﻿USE sofia;
DROP TABLE IF EXISTS sofia.ben2006_vpl;
CREATE TABLE ben2006_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ben2006_vpl WRITE;
INSERT INTO ben2006_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","শুরুতে, ঈশ্বর আকাশ ও পৃথিবী সৃষ্টি করলেন| প্রথমে পৃথিবী সম্পূর্ণ শূন্য ছিল; পৃথিবীতে কিছুই ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","অন্ধকারে আবৃত ছিল জলরাশি আর ঈশ্বরের আত্মা সেই জলরাশির উপর দিয়ে ভেসে বেড়াচ্ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","তারপর ঈশ্বর বললেন, “আলো ফুটুক!” তখনই আলো ফুটতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","আলো দেখে ঈশ্বর বুঝলেন, আলো ভাল| তখন ঈশ্বর অন্ধকার থেকে আলোকে পৃথক করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ঈশ্বর আলোর নাম দিলেন, “দিন” এবং অন্ধকারের নাম দিলেন “রাত্রি|” সন্ধ্যা হল এবং সেখানে সকাল হল| এই হল প্রথম দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","তারপর ঈশ্বর বললেন, “জলকে দুভাগ করবার জন্য আকাশমণ্ডলের ব্যবস্থা হোক্|” ");
INSERT INTO ben2006_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","তাই ঈশ্বর আকাশমণ্ডলের সৃষ্টি করে জলকে পৃথক করলেন| এক ভাগ জল আকাশমণ্ডলের উপরে আর অন্য ভাগ জল আকাশমণ্ডলের নীচে থাকল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ঈশ্বর আকাশমণ্ডলের নাম দিলেন “আকাশ|” সন্ধ্যা হল আর তারপর সকাল হল| এটা হল দ্বিতীয় দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","তারপর ঈশ্বর বললেন, “আকাশের নীচের জল এক জায়গায় জমা হোক্ যাতে শুকনো ডাঙা দেখা যায়|” এবং তা-ই হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ঈশ্বর শুকনো জমির নাম দিলেন, “পৃথিবী” এবং এক জায়গায় জমা জলের নাম দিলেন, “মহাসাগর|” ঈশ্বর দেখলেন ব্যবস্থাটা ভাল হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","তখন ঈশ্বর বললেন, “পৃথিবীতে ঘাস হোক্, শস্যদায়ী গাছ ও ফলের গাছপালা হোক্| ফলের গাছগুলিতে ফল আর ফলের ভেতরে বীজ হোক্| প্রত্যেক উদ্ভিদ আপন আপন জাতের বীজ সৃষ্টি করুক| এইসব গাছপালা পৃথিবীতে বেড়ে উঠুক|” আর তাই-ই হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","পৃথিবীতে ঘাস আর শস্যদায়ী উদ্ভিদ উৎপন্ন হল| আবার ফলদায়ী গাছপালাও হল, ফলের ভেতরে বীজ হল| প্রত্যেক উদ্ভিদ আপন আপন জাতের বীজ সৃষ্টি করল এবং ঈশ্বর দেখলেন ব্যবস্থাটা ভাল হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","সন্ধ্যা হল এবং সকাল হল| এভাবে হল তৃতীয় দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","তারপর ঈশ্বর বললেন, “আকাশে আলো ফুটুক| এই আলো দিন থেকে রাত্রিকে পৃথক করবে| এই আলোগুলি বিশেষ সভা শুরু করার বিশেষ বিশেষ সংকেত হিসেবে ব্যবহৃত হবে| আর দিন ও বছর বোঝাবার জন্য এই আলোগুলি ব্যবহৃত হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","পৃথিবীতে আলো দেওয়ার জন্য এই আলোগুলি আকাশে থাকবে|” এবং তা-ই হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","তখন ঈশ্বর দুটি মহাজ্যোতি বানালেন| ঈশ্বর বড়টি বানালেন দিনের বেলা রাজত্ব করার জন্য আর ছোটটি বানালেন রাত্রিবেলা রাজত্ব করার জন্য| ঈশ্বর তারকারাজিও সৃষ্টি করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","পৃথিবীকে আলো দেওয়ার জন্য ঈশ্বর এই আলোগুলিকে আকাশে স্থাপন করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","দিন ও রাত্রিকে কর্তৃত্ত্ব দেবার জন্য ঈশ্বর এই আলোগুলিকে আকাশে সাজালেন| এই আলোগুলি আলো আর অন্ধকারকে পৃথক করে দিল এবং ঈশ্বর দেখলেন ব্যবস্থাটা ভাল হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","সন্ধ্যা হল এবং সকাল হল| এভাবে চতুর্থ দিন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","তারপর ঈশ্বর বললেন, “বহু প্রকার জীবন্ত প্রাণীতে জল পূর্ণ হোক্ আর পৃথিবীর ওপরে আকাশে ওড়বার জন্য বহু পাখী হোক্|” ");
INSERT INTO ben2006_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","সুতরাং ঈশ্বর বড় বড় জলজন্তু এবং জলে বিচরণ করবে এমন সমস্ত প্রাণী সৃষ্টি করলেন| অনেক প্রকার সামুদ্রিক জীব রয়েছে এবং সে সবই ঈশ্বরের সৃষ্টি| যত রকম পাখী আকাশে ওড়ে সেইসবও ঈশ্বর বানালেন| এবং ঈশ্বর দেখলেন ব্যবস্থাটি ভাল হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ঈশ্বর এই সমস্ত প্রাণীদের আশীর্বাদ করলেন| ঈশ্বর সামুদ্রিক প্রাণীদের সংখ্যাবৃদ্ধি করে সমুদ্র ভরিয়ে তুলতে বললেন| ঈশ্বর পৃথিবীতে পাখীদের সংখ্যাবৃদ্ধি করতে বললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","সন্ধ্যা হয়ে গেল এবং তারপর সকাল হল| এভাবে পঞ্চম দিন কেটে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","তারপর ঈশ্বর বললেন, “নানারকম প্রাণী পৃথিবীতে উৎপন্ন হোক্| নানারকম বড় আকারের জন্তু জানোয়ার আর বুকে হেঁটে চলার নানারকম ছোট প্রাণী হোক্ এবং প্রচুর সংখ্যায় তাদের সংখ্যাবৃদ্ধি হোক্|” তখন যেমন তিনি বললেন সব কিছু সম্পন্ন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","সুতরাং ঈশ্বর সব রকম জন্তু জানোয়ার তেমনভাবে তৈরী করলেন| বন্য জন্তু, পোষ্য জন্তু আর বুকে হাঁটার সবরকমের ছোট ছোট প্রাণী ঈশ্বর বানালেন এবং ঈশ্বর দেখলেন প্রতিটি জিনিসই বেশ ভালো হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","তখন ঈশ্বর বললেন, “এখন এস, আমরা মানুষ সৃষ্টি করি| আমাদের আদলে আমরা মানুষ সৃষ্টি করব| মানুষ হবে ঠিক আমাদের মত| তারা সমুদ্রের সমস্ত মাছের ওপরে আর আকাশের সমস্ত পাখীর ওপরে কর্তৃত্ত্ব করবে| তারা পৃথিবীর সমস্ত বড় জানোয়ার আর বুকে হাঁটা সমস্ত ছোট প্রাণীর উপরে কর্তৃত্ত্ব করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","তাই ঈশ্বর নিজের মতোই মানুষ সৃষ্টি করলেন| মানুষ হল তাঁর ছাঁচে গড়া জীব| ঈশ্বর তাদের পুরুষ ও স্ত্রীরূপে সৃষ্টি করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ঈশ্বর তাদের আশীর্বাদ করে বললেন, “তোমাদের বহু সন্তানসন্ততি হোক্| মানুষে মানুষে পৃথিবী পরিপূর্ণ করো এবং তোমরা পৃথিবীর নিয়ন্ত্রণের ভার নাও, সমুদ্রে মাছেদের এবং বাতাসে পাখিদের শাসন করো| মাটির ওপর যা কিছু নড়েচড়ে, যাবতীয় প্রাণীকে তোমরা শাসন করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ঈশ্বর বললেন, “আমি তোমাদের শস্যদায়ী সমস্ত গাছ ও সমস্ত ফলদায়ী গাছপালা দিচ্ছি| ঐসব গাছ বীজযুক্ত ফল উৎ‌পাদন করে| এই সমস্ত শস্য ও ফল হবে তোমাদের খাদ্য| ");
INSERT INTO ben2006_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","এবং জানোয়ারদের সমস্ত সবুজ গাছপালা দিচ্ছি| তাদের খাদ্য হবে সবুজ গাছপালা| পৃথিবীর সমস্ত জন্তু জানোয়ার, আকাশের সমস্ত পাখি এবং মাটির উপরে বুকে হাঁটে যেসব কীট সবাই ঐ খাদ্য খাবে|” এবং এই সব কিছুই সম্পন্ন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ঈশ্বর যা কিছু সৃষ্টি করেছেন সেসব কিছু দেখলেন এবং ঈশ্বর দেখলেন সমস্ত সৃষ্টিই খুব ভাল হয়েছে| সন্ধ্যা হল, তারপর সকাল হল| এভাবে ষষ্ঠ দিন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","এইভাবে পৃথিবী, আকাশ এবং তাদের আভ্যন্তরীণ যাবতীয় জিনিস সম্পূর্ণ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","যে কাজ ঈশ্বর শুরু করেছিলেন তা শেষ করে সপ্তম দিনে তিনি বিশ্রাম নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","সপ্তম দিনটিকে আশীর্বাদ করে ঈশ্বর সেটিকে পবিত্র দিনে পরিণত করলেন| দিনটিকে ঈশ্বর এক বিশেষ দিনে পরিণত করলেন কারণ ঐ দিনটিতে পৃথিবী সৃষ্টির সমস্ত কাজ থেকে তিনি বিশ্রাম নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","এই হল আকাশ ও পৃথিবীর ইতিহাস| ঈশ্বর যখন পৃথিবী ও আকাশ সৃষ্টি করেছিলেন, তখন যা কিছু ঘটেছিল এটা তারই গল্প| ");
INSERT INTO ben2006_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","পৃথিবীতে তখন কোন গাছপালা ছিল না| মাঠে তখন কিছুই জন্মাতো না| কারণ প্রভু তখনও পৃথিবীতে বৃষ্টি পাঠান নি এবং ক্ষেতে চাষবাস করার জন্য তখন কেউ ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","পৃথিবী থেকে জল উঠে চারপাশের জমিতে ছড়িয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","তখন প্রভু ঈশ্বর মাটি থেকে ধুলো তুলে নিয়ে একজন মানুষ তৈরী করলেন এবং সেই মানুষের নাকে ফুঁ দিয়ে প্রাণবায়ু প্রবেশ করালেন এবং মানুষটি জীবন্ত হয়ে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","তখন প্রভু ঈশ্বর পূর্বদিকে একটি বাগান বানালেন আর সেই বাগানটির নাম দিলেন এদন এবং প্রভু ঈশ্বর তাঁর সৃষ্টি করা মানুষটিকে সেই বাগানে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","এবং সেই বাগানে প্রভু ঈশ্বর সবরকমের সুন্দর বৃক্ষ এবং খাদ্যোপযোগী ফল দেয় এমন প্রতিটি বৃক্ষ রোপণ করলেন| বাগানের মাঝখানটিতে প্রভু ঈশ্বর রোপণ করলেন জীবন বৃক্ষটি যা ভাল এবং মন্দ বিষয়ে জ্ঞান দেয়| ");
INSERT INTO ben2006_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","এদন হতে এক নদী প্রবাহিত হয়ে সেই বাগান জলসিক্ত করল| তারপর সেই নদী বিভক্ত হয়ে চারটি ছোট ছোট ধারায় পরিণত হল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","প্রথম ধারাটির নাম পীশোন| এই নদী ধারা পুরো হবীলা দেশটিকে ঘিরে প্রবাহিত| ");
INSERT INTO ben2006_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(সে দেশে সোনা রয়েছে আর তা উঁচু মানের| এছাড়া এই দেশে গন্ধদ্রব্য, গুগ্গুল আর মূল্যবান গোমেদকমণি পাওয়া যায়|) ");
INSERT INTO ben2006_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দ্বিতীয় নদীর নাম গীহোন, এই নদীটি সমস্ত কুশ দেশটিকে ঘিরে প্রবাহিত| ");
INSERT INTO ben2006_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তৃতীয় নদীটির নাম হিদ্দেকল| এই নদী অশূরিয়া দেশের পূর্ব দিকে প্রবাহিত| চতুর্থ নদীটির নাম ফরাৎ| ");
INSERT INTO ben2006_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","কৃষিকাজ আর বাগানের রক্ষণাবেক্ষণের জন্য প্রভু ঈশ্বর মানুষটিকে এদন বাগানে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","প্রভু ঈশ্বর মানুষটিকে এই আদেশ দিলেন, “বাগানের যে কোনও বৃক্ষের ফল তুমি খেতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","কিন্তু যে বৃক্ষ ভালো আর মন্দ বিষয়ে জ্ঞান দেয় সেই বৃক্ষের ফল কখনও খেও না| যদি তুমি সেই বৃক্ষের ফল খাও, তোমার মৃত্যু হবে!” ");
INSERT INTO ben2006_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","তারপরে প্রভু ঈশ্বর বললেন, “মানুষের নিঃসঙ্গ থাকা ভালো নয়| আমি ওকে সাহায্য করার জন্যে ওর মত আর একটি মানুষ তৈরী করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","প্রভু ঈশ্বর পৃথিবীর ওপরে সমস্ত পশু আর আকাশের সমস্ত পাখী তৈরী করবার জন্য মৃত্তিকার ধূলি ব্যবহার করেছিলেন| প্রভু ঈশ্বর ঐ সমস্ত পশুপাখীকে মানুষটির কাছে নিয়ে এলেন আর মানুষটি তাদের প্রত্যেকের আলাদা আলাদা নাম দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","মানুষটি সমস্ত গৃহপালিত পশু, আকাশের সমস্ত পাখীর এবং অরণ্যের সমস্ত বন্য প্রাণীর নামকরণ করল| মানুষটি অসংখ্য পশু পাখী দেখল কিন্তু সে তার যোগ্য সাহায্যকারী কাউকে দেখতে পেল না| ");
INSERT INTO ben2006_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","তখন প্রভু ঈশ্বর সেই মানুষঢিকে খুব গভীর ঘুমে আচ্ছন্ন করলেন| মানুষটি যখন ঘুমোচ্ছিল তখন প্রভু ঈশ্বর তার পাঁজরের একটা হাড় বার করে নিলেন| তারপর প্রভু ঈশ্বর যেখান থেকে হাড়টি বার করেছিলেন সেখানটা চামড়া দিয়ে ঢেকে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","প্রভু ঈশ্বর মানুষটির পাঁজরের সেই হাড় দিয়ে তৈরি করলেন একজন স্ত্রী| তখন সেই স্ত্রীকে প্রভু ঈশ্বর মানুষটির সামনে নিয়ে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","এবং সেই মানুষটি বলল, “অবশেষে আমার সদৃশ একজন হল| আমার পাঁজরা থেকে তার হাড়, আর আমার শরীর থেকে তার দেহ তৈরী হয়েছে| যেহেতু নর থেকে তার সৃষ্টি হয়েছে, সেহেতু “নারী” বলে এর পরিচয় হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","এইজন্য পুরুষ পিতামাতাকে ত্যাগ করে স্ত্রীর সঙ্গে মিলিত হয় এবং এইভাবে দুজনে এক হয়ে যায়| ");
INSERT INTO ben2006_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","তখন নরনারী উলঙ্গ ছিল, কিন্তু সেজন্যে তাদের কোন লজ্জাবোধ ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","প্রভু ঈশ্বর যত রকম বন্য প্রাণী সৃষ্টি করেছিলেন সে সবগুলোর মধ্যে সাপ সবচেয়ে চালাক ছিল| সাপ সেই নারীর সঙ্গে একটা চালাকি করতে চাইল| একদিন সাপটা সেই নারীকে জিজ্ঞেস করল, “নারী, ঈশ্বর কি বাগানের কোনও গাছের ফল না খেতে সত্যিই আদেশ দিয়েছেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","তখন নারী সাপটাকে বলল, “না! ঈশ্বর তা বলেন নি! বাগানের সব গাছগুলো থেকে আমরা ফল খেতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","শুধু একটি গাছ আছে যার ফল কিছুতেই খেতে পারি না| ঈশ্বর আমাদের বলেছিলেন, ‘বাগানের মাঝখানে যে গাছটা আছে, তার ফল কোনমতেই খাবে না| এমন কি ঐ গাছটা ছোঁবেও না — ছুঁলেই মরবে|’” ");
INSERT INTO ben2006_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","কিন্তু সাপটা নারীকে বলল, “না, মরবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ঈশ্বর জানেন, যদি তোমরা ঐ গাছের ফল খাও তাহলে তোমাদের ভালো আর মন্দের জ্ঞান হবে| আর তোমরা তখন ঈশ্বরের মত হয়ে যাবে!” ");
INSERT INTO ben2006_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","সেই নারী দেখল গাছটা সুন্দর এবং এর ফল সুস্বাদু, আর এই ভেবে সে উত্তেজিত হল যে ঐ গাছ তাকে জ্ঞান দেবে| তাই নারী গাছটার থেকে ফল নিয়ে খেল| তার স্বামী সেখানেই ছিল, তাই সে স্বামীকেও ফলের একটা টুকরো দিল আর তার স্বামীও সেটা খেল| ");
INSERT INTO ben2006_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","তখন সেই নারী ও পুরুষ দুজনের মধ্যেই একটা পরিবর্তন ঘটল| যেন তাদের চোখ খুলে গেল আর তারা সব কিছু অন্যভাবে দেখতে শুরু করল| তারা দেখল তাদের কোনও জামাকাপড় নেই| তারা উলঙ্গ| তাই তারা কয়েকটা ডুমুরের পাতা জোগাড় করে সেগুলোকে জুড়ে জুড়ে সেলাই করল এবং সেগুলোকে পোশাক হিসেবে পরল| ");
INSERT INTO ben2006_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","প্রভু ঈশ্বর বিকেল বেলা বাগানে বেড়াচ্ছিলেন| তাঁর পায়ের শব্দ শুনে সেই পুরুষ ও নারী বাগানে গাছগুলির মাঝখানে গিয়ে লুকালো| ");
INSERT INTO ben2006_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","কিন্তু প্রভু ঈশ্বর পুরুষটিকে ডাকলেন, “তুমি কোথায়?” ");
INSERT INTO ben2006_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","পুরুষটি বলল, “আপনার পায়ের শব্দ শুনে ভয় পেলাম| আমি যে উলঙ্গ| তাই আমি লুকিয়ে আছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","প্রভু ঈশ্বর মানুষটিকে বললেন, “কে বলল যে তুমি উলঙ্গ? তোমার লজ্জা করছে কেন? যে গাছটার ফল খেতে আমি বারণ করেছিলাম তুমি কি সেই বিশেষ গাছের ফল খেয়েছ?” ");
INSERT INTO ben2006_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","সেই পুরুষ বলল, “আমার জন্য যে নারী আপনি তৈরী করেছিলেন সেই নারী গাছটা থেকে আমায় ফল দিয়েছিল, তাই আমি সেটা খেয়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","তখন প্রভু ঈশ্বর সেই নারীকে বললেন, “তুমি এ কি করেছ?” সেই নারী বলল, “সাপটা আমার সঙ্গে চালাকি করেছে| সাপটা আমায় ভুলিযে দিল আর আমিও ফলটা খেয়ে ফেললাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","সুতরাং প্রভু ঈশ্বর সাপটাকে বললেন, “তুমি ভীষণ খারাপ কাজ করেছ; তার ফলে তোমার খারাপ হবে| অন্যান্য পশুর চেয়ে তোমার পক্ষে বেশী খারাপ হবে| সমস্ত জীবন তুমি বুকে হেঁটে চলবে আর মাটির ধুলো খাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","তোমার এবং নারীর মধ্যে আমি শত্রুতা সৃষ্টি করব এবং তার সন্তানসন্ততি এবং তোমার সন্তান সন্ততির মধ্যে এই শত্রুতা বয়ে চলবে| তুমি কামড় দেবে তার সন্তানের পায়ে কিন্তু সে তোমার মাথা চূর্ণ করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","তারপর প্রভু ঈশ্বর নারীকে বললেন, “তুমি যখন গর্ভবতী হবে, আমি সেই দশাটাকে দুঃসহ করে তুলব, তুমি অসহ্য ব্যথায সন্তানের জন্ম দেবে| তুমি তোমার স্বামীকে আকুলভাবে কামনা করবে কিন্তু সে তোমার উপরে কর্তৃত্ত্ব করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","তারপর প্রভু ঈশ্বর পুরুষকে বললেন, “আমি তোমায় ঐ গাছের ফল খেতে বারণ করেছিলাম| তবু তুমি নারীর কথা শুনে নিষিদ্ধ গাছের ফল খেয়েছ| তাই তোমার কারণে আমি এই ভূমিকে শাপ দেব| ভূমি তোমাদের যে খাদ্য দেবে তার জন্যে এখন থেকে সারাজীবন তোমায় অতি কঠিন পরিশ্রম করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ভূমি তোমার জন্য কাঁটাঝোপ জন্ম দেবে এবং তোমাকে বুনো গাছপালা খেতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","তোমার খাদ্যের জন্যে তুমি কঠোর পরিশ্রম করবে যে পর্যন্ত না মুখ ঘামে ভরে যায়| তুমি মরণ পর্যন্ত পরিশ্রম করবে, তারপর পুনরায় ধূলি হয়ে যাবে| আমি ধুলি থেকে তোমায় সৃষ্টি করেছি এবং যখন তোমার মৃত্যু হবে পুনরায় তুমি ধূলিতে পরিণত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","আদম তার স্ত্রীর নাম রাখল হবা, কারণ সে সমস্ত জীবিত মানুষের জননী হল| ");
INSERT INTO ben2006_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","প্রভু ঈশ্বর পশুর চামড়া দিয়ে আদম ও হবার জন্য পোশাক বানিয়ে তাদের পরিয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","প্রভু ঈশ্বর বললেন, “দেখ, ওরা এখন ভালো আর মন্দ বিষয়ে জেনে আমাদের মত হয়ে গেছে| এখন মানুষটা জীবনবৃক্ষের ফল পেড়েও খেতে পারে| আর তা যদি খায় তাহলে ওরা চিরজীবি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","সুতরাং প্রভু ঈশ্বর মানুষকে এদন উদ্যান ত্যাগ করতে বাধ্য করলেন| যে ভুমি থেকে আদমকে তৈরী করা হয়েছিল, বাধ্য হয়ে সে সেই ভুমিতেই কাজ করতে থাকল| ");
INSERT INTO ben2006_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","প্রভু ঈশ্বর মানুষকে ঐ উদ্যান থেকে তাড়িয়ে দিলেন| প্রভু করূব দূতদের উদ্যানের প্রবেশ পথে পাহারায় রাখলেন এবং তিনি আগুনের একটা তরবারিকেও সেখানে রাখলেন| জীবনবৃক্ষের কাছে যাবার পথটি পাহারা দেবার জন্য ঐ তরবারিটি চারদিকে জ্বলজ্বল করছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","আদম ও তার স্ত্রী হবার মধ্যে যৌন সম্পর্ক হল| হবা একটি শিশুর জন্ম দিল| শিশুটির নাম রাখা হল কয়িন| হবা বলল, “প্রভুর সহায়তায় আমি একটি মানুষের রূপ দিয়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","পরে সে আর একটি শিশু প্রসব করল| এই শিশুটি হল কয়িনের ভাই হেবল| হেবল হল মেষপালক আর কয়িন হল কৃষক| ");
INSERT INTO ben2006_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","ফসল কাটার সময় প্রভুর জন্যে কয়িন কিছু উপহার নিয়ে এল| কয়িন ক্ষেতে যা ফলিয়েছিল তার থেকে কিছু ফসল নিয়ে এল| আর হেবল প্রভুর জন্য তার মেষপাল থেকে বাছাই করা সেরা মেষগুলোর সেরা অংশ নিয়ে এল| প্রভু হেবল ও তার উপহার গ্রহণ করলেন, ");
INSERT INTO ben2006_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","কিন্তু প্রভু কয়িন ও তার উপহার প্রত্যাখ্যান করলেন| এতে কয়িনের ভীষণ দুঃখ আর রাগ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","প্রভু কয়িনকে জিজ্ঞেস করলেন, “তুমি রাগ করছ কেন? তোমার মুখ বিষন্ন কেন? ");
INSERT INTO ben2006_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","তুমি যদি ভাল কাজ কর, তখন আমি তোমায় গ্রহণ করব| কিন্তু যদি অন্যায় কাজ করো সে পাপ থাকবে তোমার জীবনে| তোমার পাপ তোমাকে আয়ত্তে রাখতে চায়, কিন্তু তোমাকেই সেই পাপকে আয়ত্তে রাখতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","কয়িন তার ভাই হেবলকে বলল, “চলো, মাঠে যাওয়া যাক|” তখন কয়িন আর হেবল বাইরে মাঠে গেল| তখন কয়িন তার ভাই হেবলের উপর ঝাঁপিয়ে পড়ে তাকে হত্যা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","পরে প্রভু কয়িনকে জিজ্ঞেস করলেন, “তোমার ভাই হেবল কোথায়?” কয়িন বলল, “আমি জানি না| ভাইয়ের উপর নজরদারি করা কি আমার কাজ?” ");
INSERT INTO ben2006_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","11","তখন প্রভু বললেন, “তুমি কি করেছ? তোমার ভাইকে তুমি হত্যা করেছ? তার রক্ত মাটির নীচে থেকে আমার উদ্দেশ্যে চিৎকার করছে| তুমি তোমার ভাইকে হত্যা করেছ এবং তোমার হাত থেকে তার রক্ত নেওয়ার জন্যে পৃথিবী বিদীর্ণ হয়েছে| তাই এখন, আমি এই ভূমিকে অভিশাপ দেব| ");
INSERT INTO ben2006_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","অতীতে, তুমি গাছপালা লাগিয়েছ এবং তোমার গাছপালার ভালই বাড়বৃদ্ধি হয়েছে| কিন্তু এখন তুমি গাছপালা লাগাবে এবং মাটি তোমার গাছপালা বাড়তে আর সাহায্য করবে না| এই পৃথিবীতে তোমার কোনও বাড়ী থাকবে না, তুমি এক জায়গা থেকে আর এক জায়গায় ঘুরে ঘুরে বেড়াবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","তখন কয়িন বলল, “এই শাস্তি আমার পক্ষে খুব বেশী! ");
INSERT INTO ben2006_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","দেখ, তুমি আমায় নির্বাসনে যেতে বাধ্য করছ| আমি তোমার কাছেও আসতে পারব না, তোমার সঙ্গে আর আমার দেখাও হবে না| আমার কোনও ঘরবাড়ী থাকবে না| আমি পৃথিবী জুড়ে এক জায়গা থেকে আর এক জায়গায় ঘুরে বেড়াতে বাধ্য হব এবং আমায় যে দেখবে সেই হত্যা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","তখন প্রভু কয়িনকে বললেন, “না, আমি তা ঘটতে দেব না| তোমায় যদি কেউ হত্যা করে তাহলে তাকে আরও বেশী শাস্তি দেব|” তখন প্রভু কয়িনের গায়ে একটা চিহ্ন দিলেন যাতে কেউ তাকে হত্যা না করে| ");
INSERT INTO ben2006_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","কয়িন প্রভুর কাছ থেকে চলে এল এবং এদনের পূর্বদিকে নোদ নামক এক দেশে বাস করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","কয়িনের সঙ্গে যৌন সম্পর্কের ফলে তার স্ত্রী একটি পুত্রের জন্ম দিল| তার নাম রাখা হল হনোক| কয়িন একটি নগর পত্তন করে তার নামও পুত্রের নামে রাখল হনোক| ");
INSERT INTO ben2006_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনোকের ইরদ নামে একটি পুত্র হল| ইরদের পুত্রের নাম মহূয়ায়েল| আর তার পুত্রের নাম মথুশায়েল| আর তার পুত্রের নাম লেমক| ");
INSERT INTO ben2006_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","লেমকের দুজন স্ত্রী ছিল| একজনের নাম আদা, আর একজনের নাম সিল্লা| ");
INSERT INTO ben2006_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","আদার গর্ভে জন্ম হল যাবলের| যারা তাঁবুতে বাস করে এবং পশুপালন করে সেই জাতির জনক হল যুবল| ");
INSERT INTO ben2006_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","আদার অন্য পুত্রের নাম যুবল| তার সন্তানসন্ততি থেকে যে জাতির সৃষ্টি হল তারা বীণা ও বাঁশি বাজায়| ");
INSERT INTO ben2006_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","লেমকের অন্য স্ত্রী সিল্লা এক পুত্রের ও এক কন্যার জন্ম দিল| পুত্রের নাম তুবল কয়িন আর কন্যার নাম নয়মা| তুবল কয়িনের সন্তানসন্ততি পিতল ও লোহার কাজে দক্ষ| ");
INSERT INTO ben2006_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","লেমক তার দুই স্ত্রীর উদ্দেশ্যে বলল, “আদা আর সিল্লা, এদিকে কান দাও| লেমকের স্ত্রীরা, আমার কথা শোনো! একটা লোক আমায় মেরেছিল, তাই তাকে আমি হত্যা করেছি| একজন তরুণ আমায় আঘাত করেছিল, তার বদলে আমি তাকে হত্যা করেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","কয়িনকে হত্যার শাস্তি ছিল সাত গুণ, লেমককে হত্যার শাস্তি সাতাত্তর গুণ বেশী!” ");
INSERT INTO ben2006_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","আদমের সঙ্গে যৌন সম্পর্কের ফলে হবা আর একটি পুত্রের জন্ম দিল| তারা তার নাম রাখল শেথ| হবা বলল, “ঈশ্বর আমায় আর একটি পুত্র দিয়েছেন| কয়িন হেবলকে মেরে ফেলল, কিন্তু আমার এখন শেথ আছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","শেথেরও একটি পুত্র হল| সে তার নাম রাখল ইনোশ| সেই সময় লোকেরা প্রভুর কাছে প্রার্থনা করতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","এই বই হল আদম পরিবারের বিষয় নিয়ে| ঈশ্বর নিজের ছাঁচে মানুষকে সৃষ্টি করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ঈশ্বর মানুষকে পুরুষ ও স্ত্রীরূপে সৃষ্টি করেছিলেন| এবং সেই সৃষ্টির দিনে ঈশ্বর আশীর্বাদ করে তাদের নাম দিলেন “আদম|” ");
INSERT INTO ben2006_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","আদমের যখন 130 বছর বয়স তখন তার আর একটি পুত্র হল| পুত্রটিকে দেখতে হুবহু আদমের মতো| আদম তার নাম রাখলেন শেথ| ");
INSERT INTO ben2006_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","শেথের জন্মের পর 800 বছর আদম বেঁচেছিলেন| এই সময়ের মধ্যে আদমের আরও পুত্রকন্যা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","সুতরাং আদম মোট 930 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হল| ");
INSERT INTO ben2006_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","শেথের যখন 105 বছর বয়স তখন তাঁর একটি পুত্র হয়| তার নাম রাখা হয় ইনোশ| ");
INSERT INTO ben2006_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ইনোশের জন্মের পরে শেথ 807 বছর বেঁচেছিলেন| ইতিমধ্যে শেথের আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","সুতরাং শেথ বেঁচেছিলেন মোট 912 বছর| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ইনোশের যখন 90 বছর বয়স তখন তাঁর কৈনন নামে একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","কৈননের জন্মের পর ইনোশ 815 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","সুতরাং ইনোশ মোট 905 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","কৈননের 70 বছর বয়সে তাঁর মহললেল নামে একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","মহললেলের জন্মের পর কৈনন 840 বছর বেঁচেছিলেন| ইতিমধ্যে কৈননের আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","সুতরাং কৈনন মোট 910 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","মহললেলের যখন 65 বছর তখন তাঁর যেরদ নামে একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","যেরদের জন্মের পর মহললেল 830 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","সুতরাং মহললেল মোট 895 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","যেরদের যখন 162 বছর বয়স তখন তাঁর হনোক নামে একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","হনোকের জন্মের পর যেরদ 800 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়. ");
INSERT INTO ben2006_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","সুতরাং যেরদ মোট 962 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","হনোকের যখন 65 বছর বয়স তখন মথূশেলহ নামে তাঁর একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","মথূশেলহর জন্মের পর হনোক আরও 300 বছর ঈশ্বরের সঙ্গে পদচারণা করেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","সুতরাং হনোক মোট 365 বছর বেঁচেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","একদিন হনোক ঈশ্বরের সঙ্গে পদচারণা করতে করতে অদৃশ্য হয়ে গেলেন| ঈশ্বর তাঁকে নিয়ে নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","মথূশেলহর যখন 187 বছর বয়স তখন তাঁর লেমক নামে একটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","লেমকের জন্মের পর মথূশেলহ 782 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","সুতরাং মথূশেলহ মোট 969 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","লেমকের যখন 182 বছর বয়স তখন তাঁর একটি পুত্র হল| ");
INSERT INTO ben2006_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","লেমক পুত্রের নাম রাখলেন নোহ| তিনি বললেন, “ঈশ্বর ভূমিকে অভিশাপ দিয়েছেন বলে কৃষকরূপে আমাদের কঠোর পরিশ্রম করতে হয়| কিন্তু নোহ আমাদের বিশ্রাম দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","নোহের জন্মের পর লেমক 595 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","সুতরাং লেমক মোট 777 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","নোহর 500 বছর বয়সে শেম, হাম এবং যেফৎ নামে তিনটি পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","4","পৃথিবীতে মানুষের সংখ্যা ক্রমশঃ বেড়ে চলল| অনেকের অনেক কন্যা হল| ঈশ্বরের পুত্রেরা দেখল যে তারা সুন্দরী| সুতরাং ঈশ্বরের পুত্রেরা যার যাকে পছন্দ সে তাকে বিয়ে করল| এই নারীরা সন্তানের জন্ম দিল| তখন প্রভু বললেন, “মানুষ নেহাতই রক্তমাংসের জীব মাত্র| ওদের দ্বারা আমি আমার আত্মাকে চিরকাল পীড়িত হতে দেব না| আমি ওদের 120 বছর করে আয়ু দেব|” সেই সময় এবং পরবর্তীকালে পৃথিবীতে নেফিলিম জাতীয় মানুষরা বাস করত| প্রাচীনকাল থেকেই নেফিলিমরা মহাবীররূপে বিখ্যাত ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","প্রভু দেখলেন যে পৃথিবীতে লোকে শুধু মন্দ কাজই করছে| তিনি দেখলেন যে লোক সারাক্ষণ মন্দ জিনিসের কথাই চিন্তা করছে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","পৃথিবীতে মানুষ সৃষ্টি করার জন্যে প্রভুর অনুশোচনা হল এবং তাঁর হৃদয় বেদনায় পূর্ণ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","তাই তিনি বললেন, “পৃথিবীতে যত মানুষ সৃষ্টি করেছি সবাইকে আমি ধ্বংস করব| প্রত্যেক মানুষ, প্রত্যেক জানোয়ার এবং পৃথিবীর উপরে যা কিছু চলে ফিরে বেড়ায় সব কিছুকে আমি ধ্বংস করব| বাতাসে যত পাখী ওড়ে সেগুলোকেও আমি ধ্বংস করব| কেন? কারণ এই সবকিছু সৃষ্টি করেছি বলে আমি দুঃখিত|” ");
INSERT INTO ben2006_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","পৃথিবীতে শুধু একজন মানুষের প্রতি প্রভু সন্তুষ্ট ছিলেন, সে হল নোহ| ");
INSERT INTO ben2006_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","এই হল নোহের পরিবারের বৃত্তান্ত| নোহ তাঁর প্রজন্মের একজন ভাল ও সৎ মানুষ ছিলেন এবং তিনি সর্বদা ঈশ্বরকে অনুসরণ করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","নোহের তিন পুত্র ছিল: শেম, হাম আর যেফৎ| ");
INSERT INTO ben2006_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","ঈশ্বর নীচে পৃথিবীর দিকে দৃষ্টিপাত করলেন এবং দেখলেন যে মানুষ তা ধ্বংস করেছে| সর্বত্র হিংসাত্মক ক্রিয়াকলাপ| মানুষ দুষ্ট এবং নিষ্ঠুর হয়ে গেছে এবং নিজেদের জীবন নষ্ট করেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","তাই ঈশ্বর নোহকে বললেন, “সমস্ত লোক ক্রোধ আর হিংসা দিয়ে পৃথিবী পরিপূর্ণ করেছে| তাই আমি সমস্ত জীবন্ত প্রাণীদের ধ্বংস করব| পৃথিবী থেকে সব কিছু মুছে ফেলব| ");
INSERT INTO ben2006_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","গোফর কাঠ দিয়ে একটা নৌকা বানাও| নৌকোর ভেতরে অনেকগুলি কক্ষ তৈরী করবে এবং কাঠ সংরক্ষণের জন্য বাইরে আলকাতরা লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“নৌকোটা 300 হাত লম্বা, 50 হাত চওড়া আর 30 হাত উঁচু করে তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ছাদের থেকে প্রায় 18 ইঞ্চি নীচে একটা জানালা তৈরী করবে| নৌকোর পাশের দিকে একটা দরজা তৈরী করবে| উপরের তলা, মাঝের তলা আর নীচের তলা–এইভাবে নৌকোর তিনটে তলা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“এবার যা বলছি, মন দিয়ে শোন| পৃথিবীতে আমি এক মহাপ্লাবন ঘটাবো| আকাশের নীচের যত জীবন্ত প্রাণী আছে, সব ধ্বংস করবো| পৃথিবীর সমস্ত কিছুর মৃত্যু হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","কিন্তু তোমার সঙ্গে আমার একটা বিশেষ চুক্তি হবে| তুমি, তোমার স্ত্রী, তোমার পুত্ররা, তোমার পুত্রবধূরা–তোমরা সবাই ঐ নৌকোতে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","আর পৃথিবীর সমস্ত প্রাণীর থেকে তুমি একটি করে পুরুষ আর একটি করে স্ত্রী বেছে নেবে| তুমি অবশ্যই তাদের নৌকোতে তুলে নেবে এবং তোমাদের সঙ্গে তাদেরও বাঁচিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","সমস্ত রকম পাখীর এক জোড়া, সমস্ত রকম পশুর এক জোড়া এবং মাটিতে বুকে হেঁটে চলে সেরকম সব প্রাণীর এক-এক জোড়া খুঁজে বার করো| পৃথিবীতে যত রকম জীবজন্তু আছে সে সব গুলোর এক জোড়া স্ত্রী পুরুষ জোগাড় করে তোমার নৌকোতে তাদের বাঁচিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","তোমাদের জন্য আর অন্যান্য পশুপাখীর জন্য সমস্ত রকম খাবারও অবশ্যই জোগাড় করে রাখবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","এই সমস্ত কিছুই নোহ করলেন| ঈশ্বর যেমন আজ্ঞা দিয়েছিলেন, নোহ সবকিছু ঠিক সেইভাবেই পালন করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","তখন প্রভু নোহকে বললেন, “তুমি যে একজন সৎ‌ মানুষ তা আমি লক্ষ্য করেছি| এমনকি এই যুগের দুষ্ট লোকদের মধ্যেও তুমি নিজেকে সৎ‌ রেখেছ| সুতরাং তোমার পরিবারের সবাইকে নিয়ে তুমি গিয়ে নৌকোতে ওঠো| ");
INSERT INTO ben2006_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","পৃথিবীর সমস্ত শুচি পশুপাখীর সাত সাত জোড়া এবং অন্যান্য প্রত্যেক পশুর এক এক জোড়া নাও| এই সমস্ত পশুপাখীদের তুমি ঐ নৌকোতে তোমার সঙ্গে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","সমস্ত রকম পাখীর সাতটি করে জোড়া নেবে| এর ফলে পৃথিবীর অন্যান্য সমস্ত পশুপাখী আমি ধ্বংস করে ফেলার পরেও এইসব পশুপাখী সম্পূর্ণভাবে বংশলোপের হাত থেকে রক্ষা পাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","এখন থেকে ঠিক সাতদিন পরে আমি পৃথিবীতে প্রবল বর্ষণ ঘটাবো| 40 দিন 40 রাত ধরে বৃষ্টি হবে| আমি পৃথিবীর সমস্ত জীবন্ত প্রাণী ধ্বংস করে দেব| যা কিছু আমি সৃষ্টি করেছি, সব নিশ্চিহ্ন হয়ে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","প্রভু যা যা করতে বললেন, নোহ সে সমস্তই করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","যখন সেই বর্ষন শুরু হল তখন নোহের বয়স 600 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","নোহ এবং তাঁর পরিবার মহাপ্লাবন থেকে পরিত্রাণের জন্যে নৌকোতে প্রবেশ করলেন| নোহের সঙ্গে তাঁর স্ত্রী, তাঁর পুত্ররা ও পুত্রবধূরা সবাই নৌকোতে ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","সমস্ত শুচি ও অশুচি পশুপাখী এবং মাটিতে যারা বুকে হেঁটে চলে সেইসব প্রাণী ");
INSERT INTO ben2006_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","নোহের সঙ্গে নৌকোতে গিয়ে উঠল| ঈশ্বর যেমনটি আদেশ করেছিলেন ঠিক তেমনভাবে স্ত্রী ও পুরুষে জুটি বেঁধে সমস্ত পশুপাখী নৌকোতে চড়লে, ");
INSERT INTO ben2006_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","সাত দিন পরে শুরু হল প্লাবন| পৃথিবীতে শুরু হলো বর্ষা| ");
INSERT INTO ben2006_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","নোহর 600তম বছরের দ্বিতীয় মাসের 17তম দিনে সমস্ত ভূগর্ভস্থ প্রস্রবণ ফেটে বেরিয়ে এল, মাটি থেকে জল বইতে শুরু করল| ঐদিন মুষলধারে বৃষ্টি শুরু হল, বাঁধ ভেঙে গেল এবং সমস্ত পৃথিবী জলপ্লাবিত হলো| সেই একই দিনে প্রচণ্ড বেগে বৃষ্টিপাত শুরু হল যেন আকাশের সমস্ত জানালা খুলে গেল| 40 দিন 40 রাত ধরে সমানে বৃষ্টি হলো| সেই দিনটিতেই নোহ ও তাঁর স্ত্রী এবং তাঁদের তিন পুত্র শেম, হাম, যেফৎ আর তাদের তিন স্ত্রী সকলেই নৌকোয় প্রবেশ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ঐ সব মানুষ আর পৃথিবীর যাবতীয় পশুপাখী নৌকোর মধ্যে আশ্রয় নিলো| সব রকমের গৃহপালিত জন্তু এবং পৃথিবীতে যতরকমের পশুপাখী চলে ফিরে আর উড়ে বেড়ায় সবাই নৌকোর ভেতরে নিরাপদে থাকলো| ");
INSERT INTO ben2006_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","সমস্ত জন্তু জানোয়ার, পাখী ইত্যাদি নোহর সঙ্গে নৌকোতে উঠলো। প্রাণবায়ু বিশিষ্ট সমস্ত পশুপাখী নৌকাতে জোড়ায়় জোড়ায়় থাকল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ঈশ্বর যেমন আদেশ দিয়েছিলেন, নোহ সেই অনুসারে পৃথিবীর যাবতীয় প্রাণীর এক এক জোড়া নৌকোতে তুললে, প্রভু বাইরে থেকে নৌকোর দরজা বন্ধ করে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","পৃথিবীতে 40 দিন ধরে বন্যা চলল| জলের মাত্রা ক্রমশঃ উঁচু হতে লাগল আর সেই নৌকো মাটি ছেড়ে জলের উপরে ভাসতে থাকলো| ");
INSERT INTO ben2006_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","জল বাড়তেই থাকল আর নৌকো মাটি ছেড়ে অনেক উঁচুতে ভাসতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","জল এত বাড়লো যে সবচেয়ে উঁচু পর্বতগুলো পর্যন্ত ডুবে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","পর্বতগুলোর মাথা ছাপিয়ে জল বাড়তে লাগল| সবচেয়ে উঁচু পর্বতের উপরেও 20 ফুটের বেশী জল দাঁড়াল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","পৃথিবীর সমস্ত জীব মারা গেল| প্রতিটি পুরুষ ও স্ত্রী এবং পৃথিবীর সমস্ত জন্তু জানোয়ার মারা পড়ল| সমস্ত বন্য প্রাণী, সরীসৃপ ধ্বংস হয়ে গেল| স্থলচর যত প্রাণী শ্বাস প্রশ্বাস নেয় তারাও মারা গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","এইভাবে ঈশ্বর পৃথিবীকে একেবারে পরিষ্কার করে ফেললেন| পৃথিবীর সমস্ত জীবন্ত অস্তিত্ব ধ্বংস করে ফেললেন| সমস্ত মানুষ, সমস্ত জন্তু জানোয়ার, বুকে হাঁটা সমস্ত প্রাণী এবং সমস্ত পাখী এই সব কিছুই পৃথিবী থেকে নিশ্চিহ্ন হয়ে গেল| নোহ আর নোহের পরিবার পরিজন এবং নৌকোতে আশ্রয় পাওয়া পশুপাখী–কেবলমাত্র এইসব প্রাণের অবশেষ পৃথিবীতে বেঁচে থাকলো| ");
INSERT INTO ben2006_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","একটানা 150 দিন পৃথিবী বিপুল জলরাশিতে ডুবে থাকলো| ");
INSERT INTO ben2006_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","কিন্তু ঈশ্বর নোহর কথা ভুলে যান নি| নোহ এবং নোহের নৌকোয় আশ্রয় পাওয়া সব জীবজন্তুর কথাই ঈশ্বরের মনে ছিল| পৃথিবীর উপর দিয়ে তিনি এক বাতাস বইয়ে দিলেন| এবং সমস্ত জল সরে যেতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","আকাশ থেকে অবিশ্রান্ত বর্ষন বন্ধ হল| ভূগর্ভস্ত প্রস্রবণগুলি থেকে জল নির্গত হওয়া বন্ধ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","পৃথিবীর উপর থেকে জলরাশি ক্রমশঃ নেমে যেতে লাগল| 150 দিন পরে জল এতটাই নেমে গেল যে নৌকোটা আবার মাটি স্পর্শ করলো| নৌকা গিয়ে ঠেকল অরারটের একটা পর্বতে| সেটা ছিল সপ্তম মাসের 17 তম দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","জল ক্রমাগত নেমে যেতে লাগলো এবং দশম মাসের প্রথম দিনে পর্বতের মাথাগুলো জলের উপরে জেগে উঠলো| ");
INSERT INTO ben2006_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","আরও 40 দিন পরে নোহ নিজের তৈরী নৌকোর জানালাটা খুললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","তারপর তিনি নৌকো থেকে একটা দাঁড়কাক উড়িয়ে দিলেন| এবং যতদিন না জল নেমে গিয়ে শুকনো ডাঙা দেখা দিল ততদিন সেই দাঁড়কাকটা নৌকো থেকে উড়ে গিয়ে এক জায়গা থেকে আর এক জায়গায় উড়ে বেড়াতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","নোহ একটা পায়রাও উড়িয়ে দিলেন| পায়রাটা শুকনো ডাঙা খুঁজে পায় কিনা তা নোহ জানতে চাইছিলেন| তিনি জানতে চাইছিলেন যে পৃথিবী এখনও জলে ডুবে আছে কি না| ");
INSERT INTO ben2006_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","পৃথিবী তখনও জলে ঢাকা, তাই পায়রাটা বসার জায়গা না পেয়ে ফিরে এল নৌকোতে| নোহ হাত বাড়িয়ে পায়রাটাকে ধরে নৌকোর ভিতরে টেনে নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","সাত দিন পরে নোহ আবার পায়রাটা উড়িয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","এবং সেদিন বিকেলে পায়রাটা জলপাইয়ের একটা কচি পাতা ঠোঁটে নিয়ে ফিরে এল| পৃথিবীতে যে আবার ডাঙা জেগে উঠতে শুরু করেছে ঐ কচি পাতাটি তারই চিহ্ন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","সাত দিন পরে নোহ আবার পায়রাটা উড়িয়ে দিলেন| কিন্তু এবার পায়রাটা আর ফিরে এল না| ");
INSERT INTO ben2006_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","তারপর নোহ নৌকোর দরজাটা খুললেন| নোহ তাকিয়ে শুকনো ডাঙা দেখতে পেলেন| সেটা ছিল বছরের প্রথম মাসের প্রথম দিন| নোহর বয়স তখন 601 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","দ্বিতীয় মাসের 27তম দিনের মধ্যে ডাঙা সম্পূর্ণ শুকনো হয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ঈশ্বর তখন নোহকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“নৌকো থেকে নেমে এস| তুমি, তোমার স্ত্রী, তোমার পুত্ররা আর তাদের বধূরা নৌকো থেকে এবার বাইরে যাও| ");
INSERT INTO ben2006_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","তোমাদের সঙ্গে নৌকোর সমস্ত পশুপাখী নিয়ে বাইরে যাও| সমস্ত পাখী, সমস্ত জন্তু জানোয়ার এবং বুকে হেঁটে চলে এরকম সমস্ত প্রাণী নিয়ে বাইরে এসো| ঐসব পশুপাখী আরও অনেক পশুপাখীর জন্ম দেবে আর সে সবে আবার পৃথিবী ভরে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","অতএব নোহ, তাঁর স্ত্রী, পুত্র ও পুত্রবধূদের নিয়ে নৌকো থেকে মাটিতে নামলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","সমস্ত জন্তু জানোয়ার, সমস্ত প্রাণী যা বুকে হাঁটে এবং সমস্ত পাখী নৌকো ছেড়ে বাইরে বেরিয়ে এল| নৌকো ছেড়ে এল জোড়ায় জোড়ায় সমস্ত পশুপাখী| ");
INSERT INTO ben2006_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","তখন নোহ প্রভুর জন্যে একটা বেদী তৈরী করলেন| নোহ কয়েকটি শুচি পশু ও কয়েকটি শুচি পাখী ঈশ্বরের উদ্দেশ্যে নিবেদন করে সেই বেদীতে হোম করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","প্রভু হোমের গন্ধ আঘ্রাণ করে প্রীত হলেন| আপন মনে প্রভু বললেন, “মানুষকে শাস্তি দেওয়ার জন্যে আমি আর কখনও মৃত্তিকাকে অভিশাপ দেব না| কারণ বাল্যকাল থেকে মানুষের স্বভাব মন্দ| সুতরাং এইমাত্র আমি যেমনটি করেছিলাম আর কখনও সেভাবে পৃথিবীর সমস্ত প্রাণীদের ধ্বংস করব না| ");
INSERT INTO ben2006_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","যতদিন পৃথিবী থাকবে ততদিন শস্যের চারা রোপণের আর ফসল কাটার নির্দিষ্ট সময় থাকবে| ততদিন ঠাণ্ডা, গরম, শীতকাল আর গ্রীষ্মকাল এবং দিন, রাত হয়ে চলবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ঈশ্বর নোহ আর তাঁর পুত্রদের আশীর্বাদ করলেন| ঈশ্বর তাদের বললেন, “তোমাদের বহু সন্তান হোক্| তোমাদের উত্তরপুরুষরা পৃথিবী পরিপূর্ণ করুক| ");
INSERT INTO ben2006_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","পৃথিবীর সমস্ত জন্তু জানোয়ার, আকাশের সমস্ত পাখী, যতরকমের সরীসৃপ জাতীয় জীব যারা মাটির উপরে বুকে হেঁটে চলে এবং জলের সমস্ত মাছ প্রত্যেকে তোমাদের ভয় করবে| সমস্ত প্রাণীগণই তোমাদের শাসনে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","অতীতে তোমাদের খাদ্য হিসেবে আমি শুধু সবুজ উদ্ভিদ তোমাদের দিয়েছিলাম| এখন থেকে সমস্ত জানোয়ারই তোমাদের খাদ্য হবে| পৃথিবীর সমস্ত কিছুই আমি তোমাদের দিচ্ছি| সব কিছুই তোমাদের| ");
INSERT INTO ben2006_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","যে মাংসের মধ্যে সেই প্রাণীর প্রাণ (রক্ত) আছে সেই মাংস কখনও খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","আমি তোমাদের জীবনের জন্য তোমাদের রক্ত দাবি করব| অর্থাৎ‌ যদি কোনও জানোয়ার কোনও মানুষকে হত্যা করে তাহলে আমি তার প্রাণ দাবী করব এবং যদি কোন মানুষ অন্য কোনও মানুষের প্রাণ নেয় আমি তারও প্রাণ দাবী করব| ");
INSERT INTO ben2006_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ঈশ্বর মানুষকে আপন ছাঁচে তৈরী করেছেন| তাই যে মানুষ অপর মানুষকে হত্যা করে তার অবশ্যই মানুষের হাতে মৃত্যু হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“নোহ, তুমি ও তোমার পুত্রদের অনেক সন্তানসন্ততি হোক্| আপন পরিজনদের দিয়ে পৃথিবী পরিপূর্ণ করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","তারপর ঈশ্বর নোহ ও তাঁর পুত্রদের বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“আমি এখন তোমাকে এবং তোমার লোকদের, যারা তোমার পরে বর্ত্তমান থাকবে তাদের প্রতিশ্রুতি দিচ্ছি| ");
INSERT INTO ben2006_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","নৌকোর মধ্যে থেকে তোমার সঙ্গে যেসব পাখী, যেসব গৃহপালিত জন্তু এবং অন্যান্য যেসব জানোয়ার নেমেছে তাদের সবাইকে আমার প্রতিশ্রুতি দিচ্ছি| পৃথিবীর সমস্ত প্রাণীর কাছে আমার প্রতিশ্রুতি দিচ্ছি| ");
INSERT INTO ben2006_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","তোমাদের কাছে আমার প্রতিশ্রুতি হল এই: পৃথিবীর সমস্ত প্রাণ বন্যা দিয়ে ধ্বংস করা হয়েছিল| কিন্তু এমন ঘটনা আর কখনও হবে না| কোনও বন্যা আর কখনও পৃথিবী থেকে সমস্ত প্রাণ নিশ্চিহ্ন করবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ঈশ্বর আরও বললেন, “আর আমি যে এই প্রতিশ্রুতি দিলাম এর প্রমাণস্বরূপ আমি তোমাদের একটা জিনিস দেব| এই প্রমাণ থেকে সকলে জানবে যে আমি তোমাদের সঙ্গে এবং পৃথিবীর সমস্ত জীবন্ত জিনিসের সঙ্গে চুক্তিবদ্ধ| এই চুক্তি চিরকালীন| ");
INSERT INTO ben2006_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","প্রমাণটা এই যে, আকাশে আমি মেঘে মেঘে সাতরঙের এক রঙধনু বানিয়েছি| ঐ রঙধনুই হল আমার আর পৃথিবীর মধ্যে চুক্তির চিহ্ন| ");
INSERT INTO ben2006_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","আমি যখন পৃথিবীর উপরে মেঘমালা ছড়িয়ে দেব, তখন তোমরা মেঘে ঐ রঙধনু দেখতে পাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","আর আমি যখন ঐ রঙধনু দেখতে পাবো, আমার তখন তোমাদের ও পৃথিবীর যাবতীয় জীবন্ত জিনিসের সঙ্গে চুক্তির কথা মনে পড়বে| এই চুক্তির মর্ম হল যে পৃথিবীতে আর কখনও সর্ব বিধ্বংসী এমন বন্যা হবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","আমি যখন মেঘের মধ্যে ঐ রঙধনু দেখবো তখন চিরকালের জন্য সম্পন্ন ঐ চুক্তির কথা আমার মনে পড়ে যাবে| আমার আর পৃথিবীর প্রত্যেক প্রাণীর মধ্যে ঐ চুক্তির কথা আমি মনে রাখব|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","তারপর প্রভু নোহকে বললেন, “পৃথিবীর সমস্ত প্রাণীর সঙ্গে আমি যে একটা চুক্তি করেছি ঐ রঙধনুই তার প্রমাণ|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","নোহর সঙ্গে তাঁর পুত্ররাও নৌকো থেকে বেরিয়ে এলো| তাদের নাম শেম, হাম আর যেফৎ| (হামই কনানের পিতা|) ");
INSERT INTO ben2006_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ঐ তিনজন হল নোহর পুত্র| ঐ তিন পুত্র হতেই পৃথিবীর সমস্ত মানুষ এসেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","মাটিতে নেমে নোহ কৃষিকাজ শুরু করলেন| একটা জমিতে তিনি দ্রাক্ষা চাষ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","সেই দ্রাক্ষা থেকে নোহ দ্রাক্ষারস বানালেন, তারপর সেই দ্রাক্ষারস পান করে নেশায চুর হয়ে তাঁবুর ভিতরে শুয়ে পড়লেন| নোহর গায়ে আবরণ থাকল না| ");
INSERT INTO ben2006_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","কনানের পিতা হাম সেই উলঙ্গ অবস্থায় নিজের পিতাকে দেখে ফেললো| তাঁবুর বাইরে গিয়ে সে কথা ভাইদের বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","তখন শেম আর যেফৎ এক খণ্ড বস্ত্র নিয়ে নিজেদের পিঠের উপর ছড়িয়ে নিলো| তারপর পিছন দিকে হেঁটে হেঁটে তাঁবুর ভিতরে ঢুকে ঐ বস্ত্রখণ্ড দিয়ে পিতাকে ঢেকে দিল| এইভাবে, তাদের মুখ বিপরীত দিকে ছিল বলে তাদের পিতার নগ্নতা তারা দেখেনি| ");
INSERT INTO ben2006_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","দ্রাক্ষারসের প্রভাবে নোহ ঘুমিয়ে পড়েছিলেন| তিনি যখন ঘুম থেকে উঠলেন তখন জানতে পারলেন তাঁর তরুণ পুত্র হাম তাঁর প্রতি কি করেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","তখন নোহ বললেন, “অভিশাপ কনানের উপরে পড়ুক| তাকে চিরকাল তার ভাইদের দাস হয়ে থাকতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","নোহ আরও বললেন, “শেমের প্রভু ঈশ্বরের প্রশংসা কর! কনান যেন শেমের দাস হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ঈশ্বর যেফৎকে আরও জমি দিন, ঈশ্বর শেমের তাঁবুতে অবস্থান করুন এবং কনান তাদের দাস হউক|” ");
INSERT INTO ben2006_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","বন্যার পরে নোহ 350 বছর বেঁচেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","নোহ বেঁচেছিলেন মোট 950 বছর; তারপর তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","শেম, হাম ও যেফৎ এই তিনজন ছিল নোহর পুত্র| বন্যার পরে এই তিনজনের আরও বহু সন্তান সন্ততির জন্ম হল| শেম, হাম ও যেফতের উত্তরপুরুষরা: ");
INSERT INTO ben2006_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","যেফতের পুত্রগণ হল: গোমর, মাগোগ, মাদয়, যবন, তূবল, মেশক এবং তীরস| ");
INSERT INTO ben2006_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","গোমরের পুত্রগণ হল: অস্কিনস, রীফৎ‌ এবং তোগর্ম| ");
INSERT INTO ben2006_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","যবনের পুত্রগণ হল: ইলীশা, তর্শীশ, কিত্তীম এবং দোদানীম| ");
INSERT INTO ben2006_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ভূমধ্যসাগর অঞ্চলে যে সকল মানুষের বাস তারা সকলেই যেফতের সন্তানসন্ততি| প্রত্যেক পুত্রের নিজস্ব ভূমি ছিল| সমস্ত পরিবারই বৃদ্ধি পেতে পেতে একটি জাতিতে পরিণত হয়| প্রত্যেক জাতির নিজস্ব ভাষা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","হামের পুত্রগণ হল: কূশ, মিশর, পূট এবং কনান| ");
INSERT INTO ben2006_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কূশের পুত্রগণ হল: সবা, হবীলা, সপ্তা, রয়মা এবং সপ্তক| রয়মার পুত্রগণ হল: শিবা এবং দদান| ");
INSERT INTO ben2006_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","নিম্রোদ নামেও কুশের এক পুত্র ছিল| কালক্রমে নিম্রোদ দারুন শক্তিমান পুরুষে পরিণত হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","প্রভুর সম্মুখে নিম্রোদ একজন বড় শিকারী হয়ে উঠল| সেজন্য তার সঙ্গে অন্যান্য লোকদের তুলনা করে সকলে বলতো, “ঐ মানুষটি নিম্রোদের মত, এমন কি প্রভুর সামনেও দারুণ শিকারী|” ");
INSERT INTO ben2006_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","নিম্রোদের রাজত্ব বাবিল থেকে শিনিয়র দেশে এরক অক্কদ এবং কল্নী পর্যন্ত বিস্তৃত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","নিম্রোদ অশূরেও গিয়েছিল| নিম্রোদ অশূর দেশে নীনবী, রহোবোৎ-পুরী, কেলহ এবং ");
INSERT INTO ben2006_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","রেষণ (নীনবী এবং কেলহের মধ্যবর্তী ভুভাগে রেষণ মহানগরের পত্তন হয়|) ");
INSERT INTO ben2006_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","মিশর ছিল লূদীয়, অনামীয়, লহাবীয়, নপ্তুহীয়, ");
INSERT INTO ben2006_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","পথ্রোষীয়, কস্লূহীয় আর কপ্তোরীয় অঞ্চলগুলির অধিবাসীদের জনক| (পলেষ্টীয়রা কস্লূহীয় দেশ থেকে এসেছিল|) ");
INSERT INTO ben2006_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","কনান ছিল সীদোনের পিতা| সীদোন কনানের প্রথম সন্তান| কনান হিত্তীয়দের পূর্বপুরুষ হেতেরও পিতা ছিলেন| হেৎ থেকে হিত্তীয়দের উদ্ভব| ");
INSERT INTO ben2006_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","কনান ছিলেন যিবুষীয়, ইমোরীয় জনগোষ্ঠী, গির্গাশীয়়দের পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিব্বীয় জনগোষ্ঠী, অর্কীয়় জনগোষ্ঠী, সীনীয়় জনগোষ্ঠী, ");
INSERT INTO ben2006_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","অর্বদীয়় জনগোষ্ঠী, সমারীয়় জনগোষ্ঠী এবং হমাতীয় জনগোষ্ঠী কনান থেকে উদ্ভুত হয়| পরে কনানীয় গোষ্ঠীগুলি পৃথিবীর বিভিন্ন অংশে ছড়িয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","কনানীয়দের দেশ উত্তরে সীদোন থেকে দক্ষিণে গরার পর্যন্ত, পশ্চিমে ঘসা থেকে পূর্বে সদোম ও ঘমোরা পর্যন্ত এবং অদ্মা ও সবোয়ীর থেকে লাশা পর্যন্ত বিস্তৃত ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","এই সমস্ত মানুষই ছিল হামের উত্তরপুরুষ| এইসব পরিবারগুলির নিজস্ব ভাষা ও নিজস্ব দেশ ছিল| তারা ক্রমে ক্রমে পৃথক পৃথক জাতি হয়ে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","যেফতের বড় ভাই ছিল শেম| শেমের একজন উত্তরপুরুষ হল এবর এবং এবর সমস্ত হিব্রু জনগোষ্ঠীর জনক রূপে পরিচিত| ");
INSERT INTO ben2006_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","শেমের পুত্ররা হল: এলম, অশূর, অর্ফক্ষদ, লূদ এবং অরাম| ");
INSERT INTO ben2006_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অরামের পুত্রেরা হল: উষ, হূল, গোখর এবং মশ| ");
INSERT INTO ben2006_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","অর্ফক্ষদের পুত্র শেলহ, শেলহের পুত্র এবর| ");
INSERT INTO ben2006_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","এবরের দুই পুত্র| এক পুত্রের নাম পেলগ| তার আমলে পৃথিবী বিভক্ত হয় বলে তার ঐ নাম হয়| অন্য পুত্রের নাম যক্তন| ");
INSERT INTO ben2006_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","যক্তনের পুত্রেরা হল: অল্মোদদ, শেলফ, হৎসর্মাবৎ, যেরহ, ");
INSERT INTO ben2006_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদোরাম, উবল, দিক্ল, ");
INSERT INTO ben2006_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ওবল, অবীমায়েল, শিবা, ");
INSERT INTO ben2006_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফীর, হবীলা এবং যোবব| এরা সবাই ছিল যক্তনের পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","পূর্ব দিকে মেষা এবং পার্বত্য দেশের মধ্যবর্তী ভুভাগে তারা বাস করত| মেষা ছিল সফার দেশের দিকে| ");
INSERT INTO ben2006_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","এরা সবাই ছিল শেমের পরিবারের অন্তর্গত| পরিবার, ভাষা, দেশ ও জাতি অনুসারেই তাদের সাজানো হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","এই সবগুলোই নোহের পুত্রদের পরিবার| পরিবারগুলি তালিকা তাদের জাতি অনুসারে প্রস্তুত করা হয়েছে| প্লাবনের পরে এই পরিবারগুলি থেকেই সারা পৃথিবীতে মনুষ্য সমাজের বিস্তার হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","প্লাবনের পরে সমস্ত পৃথিবী এক ভাষাতে কথা বলত| সমস্ত মানুষ একই শব্দগুলি ব্যবহার করত| ");
INSERT INTO ben2006_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","সেই লোকরা পূর্ব দিক থেকে ঘুরতে ঘুরতে শিনিয়র দেশে এসে সমতল ভূমি পেল| তারা সেখানে বসবাস শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","তারা বলল, “আমরা মাটি দিয়ে ইঁট তৈরী করব, তারপর আরও শক্ত করার জন্যে ইঁটগুলো পোড়াব|” তখন মানুষ পাথরের বদলে ইঁট দিয়ে বাড়ী তৈরী করল| আর গাঁথনি শক্ত করার জন্যে সিমেন্টের বদলে আলকাতরা ব্যবহার করল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","তারা বলল, “এস আমরা আমাদের জন্য এক বড় শহর বানাই| আর এমন একটি উঁচু স্তম্ভ বানাই যা আকাশ স্পর্শ করবে| তাহলে আমরা বিখ্যাত হব এবং এটা আমাদের এক সঙ্গে ধরে রাখবে| সারা পৃথিবীতে আমরা ছড়িয়ে থাকব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","সেই শহর আর সেই আকাশস্পর্শী স্তম্ভ দেখতে প্রভু পৃথিবীতে নেমে এলেন| মানুষ কি কি তৈরী করেছে সেসব প্রভু দেখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","প্রভু বললেন, “সব মানুষ একই ভাষাতে কথা বলছে| আর দেখতে পাচ্ছি যে এসব কাজ করার জন্যে তারা ঐক্যবদ্ধ| তারা কি করতে পারে এ তো সবে তার শুরু| শীঘ্রই তারা যা চায় তাই করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","তাহলে এস আমরা নীচে গিয়ে ওদের এক ভাষাকে নানারকম ভাষা করে দিই| তাহলে তারা পরস্পরকে বুঝতে পারবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","সুতরাং প্রভু সমস্ত লোকেদের সারা পৃথিবীতে ছড়িয়ে দিলেন| ফলে মানুষ আর সেই শহর তৈরির কাজ শেষ করতে পারল না| ");
INSERT INTO ben2006_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","এই সেই স্থান যেখানে প্রভু সমস্ত পৃথিবীর এক ভাষাকে অনেক ভাষাতে বিভ্রান্ত করলেন| তাই এই স্থানটির নাম হলো বাবিল| এইভাবে প্রভু তাঁদের সেই স্থান থেকে পৃথিবীর বিভিন্ন স্থানে ছড়িয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","এটা হল শেমের পরিবারের কাহিনী| প্লাবনের দু বছর পরে, যখন শেমের বয়স 100 বছর তখন তার অর্ফক্ষদ নামে পুত্রটির জন্ম হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","তারপরে শেম 500 বছর বেঁচেছিলেন| তাঁর আরও পুত্রকন্যা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","অর্ফক্ষদের 35 বছর বয়সে তাঁর পুত্র শেলহের জন্ম হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","শেলহের জন্মের পরে অর্ফক্ষদ 403 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","যখন শেলহের বয়স 30 বছর তখন এবর নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","এবরের জন্মের পরে শেলহ 403 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","এবরের যখন 34 বছর বয়স তখন পেলগ নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","পেলগের জন্মের পর এবর 430 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","পেলগের যখন 30 বছর বয়স তখন রিয়ু নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","রিয়ুর জন্মের পরে পেলগ আরও 209 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","রিয়ুর যখন 32 বছর বয়স তখন সরূগ নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","সরূগের জন্মের পরে রিয়ু 207 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","সরূগের যখন 30 বছর বয়স তখন নাহোর নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","নাহোরের জন্মের পরে সরূগ 200 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নাহোরের যখন 29 বছর বয়স তখন তেরহ নামে তাঁর এক পুত্র হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","তেরহের জন্মের পরে নাহোর আরও 119 বছর বেঁচেছিলেন| ইতিমধ্যে তাঁর আরও পুত্রকন্যা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তেরহ 70 বছর বয়সে যথাক্রমে অব্রাম, নাহোর ও হারণ নামে পুত্রদের জন্ম দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","এটা হল তেরহের পরিবারের কাহিনী| তেরহ হল অব্রাম, নাহোর ও হারণের জনক| হারণ ছিল লোটের জনক| ");
INSERT INTO ben2006_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","কিন্তু তেরহের জীবদ্দশাতেই আপন জন্মস্থান কলদীয়় দেশের উরে হারণের মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","অব্রাম ও নাহোর দুজনেই বিবাহ করেন| অব্রামের স্ত্রীর নাম সারী আর নাহোরের স্ত্রীর নাম মিল্কা| মিল্কা ছিল হারণের কন্যা| হারণ ছিলেন মিল্কা ও য়িষ্কার জনক| ");
INSERT INTO ben2006_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","সারী বন্ধ্যা ছিল তাই তাঁর কোনও সন্তান হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","তেরহ তাঁর পরিবার নিয়ে কলদীয়় দেশের উর পরিত্যাগ করলেন| তাঁদের পরিকল্পনা ছিল কনান দেশে যাওয়ার| তেরহ তাঁর পুত্র অব্রাম, তাঁর পৌত্র লোট এবং পুত্রবধূ সারীকে সঙ্গে নিলেন| তাঁরা হারণ নামে একটা শহরে পৌঁছে সেখানেই বাস করার সিদ্ধান্ত নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","তেরহ 205 বছর বেঁচেছিলেন এবং হারণেই তাঁর মৃত্যু হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","প্রভু অব্রামকে বললেন, “তুমি এই দেশ, নিজের জাতিকুটুম্ব এবং পিতার পরিবার ত্যাগ করে, আমি যে দেশের পথ দেখাব সেই দেশে চল| ");
INSERT INTO ben2006_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","তোমা হতে আমি এক মহাজাতি উৎপন্ন করব| তোমাকে আশীষ দেব এবং তুমি বিখ্যাত হবে| অন্যকে আশীর্বাদ জানাতে লোকে তোমার নাম নেবে| ");
INSERT INTO ben2006_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","যারা তোমাকে আশীর্বাদ করবে, সেই লোকদের আমি আশীর্বাদ করব এবং যারা তোমাকে অভিশাপ দেবে, সেই লোকদের আমি অভিশাপ দেব| তোমার মাধ্যমে আমি পৃথিবীর সব লোকদের আশীর্বাদ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","অতঃপর অব্রাম প্রভুর আজ্ঞা পালন করলেন| তিনি হারণ ত্যাগ করলেন এবং লোট তাঁর সঙ্গে গেলেন| অব্রামের বয়স তখন 75 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","অব্রাম সঙ্গে নিলেন স্ত্রী সারী, ভ্রাতুষ্পুত্র লোট এবং হারণে তাঁদের যা কিছু ছিল সে সবই নিয়ে গেলেন| হারণে অব্রামের যেসব দাসদাসী ছিল তাদেরও তিনি সঙ্গে নিলেন| দলবল সমেত হারণ ত্যাগ করে অব্রাম কনান দেশে যাত্রা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","অব্রাম কনান দেশের মধ্য দিয়ে শিখিম শহরে গেলেন এবং তারপরে মোরিতে এক বিশাল গাছের কাছে গেলেন| সেই সময় কনানীয়রা সেখানে বাস করতো| ");
INSERT INTO ben2006_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","প্রভু অব্রামের সকাশে আত্মপ্রকাশ করলেন| প্রভু বললেন, “তোমার উত্তরপুরুষদের আমি এই দেশ দেব|” প্রভু যেখানে অব্রামকে দর্শন দিয়েছিলেন সেখানে অব্রাম প্রভুর উদ্দেশ্যে উৎসর্গ সম্পাদনের জন্য পাথরের একটা বেদী নির্মাণ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","তারপর অব্রাম সেই স্থান ত্যাগ করে গেলেন বৈথেলের পূর্বদিকে অবস্থিত পর্বতে এবং সেখানে তাঁর শিবির স্থাপন করলেন| বৈথেল নগর ছিল পশ্চিম দিকে আর অয় ছিল পূর্ব দিকে| সেখানে অব্রাম আর একটি বেদী নির্মাণ করলেন এবং প্রভুর উপাসনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","অতঃপর তিনি পুনরায় তাঁর যাত্রা শুরু করলেন| তিনি নেগেভের দিকে অগ্রসর হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","তখন দেশটা ছিল খুব শুষ্ক| অনাবৃষ্টির জন্য কোনও শস্য উৎপাদন সম্ভব ছিল না| তাই অব্রাম বসবাসের জন্য আরও দক্ষিণে মিশরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","তিনি খেয়াল করলেন যে তাঁর স্ত্রী সারী কত সুন্দরী| তাই মিশরে প্রবেশের ঠিক আগে সারীকে বললেন, “আমি জানি তুমি সুন্দরী| ");
INSERT INTO ben2006_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","মিশরীয় পুরুষরা তোমায় দেখবে| তারা বলবে, ‘এই মহিলা ঐ লোকটার স্ত্রী|’ তারা তখন তোমাকে পাওয়ার জন্য আমায় মেরে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","তাই সবাইকে বলবে যে তুমি আমার বোন| তাহলে তারা আর আমায় হত্যা করবে না| তারা আমায় তোমার ভাই ভাববে, আমার সঙ্গে ভাল ব্যবহার করবে| এইভাবে তুমি আমার প্রাণ বাঁচাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","তখন অব্রাম মিশরে গেলেন| মিশরীয় পুরুষরা দেখল যে সারী কত সুন্দরী| ");
INSERT INTO ben2006_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","মিশরের নেতারা কেউ কেউ তাঁকে দেখলেন| সারী যে কত সুন্দরী সে কথা তাঁরা স্বয়ং ফরৌণের কানে তুললেন| তাঁরা সারীকে ফরৌণের প্রাসাদে নিয়ে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","অব্রামকে সারীর ভাই মনে করে ফরৌণ অব্রামের প্রতি সদয় ব্যবহার করলেন| অব্রামকে ফরৌণ মেষ, গবাদি পশু এবং বোঝা বইবার জন্য গাধা দিলেন| সেই সঙ্গে দাসদাসী এবং উটও পেলেন অব্রাম| ");
INSERT INTO ben2006_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","আর ফরৌণ অব্রামের স্ত্রীকে নিলেন| এই কারণে ফরৌণ এবং তাঁর প্রাসাদের সব লোকদের প্রভু ভয়ঙ্কর অসুখ দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","তখন ফরৌণ অব্রামকে ডেকে বললেন, “তুমি আমার প্রতি খুব অন্যায় করেছ! সারী যে তোমার স্ত্রী সে কথা আমায় বলো নি কেন? ");
INSERT INTO ben2006_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","তুমি কেন বলেছিলে যে সারী তোমার বোন? তোমার বোন মনে করে আমি ওকে আমার স্ত্রী করব বলে এনেছিলাম| কিন্তু এখন তোমায় তোমার স্ত্রী ফেরত দিচ্ছি| ওকে নিয়ে তুমি চলে যাও!” ");
INSERT INTO ben2006_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","তারপর ফরৌণ তাঁর লোকজনদের আদেশ করলেন, “অব্রামকে মিশরের বাইরে নিয়ে যাও|” সুতরাং অব্রাম ও তার স্ত্রী সেই দেশ ত্যাগ করলেন| এবং সঙ্গে তাঁদের সমস্ত জিনিসপত্রও নিয়ে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","অতঃপর অব্রাম মিশর ত্যাগ করলেন| তাঁর স্ত্রী এবং তাঁদের সমস্ত জিনিসপত্র নিয়ে অব্রাম নেগেভের মধ্যে দিয়ে অগ্রসর হলেন| তাঁর সঙ্গে তখন লোটও ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","এই সময় অব্রাম খুবই ধনী| তাঁর প্রচুর পশু এবং প্রচুর সোনা ও রূপা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","অব্রাম তাঁর যাত্রা অব্যাহত রাখলেন| নেগেভ ত্যাগ করে তিনি বৈথেলে ফিরে গেলেন| সেখান থেকে বৈথেল নগর আর অয় নগরের মধ্যবর্তী স্থানে গেলেন| এখানেই অব্রাম ও তাঁর পরিবার আগে একবার শিবির স্থাপন করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","এই স্থানটিতেই একটি বেদী নির্মাণ করেছিলেন| তাই অব্রাম এই স্থানটিতেই প্রভুর উপাসনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","এই পর্যটনের সময় অব্রামের সঙ্গে লোটও ছিল| লোটের অনেক পশু ও তাঁবু ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","অব্রাম আর লোটের এত পশু ছিল যে তাদের উভয়কে খাদ্য যোগাবার জন্য সেই দেশ অসমর্থ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","এই সময় কনানীয় এবং পরিষীয় জাতিরাও সে দেশে বাস করত| অব্রামের পশুপালকদের সঙ্গে লোটের পশুপালকদের বিবাদ হতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তখন অব্রাম লোটকে বলল, “তোমার আমার মধ্যে কোনও বিবাদ থাকতে পারে না| তোমার লোকদের সঙ্গে আমার লোকদের কোন বিবাদ হওয়া উচিত নয়| আমরা সবাই পরস্পরের আপনজন| ");
INSERT INTO ben2006_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","আমাদের পৃথক হয়ে যাওয়া উচিত| তোমার যে জায়গা পছন্দ সেই জায়গাতেই যাও| তুমি বাঁ দিকে গেলে আমি ডান দিকে যাব| যদি তুমি ডান দিকে যাও, আমি বাঁ দিকে যাব|” ");
INSERT INTO ben2006_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","লোট চোখ তুলে দেখল, সামনে বিস্তৃত যর্দন উপত্যকা| লোট দেখল জায়গাটা পর্যাপ্ত জলে সরস| (এটা প্রভু কর্ত্তৃক সদোম ও ঘমোরা ধ্বংস করার আগের ঘটনা| তখন সোয়র পর্যন্ত যর্দন উপত্যকা ছিল প্রভুর উদ্যানের মত| এখানকার মাটি ছিল মিশরের মাটির মত ভাল জাতের মাটি|) ");
INSERT INTO ben2006_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","তাই লোট যর্দন উপত্যকাতে বাস করবে বলে ঠিক করল| দুজনে পৃথক হয়ে গেল এবং লোট পূর্ব দিকে এগিয়ে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","অব্রাম কনানেই থেকে গেলেন এবং লোট উপত্যকার জনপদগুলিতে বাস করতে লাগলেন| লোট উপত্যকার সূদুর দক্ষিণে সদোমে চলে গেলেন এবং সেখানেই তাঁবু পাতলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","প্রভু জানতেন যে সদোমের অধিবাসীরা মহাপাপী| ");
INSERT INTO ben2006_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","লোট চলে গেলে প্রভু অব্রামকে বললেন, “তোমার চারদিকে তাকিয়ে দেখ| উত্তর, দক্ষিণ, পূর্ব, পশ্চিম চারদিকে তাকাও| ");
INSERT INTO ben2006_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","যত জমিজায়গা দেখতে পাচ্ছ, সব আমি তোমায় এবং তোমার বংশধরদের দেব| এ দেশ চিরকালের জন্যে তোমার হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","পৃথিবীর ধূলোর মত আমি তোমার উত্তরপুরুষদের সংখ্যাবৃদ্ধি করব| যদি লোকে পৃথিবীর সব ধূলো গুনতে পারে তাহলে তোমার লোকদের গোনা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","অতএব এগিয়ে যাও, তোমার নিজের দেশে তুমি হেঁটে বেড়াও| এই দেশ আমি তোমায় দিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","তখন অব্রাম তাঁর তাঁবু উঠিয়ে নিলেন| তিনি মম্রির উচ্চ বৃক্ষগুলির কাছে বাস করতে গেলেন| স্থানটি ছিল হিব্রোণ নগরের কাছে| সেখানে অব্রাম প্রভুর উদ্দেশ্যে উপাসনা করার জন্যে একটি বেদী নির্মাণ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","শিমিয়রের রাজা ছিলেন অম্রাফল| অরিয়োক ছিলেন ইল্লাসরের রাজা| এলমের রাজা ছিলেন কদলায়োমর এবং গোয়ীমের রাজা তিদিয়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","এইসব রাজা, সদোমের রাজা বিরা, ঘমোরার রাজা বির্শা, অদ্মার রাজা শিনাব, সবোয়িমের রাজা শিমেবর এবং বিলার (বিলা সোয়র নামেও পরিচিত ছিল) রাজার সঙ্গে যুদ্ধ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","এই সমস্ত রাজাদের সৈন্যবাহিনী সিদ্দীম উপত্যকায় মিলিত হল| (সিদ্দীম উপত্যকা বর্তমানে লবণ সমুদ্র|) ");
INSERT INTO ben2006_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","এই রাজারা বারো বছর ধরে কদর্লায়োমরের অনুগত ছিল| কিন্তু 13তম বছরে তারা সবাই কদর্লায়োমরের বিরুদ্ধে বিদ্রোহ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","সুতরাং 14তম বছরে রাজা কদর্লায়োমর ও তাঁর মিত্র রাজাদের সঙ্গে বিদ্রোহী রাজাদের যুদ্ধ হল| কদর্লায়োমর ও তাঁর মিত্র রাজারা অন্তরোৎ‌ কর্ণয়িমের অধিবাসী রফায়ীয় নামক জাতিকে পরাস্ত করলেন| তারা হমের সুষী য়দেরও পরাস্ত করলেন এবং শাবি-কিরিয়াথয়িমের অধিবাসী এমীয়দের পরাস্ত করলেন। ");
INSERT INTO ben2006_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","তারপর তাঁরা হোরীয়দের পরাস্ত করলেন| হোরীয়রা সেয়ীর থেকে এল-পারণ (এল-পারণ মরুভূমির কাছে অবস্থিত) পর্যন্ত পার্বত্য দেশে বাস করত| ");
INSERT INTO ben2006_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","তারপর রাজা কদর্লায়োমের উত্তর দিকে গেলেন এবং ঐনমিস্পটে অর্থাৎ‌ কাদেশে গিয়ে সমস্ত অমালেকীয়দের পরাস্ত করলেন| তিনি হৎসসোন তামরের অধিবাসী ইমোরীয়দেরও পরাস্ত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","সেই সময় সদোমের রাজা, ঘমোরার রাজা, অদ্মার রাজা, সবোয়িমের রাজা এবং বিলার রাজা তাঁদের শত্রুদের বিরুদ্ধে সম্মিলিতভাবে সিদ্দীম উপত্যকায় যুদ্ধ করতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","এই যুদ্ধে অপর পক্ষে ছিলেন এলমের রাজা কদর্লায়োমর, গোয়ীমের রাজা তিদিয়ল, শিনিয়রের রাজা অম্রাফল এবং ইলাসরের রাজা অরিয়োক| অর্থাৎ‌ যুদ্ধটা ছিল পাঁচজন রাজার বিরুদ্ধে চারজন রাজার| ");
INSERT INTO ben2006_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","সিদ্দীম উপত্যকায় আলকাতরায় পূর্ণ অনেক গর্ত ছিল| সদোম এবং ঘমোরার রাজা এবং তাদের সৈন্যরা যুদ্ধক্ষেত্র থেকে পালিয়ে গেল| অনেক সৈন্য ঐসব খাতে পড়ল| কিন্তু অধিকাংশই পাহাড়ে পর্বতে পালিয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","সুতরাং সদোম এবং ঘমোরার সমস্ত সরঞ্জাম, তাদের সমস্ত খাদ্যসম্ভার, বস্ত্রাদি এবং অন্যান্য সব জিনিসপত্র প্রতিপক্ষরা নিয়ে চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","অব্রামের ভ্রাতুষ্পুত্র লোট তখন সদোমে বাস করছিল এবং সদোমের শত্রুরা লোটকে বন্দী করল, লোটের যা কিছু ছিল সব অধিকার করল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","লোটের একটি লোককে তারা বন্দী করতে পারে নি| সে পালিয়ে গিয়ে যা যা ঘটেছে সমস্ত অব্রামকে জানাল| অব্রাম তখন ইমোরীয়দের মম্রির গাছগুলির কাছে শিবিরে বাস করছিলেন| মম্রি, ইষ্কোল এবং আনেরের মধ্যে পরস্পরকে সাহায্য করার এক চুক্তি ছিল| তারা অব্রামকে সাহায্য করার একটা চুক্তিও করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","লোট বন্দী হয়েছে জানতে পেরে অব্রাম পরিবারের সবাইকে ডেকে পাঠালেন| তাদের মধ্যে 318 জন শিক্ষিত সৈন্য ছিল| অব্রাম তাঁর লোকদের পরিচালনা করে শত্রুদের দূরে দান নগর অবধি তাড়িয়ে নিয়ে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","সেই রাত্রে তিনি ও তাঁর সৈন্যরা অতর্কিতে শত্রুদের আক্রমণ করলেন| তাঁরা শত্রুদের পরাভূত করে দম্মেশকের উত্তরে হোবা পর্যন্ত বিতাড়িত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","তারপর শত্রুরা যা যা অধিকার করেছিল, সেই সমস্ত পুনরুদ্ধার করলেন| লোট, লোটের সমস্ত নারী ও ভৃত্যদের পর্যন্ত অব্রাম ফিরিয়ে আনলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","তারপর অব্রাম কদর্লায়োমর ও তাঁর সঙ্গে যোগদানকারী রাজাদের পরাস্ত করে তাঁর আগের জায়গায় ফিরে এলেন| তিনি ফিরে এলে সদোমের রাজা তাঁর সঙ্গে শাবী উপত্যকায় (এখন এই স্থান রাজার উপত্যকা নামে পরিচিত) দেখা করতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","শালেমের রাজা মল্কীষেদকও অব্রামের সঙ্গে সাক্ষাৎ করতে গেলেন| মল্কীষেদক ছিলেন পরাৎ‌‌পর ঈশ্বরের একজন যাজক| মল্কীষেদক নিয়ে এলেন রুটি ও দ্রাক্ষারস| ");
INSERT INTO ben2006_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","অব্রামকে আশীর্বাদ করে মল্কীষেদক বললেন, “হে অব্রাম, পরাৎ‌‌পর তোমাকে আশীর্বাদ করুন| ঈশ্বর স্বর্গ ও মর্ত্য সৃষ্টি করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","আমরা পরাৎ‌‌পর ঈশ্বরের প্রশংসা করি| তিনি শত্রুদের পরাস্ত করতে তোমাকে সাহায্য করেছেন|” অব্রাম যুদ্ধের সময় যা যা পেয়েছিলেন তার থেকে এক দশমাংশ মল্কীষেদককে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","সদোমের রাজা বললেন, “আপনি নিজের জন্যে সব রেখে দিন| শত্রুরা যে লোকদের নিয়ে গেছে শুধু আমার সেই লোকদের আমাকে দিন|” ");
INSERT INTO ben2006_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","কিন্তু সদোমের রাজাকে অব্রাম বললেন, “পরাৎ‌পর ঈশ্বর, যিনি স্বর্গ মর্ত্য সৃষ্টি করেছেন সেই প্রভুর কাছে আমি শপথ করছি| ");
INSERT INTO ben2006_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","যা কিছু আপনার তার কিছুই আমি রাখব না| আমি প্রতিশ্রুতি করছি যে আমি কিছুই রাখব না| এমনকি একটা সুতো অথবা জুতোর ফিতেও না। আমি চাই না যে আপনি বলবেন, ‘অব্রামকে আমি বড় লোক বানিয়েছি|’ ");
INSERT INTO ben2006_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","আমি শুধু সেটুকুই নেব যা আমার যোদ্ধারা খেয়েছে| কিন্তু অন্যদের আপনি তাদের ভাগ দিন| যুদ্ধে যা জিতেছি তা আপনি নিয়ে যান, কিন্তু কিছু আনের, ইষ্কোল এবং মম্রিকে দিয়ে যান| এরা যুদ্ধে আমায় সাহায্য করেছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","এইসব ঘটনাবলির পরে অব্রাম দর্শনের মধ্যে প্রভুর কথা শুনতে পেলেন| ঈশ্বর বললেন, “অব্রাম চিন্তা কোরো না| আমি তোমায় রক্ষা করব| আমি তোমায় এক মহাপুরস্কার দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","কিন্তু অব্রাম বললেন, “প্রভু ঈশ্বর, আমায় খুশী করার মত আপনি কিছুই দিতে পারবেন না| কেন? কারণ আমার কোনও পুত্র নেই| তাই আমার মৃত্যুর পরে আমার দম্মেশকীয দাস ইলীয়েষর আমার সমস্ত সম্পত্তির উত্তরাধিকারী হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","অব্রাম বললেন, “আপনি আমায় পুত্র দেননি| তাই যে দাস আমার ঘরে জন্ম লাভ করেছে সে-ই পাবে আমার সমস্ত ধনসম্পত্তি|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","তখন প্রভু অব্রামের সঙ্গে কথা বললেন| ঈশ্বর বললেন, “ঐ দাস তোমার নিজের পুত্র হবে. এবং তোমার ঔরসজাত পুত্রই তোমার সমস্ত কিছুর উত্তরাধিকার পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","তখন ঈশ্বর অব্রামকে বাইরে ডেকে নিয়ে গেলেন| ঈশ্বর বললেন, “আকাশের দিকে তাকাও| দেখ, সেখানে কত তারা| এত তারা যে তুমি গুণতেই পারবে না| ভবিষ্যতে তোমার বংশধররাও ঐরকম অগুনতি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","অব্রাম ঈশ্বরকে বিশ্বাস করলেন এবং ঈশ্বর অব্রামের বিশ্বাসকে তার ধার্মিকতা হিসেবে বিবেচনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","এবং ঈশ্বর অব্রামকে বললেন, “আমিই সেই প্রভু, যিনি তোমায় বাবিলের উর থেকে নিয়ে এসেছিলেন, যাতে এই দেশটা আমি তোমায় দিতে পারি| এই দেশ তুমি পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","কিন্তু অব্রাম বললেন, “প্রভু আমার গুরু, এই দেশ যে আমি পাব তার নিশ্চয়তা কি?” ");
INSERT INTO ben2006_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ঈশ্বর অব্রামকে বললেন, “আমরা একটা চুক্তি করব| আমায় একটা তিন বছরের বাছুর, তিন বছরের ছাগল আর তিন বছরের মেষ এনে দাও| একটা বাচ্চা পায়রা আর একটা ঘুঘুপাখীও এনে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","অব্রাম এই সমস্ত ঈশ্বরের কাছে এনে দিলেন| অব্রাম প্রাণীগুলি হত্যা করে এবং প্রতিটির দুটি করে খণ্ড করে ঐ খণ্ডগুলি থাক-থাক করে সাজিয়ে রাখলেন| কিন্তু পাখীগুলিকে অব্রাম দুখণ্ড করেন নি| ");
INSERT INTO ben2006_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","পরে ঐসব প্রাণীর মাংসখণ্ডের জন্য বড় বড় পাখী ছোঁ মেরে এলো| কিন্তু অব্রাম সেগুলি তাড়িয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","বেলা বাড়তে থাকল, ঢলে পড়তে লাগল সূর্য| অব্রামের ভীষণ ঘুম পেল এবং শেষ পর্যন্ত তিনি ঘুমিয়ে পড়লেন| তখন নেমে এল এক ভীষণ অন্ধকার| ");
INSERT INTO ben2006_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","তখন প্রভু অব্রামকে বললেন, “তোমার কয়েকটা কথা জেনে রাখা উচিৎ‌| তোমার উত্তরপুরুষরা যে দেশে বাস করবে সেই দেশ তাদের নয়, সেখানে তারা বিদেশী বলে গণ্য হবে| এবং সেই দেশের অধিবাসীরা 400 বছর ধরে তোমার উত্তরপুরুষদের দাস করে রাখবে এবং তাদের উপর নানা উৎ‌পীড়ন করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","কিন্তু তারপর যে জাতি তোমার উত্তরপুরুষদের দাস করে রেখেছিল তাদের আমি শাস্তি দেব| তোমার উত্তরপুরুষরা সেই জাতি ত্যাগ করবে এবং তাদের সঙ্গে নিয়ে যাবে বহু ভাল জিনিস| ");
INSERT INTO ben2006_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“তুমি নিজে বহুকাল জীবিত থাকবে| শান্তিতে তুমি শেষ নিঃশ্বাস ত্যাগ করবে| তোমার সমাধি হবে তোমার পরিবারের মধ্যে| ");
INSERT INTO ben2006_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","চার প্রজন্ম পরে তোমার আত্মীয়স্বজনরা আবার এই দেশে আসবে| তখন তারা এখানকার অধিবাসী ইমোরীয়দের পরাস্ত করবে| তোমার আত্মীয়স্বজনদের মাধ্যমে আমি ইমোরীয়দের শাস্তি দেব| এটা ভবিষ্যতে ঘটবে| কারণ ইমোরীয়রা এখনও আমার কাছে শাস্তি পাওয়ার মত খারাপ হয় নি|” ");
INSERT INTO ben2006_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","সূর্য অস্ত গেলে গাঢ় অন্ধকার ঘনাল| দুখণ্ড করা মৃত পশুগুলি তখনও মাটির উপরে পড়ে আছে| সেই সময় আগুন ও ধোঁয়ার স্তম্ভ মৃত পশুগুলির অর্ধেক খণ্ডগুলির মধ্য দিয়ে চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","সুতরাং ঐদিন প্রভু অব্রামকে একটা প্রতিশ্রুতি দিলেন এবং সেই অনুসারে অব্রামের সঙ্গে একটা চুক্তি করলেন| প্রভু বললেন, “এই দেশ আমি তোমার উত্তরপুরুষদের দেব| মিশর নদ এবং ফরাৎ নদের মধ্যবর্তী বিশাল ভূভাগ আমি তাদের দেব| ");
INSERT INTO ben2006_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","এটা হল কেনীয়, কনিষীয়, কদ্মোনীয়, ");
INSERT INTO ben2006_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিত্তীয়, পরিষীয়, রফায়ীয়, ");
INSERT INTO ben2006_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ইমোরীয়, কনানীয়, গির্গাশীয় এবং যিবুষীয় বংশগুলির দেশ|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","সারী ছিল অব্রামের স্ত্রী| তার ও অব্রামের কোনও সন্তানাদি ছিল না| সারী মিশর থেকে একজন দাসী এনেছিল| তার নাম হাগার| ");
INSERT INTO ben2006_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","সারী অব্রামকে বললেন, “প্রভু আমায় সন্তান ধারণের ক্ষমতা দেন নি| তাই তুমি আমার দাসী হাগারের কাছে যাও| আমাকে একটি সন্তান দাও এবং আমি সেই সন্তানকে নিজের বলে গ্রহণ করবো|” অব্রাম সারীর নির্দেশ অনুসরণ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","অব্রাম কনানে দশ বছর বাস করার পরে এই ঘটনা ঘটে| সারী হাগারকে তাঁর স্বামী অব্রামের কাছে পাঠালো| (হাগার ছিল তাঁর মিশরীয় দাসী|) ");
INSERT INTO ben2006_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","অব্রামের দ্বারা হাগার গর্ভবতী হলো| যখন সে একথা জানতে পারল সে খুব গর্বিতা হয়ে উঠল এবং ভাবল সে তার প্রভু পত্নী সারীর চেয়ে ভাল| ");
INSERT INTO ben2006_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","কিন্তু সারী অব্রামকে বলল, “আমার দাসী এখন আমাকেই তিরস্কার করে এবং এর জন্যে তুমি দায়ী| আমিই তাকে তোমার কাছে পাঠিয়েছিলাম| সে গর্ভবতী হল| এখন সে নিজেকে আমার চেয়ে ভাল মনে করে| প্রভু বিচার করুন যে কোনটা ঠিক|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","কিন্তু অব্রাম সারীকে বলল, “তুমিই হাগারের গৃহকর্ত্রী| তোমার যে রকম ইচ্ছে সে রকমভাবেই তুমি হাগারের ব্যবস্থা করবে|” ফলে সারী তাঁর দাসী হাগারকে দুঃখ দিলেন এবং হাগার সেখান থেকে পালিয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","মরুভূমির মধ্যে এক জলপূর্ণ কূপের পাশে প্রভুর দূত হাগারকে দেখতে পেল| জলাশয়টি ছিল শূর যাওয়ার পথে| ");
INSERT INTO ben2006_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","সেই দূত বলল, “হাগার তুমি তো সারীর পরিচারিকা| তুমি এখানে কেন? তুমি কোথায় যাচ্ছো?” হাগার বলল, “আমি সারীর কাছ থেকে পালাচ্ছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","প্রভুর দূত হাগারকে বলল, “সারী তোমার গৃহকর্ত্রী| তার কাছে ফিরে যাও| তার বাধ্য হও|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","হাগারকে প্রভুর দূত আরও বলল, “তোমার থেকে বিশাল জনসমষ্টি সৃষ্টি হবে| এত বিপুল জনসংখ্যা হবে যে তাদের গুনে শেষ করা যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","প্রভুর দূত আরও বলল, “হাগার, এখন তুমি গর্ভবতী, তুমি হবে এক পুত্রের জননী| পুত্রের নাম দেবে ইশ্মায়েল, কারণ প্রভু শুনেছেন তোমার উপর দুর্ব্যবহার হয়েছে, তিনি তোমাকে সাহায্য করবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ইশ্মায়েল স্বাধীন এবং উদ্দাম হবে যেমন উদ্দাম হয় বন্য গাধা| সে সবার বিরুদ্ধে দাঁড়াবে এবং সবাই হবে তার প্রতিপক্ষ| সে স্থান থেকে স্থানান্তরে ঘুরে বেড়াবে এবং ভাইদের বসতির কাছে তাঁবু গাড়বে|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","প্রভু হাগারের সঙ্গে কথা বললেন| হাগার ঈশ্বরের এক নতুন নাম দিল| সে তাঁকে বলল, “আপনি হলেন ঈশ্বর যিনি আমায় দেখেন|” সে এই কথা বলল কারণ সে ভাবল, “এরকম জায়গাতেও ঈশ্বর আমায় দেখতে পাচ্ছেন, আমার ভালমন্দের কথা চিন্তা করছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","সুতরাং ঐ কূপের নাম হল বের-লহয়-রোয়ী| কাদেশ এবং বেরদ অঞ্চলের মধ্যে ঐ কূপের অবস্থান| ");
INSERT INTO ben2006_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","হাগার অব্রামের পুত্রের জন্ম দিল| সে অব্রাম পুত্রের নাম দিল ইশ্মায়েল| ");
INSERT INTO ben2006_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","যখন হাগারের গর্ভে ইশ্মায়েলের জন্ম হয় তখন অব্রামের বয়স 86 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","অব্রামের 99 বছর বয়স হলে প্রভু তাঁর সামনে আবির্ভূত হলেন| প্রভু বললেন, “আমি সর্বশক্তিমান ঈশ্বর| আমার জন্য এই কাজগুলি করো: আমার কথামত চলো এবং সৎ পথে জীবনযাপন করো| ");
INSERT INTO ben2006_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","এটা যদি করো তাহলে আমাদের মধ্যে একটা চুক্তির ব্যবস্থা করব| আমি প্রতিশ্রুতি করছি যে তোমার বংশধরদের আমি এক মহান জাতিতে পরিণত করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","তখন অব্রাম ঈশ্বরের সামনে প্রণামে নত হলেন| ঈশ্বর তাঁকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“আমাদের চুক্তিতে এটি আমার অংশ| আমি তোমাকে বহু জাতির পিতা করব| ");
INSERT INTO ben2006_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","আমি তোমার নাম পরিবর্তন করব| তোমার নাম অব্রামের পরিবর্তে অব্রাহাম হবে| আমি তোমায় এই নাম দিচ্ছি কারণ আমি তোমায় বহু জাতির পিতা করছি| ");
INSERT INTO ben2006_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","আমি তোমার বংশ অতিশয় বৃদ্ধি করব| তোমার থেকে নতুন নতুন জাতির এবং রাজার জন্ম হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","এবং তোমার ও আমার মধ্যে এক চুক্তি সম্পন্ন হবে| তোমার সমস্ত উত্তরপুরুষগণের জন্যও এই একই চুক্তি প্রযোজ্য হবে| এই চুক্তি চিরকাল বহাল থাকবে| আমি তোমার ও তোমার উত্তরপুরুষগণের জন্য ঈশ্বর থাকব| ");
INSERT INTO ben2006_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","আমি তোমাকে এবং তোমার সব উত্তরপুরুষদের এই কনান দেশ দেব যার মধ্য দিয়ে তোমরা যাত্রা করছ| আমি তোমাকে এই দেশ চিরকালের জন্য দেব| আমি হব তোমার ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","এবং ঈশ্বর অব্রাহামকে বললেন, “এখন তোমার দিক থেকে এই চুক্তি হবে এই রকম| তুমি এবং তোমার উত্তরপুরুষগণ আমার চুক্তি মান্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","এটাই চুক্তি যা তুমি মেনে চলবে| তোমার ও আমার মধ্যে এটাই হল চুক্তি| তোমার উত্তরপুরুষগণের জন্যেও এটাই চুক্তি| যত পুত্র সন্তান হবে প্রত্যেককে সুন্নত করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","তোমার আর আমার মধ্যে চুক্তি যে তুমি মেনে চলবে, এই সুন্নত হবে তার প্রমাণস্বরূপ| ");
INSERT INTO ben2006_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","শিশু পুত্রের বয়স আট দিন হলে এই সুন্নত সম্পন্ন করবে| তোমার পরিবারে যত ছেলের এবং তোমার দাসদের মধ্যে যত ছেলের জন্ম হবে, তোমার বংশধর নয় এমন বিদেশীদের কাছ থেকে তোমার অর্থ দিয়ে তুমি যে দাসদের কিনেছিলে তাদের যে ছেলেরা জন্মাবে, সকলের অবশ্যই সুন্নত করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","সুতরাং তোমার জাতির প্রত্যেক শিশু পুত্রকে সুন্নত করা হবে| তোমার পরিবারের অথবা ক্রীতদাসের সব পুত্রদের এভাবে সুন্নত করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","অব্রাহাম, তোমার ও আমার মধ্যে এটাই চুক্তি; সুন্নত করা হয়নি এমন কোন পুরুষ থাকলে সে হবে তার নিজের লোকদের স্বজাতির থেকে বিচ্ছিন্ন| কারণ সে ব্যক্তি আমার চুক্তি ভঙ্গকারী|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ঈশ্বর অব্রাহামকে বললেন, “তোমার স্ত্রী সারীকে আমি এক নতুন নাম দেব| তার নতুন নাম হবে সারা অর্থাৎ‌ রানী| ");
INSERT INTO ben2006_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","আমি তাকে আশীর্বাদ করব| আমি তাকে একটি পুত্র দেব এবং তুমি হবে সেই পুত্রের পিতা| সারা হবে বহু নতুন জাতির মাতা| সারা থেকে আসবে বহু জাতির বহু রাজা|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ঈশ্বরকে যে তিনি মান্য করেন এই কথা বোঝাবার জন্যে অব্রাহাম আভূমি মাথা নত করলেন| কিন্তু তিনি নিজের মনে হেসে বললেন, “আমার 100 বছর বয়স| আমার আর সন্তান হতে পারে না| এবং সারার 90 বছর বয়স| সে সন্তানের জন্ম দিতে পারবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","তখন অব্রাহাম ঈশ্বরকে বলল, “আশা করি ইশ্মায়েল বেঁচে থেকে আপনার সেবা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ঈশ্বর বললেন, “না! আমি বলেছি যে তোমার স্ত্রী সারার একটি পুত্র হবে| তুমি তার নাম দেবে ইসহাক| তার সঙ্গে আমি আমার চুক্তি সম্পাদন করব| তার সঙ্গে ঐ চুক্তি এমন হবে যা তার উত্তরপুরুষগণের সঙ্গেও চিরকাল বজায় থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“তুমি ইশ্মায়েলের কথা বলেছ এবং আমি সে কথা শুনেছি| আমি তাকে আশীর্বাদ করব| তার বহু সন্তানসন্ততি হবে| সে বারোজন মহান নেতার পিতা হবে| তার পরিবার থেকে সৃষ্টি হবে এক মহান জাতির| ");
INSERT INTO ben2006_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","কিন্তু আমি ইসহাকের সঙ্গে চুক্তিবদ্ধ হব| সারার যে পুত্র হবে সে-ই হবে ইসহাক পরের বছর ঠিক এই সময় সেই পুত্রের জন্ম হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","অব্রাহামের সঙ্গে কথা শেষ করে ঈশ্বর উপরে স্বর্গে চলে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ঈশ্বর অব্রাহামকে তাঁর পরিবারের সমস্ত পুরুষ ও বালকের সুন্নতের কথা বলেছিলেন| সুতরাং অব্রাহাম ইশ্মায়েল এবং তাঁর গৃহে জন্ম হয়েছে এমন সমস্ত দাসদের একত্রে সমবেত করলেন| যাদের অর্থ দিয়ে ক্রয় করা হয়েছিল, সেই ক্রীতদাসদেরও তিনি সমবেত করলেন| অব্রাহামের বাড়ীর প্রত্যেক পুরুষ ও বালককে একত্র করা হল| এবং প্রত্যেককে সুন্নত করা হল| তাদের সকলকে একই দিনে সুন্নত করা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","অব্রাহামকে যখন সুন্নত করা হল তখন তাঁর বয়স 99 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","এবং তাঁর পুত্র ইশ্মায়েলের সুন্নতের সময় 13 বছর বয়স ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","অব্রাহাম ও তাঁর পুত্রের একই দিনে সুন্নত করা হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","সেই একই দিনে অব্রাহামের বাড়ীর সমস্ত পুরুষেরাও সুন্নত হয়| যেসব দাসদের অর্থ দিয়ে ক্রয় করা হয়েছিল এবং যেসব দাসদের তাঁর গৃহেই জন্ম হয়েছিল সকলেরই সুন্নত করা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","পরে প্রভু পুনরায় অব্রাহামের সামনে আবির্ভূত হলেন| মম্রির ওক বৃক্ষগুলির কাছে অব্রাহাম বাস করছিলেন| একদিন অব্রাহাম নিজের তাঁবুর প্রবেশ পথে বসেছিলেন| তখন দিনের সবচেয়ে চড়া গরমের সময়| ");
INSERT INTO ben2006_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","অব্রাহাম চোখ তুলে দেখলেন যে তাঁর সামনে তিনজন আগন্তুক দাঁড়িয়ে| তাঁদের দেখে অব্রাহাম তাঁদের কাছে গিয়ে অভিবাদন জানালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","অব্রাহাম বললেন, “মহাশয়গণ, আমি আপনাদের সেবক, আমার এখানে আপনারা কিছুক্ষণ অবস্থান করুন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","আপনাদের পা ধোয়ার জন্য আমি জল এনে দিচ্ছি| আপনারা গাছের ছায়ায় বিশ্রাম করুন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","আমি আপনাদের খাবারের ব্যবস্থা করছি এবং আপনারা ইচ্ছামত আহার করে আবার আপনাদের গন্তব্যস্থল অভিমুখে যাত্রা করতে পারেন|” ঐ তিনজন বললেন, “বেশ কথা! যেমন বললেন, আমরা তেমনই করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","অব্রাহাম তাড়াতাড়ি তাঁবুর ভেতরে গেলেন| অব্রাহাম সারাকে বললেন, “চট করে তিনজনের মত রুটির ব্যবস্থা করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","তারপর অব্রাহাম তাঁর গোয়ালে দৌড়ে গেলেন| সবচেয়ে ভাল বাছুরটা বেছে নিলেন| অব্রাহাম তখনই এক ভৃত্যকে ওটাকে মেরে রান্না করার জন্যে বললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","তারপর অব্রাহাম সেই মাংস আর খানিকটা দুধ ও পনীর এনে অতিথি তিনজনের সামনে রাখলেন| পরিবেশন করার জন্য অব্রাহাম সামনে দাঁড়িয়ে থাকলেন এবং তাঁরা গাছের ছায়ায় বসে ভোজন করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","তারপর তাঁরা জিজ্ঞাসা করলেন, “তোমার স্ত্রী সারা কোথায়?” অব্রাহাম বললেন, “ওখানে ঐ তাঁবুর মধ্যে|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","তখন প্রভু বললেন, “আমি আবার বসন্তকালে আসব| তখন তোমার স্ত্রী সারার একটি পুত্র হবে|” তাঁবুর ভেতর থেকে সারা সমস্ত কথাবার্তা শুনছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","অব্রাহাম ও সারা তখন রীতিমত বৃদ্ধ-বৃদ্ধা| সন্তান জন্ম দেওয়ার বয়স সারা অনেকদিন আগে পার হয়ে এসেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","স্বভাবতই সারা যা শুনলেন তা বিশ্বাস করলেন না| নিজের মনে মনে সারা হেসে বললেন, “আমি বৃদ্ধা হয়েছি আর আমার স্বামীও বৃদ্ধ| সন্তান প্রসবের পক্ষে আমার অনেক বেশী বয়স হয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","তখন প্রভু অব্রাহামকে বললেন, “সারা হাসছে| সারা ভাবছে যে সন্তানের জন্ম দেওয়ার পক্ষে তার অনেক বেশী বয়স হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","কিন্তু প্রভুর পক্ষে কি কোনও কাজ খুব কঠিন? না! আমি যেমন বলেছি, আবার বসন্তকালে, তেমনই আসব এবং তোমার স্ত্রী সারার তখন সন্তান হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","কিন্তু সারা বলল, “আমি হাসি নি!” (একথা বললেন কারণ তিনি ভয় পেয়েছিলেন|) কিন্তু প্রভু বললেন, “না! আমি জানি, তা সত্যি নয়! তুমি হেসেছিলে!” ");
INSERT INTO ben2006_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","তারপর সেই তিনজন আগন্তুক যাওয়ার জন্য উঠে দাঁড়ালেন| সদোমের দিকে দৃষ্টি নিক্ষেপ করলেন এবং সদোম অভিমুখে চলতে শুরু করলেন| তাঁদের এগিয়ে দেওয়ার জন্য অব্রাহামও তাঁদের সঙ্গে সঙ্গে হাঁটতে শুরু করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","প্রভু আপন মনে বললেন, “এখন আমি কি করব তা কি অব্রাহামকে বলব? ");
INSERT INTO ben2006_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","অব্রাহাম থেকে জন্মলাভ করবে এক মহান ও শক্তিশালী জাতি এবং অব্রাহামের জন্যেই পৃথিবীর সমস্ত মানুষ আশীর্বাদ প্রাপ্ত হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","আমি অব্রাহামের সাথে এক বিশেষ চুক্তি করেছি| প্রভুর ইচ্ছা অনুসারে জীবনযাপনের জন্য যাতে অব্রাহামের সন্তানসন্ততি ও উত্তরপুরুষগণ অব্রাহামের আজ্ঞা পালন করে তাই এই ব্যবস্থা করেছি| এটা করেছি যাতে তারা ন্যায়পরায়ণ হয় ও সৎ‌‌ জীবনযাপন করে| তাহলে আমি প্রভু, প্রতিশ্রুত জিনিসগুলি দিতে পারব|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","তারপরে প্রভু বললেন, “যে নিদারুণ পাপ সেখানে সংঘটিত হচ্ছে, তার জন্য আমি সদোম এবং ঘমোরার বিরুদ্ধে তীব্র আর্তনাদ শুনেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","যত খারাপ বলে শুনেছি তা সত্যিই তত খারাপ কিনা তা আমি নিজে গিয়ে দেখব| তাহলে আমি নিশ্চিতভাবে সব জানব|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","তখন তাঁরা তিনজন সদোম অভিমুখে হাঁটতে শুরু করলেন| কিন্তু অব্রাহাম প্রভুর সামনে দাঁড়িয়ে রইলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","অব্রাহাম প্রভুর কাছে এলেন এবং জিজ্ঞেস করলেন, “প্রভু, আপনি কি ভাল লোকেদেরও ধ্বংস করবেন যেমন আপনি মন্দ লোকেদের ধ্বংস করেন? ");
INSERT INTO ben2006_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","সদোম নগরে যদি 50 জনও ভাল লোক থাকে তাহলে আপনি কি করবেন? তাহলেও কি আপনি নগরটা ধ্বংস করবেন? নিশ্চয়ই আপনি ঐ নগরবাসী 50 জন ভাল লোকের জন্য নগরটা রক্ষা করবেন? ");
INSERT INTO ben2006_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","তাহলে আপনি নিশ্চয়ই ঐ নগরটা বা ঐ খারাপ লোকদের ধ্বংস করতে গিয়ে ঐ 50 জন ভাল লোকদেরও ধ্বংস করবেন না? যদি তা করেন তাহলে ভাল এবং মন্দ লোকেদের একই পরিণতি হবে| তার অর্থ, ভাল এবং মন্দ জাতীয় উভয় লোকদেরই মৃত্যুদণ্ড দেওয়া হবে| আপনি সমস্ত পৃথিবীর বিচারক| আমি জানি আপনি ঠিক বিচারই করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","তখন প্রভু বললেন, “আমি যদি সদোম নগরে 50 জন ভাল লোক পাই তাহলে আমি সমগ্র নগরটাকেই রক্ষা করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","তখন অব্রাহাম বললেন, “আপনার তুলনায় আমি নেহাতই ধুলো আর ছাই| কিন্তু একটা প্রশ্ন করে আবার আপনাকে বিরক্ত করছি| ");
INSERT INTO ben2006_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","যদি ভাল লোকদের থেকে 5 জনকে খুঁজে না পাওয়া যায় তখন কি করবেন? নগরে যদি মাত্র 45 জন ভাল লোক থাকে? মাত্র 5 জনকে পাওয়া গেল না বলে কি আপনি গোটা নগর ধ্বংস করে ফেলবেন?” তখন প্রভু বললেন, “যদি আমি 45 জন ভাল লোককেও পাই তাহলে ঐ নগর ধ্বংস করব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","অব্রাহাম আবার বললেন, “সেখানে গিয়ে আপনি যদি মাত্র 40 জন ভাল লোককে পান তাহলে কি আপনি পুরো নগর ধ্বংস করবেন?” প্রভু বললেন, “আমি যদি 40 জন ভাল লোককেও পাই তাহলে আমি নগরটা ধ্বংস করব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","অব্রাহাম বললেন, “প্রভু দয়া করে আমার ওপর রাগ করবেন না| একটা প্রশ্ন করি! যদি নগরে মাত্র 30 জন ভাল লোককে পান তাহলেও কি আপনি ঐ নগর ধ্বংস করবেন?” তখন প্রভু বললেন, “আমি যদি 30 জন ভাল লোক পাই তাহলে নগরটা ধ্বংস করব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","তখন অব্রাহাম বললেন, “আপনাকে কি আর একবার বিরক্ত করতে পারি? যদি সেখানে মাত্র 20 জন ভাল লোক পান তাহলে কি করবেন?” প্রভু বললেন, “আমি যদি 20 জন ভাল লোক পাই তাহলে আমি নগরটা ধ্বংস করবো না|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","তখন অব্রাহাম বললেন, “প্রভু দয়া করে রাগ করবেন না, কিন্তু শেষবারের মতো আর একটি প্রশ্ন দিয়ে আপনাকে বিরক্ত করি| আপনি যদি সেখানে মাত্র 10 জন ভাল লোক পান তাহলে আপনি কি করবেন?” প্রভু বললেন, “ঐ নগরে 10 জন ভাল লোক পেলেও আমি তা ধ্বংস করব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","প্রভুর অব্রাহামকে যা বলার ছিল, সব বলা হয়ে গেল| এবার প্রভু তাঁর পথে চলে গেলেন এবং অব্রাহাম নিজের বাসস্থানে ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","2","সেদিন সন্ধ্যায় সদোম নগরে দুজন দূত এলেন| তখন লোট নগরের প্রবেশ পথে বসেছিলেন| তিনি দূতদের আসতে দেখলেন| লোট ভাবলেন যে তারা সাধারণ পথিক, নগরের মধ্য দিয়ে কোথাও যাচ্ছে| লোট উঠে গিয়ে তাঁদের অভিবাদন করে বললেন, “মহাশয়গণ, অনুগ্রহ করে একবার আমার বাড়ীতে আসুন এবং আপনাদের সেবা করার সুযোগ দিন| সেখানে আপনারা হাত-পা ধুয়ে রাত্রিবাস করতে পারেন| তাহলে কাল সকালে আবার আপনাদের গন্তব্যস্থল অভিমুখে যাত্রা করতে পারবেন|” দূত দুজন বললেন, “না, আমরা চকেই রাত্রিবাস করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","কিন্তু লোট নিজের বাড়ীতে তাঁদের নিয়ে যাওয়ার জন্যে পীড়াপীড়ি করতে লাগলেন| তাই দূতরা শেষ পর্যন্ত লোটের বাড়ীতে থেকে রাজী হলেন| তাঁরা লোটের বাড়ীতে গেলেন| লোট তাঁদের কিছু পানীয় দিলেন| লোট তাঁদের রুটি বানিয়ে দিলেন এবং তাঁরা সেই রুটি খেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","সেদিন সন্ধ্যায় ঘুমোতে যাওয়ার ঠিক আগে, নগরের নানা প্রান্ত থেকে নানা বয়সের বহু লোক লোটের বাড়িতে এল| সদোমের সেইসব লোকেরা লোটের বাড়ী ঘিরে ফেলল এবং লোটকে চিৎকার করে ডাকতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","তারা বলল, “আজ সন্ধ্যায় যারা এসেছে, কোথায় তারা? তাদের বাইরে নিয়ে এস–আমরা তাদের সাথে যৌন সহবাস করতে চাই|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","লোট বাইরে বেরিয়ে এসে দরজা বন্ধ করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","সেই জনতার উদ্দেশ্যে লোট বলল, “না! বন্ধুরা, আমি মিনতি করছি, এমন খারাপ কাজ কোরো না| ");
INSERT INTO ben2006_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","দেখ, আমার দুটি মেয়ে আছে–কোনও পুরুষ তাদের স্পর্শ করে নি| তোমাদের জন্য আমি নিজের কন্যাদের দেব| তোমরা তাদের নিয়ে যা খুশী করতে পারো| কিন্তু দয়া করে এই অতিথি দুজনের প্রতি কিছু কোরো না| এই দুজন আমার ঘরে এসেছে এবং আমার অবশ্যই এদের রক্ষা করা উচিৎ‌|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","যেসব লোকেরা লোটের বাড়ী ঘিরে রেখেছিল তারা উত্তর দিল, “আমাদের পথ থেকে সরে যাও|” তারপর তারা নিজেদের মধ্যে বলাবলি করল, “এই লোকটা একদিন অতিথি হিসেবে আমাদের নগরে বাস করতে এসেছিল| এখন জ্ঞান দিচ্ছে, আমরা কি করব না করব!” তখন সেই লোকেরা লোটকে বলল, “এখন তোমার প্রতি ওদের চেয়ে আরও বেশী খারাপ ব্যবহার করব|” অতএব সেই জনতা লোটের দিকে এগিয়ে যেতে থাকল| ক্রমে দরজা ভেঙ্গে ফেলার উপক্রম| ");
INSERT INTO ben2006_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","কিন্তু যে দুজন পুরুষ লোটের বাড়িতে আশ্রয় নিয়েছিলেন তাঁরা হঠাৎ‌‌ দরজা খুলে বেরিয়ে এসে লোটকে ভেতরে টেনে নিয়ে গেলেন এবং ভেতর থেকে দরজা বন্ধ করে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","তারপর তাঁরা বাইরের মারমুখো জনতার জন্য কিছু একটা করলেন| ফলে যুবক, বৃদ্ধ, সব বদমাশ লোকেরা অন্ধ হয়ে গেল| এর ফলে যারা বাড়ির ভেতর জোর করে ঢোকার চেষ্টা করছিল তারা ভেতরে ঢোকার দরজাই খুঁজে পেল না| ");
INSERT INTO ben2006_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","অতিথি দুজন লোটকে জিজ্ঞেস করলেন, “তোমার পরিবারের আর কেউ কি এই শহরে বাস করে? তোমার জামাই, ছেলে, মেয়ে কিংবা পরিবারের আর কেউ কি এখানে আছে? যদি থাকে তাহলে তাদের এখনই এই জায়গা ছেড়ে চলে যাওয়ার জন্য বলো| ");
INSERT INTO ben2006_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","আমরা এই নগর ধ্বংস করে দেব| এই নগর যে কত খারাপ তা প্রভু শুনেছেন| তাই এই নগর ধ্বংস করে দেওয়ার জন্য তিনি আমাদের পাঠিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","তখন লোট বেরিয়ে গিয়ে তাঁর অন্যান্য মেয়েদের যারা বিয়ে করেছে সেই মেয়েদের স্বামীদের অর্থাৎ‌ জামাইদের সঙ্গে কথা বললেন| লোট বলল, “তাড়াতাড়ি করো! এক্ষুনি এই জায়গা ছেড়ে চলে যাও! প্রভু এখনই এই জায়গা ধ্বংস করবেন|” কিন্তু তারা ভাবল, লোট বোধহয় তামাশা করছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","পরদিন ভোরে সেই দূতরা লোটকে তাড়া দিলেন| তাঁরা বললেন, “এই নগরবাসীদের শাস্তি দেওয়া হবে| সুতরাং তুমি, তোমার স্ত্রী এবং যে দুজন মেয়ে তোমার কাছে থাকে তাদের নিয়ে শীঘ্রই এই জায়গা ছেড়ে চলে যাও| তাহলে এই নগরের সঙ্গে তোমরা আর ধ্বংস হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","কিন্তু লোটের সব গুলিয়ে গেল এবং তিনি নগর ছেড়ে যাওয়ার ব্যাপারে তাড়া করলেন না| সুতরাং ঐ দুজন লোট এবং তাঁর স্ত্রীর এবং দুই মেয়ের হাত চেপে ধরল| ঐ দুজন লোট এবং তাঁর পরিবারকে নিরাপদে নগরের বাইরে নিয়ে গেলেন| লোট এবং তাঁর পরিবারের প্রতি প্রভু দয়ালু ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","তাই ঐ দুজন লোট এবং তাঁর পরিবারকে নগরের বাইরে নিয়ে এলেন| তাঁরা নগরের বাইরে চলে এলে সেই দুজন দুতের একজন বললেন, “এবার প্রাণ বাঁচাবার জন্য তোমরা দৌড় দাও! আর পেছনের দিকে তাকাবে না| উপত্যকার কোনও জায়গাতে দাঁড়াবে না| যতক্ষণ না ঐ পর্বতে পৌঁছবে ততক্ষণ শুধুই দৌড়বে| থামলে, নগরের সঙ্গে তোমরাও ধ্বংস হয়ে যাবে!” ");
INSERT INTO ben2006_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","কিন্তু লৌট এই দুজনকে বললেন, “মহাশয়গণ, দয়া করে আমায় অত দূরে দৌড়ে যেতে বলবেন না! ");
INSERT INTO ben2006_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","আমি আপনাদের সেবকমাত্র, তবু আমার প্রতি আপনাদের অসীম দয়া| দয়া করে আমার জীবন রক্ষা করেছেন| কিন্তু ঐ পর্বত পর্যন্ত সমস্ত পথ দৌড়োবার ক্ষমতা আমার নেই| যদি আমি খুব ধীরে যাই তবে বিপদ ঘটবে এবং আমি নিহত হব! ");
INSERT INTO ben2006_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","দেখুন, এখানে কাছেই একটা খুব ছোট শহর আছে| আমি সেই শহর পর্যন্ত দৌড়ে বেঁচে যেতে পারি|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","দূত লোটকে বললেন, “ভালো কথা আমি তোমার অনুরোধ স্বীকার করেছি| আমি তোমাকে সেটা করতে দেব| আমি ঐ শহর ধ্বংস করব না| ");
INSERT INTO ben2006_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","কিন্তু সেখানে শীঘ্রই দৌড়ে যাও| যতক্ষণ না নিরাপদে ঐ শহরে তুমি পৌঁছোচ্ছ ততক্ষণ সদোম ধ্বংস করতে পারব না|” (ঐ শহরের নাম সোয়র কারণ শহরটি খুব ছোট|) ");
INSERT INTO ben2006_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","সূর্যোদয়ের সঙ্গে সঙ্গে লোট সোয়রে পৌঁছলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","একই সময়ে প্রভু সদোম ও ঘমোরা ধ্বংস করা শুরু করলেন| প্রভু আকাশ থেকে আগুন আর জ্বলন্ত গন্ধক বর্ষণ শুরু করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","অর্থাৎ‌ প্রভু ঐ নগরগুলি ধ্বংস করলেন| সমস্ত গাছপালা, সমস্ত লোকজন, সমগ্র উপত্যকাটাই প্রভু ধ্বংস করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","লোট যখন স্ত্রী ও দুই মেয়েকে নিয়ে দৌড়ে পালাচ্ছিলেন তখন লোটের স্ত্রী নিষেধ ভুলে একবার পেছনে নগরের দিকে তাকালেন এবং তখনই লবণের মূর্ত্তি হয়ে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","খুব সকালে অব্রাহাম আগে যেখানটাতে প্রভুর সামনে দাঁড়িয়েছিলেন সেই স্থানটিতে তিনি আবার গিয়ে দাঁড়ালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","অব্রাহাম সদোম এবং ঘমোরার দিকে তাকিয়ে দেখলেন| সমগ্র উপত্যকার ওপর দৃষ্টিপাত করে অব্রাহাম দেখলেন যে সমস্ত উপত্যকা থেকে ধোঁয়া উঠছে| দেখে মনে হল বিশাল অগ্নিকাণ্ডের ফলস্বরূপ ঐ ধোঁয়া| ");
INSERT INTO ben2006_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ঈশ্বর উপত্যকার সমস্ত নগর ধ্বংস করলেন| কিন্তু ঈশ্বর ঐ নগরগুলি ধ্বংস করার সময় অব্রাহামের কথা মনে রেখেছিলেন এবং তিনি অব্রাহামের ভ্রাতুষ্পুত্রকে ধ্বংস করেন নি| লোট ঐ উপত্যকার নগরগুলির মধ্যে বাস করছিলেন| কিন্তু নগরগুলি ধ্বংস করার আগে ঈশ্বর লোটকে অন্যত্র পাঠিয়ে দিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","সোয়রে বাস করতে লোটের ভয় করছিল| তাই তিনি ও তাঁর দুই মেয়ে পর্বতে বাস করতে চলে গেলেন| সেখানে তাঁরা একটা গুহার মধ্যে বাস করতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","দুজনের মধ্যে যে মেয়ে বড় সে একদিন ছোট বোনকে বলল, “পৃথিবীতে সর্বত্র স্ত্রী ও পুরুষ বিয়ে করে এবং তাদের সন্তানাদি হয়| কিন্তু আমাদের পিতা বৃদ্ধ হয়েছেন এবং আমাদের সন্তানাদি দিতে পারে এমন অন্য পুরুষ এখানে নেই| ");
INSERT INTO ben2006_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","তাই আমরা পিতাকে প্রচুর দ্রাক্ষারস পান করিয়ে বেহুঁশ করিয়ে দেব| তারপর তাঁর সঙ্গে আমরা যৌনসঙ্গম করব| আমাদের পরিবার রক্ষা করার জন্য আমরা এইভাবে আমাদের পিতার সাহায্য নেব!” ");
INSERT INTO ben2006_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","সেই রাত্রে দু মেয়ে তাদের পিতার কাছে গেল এবং তাঁকে প্রচুর দ্রাক্ষারস পান করতে দিল| তারপর বড় মেয়ে পিতার বিছানায় গিয়ে তাঁর সঙ্গে যৌন সঙ্গম করল| লোট এমন নেশাগ্রস্ত ছিলেন যে তাঁর বিছানায় কে কখন এল এবং কে কখন গেল কিছুই বুঝতে পারলেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","পরদিন ছোট বোনকে বড় বোন বলল, “গত রাত্রে আমি পিতার সঙ্গে এক বিছানায় শুয়েছি| আজ রাতে আবার তাঁকে দ্রাক্ষারস পান করিয়ে বেহুঁশ করে দেব| তাহলে তুমি তাঁর সঙ্গে যৌন সঙ্গম করতে পারবে| এভাবে আমরা সন্তানাদি পেতে আমাদের পিতার সাহায্য নেব| এতে আমাদের বংশধারা অব্যাহত থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","সুতরাং সেই রাত্রে দু মেয়ে আবার পিতাকে নেশাতে বেহুঁশ করে দিল| তারপর ছোট মেয়ে পিতার বিছানায় গিয়ে পিতার সঙ্গে যৌন সঙ্গম করল| এবারেও লোট এমন নেশাগ্রস্ত ছিলেন যে জানতে পারলেন না কে তার বিছানায় এল, কে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","লোটের দু মেয়েই গর্ভবতী হল| তাদের পিতাই তাদের সন্তানাদির পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","বড় মেয়ের হল এক পুত্র সন্তান| তার নাম হল মোয়াব| বর্তমানে যে মোয়াবীয় জাতি আছে তাদের আদিপুরুষ হলেন মোয়াব| ");
INSERT INTO ben2006_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ছোট মেয়েও এক পুত্র সন্তানের জন্ম দিল| তার নাম বিন্-অম্মি| বর্তমানে যে অম্মোন জাতি আছে তাদের আদিপুরুষ হলেন বিন্-অম্মি| ");
INSERT INTO ben2006_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","অব্রাহাম পূর্বের বাসস্থান ত্যাগ করে নেগেভে গেলেন| তিনি কাদেশ এবং শূরের মধ্যবর্তী গরার নগরে বাস করা শুরু করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","গরারে বাস করার সময় অব্রাহাম সবাইকে বললেন যে সারা তাঁর বোন| গরারের রাজা অবীমেলক সে কথা শুনলেন| অবীমেলক সারাকে কামনা করলেন, তাই সারাকে নিয়ে আসার জন্য কয়েকজন ভৃত্যকে পাঠালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","কিন্তু রাত্রে ঈশ্বর স্বপ্নে অবীমেলকের কাছে এলেন| ঈশ্বর বললেন, “তোমার মরণ ঘনিয়ে এসেছে| যে নারীকে তুমি এনেছ সে বিবাহিতা|” ");
INSERT INTO ben2006_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","কিন্তু অবীমেলক তখন পর্যন্ত সারাকে শয্যার সঙ্গিনী করেন নি| তাই অবীমেলক বললেন, “প্রভু, আমি তো অপরাধ করিনি| আপনি কি একজন নিরপরাধকে হত্যা করবেন? ");
INSERT INTO ben2006_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","অব্রাহাম নিজে আমায় বলেছে যে, এই নারী তার বোন| আর ঐ নারীও বলেছে যে, ঐ পুরুষ তার ভাই| আমি তো কোন অপরাধ করিনি| আমি তো জানতামই না যে আমি কি করছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","তখন ঈশ্বর স্বপ্নের মধ্যে অবীমেলককে বললেন, “হ্যাঁ, আমি জানি তুমি নির্দোষ এবং এটাও জানি যে তুমি কি করছ তা তুমি জানতে না| তোমায় আমি বাঁচিয়ে দিয়েছি| আমি তোমাকে আমার বিরুদ্ধে পাপ করতে দিই নি| আমিই তোমায় ঐ নারীকে শয্যায় নিয়ে যেতে দিই নি| ");
INSERT INTO ben2006_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","সুতরাং তুমি অব্রাহাম ও তার স্ত্রীকে ফিরিয়ে দাও| অব্রাহাম একজন ভাববাদী| সে তোমার জন্য প্রার্থনা করবে এবং তুমি তাতে জীবন লাভ করবে| কিন্তু তুমি যদি অব্রাহাম ও তার স্ত্রীকে ফিরিয়ে না দাও তাহলে আমি নিশ্চিত যে তোমার মৃত্যু আসন্ন এবং তোমার সমস্ত পরিবারেরও মৃত্যু হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","সুতরাং পরদিন খুব সকালে অবীমেলক তাঁর ভৃত্যদের ডেকে তাঁর স্বপ্নের কথা বললেন| তাঁর স্বপ্নের কথা শুনে ভৃত্যরা খুব ভীত হয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","তখন অবীমেলক অব্রাহামকে ডেকে পাঠিয়ে জিজ্ঞাসা করলেন, “কেন আপনি আমাদের প্রতি এরকম ব্যবহার করলেন? আমি আপনার প্রতি কি অন্যায় করেছি? কেন মিথ্যে বললেন যে ঐ নারীটি আপনার বোন? আমার রাজত্বে আপনি অনেক বিপর্যয় ডেকে এনেছেন| আমার প্রতি এসব করা আপনার উচিৎ‌ হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","আপনি কিসের ভয় পাচ্ছিলেন? কেন আপনি আমার সঙ্গে এরকম ব্যবহার করলেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","তখন অব্রাহাম বললেন, “আমি ভয় পেয়েছিলাম| আমি ভেবেছিলাম, এখানে কেউ বোধহয় ঈশ্বরকে শ্রদ্ধা করে না| তাই ভেবেছিলাম, সারাকে পাওয়ার জন্যে আমাকে কেউ হত্যা করতেও পারে| ");
INSERT INTO ben2006_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","সারা আমার স্ত্রী, আবার আমার বোনও বটে| সারা আমার পিতার কন্যা বটে, কিন্তু আমার মাতার কন্যা নয়| ");
INSERT INTO ben2006_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ঈশ্বর আমাকে পিতৃগৃহ থেকে দূরে কোথাও নিয়ে যাচ্ছেন| ঈশ্বর আমাকে অনেক দেশে নিয়ে গেছেন| যখন এরকম হল তখন আমি সারাকে বললাম, ‘আমার জন্য কিছু করো; যেখানেই আমরা যাব, সবাইকে বলবে যে তুমি আমার বোন|’” ");
INSERT INTO ben2006_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","তখন অবীমেলক আসল ব্যাপারটা বুঝলেন| তাই অবীমেলক অব্রাহামের হাতে সারাকে ফিরিয়ে দিলেন| সেই সঙ্গে অবীমেলক অব্রাহামকে কিছু দাস, মেষ ও গবাদি পশুও দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","এবং অবীমেলক বললেন, “চারদিকে তাকিয়ে দেখুন| এসবই আমার জমি| আপনার যেখানে খুশী সেখানে থাকতে পারেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","আর অবীমেলক সারাকে বললেন, “তোমার ভাই অব্রাহামকে আমি 1200 রৌপ্যমুদ্রা দিয়েছি| যা কিছু ঘটেছে সেসবের জন্যে আমি দুঃখিত এটা বোঝাতেই এই রৌপ্যমুদ্রা| সবাই জানুক যে আমি ন্যায় মেনে কাজ করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","অবীমেলকের পরিবারের সমস্ত নারীর গর্ভধারণের ক্ষমতা প্রভু হরণ করেছিলেন| অবীমেলক সারাকে অধিকার করেছিলেন বলে প্রভু এই কাজ করেছিলেন| কিন্তু অব্রাহাম ঈশ্বরের কাছে প্রার্থনা করলেন এবং ঈশ্বর অবীমেলক, অবীমেলকের স্ত্রী ও দাসীদের সন্তানের জন্ম দেওয়ার ক্ষমতা ফিরিয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","প্রভু সারার জন্য যে প্রতিশ্রুতি দিয়েছিলেন, তা রক্ষা করলেন| প্রভু সারার জন্য দেওয়া প্রতিশ্রুতি সম্পন্ন করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","সারা গর্ভবতী হলেন এবং এই বেশী বয়সে অব্রাহামের জন্য একটি পুত্র সন্তান প্রসব করলেন| ঈশ্বর যেভাবে প্রতিশ্রুতি দিয়েছিলেন সেভাবেই সব সম্পন্ন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","সারা একটি পুত্রের জন্ম দিলেন এবং অব্রাহাম তার নাম রাখলেন ইসহাক| ");
INSERT INTO ben2006_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ইসহাকের আট দিন বয়স হলে, যেমনটি ঈশ্বর বলেছিলেন ঠিক সেইভাবে অব্রাহাম তাঁকে সুন্নত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ইসহাকের জন্মের সময় অব্রাহামের বয়স ছিল 100 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","এবং সারা বললেন, “ঈশ্বর আমাকে আনন্দিত করেছেন| যে শুনবে সেই আমার সুখে সুখী হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","কেউ ভাবে নি যে আমি অব্রাহামের পুত্রের জন্ম দেব| কিন্তু এই বৃদ্ধ বয়সেও আমি অব্রাহামকে পুত্র দিতে পেরেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ইসহাক ক্রমশঃ বড় হতে লাগল| শীঘ্রই সে শক্ত খাবার খাওয়ার মত বড় হল| তখন অব্রাহাম একটা মস্ত ভোজ দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","অব্রাহামের প্রথম সন্তানের জন্ম দিয়েছিল হাগার নামে মিশরীয় দাসী| সারা দেখলেন হাগারের সেই পুত্র ইসহাককে নিয়ে মজা করছে| তাই সারা বিচলিত হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","সারা অব্রাহামকে বললেন, “ঐ দাসী আর তার পুত্রের হাত থেকে আমাদের বাঁচাও| ওদের বিদায় করে দাও! যখন আমাদের মৃত্যু হবে তখন আমাদের যা কিছু ধন-সম্পদ ইসহাকই পাবে| আমি চাই না যে আমার পুত্র ইসহাকের সঙ্গে আমার দাসীর পুত্রও সবকিছুর ভাগ পাক!” ");
INSERT INTO ben2006_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","এতে অব্রাহাম খুব বিচলিত হলেন| তিনি তাঁর পুত্র ইশ্মায়েলের জন্যে উদ্বিগ্ন হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","কিন্তু অব্রাহামকে ঈশ্বর বললেন, “ঐ পুত্র আর দাসীর জন্যে চিন্তা কোরো না| সারা যা চায় তা-ই করো| তোমার একমাত্র উত্তরাধিকারী হবে ইসহাক| ");
INSERT INTO ben2006_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","কিন্তু তোমার দাসী পুত্রকেও আমি আশীর্বাদ করব| সে তোমার পুত্র সুতরাং তার পরিবার থেকেও আমি এক মহান জাতি সৃষ্টি করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","পরদিন খুব ভোরে অব্রাহাম কিছু খাদ্য ও পানীয় জল এনে হাগারকে দিলেন| তাই সম্বল করে হাগার পুত্রকে নিয়ে চলে গেল| হাগার সেই স্থান ত্যাগ করে বের্-শেবা মরুভূমির মধ্যে ঘুরে বেড়াতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","কিছুক্ষণ পরে সব জল ফুরিয়ে গেল| পিপাসা মেটাবার জন্যে আর কিছু থাকল না| তখন হাগার তার পুত্রকে একটা ঝোপের নীচে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","হাগার খানিকটা দূরে হেঁটে গেল| তারপর সেখানেই বসে পড়ল| হাগারের ভয় হল, জলের অভাবে তার পুত্র বোধ হয় মারা যাবে| পুত্রের মৃত্যু সে দেখতে পারবে না| তাই সেখানে বসে বসে সে কাঁদতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ঈশ্বর সেই পুত্রের কান্না শুনতে পেলেন এবং স্বর্গ থেকে ঈশ্বরের দূত হাগারকে বলল, “কি হয়েছে? ভয় পেও না! প্রভু তোমার পুত্রের কান্না শুনতে পেয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","যাও, পুত্রকে গিয়ে দেখ| ওর হাত ধরে এগিয়ে চলো| আমি তাকে এক বৃহৎ‌‌ জাতির পিতা করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","তখন হাগার ঈশ্বরের কৃপায় একটা কূপ দেখতে পেল| তারপর হাগার সেই কূপের জলে নিজের জলপাত্র পূর্ণ করল| তারপর সেই জল নিয়ে গিয়ে পুত্রকে পান করাল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","সেই পুত্র বড় হতে লাগল আর ঈশ্বর সারাক্ষণ তার সঙ্গে থাকলেন| ইশ্মায়েল সেই মরুভূমির মধ্যেই বড় হতে লাগল| ক্রমে ক্রমে সে হল একজন শিকারী| তীরধনুকে সে হয়ে উঠল খুব দক্ষ| ");
INSERT INTO ben2006_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","তার মা এক মিশরীয় কন্যার সঙ্গে তার বিয়ে দিল| তারা সেই পারণ নামের মরুভূমিতেই বাস করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","তারপর অবীমেলক ও ফীখোল অব্রাহামের সঙ্গে কথা বললেন| ফীখোল ছিলেন অবীমেলকের সৈন্যবাহিনীর প্রধান| তাঁরা অব্রাহামকে বললেন, “তোমার সব কাজেতেই ঈশ্বর তোমার সঙ্গে আছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","সুতরাং ঈশ্বরের সাক্ষাতে তুমি আমায় একটা প্রতিশ্রুতি দাও| প্রতিজ্ঞা করো যে তুমি আমার ও আমার সন্তানসন্ততির প্রতি ন্যায়পরায়ণ থাকবে| প্রতিশ্রুতি দাও যে তুমি আমার প্রতি এবং যে দেশে বাস করছ সেই দেশের প্রতি ন্যায়পরায়ণ হবে| প্রতিশ্রুতি দাও যে আমি তোমার প্রতি যেরকম ন্যায়পরায়ণ, তুমিও আমার প্রতি সেরকম ন্যায়পরায়ণ হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","এবং অব্রাহাম বললেন, “আমি প্রতিজ্ঞা করছি যে আপনি আমার প্রতি যেরকম আচরণ করেছেন আমিও আপনার প্রতি সেরকম আচরণ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","তারপর অব্রাহাম অবীমেলকের কাছে একটা অভিযোগ করলেন| অব্রাহাম অবীমেলকের কাছে অভিযোগ করলেন যে তাঁর দাসরা একটা পানীয় জলের কূপ অধিকার করে রেখেছে| সেই কূপটি অব্রাহামের দাসরা খনন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","কিন্তু অবীমেলক বললেন, “কে এরকম করেছে আমি জানি না| আপনি তো এর আগে এ ব্যাপারে কখনও কিছু বলেন নি!” ");
INSERT INTO ben2006_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","সুতরাং অব্রাহাম আর অবীমেলক দুজনে চুক্তিবদ্ধ হলেন| অবীমেলক চুক্তির প্রমাণ হিসেবে অব্রাহামকে কয়েকটা মেষ আর গবাদি পশু দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","অব্রাহাম অবীমেলকের সামনে সাতটা মেষ পৃথক করে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","অবীমেলক অব্রাহামকে জিজ্ঞেস করলেন, “আমার সামনে এই সাতটা মেষ পৃথক করে রাখলেন কেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","অব্রাহাম উত্তর দিলেন, “আপনি যখন এই সাতটা মেষ আমার কাছ থেকে নেবেন তখন প্রমাণিত হবে যে আমি এই কূপ খনন করেছিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","তারপর থেকে ঐ কূপের নাম হল বের্-শেবা| কারণ ঐ স্থানে দুজনে পরস্পরের কাছে প্রতিশ্রুতি দিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","অতএব বের্-শেবাতে অব্রাহাম ও অবীমেলক দুজনে একটা চুক্তি সম্পাদন করলেন| তারপর অবীমেলক তাঁর সৈন্যাধক্ষ্যদের নিয়ে পলেষ্টীয়দের দেশে ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","বের্-শেবাতে অব্রাহাম একটা চিরহরিৎ‌ ঝাউগাছ রোপণ করলেন| সেখানে তিনি প্রভু শাশ্বত ঈশ্বরের কাছে প্রার্থনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","অব্রাহাম পলেষ্টীয়দের দেশে বহুকাল বাস করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","এই সমস্ত কিছুর পরে ঈশ্বর ঠিক করলেন যে তিনি অব্রাহামের বিশ্বাস পরীক্ষা করবেন| তাই ঈশ্বর ডাকলেন, “অব্রাহাম!” এবং অব্রাহাম সাড়া দিলেন, “বলুন!” ");
INSERT INTO ben2006_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","তখন ঈশ্বর বললেন, “তোমার একমাত্র পুত্র যাকে তুমি ভালবাস সেই ইসহাককে মোরিয়া দেশে নিয়ে যাও| সেখানে পর্বতগুলির মধ্যে একটির ওপরে তাকে আমার উদ্দেশ্যে বলি দাও| আমি তোমাকে বলব কোন পর্বতের ওপর তুমি তাকে বলি দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","পরদিন সকালে ঘুম থেকে উঠে অব্রাহাম যাত্রার জন্যে গাধার পিঠে জিন সাজালেন| সঙ্গে ইসহাককে নিলেন, আর নিলেন দুজন ভৃত্যকে| অব্রাহাম হোমের জন্য কাঠ কাটলেন| তারপর ঈশ্বর যেখানে যেতে বলেছিলেন সেই স্থানের উদ্দেশ্যে রওনা দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","তিনদিন চলার পর অব্রাহাম দূরে দৃষ্টিপাত করলেন আর গন্তব্যস্থল দেখতে পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","তখন ভৃত্য দুজনের উদ্দেশ্যে অব্রাহাম বললেন, “গাধাটা নিয়ে তোমরা এখানে অপেক্ষা করো, আমি ছেলেকে নিয়ে নির্দিষ্ট স্থানটিতে যাব এবং উপাসনা করব| পরে তোমাদের কাছে ফিরে আসব|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","অব্রাহাম হোমের জন্যে কেটে আনা কাঠ ছেলের কাঁধে দিলেন| এবং সঙ্গে নিলেন খাঁড়া ও আগুন| তারপর অব্রাহাম ও তাঁর ছেলে দুজনেই উপাসনা সম্পাদন করার জন্য নির্দিষ্ট স্থানটিতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ইসহাক পিতা অব্রাহামকে বলল, “পিতা!” অব্রাহাম উত্তর দিলেন, “বলো, পুত্র!” ইসহাক বলল, “পিতা! হোমের জন্যে সব আয়োজন দেখতে পাচ্ছি, কিন্তু হোমের আগে বলি দেওয়ার জন্যে মেষশাবক কোথায়?” ");
INSERT INTO ben2006_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","অব্রাহাম বললেন, “আমার পুত্র, স্বয়ং ঈশ্বর বলির জন্য মেষশাবকের ব্যবস্থা করবেন|” সুতরাং অব্রাহাম আর ইসহাক দুজনে মিলে নির্দিষ্ট স্থানটিতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","তাঁরা সেই স্থানটিতে পৌঁছলেন যেখানে ঈশ্বর যেতে বলেছিলেন| সেখানে অব্রাহাম একটি বেদী তৈরী করলেন| বেদীর উপরে অব্রাহাম কাঠগুলো সাজালেন| তারপর অব্রাহাম তাঁর পুত্র ইসহাককে বাঁধলেন এবং বেদীর উপরে সাজানো কাঠগুলোর উপর তাকে শোয়ালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","এবার অব্রাহাম খাঁড়া বার করে ইসহাককে বলি দেওয়ার জন্যে তৈরী হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","কিন্তু তখন প্রভুর দূত অব্রাহামকে বাধা দিলেন| সেই দূত স্বর্গ থেকে “অব্রাহাম, অব্রাহাম” বলে ডাকলেন| অব্রাহাম থেমে গিয়ে সাড়া দিলেন, “বলুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","দূত বললেন, “তোমার পুত্রকে হত্যা কোরো না, তাকে কোন রকম আঘাত দিও না| এখন আমি দেখতে পাচ্ছি, তুমি ঈশ্বরকে ভক্তি করো এবং তাঁর আজ্ঞা পালন করো| প্রভুর জন্য তুমি তোমার একমাত্র পুত্রকে পর্যন্ত বলি দিতে প্রস্তুত|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","তখন অব্রাহাম একটা মেষ দেখতে পেলেন| একটা ঝোপে তার শিং আটকে গেছে| সুতরাং অব্রাহাম সেই মেষটা ধরে এনে বলি দিলেন| ঐ মেষটাই হল ঈশ্বরের জন্য অব্রাহামের বলি| আর রক্ষা পেল অব্রাহামের পুত্র ইসহাক| ");
INSERT INTO ben2006_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","সুতরাং অব্রাহাম ঐ স্থানটির একটা নাম দিলেন, “যিহোবা-যিরি|” এমন কি আজও লোকেরা বলে, “এই পর্বতে প্রভুকে দেখা যায়|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","স্বর্গ থেকে প্রভুর দূত দ্বিতীয়বার অব্রাহামকে ডেকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“আমার জন্য তুমি তোমার একমাত্র পুত্রকেও বলি দিতে প্রস্তুত ছিলে| আমার জন্য তুমি এত বড় কাজ করেছ বলে আমি তোমার কাছে প্রতিশ্রুতি দিচ্ছি। আমি প্রভু, নিজেরই দিব্য করে প্রতিশ্রুতি করছি যে, ");
INSERT INTO ben2006_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","আমি তোমাকে অবশ্য আশীর্বাদ করব| আকাশে যত তারা, আমি তোমার উত্তরপুরুষদেরও সংখ্যাও তত করব| সমুদ্রতীরে যত বালি, তোমার উত্তরপুরুষরাও তত হবে| এবং তোমার বংশ তাদের সমস্ত শত্রুদের পরাস্ত করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","পৃথিবীর প্রত্যেক জাতি তোমার উত্তরপুরুষদের মাধ্যমে আশীর্বাদ পাবে| তুমি আমার আজ্ঞা পালন করেছ বলে তোমার উত্তরপুরুষদের জন্য আমি একাজ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","তখন অব্রাহাম তাঁর ভৃত্যদের কাছে ফিরে গেলেন| তাঁরা সকলে বের্-শেবাতে ফিরে এলেন এবং অব্রাহাম বের্-শেবাতেই থেকে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","এইসব ঘটনার পরে অব্রাহামের কাছে এই খবর এল, “শোনো, তোমার ভাই নাহোর এবং তার স্ত্রী মিল্কারও এখন সন্তানাদি হয়েছে; ");
INSERT INTO ben2006_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","প্রথম পুত্রের নাম উষ, দ্বিতীয় পুত্রের নাম বূষ, তৃতীয় পুত্র কমূয়েল হল অরামের পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","তারপরে আছে কেষদ, হসো, পিল্দশ, ষিদ্লক এবং বথুযেল|” ");
INSERT INTO ben2006_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","বথুয়েল হল রিবিকার পিতা| এই আট পুত্রের মাতা হল মিল্কা এবং পিতা হল নাহোর| আর নাহোর হচ্ছে অব্রাহামের ভাই| ");
INSERT INTO ben2006_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","তাছাড়া দাসী রূমার থেকেও নাহোরের আরও চারজন পুত্র ছিল| এই চার পুত্রের নাম টেবহ, গহম, তহশ এবং মাখা| ");
INSERT INTO ben2006_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","সারা 127 বছর বেঁচেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","কনান দেশের কিরিয়থ অর্ব অর্থাৎ‌ হিব্রোণ নগরে তাঁর মৃত্যু হল| অব্রাহাম ভীষণ দুঃখ পেলেন, সারার জন্যে অনেক কাঁদলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","তারপর স্ত্রীর মৃতদেহ রেখে হেতের জনগোষ্ঠীর সঙ্গে কথা বলতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","তিনি বললেন, “দেশ পর্যটন করতে করতে আপনাদের দেশে এসে আমি পরবাসী হিসেবে বাস করছি| ফলে আমার মৃত স্ত্রীকে কবর দেওয়ার মত আমার কোনও জায়গা নেই| আমি যাতে স্ত্রীকে কবর দিতে পারি তার জন্য দয়া করে আমায় খানিকটা জায়গা দিন|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","হেতেরা উত্তরে বলল, ");
INSERT INTO ben2006_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“মহাশয়, আমাদের মধ্যে আপনি ঈশ্বরের মহান নেতাদের একজন| আমাদের শ্রেষ্ঠ জমিতে আপনি আপনার মৃত স্ত্রীকে সমাধিস্থ করতে পারেন| আপনার স্ত্রীকে আপনি আপনার পছন্দমত জায়গাতে সমাধিস্থ করলে কেউ আপনাকে বাধা দেবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","অব্রাহাম উঠে দাঁড়িয়ে তাঁদের নমস্কার করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","অব্রাহাম তাঁদের বললেন, “আপনারা সত্যিই যদি আমার মৃত স্ত্রীকে কবর দেওয়ার ব্যাপারে সাহায্য করতে চান তাহলে আমার হয়ে সোহরের পুত্র ইফ্রোণের সঙ্গে কথা বলুন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ইফ্রোণের ক্ষেতের শেষে যে মক্পেলার গুহাটা আছে সেটা আমি কিনতে চাই| ইফ্রোণ ঐ গুহার মালিক| যা দাম হয়, সবটাই আমি দেব| আমি চাই যে আমার স্ত্রীর কবরের জন্য যে ঐ জায়গা কিনছি আপনারা সবাই তার সাক্ষী থাকুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","যাদের সঙ্গে অব্রাহাম কথা বলছিলেন তাঁদের মধ্যে ইফ্রোণ উপবিষ্ট ছিলেন| এখন ইফ্রোণ অব্রাহামকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“না, মহাশয়, এখানেই ঐ ক্ষেত এবং গুহাটিও আমি আমার লোকেদের সামনে আপনাকে দেব| আপনি যাতে আপনার ইচ্ছা মত আপনার স্ত্রীকে সমাধিস্থ করতে পারেন সেজন্যে ঐ জমি, গুহা আমি আপনাকে দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","তখন অব্রাহাম সমবেত হেতের লোকদের সবিনয় নমস্কার করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","সকলের উপস্থিতিতে তিনি ইফ্রোণকে বললেন, “কিন্তু আমি ঐ জমির পুরো দাম আপনাকে দিতে চাই| আমার দেওয়া দাম আপনি দয়া করে গ্রহণ করুন, আমি নির্ধিধায় আমার স্ত্রীকে কবর দিই|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","উত্তরে ইফ্রোণ অব্রাহামকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“মহাশয়, আমার কথা শুনুন| আপনার ও আমার কাছে 10 পাউণ্ড ওজনের রূপোর তো কোন দাম নেই| সুতরাং আপনি জমিটা নিন এবং সেখানে নিশ্চিন্তে আপনার স্ত্রীকে সমাধিস্থ করুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","অব্রাহাম বুঝতে পারলেন যে ইফ্রোণের কথার মধ্যেই জমিটার মূল্য উল্লিখিত রয়েছে| সুতরাং অব্রাহাম ঐ মূল্যই ইফ্রোণকে দিলেন| ইফ্রোণের জন্যে অব্রাহাম 10 পাউণ্ড রূপো ওজন করলেন এবং সেই রূপো বণিককে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","সুতরাং ইফ্রোণের জমির স্বত্ত্বাধিকারীর পরিবর্তন হল| মম্রির পূর্বদিকে মক্পেলায় ঐ জমি অবস্থিত| এখন ঐ জমির স্বত্ত্বাধিকারী হলেন অব্রাহাম| তিনি ঐ জমির অন্তর্গত গুহা এবং সমস্ত বৃক্ষাদির স্বত্ত্বাধিকারী হলেন| সমস্ত নগরবাসী ইফ্রোণ ও অব্রাহামের মধ্যে ঐ চুক্তি সম্পাদন প্রত্যক্ষ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","তারপর অব্রাহাম মম্রির (হিব্রোণে) নিকটস্থ জমিতে অর্থাৎ‌ কনান দেশের এক গুহার মধ্যে তাঁর স্ত্রী সারাকে সমাধিস্থ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","অব্রাহাম হেতের জনগোষ্ঠীর কাছ থেকে ঐ জমি ও জমির মধ্যেকার গুহা কিনলেন| এখন ঐ জমি গুহা হল অব্রাহামের সম্পত্তি এবং ঐ জায়গা তিনি সমাধিস্থল হিসেবে ব্যবহার করতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","অব্রাহাম অত্যন্ত বৃদ্ধ বয়স পর্যন্ত জীবিত ছিলেন| অব্রাহাম ও তাঁর কৃত সমস্ত কর্মে প্রভুর আশীর্বাদ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","অব্রাহামের সমস্ত সম্পত্তি দেখাশোনার জন্যে একজন পুরানো ভৃত্য ছিল| অব্রাহাম সেই ভৃত্যকে একদিন ডেকে বললেন, “আমার উরুর নীচে হাত দাও| ");
INSERT INTO ben2006_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","এখন আমার কাছে তুমি একটা প্রতিজ্ঞা করো| স্বর্গ ও মর্ত্যের ঈশ্বর প্রভুর সাক্ষাতে আমায় কথা দাও যে কনানের কোন কন্যাকে আমার পুত্র বিয়ে করবে, এরকমটা তুমি কখনও হতে দেবে না| আমরা কনানীয়দের মধ্যে বাস করি বটে, কিন্তু আমার পুত্রের সঙ্গে কোনও কনানীয় কন্যার বিয়ে হতে দেবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","আমার দেশে আমার স্বজাতির কাছে ফিরে যাও| সেখানে আমার পুত্র ইসহাকের জন্যে পাত্রী খুঁজে বার করে তাকে এখানে নিয়ে এস|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ভৃত্যটি তাঁকে বলল, “এমন তো হতে পারে যে কোনও পাত্রী আমার সঙ্গে এদেশে আসতে রাজী হল না| তাহলে কি আমি আপনার পুত্রকে আমার সঙ্গে নিয়ে আপনার জন্মভূমিতে যাব?” ");
INSERT INTO ben2006_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","অব্রাহাম তাকে বলল, “না! আমার পুত্রকে ঐ দেশে নিয়ে যেও না| ");
INSERT INTO ben2006_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","স্বর্গের প্রভু স্বয়ং ঈশ্বর আমার স্বদেশ থেকে সপরিবারে আমায় এখানে নিয়ে এসেছেন| ঐ দেশ আমার পিতার ও পরিবারের স্বদেশ ছিল| কিন্তু প্রভু কথা দিয়েছেন যে এই নতুন দেশ হবে আমার পরিবারের স্বদেশ| প্রভু তোমার আগে তাঁর দূত পাঠাবেন যাতে তুমি আমার পুত্রের জন্য একটি পাত্রী পছন্দ করে তাকে এখানে আনতে পার| ");
INSERT INTO ben2006_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","কিন্তু যদি সেই পাত্রী তোমার সঙ্গে এই দেশে আসতে না চায় তাহলে তুমি তোমার শপথ থেকে মুক্তি পাবে| কিন্তু তুমি কখনও আমার পুত্রকে সেই দেশে ফিরিয়ে নিয়ে যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","সুতরাং ভৃত্যটি তার মনিবের উরুর নীচে হাত দিয়ে সেই রকমই শপথ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","পরিচারকটি অব্রাহামের দশটি উট নিয়ে সেই স্থান ত্যাগ করল| সঙ্গে নিয়ে গেল নানা ধরণের সুন্দর সুন্দর উপহার| সে গেল নাহোরের নগর মেসোপটেমিযাতে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","নগরের বাইরে সেই ভৃত্য জলের কূপের দিকে গেল| সন্ধ্যার সময় নগরের মেয়েরা সেই কূপে জল নিতে বেরিয়ে এল| ভৃত্যটি উটগুলোকে সেখানে হাঁটু গেড়ে বসাল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ভৃত্যটি বলল, “প্রভু, আপনি আমার মনিব অব্রাহামের ঈশ্বর| আজ আমার মনিবের পুত্রের জন্য একটি যোগ্য পাত্রী নির্বাচনে আপনি আমায় সাহায্য করুন| অনুগ্রহ করে আমার প্রভু অব্রাহামকে এই দয়া করুন| ");
INSERT INTO ben2006_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","এখানে কূপের ধারে আমি দাঁড়িয়ে আছি| নগরের তরুণী রমনীরা এই কূপের জল নিতে আসছে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ইসহাকের জন্যে কোন পাত্রীটি উপযুক্ত তা জানার একটা বিশেষ ইঙ্গিত দেখতে পাব বলে এখানে আমি অপেক্ষা করছি| সেই বিশেষ ইঙ্গিতটি হল এই: আমি মেয়েটিকে বলব, ‘তোমার কলসী থেকে আমায় একটু জল দাও|’ সেই মেয়েটিই যে উপযুক্ত তা আমি বুঝতে পারব যদি সে বলে, ‘নিন, এই জলে তেষ্টা মেটান| আপনার উটগুলোকেও আমি জল দিচ্ছি|’ এরকমটা যদি ঘটে তাহলে আমি বুঝব আপনার কাছ হতে আসা সেটাই প্রমাণ যে ঐ মেয়েই ইসহাকের জন্যে সঠিক পাত্রী এবং আমি জানব যে আপনি আমার মনিবকে দয়া করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ভৃত্য প্রার্থনা শেষ করার আগেই রিবিকা নামে একটি তরুনী কূপের কাছে এল| রিবিকা বথুযেলের কন্যা| বথুযেল ছিল অব্রাহামের ভাই নাহোর ও তার স্ত্রী মিল্কার পুত্র| জল নেওয়ার কলসী কাঁধে নিয়ে রিবিকা কূপের কাছে এল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","রিবিকা অসাধারণ সুন্দরী| সে কখনও কোন পুরুষের সঙ্গে ঘুমায নি| সে ছিল কুমারী| কূপের ধারে গিয়ে সে কলসী ভরে জল নিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","তখন সেই ভৃত্য তাড়াতাড়ি তার কাছে গিয়ে বলল, “দারুণ তৃষ্ণা, দয়া করে তোমার কলসী থেকে একটু জল দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","রিবিকা সঙ্গে সঙ্গে কাঁধ থেকে কলসী নামিয়ে তার আঁজলায জল ঢেলে দিয়ে বলল, “এই নিন, তৃষ্ণা মেটান|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","তাকে জল খেতে দেওয়ার পরে রিবিকা বলল, “আপনার উটগুলোকেও আমি জল দিচ্ছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","তখন রিবিকা কলসী খালি করে সবটা জল ঢেলে দিল উটেদের পানপাত্রে| তারপর আবার কূপ থেকে আরও জল আনতে গেল| এভাবে সে সবগুলো উটকেই জল পান করতে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","সেই ভৃত্য নীরবে রিবিকার সমস্ত কাজ লক্ষ্য করতে লাগল| সে নিশ্চিত হতে চাইছিল যে প্রভু তার প্রার্থনা শুনেছেন কিনা এবং ইসহাকের জন্যে কন্যা সন্ধান সফল হয়েছে কিনা| ");
INSERT INTO ben2006_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","উটগুলোর জলপান শেষ হলে সে রিবিকাকে একটা 1/4 আউন্স ওজনের সোনার আংটি দিল| তাছাড়া সে এক-একটি 5 আউন্স ওজনের দুখানা সোনার বালাও রিবিকাকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ভৃত্যটি রিবিকাকে জিজ্ঞেস করল, “তোমার পিতা কে? তোমার পিতার গৃহে কি আমার লোকদের রাতে থাকার কোনও ব্যবস্থা হতে পারে?” ");
INSERT INTO ben2006_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","রিবিকা উত্তর দিল, “বথুযেল আমার পিতা| তিনি মিল্কা ও নাহোরের পুত্র|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","তারপর সে বলল, “উটগুলোকে খেতে দেওয়ার মত খড় আর আপনাদের ঘুমোতে দেওয়ার মত জায়গা দুটোই আমাদের আছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ভৃত্যটি সাষ্টাঙ্গে প্রণিপাত করে প্রভুর উপাসনা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","সে বলল, “ধন্য প্রভু, আমার মনিব অব্রাহামের ঈশ্বর| আমার মনিবের প্রতি প্রভু দয়া ও বিশ্বস্ততার ব্যবহার করেছেন| প্রভু আমাকে আমার মনিবের আত্মীয়দের বাড়ীতে নিয়ে এসেছেন আমার মনিবের পুত্রের জন্য যোগ্য পাত্রী খুঁজে বার করার জন্য|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","তখন রিবিকা ছুটে গিয়ে যা যা ঘটেছে সেসব তার পরিবারের সবাইকে বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","রিবিকার এক ভাই ছিল| তার নাম লাবন| সেই আগন্তুক যা কিছু বলেছে, সেইসব রিবিকা যখন বলছিল তখন লাবন মন দিয়ে সব শুনছিল এবং লাবন যখন তার দিদির আঙুলে আংটি আর হাতে বালা দেখল তখন ছুটে বেরিয়ে গিয়ে সেই কূপের ধারে এল| সেই লোকটি তখন কূপের ধারে উটগুলো নিয়ে দাঁড়িয়ে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","লাবন বলল, “মহাশয়, আপনাকে আমাদের আলয়ে স্বাগত জানাই| আপনার এখানে দাঁড়িয়ে থাকার দরকার নেই| আপনাদের বিশ্রামের জন্য আমি সমস্ত বন্দোবস্ত করছি এবং আপনাদের উটগুলোর জন্যে আমাদের বাড়ীতে জায়গা আছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","তাই অব্রাহামের ভৃত্য তাদের বাড়ীর ভেতরে গেল| উটগুলোর থেকে বোঝা নামাতে লাবন তাদের সাহায্য করল এবং উটগুলোকে খাবারের জন্য খড়ও দিল| লাবন তারপর সেই ভৃত্য ও তার লোকদের পা ধোওয়ার জন্য জল দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","তারপর লাবন তাদের খাওয়ার জন্য খাবার দিল| কিন্তু ভৃত্যটি খেতে রাজী হল না| সে বলল, “আমি কেন এসেছি তা না বলে আমি খাব না|” তখন লাবন বলল, “তাহলে আমাদের বলুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","তখন সেই ভৃত্য বলল, “আমি অব্রাহামের পরিচারক| ");
INSERT INTO ben2006_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","কিন্তু সমস্ত বিষয়েই আমার মনিবকে আশীর্বাদ করেছেন| আমার মনিব এখন এক মহান ব্যক্তি| অব্রাহামকে প্রভু অনেক মেষের পাল এবং প্রচুর গবাদি পশু দিয়েছেন| অব্রাহামের এখন অনেক সোনা, রূপা, অনেক দাসদাসী| অব্রাহামের অনেক উট ও গাধা আছে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","আমার মনিবের স্ত্রী ছিলেন সারা| অনেক বয়সে তিনি একটি পুত্রের জন্ম দিলেন এবং আমার মনিব তাঁর সমস্ত ধন-সম্পদ তাঁর এই পুত্রকে দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","আমার মনিব আমায় একটা শপথ নিতে বাধ্য করেছেন| আমার মনিব আমায় বললেন, ‘আমার পুত্রকে তুমি কনানের কোনও কন্যাকে বিয়ে করতে দেবে না| আমরা কনানের লোকদের মধ্যে বাস করি বটে, কিন্তু আমি চাই না যে সে কনানের কোনও কন্যাকে বিয়ে করে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","সুতরাং তুমি শপথ করো যে তুমি আমার পিতার দেশে যাবে| আমার আত্মীয়স্বজনদের কাছে যাও এবং আমার পুত্রের জন্যে একজন পাত্রী নির্বাচন করো|’ ");
INSERT INTO ben2006_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","তখন আমি আমার মনিবকে বললাম, ‘সেই পাত্রী আমার সঙ্গে এই দেশে আসতে না চাইতেও পারে|’ ");
INSERT INTO ben2006_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","কিন্তু আমার মনিব বললেন, ‘আমি প্রভুর সেবা করেছি এবং সেই একই প্রভু তাঁর দূত পাঠাবেন তোমার সঙ্গে তোমার সাহায্যের জন্য| আমার আত্মীয়স্বজনদের মধ্যেই তুমি আমার পুত্রের জন্যে পাত্রী খুঁজে পাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","কিন্তু তুমি যদি আমার পিতার দেশে যাও আর তাঁরা যদি আমার পুত্রের জন্য মেয়ে দিতে অস্বীকার করেন, তাহলে তুমি এই শপথের দায় থেকে মুক্ত হবে|’ ");
INSERT INTO ben2006_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“আজ আমি এই কূপের পাড়ে এসে প্রার্থনা করলাম, ‘প্রভু, আপনি আমার মনিব অব্রাহামের ঈশ্বর, দয়া করে আমার এই যাত্রাকে সফল করুন| ");
INSERT INTO ben2006_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","আমি এই কূপের পাশে দাঁড়িয়ে জল নেওয়ার জন্য আসা একটি মেয়ের জন্যে অপেক্ষা করব| সে জল নিতে এলে আমি বলব, “দয়া করে তোমার কলসী থেকে আমায় একটু জল পান করতে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","এতে উপযুক্ত পাত্রী একটা বিশেষভাবে উত্তর দেবে| সে বলবে, “এই জল আপনি পান করুন আর আপনার উটগুলোকেও আমি জল পান করতে দেব|” যে মেয়ে এইভাবে উত্তর দেবে, আমি জানব, সে-ই আমার মনিবের পুত্রের জন্য উপযুক্ত পাত্রী হবে যাকে প্রভু নির্বাচন করেছেন|’ ");
INSERT INTO ben2006_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“আমার প্রার্থনা শেষ করার আগেই রিবিকা জল নেওয়ার জন্যে কূয়ো তলায় এল| জলের কলসীটা তার কাঁধে ছিল| আমি তার কাছে তৃষ্ণা নিবারণের জন্য জল চাইলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","তখনই সে কাঁধ থেকে কলসী নামিয়ে আমার আঁজলায় খানিকটা জল ঢেলে দিল| তারপর সে বলল, ‘এই জল আপনি পান করুন আর আপনার উটগুলোর জন্য আমি আরও জল দিচ্ছি|’ তখন আমি সেই জল পান করলাম এবং মেয়েটি উটগুলোকেও জল পান করতে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","তখন আমি তাকে জিজ্ঞেস করলাম, ‘তোমার পিতা কে?’ সে বলল, ‘বথুযেল আমার পিতা| তিনি মিল্কা ও নাহোরের পুত্র|’ তখন আমি তাকে আংটি আর বালা জোড়া দিলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","আর প্রণিপাত করে আমি প্রভুকে ধন্যবাদ জানালাম| আমি প্রভুকে আমার মনিব অব্রাহামের ঈশ্বরকে প্রশংসা করলাম| আমায় সোজা আমার মনিবের ভাইয়ের নাতনির কাছে পৌঁছে দেওয়ার জন্যে ধন্যবাদ জানাই প্রভুকে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","এখন আমায় বলুন, আপনি কি আমার মনিবের প্রতি সদয় এবং বিশ্বস্ত হয়ে তাঁকে আপনার কন্যাটিকে দেবেন? না কি গররাজী হবেন? আপনি খুলে বলুন যাতে আমি কি করব, না করব ঠিক করতে পারি|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","তখন লাবন এবং বথুয়েল উত্তর দিলেন, “আমরা দেখতে পাচ্ছি, সবই প্রভুর ইচ্ছা অনুসারে হচ্ছে| সুতরাং তোমাকে আমরা এটি বদলাবার জন্য কিছুই বলতে পারি না| ");
INSERT INTO ben2006_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","তাই রিবিকাকে দিলাম| ওকে নিয়ে যাও| ওর সঙ্গে তোমার মনিবের পুত্রের বিয়ে দাও| প্রভুর এটাই ইচ্ছা|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","যখন অব্রাহামের ভৃত্য একথা শুনল সে প্রভুর সামনে ভূমিতে প্রণিপাত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","তখন সে যেসব উপহার সামগ্রী এনেছিল সেসব রিবিকাকে দিল| সে তাকে খুব সুন্দর সুন্দর জামা কাপড় এবং সোনা ও রূপার নানা অলঙ্কার দিল| তার ভাই এবং মাকেও দিল বহু রকম মূল্যবান সামগ্রী| ");
INSERT INTO ben2006_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","তারপর তারা খাওয়াদাওয়া সেরে সেখানে রাত্রিযাপন করল| পরদিন খুব সকালে উঠে তারা বলল, “এখন আমার মনিবের কাছে আমাদের ফিরে যেতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","তখন রিবিকার মা ও ভাই বলল, “রিবিকা আরও কিছুদিন আমাদের কাছে থাকুক| আর দশ দিন আমাদের কাছে থাক| তারপর সে যেতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","কিন্তু ভৃত্য তাদের বলল, “আমায় দেরী করিয়ে দেবেন না| প্রভু আমার যাত্রা সফল করেছেন| এবার আমার প্রভুর কাছে তাড়াতাড়ি ফিরে যাওয়া দরকার|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","রিবিকার মা ও ভাই বলল, “রিবিকাকে ডেকে আনি–ও কি বলে শোনা যাক্|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","তাঁরা রিবিকাকে ডেকে জিজ্ঞেস করলেন, “তুমি কি এঁর সঙ্গে এখনই যেতে চাও?” রিবিকা বলল, “হ্যাঁ, আমি যাব|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","সুতরাং তাঁরা অব্রাহামের ভৃত্য ও তার লোকজনের সঙ্গে রিবিকাকে যেতে দিলেন| রিবিকাকে ছোটবেলা থেকে যে দাসী মানুষ করেছে সে-ও তাদের সঙ্গে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","যখন রিবিকা যাত্রা শুরু করল তাঁরা তাকে বললেন, “আমাদের বোন, তুমি হও লক্ষ লক্ষ জনের জননী| তোমার উত্তরপুরুষগণ শত্রুদের পরাজিত করে দখল করুক তাদের নগরগুলি|” ");
INSERT INTO ben2006_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","তারপর রিবিকা ও তার দাসী উটের পিঠে চড়ে অব্রাহামের ভৃত্য ও তার লোকজনদের অনুগমন করল| সুতরাং সেই ভৃত্য রিবিকাকে নিয়ে মনিবের গৃহের পথে যাত্রা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ইসহাক তখন বের্-লহয়্-রোয়ী ত্যাগ করে নেগেভে বাস করছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","একদিন সন্ধ্যায় একান্তে ধ্যান করার জন্যে ইসহাক নির্জন প্রান্তরে বেড়াতে গিয়েছিলেন| ইসহাক চোখ তুলে দেখলেন যে দূর থেকে উটের সারি আসছে| ");
INSERT INTO ben2006_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","রিবিকাও ইসহাককে দেখতে পেলেন| তখন সে উটের পিঠ থেকে লাফিয়ে নেমে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ভৃত্যকে জিজ্ঞেস করল, “কে ঐ তরুণ মাঠের মধ্যে দিয়ে আমাদের দিকে এগিয়ে আসছে?” ভৃত্য উত্তর দিল, “ঐ আমার মনিবের পুত্র|” শুনে রিবিকা ওড়না দিয়ে তার মুখ ঢাকল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","সেই ভৃত্য যা-যা ঘটেছে সব ইসহাককে বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","তখন ইসহাক মেয়েটিকে তাঁর মায়ের তাঁবুতে নিয়ে গেলেন| সেদিন থেকে রিবিকা হল ইসহাকের স্ত্রী| ইসহাক তাকে খুব ভালবাসলেন| তাকে ভালবেসে ইসহাক মায়ের মৃত্যুর শোকে সান্ত্বনা পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","অব্রাহাম আবার বিবাহ করলেন| তাঁর নতুন স্ত্রীর নাম কটুরা| ");
INSERT INTO ben2006_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","অব্রাহামের ঔরসে কটুরা সিম্রণ, যকষণ, মদান, মিদিয়ন, যিশবক এবং শূহরের জন্ম দেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","যকষণ ছিলেন শিবা ও দদানের জনক| অশূরীয়, লিযুশ্মীয় আর লটুনীয় অধিবাসীরা ছিল দদানের উত্তরপুরুষ| ");
INSERT INTO ben2006_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ঐফা, এফর, হনোক, অবীদ এবং ইল্দায়া ছিল মিদিয়নের সন্তানসন্ততি| অব্রাহাম ও কটুরার বিবাহের ফলে এইসব পুত্রদের জন্ম হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","মৃত্যুর আগে অব্রাহাম তাঁর রক্ষিত দাসীদের গর্ভজাত পুত্রদের নানা রকম উপহার দিয়ে তাদের পূর্ব দেশে পাঠান| তিনি তাদের ইসহাকের কাছ থেকে দূরে পাঠিয়ে দিয়ে তাঁর যা কিছু ছিল সব ইসহাককে দেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","অব্রাহাম 175 বছর বয়স পর্যন্ত বেঁচে ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","তারপর অব্রাহাম ক্রমশঃ দুর্বল হয়ে অবশেষে শেষ নিঃশ্বাস ত্যাগ করলেন| সুদীর্ঘ ও সুখী জীবন ছিল তাঁর| তিনি মারা গেলেন এবং তাঁকে তাঁর আপনজনের কাছে নিয়ে যাওয়া হল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","তাঁর দুই পুত্র ইসহাক আর ইশ্মায়েল মিলে তাঁর মৃতদেহ মক্পেলার গুহাতে কবর দিল| সোহরের পুত্র ইফ্রোণের জমিতে ঐ গুহা| জায়গাটা ছিল মম্রির পূর্ব দিকে| ");
INSERT INTO ben2006_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","এই সেই গুহা যেটা অব্রাহাম হেতের সন্তানদের কাছ থেকে কিনেছিলেন| সেখানে স্ত্রী সারার কবরের পাশে অব্রাহামকে কবর দেওয়া হল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","অব্রাহামের মৃত্যুর পরে ঈশ্বর ইসহাককে আশীর্বাদ করলেন| ইসহাক বের্-লহয়-রোয়ীতে বসবাস করতে থাকলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ইশ্মায়েলের বংশ বৃত্তান্ত এই: অব্রাহাম ও হাগারের পুত্র ছিলেন ইশ্মায়েল| (হাগার ছিলেন সারার মিশরীয় দাসী|) ");
INSERT INTO ben2006_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ইশ্মায়েলের পুত্রদের নামগুলো হল: প্রথম পুত্র ছিল নবায়োত্‌, তারপর জন্মায় কেদর, তারপরে যথাক্রমে অদ্বেল, মিবসম্, ");
INSERT INTO ben2006_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিশ্ম, দুমা, মসা, ");
INSERT INTO ben2006_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তেমা, যিটুর, নাফীশ এবং কেদমা| ");
INSERT INTO ben2006_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","এইগুলি হল ইশ্মায়েলের পুত্রদের নাম| প্রত্যেকের এক-একটা ছোট বসতি ছিল এবং প্রত্যেকটি বসতি আস্তে আস্তে শহরে পরিণত হয়| বারোটি পুত্র যেন বারো জন রাজপুত্র এবং প্রত্যেকের নিজস্ব জনবল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইশ্মায়েল 137 বছর বেঁচেছিলেন| তারপর তাঁর মৃত্যু হয় এবং তাঁকে তাঁর পূর্বপুরুষদের কাছে নিয়ে যাওয়া হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ইশ্মায়েলের উত্তরপুরুষরা সমগ্র মরুভূমি অঞ্চলে বসতি স্থাপন করে| এই অঞ্চলটি ছিল মিশরের কাছে হুবীলা থেকে শূর পর্যন্ত বিস্তৃত এবং এখান থেকে তা বিস্তৃত ছিল অশূরিযা পর্যন্ত| ইশ্মায়েলের উত্তরপুরুষরা প্রায়ই তার ভাইয়ের লোকেদের আক্রমণ করত| ");
INSERT INTO ben2006_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","এবার ইসহাকের কাহিনী। ইসহাক নামে অব্রাহামের এক পুত্র ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","যখন ইসহাকের বয়স 40 হল তখন তিনি রিবিকাকে বিয়ে করলেন| রিবিকা ছিলেন পদ্দন্ অরাম অঞ্চলের মেয়ে| তাঁর পিতা বথুযেল এবং অরামীয় লাবন ছিলেন তাঁর ভাই| ");
INSERT INTO ben2006_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ইসহাকের স্ত্রীর সন্তানাদি হচ্ছিল না| তাই তিনি প্রভুর কাছে তাঁর স্ত্রীর জন্যে প্রার্থনা করলেন এবং প্রভু তাঁর প্রার্থনা শুনলে রিবিকা গর্ভবতী হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","গর্ভবতী অবস্থায় রিবিকা যন্ত্রণা ভোগ করছিলেন কারণ তাঁর গর্ভে দুটি শিশু একে অপরকে জোরে ঠেলাঠেলি করছিল| গর্ভস্থ শিশুর জন্যে রিবিকা অনেক কষ্ট পেতে থাকেন| তিনি প্রভুর কাছে প্রার্থনা করে জানতে চাইলেন, “আমার কেন এমন হচ্ছে?” ");
INSERT INTO ben2006_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","প্রভু উত্তরে বললেন, “তোমার গর্ভের মধ্যে দুটি জাতি আছে| তুমি দুই মহান বংশের শাসকদের জন্ম দেবে| তাদের মধ্যে বিচ্ছেদ ঘটবে| এক পুত্রের অপেক্ষা অন্য পুত্র শক্তিশালী হবে| ছোট পুত্রের সেবা করবে বড় পুত্র|” ");
INSERT INTO ben2006_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","যথাসময়ে রিবিকা দুটি যমজ সন্তানের জন্ম দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","প্রথম সন্তানের গায়ের রং ছিল লাল| গায়ের ত্বক ছিল লোমশ বস্ত্রের মত| তাই তার নাম রাখা হল এষৌ| ");
INSERT INTO ben2006_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","তারপরে যখন দ্বিতীয় সন্তানটির জন্ম হল তখন তার শক্ত মুঠোর মধ্যে এষৌর পায়ের গোড়ালি ধরা ছিল| তাই তার নাম রাখা হল যাকোব| এষৌ এবং যাকোবের জন্মের সময় ইসহাকের বয়স ছিল 60 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ছেলে দুটি বড় হতে লাগল| এষৌ হল একজন দক্ষ শিকারী| সে জঙ্গলে প্রান্তরে ঘুরে বেড়াতে ভালবাসত| কিন্তু যাকোব ছিল শান্ত প্রকৃতির| সে তাঁবুতেই থাকত| ");
INSERT INTO ben2006_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ইসহাক এষৌকে ভালবাসতেন| এষৌর শিকার করা পশুর মাংস খেতে তিনি ভালবাসতেন| কিন্তু রিবিকা যাকোবকে ভালবাসতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","একবার এষৌ শিকার থেকে ফিরে এল| ক্ষুধায় সে ছিল ক্লান্ত ও দুর্বল| তখন যাকোব এক হাঁড়ি শিম সেদ্ধ করছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","এষৌ যাকোবকে বলল, “ক্ষিধের জ্বালায় আমি ক্লান্ত| আমায় এই লাল বীন কিছু খেতে দাও|” (সেজন্য সবাই তাকে ইদোম বলে|) ");
INSERT INTO ben2006_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","কিন্তু যাকোব বলল, “তাহলে তুমি আজ বড় পুত্রের অধিকার আমায় বিক্রি করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","এষৌ বলল, “ক্ষিধের চোটে আমি এমনিতেই আধমরা হয়ে গেছি| মরেই যদি যাই তাহলে পিতার সব সম্পত্তি আমার কোন কাজে লাগবে? তাই আমার ভাগ আমি তোমায় দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","কিন্তু যাকোব বলল, “আগে প্রতিজ্ঞা করো যে তোমার ভাগ আমায় দেবে|” অতএব যাকোবের কাছে এষৌ প্রতিজ্ঞা করল| এষৌ পিতার সম্পত্তি থেকে নিজের ভাগ যাকোবকে বিক্রি করল| ");
INSERT INTO ben2006_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","তখন যাকোব এষৌকে রুটি ও খাবার দিল| এষৌ খেয়েদেয়ে পরিতৃপ্ত হয়ে চলে গেল| সুতরাং এষৌ প্রমাণ করল যে বড় পুত্রের অধিকার নিয়ে তার কোনও মাথাব্যথা নেই| ");
INSERT INTO ben2006_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","একবার দুর্ভিক্ষ হল| অব্রাহামের সময় যেমন হয়েছিল এই দুর্ভিক্ষটা তেমনই ছিল| তখন ইসহাক পলেষ্টীয়দের অবীমেলকের সঙ্গে দেখা করার জন্য গরারে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","প্রভু ইসহাককে দর্শন দিলেন এবং বললেন, “মিশরে যেও না| আমি তোমায় যে দেশে বাস করার পরামর্শ দিচ্ছি সেই দেশে বাস করো| ");
INSERT INTO ben2006_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","সেই দেশে থাকো এবং আমি তোমার সঙ্গে থাকব| আমি তোমায় আশীর্বাদ করব| এই যত জমিজমা দেখছ সব আমি তোমায় ও তোমার পরিবারকে দেব| তোমার পিতা অব্রাহামকে আমি যা-যা প্রতিজ্ঞা করেছিলাম সে সব কথা আমি রাখব| ");
INSERT INTO ben2006_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","আকাশের তারার মত তোমার উত্তরপুরুষরা হবে অসংখ্য এবং তোমার পরিবার এই সমস্ত জমির মালিক হবে| তোমার উত্তরপুরুষদের মাধ্যমে পৃথিবীর সমস্ত জাতি আমার আশীর্বাদ পাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","তোমার পিতা অব্রাহাম আমার কথা, আমার আদেশ, আমার বিধি, আমার নিয়ম সব কিছু পালন করেছিল এবং আমি তাকে যা যা করতে বলেছিলাম সব করেছিল বলে আমি এটা করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","সুতরাং ইসহাক গরারে থেকে গেলেন এবং সেখানেই বাস করতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ইসহাকের স্ত্রী রিবিকা ছিল অপূর্ব সুন্দরী| গরারের বাসিন্দারা রিবিকার সম্পর্কে ইসহাককে জিজ্ঞাসাবাদ করতে লাগল| ইসহাক বললেন, “ও আমার বোন|” রিবিকাকে তার স্ত্রী হিসেবে পরিচয় দিতে ইসহাক ভয় পেল| ইসহাকের ভয় হল যে রিবিকাকে পাওয়ার জন্য তারা তাকে হত্যা করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","তারপর ইসহাক সেখানে বহুদিন থেকেছিলেন| একদিন অবীমেলক জানালা দিয়ে ইসহাক ও তার স্ত্রী রিবিকাকে খেলা করতে দেখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","তখন অবীমেলক ইসহাককে ডেকে পাঠালেন| অবীমেলক বললেন, “এই নারী আসলে তোমার স্ত্রী| আমায় কেন মিথ্যে করে বলেছিলে যে এ তোমার বোন?” ইসহাক বলল, “আমি ভয় পেয়েছিলাম যে একে স্ত্রী বলে পরিচয় দিলে ওকে পাওয়ার জন্য আপনি আমায় হত্যা করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","অবীমেলক বললেন, “আমাদের প্রতি অত্যন্ত অন্যায় অবিচার করেছ| আমাদের মধ্যে কেউ যদি তোমার স্ত্রীকে শয্যাসঙ্গিনী করতো তাহলে সে মহাপাপের ভাগী হত|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","সুতরাং অবীমেলক তাঁর সমস্ত প্রজাদের সাবধান করে দিলেন| তিনি বললেন, “কেউ এই লোকটির বা এর স্ত্রীর কোন ক্ষতি করবে না| যদি কেউ এদের কোনও ক্ষতি করে তাহলে তার শাস্তি হবে মৃত্যু|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ইসহাক তাঁর ক্ষেতে চাষ করলেন| এবং সে বছর খুব ভাল ফসল হল| প্রভু তাঁকে খুব আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ইসহাক ধনী হলেন| তিনি আরও অনেক ধন উপার্জন করলেন| এভাবে তিনি একজন অত্যন্ত ধনবান ব্যক্তি হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","তিনি প্রচুর মেষপাল ও গো-পালের মালিক হলেন| তাঁর বিশাল ধন ও অনেক দাস-দাসী ছিল| সমস্ত পলেষ্টীয় মানুষরা তাঁকে ঈর্ষা করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ফলে অনেক কাল আগে অব্রাহাম ও তাঁর লোকজন যেসব কূপ খনন করেছিলেন সেগুলো পলেষ্টীয়রা বুজিয়ে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","এমনকি অবীমেলক পর্যন্ত ইসহাককে বললেন, “আমাদের দেশ ছেড়ে চলে যাও| তুমি আমাদের অপেক্ষা অনেক বেশী শক্তিশালী হয়ে গেছ|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","সুতরাং ইসহাক সেই স্থান ত্যাগ করে সঙ্কীর্ণ গরার নদীর ধারে এসে শিবির স্থাপন করলেন| ইসহাক সেখানে অবস্থান করে সেখানেই বসবাস করতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","এর বহুকাল আগে অব্রাহাম প্রচুর কূপ বা জলাশয় খনন করেছিলেন| অব্রাহাম মারা গেলে পলেষ্টীয়রা সেইসব কূপ মাটি দিয়ে বুজিয়ে ফেলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","তখন ইসহাক ফিরে গিয়ে আবার সেই কূপগুলি খনন করলেন| ইসহাকের ভৃত্যরাও ছোট নদীটির কাছে একটা কূপ খনন করল এবং তারা সেই কূপের মধ্যে একটি জলের ঝর্ণা দেখতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","গরার উপত্যকায় যারা মেষ চরাত তাদের সঙ্গে ইসহাকের লোকজনদের বিবাদ বাধল| তারা বলল, “এই জল আমাদের|” তাই ইসহাক ঐ কূপটির নাম দিলেন এষক| তিনি কূপটির ঐ নাম দিলেন, কারণ ঐখানেই তর্কাতর্কিটা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ইসহাকের লোকরা আর একটি কূপ খনন করল| সেই কূপ নিয়ে ইসহাকের লোকদের সঙ্গে স্থানীয় লোকদের আবার বিবাদ বাধল| তাই ইসহাক ঐ কূপটির নাম দিলেন সিটনা| ");
INSERT INTO ben2006_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","সেখান থেকে সরে গিয়ে ইসহাক আবার একটি কূপ খনন করলেন| এবার ঐ কূপ নিয়ে কেউ বিবাদ করতে এল না। তাই ইস্হাক ঐ কূপটির নাম দিলেন রহোবোত্| ইসহাক বললেন, “এবার প্রভু আমাদের জন্য একটা জায়গা পেয়েছেন| এখানেই আমরা বহুগুণ হব ও সফল হব|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","সেখান থেকে ইসহাক গেলেন বের্-শেবাতে| ");
INSERT INTO ben2006_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","সেই রাত্রে প্রভু ইসহাকের সঙ্গে কথা বললেন| প্রভু বললেন, “আমি তোমার পিতা অব্রাহামের ঈশ্বর| ভয় পেও না| আমি তোমার সঙ্গে আছি এবং তোমায় আশীর্বাদ করছি| তোমার পরিবারকে আমি এক মহান পরিবারে পরিণত করব| আমার বিশ্বস্ত সেবক অব্রাহামের জন্য আমি একাজ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","সুতরাং ইসহাক এক বেদী নির্মাণ করে সেখানে প্রভুর উপাসনা করলেন| ইসহাক সেই জায়গায় তাঁবু স্থাপন করলেন আর তাঁর পরিচারকরা সেখানে কূপ খনন করলো| ");
INSERT INTO ben2006_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","গরার থেকে অবীমেলক এলেন ইসহাকের সঙ্গে দেখা করতে| অবীমেলকের সঙ্গে তাঁর উপদেষ্টা অহূষত্‌ এবং তাঁর সৈন্যাধ্যক্ষ ফীকোলও এলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ইসহাক জিজ্ঞাসা করলেন, “আমার কাছে এসেছেন কেন? আগে আপনি আমার সঙ্গে বন্ধুর মত ব্যবহার করেন নি| এমনকি আপনার রাজ্য থেকে আপনি আমায় তাড়িয়ে দিয়েছিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","উত্তরে তাঁরা বললেন, “এখন আমরা জেনেছি যে প্রভু আপনার সঙ্গে আছেন| আমরা মনে করি যে আমাদের মধ্যে একটা চুক্তি হওয়া উচিৎ‌| আমরা চাই আপনি আমাদের কাছে শপথ নিন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","আমরা আপনাকে কখনও আঘাত করি নি| আপনিও দিব্য করুন যে আমাদের কখনও আঘাত করবেন না| আমরা আপনাকে বহিষ্কার করেছিলাম| এখন এটা পরিষ্কার যে প্রভু আপনাকে আশীর্বাদ করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","সুতরাং ইসহাক অভ্যাগতদের জন্য এক ভোজসভার আয়োজন করলেন| সবাই পরিতৃপ্তির সঙ্গে পানভোজন করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","পরদিন খুব সকালে তাঁরা একে অপরের কাছে একটি প্রতিজ্ঞা করলেন| তারপর তাঁরা শান্তিপূর্ণভাবে বিদায় নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","সেইদিন ইসহাকের ভৃত্যরা এসে তারা যে কূপ খনন করেছিল তার কথা জানাল| তারা বলল, “ঐ কূপের মধ্যে জল পাওয়া গেছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","তাই ইসহাক ঐ কূপের নাম দিলেন শিবিয়া এবং এখনও ঐ নগরী বের্-শেবা নামে পরিচিত| ");
INSERT INTO ben2006_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","এষৌর যখন 40 বছর বয়স হল তখন সে দুজন হিত্তীয় রমণীকে বিবাহ করল| একজন ছিল বেরির কন্যা যিহূদীত্‌| অন্যজন ছিল এলনের কন্যা বাসমৎ‌| ");
INSERT INTO ben2006_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","এই বিবাহ দুটিতে ইসহাক এবং রিবিকা মানসিকভাবে বিপর্যস্ত হয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ইসহাক ক্রমশঃ বৃদ্ধ হলেন, ক্ষীণ হল তাঁর দৃষ্টিশক্তি–আর কিছু ভাল দেখতে পান না| একদিন তিনি বড় পুত্রকে ডাকলেন, “এষৌ!” এষৌ উত্তর দিল, “আমি এখানে|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ইসহাক বললেন, “আমি বৃদ্ধ হয়েছি| শীঘ্রই মারাও যেতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","তাই তোমার তীরধনুক নিয়ে শিকারে যাও| আমার খাওয়ার জন্যে একটা কিছু শিকার করে আনো| ");
INSERT INTO ben2006_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","আমি ভালবাসি এমন কোনও খাবার তৈরী কর| আমায় খাবার এনে দাও, আমি খাই| মৃত্যুর আগে তোমায় আশীর্বাদ করে যাই|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","তখন এষৌ শিকার করতে বেরিয়ে গেল| এসব কথা ইসহাক যখন এষৌকে বলছিলেন তখন রিবিকা সব শুনছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","রিবিকা তাঁর প্রিয় পুত্র যাকোবকে বললেন, “শোন, তোমার পিতা তোমার ভাই এষৌকে কি বলছিলেন সব শুনেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","তোমার পিতা বললেন, ‘আমার খাওয়ার জন্যে একটা জানোয়ার শিকার করে আনো| আমায় রেঁধে দাও, আমি খাই| তাহলে আমি মৃত্যুর আগে তোমায় আশীর্বাদ করব|’ ");
INSERT INTO ben2006_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","এখন শোন বাবা, আমি যা বলি তা করো| ");
INSERT INTO ben2006_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","আমাদের ছাগলের খোঁয়াড়ে যাও, দুটো ছাগল ছানা নিয়ে এস| তোমার পিতা যেমন মাংস খেতে ভালবাসে তেমন করে আমি রেঁধে দেব| ");
INSERT INTO ben2006_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","তারপর সেই খাবার নিয়ে পিতার কাছে যাবে| মৃত্যুর আগে তিনি তোমায় আশীর্বাদ করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","কিন্তু যাকোব মা রিবিকাকে বলল, “আমার ভাযের গা ভর্ত্তি লোম| কিন্তু আমার শরীরের ত্বক মসৃণ| ");
INSERT INTO ben2006_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","পিতা আমায় ছুঁলেই টের পাবেন যে আমি এষৌ নই| তাহলে পিতা আমায় আশীর্বাদ দেবেন না| বরং অভিশাপ দেবেন| কেন? কেননা আমি তাঁর সঙ্গে চালাকি করতে গিয়েছিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","সুতরাং রিবিকা তাকে বললেন, “যদি তিনি অভিশাপ দেন তবে তা আমার ওপর আসুক| আমি যেমন বলছি তেমনটি করো| যাও, আমার জন্য ছাগল নিয়ে এস|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","তখন যাকোব দুটো ছাগল নিয়ে এসে তার মাকে সেগুলি দিল| তার মা ঠিক যেভাবে ইসহাক খেতে ভালবাসেন সেই বিশেষ ভাবে ছাগল দুটো রান্না করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","তারপর রিবিকা বড় পুত্র এষৌর প্রিয় জামাকাপড় নিলেন| সেই জামাকাপড় পরিয়ে দিলেন ছোট পুত্র যাকোবকে। ");
INSERT INTO ben2006_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","আর যাকোবের হাতে ও গলায় লাগিয়ে দিলেন ছাগলের চামড়া| ");
INSERT INTO ben2006_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","তারপর রিবিকা সেই রান্না করা মাংস নিয়ে এসে যাকোবকে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","যাকোব পিতার কাছে গিয়ে ডাকল, “পিতা|” তার পিতা সাড়া দিলেন, “তুমি কে বাবা?” ");
INSERT INTO ben2006_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","যাকোব বলল, “আমি তোমার বড় পুত্র এষৌ| তুমি যেমন বলেছিলে আমি সব তেমনভাবে করে এনেছি| এখন উঠে বসো, তোমার জন্যে যা শিকার করেছি, খাও আগে| আমায় পরে আশীর্বাদ কোরো|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","কিন্তু ইসহাক তাঁর পুত্রকে জিজ্ঞেস করলেন, “তুমি কি করে এত তাড়াতাড়ি জানোয়ার শিকার করলে?” যাকোব উত্তর দিল, “কারণ প্রভু, তোমার ঈশ্বর আমাকে জানোয়ারগুলি তাড়াতাড়ি খুঁজে পেতে সাহায্য করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","তখন ইসহাক যাকোবকে বললেন, “কাছে এস বাবা, আমি তোমায় ছুঁয়ে দেখি, তুমি সত্যিই আমার পুত্র এষৌ কিনা|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","সুতরাং যাকোব তার পিতা ইসহাকের কাছে গেল| ইসহাক তার গায়ে হাত বুলিয়ে বলল, “তোমার গলার স্বর যাকোবের মত শোনাচ্ছে, কিন্তু তোমার হাত এষৌর মত লোমশ|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ইসহাক বুঝতে পারলেন না যে এ আসলে যাকোব| কারণ তার হাত এষৌর হাতের মতোই লোমশ| সুতরাং ইসহাক যাকোবকে আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ইসহাক নিঃসন্দেহ হবার জন্যে আবার জিজ্ঞেস করল, “তুমি সত্যিই আমার পুত্র এষৌ তো?” যাকোব উত্তর দিল, “হ্যাঁ, পিতা, আমিই এষৌ|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","তখন ইসহাক বললেন, “আমাকে আমার পুত্রের শিকার করা পশুগুলির থেকে খাবার এনে দাও| আমি সেটা খেয়ে তোমায় আশীর্বাদ করবো|” তখন যাকোব খাবারটা দিল এবং ইসহাক তা খেলেন| তারপর যাকোব কিছু দ্রাক্ষারস দিলে ইসহাক তা পান করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","তারপর ইসহাক তাকে বললেন, “কাছে এস, আমায় চুমু দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","সুতরাং যাকোব তার পিতার কাছে গিয়ে তাঁকে চুম্বন করল| তখন ইসহাক যাকোবের জামা কাপড়ে এষৌর জামা কাপড়ের গন্ধ পেল এবং তাকে আশীর্বাদ করলেন| ইসহাক বললেন, “যে প্রান্তর প্রভুর আশীর্বাদ ধন্য, আমার সন্তান সেই প্রান্তরের গন্ধ বহে| ");
INSERT INTO ben2006_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","তোমাকে প্রভু প্রচুর বৃষ্টি দিন যাতে প্রচুর ফসল আর দ্রাক্ষারস হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","বহু জাতি তোমায় সেবা করবে এবং তোমার প্রতি নত থাকবে| ভাই জ্ঞাতিদের ওপরে তোমার প্রভুত্ব বহাল হবে| তোমার মাতার পুত্রগণ তোমার অধীন হবে এবং তারা তোমার আদেশে চলবে| তোমাকে যারা শাপ দেবে তারা হবে অভিশপ্ত, যারা তোমাকে আশীর্বাদ করবে তারা আশীর্বাদ পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইসহাক যাকোবকে আশীর্বাদ করা শেষ করলেন| তারপর যেই যাকোব পিতার কাছ থেকে আশীর্বাদ নিয়ে চলে গেল অমনি এষৌ ফিরে এল শিকার থেকে| ");
INSERT INTO ben2006_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","পিতা ঠিক যেমন খেতে ভালবাসে ঠিক সেভাবে এষৌ মাংস রাঁধল| তারপর খাবারটা নিয়ে এল পিতার কাছে| পিতাকে সে বলল, “পিতা, আমি তোমার পুত্র| ওঠো, তোমার জন্য শিকার করে আমি মাংস রেঁধে নিয়ে এসেছি, খাও, তারপরে আমায় আশীর্বাদ করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","কিন্তু ইসহাক জিজ্ঞেস করলেন, “তুমি কে?” সে উত্তর দিল, “আমি তোমার পুত্র–তোমার বড় পুত্র এষৌ|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","তখন ইসহাক মহা উদ্বিগ্ন হলেন| জিজ্ঞেস করলেন, “তাহলে তুমি আসার আগে কে মাংস রান্না করে এনে দিল আমায়? আমি সমস্ত মাংস খেয়ে তাকে আশীর্বাদ করলাম| এখন সেই আশীর্বাদ ফিরিয়ে নেওয়ার পক্ষেও ঢের দেরী হয়ে গেছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","এষৌ তার পিতার কথা শুনল| সে খুব ক্রুদ্ধ ও তিক্ত হয়ে উঠল| সে চিৎকার করে কেঁদে উঠল| পিতাকে বলল, “তাহলে আমাকেও আশীর্বাদ করো, পিতা!” ");
INSERT INTO ben2006_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ইসহাক বললেন, “তোমার ভাই আমার সঙ্গে চালাকি করেছে! সে এসে তোমার আশীর্বাদ নিয়ে গেছে!” ");
INSERT INTO ben2006_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","এষৌ বলল, “তার নাম যাকোব| ওর জন্যে ঐ নামই ঠিক| আমার সঙ্গে ভাই দুবার চালাকি করল| প্রথমবার কৌশলে সে প্রথম সন্তান হিসেবে আমার যা অধিকার ছিল তার থেকে বঞ্চিত করেছে এবং এবার আমার প্রাপ্য আশীর্বাদ থেকে আমাকে বঞ্চিত করল|” তারপর এষৌ জিজ্ঞেস করল, “আমার জন্য কি তোমার আর কোন আশীর্বাদ অবশিষ্ট নেই?” ");
INSERT INTO ben2006_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ইসহাক উত্তর দিলেন, “না, তার জন্য বড় দেরী হয়ে গেছে| আমি তোমায় শাসন করার অধিকারও যাকোবকে দিয়ে ফেলেছি| আমার আশীর্বাদে সে পাবে তার সমস্ত ভাইদের সেবা| আর আমি তাকে প্রচুর শস্য আর দ্রাক্ষারসের জন্য আশীর্বাদ দিয়েছি| তোমায় আশীর্বাদ করার জন্য আর কিছু বাকি নেই|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","কিন্তু এষৌ আশীর্বাদের জন্যে পিতাকে পীড়াপীড়ি করে বলল, “পিতা তোমার কাছে কি শুধুমাত্র একটিই আশীর্বাদ আছে?” এষৌ কাঁদতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","তখন ইসহাক বললেন, “তুমি কখনও উর্বর জমি পাবে না, তুমি কখনও পর্যাপ্ত বর্ষা পাবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তোমাকে লড়তে হবে জীবনের জন্য এবং ভ্রাতার ভৃত্য হবে তুমি| কিন্তু লড়ে তুমি হবে সম্পূর্ণ স্বাধীন| মুক্তি পাবে তোমার ভ্রাতার শাসন থেকে|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","তারপর এই আশীর্বাদের জন্য এষৌ যাকোবকে ঘৃণা করতে শুরু করল| মনে মনে এষৌ ভাবল, “আমার পিতা শীঘ্রই মারা যাবেন| তার জন্য শোক করার সময় শেষ হবার পরে আমি যাকোবকে হত্যা করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","রিবিকা জানলেন যে এষৌ যাকোবকে হত্যা করার কথা ভাবছে| তিনি যাকোবকে ডেকে পাঠালেন| যাকোবকে তিনি বললেন, “শোন, তোমার ভাই এষৌ তোমায় হত্যা করার কথা ভাবছে| ");
INSERT INTO ben2006_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","তাই আমি যা বলি তা-ই করো| আমার ভাই লাবন বাস করে হারণে| তার কাছে গিয়ে তুমি লুকিয়ে থাকো| ");
INSERT INTO ben2006_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","তার কাছে তুমি কিছুদিন থাকো যতদিন না তোমার ভাইয়ের রাগ পড়ে| ");
INSERT INTO ben2006_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","কিছুদিন পরে তোমার ভাই, তুমি তার প্রতি কি করেছ না করেছ সব ভুলে যাবে| তখন আমি তোমায় ফিরিয়ে আনার জন্যে একটি ভৃত্য পাঠাব| আমি একই দিনে আমার দু পুত্রকে হারাতে চাই না|” ");
INSERT INTO ben2006_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","তারপর রিবিকা ইসহাককে বললেন, “তোমার পুত্র এষৌ হিত্তীয়দের কন্যাকে বিয়ে করেছে| এ আমার মোটে ভাল লাগে নি| কেননা তারা আমাদের আপনজন নয়| যাকোবও যদি ঐ মেয়েদের কাউকে বিয়ে করে তাহলে আমি নির্ঘাত মারা যাব|” ");
INSERT INTO ben2006_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ইসহাক যাকোবকে ডেকে পাঠালেন এবং তাকে আশীর্বাদ করলেন| তারপর ইসহাক যাকোবকে একটি আজ্ঞা করলেন| তিনি বললেন, “তুমি কখনও কনানের মেয়ে বিয়ে করবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","তাই এই জায়গা ছেড়ে পদ্দন্-অরামে চলে যাও| তোমার দাদামশায বথূয়েলের কাছে যাও| তোমার মামা লাবনের কন্যাদের কোন একজনকে বিয়ে করো| ");
INSERT INTO ben2006_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","প্রার্থনা করি যে সর্বশক্তিমান ঈশ্বর তোমায় আশীর্বাদ করবেন এবং তোমায় বহু সন্তানসন্ততি দেবেন| তুমি যাতে এক মহান জাতির জনক হও তার জন্য আমি প্রার্থনা করি| ");
INSERT INTO ben2006_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","যেভাবে ঈশ্বর অব্রাহামকে আশীর্বাদ করেছিলেন সেভাবে তিনি যেন তোমায় ও তোমার সন্তানসন্ততিকে আশীর্বাদ করেন-এই প্রার্থনা করি এবং আমি প্রার্থনা করি যে যে দেশে তুমি বাস করবে সেই দেশ তোমার হবে| ঈশ্বর এই দেশ অব্রাহামকে দিয়েছিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","তখন ইসহাক যাকোবকে পদ্দন্-অরাম নামক স্থানে পাঠালেন| যাকোব গেলেন রিবিকার ভাই লাবনের কাছে| বথুযেল লাবন ও রিবিকার জনক এবং যাকোব ও এষৌর মা হলেন রিবিকা| ");
INSERT INTO ben2006_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","এষৌ জানতে পারল যে তার পিতা ইসহাক যাকোবকে আশীর্বাদ করেছেন| এষৌ জানল যে ইসহাক যাকোবকে পদ্দন-অরামে পাঠিয়েছেন সেখানে বিয়ে করার জন্যে| ইসহাক যে যাকোবকে কনানের মেয়ে বিয়ে না করার আদেশ দিয়েছেন সে কথাও এষৌ জানল| ");
INSERT INTO ben2006_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","এষৌ জানল যে যাকোব পিতামাতাকে মেনে চলেছে এবং পদ্দন্-অরামে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","এসবের থেকে এষৌ বুঝল যে তাদের পিতা ইসহাক চাইতেন না যে পুত্ররা কেউ কনানের মেয়েদের বিয়ে করে| ");
INSERT INTO ben2006_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","এষৌর তখনই দুজন স্ত্রী ছিল| কিন্তু সে ইশ্মায়েলের কাছে গিয়ে আরও একটি বিয়ে করল| এবার সে ইশ্মায়েলের কন্যা মহলত্‌কে বিয়ে করল| অব্রাহামের আর এক পুত্র ইশ্মায়েল| মহলত্‌ নবায়োতের বোন| ");
INSERT INTO ben2006_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","যাকোব বের্-শেবা ছেড়ে হারণে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","হারণে যাওয়ার পথে সূর্যাস্ত হল| তখন যাকোব রাত কাটাবার জন্য একটা জায়গায় গেল| সেখানে একটা পাথর দেখতে পেয়ে সে তার ওপরে মাথা রেখে ঘুমিয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ঘুমের মধ্যে যাকোব একটা স্বপ্ন দেখল| সে দেখল, মাটি থেকে একটা সিঁড়ি গেছে স্বর্গে| যাকোব দেখল যে ঈশ্বরের দূতরা ঐ সিঁড়ি দিয়ে ওঠানামা করছে| আর যাকোব দেখল যে প্রভু সিঁড়িতে দাঁড়িয়ে আছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","প্রভু বললেন, “আমিই প্রভু, তোমার পিতামহ অব্রাহামের ঈশ্বর| আমি ইসহাকের ঈশ্বর| যে জমিতে তুমি এখন শুয়ে আছ তা আমি তোমাকে দেব| এই জমি আমি তোমাকে এবং তোমার বংশকে দেব| ");
INSERT INTO ben2006_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তোমার বহু সংখ্যক উত্তরপুরুষ হবে| তারা পৃথিবীর ধূলোর মতো অসংখ্য হবে| তারা পূর্ব, পশ্চিম, উত্তর ও দক্ষিণে ছড়িয়ে পড়বে| পৃথিবীর সব জাতিরা তোমার এবং তোমার উত্তরপুরুষদের মাধ্যমে আশীর্বাদ পাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“আমি তোমার সঙ্গে আছি| তুমি যে কোন জায়গায় যাও না কেন আমি তোমাকে রক্ষা করব এবং এই দেশে আবার ফিরিয়ে আনব| আমি তোমার কাছে যা প্রতিজ্ঞা করেছি তা পূর্ণ না করা পর্যন্ত আমি তোমায় ত্যাগ করব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","যাকোব ঘুম থেকে উঠে বলল, “আমি জানি প্রভু এই জায়গায় রয়েছেন| কিন্তু আমি না ঘুমানো পর্যন্ত জানতাম না যে তিনি এখানে রয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","যাকোব ভয় পেল| সে বলল, “এ এক মহান জায়গা| এই হল ঈশ্বরের গৃহ| এই হল স্বর্গের দ্বার|” ");
INSERT INTO ben2006_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","যাকোব খুব ভোরে উঠে পড়ল| যে পাথরে মাথা রেখে শুয়েছিল তা দাঁড় করিয়ে স্থাপন করল| তারপর সে সেই পাথরের উপর তেল ঢালল| এইভাবে সে সেই পাথরকে ঈশ্বরের স্মরনার্থে স্মৃতি চিহ্নস্বরূপ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","সেই জায়গার নাম ছিল লুস কিন্তু যাকোব তার নাম বৈথেল রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","এরপর যাকোব এক প্রতিজ্ঞা করে বলল, “যদি ঈশ্বর আমার সহায় থাকেন, যদি তিনি আমাকে এ যাত্রায় রক্ষা করেন, যদি তিনি আমার খাদ্য ও পরণের কাপড় যোগান, ");
INSERT INTO ben2006_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","আর যদি আমি শান্তিতে আমার পিতার গৃহে ফিরতে পারি, যদি ঈশ্বর এই সমস্ত কিছুই সাধন করেন তাহলে প্রভুই আমার ঈশ্বর হবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","এই পাথর আমি স্মৃতিস্তম্ভ রূপে স্থাপন করছি| এটা প্রমাণ করবে যে এ জায়গা ঈশ্বরের উদ্দেশ্যে এক পবিত্র জায়গা এবং ঈশ্বর আমাকে যা কিছু দেবেন তার দশ ভাগের এক ভাগ অংশ আমি ঈশ্বরকে দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","তারপর যাকোব আবার তার যাত্রা পথে চলল| সে পূর্বদিকের দেশে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","যাকোব তাকিয়ে দেখল মাঠে একটা কূপ রয়েছে| কূপের ধারে ছিল তিন পাল মেষ| মেষরা এই কূপের জলই পান করত| একটা বড় পাথর দিয়ে কূপের মুখটা ঢাকা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","পালের সব মেষ জড়ো হলে মেষপালকরা কূপের মুখ থেকে পাথরটা গড়িয়ে দিতো| তখন সব মেষরা জল পান করত| মেষদের জল পান শেষ হলে মেষপালকরা সেই পাথরটা আবার যথাস্থানে গড়িয়ে দিত| ");
INSERT INTO ben2006_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","সেখানকার মেষপালকদের যাকোব বলল, “ভাইরা, তোমরা কোথা থেকে এসেছ?” তারা উত্তরে বলল, “আমরা হারোণ থেকে এসেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","তখন যাকোব বলল, “তোমরা কি নাহোরের পুত্র লাবনকে চেন?” মেষপালকরা উত্তরে বলল, “আমরা তাঁকে চিনি|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","তখন যাকোব বলল, “তিনি কেমন আছেন?” তারা বলল, “তিনি ভাল আছেন| সব কিছু ঠিকঠাক রয়েছে| দেখুন, তাঁর কন্যা রাহেল এখন মেষপাল নিয়ে আসছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","যাকোব বলল, “দেখ, এখনও দিনের আলো রয়েছে এবং সূর্য ডুবতে এখনও দেরী| মেষ জড়ো করার সময় তো এখন নয়| তাই তাদের জল পান করিয়ে মাঠে আবার চরতে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","কিন্তু মেষপালকরা বলল, “সব মেষপাল এক জায়গায় জড়ো না হওয়া পর্যন্ত আমরা তা করতে পারি না| তারপর আমরা কূপের মুখ থেকে পাথর সরিয়ে দেব আর সব মেষ জল পান করতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","যে সময় যাকোব মেষপালকদের সঙ্গে কথা বলছিল, সে সময় রাহেল তার পিতার মেষপাল নিয়ে এল| (রাহেলের কাজ ছিল মেষদের যত্ন নেওয়া|) ");
INSERT INTO ben2006_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","রাহেল ছিল লাবনের কন্যা| লাবন ছিলেন যাকোবের মাতার অর্থাৎ‌ রিবিকার ভাই| যাকোব রাহেলকে দেখে এগিয়ে গিয়ে পাথর সরিয়ে তার মামার মেষদের জল দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","পরে যাকোব রাহেলকে চুমু খেয়ে উঁচু গলায় কাঁদতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","যাকোব রাহেলকে বলল যে সে তার পিতার পরিবারের দিক দিয়ে আত্মীয় - রিবিকার পুত্র| তাই রাহেল দৌড়ে বাড়ী গিয়ে তার পিতাকে তা জানাল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","লাবন তাঁর বোনের পুত্র যাকোবের কথা শুনলেন| এবার তাই লাবন দৌড়ে তার সঙ্গে দেখা করতে গেলেন| লাবন তাকে জড়িয়ে ধরে চুমু খেলেন এবং নিজের বাড়ীতে নিয়ে এলেন| যা ঘটেছিল তার সব কিছু যাকোব লাবনকে বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","তখন লাবন বললেন, “তুমি যে আমার পরিবারের একজন এ বড়ই আনন্দের!” তাই লাবন যাকোবের সঙ্গে এক মাস কাটালেন। ");
INSERT INTO ben2006_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","একদিন লাবন যাকোবকে বললেন, “পারিশ্রমিক বিনা আমার জন্য তোমার এই পরিশ্রম করাটা ঠিক হচ্ছে না| তুমি আমার আত্মীয়, দাস নও| আমি তোমায় কি পারিশ্রমিক দেব?” ");
INSERT INTO ben2006_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবনের দুটি কন্যা ছিল| বড়টির নাম লেয়া এবং ছোটটির নাম রাহেল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","রাহেল সুন্দরী ছিল| লেয়ার চোখ দুটি শান্ত ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","যাকোব রাহেলকে ভালোবাসল| যাকোব লাবনকে বলল, “আমি সাত বছর কাজ করব যদি আপনি আমাকে আপনার কনিষ্ঠা কন্যা রাহেলকে বিয়ে করতে দেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","লাবন বললেন, “অন্য কারও সঙ্গে বিয়ে হওয়ার থেকে তোমার সঙ্গে বিয়ে হওয়াটা ওর পক্ষে মঙ্গল হবে| তাই আমাদের সঙ্গে থেকে যাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","তাই যাকোব থেকে গেল এবং লাবনের জন্য সাত বছর কাজ করল| কিন্তু রাহেলকে সে ভালবাসত বলে এই সাত বছর সময় তার কাছে অল্প বলে মনে হল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","সাত বছর পর যাকোব লাবনকে বলল, “রাহেলকে আমায় দিন, আমি তাকে বিয়ে করব| আপনার কাছে পরিশ্রম করার মেযাদ শেষ হয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","তাই লাবন সেখানকার সমস্ত লোককে ভোজে নিমন্ত্রিত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","সেই রাত্রে লাবন তাঁর কন্যা লেয়াকে যাকোবের কাছে নিয়ে এলেন| যাকোব ও লেয়া যৌন সহবাস করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(লাবন তার দাসী সিল্পাকে তার কন্যার দাসী হবার জন্যও দিলেন|) ");
INSERT INTO ben2006_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","সকাল বেলা যাকোব দেখলেন তিনি লেয়ার সাথে রাত কাটিয়েছেন| যাকোব লাবনকে বলল, “আপনি আমার সঙ্গে চালাকি করেছেন| রাহেলকে বিয়ে করার জন্য আপনার জন্য কত কঠোর পরিশ্রম করেছি, তবে কেন আপনি আমার সঙ্গে এই চালাকি করলেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","লাবন বললেন, “আমাদের দেশের প্রথা অনুযায়ী বড় কন্যার আগে ছোট কন্যার বিয়ে আমরা দিই না| ");
INSERT INTO ben2006_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","কিন্তু বিবাহ উৎসবের পুরো সপ্তাহটা কাটাও আর আমি রাহেলের সঙ্গে তোমার বিয়ে দেব| কিন্তু তুমি আরও সাতবছর আমার সেবা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","সুতরাং যাকোব তাই করলেন এবং বিবাহ অনুষ্ঠানের সপ্তাহটি শেষ করলেন| তখন লাবন তার কন্যা রাহেলকে যাকোবের স্ত্রী হতে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(লাবন তার দাসী বিল্হাকে রাহেলের দাসী হিসেবে দিলেন|) ");
INSERT INTO ben2006_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","সুতরাং যাকোব রাহেলের সঙ্গেও যৌন সহবাস করলেন| আর যাকোব রাহেলকে লেয়ার থেকেও বেশী ভালবাসত| যাকোব লাবনের জন্য আরও সাত বছর পরিশ্রম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","প্রভু দেখলেন যে যাকোব লেয়ার থেকে রাহেলকে বেশী ভালবাসে| তাই প্রভু লেয়াকে সন্তান প্রসবের জন্য সক্ষম করলেন| কিন্তু রাহেলের সন্তান হল না| ");
INSERT INTO ben2006_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","লেয়া এক পুত্রের জন্ম দিলেন| তিনি তার নাম রাখলেন রূবেণ| লেয়া তার এই নাম দিলেন কারণ তিনি বললেন, “প্রভু আমার কষ্ট সকল দেখেছেন| আমার স্বামী আমায় ভালবাসেন না| তাই এবার আমার স্বামী আমায় ভালবাসতেও পারেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","লেয়া আবার গর্ভবতী হলেন এবং তাঁর আর একটি পুত্র হল| তিনি তার নাম রাখলেন শিমিয়োন| লেয়া বললেন, “আমি যে ভালবাসা থেকে বঞ্চিত তা প্রভু শুনেছেন তাই তিনি আমাকে এই পুত্র দিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","লেয়া আবার গর্ভবতী হলেন এবং তাঁর আর একটি পুত্র হল| তিনি এই পুত্রের নাম লেবি রাখলেন| লেয়া বললেন, “এবার অবশ্যই আমার স্বামী আমায় ভালবাসবেন| আমি তাঁকে তিনটি পুত্র দিয়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","এরপর লেয়া আর একটি পুত্রের জন্ম দিলেন| তিনি এই পুত্রের নাম রাখলেন যিহূদা| লেয়া তার এই নাম রাখলেন কারণ তিনি বললেন, “এখন আমি প্রভুর প্রশংসা করব|” এবার লেয়ার আর সন্তান হল না| ");
INSERT INTO ben2006_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","রাহেল দেখল যে সে যাকোবকে কোন সন্তান দিতে পারে নি| রাহেল তাই তার বোন লেয়ার প্রতি ঈর্ষান্বিত হল| তাই রাহেল যাকোবকে বলল, “আমায় সন্তান দিন নতুবা আমি মারা যাব!” ");
INSERT INTO ben2006_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","যাকোব রাহেলের প্রতি ক্রুদ্ধ হল| সে বলল, “আমি ঈশ্বর নই| ঈশ্বরই তোমার গর্ভ রুদ্ধ করে রেখেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","তারপর রাহেল বলল, “আপনি আমার দাসী বিল্হাকে নিন| তার সাথে শয়ন করুন এবং সে আমার জন্য সন্তান প্রসব করবে| তাহলে আমি তার মাধ্যমে মাতা হতে পারব|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","তাই রাহেল বিল্হাকে যাকোবের কাছে পাঠাল| যাকোব বিল্হার সঙ্গে যৌন সহবাস করল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","বিল্হা গর্ভবতী হয়ে যাকোবের জন্য এক পুত্রের জন্ম দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","রাহেল বলল, “ঈশ্বর আমার প্রার্থনা শুনেছেন| তিনি তাই আমার এক পুত্র দিতে মনস্থ করলেন|” তাই রাহেল এই সন্তানের নাম দান রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","বিল্হা আবার গর্ভবতী হয়ে দ্বিতীয় পুত্রের জন্ম দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","রাহেল বলল, “আমি আমার বোনের সঙ্গে ভারী প্রতিদ্বন্দিতা করেছি এবং আমি জিতেছি|” তাই সে সেই পুত্রের নাম দিল নপ্তালি| ");
INSERT INTO ben2006_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","লেয়া দেখলেন যে তার আর সন্তান হবার সম্ভাবনা নেই| তাই তিনি তাঁর দাসী সিল্পাকে যাকোবকে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","এবার সিল্পার এক পুত্র হল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","লেয়া বললেন, “আমি খুবই সৌভাগ্যবতী|” তাই তিনি এই পুত্রের নাম গাদ রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","সিল্পা আর একটি পুত্রের জন্ম দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","লেয়া বললেন, “আমি অত্যন্ত আনন্দিত! এখন হতে স্ত্রী লোকরা আমায় ধন্যা বলবে|” তাই তিনি তার নাম আশের রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","গম কাটার সময় রূবেণ ক্ষেতে গিয়ে একটি বিশেষ ধরণের ফুল দেখতে পেল| রূবেণ সেই ফুলগুলি তার মা লেয়ার কাছে নিয়ে এল| কিন্তু রাহেল লেয়াকে বলল, “তোমার পুত্রের আনা ঐ ফুলের কিছু আমাকে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","লেয়া উত্তরে বললেন, “তুমি এর মধ্যেই আমার স্বামীকে নিয়ে নিয়েছ| এখন তুমি আমার পুত্রের ফুলগুলিও নিতে চাইছ?” কিন্তু রাহেল বলল, “তুমি তোমার পুত্রের আনা ফুল আমায় দিলে আজ রাত্রে আমার স্বামীর সঙ্গে সহবাস করতে পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ক্ষেত থেকে রাতে যাকোব বাড়ী ফিরল| লেয়া তাকে দেখে তার সঙ্গে সাক্ষাৎ করতে বাইরে এলেন| তিনি বললেন, “আজ রাতে তুমি আমার সঙ্গে শোবে| আমি তোমার জন্য মূল্য হিসাবে আমার পুত্রের ফুল দিয়ে দিয়েছি|” তাই সেই রাত্রে যাকোব লেয়ার সঙ্গে শয়ন করল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","এরপর ঈশ্বরের দয়ায় লেয়া আবার গর্ভবতী হলেন| তিনি পঞ্চম পুত্রের জন্ম দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","লেয়া বললেন, “আমি আমার দাসীকে আমার স্বামীর কাছে পাঠানোর বেতন হিসাবে ঈশ্বর আমাকে এই সন্তান দিলেন|” তিনি সেই পুত্রের নাম ইষাখর রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","লেয়া আবার গর্ভবতী হয়ে ষষ্ঠ পুত্রের জন্ম দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","লেয়া বললেন, “ঈশ্বর আমাকে অপূর্ব উপহার দিলেন| এখন নিশ্চয়ই যাকোব আমাকে গ্রহণ করবেন কারণ আমি তাকে দুটি পুত্র দিয়েছি|” তাই লেয়া সেই পুত্রের নাম সবূলূন রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","পরে লেয়া একটি কন্যার জন্ম দিলেন| তিনি তার নাম রাখলেন দীণা| ");
INSERT INTO ben2006_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","এবার ঈশ্বর রাহেলের প্রার্থনা শুনলেন| ঈশ্বর রাহেলের গর্ভ মুক্ত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","রাহেল গর্ভবতী হয়ে এক পুত্রের জন্ম দিল| রাহেল বলল, “ঈশ্বর আমার লজ্জা দূর করেছেন এবং এক পুত্র দিয়েছেন|” তাই রাহেল ঈশ্বর আমাকে আর একটি পুত্র দিন, একথা বলে তার নাম রাখল যোষেফ| ");
INSERT INTO ben2006_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","যোষেফের জন্মের পর যাকোব লাবনকে বলল, “এবার আমাকে আমার বাড়ী ফিরতে দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","আমাকে আমার স্ত্রী ও পুত্রদের নিয়ে যেতে দিন| আমি 14 বছর পরিশ্রম করে তাদের আপনার কাছ থেকে লাভ করেছি| আপনি জানেন আমি ভালভাবেই আপনার সেবা করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","লাবন তাকে বললেন, “এখন আমায় কিছু বলতে দাও! আমি জানি তোমার জন্যই প্রভু আমায় মনোনীত করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","আমায় বল তোমার পারিশ্রমিক হিসাবে কি দিতে হবে আর আমি তোমায় তা দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","যাকোব উত্তরে বলল, “আপনি জানেন যে আমি আপনার জন্য কঠোর পরিশ্রম করেছি| আমার তত্ত্বাবধানে আপনার পশুবল ভালই রয়েছে এবং বৃদ্ধি পেয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","যখন আমি এসেছিলাম তখন আপনার অল্পই ছিল| কিন্তু এখন আপনার প্রচুর হয়েছে| প্রতিবার আমি আপনার জন্য কিছু কাজ করলে প্রভু আপনাকে আশীর্বাদ করেছেন| এখন সময় এসেছে আমার নিজের জন্য কাজ করার| সময় এসেছে আমার নিজের গৃহ তৈরীর|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","লাবন জিজ্ঞাসা করলেন, “তাহলে আমি তোমায় কি দেব?” যাকোব উত্তরে বলল, “আমি আপনার কাছ থেকে কিছু চাই না| কেবল চাই আপনি আমার শ্রমের বেতন দিন| কেবল এই একটি কাজ করুন; আমি ফিরে গিয়ে আপনার মেষপালের যত্ন নেব| ");
INSERT INTO ben2006_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","কিন্তু আজকে আমাকে আপনার সমস্ত পশুপালের মধ্যে দিয়ে যেতে দিন এবং যে সমস্ত মেষের গায়ে গোল গোল দাগ এবং ডোরা কাটা দাগ রয়েছে তাদের প্রত্যেককে নিতে দিন| আর সমস্ত কালো ছাগ শিশুও আমাকে নিতে দিন| এবং গোল গোল দাগ ও ডোরা কাটা দাগ রয়েছে এমন সমস্ত স্ত্রী ছাগ শিশুও আমার হোক্্| সেই হবে আমার বেতন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","তাহলে আমি আপনার প্রতি বিশ্বস্ত কিনা তা সহজেই বুঝতে পারবেন| আপনি এসে আমার পশুপাল দেখতে পারেন| যদি কোন ছাগ চিত্র বিচিত্র না হয় এবং মেষ কালো রঙের না হয় তাহলেই আপনি বুঝতে পারবেন যে আমি চুরি করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","লাবন বললেন, “এতে আমার সম্মতি রয়েছে| তুমি যা চাইলে আমরা সেই মত করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","কিন্তু সেই দিন লাবন সমস্ত চিত্র বিচিত্র পুং ছাগল এবং চিতল স্ত্রী ছাগলগুলিকে লুকিয়ে ফেললেন এবং কালো মেষগুলিকে লুকিয়ে ফেললেন| লাবন তার পুত্রদের সেই সমস্ত পাহারা দিতে বললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","তাই তার পুত্ররা চিত্র-বিচিত্র সেই সকল পশু নিয়ে তাদের অন্য এক জায়গায় চরিয়ে নিয়ে তিন দিন পথের দূরত্ব বজায় রাখলেন| বাকী পশু যা পড়ে রইল যাকোব তার যত্ন নিল| কিন্তু সেই পালে চিত্র বিচিত্র অথবা রঙীন কোন পশুই ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","তাই যাকোব ঝাউ ও বাদাম গাছের কচি ডালপালা কাটল এবং ডালের ছাল কিছুটা করে ছাড়াল যাতে ডোরা কাটা দেখায়| ");
INSERT INTO ben2006_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","যাকোব সেই ডালগুলি পশুদের জল খাওয়ার জায়গার সামনে রাখল| পশুরা সেইস্থানে জল পান করতে এলে ");
INSERT INTO ben2006_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","সঙ্গমও করল| এরপর সেই ডালের সামনে সঙ্গম করা পশুদের চিত্র বিচিত্র, ডোরাকাটা অথবা কালো শাবক জন্মাল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","পশুপালের জন্য সমস্ত পশুর মধ্যে থেকে যাকোব চিত্র বিচিত্র ও কালো পশুদের পৃথক করল| যাকোব তার পশুদের লাবনের পশুদের থেকে আলাদা করে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","যে কোন সময় বলবান পশুরা সঙ্গম করলে যাকোব সেই ডালগুলি তাদের সামনে রাখত| বলবান পশুরা সেই ডালপালার সামনে সঙ্গম করত| ");
INSERT INTO ben2006_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","কিন্তু দুর্বল পশুরা সঙ্গম করলে যাকোব সেখানে ডালগুলি রাখত না| তাই দুর্বল পশুদের শাবকগুলি লাবনের হল| আর বলবান পশুদের শাবকগুলি হল যাকোবের| ");
INSERT INTO ben2006_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","এইভাবে যাকোব বেশ ধনী হয়ে উঠল| তার অনেক পশু, ভৃত্য, উট এবং গাধা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","একদিন যাকোব শুনল যে লাবনের পুত্ররা কথাবার্তা বলছে| তারা বলল, “আমাদের পিতার সবকিছুই যাকোব নিয়ে নিয়েছে| যাকোব খুবই ধনী হয়েছে| ওর এই ধনের সবটাই সে আমাদের পিতার কাছ থেকে নিয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","যাকোব লক্ষ্য করল যে লাবন অতীতের মত আর বন্ধুমনোভাবাপন্ন নয়| ");
INSERT INTO ben2006_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","প্রভু যাকোবকে বললেন, “তোমার পূর্বপুরুষেরা যে দেশে বাস করতেন, তোমার সেই নিজের দেশে ফিরে যাও| আমি তোমার সঙ্গে সঙ্গে থাকব|” ");
INSERT INTO ben2006_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","তাই যাকোব রাহেল ও লেয়াকে সেই মাঠে দেখা করতে বলল| যেখানে সে তার মেষপাল ও ছাগপাল রেখেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","যাকোব রাহেল ও লেয়াকে বলল, “আমি দেখছি যে তোমাদের পিতা আমার ওপর রেগে গেছেন| অতীতে সব সময় তিনি আমার সঙ্গে বন্ধুত্বের মনোভাব পোষণ করতেন কিন্তু তিনি আর সেরকম নন| কিন্তু আমার পিতা ঈশ্বর আমার সঙ্গে রয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","তোমরা উভয়েই জান আমি তোমাদের পিতার জন্য আমার সাধ্যমত কঠোর পরিশ্রম করেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","কিন্তু তোমাদের পিতা আমাকে ঠকিয়েছেন| এই নিয়ে দশবার তিনি আমার বেতন বদলেছেন| কিন্তু এই সকল সময় ঈশ্বর লাবনের সমস্ত চালাকি হতে আমাকে রক্ষা করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“একবার লাবন বললেন, ‘বিন্দু চিহ্নিত সমস্ত ছাগল তুমি রাখতে পার| তাই হবে তোমার বেতন|’ তিনি এই কথা বলার পর সমস্ত পশুর বিন্দু চিহ্নিত শাবক জন্মাল| তাই সেসব আমারই হল| কিন্তু তখন লাবন বললেন, ‘সব বিন্দু চিহ্নিত ছাগল আমার| তুমি ডোরা কাটা ছাগগুলি রাখতে পার| সেই হবে তোমার বেতন|’ তিনি একথা বলার পর সমস্ত পশু ডোরাকাটা শাবকের জন্ম দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","সুতরাং ঈশ্বরই পশুগুলিকে তোমার পিতার কাছ থেকে নিয়ে আমায় দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“একটি স্বপ্নে আমি দেখলাম, দলের সঙ্গে সঙ্গম করছে যে পুরুষ ছাগলরা, তাদেরই গায়ে ডোরাকাটা এবং ছোপমারা| ");
INSERT INTO ben2006_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ঈশ্বরের দূত সেই স্বপ্নে আমার সঙ্গে কথা বললেন, ‘যাকোব!’ “আমি উত্তর দিলাম, ‘আজ্ঞে!’ ");
INSERT INTO ben2006_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“দূত আমাকে উত্তর দিলেন, ‘দেখ, কেবল ডোরাকাটা ও বিন্দু চিহ্নিত ছাগলরাই সঙ্গম করছে| আমিই তা ঘটাচ্ছি| লাবন তোমার প্রতি যে সমস্ত অন্যায় করেছেন তার সমস্তই আমি দেখেছি| আমি এমনটা করছি যাতে সমস্ত ছাগ শাবক তোমারই হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","আমি সেই ঈশ্বর যিনি বৈথেলে তোমার কাছে এসেছিলাম| সেই স্থানে তুমি এক বেদী স্থাপন করেছিলে| তুমি সেই বেদীতে ওলিভ তেল ঢেলেছিলে এবং আমার কাছে এক প্রতিজ্ঞা করেছিলে| এখন আমি চাই যে তুমি যে দেশে জন্মেছিলে সেই দেশে ফিরে যাবার জন্য প্রস্তুত হও|’” ");
INSERT INTO ben2006_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","রাহেল ও লেয়া যাকোবকে উত্তরে বললেন, “আমাদের পিতা তার মৃত্যুর সময় আমাদের জন্য কিছু রেখে যাবেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","তিনি আমাদের সঙ্গে এমন ব্যবহার করেন যেন আমরা বিদেশী| তিনি আমাদের তোমার কাছে বিক্রি করেছেন এবং তারপর যে অর্থ আমাদের পাবার কথা তা তিনি খরচ করে ফেলেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ঈশ্বর এই সমস্ত ধন আমাদের পিতার কাছ থেকে নিয়েছেন যার মালিক এখন আমরা এবং আমাদের সন্তানরা| সেইজন্য ঈশ্বর যেমনটি বলেছেন সেই মতোই আপনার কাজ করা উচিৎ‌|” ");
INSERT INTO ben2006_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","সেইজন্য যাকোব যাত্রার জন্য প্রস্তুত হল| সে তার সব পুত্রদের ও স্ত্রীদের উটের পিঠে ওঠাল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","তারপর তারা কনান দেশে ফিরে গেল যেখানে যাকোবের পিতা বাস করতেন| যাকোবের সমস্ত পশুপাল তার সামনে সামনে হেঁটে চলল| পদ্দন্-অরামে থাকাকালীন সে যে সমস্ত কিছু অর্জন করেছিল তার সব কিছু নিয়ে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","সেই সময় লাবন মেষদের লোম ছাঁটতে গেলেন| তিনি সেই কাজে যাওয়ার পরে রাহেল তার ঘরে ঢুকে তার পিতার ঠাকুরগুলোকে চুরি করল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","যাকোব অরামীয় লাবনের সঙ্গে চালাকি করল কারণ তার চলে যাবার বিষয়ে সে তাঁকে জানাল না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","যাকোব তার পরিবার ও সমস্ত সম্পত্তি নিয়ে দ্রুত বেরিয়ে পড়ল| তারা ফরাৎ নদী পার হয়ে পর্বতময় প্রদেশ গিলিয়দের দিকে রওনা দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","তিন দিন পরে লাবন জানতে পারলেন যে যাকোব পালিয়ে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","তাই লাবন তাঁর লোকজন জড়ো করে যাকোবের পেছনে ধাওয়া করে চললেন| সাত দিন পর লাবন যাকোবকে পার্বত্য গিলিয়দ দেশের কাছে দেখতে পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","সেই রাতে ঈশ্বর স্বপ্নে লাবনের কাছে গেলেন| ঈশ্বর বললেন, “সাবধান! যাকোবের সঙ্গে ভেবে চিন্তে কথা বোলো!” ");
INSERT INTO ben2006_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","পরের দিন সকাল বেলা লাবন যাকোবকে দেখতে পেলেন| যাকোব পর্বতের উপরে তার তাঁবু খাটিয়েছিল| তাই লাবন ও তাঁর লোকজন পর্বতময় প্রদেশ গিলিয়দে তাঁদের তাঁবু খাটালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","লাবন যাকোবকে বললেন, “তুমি কেন আমার সঙ্গে চালাকি করলে? কেন তুমি আমার কন্যাদের যুদ্ধ বন্দীদের মত ধরে নিয়ে গেলে? ");
INSERT INTO ben2006_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","তুমি আমাকে না জানিয়ে কেন পালালে? যদি আমায় বলতে তবে আমি একটা ভোজের আয়োজন করতাম| বাজনার সাথে নাচ গানের ব্যবস্থাও করতাম| ");
INSERT INTO ben2006_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","তুমি আমার নাতি নাতনিদের চুমু খেতে ও কন্যাদের বিদায় জানাবারও সুযোগ দিলে না| এইভাবে তুমি খুব অজ্ঞের মত কাজ করেছ| ");
INSERT INTO ben2006_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","তোমাকে আঘাত করার ক্ষমতা আমার রয়েছে| কিন্তু গত রাতে তোমার পিতার ঈশ্বর আমার স্বপ্নে আমার কাছে এলেন| তিনি আমাকে সাবধান করে দিলেন যাতে তোমার কোন ক্ষতি না করি| ");
INSERT INTO ben2006_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","আমি জানি তুমি তোমার বাড়ী ফিরে যেতে চাও আর সেইজন্যই তুমি চলে এসেছ| কিন্তু কেন তুমি আমার ঘর থেকে ঠাকুরগুলোকে চুরি করলে?” ");
INSERT INTO ben2006_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","যাকোব উত্তরে বলল, “আমি ভয় পেয়েছিলাম তাই আপনাকে না বলে চলে এসেছি! আমি ভেবেছিলাম আপনি হয়তো আমার কাছ থেকে আপনার কন্যাদের ছিনিয়ে নেবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","কিন্তু আমি আপনার ঠাকুরগুলো চুরি করি নি| যদি এখানে আমার সঙ্গের কোন ব্যক্তি ঐ ঠাকুরগুলোকে নিয়ে থাকে তবে তাকে হত্যা করতে হবে| আপনার লোকরাই এই বিষয়ে আমার সাক্ষী হবে| আপনার যা কিছু তা আপনি খুঁজে দেখতে পারেন| যা আপনার তা নিয়ে নিন|” (যাকোব জানতেন না যে রাহেল লাবনের ঠাকুরগুলো চুরি করেছে|) ");
INSERT INTO ben2006_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","তাই লাবন গিয়ে যাকোবের তাঁবু এবং তারপর লেয়ার তাঁবু খুঁজে দেখলেন| তারপর সেই দুই দাসীর তাঁবুও খুঁজে দেখলেন| কিন্তু সেই ঠাকুরগুলোকে তাদের ঘরে খুঁজে পেলেন না| তারপর লাবন রাহেলের তাঁবুর দিকে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","রাহেল ঠাকুরগুলোকে উটের গদির তলায় লুকিয়ে তার ওপরে বসে ছিলেন| লাবন সমস্ত তাঁবু তন্ন তন্ন করে খুঁজেও ঠাকুরগুলোকে খুঁজে পেলেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","রাহেল তার পিতাকে বলল, “পিতা আমার উপর রাগ করবেন না| আমি আপনার সামনে উঠে দাঁড়াতে পারছি না কারণ আমার মাসিক চলছে|” তাই লাবন তাঁবুর ভিতরে দেখলেন কিন্তু তাঁর ঠাকুরগুলো খুঁজে পেলেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","তখন যাকোব খুব রেগে গিয়ে বলল, “আমি কি দোষ করেছি? কোন আইন ভেঙ্গেছি? কি অধিকারে আপনি আমাকে তাড়া করে থামাতে এসেছেন? ");
INSERT INTO ben2006_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","আমার যা কিছু রয়েছে তার সবকিছুই আপনি খুঁজে দেখেছেন| কিন্তু আপনার কিছুই খুঁজে পান নি আর যদি পেয়ে থাকেন তবে তা দেখান| সেটা এখানেই রাখুন যাতে আমাদের লোকরা তা দেখতে পায়| আমাদের লোকেরাই বিচার করুক আমাদের মধ্যে কারা ঠিক| ");
INSERT INTO ben2006_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","আমি 20 বছর আপনার জন্য কাজ করেছি| এই সময় আপনার কোন মেষশাবক বা ছাগশিশু জন্মাবার সময় মারা যায় নি| আর আমি আপনার পালের কোন মেষ মেরে খাই নি| ");
INSERT INTO ben2006_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","কোন সময় বন্য পশুর দ্বারা কোন মেষ মারা গেলে আমি সবসময় নিজে আপনার কাছে এসে বলি নি যে আমার দোষে এটা হয় নি| কিন্তু দিন রাত আমি ক্ষতি স্বীকার করেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","দিনের বেলা সূর্য্য যেন আমার শক্তি নিঙড়ে নিত এবং রাতে শীতে ঘুম আমার চোখ থেকে উধাও হয়ে যেত| ");
INSERT INTO ben2006_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","আমি 20 বছর ধরে আপনার কাছে দাসের মত কাজ করেছি| প্রথম 14 বছর আমি আপনার দুই কন্যা লাভ করার জন্য খেটেছি| শেষ 6 বছর আমি আপনার পশু লাভ করার জন্য খেটেছি| এবং এই সময় আপনি দশ বার আমার বেতন বদলেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","কিন্তু আমার পূর্বপুরুষের ঈশ্বর, অব্রাহামের ঈশ্বর এবং ইসহাকের ভয়। আমার সঙ্গে ছিলেন| ঈশ্বর আমার সঙ্গে না থাকলে আপনি আমাকে খালি হাতে বিদায় দিতেন| কিন্তু ঈশ্বর আমার কষ্ট সকল ও আমার পরিশ্রম দেখলেন| এই জন্যই গত রাতে ঈশ্বর প্রমাণ করেছেন যে আমি ঠিক|” ");
INSERT INTO ben2006_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","লাবন যাকোবকে বললেন, “এই মহিলারা আমারই কন্যা| এই সন্তানরা ও এই পশুরাও আমারই| যা কিছু দেখছ এ সবই তো আমারই, কিন্তু আমার কন্যাদের ও নাতি নাতনিদের আমার কাছে রাখার জন্য কিছুই করতে পারি না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","সেইজন্য এস তোমার সঙ্গে এক চুক্তি করি| আমাদের এই চুক্তির প্রমাণ স্বরূপ আমরা এক পাথরের থাম স্থাপন করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","চুক্তির প্রমাণ হিসাবে যাকোব একটা বড় পাথর খুঁজে এনে সেটা স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","সে তার নিজের লোকদেরও পাথর এনে রাশি করে রাখতে বলল| তারপর সেই পাথরের রাশির ধারে বসে খাওয়া দাওয়া করল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","লাবন সেই স্থানের নাম রাখলেন যিগর্ সাহদুথা| কিন্তু যাকোব সেই স্থানের নাম দিল গল্-এদ| ");
INSERT INTO ben2006_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","তখন লাবন বললেন, “পাথরের এই রাশি আমাদের চুক্তি স্মরণ করতে সাহায্য করবে|” এই কারণে যাকোব সেই স্থানের নাম গল্-এদ রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","তারপর লাবন বললেন, “আমরা পরস্পরের থেকে দূরে চলে গেলে প্রভু যেন আমাদের পাহারা দেন|” সেইজন্যে সেই স্থানের নাম মিস্পা রাখা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","তারপর লাবন বললেন, “মনে রেখো তুমি যদি আমার কন্যাদের আঘাত কর তবে ঈশ্বর তোমাকে শাস্তি দেবেন| তুমি যদি অন্য আর কোন স্ত্রী লোককে বিয়ে কর তবে মনে রেখো ঈশ্বর লক্ষ্য রাখছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","আমাদের মধ্যে স্থাপিত স্তম্ভ ও এই রাশি করা পাথরগুলো স্মরণ করিয়ে দেবে আমাদের চুক্তির কথা| ");
INSERT INTO ben2006_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","আমি কখনই এই পাথরগুলো পার হয়ে তোমার সাথে লড়াই করতে যাবো না এবং তুমিও অবশ্যই পার হয়ে আমার সঙ্গে লড়াই করতে আসবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","আমরা যদি এই চুক্তি লঙঘন করি তবে অব্রাহামের ঈশ্বর, নাহোরের ঈশ্বর এবং তাদের পূর্বপুরুষের ঈশ্বর আমাদের বিচারে দোষী করুন|” যাকোবের পিতা ইসহাক ঈশ্বরকে “ভয়” বলে ডাকতেন| তাই যাকোব সেই নাম ব্যবহার করে প্রতিজ্ঞা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","তারপর যাকোব সেই পর্বতে একটা পশু বলিদান রূপে উৎসর্গ করল| আর তার আপনজনদের ভোজে নিমন্ত্রণ করল| খাওয়া-দাওয়া শেষ হলে তারা সেই রাতটা পাহাড়েই কাটাল| ");
INSERT INTO ben2006_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","পরের দিন ভোরে লাবন তাঁর নাতি নাতনিদের ও কন্যাদের চুমু খেয়ে বিদায় জানালেন| তিনি তাদের আশীর্বাদ করে ঘরে ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","যাকোবও সেই স্থান হতে উঠে চলল| পথে সে ঈশ্বরের দূতগণের দেখা পেল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","তাদের দেখে যাকোব বলল, “এ ঈশ্বরের শিবির!” সেই জন্য সে সেই স্থানের নাম মহনয়িম রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","যাকোবের ভাই এষৌ থাকত সেয়ীরে| এই জায়গাটা ছিল পাহাড়ী দেশ ইদোমে| যাকোব এষৌর কাছে বার্তাবাহকদের এই বলে পাঠাল, ");
INSERT INTO ben2006_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“এই সব কথা আমার মনিব এষৌকে গিয়ে বলো| আপনার দাস যাকোব বলে: আমি এতগুলি বছর লাবনের কাছে কাটিয়েছি| ");
INSERT INTO ben2006_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","আমার অনেক গরু, গাধা, মেষপাল, লোকজন ও দাসী রয়েছে| মহাশয় আমি এই বার্তা পাঠিয়ে অনুরোধ করছি, আপনি আমাদের গ্রহণ করুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","বার্তাবাহকরা যাকোবের কাছে ফিরে এসে বলল, “আমরা আপনার ভাই এষৌয়ের কাছে গিয়েছিলাম| তিনি আপনার সাথে দেখা করতে আসছেন| তাঁর সাথে 400 জন লোক রয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","এই বার্তায় যাকোব ভীত হল| সে তার লোকজনদের দুই দলে ভাগ করল| সে তার মেষপাল, পশুপাল ও উটের পালকে দুই ভাগে ভাগ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","যাকোব বলল, “যদি এষৌ এসে এক দলকে ধ্বংস করে তবে অপর দল নিশ্চয় পালিয়ে রক্ষা পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","যাকোব বলল, “হে আমার পিতা অব্রাহামের ঈশ্বর, আমার পিতা ইসহাকের ঈশ্বর! প্রভু তুমিই আমাকে আমার দেশে আমার পরিবারের কাছে ফিরে যেতে বলেছিলে| তুমি বলেছিলে আমার মঙ্গল করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","তুমি আমার প্রতি কত করুণা করেছ| আমার কত মঙ্গল করেছ| প্রথমবার যখন আমি যর্দ্দন পার হচ্ছিলাম তখন কেবল পথ চলার লাঠি ছাড়া আমার কাছে কিছুই ছিল না| কিন্তু এখন আমার সব কিছু প্রচুর বলে দুটো দল হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","দয়া করে আমায় আমার ভাইয়ের হাত থেকে, এষৌর হাত থেকে রক্ষা কর| আমার ভয় হয় যে সে আমাদের, এমনকি সন্তানদের সঙ্গে মায়েদেরও হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","প্রভু তুমি আমায় বলেছিলে, ‘আমি তোমার মঙ্গল করব| আমি তোমার বংশধরদের সংখ্যায় সমুদ্রের বালির মত করব যা গুনে শেষ করা যায় না|’” ");
INSERT INTO ben2006_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","সেই স্থানে যাকোব রাত কাটাল| এষৌকে উপহার হিসাবে দেবার জন্য জিনিস গোছাল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","যাকোব 200টি ছাগী, 20টি ছাগ, 200টি মেষী ও 20টি মেষ নিল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","আরও নিল 30টি উট এবং তাদের বাচ্চা, 40টি গরু, 10টি ষাঁড়, 20টি গর্দ্দভী ও 10টি গর্দ্দভ| ");
INSERT INTO ben2006_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","যাকোব প্রতিটি পশুপাল তার দাসদের হাতে দিল| তারপর যাকোব তার দাসদের বলল, “প্রতিটি পশুর পাল পৃথক কর| আমার আগে আগে যাও আর প্রতিটি পালের মধ্যে কিছুটা দূরত্ব রেখো|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","যাকোব তার দাসদের আজ্ঞা দিল| প্রথম দলের পশু যে দাসের হাতে তাকে সে বলল, “যখন আমার ভাই এষৌ এসে তোমাকে জিজ্ঞেস করবে, ‘এ সব পশু কার? তুমি কোথায় যাচ্ছ? তুমি কার দাস?’ ");
INSERT INTO ben2006_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","তখন তুমি বলবে, ‘এইসব পশু আপনার দাস যাকোবের| যাকোবই এইসব উপহার হিসাবে আপনার কাছে পাঠিয়েছেন. আর যাকোব নিজেও পেছন পেছন আসছেন|’” ");
INSERT INTO ben2006_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","যাকোব দ্বিতীয়, তৃতীয় এবং অন্য সব দাসদের ঐ একই কাজ করতে বলল| সে বলল, “এষৌর সঙ্গে দেখা হলে তোমরাও সবাই ঐ একই কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","তোমরা বলবে, ‘এই উপহার আপনার জন্যে আর আপনার দাস যাকোব আমাদের পেছনেই আসছেন|’” যাকোব বলল, “যদি আমি এই লোকদের উপহার সমেত আমার আগে পাঠাই তবে হয়তো এষৌ আমায় ক্ষমা করে গ্রহণ করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","তাই যাকোব এষৌকে উপহারগুলি পাঠাল| কিন্তু সেই রাতে যাকোব তাঁবুতে রইল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","পরে সেই রাতে উঠে যাকোব সেখান থেকে চলে গেল| সে তার সাথে তার দুই স্ত্রী, দুই দাসী ও তার এগারোটি সন্তানকে নিয়ে যব্বোক নদী পার হল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","যাকোবের পরিবার নদী পার হয়ে গেলে সে তার সমস্ত জিনিসপত্রও পার হবার জন্য পাঠাল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","অবশেষে যাকোব নদী পার হবার জন্য রইল| কিন্তু সে একা পার হবার আগে একজন পুরুষ এসে তার সঙ্গে মল্লযুদ্ধ করলেন| সূর্য্য ওঠার আগে পর্যন্ত সেই পুরুষটি তার সঙ্গে যুদ্ধ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","পুরুষটি যখন দেখলেন তিনি যাকোবকে পরাজিত করতে পারছেন না তখন যাকোবের পায়ে আঘাত করলেন; তাতে যাকোবের পায়ের হাড় সরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","তারপর সেই পুরুষটি যাকোবকে বললেন, “আমায় যেতে দাও, সূর্য্য উঠছে|” কিন্তু যাকোব বলল, “আপনি আমাকে আশীর্বাদ না করলে আমি আপনাকে যেতে দেব না|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","সেই পুরুষটি তাকে জিজ্ঞাসা করলেন, “তোমার নাম কি?” যাকোব উত্তর দিল, “আমার নাম যাকোব|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","তখন সেই পুরুষটি বললেন, “তোমার নাম যাকোবের পরিবর্তে ইস্রায়েল হবে| আমি তোমার এই নাম রাখলাম কারণ তুমি ঈশ্বরের সঙ্গে ও মানুষের সঙ্গে যুদ্ধ করেছ কিন্তু পরাজিত হও নি|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","তখন যাকোব তাকে জিজ্ঞেস করল, “দয়া করে বলুন আপনার নাম কি?” কিন্তু সেই পুরুষটি বললেন, “কি জন্য আমার নাম জিজ্ঞেস করছ?” সেই সময়ই পুরুষটি যাকোবকে আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","তাই যাকোব সেই জায়গার নাম পনূয়েল রাখল| যাকোব বলল, “এই স্থানেই আমি ঈশ্বরকে মুখোমুখি দেখলাম কিন্তু তাও প্রাণে বাঁচলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","সে পনূয়েল পার হলে সূর্য্য উঠল| যাকোব পায়ের জন্য খোঁড়াতে খোঁড়াতে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","সেইজন্য আজও ইস্রায়েলীয়রা উরুসন্ধির পেশী ভোজন করে না, কারণ যাকোবের সেই পেশীই আহত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","যাকোব তাকিয়ে দেখলেন এষৌ আসছেন| এষৌ তার সঙ্গে 400 জন লোক নিয়ে আসছিলেন| যাকোব তার পরিবারকে চারটি দলে ভাগ করল| লেয়া এবং তার সন্তানরা একটি দলে, রাহেল ও যোষেফ আর একটি দলে এবং দুই দাসী ও তাদের সন্তানরা আরও দুটি দলে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","যাকোব তার দাসীদের সন্তানদের সামনে রাখল| লেয়া এবং তার সন্তানদের সে তাদের পেছনে রাখল| যাকোব রাহেল ও যোষেফকে সবশেষে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","যাকোব নিজে এষৌর দিকে এগিয়ে গেল| এর ফলে এষৌর সাথেই প্রথমে তার সাক্ষাৎ হল| যাকোব তার ভাইয়ের দিকে হেঁটে যাবার সময় সাতবার আভূমি প্রণত হল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","এষৌ যাকোবকে দেখতে পেয়ে তার সাথে দেখা করার জন্য দৌড়ে গেলেন| এষৌ যাকোবের গলা জড়িয়ে ধরে চুমু খেলেন| তারপর তাঁরা দুজনেই কাঁদলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","এষৌ তাকিয়ে সেই স্ত্রীলোক ও শিশুদের দেখতে পেয়ে বললেন, “তোমার সাথে ঐ লোকজনরা কারা?” যাকোব উত্তরে বললেন, “ঈশ্বর অনুগ্রহ করে আমাকে এইসব সন্তানসন্ততিদের দিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","তারপর সন্তানদের নিয়ে দুই দাসী এষৌর সঙ্গে দেখা করতে গেল| তারা তাঁর সামনে সশ্রদ্ধ প্রণিপাত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","এরপর লেয়া ও তার সন্তানরা এষৌর সঙ্গে দেখা করে তাঁর সামনে সশ্রদ্ধভাবে উপুড় হয়ে তাঁকে প্রণাম করল| শেষে রাহেল ও যোষেফ এষৌর সঙ্গে দেখা করে উপুড় হয়ে প্রণাম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","এষৌ বললেন, “আমি এখানে আসার সময় যে জনসমারোহ দেখতে পেলাম তা এবং এইসব পশুই বা কিসের জন্য?” যাকোব বলল, “ঐ সব আপনার জন্য আমার উপহার| যেন আপনি আমাকে গ্রহণ করেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","কিন্তু এষৌ বললেন, “তোমাকে উপহার দিতে হবে না ভাই আমার যথেষ্ট রয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","যাকোব বলল, “তা না, আমার মিনতি এই যদি সত্যিসত্যি আপনি আমাকে গ্রহণ করে থাকেন তবে আমি যে উপহার আপনাকে দিই তা গ্রহণ করুন| আমি আবার আপনার মুখ দেখতে পেয়ে আনন্দিত| যেন ঈশ্বরেরই মুখ দর্শন করলাম| আপনি যে আমাকে গ্রহণ করলেন এতেই আমি খুব খুশী| ");
INSERT INTO ben2006_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","সেইজন্য বিনয় করি আমি যে যে উপহার আপনার জন্য এনেছি তা গ্রহণ করুন| ঈশ্বর আমার প্রতি অনুগ্রহ করেছেন তাই আমার প্রয়োজনের অতিরিক্তই রয়েছে|” এইভাবে যাকোব তার উপহারগুলি স্বীকার করার জন্য এষৌর কাছে বিনতি করল| সেইজন্য এষৌ উপহারগুলি স্বীকার করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","তারপর এষৌ বললেন, “এবার তুমি তোমার যাত্রা পথে চলতে পার| আমি তোমার সঙ্গে যাব|” ");
INSERT INTO ben2006_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","কিন্তু যাকোব তাকে বলল, “আপনি জানেন যে আমার শিশুরা দুর্বল এবং আমাকে আমার পশুপাল সম্পর্কে সাবধান হতে হবে| যদি আমি তাদের একদিনে এতদূর যেতে বাধ্য করি, তবে সব পশুই মারা পড়বে| ");
INSERT INTO ben2006_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","সেইজন্য আপনি আগে আগে যান| গবাদিপশু এবং অন্যান্য পশুদের নিরাপত্তা নিশ্চিত করতে এবং সন্তানরা যাতে খুব ক্লান্ত না হয়ে পড়ে সেই দিক দেখে আমি খুব ধীর গতিতে যাব| আমি সেয়ীরে আপনার সঙ্গে দেখা করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","তাই এষৌ বললেন, “তবে তোমাকে সাহায্য করার জন্য আমার কিছু লোক তোমার কাছে রেখে যাই|” কিন্তু যাকোব বলল, “আপনি বড়ই দয়ালু কিন্তু সেটারই বা প্রয়োজন কি?” ");
INSERT INTO ben2006_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","সেদিন এষৌ সেয়ীরের পথে যাত্রা শুরু করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","কিন্তু যাকোব সুক্কোতে গেল| সেই জায়গায় সে নিজের জন্য একটা গৃহ তৈরী করল আর তার পশুপালের জন্য ছাউনি তৈরী করল| এইজন্য সেই জায়গার নাম রাখা হল সুক্কোৎ| ");
INSERT INTO ben2006_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","যাকোব নিরাপদে পদ্দম্-অরাম হতে যাত্রা করে কনান দেশের শিখিম নগরে এসে উপস্থিত হল| সেই শহরের কাছে এক মাঠের মধ্যে সে শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","শিখিমের পিতা হামোরের কাছ থেকে যাকোব ঐ মাঠটি 100 রৌপ্য খণ্ড দিয়ে কিনেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","যাকোব সেই জায়গায় ঈশ্বরের উপাসনা করার জন্য এক বেদী তৈরী করে তার নাম রাখল, “এল্ ইলোহে, ইস্রায়েলের ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","দীণা ছিল যাকোব এবং লেয়ার কন্যা| একদিন দীণা সেই জায়গার মেয়েদের সঙ্গে দেখা করতে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","হমোর ছিলেন সেই দেশের রাজা, তাঁর পুত্র শিখিম দীণাকে দেখতে পেলেন| শিখিম দীণাকে ধরে নিয়ে গিয়ে বলাৎ‌‌কার করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","শিখিম দীণার প্রেমে পড়ে তাকে বিয়ে করার জন্য অনুণয করতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","শিখিম তাঁর পিতাকে বললেন, “দয়া করে ওকে আমার জন্য এনে দাও যেন আমি বিয়ে করতে পারি|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","যাকোব জানতে পারল যে ছেলেটি তার কন্যার সাথে ঐ মারাত্মক খারাপ কাজটি করেছে| কিন্তু যেহেতু তার সব কটি পুত্রই মাঠে পশু চরাতে গিয়েছিল, সেই জন্য তারা ঘরে ফিরে না আসা পর্যন্ত তিনি কিছুই করলেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","সেই সময় শিখিমের পিতা হমোর যাকোবের সঙ্গে কথা বলতে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","যাকোবের পুত্ররা মাঠেই জানতে পারল কি ঘটেছে| ঘটনা শুনে তারা খুবই রেগে গেল কারণ শিখিম যাকোবের কন্যাকে বলাৎ‌‌কার করে ইস্রায়েলকে লজ্জায় ফেলেছিলেন| শিখিমের করা এই ভয়ঙ্কর ঘটনা শুনতে পেয়েই ভাইরা ক্ষেত থেকে ফিরে এল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","কিন্তু হমোর ভাইদের বললেন, “আমার পুত্র শিখিম দীণাকে খুবই চায়| অনুগ্রহ করে ওকে বিয়ে করতে দাও| ");
INSERT INTO ben2006_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","এই বিবাহ বোঝাবে যে তোমাদের সঙ্গে আমাদের এক বিশেষ চুক্তি হয়েছে| তখন আমাদের পুত্ররা তোমাদের কন্যাদের এবং তোমাদের পুত্ররা আমাদের কন্যাদের বিয়ে করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","তোমরা আমাদের সঙ্গে এই একই দেশে থাকতে পারবে| তোমরা এখানকার জমির মালিক হবে ও ব্যবসা করতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","শিখিম নিজেও যাকোব ও ভাইদের সঙ্গে কথা বললেন| শিখিম বললেন, “দয়া করে আমায় গ্রহণ কর| তোমরা আমাকে যা করতে বলবে তাই-ই করব| ");
INSERT INTO ben2006_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","যদি তোমরা আমায় কেবল দীণাকে বিয়ে করতে দাও, তবে তোমাদের চাওয়া যে কোন উপহার আমি তোমাদের দেব| তোমরা যা চাইবে তাই-ই দেব, কেবল দীণাকে বিয়ে করতে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","যাকোবের পুত্ররা শিখিম ও তার পিতাকে মিথ্যা বলব বলে ঠিক করল| ভাইরা তাদের রাগ সামলাতে পারছিল না কারণ শিখিম তাদের বোন দীণার প্রতি এই জঘন্য কাজ করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","তাই ভাইরা তাঁকে বলল, “আপনি সুন্নত নন বলে আপনার সঙ্গে আমাদের বোনের বিয়ে দিতে পারি না| যদি আমরা আমাদের বোনকে আপনাকে বিয়ে করতে দিই তা হবে আমাদের পক্ষে এক অপমান| ");
INSERT INTO ben2006_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","কিন্তু আপনি এই একটি কাজ করলে আমরা তার সঙ্গে আপনার বিয়ে দিতে পারি| আপনার শহরের প্রত্যেকটি পুরুষকে আমাদের মত সুন্নত হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","তাহলে আপনাদের পুত্ররা আমাদের কন্যাদের এবং আমাদের কন্যারা আপনাদের পুত্রদের বিয়ে করতে পারবে| তাহলে আমরা এক জাতি হব| ");
INSERT INTO ben2006_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","যদি আপনি সুন্নত হতে অস্বীকার করেন তবে আমরা দীণাকে নিয়ে যাব।” ");
INSERT INTO ben2006_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","এই চুক্তি হমোর এবং শিখিমকে খুব আনন্দিত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","দীণার ভাইরা যা করতে বলল তাতে শিখিম খুশী হয়ে রাজী হলেন| শিখিম ছিলেন তাঁর পরিবারে সবচেয়ে সম্মানীয় ব্যক্তি| ");
INSERT INTO ben2006_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","হমোর ও শিখিম তাঁদের শহরের সমাগম স্থানে গেলেন| তাঁরা শহরের পুরুষদের সঙ্গে কথা বললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","তাঁরা বললেন, “ইস্রায়েলের এই লোকরা আমাদের বন্ধু হতে চায়| তারা আমাদের দেশে বাস করুক ও আমাদের সঙ্গে ব্যবসা করুক| আমাদের সকলের জন্য যথেষ্ট জায়গা আমাদের রয়েছে| তাদের সঙ্গে আমাদের পারস্পরিক বিবাহও হতে পারে| আমাদের ছেলেরা তাদের মেয়েদের বিয়ে করতে পারে এবং তাদের মেয়েরা আমাদের ছেলেদের বিয়ে করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","কিন্তু একটি বিষয় আমাদের সবাইকে মেনে নিতে হবে| আমাদের সব পুরুষকে সুন্নত হতে হবে, যেমনটি ইস্রায়েলের লোকরা হয়ে রয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","একাজ করলে আমরা তাদের গো-মেষাদির পাল ও পশুর দ্বারা এবং সম্পত্তির দ্বারা ধনী হব| সুতরাং তাদের সঙ্গে আমাদের এই চুক্তি করা উচিৎ‌, তাহলে তারা এখানে আমাদের সঙ্গে থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","সমবেত সমস্ত লোক হমোর ও শিখিমের কথা শুনে সম্মতি জানাল| আর সব পুরুষরা সেই সময় সুন্নত হল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","তিন দিন পরেও সুন্নত হওয়া লোকরা তখনও পীড়িত ছিল| যাকোবের দুই পুত্র শিমিয়োন ও লেবি জানত যে ঐ লোকরা এই সময়ে দুর্বল থাকবে| তাই তারা শহরে ঢুকে সেখানকার সমস্ত লোককে হত্যা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","দীণার ভাই শিমিয়োন ও লেবি এই দুজনে মিলে হমোর ও তার পুত্র শিখিমকে হত্যা করল| তারা শিখিমের বাড়ী থেকে দীণাকে বার করে নিয়ে এল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","যাকোবের পুত্ররা শহরের সব কিছু লুঠ করল| শিখিম তাদের বোনের সঙ্গে ভ্রষ্টাচার করার জন্য তারা তখনও রেগে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","তাই ভাইরা সমস্ত পশু, গাধা এবং শহরে ও ক্ষেতে যা কিছু ছিল তার সবই নিয়ে নিল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","সেই লোকেদের সর্বস্ব এমনকি তাদের স্ত্রী ও শিশুদের অধিকার করল| ");
INSERT INTO ben2006_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","কিন্তু যাকোব শিমিয়োন ও লেবিকে বলল, “তোমরা আমায় অনেক বিপদে ফেলেছ| এই অঞ্চলের সমস্ত লোক এখন আমায় ঘৃণা করবে| কনানীয় ও পরিষীয় সমস্ত লোকরা আমার বিরুদ্ধে উঠে দাঁড়াবে| আমরা এখানে অল্প কয়েকজন রয়েছি| যদি এই জায়গার লোকরা একত্রে আমাদের সঙ্গে যুদ্ধ করতে আসে, তবে আমি তো ধ্বংস হবোই, এমনকি আমার সমস্ত লোকও আমার সঙ্গে ধ্বংস হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","কিন্তু ভাইরা বলল, “ঐ লোকরা আমাদের বোনের সঙ্গে বেশ্যার মত যে ব্যবহার করেছে সেটাও কি উচিৎ‌ ছিল? না, ঐ লোকেরা আমাদের বোনের প্রতি অন্যায় করেছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ঈশ্বর যাকোবকে বললেন, “বৈথেল শহরে যাও| সেখানে বাস কর আর উপাসনার জন্য একটা বেদী তৈরী কর| স্মরণ কর এলকে| তুমি যখন তোমার ভাই এষৌর কাছ থেকে পালিয়ে যাচ্ছিলে তখন সেখানে এই ঈশ্বরই তোমায় দর্শন দিয়েছিলেন|” সেখানে তোমার ঈশ্বরের উপাসনার জন্য বেদী তৈরী কর। ");
INSERT INTO ben2006_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","তাই যাকোব তার পরিবার ও তার সমস্ত দাসকে বলল, “তোমাদের কাছে কাঠ ও ধাতুর যে সমস্ত পুতুল ঠাকুর রয়েছে তার সমস্তই ধ্বংস কর| নিজেদের পবিত্র কর এবং পরিষ্কার কাপড় পর| ");
INSERT INTO ben2006_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","আমরা এই জায়গা ছেড়ে বৈথেলে যাব| সেখানেই আমি আমার ঈশ্বরের উদ্দেশ্যে একটি বেদী তৈরী করব, এই ঈশ্বরই সঙ্কটের সময় আমায় সাহায্য করেছিলেন| আমি যেখানেই গিয়েছি সেখানেই এই ঈশ্বর আমার সঙ্গে গিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","সেইজন্য লোকরা বিদেশের সমস্ত ঠাকুরগুলোকে যাকোবের কাছে এনে দিল| তারা যাকোবকে তাদের কানের দুলগুলি এনে দিল| যাকোব এসব কিছু শিখিম শহরের কাছে একটা এলা গাছের তলায় পুঁতে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","যাকোব আর তার পুত্ররা সেই জায়গা পরিত্যাগ করল| সেই স্থানের লোকরা তাদের তাড়া করে হত্যা করতে চেয়েছিল| কিন্তু তারা ভীষণ ভয় পেয়ে যাকোবকে আর অনুসরণ করল না| ");
INSERT INTO ben2006_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","এরপর যাকোব আর তার লোকরা লুসে গেল| লুসের বর্তমান নাম বৈথেল| এটি কনান দেশে অবস্থিত| ");
INSERT INTO ben2006_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","যাকোব সেই জায়গায় একটি বেদী তৈরী করে তার নাম রাখল “এল্ বৈথেল|” যাকোব এই নাম বেছে নিল কারণ ভাইয়ের কাছ থেকে পালিয়ে যাবার সময় এইখানে ঈশ্বর তাঁর সামনে আবির্ভূত হয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","রিবিকার দাই দবোরার সেখানেই মৃত্যু হল| তারা তাকে বৈথেলে একটা অলোন গাছের নীচে কবর দিল এবং সেই জায়গার নাম রাখল অলোন্ বাখুৎ‌‌| ");
INSERT INTO ben2006_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","পদ্দন্-অরাম থেকে যাকোব যখন ফিরে এল ঈশ্বর তাঁকে আবার দর্শন দিলেন এবং তাকে আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ঈশ্বর যাকোবকে বললেন, “তোমার নাম যাকোব কিন্তু আমি তোমার অন্য নাম রাখব| এখন থেকে তোমাকে যাকোব বলে ডাকা হবে না, তোমার নাম হবে ইস্রায়েল|” তাই ঈশ্বর তার নাম রাখলেন ইস্রায়েল| ");
INSERT INTO ben2006_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ঈশ্বর তাকে বললেন, “আমিই সর্বশক্তিমান ঈশ্বর এবং আমি তোমায় এই আশীর্বাদ করছি| তোমার অনেক সন্তান-সন্ততি হোক্, এক মহাজাতি হয়ে বেড়ে ওঠো| তোমার থেকেই অন্য অনেক জাতি এবং রাজারা উৎপন্ন হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","আমি অব্রাহাম ও ইসহাককে যে দেশ দিয়েছিলাম সেই দেশই এখন তোমায় দিচ্ছি| তোমার পরে তোমার বংশধরদের আমি সেই দেশ দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","এরপর ঈশ্বর সেই জায়গা থেকে চলে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","এই স্থানে যাকোব একটি স্মরণস্তম্ভ স্থাপন করল| সেই পাথরের উপরে দ্রাক্ষারস ও তেল ঢেলে যাকোব সেটা পবিত্র করল| এটা ছিল এক বিশেষ জায়গা কারণ এখানেই ঈশ্বর যাকোবের সঙ্গে কথা বলেছিলেন| এবং যাকোব এই জায়গার নাম রাখল বৈথেল| ");
INSERT INTO ben2006_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","যাকোব এবং তার দল বৈথেল ত্যাগ করল| তারা ইফ্রাতে পৌঁছাবার আগেই রাহেলের প্রসবের সময় এল| ");
INSERT INTO ben2006_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","কিন্তু এইবার প্রসবকালে রাহেলের ভীষণ কষ্ট হল, প্রসব বেদনা তীব্র হয়ে উঠল| রাহেলের ধাত্রী এই দেখে বললেন, “ভয় পেও না রাহেল! তুমি আরেকটি পুত্রের জন্ম দিতে চলেছ|” ");
INSERT INTO ben2006_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","রাহেল পুত্রটি প্রসব করার সময়ই মারা গেল| মারা যাবার আগে রাহেল পুত্রটির নাম রাখল বিনোনী| কিন্তু যাকোব তার নাম রাখল বিন্যামীন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","রাহেলকে ইফ্রাথ যাবার পথেই কবর দেওয়া হল| (ইফ্রাথই বৈৎ‌লেহম|) ");
INSERT INTO ben2006_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","রাহেলকে সম্মান জানাতে যাকোব তার কবরে একটি স্তম্ভ স্থাপন করল| সেই বিশেষ স্তম্ভটি আজও সেখানে রয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","এরপর ইস্রায়েল আবার তার যাত্রা পথে চললেন| তিনি মিগ্দল এদর দক্ষিণে তাঁর তাঁবু খাটালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ইস্রায়েল এই স্থানে অল্পকাল রইলেন| এই স্থানেই রূবেণ তার পিতার দাসী বিল্হার কাছে গেল এবং তার সাথে শয়ন করল| ইস্রায়েল এই খবর জানতে পেরে অত্যন্ত ক্রুদ্ধ হলেন| যাকোবের 12টি পুত্র ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","যাকোব এবং লেয়ার পুত্ররা হল: যাকোবের প্রথম জাত পুত্র রূবেণ, শিমিয়োন, লেবি, যিহূদা, ইষাখর ও সবূলূন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","যাকোব এবং রাহেলের পুত্ররা হল যোষেফ ও বিন্যামীন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","বিল্হা ছিলেন রাহেলের দাসী| যাকোব ও বিল্হার পুত্ররা হল দান এবং নপ্তালি| ");
INSERT INTO ben2006_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","সিল্পা ছিলেন লেয়ার দাসী| যাকোব এবং সিল্পার পুত্ররা হল গাদ ও আশের| পদ্দন্-অরামে যাকোবের এই কটি পুত্রের জন্ম হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","যাকোব কিরিযথ অর্ব্বয স্থিত মম্রি নামক স্থানে তার পিতা ইসহাকের কাছে গেলেন| এই জায়গাতেই অব্রাহাম ও ইসহাক বাস করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ইসহাক 180 বৎস‌র বেঁচে ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","এরপর ইসহাক বৃদ্ধ ও পূর্ণায়ু হয়ে মারা গেলেন| তাঁর দুই পুত্র এষৌ ও যাকোব তার পিতাকে যে স্থানে কবর দেওয়া হয়েছিল সেইখানেই তাকে কবর দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","এষৌর (ইদোম) বংশ বৃত্তান্ত এই| ");
INSERT INTO ben2006_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","এষৌ কনান দেশের এক স্ত্রীলোককে বিয়ে করেন| এষৌর স্ত্রীরা ছিলেন: হিত্তীয়, এলোনের কন্যা আদা, অনার কন্যা অহলীবামা, অনা ছিলেন হিব্বীয় সিবিয়়োনের পৌত্রী| ");
INSERT INTO ben2006_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","এবং ইশ্মায়েলের কন্যা বাসমৎ‌, বাসমতের বোনের নাম নবায়োত| ");
INSERT INTO ben2006_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","এষৌ এবং আদার পুত্রের নাম ইলীফস| বাসমতের পুত্রের নাম ছিল রূয়েল| ");
INSERT INTO ben2006_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","অহলীবামার তিনটি পুত্রের নাম যিয়ূশ, যালম ও কোরহ| এষৌর এই পুত্ররা কনান দেশে জন্মেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","এষৌ এবং যাকোবের প্রচুর সম্পত্তি এবং বহু লোকজন হয়ে যাবার জন্য তাদের পক্ষে একসঙ্গে থাকা অসম্ভব হয়ে উঠল| তাদের প্রচুর পশুপাল ছিল বলে সেই জমিটি, যেখানে তারা থাকত, তাদের প্রয়োজন মেটাতে পারত না| তাই এষৌ তার ভাই যাকোবের কাছ থেকে চলে গেলেন| এষৌ তার স্ত্রী, পুত্র, কন্যা, সমস্ত দাস-দাসী, গরু এবং অন্যান্য পশু এবং কনান দেশে তার আর যা কিছু ছিল সব নিয়ে পর্বতময প্রদেশ সেয়ীরে চলে গেলেন| (এষৌ ইদোম নামেও পরিচিত এবং ইদোম সেয়ীর দেশের অপর নাম|) ");
INSERT INTO ben2006_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","এষৌ হলেন ইদোমীয়দের পূর্বপুরুষ| পার্বত্য সেয়ীর (ইদোম) প্রদেশে বসবাসকারী এষৌর পরিবারগোষ্ঠীর নামগুলি: ");
INSERT INTO ben2006_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","এষৌ এবং আদার পুত্র ইলীফস| এষৌ এবং বাসমতের পুত্র রূয়েল| ");
INSERT INTO ben2006_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ইলীফসের পাঁচটি পুত্র ছিল: তৈমন, ওমার, সফো, গযিতম ও কনস| ");
INSERT INTO ben2006_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","তিম্না নামে এষৌর একজন দাসীও ছিল| তিম্না ও ইলীফসের পুত্রের নাম অমালেক| ");
INSERT INTO ben2006_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","রূয়েলের চার পুত্রের নাম নহৎ, সেরহ, শল্ম ও মিসা| এরা ছিল এষৌর স্ত্রী বাসমতের নাতি| ");
INSERT INTO ben2006_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","এষৌর তৃতীয় স্ত্রীর নাম ছিল অহলীবামা, ইনি ছিলেন অনার কন্যা| (অনা ছিলেন সিবিয়়োনের পুত্র|) এষৌ এবং অহলীবামার সন্তানরা হল: যিয়ূশ, বালম ও কোরহ| ");
INSERT INTO ben2006_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","এষৌ হতে উৎপন্ন পরিবারগোষ্ঠীগুলি হল নিম্নরূপ: এষৌর প্রথম পুত্র ইলীফস থেকে উৎপন্ন তৈমন, ওমার, সফো, কনস, ");
INSERT INTO ben2006_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","কোরহ, গয়িতম ও অমালেক| এই সমস্ত পরিবারগোষ্ঠী এষৌর স্ত্রী আদা থেকে উৎপন্ন| ");
INSERT INTO ben2006_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","এষৌর পুত্র রূয়েল ছিলেন নহৎ, সেরহ শল্ম ও মিসার পিতা| এই সমস্ত পরিবারের মা ছিলেন এষৌর স্ত্রী বাসমৎ‌| ");
INSERT INTO ben2006_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","এষৌর স্ত্রী অহলীবামা, অনার কন্যা, যিয়ূশ, যলম ও কোরহের জন্ম দিলেন| ঐ তিনজন ছিলেন তাদের পরিবারের পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","এষৌ হতে উৎপন্ন ঐ পুরুষরা প্রত্যেকে ছিলেন তাঁদের নিজ পরিবারগোষ্ঠীর নেতা| ");
INSERT INTO ben2006_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","হোরীয়় সেয়ীরের এই পুত্ররা সেই দেশে বাস করত| এরা হল লোটন, শোবল, শিবিয়োন, অনা, ");
INSERT INTO ben2006_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দিশোন, এৎ‌সর, ও দীশন| এই পুত্ররা ছিল ইদোম দেশে সেয়ীর হতে আসা হোরীয়় পরিবারের গোষ্ঠীর নেতাসকল| ");
INSERT INTO ben2006_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোটন ছিলেন হোরি এবং হেমনের পিতা| (তিম্না ছিলেন লোটনের বোন|) ");
INSERT INTO ben2006_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","শোবল ছিলেন অল্বন, মানহৎ, এবল, শফো ও ওনমের পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","সিবিয়়োনের দুই পুত্র ছিল অয়া ও অনা| (অনাই সেই জন যিনি তাঁর পিতার গাধাদের চরাবার সময় মরুভূমিতে উষ্ণ প্রস্রবণ খুঁজে পেয়েছিলেন|) ");
INSERT INTO ben2006_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","অনা ছিলেন দিশোন ও অহলীবামার পিতা| ");
INSERT INTO ben2006_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","দিশোনের চার পুত্র ছিল| তাদের নাম: হিম্দন, ইশ্বন, যিত্রণ ও করাণ| ");
INSERT INTO ben2006_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","এৎসরের তিন পুত্র ছিল| তাদের নাম বিল্হন, সাবন ও আকন| ");
INSERT INTO ben2006_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","দীশনের দুই পুত্র ছিল| তাদের নাম উষ ও অরাণ| ");
INSERT INTO ben2006_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","হোরীয় পরিবারগুলির দলপতিদের নামগুলি এইরকম: লোটন, শোবল, সিবিয়োন, ");
INSERT INTO ben2006_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","অনা, দিশোন, এৎসর ও দীশোন| সেয়ীর দেশে যে পরিবারগুলি বাস করত, এই লোকরা ছিল তাদের দলপতিগণ| ");
INSERT INTO ben2006_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","সেই সময় ইদোমে রাজারা রাজত্ব করতেন| ইস্রায়েলে রাজ শাসন চালু হবার বহু পূর্বেই ইদোমে রাজারা রাজত্ব করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","যিয়োরের পুত্র বেলা ইদোম দেশে রাজত্ব করেন, তার রাজধানীর নাম দিন্হাবা| ");
INSERT INTO ben2006_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","বেলার মৃত্যুর পর যোবব রাজা হলেন| যোবব ছিলেন বস্রা নিবাসী সেরহের পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","যোববের মৃত্যুর পর হূশম রাজত্ব করলেন| হূশম ছিলেন তৈমন দেশীয়| ");
INSERT INTO ben2006_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","হূশমের মৃত্যুর পর বেদদের পুত্র হদদ সেই নগর শাসন করলেন| (হদদই মোয়াব দেশে মিদিয়নদের পরাজিত করেছিলেন|) হদদ এসেছিলেন অবীত্‌ শহর থেকে| ");
INSERT INTO ben2006_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","হদদের মৃত্যুর পর সম্ল সেই দেশ শাসন করতে থাকেন| সম্ল এসেছিলেন মস্রেকা থেকে| ");
INSERT INTO ben2006_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","সম্লের মৃত্যুর পর শৌল সেই দেশ শাসন করতে থাকেন| শৌল এসেছিলেন ফরাৎ নদীর ধারে স্থির রহোবোত্‌ থেকে| ");
INSERT INTO ben2006_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","শৌলের মৃত্যুর পর বাল্হানন সেই দেশে রাজত্ব করেন| বাল্হানন ছিলেন অক্বোরের পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","বাল্হাননের মৃত্যুর পর হদর সেই দেশে রাজত্ব করেন| হদর ছিলেন পায়ু শহরের লোক| হদরের স্ত্রীর নাম মহেটবেল; ইনি ছিলেন মট্টেদের কন্যা| (মট্টেদের পিতার নাম মেষাহবের|) ");
INSERT INTO ben2006_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","এষৌ ছিলেন ইদোম পরিবারগুলির পিতা| ইদোম পরিবারগুলি হল তিম্ন, অল্বা, যিথেত্‌, অহলীবামা, এলা, পীনোন, কনস, তৈমন, মিব্মস, মগদীয়েল ও ঈরম| এই পরিবারগুলির নাম অনুসারেই তাদের বসতি স্থানের নাম হল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","যাকোব কনান দেশেই বাস করতে লাগল| এই সেই দেশ যেখানে পূর্বে তার পিতা বাস করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","যাকোবের পরিবারের বৃত্তান্ত এইরকম| যোষেফ তখন 17 বছর বয়স্ক যুবক| তার কাজ ছিল মেষ, ছাগলের তত্ত্বাবধান করা| যোষেফ এই কাজ করতেন তার ভাইদের সঙ্গে অর্থাৎ‌ বিল্হা ও সিল্পার সন্তানদের সঙ্গে| (বিল্হা ও সিল্পা তাঁর সৎ‌ মা ছিলেন|) ভাইরা মন্দ কাজ করলে যোষেফ তা তাঁর পিতাকে এসে জানাতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","যোষেফ ছিলেন ইস্রায়েলের বৃদ্ধাবস্থার সন্তান| এই জন্য ইস্রায়েল তার অন্যান্য পুত্রদের চেয়ে যোষেফকেই বেশী ভালবাসতেন| যাকোব তাকে একটা বিশেষ জামা উপহার দিয়েছিল| জামাটি ছিল লম্বা এবং বেশ সুন্দর| ");
INSERT INTO ben2006_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","যোষেফের ভাইরা দেখল যে তাদের পিতা তাদের চাইতে যোষেফকেই বেশী ভালবাসেন| এইজন্য তারা তাকে ঘৃণা করতে লাগল| তারা যোষেফের সাথে বন্ধুভাবে কথা বলতেও চাইল না| ");
INSERT INTO ben2006_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","একদিন যোষেফ একটা স্বপ্ন দেখলেন| পরে তিনি তার ভাইদের সেই স্বপ্নটা বললেন| এরপর তার ভাইরা তাকে আরও ঘৃণা করতে থাকল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","যোষেফ বললেন, “আমি একটা স্বপ্ন দেখেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","দেখলাম আমরা সকলে ক্ষেতে কাজ করছি| আমরা সকলে গমের আঁটি বাঁধছিলাম, এমন সময় আমার আঁটিটা উঠে দাঁড়াল| আর আমার আঁটির চারপাশে গোল করে ঘিরে থাকা তোমাদের আঁটিগুলো একে একে আমারটিকে প্রণাম জানাল|” ");
INSERT INTO ben2006_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","তার ভাইরা বলল, “তুমি কি মনে কর এর অর্থ তুমি আমাদের রাজা হয়ে আমাদের উপর রাজত্ব করবে?” তার ভাইরা তাদের সম্বন্ধে দেখা এই স্বপ্নের জন্য তাকে আরও ঘৃণা করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","এরপর যোষেফ আরেকটি স্বপ্ন দেখে সেই স্বপ্ন সম্বন্ধে তার ভাইদের বললেন, “আমি আরেকটি স্বপ্ন দেখেছি| দেখলাম সূর্য্য, চাঁদ এবং এগারোটি তারা আমাকে প্রণাম করছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","যোষেফ তাঁর পিতাকেও এই স্বপ্নটি সম্বন্ধে বললেন| কিন্তু তাঁর পিতা এর সমালোচনা করে বললেন, “এ কি ধরণের স্বপ্ন? তুমি কি বিশ্বাস কর যে তোমার মা, তোমার ভাইরা, এমনকি আমিও তোমায় প্রণাম করব?” ");
INSERT INTO ben2006_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","যোষেফের ভাইরা তাঁকে ঈর্ষা করত| কিন্তু যোষেফের পিতা সেসব মনে রাখলেন আর ভেবে অবাক হলেন যে এর অর্থ কি হতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","একদিন যোষেফের ভাইরা শিখিমে গেল তাদের পিতার মেষ চরাতে| ");
INSERT INTO ben2006_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","যাকোব যোষেফকে বলল, “শিখিমে যাও| সেখানে তোমার ভাইরা আমার মেষ চরাচ্ছে|” যোষেফ উত্তর করলেন, “আমি যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","যোষেফের পিতা বললেন, “যাও গিয়ে দেখ তোমার ভাইরা নিরাপদে আছে কিনা| তারপর ফিরে এসে আমাদের জানিও মেষদের অবস্থা কেমন|” এইভাবে যোষেফের পিতা তাকে হিব্রোণ উপত্যকা থেকে শিখিমে পাঠালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","শিখিমে যোষেফ পথ হারালে একজন লোক তাঁকে মাঠে ঘুরে বেড়াতে দেখল| সেই লোকটি বলল, “তুমি কি খুঁজে বেড়াচ্ছ?” ");
INSERT INTO ben2006_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","যোষেফ উত্তর দিলেন, “আমি আমার ভাইদের খোঁজ করছি| বলতে পারেন তারা তাদের মেষ নিয়ে কোথায় গেছে?” ");
INSERT INTO ben2006_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","সেই লোকটি বলল, “তারা তো চলে গেছে| আমি তাদের দোথনে যাবার কথা বলতে শুনেছিলাম|” তাই যোষেফ তার ভাইদের খুঁজতে গেলেন এবং দোথনে তাদের খুঁজে পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","যোষেফের ভাইরা তাকে দূর থেকে আসতে দেখে তাকে হত্যা করার পরিকল্পনা করল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ভাইরা নিজেদের মধ্যে বলাবলি করল, “ঐ দেখ স্বপ্নদর্শক যোষেফ আসছে| তাকে মেরে ফেলার ");
INSERT INTO ben2006_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","এই তো সুযোগ| তাকে আমরা যে কোন একটা খালি কূপের মধ্যে ফেলে দিয়ে পিতাকে গিয়ে বলতে পারি যে এক বুনো জন্তু তাকে মেরে ফেলেছে| এইভাবে আমরা ওকে দেখাব যে তার স্বপ্নগুলো অসার|” ");
INSERT INTO ben2006_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","কিন্তু রূবেণ যোষেফের প্রাণ বাঁচাতে চাইল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","সে বলল, “আমরা তাকে হত্যা করব না| এস, আমরা তাকে হত্যা না করে বরং বিনা আঘাতে ঐ শুকনো কূপের মধ্যে ফেলে দিই|” রূবেণের পরিকল্পনা ছিল যোষেফকে এইভাবে উদ্ধার করে তার পিতার কাছে ফেরত পাঠানোর| ");
INSERT INTO ben2006_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","যোষেফ তার ভাইদের কাছে এলে তারা তাকে আক্রমণ করে তার সুন্দর লম্বা জামাটা ছিঁড়ে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","এরপর তারা তাকে ধরে ছুঁড়ে দিল এক শুকনো কূপের মধ্যে| ");
INSERT INTO ben2006_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","যোষেফ যখন কূপের মধ্যে, সেই সময় তার ভাইরা খেতে বসল| এইসময় তারা একদল বণিককে দেখতে পেল যারা গিলিয়দ থেকে মিশরে যাত্রা করছিল| তাদের উটগুলো বহন করছিল বহু রকম মশলা ও ধন দৌলত| ");
INSERT INTO ben2006_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","তাই যিহূদা তার ভাইদের বলল, “আমাদের ভাইকে হত্যা করে আর তার মৃত্যুর সংবাদ গোপন করে আমাদের কি লাভ হবে? ");
INSERT INTO ben2006_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","এর থেকে লাভ হবে যদি আমরা তাকে এই বণিকদের কাছে বিক্রী করে দিই| এভাবে আমরা আমাদের নিজের ভাইয়ের মৃত্যুর জন্য দোষীও হব না|” অন্য ভাইরাও সম্মতি জানাল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","মিদিয়নীয় বণিকরা কাছে আসতেই ভাইরা যোষেফকে কূপ থেকে তুলে আনলো| তারা তাকে 20টি রৌপ্যমুদ্রার বিনিময়ে বিক্রী করে দিল| বণিকরা এবার তাকে মিশরে নিয়ে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","এই সময় রূবেণ সেখানে তার ভাইদের সঙ্গে ছিল না| সে জানতোও না যে তারা যোষেফকে বিক্রী করে দিয়েছে| রূবেণ কূপের ধারে ফিরে এসে দেখল যোষেফ সেখানে নেই| তখন সে দুঃখ প্রকাশ করার জন্য নিজের কাপড় ছিঁড়ে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ভাইদের কাছে ফিরে গিয়ে রূবেণ বলল, “ছেলেটা সেখানে নেই, এখন আমি কি করব?” ");
INSERT INTO ben2006_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ভাইরা তখন একটা ছাগল মেরে তার রক্তে যোষেফের সুন্দর শালটা রাঙ্গিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","এরপর তারা সেই শালটা তাদের পিতাকে দেখাল| ভাইরা বলল, “আমরা এই শালটা পেয়েছি, দেখুন তো এটা যোষেফের কিনা?” ");
INSERT INTO ben2006_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","তাদের পিতা শালটা দেখে চিনতে পারলেন যে সেটা যোষেফেরই| পিতা বললেন, “হ্যাঁ, এটা তো তারই! হয়তো কোনো বন্য জন্তু তাকে মেরে ফেলেছে| আমার পুত্র যোষেফকে এক হিংস্র পশু খেয়ে ফেলেছে!” ");
INSERT INTO ben2006_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","পুত্র শোকে যাকোব তার কাপড় ছিঁড়ে ফেলল, তারপর চট বস্ত্র পরে দীর্ঘ সময় তার পুত্রের জন্য শোক করল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","যাকোবের পুত্র কন্যারা তাকে সান্ত্বনা দিতে চাইল| কিন্তু যাকোবকে সান্ত্বনা দেওয়া গেল না| সে বলল, “আমার মৃত্যু দিন পর্যন্ত আমি আমার পুত্রের জন্য দুঃখ করে যাব|” তাই যাকোব যোষেফের জন্য দুঃখিত হয়ে রইল| ");
INSERT INTO ben2006_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","মিদিয়নীয় বণিকরা পরে যোষেফকে মিশরে নিয়ে গিয়ে ফরৌণের রক্ষক সেনাপতি পোটীফরের কাছে বিক্রি করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","সেই সময় যিহূদা তার ভাইদের ছেড়ে হীরা নামে একটি লোকের সঙ্গে বাস করতে গেল| হীরা ছিলেন অদুল্লমীয় শহরের লোক| ");
INSERT INTO ben2006_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","সেখানে যিহূদা এক কনানীয় স্ত্রীলোককে দেখতে পেয়ে তাকে বিয়ে করল| মেয়েটির পিতার নাম ছিল শূয়| ");
INSERT INTO ben2006_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","কনানীয় মেয়েটি একটি পুত্রের জন্ম দিয়ে তার নাম রাখল এর| ");
INSERT INTO ben2006_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","পরে সে আরেকটি পুত্রের জন্ম দিয়ে তার নাম রাখল ওনন| ");
INSERT INTO ben2006_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","পরে তার শেলা নামে আরেকটি পুত্র হল| তৃতীয় পুত্রের জন্মের সময় যিহূদা কষীবে বাস করছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","যিহূদা তামর নামে এক কন্যাকে এনে তার সঙ্গে প্রথম পুত্র এরের বিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","কিন্তু এর অনেক মন্দ কাজ করায় প্রভু তার প্রতি অসন্তুষ্ট হলেন এবং তাকে হত্যা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","তখন যিহূদা এরের ভাই ওননকে বলল, “যাও তোমার মৃত ভাইয়ের স্ত্রীর সঙ্গে শয়ন কর| তার স্বামী হও| নিজের ভাই এরের জন্য বংশ উৎপন্ন কর|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ওনন বুঝল মিলনের ফলে সন্তানসন্ততি হলে তা তার হবে না| ওনন তাই যৌন সঙ্গম করল| সে তার শরীরের অভ্যন্তরে বীর্য্য ত্যাগ করল না| ");
INSERT INTO ben2006_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","এই কাজে প্রভু ক্রুদ্ধ হলেন এবং ওননকেও মেরে ফেললেন| ");
INSERT INTO ben2006_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","তখন যিহূদা তার বৌমা তামরকে বলল, “যাও, তোমার পিতার বাড়ী ফিরে যাও| যে পর্যন্ত না আমার ছোট পুত্র শেলা বড় হয় সে পর্যন্ত বিয়ে না করে সেখানেই থাক|” যিহূদা আসলে ভয় পেয়েছিলেন, ভেবেছিলেন অন্য ভাইদের মতো হয়তো শেলাও মারা যাবে| তামর তার পিতার বাড়ী ফিরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","পরে যিহূদার স্ত্রী, শূয়ের কন্যার মৃত্যু হল| শোকের সময় গেলে যিহূদা তার অদুল্লমীয় বন্ধু হীরার সাথে মেষদের লোম ছাঁটতে তিম্নায গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","তামর জানতে পারল যে তার শ্বশুর তিম্নায় তার মেষদের লোম ছাঁটতে যাচ্ছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","তামর বিধবা বলে যে কাপড় পরত তা খুলে ফেলে অন্য কাপড় পরল ও তার মুখ ওড়না দিয়ে ঢাকল| তারপর সে তিম্নার কাছে অবস্থিত ঐনয়িম শহরের দিকে যে রাস্তা চলে গেছে তার ধারে বসল| তামর জানত যে যিহূদার ছোট পুত্র শেলা এখন বড় হয়েছে কিন্তু তবু শেলার সাথে তার বিয়ে দেবার কোন পরিকল্পনাই যিহূদা করে নি| ");
INSERT INTO ben2006_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","যিহূদা সেই পথে যেতে যেতে তাকে দেখে ভাবল বোধ হয় বেশ্যা| (বেশ্যার মত তার মুখ ওড়না দিয়ে ঢাকা ছিল|) ");
INSERT INTO ben2006_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","যিহূদা তার কাছে গিয়ে বলল, “এস আমার সাথে শোও|” (যিহূদা জানত না যে এই ছিল তামর, তার পুত্রবধূ|) সে বলল, “আমায় কত দেবেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","যিহূদা উত্তর করল, “আমার পশুপাল থেকে তোমার জন্য একটা বাচ্চা ছাগল পাঠিয়ে দেব|” সে বলল, “ঠিক আছে| কিন্তু ছাগলটা পৌঁছাবার আগে আমার কাছে কিছু বন্ধক রাখুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","যিহূদা জিজ্ঞেস করল, “তোমাকে যে ছাগল পাঠাব তার প্রমাণ হিসাবে তুমি আমার কাছে কি চাও?” তামর বলল, “চিঠিতে মারবার তোমার ঐ মোহর, ও তার সুতো এবং হাঁটার ছড়িটাও আমায় দাও|” যিহূদা তাকে ঐ জিনিসগুলো দিল| তারপর যিহূদা ও তামর সহবাস করলে তামর গর্ভবতী হল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","তামর ঘরে ফিরে মুখের ওড়নাটা খুলে ফেলে বিধবার সাজে সাজল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","পরে যিহূদা তার বন্ধু হীরাকে ঐনয়িমে পাঠাল সেই বেশ্যাকে ছাগলটা দিতে| যিহূদা হীরাকে আরও বলল যেন সে তার কাছ থেকে সেই মোহর ও ছড়িটা নিয়ে আসে| কিন্তু হীরা তাকে খুঁজে পেল না| ");
INSERT INTO ben2006_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","হীরা ঐনয়িম শহরের লোকদের জিজ্ঞাসা করল, “রাস্তার ধারে বসে থাকা বেশ্যাটা কোথায়?” লোকে উত্তর দিল, “এখানে কখনই কোন বেশ্যা ছিল না তো|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","তাই যিহূদার বন্ধু ফিরে এসে বলল, “সেই স্ত্রীলোককে খুঁজে পেলাম না| সেখানকার লোকজন বলল সেখানে কোন বেশ্যা কখনই ছিল না|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","তাই যিহূদা বলল, “সেইসব জিনিস তার কাছেই থাকুক| আমি চাই না যে লোক আমাদের নিয়ে হাসে| আমি ছাগলটা তাকে দিতে চেয়েছিলাম কিন্তু খুঁজে পেলাম না| এটাই যথেষ্ট|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","তিন মাস পরে কেউ একজন যিহূদাকে বলল, “তোমার পুত্রবধু তামর বেশ্যার কাজ করেছে আর এখন সে গর্ভবতী হয়েছে|” তখন যিহূদা বলল, “তাকে বাইরে নিয়ে এসে পুড়িয়ে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","সেই লোকটি তামরকে হত্যা করতে এলে সে তার শ্বশুরকে এক খবর পাঠাল| তামর বলল, “যে লোকটি আমায় গর্ভবতী করেছে এই জিনিসগুলি তার| এই জিনিসগুলির দিকে দেখ| এগুলো কার? এই মোহর ও সুতো কার? এই ছড়িটা কার?” ");
INSERT INTO ben2006_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","যিহূদা সেই জিনিসগুলো চিনতে পেরে বলল, “সেই ঠিক| আমারই ভুল হয়েছে| আমি আমার পুত্র শেলাকে দেব বলে প্রতিজ্ঞা করেও তাকে দিই নি|” এরপর যিহূদা কিন্তু তার সাথে আর সহবাস করল না| ");
INSERT INTO ben2006_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","তামরের প্রসবের সময় উপস্থিত হলে তারা দেখল তার যমজ সন্তান হতে চলেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","প্রসবের সময় একটা বাচ্চা তার হাত বার করলে ধাইমা তার হাতে একটা লাল সুতো বাঁধল আর বলল, “এই বাচ্চাটা আগে জন্মাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","কিন্তু বাচ্চাটা তার হাত গুটিয়ে নিলে অন্য বাচ্চাটা প্রথমে জন্মাল| তাই সেই ধাইমা বলল, “তুমি প্রথমে ঠেলে বেরিয়ে আসতে পেরেছ!” তাই তারা তার নাম পেরস রাখল| ");
INSERT INTO ben2006_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","এরপর অন্য শিশুটির জন্ম হল, যার হাতে লাল সুতো বাঁধা ছিল| তারা এর নাম রাখল সেরহ| ");
INSERT INTO ben2006_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","বণিকরা যারা যোষেফকে কিনেছিল, তারা তাকে মিশরে নিয়ে গেল এবং ফরৌণের রক্ষকদের সেনাপতি পোটীফরের কাছে বিক্রি করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","কিন্তু প্রভু যোষেফকে সাহায্য করলেন| যোষেফ সফলকর্মা হলেন| যোষেফ সেই মিশরীয় পোটীফরের অর্থাৎ‌ তার মনিবের বাড়ীতেই বাস করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","পোটীফর দেখলেন যে প্রভু যোষেফের সাথে রয়েছেন এবং যোষেফ যা কিছু করেন তাতেই তিনি তাকে সফল হতে দেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","সেইজন্য পোটীফর খুশী হয়ে যোষেফকে তার নিজের বাড়ীর অধ্যক্ষ করে তারই হাতে সব কিছুর ভার দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","যোষেফকে সেই বাড়ীর অধ্যক্ষ করা হলে প্রভু পোটীফরের বাড়ী এবং তার সব কিছুকে আশীর্বাদ করলেন| যোষেফের জন্যই প্রভু একাজ করলেন| আর তিনি পোটীফরের ক্ষেতে যা জন্মাত তাকেও আশীর্বাদযুক্ত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","তাই পোটীফর তার বাড়ীর সব কিছুর ভারই যোষেফের হাতে দিয়ে দিলেন, কেবল নিজের খাবারটা ছাড়া আর কিছুরই জন্য তিনি চিন্তিত ছিলেন না| যোষেফ ছিলেন অত্যন্ত রূপবান ও সুদর্শন পুরুষ| ");
INSERT INTO ben2006_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","কিছু সময় পরে যোষেফের মনিবের স্ত্রীও তাকে পছন্দ করতে শুরু করল| একদিন সে তাকে বলল, “আমার সঙ্গে শোও|” ");
INSERT INTO ben2006_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","কিন্তু যোষেফ প্রত্যাখ্যান করে বলল, “আমার মনিব জানেন তাঁর বাড়ীর প্রতিটি বিষয়ের প্রতি আমি বিশ্বস্ত| তিনি এখানকার সব কিছুর দায় দায়িত্বই আমাকে দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","আমার মনিব আমাকে এই বাড়ীতে প্রায় তাঁর সমান স্থানেই রেখেছেন| আমি কখনই তাঁর স্ত্রীর সঙ্গে শুতে পারি না| এটা মারাত্মক ভুল কাজ! ঈশ্বরের বিরুদ্ধে পাপ কাজ|” ");
INSERT INTO ben2006_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","স্ত্রী লোকটি রোজই যোষেফকে এ কথা বলত, কিন্তু যোষেফ রাজী হতেন না| ");
INSERT INTO ben2006_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","একদিন যোষেফ নিজের কাজ করতে বাড়ীর ভেতরে গেলেন| সেই সময় সেই বাড়ীতে কেবল একা তিনিই ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","তার মনিবের স্ত্রী সেই সময় তার কাপড় টেনে ধরে বলল, “আমার সঙ্গে বিছানায় এস|” কিন্তু যোষেফ সেই বাড়ী থেকে এত দ্রুত দৌড়ে পালাল যে জামাটা স্ত্রীলোকটির হাতেই রয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","স্ত্রীলোকটি দেখল যে যোষেফ তার হাতেই জামাটা ফেলে বাড়ীর বাইরে দৌড়ে বেরিয়ে গেছে| তাই সে চিন্তা করে ঠিক করল যা ঘটেছে সে সম্বন্ধে মিথ্যা কথা বলবে| ");
INSERT INTO ben2006_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","সে তার বাড়ীর ভৃত্যদের ডেকে বলল, “দেখ! এই ইব্রীয় ক্রীতদাসকে কি আমাদের নিয়ে ঠাট্টা করার জন্য এখানে আনা হয়েছে? সে ভিতরে এসে আমাকে আক্রমণ করার চেষ্টা করেছিল, কিন্তু আমি চেঁচিয়ে উঠলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","আমার চিৎকারে সে ভয় পেয়ে পালাল| কিন্তু সে তার জামাটা ফেলে গেছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","তারপর তার স্বামী অর্থাৎ‌ যোষেফের মনিব আসা পর্যন্ত সে সেই জামাটা তার কাছে রেখে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","স্বামীকেও সে ঐ একই ঘটনা বলল| সে বলল, “যে ইব্রীয় দাসটিকে তুমি এখানে এনেছ, সে আমাকে আক্রমণ করার চেষ্টা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","কিন্তু সে আমার কাছে আসতেই আমি চিৎকার করে উঠলাম| সে দৌড়ে পালাল বটে কিন্তু তার জামাটা ফেলে গেল|” ");
INSERT INTO ben2006_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","যোষেফের মনিব তার স্ত্রীর সব কথা শুনে ক্রুদ্ধ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","তাই রাজার শত্রুদের যে কারাগারে রাখা হত, পোটীফর যোষেফকে সেইখানে রাখল| যোষেফ সেখানে রইলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","কিন্তু প্রভু যোষেফের সঙ্গে ছিলেন| প্রভু যোষেফের প্রতি দয়া করে চললেন| কিছুদিন পরে সেই কারাগারের রক্ষকদের প্রধানের কাছে তিনি প্রিয় হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","সেই কারাগারের সমস্ত বন্দীদের ভার যোষেফের হাতে দিলেন| সেই পদে অধিষ্ঠিত যে কোন পদাধিকারী স্বাভাবিকভাবে যা করেন, যোষেফ তাই করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","সুতরাং যোষেফের অধীনের কোন কাজই কারাধিকারীকে তত্ত্বাবধান করতে হত না| এটা হয়েছিল কারণ প্রভু তার সঙ্গে ছিলেন এবং তাকে সব কাজে সফল করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","পরে ফরৌণের দুই ভৃত্য ফরৌণের প্রতি কিছু অন্যায় কাজ করল| এই ভৃত্যরা ছিল তাঁর রুটিওয়ালা ও দ্রাক্ষারস পরিবেশনকারী| ");
INSERT INTO ben2006_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ফরৌণ প্রধান রুটিওয়ালা ও দ্রাক্ষারস পরিবেশনকারীর উপর ক্রুদ্ধ হয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","তাই ফরৌণ তাদের যোষেফের সাথে একই কারাগারে রাখলেন| পোটীফর, ফরৌণের কারারক্ষকদের প্রধান সেই কারাগারের দায়িত্বে ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","প্রধান কারারক্ষক সেই দুই বন্দীকে যোষেফের পরিচর্যার অধীনে রাখলেন| সেই দুইজন লোকই কিছু সময় সেই কারাগারে রইল| ");
INSERT INTO ben2006_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","একদিন রাত্রে দুই বন্দীই স্বপ্ন দেখল| (এই দুই বন্দী ছিল মিশরের রাজার রুটিওয়ালা ও দ্রাক্ষারস পরিবেশনকারী|) প্রত্যেক বন্দীই ভিন্ন ভিন্ন স্বপ্ন দেখল এবং প্রতিটি স্বপ্নের নিজস্ব অর্থ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","পরের দিন সকালে যোষেফ তাদের কাছে গিয়ে দেখলেন যে তারা দুশ্চিন্তাগ্রস্থ| ");
INSERT INTO ben2006_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","যোষেফ জিজ্ঞাসা করলেন, “তোমাদের এত বিষন্ন দেখাচ্ছে কেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","লোক দুটি উত্তর করল, “গত রাতে আমরা স্বপ্ন দেখেছি কিন্তু স্বপ্নের অর্থ বুঝছি না| সেই স্বপ্নের অর্থ বলার বা তা বুঝিয়ে দেবার কেউ নেই|” যোষেফ তাদের বললেন, “ঈশ্বরই একজন যিনি বোঝেন ও স্বপ্নের অর্থ বলতে পারেন| তাই আমার অনুরোধ, তোমাদের স্বপ্নগুলো বল|” ");
INSERT INTO ben2006_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","সুতরাং দ্রাক্ষারস পরিবেশক যোষেফকে তার স্বপ্ন বলল, “আমি স্বপ্নে একটা দ্রাক্ষালতা দেখলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","সেই লতায় তিনটে শাখা ছিল| আমি দেখলাম শাখাগুলিতে ফুল হল এবং দ্রাক্ষা ফলল| ");
INSERT INTO ben2006_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","আমি ফরৌণের পানপাত্র ধরেছিলাম, তাই সেই দ্রাক্ষাগুলোকে সেই কাপে নিঙড়ে নিলাম| তারপর সেই পানপাত্র ফরৌণকে দিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","তখন যোষেফ বললেন, “সেই স্বপ্নের অর্থ আমি তোমায় বলছি| তিনটি শাখার অর্থ তিন দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","তিন দিন শেষ হবার আগেই ফরৌণ তোমায় ক্ষমা করে আবার তোমাক কাজে বহাল করবেন| তুমি ফরৌণের জন্য আগে যে কাজ করতে তাই-ই করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","কিন্তু তুমি ছাড়া পেলে আমায় স্মরণ করো| আমার প্রতি দয়া করো| ফরৌণকে আমার সম্বন্ধে বলো যাতে আমি কারাগার থেকে বেরিয়ে আসতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","আমাকে জোর করে আমার নিজের জায়গা, ইব্রীয়দের দেশ থেকে নিয়ে যাওয়া হয়েছে| কারাগারে থাকার মত কোন অন্যায়ই আমি করি নি|” ");
INSERT INTO ben2006_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","রুটিওয়ালা দেখল অন্য ভৃত্যের স্বপ্নটা ভাল| তখন সে যোষেফকে বলল, “আমিও একটা স্বপ্ন দেখেছি| দেখলাম আমার মাথায় রুটির তিনটে ঝুড়ি রয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","উপরের ঝুড়িতে সব রকমের সেঁকা খাবার ছিল| সেই খাবার রাজার জন্য ছিল কিন্তু পাখীরা ঐ খাবার খেতে লাগল|” ");
INSERT INTO ben2006_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","যোষেফ বললেন, “আমি তোমাকে স্বপ্নের অর্থ বলছি| তিনটে ঝুড়ির অর্থ তিন দিন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","তিন দিনের মধ্যে রাজা তোমাকে কারাগার থেকে মুক্তি দেবেন| তিনি তোমার শিরশ্ছেদ করে একটা বাঁশের মাথায় ঝুলিয়ে দেবেন| আর পাখীরা তোমার দেহের মাংস খাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","তৃতীয় দিনটা ছিল ফরৌণের জন্ম দিন| ফরৌণ তাঁর সব দাসদের জন্য ভোজের আয়োজন করলেন| সেই সময়ে ফরৌণ রুটিওয়ালা ও দ্রাক্ষারস পরিবেশককে কারাগার থেকে মুক্তি দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ফরৌণ পানপাত্র বাহককে মুক্তি দিয়ে পুনরায় তাকে তার কাজে নিয়েগ করলেন| আর সেই পানপাত্র বাহক আবার ফরৌণের হাতে পানপাত্র দিতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","কিন্তু ফরৌণ রুটিওয়ালাকে ফাঁসি দিলেন| যোষেফ যেমনটি বলেছিলেন সেরকম ভাবেই সব ঘটনা ঘটল| ");
INSERT INTO ben2006_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","কিন্তু সেই পানপাত্র বাহকদের যোষেফকে সাহায্য করার কথা মনে রইল না| সে যোষেফের বিষয় ফরৌণকে কিছুই বলল না, যোষেফের কথা ভুলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","দু বছর পর ফরৌণ একটা স্বপ্ন দেখলেন| দেখলেন তিনি নীল নদীর ধারে দাঁড়িয়ে রয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","স্বপ্নে নদী থেকে সাতটা গরু উঠে এসে ঘাস খেতে লাগল| গরুগুলো ছিল হৃষ্টপুষ্ট, দেখতেও ভালো| ");
INSERT INTO ben2006_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","এরপর নদী থেকে আরও সাতটা গরু উঠে এসে পাড়ের হৃষ্টপুষ্ট গরুগুলোর গা ঘেঁসে দাঁড়াল| কিন্তু ঐ গরুগুলো রোগা ছিল, দেখতেও অসুস্থ| ");
INSERT INTO ben2006_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","সেই সাতটা অসুস্থ গরু সাতটা হৃষ্টপুষ্ট গরুগুলোকে খেয়ে ফেলল| তখনই ফরৌণের ঘুম ভেঙ্গে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ফরৌণ আবার শুতে গেলেন; আবার স্বপ্ন দেখলেন| এইবার দেখলেন একটা গাছে সাতটা শীষ বেড়ে উঠছে| শীষগুলো পুষ্ট এবং শস্যে ভরা| ");
INSERT INTO ben2006_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","তারপর দেখলেন আরও সাতটা শীষ উঠছে| কিন্তু শীষগুলো অপুষ্ট আর পূবের বাতাসে ঝলসে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","এরপর ঐ রোগা রোগা সাতটা শীষ পুষ্ট সাতটা শীষকে খেয়ে ফেলল| ফরৌণের ঘুম আবার ভেঙ্গে গেল| তিনি বুঝলেন যে তিনি স্বপ্ন দেখছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","পরের দিন সকালে রাতে দেখা স্বপ্নগুলোর জন্য ফরৌণের মন অস্থির হয়ে উঠল| তাই তিনি মিশরের সমস্ত যাদুকর ও জ্ঞানী লোকদের ডেকে পাঠালেন| ফরৌণ তার স্বপ্ন তাদের বললেন কিন্তু কেউ তার অর্থ বলতে পারল না| ");
INSERT INTO ben2006_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","তখন পানপাত্রবাহকের যোষেফের কথা মনে পড়ল| ভৃত্যটি ফরৌণকে বলল, “আমার সাথে যা ঘটেছিল তা মনে পড়ছে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","আপনি আমার ও রুটিওয়ালার উপর রেগে গিয়েছিলেন এবং আমাদের বন্দী করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","তারপর এক রাতে সে ও আমি স্বপ্ন দেখলাম| প্রত্যেকটি স্বপ্নের আলাদা অর্থ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","আমাদের সাথে কারাগারে এক ইব্রীয় যুবক ছিল| সে ছিল রক্ষীদের অধিকারী ভৃত্য| আমরা তাকে আমাদের স্বপ্ন বললে সে তার মানে বলে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","আর সে যা বলল বাস্তবে তাই-ই ঘটল| সে বলেছিল যে আমি মুক্তি পেয়ে আবার পুরানো কাজ ফিরে পাব–ঘটলও তাই| রুটিওয়ালা সম্বন্ধে বলেছিল যে সে মারা যাবে–ঘটলও তাই|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","তাই ফরৌণ যোষেফকে ডেকে পাঠালে দুজন রক্ষী দ্রুত তাকে কারাগার থেকে বার করে আনল| যোষেফ দাড়ি কামালেন, পরিষ্কার জামা পরলেন| তারপর ফরৌণের সঙ্গে দেখা করতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ফরৌণ যোষেফকে বললেন, “আমি একটা স্বপ্ন দেখেছি কিন্তু কেউ তার ব্যাখ্যা করতে পারছে না| আমি শুনেছি যে তুমি স্বপ্ন শুনলে তার ব্যাখ্যা করতে পার|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","উত্তরে যোষেফ বললেন, “আমি পারি না! কিন্তু হয়তো ফরৌণের জন্য ঈশ্বর তার অর্থ বলে দেবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","তখন ফরৌণ যোষেফকে বলতে লাগলেন, “আমার দেখা স্বপ্নে আমি নীল নদীর ধারে দাঁড়িয়েছিলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","তখন নদী থেকে সাতটা গরু উঠে এসে ঘাস খেতে শুরু করল| গরুগুলো ছিল হৃষ্টপুষ্ট, দেখতেও সুন্দর| ");
INSERT INTO ben2006_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","তারপর আমি নদী থেকে আরও সাতটি গরু উঠে আসতে দেখলাম| কিন্তু এই গরুগুলো রোগা রোগা, দেখতেও অসুস্থ| ঐরকম বিশ্রী গরু আমি মিশরে কখনও দেখি নি| ");
INSERT INTO ben2006_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","তারপর রোগা অসুস্থ গরুগুলো প্রথমে আসা হৃষ্টপুষ্ট গরুগুলোকে খেয়ে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","কিন্তু তাও তাদের চেহারা রোগা আর অসুস্থই রইল| দেখে মনেই হবে না যে তারা সেই মোটা মোটা গরুগুলো খেয়েছে| তারপর আমার ঘুম ভেঙ্গে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“আমার পরের স্বপ্নে আমি দেখলাম একটা গাছে সাতটা শীষ বেড়ে উঠছে| শীষগুলো পুষ্ট শস্যের দানায ভরা| ");
INSERT INTO ben2006_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","তারপর সেগুলোর পরে সাতটা আরও শীষ উঠে এলো| কিন্তু এগুলো রোগা আর পূবের বাতাসে ঝলসানো ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","এরপর সেই অপুষ্ট শীষগুলো পুষ্ট শীষগুলোকে খেয়ে ফেলল| “আমার যাদুকরদের আমি এই স্বপ্নগুলো বললাম বটে কিন্তু তারা তার অর্থ বলতে পারল না| স্বপ্নগুলোর অর্থ কি?” ");
INSERT INTO ben2006_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","তখন যোষেফ ফরৌণকে বললেন, “এই দুই স্বপ্নের বিষয়টা এক| ঈশ্বর শীঘ্রই যা করতে চলেছেন তা আপনার কাছে প্রকাশ করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","উভয় স্বপ্নের প্রকৃত অর্থ এক| সাতটা ভাল গরু এবং সাতটা ভাল শীষ সাতটা ভাল বছরকে বোঝাচ্ছে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","আর সাতটা রোগা গরু, সাতটা অপুষ্ট শীষ বোঝায় সাতটা দুর্ভিক্ষের বছর| সাতটা ভাল বছরের পর দুর্ভিক্ষের সাত বছর আসবে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","শীঘ্র যা ঘটতে চলেছে ঈশ্বর তাই-ই আপনাকে দেখিয়েছেন| যে ভাবে আমি বললাম ঈশ্বর সেইভাবেই এসব ঘটাবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","সাত বছর মিশরে প্রচুর শস্য উৎপন্ন হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","কিন্তু তারপর আসবে দুর্ভিক্ষের সাতটা বছর| মিশরের লোকরা ভুলে যাবে অতীতে কত শস্যই না হত| এই দুর্ভিক্ষে দেশ নষ্ট হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","লোকরা ভুলে যাবে শস্যের প্রাচুর্য্য বলতে কি বোঝায়| ");
INSERT INTO ben2006_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“ফরৌণ, আপনি একটি বিষয় নিয়ে দুটি স্বপ্ন দেখেছন| কারণ ঈশ্বর যে সত্যিই তা ঘটাতে চলেছেন তা আপনাকে দেখাতে চাইলেন| আর তিনি শীঘ্রই তা ঘটাবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","তাই ফরৌণ, আপনার উচিৎ‌ একজন সুবুদ্ধি ও জ্ঞানবান লোক খুঁজে তাকে মিশর দেশের জন্য নিযুক্ত করা| ");
INSERT INTO ben2006_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","তারপর আপনি অন্য লোকদের নিয়োগ করুন যেন তারা খাদ্য সংগ্রহ করে| সাতটি ভাল বছরের প্রত্যেকটি লোক তাদের উৎ‌ পন্ন শস্যের এক পঞ্চমাংশ সেই লোকদের দিক| ");
INSERT INTO ben2006_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","এইভাবে ঐ লোকরা ঐ সাতটি ভাল বছরে প্রচুর খাদ্য সংগ্রহ করে প্রয়োজন না পড়া পর্যন্ত শহরে শহরে সংগ্রহ করে রাখবে| এইভাবে ফরৌণ, আপনার অধীনে ঐ খাদ্য আসবে| ");
INSERT INTO ben2006_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","তারপর দুর্ভিক্ষের সাত বছরে মিশর দেশের জন্য খাদ্য থাকবে| আর দুর্ভিক্ষে মিশর ধ্বংস হয়ে যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","এই পরিকল্পনা ফরৌণের মনপুতঃ হল আর তাঁর আধিকারিকরাও মেনে নিল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","তারপর ফরৌণ তাদের বললেন, “ঐ কাজ করার জন্যে মনে হয় না আমরা যোষেফের থেকে আর ভাল কাউকে পাব! ঈশ্বরের আত্মা তার সঙ্গে রয়েছে আর সেই জন্যই সে জ্ঞানবান!” ");
INSERT INTO ben2006_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","তাই ফরৌণ যোষেফকে বললেন, “ঈশ্বর তোমাকে এই সমস্ত যখন জানিয়েছেন তখন তোমার মত জ্ঞানী আর কে হতে পারে? ");
INSERT INTO ben2006_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","আমি তোমাকে আমার নিয়ন্ত্রণের জন্য নিযুক্ত করলাম, সমস্ত লোক তোমার আদেশ পালন করবে| ক্ষমতার দিক থেকে কেবল আমি তোমার চেয়ে বড় থাকব|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ফরৌণ যোষেফকে বিশেষ অনুষ্ঠানের মাধ্যমে রাজ্যপাল করলেন| ফরৌণ যোষেফকে বললেন, “আমি তোমাকে সমগ্র মিশরের রাজ্যপাল হিসেবে নিযুক্ত করলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","তারপর ফরৌণ তাঁর আংটি খুলে যোষেফের হাতে পরিয়ে দিলেন| সেই আংটিতে রাজকীয় ছাপ ছিল| ফরৌণ তাকে মিহি কার্পাসের পোশাক দিলেন এবং তার গলায় সোনার হার পরিয়ে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ফরৌণ যোষেফকে দ্বিতীয় রথে চড়তে দিলেন| রক্ষকরা যোষেফের রথের আগে আগে যেতে যেতে লোকদের বলতে থাকল, “যোষেফের সামনে হাঁটু গাড়ো|” এইভাবে যোষেফ সমগ্র মিশরের রাজ্যপাল হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ফরৌণ তাকে বললেন, “আমি রাজা ফরৌণ, সুতরাং আমি যা চাই তাই করব কিন্তু মিশরের আর কেউ তোমার আজ্ঞা ছাড়া হাত অথবা পা তুলতে পারবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ফরৌণ যোষেফের আর এক নাম সাফনত্‌-পানেহ রাখলেন| ফরৌণ যোষেফকে আসনত্‌ নামে এক কন্যার সঙ্গে বিয়েও দিলেন| সে ছিল ওন নামক শহরে যাজক পোটীফরের কন্যা| এইভাবে যোষেফ সমস্ত মিশর দেশের রাজ্যপাল হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","যোষেফের 30 বছর বয়সে তিনি মিশর দেশের রাজার সেবা করতে শুরু করলেন| তিনি সমস্ত মিশর দেশ ঘুরলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","সাত বছর মিশরে খুব ভাল শস্য উৎপন্ন হল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","আর ঐ সাত বছর ধরে যোষেফ মিশরে খাবার সঞ্চয় করলেন| প্রত্যেক শহরে শহরে যোষেফ সেই শহরের আশেপাশের ক্ষেতে যা জন্মাত তার থেকে সংগ্রহ করতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","যোষেফ সমুদ্রের বালির মত এত শস্য সংগ্রহ করলেন যে তা মাপা গেল না কারণ তা মাপা সম্ভব ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","যোষেফের স্ত্রী আসনৎ ছিলেন ওন শহরের যাজকের কন্যা| দুর্ভিক্ষের প্রথম বছর আসার আগেই যোষেফ এবং আসনতের দুটি পুত্র হল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","প্রথম পুত্রের নাম রাখা হল মনঃশি| যোষেফ এই নাম দিলেন কারণ তিনি বললেন, “ঈশ্বর আমার সমস্ত কষ্ট ও আমার বাড়ীর সমস্ত চিন্তা ভুলে যেতে দিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","যোষেফ দ্বিতীয় পুত্রের নাম রাখলেন ইফ্রয়িম| যোষেফ এই নাম রাখলেন কারণ তিনি বললেন, “আমার মহাকষ্টের মধ্যেও ঈশ্বর আমাকে ফলবান করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","সাত বছর লোকরা খাদ্যের জন্য প্রচুর শস্য পেল| তারপর সেই বছরগুলো শেষ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","এবার দুর্ভিক্ষের সাতটা বছর শুরু হল ঠিক যেমনটি যোষেফ বলেছিলেন| সেই অঞ্চলের কোন দেশে কোথাও কোন খাদ্য শস্য জন্মালো না| কিন্তু মিশরের লোকদের জন্য যথেষ্ট খাদ্য ছিল. কারণ যোষেফ শস্য জমা করে রেখেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","দুর্ভিক্ষের সময় শুরু হলে লোকরা খাদ্যের জন্য ফরৌণের কাছে এসে কান্নাকাটি করল| ফরৌণ মিশরীয়দের বললেন, “যাও যোষেফকে গিয়ে জিজ্ঞেস কর কি করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","সব জায়গায় দুর্ভিক্ষ দেখা দিলে যোষেফ গুদাম থেকে লোকদের শস্য বিক্রি করতে শুরু করলেন| দুর্ভিক্ষ মিশরেও ভয়াবহ রূপ নিল| ");
INSERT INTO ben2006_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","সর্বত্রই সেই দুর্ভিক্ষ প্রবল হল, ফলে মিশরের আশেপাশের দেশ থেকেও লোকরা শস্য কিনতে এলো| ");
INSERT INTO ben2006_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","কনান দেশেও প্রবলভাবে দুর্ভিক্ষ হলো| যাকোব জানতে পারল যে মিশর দেশে শস্য রয়েছে| তাই যাকোব তার পুত্রদের বলল, “আমরা কিছু না করে কেন এখানে বসে রয়েছি? ");
INSERT INTO ben2006_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","শুনলাম মিশর দেশে শস্য বিক্রি হচ্ছে| চল সেখানে গিয়ে আমরা শস্য কিনি| তাহলে আমরা বাঁচব| মরব না!” ");
INSERT INTO ben2006_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","তাই যোষেফের দশ ভাই মিশরে শস্য কিনতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","যাকোব কিন্তু বিন্যামীনকে পাঠালেন না| (কেবল বিন্যামীনই যোষেফের সহোদর ভাই ছিলেন|) যাকোব ভয় পেলেন পাছে বিন্যামীনের খারাপ কিছু ঘটে| ");
INSERT INTO ben2006_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","কনানেও দুর্ভিক্ষ ভয়াবহ রূপ নিল ফলে কনান দেশের বহু লোক মিশরে শস্য কিনতে গেল| তাদের মধ্যে ইস্রায়েলের সন্তানরাও ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","সেই সময় যোষেফ মিশর দেশের রাজ্যপাল ছিলেন| আর যে সব লোক মিশরে শস্য কিনতে আসত তাদের উপর যোষেফ নজর রাখতেন| তাই যোষেফের ভাইরাও তার কাছে এসে হেঁট হয়ে প্রণাম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","যোষেফ তাঁর ভাইদের দেখে চিনতে পারলেন, কিন্তু এমন ভান করলেন যেন তাদের চেনেনই না| তিনি তাদের সঙ্গে কর্কশভাবে কথা বললেন| তিনি বললেন, “তোমরা কোথা থেকে এসেছ?” ভাইরা উত্তর দিল, “আমরা কনান দেশ থেকে এখানে খাদ্য কিনতে এসেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","যোষেফ জানতেন যে এই লোকরাই তার ভাই কিন্তু তারা যোষেফকে চিনল না| ");
INSERT INTO ben2006_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","আর ভাইদের নিয়ে যোষেফ যে স্বপ্নগুলি দেখেছিলেন তা তাঁর মনে পড়ে গেল| যোষেফ তাঁর ভাইদের বললেন, “তোমরা এখানে শস্য কিনতে আস নি! তোমরা গুপ্তচর| তোমরা আমাদের দুর্বল জায়গাগুলো জানতে এসেছ|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","কিন্তু তাঁর ভাইরা বলল, “তা নয় মহাশয়! আমরা আপনার দাস, কেবল খাদ্য কিনতে এসেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","আমরা ভাইরা এক পিতার সন্তান| আমরা সৎ‌ লোক, আমরা কেবল খাদ্য কিনতে এসেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","তখন যোষেফ তাদের বললেন, “তা নয়, কিন্তু তোমরা আমাদের কোথায় দুর্বলতা তাই দেখতে এসেছ|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","আর ভাইরা বলল, “না! আমরা সবাই ভাই ভাই! আমাদের পরিবারে আমরা বারো ভাই| আমাদের সকলের পিতা একজনই| ছোট ভাই এখনও আমাদের পিতার কাছে রয়েছে| অন্য ভাইটি বহু বছর আগে মারা গেছে| আমরা আপনার দাস, কনান দেশ থেকে এসেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","কিন্তু যোষেফ তাদের বললেন, “না! আমি দেখছি আমার কথাই ঠিক| তোমরা গুপ্তচরই বটে| ");
INSERT INTO ben2006_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","কিন্তু তোমরা যে সত্য বলছ তা আমি তোমাদের প্রমাণ করতে দেব| ফরৌণের নামে দিব্যি দিয়ে বলছি, যে পর্যন্ত না তোমাদের ছোট ভাই এখানে আসে আমি তোমাদের যেতে দেব না| ");
INSERT INTO ben2006_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","আমি তোমাদের একজনকে যেতে দেব যে ছোট ভাইকে আমার কাছে নিয়ে আসবে, সেই সময়ে তোমরা কারাগারে থাকবে| আমরা দেখব যে তোমাদের কথা সত্যি কিনা, যদিও আমার বিশ্বাস যে তোমরা গুপ্তচর|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","তারপর যোষেফ তাদের তিনদিনের জন্য কারাগারে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","তিন দিন পরে যোষেফ তাদের বললেন, “আমি ঈশ্বরকে ভয় করি! এই কাজ করলে তোমরা বাঁচবে| ");
INSERT INTO ben2006_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","তোমরা যদি সত্যিই সৎ‌ লোক হও তবে তোমাদের এক ভাই এখানে এই কারাগারে থাকুক| অন্যরা শস্য বহন করে আপনজনের কাছে নিয়ে যেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","কিন্তু তোমরা অবশ্যই ছোট ভাইকে এখানে আমার কাছে নিয়ে আসবে| তাহলে আমি জানব যে তোমরা সত্য বলছ এবং তোমরা প্রাণে বাঁচবে|” ভাইরা এতে সম্মতি জানাল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","তারা একে অপরকে বলল, “আমরা যোষেফের প্রতি যে অন্যায় কাজ করেছিলাম তার জন্য এই শাস্তি পাচ্ছি| আমরা তার কষ্ট দেখেও তার প্রাণের জন্য মিনতি শুনতে অস্বীকার করেছিলাম, আর এখন তাই আমরা এই সমস্যায় পড়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","তখন রূবেণ তাদের বলল, “আমি তোমাদের বলেছিলাম ঐ ছেলেটার প্রতি কোন অন্যায় করো না| কিন্তু তোমরা আমার কথা শুনতে চাও নি| তাই এখন তার মৃত্যুর জন্য আমরা শাস্তি পাচ্ছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","যোষেফ ভাইদের সঙ্গে কথা বলার জন্য অনুবাদক ব্যবহার করছিলেন| তাই ভাইরা বুঝল না যে যোষেফ তাদের ভাষা বুঝতে পারছেন| কিন্তু যোষেফ যা শুনছিলেন তার সব কিছুই বুঝলেন| তাদের কথাবার্তা যোষেফকে দুঃখিত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","তাই যোষেফ তাদের থেকে দূরে গিয়ে কাঁদলেন| কিছুক্ষণ পরে যোষেফ আবার তাদের কাছে ফিরে এলেন| তিনি শিমিয়োনকে ধরে তাদের সামনেই বাঁধলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","যোষেফ তাঁর ভৃত্যদের বললেন যেন তাদের বস্তাগুলো শস্যে ভরে দেয়| ভাইরা শস্যের জন্য যোষেফকে টাকা দিল| কিন্তু যোষেফ সে টাকা না নিয়ে তাদের বস্তাতেই ফেরত রাখলেন| তারপর তিনি তাদের পথ যাত্রার জন্য প্রয়োজনীয় জিনিসগুলিও দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","তাই ভাইরা গাধার পিঠে শস্য চাপিয়ে রওনা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","সেই রাত্রে ভাইরা রাত কাটানোর জন্য এক জায়গায় এসে থামল| এক ভাই গাধার খাবার শস্য বার করার জন্য বস্তা খুলতেই বস্তায় তার টাকা দেখতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","সে অন্য ভাইদের বলল, “দেখ, শস্য কিনতে যে টাকা দিয়েছিলাম তা ফেরত এসেছে|” কেউ বস্তায় টাকা ফেরত রেখেছে| এতে ভাইরা খুব ভয় পেয়ে গেল| তারা একে অন্যকে বলল, “ঈশ্বর আমাদের প্রতি এ কি করেছেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ভাইরা তাদের কনান দেশে পিতা যাকোবের কাছে ফিরে গেল| যা ঘটেছে তার সব কিছু তারা যাকোবকে বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","তারা বলল, “সেই দেশের রাজ্যপাল আমাদের সঙ্গে কর্কশভাবে কথা বললেন| তিনি ভাবলেন আমরা গুপ্তচর! ");
INSERT INTO ben2006_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","কিন্তু আমরা তাঁকে বললাম যে আমরা গুপ্তচর নই, আমরা সৎ‌ লোক| ");
INSERT INTO ben2006_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","আমরা তাঁকে আমাদের পিতার কথা এবং ছোট ভাই কনান দেশে পিতার সঙ্গে বাড়ীতে রয়েছে তার কথা এবং এক ভাই যে মারা গেছে তার কথাও বললাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“তখন সেই দেশের রাজ্যপাল আমাদের এই কথা বললেন, ‘তোমরা যে সৎ‌ লোক তার প্রমাণ দেবার একটা পথ রয়েছে| আমার এখানে তোমাদের এক ভাইকে রেখে যাও| তোমাদের শস্য তোমাদের পরিবারের কাছে নিয়ে যাও| ");
INSERT INTO ben2006_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","তারপর তোমাদের ছোট ভাইকে আমার কাছে নিয়ে এসো| তাহলে আমি বুঝব তোমরা সৎ‌ লোক, অথবা তোমরা গুপ্তচর হয়ে আমাদের ধ্বংস করতে এসেছ কিনা| তোমরা যদি সত্যি বলছ প্রমাণ হয় তবে আমি তোমাদের ভাইকে ফেরত দেব আর তোমরা আবার স্বচ্ছন্দে এই দেশ থেকে শস্য কিনতে পারবে|’” ");
INSERT INTO ben2006_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","তারপর ভাইরা তাদের বস্তা থেকে শস্য বার করতে শুরু করলো| আর প্রত্যেক ভাই নিজের নিজের বস্তায় নিজের নিজের টাকা খুঁজে পেলো| ভাইরা ও তাদের পিতা সেই টাকা দেখে ভীত হল| ");
INSERT INTO ben2006_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","যাকোব তাদের বললেন, “তোমরা কি চাও আমি আমার সব সন্তানদের হারাই? যোষেফ চলে গেছে| শিমিয়োনও নেই| আর এখন তোমরা বিন্যামীনকেও নিয়ে যেতে এসেছ|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","কিন্তু রূবেন তার পিতাকে বলল, “পিতা, যদি আমি বিন্যামীনকে তোমার কাছে ফিরিয়ে না আনি তবে তুমি আমার দুই সন্তানকে হত্যা করো|” ");
INSERT INTO ben2006_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","কিন্তু যাকোব বললেন, “আমি বিন্যামীনকে তোমাদের সঙ্গে যেতে দেব না| তার ভাই মৃত আর আমার স্ত্রী রাহেলের পুত্রদের মধ্যে সেই অবশিষ্ট| মিশরে যাবার পথে তার যদি কিছু হয় তবে তা আমাকে মেরেই ফেলবে| তাহলে এই দুঃখে তোমরা আমাকে, এই বৃদ্ধ মানুষকে মেরে ফেলবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","দুর্ভিক্ষের সময়টা সেই দেশের পক্ষে খারাপ হল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","মিশর থেকে আনা সব শস্যই লোকরা খেয়ে শেষ করে ফেলল| যখন সেইসব শস্য শেষ হল, যাকোব তার দুটি পুত্রকে বলল, “মিশরে গিয়ে খাবার জন্য আরও শস্য কিনে আনো|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","কিন্তু যিহূদা যাকোবকে বলল, “কিন্তু সেই দেশের রাজ্যপাল আমাদের সাবধান করে দিয়ে বলেছেন, ‘তোমরা তোমাদের ভাইকে নিয়ে না এলে আমি তোমাদের সঙ্গে কথা বলব না|’ ");
INSERT INTO ben2006_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","আপনি বিন্যামীনকে আমাদের সঙ্গে পাঠালে আমরা আবার শস্য কিনতে যেতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","কিন্তু বিন্যামীনকে না পাঠালে আমরা যাব না| সেই রাজ্যপাল আমাদের সাবধান করে দিয়ে বলেছে তাকে না নিয়ে আসা চলবে না|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ইস্রায়েল বললেন, “কেন তোমরা তাঁকে বললে যে তোমাদের আরেক ভাই রয়েছে? কেন তোমরা আমায় এই রকম বিপদে ফেললে|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ভাইরা উত্তরে বলল, “লোকটি অনেক প্রশ্ন জিজ্ঞাসা করছিলেন| তিনি আমাদের ও আমাদের পরিবার সম্বন্ধে সব কিছু জানতে চাইছিলেন| তিনি এও জিজ্ঞাসা করলেন, ‘তোমাদের পিতা কি এখনও জীবিত আছেন? তোমাদের বাড়ীতে কি আর কোন ভাই রয়েছে?’ আমরা কেবল তাঁর প্রশ্নের উত্তর দিয়েছি| আমরা জানতাম না যে তিনি ছোট ভাইকে নিয়ে আসতে বলবেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","তখন যিহূদা তার পিতা ইস্রায়েলকে বলল, “বিন্যামীনকে আমার সঙ্গে যেতে দিন| আমি তার যত্ন নেব| আমাদের মিশরে যেতেই হবে, না গেলে আমরা সবাই মারা যাব, এমনকি আমাদের সন্তানরাও মরবে| ");
INSERT INTO ben2006_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","আমি নিশ্চিতভাবে তার নিরাপত্তার দিকে নজর রাখব| আমিই তার দায়িত্ব নেব| আমি যদি তাকে ফেরত না আনি তবে চিরকাল তোমার কাছে অপরাধী থাকব| ");
INSERT INTO ben2006_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","আমাদের যদি আগে যেতে দিতে তবে আমরা দ্বিতীয়বার খাবার নিয়ে আসতে পারতাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","তখন তাদের পিতা ইস্রায়েল বললেন, “এই যদি সত্যি হয় তবে বিন্যামীনকে তোমাদের সঙ্গে নাও| কিন্তু রাজ্যপালের জন্য কিছু উপহার নিয়ে যেও| সেই সমস্ত জিনিস যা আমরা আমাদের দেশে সংগ্রহ করেছি তা নিয়ে যাও| তার জন্য মধু, পেস্তা, বাদাম, ধূনো, আঠা এবং সুগন্ধদ্রব্য এইসব নিয়ে যাও| ");
INSERT INTO ben2006_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","এইবার তোমাদের সঙ্গে দ্বিগুন টাকা নিও| গতবার দাম মেটাবার পর যে টাকা তোমাদের কাছে ফেরৎ‌ এসেছিল তা সঙ্গে নাও| হতে পারে রাজ্যপালের ভুল হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","বিন্যামীনকে নিয়েই তার কাছে যাও| ");
INSERT INTO ben2006_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","আমার প্রার্থনা তোমরা যখন রাজ্যপালের সামনে দাঁড়াবে তখন যেন সর্বশক্তিমান ঈশ্বর তোমাদের সাহায্য করেন| প্রার্থনা করি সে যেন বিন্যামীন ও শিমিয়োনকে নিরাপদে ফিরে আসতে দেয়| যদি তা না হয় তবে আমি পুত্র হারানোর শোকে আবার মুষড়ে পড়ব|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","তাই ভাইরা রাজ্যপালকে দেবার জন্য উপহারগুলো নিল আর সঙ্গে আগে যা নিয়েছিল তার দ্বিগুন টাকা নিল| এইবার বিন্যামীনও তার ভাইদের সাথে মিশরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","মিশরে যোষেফ বিন্যামীনকে তার ভাইদের সঙ্গে দেখতে পেয়ে ভৃত্যদের বললেন, “ঐ লোকদের আমার বাড়ী নিয়ে এস| পশু মেরে রান্না কর| এই লোকরা আজ দুপুরে আমার সঙ্গে খাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ভৃত্যটি কথা মত কাজ করল| সে ঐ লোকদের যোষেফের বাড়ীর ভিতর নিয়ে এল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","যোষেফের বাড়ী যাবার সময় ভাইরা ভয় পেয়ে গেল| তারা বলল, “গতবার যে টাকা আমাদের বস্তায় ফেরৎ‌ দেওয়া হয়েছিল তার জন্যই বোধহয় আমাদের এখানে আনা হচ্ছে| ঐ বিষয়টিকেই আমাদের বিরুদ্ধে প্রমাণ হিসেবে ব্যবহার করে তারা আমাদের গাধা কেড়ে নিয়ে আমাদের দাস করে রাখবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","তাই ভাইরা যোষেফের বাড়ীর প্রধান ভৃত্যের কাছে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","তারা বলল, “সত্যি বলছি গতবার আমরা শস্য কিনতে এসেছিলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","বাড়ী ফেরার পথে আমরা বস্তা খুলে প্রত্যেক বস্তায় আমাদের টাকা খুঁজে পেলাম| আমরা জানি না টাকা সেখানে কি করে এলো| কিন্তু আমরা সেই টাকা ফেরৎ‌ দেবার জন্য নিয়ে এসেছি| আর এবারের শস্য কেনার জন্যও টাকা এনেছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","কিন্তু সেই ভৃত্য বলল, “ভয় পেও না, আমায় বিশ্বাস কর| তোমাদের ঈশ্বর, তোমাদের পিতার ঈশ্বর নিশ্চয়ই উপহার হিসাবে সেই টাকা তোমাদের বস্তায় ফেরৎ‌ দিয়েছেন| আমার মনে আছে তোমরা গতবার শস্যের জন্য দাম দিয়েছিলে|” তারপর সেই ভৃত্যটি শিমিয়োনকে কারাগার থেকে বাইরে আনল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ভৃত্যটি তাদের যোষেফের বাড়ী নিয়ে গেল| সে তাদের জল দিলে তারা পা ধুয়ে নিল| তারপর সে তাদের গাধাদের খাবার খেতে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ভাইরা শুনতে পেল যে তারা যোষেফের সঙ্গে খাবে| তাই তারা দুপুর পর্যন্ত তাদের উপহার সাজাল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","যোষেফ বাড়ী ফিরলে ভাইরা তাদের সঙ্গে করে আনা উপহার তাঁকে দিল| তারপর তারা হাঁটু গেড়ে তাকে প্রণাম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","যোষেফ তারা কেমন আছে জিজ্ঞেস করলেন| তারপর বললেন, “তোমাদের বৃদ্ধ পিতা যাঁর সম্বন্ধে আমাকে বলেছিলে তিনি কেমন আছেন? তিনি কি এখনও জীবিত আছেন?” ");
INSERT INTO ben2006_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ভাইরা উত্তর দিল, “হ্যাঁ, মহাশয়, আমাদের পিতা এখনও জীবিত আছেন|” তারপর তারা আবার যোষেফের সামনে হাঁটু গেড়ে তাঁকে প্রণাম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","তখন যোষেফ বিন্যামীনকে দেখতে পেলেন| (বিন্যামীন ও যোষেফ ছিলেন এক মায়ের সন্তান|) যোষেফ বললেন, “এই কি তোমাদের ছোট ভাই যার সম্বন্ধে তোমরা আমায় বলেছিলে?” তারপর যোষেফ বিন্যামীনকে বললেন, “বৎ‌স, ঈশ্বর তোমায় আশীর্বাদ করুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","সেই সময় যোষেফ ঘর থেকে দৌড়ে বেরিয়ে গেলেন| যোষেফ তাঁর ভাই বিন্যামীনকে যে ভালবাসেন তা প্রকাশ করতে চাইলেন| তাঁর কান্না পেল, কিন্তু তিনি চাইলেন না যে তাঁর ভাইরা তাঁকে কাঁদতে দেখুক| তাই যোষেফ দৌড়ে তাঁর ঘরে গিয়ে কাঁদতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","তারপর যোষেফ তাঁর মুখ ধুয়ে বাইরে বেরিয়ে এলেন| নিজেকে সামলে নিয়ে তিনি বললেন, “এখন খাবার সময় হয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ভৃত্যরা যোষেফের জন্য একটা টেবিলে ব্যবস্থা করল| অন্য টেবিলে তাঁর ভাইদের বসার ব্যবস্থা হল, এছাড়া মিশরীয়দের জন্য আলাদা আরেকটা টেবিলে ব্যবস্থা করা হল| মিশরীয়রা মনে মনে বিশ্বাস করত যে ইব্রীয়দের সঙ্গে বসে তাদের খাওয়াটা উচিত কাজ নয়| ");
INSERT INTO ben2006_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","যোষেফের ভাইরা তাঁর সামনের টেবিলেই বসল| ভাইরা ছোট থেকে বড়জন পরপর বসেছিল| কি ঘটছিল তাই ভেবে ভাইরা বিস্ময়ে একে অপরের দিকে চাইল| ");
INSERT INTO ben2006_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ভৃত্যরা যোষেফের টেবিল থেকে খাবার এনে তাদের দিচ্ছিল| তবে ভৃত্যরা বিন্যামীনকে অন্যদের চাইতে পাঁচগুণ বেশী খাবার দিল| ভাইরা যোষেফের সঙ্গে খেল, পান করল যে পর্যন্ত না তারা প্রায় মৎত হয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","তারপর যোষেফ তাঁর ভৃত্যদের এক আদেশ দিয়ে বললেন, “ওদের প্রত্যেকের বস্তা বইবার ক্ষমতা অনুসারে শস্য ভর্ত্তি করে দাও| আর প্রত্যেকের টাকাও তাদের শস্যের সঙ্গে রেখে দাও| ");
INSERT INTO ben2006_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","আমার ছোট ভাইয়ের বস্তায় তার টাকাটা রেখো এবং তার সঙ্গে আমার বিশেষ রূপোর পেয়ালাটাও রেখো|” ভৃত্যরা যোষেফের কথা মত কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","পরের দিন ভোরবেলা ভাইদের গাধায় করে দেশে ফেরার জন্য বিদেয় করা হল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","তারা শহর ছেড়ে বেরোলে যোষেফ তাঁর ভৃত্যকে বললেন, “যাও, ওদের পিছু নাও| ওদের থামিয়ে বল, ‘আমরা তোমাদের প্রতি কি ভাল ব্যবহার করি নি? তবে তোমরা কেন আমাদের সঙ্গে খারাপ ব্যবহার করলে? কেন তোমরা আমার মনিবের রূপোর পেয়ালা চুরি করলে? ");
INSERT INTO ben2006_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","আমার মনিব সেই পেয়ালা থেকে পান করেন এবং গণনার জন্যও ব্যবহার করেন| তোমরা যা করেছ তা অন্যায় কাজ|’” ");
INSERT INTO ben2006_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ভৃত্যটি সেই মত কাজ করল| সে সেখানে পৌঁছে ভাইদের থামালো| যোষেফ যা বলতে বলেছিলেন, ভৃত্যটি সেই মত কথা বলল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","কিন্তু ভাইরা ভৃত্যটিকে বলল, “রাজ্যপাল কেন এইরকম কথা বলছেন? আমরা সেইরকম কোন কাজ করতেই পারি না| ");
INSERT INTO ben2006_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","আমরা আমাদের বস্তায় যে টাকা আগের বার পেয়েছিলাম তা ফিরিয়ে এনেছিলাম| তাহলে নিশ্চয়ই আমরা তোমার মনিবের বাড়ী থেকে সোনা কি রূপা কিছুই চুরি করতে পারি না| ");
INSERT INTO ben2006_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","তুমি যদি সেই রূপোর পেয়ালা আমাদের কারও বস্তায় খুঁজে পাও তবে তার মৃত্যু হোক্| তুমি তাকে তাহলে হত্যা করতে পারো এবং সেক্ষেত্রে আমরাও তোমার দাস হব|” ");
INSERT INTO ben2006_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ভৃত্যটি বলল, “আমরা তোমাদের কথা মতই কাজ করব| কিন্তু আমি সেই জনকে হত্যা করব না| আমি রূপোর পেয়ালা খুঁজে পেলে সেই জন আমার দাস হবে, অন্যরা যেতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","তখন প্রত্যেক ভাই তাড়াতাড়ি মাটিতে নিজেদের বস্তা খুলে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ভৃত্যটি বস্তাগুলি দেখতে লাগল| জ্যেষ্ঠ থেকে শুরু করে কনিষ্ঠের বস্তা খুঁজে দেখলে বিন্যামীনের বস্তায় সেই পেয়ালা খুঁজে পাওয়া গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ভাইরা এতে অত্যন্ত দুঃখিত হল| তারা তাদের শোক প্রকাশ করতে জামা ছিঁড়ে ফেলল| নিজেদের বস্তা আবার গাধায় চাপিয়ে শহরে ফিরে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","যিহূদা তার ভাইদের নিয়ে যোষেফের বাড়ী গেল| যোষেফ তখনও বাড়ীতে ছিলেন| ভাইরা তার সামনে মাটিতে পড়ে তাকে প্রণাম করল| ");
INSERT INTO ben2006_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","যোষেফ তাদের বললেন, “তোমরা কেন এ কাজ করেছ| তোমরা কি জানতে না যে আমি গণনা করতে পারি? এ কাজে আমার থেকে ভালো কেউ নেই|” ");
INSERT INTO ben2006_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","যিহূদা বলল, “মহাশয়, আমাদের বলবার কিছুই নেই| ব্যাখ্যা করারও পথ নেই| আমরা যে নির্দোষ তা প্রমাণ করারও পথ নেই| অন্য কোন অন্যায় কাজের জন্য ঈশ্বর আমাদের বিচারে দোষী করেছেন| সেইজন্য আমরা সবাই এমনকি, বিন্যামীনও, আপনার দাস হব|” ");
INSERT INTO ben2006_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","কিন্তু যোষেফ বললেন, “আমি তোমাদের সবাইকে দাস করব না| কেবল যে পেয়ালা চুরি করেছে সেই আমার দাস হবে| বাকী তোমরা তোমাদের পিতার কাছে শান্তিতে ফিরে যাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","তখন যিহূদা যোষেফের কাছে গিয়ে বললেন, “মহাশয়, দয়া করে আমাকে সব কথা পরিস্কার করে আপনাকে বলতে দিন| দয়া করে আমার প্রতি রাগ করবেন না| আমি জানি আপনি ফরৌণের সমান| ");
INSERT INTO ben2006_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","আমরা আগে যখন এখানে এসেছিলাম তখন আপনি জিজ্ঞেস করেছিলেন, ‘তোমাদের একজন পিতা আর ভাই আছে কি?’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","আমরা আপনাকে উত্তর দিয়েছিলাম, ‘আমাদের এক পিতা আছেন, তিনি বৃদ্ধ| আমাদের এক ছোট ভাই রয়েছে| আমাদের পিতা তাকে ভালবাসেন কারণ সে তার বৃদ্ধ বয়সের সন্তান| আর সেই ছোট ভাইয়ের নিজের এক ভাই মারা গেছে| তাই তার মায়ের পুত্রদের মধ্যে একমাত্র সেই বেঁচে আছে এবং তার পিতা তাকে খুব ভালবাসেন|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","তারপর আপনি বললেন, ‘তবে সেই ভাইকেই আমার কাছে নিয়ে এস| আমি তাকে দেখতে চাই|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","আর আমরা আপনাকে বললাম, ‘সেই ছোট ভাই পিতাকে ছেড়ে আসতে পারে না| আর পিতা তাকে হারালে শোকেতে মারাই যাবেন|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","কিন্তু আপনি আমাদের বললেন, ‘তোমাদের অবশ্যই সেই ভাইকে আনতে হবে নতুবা আমি শস্য বিক্রি করব না|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","তাই আমরা ফিরে গিয়ে আপনি যা বলেছিলেন তা আমাদের পিতাকে জানালাম| ");
INSERT INTO ben2006_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“পরে আমাদের পিতা বললেন, ‘যাও, গিয়ে আরও কিছু শস্য কিনে আনো|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","আর আমরা পিতাকে বললাম, ‘আমরা ছোট ভাইকে না নিয়ে যেতে পারি না| রাজ্যপাল বলেছেন ছোট ভাইকে না দেখলে তিনি আমাদের কাছে শস্য বিক্রি করবেন না|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","তখন আমাদের পিতা বললেন, ‘তোমরা জান আমার স্ত্রী রাহেলের দুটি সন্তান হয়| ");
INSERT INTO ben2006_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","তাদের একজনকে আমি যেতে দিলে বন্য জন্তু তাকে মেরে ফেলল| সেই থেকে আর কখনও তাকে দেখিনি| ");
INSERT INTO ben2006_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","তোমরা যদি অন্য জনকেও আমার কাছে থেকে নিয়ে যাও আর তার যদি কিছু ঘটে তাহলে আমি শোকে মারা যাব|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","এখন ভেবে দেখুন ছোট ভাইকে নিয়ে বাড়ী না ফিরলে কি ঘটবে–এই ছোট ভাই পিতার প্রাণের জন্য অত্যন্ত গুরুত্বপূর্ণ! ");
INSERT INTO ben2006_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ছোট ভাইকে আমাদের সঙ্গে না দেখলে আমাদের পিতার মারাই যাবেন আর দোষটা হবে আমাদেরই| তাহলে আমরা আমাদের বৃদ্ধ পিতাকে এই দুঃখের কারণে মেরে ফেলব| ");
INSERT INTO ben2006_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“এই ছোট ভাইয়ের দায়িত্ব আমিই নিয়েছিলাম| আমি পিতাকে বলেছিলাম, ‘আমি যদি তাকে তোমার কাছে ফিরিয়ে না আনি তবে সারাজীবন আমি অপরাধী হয়ে থাকব|’ ");
INSERT INTO ben2006_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","তাই এখন আমার এই ভিক্ষা, দয়া করে ছোট ভাইকে তার ভাইদের সঙ্গে ফিরতে দিন| আর আমি এখানে আপনার দাস হয়ে থাকি| ");
INSERT INTO ben2006_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ঐ ছোট ভাই না ফিরলে আমি পিতাকে মুখ দেখাতে পারবো না| ভেবে ভয় পাচ্ছি আমার পিতার কি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","যোষেফ আর নিজেকে সামলে রাখতে পারলেন না| তিনি সেখানে উপস্থিত সমস্ত লোকের সামনে কেঁদে উঠলেন এবং বললেন, “সবাইকে চলে যেতে বলো|” তাই সব লোক চলে গেল| কেবল যোষেফের ভাইরা সঙ্গে রইল| তখন যোষেফ নিজের পরিচয় দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","যোষেফ খুব উচ্চস্বরে কাঁদছিলেন, আর ফরৌণের বাড়ীর সমস্ত মিশরীয়রা তা শুনতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","যোষেফ তাঁর ভাইদের বললেন, “আমি তোমাদের ভাই যোষেফ| আমার পিতা ভাল আছেন তো?” কিন্তু ভাইরা উত্তর দিল না কারণ তারা হতবুদ্ধি হলেন, ভয় পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","তাই যোষেফ আবার তাঁর ভাইদের বললেন, “এখানে আমার কাছে এস| দয়া করে এখানে এস|” তাই ভাইরা যোষেফের কাছে গেল| যোষেফ তাদের বললেন, “আমি তোমাদের ভাই যোষেফ| আমিই সেই, যাকে তোমরা দাস হিসাবে মিশরের জন্য বেচে দিয়েছিলে| ");
INSERT INTO ben2006_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","এখন চিন্তা করো না| তোমরা যা করেছিলে তার জন্য রাগও করো না| ঈশ্বরের পরিকল্পনা অনুসারেই আমি এখানে এসেছি| আমি তোমাদের প্রাণ বাঁচাতেই এখানে এসেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","দুর্ভিক্ষের কেবল দুটো বছরই কেটেছে| এখনও আরও পাঁচ বছর কোন চাষ হবে না, ফসলও ফলবে না| ");
INSERT INTO ben2006_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","সুতরাং ঈশ্বর আমাকে তোমাদের আগেই এখানে পাঠিয়েছেন যাতে আমি তোমাদের লোকজনদের এই দেশে এনে বাঁচাতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","আমাকে যে এখানে পাঠানো হয়েছে তাতে তোমাদের দোষ নেই| এ ছিল ঈশ্বরের পরিকল্পনা| ঈশ্বরই আমাকে ফরৌণের পিতার স্থানে বসিয়েছেন| আমি তার সমস্ত বাড়ীর সমস্ত মিশর দেশের রাজ্যপাল হয়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","যোষেফ বলল, “তোমরা তাড়াতাড়ি আমার পিতার কাছে যাও| তাঁকে বল তার পুত্র যোষেফ এই বার্তা পাঠিয়েছে: ‘ঈশ্বর আমাকে মিশরের রাজ্যপাল করেছেন| তাই এখানে আমার কাছে চলে আসুন| দেরী করবেন না| এখনই চলে আসুন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","আপনি আমার কাছাকাছি গোশন প্রদেশে থাকতে পারেন| আপনি, আপনার সন্তানরা, আপনার নাতিনাতনিরা এবং আপনার সমস্ত পশুদেরও নিয়ে আসুন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","দুর্ভিক্ষের পরের পাঁচ বছর আমি আপনার যত্ন নেব| ফরে আপনি এবং আপনার পরিবারের যা আছে তার কিছুই হারিয়ে যাবে না|’ ");
INSERT INTO ben2006_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","যোষেফ তার ভাইদের বললেন, “আমি যে সত্যি সত্যিই যোষেফ তা তোমরা চোখেই দেখছ| এখন আমার ভাই বিন্যামীনও জানে যে আমি তোমাদের ভাই, তোমাদের সঙ্গে কথা বলছি| ");
INSERT INTO ben2006_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","আমি মিশর দেশে যে সম্মান অর্জন করেছি সে সম্বন্ধে পিতাকে বলো| এখানে তোমরা যা যা দেখছ সে সম্বন্ধে তাঁকে বলো| এবার ওঠ, যত তাড়াতাড়ি পার আমার পিতাকে এখানে নিয়ে এস|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","এরপর যোষেফ বিন্যামীনকে বুকে জড়িয়ে ধরে দুজনেই কাঁদতে লাগলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","যোষেফ অন্যান্য ভাইদেরও চুমু খেয়ে কাঁদলেন| এরপর ভাইরা তাঁর সঙ্গে কথা বলতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ফরৌণও জানতে পারলেন যে যোষেফের ভাইরা তাঁর কাছে এসেছে| এই খবর ফরৌণের সারা ঘরে ছড়িয়ে পড়লে ফরৌণ ও তাঁর দাসরা অত্যন্ত সন্তুষ্ট হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ফরৌণ যোষেফকে বললেন, “তোমার ভাইদের বল তাদের যে পরিমাণ শস্যের প্রয়োজন তা নিয়ে যেন কনান দেশে যায়| ");
INSERT INTO ben2006_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","আরও বল যেন তারা তাদের পিতা এবং তাদের পরিবারের সবাইকে নিয়ে আমার কাছে এইখানে ফিরে আসে| আমি তোমাদের বাস করার জন্য মিশরে সব চাইতে ভাল জমি দেব| আর তোমার পরিবার এখানকার সব চেয়ে ভাল খাবার খেতে পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","তারপর ফরৌণ বললেন, “আমাদের মালবাহী গাড়ীগুলোর মধ্যে যেগুলো ভালো তার কিছু তোমার ভাইদের দাও| তাদের বলো যেন, তারা কনান দেশে গিয়ে তাদের পিতা এবং নিজের নিজের স্ত্রী ও পুত্র কন্যা নিয়ে গাড়ী করে ফিরে আসে| ");
INSERT INTO ben2006_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","সেখান থেকে তাদের সমস্ত সম্পত্তি নিয়ে আসার ব্যাপারে তারা যেন চিন্তা না করে, কারণ মিশরের সমস্ত উত্তম জিনিস তাদের|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ইস্রায়েলের সন্তানরা তাই করলেন| ফরৌণ যেমন আদেশ করেছিলেন সেই মতন যোষেফ তাদের ভালো কিছু মালবাহী গাড়ী দিলেন আর যাত্রার জন্য যথেষ্ট খাবারও দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","যোষেফ তাঁর প্রত্যেক ভাইকে সুন্দর জামা জোড়াও দিলেন| কিন্তু যোষেফ বিন্যামীনকে দিলেন পাঁচ জোড়া জামা আর 300 রৌপ্য মুদ্রা। ");
INSERT INTO ben2006_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","যোষেফ তাঁর পিতার জন্যও উপহার পাঠালেন| তিনি দশটা গাধার পিঠে বস্তা ভরে মিশরের বহু উত্তম জিনিস পাঠালেন| আর তার পিতার ফেরবার পথে যাত্রার জন্য আরও দশটি স্ত্রী গাধার পিঠে করে শস্য, রুটি এবং অন্যান্য খাবার পাঠালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","তারপর যোষেফ তাঁর ভাইদের বিদায় দিলেন| আর তারা যখন পথে যাচ্ছে যোষেফ তাদের বললেন, “সোজা বাড়ী যাও| পথে ঝগড়া কর না|” ");
INSERT INTO ben2006_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","তাই তারা মিশর দেশ ছেড়ে তাদের পিতার কাছে কনান দেশে গিয়ে পৌঁছাল| ");
INSERT INTO ben2006_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ভাইরা বলল, “পিতা যোষেফ এখনও জীবিত! আর তিনিই সমস্ত মিশরের নিযুক্ত রাজ্যপাল|” তাদের পিতা এই শুনে হতবুদ্ধি হয়ে রইলেন; প্রথমে তো তাঁর বিশ্বাসই হল না| ");
INSERT INTO ben2006_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","কিন্তু তারপর তারা যোষেফ যা বলেছিলেন তা বলল| আর যোষেফ তাঁকে মিশর দেশে নিয়ে যাবার জন্য মালবাহী গাড়ীগুলো পাঠিযছিলেন তা যখন যাকোব দেখলেন, তখন তিনি আনন্দে উত্তেজিত হয়ে উঠলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ইস্রায়েল বললেন, “এবার আমি তোমাদের কথা বিশ্বাস করছি| আমার পুত্র যোষেফ এখনও বেঁচে আছে! আহা, মৃত্যুর আগে আমি তাকে দেখতে পাব!” ");
INSERT INTO ben2006_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ইস্রায়েল মিশর দেশের উদ্দেশ্যে যাত্রা শুরু করলেন| প্রথমে তিনি বের্-শেবাতে গেলেন| সেখানে ইস্রায়েল তাঁর পিতা ইসহাকের ঈশ্বরের উপাসনা করলেন এবং বলি দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","রাত্রে ঈশ্বর স্বপ্নে যাকোবের সঙ্গে কথা বললেন| ঈশ্বর বললেন, “যাকোব, যাকোব|” ইস্রায়েল উত্তর দিলেন, “এই যে আমি|” ");
INSERT INTO ben2006_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","তখন ঈশ্বর বললেন, “আমি ঈশ্বর, তোমার পিতার ঈশ্বর! মিশরে যেতে ভয় করো না| মিশরে আমি তোমাকে এক মহাজাতিতে পরিণত করব| ");
INSERT INTO ben2006_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","আমি তোমার সঙ্গে মিশরে যাব আর তোমাকে সেখান থেকে ফিরিয়ে আনব| তুমি মিশরে মারা যাবে কিন্তু যোষেফ তোমার সঙ্গে থাকবে| তুমি মারা গেলে যোষেফই তার নিজের হাত দিয়ে তোমার চোখ বুজিয়ে দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","তারপর যাকোব বের্-শেবা ছেড়ে মিশরের দিকে যাত্রা করলেন| ইস্রায়েলের পুত্ররা নিজেদের পিতা যাকোবকে এবং প্রত্যেকে নিজের পুত্র কন্যা ও স্ত্রীদের নিয়ে মিশরে চললেন| ফরৌণ যে মালবাহী গাড়ীগুলো পাঠিয়েছিলেন সেইগুলো করেই তাঁরা গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","তাঁরা তাঁদের পশুপাল এবং কনান দেশে তাদের যা যা ছিল সব নিয়ে চললেন| সুতরাং ইস্রায়েল মিশরে তার সমস্ত সন্তান এবং তাদের পরিবার নিয়েই গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","তাঁর সঙ্গে ছিল তাঁর পুত্ররা এবং নাতিরা, তাঁর কন্যারা এবং নাতনিরা| সুতরাং তাঁর সমস্ত পরিবার তাঁর সাথে মিশরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ইস্রায়েলের পুত্ররা এবং তার বংশধররা যারা তাঁর সঙ্গে মিশরে গিয়েছিলেন তাদের নামগুলি এই: বূবেণ ছিলেন জ্যেষ্ঠ পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","রূবেণের পুত্ররা ছিলেন হনোক, পল্লু, হিষ্রোণ ও কর্মি| ");
INSERT INTO ben2006_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","শিমিয়োনের পুত্ররা ছিলেন যিমূয়েল, যামীন, ওহদ, যাখীন, সোহর আর এছাড়া শৌল| (শৌলের মা ছিলেন একজন কনানীয় স্ত্রীলোক|) ");
INSERT INTO ben2006_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লেবীর পুত্ররা ছিলেন গের্শোন, কহাত্‌ ও মরারি| ");
INSERT INTO ben2006_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","যিহূদার পুত্ররা হলেন এর, ওনন, শেলা, পেরস ও সেরহ| (এর ও ওনন কনান দেশেই মারা গিয়েছিল|) পেরসের পুত্ররা হলেন হিষ্রোণ ও হামূল| ");
INSERT INTO ben2006_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইষাখরের পুত্ররা হলেন তোলয়, পুয, যোব ও শিম্রোণ| ");
INSERT INTO ben2006_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","সবূলূনের পুত্ররা হলেন সেরদ, এলোন ও যহলোল| ");
INSERT INTO ben2006_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","রূবেণ, শিমিয়োন, লেবি, যিহূদা, ইষাখর ও সবূলূন ছিলেন যাকোব ও লেয়ার সন্তানগণ| পদ্দম্-অরামে লেয়ার এই সন্তানরা জন্মেছিল| তার দীনা নামে একটি কন্যাও ছিল| তার পরিবারে মোট সদস্য সংখ্যা ছিল 33 জন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","গাদের পুত্ররা ছিলেন সিফিযোন, হগি, শূনী, ইষ্বোন, এরি, অরোদী ও অরেলী| ");
INSERT INTO ben2006_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আশেরের পুত্ররা ছিলেন যিন্না, যিশ্বা, যিশবি, বরিয় এবং তাদের বোন সেরহ| বরিয়ের পুত্ররা অর্থাৎ‌ হেবর ও মল্কীয়েলও ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","যাকোবের এই পুত্ররা ছিলেন তাঁর স্ত্রী দাসী সিল্পার| (সিল্পাই সেই দাসী যাকে লাবন তাঁর কন্যা লেয়ার সাথে দিয়েছিলেন|) তাঁর পরিবারের মোট সদস্য ছিলেন 16 জন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","বিন্যামীনও যাকোবের সঙ্গে ছিলেন| বিন্যামীন ছিলেন যাকোব ও রাহেলের পুত্র| (যোষেফও রাহেলের পুত্র| কিন্তু যোষেফ ইতিমধ্যে মিশরে ছিলেন|) ");
INSERT INTO ben2006_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","মিশরে যোষেফের দুই পুত্র হয়| তাদের নাম মনঃশি ও ইফ্রয়িম| (যোষেফের স্ত্রীর নাম ছিল আসনত্‌| তিনি ছিলেন ওন শহরের যাজক পোটীফরের কন্যা|) ");
INSERT INTO ben2006_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিন্যামীনের পুত্ররা হল বেলা, বেখর, অস্বেল, গেরা, নামন, এহী, রোশ, মুপ্পীম, হুপ্পীম ও অর্দ| ");
INSERT INTO ben2006_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","এনারা ছিলেন যাকোব ও তার স্ত্রী রাহেলের সন্তান| পরিবারের মোট সদস্য সংখ্যা 14 জন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","দানের পুত্র ছিলেন হূশীম| ");
INSERT INTO ben2006_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নপ্তালির পুত্র ছিলেন যহসিয়েল, গূনি, বেৎসর ও শিল্লেম| ");
INSERT INTO ben2006_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","এঁরা ছিলেন যাকোব ও বিল্হার সন্তান| (বিল্হা-ই সেই দাসী যাকে লাবন তার কন্যা রাহেলের সাথে পাঠিয়েছিলেন|) এই পরিবারের মোট সদস্য সংখ্যা ছিল সাত| ");
INSERT INTO ben2006_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","সরাসরি যাকোব হতে উৎপন্ন উত্তরপুরুষদের মোট 66জন তার সঙ্গে মিশরে গিয়েছিলেন| (এই সংখ্যার মধ্যে যাকোবের পুত্রদের স্ত্রীদের গণনা করা হয় নি|) ");
INSERT INTO ben2006_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","আবার যোষেফেরও দুই সন্তান ছিলেন যাঁরা মিশরে জন্মেছিলেন| সুতরাং মিশরে যাকোবের পরিবারের মোট সদস্য সংখ্যা হল 70 জন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","যোষেফের সঙ্গে কথা বলার জন্য যাকোব যিহূদাকে তাঁর আগে পাঠালেন| এর পরে যাকোব এবং তাঁর পুত্ররা গোশন প্রদেশে পৌঁছোলেন| যিহূদা গোশন প্রদেশে যোষেফের সঙ্গে কথা বলতে গেলেন| যাকোব এবং তাঁর পরিবারের লোকজন এরপর সেই প্রদেশে পৌঁছালেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","যোষেফ যখন শুনলেন যে তাঁর পিতা আসছেন তখন তিনি রথ প্রস্তুত করে গোশন প্রদেশে তাঁর পিতা ইস্রায়েলের সঙ্গে দেখা করতে গেলেন| য়েষেফ তাঁর পিতাকে দেখে গলা জড়িয়ে ধরে বহুক্ষণ কাঁদলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","তখন ইস্রায়েল যোষেফকে বললেন, “এখন আমি শান্তিতে মরতে পারব| আমি তোমার মুখ দেখলাম এবং জানলাম যে তুমি এখনও জীবিত|” ");
INSERT INTO ben2006_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","যোষেফ তাঁর ভাইদের এবং পিতার পরিবারের বাকীদের বললেন, “আমি ফরৌণকে বলতে যাচ্ছি যে তোমরা এখানে এসেছ| আমি ফরৌণকে বলব, ‘আমার ভাইরা এবং পিতার পরিবারের বাকী সবাই কনান দেশ ছেড়ে এখানে আমার কাছে এসেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","পরিবারের সবাই মেষপালক| তারা বরাবরই মেষপাল ও গো-পাল রেখে থাকেন| তারা তাদের পশু ও আর যা কিছু তাদের ছিল সবই তাদের সঙ্গে নিয়ে এসেছেন|’ ");
INSERT INTO ben2006_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ফরৌণ তোমাদের ডাকলে জিজ্ঞেস করবে, ‘তোমরা কি কাজ কর?’ ");
INSERT INTO ben2006_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","তোমরা তাকে বলবে, ‘আমরা মেষপালক| সারাজীবন ধরেই আমরা মেষ পালন করে আসছি| আমাদের আগে আমাদের পূর্বপুরুষরা মেষপালক ছিলেন|’ ফরৌণ তোমাদের গোশন প্রদেশে থাকতে দেবেন| মিশরীয়রা মেষপালকদের পছন্দ করেন না, সেইজন্য তোমাদের গোশন প্রদেশে থাকাটাই ভাল হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","যোষেফ ফরৌণের কাছে গিয়ে বললেন, “আমার পিতা, আমার ভাইরা এবং তাঁদের পরিবারের সবাই এখানে এসেছেন| তাঁরা তাদের পশু ও সর্বস্ব নিয়ে কনান দেশ থেকে চলে এসেছেন| তাঁরা এখন গোশন প্রদেশে রয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ফরৌণের সামনে যাবার জন্য ভাইদের মধ্যে পাঁচজনকে মনোনীত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ফরৌণ ভাইদের জিজ্ঞেস করলেন, “তোমরা কি কাজ কর?” ভাইরা ফরৌণকে বলল, “মহাশয় আমরা মেষপালক| আর আমাদের আগে আমাদের পূর্বপুরুষরাও মেষপালক ছিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","তারা ফরৌণকে বলল, “কনান দেশে ভয়াবহ দুর্ভিক্ষ হয়েছে| তাই পশুদের খাবার ঘাসের অভাব হয়েছে| তাই আমরা এই দেশে বাস করব বলে এখানে এসেছি| দয়া করে আমাদের গোশন প্রদেশে থাকতে দিন|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","তখন ফরৌণ যোষেফকে বললেন, “তোমার পিতা ও তোমার ভাইরা তোমার কাছে এসেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","তাদের থাকবার জন্য তুমি মিশরে যে কোন জায়গা বেছে নিতে পারো| তোমার পিতা এবং তোমার ভাইদের সব চাইতে ভাল জমিটা দিও| তাদের গোশন প্রদেশে বাস করতে দাও| আর তারা যদি দক্ষ মেষপালক হয় তবে তারা আমার পশুপালেরও যত্ন নিতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","তখন যোষেফ তাঁর পিতাকে ফরৌণের সঙ্গে দেখা করবার জন্য ডেকে আনলেন| যাকোব ফরৌণকে আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ফরৌণ তাঁকে জিজ্ঞাসা করলেন, “আপনার বয়স কত?” ");
INSERT INTO ben2006_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","যাকোব ফরৌণকে বললেন, “আমার আয়ুর এই অল্প বয়সে আমাকে অনেক সমস্যার সম্মুখীন হতে হয়েছে| আমি কেবল 130 বছর বয়স্ক| আমার পিতা এবং আমার পূর্বপুরুষরা আমার চাইতেও বেশী বয়স বেঁচেছিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","যাকোব ফরৌণকে আশীর্বাদ করলেন এবং তাঁর সামনে থেকে বিদায় নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ফরৌণের কথামত যোষেফ তাঁর পিতা ও ভাইদের মিশরে জমিজমা দিলেন| রামিষেষ শহরের কাছে স্থিত সেই জমি মিশরের সব জমির চেয়ে সেরা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","আর যোষেফ তাঁর পিতা, তাঁর ভাইদের এবং তাঁর সমস্ত পরিজনদের তাঁদের প্রয়োজনীয় খাদ্য সরবরাহ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","দুর্ভিক্ষ আরও ভয়াবহ হয়ে উঠল| ফলে দেশে কোথাও কোন খাদ্য রইল না| এই দরুণ দুর্ভিক্ষের জন্যে মিশর এবং কনান দেশ দরিদ্র হয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","দেশের লোকরা আরও শস্য কিনতে থাকল আর যোষেফ সেই অর্থ জমিয়ে ফরৌণের কাছে নিয়ে আসতেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","কিছু পরে মিশরীয় এবং কনানীয়দের সব অর্থ শেষ হয়ে গেল| কারণ তারা সমস্ত অর্থই শস্য কিনতে ব্যয করেছিল| তাই মিশরীয়রা যোষেফের কাছে গিয়ে বলল, “আমাদের খাদ্য দিন| আমাদের অর্থ শেষ হয়ে গেছে| আমরা খেতে না পেলে আপনার চোখের সামনে মারা যাব|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","কিন্তু যোষেফ উত্তর দিলেন, “তোমাদের গো-পাল দাও, আমি তোমাদের খাবার দেব|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","এইভাবে খাদ্য কেনার জন্য লোকরা তাদের গো-পাল, ঘোড়া এবং অন্যান্য পশুর ব্যবহার করলেন| সেই বছরে যোষেফ পশুর বদলে তাদের খাদ্য দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","কিন্তু পরের বছরে লোকদের খাবার কেনার জন্য পশু এবং অন্য কিছু ছিল না| তাই লোকরা যোষেফের কাছে গিয়ে বলল, “আপনি জানেন আমাদের কাছে আর কোন অর্থ নেই| আর আমাদের সব পশুও এখন আপনারই| সুতরাং আপনি যা দেখছেন আমাদের সেই দেহ ও আমাদের জমি ছাড়া আমাদের কাছে আর কিছুই নেই| ");
INSERT INTO ben2006_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","সত্যিই আমরা আপনার চোখের সামনে মারা যাব| কিন্তু আপনি আমাদের খাদ্য দিলে আমরা ফরৌণকে আমাদের জমি দেব এবং আমরা তাঁর দাস হব| আমাদের বপন করার বীজ দিন| তাহলে আমরা মরব না| আর জমিতে আবার আমাদের জন্য শস্য হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","তাই যোষেফ মিশরের সমস্ত জমি ফরৌণের জন্য কিনে নিলেন| লোকরা ক্ষুধার জন্য মিশরের সমস্ত জমি ফরৌণের কাছে বিক্রি করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","আর মিশরের সর্বত্র লোকরা ফরৌণের দাস হল| ");
INSERT INTO ben2006_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","যোষেফ কেবল যাজকদের জমি কিনলেন না| যাজকদের জমি বিক্রি করারও প্রয়োজন ছিল না| কারণ ফরৌণ তাদের কাজের জন্য পারিশ্রমিক দিতেন আর তারা সেই অর্থ দিয়ে খাদ্য কিনত| ");
INSERT INTO ben2006_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","যোষেফ লোকদের বললেন, “এখন আমি তোমাদের এবং তোমাদের জমি ফরৌণের জন্য কিনে নিয়েছি| তাই আমি এরপর তোমাদের জমিতে বপন করার বীজ দেব| আর তোমরা তা বপন করতে পার| ");
INSERT INTO ben2006_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","শস্য ছেদনের সময় তোমরা অবশ্যই উৎপন্ন শস্যের পাঁচ ভাগের এক ভাগ ফরৌণকে দেবে| বাকী পাঁচ ভাগের চার ভাগ শস্য তোমাদের হবে| তোমরা তোমাদের খাদ্যের জন্য সেই রাখা শস্যের বীজ পরের বছর বপন করার জন্য ব্যবহার করতে পারবে| আর তাতে তোমাদের পরিবার ও সন্তানদের জন্যও খাদ্য থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","লোকরা বলল, “আপনি আমাদের প্রাণ বাঁচিয়েছেন| আমরা ফরৌণের দাস হয়ে খুশী|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","তাই যোষেফ সেই সময় জমির ব্যাপারে আইন তৈরী করলেন| আর সেই আইন আজও বলবৎ রয়েছে| সেই আইন অনুযায়ী জমিতে উৎপন্ন সবকিছুর পাঁচ ভাগের এক ভাগ ফরৌণের| যাজকদের জমি ছাড়া সমস্ত জমি ফরৌণের| ");
INSERT INTO ben2006_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ইস্রায়েল মিশরের গোশন প্রদেশেই স্থায়ী হলেন| তাঁর পরিবার সংখ্যায় বৃদ্ধি পেল এবং বিশাল হয়ে উঠল| মিশর দেশে তাঁরা কিছু জমি পেলেন এবং সফল হলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","যাকোব মিশরে 17 বছর বেঁচে ছিলেন সুতরাং তাঁর বয়স হল 147 বছর| ");
INSERT INTO ben2006_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","সময় হল যখন ইস্রায়েল বুঝলেন যে তিনি শীঘ্রই মারা যাবেন| তাই তিনি তাঁর পুত্র যোষেফকে নিজের কাছে ডাকলেন| তিনি বললেন, “যদি তুমি আমায় ভালবাস তবে আমার উরুর নীচে হাত রাখ এবং প্রতিজ্ঞা কর যে তুমি তোমার কথায় বিশ্বস্ত হবে| আমি মারা গেলে আমায় মিশরে কবর দিও না| ");
INSERT INTO ben2006_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","যে জায়গায় আমার পূর্বপুরুষদের কবর দেওয়া হয়েছে সেখানেই আমায় কবর দিও| আমাকে মিশর থেকে বয়ে নিয়ে গিয়ে আমাদের পারিবারিক কবরে কবর দিও|” যোষেফ উত্তর দিলেন, “আমি প্রতিজ্ঞা করছি আপনার কথা মতোই কাজ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","তারপর যাকোব বললেন, “আমার কাছে দিব্য কর|” তখন ইস্রায়েল বিছানায় তার মাথা নামিয়ে ঈশ্বরের উপাসনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","কিছু সময় পরে যোষেফ জানতে পারলেন যে তাঁর পিতা খুব অসুস্থ| তাই যোষেফ তাঁর দুই পুত্র মনঃশি ও ইফ্রয়িমকে নিয়ে তাঁর পিতার কাছে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","যোষেফ সেখানে পৌঁছালে ইস্রায়েলকে কেউ খবর দিলেন, “আপনার পুত্র যোষেফ আপনাকে দেখতে এসেছেন|” ইস্রায়েল খুব দুর্বল হয়ে পড়েছিলেন, কিন্তু তিনি খুব চেষ্টা করে কোন মতে বিছানায় উঠে বসলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","তখন ইস্রায়েল যোষেফকে বললেন, “কনান দেশের লূস নামক জায়গায় সর্বশক্তিমান ঈশ্বর আমার সামনে আবির্ভূত হয়েছিলেন| সেখানে ঈশ্বর আমায় আশীর্বাদ করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ঈশ্বর আমায় বলেছিলেন, ‘আমি তোমাকে বহু বংশ করব| তোমার অনেক সন্তানসন্ততি হবে এবং তারা মহান হবে| এই দেশ তোমার বংশধররা চিরকালের জন্য তাদের অধিকারে রাখবে|’ ");
INSERT INTO ben2006_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","আর এখন তোমার দুই পুত্র, আমার আসার আগেই মিশর দেশে এদের জন্ম হয়েছিল| তোমার দুই পুত্র মনঃশি ও ইফ্রয়িম আমার কাছে নিজের পুত্রের মতই হোক্| তারা আমার কাছে রূবেণ ও শিমিয়োনের মত হোক্| ");
INSERT INTO ben2006_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","সুতরাং ঐ দুই জন পুত্র আমারই হোক্| তারা আমার সব কিছুর অংশীদার হবে| কিন্তু এছাড়া তোমার যদি আর অন্য পুত্র থাকে তবে তা তোমারই হোক্| আর তারা ইফ্রয়িম ও মনঃশির কাছে সন্তানের মতই হোক্ অর্থাৎ‌ ভবিষ্যতে তারা ইফ্রয়িম ও মনঃশির অধিকারভুক্ত সব কিছুরই অংশীদার হবে| ");
INSERT INTO ben2006_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","পদ্দম্-অরাম থেকে আসার সময় রাহেল মারা গেলেন| এই ঘটনায় আমি অত্যন্ত দুঃখ পেলাম| আমরা যখন ইফ্রাথের দিকে যাচ্ছিলাম তখন কনান দেশে তিনি মারা গেলেন| আমি তাকে সেখানে ইফ্রাথ যাবার পথের ধারে কবর দিলাম|” (ইফ্রাথ বৈৎ‌লেহেমের অপর নাম|) ");
INSERT INTO ben2006_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","তখন ইস্রায়েল যোষেফের পুত্রদের দেখে জিজ্ঞাসা করলেন, “এই বালকরা কারা?” ");
INSERT INTO ben2006_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","যোষেফ তাঁর পিতাকে বললেন, “এরা আমার পুত্ররা, ঈশ্বরই এদের আমায় দিয়েছেন|” ইস্রায়েল বললেন, “তোমার ছেলেদের আমার কাছে নিয়ে এস| আমি তাদের আশীর্বাদ করব|” ");
INSERT INTO ben2006_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ইস্রায়েল বৃদ্ধ হয়েছিলেন এবং চোখেও ভালো দেখতে পেতেন না| তাই যোষেফ দুই পুত্রকে পিতার খুব কাছে নিয়ে এলেন| ইস্রায়েল তাদের গলা জড়িয়ে চুমু খেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","তারপর ইস্রায়েল যোষেফকে বললেন, “আমি ভাবতেই পারি নি যে কখনও তোমার মুখ দেখতে পাব| কিন্তু দেখ ঈশ্বর আমাকে, তোমার এমনকি তোমার পুত্রদেরও দেখতে দিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","তারপর যোষেফ ইস্রায়েলের কোল থেকে তার পুত্রদের নিলেন এবং তারা ইস্রায়েলের সামনে মাথা নত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","যোষেফ ইফ্রয়িমকে তাঁর ডানদিকে এবং মনঃশিকে তার বাঁ দিকে রাখলেন| (সুতরাং ইফ্রয়িম ইস্রায়েলের বাম দিকে ও মনঃশি তার ডান দিকে রইল|) ");
INSERT INTO ben2006_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","কিন্তু ইস্রায়েল তাঁর হাত আড়াআড়ি ভাবে রেখে তাঁর ডান হাত ছোট পুত্র ইফ্রয়িমের মাথায় রাখলেন| ইস্রায়েল তাঁর বাম হাত বড় পুত্র মনঃশির মাথায় রাখলেন| মনঃশি প্রথমজাত হলেও তিনি বাম হাত তার উপরে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ইস্রায়েল যোষেফকে আশীর্বাদ করে বললেন, “আমার পূর্বপুরুষ অব্রাহাম ও ইসহাক আমাদের ঈশ্বরের উপাসনা করতেন| আর সেই ঈশ্বরই সারা জীবন আমায় বহন করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","তিনিই সেই দেবদূত যিনি আমায় সব সমস্যা থেকে রক্ষা করেছেন| আমার প্রার্থনা, তিনিই এই পুত্রদের আশীর্বাদ করবেন| এখন এই পুত্ররা আমার এবং আমার পূর্বপুরুষ অব্রাহাম ও ইসহাকের নামে আখ্যাত হোক্| আমার প্রার্থনা তারা যেন পৃথিবীতে বৃদ্ধি পযে বহু বংশ ও বহু জাতি হয়|” ");
INSERT INTO ben2006_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","যোষেফ যখন দেখলেন তাঁর পিতা ডান হাত ইফ্রয়িমের মাথায় রেখেছেন, তখন তিনি খুশী হলেন না| যোষেফ পিতার হাত ইফ্রয়িমের মাথা থেকে তুলে ধরে মনঃশির মাথায় রাখতে চাইলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","যোষেফ তাঁর পিতাকে বললেন, “আপনি আপনার ডান হাত ভুল জনের মাথার উপর রেখেছেন| মনঃশিই প্রথমজাত| তার উপরেই ডান হাত রাখুন|” ");
INSERT INTO ben2006_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","কিন্তু তাঁর পিতা তর্ক করে বললেন, “আমি জানি বৎস, আমি জানি| মনঃশি প্রথমজাত সে মহান হবে, বহুলোকের পিতা হবে কিন্তু ছোট জন বড় জনের চেয়েও মহান হবে আর তার বংশ আরও অনেক হবে|” ");
INSERT INTO ben2006_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","তাই ইস্রায়েল সেই দিন এই বলে আশীর্বাদ করলেন, “ইস্রায়েল কাউকে আশীর্বাদ করতে তোমাদেরই নাম ব্যবহার করবে| তারা বলবে, ‘ঈশ্বর তোমাকে যেন মনঃশি ও ইফ্রয়িমের মতো করেন|’” এইভাবে ইস্রায়েল মনঃশির চাইতে ইফ্রয়িমকে বড় করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","তারপর ইস্রায়েল যোষেফকে বললেন, “দেখ আমার মৃত্যুর সময় কাছে এসে গেছে| কিন্তু ঈশ্বর তোমার সঙ্গে থাকবেন| তিনিই তোমাকে আবার তোমার পূর্বপুরুষদের দেশে নিয়ে যাবেন| ");
INSERT INTO ben2006_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","আমি তোমাকে যা দিলাম তা তোমার ভাইদের দিই নি| ইমোরীয়দের হাত থেকে যে পাহাড় আমি জয় করে নিয়েছিলাম তা তোমায় দিচ্ছি| আমি সেই পাহাড় জয় করতে আমার তরবারি ও ধনুক ব্যবহার করেছিলাম এবং আমি জয়ী হয়েছিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","এরপর যাকোব তাঁর পুত্রদের তাঁর কাছে ডাকলেন এবং বললেন, “আমার বাছারা এখানে আমার কাছে এস| ভবিষ্যতে কি ঘটবে তা আমি তোমাদের বলছি| ");
INSERT INTO ben2006_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“যাকোবের পুত্ররা এস, একসাথে এসে শোন তোমাদের পিতা ইস্রায়েল কি বলছেন| ");
INSERT INTO ben2006_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“রূবেণ আমার প্রথম জাত, তুমিই তো আমার প্রথম সন্তান, পুরুষ হিসাবে আমার শক্তির প্রথম প্রমাণ| তুমি আমার সন্তানদের মধ্যে সবচেয়ে সম্মানিত এবং শক্তিমান| ");
INSERT INTO ben2006_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","কিন্তু বন্যার মত তোমার কামেচ্ছা, তুমি তা দমন করো নি| সেইজন্য তুমি সম্মানিত সন্তান হিসাবে তোমার প্রাধান্য হারাবে| তুমি তোমার পিতার শয্যায় উঠেছিলে আর তার এক স্ত্রীর সাথে শুয়েছিলে| তুমি সেই শয্যায় ঘুমিয়েছ এবং সেই শয্যাকে অপবিত্র করেছ| ");
INSERT INTO ben2006_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“শিমিয়োন ও লেবি ভাই ভাই| তারা যোদ্ধা এবং তারা তাদের তরবারি নিয়ে যুদ্ধ করতে ভালবাসে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","তারা গোপনে মন্দ বিষয় পরিকল্পনা করল| আমার আত্মা তাদের পরিকল্পনার অংশ নেবে না| তাদের গোপন সত্য আমি স্বীকার করব না| তারা রাগে মানুষ হত্যা করল| কেবল ঠাট্টা করতে পশুদের আঘাত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","তাদের রাগ এক অভিশাপ, কারণ তা প্রচণ্ড| উন্মৎত হয়ে উঠলে তারা নিষ্ঠুরতায় পূর্ণ হয়| তারা যাকোবের দেশে তাদের অংশ পাবে না| তারা সমস্ত ইস্রায়েলে ছড়িয়ে পড়বে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“যিহূদা তোমার ভাইরা তোমার প্রশংসা করবে| তুমি তোমার শত্রুদের পরাজিত করবে| তোমার ভাইরা তোমার কাছে জানু পাতবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","আমার বাছা, তুমি শিকারের ওপর দাঁড়িয়ে থাকা সিংহের মতো| সে বিশ্রাম করলে তাকে বিরক্ত করার সাহস কার আছে? ");
INSERT INTO ben2006_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","যিহূদার বংশ থেকেই রাজারা উঠবে| তার বংশ যে শাসন করবে এই চিহ্ন প্রকৃত রাজা না আসা পর্যন্ত রইবে| পরে বহু লোক বাধ্য হয়ে তার সেবা করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","সে দ্রাক্ষালতা দিয়ে তার গাধা বাঁধবে| গাধার শাবককে উত্তম দ্রাক্ষালতায়় বাঁধবে| উত্তম দ্রাক্ষারসে নিজের বস্ত্র ধৌত করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","তার চোখ দ্রাক্ষারস পান করে লাল, তার দাঁত দুধ পান করে সাদা| ");
INSERT INTO ben2006_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“সবূলূন সমুদ্রের কাছে বাস করবে| তার সমুদ্রোপকুল জাহাজের পক্ষে হবে নিরাপদ| সীদোন পর্যন্ত বিস্তৃত হবে তার দেশ| ");
INSERT INTO ben2006_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ইষাখর খচ্চরের মত কঠিন পরিশ্রম করেছে| ভারী বোঝা বহন করার পর সে বিশ্রাম করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","সে দেখবে তার বিশ্রাম স্থান উত্তম| তার দেশ হবে মনোহর| তখন সে ভারী বোঝা বইতে সম্মত হবে| দান হিসাবে কাজ করতে সম্মতি জানাবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“দান ইস্রায়েলের অন্য বংশের মতোই নিজের প্রজাদের বিচার করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","দান হবে পথের ধারের সাপের মতো| সে পথে শুয়ে থাকা বিষধর সাপের মতই হবে| সেই সাপ, যে ঘোড়ার পায়ে দংশন করে চালককে মাটিতে ফেলে দেয়| ");
INSERT INTO ben2006_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“হে প্রভু, আমি তোমার পরিত্রাণের অপেক্ষা করছি| ");
INSERT INTO ben2006_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“এক দল দস্যু গাদকে আক্রমণ করবে| কিন্তু গাদ তাদের পিছনে তাড়া করবে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“আশেরের দেশে উত্তম খাদ্য উৎপন্ন হবে| রাজার উপযুক্ত খাদ্যই সে যোগাবে! ");
INSERT INTO ben2006_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“নপ্তালি মুক্ত হরিণীর মতো, আর তার বাক্য তাদের সুন্দর শিশুর মতো| ");
INSERT INTO ben2006_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“যোষেফ কৃতকার্য হয়েছে| সে ফলে ঢাকা লতার মতো, বসন্তে বেড়ে ওঠা শাখার মতো| বেড়ার গায়ে বেড়ে ওঠা লতার মতো| ");
INSERT INTO ben2006_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","অনেক লোক তার বিরোধিতা করেছে এবং তার সঙ্গে যুদ্ধ করেছে| ধনুকধারীরা তার শত্রু হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","কিন্তু সে তার পরাক্রমী ধনু ও দক্ষ বাহুর সাহায্যে যুদ্ধ জয় করেছে| সে ক্ষমতা পায় যাকোবের এক বীরের কাছ থেকে, এক মেষপালকের কাছ থেকে যে ইস্রায়েলের পর্বত স্বরূপ, মেষপালক অর্থাৎ‌ ইস্রায়েলের শৈলের কাছে| ");
INSERT INTO ben2006_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","তোমার পিতার ঈশ্বরের কাছ থেকে ঈশ্বর তোমায় আশীর্বাদ করুন| “সর্বশক্তিমান ঈশ্বর তোমায় আশীর্বাদ করুন, উপরের আকাশ হতে আশীর্বাদ বর্ষান, আর গভীর জল থেকেও আশীর্বাদ করুন| তিনি তোমাকে স্তন ও গর্ভ হতেও আশীর্বাদ করুন| ");
INSERT INTO ben2006_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","আমার পূর্বপুরুষরা অনেক আশীর্বাদ ভোগ করেছেন| কিন্তু তোমার পিতা আমি আরও বেশী আশীর্বাদ পেয়েছি| তোমার ভাইরা তোমায় সবকিছু থেকে বঞ্চিত করল; কিন্তু এখন আমি পর্বতের সমান উঁচু আশীর্বাদ তোমার মাথায় রাশিকৃত করলাম| ");
INSERT INTO ben2006_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“বিন্যামীন ক্ষুধার্ত নেকড়ে| সকালে সে শিকার করে খেতে বসে| বিকালে যা পড়ে থাকে তা ভাগ করে নেয়|” ");
INSERT INTO ben2006_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","এই হল ইস্রায়েলের বারো বংশ| আর এই কথাগুলো তাদের পিতা তাদের বলেছিলেন| তিনি প্রত্যেকটি সন্তানকে তাদের উপযুক্ত আশীর্বাদে আশীর্বাদ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","তারপর ইস্রায়েল তাদের এই নির্দেশ দিয়ে বললেন, “মৃত্যুর পর আমি চাই আমার লোকদের সঙ্গে পুনর্মিলিত হতে, সুতরাং হেতীয় ইফ্রোণের ক্ষেতে যে গুহা আছে সেখানে আমার পিতৃপুরুষদের সেই গুহায় আমায় কবর দিও| ");
INSERT INTO ben2006_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","সেই কবর কনান দেশে মম্রির কাছে মক্পেলা ক্ষেতে রয়েছে। সেই ক্ষেত অব্রাহাম ইফ্রোনের কাছ থেকে কিনেছিলেন যেন কবর দিতে পারেন| ");
INSERT INTO ben2006_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","অব্রাহাম ও তার স্ত্রী সারাও সেই কবরে সমাহিত হয়েছিলেন| ইসহাক ও তার স্ত্রী রিবিকাকেও সেই কবরে সমাহিত করা হয়েছিল| আমি আমার স্ত্রী লেয়াকেও সেখানে সমাহিত করেছি| ");
INSERT INTO ben2006_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","সেই গুহা হেতীয়়দের কাছ থেকে কেনা সেই ক্ষেতের মধ্যে রয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","যাকোব তার পুত্রদের সঙ্গে কথা বলা শেষ করে শুয়ে পড়লেন| বিছানায় পা উঠিয়ে রাখলেন, তারপর মারা গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ইস্রায়েল মারা গেলে যোষেফ অত্যন্ত দুঃখিত হলেন| তিনি কাঁদলেন এবং তাঁর পিতাকে জড়িয়ে ধরে চুমু খেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","যোষেফ তাঁর ভৃত্যদের পিতার দেহ প্রস্তুত করতে বললেন| (এই ভৃত্যরা চিকিৎসক ছিল|) চিকিৎসকেরা মিশরীয়রা যে বিশেষভাবে দেহ প্রস্তুত করে সেইভাবে যাকোবের দেহ কবর দেবার জন্য প্রস্তুত করল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","দেহ বিশেষভাবে প্রস্তুত করার সময় কবর দেবার আগে তারা 40 দিন পর্যন্ত অপেক্ষা করল| তারপর 70 দিন ধরে মিশরীয়রা যাকোবের জন্য শোক পালন করল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","শোকের 70 দিন শেষ হলে যোষেফ ফরৌণের আধিকারিকদের বললেন, “ফরৌণকে দয়া করে এই কথা বলুন: ");
INSERT INTO ben2006_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘আমার পিতা যখন মৃত্যুশয্যায় ছিলেন তখন আমি তাঁর কাছে প্রতিজ্ঞা করেছিলাম যে তাঁকে কনান দেশে এক গুহায় সমাহিত করব| এই গুহা তিনি নিজের জন্য প্রস্তুত করেছিলেন| তাই দয়া করে আমার পিতাকে কবর দিতে দিন| তারপর আমি আবার আপনার কাছে আসব|’” ");
INSERT INTO ben2006_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ফরৌণ বললেন, “তোমার প্রতিজ্ঞা পালন কর| যাও তোমার পিতাকে কবর দাও|” ");
INSERT INTO ben2006_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","তাই যোষেফ তাঁর পিতাকে সমাহিত করতে চললেন| ফরৌণের সমস্ত আধিকারিক, ফরৌণের নেতারা এবং মিশরের প্রবীণরা যোষেফের সাথে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","যোষেফের পরিবারের সবাই, তাঁর ভাইরা ও তাঁর পিতার পরিবারের সবাই, তাঁর সঙ্গে গেলেন| গোশন প্রদেশে কেবল তাদের সন্তানসন্ততি ও পশুরা থেকে গেল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","সেই এক বিরাট দল হল। এমনকি এক দল সৈনিকও রথে ও ঘোড়ায় চড়ে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","তারা যর্দন নদীর পূর্বদিকে গোরেন আটদের খামারে এলেন| এই স্থানে তারা ইস্রায়েলের জন্য দীর্ঘ সময় ধরে শোক সভা করলেন| সেই শোক সভা সাত দিন ধরে চলল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","কনান দেশের লোকরা গোরেন আটদের সেই অন্ত্যেষ্টি ক্রিয়া দেখে বললেন, “মিশরীয়দের এ দারুণ বিষাদময় শোকের অনুষ্ঠান!” সেইজন্য যর্দ্দন নদীর পারের সেই জায়গার নাম হল আবেল্-মিস্রযীম| ");
INSERT INTO ben2006_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","সুতরাং যাকোবের পুত্ররা তাদের পিতার কথানুসারে কাজ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","তারা তাঁর দেহ কনান দেশে বহন করে এনে মক্পেলার গুহাতে কবর দিল| অব্রাহাম হেতীয়় ইক্রোণের কাছ থেকে মম্রির কাছে যে ক্ষেত কিনেছিলেন এই কবর সেখানেই ছিল| অব্রাহাম কবর দেবার জন্যই এটা কিনেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","যোষেফ তাঁর পিতাকে কবর দেবার পর তাঁর দলের সবাই মিশরে ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","যাকোব মারা গেলে যোষেফের ভাইরা দুঃশ্চিন্তাগ্রস্ত হল| তারা এই ভেবে ভীত হল যে বহু বছর আগে তারা যোষেফের প্রতি যা করেছিল, যোষেফ হয়তো তার প্রতিফল দেবেন| তারা বলল, “হয়তো যোষেফ এখনও আমরা যা করেছিলাম তার জন্য আমাদের ঘৃণা করেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","এইজন্য ভাইরা যোষেফকে এই বলে পাঠাল: “পিতা মারা যাবার আগে আপনাকে এই বার্তা দিতে বলেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","তিনি বললেন, ‘যোষেফকে আমার এই অনুরোধ, সে যেন দয়া করে তার ভাইদের অন্যায় কাজ ক্ষমা করে দেয়|’ সেই জন্য আমরা এখন আমাদের তোমার প্রতি করা সেই অন্যায় কাজের ক্ষমা চাই| আমরা সেই ঈশ্বরের দাস যিনি তোমার পিতারও ঈশ্বর|” এই খবরে যোষেফ খুব দুঃখ পেলেন এবং কাঁদলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","তাঁর ভাইরা তাঁর সামনে গিয়ে প্রণাম করলেন এবং বললেন, “আমরা আপনার দাস হব|” ");
INSERT INTO ben2006_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","তখন যোষেফ তাদের বললেন, “ভয় করো না, আমি ঈশ্বর নই! শাস্তি দেবার অধিকার আমার নেই| ");
INSERT INTO ben2006_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","এটা সত্যি যে তোমরা আমার অনিষ্ট করার পরিকল্পনা করেছিলে, কিন্তু প্রকৃতপক্ষে ঈশ্বরই আমার জন্য ভাল কিছু পরিকল্পনা করছিলেন| ঈশ্বরের আমার মাধ্যমে অনেকের প্রাণ বাঁচানোর পরিকল্পনা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","আর ঘটলও তা-ই| তাই ভয় পেও না| আমি তোমাদের এবং তোমাদের সন্তানদের সহায় হব|” এইভাবে যোষেফ ভাইদের ভালো ভালো কথা বললে তারা ভালো বোধ করল| ");
INSERT INTO ben2006_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","যোষেফ তাঁর পিতার পরিবারের সঙ্গে মিশরে রইলেন| যোষেফ 110 বছর বয়সে মারা গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","যোষেফের জীবনকালেই যোষেফ এও দেখলেন যে তাঁর পুত্র মনঃশির মাখীর নামে একটি পুত্র হল| যোষেফের জীবনকালেই মাখীরের পুত্ররা জন্মাল এবং যোষেফ তাও দেখে যেতে পারলেন| ");
INSERT INTO ben2006_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","অন্তিম শয্যায় যোষেফ তাঁর ভাইদের বললেন, “আমার মৃত্যুর সময় নিকট, কিন্তু আমি জানি ঈশ্বর তোমাদের যত্ন নেবেন এবং এই দেশ থেকে বাইরে নিয়ে যাবেন সেই দেশে, যে দেশ তিনি অব্রাহাম ইসহাক ও যাকোবকে দেবেন বলে প্রতিজ্ঞা করেছিলেন|” ");
INSERT INTO ben2006_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","তারপর যোষেফ তাঁর লোকদের একটি শপথ নিতে বললেন যে ঈশ্বর তাদের যখন নতুন দেশে নিয়ে যাবেন, তখন তারা যেন তাঁর অস্থি বহন করে নিয়ে যায়| ");
INSERT INTO ben2006_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","যোষেফ 110 বছর বয়সে মিশরে মারা যান| চিকিৎসকরা তাঁর দেহে ঔষধ দিয়ে মিশরে এক কফিনের মধ্যে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","যাকোব তাঁর পুত্রদের নিয়ে মিশরের পথে চললেন| পুত্রদের সঙ্গে তাদের নিজ নিজ পরিবারও ছিল| ইস্রায়েলের পুত্ররা হল: ");
INSERT INTO ben2006_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","রূবেণ, শিমিয়োন, লেবি, যিহূদা ");
INSERT INTO ben2006_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইষাখর, সবূলূন, বিন্যামীন, ");
INSERT INTO ben2006_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান, নপ্তালি, গাদ এবং আশের| ");
INSERT INTO ben2006_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","যাকোবের সবশুদ্ধ 70 জন উত্তরপুরুষ ছিল| যোষেফ তাঁর বারোজন পুত্রের একজন, কিন্তু সে আগে থেকে মিশরে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","পরে যোষেফ তাঁর ভাইরা এবং ঐ প্রজন্মের প্রত্যেকেই মারা গেলেও ");
INSERT INTO ben2006_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ইস্রায়েলের লোকদের অসংখ্য সন্তান ছিল| তাদের লোকসংখ্যা খুব তাড়াতাড়ি বেড়ে গিয়েছিল| ফলস্বরূপ মিশর দেশটি ইস্রায়েলীয়তে ভরে গিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","সেই সময় একজন নতুন রাজা মিশর শাসন করতে লাগলেন| এই রাজা যোষেফকে চিনতেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","রাজা তাঁর প্রজাদের উদ্দেশ্যে বললেন, “ইস্রায়েলের লোকদের দিকে চেয়ে দেখ, ওরা সংখ্যায় অসংখ্য এবং আমাদের থেকে বেশী শক্তিশালী! ");
INSERT INTO ben2006_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","তাদের শক্তিবৃদ্ধি বন্ধ করবার জন্য আমাদের কিছু একটা চতুরতার সাহায্য নিতেই হবে| কারণ, এখন যদি যুদ্ধ লাগে তাহলে ওরা আমাদের পরাজিত করবার জন্য ও আমাদের দেশ থেকে বার করে দেবার জন্য আমাদের শত্রুদের সঙ্গে হাত মেলাতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","মিশরের লোকরা তাই ইস্রায়েলের লোকদের জীবনকে দুর্বিষহ করে তোলার ফন্দি আঁটল| অতএব ইস্রায়েলীয়দের তত্ত্বাবধান করবার জন্য মিশরীয়রা ক্রীতদাস মনিবদের নিয়োগ করল| এই দাস শাসকরা ইহুদীদের দিয়ে জোর করে রাজার জন্য পিথোম ও রামিষেষ নামে দুটি শহর নির্মাণ করাল| এই দুই শহরে রাজা শস্য এবং অন্যান্য জিনিসপত্র মজুত করে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","মিশরীয়রা ইস্রায়েলীয়দের কঠিন পরিশ্রম করতে বাধ্য করল| কিন্তু তাদের যত বেশী কঠিন পরিশ্রম করানো হতে থাকল ততই ইস্রায়েলের লোকদের সংখ্যাবৃদ্ধি এবং বিস্তার ঘটতে থাকল| ফলে মিশরীয়রা ইস্রায়েলের লোকদের আরও বেশী ভয় পেতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","আর সেইজন্য তারা উদ্বিগ্ন হয়ে ইস্রায়েলের লোকদের প্রতি আরও বেশী নির্দয় হয়ে উঠল| ফলস্বরূপ মিশরীয়রা ইস্রায়েলীয়দের আরো কঠিন পরিশ্রম করতে বাধ্য করল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","মিশরীয়রা ইস্রায়েলীয়দের জীবন দুর্বিসহ করে তুলল| তারা ইস্রায়েলীয়দের ইঁট তৈরি করবার জন্য গাদা গাদা ভারী ঢালাই এর মিশ্রণ বহন করতে এবং মাঠে লাঙল চালাতে বাধ্য করেছিল| তারা ইস্রায়েলীয়দের সব রকমের কঠিন কাজ করতে বাধ্য করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ইস্রায়েলীয় মহিলাদের সন্তান প্রসবে সাহায্য করবার জন্য দুজন ধাইমা ছিল| তাদের দুজনের নাম ছিল শিফ্রা ও পূয়া| ");
INSERT INTO ben2006_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","স্বয়ং রাজা এসে সেই দুই ধাইমাকে বললেন, “দেখছি তোমরা বরাবর হিব্রু মহিলাদের সন্তান প্রসবের সময় সাহায্য করে চলেছো| দেখ, যদি কেউ কন্যা সন্তান প্রসব করে তাহলে ঠিক আছে, তাকে বাঁচিয়ে রেখ, কিন্তু পুত্র সন্তান হলে সঙ্গে সঙ্গেই সেই সদ্যোজাত পুত্র সন্তানকে হত্যা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","কিন্তু ধাইমা দুজন ঈশ্বরের প্রতি বিশ্বাস রেখে রাজার আদেশ অমান্য করে পুত্র সন্তানদের বাঁচিয়ে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","রাজা এবার তাদের ডেকে পাঠিয়ে বললেন, “তোমরা এটা কি করলে? কেন তোমরা আমার অবাধ্য হয়েছ এবং পুত্র সন্তানদের বাঁচিয়ে রেখেছ?” ");
INSERT INTO ben2006_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ধাইমারা রাজাকে বলল, “হে রাজা, ইস্রায়েলীয় মহিলারা মিশরের মহিলাদের থেকে অনেক বেশী শক্তিশালী| আমরা তাদের সাহায্যের জন্য পৌঁছাবার আগেই ইস্রায়েলীয় মহিলারা সন্তান প্রসব করে ফেলে|” ");
INSERT INTO ben2006_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ঈশ্বর ঐ ধাইমাদের এই আচরণে খুশী হলেন| তাই ঈশ্বর ধাইমাদের আশীর্বাদ করলেন এবং তাদের নিজেদের পরিবার তৈরী করতে দিলেন| ইস্রায়েলীয়রা সংখ্যায় আরও বাড়তে থাকল এবং আরও শক্তিশালী হয়ে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","পরে ফরৌণ নিজস্ব লোকদের আদেশ দিলেন, “তোমরা কন্যা সন্তান বাঁচিয়ে রাখতে পারো| কিন্তু পুত্র সন্তান হলে তাকে নীলনদে ছুঁড়ে ফেলতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","লেবি পরিবারের একজন পুরুষ লেবি পরিবারেরই এক কন্যাকে বিয়ে করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","সে সন্তানসম্ভবা হল এবং একটা সুন্দর ফুটফুটে পুত্র সন্তানের জন্ম দিল| পুত্র সন্তান দেখতে এত সুন্দর হয়েছিল যে তার মা তাকে তিন মাস লুকিয়ে রেখেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","তিন মাস পরে যখন সে তাকে আর লুকিয়ে রাখতে পারছিল না, তখন সে একটি ঝুড়িতে আলকাতরা মাখালো এবং তাতে শিশুটিকে রেখে নদীর তীরে লম্বা ঘাসবনে রেখে এলো| ");
INSERT INTO ben2006_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","শিশুটির বড় বোন তার ভাইয়ের কি অবস্থা হতে পারে দেখবার জন্য দূরে দাঁড়িয়ে ভাইয়ের ঝুড়ির দিকে লক্ষ্য রাখছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ঠিক তখনই ফরৌণের মেয়ে নদীতে স্নান করতে এসেছিল| সে দেখতে পেল ঘাসবনে একটি ঝুড়ি ভাসছে| তার সহচরীরা তখন নদী তীরে ঘুরে বেড়াচ্ছিল| তাই সে তার সহচরীদের একজনকে ঝুড়িটা তুলে আনতে বলল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","তারপর রাজকন্যা ঝুড়িটা খুলে দেখল যে তাতে রয়েছে একটি শিশুপুত্র| শিশুটি তখন কাঁদছিল| আর তা দেখে রাজকন্যার বড় দয়া হল| ভাল করে শিশুটিকে লক্ষ্য করার পর সে বুঝতে পারল যে শিশুটি হিব্রু| ");
INSERT INTO ben2006_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","এবার শিশুটির দিদি আড়াল থেকে বেরিয়ে এসে রাজকন্যাকে বলল, “আমি কি আপনাকে সাহায্যের জন্য কোনও হিব্রু ধাত্রীকে ডেকে আনব যে অন্তত শিশুটিকে দুধ খাওয়াতে পারবে?” ");
INSERT INTO ben2006_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","রাজকন্যা বলল, “বেশ যাও|” সুতরাং মেয়েটি গেল এবং শিশুটির মাকে ডেকে আনল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","রাজকন্যা তাকে বলল, “আমার হয়ে তুমি এই শিশুটিকে দুধ পান করাও| এরজন্য আমি তোমাকে টাকা দেব|” তারই মা শিশুটিকে যত্ন করে বড় করে তুলতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","শিশুটি বড় হয়ে উঠলে মহিলাটি তার সন্তানকে রাজকন্যাকে দিয়ে দিল| রাজকন্যা শিশুটিকে নিজের ছেলের মতোই গ্রহণ করে তার নাম দিল মোশি| শিশুটিকে সে জল থেকে পেয়েছিল বলে তার নামকরণ করা হল মোশি| ");
INSERT INTO ben2006_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","একদিন, মোশি বড় হয়ে যাবার পর সে তার নিজের লোকদের দেখবার জন্য বাইরে গেল এবং দেখল তাদের ভীষণ কঠিন কাজ করতে বাধ্য করা হচ্ছে| সে এও দেখল যে একজন মিশরীয় একজন হিব্রু ছোকরাকে প্রচণ্ড মারধর করছে| ");
INSERT INTO ben2006_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","মোশি চারিদিকে তাকিয়ে দেখল কেউ ব্যাপারটা লক্ষ্য করছে না| তখন মোশি সেই মিশরীয়কে হত্যা করে তাকে বালিতে পুঁতে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","পরদিন মোশি দেখল দুজন ইস্রায়েলীয় নিজেদের মধ্যে মারামারি করছে| তাদের মধ্যে একজন অন্যায়ভাবে আরেকজনকে মারছে| মোশি তখন সেই অন্যায়কারী লোকটির উদ্দেশ্যে বলল, “কেন তুমি তোমার প্রতিবেশীকে মারছো?” ");
INSERT INTO ben2006_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","লোকটি উত্তরে জানাল, “তোমাকে কে আমাদের শাস্তি দিতে পাঠিয়েছে? বলো, তুমি কি আমাকে মারতে এসেছ যেমনভাবে তুমি গতকাল ঐ মিশরীয়কে হত্যা করেছিলে?” তখন মোশি ভয় পেয়ে মনে মনে বলল, “তাহলে এখন ব্যাপারটা সবাই জেনে গেছে|” ");
INSERT INTO ben2006_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","একদিন রাজা ফরৌণ মোশির কীর্তি জানতে পারলেন; তিনি তাকে হত্যা করতে চাইলেন| কিন্তু মোশি মিদিয়ন দেশে পালিয়ে গেল| মিদিয়নে এসে একটি কুয়োর সামনে মোশি বসে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","সেখানে এক যাজক ছিল| তার ছিল সাতটি মেয়ে| কুয়ো থেকে জল তুলে পিতার পোষা মেষপালকে জল খাওয়ানোর জন্য সেই সাতটি মেয়ে কুয়োর কাছে এল| তারা মেষদের জল পানের পাত্রটি ভর্ত্তি করার চেষ্টা করছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","কিন্তু কিছু মেষপালক এসেছিল এবং তরুণীদের তাড়িয়ে দিয়েছিল| তাই মোশি তাদের সাহায্য করতে এলো এবং তাদের পশুর পালকে জল পান করালো| ");
INSERT INTO ben2006_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","তখন তরুণীরা তাদের পিতা রূয়েলের কাছে ফিরে গেল| সে বলল, “তোমরা আজ তাড়াতাড়ি ফিরে এসেছ দেখছি!” ");
INSERT INTO ben2006_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","তরুণীরা উত্তর দিল, “হ্যাঁ, ওখানে কুয়ো থেকে জল তোলার সময় কিছু মেষপালক আমাদের তাড়িয়ে দিল| কিন্তু একজন অচেনা মিশরীয় এলো এবং আমাদের সাহায্য করল| সে আমাদের জন্য জলও তুলে দিল এবং আমাদের মেষের পালকে জল পান করালো|” ");
INSERT INTO ben2006_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","রূয়েল তার মেয়েদের বলল, “সেই লোকটি কোথায়? তোমরা তাকে ওখানে ছেড়ে এলে কেন? যাও তাকে আমাদের সঙ্গে খাবার নেমতন্ন করে এসো|” ");
INSERT INTO ben2006_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","মোশি রূয়েলের সঙ্গে থাকবার জন্য খুশীর সঙ্গে রাজী হল| রূয়েল তার মেয়ে সিপ্পোরার সঙ্গে মোশির বিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","বিয়ের পর সিপ্পোরা একটি পুত্র সন্তানের জন্ম দিল| মোশি তার নাম দিল গের্শোম কারণ সে ছিল প্রবাসে থাকা একজন অপরিচিত ব্যক্তি| ");
INSERT INTO ben2006_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","দেখতে দেখতে অনেক বছর পেরিয়ে গেল| মিশরের রাজাও ইতিমধ্যেই মারা গিয়েছেন| কিন্তু ইস্রায়েলীয়দের তখনও জোর করে কাজ করানো হচ্ছিল| তারা সাহায্যের জন্য কান্নাকাটি শুরু করল| এবং সেই কান্না স্বয়ং ঈশ্বর শুনতে পাচ্ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ঈশ্বর তাদের গভীর আর্তনাদ শুনলেন এবং তিনি স্মরণ করলেন সেই চুক্তির কথা যা তিনি অব্রাহাম, ইসহাক এবং যাকোবের সঙ্গে করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ঈশ্বর ইস্রায়েলীয়দের দেখেছিলেন এবং তিনি জানতেন তিনি কি করতে যাচ্ছেন এবং তিনি স্থির করলেন যে শীঘ্রই তিনি তাঁর সাহায্যের হাত তাদের দিকে বাড়িয়ে দেবেন| ");
INSERT INTO ben2006_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","রূয়েল ছাড়াও মোশির শ্বশুরের আর এক নাম ছিল যিথ্রো| যিথ্রো মিদিয়নীর একজন যাজক| মোশি যিথ্রোর মেষের পালের দেখাশোনার দায়িত্ব নিল| মোশি মেষের পাল চরাতে মরুভূমির পশ্চিম প্রান্তে যেত| একদিন সে মেষের পাল চরাতে চরাতে ঈশ্বরের পর্বত হোরেবে (সীনয়) গিয়ে উপস্থিত হল| ");
INSERT INTO ben2006_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ঐ পর্বতে সে জ্বলন্ত ঝোপের ভিতরে প্রভুর দূতের দর্শন পেল| মোশি দেখল ঝোপে আগুন লাগলেও তা পুড়ে ছাই হয়ে যাচ্ছে না| ");
INSERT INTO ben2006_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","তাই সে অবাক হয়ে জ্বলন্ত ঝোপের আর একটু কাছে এগিয়ে গেল| মনে মনে ভাবল কি আশ্চর্য্য ব্যাপার, ঝোপে আগুন লেগেছে, অথচ ঝোপটা পুড়ে নষ্ট হচ্ছে না! ");
INSERT INTO ben2006_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","প্রভু লক্ষ্য করছিলেন মোশি ক্রমশঃ ঝোপের দিকে দৃষ্টিপাত করতে করতে কাছে এগিয়ে আসছে| তাই ঈশ্বর ঐ ঝোপের ভিতর থেকে ডাকলেন, “মোশি, মোশি!” এবং মোশি উত্তর দিল, “হ্যাঁ, প্রভু|” ");
INSERT INTO ben2006_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","তখন প্রভু বললেন, “আর কাছে এসো না| পায়ের চটি খুলে নাও| তুমি এখন পবিত্র ভূমিতে দাঁড়িয়ে আছো| ");
INSERT INTO ben2006_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","আমি তোমার পূর্বপুরুষদের ঈশ্বর| আমি অব্রাহামের ঈশ্বর, ইসহাকের ঈশ্বর এবং যাকোবের ঈশ্বর|” মোশি ঈশ্বরের দিকে তাকানোর ভয়ে তার মুখ ঢেকে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","তখন প্রভু বললেন, “মিশরে আমার লোকদের দুর্দশা আমি নিজের চোখে দেখেছি| এবং যখন তাদের ওপর অত্যাচার করা হয় তখন আমি তাদের চিৎকার শুনেছি| আমি তাদের যন্ত্রণার কথা জানি| ");
INSERT INTO ben2006_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","এখন সমতলে নেমে গিয়ে মিশরীয়দের হাত থেকে আমার লোকদের আমি রক্ষা করব| আমি তাদের মিশর থেকে উদ্ধার করে নিয়ে যাব এবং আমি তাদের এমন এক সুন্দর দেশে নিয়ে যাব যে দেশে তারা স্বাধীনভাবে শান্তিতে বাস করতে পারবে| সেই দেশ হবে বহু ভাল জিনিসে ভরা ভূখণ্ড| নানা ধরণের মানুষ সে দেশে বাস করে: কনানীয়, হিত্তীয়, ইমোরীয়, পরিষীয়, হিব্বীয় ও যিবুষীয় গোষ্ঠীর লোকরা সেখানে বাস করে| ");
INSERT INTO ben2006_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","আমি ইস্রায়েলীয়দের কান্না শুনেছি| দেখেছি, মিশরীয়রা কিভাবে তাদের জীবন দুর্বিষহ করে তুলেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","তাই এখন আমি তোমাকে ফরৌণের কাছে পাঠাচ্ছি| যাও! তুমি আমার লোক ইস্রায়েলীয়দের মিশর থেকে বাইরে নিয়ে এসো|” ");
INSERT INTO ben2006_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","কিন্তু মোশি ঈশ্বরকে বলল, “আমি কোনও মহান ব্যক্তি নই! সুতরাং আমি কি করে ফরৌণের কাছে যাব এবং ইহুদীদের মিশর থেকে উদ্ধার করে আনব?” ");
INSERT INTO ben2006_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ঈশ্বর বললেন, “তুমি পারবে, কারণ আমি তোমার সঙ্গে থাকব! আমি যে তোমাকে পাঠাচ্ছি তার প্রমাণ হবে; তুমি ইস্রায়েলীয়দের মিশর থেকে উদ্ধার করে আনার পর এই পর্বতে এসে আমার উপাসনা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","তখন মোশি ঈশ্বরের উদ্দেশ্যে বলল, “কিন্তু আমি যদি গিয়ে ইস্রায়েলীয়দের বলি যে, ‘তোমাদের পূর্বপুরুষদের ঈশ্বর আমাকে পাঠিয়েছেন,’ তখন তারা আমাকে জিজ্ঞাসা করবে, ‘তার নাম কি?’ তখন আমি তাদের কি বলব?” ");
INSERT INTO ben2006_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","তখন ঈশ্বর মোশিকে বললেন, “তাদের বলো, ‘আমি আমিই|’ যখনই তুমি ইস্রায়েলীয়দের কাছে যাবে তখনই তাদের বলবে, ‘আমিই’ আমাকে পাঠিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ঈশ্বর মোশিকে আরও বললেন, “তুমি অবশ্যই তাদের একথা বলবে: যিহোবা হলেন তোমাদের পূর্বপুরুষদের ঈশ্বর, অব্রাহামের ঈশ্বর, ইসহাকের ঈশ্বর এবং যাকোবের ঈশ্বর| আমার নাম সর্বদা হবে যিহোবা| এই নামেই আমাকে লোকে বংশ পরম্পরায় চিনবে|’ লোকদের বলো, ‘যিহোবা তোমাকে পাঠিয়েছেন! ");
INSERT INTO ben2006_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","প্রভু আরও বললেন, “যাও, ইস্রায়েলের প্রবীণদের একত্র করে তাদের বলো, ‘যিহোবা, তোমাদের পূর্বপুরুষদের ঈশ্বর আমাকে দর্শন দিয়েছেন| অব্রাহামের, ইসহাকের, এবং যাকোবের ঈশ্বর আমাকে বলেছেন: তোমাদের সঙ্গে মিশরে যা ঘটেছে তা সবই আমি দেখেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","আমি সিদ্ধান্ত নিয়েছি যে মিশরের দুর্দশা থেকে তোমাদের উদ্ধার করব| আমি তোমাদের উদ্ধার করব এবং তোমাদের কনানীয়, হিত্তীয়, ইমোরীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের দেশে নিয়ে যাব| আমি তোমাদের বহু সুসম্পদে ভরা ভূখণ্ডে নিয়ে যাব|’ ");
INSERT INTO ben2006_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“প্রবীণরা তোমার কথা শুনবে এবং তখন তুমি প্রবীণদের নিয়ে মিশরের রাজার কাছে যাবে| তুমি অবশ্যই যাবে এবং রাজাকে বলবে যে যিহোবা, ইস্রায়েলীয়দের ঈশ্বর আমাদের সামনে আবির্ভূত হয়েছিলেন| এখন আমাদের তিনদিন ধরে মরুভূমিতে ভ্রমণ করতে দাও| সেখানে আমরা যিহোবা, আমাদের ঈশ্বরের উদ্দেশ্যে উৎসর্গ দান করব|” ");
INSERT INTO ben2006_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“কিন্তু আমি জানি যে মিশরের রাজা তোমাদের সেখানে যেতে দেবে না| কেবলমাত্র একটি মহান শক্তিই তাকে বাধ্য করতে পারে তোমাদের যাবার অনুমতি দেবার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","তাই আমি আমার বিরাট ক্ষমতা দিয়ে মিশরীয়দের আঘাত করব| আমি ঐ দেশে আশ্চর্য্য সব কাণ্ড ঘটাব| আমার ঐসব অদ্ভুত কাণ্ড ঘটানোর পরেই দেখবে যে সে তোমাদের যেতে দিচ্ছে| ");
INSERT INTO ben2006_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","এবং আমি ইস্রায়েলীয়দের প্রতি মিশরীয়দের দয়ালু করে তুলব| ফলে তোমরা যখন মিশর ত্যাগ করবে তখন মিশরীয়রা তোমাদের হাত উপহারে ভরে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“প্রত্যেক ইস্রায়েলীয় মহিলা নিজের নিজের মিশরীয় প্রতিবেশীর বাড়ী যাবে এবং মিশরীয় মহিলার কাছে গিয়ে উপহার চাইবে| এবং মিশরীয় মহিলারা তাদের উপহার দেবে| তোমার লোকরা উপহার হিসাবে সোনা, রূপা এবং মিহি ও মসৃণ পোশাক পাবে| তারপর যখন তোমরা মিশর ত্যাগ করবে তখন সেই উপহারগুলি নিজের নিজের ছেলেমেয়েদের গায়ে পরিয়ে দেবে| এইভাবে তোমরা মিশরীয়দের সম্পদ নিয়ে আসতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","তখন মোশি ঈশ্বরকে বললেন, “কিন্তু আপনি আমাকে পাঠিয়েছেন বললেও ইস্রায়েলের লোকরা তা বিশ্বাস করতে চাইবে না| বরং তারা উল্টে বলবে, ‘প্রভু তোমাকে দর্শন দেন নি|’” ");
INSERT INTO ben2006_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","কিন্তু প্রভু মোশিকে জিজ্ঞাসা করলেন, “তোমার হাতে ওটা কি?” মোশি উত্তর দিল, “এটা আমার পথ চলার লাঠি|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","তখন প্রভু বললেন, “ঐ লাঠিকে মাটিতে ছুঁড়ে ফেল|” প্রভুর কথামতো মোশি তার হাতের পথ চলার লাঠিকে মাটিতে ছুঁড়ে ফেলতেই ঐ লাঠি তত্ক্ষনাত্‌ সাপে পরিণত হল| মোশি তা দেখে ভয়ে পালাতে যাচ্ছে দেখে ");
INSERT INTO ben2006_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","প্রভু মোশিকে বললেন: “যাও কাছে গিয়ে সাপটিকে লেজের দিক থেকে ধরো|” তখন মোশি সাপটির লেজ ধরে ঝোলাতেই দেখল সাপটি আবার লাঠিতে পরিণত হল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","তখন প্রভু বললেন, “লাঠি দিয়ে এই চমৎ‌‌কারিত্ব দেখলেই লোকরা বিশ্বাস করবে যে তুমি প্রভু, তোমার পূর্বপুরুষের ঈশ্বরের দেখা পেয়েছ| দেখা পেয়েছ অব্রাহাম, ইসহাক এবং যাকোবের ঈশ্বরের|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","তারপর প্রভু মোশিকে বললেন, “আমি তোমাকে আরও একটি প্রমাণ দেব| আলখাল্লার নীচে হাত রাখো|” তাই মোশি আলখাল্লা খুলে হাত ভেতরে রাখলো| তারপর সে তার হাত বার করে দেখল হাতটি শ্বেতীতে ভরে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","তখন প্রভু বললেন, “এবার আবার আলখাল্লার ভেতরে হাত ঢুকিয়ে দাও|” তাই মোশি আবার তার হাত আলখাল্লার ভেতরে ঢুকিয়ে দিল এবং তা বার করে আনার পর মোশি দেখল তার হাত আবার আগের মতোই স্বাভাবিক সুন্দর হয়ে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","তারপর প্রভু বললেন, “যদি লোকরা লাঠিকে সাপ বানানোর কীর্তি দেখার পরও তোমাকে বিশ্বাস না করে তাহলে হাতের ব্যাপারটি দেখাবে| তখন তোমাকে তারা বিশ্বাস করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","যদি এই দুটো প্রমাণ দেখানোর পরও লোকরা তোমাকে বিশ্বাস না করে তাহলে নীলনদ থেকে সামান্য জল নেবে| সেই জল মাটিতে ঢালবে এবং জল মাটিকে স্পর্শ করার সঙ্গে সঙ্গে তা রক্তে পরিণত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","তখন মোশি প্রভুর উদ্দেশ্যে বললেন, “কিন্তু প্রভু আমি তো একজন চতুর বক্তা নই| আমি কোনোকালেই সাজিয়ে গুছিয়ে কথা বলতে পারি না| এবং এখনও আপনার সঙ্গে কথা বলার পরেও আমি সুবক্তা হতে পারি নি| আপনি জানেন যে আমি ধীরে ধীরে কথা বলি এবং কথা বলার সময় ভাল ভাল শব্দ চয়ন করতে পারি না|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","তখন প্রভু তাকে বললেন, “মানুষের মুখ কে সৃষ্টি করেছে? এবং কে একজন মানুষকে বোবা ও কালা তৈরী করে? কে মানুষকে অন্ধ তৈরী করে? কে মানুষকে দৃষ্টিশক্তি দেয়? আমি যিহোবা| আমিই একমাত্র এইসব করতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","সুতরাং যাও| যখন তুমি কথা বলবে তখন আমি তোমায় কথা বলতে সাহায্য করব| আমিই তোমার মুখে শব্দ জোগাব|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","তবু মোশি বলল, “হে আমার প্রভু, আমার একটাই অনুরোধ, আপনি এই কাজের জন্য অন্য একজনকে মনোনীত করুন, আমাকে নয়|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","মোশির প্রতি প্রভু তখন ক্রুদ্ধ হয়ে বললেন, “বেশ! তাহলে তোমাকে সাহায্য করার জন্য আমি তোমার ভাই হারোণকে তোমার সঙ্গে দিচ্ছি| হারোণ লেবীয় পরিবারের সন্তান এবং সে বেশ ভাল বক্তা| হারোণ ইতিমধ্যেই তোমার সঙ্গে দেখা করার জন্য আসছে| এবং সে তোমাকে দেখে খুশীই হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","হারোণ তোমার সঙ্গে ফরৌণের কাছে যাবে| তোমাদের কি বলতে হবে তা আমি বলে দেব| কি করতে হবে তা আমি তোমাদের শিখিয়ে দেব এবং তুমি তা হারোণকে বলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","তোমার হয়ে হারোণ লোকদের সঙ্গে কথা বলবে| তুমি হবে তার কাছে ঈশ্বরের মতো| আর হারোণ হবে তোমার মুখপাত্র| ");
INSERT INTO ben2006_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","সুতরাং যাও এবং সঙ্গে তোমার পথ চলার লাঠি নাও| আমি যে তোমার সঙ্গে আছি তা প্রমাণ করার জন্য লোকদের এই চিহ্ন-কার্যগুলি দেখাও|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","মোশি তখন তার শ্বশুর যিথ্রোর কাছে ফিরে গেল| মোশি তার শ্বশুরকে বলল, “অনুগ্রহ করে আমাকে মিশরে ফিরে যেতে দিন| আমি দেখতে চাই আমার লোকরা এখনও সেখানে বেঁচে আছে কিনা|” যিথ্রো তার জামাতা মোশিকে বলল, “নিশ্চয়ই! আশা করি তুমি সেখানে ভালোভাবেই পৌঁছাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","মিদিয়নে থাকাকালীন প্রভু মোশিকে বললেন, “মিশরে ফিরে যাওয়া এখন তোমার পক্ষে ভাল| কারণ যারা তোমায় হত্যা করতে চেয়েছিল তারা এখন কেউ বেঁচে নেই|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","সুতরাং মোশি তখন তার স্ত্রী ও ছেলেমেয়েদের গাধার পিঠে চাপিয়ে মিশরে প্রত্যাবর্তন করল| সঙ্গে সে তার পথ চলার লাঠিও নিল| এটা সেই পথ চলার লাঠি যাতে রয়েছে ঈশ্বরের অলৌকিক শক্তি| ");
INSERT INTO ben2006_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","মিশরে আসার পথে প্রভু মোশির সঙ্গে কথা বলেছিলেন| তিনি বলেছিলেন, “আমি তোমাকে অলৌকিক কাজ দেখানোর যে সব শক্তি দিয়েছি সেগুলো সব ফরৌণের সঙ্গে কথা বলার সময় তার সামনে করে দেখাবে| কিন্তু আমি ফরৌণকে একগুঁয়ে এবং জেদী করে তুলব| সে লোকদের কিছুতেই ছেড়ে দেবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","তখন তুমি ফরৌণকে বলবে: ");
INSERT INTO ben2006_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","প্রভু বলেছেন, ‘ইস্রায়েল হল আমার প্রথমজাত পুত্র সন্তান| এই প্রথমজাত সন্তান একটি পরিবারে জন্মেছিল| অতীত দিনে এই প্রথমজাত সন্তানের গুরুত্ব ছিল অসীম| এবং আমি তোমাকে বলছি আমার পুত্রকে আমার উপাসনার জন্য ছেড়ে দাও| তুমি যদি ইস্রায়েলকে ছেড়ে দিতে অস্বীকার করো তাহলে আমি তোমার প্রথমজাত পুত্র সন্তানকে হত্যা করব|’” ");
INSERT INTO ben2006_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","মিশরে ফেরার পথে মোশি একটি পান্থশালায় রাত্রিযাপন করছিল| তখন প্রভু তাকে হত্যা করতে চেষ্টা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","কিন্তু সিপ্পোরা একটা ধারালো পাথরের ছুরি দিয়ে তার পুত্রের সুন্নৎ করল| এবং সুন্নৎ এর চামড়া (চামড়াটি লিঙ্গের মুখ থেকে ছিঁড়ে বেরিয়েছিল|) মোশির পায়ে ছোঁয়াল| তারপর সে মোশিকে বলল, “আমার কাছে তুমি রক্তের স্বামী|” ");
INSERT INTO ben2006_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","সিপ্পোরা একথা বলেছিল কারণ তার ছেলের সুন্নৎ তাকে করতেই হত| তাই সে তাদের কাছ থেকে সরে এল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","প্রভু হারোণকে বললেন, “মরুপ্রান্তরে গিয়ে মোশির সঙ্গে দেখা করো|” প্রভুর কথামতো হারোণ ঈশ্বরের পর্বতে গিয়ে মোশির সঙ্গে দেখা করে তাকে চুম্বন করল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","প্রভু যে সব কথা বলবার জন্য মোশিকে পাঠিয়েছিলেন এবং প্রভুই যে তাকে পাঠিয়েছেন তা প্রমাণ করবার জন্য যে সব অলৌকিক কাজ করতে বলেছিলেন তার সম্বন্ধে সবই মোশি হারোণকে জানাল| প্রভু যা বলেছেন তার সবকিছু মোশি হারোণকে খুলে বলল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","সুতরাং মোশি এবং হারোণ ইস্রায়েলের লোকদের মধ্যে প্রবীণ ব্যক্তিদের একত্র করার জন্য গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","তখন হারোণ সেই কথাগুলো বলল যেগুলো প্রভু মোশিকে বলতে বলেছিলেন| আর মোশি লোকদের সামনে সেই সকল চিহ্ন কার্য করে দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","তার ফলে লোকরা বিশ্বাস করল যে প্রভু মোশিকে পাঠিয়েছেন| একই সঙ্গে ইস্রায়েলের লোকরা জানল যে, ঈশ্বর তাদের দুঃখ দুর্দশা দেখে তাদের সাহায্যে এগিয়ে এসেছেন| তাই তারা সকলে নতজানু হয়ে ঈশ্বরের উপাসনা করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","লোকদের সঙ্গে কথা বলার পর মোশি এবং হারোণ ফরৌণের কাছে গিয়ে বলল, “প্রভু ইস্রায়েলের ঈশ্বর বলেছেন, ‘আমার সম্মানার্থে উৎসব করার জন্য আমার লোকদের মরুপ্রান্তরে যাওয়ার ছাড়পত্র দাও|’” ");
INSERT INTO ben2006_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","কিন্তু ফরৌণ বলল, “কে প্রভু? আমি কেন তাকে মানব? কেন ইস্রায়েলকে ছেড়ে দেব? এমনকি এই প্রভু কে আমি তাই জানি না| সুতরাং আমি এভাবে ইস্রায়েলের লোকদের ছেড়ে দিতে পারি না|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","তখন হারোণ এবং মোশি বলল, “ইস্রায়েলীয়দের ঈশ্বর আমাদের সঙ্গে কথা বলেছেন| তাই আমরা তিন দিনের জন্য মরুপ্রান্তরে ভ্রমণের অনুমতি প্রার্থনা করছি, সেখানে আমরা আমাদের প্রভু, ঈশ্বরের উদ্দেশ্যে নৈবেদ্য উৎসর্গ করব| আমরা যদি তা না করি তাহলে তিনি প্রচণ্ড ক্রুদ্ধ হয়ে আমাদের ধ্বংস করে দেবেন| আমাদের মহামারী অথবা যুদ্ধের প্রকোপে মেরে ফেলবেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","কিন্তু তখন মিশরের রাজা তাদের উত্তর দিলেন, “মোশি ও হারোণ, তোমরা কাজের লোকদের বিরক্ত করছ| ওদের কাজ করতে দাও| গিয়ে নিজের কাজে মন দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","দেখ, দেশে এখন প্রচুর কর্মী আছে এবং তোমরা তাদের কাজ করা থেকে বিরত করছ|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","একই দিনে ক্রীতদাস প্রভুদের এবং ইস্রায়েলীয় তত্ত্বাবধায়কদের ফরৌণ আদেশ দিলেন ইস্রায়েলীয় লোকদের আরো কিছু কঠিনতর কাজ দিতে| ");
INSERT INTO ben2006_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","ফরৌণ তাদের বললেন, “ইঁট তৈরির জন্য এতদিন তোমরা খড় সরবরাহ করেছো| কিন্তু ওদের বলো, এখন থেকে ইঁট তৈরির জন্য প্রয়োজনীয় খড় ওরা নিজেরাই যেন খুঁজে আনে| ");
INSERT INTO ben2006_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","কিন্তু খড় খুঁজে আনতে হবে বলে ইঁটের উৎপাদন যেন না কমে| আগে ওরা সারাদিনে যে পরিমাণ ইঁট তৈরি করতো নিজেরা খড় জোগাড় করে আনার পরও ওদের আগের মতো একই পরিমাণ ইঁট তৈরি করতে হবে| আজকাল ওরা ভীষণ অলস হয়ে গেছে| এবং সেজন্যই ওরা আমার কাছে মরুপ্রান্তরে যাওয়ার ছাড়পত্র চাইছে| ওদের হাতে বিশেষ কাজ নেই তাই ওরা ওদের ঈশ্বরকে নৈবেদ্য উৎসর্গ করতে যেতে চায়| ");
INSERT INTO ben2006_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","তাই এই লোকদের আরও কঠিন পরিশ্রম করাও যাতে ওরা ব্যস্ত থাকে| তাহলে ওদের আর প্রতারণামূলক কথা শোনবার সময় হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","তাই মিশরের ক্রীতদাস প্রভু এবং ইস্রায়েলীয় তত্ত্বাবধায়করা ইস্রায়েলের লোকদের কাছে গিয়ে বলল, “ফরৌণ সিদ্ধান্ত নিয়েছেন যে ইঁট তৈরির জন্য তোমাদের আর খড় সরবরাহ করা হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","এবার থেকে তোমরা নিজেরা খড় জোগাড় করে আনবে| সুতরাং যাও গিয়ে খড় জোগাড় করো| কিন্তু ইঁট তৈরির পরিমাণ আগের মতোই রাখতে হবে| খড় জোগাড়ের নাম করে কম ইঁট তৈরি করলে চলবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","সুতরাং লোকরা মিশরের চারিদিকে খড়ের খোঁজে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ক্রীতদাস প্রভুরা ইস্রায়েলীয়দের আরো কঠিন কাজ করালো এবং তাদের একদিনে সমান সংখ্যক ইঁট তৈরি করতে বাধ্য করল যা তারা খড় থাকাকালীন করত| ");
INSERT INTO ben2006_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","মিশরীয় ক্রীতদাস প্রভুরা ইস্রায়েলীয়দের দিয়ে এই হাড়ভাঙ্গা পরিশ্রম করানোর দায়িত্ব চাপালো ইস্রায়েলীয় তত্ত্বাবধায়কদের ওপর| মিশরীয় ক্রীতদাস প্রভুরা ইস্রায়েলীয় তত্ত্বাবধায়কদের মারলো এবং তাদের বলল, “কেন তোমরা আগের মতো ইঁট তৈরি করতে পারছো না? তোমরা আগে যা করতে পারতে এখনও তোমাদের তাই পারা উচিৎ‌|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","তখন ইস্রায়েলীয় তত্ত্বাবধায়করা ফরৌণের কাছে নালিশ জানাতে গেল| তারা ফরৌণকে বলল, “আমরা তো আপনার অনুগত ভৃত্য়, তাহলে আমাদের সঙ্গে কেন এরকম ব্যবহার করছেন? ");
INSERT INTO ben2006_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","আপনি আমাদের খড় সরবরাহ বন্ধ করেছেন| আবার বলছেন আগের মতোই ইঁটের উৎপাদন চালু রাখতে হবে| ইঁট তৈরির পরিমাণ কম হলেই আমাদের মনিবরা আমাদের মারধোর করছে| আপনার লোকরা এটা তো অন্যায় করছে|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","উত্তরে ফরৌণ জানালেন, “তোমরা কাজ করতে চাও না| তোমরা অলস হয়ে গেছ| সেজন্যই তোমরা প্রভুর উদ্দেশ্যে নৈবেদ্য উৎসর্গ করতে যাবার ব্যাপারে আমার অনুমতি চেয়েছো| ");
INSERT INTO ben2006_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","যাও, এখন আবার কাজে ফিরে যাও| আমরা তোমাদের কোনও খড় সরবরাহ করব না এবং তোমাদের আগের মতোই সমপরিমাণ ইঁট তৈরি করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","তখন ইস্রায়েলীয় তত্ত্বাবধায়করা বুঝতে পারল যে তারা গভীর সঙ্কটে পড়েছে| তারা জানতো যে কিছুতেই তারা আগের পরিমাণ মতো ইঁট আর তৈরি করতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ফরৌণের সঙ্গে দেখা করে ফেরার পথে মোশি এবং হারোণের সঙ্গে তাদের দেখা হল| মোশি ও হারোণ অবশ্য তাদের সঙ্গে দেখা করার জন্যই অপেক্ষা করছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","সুতরাং ইস্রায়েলীয় তত্ত্বাবধায়করা মোশি ও হারোণকে বলল, “আমাদের যাওয়ার ছাড়পত্র চাওয়ার ব্যাপারে ফরৌণের সঙ্গে কথা বলে তোমরা একটা মারাত্মক ভুল করেছো| প্রভু যেন তোমাদের শাস্তি দেন| কারণ তোমাদের জন্যই ফরৌণ ও তার শাসকরা আমাদের এখন ঘৃণা করে| তোমরাই তাদের হাতে আমাদের হত্যা করার অজুহাত তুলে দিয়েছ|” ");
INSERT INTO ben2006_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","তখন মোশি প্রভুর কাছে ফিরে গেল এবং বলল, “প্রভু কেন আপনি লোকদের এমন অমঙ্গল করলেন? কেন আপনি আমায় এখানে পাঠিয়েছিলেন? ");
INSERT INTO ben2006_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","আপনি যা বলতে বলেছিলেন আমি সে কথাগুলো বলতেই ফরৌণের কাছে গিয়েছিলাম| অথচ সেই সময় থেকেই ফরৌণ আপনার লোকদের প্রতি অত্যন্ত খারাপ ব্যবহার করছে| এবং আপনি ঐসব লোকদের সাহায্যের জন্য কোনও কিছুই করছেন না|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","প্রভু তখন মোশিকে বললেন, “ফরৌণের এখন আমি কি অবস্থা করব তা তুমি দেখতে পাবে| আমি তার বিরুদ্ধে আমার মহান ক্ষমতা ব্যবহার করব এবং সে আমার লোকদের চলে যেতে বাধ্য করবে| সে যে শুধু আমার লোকদের ছেড়ে দেবে তা নয়, সে তার দেশ থেকে তাদের জোর করে পাঠিয়ে দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ঈশ্বর তখন মোশিকে আবার বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“আমিই হলাম প্রভু| আমি অব্রাহাম, ইসহাক এবং যাকোবের সামনে নিজেকে প্রকাশ করতাম| তারা আমায় এল্সদাই (সর্বশক্তিমান ঈশ্বর) বলে ডাকত| আমার নাম যে যিহোবা তা তারা জানত না| ");
INSERT INTO ben2006_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","আমি তাদের সঙ্গে একটি চুক্তি করেছিলাম| আমি তাদের কনান দেশ দেবার প্রতিশ্রুতি দিয়েছিলাম| ঐ দেশে তারা বাস করলেও দেশটি কিন্তু তাদের নিজস্ব দেশ ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","এখন, আমি ইস্রায়েলীয়দের বিলাপ শুনেছি। আমি জানি মিশরীয়রা তাদের ক্রীতদাস করে রেখেছিল এবং আমি আমার চুক্তিকে মনে রাখব| ");
INSERT INTO ben2006_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","সুতরাং ইস্রায়েলের লোকদের গিয়ে বলো আমি তাদের বলেছি, ‘আমি হলাম প্রভু| আমি তোমাদের রক্ষা করব| আমিই তোমাদের মুক্ত করব| তোমরা আর মিশরীয়দের ক্রীতদাস থাকবে না| আমি আমার মহান শক্তি ব্যবহার করব এবং মিশরীয়দের ভয়ঙ্কর শাস্তি দেব| তখন আমি তোমাদের উদ্ধার করব| ");
INSERT INTO ben2006_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","আমি তোমাদের আমার লোক করে নিলাম এবং আমি হব তোমাদের ঈশ্বর| তোমরা জানবে যে আমি হলাম তোমাদের প্রভু, ঈশ্বর, যে তোমাদের মিশর থেকে মুক্ত করেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","আমি অব্রাহাম, ইসহাক এবং যাকোবের কাছে একটি মহান প্রতিশ্রুতি দিয়েছিলাম| আমি তাদের একটি বিশেষ দেশ দান করার প্রতিশ্রুতি দিয়েছিলাম| তাই আমার নেতৃত্বে তোমরা ঐ দেশে যাবে| আমি তোমাদের ঐ দেশটি দিয়ে দেব| সেই দেশটি একান্তভাবে তোমাদেরই হবে| আমিই হলাম প্রভু|’” ");
INSERT INTO ben2006_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","মোশি এই কথাগুলো ইস্রায়েলীয়দের বলল, কিন্তু তাদের ধৈর্য্যহীনতা ও কঠোর পরিশ্রমের দরুণ তারা তার কথা শুনতে অস্বীকার করল| ");
INSERT INTO ben2006_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“যাও মিশরের রাজা ফরৌণকে বলো যে তার উচিৎ‌ ইস্রায়েলীয়দের তার দেশ থেকে মুক্তি দেওয়া|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","কিন্তু মোশি উত্তরে জানাল, “ইস্রায়েলের লোকরাই আমার কথা শুনতে অস্বীকার করছে, সেক্ষেত্রে ফরৌণ আর কি শুনবে! সেও আমার কথা শুনতে রাজি হবে না| এ ব্যাপারে আমি একরকম নিশ্চিত| তার উপর আমি ভালোভাবে কথা বলতেও পারি না|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","কিন্তু প্রভু মোশি এবং হারোণের সঙ্গে কথা বললেন এবং তাদের ইস্রায়েলীয়দের সঙ্গে ও ফরৌণের সঙ্গে কথা বলতে আদেশ দিলেন| ইস্রায়েলীয়দের মিশর থেকে উদ্ধার করে আনতে প্রভু তাদের আদেশ দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ইস্রায়েলীয় পরিবারগুলির নেতাদের নাম ক্রমানুসারে এইরূপ: ইস ইস্রায়েলের জ্যেষ্ঠ পুত্রের নাম ছিল রূবেণ| তার পুত্ররা ছিল: হনোক, পল্লু, হিষ্রোণ ও কর্ম্মি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","শিমিয়োনোর পুত্ররা ছিল: যিমুয়েল, যামীন, ওহদ, যাখীন, সোহর এবং শৌল যে ছিল এক কনানীয়া মহিলার গর্ভজাত সন্তান| ");
INSERT INTO ben2006_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","লেবি 137 বছর জীবিত ছিলেন| লেবির পুত্রদের নাম হল গের্শোন, কহাত্‌ ও মরারি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","গের্শোনের আবার দুই পুত্র ছিল লিব্নি ও শিমিয়ি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","কহাত্‌ 133 বছর পর্যন্ত জীবিত ছিল| কহাতের পুত্ররা হল অম্রম, যিষ্হর, হিব্রোণ এবং উষীয়েল| ");
INSERT INTO ben2006_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মরারির দুই পুত্র হল মহলি ও মুশি| এই প্রত্যেকটি পরিবারের প্রথম পূর্বপুরুষ ছিল ইস্রায়েলের সন্তান লেবি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","অম্রম বেঁচে ছিল 137 বছর| অম্রম তার আপন পিসি য়োকেবদকে বিয়ে করেছিল| অম্রম ও য়োকেবদের দুই সন্তান হল যথাক্রমে হারোণ এবং মোশি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","যিষ্হরের পুত্ররা হল কোরহ, নেফগ ও সিখ্রি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","আর উষীয়েলের সন্তান হল মীশায়েল, ইল্সাফন ও সিথ্রি| ");
INSERT INTO ben2006_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","হারোণ অম্মীনাদবের কন্যা, নহোশনের বোন ইলীশেবাকে বিয়ে করেছিল| হারোণ ও ইলীশেবার সন্তানরা হল নাদব, অবীহূ, ইলিয়াসর ও ইথামর| ");
INSERT INTO ben2006_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","কোরহের পুত্র অসীর, ইল্কানা ও অবীযাসফ হল কোরহীয় গোষ্ঠীর পূর্বপুরুষ| ");
INSERT INTO ben2006_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","হারোণের পুত্র ইলিয়াসর পূটীয়েলের এক কন্যাকে বিয়ে করার পরে তাদের যে সন্তান হয় তার নাম দেওয়া হয় পীনহস| এরা প্রত্যেকেই ইস্রায়েলের পুত্র লেবির বংশজাত| ");
INSERT INTO ben2006_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","হারোণ এবং মোশি ছিল এই পরিবারগোষ্ঠীর| প্রভু তাদের দুজনের সঙ্গে কথা বলেছিলেন এবং বলেছিলেন, “আমার লোকদের মিশর থেকে দলে দলে বাইরে নিয়ে এসো|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","হারোণ এবং মোশি উভয়েই মিশরের রাজা ফরৌণের সঙ্গে কথা বলেছিল| তারাই ফরৌণকে বলেছিল ইস্রায়েলের লোকদের মিশর থেকে ছেড়ে দেওয়া হোক্| ");
INSERT INTO ben2006_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","মিশরে যেদিন প্রভু মোশির সঙ্গে কথা বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","তিনি তাকে বলেছিলেন, “আমিই হলাম প্রভু| আমি তোমাকে যা কিছু বলেছি তা মিশরের রাজা ফরৌণকে গিয়ে বলো|” ");
INSERT INTO ben2006_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","কিন্তু মোশি উত্তর দিল, “আমি ভালোভাবে কথা বলতে পারি না| রাজা আমার কথা শুনবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","প্রভু তখন মোশিকে বললেন, “আমি তোমাকে ফরৌণের কাছে একজন ঈশ্বর করে তুলেছি| আর হারোণ তোমার ভাই হবে তোমার ভাববাদী| ");
INSERT INTO ben2006_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","তোমার ভাই হারোণকে আমার সমস্ত আদেশগুলো বলো| তাহলে হারোণ রাজাকে আমার কথাগুলো জানাবে| ফরৌণ ইস্রায়েলীয়দের তার দেশ থেকে চলে যেতে অনুমতি দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","কিন্তু আমি ফরৌণকে জেদী করে তুলব| তাই সে তোমাদের কথা মানবে না| তখন আমি নিজেকে প্রমাণের উদ্দেশ্যে মিশরে নানারকম অলৌকিক অথবা অদ্ভুত কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তবুও সে তোমাদের কথা শুনবে না| তখন আমি মিশরকে কঠিন শাস্তি দেব এবং আমি মিশর থেকে আমার লোকদের বাইরে বের করে আনব| ");
INSERT INTO ben2006_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","যখন আমি তাদের বিরোধিতা করব তখন মিশরের লোকরাও জানতে পারবে যে আমিই হলাম প্রভু| সেই মুহুর্তে আমি আমার লোকদের মিশরীয়দের দেশ থেকে বের করে আনব|” ");
INSERT INTO ben2006_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","প্রভু তাদের যা বলেছিলেন মোশি এবং হারোণ তা মেনে চলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","যখন তারা ফরৌণের সঙ্গে কথা বলেছিল সেই সময় মোশির বয়স ছিল 80 এবং হারোণের বয়স ছিল 83 বছর| ");
INSERT INTO ben2006_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","মোশি এবং হারোণকে প্রভু বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ফরৌণ তোমাদের শক্তির পরিচয়ের প্রমাণ হিসাবে কোনও অলৌকিক কাজ ঘটিয়ে দেখাতে বলবে| তখন হারোণকে বলবে তোমার পথ চলার লাঠিটি মাটিতে ছুঁড়ে ফেলতে| ফরৌণের চোখের সামনে মাটিতে পড়ে থাকা ঐ লাঠি নিমেষের মধ্যে সাপে পরিণত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","তাই মোশি এবং হারোণ প্রভুর কথামতো ফরৌণের কাছে গেল| হারোণ তার সামনে লাঠিটি মাটিতে ছুঁড়ে ফেলেছিল| ফরৌণ এবং তার সভাসদদের চোখের সামনেই লাঠি সাপের রূপ নিল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","রাজা এই ঘটনা দেখে তার জ্ঞানীগুণী ব্যক্তি ও যাদুকরদের ডাকলেন| রাজার নিজস্ব যাদুকররা তাদের মায়াবলে হারোণের মতো তাদের লাঠিটিও সাপে পরিণত করে দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","সেইসব যাদুকররাও নিজের নিজের হাতের লাঠিকে মাটিতে ছুঁড়ে ফেলে মুহুর্তে লাঠিগুলিকে সাপে রূপান্তরিত করে দেখাল| কিন্তু হারোণের লাঠি তাদের লাঠিগুলোকে গ্রাস করে নিল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","তবুও ফরৌণ উদ্ধত হয়ে থাকলেন| প্রভুর ভবিষ্যদ্বাণী অনুযায়ীরাজা মোশি এবং হারোণের কথায় কান দিলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","তখন প্রভু মোশিকে বললেন, “ফরৌণ লোকদের ছেড়ে না দেবার জেদ ধরে রইল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","সকালে ফরৌণ নদীর দিকে যায়| তুমিও তার সঙ্গে দেখা করার জন্য নীল নদের তীরে দাঁড়াবে| সাপে পরিণত হয় ঐ লাঠিকে সঙ্গে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ফরৌণকে বলবে: ‘প্রভু ইস্রায়েলীয়দের ঈশ্বর আমাকে পাঠিয়েছেন| আমায় আপনাকে বলতে বলেছেন যে তাঁর লোকদের যেন তাঁর উপাসনার জন্য মরুপ্রান্তরে যেতে দেওয়া হয়| এখনও পর্যন্ত অবশ্য আপনি প্রভুর কথা শোনেন নি| ");
INSERT INTO ben2006_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","তাই প্রভু আপনার সম্মুখে নিজের স্বরূপ প্রমাণের উদ্দেশ্যে কিছু কাণ্ড ঘটাবেন| এবার দেখুন আমি আমার পথ চলার লাঠি দিয়ে নীল নদের জলে আঘাত করব এবং সঙ্গে সঙ্গে নদীর জল রক্তে পরিণত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","নদীর সমস্ত মাছ মারা যাবে এবং নদীর জলে দুর্গন্ধ ছড়াবে| ফলে মিশরীয়রা আর এই নদীর জল পান করতে পারবে না|’” ");
INSERT INTO ben2006_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","প্রভু মোশিকে বললেন, “হারোণকে বলো এই লাঠি নিয়ে সে যেন মিশরের সমস্ত জলাশয়, নদী, খাল, বিল, হ্রদ প্রত্যেকটি জায়গার জলে স্পর্শ করে| লাঠির স্পর্শে সমস্ত জলাশয়ের জল রক্তে পরিণত হবে| এমনকি কাঠ ও পাথরের পাত্রে সংগ্রহ করে রাখা পানীয় জলও রক্তে পরিণত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","সুতরাং মোশি এবং হারোণ প্রভুর আদেশ কার্যকর করল| হারোণ ফরৌণ ও তার সভাসদগণের সামনেই তার হাতে লাঠি উঁচিয়ে ধরে নীল নদের জলে আঘাত করল| আর সঙ্গে সঙ্গে নদীর জল রক্তে পরিণত হল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","নদীর সমস্ত মাছ মারা গেল এবং নদীর জলে দুর্গন্ধ ছড়াতে শুরু করল| ফলে মিশরীয়রা আর সেই নদীর জল পান করতে পারল না| মিশরের সমস্ত জলাধারের জলই রক্তে পরিণত হল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","হারোণ ও মোশির মতো রাজার যাদুকররাও তাদের মায়াবলে একই ঘটনা ঘটিয়ে প্রমাণ করল তারাও কম জানে না| ফলে প্রভুর ভবিষ্যদ্বাণী অনুযায়ীফরৌণ আবার মোশি ও হারোণের কথা শুনতে অস্বীকার করলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ফরৌণ মোশি ও হারোণের ঐ কথায় মনোযোগ না দিয়ে নিজের প্রাসাদে ঢুকে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","মিশরীয়রা নদীর জল পান করতে না পেরে তারা পানীয় জলের সন্ধানে নদীর চারপাশে কুঁয়ো খুঁড়তে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","প্রভুর নীলনদের জলকে রক্তে পরিণত করার পর সাতদিন পার হল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","প্রভু তখন মোশির উদ্দেশ্যে বললেন, “ফরৌণকে গিয়ে বলো যে প্রভু বলেছেন, ‘আমার লোকেদের আমাকে উপাসনার জন্য ছেড়ে দাও! ");
INSERT INTO ben2006_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","যদি তুমি ওদের ছেড়ে না দাও তাহলে আমি মিশর দেশ ব্যাঙে ভর্ত্তি করে দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","নীল নদ ব্যাঙে ভর্ত্তি হয়ে উঠবে| নদী থেকে ব্যাঙরা উঠে এসে তোমার ঘরে শয্যাকক্ষে প্রবেশ করে বিছানায় উঠে বসবে| তোমার উনুনের চুল্লি, জলের পাত্র ব্যাঙে ভরে যাবে| তোমার সভাসদগণের ঘরও ব্যাঙে পরিপূর্ণ হয়ে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","তোমাদের চারিদিকে ব্যাঙরা ঘুরে বেড়াবে| তোমার সভাসদগণ, তোমার লোকদের এবং তোমার গায়েও ব্যাঙ ছেঁকে ধরবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","প্রভু এরপর মোশিকে বললেন, “তুমি হারোণকে বলো সে যেন তার হাতের পথ চলার লাঠি নদী, খালবিল ও হ্রদের ওপর বিস্তার করে মিশর দেশে ব্যাঙ এনে ভরিয়ে দেয়|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","হারোণ মিশরের জলের ওপর তার লাঠি সমেত হাত বিস্তার করতেই নদী, খালবিল ও হ্রদ থেকে রাশি রাশি ব্যাঙ উঠে মিশরের মাটি ঢেকে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","হারোণের সঙ্গে পাল্লা দিতে গিয়ে রাজার যাদুকররাও তাদের মায়াজাল বিস্তার করে একই কাণ্ড ঘটিয়ে দেখাল| ফলে মিশরের মাটিতে আরও অসংখ্য ব্যাঙ উঠে এলো| ");
INSERT INTO ben2006_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ফরৌণ এবার বাধ্য হয়ে মোশি এবং হারোণকে ডেকে পাঠিয়ে তাদের বললেন, “প্রভুকে বলো তিনি যেন আমাকে এবং আমার লোকদের এই ব্যাঙের উপদ্রব থেকে রেহাই দেন| আমি প্রভুকে নৈবেদ্য উৎসর্গ করার জন্য লোকদের যাবার ছাড়পত্র দেব|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","মোশি ফরৌণকে বলল, “বলুন, আপনি কখন চান যে এই ব্যাঙরা ফিরে যাক্| আমি আপনার জন্য, আপনার সভাসদগণ ও প্রজাদের জন্য তাহলে প্রার্থনা করব| তারপরই ব্যাঙরা আপনাকে এবং আপনার ঘর ছেড়ে নদীতে ফিরে যাবে| ব্যাঙরা নদীতেই থাকে| বলুন আপনি কবে এই ব্যাঙদের উপদ্রব থেকে অব্যাহতি চান?” ");
INSERT INTO ben2006_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","উত্তরে ফরৌণ জানালেন, “আগামীকাল|” মোশি বলল, “বেশ আপনার কথা মতো তাই হবে| তবে এবার নিশ্চয়ই আপনি বুঝতে পেরেছেন যে আমাদের প্রভু ঈশ্বরের মতো আর কোন ঈশ্বর এখানে নেই| ");
INSERT INTO ben2006_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ব্যাঙরা আপনাকে, আপনার ঘর এবং আপনার সভাসদগণ ও প্রজাদের সবাইকে ছেড়ে ফিরে যাবে| কেবলমাত্র নদীতেই তারা এবার থেকে বাস করবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","এরপর মোশি এবং হারোণ ফরৌণের কাছ থেকে ফিরে এলো| ফরৌণের বিরুদ্ধে পাঠানো সমস্ত ব্যাঙদের সরিয়ে নেবার জন্য মোশি প্রভুর কাছে প্রার্থনা করল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","মোশির প্রার্থনায় সাড়া দিয়ে প্রভু ঘরে, বাইরে, মাঠে ঘাটের সমস্ত ব্যাঙকে মেরে ফেললেন| ");
INSERT INTO ben2006_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","কিন্তু মৃত ব্যাঙের স্তূপ পচতে শুরু করল এবং সারা দেশ দুর্গন্ধে ভরে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ব্যাঙদের উপদ্রব থেকে মুক্তি পাওয়ার পরই ফরৌণ আবার একগুঁয়ে ও জেদী হয়ে উঠলেন| প্রভুর ভবিষ্যদ্বাণী অনুযায়ীমোশি ও হারোণকে দেওয়া প্রতিশ্রুতি রাজা পালন করলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","প্রভু তখন মোশিকে বললেন, “হারোণকে বলো তার হাতের লাঠি দিয়ে মাটির ধূলোয় আঘাত করতে, এবং তারপর সেই ধূলো মিশরের সর্বত্র উকুনে পরিণত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","হারোণ প্রভুর কথামতো ধূলোতে তার লাঠি আঘাত করতেই মিশরের সর্বত্র ধূলো উকুনে পরিণত হল| এবং সেই উকুনগুলো মানুষ ও পশুদের গায়ের ওপর চড়ে বসল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","রাজার যাদুকররা এবারও একই জিনিস করে দেখানোর চেষ্টা করল কিন্তু তারা কিছুতেই ধূলোকে উকুনে পরিণত করতে পারল না| কিন্তু সেই উকুনগুলো মানুষ ও পশুদের শরীরে রয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","যাদুকররা এবারে ব্যর্থ হয়ে গিয়ে রাজা ফরৌণকে বলল যে ঈশ্বরের শক্তিই এটাকে সম্ভব করেছে| কিন্তু ফরৌণ তাদের কথাতে কান দিলেন না| প্রভুর ভবিষ্যদ্বাণী অনুসারেই অবশ্য এই ঘটনা ঘটল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","প্রভু মোশিকে বললেন, “সকালে উঠে ফরৌণের কাছে যাবে| ফরৌণ নদীর তীরে যাবে| তখন তাকে বলবে প্রভু বলেছেন, ‘আমার উপাসনার জন্য আমার লোকদের ছেড়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","যদি তুমি তাদের ছেড়ে না দাও তাহলে তোমার ঘরে মাছির ঝাঁক ঢুকবে| শুধু তোমার ঘরেই নয় তোমার সভাসদগণ ও তোমার প্রজাদের ঘরেও মাছির ঝাঁক ঢুকবে| মিশরের প্রত্যেকটি ঘর মাছির ঝাঁকে পরিপূর্ণ হয়ে উঠবে| মিশরের মাঠে ঘাটে সর্বত্র শুধু ঝাঁকে ঝাঁকে মাছি উড়ে বেড়াবে! ");
INSERT INTO ben2006_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","কিন্তু মিশরীয়দের মতো ইস্রায়েলের লোকদের আমি এই যন্ত্রণা ভোগ করাবো না| গোশন প্রদেশে, যেখানে আমার লোকরা বাস করে, সেখানে একটিও মাছি থাকবে না| কারণ সেখানে আমরা লোকরা বাস করে| এর ফলে তুমি বুঝতে পারবে যে এই দেশে আমিই হলাম প্রভু| ");
INSERT INTO ben2006_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","সুতরাং আগামীকাল থেকেই তুমি আমার এই বিভেদ নীতির প্রমাণ পাবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","সুতরাং প্রভু তাই করলেন যা তিনি বলেছিলেন| ঝাঁকে ঝাঁকে মাছি মিশরে এসে গেল| ফরৌণের বাড়ী এবং তাঁর সভাসদগণের বাড়ী মাছিতে ভরে গেল| মাছিগুলোর জন্য সমগ্র মিশর ধ্বংস হল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ফরৌণ মোশি এবং হারোণকে ডেকে বললেন, “তোমরা তোমাদের ঈশ্বরকে এই দেশের মধ্যেই নৈবেদ্য উৎসর্গ করো|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","কিন্তু মোশি বলল, “না, তা এখানে করা ঠিক হবে না| কারণ প্রভু, আমাদের ঈশ্বরের উদ্দেশ্যে পশু বলিদান মিশরীয়দের চোখে ভয়ঙ্কর ব্যাপার| আমরা যদি এখানে তা করি তাহলে মিশরীয়রা আমাদের দেখতে পেয়ে পাথর ছুঁড়ে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","তাই তিন দিনের জন্য আমাদের প্রভু ঈশ্বরের উদ্দেশ্যে নৈবেদ্য উৎসর্গ করার জন্য আমাদের মরুপ্রান্তরে যেতে দিন| প্রভুই আমাদের এটা করতে বলেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","সব শুনে ফরৌণ বললেন, “বেশ আমি তোমাদের মরুপ্রান্তরে যাবার ছাড়পত্র দিচ্ছি তোমাদের প্রভু ঈশ্বরের উদ্দেশ্যে নৈবেদ্য উৎসর্গ করার জন্য| কিন্তু মনে রেখো তোমরা কিন্তু বেশী দূরে চলে যাবে না| এখন যাও এবং আমার জন্য প্রার্থনা করো|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","তখন মোশি ফরৌণকে বলল, “দেখুন, আমি যাব এবং প্রভুকে অনুরোধ করব যাতে আগামীকাল তিনি আপনার কাছ থেকে, আপনার লোকদের কাছ থেকে এবং আপনার সভাসদগণের কাছ থেকে মাছিগুলো সরিয়ে নেন| কিন্তু আপনি যেন আবার আগের মতো প্রভুকে নৈবেদ্য উৎসর্গ করার বিষয়টি নিয়ে পরে আপত্তি করবেন না|” ");
INSERT INTO ben2006_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","এই কথা বলে মোশি ফরৌণের কাছ থেকে ফিরে এল এবং প্রভুর কাছে প্রার্থনা করল| ");
INSERT INTO ben2006_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","এবং মোশির প্রার্থনায়় সাড়া দিয়ে প্রভু ফরৌণকে, সভাসদগণ ও প্রজাদের মাছির উপদ্রব থেকে রক্ষা করলেন| মিশর থেকে মাছিদের বার করে দিলেন| আর একটি মাছিও সেখানে রইল না| ");
INSERT INTO ben2006_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","কিন্তু ফরৌণ আবার জেদী হয়ে গেলেন এবং লোকদের যেতে দিলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","তারপর প্রভু মোশিকে বললেন, ফরৌণকে গিয়ে বল, “প্রভু, ইস্রায়েলীয়দের ঈশ্বর বলেছেন, ‘আমার লোকদের আমার উপাসনা করার জন্য ছেড়ে দাও|’ ");
INSERT INTO ben2006_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","তুমি যদি তাদের ধরে রাখো এবং যেতে বাধা দাও ");
INSERT INTO ben2006_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","তাহলে প্রভু তোমার গবাদি পশুদের ওপর তাঁর ক্ষমতা প্রয়োগ করবেন| তোমার সমস্ত ঘোড়া, গাধা, উট, গরু ও মেষের পাল প্রভুর কোপে এক ভয়ঙ্কর রোগের শিকার হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","কিন্তু প্রভু মিশরের পশুদের মতো ইস্রায়েলের পশুদের দুর্দশাগ্রস্ত করবেন না| ইস্রায়েলের লোকদের কোনও পশু মারা যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","আগামীকাল এই ঘটনা ঘটাবার জন্য প্রভু সময় স্থির করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","পরদিন, প্রভু যেমন বলেছিলেন তেমন করলেন| মিশরীয়দের সমস্ত গৃহপালিত পশু মারা গেল| কিন্তু ইস্রায়েলের লোকদের কোনও পশু মারা গেল না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ইস্রায়েলীয়দের কোনও পশু মারা গেছে কিনা তা দেখে আসতে ফরৌণ তাঁর কর্মচারীদের পাঠালেন এবং সে জানতে পারলো যে ইস্রায়েলীয়দের একটি পশুও মারা যায় নি| কিন্তু তবুও ফরৌণ তাঁর জেদ ধরে রইলেন এবং লোকদের যেতে দিলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","প্রভু মোশি এবং হারোণকে বললেন, “একটা উনুন থেকে এক মুঠো ছাই নাও| মোশি তুমি সেই ছাই ফরৌণের সামনে বাতাসে ছুঁড়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","এই ছাই ধূলিকণা হয়ে সারা মিশরে ছড়িয়ে পড়বে| এবং যখনই এই ধূলো মিশরের কোনও মানুষ বা পশুর গায়ে পড়বে তখনই তাদের গায়ে ফোঁড়া হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","তাই মোশি ও হারোণ উনুন থেকে ছাই নিয়ে ফরৌণের সামনে দাঁড়াল| মোশি সেই ছাই আকাশে ছুঁড়ে দিল আর পশু ও মানুষের গায়ে ফোঁড়া বার হতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","যাদুকররা মোশির সঙ্গে প্রতিযোগিতা করতে পারল না| কারণ তাদেরও সারা গায়ে ফোঁড়া ছিল| মিশরের প্রতিটি জায়গায় এই রোগ দেখা দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","কিন্তু এতে প্রভু ফরৌণকে আরও উদ্ধত করে তুললেন| তাই ফরৌণ তাদের কথা শুনতে অস্বীকার করলেন| প্রভুর কথামতোই এসব ঘটেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","এরপর প্রভু, ইস্রায়েলীয়দের ঈশ্বর মোশিকে বললেন, “সকালে উঠে ফরৌণের কাছে গিয়ে বলবে, প্রভু ঈশ্বর বলেছেন, ‘আমার লোকদের আমার উপাসনা করতে যেতে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","যদি তুমি তা না কর, তবে তোমাকে তোমার সমস্ত রাজকর্মচারীদের এবং লোকদের সমস্ত রকমের দুর্ভোগ ভুগতে হবে| তখন তুমি জানবে যে এই পৃথিবীতে আমার মতো ঈশ্বর আর নেই, ");
INSERT INTO ben2006_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","আমি আমার ক্ষমতা দিয়ে তোমাদের এমন রোগ দিতে পারি যা তোমাদের পৃথিবী থেকে মুছে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","কিন্তু আমি তোমাদের একটা কারণে এখানে রেখেছি| আমি তোমাদের আমার ক্ষমতা দেখানোর জন্য রেখেছি| যাতে সারা পৃথিবীর লোক আমার কথা শুনতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","তুমি এখনও আমার লোকদের সঙ্গে বিরোধিতা করছ এবং তাদের যেতে দিচ্ছ না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","তাই আগামীকাল এই সময় আমি এক ভয়ঙ্কর শিলাবৃষ্টি ঘটাবো| মিশরের শুরু থেকে আজ পর্যন্ত এই রকম ভয়ঙ্কর শিলাবৃষ্টি আর কখনও হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","এখন তুমি তোমার পশুদের একটি নিরাপদ স্থানে নিয়ে যাও| তোমার ক্ষেতে যা কিছু আছে সব একটি নিরাপদ স্থানে নিয়ে যাও| কেন? কারণ কোন লোক যদি ক্ষেতে পড়ে থাকে, তবে সে মারা যাবে; যদি কোন পশু মাঠে পড়ে থাকে সে মারা যাবে| তোমার বাড়ীর বাইরে যা কিছু পড়ে থাকবে সে সব কিছুর ওপরেই শিলাবৃষ্টি হবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ফরৌণের সেই কর্মচারীরা যারা প্রভুর বার্তাকে গুরুত্ব দিয়েছিল তারা তাদের পশু ও ক্রীতদাসদের ক্ষেত থেকে নিয়ে এলো এবং ঘরে রেখে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","কিন্তু যে সব কর্মচারীরা প্রভুর বার্তা অগ্রাহ্য করেছিল তারা তাদের ক্রীতদাসদের ও পশুদের মাঠে রেখে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","প্রভু মোশিকে বললেন, “তোমার হাত আকাশের দিকে তুলে ধরো, তাহলে মিশরের ওপর শিলাবৃষ্টি শুরু হয়ে যাবে| মিশরের সমস্ত ক্ষেতের মানুষ, পশু ও গাছপালার ওপর এই শিলাবৃষ্টি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","তাই মোশি তার হাতের ছড়ি আকাশের দিকে তুলল, তারপর প্রভু ভূমির ওপর বজ্রনির্ঘোষ, শিলাবৃষ্টি ও অশনি ঘটালেন| সারা মিশরে শিলাবৃষ্টি হল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","শিলাবৃষ্টি হচ্ছিল এবং চারিদিকে বিদ্যুত চমকাচ্ছিল| এই ধরণের ভয়ঙ্কর শিলাবৃষ্টি মিশরের শুরু থেকে আজ পর্যন্ত আগে কখনও হয়নি| ");
INSERT INTO ben2006_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","এই শিলাবৃষ্টি মিশরের ক্ষেতের সমস্ত কিছু, লোকজন ও পশুসহ গাছপালা ধ্বংস করে দিল| এই শিলাবৃষ্টিতে মাটির সমস্ত গাছ ভেঙ্গে পড়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","একমাত্র ইস্রায়েলের লোকদের বাসস্থান গোশন প্রদেশে শিলাবৃষ্টি হল না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ফরৌণ মোশি ও হারোণকে ডেকে বললেন, “এইবার বুঝেছি যে আমি পাপ করেছি| প্রভুই ঠিক ছিলেন| আমি ও আমার লোকরা ভুল করেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","প্রভুর দেওয়া শিলাবৃষ্টি ও বজ্রপাত আর সহ্য হচ্ছে না| ঈশ্বরকে গিয়ে এই ঝড় থামাতে বল| তাহলে আমি তোমাদের যেতে দেব, তোমাদের আর এখানে থাকতে হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","মোশি ফরৌণকে বললেন, “আমি যখন শহর ত্যাগ করে যাবো তখন আমি প্রভুকে প্রার্থনার ভঙ্গীতে আমার হাতগুলো ওপরে তুলব| এবং তারপর বজ্রপাত ও শিলাবৃষ্টি থামবে| তখন তুমি জানবে যে এই পৃথিবী প্রভুর অধিকারে| ");
INSERT INTO ben2006_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","কিন্তু আমি জানি যে তুমি এবং তোমার কর্মচারীরা এখনও প্রভুকে শ্রদ্ধা করো না|” ");
INSERT INTO ben2006_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","য়ব ও শন গাছে ফুল এসে গিয়েছিল| তাই এই সমস্ত শস্য নষ্ট হয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","কিন্তু যেহেতু গম ও জনার বড় হল না তাই সেগুলো নষ্ট হল না| ");
INSERT INTO ben2006_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","মোশি ফরৌণের কাছে থেকে শহরের বাইরে গেল, প্রভুকে প্রার্থনা করার ভঙ্গীতে তার হাতগুলো ওপরে তুলল এবং তৎক্ষণাৎ বজ্র, শিলাবৃষ্টি এমনকি বৃষ্টিও থেমে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","যখন ফরৌণ দেখলেন বৃষ্টি, বজ্রপাত ও শিলাবৃষ্টি থেমে গিয়েছে তখন তিনি আবার ভুল করলেন| তিনি ও তার কর্মচারীরা জেদী হয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ফরৌণ উদ্ধত হলেন এবং ইস্রায়েলের লোকদের যেতে দিতে অস্বীকার করলেন| এসবই হয়েছিল ঠিক প্রভু যেমন মোশিকে বলেছিলেন সেইরকম ভাবেই| ");
INSERT INTO ben2006_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","তারপর প্রভু মোশিকে বললেন, “ফরৌণের কাছে যাও, আমি তাকে ও তার কর্মচারীদের জেদী করে তুলেছি যাতে আমি আমার অলৌকিক শক্তি তাদের দেখাতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","আমি এটা এই কারণেও করেছি যাতে তোমরা, তোমাদের সন্তান এবং নাতি-নাতনিদের আমি মিশরীয়দের বিরুদ্ধে কি কি করেছিলাম এবং মিশরে কেমন করে চিহ্ন-কার্যগুলি করেছিলাম তার সম্বন্ধে বলতে পারো| তাহলে তোমরা সবাই জানতে পারবে যে আমিই প্রভু|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","তাই মোশি ও হারোণ ফরৌণের কাছে গেল এবং বলল, “প্রভু, ইস্রায়েলীয়দের ঈশ্বর বলেছেন, ‘তুমি আর কতদিন প্রভুকে অমান্য করবে? আমার লোকদের আমার উপাসনা করতে যেতে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","তুমি যদি আমার আদেশ অমান্য কর তবে আগামীকাল আমি তোমাদের এই দেশে পঙ্গপাল নিয়ে আসব| ");
INSERT INTO ben2006_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","পঙ্গপালরা সারা দেশ ঢেকে ফেলবে, চারিদিকে এত পঙ্গপাল আসবে যে তোমরা মাটি দেখতে পাবে না| শিলাবৃষ্টির হাত থেকে যা কিছু বেঁচে গিয়েছে সেসব পঙ্গপালরা খেয়ে ফেলবে, মাঠের প্রত্যেকটি গাছের সমস্ত পাতা এই পঙ্গপালরা খেয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","তোমার সমস্ত ঘর, তোমার কর্মচারীদের ঘর এবং মিশরের সব ঘর পঙ্গপালে ভরে যাবে| এত পঙ্গপাল হবে যা তোমার পিতামাতা অথবা তোমার পিতামহরা কখনও দেখে নি| মিশরে জনবসতি গড়ে ওঠার সময় থেকে আজ পর্যন্ত এত পঙ্গপাল আর কখনও কেউ দেখে নি|’” তারপর মোশি পিছন ফিরে ফরৌণকে ছেড়ে চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","এরপর ফরৌণের কর্মচারীরা তাঁকে জিজ্ঞাসা করল, “আর কতদিন আমরা এই লোকদের ফাঁদে পড়ে থাকব? এদের ঈশ্বর, প্রভুর উপাসনা করতে যেতে দিন, আপনি যদি তা না করেন তবে আপনার বোঝার আগেই মিশর ছারখার হয়ে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","তখন ফরৌণ তাঁর কর্মচারীদের বললেন মোশি ও হারোণকে ফিরিয়ে আনতে| তারা এলে ফরৌণ তাদের বললেন, “যাও, তোমরা তোমাদের প্রভু ঈশ্বরের উপাসনা কর| কিন্তু আমাকে বলে যাও ঠিক কারা কারা যাচ্ছে?” ");
INSERT INTO ben2006_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মোশি উত্তর দিল, “আমাদের সমস্ত লোক, যুবক ও বৃদ্ধ সকলেই যাবে| আমরা আমাদের পুত্রদের, কন্যাদের, মেষ, গবাদি পশু এবং প্রত্যেকটি জিনিস আমাদের সঙ্গে নিয়ে যাব| কারণ প্রভু আমাদের সকলকেই উৎসবে আমন্ত্রণ করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ফরৌণ তাদের বললেন, “আমি তোমাদের ও তোমাদের সন্তানদের মিশরে ছেড়ে যেতে দেওয়ার আগে প্রভুকে সত্যিই তোমাদের সঙ্গে থাকতে হবে! দেখ তোমাদের নিশ্চয়ই কোন কু-মতলব আছে| ");
INSERT INTO ben2006_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","শুধুমাত্র পুরুষরাই প্রভুর উপাসনা করতে পারবে কারণ প্রথমে তোমরা একথাই বলেছিলে| কিন্তু তোমাদের সব লোক যেতে পারবে না|” এরপর ফরৌণ মোশি ও হারোণকে বিদায় দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","প্রভু এবার মোশিকে বললেন, “তুমি মিশরের ওপর তোমার হাত মেলে দাও| তাতে পঙ্গপালরা আসবে| সারা মিশর পঙ্গপালে ভরে যাবে| শিলাবৃষ্টিতে যে সব গাছ নষ্ট হয় নি সেগুলি পঙ্গপাল খেয়ে ফেলবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","মোশি তার হাতের ছড়ি মিশরের ওপর তুলে ধরল| এবং প্রভু পূর্ব দিক থেকে এক প্রবল বাতাস পাঠালেন| সারা দিন সারা রাত ধরে সেই হাওয়া বয়ে গেল| এবং সকালবেলা সেই হাওয়ায় পঙ্গপালরা এসে মিশরে ঢুকে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","পঙ্গপালরা উড়ে এসে মিশরের মাটিতে বসল| এত পঙ্গপাল ইতিপূর্বে কখনও মিশরে দেখা যায় নি আর বোধ হয় পরবর্তী কালেও কখনও দেখা যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","পঙ্গপালরা মাটি ঢেকে ফেলল এবং সারা দেশ অন্ধকার হয়ে গেল| শিলাবৃষ্টি যা ধ্বংস করে নি সে সমস্ত গাছ এবং গাছের ফল পঙ্গপাল খেয়ে ফেলল, মিশরের কোথাও কোনও গাছ বা লতা-পাতাও অবশিষ্ট রইল না| ");
INSERT INTO ben2006_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ফরৌণ তাড়াতাড়ি মোশি ও হারোণকে ডেকে পাঠিয়ে বললেন, “আমি তোমাদের ও তোমাদের প্রভু ঈশ্বরের কাছে পাপ করেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","এবারকার মতো আমার অপরাধ ক্ষমা করে দাও| তোমাদের প্রভুকে বল এই পঙ্গপালগুলোকে সরিয়ে নিতে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","মোশি ফরৌণের কাছ থেকে চলে গেল এবং প্রভুর কাছে তার জন্য প্রার্থনা করল| ");
INSERT INTO ben2006_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","প্রভু হাওয়ার দিক পরিবর্তন করে পশ্চিম দিক থেকে বাতাস পাঠালেন, এই প্রবল হাওয়ায় সমস্ত পঙ্গপাল মিশর থেকে বেরিয়ে গিয়ে সূফ সাগরে পড়ল| মিশরে আর একটিও পঙ্গপাল রইল না| ");
INSERT INTO ben2006_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","কিন্তু প্রভু আবার ফরৌণকে জেদী করে তুললেন এবং ফরৌণ ইস্রায়েলের লোকদের যেতে দিলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","তারপর প্রভু মোশিকে বললেন, “তোমার হাত উপরে আকাশের দিকে তুলে দাও যাতে সারা মিশর অন্ধকারে ঢেকে যায়| অন্ধকার এত গাঢ় হবে যে তোমরা তা অনুভব করতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","তাই মোশি আকাশের দিকে হাত তুলল, তখন কালো মেঘ এসে মিশরকে ঢেকে ফেলল| তিন দিন ধরে এই অন্ধকার রইল| ");
INSERT INTO ben2006_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","কেউ কাউকে দেখতে পেল না বা কেউ উঠে কোথাও যেতে পারল না| কিন্তু ইস্রায়েলীয়রা যেখানে বাস করত সেখানে আলো ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","আবার ফরৌণ মোশিকে ডেকে পাঠিয়ে বললেন, “যাও গিয়ে তোমাদের প্রভুর উপাসনা কর| তোমরা তোমাদের সন্তানদের নিয়ে যেতে পারবে কিন্তু গরু বা মেষের দল নিতে পারবে না, এখানে রেখে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","মোশি বলল, “না, আমাদের প্রভু ঈশ্বরকে উৎসর্গ এবং হোমবলি দেওয়ার জন্য আপনাকে আমাদের পশুসমূহ দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","হ্যাঁ, এবং আমরা আমাদের পশুসমূহ প্রভুর উপাসনার জন্য নিয়ে যাব| আমরা একটা ক্ষুরও ফেলে যাব না| কারণ আমরা জানি না আমাদের প্রভু ঈশ্বরের উপাসনার জন্য ঠিক কি কি লাগবে| একথা আমরা আমাদের গন্তব্যস্থলে পৌঁছে জানতে পারব| তাই আমরা এ সবকিছুই সঙ্গে নিয়ে যাব|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","প্রভু আবার ফরৌণকে জেদী করে তুললেন এবং ফরৌণ তাদের যেতে বাধা দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ফরৌণ মোশিকে বললেন, “এখান থেকে দুর হয়ে যাও, আর কখনও যেন এখানে তোমাকে না দেখি, যদি তুমি এখানে আমার কাছে দেখা করতে আসো তবে তোমায় মরতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","তখন মোশি বলল, “তুমি একটা কথা ঠিকই বলেছো, আমি আর কখনও তোমার কাছে আসব না|” ");
INSERT INTO ben2006_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","প্রভু তখন মোশিকে বললেন, “মিশর এবং ফরৌণের বিরুদ্ধে আমি আরেকটি বিপর্যয় বয়ে আনব| তারপর, সে তোমাদের সবাইকে পাঠিয়ে দেবে| বস্তুত সে তোমাদের চলে যেতে বাধ্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","তুমি ইস্রায়েলের লোকদের এই বার্তা পাঠাবে: ‘নারী ও পুরুষ নির্বিশেষে তোমরা নিজের নিজের প্রতিবেশীদের কাছ থেকে সোনা ও রূপোর অলঙ্কার চাইবে| ");
INSERT INTO ben2006_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","প্রভু মিশরীয়দের তোমাদের প্রতি দয়ালু করে তুলবেন| মিশরের লোকরা, এমনকি ফরৌণের কর্মচারীরা মোশিকে এক মহান ব্যক্তির মর্যাদা দেবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","মোশি লোকদের জানাল, “প্রভু বলেছেন, ‘আজ মধ্যরাত নাগাদ আমি মিশরের মধ্যে দিয়ে যাব| ");
INSERT INTO ben2006_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","এবং তার ফলে মিশরীয়দের সমস্ত প্রথমজাত পুত্ররা মারা যাবে| রাজা ফরৌণের প্রথমজাত পুত্র থেকে শুরু করে যাঁতাকলে শস্য পেষনকারিণী দাসীর প্রথমজাত পুত্র পর্যন্ত সবাই মারা যাবে| এমনকি পশুদেরও প্রথম শাবক মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","তারপর সমস্ত মিশরে এমন জোরে কান্নার রোল উঠবে যা অতীতে কখনও হয় নি এবং যা ভবিষ্যতেও কখনও হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","কিন্তু ইস্রায়েলের লোকদের কোনরকম ক্ষতি হবে না| এমন কি কোনো কুকুর পর্যন্ত ইস্রায়েলীয়দের অথবা তাদের পশুদের দিকে ঘেউ ঘেউ করে চিৎকার করবে না|’ এর ফলে, তোমরা বুঝতে পারবে আমি মিশরীয়দের থেকে ইস্রায়েলীয়দের সঙ্গে কতখানি অন্যরকম আচরণ করি| ");
INSERT INTO ben2006_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","তখন তোমাদের সমস্ত (মিশরীয় কর্মচারীরা) নতজানু হবে এবং আমার উপাসনা করবে| তারা বলবে, ‘তুমি তোমার সমস্ত লোককে তোমার সঙ্গে নিয়ে চলে যাও|’ তখন মোশি ক্রোধে ফরৌণকে ছেড়ে চলে গেল|” ");
INSERT INTO ben2006_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","প্রভু এরপর মোশিকে আরও বললেন যে, “ফরৌণ তোমার কথা শোনে নি| কেন শোনে নি? শোনে নি বলেই তো আমি মিশরের ওপর আমার মহাশক্তির প্রভাব দেখাতে পেরেছিলাম|” ");
INSERT INTO ben2006_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","মোশি ও হারোণ ফরৌণের কাছে গিয়েছিল এবং এই সমস্ত অলৌকিক কাজগুলো করেছিল| কিন্তু প্রভু ফরৌণের হৃদয়কে উদ্ধত করেছিলেন যাতে সে ইস্রায়েলীয়দের তার দেশ থেকে যেতে না দেয়| ");
INSERT INTO ben2006_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","মোশি ও হারোণ মিশরে থাকার সময় প্রভু তাদের বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“এই মাস হবে তোমাদের জন্য বছরের প্রথম মাস। ");
INSERT INTO ben2006_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","এই আদেশ সমস্ত ইস্রায়েলবাসীর জন্য: এই মাসের দশম দিনে প্রত্যেকে তার বাড়ীর জন্য একটি করে পশু জোগাড় করবে| পশুটি একটি মেষ অথবা একটি ছাগলও হতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","যদি তার বাড়ীতে একটি গোটা পশুর মাংস খাওয়ার মতো যথেষ্ট লোক না থাকে তবে সে তার কিছু প্রতিবেশীকে মাংস ভাগ করে খাওয়ার জন্য নিমন্ত্রণ করবে| প্রত্যেকের খাওয়ার জন্য যথেষ্ট মাংস থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","পশুটিকে হতে হবে একটি এক বছরের পুংশাবক এবং সম্পূর্ণরূপে স্বাস্থ্যবান| ");
INSERT INTO ben2006_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","মাসের চতুর্দশ দিন পর্যন্ত এই পশুটির ওপর তোমাদের নজর রাখতে হবে| সেই দিন ইস্রায়েলীয় মণ্ডলীর সমস্ত লোকরা এই পশুটিকে গোধুলি বেলায় হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","তোমরা এই প্রাণীর রক্ত সংগ্রহ করে, যে বাড়ীতে লোকরা ভোজ খাবে সেই বাড়ীর দরজার কাঠামোর ওপরে ও পাশে এই রক্ত লাগিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“এই দিন রাতে তোমরা মেষটিকে পুড়িয়ে তার মাংস খাবে| তোমরা তেঁতো শাক ও খামিরবিহীন রুটিও খাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","মেষটিকে কাঁচা অথবা জলে সিদ্ধ করা অবস্থায় তোমাদের খাওয়া উচিৎ‌ হবে না, কিন্তু আগুনের তাপে সেঁকবে| মেষশাবকটির মাথা, পা এবং ভিতরের অংশ সব কিছুই অক্ষুন্ন থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","তোমরা সব মাংস রাতের মধ্যেই খেয়ে শেষ করবে| যদি পরদিন সকালে কিছু অবশিষ্ট থাকে তবে তা পুড়িয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“যখন তোমরা আহার করবে তখন তোমরা যাত্রার জন্য পুরোপুরি প্রস্তুত হয়ে থাকার পোশাকে থাকবে| তোমাদের পায়ে জুতো থাকবে, হাতে ছড়ি থাকবে এবং তোমরা তাড়াহুড়ো করে খাবে| কারণ এ হল প্রভুর নিস্তারপর্ব| ");
INSERT INTO ben2006_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“আমি মিশরীয়দের প্রথমজাত শিশুগুলিকে এবং তাদের সমস্ত পশুর প্রথমজাত শাবকগুলিকে হত্যা করব| এইভাবে, আমি মিশরের সমস্ত দেবতাদের ওপর রায় দেব যাতে তারা জানতে পারে যে আমিই প্রভু| ");
INSERT INTO ben2006_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","কিন্তু তোমাদের দরজায় লাগানো রক্ত একটি বিশেষ চিহ্নের কাজ করবে| যখন আমি ঐ রক্ত দেখব তখন আমি তোমাদের বাড়ীগুলোর ওপর দিয়ে চলে যাব| আমি শুধু মিশরের লোকদের ক্ষতি করব| এই সব মারাত্মক রোগে তোমাদের কোন ক্ষতি হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“তাই তোমরা সবসময় মনে রাখবে যে আজ তোমাদের একটি বিশেষ ছুটির দিন| তোমাদের উত্তরপুরুষরা এই ছুটির দিনের মাধ্যমে প্রভুকে সম্মান জানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","এই ছুটিতে তোমরা সাতদিন ধরে খামিরবিহীন রুটি খাবে, ছুটির প্রথম দিনে তোমরা তোমাদের বাড়ী থেকে সমস্ত খামির সরিয়ে ফেলবে| এই ছুটিতে পুরো সাত দিন ধরে কেউ কোন খামির খাবে না| যদি কেউ সেটা খায় তবে সেই ব্যক্তিকে ইস্রায়েলীয়দের থেকে আলাদা করে দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","এই ছুটির প্রথম ও শেষ দিনে পবিত্র সমাগম অনুষ্ঠিত হবে| তোমরা এই দিনগুলোতে কোন কাজ করবে না| তোমরা এই দিনগুলিতে একমাত্র তোমাদের আহারের জন্য খাদ্য তৈরী করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","তোমরা খামিরবিহীন রুটির উৎসবের কথা মনে রাখবে| কেন? কারণ এই দিন আমি তোমাদের সব লোককে দলে দলে মিশর থেকে বের করে এনেছিলাম, তাই তোমাদের সব উত্তরপুরুষ এই দিনটি স্মরণ করবে, এই নিয়ম চিরকাল থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","তাই প্রথম মাসের চতুর্দশ দিন বিকেলে তোমরা খামিরবিহীন রুটি খাওয়া শুরু করবে| তোমরা ঐ রুটিটি ঐ মাসের একবিংশ দিনের সন্ধ্যা পর্যন্ত খাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","সাতদিন ধরে তোমাদের ঘরে কোন খামির থাকবে না, যে কোন ব্যক্তি সে ইস্রায়েলের নাগরিক হোক্ বা বিদেশী যে এই সময় খামির খাবে তাকে ইস্রায়েলের বাকি লোকদের থেকে আলাদা করে দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","এই ছুটিতে তোমরা অবশ্যই খামির খাবে না, তোমরা যেখানেই থাক না কেন খামিরবিহীন রুটি খাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","তাই মোশি ইস্রায়েলীয়দের সমস্ত প্রবীণদের ডেকে বলল, “তোমাদের পরিবারের জন্য মেষশাবক জোগাড় কর এবং নিস্তারপর্বের জন্য মেষশাবকটিকে হত্যা কর| ");
INSERT INTO ben2006_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","এক আঁটি করে এসোব নিয়ে পাত্রে রাখা রক্তে ডুবিয়ে তা দিয়ে দরজার কাঠামোর ওপর ও পাশের দিক রঙ করো| সকালের আগে কেউ নিজের বাড়ী ত্যাগ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","এই সময়, প্রভু মিশরের ভেতর দিয়ে মিশরীয়দের হত্যা করতে যাবেন| যখন তিনি দরজার কাঠামোর পাশে ও ওপরে রক্তের প্রলেপ দেখবেন, তখন তিনি সেই দরজাগুলোর ওপর দিয়ে যাবেন| প্রভু ধ্বংসকারীকে তোমাদের বাড়ীতে এসে আঘাত করতে দেবেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","তোমরা অবশ্যই এই আদেশ মনে রাখবে, এই নিয়ম তোমাদের ও তোমাদের উত্তরপুরুষদের জন্য চিরকাল থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","যখন তোমরা প্রভুর প্রতিশ্রুতি মত তাঁর দেওয়া ভূখণ্ডে যাবে তখন তোমাদের এই জিনিসগুলি অবশ্যই মনে রাখতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","যখন তোমাদের সন্তানরা জিজ্ঞাসা করবে, ‘আমরা কেন এই উৎসব করছি?’ ");
INSERT INTO ben2006_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তখন তোমরা বলবে, ‘এই নিস্তারপর্ব প্রভুকে সম্মান জানাবার জন্য| কেন? কারণ যখন আমরা মিশরে ছিলাম তখন প্রভু আমাদের ইস্রায়েলবাসীদের বাড়ীগুলিকে নিস্তার দিয়েছিলেন| প্রভু মিশরীয়দের হত্যা করেছিলেন কিন্তু আমাদের লোকদের বাড়ীগুলো রক্ষা করেছিলেন|’” সুতরাং লোকে নত হয়ে প্রভুর উপাসনা করল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","প্রভু মোশি ও হারোণকে এই আদেশ দিয়েছিলেন তাই ইস্রায়েলবাসী প্রভুর আদেশমতো কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","মধ্যরাতে মিশরের সমস্ত প্রথম নবজাতক পুত্রদের প্রভু হত্যা করেছিলেন| ফরৌণের প্রথমজাত পুত্র থেকে জেলের বন্দীর প্রথমজাত পুত্র পর্যন্ত| সমস্ত পশুর প্রথমজাত শাবককেও হত্যা করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","সেই রাতে মিশরের প্রত্যেক ঘরে কেউ না কেউ মারা গেল| ফরৌণ, তাঁর কর্মচারী ও মিশরের সমস্ত লোক উচ্চস্বরে কান্না শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","তাই, সেই রাতে ফরৌণ মোশি ও হারোণকে ডেকে বললেন, “উঠে পড়, আমাদের সকলকে ছেড়ে দাও এবং চলে যাও| তুমি ও তোমার ইস্রায়েলের লোকরা যা ইচ্ছা তাই করতে পার| তোমরা যেমন বলেছিলে, গিয়ে প্রভুর উপাসনা কর| ");
INSERT INTO ben2006_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","তোমাদের চাহিদা মতো সমস্ত গরু ও মেষের দল তোমরা নিয়ে যেতে পারো| যাও! যখন তোমরা যাবে আমায় আশীর্বাদ করার জন্য প্রভুর কাছে প্রার্থনা করো|” ");
INSERT INTO ben2006_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","মিশরীয়রা তাদের তাড়াতাড়ি চলে যাবার জন্য মিনতি করল| কেন? কারণ তারা বলল, “তোমরা না চলে গেলে আমরা সকলে মারা যাব!” ");
INSERT INTO ben2006_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ইস্রায়েলীয়রা তাদের রুটিতে খামির দেবার সময় পেল না| তারা ভিজে ময়দার তালের পাত্র কাপড়ে জড়িয়ে কাঁধে বয়ে নিয়ে চলল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","তারপর ইস্রায়েলের লোকরা মোশির কথামতো তাদের মিশরীয় প্রতিবেশীদের কাছে গিয়ে কাপড় ও সোনা রূপার তৈরী জিনিস চাইল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","প্রভু মিশরীয়দের ইস্রায়েলীয়দের প্রতি দয়ালু করে তুললেন যাতে মিশরীয়রা তাদের ধনসইদ ইস্রায়েলবাসীদের হাতে তুলে দেয়! এইভাবে, ইস্রায়েলীয়রা মিশরীয়দের লুন্ঠন করল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ইস্রায়েলের লোকরা রামিষেষ থেকে সুক্কোতে যাত্রা করল| শিশুরা ছাড়াই সেখানে প্রায় 600,000 লোক ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","সেখানে প্রচুর মেষ, গবাদি পশু এবং জিনিসপত্র ছিল| তাদের সঙ্গে অনেক অ-ইস্রায়েলীয় লোক গিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","যেহেতু তাদের মিশরের বাইরে যেতে বাধ্য করা হয়েছিল, সেই হেতু তারা মাখা ময়দায়়, যেটা তারা মিশর থেকে এনেছিল, খামির মেশাবার সময় পায়নি| এবং যাত্রার জন্য কোন বিশেষ খাবার প্রস্তুত করারও সময় হয় নি| তাই তারা খামিরবিহীন রুটিই সেঁকে নিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ইস্রায়েলীয়বাসীরা 430 বছর ধরে মিশরে বাস করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","প্রভুর সৈন্যরা 430 বছর পর সেই বিশেষ দিনে মিশর ত্যাগ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","তাই সেটা ছিল একটি বিশেষ রাত্রি কারণ প্রভু তাদের মিশর থেকে বাইরে বার করে আনার জন্য লক্ষ্য রাখছিলেন| সেইভাবে, সমস্ত ইস্রায়েলবাসীরা প্রভুকে সম্মান জানানোর জন্য চিরকাল এই বিশেষ রাতটির প্রতি লক্ষ্য রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","প্রভু মোশি ও হারোণকে বললেন, “এই হল নিস্তারপর্বের বলির নিয়মাবলী: কোন বিদেশী এই নিস্তারপর্বে আহার করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","কিন্তু যদি কোন ব্যক্তি কোন দাস কেনে এবং তাকে সুন্নৎ করায় তাহলে সেই দাস নিস্তারপর্ব খেতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","কিন্তু যে লোক তোমার দেশের একজন সাময়িক বাসিন্দা বা ভাড়া করা কর্মী তার নিস্তারপর্ব ভোজ খাওয়া উচিৎ‌ নয়| এই নিস্তারপর্ব শুধুমাত্র ইস্রায়েলের লোকদের জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“প্রত্যেক পরিবার একটি বাড়ীতেই আহার করবে| কোনও খাবার বাড়ীর বাইরে যাবে না, মেষ শাবকের কোন হাড় ভাঙ্গবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","সমস্ত ইস্রায়েল প্রজাতির মানুষ এই উৎসব পালন করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","যদি ইস্রায়েলীয় ছাড়া অন্য কোন উপজাতির লোক তোমাদের সঙ্গে থাকে এবং তোমাদের খাবারে ভাগ বসাতে চায় তবে তাকে এবং তার পরিবারের প্রত্যেক পুরুষকে সুন্নৎ করাতে হবে| তাহলে সে অন্যান্য ইস্রায়েলীয়দের সমকক্ষ হয়ে যাবে এবং তাদের সঙ্গে খাবার ভাগ করে খেতে পারবে| কিন্তু যদি কোন ব্যক্তির সুন্নৎ না করানো হয় তবে সে এই খাবার আহার করতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","এই নিয়ম সকলের জন্যই প্রযোজ্য| এই নিয়মটি ইস্রায়েলীয় অথবা অ-ইস্রায়েলীয় সকলের জন্য সমানভাবে প্রযোজ্য|” ");
INSERT INTO ben2006_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","তাই প্রভু মোশি ও হারোণকে যা আদেশ দিয়েছিলেন সমস্ত ইস্রায়েলের লোক তা পালন করল| ");
INSERT INTO ben2006_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","তাই সেই দিন প্রভু এইভাবে দলে দলে ইস্রায়েলবাসীদের মিশর দেশ থেকে বাইরে বার করে আনলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ইস্রায়েলের প্রতিটি নারীর প্রথমজাত পুত্র সন্তানকে আমার উদ্দেশ্যে দান কর| এমনকি প্রত্যেকটি পশুর প্রথম পুরুষ শাবকটিও আমার হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","মোশি লোকদের বলল, “এই দিনটিকে মনে রেখো| তোমরা মিশরের ক্রীতদাস ছিলে| কিন্তু প্রভু তাঁর মহান শক্তি দিয়ে এই দিনে তোমাদের দাসত্বের শৃঙ্খল থেকে মুক্ত করেছেন| তোমরা খামিরবিহীন রুটি খাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আজ আবীব মাসের (বসন্তকালের) এই দিনে তোমরা মিশর ত্যাগ করেছ| ");
INSERT INTO ben2006_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","প্রভু তোমাদের পূর্বপুরুষদের কাছে কনানীয়, হিত্তীয়, ইমোরীয়, হিব্বীয় ও যিবূষীয়দের দেশ তোমাদের দেওয়ার প্রতিশ্রুতি দিয়েছিলেন| প্রভু তোমাদের এই বিশাল সম্পদে ভরা শস্য শ্যামল দেশে নিয়ে আসার পর তোমরা অবশ্যই প্রতি বছর প্রথম মাসের এই বিশেষ দিনে উপাসনা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“সাতদিন ধরে তোমরা খামিরবিহীন রুটি খাবে| সাত দিনের দিন ভোজন উৎসব করবে| এই মহাভোজ উৎসব হবে প্রভুকে সম্মান জানানোর উদ্দেশ্যে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","তাই সাতদিন ধরে তোমরা খামিরবিহীন রুটি খাবে| তোমাদের দেশের কোথাও কোন খামিরবিশিষ্ট রুটি অবশ্যই থাকবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","সেইদিন তোমরা তোমাদের সন্তানদের বলবে, ‘প্রভু আমাদের মিশর দেশ থেকে উদ্ধার করে এনেছেন বলে আমরা এই মহাভোজ উৎসব পালন করি|’ ");
INSERT INTO ben2006_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“এই বিশ্রামের দিনটিকে কোনও বিশেষ দিনে হাতে বাঁধা সুতোর মতো তোমাদের মনে রাখা উচিৎ‌| মনে রাখবে দুই চোখের মাঝখানে কপালে লাগানো তিলকের মতো| এই ছুটির দিনটি তোমাদের প্রভুর শিক্ষামালাকে মনে রাখতে সাহায্য করবে| এটা তোমাদের সাহায্য করবে প্রভুর মহান শক্তিকে মনে রাখতে যিনি তোমাদের মিশর থেকে মুক্ত করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","সুতরাং প্রতি বছর ছুটির দিনটিকে তোমরা প্রতি বছর সঠিক সময় স্মরণ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“তোমাদের পূর্বপুরুষদের এবং তোমাদের কাছে প্রতিশ্রুতি মতো প্রভু তোমাদের কনানীয়দের দেশে নিয়ে যাবেন| কিন্তু প্রভু তোমাদের পূর্বপুরুষদের কাছে প্রতিশ্রুতি দিয়েছিলেন যে তোমাদের তিনি এই দেশ দিয়ে দেবেন| ঈশ্বর তোমাদের এই দেশ দেওয়ার পর, ");
INSERT INTO ben2006_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","তোমরা কিন্তু তাঁকে তোমাদের প্রথম পুত্র সন্তান এবং ভূমিষ্ট হওয়া প্রথম পুরুষ শাবককে প্রভুর উদ্দেশ্যে দান করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","প্রতিটি গাধার প্রথমজাত পুরুষ শাবককে প্রতিটি মেষ শাবকের বিনিময়ে প্রভুর কাছ থেকে কিনে মুক্ত করে আনতে পারবে| যদি মুক্ত করতে না পারো তাহলে গাধার শাবকটিকে ঘাড় মটকে হত্যা করবে| এবং সেটাই হবে প্রভুর প্রতি নৈবেদ্য| কিন্তু মানুষের প্রথমজাত পুত্র সন্তানদের অবশ্যই প্রভুর কাছ থেকে ফেরৎ‌ নিয়ে আসতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ভবিষ্যতে তোমাদের সন্তানরা জিজ্ঞাসা করবে, তোমরা এগুলো কেন করলে, ‘এগুলোর মানেই বা কি?’ তখন তোমরা বলবে, ‘আমরা মিশরে দাসত্ব করতাম| কিন্তু প্রভুই তাঁর মহান শক্তি প্রয়োগ করে আমাদের মিশর দেশ থেকে উদ্ধার করে এনেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","মিশরে ফরৌণ ছিলেন ভীষণ জেদী| তিনি কিছুতেই আমাদের মুক্তি দিচ্ছিলেন না| তাই প্রভু তখন সে দেশের প্রত্যেক প্রথমজাত সন্তানদের হত্যা করেছিলেন| প্রভু মানুষ ও পশু উভয়েরই প্রথমজাত পুরুষ সন্তানদের হত্যা করেছিলেন| সেইজন্যই আমরা সমস্ত প্রথমজাত পুং পশুদের প্রভুর কাছে উৎসর্গ করি এবং প্রভুর কাছ থেকে আমাদের প্রথমজাত পুত্র সন্তানদের কিনে নিই|’ ");
INSERT INTO ben2006_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","এরই চিহ্ন হিসাবে তোমাদের হাতে সুতো বাঁধা এবং দুই চোখের মাঝখানে তিলক, যাতে তোমরা মনে রাখতে পার যে প্রভু তাঁর পরাক্রম শক্তি প্রয়োগ করে আমাদের মিশর দেশ থেকে উদ্ধার করে এনেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ফরৌণ যখন লোকদের চলে যেতে দিলেন, ঈশ্বর তাদের পলেষ্টীয় দেশের মধ্যে দিয়ে ভূমধ্যসাগর বরাবর সহজ সমুদ্র পথ ব্যবহার করতে দেন নি, যদিও সেটা রাস্তা ছিল| ঈশ্বর বলেছিলেন, “ঐ দিক দিয়ে গেলে যুদ্ধ করতে হবে| তখন লোকরা মত পরিবর্তন করে আবার মিশরেই ফিরে যেতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","তাই ঈশ্বর তাদের সূফ সাগরের দিকবর্তী মরুভূমির মধ্যে দিয়ে নিয়ে এসেছিলেন| মিশর ত্যাগ করার সময় ইস্রায়েলের লোকরা যুদ্ধের পোশাকে নিজেদের সজ্জিত করল| ");
INSERT INTO ben2006_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","মোশি যোষেফের অস্থি বয়ে নিয়ে চলল| (যোষেফ মারা যাবার আগে ইস্রায়েলের পুত্রদের এই কাজ করার প্রতিশ্রুতি করিয়ে নিয়েছিল| যোষেফ বলেছিল, “ঈশ্বর তোমাদের যখন রক্ষা করবেন তখন তোমরা মিশর দেশ থেকে আমার অস্থি সকল বয়ে নিয়ে এসো|”) ");
INSERT INTO ben2006_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ইস্রায়েলীয়রা সুক্কোৎ ছেড়ে এসেছিল এবং এথমে, যেটা মরুভুমির কাছে ছিল, সেখানে তাঁবু গাড়ল| ");
INSERT INTO ben2006_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","প্রভু সেই সময় তাদের পথ দেখিয়ে নিয়ে এলেন| সেই যাত্রার সময় প্রভু পথ দেখানোর জন্য দিনের বেলায় লম্বা মেঘ স্তম্ভ এবং রাতের বেলায় আগুনের শিখা ব্যবহার করতেন| ঐ আগুনের শিখা রাতের বেলায় তাদের পথ চলার আলো জোগাতো| ");
INSERT INTO ben2006_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","লম্বা মেঘ স্তম্ভ সারাদিন তাদের সঙ্গে থাকত এবং রাতে থাকত আগুনের শিখা| ");
INSERT INTO ben2006_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","তারপর প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ওদের বলো, মিগ্দোল এবং সূফ সাগরের মাঝখানে বাল্সফোনের সামনে রাত্রিযাপন করতে| ");
INSERT INTO ben2006_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","তাহলে ফরৌণ ভাববে যে ইস্রায়েলের লোকরা মরুভূমিতে হারিয়ে গেছে| ওদের আর কোথাও যাবার জায়গা নেই| ");
INSERT INTO ben2006_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","তখন আমি ফরৌণকে সাহসী করে তুলব যাতে সে তোমাদের তাড়া করে| কিন্তু শেষ পর্যন্ত আমি ফরৌণ ও তার সেনাদের পরাজিত করব| এটা আমার সম্মান বাড়াবে| এবং মিশরের লোকরা তখন জানতে পারবে যে আমিই প্রভু|” ইস্রায়েলের লোকরা ঈশ্বরের কথামতোই কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","মিশরের রাজা খবর পেলেন যে ইস্রায়েলীয়রা পালিয়েছে| এই খবর শুনে ফরৌণ ও তাঁর সভাসদরা আগের মত মন পরিবর্তন করলেন| ফরৌণ বললেন, “আমরা কেন ইস্রায়েলীয়দের যেতে দিলাম? কেন ওদের পালাতে দিলাম? এখন আমরা আমাদের ক্রীতদাসদের হারালাম|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","সুতরাং ফরৌণ তাঁর রথে চড়ে লোকজন সমেত ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ফরৌণ তাঁর সব চেয়ে ভালো 600 জন সারথীকে নিলেন| প্রত্যেকটি রথে একজন করে বিশিষ্ট সভাসদ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ইস্রায়েলীয়রা তাদের যুদ্ধ জয়ে উঁচু করা অস্ত্রশস্ত্র নিয়ে ছেড়ে যাচ্ছিল| কিন্তু মিশরের রাজা ফরৌণ, যাঁর হৃদয় প্রভুর দ্বারা উদ্ধত হয়েছিল, ইস্রায়েলীয়দের তাড়া করলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","মিশরীয় সৈন্যরা তাদের তাড়া করল| ফরৌণের সমস্ত অশ্বারোহী, রথারোহী এবং সৈন্য ইস্রায়েলীয়দের ধরে ফেলল যখন তারা সূফ সাগরের কাছে বাল্সফোনের পূর্বে পী-হহীরোতে শিবির করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ইস্রায়েলের লোকেরা দেখতে পেল ফরৌণ এবং তাঁর সেনারা তাদের দিকে এগিয়ে আসছে| তখন তারা ভয় পেয়ে প্রভুর কাছে সাহায্যের জন্য চিৎকার করে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","তারা মোশিকে বলল, “কেন তুমি আমাদের মিশর থেকে বার করে আনলে? কেন মরার জন্য তুমি আমাদের এই মরুভূমিতে নিয়ে এলে? আমরা অন্ততঃ মিশরে তো শান্তিতে মরতে পারতাম| সেখানে আর কিছু থাক না থাক প্রচুর কবর ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","এরকম যে ঘটতে পারে তা কিন্তু আমরা আগেই বলেছিলাম| আমরা বলেছিলাম, ‘অনুগ্রহ করে আমাদের বিরক্ত কোরো না| আমাদের এখানেই থাকতে দাও, মিশরীয়দের সেবা করতে দাও|’ এই মরুভূমিতে এসে মরার থেকে মিশরীয়দের দাসত্ব অনেক ভাল ছিল|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","কিন্তু মোশি উত্তরে বলল, “ভয় পেয়ে পালিয়ে যেও না| দেখো, প্রভু কিভাবে আজ তোমাদের রক্ষা করেন| তোমরা আর কোনও দিন মিশরীয়দের দেখতে পাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","তোমাদের কিছুই করতে হবে না| শুধু শান্ত হয়ে দেখে যাও কি ঘটছে| প্রভুই তোমাদের হয়ে যুদ্ধ করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","সেই সময় প্রভু মোশিকে বললেন, “তুমি এখনও কেন আমার সামনে কাঁদছো! ইস্রায়েলীয়দের এগিয়ে যেতে বলো| ");
INSERT INTO ben2006_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","যখন তুমি সূফ সাগরের ওপর তোমার হাতের লাঠি তুলে ধরবে সূফ সাগর দুভাগ হয়ে যাবে| তখন লোকরা সমুদ্রের মাঝখানে তৈরি হওয়া সেই শুকনো পথ দিয়ে পায়ে হেঁটে যেতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","আমিই মিশরীয়দের সাহসী করে তুলেছি| তাই ওরা তোমাদের তাড়া করছে| কিন্তু আমি তোমাদের দেখাব যে আমি ফরৌণ, তার সমস্ত সৈন্য, তার অশ্বারোহীসমূহ এবং সারথীদের চেয়ে অনেক বেশী শক্তিশালী| ");
INSERT INTO ben2006_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","তখন মিশরও জানবে যে আমিই প্রভু| মিশরীয়রাও আমাকে সম্মান জানাবে যখন আমি ফরৌণ, তার অশ্বারোহীগণ এবং সারথীদের পরাজিত করব|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","এরপর প্রভুর দূত, যে সামনে থেকে ইস্রায়েলীয়দের নেতৃত্ব দিচ্ছিল, সে ইস্রায়েলীয়দের পিছন দিকে চলে এলো| তাই এক লম্বা মেঘস্তম্ভ মুহুর্তের মধ্যেই লোকদের সামনে থেকে পিছনে চলে এল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","এইভাবে ঐ মেঘস্তম্ভ মিশরীয়দের মাঝখানে বিরাজ করতে থাকল| তখন মিশরীয়দের জন্য অন্ধকার থাকলেও ইস্রায়েলীয়দের জন্য আলো ছিল| তাই ঐ রাত্রে মিশরীয়রা ইস্রায়েলীয়দের কাছে আসতে পারল না| ");
INSERT INTO ben2006_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","মোশি সূফ সাগরের ওপর তার হাত মেলে ধরল| প্রভু পূর্ব দিক থেকে প্রবল ঝড়ের সৃষ্টি করলেন| এই ঝড় সারারাত ধরে চলতে লাগল| দু’ভাগ হয়ে গেল সমুদ্র| এবং বাতাস মাটিকে শুকনো করে দিয়ে সমুদ্রের মাঝখান বরাবর পথের সৃষ্টি করল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ইস্রায়েলের লোকরা ঐ পথ দিয়ে হেঁটে সূফ সাগর পেরিয়ে গেল| তাদের দুদিকে ছিল জলের দেওয়াল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","পিছনে ফরৌণের সমস্ত অশ্বারোহী সেনা ও রথ ধাওয়া করল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","পরদিন সকালে মেঘস্তম্ভ ও অগ্নিশিখার ওপর থেকে প্রভু মিশরীয় সেনাদের দিকে দৃষ্টিপাত করলেন| তখন প্রভু ইস্রায়েলীয়দের পক্ষ নিয়ে মিশরীয় সৈন্যবাহিনীকে আতঙ্কে ফেলে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","রথের চাকা আটকে গিয়ে রথ চালানো কঠিন হয়ে দাঁড়ালো| মিশরীয়রা চিৎকার করে উঠল, “চলো এখান থেকে বেরিয়ে যাই| প্রভুই ইহুদীদের হয়ে আমাদের বিরুদ্ধে লড়াই করছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","তখন প্রভু মোশিকে বললেন, “সমুদ্রের ওপর তোমার হাত তুলে ধর| দেখবে তীব্র জলোচ্ছ্বাস গ্রাস করছে মিশরীয়দের রথ ও অশ্বারোহী সেনাদের|” ");
INSERT INTO ben2006_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","মোশি তার হাত সমুদ্রের ওপর মেলে ধরলো| তাই দিনের আলো ফোটার ঠিক আগে সমুদ্র তার স্বাভাবিক অবস্থায় ফিরে গেল| মিশরীয়রা জলোচ্ছ্বাস থেকে বাঁচার তাগিদে প্রাণপনে দৌড়তে লাগল| কিন্তু প্রভু তাদের সমুদ্রের জলে ঠেলে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","জলোচ্ছ্বাস গ্রাস করল রথ ও অশ্বারোহী সেনাদের| ফরৌণের যে সমস্ত সেনারা ইস্রায়েলীয়দের তাড়া করে আসছিল তারা সব ধ্বংস হল| কেউ বেঁচে থাকল না| ");
INSERT INTO ben2006_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ইস্রায়েলের লোকরা সমুদ্রের মাঝখানে তৈরি হওয়া পথ দিয়ে সূফ সাগর পেরিয়ে গেল| তাদের পথের দুপাশে ছিল জলের দেওয়াল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","সুতরাং সেইদিন এইভাবে প্রভু মিশরীয়দের হাত থেকে ইস্রায়েলীয়দের রক্ষা করলেন| পরে ইস্রায়েলীয়রা সূফ সাগরের তীরে মিশরীয়দের মৃত দেহের সারি দেখতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","মিশরীয়দের সেই পরিণতি দেখার পর থেকে ইস্রায়েলের লোকরা প্রভুর শক্তি সম্পর্কে নিঃসন্দেহ হল| তারা প্রভুকে ভয় ও সম্মান করতে শুরু করল| তারা বিশ্বাস করতে শুরু করল প্রভুকে এবং তাঁর দাস মোশিকে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","এরপর মোশি এবং ইস্রায়েলের লোকরা প্রভুর উদ্দেশ্যে এই গানটি গাইল: “আমি প্রভুর উদ্দেশ্যে গান গাইব! তিনি মহান কাজ করেছেন| তিনি ঘোড়া এবং ঘোড়সওয়ারদের সমুদ্রে ছুঁড়ে ফেলে দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","প্রভুই আমার শক্তি| তিনি আমার পরিত্রাতা এবং আমি তাঁর প্রশংসার গান গাইব| প্রভু আমার ঈশ্বর, আমি তাঁর প্রশংসা করব| প্রভু হলেন আমার পূর্বপুরুষদের ঈশ্বর| এবং আমি তাঁকে সম্মান করব| ");
INSERT INTO ben2006_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","প্রভু হলেন মহান যোদ্ধা| তাঁর নাম হল প্রভু| ");
INSERT INTO ben2006_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ফরৌণের রথ এবং সেনাদের তিনি সমুদ্রে ছুঁড়ে ফেলে দিয়েছেন| ফরৌণের সেরা সৈন্যরা সূফ সাগরে ডুবে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","জলের গভীরে তারা তলিয়ে গেছে| পাথরের মতো তারা জলে ডুবে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“প্রভু আপনার ডান হাত অসম্ভব শক্তিশালী| প্রভু আপনার ডান হাত শত্রুবাহিনীকে চুরমার করে দিয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","আপনি আপনার মহান রাজকীয়় ঢঙে আপনার বিরুদ্ধাচারীদের ধ্বংস করেছেন| আগুনের শিখা যেমন করে ঘর পুড়িয়ে দেয়, তেমনি আপনার ক্রোধ তাদের ধ্বংস করে দিয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","আপনার নিঃশ্বাসের একটি সজোর ফুত্কারে জল জমে উঠেছিল| সেই জলোচ্ছ্বাস একটি নিরেট দেওয়ালে পরিণত হয়েছিল এবং সমুদ্রের গভীরতাও ঘন হয়ে উঠেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“শত্রুরা বলেছিল, ‘আমি তাদের তাড়া করে ধরে ফেলব| আমি তাদের সমস্ত ধন-সম্পত্তি লুঠ করব| আমি তরবারি ব্যবহার করে সব লুঠ করে নেব| সবকিছু আমার নিজের জন্য নিয়ে যাব|’ ");
INSERT INTO ben2006_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","কিন্তু আপনি আপনার নিঃশ্বাস দিয়ে সমুদ্রকে উড়িয়ে দিয়েছিলেন এবং তাদের ঢেকে দিয়েছিলেন| তারা সীসার মতো সেই ক্রুদ্ধ সমুদ্রের নীচে চলে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“প্রভুর মতো আর কোনও ঈশ্বর আছে? না! আপনার মতো আর কোনও ঈশ্বর নেই| আপনি অত্যন্ত পবিত্র| আপনি আশ্চর্য্যজনক শক্তিশালী| আপনি মহান অলৌকিক ঘটনা ঘটান| ");
INSERT INTO ben2006_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","আপনি আপনার ডান হাত প্রসারিত করেছিলেন, তাই পৃথিবী তাদের গিলে ফেলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","আপনি আপনার মহান করুণা দিয়ে লোকদের রক্ষা করেছেন| এবং আপনার শক্তি দিয়ে ঐ লোকদের আপনার পবিত্র ও সুন্দর দেশে আপনি নিয়ে এসেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“অন্যান্য দেশ এই কাহিনী শুনে ভয় পাবে| পলেষ্টীয়রা ভয়ে কেঁপে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ইদোমের নেতারা ভয়ে কাঁপবে| মোয়াবের নেতারা ভয়ে কাঁপবে| কনানবাসীরা উদ্যম হারাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ঐ শক্তিশালী লোকরা যখন আপনার ক্ষমতার প্রমাণ পাবে তখন তারা ভয় পেয়ে যাবে| ওরা পাথরের মতো অনঢ় হয়ে থাকবে যতক্ষণ না আপনার লোকরা চলে যায়: হ্যাঁ, হে প্রভু, যতক্ষণ না আপনার লোক, যাদের আপনি কিনেছিলেন চলে যায়| ");
INSERT INTO ben2006_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","তাদের আপনার পর্বতে নিয়ে যান যেখানে আপনার বাসস্থান এবং সেখানে তাদের স্থাপন করুন| আমার প্রভু, ঐ জায়গাটাই হচ্ছে সেই জায়গা যেটা আপনি তৈরী করেছেন| পবিত্র স্থান যেটাকে আপনার হাত প্রতিষ্ঠা করেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“প্রভু চিরকালের জন্য যুগে যুগে শাসন করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","যখন ফরৌণের সমস্ত ঘোড়া, রথ ও অশ্বারোহী সমুদ্রের নীচে চলে গেল, তখন প্রভু আবার সমুদ্রের জল তাদের ওপর ফেরৎ‌ আনলেন| কিন্তু ইস্রায়েলীয়রা সমুদ্রের মাঝখান দিয়ে শুকনো পথে হেঁটে গিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","তারপর হারোণের বোন মরিয়ম, মহিলা ভাববাদিনী, হাতে একটি খঞ্জনী তুলে নিল| মরিয়ম ও তার মহিলা সঙ্গীরা নাচতে ও গাইতে শুরু করল| গানের যে কথাগুলো মরিয়ম উচ্চারণ করছিল তা হল: ");
INSERT INTO ben2006_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“প্রভুর উদ্দেশ্যে গান কর| তিনি মহান কাজ করেছেন| তিনি ঘোড়া এবং ঘোড়াসওয়ারীদের সমুদ্রে ছুঁড়ে ফেলে দিয়েছেন ….” ");
INSERT INTO ben2006_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ইস্রায়েলের লোকদের সূফ সাগর পেরোতে মোশি নেতৃত্ব দিয়েছিল| তিন দিন ধরে শূর মরুভূমি অতিক্রম করতে করতে তারা জলের সন্ধান পেল না| ");
INSERT INTO ben2006_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","তিন দিন পর তারা মারাতে এসে পৌঁছালো| মারাতে জলের সন্ধান মিললেও সেই জল এত তেঁতো ছিল যে তা পানের অযোগ্য| (এরজন্য এই জায়গার নাম রাখা হয়েছিল মারা বা তিক্ততা|) ");
INSERT INTO ben2006_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","লোকরা মোশির কাছে এসে নালিশ জানালো| তারা বলল, “এখন আমরা কি পান করব?” ");
INSERT INTO ben2006_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","মোশি প্রভুর কাছে কেঁদে পড়ল| প্রভু তাকে এক গাছের সন্ধান দিলেন| মোশি সেই গাছ ঐ তেঁতো জলে ডুবোতেই সেই জল সুস্বাদু হয়ে উঠল| ঐ স্থানে প্রভু লোকদের বিচার করে তাদের জন্য একটি আইন প্রণযনও করেছিলেন| প্রভু তাদের বিশ্বাসেরও পরীক্ষা নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","প্রভু বললেন, “তোমরা অবশ্যই তোমাদের প্রভু ঈশ্বরকে মেনে চলবে| তিনি যেটা সঠিক মনে করবেন সেটাই তোমরা করবে| তোমরা যদি প্রভুর সমস্ত নির্দেশ ও বিধি মেনে চলো তাহলে তোমরা মিশরীয়দের মতো অসুস্থ থাকবে না| আমি প্রভু, তোমাদের মিশরীয়দের মতো অসুস্থ করে তুলব না| আমিই সেই প্রভু যিনি তোমাদের আরোগ্য দান করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","তারপর লোকরা এলীমে এসে উপস্থিত হল| সেখানে বারোটি জলের ঝর্ণা এবং 70টি তাল গাছ ছিল| তারা সেই জায়গায় জলের ধারে তাদের শিবির তৈরি করল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","তারপর ইস্রায়েলের সমস্ত জনমণ্ডলী এলীম ছেড়ে গেল এবং সীনয় মরুভূমিতে এলো যেটা ছিল এলীম ও সীনয়ের মাঝখানে| মিশর দেশ ছেড়ে আসার দ্বিতীয় মাসের 15 দিনের মাথায় তারা সেখানে পৌঁছলো| ");
INSERT INTO ben2006_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","তারপর ইস্রায়েলের সমস্ত জনমণ্ডলী মরুভূমিতে মোশি ও হারোণের কাছে নালিশ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","এইসব লোকরা বলল, “প্রভু যদি আমাদের মিশর দেশে মেরে ফেলতেন তাহলেও ভাল ছিল| অন্ততঃ সেখানে তো খাবার পেতাম| আমাদের ইচ্ছামতো খাবার সেখানে মজুত ছিল| কিন্তু এখন তোমরা আমাদের এই মরুভূমিতে এনে ফেললে| এখানে তো আমরা খাবারের অভাবেই মারা যাব|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","তখন প্রভু মোশিকে বললেন, “আমি তোমাদের জন্য আকাশ থেকে খাবার ফেলবার ব্যবস্থা করব| সেই খাদ্য তোমাদের খাবার যোগ্য হবে| লোকরা প্রতিদিন বাইরে বেরিয়ে এসে তাদের প্রয়োজনমতো সারাদিনের খাবার কুড়িয়ে নিয়ে আসবে| আমি যা বলছি তোমরা তা করছ কিনা শুধু তা দেখার জন্যই আমি এটা করব| ");
INSERT INTO ben2006_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","প্রত্যেকদিন তারা কেবলমাত্র একদিনের মতো পর্যাপ্ত খাবার সংগ্রহ করবে| কিন্তু শুক্রবার যখন তারা খাবার তৈরি করবে, তখন তারা দেখবে যে দুদিনের মত পর্যাপ্ত খাবার সঞ্চিত আছে|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","মোশি এবং হারোণ ইস্রায়েলের লোকদের বলল, “রাতে তোমরা প্রভুর শক্তির প্রমাণ পাবে| তোমরা জানবে যে তিনিই তোমাদের মিশর থেকে উদ্ধার করে নিয়ে এসেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","তোমরা প্রভুর কাছে নালিশ জানিয়েছো এবং তিনি তা শুনেছেন| তাই আগামীকাল সকালে তোমরা প্রভুর মহিমা স্বচক্ষে দেখতে পাবে| তোমরা আমাদের কাছে কেবল নালিশই জানিয়ে যাচ্ছ| এখন কি আমরা খানিকটা বিশ্রাম পেতে পারি?” ");
INSERT INTO ben2006_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","এবং মোশি বলল, “তোমরা নালিশ জানিয়েছ এবং প্রভু তোমাদের অভিযোগ শুনেছেন| তাই আজ রাতে প্রভু তোমাদের মাংস দেবেন| এবং কাল সকালের মধ্যে তোমরা তোমাদের চাহিদা মতো রুটিও পেয়ে যাবে| তোমরা আমার কাছে এবং হারোণের কাছেও নালিশ জানিয়ে এসেছ| কিন্তু আমরা এখন দুজনে কিছু সময়ের জন্য বিশ্রাম নিতে পারব বলে মনে হয়| মনে রেখো, তোমরা আমার বিরুদ্ধে কিংবা হারোণের বিরুদ্ধে নালিশ জানাও নি, তোমরা স্বয়ং প্রভুর বিরুদ্ধে নালিশ জানিয়েছ|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","তারপর মোশি হারোণকে বলল, “ইস্রায়েলের সমস্ত লোকদের বলো, প্রভুর সামনে উপস্থিত হও, কারণ প্রভু তোমাদের নালিশ শুনেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","হারোণ ইস্রায়েলের সমস্ত লোকদের সে কথা বলল| তখন তারা সবাই একসঙ্গে এক জায়গায় এসে জড়ো হল| হারোণ যখন সবার সঙ্গে কথা বলছিল তখন সবাই পিছন ফিরে মরুভূমির দিকে তাকিয়ে দেখতে থাকল মেঘের ভিতর দিয়ে প্রভুর মহিমা প্রকাশিত হচ্ছে| ");
INSERT INTO ben2006_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“আমি ইস্রায়েলের লোকদের নালিশ শুনেছি| সুতরাং ওদের বলো, ‘আজ রাতে তোমরা মাংস খেতে পারো এবং সকালে তোমরা যতখুশি রুটি খেতে পারো| তখন তোমরা বুঝবে যে তোমরা তোমাদের প্রভু, তোমাদের ঈশ্বরকে, বিশ্বাস করতে পার|’” ");
INSERT INTO ben2006_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","রাতে, তিতির পাখীরা এসেছিল এবং শিবিরের চারপাশে বসেছিল| লোকরা সেই পাখীগুলোকে ধরে তার মাংস খেল| সকালে শিবিরের চারপাশে শিশির পড়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","শিশির শুকিয়ে গেলে তুষার কণার সরু স্তরের মতো একটি বস্তু মাটিতে পড়ে থাকল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","তা দেখে ইস্রায়েলবাসীরা একে অপরকে জিজ্ঞাসা করতে শুরু করল, “এটা আবার কি জিনিস?” তারা জানত না সেটা কি| তাই তারা একে অপরকে কৌতুহলী হয়ে জিজ্ঞাসা করছিল| তখন মোশি তাদের বলল, “এটা এক ধরণের খাদ্যবস্তু যা প্রভু তোমাদের খাবার জন্য দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","প্রভু বলেছেন, ‘প্রত্যেকেই তার প্রয়োজন মতো এটা কুড়িয়ে নেবে| এবং প্রত্যেককে তার পরিবারের প্রত্যেকের জন্য অন্ততঃ দু’পোয়া করে নিতে হবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","একথা শুনে ইস্রায়েলবাসীরা প্রত্যেকে ঐ খাদ্যবস্তু কুড়িয়ে নিল, কেউ কেউ আবার অন্যদের থেকে বেশী কুড়ালো| ");
INSERT INTO ben2006_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","পরে ওজনে দেখা গেল যে যারা বেশী সংগ্রহ করেছিল তাদের কাছে অতিরিক্ত পরিমাণ ছিল না এবং যারা কম সংগ্রহ করতে পেরেছিল তাদেরও খাবারে কম পড়ে নি| প্রত্যেকের পরিবারই পর্যাপ্ত পরিমাণে খাবার পেল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","মোশি তাদের বলল, “পরের দিনের জন্য ঐ খাবার মজুত করে রেখো না|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","কিন্তু কয়েকজন মোশির কথা না শুনে পরের দিনের জন্য ঐ খাবার রেখে দিল| কিন্তু মজুত করা খাবারগুলোয়় পোকা ধরে দুর্গন্ধ ছড়িয়ে গেল| তাই মোশি ঐসব লোকদের ওপর ক্রুদ্ধ হল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","প্রতিদিন সকালে প্রত্যেকে ঐ খাবার পর্যাপ্ত পরিমাণে জমা করত| কিন্তু দুপুরের মধ্যে ঐ খাদ্যবস্তু গলে উধাও হয়ে যেত| ");
INSERT INTO ben2006_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","শুক্রবারে লোকগুলো দ্বিগুণ খাবার জমা করত| তারা মাথা পিছু দু’পোয়া করে খাবার জমা করত| তাই দেখে বিভিন্ন দলের নেতারা এসে মোশিকে তা জানাল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","মোশি তখন তাদের বলল, “প্রভুই ওদের বলেছিলেন এটা করতে| কারণ আগামীকাল হল প্রভুকে সম্মান প্রদর্শনের জন্য বিশেষ বিশ্রামের দিন| তোমরা আজ সব খাবার রান্না করে আজকে খাবার পরে অবশিষ্ট খাবার কালকের জন্য মজুত করে রাখতে পারো|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","মোশির আদেশমত, লোকরা সেদিনকার অতিরিক্ত খাবার পরের দিনের জন্য সঞ্চয় করে রেখে দিল| কিন্তু ঐ খাবার এতটুকু নষ্ট হল না| তার মধ্যে একটাও পোকা ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","শনিবার মোশি লোকদের বলল, “আজ হল প্রভুর প্রতি সম্মান প্রদর্শনের জন্য বিশেষ বিশ্রামের দিন| তাই আজ আর কেউ তোমরা মাঠে যাবে না| গতকালের মজুত করা খাবার আজ খাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","সপ্তাহের বাকি ছয় দিন খাবার সংগ্রহ করলেও প্রতি সাত দিনের দিন হবে বিশ্রামের দিন| তাই বিশ্রামের দিনে মাঠে কোনও খাবার পাওয়া যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","একথা বলা সত্ত্বেও শনিবার কয়েকজন খাবারের সন্ধানে বাইরে গেল| কিন্তু দেখল কোনও খাবার মাঠে পড়ে নেই| ");
INSERT INTO ben2006_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তখন প্রভু মোশিকে বললেন, “আর কতদিন এই লোকরা আমার নির্দেশ ও শিক্ষাকে অমান্য করবে? ");
INSERT INTO ben2006_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","দেখ, প্রভু এই বিশ্রামের দিনটি তোমাদের অবসরের জন্য নির্দিষ্ট করেছেন| তাই প্রভু শুক্রবার তোমাদের দুদিনের জন্য পর্যাপ্ত খাবার দিয়ে দেন| সুতরাং যে যেখানেই থাকো না কেন শনিবার বিশ্রামের দিনে তোমরা সকলে বিশ্রাম নেবে ও আরাম করবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","তাই লোকজন প্রভুর কথামতো বিশ্রামের দিনে আরাম করতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ইস্রায়েলের লোকেরা ঐ খাদ্যবস্তুর নাম দিল “মান্না|” মান্নাকে দেখতে সাদা রঙের ধনে বীজের মতো হলেও এর স্বাদ অনেকটা মধু দিয়ে তৈরী করা পিঠের মতো| ");
INSERT INTO ben2006_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","মোশি বলল, “প্রভু বলেছেন: পরবর্তী উত্তরপুরুষের জন্য তোমাদের দু’পোয়া করে মান্না সঞ্চয় করে রাখতে হবে| তাহলে পরে তারা দেখতে পাবে এই বিশেষ খাবার যা আমি তোমাদের মিশর দেশ থেকে উদ্ধার করে এনে মরুভূমিতে দিয়েছি|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","তাই মোশি হারোণকে বলল, “একটা পাত্র নাও এবং তাতে দু’পোয়া মান্না রাখো| প্রভুর সামনে আমাদের উত্তর পুরুষদের জন্য এই মান্না রাখো|” ");
INSERT INTO ben2006_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","(মোশির প্রতি প্রভুর নির্দেশ মতো হারোণ একটি পাত্রে মান্না ভরল এবং সাক্ষ্য সিন্দুকের ভেতর রাখল|) ");
INSERT INTO ben2006_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ইস্রায়েলীয়রা 40 বছর ধরে মান্না খেয়েছিল| কনান দেশের সীমান্তে এসে না পৌঁছানো পর্যন্ত তারা মান্না খেয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(মান্না মাপা হত পোয়া হিসেবে| এক পোয়া হল 8 কাপের সমান|) ");
INSERT INTO ben2006_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","সমস্ত ইস্রায়েলীয়রা একসঙ্গে সীন মরুভূমি থেকে তাদের যাত্রা শুরু করল| প্রভু যেমনভাবে তাদের নেতৃত্ব দিলেন তারা সেইভাবে এক জায়গা থেকে আর এক জায়গায় যেতে শুরু করল| ঘুরতে ঘুরতে তারা রফীদীমে গিয়ে শিবির স্থাপন করল| সেখানে কোনও পানীয় জল ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","তাই ঐসব লোকরা আবার মোশির সঙ্গে তর্ক শুরু করল এবং বলল, “আমাদের পানীয় জল দাও|” মোশি তাদের বলল, “তোমরা কেন আমার বিরোধিতা করছো? কেনই বা তোমরা প্রভুকে পরীক্ষা করছো?” ");
INSERT INTO ben2006_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","কিন্তু লোকরা তখন প্রচণ্ড তৃষ্ণার্ত ছিল| তাই তারা পুনরায় মোশির কাছে নালিশ জানাতে শুরু করল| তারা বলল, “কেন তুমি আমাদের মিশর থেকে বার করে আনলে? তুমি কি আমাদের, আমাদের সন্তানদের এবং গবাদি পশুদের পানীয় জলের অভাবে মারার জন্য মিশর থেকে বাইরে নিয়ে এসেছো?” ");
INSERT INTO ben2006_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","তারপর মোশি প্রভুর কাছে কেঁদে পড়ল এবং বলল, “আমি এদের নিয়ে কি করি? যদি এখুনি কিছু না করা যায় তাহলে এরা তো সত্যি সত্যি আমাকে পাথর দিয়ে মেরে ফেলবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","প্রভু মোশিকে বললেন, “কিছু প্রবীণ নেতাদের নিয়ে ইস্রায়েলের লোকের সামনে গিয়ে দাঁড়াও| সঙ্গে তোমার পথ চলার লাঠিকেও নেবে যে লাঠি দিয়ে তুমি নীল নদে আঘাত করেছিলে| ");
INSERT INTO ben2006_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","আমি তোমার সামনে হোরেব পর্বতের (সীনয় পর্বত) ওপর দাঁড়াব| পথ চলার লাঠি দিয়ে ঐ পাথরে আঘাত করো আর তখনই দেখবে পাথর থেকে জল বেরিয়ে আসছে| ঐ জল লোকরা পান করতে পারবে|” মোশি তাই করল এবং ইস্রায়েলের প্রবীণ নেতারাও তা স্বচক্ষে দেখতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","মোশি ঐ স্থানের নাম দিল মঃসা ও মরীবা, কারণ ঐ স্থানেই ইস্রায়েলের লোকরা তার বিরোধিতা এবং ঈশ্বরের পরীক্ষা নিয়েছিল| লোকজন চেয়েছিল প্রভু তাদের সঙ্গে আছেন কিনা তা পরীক্ষা করে দেখতে| ");
INSERT INTO ben2006_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","সেই সময় অমালেক গোষ্ঠীর লোকরা এল এবং রফীদীমে ইস্রায়েলের লোকদের সঙ্গে যুদ্ধ বাধিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","তখন মোশি যিহোশূয়কে বলল, “কিছু লোককে বেছে নিয়ে আগামীকাল থেকে অমালেকদের সঙ্গে যুদ্ধ করো| আমি তোমাকে পথ চলার লাঠি যেটাতে ঈশ্বরের পরাক্রম বিদ্যমান, সেইটা নিয়ে পাহাড়ের ওপর থেকে লক্ষ্য করব|” ");
INSERT INTO ben2006_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","পরদিন যিহোশূয় মোশির আদেশ মেনে যুদ্ধ করতে গেল| একই সময়ে মোশি, হারোণ এবং হূর পাহাড়ের চূড়ায় উঠল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","যতক্ষণ পর্যন্ত মোশি তার হাত তুলে রইল, ইস্রায়েলীয়রা যুদ্ধ জিতছিল, যখন সে তার হাত নামিয়েছিল তখন তারা হেরে যাচ্ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","কিছু সময় পরে হাত তুলে থাকতে থাকতে মোশি ক্লান্ত হয়ে উঠল| তখন হারোণ ও হূর একটা বিশাল পাথরে মোশিকে বসিয়ে তারা উভয়ে মোশির দুদিকে গিয়ে তার হাত তুলে ধরল| সূর্য না ডোবা পর্যন্ত তারা এইভাবেই মোশির হাত দুটোকে তুলে ধরে রইল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","আর যিহোশূয় অমালেকদের যুদ্ধে পরাজিত করল| ");
INSERT INTO ben2006_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","তখন প্রভু মোশিকে বললেন, “এই যুদ্ধ নিয়ে একটা বই লেখ যাতে লোকরা মনে রাখে এখানে কি ঘটেছিল এবং যিহোশূয়ের কাছে এটা জোরে পড়ে শোনাও যাতে সে জানতে পারে যে আমি অমালেকদের এই পৃথিবী থেকে সম্পূর্ণরূপে নিশ্চিহ্ন করে দেব|” ");
INSERT INTO ben2006_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","এরপর মোশি একটি বেদী তৈরী করল| সেই বেদীর নাম হল “প্রভুই আমার পতাকা|” ");
INSERT INTO ben2006_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","মোশি বলল, “আমি প্রভুর সিংহাসনের দিকে হাত বাড়িয়ে ছিলাম বলেই প্রভু অমালেকদের বিরুদ্ধে যুদ্ধ করেছিলেন, যেমন তিনি সর্বদা করেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","মোশির শ্বশুর যিথ্রো ছিল মিদিয়নীয়র যাজক| ঈশ্বর যে একাধিকভাবে মোশিকে এবং ইস্রায়েলের লোকদের সাহায্য করেছেন তা সে শুনেছিল| যিথ্রো শুনেছিল যে প্রভু ইস্রায়েলীয়দের মিশর থেকে বার করে এনেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","তাই যিথ্রো মোশির স্ত্রী সিপ্পোরাকে নিল এবং মোশির সঙ্গে দেখা করতে গেল| মোশি তখন ঈশ্বরের পর্বতের কাছে শিবির করে রয়েছে| মোশির স্ত্রী সিপপোরা তখন বাপের বাড়ীতে থাকত কারণ মোশিই তার স্ত্রীকে বাপের বাড়ী পাঠিয়ে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","যিথ্রো তার সঙ্গে শুধু মোশির স্ত্রীকেই নয়, মোশির দুই পুত্রকেও নিয়ে গিয়েছিল| প্রথম পুত্রের নাম গের্শোন কারণ সে যখন জন্মায় তখন মোশি বলেছিল, “আমি পরদেশে প্রবাসী|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","দ্বিতীয় পুত্রের নাম ইলীয়েষর| নামকরণের কারণ হিসেবে দ্বিতীয় পুত্রের জন্মের সময় মোশি বলেছিল, “আমার পিতার ঈশ্বর, আমাকে সাহায্য করেছেন এবং ফরৌণের তরবারি থেকে রক্ষা করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","যিথ্রো মোশির স্ত্রী ও দুই পুত্রকে নিয়ে মোশির শিবিরে পৌঁছালো| মোশি তখন ঈশ্বরের পর্বতের কাছে মরুভূমিতে শিবিরে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","যিথ্রো মোশির উদ্দেশ্যে একটি বার্তায় বলে পাঠাল, “আমি তোমার শ্বশুর যিথ্রো| আমি তোমার স্ত্রী ও দুই পুত্রকে সঙ্গে করে নিয়ে এসেছি|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","তখন মোশি তাঁবু থেকে বেরিয়ে এসে শ্বশুরকে হাঁটু গেড়ে প্রণাম ও চুম্বন করল| দুজনে দুজনের শরীর ও স্বাস্থ্যের খোঁজ খবর নিয়ে মোশির তাঁবুতে প্রবেশ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ইস্রায়েলের লোকদের জন্য প্রভু যা যা করেছেন মোশি তা বিস্তারিতভাবে যিথ্রোকে বলল| মোশি জানাল, প্রভু ফরৌণ ও মিশরের লোকদের কি অবস্থা করেছেন| যাত্রাপথে যে সমস্ত সমস্যার সম্মুখীন হতে হয়েছিল সে সমস্ত সমস্যার কথাও সে বলল| প্রত্যেকটি সমস্যার ক্ষেত্রে প্রভু কিভাবে ইস্রায়েলের লোকদের রক্ষা করেছেন তাও সে শ্বশুরকে খুলে বলল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","মিশরীয়দের হাত থেকে ইস্রায়েলীয়দের উদ্ধার করবার সময় প্রভু তাদের জন্য যে সমস্ত ভাল কাজগুলি করেছিলেন সে সম্বন্ধে শুনে যিথ্রো খুশী হল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","যিথ্রো বলল, “প্রভুর প্রশংসা করো! তিনিই তোমাদের মিশরীয়দের কবল থেকে মুক্ত করেছেন| ফরৌণের হাত থেকেও প্রভু তোমাদের রক্ষা করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","এখন আমি জানি সকল দেবতার থেকে প্রভুই মহান! তারা ভাবত তারাই একমাত্র ক্ষমতার অধিকারী কিন্তু দেখ ঈশ্বর কি করে দেখালেন!” ");
INSERT INTO ben2006_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","মোশির শ্বশুর যিথ্রো ঈশ্বরের প্রতি সম্মানার্থে নৈবেদ্য ও বলি দিল| তখন হারোণ ও ইস্রায়েলের অন্যান্য প্রবীণ নেতারা এসে ঈশ্বরের সামনে মোশি ও যিথ্রোর সঙ্গে একসঙ্গে আহার করল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","পরদিন মোশি লোকদের বিচার করতে বসল| বিচার সভায় এত লোক হয়েছিল যে সবাইকে সকাল থেকে সন্ধ্যা পর্যন্ত দাঁড়িয়ে থাকতে হল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","মোশিকে লোকদের বিচার করতে দেখে যিথ্রো তাকে জিজ্ঞেস করল, “তুমি কেন একা বিচারকের দায়িত্ব পালন করছো? এবং সবাই সারাদিন ধরে কেনই বা শুধু তোমার কাছেই আসছে?” ");
INSERT INTO ben2006_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","তখন মোশি তার শ্বশুরকে বলল, “লোকরা আমার কাছে ঈশ্বরের সিদ্ধান্ত জানতে আসে| ");
INSERT INTO ben2006_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","যখন মানুষদের মধ্যে কোন বিবাদ তৈরী হয় তখন তারা আমার কাছে আসে| আমিই ঠিক করে দিই কে সঠিক আর কে বেঠিক| এই উপায়ে আমি মানুষের মধ্যে ঈশ্বরের বিধি ও শিক্ষাকে ছড়িয়ে দিই|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","কিন্তু মোশির শ্বশুর তাকে বলল, “এটা ঐ কাজের সঠিক উপায় নয়| ");
INSERT INTO ben2006_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","এটা তোমার একার কাজ নয়| তুমি একা এই কাজ করতে পারবে না| এভাবে তুমিও উদ্যম হারাবে এবং লোকরাও ক্লান্ত হয়ে পড়বে! ");
INSERT INTO ben2006_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","এখন মন দিয়ে আমার কথা শোন| আমার কিছু উপদেশ গ্রহণ করো| এবং আমি প্রার্থনা করি ঈশ্বর যেন সর্বদা তোমার সঙ্গে থাকেন| তুমি সর্বদা লোকদের সমস্যা শুনে যাবে এবং সেগুলো নিয়ে তুমি সর্বদা ঈশ্বরের কাছে বলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","তুমি ঈশ্বরের বিধি ও শিক্ষামালাকে লোকদের মধ্যে জাগিয়ে তুলবে| তাদের বলবে তারা যেন ঈশ্বর প্রদত্ত বিধিকে না ভাঙ্গে| তাদের বলবে সঠিক পথে চলতে| তাদের কি করা উচিৎ‌ তাও বলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","কিন্তু তোমাকে কিছু মানুষকে বিচারক হিসাবে এবং নেতা হিসেবে নির্বাচন করতে হবে| “কিছু ভাল মানুষ যাদের তুমি বিশ্বাস করতে পারো তাদের নির্বাচন করো–তারা ঈশ্বরকে সম্মান করবে| তাদেরই নির্বাচন করবে যারা অর্থের জন্য নিজেদের সিদ্ধান্ত বদল করবে না এবং এদের মানুষদের শাসক হিসাবে তৈরি করো| 1000 জন প্রতি, 100 জন প্রতি, 50 জন প্রতি এবং 10 জন প্রতি শাসক মনোনীত করো| ");
INSERT INTO ben2006_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","এবার ঐ লোকেদের শাসনের ভার এই শাসকদের হাতে ছেড়ে দাও| যদি কোনও গুরুত্বপূর্ণ মামলা থাকে তাহলে সেই শাসকরা সিদ্ধান্ত গ্রহণের জন্য তোমার কাছে আসবে| কিন্তু সাধারণ মামলার সিদ্ধান্তগুলি অবশ্য তারা নিজেরাই করে নেবে| এইভাবে তোমার বেশ কিছু কাজের ভার তারা বহন করবে এবং তার ফলে লোকদের নেতৃত্ব দিতে তোমারও সুবিধা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","যদি তুমি এভাবে এগোতে পারো, আর ঈশ্বর যদি চান তাহলে তুমি তোমার দায়িত্ব পালনে সক্ষম হবে এবং একইভাবে লোকরাও তাদের সমস্যার সমাধান করে ঘরে ফিরে যেতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","যিথ্রো যা বলল মোশি তাই করল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ইস্রায়েলের লোকদের থেকে কিছু ভাল লোককে সে মনোনীত করল| তারপর সে তাদের নেতা হিসেবে তুলে ধরল| মোশি প্রতি 1000 জনের জন্য, প্রতি 100 জনের জন্য, প্রতি 50 জনের জন্য, এবং প্রতি 10 জনের জন্য শাসক নিযুক্ত করল| ");
INSERT INTO ben2006_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","এরপর থেকে সেই প্রধানরাই সাধারণ লোকদের শাসন করতে শুরু করল| লোকদের মধ্যে বিবাদ দেখা দিলে তারা নিজের নিজের অঞ্চলের নির্দিষ্ট প্রধানের কাছে যেতে লাগল সমস্যা সমাধানের জন্য| কেবলমাত্র গুরুত্বপূর্ণ কোন সমস্যা বা মামলার সিদ্ধান্ত গ্রহণ করতে হত মোশিকে| ");
INSERT INTO ben2006_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","কিছুদিন পর মোশি তার শ্বশুর যিথ্রোকে বিদায় জানাল এবং যিথ্রো তার দেশে ফিরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","মিশর ছেড়ে এসে যখন ইস্রায়েলের লোকরা ভ্রমণ করছিল তখন সেই ভ্রাম্যমান অবস্থার তৃতীয় মাসে ইস্রায়েলের লোকরা সীনয় মরুভূমিতে পৌঁছোল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","তারা রফীদীম থেকে সীনয় পর্যন্ত ভ্রমণ করেছিল এবং পর্বতের কাছে তাঁবু ফেলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","তারপর মোশি পর্বতে উঠল ঈশ্বরের সঙ্গে সাক্ষাৎ করার উদ্দেশ্যে| সেই পর্বতে ঈশ্বর মোশিকে ডেকে বললেন, “ইস্রায়েলের লোকজন ও মহান যাকোব পরিবারের লোকজনকে একথাগুলি বলো: ");
INSERT INTO ben2006_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘তোমরা নিজেরাই দেখেছ আমি মিশরীয়দের কি অবস্থা করেছি| তোমরা দেখেছো আমি কিভাবে ঈগল পাখীর মতো মিশর থেকে তোমাদের বার করে আমার কাছে এখানে নিয়ে এসেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","তাই এখন আমি তোমাদের আমার নির্দেশগুলো মেনে চলতে বলছি| আমার চুক্তি পালন করো| তোমরা যদি তা করো তাহলে তোমরা হবে আমার বিশেষ লোক| এই পুরো পৃথিবীটাই আমার; কিন্তু আমি তোমাদের আমার বিশেষ লোক হিসেবে মনোনীত করেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","তোমরা যাজকদের একটি বিশেষ রাজ্য হবে|’ মোশি, তুমি কিন্তু আমি যা বলেছি তা ইস্রায়েলের লোকেদের অবশ্যই বলবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","তাই মোশি আবার পর্বত থেকে নীচে নেমে এসে ইস্রায়েলের প্রবীণ লোকদের প্রভুর সমস্ত নির্দেশ জানাল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","তারা সবাই সমস্বরে জানাল, “প্রভুর সব কথা আমরা মেনে চলব|” তখন মোশি প্রভুকে বলল যে প্রত্যেকেই তাঁকে মেনে চলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","এবং প্রভু মোশিকে বললেন, “ঘন মেঘের মধ্যে দিয়ে আমি তোমার কাছে আসব এবং তোমার সঙ্গে কথা বলব| এবং তোমার সঙ্গে আমার বাক্যলাপ প্রত্যেকটি লোক শুনতে পাবে| লোকদের কাছে তোমার বিশ্বাসযোগ্যতা বাড়ানোর জন্যই আমি এই উপায়ে তোমার সঙ্গে কথা বলব|” তখন মোশি লোকদের যাবতীয় বক্তব্য ঈশ্বরকে জানাল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","এবং প্রভু মোশিকে বললেন, “আজ এবং আগামীকাল তুমি একটা বিশেষ সভার জন্য লোকদের প্রস্তুত করো| তাদের অবশ্যই তাদের পোশাক ধুয়ে নিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","এবং তৃতীয় দিনে আমার জন্য তৈরী থাকতে হবে| তৃতীয় দিনে আমি সীনয় পর্বত থেকে নীচে নেমে আসব এবং প্রত্যেকটি মানুষ আমার দর্শন পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","কিন্তু তুমি প্রত্যেককে বলবে পর্বত থেকে দূরে সরে থাকতে| একটি রেখা টেনে সেই রেখা ওদের পার হতে বারণ করবে| কোন লোক বা প্রাণী যদি পর্বতকে স্পর্শ করে তাহলে তার মৃত্য়ু হবে| তাকে অবশ্যই পাথর দিয়ে অথবা তীর বিদ্ধ করে মেরে ফেলতে হবে| তাকে কেউ ছোঁবে না| শিঙা বেজে না ওঠা পর্যন্ত প্রত্যেকে অপেক্ষা করবে| তারপর তারা পর্বতে উঠতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","সুতরাং মোশি পর্বত থেকে নীচে নেমে এসে লোকদের বিশেষ সভার জন্য প্রস্তুত করল| লোকরা তাদের পোশাক পরিষ্কার করে নিল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","তখন মোশি লোকদের বলল, “তৃতীয় দিনে ঈশ্বরের সঙ্গে বিশেষ সভার জন্য প্রস্তুত হও| ঐদিন পর্যন্ত কোন পুরুষ নারীকে স্পর্শ করবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","তৃতীয় দিন সকালে, পর্বতের চূড়া থেকে ঘন মেঘ নীচে নেমে এল| মেঘ গর্জন ও বিদ্যুৎ রেখায় উচ্চস্বরে শিঙা বেজে উঠল| শিবিরের প্রত্যেকে ভয় পেয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","তখন মোশি সবাইকে শিবির থেকে বার করে পর্বতের কাছে ঈশ্বরের সঙ্গে সাক্ষাতের জন্য নিয়ে এল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","সীনয় পর্বত ধোঁয়ায় ঢেকে গেল| চূল্লীর মতো ধোঁয়া পাকিযে পাকিযে ওপরে উঠতে লাগল| সমস্ত পর্বত কাঁপতে শুরু করল| আগুনের শিখায় প্রভু পর্বত থেকে নীচে নেমে এলেন বলেই এই ঘটনা ঘটল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","শিঙার শব্দ ক্রমশঃ জোরালো হতে থাকল| মোশি যতবার ঈশ্বরের সঙ্গে কথা বলল ততবারই বজ্রের মতো কঠিন স্বরে ঈশ্বর উত্তর দিতে থাকলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","প্রভু সীনয় পর্বতে নেমে এলেন| এরপর প্রভু মোশিকে পর্বত শৃঙ্গে তাঁর কাছে যেতে বললেন| তখন মোশি পর্বতে চড়ল| ");
INSERT INTO ben2006_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","প্রভু মোশিকে বললেন, “নীচে গিয়ে লোকদের বলো ওরা যেন আমার কাছে না আসে| আমাকে যেন না দেখে| যদি তা করে তাহলে অনেকে মারা পড়বে| ");
INSERT INTO ben2006_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","আর যে সকল যাজক আমার কাছে আসবে তাদের বলো তারা যেন এই বিশেষ সভার জন্য নিজেদের তৈরি করে আসে| যদি তারা তা না করে তাহলে আমি তাদের শাস্তি দেব|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","মোশি প্রভুকে বলল, “কিন্তু লোকে পর্বতে চড়তে পারবে না| কারণ আপনিই তো বলেছিলেন একটি রেখা টানতে এবং সেই রেখা লঙঘন করে কেউ যেন পবিত্র ভূমিতে না আসে|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","প্রভু তাকে বললেন, “নীচে মানুষের কাছে যাও| গিয়ে হারোণকে তোমার সঙ্গে নিয়ে এসো| কিন্তু কোন সাধারণ মানুষ ও যাজককে আমার কাছে আসতে দিও না| যদি তারা আমার খুব কাছে আসে তাহলে আমি তাদের শাস্তি দেব|” ");
INSERT INTO ben2006_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","সুতরাং মোশি লোকদের এই কথাগুলি বলার জন্য নীচে নামল| ");
INSERT INTO ben2006_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","তখন ঈশ্বর এই সব কথা বললেন: ");
INSERT INTO ben2006_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“আমিই প্রভু, তোমাদের ঈশ্বর| আমিই তোমাদের মিশরের দাসত্ব থেকে মুক্ত করেছি| তাই তোমরা এই নির্দেশগুলি মানবে: ");
INSERT INTO ben2006_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“আমাকে ছাড়া তোমরা আর কোনও দেবতাকে উপাসনা করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“তোমরা অবশ্যই অন্য কোন মূর্তি গড়বে না যেগুলো আকাশের, ভূমির অথবা জলের নীচের কোন প্রাণীর মত দেখতে| ");
INSERT INTO ben2006_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","কোন মূর্ত্তির উপাসনা বা সেবা করবে না| কারণ, আমিই প্রভু, তোমাদের ঈশ্বর| যারা অন্য দেবতার উপাসনা করবে তাদের আমি ঘৃণা করি| আমার বিরুদ্ধে যারা পাপ করবে তারা আমার শত্রুতে পরিণত হবে| এবং আমি তাদের শাস্তি দেব| আমি তাদের সন্তানসন্ততি এবং পরবর্তী প্রজন্মকেও শাস্তি দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","কিন্তু যারা আমায় ভালবাসবে ও আমার নির্দেশ মান্য করবে তাদের প্রতি আমি সর্বদা দয়ালু থাকব| আমি তাদের হাজার প্রজন্ম পর্যন্ত দয়া প্রদর্শন করব| ");
INSERT INTO ben2006_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“তোমরা তোমাদের প্রভু ঈশ্বরের নাম ভুল ভাবে ব্যবহার করবে না| যদি কেউ তা করে তাহলে সে দোষী এবং প্রভু তাকে নির্দোষ সাব্যস্ত করবেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“বিশ্রামের দিনটিকে বিশেষ দিন হিসাবে মনে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","সপ্তাহে ছয় দিন কাজ করো| ");
INSERT INTO ben2006_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","কিন্তু সপ্তমদিনটি হবে অবসরের| প্রভু, তোমাদের ঈশ্বরের প্রতি সম্মান প্রর্দশনের দিন| সুতরাং সেই দিনে কেউ কাজ করবে না-তুমি নয়, অথবা তোমার ছেলেরা এবং মেয়েরা, অথবা তোমার স্ত্রী, অথবা তোমার ক্রীতদাস-দাসীরা কেউ নয়| এমনকি তোমাদের গৃহপালিত পশু এবং তোমাদের শহরে বাস করা বিদেশীরাও বিশ্রামের দিনে কোন কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","কারণ প্রভু সপ্তাহে ছয় দিন কাজ করে এই আকাশ, পৃথিবী, সমুদ্র এবং এর মধ্যস্থিত সব কিছু বানিয়েছেন এবং সপ্তমদিনে তিনি বিশ্রাম নিয়েছেন| এইভাবে বিশ্রামের দিনটি প্রভুর আশীর্বাদ ধন্য–ছুটির দিন| প্রভু এই দিনটিকে বিশেষ দিন হিসাবে সৃষ্টি করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“তুমি অবশ্যই তোমার পিতামাতাকে সম্মান করবে, তাহলে তোমরা তোমাদের দেশে দীর্ঘ জীবনযাপন করবে| যেটা প্রভু, তোমাদের ঈশ্বর তোমাদের দিচ্ছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“কাউকে হত্যা কোরো না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ব্যাভিচার কোরো না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“চুরি কোরো না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“অন্যদের সম্বন্ধে মিথ্যা বোলো না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“তোমাদের প্রতিবেশীর ঘরবাড়ীর প্রতি লোভ কোরো না| তার স্ত্রীকে ভোগ করতে চেয়ো না| এবং তার দাস-দাসী, গবাদি পশু অথবা গাধাদের আত্মসাত্‌ করতে চেয়ো না| অন্যদের কোন কিছুর প্রতি লোভ কোরো না|” ");
INSERT INTO ben2006_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ঐ সময়ে, লোকজন বজ্র নির্ঘোষ শুনতে পেল এবং বিদ্যুৎ দেখতে পেল| তারা শিঙার শব্দ শুনতে পেল এবং দেখল ধোঁয়া ওপর দিকে উঠছে| এই দেখে লোকরা ভয়ে কুঁকড়ে গেল| পর্বত থেকে দূরে দাঁড়িয়ে তারা এই ঘটনা দেখতে লাগল| ");
INSERT INTO ben2006_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","তখন লোকরা মোশিকে বলল, “তুমি যদি আমাদের সঙ্গে কথা বলতে চাও তাহলে তা আমরা শুনব| কিন্তু ঈশ্বর যেন আমাদের সঙ্গে কথা না বলেন| তিনি কথা বললে আমরা ভয়ে মারা যাব|” ");
INSERT INTO ben2006_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","তখন মোশি তাদের বলল, “ভয় পেও না| প্রভু তোমাদের পরীক্ষা করতে আবির্ভূত হয়েছেন| তিনি চান তোমরা তাঁকে সম্মান কর, যাতে তোমরা পাপ কাজ না কর|” ");
INSERT INTO ben2006_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","লোকরা পর্বত থেকে দূরে দাঁড়িয়ে থাকল, আর তখন মোশি অন্ধকার মেঘের ভেতর ঈশ্বরের কাছে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","তখন প্রভু মোশিকে, ইস্রায়েলের লোকদের এই কথাগুলি বলার জন্য বললেন: “তোমরা দেখেছো যে আমি স্বর্গ থেকে তোমাদের সঙ্গে কথা বলেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","সুতরাং তোমরা আমার সঙ্গে তুলনা করে সোনা অথবা রূপো দিয়ে অন্য কোন মূর্ত্তি গড়বে না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“আমার জন্য একটি বিশেষ বেদী তৈরী করো| বেদী তৈরীর সময় মাটি ব্যবহার করবে| আমার প্রতি উৎসর্গ হিসেবে ঐ বেদীর ওপর হোমবলি ও মঙ্গল নৈবেদ্য নিবেদন করবে| বলিতে তোমাদের গৃহপালিত মেষ অথবা গবাদি পশু ব্যবহার করবে| যেখানে যেখানে আমি তোমাদের আমাকে মনে রাখতে বলেছি সেই সব স্থানে তোমরা এই বলিগুলি দেবে| তখন আমি এসে তোমাদের আশীর্বাদ করব| ");
INSERT INTO ben2006_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","পাথরের বেদী তৈরী করলে কোন লোহার অস্ত্র দিয়ে, কাটা পাথর ফলক দিয়ে সেই বেদী তৈরী করবে না| যদি তা করো তাহলে সেই বেদী গ্রহণযোগ্য হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","এবং আমার বেদীতে কোন সিঁড়ি তৈরী করবে না| যদি বেদীতে সিঁড়ি থাকে তাহলে ঐ সিঁড়ি দিয়ে মানুষ যখন উঠবে তখন নীচের লোকদের কাছে তাদের নগ্নতা প্রকাশ পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","তারপর ঈশ্বর মোশিকে বললেন, “তুমি অন্য এই সব নিয়মের কথাও লোকদের বলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“তুমি যদি ইব্রীয় দাস ক্রয় করো তবে সে ছয় বছর দাসত্ব করার পর বিনামূল্যে মুক্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","যদি তোমার দাস থাকাকালীন সে বিবাহিত না হয় তাহলে মুক্তির সময়েও সে একাই মুক্তি পাবে| কিন্তু যদি সে বিবাহিত হয় তাহলে সে সস্ত্রীক মুক্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","যদি দাসটি বিবাহিত না হয় তাহলে তার মনিব তাকে বিয়ে দিতে পারে| সে যদি পুত্র অথবা কন্যা ধারণ করে তাহলে সে এবং তার ছেলেমেয়েরা মনিবের অধিকারভুক্ত হবে এবং সে নিজে ঐ মনিবের কাছে থাকবে এবং দাসের নিজের কর্মকাল শেষ হবার পর সে একা মুক্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“কিন্তু যদি দাসটি বলে, ‘আমি আমার মনিবকে, আমার পত্নীকে এবং ছেলে-মেয়েদের ভালবাসি, তাই আমি মুক্ত হতে চাই না,’ ");
INSERT INTO ben2006_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","যদি এরকম হয় তাহলে তার মনিব দাসটিকে ঈশ্বরের কাছে নিয়ে আসবে| তারপর তার মনিব তাকে একটি দরজা বা দরজার কাঠের কাঠামোর কাছে নিয়ে যাবে| তারপর ছুঁচালো একটি যন্ত্র দিয়ে মনিব তার দাসের কানে একটি ফুটো করবে| তাহলে সেই দাস সারাজীবন তার মনিবের সেবা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“কোন ব্যক্তি যদি তার কন্যাকে দাস হিসেবে বিক্রি করতে চায় তাহলে তার মুক্তি পাওয়ার নিয়ম পুরুষ দাসদের নিয়মের থেকে আলাদা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","যদি সেই মহিলার মনিব তার প্রতি অসন্তুষ্ট হয় তাহলে সে তার মহিলা দাসটিকে তার পিতার কাছে ফেরৎ‌ পাঠাতে পারে| যদি মনিবটি তাকে বিয়ের প্রতিশ্রুতি দেয়, তাহলে অন্য লোকের কাছে তাকে বিক্রি করতে পারবে না কারণ সেটা হবে অন্যায়| ");
INSERT INTO ben2006_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","যদি তার মনিব মহিলা দাসটিকে তার পুত্রের সঙ্গে বিয়ে দেবে বলে প্রতিশ্রুতি দেয় তবে তাকে দাসের মতো না রেখে মেয়ের মতো রাখতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“যদি মনিব অন্য কোনও স্ত্রীলোককে বিয়ে করে তাহলে সে তার প্রথম স্ত্রীকে কম খাবার বা কম জামাকাপড় দিতে পারবে না| সে তার স্ত্রীর প্রতি বিবাহের অধিকার হিসেবে সব কর্তব্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","মনিব যদি এই তিনটি জিনিস না করে তাহলে তার স্ত্রী বিনামূল্যে তার কাছে থেকে মুক্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“যদি কোনও ব্যক্তি কাউকে আঘাত করে হত্যা করে তাহলে সেই ব্যক্তিকেও হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","কিন্তু যদি একটি দুর্ঘটনায়় কোন ব্যক্তি মারা যায় তাহলে সেটা ঈশ্বরের অভিপ্রায় বলে ধরে নেওয়া হবে| আমি কতগুলি বিশেষ জায়গা বেছে দেব যেগুলি লোকরা নিরাপদ আশ্রয় হিসেবে ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","কিন্তু কোনও ব্যক্তি যদি ক্রোধ বা ঘৃণা থেকে কাউকে হত্যা করে তবে সে শাস্তি পাবে| তাকে আমার বেদী থেকে সরিয়ে নিয়ে গিয়ে হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“যে ব্যক্তি পিতা বা মাতাকে আঘাত করবে তাকে হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“যদি কোনও ব্যক্তি কাউকে চুরি করে দাস হিসেবে বিক্রি করতে চায় বা নিজের দাস করে রাখতে চায় তাহলে তাকে হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“যে ব্যক্তি তার পিতা বা মাতাকে অভিশাপ দেয়, তাকে হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“পরস্পর ঝগড়া করবার সময় যদি একজন অপর ব্যক্তিকে পাথর অথবা তার মুষ্টি দিয়ে আঘাত করে তাহলে তার শাস্তি পাওয়া উচিৎ‌| যে আহত সে যদি মারা না যায় তবে যে আঘাত করেছে তাকে হত্যা করা হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","আহত ব্যক্তি যদি কিছু সময়ের জন্য শয্যাশায়ী থাকে তাহলে যে আঘাত করেছে সে তার সময়ের ক্ষতিপূরণ দেবে, যতদিন না আহত ব্যক্তি সুস্থ হয়ে ওঠে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“কখনও কখনও মনিব তার পুরুষ বা স্ত্রী দাসদের প্রহার করে থাকে, যদি এই প্রহারে দাসটি মারা যায় তবে তার ঘাতক শাস্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","কিন্তু যদি দাসটি মারা না গিয়ে কয়েকদিন বাদে সেরে ওঠে তবে তার মনিবকে কিছু বলা হবে না কারণ সে তার দাসের জন্য অর্থ ব্যয করে থাকে এবং সে দাসটি তার সম্পত্তি| ");
INSERT INTO ben2006_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“দুটি মানুষ ঝগড়া করার সময় যদি কোনও গর্ভবতী মহিলাকে আঘাত করে এবং এর ফলে যদি তার গর্ভপাত হয়ে যায় এবং অন্য কোন ক্ষতি না হয় তাহলে যে আঘাত করেছে সে শুধু তাকে জরিমানা দিয়ে ছাড়া পেয়ে যাবে| ঐ মহিলার স্বামী জরিমানার টাকার অংশ ঠিক করে দেবে| বিচারকরা এই ব্যাপারে তাকে সাহায্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","কিন্তু যদি সেই মহিলার আঘাতের ফলে কোন ক্ষতি হয় তাহলে যে তাকে আঘাত করবে তাকে শাস্তি দেওয়া হবে, যে অন্যকে হত্যা করবে তাকেও মরতে হবে| একজনের জীবনের বদলে অন্যের জীবন নেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","তুমি চোখের বদলে চোখ নেবে, দাঁতের বদলে দাঁত, হাতের বদলে হাত, পায়ের বদলে পা নেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","পোড়ার বদলে পোড়াবে, চোটের বদলে চোট দেবে, কাটার বদলে কাটবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“যদি কোন ব্যক্তি তার দাসের চোখে আঘাত করে তাকে অন্ধ করে দেয় তাহলে সেই দাসকে মুক্তি দিয়ে দিতে হবে| তার চোখ হল তার মুক্তির মূল্য, স্ত্রী বা পুরুষ দাসের ক্ষেত্রে এই একই নিয়ম খাটবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","যদি কোনও মনিব তার দাসকে মুখে আঘাত করে তার দাঁত ফেলে দেয় তবে তাকে মুক্তি দিতে হবে, তার দাঁত হবে তার মুক্তির মূল্য, এই নিয়ম স্ত্রী ও পুরুষ উভয় দাসের ক্ষেত্রেই প্রযোজ্য হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“যদি কোনও ব্যক্তির ষাঁড় কোন স্ত্রী বা পুরুষকে মেরে ফেলে তাহলে ঐ ষাঁড়কে পাথর দিয়ে মেরে হত্যা করতে হবে| ঐ ষাঁড়কে খাওয়াও যাবে না| কিন্তু ষাঁড়ের মালিক দোষী হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","কিন্তু যদি ষাঁড়টি ইতিপূর্বে কাউকে আঘাত করে থাকে এবং তার মালিককে সতর্ক করে দেওয়া হয়ে থাকে, তাহলে সেই মালিককে দোষী সাব্যস্ত করা হবে| কেননা সে জানা সত্ত্বেও ষাঁড়টিকে যথাস্থানে বেঁধে বা আটকে রাখে নি| আর যদি এরকম ষাঁড়কে ছেড়ে রাখার ফলে কারো প্রাণ যায় তাহলে সেই ষাঁড় ও তার মালিক দুজনকেই পাথর দিয়ে আঘাত করে মেরে ফেলা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","কিন্তু মৃত ব্যক্তির পরিবার যদি অর্থ গ্রহণ করে তাহলে ষাঁড়ের মালিককে মারা হবে না| কিন্তু সে বিচারকদের নির্ধারিত টাকার অঙ্ক জরিমানা দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“এই একই নিয়ম বলবৎ থাকবে যদি ষাঁড়টি কোনও লোকের পুত্র বা কন্যাকে হত্যা করে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","কিন্তু ষাঁড়টি যদি কোনও দাসকে হত্যা করে তবে তার মালিককে 30 টুকরো রূপো দিতে হবে মূল্য হিসেবে এবং ষাঁড়টিকে পাথর দিয়ে মারা হবে| এই নিয়ম স্ত্রী ও পুরুষ দাসের ক্ষেত্রে একই হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“কোনও ব্যক্তি কুঁয়োর ওপরের ঢাকা সরিয়ে দিতে পারে বা গভীর গর্ত খুঁড়ে ঢাকা না দিয়ে রাখতে পারে| যদি কোন ব্যক্তির পোষা জন্তু এসে এই গর্তে পড়ে যায় তবে গর্তের মালিককে দায়ী করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","গর্তের মালিককে জন্তুটির মূল্য দিতে হবে কিন্তু মূল্য দেওয়ার পর সে জন্তুটির দেহ নিজের কাছে রাখার অধিকার পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“যদি এক ব্যক্তির ষাঁড় আরেক ব্যক্তির ষাঁড়কে হত্যা করে তখন জীবিত ষাঁড়টিকে বিক্রি করে দিতে হবে| উভয় ব্যক্তি সেই বিক্রয় মূল্যের অর্ধেক ভাগ পাবে এবং মৃত ষাঁড়টির দেহের অর্ধেক ভাগ পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","যদি কারো ষাঁড় অন্য কারো ব্যক্তির জন্তুদের গুঁতিয়ে মেরে ফেলার জন্য পরিচিত থাকে, তবে সেই ষাঁড়ের মালিককে তার জন্য দায়ী করা হবে| যদি ষাঁড়টি অন্য ষাঁড়কে মেরে ফেলে, তাহলে তার মালিককেই দায়ী করা হবে কারণ সে ষাঁড়টিকে ছেড়ে রেখেছে| তাকে অবশ্যই মৃত ষাঁড়ের মূল্য দিতে হবে কিন্তু মৃত ষাঁড়টি সে নিজের জন্য রাখতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“যে ব্যক্তি ষাঁড় বা মেষ চুরি করেছে তাকে কিভাবে শাস্তি দেবে? যদি সে প্রাণীটিকে হত্যা করে বা বিক্রি করে দেয় তবে সে সেটা ফেরৎ‌ দিতে পারবে না, তাই তাকে একটা চুরি করা ষাঁড়ের বদলে পাঁচটা ষাঁড় কিনে দিতে হবে বা একটা মেষের বদলে চারটি মেষ দিতে হবে| তাকে চুরির জন্য জরিমানা দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","যদি তার কাছে কিছু না থাকে তাহলে তাকে দাস হিসেবে বিক্রি করে দেওয়া হবে| যদি তুমি লোকটির কাছে জন্তুটিকে দেখতে পাও, তবে চোরকে অবশ্যই চুরি করা জন্তুটির মূল্যের দ্বিগুণ মূল্য দিতে হবে| প্রাণীটি ষাঁড় বা গাধা বা মেষ যাই হোক্ না কেন নিয়ম একই থাকবে| “যদি সিঁধ কেটে চুরি করার সময় কোনও চোর মারা যায় তবে কেউই দোষী হবে না| কিন্তু যদি এটা দিনের বেলায় হয় তাহলে যে হত্যা করবে সে দায়ী হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“যখন একটি ব্যক্তি তার গৃহপালিত জন্তুদের তার নিজের ক্ষেতে অথবা দ্রাক্ষাক্ষেতে চরতে দেয়, কিন্তু তারা যদি বিপথে গিয়ে অন্য কারো ক্ষেতে অথবা দ্রাক্ষাক্ষেতে চরে বেড়ায় তাহলে তাকে তার ক্ষেতের অথবা দ্রাক্ষাক্ষেতের সবচেয়ে ভালো ফসল দিয়ে ক্ষতিপূরণ দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“কেউ যদি তার প্রতিবেশীর শস্যের গাদা অথবা যে শস্য কাটা হয়নি তা অথবা পুরো ক্ষেতটি পুড়িয়ে ফেলে, তাহলে যা কিছু পুড়ে গেছে তার ক্ষতিপূরণ তাকে দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“কোনও ব্যক্তি তার টাকা বা অন্য কিছু তার প্রতিবেশীর কাছে রাখতে দিতে পারে| কিন্তু যদি প্রতিবেশীর বাড়ি থেকে সেই জিনিস চুরি হয়ে যায় তবে কি করবে? চোরকে খুঁজে বার করার চেষ্টা করবে| যদি চোরকে পাওয়া যায় তবে চোর চুরি করা জিনিসের মূল্যের দ্বিগুণ জরিমানা দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","যদি চোরকে খুঁজে পাওয়া না যায়, তাহলে ঈশ্বর বিচার করবেন যেখান থেকে চুরি হয়েছে সেই বাড়ির মালিক দোষী কি না| বাড়ির মালিক ঈশ্বরের কাছে যাবে এবং ঈশ্বর বিচার করবেন যে সে কিছু চুরি করেছে কি না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“যদি কোনও দুই ব্যক্তি উভয়েই কোনও ষাঁড় বা গাধা বা মেষ বা কোনও হারানো বস্তুকে নিজের বলে দাবী করে তাহলে তারা দুজনেই ঈশ্বরের কাছে যাবে| ঈশ্বর যাকে দোষী করবেন সে অপর ব্যক্তিকে সেই জিনিসটির মূল্যের দ্বিগুণ দাম দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“কোনও ব্যক্তি তার কোন প্রাণীর রক্ষণাবেক্ষণের জন্য তার প্রতিবেশীকে অল্প সময়ের জন্য ভার দিতে পারে| সেটা গাধা বা ষাঁড় বা মেষ হতে পারে কিন্তু যদি সেই প্রাণী আহত হয় বা মারা যায় বা কারো অলক্ষ্যে চুরি হয়ে যায় তাহলে কি করবে? ");
INSERT INTO ben2006_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","তখন সেই প্রতিবেশীকে প্রভুর নামে শপথ করে বলতে হবে যে সে চুরি করে নি| তখন প্রাণীর মালিক সেই শপথ গ্রাহ্য করবে এবং প্রতিবেশীকে সেই মৃত প্রাণীর জন্য কোন জরিমানা দিতে হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","কিন্তু যদি সেই প্রতিবেশী চুরি করে থাকে তবে তাকে জরিমানা দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","যদি কোন বন্য জন্তু প্রাণীটিকে মেরে ফেলে তবে তার দেহ প্রমাণ হিসেবে দেখাতে হবে| তাহলে প্রতিবেশীকে জরিমানা দিতে হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“যদি কোনও ব্যক্তি তার প্রতিবেশীর কাছ থেকে ধার নেয় তবে সে তার জন্য দায়ী থাকবে| যদি কোন প্রানী আহত হয় বা মারা যায় তবে প্রতিবেশী প্রানীর মালিককে জরিমানা দেবে| প্রতিবেশীই দায়ী কারণ মালিক সেখানে উপস্থিত ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","কিন্তু যদি প্রানীর মালিক সেখানে উপস্থিত থাকে তাহলে প্রতিবেশীকে জরিমানা দিতে হবে না| যদি প্রতিবেশী প্রানীটিকে ব্যবহারের জন্য টাকা দেয় তাহলে তাকে প্রাণীটি আহত হলে বা মারা গেলে জরিমানা দিতে হবে না| সে ঐ প্রানীটি ব্যবহারের জন্য যা মূল্য দিয়েছে তাই যথেষ্ট| ");
INSERT INTO ben2006_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“যদি, কোনও ব্যক্তি একজন অবাগদত্তা কুমারী মেয়ের সঙ্গে যৌন সম্পর্কে লিপ্ত হয় তাহলে সে অবশ্যই তার পিতাকে পুরো যৌতুক দেবে এবং তাকে বিয়ে করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","যদি তার পিতা মেয়েটিকে সেই ব্যক্তির সঙ্গে বিয়ে দিতে নাও চান তাহলেও তাকে মেয়েটির জন্য পুরো অর্থ দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“যদি কোন স্ত্রীলোক দুষ্ট কূহক করে তবে তাকে বাঁচতে দিও না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“কোন মানুষ যদি কোন পশুর সঙ্গে যৌন সম্পর্ক করে তবে তাকে অবশ্যই হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“যদি কোন ব্যক্তি মূর্ত্তিকে নৈবেদ্য দেয় তবে তাকে হত্যা করবে| তোমরা অবশ্যই কেবলমাত্র প্রভুর কাছেই নৈবেদ্য উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“মনে রাখবে তোমরা ইতিপূর্বে মিশরে বিদেশী ছিলে তাই তোমরা কোন বিদেশীকে ঠকাবে না বা আঘাত করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“কোন বিধবা বা অনাথ শিশুর কখনও কোনও ক্ষতি করো না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","যদি তুমি ঐসব বিধবা ও অনাথদের নির্যাতন কর তাহলে আমি তাদের দুর্দশার কথা জেনে যাব| ");
INSERT INTO ben2006_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","এতে আমি রেগে গিয়ে তোমাকে হত্যা করব, যার ফলে তোমার স্ত্রী বিধবা হবে এবং তোমার সন্তানরা অনাথ হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“যদি আমার লোকদের মধ্যে কেউ দরিদ্র হয় এবং তাকে তুমি কিছু টাকা ধার দাও, তাহলে ঐ টাকার ওপর কোন সুদ দাবী করো না অথবা তাকে সুদ দিতে বাধ্য করো না| সুদ নিয়ে যে টাকা দেয় তার মতো ব্যবহার করো না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","যদি কোনও ব্যক্তি তোমার কাছে ধার শোধ করার প্রমাণ হিসেবে তার গায়ের শীতবস্ত্র বন্ধক রাখে তবে তুমি সূর্যাস্তের আগে তাকে সেটা ফিরিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","যদি তার শীতবস্ত্র না থাকে তবে সে শীতে কষ্ট পাবে এবং তার কান্না আমি শুনতে পাবো কারণ আমি দয়ালু| ");
INSERT INTO ben2006_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ঈশ্বর বা জনগণের নেতাদের কখনও অভিশাপ দিও না| ");
INSERT INTO ben2006_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ফসল কাটার সময় প্রথম শস্যের দানা ও প্রথম ফলের রস বছরের শেষ পর্যন্ত অপেক্ষা না করেই আমাকে দেবে| “তোমাদের প্রথম সন্তানকে আমার কাছে উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","তোমাদের প্রথমজাত গরু বা মেষও আমাকে দেবে| প্রথম নবজাতককে তার মায়ের কাছে সাত দিন রেখে অষ্টম দিনে আমাকে দিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“তোমরা আমার বিশেষ লোক, কোন বন্য প্রাণীর মেরে ফেলা পশুর মাংস খাবে না| সেই মাংস কুকুরকে খেতে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“অন্যদের বিরুদ্ধে মিথ্যে অপবাদ রটিও না| যদি তুমি আদালতে সাক্ষী দিতে যাও তাহলে একজন খারাপ লোককে সাহায্যের জন্য মিথ্যা সাক্ষ্য দিও না| ");
INSERT INTO ben2006_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“সবাই যা করছে তুমিও তাই করতে যেও না| যদি একটি গোষ্ঠীর মানুষ অন্যায় করে তাহলে তুমিও তাদের দলে গিয়ে ভিড়ে যেও না, বরং তুমি তাদের ইন্ধন না জুগিয়ে যা সঠিক এবং ন্যায়্য তাই করো| ");
INSERT INTO ben2006_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“কোন মামলা-মকদ্দমায় কোন দরিদ্র লোককে তোমার বিশেষ অনুগ্রহ করা অবশ্যই উচিৎ‌ নয়| ");
INSERT INTO ben2006_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“যদি কোনও ব্যক্তির বলদ অথবা গাধা হারিয়ে যায় আর তা যদি তুমি খুঁজে পাও তাহলে সঙ্গে সঙ্গে তুমি হারিয়ে যাওয়া বলদ বা গাধাটিকে তার মালিকের কাছে ফিরিয়ে দেবে| এমনকি সে যদি তোমার শত্রু হয় তাহলেও তুমি এটাই করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“যদি কোন মালবাহী পশু মালের ভারে আর চলতে না পারার মতো অবস্থায় পৌঁছে যায় তাহলে তুমি সেই পশুটির ভার লাঘব করতে সচেষ্ট হবে| সেই পশুটি যদি তোমার শত্রুও হয় তাহলেও তুমি তা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“কোনও দরিদ্রের সঙ্গে কোনরকম অন্যায় হতে দিও না| সাধারণ মানুষদের মতোই একই বিধানে সেই দরিদ্রের বিচার হওয়া উচিত| ");
INSERT INTO ben2006_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“কাউকে দোষী হিসেবে চিহ্নিত করার আগে সচেতন থেকো| কারো বিরুদ্ধে মিথ্যা অপবাদ দিও না| কোনও নির্দোষ মানুষকে শাস্তি পেতে দেখলে তার বিরুদ্ধে রুখে দাঁড়িয়ে অন্যায়ের প্রতিবাদ জানাবে| যে একজন নির্দোষ মানুষকে হত্যা করে সে একজন পাপী এবং আমি কখনই তাকে ক্ষমা করব না| ");
INSERT INTO ben2006_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“যদি কেউ তোমাকে তার অন্যায় কাজকর্মের সঙ্গী হবার জন্য ঘুষ দিতে চায় তাহলে তুমি সেই ব্যক্তির প্রস্তাব গ্রহণ করবে না| কারণ ঘুষের অর্থ সত্যকে দেখার দৃষ্টি ঢেকে দেয় এবং এই ধরণের ঘুষের অর্থ ভাল মানুষদের মিথ্যা বলতে প্রলুদ্ধ করে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“কোনও বিদেশীর সঙ্গে খারাপ ব্যবহার করবে না কারণ এক সময় তোমরা যখন মিশরে ছিলে তোমরাও তখন সে দেশে বিদেশী হিসেবেই বাস করতে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ছয় বছর ধরে জমিতে চাষ করো, বীজ বোনো, ফসল ফলাও| ");
INSERT INTO ben2006_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","কিন্তু সপ্তম বছরে আর নিজের জমিকে চাষের জন্য ব্যবহার করবে না| সপ্তম বছরটি হবে জমির বিশেষ বিশ্রামের সময়| তাই জমিতে সে বছর আর কোনও চাষ করবে না| তবু যদি সেই জমিতে কোনও ফসল ফলে তাহলে সেই ফসল গরীব মানুষদের দিয়ে দিতে হবে এবং বাকী যা পড়ে থাকবে তা খেতে দেবে বন্য প্রানীদের| তোমাদের দ্রাক্ষাক্ষেত ও জলপাই গাছগুলির ক্ষেত্রেও একই নিয়ম খাটাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“সপ্তাহে ছদিন কাজ করার পর সপ্তম দিনটি ছুটির দিন হিসাবে ঘোষণা করো| ছুটির দিন শুধু বিশ্রামের জন্য তুলে রাখবে| তুমি অবশ্যই তোমার ক্রীতদাসদের এবং বিদেশীদের এবং এমন কি তোমার গৃহপালিত ষাঁড় এবং গাধাদের সাময়িক অবকাশ দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“এই সমস্ত নিয়মগুলো তুমি সাবধানে মেনে চলবে| অন্য দেবতাদের নামও উচ্চারণ করো না; তোমার মুখে যেন ওগুলো না শুনতে পাওয়া যায়| ");
INSERT INTO ben2006_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“তোমাদের জন্য বছরে তিনটি বিশেষ ছুটির দিন থাকবে| তোমাদের আমাকে উপাসনার জন্য নির্দিষ্ট স্থানে আসতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","প্রথম ছুটির দিনটি হবে খামিরবিহীন রুটির উৎসব| আমার নির্দেশ মতো তা পালন করা হবে| এই সময় তোমরা যে রুটি খাবে তা হবে খামিরবিহীন| সাত দিন এই ভাবে চলবে| তোমরা এই নির্দেশ পালন করবে আবীব মাসে| কারণ এই সময়ই তোমরা মিশর থেকে ফিরে এসেছিলে| এই আবীব মাসে তোমরা প্রত্যেকে আমাকে উৎসর্গ করার জন্য কিছু না কিছু নিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“দ্বিতীয় ছুটির দিনটি হবে ফসল কাটার উৎসব| গ্রীষ্মের প্রথম দিকে এই দ্বিতীয় ছুটির দিন হবে| সে সময় তোমরা ক্ষেতের ফসল কাটবে| “তৃতীয় ছুটির দিনটি হবে ফসল তোলার উৎসব| বছরের শেষে যখন তোমরা জমি থেকে সব শস্য ঘরে তুলবে তখনই এই উৎসব পালিত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“সুতরাং প্রত্যেক বছরে তিনদিন সকলে সেই নির্দিষ্ট বিশেষ স্থানে জড়ো হয়ে তোমাদের প্রভুর সঙ্গে কাটাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“যখন তোমরা পশু বলি দিয়ে তার রক্ত প্রভুর উদ্দেশ্যে উৎসর্গ করবে তখন আর খামির দেওয়া রুটি উৎসর্গ করবে না| এবং ঐ বলির মাংস তোমরা একদিনে খেয়ে নেবে, পরের দিনের জন্য জমিয়ে রাখবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“ক্ষেত থেকে ফসল তোলার সময় সব ফসল তুলে প্রথমে নিয়ে আসবে তোমাদের ঈশ্বরের গৃহে| “কোন ছাগ শিশুকে তার মায়ের দুধে ফুটিয়ো না|” ");
INSERT INTO ben2006_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ঈশ্বর বললেন, “দেখ তোমাদের জন্য আমি একজন দূত পাঠাচ্ছি| আমি তোমাদের জন্য যে স্থান নির্বাচন করেছি তোমাদের সেইখানে নিয়ে যাওয়ার জন্য আমার পাঠানো দূত তোমাদের নেতৃত্ব দেবে| ঐ দূত তোমাদের রক্ষা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ঐ দূতকে অমান্য না করে তাকে অনুসরণ করো| তার বিরুদ্ধে কখনও অসন্তোষ প্রকাশ করো না| ঐ দূতের শরীরে আমার শক্তি আছে; সুতরাং সে কোনরকম অন্যায় বরদাস্ত করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","তোমরা তার সব কথা মেনে চলবে| আমার সব কথাও অক্ষরে অক্ষরে পালন করবে| যদি তোমরা তা করো তাহলে আমি তোমাদের সঙ্গে থাকব| তোমাদের শত্রুদের বিরোধিতা করব এবং যারা তোমার বিরুদ্ধে যাবে আমি তাদেরও শত্রুতে পরিণত হব|” ");
INSERT INTO ben2006_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ঈশ্বর বললেন, “আমার প্রেরিত দূত তোমাদের আগে আগে যাবে| সে তোমাদের নেতৃত্ব দেবে–ইমোরীয়, হিত্তীয়, পরিষীয়, কনানীয়, হিব্বীয় ও যিবূষীয়দের বিরুদ্ধে| কিন্তু আমি তাদের প্রত্যেককে পরাজিত করব| ");
INSERT INTO ben2006_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“তাদের দেবতাদের তোমরা পূজা করবে না| তোমরা সেইসব দেবতাদের কাছে নতজানু হবে না| তাদের জীবনযাপনের সঙ্গে তোমরা নিজেদের জড়াবে না| তোমরা তাদের মূর্তিদের ধ্বংস করবে এবং তোমরা তাদের দেবতাকে মনে রাখার সমস্ত স্তম্ভ ভেঙ্গে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","তোমরা সর্বদা তোমাদের প্রভুর সেবা অবশ্যই করবে| আমি তোমাদের রুটি ও জলকে আশীর্বাদ করব| আমি তোমাদের কাছ থেকে সমস্ত রোগ সরিয়ে নেব| ");
INSERT INTO ben2006_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","তোমাদের মহিলারা সন্তান ধারণে সক্ষম হয়ে উঠবে| তাদের কেউই সন্তান প্রসবকালে মারা যাবে না| আমি তোমাদের দীর্ঘ জীবন দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“তোমরা যখন তোমাদের শত্রুদের সঙ্গে যুদ্ধ করবে তখন আমি তোমাদের শক্তি জোগাবো| তোমাদের শত্রুদের যাতে তোমরা হারাতে পারো তাতে আমি সাহায্য করব| তোমাদের শত্রুরা হতচকিত হয়ে যুদ্ধক্ষেত্র থেকে পালাতে শুরু করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","আমি তোমাদের আগে একটা ভীমরুল পাঠাব| সেই তোমাদের শত্রুদের জোর করে তাড়িয়ে দেবে| হিব্বীয়, কনানীয় ও হিত্তীয়রা তোমাদের দেশ ত্যাগ করে পালাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","কিন্তু আমি শীঘ্রই ঐ সমস্ত মানুষগুলোকে জোর করে তোমাদের দেশ থেকে তাড়াব না| অন্তত এক বছর আমি ওদের তাড়াব না| কারণ তাহলে খুব তাড়াতাড়ি তোমাদের দেশ জনমানব শূন্য হয়ে পড়বে| ফলে সে সময় বন্য প্রানীরা ঢুকে পড়ে বংশবৃদ্ধির দ্বারা দেশটাকে দখল করে নেবে এবং তখন সেই সমস্ত প্রানীরাই তোমাদের সমস্যা সৃষ্টি করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","তাই আমি খুব ধীরে ধীরে ঐ মানুষগুলোকে তোমাদের দেশ থেকে তাড়াব| তোমরাও ক্রমশঃ দেশের অভ্যন্তরে প্রবেশ করতে থাকবে আর আমিও ওদের একে একে তাড়াতে থাকব| ");
INSERT INTO ben2006_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“সূফ সাগর থেকে ফরাৎ নদী পর্যন্ত সমস্ত জমি তোমাদের দিয়ে দেব| তোমাদের দেশের পশ্চিম সীমান্ত হবে পলেষ্টীয়দের সমুদ্র পর্যন্ত| আর পূর্ব দিকের সীমান্ত হবে আরব দেশের মরুভূমি| এই সীমানার মধ্যে বসবাসকারী প্রত্যেককে আমি তোমাদের দিয়েই পরাজিত করে তাড়িয়ে ছাড়ব| ");
INSERT INTO ben2006_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“তোমরা ঐ সমস্ত লোকদের সঙ্গে অথবা তাদের দেবতাদের সঙ্গে কোনরকম চুক্তি করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","তাদের তোমাদের দেশে একদম থাকতে দেবে না| যদি থাকতে দাও তাহলে তাদের ফাঁদে পা দিয়ে তোমরা আমার বিরুদ্ধে পাপ করবে এবং তোমরা ঐ লোকদের দেবতাদের পূজা করতে বাধ্য হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","প্রভু মোশিকে বললেন, “তুমি, হারোণ, নাদব, অবীহূ এবং ইস্রায়েলের 70 জন প্রবীণ নেতৃবৃন্দ পর্বতের ওপর উঠে এসে দূর থেকে আমার উপাসনা করো| ");
INSERT INTO ben2006_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","কিন্তু মোশি একাই প্রভুর কাছে আসবে| অন্যরা যেন প্রভুর কাছে না যায়| এমনকি বাকী লোকরা মোশির সঙ্গে পর্বতে উঠবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","প্রভুর সমস্ত নির্দেশ ও সমস্ত বিধি মোশি লোকদের বলল| তখন সবাই রাজী হল এবং বলল, “আমরা প্রভুর সমস্ত নির্দেশ মেনে চলব|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","তখন মোশি একটি খাতায় প্রভুর সমস্ত নির্দেশ লিখে রাখল| পরদিন সকালে সে জেগে উঠল এবং পর্বতের পাদদেশে একটি বেদী এবং ইস্রায়েলের দ্বাদশ পরিবারগোষ্ঠী অনুসারে বারোটি স্তম্ভ নির্মাণ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","তারপর মোশি ইস্রায়েলের যুবকদের পাঠাল প্রভুর বেদীতে কিছু উৎসর্গের জন্য| এই যুবকরা হোমবলি ও মঙ্গল নৈবেদ্য স্বরূপ প্রভুর কাছে ষাঁড়গুলি উৎসর্গ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","পশু বলির সময় মোশি পাত্রগুলিতে অর্ধেক রক্ত রাখল এবং বাকী রক্ত বেদীর ওপর ঢেলে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","মোশি তখন খাতাটি নিয়ে তাতে লেখা চুক্তিগুলি চেঁচিয়ে পড়তে থাকল| লোকরা তা শুনে বলে উঠল, “আমরা প্রভুর দেওয়া বিধিগুলি শুনেছি এবং আমরা তা মানতে রাজি আছি|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","তখন মোশি লোকদের মাঝে উঠে দাঁড়াল এবং ঐ পাত্রগুলিতে রাখা রক্ত ছিটিয়ে দিল| সে বলল, “দেখ, এই হচ্ছে সেই রক্ত যা তোমাদের সঙ্গে প্রভুর চুক্তির সূচনা করে| চুক্তিটিকে ব্যাখ্যা করার জন্যই ঈশ্বর তোমাদের জন্য বিধি প্রণযন করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","এরপর মোশি, হারোণ, নাদব, অবীহূ এবং ইস্রায়েলের 70 জন প্রবীণ নেতৃবৃন্দ সেই পর্বতে চড়ল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","পর্বতের ওপর তারা ইস্রায়েলের ঈশ্বরকে দেখতে পেল| ঈশ্বর নীল আকাশের মতো স্বচ্ছ নীলকান্ত মণির রাস্তার ওপরে দাঁড়িয়ে ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ইস্রায়েলের প্রবীণদের প্রত্যেকে ঈশ্বরকে দেখতে পেল| কিন্তু ঈশ্বর তাদের ধ্বংস করেন নি| পরিবর্তে তারা সবাই একত্রে ভোজন ও পান করল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","প্রভু মোশিকে বললেন, “পর্বতের ওপর আমার কাছে এসো এবং ওখানে থাকো| আমি লোকদের জন্য আমার শিক্ষামালা ও বিধিগুলি দুটো প্রস্তর ফলকে লিখে রেখেছি| আমি এই প্রস্তর ফলকগুলি তোমাকে দিতে চাই|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","তখন মোশি ও তার পরিচারক যিহোশূয় ঈশ্বরের কাছে যাওয়ার জন্য পর্বতে চড়লো| ");
INSERT INTO ben2006_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","মোশি প্রবীণ নেতৃবৃন্দের উদ্দেশ্যে বলল, “এখানে তোমরা আমাদের দুজনের জন্য অপেক্ষা করো| আমরা তোমাদের কাছে ফিরে আসব| আমি যাবার পর তোমাদের কারো কোন সমস্যা হলে হারোণ ও হূরের কাছে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","মোশি যখন পর্বতে উঠল তখন পর্বত মেঘে আচ্ছন্ন ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","সীনয় পর্বতে প্রভুর মহিমা স্থায়ী হল| ছয় দিন পর্বত মেঘে ঢেকে রইল এবং সপ্তম দিনে ঈশ্বর মেঘের ভেতর থেকে মোশির সঙ্গে কথা বললেন| ");
INSERT INTO ben2006_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","আর তখন ইস্রায়েলের লোকরা প্রভুর মহিমা দেখতে পেল| যেন এক আগুনের গোলা জ্বলছিল পর্বতের চূড়ায়| ");
INSERT INTO ben2006_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","তখন মোশি মেঘের মধ্যে দিয়েই পর্বতের চূড়ায় উঠতে লাগল| মোশি ঐ পর্বতে 40 দিন ও 40 রাত কাটিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ইস্রায়েলের লোকদের বলো আমার জন্য উপহার নিয়ে আসতে| তারা ব্যক্তিগতভাবে নিজেদের মনে মনে ঠিক করে নেবে তারা আমাকে কি দিতে চায়| আমার হয়ে তুমি সেই উপহারগুলি গ্রহণ করো| ");
INSERT INTO ben2006_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","এই হল তার ফর্দ যা যা তুমি তাদের থেকে গ্রহণ করবে: সোনা, রূপো এবং পিতল, ");
INSERT INTO ben2006_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","নীল, বেগুনী এবং লাল সূতো ও মসৃণ শনের কাপড় এবং ছাগলের লোম, ");
INSERT INTO ben2006_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","মেষের লাল রঙের চামড়া, মসৃণ চামড়া, বাবলা কাঠ, ");
INSERT INTO ben2006_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","প্রদীপের তেল, অভিষেকের তেল, সুগন্ধি মশলা, সুগন্ধি ধূপ তৈরির মশলা| ");
INSERT INTO ben2006_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","এগুলি ছাড়াও অলীক মণি এবং অন্যান্য মনিমাণিক্য যেগুলো যাজক দ্বারা পরিহিত এফোদ এবং বক্ষাবরণের ওপর ব্যবহৃত হবে তা গ্রহণ করো|” ");
INSERT INTO ben2006_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ঈশ্বর আরও বললেন, “লোকরা আমার জন্য একটি পবিত্র স্থান তৈরী করবে| তখন আমি তাদের মধ্যে থাকতে পারব| ");
INSERT INTO ben2006_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","আমি তোমাদের পবিত্র তাঁবু এবং তার আসবাবপত্রাদি কেমন দেখতে হওয়া উচিৎ‌ দেখাব| এবং আমি যেমনটি দেখাব ঠিক তেমনি একটি তাঁবু তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“একটি বিশেষ সিন্দুক তৈরী করবে| সিন্দুকটি তোমরা বাবলা কাঠ দিয়ে তৈরী করবে| পবিত্র সিন্দুকটির দৈর্ঘ্য হবে 2.5 হাত, প্রস্থ 1.5 হাত এবং উচ্চতা 1.5 হাত| ");
INSERT INTO ben2006_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","পুরো সিন্দুকটির ভেতরে বাইরে সোনা দিয়ে মুড়ে দেবে| তোমরা অবশ্যই তার চারধারে সোনার ঝালর দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","তোমরা সিন্দুকটিকে বয়ে নেওয়ার জন্য চারটি সোনার আংটা সিন্দুকটির চারদিকে লাগাবে| দুদিকে দুটো করে সোনার কড়া বা আংটা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","এরপর সিন্দুকটিকে বহন করার জন্য দুটো বাবলা কাঠের দণ্ড বানাবে| এই দণ্ডটিও সোনা দিয়ে মোড়া থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","এরপর সিন্দুকটির দু প্রান্তের আংটার মধ্যে দণ্ডগুলি ঢোকাবে এবং সিন্দুকটিকে বয়ে নিয়ে যাওয়ার কাজে ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","এই দণ্ডগুলি অবশ্যই সিন্দুকটির হাতার ভেতরদিকে দৃঢ় হয়ে থাকবে এবং সেগুলো কখনও খুলে নেওয়া হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ঈশ্বর বললেন, “আমি তোমাদের চুক্তিটি দেব| তা ঐ সিন্দুকে রেখে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","আড়াই হাত লম্বা ও দেড় হাত চওড়া একটি সোনার আচ্ছাদন তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","পেটানো সোনা দিয়ে দুইটি করূব দূত বানাও এবং সোনার আচ্ছাদনের দুই প্রান্তে তাদের রাখো| ");
INSERT INTO ben2006_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","আচ্ছাদনের দুই কোণায় তাদের রেখে একই আচ্ছাদনের নীচে ওদের স্থাপন করবে| এরপর দূতদের এবং আচ্ছাদনটিকে একটি অখণ্ড বস্তু করবার জন্য তাদের যুক্ত করো| ");
INSERT INTO ben2006_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","দূতদের ডানা দুটিকে অবশ্যই আকাশের দিকে বিস্তৃত করে দিতে হবে| এবার ডানা সমেত দূতের মূর্তিকে সিন্দুকে এমনভাবে রাখবে যেন দুজনেই মুখোমুখি আচ্ছাদনের দিকে তাকিয়ে থাকে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“আমি তোমাদের চুক্তিটি দেব এবং তোমরা তা সিন্দুকে রাখবে এবং সিন্দুকের ওপর ঐ ঢাকনাটি দিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","আমি যখন তোমাদের সঙ্গে সাক্ষাৎ করব তখন আমি পরস্পর মুখোমুখি ঐ দূতদের মাঝখানে আচ্ছাদনের ওপর থেকে কথা বলব| ইস্রায়েলবাসীকে দেবার জন্য আমি আমার সমস্ত আদেশসমূহ তোমাদের দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“বাবলা কাঠের একটি টেবিল তৈরী করবে| টেবিলটি দৈর্ঘ্যে হবে 2 হাত, প্রস্থে 1 হাত এবং উচ্চতায় 1.5 হাত| ");
INSERT INTO ben2006_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","টেবিলটি খাঁটি সোনা দিয়ে মোড়া থাকবে এবং টেবিলের চারদিকে সোনার নিকেল করা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","তারপর টেবিলের চারিদিকে 1 হাত চওড়া একটি কাঠের কাঠামো তৈরী করবে এবং ঐ কাঠের কাঠামোতে সোনার নিকেল করা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","টেবিলের চার পায়ায় চারটি সোনার কড়া তৈরী করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","পায়ায় সোনার কড়া চারটি টেবিলের ওপর রাখা কাঠামো বরাবর সোজা তুলে আনবে| এবার চারটি কড়ায দণ্ড ঢুকিয়ে টেবিলটিকে বহন করা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","বাবলা কাঠেরই দণ্ড তৈরী করে যেগুলি সোনারপাতে মুড়ে টেবিলটিকে বহন করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","সোনার থালা, চামচ, মগ ও পাত্র তৈরী করবে| মগ ও পাত্র পেয় নৈবেদ্যর জন্য ব্যবহার করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","টেবিলের ওপর আমার জন্য বিশেষ রুটি রাখবে| এবং তা যেন সর্বক্ষণই আমার সামনে রাখা থাকে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“এরপর একটি দীপদান বানাবে| খাঁটি সোনাকে পিটিয়ে একটি সুদৃশ্য দীপদান তৈরী করবে| এই দীপদানের কাণ্ড, শাখা, গোলাধার প্রভৃতি সব অখণ্ড হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“এই দীপদানে অবশ্যই ছয়টি শাখা থাকতে হবে| তিনটি শাখা একদিকে প্রসারিত থাকবে এবং অন্যদিকে থাকবে তিনটি শাখা| ");
INSERT INTO ben2006_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","প্রত্যেক শাখায় তিনটি ফুল থাকবে| ঐ দীপদানের ফুলগুলি বাদাম ফুলের মতো হবে এবং তাতে মুকুলও থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","দীপদানের জন্য আরও চারটে ফুল তৈরী করবে| এই ফুলগুলি হবে বাদাম ফুলের মতো, সঙ্গে মুকুলও থাকবে. ");
INSERT INTO ben2006_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","দীপদানের ছয়টি শাখা থাকবে| হাতলের বা দীপদানের কাণ্ডের দুদিক থেকে যথাক্রমে তিনটি করে শাখা বেরিয়ে আসবে| কাণ্ডের যেখানে শাখাগুলি মিশছে সেখানে ফুল ও মুকুল তৈরী করে লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","পুরো দীপদানটি, এবং শাখা ফুলগুলিও খাঁটি সোনার হওয়া চাই| এবং পুরোটাই একছাঁচে অর্থাৎ‌ অখণ্ড হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","এরপর সাতটি প্রদীপ বানাবে দীপদানে রাখার জন্য| এই প্রদীপগুলিই দীপদানের সামনে আলোকিত করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","প্রদীপের চিমটাটিও সোনার হওয়া চাই| যে থালাটিতে দীপদানটি রাখা হবে সেটিকেও সোনার হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ঐ দীপদান ও দীপদানের আনুষঙ্গিক অংশ তৈরী করতে অবশ্যই 75 পাউণ্ড সোনা ব্যবহার করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","পর্বতের ওপর আমি তোমাদের যা যা দেখিয়েছি তা তৈরী করার সময় সর্বদা সতর্ক থেকো, যেন কোন ভুল না হয়|” ");
INSERT INTO ben2006_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","প্রভু মোশিকে বললেন, “পবিত্র তাঁবুটি তৈরী করবে 10টি পর্দা দিয়ে| পর্দাগুলি তৈরী হবে মসৃণ শনের কাপড়ে এবং নীল, বেগুনী ও লাল সুতোয়| একজন দক্ষ কারিগর পর্দাটি বুনবে এবং তাতে সে করূব দূতের চিত্র সেলাই করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","প্রত্যেকটি পর্দা একই রকম আকৃতির তৈরী করবে| প্রত্যেকটি পর্দা দৈর্ঘ্যে 28 হাত ও প্রস্থে 4 হাত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","এক ভাগ করবার জন্য 5টি পর্দাকে যুক্ত করো| পর্দাগুলি সমান দু ভাগে ভাগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","এক ভাগের শেষ পর্দাটির ধার জুড়ে ফাঁস তৈরী করবার জন্য নীল কাপড় ব্যবহার কর| ");
INSERT INTO ben2006_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","দুই ভাগের শেষ পর্দা দুটিতে 50টি নীল কাপড়ের ঝালর থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","পর্দাগুলিকে একত্রে যুক্ত করবার জন্য 50টি সোনার আংটা তৈরী কর| এটা পবিত্র তাঁবুটিকে একসঙ্গে যুক্ত করবে একটি অখণ্ড তাঁবু করবার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“একটি তাঁবু তৈরী করবার জন্য ছাগলের লোম দিয়ে তৈরী এগারোটি পর্দা ব্যবহার করো| এই তাঁবুটি হবে আগের পবিত্র তাঁবুর আচ্ছাদন| ");
INSERT INTO ben2006_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","এই সমস্ত পর্দাগুলি অবশ্যই একই আকৃতির হবে| প্রত্যেকটি পর্দা হবে 30 হাত লম্বা এবং 4 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","এগারোটি পর্দা দুভাগে ভাগ করে এক ভাগে পাঁচটা ও অন্য ভাগে ছয়টি পর্দা রাখবে| পবিত্র তাঁবুর সামনে ষষ্ঠ পর্দাটি ভাঁজ করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","প্রতিটি ভাগের শেষে পর্দার নীচে 50টি ফাঁস লাগাও| ");
INSERT INTO ben2006_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","এবার পর্দাগুলি একত্র করার জন্য 50টি পিতলের আংটা তৈরী করবে এবং একসঙ্গে সেগুলি টাঙ্গাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","এই তাঁবুর শেষ পর্দাটির অর্ধেক অবশ্যই পবিত্র তাঁবুর পিছন দিকে ঝুলে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","অন্য দিকেও 1 হাত করে পর্দা পবিত্র তাঁবুর ভূমিদেশ থেকে নীচের দিকে ঝুলে থাকবে| এইভাবে পবিত্র তাঁবুকে পরবর্তী তাঁবুটি চারিদিক থেকে আচ্ছাদনের মতো ঘিরে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ভেতরের তাঁবু থেকে বাইরের তাঁবুতে যাওয়ার জন্য দুখানি চামড়ার ছাদ তৈরী করবে| একটি হবে পুং মেষের পাকা চামড়ায তৈরী এবং অন্যটি হবে উৎকৃষ্ট চামড়ার| ");
INSERT INTO ben2006_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“পবিত্র তাঁবুটিকে খাড়া করে রাখার জন্য বাবলা কাঠের একটি কাঠামো তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ঐ কাঠামোটি হবে 10 হাত উঁচু ও 1.5 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","প্রত্যেকটি কাঠামোর নীচে দুটো পায়া থাকবে| পবিত্র তাঁবুর প্রত্যেকটি কাঠামো একই আকারের হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","পবিত্র তাঁবুর দক্ষিণ দিকের জন্য 20টি কাঠামো বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","কাঠামোগুলির নীচে লাগানোর জন্য রূপো দিয়ে 40টি ভূমিমূল তৈরী করবে| প্রত্যেকটি কাঠামোর গোড়ায় দুটি করে রূপোর পায়া বা ভূমিমূল থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","উত্তর দিকের জন্য আরও 20টি কাঠামো তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","একই রকম ভাবে কুড়িটি কাঠামোর দুটি করে পায়ার জন্য আরও 40টি রূপোর পায়া তৈরী করে লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","পবিত্র তাঁবুর পিছন দিক অর্থাৎ‌ পশ্চিম দিকের জন্য আরও ছয়খানি কাঠামো বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","পবিত্র তাঁবুর পিছন দিকে দুই কোণের জন্য দুখানি কাঠামো বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","দুই কোণার কাঠামো দুখানি পরস্পরের সঙ্গে নীচের দিকে যুক্ত থাকবে| ওপরে একটি কড়া এই দুখানি কাঠামোকে একত্রে ধরে রাখবে| দু দিকের কোণাতেই একই রকম হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","এই রকম মোট আটটি কাঠামো থাকবে এবং 16টি রূপোর পায়া থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“পবিত্র তাঁবুর কাঠামোগুলি জোড়া লাগানোর জন্য বাবলা কাঠ ব্যবহার করবে| পবিত্র তাঁবুর প্রথম দিকে পাঁচটি জোড়া তক্তা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","অন্যদিকেও পাঁচটি তক্তা জোড়া দেওয়া থাকবে| এবং পিছনদিকেও পাঁচটি জোড়া তক্তা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","তক্তাগুলির মাঝখানে একটি কেন্দ্রস্থিত হুড়কো লাগাতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“কাঠামোগুলি তারপর সোনা দিয়ে মুড়ে দেবে| তক্তাগুলি আটকানোর জন্য আংটা ব্যবহার করবে| আংটাগুলিও অবশ্যই সোনার হবে| কীলকগুলিকে সোনা দিয়ে ঢেকে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","এইভাবে পর্বতের ওপর দেখানো পরিকল্পনা অনুযায়ী অবশ্যই তোমাদের পবিত্র তাঁবুটি তৈরী করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“পবিত্র তাঁবুর ভেতর বিভাজনের জন্য মসৃণ শনের কাপড়ের পর্দা বানাবে| ঐ পর্দার ওপর অবশ্যই করূব দূতের চেহারা থাকতে হবে| লাল, নীল, বেগুনী সূতোর কারুকার্য্যে তা ফুটে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","বাবলা কাঠের চারটি খুঁটি তৈরী করে সোনা দিয়ে তাও মুড়ে দেবে| চারটে খুঁটিতে সোনার আংটা লাগাবে| খুঁটিরে নীচে রূপোর পায়া লাগাবে| এবার পর্দাটি সোনার আংটায় লাগিয়ে টাঙ্গিয়ে দেবে খুঁটির সঙ্গে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","পর্দাটি সোনার আংটাগুলির নীচে টাঙিযে দাও| তারপর ঠিক পর্দার পিছনে সাক্ষ্যসিন্দুক রাখবে| টাঙানো পর্দা দিয়ে পবিত্র স্থান এবং অতি পবিত্র স্থানের মধ্যে বিভাজন করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","অতি পবিত্র স্থান হিসাবে সাক্ষ্যসিন্দুকের ওপর একটি আবরণ রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“পবিত্র স্থানে পর্দার উল্টো দিকে নির্মিত বিশেষ টেবিলটি রাখবে| টেবিলটি বসানো হবে পবিত্র তাঁবুর উত্তর দিকে| এবার দীপদানটিকে বসাবে দক্ষিণ দিকে টেবিলের থেকে খানিকটা দূরে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“এবারে একটি পর্দা দিয়ে পবিত্র তাঁবুর প্রবেশ পথ ঢেকে দেবে| পর্দাটি বানাবে লাল, নীল, বেগুনী সুতো ও মসৃণ শনের কাপড় দিয়ে| এবং তাতে চিত্র ফুটিয়ে তুলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","এই পর্দা টাঙানোর জন্য সোনার আংটা বানাবে| এবং বাবলা কাঠের পাঁচটি খুঁটি বানাবে| সেগুলিও সোনার পাতে মোড়া থাকবে| পাঁচটি খুঁটির পায়া পিতল দিয়ে বানাবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","প্রভু মোশিকে বললেন, “বাবলা কাঠের একটি বেদী বানাবে| বেদীখানা হবে চৌকো আকারের| বেদীটি উচ্চতায় হবে 3 হাত, লম্বায় হবে 5 হাত এবং চওড়ায় হবে 3 হাত| ");
INSERT INTO ben2006_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","বেদীর চার কোণার প্রত্যেকটির জন্য একটি করে শিখর বানাও এবং প্রত্যেকটি শিখর বেদীর কোনায় যুক্ত কর যাতে তারা অখণ্ড হয়| তারপর ওটিকে পিতলের পাত দিয়ে মুড়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“বেদীর সমস্ত যন্ত্রপাতি এবং বাসন-কোসন পিতল দিয়ে তৈরী কর| বেদী থেকে ছাই তুলে নেওয়ার জন্য পাত্র, তার বেলচাসমূহ, সিঞ্চনকারী পাত্রসমূহ, আঁকশি এবং উনুন তৈরী কর| ব্যবহারের পর বেদীর হোমবলির ছাই দিয়ে এগুলো পরিষ্কার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","বেদীর জন্য ছাকনীর আকারের একটি ঝাঁঝরি রাখবে| ঝাঁঝরির চারকোণার জন্য পিতলের আংটা বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","বেদীর নীচে এই ঝাঁঝরি রাখবে| কিন্তু এর উচ্চতা হবে বেদীর মধ্যভাগ পর্যন্ত| ");
INSERT INTO ben2006_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“বেদীর জন্য পিতলে মোড়া বাবলা কাঠের খুঁটি ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","বেদীর দুপাশে লাগানো আংটার মধ্যে খুঁটি ঢুকিয়ে বেদীকে যেখানে ইচ্ছে বয়ে নিয়ে বেড়াও| ");
INSERT INTO ben2006_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","খালি ধারগুলিতে কাঠের তক্তা ব্যবহার করে বেদীটি একটি শূন্য সিন্দুকের আকারে বানাও| এবং পর্বতে আমি যেভাবে দেখালাম ঠিক সেইভাবেই বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“পবিত্র তাঁবুর জন্য একটি আদালত চত্বর বানাবে| দক্ষিণ দিকে 100 হাত লম্বা পর্দা দেওয়া দেওয়াল থাকবে| এই পর্দা মসৃণ শনের কাপড়ের তৈরী হওয়া চাই| ");
INSERT INTO ben2006_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","কুড়িটি খুঁটি এবং খুঁটিগুলোর নীচে 20টি পিতলের ভিত্তি তৈরী কর| আংটা এবং পর্দার দণ্ডগুলি রূপো দিয়ে তৈরী কর| ");
INSERT INTO ben2006_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","উত্তরদিকেও একইভাবে 100 হাত লম্বা একটি পর্দার দেওয়াল থাকবে| এর জন্য অবশ্যই 20টি খুঁটি ও 20টি পিতলের ভিত্তি থাকবে| এই খুঁটিগুলির জন্য আংটাসমূহ ও পর্দার দণ্ডগুলি হবে রূপোর তৈরী| ");
INSERT INTO ben2006_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“আদালত চত্বরের পশ্চিম দিকে 50 হাত লম্বা পর্দা থাকবে| আর এর জন্য চাই দশটি খুঁটি ও পায়া| ");
INSERT INTO ben2006_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","পূর্ব দিকেও 50 হাত লম্বা পর্দা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","এই পূর্ব দিকটিই হবে প্রবেশ পথ| প্রবেশ পথের একদিকে থাকবে 15 হাত লম্বা পর্দা| তার জন্যও চাই তিনটি খুঁটি ও পায়া| ");
INSERT INTO ben2006_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","অন্যদিকেও করতে হবে একই ব্যাপার সেই 15 হাত লম্বা পর্দা ও তার জন্য চাই 3টি খুঁটি ও 3টি পায়া| ");
INSERT INTO ben2006_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“আদালত চত্বরের পথটি ঢাকতে বানাবে 20 হাত লম্বা পর্দা| পর্দা তৈরী হবে মিহি মসীনাবস্ত্রের এবং লাল, নীল, বেগুনী ও লাল সুতোর এবং তাতে সুন্দর চিত্র ফুটিয়ে তুলবে| পর্দাটি টাঙ্গানোর জন্য চারটি খুঁটি ও চারটি পায়া থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","উঠোনের চারিদিকের সমস্ত খুঁটি পর্দার রূপোর দণ্ড দিয়ে যুক্ত হবে| খুঁটির ওপর পর্দা টাঙ্গানোর আংটাগুলি হবে রূপোর এবং খুঁটির নীচে পায়াগুলি হবে পিতলের| ");
INSERT INTO ben2006_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","আদালত চত্বরটি হবে 100 হাত লম্বা ও 50 হাত চওড়া| আদালত চত্বরের চারিদিকে 5 হাত উচ্চতার টানা পর্দার দেওয়াল থাকবে| পর্দাটি হবে মিহি মসীনা কাপড়ের| খুঁটির নীচের পায়াগুলি হবে পিতলের| ");
INSERT INTO ben2006_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","পবিত্র তাঁবু তৈরীর যাবতীয় জিনিসপত্র হবে পিতলের| উঠোনের চারিদিকের, পর্দায় ব্যবহারের জন্য কীলকগুলি পিতলের তৈরী হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ইস্রায়েলের লোকদের আদেশ করো, তারা যেন প্রত্যেক সন্ধ্যায় যে প্রদীপ জ্বালানো হবে তার জন্য সব থেকে ভাল জলপাইয়ের তেল নিয়ে আসে| ");
INSERT INTO ben2006_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","হারোণ ও তার পুত্রদের কাজ হল প্রতি সন্ধ্যায় প্রভুর সামনে প্রদীপ জ্বালানোর জন্য প্রদীপ তৈরী করে রাখা| আর সাক্ষ্য সিন্দুকের ঘরের বাইরে পর্দা দিয়ে বিভাজন করা অন্য একটি ঘরে বা সমাগম তাঁবুর ঘরে তারা সন্ধ্যা থেকে সকাল পর্যন্ত সর্বদা প্রভুর সামনে প্রদীপ জ্বালিয়ে রাখবে| ইস্রায়েলের লোকরা এবং তাদের পরবর্তী উত্তরপুরুষরা এই চিরস্থায়ী বিধি মেনে চলবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","প্রভু মোশিকে বললেন, “তোমার ভাই হারোণ ও তার পুত্রগণ নাদব, অবীহূ, ইলীয়াসর এবং ঈথামরকে তোমার কাছে আসতে বলো| তারাই যাজকরূপে ইস্রায়েলের লোকদের হয়ে আমাকে সেবা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“তোমার ভাই হারোণের জন্য একটি বিশেষ ধরণের পোশাক বানাবে| ঐ পোশাক হারোণকে বিশেষ সম্মান ও গৌরব প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","কয়েকজন দক্ষ দর্জি সেই পোশাক তৈরী করবে| আমি সেই দর্জিদের বিশেষ জ্ঞান ও দক্ষতা প্রদান করেছি| সেই দর্জিদের বলো হারোণের জন্য বিশেষ পোশাক তৈরী করতে| এই পোশাকই প্রমাণ করবে সেই যাজক আমাকে বিশেষ ভাবে সেবা করছে| তখন সে আমাকে যাজকের মতোই সেবা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","তাদের যে পোশাকগুলি বানাতে হবে তা হল এই: একটি বক্ষাবরণ, একটি এফোদ, একটি নীল রঙের পরিচ্ছদ এবং একটি সাদা বোনা বস্ত্র, একটি পাগড়ি এবং একটি কোমর বন্ধনী| এই বিশেষ পোশাক পরিচ্ছদগুলি বানানো হবে হারোণ ও তার পুত্রদের জন্য| এই পোশাক পরার পরেই ওরা আমায় যাজক হিসেবে সেবা করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","পোশাকগুলিতে ব্যবহার হবে সোনার জরি, মসৃণ মসীনা এবং লাল, নীল, বেগুনী সুতো| ");
INSERT INTO ben2006_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“এফোদ বানাতে সোনার জরি, মসৃণ শনের কাপড় ও লাল, নীল, বেগুনী সুতো ব্যবহার করবে| দক্ষতার সঙ্গে অতি যত্নে তা তৈরী করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","এফোদের প্রতিটি কাঁধে একটি করে কাঁধ পট্টি থাকবে| এফোদের দুই কোণার সঙ্গে কাঁধ পট্টি সংযুক্ত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“এফোদের জন্য কোমর বন্ধনী তৈরীর সময় দর্জীদের সতর্ক থাকতে হবে| এফোদের মতো কোমর বন্ধনীতেও সোনার জরি, মসৃণ শণের কাপড় ও লাল, নীল, বেগুনী সুতো ব্যবহার করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“দুটো গোমেদমনি নাও এবং তার ওপর ইস্রায়েলের পুত্রদের নাম খোদাই কর| ");
INSERT INTO ben2006_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ছয় জনের নাম এক মণিতে ও অন্য ছয় জনের নাম অপর মণিতে খোদাই করবে| নাম খোদাই করার সময় বয়স অনুযায়ীবড় থেকে ছোট এইভাবে পর পর সাজাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","শীলমোহরের মতো নামগুলো খোদাই করে সোনা দিয়ে বাঁধিযে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","এবারে ঐ দুটি মণি এফোদের দুই কাঁধে লাগাবে| হারোণ যখন প্রভুর সামনে দাঁড়াবে তখন সে ইস্রায়েলের পুত্রদের নামের স্মারক হিসেবে ঐ বিশেষ আচ্ছাদনটি পরবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","এফোদের দুই কাঁধে যাতে খোদাই করা মণি দুটি সঠিকভাবে আটকে থাকে তার জন্য খাঁটি সোনা ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","খাঁটি সোনার দুটি শিকল তৈরী কর, প্রত্যেকটি দড়ির মত পাকানো এবং তাদের ঐ মণি দুটির সঙ্গে আটকে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“মহাযাজকের জন্য বক্ষাবরণ তৈরী করবে| দক্ষ দর্জিরা এফোদের মতোই যত্ন করে বক্ষাবরণ তৈরী করবে| বক্ষাবরণ তৈরী হবে সোনার জরি, মসৃণ মসীনা কাপড় ও লাল, নীল, বেগুনী সুতো দিয়ে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","বক্ষাবরণটিকে চারকোণা করবার জন্য অবশ্যই দুবার ভাঁজ করতে হবে| এর দৈর্ঘ্য হবে 1 বিঘত্‌ ও প্রস্থ হবে 1 বিঘত্‌| ");
INSERT INTO ben2006_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","বক্ষাবরণে চার সারিতে মণিমানিক্য বসাও| প্রথম সারিতে থাকবে চূনী, পীতমণি ও মরকত| ");
INSERT INTO ben2006_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দ্বিতীয় সারিতে থাকবে পদ্মরাগ, নীলকান্ত ও পান্না| ");
INSERT INTO ben2006_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তৃতীয় সারিতে থাকবে পোখরাজ, য়িস্ম ও কটাহেলা| ");
INSERT INTO ben2006_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","চতুর্থ সারিতে থাকবে বৈদুর্য্য, গোমেদ ও সূর্য্যকান্ত মণি| এই মণিগুলি নিজের নিজের সারিতে সোনায় আঁটা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","বারোটি মণির ওপর ইস্রায়েলের সন্তানদের নাম আলাদা আলাদা করে খোদাই থাকবে| সীলমোহরের মতো ঐ মণিগুলিতে বারোজনের নাম খোদাই করা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“বক্ষাবরণের ওপরের অংশটির জন্য খাঁটি সোনা দিয়ে প্রত্যেকটিকে দড়ির মত পাকিযে শেকল তৈরী কর| ");
INSERT INTO ben2006_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","দুটো সোনার আংটা লাগানো থাকবে বক্ষাবরণের দুই কোণে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","দুটো সোনার চেন বক্ষাবরণের দুপাশের আংটায় লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","পাকানো শেকল দুটির অন্য প্রান্ত এফোদের কাঁধের পট্টিগুলোর সঙ্গে অবশ্যই সামনে দিয়ে জোড়া থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","আরও দুটো সোনার আংটা বানিয়ে বক্ষাবরণের অন্য দুই প্রান্তে লাগাবে| এফোদের পরে বক্ষাবরণের ভিতর ভাগে এই আংটা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","আরও দুটো সোনার আংটা এফোদের সামনের দিকে কাঁধের পট্টির নীচে লাগাবে| এফোদের কোমর বন্ধনীর ওপরে এই আংটা স্থাপন করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","বক্ষাবরণ থেকে এফোদ যাতে খসে পড়ে না যায় তার জন্য বক্ষাবরণের আংটার সঙ্গে এফোদের আংটা নীল রঙের ফিতে দিয়ে বেঁধে নেবে| এইভাবে বক্ষাবরণ কোমর বন্ধনীর কাছাকাছি থেকে এফোদকেও ধরে রাখতে সক্ষম হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“হারোণ পবিত্র স্থানে প্রবেশ করলে তাকে বক্ষাবরণ পরতেই হবে| এইভাবে যখন সে প্রভুর সামনে দাঁড়াবে তখন সে তার বক্ষের ওপর স্মারক হিসেবে ইস্রায়েলের বারোজন সন্তানের নাম পরে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","আর সেই বক্ষাবরণের অভ্যন্তরে উরীম ও তূম্মীম রাখবে| প্রভুর সামনে গেলে সর্বদা সেগুলি হারোণের হৃদয়ের ওপর থাকবে| এইভাবে হারোণ প্রভুর সামনে ইস্রায়েলের সন্তানদের বিচার প্রতিনিযত নিজের হৃদয়ের ওপর বয়ে নিয়ে বেড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“এফোদের জন্য একটি সম্পূর্ণরূপে নীল রঙের আলখাল্লা তৈরী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","আলখাল্লার মাঝখান দিয়ে মাথা ঢোকানোর জন্য একটি ছিদ্র করবে এবং এই ছিদ্রটির চারধার জুড়ে একটি বোনা কাপড়ের টুকরো সেলাই করে দাও যাতে এটি ছিঁড়ে না যায়| এই কাপড় ছিদ্রটির চারদিকে গলাবন্ধনীর কাজ করবে, ফলে তা ছিঁড়ে যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","লাল, নীল, বেগুনী সুতো দিয়ে ডালিমের মতো সুতোর গোলা তৈরী কর এবং আলখাল্লার নীচে ঝুলিয়ে দেবে আর সুতোর বলের মাঝখানে সোনার ছোট ছোট ঘন্টা লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","পুরো আলখাল্লার নীচের চারিদিকে এই রকম একটা করে সুতোর গোলা ও একটা করে সোনার ঘন্টা লাগানো হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","যাজকরূপে প্রভুকে সেবা করার সময় হারোণ এই আলখাল্লাটি পরবে| প্রভুর সামনে দাঁড়ানোর জন্য হারোণ পবিত্র স্থানের দিকে এগোলে ঐ ঘন্টাগুলি বাজবে এবং পবিত্র স্থান ছেড়ে বাইরে আসবার সময়ও ঘন্টাগুলি বাজবে| এইভাবে হারোণ কখনও মারা যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“নির্মল সোনার ফলক বানিয়ে তাতে শীলমোহরের মতো জনগণের উদ্দেশ্যে খোদাই করবে এই কথাগুলি: এটি প্রভুর কাছে উৎসর্গীকৃত| ");
INSERT INTO ben2006_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","সোনার ফলকটিকে নীল ফিতেতে আবদ্ধ করবে| পাগড়ির ওপর চারিদিকে নীল ফিতে বাঁধা থাকবে| পাগড়ির সামনের দিকে থাকবে সোনার ফলকটি| ");
INSERT INTO ben2006_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","হারোণ পাগড়ি সমেত ঐ সোনার ফলকটি মাথায় পরবে| আর তা সবসময় হারোণের মাথায় থাকবে| তার ফলে ইস্রায়েলের লোকরা প্রভুকে যে সমস্ত উপঢৌকন দেবে হারোণ তা দোষ মুক্ত করে সব কিছু পবিত্র করে তুলবে যাতে সেই সমস্ত উপঢৌকন প্রভু গ্রহণ করতে পারেন| ");
INSERT INTO ben2006_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“মসৃণ সাদা মসীনা সুতো দিয়ে আরও একটা আলখাল্লা বুনবে| পাগড়িও বানাবে মসৃণ মসীনা কাপড়ের| চিহ্নিত কোমর বন্ধনী বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","হারোণের পুত্রদের জন্যও গায়ের পোশাক, কোমর বন্ধনী ও পাগড়ি বানাবে| এই পোশাকই তাদের গৌরবান্বিত ও সম্মানিত করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","এই পোশাকগুলি তোমার ভাই হারোণ ও তার পুত্রদের পরাবে| যাজক হিসেবে অভিষেকের জন্য তাদের গায়ে বিশেষ সুগন্ধি তেল ছেটাবে| এইভাবে তারা পবিত্র হবে এবং প্রভুর সেবা করার যোগ্য যাজক হয়ে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“যাজকদের নগ্নতা ঢাকার জন্য শরীরের ভেতরের পোশাক মসৃণ মসীনা কাপড়ে তৈরী হবে| এই ভেতরের পোশাক তাদের জঙঘা থেকে কোমর পর্যন্ত ঢেকে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","সমাগম তাঁবুতে প্রবেশের সময় হারোণ ও তার পুত্রদের অবশ্যই এই পোশাকগুলি পরাতে হবে| পবিত্র স্থানে প্রভুর সেবার উদ্দেশ্যে বেদীর কাছে আসতে হলে তাদের এই পোশাক পরতে হবে| তারা যদি এই পোশাক না পরে তাহলে তাদের মরতে হবে কারণ তারা অপরাধী| এই পোশাক পরার বিধি হারোণ ও তার পরবর্তী বংশধরদের চিরস্থায়ীভাবে মেনে চলতেই হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","প্রভু মোশিকে বললেন, “এখন আমি তোমাকে বলব আমার সেবায় বিশেষ যাজক হিসেবে নিয়োগ করার জন্য হারোণ ও তার পুত্রদের কি কি করতে হবে| একটি নির্দোষ ছোট বলদ ও দুটি মেষশাবক জোগাড় করে আনো| ");
INSERT INTO ben2006_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","তারপর উৎকৃষ্ট মানের গমের আটা থেকে খামিরবিহীন রুটি তৈরী করো এবং একই আটা বা ময়দা দিয়ে জলপাইয়ের তেল মিশিয়ে পিঠে তৈরী করবে| তেলে ভাজা সরুচাকলী পিঠেও বানাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","এই রুটি ও পিঠেগুলি ঝুড়িতে ভরবে| এবার এই ঝুড়িটি এবং ষাঁড় ও মেষ দুটি সমাগম তাঁবুতে নিয়ে এসো| ");
INSERT INTO ben2006_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“এরপর হারোণ ও তার পুত্রদের সমাগম তাঁবুর দরজায় নিয়ে আসবে| পরিষ্কার জলে তাদের স্নান করাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","বিশেষভাবে বানানো পোশাকটি হারোণকে পরাবে| তাকে বোনা সাদা পোশাকটি এবং নীল বস্ত্র সমেত এফোদ পরাবে| এফোদের সঙ্গে যুক্ত করবে বক্ষাবরণ| এরপর সুদৃশ্য কোমরবন্ধনী লাগিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","তার মাথায় পাগড়ি পরাও এবং পাগড়িটি ঘিরে বিশেষ পবিত্র মুকুটটি পরাও| ");
INSERT INTO ben2006_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","এবার অভিষেকের তেল হারোণের মাথায় ছিটিয়ে দেবে| এইভাবে হারোণ যাজকরূপে অভিষিক্ত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“এরপর হারোণের পুত্রদের ঐ স্থানে নিয়ে এসে সাদা আলখাল্লা পরাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","তাদের কোমরে বাঁধবে কোমরবন্ধনী| তাদের মাথায় পরাবে শিরোভূষণ| এইভাবে তারা যাজক হিসাবে চিহ্নিত হবে| চিরস্থায়ী অধিকার বিধি অনুযায়ী তারা যাজক পদে উত্তীর্ণ হবে| এইভাবে তুমি হারোণ ও তার পুত্রদের যাজক হিসাবে অভিষিক্ত করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“এবার সেই বলদকে সমাগম তাঁবুর সামনে আনো| হারোণ ও তার পুত্ররা সেই বলদের ওপর তাদের হাত রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","সমাগম তাঁবুর প্রবেশপথে ঐ বলদটিকে প্রভুর উপস্থিতিতে বলি দাও| প্রভু তা দেখবেন| ");
INSERT INTO ben2006_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","সেই বলদ বলির কিছু পরিমাণ রক্ত নাও এবং তোমার আঙ্গুল দিয়ে বেদীর শৃঙ্গগুলির ওপরে ঐ রক্তের প্রলেপ লাগিয়ে দাও| বাকি রক্ত বেদীর নীচে ছড়িয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","এবার বলি দেওয়া সেই বলদের শরীরের সমস্ত চর্বি, যকৃৎ এবং চর্বি এবং দুটো মুত্রগ্রন্থী ও তার চারপাশের চর্বি জড়ো করে বেদীর ওপর জ্বালাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","এবার ঐ বলদের মাংস, চামড়া এবং গোবর তাঁবুর বাইরে নিয়ে যাও এবং তা আগুনে পুড়িয়ে দাও| এই পদ্ধতিতে যাজকদের পাপমোচনের হোমবলি হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“এবার হারোণ ও তার পুত্রদের বলো একটি মেষের ওপর হাত রাখতে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ঐ মেষটিকে কেটে ফেল| তার এবং বলির রক্ত সংগ্রহ কর এবং ঐ রক্ত বেদীর চারপাশে লাগিয়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","এরপর মেষটিকে খণ্ড খণ্ড করে কাটো| মেষের অভ্যন্তর ভাগ এবং পা-গুলি ধোও| এই অংশগুলি অন্যান্য অংশের সঙ্গে এবং মাথার সঙ্গে রাখো| ");
INSERT INTO ben2006_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","এবার সেগুলি বেদীতে এনে পুড়িয়ে দেবে| বেদীতে পোড়ালে তা হবে হোমবলি| প্রভুর উদ্দেশ্যে আগুনের উপহার| প্রভু এর গন্ধে খুশী হবেন| ");
INSERT INTO ben2006_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“এবার অন্য একটি মেষ নিয়ে এসো এবং হারোণ ও তার পুত্রদের বলো মাথায় হাত রাখতে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ছাগলটিকে বলি দাও ও তার একটু রক্ত নাও এবং সেটি হারোণ ও তার পুত্রদের ডান কানের লতিতে লাগিয়ে দাও| একটু রক্ত লাগাও ডান হাতের বুড়ো আঙুলে এবং কিছু রক্ত লাগাবে ডান পায়ের বুড়ো আঙুলে| এরপর বাকী রক্ত বেদীর চারদিকে ঢেলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","এবার বেদী থেকে একটু রক্ত তুলে নাও এবং একটি বিশেষ অভিষেকের তেলের সঙ্গে মিশিয়ে হারোণ ও তার পুত্রদের ওপর ও তাদের পোশাকের ওপর ছিটিয়ে দেবে| এতে বোঝা যাবে যে হারোণ ও তার পুত্রদের পোশাকগুলি প্রভুর কাছে উৎসর্গীকৃত| ");
INSERT INTO ben2006_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“এরপর সেই মেষের চর্বি ছাড়িয়ে নেবে| (এটা সেই ছাগল বা মেষ যেটা হারোণের মহাযাজকরূপে অভিষেকের সময় ব্যবহৃত হয়েছে|) বলি দেওয়া ছাগলের লেজের এবং শরীরের ভেতরের চর্বি ছাড়িয়ে নেবে| যকৃত্‌ ও মুত্রগ্রন্থীর ওপরের চর্বি এবং ডান পায়ের চর্বিও সংগ্রহ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","এবার প্রভুর সামনে রাখার জন্য খামিরবিহীন রুটি এবং তেলে ভাজা পিঠে ভর্ত্তি ঝুড়িটিকে আনবে| ঝুড়ি থেকে একটি রুটি, একটি তেলেভাজা পিঠে ও একটি ছোট সরুচাকলী পিঠে তুলে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","এই জিনিসগুলি হারোণ ও তার পুত্রদের দেবে এবং ওদের বলবে এইগুলি হাতে নিতে এবং প্রভুর সামনে সেগুলি দোলাতে| এটা হবে দোলনীয় নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","এবার এই জিনিসগুলি তাদের কাছ থেকে নিয়ে নাও এবং তাদের বেদীর ওপর রাখো এবং এইগুলি মেষের সঙ্গে পুড়িয়ে দাও| এটি একটি হোমবলি| এর গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“এরপর বলি দেওয়া মেষটির বক্ষ কেটে নেবে| (হারোণের মহাযাজকের পদে অভিষেক উৎসবে এই মেষটিকে ব্যবহার করা হয়েছিল|) মেষটির বক্ষ প্রভুর সামনে দোলনীয় নৈবেদ্যর মত দোলাও এবং তারপরে রেখে দাও| এটি তোমার খাবার জন্য থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","হারোণের মহাযাজকরূপে অভিষেকের শিষ্টাচারে ব্যবহৃত ছাগলের পা ও স্তন এই বিশেষ অঙ্গ দুটি পবিত্র হল| এবার ঐ দুটি অঙ্গ হারোণ ও তার পুত্রদের দিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","এরপর থেকে সর্বদা ইস্রায়েলের জনগণ প্রভুকে যাজকের মাধ্যমে ঐ বিশেষ অঙ্গ দুটি উৎসর্গ করবে| তারা যখন যাজককে ঐ অঙ্গ দুটি দেবে তা হবে প্রভুকে দেওয়ারই সমান| ");
INSERT INTO ben2006_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“বিশেষভাবে তৈরী করা বিশেষ পোশাকগুলো হারোণের জন্য তৈরী করা হলেও সেগুলো যত্ন করে রেখে দেবে| কারণ হারোণের পর যে মহাযাজক হবে সে ঐ পোশাকগুলো পরেই প্রভুর সেবা করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","হারোণের পর তার ছেলেদের মধ্যে থেকেই একজন মহাযাজকের দায়়ভার সামলাবে| সে যখন সমাগম তাঁবুতে পবিত্র স্থানের সেবায় নিযোজিত হবে তখন সে সাতদিন ঐ পোশাকগুলোই পরবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“হারোণের মহাযাজকরূপে অভিষেক উৎসবে ব্যবহৃত মেষের মাংস সেদ্ধ কর| পবিত্রস্থানেই ঐ মাংস রান্না হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","সমাগম তাঁবুর সামনের দরজায় বসে হারোণ ও তার পুত্ররা ঐ রান্না করা মাংস খাবে| ঝুড়ির রুটি দিয়ে তারা মাংস খাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","এই পদ্ধতিতে তাদের পাপমোচন হবে এবং তারা প্রায়শ্চিত্তের মাধ্যমে যাজক হিসেবে আত্মপ্রকাশ করবে| আর কাউকে ওগুলো খেতে দেওয়া হবে না, কারণ সেগুলি পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","যদি কোন খাবার রুটি বা মাংস অবশিষ্ট থাকে তাহলে পরদিন সকালে সেগুলো পুড়িয়ে ফেলতে হবে| কেউ এ খাবার খাবে না কারণ এই খাবার বিশেষ উপায়ে বিশেষ সময়ে খেতে হয়| ");
INSERT INTO ben2006_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“আমার আদেশ মতো তুমি হারোণ ও তার পুত্রদের এগুলি করাবে| আমি যা যা বলেছি তুমি তাদের জন্য ঠিক তাই করবে| তাদের যাজক পদে অভিষেকের শিষ্টাচার সাত দিন ধরে চলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","সাতদিন ধরে তুমি প্রত্যেকদিনে একটি করে বলদ বলি দেবে| হারোণ ও তার পুত্রদের পাপমোচনের জন্য এই উপায় অবলম্বন করতে হবে| এই প্রায়শ্চিত্ত বেদীকে পূণ্য করার জন্য করতে হবে| এবং বেদীকে পবিত্র করার জন্য জলপাইয়ের তেল ঢালবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","তুমি সাত দিন ধরে প্রায়শ্চিত্ত করে সাতদিন ধরে বেদীকে পূণ্য ও পবিত্র করে তুলবে| সে সময় বেদীটি অতি পবিত্র স্থান হয়ে উঠবে| বেদীর সংস্পর্শে যা আসবে তাই-ই পবিত্র হয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“প্রত্যেকদিন তুমি বেদীতে কিছু না কিছু নৈবেদ্য দেবে| তোমাকে এক বছর বয়সের দুটো মেষ বলি দিতেই হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","একটা মেষকে সকালে ও অন্যটিকে সন্ধ্যায় বলি দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","যখন তুমি প্রথম মেষটিকে বলি দেবে তখন তার সঙ্গে এক পোয়া খাঁটি জলপাই তেল আর তিন পোয়া দ্রাক্ষারসের সঙ্গে আট বাটি ভাল গমের আটাও উৎসর্গ করো| ");
INSERT INTO ben2006_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","এবার দ্বিতীয় মেষটি গোধূলি বেলায় বলি দেবে| এটির শস্য নৈবেদ্য এবং এটির পেয় নৈবেদ্য হবে সকালের নৈবেদ্যর মতোই| এটা হবে একটি সুগন্ধ সৌরভ, প্রভুকে নিবেদিত একটি হোমবলি| এবং প্রভু তা নিঃশ্বাসে গ্রহণ করবেন এবং তার গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“প্রভুর প্রতিদিনের নৈবেদ্যগুলোকেই পুড়িয়ে ফেলতে হবে| সমাগম তাঁবুর দরজাতেই এটা করবে| প্রভুকে নৈবেদ্য দেবার সময় সর্বদা এটাই করবে| আমি, প্রভু তোমাদের সঙ্গে কথা বলার জন্য ওখানেই দর্শন দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ইস্রায়েলের লোকদের সঙ্গে সাক্ষাৎ করব ঐ স্থানেই এবং আমার মহিমা ঐ স্থানকে পবিত্র করে তুলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“তাই সমাগম তাঁবুকে আমি পবিত্র করে তুলব এবং বেদীকেও পবিত্র করে তুলব| হারোণ ও তার পুত্ররা যাতে আমাকে যাজক হয়ে সেবা করতে পারে তার জন্য আমি ওদেরও পবিত্র করে তুলব| ");
INSERT INTO ben2006_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ইস্রায়েলের লোকদের সঙ্গেই আমি থাকব| আমিই হব তাদের ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","লোকরা জানবে আমিই তাদের প্রভু এবং ঈশ্বর| তারা জানতে পারবে যে আমিই ‘সেই জন’ যে তাদের নেতৃত্ব দিয়ে মিশর থেকে বাইরে এনেছে তাই আমি তাদের মাঝেই বাস করব| আমিই তাদের প্রভু, আমিই তাদের ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","প্রভু মোশিকে বললেন, “বাবলা কাঠের একটা বেদী তৈরী করবে| ধূপদান হিসাবে এই বেদী ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","বেদীটি হবে চারকোণা| বেদীর দৈর্ঘ্য ও প্রস্থ হবে 1 হাত করে এবং উচ্চতা হবে 2 হাত| বেদীর এই শৃঙ্গগুলি বেদীর সঙ্গে একটি অখণ্ড টুকরো হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ওটিকে খাঁটি সোনা দিয়ে মুড়ে দাও–এর উপরিভাগে, বেদীকে ঘিরে তার চার ধারে এবং বেদীর চারধারে তার শৃঙ্গগুলি সোনার নিকেল দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","সোনার নিকেলের নীচে বেদীর বিপরীত দুদিকে দুটো সোনার আংটা লাগাবে| এই আংটায় দণ্ড ঢুকিয়ে বেদীকে বয়ে নিয়ে যাওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","দণ্ডও বাবলা কাঠের হবে এবং দণ্ডকে সোনা দিয়ে মুড়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ধূপবেদীটি বিশেষ পর্দার সামনে বসাও| ঐ পর্দাটি সাক্ষ্যসিন্দুকের ওপর যে আচ্ছাদন আছে তার সামনে থাকবে| এটা সেই স্থান সেখানে আমি তোমাদের সঙ্গে সাক্ষাৎ করব| ");
INSERT INTO ben2006_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“প্রতি সকালে হারোণ যখন বাতিগুলো ঠিক করতে আসবে তখন সে বেদীতে সুগন্ধি ধূপ জ্বালাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","সন্ধ্যায় যখন সে প্রদীপ জ্বালাতে আসবে তখনও তাকে বেদীতে ধূপ জ্বালাতে হবে| এখন থেকে, এই ধূপ নিয়মিতভাবে প্রভুর সামনে অর্পণ করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","এই বেদীর ওপর অন্য কোন ধূপ অথবা হোমবলি উৎসর্গ করবে না| কোন রকম শস্য নৈবেদ্য ও পেয় নৈবেদ্যর জন্য এই বেদী ব্যবহার করা হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“বছরে একবার হারোণ প্রভুর প্রতি একটি বিশেষ পশু উৎসর্গ করবে| মানুষের পাপমোচনের উদ্দেশ্যে সে পাপ বলির রক্ত দিয়ে প্রায়শ্চিত্ত করবে| পাপমোচনের নৈবেদ্যর রক্ত দিয়ে এই প্রায়শ্চিত্ত করতে হবে| এটি প্রভুর কাছে সবচেয়ে পবিত্র| এই দিনটি চিহ্নিত হবে প্রায়শ্চিত্তের দিন হিসেবে| এই দিনটি হবে প্রভুর কাছে একটি বিশেষ দিন|” ");
INSERT INTO ben2006_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ইস্রায়েলের জনসংখ্যা গণনা করো তাহলে বুঝতে পারবে কতজন ইস্রায়েলে বসবাস করে| তাদের প্রত্যেকে প্রভুকে কিছু না কিছু অর্থ দান করবে| যদি প্রত্যেকে এটা মেনে চলে তাহলে তাদের জীবনে কোন ভয়ঙ্কর ঘটনা ঘটবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","এই লোকদের প্রত্যেককে আমলাতান্ত্রিক মান অনুযায়ী 1/2 শেকল দিতে হবে| এই আমলাতান্ত্রিক শেকলের ওজন হল 20 গেরা| এই 1/2 শেকল প্রভুর প্রতি একটি নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","কুড়ি বছর হলে তাকে গণনার আওতায় আনা হবে| এবং গণনার আওতায় চলে আসা প্রত্যেকে এই নৈবেদ্য দেবে প্রভুর প্রতি| ");
INSERT INTO ben2006_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","বড় লোকরা 1/2 শেকলের বেশী দেবে না আবার গরীবরা 1/2 শেকলের কম দেবে না| তাদের জীবনের প্রায়শ্চিত্তের জন্য প্রত্যেককে অবশ্যই সমপরিমাণ নৈবেদ্য প্রভুকে অর্পণ করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","প্রায়শ্চিত্ত নৈবেদ্যর সমস্ত অর্থ জমা কর এবং ঐ অর্থ সমাগম তাঁবুর যাবতীয় খরচের জন্য ব্যবহার কর| এই নৈবেদ্য এরকমভাবে প্রভুকে তাঁর লোকদের কথা মনে রাখাবার জন্য| তারা তাদের নিজেদের জীবনের জন্য মূল্য দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“পিতলের একটি পায়া তৈরী করে তার ওপর একটি পিতলের পাত্র বসাবে| এই পাত্রে অন্য সব কিছু পরিষ্কার করে ধোয়া হবে| সমাগম তাঁবু ও বেদীর মাঝখানে ঐ পাত্র বসিয়ে তাতে জল ভর্ত্তি করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","হারোণ ও তার পুত্ররা ঐ পাত্রের জলে তাদের হাত পা ধোবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","যখনই তারা সমাগম তাঁবুতে প্রবেশ করবে অথবা প্রভুর কাছে নৈবেদ্য পোড়াবার জন্য বেদীর কাছে আসবে তখনই তাদের ঐ পাত্রের জল দিয়ে নিজেদের পরিষ্কার করতে হবে যাতে তারা মারা না যায়| এটা মেনে চললে তারা মারা যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","যদি তারা মরতে না চায় তাহলে এই বিধি তাদের মেনে চলতে হবে| এই বিধি হারোণ এবং তার উত্তরপুরুষদের চিরকাল মেনে চলতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“সুগন্ধি মশলা খুঁজে আনো| 12 পাউণ্ড ওজনের তরল মস্তকি, 6 পাউণ্ড ওজনের সুগন্ধি দারুচিনি, 6 পাউণ্ড ওজনের সুগন্ধি এবং ");
INSERT INTO ben2006_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","বারো পাউণ্ড ওজনের সূক্ষ্ম ধরণের দারুচিনি নিয়ে এসো| এগুলিকে প্রচলিত শেকলের মান অনুযায়ীওজন কর| 1 গ্যালন জলপাইয়ের তেলও এনো| ");
INSERT INTO ben2006_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“সুগন্ধি অভিষেকের তেল তৈরী করবার জন্য এই জিনিসগুলি বিশেষজ্ঞের মতো মেশাও| ");
INSERT INTO ben2006_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","সমাগম তাঁবুর ওপর ও সাক্ষ্যসিন্দুকের ওপর ঐ তেল ছিটিয়ে দাও| এর ফলে ঐ জিনিসগুলোর বিশেষত্ব প্রকাশ পাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","টেবিল এবং টেবিলের ওপর রাখা প্লেটে ওই তেল ছিটোবে| দীপদান ও তার সকল পাত্র ও ধূপবেদীতেও ঐ তেল ছিটোবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","হোমবলির বেদীতে এবং হোমবলির জন্য ব্যবহৃত সমস্ত পাত্রে এবং হাত পা ধোয়ার সেই পাত্র ও পাত্রের নীচে রাখা পায়াতেও ঐ তেল ছিটিয়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","প্রভুর সেবার জন্য এই সমস্ত জিনিসগুলোকে তোমাকে পবিত্র করে তুলতে হবে| তাহলেই তারা পবিত্র হয়ে উঠবে| এই জিনিসগুলোকে অন্য কিছু স্পর্শ করলে সেগুলোও পবিত্র হয়ে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“যাজকরূপে বিশেষ উপায়ে আমাকে সেবার জন্য হারোণ ও তার পুত্রদের গায়েও ঐ তেল ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ইস্রায়েলের লোকদের বলো যে এই অভিষেকের তেল হল পবিত্র| ইস্রায়েলের লোকদের বলো যে এই তেল অবশ্যই তাদের বংশ পরম্পরায় একমাত্র আমার জন্যই ব্যবহৃত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","সাধারণ সুগন্ধি হিসেবে কেউ যেন এই তেল ব্যবহার না করে| এই সূত্র অনুসারে অন্য কোন তেল তৈরী করবে না| এই তেল পবিত্র এবং তোমাদের কাছে এর বিশেষ অর্থ আছে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","যদি কেউ এই পবিত্র তেল সাধারণ সুগন্ধি হিসাবে তৈরী করে অথবা এটি কারো ওপর আরোপ করে, তার লোকদের থেকে তাকে বিতাড়িত করে দেওয়া হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","এরপর প্রভু মোশিকে বললেন, “এই সুগন্ধি মশলাগুলো জোগাড় করে আনো: ধুনো, নখী, গুগ্গুল, কুন্দুরু| মনে রাখবে প্রত্যেকটি মশলার পরিমাণ হবে সমান| ");
INSERT INTO ben2006_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","পরিষ্কার লবনের সঙ্গে এই সুগন্ধি মশলাগুলো মেশাও এবং সুগন্ধি তৈরী করার মতো সুগন্ধি ধূপ বানাও| এই প্রক্রিয়া ধূপকে খাঁটি এবং পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","খানিকটা পাউডারের মতো ধূপের গুঁড়ো করে নিয়ে সেই মিহি করা ধূপের গুঁড়ো যে সমাগম তাঁবুতে আমি তোমাদের দর্শন দেব তার মধ্যে রাখা সাক্ষ্যসিন্দুকের সামনে রাখবে| বিশেষ প্রয়োজনেই শুধুমাত্র এই ধূপের গুঁড়ো ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","প্রভুর জন্য বিশেষ প্রয়োজন ছাড়া এর ব্যবহার হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","সুগন্ধি ধূপের গন্ধ অনুভব করতে কেউ যদি নিজের জন্য এই ধূপের গুঁড়ো নিয়ে যায় তাহলে সে সমাজচ্যূত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“আমার বিশেষ কাজের জন্য আমি যিহূদা বংশীয় একজনকে নির্বাচন করেছি| তার নাম হল বৎসলেল| বৎসলেল হল হূরের পৌত্র এবং উরির পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","আমি বৎসলেলকে ঈশ্বরের আত্মা, পটুতা, দক্ষতা এবং সমস্ত রকমের কলা ও শিল্পের জ্ঞান দিয়ে ভরে দিয়েছি| ");
INSERT INTO ben2006_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","বৎসলেল একজন ভাল শিল্পকার এবং সে সোনা, রূপো ও পিতল থেকে নানা জিনিসপত্র তৈরী করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","বৎসলেল নানা মণি মাণিক্য কাটতে ও তাতে খোদাই করে সুন্দর অলঙ্কার তৈরী করতে পারে| সে কাঠের শিল্পকর্মেও পারদর্শী| বৎসলেল সব ধরণের কাজ করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","বৎসলেলের সঙ্গে কাজ করার জন্য আমি অহলীয়াবকে নির্বাচন করেছি| অহলীয়াব হল দান পরিবারগোষ্ঠীর অহীষামকের পুত্র| আমি বাকী কারিগরদের সব রকম দক্ষতা দিয়েছি যাতে ওরা তোমাকে দেওয়া আমার নির্দেশগুলো পালন করতে পারে: ");
INSERT INTO ben2006_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","সমাগম তাঁবু, সাক্ষ্যসিন্দুক, সাক্ষ্য সিন্দুকের ওপরের আচ্ছাদন এবং সমাগম তাঁবুর সমস্ত আসবাবপত্র| ");
INSERT INTO ben2006_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","টেবিল ও তার ওপর রাখা যাবতীয় সব কিছু, আনুষঙ্গিক অংশসহ খাঁটি সোনার বাতিস্তম্ভটি এবং ধূপবেদী| ");
INSERT INTO ben2006_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","হোমবলির বেদী এবং বেদীতে ব্যবহৃত জিনিসপত্র| হাত পা ধোয়ার পাত্র ও পাত্রের নীচের পায়া| ");
INSERT INTO ben2006_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","যাজক হারোণের জন্য বোনা বিশেষ পোশাক পরিচ্ছদ এবং হারোণের পুত্ররা যখন যাজকের কাজ করবে তখন তাদের জন্য বোনা বিশেষ পোশাক পরিচ্ছদ| ");
INSERT INTO ben2006_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","সুগন্ধি অভিষেকের তেল, পবিত্র স্থানে ব্যবহারের সুগন্ধি ধূপ| আমি তোমাকে ঠিক যেভাবে নির্দেশ দিয়েছি ঠিক সেইভাবেই তাদের এই জিনিসগুলো তৈরী করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ইস্রায়েলের লোকদের এই কথাগুলি বলো: তোমরা অবশ্যই আমার বিশ্রামের দিন বিধি অনুসারে পালন করবে| তোমরা এটা অবশ্যই করবে কারণ প্রজন্মের পর প্রজন্ম এটা তোমার এবং আমার মধ্যে একটি প্রতীক চিহ্ন হিসাবে বিরাজ করবে| এই চিহ্ন দেখাবে যে, আমিই প্রভু, তোমাদের পবিত্র করেছি| ");
INSERT INTO ben2006_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“এই বিশ্রামের দিনকে একটি বিশেষ দিনের মর্যাদা দেবে| যদি কেউ এই বিশেষ বিশ্রামের দিনকে অন্য একটি সাধারণ দিনের মতো পালন করে তাহলে তাকে অবশ্যই হত্যা করতে হবে| যদি কেউ এই বিশ্রামের দিনেও কাজ করে, তাহলে তাকে তার লোকদের থেকে বিতাড়িত করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","কাজ করার জন্য সপ্তাহের বাকি ছয় দিন নির্দিষ্ট থাকবে কিন্তু সপ্তম দিনটি হবে বিশেষ বিশ্রামের দিন| এই দিনটি তোলা থাকবে প্রভুর প্রতি সম্মান প্রদর্শনের দিন হিসেবে| এই বিশেষ বিশ্রামের দিনে কেউ কাজ করলে তার মৃত্য়ু অনিবার্য| ");
INSERT INTO ben2006_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","বিশ্রামের দিনটিকে সর্বদা মনে রেখে ইস্রায়েলের মানুষ বিশেষ দিন হিসেবে পালন করবে| তারা সর্বদা এটা মেনে চলবে| এটা হল আমার ও তাদের মধ্যে এক চিরস্থায়ী বন্দোবস্ত| ");
INSERT INTO ben2006_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","বিশ্রামের দিনটি একটি চিরস্থায়ী চিহ্ন হিসেবে বেঁচে থাকবে আমার ও ইস্রায়েলের লোকদের মধ্যে| প্রভু সপ্তাহের ছয় দিন পরিশ্রম করে এই স্বর্গ ও মর্ত্য তৈরী করেছেন| কিন্তু সপ্তম দিনে তিনি বিশ্রাম ও অবসরের মধ্যে কাটিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","সীনয় পর্বতে এরপর প্রভু মোশির সঙ্গে কথোপকথন শেষ করলেন| তারপর তিনি বন্দোবস্ত লেখা দুটো সমান্তরাল পাথর ফলক মোশিকে দিলেন| ঈশ্বর নিজের হাতে ঐ দুই পাথর ফলকে লিখেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","পর্বত থেকে মোশির নামতে দেরী হচ্ছে দেখে লোকরা উদ্বিগ্ন হয়ে হারোণকে ঘিরে ধরল| তারা বলল, “মোশি আমাদের পথ দেখিয়ে মিশর দেশ থেকে বার করে এনেছে কিন্তু আমরা তো এখান থেকে কিছুই বুঝে উঠতে পারছি না যে মোশির কি হয়েছে| সুতরাং এসো, আমরা আমাদের নেতৃত্ব দেবার জন্য দেবতাদের তৈরী করি|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","হারোণ তখন ঐ লোকদের বলল, “তোমরা আমার কাছে তোমাদের স্ত্রী, পুত্র, কন্যাদের কানের সোনার দুল এনে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","সুতরাং সবাই তাদের স্ত্রী, পুত্র ও কন্যাদের কানের দুল এনে হারোণকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","হারোণ সবার কাছ থেকে সোনার দুলগুলো নিয়ে সেগুলো গলিয়ে একটি বাছুরের মূর্তি গড়ল| হারোণ বাটালি দিয়ে বাছুরের মূর্তি গড়ল এবং সোনা দিয়ে মূর্তিটির আচ্ছাদন তৈরী করল| তখন লোকরা বলল, “হে ইস্রায়েল, এই তোমার দেবতা যিনি তোমাকে মিশর দেশ থেকে বাইরে এনেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","সব দেখার পর হারোণ বাছুরের মূর্তির সামনে একটি বেদী তৈরী করল| এরপর হারোণ ঘোষণা করে জানাল, “আগামীকাল প্রভুর সম্মানার্থে একটি বিশেষ চড়ুই ভাতি উৎসব পালন করা হবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","পরদিন খুব ভোরে লোকরা উঠে কিছু পশুকে মেরে হোমবলি ও মঙ্গল নৈবেদ্য দিল| তারপর তারা বসে পাত পেড়ে খাওয়া দাওয়া করে আনন্দ স্ফূর্তিতে মেতে উঠল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ঠিক সেই সময়ে প্রভু মোশিকে বললেন, “তোমার লোকরা, যাদের তুমি মিশর দেশ থেকে বের করে এনেছো, তারা মারাত্মক পাপ কাজে লিপ্ত হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","আমার নির্দেশ সম্পূর্ণরূপে অগ্রাহ্য করে সোনা গলিয়ে তারা একটি বাছুরের মূর্তি তৈরী করেছে| তারা গলা সোনা দিয়ে তৈরী একটি বাছুরের মূর্তিকে পূজো করছে এবং তাকে নৈবেদ্য দিচ্ছে| আবার তারা বলছে, ‘ইস্রায়েল, এই হচ্ছে তোমার দেবতা যিনি তোমাকে মিশর থেকে বার করে এনেছেন|’” ");
INSERT INTO ben2006_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","প্রভু মোশিকে বললেন, “আমি ঐ লোকদের ভাল করে চিনি| ওরা ভীষণ জেদী ও উদ্ধত| ");
INSERT INTO ben2006_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","সুতরাং আমাকে একা থাকতে দাও| আমি তাদের ওপর ক্রুদ্ধ, আমি তাদের ধ্বংস করব| তারপর আমি তোমাকে দিয়ে একটা বড় জাতির সৃষ্টি করব|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","কিন্তু মোশি বিনয়ের সঙ্গে, প্রভু তার ঈশ্বরকে অনুরোধ করল, “আপনি ক্রোধ দিয়ে আপনার লোকদের ধ্বংস করবেন না| আপনি আপনার শক্তি ও পরাক্রম দিয়ে ঐ মানুষদের মিশর দেশ থেকে বাইরে এনেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","কিন্তু আপনি যদি ওদের ধ্বংস করেন তাহলে মিশরীয়রা বলতে পারে, ‘প্রভু নিজের লোকদের জন্য খারাপ কিছু করার পরিকল্পনা করেছিলেন| তাই তিনি ঐ লোকদের মিশর থেকে বের করে নিয়ে গিয়েছিলেন| তিনি চেয়েছিলেন পর্বতের ওপর নিয়ে গিয়ে তাদের হত্যা করতে| তিনি চেয়েছিলেন তাদের পৃথিবী থেকে সরিয়ে দিতে|’ তাই আপনি তাদের ওপর রাগ করবেন না| দয়া করে আপনার মনকে বদলান| আপনার জনগণকে ধ্বংস করবেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","আপনার দাসগণ অব্রাহাম, ইসহাক এবং যাকোবকে স্মরণ করুন| এবং আপনি তাদের কাছে নিজের নামে শপথ নিয়ে বলেছিলেন: ‘আমি প্রতিজ্ঞা করছি যে আকাশের অসংখ্য তারার মতো তোমাদের বংশ বৃদ্ধি হবে| এই দেশ তোমাদের বংশধরদের দিয়ে দেব| ওরা এখানে চিরকালের জন্য থাকবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","তাই প্রভু তাঁর মন পরিবর্তন করলেন এবং তাঁর লোকদের ধ্বংস করবার ভীতি প্রদর্শন পালন করলেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","তখন মোশি ঘুরে দাঁড়াল এবং পর্বতের নীচে নামল| তার হাতে ছিল বন্দোবস্ত লেখা দুই পাথর ফলক| ঐ দুই পাথর ফলকের দুপাশেই লেখা ছিল প্রভুর নির্দেশগুলি| ");
INSERT INTO ben2006_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ঈশ্বর নিজের হাতে ঐ দুই পাথর ফলক তৈরী করে নিজেই ঐ নির্দেশগুলি লিখেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","যিহোশূয় শিবিরের গভীরে লোকজনের কোলাহল শুনতে পেল এবং মোশিকে বলল, “মনে হচ্ছে শিবিরের লোকরা যুদ্ধ করছে|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","উত্তরে মোশি বলল, “এই কোলাহল কোন যুদ্ধ জয়ের উল্লাস নয় আবার পরাজয়ের কান্নাও নয়| আমি কিন্তু গান বাজনা শুনতে পাচ্ছি|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","মোশি সেই শিবিরের কাছে গেল| সে দেখল সোনার বাছুরের মূর্তিটি এবং লোকরা তা নিয়ে নাচানাচি করছে| এসব দেখে মোশি রেগে গেল, রাগের চোটে হাত থেকে পাথর ফলকগুলি নীচে ফেলে দিল এবং পর্বতের পাদদেশে তাদের ভেঙ্গে চূর্ণবিচূর্ণ করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","মোশি সেই সোনার বাছুরের মূর্তিকে আগুনে ছুঁড়ে ফেলে দিল| তারপর আগুনে সেই মূর্তি গলে গেলে সেই ছাই জলে মিশিয়ে ইস্রায়েলের লোকদের সেই জল পান করতে বাধ্য করল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","মোশি হারোণকে বলল, “এই লোকরা তোমার সঙ্গে কি করেছিল যে তুমি ওদের এমন পাপের দিকে ঠেলে দিলে?” ");
INSERT INTO ben2006_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","হারোণ উত্তর দিল, “মহাশয়, রাগ করো না| তুমি তো জানো এরা সব সময়ই ভুল পথে পা বাড়ায| ");
INSERT INTO ben2006_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ওরা আমায় বলেছিল, ‘মোশি আমাদের মিশর দেশ থেকে নেতৃত্ব দিয়ে বের করে আনলেও এখন কিন্তু তার কোন খবর পাওয়া যাচ্ছে না| তাই আমাদের জন্য এমন দেবতাসমূহ তৈরী করে দাও যারা আমাদের নেতৃত্ব দেবে|’ ");
INSERT INTO ben2006_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","তখন আমি ওদের বলেছিলাম, ‘যদি তোমাদের কোন সোনার দুল থাকে তাহলে আমাকে সব দাও|’ ওরা আমাকে সোনার দুল দিলে আমি সেগুলো আগুনে ফেলে দিলে আগুন থেকে ঐ বাছুরটি বার হয়ে এলো|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","মোশি দেখল হারোণ লোকদের ওপর নিয়ন্ত্রণ হারিয়েছে এবং তারা স্বেচ্ছাচারী হয়ে উঠেছে| লোকরা বন্য হয়ে উঠেছে| এবং তাদের সমস্ত শত্রুরা এই বোকামী দেখতে পেয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","তাই মোশি সেই শিবিরের প্রবেশ দ্বারে দাঁড়িয়ে বলে উঠল, “কেউ যদি প্রভুকে অনুসরণ করতে চাও তাহলে আমার কাছে এসো|” এবং লেবি বংশজাত লোকরা সবাই দৌড়ে মোশির কাছে চলে এল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","তখন মোশি তাদের বলল, “প্রভু ইস্রায়েলের ঈশ্বর কি বলেন তা আমি তোমাদের বলব: ‘প্রত্যেকে তার নিজের নিজের তরবারি হাতে তুলে নিয়ে শিবিরের এ প্রান্ত থেকে ও প্রান্তে গিয়ে সমস্ত লোকদের হত্যা করে তাদের শাস্তি দাও| প্রত্যেকে তার বন্ধু ভাই এবং প্রতিবেশীকে হত্যা করবে|’” ");
INSERT INTO ben2006_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","লেবি বংশজাত প্রত্যেক মানুষ মোশির নির্দেশ পালন করল| সেই দিন অন্তত 3000 ইস্রায়েলবাসীকে হত্যা করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","তখন মোশি বলল, “আজ থেকে প্রভু তোমাদের তাঁর সেবার জন্য উৎসর্গ করেছেন এবং আজ তিনি তোমাদের আশীর্বাদ করেছেন কারণ তোমরা প্রত্যেকে তোমাদের পুত্রদের এবং ভাইদের বিরুদ্ধে ঝগড়া করেছ|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","পরদিন সকালে মোশি সবাইকে বলল, “তোমরা মারাত্মক পাপ কাজ করেছো কিন্তু এখন আমি প্রভুর কাছে যাব এবং চেষ্টা করব যাতে তিনি তোমাদের এই পাপকে ক্ষমা করে দেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","সুতরাং মোশি আবার প্রভুর কাছে ফিরে গিয়ে বলল, “প্রভু অনুগ্রহ করে শুনুন| ওরা সোনার দেবতা তৈরী করে মারাত্মক পাপ করেছে| ");
INSERT INTO ben2006_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","এখন আপনি ওদের এই পাপকে ক্ষমা করে দিন| যদি আপনি ওদের ক্ষমা না করেন তাহলে আপনার লেখা পুস্তক থেকে আমার নাম মুছে দিন|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","প্রভু মোশিকে বললেন, “যে আমার বিরুদ্ধে পাপ কাজ করেছে আমি কেবল তার নামই আমার পুস্তক থেকে কেটে ফেলব| ");
INSERT INTO ben2006_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","তাই এখন তুমি নীচে গিয়ে লোকদের যে দেশে নিয়ে যেতে বলেছি সেই দেশে নিয়ে যাও| আমার দূত তোমাদের আগে পথ দেখাতে দেখাতে যাবে, পাপীর যখন বিনাশের সময় হবে তখন সে শাস্তি পাবেই|” ");
INSERT INTO ben2006_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","তাই প্রভু লোকদের ওপর একটি মহামারী ছড়িয়ে দিলেন কারণ তারা হারোণকে বাছুরের মূর্তি তৈরী করতে বাধ্য করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","তখন প্রভু মোশিকে বললেন, “তুমি এবং তোমার লোকদের, যাদের তুমি মিশর থেকে এনেছিলে তাদের অবশ্যই এখান থেকে চলে যেতে হবে| অব্রাহাম, ইসহাক ও যাকোবকে আমি যে দেশ দেব বলে প্রতিজ্ঞা করেছিলাম সেই দেশে চলে যাও| আমি প্রতিজ্ঞা করেছিলাম যে আমি ওদের পরবর্তী উত্তরপুরুষদের ঐ দেশ দিয়ে যাব| ");
INSERT INTO ben2006_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","তাই আমি তোমার আগে একজন দূত পাঠাব এবং কনানীয়, ইমোরীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের পরাজিত করে ঐ দেশ থেকে তাড়িয়ে দেব| ");
INSERT INTO ben2006_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","তোমরা সেই ভাল দেশে যাও সেখানে সব কিছু সুন্দর| কিন্তু আমি তোমার সঙ্গে যাব না| তোমরা ভীষণ একগুঁয়ে ও জেদী| তোমরা আমাকে ক্রুদ্ধ করেছ| যদি আমি তোমাদের সঙ্গে যাই তাহলে হয়তো আমি তোমাদের ধ্বংস করতে পারি|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","এই দুঃসংবাদ শোনার পর লোকরা ভীষন হতাশ হয়ে পড়ল এবং তারা মণিমাণিক্য ব্যবহার করা বন্ধ করে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","কেন? কারণ মোশিকে প্রভু বলেছেন, “ইস্রায়েলবাসীকে বলো, ‘তোমরা একগুঁয়ে জেদী প্রকৃতির মানুষ| খুব কম সময়ের জন্যও আমি যদি তোমাদের সঙ্গে ভ্রমণ করি তাহলে তোমাদের বিনাশ হতে পারে| সুতরাং যখন আমি স্থির করব ইস্রায়েলকে কি করতে হবে তখন তোমরা নিজেদের দেহ থেকে অলঙ্কারাদি খুলে ফেল|’” ");
INSERT INTO ben2006_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","সুতরাং ইস্রায়েলবাসীরা হোরেব পর্বত থেকে তাদের যাত্রাপথে নিজেদের অলঙ্কারাদি খুলে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","মোশি শিবিরের একটু দূরে অন্য একটি তাঁবু স্থাপন করল| মোশি এই তাঁবুর নাম দিল “সমাগম তাঁবু|” প্রভুকে কেউ যদি কিছু জিজ্ঞাসা করতে চায় তাহলে সে শিবিরের বাইরে ঐ সমাগম তাঁবুতে যেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","যখন খুশি মোশি ঐ সমাগম তাঁবুতে যেত| সবাই তাকে লক্ষ্য করত| সকলে নিজস্ব তাঁবুর দরজায় দাঁড়িয়ে মোশির সমাগম তাঁবুর অভ্যন্তরে যাওয়া দেখতো| ");
INSERT INTO ben2006_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","মোশি যখনই ঐ সমাগম তাঁবুতে প্রবেশ করতো তখনই তাঁবুর দরজায় মেঘস্তম্ভ নেমে আসত এবং প্রভু তখন মোশির সঙ্গে কথা বলতেন| ");
INSERT INTO ben2006_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","লোকরা সমাগম তাঁবুর দরজায় মেঘস্তম্ভ দেখতে পেলেই তারা নিজের নিজের তাঁবুর মধ্যে হাঁটু গেড়ে ঈশ্বরের উপাসনা করতো| ");
INSERT INTO ben2006_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","এভাবেই প্রভু মোশির সঙ্গে মুখোমুখি কথা বলত| প্রভু বন্ধুর মতো মোশির সঙ্গে কথা বলতেন| প্রভুর সঙ্গে কথা শেষ করার পর মোশি শিবিরে ফিরে যেত কিন্তু মোশির পরিচারক (দাস), নূনের পুত্র যিহোশূয় তাঁবুর বাইরে বেরোত না| ");
INSERT INTO ben2006_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","মোশি প্রভুকে বলল, “আপনি এই লোকদের নেতৃত্ব দিতে বলেছিলেন কিন্তু আমার সঙ্গে আপনি কাকে পাঠাবেন তা কিন্তু বলেন নি| আপনি বলেছেন, ‘আমি তোমাকে ভাল করে চিনি এবং তোমার ওপর আমি সন্তুষ্ট|’ ");
INSERT INTO ben2006_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","আমি যদি সত্যিই আপনাকে সন্তুষ্ট করে থাকি তাহলে আমাকে আপনার শিক্ষা ও জ্ঞান দিন| আমি আপনাকে জানতে চাই| তাহলে আমি আপনাকে বরাবর সন্তুষ্ট করতে পারব| মনে রাখবেন যে তাদের সবাই আপনার লোক|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","প্রভু উত্তরে বললেন, “আমি নিজে তোমার সঙ্গে যাব, আমি তোমাকে বিশ্রাম দেব|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","তখন মোশি প্রভুকে বলল, “আপনি যদি আমাদের সঙ্গে না যান তাহলে আমাদের এই স্থান থেকে সরাবেন না| ");
INSERT INTO ben2006_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","তাছাড়া, আমরা কি করে বুঝব আপনি আমার এবং আপনার লোকদের ওপর সন্তুষ্ট? আপনি যদি আমাদের সঙ্গে যান তাহলে বুঝব আপনি আমাদের ওপর সন্তুষ্ট হয়েছেন| আপনি যদি আমাদের সঙ্গে না আসেন, তাহলে আমার এবং আপনার লোকদের মধ্যে এবং পৃথিবীর অন্য জাতির মধ্যে আর কোন পার্থক্য থাকবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","তখন প্রভু মোশিকে বললেন, “বেশ আমি তোমার ইচ্ছা পূরণ করব| কারণ আমি তোমার ওপর সন্তুষ্ট এবং আমি তোমাকে ভাল করে জানি|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","তখন মোশি বলল, “দয়া করে আপনার মহিমা আমায় দেখান|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","তখন প্রভু উত্তর দিলেন, “আমি আমার সমস্ত গুণাবলীকে তোমার সামনে দিয়ে গমণ করাবো| আমিই প্রভু এবং তোমরা যাতে শুনতে পাও সেইজন্য আমি আমার নাম ঘোষণা করব| কারণ আমার যাকে খুশী আমি আমার করুণা ও ভালবাসা দেখাতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","কিন্তু তোমরা আমার মুখ দেখতে পাবে না| আমাকে দেখার পর কেউ বাঁচতে পারবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“আমার খুব কাছেই একটি পাথর আছে; তোমরা সেই পাথরের ওপর দাঁড়াতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ঐ স্থান দিয়েই আমার মহিমা প্রকাশ পাবে| আমি তোমাদের ঐ পাথরের একটি বিশাল ফাটলে রেখে দেব এবং আমি যখন ওখান দিয়ে যাব তখন আমার হাত তোমাদের ঢেকে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","এরপর আমি তোমাদের ওপর থেকে হাত সরিয়ে নেব এবং তোমরা আমার পিছন দিক দেখতে পাবে কিন্তু আমার মুখ দেখতে পাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","তখন প্রভু মোশিকে বললেন, “পূর্ববর্তী দুটি প্রস্তর ফলক, যে দুটি তুমি ভেঙ্গেছিলে সেরকম আরো দুটি প্রস্তর ফলক তুমি তৈরী কর| প্রথম ফলক দুটিতে যেসব কথা লেখা হয়েছিল সেইসব কথা আমি আবার এই ফলক দুটিতে লিখব| ");
INSERT INTO ben2006_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","কাল সকালে প্রস্তুত হয়ে নিও এবং আমার সঙ্গে দেখা করবার জন্য সীনয় পর্বতের চূড়ায় এসো| ");
INSERT INTO ben2006_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","আর কেউ তোমার সঙ্গে আসবে না| অন্য কাউকে যেন পর্বতের কোথাও না দেখা যায়| এমনকি কোনও পশুর দল বা মেষের পালকেও পর্বতের নীচে চরতে দেওয়া যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","তাই মোশি প্রথম পাথরের ফলকের মতো আরও দুটি ফলক তৈরী করল| তারপর পরদিন সকালে উঠে সীনয় পর্বতের চূড়ায় গেল| মোশি প্রভুর আদেশ অনুসারে সব কিছু করল| সে পাথরের ফলক দুটি সঙ্গে করে নিয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","অতঃপর প্রভু মেঘের মধ্যে মোশির কাছে নেমে এলেন এবং তার সঙ্গে দাঁড়ালেন এবং তাঁর নাম (প্রভুর) ঘোষণা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","প্রভু মোশির সামনে দিয়ে গেলেন এবং বললেন, “যিহোবা, প্রভু হলেন দয়ালু ও করুণাময়| তিনি ক্রোধের ব্যাপারে ধৈর্য্যশীল| তিনি পরমস্নেহে পরিপূর্ণ এবং বিশ্বস্ত| ");
INSERT INTO ben2006_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","হাজার হাজার পুরুষ ধরে প্রভু তাঁর করুণা দেখান| তিনি ভুল কাজ, অবাধ্যতা এবং পাপ ক্ষমা করে দেন| কিন্তু তবু তিনি দোষীদের শাস্তি দিতে ভোলেন না| তিনি কেবলমাত্র দোষীদেরই শাস্তি দেন না, তাদের দণ্ডনীয় অপরাধের জন্য তাদের তৃতীয় ও চতুর্থ পুরুষের উত্তরপুরুষদেরও শাস্তি দেন|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","তখন মোশি সঙ্গে সঙ্গে হাঁটু গেড়ে বসল ও আভুমি মাথা নত করে প্রভুর কাছে প্রার্থনা করল এবং বলল, ");
INSERT INTO ben2006_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“প্রভু, আপনি যদি আমার প্রতি সন্তুষ্ট হন তাহলে আমাদের সঙ্গে চলুন| আমি জানি আমরা জেদী কিন্তু আমাদের অপরাধ ক্ষমা করে দিন| আমাদের ওপর আপনার নিজের পূর্ণ অধিকার আছে বলে মনে করুন এবং আমাদের গ্রহণ করুন|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","তখন প্রভু বললেন, “আমি তোমার লোকদের সঙ্গে এই চুক্তি করি যে আমি তোমার লোকদের সামনে এমন সব আশ্চর্য্য কার্য করব যা ইতিপূর্বে পৃথিবীর কোনও দেশে হয় নি| তখন তোমাদের চারপাশের সমস্ত জাতিসমূহ দেখতে পাবে আমি কত মহান| তারা এইসব আশ্চর্য্য জিনিস দেখবে যা আমি তোমাদের জন্য করব| ");
INSERT INTO ben2006_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","আমি যা আদেশ দিচ্ছি, আজ তা পালন কর তাহলে আমি তোমাদের শত্রুদের তোমাদের দেশ ত্যাগ করতে বাধ্য করব| আমি ইমোরীয়, কনানীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের বিতাড়ন করব| ");
INSERT INTO ben2006_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","সাবধান! তোমরা যেখানে যাচ্ছো সেখানকার লোকদের সঙ্গে কোনও চুক্তি কোরো না| তাহলে তোমরা বিপদে পড়বে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","তাদের বেদী ধ্বংস কর| যে পাথরকে তারা পূজো করে তা ভেঙ্গে ফেলো| তাদের পবিত্র দণ্ডগুলি ধ্বংস করো| ");
INSERT INTO ben2006_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","অন্য কোনও দেবতাকে পূজা করো না কারণ আমার নাম ঈর্ষা| আমি হলাম ঈর্ষাপরায়ণ ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ঐ দেশের লোকদের সঙ্গে কোনও চুক্তি না করার ব্যাপারে সাবধান থেকো| কারণ তোমরা তাদের দেবতাদের পূজো করে এবং তাদের নৈবেদ্য উৎসর্গ করে ব্যভিচার করবে| তারা তাদের নৈবেদ্য ভক্ষণ করতে তোমাদের নিমন্ত্রণ করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","তোমরা যদি তাদের কন্যাদের পুত্রবধূরূপে গ্রহণ করো তাহলে ঐ মহিলারা তোমাদের পুত্রদের তাদের ঐ দেবতাদের পূজো করাবে এবং তারা তোমাদের পুত্রদের প্রভুর প্রতি অবিশ্বস্ত করে তুলবে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“কোনও মূর্ত্তি তৈরী করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“খামিরবিহীন রুটির উৎসব পালন করবে| আমি তোমাদের যেমন আদেশ দিয়েছিলাম সেই মতো সাতদিন ধরে খামিরবিহীন রুটি খাবে| তোমরা এটা আবীব মাসে করবে কারণ ঐ মাসে তোমরা মিশর ছেড়ে বেরিয়ে এসেছিলে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“কোনও নারীর প্রথম গর্ভজাত পুত্র সন্তান হবে আমার| এমনকি গবাদি পশুর অথবা মেষের প্রথমজাত পুরুষশাবকও আমার অধিকারভুক্ত| ");
INSERT INTO ben2006_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","তোমরা যদি গাধার প্রথমজাত পুরুষশাবককে রাখতে চাও, তবে তোমরা একটি মেষশাবকের বিনিময়ে তা রাখতে পারো| কিন্তু তোমরা যদি ঐ গাধার শাবকটিকে একটি মেষের বিনিময়ে না কেনো তাহলে তোমাদের ঐ গাধার ঘাড় মটকাতে হবে| তোমাদের সমস্ত প্রথমজাত পুত্র সন্তানদের আমার কাছে থেকে ফেরৎ‌ নিতে হবে| কিন্তু কোনও লোকই উপহার ছাড়া আমার কাছে আসবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“তোমরা ছযদিন যাবৎ পরিশ্রম করবে ও সপ্তম দিনে বিশ্রাম নেবে| চাষের বীজ রোপন ও ফসল কাটার সময় তোমরা অবশ্যই বিশ্রাম নেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“সাত সপ্তাহের উৎসব পালন করবে| গম কাটার পর প্রথম কাটা ফসলের দানাগুলো এই উৎসবের জন্য ব্যবহার করবে এবং বছরের শেষে ফসল কাটার উৎসব পালন করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“বছরে তিনবার তোমাদের সমস্ত লোক সর্বশক্তিমান প্রভু, ইস্রায়েলের ঈশ্বরের সামনে উপস্থিত হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“তোমরা যখন তোমাদের দেশে যাবে তখন আমি তোমাদের শত্রুদের সেখান থেকে বিতাড়িত করতে বাধ্য করব| আমি তোমাদের দেশের সীমা বিস্তার করে দেব যাতে তোমরা আরও বেশী জমি পাও| তোমাদের অবশ্যই প্রতি বছরে তিনবার প্রভু, তোমাদের ঈশ্বরের সামনে যেতে হবে| এবং তখন কেউ তোমাদের দেশ অধিকার করার চেষ্টা করবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“যখন তোমরা আমাকে নৈবেদ্য হিসাবে রক্ত উৎসর্গ করবে তখন তার সঙ্গে খামির দেবে না| “নিস্তারপর্বে উৎসর্গীকৃত মাংস পরদিন সকাল পর্যন্ত রাখা উচিৎ‌ হবে না| ");
INSERT INTO ben2006_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“তোমাদের ক্ষেতের প্রথম ফসল প্রভুকে দেবে| ঐ ফসল প্রভু, তোমাদের ঈশ্বরের গৃহে নিয়ে আসবে| “কখনও কোনও ছাগশিশুকে তার মায়ের দুধ দিয়ে রান্না করবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","তারপর প্রভু মোশিকে বললেন, “তোমাকে আমি যা বলেছি সব কিছু লিখে রাখো| এইগুলিই হল তোমার এবং ইস্রায়েলের লোকদের মধ্যে চুক্তির দলিল|” ");
INSERT INTO ben2006_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","মোশি সেখানে প্রভুর সঙ্গে 40 দিন ও 40 রাত বাস করেছিল| মোশি 40 দিন কোন কিছু ভোজন করল না বা জল পান করল না| মোশি দুটি পাথরের ফলকের ওপর চুক্তির কথাগুলি লিখেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","তারপর মোশি সীনয় পর্বত থেকে নেমে এল| সে সেই চুক্তি লেখা পাথরের ফলক দুটি বয়ে নিয়ে এল| প্রভুর সঙ্গে কথা বলার পর মোশির মুখ জ্বলজ্বল করছিল| কিন্তু মোশি নিজে তা জানত না| ");
INSERT INTO ben2006_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","হারোণ ও ইস্রায়েলের অন্য সব লোকরা তার উজ্জ্বল মুখ দেখে তার কাছে যেতে ভয় পাচ্ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","তখন মোশি তাদের ডেকে পাঠাল| মোশি হারোণ এবং দলপতির সঙ্গে কথা বলল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","তারপর সমস্ত ইস্রায়েলবাসী মোশির কাছে এল| সীনয় পর্বতে প্রভু যেসব আদেশ দিয়েছেন মোশি সেই আদেশের কথা তাদের শোনাল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","মোশি তার কথা শেষ করে নিজের মুখ আবরণ দিয়ে ঢেকে ফেলল| ");
INSERT INTO ben2006_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","কিন্তু মোশি যখনই প্রভুর সঙ্গে কথা বলতে যেত তখন সে যতক্ষণ না বাইরে আসত ততক্ষণ সেই আবরণ খুলে রাখত| মোশি যখন প্রভুর সান্নিধ্য থেকে বেরিয়ে আসত এবং ইস্রায়েলের লোকদের প্রভুর আদেশসমূহ বলত, ");
INSERT INTO ben2006_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","তখন তারা মোশির মুখমণ্ডলের ওপর একটি দীপ্তি দেখতে পেত| তাই সে আবার তার মুখ ঢেকে ফেলত। পরের বার প্রভুর সঙ্গে কথা বলতে না যাওয়া পর্যন্ত সে ঐভাবেই মুখ ঢেকে রাখত| ");
INSERT INTO ben2006_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মোশি সমস্ত ইস্রায়েলবাসীকে একত্র করল| সে তাদের বলল, “প্রভু তোমাদের যা আদেশ করেছেন তা আমি তোমাদের বলব: ");
INSERT INTO ben2006_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“তোমরা ছয়দিন ধরে কাজ করবে কিন্তু সপ্তম দিনটি বিশেষভাবে বিশ্রামের জন্য থাকবে| তোমরা ঐদিন বিশ্রাম নেবে এবং এইভাবে প্রভুকে সম্মান জানাবে| যে ব্যক্তি সপ্তম দিন কাজ করবে তাকে হত্যা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ঐ বিশ্রামের দিন তোমাদের বাড়ীর কোথাও তোমরা আগুন পর্যন্ত জ্বালাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","মোশি ইস্রায়েলের সমস্ত মণ্ডলীকে বলল, “এইগুলি হল প্রভুর আদেশসমূহ: ");
INSERT INTO ben2006_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","প্রভুর জন্য বিশেষ উপহার সংগ্রহ কর| প্রত্যেকে মনে মনে ঠিক করে নেবে তোমরা কি দেবে| তারপর তোমরা প্রভুর কাছে উপহারসমূহ আনবে| সোনা, রূপো, পিতল; ");
INSERT INTO ben2006_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","নীল, বেগুনী ও লাল সুতো ও সূক্ষ্ম মসীনা বস্ত্র; ছাগলের লোম; ");
INSERT INTO ben2006_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","লাল রঙ করা মেষ চর্ম ও মসৃণ চর্ম; বাবলা কাঠ; ");
INSERT INTO ben2006_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","প্রদীপের জন্য তেল, অভিষেকের তেলের জন্য মশলাপাতি এবং সুগন্ধি ধূপকাঠির জন্য মশলা এনে তোমরা প্রভুকে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","এফোদ ও বক্ষাবরণের জন্য গোমেদ ও অন্যান্য মূল্যবান মণিমাণিক্যও সঙ্গে এনো| ");
INSERT INTO ben2006_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“তোমাদের মধ্যে যারা দক্ষ কারিগর তারা এসে প্রভুর আদেশমতো জিনিস তৈরী করো: ");
INSERT INTO ben2006_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","পবিত্র তাঁবু, তার বাইরের তাঁবু, তার আস্তরণ, আংটাগুলি, তক্তাসমুহ, আগল, খুঁটি ও ভিত্তিসমূহ; ");
INSERT INTO ben2006_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","পবিত্র সিন্দুক, তার খুঁটিগুলি, আস্তরণ এবং পর্দা যা পবিত্র সিন্দুক যেখানে রাখা আছে সেই জায়গা ঢেকে দেয়; ");
INSERT INTO ben2006_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","সেই টেবিল ও তার পায়াগুলি, টেবিলের ওপরের সমস্ত জিনিস এবং টেবিলের ওপরের বিশেষ রুটি; ");
INSERT INTO ben2006_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","বাতির জন্য বাতিদানসমূহ, তার আনুষঙ্গিক অঙ্গ এবং বাতির জন্য তেল; ");
INSERT INTO ben2006_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ধূপ বেদী এবং তার খুঁটিসমূহ; অভিষেকের তেল এবং সুগন্ধি ধূপ; যে পর্দা পবিত্র তাঁবুর প্রবেশদ্বার ঢেকে রাখবে; ");
INSERT INTO ben2006_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","হোমবলির জন্য বেদী এবং তার পিতলের জাল, খুঁটিগুলি এবং তার বাসনকোসন, পিতলের পাত্র ও তার দান; ");
INSERT INTO ben2006_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","প্রাঙ্গণের চারদিকের পর্দা, তাদের খুঁটি ও ভিত্তিসমূহ এবং প্রাঙ্গণের প্রবেশদ্বারের পর্দা ");
INSERT INTO ben2006_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","সমাগম তাঁবুর জন্য এবং প্রাঙ্গণের জন্য কীলকগুলি এবং তাদের দড়িগুলি; ");
INSERT INTO ben2006_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","পবিত্র স্থানে পরার জন্য যাজকের বিশেষ বস্ত্র – এসবই তোমরা আনবে| এই বিশেষ বস্ত্র যাজক হারোণ ও তার পুত্ররা পরবে| তারা যখন যাজক হবে তখন তারা এই বস্ত্র পরবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","তারপর ইস্রায়েলের সমগ্র মণ্ডলী মোশির কাছ থেকে চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","প্রত্যেকে, যাদের হৃদয়ে প্রবৃত্তি ও মনে ইচ্ছা হল তারা প্রভুর জন্য উপহার নিয়ে এল| এই উপহার সামগ্রীগুলি সমাগম তাঁবুর জন্য, তাঁবুর ভেতরের প্রয়োজনীয় জিনিস এবং বিশেষ বস্ত্র তৈরীর কাজে লাগানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","পুরুষ, স্ত্রী যারা ইচ্ছুক ছিল প্রভুর জন্য উপহার সামগ্রী নিয়ে এলো| তারা পিন, দুল, আংটি ও অন্যান্য গয়না নিয়ে এল এবং সমস্ত প্রভুকে দিয়ে দিল| এটা ছিল প্রভুর জন্য বিশেষ নৈবেদ্য. ");
INSERT INTO ben2006_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","যে সমস্ত লোকের কাছে মিহি শনের কাপড় ছিল এবং নীল, বেগুনী ও লাল সুতো ছিল তারা তা নিয়ে প্রভুর কাছে এলো, যাদের কাছে ছাগলের লোম বা লাল রঙ করা মেষের চামড়া বা মসৃণ চামড়া ছিল তারা সেগুলো নিয়ে এল এবং প্রভুকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","যারা প্রভুকে রূপো বা পিতল দিতে চাইল তারা সেটা নিয়ে এল| যাদের কাছে বাবলা কাঠ ছিল যা সমাগম তাঁবু নির্মাণের কাজে ব্যবহার করা যেতে পারে তারা সেটা আনল এবং তা প্রভুকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","প্রতিটি দক্ষ মহিলা তাদের হাত দিয়ে সুতো কেটে মিহি শনের কাপড় বুনল এবং লাল, নীল ও বেগুনী সুতো কাটল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ঐ দক্ষ মহিলারা যারা সাহায্য করতে চাইল, তারা ছাগলের লোম থেকে কাপড় তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ইস্রায়েলবাসীদের দলপতিরা গোমেদ ও অন্যান্য মণিমাণিক্য নিয়ে এলো যেগুলি এফোদ ও যাজকের বক্ষাবরণের উপর লাগানো হবে| ");
INSERT INTO ben2006_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","তারা মশলা ও জলপাই তেলও নিয়ে এল, এগুলি সুগন্ধি ধূপ, অভিষেকের তেল ও প্রদীপের তেল হিসেবে ব্যবহৃত করবার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","সমস্ত পুরুষ ও নারী, যারা সাহায্য করতে চাইছিল তারা প্রভুর জন্য উপহার সামগ্রী নিয়ে এল| তারা নিজেদের ইচ্ছায় স্বতঃস্ফূর্তভাবেই এই উপহারসামগ্রী প্রদান করল| প্রভু মোশি ও তার লোকদের যেসব জিনিস বানাতে আদেশ করেছিলেন সেইসব জিনিসই এই উপহার সামগ্রীর সাহায্যে তৈরী করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","তারপর মোশি ইস্রায়েলবাসীদের বলল, “দেখ, প্রভু যিহূদা বংশের হূরের পৌত্র, উরির পুত্র বৎসলেলকে মনোনীত করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","তিনি তাকে ঐশ্বরিক ক্ষমতা দিয়েছেন| তিনি তাকে জ্ঞানে ও সর্বপ্রকার বিদ্যায় পারদর্শী করে তুলেছেন| ");
INSERT INTO ben2006_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","সে সোনা, রূপো ও পিতলের জিনিস তৈরী করে তার ওপর কারুকার্য করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","সে মূল্যবান পাথর ও মণিমাণিক্য কেটে বসাতে পারে| সে কাঠ দিয়েও সর্বপ্রকার জিনিস তৈরী করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","প্রভু বৎসলেল ও অহলীয়াবকে শিক্ষাদান করার বিশেষ ক্ষমতা দিয়েছেন| অহলীয়াব হল দান বংশীয় অহীষামকের পুত্র| ");
INSERT INTO ben2006_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","প্রভু এই দুজনকেই সর্বপ্রকার কাজ করার জন্য বিশেষ দক্ষতা দিয়েছেন| তারা ছুতোর এবং ধাতুর কাজে দক্ষ| তারা মিহি শনের কাপড়, নীল, বেগুনী এবং লাল সুতোর সাহায্যে কাপড়ে কারুকার্য করে ও কাপড় বোনে| তারা পশম দিয়েও কাপড় বুনতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“অতএব বৎসলেল, অহলীয়াব ও অন্যান্য সব দক্ষ কারিগরদের অবশ্যই প্রভুর আদেশ অনুসারে কাজটি করতে হবে| প্রভু এদের জ্ঞান ও বুদ্ধি দিয়েছেন যাতে এরা পারদর্শিতার সঙ্গে পবিত্র স্থান তৈরীর কাজ করতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","3","তারপর মোশি বৎসলেল, অহলীয়াব এবং যেসব লোকদের প্রভু বিশেষ দক্ষতা দিয়েছিলেন তাদের ডেকে ইস্রায়েলবাসীদের আনা উপহার সামগ্রীগুলি তাদের হাতে তুলে দিল| এই সব লোকরা পবিত্র স্থান তৈরীর কাজে সাহায্য করার জন্যই এসেছিল এবং তারা এই উপহারগুলি ঈশ্বরের পবিত্র স্থান তৈরীর কাজে লাগাল| লোকরা প্রত্যেক দিন সকালেই উপহার নিয়ে আসত| ");
INSERT INTO ben2006_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","শেষকালে ঐসব কারিগররা পবিত্র স্থানের কাজ ছেড়ে মোশির কাছে এল| তারা বলল, ");
INSERT INTO ben2006_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“আমাদের তাঁবুর কাজ শেষ করার জন্য যা প্রয়োজন তার চেয়ে লোকরা অনেক বেশী জিনিস এনেছে|” ");
INSERT INTO ben2006_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","তখন মোশি শিবিরের চারদিকে খবর পাঠাল: “কোনও নারী বা পুরুষ পবিত্র স্থানের জন্য আর কোনও উপহার তৈরী করবে না|” তাই লোকদের উপহার না দিতে বাধ্য করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","তারা প্রয়োজনের চেয়ে অনেক বেশী জিনিস এনেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","তারপর দক্ষ কারিগররা পবিত্র তাঁবু তৈরী করবার কাজ আরম্ভ করল| তারা মিহি শনের কাপড়, বেগুনী, নীল ও লাল সুতো দিয়ে দশটি পর্দা তৈরী করল| তারা তার ওপর সূতো দিয়ে ঈশ্বরের বিশেষ ডানাযুক্ত করূব দূতের ছবি বসাল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","প্রত্যেকটি পর্দাই ছিল সমান মাপের–28 হাত লম্বা এবং 4 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","তারপর কারিগররা সেই পর্দাগুলি জুড়ে দুভাগে ভাগ করল| পাঁচটি করে পর্দা নিয়ে একেকটি ভাগ হলো| ");
INSERT INTO ben2006_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","তারা নীল কাপড় দিয়ে প্রত্যেক ভাগের পর্দার কিনারায় একটি ফাঁস তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","প্রতিটি ভাগের পর্দার ধারে 50টি করে ফাঁস দিল| ফাঁসগুলি ছিল একে অপরের বিপরীতে| ");
INSERT INTO ben2006_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","তারা দুটি পর্দাকে জোড়া দেবার জন্য 50টি সোনার আংটা তৈরী করল| এইভাবে পবিত্র তাঁবুটিকে একসঙ্গে একটি খণ্ডে যুক্ত করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","তারপর কারিগররা সেই পবিত্র তাঁবুর আচ্ছাদনের জন্য আরেকটি তাঁবু তৈরী করল| তারা ছাগলের লোম দিয়ে এগারোটি পর্দা বানাল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","সবগুলি পর্দাই ছিল সমান মাপের – 30 হাত লম্বা এবং 4 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","তারপর পাঁচটি পর্দা জুড়ে একটি ও ছয়টি পর্দা জুড়ে আরেকটি ভাগ করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","দুই ভাগের পর্দার মাঝেই 50টি করে ফাঁস লাগানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","দুই ভাগের পর্দাগুলি জুড়ে একটি তাঁবু বানানোর জন্য তারা 50টি পিতলের আংটা তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","তারপর তারা পবিত্র তাঁবুর জন্য আরো দুটি আচ্ছাদন তৈরী করল| একটি বানানো হলো লাল রঙ করা ভেড়ার চামড়া দিয়ে আর অন্যটি বানানো হল মসৃণ চামড়া দিয়ে| ");
INSERT INTO ben2006_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","তারপর কারিগররা পবিত্র তাঁবুকে দাঁড় করানোর জন্য বাবলা কাঠের কাঠামো বানালো| ");
INSERT INTO ben2006_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","প্রতিটি কাঠামো ছিল 10 হাত লম্বা ও 1.5 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","প্রতিটি কাঠামো পাশাপাশি দুটি তক্তা জোড়া দিয়ে তৈরী হয়েছিল| প্রতিটি কাঠামো ছিল একইরকম| ");
INSERT INTO ben2006_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","এইভাবে তারা পবিত্র তাঁবুর কাঠামোগুলো তৈরী করল| তারা পবিত্র তাঁবুর দক্ষিণ দিকের জন্য 20টি কাঠামো তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","তারপর ঐ কাঠামোর জন্য 40টি রূপোর পায়া তৈরী করল| প্রত্যেকটি কাঠামোতে দুটি করে পায়া ছিল| প্রতিটি তক্তার ধারে একটি করে পায়া| ");
INSERT INTO ben2006_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","তাঁবুর উত্তর দিকের জন্যও তারা 20টি কাঠামো তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","তারা 40টি রূপোর ভিত্তি তৈরী করল, প্রত্যেক কাঠামোর জন্য দুটি করে ভিত্তি| ");
INSERT INTO ben2006_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","তাঁবুর পিছনে পশ্চিম দিকের জন্য তারা আরো দুটি কাঠামো তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","পবিত্র তাঁবুর পিছনে কোনার দিকের জন্যও তারা দুটি কাঠামো তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","এই কাঠামোগুলিকে একত্র করে নীচের দিকে জোড়া দেওয়া হল এবং ওপর দিকে একটা আংটা দিয়ে দুদিকের কোনার কাঠামোগুলি জোড়া হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","পবিত্র তাঁবুর পশ্চিম দিকের জন্য মোট আটটি কাঠামো ছিল| সেখানে 16টি রূপোর পায়াও ছিল যা প্রতিটি কাঠামোতে দুটি করে লাগানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","তারপর কারিগররা বাবলা কাঠ দিয়ে কাঠামোর আগল তৈরী করল| তাঁবুর প্রথম পাশে পাঁচটি আগল, ");
INSERT INTO ben2006_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","অন্য দিকে পাঁচটি আগল লাগালো এবং পেছনদিকে অর্থাৎ‌ পশ্চিম দিকে পাঁচটি আগল লাগালো| ");
INSERT INTO ben2006_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","মাঝের আগলটিকে রাখা হল কাঠামোর একপ্রান্ত থেকে আরেক প্রান্ত জুড়ে| ");
INSERT INTO ben2006_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","কাঠামোগুলিকে সোনায় মুড়ে দেওয়া হল| তারপর তারা সোনার আংটা তৈরী করল আগলগুলি ধরে রাখার জন্য এবং আগলগুলি সোনা দিয়ে মুড়ে দেওয়া হল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","তারা মিহি শনের কাপড় দিয়ে পর্দাসমূহ তৈরী করল এবং তারা বিশেষ পর্দাটি তৈরী করবার জন্য নীল, বেগুনী ও লাল সূতো তৈরী করল| তারা সেগুলোর ওপর করূব দূতদের চেহারা সেলাই করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","চারটি বাবলা কাঠের খুঁটি বানিয়ে সোনা দিয়ে মুড়ে দেওয়া হল| তারা খুঁটির জন্য সোনার আংটা তৈরী করল এবং চারটি করে রূপোর পায়া তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","তারপর তারা তাঁবুতে ঢোকার জন্য মিহি শনের কাপড় এবং নীল, বেগুনী ও লাল সুতা ব্যবহার করে দরজার পর্দা তৈরী করল। এর ওপর তারা সুতার কাজও করল| ");
INSERT INTO ben2006_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","তারপর তারা এই ঢোকার দরজার পর্দার জন্য পাঁচটি খুঁটি ও আংটা তৈরী করল| তারপর এই খুঁটির ও পর্দার আংটার মাথাগুলি সোনা দিয়ে মুড়ে দেওয়া হল| তারপর খুঁটির জন্য পাঁচটি করে পিতলের পায়া প্রস্তুত করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","বৎসলেল বাবলা কাঠ দিয়ে পবিত্র সিন্দুক তৈরী করল| সিন্দুকটি 2.5 হাত লম্বা, 1.5 হাত চওড়া আর 1.5 হাত উঁচু| ");
INSERT INTO ben2006_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","তারপর সে সিন্দুকের ভেতর ও বাইরের দিক খাঁটি সোনা দিয়ে মুড়ে দিল| সে সিন্দুকের চারিদিকে সোনার জরি দিয়েও ঘিরে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","এরপর সে চারটি সোনার আংটা চারকোণায় রাখল সিন্দুকটি বয়ে নিয়ে যাওয়ার জন্য| এর একদিকে দুটি আংটা লাগানো ছিল এবং দুটি আংটা লাগানো ছিল এর অন্য দিকে| ");
INSERT INTO ben2006_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","সিন্দুকটি বয়ে নিয়ে যাওয়ার জন্য বাবলা কাঠের খুঁটি তৈরী করে সে সেগুলি খাঁটি সোনায় মুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","তারপর সে পবিত্র সিন্দুকের প্রতিটি ধারে আংটাগুলির ভেতর দিয়ে খুঁটিগুলি ঢুকিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","তারপর সে খাঁটি সোনা দিয়ে আচ্ছাদনটি তৈরী করল| এটা ছিল 2.5 হাত লম্বা ও 1.5 হাত চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","তারপর সে পেটানো সোনা দিয়ে দুটি করূব দূত তৈরী করল এবং সেগুলো আচ্ছাদনের দুধারে রেখে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","তারপর সে করূব দূতের মূর্ত্তি দুটি পাপমোচন স্থানের আচ্ছাদনের সঙ্গে জুড়ে একত্র করল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","দূতরা ডানা আকাশে ছড়িয়ে পবিত্র সিন্দুকটিকে ঢেকে দিল| দূতরা পরস্পর মুখোমুখি হয়ে পাপমোচন স্থানের দিকে তাকিয়ে রইল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","বৎসলেল বাবলা কাঠ দিয়ে একটি 2 হাত লম্বা, 1 হাত চওড়া ও 1.5 হাত উঁচু টেবিল বানাল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","টেবিলের চারধার খাঁটি সোনার পাত দিয়ে সে মুড়ে দিল| এবং তার চারধারে একটি সোনার ঝালর লাগিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","তারপর সে একটি 1 হাত চওড়া কাঠামো তৈরী করল টেবিলের সব ধার ঘিরে এবং কাঠামোর চারপাশে সোনার ঝালর লাগালো| ");
INSERT INTO ben2006_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","তারপর সে টেবিলের চারকোণায় চারপায়ায় চারটি সোনার আংটা লাগাল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","সে টেবিলটাকে বইবার জন্য আংটাগুলো কাঠামোর খুব কাছে আটকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","তারপর সে টেবিলটি বয়ে নিয়ে যাওয়ার জন্য বাবলা কাঠের খুঁটি তৈরী করল| খাঁটি সোনা দিয়ে খুঁটিগুলিও মুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","এরপর সে টেবিলে ব্যবহারের জন্য সোনার প্লেট, চামচ, বাটি ও কলসী বানাল| পেয় নৈবেদ্য ঢালার জন্য বাটি ও কলসী তৈরী করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","তারপর সে সোনার বাতিদানটি তৈরী করল| সে খাঁটি সোনা হাতুড়ি দিয়ে পেটালো এবং তৈরী করল বাতিদানের বিস্তৃত পাদানী| সে ফুল, পাতা, কুঁড়ি দিয়ে কারুকার্য করে সবকিছু একত্রে জুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","বাতিদানের ছয়টি শাখা - একদিকে তিনটি অপরদিকে আরও তিনটি| ");
INSERT INTO ben2006_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","প্রতিটি ডালে থাকল তিনটি করে ফুল| সেগুলি কাঠ বাদামের ফুলের মতো তাতে কুঁড়ি ও পাতা রাখা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","বাতিদানের দণ্ডে আরও চারটি ফুল রাখা হল কুঁড়ি ও পাপড়ি সমেত যা দেখতে বাদাম ফুলের মতো| ");
INSERT INTO ben2006_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","তাতে একেক দিকে তিনটি করে মোট ছয়টি ডালও রাখা হল| প্রতি জোড়া ডালগুলির নীচে যেগুলি বিস্তৃত পাদানীর সঙ্গে যুক্ত ছিল, সেখানে কুঁড়ি ও পাপড়িসহ একটি ফুল ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","পুরো বাতিদানটি খাঁটি সোনায় ফুলপাতাসহ একসাথে জোড়া দিয়ে তৈরী করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","এই বাতিদানের জন্য সাতটি প্রদীপ তৈরী করা হল| তারপর সে খাঁটি সোনা দিয়ে সলতের চিমটা ও শীষদানী পাত্র তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","সে মোট 75 পাউণ্ড খাঁটি সোনা ব্যবহার করে এই বাতিদান ও তার আনুষঙ্গিক জিনিসপত্র তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","এরপর ধূপ-ধূনা পোড়াবার জন্য সে বাবলা কাঠ দিয়ে একটি ধূপদানী তৈরী করল| এটা ছিল 1 হাত লম্বা, 1 হাত চওড়া এবং 2 হাত উচ্চতা বিশিষ্ট একটি চৌকোনা জিনিস| ধূপদানের চারকোণের প্রতিটিতে একটি করে শৃঙ্গ ছিল| এই শৃঙ্গগুলি ও ধূপবেদী একটি অখণ্ড টুকরো ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","সে ধূপদানের ওপর চারপাশ এবং শৃঙ্গগুলি খাঁটি সোনা দিয়ে মুড়ে দিল| তারপর ধূপদানের চারপাশ সোনার জরি দিয়ে মুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","এই জরির নীচে দুধারে আংটা লাগানো হল| এই আংটা লাগানো হল বয়ে নিয়ে যাওয়ার খুঁটি ধরে রাখার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","সে এই খুঁটিগুলি বাবলা কাঠ দিয়ে তৈরী করে সোনা দিয়ে মুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","তারপর সে একজন সুগন্ধি প্রস্তুতকারক যেমন করে সুগন্ধ তৈরী করে সেইভাবে পবিত্র অভিষেকের তেল এবং খাঁটি ও সুগন্ধি ধূপ-ধূনা তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","তারপর বৎসলেল বাবলা কাঠ দিয়ে হোমবলির বেদী তৈরী করলেন| এটা ছিল 5 হাত লম্বা, 5 হাত চওড়া ও 3 হাত উচ্চতা বিশিষ্ট চৌকোনা আকারের| ");
INSERT INTO ben2006_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","তারপর সে বেদীর প্রত্যেকটি কোণের জন্য একটি করে শৃঙ্গ বানালো এবং তাদের কোণায় জুড়ে দিল যাতে তা অখণ্ড হয় এবং বেদীটি পিতল দিয়ে ঢেকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","সে বেদীতে ব্যবহারের সব সরঞ্জাম পিতল দিয়ে তৈরী করল| সে পাত্র, বেলচা, বাটি, কাঁটা চামচ, চাটু ইত্যাদি তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","তারপর সে পিতল দিয়ে জালের মতো একটি ঝাঁঝরি তৈরী করল| বেদীর বেড়ের নীচে থেকে মাঝখান পর্যন্ত এই ঝাঁঝরি বসানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","তারপর সে বেদীটি বয়ে নিয়ে যাওয়ার খুঁটি লাগাবার জন্য ঝাঁঝরির চারকোণায় চারটি আংটা লাগাল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","তারপর সে বাবলা কাঠ দিয়ে খুঁটি তৈরী করে পিতল দিয়ে মুড়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","বেদীটি বয়ে নিয়ে যাওয়ার জন্য খুঁটিগুলো আংটার ভিতরে ঢুকিয়ে দেওয়া হল| বেদীর ধারগুলো তৈরী করা হল তক্তা দিয়ে| এটা ছিল একটা খালি সিন্দুকের মতো ফাঁপা| ");
INSERT INTO ben2006_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","তারপর সে পিতল দিয়ে পাত্র এবং পাত্রের পায়া তৈরী করল| এটা মহিলাদের দেওয়া পিতলের আয়না থেকে নেওয়া হয়েছিল| এই মহিলারা সমাগম তাঁবুর প্রবেশ দরজায় সেবা করার জন্য এসেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","তারপর সে প্রাঙ্গণের চারিদিকে পর্দার একটি দেওয়াল তৈরী করল| দক্ষিণ দিকে সে 100 হাত লম্বা পর্দার একটি দেওয়াল তৈরী করল| এই পর্দাগুলো ছিল মিহি শনের কাপড় দিয়ে তৈরী| ");
INSERT INTO ben2006_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","কুড়িটি খুঁটির সাহায্যে এই পর্দাগুলিতে অবলম্বন দেওয়া ছিল| খুঁটিগুলো ছিল 20টি পিতলের ভিত্তির উপর| খুঁটির আংটা ও পর্দার বন্ধনী ছিল রূপোর তৈরী| ");
INSERT INTO ben2006_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","উত্তর দিকের প্রাঙ্গণেও ছিল 100 হাত লম্বা পর্দার একটি দেওয়াল| সেখানে 20টি পিতলের ভিত্তির ওপর 20টি খুঁটি ছিল| খুঁটির আংটা ও পর্দার বন্ধনী ছিল রূপোর| ");
INSERT INTO ben2006_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","পশ্চিমদিকের প্রাঙ্গণে থাকল 50 হাত লম্বা পর্দার দেওয়াল| আর থাকল 10টি খুঁটি ও 10টি ভিত্তি| খুঁটির আংটা ও পর্দার বন্ধনী তৈরী করা হল রূপো দিয়ে| ");
INSERT INTO ben2006_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","প্রাঙ্গণের পূর্ব দিকে 50 হাত চওড়া| প্রাঙ্গণে প্রবেশের দরজা রাখা হল এই দিকেই| ");
INSERT INTO ben2006_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","প্রবেশ দরজার দিকের পর্দা ছিল 15 হাত লম্বা| এইদিকে তিনটি খুঁটি ও তিনটি ভিত্তি ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","অন্যদিকের প্রবেশ দরজাও ছিল 15 হাত লম্বা| ঐদিকে তিনটি খুঁটি ও তিনটি পায়া ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","প্রাঙ্গণের চারিদিকের সব পর্দাই ছিল মিহি শনের কাপড়ের তৈরী| ");
INSERT INTO ben2006_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","খুঁটির ভিত্তিগুলো ছিল পিতলের তৈরী| দণ্ডগুলির আংটা ও পর্দার বন্ধনী ছিল রূপো দিয়ে তৈরী| খুঁটির মাথাগুলো ছিল রূপো দিয়ে মোড়া| প্রাঙ্গণের সব খুঁটিতেই ছিল রূপোর পর্দাবন্ধনী| ");
INSERT INTO ben2006_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","প্রাঙ্গণের প্রবেশ দরজার পর্দা তৈরী করা হল মিহি শনের কাপড় দিয়ে| এবং নীল, বেগুনী ও লাল সুতো দিয়ে| পর্দার ওপর সুতোর কারুকার্যও করা হল| পর্দাটি ছিল 20 হাত লম্বা এবং 5 হাত উঁচু| এগুলো প্রাঙ্গণের চারিদিকের পর্দার সমান উঁচু| ");
INSERT INTO ben2006_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","পর্দা ঠেকা দেওয়া হল চারটি খুঁটি ও চারটি পিতলের পায়া দিয়ে| খুঁটির আংটা তৈরী করা হল রূপো দিয়ে| খুঁটির ওপরের দিক আর পর্দার বন্ধনী রূপোর| ");
INSERT INTO ben2006_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","পবিত্র তাঁবুর সমস্ত কীলকগুলো এবং প্রাঙ্গণের চারিদিকের পর্দাগুলো ছিল পিতলের তৈরী| ");
INSERT INTO ben2006_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","মোশি লেবীয়দের আদেশ দিল পবিত্র তাঁবু বা সাক্ষ্যের তাঁবু তৈরীর কাজে যা কিছু ব্যবহার করা হয়েছে তা একটি তালিকায় লিখে রাখতে| এই তালিকার দায়িত্ব দেওয়া হল যাজক হারোণের পুত্র ঈথামরকে| ");
INSERT INTO ben2006_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","যিহূদা বংশীয় হূরের পৌত্র ও উরির পুত্র বৎসলেল মোশিকে দেওয়া প্রভুর আদেশ অনুসারে সব কিছু তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","দান বংশীয় অহীষামকের পুত্র অহলীয়াব তাকে এই কাজে সাহায্য করল| সে একজন দক্ষ কারিগর ও কারুশিল্পী| সে মিহি শনের কাপড়, নীল, বেগুনী ও লাল সুতো বোনায পারদর্শী ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","এই পবিত্র স্থান নির্মাণের জন্য 2 টনেরও বেশী সোনা দেওয়া হয়েছিল| এটা ছিল সরকারি হিসাব অনুযায়ীওজন| ");
INSERT INTO ben2006_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","যতজন লোককে গোনা হয়েছিল তারা সবাই আমলাতান্ত্রিক পরিমাণ অনুসারে 3.75 টন রূপো দিয়েছিল| কুড়ি বছর বা তার বেশী বয়সের লোকদের গোনা হয়েছিল| মোট 603,550 জন পুরুষ ছিল এবং প্রত্যেককে আমলাতান্ত্রিক পরিমাপ অনুসারে 1.5 আউন্স রূপো কর হিসেবে দিতে হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","তারা 3.75 টন রূপো ব্যবহার করে প্রভুর পবিত্র স্থান এবং পর্দার জন্য 100টি ভিত্তি তৈরী করেছিল| তারা পবিত্র স্থানের ভিত্তির জন্য এবং পর্দার পায়ার জন্য 3.75 টন রূপো ব্যবহার করেছিল| মোট 100টি ভিত্তি করা হয়েছিল| তারা প্রতিটি ভিত্তির জন্য 75 পাউণ্ড রূপো ব্যবহার করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","বাকি 50 পাউণ্ড রূপো দিয়ে আংটা পর্দার বন্ধনী তৈরী করেছিল এবং খুঁটির মাথা মুড়ে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","প্রভুকে 26.5 টনেরও বেশী পিতল নৈবেদ্য দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ঐ পিতল দিয়ে সমাগম তাঁবুর প্রবেশ দরজার পায়া তৈরী করা হয়েছিল| পিতল দিয়ে, বেদী ও ঝাঁঝরি তৈরী হয়েছিল| বেদীতে প্রয়োজনীয় সমস্ত জিনিসপত্র পিতল দিয়ে তৈরী করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","প্রাঙ্গণের চারিদিকের পর্দা ও প্রবেশ দরজার পর্দার পায়াও পিতল দিয়ে বানানো হয়েছিল| পবিত্র তাঁবুর খুঁটি এবং প্রাঙ্গণের চারদিকের পর্দার জন্য পিতল ব্যবহার করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","যাজকরা যখন প্রভুর পবিত্র স্থানে সেবা করবে তখন তারা যে বিশেষ পোশাক পরবে, সেটা কারিগররা নীল, বেগুনী ও লাল সুতো দিয়ে তৈরী করল| তারা মোশিকে দেওয়া প্রভুর আদেশ অনুযায়ী হারোণের জন্য বিশেষ পোশাক তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","তারা মিহি শনের কাপড়, সোনার জরি, নীল, বেগুনী ও লাল সুতো দিয়ে এফোদ তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","তারা সোনা পিটিয়ে সরু পাত তৈরী করে তারপর তা থেকে সোনার জরি বানাল| তারপর তারা সেই সোনার জরি নীল, বেগুনী, লাল সুতো ও শনের কাপড়ের সাথে একসাথে বুনল| এটা খুবই দক্ষ কারিগরের কাজ| ");
INSERT INTO ben2006_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","তারা এফোদের জন্য কাঁধের কাপড় বানাল যেটা এফোদের দুই কোনে বেঁধে দেওয়া হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","তারা কোমরবন্ধনী বুনে এফোদের সাথে জুড়ে দিল| মোশিকে দেওয়া প্রভুর আদেশ অনুযায়ীএটাও এফোদের মতই মিহি শনের কাপড় নীল, বেগুনী ও লাল সুতো এবং সোনার জরি দিয়ে বোনা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","কারিগররা এফোদের জন্য সোনার ওপর গোমেদ বসালো| তারা ঐ পাথরগুলোর ওপর ইস্রায়েলের পুত্রদের নাম খোদাই করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","তারপর তারা এই মণিগুলো এফোদের ওপর বসিয়ে দিল| এই অলংকারগুলি ইস্রায়েলের লোকদের জন্য একটি স্মারক হয়ে থাকবে| এসবই করা হয়েছিল মোশিকে দেওয়া প্রভুর আদেশ অনুসারে| ");
INSERT INTO ben2006_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","তারপর তারা বক্ষাবরণ তৈরী করল| ঠিক এফোদের মতোই এটাও ছিল একজন দক্ষ কারিগরের কাজ| এটা তৈরী করা হল সোনার জরি, মিহি শনের কাপড় এবং নীল, বেগুনী ও লাল কাপড় দিয়ে| ");
INSERT INTO ben2006_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","বক্ষাবরণটিকে অর্ধেক করে ভাঁজ করে চারকোণা একটি পকেটের আকার দেওয়া হল| এটা ছিল 9 ইঞ্চি লম্বা আর 9 ইঞ্চি চওড়া| ");
INSERT INTO ben2006_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","তারপর কারিগররা বক্ষাবরণটির ওপর চার সারি মণিমাণিক্য বসালো| প্রথম সারিতে ছিল চূনী, পীতমণি ও মরকত| ");
INSERT INTO ben2006_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দ্বিতীয় সারিতে ছিল পদ্মরাগ, নীলকান্ত ও পান্না, ");
INSERT INTO ben2006_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তৃতীয় সারিতে ছিল পোখরাজ, যিস্ম ও কটাহেলা| ");
INSERT INTO ben2006_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","চতুর্থ সারিতে ছিল বৈদুর্য্য, গোমেদ ও সূর্যকান্তমণি| এইসব মণি সোনার ওপর বসানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","বক্ষাবরণটির ওপর মোট বারোটি মণি ছিল| ইস্রায়েলের প্রত্যেক পুত্রের জন্য ছিল একটি করে মণি| প্রত্যেক অলঙ্কারের ওপর শীলমোহরের মতো ইস্রায়েলের বারোটি পরিবারগোষ্টীর একটি করে নাম খোদাই করা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","কারিগররা বক্ষাবরণের জন্য খাঁটি সোনার শেকলসমূহ বানালো| এই শেকলগুলি দড়ির মত পাকানো ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","কারিগররা দুটি সোনার আংটা বানিয়ে বক্ষাবরণের দুই কোণে আটকে দিল| তার কাঁধের জন্য দুটি সোনার স্থালীও তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","তারা সোনার চেন দুটিকে বক্ষাবরণের কোণের আংটার সাথে বেঁধে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","তারা আরো দুটি সোনার আংটা বানিয়ে বক্ষাবরণের অপর দুটি কোণে আটকে দিল| এটা ছিল বক্ষাবরণের ভিতরের দিকে এফোদের ঠিক পরেই| তারা সোনার শেকলের অপর প্রান্তগুলি সামনের দিক দিয়ে এফোদের কাঁধের পট্টির সোনার অলঙ্কারের সঙ্গে যুক্ত করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","তারপর তারা আরো দুটি সোনার আংটা তৈরী করল এবং সেগুলি এফোদের পাশে বক্ষাবরণের ভেতরদিকের ধারে আটকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","তারা আরো দুটি সোনার আংটা বসাল কাঁধের পট্টির নীচে এফোদের সামনে| এই আংটাগুলি ছিল বন্ধনীর কাছে, কোমরবন্ধনীর ওপর| ");
INSERT INTO ben2006_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","তারপর তারা একটি নীল ফিতের সাহায্যে বক্ষাবরণীর আংটার সাথে এফোদের আংটা বেঁধে দিল| এইভাবে প্রভুর আদেশ অনুযায়ীবক্ষাবরণটি এফোদের সাথে শক্তভাবে বাঁধা থাকল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","তারপর তারা এফোদের জন্য সম্পূর্ণরূপে নীল কাপড় দিয়ে একটি পোশাক বুনল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","তারা আলখাল্লার মাঝখানে একটি ফুটো করল এবং এই ফুটোর চারধার দিয়ে এক টুকরো কাপড় সেলাই করে দিল, ফুটোটি যাতে না ছেঁড়ে তার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","তারপর তারা মিহি শনের কাপড় এবং নীল, বেগুনী ও লাল সুতো দিয়ে বেদানা তৈরী করল| এই বেদানাগুলি তারা আলখাল্লার নীচের ধারে ঝুলিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","তারা খাঁটি সোনার ঘন্টা তৈরী করল এবং সেগুলি আলখাল্লার নীচের ধারে বেদানার মাঝে মাঝে লাগিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","আলখাল্লার নীচের ধারে প্রত্যেকটি বেদানার মাঝখানে একটি করে ঘন্টা লাগানো হল| মোশিকে দেওয়া প্রভুর আদেশমতই প্রভুর সেবা করার সময় যাজকের পরার জন্য পোষাক তৈরী করা হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","দক্ষ কারিগররা হারোণ ও তার পুত্রদের জন্য মিহি শনের কাপড়ের জামা তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","তারা মিহি শনের কাপড় দিয়ে একটি পাগড়ি, মাথায় বাঁধার ফিতে ও ভেতরে পরার পোশাক তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","মোশিকে দেওয়া প্রভুর আদেশমতো তারা মিহি শনের কাপড় এবং নীল, বেগুনী ও লাল সুতো দিয়ে কাপড়ের ওপর সুঁচের কাজ করে বন্ধনী তৈরী করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","তারপর তারা খাঁটি সোনা থেকে সোনার পাত তৈরী করল পবিত্র মুকুটের জন্য| তারা সোনার ওপর এই কথাগুলি খোদাই করল; পবিত্র প্রভুর কাছে| ");
INSERT INTO ben2006_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","তারপর তারা এই সোনার পাতটিকে একটি নীল ফিতের সঙ্গে বেঁধে দিল| তারা মোশিকে দেওয়া প্রভুর আদেশ অনুসারে নীল ফিতেটিকে পাগড়ির সঙ্গে জড়িয়ে বেঁধে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","অবশেষে পবিত্র তাঁবু বা সমাগম তাঁবুর কাজ শেষ হল| মোশিকে প্রভু যা যা আদেশ দিয়েছিলেন ইস্রায়েলবাসী ঠিক সেইভাবেই সবকিছু করল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","তারপর তারা মোশিকে ডেকে পবিত্র তাঁবু ও তার ভেতরের সব জিনিস দেখাল| তারা মোশিকে আংটা, কাঠামো, আগল, খুঁটি এবং পায়া দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","তারা তাকে তাঁবুর লাল রঙ করা মেষের চামড়ার তৈরী আবরণ দেখাল| তারা তাকে মসৃণ চামড়ার তৈরী আবরণও দেখাল| তাকে সর্বোচ্চ পবিত্রতম স্থানের প্রবেশ দরজার পর্দাও দেখানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","মোশিকে সাক্ষ্য সিন্দুকটিও দেখানো হল| সিন্দুকটি বহন করার জন্য খুঁটি ও সিন্দুকটির আবরণও তারা দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","তারা তাকে টেবিল ও তার উপরে রাখা জিনিস এবং বিশেষ রুটিও দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","তারা তাকে খাঁটি সোনার তৈরী দীপদান ও তার দীপগুলিও দেখাল| তারা দীপের জন্য ব্যবহৃত তেল ও দীপের আনুষঙ্গিক অংশগুলিও দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","মোশিকে সোনার বেদী, অভিষেকের তেল, সুগন্ধী ধূপ-ধূনা এবং তাঁবুর প্রবেশ দরজার পর্দাও দেখানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","তারা পিতলের বেদী ও পিতলের খুরা দেখাল| তারা বেদী বহন করার খুঁটি ও বেদীতে ব্যবহার্য্য্য সব জিনিস দেখাল| পাত্র এবং পাত্রের পায়াও দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","তারা মোশিকে প্রাঙ্গণের চারিদিকের পর্দা, তার খুঁটি এবং পায়াও দেখাল| প্রাঙ্গণের প্রবেশ দরজার পর্দা, দড়ি, তাঁবুর খুঁটি এবং পবিত্র তাঁবু বা সমাগম তাঁবুর সমস্ত কিছুই মোশিকে দেখানো হল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","তারা পবিত্র স্থানে সেবার জন্য যাজকদের পোশাক, হারোণ এবং তার পুত্রদের জন্য তৈরী বিশেষ পোশাক মোশিকে দেখাল| এই পোশাক হারোণের পুত্ররা যাজকের কাজ করার সময় পরবে| ");
INSERT INTO ben2006_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ইস্রায়েলবাসীরা মোশিকে দেওয়া প্রভুর আদেশ মতোই সমস্ত কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","মোশি সবকিছু ভাল করে পর্যবেক্ষণ করে দেখল যে সবকিছুই হুবহু প্রভুর আদেশ মতোই হয়েছে| তাই মোশি তাদের আশীর্বাদ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“প্রথম মাসের প্রথম দিনে তোমরা পবিত্র তাঁবু অর্থাৎ‌ সমাগম তাঁবু স্থাপন করবে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","সাক্ষ্য সিন্দুকটি পবিত্র তাঁবুতে রাখো এবং আবরণ দিয়ে ঢেকে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","টেবিলটি নিয়ে এসো এবং ওপরে যে সব জিনিস থাকার কথা সেগুলি রাখো| তারপর দীপদানটি তাঁবুতে নিয়ে এসে দীপগুলি ঠিক জায়গা মতো রাখো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","এরপর তাঁবুতে নৈবেদ্য দেওয়ার জন্য সোনার বেদীটি নিয়ে এসো| সাক্ষ্য সিন্দুকটির সামনে বেদীটি রাখো| পবিত্র তাঁবুর প্রবেশ দরজায় পর্দা টাঙিযে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“হোমবলি দেওয়ার জন্য বেদীটি পবিত্র তাঁবুর প্রবেশ দরজার সামনে রাখো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","হাতমুখ ধোওযার জন্য পাত্রটিতে জল রেখে সেটি সমাগম তাঁবু ও বেদীর মাঝখানে রাখো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","প্রাঙ্গণের চারিদিকে পর্দার দেওয়াল টাঙিযে দাও| তারপর প্রাঙ্গণের প্রবেশ দরজায় পর্দা লাগিয়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“অভিষেক তেল ব্যবহার করে পবিত্র তাঁবু ও তার ভেতরের সবকিছুর অভিষেক করো| তুমি যখন ঐসব জিনিসের ওপর তেল ছেটাবে তখন সবকিছু পবিত্র হয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","হোমবলির জন্য বেদীটি অভিষেক করো এবং অভিষেকের তেল দিয়ে বেদীর সমস্ত জিনিস অভিষিক্ত করো| এতে বেদীটি খুব পবিত্র হয়ে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","পাত্র ও পাত্র দানকে পবিত্র করবার জন্য তাদের অভিষেক করো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“হারোণ ও তার পুত্রদের সমাগম তাঁবুর প্রবেশ দরজায় নিয়ে এসো| তাদের জল দিয়ে স্নান করাও| ");
INSERT INTO ben2006_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","তারপর হারোণকে বিশেষ পোশাক পরাও| তাকে তেল দিয়ে অভিষেক করে পবিত্র করো| তাহলে সে যাজকরূপে আমার সেবা করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","তার পুত্রদের পোশাক পরাও| ");
INSERT INTO ben2006_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","তার পুত্রদের ঠিক সেভাবে অভিষেক করাও যেভাবে তাদের পিতাকে করেছ| তাহলে তারাও যাজক হিসেবে আমার সেবা করতে পারবে| যখন তুমি তাদের অভিষেক করবে তখন তারা যাজক হয়ে যাবে| এবং এই পরিবার আগামী দিনেও চিরকালের মত যাজকের কাজ করবে|” ");
INSERT INTO ben2006_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","মোশি প্রভুর আদেশ মেনে তাঁর নির্দেশ মতো সবকিছু করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","তাই ঠিক সময়ে পবিত্র তাঁবু স্থাপন করা হল| তারা মিশর ছেড়ে যাবার দ্বিতীয় বছরের প্রথম মাসের প্রথম দিন তাঁবু স্থাপন করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","মোশি তাঁবুর ভিত্তিগুলো জায়গামত স্থাপন করল| তারপর সে ভিত্তিগুলোর ওপর কাঠামোটি বসাল এবং আগল দিয়ে খুঁটিগুলো বসাল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","তারপর মোশি পবিত্র তাঁবুর ওপর বাইরের তাঁবু বসাল| এবং তার ওপর আচ্ছাদন দিল| সে সব কিছুই প্রভুর আদেশ মতো করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","মোশি চুক্তিপত্র নিয়ে পবিত্র সিন্দুকে রাখল| খুঁটিগুলো সিন্দুকের ওপর রেখে সেটিকে আবরণ দিয়ে ঢেকে দিল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","তারপর মোশি পবিত্র সিন্দুকটি পবিত্র তাঁবুতে রাখল| সিন্দুকটির সুরক্ষার জন্য সে ঠিক জায়গায় পর্দা টাঙ্গালো এবং এভাবেই সে প্রভুর আদেশ মতো সাক্ষ্য সিন্দুকটির সুরক্ষার ব্যবস্থা করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","তারপর সে পবিত্র তাঁবুর উত্তরদিকে পবিত্র স্থানের পর্দার সামনে টেবিলটি রাখলো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","প্রভুর আদেশ অনুসারে মোশি প্রভুর সামনে টেবিলের ওপর রুটি রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","তারপর সে তাঁবুটির দক্ষিণ দিকে টেবিলের বিপরীত দিকে দীপদানটি রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","প্রভু যেমনটি আদেশ করেছিলেন সেই মতো মোশি দীপগুলি স্থাপন করল এবং সেগুলো প্রভুর সামনে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","এরপর মোশি সমাগম তাঁবুর পর্দার সামনে সোনার বেদীটি রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","প্রভুর আদেশ মতো মোশি তার ভেতরে সুগন্ধি ধূপ-ধূনো পোড়ালো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","তারপর মোশি পবিত্র তাঁবুর প্রবেশ দরজায় পর্দা টাঙালো| ");
INSERT INTO ben2006_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","মোশি হোমবলির বেদীটি সমাগম তাঁবুর প্রবেশ দরজার সামনে রাখল| তারপর মোশি সেই বেদীতে একটি হোমবলি দিল| সে প্রভুকে শস্য নৈবেদ্যও দিল| সে সবকিছুই প্রভুর আদেশ মতো করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","মোশি এরপর সমাগম তাঁবু ও বেদীর মাঝখানে হাত মুখ ধোওযার জন্য জল ভর্ত্তি পাত্রটি রাখল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","হাত ও পা ধোয়ার জন্য মোশি, হারোণ ও তার পুত্ররা এই পাত্রের জল ব্যবহার করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","তারা প্রত্যেকবার তাঁবুতে ঢোকার সময় এবং বেদীর কাছে যাওয়ার সময় তাদের হাত পা ধুয়ে নিল| এসব কিছুই করা হল প্রভুর আদেশ অনুসারে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","তারপর মোশি পবিত্র তাঁবুর প্রাঙ্গণের চারিদিকে পর্দা দিয়ে দিল| সে বেদীটি প্রাঙ্গণে রেখে প্রাঙ্গণের প্রবেশ দরজায় পর্দা লাগাল| এইভাবেই মোশি তার সব কাজ শেষ করল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","এরপরই মেঘ এসে পবিত্র সমাগম তাঁবু ঢেকে ফেলল| এবং প্রভুর মহিমায় পবিত্র তাঁবু পরিপূর্ণ হল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","মোশি সমাগম তাঁবুতে ঢুকতে পারল না| কারণ তা মেঘে ঢেকে ছিল এবং প্রভুর মহিমায় ছিল পরিপূর্ণ| ");
INSERT INTO ben2006_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","এই মেঘই ইস্রায়েলের লোকদের দেখিয়ে দিয়েছিল যে কখন যাত্রা শুরু করতে হবে| যখন পবিত্র তাঁবুর ওপর থেকে মেঘ সরে যাবে তখনই ইস্রায়েলের লোকরা যাত্রা শুরু করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","সুতরাং যখন মেঘ পবিত্র তাঁবুর ওপর ছিল তখন লোকরা তাদের যাত্রা শুরু করার চেষ্টা করেনি| যতক্ষণ না মেঘ ওপরে উঠেছিল ততক্ষণ তারা সেখানেই ছিল| ");
INSERT INTO ben2006_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","তাই প্রভুর মেঘ দিনের বেলায় ছিল সমাগম তাঁবুর ওপরে এবং রাতে আগুন ছিল মেঘের ভেতরে| তাই ইস্রায়েলের সমগ্র পরিবার তাদের পুরো যাত্রাপথে মেঘটি দেখতে পাচ্ছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","প্রভু ঈশ্বর মোশিকে ডাকলেন এবং সমাগম তাঁবু থেকে তার সঙ্গে কথা বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ইস্রায়েলের লোকদের বল: যখন প্রভুর কাছে তোমরা কোন নৈবেদ্য নিয়ে আসবে, সেই নৈবেদ্য যেন তোমাদেরই কোন একটি গৃহপালিত প্রাণী হয়, তা একটি গরু, মেষ বা ছাগলও হতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“যখন কোন ব্যক্তি তার গো-পাল থেকে হোমবলি দেয়, তখন সেটা যেন ষাঁড় হয়, যার মধ্যে কোন দোষ নেই| সমাগম তাঁবুতে ঢোকার মুখে সে প্রাণীটিকে আনবে| তারপর প্রভু সেই নৈবেদ্য গ্রহণ করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","প্রাণীটিকে হত্যা করার সময় সে অবশ্যই প্রাণীটির মাথায় তার হাত রাখবে| প্রভু সেই ব্যক্তিকে পাপ থেকে মুক্ত করার জন্যই প্রায়শ্চিত্তরূপে হোমবলি গ্রহণ করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“প্রভুর সামনেই সে সেই এঁড়ে বাছুরটিকে হনন করবে| তারপর হারোণের পুত্ররা অর্থাৎ‌ যাজকরা সমাগম তাঁবুতে ঢোকার মুখে অবস্থিত বেদীর কাছে অবশ্যই সেই রক্ত আনবে এবং বেদীর ওপরে এবং চারপাশে তা ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","যাজকরা অবশ্যই প্রাণীটির দেহ থেকে চামড়া ছাড়াবে এবং তারপর প্রাণীটিকে কেটে টুকরো টুকরো করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","হারোণের পুত্ররা অর্থাৎ‌ যাজকরা অবশ্যই বেদীতে আগুন জ্বালবে এবং তারপর আগুনের ওপর কাঠ চাপাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","তারপর তারা বেদীর ওপরের আগুনে জড়ো করা কাঠের ওপর অবশ্যই টুকরোগুলো (মাথা আর চর্বিযুক্ত মাংস) রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","যাজকরা জল দিয়ে অবশ্যই জন্তুটির পাগুলি আর দেহের ভিতরের অংশগুলি ধুয়ে নেবে| তারপর তারা বেদীর ওপরকার জন্তুটির সমস্ত অংশ পুড়িয়ে নেবে| এ হল হোমবলি, আগুনে প্রস্তুত একটি নৈবেদ্য| এই নৈবেদ্যর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“যখন কেউ হোমবলি হিসেবে একটা মেষ বা একটা ছাগল উপহার দেয়, তখন সেই প্রাণীটিকে অবশ্যই পুরুষ প্রাণী হতে হবে, যার মধ্যে কোন দোষ বা খুঁত নেই| ");
INSERT INTO ben2006_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","প্রভুর সামনে বেদীর উত্তর দিকে সে প্রাণীটিকে হত্যা করবে| তারপর হারোণের পুত্ররা অর্থাৎ‌ যাজকরা প্রাণীটির রক্ত বেদীর ওপরে এবং চারপাশে ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","তারপর যাজকরা প্রাণীটিকে টুকরো টুকরো করে কাটবে| তারপর তারা টুকরোগুলো (মাথা ও চর্বিযুক্ত মাংস) বেদীর আগুনে রাখা কাঠের ওপর রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","যাজকরা জল দিয়ে প্রাণীটির পাগুলি আর দেহের ভিতরের অংশগুলি ধুয়ে নেবে| যাজকদের অবশ্যই পশুটির সমস্ত অংশই উৎসর্গ করতে হবে| তারা বেদীর ওপর প্রাণীটিকে পুড়িয়ে নেবে| এ হল হোমবলি, আগুনে প্রস্তুত নৈবেদ্য| এই সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“যখন কোন লোক প্রভুকে হোমবলি হিসেবে একটি পাখী উপহার দেয়, তখন সেই পাখীটি যেন একটি ঘুঘু কিংবা একটি কচি পায়রা হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","যাজক অবশ্যই নৈবেদ্যটিকে বেদীর কাছে আনবে| তারপর সে পাখীর মাথাটি টেনে ছিঁড়ে নেবে এবং বেদীর ওপর পাখীটিকে পোড়াবে| পাখীটির রক্ত বেদীর পাশে ফেলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","যাজক অবশ্যই পাখীটির গলার থলিটা টেনে নেবে, পালকগুলিও সরাবে এবং সেগুলিকে বেদীর পূর্ব দিকে ছুঁড়ে ফেলে দেবে| বেদী থেকে ছাই সরিয়ে রাখার এটাই হল জায়গা| ");
INSERT INTO ben2006_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","যাজক পাখীটির ডানার জায়গাটা ছিঁড়ে ফেলবে কিন্তু পাখীটিকে দুভাগ করবে না| তারপর পাখীটিকে বেদীর উপর কাঠের ওপরকার আগুনে পোড়াবে| এটা হল হোমবলি, আগুনে প্রস্তুত নৈবেদ্য| এর সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“যদি কেউ প্রভু ঈশ্বরকে শস্য নৈবেদ্য দান করে, তবে তার নৈবেদ্য যেন গুঁড়ো ময়দা থেকে তৈরী হয়| এই ময়দার ওপর লোকটি অবশ্যই তেল ঢালবে এবং তার ওপর কুন্দুরু রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","তারপর সে সেটা হারোণের পুত্রদের কাছে অর্থাৎ‌ যাজকদের কাছে আনবে| সে তেল আর সুগন্ধি মেশানো এক মুঠো ময়দার গুঁড়ো নেবে| যাজক তখন বেদীর ওপরে এই স্মারক নৈবেদ্য পোড়াবে| এই নৈবেদ্য আগুনে প্রস্তুত| এর সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","হারোণ এবং তার পুত্রদের জন্য থাকবে বাকি পড়ে থাকা শস্য নৈবেদ্য| প্রভুকে দেওয়া আগুনে তৈরী এই নৈবেদ্য অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“যখন কোন লোক উনুনে সেঁকা রুটি নৈবেদ্য উপহার দেয় তখন তা যেন অবশ্যই খামিরবিহীন রুটি হয় মিহি ময়দা ও তেল দিয়ে তৈরী, অথবা যেন তেল মেশানো সরুচাকলী হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","যদি তুমি সেঁকাপাত্রে সেঁকা শস্য নৈবেদ্য আনো, তা হলে তা যেন অবশ্যই তেল মেশানো খামিরবিহীন গুঁড়ো ময়দার তৈরী হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","তুমি অবশ্যই সেটা টুকরো টুকরো করবে এবং তার ওপর তেল ঢালবে| এটি হল শস্য নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","যদি তুমি কড়ায় ভাজা শস্য নৈবেদ্য নিয়ে আসো, তখন যেন তা তেল মেশানো গুঁড়ো ময়দা দিয়ে তৈরী হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“তুমি অবশ্যই এই সব জিনিস থেকে তৈরী শস্য নৈবেদ্যগুলি প্রভুর কাছে আনবে| যাজকের কাছে সেগুলি নিয়ে যাবে এবং সে সেগুলিকে বেদীর ওপর রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","তারপর যাজক শস্য নৈবেদ্যর কিছু অংশ নেবে এবং এই স্মারক নৈবেদ্য, বেদীর ওপর পোড়াবে| এই নৈবেদ্য আগুনে তৈরী| এর সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","পড়ে থাকা শস্য নৈবেদ্য হারোণ ও তার পুত্রদের জন্য| প্রভুকে দেওয়া এই আগুনে তৈরী নৈবেদ্য অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“তোমরা অবশ্যই খামির মেশানো কোন শস্য নৈবেদ্য প্রভুকে দেবে না| তোমরা খামির বা মধু আগুনে ঝলসে প্রভুকে নৈবেদ্য হিসেবে দেবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","প্রথম ফসল থেকে আনা নৈবেদ্য হিসেবে তোমরা খামির ও মধু প্রভুর কাছে আনতে পারো, কিন্তু খামির ও মধু সুগন্ধ হয়ে উবে যাওয়ার জন্য বেদীর ওপর যেন পোড়ানো না হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","তোমাদের আনা প্রতিটি শস্য নৈবেদ্যে তোমরা অবশ্যই লবণ দেবে| ঈশ্বরের নিয়মের লবণ যেন তোমাদের শস্য নৈবেদ্য থেকে বাদ না পড়ে| তোমাদের সমস্ত নৈবেদ্যর সঙ্গে অবশ্যই লবণ আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“যখন তোমরা প্রথম ফসল থেকে শস্য নৈবেদ্য প্রভুর কাছে আনবে, তখন অবশ্যই আগুনে ঝলসানো শস্যের মাথা আনবে| এইগুলি অবশ্যই টাটকা শস্যের চূর্ণ করা মাথা হবে| এই হবে তোমাদের প্রথম ফসল থেকে আনা শস্য নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","তোমরা অবশ্যই তেল আর সুগন্ধি তার ওপর ঢালবে| এই হল শস্য নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","যাজক অবশ্যই গুঁড়ো শস্যের কিছু অংশ, তেল এবং সমস্ত ধূনা প্রভুর কাছে স্মারক নৈবেদ্য হিসেবে পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“মঙ্গল নৈবেদ্য হিসেবে যখন কেউ ঈশ্বরের কাছে উৎসর্গ দেয় তখন প্রাণীটি একটি পুরুষ বা স্ত্রী গরু হতে পারে| কিন্তু প্রাণীটির অবশ্যই যেন কোন দোষ না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","লোকটি প্রাণীটির মাথায় হাত রাখবে এবং সমাগম তাঁবুতে ঢোকার মুখে প্রাণীটিকে হত্যা করবে, তারপর বেদীর ওপরে আর তার চারপাশে হারোণের পুত্ররা অর্থাৎ‌ যাজকরা রক্ত ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","মঙ্গল নৈবেদ্য হল প্রভুর প্রতি আগুনে প্রস্তুত এক নৈবেদ্য| প্রাণীটির দেহের ভিতরে ও বাইরে যে চর্বি আছে, যাজকরা তা অবশ্যই উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","তারা দুটি বৃক্ক এবং যে চর্বি নিতম্বের নীচে তাদের ঢেকে রেখেছে সেগুলো উৎসর্গ করবে| যে চর্বি যকৃৎকে ঢেকে রেখেছে তারা সেটিও উৎসর্গ করবে এবং বৃক্কের সঙ্গে এটিকে সরিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","তারপর হারোণের পুত্ররা বেদীর ওপর চর্বি পোড়াবে| আগুনের ওপরকার কাঠে রাখা জ্বলন্ত নৈবেদ্যর ওপর তা তারা রাখবে| এটা হল আগুনে প্রস্তুত নৈবেদ্য| এর সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“যখন কোন লোক প্রভুর প্রতি মঙ্গল নৈবেদ্য হিসেবে একটি মেষ বা একটি ছাগল দান করে, তখন প্রাণীটি পুরুষ অথবা স্ত্রী জাতীয় হতে পারে; কিন্তু তাতে যেন অবশ্যই কোন দোষ না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","যদি সে তার নৈবেদ্য হিসেবে একটি মেষশাবক আনে তবে সে তা প্রভুর সামনে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","সে অবশ্যই তার হাত প্রাণীটির মাথার ওপর রাখবে আর সমাগম তাঁবুর সামনে প্রাণীটিকে হত্যা করবে| তারপর হারোণের পুত্ররা বেদীর চারপাশে প্রাণীটির রক্ত ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","আগুনে প্রস্তুত নৈবেদ্যর মত করে তারা মঙ্গল নৈবেদ্যর একটা অংশ প্রভুর প্রতি উৎসর্গ করবে| তারা অবশ্যই চর্বি, সমগ্র চর্বিযুক্ত লেজ এবং যে চর্বি প্রাণীটির ভিতর অংশের সমস্ত অঙ্গগুলোকে ঢেকে রাখে তা উৎসর্গ করবে| (পিছনের হাড়ের একেবারে লাগোয়া অংশ থেকে লেজটা সে কেটে দেবে|) ");
INSERT INTO ben2006_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","কটির কাছের দুটি বৃক্ক ও তাদের ঢেকে রাখা চর্বিকে তারা যেন দান করে| তারা অবশ্যই যকৃতের চর্বি অংশটুকুও দান করবে| তারা অবশ্যই বৃক্ক সমেত সেটিকে সরিয়ে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","তারপর বেদীর ওপর যাজকরা সেগুলিকে পোড়াবে| প্রভুর প্রতি আগুনের নৈবেদ্যই হল মঙ্গল নৈবেদ্য কিন্তু এটা সাধারণ মানুষ খাদ্য হিসেবে গ্রহণ করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“যদি নৈবেদ্যটি একটি ছাগল হয় তা হলে লোকটি তাকে প্রভুর সামনে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","লোকটি ছাগলটির মাথায় তার হাত রাখবে এবং তাকে সমাগম তাঁবুর সামনে হত্যা করবে| তারপর হারোণের পুত্ররা বেদীর চারপাশে ছাগলের সে রক্ত ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","প্রভুর প্রতি আগুনের নৈবেদ্য হিসেবে যাজকরা মঙ্গল নৈবেদ্যর কিছু অংশ অবশ্যই দান করবে| প্রাণীটির ভিতরের অংশগুলির ওপরের ও চারপাশের চর্বি তারা অবশ্যই উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","তারা নীচের পিছনের দিকের মাংসপেশীর কাছাকছি দুটি বৃক্ক ও তাদের চর্বির আচ্ছাদন অবশ্যই উৎসর্গ করবে| তারা যকৃতের চর্বি অংশও দেবে| তারা অবশ্যই এটাকে বৃক্কসহ সরিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","এরপর যাজকরা অবশ্যই এগুলি বেদীর ওপর পোড়াবে| মঙ্গল নৈবেদ্য হল আগুনে প্রস্তুত এক নৈবেদ্য| এর সুগন্ধ প্রভুকে খুশী করে| এটিও সাধারণ মানুষ খাদ্য হিসেবে গ্রহণ করতে পারে; কিন্তু শ্রেষ্ঠ অংশগুলি অর্থাৎ‌ চর্বি, প্রভুর জন্য নির্দিষ্ট| ");
INSERT INTO ben2006_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","বংশপরম্পরায় এই নিয়ম চিরকালের জন্য তোমাদের মধ্যে চলতে থাকবে| যেখানেই তোমরা থাক তোমরা অবশ্যই কখনও চর্বি বা রক্ত খাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ইস্রায়েলের লোকদের বলো: যদি কোন মানুষ অজান্তে পাপ করে ফেলে এবং প্রভু যা করতে বারণ করেছেন তেমন কোন কাজ করে, তখন মানুষটি অবশ্যই এই কাজগুলি করবে: ");
INSERT INTO ben2006_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“যদি অভিষিক্ত যাজক এমন একটা ভুল করে বসে যাতে মানুষ তার পাপে দোষী হয়ে যায়, তখন যাজক তার পাপের জন্য অবশ্যই প্রভুর কাছে একটি নৈবেদ্য দান করবে| যাজক অবশ্যই কোন দোষ নেই এমন একটি এঁড়ে বাছুর উৎসর্গ করবে| পাপ নৈবেদ্য হিসেবে সে এঁড়ে বাছুরটি প্রভুকে উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","অভিষিক্ত যাজক এঁড়ে বাছুরটিকে সমাগম তাঁবুর প্রবেশ পথে আনবে| তারপর তার হাত ষাঁড়ের মাথায় রাখবে এবং প্রভুর সামনে ষাঁড়টাকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","সেই যাজক বাছুরটি থেকে কিছুটা রক্ত নিয়ে তা সমাগম তাঁবুর ভেতরে নিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","পরে তার আঙুল রক্তের মধ্যে ডোবাবে এবং পবিত্রতম জায়গার আচ্ছাদনের সামনে প্রভুর সামনে সাতবার সেই রক্ত ছেটাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","যাজক কিছুটা রক্ত সুগন্ধী বেদীর কোণে লাগাবে| (এই বেদীটি সমাগম তাঁবুতে প্রভুর সামনে রয়েছে|) ষাঁড়ের সব রক্তটাই তাকে হোম বেদীর নীচে ঢেলে দিতে হবে| (এই বেদীটি সমাগম তাঁবুতে ঢোকার মুখের বেদী|) ");
INSERT INTO ben2006_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","পাপের জন্য নৈবেদ্যর বাছুরটির সমস্ত চর্বি সে বার করে নেবে| ভেতরের অংশগুলির ওপরকার ও চারপাশের চর্বিও সে নিয়ে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","সে অবশ্যই বৃক্ক এবং কটির নীচে যে চর্বি তাদের ঢেকে রাখে তা নেবে| সে যকৃতের চর্বিও অবশ্যই নেবে| সে এটা বৃক্কের সাথেই বার করে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","মঙ্গল নৈবেদ্যর ষাঁড়টির উৎসর্গীকরণের মতই যাজক অবশ্যই এই সমস্ত অংশগুলো উৎসর্গ করবে| হোম নৈবেদ্যর জন্য যে বেদী, তার ওপর যাজক অবশ্যই প্রাণীটির অংশগুলো পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","কিন্তু যাজক অবশ্যই ষাঁড়টির চামড়া, ভেতরের অংশগুলো এবং শরীরের বর্জ্য পদার্থ এবং মাথা ও পায়ের সমস্ত মাংস সরিয়ে রাখবে| যাজক সেই সব অংশ তাঁবুর বাইরে বিশেষ জায়গায়-যেখানে ছাইগুলো ঢেলে রাখা হয়, সেখানে বয়ে নিয়ে আসবে| সেখানে অবশ্যই সে কাঠের ওপর সেই সব অংশ রেখে পোড়াবে| যেখানে ছাইগুলো ঢালা আছে সেখানেই ষাঁড়টিকে পোড়াতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“এমনও হতে পারে যে সমগ্র ইস্রায়েল জাতি না জেনে পাপ করেছে| তারা হয়তো এমন অনেক কাজ করে বসেছে যেগুলি প্রভু তাদের না করতেই আজ্ঞা দিয়েছেন| যদি তাই ঘটে তারা দোষী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","যদি তারা সেই পাপ সম্বন্ধে বুঝতে পারে, তবে তারা সমগ্র জাতির জন্য পাপের নৈবেদ্য হিসেবে একটা এঁড়ে বাছুর উৎসর্গ করবে| তারা অবশ্যই এঁড়ে বাছুরটিকে সমাগম তাঁবুতে নিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","লোকদের মধ্যে যারা প্রবীণ তারা প্রভুর সামনে ষাঁড়টির মাথায় হাত রাখবে এবং তখন একজন প্রভুর সামনে এঁড়ে বাছুরটিকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","অভিষিক্ত যাজক যে তখন কর্তব্যরত ছিল, সে কিছুটা রক্ত সমাগম তাঁবুতে নিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","যাজকটি তার আঙুল রক্তের মধ্যে ডোবাবে এবং তা সাতবার প্রভুর সামনে পর্দার সম্মুখভাগে ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","তারপর যাজক কিছুটা রক্ত বেদীর কোণগুলোয় ফেলবে| (এই বেদী সমাগম তাঁবুর মধ্যে প্রভুর সামনে রয়েছে|) যাজক সমস্ত রক্ত জ্বলন্ত নৈবেদ্যর বেদীর মেঝেতে ঢালবে| (এই বেদী সমাগম তাঁবুর মধ্যে ঢোকার মুখে রয়েছে|) ");
INSERT INTO ben2006_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","এরপর যাজক প্রাণীটির সমস্ত চর্বি নেবে এবং তা বেদীর ওপর পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","যাজক পাপ নৈবেদ্য যেমনভাবে ষাঁড়টিকে উৎসর্গ করেছিল সেইভাবেই এই সমস্ত অংশগুলো উৎসর্গ করবে| এইভাবে যাজক লোকদের শুচি করে তুলবে এবং ঈশ্বর ইস্রায়েলের লোকদের ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","যাজক অবশ্যই এই ষাঁড়টিকে শিবিরের বাইরে আনবে এবং তা পোড়াবে, যেমনভাবে সে প্রথম ষাঁড়কে পুড়িয়েছিল| সমগ্র সম্প্রদায়ের পক্ষে এটাই হল পাপ মোচনের নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“একজন শাসক অজান্তে পাপ করতে পারে এবং তার প্রভু ঈশ্বর যা যা করতে অবশ্যই নিষেধ করেছিলেন, তার মধ্যে কোন একটা সে করে ফেলতে পারে| এই ভুল করার জন্য শাসক দোষী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","যদি শাসক তার পাপ সম্বন্ধে বুঝতে পারে, তা হলে সে অবশ্যই কোন দোষ নেই এমন একটি পুরুষ ছাগল আনবে| সেটাই হবে তার নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","শাসকটি অবশ্যই তার হাত ছাগলটির মাথায় রাখবে আর প্রভুর সামনে যেখানে হোমবলি হত্যা করা হয় সেখানেই তাকে হনন করবে| ছাগলটি হল দোষমোচনের বলি| ");
INSERT INTO ben2006_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","পাপ নৈবেদ্যর কিছুটা রক্ত যাজক অবশ্যই তার আঙুলে নেবে এবং জ্বলন্ত নৈবেদ্যর বেদীর কোণগুলোয় তা লাগাবে| বাকি রক্তটুকু যাজক অবশ্যই বেদীর মেঝেতে ঢেলে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","আর ছাগলটির সমস্ত মেদ যাজক অবশ্যই বেদীর ওপর পোড়াবে; মঙ্গল নৈবেদ্য দানের মেদ যেমনভাবে সে পোড়ায় সেইভাবে যাজক অবশ্যই তা পোড়াবে| এইভাবে যাজক সেই শাসককে তার পাপ থেকে শোষণ করবে এবং ঈশ্বর তাকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“সাধারণ মানুষের কেউ যদি অজান্তে পাপ করে এবং প্রভু যা নিষিদ্ধ করেছেন এমন কিছু যদি করে তাহলে সে তার অপরাধের জন্য আইনের কাছে দায়বদ্ধ থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","যদি সেই ব্যক্তিটির নিজের পাপ সম্বন্ধে অবগত হয় তবে সে নিশ্চয়ই দোষ নেই এমন একটি স্ত্রী ছাগল আনবে| এইটিই হবে লোকটির পাপের জন্য নৈবেদ্য| পাপ করেছে বলে সে অবশ্যই এই ছাগলটি আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","সে তার হাত প্রাণীটির মাথায় রাখবে এবং হোমবলির জায়গায় তাকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","তারপর যাজক ছাগলটির কিছুটা রক্ত তার আঙুলে নেবে এবং হোমবলির বেদীর কোণগুলোতে সেই রক্ত ছিটিয়ে দেবে| এরপর যাজক ছাগের বাকি রক্তটুকু অবশ্যই বেদীর মেঝেতে ঢেলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","যেমনভাবে মঙ্গল নৈবেদ্য থেকে মেদ দেওয়া হয়, সেইভাবে যাজক অবশ্যই ছাগলটির সমস্ত মেদ উৎসর্গ করবে| যাজক অবশ্যই প্রভুর উদ্দেশ্যে সুগন্ধি হিসেবে বেদীর ওপর তা পোড়াবে| এইভাবে যাজক সেই মানুষটিকে তার পাপ মোচনের প্রায়শ্চিত্ত করাবে| এবং ঈশ্বর সেই ব্যক্তিকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“পাপের নৈবেদ্য হিসেবে যদি সেই লোকটি একটি মেষশাবক আনে তাহলে তাকে অবশ্যই কোন দোষ নেই এমন একটি স্ত্রী শাবক আনতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","লোকটি অবশ্যই তার হাত প্রাণীটির মাথায় রাখবে এবং যেখানে তারা হোমবলি হত্যা করে সেখানেই দোষ মোচনের নৈবেদ্যকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","যাজক তার আঙুলে অবশ্যই সেই পাপমোচনের নৈবেদ্য থেকে কিছুটা রক্ত নেবে এবং হোমবলির বেদীর কোণগুলিতে তা লাগাবে| এরপর যাজক মেষশাবকটার বাকী সব রক্ত বেদীর মেঝেয ঢালবে| ");
INSERT INTO ben2006_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","যেমনভাবে মঙ্গল নৈবেদ্যগুলির মধ্যে মেষশাবকের মেদ মাংস উৎসর্গ করা হয়, যাজক সেইভাবে মেষশাবকটির সমস্ত মেদ উৎসর্গ করবে| সেটাকে যাজক যেমনভাবে কোন হোমবলি প্রভুকে দেওয়া হয়, সেইভাবে বেদীর ওপর তাকে পোড়াবে| এইভাবে যাজক সেই ব্যক্তিটিকে তার কৃত পাপ কর্মের প্রায়শ্চিত্ত করাবে এবং ঈশ্বর সেই লোকটিকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“কোন মানুষ একটি সতর্কবাণী শুনেছে অথবা একজন মানুষ এমন কিছু শুনে বা দেখে থাকতে পারে যা অন্য লোকদের বলা উচিৎ‌| যদি সেই লোকটি যা দেখেছে বা শুনেছে তা লোকদের না বলে, তা হলে সে এই পাপের জন্য দোষী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","অথবা লোকটি হয়ত অশুচি কোন কিছু স্পর্শ করেছে, যেমন গৃহপালিত কোন প্রাণীর মৃতদেহ অথবা কোন অশুচি প্রাণীর মৃতদেহ| ঐ লোকটি নাও জানতে পারে যে সে ঐসব জিনিস স্পর্শ করেছে; কিন্তু তবু সে ভুল করার কারণে দোষী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","এমন অনেক বিষয় আছে যা মানুষের কাছ থেকে আসে এবং মানুষকে অশুচি করে| একজন মানুষ না জেনেই অন্য একজনের কাছ থেকে এসবের যে কোন একটা স্পর্শ করতে পারে| যখন সেই মানুষ জানতে পারে যে সে অশুচি জিনিস স্পর্শ করেছে, তখন সে দোষী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","একজন মানুষ ভাল অথবা মন্দ কিছু চিন্তা না করেই হঠকারী প্রতিজ্ঞা করে ফেলতে পারে এবং এসম্পর্কে ভুলে যেতে পারে কিন্তু যখন তার প্রতিজ্ঞার কথাটা মনে পড়বে তখনই সে হবে দোষী কারণ সে তার প্রতিশ্রুতি রক্ষা করেনি| ");
INSERT INTO ben2006_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","সুতরাং যদি কোন মানুষ এগুলির মধ্যে কোন একটি বিষয়ে দোষী হয় তাহলে সে যে কাজটা ভুল করে করেছে তা অবশ্যই স্বীকার করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","সে অবশ্যই তার কৃত দোষের জন্য প্রভুর কাছে আসবে| সে অবশ্যই একটা স্ত্রী মেষশাবক বা স্ত্রী ছাগল পাপমোচনের নৈবেদ্য হিসেবে আনবে| তারপর যাজক সেই মানুষটির কৃত পাপকর্ম থেকে তাকে মুক্ত করার জন্য যা কিছু করার করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“যদি লোকটি মেষশাবক দিতে সমর্থ না হয় তবে সে অবশ্যই দুটি ঘুঘু পাখী বা দুটি পায়রা ঈশ্বরের কাছে আনবে| এগুলো হল তার কৃত পাপের জন্য নৈবেদ্য| একটি পাখী হবে অবশ্যই তার পাপের নৈবেদ্য এবং অপরটি হবে হোমের নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","লোকটি অবশ্যই সেগুলি যাজকের কাছে আনবে| প্রথমে যাজক পাপ নৈবেদ্য হিসেবে একটি পাখীকে উৎসর্গ করবে| যাজক পাখীর ঘাড় থেকে মাথাটা আলাদা করে নেবে, কিন্তু পাখীটিকে দুভাগে ভাগ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","যাজক অবশ্যই বেদীর পাশে পাপের জন্য উৎসর্গীকৃত এই নৈবেদ্যর রক্তকে ছিটিয়ে দেবে| তারপর বাকি রক্ত বেদীর তলদেশে ঢেলে দেবে| এই হল কৃত পাপের জন্য নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","এরপর যাজক দ্বিতীয় পাখীটিকে অবশ্যই হোমবলির নিয়মানুযায়ী উৎসর্গ করবে| এইভাবে যাজক সেই মানুষটিকে তার কৃত পাপ থেকে মোচনের প্রায়শ্চিত্ত করাবে এবং ঈশ্বর সেই মানুষটিকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“যদি মানুষটি দুটি ঘুঘু পাখী বা দুটি পায়রা দিতে সমর্থ না হয় তাহলে সে অবশ্যই 8 কাপ গুঁড়ো ময়দা আনবে| এটাই হবে তার পাপের জন্য নৈবেদ্য| লোকটি কোনক্রমেই ময়দায় কোন তেল দেবে না| তা পাপ মোচনের নৈবেদ্য বলে সে এতে কুন্দুরু দেবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","লোকটি অবশ্যই ময়দার গুঁড়ো যাজকের কাছে আনবে| যাজক তা থেকে এক মুঠো ময়দা নেবে| এ হবে এক স্মরনার্থক নৈবেদ্য| বেদীর ওপর যাজক গুঁড়ো ময়দা পোড়াবে| এ হল ঈশ্বরের প্রতি আগুনে পোড়ানো এক নৈবেদ্য| এ নৈবেদ্য পাপের জন্য উৎসর্গ নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","এইভাবে যাজক মানুষটিকে শোধন করবে এবং ঈশ্বর সেই মানুষটিকে ক্ষমা করবেন| যেটুকু শস্য নৈবেদ্য পড়ে থাকবে, তা সাধারণ শস্য নৈবেদ্যর মতই যাজকের জন্য হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“কোন মানুষ আকস্মিকভাবে প্রভুর পবিত্র জিনিস অপবিত্র করতে পারে| সেক্ষেত্রে সেই লোকটি তখন কোন খুঁত নেই এমন একটি পুরুষ মেষ অবশ্যই আনবে| এটাই হবে প্রভুর প্রতি দোষের জন্য দেওয়া নৈবেদ্য| তুমি অবশ্যই পবিত্র স্থানের মাপ কাঠি ব্যবহার করবে এবং পুরুষ মেষটির একটি মূল্য ঠিক করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","পবিত্র জিনিসের সঙ্গে সে যে পাপ করেছে তার জন্য লোকটি অবশ্যই তার জরিমানা দেবে| সে যা দেবে বলে প্রতিশ্রুতি দিয়েছিল তা দেবে ও তার সঙ্গে মূল্যের এক পঞ্চমাংশ যোগ করবে এবং সেই মূল্য যাজককে দেবে| এইভাবে পাপমোচনের নৈবেদ্যর মেষটি উৎসর্গ করে যাজক সেই লোকটিকে শুচি করবে এবং ঈশ্বর ঐ ব্যক্তিকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“যদি কোন ব্যক্তি পাপ করে এবং প্রভুর আজ্ঞাগুলির কোন একটি লঙঘন করে, এমনকি যদি সে তা না জেনে করে থাকে, সে দোষী সাব্যস্ত হবে এবং তার পাপের জন্য দায়ী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","সেই লোকটিকে যাজকের কাছে কোন খুঁত নেই এমন একটি পুরুষ মেষ আনতে হবে| সেই পুরুষ মেষ হবে দোষ মোচনের নৈবেদ্য| এইভাবে অজান্তে লোকটি যে পাপ করেছিল তা থেকে যাজক তাকে মুক্ত করবে এবং ঈশ্বর সেই মানুষটিকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","এমন কি, সে যে পাপ করেছে এটা না জানলেও লোকটি দোষী সুতরাং সে প্রভুকে অবশ্যই তার দোষার্থক নৈবেদ্য দান করবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“একজন মানুষ হয়তো এইসব পাপের মধ্যে কোন একটা করে প্রভুর বিরুদ্ধাচরণ করতে পারে| কারোর কোন বিষয় দেখাশোনা করার সময় সে ব্যাপারে কি ঘটেছে সে সম্বন্ধে মিথ্যা কথা বলতে পারে, সে কিছু চুরি করতে পারে অথবা কাউকে ঠকাতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","অন্যের হারিয়ে যাওয়া জিনিস পেয়ে মিথ্যে বলতে পারে, অথবা তার প্রতিশ্রুতি অনুযায়ী কাজ নাও করতে পারে| অথবা কোন মানুষ অন্য কোন রকমের অন্যায় করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","কিন্তু সে এই ধরণের কোন কাজ করলে পাপের দোষে দোষী হবে, সুতরাং সে যা কিছু চুরি করেছিল, সে অন্যকে ঠকিয়ে যা কিছু নিয়েছিল তা সে অবশ্যই ফিরিয়ে দেবে| অথবা অন্য লোকরা তাকে যা কিছু তত্ত্বাবধান করার জন্য দিয়েছিল অথবা যেসব জিনিস সে পেয়েও মিথ্যে বলেছিল, সব কিছু সে অবশ্যই ফিরিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","সে যা কিছু মিথ্যা প্রতিশ্রুতি দিয়েছিল তার পুরো দাম দেবে এবং তারপর সে অতিরিক্ত জিনিসটির এক পঞ্চমাংশের মত দামও অবশ্যই ফেরৎ‌ দেবে| সে প্রকৃত অধিকারীর কাছেই সেই অর্থ দেবে| যেদিন সে তার দোষার্থক বলি নিয়ে আসবে সেদিন সে এই কাজটি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ঐ মানুষটি অবশ্যই যাজকের কাছে দোষার্থক বলি নিয়ে আসবে| তা অবশ্যই হবে মেষের দল থেকে আনা একটা পুরুষ মেষ| সেই পুরুষ মেষের মধ্যে যেন কোন খুঁত না থাকে| যাজক যা বলবে এর দাম হবে তাই| এটা হবে প্রভুর কাছে প্রদত্ত এক দোষার্থক বলি| ");
INSERT INTO ben2006_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","এরপর যাজক প্রভুর কাছে যাবে এবং লোকটির পাপ মোচনের জন্য প্রয়োজনীয় কাজ করবে এবং প্রভু লোকটির সমস্ত কাজ ক্ষমা করে দেবেন যেগুলির জন্য সে দায়ী ছিল|” ");
INSERT INTO ben2006_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“হারোণ এবং তার পুত্রদের এই নির্দেশ দাও: এটা হল হোমবলির নিয়ম| বেদীর অগ্নিকুণ্ডের ওপর সকাল না হওয়া পর্যন্ত হোমবলি সারা রাত ধরে থাকবে| বেদীর আগুন অবশ্যই একটানা বেদীটির ওপরে জ্বলতে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","যাজক অবশ্যই মসীনার অন্তর্বাস পরবে এবং তার উপর পরবে মসীনা বস্ত্রের পোশাক| বেদীর ওপর আগুনে দগ্ধ যে নৈবেদ্যসমূহ ছাই হয়ে যাবে যাজক সেই পরিত্যক্ত ছাই তুলে নিয়ে সেই সমস্ত ছাই বেদীর পাশে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","এরপর যাজক এই পোশাক ছেড়ে অন্য পোশাক পরবে, তারপর সে তাঁবুর বাইরে অন্য এক বিশেষ জায়গায় ছাইগুলিকে নিয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","কিন্তু বেদীর আগুন অবশ্যই বেদীর ওপর জ্বলতে থাকবে| তাকে কোন মতেই নিভিয়ে দেওয়া চলবে না| যাজক প্রতিদিন সকালে বেদীর ওপরে কাঠ দিয়ে জ্বালাবে| সে বেদীর ওপরে কাঠ সাজিয়ে মঙ্গল নৈবেদ্য সমূহের চর্বি অবশ্যই পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","বেদীর ওপর আগুন অবিরাম জ্বলতে থাকবে, তা যেন কোন মতেই না নিভে যায়| ");
INSERT INTO ben2006_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“এটা হল শস্য নৈবেদ্য দানের নিয়ম: বেদীর সামনে প্রভুর কাছে হারোণের পুত্ররা এই নৈবেদ্য অবশ্যই আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","শস্য নৈবেদ্য সমূহের মধ্য থেকে যাজক এক মুঠো ভর্ত্তি গুঁড়ো ময়দা নেবে| সেই শস্য নৈবেদ্যর সাথে যেন তেল এবং সুগন্ধী নিশ্চিতভাবে থাকে| যাজক বেদীর ওপর শস্য নৈবেদ্যকে পোড়াবে| এটা হবে প্রভুর প্রতি এক স্মরনার্থক নৈবেদ্য, এর গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“শস্য নৈবেদ্যর অবশিষ্ট যা পড়ে থাকবে হারোণ এবং তার পুত্ররা অবশ্যই তা খাবে| খামির না দিয়ে তৈরী এক ধরণের রুটিই হল শস্য নৈবেদ্য| কোনো পবিত্র স্থানে যাজকরা অবশ্যই এই রুটি খাবে; সমাগম তাঁবুর প্রাঙ্গণের মধ্যেই এটা খাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","শস্য নৈবেদ্যটি যেন কখনই খামির দিয়ে তৈরী করা না হয়| আগুন দিয়ে তৈরী আমাকে দেওয়া নৈবেদ্যসমূহ আমি যাজকদের অংশ হিসেবে দিয়েছি| এটা অত্যন্ত পবিত্র, দান করা পাপ নৈবেদ্য এবং দোষ নৈবেদ্যর মত| ");
INSERT INTO ben2006_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","হারোণের সমস্ত সন্তানদের মধ্যে প্রত্যেকটি পুরুষ সন্তান আগুনে প্রস্তুত প্রভুর প্রতি নিবেদিত নৈবেদ্যসমূহ খেতে পারে| এটা তোমাদের বংশপরম্পরাভাবে চিরকালের নিয়ম| এই সমস্ত নৈবেদ্য স্পর্শের দ্বারাই সেই সব মানুষদের পবিত্রতা আনে|” ");
INSERT INTO ben2006_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“হারোণ আর তার পুত্রদের আমার কাছে এইসব নৈবেদ্য আনতে হবে| যেদিন তারা হারোণকে প্রধান যাজক বলে অভিষিক্ত করবে, সেদিনই তারা এটা করবে| শস্য নৈবেদ্যর জন্য তারা অবশ্যই 8 কাপ গুঁড়ো ময়দা আনবে| (প্রতিদিনের নৈবেদ্য দানের সময়েই এটা দেওয়া হবে|) তারা এর অর্ধেক আনবে সকালে, বাকি অর্ধেক আনবে সন্ধ্যার সময়| ");
INSERT INTO ben2006_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","গুঁড়ো ময়দার সঙ্গে তেল মেশানো হবে এবং সেঁকার পাত্রে তাকে সেঁকা হবে| তৈরী হয়ে গেলে তুমি অবশ্যই তা ভেতরে আনবে| তুমি নৈবেদ্যটিকে টুকরো টুকরো করে ভাঙ্গবে| এর গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“হারোণের স্থানে বসার জন্য হারোণের উত্তরপুরুষদের থেকে অভিষিক্ত যাজক এই শস্য নৈবেদ্য অবশ্যই প্রভুর কাছে আনবে| এ নিয়ম চিরকাল ধরে চলবে| প্রভুর জন্য শস্য নৈবেদ্য অবশ্যই সম্পূর্ণভাবে অগ্নিদগ্ধ করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","যাজকের প্রত্যেকটি শস্য নৈবেদ্য অবশ্যই সম্পূর্ণভাবে পোড়াতে হবে| তা কোন মতেই আহার করা চলবে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“হারোণ ও তার পুত্রদের বলো: এই হল পাপ নৈবেদ্য দানের নিয়ম| যেখানে প্রভুর সামনে হোমবলির বলি হত্যা করা হয়েছিল, সেখানেই পাপ নৈবেদ্যর বলিকেও হত্যা করতে হবে| এটা অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","যে যাজক পাপ নৈবেদ্য উৎসর্গ করছে সে অবশ্যই সেটা খাবে; কিন্তু সে এটা একটা পবিত্র জায়গায় খাবে-জায়গাটা যেন সমাগম তাঁবুর চারপাশের উঠানের মধ্যে হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","পাপ নৈবেদ্যর মাংস স্পর্শেই একজন মানুষ বা কোন বিষয় পবিত্র হয়ে ওঠে| “যদি ছিটানো রক্তের একটুও কোন মানুষের কাপড়ের ওপর পড়ে তখন অবশ্যই কোন পবিত্র স্থানে যেন সেই কাপড় কাচা হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","মাটির পাত্রে যদি পাপ নৈবেদ্যকে সিদ্ধ করা হয়, তাহলে পাত্রটাকে অবশ্যই ভেঙ্গে ফেলতে হবে| যদি পাপ নৈবেদ্যকে পিতলের তৈরী পাত্রে ফোটানো হয়, তাহলে পাত্রটিকে অবশ্যই মাজতে হবে এবং পরে জলে ধুয়ে নিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“যাজক পরিবারের যে কোন পুরুষ পাপ মোচনের নৈবেদ্য খেতে পারবে; এটা খুবই পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","কিন্তু যদি পাপ মোচনের নৈবেদ্যর রক্ত সমাগম তাঁবুর মধ্যে আনা হয় এবং সেই পবিত্র স্থানে লোকদের শুচি করার জন্য ব্যবহার করা হয়, তাহলে সেই পাপ মোচনের নৈবেদ্য আগুনে পুড়িয়ে নিতে হবে| যাজকরা সেই পাপ নৈবেদ্য অবশ্যই খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“দোষ মোচনের বলি উৎসর্গের এগুলি হল নিয়ম: এ অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","একজন যাজক দোষ মোচনের বলি অবশ্যই সেই জায়গায় হত্যা করবে, যেখানে হোমের বলি হত্যা করা হয়, তারপর দোষ মোচনের বলির রক্ত বেদীর সবদিকে ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“যাজক দোষ মোচনের বলির সমস্ত মেদ অবশ্যই উৎসর্গ করবে, মেদসহ লেজ এবং ভিতর অংশের ওপর ছড়িয়ে থাকা মেদ উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","যাজক নৈবেদ্যর দুটি বৃক্ক এবং যে চর্বি কটিদেশের নীচে তাদের ঢেকে রাখে তা উৎসর্গ করবে, যকৃতের মেদ অংশও নৈবেদ্য হিসাবে দেবে| মুত্রগ্রন্থিগুলির সঙ্গে সে তা ছাড়িয়ে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ঐ সমস্ত জিনিস যাজক বেদীর ওপর পোড়াবে| এ হবে প্রভুর প্রতি আগুনে প্রস্তুত এক নৈবেদ্য| এটা হল এক দোষ মোচনের নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“যাজকের পরিবারের যে কোন পুরুষ দোষ মোচনের বলি ভক্ষণ করতে পারে| এ নৈবেদ্য খুবই পবিত্র, তাই এটা অবশ্যই কোন পবিত্র স্থানে খেতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","দোষ মোচনের নৈবেদ্য পাপ মোচনের নৈবেদ্যরই মতো| এই দুই নৈবেদ্যর জন্য এক নিয়ম| যে যাজক বলির ব্যবস্থা করবে সে খাদ্য হিসেবে মাংস পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","যে যাজক বলির ব্যবস্থা করবে সে দগ্ধ নৈবেদ্য থেকে চামড়াও পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","প্রদত্ত প্রত্যেক শস্য নৈবেদ্য সেই যাজকের অধিকারে আসবে, যে যাজক তা উৎসর্গ করবার ভার নেবে| যাজক পাবে শস্য নৈবেদ্যসমূহ যা উনুনে সেঁকা বা ভাজবার পাত্রে অথবা সেঁকার থালায় রান্না করা| ");
INSERT INTO ben2006_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","হারোণের পুত্রদের অধিকারে থাকবে শস্য নৈবেদ্যসমূহ, সেগুলি শুকনো বা তেল মেশানো হতে পারে| হারোণের পুত্ররা সকলে এই খাদ্যের অংশ নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“প্রভুর কাছে মঙ্গল নৈবেদ্যসমূহ দানের নিয়ম: ");
INSERT INTO ben2006_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","কোন ব্যক্তি কৃতজ্ঞতা জানাতে মঙ্গল নৈবেদ্য আনতে পারে| যদি সে কৃতজ্ঞতা জানাতে নৈবেদ্য আনে তবে তার খামিরবিহীন তেল মাখানো রুটি, ওপরে তেল দেওয়া পাতলা কিছু রুটি এবং তেল মেশানো গুঁড়ো ময়দার কিছু গোটা পাঁউরুটি আনা উচিত| ");
INSERT INTO ben2006_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","মঙ্গল নৈবেদ্যসমূহ হল সেই নৈবেদ্য যা কোন ব্যক্তি ঈশ্বরকে ধন্যবাদ জানাতেই আনে| সেই নৈবেদ্যর সঙ্গে ব্যক্তিটি খামির দিয়ে তৈরী করা গোটা পাঁউরুটিগুলিও অন্য নৈবেদ্য হিসেবে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","এই সমস্ত রুটির একটি সেই যাজকের, যে মঙ্গল নৈবেদ্যর রক্ত ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","মঙ্গল নৈবেদ্যর মাংস যেদিন উৎসর্গ করা হবে, সেই দিনেই তা খেতে হবে| একজন মানুষ এই উপহার ঈশ্বরের প্রতি কৃতজ্ঞতা জানাতেই দেয়; কিন্তু পরের দিন সকালের জন্য মাংসের একটুও যেন পড়ে না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“কোন মানুষ মঙ্গল নৈবেদ্য আনতে পারে কারণ সে হয়ত ঈশ্বরকে উপহার দিতে চায় অথবা সে হয়ত ঈশ্বরের কাছে বিশেষ মানত করেছিল| যদি এটা সত্য হয় তাহলে যেদিন সে নৈবেদ্য দেয়, সেই দিনেই প্রদত্ত নৈবেদ্য খেয়ে নিতে হবে| যদি কিছু পড়ে থাকে তা পরের দিন অবশ্যই খেতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","কিন্তু যদি এই নৈবেদ্যর কোন মাংস তৃতীয় দিনেও পড়ে থাকে তা আগুনে পুড়িয়ে ফেলতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","যদি কোন ব্যক্তি তৃতীয় দিন তার মঙ্গল নৈবেদ্যর কোন মাংস ভক্ষণ করে তাহলে প্রভু সেই ব্যক্তির প্রতি সন্তুষ্ট হবেন না| তার নৈবেদ্য প্রভু গ্রহণ করবেন না; সেই নৈবেদ্য হবে অশুচি| আর যদি কোন ব্যক্তি সেই মাংসের কিছু ভক্ষণ করে তা হলে সেই ব্যক্তি নিজে তার দোষের জন্য দায়ী হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“অশুচি এমন কোন বস্তুর ছোঁয়া লাগা মাংস অবশ্যই যেন কেউ না খায়; আগুনে এই মাংস পোড়াবে| প্রত্যেকটি শুচি মানুষ মঙ্গল নৈবেদ্য থেকে মাংস খেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","কিন্তু যদি কোন অশুচি ব্যক্তি প্রভুর জন্য নির্দিষ্ট মঙ্গল নৈবেদ্যর মাংস খায়, তা হলে সেই ব্যক্তিকে অবশ্যই তার লোকদের থেকে বিচ্ছিন্ন করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“যদি কোন ব্যক্তি কোন অশুচি জিনিস, যা মানুষের শরীরের দ্বারা অশুচি হয়েছে বা কোন অশুচি জন্তু বা প্রভু নিষেধ করেছেন এমন কোন জিনিস স্পর্শ করে, তাহলে সেই ব্যক্তি অশুচি হবে| এবং যদি সে মঙ্গল নৈবেদ্যর মাংস খায়, তাহলে তাকে অবশ্যই তার লোকদের থেকে আলাদা করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ইস্রায়েলের লোকদের বলো: তোমরা গরু, মেষ বা ছাগলের কোনো চর্বি অবশ্যই খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","যে জন্তু স্বাভাবিক ভাবে মারা গেছে অথবা অন্য জন্তুদের দ্বারা ছিন্ন-বিচ্ছিন্ন হয়ে গেছে, তোমরা সে জন্তুর চর্বি ব্যবহার করতে পার; কিন্তু তোমরা কখনোই তা খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","আগুনে পোড়া জন্তু প্রভুর প্রতি প্রদত্ত যদি কোন ব্যক্তি তার চর্বি খায়, তাহলে সেই ব্যক্তিকে তার সংশ্লিষ্ট লোকদের থেকে বিচ্ছিন্ন হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“তোমরা যেখানেই বাস করো না কেন কখনও কোন পাখির বা কোন জন্তুর রক্ত পান করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","যদি কোন ব্যক্তি রক্ত খায়, তাহলে সেই লোকটিকে অবশ্যই তার লোকদের থেকে বিচ্ছিন্ন হতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ইস্রায়েলের লোকদের বলো: যদি কোন ব্যক্তি প্রভুর কাছে মঙ্গল নৈবেদ্য নিয়ে আসে, তাহলে সেই ব্যক্তি ঐ নৈবেদ্যর অংশ অবশ্যই প্রভুকে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","উপহারের সেই অংশ আগুনে পোড়ানো হবে| সে নিজের হাতে সেই উপহারের অংশ বহন করবে| সেই জন্তুটির চর্বি এবং বক্ষদেশ যাজকের কাছে আনবে| প্রভুর সামনে জন্তুটির বক্ষদেশটি তুলে ধরবে| এটাই হবে দোলনীয় নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","তারপর যাজক বেদীর ওপর চর্বি পোড়াবে; কিন্তু জন্তুর বক্ষদেশ হারোণ এবং তার পুত্রদের অধিকারে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","তোমরা মঙ্গল নৈবেদ্যর ডান দিকের উরুটিও যাজককে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","মঙ্গল নৈবেদ্যর ডান দিকের উরুটি থাকবে সেই যাজকের (হারোণের পুত্রদের) দখলে, যে মঙ্গল নৈবেদ্যর রক্ত আর চর্বি উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","আমি ইস্রায়েলের লোকদের কাছ থেকে দোলনীয় নৈবেদ্যর বক্ষদেশ এবং মঙ্গল নৈবেদ্যর ডান উরু নিচ্ছি এবং সেই বস্তুগুলি আমি হারোণ ও তার পুত্রদের দিয়ে দিচ্ছি| ইস্রায়েলের লোকরা অবশ্যই এই নিয়ম চিরকালের জন্য মেনে চলবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ঐগুলি হল প্রভুকে প্রদত্ত আগুনের তৈরী নৈবেদ্যর অংশ যা হারোণ ও তার পুত্রদের অধিকার| যখনই হারোণ এবং তার পুত্ররা প্রভুর যাজক হয়ে সেবা করবে তারা উৎসর্গগুলির অংশও পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","যাজকদের মনোনীত করার সময় থেকেই প্রভু ঐ সব অংশ যাজকদের দেওয়ার জন্য ইস্রায়েলের লোকদের নির্দেশ দেন| লোকরা অবশ্যই যেন সেই অংশ চিরকালের জন্য যাজকদের দেয়| ");
INSERT INTO ben2006_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ঐগুলি হল হোমবলি, শস্য নৈবেদ্য, পাপমোচনের নৈবেদ্য, দোষমোচনের বলি, মঙ্গল নৈবেদ্য এবং যাজক নির্বাচন সম্পর্কে নিয়মাবলী| ");
INSERT INTO ben2006_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","সীনয় পর্বতের ওপর প্রভু মোশিকে এই আজ্ঞাগুলি দেন| যেদিন প্রভু ইস্রায়েলের লোকদের সীনয় মরুভুমির মধ্যে প্রভুর কাছে তাদের নৈবেদ্যসমূহ আনতে আদেশ দিয়েছিলেন, সেদিনই তিনি ঐ বিধিগুলি জানিয়ে দেন| ");
INSERT INTO ben2006_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“হারোণ ও তার পুত্রদের সঙ্গে নাও| সেই সঙ্গে নাও পোশাক-পরিচ্ছদ, অভিষেকের জন্য তেল, পাপমোচনের নৈবেদ্যর ষাঁড়, দুটি পুরুষ মেষ এবং খামিরবিহীন রুটির ঝুড়ি| ");
INSERT INTO ben2006_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","তারপর লোকদের একসঙ্গে সমাগম তাঁবুর প্রবেশ মুখে নিয়ে এসো|” ");
INSERT INTO ben2006_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","প্রভুর আদেশ মতই মোশি সব কাজ করল| লোকরা সমাগম তাঁবুর প্রবেশ মুখে একসঙ্গে দেখা করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","তখন মোশি লোকদের বলল, “প্রভু আদেশ করেছেন এ হল তাই এবং তা অবশ্য কর্তব্য|” ");
INSERT INTO ben2006_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","তারপর মোশি হারোণ ও তার পুত্রদের নিয়ে এল| জল দিয়ে সে তাদের ধৌত করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","এরপর মোশি হারোণকে বোনা অঙ্গরক্ষিণী পরালো এবং তার কোমরের চারপাশে কটিবন্ধ জড়াল| তারপর মোশি হারোণের গায়ে পোশাক পরিয়ে গায়ে এফোদ জড়াল এবং বোনা পটুকাতে গা বেষ্টন করে তা বাঁধল| এইভাবে মোশি হারোণের গায়ে এফোদ পরাল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","মোশি হারোণের বুকে বক্ষাবরণ পরিয়ে দিল| তারপর সে বক্ষাবরণের ভেতরে উরীম ও তূম্মীম রাখল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","মোশি হারোণের মাথা লম্বা কাপড় জড়ানো পাগড়ি দিয়ে ঢেকে দিল| এক টুকরো সোনা পাগড়ির সামনেটায বসিয়ে দিল| এই সোনার টুকরোটা হল পবিত্র মুকুট| প্রভুর আজ্ঞা মতই মোশি এটা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","এরপর মোশি অভিষেকের তেল নিল এবং পবিত্র তাঁবুর ওপর ও তার ভেতরের সমস্ত জিনিসের ওপর তা ছিটিয়ে দিল| এইভাবে মোশি তাদের পবিত্র করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","মোশি বেদীর ওপর ঐ তেলের কিছুটা সাতবার ছিটিয়ে দিল| মোশি বেদীর ওপর এবং তত্সংলগ্ন থালায়, গামলায় এবং তার তলদেশে তেল ছিটিয়ে সব কিছুকে পবিত্র করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","তারপর কিছুটা অভিষেকের তেল নিয়ে সে হারোণের মাথায় ঢালল, এইভাবে মোশি হারোণকে পবিত্র করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","মোশি এরপর হারোণের পুত্রদের নিয়ে এসে তাদের বোনা অঙ্গরক্ষিণী পরাল| পরে তাদের গায়ে কটিবন্ধ জড়িয়ে দিল| তারপর তাদের মাথায় ফেট্টি বাঁধল| প্রভুর আজ্ঞামতই মোশি এসব করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","এরপর মোশি পাপ মোচন নৈবেদ্যর ষাঁড়টিকে নিয়ে এল| পাপ মোচন নৈবেদ্যর ষাঁড়ের মাথার ওপর হারোণ ও তার পুত্ররা হাত রাখল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","তারপর মোশি ষাঁড়টিকে হত্যা করে তার রক্ত সংগ্রহ করল| মোশি তার আঙুল দিয়ে কিছু রক্ত বেদীর সব কোণে লাগাল| এইভাবে মোশি বেদীটিকে বলির উপযোগী করে তৈরী করল| তারপর সে বেদীর মেঝেয রক্ত ঢেলে দিল| লোকদের পাপ মুক্ত করার জন্য এইভাবে মোশি বেদীটিকে বলির জন্য তৈরী রাখল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","সে যকৃৎ থেকে সব চর্বি বার করে নিল এবং সেই সঙ্গে দুটি বৃক্ক ও তাদের ওপরকার সব চর্বিটুকু নিয়ে সেই বেদীর ওপর তাদের পোড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","কিন্তু মোশি ষাঁড়ের চামড়া, তার মাংস এবং শরীরের বর্জ্য পদার্থকে তাঁবুর বাইরে নিয়ে এল| তাঁবুর বাইরে আগুনে মোশি সেগুলিকে পোড়াল| প্রভুর আজ্ঞামতই মোশি এসব করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","এরপর মোশি হোমবলির জন্য পুরুষ মেষকে নিয়ে এল| হারোণ এবং তার পুত্ররা সেই পুরুষ মেষের মাথায় তাদের হাত রাখল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","মোশি তারপর পুরুষ মেষটিকে হত্যা করল| সে বেদীর চারপাশে ও বেদীর ওপরে পুরুষ মেষটির রক্ত ছিটিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","মোশি পুরুষ মেষটিকে টুকরো টুকরো করে কাটল| সে ভিতরের অংশগুলি ও পা জল দিয়ে ধুয়ে দিল, তারপর বেদীর ওপর গোটা পুরুষ মেষটিকে পোড়াল| মোশি মাথা ও শরীরের টুকরোগুলো এবং চর্বি পোড়াল| এ হল আগুনের তৈরী হোমবলি| এর গন্ধ প্রভুকে খুশী করে| প্রভুর আজ্ঞামত মোশি ঐগুলি করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","তারপর মোশি অন্য পুরুষ মেষটিকে নিয়ে এল| হারোণ আর তার পুত্রদের যাজক হিসাবে নির্দিষ্ট করার জন্যই এই পুরুষ মেষটি ব্যবহার করা হয়েছিল| তারা এই পুরুষ মেষটির মাথায় তাদের হাত রেখেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","এরপর মোশি পুরুষ মেষটিকে হত্যা করল| এর কিছুটা রক্ত সে হারোণের কানের লতিতে, তার ডান হাতের বুড়ো আঙুলে এবং হারোণের ডান পায়ের বুড়ো আঙুলের মাথায় ছোঁয়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","তারপর সে হারোণের পুত্রদের বেদীর কাছাকাছি নিয়ে এল| রক্তের কিছুটা তাদের ডান কানের লতিতে, ডান হাতের বুড়ো আঙুলে এবং ডান পায়ের বুড়ো আঙুলের মাথায় লাগিয়ে দিল| এরপর সে বেদীর চারপাশে রক্ত ছিটিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","এরপর মোশি চর্বি, লেজ, ভিতরের সমস্ত অংশগুলোর চর্বি, যকৃৎ ঢাকা চর্বি, বৃক্ক দুটি এবং তাদের চর্বি এবং ডান দিকের উরু নিল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","প্রত্যেকদিন প্রভুর সামনে এক ঝুড়ি ভর্ত্তি খামিরবিহীন রুটি রাখা হত| মোশি এই রুটিগুলির একটি, তেল মাখানো রুটির একটি ও একটি খামিরবিহীন পাতলা রুটি নিল| সেই সব রুটির টুকরোগুলো মোশি চর্বির ওপর এবং পুরুষ মেষের ডান উরুর ওপর রাখল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","তারপর মোশি সেই সমস্ত কিছু হারোণ ও তার পুত্রদের হাতে দিয়ে দিল| টুকরোগুলোকে মোশি দোলনীয় নৈবেদ্যরূপে প্রভুর সামনে দোলালো| ");
INSERT INTO ben2006_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","তারপর হারোণ ও তার পুত্রদের হাত থেকে সেগুলিকে নিয়ে মোশি বেদীর হোমবলির ওপর পোড়াল| হারোণ ও তার পুত্রদের যাজক হিসাবে নিয়োগ করার জন্যই এই নৈবেদ্য| এ নৈবেদ্য আগুনের দ্বারা তৈরী নৈবেদ্য| এর গন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","মোশি বক্ষদেশটা নিয়ে প্রভুর সামনে তা দোলনীয় নৈবেদ্য হিসেবে দোলাল| যাজকদের নিয়োগ করার ব্যাপারে পুরুষ মেষের এই অংশ হল মোশির অংশ| মোশি প্রভুর আজ্ঞামতই এসব কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","মোশি বেদীর ওপর পড়ে থাকা অভিষেকের তেলের কিছুটা ও কিছুটা রক্ত নিয়ে হারোণের ওপর এবং হারোণের পোশাকের ওপর ছিটিয়ে দিল| হারোণের সঙ্গে সেবারত ছেলেদের এবং তাদের পোশাকের ওপরেও কিছুটা ছিটিয়ে দিল| এইভাবে মোশি হারোণ, তার কাপড়-চোপড়, তার ছেলেদের এবং ছেলেদের কাপড়-চোপড় শুচিশুদ্ধ করল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","তারপর মোশি হারোণ ও তার পুত্রদের জিজ্ঞাসা করল, “আমার আদেশ তোমাদের মনে পড়ে তো? আমি বলেছিলাম, ‘হারোণ এবং তার পুত্ররা এই সমস্ত জিনিস অবশ্যই আহার করবে|’ সুতরাং যাজক নির্বাচনের অনুষ্ঠান থেকে রুটির ঝুড়ি আর মাংস নিয়ে নিও| সমাগম তাঁবুর প্রবেশ মুখে মাংসটাকে সিদ্ধ করো| সেই খানেই মাংস আর রুটি খেও| আমি যা বলছি সেইমতো এটা করো| ");
INSERT INTO ben2006_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","যদি মাংস বা রুটির কোন কিছু পড়ে থাকে তবে তা পুড়িয়ে ফেল| ");
INSERT INTO ben2006_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","যাজক নির্বাচনের অনুষ্ঠান চলবে সাতদিন ধরে| সেই অনুষ্ঠান শেষ না হওয়া পর্যন্ত তোমরা অবশ্যই সমাগম তাঁবুর প্রবেশ পথ ছাড়বে না| ");
INSERT INTO ben2006_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","আজ যা করা হল, প্রভু সেইসব করতেই আজ্ঞা দিয়েছেন| তোমাদের শুচি করতেই তিনি এই সব আজ্ঞা দিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","তোমরা অবশ্যই সমাগম তাঁবুর প্রবেশ মুখে সাতদিন ধরে দিনরাত থাকবে| যদি তোমরা প্রভুর আজ্ঞা না মানো তাহলে তোমরা মারা যাবে| প্রভু আমাকে এইসব আজ্ঞা দিয়েছেন|” ");
INSERT INTO ben2006_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","তাই হারোণ ও তার পুত্ররা প্রভু মোশিকে যা যা করতে আজ্ঞা দিয়েছিলেন সেসবই করল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","আট দিনের দিন মোশি হারোণ ও তার পুত্রদের এবং সেই সাথে ইস্রায়েলের প্রবীণদেরও ডাকল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","মোশি হারোণকে বলল, “একটা ষাঁড় এবং একটা পুরুষ মেষ নিয়ে এসো| এই জন্তুদের মধ্যে অবশ্যই যেন কোন খুঁত না থাকে| ষাঁড়টা হবে পাপ মোচনের নৈবেদ্য আর মেষটা হবে হোমবলির নৈবেদ্য| ঐসব জন্তুদের প্রভুর কাছে নিবেদন করো| ");
INSERT INTO ben2006_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ইস্রায়েলের লোকদের বলো, ‘পাপ মোচনের নৈবেদ্যর জন্য একটি পুরুষ ছাগল নাও এবং হোমবলির জন্য একটি বাছুর ও একটি মেষশাবক নাও| বাছুর ও ছাগ শিশু প্রত্যেকটির বয়স যেন এক বছর হয়| ঐ সমস্ত জন্তুদের মধ্যে অবশ্যই যেন কোন খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","একটা ষাঁড় ও একটা পুরুষ মেষ মঙ্গল নৈবেদ্যর জন্য নাও| ঐসব জন্তু ছাড়াও তেল মেশানো শস্য নৈবেদ্য নেবে এবং এসব প্রভুর কাছে নিবেদন করবে, কারণ আজ প্রভু তোমাদের কাছে আবির্ভূত হবেন|’” ");
INSERT INTO ben2006_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","সুতরাং সমস্ত মানুষ সমাগম তাঁবুর কাছে এলো| মোশি যেমন আদেশ দিয়েছিল তারা সকলে সেই মত জিনিস আনলো| সমস্ত লোক প্রভুর সামনে দাঁড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","মোশি বলল, “প্রভুর আজ্ঞা মতই তোমরা এগুলি করবে আর তখন প্রভুর মহিমা তোমাদের কাছে প্রকাশিত হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","তারপর মোশি হারোণকে বলল, “ইস্রায়েলেও প্রভুর আজ্ঞা মতো কাজগুলি করো| বেদীর কাছে ও এবং পাপ মোচনের নৈবেদ্য ও হোমবলির নৈবেদ্যগুলি নিবেদন করো, যাতে তুমি এবং তোমার লোকরা শুচি হও| লোকদের নৈবেদ্যগুলিও নাও এবং সেইসব পর্বগুলি পালন কর যেগুলি তাদের শুচি করে|” ");
INSERT INTO ben2006_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","সেইজন্য হারোণ বেদীর সামনে এসে পাপমোচনের নৈবেদ্যর জন্য ষাঁড়টাকে হত্যা করলো| এই পাপমোচনের নৈবেদ্য তার নিজেরই জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","তারপর হারোণের পুত্ররা হারোণের কাছে রক্ত আনলো| হারোণ তার আঙুল রক্তে ডুবিয়ে তার বেদীর কোণগুলোয় ছড়িয়ে দিল, তারপর বেদীর মেঝেতে রক্ত ঢেলে দিল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","পাপমোচনের নৈবেদ্য থেকে হারোণ নিল চর্বি, বৃক্কগুলো এবং যকৃতের চর্বি অংশটা। প্রভু যেমন যেমন মোশিকে আজ্ঞা করেছিলেন সেইভাবে সে ঐ জিনিসগুলো বেদীর ওপর পোড়ালো| ");
INSERT INTO ben2006_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","হারোণ এরপর শিবিরের বাইরে আগুনে মাংস আর চামড়া পোড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","পরে হোমবলির জন্য হারোণ জন্তুটিকে হত্যা করে টুকরো টুকরো করে কাটল| হারোণের পুত্ররা হারোণের কাছে রক্ত নিয়ে এলে হারোণ সেই রক্ত বেদীর চারপাশে ছিটিয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","হারোণের পুত্ররা হারোণকে হোমবলির টুকরোগুলো আর মাথাটা দিলে সে সেগুলো বেদীর ওপর পোড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","হোমবলির ভিতরের অংশগুলো আর পাগুলিও ধুয়ে ফেলে সেইসব বেদীর ওপর পোড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","তারপর হারোণ লোকদের নৈবেদ্যগুলি আনল| সে লোকদের পাপের জন্য নৈবেদ্য হিসেবে ছাগলটিকে হত্যা করে প্রথমটার মতই এটিকে নিবেদন করল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","প্রভুর নির্দেশমত সে দগ্ধ নৈবেদ্যটিকে নিয়ে এসে নিবেদন করল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","বেদীর কাছে শস্য নৈবেদ্য নিয়ে এসে সে এক মুঠো শস্য নিল এবং তা রোজ সকালে বেদীর ওপর যে বলি দেওয়া হত তার সাথে সাথে নিবেদন করল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","সে ষাঁড় এবং পুরুষ মেষটিকেও হত্যা করল| এসব হল লোকদের মঙ্গল নৈবেদ্য| হারোণের পুত্ররা হারোণের কাছে রক্ত আনলে সে এই রক্ত বেদীর চারপাশে ছড়িয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","তারা ষাঁড় আর মেষের চর্বি, লেজের চর্বি, ভিতরের অংশে ঢাকা দেওয়া চর্বি, বৃক্কগুলি এবং যকৃতের চর্বি অংশ আনল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","এইসব চর্বিগুলো ষাঁড় আর পুরুষ মেষের বুকের ওপর রাখা হলে হারোণ চর্বি অংশগুলো বেদীর ওপর পোড়াল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","হারোণ মোশির আজ্ঞামতো বক্ষদেশগুলি এবং ডান উরু প্রভুর সামনে দোলনীয় নৈবেদ্য হিসাবে দোলাল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","তারপর লোকদের উদ্দেশ্যে তার হাত ওপরে তুলে তাদের আশীর্বাদ করল| পাপ মোচনের নৈবেদ্য, হোমবলি এবং মঙ্গল নৈবেদ্য শেষ করার পর হারোণ বেদী থেকে নেমে এল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","মোশি এবং হারোণ সমাগম তাঁবুর ভিতরে এল| পরে তারা বাইরে এসে লোকদের আশীর্বাদ করল| তারপর প্রভুর মহিমা সমস্ত লোকের সামনে আবির্ভুত হল| ");
INSERT INTO ben2006_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","প্রভুর কাছ থেকে অগ্নি নির্গত হয়ে বেদীর ওপরকার হোমবলি ও চর্বি দগ্ধ করল| তখন সমস্ত মানুষ সেই নৈবেদ্য দহন দেখে চিৎকার করে উঠলো এবং মাটির দিকে মুখ নীচু করলো| ");
INSERT INTO ben2006_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","তারপর হারোণের পুত্ররা, নাদব ও অবীহূ ধূপ জ্বালাবার ধূপদানী নিলো| এবং ভিন্ন আগুন ব্যবহার করে সেই সুগন্ধী প্রজ্বলিত করলো| মোশি তাদের যে আগুন ব্যবহার করতে নির্দেশ দিয়েছিল সেই আগুন তারা ব্যবহার করেনি| ");
INSERT INTO ben2006_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","তাই প্রভুর কাছ থেকে আগুন নেমে এসে নাদব ও অবীহূকে ধ্বংস করল| প্রভুর সামনেই তারা মৃত্যু বরণ করলো| ");
INSERT INTO ben2006_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","তখন মোশি হারোণকে বলল, “প্রভু বলেন, ‘যে সমস্ত যাজক আমার নিকটে আসে, তারা অবশ্যই আমাকে শ্রদ্ধা করবে| আমি অবশ্যই তাদের কাছে পবিত্র হিসেবে মান্য হবো এবং সমস্ত মানুষের কাছে অবশ্যই মহিমান্বিত হবো|’” তাই তার পুত্রদের মৃত্যু নিয়ে হারোণ নীরব রইল| ");
INSERT INTO ben2006_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","হারোণের কাকা উষীয়েলের দুটি পুত্র ছিল| তারা হল মীশাযেল ও ইলীষাফণ| মোশি সেই দুই পুত্রকে বলল, “পবিত্র স্থানটির সামনে গিয়ে তোমাদের জ্য়াঠতুতো ভাইদের দেহ শিবিরের বাইরে নিয়ে ও|” ");
INSERT INTO ben2006_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","তখন মীশাযেল ও ইলীষাফণ মোশিকে মান্য করলো| তারা নাদব ও অবীহূর দেহ শিবিরের বাইরে বয়ে নিয়ে গেলো| নাদব ও অবীহূ তখনও বিশেষ ধরণের সুতোর জামা পরে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","তখন মোশি হারোণের অন্য পুত্র ইলীয়াসর ও ঈথামরকে বলল, “কোনো বিষন্নতা দেখিও না! তোমাদের পোশাক ছিঁড়ো না অথবা মাথার চুল এলোমেলো করো না| বিষন্নতা না দেখালে তোমরা নিহত হবে না| এবং প্রভু বাকী সকলের ওপর ক্রুদ্ধ হবেন না| ইস্রায়েলের সমস্ত মানুষ তোমাদের আত্মীয়| প্রভু নাদব ও অবীহূকে দগ্ধ করেছেন–এ নিয়ে তারা শোক করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","কিন্তু তোমরা অবশ্যই সমাগম তাঁবু, এমনকি, তার প্রবেশ পথ ত্যাগ করবে না| ত্যাগ করলে তোমরা মারা যাবে| কারণ প্রভুর অভিষেকের তেল তোমাদের ওপর ঢালা হয়েছে|” তখন হারোণ, ইলীয়াসর এবং ঈথামর মোশিকে মান্য করল| ");
INSERT INTO ben2006_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","তারপর প্রভু হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“যখন তোমরা সমাগম তাঁবুর মধ্যে আসবে তখন তুমি আর তোমার পুত্ররা অবশ্যই দ্রাক্ষারস পান করবে না| যদি তোমরা ঐসব জিনিস পান কর, তাহলে তোমরা মারা যাবে| এই বিধি তোমাদের বংশপরম্পরায় চিরকালের জন্য চলতে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","তোমাদের অবশ্যই পবিত্র ও অপবিত্র এবং শুচি ও অশুচি বিষয়ের মধ্যে পরিষ্কারভাবে পার্থক্য করে নিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","প্রভু মোশির মাধ্য়মে লোকদের সেইসব বিধি জানিয়ে দিলেন, তুমি লোকদের ঐসব বিধি সম্পর্কে অবশ্যই অবহিত করবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","হারোণের দুই পুত্র ইলীয়াসর ও ঈথামর তখনও জীবিত ছিল| মোশি হারোণ ও তার দুই পুত্রকে বলল, “আগুনে পোড়ানো উপহারগুলির মধ্যে কিছু শস্য নৈবেদ্য পড়ে আছে| তোমরা শস্য নৈবেদ্যর সেই অংশ আহার করবে, কিন্তু অবশ্যই তাতে খামির যোগ করবে না| বেদীর কাছেই সেটা খাও, কারণ সেই নৈবেদ্য অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","নৈবেদ্যর এই অংশ প্রভুর উদ্দেশ্যে আগুনে পোড়ানো হয়েছিল, এবং যে বিধি আমি তোমাদের জানিয়েছি তা শেখায় যে এই অংশ তোমার ও তোমার পুত্রদের জন্যই; কিন্তু অবশ্যই তোমরা একটা পবিত্র স্থানে তা আহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“তাছাড়া তুমি, তোমার ছেলেরা এবং মেয়েরা দোলনীয় নৈবেদ্যসমূহের বক্ষদেশ এবং উরুর অংশ আহার করতে পারবে| এসব তোমাদের পবিত্র জায়গায় খেতে হবে না| কিন্তু তা অবশ্যই পরিচ্ছন্ন জায়গায় খেতে হবে| কারণ সেগুলি আসে মঙ্গল নৈবেদ্যসমূহ থেকে| ইস্রায়েলের লোকরা ঈশ্বরকে যে উপহার দেয় তা থেকে এই অংশ তোমার ও তোমার সন্তানদের প্রাপ্য বলে ধরা হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","লোকরা অবশ্যই আগুনে পোড়ানো বলির অংশ হিসেবে জন্তুদের চর্বি, মঙ্গল নৈবেদ্যর উরু এবং দোলনীয় নৈবেদ্যর বক্ষদেশ নিয়ে আসবে| প্রভুর সামনে দোলানো হলে নৈবেদ্যর সেই অংশ প্রভুর আজ্ঞা অনুসারে চিরকাল তোমার ও তোমার সন্তানসন্ততিদের অধিকারে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","মোশি পাপার্থক নৈবেদ্য ছাগলের খোঁজ করল, কিন্তু তা ইতিমধ্যে পোড়ানো হয়ে গিযেছিল| এতে মোশি হারোণের পুত্র ইলীয়াসর ও ঈথামরের ওপর অত্যন্ত ক্রুদ্ধ হল| মোশি বলল, ");
INSERT INTO ben2006_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“সেই ছাগটিকে পবিত্র স্থানে খাওয়া তোমাদের উচিৎ‌ ছিল| এটা অত্যন্ত পবিত্র| কেন তোমরা প্রভুর সামনে তা খেলে না? প্রভু তোমাদের তা দিয়েছিলেন লোকদের দোষের প্রায়শ্চিত্ত করার জন্য, লোকদের পবিত্র করার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","সেই ছাগলের রক্ত পবিত্র জায়গায় (তাঁবুর মধ্যেকার পবিত্র ঘরে) আনা হয় নি| তাই তোমাদের উচিৎ‌ ছিল আমি যেমন আদেশ দিয়েছিলাম, সেইভাবে পবিত্র জায়গায় মাংস আহার করা|” ");
INSERT INTO ben2006_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","কিন্তু হারোণ মোশিকে বলল, “দেখুন আজ তারা পাপ মোচনের নৈবেদ্য ও হোমবলির নৈবেদ্য প্রভুর কাছে এনেছিল| আর আপনি জানেন আজ আমার ভাগ্যে কি ঘটেছে| আপনি কি মনে করেন আমি আজ পাপ মোচনের নৈবেদ্য খেলে তা প্রভুকে খুশী করতো? না!” ");
INSERT INTO ben2006_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","মোশি তা শুনল এবং মেনে নিল| ");
INSERT INTO ben2006_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","প্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ইস্রায়েলের লোকদের বলো: এই সমস্ত জন্তু তোমরা আহার করতে পারো: ");
INSERT INTO ben2006_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","যে সব জন্তুর পায়ের খুর দুভাগে ভাগ করা, সেইসব জন্তু যদি জাবর কাটে তা হলে তোমরা সেই জন্তুর মাংস খেতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“কিছু জন্তু আবার জাবর কাটে কিন্তু তাদের পায়ের খুর দু’ভাগ করা নয়, তোমরা সে সব জন্তু খাবে না| উট, পাহাড়ের শাফন এবং খরগোশ হল সেই রকম| তাই তারা তোমাদের পক্ষে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","অন্য কিছু জন্তুদের পায়ের খুর দু’ভাগ করা, কিন্তু তারা জাবর কাটে না, ঐসব জন্তু খাবে না| শূকর সেই ধরণের, সুতরাং তারা তোমাদের পক্ষে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ঐসব প্রাণীর মাংস খাবে না| এমনকি তাদের মৃত দেহও স্পর্শ করবে না, তা তোমাদের পক্ষে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“যদি কোন প্রাণী সমুদ্রে বা নদীতে বাস করে এবং যদি প্রাণীটির পাখনা ও আঁশ থাকে, তাহলে তোমরা সেই প্রাণী খেতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","কিন্তু সমুদ্রে বা নদীতে বাস করে এমন কোন প্রাণীর যদি ডানা ও আঁশ না থাকে তাহলে সেই প্রাণী তোমরা অবশ্যই খাবে না| এই ধরণের প্রাণী আহারের পক্ষে অনুপযুক্ত| সেই প্রাণীর মাংস তোমরা খাবে না, এমন কি তার মৃত শরীরও স্পর্শ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","জলচর যে কোন প্রাণী যার পাখনা এবং আঁশ নেই, তাকে প্রভু আহারের জন্য অনুপযুক্ত বলেছেন বলেই মনে করেন| ");
INSERT INTO ben2006_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ঈশ্বর যে সব পাখী খাওয়ার পক্ষে অনুপযুক্ত বলেছেন, তোমরা অবশ্যই সেইসব পাখীদের অখাদ্য বলে গণ্য করবে| এই পাখীগুলি তোমরা খাবে না: ঈগল, শকুনি, শিকারী পাখী, ");
INSERT INTO ben2006_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","চিল এবং সব ধরণের বাজ পাখী| ");
INSERT INTO ben2006_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","সমস্ত জাতের কালো পাখী, ");
INSERT INTO ben2006_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","উট পাখী, রাতের বাজ পাখী, শঙ্খচিল, সব জাতের শ্যেন পাখী, ");
INSERT INTO ben2006_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","পেঁচা, লিপ্তপদ সামুদ্রিক পাখী, বড় পেঁচা, ");
INSERT INTO ben2006_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","হংসী, জলচর প্যানিভেলা, শবভূক শকুনি, ");
INSERT INTO ben2006_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","সারস, সমস্ত জাতের সারস, ঝুঁটিওযালা পাখী এবং বাদুড়| ");
INSERT INTO ben2006_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“বুকে হাঁটা ক্ষুদ্র কোন প্রাণীর যদি ডানা থাকে, তাহলে সেগুলিকে তোমরা খাবে না কারণ প্রভু তা নিষেধ করেছেন| ঐ সমস্ত পোকামাকড় খেও না| ");
INSERT INTO ben2006_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","কিন্তু তোমরা সেইসব পোকামাকড় খেতে পার যারা সন্ধিপদ এবং লাফাতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","সমস্ত রকম পঙ্গপাল, সমস্ত রকমের ডানাওযালা পঙ্গপাল, সমস্ত রকমের ঝিঁঝি পোকা আর সব জাতের গঙ্গা ফড়িং তোমরা খেতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“কিন্তু অন্য আর সব ক্ষুদ্র প্রাণী যাদের ডানা আছে কিন্তু বুকে হেঁটে চলে, তোমরা অবশ্যই সেসব খাবে না, কারণ প্রভু তা নিষিদ্ধ করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","সেই সমস্ত ক্ষুদ্র প্রাণীরা তোমাদের অশুচি করবে| যে তাদের মৃত দেহ স্পর্শ করবে, সন্ধ্যা না হওয়া পর্যন্ত সে অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","যদি কোন ব্যক্তি সেই মৃত পোকামাকড়দের স্পর্শ করে, তাহলে সে অবশ্যই তার কাপড়-চোপড় ধুয়ে ফেলবে| সন্ধ্যা না হওয়া পর্যন্ত সে অশুচি হয়ে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“কিছু প্রাণীর পায়ের খুর দুভাগে ভাগ করা কিন্তু খুরগুলি সত্যিকারের দুটি অংশ নয়| আবার তারা জাবর কাটে না, এসব প্রাণী তোমাদের পক্ষে অশুচি| যে কোন ব্যক্তি তাদের স্পর্শ করলে অশুচি হবে| সন্ধ্যা না হওয়া পর্যন্ত সেই ব্যক্তিটি অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","যদি কোন ব্যক্তি তাদের মৃত দেহ সরায়, সে অবশ্যই তার পোশাক-পরিচ্ছদ ধুয়ে নেবে| সেই মানুষটি সন্ধ্যা না হওয়া পর্যন্ত অশুচি থাকবে| ঐ সমস্ত প্রাণী তোমাদের কাছে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“এই সমস্ত বুকে হাঁটা প্রাণীরা তোমাদের কাছে অশুচি: ছুঁচো, ইঁদুর সমস্ত জাতের বড় টিকটিকি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","গোসাপ, কুমির, টিকটিকি, বালির সরীসৃপ এবং গিরগিটি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ঐ সমস্ত বুকে হাঁটা প্রাণীরা তোমাদের কাছে অশুচি| কোন মানুষ তাদের মৃতদেহ স্পর্শ করলে সন্ধ্যা না হওয়া পর্যন্ত সে অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“যদি ঐ সমস্ত অশুচি প্রাণীদের কোন একটা মরে কোন কিছুর ওপর পড়ে, তাহলে সেই জিনিসটিও অশুচি হবে| সেই জিনিসটি কাঠের তৈরী কোন পাত্র, কাপড়, চামড়া, শোকের পোশাক দিয়ে তৈরী কাজের কোন হাতিযার হতে পারে| এটা যাইহোক্ তা অবশ্যই জলে ধুতে হবে| সন্ধ্যা না হওয়া পর্যন্ত তা অশুচি থাকবে| তারপর তা আবার শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","যদি ঐ সমস্ত অশুচি প্রাণীদের কোন একটা মারা যায় এবং মাটির তৈরী পাত্রের ওপর পড়ে, তাহলে পাত্রের ভেতরের যে কোনো জিনিস অশুচি হয়ে যাবে এবং তোমরা অবশ্যই পাত্রটাকে ভেঙ্গে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","যদি অশুচি মাটির পাত্রের জল কোন খাদ্যের ওপর পড়ে, তাহলে সেই খাবার অশুচি হবে| অশুচি পাত্রের যে কোন পানীয় অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","যদি মৃত অশুচি প্রাণীর কোন অঙ্গ কোন কিছুর ওপর পড়ে, তাহলে সেই জিনিসটা অশুচি হবে| এটা মাটির উনুন অথবা রুটি সেঁকার মাটির পাত্র হলে তা অবশ্যই ভেঙ্গে টুকরো করে ফেলতে হবে| সেই সমস্ত জিনিস আর শুচি করা যাবে না| সেগুলি তোমাদের কাছে সবসময়েই অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“কোন ঝর্ণা বা জল জমে এমন কোন কূপ শুচি থাকলেও যে মানুষ কোন অশুচি প্রাণীর দেহ স্পর্শ করে সে অশুচি হয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","যদি মৃত অশুদ্ধ প্রাণীদের কোনো অংশ বপন করার কোন বীজের ওপর পড়ে, তাহলে সেই বীজ তখনও শুচিই থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","কিন্তু তোমরা যদি বীজের ওপর জল ঢালো এবং তারপর যদি অশুচি প্রাণীদের কোন অঙ্গ ঐসব বীজের ওপর পড়ে তা হলে তোমাদের পক্ষে ঐ সমস্ত বীজ অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“তাছাড়া তুমি খাদ্য হিসেবে ব্যবহার করো এমন কোন প্রাণী যদি মারা যায়, তাহলে যে তার মৃত শরীর স্পর্শ করবে, সন্ধ্যা না হওয়া পর্যন্ত সে অশুচি রইবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","এবং যে এই প্রাণীদেহ থেকে মাংস খাবে তাকে অবশ্যই তার কাপড় চোপড় ধুতে হবে| সন্ধ্যা না হওয়া পর্যন্ত এই ব্যক্তিটি অশুচি থেকে যাবে| যে ব্যক্তি প্রাণীটির মৃতদেহ তোলে তাকে অবশ্যই তার পোশাক-পরিচ্ছদ ধুতে হবে এবং সেই লোকটি সন্ধ্যা না হওয়া পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“যে সব প্রাণী মাটির ওপর বুকে হেঁটে যায়, সেইসব প্রাণীদের তোমরা আহার করবে না| তোমরা সে প্রাণী অবশ্যই খাদ্য হিসেবে গ্রহণ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","পেটের ওপর ভর দিয়ে হাঁটা অথবা চার পা দিয়ে হাঁটা সরীসৃপ বা যে সমস্ত প্রাণীর অনেকগুলো পা তাদের অবশ্যই আহার করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ঐ সমস্ত প্রাণী তোমাদের যেন নোংরা না করে| তোমরা অশুচি হয়ো না, ");
INSERT INTO ben2006_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","কারণ আমিই তোমাদের প্রভু ঈশ্বর! আমি পবিত্র, তাই তোমরাও তোমাদের নিজেদের পবিত্র রেখো| ঐ সমস্ত বুকে হাঁটা প্রাণীদের সংস্পর্শে নিজেদের অশুচি করো না| ");
INSERT INTO ben2006_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","আমি তোমাদের মিশর থেকে এনেছি যাতে তোমরা আমার বিশিষ্ট লোকজন হতে পারো এবং আমি তোমাদের ঈশ্বর হতে পারি| আমি পবিত্র তাই তোমরাও অবশ্যই পবিত্র হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","এই সমস্ত নিয়মাবলী পশু, পাখী, সমুদ্রের সমস্ত প্রাণী এবং মাটির ওপর বুকে হাঁটা সমস্ত প্রাণীদের ক্ষেত্রে প্রযোজ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ঐ সমস্ত উপদেশ সাধারণ মানুষকে শুচি প্রাণীদের থেকে অশুচি প্রাণীদের আলাদা করতে সাহায্য করবে যেন তারা জানতে পারে কোন প্রাণীদের আহার করা এবং কোন প্রাণীদের আহার না করা উচিৎ‌| ");
INSERT INTO ben2006_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ইস্রায়েলের লোকদের বলো: যদি একজন স্ত্রীলোক একটি শিশু পুত্রের জন্ম দেয়, তাহলে সেই স্ত্রীলোকটি সাতদিন ধরে অশুচি থাকবে| তার মাসিকের রক্ত পাতের অশুচি সময়ের মতই হবে এই অশুচিতা| ");
INSERT INTO ben2006_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","অষ্টম দিনে অবশ্যই শিশু পুত্রটিকে সুন্নত করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","তারপর তার রক্তক্ষয় থেকে সে শুচি হবে 33 দিন পর| যা কিছু পবিত্র অবশ্যই তার কোনো কিছুই সে স্পর্শ করতে পারবে না| যতক্ষণ না তার শুচিকরণ শেষ হচ্ছে, সে অবশ্যই কোন পবিত্র স্থানে ঢুকতে পাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","কিন্তু যদি স্ত্রীলোকটি এক শিশুকন্যার জন্ম দেয়, তাহলে তার মাসিক সময়ের রক্তপাতের মতই দু সপ্তাহ ধরে সে অশুচি থাকবে| তার রক্তক্ষয় থেকে 66 দিন পর্যন্ত কাটিয়ে সে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“শুচিকরণের সময় শেষ হলে একটি শিশু কন্যা বা পুত্রের নতুন প্রসূতি, সমাগম তাঁবুতে অবশ্যই বিশেষ ধরণের উৎসর্গ আনবে| সে সমাগম তাঁবুর প্রবেশ পথে যাজককে অবশ্যই ঐসব উৎসর্গ বস্তুগুলি দেবে| দগ্ধ নৈবেদ্যর জন্য আনতে হবে এক বছর বয়সী মেষশাবক এবং একটি ঘুঘু পাখী বা বাচ্চা পায়রা আনবে পাপ মোচনের নৈবেদ্যর জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","যদি স্ত্রীলোকটি একটি মেষ দিতে অক্ষম হয় তবে সে দুটি ঘুঘু বা দুটি বাচ্চা পায়রা আনতে পারে| একটি পাখী হবে হোমবলির জন্য নির্দিষ্ট আর একটি পাপ মোচনের নৈবেদ্যর জন্য| যাজক ঐ সমস্ত নৈবেদ্য প্রভুর কাছে নিবেদন করে তাকে পাপমুক্ত করবে| এবং সে তার রক্তক্ষয়ের থেকে শুচি হবে| এগুলি হল একজন নারীর জন্য নির্দিষ্ট নিয়মাবলী, যে নারী একটি শিশু পুত্র বা এক শিশু কন্যার জন্ম দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","প্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“কোন লোকের চামড়া যদি ফুলে থাকে বা তাতে খোস পাঁচড়া অথবা চক্চকে দাগের মতো কিছু থাকে, যদি ক্ষত অংশটা কুষ্ঠ রোগের ঘায়ের মতো দেখতে হয়, তাকে অবশ্যই যাজক হারোণ বা তার যাজক পুত্রদের কাছে আনতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","চামড়ার ক্ষত স্থানটিকে যাজক অবশ্যই দেখবে| যদি ক্ষতের মধ্যেকার লোম সাদা হয়ে ওঠে এবং যদি চামড়ার ওপর থেকে ক্ষতস্থানটিকে গর্তের মতো মনে হয়, তবে তা কুষ্ঠরোগ| যাজক লোকটিকে দেখা শেষ করে তাকে অশুচি বলে ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“কিন্তু চামড়ায় সাদা দাগ যদি গভীর না হয় এবং ক্ষতস্থানের লোম যদি সাদা না হয় তাহলে সাত দিনের জন্যে যাজক সেই মানুষটিকে অন্য সব লোকদের থেকে আলাদা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","সাত দিনের দিন যাজক অবশ্যই লোকটাকে দেখবে| যাজক যদি দেখে বোঝে যে ক্ষতস্থানের কোনো পরিবর্তন হয় নি এবং তা চামড়ার ওপর ছড়িয়ে পড়েনি, তাহলে আরও সাত দিনের জন্য লোকটাকে আলাদা করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","সাত দিন পর যাজক লোকটিকে আবার দেখবে| যদি ক্ষতস্থানটি শুকিয়ে র এবং চামড়ার ওপর না ছড়ায়, তখন যাজক সেই লোকটিকে শুচি বলে ঘোষণা করবে| এক্ষেত্রে ক্ষতস্থানটি শুধু হল খোস-পাঁচড়ার, সুতরাং লোকটি অবশ্যই তার কাপড়-চোপড় পরিষ্কার করে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“কিন্তু যদি লোকটি যাজকের কাছে নিজেকে শুচি দেখানোর পরে ক্ষতস্থানটি চামড়ায় আরও ছড়িয়ে পড়তে দেখে তা হলে লোকটি অবশ্যই যাজকের কাছে আবার আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","যাজক আবার দেখবে যে ক্ষতস্থানটি চামড়ার ওপর ছড়িয়ে গেছে কিনা, আর তাহলে যাজক তাকে অশুচি বলে ঘোষণা করবে| সেটা তাহলে কুষ্ঠরোগ| ");
INSERT INTO ben2006_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“যদি কোনো ব্যক্তির কুষ্ঠরোগ থাকে তাহলে তাকে অবশ্যই যাজকের কাছে আনতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","যাজক অবশ্যই লোকটিকে দেখবে যে চামড়ার ওপর কোন সাদা ফোলা অংশ আছে কিনা এবং লোমটাও সাদা হয়ে গেছে কিনা| যদি চামড়ার লোম সাদা হয়ে যায় এবং চামড়ার ফোলা জায়গা কাঁচা থাকে, ");
INSERT INTO ben2006_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তাহলে তা কুষ্ঠরোগ| দীর্ঘ দিন ধরে যা লোকটির চামড়ায় থেকে গেছে, যাজক অবশ্যই তাকে অশুচি বলে ঘোষণা করবে| তাকে অন্য লোকদের থেকে অল্প সময়ের জন্য আলাদা করার প্রয়োজন নেই, কারণ লোকটি অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“কখনও কখনও মাথা থেকে পা পর্যন্ত সারা শরীরে চর্মরোগ ছড়াতে পারে| সুতরাং যাজক অবশ্যই লোকটির সারা শরীর দেখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","যদি যাজক দেখে যে চর্মরোগ সমস্ত শরীরে ছড়িয়ে গেছে এবং লোকটার চামড়া সাদা হয়ে গিযেছে, তাহলে যাজক অবশ্যই তাকে শুচি বলে ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","কিন্তু যদি লোকটির চামড়া কাঁচা হয় তাহলে সে শুচি নয়| ");
INSERT INTO ben2006_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","যখন যাজক কোনো মানুষের চামড়া কাঁচা দেখে, সে অবশ্যই লোকটিকে অশুচি ঘোষণা করবে| কাঁচা চামড়া শুচি নয়| এটা হল কুষ্ঠরোগ| ");
INSERT INTO ben2006_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“যদি কাঁচা চামড়া বদলায় এবং সাদা হয়ে যায়, তাহলে লোকটিকে যাজকের কাছে আসতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","যাজক লোকটিকে অবশ্যই দেখবে| যদি সংক্রামিত জায়গা সাদা হয়, তাহলে যাজক লোকটিকে অবশ্যই শুচি বলে ঘোষণা করবে| ঐ লোকটি শুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“কোন ব্যক্তির চামড়ার ওপর ফোড়া হতে পারে এবং সে ফোড়া সেরে যেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","পরে সেই ফোঁড়ার স্থানে সাদা রঙের ফোলা বা দগ্দগে লাল ডোরা টানা সাদা দাগ হতে পারে| লোকটি ঐ দাগ তখন যাজককে অবশ্যই দেখাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","যাজক অবশ্যই তা দেখবে| যদি ফোড়াটা চামড়া থেকে গর্তের মতো হয় এবং এর ওপরকার লোম সাদা হয়, তাহলে যাজক লোকটিকে অবশ্যই অশুচি ঘোষণা করবে| চিহ্নিত জায়গাটায় কুষ্ঠের ঘা শুরু হয়েছে| চামড়ায় এই ফোঁড়াটার ভেতর থেকে কুষ্ঠ রোগ ছড়িয়ে পড়েছে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","কিন্তু যদি যাজক জায়গাটায় কোন সাদা লোম না দেখে আর জায়গাটা চামড়ার মধ্যে গর্ত না করে থাকে, বরং যদি দেখা যায় শুকিয়ে যাচ্ছে, তাহলে যাজক লোকটাকে সাত দিনের জন্যে আলাদা করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","যদি চামড়ার আরও অংশে দাগ ছড়ায় তা হলে যাজক সেই লোকটিকে অবশ্যই অশুচি ঘোষণা করবে| এটা হল ঘা| ");
INSERT INTO ben2006_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","কিন্তু যদি চক্চকে দাগটি এক জায়গাতেই থাকে এবং না ছড়ায় তা হলে বুঝতে হবে তা পুরানো ফোঁড়ারই ক্ষতচিহ্ন| যাজক অবশ্যই তাকে শুচি ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“কোন ব্যক্তির চামড়া আগুনে পুড়ে যেতে পারে| যদি চামড়ার কাঁচা অংশটি সাদা অথবা লাল ডোরাকাটা সাদা অংশ হয়, যাজক অবশ্যই তা দেখবে| যদি সাদা অংশটা চামড়ায় গর্তের মতো হয় এবং ঐ জায়গাটার লোম সাদা হয়ে যায় তাহলে তা কুষ্ঠরোগ| পোড়া অংশে কুষ্ঠ ছড়িয়ে পড়েছে| যাজক অবশ্যই ঐ লোকটিকে অশুচি ঘোষণা করবে| এটা হল কুষ্ঠরোগ| ");
INSERT INTO ben2006_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","কিন্তু যদি সেই চক্চকে জায়গায় কোনো সাদা লোম না থাকে এবং ক্ষতস্থানটা চামড়ায় গর্ত সৃষ্টি না করে মিলিয়ে যায়, তাহলে যাজক অবশ্যই সাত দিনের জন্য লোকটাকে আলাদা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","সাত দিনের দিন যাজক লোকটাকে আবার দেখবে| যদি ক্ষতস্থানটা চামড়ার ওপর ছড়িয়ে যায়, তাহলে যাজক ঘোষণা করবে যে লোকটা অশুচি| এটা কুষ্ঠরোগ| ");
INSERT INTO ben2006_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","কিন্তু যদি চক্চকে দাগটি চামড়ায় না ছড়ায় এবং মিলিয়ে যায় তাহলে পোড়ার জন্যেই ফুলেছে বুঝতে হবে| এটা কেবলমাত্র পোড়ার ক্ষতচিহ্ন| যাজক অবশ্যই সেই ব্যক্তিকে শুচি বলে ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“কোন ব্যক্তির মাথার চামড়ায় বা দাড়িতে ঘা হলে, ");
INSERT INTO ben2006_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","যাজক চামড়ার এই সংক্রমণ অবশ্যই দেখবে| যদি চামড়া থেকে সংক্রমণের জায়গাটা গর্তের মতো হয় এবং যদি তার চারপাশের লোম হয় পাতলা ও হলদে, তাহলে যাজক সেই মানুষটিকে অবশ্যই অশুচি ঘোষণা করবে| এটা দাদ, খারাপ চর্মরোগ| ");
INSERT INTO ben2006_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","যদি রোগটা চামড়ার থেকে গর্ত হওয়ার মতো মনে না হয়, কিন্তু সেখানে কোনো কালো লোম না থাকে, তখন যাজক অবশ্যই লোকটিকে সাত দিনের জন্যে আলাদা করে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","সাতদিনের মাথায় যাজক সংক্রামিত জায়গাটা দেখবে| যদি রোগটা না ছড়ায় এবং সেখানে কোন হলদে লোম না জন্মায় এবং রোগটা চামড়া থেকে গর্তের মতো না হয়, ");
INSERT INTO ben2006_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তাহলে লোকটা নিশ্চয়ই নিজেকে কামিয়ে নেবে; কিন্তু সে রোগের জায়গাটা কখনও কামাবে না| যাজক অবশ্যই লোকটিকে আরও সাত দিন আলাদা করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","সাত দিনের মাথায় যাজক অবশ্যই রোগটাকে দেখবে| যদি গোটা চামড়ায় রোগটা না ছড়ায় এবং যদি চামড়া থেকে সেটাকে গর্তের মত মনে না হয়, তাহলে যাজক লোকটিকে শুচি বলে ঘোষণা করবে| লোকটি অবশ্যই তার কাপড়-চোপড় ধৌত করবে এবং শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","কিন্তু শুচি হওয়ার পর লোকটির রোগ যদি চামড়ায় ছড়ায়, ");
INSERT INTO ben2006_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","তখন যাজক লোকটিকে আবার দেখবে| যদি রোগটা চামড়ায় ছড়িয়ে যায় যাজক হলুদ রঙের লোম দেখার প্রয়োজন বোধ করবে না| লোকটা অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","কিন্তু যদি যাজক মনে করে যে রোগটা সেরে গেছে এবং তার মধ্যে কালো লোম গজাতে শুরু করেছে, তাহলে রোগটা সেরে গেছে| লোকটা শুচি| যাজক অবশ্যই ঘোষণা করবে যে লোকটা শুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“যদি কোন লোমের চামড়ায় সাদা সাদা দাগ থাকে, ");
INSERT INTO ben2006_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","তাহলে যাজক অবশ্যই ঐ সব দাগের জায়গাগুলো দেখবে| যদি লোকটার চামড়ায় ওপরকার দাগগুলো কেবলমাত্র অনুজ্জ্বল সাদাটে হয় তাহলে তা শুধুমাত্র ফুসকুড়ি বা ক্ষতিকারক নয়| ঐ ধরণের লোক শুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“কোন মানুষের মাথার চুল পড়ে যেতে পারে; সে শুচি, এটা শুধু টাক পড়া| ");
INSERT INTO ben2006_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","কোন মানুষের মাথার দুপাশ থেকে চুল উঠে যেতে পারে; সে শুচি| এটা শুধুমাত্র আর এক ধরণের টাক পড়া| ");
INSERT INTO ben2006_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","কিন্তু যদি তার মাথার টাক পড়া চামড়ায় কোন লাল এবং সাদা দাগ থাকে, তাহলে তা চামড়ারই কোন রোগ বুঝতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","একজন যাজক অবশ্যই তাকে দেখবে| যদি সংক্রামিত ফোঁড়াটা লাল এবং সাদা হয়, আর যদি শরীরের অন্য সব অংশে কুষ্ঠ রোগের মতো দেখায় ");
INSERT INTO ben2006_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","তাহলে বুঝতে হবে লোকটির মাথার খুলিতে কুষ্ঠ হয়েছে, লোকটা অশুচি| যাজক অবশ্যই লোকটিকে অশুচি ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“যদি এক ব্যক্তির কুষ্ঠ রোগ থাকে, তাহলে সেই ব্যক্তি অন্য লোকদের সাবধান করে দেবে| সেই লোকটি চেঁচিয়ে বলবে, “অশুচি, অশুচি|” লোকটির কাপড়ের দুই ধারের জোড়া অবশ্যই ছিঁড়ে ফেলা হবে| সে তার চুল অবিন্যস্ত করবে এবং মুখ ঢাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","যতক্ষণ তার সংক্রামক ব্যাধি থাকবে ততক্ষণ লোকটি হবে অশুচি| সে অবশ্যই একা থাকবে| তার বাড়ী অবশ্যই শিবিরের বাইরে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“কিছু পোশাকের ওপর ছাতা পড়তে পারে| কাপড়টা মসীনা সুতোর অথবা উলে তৈরী, তাঁতে বোনা বা হাতে বোনা হতে পারে| এক টুকরো চামড়ার ওপর বা চামড়া থেকে তৈরী কোন জিনিসের ওপরেও ছাতা পড়তে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","যদি ঐ ছত্রাকের রঙ সবুজ বা লাল হয় তাহলে এটা অবশ্যই একজন যাজককে দেখাতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","যাজক অবশ্যই ছাতা পড়া অংশটা দেখবে এবং সেই জিনিসটাকে আলাদা জায়গায় সাতদিন ধরে ফেলে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","সাত দিনের মাথায় যাজক অবশ্যই ছাতা পড়া অংশটি দেখবে| ছাতা পড়া অংশটা চামড়ার বা কাপড়ের ওপর হোক্ তাতে তেমন কিছু যায় আসে না| যদি পোশাক তাঁতে বোনা বা হাতে বোনা হয় তাতেও কিছু যায় আসে না বা চামড়া কিসে ব্যবহৃত হচ্ছে সেটাও কোন ব্যাপার নয়| যদি ছাতা পড়া অংশটা ছড়ায় তাহলে সেই কাপড় বা চামড়া অশুচি| সংক্রামনটি অশুচি| যাজক অবশ্যই সেই কাপড় ও চামড়া পুড়িয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“যদি যাজক দেখে যে ছাতা পড়া অংশটি ছড়িয়ে পড়েনি, তখন কাপড় বা চামড়া অবশ্যই ধুতে হবে| চামড়া বা কাপড় যাই হোক্ না কেন, কোন ব্যাপার নয়| অথবা যদি কাপড় হাতে বোনা বা তাঁতে বোনা হয় তাতেও কিছু আসে যায় না| ");
INSERT INTO ben2006_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","যাজক লোকেদের অবশ্যই আদেশ দেবে সেই চামড়া বা কাপড়ের টুকরো ধুয়ে ফেলতে| তারপর যাজক আরো সাত দিনের জন্য কাপড় চোপড় আলাদা করে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","এরপর যাজক অবশ্যই আবার দেখবে| যদি সেই অংশটি তখনও ছত্রাক দ্বারা সংক্রামিত হয়ে আছে বলে মনে হয়, তখন ছড়িয়ে না থাকা সত্ত্বেও তা অশুচি হবে এবং সোকে আগুনে পোড়াতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“কিন্তু যদি ছাতা পড়া অংশটি ম্লান হয়ে গিয়ে থাকে তাহলে যাজক অবশ্যই চামড়া বা কাপড়ের টুকরো থেকে সংক্রামিত অংশটি ছিঁড়ে বাদ দেবে| তাঁতে বা হাতে বোনা কাপড় হলেও কিছু আসে যায় না| ");
INSERT INTO ben2006_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","কিন্তু সেই চামড়ার বা কাপড়ের টুকরোয় ছাতা পড়া অংশ আবার দেখা দিতে পারে| যদি তাই ঘটে তখন বুঝতে হবে ছাতা পড়া অংশটা ছড়িয়ে পড়ছে| সেক্ষেত্রে তোমাকে সেই ছাতা পড়া জিনিস পুড়িয়ে ফেলতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","কিন্তু ধোয়ার পরে যদি ছাতা পড়া অংশ না দেখা দেয় তাহলে সেই চামড়ার বা কাপড়ের টুকরো শুচি| সে কাপড় তাঁতে বোনাই হোক্ অথবা হাতে বোনা সেটা কোন ব্যাপারই নয়| সেই কাপড় শুচি|” ");
INSERT INTO ben2006_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ঐগুলি হল চামড়ার বা কাপড়ের টুকরোগুলির ওপরে ছাতা পড়ার ব্যাপারে নিয়মাবলী| কাপড় তাঁতে বা হাতে বোনা হতে পারে; কিন্তু তাতে কিছু আসে যায় না| ");
INSERT INTO ben2006_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“এখন যে নিয়মাবলীসমূহ বলব সেগুলো আগে চর্মরোগ ছিল কিন্তু সুস্থ হয়েছে, এমন ব্যক্তিকে শুচি করার নিয়মাবলী| “যে মানুষটির কুষ্ঠ ছিল তাকে একজন যাজক অবশ্যই দেখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","যাজক অবশ্যই শিবিরের বাইরে গিয়ে সেই ব্যক্তির চর্মরোগ সেরে গেছে কিনা তা দেখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","লোকটি সুস্থ হয়ে থাকলে যাজক তাকে দুটি জীবন্ত শুচি পাখী, এক খণ্ড এরস বৃক্ষের কাঠ, এক টুকরো লাল কাপড় এবং একটি এসোব গাছ আনতে আদেশ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","তারপর যাজক অবশ্যই আদেশ দেবে মাটির পাত্রে জলের ঢেউযে একটি পাখীকে হত্যা করার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","এবার অন্য যে পাখীটি বেঁচে আছে যাজক সেটার সাথে এরস বৃক্ষের কাঠের খণ্ড, লাল কাপড়ের টুকরো এবং এসোব গাছ নেবে| এরপর জলের ঢেউযে যে পাখীটিকে মারা হয়েছে, তার রক্তের মধ্যে সে জীবন্ত পাখীটাকে এবং অন্য জিনিসগুলোকে ডোবাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","যে মানুষটির কুষ্ঠ রোগ হয়েছিল তার গায়ে সাতবার রক্তটা ছিটিয়ে দেবে| তারপর যাজক লোকটাকে শুচি বলে ঘোষণা করবে এবং পরে খোলা মাঠে গিয়ে পাখীটাকে ছেড়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“তারপর লোকটি তার পোশাক পরিচ্ছদ ধুয়ে ফেলবে, তার মাথার সমস্ত চুল কামিয়ে ফেলবে এবং স্নান করে শুচি হবে| লোকটি এবার শিবিরের মধ্যে যেতে পারবে; কিন্তু সে অবশ্যই সাতদিন তার তাঁবুর বাইরে কাটাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","সাতদিনের দিন সে তার মাথা, দাড়ি এবং ভুরু অর্থাৎ‌ তার সমস্ত চুল কামাবে| তারপর সে তার কাপড়-চোপড় ধোবে এবং জলে স্নান করে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“অষ্টম দিনে, যে লোকটার চর্ম রোগ ছিল সে নিখুঁত দুটি মেষশাবক এবং একটি এক বছর বয়সী স্ত্রী মেষশাবকও আনবে| সে অবশ্যই শস্য নৈবেদ্যর জন্য 24 কাপ তেল মেশানো গুঁড়ো ময়দা আনবে| এছাড়াও লোকটি যেন এক লোগ অলিভ তেল নিয়ে আসে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","শুচিকারী যাজক অবশ্যই যে লোকটি শুচি হচ্ছে তাকে এবং তার নৈবেদ্যগুলি সমাগম তাঁবুর প্রবেশ মুখে প্রভুর সামনে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","যাজক পুরুষ মেষশাবকগুলির মধ্যে একটিকে দোষার্থক নৈবেদ্যরূপে উপহার দেবে| তারপর সেই মেষটি ও এক লোগ তেল দোলনীয় নৈবেদ্য হিসাবে প্রভুর সামনে দোলাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","তারপর যে পবিত্র স্থানে তারা পাপ মোচনের নৈবেদ্য ও হোমবলির নৈবেদ্য বলি দেয়, সেই স্থানেই যাজক পুরুষ মেষশাবকটিকে বলি দেবে| দোষ মোচনের নৈবেদ্য হল পাপ মোচনের নৈবেদ্যর মতো| এটা যাজকের কাছে থাকবে| এটা অত্যন্ত পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“দোষ মোচনের নৈবেদ্যর রক্ত নিয়ে যাজক এই রক্তের কিছুটা রক্ত যে লোকটিকে শুচি করা হচ্ছে তার ডান কানের লতিতে, কিছুটা রক্ত তার ডান হাতের বুড়ো আঙুলে এবং কিছুা রক্ত সেই লোকের ডান পায়ের বুড়ো আঙুলে লাগিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","যাজক সেই এক লোগ তেলের কিছুটা নিয়ে তা বাঁ হাতের তালুতে ঢালবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","তারপর যাজক ডান হাতের আঙুল বাঁ হাতে রাখা তেলের মধ্যে ডুবিয়ে প্রভুর সামনে সাতবার তেলের কিছুটা ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","আর হাতের তালুর কিছুটা তেল যে মানুষটিকে শুচি করা হচ্ছে তার ওপর ঢেলে দেবে| দোষ মোচনের নৈবেদ্যর রক্ত যেখানে যেখানে লাগানো হয়েছিল, সেই একই জায়গাতেই যাজক তেল লাগিয়ে দেবে অর্থাৎ‌ লোকটির ডান কানের লতিতে, ডান হাতের বুড়ো আঙুলে এবং কিছুটা তেল লোকটির ডান পায়ের বুড়ো আঙুলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","লোকটিকে শুচি করার জন্য যাজক হাতের তালুতে পড়ে থাকা বাকি তেলটুকু লোকটির মাথায় দেবে| এইভাবে যাজক প্রভুর সামনে লোকটিকে পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“তারপর যাজক লোকটিকে শুচি করার জন্য প্রায়শ্চিত্ত হিসাবে পাপ মোচনের নৈবেদ্যটিকে উৎসর্গ করবে| এরপর হোমবলির নৈবেদ্যর জন্য যাজক প্রাণীটিকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","তারপর যাজক বেদীর ওপর হোমবলির নৈবেদ্য এবং শস্য নৈবেদ্য উৎসর্গ করবে| এইভাবে যাজক ঐ লোকটির জন্য প্রায়শ্চিত্ত করলে লোকটি শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“কিন্তু যদি লোকটি গরীব হয় এবং ঐ সমস্ত নৈবেদ্য দানে অক্ষম হয় তাহলে সে দোষার্থক নৈবেদ্যর জন্য একটি পুরুষ মেষশাবক আনবে| এটা হবে দোলনীয় নৈবেদ্য যাতে যাজক সেই লোকটিকে পবিত্র করতে পারে| এছাড়া শস্য নৈবেদ্যর জন্য তেল মেশানো 8 কাপ গুঁড়ো ময়দা ও এক লোগ অলিভ তেল লোকটিকে আনতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","এবং সঙ্গতি অনুসারে আনবে দুটো ঘুঘু বা দুটি বাচ্চা পায়রা, যার একটি হবে পাপ মোচনের নৈবেদ্য এবং অন্যটি হবে হোমবলির নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“আট দিনের দিন লোকটি শুচি হবার জন্য সমাগম তাঁবুর প্রবেশ মুখে প্রভুর সামনে যাজকের কাছে ঐ জিনিসগুলি আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","দোষার্থক নৈবেদ্যর মেষশাবক এবং তেল নিয়ে যাজক তা প্রভুর সামনে দোলনীয় নৈবেদ্য হিসেবে উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","তারপর লোকটিকে শুচি করার জন্য দোষার্থক নৈবেদ্যর মেষশাবকটিকে হত্যা করে যাজক এই রক্তের কিছুটা লোকটির ডান কানের লতিতে দেবে, কিছুটা তার ডান হাতের বুড়ো আঙূলে এবং কিছুটা রক্ত তার ডান পায়ের বুড়ো আঙুলে লেপে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","যাজক সেই তেলের কিছুটা তার বাঁ হাতের তালুতে ঢালবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","তার বাঁ হাতে যে তেল রয়েছে, তার ওপর যাজক তার ডান হাতের আঙুল দিয়ে প্রভুর সামনে সাতবার এই তেল ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","তারপর যাজক তার হাতের কিছুটা তেল পাপমোচনের বলির রক্ত যেখানে লাগিয়েছিল সেইসব জায়গায় লাগিয়ে দেবে অর্থাৎ‌ যে মানুষটি শুচি হচ্ছে তার ডান কানের লতিতে, ডান হাতের বুড়ো আঙুলে এবং ডান পায়ের বুড়ো আঙুলে দেবে| বাকি তেলের কিছুটা লোকটির মাথায় দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","এইভাবে যাজক প্রভুর সামনে লোকটিকে পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“তারপর যাজক নৈবেদ্য হিসাবে দেওয়া ঘুঘুগুলোর একটি বা বাচ্চা পায়রাগুলোর একটি উৎসর্গ করবে| (সে অবশ্যই ব্যক্তির সঙ্গতি অনুসারে উৎসর্গ করবে|) ");
INSERT INTO ben2006_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","অর্থাৎ‌ সঙ্গতি অনুসারে সে শস্য নৈবেদ্যর সাথে পাখিগুলোর মধ্যে একটাকে উৎসর্গ করবে পাপমোচনের বলি হিসেবে, আর একটিকে উৎসর্গ করবে হোমবলির নৈবেদ্য হিসেবে.| এইভাবে প্রভুর সামনে যাজক লোকটিকে শুচি করার জন্য প্রায়শ্চিত্ত করবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","শুদ্ধ হওয়ার জন্য যে সমস্ত মানুষ নিয়মিত নৈবেদ্য সম্প্রদানে অপারগ, চর্মরোগ থেকে সেরে ওঠার পর শুচি হবার জন্য ঐ নিয়মাবলী তাদের জন্যই নির্দিষ্ট| ");
INSERT INTO ben2006_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","প্রভু মোশি এবং হারোণকে আরও বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“আমি তোমাদের অধিকার করার জন্য যে কনান দেশ দিয়ে দিয়েছি সেই দেশে তোমরা প্রবেশ করলে আমি কোন লোকের বাড়ীতে ছত্রাক উৎপন্ন করতে পারি| ");
INSERT INTO ben2006_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","এরকম হলে সেই বাড়ীটির মালিক অবশ্যই যাজকের কাছে আসবে এবং বলবে, ‘আমার বাড়ীতে আমি ছত্রাকের মত কিছু দেখছি|’ ");
INSERT INTO ben2006_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“যাজক বাড়ীতে ঢুকে ছত্রাক পরীক্ষা করার আগে বাড়ী থেকে সবকিছু বাইরে বার করার জন্য আদেশ দেবে| যাজক ছত্রাক দেখতে যাওয়ার আগে লোকরা একাজ করলে ঘরের সমস্ত কিছু অশুচি হবে না| এরপর যাজক ভাল করে পরীক্ষা করার জন্য বাড়ীর মধ্যে ঢুকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","যাজক পরীক্ষা করে যদি দেখে যে বাড়ির দেওয়ালগুলির ওপরকার ছত্রাক সবুজ অথবা লাল রঙের এবং তা দেওয়ালের গায়ে গর্ত করেছে, ");
INSERT INTO ben2006_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","তাহলে যাজক অবশ্যই বাড়ীর বাইরে আসবে এবং সাত দিনের জন্য বাড়ীটিতে তালা লাগাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“সপ্তম দিনে যাজক ফিরে এসে বাড়ীটিকে পরীক্ষা করবে| যদি বাড়ীর দেওয়ালগুলিতে ছত্রাক ছড়িয়ে পড়ে, ");
INSERT INTO ben2006_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","তাহলে যাজক ছত্রাক জড়ানো পাথরের টুকরোগুলোকে টেনে বার করার এবং লোকদের সেগুলিকে ছুঁড়ে ফেলে দেওয়ার আদেশ দেবে| শহরের বাইরের কোন বিশেষ ধরণের অশুচি জায়গায় তারা অবশ্যই ঐ সব পাথরগুলো রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","তারপর যাজক গোটা বাড়ীটির ভেতরটা চেঁছে ফেলার আদেশ দেবে| লোকরা চেঁছে তোলা প্রলেপ শহরের বাইরের কোন অশুচি জায়গায় জমা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","তারপর সেই লোকটি দেওয়ালগুলোর ওপর নতুন পাথর বসাবে এবং নতুন প্রলেপ দিয়ে দেওয়ালগুলো ঢেকে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“যদি পুরানো প্রলেপ চেঁছে ফেলে নতুন পাথর ও প্রলেপ লাগানোর পর ঐ বাড়ীটিতে আবার ছত্রাক দেখা দেয়, ");
INSERT INTO ben2006_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","তখন যাজক আবার আসবে এবং বাড়ীটিকে পরীক্ষা করবে| যদি সংক্রামণ বাড়ির মধ্যে ছড়িয়ে যায়, তাহলে এটা একটা রোগ যা তাড়াতাড়ি অন্য জায়গায় ছড়িয়ে যায়| সুতরাং বাড়ীটি অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","সেই ব্যক্তি অবশ্যই বাড়ীটিকে ভেঙ্গে ফেলবে| শহরের বাইরে নির্দিষ্ট অশুচি জায়গায় পাথরগুলি, প্রলেপ ও কাঠের টুকরোগুলি নিয়ে গিয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","বাড়ীটি যখন তালাবন্ধ, সেই সময় যদি কোনো ব্যক্তি ঐ বাড়ীর মধ্যে যায়, তবে সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","যদি কোনো ব্যক্তি সেই বাড়ীর মধ্যে খাওয়া-দাওয়া করে অথবা সেখানে শোয়, তাহলে সেই ব্যক্তি অবশ্যই তার কাপড়-চোপড় ধোবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“বাড়ীতে নতুন পাথর এবং প্রলেপ লাগানোর পর যাজক অবশ্যই বাড়ীটিকে পরীক্ষা করবে| যদি ছত্রাক বাড়ীটায ছড়িয়ে না পড়ে, তাহলে যাজক ঘোষণা করবে যে বাড়ীটি শুচি| কারণ ছত্রাক মরে গেছে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“তখন বাড়ীটিকে শুচি করার জন্য যাজক অবশ্যই দুটি পাখি, এক খণ্ড এরস কাঠ, এক টুকরো লাল কাপড় এবং একটি এসোব গাছ নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","মাটির বড় পাত্রে জলের স্রোতের মধ্যে যাজক একটি পাখীকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","তারপর যাজক এরস কাঠ, এসোব গাছ, লাল কাপড়ের খণ্ড ও জীবন্ত পাখীটিকে নেবে এবং জলের স্রোতে হত্যা করা পাখীর রক্তে যাজক ঐসব জিনিস ডোবাবে| এরপর যাজক সাতবার সেই রক্ত বাড়ীটির ওপর ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","যাজক ঐ সব জিনিস ব্যবহার করে বাড়ীটিকে এইভাবে শুচি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","যাজক শহরের বাইরে একটি ফাঁকা জায়গায় যাবে এবং জীবন্ত পাখীটিকে ছেড়ে দেবে| এইভাবে যাজক বাড়ীটির জন্য প্রায়শ্চিত্ত করবে এবং বাড়ীটি শুচি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","এ সমস্তই হল যে কোন সংক্রামক কুষ্ঠ রোগের ");
INSERT INTO ben2006_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","কাপড়-চোপড় অথবা বাড়ীর মধ্যেকার অংশে লাগা ছত্রাকের নিয়মাবলী| ");
INSERT INTO ben2006_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","এগুলো চামড়ার ওপরকার ফোঁড়া, খোস-পাঁচড়া বা দগ্দগে দাগের নিয়মকানুন| ");
INSERT INTO ben2006_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","এই সমস্ত নিয়ম ব্যাখ্যা করে কোন্ জিনিসগুলি শুচি এবং কোন্ জিনিসগুলি অশুচি| এগুলি ঐসব রোগের নিয়মাবলী| ");
INSERT INTO ben2006_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","প্রভু মোশি আর হারোণকে আরও বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ইস্রায়েলের লোকদের এটা বলো: যখন কোন পুরুষ তার শরীর থেকে তরল পদার্থ নির্গত করে তখন সেই ব্যক্তি অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","তার শরীর থেকে সেটা সাবলীলভাবে বেরিয়ে আসুক বা প্রবাহ বন্ধ হোক্্ তাতে কিছু আসে যায় না| ");
INSERT INTO ben2006_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“নির্গমণ হয়েছে এমন ব্যক্তি যদি কোন বিছানায় শোয় তবে তা অশুচি হয়ে পড়বে আর সে যা কিছুর ওপর বসবে তাও অশুচি হয়ে পড়ে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","যদি কোন ব্যক্তি, যার নির্গমণ হয়েছে তার বিছানা স্পর্শ করে, তাহলে সে অবশ্যই তার জামাকাপড় ধোবে এবং জলে স্নান করবে, তবে সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","যদি কোন ব্যক্তি যার নির্গমণ হয়েছে তার জায়গায় বসে, তাহলে সে অবশ্যই তার জামাকাপড় ধোবে এবং জলে স্নান করবে| সেও সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","আরও যদি কোন ব্যক্তি নির্গমণ হয়েছে এমন কাউকে ছুঁয়ে ফেলে, তাহলে সে অবশ্যই তার জামা কাপড় ধোবে এবং জলে স্নান করবে আর সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“যার নির্গমণ হয়েছে সে যদি কোনো শুচি ব্যক্তির ওপর থুতু ফেলে তাহলে শুচি ব্যক্তিটি অবশ্যই তার জামা কাপড় ধোবে এবং জলে স্নান করবে| এই ব্যক্তিটি সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","যার নির্গমণ হয়েছে সেই ব্যক্তি যদি কোন জিনের ওপর বসে তাহলে সেটিও অশুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","সুতরাং যদি কেউ নির্গমণ হয়েছে এমন কোন ব্যক্তির নীচে থাকা কোন কিছু স্পর্শ করে বা এই জিনিসগুলি বহন করে, তাহলে সে অবশ্যই তার জামাকাপড় ধোবে এবং জলে স্নান করবে| সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“যদি এমন হয়, যে কোন ব্যক্তি, যার নির্গমণ হয়েছে সে তার হাত ধোযনি কিন্তু অন্য একজনকে স্পর্শ করেছে, তাহলে সেই অপর ব্যক্তি অবশ্যই তার জামাকাপড় ধোবে এবং জলে স্নান করবে| সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“নির্গমণ হয়েছে এমন কোন ব্যক্তি যদি মাটির গামলা ছোয়, তাহলে সেই গামলাটি অবশ্যই ভাঙতে হবে| আর সে কোন কাঠের গামলা ছুঁয়ে ফেললে সেই গামলা অবশ্যই জল দিয়ে ধুতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“যখন নির্গমণ হয়েছে এমন ব্যক্তি সেরে ওঠে, তখন তাকে তার শুদ্ধিকরণ সম্পূর্ণ হবার জন্য সাত দিন অপেক্ষা করতে হবে| তারপর সে তার জামা কাপড় ধোবে এবং স্রোতের জলে শরীরকে স্নান করাবে| তা হলে সে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","আট দিনের দিন সেই ব্যক্তিটি তার নিজের জন্য দুটি ঘুঘু বা দুটি বাচ্চা পায়রা আনবে| সমাগম তাঁবুর ঢোকার মুখে প্রভুর সামনে এনে সে সেই পাখী দুটি যাজককে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","যাজক পাখীগুলির একটিকে পাপ মোচনের নৈবেদ্য হিসেবে এবং আর একটিকে হোমবলির নৈবেদ্য হিসেবে উৎসর্গ করবে| এইভাবে যাজক প্রভুর সামনে লোকটিকে পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“যদি কোন পুরুষ মানুষের বীর্যপাত ঘটে, সে তার সারা শরীর স্নানের জলে ধোবে, কিন্তু সন্ধ্যা পর্যন্ত সে অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","যদি কাপড় বা কান চামড়ার ওপর বীর্য পড়ে থাকে, তা হলে সে কাপড় বা চামড়া অবশ্যই জল দিয়ে ধুয়ে ফেলবে| এটা সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","যদি কোন পুরুষ কোন মহিলার সঙ্গে এক বিছানায় শোয় এবং বীর্যপাত ঘায, তাহলে পুরুষ ও মহিলা দুজনেই জলে স্নান করবে| তারা সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“মাসিক রক্তপাতের সময় কোন স্ত্রীলোক সাত দিন অশুচি থাকবে| যদি কোন ব্যক্তি তাকে স্পর্শ করে, সন্ধ্যা পর্যন্ত সেই ব্যক্তি অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","মাসিক রক্তপাতের সময় সেই স্ত্রীলোক কিছুর ওপর শোবে, প্রত্যেকটি হবে অশুচি এবং সে কিছুর ওপর বসবে সেটাও হবে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","যদি কোন ব্যক্তি স্ত্রীলোকটির বিছানা ছোয়, সেই ব্যক্তি অবশ্যই তার জামা কাপড় ধোবে এবং জলে স্নান করবে| সেও সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","মহিলাটি কিছুর ওপর বসেছে, সেগুলি যদি কোন লোক ছোয়, সেই লোকটি অবশ্যই জামা কাপড় ধোবে ও জলে স্নান করবে কিন্তু সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","লোকটি স্ত্রীলোকের বিছানা ছুঁলে বা স্ত্রীলোকটি যাতে বসেছে তার কোন কিছু স্পর্শ করলে, সেই লোকটি সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“যদি কোন ব্যক্তি কোন মহিলার সাথে মাসিক রক্তপাতের মধ্যেই যৌন সম্পর্ক করে, তাহলে স্ত্রীলোকটির অশুচিতা তার মধ্যে প্রবেশ করবে এবং লোকটি সাত দিন ধরে অশুচি থাকবে| লোকটি শুয়েছে এমন প্রত্যেকটি বিছানা অশুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“যদি কোন মহিলার অনেক দিন ধরে রক্তক্ষরণ হয়, এটি যদি তার মাসিক রক্তস্রাবের সময়ে না হয়, অথবা যদি তার মাসিক রক্তপাতের পরে রক্তক্ষরণ হয়, তাহলে সে মাসিক রক্তস্রাবের মতই অশুচি হবে| যতদিন তার রক্তস্রাব থাকবে, ততদিন সে অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","যে কোন রক্তস্রাবের সময় যে কোন বিছানায় মহিলাটি শোবে, তা হবে তার মাসিক রক্তস্রাবের সময়কার বিছানায় মতই| যা কিছুর ওপর মেয়েটি বসবে তা অশুচি হবে। ঠিক যেমন তার মাসিক রক্তস্রাবের সময় সে অশুচি হয় সেরকমই| ");
INSERT INTO ben2006_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","যদি কোন ব্যক্তি সেইসব জিনিস ছোয়, সেই ব্যক্তি হবে অশুচি| লোকটি তার পোশাক-পরিচ্ছদ ধোবে এবং জলে স্নান করবে, কিন্তু সন্ধ্যা পর্যন্ত সে অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","স্ত্রীলোকটি রক্তস্রাব বন্ধ হওয়ার পর অবশ্যই সাত দিন অপেক্ষা করবে; তারপর সে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","আট দিনের দিন স্ত্রীলোকটি দুটি ঘুঘু অথবা দুটি বাচ্চা পায়রা আনবে| সমাগম তাঁবুর প্রবেশ মুখে যাজকের কাছে সেগুলি আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","তখন যাজক একটি পাখীকে পাপ মোচনের নৈবেদ্য হিসেবে এবং অন্যটিকে হোমবলির নৈবেদ্য হিসেবে উপহার দেবে| এইভাবে যাজক প্রভুর সামনে তাকে শুচি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“সুতরাং অশুচি হওয়া বিষয়ে অবশ্যই তোমরা ইস্রায়েলের লোকদের সাবধান করবে| তাহলে তারা আমার পবিত্র তাঁবুকে অশুচি করে তাদের অশুচিতায় মারা পড়বে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","এই সমস্ত নিয়ম যাদের নির্গমণ হয়েছে এমন লোকদের জন্য| ঐ সব নিয়ম হল দীর্ঘ পতনের ফলে অশুদ্ধ মানুষদের জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","এবং ঐগুলি হল যে সমস্ত স্ত্রীলোক তাদের মাসিক রক্তস্রাবের সময় অশুচি হয় তাদের জন্য| উপরন্তু ঐ সমস্ত নিয়মাবলী সেই ব্যক্তির জন্য যে অপর এক অশুচি স্ত্রীর সঙ্গে যৌন সংসর্গ করে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","হারোণের দুই পুত্র প্রভুর কাছে উপস্থিত হয়ে মারা বার পর প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“তোমার ভাই হারোণের সঙ্গে কথা বলো, তাকে বলো যে সে তার ইচ্ছা মত যে কোন সময়ে পর্দার পিছনে পবিত্রতম জায়গায় যেতে পারে না| চুক্তির পবিত্র সিন্দুকটি ঐ পর্দার পিছনের ঘরে আছে| ঐ পবিত্র সিন্দুকটির মাথায় আছে বিশেষ ধরণের আচ্ছাদন| আমি ঐ বিশেষ আচ্ছাদনের ওপর মেঘের মধ্যে আবির্ভূত হই| যদি হারোণ ঐ ঘরে ঢোকে সে মারা যেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“পাপের প্রায়শ্চিত্তের দিন হারোণ অবশ্যই পাপমোচনের নৈবেদ্যর জন্য একটি ষাঁড় এবং হোমবলির জন্য একটি পুরুষ মেষ উৎসর্গ করবে| পবিত্রতম জায়গায় প্রবেশ করার আগেই হারোণ এটা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","হারোণ অবশ্যই তার দেহ জলে ধৌত করবে| তারপর সে এই সমস্ত পোশাক পরবে; হারোণকে অতি অবশ্যই পবিত্র লিনেন জামা পরতে হবে| লিনেনের অন্তর্বাসসমূহ তার দেহে থাকবে| সে তার চারপাশে লিনেনের বেল্ট ব্যবহার করবে এবং লিনেনের পাগড়ী পরবে| ঐগুলি হল পবিত্র পোশাক| ");
INSERT INTO ben2006_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“ইস্রায়েলের লোকদের কাছ থেকে হারোণ দুটি পুরুষ ছাগল পাপমোচনের নৈবেদ্যর জন্য এবং একটি পুরুষ মেষ হোমবলির জন্য নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","তারপর হারোণ ষাঁড়টিকে পাপ মোচনের নৈবেদ্য হিসেবে উপহার দেবে| পাপ মোচনের নৈবেদ্যটি তার নিজের জন্য| নিজেকে এবং তার পরিবারকে পবিত্র করার জন্য হারোণ অবশ্যই এটা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“তারপর হারোণ ছাগল দুটি নেবে এবং তা সমাগম তাঁবুর ঢোকার দরজার মুখে প্রভুর সামনে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","হারোণ ছাগল দুটির জন্য ঘুঁটি চাললে একটা হবে প্রভুর জন্য, অপরটি হবে অজাজেলের জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“তারপর ঘুঁটি চেলে যে ছাগলটি প্রভুর জন্য নির্বাচিত হয় হারোণ অবশ্যই সেটিকে পাপ মোচনের নৈবেদ্য হিসাবে উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","অজাজেলের জন্য ঘুঁটি চেলে যে ছাগলটাকে বেছে নেওয়া হয়েছে তাকে অবশ্যই জীবন্ত অবস্থায় প্রভুর কাছে আনবে| তারপর এই ছাগলটিকে অজাজেলের জন্য মরুভূমিতে পাঠাতে হবে| এটা লোকদের পবিত্র করার জন্যই দরকার| ");
INSERT INTO ben2006_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“তারপর তার নিজের জন্য পাপ মোচনের নৈবেদ্য হিসেবে হারোণ একটি ষাঁড় দেবে এবং এইভাবে নিজেকে ও তার পরিবারকে পবিত্র করবে| হারোণ তার নিজের জন্য পাপ মোচনের নৈবেদ্য রূপে ষাঁড়টিকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","তারপর সে অবশ্যই প্রভুর কাছে বেদী থেকে তুলে আনা জ্বলন্ত কয়লা ভর্ত্তি পাত্রটি আনবে| সুগন্ধী ধূপের মিহি করা গুঁড়ো দুহাত ভর্ত্তি করে নেবে হারোণ| হারোণ পর্দার পিছনের ঘরে সেই মিষ্টি গন্ধের গুঁড়ো আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","হারোণ অবশ্যই প্রভুর সামনের আগুনে সেই মিষ্টি গন্ধের ধূপের গুঁড়ো রাখবে| তারপর সুগন্ধ গুঁড়োর মেঘ চুক্তির সিন্দুকের বিশেষ আচ্ছাদনকে ঢেকে দেবে, ফলে হারোণ মারা যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","হারোণ অবশ্যই ষাঁড়টি থেকে কিছুটা রক্ত নিয়ে তার আঙুল দিয়ে তা পূর্বদিকে বিশেষ আচ্ছাদন পর্যন্ত ছিটিয়ে দেবে| সে রক্তটা সেই বিশেষ আচ্ছাদনের সামনে তাকে আঙুল দিয়ে সাত বার ছিটিয়ে দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“তারপর হারোণ লোকদের জন্য পাপ মোচনের নৈবেদ্যর ছাগলটিকে হত্যা করে সেই রক্ত পর্দার আড়ালের ঘরটিতে আনবে| ষাঁড়ের রক্ত নিয়ে করেছিল, ছাগলটির রক্ত নিয়ে হারোণ ঠিক তাই করবে| হারোণ অবশ্যই ছাগলের রক্ত বিশেষ আচ্ছাদনের ওপর এবং আচ্ছাদনের সামনে ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","এইভাবে সে ঐ পবিত্রতম জায়গাটিকে ইস্রায়েলের লোকদের তাদের অশুচিতা, বিরুদ্ধাচরণ এবং তাদের কৃত সমস্ত পাপ থেকে শুচি করবে| হারোণকে সমাগম তাঁবুর জন্য এই সমস্ত কিছু করতে হবে, কারণ এটা অশুচি লোকদের মাঝখানে আছে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“যখন হারোণ পবিত্রতম জায়গাটিকে এবং লোকদের শুদ্ধ করার জন্য যায়, তখন সে সেখান থেকে বেরিয়ে না আসা পর্যন্ত সমাগম তাঁবুতে কোন লোক থাকবে না| সুতরাং হারোণ নিজেকে এবং তার পরিবারকে এবং ইস্রায়েলের সমস্ত লোকদের শুচি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“তারপর হারোণ বেরিয়ে এসে প্রভুর সামনে বেদীর কাছে যাবে এবং বেদীটাকে শুচি করবে| হারোণ কিছুটা ষাঁড়ের রক্ত ও কিছুটা ছাগলের রক্ত নেবে এবং তা বেদীর সব দিকের কোণগুলিতে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","অতঃপর হারোণ সাতবার তার আঙুল দিয়ে কিছুটা রক্ত বেদীর ওপর ছিটিয়ে দেবে| এইভাবে হারোণ বেদীটিকে ইস্রায়েলের লোকদের অশুচিতা থেকে শুচি করে পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“পবিত্রতম স্থান, সমাগম তাঁবু এবং বেদীকে পবিত্র করার পর হারোণ জীবন্ত ছাগলটি প্রভুর কাছে আনবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","হারোণ তার হাত দুটি জীবন্ত ছাগলের মাথায় রাখবে এবং তার ওপর ইস্রায়েলের লোকদের পাপ ও অপরাধগুলি স্বীকার করবে| এইভাবে হারোণ লোকদের পাপসমূহকে ছাগলের মাথায় চাপাবে| তারপর সে ছাগলটাকে মরুভূমিতে পাঠাবে| একজন মানুষ নিযুক্ত করা হবে এবং সে ছাগলটিকে নিয়ে যাওয়ার জন্য তৈরী থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","সুতরাং ছাগলটা নিজের ওপর সমস্ত মানুষের পাপ বয়ে নিয়ে খোলা মরুভূমিতে চলে যাবে| যে মানুষটি ছাগলটিকে নিয়ে যাবে সে তাকে মরুভূমিতে ছেড়ে দিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“তারপর হারোণ সমাগম তাঁবুতে ঢুকবে| পবিত্র স্থানে আসার সময় সে যে লিনেনের কাপড়-চোপড় পরেছিল সেগুলি সে খুলে ফেলবে| কাপড়গুলি সে অবশ্যই সেখানে ছেড়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","একটি পবিত্র জায়গায় সে তার সারা শরীর জল দিয়ে ধুয়ে নেবে| তারপর সে তার অন্যান্য বিশেষ পোশাক পরবে| সে বাইরে আসবে এবং তার নিজের হোমবলি ও লোকদের হোমবলি উৎসর্গ করবে| সে নিজেকে এবং লোকদের শুচি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","তারপর সে বেদীর ওপর পাপ মোচনের নৈবেদ্যর চর্বি পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“যে লোকটি ছাগলটিকে অজাজেলের জন্য নিয়ে গিযেছিল, সে তার জামাকাপড় ধুয়ে নেবে এবং জলে স্নান করবে| তারপর সে তাঁবুর মধ্যে আসতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“পাপমোচনের নৈবেদ্যর ষাঁড় ও ছাগলটিকে শিবিরের বাইরে আনতে হবে| (ঐ সমস্ত প্রাণীর রক্ত পবিত্র জিনিসগুলিকে পবিত্র জায়গায় শুচি করার জন্য আনা হয়েছিল|) যাজকরা অবশ্যই ঐ সমস্ত প্রাণীর চামড়া, শরীর এবং শরীরের বর্জ্য অংশগুলি আগুনে পোড়াবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","তারপর যে ব্যক্তি তাদের পোড়াবে সে অবশ্যই তার পোশাক-পরিচ্ছদ ধুয়ে ফেলবে এবং তার সমস্ত শরীর জলে ধোবে| তারপর সে তাঁবুতে প্রবেশ করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“তোমাদের ক্ষেত্রে এই আইন সর্বদাই চলবে: সপ্তম মাসের দশ দিনের দিন তোমাদের কোন খাদ্য গ্রহণ করা চলবে না এবং অবশ্যই তোমরা কোন কাজ করবে না| তোমাদের দেশে বাস করা কোন ভ্রমণকারী বা বিদেশী কোন কাজ করতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","কারণ এই দিনে যাজক তোমাদের পবিত্র করার জন্য তোমাদের পাপের প্রায়শ্চিত্ত করাবে| তখন তোমরা প্রভুর কাছে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","তোমাদের জন্য এই দিনটি অত্যন্ত গুরুত্বপূর্ণ বিশ্রামের দিন| তোমরা অবশ্যই খাওয়া-দাওয়া করবে না| এই আইন চিরকাল চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“সুতরাং প্রধান যাজক হিসেবে মনোনীত ব্যক্তিটি জিনিসপত্র পবিত্র করার জন্য এই পর্বাদি পালন করবে| এই প্রধান যাজক, কে তার পিতারই স্থানে নিয়োগ করা হয়েছে, সে পবিত্র লিনেনের পোশাক পরিচ্ছদ পরবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","সে অবশ্যই পবিত্রতম স্থান সমাগম তাঁবু এবং বেদী শুচি করবে এবং সে অবশ্যই যাজকদের ও ইস্রায়েলের লোকদের শুচি করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ইস্রায়েলের লোকদের পবিত্র করার এই বিধি চিরকালের জন্য থাকবে| ইস্রায়েলের লোকদের তাদের পাপ থেকে শুচি করার জন্য তোমরা প্রত্যেক বছরে একবার এসব করবে|” তাই মোশিকে দেওয়া প্রভুর আদেশ মতো তারা এইসব করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“হারোণ আর তার পুত্রদের এবং ইস্রায়েলের সমস্ত লোকদের বলো, প্রভু এই আদেশ করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","যদি একজন ইস্রায়েলীয় একটি ষাঁড় অথবা একটি মেষ বা একটি ছাগল শিবিরের মধ্যে বা তাঁবুর বাইরে হত্যা করে, ");
INSERT INTO ben2006_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","কিন্তু সেই প্রাণীটিকে সমাগম তাঁবুর প্রবেশ পথে না আনে এবং সেই প্রাণীর একটা অংশ উপহার হিসেবে প্রভুকে নিবেদন না করে, তবে সেই ব্যক্তি রক্তপাত ঘটিয়েছে বলে অবশ্যই দোষী গন্য হবে| সেই ব্যক্তিকে অন্য লোকদের থেকে অবশ্যই বিচ্ছিন্ন করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","এই নিয়ম এই জন্য যাতে ইস্রায়েলের লোকরা যে সব প্রাণীদের মাঠে হত্যা করবে তাদের সমাগম তাঁবুর প্রবেশ মুখে প্রভুর কাছে মঙ্গল নৈবেদ্য হিসাবে প্রভুর কাছে উৎসর্গ করে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","তারপর যাজক ওইসব প্রাণীদের রক্ত সমাগম তাঁবুর প্রবেশ মুখে প্রভুর বেদীর ওপর নিক্ষেপ করবে এবং যাজক বেদীর ওপর ঐসব প্রাণীর মেদ দগ্ধ করবে| এর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","তারা অবশ্যই আর কোন বলি তাদের ‘ছাগ দেবতার’ কাছে উৎসর্গ করবে না| তারা বেশ্যাদের মত অন্য দেবতার পিছনে ছুটেছে| এই সমস্ত নিয়ম চিরকাল ধরে চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“লোকদের বলো ইস্রায়েলের কুলজাত কোন ব্যক্তি বা তাদের মধ্যে বসবাসকারী কোন বিদেশী যদি হোমবলি উপহার দেয়, ");
INSERT INTO ben2006_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","কিন্তু তা সমাগম তাঁবুর প্রবেশ মুখে না আনে এবং প্রভুকে নিবেদন না করে তবে সেই ব্যক্তিকে তার লোকদের থেকে অবশ্যই বিচ্ছিন্ন হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“কোন ব্যক্তি রক্ত খেলে আমি তার বিরুদ্ধে| সেই ব্যক্তি ইস্রায়েলের নাগরিক হোক্ অথবা তোমাদের মধ্যে বাস করা কোন বিদেশী হোক্ না কেন তাতে কিছু আসে যায় না| আমি তাকে তার লোকদের থেকে বিচ্ছিন্ন করবো| ");
INSERT INTO ben2006_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","কারণ দেহটির জীবন রক্তের মধ্যে রয়েছে| আমি সেই রক্ত বেদীর ওপর ঢেলে তোমাদের নিজেদের শুচি করার জন্য দিয়েছি| রক্তে প্রাণ আছে বলেই তা প্রায়শ্চিত্ত সাধন করে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","তাই আমি ইস্রায়েলের লোকদের বলি: তোমাদের কোন ব্যক্তিই রক্ত খেতে পারো না| তোমাদের মধ্যে বাস করা কোন বিদেশীও রক্ত খেতে পারে না| ");
INSERT INTO ben2006_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“যদি কোন ব্যক্তি খাওয়া যেতে পারে এমন একটি বন্য প্রাণী বা একটি পাখী শিকার করে ধরে তাহলে সেই ব্যক্তি অবশ্যই ়শিকারের রক্ত মাটিতে ফেলবে এবং তা ধূলো দিয়ে ঢেকে দেবে, কারণ প্রতিটি প্রাণীর রক্তে তার জীবন রয়েছে| যদি সেই ব্যক্তি ইস্রায়েলীয় অথবা তোমাদের মধ্যে বসবাসকারী একজন বিদেশী হয় তাতে কিছু আসে যায় না| ");
INSERT INTO ben2006_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","প্রতিটি প্রাণীর রক্তেই তার জীবন রয়েছে| তাই আমি ইস্রায়েলের লোকদের এই আদেশ দিচ্ছি যে তারা যেন কোন প্রাণীর রক্ত না খায়! কোন ব্যক্তি যদি রক্ত খায় অবশ্যই সে তার লোকদের থেকে বিচ্ছিন্ন হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“আরও যদি কোন ব্যক্তি এমন প্রাণী ভক্ষণ করে যা নিজে নিজেই মরে গেছে, অথবা যদি অন্য কোন প্রাণীর দ্বারা নিহত প্রাণী ভক্ষণ করে, অবশ্যই তার কাপড়-চোপড় ধোবে এবং জল দিয়ে তার গোটা দেহ ধুয়ে ফেলবে| সেই ব্যক্তি সন্ধ্যা পর্যন্ত অশুচি থাকবে| তারপর শুচি হবে| সেই ব্যক্তিটি ইস্রায়েলের নাগরিক হোক্ বা ব্যক্তিটি তোমাদের মধ্যে বসবাসকারী একজন বিদেশী হোক্ তাতে কিছু যায় আসে না| ");
INSERT INTO ben2006_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","যদি সেই ব্যক্তি তার কাপড়-চোপড় ধৌত না করে অথবা শরীরকে স্নান না করায়, তাহলে সে তার নিজ অপরাধ বহন করবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ইস্রায়েলের লোকদের বলো: আমি তোমাদের প্রভু ও ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","অতীতে তোমরা মিশরে বাস করতে| সেই দেশে যা করা হত, তোমরা অবশ্যই সেগুলি করবে না| আমি তোমাদের কনান দেশে নিয়ে যাচ্ছি| ঐ দেশেও যা করা হয় তোমরা অবশ্যই সেগুলি করবে না! তাদের রীতিনীতি অনুসরণ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","তোমরা অবশ্যই আমার নিয়মাবলী মান্য করবে এবং আমার বিধি সকল অনুসরণ করবে| সেইসব নিয়মাবলী অনুসরণে নিশ্চিত হও! কারণ আমিই তোমাদের প্রভু ও ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","সুতরাং তোমরা অবশ্যই আমার বিধিসকল ও নিয়মাবলী মান্য করবে| যদি কোন ব্যক্তি আমার বিধিসকল ও নিয়মাবলী মান্য করে, সে জীবিত থাকবে! আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“তোমরা কখনও তোমাদের ঘনিষ্ঠ আত্মীয়দের সঙ্গে যৌন সংসর্গ করবে না| আমি তোমাদের প্রভু| ");
INSERT INTO ben2006_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“তোমরা অবশ্যই তোমাদের পিতার অপমান করবে না| পিতা বা মাতার সঙ্গে যৌন সংসর্গ করবে না| সেই মহিলা তোমার মা, সুতরাং তার সঙ্গে তোমার অবশ্যই যৌন সংসর্গ থাকবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","তোমাদের পিতার স্ত্রী, যদি সে তোমাদের মা নাও হয় তবু তার সঙ্গে যৌন সম্পর্কে যাবে না| কেন? কারণ তাহলে তোমার পিতাকে অসম্মান করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“তোমরা অবশ্যই তোমাদের বোনের সঙ্গে যৌন সংসর্গ করবে না| যদি সে তোমাদের পিতার বা মাতার কন্যা হয়, তাতে কিছু যায় আসে না এবং যদি তোমাদের বোন তোমাদের বাড়ীতে বা অন্য জায়গায় বড় হয় তাতেও এই নিয়ম বলবৎ থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“তোমরা অবশ্যই তোমাদের নাতনীর সঙ্গে যৌন সংসর্গ করবে না| তারা তোমাদেরই একটা অংশ| ");
INSERT INTO ben2006_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“যদি তোমাদের পিতা এবং তার স্ত্রীর একটি কন্যা থাকে, তাতে সে হয় তোমার বোন| তোমরা অবশ্যই তার সঙ্গে যৌন সংসর্গ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“তোমরা অবশ্যই তোমাদের পিতার বোনের সঙ্গে যৌন সংসর্গ করবে না| সে হল তোমাদের পিতার ঘনিষ্ঠ আত্মীযা| ");
INSERT INTO ben2006_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","তোমরা অবশ্যই তোমাদের মাতার বোনের সঙ্গে যৌন সম্পর্ক করবে না| সে তোমাদের মাতার ঘনিষ্ঠ আত্মীয়া| ");
INSERT INTO ben2006_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","তোমরা অবশ্যই তোমাদের বাবার ভাইকে অপমান করবে না| তোমাদের কাকার স্ত্রীর কাছেও যৌন সংসর্গের জন্য যাবে না| সে তোমাদের কাকীমা| ");
INSERT INTO ben2006_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“তোমরা অবশ্যই তোমাদের পুত্রবধুর সঙ্গে যৌন সংসর্গ করবে না| সে তোমাদের ছেলের স্ত্রী| তোমাদের অবশ্যই তার সঙ্গে যৌন সম্পর্ক থাকবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ভাইয়ের স্ত্রীর সঙ্গে অবশ্যই তোমাদের যৌন সম্পর্ক থাকবে না| তা তোমার ভাইকে অপমান করার মত হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“একজন মা এবং তার মেয়ের সঙ্গে তোমাদের যৌন সংসর্গ অবশ্যই থাকবে না| সেই মহিলার নাতনীর সঙ্গেও যৌন সম্পর্ক রেখো না| যদি এই নাতনী এই স্ত্রীলোকের পুত্রের বা কন্যার কন্যা হয় তাতেও কিছু যায় আসে না| তার নাতনীরা তার ঘনিষ্ঠ আত্মীয়জন| তাদের সঙ্গে যৌন সম্পর্ক থাকা অন্যায়| ");
INSERT INTO ben2006_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“তোমার স্ত্রী জীবিত অবস্থায়, তুমি অবশ্যই তার বোনকে বিয়ে করবে না| এতে বোনরা পরস্পরের শত্রু হয়ে উঠবে| তোমরা অবশ্যই তোমাদের স্ত্রীর বোনের সঙ্গে যৌন সম্পর্ক রাখবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“মাসিক রক্তক্ষরণের সময় একজন মহিলার কাছে তোমরা অবশ্যই যৌন সংসর্গের জন্য যাবে না| এই সময়টায সে অশুচি| ");
INSERT INTO ben2006_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“এবং তোমাদের প্রতিবেশীর স্ত্রীর সঙ্গে তোমরা অবশ্যই যৌন সংসর্গ করবে না| এটা তোমাদের অপবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“তোমরা অবশ্যই তোমাদের শিশুদের কোন একজনকে আগুনের মধ্য দিয়ে মোলক দেবতার উদ্দেশ্যে উৎসর্গ করবে না| একাজ করে তোমরা অবশ্যই তোমাদের ঈশ্বরের নামকে অপবিত্র করবে না| আমি তোমাদের প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“একজন পুরুষের অন্য একজন পুরুষের সঙ্গে স্ত্রীলোকের ন্যায যৌন সম্পর্ক অবশ্যই থাকবে না| তা হলো ভয়ঙ্কর পাপ| ");
INSERT INTO ben2006_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“কোন ধরণের প্রাণীর সঙ্গে তোমাদের যৌন সম্পর্ক অবশ্যই থাকবে না| এটা তোমাদের কেবল নোংরা করবে| একজন স্ত্রীলোকেরও কোন প্রাণীর সঙ্গে অবশ্যই যৌন সম্পর্ক থাকবে না| এটা প্রকৃতি বিরুদ্ধ| ");
INSERT INTO ben2006_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“এইসব ভুল কাজ করে তোমরা নিজেদের অশুচি করো না| যে সব জাতিগণকে আমি তোমাদের সামনে তাদের দেশ থেকে দূর করে দেব তারা এই সমস্ত কর্ম দ্বারা নিজেদের অশুচি করেছে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","তাই দেশ অপবিত্র হয়ে গেছে| তাই এর পাপের জন্য আমি শাস্তি দেব এবং সেই দেশ ওখানে বসবাসকারী সেই সব মানুষদের বমি করার মত বার করে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“সুতরাং তোমরা অবশ্যই আমার বিধি ও নিয়মাবলী মান্য করবে| তোমরা অবশ্যই ঐসব ভয়ঙ্কর পাপের কোন একটিও করবে না| সেই সব নিয়মাবলী ইস্রায়েলের নাগরিকদের জন্যই এবং সেগুলি তোমাদের মধ্যে বাসকারী লোকদের জন্যই| ");
INSERT INTO ben2006_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","তোমাদের আগে ঐ সব দেশে যারা বসবাস করত তারা ঐ সমস্ত ভয়ঙ্কর পাপ করে দেশটাকে নোংরা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","যদি তোমরা এই ভয়ঙ্কর জিনিসগুলি করো, তাহলে তোমরা দেশকে কলুষিত করবে এবং তা তোমাদের দেশের বাইরে বার করে দেবে, যেমন করে তোমাদের সামনে জাতিগুলিকে বার করে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","যদি কোন ব্যক্তি ঐ সমস্ত ভয়ঙ্কর পাপগুলির কোনো একটি করে, তাহলে সেই ব্যক্তিকে তার নিজের লোকদের কাছ থেকে অবশ্যই বিচ্ছিন্ন করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","তোমরা অবশ্যই আমার বিধি মানবে! তোমরা অবশ্যই ঐসব ভয়ঙ্কর পাপসমূহের কোন একটিও করবে না ইস্রায়েলে তোমাদের পূর্বে সেখানে প্রচলিত ছিল| ওইসব ভয়ঙ্কর পাপ দিয়ে তোমরা নিজেদের অবশ্যই কলুষিত করবে না| আমি তোমাদের প্রভু ও ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ইস্রায়েলের সমস্ত লোকদের বলো: আমি তোমাদের প্রভু ঈশ্বর| আমি পবিত্র সুতরাং তোমরা অবশ্যই পবিত্র হবে!” ");
INSERT INTO ben2006_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“তোমাদের মধ্যে প্রত্যেকটি ব্যক্তি তার পিতা এবং মাতাকে সম্মান দেবে এবং আমার বিশ্রামের বিশেষ দিনগুলি পালন করবে| আমিই প্রভু তোমাদের ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“মূর্ত্তি পূজো করবে না| তোমাদের নিজেদের জন্য গলিত ধাতু দিয়ে দেবতার মূর্ত্তি তৈরী করবে না| আমি প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“যখন তোমরা ঈশ্বরকে মঙ্গল নৈবেদ্য উপহার দাও, তোমরা অবশ্যই তা সঠিকভাবে দেবে যাতে তা গ্রাহ্য হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","তোমরা যেদিন নৈবেদ্য দেবে সেদিন এবং পরের দিনও তা আহার করতে পারবে; কিন্তু যদি সেই নৈবেদ্যর কোন অংশ তৃতীয় দিনেও পড়ে থাকে, তাহলে তা অবশ্যই আগুনে পুড়িয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","তোমরা সেই নৈবেদ্যর কোনো অংশই তৃতীয় দিনে আহার করবে না; সেটা হবে অশুচি, সেটা অগ্রাহ্য হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","একজন ব্যক্তি যদি তা করে তবে সে সেই পাপের কারণে দোষী হবে| কারণ সে প্রভুর জিনিসগুলিকে শ্রদ্ধা করেনি| সেই লোকটি তার লোকদের থেকে অবশ্যই বিচ্ছিন্ন হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“যখন তোমরা শস্য কাটো, তখন তোমাদের ক্ষেত্রের কোণ পর্যন্ত শস্য কেটো না| শস্য যদি মাটিতে পড়ে ইস্রায়েলে, তোমরা তা কুড়িয়ে নিও না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","তোমাদের দ্রাক্ষা বাগানের সব দ্রাক্ষা তুলবে না এবং যেগুলি মাটিতে পড়ে থাকে সেগুলিও তুলে নেবে না| কেন? কারণ সেগুলি তোমরা গরীব এবং তোমাদের দেশের মধ্যে দিয়ে ভ্রাম্যমাণ মানুষদের জন্য ফেলে রাখবে| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“তোমরা অবশ্যই চুরি করবে না| তোমরা অবশ্যই লোকদের ঠকাবে না এবং পরস্পরের কাছে মিথ্যে কথা বলবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","মিথ্যে প্রতিশ্রুতি দিতে তোমরা অবশ্যই আমার নাম ব্যবহার করবে না| তা করলে ঈশ্বরের নামের অসম্মান করা হয়| আমিই তোমাদের প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“তোমাদের প্রতিবেশীর প্রতি তোমরা অবশ্যই মন্দ ব্যবহার করবে না| তোমরা অবশ্যই তাকে লুঠ করবে না| তোমরা সকাল না হওয়া পর্যন্ত সারা রাত ধরে অবশ্যই একজন ভাড়া করা শ্রমিকের বেতন আটকাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“তোমরা অবশ্যই একজন বধির মানুষকে অভিশাপ দেবে না| অন্ধ মানুষের সামনে এমন কিছু রেখো না যাতে সে পড়ে যায়| তোমরা অবশ্যই ঈশ্বরকে শ্রদ্ধা করবে| আমিই তোমাদের প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“বিচারের ব্যাপারে তোমরা অবশ্যই পক্ষপাতহীন হবে| তোমরা অবশ্যই দরিদ্র মানুষের প্রতি বিশেষ পক্ষপাতিত্ব দেখাবে না| এবং তোমরা অবশ্যই অতি গুরুত্বপূর্ণ লোকদেরও বিশেষ সম্মান দেখাবে না| তোমরা যখন প্রতিবেশীর বিচার করবে তখন অবশ্যই অন্যায় করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","অন্য লোকদের বিরুদ্ধে তোমরা অবশ্যই মিথ্যা গল্প রটিয়ে বেড়াবে না| এমন কিছু করবে না যাতে তোমাদের প্রতিবেশীর জীবন বিপন্ন হয়| আমিই তোমাদের প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“তোমরা তোমাদের ভাইকে অবশ্যই মনে মনে ঘৃণা করবে না| যদি তোমাদের প্রতিবেশী ভুল করে, তাহলে তার সাথে সে বিষয়ে কথা বল, কিন্তু তাকে ক্ষমা করো; তাহলে তুমি তার দোষের ভাগীদার হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","তোমার প্রতি লোকরা খারাপ ইস্রায়েলে কিছু করেছে, তা ভুলে যেও; প্রতিশোধ নেওয়ার চেষ্টা করো না| তোমাদের প্রতিবেশীকে নিজেদের মত করে ভালোবাসো| আমিই তোমাদের প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“তোমরা অবশ্যই আমার বিধিসকল মান্য করবে| তোমরা অবশ্যই দু পৃথক ধরণের প্রাণীর মধ্যে সঙ্কর প্রজনন করবে না| তোমরা অবশ্যই তোমাদের ক্ষেতে দুটি আলাদা ধরণের বীজ বপন করবে না| দুই ধরণের সুতো দিয়ে তৈরী পোশাক তোমরা অবশ্যই পরবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“এমন ঘটতে পারে যে একজন ব্যক্তি, অন্যের কাছে দাসী এমন একজনের সঙ্গে যৌন সংসর্গ করেছে; কিন্তু এই দাসী মহিলাটি বিক্রিত হয়নি বা তাকে তার স্বাধীনতা দেওয়া হয় নি| যদি তা ঘটে, তাহলে সেক্ষেত্রে অবশ্যই শাস্তি হবে; কিন্তু তাদের মৃত্যুদণ্ড হবে না, কারণ স্ত্রীলোকটি স্বাধীন নয়| ");
INSERT INTO ben2006_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","লোকটি প্রভুর জন্য সমাগম তাঁবুর প্রবেশমুখে অবশ্যই তার দোষ মোচনের নৈবেদ্য হিসাবে একটি পুরুষ মেষশাবক আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","যাজক লোকটিকে শুচি করার জন্য পুরুষ মেষশাবকটিকে দোষার্থক নৈবেদ্য হিসেবে প্রভুর সামনে উৎসর্গ করে তার পাপের প্রায়শ্চিত্ত করাবে| তারপর লোকটিকে তার কৃত পাপসমুহের জন্য ক্ষমা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ভবিষ্যতে তোমরা তোমাদের দেশে প্রবেশ করে যখন খাদ্যের জন্য কোন জাতের গাছ লাগাবে, তখন ঐ গাছের ফল ব্যবহারের আগে অবশ্যই তিন বছর অপেক্ষা করবে| এই সময় সেই ফল অশুচি বলে গন্য করবে এবং তা খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","চতুর্থ বছরে গাছের ফল হবে প্রভুর| প্রভুর প্রতি প্রশংসা হিসেবে এটা হবে পবিত্র নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","তারপর পঞ্চম বছরে তোমরা সেই গাছ থেকে ফল পেতে পারো! এবং এইভাবে গাছটি তোমাদের জন্য আরো ফল দেবে| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“রক্ত লেগে থাকা অবস্থায় কোন মাংস তোমরা অবশ্যই খাবে না| “তোমরা অবশ্যই ইস্রায়েলে যাদুবিদ্যা এবং গণক বিদ্যার ব্যবহার করতে চেষ্টা করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“তোমরা অবশ্যই তোমাদের মাথার পাশে গজানো কেশগুলি গোল করে গোটাবে না| তোমরা অবশ্যই তোমাদের দাড়ির কোণ কাটবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","মৃত ব্যক্তিদের স্মরণে রাখার জন্য তোমরা অবশ্যই তোমাদের দেহে কাটা ছেঁড়া করবে না| তোমরা অবশ্যই নিজেদের ওপর কোন উল্কি রাখবে না| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“তোমার কন্যাকে বেশ্যা হতে দিও না| তা করলে তাকে অপমান করা হয়| দেশের মানুষজনও তাহলে বেশ্যার মত অর্থাৎ‌ ঈশ্বরের প্রতি অবিশ্বস্তের মত আচরণ করবে না এবং দেশে মন্দ জিনিসে পূর্ণ হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“আমার বিশ্রামের বিশেষ দিনগুলিতে তোমরা অবশ্যই কাজ করবে না| তোমরা অবশ্যই আমার পবিত্রস্থানকে সম্মান দেবে| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ভুতুড়িয়াদের বা ডাইনীদের কাছে মন্ত্রণার জন্য যাবে না| তাদের কাছে যেও না, তারা শুধু তোমাকে অশুচি করবে| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“বয়স্ক ব্যক্তিদের সম্মান দেখাবে; যখন তাঁরা ঘরে ঢোকেন উঠে দাঁড়াবে| তোমাদের ঈশ্বরের প্রতি শ্রদ্ধা প্রদর্শন করবে| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“তোমাদের দেশে বাস করা বিদেশীদের প্রতি খারাপ ব্যবহার করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","তোমাদের নিজেদের নাগরিকদের মতই বিদেশীদের প্রতি সমান ব্যবহার করবে| তোমাদের নিজেদের যেমন ভালোবাস, বিদেশীদের তেমনি ভালোবাসবে| কারণ একসময় তোমরা মিশরে বিদেশী ছিলে| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“তোমরা বিচারে অন্যায় করবে না এবং জিনিসপত্র মাপার ও ওজন করার ব্যাপারে সৎ‌ হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","শস্য ওজন করার জন্য এবং তরল পদার্থ মাপার জন্য তোমাদের ওজন পাল্লা, বাটখারা, ঝুড়ি ও পাত্রগুলি সঠিক হওয়া উচিৎ‌| আমিই প্রভু তোমাদের ঈশ্বর! আমি তোমাদের মিশর দেশ থেকে বাইরে এনেছি| ");
INSERT INTO ben2006_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“তোমরা অবশ্যই আমার সমস্ত বিধি এবং নিয়মাবলী মনে রাখবে এবং সেগুলি মান্য করবে| আমিই প্রভু!” ");
INSERT INTO ben2006_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“তুমি অবশ্যই ইস্রায়েলের লোকদের আরও এই বিষয়গুলি বলো: তোমাদের দেশের কোন মানুষ যদি মোলকের মূর্ত্তির সামনে তার শিশুদের মধ্যে একটিকে উৎসর্গ করে, তবে সেই মানুষটির অবশ্যই প্রাণদণ্ড হবে| যদি সেই ব্যক্তি ইস্রায়েলের নাগরিক হয় বা ইস্রায়েলে বাস করা একজন বিদেশী হয় তাতে কিছু যায় আসে না| তোমরা অবশ্যই সেই ব্যক্তিকে পাথর ছুঁড়ে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","আমি সেই ব্যক্তির বিরুদ্ধে দাঁড়াব এবং তাকে তার লোকদের কাছ থেকে বিচ্ছিন্ন করব, কারণ সে তার শিশুকে মোলকের উদ্দেশ্যে দিয়েছে| সে আমার পবিত্র নামকে শ্রদ্ধা করেনি এবং আমার পবিত্র স্থানকে অশুচি করেছে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","কিন্তু সাধারণ মানুষ সেই ব্যক্তিকে উপেক্ষা করে এবং যে তার শিশুদের মোলককে দিয়েছে তাকে হত্যা না করে, ");
INSERT INTO ben2006_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তাহলে আমি সেই ব্যক্তি এবং তার পরিবারের বিরোধিতা করব এবং তাকে তার লোকদের কাছ থেকে বিচ্ছিন্ন করব| যারা সেই ব্যক্তিকে অনুসরণ করে মোলকের পিছনে ইস্রায়েলে আমি তাদেরও বিচ্ছিন্ন করব| ");
INSERT INTO ben2006_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“যদি কোন ব্যক্তি ভুতুড়িয়া এবং মায়াবীদের কাছে উপদেশের জন্য যায় আমি তার বিরোধী হবো| সেই ব্যক্তি আমার প্রতি অবিশ্বাসী, তাই আমি তাকে তার লোকদের কাছ থেকে বিচ্ছিন্ন করব| ");
INSERT INTO ben2006_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“তোমরা পৃথক হও! নিজেদের পবিত্র করো| কারন আমি পবিত্র! আমিই প্রভু, তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","আমার বিধিগুলি স্মরণে রাখো এবং মেনে চলো| আমি প্রভু এবং আমিই সেই, যিনি তোমাদের পবিত্র করেন| ");
INSERT INTO ben2006_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“যদি কোনো মানুষ তার পিতা কিম্বা মাতাকে অভিশাপ দেয়, তার প্রাণদণ্ড হবে| পিতামাতাকে অভিশাপ দিয়েছে বলে সে তার নিজের মৃত্যুর জন্য দায়ী! ");
INSERT INTO ben2006_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“যদি কোন পুরুষের তার প্রতিবেশীর স্ত্রীর সঙ্গে যৌন সম্পর্ক থাকে, তাহলে সেই পুরুষ এবং মহিলা দুজনেই ব্যভিচারের দোষে দোষী হবে| সেই পুরুষ এবং মহিলা দুজনের অবশ্যই যেন প্রাণদণ্ড হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","যদি কোন পুরুষের তার পিতার স্ত্রীর সঙ্গে যৌন সংসর্গ থাকে, তাহলে পুরুষ এবং রমণী দুজনকে অবশ্যই যেন মেরে ফেলা হয়| তারা নিজেরা তাদের মৃত্যুর জন্য দায়ী, কারণ এই কাজ দ্বারা সেই পুরুষটির পিতাকে অপমান করা হয়| ");
INSERT INTO ben2006_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“যদি একজন পুরুষের তার পুত্রবধূর সঙ্গে যৌন সংসর্গ থাকে, তাহলে দুজনকে অবশ্যই যেন মেরে ফেলা হয়| এ হল অনাচার, তারা তাদের নিজেদের মৃত্যুর জন্য দায়ী| ");
INSERT INTO ben2006_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“যদি কোন পুরুষের অন্য এক পুরুষের সঙ্গে একজন স্ত্রীলোকের মত যৌন সম্পর্ক থাকে তবে এই দুজন পুরুষ এক ভয়ঙ্কর পাপ কার্য্যে লিপ্ত| তাদের অবশ্যই যেন মেরে ফেলা হয়| তারা তাদের নিজেদের মৃত্যুর জন্য দায়ী| ");
INSERT INTO ben2006_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“কোন পুরুষের পক্ষে একই সাথে কোন স্ত্রীলোক এবং তার মাতাকে বিয়ে করা অত্যন্ত মন্দ কাজ| লোকেরা সেই মানুষটিকে অবশ্যই পোড়াবে এবং দুজন স্ত্রীলোককে আগুনে দেবে যেন এই ধরণের কুকর্ম আর কেউ না করে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“যদি একজন মানুষ কোন এক জন্তুর সঙ্গে যৌন সম্পর্কে লিপ্ত হয় তবে সেই মানুষটি অবশ্যই প্রাণদণ্ডে দণ্ডিত হবে এবং তোমরা অবশ্যই প্রাণীটিকেও হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","যদি একজন স্ত্রীলোকের কোন এক জন্তুর সঙ্গে যৌন সম্পর্ক থাকে, তাহলে তোমরা অবশ্যই স্ত্রীলোক ও প্রাণীটিকে হত্যা করবে| তারা অবশ্যই প্রাণদণ্ডে দণ্ডিত হবে| তারা তাদের নিজেদের মৃত্যুর জন্য দায়ী| ");
INSERT INTO ben2006_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“যদি কেউ তার বোন, তার সৎ‌ মাতা বা সৎ‌ পিতার মেয়েকে বিবাহ করে এবং একে অপরের সঙ্গে যৌন সম্পর্কে লিপ্ত হয় তবে এটা লজ্জাজনক বিষয়| তারা অবশ্যই প্রকাশ্যে শাস্তি পাবে| তারা অবশ্যই তাদের লোকদের কাছ থেকে বিচ্ছিন্ন হবে| যে মানুষ তার বোনের সঙ্গে যৌন সম্পর্ক করে, সে অবশ্যই তার পাপের জন্য শাস্তি পাবে! ");
INSERT INTO ben2006_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“মাসিক রক্তস্রাবের সময় কোন রমণীর সঙ্গে যদি কোন পুরুষের যৌন সংসর্গ হয়, তাহলে পুরুষ এবং রমনী দুজনই তাদের লোকদের থেকে অবশ্যই বিচ্ছিন্ন হবে| তারা পাপ করেছে কারণ সেই পুরুষ রক্তের উৎ‌সকে প্রকাশ করেছে এবং সেই স্ত্রী তার রক্তের উৎ‌সকে অনাবৃত করেছে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“তোমাদের মাতার বোন বা তোমাদের পিতার বোনের সঙ্গে অবশ্যই যৌন সম্পর্ক করবে না| সেটা হল গর্হিত আচার| তোমাদের পাপসমূহের জন্য তোমরা অবশ্যই শাস্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“একজন পুরুষ অবশ্যই তার কাকার স্ত্রীর সঙ্গে যৌন সম্পর্ক করবে না| এ কাজ তার কাকাকে অপমান করে| সেই পুরুষ এবং তার কাকার স্ত্রী তাদের পাপসমুহের জন্য শাস্তি পাবে| তারা সন্তানসন্ততিহীন হবে এবং সেই অবস্থাতেই মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“একজন পুরুষের পক্ষে তার নিজের ভ্রাতৃবধুকে বিবাহ করা অন্যায়| এ কাজ তার ভাইকে অসম্মান করে| তাদের সন্তানসন্ততি থাকবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“তোমরা অবশ্যই আমার সমস্ত বিধিসমুহ এবং নিয়মাবলি মনে রাখবে এবং সেগুলি মান্য করবে| আমি তোমাদের যে দেশে নিয়ে ইস্রায়েলেচ্ছি, সেই দেশে বসবাসকালে তোমরা আমার বিধিসমুহ এবং নিয়মাবলী মান্য করো, তাহলে সেই দেশ তোমাদের বিতাড়িত করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","তোমাদের সামনে যে সব জাতিকে আমি সেই দেশ থেকে দূর করে দিচ্ছি, তাদের মত জীবনইস্রায়েলেপন করো না| তারা ঐ সমস্ত পাপ কাজ করত তাই আমি তাদের ঘৃণা করলাম| ");
INSERT INTO ben2006_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","আমি তোমাদের বলেছি যে তোমরা তাদের জমি পাবে| আমি তা তোমাদের দেব| সেই দেশে খাদ্য ও পানীয়ের কোন অভাব হবে না| আমিই প্রভু তোমাদের ঈশ্বর! “আমি তোমাদের জন্য জাতির থেকে পৃথক করে আমার বিশেষ লোকজন করে তুলেছি| ");
INSERT INTO ben2006_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","সুতরাং তোমরা অবশ্যই অশুচি প্রাণীদের থেকে শুচি প্রাণীদের এবং অশুচি পাখীদের থেকে শুচি পাখীদের আলাদা করে নেবে| ঐ সব অশুচি পাখী, প্রাণী এবং যারা মাটিতে বুক দিয়ে হাঁটে, তা আহার করে নিজেদের অশুচি করো না| আমি ঐসব প্রানীগুলোকে অশুচি বলে নির্দিষ্ট করেছি| ");
INSERT INTO ben2006_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","আমি তোমাদের অন্য জাতির থেকে আলাদা করে আমার নিজস্ব করে তুলেছি| তাই তোমরা অবশ্যই পবিত্র হবে! কেন? কারণ আমি প্রভু এবং আমি পবিত্র! ");
INSERT INTO ben2006_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“কোন পুরুষ অথবা স্ত্রীলোক যদি ভুতুড়িয়া বা মায়াবী হয় তাকে অবশ্যই প্রাণদণ্ডে দণ্ডিত হতে হবে| লোকরা তাদের পাথর দিয়ে হত্যা করবে| তারা নিজেরাই নিজেদের মৃত্যুর জন্য দায়ী হবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","প্রভু মোশিকে বললেন, “হারোণের পুত্রদের অর্থাৎ‌ যাজকদের এই বিষয়গুলি বলো: একজন যাজক অবশ্যই কোন মৃত ব্যক্তিকে স্পর্শ করে নিজেকে অশুচি করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","কিন্তু যদি মৃত ব্যক্তিটি তার ঘনিষ্ঠ আত্মীয়দের একজন হয় তাহলে সে মৃতদেহ স্পর্শ করতে পারে| যদি মৃত ব্যক্তি তার মাতা কি পিতা, তার পুত্র বা কন্যা, তার ভাই বা ");
INSERT INTO ben2006_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","তার অবিবাহিত বোন (এই বোন ঘনিষ্ঠ কারণ তার স্বামী নেই, সে মারা গেলে তার জন্য যাজক নিজেকে অশুচি করতে পারে|) হয়, তবে যাজক নিজেকে অশুচি করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","কিন্তু কেবল বৈবাহিক কারণে সম্পর্কযুক্ত মানুষের জন্য যাজক নিজেকে অশুচি করতে পারে না এবং নিজেকে অপবিত্র করতে পারে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“যাজকরা তাদের মাথা এমনভাবে কামাবে না যাতে তাদের াক দেখা যায় অথবা তাদের দাড়ি কামাবে না| যাজকরা তাদের শরীরে অবশ্যই কোন কাটা ছেঁড়া করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","যাজকদের তাদের ঈশ্বরের জন্য অবশ্যই পবিত্র হতে হবে| তারা অবশ্যই ঈশ্বরের নামকে শ্রদ্ধা জানাবে, কারণ তারাই রুটি এবং আগুনের দ্বারা তৈরী নৈবেদ্যসমূহ প্রভুর কাছে বয়ে নিয়ে যাবে; তাই তারা অবশ্যই পবিত্র হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“একজন যাজক অবশ্যই একজন বেশ্যা অথবা একজন ভ্রষ্টা রমণীকে বিবাহ করবে না| সে বিবাহ বিচ্ছেদ হয়েছে এমন একজন রমণীকে বিবাহ করবে না| কারণ সে ঈশ্বরের উদ্দেশ্যে পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","তোমরা অবশ্যই যাজককে সম্মান করবে কারণ সে ঈশ্বরের কাছে পবিত্র রুটি নিয়ে যায়| সে তোমাদের কাছে পবিত্র বলে গণ্য হবে, কারণ আমি পবিত্র! আমিই প্রভু এবং আমি তোমাদের পবিত্র করি! ");
INSERT INTO ben2006_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“কোন যাজকের মেয়ে বারবণিতা হয়ে নিজেকে অশুচি করলে, সে তার পিতার লজ্জার কারণ হয় সুতরাং তাকে অবশ্যই আগুনে দগ্ধ হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“প্রধান যাজক, ইস্রায়েলেকে তার ভাইদের মধ্যে থেকে বেছে নেওয়া হয়েছে, অভিষেকের তেল যার মাথায় ঢালা হয়েছে এবং বিশেষ পোশাক পরার জন্য ইস্রায়েলেকে বাছা হয়েছে সে প্রকাশ্যে তার বিষাদ বোঝাতে যেন তার মাথার চুল এলোমেলো না করে এবং তার কাপড়-চোপড় না ছেঁড়ে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","মৃতদের স্পর্শ করে সে নিজেকে অশুচি করবে না এবং কোন মৃত দেহের কাছে যাবে না, এমনকি মৃতদেহ যদি তা তার নিজের পিতা বা মাতারও হয় তবুও না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","প্রধান যাজক ঈশ্বরের পবিত্র স্থানের বাইরে অবশ্যই যাবে না| তাতে সে অশুচি হতে পারে এবং তখন সে ঈশ্বরের পবিত্র স্থানকে অশুচি করতে পারে| কারণ অভিষেকের তেল প্রধান যাজকের মাথায় ঢেলে তাকে বাকী লোকদের থেকে আলাদা করা হয়েছিল| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“প্রধান যাজক অবশ্যই একজন রমনীকে বিবাহ করবে যে কুমারী| ");
INSERT INTO ben2006_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","প্রধান যাজক এমন কোন রমণীকে অবশ্যই বিবাহ করবে না যার সঙ্গে অন্য পুরুষের যৌন সম্পর্ক ছিল| প্রধান যাজেক অবশ্যই একজন বারবনিতা, স্বামী পরিত্যক্তা রমণী অথবা একজন বিধবাকে বিবাহ করবে না| প্রধান যাজক অবশ্যই তার নিজের লোকদের মধ্যে থেকে একজন কুমারীকে বিয়ে করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","এইভাবে লোকরা তাদের সন্তানসন্ততিদের প্রতি শ্রদ্ধা জানাবে| আমি প্রভু, প্রধান যাজককে তার বিশেষ কাজের জন্য পৃথক করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“হারোণকে বলো: পুরুষানুক্রমে তোমার বংশের মধ্যে কারও দৈহিক কোন দোষ থাকলে তারা অবশ্যই ঈশ্বরের কাছে বিশেষ রুটি বয়ে নিয়ে যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","কোন ব্যক্তি যার মধ্যে কিছু শারীরিক ত্রুটি আছে, অবশ্যই যাজক হিসেবে সেবা করতে পারবে না এবং আমার কাছে নৈবেদ্যসমূহ আনতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","অন্ধ কি খোঁড়া, কি মুখে খারাপ দাগ যুক্ত লোকেরা বা লম্বা হাত পা সহ লোকরা, ");
INSERT INTO ben2006_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","পিঠে কুঁজ থাকা লোকরা, কি বামনরা, যাদের চোখের দোষ আছে, ক্ষত আছে এমন লোকরা, খারাপ চর্মরোগযুক্ত লোকরা এবং ক্ষতিগ্রস্ত অণ্ডকোষ আছে এমন লোকরা যাজক হিসাবে সেবা করতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“হারোণের উত্তরপুরুষদের মধ্যে কারোর যদি কিছু দোষ থাকে, তাহলে সে প্রভুর কাছে আগুনের নৈবেদ্যসমূহ দিতে পারবে না| এবং সেই ব্যক্তি ঈশ্বরের কাছে বিশেষ রুটি নিয়ে যেতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","সেই ব্যক্তি যাজকদের পরিবারের, তাই সে পবিত্র রুটি আহার করতে পারে| সে অতি পবিত্র রুটিও খেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","কিন্তু সে পর্দার ভেতর দিয়ে পবিত্রতম স্থানে যেতে পারবে না এবং বেদীর কাছে যাবে না কারণ তার মধ্যে কিছু দোষ আছে| সে আমার পবিত্র স্থানগুলিকে অবশ্যই অশুচি করবে না| আমি ঈশ্বর সেই সমস্ত স্থানসমুহকে পবিত্র করি|” ");
INSERT INTO ben2006_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","তারপর মোশি এই সমস্ত বিষয় হারোণ এবং হারোণের পুত্রদের এবং ইস্রায়েলের সমস্ত লোকদের বলল| ");
INSERT INTO ben2006_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","প্রভু ঈশ্বর মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“হারোণ এবং তার পুত্রদের বলো: ইস্রায়েলের লোকরা আমাকে যে উপহার দেয় তা পবিত্র| যাজকরা যেন সেই উপহারগুলিকে অসম্মান না করে, কারণ তা তারা আমার উদ্দেশ্যে উৎসর্গ করেছে| তা না হলে তোমরা যে আমার পবিত্র নামকে শ্রদ্ধা করো না সেটাই স্পষ্ট হবে| আমিই প্রভু| ");
INSERT INTO ben2006_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","এখন থেকে যদি তোমার উত্তরপুরুষদের মধ্যে থেকে কোন ব্যক্তি অশুচি অবস্থায় সেই সমস্ত জিনিস স্পর্শ করে, তাহলে সেই ব্যক্তি অবশ্যই আমার থেকে বিচ্ছিন্ন হবে| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“যদি হারোণের উত্তরপুরুষদের কারো কোন খারাপ চর্মরোগ থাকে বা যার নির্গমণ হয়েছে, সে পবিত্র না হওয়া পর্যন্ত পবিত্র খাদ্য খেতে পারবে না| ঐ নিয়ম যে কোন যাজকের পক্ষে প্রযোজ্য যে অশুচি থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","মৃতদেহ দ্বারা অশুচি হয়েছে এমন কিছু যদি কেউ স্পর্শ করে অথবা যদি তার বীর্যপাত হয় অথবা সে যদি বুকে হাঁটা অশুচি কোন প্রাণীকে স্পর্শ করে বা অশুচি কোন ব্যক্তিকে স্পর্শ করে যদি সে অশুচি হয় তবে কি করে সেই ব্যক্তি অশুচি হয়েছে সেটা গুরুত্বপূর্ণ নয়| ");
INSERT INTO ben2006_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","যে ব্যক্তি ঐ সমস্ত কিছুর যে কোন একটা স্পর্শ করে, সে সন্ধ্যা না হওয়া পর্যন্ত অশুচি থাকবে| সেই ব্যক্তি পবিত্র খাদ্যের কোন কিছু অবশ্যই খাবে না| এমন কি সে যদি জলে ধৌত হয়, তবু সে পবিত্র খাদ্য খেতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","কেবলমাত্র সূর্য ডোবার পর সে শুচি হবে| তখন সে পবিত্র খাদ্য আহার করতে পারবে| কারণ সূর্যাস্তের পর সে শুচি এবং সেই খাদ্য তারই জন্য| ");
INSERT INTO ben2006_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“যদি একজন যাজক দেখে যে একটি প্রাণী নিজে নিজেই মারা গেছে বা বন্য প্রাণীদের দ্বারা নিহত হয়েছে, সে অবশ্যই সেই মৃত প্রাণীটিকে ভক্ষণ করবে না| যদি সেই ব্যক্তি সেই প্রাণীটিকে ভক্ষণ করে সে অশুচি হবে| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“আমাকে সেবা করার জন্য যাজকদের একটা বিশেষ সময় থাকবে| তারা অবশ্যই সেইসব সময় বিষয়ে সতর্ক থাকবে| তারা পবিত্র জিনিসগুলিকে অপবিত্র না করার বিষয়ে অবশ্যই সাবধান হবে| যদি তারা সাবধান হয় তাহলে তারা মারা যাবে না| আমি ঈশ্বর এই বিশেষ কাজের জন্য তাদের পৃথক করেছি| ");
INSERT INTO ben2006_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","কেবলমাত্র যাজকদের পরিবারের লোকরাই পবিত্র খাদ্য আহার করতে পারে| যাজকের সঙ্গে বসবাসকারী একজন প্রবাসী অথবা একজন ভাড়াটে কর্মী অবশ্যই কোন পবিত্র খাদ্য খেতে পারে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","কিন্তু যদি যাজক তার নিজের অর্থে একজন লোককে ভৃত্য হিসেবে কেনে, সেই ব্যক্তি তখন পবিত্র জিনিসগুলির কিছুটা আহার করতে পারে| ভৃত্যরা, যারা যাজকের বাড়ীতে জন্মায় তারাও যাজকের খাদ্যের কিছুটা খেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","যাজকের কন্যা যাজক নয় এমন কাউকে বিয়ে করলে পবিত্র নৈবেদ্যসমূহের কোন কিছু খেতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","যাজকের মেয়ে বিধবা হলে অথবা সে স্বামী পরিত্যক্তা হলে, যদি তাকে সাহায্য করার মত কোন সন্তানসন্ততি না থাকে এবং সে যেখানে বাল্যকাল কাটিয়েছে সেই পিত্রালযে ফিরে আসে, তাহলে সে তার পিতার খাদ্য কিছুটা খেতেও পারে| তাছাড়া কেবলমাত্র যাজকের পরিবারের লোকরা এই খাদ্য খেতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“একজন মানুষ ভুল করে পবিত্র খাদ্যের কিছুটা খেতে পারে| সেই ব্যক্তি অবশ্যই সেই পরিমাণ খাদ্যের দাম যাজককে দেবে এবং সে অবশ্যই খাদ্যের দামের ওপর আরো পঞ্চমাংশ দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“ইস্রায়েলের লোকরা প্রভুকে যে সব উপহার দান করে তা হবে পবিত্র; সুতরাং যাজক অবশ্যই সেই পবিত্র জিনিসগুলিকে অপবিত্র করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","যদি যাজকরা সেই সমস্ত পবিত্র নৈবেদ্যগুলিকে অপবিত্র হিসেবে বিবেচনা করে এবং সেগুলি খায়, তাহলে তা পাপ হিসেবে ধরা হবে| আমি প্রভু তাদের পবিত্র করি|” ");
INSERT INTO ben2006_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","প্রভু ঈশ্বর মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“হারোণ এবং তার পুত্রদের এবং ইস্রায়েলের সমস্ত লোকদের বলো: ইস্রায়েলের একজন নাগরিক বা একজন বিদেশী নৈবেদ্য নিয়ে আসতে পারে| হতে পারে লোকটি যে বিশেষ প্রতিজ্ঞা করেছিল সেই উপহার তার জন্য, অথবা কোন বিশেষ নৈবেদ্য লোকটি আনতে চেয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","ঐ উপহারগুলি লোকরা আনে কারন তারা সত্যিই ঈশ্বরকে উপহার দিতে চায়| কিন্তু কোন নৈবেদ্য যাতে কোন দোষ আছে তা তোমরা অবশ্যই গ্রহণ করবে না| আমি সেই উপহারে খুশী হবো না| যদি সেই উপহার একটি ষাঁড় অথবা একটি মেষ বা একটি ছাগল হয় তাহলে সেই প্রাণী অবশ্যই পুরুষ হবে এবং সেটার মধ্যে যেন দোষ না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“মানত পূর্ণ করার জন্য অথবা স্বেচ্ছায় যখন কোন ব্যক্তি প্রভুর কাছে মঙ্গল নৈবেদ্য আনে সেই নৈবেদ্য একটি ষাঁড় বা মেষ হতে পারে; কিন্তু সেটা যেন স্বাস্থ্যবান হয়| সেই প্রাণীটির মধ্যে অবশ্যই যেন কোন দোষ না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","তোমরা অবশ্যই প্রভুকে এমন কোন প্রাণী দেবে না যেটা কানা, যার হাড়ভাঙ্গা বা পঙ্গু অথবা গলিত ঘা-যুক্ত বা খারাপ চর্মরোগ সমন্বিত| প্রভুর বেদীর ওপরকার আগুনের ওপর তোমরা অবশ্যই অসুস্থ প্রাণী দেবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“কখনও কখনও একটি ষাঁড় বা একটি মেষশাবকের একটা পা থাকে ইস্রায়েলে খুব লম্বা অথবা একটা পায়ের পাতা ইস্রায়েলে ঠিক মত গজায় নি| যদি কোন ব্যক্তি সেই প্রাণীকে প্রভুর কাছে বিশেষ উপহার হিসেবে দিতে চায়, তাতে এটা গৃহীত হবে, কিন্তু এটা লোকটির বিশেষ প্রতিশ্রুতির অর্পণ হিসেবে গৃহীত হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“কোন প্রাণীর কালশিরে পড়া, চূর্ণ বা ছিন্ন বিচ্ছিন্ন অণ্ডকোষ থাকলে তা তোমরা প্রভুর প্রতি উৎসর্গ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“তোমরা বিদেশীদের কাছ থেকে প্রভুর প্রতি নৈবেদ্য হিসাবে অবশ্যই কোন প্রাণী গ্রহণ করবে না, কারণ প্রাণীগুলি কোনভাবে ক্ষতিগ্রস্ত হতে পারে, তাদের মধ্যে কোন দোষ থাকতে পারে; তারা গৃহীত হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“যখন একটি বাছুর বা একটি মেষ অথবা একটি ছাগল জন্মাবে, সে অবশ্যই তার মায়ের সঙ্গে সাত দিন থাকবে| তারপর আট দিনের দিন এবং পরে এই প্রাণী প্রভুর কাছে অগ্নি প্রদত্ত নৈবেদ্য হিসেবে গ্রহণ যোগ্য হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","কিন্তু তোমরা অবশ্যই প্রাণীটিকে এবং এর মাকে একই দিনে হত্যা করবে না! এই নিয়ম গাভী এবং মেষ উভয়ের ক্ষেত্রে প্রযোজ্য| ");
INSERT INTO ben2006_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“যদি তোমরা কিছু বিশেষ ধরণের ধন্যবাদসূচক নৈবেদ্য প্রভুকে দিতে চাও, তাহলে তোমরা সেই উপহার দানের ব্যাপারে স্বাধীন| কিন্তু অবশ্যই তোমরা এটা এমনভাবে করবে ইস্রায়েলে ঈশ্বরকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","তোমরা সেদিন অবশ্যই গোটা প্রাণীটিকে ভক্ষণ করবে| পরের দিনের সকালের জন্য অবশ্যই কোন মাংস ফেলে রাখবে না| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“আমার আদেশগুলি মনে রেখো এবং সেগুলি মান্য করো| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","আমার পবিত্র নামকে তোমরা শ্রদ্ধা দেখাবে| ইস্রায়েলের লোকরা অবশ্যই যেন আমাকে তাদের পবিত্র প্রভু হিসেবে মান্য করে| আমিই প্রভু যিনি তোমাদের পবিত্র করেন| ");
INSERT INTO ben2006_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","আমি তোমাদের ঈশ্বর হবার জন্য মিশর থেকে এসেছি| আমিই প্রভু!” ");
INSERT INTO ben2006_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ইস্রায়েলের লোকদের বলো: প্রভুর মনোনীত উৎসবগুলিকে তোমরা পবিত্র সভা বলে ঘোষণা কর| এইগুলি হল আমার নির্দিষ্ট ছুটির দিন: ");
INSERT INTO ben2006_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ছদিন ধরে কাজ কর, কিন্তু সপ্তম দিন কর্মবিরতির জন্য নির্দিষ্ট বিশ্রামপর্ব হবে বিশ্রামের বিশেষ দিন| তোমরা অবশ্যই কোন কাজ করবে না| এটা তোমাদের সকলের বাড়ীতেই প্রভুর জন্য বিশ্রামের দিন হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“এগুলি হল প্রভুর মনোনীত নিস্তারপর্ব| তোমরা এগুলির জন্য মনোনীত সময়ে পবিত্র সভার কথা ঘোষণা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","প্রভুর নিস্তারপর্বের দিন হল প্রথম মাসের 14 দিনের দিন সূর্যাস্তের সময়| ");
INSERT INTO ben2006_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“খামিরবিহীন রুটির উৎসব হবে ঐ একই মাসের 15 দিনের দিন| তোমরা সাত দিন ধরে খামিরবিহীন রুটি খাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","এই ছুটির প্রথম দিনে তোমাদের এক বিশেষ সভা হবে| তোমরা অবশ্যই ঐ দিনটিতে কোন কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","সাতদিন ধরে তোমরা প্রভুর কাছে অগ্নিপ্রদত্ত উৎসর্গগুলি আনবে| তারপর সপ্তমদিনে আর একটি পবিত্র সভা হবে| তোমরা অবশ্যই ঐ দিনে কোন কাজ করবে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ইস্রায়েলের লোকদের বলো: আমি তোমাদের যে দেশ দেবো তাতে তোমরা প্রবেশ করবে| তোমরা এর শস্য ছেদন করলে শস্যের প্রথম আঁটি যাজকের কাছে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","যাজক প্রভুর সামনে সেই আঁটি দোলাবে যেন তোমাদের জন্য তা গ্রাহ্য হয়| যাজক রবিবার সকালে সেই শস্যের আঁটি দোলাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“যে দিন তোমরা শস্যের আঁটি দোলাবে, সেদিন তোমরা একটি এক বছর বয়সী পুরুষ মেষ উপহার দেবে| সেই মেষের মধ্যে যেন কোন দোষ না থাকে| ঐ মেষটি প্রভুর কাছে হোমবলির নৈবেদ্য হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","এছাড়া তোমরা অবশ্যই অলিভ তেল মেশানো 16কাপ মিহি ময়দা শস্য নৈবেদ্য হিসাবে দেবে| এর সাথে দেবে 1 কোয়ার্ট দ্রাক্ষারস| সেই নৈবেদ্যর গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ঈশ্বরের কাছে তা নৈবেদ্য হিসাবে না আনা পর্যন্ত তোমরা অবশ্যই কোন নতুন শস্য অথবা ফল বা নতুন শস্য থেকে তৈরী রুটি খাবে না| তোমরা যেখানেই বাস কর না কেন এই বিধি তোমাদের বংশ পরম্পরায় চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“সেই রবিবারের সকাল থেকে (অর্থাৎ‌ দোলনীয় নৈবেদ্যর জন্য আনীত শস্যের আঁটি আনার দিন থেকে) সাত সপ্তাহ গুনে নাও| ");
INSERT INTO ben2006_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","সপ্তম সপ্তাহ পরে রবিবারে (অর্থাৎ‌ 50 দিন পরে) তোমরা প্রভুর কাছে একটি নতুন শস্য নৈবেদ্য আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ঐ দিনে তোমাদের বাড়ী থেকে দুুকরো রুটি নিয়ে আসবে| ঐ রুটি দোলনীয় নৈবেদ্যর জন্য নির্দিষ্ট হবে| ঐ রুটি তৈরী করার জন্য খামির এবং 16 কাপ ময়দা ব্যবহার কর| এটাই হবে তোমাদের প্রথম শস্য থেকে প্রভুর কাছে দেওয়া উপহার| ");
INSERT INTO ben2006_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“লোকরা শস্য নৈবেদ্যর সঙ্গে একটি ষাঁড়, একটি মেষ এবং সাতটি এক বছর বয়স্ক পুরুষ মেষশাবক দেবে| ঐসব প্রাণীর মধ্যে অবশ্যই কোন দোষ থাকবে না| তারা প্রভুর কাছে হোমবলির নৈবেদ্য হবে| শস্য নৈবেদ্য ও পেয় নৈবেদ্যর সাথে হবে ঈশ্বরের উদ্দেশ্যে অগ্নির দ্বারা প্রদত্ত নৈবেদ্য| এর গন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","এ ছাড়াও তোমরা পাপার্থক নৈবেদ্যর জন্য একটি পুরুষ ছাগল এবং মঙ্গল নৈবেদ্য হিসেবে দুটি এক বছর বয়সী পুরুষ মেষশাবক আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“যাজক তাদের প্রথম শস্য থেকে তৈরী রুটি সহ দোলনীয় নৈবেদ্যর দুটি মেষশাবক প্রভুর সামনে দোলাবে| তারা প্রভুর কাছে পবিত্র| তারা থাকবে যাজকের অধিকারে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ঐ একই দিনে তোমরা এক পবিত্র সভা ডাকবে| তোমরা অবশ্যই কোন কাজ করবে না| তোমাদের সকলের বাড়ীতে এই বিধি চিরকালের জন্য চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“উপরন্তু যখন তোমরা তোমাদের জমিতে শস্য বপন করবে, তখন তোমাদের ক্ষেতের কোণগুলির শস্য কাটবে না| মাটির ওপর পড়ে থাকা শস্য তোমরা তুলবে না| সেই জিনিসগুলি গরীবদের জন্য এবং তোমাদের দেশে ভ্রমণকারী বিদেশীদের জন্য রেখে দেবে| আমিই প্রভু তোমাদের ঈশ্বর!” ");
INSERT INTO ben2006_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","প্রভু আবার মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ইস্রায়েলের লোকদের বল: সপ্তম মাসের প্রথম দিন তোমরা বিশ্রামের বিশেষ দিন হিসেবে পালন করবে| সেই পবিত্র সভা লোকদের স্মরণ করানোর জন্য ভেরী বাজাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","সেদিন তোমরা অবশ্যই কোন কাজ করবে না এবং অগ্নি প্রদত্ত একটি নৈবেদ্য তোমরা প্রভুর কাছে আনবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“সপ্তম মাসের দশম দিনটি প্রায়শ্চিত্তের দিন, সেদিন এক পবিত্র সভা হবে| সেদিন তোমরা অবশ্যই কোন খাদ্য গ্রহণ করবে না এবং অগ্নিতে প্রদত্ত একটি নৈবেদ্য প্রভুর কাছে আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","তোমরা অবশ্যই ঐ দিন কোন কাজ করবে না, কারণ এটা হল প্রায়শ্চিত্তের দিন| ঐ দিন যাজকরা প্রভুর কাছে যাবে এবং যা তোমাদের শুচি করে সেই সব আচারানুষ্ঠান করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“এই দিন যদি কোন মানুষ উপবাস করতে অস্বীকার করে সে অবশ্যই তার লোকদের থেকে বিচ্ছিন্ন হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","এই দিন যদি কোন ব্যক্তি কোন কাজ করে, আমি তার লোকদের মধ্যে সেই ব্যক্তিকে ধ্বংস করব| ");
INSERT INTO ben2006_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","সেদিন তোমরা অবশ্যই আদৌ কোন কাজ করবে না| তোমরা যেখানেই বসবাস করো না কেন, তোমাদের জন্য এটা হল চিরকালের বিধি| ");
INSERT INTO ben2006_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","এটা তোমাদের জন্য হবে বিশেষ বিশ্রামের দিন| তোমরা সেদিন অবশ্যই খাদ্য গ্রহণ করবে না| বিশ্রামের এই বিশেষ দিন তোমরা আরম্ভ করবে মাসের নবম দিনের সন্ধ্যায় এবং তা চলবে সেই সন্ধ্যা থেকে পরের দিনের সন্ধ্যা পর্যন্ত|” ");
INSERT INTO ben2006_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","প্রভু আবার মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ইস্রায়েলের লোকদের বলো: সপ্তম মাসের 15 দিনের দিন হল কুটির উৎসব পালনের দিন| প্রভুর উদ্দেশ্যে এই উৎসব সাত দিন ধরে চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","প্রথম দিনে একটি পবিত্র সভা হবে| তোমরা অবশ্যই সেদিন কোন কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","সাতদিন ধরে তোমরা প্রভুর কাছে প্রতিদিন একটি করে অগ্নিতে প্রস্তুত নৈবেদ্য আনবে| আট দিনের দিন তোমাদের আর একটা পবিত্র সভা হবে| তোমরা প্রভুর কাছে অগ্নি দ্বারা প্রস্তুত একটি নৈবেদ্য আনবে| এটা হবে একটা পবিত্র সভা| তোমরা অবশ্যই সেদিন কোন কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ঐগুলি হল প্রভুর পর্ব| ঐ সমস্ত পর্বের দিনগুলিতে পবিত্র সভা অনুষ্ঠিত হবে| তোমরা প্রভুর কাছে হোমবলি, শস্য নৈবেদ্যসমুহ, বলিগুলি এবং পেয় নৈবেদ্যসমুহ আনবে| তোমরা ঠিক ঠিক দিনে ঐ সমস্ত উপহার আনবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ঐ সমস্ত পর্বের দিনগুলির সঙ্গে প্রভুর বিশ্রামের দিনগুলি স্মরণ করে তোমরা পালন করবে| এই সমস্ত নৈবেদ্যগুলি তোমরা প্রভুর কাছে যে বিশেষ নৈবেদ্য দিতে চাও এবং বিশেষ প্রতিশ্রুতির জন্য যে উপহার দিতে চাও তার সঙ্গে যোগ হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“সপ্তম মাসের 15 দিনে, যখন তোমরা জমির শস্য সংগ্রহ করবে তখন তোমরা সাতদিন ধরে প্রভুর উৎসব পালন করবে| তোমরা প্রথম দিন ও সপ্তম দিনে বিশ্রাম করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","প্রথম দিনটিতে তোমরা সুন্দর গাছগুলি থেকে ফল এবং নদীর তীরবর্তী তালগাছগুলির, ঝাউগাছগুলির এবং বাইসী গাছগুলির ডালগুলি নেবে| তোমরা সাতদিন ধরে তোমাদের প্রভু ঈশ্বরের সামনে উৎসব করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","প্রতি বছরে সাত দিন ধরে তোমরা এই পর্ব প্রভুর জন্য পালন করবে| এই বিধি চিরকাল চলবে| সপ্তম মাসে তোমরা এই পর্ব পালন করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","তোমরা সাতদিন ধরে অস্থায়ী কুটিরে বসবাস করবে| ইস্রায়েলে জন্ম নেওয়া সমস্ত লোক ঐ সমস্ত আবাসে বাস করবে, ");
INSERT INTO ben2006_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","যাতে তোমাদের সমস্ত উত্তরপুরুষ জানে যে তাদের মিশর থেকে বাইরে আনার সময় আমি ইস্রায়েলের লোকদের অস্থায়ী আবাসে বসবাসের ব্যবস্থা করেছিলাম| আমিই প্রভু তোমাদের ঈশ্বর!” ");
INSERT INTO ben2006_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","সুতরাং মোশি ইস্রায়েলের লোকদের প্রভুর পর্বগুলির কথা বললেন| ");
INSERT INTO ben2006_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ইস্রায়েলের লোকদের আজ্ঞা দাও নিঙড়ানো অলিভ থেকে খাঁটি তেল তোমার কাছে আনতে| সেই তেল লাগবে বাতিগুলির জন্য| যেন সবসময় সেগুলি জ্বলে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","হারোণ প্রভুর সামনে সন্ধ্যা থেকে সকাল পর্যন্ত সমাগম তাঁবুর মধ্যে বাতি জ্বালিয়ে রাখবে| পর্দার বাইরে সাক্ষ্য সিন্দুকের সামনে সেই বাতিটি থাকবে| এই বিধি চিরকাল ধরে চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","প্রভুর সামনে খাঁটি সোনার বাতিস্তম্ভের ওপর রাখা বাতিগুলিকে হারোণ নিয়মিত জ্বালিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“মিহি ময়দা নাও এবং তা দিয়ে বারোটি রুটি সেঁকে নাও| প্রতি রুটির জন্য 16 কাপ করে ময়দা ব্যবহার কর| ");
INSERT INTO ben2006_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","প্রভুর সামনে সোনার টেবিলের ওপর সেগুলি দুটি সারিতে রাখো| প্রতি সারিতে থাকবে দুটি করে রুটি| ");
INSERT INTO ben2006_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","প্রতি সারিতে কুন্দুরু ঢালবে| এটা প্রভুর কাছে দেওয়া দগ্ধ নৈবেদ্য দানের স্মৃতি রক্ষায প্রভুকে সাহায্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","প্রতিটি শনিবারে নিয়মিতভাবে হারোণ প্রভুর সামনে রুটি সাজিয়ে রাখবে| ইস্রায়েলের লোকদের সঙ্গে এই চুক্তি চিরকাল চলবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ঐ রুটি হারোণ এবং তার ছেলেদের অধিকারে থাকবে| তারা কোন পবিত্র জায়গায় ঐ রুটি খাবে, কারণ সেই রুটি প্রভুর প্রতি অগ্নিকৃত নৈবেদ্যসমুহের একটি| সেই রুটি চিরকালের জন্য হারোণের অংশ|” ");
INSERT INTO ben2006_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","একজন ইস্রায়েলীয় মহিলার একটি ছেলে ছিল, যার পিতা ছিল একজন মিশরীয়| সেই ছেলে ইস্রায়েলের লোকদের মধ্যে ঘুরে বেড়াতে গেল| এমন সময় তাঁবুর মধ্যে তার সাথে এক ইস্রায়েলের পুরুষের লড়াই শুরু হল| ");
INSERT INTO ben2006_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ইস্রায়েলীয় স্ত্রীলোকের সন্তানটি প্রভুর নামে নিন্দা করে অভিশাপ দিতে শুরু করলে লোকরা তাকে মোশির কাছে নিয়ে এল| (ছেলেটির মায়ের নাম ছিল শালোমীত্‌, দিব্রির মেয়ে, দান এর পরিবারগোষ্ঠী থেকে আগত|) ");
INSERT INTO ben2006_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","লোকরা ছেলেটিকে গ্রেফতার করে প্রভুর স্পষ্ট আদেশের জন্য অপেক্ষা করল| ");
INSERT INTO ben2006_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“যে অভিশাপ দিয়েছিল তাকে তাঁবুর বাইরে নিয়ে এসো| যারা তাকে অভিশাপ দিতে শুনেছিল, তারা তাদের হাত ছেলেটির মাথায় রাখবে, এবং তখন সমস্ত মানুষ তার দিকে পাথর ছুঁড়বে এবং তাকে হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ইস্রায়েলের লোকদের বলো: যদি কোন ব্যক্তি তার ঈশ্বরকে অভিশাপ দেয়, তাহলে সে অবশ্যই শাস্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","যে কোন ব্যক্তি প্রভুর নামের বিরুদ্ধে কথা বললে সে অবশ্যই নিহত হবে| সমস্ত মানুষ তাকে পাথর মারবে| ইস্রায়েলে জন্মগ্রহণ করা মানুষের মত বিদেশীরাও যদি ঈশ্বরের নামকে অভিশাপ দেয়, তাহলে সে অবশ্যই মৃত্যুমুখে পতিত হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“যদি কোন ব্যক্তি অপর এক ব্যক্তিকে হত্যা করে তবে সে অবশ্যই মৃত্যুদণ্ডে দণ্ডিত হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","কোন ব্যক্তি যদি কারো পশু হত্যা করে তবে সে তার জায়গায় আর একটি পশু দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“কোন ব্যক্তি তার প্রতিবেশীকে আঘাত করলে ঠিক সেই ধরণের আঘাত দিয়ে লোকটিকে শাস্তি দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ভাঙ্গা হাড়ের বদলে ভাঙ্গা হাড়, চোখের বদলে চোখ এবং দাঁতের বদলে দাঁত| লোকে অন্যকে যে ধরণের আঘাত দেয়, ঠিক সেই ধরণের আঘাত দিয়ে তাকে শাস্তি দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","সুতরাং যদি কোন ব্যক্তি এক প্রাণী হত্যা করে তাহলে ব্যক্তিকে অবশ্যই প্রাণীর জন্য ক্ষতিপূরণ দিতে হবে; কিন্তু যদি কোন ব্যক্তি অপর কোন ব্যক্তিকে হত্যা করে, তাহলে সে অবশ্যই মৃত্যুদণ্ডে দণ্ডিত হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“বিদেশীদের জন্য এবং তোমাদের নিজের দেশের লোকদের জন্য একইরকম অনুশাসন হবে| কেন? কারণ আমিই প্রভু, তোমাদের ঈশ্বর!” ");
INSERT INTO ben2006_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","তখন মোশি ইস্রায়েলের লোকদের বলল, যে লোকটা তাঁবুর বাইরের জায়গায় অভিশাপ দিচ্ছিল তাকে নিয়ে এসো| তারপর তারা লোকটাকে পাথর মেরে হত্যা করল| এইভাবে প্রভু মোশিকে যে আদেশ দিয়েছিলেন ইস্রায়েলের লোকরা সেই অনুসারেই কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","সীনয় পর্বতে প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ইস্রায়েলের লোকদের বলো: আমি যে দেশ তোমাদের দিচ্ছি, সেখানে প্রবেশ করলে তোমরা জমিটিকে বিশ্রামের সময় দেবে| প্রভুকে সম্মান দেওয়ার জন্য এই বিশ্রামের সময় বিশেষ সময়| ");
INSERT INTO ben2006_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","তোমরা ছ’বছর ধরে তোমাদের জমিতে বীজ বপন করবে, তোমাদের দ্রাক্ষা ক্ষেতগুলিতে গাছগুলিকে ছ’বছর ছাঁটবে এবং ফল নিয়ে আসবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","কিন্তু সপ্তম বছরে প্রভুকে সম্মান জানানোর জন্য তোমরা জমিকে বিশ্রাম দেবে| এই সময় তোমরা তোমাদের ক্ষেতে বীজ বপন করবে না অথবা তোমাদের দ্রাক্ষা ক্ষেতে গাছগুলি ছাঁটবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ফসল কাটার পর যে সমস্ত শস্য নিজেরাই জন্মেছে, তোমরা অবশ্যই তাদের কাটবে না| যে সমস্ত দ্রাক্ষালতা ছাঁটা হয়নি সেখান থেকে তোমরা অবশ্যই দ্রাক্ষা সংগ্রহ করবে না| জমি এক বছর বিশ্রামে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“কিন্তু জমি এক বছরের বিশ্রামে থাকাকালীন ইস্রায়েলে উৎপন্ন হবে তাতে তোমাদের জন্য, তোমাদের পুরুষ এবং মহিলা ভৃত্যদের খাবার জন্য প্রচুর খাদ্য থাকবে| তোমাদের জনখাটা ভাড়াটে শ্রমিকদের জন্য, তোমাদের দেশে বসবাস করা বিদেশীদের জন্য ");
INSERT INTO ben2006_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","এবং তোমাদের পশুদের ও তোমার দেশের বন্য পশুদের খাবার মত প্রচুর খাদ্য থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“তোমরা সাত বছর সাত বার গণনা করবে| ঐ সময়ের মধ্যে জমির জন্য থাকবে সাত বছরের বিরতি| এটা হবে 49 বছর| ");
INSERT INTO ben2006_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","তখন সপ্তম মাসের দশম দিনটিতে অর্থাৎ‌ প্রায়শ্চিত্তের দিনে তোমরা অবশ্যই মেষের শিং বাজাবে, সারা দেশময় এই মেষের শিং বাজাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","তোমরা 50তম বছরকে একটি বিশেষ বছর গণ্য করবে| তোমাদের রাজ্যে বাস করা সমস্ত মানুষের জন্য তোমরা মুক্তি ঘোষণা করবে| এই সময়টিকে বলা হবে ‘জুবিলী’| তোমাদের প্রত্যেকে যে যার নিজস্ব সম্পত্তি ফিরে পাবে এবং তোমরা প্রত্যেকেই যে যার নিজের পরিবারে ফিরে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","তোমাদের পক্ষে 50তম বছরটি হবে জুবিলীর বছর| তোমরা বীজ বপন করবে না| যে সমস্ত শস্য নিজে নিজেই হবে, সেগুলি কাটবে না| যে সব দ্রাক্ষালতা ছাঁটা হয় না তাদের থেকে দ্রাক্ষা ফল সংগ্রহ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ঐ বছরটা হল জুবিলী বছর| এটা তোমাদের পক্ষে পবিত্র সময়| যে সমস্ত শস্য ক্ষেত থেকে আসে, তোমরা সেগুলি আহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","জুবিলী বছরে প্রত্যেক ব্যক্তি তার নিজের বিষয় আশয়ের মধ্যে ফিরে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“যখন তোমরা প্রতিবেশীর কাছে তোমাদের জমি বিক্রি করবে বা তাদের কাছ থেকে তা কিনবে তখন পরস্পরকে ঠকিও না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","যদি তোমরা তোমাদের প্রতিবেশীর জমি কিনতে চাও, তাহলে বিগত শেষ জুবিলী বছর থেকে বছরগুলো গুনে নাও এবং সঠিক মূল্য নির্ণযে সেই সংখ্যাটি ব্যবহার কর| কারণ সে তোমার কাছে কেবলমাত্র পরের জুবিলী বছর আসা পর্যন্ত শস্য কাটার অধিকার বিক্রয়় করেছে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","যদি পরের জুবিলী আসতে অনেক দেরী থাকে সেক্ষেত্রে দাম হবে অনেক বেশী| যদি বছরগুলি কম হয়, তাতে দাম কম হবে| কেন? কারণ তোমাদের প্রতিবেশী প্রকৃতপক্ষে, তোমার কাছে জুবিলীর যতগুলি বছর বাকি আছে ততগুলি ফসর বিক্রি করছে| পরবর্তী জুবিলী বছরে সেই জমি আবার তার পরিবারের অধিকারে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","তোমরা পরস্পর পরস্পরকে কখনও ঠকিও না| কিন্তু ঈশ্বরকে ভয় করো| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“আমার বিধিসমূহ এবং নিয়মাবলী মনে রেখো, সেগুলি মান্য করো, তাহলে তোমরা নির্ভয়ে তোমাদের দেশে বাস করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","তোমাদের জন্য জমি ভাল শস্যের ফলন দেবে| তখন তোমাদের প্রচুর খাদ্য হবে এবং তোমরা দেশে নির্ভয়ে বাস করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“কিন্তু হয়তো তোমরা বলবে, ‘যদি আমরা বীজ বপন না করি অথবা আমাদের শস্যসমূহ সংগ্রহ না করি, তাহলে সপ্তম বছরে খাবার মত আমাদের কিছুই থাকবে না|’ ");
INSERT INTO ben2006_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","শঙ্কিত হয়ো না| ষষ্ঠ বছরে আমি আমার আশীর্বাদ তোমাদের কাছে পাঠাবো| তিন বছর ধরে জমিতে শস্য জন্মাতে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","অষ্টম বছরে রোপন করার সময়ও তোমাদের পুরানো শস্য খেয়ে শেষ হবে না| অষ্টম বছরে চাষ করা শস্য আসার আগে নবম বছর পর্যন্ত তোমরা পুরানো শস্য খেতে পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“জমি আমার, তাই তোমরা স্থায়ীভাবে তা বিক্রি করতে পারো না| আমার জমিতে আমার সঙ্গে তোমরা কেবলমাত্র বিদেশী এবং ভ্রমণকারী হিসেবে বসবাস করছ| ");
INSERT INTO ben2006_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","বিক্রি হলেও জমির পুরানো মালিক যেন তা আবার কিনে নিতে পারে| এই প্রথা যেন দেশে থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","তোমাদের দেশের কোন ব্যক্তি যদি খুব গরীব হয়ে যায়, সে এত বেশী গরীব যে সে তার সম্পত্তি বিক্রি করে দিয়েছে| সুতরাং সেক্ষেত্রে তার ঘনিষ্ঠ আত্মীয় আসবে এবং তার আত্মীয়কে ফিরিয়ে দেবার জন্য সমস্ত সম্পত্তি কিনে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","কোন ব্যক্তির ঘনিষ্ঠ এমন আত্মীয় নাও থাকতে পারে, কিন্তু সে যদি নিজের জমি পুনরায় কিনে নেবার জন্য ধনবান হয়, ");
INSERT INTO ben2006_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","তাহলে সে অবশ্যই জমি বিক্রির সময় থেকে বছরগুলো গণনা করবে| জমির জন্য কত দিতে হবে তাতে সিদ্ধান্ত নিতে সেই সংখ্যা কাজে লাগাবে| তারপর সে সেই জমি কিনে নিতে পারে| এরপর জমি আবার তার সম্পত্তি হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","কিন্তু যদি এই ব্যক্তি তার নিজের জন্য জমি ফেরত পেতে প্রয়োজনীয় অর্থ না জোগাড় করতে পারে, তাহলে সে যা বিক্রি করেছে তা জুবিলী বছর না আসা পর্যন্ত যে কিনেছিল তার হাতেই থাকবে| তারপর সেই জুবিলী বছরে জমি ফেরত যাবে প্রথম স্বত্ত্বাধিকারীর কাছে| সুতরাং সম্পত্তি আবার সঠিক পরিবারের অধিকারে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“যদি কোন ব্যক্তি প্রাচীরে ঘেরা শহরের মধ্যে কোন বাড়ী বিক্রি করে, তাহলে তার বিক্রির পর একটি বছর পূর্ণ না হওয়া পর্যন্ত সেটা ফেরত পাওয়ার অধিকার তার আছে| এই অধিকার এক বছর পর্যন্ত থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","কিন্তু এক বছর পূর্ণ হওয়ার আগে যদি মালিক বাড়িটি কিনে ফেরত না দেয়, তাহলে প্রাচীরে ঘেরা শহরের বাড়িটি যে কিনেছিল, তা তার এবং তার উত্তরপুরুষদের অধিকারে থেকে যাবে| বাড়িটি জুবিলীর সময় প্রথম মালিকের কাছে ফেরত যাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","চারপাশে প্রাচীর না দেওয়া ছোট শহর বা গ্রামগুলিকে খোলা মাঠের মত ধরা হবে| সুতরাং সেইসব ছোট শহরগুলিতে নির্মিত বাড়িগুলি জুবিলীর সময় প্রথম মালিকদের কাছে ফেরত যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“লেবীয়দের শহর সম্পর্কে; লেবীয় বংশধররা যে শহরগুলির অধিকারী, সেখানে তাদের বাড়ীগুলি যে কোন সময়ে তারা কিনে ফেরত পেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","কোন ব্যক্তি যদি একজন লেবী বংশধরের কাছ থেকে বাড়ী কেনে, তবে জুবিলী বছরে লেবীয়দের শহরের সেই বাড়ী আবার লেবীয় বংশধরদের কাছে ফিরে আসবে| কারণ ইস্রায়েলের মানুষের মধ্যে লেবীয়দের শহরের বাড়ীগুলি লেবীগোষ্ঠীর পরিবারের লোকদের অধিকারেই থাকে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","লেবীয়দের শহরসমুহ, ঘিরে রাখা মাঠসমুহ ও প্রান্তরসমুহ বিক্রয়় করা যাবে না| ঐ মাঠগুলি লেবীয় বংশধরদের চিরকালের অধিকার| ");
INSERT INTO ben2006_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“তোমাদের নিজেদের দেশের কোন এক ব্যক্তি যদি আর্থিকভাবে নিজের ভারবহন করার ব্যাপারে খুবই অক্ষম হয়ে পড়ে, তবে তোমরা অবশ্যই তাকে তোমাদের সঙ্গে একজন বিদেশী ও প্রবাসীর মত বসবাস করতে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","তাকে তোমরা ধার দিতে পারো এমন কোন অর্থের ওপর সুদ তার কাছ থেকে নিও না| তোমাদের ঈশ্বরকে শ্রদ্ধা কর এবং তোমাদের ভাইকে তোমাদের সঙ্গে বাস করতে দাও| ");
INSERT INTO ben2006_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","তাকে ধার দিয়েছ এমন অর্থের উপর কোন সুদ তার কাছ থেকে লাভ করার চেষ্টা করো না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","আমিই প্রভু তোমাদের ঈশ্বর| কনান দেশ দেওয়ার জন্য এবং তোমাদের ঈশ্বর হওয়ার জন্য আমি তোমাদের মিশর দেশ থেকে এনেছিলাম| ");
INSERT INTO ben2006_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“তোমাদের নিজেদের দেশের কোন ব্যক্তি যদি এত গরীব হয়ে পড়ে যে সে নিজেকে দাস হিসেবে তোমাদের কাছে বিক্রি করতে বাধ্য হয়, তখন তোমরা অবশ্যই তাকে ভৃত্যের মত কাজে লাগাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","জুবিলী বছর না আসা পর্যন্ত, সে তোমাদের কাছে জন খাটার কর্মী এবং একজন বিদেশীর মতো হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","তারপর সে তোমাদের ছেড়ে তার সন্তানসন্ততিদের নিয়ে নিজের পরিবারে এবং তার পূর্বপুরুষদের সম্পত্তিতে ফিরতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","কারণ তারা আমার দাস| আমি মিশরের দাসত্ব থেকে তাদের নিয়ে এসেছি| তারা অবশ্যই আবার দাস হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","তোমরা এই ব্যক্তির একজন নির্দয় প্রভু অবশ্যই হতে পারো না| তোমরা অবশ্যই তোমাদের ঈশ্বরকে শ্রদ্ধা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“তোমাদের চারপাশের অন্যান্য জাতিদের থেকে পুরুষ এবং নারী ভৃত্যদের তোমরা পেতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","তোমরা শিশুদেরও দাস হিসেবে নিতে পার যদি তারা তোমাদের দেশে বসবাসকারী বিদেশীদের পরিবারসমূহ থেকে আসে| সেইসব শিশু ভৃত্যরা তোমাদের অধিকারে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","তোমরা এমনকি তোমাদের মৃত্যুর আগে এই সমস্ত বিদেশী দাসদের তোমাদের ছেলেমেয়েদের হেফাজতে দিয়ে যেতে পারো, যাতে তারা তোমাদের ছেলেমেয়েদের অধিকারে থাকে| তারা চিরকালের জন্য তোমাদের দাস হবে| তোমরা এইসব বিদেশীদের দাস বানাতে পারো; কিন্তু তোমরা অবশ্যই তোমাদের নিজেদের ভাইদের, ইস্রায়েলের লোকদের নির্দয় মনিব হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“তোমাদের মধ্যে থেকে কোন বিদেশী বা দর্শনার্থী ধনী হতে পারে| অন্যদিকে তোমাদের দেশের এক ব্যক্তি গরীব হয়ে যেতে পারে এবং নিজেকে দাস হিসেবে তোমাদের মধ্যে বসবাসকারী বিদেশীর কাছে বা বিদেশীদের পরিবারের কোন সদস্যর কাছে নিজেকে বিক্রি করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","সেই লোকটির অধিকার আছে ক্রয়ের মধ্যে দিয়ে ফিরে আসার এবং স্বাধীন হওয়ার| তার ভাইদের কোন একজন তাকে কিনে ফেরত পেতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","অথবা তার কাকা বা খুড়তুতো ভাই তাকে কিনে ফেরত পেতে পারে| অথবা তার পরিবারের ঘনিষ্ঠ আত্মীয়দের একজন তাকে কিনে ফেরত পেতে পারে| বা যদি লোকটি প্রচুর অর্থ পায়, সে নিজে অর্থ শোধ করে আবার স্বাধীন হতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“তোমরা কেমনভাবে মূল্য ইস্রায়েলেচাই করবে? বিদেশীর কাছে তার নিজেকে বিক্রি করার সময়ের বছরগুলি থেকে পরের জুবিলী বছর পর্যন্ত তোমরা অবশ্যই গণনা করবে| মূল্য ঠিক করতে তোমরা সংখ্যাটা ব্যবহার করবে| কারণ প্রকৃতপক্ষে লোকটি কয়েক বছরের জন্য তাকে ‘ভাড়া’ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","যদি কোন ক্ষেত্রে জুবিলী বছরের আগে আরও অনেক বছর থেকে যায়, তখন লোকটি মূল্যের মোটা অংশ অবশ্যই ফেরত দেবে| এটা নির্ভর করে বছরের সংখ্যাসমুহের ওপর| ");
INSERT INTO ben2006_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","জুবিলী বছর আসার যদি কেবলমাত্র সামান্য কয়েক বছর থাকে, তাহলে লোকটি অবশ্যই মূল মূল্যের সামান্য অংশ ফেরৎ‌ দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","কিন্তু সেই লোকটি প্রতি বছর বিদেশীর সঙ্গে ভাড়া করা লোকের মত বসবাস করবে| সেই লোকটির প্রতি বিদেশীকে নির্দয় প্রভু হতে দিও না| ");
INSERT INTO ben2006_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“সেই লোকটিকে মুক্ত করার জন্য যদি কেউই দাম দিতে না চায় তাহলেও জুবিলী বছরে সে স্বাধীন হবে| জুবিলী বছরে সে এবং তার সন্তানসন্ততিরা স্বাধীন হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","কারণ ইস্রায়েলের লোকরা আমার দাস| তারা আমার দাস যেহেতু আমি তাদের মিশরের দাসত্বের বাইরে নিয়ে এসেছি| আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“তোমাদের নিজেদের জন্য প্রতিমূর্ত্তি গড়বে না| তাদের প্রণাম করবার জন্যে তোমাদের দেশে মূর্ত্তি বা স্মৃতিফলকসমুহ গড়বে না| কেন? কারণ আমিই প্রভু তোমাদের ঈশ্বর! ");
INSERT INTO ben2006_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“আমার বিশ্রামের বিশেষ দিনগুলি মনে রেখো এবং আমার পবিত্র স্থানকে সম্মান দিও| আমিই প্রভু! ");
INSERT INTO ben2006_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“আমার বিধিসমুহ ও আজ্ঞাসমুহ মনে রেখো এবং তাদের মান্য করো| ");
INSERT INTO ben2006_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","যদি তোমরা আমার আজ্ঞাসমূহ মেনে চলো তাহলে যে সময়ে বৃষ্টি আসা উচিৎ‌, আমি সে সময়ে তোমাদের বৃষ্টি দেবো| জমিতে শস্য উৎপন্ন হবে এবং মাঠের বৃক্ষগুলিতে ফল ধরবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","দ্রাক্ষা ফলগুলি সংগ্রহ করার সময় না আসা পর্যন্ত তোমাদের শস্যাদি মাড়াই চলতে থাকবে এবং রোপণের সময় না আসা পর্যন্ত তোমাদের দ্রাক্ষা সংগ্রহ চলতে থাকবে| সুতরাং খাবার জন্য তোমাদের প্রচুর খাবার থাকবে এবং তোমরা নির্ভয়ে তোমাদের দেশে বাস করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","আমি তোমাদের দেশে শান্তি বজায় রাখবো| তোমরা শান্তিতে থাকবে| কোন মানুষ তোমাদের ভীত সন্ত্রস্ত করবে না| বিপজ্জনক প্রাণীদের তোমাদের দেশের বাইরে রাখবো| আর তোমাদের দেশে শত্রু সৈন্যরা আসবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“তোমরা তোমাদের শত্রুদের তাড়া করে পরাজিত করবে এবং তরবারি দিয়ে তাদের হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","তোমাদের পাঁচ জন তাদের 100 জনকে ধাওয়া করবে এবং 100 জন ধাওয়া করবে 10,000 জনকে| তোমরা তোমাদের শত্রুদের পরাজিত করবে এবং তোমাদের অস্ত্র দিয়ে তাদের হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“আর আমি তোমাদের প্রতি প্রসন্ন হব| আমি তোমাদের অনেক সন্তানসন্ততি দিয়ে আশীর্বাদ করব এবং তোমাদের সংখ্যা বৃদ্ধি করব| আমি তোমাদের সঙ্গে আমার চুক্তি রক্ষা করবো| ");
INSERT INTO ben2006_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","এক বছরের বেশী সময় ধরে তোমরা তোমাদের জমা করা শস্য খাবে| তোমরা নতুন শস্যাদি ছেদন করবে, তারপর নতুন শস্যগুলি রাখার মত জাযজার জন্য পুরানো শস্যগুলিকে ফেলে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","এছাড়াও আমি তোমাদের মধ্যে আমার পবিত্র শিবির বসাবো| আমি তোমাদের থেকে সরে ইস্রায়েলেবো না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","আমি তোমাদের সঙ্গে ওঠা বসা করব, তোমাদের ঈশ্বর হবো এবং তোমরা হবে আমার লোকজন| ");
INSERT INTO ben2006_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","আমিই প্রভু, তোমাদের ঈশ্বর| তোমরা মিশরে দাস ছিলে, কিন্তু আমি তোমাদের মিশরের বাইরে এনেছি| দাস হয়ে তোমরা ভারী ওজনের জিনিস বইতে গিয়ে নুযে থাকতে, কিন্তু আমি তোমাদের কাঁধের যোয়ালীর কাঠ ভেঙ্গে দিয়েছি| আমি তোমাদের আবার সোজা হয়ে হাঁটবার সুযোগ দিয়েছি| ");
INSERT INTO ben2006_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“কিন্তু যদি তোমরা আমাকে এবং আমার সমস্ত আজ্ঞাগুলি মান্য না করো, তাহলে এই সমস্ত খারাপ ঘনাগুলো ঘটবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","যদি তোমরা আমার বিধিসমুহ এবং আজ্ঞাগুলি মানতে অস্বীকার কর, তার অর্থ তোমরা আমার চুক্তি ভঙ্গ করেছো| ");
INSERT INTO ben2006_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","যদি তোমরা তা করো, সেক্ষেত্রে আমি ভয়ঙ্কর সব ঘটনা ঘটাবো, আমি তোমাদের মধ্যে ছড়িয়ে দেব রোগ এবং জ্বর| সেগুলি তোমাদের চোখ নষ্ট করবে এবং তোমাদের প্রাণ নেবে| তোমরা বৃথাই বীজ বপন করবে, কারণ তোমাদের শত্রুরা তোমাদের শস্যসমুহ খেয়ে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","আমি তোমাদের বিরুদ্ধে দাঁড়াব, তাই তোমাদের শত্রুরা তোমাদের পরাজিত করবে| সেইসব শত্রুরা তোমাদের ঘৃণা করবে এবং শাসন করবে| এমন কি তোমাদের কেউ তাড়া না করলেও তোমরা পালাতে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“এই সমস্ত কিছুর পরও যদি তোমরা আমাকে মান্য না করো, তবে আমি তোমাদের পাপসমুহের জন্য সাতগুণ বেশী শাস্তি দেবো| ");
INSERT INTO ben2006_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","এবং যা তোমাদের গর্বিত করে সেই শহরগুলিকেও আমি ধ্বংস করে দেবো| আকাশ বৃষ্টি দেবে না এবং মাটিতেও শস্য জন্মাবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","তোমরা কঠিন পরিশ্রম করবে, কিন্তু তাতে তোমাদের কোন সাহায্য হবে না| তোমাদের জমি কোন শস্য দেবে না এবং তোমাদের গাছগুলিতে ফল ফলবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“যদি তা সত্ত্বেও তোমরা আমার বিরুদ্ধে ইস্রায়েলেও এবং আমাকে মান্য করতে অস্বীকার করো, আমি তোমাদের সাতগুণ কঠিন আঘাত করব| তোমরা যত পাপ করবে, তত শাস্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","আমি তোমাদের বিরুদ্ধে বুনো জন্তুদের পাঠাবো| তারা তোমাদের কাছ থেকে তোমাদের ছেলেমেয়েদের ছিনিয়ে নেবে, তোমাদের প্রাণীদের ধ্বংস করবে এবং তোমাদের অনেককে হত্যা করবে| লোকরা হাঁটাচলা করতে ভয় পাবে–রাস্তাঘাট ফাঁকা হয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ঐ সমস্ত কিছুর পরও তোমরা যদি উচিৎ‌ শিক্ষা না পাও এবং তারপরও যদি আমার বিরুদ্ধাচারী হও, ");
INSERT INTO ben2006_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তাহলে আমিও তোমাদের বিরুদ্ধে ইস্রায়েলেবো| আমি নিজে তোমাদের পাপসমুহের সাতগুণ শাস্তি দেব| ");
INSERT INTO ben2006_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","চুক্তিভঙ্গ করার শাস্তি দিতে আমি তোমাদের বিরুদ্ধে সৈন্যদের পাঠাবো| তোমরা তোমাদের নিরাপত্তার জন্য শহরে যাবে; কিন্তু আমি তোমাদের মধ্যে মহামারী ছড়িয়ে দেব| এবং তোমাদের শত্রুরা তোমাদের পরাজিত করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","আমি তোমাদের খাদ্য যোগানো বন্ধ করে দিলে একটি মাত্র উনুনে দশ জন মহিলা তাদের সমস্ত রুটি সেঁকতে পারবে| তারা তোমাদের মেপে খেতে দেবে তাই তোমরা আহার করবে কিন্তু তবু ক্ষুধার্ত থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“তা সত্ত্বেও তোমরা যদি আমার কথা শুনতে অস্বীকার করো এবং যদি তবু আমার বিরুদ্ধাচারণ করো, ");
INSERT INTO ben2006_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তাহলে আমি সত্যিই তোমাদের প্রতি ক্রুদ্ধ হবো এবং তোমাদের পাপসমুহের জন্য সাতগুণ শাস্তি দেব| ");
INSERT INTO ben2006_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","তোমরা এত বেশী ক্ষুধার্ত হবে যে তোমরা তোমাদের ছেলেদের এবং মেয়েদের ভক্ষণ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","আমি তোমাদের উচ্চ স্থানগুলিকে এবং মূর্ত্তির স্থানগুলিকে ধ্বংস করব| আমি সুগন্ধী উৎসর্গ করার বেদীগুলি নষ্ট করে দেব| আমি তোমাদের মৃতদেহগুলিকে তোমাদের মূর্ত্তির ওপর ফেলে দেব| আমার কাছে তোমরা হবে নিদারুণ বিরক্তিকর| ");
INSERT INTO ben2006_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","আমি তোমাদের শহরগুলি ধ্বংস করব, তোমাদের পবিত্র স্থানগুলিকে ফাঁকা করে দেব| আমি তোমাদের নৈবেদ্যসমুহের সুগন্ধের গন্ধ আর নেবো না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","আমি তোমাদের দেশকে ফাঁকা করব এবং তোমাদের শত্রুরা যারা সেখানে বসবাস করতে আসবে তারা তাই দেখে চমকে উঠবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","আমি তোমাদের জাতিগুলির মধ্যে ছড়িয়ে দেব এবং আমি আমার তরোয়াল বার করে তোমাদের ধ্বংস করব| তোমাদের দেশ ধ্বংসস্তূপে পরিণত হবে এবং শহরগুলি উচ্ছন্নে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“তোমরা তোমাদের শত্রুর দেশে আনীত হবে| তোমাদের দেশ হবে শূন্য, সুতরাং তোমাদের জমি নিয়ম অনুযায়ী তার বিশ্রাম পাবে| জমি তার বিশ্রাম সময়কে উপভোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","বিধি অনুযায়ী প্রতি সাত বছরে জমি এক বছর বিরাম পাবে| জমি শূন্য থাকার সময়ে বিরাম পাবে যা সেখানে তোমরা বাস করার সময় তাকে দাও নি| ");
INSERT INTO ben2006_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","প্রাণে বেঁচে যাওয়া ব্যক্তিরা তাদের শত্রুর দেশে নিজেদের সাহস হারাবে| তারা প্রত্যেক বিষয়ে আতঙ্কিত হবে| বাতাসে নড়া পাতার শব্দই তাদের ছুটে পালানোর পক্ষে যথেষ্ট হবে| তারা এমনভাবে দৌড়াতে থাকবে যেন কেউ তাদের তরবারি নিয়ে তাড়া করছে| এমন কি কেউ তাড়া না করলেও তারা উল্টে পড়বে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","কেউ পিছনে তাড়া না করলেও তরবারির ভয়ে প্রাণ বাঁচাতে তারা একে অপরের গায়ে উল্টে পড়বে| “শত্রুদের বিরুদ্ধে দাঁড়ানোর মতো শক্তি তোমাদের হবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","অন্য দেশগুলির মধ্যে তোমরা হারিয়ে যাবে| তোমাদের শত্রুদের দেশে তোমরা মুছে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","প্রাণে বেঁচে যাওয়া অবশিষ্ট লোকরা শত্রুদের রাজ্যগুলিতে তাদের নিজেদের পাপে এবং পূর্বপুরুষদের পাপে ক্ষয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“কিন্তু হতে পারে লোকরা তাদের পাপসমুহ স্বীকার করবে এবং হয়তো তারা তাদের পূর্বপুরুষদের পাপসমুহকে স্বীকার করবে| তারা হয়তো স্বীকার করবে যে তারা আমার প্রতি অবিশ্বস্ত হয়েছিল এবং আমার বিরুদ্ধাচারী হয়ে পাপ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","এবং তাই আমিও তাদের বিরুদ্ধে গিযেছিলাম এবং শত্রুদের তাদের রাজ্যে এনেছিলাম| এরপর যদি তারা নম্র হয় এবং তাদের পাপের জন্য দেওয়া শাস্তিকে গ্রহণ করে, ");
INSERT INTO ben2006_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","তাহলে ইস্রায়েলে যাকোবের সঙ্গে আমার করা সেই চুক্তিকে আমি স্মরণ করব| আমি ইসহাকের সঙ্গে করা চুক্তিকে স্মরণ করব এবং অব্রাহামের সঙ্গে করা চুক্তিকে স্মরণ করব| আমি দেশকে স্মরণ করব| ");
INSERT INTO ben2006_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“দেশ শূন্য হয়ে যাবে এবং ধ্বংসস্থান তার বিশ্রামের সময় উপভোগ করবে| তখন অবশিষ্ট জীবিতরা তাদের পাপের শাস্তিকে মেনে নেবে| তারা বুঝবে যে তারা আমার বিধিসমুহকে ঘৃণা করেছিল এবং আমার নিয়মাবলীকে মানতে অস্বীকার করেছিল বলে শাস্তি পেয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","কিন্তু এর পরেও শত্রুদের দেশে থাকাকালীন তারা যদি আমার কাছে সাহায্যের জন্য ফিরে আসে আমি তাদের দিক থেকে মুখ ফিরিয়ে নেব না| আমি তাদের কথা শুনবো| আমি তাদের সম্পূর্ণ ধ্বংস করব না| আমি তাদের সঙ্গে আমার চুক্তি ভঙ্গ করব না কারণ আমিই প্রভু তাদের ঈশ্বর| ");
INSERT INTO ben2006_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","তাদের ভালোর জন্যই আমি তাদের পূর্বপুরুষদের সঙ্গে করা চুক্তি স্মরণ করব| আমি অন্য জাতিদের সামনেই মিশর দেশ থেকে তাদের পূর্বপুরুষদের এনেছিলাম, যাতে আমি তাদের ঈশ্বর হতে পারি| আমিই প্রভু|” ");
INSERT INTO ben2006_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ঐগুলি হল বিধি, নিয়ম এবং শিক্ষামালা ইস্রায়েলে প্রভু ইস্রায়েলের লোকদের দিয়েছিলেন| প্রভু সীনয় পর্বতে ঐ বিধিগুলিকে দিয়েছিলেন এবং মোশি সেগুলি লোকদের জানিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ইস্রায়েলের লোকদের বলো: এক ব্যক্তি প্রভুর কাছে বিশেষ মানত হিসাবে কোন ব্যক্তিকে দেওয়ার প্রতিশ্রুতি দিতে পারে| ঐ লোকটি তখন বিশেষ পদ্ধতিতে প্রভুর সেবা করবে| ঐ লোকটির জন্য যাজক অবশ্যই মূল্য ঠিক করবে| ঐ লোকটিকে ফেরত পেতে হলে এই দাম দিতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","কুড়ি থেকে ষাট বছর বয়সের মধ্যেকার একজন পুরুষের দাম রূপোর 50 শেকেল| (তোমরা অবশ্যই পবিত্র স্থানের মাপ অনুসারে রূপোর মাপ ব্যবহার করবে|) ");
INSERT INTO ben2006_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","একজন স্ত্রীলোকের মূল্য অর্থাৎ‌ 20 থেকে 60 বছর বয়সীর দাম 30 শেকেল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","পাঁচ থেকে কুড়ি বছর বয়সী একজন পুরুষের দাম ২০ শেকেল। পাঁচ থেকে কুড়ি বছর বয়সী একজন স্ত্রীলোকের দাম 10 শেকেল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","একমাস থেকে পাঁচ বছর বয়সী এক ছোট ছেলের দাম 5 শেকেল| একটি ছোট মেয়ের দাম হল 3 শেকেল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ষাট বছরের বৃদ্ধ বা তার থেকে বেশী বয়সের মানুষের দাম হল 15 শেকেল| একজন স্ত্রীলোকের মূল্য 10 শেকেল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“যদি কোন মানুষ এত গরীব হয় যে দান দিতে অক্ষম, তাহলে সেই লোকটিকে যাজকের কাছে নিয়ে এসো| কত অর্থ লোকটিকে দিতে হবে, তা যাজক ঠিক করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“যদি কোন ব্যক্তি তার পশুগুলির মধ্যে কোন একটিকে প্রভুর প্রতি উৎসর্গ হিসাবে নিয়ে আসে, তাহলে সেই ধরণের সব পশু হবে পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","লোকটি প্রভুকে যে প্রাণীটি দেওয়ার প্রতিশ্রুতি দিয়েছিল তার জায়গায় অন্য প্রাণী যেন না রাখে, খারাপ পশুর জায়গায় একটা ভাল পশু দিয়ে বা ভাল পশুর জায়গায় একটা খারাপ পশু দিয়ে সে যেন বদলাবার চেষ্টা না করে| যদি এই ব্যক্তি প্রাণীসমূহ বদলের চেষ্টা করে, তাহলে দুটি প্রাণীই পবিত্র হবে| দুটি প্রাণী প্রভুর অধিকারে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“অশুচি বলে যে সব প্রাণী ঈশ্বরের প্রতি নৈবেদ্য হিসেবে প্রদত্ত হতে পারে না, যদি কোন ব্যক্তি সেইসব অশুচি প্রাণীদের একটি প্রভুর কাছে আনে, তাহলে সেই প্রাণীটিকে অবশ্যই যাজকের কাছে আনতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","যাজক সেই প্রাণীটির জন্য একটি দাম নির্দিষ্ট করবে| প্রাণীটি ভাল বা মন্দ হোক্্, তাতে কিছু আসে যায় না| যদি যাজক একটি মূল্য ঠিক করে তাতে সেটা হবে প্রাণীটির মূল্য| ");
INSERT INTO ben2006_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","যদি লোকটি প্রাণীটিকে কিনে ফেরত নিতে চায়, তাহলে সে অবশ্যই দামের পাঁচভাগের এক ভাগ ঐ দামের সঙ্গে যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“যদি কোন ব্যক্তি পবিত্র বিষয় হিসেবে তার বাড়ীটি প্রভুর প্রতি উৎসর্গ করে, তাহলে যাজক অবশ্যই তার দাম ঠিক করবে| বাড়ীটি ভালো বা খারাপ, তাতে কিছু যায় আসে না| যদি যাজক কোন দাম নির্দিষ্ট করে দেয় তাহলে তাই হবে বাড়ীটির দাম| ");
INSERT INTO ben2006_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","কিন্তু দাতা যদি তা ফেরত পেতে চায়, তাহলে সে অবশ্যই ঐ দামের ওপর দামের পাঁচ ভাগের একভাগ যোগ করবে| তাতে বাড়ীটি লোকটির অধিকারে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“যদি এক ব্যক্তি প্রভুর কাছে তার জমির অংশ উৎসর্গ করতে চায়, তবে ঐ জমির মূল্য নির্ভর করবে তা চাষ করতে কি পরিমাণ বীজের প্রয়োজন হয় তার ওপর| প্রতি হোমার এক ঝুড়ি যবের বীজের জন্য এর মূল্য হবে রূপোর 50 শেকেল| ");
INSERT INTO ben2006_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","যদি ব্যক্তিটি জুবিলী বছরের মধ্যে তার জমি ঈশ্বরকে দেয়, তাহলে তার দাম যাজক যা ঠিক করবে তাই হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","কিন্তু যদি লোকটি জুবিলীর পরে দেয়, তাহলে যাজক অবশ্যই তার প্রকৃত দাম গণনা করবে| পরবর্তী জুবিলী পর্যন্ত বছরের সংখ্যা গণনা করে দাম নির্ণয করতে সেই সংখ্যা অবশ্যই ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","যদি লোকটি তা কিনে ফেরত পেতে চায়, তাহলে সে ঐ দামের ওপর পাঁচ ভাগের এক ভাগ যোগ করবে| তাহলে জমি আবার সেই ব্যক্তির অধিকারে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","যদি ব্যক্তিটি জমি কিনে ফেরত না নেয় তবে তা যাজকদের দখলে থাকবে| যদি জমি অপর কাউকে বিক্রয়় করা হয়, তাহলে প্রথম ব্যক্তি জমি কিনে ফেরত পেতে পারবে না| ");
INSERT INTO ben2006_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","যদি ব্যক্তিটি জমি কিনে ফেরত না নিয়ে থাকে, তাহলে জুবিলী বছরে জমিটি প্রভুর কাছে পবিত্র হয়ে থাকবে| এটা যাজকের কাছে চিরকালের জন্য থেকে যাবে| এটা হবে প্রভুর কাছে সম্পূর্ণরূপে প্রদত্ত জমির মত| ");
INSERT INTO ben2006_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“যদি কোন ব্যক্তি তার কেনা জমি প্রভুকে উৎসর্গ করে এবং যদি তা তার পারিবারিক সম্পত্তির অংশ না হয়, ");
INSERT INTO ben2006_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","তাহলে যাজক অবশ্যই জুবিলী বছর পর্যন্ত বছর গণনা করে জমির দাম ঠিক করবে| এই মূল্য সেই দিনই লোকটিকে দিতে হবে আর এই অর্থ প্রভুর উদ্দেশ্যে পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","জুবিলী বছরে যদি আদি মালিকের কাছে অর্থাৎ‌ যে পরিবার জমির মালিক তার কাছে ফিরে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“তোমরা অবশ্যই সেই সব দাম মেটাতে পবিত্র স্থানের মাপ ব্যবহার করবে| সেই মাপে এক শেকেলের ওজন হল 20 গেরা| ");
INSERT INTO ben2006_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“প্রথমজাত প্রাণী, সে গোরু বা মেষ হোক্্ তাকে প্রভুর উদ্দেশ্যে উৎসর্গ করার প্রয়োজন নেই, কারণ তা তো প্রভুরই| ");
INSERT INTO ben2006_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","কিন্তু সেই প্রথমজাত প্রাণী একটি অপবিত্র প্রাণী হলে লোকটি অবশ্যই ঐ প্রাণীকে কিনে ফেরত নেবে| যাজক প্রাণীর দাম নির্দ্ধারণ করবে এবং ব্যক্তিটি অবশ্যই সেই দামের সঙ্গে দামের পাঁচ ভাগের এক ভাগ যোগ করবে| যদি ব্যক্তিটি সেই প্রাণীটিকে কিনে ফেরত না দেয় তাহলে যাজক প্রাণীটির যে দাম নির্দিষ্ট করেছে সেই দামে অবশ্যই বিক্রয়় করে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“এক বিশেষ ধরণের উপহার আছে যা লোকরা প্রভুকে দেয়| সেই উপহার একমাত্র প্রভুর অধিকারেই থাকে| সেই উপহারকে কিনে নেওয়া বা বিক্রয়় করা যায় না| সেই উপহার থাকে প্রভুর অধিকারে| সেই ধরণের উপহারের মধ্যে পড়ে মানুষ, প্রাণী এবং পারিবারিক সম্পত্তি থেকে আগত জমি| ");
INSERT INTO ben2006_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","প্রভুর প্রতি বিশেষ ধরণের উপহার যদি কোন ব্যক্তি হয় তা হলে তাকে মুক্ত করা যাবে না| সেই ব্যক্তিকে অবশ্যই নিহত হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“সমস্ত শস্যের দশমাংশ প্রভুর অধিকারে থাকে| এর অর্থ হলো, জমি থেকে কেটে আনা শস্য এবং গাছ থেকে আনা ফল ফলাদি, এসবের দশমাংশ প্রভুর অধিকারভুক্ত| ");
INSERT INTO ben2006_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","সুতরাং যদি একজন লোক তার দশমাংশ ফেরত পেতে চায়, তবে সে অবশ্যই এর দামের পাঁচ ভাগের একভাগ যোগ করবে এবং তারপর তা কিনে নেবে| ");
INSERT INTO ben2006_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“যাজকরা প্রত্যেক ব্যক্তির গোরু বা মেষদের মধ্যে থেকে প্রতি দশটির জন্য একটি করে প্রাণী নেবে এবং তা হবে প্রভুর উদ্দেশ্যে পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","পছন্দ করা প্রাণীটি ভাল না খারাপ এই সব পরীক্ষা চলবে না এবং একটির পরিবর্তে অন্য প্রাণী দেওয়া যাবে না| যদি সে অন্য প্রাণী দিয়ে তা বদলাতে মনস্থ করে, তাহলে দুটি প্রাণীই প্রভুর অধিকারে থাকবে| ঐ প্রাণীকে কিনে নিতে পারবে না|” ");
INSERT INTO ben2006_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","এইগুলি ইস্রায়েলের লোকদের জন্য সীনয় পর্বত থেকে মোশিকে দেওয়া প্রভুর আদেশসমুহ| ");
INSERT INTO ben2006_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","প্রভু সমাগম তাঁবুতে মোশির সঙ্গে কথা বলেছিলেন| সেটা সীনয় মরুভূমিতে অবস্থিত ছিল| ইস্রায়েলের লোকরা মিশর ত্যাগ করার পর দ্বিতীয় বছরের দ্বিতীয় মাসের প্রথম দিনটিতে এই সাক্ষাৎ হয়েছিল| প্রভু মোশিকে বললেন: ");
INSERT INTO ben2006_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ইস্রায়েলের সমস্ত লোকসংখ্যা গণনা করো| প্রত্যেক ব্যক্তির নামের সাথে তার পরিবার এবং তার পরিবারগোষ্ঠী তালিকা তৈরী করো| ");
INSERT INTO ben2006_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","তুমি এবং হারোণ ইস্রায়েলের পুরুষদের মধ্যে যাদের বয়স 20 বছর অথবা তার বেশী তাদের সকলকেই গণনা করবে| (এরাই সেইসব মানুষ যারা ইস্রায়েলের সেনাবাহিনীতে কাজ করতে পারে|) তাদের গোষ্ঠী অনুযায়ী তালিকাভুক্ত করো| ");
INSERT INTO ben2006_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","প্রত্যেকটি পরিবারগোষ্ঠী থেকে একজন ব্যক্তি তোমাকে সাহায্য করবে| এই ব্যক্তিটিই হবে তার পরিবারগোষ্ঠীর সর্বময় কর্তা| ");
INSERT INTO ben2006_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","এই নামগুলি হচ্ছে সেইসব লোকের যারা তোমার পাশে থাকবে এবং তোমাকে সাহায্য করবে: রূবেণের পরিবারগোষ্ঠী থেকে শদেয়ূরের পুত্র ইলীষূর; ");
INSERT INTO ben2006_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","শিমিয়োনের পরিবারগোষ্ঠী থেকে সূরীশদ্দয়ের পুত্র শলুমীয়েল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","যিহূদার পরিবারগোষ্ঠী থেকে অম্মীনাদবের পুত্র নহশোন; ");
INSERT INTO ben2006_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইষাখরের পরিবারগোষ্ঠী থেকে সূয়ারের পুত্র নথনেল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","সবূলূনের পরিবারগোষ্ঠী থেকে হেলোনের পুত্র ইলীয়াব; ");
INSERT INTO ben2006_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","যোষেফের উত্তরপুরুষ: ইফ্রয়িমের পরিবারগোষ্ঠী থেকে অম্মীহূদের পুত্র ইলীশামা; মনঃশির পরিবারগোষ্ঠী থেকে পদাহসূরের পুত্র গমলীয়েল; ");
INSERT INTO ben2006_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিন্যামীনের পরিবারগোষ্ঠী থেকে গিদিয়োনির পুত্র অবীদান; ");
INSERT INTO ben2006_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দানের পরিবারগোষ্ঠী থেকে অম্মীশদ্দয়ের পুত্র অহীয়েষর; ");
INSERT INTO ben2006_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আশেরের পরিবারগোষ্ঠী থেকে অক্রণের পুত্র পগীয়েল; ");
INSERT INTO ben2006_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","গাদের পরিবারগোষ্ঠী থেকে দ্যূয়েলের পুত্র ইলীয়াসফ; ");
INSERT INTO ben2006_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নপ্তালীর পরিবারগোষ্ঠী থেকে ঐননের পুত্র অহীরঃ|” ");
INSERT INTO ben2006_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ওপরে উল্লিখিত ব্যক্তিরা তাদের গোষ্ঠীর নেতা| তাদের পরিবারগোষ্ঠীর সর্বময় কর্তা হিসেবে লোকরা তাদেরই মনোনীত করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","যারা সর্বময় কর্তা হিসেবে মনোনীত হয়েছিল, মোশি এবং হারোণ তাদেরই বেছে নিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","এবং মোশি ও হারোণ ইস্রায়েলের সমস্ত লোকদের একসঙ্গে জড়ো করল| তখন লোকদের তাদের পরিবার এবং পরিবারগোষ্ঠী অনুসারে তালিকাভুক্ত করা হল| 20 বছর অথবা তার বেশী বয়সের প্রত্যেক পুরুষের নাম তালিকাভুক্ত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","প্রভু যা আদেশ করেছিলেন মোশি ঠিক তাই করেছিল| লোকরা যখন সীনয় মরুভূমিতে ছিল মোশি তখনই তাদের গণনা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","তারা রূবেণের পরিবারগোষ্ঠীর গণনা করেছিল| (রূবেণ ছিলেন ইস্রায়েলের জ্যেষ্ঠ পুত্র|) 20 বছর বয়স্ক অথবা তার বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম তাদের পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","রূবেণের পরিবারগোষ্ঠীতে মোট পুরুষের সংখ্যা ছিল 46,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","তারা শিমিয়োনের পরিবারগোষ্ঠী গণনা করেছিল: 20 বছর বয়স্ক অথবা তার উর্দ্ধে সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম তাদের পরিবার এবং পরিবারগোষ্ঠী অনুসারে তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","শিমিয়োনের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 59,300 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","তারা গাদের পরিবারগোষ্ঠীর গণনা করেছিল। 20 বছর বয়স্ক অথবা তার উর্দ্ধে সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম তাদের পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","গাদের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 45,650 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","তারা যিহূদা পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম তাদের পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","যিহূদার পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 74,600 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","তারা ইষাখরের পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম তাদের পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ইষাখরের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 54,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","তারা সবূলূনের পরিবারগোষ্ঠী গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","সবূলূনের পরিবারগোষ্ঠী মোট পুরুষের সংখ্যা ছিল 57,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","তারা ইফ্রয়িমের গোষ্ঠীর গণনা করেছিল| (ইফ্রয়িম ছিলেন যোষেফের পুত্র|) 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ইফ্রয়িমের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 40,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","তারা মনঃশি পরিবারগোষ্ঠীর গণনা করেছিল| (মনঃশি ছিলেন যোষেফের অপর এক পুত্র|) 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","মনঃশি পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 32,200 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","তারা বিন্যামীন পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","বিন্যামীনের পরিবারগোষ্ঠীর মোট সংখ্যা ছিল 35,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","তারা দানের পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","দানের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 62,700 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","তারা আশের পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","আশের পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 41,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","তারা নপ্তালির পরিবারগোষ্ঠীর গণনা করেছিল| 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের সমস্ত পুরুষ যারা সেনাবাহিনীতে কাজ করতে সক্ষম, তাদের প্রত্যেকের নাম নিজ নিজ পরিবার ও পরিবারগোষ্ঠী অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","নপ্তালির পরিবারগোষ্ঠীর মোট পুরুষের সংখ্যা ছিল 53,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","মোশি, হারোণ এবং ইস্রায়েলের বারোজন সর্বময় কর্তা এই লোকসংখ্যা গণনা করেছিল| (প্রত্যেকটি পরিবারগোষ্ঠীর থেকে একজন করে সর্বময় কর্তা ছিলেন|) ");
INSERT INTO ben2006_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","তারা 20 বছর বয়স্ক অথবা তার চেয়ে বেশী বয়সের প্রত্যেক পুরুষের গণনা করেছিল, যারা সেনাবাহিনীতে কাজ করতে সক্ষম| প্রত্যেক ব্যক্তিকে তার পরিবার অনুসারেই তালিকাভুক্ত করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","তালিকায় সর্বসাকুল্যে মোট পুরুষের সংখ্যা ছিল 603,550 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ইস্রায়েলের অন্যান্য লোকদের সঙ্গে লেবীয় পরিবারগোষ্ঠীভুক্ত পরিবারদের গণনা করা হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","প্রভু মোশিকে বললেন: ");
INSERT INTO ben2006_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“লেবির পরিবারগোষ্ঠীর লোকদের গণনা করবে না অথবা ইস্রায়েলের অন্যান্য লোকদের তালিকার অন্তর্ভুক্ত করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","লেবীয়দের চুক্তির পবিত্র তাঁবুর এবং তার সমস্ত জিনিসের দায়িত্ব রাখ| তারা অবশ্যই পবিত্র তাঁবুর সাথে তার সব জিনিসপত্র বহন করবে ও তার যত্ন নেবে এবং পবিত্র তাঁবুর চারপাশেই শিবির স্থাপন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","যখনই পবিত্র তাঁবু স্থানান্তরিত হবে, লেবীয়রাই এটাকে স্থানান্তরিত করবে| যখনই বিরতির সময় পবিত্র তাঁবুর প্রতিষ্ঠা করা হবে তখন অবশ্যই লেবীয়রা এটিকে প্রতিষ্ঠা করবে| একমাত্র তারাই পবিত্র তাঁবুর রক্ষণাবেক্ষণ করবে| লেবীয় পরিবারগোষ্ঠী বহির্ভুত কোনো ব্যক্তি যদি তাঁবুর যত্নের ব্যাপারে সচেষ্ট হয়, তাহলে তার মৃত্যু অনিবার্য| ");
INSERT INTO ben2006_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ইস্রায়েলের লোকরা তাদের আলাদা গোষ্ঠীতে শিবির স্থাপন করবে| প্রত্যেক ব্যক্তি তার পারিবারিক পতাকার কাছাকাছি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","লেবীয়রা চুক্তির পবিত্র তাঁবুর চারপাশে তাদের শিবির স্থাপন করবে| তাহলে ইস্রায়েলের জনগোষ্ঠীর প্রতি ঈশ্বর তাঁর ক্রোধ প্রকাশ করবেন না| তারা পবিত্র তাঁবুর দায়িত্বে থাকবে এবং তা পাহারা দেবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","সুতরাং প্রভু মোশিকে যা আদেশ করেছিলেন, ইস্রায়েলের লোকরা সেই অনুসারে সব কিছু করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","প্রভু মোশি এবং হারোণকে বললেন: ");
INSERT INTO ben2006_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ইস্রায়েলীয়র সমাগম তাঁবুর চারপাশে কিছুটা দূরত্ব রেখে তাদের শিবির তৈরী করবে| প্রত্যেক ব্যক্তি তার গোষ্ঠীর নিজস্ব পতাকার কাছে শিবির স্থাপন করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“পূর্বদিকে, যে দিকে সূর্যোদয় হয়, সেদিকে থাকবে যিহূদার শিবিরের পতাকা| যিহূদার লোকরা এই পতাকার কাছেই শিবির স্থাপন করবে| অম্মীনাদবের পুত্র নহশোন হলেন যিহূদার লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","তার দলে পুরুষের সংখ্যা 74,600 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“যিহূদা পরিবারগোষ্ঠীর ঠিক পরেই ইষাখরের পরিবারগোষ্ঠী শিবির স্থাপন করবে| সূয়ারের পুত্র নথনেল ইষাখরের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","তার দলে পুরুষের সংখ্যা ছিল 54,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“যিহূদার পরিবারগোষ্ঠীর ঠিক পরেই সবূলূনের পরিবারগোষ্ঠীও শিবির স্থাপন করবে| হেলোনের পুত্র ইলীয়াব সবূলূনের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","তার দলে পুরুষের সংখ্যা 57,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“যিহূদার শিবিরের মোট লোকসংখ্যা 186,400 জন| এদের বিভিন্ন পরিবারগোষ্ঠীতে বিভক্ত করা হয়েছে| স্থানান্তরে ভ্রমণ করার সময় যিহূদার গোষ্ঠী প্রথমে অগ্রসর হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“পবিত্র তাঁবুর দক্ষিণ দিকে রূবেণের শিবিরের পতাকা থাকবে| প্রত্যেক গোষ্ঠী তার পতাকার কাছে শিবির স্থাপন করবে| শদেয়ূরের পুত্র ইলীষুর হলেন রূবেণের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","এই দলে পুরুষের সংখ্যা ছিল 46,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“রূবেণের পরিবারগোষ্ঠীর ঠিক পরেই শিমিয়োনের পরিবারগোষ্ঠী শিবির স্থাপন করবে| সূরীশদ্দেয়ের পুত্র শলূমীয়েল হলেন শিমিয়োনের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","এই দলে পুরুষের সংখ্যা ছিল 59,300 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“রূবেণের লোকদের শিবিরের ঠিক পরেই গাদের পরিবারগোষ্ঠী শিবির স্থাপন করবে| দ্যূয়েলের পুত্র ইলীয়াসফ হলেন গাদের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","এই দলে পুরুষের সংখ্যা ছিল 45,650 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“রূবেণের শিবিরের এই গোষ্ঠীগুলির মোট পুরুষের সংখ্যা 151,450 জন| স্থানান্তরে ভ্রমণকালে রূবেণের শিবিরের লোকরা দ্বিতীয় স্থানে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ভ্রমণকালে লেবীয় লোকরা রূবেণের লোকদের ঠিক পরেই থাকবে| অন্যান্য শিবিরের মাঝখানে সমাগম তাঁবু তাদের সঙ্গেই থাকবে| এমনকি ভ্রমণের সময়ও লোকরা তাদের শিবিরগুলি একই ক্রমানুসারে স্থাপন করবে| প্রত্যেক ব্যক্তি তার পারিবারিক পতাকার কাছে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“ইফ্রয়িম শিবিরের পতাকা পশ্চিম দিকে থাকবে| ইফ্রয়িমের পরিবারগোষ্ঠী এই পতাকার কাছেই শিবির স্থাপন করবে| অম্মীহূদের পুত্র ইলীশামা হল ইফ্রয়িমের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","এই দলে পুরুষের সংখ্যা 40,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“ইফ্রয়িমের পরিবারের ঠিক পরেই মনঃশি পরিবারগোষ্ঠী শিবির স্থাপন করবে| পদাহসূরের পুত্র গমলীয়েল হলেন মনঃশি লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","এই দলে পুরুষের সংখ্যা ছিল 32,200 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“ইফ্রয়িমের পরিবারের ঠিক পরেই বিন্যামীনের পরিবারগোষ্ঠীও শিবির স্থাপন করবে| গিদিয়োনির পুত্র অবীদান হল বিন্যামীনের লোকদের দলপতি| ");
INSERT INTO ben2006_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","এই দলে পুরুষের সংখ্যা ছিল 35,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“ইফ্রয়িমের শিবিরে সেনাদল হিসাবে যাদের গণনা করা হয়েছিল তাদের মোট পুরুষের সংখ্যা 108,100 জন| স্থানান্তরে ভ্রমণকালে এদের পরিবার তৃতীয় স্থানে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“দানের শিবিরের পতাকা তাঁবুর উত্তর দিকে থাকবে| দানের পরিবারগোষ্ঠী এই শিবিরেই থাকবে| অম্মীশদ্দয়ের পুত্র অহীয়েষর হল দানের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","এই গোষ্ঠীর পুরুষের সংখ্যা ছিল 62,700 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“আশের পরিবারগোষ্ঠীর লোকরা দানের পরিবারগোষ্ঠীর ঠিক পরেই শিবির স্থাপন করবে| অক্রণের পুত্র পগীয়েল হলেন আশেরের লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","এই দলে পুরুষের সংখ্যা ছিল 41,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“নপ্তালির পরিবারগোষ্ঠী দানের গোষ্ঠীর ঠিক পরেই শিবির স্থাপন করবে| ঐননের পুত্র অহীরঃ হল নপ্তালির লোকদের নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","এই দলে পুরুষের সংখ্যা ছিল 53,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“দানের শিবিরের মোট পুরুষের সংখ্যা 157,600 জন| স্থানান্তরে ভ্রমণকালে এরা সকলের শেষে থাকবে| প্রত্যেক ব্যক্তি তার পারিবারিক পতাকার সঙ্গে থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","সুতরাং এরাই হল ইস্রায়েলের জনগণ| পরিবার অনুসারে তাদের গণনা করা হতো| শিবিরে গোষ্ঠী অনুসারে গণনাকৃত ইস্রায়েলের মোট পুরুষের সংখ্যা 603,550 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","মোশি প্রভুর কথা মান্য করল এবং ইস্রায়েলের অন্যান্য লোকদের সঙ্গে লেবীয় লোকদের গণনা করল না| ");
INSERT INTO ben2006_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","প্রভু মোশিকে যা যা বলেছিলেন, ইস্রায়েলের লোকরা তার প্রত্যেকটিই পালন করেছিল| প্রত্যেক গোষ্ঠী তার নিজস্ব পতাকার কাছেই শিবির স্থাপন করত এবং প্রত্যেক ব্যক্তি তার পরিবার ও পরিবারগোষ্ঠীর সঙ্গেই যাত্রা করত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","এ হল হারোণ এবং মোশির পারিবারিক ইতিহাস, যে সময় সীনয় পর্বতের ওপর প্রভু মোশির সঙ্গে কথা বলেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হারোণের চার পুত্র ছিল| নাদব ছিল জ্যেষ্ঠ পুত্র| বাকী তিনজন হল অবীহূ, ইলীয়াসর এবং ঈথামর| ");
INSERT INTO ben2006_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","এই চারজন পুত্রই যাজক হিসেবে মনোনীত হয়েছিল| যাজক হিসেবে প্রভুকে সেবা করার বিশেষ দায়িত্ব এদের দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","কিন্তু প্রভুকে সেবা করার সময় পাপ করার দরুণ নাদব এবং অবীহূর মৃত্যু হয়েছিল| উৎসর্গের সময় প্রভু যে আগুন ব্যবহার করার অনুমতি দেন নি তারা সেই আগুন ব্যবহার করেছিল| এই কারণেই সীনয় মরুভূমিতে নাদব এবং অবীহূযের মৃত্যু হয়েছিল| তাদের কোনো পুত্র ছিল না, এই কারণে ইলীয়াসর এবং ঈথামর তাদের স্থান নিয়েছিল এবং যাজক হিসেবে প্রভুর সেবা করেছিল| তাদের পিতা হারোণের জীবদ্দশাতেই এই সকল ঘটনা ঘটেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“লেবীর পরিবারগোষ্ঠীকে নিয়ে এসো| তাদের সবাইকে যাজক হারোণের কাছে নিয়ে এসো| তারাই হারোণকে সাহায্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","সমাগম তাঁবুতে যখন হারোণ ঈশ্বরের সেবা করবে সেই সময় এই লেবীয়রা তাকে সাহায্য করবে| পবিত্র তাঁবুতে উপাসনা করতে আসা ইস্রায়েলীয়দের এই লেবীয়রা সাহায্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ইস্রায়েলীয়রা সমাগম তাঁবুর প্রত্যেকটি জিনিস রক্ষা করবে, এটাই তাদের কর্তব্য| এই সকল দ্রব্যসামগ্রীর রক্ষার মধ্যে দিয়েই লেবীয়রা ইস্রায়েলীয়দের সাহায্য করবে| পবিত্র তাঁবুতে এটাই হবে তাদের উপাসনার পদ্ধতি| ");
INSERT INTO ben2006_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“হারোণ এবং তার পুত্রদের কাছে লেবীয়দের দাও| ইস্রায়েলের লোকদের মধ্য থেকে একমাত্র লেবীয়দেরই হারোণ এবং তার পুত্রদের সাহায্য করার জন্য মনোনীত করা হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“যাজক হিসেবে হারোণ এবং তার পুত্রদের নিয়োগ করো| তারা অবশ্যই তাদের কর্তব্য পালন করবে এবং যাজক হিসেবে কাজ করবে| অন্য যে কোনো ব্যক্তি যদি পবিত্র দ্রব্যসামগ্রীর কাছাকাছি আসতে চেষ্টা করে তবে তাকে অবশ্যই হত্যা করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","প্রভু মোশিকে আরও বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“আমি তোমাকে বলেছিলাম যে ইস্রায়েলের প্রত্যেক পরিবার তাদের জ্যেষ্ঠপুত্রকে অবশ্যই আমার কাছে দেবে কিন্তু এখন আমি লেবীয়দেরই আমার সেবা করার জন্য মনোনীত করছি, তারা আমারই হবে| সুতরাং ইস্রায়েলের অন্যান্য লোকদের আর তাদের জ্যেষ্ঠপুত্রদের আমার কাছে উৎসর্গ করতে হবে না| মিশরের সমস্ত প্রথম জাতদের হত্যা করার সময় আমি ইস্রায়েলের সকল প্রথম জাতদের নিজের করে নিয়েছিলাম| জ্যেষ্ঠ সন্তানরা এবং প্রথম জাত পশুরা সকলেই আমার| কিন্তু এখন আমি তোমার জ্যেষ্ঠ সন্তানদের তোমার কাছে ফেরত দিচ্ছি এবং লেবীয়দের আমার জন্য তৈরী করছি| আমিই প্রভু|” ");
INSERT INTO ben2006_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","প্রভু আবার সীনয়ের মরুভূমিতে মোশির সঙ্গে কথা বললেন| প্রভু বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“লেবী গোষ্ঠীর প্রত্যেক পরিবার এবং পরিবারগোষ্ঠীর গণনা করো| এক মাস অথবা তার বেশী বয়স্ক প্রত্যেক পুরুষকে গণনা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","সুতরাং মোশি প্রভুর কথা পালন করল| সে তাদের সকলকে গণনা করল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","লেবীয়দের তিন পুত্র ছিল, তাদের নাম হল গের্শোন, কহাত্‌ এবং মরারি| ");
INSERT INTO ben2006_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","প্রত্যেক পুত্র বিভিন্ন পরিবারগোষ্ঠীর নেতা ছিল| গের্শোনের পরিবারগোষ্ঠীতে ছিল: লিব্নি এবং শিমিয়ি| ");
INSERT INTO ben2006_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","কহাতের পরিবারগোষ্ঠীতে ছিল অম্রাম, ষিষ্হর, হিব্রোণ এবং উষীয়েল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","মরারির পরিবারগোষ্ঠীতে ছিল মহলি এবং মূশি| সব পরিবার লেবীয় পরিবারগোষ্ঠীর অন্তর্ভূক্ত ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","গের্শোনের পরিবারের অন্তর্ভূক্ত ছিল লিব্নি এবং শিমিয়ির পরিবার| তারা গের্শোনের পরিবারগোষ্ঠীতে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","এই দুটি পরিবারগোষ্ঠীতে 7500 জন পুরুষ এবং ছেলে ছিল যাদের বয়স এক মাসের বেশী| ");
INSERT INTO ben2006_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","গের্শোনের পরিবারগোষ্ঠী সমাগম তাঁবুর পিছনে পশ্চিম দিকে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","গের্শোনীয়দের পরিবারগোষ্ঠীর নেতা ছিল লায়েলের পুত্র ইলীয়াসফ| ");
INSERT INTO ben2006_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","সমাগম তাঁবুতে গের্শোনের লোকদের কাজ ছিল পবিত্র তাঁবু, বাইরের তাঁবু এবং আচ্ছাদনের দেখাশোনা করা| সমাগম তাঁবুর প্রবেশ পথের পর্দারও তারা যত্ন নিত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","তারা প্রাঙ্গনের পর্দার যত্ন নিত এবং প্রাঙ্গণের প্রবেশ পথের পর্দারও যত্ন নিত| পবিত্র তাঁবু এবং উপাসনা বেদীর চারপাশ ঘিরে এই প্রাঙ্গণটি ছিল এবং তারা পর্দার জন্য ব্যবহার করা হত এমন দড়ি এবং অন্যান্য জিনিসপত্রেরও যত্ন নিত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","কহাতের পরিবারের অন্তর্ভুক্ত ছিল অম্রাম, যিষহর, হিব্রোণ এবং উষীয়েলের পরিবার| তারা কহাতের পরিবারগোষ্ঠীতে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","এক মাস অথবা তার থেকে বেশী বয়স্ক 8300 জন পুরুষ এবং ছেলে এই পরিবারগোষ্ঠীতে ছিল| পবিত্র স্থানের দ্রব্যসামগ্রী দেখাশোনার দায়িত্ব কহাতের লোকদের ওপর ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","কহাতের পরিবারগোষ্ঠীগুলিকে পবিত্র তাঁবুর দক্ষিণ দিকে স্থান দেওয়া হয়েছিল| এই স্থানেই তারা শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","উষীয়েলের পুত্র ইলীষাফণ কহাতের পরিবারগোষ্ঠীর নেতা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","পবিত্র স্থানের পবিত্র সিন্দুক, টেবিল, বাতিস্তম্ভ, বেদীগুলি এবং পাত্র সকলের রক্ষণাবেক্ষণের দায়িত্বও তাদের ওপর ছিল| পর্দা এবং পর্দার সঙ্গে ব্যবহারের উপযোগী অন্যান্য আনুষঙ্গিক জিনিসপত্রেরও যত্ন তারা নিত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","লেবীয়দের যারা নেতা ছিল, তাদের ওপর নেতৃত্ব করত যাজক হারোণের পুত্র ইলীয়াসর| পবিত্র দ্রব্যসামগ্রীর যত্নের দায়িত্ব যাদের ওপর ন্যস্ত ছিল, তাদের দেখাশোনার ভার ছিল ইলীয়াসরের ওপর| ");
INSERT INTO ben2006_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","মহলীয় এবং মুশীয় পরিবারগোষ্ঠী মরারি পরিবারের অংশ ছিল| মহলী এবং মুশী পরিবারগোষ্ঠীতে এক মাস অথবা তার বেশী বয়সের 6200 জন পুরুষ এবং ছেলে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","অবীহয়িলের পুত্র সূরীয়েল ছিল মরারি পরিবারগোষ্ঠীর নেতা| এই পরিবারগোষ্ঠী পবিত্র তাঁবুর উত্তর দিকে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","পবিত্র তাঁবুর কাঠামোর যত্ন ও রক্ষণাবেক্ষণের কাজ মরারি পরিবারের লোকদের দেওয়া হয়েছিল| পবিত্র তাঁবুর কাঠামোর বন্ধনী, স্তম্ভ, ভিত্তি এবং কাঠামোর সঙ্গে ব্যবহৃত অন্যান্য প্রয়োজনীয় জিনিসপত্রের যত্নও তারা নিত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","পবিত্র তাঁবুর চারপাশ ঘিরে যে প্রাঙ্গণ তার সমস্ত স্তম্ভ তাঁবুর খুঁটিগুলি এবং দড়ির যত্নও তারা নিত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","সমাগম তাঁবুর সামনে অর্থাৎ‌ পূর্বদিকে মোশি, হারোণ এবং তার পুত্ররা পবিত্র তাঁবু স্থাপন করেছিল| তারা ইস্রায়েলের লোকদের জন্য পবিত্র অঞ্চলটি রক্ষণাবেক্ষণ করত| অন্য যে কোনো ব্যক্তি পবিত্র স্থানের কাছে এলে তাকে হত্যা করা হত| ");
INSERT INTO ben2006_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","লেবীয় পরিবারগোষ্ঠীর সমস্ত পুরুষ এবং এক মাস অথবা তার বেশী বয়সের সব ছেলের সংখ্যা গণনা করার জন্য মোশি এবং হারোণকে ঈশ্বর আদেশ দিয়েছিলেন| তাদের মোট লোকসংখ্যা ছিল 22,000 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","প্রভু মোশিকে বললেন, “ইস্রায়েলের সকল প্রথমজাত পুরুষ এবং ছেলের সংখ্যা গণনা করে যাদের বয়স কমপক্ষে এক মাস, তাদের নাম তালিকাভুক্ত করো| ");
INSERT INTO ben2006_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","আমি প্রভু, আমার জন্য ইস্রায়েলের সকল প্রথমজাত ব্যক্তির পরিবর্তে লেবীয়দের গ্রহণ কর এবং ইস্রায়েল সন্তানদের প্রথমজাত পশুদের পরিবর্তে লেবীয়দের পশুদের গ্রহণ করো|” ");
INSERT INTO ben2006_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","সুতরাং মোশি প্রভুর আদেশানুযায়ী ইস্রায়েলের জ্যেষ্ঠ সন্তানদের সংখ্যা গণনা করল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","সে এক মাস অথবা তার বেশী বয়সের সকল প্রথমজাত পুরুষ এবং ছেলের নাম তালিকাভুক্ত করল| সেই তালিকায় 22,273 জনের নাম ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","প্রভু মোশিকে আরও বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ইস্রায়েলের অন্যান্য প্রথমজাত ব্যক্তিদের পরিবর্তে লেবীয়দের নাও এবং অন্যান্য লোকদের পশুদের পরিবর্তে লেবীয়দের পশুদেরই নাও| লেবীয়রা আমার, আমি প্রভু এই কথা বলেছি| ");
INSERT INTO ben2006_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","সেখানে 22,000 জন লেবীয় আছে কিন্তু অন্যান্য পরিবারের জ্যেষ্ঠ সন্তানদের সংখ্যা 22,273 জন অর্থাৎ‌ লেবীয়দের থেকে ইস্রায়েলের আর অন্য পরিবারগুলিতে মোট 273 জন জ্যেষ্ঠ সন্তান বেশী আছে| ");
INSERT INTO ben2006_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","সুতরাং তাদের মুক্ত করতে ইস্রায়েলের লোকদের কাছ থেকে পবিত্র মন্দিরের অনুমোদিত ওজনের পরিমাপ অনুসারে 273 জনের প্রত্যেকের জন্য পাঁচ শেকেল রূপো সংগ্রহ করো| (পবিত্র স্থানের ওজনানুসারে এক শেকেল হলো 20 জিরোহ|) ");
INSERT INTO ben2006_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","সেই রূপো হারোণ এবং তার পুত্রদের দিয়ে দাও| ইস্রায়েলের 273 জন লোকের জন্য এই মূল্য দিতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","অন্যান্য পরিবারগোষ্ঠীর 273 জন পুরুষের বদলে জায়গা নেওয়ার মতো লেবীয়দের সংখ্যা যথেষ্ট ছিল না| সুতরাং মোশি সেই 273 জনের জন্য অর্থ সংগ্রহ করল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ইস্রায়েলের প্রথমজাত ব্যক্তিদের কাছ থেকে মোশি রূপো সংগ্রহ করল| সে পবিত্র স্থানের অনুমোদিত ওজন অনুসারে 1365 শেকেল রূপো সংগ্রহ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","মোশি প্রভুর আদেশ মতো হারোণ ও তার পুত্রদের সেই রূপো দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","প্রভু মোশি এবং হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“কহাত্‌ গোষ্ঠীর পরিবারগুলির লোকসংখ্যা গণনা করো| (কহাত্‌ পরিবারগোষ্ঠী লেবী পরিবারগোষ্ঠীরই একটি অংশ|) ");
INSERT INTO ben2006_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক যে সব পুরুষ সেনাবাহিনীতে কাজ করেছিল তাদের সকলের সংখ্যা গণনা করো| এরা সমাগম তাঁবুতে কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","সমাগম তাঁবুর ভেতরের পবিত্রতম জিনিসপত্রের যত্ন ও রক্ষনাবেক্ষণই হবে তাদের কাজ| ");
INSERT INTO ben2006_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“যখন ইস্রায়েলের লোকরা কোনো নতুন জায়গায় ভ্রমণে যাবে, তখন হারোণ এবং তার পুত্ররা অবশ্যই সমাগম তাঁবুতে যাবে এবং পর্দা নামিয়ে সেই পর্দা দিয়ে ঈশ্বর এবং ইস্রায়েলের লোকদের চুক্তির পবিত্র সিন্দুকটিকে ঢাকা দিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","এর পর তারা এই সমস্ত জিনিসগুলিকে একটি মসৃণ চামড়ার তৈরী আচ্ছাদন দিয়ে ঢেকে দেবে| এর পর তারা অবশ্যই এই চামড়ার ওপর দিয়ে একটি শক্ত নীল কাপড় সমানভাবে বিছিয়ে দেবে এবং পবিত্র সিন্দুকের আংটার মধ্যে খুঁটিগুলো পরাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“এর পর তারা অবশ্যই পবিত্র টেবিলের উপর একটি নীল কাপড় বিছিয়ে দেবে| তারপর তারা থালা, চামচ, বাটি এবং পেয় নৈবেদ্যগুলির পাত্র টেবিলের ওপর রাখবে| টেবিলের ওপরে বিশেষ ধরণের রুটিও রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","এই সমস্ত জিনিপত্রের উপরে তোমরা অবশ্যই একটি লাল কাপড় বিছিয়ে দেবে| এর পর এই সমস্ত জিনিসগুলিকে মসৃণ চামড়া দিয়ে ঢেকে রাখো| এর পর টেবিলের আংটার মধ্যে খুঁটিগুলো পরাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“এর পর তারা অবশ্যই বাতিস্তম্ভ এবং তার বাতিগুলিকে একটি নীল কাপড় দিয়ে ঢেকে দেবে| বাতিগুলোকে প্রজ্জ্বলিত অবস্থায় রাখার জন্য যা যা জিনিসপত্রের প্রয়োজন হয়, সেই সমস্ত কিছুকে এবং বাতির জন্যে প্রয়োজনীয় তেলের পাত্রগুলোকেও তারা অবশ্যই ঢেকে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","তারপর সমস্ত জিনিসগুলোকে মসৃণ চামড়ার মধ্যে মুড়বে| এর পর তারা অবশ্যই এই সমস্ত দ্রব্যসামগ্রীকে খুঁটিতে পরাবে, যে খুঁটিগুলো বহন করার জন্য ব্যবহৃত হত| ");
INSERT INTO ben2006_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“তারা অবশ্যই সোনালী বেদীর ওপর একটি নীল কাপড় বিছিয়ে দেবে এবং সেটাকে একটি মসৃণ চামড়া দিয়ে আবৃত করবে| তারপর তারা বহনের জন্য বেদীর ওপরে আংটার মধ্যে খুঁটিগুলো পরাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“এর পর তারা পবিত্র স্থানে উপাসনার জন্য যে সব বিশেষ ধরণের জিনিসপত্র ব্যবহৃত হয়, সেগুলিকে এক জায়গায় জড়ো করবে| একত্রিত জিনিসপত্রগুলিকে তারা অবশ্যই একটি নীল কাপড়ে মুড়বে| তারপর তারা ঐসব জিনিসগুলিকে মসৃণ চামড়া দিয়ে ঢাকবে| তারপর এগুলোকে বহনের জন্যে একটি কাঠামোর ওপর রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“তারা অবশ্যই পিতলের বেদীর ওপর থেকে ছাই পরিষ্কার করবে এবং বেদীর ওপর একটি বেগুনী কাপড় পাতবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","এরপর তারা উপাসনার জন্য যে সব জিনিসপত্র ব্যবহৃত হত সেইগুলোকে বেদীর উপরে এক জায়গায় একত্রিত করবে| এগুলো হল আগুন রাখার পাত্র, কাঁটা চামচ, বেলচা এবং বাটি| তারা অবশ্যই এই সকল দ্রব্যসামগ্রী পিতলের বেদীর ওপর রাখবে| এরপর বেদীটি একটি মসৃণ চামড়ার আচ্ছাদন দিয়ে ঢাকবে| বেদীর উপরের আংটার মধ্যে দিয়ে তারা বহনের জন্য খুঁটিগুলোকে পরাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“হারোণ এবং তার পুত্ররা পবিত্র স্থানের জিনিসপত্র ঢেকে দেওয়ার কাজ সম্পূর্ণ করবে| এরপর কহাত্‌ পরিবারের লোকরা ভিতরে যেতে পারবে এবং ঐ সব জিনিসপুত্র বহনের কাজ শুরু করবে| এইভাবে তারা পবিত্র স্থান স্পর্শ করবে না এবং তাদের মৃত্যু হবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“যাজক হারোণের পুত্র ইলীয়াসর, পবিত্র তাঁবুর দায়িত্বে থাকবে| সেই পবিত্র স্থান এবং সেখানকার সকল জিনিসপত্রের দায়িত্ব তার| বাতি জ্বালাবার জন্য প্রয়োজনীয় তেল, ধূপধূনো, দৈনন্দিন উৎসর্গীকৃত জিনিসপত্র এবং অভিষেকের তেলের দায়িত্বেও সে থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","এরপর প্রভু মোশি এবং হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“সাবধান! এই কহাতের পরিবারের লোকদের উচ্ছেদ করো না| ");
INSERT INTO ben2006_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","তোমরা নিশ্চয়ই এই কাজগুলো করবে যাতে কহাতের পরিবারের লোকরা পবিত্রতম স্থানের কাছে যেতে পারে এবং যাতে তাদের মৃত্যু না হয়| হারোণ ও তার পুত্ররা ভেতরে প্রবেশ করে কহাত্‌ পরিবারের প্রত্যেকটি লোককে তাদের কি করতে হবে এবং কি বইতে হবে তা দেখিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","যদি তুমি এই কাজ না করো, তাহলে কহাতের লোকরা হয়তো ভেতরে প্রবেশ করে পবিত্র দ্রব্যাদি দেখতে পারে| যদি তারা ক্ষণিকের জন্যও ঐসব জিনিপত্র দেখে, তাহলে তাদের অবশ্যই মরতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“গের্শোন পরিবারের সকল লোকর সংখ্যা গণনা করো| পরিবার এবং পরিবারগোষ্ঠী অনুসারে তাদের তালিকাভুক্ত করো| ");
INSERT INTO ben2006_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","সেনাবাহিনীতে কাজ করেছিল এমন 30 থেকে 50 বছর বয়স্ক পুরুষের সংখ্যা গণনা করো| সমাগম তাঁবুর রক্ষণাবেক্ষণই হবে তাদের কাজ| ");
INSERT INTO ben2006_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“এগুলো গের্শোন পরিবারের কাজ| তারা এই সকল দ্রব্যাদি বহন করবে: ");
INSERT INTO ben2006_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","তারা সমাগম তাঁবুর পর্দাগুলো, পবিত্র তাঁবু তার আচ্ছাদন এবং মসৃণ চামড়ার আচ্ছাদনগুলোকে বহন করবে| তারা পবিত্র তাঁবুর প্রবেশ পথের পর্দাও বহন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","পবিত্র তাঁবু এবং বেদীর চতুর্দিকে যে প্রাঙ্গণ তার পর্দাগুলোকেও তারা বহন করবে| তারা প্রাঙ্গণের প্রবেশ পথের পর্দা এবং পর্দার সঙ্গে ব্যবহারের উপযোগী সমস্ত দড়ি এবং অন্যান্য জিনিসপত্রও বহন করবে| এই সকল জিনিসপত্রের সঙ্গে অন্যান্য যা যা কাজকর্মের প্রয়োজন হবে তার দায়িত্বেও থাকবে গের্শোন পরিবারের লোকরা| ");
INSERT INTO ben2006_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","যে সকল কাজ করা হবে হারোণ এবং তার পুত্ররা তার প্রতি লক্ষ্য রাখবে| গের্শোনের লোকরা যে সব জিনিসপত্র বহন করবে এবং যে সব কাজ করবে, তার প্রত্যেকের প্রতি হারোণ এবং তার পুত্ররা লক্ষ্য রাখবে| যে সব জিনিসপত্র তারা বহন করবে তার দায়িত্বও তুমি তাদের দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","যাজক হারোণের পুত্র ঈথামরের নির্দেশ অনুসারে সমাগম তাঁবুর জন্য গের্শোন পরিবারগোষ্ঠীর লোকরা এই কাজগুলোই করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“মরারি পরিবারগোষ্ঠীর সকল পরিবার এবং পরিবারগোষ্ঠীর সকল পুরুষদের গণনা করো| ");
INSERT INTO ben2006_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","সেনাবাহিনীতে কাজ করেছিল এমন 30 থেকে 50 বছরের বয়স্ক সব পুরুষের সংখ্যা গণনা করো| সমাগম তাঁবুর জন্য তারা এই বিশেষ ধরণের কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","যখন তুমি ভ্রমণ করবে তখন তাদের কাজ হল সমাগম তাঁবুর কাঠামো বহন করা| তারা অবশ্যই পবিত্র তাঁবুর বন্ধনী, স্তম্ভ এবং ভিত্তিগুলোকে বহন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","প্রাঙ্গণের চারপাশের স্তম্ভগুলি, ভিত্তিগুলি, তাঁবুর খুঁটিগুলি, সমস্ত দড়ি এবং প্রাঙ্গণের চারপাশের খুঁটির জন্যে যা কিছু ব্যবহৃত হয় সব কিছু তারা অবশ্যই বহন করবে| নামের তালিকা তৈরী করে প্রত্যেক ব্যক্তিকে নিশ্চিত করে বলে দাও তাকে কোন কোন জিনিস বহন করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","সমাগম তাঁবুর কাজে সেবা করার জন্যেই মরারি পরিবারের লোকদের এই সব কাজ করতে হবে| যাজক হারোণের পুত্র ঈথামরের নির্দেশ অনুসারে এই কাজগুলি তারা করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","মোশি, হারোণ এবং ইস্রায়েলের দলনেতারা কহাতের লোকদের তাদের পরিবার এবং পরিবারগোষ্ঠী অনুসারেই গণনা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক যেসব পুরুষ সমাগম তাঁবুতে বিশেষ কাজের দায়িত্বে ছিল তাদের সংখ্যা গণনা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","কহাত্‌ পরিবারের 2750 জন পুরুষ এই কাজের জন্য উপযুক্ত বলে বিবেচিত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","সুতরাং সমাগম তাঁবুর জন্য বিশেষ ধরণের কাজের দায়িত্ব কহাত্‌ পরিবারগোষ্ঠীকে দেওয়া হয়েছিল| প্রভু মোশিকে যে ভাবে কাজ করতে বলেছিলেন, মোশি এবং হারোণ ঠিক সেই ভাবেই সেসব কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","গের্শোনের গোষ্ঠীকেও গণনা করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","সেনাবাহিনীতে কাজ করেছিল এমন 30 থেকে 50 বছর বয়স্ক সব পুরুষকেই তারা গণনা করেছিল| তাদের সমাগম তাঁবুর জন্য বিশেষ কাজের দায়িত্ব দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","গের্শোন পরিবারগোষ্ঠীর 2630 জন পুরুষ এই কাজের জন্য উপযুক্ত বলে বিবেচিত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","সমাগম তাঁবুর জন্য বিশেষ কাজের দায়িত্ব গের্শোন পরিবারগোষ্ঠীর এইসব ব্যক্তির ওপরেই দেওয়া হয়েছিল| প্রভু মোশিকে যেভাবে কাজ করতে বলেছিলেন, মোশি এবং হারোণ ঠিক সেভাবেই সেসব কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","মরারি পরিবারগোষ্ঠীর সব পরিবার এবং গোষ্ঠীর পুরুষদের গণনা করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","সেনাবাহিনীতে কাজ করেছিল এমন 30 থেকে 50 বছর বয়স্ক সকল পুরুষের সংখ্যাই গণনা করা হয়েছিল| তাদের সমাগম তাঁবুর জন্য বিশেষ কাজের দায়িত্ব দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","মরারি পরিবারগোষ্ঠীর 3200 জন পুরুষ এইসব কাজের জন্য উপযুক্ত বলে বিবেচিত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","সুতরাং মরারি পরিবারগোষ্ঠীর এইসব ব্যক্তির ওপরেই বিশেষ কাজের দায়িত্ব দেওয়া হয়েছিল| প্রভু মোশিকে যে ভাবে কাজ করতে বলেছিলেন, মোশি এবং হারোণ ঠিক সেভাবেই কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","মোশি, হারোণ এবং ইস্রায়েলের অন্যান্য দলনেতারা লেবীয় পরিবারগোষ্ঠীর জনসংখ্যা গণনা করেছিল| তারা প্রত্যেক পরিবার এবং পরিবারগোষ্ঠীর লোকসংখ্যা গণনা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","সেনাবাহিনীতে কাজ করেছিল এমন 30 থেকে 50 বছর বয়স্ক সব পুরুষের সংখ্যাই গণনা করা হয়েছিল| তাদের সমাগম তাঁবুর জন্য বিশেষ কাজের দায়িত্ব দেওয়া হয়েছিল| স্থানান্তরে ভ্রমণের সময় এরা সমাগম তাঁবু বহনের কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","মোট লোকসংখ্যা ছিল 8580 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","সুতরাং প্রভু মোশিকে যেভাবে আদেশ করেছিলেন সেই ভাবে প্রত্যেক লোককে গণনা করা হয়েছিল| প্রত্যেক ব্যক্তিকে তার নিজের কাজ দেওয়া হয়েছিল এবং বলা হয়েছিল তাকে অবশ্যই কোনো না কোন জিনিসপত্র বহন করতে হবে| প্রভু যেভাবে কাজ সম্পন্ন করার আদেশ দিয়েছিলেন সেই ভাবেই এইসব কাজ সম্পাদিত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“অসুস্থতা এবং রোগ থেকে তাদের শিবির মুক্ত রাখার জন্য আমি ইস্রায়েলের লোকদের আদেশ করছি| লোকদের বলো চর্মরোগ আছে এমন ব্যক্তিকে শিবির থেকে যেন বের করে দেওয়া হয়| যার শরীর থেকে কিছু বার হচ্ছে তাকে দূরে পাঠিয়ে দিতে বলো এবং তাদের বলে দাও মৃতদেহ স্পর্শ করেছে এমন যে কোনো ব্যক্তিকেও শিবির থেকে বার করে দিতে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","সে পুরুষই হোক্ অথবা স্ত্রী হোক্ তাতে কিছু আসে যায় না, তাকে শিবির থেকে বার করে দাও যাতে তাদের যে শিবিরের মধ্যে আমি বাস করি সেখানে অসুস্থতা এবং অশুদ্ধতা ছড়িয়ে না পড়ে|” ");
INSERT INTO ben2006_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ইস্রায়েলের লোকরা ঈশ্বরের আদেশ পালন করেছিল| তারা সেই সমস্ত লোকদের শিবিরের বাইরে পাঠিয়ে দিয়েছিল| প্রভু মোশিকে যা যা আদেশ দিয়েছিলেন তারা সেইগুলোই করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ইস্রায়েলের লোকদের এ কথা বলে দাও: একজন ব্যক্তি হয়তো আরেকজন ব্যক্তির ক্ষতি করতে পারে| যখন কেউ অন্যদের কিছু ক্ষতি করে তখন সে আসলে ঈশ্বরের বিরুদ্ধেই পাপ কাজ করে| সেই ব্যক্তিটি অপরাধী| ");
INSERT INTO ben2006_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","সুতরাং সে তার নিজের পাপ স্বীকার করবে| সেই ব্যক্তিটি অবশ্যই তার ভুল কাজের জন্য পুরো খেসারত দিতে বাধ্য থাকবে| এছাড়াও সে তার খেসারতের এক পঞ্চমাংশ পরিমাণ মূল্য সেই ব্যক্তিকে দেবে, যার ক্ষতি সে করেছে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","কিন্তু হয়তো এমনও হতে পারে যে, সে যে ব্যক্তির ক্ষতি করেছে সে মারা গেছে এবং এমনও হতে পারে যে তার হয়ে খেসারতের মূল্য গ্রহণ করার মতো কোনো নিকট আত্মীয় নেই| সে ক্ষেত্রে যে ব্যক্তিটি খারাপ কাজ করেছিল, সে প্রভুকে সেই মূল্য দেবে| সেই মূল্যের পুরোটাই তাকে যাজককে দিতে হবে| যাজক সেই মানুষকে শুচি করার জন্য অবশ্যই একটি পুং মেষ বলি দেবে| যে ব্যক্তি অন্যায় কাজ করেছে, তার পাপকে ঢাকা দেওয়ার জন্যই এই মেষ বলি দেওয়া হবে| কিন্তু যাজক বাকী মূল্য রেখে দিতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“যদি ইস্রায়েলের লোকদের মধ্যে কোনো একজন ঈশ্বরকে কোনো বিশেষ উপহার দেয়, তাহলে যিনি সেই উপহার গ্রহণ করেছেন, সেই যাজক সেটি রেখে দিতে পারেন, এটি তাঁর ");
INSERT INTO ben2006_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","কোনো ব্যক্তির পক্ষে বিশেষ ধরণের উপহার দেওয়া বাধ্যতামূলক নয়| কিন্তু যদি সে কোনো উপহার দেয় তবে সেই উপহার যাজকের প্রাপ্য হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","এর পর প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ইস্রায়েলের লোকদের একথা বলে দাও: একজন পুরুষের স্ত্রী তার কাছে বিশ্বস্ত নাও হতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","অন্য কোনো পুরুষের সঙ্গে তার যৌন সম্পর্ক থাকতে পারে এবং এই ব্যাপারটি সে তার স্বামীর কাছে লুকোতে পারে| সে যে পাপ কাজ করছে সে সম্পর্কে তার স্বামীকে অবহিত করার জন্য সেখানে কেউ নাও থাকতে পারে| তার অন্যায় কাজকর্ম সম্পর্কে তার স্বামী কোনোদিনই কোনো কিছুই নাও জানতে পারে এবং সেই স্ত্রীলোক তার পাপকর্ম সম্পর্কে তার স্বামীকে অবহিত নাও করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","কিন্তু স্ত্রী যে পাপ কার্য করে সেই ব্যাপারে স্বামী সন্দেহ করতে শুরু করতে পারে| সে ঈর্ষান্বিত হয়ে উঠতে পারে| তার মনে এই বিশ্বাস হতে পারে যে তার স্ত্রী তার কাছে আর পবিত্র এবং সৎ‌ নেই| ");
INSERT INTO ben2006_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","যদি তাই হয়, তাহলে সে অবশ্যই তার স্ত্রীকে যাজকের কাছে নিয়ে যাবে| সেই স্বামী অবশ্যই 8 কাপ যবের ময়দা নৈবেদ্য হিসাবে প্রদান করবে| সে সেই যবের ময়দার মধ্যে কোনো তেল বা ধূপধূনা দেবে না| কারণ এটি এক ঈর্ষান্বিত স্বামীর আনা শস্য নৈবেদ্য| এই নৈবেদ্য প্রদান ঐ স্ত্রীলোকটিকে তার দোষ স্মরণ করাবার জন্য| ");
INSERT INTO ben2006_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“যাজক সেই স্ত্রীকে প্রভুর সামনে নিয়ে যাবে এবং সেখানে দাঁড় করিয়ে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","এর পর যাজক পবিত্র জল নিয়ে আসবে এবং একটি মাটির পাত্রে তা রাখবে| যাজক পবিত্র তাঁবুর মেঝে থেকে কিছু ধুলো তুলে সেই জলে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","তারপর যাজক ঐ স্ত্রীলোককে প্রভুর সামনে দাঁড় করাবে| এর পর যাজক সেই স্ত্রীর চুল আলগা করে দেবে এবং তার হাতে সেই নৈবেদ্য রাখবে| এই নৈবেদ্যটি সেই যবের ময়দা যা তার স্বামী ঈর্ষান্বিত হয়েছিল বলে এনেছিল| এই একই সময়ে যাজকের হাতে সেই তিক্ত জল থাকবে যা অভিশাপ নিয়ে আসে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“এর পর যাজক সেই স্ত্রীকে দিব্য করিয়ে বলবেন যে: ‘যদি তুমি অন্য কোনো পুরুষের সঙ্গে না শুয়ে থাকো এবং তুমি যদি তোমার বিবাহিত জীবনের সময়ে স্বামীর বিরুদ্ধে কোনো পাপ না করে থাকো তাহলে অভিশাপ বহনকারী এই তিক্ত জল তোমার কোনো ক্ষতি করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","কিন্তু তুমি যদি তোমার স্বামী নয় এমন কোনোও পুরুষের সঙ্গে যৌন সম্পর্ক করে তোমার স্বামীর বিরুদ্ধে যৌন পাপ করে থাক, তাহলে তুমি শুচি নও| ");
INSERT INTO ben2006_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","যদি তা সত্যি হয়, তাহলে এই বিশেষ জল পান করলে তোমাকে প্রচুর সমস্যার সম্মুখীন হতে হবে| তুমি কোনো সন্তানের জন্ম দিতে পারবে না| এবং তুমি যদি এখন সন্তানসম্ভবা হয়ে থাকো, তাহলে তোমার সন্তান মারা যাবে| তাহলে তোমার লোকরা তোমাকে ত্যাগ করবে এবং তোমার সম্পর্কে কু-কথা কথা বলবে|’ “এর পর যাজক অবশ্যই সেই স্ত্রীকে প্রভুর কাছে এক বিশেষ প্রতিশ্রুতি করার জন্য বলবে| যদি স্ত্রী মিথ্যে কথা বলে তাহলে তার পক্ষে এই খারাপ ঘটনাগুলো যে ঘটবে সে ব্যাপারে তাকে অবশ্যই সম্মত হতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","যাজক অবশ্যই বলবে, ‘তুমি অবশ্যই এই জল পান করবে যা সমস্যার সৃষ্টি করে| যদি তুমি পাপ করে থাকো, তাহলে তুমি বন্ধ্যা হয়ে যাবে, আর যদি তুমি সন্তানসম্ভবা হও, তাহলে তোমার গর্ভের শিশু জন্মের আগেই মারা যাবে|’ এবং সেই স্ত্রী বলবে: ‘তুমি যা বলবে আমি সেই মতো কাজ করতে সম্মত হলাম|’ ");
INSERT INTO ben2006_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“যাজক তখন সেই অভিশাপগুলো একটি গোটানো পুঁথিতে লিখে রাখবে| এরপরে সে জল দিয়ে সেই বাণীগুলো ধুয়ে ফেলবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","এরপর সেই স্ত্রীকে সেই জল পান করতে হবে যা সমস্যার সৃষ্টি করে| এই জল তার মধ্যে প্রবেশ করবে এবং যদি সে দোষী হয় তাহলে এটি তার পক্ষে খুবই যন্ত্রণাদায়ক হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“এরপর যাজক সেই স্ত্রীর কাছ থেকে যে নৈবেদ্য দেওয়া হয়েছিল সেটি নেবে (ঈর্ষার জন্য নৈবেদ্য) এবং প্রভুর সম্মুখে উপস্থাপিত করবে| এরপর যাজক সেটিকে বেদীর উপরে নিয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","যাজক এক মুঠো শস্য নিয়ে সেটিকে বেদীর উপরে দগ্ধ করবে| এরপর সে সেই স্ত্রীকে জলপান করতে বলবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","যদি সেই স্ত্রী তার স্বামীর বিরুদ্ধে যৌন পাপ করে থাকে, তাহলে এই জল তাকে বিপদে ফেলবে| জল তার শরীরে প্রবেশ করে তাকে প্রচুর যন্ত্রণা ভোগ করাবে| কোনো সন্তান যদি তার মধ্যে থাকে, তাহলে জন্মের আগেই তার মৃত্যু হবে এবং স্ত্রীলোকটি আর কোনোদিনই কোনো সন্তানের জন্ম দিতে পারবে না| সকলেই তার বিরুদ্ধাচারণ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","কিন্তু সেই স্ত্রী যদি তার স্বামীর বিরুদ্ধে যৌন পাপ না করে থাকে এবং সে যদি শুচিই থেকে থাকে, সেক্ষেত্রে এই বিচার বলে দেবে যে সে দোষী নয়| তখনই সে স্বাভাবিক হবে এবং সন্তানের জন্ম দিতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“এটাই হল ঈর্ষা সংক্রান্ত বিধি যা নির্দেশ দেয় কি করা উচিৎ‌ যখন বিশেষ করে কোনো স্ত্রী তার সাথে বিবাহে আবদ্ধ স্বামীর বিরুদ্ধে পাপকর্মে লিপ্ত হয়| ");
INSERT INTO ben2006_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","অথবা একজন পুরুষের কি করা উচিৎ‌ যদি সে তার স্ত্রীর প্রতি ঈর্ষান্বিত হয় এবং সন্দেহ করে যে তার স্ত্রী তার বিরুদ্ধে পাপকর্মে লিপ্ত হয়েছে| যাজক সেই স্ত্রীকে অবশ্যই প্রভুর সামনে দাঁড়ানোর জন্য বলবে| এরপরে যাজক ঐ সমস্ত কাজগুলি সম্পন্ন করবে| এটাই বিধি| ");
INSERT INTO ben2006_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","তাহলে কোনো রকম অন্যায়ের জন্যে স্বামী দোষী হবে না| কিন্তু যদি স্ত্রী কোনো যৌন পাপ করে থাকে তাহলে তাকে কষ্টভোগ করতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ইস্রায়েলের লোকদের বলো: কোন পুরুষ বা স্ত্রী যদি নাসরীয় হবার জন্য অর্থাৎ‌ প্রভুর জন্য নিজেকে পৃথক করে তবে, ");
INSERT INTO ben2006_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ঐ সময় সেই ব্যক্তি যেন কোনো দ্রাক্ষারস বা অন্য কোনো কড়া পানীয় পান না করে| সেই ব্যক্তি দ্রাক্ষারস বা অন্য কোনো কড়া পানীয় থেকে তৈরী সিরকাও পান করবে না| এবং তাজা দ্রাক্ষা কিংবা কিশ্মিশ্ খাবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","আলাদা থাকার এই বিশেষ সময় দ্রাক্ষা থেকে তৈরী কোনো কিছুই সে খাবে না, এমনকি দ্রাক্ষার বীজ অথবা খোসাও নয়| ");
INSERT INTO ben2006_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“নাসরীয় হয়ে থাকার এই বিশেষ সময়ে সেই ব্যক্তি তার চুলও কাটবে না| এই বিশেষ সময়টি শেষ না হওয়া পর্যন্ত সে অবশ্যই পবিত্র থাকবে| সে তার চুলকে বড় হতে দেবে| সেই ব্যক্তির চুল হচ্ছে ঈশ্বরের কাছে তার শপথের একটি বিশেষ অংশ| ঈশ্বরের কাছে উপহার হিসেবে সে তার চুল দান করবে| সুতরাং আলাদা থাকার এই বিশেষ সময়টি শেষ না হওয়া পর্যন্ত সেই ব্যক্তি তার চুল কাটবে না, তাকে বাড়তে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“পৃথক থাকার এই বিশেষ সময় একজন নাসরীয় কোনো মৃতদেহের কাছে অবশ্যই যাবে না| কারণ, সেই ব্যক্তি প্রভুর কাছে নিজেকে সম্পূর্ণ সমর্পণ করেছে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","এমনকি যদি তার নিজের পিতামাতা কিংবা ভাই অথবা বোন মারা যায়, তাহলেও সে অবশ্যই তাদের স্পর্শ করবে না| এটা তাকে অশুচি করে দেবে| তাকে অবশ্যই দেখাতে হবে যে, সে পৃথক এবং সম্পূর্ণভাবে সে নিজেকে ঈশ্বরের কাছে সমর্পণ করেছে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","পৃথক থাকার এই পুরো সময়ে সে অবশ্যই সম্পূর্ণভাবে নিজেকে প্রভুর কাছে নিবেদন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“এও হতে পারে যে, নাসরীয় এমন একজনের সঙ্গে আছে যে অকস্মাত্‌ মারা গেছে| যদি নাসরীয় এই মৃত ব্যক্তিকে স্পর্শ করে তবে সে অপবিত্র হয়ে যাবে| যদি তাই হয়, তবে নাসরীয় অবশ্যই মাথার সমস্ত চুল কেটে ফেলবে| (ঐ চুল তার বিশেষ প্রতিজ্ঞার একটি অংশ ছিল|) সে অবশ্যই সপ্তম দিনে তার চুল কাটবে, কারণ ঐ দিনে তাকে শুচি করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","এরপর অষ্টম দিনে সেই নাসরীয় অবশ্যই দুটি ঘুঘু এবং দুটি পায়রার বাচ্চা যাজকের কাছে নিয়ে আসবে| সমাগম তাঁবুর প্রবেশ পথেই সে যাজকের কাছে এগুলিকে দিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","তখন যাজক এদের একটিকে পাপ থেকে শুচি হবার জন্য উৎসর্গ করবে| অপরটিকে সে দাহ করার জন্য উৎসর্গ করবে| এই দাহ করা উৎসর্গই হবে নাসরীয়র পাপের প্রতিদান| (সে পাপী কারণ সে একটি মৃতদেহের কাছে ছিল|) ঐ সময় সেই ব্যক্তি ঈশ্বরের কাছে উপহার হিসাবে তার মাথার চুল দেবার জন্য আবার শপথ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","এর অর্থ হল, সেই ব্যক্তি আবার আলাদা থেকে ঈশ্বরের কাছে নিজেকে অবশ্যই সমর্পণ করবে| অবশ্যই সে একটি এক বছর বয়স্ক পুরুষ মেষ নিয়ে আসবে| এবং এই মেষ দোষার্থক বলি হিসাবে উৎসর্গ করবে| তার পৃথক থাকার প্রথম পর্যায়কে গণনা করা হবে না| সে নতুন করে পৃথক থাকতে শুরু করবে| এটা অবশ্যই করতে হবে কারণ সে তার প্রথম পৃথক থাকার সময় একটি মৃতদেহ স্পর্শ করায় অশুচি হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“তার পৃথক থাকার নির্দিষ্ট সময় শেষ হওয়ার পরে নাসরীয় অবশ্যই সমাগম তাঁবুর প্রবেশ পথে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","এবং প্রভুর কাছে তার যা কিছু উৎসর্গ করার তা করবে| তার উৎসর্গ অবশ্যই হবে: একটি নিখুঁত এক বছর বয়স্ক পুরুষ মেষশাবক যা হোমবলির জন্য উৎসর্গ করা হবে| একটি নিখুঁত এক বছর বয়স্ক স্ত্রী মেষশাবক যা পাপার্থক বলির জন্য উৎসর্গ করা হবে| একটি নিখুঁত মেষ যা মঙ্গল নৈবেদ্যর জন্য উৎসর্গ করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","এক ঝুড়ি রুটি যা খামিরবিহীনভাবে তৈরী (তেলের সঙ্গে খুব ভালো ময়দা মিলিয়ে তৈরী কেক|) এই সব কেকের ওপরে অবশ্যই তেল ছড়ানো থাকবে| এই সব উপহারের সঙ্গেই শস্য নৈবেদ্য এবং পেয় নৈবেদ্য উৎসর্গ করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“যাজক এই সকল দ্রব্যসামগ্রী প্রভুর সামনে উপস্থিত করে তখনই পাপস্খালনের জন্য বলি এবং হোমবলি উৎসর্গ করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","যাজক খামিরবিহীন তৈরী এক ঝুড়ি রুটি প্রভুকে দেবেন| তারপর তিনি প্রভুর কাছে মঙ্গল নৈবেদ্য উৎসর্গের জন্য সেই পুং মেষটিকে হত্যা করবেন| যাজক এটিকে শস্য নৈবেদ্য ও পেয় নৈবেদ্যর সাথেই প্রভুকে উৎসর্গ করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“এরপর নাসরীয় সমাগম তাঁবুর প্রবেশ পথে যাবে| সেখানে সে তার এই উৎসর্গ করা চুল কেটে ফেলবে এবং যে আগুন মঙ্গল নৈবেদ্যর জন্য উৎসর্গীকৃত নৈবেদ্যর নীচে জ্বলছে তাতে সেই চুল ফেলে দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“নাসরীয় তার চুল কেটে ফেলার পরে যাজক তাকে পুং মেষের একটি সেদ্ধ করা স্কন্ধ, একটি পিঠে আর একটি সরুচাকলী ঝুড়ি থেকে দেবেন| এই দুটিই খামির ছাড়া তৈরী করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","এর পর যাজক এইসব দ্রব্যসামগ্রী প্রভুর সামনে দোলাবেন| এটি হল দোলনীয় নৈবেদ্য| এই সব দ্রব্যসামগ্রী পবিত্র এবং এগুলো সবই যাজকের| এছাড়াও মেষের বুক এবং উরুও প্রভুর সামনে দোলানো হবে| এই সব দ্রব্যসামগ্রীও যাজকের| এর পর নাসরীয় ব্যক্তিটি দ্রাক্ষারস পান করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“যে ব্যক্তি নাসরীয় শপথ করবে বলে মনস্থ করেছে তার জন্য ঐগুলোই হল নিয়ম| ঐ ব্যক্তি অবশ্যই প্রভুকে ঐসব উপহার দেবে| এছাড়াও যদি কোনো ব্যক্তি আরও কিছু বেশী দিতে সক্ষম হয় এবং তা দেবার জন্য শপথ করে থাকে, তাহলে তাকে অবশ্যই তার শপথ রাখতে হবে| তবে তাকে অবশ্যই কমপক্ষে ঐসব জিনিসপত্র দিতেই হবে যা নাসরীয় শপথের নিয়মে তালিকাভুক্ত হয়েছে|” ");
INSERT INTO ben2006_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“হারোণ এবং তার পুত্রদের বলে দাও যে, এভাবেই তারা ইস্রায়েলের লোকদের আশীর্বাদ করবে|” তারা বলবে: ");
INSERT INTO ben2006_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘প্রভু তোমাদের আশীর্বাদ করুন এবং রক্ষা করুন| ");
INSERT INTO ben2006_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","প্রভু তোমাদের প্রতি সদয় হোন এবং তোমাদের করুণা প্রদর্শন করুন| ");
INSERT INTO ben2006_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","প্রভু তোমাদের প্রার্থনার উত্তর দিন এবং তোমাদের শান্তি দিন|’ ");
INSERT INTO ben2006_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","এরপর প্রভু বললেন, “ইস্রায়েলের লোকদের আশীর্বাদ করার জন্য হারোণ এবং তার পুত্ররা আমার নাম ব্যবহার করবে এবং আমি তাদের আশীর্বাদ করবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","মোশি পবিত্র তাঁবুর স্থাপনের কাজ সম্পন্ন করে এটিকে প্রভুর কাছে উৎসর্গ করল| পবিত্র তাঁবু এবং তার ভেতরের সমস্ত দ্রব্যসামগ্রীকে মোশি অভিষেক করল| বেদী এবং তার সঙ্গে ব্যবহার্য্য অন্যান্য দ্রব্যসামগ্রীকেও মোশি অভিষেক ও পবিত্র করল| এতে বোঝানো হল যে, এই সব দ্রব্যসামগ্রী কেবলমাত্র প্রভুর উপাসনার জন্যই ব্যবহৃত হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","এরপর ইস্রায়েলের নেতাগণ প্রভুকে তাদের নৈবেদ্য প্রদান করল| এই সকল নেতারা ছিল তাদেরই পরিবারের কর্তা এবং তাদের গোষ্ঠীর নেতা| এই সব লোকরা হল তারাই যাদের লোকসংখ্যা গণনা করার দায়িত্ব ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","এই সব লোকরা প্রভুর কাছে উপহার এনেছিল| তারা ছয়টি আচ্ছাদিত শকট এবং সেই শকটগুলিকে চালানোর জন্য বারোটি গরু এনেছিল| (প্রত্যেক নেতা একটি করে গরু দিয়েছিল| প্রত্যেক নেতা অপর আরেক নেতার সঙ্গে একসঙ্গে একটি করে শকট দিয়েছিল|) পবিত্র তাঁবুতেই নেতারা প্রভুকে এই সব দ্রব্যসামগ্রী দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“নেতাদের কাছ থেকে এই সব উপহারসামগ্রী গ্রহণ করো| সমাগম তাঁবুর কাজে এইসব উপহারসামগ্রী ব্যবহার করা যাবে| লেবীয়দের এই সব জিনিসপত্র দিয়ে দাও| এই জিনিসগুলি তাদের প্রয়োজন হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","তাই মোশি শকটগুলি এবং গরুগুলোকে গ্রহণ করে ঐগুলো লেবীয় পরিবারভুক্তদের দিয়ে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","মোশি গের্শোন গোষ্ঠীভুক্ত লোকদের দুটি গাড়ী এবং চারটি গরু দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","এরপর মোশি মরারি গোষ্ঠীভুক্ত লোকদের চারটি গাড়ী এবং আটটি গরু দিয়েছিল| তাদের কাজের জন্য এই শকট ও গরুর তাদের প্রয়োজন ছিল| যাজক হারোণের পুত্র ঈথামর এইসব ব্যক্তিদের কাজকর্মের জন্য দায়বদ্ধ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","মোশি কহাতের পরিবারগোষ্ঠীকে একটিও গরু অথবা গাড়ি দেয় নি, কারণ তাদের কাজ ছিল পবিত্র দ্রব্যসামগ্রী নিজেদের কাঁধেই বহন করা| ");
INSERT INTO ben2006_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","মোশি বেদীকে অভিষেক করেছিল| ঐ একই দিনে বেদীটিকে উৎসর্গ করার জন্য নেতারা তাদের নৈবেদ্য নিয়ে এসেছিল| তারা বেদীতে প্রভুকে তাদের নৈবেদ্য প্রদান করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","প্রভু মোশিকে বললেন, “বেদীটিকে উৎসর্গ করার জন্যে প্রত্যেকদিন একজন করে নেতা তার উপহার নিয়ে আসবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","বারোজন নেতার প্রত্যেকে তাদের উপহার নিয়ে এসেছিল| এইগুলি হল উপহার সামগ্রী: প্রত্যেক নেতা 3-1/4 পাউণ্ড ওজনের একটি করে রূপোর থালা এবং 1-3/4 পাউণ্ড ওজনের একটি করে রূপোর বাটি এনেছিল| এই দুরকমের উপহারই পবিত্র স্থানের মাপকাঠি অনুসারে ওজন করা হয়েছিল| প্রত্যেকটি বাটি এবং থালা তেল মিশ্রিত সূক্ষ্ম ময়দায় পূর্ণ ছিল; এটি শস্য নৈবেদ্যর জন্য ব্যবহৃত হত| প্রত্যেক নেতা 4 আউন্স ওজনের একটি করে বড় সোনার চামচও এনেছিল| এই চামচগুলি সুগন্ধি ধূনোয় পরিপূর্ণ ছিল| এছাড়াও তারা প্রত্যেকে একটি করে এঁড়ে বাছুর, একটি মেষ এবং এক বছর বয়স্ক একটি পুং মেষশাবক এনেছিল| এই পশুগুলিকে হোমবলির জন্য আনা হয়েছিল| পাপ কর্মের উৎসর্গের জন্য তারা প্রত্যেকে একটি করে পুরুষ ছাগল এনেছিল| প্রত্যেকে 2টি গরু, 5টি পুং মেষ, 5টি পুং ছাগল এবং এক বছর বয়স্ক 5টি পুং মেষশাবক এনেছিল| এই সকল দ্রব্যসামগ্রী মঙ্গল নৈবেদ্য হিসাবে উৎসর্গীকৃত হয়েছিল| প্রথম দিন, যিহূদা পরিবারগোষ্ঠীর নেতা অম্মীনাদবের পুত্র নহশোন তার উপহার এনেছিল| দ্বিতীয় দিন, ইষাখরের গোষ্ঠীর নেতা সূয়ারের পুত্র নথনেল তার উপহার এনেছিল| তৃতীয় দিন, সবূলূন পরিবারগোষ্ঠীর নেতা হেলোনের পুত্র ইলীয়াব তার উপহার এনেছিল| চতুর্থ দিন, রূবেণ গোষ্ঠীর নেতা শদেয়ূরের পুত্র ইলীষুর তার উপহার এনেছিল| পঞ্চম দিন, শিমিয়োন গোষ্ঠীর নেতা সূরীশদ্দয়ের পুত্র শলূমীয়েল তার উপহার এনেছিল| ষষ্ঠ দিন, গাদ গোষ্ঠীর নেতা দ্যূয়েলের পুত্র ইলীয়াসফ তার উপহার এনেছিল| সপ্তম দিন, ইফ্রয়িম গোষ্ঠীর নেতা অম্মীহূদের পুত্র ইলীশামা তার উপহার এনেছিল| অষ্টম দিন, মনঃশি গোষ্ঠীর নেতা পদাহসূরের পুত্র গমলীয়েল তার উপহার এনেছিল| নবম দিন, বিন্যামীন গোষ্ঠীর নেতা গিদিয়োনির পুত্র অবীদান তার উপহার এনেছিল| দশম দিন, দান গোষ্ঠীর নেতা অম্মীশদ্দয়ের পুত্র অহীয়েষর তার উপহার এনেছিল| একাদশ দিন, আশের গোষ্ঠীর নেতা অক্রণের পুত্র পগীয়েল তার উপহার এনেছিল| দ্বাদশ দিন, নপ্তালি গোষ্ঠীর নেতা ঐননের পুত্র অহীরঃ তার উপহার এনেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","সুতরাং ঐসব দ্রব্যসামগ্রী ছিল ইস্রায়েলের লোকদের নেতাদের কাছ থেকে পাওয়া উপহারসামগ্রী| মোশি বেদীটিকে অভিষেক করে উৎসর্গ করার সময় তারা এই সকল দ্রব্যসামগ্রী নিয়ে এসেছিল| তারা 12টি রূপোর থালা, 12টি রূপোর বাটি এবং 12টি সোনার চামচ এনেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","প্রত্যেকটি রূপোর থালা প্রায় 3-1/4 পাউণ্ড ওজনের ছিল| এবং প্রত্যেকটি বাটির ওজন ছিল প্রায় 1-3/4 পাউণ্ড| পবিত্র স্থানের মাপকাঠি অনুসারে সমস্ত রূপোর থালা এবং রূপোর বাটির মোট ওজন ছিল প্রায় 60 পাউণ্ড| ");
INSERT INTO ben2006_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","পবিত্র স্থানের মাপকাঠি অনুসারে সুগন্ধি ধূনোয় পরিপূর্ণ 12 টি সোনার চামচের প্রত্যেকটির ওজন ছিল প্রায় 4 পাউণ্ড| 12টি সোনার চামচের মোট ওজন ছিল প্রায় 3 পাউণ্ড| ");
INSERT INTO ben2006_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","হোমবলি উৎসর্গের জন্য পশুর মোট সংখ্যা ছিল 12টি ষাঁড়, 12টি মেষ এবং 12টি এক বছর বয়স্ক পুরুষ মেষশাবক| ঐসব দ্রব্যসামগ্রীর উৎসর্গের সঙ্গে যে শস্য নৈবেদ্যর জন্য আবশ্যক, তাও ছিল এবং সেখানে 12টি পুরুষ ছাগলও ছিল যা প্রভুর কাছে পাপার্থক বলি হিসাবে উৎসর্গের জন্য ব্যবহৃত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","এছাড়াও নেতারা মঙ্গল নৈবেদ্যর জন্য বলি হিসাবে উৎসর্গের জন্য পশুও দিয়েছিল| এই সব পশুদের মোট সংখ্যা ছিল 24টি ষাঁড়, 60টি মেষ, 60টি পুরুষ ছাগল এবং 60টি এক বছর বয়স্ক পুরুষ মেষশাবক| এই ভাবে মোশি অভিষেক করার পরে তারা বেদীটিকে উৎসর্গ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","মোশি যখনই প্রভুর সাথে কথা বলার জন্য সমাগম তাঁবুতে যেত, সে প্রভুর কন্ঠস্বর শুনত, প্রভু তাঁর সঙ্গে কথা বলতেন| সেই সাক্ষ্যসিন্দুকের বিশেষ আচ্ছাদনের ওপরের দুজন করূব দূতের মাঝখান থেকে সেই কন্ঠস্বর শোনা যেত| এই ভাবে ঈশ্বর মোশির সঙ্গে কথা বলতেন| ");
INSERT INTO ben2006_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“হারোণকে বলো, সে বাতিগুলো জ্বালালে বাতিগুলোর আলোয় যেন বাতিস্তম্ভের সামনের জায়গাটা আলোকিত হয়|” ");
INSERT INTO ben2006_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","হারোণ তাই করেছিল| সঠিক জায়গাতেই সে বাতিগুলো রেখেছিল এবং এমনভাবে রেখেছিল যে, বাতিস্তম্ভের সামনের জায়গাটা আলোকিত হয়েছিল| প্রভু মোশিকে যা আদেশ করেছিলেন তা মোশি পালন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","এই ভাবে বাতিস্তম্ভটি তৈরী করা হয়েছিল| এটি পিটানো সোনা দিয়ে তৈরী করা হয়েছিল, বাতিস্তম্ভের গোড়ার সোনার ভিত থেকে উপরের সোনার ফুল পর্যন্ত পুরোটাই| প্রভু মোশিকে ঠিক যেরকম দেখিয়েছিলেন এটি সেরকমই দেখতে হয়েছিলো| ");
INSERT INTO ben2006_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ইস্রায়েলের অন্যান্য লোকদের থেকে লেবীয়দের পৃথক করো| সেই লেবীয়দের শুচি করো| ");
INSERT INTO ben2006_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","তাদের শুচি করার জন্য তোমার যা যা করা উচিৎ‌ তা এই রকম: পাপার্থক বলির জন্য যে বিশেষ জল আছে সেটা তাদের ওপর ছিটিয়ে দাও| এই জল তাদের শুচি করবে| এরপর তারা তাদের শরীর কামিয়ে পরিষ্কার করবে, বস্ত্রাদি ধোবে এবং শরীরকে পরিষ্কার করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“তারপর লেবীয় গোষ্ঠীভুক্ত লোকরা পালের মধ্যে থেকে একটি অল্পবয়স্ক ষাঁড় নেবে যার সঙ্গেই শস্য নৈবেদ্য উৎসর্গ করা হবে| নৈবেদ্যর উদ্দেশ্যে এই শস্য হবে তেল মেশানো ময়দা| এরপর পাপার্থক বলি উৎসর্গের প্রয়োজনে তুমি আরও একটি অল্পবয়স্ক ষাঁড় নেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","সমাগম তাঁবুর সামনের এলাকায় লেবীয় গোষ্ঠীভুক্ত লোকদের একসঙ্গে ঐ জায়গায় নিয়ে এসো| ");
INSERT INTO ben2006_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","প্রভুর সামনে লেবীয় গোষ্ঠীভুক্ত লোকদের নিয়ে এলে ইস্রায়েলের লোকরা তাদের হাত লেবীয়দের ওপরে রাখবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","এরপর হারোণ লেবীয় গোষ্ঠীভুক্ত লোকদের ইস্রায়েল সন্তানদের কাছ থেকে প্রভুর কাছে আনা বিশেষ উপহার হিসাবে দিয়ে দেবে| এই ভাবে লেবীয় গোষ্ঠীভুক্ত লোকরা প্রভুর উদ্দেশ্যে তাদের বিশেষ কাজ করার জন্য প্রস্তুত হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“এরপর লেবীয়রা ষাঁড়ের মাথায় হাত রাখবে, তার মধ্যে একটি ষাঁড় পাপার্থক বলি হিসাবে এবং অন্যটি হোমবলি হিসাবে প্রভুর কাছে উৎসর্গ করার জন্য ব্যবহার করা হবে| এইসব উৎসর্গ লেবীয় গোষ্ঠীভুক্ত লোকদের পবিত্র করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","লেবীয় গোষ্ঠীভুক্ত লোকদের হারোণ এবং তার পুত্রদের সামনে দাঁড়াতে বলো| এরপর প্রভুর কাছে লেবীয় গোষ্ঠীভুক্ত লোকদের দিয়ে দাও| তারা দোলনীয় নৈবেদ্যর মতো হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","তুমি লেবীয়দের ইস্রায়েলের অন্যান্য লোকদের থেকে পৃথক করবে| লেবীয় গোষ্ঠীভুক্ত লোকরা আমার হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“সুতরাং লেবীয় গোষ্ঠীভুক্ত লোকদের শুচি করো এবং তাদেরকে প্রভুর কাছে দিয়ে দাও| তারা দোলনীয় নৈবেদ্যর মতো হবে| তুমি এটা করার পরে তারা সমাগম তাঁবুতে তাদের নির্ধারিত কাজ করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ইস্রায়েলীয় লোকরা লেবীয়র গোষ্ঠীভুক্ত লোকদের আমার কাছে দিয়ে দেবে| তারা আমার হবে| অতীতে আমি প্রত্যেক ইস্রায়েলীয় পরিবারকে তাদের প্রথমজাত পুত্র আমাকে দিয়ে দিতে বলেছিলাম| কিন্তু এখন আমি ইস্রায়েলের অন্যান্য পরিবারের প্রথমজাত পুত্রদের পরিবর্তে লেবীয় গোষ্ঠীভুক্ত লোকদের নিচ্ছি| ");
INSERT INTO ben2006_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ইস্রায়েলের প্রত্যেক পুংলিঙ্গধারী প্রথমজাত আমার| সেটি মানুষ হোক্্ অথবা পশু, তাতে কিছু যায় আসে না, সেটি আমারই| কারণ যেদিন আমি মিশরের সমস্ত প্রথমজাত পুত্র এবং পশুদের হত্যা করেছিলাম, আমি আমার জন্য প্রথমজাত পুত্রদের বাছাই করেছিলাম| ");
INSERT INTO ben2006_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","কিন্তু এখন আমি তাদের পরিবর্তে লেবীয় গোষ্ঠীভুক্ত লোকদেরই নেব| ");
INSERT INTO ben2006_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ইস্রায়েলের সকল লোকদের থেকে আমি লেবীয় গোষ্ঠীভুক্ত লোকদের বেছে নিয়েছিলাম| এবং আমি তাদের হারোণ এবং তার পুত্রদের কাছে উপহার হিসেবে দেব| আমি চাই সমাগম তাঁবুতে তারা কাজ করুক| তারা ইস্রায়েলের সমস্ত লোকর জন্যে সেবাকার্য করবে| তারা তাদের শুদ্ধিকরণের বলি উৎসর্গ করতে সাহায্য করবে যা ইস্রায়েলের লোকদের শুচি করবে| তাহলে ইস্রায়েলের লোকরা পবিত্র স্থানের কাছাকাছি এলেও তারা কোনো বড় রকমের অসুস্থতা বা সমস্যার সম্মুখীন হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","সুতরাং মোশি, হারোণ এবং ইস্রায়েলের সমস্ত লোক প্রভুর আদেশ পালন করল| প্রভু মোশিকে যা আদেশ করেছিলেন, ইস্রায়েলীয়রা লেবীয় গোষ্ঠীভুক্ত লোকদের প্রতি তা সম্পন্ন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","লেবীয়রা তাদের নিজেদের এবং তাদের পোশাক পরিচ্ছদ পরিষ্কার করলে হারোণ তাদের প্রভুর কাছে দোলনীয় নৈবেদ্যর মতো অর্পণ করল| হারোণ যে নৈবেদ্য নিবেদন করল তা তাদের পাপমুক্ত এবং শুচি করল| ");
INSERT INTO ben2006_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","এরপর লেবীয়রা তাদের নির্ধারিত কাজ করার জন্য সমাগম তাঁবুতে এল| তারা হারোণ এবং তার পুত্রদের অধীনে ছিল| প্রভু মোশিকে যা বলেছিলেন লেবীয়দের প্রতি তাই করা হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","এরপর প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“এটি লেবীয়দের জন্য এক বিশেষ আদেশ: 25 বছর অথবা তার বেশী বয়স্ক প্রত্যেক লেবীয় পুরুষ সমাগম তাঁবুতে অবশ্যই আসবে এবং সমাগম তাঁবুর কাজকর্মে অংশ নেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","কিন্তু যখন কারোও বয়স 50 বছর তখন সে অবশ্যই ভারী কাজকর্ম থেকে অবসর নেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","পঞ্চাশ বছর অথবা তার বেশী বয়স্ক সেই সকল ব্যক্তিরা সমাগম তাঁবুতে পাহারা দিয়ে তাদের ভাইদের কাজে সাহায্য করতে পারে| কিন্তু তারা যেন কোন ভারী কাজ না করে| যখন তুমি লেবীয় গোষ্ঠীভুক্ত লোকদের তাদের কাজের জন্য মনোনীত করেছো তখন তুমি এই কাজগুলি অবশ্যই করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ইস্রায়েলের লোকরা মিশর ছেড়ে চলে আসার পরে দ্বিতীয় বছরের প্রথম মাসে প্রভু সীনয় মরুভূমিতে মোশির সাথে এই কথা বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ইস্রায়েলের লোকদের ঠিক সময়ে নিস্তারপর্বের পবিত্র দিন উদযাপন করতে বলে দাও| ");
INSERT INTO ben2006_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","তারা অবশ্যই এই মাসের 14 তারিখ, গোধুলি বেলায় উদ্বারের পবিত্র দিনের খাদ্য গ্রহণ করবে| তারা অবশ্যই নির্ধারিত সময়ে এই কাজ করবে এবং নিস্তারপর্বের সকল নিয়ম তারা অবশ্যই পালন করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","সুতরাং মোশি ইস্রায়েলের লোকদের নিস্তারপর্ব উদযাপন করতে বলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ইস্রায়েলের লোকরা প্রথম মাসের 14 তারিখে গোধুলি বেলায় সীনয় মরুভূমিতে নিস্তারপর্ব পালন করেছিল| প্রভু মোশিকে যেভাবে আদেশ করেছিলেন ইস্রায়েলীয়রা ঠিক সেভাবেই কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","কিন্তু কিছু লোক ঐ দিনটিকে নিস্তারপর্বের পবিত্র দিন হিসেবে উদযাপন করতে পারে নি| তারা অশুচি ছিল, কারণ তারা একটা মৃতদেহ স্পর্শ করেছিল| সুতরাং তারা ঐ দিনে মোশি এবং হারোণের কাছে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","তারা মোশিকে বলল, “আমরা এক ব্যক্তির মৃতদেহ স্পর্শ করে অশুচি হয়েছি| নির্ধারিত সময়ে প্রভুকে উপহার দিতে আমাদের বাধা দেওয়া হচ্ছে| সুতরাং আমরা ইস্রায়েলের অন্যান্য লোকদের সঙ্গে নিস্তারপর্ব উদযাপন করতে পারছি না| আমরা কি করব?” ");
INSERT INTO ben2006_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","মোশি তাদের বলল, “আমি প্রভুকে জিজ্ঞেস করবো তিনি এ ব্যাপারে কি বলেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“তুমি এই কথাগুলো ইস্রায়েলের লোকদের বলো: এই নিয়ম তোমাদের এবং তোমাদের উত্তরপুরুষদের জন্যই| কোনো একজনের পক্ষে নির্ধারিত সময়ে নিস্তারপর্ব উদযাপন করা সম্ভব নাও হতে পারে| হয়তো সেই ব্যক্তি মৃতদেহ স্পর্শ করে অশুচি হয়েছিল অথবা দূর দেশে যাত্রা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","তবু সেই ব্যক্তি অন্য কোনোও সময়ে নিস্তারপর্ব উদযাপন করতে পারবে| দ্বিতীয় মাসের 14 তারিখে গোধুলি বেলায় অবশ্যই সে নিস্তারপর্ব উদযাপন করবে| ঐ সময়ে তারা অবশ্যই নিস্তারপর্বের মেষ, খামির ছাড়া তৈরী রুটি এবং কিছু তেতো শাকপাতা দিয়ে খাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","তারা পরের দিন সকাল পর্যন্ত ঐ খাবারের কোনো কিছুই অবশিষ্ট রাখবে না এবং অবশ্যই সেই মেষের কোনো হাড় ভগ্ন করবে না| সে অবশ্যই নিস্তারপর্বের সব নিয়ম অনুসরণ করবে; ");
INSERT INTO ben2006_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","কিন্তু যে লোকটি শুচি এবং বেড়াতে যায় নি সে যদি নির্দিষ্ট সময় নিস্তারপর্ব উদযাপন না করে, তাহলে তাকে অবশ্যই তার লোকদের কাছ থেকে আলাদা করে দেওয়া হবে| সে দোষী এবং শাস্তির যোগ্য কারণ সে নির্দিষ্ট সময় প্রভুকে তার উপহার দেয় নি| ");
INSERT INTO ben2006_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“তোমাদের সঙ্গে আছে এমন কোনো বিদেশী যদি প্রভুর নিস্তারপর্ব উদ্যাপনের জন্য ইচ্ছুক হয় তাহলে সে অবশ্যই তা করবে কিন্তু সে অবশ্যই নিস্তারপর্বের সকল বিধি অনুসরণ করবে| একই নিয়ম সকলের জন্য প্রযোজ্য|” ");
INSERT INTO ben2006_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","যেদিন সমাগম তাঁবু অর্থাৎ‌ চুক্তির সেই তাঁবু স্থাপিত হল, সেদিন সন্ধ্যায় ঈশ্বরের মেঘ সেটিকে আবৃত করল এবং সকাল পর্যন্ত পবিত্র তাঁবুর ওপরের মেঘকে ঠিক আগুনের মতো দেখাচ্ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","মেঘটি সমস্তক্ষণ পবিত্র তাঁবু আবৃত করত এবং রাত্রে সেটাকে আগুনের মতো দেখাতো| ");
INSERT INTO ben2006_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","মেঘটি পবিত্র তাঁবুর ওপর থেকে স্থান পরিবর্তন করলে, ইস্রায়েলীয়রা সেটিকে অনুসরণ করল| যখন মেঘটি থামত তখন ইস্রায়েলীয়রা সেখানেই শিবির স্থাপন করত| ");
INSERT INTO ben2006_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","কখন যাত্রা শুরু করতে হবে, কখন থামতে হবে এবং কখন শিবির স্থাপন করতে হবে সে ব্যাপারে ইস্রায়েলের লোকদের প্রভু এই রাস্তাই দেখিয়েছিলেন| যতক্ষণ পর্যন্ত পবিত্র তাঁবুর ওপরে মেঘ থাকত, ততক্ষণ পর্যন্ত লোকরা সেই একই জায়গায় শিবির স্থাপন করে বসবাস করত| ");
INSERT INTO ben2006_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","কোনো কোনো সময়ে পবিত্র তাঁবুর ওপরে দীর্ঘ সময় ধরে মেঘ থাকতো| ইস্রায়েলীয়রা প্রভুর আদেশ পালন করত এবং সেই স্থান ত্যাগ করত না| ");
INSERT INTO ben2006_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","কোনো সময়ে আবার অল্প কয়েকদিনের জন্য পবিত্র তাঁবুর ওপরে মেঘ থাকতো| সুতরাং লোকরা প্রভুর আদেশ পালন করত–যখন মেঘ চলতে শুরু করত, তখন তারাও সেই মেঘকে অনুসরণ করত| ");
INSERT INTO ben2006_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","কোনো সময় আবার মাত্র এক রাত্রির জন্য মেঘ স্থায়ী হত। পরদিন সকালেই আবার চলতে শুরু করত| সুতরাং লোকরা তাদের জিনিসপত্র এক জায়গায় জড়ো করে মেঘকে অনুসরণ করত| দিনের বেলায় অথবা রাত্রিতে যখনই মেঘ চলতে শুরু করত তখনই লোকরা তাকে অনুসরণ করত| ");
INSERT INTO ben2006_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","যদি সেই মেঘ দুদিন অথবা এক মাস অথবা এক বছরের জন্য পবিত্র তাঁবুর উপরে স্থায়ী হত তখনও লোকরা প্রভুর আদেশ পালন করত| তারা সেই জায়গায় থাকত এবং সেই স্থান থেকে মেঘ না সরে যাওয়া পর্যন্ত সেই স্থান তারা ত্যাগ করত না| এরপর মেঘ সেই জায়গা থেকে উঠে চলতে শুরু করলে, লোকরাও চলতে শুরু করত| ");
INSERT INTO ben2006_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","সুতরাং লোকরা প্রভুর আদেশ পালন করত| প্রভু বললে তারা শিবির স্থাপন করত এবং প্রভু বললে তারা চলতে শুরু করত| লোকরা খুব সতর্কভাবে নজর রাখত এবং প্রভু মোশিকে যা আদেশ করতেন তা তারা পালন করত| ");
INSERT INTO ben2006_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","প্রভু মোশিকে বললেন: ");
INSERT INTO ben2006_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“দুটি রূপোর শিঙা তৈরী কর| শিঙা দুটি তৈরী করার জন্য পেটানো রূপো ব্যবহার কর| লোকদের একসঙ্গে ডাকার জন্য এবং শিবির স্থানান্তরের সময় বলার জন্য এই শিঙা দুটি ব্যবহার করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","যদি শিঙা দুটি এক সাথে দীর্ঘ সুরে জোরে বাজাও, তাহলে সব লোক যেন সমাগম তাঁবুর প্রবেশ পথে তোমার সামনে আসে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","কিন্তু যদি তুমি তোমার সঙ্গে দেখা করার জন্য নেতাদের অর্থাৎ‌ ইস্রায়েলের বারোটি পরিবারগোষ্ঠীর প্রধানদের জড়ো করতে চাও, তাহলে কেবলমাত্র একটি শিঙাকেই দীর্ঘ সুরে বাজাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“শিঙা দুটি অল্পক্ষণের জন্য বাজানো হলে বোঝাবে যে শিবিরকে সরিয়ে নিয়ে যেতে হবে| তখন সমাগম তাঁবুর পূর্বদিকে যে পরিবারগোষ্ঠী শিবির স্থাপন করেছে তারা অবশ্যই চলতে শুরু করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","দ্বিতীয়বার শিঙা দুটিকে অল্পক্ষণের জন্য বাজালে সমাগম তাঁবুর দক্ষিণদিকে যে পরিবারগোষ্ঠী শিবির স্থাপন করেছে তারা চলতে শুরু করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","কিন্তু যদি বিশেষ সভার জন্য লোকদের এক জায়গায় একত্রিত করতে চাও, তাহলে শিঙা দুটিকে দীর্ঘ সময় ধরে কিন্তু অন্যভাবে বাজাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","কেবলমাত্র হারোণের পুত্ররা এবং যাজকরা শিঙা দুটিকে বাজাবে| এই বিধি তোমাদের এবং তোমাদের পরবর্তী বংশধরদের জন্য চিরকালীন বিধি| ");
INSERT INTO ben2006_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“যদি তুমি তোমার কোনো শত্রুর সঙ্গে তোমার নিজের দেশে যুদ্ধ করতে যাও, তাহলে তুমি তাদের সঙ্গে যুদ্ধ করতে যাওয়ার আগে শিঙা দুটিকে অল্প সময়ের জন্য জোরে বাজাবে| প্রভু তোমার ঈশ্বর, তোমার শিঙার আওয়াজ শুনতে পাবেন এবং তিনি তোমাকে তোমার শত্রুদের হাত থেকে বাঁচাবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","এছাড়াও তোমার বিশেষ সভার সময়, অমাবস্যার দিনগুলোতে এবং তোমাদের সকলের সুখের সমাবেশে এই শিঙা দুটিকে বাজাবে| তুমি যখন তোমার হোমবলি এবং মঙ্গল নৈবেদ্য প্রদান করবে সেই সময়ও শিঙা দুটিকে বাজাবে| প্রভু, তোমার ঈশ্বর তোমাকে যেন মনে রাখেন, সে জন্যই এই বিশেষ পদ্ধতি| এটি করার জন্য আমি তোমাকে আদেশ করছি; আমিই প্রভু তোমার ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ইস্রায়েলের লোকরা মিশর ত্যাগ করার পরে, দ্বিতীয় বছরের দ্বিতীয় মাসের 20 তম দিনে চুক্তির তাঁবুর ওপর থেকে মেঘ উঠল| ");
INSERT INTO ben2006_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","তাই ইস্রায়েলের লোকরা তাদের যাত্রা শুরু করল| তারা সীনয় মরুভূমি ত্যাগ করে পারণ মরুভূমিতে মেঘ থামা পর্যন্ত ভ্রমণ করল| ");
INSERT INTO ben2006_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","এই প্রথম লোকরা তাদের শিবির স্থানান্তর করল| প্রভু মোশিকে যেমন আদেশ করলেন, সেই ভাবেই তারা এটিকে স্থানান্তর করল| ");
INSERT INTO ben2006_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","যিহূদার শিবির থেকে প্রথমে তিনটি গোষ্ঠী গেল| তারা তাদের পতাকা নিয়েই ভ্রমণ করল| প্রথম গোষ্ঠীটি ছিল যিহূদার পরিবারগোষ্ঠী| অম্মীনাদবের পুত্র নহশোন ছিল ঐ গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","এরপর এলেন ইষাখরের পরিবারগোষ্ঠী| সূয়ারের পুত্র নথনেল ছিল ঐ গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","তারপরে এল সবূলূনের পরিবারগোষ্ঠী| হেলোনের পুত্র ইলীয়াব ছিল ঐ গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","এরপর পবিত্র তাঁবুটিকে তোলা হল, গের্শোন এবং মরারি পরিবারের লোকরা পবিত্র তাঁবুটিকে বহন করছিল, সুতরাং এই পরিবারের লোকরা সারিতে ঠিক তার পরেই ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","এরপর রূবেণের শিবির থেকে তিনটি গোষ্ঠী তাদের পতাকাসহ ভ্রমণ করল| প্রথম গোষ্ঠীটি ছিল রূবেণের পরিবারগোষ্ঠী| শদেয়ূরের পুত্র ইলীয়ুর ছিল এই গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","এরপর শিমিয়োনের পরিবারগোষ্ঠী এল| সুরীশদ্দয়ের পুত্র শলূমীয়েল ছিল এই গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","এবং তারপরে এসেছিল গাদের পরিবারগোষ্ঠী| দ্যূয়েলের পুত্র ইলীয়াসফ ছিল এই গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","কহাত্‌ পরিবার, যারা পবিত্র তাঁবু বহন করত, এরপর তারা যাত্রা শুরু করল কারণ নতুন জায়গায় আসামাত্রই তাদের তাঁবুটি স্থাপন করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","এরপর ইফ্রয়িমের শিবির থেকে তিনটি গোষ্ঠী এল| তারা তাদের পতাকাসহ ভ্রমণ করেছিল| প্রথম গোষ্ঠীটি ছিল ইফ্রয়িমের পরিবারগোষ্ঠী| অম্মীহূদের পুত্র ইলীশামা ছিল ঐ গোষ্ঠীর দলনেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","এরপর এসেছিল মনঃশির পরিবারগোষ্ঠী| পদাহসূরের পুত্র গমলীয়েল ছিল এই গোষ্ঠীর দলনেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","এরপর এল বিন্যামীনের পরিবারগোষ্ঠী| গিদিয়োনির পুত্র অবীদান ছিল ঐ গোষ্ঠীর দলনেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","শেষ তিনটি পরিবারগোষ্ঠী ছিল অন্যান্য সকল পরিবারগোষ্ঠীর পশ্চাদভাগরক্ষী| তারা ছিল দানের শিবিরের গোষ্ঠীভুক্ত| তারা তাদের পতাকা নিয়ে ভ্রমণ করল| প্রথম গোষ্ঠীটি ছিল দানের পরিবারগোষ্ঠী| অম্মীশদ্দয়ের পুত্র অহীয়েষর ছিল এই গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","এরপরে এল আশেরের পরিবারগোষ্ঠী অক্রণের পুত্র পগীয়েল ছিল ঐ গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","এরপরে এল নপ্তালি পরিবারগোষ্ঠী| ঐননের পুত্র অহীরঃ ছিল ঐ গোষ্ঠীর দল নেতা| ");
INSERT INTO ben2006_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","স্থানান্তরে যাবার সময় ইস্রায়েলের লোকরা এইভাবেই একসাথে যেত| ");
INSERT INTO ben2006_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","মিদিয়োনীয় রূয়েলের পুত্র ছিল হোবব| (রূয়েল ছিল মোশির শ্বশুর|) মোশি হোরবকে বলল, “আমরা সেই দেশের উদ্দেশ্যে যাত্রা করছি যেটা ঈশ্বর আমাদের দেবেন বলে প্রতিশ্রুতি করেছিলেন| আমাদের সঙ্গে এসো আমরা তোমার সঙ্গে ভালো ব্যবহার করবো| প্রভু ইস্রায়েলীয়দের পক্ষে মঙ্গল প্রতিজ্ঞা করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","কিন্তু হোবব উত্তর দিল, “না, আমি তোমাদের সঙ্গে যাবো না| আমি আমার জন্মভূমিতে, আমার নিজের লোকদের কাছে ফিরে যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","তখন মোশি বলল, “দয়া করে আমাদের ছেড়ে যাবেন না| আপনি মরুভূমি সম্পর্কে আমাদের থেকেও বেশী জানেন| আপনি আমাদের পথ প্রদর্শক হতে পারেন| ");
INSERT INTO ben2006_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","আপনি যদি আমাদের সঙ্গে আসেন তাহলে প্রভু আমাদের যে সকল উত্তম বিষয়ের অধিকারী করবেন, সেটা আমরা আপনার সঙ্গে ভাগ করে নেব|” ");
INSERT INTO ben2006_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","এতে হোবব রাজী হল এবং তারা প্রভুর পাহাড়ের চূড়া থেকে যাত্রা শুরু করল এবং তিন দিন পথে চলল| যাজকগণ প্রভুর সঙ্গে চুক্তির সিন্দুকটি নিয়ে লোকদের আগে আগে হাঁটল| শিবিরের জন্য স্থান অন্বেষণে তারা তিনদিন পবিত্র সিন্দুকটিকে বহন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","প্রত্যেক দিনই প্রভুর মেঘ তাদের ওপরেই থাকত এবং প্রত্যেক দিন সকালে তারা যখন শিবির ত্যাগ করত, তখন মেঘ তাদের পথ প্রদর্শন করত| ");
INSERT INTO ben2006_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","শিবির স্থানান্তরের জন্য লোকরা যখনই পবিত্র সিন্দুকটিকে ওঠাতো, মোশি তখনই প্রত্যেকবারের মত বলত, “প্রভু তুমি ওঠ! তোমার শত্রুরা ছড়িয়ে ছিটিয়ে যাক| তোমার শত্রুরা তোমার কাছ থেকে পালিয়ে যাক|” ");
INSERT INTO ben2006_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","যখনই পবিত্র সিন্দুকটিকে তার নিজের জায়গায় রাখা হত, মোশি তখনই প্রত্যেকবারের মত বলত, “প্রভু তুমি, কোটি কোটি ইস্রায়েলীয়দের কাছে ফিরে এসো|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","লোকরা তাদের সমস্যা সম্পর্কে অভিযোগ করা শুরু করলে প্রভু তাদের অভিযোগ শুনলেন এবং ক্ষুদ্ধ হলেন| প্রভুর কাছ থেকে আগুন এসে লোকদের মধ্যে জ্বলে উঠল| আগুন শিবিরের বাইরের দিকে কিছু কিছু এলাকা গ্রাস করল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","তখন লোকরা মোশির কাছে সাহায্যের জন্য ক্রন্দন করল| মোশি প্রভুর কাছে প্রার্থনা করল এবং আগুন নিভে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","সুতরাং তারা ঐ জায়গাটির নাম রাখল তবেরা, কারণ প্রভুর আগুন তাদের শিবিরের মধ্যে জ্বলে উঠেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","বিদেশীরা যারা ইস্রায়েলের লোকদের সঙ্গে যোগদান করেছিল, তারা অন্যান্য খাবার খেতে চাইল এবং ইস্রায়েলের লোকরা পুনরায় অভিযোগ করতে শুরু করল| তারা বলল, “কে আমাদের মাংস খেতে দেবে? ");
INSERT INTO ben2006_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","আমরা মিশরে যে মাছ খেতাম তা মনে পড়ছে| আমাদের ঐ মাছের জন্য কোনো দামই দিতে হত না| এছাড়াও আমাদের খুব ভালো শাকসব্জি ছিল যেমন শশা, ফুটি, পেঁয়াজ জাতীয় ফল, পেঁয়াজ এবং রসুন| ");
INSERT INTO ben2006_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","কিন্তু এখন আমরা আমাদের শক্তি হারিয়ে ফেলেছি| এই মান্না ছাড়া আর কোন কিছুই আমরা চোখে দেখতে পাই না|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(এই মান্না ছিল ধনে বীজের মত এবং এর রং ছিল গুগ্গুলের মতো| ");
INSERT INTO ben2006_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","লোকরা এই মান্না এক জায়গায় জড়ো করত| এরপর তারা পাথরের সাহায্যে সেগুলোকে গুঁড়ো করে পাত্রে সেটি রান্না করত| অথবা এটিকে পেষণ যন্ত্রে মিহি করে গুঁড়ো করে তা দিয়ে পিঠে তৈরী করত| পিঠেগুলোর স্বাদ ছিল অলিভ তেল দিয়ে তৈরী করা পিঠের মতো| ");
INSERT INTO ben2006_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","প্রত্যেক রাত্রে যখন শিশির পড়ে শিবির ভিজে যেত সেই সময় এই মান্না মাটিতে পড়তো|) ");
INSERT INTO ben2006_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","মোশি লোকদের অভিযোগ করতে শুনল| প্রত্যেক পরিবারের লোকরা তাদের তাঁবুর দরজায় বসে এই অভিযোগ করছিল| প্রভু এতে খুব ক্ষুব্ধ হলেন এবং এটা মোশিকেও মনঃক্ষুন্ন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","মোশি প্রভুকে জিজ্ঞেস করল, “প্রভু, আপনি কেন আমাকে এই সব সমস্যায় জড়িয়েছেন? আমি আপনার সেবক| আমি এমন কি করেছি যে আপনি অসন্তুষ্ট হয়েছেন? এই সমস্ত লোকের দায়িত্ব আপনি কেন আমার উপর দিয়েছেন? ");
INSERT INTO ben2006_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","আমি কি লোকদের গর্ভে ধারণ করেছি, আমি কি এদের জন্ম দিয়েছি? কিন্তু আমাকে তাদের যত্ন নিতে হয়, ঠিক যেমন ভাবে একজন সেবিকা তার দুই বাহুর মধ্যে একটি শিশুকে যত্ন করে| আপনি কেন আমাকে এটি করার জন্য বাধ্য করেছেন? পূর্বপুরুষদের যে জায়গা দেবেন বলে আপনি প্রতিশ্রুতি করেছিলেন তাদের সেই জায়গায় নিয়ে যাওয়ার জন্য কেন আপনি আমায় বাধ্য করেছেন? ");
INSERT INTO ben2006_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","এই সব লোককে খাওয়াবার জন্য আমি কোথায় মাংস পাব? তারা সমানে আমার কাছে অভিযোগ করে বলছে, ‘আমাদের খাবার জন্য মাংস দাও!’ ");
INSERT INTO ben2006_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","আমি একা এই সমস্ত লোকের দেখাশুনো করতে পারবো না| এই দায়িত্ব আমার কাছে গুরুভার স্বরূপ| ");
INSERT INTO ben2006_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","আপনি যদি মনস্থ করে থাকেন যে আমার প্রতি এই রকম ব্যবহার করবেন তাহলে আমাকে এখনই হত্যা করুন| আপনি যদি আপনার সেবক হিসেবে আমাকে গ্রহণ করে থাকেন তাহলে আমাকে এখনই মরতে দিন|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","প্রভু মোশিকে বললেন, “ইস্রায়েলের প্রাচীনদের মধ্য থেকে 70 জনকে আমার কাছে নিয়ে এসো| যাদের তুমি এই লোকদের নেতা বলে জান তাদের সমাগম তাঁবুতে নিয়ে এসো| ওখানেই ওদের তোমার সঙ্গে দাঁড়াতে দাও| ");
INSERT INTO ben2006_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","তখন আমি নীচে নেমে আসব এবং ওখানেই তোমার সঙ্গে কথা বলবো| তোমার ওপরে যে আত্মা আছে তার কিছুটা অংশ আমি তাদেরও দেবো| তখন তারা লোকদের দেখাশুনো করার জন্য তোমাকে সাহায্য করবে| তাহলে তোমাকে একা এই সব লোকদের দেখাশুনো করার ভার বহন করতে হবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“লোকদের বলো: তোমরা আগামীকালের জন্য নিজেদের তৈরী করো| আগামীকাল তোমরা মাংস খাবে| প্রভু তোমাদের কান্না শুনেছেন| প্রভু তোমাদের কথা শুনেছেন, কারণ তোমরা কেঁদে বলেছ, ‘খাওয়ার জন্য আমাদের কে মাংস দেবে? আমাদের জন্য মিশরই ভালো ছিল|’ সুতরাং এখন প্রভু তোমাদের মাংস দেবেন এবং তোমরা তা খাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","একদিন অথবা দুইদিন অথবা পাঁচদিন অথবা দশদিন এমনকি কুড়িদিনেরও বেশী সময় ধরে তোমরা সেই মাংস খাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","কিন্তু তোমরা তা এক মাস ধরে খাবে| ঘেন্না না আসা পর্যন্ত তোমরা ঐ মাংস খাবে| এটাই তোমাদের ভবিতব্য কারণ তোমরা প্রভুকে অগ্রাহ্য করেছ যিনি তোমাদের মধ্যেই আছেন এবং তোমরা কেঁদে তাঁর সামনে অভিযোগ করে বলেছ, ‘কেন আমরা আদৌ মিশর ত্যাগ করলাম?’” ");
INSERT INTO ben2006_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","মোশি বলল, “প্রভু এখানে 600,000 পুরুষ ঘুরে বেড়াচ্ছে আর আপনি বলছেন, ‘আমি তাদের এক মাস ধরে খাওয়ার জন্য যথেষ্ট পরিমাণে মাংস দেব!’ ");
INSERT INTO ben2006_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","যদি আমরা সমস্ত গরু এবং মেষদের হত্যা করি তাহলেও এক মাস ধরে এই সমস্ত লোকদের খাওয়ানোর জন্য তা যথেষ্ট হবে না| এবং আমরা যদি সমুদ্রের সমস্ত মাছ ধরে নিই, তাহলেও তা তাদের জন্য যথেষ্ট হবে না!” ");
INSERT INTO ben2006_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","কিন্তু প্রভু মোশিকে বললেন, “প্রভুর ক্ষমতা কি সীমিত? তুমি দেখতে পাবে যে, আমি যা বলি সেটা ফলে কি না|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","সুতরাং মোশি লোকদের সঙ্গে কথা বলার জন্য বেরিয়ে গেল| প্রভু যা যা বলেছিলেন মোশি তাদের তাই বলল| তখন মোশি প্রবীনদের মধ্য থেকে 70 জনকে এক জায়গায় জড়ো করে তাদের তাঁবুর চারদিকে দাঁড়াতে বলল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","তখন প্রভু মেঘের মধ্যে নেমে এসে মোশির সাথে কথা বললেন| মোশির ওপর আত্মা ছিল, প্রভু সেই আত্মার কিছু অংশ নিয়ে 70 জন প্রবীণদের ওপরেও রাখলেন| আত্মা তাদের ওপরে নেমে আসলে পরে তারা ভবিষ্যদ্বানী করতে শুরু করল| কিন্তু এরপর তারা আর ভাববানী বলে নি| ");
INSERT INTO ben2006_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","প্রবীণদের মধ্যে দুজন, ইল্দদ এবং মেদদ তাদের তাঁবুর বাইরে যায় নি| তাদের নাম প্রাচীনদের তালিকায় ছিল, কিন্তু তারা শিবিরেই ছিল| কিন্তু তাদের ওপরেও আত্মা এলে তারা শিবিরের মধ্যেই ভবিষ্যদ্বানী করতে শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","একজন যুবক দৌড়ে গিয়ে মোশিকে এই খবর দিল| সেই ব্যক্তি বলল, “ইল্দদ এবং মেদদ শিবিরের মধ্যেই ভবিষ্যদ্বানী করছে|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","নূনের পুত্র যিহোশূয় (যিনি কিশোর বয়স থেকেই মোশির সহকারী ছিলেন) মোশিকে বলল, “হে আমার গুরু মোশি আপনি তাদের থামান্!” ");
INSERT INTO ben2006_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","কিন্তু মোশি উত্তর দিল, “তুমি কি ভয় পাচ্ছো যে লোকরা ভাববে আমি এখন আর নেতা নই? আমার ইচ্ছা প্রভুর সব প্রজাই যেন ভবিষ্যদ্বানী করতে সক্ষম হয়| আমার ইচ্ছা প্রভু যেন সকলের মধ্যেই তাঁর আত্মাকে রাখেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","এরপর মোশি এবং ইস্রায়েলের নেতারা শিবিরে ফিরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","এরপর প্রভু ঝড়ের সৃষ্টি করলেন যা সমুদ্র থেকে হঠাৎ‌‌ এসে হাজির হল| ঝড় সেখানে হঠাৎ‌‌ই ভারুই পাখীদের নিয়ে এল| ভারুই পাখীরা শিবিরের চারধারে উড়ে বেড়াতে লাগল| এতো বেশী ভারুই পাখী ছিল যে সেই জায়গার মাটি ঢেকে গেল| ভারুই পাখীগুলো মাটির ওপরে তিন ফুট স্তর তৈরী করল| একজন মানুষ একদিনে যতদূর পর্যন্ত হাঁটতে পারে, ততদূর পর্যন্ত ভারুই পাখীগুলো ছড়িয়ে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","তারা গিয়ে সারাদিন এবং সারারাত ধরে ভারুই পাখীগুলোকে জড়ো করল| পরের দিনও সারাদিন ধরে তারা ভারুই পাখীগুলো জড়ো করল| একজন ব্যক্তি সবচেয়ে ন্যুনতম 60 বুশেল সংগ্রহ করল| এরপর লোকরা ভারুই পাখীর মাংস শিবিরের চারদিকে ছড়িয়ে রাখল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","যখন লোকরা মাংস খাওয়া শুরু করল প্রভু খুব ক্রুদ্ধ হলেন| সেই মাংস তাদের মুখে থাকতে থাকতেই এবং তাদের মাংস খাওয়া শেষ করার আগেই প্রভু তাদের গুরুতরভাবে অসুস্থ করে দিলেন| অনেক লোক মারা গেল এবং ঐ জায়গাতেই তাদের কবর দেওয়া হল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","এই কারণেই লোকরা ঐ জায়গার নাম রাখল কিব্রোত্‌-হত্তাবা| তারা ঐ জায়গার ঐ নাম দিল কারণ যাদের মাংসের জন্য খুব আকাঙ্খা ছিল তাদেরই ওখানে কবর দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","কিব্রোত্‌-হত্তাবা থেকে লোকরা হৎসেরোতের দিকে যাত্রা করল এবং সেখানেই থাকল| ");
INSERT INTO ben2006_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","মরিয়ম এবং হারোণ মোশির বিরুদ্ধে কথা বলতে শুরু করল| কারণ মোশি একজন কুশীয়া মহিলাকে বিবাহ করেছিল| তারা মনে করেছিল যে মোশির পক্ষে একজন কুশীয়া মহিলাকে বিবাহ করা ঠিক হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","তারা নিজেদের মধ্যে বলাবলি করল, “প্রভু লোকের সঙ্গে কথা বলার জন্য কি কেবল মোশিকেই ব্যবহার করেছেন? প্রভু কি আমাদের মাধ্যমেও কথা বলেন নি?” প্রভু এই কথাগুলো শুনলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(মোশি খুব নম্র ছিল| পৃথিবীতে যে কোনো মানুষের থেকে সে বেশী নম্র ছিল|) ");
INSERT INTO ben2006_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","হঠাৎ‌‌ই প্রভু এলেন এবং মোশি, হারোণ এবং মরিয়মের সঙ্গে কথা বললেন| প্রভু বললেন, “তোমরা তিনজন এখন সমাগম তাঁবুতে এসো|” সুতরাং মোশি, হারোণ এবং মরিয়ম পবিত্র তাঁবুতে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","প্রভু মেঘ স্তম্ভের মধ্যে নেমে এলেন এবং পবিত্র তাঁবুর প্রবেশ পথে এসে দাঁড়ালেন| প্রভু ডাকলেন, “হারোণ এবং মরিয়ম!” হারোণ এবং মরিয়ম তখন বেরিয়ে এল| ");
INSERT INTO ben2006_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ঈশ্বর বললেন, “আমার কথা শোনো! তোমাদের মধ্যে ভাববাদী থাকবে| আমি প্রভু দর্শনে তাদের দেখা দেবো| আমি তাদের সঙ্গে স্বপ্নে কথা বলবো| ");
INSERT INTO ben2006_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","কিন্তু আমার দাস মোশি সেরকম নয়| মোশি আমার বিশ্বস্ত সেবক| আমার বাড়ীর প্রত্যেকেই তাকে বিশ্বাস করে| ");
INSERT INTO ben2006_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","আমি যখন তার সঙ্গে কথা বলি, তখন তার সঙ্গে মুখোমুখি কথা বলি| আমি এমন কোনো ধাঁধার সাহায্য নিই না যার ভেতরে কোনো অর্থ লুকিয়ে আছে; আমি তাকে যে জিনিস জানাতে চাই সেটা আমি তাকে পরিষ্কারভাবে দেখিয়ে দিই| এবং মোশি প্রভুর সেই প্রতিমূর্ত্তির দিকে তাকিয়ে থাকতে পারে| সুতরাং আমার সেবক মোশির বিরুদ্ধে কথা বলার সাহস তোমাদের কি করে হল?” ");
INSERT INTO ben2006_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","প্রভু তাদের প্রতি ক্রুদ্ধ হলেন, তাই তাদের ত্যাগ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","পবিত্র তাঁবু থেকে মেঘ উপরে উঠলে দেখা গেল মরিয়মের চামড়া হিমের মত সাদা| হারোণ ঘুরে মরিয়মের দিকে তাকিয়ে দেখল, তার শরীরের চামড়ার রং তুষারের মতো সাদা| তার মারাত্মক চামড়ার রোগ হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","তখন হারোণ মোশির কাছে অনুনয় করে বলল, “মহাশয়, দয়া করুন, আমরা মুর্খের মতো যে কাজ করেছিলাম তার জন্য আমাদের ক্ষমা করুন| ");
INSERT INTO ben2006_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","মৃত অবস্থায় জন্ম হয়েছে এমন একটি শিশুর মতো তাকে তার শরীরের চামড়া হারাতে দেবেন না|” (কখনও কখনও এক একটি শিশুর জন্ম হয় যাদের শরীরের অর্ধেক চামড়া ক্ষয়ে গেছে|) ");
INSERT INTO ben2006_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","এই কারণে মোশি ঈশ্বরের কাছে প্রার্থনা করল, “ঈশ্বর, দয়া করে মরিয়মকে এই অসুস্থতা থেকে আরোগ্য করুন!” ");
INSERT INTO ben2006_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","প্রভু মোশিকে উত্তর দিলেন, “যদি তার পিতা তার মুখে থুথু ফেলে, তাহলে সে সাত দিনের জন্যে লজ্জিত থাকত না? সুতরাং তাকে সাত দিনের জন্য শিবিরের বাইরে রাখো| ঐ সময়ের পরে, সে সুস্থ হয়ে উঠবে| তখন সে শিবিরে ফিরে আসতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","সুতরাং তারা মরিয়মকে সাত দিনের জন্য শিবিরের বাইরে নিয়ে গেল এবং লোকরাও সেই জায়গা থেকে আর এগোলো না, যতক্ষণ পর্যন্ত তাকে আবার শিবিরে ফিরিয়ে না নিয়ে আসা হল| ");
INSERT INTO ben2006_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","এরপর লোকরা হৎসেরোত্‌ ত্যাগ করে পারণ মরুভূমির উদ্দেশ্যে গমন করল এবং ঐ মরুভূমিতেই শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“কনান দেশের জমি অনুসন্ধানের জন্য কিছু লোক পাঠিয়ে দাও| ইস্রায়েলের লোকদের আমি এই দেশটিই দেবো| বারোটি পরিবারগোষ্ঠীর প্রত্যেকটির থেকে একজন করে নেতা পাঠিয়ে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","সুতরাং পারণ মরুভূমিতে বাস করার সময় মোশি প্রভুর আদেশ অনুসারে ইস্রায়েলের এই সব নেতাদের পাঠিয়ে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ঐসব নেতাদের নামগুলো হল এই: রূবেণের পরিবারগোষ্ঠী থেকে সক্কুরের পুত্র শম্মুযা| ");
INSERT INTO ben2006_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","শিমিয়োনের পরিবারগোষ্ঠী থেকে হোরির পুত্র শাফট| ");
INSERT INTO ben2006_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","যিহূদার পরিবারগোষ্ঠী থেকে যিফুন্নির পুত্র কালেব| ");
INSERT INTO ben2006_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইষাখর পরিবারগোষ্ঠী থেকে যোষেফের পুত্র যিগাল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ইফ্রয়িম পরিবারগোষ্ঠী থেকে নূনের পুত্র হোশেয়| ");
INSERT INTO ben2006_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিন্যামীন পরিবারগোষ্ঠী থেকে রাফুর পুত্র পল্টি| ");
INSERT INTO ben2006_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","সবূলূন পরিবারগোষ্ঠী থেকে সোদির পুত্র গদ্দীয়েল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","যোষেফের পরিবারগোষ্ঠী থেকে (মনঃশি) সুষির পুত্র গদ্দি| ");
INSERT INTO ben2006_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান পরিবারগোষ্ঠী থেকে গমল্লির পুত্র অম্মীয়েল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আশের পরিবারগোষ্ঠী থেকে মীখায়েলের পুত্র সথুর| ");
INSERT INTO ben2006_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নপ্তালি পরিবারগোষ্ঠী থেকে বপ্সির পুত্র নহ্বি| ");
INSERT INTO ben2006_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","গাদের পরিবারগোষ্ঠী থেকে মাখির পুত্র গ্য়ুয়েল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","মোশি উল্লিখিত ব্যক্তিদের সেই দেশ দেখতে এবং জায়গাটি সম্বন্ধে ধারণা অর্জন করতে পাঠিয়েছিল| (মোশি নূনের পুত্র হোশেয়কে অন্য আরেকটি নামে ডাকত| মোশি তাকে যিহোশূয় বলে ডাকত|) ");
INSERT INTO ben2006_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","মোশি তাদের কনান দেশ অনুসন্ধান করতে পাঠিয়ে বলেছিল, “প্রথমে নেগেভের মধ্য দিয়ে যাও এবং তারপরে পাহাড়ী দেশে ঢুকে পড়ো| ");
INSERT INTO ben2006_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","দেখো, জায়গাটি কেমন দেখতে| ওখানে যারা বসবাস করে তাদের সম্বন্ধে খোঁজ নাও তারা কতোখানি শক্তিশালী অথবা দুর্বল। তারা সংখ্যায় কম না বেশী। ");
INSERT INTO ben2006_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","তারা যেখানে বসবাস করছে সেই জায়গাটি সম্বন্ধে জানো| সেখানকার জমি কি ভালো না খারাপ? কি ধরণের শহরে তারা বাস করে? তাদের সুরক্ষার জন্য কি শহরে কোনো প্রাচীর আছে? শহরগুলো কি মজবুতভাবে সুরক্ষিত? ");
INSERT INTO ben2006_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","এবং দেশটির সম্পর্কে অন্যান্য বিষয়ও জেনে নাও–যেমন সেখানকার জমি উর্বর না অনুর্বর। সেখানে গাছ আছে কি না। এছাড়াও সেই জায়গা থেকে ফিরে আসার সময় সেখান থেকে কিছু ফল নিয়ে আসার চেষ্টা করো|” (এটা ছিল সেই সময় যখন গাছে প্রথম দ্রাক্ষা পাকে|) ");
INSERT INTO ben2006_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","সুতরাং তারা সেই দেশ অনুসন্ধান করতে চলে গেল| তারা সীন মরুভূমি থেকে রহোব এবং লেবো হমাত পর্যন্ত জায়গা অনুসন্ধান করল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","তারা নেগেভের মধ্য দিয়ে দেশে প্রবেশ করে হিব্রোণে গেল| (মিশরের সোয়ন শহর তৈরীর সাত বছর আগে হিব্রোণ শহর তৈরী হয়েছিল|) অহীমান, শেশয় এবং তল্ময় ওখানে বাস করতেন| তারা ছিলেন অনাকের উত্তরপুরুষ| ");
INSERT INTO ben2006_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","এরপর তারা ইষ্কোল উপত্যকায় গিয়ে সেখানে একটি দ্রাক্ষা গাছের শাখা কাটল| শাখাটিতে এক থোকা দ্রাক্ষা ছিল| তারা সেই শাখাটিকে একটি খুঁটির মাঝখানে রেখে দুজন মিলে সেই খুঁটি বহন করল| এছাড়াও তারা ডালিম ফল এবং ডুমুরও নিয়ে এসেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ঐ জায়গাটির নাম ছিল ইষ্কোল উপত্যকা, কারণ ঐ জায়গাতেই ইস্রায়েলের লোকরা দ্রাক্ষার থোকাগুলো কেটেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","40 দিন ধরে গুপ্তচররা সেই দেশ অনুসন্ধান করল| এরপর তারা শিবিরে ফিরে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ইস্রায়েলের গুপ্তচররা সেই সময় কাদেশের কাছে পারণ মরুভূমিতে শিবির স্থাপন করেছিল| গুপ্তচররা মোশি হারোণ এবং ইস্রায়েলের সব লোকদের কাছে গিয়ে তারা যা যা দেখেছে সে সম্পর্কে বলল এবং তাদের সেই দেশের ফলও দেখাল| ");
INSERT INTO ben2006_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","তারা মোশিকে বলল, “আমরা সেই দেশে গেলাম যেখানে আপনি আমাদের পাঠালেন| সেই দেশটি প্রচুর ভালো ভালো দ্রব্যসামগ্রীতে পরিপূর্ণ| এখানে এমন কিছু ফল আছে যা ওখানে ফলে| ");
INSERT INTO ben2006_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","কিন্তু ওখানে যারা বসবাস করে তারা খুবই শক্তিশালী| শহরগুলো খুবই বড়ো| খুবই মজবুতভাবে সেগুলি সুরক্ষিত| এমনকি আমরা সেখানে অনাকের কয়েকজন লোককে দেখেছি| ");
INSERT INTO ben2006_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","অমালেকের লোকরা নেগেভে বাস করে| হিত্তীয়, যিবুষীয় এবং ইমোরীয়রা পার্বত্য শহরে বাস করে| কনানীয়রা সমুদ্রের কাছে যর্দন নদীর পাশে বাস করে|” ");
INSERT INTO ben2006_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","মোশির কাছে যারা বসেছিল, কালেব তখন তাদের চুপ করতে বলল| তারপর কালেব বলল, “আমরা ওপরে যাবো এবং ঐ জায়গা আমাদের জন্য অধিকার করব| আমরা সহজেই ঐ জায়গা অধিকার করতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","কিন্তু তার সঙ্গে অন্য যারা গিয়েছিল তারা বলল, “আমরা ঐ লোকদের সঙ্গে লড়াই করতে পারবো না| তারা আমাদের থেকে অনেক বেশী শক্তিশালী|” ");
INSERT INTO ben2006_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","এবং ঐ লোকরা ইস্রায়েলের অন্যান্য সমস্ত লোকদের বলল যে ঐ দেশের লোকদের পরাস্ত করার পক্ষে তারা যথেষ্ট শক্তিশালী নয়| তারা বলল, “আমরা যে দেশ দেখেছিলাম সে দেশটি শক্তিশালী লোকে পরিপূর্ণ| যারা ওখানে গিয়েছে এমন যে কোনো ব্যক্তিকেই ওখানকার অধিবাসীরা খুব সহজেই পরাস্ত করতে পারবে| এমন শক্তি তাদের আছে| ");
INSERT INTO ben2006_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","আমরা সেখানে দৈত্যাকার নেফিলিম লোকদের দেখেছি| (অনাকের উত্তরপুরুষরা নেফিলিম লোকদের থেকেই এসেছিল|) তাদের কাছে আমাদের ফড়িং-এর মতো দেখাচ্ছিল| হ্যাঁ, আমরা তাদের কাছে ফড়িং-এর মতো|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","সেই রাত্রে সমস্ত লোকরা শিবিরের মধ্যে প্রবল চিৎকার শুরু করল এবং কান্নাকাটিও করল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ইস্রায়েলের লোকরা মোশি ও হারোণের বিরুদ্ধে অভিযোগ করতে লাগল| সমস্ত মানুষ এক জায়গায় একত্রিত হয়ে মোশি ও হারোণকে বলল, “আমাদের মিশরে অথবা মরুভূমিতে মরে যাওয়া উচিৎ‌ ছিল| এই নতুন দেশে এসে নিহত হওয়ার থেকে সেটাই বরং ভালো ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","যুদ্ধে হত হওয়ার জন্যেই কি প্রভু আমাদের এই নতুন দেশে নিয়ে এলেন? শত্রুরা আমাদের হত্যা করবে এবং আমাদের স্ত্রী ও সন্তানদের নিয়ে যাবে| মিশরে ফিরে যাওয়াই কি আমাদের পক্ষে ভালো নয়?” ");
INSERT INTO ben2006_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","তখন লোকরা নিজেদের মধ্যে আলোচনা করে বলল, “এখন আমরা একজন নতুন নেতাকে নির্বাচন করবো এবং মিশরে ফিরে যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","মোশি এবং হারোণ সেখানে ইস্রায়েলের সমবেত সকলের সামনে মাটিতে উবুড় হয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","নূনের পুত্র যিহোশূয় এবং যিফুন্নির পুত্র কালেব, যারা সেই দেশ অনুসন্ধান করে দেখতে গিয়েছিলেন, এই ঘটনায়় বিচলিত হয়ে নিজেদের কাপড় ছিঁড়ল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","সেখানে ইস্রায়েলের সমস্ত লোকর সামনে ঐ দুইজন বলল, “আমরা যে দেশটি দেখেছি সেটি খুবই ভালো| ");
INSERT INTO ben2006_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","প্রভু যদি আমাদের উপর খুশী হয়ে থাকেন, তাহলে তিনিই আমাদের নেতৃত্ব দিয়ে ঐ জায়গায় নিয়ে যাবেন| এবং প্রভু আমাদের সেই সমৃদ্ধ এবং উর্বর দেশটি দিয়ে দেবেন! ");
INSERT INTO ben2006_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","সুতরাং প্রভুর বিরুদ্ধে যেও না| ঐ দেশের লোকদের ভয় পেও না| আমরা তাদের সহজেই পরাস্ত করব| তারা আর সুরক্ষিত নয়, তা তাদের থেকে সরিয়ে দেওয়া হয়েছে| কিন্তু আমাদের সঙ্গে প্রভু আছেন| সুতরাং ভয় পেও না!” ");
INSERT INTO ben2006_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","সকলেই যখন যিহোশূয় এবং কালেবকে পাথর দিয়ে হত্যা করার কথা বলছিল, সেই সময় সমাগম তাঁবুর ওপরে তখনই প্রভুর মহিমা প্রকাশিত হল এবং সকলেই সেটা দেখতে পেল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","প্রভু মোশিকে তখনই বললেন, “এই সব লোকরা আর কতদিন আমার বিরুদ্ধাচরণ করবে? তাদের মধ্যে আমি যে সব নানা অলৌকিক কাজ করেছি তা দেখা সত্ত্বেও এরা কতদিন আমাকে অবিশ্বাস করবে? ");
INSERT INTO ben2006_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","আমি তাদের ভয়ঙ্করভাবে অসুস্থ করে দিয়ে হত্যা করবো| আমি তাদের ধ্বংস করবো এবং তোমাকে এদের চেয়ে বড় এবং বলবান জাতিতে পরিণত করবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","তখন মোশি প্রভুকে বলল, “আপনি যদি তা করেন তবে, মিশরীয়রা সে সম্পর্কে জানতে পারবে| তারা জানে যে আপনার লোকদের মিশর থেকে বার করে আনার সময় আপনি আপনার ক্ষমতা প্রয়োগ করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","এবং মিশরের লোকরা এ সম্পর্কে কনানের লোকদের কাছেও বলবে| তারা এর মধ্যেই জেনে গেছে যে আপনিই প্রভু| তারা জানে যে আপনি আপনার লোকদের সঙ্গে আছেন| কারণ তারা আপনাকে দেখতে পায় এবং আপনার মেঘ তাদের উপর অবস্থিত| তারা এও জানে যে আপনি দিনের বেলায় মেঘস্তম্ভে থেকে এবং রাত্রিবেলা অগ্নিস্তম্ভে থেকে তাদের আগে আগে যান| ");
INSERT INTO ben2006_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","সুতরাং আপনি যদি এদের সকলকে একসাথে হত্যা করেন, তাহলে সেই সব জাতি, যারা আপনার ক্ষমতা সম্পর্কে শুনেছে, তারা বলবে, ");
INSERT INTO ben2006_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘প্রভু এই সব লোকদের এই দেশে আনতে সক্ষম হন নি, যার সম্বন্ধে তিনি তাদের কাছে প্রতিজ্ঞা করেছিলেন| এই কারণেই প্রভু তাদের মরুভূমিতে হত্যা করেছেন|’ ");
INSERT INTO ben2006_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“সুতরাং এখন হে প্রভু আপনি আপনার বাক্য অনুসারে আপনার শক্তি প্রদর্শন করুন| ");
INSERT INTO ben2006_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","আপনি বলেছিলেন, ‘প্রভু ধীরে ক্রুদ্ধ হন এবং প্রেমে মহান| পাপী এবং বিধি ভঙ্গকারীদের তিনি ক্ষমা করেন; কিন্তু তিনি অবশ্যই দোষীদের শাস্তি দেন| প্রভু ঐসব লোকদের শাস্তি দেন এবং এছাড়াও তাদের পুত্রদের, তাদের পৌত্র-পৌত্রীদের এমনকি তাদের প্রপৌত্র প্রপৌত্রীদেরও এই সকল খারাপ কাজের জন্য শাস্তি দেন!’ ");
INSERT INTO ben2006_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","তাই এখন আপনি এইসব লোকদের আপনার মহৎ‌‌ ভালোবাসা দেখান| তাদের পাপকে ক্ষমা করে দিন| মিশক ত্যাগ করার পর থেকে এখন পর্যন্ত আপনি তাদের যেভাবে ক্ষমা করে এসেছেন সেই ভাবেই এখনও আপনি তাদের ক্ষমা করে দিন|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","প্রভু উত্তর দিয়ে বললেন, “হ্যাঁ, তুমি যে ভাবে বলেছো, সেই ভাবেই আমি তাদের ক্ষমা করে দেবো| ");
INSERT INTO ben2006_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","কিন্তু আমি তোমাকে সত্য কথাই বলছি, আমি যেমন নিশ্চিতভাবেই বেঁচে আছি এবং আমার মহিমায় যেমন সারা পৃথিবী নিশ্চিতভাবেই পরিপূর্ণ, তেমনি নিশ্চয়তার সঙ্গেই আমি তোমার কাছে শপথ করছি| ");
INSERT INTO ben2006_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","মিশর থেকে আমি যাদের নিয়ে এসেছিলাম, তাদের কেউই কনান দেশ দেখতে পাবে না| কারণ ঐসব লোকই আমার মহিমা এবং মিশরে ও মরুভূমিতে আমি যে সব অলৌকিক কাজ করেছিলাম সেগুলো দেখেছিল| কিন্তু তাও তারা আমাকে অমান্য করেছে এবং আমাকে এই নিয়ে দশবার পরীক্ষা করেছে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","আমি তাদের পূর্বপুরুষদের কাছে প্রতিশ্রুতি করেছিলাম| আমি শপথ করেছিলাম যে আমি তাদের ঐ জায়গা দিয়ে দেব| কিন্তু যারা আমার বিরুদ্ধাচরণ করেছে, তাদের কেউই সেই জায়গায় কোনোদিন প্রবেশ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","তবে আমার সেবক কালেব একটু আলাদা রকমের; সে আমাকে পুরোপুরি অনুসরণ করেছে| সুতরাং সে যে জায়গা এর মধ্যেই দেখে নিয়েছে, আমি তাকে সেই জায়গাতেই নিয়ে আসব এবং তার বংশ সেই জায়গা অধিকার করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","অমালেকীয়রা এবং কনানীয়রা উপত্যকায় বাস করছে| সুতরাং আগামীকাল তুমি অবশ্যই এই জায়গা ত্যাগ করবে| সূফ সাগরে যাওয়ার পথ ধরে তুমি মরুভূমিতে ফিরে যাও|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","প্রভু মোশি এবং হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“এই সব দুষ্ট লোকরা আর কতদিন ধরে আমার বিরুদ্ধে অভিযোগ করবে? আমি তাদের অভিযোগ ও অসন্তোষ শুনেছি| ");
INSERT INTO ben2006_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","সুতরাং তাদের বলে দাও, ‘তোমরা যে সব ব্যাপারে অভিযোগ করেছিলে, প্রভু নিশ্চিতভাবেই তোমাদের সেই সব অভিযোগগুলোর ব্যাপারে ব্যবস্থা নেবেন| তোমাদের যা হবে তা হল এই: ");
INSERT INTO ben2006_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","মরুভূমিতেই তোমরা মারা যাবে| 20 বছর অথবা তার বেশী বয়স্ক প্রত্যেক ব্যক্তি, যারা প্রত্যেকে আমার লোকদের একজন বলে গণ্য ছিল, তারা মারা যাবে| কারণ তোমরা আমার বিরুদ্ধে অর্থাৎ‌ প্রভুর বিরুদ্ধে অভিযোগ করেছিলে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","সুতরাং যে দেশ আমি তোমাদের দেবো বলে প্রতিজ্ঞা করেছিলাম সেখানে তোমাদের কেউই কোনোদিন প্রবেশ করতে এবং বাস করতে পারবে না| কেবলমাত্র যিফুন্নির পুত্র কালেব এবং নূনের পুত্র যিহোশূয় সে দেশে প্রবেশ করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","তোমরা ভয় পেয়েছিলে এবং অভিযোগ করেছিলে যে নতুন দেশে তোমাদের শত্রুরা তোমাদের কাছ থেকে তোমাদের সন্তানদের ছিনিয়ে নিয়ে যাবে; কিন্তু আমি বলছি, আমি ঐ সন্তানদের সেই দেশে নিয়ে আসবো| তোমরা যা গ্রহণ করতে অস্বীকার করেছো, তারা সেই জিনিসগুলোই উপভোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","কিন্তু তোমরা এই মরুভূমিতেই মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘তোমাদের সন্তানরা 40 বছর ধরে মরুভূমিতে মেষপালক হয়ে থাকবে| তোমাদের অবিশ্বস্ততার জন্য তারা শাস্তি ভোগ করবে| তারা অবশ্যই এই কষ্ট ভোগ করবে যতক্ষণ পর্যন্ত না তোমরা সবাই মরুভূমিতে মারা যাচ্ছো| ");
INSERT INTO ben2006_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","তোমরা 40 বছর ধরে তোমাদের পাপের জন্য শাস্তি ভোগ করবে| (অর্থাৎ‌ 40 দিন ধরে লোকরা যে জায়গাটি অনুসন্ধান করেছিলো তার প্রতিদিনের জন্য এক বছর করে|) তখন তোমরা বুঝতে পারবে আমি তোমাদের বিরুদ্ধে গেলে কি হতে পারে|’ ");
INSERT INTO ben2006_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“আমি প্রভু এবং আমিই শপথ করছি, এই মন্দ লোকরা যারা একত্রে আমার বিরুদ্ধাচরণ করেছে তাদের বিরুদ্ধে আমি এই কাজগুলো করবো| তারা সকলেই এই মরুভূমিতে মারা যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","মোশি যাদের নতুন দেশ অনুসন্ধান করতে পাঠিয়েছিল তারাই ফিরে এসে ইস্রায়েলের সমস্ত লোকদের মধ্যে অভিযোগ ছড়িয়ে দিয়েছিল| তারা বলেছিল যে লোকরা ঐ দেশে প্রবেশ করার পক্ষে যথেষ্ট শক্তিশালী নয়, ");
INSERT INTO ben2006_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","সেই দেশের অখ্যাতিকারী এই লোকরাই মহামারীতে মারা পড়ল–প্রভুর ইচ্ছা অনুসারেই তা হল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","কিন্তু যারা দেশ অনুসন্ধান করতে গিয়েছিল তাদের মধ্যে কেবল নূনের পুত্র যিহোশূয় এবং যিফুন্নির পুত্র কালেব জীবিত থাকল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","মোশি ইস্রায়েলের লোকদের এই সব কথা বললে ইস্রায়েলের সাধারণ লোকরা শোকে ভেঙে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","পরদিন খুব সকালে উঠে লোকরা পর্বতের চূড়ার দিকে এগোল| তারা বলল, “এই আমরা, প্রভু যে দেশের কথা বলেছেন চলো আমরা সেখানে যাই কারণ আমরা পাপ করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","কিন্তু মোশি বলল, “তোমরা প্রভুর আদেশ পালন করছ না কেন? তোমরা সফল হবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","তোমরা ঐ দেশে যেও না| প্রভু তোমাদের সঙ্গে নেই, এই কারণে শত্রুরা সহজেই তোমাদের পরাস্ত করতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","সেখানে তোমাদের বিরুদ্ধে অমালেকীয়রা এবং কনানীয়রা যুদ্ধ করবে| তোমরা প্রভুর পথ থেকে সরে এসেছো| সুতরাং তোমরা যখন তাদের সঙ্গে যুদ্ধ করবে তখন তিনি তোমাদের সঙ্গে থাকবেন না এবং তোমরা সকলেই যুদ্ধে মারা যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","কিন্তু লোকরা মোশিকে বিশ্বাস করে নি| তারা পর্বতের চূড়ার দিকে এগিয়ে গেল| কিন্তু প্রভুর সাক্ষ্যসিন্দুক এবং মোশি তাদের সঙ্গে যায় নি| ");
INSERT INTO ben2006_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","এরপর উঁচু পর্বতের ওপরে বসবাসকারী অমালেকীয়রা এবং কনানীয়েরা নীচে নেমে এসে তাদের উপর আঘাত হানল এবং খুব সহজেই তাদের পরাস্ত করে হর্মা পর্যন্ত সমস্ত রাস্তা তাড়া করল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ইস্রায়েলের লোকদের সঙ্গে কথা বলো এবং তাদের বলো: আমি তোমাদের একটি দেশ দিচ্ছি যা তোমাদের বাসভূমি হবে| যখন তোমরা সেই দেশে প্রবেশ করবে, ");
INSERT INTO ben2006_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","তখন তোমরা অবশ্যই প্রভুকে আগুনে তৈরী এক বিশেষ নৈবেদ্য প্রদান করবে| তার সুগন্ধ প্রভুকে খুশী করবে| তোমরা হোমবলি নৈবেদ্য, বিশেষ প্রতিশ্রুতি, বিশেষ উপহার, মঙ্গল নৈবেদ্য, বিশেষ ছুটির জন্য তোমাদের গোরু, মেষ এবং ছাগল ব্যবহার করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“উপহার উৎসর্গকারী ব্যক্তি সেই স্থানে প্রভুকে দেবার জন্য যেন শস্য নৈবেদ্যও নিয়ে আসে| এই শস্যের নৈবেদ্য হবে 1 কোয়ার্ট অলিভ তেল মিশ্রিত 8 কাপ মিহি ময়দা| ");
INSERT INTO ben2006_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","প্রত্যেক সময়ে হোমবলির জন্য একটি করে মেষশাবক নৈবেদ্য দেবে, এছাড়াও তুমি পেয় নৈবেদ্যর জন্য 1 কোয়ার্ট দ্রাক্ষারস উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“তুমি যদি মেষ দাও তাহলে তুমি অবশ্যই শস্যের নৈবেদ্যও তৈরী করবে| এই শস্যের নৈবেদ্য হবে 1-1/4 কোয়ার্ট অলিভ তেলে মিশ্রিত 16 কাপ মিহি ময়দা| ");
INSERT INTO ben2006_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","এবং তুমি অবশ্যই পেয় নৈবেদ্যর জন্য 1-1/4 কোয়ার্ট দ্রাক্ষারস উৎসর্গ করবে| এর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“তুমি হোমবলি, নৈবেদ্য, মঙ্গল নৈবেদ্য অথবা প্রভুর কাছে বিশেষ প্রতিশ্রুতি রক্ষার্থে একটি অল্প বয়স্ক বৃষেরও ব্যবস্থা করতে পারো| ");
INSERT INTO ben2006_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ঐ সময় তুমি বৃষের সঙ্গে অবশ্যই শস্যের নৈবেদ্য নিয়ে আসবে| সেই শস্যের নৈবেদ্য হবে 2 কোয়ার্ট অলিভ তেলে মিশ্রিত 24 কাপ মিহি ময়দা| ");
INSERT INTO ben2006_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","এছাড়াও পেয় নৈবেদ্যর জন্য 2 কোয়ার্ট দ্রাক্ষারসও নিয়ে আসবে| এই নৈবেদ্য হবে আগুন দিয়ে তৈরী| এর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","প্রত্যেকটি বৃষ, মেষ, মেষশাবক অথবা ছাগল, যা তুমি প্রভুকে দিচ্ছো, তা এভাবেই তৈরী হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","তুমি যে পশুগুলো দিচ্ছো তার প্রত্যেকটির জন্যই এটি কোরো| ");
INSERT INTO ben2006_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“প্রভুকে খুশী করার জন্য ইস্রায়েলের প্রত্যেক নাগরিক এই পদ্ধতিতে আগুনের সাহায্যে তৈরী নৈবেদ্য প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","আর এখন থেকে বিদেশীরা যারা তোমাদের সঙ্গেই বাস করে, যদি তারা প্রভুকে খুশী করার জন্য আগুনের সাহায্যে তৈরী কোনো নৈবেদ্য প্রদান করে, তাহলে তারাও তোমাদের মতোই একই পদ্ধতি অনুসরণ করে সেই নৈবেদ্য প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","এই একই বিধি সকলের জন্য হবে, ইস্রায়েলের লোকদের জন্যে এবং তোমাদের মধ্যে বসবাসকারী বিদেশীদের জন্যেও| এই বিধি চিরকাল চলবে| তুমি এবং তোমাদের মধ্যে বসবাসকারী প্রত্যেকেই প্রভুর কাছে সমান| ");
INSERT INTO ben2006_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","এর অর্থ হল তোমরাও একই বিধি এবং নিয়ম অনুসরণ করবে| ঐ বিধি এবং নিয়ম তোমাদের জন্য এবং তোমাদের মধ্যে বসবাসকারী বিদেশীদের জন্যও প্রযোজ্য|” ");
INSERT INTO ben2006_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ইস্রায়েলের লোকদের এই কথাগুলো বলো: আমি তোমাদের অন্য দেশে নিয়ে যাচ্ছি| ");
INSERT INTO ben2006_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","তোমরা যখন সেই দেশে পৌঁছে সেই দেশের কোনো খাদ্য গ্রহণ করবে, তখন অবশ্যই প্রভুকে সেই খাদ্যের কিছু অংশ উপহার হিসাবে উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","তোমরা শস্য গুঁড়ো করে রুটির জন্য ময়দার তাল তৈরী করবে এবং সেই ময়দার তালের প্রথমটা প্রভুকে উপহার হিসেবে প্রদান করবে| শস্য মাড়ানোর জায়গা থেকে আনা শস্য যেভাবে উৎসর্গ করা হয় এটিও সেইভাবেই করো| ");
INSERT INTO ben2006_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","এই নিয়ম চিরকাল চলবে| তোমরা অবশ্যই ঐ ময়দার তালের প্রথমটা প্রভুকে উপহার হিসেবে প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“এখন তোমরা যদি কোনো ভুল করো এবং প্রভু মোশিকে যে আদেশ করেছেন তার কোনোটা পালন করতে ভুলে যাও, তাহলে তোমরা কি করবে? ");
INSERT INTO ben2006_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","প্রভু মোশির মাধ্যমে এই আদেশগুলো দিয়েছিলেন| যেদিন প্রভু এই আদেশগুলো দিয়েছিলেন সেদিন থেকেই আদেশগুলির কার্যকারিতা শুরু হয়েছিল এবং আদেশগুলি চিরকাল চলবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","সুতরাং যদি তোমরা কোন ভুল কর এবং এই আজ্ঞাগুলো পালন করতে ভুলে যাও তাহলে কি করবে? যদি ইস্রায়েলের সব লোকই ভুল করে, তাহলে সবাই একত্রে প্রভুকে একটি অল্পবয়সী বৃষ হোমবলির নৈবেদ্য হিসেবে প্রদান করবে| তার সুগন্ধ প্রভুকে খুশী করবে| এছাড়াও বৃষের সঙ্গে নৈবেদ্য হিসেবে দেবার জন্যে শস্য এবং পেয় নৈবেদ্য প্রদানের কথা মনে রাখবে| তোমরা অবশ্যই পাপের জন্য একটি পুরুষ ছাগলও নৈবেদ্য হিসেবে প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“এই ভাবে যাজক ইস্রায়েলের সমস্ত লোককে শুচি করবেন যেন তারা পাপের ক্ষমা লাভ করে কারণ তারা ভুল করে সেই কাজ করেছে| সুতরাং তারা যখন এ সম্বন্ধে জানতে পারল, তখনই তারা প্রভুর কাছে আগুনে তৈরী নৈবেদ্য এবং কৃত পাপের জন্য নৈবেদ্য আনল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ইস্রায়েলের সমস্ত লোক এবং তাদের সঙ্গে বসবাসকারী অন্যান্য সকলকেই ক্ষমা করে দেওয়া হবে| তাদের ক্ষমা করা হবে কারণ তারা ভুলবশতঃ ঐ কাজ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“কিন্তু যদি কেবলমাত্র একজন ব্যক্তি ভুল করে পাপ করে, তাহলে সে অবশ্যই একটি এক বছর বয়স্ক স্ত্রী ছাগল নিয়ে আসবে| সেই ছাগলটি হবে পাপের জন্য নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","সেই ব্যক্তিকে শুচি করার জন্য যাজক অবশ্যই প্রয়োজনীয় ব্যবস্থা নেবে| সেই ব্যক্তিটি ভুল করেছিল এবং প্রভুর সামনে পাপ করেছিল| যাজক সেই ব্যক্তির জন্য প্রায়শ্চিত্ত করলে তাকে ক্ষমা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","এই বিধিটি প্রত্যেকের জন্যই, যে ভুল করবে এবং যে পাপ করবে| ইস্রায়েলের পরিবারে জাত প্রত্যেকের জন্য এবং তোমাদের সঙ্গে বসবাসকারী বিদেশীদের জন্যও এই একই বিধি বলবৎ থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“কিন্তু যদি কোনো ব্যক্তি জেনেশুনে ভুল করে তাহলে সে প্রভুর বিরুদ্ধে গেছে| সেই ব্যক্তিকে অবশ্যই তার লোকদের কাছ থেকে পৃথক রাখা হবে| ইস্রায়েলের পরিবারে জাত কোনো ব্যক্তি অথবা তাদের সঙ্গে বসবাসকারী বিদেশীদের জন্যও এই একই নিয়ম| ");
INSERT INTO ben2006_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","সেই ব্যক্তি প্রভুর বাক্য অবজ্ঞা করেছে এবং সেই আজ্ঞা লঙঘন করেছে সুতরাং সে তোমার গোষ্ঠী থেকে আলাদা থাকবে| সেই ব্যক্তি দোষী এবং অবশ্যই শাস্তি পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ইস্রায়েলের লোকরা মরুভূমিতে থাকাকালীন একজনকে বিশ্রামবারে কাঠ জড়ো করতে দেখল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","যে লোকরা তাকে কাঠ জড়ো করতে দেখেছিল তারা তাকে মোশি এবং হারোণের কাছে নিয়ে এল এবং সমস্ত লোক চারদিকে একত্রিত হল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","তারা সেই লোকটিকে পাহারায় রাখল কারণ তারা জানতো না, তারা কিভাবে তাকে শাস্তি দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","তখন প্রভু মোশিকে বললেন, “লোকটিকে অবশ্যই মরতে হবে| শিবিরের বাইরে সমস্ত লোক তার ওপর পাথর ছুঁড়বে|” ");
INSERT INTO ben2006_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","এই কারণে লোকরা তাকে শিবিরের বাইরে নিয়ে গেল এবং তাকে পাথর মেরে হত্যা করল| প্রভু মোশিকে যেভাবে আজ্ঞা করেছিলেন, তারা ঠিক সেভাবেই এটি করল| ");
INSERT INTO ben2006_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ইস্রায়েলের লোকদের বলো তারা যেন সুতো দিয়ে ঝালর তৈরী করে তা কাপড়ের কোণে লাগায় এবং এখন থেকে বংশ পরম্পরায় তারা যেন এই নিয়ম পালন করে| এই গোছাগুলোর প্রত্যেকটিতে তারা যেন একটি করে নীল সুতো রাখে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","এই সুতোর গোছাগুলোর দিকে তাকালে তোমরা প্রভুর দেওয়া আজ্ঞাগুলো মনে করতে পারবে| আর তখনই আজ্ঞাগুলো তোমরা পালন করবে| আজ্ঞাগুলো ভুলে গিয়ে, তোমাদের শরীর ও চোখ যা চায়, তাই করে অবিশ্বস্ত হবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","আমার সব আজ্ঞাগুলো পালন করার কথা তোমরা মনে রাখবে| তাহলে তোমরা ঈশ্বরের দৃষ্টিতে পবিত্র হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","আমি প্রভু তোমাদের ঈশ্বর| আমিই সেই যিনি তোমাদের মিশর থেকে নিয়ে এসেছিলাম| তোমাদের প্রভু হওয়ার জন্যই আমি এটা করেছিলাম| আমিই প্রভু, তোমাদের ঈশ্বর|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","কোরহ, দাথন, অবীরাম এবং ওন মোশির বিরুদ্ধে গেল| (কোরহ ছিল ষিষ্হরের পুত্র| ষিষ্হর ছিল কহাতের পুত্র এবং কহাত্‌ ছিল লেবির পুত্র| দাথন এবং অবীরাম ছিল দুই ভাই এবং ইলীয়াবের পুত্র| ওন ছিল পেলতের পুত্র| দাথন, অবীরাম এবং ওন ছিলেন রূবেণের উত্তরপুরুষ|) ");
INSERT INTO ben2006_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ঐ চারজন ব্যক্তি ইস্রায়েলের অন্যান্য 250 জন পুরুষকে একত্রিত করে মোশির বিরুদ্ধে গেল| তারা ছিল লোকদের নির্বাচিত নেতা| সমস্ত লোক তাদের চিনত| ");
INSERT INTO ben2006_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","তারা মোশি এবং হারোণের বিরুদ্ধে কথা বলার জন্য একসাথে এল| তারা মোশি এবং হারোণকে বলল, “আপনি বড্ড বেশী বাড়াবাড়ি করছেন| ইস্রায়েলের সকল লোক পবিত্র এবং প্রভু এখনও তাদের মধ্যেই বাস করেন| প্রভুর অন্যান্য লোকদের থেকে আপনি নিজেকে অনেক বেশী গুরুত্বপূর্ণ করে তুলেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","মোশি এই কথা শুনে মাটিতে উপুড় হয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","আর সে কোরহ এবং তার অনুসরণকারীদের বলল, “আগামীকাল সকালে প্রভু দেখিয়ে দেবেন কোন্ ব্যক্তি প্রকৃতই তাঁর এবং কে প্রকৃতই পবিত্র| আর সেই ব্যক্তিকে প্রভু তাঁর কাছে নিয়ে আসবেন| প্রভু যাকে বেছে নেবেন তাকে তাঁর কাছে নিয়ে আসবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","সুতরাং কোরহ তুমি এবং তোমার অনুসরণকারী এই কাজ করবে: ");
INSERT INTO ben2006_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","আগামীকাল ধুনুচি নিয়ে তাতে সুগন্ধি ধূপধূনো রাখবে| তারপরে সেই ধুনুচিগুলো প্রভুর সামনে নিয়ে আসবে| প্রভু সেই ব্যক্তিকে বেছে নেবেন যে সত্যই পবিত্র| তোমরা লেবীয়রা অনেক দূরে চলে গেছো–তোমরা ভুল করছো|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","মোশি কোরহকে এও বলল, “লেবীয়রা দয়া করে আমার কথা শোন| ");
INSERT INTO ben2006_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","এটাই কি যথেষ্ট নয় যে ইস্রায়েলের ঈশ্বর তোমাদের ইস্রায়েলের মণ্ডলী থেকে আলাদা করে প্রভুর পবিত্র তাঁবুর সেবা করার জন্য এবং মণ্ডলীর সামনে দাঁড়িয়ে তাঁর সেবা করার জন্য তোমাদের তাঁর কাছে নিয়ে এসেছেন? ");
INSERT INTO ben2006_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","যাজকদের কাজে সাহায্য করার জন্য ঈশ্বর তোমাদের অর্থাৎ‌ লেবীয় গোষ্ঠীভুক্ত লোকদের নিয়ে এসেছিলেন| কিন্তু তোমরা এখন যাজক হওয়ার চেষ্টা করছো| ");
INSERT INTO ben2006_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","তুমি এবং তোমার অনুসরণকারীরা একত্রিত হয়ে প্রভুর বিরোধিতা করেছো| হারোণ কি কোনো ভুল কাজ করেছে যে তাঁর বিরুদ্ধে তোমরা অভিযোগ করছো?” ");
INSERT INTO ben2006_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","এরপর মোশি ইলীয়াবের পুত্র দাথন এবং অবীরামকে ডাকল| কিন্তু ঐ দুই ব্যক্তি বললেন, “আমরা যাবো না| ");
INSERT INTO ben2006_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","এটাই কি যথেষ্ট নয় যে আপনি উত্তম জিনিসে পরিপূর্ণ শস্য শ্যামলা দেশ থেকে আমাদের নিয়ে এসেছেন যাতে মরুভূমিতে হত্যা করতে পারেন? আর এখন আপনি আমাদের উপর কর্তৃত্ত্বও করবেন? ");
INSERT INTO ben2006_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","আমরা কেন আপনাকে অনুসরণ করবো? উত্তম জিনিসে পরিপূর্ণ এমন কোনো দেশে তো আপনি আমাদের নিয়ে আসেন নি| আপনি আমাদের ঈশ্বরের শপথ করা সেই দেশও দেন নি এবং আমাদের চারণভূমি অথবা দ্রাক্ষাক্ষেতও দেন নি| আপনি কি এই সব লোকদের ক্রীতদাস করবেন? না, আমরা আসবো না|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","এই কারণে মোশি খুবই ক্রুদ্ধ হল| সে প্রভুকে বলল, “আমি এইসকল লোকদের সঙ্গে কোনোদিন কোন অন্যায় করি নি| আমি কোনো সময়েই তাদের কাছ থেকে কোনো কিছুই নিই নি, একটি গাধা পর্যন্ত নয়| প্রভু আপনি এদের উপহার গ্রহণ করবেন না!” ");
INSERT INTO ben2006_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","এরপর মোশি কোরহকে বলল, “আগামীকাল তুমি এবং তোমার অনুসরণকারীরা প্রভুর সামনে দাঁড়াবে| সেখানে হারোণ, তুমি ও তোমার লোকরা থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","তোমরা প্রত্যেকে একটি করে ধুনুচি এনে তাতে সুগন্ধি ধূপধূনো রাখবে এবং তা ঈশ্বরকে প্রদান করবে| সেখানে নেতাদের জন্য 250 টি ধুনুচি থাকবে এবং একটি পাত্র তোমার জন্য ও একটি পাত্র হারোণের জন্য থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","সুতরাং প্রত্যেকে একটি ধুনুচি নিয়ে তার ওপর জ্বলন্ত কয়লা ও সুগন্ধি ধূপধূনো রাখল| এরপর তারা মোশি ও হারোণের সাথে সামগম তাঁবুর প্রবেশপথে গিয়ে দাঁড়ালো| ");
INSERT INTO ben2006_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","কোরহও সমাগম তাঁবুর প্রবেশপথে তাদের বিরুদ্ধে সমস্ত লোককে জড়ো করেছিল| এর ঠিক পর সেই জায়গায় সকলের সামনে প্রভুর মহিমা প্রকাশিত হল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","প্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“এই সকল লোকদের থেকে দূরে সরে যাও| আমি এখনই তাদের ধ্বংস করতে চাই|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","কিন্তু মোশি এবং হারোণ মাটিতে নতজানু হয়ে অনুনয় করে বলল, “হে ঈশ্বর, আপনি জানেন লোকরা তাদের মনে কি ভাবছে| একজন পাপ করলে কি আপনি সমস্ত মণ্ডলীর প্রতি ক্রুদ্ধ হবেন?” ");
INSERT INTO ben2006_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","তখন প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“কোরহ, দাথন এবং অবীরামের তাঁবু থেকে লোকদের সরে যেতে বলো|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","মোশি উঠে দাঁড়াল এবং দাথন ও অবীরামের কাছে গেল| ইস্রায়েলের সকল প্রবীণরা (নেতারা) তাঁকে অনুসরণ করল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","মোশি লোকদের সাবধান করে দিয়ে বলল, “এই সকল মন্দ লোকদের তাঁবু থেকে সরে যাও| তাদের কোনো জিনিস স্পর্শ কোরো না| যদি তোমরা সেটা করো, তাহলে তাদের পাপের জন্য তোমরা ধ্বংস হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","সেই কারণে কোরহ, দাথন এবং অবীরামের তাঁবু থেকে লোকরা সরে গেল| আর দাথন এবং অবীরাম বাইরে এসে তাদের স্ত্রীদের সন্তানদের এবং ছোটো শিশুদের নিয়ে তাঁবুর প্রবেশ পথে দাঁড়িয়ে রইল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","তখন মোশি বলল, “আমি তোমাদের প্রমাণ করে দেখাবো যে প্রভুই আমাকে এইসব কাজ করার জন্য পাঠিয়েছেন এবং আমি এসব নিজের ইচ্ছানুসারে করিনি| ");
INSERT INTO ben2006_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","এই লোকরা এখানে মারা যাবে| কিন্তু তারা যদি স্বাভাবিবকিভাবে মারা যায়, যেভাবে লোকরা সবসময় মারা যায় তাহলে তা প্রমাণ করবে যে, প্রভু আমাকে প্রকৃতই পাঠান নি| ");
INSERT INTO ben2006_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","কিন্তু যদি প্রভু এই লোকদের মৃত্যু একটু ভিন্নভাবে ঘটান অর্থাৎ‌ একটু নতুনভাবে তাহলে তোমরা জানবে যে এই লোকরা সত্যই প্রভুকে অবজ্ঞা করেছিল| এটাই হল প্রমাণ: ধরনী বিদীর্ণ হয়ে যাবে এবং এই সমস্ত লোককে গ্রাস করবে| তারা জীবিতাবস্থায় তাদের কবরে নেমে যাবে| এবং এই সব লোকদের অধিকৃত যাবতীয় জিনিসপত্র তাদের সঙ্গেই তলিযে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","যখন মোশি এই কথাগুলো বলা শেষ করল, লোকদের পায়ের তলার মাটি ফেটে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","মনে হল যেন পৃথিবী তার মুখটি খুলে তাদের গ্রাস করল| কোরহের সমস্ত লোকরা, তাদের পরিবার এবং তাদের অধিকৃত যাবতীয় দ্রব্যসামগ্রী পৃথিবীর নীচে চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ঐসব লোকরা জীবন্ত অবস্থাতেই তাদের কবরে গেল| তাদের অধিকৃত সকল দ্রব্যসামগ্রীও তাদের সঙ্গে মাটির তলায় চলে গেল| এরপর পৃথিবী তাদের ওপরে মুখ বন্ধ করল| তারা বিনষ্ট হল এবং সমাজ থেকে চিরকালের জন্যই চলে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ইস্রায়েলের লোকরা এই মরনোন্মুখ মানুষগুলোর আর্তনাদ শুনতে পেল| সেই কারণে তারা বিভিন্ন দিকে ছুটে পালাতে পালাতে বলল, “পৃথিবী আমাদেরও গ্রাস করবে!” ");
INSERT INTO ben2006_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","এরপর প্রভুর কাছ থেকে এক আগুন এসে যারা সুগন্ধি ধূপধূনোর নৈবেদ্য প্রদান করছিল, সেই 250 জন পুরুষকে ধ্বংস করল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“যাজক হারোণের পুত্র ইলীয়াসরকে বলো, যে আগুন এখনও শিখাহীন হয়ে জ্বলছে তার থেকে সমস্ত সুগন্ধি ধূপধূনোর পাত্রগুলো নিয়ে এসো| এই সুগন্ধি ধূপধূনোর পাত্রগুলি এখন পবিত্র| পাত্রগুলো পবিত্র কারণ তারা এই পাত্রগুলো ঈশ্বরকে প্রদান করেছিল| তাদের ধুনুচিগুলো নিয়ে হাতুড়ির সাহায্যে সমতল পাতে পরিণত কর| এরপর এই ধাতব চাদরটি বেদীর আচ্ছাদনের কাজে ব্যবহার করো| ইস্রায়েলের লোকদের জন্য এটি চিহ্ন, যাতে তারা সতর্ক হয়|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","সুতরাং যাজক ইলীয়াসর পিতলের তৈরী সেই ধুনুচিগুলো নিলেন| যারা মারা গিয়েছিল তারাই ঐ পাত্রগুলো এনেছিল| আর তারা তা পিটিয়ে বেদীকে ঢাকবার জন্য পাত প্রস্তুত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","মোশির মাধ্যমে প্রভু যে ভাবে আজ্ঞা দিয়েছিলেন, তিনি ঠিক সেভাবেই তা করলেন| এটি এমন একটি চিহ্নস্বরূপ হল যা ইস্রায়েলের লোকদের মনে রাখতে সাহায্য করবে যে কেবলমাত্র হারোণের পরিবারের কোনো ব্যক্তিই প্রভুর সামনে সুগন্ধি ধূপধূনো উৎসর্গ করতে পারে| এছাড়া অন্য কোনো ব্যক্তি যদি প্রভুকে সুগন্ধি ধূপধূনোর নৈবেদ্য প্রদান করেন তাহলে সেও কোরহ এবং তার অনুসরণকারীদের মতোই মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","পরদিন ইস্রায়েলের সমস্ত লোকরা মোশি এবং হারোণের বিরুদ্ধে অভিযোগ করে বলল, “আপনারা প্রভুর লোকদের হত্যা করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","আর ইস্রায়েলের লোকরা মোশি ও হারোণের বিরুদ্ধে একত্র হয়ে যখন সমাগম তাঁবুর দিকে তাকাল, তখন দেখল মেঘ সেটিকে ঢেকে দিয়েছে এবং সেখানে ঈশ্বরের মহিমা প্রকাশিত হচ্ছে| ");
INSERT INTO ben2006_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","তারপর মোশি এবং হারোণ সমাগম তাঁবুর সামনে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ঐ লোকদের থেকে দূরে সরে যাও, যাতে আমি এখনই তাদের ধ্বংস করতে পারি|” তাতে মোশি এবং হারোণ মাটিতে উপুড় হয়ে পড়ল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","তখন মোশি হারোণকে বলল, “ধুনুচি নিয়ে তাতে বেদী থেকে আগুন নিয়ে রাখো| এরপর এতে সুগন্ধি ধূপধূনো দাও এবং ঐ লোকদের কাছে তাড়াতাড়ি গিয়ে তাদের পবিত্র করো| কারণ প্রভু তাদের প্রতি খুবই ক্রুদ্ধ হয়ে আছেন| ইতিমধ্যেই রোগ ছড়াতে শুরু করেছে|” ");
INSERT INTO ben2006_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","48","সুতরাং হারোণ মোশির কথামতো কাজ করল| হারোণ সুগন্ধি ধূপধূনো ও আগুন এনে লোকদের মাঝখানে দৌড়ে গেল| কিন্তু লোকদের মধ্যে এর মধ্যেই অসুস্থতা শুরু হয়ে গিয়েছিল| এই কারণে হারোণ মৃত লোক এবং যারা জীবিত আছে তাদের মাঝখানে গিয়ে দাঁড়াল| লোকদের শুচি করার জন্যে যা দরকার হারোণ ঠিক তাই করল এবং তাদের অসুস্থতা আর বাড়ল না| ");
INSERT INTO ben2006_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","কোরহের কারণে যাদের মৃত্যু হয়েছিল তাদের ছাড়াও আরও 14,700 জন লোক অসুস্থতার জন্য মারা গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","সুতরাং ঐ ভয়ঙ্কর অসুস্থতা আর এগোলো না এবং পরে হারোণ পবিত্র তাঁবুর প্রবেশপথে মোশির কাছে গিয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ইস্রায়েলের লোকদের সঙ্গে কথা বলো| বারোটি পরিবারগোষ্ঠীর প্রত্যেকটির নেতার কাছ থেকে একটি করে মোট বারোটি হাঁটার লাঠি বা ছড়ি নিয়ে এসো| প্রত্যেক ব্যক্তির নাম তার লাঠির ওপরে লেখো| ");
INSERT INTO ben2006_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","লেবি গোষ্ঠীর লাঠির ওপরে হারোণের নাম লেখ| বারোটি পরিবারগোষ্ঠীর প্রত্যেকটির নেতার জন্য অবশ্যই একটি করে লাঠি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","এই লাঠিগুলোকে সাক্ষ্যসিন্দুকের সামনে সমাগম তাঁবুতে রাখো| এটাই সেই জায়গা যেখানে আমি তোমার সঙ্গে দেখা করি| ");
INSERT INTO ben2006_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","সত্যিকারের যাজক হওয়ার জন্য আমি একজনকে মনোনীত করব| আমি যে ব্যক্তিকে মনোনীত করব তার হাঁটার লাঠিতে নতুন পাতা গজাতে শুরু করবে| এই ভাবে আমি তোমার এবং আমার বিরুদ্ধে লোকদের অভিযোগ করা বন্ধ করে দেবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","সুতরাং মোশি ইস্রায়েলের লোকদের সঙ্গে কথা বলল| নেতারা প্রত্যেকেই তাকে লাঠি দিলেন| সেখানে মোট বারোটি লাঠি হল| প্রত্যেক পরিবারগোষ্ঠীর প্রত্যেক নেতার কাছ থেকে পাওয়া একটি করে লাঠি সেখানে ছিল| লাঠিগুলোর মধ্যে একটি ছিল হারোণের| ");
INSERT INTO ben2006_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","চুক্তির তাঁবুতে প্রভুর সামনে মোশি লাঠিগুলো রেখে দিল| ");
INSERT INTO ben2006_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","পরদিন মোশি তাঁবুতে প্রবেশ করে হারোণের লাঠিটি দেখল| লেবি পরিবারের কাছ থেকে পাওয়া এই লাঠিই ছিল একমাত্র লাঠি যাতে নতুন পাতা গজিয়েছিল| সেই লাঠিটিতে শাখা প্রশাখা গজিয়েছিল এবং বাদামও ফলেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","সেই কারণে মোশি প্রভুর সেই স্থান থেকে সমস্ত লাঠিগুলো নিয়ে এল| মোশি ইস্রায়েলের লোকদের সেই লাঠিগুলো দেখালেন| তারা সকলেই লাঠিগুলো দেখল এবং প্রত্যেক ব্যক্তি তাদের লাঠিগুলো ফিরিয়ে নিয়ে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","তখন প্রভু মোশিকে বললেন, “চুক্তি সিন্দুকের সামনে পবিত্র তাঁবুর ভেতরে পেছনদিকে হারোণের লাঠিটিকে রাখো| এই যে সব লোক, যারা সব সময়েই আমার বিরোধিতা করে তাদের জন্য এটি একটি সতর্কীকরণ| এতে আমার বিরুদ্ধে অভিযোগ করা বন্ধ হয়ে যাবে যার ফলে আমি তাদের ধ্বংস করব না|” ");
INSERT INTO ben2006_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","সুতরাং মোশি প্রভুর আজ্ঞা অনুসারেই কাজ করল| ");
INSERT INTO ben2006_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ইস্রায়েলের লোকরা মোশিকে বলল, “দেখ, আমরা মারা পড়তে বসেছি| আমরা শেষ হয়ে যাব| আমরা সকলেই ধ্বংস হয়ে যাব| ");
INSERT INTO ben2006_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","যে কোনোও ব্যক্তি প্রভুর পবিত্র তাঁবুর কাছে আসে সে মারা যায়| তবে কি আমরা সকলেই মারা যাবো?” ");
INSERT INTO ben2006_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","প্রভু হারোণকে বললেন, “পবিত্র স্থানের বিরুদ্ধে যে কোনোরকম ভুল কাজের জন্য তুমি, তোমার পুত্ররা এবং তোমার পিতার পরিবারের সকল ব্যক্তি দায়ী থাকবে| যাজকগণের বিরুদ্ধে যে কোনোরকম ভুল কাজের জন্যে তুমি এবং তোমার পুত্ররা দায়ী থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","তুমি তোমার পরিবারগোষ্ঠী থেকে অন্যান্য লেবীয় লোকদেরও নিয়ে এসো যাতে তারা তোমার সাথে যোগ দিতে পারে| তুমি তোমার পুত্রদের সাথে যখন চুক্তির সিন্দুকের সাক্ষাতে উপস্থিত থাকবে তখন তারা তোমাদের সাহায্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","লেবি পরিবার থেকে আসা ঐসব লোকরা তোমার অধীনে থাকবে| পবিত্র তাঁবুতে প্রয়োজনীয় সব কাজই তারা করবে| কিন্তু তারা কোনো সময়েই পবিত্র স্থানের দ্রব্যসামগ্রীর কাছে অথবা বেদীর কাছে যাবে না| যদি তারা সেটা করে, তাহলে তারা মারা যাবে এবং তুমিও মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","তারা তোমাকে সঙ্গ দেবে এবং তোমার সঙ্গে কাজ করবে| সমাগম তাঁবুর তত্ত্বাবধানের জন্য তারা দায়ী থাকবে| পবিত্র তাঁবুতে অবশ্য করণীয় কাজগুলো তারা করবে| এ ছাড়া অন্য কেউই ঐ জায়গায় আসতে পারবে না যেখানে তুমি আছো| ");
INSERT INTO ben2006_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“পবিত্র স্থান এবং বেদীর তত্ত্বাবধান করার জন্য তুমি দায়বদ্ধ কারণ আমি ইস্রায়েলের লোকদের ওপরে আর ক্রুদ্ধ হতে চাই না| ");
INSERT INTO ben2006_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ইস্রায়েলের লোকদের মধ্য থেকে আমি নিজে একমাত্র লেবীয় গোষ্ঠীভুক্তদেরই বেছে নিয়েছি| তারা তোমাদের কাছে উপহারস্বরূপ প্রভুর সেবা করার জন্য এবং সমাগম তাঁবুতে কাজ করার জন্য আমি তোমাদের কাছে তাদের দিয়েছি| ");
INSERT INTO ben2006_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","কিন্তু হারোণ, কেবলমাত্র তুমি এবং তোমার পুত্ররাই যাজক হিসাবে সেবা করতে পারো| কেবলমাত্র তুমিই বেদীর কাছে যেতে পারো| পবিত্রতম স্থানের পর্দার অভ্যন্তরে একমাত্র তুমিই প্রবেশ করতে পারো| আমি দানরূপে যাজকত্ব পদ তোমাদের দিয়েছি| অন্য যে কেউই আমার পবিত্র স্থানের কাছে আসবে তাকে অবশ্যই হত্যা করা হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","এরপর প্রভু হারোণকে বললেন, “দেখ ইস্রায়েলের লোকরা আমাকে যে বিশেষ উপহারগুলো দিয়েছে, তার রক্ষণাবেক্ষণের দায়িত্ব আমি নিজেই তোমাকে দিয়েছি| আমি তোমাকে সব পবিত্র উপহারসামগ্রী দেব যা ইস্রায়েলীয়রা আমাকে দেয়| তুমি এবং তোমার পুত্ররা এইসব উপহার সামগ্রী ভাগ করে নেবে| সেগুলো চিরকাল তোমাদেরই থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","লোকরা উৎসর্গের জন্য জিনিসপত্র, শস্য নৈবেদ্য, পাপার্থক বলি এবং দোষার্থক বলির নৈবেদ্য নিয়ে আসবে| ঐসব নৈবেদ্য সব থেকে পবিত্র| সব থেকে পবিত্র নৈবেদ্য যে অংশ পোড়ানো হয় নি, সেখান থেকেই তোমার অংশ আসবে| ঐসব দ্রব্যসামগ্রী তোমার এবং তোমার পুত্রদের জন্য| ");
INSERT INTO ben2006_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","কেবলমাত্র অতি পবিত্র স্থানে তোমরা ঐসব দ্রব্য সামগ্রী ভক্ষণ কোরো| তোমার পরিবারের প্রত্যেক পুরুষ ঐসব দ্রব্যসামগ্রী খেতে পারবে, কিন্তু তুমি অবশ্যই মনে রাখবে যে, ঐসব নৈবেদ্যগুলো পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“এবং ইস্রায়েলের লোকরা দোলনীয় নৈবেদ্য স্বরূপ যে সব উপহারসামগ্রী আমাকে দেয়, সেগুলোও তোমাদের| আমি তোমাকে, তোমার পুত্রদের এবং তোমার কন্যাদের এগুলো দিলাম| এটি তোমার অংশ| তোমার পরিবারের প্রত্যেক ব্যক্তি, যে শুচি সে এগুলো খেতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“তাদের ক্ষেতে উৎপন্ন প্রথম সবচেয়ে উৎকৃষ্ট অলিভ তেল, নতুন দ্রাক্ষারস, শস্য যা তারা আমার উদ্দেশ্যে উৎসর্গ করে তা আমি তোমাদের দিলাম| ");
INSERT INTO ben2006_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","দেশের সমস্ত প্রথম ফসল যা তারা প্রভুর উদ্দেশ্যে নিয়ে আসে তা তোমাদের হবে| তোমার পরিবারের প্রত্যেক ব্যক্তি, যে শুচি সে এটি খেতে পারবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ইস্রায়েলে যে সকল দ্রব্যসামগ্রী প্রভুকে দেওয়া হবে সেগুলো তোমারই| ");
INSERT INTO ben2006_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“স্ত্রীলোকের প্রথম সন্তান এবং পশুর প্রথম সন্তান অবশ্যই প্রভুকে দান করতে হবে| সেই সন্তান তোমার হবে| যদি প্রথমজাত পশুটি অশুচি হয় তাহলে সেটিকে ফেরত নিয়ে যাওয়া হবে| যদি নৈবেদ্যটি শিশু হয়, তাহলে সেই শিশুটিকে অবশ্যই ফেরত নিয়ে আসতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","যখন শিশুটির বয়স এক মাস, তখন তারা অবশ্যই তার দাম দেবে| খরচ হবে 2 আউন্স রূপো| তুমি অবশ্যই সরকারী মাপকাঠি অনুযায়ী রূপো ওজন করবে| সরকারী মাপকাঠি অনুসারে এক শেকল হল 20 জিরাহ| ");
INSERT INTO ben2006_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“কিন্তু তুমি প্রথমজাত গোরু মেষ অথবা ছাগলের মুক্তির জন্য কোনো মূল্য দেবে না| ঐ পশুরা পবিত্র। বেদীর ওপরে তাদের রক্ত ছিটিয়ে দাও এবং তাদের চর্বি পোড়াও| এই নৈবেদ্য আগুনের সাহায্যে তৈরী| এর সুগন্ধ প্রভুকে খুশী করে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","কিন্তু ঐসব পশুর মাংস তোমার| যেমন দোলনীয় নৈবেদ্যর বক্ষঃস্থল এবং অন্যান্য নৈবেদ্যর দক্ষিণ উরু তোমার| ");
INSERT INTO ben2006_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","লোকরা পবিত্র উপহারস্বরূপ যে সব দ্রব্যসামগ্রী প্রদান করে, আমি প্রভু হিসাবে সে সবই তোমাকে দিলাম| এটি তোমার প্রাপ্য অংশ| আমি এইগুলো তোমাকে, তোমার পুত্রদের এবং তোমার কন্যাদের দিলাম| এই বিধি চিরকাল চলবে| এটি প্রভুর সঙ্গে একটি চুক্তি, যা কোনো সময়ই ভঙ্গ করা যাবে না| আমি তোমার কাছে এবং তোমার উত্তরপুরুষদের কাছে এই প্রতিশ্রুতি করলাম|” ");
INSERT INTO ben2006_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","প্রভু হারোণকে এও বললেন, “তুমি জমির কোনো অংশই পাবে না| অন্যান্য লোকরা যা অধিকারভুক্ত করে থাকে এমন কোনো কিছুই তুমি অধিকারভুক্ত করতে পারবে না| আমি, প্রভু তোমারই হবো| ইস্রায়েলের লোকরা সেই দেশ পাবে যা আমি তাদের কাছে প্রতিশ্রুতি করেছিলাম| কিন্তু আমিই তোমার অংশ ও অধিকার| ");
INSERT INTO ben2006_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ইস্রায়েলের লোকরা তাদের যা কিছু আছে তার এক দশমাংশ আমাকে দেবে| সুতরাং সেই এক দশমাংশ আমি লেবির সকল উত্তরপুরুষদের দিয়ে দিচ্ছি| সমাগম তাঁবুতে তারা যে সেবাকার্য করেছে তার জন্য এটি তাদের পারিশ্রমিক| ");
INSERT INTO ben2006_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","কিন্তু এখন থেকে সমাগম তাঁবুর কাছে ইস্রায়েলের অন্যান্য লোকরা অবশ্যই যাবে না| যদি তারা সেটা করে, তবে তাদের অবশ্যই মৃত্যুদণ্ড দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","লেবীয় গোষ্ঠীভুক্ত লোকরা, যারা সমাগম তাঁবুতে কাজ করে তারা এর বিরুদ্ধে যে কোনোরকম পাপ কাজের জন্যে দায়ী| এটিই বিধি| এইটিই চিরকাল চলবে| আর এই লেবীয় গোষ্ঠীভুক্ত লোকরা ইস্রায়েলের লোকদের মধ্যে কোনো দেশই পাবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","কিন্তু ইস্রায়েলের লোকরা তাদের যা কিছু আছে তার সব কিছুর এক দশমাংশ আমাকে দেবে| এবং আমি সেই এক দশমাংশ লেবীয় গোষ্ঠীভুক্ত লোকদের দেবো| সেই কারণেই লেবীয় গোষ্ঠীভুক্ত লোকদের সম্পর্কে এই কথাগুলো আমি বলেছিলাম: ঐসব লোকরা কোনো দেশ পাবে না যা আমি ইস্রায়েলের অন্যান্য লোকদের কাছে প্রতিশ্রুতি করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“লেবীয় গোষ্ঠীভুক্ত লোকদের বলো, ইস্রায়েলের লোকরা, তাদের অধিকারে যা আছে, তার সবকিছুর এক দশমাংশ প্রভুকে দেবে| সেই এক দশমাংশ লেবীয় গোষ্ঠীভুক্ত লোকদের হবে| কিন্তু তোমরা অবশ্যই তার এক দশমাংশ প্রভুকে তাঁর নৈবেদ্য স্বরূপ প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ফসল কাটার পর যেমন শস্য এবং যন্ত্রের সাহায্যে দ্রাক্ষার রস বার করা হয় সেই রকমভাবে তোমার দাম তোমার পক্ষে গণনা করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","এইভাবে ইস্রায়েলের অন্যান্য লোকদের মতো, তোমরাও প্রভুকে তোমাদের নৈবেদ্য প্রদান করবে| ইস্রায়েলের লোকরা প্রভুকে যা দেন সেই এক দশমাংশ তুমি পাবে| এবং তারপর তুমি যাজক হারোণকে তার এক দশমাংশ দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","যখন ইস্রায়েলের লোকরা তাদের অধিকারভুক্ত সবকিছুর এক দশমাংশ তোমাকে দেবে, তখন তুমি অবশ্যই তার মধ্য থেকে সর্বাপেক্ষা উৎকৃষ্ট এবং পবিত্রতম অংশটি বেছে নেবে| ঐটিই সেই এক দশমাংশ যা তুমি অবশ্যই প্রভুকে প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“সুতরাং লেবীয় গোষ্ঠীভুক্ত লোকদের বলো, “ইস্রায়েলের লোকরা ফসল কাটার পরে শস্যের এবং দ্রাক্ষারসের এক দশমাংশ তোমাদের দেবে| এরপর তোমরা তার থেকে সর্বাপেক্ষা উৎকৃষ্ট অংশটি প্রভুকে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","বাকী অংশটি তুমি এবং তোমার পরিবারের সদস্যরা খেতে পারবে| সমাগম তাঁবুতে তুমি যে কাজ করো তার জন্য এটি তোমার পারিশ্রমিক| ");
INSERT INTO ben2006_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","এবং যদি তুমি সব সময়ই সব থেকে উৎকৃষ্ট অংশটি প্রভুকে দিয়ে দাও, তাহলে তুমি কোনো সময়ই দোষী হবে না| তুমি ইস্রায়েলের লোকদের দেওয়া পবিত্র উপহারসামগ্রী কখনও অপবিত্র কোরো না, তাহলে তুমি মারা যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","প্রভু, মোশি এবং হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ইস্রায়েলের লোকদের ঈশ্বর যে শিক্ষা দিয়েছিলেন, তার থেকেই আসছে এই বিধিগুলি| ইস্রায়েলের লোকদের বলো তারা যেন তোমাদের কাছে একটি নিখুঁত লাল গোরু নিয়ে আসে| গোরুটির শরীরে যেন অবশ্যই কোনো রকম আঘাতের চিহ্ন না থাকে এবং সেটি যেন কোনোদিন জোয়াল না বয়ে থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","সেই গোরুটিকে যাজক ইলীয়াসরের কাছে দিয়ে দাও| ইলীয়াসর সেই গোরুটিকে শিবিরের বাইরে নিয়ে যাবে এবং সেখানে এটি হত্যা করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","তখন যাজক ইলীয়াসর কিছুটা রক্ত তার আঙুলে নিয়ে তা পবিত্র তাঁবুর দিকে সাতবার ছিটিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","এরপর গোটা গোরুটিকে তার সামনে পোড়ানো হবে| গোরুটির চামড়া, মাংস, রক্ত এবং অন্ত্র সম্পূর্ণরূপে পোড়াতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","এরপর যাজক একটি এরস কাঠের কাঠি, একটি এসোব এবং কিছু লাল সুতো নেবে| যেখানে গোরুটি পুড়ছে সেই আগুনে ঐসব দ্রব্যসামগ্রী ছুঁড়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","এরপর যাজক স্নান করবে এবং নিজের বস্ত্রাদি জলে ধুয়ে ফেলবে| এরপর সে শিবিরে ফিরে আসতে পারবে| যাজক সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","যে ব্যক্তি গোরুটি পুড়িয়েছে সেও স্নান করবে এবং নিজের বস্ত্রাদি জলে ধুয়ে ফেলবে| সেও সন্ধ্যা পর্যন্ত অপবিত্র থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“এরপর একজন শুচি ব্যক্তি সেই গোরুর ছাই সংগ্রহ করবে| সে শিবিরের বাইরে পরিষ্কার জায়গায় সেই ছাই রাখবে| যখন লোকরা শুচি হওয়ার জন্য এক বিশেষ অনুষ্ঠানের আয়োজন করবে, সে সময় এই ছাই ব্যবহৃত হবে| কোনো ব্যক্তির পাপ দূরীকরণের জন্যও এই ছাই ব্যবহৃত হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“যে ব্যক্তি গোরুর ছাই সংগ্রহ করেছিল সে অবশ্যই তার বস্ত্রাদি ধুয়ে ফেলবে| সেও সন্ধ্যা পর্যন্ত অশুচি থাকবে| “এই নিয়ম চিরকাল চলবে| ইস্রায়েলের নাগরিকদের জন্য এই নিয়ম এবং তোমাদের সঙ্গে যে বিদেশীরা বাস করছে তাদের জন্যেও এই একই নিয়ম বলবৎ থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","যদি কোনো ব্যক্তি কোনো মৃতদেহ স্পর্শ করে, তাহলে সে সাতদিন পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","সে অবশ্যই তৃতীয় দিনে এবং পুনরায় সপ্তম দিনে বিশেষ জলে নিজেকে পরিষ্কার করবে| যদি সে তা না করে, তাহলে সে অশুচিই থেকে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","যদি একজন ব্যক্তি কোনো মৃতদেহ স্পর্শ করে তবে সেই ব্যক্তি অশুচি| যদি সেই ব্যক্তি নিজেকে শুচি না করে পবিত্র তাঁবুতে যায়, তাহলে সেই তাঁবুটিও অশুচি হয়ে যাবে| সুতরাং সেই ব্যক্তিকে অবশ্যই ইস্রায়েলের অন্যান্য লোকদের থেকে পৃথক করে রাখা হবে| যদি কোনো অশুচি ব্যক্তির ওপরে পবিত্র জল ঢেলে না দেওয়া হয়, তাহলে সেই ব্যক্তি অশুচিই থেকে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“এই নিয়ম মানতে হবে যখন তারা তাদের তাঁবুতে মারা যায়| যদি কোনো ব্যক্তি তার তাঁবুতে মারা যায় তাহলে তাঁবুর প্রত্যেক ব্যক্তি অশুচি হবে| তারা সাতদিনের জন্য অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","এবং ঢাকা না দেওয়া প্রত্যেকটি বযাম অথবা পাত্র অশুচি হয়ে যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","যদি কোনো ব্যক্তি মৃতদেহ স্পর্শ করে, তাহলে সেই ব্যক্তি সাতদিন অশুচি থাকবে| মৃতদেহটি যদি বাইরে মাঠে থাকে অথবা সেই ব্যক্তি যদি যুদ্ধে মারা গিয়ে থাকে তাহলেও এটি প্রযোজ্য| এছাড়াও যদি কোন ব্যক্তি মৃত ব্যক্তির হাড় স্পর্শ করে, তাহলে সেই ব্যক্তি সাতদিনের জন্য অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“সুতরাং সেই ব্যক্তিকে আবার শুচি করার জন্যে তুমি অবশ্যই পোড়ানো গোরুর ছাই ব্যবহার করবে| একটি বয়ামের মধ্যেকার ছাইয়ের ওপর দিয়ে টাটকা স্রোতের জল ভরো| ");
INSERT INTO ben2006_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","একজন শুচি ব্যক্তি একটি এসোব নিয়ে সেটিকে জলে ডোবাবে| এরপর সে এটিকে তাঁবুর ওপর, তাঁবুর পাত্রগুলিতে এবং তাঁবুতে যে সব লোকরা আছে তাদের ওপরে ছিটিয়ে দেবে| যে কেউই মৃত ব্যক্তির শরীর স্পর্শ করে তার প্রতি তুমি অবশ্যই এটি করবে| যে কেউ যুদ্ধে মৃত কোনো ব্যক্তির শরীর স্পর্শ বা কোনো মৃত ব্যক্তির হাড় স্পর্শ করে তাদের ক্ষেত্রেও তুমি অবশ্যই এটি করো| ");
INSERT INTO ben2006_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“এরপর তৃতীয় দিনে এবং আবার সপ্তম দিনে একজন শুচি ব্যক্তি অবশ্যই একজন অশুচি ব্যক্তির ওপরে এই জল ছিটিয়ে দেবে| সপ্তম দিনে সেই ব্যক্তি শুচি হবে| সে অবশ্যই জলে তার কাপড়চোপড় ধোবে| সন্ধ্যাবেলায় সে শুচি হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“যদি কোনো ব্যক্তি অশুচি হয়ে যায় এবং নিজেকে শুচি না করে, তবে সেই ব্যক্তিকে অবশ্যই ইস্রায়েলের অন্যান্য লোকদের থেকে পৃথক রাখা হবে কারণ সে ঈশ্বরের পবিত্র স্থানকে অশুচি করেছে| সেই ব্যক্তির ওপরে সেই বিশেষ জল ছিটোনো হয় নি তাই সে শুচি হয় নি| ");
INSERT INTO ben2006_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","এই নিয়ম তোমাদের জন্য চিরকাল চলবে| যে ব্যক্তি সেই বিশেষ জল ছিটোয সে অবশ্যই তার বস্ত্রাদিও ধোবে| যে কোনো ব্যক্তি সেই বিশেষ জল স্পর্শ করবে সে সন্ধ্যা পর্যন্ত অশুচি থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","যদি কোনো অশুচি ব্যক্তি অন্য কাউকে স্পর্শ করে, তাহলে সেই ব্যক্তিও অশুচি হয়ে যাবে| সেই ব্যক্তি সন্ধ্যা পর্যন্ত অশুচি থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ইস্রায়েলের লোকরা প্রথম মাসে, সীন মরুভূমিতে পৌঁছালো| প্রথমে তারা কাদেশে পৌঁছাল, সেখানে মরিয়ম মারা গেলেন এবং তাকে সেখানেই কবর দেওয়া হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","সেই জায়গায় লোকদের জন্য পর্যাপ্ত পরিমাণ জল ছিল না, সুতরাং মোশি এবং হারোণের কাছে অভিযোগ করার জন্যে লোকরা এক জায়গায় মিলিত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","লোকরা মোশির সঙ্গে তর্ক করে বলল, “এও হলে ভাল হতো যদি আমরা আমাদের ভাইদের মতো প্রভুর সামনে মারা যেতাম| ");
INSERT INTO ben2006_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","আপনি কেন প্রভুর লোকদের এই মরুভূমিতে নিয়ে এসেছিলেন? আপনার ইচ্ছে কি এটাই যে আমাদের এবং আমাদের সঙ্গে থাকা পশুদের এখানেই মৃত্যু হোক্? ");
INSERT INTO ben2006_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","আপনি কেন আমাদের মিশর থেকে এই খারাপ জায়গায় নিয়ে এসেছেন? এখানে কোনো শস্য নেই| এখানে কোনো ডুমুর, দ্রাক্ষা অথবা ডালিম ফল নেই এবং পানের জন্য কোনো জলও নেই|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","সুতরাং মোশি এবং হারোণ লোকদের কাছ থেকে বিদায় নিয়ে সমাগম তাঁবুর প্রবেশ পথে গেলেন| তাঁরা মাটিতে উপুড় হয়ে পড়লে প্রভুর মহিমা তাঁদের সামনে প্রকাশিত হল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“হাঁটার বিশেষ লাঠিটি নিয়ে এসো| হারোণ এবং লোকদের নিয়ে সেই পাহাড়ের সামনে এসো| সবার সামনে ঐ পাহাড়কে বলো, তখন ঐ পাহাড় থেকে জল প্রবাহিত হবে| তুমি সেই জল লোকদের এবং তাদের পশুদের দিতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","লাঠিটি পবিত্র তাঁবুতে প্রভুর সামনে ছিল| প্রভু যেভাবে বলেছিলেন, মোশি সেই ভাবেই লাঠিটি নিয়ে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","মোশি এবং হারোণ পাহাড়ের সামনে সমস্ত লোকদের সমবেত হতে বললেন| তখন মোশি বললেন, “তোমরা সকল সময়েই অভিযোগ করছ| এখন আমার কথা শোন| আমরা কি তোমাদের জন্য এই পাহাড় থেকে জল বার করবো?” ");
INSERT INTO ben2006_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","এরপর মোশি তাঁর হাত তুললেন এবং পাহাড়ে দুবার আঘাত করলেন| পাহাড় থেকে জল বেরোতে শুরু করল| লোকরা এবং তাদের পশুরা জল পান করল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","কিন্তু প্রভু মোশি ও হারোণকে বললেন, “ইস্রায়েলের সব লোকর সাক্ষাতে তুমি আমার প্রতি সম্মান দেখাও নি| তুমি ইস্রায়েলের লোকদের দেখাও নি যে জল বার করার ক্ষমতা আমার থেকেই এসেছে| তুমি লোকদের দেখাও নি যে তুমি আমার প্রতি বিশ্বাস রেখেছো| আমি ঐসব লোকদের সেই দেশটি দেব যে দেশটি আমি তাদের দেব বলে শপথ করেছিলাম, কিন্তু তুমি তাদের সেই দেশে নিয়ে যেতে নেতৃত্ব দেবে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","এই জায়গাটিকে বলা হতো মরীবার জল| এটিই সেই জায়গা যেখানে ইস্রায়েলীয়রা প্রভুর সঙ্গে বিবাদ করেছিল এবং এটিই সেই জায়গা যেখানে প্রভু তাদের দেখিয়েছিলেন যে তিনি পবিত্র| ");
INSERT INTO ben2006_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","কাদেশে থাকাকালীন মোশি ইদোমীয় রাজার কাছে বার্তাসহ কয়েকজন লোককে পাঠালেন| বার্তায় বলা ছিল: “আপনার ভাইরা অর্থাৎ‌ ইস্রায়েলের লোকেরা, আপনাকে বলছে: আমাদের যে সব সমস্যা আছে সে সম্পর্কে আপনি সবই জানেন| ");
INSERT INTO ben2006_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","বহু বছর আগে আমাদের পূর্বপুরুষরা মিশরে গিয়েছিলেন এবং আমরা সেখানে বহু বছর বাস করেছিলাম| মিশরের লোকরা আমাদের পূর্বপুরুষদের প্রতি নিষ্ঠুর ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","কিন্তু আমরা প্রভুর কাছে সাহায্যের জন্য প্রার্থনা করেছিলাম| প্রভু আমাদের প্রার্থনা শুনেছিলেন এবং আমাদের সাহায্যের জন্য একজন দূত পাঠিয়েছিলেন| প্রভু আমাদের মিশর থেকে নিয়ে এসেছেন| “এখন আমরা আপনার দেশের প্রান্তে কাদেশে আছি| ");
INSERT INTO ben2006_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","দয়া করে আপনার দেশের মধ্য দিয়ে আমাদের যেতে দিন| আমরা কোনো শস্য ক্ষেত অথবা কোনো দ্রাক্ষাক্ষেতের মধ্য দিয়ে যাবো না| আমরা আপনাদের কোনো জলাশয় থেকে জল পান করবো না| আমরা রাজপথ বরাবর যাতায়াত করবো| আমরা ঐ রাস্তা থেকে কোনো সময়ই ডানদিকে অথবা বাঁদিকে যাবো না| যতক্ষণ পর্যন্ত আমরা আপনার দেশের মধ্য দিয়ে যাচ্ছি, ততক্ষণ পর্যন্ত আমরা এই রাস্তার ওপরেই থাকবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","কিন্তু ইদোমীয় রাজা উত্তর দিলেন, “তোমরা আমার দেশের মধ্য দিয়ে যেতে পারবে না| তোমরা আমার দেশের মধ্য দিয়ে যাবার চেষ্টা করলে আমরা তরবারি নিয়ে তোমাদের সঙ্গে যুদ্ধ করবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ইস্রায়েলের লোকরা উত্তর দিল, “আমরা প্রধান রাস্তা দিয়ে যাবো| যদি আমাদের পশুরা আপনাদের কোনো জল পান করে, আমরা তার জন্য মূল্য দেবো| আমরা কেবলমাত্র আপনার দেশের মধ্য দিয়ে পায়ে হেঁটে যেতে চাই| আর কিছু নয়|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","কিন্তু ইদোম আবার উত্তর দিলেন, “আমরা তোমাদের আমাদের দেশের মধ্য দিয়ে আসার অনুমতি দেবো না|” এরপর ইদোমীয় রাজা এক বিশাল এবং শক্তিশালী সৈন্যবাহিনী জড়ো করলেন এবং ইস্রায়েলের লোকদের বিরুদ্ধে যুদ্ধের জন্য গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ইদোমীয় রাজা তাঁর দেশের মধ্য দিয়ে ইস্রায়েলের লোকদের যাওয়া নিষেধ করলেন| তাই ইস্রায়েলের লোকরা ঘুরে অন্য পথে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ইস্রায়েলের লোকরা কাদেশ থেকে হোর পর্বতের দিকে যাত্রা করল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","হোর পর্বত ছিল ইদোম সীমানার কাছে| এখানেই প্রভু মোশি এবং হারোণকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হারোণের মৃত্যুর সময় হয়েছে এবং তার পূর্বপুরুষদের কাছে যাওয়ার সময় হয়েছে| যে দেশটা আমি ইস্রায়েলের লোকদের দেব বলে প্রতিশ্রুতি করেছিলাম, হারোণ সেই দেশে প্রবেশ করবে না| মোশি, আমি একথা তোমাকেও বললাম, কারণ তুমি এবং হারোণ দুজনেই মরীবার জলের ধারে দেওয়া আমার আজ্ঞার বিরুদ্ধাচরণ করেছিলে| ");
INSERT INTO ben2006_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“এখন হারোণ এবং তার পুত্র ইলীয়াসরকে হোর পর্বতের ওপরে নিয়ে এসো| ");
INSERT INTO ben2006_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","হারোণের বিশেষ বস্ত্র তার কাছ থেকে নিয়ে এসো এবং সেই বস্ত্রাদি তার পুত্র ইলীয়াসরকে পরিয়ে দাও| সেখানে পর্বতের ওপরে হারোণের মৃত্যু হবে| সে তার পূর্বপুরুষদের কাছে চলে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","মোশি প্রভুর আজ্ঞা পালন করলেন| মোশি, হারোণ এবং ইলীয়াসর হোর পর্বতের ওপরে গেলেন এবং ইস্রায়েলের সমস্ত লোক তাদের সেখানে যেতে দেখল| ");
INSERT INTO ben2006_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","মোশি হারোণের বিশেষ পোশাক খুলে নিলেন এবং হারোণের পুত্র ইলীয়াসরকে সেই সব পোশাক পরিয়ে দিলেন| এরপর পর্বতের চূড়ায় হারোণ মারা গেলে মোশি এবং ইলীয়াসর পর্বত থেকে নেমে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ইস্রায়েলের সকল লোক হারোণের মৃত্যুর খবর জানল| এই কারণে ইস্রায়েলের প্রত্যেক ব্যক্তি 30 দিন শোক পালন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","কনানীয় রাজার নাম ছিলো অরাদ| তিনি নেগেভে বাস করতেন| রাজা অরাদ শুনেছিলেন, যে, ইস্রায়েলের লোকরা অথারীম যাওয়ার পথ ধরে এগিয়ে আসছে| এই কারণে রাজা বেরিয়ে এসে ইস্রায়েলের লোকদের ওপর আক্রমণ করলেন| অরাদ কয়েকজন লোককে বন্দী করে রাখলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তখন ইস্রায়েলের লোকরা প্রভুর কাছে এক বিশেষ শপথ করে বললেন: “প্রভু দয়া করে এইসব লোকদের পরাজিত করতে আমাদের সাহায্য করুন| যদি আপনি এটা করেন তাহলে আমরা তাদের শহরগুলো আপনাকে দেবো| আমরা তাদের সম্পূর্ণ ধ্বংস করবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","প্রভু ইস্রায়েলের লোকদের কথা শুনলেন এবং কনানীয় লোকদের পরাজিত করার জন্য প্রভু ইস্রায়েলের লোকদের সাহায্য করলেন| ইস্রায়েলীয়রা কনানীয়দের এবং তাদের শহরগুলো সম্পূর্ণ ধ্বংস করেছিল| এই কারণে ঐ জায়গাটির নাম রাখা হল হর্মা| ");
INSERT INTO ben2006_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ইস্রায়েলের লোকরা হোর পর্বত ত্যাগ করে সূফ সাগরে যাওয়ার পথ ধরে এগোলো| ইদোমের চারদিকে ঘোরার জন্য তারা এটা করল| কিন্তু লোকরা অধৈর্য্য হল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","তারা প্রভু এবং মোশির বিরুদ্ধে অভিযোগ করতে শুরু করল| লোকরা বলল, “কেন আপনি আমাদের মিশর থেকে বের করে নিয়ে এসেছেন? আমরা এখানে মরুভূমিতে মারা যাবো| এখানে কোনো রুটি নেই! জল নেই! আর আমরা এই সাংঘাতিক খাদ্যকে ঘৃণা করি|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","এই কারণে প্রভু লোকদের মধ্যে বিষাক্ত সাপ পাঠালেন| সাপগুলো লোকদের দংশন করলে ইস্রায়েলের বহু সংখ্যক লোক মারা গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","তখন লোকরা মোশির কাছে এসে বলল, “আমরা জানি যে আমরা প্রভুর বিরুদ্ধে এবং আপনার বিরুদ্ধে কথা বলে পাপ করেছি| প্রভুর কাছে প্রার্থনা করুন যেন তিনি সাপগুলোকে ফিরিয়ে নিয়ে যান|” সুতরাং মোশি লোকদের জন্য প্রার্থনা করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","প্রভু মোশিকে বললেন, “একটি পিতলের সাপ তৈরী করো এবং এটিকে একটি খুঁটির ওপরে রাখো| কোনো ব্যক্তিকে সাপে কামড়ালে যদি সেই ব্যক্তি খুঁটির ওপরের পিতলের সাপটির দিকে তাকায় তাহলে সে ব্যক্তি মারা যাবে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","মোশি প্রভুর আদেশ পালন করলেন| তিনি একটি পিতলের সাপ তৈরী করে সেটিকে খুঁটির ওপরে রাখলেন| এরপর যখনই কোন মানুষকে সাপে দংশন করত, তখনই সে খুঁটির ওপরের পিতলের সাপটির দিকে তাকাতো আর বেঁচে যেতো| ");
INSERT INTO ben2006_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ইস্রায়েলের লোকরা ঐ জায়গা ছেড়ে ওবোতে শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","এরপর তারা ওবোত ত্যাগ করে মোয়াবের পূর্বদিকের মরুভূমিতে ইয় অবারীমে শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","তারা সেই জায়গাও পরিত্যাগ করে সেরদ উপত্যকায় শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","এরপর তারা সরে গিয়ে মরুভূমিতে অর্ণোন নদীর অপর পারে শিবির স্থাপন করল| এই নদীটি অম্মোনীয় সীমান্তে শুরু হয়েছিল| উপত্যকা হল মোয়াব এবং ইমোরীয়ের মধ্যে সীমারেখা| ");
INSERT INTO ben2006_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","এই কারণে এই কথাগুলো লেখা হয়েছে প্রভুর যুদ্ধ সংক্রান্ত পুস্তকে: “…এবং শূফাতে বাহেব, আর অর্ণোনের উপত্যকাগুলি ");
INSERT INTO ben2006_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","এবং উপত্যকাগুলির পাশের পর্বতমালা, যা আর শহরের দিকে চলে গেছে| এই জায়গাগুলি মোয়াবের সীমান্তে অবস্থিত|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ইস্রায়েলের লোকরা সেই জায়গা ছেড়ে বেরের দিকে যাত্রা করল| এই জায়গাটিতে কুয়ো ছিল| এটিই সেই জায়গা যেখানে প্রভু মোশিকে বললেন, “সমস্ত লোকদের একত্রে এখানে নিয়ে এসো, আমি তাদের জল দেবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","তখন ইস্রায়েলের লোকরা এই গানটি গাইল: “কুয়ো তুমি ঝর্ণা হয়ে ওঠো| তোমরা এই নিয়ে গান ধরো| ");
INSERT INTO ben2006_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","মহান মানুষরা কুয়োটি খুঁড়েছিলেন| গুরুত্বপূর্ণ নেতারা কুয়োটি খুঁড়েছিলেন| তাঁদের নিজেদের দণ্ড আর হাঁটার লাঠি দিয়ে কুয়োটি খুঁড়েছিলেন| কুয়োটি মরুভূমিতে একটি উপহার|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","লোকরা মৎতানায় থেকে নহলীয়েল পর্যন্ত গেল| এরপর তারা নহলীয়েল থেকে বামোৎ পর্যন্ত গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","বামোৎ থেকে তারা মোয়াবের উপত্যকা পর্যন্ত গেল| এখানে পিস্গা পর্বতের চূড়া মরুভূমির ওপরে দেখা যায়| ");
INSERT INTO ben2006_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ইমোরীয়দের রাজা সীহোনের কাছে ইস্রায়েলের লোকরা কয়েকজন বার্তাবাহককে পাঠাল| সেই লোকরা রাজাকে বলল, ");
INSERT INTO ben2006_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“আমাদের আপনার দেশের মধ্য দিয়ে ভ্রমণ করার অনুমতি দিন| আমরা কোনো শস্য অথবা দ্রাক্ষার ক্ষেতের মধ্য দিয়ে যাবে| না| আমরা আপনার কোনো কুয়ো থেকে জল পান করবো না| আপনার দেশের সীমা অতিক্রম না করা পর্যন্ত আমরা রাজপথ ছাড়া অন্য কোন রাস্তা দিয়েই যাবো না|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","কিন্তু রাজা সীহোন তাঁর দেশের মধ্য দিয়ে লোকদের যাওয়ার অনুমতি দিলেন না| রাজা তাঁর সৈন্যবাহিনীকে এক জায়গায় একত্রিত করে ইস্রায়েলের লোকদের বিরুদ্ধে যুদ্ধ করার জন্য মরুভূমির দিকে অগ্রসর হলেন| রাজার সৈন্যরা যহস নামে একটি জায়গায় ইস্রায়েলের লোকদের বিরুদ্ধে যুদ্ধ করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","কিন্তু ইস্রায়েলের লোকরা রাজাকে হত্যা করল| এরপর অর্ণোন নদী থেকে যব্বোক নদী পর্যন্ত জায়গা তারা অধিকার করল| ইস্রায়েলের লোকরা অম্মোন সীমানা পর্যন্ত অধিকার করল| অম্মোনীয়দের দ্বারা সীমানা খুবই শক্তভাবে সুরক্ষিত থাকার জন্য তারা সেই সীমানা পর্যন্ত গিয়ে থেমে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ইস্রায়েলের লোকরা ইমোরীয়দের সমস্ত শহরগুলোকে দখল করল এবং সেগুলিতে বসবাস করতে শুরু করল| উপরন্তু তারা হিষবোন শহর এবং তার আশেপাশের ছোটো ছোটো শহরগুলোকেও অধিকার করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ইমোরীয়দের রাজা সীহোন হিষ্বোন শহরেই বাস করতেন| অতীতে মোয়াবের রাজার সঙ্গে সীহোন যুদ্ধ করে অর্ণোন নদী পর্যন্ত সমস্ত জায়গা অধিকার করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","এই কারণেই গায়করা গেয়ে থাকেন: “হিষ্বোন এসো এবং হিষ্বোন শহরকে আবার তৈরী কর! সীহোনের শহরটিকে শক্ত কর! ");
INSERT INTO ben2006_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","হিষ্বোনে এক আগুন শুরু হয়েছিল| সেই আগুন সীহোনের শহরেও উদ্ভুত হয়েছিল| মোয়াবের আর নামে শহরটি সেই আগুনে ভস্মীভূত হয়েছিল| অর্ণোন নদীর ওপরের পর্বতটিকেও সেই আগুন পুড়িয়ে দিয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","মোয়াব, ধিক্ তোমাকে! কমোশ দেবতার লোকরা, তোমরা হেরে গেছ! তার ছেলেরা পালিয়ে গেল| ইমোরীয়দের রাজা সীহোন তার কন্যাদের জেলে বন্দী করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","কিন্তু আমরা সেই ইমোরীয়দের পরাজিত করলাম| হিষ্বোন থেকে দীবোন পর্যন্ত, মেদবার কাছে নাশিম থেকে নোফঃ পর্যন্ত তাদের শহরগুলোকেও আমরা ধ্বংস করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","এই কারণে ইস্রায়েলের লোকরা ইমোরীয়দের দেশে তাদের শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","মোশি যাসের শহরটিকে অনুসন্ধানের জন্য কয়েকজন গুপ্তচর পাঠালেন| তারপরে ইস্রায়েলের লোকরা এটিকে দখল করল| তারা শহরটির আশেপাশের ছোটোখাটো শহরগুলোকেও অধিকার করল| ইস্রায়েলের লোকরা সেখানে বসবাসকারী ইমোরীয়দের সেই জায়গা ত্যাগ করতে বাধ্য করল| ");
INSERT INTO ben2006_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","এরপর ইস্রায়েলের লোকরা বাশনের অভিমুখে সড়কপথে ভ্রমণ করল| বাশনের রাজা ওগ তাঁর সৈন্যদের সঙ্গে নিয়ে ইস্রায়েলের লোকদের সম্মুখীন হওয়ার জন্য কুচকাওয়াজ করে অগ্রসর হলেন| ইদ্রিয়ী নামে একটি জায়গায় তিনি তাদের বিরুদ্ধে যুদ্ধ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","কিন্তু প্রভু মোশিকে বললেন, “ঐ রাজা সম্পর্কে ভীত হয়ো না| আমি তার সমস্ত সৈন্য এবং তার সম্পূর্ণ দেশ তোমার হাতে তুলে দেব| ইমোরীয়দের রাজা সীহোন, যিনি হিষ্বোনে বাস করতেন তার সঙ্গে তুমি যা করেছিলে এই রাজার সঙ্গেও তুমি সেটাই করো|” ");
INSERT INTO ben2006_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","সুতরাং ইস্রায়েলের লোকরা ওগ এবং তাঁর সৈন্যদের পরাজিত করল| তারা তাঁকে তাঁর পুত্রদের এবং তাঁর সৈন্যদের হত্যা করল| এরপর ইস্রায়েলের লোকরা তাঁর দেশ অধিকার করল| ");
INSERT INTO ben2006_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","এরপর ইস্রায়েলের লোকরা মোয়াবের যর্দন উপত্যকার দিকে এগোতে শুরু করল| যিরীহো থেকে অপরপারে যর্দন নদীর কাছে তারা শিবির স্থাপন করল| ");
INSERT INTO ben2006_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","ইমোরীয়দের লোকদের সঙ্গে ইস্রায়েলের লোকরা যা যা করেছিল, সিপ্পোরের পুত্র বালাক তার সমস্তটাই দেখেছিলেন| মোয়াবের রাজা খুবই ভয় পেয়েছিলেন, কারণ সেখানে ইস্রায়েলের লোকসংখ্যা ছিল প্রচুর| মোয়াব উদ্বিগ্ন হল| ");
INSERT INTO ben2006_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","মোয়াবের রাজা মিদিয়নের নেতাদের বললেন, “গরু যেভাবে মাঠের সমস্ত ঘাস খেয়ে ফেলে, ঠিক সেভাবেই এই বিশাল জনগোষ্ঠী আমাদের চারপাশের সমস্ত কিছুই ধ্বংস করে দেবে|” এই সময় সিপ্পোরের পুত্র বালাক মোয়াবের রাজা ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","বিয়োরের পুত্র বিলিয়মকে ডাকার জন্য তিনি কয়েকজন লোক পাঠালেন| ফরাৎ নদীর কাছে পথোর নামে একটি জায়গায় বিলিয়ম ছিলেন| এইখানেই বিলিয়মের স্বজাতীয়রা বাস করতো| এই ছিল বালাকের বার্তা: “মিশর থেকে এক নতুন জাতির লোকরা এসেছে| সেখানে তাদের সংখ্যা এতো বেশী যে সমস্ত দেশটা ভরে যাবে| তারা আমাদের পরেই শিবির স্থাপন করেছে| ");
INSERT INTO ben2006_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","আপনি এসে আমাকে সাহায্য করুন| এই লোকদের অভিশাপ দিন কারণ এরা আমার চেয়ে শক্তিশালী| আমি জানি আপনি যদি কোনো ব্যক্তিকে আশীর্বাদ করেন তাহলে সে আশীর্বাদ পায় এবং আপনি যদি কোনো ব্যক্তিকে অভিশাপ দেন তবে সে শাপগ্রস্ত হয়| সুতরাং আপনি আসুন এবং এই সমস্ত লোকদের অভিশাপ দিন| হতে পারে, আমি হয়তো তাদের আঘাত করে আমার দেশ থেকে দূর করে দিতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","মোয়াব এবং মিদিয়নের নেতারা বিলিয়মের সঙ্গে কথা বলতে গেলেন| তার কাজের পারিশ্রমিক হিসেবে তাদের সঙ্গে টাকা নিয়ে গেলেন এবং তাকে বালাকের প্রেরিত বার্তাটি বললেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","বিলিয়ম তাদের বললেন, “এখানে এক রাত্রির জন্য থাকো| আমি প্রভুর সঙ্গে কথা বলবো এবং তিনি আমাকে যে উত্তর দেবেন তা আমি তোমাদের বলবো|” সুতরাং সেই রাত্রে মোয়াবের নেতারা বিলিয়মের সঙ্গেই সেখানে থাকলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ঈশ্বর বিলিয়মের কাছে এসে জিজ্ঞেস করলেন, “তোমার সঙ্গের এই সমস্ত লোকরা কারা?” ");
INSERT INTO ben2006_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","বিলিয়ম ঈশ্বরকে বললেন, “মোয়াবের রাজা, সিপ্পোরের পুত্র বালাক আমাকে একটি সংবাদ দেওয়ার জন্য এদের পাঠিয়েছেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","এই সেই বার্তা: মিশর থেকে এক নতুন জাতি এসেছে| সেখানে তাদের সংখ্যা এতো বেশী যে তারা সমস্ত দেশটাকে ভরে দেবে| সুতরাং আপনি আসুন এবং এই সমস্ত লোকদের অভিশাপ দিন| তাহলে হয়তো আমি তাদের সঙ্গে যুদ্ধ করতে সক্ষম হবো এবং তাদের আমার দেশ ত্যাগ করতে বাধ্য করতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","কিন্তু ঈশ্বর বিলিয়মকে বললেন, “তুমি অবশ্যই এদের সঙ্গে যাবে না| ওসব লোকর বিরুদ্ধে তোমার কথা বলা উচিৎ‌ হবে না কারণ তারা আমার আশীর্বাদ প্রাপ্ত লোক|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","পরদিন সকালে উঠে বিলিয়ম বালাকের প্রেরিত নেতাদের বললেন, “তোমরা তোমাদের নিজেদের দেশে ফিরে যাও| প্রভু আমাকে তোমাদের সঙ্গে যেতে দেবেন না|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","সুতরাং মোয়াবের নেতারা বালাকের কাছে ফিরে গিয়ে তাকে এই সব কথা জানালেন| তাঁরা বললেন, “বিলিয়ম, আমাদের সঙ্গে আসতে অস্বীকার করেছেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","সুতরাং বালাক বিলিয়মের কাছে প্রথমবারের থেকেও বেশী লোক পাঠালেন| প্রথমবার তিনি যাদের পাঠিয়েছিলেন তাদের থেকেও এবারের নেতারা ছিলেন অনেক বেশী গুরুত্বপূর্ণ| ");
INSERT INTO ben2006_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","তাঁরা বিলিয়মের কাছে গিয়ে বললেন: “সিপ্পোরের পুত্র বালাক আপনাকে এই কথা বলেছেন: দয়া করে এখানে আসুন এবং কোন কিছুই যেন আমার কাছে আপনার আসা থামিয়ে না দেয়| ");
INSERT INTO ben2006_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","আমি আপনাকে প্রচুর পারিশ্রমিক দেবো এবং আপনি যা বলবেন আমি তাই-ই করব| আমার জন্যে আপনি আসুন এবং এসে এই লোকদের বিরুদ্ধে কথা বলুন|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","বিলিয়ম বালাকের প্রেরিত দূতকে তার উত্তর জানিয়ে দিয়ে বললেন, “আমি আমার প্রভু ঈশ্বরকে অবশ্যই মান্য করবো| আমি তাঁর আদেশের বিরুদ্ধে কোনো কাজ করতে পারি না| আমি বড় বা ছোট কোনো কাজই করবো না যদি না প্রভু আমাকে সেই কাজ করার অনুমতি দেন| রাজা বালাক যদি তার রূপো এবং সোনা খচিত সুন্দর প্রাসাদটি আমাকে দিয়ে দেন তাহলেও আমি প্রভুর আদেশের বিরুদ্ধে কোনো কাজ করবো না| ");
INSERT INTO ben2006_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","কিন্তু তোমরা অন্যান্যদের মতোই আজকের রাত্রিটা এখানে থাকতে পারো| তাহলে এই রাত্রিকালের মধ্যেই প্রভু আমাকে যা বলতে চান তা জানতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","সেই রাত্রে ঈশ্বর বিলিয়মের কাছে এসে বললেন, “এই সমস্ত লোকরা তাদের সঙ্গে যাওয়ার কথা বলার জন্য পুনরায় এসেছে| সুতরাং তুমি তাদের সঙ্গে যেতে পারো| কিন্তু আমি তোমাকে যা করতে বলবো তুমি কেবলমাত্র সেই কাজই করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","পরদিন সকালে বিলিয়ম উঠে তাঁর গাধা সাজিয়ে মোয়াবের নেতাদের সঙ্গে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","বিলিয়ম তাঁর গাধায় চড়েই যাচ্ছিলেন| তাঁর সঙ্গে তাঁর দুজন ভৃত্য ছিল| কিন্তু বিলিয়মের গমনে ঈশ্বর ক্ষুব্ধ হলেন| তাই বিলিয়মের সামনে রাস্তার ওপরে প্রভুর দূত দাঁড়ালেন, যেন বিলিয়মের যাওয়া বন্ধ করা যায়| ");
INSERT INTO ben2006_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","বিলিয়মের গাধা প্রভুর দূতকে রাস্তায় তরবারি হাতে দাঁড়িয়ে থাকতে দেখল| সেইজন্য গাধাটি রাস্তা থেকে সরে এসে মাঠের মধ্যে চলে গেল| বিলিয়ম কিন্তু দূতকে দেখতে পান নি| সেইজন্য তিনি তাঁর গাধাটার ওপরেই রেগে গিয়ে তাকে আঘাত করলেন এবং রাস্তার ওপরে ফিরে যেতে তাকে বাধ্য করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","পরে প্রভুর দূত এমন এক জায়গায় গিয়ে দাঁড়ালেন যেখানে রাস্তাটি আরও সরু হয়ে এসেছে| জায়গাটি ছিল দুটি দ্রাক্ষা ক্ষেতের মাঝখানে| সেখানে রাস্তার দুই ধারেই দেওয়াল ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","গাধাটি আবার প্রভুর দূতকে দেখতে পেয়ে দেওয়ালের গা ঘেঁষে হাঁটল| তাতে বিলিয়মের পা দেওয়ালে আঘাত লেগে ছড়ে গেল| সেই জন্যে বিলিয়ম আবার তাঁর গাধাটিকে আঘাত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","পরে প্রভুর দূত আরেকটি জায়গায় গিয়ে দাঁড়ালেন| এই খানে রাস্তাটি সরু হয়ে এসেছিল, ফলে এমন কোনো জায়গা ছিল না যেখান দিয়ে গাধাটি তাঁকে পাশ কাটিয়ে চলে যেতে পারে| গাধাটি বাঁদিক অথবা ডানদিক, কোনো দিক দিয়েই পাশ কাটাতে পারল না| ");
INSERT INTO ben2006_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","গাধাটি প্রভুর দূতকে দেখে বিলিয়মকে তার পিঠের ওপরে নিয়েই শুয়ে পড়ল| তাতে বিলিয়ম গাধাটির ওপরে প্রচণ্ড ক্রুদ্ধ হয়ে তার হাঁটার লাঠিটি দিয়ে গাধাটিকে আঘাত করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","তখন প্রভু গাধাটিকে দিয়ে কথা বলালেন| গাধাটি বিলিয়মকে বলল, “আপনি আমার ওপরে রেগে গিয়েছেন কেন? আমি আপনার কি ক্ষতি করেছি যে এই নিয়ে আপনি আমাকে তিনবার আঘাত করলেন?” ");
INSERT INTO ben2006_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বিলিয়ম গাধাটিকে বলল, “তুমি আমাকে হাস্যস্পদ করে তুলেছ| যদি আমার হাতে একটি তরবারি থাকতো, তাহলে আমি এখনই তোমাকে হত্যা করতাম|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","কিন্তু গাধাটি বিলিয়মকে বলল, “আপনি সারা জীবন ধরে যার উপরে চড়ে ভ্রমণ করেছেন আমি কি আপনার সেই গাধা নই? আমি কি আপনার প্রতি এমন ব্যবহার করে থাকি?” বিলিয়ম বলল, “সেটা সত্য|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","তখন প্রভু বিলিয়মকে তার দূতকে দেখতে দিলেন| প্রভুর দূত হাতে একটি তরবারি নিয়ে রাস্তার ওপরে দাঁড়িয়েছিলেন| বিলিয়ম মাটিতে নতজানু হয়ে অভিবাদন জানালেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","তখন প্রভুর দূত বিলিয়মকে প্রশ্ন করল, “তুমি তোমার গাধাকে তিনবার আঘাত করেছো কেন? আমিই এসেছিলাম তোমাকে থামাতে| কিন্তু ঠিক সময়ে ");
INSERT INTO ben2006_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","তোমার গাধা আমাকে দেখতে পেয়ে তিনবার আমার কাছ থেকে সরে গিয়েছিল| যদি গাধাটি সরে না যেতো, তাহলে আমি হয়তো এতক্ষণে তোমাকে হত্যা করতাম, কিন্তু তোমার গাধাকে বাঁচিয়ে রাখতাম|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","তখন বিলিয়ম প্রভুর দূতকে বললেন, “আমি পাপ করেছি| আমি জানতাম না যে আপনি আমার গতিরোধ করার জন্য রাস্তার ওপরে দাঁড়িয়েছিলেন| আমার ওখানে যাওয়াতে আপনি যদি খুশী না হন, তাহলে আমি ঘরে ফিরে যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","তখন প্রভুর দূত বিলিয়মকে বললেন, “না! তুমি এই লোকদের সঙ্গে যেতে পারো| কিন্তু সাবধান, আমি তোমাকে যা বলতে বলবো তুমি কেবল তাই বলবে|” সুতরাং বালাকের প্রেরিত নেতাদের সঙ্গে বিলিয়ম চলে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","বালাক শুনেছিলেন যে বিলিয়ম আসছেন| তাই অর্ণোন নদীর কাছে মোয়াবের শহরে তাঁর সঙ্গে দেখা করার জন্য বালাক চলে গেলেন| জায়গাটি ছিল তাঁর দেশের উত্তর সীমানায়| ");
INSERT INTO ben2006_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","বালাক বিলিয়মকে দেখতে পেয়ে বললেন, “আমি আগেই আপনাকে আসতে বলেছিলাম| বলেছিলাম, এটি খুবই জরুরী, কিন্তু আপনি আমার কাছে কেন আসেন নি? আপনাকে পারিশ্রমিক দিতে কি আমার সামর্থ্য নেই?” ");
INSERT INTO ben2006_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","বিলিয়ম উত্তর দিলেন, “দেখুন আমি এখন এখানে| আমি এসেছি কিন্তু আপনি যা বলেছেন সেটা করতে আমি সক্ষম নাও হতে পারি| প্রভু ঈশ্বর আমাকে যা বলতে বলবেন, আমি কেবলমাত্র সে কথাই বলতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","তখন বিলিয়ম বালাকের সঙ্গে কিরিয়ৎ-হুষোতে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","বালাক কিছু গবাদি পশু এবং মেষ বলিদান করে সেই মাংসের কিছুটা বিলিয়মকে এবং তার সঙ্গী নেতাদের দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","পরদিন সকালে বালাক বিলিয়মকে নিয়ে ব্যামোথ বালে গেলে সেখান থেকে তাঁরা ইস্রায়েলীয়দের শিবিরের কিছুটা দেখতে পেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","বিলিয়ম বালাককে বলল, “এখানে সাতটি বেদী তৈরী করো এবং আমার জন্য সাতটি ষাঁড় এবং সাতটি মেষ তৈরী রাখো|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","বিলিয়মের কথামতো বালাক কাজগুলো করলেন| এরপর বালাক এবং বিলিয়ম প্রত্যেকটি বেদীর ওপরে একটি করে মেষ এবং একটি করে ষাঁড় উৎসর্গ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","তখন বিলিয়ম বালাককে বললেন, “আপনি আপনার হোমবলির কাছে দাঁড়িয়ে থাকুন| আমি অন্য জায়গায় যাবো| হয়তো প্রভু আমার কাছে আসবেন এবং আমার যা বলা উচিৎ‌ সেটা উনি আমায় বলে দেবেন|” এরপর বিলিয়ম একটি উঁচু জায়গায় চলে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ঈশ্বর সেই স্থানে বিলিয়মের কাছে এলে বিলিয়ম বললেন, “আমি সাতটি বেদী তৈরী করেছি এবং উৎসর্গ হিসেবে প্রত্যেকটি বেদীর ওপরে একটি ষাঁড় এবং একটি মেষ হত্যা করেছি|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","তখন প্রভু বিলিয়মকে তাঁর যা বলা উচিৎ‌ তা বললেন| আর বললেন, “বালাকের কাছে ফিরে যাও, এবং আমি তোমাকে যা বলতে বলেছি সেই কথাগুলো বলো|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","তাই বিলিয়ম বালাকের কাছে ফিরে গেলেন| বালাক তখনও সেই হোমবলির কাছে দাঁড়িয়েছিলেন| মোয়াবের সমস্ত নেতারাও তাঁর সঙ্গে সেখানে দাঁড়িয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","তখন বিলিয়ম এই কথাগুলো বললেন: “মোয়াবের রাজা বালাক অরামের পূর্বদিকে পর্বত থেকে আমাকে এখানে নিয়ে এসেছেন| বালাক আমাকে বললেন, ‘আসুন, আমার জন্য যাকোবের বিরুদ্ধে বলুন| আসুন, ইস্রায়েলের লোকদের বিরুদ্ধে বলুন|’ ");
INSERT INTO ben2006_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","কিন্তু ঈশ্বর এইসব লোকদের বিরুদ্ধে নন, সুতরাং আমিও তাদের বিরুদ্ধে কিছু বলতে পারবো না| ঈশ্বর তাদের খারাপ হোক্ এমন কিছু চান না| সুতরাং আমিও সেটা করতে পারবো না| ");
INSERT INTO ben2006_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","আমি পর্বতের ওপর থেকে ঐ লোকদের দেখছি| আমি উঁচু পর্বতশৃঙ্গ থেকে তাদের দেখছি| ঐ সমস্ত লোকরা একাই বাস করে| তারা অন্য কোনো জাতির অংশ নয়| ");
INSERT INTO ben2006_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","যাকোবের লোকদের কে গণনা করতে পারবে? তারা ধূলোর কণার মতোই সংখ্যায় প্রচুর| ইস্রায়েলের এক চতুর্থাংশ লোককেও কেউ গণনা করতে পারবে না| একজন ভালো লোকর মতো আমাকে মরতে দাও| তাদের মতো সুখে আমার জীবন শেষ হতে দাও|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","বালাক বিলিয়মকে বললেন, “আপনি আমার জন্য কি করলেন? আমার শত্রুদের বিরুদ্ধে কথা বলার জন্য আমি আপনাকে এখানে এনেছিলাম| কিন্তু আপনি তাদের কেবলমাত্র আশীর্বাদ করলেন!” ");
INSERT INTO ben2006_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","কিন্তু বিলিয়ম উত্তর দিলেন, “প্রভু আমাকে যে কথা বলেছেন, আমি অবশ্যই সেই কথা বলবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","তখন বালাক তাকে বললেন, “তাহলে আমার সঙ্গে আরেকটি জায়গায় আসুন| সেই জায়গা থেকে আপনি তাদের দেখতে পাবেন| আপনি তাদের সকলকে দেখতে পাবেন না, কেবল প্রান্তভাগ দেখতে পাবেন| সেই জায়গা থেকে আমার জন্য তাদের বিরুদ্ধে আপনার পক্ষে কথা বলা সম্ভব হতে পারে|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","সুতরাং বালাক বিলিয়মকে সোফীম ক্ষেত্রের ওপরে নিয়ে গেলেন| এই জায়গাটি ছিল পিস্গা পর্বতের ওপরে| সেই জায়গায় বালাক সাতটি বেদী তৈরী করে প্রত্যেকটি বেদীর ওপরে উৎসর্গস্বরূপ একটি করে ষাঁড় এবং একটি করে মেষ উৎসর্গ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","বিলিয়ম বালাককে বললেন, “এই স্থানে আপনার হোমবলির পাশে থাকুন| আমি ঈশ্বরের সঙ্গে দেখা করতে যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","সুতরাং ঈশ্বর বিলিয়মের কাছে এলেন এবং কি বলতে হবে তা বিলিয়মকে বলে দিলেন| এরপর প্রভু বিলিয়মকে বালাকের কাছে ফিরে গিয়ে সেই কথাগুলো বলতে বললেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","সুতরাং বিলিয়ম বালাকের কাছে ফিরে গেলেন| বালাক তখনও পর্যন্ত হোমবলির কাছে দাঁড়িয়েছিলেন| মোয়াবের নেতারা তার সঙ্গে সেখানেই ছিলেন| বালাক বিলিয়মকে আসতে দেখে বললেন, “প্রভু কি বলেছেন?” ");
INSERT INTO ben2006_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","বিলিয়ম তখন এই ভাববাণী বললেন: “দাঁড়াও বালাক এবং আমার কথা শোন| আমার কথা শোন, সিপ্পোরের পুত্র বালাক| ");
INSERT INTO ben2006_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ঈশ্বর মানুষ নন; তিনি মিথ্যে বলবেন না| ঈশ্বর মানুষ নন; তাঁর সিদ্ধান্তের পরিবর্তন হবে না| যদি প্রভু বলেন যে তিনি কোনো কাজ করবেন, তখন তিনি অবশ্যই সে কাজ করবেন| যদি প্রভু যদি কোনো প্রতিজ্ঞা করেন তাহলে তিনি প্রতিজ্ঞা মতো কাজটি করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","প্রভু আমাকে ঐ সমস্ত লোকদের আশীর্বাদ করতে বলেছেন| প্রভু তাদের আশীর্বাদ করেছেন, সুতরাং আমি সেটা পরিবর্তন করতে পারব না| ");
INSERT INTO ben2006_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ঈশ্বর যাকোবের লোকদের মধ্যে কোনো অন্যায় দেখেন নি| ইস্রায়েলের লোকদের মধ্যেও তিনি কোনো পাপ দেখেন নি| প্রভু তাদের ঈশ্বর এবং তিনি তাদের সঙ্গে আছেন| মহান রাজা তাদের সঙ্গে আছেন| ");
INSERT INTO ben2006_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ঈশ্বর ঐসব লোকদের মিশর থেকে নিয়ে এসেছেন| তিনি তাদের পক্ষে বুনো ষাঁড়ের মতোই শক্তিশালী| ");
INSERT INTO ben2006_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","যাকোবের লোকদের পরাজিত করতে পারে এমন কোনো ক্ষমতা নেই| ইস্রায়েলের লোকদের থামাতে পারে এমন কোনো মন্ত্রও নেই| যাকোব সম্পর্কে এবং ইস্রায়েলের লোকদের সম্পর্কে লোক এই কথা বলবে: ‘ঈশ্বর যে সব মহৎ‌‌ কাজ করেছেন, তা দেখো!’ ");
INSERT INTO ben2006_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","এইসব লোকরা সিংহের মতোই উঠে দাঁড়ায় এবং যে পর্যন্ত না তার শিকার খায় ও তার রক্ত পান করে সে পর্যন্ত বিশ্রাম করে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","তখন বালাক বিলিয়মকে বললেন, “আপনি ওদের শাপও দেবেন না, আশীর্বাদও করবেন না|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","বিলিয়ম উত্তর দিলেন, “আমি আপনাকে আগেই বলেছিলাম যে প্রভু আমাকে যা বলতে বলবেন, আমি কেবল সেই কথাই বলতে পারবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","তখন বালাক বিলিয়মকে বললেন, “তাহলে আমার সঙ্গে আপনি আরেকটি জায়গায় আসুন| এমন হতে পারে যে, ঈশ্বর খুশী হবেন এবং সেই স্থান থেকে অভিশাপ দেওয়ার জন্য আপনাকে অনুমতি দেবেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","তখন বালাক বিলিয়মকে নিয়ে পিয়োর পর্বতের ওপরে গেলেন| সেই পর্বতের ওপর থেকে মরুভূমি দেখা যায়| ");
INSERT INTO ben2006_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","বিলিয়ম বললেন, “এখানে সাতটি বেদী তৈরী করুন| তারপর সেই বেদীর জন্য সাতটি ষাঁড় এবং সাতটি মেষকে তৈরী রাখুন|” ");
INSERT INTO ben2006_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","বিলিয়ম যা করতে বলেছিলেন বালাক ঠিক তাই করলেন| বালাক বেদীগুলোর ওপরে ষাঁড় ও মেষগুলোকে উৎসর্গ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","বিলিয়ম দেখলেন যে প্রভু ইস্রায়েলকে আশীর্বাদ করতে পেরে সন্তুষ্ট| সেই কারণে বিলিয়ম আগের মত মন্ত্র পাবার জন্য চেষ্টা করলেন না| কিন্তু তিনি মরুভূমির দিকে ফিরে তাকালেন| ");
INSERT INTO ben2006_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","বিলিয়ম চোখ তুলে মরুভূমির একপ্রান্ত থেকে অপরপ্রান্তের দিকে তাকিয়ে ইস্রায়েলের সমস্ত লোককে দেখলেন| তারা পরিবারগোষ্ঠীর সঙ্গে বিভিন্ন স্থানে শিবির স্থাপন করেছিল| তখন বিলিয়মের কাছে ঈশ্বরের আত্মা এলেন এবং তাঁকে নিয়ন্ত্রণ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","তখন বিলিয়ম এই ভাববানী বললেন: “বিয়োরের পুত্র বিলিয়মের কাছ থেকে এই বার্তা| আমি যা কিছু স্পষ্ট দেখলাম সে সম্পর্কে বলছি| ");
INSERT INTO ben2006_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","আমি ঈশ্বরের কাছ থেকে এই বার্তা শুনেছি| সর্বশক্তিমান ঈশ্বর আমাকে যা দেখিয়েছেন তা আমি দেখেছি| আমি যা দেখেছি সেটা বিনয়ের সঙ্গে বলছি| ");
INSERT INTO ben2006_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“হে যাকোবের লোকরা, তোমাদের তাঁবুগুলো কি সুন্দর! ইস্রায়েলের লোকরা, তোমাদের ঘরগুলো কতো সুন্দর! ");
INSERT INTO ben2006_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","তোমাদের তাঁবুগুলো তালগাছের সারির মতো, নদীর ধারের কনানের মতো| তোমরা প্রভুর দ্বারা রোপিত হওয়া সুমিষ্ট গন্ধগুল্মের মতো, জলের পাশে বেড়ে ওঠা এরস বৃক্ষের মতো| ");
INSERT INTO ben2006_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","তোমাদের জলের অভাব হবে না, এই জল তোমাদের বীজের বেডে ওঠার কাজে ব্যবহার করা যাবে| রাজা অগাগের থেকে তোমাদের রাজা অনেক মহৎ‌‌ হবেন| তোমাদের রাজ্য অনেক শ্রেষ্ঠতর হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ঈশ্বর ঐ সমস্ত লোকদের মিশর থেকে নিয়ে এসেছেন| তারা বুনো ষাঁড়ের মতো শক্তিশালী| তারা তাদের সমস্ত শত্রুদের পরাজিত করবে| তারা তাদের হাড় ভেঙ্গে দেবে এবং তীর বিদ্ধ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","“ইস্রায়েল একটি সিংহের মতো, গুঁড়ি মেরে শুয়ে আছে| হ্যাঁ, তারা তেজী সিংহের মতো, এবং কেউই তাকে জাগাতে চায় না| যদি কোনো ব্যক্তি তোমাকে আশীর্বাদ করে তবে সে নিজের আশীর্বাদ পাবে এবং যদি কোনোও ব্যক্তি তোমার বিরুদ্ধে কথা বলে তাকে অনেক সমস্যার সম্মুখীন হতে হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","বালাক বিলিয়মের ওপরে প্রচণ্ড ক্রুদ্ধ হয়ে নিজের হাত ঠুকলেন| বালাক বিলিয়মকে বললেন, “আমি আপনাকে এসে আমার শত্রুদের বিরুদ্ধে কথা বলতে বলেছিলাম| কিন্তু আপনি তাদের এই নিয়ে তিনবার আশীর্বাদ করেছেন| ");
INSERT INTO ben2006_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","এখন অবিলম্বে আপনি এই স্থান ত্যাগ করে ঘরে পালান! আমি বলেছিলাম যে আমি আপনাকে খুব ভালো পারিশ্রমিক দেব| কিন্তু দেখুন, প্রভু আপনাকে আপনার পুরস্কার থেকে বঞ্চিত করলেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","বিলিয়ম বালাককে বললেন, “স্মরণ করে দেখুন আপনি আমার কাছে লোক পাঠিয়ে যখন আমাকে আসার জন্য বলেছিলেন, তখনই আমি তাদের বলেছিলাম, ");
INSERT INTO ben2006_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘বালাক তার রূপো এবং সোনায় ভরা সবথেকে সুন্দর বাড়ীটি আমায় দিতে পারেন, কিন্তু তবুও আমি কেবল সেই কথাই বলবো যা প্রভু আমাকে বলার জন্য আদেশ করবেন| আমি ভালো কিংবা খারাপ কোনো কিছুই নিজে করতে পারবো না| প্রভু যা আদেশ করবেন, আমি অবশ্যই সেই কথা বলবো|’ ");
INSERT INTO ben2006_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","এখন আমি আমার নিজের লোকদের কাছে ফিরে যাচ্ছি, কিন্তু আমি আপনাকে সতর্কবার্তা দেবো| ইস্রায়েলের এই সমস্ত লোকরা ভবিষ্যতে আপনার এবং আপনার লোকদের সঙ্গে কি করবে সেটা আমি বলে দেবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","তখন বিলিয়ম এই ভাববাণী করে বললেন: “বিয়োরের পুত্র বিলিয়মের কাছ থেকে এই বার্তা, আমি যা স্পষ্ট দেখেছি সে সম্পর্কেই বলছি| ");
INSERT INTO ben2006_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","আমি ঈশ্বরের কাছ থেকে এই বার্তা শুনেছি| পরাৎ‌‌পর আমাকে যা শিখিয়েছেন তা আমি শিখেছি| সর্বশক্তিমান ঈশ্বর আমাকে যা দেখিয়েছেন তা আমি দেখেছি| আমি যা স্পষ্ট দেখেছি সে সম্পর্কে বিনয়ের সঙ্গে বলছি| ");
INSERT INTO ben2006_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“আমি দেখলাম প্রভু আসছেন, কিন্তু এখন নয়| আমি দেখলাম তিনি আসছেন, কিন্তু তাড়াতাড়ি নয়| যাকোবের পরিবার থেকে একজন নক্ষত্র আসবে| ইস্রায়েলের লোকদের মধ্য থেকে একজন নতুন শাসনকর্তা আসবেন| সেই শাসনকর্তা মোয়াবের লোকদের মাথা চূর্ণবিচূর্ণ করে দেবেন| সেই শাসনকর্তা কলহের সকল পুত্রদের মাথা চূর্ণবিচূর্ণ করে দেবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ইস্রায়েল ইদোম দেশ অধিকার করবে এবং সে তার শত্রুর, সেয়ীর দেশটিও অধিকার করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“যাকোবের পরিবার থেকে একজন নতুন শাসনকর্তা আসবেন| সেই শাসনকর্তা সেই শহরের অবশিষ্ট লোকদের ধ্বংস করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","এরপর বিলিয়ম অমালেকীয়দের দেখতে পেয়ে এই ভাববাণী বললেন: “সকল জাতির মধ্যে অমালেক হচ্ছে সবথেকে শক্তিশালী| কিন্তু শেষে তারাও ধ্বংস হয়ে যাবে!” ");
INSERT INTO ben2006_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","এরপর বিলিয়ম কেনীয় লোকদের দেখে এই কথাগুলো বললেন: “তোমরা বিশ্বাস করো যে পর্বতের ওপরের পাখীর বাসার মতোই তোমাদের দেশটিও নিরাপদ| ");
INSERT INTO ben2006_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","কিন্তু প্রভু যেভাবে কেনীয়কে ধ্বংস করেছিলেন, কেনীয় লোকরাও ধ্বংস হয়ে যাবে| অশূর তোমাদের বন্দী করবেন|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","এরপর বিলিয়ম এই ভাববাণী বললেন: “ঈশ্বর যখন এটি করবেন তখন কে বাঁচবে? ");
INSERT INTO ben2006_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","কিত্তীমের থেকে অনেক জাহাজ আসবে| তারা অশূরকে এবং এবরকে পরাজিত করবে| কিন্তু সেই জাহাজগুলোও ধ্বংস হয়ে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","এরপর বিলিয়ম উঠে বাড়ীতে ফিরে গেলেন| এবং বালাক তার নিজের পথে ফিরে গেলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","শিটীমের কাছে ইস্রায়েলের লোকরা শিবির স্থাপন করেছিল| সেই সময় ইস্রায়েলের লোকরা মোয়াবের স্ত্রীলোকের সঙ্গে যৌন পাপে লিপ্ত হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","মোয়াবের স্ত্রীলোকরা লোকদের সেখানে আসার জন্য এবং তাদের মূর্ত্তিদের কাছে উৎসর্গে যোগদানের জন্য আমন্ত্রণ জানালো| সেই কারণে ইস্রায়েলীয়রা মূর্ত্তিদের পূজায যোগদান করল| তারা উৎসর্গীকৃত দ্রব্যসামগ্রী খেয়ে সেই মূর্ত্তিদের পূজাও করল| এইভাবে ইস্রায়েলের লোকরা বাল্-পিয়োরের মূর্ত্তির পূজা শুরু করল| তাই প্রভু তাদের ওপর প্রচণ্ড ক্রুদ্ধ হলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","প্রভু মোশিকে বললেন, “এইসব লোকদের সমস্ত নেতাদের নিয়ে এসো এবং তাদের প্রভুর সামনে হত্যা কর যাতে সমস্ত লোকরা দেখতে পায়| তাহলে প্রভু ইস্রায়েলের সমস্ত লোকদের বিরুদ্ধে তাঁর ক্রোধ প্রকাশ করবেন না|” ");
INSERT INTO ben2006_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","সেই কারণে মোশি ইস্রায়েলের বিচারকদের বললেন, “তোমরা প্রত্যেকে তোমাদের পরিবারগোষ্ঠী থেকে সেই লোকগুলিকে খুঁজে হত্যা করো যারা পিয়োরের বালের মূর্ত্তি পূজা করেছে|” ");
INSERT INTO ben2006_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","আর দেখ ঠিক সেই সময় একজন ইস্রায়েলীয় এক মিদিয়নীয়া স্ত্রীলোককে বাড়ীতে তার পরিবারের কাছে নিয়ে এল| সেখানে মোশি এবং অন্যান্য নেতারা যাতে এ সব দেখতে পান সেই জন্যই সে এটি করল| সেই সময় মোশি এবং অন্যান্য ইস্রায়েলীয়রা সমাগম তাঁবুর প্রবেশ পথে কাঁদছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ইলিয়াসরের পুত্র এবং যাজক হারোণের পৌত্র ছিলেন পীনহস| পীনহস ইস্রায়েলীয় লোকটিকে স্ত্রীলোকটিকে সঙ্গে নিয়ে শিবিরে আসতে দেখেছিলেন, সেজন্য তিনি সমাবেশ ত্যাগ করে তাঁর বর্শা নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","তারপর ইস্রায়েলীয় লোকটিকে অনুসরণ করে তাঁবুতে গিয়ে তাঁর বর্শার সাহায্যে সেই ইস্রায়েলীয় লোকটিকে এবং সেই মিদিয়নীয়া স্ত্রীলোকটিকে হত্যা করলেন| তিনি তাদের দুজনের পেটের ভিতরে বর্শাটিকে ঢুকিয়ে দিলেন| তাতে ইস্রায়েলের লোকদের মধ্যে যে সাংঘাতিক মহামারী শুরু হয়েছিল তা থেমে গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","মোট 24,000 লোক এই মহামারীতে মারা গিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“আমি আমার লোকদের অন্তর্জ্বালায় জ্বলছি; আমি চাই তারা কেবলমাত্র আমার থাকবে| যাজক হারোণের পৌত্র ইলিয়াসরের পুত্র পীনহস ইস্রায়েলের লোকদের আমার আক্রোশ থেকে বাঁচিয়েছে| সুতরাং আমি যেভাবে চেয়েছিলাম সেভাবে তাদের হত্যা করব না| ");
INSERT INTO ben2006_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","পীনহসকে বলো যে, আমি তার সঙ্গে শান্তির চুক্তি করবো| ");
INSERT INTO ben2006_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","এটি হলো চুক্তি; সে এবং তারপরে তার পরিবারের সদস্যরা সকল সময়ই যাজক হবে, কারণ ঈশ্বর সম্পর্কে তার এক তীব্র টান আছে এবং সে এমন কাজ করেছে যাতে ইস্রায়েলের লোকরা পবিত্র হয়!” ");
INSERT INTO ben2006_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","মিদিয়নীয়া স্ত্রীলোকটির সঙ্গে যে ইস্রায়েলীয় লোকটি হত হয়েছিল সে ছিল সালুর পুত্র সিম্রি| সে শিমিয়োনের পরিবারগোষ্ঠীর একটি পরিবারের নেতা ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","যে মিদিয়নীয়া স্ত্রীলোকটি হত হয়েছিল তার নাম ছিল কস্বী| সে ছিল সূরের কন্যা| সূর একটি পরিবারের কর্তা ছিলেন এবং একটি মিদিয়নীয় পরিবারগোষ্ঠীর নেতা ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“মিদিয়নীয় লোকদের প্রতি শত্রু মনোভাব পোষণ কর এবং তাদের হত্যা করো| ");
INSERT INTO ben2006_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","কারণ তারা তোমার সাথে শত্রুতা করেছে| তারা তোমাকে পিয়োরে প্রতারিত করেছিল| এবং তারা কস্বী নামক একজন স্ত্রীলোকের দ্বারা তোমাকে প্রতারিত করেছিল| সে ছিল এক মিদিয়নীয়া নেতার কন্যা| কিন্তু যখন ইস্রায়েলীয়দের মধ্যে অসুস্থতা দেখা দেয় সেই সময় তাকে হত্যা করা হয়েছিল| যখন লোকরা প্রতারিত হয়ে পিয়োরের বালের মূর্ত্তি পূজা করেছিল সেই সময় তাদের মধ্যে অসুস্থতা দেখা দিয়েছিল|” ");
INSERT INTO ben2006_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","সেই সাংঘাতিক অসুস্থতার পরে, প্রভু মোশি এবং যাজক হারোণের পুত্র ইলিয়াসরের সঙ্গে কথা বললেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","তিনি বললেন, “ইস্রায়েলের লোকদের গণনা কর| 20 বছর অথবা তার বেশী বয়স্ক সকল পুরুষের সংখ্যা গণনা করো এবং তাদের পরিবার অনুযায়ী তালিকাভুক্ত করো| এই পুরুষরা ইস্রায়েলের সেনাবাহিনীতে সেবা করার যোগ্যতাসম্পন্ন|” ");
INSERT INTO ben2006_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","এই সময় লোকরা মোয়াবের যর্দন উপত্যকায় শিবির স্থাপন করেছিল| এই স্থানটি ছিল যিরীহোর অপর পারে যর্দন নদীর কাছে| সুতরাং মোশি এবং যাজক ইলিয়াসর লোকদের বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“তোমরা অবশ্যই 20 বছর অথবা তার বেশী বয়স্ক পুরুষদের সংখ্যা গণনা করবে| মিশর দেশ থেকে বেরিয়ে আসার সময় প্রভু মোশিকে এবং ইস্রায়েলের লোকদের যেভাবে আজ্ঞা করেছিলেন, সেভাবেই করো|” ");
INSERT INTO ben2006_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","এই সব লোকরা ছিল রূবেণের পরিবারের অন্তর্ভূক্ত| (রূবেণ ছিলেন ইস্রায়েলের প্রথমজাত পুত্র|) পরিবারগুলো ছিল: হনোক হতে হনোকীয় পরিবার| পল্লু হতে পল্লুয়ীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","হিষ্রোণ হতে হিষ্রোণীয় পরিবার| কর্ম্মি হতে র্কম্মীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ঐ পরিবারগুলো ছিল রূবেণের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে মোট 43,730 জন পুরুষ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","পল্লুর পুত্র ছিলেন ইলীয়াব| ");
INSERT INTO ben2006_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ইলীয়াবের তিন পুত্র নমূয়েল, দাথন এবং অবীরাম| দাথন এবং অবীরাম ছিলেন সেই দুজন নেতা, যারা মোশি এবং হারোণের বিরোধিতা করেছিলেন| কোরহ যখন প্রভুর বিরুদ্ধে গিয়েছিলেন সে সময় তারা কোরহকে অনুসরণ করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","সেই সময় পৃথিবীর মাটি বিদীর্ণ হয়ে কোরহ ও তার অনুসরণকারীদের গ্রাস করেছিল| এবং 250 জন পুরুষ মারা গিয়েছিল| সেটি ইস্রায়েলের লোকদের প্রতি একটি সতর্কবাণী ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","কিন্তু কোরহের সন্তানরা মারা যান নি| ");
INSERT INTO ben2006_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","এই পরিবারগুলি হল শিমিয়োনের পরিবারগোষ্ঠীর অন্তর্ভুক্ত: নমূয়েল হতে নমূয়েলীয় পরিবার| যামীন হতে যামীনীয় পরিবার| যাখীন হতে যাখীনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","সেরহ হতে সেরহীয় পরিবার| শৌল হতে শৌলীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ঐ পরিবারগুলি ছিল শিমিয়োনের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে মোট 22,200 জন পুরুষ ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","এই পরিবারগুলো হল গাদের পরিবারগোষ্ঠীর অন্তর্ভুক্ত: সিফোন হতে সিফোনীয় পরিবার| হগি হতে হগীয় পরিবার| শূনি হতে শূনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ওষ্ণি হতে ওষ্ণীয় পরিবার| এরি হতে এরীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","আরোদ হতে আরোদীয় পরিবার| অরোলি হতে অরোলীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ঐ পরিবারগুলি ছিল গাদের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে মোট 40,500 জন পুরুষ ছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","এই পরিবারগুলি ছিল যিহূদার পরিবারগোষ্ঠীর অন্তর্ভুক্ত: শেলা হতে শেলায়ীয় পরিবার| পেরস হতে পেরসীয় পরিবার| সেরহ হতে সেরহীয় পরিবার| যিহূদার পুত্রদের মধ্যে দুজন, এর এবং ওনন কনান দেশে মারা গিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","এই পরিবারগুলো হল পেরসের বংশধর: হিষ্রোণ হতে হিষ্রোণীয় পরিবার| হামুল হতে হামুলীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ঐ পরিবারগুলি ছিল যিহূদার পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে পুরুষদের মোট সংখ্যা ছিল 76,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ইষাখরের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলো ছিল: তোলয় হতে তোলয়ীয় পরিবার| পূয় হতে পূনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","যাশূর হতে যাশূরীয় পরিবার| শিম্রোণ হতে শিম্রোনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ঐ পরিবারগুলি ইষাখরের পরিবারগোষ্ঠীর অন্তর্ভুক্ত ছিল| সেখানে পুরুষদের মোট সংখ্যা ছিল 64,300 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","সবূলূনের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলি ছিল: সেরদ হতে সেরদীয় পরিবার| এলোন হতে এলোনীয় পরিবার| যহলেল হতে যহলেলীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ঐ পরিবারগুলি ছিল সবূলূনের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে পুরুষদের মোট সংখ্যা ছিল 60,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","যোষেফের দুই পুত্র ছিল মনঃশি এবং ইফ্রয়িম| প্রত্যেক পুত্রই তাদের নিজেদের পরিবারদের নিয়ে একটি গোষ্ঠী হয়ে উঠেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","মনঃশি পরিবারগুলি ছিল: মাখীর হতে মাখীরীয় পরিবার| (মাখীর ছিলেন গিলিয়দের পিতা|) গিলিয়দ হতে গিলিয়দীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","গিলিয়দের পরিবারগুলো ছিল: ঈয়েষর হতে ঈয়েষরীয় পরিবার| হেলক হতে হেলকীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","অস্রীয়েল হতে অস্রীয়েলীয় পরিবার| শেখম হতে শেখমীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","শিমীদা হতে শিমীদায়ীয় পরিবার| হেফর হতে হেফরীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","সলফাদ ছিলেন হেফরের পুত্র| কিন্তু তার কোনো পুত্র ছিল না| কেবল কন্যারা ছিল| তার কন্যাদের নাম ছিল মহলা, নোয়া, হগ্লা, মিল্কা এবং তির্সা| ");
INSERT INTO ben2006_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ঐ পরিবারগুলোর সবগুলোই ছিল মনঃশি পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে পুরুষদের মোট সংখ্যা ছিল 52,700 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ইফ্রয়িমের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলো ছিল: শূথলহ হতে শূথলহীয় পরিবার| বেখর হতে বেখরীয় পরিবার| তহন হতে তহনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","শূথলহের পরিবার থেকে এরণ এসেছিল আর এরণ থেকে এসেছিল এরণীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ঐ পরিবারগুলো ছিল ইফ্রয়িম পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে মোট 32,500 জন পুরুষ ছিলেন| ঐসব লোকদের সকলেই ছিলেন ষোষেফের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| ");
INSERT INTO ben2006_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","বিন্যামীনের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলি ছিল: বেলা হতে বেলায়ীয় পরিবার| অস্বেল হতে অস্বেলীয় পরিবার| অহীরাম হতে অহীরামীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","শূফম থেকে শূফমীয় পরিবার| হূফম থেকে হূফমীয পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","বেলার পরিবারগুলি ছিল: অর্দ হতে অর্দীয় পরিবার| নামান থেকে নামানীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ঐ পরিবারগুলি সবাই ছিল বিন্যামীন পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে পুরুষদের মোট সংখ্যা ছিল 45,600 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","দানের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলো ছিল: শূহম হতে শূহমীয় গোষ্ঠী| ঐ পরিবারগোষ্ঠীটি ছিল দানের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| ");
INSERT INTO ben2006_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","শূহমীয় পরিবারগোষ্ঠীতে অনেক পরিবার ছিল| সেখানে পুরুষদের মোট সংখ্যা ছিল 64,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","আশেরের পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলি ছিল: যিম্ন হতে যিম্নীয় পরিবার| যিস্বি হতে যিস্বীয় পরিবার| বরিয় হতে বরিয়ীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","বরিয়র পরিবারগুলি ছিল: হেবর হতে হেবরীয় পরিবার| মল্কীয়েল হতে মল্কীয়েলীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(আশেরের সারহ নামের এক কন্যাও ছিল|) ");
INSERT INTO ben2006_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ঐ পরিবারগুলি ছিল আশেরের পরিবারগোষ্ঠীর অন্তর্ভুক্ত| সেখানে পুরুষদের মোট সংখ্যা ছিল 53,400 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","নপ্তালি পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলি ছিল: যহসীয়েল হতে যহসীয়েলীয় পরিবার| গুনি হতে গুনীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","যেৎ‌সর হতে যেৎ‌সরীয় পরিবার| শিল্লেম হতে শিল্লেমীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ঐ পরিবারগুলো নপ্তালির পরিবারগোষ্ঠীর অন্তর্ভুক্ত ছিল| সেখানে পুরুষদের মোট সংখ্যা ছিল 45,500 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","সুতরাং ইস্রায়েলীয় পুরুষদের মোট সংখ্যা ছিল 601,730 জন| ");
INSERT INTO ben2006_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“দেশ ভাগ করা হবে এবং এই লোকদের সেগুলো দেওয়া হবে| প্রত্যেক পরিবারগোষ্ঠী তাদের সংখ্যা অনুসারে জমি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","বড় পরিবার বেশী জমি পাবে এবং ছোট পরিবার কম জমি পাবে| যার যত লোক তাকে ততটা অধিকার দাও| ");
INSERT INTO ben2006_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","কিন্তু কোন পরিবার জমির কোন অংশ পাবে সেটি ঠিক করার জন্যে তুমি অবশ্যই ঘুঁটি চালবে| প্রত্যেক পরিবারগোষ্ঠী তার অংশের যে জমি পাবে, সেই জমিকে সেই পরিবারগোষ্ঠীর নাম দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","জমি বড় বা ছোট যাই হোক্ না কেন তুমি সিদ্ধান্ত নেওয়ার জন্য ঘুঁটি চালবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","তারা লেবীয় গোষ্ঠীকেও গণনা করেছিল| লেবীয় পরিবারগোষ্ঠীর অন্তর্ভুক্ত পরিবারগুলি হল: গের্শোন হতে গের্শোনীয় পরিবার| কহাত্‌ হতে কহাতীয় পরিবার| মরারি হতে মরারীয় পরিবার| ");
INSERT INTO ben2006_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","এই পরিবারগুলোও লেবীয় পরিবারের অন্তর্ভুক্ত: লিব্নীয় পরিবার| হিব্রোনীয় পরিবার| মহলীয়় পরিবার| মূশীয় পরিবার| কোরহীয় পরিবার| অম্রাম ছিলেন কহাত্‌ পরিবারের অন্তর্ভক্ত| ");
INSERT INTO ben2006_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","অম্রামের স্ত্রীর নাম ছিল যোকেবদ| তিনি নিজেও ছিলেন লেবীয় পরিবারগোষ্ঠীর অন্তর্ভুক্ত| তাঁর জন্ম হয়েছিল মিশরে| অম্রাম এবং যোকেবদের দুই পুত্র ছিল হারোণ এবং মোশি| তাদের মরিয়ম নামে একটি কন্যাও ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হারোণ ছিলেন নাদব, অবীহূ, ইলিয়াসর এবং ঈথামরের পিতা| ");
INSERT INTO ben2006_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","কিন্তু নাদব এবং অবীহূ মারা গিয়েছিলেন কারণ তারা প্রভুকে যে ধরণের আগুন দিয়ে নৈবেদ্য প্রদান করেছিলেন তা করা বারণ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","লেবীয় পরিবারগোষ্ঠীর পুরুষদের মোট সংখ্যা ছিল 23,000 জন| কিন্তু ইস্রায়েলের অন্যান্য লোকদের সঙ্গে এদের গণনা করা হয় নি| প্রভু অন্যান্য লোকদের যে জমি দিয়েছিলেন তার কোনো অংশ তাঁরা পান নি| ");
INSERT INTO ben2006_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","মোয়াবের যর্দন উপত্যকায় থাকাকালীন মোশি এবং যাজক ইলিয়াসর ইস্রায়েলের লোকদের গণনা করেছিলেন| এই জায়গাটি ছিল যিরীহোর অপর পারে যর্দন নদীর কাছে| ");
INSERT INTO ben2006_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","কিন্তু বহু বছর আগে সীনয় মরুভূমিতে মোশি এবং যাজক হারোণ যখন ইস্রায়েলের সমস্ত লোকদের গণনা করেছিলেন তখন যারা গণিত হয়েছিল তাদের একজনও এর মধ্যে ছিল না| ঐ সব লোকদের আর কেউই জীবিত ছিলেন না| ");
INSERT INTO ben2006_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","কেন? কারণ প্রভু ইস্রায়েলের ঐ সমস্ত লোকদের বিষয়ে বলেছিলেন যে, তারা সকলেই মরুভূমিতে মারা যাবে| কেবল দুজন ব্যক্তি বেঁচে ছিলেন| তারা হলেন যিফুন্নির পুত্র কালেব এবং নূনের পুত্র যিহোশূয়| ");
INSERT INTO ben2006_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","সলফাদ ছিলেন হেফরের পুত্র| হেফর ছিলেন গিলিয়দের পুত্র| গিলিয়দ ছিলেন মাখীরের পুত্র| মাখীর মনঃশির পুত্র| মনঃশি যোষেফের পুত্র ছিলেন| সলফাদের পাঁচ কন্যা ছিল| তাদের নাম ছিল মহলা, নোয়া, হগ্লা, মিল্কা এবং তির্সা| ");
INSERT INTO ben2006_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","এরা সমাগম তাঁবুর প্রবেশ পথে মোশি, যাজক ইলিয়াসর, অন্যান্য নেতা এবং ইস্রায়েলের সমস্ত লোকদের সামনে দাঁড়িয়ে বলল, ");
INSERT INTO ben2006_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“আমরা যখন মরুভুমির মধ্য দিয়ে ভ্রমণ করছিলাম সে সময় আমাদের পিতা মারা গিয়েছিলেন| তিনি কোরহ দলে যোগদানকারী লোকদের মধ্যে ছিলেন না| (যে কোরহ প্রভুর বিরোধিতা করেছিলেন|) কিন্তু আমাদের পিতা নিজ পাপে মারা গিয়েছিলেন| আমাদের পিতার কোনো পুত্র নেই| ");
INSERT INTO ben2006_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","এর অর্থ হল এই যে, আমাদের পিতার নাম লোপ পাবে| এটা ঠিক নয় যে আমাদের পিতার কোনো পুত্র নেই বলে তার নাম শেষ হয়ে যাবে| সুতরাং আমাদের পিতার ভাইরা যে জমি পাবে তার কিছুটা অন্ততঃ যাতে আমরা পাই তার জন্য আমরা আপনাদের কাছে প্রার্থনা করছি|” ");
INSERT INTO ben2006_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","সেই কারণে মোশি প্রভুকে জিজ্ঞেস করেছিলেন যে তার কি করা উচিৎ‌ হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","প্রভু তাকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“সলফাদ এর মেয়েরা ঠিক বলেছে| তাদের পিতার ভাইদের জমির অংশ ভাগ করে নেওয়াই তাদের উচিৎ‌ হবে| সুতরাং যে জমিটা তুমি তাদের পিতাকে দিতে, সেই জমিটা তুমি ওদের দিয়ে দাও| ");
INSERT INTO ben2006_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“সুতরাং ইস্রায়েলের লোকদের জন্য এটিকে বিধি করে নাও| ‘যদি কোন ব্যক্তির কোনো পুত্র সন্তান না থাকে এবং সে মারা যায়, তাহলে তার যা কিছু আছে সে সব কিছুই তার মেয়েকে দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","10","যদি তার কোনো মেয়ে না থাকে, তাহলে তার সমস্ত কিছুই তার ভাইদের দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","যদি তার পিতার কোনো ভাই না থাকে তাহলে তার যা কিছু আছে সে সমস্তই তার পরিবারের ঘনিষ্ঠ আত্মীয়কে দেওয়া হবে| ইস্রায়েলের লোকদের জন্য এটিই আইন| প্রভু মোশিকে এই আদেশ দিলেন|’” ");
INSERT INTO ben2006_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","তখন প্রভু মোশিকে বললেন, “যর্দন নদীর পূর্বদিকের মরুভূমিতে যে কোনো একটি পর্বতের ওপরে যাও| ইস্রায়েলের লোকদের আমি যে দেশ দিচ্ছি সেটা তুমি দেখতে পাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","সেই দেশ দেখার পরে তুমি তোমার ভাই হারোণের মতো মারা যাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","মনে করে দেখো যখন লোকরা সীন মরুভূমিতে তৃষ্ণায় বিচলিত হয়েছিল তখন তুমি এবং হারোণ দুজনেই আমার আজ্ঞা পালন করতে অস্বীকার করেছিলে| তুমি আমাকে সম্মান দাও নি এবং লোকদের দেখাও নি যে আমি পবিত্র|” (সীন মরুভূমির কাদেশের কাছে মরীবার জলের কাছে এই ঘটনা ঘটে|) ");
INSERT INTO ben2006_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","মোশি প্রভুকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“প্রভু ঈশ্বর আপনি সকল মানুষের চিন্তা জানেন| আমি প্রার্থনা করি যেন আপনি এই সমস্ত লোকদের জন্য একজন নেতা মনোনীত করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","যিনি তাদের এই দেশ থেকে বাইরে এনে নতুন দেশে নিয়ে যাবেন| তাহলে প্রভুর লোকরা মেষপালকহীন মেষের মতো হবে না|” ");
INSERT INTO ben2006_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","সুতরাং প্রভু মোশিকে বললেন, “নূনের পুত্র যিহোশূয় নতুন নেতা হবে| সে খুবই জ্ঞানী| তাকে নতুন নেতা করো| ");
INSERT INTO ben2006_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","তাকে যাজক ইলিয়াসর এবং সকল লোকের সামনে দাঁড়াতে বলো| এরপর তাকে নতুন নেতা করো| ");
INSERT INTO ben2006_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“লোকদের দেখিয়ে দাও যে তুমি তাকে নেতা করছ| তাহলে সমস্ত লোক তাকে মান্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","যিহোশূয় যদি কোনো সিদ্ধান্ত নেওয়ার প্রয়োজন অনুভব করে তবে সে যাজক ইলিয়াসরের কাছে যাবে| ইলিয়াসর প্রভুর উত্তর জানার জন্য উরীমের সাহায্য নেবে| তখন ঈশ্বরের কথামতো যিহোশূয় এবং ইস্রায়েলের সমস্ত লোকরা কাজ করবে| যদি তিনি বলেন, ‘যুদ্ধে যাও’ তাহলে তারা যুদ্ধে যাবে| এবং যদি তিনি বলেন, ‘ঘরে যাও’ তাহলে তারা ঘরে যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","মোশি প্রভুর আজ্ঞা পালন করলেন| মোশি যিহোশূয়কে যাজক ইলিয়াসর এবং ইস্রায়েলের সমস্ত লোকদের সামনে দাঁড়াতে বললেন| ");
INSERT INTO ben2006_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","এরপর যিহোশূয় যে নতুন নেতা সেটি দেখানোর জন্য মোশি তার ওপরে দু’হাত রাখলেন| প্রভু তাকে যে ভাবে বলেছিলেন সেভাবেই তিনি এই কাজটি করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","এরপর প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ইস্রায়েলের লোকদের এই আজ্ঞা কর| তাদের বলো যে ঠিক সময়ে শস্যের নৈবেদ্য এবং উৎসর্গ দেওয়ার ব্যাপারে তারা যেন নিশ্চিত হয়| ঐ নৈবেদ্যগুলি আগুনের সাহায্যে তৈরী করতে হবে| তাদের সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","তারা অবশ্যই আগুনের সাহায্যে তৈরী করে এই নৈবেদ্যগুলি প্রভুকে দেবে| প্রত্যেকদিন এক বছর বয়স্ক 2টি মেষশাবক দেবে| সেই মেষশাবক 2 টির যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ঐ মেষশাবক দুটির মধ্যে একটিকে সকালে এবং অপরটিকে গোধুলি বেলায় উৎসর্গ করো| ");
INSERT INTO ben2006_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","এছাড়াও 1 কোয়ার্ট অলিভ তেলের সঙ্গে 8 কাপ খুব মিহি ময়দা মিশ্রিত করে দানাশস্যের নৈবেদ্যও দাও|” ");
INSERT INTO ben2006_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(সীনয় পর্বতের ওপরে তারা তাদের দৈনিক নৈবেদ্য দেওয়া শুরু করল| সেই নৈবেদ্যগুলি আগুনের সাহায্যে তৈরী হল এবং তাদের সুগন্ধ প্রভুকে খুশী করল|) ");
INSERT INTO ben2006_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","“লোকরা এছাড়াও অবশ্যই পেয় নৈবেদ্য প্রদান করবে যেটা আগুনের সাহায্যে তৈরী নৈবেদ্যর সঙ্গেই খাবে| তারা অবশ্যই প্রত্যেকটি মেষশাবকের সঙ্গে 1 কোয়ার্ট করে দ্রাক্ষারস দেবে| পবিত্র স্থানে বেদীর ওপরে সেই পেয় নৈবেদ্য ঢেলে দেবে| এটি প্রভুর কাছে একটি উপহার| ");
INSERT INTO ben2006_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","দ্বিতীয় মেষশাবকটিকে গোধুলি বেলায় উৎসর্গ করো| এটিকে শস্য নৈবেদ্য ও পেয় নৈবেদ্যর সাথে সকালের নৈবেদ্যর মতোই উৎসর্গ করো| এই নৈবেদ্য আগুনের সাহায্যে তৈরী হবে| এর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“বিশ্রামের দিন তুমি অবশ্যই এক বছর বয়স্ক 2টি মেষশাবক দেবে| তাদের যেন কোনো খুঁত না থাকে| এছাড়াও তুমি অবশ্যই অলিভ তেলে মিশ্রিত 16 কাপ খুব ভালো ময়দার সাহায্যে তৈরী শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","এটি এই বিশ্রামের দিনের জন্য বিশেষ নৈবেদ্য| নিয়মিত যে নৈবেদ্য এবং পেয় নৈবেদ্য দেওয়া হয় তার সাথে এটি অতিরিক্ত নৈবেদ্য হিসেবে গণ্য হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“প্রত্যেক মাসের প্রথম দিনটিকে তুমি প্রভুকে একটি বিশেষ হোমবলি উৎসর্গ করবে| এই নৈবেদ্যটি হবে এক বছর বয়স্ক 2 টি ষাঁড়, 1 টি মেষ এবং 7 টি মেষশাবক| তাদের যেন অবশ্যই কোন খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","প্রত্যেকটি ষাঁড়ের সঙ্গে তুমি অবশ্যই অলিভ তেলে মিশ্রিত 24 কাপ খুব মিহি ময়দার শস্য নৈবেদ্য উৎসর্গ করবে এবং মেষের সঙ্গে তুমি অবশ্যই অলিভ তেলে মিশ্রিত 16 কাপ খুব মিহি ময়দা দিয়ে তৈরী শস্যের নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","এছাড়াও প্রত্যেকটি মেষশাবকের সঙ্গে অলিভ তেলে মিশ্রিত 8 কাপ খুব মিহি ময়দা দিয়ে তৈরী দানা শস্যের নৈবেদ্য দেবে| এই নৈবেদ্যটি আগুনের সাহায্যে তৈরী হবে| এর সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","প্রত্যেকটি ষাঁড়ের সঙ্গে 2 কোয়ার্ট করে দ্রাক্ষারস, মেষের সঙ্গে 1-1/4 কোয়ার্ট দ্রাক্ষারস এবং প্রত্যেক মেষশাবকের সঙ্গে 1 কোয়ার্ট করে দ্রাক্ষারস পেয় নৈবেদ্য হিসেবে দিতে হবে| বছরের প্রত্যেক মাসে হোমবলি হিসেবে ঐগুলি অবশ্যই উৎসর্গ করতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","নিয়মিত দৈনিক হোমবলি এবং পেয় নৈবেদ্য ছাড়াও তুমি অবশ্যই প্রভুকে একটি পুরুষ ছাগল দেবে| ঐ ছাগলটি হবে পাপার্থক নৈবেদ্য| ");
INSERT INTO ben2006_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“প্রথম মাসের 14 তম দিনটি হবে প্রভুর নিস্তারপর্ব উদযাপনের দিন| ");
INSERT INTO ben2006_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ঐ মাসের 15তম দিনে খামিরবিহীন রুটির উৎসব হবে| এই সাত দিন ধরে তোমরা খামিরবিহীন রুটি খাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","এই ছুটির প্রথম দিনটিতে অবশ্যই তোমাদের একটি বিশেষ সভা হবে| ঐ দিনে তোমরা কোনো শ্রমসাধ্য কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","তোমরা প্রভুকে হোমের জন্য নৈবেদ্য দেবে| হোমবলির নৈবেদ্যগুলো হবে 2টি ষাঁড়, 1টি মেষ এবং 7টি এক বছর বয়স্ক মেষশাবক| তাদের অবশ্যই যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","21","এছাড়াও তোমরা অবশ্যই প্রত্যেকটি ষাঁড়ের সঙ্গে শস্য নৈবেদ্য হিসাবে অলিভ তেলে মিশ্রিত 24 কাপ খুব মিহি ময়দা, মেষের সঙ্গে শস্য নৈবেদ্য হিসাবে তেলে মিশ্রিত 16 কাপ খুব মিহি ময়দা এবং প্রত্যেকটি মেষশাবকের সঙ্গে শস্য নৈবেদ্য হিসাবে তেলে মিশ্রিত 8 কাপ খুব মিহি ময়দা দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","এছাড়াও তোমরা অবশ্যই 1টি পুরুষ ছাগল দেবে| তোমাদের পবিত্র করার জন্য ছাগলটি পাপের নৈবেদ্য হিসেবে দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","প্রতিদিন সকালে তোমরা পোড়ানোর জন্য যে নৈবেদ্য দাও সেটা ছাড়াও তোমরা অবশ্যই ঐ নৈবেদ্যগুলো দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“এই একইভাবে সাত দিনের প্রত্যেকদিন তোমরা অবশ্যই আগুনের সাহায্যে তৈরী নৈবেদ্য এবং তার সঙ্গে পেয় নৈবেদ্য প্রভুকে দেবে| এই সমস্ত নৈবেদ্যর সুগন্ধ প্রভুকে খুশী করবে| প্রত্যেক দিনের হোমবলির সাথে এই নৈবেদ্যগুলো তোমরা অবশ্যই দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“আর সপ্তম দিনে তোমাদের আরেকটি বিশেষ সভা অনুষ্ঠিত হবে| ঐ দিনে তোমরা কোনো কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“সাত সপ্তাহের উৎসব চলাকালীন প্রথম ফসলের দিন যখন তোমরা প্রভুর কাছে নতুন ফসলের শস্য নৈবেদ্য নিয়ে আসবে সেই সময় একটি পবিত্র সভা হবে| ঐ দিনে তোমরা অবশ্যই কোনো কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","তোমরা অবশ্যই হোমবলি উৎসর্গ করবে| এই নৈবেদ্যটি আগুনের সাহায্যে তৈরী হবে| এর সুগন্ধ প্রভুকে খুশী করবে| তোমরা অবশ্যই 2টি ষাঁড়, 1টি মেষ এবং 7টি এক বছর বয়স্ক মেষশাবক উৎসর্গ করবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","তোমরা অবশ্যই প্রত্যেকটি ষাঁড়ের সঙ্গে তেলে মেশানো 24 কাপ খুব মিহি ময়দা, প্রত্যেকটি মেষের সঙ্গে 16 কাপ এবং ");
INSERT INTO ben2006_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","প্রত্যেকটি মেষশাবকের সঙ্গে 8 কাপ খুব মিহি ময়দা দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","নিজেদের পবিত্র করার জন্য তোমরা অবশ্যই 1টি পুরুষ ছাগল উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","দৈনিক হোমবলি এবং শস্য নৈবেদ্য ছাড়াও তোমরা ঐ নৈবেদ্যগুলো অবশ্যই দেবে| এ ব্যাপারে অবশ্যই নিশ্চিত হবে যে, যে প্রাণীগুলি বলি দেবে সেগুলির মধ্যে যেন কোনো খুঁত না থাকে এবং সেগুলির সাথে যেন পেয় নৈবেদ্য দেওয়া হয়| ");
INSERT INTO ben2006_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“সপ্তম মাসের প্রথম দিনটিতে একটি পবিত্র সভা অনুষ্ঠিত হবে| ঐ দিনে তোমরা কোনো শ্রমসাধ্য কাজ করবে না| শিঙা বাজানোর জন্য ঐ দিনটি নির্দিষ্ট হয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","তোমরা হোমবলি উৎসর্গ করবে| তাদের সুগন্ধ প্রভুকে খুশী করবে| তোমরা 1টি ষাঁড়, 1টি মেষ এবং 7টি এক বছর বয়স্ক মেষশাবক উৎসর্গ করবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","তোমরা ষাঁড়ের সঙ্গে 24 কাপ তেল মেশানো খুব মিহি ময়দা, পুং মেষের সঙ্গে 16 কাপ ");
INSERT INTO ben2006_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","এবং 7টি মেষশাবকের প্রত্যেকটির সঙ্গে 8 কাপ করে শস্য নৈবেদ্য উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","এছাড়াও নিজেদের পবিত্র করার জন্য পাপের নৈবেদ্যস্বরূপ 1টি পুরুষ ছাগল উৎসর্গ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","অমাবস্যার দিনের উৎসর্গ এবং তার শস্যের নৈবেদ্য ছাড়াও এই নৈবেদ্যগুলি অতিরিক্ত এবং দৈনিক উৎসর্গ এবং তার শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য ছাড়াও এগুলো অতিরিক্ত| ঐগুলো অবশ্যই নিয়মানুযায়ী করতে হবে| ঐ নৈবেদ্যগুলো অবশ্যই আগুনের সাহায্যে তৈরী করা হবে| তাদের সুগন্ধ প্রভুকে খুশী করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“সপ্তম মাসের দশম দিনটিতে একটি বিশেষ সভা হবে| ঐ দিনটিতে তোমরা অবশ্যই কোনো খাবার খাবে না এবং তোমরা অবশ্যই কোনো শ্রমসাধ্য কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","তোমরা হোমবলি উৎসর্গ করবে| তাদের সুগন্ধ প্রভুকে খুশী করবে| তোমরা অবশ্যই 1টি ষাঁড়, 1টি পুং মেষ এবং 7টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন অবশ্যই কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","10","তোমরা অবশ্যই ষাঁড়ের সঙ্গে অলিভ তেলে মিশ্রিত 24 কাপ খুব মিহি ময়দা, মেষের সঙ্গে 8 কাপ করে নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","এছাড়াও পাপের নৈবেদ্যস্বরূপ 1 টি পুরুষ ছাগলও উৎসর্গ করবে| প্রায়শ্চিত্তের দিনের পাপের উৎসর্গের সাথে এটিও যোগ করবে| দৈনিক উৎসর্গ শস্য নৈবেদ্য এবং পেয় নৈবেদ্যর সাথে অতিরিক্ত হিসেবে এই নৈবেদ্যটিও দেওয়া হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“সপ্তম মাসের 15তম দিনে একটি বিশেষ সভা অনুষ্ঠিত হবে| এটিই কুটিরবাস পর্ব| ঐ দিনে তোমরা কোনো শ্রমসাধ্য কাজ করবে না| তোমরা অবশ্যই প্রভুর সম্মানার্থে ঐ সাতদিন ধরে উৎসব পালন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","তোমরা হোমবলি প্রদান করবে| ঐ নৈবেদ্যগুলো আগুনের সাহায্যে তৈরী হবে| তাদের সুগন্ধ প্রভুকে খুশী করবে| তোমরা 13টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের অবশ্যই যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","তোমরা অবশ্যই 13টি ষাঁড়ের প্রত্যেকটির জন্য তেলে মিশ্রিত 24 কাপ খুব মিহি ময়দা, 2টি মেষের প্রত্যেকটির জন্য 16 কাপ করে ");
INSERT INTO ben2006_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","এবং 14টি মেষশাবকের প্রত্যেকটির জন্য 8 কাপ করে নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","এছাড়াও তোমরা 1টি পুরুষ ছাগলও নৈবেদ্য দেবে| এটি অবশ্যই দৈনিক উৎসর্গ শস্যের নৈবেদ্য এবং পেয় নৈবেদ্যর সাথে অতিরিক্ত হিসাবে যোগ করা হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“এই উৎসবের দ্বিতীয় দিনে তোমরা অবশ্যই 12টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","এছাড়াও তোমরা অবশ্যই ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","এছাড়াও তোমরা অবশ্যই পাপের উৎসর্গের জন্য 1টি পুরুষ ছাগল নৈবেদ্য হিসেবে দেবে| এটি দৈনিক উৎসর্গ এবং তার জন্য দানাশস্যের নৈবেদ্য এবং পেয় নৈবেদ্য অতিরিক্ত হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“এই উৎসবের তৃতীয় দিনে তোমরা অবশ্যই 11টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন অবশ্যই কোন খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","এছাড়াও তোমরা অবশ্যই ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","এছাড়াও পাপের উৎসর্গের জন্য 1টি পুরুষ ছাগল দেবে| দৈনিক উৎসর্গ শস্যের নৈবেদ্য এবং পেয় নৈবেদ্যর সাথে এটিও যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“এই উৎসবের চতুর্থ দিনে তোমরা অবশ্যই 10টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","এছাড়াও তোমরা অবশ্যই ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","এছাড়াও তোমরা পাপের উৎসর্গের জন্য 1 টি পুরুষ ছাগলও নৈবেদ্য হিসেবে দেবে| দৈনিক উৎসর্গ শস্যের নৈবেদ্য এবং পানীয় নৈবেদ্যর সাথে অবশ্যই এটিও যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“এই উৎসবের পঞ্চম দিনে তোমরা অবশ্যই 9টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","এছাড়াও তোমরা ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","তোমরা পাপের উৎসর্গের জন্য 1টি পুরুষ ছাগলও নৈবেদ্য দেবে| এটি দৈনিক উৎসর্গ, শস্যের নৈবেদ্য এবং পেয় নৈবেদ্যর সাথে এটিও যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“এই উৎসবের ষষ্ঠ দিনে তোমরা 8টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন অবশ্যই কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","এছাড়াও তোমরা ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে শস্যের নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","পাপের উৎসর্গের জন্য তোমরা 1টি পুরুষ ছাগলও নৈবেদ্য হিসেবে দেবে| এটি দৈনিক উৎসর্গ এবং তার সঙ্গে দানাশস্যের নৈবেদ্য এবং পেয় নৈবেদ্য অতিরিক্ত হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“এই উৎসবের সপ্তম দিনে তোমরা অবশ্যই 7টি ষাঁড়, 2টি পুং মেষ এবং 14টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","এছাড়াও তোমরা ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে নৈবেদ্য এবং পেয় নৈবেদ্য দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","পাপের উৎসর্গের জন্য তোমরা অবশ্যই 1টি পুরুষ ছাগলও নৈবেদ্য হিসেবে প্রদান করবে| দৈনিক উৎসর্গ এবং তার জন্য শস্যের নৈবেদ্য এবং পেয় নৈবেদ্যর সাথে এটিও যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“এই উৎসবের শেষ দিনে অর্থাৎ‌ অষ্টম দিন তোমাদের জন্য এক বিশেষ সভা আয়োজিত হবে| ঐ দিনে তোমরা কোনো শ্রমসাধ্য কাজ করবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","তোমরা অবশ্যই সেদিন হোমবলি প্রদান করবে| আগুনের সাহায্যে তৈরী নৈবেদ্যর সুগন্ধ প্রভুকে খুশী করবে| তোমরা অবশ্যই 1টি ষাঁড়, 1টি পুং মেষ এবং 7টি এক বছর বয়স্ক মেষশাবক নৈবেদ্য দেবে| তাদের যেন অবশ্যই কোনো খুঁত না থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","এছাড়াও তোমরা ষাঁড়, মেষ এবং মেষশাবকের সঙ্গে ঠিক পরিমাণে দানাশস্যের নৈবেদ্য এবং পেয় নৈবেদ্য প্রদান করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","পাপের উৎসর্গের জন্য 1টি পুরুষ ছাগলও দেবে| দৈনিক হোমবলি এবং তার সাথে শস্যের নৈবেদ্য এবং পেয় যে নৈবেদ্য দেওয়া হয় সেগুলির সাথে এটিও যোগ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“এই উৎসবের দিনগুলিতে তোমরা অবশ্যই হোমবলি, শস্যের নৈবেদ্য, পেয় নৈবেদ্য এবং মঙ্গল নৈবেদ্য, নিয়ে আসবে এবং ঐ নৈবেদ্যগুলি প্রভুকে প্রদান করবে| যে কোনো প্রকার বিশেষ উপহার, যা তোমরা প্রভুকে প্রদান করতে চাও এবং যে কোনো প্রকার নৈবেদ্য যা তোমাদের বিশেষ প্রতিজ্ঞার একটি অঙ্গ, তার অতিরিক্ত হবে ঐ নৈবেদ্যগুলো|” ");
INSERT INTO ben2006_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","প্রভু মোশিকে যা যা আজ্ঞা করেছিলেন, মোশি ইস্রায়েলের লোকদের সমস্তই বললেন| ");
INSERT INTO ben2006_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ইস্রায়েলের পরিবারগোষ্ঠীর সকল নেতাদের সঙ্গে মোশি এই কথা বললেন, “এগুলো প্রভুর আজ্ঞা: ");
INSERT INTO ben2006_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“যদি কোন ব্যক্তি ঈশ্বরকে বিশেষ কিছু দেওয়ার জন্য প্রতিজ্ঞা করে অথবা কোন কিছু থেকে নিজেকে বিরত রাখার প্রতিজ্ঞা করে তাহলে সে যেন তার প্রতিজ্ঞা না ভাঙে| সেই ব্যক্তি যেন অবশ্যই যা প্রতিজ্ঞা করেছিল তা সঠিকভাবে পালন করে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“কোন যুবতী স্ত্রীলোক তার পিতার বাড়ীতে থাকার সময় প্রভুকে বিশেষ কিছু দেওয়ার জন্য কোনো বিশেষ প্রতিজ্ঞা করতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","যদি তার পিতা এই প্রতিজ্ঞা সম্পর্কে জেনে থাকে এবং একমত হয়, তাহলে সেই যুবতী স্ত্রীলোকটি তার প্রতিজ্ঞা অনুসারে অবশ্যই প্রত্যেকটি কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","কিন্তু যদি তার পিতা এই প্রতিষ্ঠার কথা জেনে থাকে এবং সে এই ব্যাপারে একমত না হয়, তাহলে সে যে প্রতিজ্ঞা করেছিল তার থেকে সে মুক্ত, সেই সমস্ত কাজকর্ম তাকে আর করতে হবে না| তার পিতা তাকে সেই কাজ করতে নিষেধ করেছিল, সুতরাং প্রভু তাকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“কোন স্ত্রীলোক প্রভুকে কিছু দেওয়ার জন্য কোনো বিশেষ প্রতিজ্ঞা করার পর যদি তার বিবাহ হয়, ");
INSERT INTO ben2006_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","যদি তার স্বামী তার প্রতিজ্ঞার কথা জানতে পারে এবং কোনো প্রতিবাদ না করে, তাহলে সেই স্ত্রীলোক যা প্রতিজ্ঞা করেছিল সেই কাজগুলো অবশ্যই করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","কিন্তু যদি তার স্বামী তার প্রতিজ্ঞার কথা জানতে পারে এবং তাকে তার প্রতিজ্ঞা পালন করতে দিতে অসম্মত হয়, তাহলে সেই স্ত্রী যা প্রতিজ্ঞা করেছিল সেই সমস্ত কাজ তাকে আর করতে হবে না| তার স্বামী তার স্ত্রীর প্রতিজ্ঞা ভঙ্গ করিয়েছিল–সেই স্ত্রীকে তার প্রতিজ্ঞানুসারে কাজ করতে দেয় নি, সুতরাং প্রভু তাকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“একজন বিধবা অথবা একজন স্বামী পরিত্যক্তা স্ত্রীলোক কোনো বিশেষ প্রতিজ্ঞা করে থাকতে পারে| যদি সে তা করে, তাহলে সে তার প্রতিজ্ঞানুসারে সমস্ত কিছুই সঠিকভাবে করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“একজন বিবাহিতা স্ত্রীলোক প্রভুকে কিছু দেওয়ার জন্য কোনো বিশেষ প্রতিজ্ঞা করে থাকতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","যদি তার স্বামী তার প্রতিজ্ঞার কথা জানতে পারে এবং তাকে তার প্রতিজ্ঞা পালন করতে দিতে সম্মত হয়, তাহলে সে তার প্রতিজ্ঞানুসারে সমস্ত কাজ অবশ্যই যথাযথভাবে পালন করবে| সে যা প্রতিজ্ঞা করেছিল সেই অনুসারে সমস্ত কিছু সে অবশ্যই দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","কিন্তু যদি তার স্বামী তার প্রতিজ্ঞার কথা জানতে পারে, এবং তাকে তার প্রতিজ্ঞা পালন করতে দিতে অসম্মত হয়, তাহলে সে যা প্রতিজ্ঞা করেছিল সেই সমস্ত কাজ তাকে আর করতে হবে না| সে কি প্রতিজ্ঞা করেছিল তাতে কিছু যায় আসে না, তার স্বামী তার স্ত্রীর প্রতিজ্ঞা ভঙ্গ করাতে পারে| যদি তার স্বামী প্রতিজ্ঞা ভঙ্গ করায়, তাহলে প্রভু তাকে ক্ষমা করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","একজন বিবাহিতা স্ত্রীলোক প্রভুকে কোনো কিছু দেওয়ার জন্য প্রতিজ্ঞা করে থাকতে পারে অথবা কোনো বিষয়ে নিজেকে বঞ্চিত করার জন্য প্রতিজ্ঞা করে থাকতে পারে অথবা সে ঈশ্বরের কাছে অন্য কোনো বিশেষ প্রতিজ্ঞা করতে পারে| তার স্বামী তার প্রতিজ্ঞাগুলোর মধ্যে যে কোনো একটির ক্ষেত্রে বাধা দিতে পারে অথবা ঐ প্রতিজ্ঞাগুলোর মধ্যে যে কোনো একটিকে পালন করতে দিতে পারে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","স্বামী যদি প্রতিজ্ঞাগুলোর সম্পর্কে জানতে পেরে সেগুলোর পালনে বাধা না দেয়, তাহলে সেই স্ত্রী অবশ্যই প্রতিজ্ঞানুসারে প্রত্যেকটি জিনিস সঠিকভাবে পালন করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","কিন্তু যদি স্বামী প্রতিজ্ঞার কথা জানতে পারে এবং সেগুলোর পালনে বাধা দেয়, তাহলে সে প্রতিজ্ঞা ভঙ্গের জন্য দায়ী থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","প্রভু মোশিকে ঐ আজ্ঞাগুলো দিলেন| ঐ আজ্ঞাগুলো হল একজন পুরুষ এবং তার স্ত্রীর সম্পর্কে, একজন পিতা এবং তার কন্যার সম্পর্কে, যে কন্যা যুবতী অবস্থায় পিতার বাড়ীতে রয়েছে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“আমি ইস্রায়েলের লোকদের মিদিয়নীয়দের পরাজিত করে প্রতিশোধ নিতে সাহায্য করবো| তারপরে মোশি তুমি মারা যাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","সুতরাং মোশি লোকদের বললেন, “তোমাদের পুরুষদের মধ্য থেকে সৈন্য হবার জন্য কয়েকজনকে বেছে নাও| মিদিয়নীয়দের বিরুদ্ধে লড়াই করার জন্য প্রভু ঐ সমস্ত লোকদের ব্যবহার করবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ইস্রায়েলের প্রত্যেকটি পরিবারগোষ্ঠী থেকে 1000 লোক বেছে নাও| ");
INSERT INTO ben2006_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","সেখানে ইস্রায়েলের পরিবারগোষ্ঠী থেকে মোট 12,000 সৈন্য থাকবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","মোশি সেই 12,000 সৈন্যকে যুদ্ধে পাঠালেন| তিনি তাদের সঙ্গে যাজক ইলিয়াসরের পুত্র পীনহসকে পাঠালেন| পীনহস তার সঙ্গে পবিত্র দ্রব্যসামগ্রী, শিঙা ও ভেরী নিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","প্রভুর আদেশমতোই ইস্রায়েলের লোকরা মিদিয়নীয়দের সঙ্গে যুদ্ধ করে সমস্ত মিদিয়নীয় লোকদের হত্যা করল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","তারা যে সমস্ত লোকদের হত্যা করেছিল তাদের মধ্যে ছিলেন ইবি, রেকম, সূর, হূর এবং রেবা মিদিয়নের পাঁচজন রাজা| তারা তরবারির সাহায্যে বিয়োরের পুত্র বিলিয়মকেও হত্যা করল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ইস্রায়েলের লোকরা মিদিয়নীয় স্ত্রীদের এবং বাচ্চাদের বন্দী করে নিয়ে এল| এছাড়াও তারা তাদের মেষ, গোরু এবং অন্যান্য জিনিসপত্রও নিয়ে এল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","এরপর তারা তাদের সমস্ত শহর এবং গ্রাম পুড়িয়ে দিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","তারা সমস্ত লোকদের, পশুসমূহ এবং যুদ্ধে যা পেয়েছিল তা নিয়ে ");
INSERT INTO ben2006_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","শিবিরে মোশি, যাজক ইলিয়াসর এবং ইস্রায়েলের অন্যান্য সমস্ত লোকের কাছে এল| ইস্রায়েলের লোকরা এইসময় মোয়াবের যর্দনের উপত্যকায় শিবির স্থাপন করেছিল| এটি ছিল যিরীহোর অপর পারে যর্দন নদীর পূর্বদিকে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","আর মোশি, যাজক ইলিয়াসর এবং ইস্রায়েলের নেতারা সৈন্যদের সঙ্গে দেখা করার জন্য শিবির থেকে বেরিয়ে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","মোশি 1000 সৈন্যের সেনাপতি এবং 100 সৈন্যের সেনাপতি, যারা যুদ্ধ থেকে ফিরে এসেছিল তাদের প্রতি ক্রুদ্ধ হয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","মোশি তাদের বললেন, “তোমরা কেন স্ত্রীলোকদের বেঁচে থাকতে দিয়েছো? ");
INSERT INTO ben2006_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","পিয়োরে বিলিয়মের ঘটনার সময় এই সব স্ত্রীলোকরাই প্রভুর কাছ থেকে ইস্রায়েলীয় পুরুষদের দূরে সরিয়ে দিয়েছিল এবং সেই জন্যই প্রভুর লোকদের মধ্যে মহামারী হয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","এখন সমস্ত মিদিয়নীয় ছেলেদের হত্যা করো| সমস্ত মিদিয়নীয় স্ত্রীলোকদের হত্যা করো যাদের কোনো না কোনো পুরুষের সঙ্গে যৌন সম্পর্ক ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","তুমি সমস্ত যুবতী মেয়েদের বাঁচতে দিতে পারো| কিন্তু কেবল তখনই যদি তাদের সঙ্গে কোনো পুরুষের যৌন সম্পর্ক না থেকে থাকে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","এরপর তোমরা যারা অন্যান্য লোকদের হত্যা করেছ তাদের প্রত্যেকে অবশ্যই শিবিরের বাইরে সাতদিন থাকবে| তোমরা যদি কেবলমাত্র মৃতদেহ স্পর্শ করে থাকো তাহলেও তোমাদের শিবিরের বাইরে থাকতে হবে| তৃতীয় দিনে তোমরা এবং তোমাদের বন্দীরা অবশ্যই নিজেদের পবিত্র করবে| সপ্তম দিনে তোমরা পুনরায় অবশ্যই এই একই কাজ করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","তোমরা অবশ্যই তোমাদের সমস্ত পরিধেয় বস্ত্র ধোবে| চামড়া, পশম অথবা কাঠের তৈরী যে কোনো জিনিসই তোমরা অবশ্যই ধোবে এবং শুচি হবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","এরপর যাজক ইলিয়াসর সৈন্যদের বললেন, “ঐ নিয়মগুলো প্রভু মোশিকে দিয়েছন| ঐ নিয়মগুলো সেইসব সৈন্যদের জন্য, যারা যুদ্ধ থেকে ফিরে আসছে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","কিন্তু আগুনে দেওয়া যাবে এমন দ্রব্যসামগ্রীর সম্পর্কে নিয়ম আলাদা| তোমরা অবশ্যই সোনা, রূপো, পিতল, লোহা, টিন অথবা সীসা আগুনের মধ্যে দিয়ে নিয়ে যাবে এবং তারপর ঐ জিনিসগুলোকে জল দিয়ে পরিষ্কার করবে তাহলে সেগুলো পবিত্র হবে| যদি কোনো দ্রব্যসামগ্রীকে আগুনে রাখা না যায়, তাহলে তোমরা অবশ্যই সেগুলোকে জল দিয়ে পরিষ্কার করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","সপ্তম দিনে তোমরা তোমাদের সমস্ত জামাকাপড় পরিষ্কার করবে এবং তখন তোমরা শুচি হবে| এরপরে তোমরা শিবিরের মধ্যে আসতে পারবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","এরপরে প্রভু মোশিকে বললেন, ");
INSERT INTO ben2006_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তুমি, যাজক ইলিয়াসর এবং সমস্ত নেতারা সমস্ত বন্দীদের, পশুদের এবং সৈন্যরা যুদ্ধে যেসব দ্রব্যসামগ্রী নিয়ে এসেছিল সেগুলো গণনা করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","এরপর ঐসব দ্রব্যসামগ্রী সৈন্যদের মধ্যে যারা যুদ্ধে গিয়েছিল এবং ইস্রায়েলের বাকী অন্যান্য লোকদের মধ্যে সমান ভাগে ভাগ করে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","যুদ্ধে গিয়েছিল এমন সৈন্যদের কাছ থেকে ঐসব দ্রব্যসামগ্রীর কিছু অংশ কর হিসাবে নিয়ে নাও; সেই অংশটি হবে প্রভুর| প্রত্যেক 500টি দ্রব্যসামগ্রীর জন্য একটি করে দ্রব্যসামগ্রী প্রভুর হবে| এই সব দ্রব্যসামগ্রীর অন্তর্ভুক্ত হল মানুষ, গরু, গাধা এবং মেষ| ");
INSERT INTO ben2006_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","সৈন্যরা যুদ্ধ থেকে লুঠ করে যেসব দ্রব্যসামগ্রী নিয়ে এসেছিল তার অর্ধেক ভাগ দ্রব্যসামগ্রী নিয়ে নাও| এরপর ঐসব দ্রব্যসামগ্রী যাজক ইলিয়াসরকে দিয়ে দাও| ঐ অংশটি হবে প্রভুর| ");
INSERT INTO ben2006_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","এবং তারপর ইস্রায়েলের লোকদের অংশের অর্ধেক থেকে, প্রত্যেক 50টি দ্রব্যসামগ্রীর জন্য একটি করে জিনিস নাও| এই সব দ্রব্যসামগ্রীর মধ্যে মানুষ, গরু, গাধা, মেষ অথবা অন্য যে কোনো পশু অন্তর্ভুক্ত থাকবে| ঐ অংশটি লেবীয়দের দিয়ে দাও কারণ লেবীয়রা প্রভুর পবিত্র তাঁবুর যত্ন করে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","প্রভু মোশিকে যা আজ্ঞা করেছিলেন মোশি এবং ইলিয়াসর ঠিক সেই মতোই কাজ করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","সৈন্যরা 675,000 মেষ, ");
INSERT INTO ben2006_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 গরু, ");
INSERT INTO ben2006_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 গাধা, ");
INSERT INTO ben2006_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","এবং 32,000 স্ত্রীলোক সঙ্গে নিয়ে এসেছিল| (ওরা সেইসব স্ত্রীলোক যাদের কোনো পুরুষের সঙ্গে যৌন সম্পর্ক ছিল না|) ");
INSERT INTO ben2006_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","যে সব সৈন্যরা যুদ্ধে গিয়েছিল তাদের প্রাপ্যের অর্ধেক অংশ হল 337,500 টি মেষ| ");
INSERT INTO ben2006_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","তারা প্রভুকে 675 টি মেষ দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","সৈন্যরা 36,000 টি গোরু পেয়েছিল| তারা 72টি গোরু প্রভুকে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","সৈন্যরা 30,500 টি গাধা পেয়েছিল| তারা প্রভুকে 61টি গাধা দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","সৈন্যরা 16,000 স্ত্রীলোক পেয়েছিল| তারা প্রভুকে কর হিসেবে 32 জন স্ত্রীলোক দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","প্রভু মোশিকে যেমন আদেশ করেছিলেন সেই আদেশমতোই তিনি যাজক ইলিয়াসর প্রভুর জন্য ঐ সকল উপহার সামগ্রী দিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","সৈন্যদের দ্বারা লুন্ঠিত দ্রব্যের অর্ধেক, যা মোশি ইস্রায়েলের লোকদের জন্য আলাদা করেছিলেন তা গণনা করে দেখা গেল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","লোকরা 337,500 টি মেষ, ");
INSERT INTO ben2006_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 গোরু, ");
INSERT INTO ben2006_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 গাধা, ");
INSERT INTO ben2006_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","এবং 16,000 স্ত্রীলোক পেয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","মোশি প্রভুর জন্য প্রত্যেক 50টি দ্রব্যসামগ্রী পিছু একটি করে জিনিস নিয়েছিলেন| এর মধ্যে পশু এবং মানুষ অন্তর্ভুক্ত ছিল| এরপর তিনি ঐ সকল দ্রব্য সামগ্রী লেবীয়দের দিয়েছিলেন, কারণ তারা প্রভুর পবিত্র তাঁবুর রক্ষণাবেক্ষণ করত| প্রভু যেমন আদেশ করেছিলেন মোশি ঠিক সেভাবেই এই কাজটি করলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","এরপর সৈন্যদের নেতারা (1000 জন পুরুষের উর্দ্ধতন নেতারা এবং 100 জন পুরুষের উর্দ্ধতন নেতারা) মোশির কাছে এলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","তাঁরা মোশিকে বললেন, “আমরা, আপনার সেবকরা, আমাদের সৈন্যদের গণনা করেছি| আমরা তাদের কাউকেই বাদ দিই নি| ");
INSERT INTO ben2006_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","সুতরাং আমরা প্রত্যেক সৈন্যর কাছ থেকে প্রভুর উপহার নিয়ে এসেছি| আমরা সোনার তৈরী বাহু-বন্ধনী, কব্জির অলংকার, আংটি, মাকড়ি এবং কন্ঠহার নিয়ে এসেছি| আমাদের শুচি করার জন্য প্রভুকে এই সকল উপহার দেওয়া হচ্ছে|” ");
INSERT INTO ben2006_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","সুতরাং মোশি সোনা দিয়ে তৈরী ঐ সমস্ত দ্রব্যসামগ্রী নিয়ে সেগুলো যাজক ইলিয়াসরকে দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","1000 জন পুরুষের উর্দ্ধতন নেতারা এবং 100 জন পুরুষের উর্দ্ধতন নেতারা যে সোনা দিয়েছিলেন তার মোট ওজন ছিল প্রায় 420 পাউণ্ড| ");
INSERT INTO ben2006_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","সৈন্যরা যুদ্ধ থেকে যে সকল দ্রব্যসামগ্রী নিয়ে এসেছিল তার বাকী অংশ তারা নিজেদের কাছে রেখে দিয়েছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","প্রতি 1000 জন পুরুষের উর্দ্ধতন নেতাদের কাছ থেকে এবং প্রতি 100 জন পুরুষের উর্দ্ধতন নেতাদের কাছ থেকে সোনা নিয়ে মোশি এবং যাজক ইলিয়াসর সেই সোনা সমাগম তাঁবুতে রাখলেন| প্রভুর সামনে এই উপহার ইস্রায়েলের লোকদের জন্য স্মৃতিচিহ্ন হিসাবে ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","রূবেণ এবং গাদের পরিবারগোষ্ঠীতে অনেক গবাদি পশু ছিল| ঐ লোকরা যাসের ও গিলিয়দের কাছে জমি দেখেছিল| তারা দেখল যে, এই জমিটি তাদের পশুদের কাছে খুবই উপযোগী| ");
INSERT INTO ben2006_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","সেই কারণে রূবেণ এবং গাদের পরিবারগোষ্ঠীর লোকরা মোশি, যাজক ইলিয়াসর এবং লোকদের নেতাদের সঙ্গে কথা বলল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","তারা বলল, “আমাদের অর্থাৎ‌ আপনাদের সেবকদের অনেক গবাদি পশু আছে এবং যে জমি প্রভু ইস্রায়েলীয়দের জন্য জয় করেছিলেন সেটি পশুদের পক্ষে খুবই উপযোগী| এই দেশের অন্তর্ভুক্ত জায়গাগুলো ছিল অষ্টারোৎ, দীবোন, যাসের, নিম্রা, হিষ্বোন, ইলিয়ালী, সেবাম, নবো ও বিয়োন| ");
INSERT INTO ben2006_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","তারা বলল, “যদি আপনার খুশী হয় তাহলে এই জায়গাটি আমাদের দিয়ে দিতে পারেন| আমাদের যর্দন নদীর অপর পাশে নিয়ে যাবেন না|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","মোশি রূবেণ এবং গাদের পরিবারগোষ্ঠীর লোকদের বললেন, “তোমরা যখন এখানে স্থায়ীভাবে বসবাস করবে তখন কি তোমরা তোমাদের ভাইদের যুদ্ধে যেতে দেবে? ");
INSERT INTO ben2006_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","তোমরা ইস্রায়েলের লোকদের নিরুৎ‌সাহ করার চেষ্টা করছ কেন? তোমরা তাদের নিরুৎ‌সাহ করছ যাতে তারা নদী পার না হয় এবং ঈশ্বর তাদের যে দেশ দিয়েছেন সেই দেশ অধিগ্রহণ না করে! ");
INSERT INTO ben2006_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","তোমাদের পিতারাও আমার সঙ্গে ঠিক একই ব্যবহার করেছিল| কাদেশ-বর্ণেয় দেশটি দেখার জন্য আমি কিছু গুপ্তচর সেখানে পাঠিয়েছিলাম| ");
INSERT INTO ben2006_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ঐ সমস্ত লোকরা ইষ্কোলের উপত্যকা পর্যন্ত গিয়েছিল| তারা দেশটি দেখেছিল এবং ঐ সমস্ত লোকরা ইস্রায়েলের লোকদের এতটাই নিরুৎ‌সাহ করেছিল যে প্রভু তাদের যে জায়গা দিয়েছিলেন, সেখানে যেতেও তারা অস্বীকার করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","প্রভু ঐ লোকদের প্রতি প্রচণ্ড ক্রুদ্ধ হয়ে প্রতিজ্ঞা করেছিলেন: ");
INSERT INTO ben2006_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘মিশর থেকে এসেছে এমন 20 বছর অথবা তার বেশী বয়স্ক কোনো লোকই সেই দেশ দেখার অনুমতি পাবে না যে দেশ আমি অব্রাহাম, ইসহাক এবং যাকোবের কাছে দেব বলে প্রতিজ্ঞা করেছিলাম| কিন্তু তারা সঠিকভাবে আমাকে অনুসরণ করে নি| সুতরাং কালেব এবং যিহোশূয় ছাড়া আর কেউ এই দেশ পাবে না| ");
INSERT INTO ben2006_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","কারণ কনিসীয় গোষ্ঠীভুক্ত যিফূন্নির পুত্র কালেব এবং নূনের পুত্র যিহোশূয় প্রভুকে সঠিকভাবে অনুসরণ করেছিল!’ ");
INSERT INTO ben2006_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“ইস্রায়েলের লোকদের প্রতি প্রভু প্রচণ্ড ক্রুদ্ধ হয়েছিলেন| সেই কারণে প্রভু ঐ লোকদের 40 বছর মরুভূমিতে বাস করতে বাধ্য করেছিলেন| যারা প্রভুর বিরুদ্ধে পাপকার্য করেছিল তাদের সকলকেই প্রভু তাদের মৃত্যু পর্যন্ত মরুভূমিতে ঘুরে বেড়াতে বাধ্য করেছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","তোমাদের পিতারা যে কাজ করেছিলেন এখন তোমরা সেই একই কাজের পুনরাবৃত্তি করছো| তোমরা পাপী লোকরা, তোমরা কি চাও যে, প্রভু তার লোকদের বিরুদ্ধে আগের থেকেও আরও বেশী ক্রুদ্ধ হন? ");
INSERT INTO ben2006_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","তোমরা যদি প্রভুকে অনুসরণ করা ছেড়ে দাও, তাহলে প্রভু ইস্রায়েলের লোকদের আরও দীর্ঘদিনের জন্য মরুভূমিতে থাকতে বাধ্য করবেন| এই ভাবে তোমরা এই সমস্ত লোকদের ধ্বংস করবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","কিন্তু রূবেণের এবং গাদের পরিবারগোষ্ঠীর লোকরা মোশির কাছে গিয়ে বলল, “আমরা আমাদের সন্তানদের জন্য এখানে শহর তৈরী করবো এবং আমাদের পশুর জন্য খোঁয়াড় গড়ে তুলবো| ");
INSERT INTO ben2006_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","তাহলে আমাদের সন্তানরা এই দেশে বসবাসকারী অন্যান্য লোকদের থেকে নিরাপদে থাকতে পারবে| কিন্তু আমরা খুব খুশী মনেই এগিয়ে এসে ইস্রায়েলের অন্যান্য লোকদের সাহায্য করব যে পর্যন্ত না তাদের নিজেদের দেশে নিয়ে আসব| ");
INSERT INTO ben2006_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ইস্রায়েলের প্রত্যেকে তার জমির অংশ না পাওয়া পর্যন্ত আমরা বাড়ী ফিরবো না| ");
INSERT INTO ben2006_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","যর্দন নদীর পশ্চিম দিকের কোনো জমি আমরা দেবো না| যর্দন নদীর কেবলমাত্র পূর্বদিকের জমিই আমাদের|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","সুতরাং মোশি তাদের বললেন, “তোমরা যদি এগুলোর সবটাই করো, তাহলে এই জমি তোমাদের হবে; কিন্তু তোমাদের সৈন্যদের অবশ্যই প্রভুর সামনে যুদ্ধে যেতে হবে| ");
INSERT INTO ben2006_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","তোমাদের সৈন্যরা অবশ্যই যর্দন নদীর পার করবে এবং শত্রুদের দেশত্যাগ করতে বাধ্য করবে| ");
INSERT INTO ben2006_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","প্রভু আমাদের সবাইকে জমি অধিগ্রহণ করতে সাহায্য করার পরে, তোমরা বাড়ী ফিরে যেতে পারো| তখন প্রভু এবং ইস্রায়েলের লোকরা তোমাদের দোষী মনে করবে না| তখন প্রভু তোমাদের এই জমি নিতে দেবেন| ");
INSERT INTO ben2006_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","কিন্তু তোমরা যদি এইগুলো না করো, তাহলে তোমরা প্রভুর বিরুদ্ধে পাপ করবে এবং এটা নিশ্চিত জেনে রেখো যে, তোমরা তোমাদের পাপের জন্য শাস্তি পাবে| ");
INSERT INTO ben2006_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","তোমরা তোমাদের সন্তানদের জন্য শহর এবং তোমাদের পশুদের জন্য খোঁয়াড় তৈরী করো; কিন্তু তোমরা যা শপথ করেছিলে সেগুলো অবশ্যই কোরো|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","তখন গাদের এবং রূবেণের পরিবারগোষ্ঠীর লোকরা মোশিকে বলল, “আমরা আপনার সেবক, আপনি আমাদের গুরু, সুতরাং আপনি যা বলবেন আমরা সেটাই করব| ");
INSERT INTO ben2006_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","আমাদের স্ত্রীরা, সন্তানরা এবং আমাদের সমস্ত পশু গিলিয়দের শহরগুলোতে থাকবে| ");
INSERT INTO ben2006_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","কিন্তু আমরা, আপনার সেবকরা যর্দন নদী পার হব| আমাদের প্রভুর কথামতো আমরা প্রভুর সামনে যুদ্ধের জন্য এগিয়ে যাবো|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","সুতরাং মোশি, যাজক ইলিয়াসর, নূনের পুত্র যিহোশূয় এবং ইস্রায়েলের পরিবারগোষ্ঠীগুলোর সমস্ত নেতাদের তাদের বিষয় এই নির্দেশ দিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","মোশি তাদের বললেন, “গাদ এবং রূবেণের মানুষ যর্দন নদী পার হবে এবং প্রভুর সামনে থেকে যুদ্ধে যাবে| তারা তোমাদের সেই দেশ নিতে সাহায্য করবে এবং তাদের দেশের অংশ হিসেবে তুমি গিলিয়দের দেশ দিয়ে দেবে| ");
INSERT INTO ben2006_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","তারা প্রতিজ্ঞা করেছে যে কনান দেশ অধিকার করতে তারা তোমাদের সাহায্য করবে| কিন্তু যদি তারা তোমাদের সৈন্যদের সঙ্গে পার না হয় তাহলে তারা কেবলমাত্র কনানে একটি অপেক্ষাকৃত ছোট জমির অংশ পাবে|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","গাদ এবং রূবেণের লোকরা উত্তর দিল, “প্রভু যা আদেশ করেছেন ঠিক সেটা করার জন্য আমরা প্রতিশ্রুতি করেছি| ");
INSERT INTO ben2006_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","আমরা প্রভুর সামনে যর্দন নদী পার হয়ে কনান দেশে যাব, কিন্তু যর্দন নদীর পূর্বদিকের দেশই হল আমাদের অংশ|” ");
INSERT INTO ben2006_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","সুতরাং গাদের লোকদের, রূবেণের লোকদের এবং মনঃশি পরিবারগোষ্ঠীর অর্ধেক লোককে মোশি সেই দেশ দিয়েছিলেন| (মনঃশি ছিলেন যোষেফের পুত্র|) ইমোরীয়দের রাজা সীহোনের রাজ্য এবং বাশনের রাজা ওগের রাজ্য সেই দেশের অন্তর্ভুক্ত ছিল| ঐ জায়গার আশেপাশের সমস্ত ঐ শহর ঐ দেশের অন্তর্ভুক্ত ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","গাদের লোকরা দীবোন, অটারোত্‌ ও অরোয়ের এবং ");
INSERT INTO ben2006_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","অটারোত্‌-শোফন, যাসের ও য়গ্বিহ এবং ");
INSERT INTO ben2006_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বৈৎ‌-নিম্রা ও বৈৎ‌-হারণ শহরগুলি খুব শক্ত প্রাচীর দিয়ে গড়ে তুলেছিল এবং পশুদের জন্য খোঁয়াড় তৈরী করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","রূবেণের লোকরা হিষ্বোন, ইলিয়ালী, কিরিয়াথয়িম, ");
INSERT INTO ben2006_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","নবো, বাল্-মিয়োন এবং সিব্মা শহর গড়ে তুলেছিল| তারা তাদের পুর্নগঠিত শহরগুলোর আগের নামগুলোই রেখেছিল কিন্তু নবো এবং বাল্-মিয়োনের নাম পরিবর্তন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","মনঃশির পুত্র মাখীরের পরিবারগোষ্ঠীর লোকরা গিলিয়দে গিয়ে সেখানে বসবাসকারী ইমোরীয়দের পরাজিত করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","সেই কারণে মোশি মনঃশি পরিবারগোষ্ঠীর মাখীরকে গিলিয়দ দিলেন এবং তাদের পরিবার সেখানে স্থায়ীভাবে বসবাস শুরু করল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","মনঃশি গোষ্ঠীর যায়ীর সেখানকার ছোটো ছোটো গ্রামগুলোকে অধিকার করল| এরপর সে ঐ গ্রামগুলোর নাম দিয়েছিল যায়ীরের শহর সকল| ");
INSERT INTO ben2006_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","কনাত্‌ এবং এর কাছের ছোটো ছোটো শহরগুলোকে নোবহ পরাজিত করেছিল| এরপর সে নিজের নামানুসারে সেই জায়গার নামকরণ করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","মোশি এবং হারোণ মিশর থেকে ইস্রায়েলের লোকদের নেতৃত্ব দিয়ে বিভিন্ন দলে ভাগ করে নিয়ে গিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","তারা যে জায়গাগুলোতে ভ্রমণ করেছিল, প্রভুর আজ্ঞা অনুযায়ী মোশি সে জায়গাগুলো সম্পর্কে লিখেছিলেন| তাদের যাত্রার পর্যায়গুলি এখানে দেওয়া হল: ");
INSERT INTO ben2006_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","প্রথম মাসের 15তম দিনে তারা রামিষেষ ত্যাগ করেছিল| সেই দিন সকালে নিস্তারপর্বের পরে ইস্রায়েলের লোকরা জয়ের ভঙ্গীতে তাদের হাত উঁচু করে মিশর থেকে বেরিয়ে এসেছিল| মিশরের সমস্ত লোক তাদের দেখেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","প্রভু যাদের হত্যা করেছিলেন সেই প্রথমজাতদের মিশরীয়রা সেই সময় কবর দিচ্ছিল| মিশরের দেবগণের বিরুদ্ধেও প্রভু তাঁর বিচার দেখিয়েছিলেন| ");
INSERT INTO ben2006_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ইস্রায়েলের লোকরা রামিষেষ ত্যাগ করে সুক্কোতের উদ্দেশ্যে যাত্রা করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","সুক্কোৎ থেকে তারা এথমের দিকে যাত্রা করেছিল| লোকরা সেখানে মরুভূমির প্রান্তে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","তারা এথম ত্যাগ করে পী-হহীরোতের দিকে যাত্রা করেছিল| এই জায়গাটি বাল-সফোনের কাছে ছিল| লোকরা মিগ্দোলের কাছে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","লোকরা পী-হহীরোত ত্যাগ করে সমুদ্রের মধ্য দিয়ে হেঁটেছিল| তারা মরুভূমির দিকে গিয়েছিল, এরপর তিন দিন ধরে এথম মরুভূমির মধ্য দিয়ে হেঁটেছিল| লোকরা মারা নামক স্থানে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","লোকরা মারা ত্যাগ করে এলীমে গিয়েছিল এবং সেখানেই শিবির স্থাপন করেছিল| সেখানে 12টি ঝর্ণা এবং 70টি খেজুর গাছ ছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","লোকরা এলীম ত্যাগ করে সূফ সাগরের কাছে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","সূফ সাগর ত্যাগ করার পরে লোকরা সীন মরুভূমিতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","এরপর সীন মরুভূমি ত্যাগ করে দপ্কাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","দপ্কা ত্যাগ করে আলুশে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","আলুশ ত্যাগ করে রফীদীমে শিবির স্থাপন করেছিল| সেই স্থানে লোকদের পান করার উপযোগী কোনো জল ছিল না| ");
INSERT INTO ben2006_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","লোকরা রফীদীম ত্যাগ করে সীনয় মরুভূমিতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","সীনয় মরুভূমি ত্যাগ করে কিব্রোত্‌-হত্তাবাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","লোকরা কিব্রোত্‌-হত্তাবা ত্যাগ করে হৎসেরোতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","হৎসেরোত ত্যাগ করার পরে রিত্‌মাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","রিত্‌মা ত্যাগ করে রিম্মোণ-পেরসে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","রিম্মোণ-পেরস ত্যাগ করে লিব্নাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","লিব্না ত্যাগ করে রিস্সাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","রিস্বা ত্যাগ করে কহেলাথায শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","কহেলাথা ত্যাগ করে শেফর পর্বতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","শেফর পর্বত ত্যাগ করে হরাদাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","হরাদা ত্যাগ করে মখেলোতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","মখেলোত্‌ ত্যাগ করে তহতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","তহৎ ত্যাগ করে তেরহতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","তেরহ ত্যাগ করে মিত্‌কাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","মিত্‌কা ত্যাগ করে হশ্মোনাতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","হশ্মোনা ত্যাগ করে মোষেরোতে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","মোষেরোত্‌ ত্যাগ করে বনেয়াকনে শিবির স্থাপন করেছিল| ");
INSERT INTO ben2006_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","বনেয়াকন ত্যাগ করে হোর্-হগিদ্গদে শিবির স্থাপন করেছিল| ");
INSERT INTO b