﻿USE sofia;
DROP TABLE IF EXISTS sofia.beln_vpl;
CREATE TABLE beln_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES beln_vpl WRITE;
INSERT INTO beln_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," На пачатку стварыў Бог неба і зямлю. ");
INSERT INTO beln_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","І зямля была бязладная і пустая, і цемра над бяздоньнямі, і Дух Божы ўзносіўся над водамі. ");
INSERT INTO beln_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","І сказаў Бог: “Няхай станецца сьвятло”. І сталася сьвятло. ");
INSERT INTO beln_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","І бачыў Бог сьвятло, што яно добрае, і разьдзяліў Бог сьвятло і цемру. ");
INSERT INTO beln_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","І назваў Бог сьвятло днём, а цемру — ноччу. І быў вечар, і была раніца — дзень адзін. ");
INSERT INTO beln_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","І сказаў Бог: “Няхай станецца прасьцяг сярод водаў і няхай аддзеліць воды ад водаў”. ");
INSERT INTO beln_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","І зрабіў Бог прасьцяг, і разьдзяліў воды, якія былі пад прасьцягам, і воды, якія былі над прасьцягам. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","І назваў Бог прасьцяг небам. І быў вечар, і была раніца — дзень другі. ");
INSERT INTO beln_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","І сказаў Бог: “Няхай зьбяруцца воды, якія пад небам, у адно месца, і няхай зьявіцца сухазем’е”. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","І назваў Бог сухазем’е зямлёю, а збор водаў назваў морам. І бачыў Бог, што гэта добра. ");
INSERT INTO beln_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","І сказаў Бог: “Няхай зазелянее зямля зелянінай, травой, якая сее насеньне, і дрэвамі пладовымі, якія даюць плады паводле гатунку свайго і маюць у сабе насеньне на зямлі”. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","І выдала зямля зеляніну, траву, якая сее насеньне паводле гатунку свайго, і дрэвы, якія даюць плады і маюць у сабе насеньне паводле гатунку свайго. І бачыў Бог, што гэта добра. ");
INSERT INTO beln_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","І быў вечар, і была раніца — дзень трэці. ");
INSERT INTO beln_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","І сказаў Бог: “Няхай стануцца сьвяцілы на прасьцягу неба, каб разьдзяляць дзень і ноч, і няхай будуць дзеля знакаў, і вызначаных часоў, і дзён, і гадоў. ");
INSERT INTO beln_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","І няхай будуць сьвяціламі на прасьцягу неба, каб сьвяцілі на зямлю”. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","І зрабіў Бог два сьвяцілы вялікія: сьвяціла большае, каб кіравала днём, і сьвяціла меншае, каб кіравала ноччу, і зоркі. ");
INSERT INTO beln_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","І зьмясьціў іх Бог на прасьцягу неба, каб сьвяцілі на зямлю, ");
INSERT INTO beln_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","і кіравалі днём і ноччу, і аддзялялі сьвятло ад цемры. І бачыў Бог, што гэта добра. ");
INSERT INTO beln_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","І быў вечар, і была раніца — дзень чацьвёрты. ");
INSERT INTO beln_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","І сказаў Бог: “Няхай узварушацца воды рухам душы жывой, і птушкі няхай лётаюць над зямлёю па прасьцягу неба”. ");
INSERT INTO beln_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","І стварыў Бог цмокаў вялікіх і ўсякую душу жывую, якая рухаецца, якімі ўзварушыліся воды, паводле гатункаў сваіх, і ўсякую птушку крылатую паводле гатунку свайго. І бачыў Бог, што гэта добра. ");
INSERT INTO beln_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","І дабраславіў іх Бог, кажучы: “Пладзіцеся і множцеся, і напаўняйце воды мораў, а птушкі няхай множацца на зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","І быў вечар, і была раніца — дзень пяты. ");
INSERT INTO beln_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","І сказаў Бог: “Няхай выдасьць зямля душу жывую паводле гатунку свайго: скаціну, паўзуноў і зьвяроў зямных паводле гатункаў сваіх”. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","І зрабіў Бог зьвяроў зямных паводле гатункаў сваіх, і скаціну паводле гатунку свайго, і ўсякіх паўзуноў зямных паводле гатункаў сваіх. І бачыў Бог, што гэта добра. ");
INSERT INTO beln_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","І сказаў Бог: “Зробім чалавека на вобраз Наш, як падабенства Нашае, і няхай ён мае уладу над рыбамі марскімі і над птушкамі паднебнымі, і над скацінай, і над усёй зямлёй, і над усякім паўзуном, які поўзае па зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","І стварыў Бог чалавека на вобраз Свой, на вобраз Божы стварыў яго, мужчыну і жанчыну стварыў іх. ");
INSERT INTO beln_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","І дабраславіў іх Бог, і сказаў ім Бог: “Пладзіцеся і множцеся, і напаўняйце зямлю, і падпарадкоўвайце яе сабе, і мейце ўладу над рыбамі марскімі, і над птушкамі паднебнымі, і над усякім зьверам, які рухаецца па зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","І сказаў Бог: “Вось, Я даў вам усякую траву, якая сее насеньне, якая на абліччы ўсёй зямлі, і ўсякія дрэвы, якія маюць плод дрэва і сеюць насеньне, каб былі вам на ежу. ");
INSERT INTO beln_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","І ўсім зьвярам зямным, і ўсім птушкам паднебным, і ўсяму, што рухаецца па зямлі, у якім ёсьць душа жывая, Я даў усякую траву зялёную на ежу”. І сталася так. ");
INSERT INTO beln_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","І бачыў Бог усё, што зрабіў, і вось, усё вельмі добра. І быў вечар, і была раніца — дзень шосты. ");
INSERT INTO beln_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","І былі скончаны неба і зямля, і ўсё войска іхняе. ");
INSERT INTO beln_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","І скончыў Бог у сёмы дзень работу Сваю, якую зрабіў, і супачыў у сёмы дзень ад усёй работы Сваёй, якую зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","І дабраславіў Бог дзень сёмы і асьвяціў яго, бо ў ім супачыў ад усёй работы Сваёй, якую стварыў Бог, робячы. ");
INSERT INTO beln_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Такі вось радавод неба і зямлі, калі былі яны створаныя, у дзень, калі ГОСПАД Бог зрабіў зямлю і неба. ");
INSERT INTO beln_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","І не было яшчэ ніводнага куста палявога на зямлі, і ніводная палявая трава яшчэ не вырасла, бо ГОСПАД Бог не спаслаў дождж на зямлю і не было чалавека, каб абрабляць зямлю. ");
INSERT INTO beln_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","І пара падымалася ад зямлі, і напойвала ўсё аблічча зямлі. ");
INSERT INTO beln_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","І зьляпіў ГОСПАД Бог чалавека з пылу зямлі, і ўдыхнуў у ноздры ягоныя дыханьне жыцьця, і стаўся чалавека душою жывою. ");
INSERT INTO beln_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","І пасадзіў ГОСПАД Бог сад у Эдэне, на ўсходзе, і зьмясьціў там чалавека, якога зьляпіў. ");
INSERT INTO beln_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","І вырасьціў ГОСПАД Бог з зямлі ўсякае дрэва, прыгожае на выгляд і добрае на ежу, і дрэва жыцьця ў сярэдзіне саду, і дрэва спазнаньня дабра і зла. ");
INSERT INTO beln_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","І рака выцякала з Эдэну, каб напойваць сад, і адтуль яна разьдзялялася на чатыры галоўныя ракі. ");
INSERT INTO beln_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Назва адной — Пішон, яна атачае ўсю зямлю Хавіля, у якой золата. ");
INSERT INTO beln_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","А золата той зямлі добрае, там бдалях і камень онікс. ");
INSERT INTO beln_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","А назва другой ракі — Гіхон, яна атачае ўсю зямлю Куш. ");
INSERT INTO beln_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","А назва трэцяй ракі — Хідэкель, яна цячэ на ўсход Асірыі; а чацьвёртая рака — Эўфрат. ");
INSERT INTO beln_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","І ўзяў ГОСПАД Бог чалавека, і зьмясьціў яго ў садзе Эдэн, каб абрабляў яго і захоўваў яго. ");
INSERT INTO beln_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","І загадаў ГОСПАД Бог чалавеку, кажучы: “З кожнага дрэва ў садзе будзеш есьці, ");
INSERT INTO beln_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","але з дрэва спазнаньня дабра і зла ня еш з яго, бо ў дзень, у які будзеш есьці з яго, сьмерцю памрэш”. ");
INSERT INTO beln_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","І сказаў ГОСПАД Бог: “Ня добра быць чалавеку аднаму; зраблю яму дапамогу, адпаведную яму”. ");
INSERT INTO beln_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","І зьляпіў ГОСПАД Бог з зямлі ўсіх зьвяроў палявых і ўсіх птушак паднебных, і прывёў да чалавека, каб пабачыць, як ён назаве іх, і як чалавек назаве кожную душу жывую, такое і імя ёй. ");
INSERT INTO beln_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","І назваў чалавек імёны ўсёй скаціны, і ўсіх птушак паднебных, і ўсіх зьвяроў палявых, але для чалавека не знайшлося дапамогі, адпаведнай яму. ");
INSERT INTO beln_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","І спусьціў ГОСПАД Бог моцны сон на чалавека, і той заснуў. І ўзяў Ён адно з рэбраў ягоных, і закрыў целам тое месца. ");
INSERT INTO beln_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","І збудаваў ГОСПАД Бог з рабра, якое ўзяў з чалавека, жанчыну, і прывёў яе да чалавека. ");
INSERT INTO beln_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","І сказаў чалавек: “Вось, на гэты раз, гэта костка з костак маіх і цела з цела майго. Яна будзе называцца жанчынаю, бо ўзятая з мужа”. ");
INSERT INTO beln_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Таму пакіне мужчына бацьку свайго і маці сваю і прылепіцца да жонкі сваёй, і будуць адным целам. ");
INSERT INTO beln_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","І былі абое голыя, чалавек і жонка ягоная, і не саромеліся. ");
INSERT INTO beln_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","А зьмей быў хітрэйшы за ўсіх зьвяроў палявых, якіх зрабіў ГОСПАД Бог. І сказаў ён жанчыне: «Ці ж гэта сказаў Бог: “Ня ешце з кожнага дрэва ў садзе”?» ");
INSERT INTO beln_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","І сказала жанчына зьмею: “Плады дрэваў саду можам есьці, ");
INSERT INTO beln_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","але пра плады дрэва, якое сярод саду, сказаў Бог: “Ня ешце з яго і не дакранайцеся да яго, каб вы не памерлі”. ");
INSERT INTO beln_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","І сказаў зьмей жанчыне: “Не памрацё сьмерцю! ");
INSERT INTO beln_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Бо ведае Бог, што ў дзень, калі зьясьцё з яго, расплюшчацца вочы вашыя і станецеся як Бог, тымі, хто спазнае дабро і зло”. ");
INSERT INTO beln_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","І ўбачыла жанчына, што дрэва добрае для ежы, і прывабнае для вачэй, і пажаданае дрэва дзеля разуменьня, і ўзяла яна плод ягоны, і ела, і дала мужу свайму, які быў з ёю, і ён еў. ");
INSERT INTO beln_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","І расплюшчыліся вочы ў іх абодвух, і спазналі, што яны голыя, і сплялі лісты фігавыя, і зрабілі сабе перапаяскі. ");
INSERT INTO beln_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","І пачулі яны голас ГОСПАДА Бога, Які хадзіў у садзе ў ветры дня, і схаваліся чалавек і жонка ягоная ад аблічча ГОСПАДА Бога сярод дрэваў саду. ");
INSERT INTO beln_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","І паклікаў ГОСПАД Бог чалавека, і сказаў яму: “Дзе ты?” ");
INSERT INTO beln_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","І той сказаў: “Голас Твой я пачуў у садзе і спалохаўся, бо я — голы, і схаваўся”. ");
INSERT INTO beln_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","І сказаў Бог: “Хто распавёў табе, што ты голы? Ці ня еў ты з дрэва, з якога Я загадаў табе ня есьці?” ");
INSERT INTO beln_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","І сказаў чалавек: “Жанчына, якую Ты даў, каб была са мною, яна дала мне з дрэва, і я еў”. ");
INSERT INTO beln_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","І сказаў ГОСПАД Бог жанчыне: “Што ты гэта зрабіла?” І сказала жанчына: “Зьмей падмануў мяне, і я ела”. ");
INSERT INTO beln_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","І сказаў ГОСПАД Бог зьмею: “За тое, што ты зрабіў гэта, пракляты ты між усёй скаціны і ўсіх зьвяроў палявых! На жываце сваім поўзаць будзеш і будзеш пыл есьці ў-ва ўсе дні жыцьця твайго. ");
INSERT INTO beln_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","І Я кладу варожасьць паміж табой і жанчынай, паміж насеньнем тваім і насеньнем яе. Яно скрышыць табе галаву, а ты скрышыш яму пяту”. ");
INSERT INTO beln_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","А жанчыне сказаў: “Памнажаючы, памножу мучэньні твае і цяжарнасьці твае, з болем будзеш нараджаць сыноў; і да мужа твайго пацяга твая, а ён будзе панаваць над табою”. ");
INSERT INTO beln_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","А Адаму сказаў: “За тое, што ты паслухаўся голасу жонкі тваёй і еў з дрэва, пра якое Я загадаў табе, кажучы: “Ня еш з яго”, праклятая зямля з-за цябе. У мучэньнях будзеш есьці з яе у-ва ўсе дні жыцьця твайго. ");
INSERT INTO beln_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Церні і асот будзе радзіць яна табе, і будзеш есьці траву палявую. ");
INSERT INTO beln_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","У поце аблічча твайго будзеш есьці хлеб, аж пакуль ня вернешся ў зямлю, бо з яе ты ўзяты, бо пыл ты і ў пыл вернешся”. ");
INSERT INTO beln_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","І назваў чалавек імя сваёй жонцы — Ева, бо яна была маці усіх, што жывуць. ");
INSERT INTO beln_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","І зрабіў ГОСПАД Бог Адаму і жонцы ягонай адзеньне са скуры, і апрануў іх. ");
INSERT INTO beln_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","І сказаў ГОСПАД Бог: “Вось, чалавек стаўся як адзін з Нас, спазнаўшы дабро і зло. І цяпер няхай ня выцягне ён рукі сваёй і ня возьме таксама з дрэва жыцьця, і ня зьесьць, і ня будзе жыць вечна”. ");
INSERT INTO beln_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","І выслаў яго ГОСПАД Бог з саду Эдэн, каб абрабляў зямлю, з якой быў узяты. ");
INSERT INTO beln_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","І выгнаў чалавека, і паставіў на ўсходзе ад саду Эдэн херувімаў і меч палымяны, які паварочваецца наўкола, каб сьцерагчы шлях да дрэва жыцьця. ");
INSERT INTO beln_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","І чалавек спазнаў Еву, жонку сваю, і яна зачала, і нарадзіла Каіна, і сказала: “Атрымала я мужа ад ГОСПАДА”. ");
INSERT INTO beln_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","І яшчэ нарадзіла брата ягонага Абэля. І быў Абэль пастухом авечак, а Каін быў земляробам. ");
INSERT INTO beln_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","І сталася, як прайшлі дні, і Каін прынёс з пладоў зямлі дар ГОСПАДУ. ");
INSERT INTO beln_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","І Абэль таксама прынёс з першародных авечак сваіх і з тлустасьці іх. І ўзглянуў ГОСПАД на Абэля і на дар ягоны, ");
INSERT INTO beln_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","а на Каіна і на дар ягоны ня ўзглянуў. І вельмі загневаўся Каін, і пахілілася аблічча яго. ");
INSERT INTO beln_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","І сказаў ГОСПАД Каіну: “Чаму ты загневаўся і чаму пахілілася аблічча тваё? ");
INSERT INTO beln_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ці ж ты не ўзьнімаеш аблічча, калі робіш добра, а калі ня робіш добра, грэх ляжыць пры дзьвярах, да цябе пацяга яго, але ты павінен панаваць над ім”. ");
INSERT INTO beln_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","І сказаў Каін Абэлю, брату свайму. І сталася, калі былі яны ў полі, паўстаў Каін на Абэля, брата свайго, і забіў яго. ");
INSERT INTO beln_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","І сказаў ГОСПАД Каіну: “Дзе Абэль, брат твой?” А той сказаў: “Ня ведаю. Ці ж я вартаўнік брата майго?” ");
INSERT INTO beln_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","І сказаў ГОСПАД: “Што ты зрабіў? Голас крыві брата твайго кліча да Мяне ад зямлі. ");
INSERT INTO beln_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","І цяпер пракляты ты ад зямлі, якая адчыніла вусны свае прыняць кроў брата твайго з рукі тваёй. ");
INSERT INTO beln_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Калі будзеш абрабляць зямлю, яна ня будзе больш даваць табе сілы свае. Выгнанцам і ўцекачом будзеш на зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","І сказаў Каін ГОСПАДУ: “Большае беззаконьне маё, чым можна зьнесьці. ");
INSERT INTO beln_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Вось, Ты выганяеш мяне сёньня з аблічча зямлі, і буду хавацца ад аблічча Твайго, і буду я выгнанцам і ўцекачом на зямлі, і станецца, што кожны, хто сустрэне мяне, заб’е мяне”. ");
INSERT INTO beln_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","І сказаў яму ГОСПАД: “Таму кожнаму, хто заб’е Каіна, сем разоў будзе адпомшчана”. І пазначыў ГОСПАД Каіна знакам, каб не забіў яго кожны, хто сустрэне яго. ");
INSERT INTO beln_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","І адыйшоў Каін ад аблічча ГОСПАДА, і пасяліўся ў зямлі Нод, на ўсход ад Эдэну. ");
INSERT INTO beln_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","І спазнаў Каін жонку сваю, і яна зачала, і нарадзіла Эноха. І пабудаваў ён горад, і назваў імя горада ад імя сына свайго — Энох. ");
INSERT INTO beln_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","І нарадзіў Ханок Ірада, а Ірад нарадзіў Мэхіяэля, а Мэхіяэль нарадзіў Мэтушаэля, а Мэтушаэль нарадзіў Лямэха. ");
INSERT INTO beln_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","І ўзяў сабе Лямэх дзьве жонкі. Імя адной — Ада, а імя другой — Цыля. ");
INSERT INTO beln_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","І нарадзіла Ада Яваля, ён быў бацька тых, што жывуць у намётах і маюць статкі. ");
INSERT INTO beln_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","А імя брата ягонага — Юваль, ён быў бацька ўсіх, што граюць на гусьлях і жалейцы. ");
INSERT INTO beln_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","І Цыля таксама нарадзіла Туваль-Каіна, які быў кавалём усякіх прыладаў з медзі і жалеза. А сястра Туваль-Каіна — Наама. ");
INSERT INTO beln_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","І сказаў Лямэх жонкам сваім: “Ада і Цыля, паслухайце голас мой! Жонкі Лямэха, прыхіліце вуха да мовы маёй! Бо забіў я чалавека за рану сваю і юнака за скалячэньне сваё. ");
INSERT INTO beln_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Бо за Каіна будзе адпомшчана сем разоў, а за Лямэха — семдзесят сем”. ");
INSERT INTO beln_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","І спазнаў яшчэ Адам жонку сваю, і яна нарадзіла сына, і назвала імя яго Сэт, бо казала: “Даў мне Бог іншае насеньне замест Абэля, якога забіў Каін”. ");
INSERT INTO beln_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","У Сэта таксама нарадзіўся сын, і ён назваў імя яго Энос. Тады пачалі клікаць імя ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Вось кніга радаводу Адама. У дзень, калі Бог стварыў Адама, зрабіў яго на падабенства Божае, ");
INSERT INTO beln_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","мужчыну і жанчыну стварыў іх, і дабраславіў іх, і назваў іх імя “чалавек” у дзень стварэньня іх. ");
INSERT INTO beln_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","І жыў Адам сто трыццаць гадоў, і нарадзіў сына на падабенства сваё, як вобраз свой, і назваў імя яго Сэт. ");
INSERT INTO beln_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","І было дзён Адама па нараджэньні Сэта васемсот гадоў, і нарадзіў ён сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","І былі ўсе дні Адама, якія ён жыў, дзевяцьсот трыццаць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","І жыў Сэт сто пяць гадоў, і нарадзіў Эноса. ");
INSERT INTO beln_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","І жыў Сэт па нараджэньні Эноса васемсот сем гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","І былі ўсе дні Сэта дзевяцьсот дванаццаць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","І жыў Энос дзевяноста гадоў, і нарадзіў Кейнана. ");
INSERT INTO beln_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","І жыў Энос па нараджэньні Кейнана васемсот пятнаццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","І былі ўсе дні Эноса дзевяцьсот пяць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","І жыў Кейнан семдзесят гадоў, і нарадзіў Магалялеэля. ");
INSERT INTO beln_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","І жыў Кейнан па нараджэньні Магалялеэля васемсот сорак гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","І былі ўсе дні Кейнана дзевяцьсот дзесяць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","І жыў Магалялеэль шэсьцьдзесят пяць гадоў, і нарадзіў Ярэда. ");
INSERT INTO beln_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","І жыў Магалялеэль па нараджэньні Ярэда васемсот трыццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","І былі ўсе дні Магалялеэля васемсот дзевяноста пяць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","І жыў Ярэд сто шэсьцьдзесят два гады, і нарадзіў Эноха. ");
INSERT INTO beln_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","І жыў Ярэд па нараджэньні Эноха васемсот гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","І былі ўсе дні Ярэда дзевяцьсот шэсьцьдзесят два гады, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","І жыў Энох шэсьцьдзесят пяць гадоў і нарадзіў Мэтушэляха. ");
INSERT INTO beln_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","І хадзіў Энох з Богам па нараджэньні Мэтушэляха трыста гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","І былі ўсе дні Эноха трыста шэсьцьдзесят пяць гадоў. ");
INSERT INTO beln_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","І хадзіў Энох з Богам, і ня стала яго, бо забраў яго Бог. ");
INSERT INTO beln_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","І жыў Мэтушэлях сто восемдзесят сем гадоў, і нарадзіў Лямэха. ");
INSERT INTO beln_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","І жыў Мэтушэлях па нараджэньні Лямэха семсот восемдзесят два гады, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","І былі ўсе дні Мэтушэляха дзевяцьсот шэсьцьдзесят дзевяць гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","І жыў Лямэх сто восемдзесят два гады, і нарадзіў сына, ");
INSERT INTO beln_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","і назваў яго імя Ной, кажучы: “Ён пацешыць нас у рабоце нашай і ў працы рук нашых на зямлі, якую пракляў ГОСПАД”. ");
INSERT INTO beln_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","І жыў Лямэх па нараджэньні Ноя пяцьсот дзевяноста пяць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","І былі ўсе дні Лямэха семсот семдзесят сем гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","І было Ною пяцьсот гадоў, і нарадзіў Ной Сэма, Хама і Яфэта. ");
INSERT INTO beln_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","І сталася, што людзі пачалі множыцца на абліччы зямлі, і нарадзіліся ім дочкі. ");
INSERT INTO beln_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","І бачылі сыны Божыя дочак чалавечых, што яны прыгожыя, і ўзялі сабе за жонак усіх, якіх абралі. ");
INSERT INTO beln_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","І сказаў ГОСПАД: “Ня будзе Дух Мой змагацца ў чалавеку вечна, бо ён — цела. І будуць дні ягоныя сто дваццаць гадоў”. ");
INSERT INTO beln_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","У тыя дні нэфілімы жылі на зямлі, а таксама пазьней, калі сыны Божыя прыходзілі да дочак чалавечых, і тыя ім нараджалі. Былі гэта волаты, ад вякоў мужы слаўныя. ");
INSERT INTO beln_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","І бачыў ГОСПАД, што вялікае зло сярод людзей на зямлі, і што ўсе намеры думак сэрца іхняга — толькі на зло ўсякі дзень. ");
INSERT INTO beln_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","І пашкадаваў ГОСПАД, што зрабіў чалавека на зямлі, і засмуціўся ў сэрцы Сваім. ");
INSERT INTO beln_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","І сказаў ГОСПАД: “Зьнішчу чалавека, якога стварыў, з аблічча зямлі, ад чалавека да скаціны, да паўзуна, да птушкі паднебнай, бо шкадую, што зрабіў іх”. ");
INSERT INTO beln_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","А Ной знайшоў ласку ў вачах ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Вось радавод Ноя. Ной быў чалавек праведны і беззаганны ў пакаленьні сваім. Ной хадзіў з Богам. ");
INSERT INTO beln_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","І нарадзіў Ной трох сыноў: Сэма, Хама і Яфэта. ");
INSERT INTO beln_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","І сапсаваная была зямля перад абліччам Бога, і напоўнілася зямля ліхадзействам. ");
INSERT INTO beln_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","І бачыў Бог зямлю, і вось, яна сапсаваная, бо кожнае цела скрывіла шлях свой на зямлі. ");
INSERT INTO beln_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","І сказаў Бог Ною: “Канец усякаму целу прыйшоў перад аблічча Маё, бо зямля напоўнілася ліхадзействам праз іх. І вось, Я вынішчу іх з зямлі. ");
INSERT INTO beln_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Зрабі сабе каўчэг з дрэва гафэр; зробіш у каўчэгу перагародкі і пацягні яго смалой звонку і знутры. ");
INSERT INTO beln_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Вось так маеш зрабіць яго: трыста локцяў даўжыня каўчэга, пяцьдзясят локцяў шырыня яго і трыццаць локцяў вышыня яго. ");
INSERT INTO beln_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Зробіш вакно ў каўчэгу, і ў локаць скончыш яго ўгары. Уваход у каўчэг разьмесьціш з боку яго; ніжні, другі і трэці паверхі зробіш у ім. ");
INSERT INTO beln_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","І вось, Я ўзьвяду патоп водны на зямлю, каб вынішчыць пад небам усякае цела, у якім ёсьць дух жыцьця. Усё, што на зямлі, — загіне. ");
INSERT INTO beln_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","І Я заключу запавет Мой з табою, і ўвойдзеш у каўчэг ты, і сыны твае, і жонка твая, і жонкі сыноў тваіх з табою. ");
INSERT INTO beln_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","І з усяго жывога, з кожнага цела прывядзеш па пары ў каўчэг, каб засталіся жывыя з табою, мужчынскага роду і жаночага няхай яны будуць. ");
INSERT INTO beln_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","З птушак паводле гатункаў іх, са скаціны паводле гатунку яго і з усіх паўзуноў зямных паводле гатункаў іх, з усіх па двое ўвойдуць да цябе, каб засталіся жывыя. ");
INSERT INTO beln_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","І ты вазьмі сабе ўсякай ежы, якою яны кормяцца, і зьбяры яе да сябе; і будзе яна для цябе і для іх ежаю”. ");
INSERT INTO beln_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","І зрабіў Ной; усё, што загадаў яму Бог, так ён і зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","І сказаў ГОСПАД Ною: “Увайдзі ты і ўвесь дом твой у каўчэг, бо ўбачыў Я цябе праведным перад абліччам Маім у пакаленьні гэтым. ");
INSERT INTO beln_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","З усякай скаціны чыстай вазьмі з сабою сем самцоў і сем саміц, а са скаціны нячыстай — па двое, самца і саміцу. ");
INSERT INTO beln_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Таксама з птушак паднебных — сем мужчынскага роду і сем жаночага, каб захаваць жывым насеньне іхняе на абліччы ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Бо праз сем дзён Я выльлю дождж на зямлю сорак дзён і сорак начэй, і вынішчу ўсе жывыя істоты, якія Я зрабіў, з аблічча зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","І зрабіў Ной усё, што загадаў яму ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","І Ною было шэсьцьсот гадоў, і патоп водны быў на зямлю. ");
INSERT INTO beln_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","І ўвайшоў Ной, і сыны ягоныя, і жонка ягоная, і жонкі сыноў ягоных з ім у каўчэг ад вады патопу. ");
INSERT INTO beln_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Са скаціны чыстай і са скаціны, якая нячыстая, з птушак і з усяго, што поўзае па зямлі, ");
INSERT INTO beln_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","па пары ўвайшлі ў каўчэг да Ноя, мужчынскага роду і жаночага, як Бог загадаў Ною. ");
INSERT INTO beln_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","І сталася праз сем дзён, што вада патопу была на зямлі. ");
INSERT INTO beln_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","У шэсьцьсотым годзе жыцьця Ноя, у другім месяцы, у сямнаццаты дзень месяца, у гэты дзень выбіліся ўсе жаролы вялікай бездані, і вокны нябесныя адчыніліся, ");
INSERT INTO beln_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","і ішоў дождж на зямлю сорак дзён і сорак начэй. ");
INSERT INTO beln_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","У гэты самы дзень увайшоў у каўчэг Ной, і Сэм, і Хам, і Яфэт, сыны Ноя, і жонка Ноя, і тры жонкі сыноў ягоных з імі. ");
INSERT INTO beln_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Яны, і ўсякія зьвяры паводле гатунку свайго, і ўсякая скаціна паводле гатунку свайго, і ўсякія паўзуны, якія поўзаюць па зямлі, паводле гатунку свайго, і ўсякія птушкі паводле гатунку свайго, усё птаства, усе крылатыя. ");
INSERT INTO beln_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","І ўвайшлі яны па двое ў каўчэг да Ноя, па двое з кожнага цела, у якім быў дух жыцьця. ");
INSERT INTO beln_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","І ўвайшоўшыя былі мужчынскага роду і жаночага з усякага цела, як загадаў Бог. І зачыніў ГОСПАД за ім каўчэг. ");
INSERT INTO beln_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","І стаўся патоп на зямлі сорак дзён, і разьліліся воды, і паднялі каўчэг, і ён узвысіўся над зямлёю. ");
INSERT INTO beln_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","І падымаліся воды, і вельмі ўзьняліся над зямлёю, і каўчэг плаваў па абліччы водаў. ");
INSERT INTO beln_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","І вельмі моцна падняліся воды над зямлёю, і закрылі ўсе высокія горы, якія ёсьць пад усім небам. ");
INSERT INTO beln_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","На пятнаццаць локцяў угору падняліся воды, і закрылі горы. ");
INSERT INTO beln_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","І пагінула ўсякае цела, якое рухаецца па зямлі: і птушкі, і скаціна, і зьвяры, і ўсе паўзуны, што поўзаюць па зямлі, і ўсе людзі. ");
INSERT INTO beln_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Усе, якія мелі дыханьне духа жыцьця ў ноздрах сваіх, усе, што былі на сухазем’і, —паўміралі. ");
INSERT INTO beln_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","І вынішчыў Бог усякую жывую істоту, якая была на абліччы зямлі, ад чалавека да скаціны, да паўзуноў і да птушак паднебных, і былі яны вынішчаны з зямлі. І застаўся толькі Ной і тыя, што былі з ім у каўчэгу. ");
INSERT INTO beln_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","І падымаліся воды над зямлёю сто пяцьдзясят дзён. ");
INSERT INTO beln_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","І ўзгадаў Бог пра Ноя і пра ўсіх зьвяроў, і пра ўсю скаціну, што былі з ім у каўчэгу, і прывёў Бог вецер на зямлю, і супакоіліся воды. ");
INSERT INTO beln_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","І зачыніліся жаролы бездані і вокны нябесныя, і спыніўся дождж з неба. ");
INSERT INTO beln_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","І вярталіся воды з зямлі, сьцякаючы і вяртаючыся, і паменшалі воды па заканчэньні ста пяцідзесяці дзён. ");
INSERT INTO beln_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","І спыніўся каўчэг у сёмы месяц, у сямнаццаты дзень месяца, на гарах Арарат. ");
INSERT INTO beln_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","І воды сьцякалі і меншалі аж да дзясятага месяца, а ў дзясяты месяц, у першы дзень месяца, сталі бачныя вяршыні гораў. ");
INSERT INTO beln_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","І сталася па заканчэньні сарака дзён Ной адчыніў вакно каўчэгу, якое зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","І выпусьціў ён крумкача, і той лятаў туды і сюды, і варочаўся, аж пакуль ня высахла вада на зямлі. ");
INSERT INTO beln_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","І выпусьціў ён ад сябе галубку, каб убачыць, ці зыйшлі воды з аблічча зямлі. ");
INSERT INTO beln_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","І не знайшла галубка месца спачынку для ног сваіх, і вярнулася да яго ў каўчэг, бо воды былі яшчэ на абліччы ўсёй зямлі. І ён выцягнуў руку сваю, і схапіў яе, і забраў да сябе ў каўчэг. ");
INSERT INTO beln_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","І пачакаў ён яшчэ сем дзён, і зноў выпусьціў галубку з каўчэгу. ");
INSERT INTO beln_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","І вярнулася галубка да яго ўвечары, і вось, сьвежы аліўкавы лісток у дзюбе ў яе. І зразумеў Ной, што зыйшлі воды з зямлі. ");
INSERT INTO beln_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","І пачакаў ён яшчэ іншых сем дзён, і выпусьціў галубку, і яна ўжо больш да яго не вярнулася. ");
INSERT INTO beln_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","І сталася, у шэсьцьсот першым годзе, у першым месяцы, у першы дзень месяца воды на зямлі павысыхалі. І Ной адкрыў дах каўчэгу, і убачыў, што, вось, высахла аблічча зямлі. ");
INSERT INTO beln_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","А ў другім месяцы, у дваццаць сёмы дзень месяца зямля абсохла. ");
INSERT INTO beln_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","І сказаў Бог Ною, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Выйдзі з каўчэгу ты і жонка твая, і сыны твае, і жонкі сыноў тваіх з табою. ");
INSERT INTO beln_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Усіх зьвяроў, якія з табою з кожнага цела, як з птушак, так i са скаціны, і з усіх паўзуноў, што рухаюцца па зямлі, вывядзі з сабою. І няхай разыходзяцца яны на зямлі, няхай плодзяцца і множацца на зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","І выйшаў Ной, і сыны ягоныя, і жонка ягоная, і жонкі сыноў ягоных з ім. ");
INSERT INTO beln_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Усе зьвяры, усе паўзуны, усе птушкі і ўсё, што рухаецца па зямлі, паводле родаў сваіх, выйшлі з каўчэгу. ");
INSERT INTO beln_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","І збудаваў Ной ахвярнiк ГОСПАДУ, і ўзяў з кожнай скаціны чыстай і з кожнай птушкі чыстай, і склаў іх у ахвяру цэласпаленьня на ахвярнiку. ");
INSERT INTO beln_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","І адчуў ГОСПАД пах прыемны, і сказаў ГОСПАД у сэрцы Сваім: “Ня буду больш праклінаць зямлю з-за чалавека, бо настаўленьне сэрца чалавечага злое ад маладосьці яго. І больш ня буду забіваць усяго жывога, як гэта зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Яшчэ ў-ва ўсе дні зямлі ня спыняцца сяўба і жніво, сьцюжа і сьпякота, лета і зіма, дзень і ноч”. ");
INSERT INTO beln_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","І дабраславіў Бог Ноя і сыноў ягоных, і сказаў ім: “Пладзіцеся і множцеся, і напаўняйце зямлю. ");
INSERT INTO beln_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Няхай баяцца вас і дрыжаць перад вамі усе зьвяры зямлі, і ўсе птушкі паднебныя; і ўсё, што рухаецца па зямлі, і ўсе рыбы марскія аддадзеныя ў рукі вашыя. ");
INSERT INTO beln_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Усё, што рухаецца, што жыве, будзе вам на ежу; як траву зялёную, Я даў вам усё. ");
INSERT INTO beln_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Толькі цела з душою яго, з крывёю яго, ня ешце. ");
INSERT INTO beln_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","І толькі кроў вашу душаў вашых Я буду шукаць, з рукі ўсякага зьвера буду шукаць яе, i з рукі чалавека, з рукі кожнага брата ягонага буду шукаць душу чалавека. ");
INSERT INTO beln_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Хто праліе кроў чалавека, таго кроў будзе праліта рукою чалавека, бо чалавек зроблены на вобраз Божы. ");
INSERT INTO beln_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","А вы пладзіцеся і множцеся, распаўсюджвайцеся на зямлі і множцеся на ёй”. ");
INSERT INTO beln_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","І сказаў Бог Ною і сынам ягоным з ім, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Вось, Я заключаю запавет Мой з вамі і з насеньнем вашым пасьля вас, ");
INSERT INTO beln_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","і з усякаю душою жывою, якая з вамі: з птушкамі, са скацінай і з усімі зьвярамі зямнымі, якія з вамі, з усімі, што выйшлі з каўчэгу, з усімі зьвярамі зямлі. ");
INSERT INTO beln_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","І Я заключаю запавет Мой з вамі, і ўжо больш ня будзе вынішчана ўсякае цела водамі патопу, і больш ня будзе патопу, каб нiшчыць зямлю”. ");
INSERT INTO beln_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","І сказаў Бог: “Гэта знак запавету, якi Я заключаю паміж Мною і вамі і ўсякай душой жывою, якая з вамі, ў пакаленьні вечныя. ");
INSERT INTO beln_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Вясёлку Маю кладу на хмарах, і будзе яна знакам запавету паміж Мною і паміж зямлёю. ");
INSERT INTO beln_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","І станецца, калі расьцягну хмары над зямлёю, будзе відаць вясёлку на хмарах, ");
INSERT INTO beln_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","і Я ўзгадаю запавет Мой, якi паміж Мною і вамі і ўсякай душой жывою ў-ва ўсякім целе, і ня будзе больш водаў патопу, каб нішчыць усякае цела. ");
INSERT INTO beln_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","І будзе гэтая вясёлка на хмарах, і Я ўбачу яе, і ўзгадаю вечны запавет паміж Богам і ўсякай душой жывою ў-ва ўсякім целе, якое ёсьць на зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","І сказаў Бог Ною: “Гэта знак запавету, якi Я даю, паміж Мною і ўсякім целам, якое ёсьць на зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","І былі сыны Ноя, якія выйшлі з каўчэгу: Сэм, Хам і Яфэт. А Хам быў бацькам Ханаана. ");
INSERT INTO beln_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Гэтыя тры былі сынамі Ноя, і ад іх залюднілася ўся зямля. ");
INSERT INTO beln_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","І Ной пачаў абрабляць зямлю, і пасадзіў вінаграднік. ");
INSERT INTO beln_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","І выпіў ён віна, і напіўся, і ляжаў голы ў сярэдзіне намёту. ");
INSERT INTO beln_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","І ўбачыў Хам, бацька Ханаана, голасьць бацькі свайго, і распавёў двум братам сваім, якія былі звонку. ");
INSERT INTO beln_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","І ўзялі Сэм і Яфэт адзежу і ўсклалі на плечы свае, і пайшлі сьпінаю, і накрылі голасьць бацькі свайго; а твары іхнія былі зьвернутыя назад, і яны ня бачылi голасьцi бацькі свайго. ");
INSERT INTO beln_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","І прачнуўся Ной ад ап’яненьня свайго, і даведаўся, што яму зрабіў малодшы сын ягоны, ");
INSERT INTO beln_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","і сказаў: “Пракляты Ханаан! Будзе ён слугою слугаў у братоў сваіх”. ");
INSERT INTO beln_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","І сказаў: “Дабраслаўлёны ГОСПАД, Бог Сэма! Няхай будзе Ханаан слугою ягоным. ");
INSERT INTO beln_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Няхай пашырыць Бог Яфэта, і будзе ён жыць ў намётах Сэма, і Ханаан будзе ў яго слугою”. ");
INSERT INTO beln_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","І жыў Ной пасьля патопу трыста пяцьдзясят гадоў. ");
INSERT INTO beln_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","І было ўсіх дзён Ноя дзевяцьсот пяцьдзясят гадоў, і ён памёр. ");
INSERT INTO beln_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Вось радавод сыноў Ноя: Сэма, Хама і Яфэта. І нарадзіліся ім сыны пасьля патопу. ");
INSERT INTO beln_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Сыны Яфэта: Гамэр, Магог, Мадай, Яван, Туваль, Мэшэх і Тырас. ");
INSERT INTO beln_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Сыны Гамэра: Ашкеназ, Рыфат і Тагарма. ");
INSERT INTO beln_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Сыны Явана: Эліша i Таршыш, Кіттым і Даданім. ");
INSERT INTO beln_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ад іх паходзяць астравы народаў у землях іхніх, кожны паводле мовы сваёй і паводле плямёнаў сваіх, у народах сваіх. ");
INSERT INTO beln_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Сыны Хама: Куш, Міцраім, Пут i Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Сыны Куша: Сэва, Хавіля, Саўта, Раама i Саўтэха. Сыны Раамы: Шэва і Дэдан. ");
INSERT INTO beln_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","А Куш нарадзіў Німрода. Ён пачаў быць магутным на зямлі. ");
INSERT INTO beln_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ён быў магутны паляўнічы перад абліччам ГОСПАДА. Таму кажуць: “Як Німрод, магутны паляўнічы перад абліччам ГОСПАДА”. ");
INSERT INTO beln_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","І пачаткам валадараньня яго былі Бабілон, Эрэх, Акад і Кальнэ ў зямлі Шынаар. ");
INSERT INTO beln_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","З тае зямлі выйшаў Ашур і пабудаваў Нініву, Рэхавот-Ір, Калях ");
INSERT INTO beln_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","і Рэсэн, вялікі горад між Нінівай і Каляхам. ");
INSERT INTO beln_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","А Міцраім нарадзіў Людыма, і Анаміма, і Легавіма, і Нафтухіма, ");
INSERT INTO beln_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","і Патрусіма і Касьлюхіма, ад якіх паходзяць Філістынцы, і Кафторыма. ");
INSERT INTO beln_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","А Ханаан нарадзіў Сідона, першароднага свайго, і Хета, ");
INSERT INTO beln_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","і Евусея, і Амарэя, і Гіргашэя, ");
INSERT INTO beln_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","і Хівея, і Аркея, і Сінея, ");
INSERT INTO beln_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","і Арвадзея, і Цэмарэя, і Хаматэя; а пасьля расьсеяліся плямёны Хананейскія. ");
INSERT INTO beln_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","І была мяжа Хананейцаў ад Сідону ў напрамку Герару аж да Газы, а ў напрамку Садома і Гаморы, і Адмы, і Цэвоіма — аж да Ляшы. ");
INSERT INTO beln_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Гэта сыны Хама паводле сваіх плямёнаў, паводле сваіх моваў, у землях сваіх і ў народах сваіх. ");
INSERT INTO beln_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","А Сэм, бацька ўсіх сыноў Эвэра, старэйшы брат Яфэта, нарадзіў сыноў. ");
INSERT INTO beln_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Сыны Сэма: Элям, Ашур, Арпахшад, Люд і Арам. ");
INSERT INTO beln_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Сыны Арама: Уц, Хуль, Гетэр і Маш. ");
INSERT INTO beln_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","А Арпахшад нарадзіў Шэляха, а Шэлях нарадзіў Эвэра. ");
INSERT INTO beln_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","А ў Эвэра нарадзіліся два сыны: аднаго імя Пэлег, таму што ў дні ягоныя разьдзялілася зямля, а імя брата ягонага — Ёктан. ");
INSERT INTO beln_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ёктан нарадзіў Альмадада, і Шалефа, і Хацармавэта, i Яраха, ");
INSERT INTO beln_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","і Гадарама, і Узаля, і Дыклю, ");
INSERT INTO beln_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","і Аваля, і Авімаэля, і Шэву, ");
INSERT INTO beln_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","і Афіра, і Хавіля, і Ёвава. Гэтыя ўсе — сыны Ёктана. ");
INSERT INTO beln_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Месца іх пражываньня было ад Мэшы ў напрамку Сэфару на ўсход. ");
INSERT INTO beln_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Гэта сыны Сэма паводле сваіх плямёнаў, паводле сваіх моваў, у землях сваіх і ў народах сваіх. ");
INSERT INTO beln_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Гэта вось плямёны сыноў Ноя паводле радаводаў у народах сваіх. Ад іх распаўсюдзiліся народы на зямлі пасьля патопу. ");
INSERT INTO beln_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","І была на ўсёй зямлі адна мова і адны словы. ");
INSERT INTO beln_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","І сталася, калі яны вандравалі з усходу, знайшлі раўніну ў зямлі Шынаар і там пасяліліся. ");
INSERT INTO beln_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","І сказалі яны адзін аднаму: “Давайце наробім цэглы і абпалім яе агнём”. І была ў іх цэгла замест камянёў, а смала была ў іх замест вапны. ");
INSERT INTO beln_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","І сказалі яны: “Давайце зробім сабе горад і вежу, у якой верх будзе да неба, і гэтым зробім сабе імя, каб не расьцярушыліся мы па абліччу ўсёй зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","І зыйшоў ГОСПАД, каб убачыць горад і вежу, якую будавалі сыны чалавечыя. ");
INSERT INTO beln_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","І сказаў ГОСПАД: “Вось, адзін народ і адна для ўсіх мова. І вось, што пачалі яны рабіць. І цяпер не спыніць іх ва ўсім, што яны задумалі зрабіць. ");
INSERT INTO beln_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Давайце зыйдзем і памяшаем там іхнюю мову, каб не маглі разумець мовы адзін аднаго”. ");
INSERT INTO beln_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","І расьцярушыў іх ГОСПАД з таго месца па абліччы ўсёй зямлі, і яны перасталі будаваць горад. ");
INSERT INTO beln_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Дзеля таго названа імя яго Бабілон, бо там зьмяшаў ГОСПАД мову ўсяе зямлі, і адтуль расьцярушыў іх ГОСПАД па абліччы ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Вось радавод Сэма. Сэм меў сто гадоў і нарадзіў Арпахшада праз два гады пасьля патопу. ");
INSERT INTO beln_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","І жыў Сэм па нараджэньні Арпахшада пяцьсот гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","І Арпахшад жыў трыццаць пяць гадоў, і нарадзіў Шэляха. ");
INSERT INTO beln_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","І жыў Арпахшад па нараджэньні Шэляха чатырыста тры гады, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","І Шэлях жыў трыццаць гадоў, і нарадзіў Эвэра. ");
INSERT INTO beln_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","І жыў Шэлях па нараджэньні Эвэра чатырыста тры гады, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","І жыў Эвэр трыццаць чатыры гады, і нарадзіў Пэлега. ");
INSERT INTO beln_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","І жыў Эвэр па нараджэньні Пэлега чатырыста трыццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","І жыў Пэлег трыццаць гадоў, і нарадзіў Рэву. ");
INSERT INTO beln_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","І жыў Пэлег па нараджэньні Рэву дзьвесьце дзевяць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","І жыў Рэву трыццаць два гады, і нарадзіў Сэруга. ");
INSERT INTO beln_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","І жыў Рэву па нараджэньні Сэруга дзьвесьце сем гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","І жыў Сэруг трыццаць гадоў, і нарадзіў Нахора. ");
INSERT INTO beln_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","І жыў Сэруг па нараджэньні Нахора дзьвесьце гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","І жыў Нахор дваццаць дзевяць гадоў, і нарадзіў Тэраха. ");
INSERT INTO beln_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","І жыў Нахор па нараджэньні Тэраха сто дзевятнаццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO beln_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","І жыў Тэрах семдзесят гадоў, і нарадзіў Абрама, Нахора і Арана. ");
INSERT INTO beln_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","І вось радавод Тэраха. Тэрах нарадзіў Абрама, Нахора і Арана, а Аран нарадзіў Лёта. ");
INSERT INTO beln_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","І памёр Аран перад абліччам Тэраха, бацькі свайго, у зямлі нараджэньня свайго, у Уры Халдэйскім. ");
INSERT INTO beln_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","І ўзялі Абрам і Нахор сабе жонак. Імя жонкі Абрама — Сарай, а імя жонкі Нахора — Мілька, дачка Арана, бацькі Мількі і бацькі Іскі. ");
INSERT INTO beln_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","І была Сарай бясплодная, яна ня мела дзяцей. ");
INSERT INTO beln_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","І ўзяў Тэрах Абрама, сына свайго, і Лёта, сына Арана, унука свайго, і Сарай, нявестку сваю, жонку Абрама, сына свайго, і выйшаў з імі з Уру Халдэйскага, каб ісьці ў зямлю Ханаан. І прыйшлі ў Харан, і пасяліліся там. ");
INSERT INTO beln_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","І было дзён Тэраха дзьвесьце пяць гадоў жыцьця, і памёр Тэрах у Харане. ");
INSERT INTO beln_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","І сказаў ГОСПАД Абраму: “Выйдзі з зямлі тваёй і ад родзічаў тваіх, і з дому бацькі твайго ў зямлю, якую Я пакажу табе. ");
INSERT INTO beln_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","І Я зраблю з цябе вялікі народ, і дабраслаўлю цябе, і ўзьвялічу імя тваё, і будзеш ты дабраславенствам. ");
INSERT INTO beln_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","І Я дабраслаўлю тых, якія будуць дабраслаўляць цябе, а тых, якія будуць праклінаць цябе, Я пракляну. І будуць дабраслаўлёныя ў табе ўсе плямёны зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","І пайшоў Абрам, як загадаў яму ГОСПАД, і з ім пайшоў Лёт. Абрам меў семдзесят пяць гадоў, калі выйшаў з Харану. ");
INSERT INTO beln_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","І ўзяў Абрам Сарай, жонку сваю, і Лёта, сына брата свайго, і ўсю маёмасьць, якую прыдбалі, і слугаў, якіх набылі ў Харане, і выйшлі, каб пайсьці ў зямлю Ханаан. І прыйшлі яны ў зямлю Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","І прайшоў Абрам гэтую зямлю аж да мясцовасьці Сыхем, аж да дубровы Марэ. А ў той зямлі жылі тады Хананейцы. ");
INSERT INTO beln_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","І зьявіўся ГОСПАД Абраму, і сказаў: “Насеньню твайму Я дам гэтую зямлю”. І ён збудаваў там ахвярнiк ГОСПАДУ, Які зьявіўся яму. ");
INSERT INTO beln_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Адтуль перайшоў ён на гору на ўсход ад Бэтэлю і паставіў намёт свой, маючы Бэтэль на захадзе, а Гай на ўсходзе. І там збудаваў ахвярнiк ГОСПАДУ, і заклікаў імя ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","І вандараваў Абрам далей, і павандраваў у Нэгеў. ");
INSERT INTO beln_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","І стаўся голад у той зямлі. І зыйшоў Абрам у Эгіпет, каб пажыць там, бо вялікі голад быў у той зямлі. ");
INSERT INTO beln_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","І сталася, калі набліжаліся яны да Эгіпту, сказаў ён жонцы сваёй Сарай: “Вось, я ведаю, што ты жанчына прыгожая, ");
INSERT INTO beln_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","і станецца, калі ўбачаць цябе Эгіпцяне і скажуць: “Гэта жонка яго”, заб’юць мяне, а цябе пакінуць. ");
INSERT INTO beln_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Дык кажы, што ты сястра мая, каб мне было добра дзеля цябе і каб я застаўся жывы дзякуючы табе”. ");
INSERT INTO beln_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","І сталася, калі Абрам прыйшоў у Эгіпет, ўбачылі Эгіпцяне, што Сарай вельмі прыгожая жанчына. ");
INSERT INTO beln_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","І ўбачылі яе князі фараона, і хвалілі яе перад фараонам. І была ўзятая жанчына ў дом фараона. ");
INSERT INTO beln_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","А Абраму было добра дзеля яе. І сталася, што атрымаў ён авечак і валоў, і аслоў, і слугаў, і нявольніцаў, і асьліцаў, і вярблюдаў. ");
INSERT INTO beln_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","І наведаў ГОСПАД фараона і дом ягоны вялікімі карамі з прычыны Сарай, жонкі Абрама. ");
INSERT INTO beln_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","І паклікаў фараон Абрама, і сказаў яму: “Што ты мне зрабіў? Чаму не сказаў мне, што яна — жонка твая? ");
INSERT INTO beln_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Чаму ты казаў: “яна — сястра мая”, і я ўзяў яе сабе за жонку? Вось табе жонка твая, бяры і ідзі!” ");
INSERT INTO beln_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","І загадаў фараон людзям сваім, і яны выслалі Абрама, і жонку ягоую, і ўсё, што ён меў. ");
INSERT INTO beln_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","І падняўся Абрам з Эгіпту сам і жонка ягоная, і ўсё, што ён меў, і Лёт з ім, у Нэгеў. ");
INSERT INTO beln_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","І быў Абрам вельмі багаты статкамі, срэбрам і золатам. ");
INSERT INTO beln_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","І ён ішоў у падарожжы сваім з Нэгеву ў Бэтэль, аж да месца, дзе раней быў намёт ягоны між Бэтэлем і Гаем, ");
INSERT INTO beln_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","да таго месца, дзе раней ён збудаваў ахвярнiк; і там клікаў Абрам імя ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Таксама Лёт, які ішоў з Абрамам, меў авечкі, валы і намёты. ");
INSERT INTO beln_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","І не магла зямля насіць іх, каб жылі разам, бо маёмасьць іх была вялікая і не маглі яны жыць разам. ");
INSERT INTO beln_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","І была спрэчка між пастухамі статкаў Абрама і пастухамі статкаў Лёта. А ў той час Хананейцы і Пэрэзэі жылі ў той зямлі. ");
INSERT INTO beln_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","І сказаў Абрам Лёту: “Няхай ня будзе спрэчкі паміж мной і табой, і паміж пастухамі маімі і пастухамі тваімі, бо мы ж браты. ");
INSERT INTO beln_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ці ня ўся гэтая зямля перад табою? Прашу, адлучыся ад мяне! Калі ты ўлева, дык я — управа, а калі ты ўправа, дык я — улева”. ");
INSERT INTO beln_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","І ўзьняў Лёт вочы свае, і ўбачыў усю ваколіцу каля Ярдану аж да Цаару, бо ўся яна была абвадняная перад тым, як зьнішчыў ГОСПАД Садом і Гамору, як сад ГОСПАДА і як зямля Эгіпецкая. ");
INSERT INTO beln_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","І выбраў сабе Лёт усю ваколіцу каля Ярдану. І рушыў Лёт на ўсход, і аддзяліліся яны адзін ад аднаго. ");
INSERT INTO beln_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Абрам жыў у зямлі Ханаан, а Лёт жыў ў гарадах тае ваколіцы, і паставіў намёты аж да Садома. ");
INSERT INTO beln_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","А жыхары Садома былі ліхімі і вялікімі грэшнікамі перад ГОСПАДАМ. ");
INSERT INTO beln_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","І сказаў ГОСПАД Абраму пасьля таго, як Лёт адлучыўся ад яго: “Узьнімі вочы твае і паглядзі з месца, дзе ты цяпер, на поўнач і на поўдзень, на ўсход і на захад. ");
INSERT INTO beln_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Бо ўсю зямлю, якую бачыш, Я дам табе і насеньню твайму на вякі. ");
INSERT INTO beln_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","І зраблю насеньне тваё, як пясок зямлі. Калі чалавек зможа палічыць пясок зямлі, тады і тваё насеньне палічана будзе. ");
INSERT INTO beln_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Устань і прайдзі па зямлі гэтай ў даўжыню і шырыню яе, бо Я дам яе табе”. ");
INSERT INTO beln_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","І паставіў Абрам намёт, і пайшоў, і абжыўся каля дубровы Мамрэ, што ў Хеўроне, і збудаваў там ахвярнiк ГОСПАДУ. ");
INSERT INTO beln_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","І сталася за дзён Амрафэля, валадара Шынаару, і Арыёха, валадара Элясару, і Кедарляамэра, валадара Эляму, і Тыдаля, валадара Гаіму, ");
INSERT INTO beln_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","пачалі яны вайну супраць Бэры, валадара Садома, і Біршы, валадара Гаморы, і Шынава, валадара Адмы, і Шэмэвэра, валадара Цэвоіма, і валадара Бэлі або Цаару. ");
INSERT INTO beln_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Усе яны злучыліся ў даліне Сыддым, яна цяпер Мора Салёнае. ");
INSERT INTO beln_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дванаццаць гадоў служылі яны Кедарляамэру, а ў трынаццатым годзе ўзбунтаваліся. ");
INSERT INTO beln_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","А ў чатырнаццатым годзе прыйшоў Кедарляамэр і валадары, якія з ім, і пабілі Рэфаімаў у Аштэрот-Карнаіме, і Зузімаў у Гаме, і Эмімаў у Шавэ-Кірыятаіме, ");
INSERT INTO beln_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","і Харэяў на гары іхняй Сэір аж да Эль-Парану, што ў пустыні. ");
INSERT INTO beln_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","І вярнуліся яны, і прыйшлі да Эн-Мішпату, які цяпер Кадэш, і пабілі ўсю краіну Амалека, а таксама Амарэяў, што жылі ў Хацацон-Тамары. ");
INSERT INTO beln_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","І выйшаў валадар Садома, і валадар Гаморы, і валадар Адмы, і валадар Цэвоіма, і валадар Бэлі або Цаару, і пашыхтаваліся ў даліне Сыддым да бою ");
INSERT INTO beln_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","з Кедарляамэрам, валадаром Эляму, і Тыдалем, валадаром Гаіму, і Амрафэлем, валадаром Шынаару, і Арыёхам, валадаром Элясару, чатыры валадары супраць пяці. ");
INSERT INTO beln_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","І былі ў даліне Сыддым ямы, ямы смалавыя. І ўцякалі валадары Садома і Гаморы, і ўпалі ў тыя ямы, а астатнія ўцяклі на гору. ");
INSERT INTO beln_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","І ўзялі пераможцы ўсю маёмасьць Садома і Гаморы і ўсе запасы харчоў, і пайшлі. ");
INSERT INTO beln_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","І ўзялі яны Лёта, сына брата Абрама, і маёмасьць ягоную, і пайшлі. А ён жыў у Садоме ");
INSERT INTO beln_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","І прыйшоў адзін з тых, што ўцяклі, і паведаміў Абраму Гебраю, які жыў каля дубровы Мамрэ Амарэя, брата Эшколя і брата Анэра, якія заключылі запавет з Абрамам. ");
INSERT INTO beln_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","І пачуў Абрам, што ўзяты ў палон брат ягоны, і ўзброіў трыста васемнаццаць спраўных слугаў сваіх, народжаных у доме яго, і пусьціўся ў пагоню аж пад Дан. ");
INSERT INTO beln_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","І, падзяліўшыся, напаў на іх ноччу, ён і слугі ягоныя, і разьбіў іх, і гнаў іх аж да Ховы, што зьлева ад Дамаску. ");
INSERT INTO beln_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","І вярнуў ён усю маёмасьць, а таксама Лёта, брата свайго, і маёмасьць ягоную, а таксама жанчын і народ. ");
INSERT INTO beln_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","І выйшаў валадар Садома насустрач яму, калі ён вяртаўся пасьля пабіцьця Кедарляамэра і валадароў, што з ім былі, у даліну Шавэ, яна цяпер даліна Валадарская. ");
INSERT INTO beln_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","А Мэльхісэдэк, валадар Салему, вынес хлеб і віно, а ён быў сьвятаром Бога Найвышэйшага, ");
INSERT INTO beln_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","і дабраславіў яго, і сказаў: “Дабраслаўлёны Абрам праз Бога Найвышэйшага, Пана неба і зямлі. ");
INSERT INTO beln_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","І дабраслаўлёны Бог Найвышэйшы, Які аддаў ворагаў тваіх у рукі твае”. І даў яму Абрам дзесяціну з усяго. ");
INSERT INTO beln_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","І сказаў валадар Садома Абраму: “Аддай мне людзей, а маёмасьць вазьмі сабе”. ");
INSERT INTO beln_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","І сказаў Абрам валадару Садома: “Узьнімаю руку сваю да ГОСПАДА, Бога Найвышэйшага, Пана неба і зямлі, ");
INSERT INTO beln_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","што ані ніткі, ані раменьчыка ад сандалаў, нічога не вазьму з усяго таго, што тваё, каб ты не сказаў: “Я ўзбагаціў Абрама”, ");
INSERT INTO beln_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","за выняткам таго, што зьелі юнакі, ды апроч часткі для людзей, што хадзілі са мною; Анэр, Эшколь і Мамрэ няхай возьмуць частку сваю”. ");
INSERT INTO beln_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Пасьля гэтых падзеяў было слова ГОСПАДА да Абрама ў відзежы, кажучы: “Ня бойся, Абраме! Я – шчыт твой, узнагарода твая вельмі вялікая”. ");
INSERT INTO beln_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","І сказаў Абрам: “Уладару ГОСПАДЗЕ, што Ты дасі мне? Я хаджу бязьдзетны, і распарадчык ў доме маім — Эліезэр з Дамаску”. ");
INSERT INTO beln_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","І сказаў Абрам: “Вось, ня даў Ты мне насеньня. І вось, народжаны ў доме маім слуга будзе спадкаемцам маім”. ");
INSERT INTO beln_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","І вось, слова ГОСПАДА да яго, кажучы: “Ня ён успадкаеміць цябе, але той, які выйдзе з нутра твайго, успадкаеміць цябе”. ");
INSERT INTO beln_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","І вывеў яго вонкі, і сказаў: “Паглядзі на неба і палічы зоркі, калі зможаш палічыць іх”. І сказаў яму: “Такім будзе насеньне тваё”. ");
INSERT INTO beln_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","І паверыў ён ГОСПАДУ, і Ён залічыў гэта яму за праведнасьць. ");
INSERT INTO beln_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","І сказаў яму: “Я – ГОСПАД, Які вывеў цябе з Уру Халдэйскага, каб даць табе гэтую зямлю ў валоданьне”. ");
INSERT INTO beln_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","А ён сказаў: “Уладару ГОСПАДЗЕ, з чаго магу ведаць, што я буду валодаць ёю?” ");
INSERT INTO beln_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","І Госпад сказаў яму: “Вазьмі Мне трохгадовую цялушку, і трохгадовую казу, і трохгадовага барана, турка і галубянятка”. ");
INSERT INTO beln_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","І Абрам узяў ўсё гэта, і расьцяў іх уздоўж, і паклаў кожную частку адну насупраць другой, але птушак не расьцінаў. ");
INSERT INTO beln_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","І зьляцеліся драпежныя птушкі на гэтае мяса, і Абрам адганяў іх. ");
INSERT INTO beln_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","І сталася, калі сонца заходзіла, моцны сон ахапіў Абрама. І вось жах і цемра вялікая ахапілі яго. ");
INSERT INTO beln_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","І сказаў Госпад Абраму: “Ведаючы, ведай, што насеньне тваё будзе прыхаднямі ў зямлі не сваёй, і будуць служыць яны, і будуць прыгнятаць іх чатырыста гадоў. ");
INSERT INTO beln_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Але з народам, якому будуць яны служыць, Я буду змагацца, і пасьля таго выйдуць яны з вялікай маёмасьцю. ");
INSERT INTO beln_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","А ты пойдзеш да бацькоў сваіх у супакоі, і будзеш пахаваны ў добрай старасьці. ");
INSERT INTO beln_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","І ў чацьвёртым пакаленьні яны вернуцца сюды, бо яшчэ не дапоўнілася мера беззаконьняў Амарэяў”. ");
INSERT INTO beln_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","І сталася, калі зайшло сонца і была цемра, вось, дым, як бы з печы, і полымя агню прайшлі між расьцятымі жывёламі. ");
INSERT INTO beln_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","У той дзень заключыў ГОСПАД з Абрамам запавет, кажучы: “Я даю гэтую зямлю насеньню твайму, ад ракі Эгіпецкай аж да вялікай ракі, ракі Эўфрат: ");
INSERT INTO beln_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Кенэяў, Кенэзэяў, Кадманеяў, ");
INSERT INTO beln_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Хетаў, Пэрэзэяў, Рэфаімаў, ");
INSERT INTO beln_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Амарэяў, Хананейцаў, Гіргашэяў і Евусеяў”. ");
INSERT INTO beln_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","А Сарай, жонка Абрама, не нараджала яму. І мела яна нявольніцу Эгіпцянку, а імя ейнае — Агар. ");
INSERT INTO beln_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","І сказала Сарай Абраму: “Вось жа, замкнуў ГОСПАД мяне, каб я не нараджала. Дык увайдзі да нявольніцы маёй, можа ад яе атрымаю дзіця”. І паслухаў Абрам голасу Сарай. ");
INSERT INTO beln_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","І ўзяла Сарай, жонка Абрама, Агар Эгіпцянку, нявольніцу сваю, калі мінула дзесяць гадоў жыцьця Абрама ў зямлі Ханаан, і дала яе Абраму, мужу свайму, за жонку. ");
INSERT INTO beln_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","І ён увайшоў да Агары, і яна зачала, і ўбачыла, што зачала, і стала пагарджаць гаспадыняй сваёй у вачах сваіх. ");
INSERT INTO beln_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","І сказала Сарай Абраму: “Крыўда мая праз цябе! Я дала табе нявольніцу маю на ўлоньне тваё, і яна ўбачыла, што зачала, і стала пагарджаць мною ў вачах сваіх. Няхай ГОСПАД судзіць паміж мной і табой”. ");
INSERT INTO beln_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","І сказаў Абрам Сарай: “Вось, нявольніца твая ў руцэ тваёй, рабі з ёй, што добра ў вачах тваіх”. І Сарай стала ўціскаць яе, і яна ўцякла ад аблічча яе. ");
INSERT INTO beln_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","І знайшоў яе анёл ГОСПАДАЎ каля крыніцы вады ў пустыні, каля крыніцы пры дарозе на Шур, ");
INSERT INTO beln_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","і сказаў: “Агар, нявольніца Сарай, адкуль ты прыйшла і куды ідзеш?” Яна адказала: “Ад аблічча Сарай, гаспадыні маёй, я ўцякаю”. ");
INSERT INTO beln_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","І сказаў ёй Анёл ГОСПАДАЎ: “Вярніся да гаспадыні сваёй і скарыся пад руку яе”. ");
INSERT INTO beln_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","І сказаў ёй Анёл ГОСПАДАЎ: “Памнажаючы, памножу насеньне тваё, нельга будзе палічыць яго з прычыны мноства”. ");
INSERT INTO beln_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","І сказаў ёй Анёл ГОСПАДАЎ: “Вось, ты зачала і народзіш сына, і назавеш імя яго Ізмаэль, таму што ГОСПАД пачуў пра уціск твой. ");
INSERT INTO beln_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","І будзе ён чалавекам, падобным да дзікага асла, рука ягоная супраць усіх, і рукі ўсіх — супраць яго; і будзе ён жыць перад абліччам усіх братоў сваіх”. ");
INSERT INTO beln_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","І назвала яна імя ГОСПАДА, Які прамаўляў да яе: “Ты — Бог, Які бачыць мяне”. Бо сказала яна: “Ці ня тут я бачыла Таго, Які бачыць мяне”. ");
INSERT INTO beln_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Дзеля таго калодзеж гэты назвалі Бээр-Ляхай-Рой. Вось, ён паміж Кадэшам і Барэдам. ");
INSERT INTO beln_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","І нарадзіла Агар Абраму сына. І назваў Абрам імя сына свайго, якога нарадзіла яму Агар, Ізмаэль. ");
INSERT INTO beln_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","І Абрам меў восемдзесят шэсьць гадоў, калі Агар нарадзіла Ізмаэля Абраму. ");
INSERT INTO beln_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","І было Абраму дзевяноста дзевяць гадоў. І зьявіўся ГОСПАД Абраму, і сказаў яму: “Я — Бог Усемагутны. Хадзі перад абліччам Маім і будзь беззаганны. ");
INSERT INTO beln_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","І Я заключу запавет Мой паміж Мной і табой, і павялічу цябе вельмі, вельмі”. ");
INSERT INTO beln_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","І ўпаў Абрам на аблічча сваё, а Бог прамовіў да яго, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Я ёсьць, вось запавет Мой з табою, і ты будзеш бацькам мноства народаў. ");
INSERT INTO beln_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","І ўжо ня будзе звацца імя тваё Абрам, але будзе імя тваё Абрагам, бо Я паставіў цябе бацькам мноства народаў. ");
INSERT INTO beln_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","І Я павялічу цябе вельмі, вельмі, і выведу з цябе народы, і будуць паходзіць ад цябе валадары. ");
INSERT INTO beln_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","І Я заключу запавет Мой паміж Мною і табой, і насеньнем тваім пасьля цябе ў пакаленьнях іхніх як запавет вечны, што Я буду Богам тваім і насеньня твайго пасьля цябе. ");
INSERT INTO beln_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","І Я дам табе і насеньню твайму пасьля цябе зямлю вандраваньня твайго, усю зямлю Ханаан на ўласнасьць вечную, і Я буду ім Богам”. ");
INSERT INTO beln_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","І сказаў Бог Абрагаму: “А ты захоўвай запавет Мой, ты і насеньне тваё пасьля цябе ў пакаленьнях сваіх. ");
INSERT INTO beln_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Гэта вось запавет Мой, які вы павінны захаваць паміж Мной і вамі, і насеньнем тваім пасьля цябе: няхай будзе ў вас абрэзаны кожны мужчынскага роду. ");
INSERT INTO beln_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","І вы будзеце абразаць цела скуравінкі вашай, і будзе гэта на знак запавету паміж Мною і вамі. ");
INSERT INTO beln_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","У восьмы дзень ад нараджэньня няхай будзе абрэзаны ў вас кожны мужчынскага роду ў пакаленьнях вашых, народжаны ў доме або куплены за грошы у кожнага чужынца, які ня ёсьць з насеньня твайго. ");
INSERT INTO beln_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Мае быць абрэзаны і народжаны ў доме тваім, і куплены за срэбра тваё; і будзе запавет Мой на целе вашым як запавет вечны. ");
INSERT INTO beln_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Неабрэзаны ж мужчынскага роду, які не абрэжа цела скуравінкі сваёй, няхай будзе вынішчана душа тая з народу свайго, бо ён парушыў запавет Мой”. ");
INSERT INTO beln_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","І сказаў Бог Абрагаму: “Сарай, жонку тваю, ня будзеш зваць імя яе Сарай, але Сара будзе імя яе. ");
INSERT INTO beln_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","І Я дабраслаўлю яе, і дам з яе табе сына. І Я дабраслаўлю яе, і стануцца з яе народы, і валадары народаў будуць з яе”. ");
INSERT INTO beln_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","І ўпаў Абрагам на аблічча сваё, і засьмяяўся, і сказаў у сэрцы сваім: “Ці ж стогадоваму народзіцца хто? І ці Сара, дзевяностагадовая, можа нарадзіць?” ");
INSERT INTO beln_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","І сказаў Абрагам Богу: “О, каб хоць Ізмаэль жыў перад абліччам Тваім!” ");
INSERT INTO beln_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","І сказаў Бог: “Але Сара, жонка твая, народзіць табе сына, і ты назавеш імя яго Ісаак; і Я заключу запавет Мой з ім як запавет вечны і з насеньнем яго пасьля яго. ");
INSERT INTO beln_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","І адносна Ізмаэля Я пачуў цябе: вось, Я дабраслаўлю яго, і распладжу яго, і памножу яго вельмі, вельмі; ён народзіць дванаццаць князёў, і Я зраблю яго народам вялікім. ");
INSERT INTO beln_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Але запавет Мой Я заключу з Ісаакам, якога народзіць табе Сара ў гэты самы час у наступным годзе”. ");
INSERT INTO beln_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","І скончыў прамаўляць да яго, і узьняўся Бог ад Абрагама. ");
INSERT INTO beln_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","І ўзяў Абрагам Ізмаэля, сына свайго, і ўсіх народжаных у доме сваім, і ўсіх купленых за срэбра сваё, ўсіх мужчынскага роду з дому Абрагама, і абрэзаў цела скуравінкі іх у той самы дзень, як прамаўляў яму Бог. ");
INSERT INTO beln_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Абрагам меў дзевяноста дзевяць гадоў, калі абрэзаў цела скуравінкі сваёй, ");
INSERT INTO beln_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","а Ізмаэль, сын ягоны, меў трынаццаць гадоў, калі было абрэзана цела скуравінкі яго. ");
INSERT INTO beln_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","У той самы дзень былі абрэзаны Абрагам і Ізмаэль, сын ягоны. ");
INSERT INTO beln_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","І ўсе мужчыны дому яго, народжаныя ў доме і купленыя за срэбра ў чужынцаў былі абрэзаныя з ім. ");
INSERT INTO beln_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","І зьявіўся яму ГОСПАД каля дубровы Мамрэ, калі ён сядзеў ля ўваходу ў намёт ў сьпякоту дня. ");
INSERT INTO beln_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","І падняў ён вочы свае, і глянуў, і вось, тры мужы стаяць насупраць яго. І ўбачыў, і выбег ад уваходу ў намёт насустрач ім, і пакланіўся да зямлі, ");
INSERT INTO beln_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","і сказаў: “Госпадзе, калі я знайшоў ласку ў вачах Тваіх, прашу, не мінай слугі Свайго. ");
INSERT INTO beln_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Возьмуць трохі вады, і абмыюць ногі Вашыя, і прыхінецеся пад дрэвам. ");
INSERT INTO beln_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","А я вазьму кавалак хлеба, і пасіліце сэрцы Вашыя, потым пойдзеце, бо дзеля гэтага вы прайшлі каля слугі Вашага”. Яны сказалі: “Зрабі так, як сказаў”. ");
INSERT INTO beln_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","І пасьпяшаў Абрагам у намёт да Сары, і сказаў: “Пасьпяшайся, замяшай тры меркі найлепшай мукі і зрабі аладак”. ");
INSERT INTO beln_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","І пабег Абрагам да быдла, і ўзяў тлустае і добрае цяля, і даў юнаку, і той хутка прыгатаваў яго. ");
INSERT INTO beln_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","І ўзяў масла і малака, і цяля, якое прыгатаваў, і паклаў перад абліччам Іх, і сам стаў каля Іх пад дрэвам, і яны елі. ");
INSERT INTO beln_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","І сказалі яму: “А дзе Сара, жонка твая?” Ён сказаў: “Вось, у намёце”. ");
INSERT INTO beln_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","А Той сказаў: “Вяртаючыся, вярнуся да цябе ў гэты час жыцьця праз год, і вось, будзе сын ў Сары, жонкі тваёй”. А Сара слухала ля ўваходу ў намёт, які быў за ім. ");
INSERT INTO beln_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Абрагам жа і Сара былі старыя, увайшлі ў гады, і спынілася ў Сары звычайнае жаночае. ");
INSERT INTO beln_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","І засьмяялася Сара ў сабе, кажучы: “Пасьля таго, як я састарэла, ці ж буду мець асалоду? І гаспадар мой стары”. ");
INSERT INTO beln_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","І сказаў ГОСПАД Абрагаму: “Чаму сьмяялася Сара, кажучы: “Няўжо я сапраўды магу нарадзіць, калі я старая?” ");
INSERT INTO beln_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ці ж ёсьць справа, цяжкая для ГОСПАДА? У прызначаны час вярнуся да цябе ў гэты час жыцьця праз год, і Сара будзе мець сына”. ");
INSERT INTO beln_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","І запярэчыла Сара, кажучы: “Я не сьмяялася,” бо яна спалохалася. Але Ён сказаў: “Не, ты сьмяялася!” ");
INSERT INTO beln_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","І падняліся адтуль тыя мужы, і скіравалі аблічча Сваё да Садому, а Абрагам пайшоў з Імі, праводзячы Іх. ");
INSERT INTO beln_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","І ГОСПАД сказаў: “Ці ж схаваю Я перад Абрагамам, што маю зрабіць? ");
INSERT INTO beln_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Абрагам станецца народам вялікім і магутным, і будуць дабраслаўлёныя ў ім ўсе народы зямлі. ");
INSERT INTO beln_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Бо Я спазнаў яго, каб ён загадаў сынам сваім і дому свайму пасьля сябе, і будуць захоўваць шлях ГОСПАДАЎ, чыніць праведнасьцьт і суд, каб ГОСПАД зьдзейсьніў Абрагаму ўсё, што сказаў яму”. ");
INSERT INTO beln_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","І сказаў ГОСПАД: “Крык Садому і Гаморы вялікі, і грэх іхні вельмі цяжкі. ");
INSERT INTO beln_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Дык зыйду і пагляджу, ці паводле крыку, які даходзіць да Мяне, учыняюць усё, ці не, і буду гэта ведаць”. ");
INSERT INTO beln_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","І павярнуліся тыя мужы, і пайшлі ў Садом, а Абрагам яшчэ стаяў перад абліччам ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","І падыйшоў Абрагам, і сказаў: “Няўжо загубіш праведнага разам з бязбожным? ");
INSERT INTO beln_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Можа, ёсьць у горадзе пяцьдзясят праведнікаў, няўжо Ты загубіш і не прабачыш гэтай мясцовасьці дзеля пяцідзесяці праведнікаў, якія ў ім? ");
INSERT INTO beln_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Няхай будзе далёкім ад Цябе, каб Ты ўчыніў такую справу, каб забіць праведнага з бязбожным, каб праведнаму было таксама, як і бязбожнаму! Няхай будзе далёкім ад Цябе! Ці ж Судзьдзя ўсёй зямлі ня ўчыніць правасудзьдзя?” ");
INSERT INTO beln_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","І сказаў ГОСПАД: “Калі знайду ў Садоме пяцьдзясят праведнікаў у горадзе, дзеля іх прабачу ўсёй мясцовасьці”. ");
INSERT INTO beln_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","І адказаў Абрагам, і сказаў: “Вось жа пачаў я гаварыць да Госпада майго, хоць я — пыл і попел. ");
INSERT INTO beln_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Можа, ня хопіць пяці да гэтых пяцідзесяці праведнікаў, няўжо дзеля нястачы пяці зьнішчыш увесь горад?” І сказаў Госпад: “Ня зьнішчу, калі знайду там сорак пяць”. ");
INSERT INTO beln_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","І працягваў гаварыць з Ім, і сказаў: “Можа, знойдзецца там сорак?” І Ён сказаў: “Не зраблю гэтага дзеля сарака”. ");
INSERT INTO beln_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","І сказаў ён: “Няхай ня гневаецца Госпад мой, і я буду гаварыць. Можа, знойдзецца там трыццаць?” І Ён сказаў: “Не зраблю, калі знайду там трыццаць”. ");
INSERT INTO beln_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","І сказаў ён: “Вось, я пачаў гаварыць да Госпада майго. Можа, знойдзецца там дваццаць?” І Ён сказаў: “Ня зьнішчу дзеля дваццаці”. ");
INSERT INTO beln_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","І сказаў ён: “Няхай ня гневаецца Госпад мой, і я буду гаварыць яшчэ раз. Можа, знойдзецца там дзесяць?” І Ён сказаў: “Ня зьнішчу дзеля дзесяці”. ");
INSERT INTO beln_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","І пайшоў ГОСПАД, скончыўшы гаварыць з Абрагамам, а Абрагам вярнуўся ў сваё месца. ");
INSERT INTO beln_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","І прыйшлі два анёлы ў Садом увечары, а Лёт сядзеў у браме Садома. І ён убачыў, і пайшоў насустрач ім, і пакланіўся тварам да зямлі, ");
INSERT INTO beln_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","і сказаў: “Вось, прашу, гаспадары мае, зьвярніце ў дом слугі вашага і пераначуйце, і памыйце ногі свае, а раніцою ўстанеце і пойдзеце ў дарогу сваю”. А яны сказалі: “Не, бо мы будзем начаваць на вуліцы”. ");
INSERT INTO beln_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Але ён іх вельмі упрошваў, і яны зьвярнуліся да яго, і ўвайшлі ў дом ягоны. І ён справіў ім гасьціну, і напёк праснакоў, і яны елі. ");
INSERT INTO beln_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Яшчэ не ляглі яны спаць, як людзі з гораду, людзі Садомскія, атачылі дом, ад малога да старога, увесь народ з усіх канцоў. ");
INSERT INTO beln_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","І паклікалі яны Лёта, і сказалі яму: “Дзе тыя людзі, што прыйшлі да цябе ноччу? Выведзі іх да нас, і мы спазнаем іх”. ");
INSERT INTO beln_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","І выйшаў да іх Лёт да уваходу, і замкнуў за сабою дзьверы, ");
INSERT INTO beln_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","і сказаў: “Прашу, браты мае, не рабіце ліхога. ");
INSERT INTO beln_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Вось, маю дзьве дачкі, якія не спазналі мужа, выведу іх да вас, і вы рабіце з імі, што добра ў вачах вашых! Толькі людзям гэтым нічога не рабіце, бо яны прыйшлі ў цень даху майго”. ");
INSERT INTO beln_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Але яны сказалі: “Ідзі прэч”. І сказалі: “Сам прыйшоў пажыць, і будзе судзіць, судзячы нас? Цяпер будзе табе горш, чым ім”. І накінуліся на чалавека гэтага, на Лёта , і падыйшлі, каб выламіць дзьверы. ");
INSERT INTO beln_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","І выцягнулі мужы тыя рукі свае, і ўцягнулі Лёта да сябе ў дом, і замкнулі дзьверы. ");
INSERT INTO beln_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","А людзей, што былі пры ўваходзе ў дом, ад найменшага да найбольшага, пакаралі сьлепатою, і яны змучыліся, шукаючы выхаду. ");
INSERT INTO beln_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","І сказалі тыя мужы Лёту: “Ці хто яшчэ ёсьць у цябе тут? Зяця, сыноў тваіх і дачок тваіх, усіх, хто ў цябе ёсць у горадзе, выведзі з гэтага месца, ");
INSERT INTO beln_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","бо мы зьнішчым гэтую мясцовасьць, таму што вялікі крык іхні перад абліччам ГОСПАДА, і ГОСПАД паслаў нас зьнішчыць яе”. ");
INSERT INTO beln_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","І выйшаў Лёт, і гаварыў да зяцёў сваіх, якія мелі ўзяць дочак ягоных, і сказаў: “Уставайце, выходзьце з гэтага месца, бо ГОСПАД мае зьнішчыць горад”. І было ў вачах зяцёў ягоных гэта, нібыта ён жартуе. ");
INSERT INTO beln_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Калі ўзыйшла зараніца, анёлы прысьпешвалі Лёта, кажучы: “Уставай, бяры жонку тваю і дзьве дочкі твае, якія тут, каб не загінуў ты праз беззаконьні гораду гэтага”. ");
INSERT INTO beln_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","А як ён марудзіў, схапілі тыя мужы за руку яго, і за руку жонку ягоную, і за руку абодвух дачок ягоных, бо ГОСПАД меў спагаду да яго, і вывелі яго, і паставілі па-за горадам. ");
INSERT INTO beln_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","І сталася, калі вывелі іх вонкі, сказаў адзін з іх: “Уцякай дзеля душы тваёй, і не аглядайся назад, і не затрымлівайся ў гэтай ваколіцы. Уцякай на гору, каб ты не загінуў!” ");
INSERT INTO beln_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","І сказаў Лёт да іх: “О не, Госпадзе! ");
INSERT INTO beln_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Вось жа, слуга Твой знайшоў ласку ў вачах Тваіх, і Ты павялічыў міласэрнасьць Сваю, якую зьявіў для мяне, захоўваючы пры жыцьці душу маю. Але я не магу ўцячы на гору, каб не напаткала мяне ліхое, і я не памёр. ");
INSERT INTO beln_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Вось жа горад гэты блізка, каб бегчы туды, і ён малы. Дазволь уцячы мне туды, — ці ж не малы ён, — і будзе жыць душа мая”. ");
INSERT INTO beln_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","І сказаў яму: “Вось, Я прыняў аблічча тваё і ў гэтым слове, і ня зьнішчу горад, пра які ты гаварыў. ");
INSERT INTO beln_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Сьпяшайся, уцякай туды, бо Я не магу нічога рабіць, пакуль ты ня прыйдзеш туды”. Таму і названае імя гэтаму гораду Цаар. ");
INSERT INTO beln_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Сонца узыйшло над зямлёю, і Лёт увайшоў у Цаар. ");
INSERT INTO beln_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","І ГОСПАД лінуў на Садом і Гамору дождж серкі і агня ад ГОСПАДА зь неба, ");
INSERT INTO beln_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","і зруйнаваў гарады гэтыя, і ўсю ваколіцу, і ўсіх жыхароў гарадоў гэтых, і расьліны зямлі. ");
INSERT INTO beln_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","І аглянулася жонка ягоная, ідучы за ім, і сталася слупом солі. ");
INSERT INTO beln_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","І ўстаў Абрагам раніцаю на тое месца, дзе стаяў перад абліччам ГОСПАДА, ");
INSERT INTO beln_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","і глянуў на аблічча Садома і Гаморы, і на аблічча ўсёй зямлі той ваколіцы, і ўбачыў, і вось дым падымаецца з зямлі, быццам з печы. ");
INSERT INTO beln_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","І сталася, калі Бог зьнішчыў гарады гэтай ваколіцы, узгадаў Бог пра Абрагама, і выслаў Лёта з-паміж руйнаваньня, калі руйнаваў гарады, у якіх жыў Лёт. ");
INSERT INTO beln_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","І падняўся Лёт з Цаару, і жыў на гары, і дзьве дачкі ягоныя з ім, бо баяўся жыць ў Цаары. І жыў ён у пячоры, сам і дзьве дачкі ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","І сказала старэйшая малодшай: “Бацька наш стары, і няма мужчыны на зямлі, каб мог прыйсьці да нас па звычаю ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Хадзем, напоім бацьку нашага віном і ляжам з ім, каб ажывіць насеньне бацькі нашага”. ");
INSERT INTO beln_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","І напаілі яны ў тую ноч бацьку свайго віном; і ўвайшла старэйшая, і ляжала з бацькам, а ён ня ведаў, ані калі яна легла, ані калі ўстала. ");
INSERT INTO beln_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","І сталася на другі дзень, сказала старэйшая малодшай: “Вось, я ў мінулую ноч ляжала з бацькам нашым. Нпоім яго віном таксама ў гэтую ноч, і ты ўвойдзеш, і ляжаш з ім, і мы ажывім насеньне бацькі нашага”. ");
INSERT INTO beln_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","І напаілі яны таксама ў гэтую ноч бацьку свайго віном, і ўвайшла малодшая дачка, і ляжала з ім, а ён ня ведаў, ані калі яна легла, ані калі ўстала. ");
INSERT INTO beln_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","І зачалі абедзьве дачкі Лёта ад бацькі свайго. ");
INSERT INTO beln_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","І нарадзіла старэйшая сына, і назвала імя яго Мааў. Ён — бацька Мааву аж да сёньня. ");
INSERT INTO beln_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","І малодшая таксама нарадзіла сына, і назвала імя яго Бэн-Аммі. Ён — бацька сыноў Амона аж да сёньня. ");
INSERT INTO beln_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","I рушыў адтуль Абрагам у зямлю Нэгеў, і пасяліўся між Кадэшам і Шурам, і жыў у Герары. ");
INSERT INTO beln_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","I сказаў Абрагам пра Сару, жонку сваю: “Яна — сястра мая”. I паслаў Абімэлех, валадар Герару, і ўзяў Сару. ");
INSERT INTO beln_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","I прыйшоў Бог да Абімэлеха ў сьне ўночы, і сказаў яму: “Вось, ты памрэш праз жанчыну, якую ты ўзяў, бо яна мае мужа”. ");
INSERT INTO beln_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","А Абімэлех не набліжаўся да яе, і сказаў: “Госпадзе! Няўжо і народ праведны ты заб’еш? ");
INSERT INTO beln_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ці ж ня ён сказаў мне: “Яна — сястра мая”. I яна таксама казала: “Ён — брат мой”. У прастаце сэрца свайго і ў чысьціні рук сваіх учыніў я гэта”. ");
INSERT INTO beln_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","I сказаў яму Бог у сьне: “І Я ведаю, што ў прастаце сэрца свайго ты ўчыніў гэта, і Я ўтрымаў цябе, каб ты не саграшыў перада Мною; і Я ня даў табе дакрануцца да яе. ");
INSERT INTO beln_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","А цяпер зьвярні жонку гэтага мужа, бо ён — прарок, і ён будзе маліцца за цябе, і ты будзеш жыць. А калі ня зьвернеш, ведай, што сьмерцю памрэш ты і ўсе, хто твае”. ");
INSERT INTO beln_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","I ўстаў Абімэлех раніцай, і паклікаў усіх слугаў сваіх, і расказаў усе словы гэтыя ў вушы іхныя; і моцна напалохаліся людзі гэтыя. ");
INSERT INTO beln_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","I паклікаў Абімэлех Абрагама, і сказаў яму: “Што ты нам нарабіў? Чым зграшыў я супраць цябе, што ты навёў на мяне і на валадарства маё грэх вялікі? Учынкі, якія ня робяць, ты зрабіў мне”. ");
INSERT INTO beln_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","I сказаў Абімэлех Абрагаму: “Што ж ты думаў, калі рабіў гэтыя рэчы?” ");
INSERT INTO beln_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","I сказаў Абрагам: “Вось, я сказаў: “Напэўна, няма страху Божага на месцы гэтым, і заб’юць мяне з прычыны жонкі маёй”. ");
INSERT INTO beln_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","І, сапраўды, яна — сястра мая, яна — дачка бацькі майго, толькі не дачка маці маёй; і яна стала маёй жонкаю. ");
INSERT INTO beln_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","I сталася, як вывеў мяне Бог з дому бацькі майго, я сказаў ёй: У тым міласэрнасьць твая, якую ты можаш зрабіць для мяне: у кожным месцы, куды мы прыйдзем, кажы пра мяне: “Ён —брат мой””. ");
INSERT INTO beln_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","I ўзяў Абімэлех авечак і валоў, і слугаў, і нявольніцаў, і даў Абрагаму, і зьвярнуў яму Сару, жонку ягоную. ");
INSERT INTO beln_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I сказаў Абімэлех: “Вось, зямля мая перад табою. Дзе добра ў вачах тваіх, жыві”. ");
INSERT INTO beln_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","А Сары сказаў: “Вось, я даю тысячу срэбнікаў брату твайму. Няхай гэта будзе табе заслонаю перад вачамі ўсіх, якія з табою, і перад усімі ты без віны”. ");
INSERT INTO beln_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","I памаліўся Абрагам да Бога, і аздаравіў Бог Абімэлеха, і жонку ягоную, і ягоныя нявольніцы, і яны нараджалі, ");
INSERT INTO beln_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","бо зачыніўшы, зачыніў ГОСПАД кожнае ўлоньне ў доме Абімэлеха з прычыны Сары, жонкі Абрагама. ");
INSERT INTO beln_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","І ГОСПАД наведаў Сару, як сказаў; і ўчыніў ГОСПАД Сары, як гаварыў. ");
INSERT INTO beln_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","I зачала Сара, і нарадзіла сына Абрагаму ў старасьці ягонай, у час, пра які казаў яму Бог. ");
INSERT INTO beln_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","I назваў Абрагам сына свайго, які нарадзіўся яму, якога нарадзіла яму Сара, Ісаак. ");
INSERT INTO beln_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I абрэзаў Абрагам Ісаака, сына свайго, на восьмы дзень, як загадаў яму Бог. ");
INSERT INTO beln_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","І было Абрагаму сто гадоў, калі нарадзіўся ў яго Ісаак, сын ягоны. ");
INSERT INTO beln_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","I сказала Сара: “Сьмех учыніў з мяне Бог. Кожны, хто пачуе, будзе сьмяяцца з мяне”. ");
INSERT INTO beln_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","I сказала: “Хто сказаў бы Абрагаму: “Сара будзе карміць грудзьдзю сыноў”, бо я нарадзіла сына ў старасьці ягонай”. ");
INSERT INTO beln_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","I вырасла дзіцятка, і было аднятае ад грудзей, і ўчыніў Абрагам вялікую гасьціну ў той дзень, калі Ісаак быў адняты ад грудзей. ");
INSERT INTO beln_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","I ўбачыла Сара сына Агар Эгіпцянкі, якога тая нарадзіла Абрагаму, што ён насьміхаецца, ");
INSERT INTO beln_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","і сказала Абрагаму: “Выжані гэтую нявольніцу і сына ейнага, бо ня будзе мець спадчыну сын нявольніцы гэтае з сынам маім Ісаакам”. ");
INSERT INTO beln_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","I было гэта ліхім у вачах Абрагама адносна сына ягонага. ");
INSERT INTO beln_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","I сказаў Бог Абрагаму: “Няхай ня будзе гэта ліхім у вачах тваіх адносна хлопчыка і адносна нявольніцы тваёй. У-ва ўсім, што скажа табе Сара, слухай голасу ейнага, бо ў Ісааку будзе названа табе насеньне. ");
INSERT INTO beln_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Таксама сына нявольніцы Я зраблю народам, бо ён — насеньне тваё”. ");
INSERT INTO beln_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","І ўстаў Абрагам раніцаю, і ўзяў хлеб і мех вады, і даў Агар, і палажыў ёй на плечы, і выслаў яе разам з дзіцём. І яна пайшла, і блукала ў пустыні Бээр-Шэва. ");
INSERT INTO beln_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","I скончылася вада ў мяху, і яна пакінула дзіця пад адным з кустоў, ");
INSERT INTO beln_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","і пайшла, і села насупраць так далёка, як стрэліць з луку; бо яна сказала: “Няхай ня буду глядзець на сьмерць дзіцяці”. I сядзела насупраць, і ўзьняла голас свой, і плакала. ");
INSERT INTO beln_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","I пачуў Бог голас хлопчыкаў; і паклікаў анёл Божы да Агар з неба, і сказаў ёй: “Што з табою, Агар? Ня бойся; бо пачуў Бог голас хлопчыка з месца, дзе Ён ёсьць. ");
INSERT INTO beln_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Устань, паднімі хлопца і трымай яго моцна рукою сваёю, бо Я зраблю яго народам вялікім”. ");
INSERT INTO beln_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","I адчыніў Бог вочы ейныя, і яна ўбачыла студню з вадою, і пайшла, і напоўніла мех вады, і дала піць хлопцу. ");
INSERT INTO beln_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","I быў Бог з хлопцам; і ён вырас, і жыў у пустыні, і быў стралец з луку. ");
INSERT INTO beln_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","І ён жыў у пустыні Паран; і ўзяла яму маці ягоная жонку з зямлі Эгіпецкае. ");
INSERT INTO beln_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","I сталася ў той час, і сказаў Абімэлех і Піколь, гетман ягоны, Абрагаму, кажучы: “Бог з табою ва ўсім, што ты робіш. ");
INSERT INTO beln_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","I цяпер прысягні мне Богам тут, што ты ня здрадзіш ані мне, ані нашчадку майму, ані ўнуку майму, і як я чыніў міласэрнасьць табе, так ты будзеш рабіць са мною і з зямлёю, у якой ты жывеш”. ");
INSERT INTO beln_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","I сказаў Абрагам: “Прысягаю”. ");
INSERT INTO beln_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","I дакараў Абрагам Абімэлеха з прычыны студні вады, якую забралі слугі Абімэлеха. ");
INSERT INTO beln_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","I сказаў Абімэлех: “Ня ведаю я, хто ўчыніў гэтую рэч, і ты не расказваў мне, і я ня чуў нічога аж да сёньняшняга дня”. ");
INSERT INTO beln_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","I ўзяў Абрагам авечак і валоў, і даў Абімэлеху, і заключылі яны абодва запавет. ");
INSERT INTO beln_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","I паставіў Абрагам сем ягнят з чарады асобна. ");
INSERT INTO beln_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","I сказаў Абімэлех Абрагаму: “Навошта гэтыя сем ягнятаў, якіх ты паставіў асобна?” ");
INSERT INTO beln_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","I сказаў Абрагам: “Бо сем гэтых ягнят возьмеш ад рукі мае, каб яны былі мне сьведчаньнем, што я выкапаў гэтую студню”. ");
INSERT INTO beln_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Дзеля таго і названа гэтае месца Бээр-Шэва, бо там яны абодва прысягалі. ");
INSERT INTO beln_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","I заключылі запавет у Бээр-Шэве. I ўстаў Абімэлех і Піколь, гетман ягоны, і вярнуліся ў зямлю Філістынскую. ");
INSERT INTO beln_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","I пасадзіў Абрагам гай у Бээр-Шэве, і клікаў там імя ГОСПАДА, Бога вечнага. ");
INSERT INTO beln_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","I жыў Абрагам у зямлі Філістынскай шмат дзён. ");
INSERT INTO beln_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","I сталася пасьля гэтых падзеяў, і Бог выспрабоўваў Абрагама, і сказаў яму: “Абрагаме!” I ён сказаў: “Вось я!” ");
INSERT INTO beln_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I сказаў Бог: “Вазьмі сына свайго, адзінага свайго, якога ты любіш, Ісаака; і ідзі ў зямлю Морыя, і там складзі яго на ахвяру цэласпаленьня на адной з гораў, пра якую Я скажу табе”. ");
INSERT INTO beln_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","І ўстаў Абрагам рана раніцаю, і асядлаў асла свайго, узяў двух юнакоў сваіх з сабою і Ісаака, сына свайго, і насек дроваў на цэласпаленьне, і ўстаў, і пайшоў на месца, пра якое сказаў яму Бог. ");
INSERT INTO beln_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","На трэці дзень узьняў Абрагам вочы свае і ўбачыў тое месца здалёк. ");
INSERT INTO beln_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","I сказаў Абрагам юнакам сваім: “Застаньцеся тут з аслом; а мы з хлопцам пойдзем аж туды, і паклонімся, і вернемся да вас”. ");
INSERT INTO beln_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","I ўзяў Абрагам дровы на цэласпаленьне, і ўзлажыў на Ісаака, сына свайго; і ўзяў у рукі агонь і вялікі нож, і пайшлі абодва разам. ");
INSERT INTO beln_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I сказаў Ісаак Абрагаму, бацьку свайму: “Ойча мой!” Той сказаў: “Вось я, сыне мой”. Ён сказаў: “Вось агонь і дровы, а дзе ягня на цэласпаленьне?” ");
INSERT INTO beln_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","I сказаў Абрагам: “Бог угледзіць Сабе ягня на цэласпаленьне, сыне мой”. I ішлі абодва разам. ");
INSERT INTO beln_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","I прыйшлі на месца, пра якое казаў яму Бог; і збудаваў там Абрагам ахвярнік, і разлажыў дровы, і зьвязаў Ісаака, сына свайго, і палажыў яго на ахвярнік, зьверху на дровы. ");
INSERT INTO beln_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","I выцягнуў Абрагам руку сваю, і ўзяў вялікі нож, каб закалоць сына свайго. ");
INSERT INTO beln_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","I паклікаў яго анёл ГОСПАДАВЫ з неба, і сказаў: “Абрагаме! Абрагаме!” Той сказаў: “Вось я!” ");
INSERT INTO beln_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","I сказаў ГОСПАД: “Не выцягвай рукі сваёй на хлопца і не рабі яму нічога, бо цяпер Я ведаю, што ты баішся Бога і не пашкадаваў дзеля Мяне сына свайго, адзінага свайго”. ");
INSERT INTO beln_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","I ўзьняў Абрагам вочы свае, і ўбачыў, і вось баран ззаду, увязаны ў хмызах рагамі сваімі. I пайшоў Абрагам, і ўзяў барана, і ахвяраваў яго на цэласпаленьне замест сына свайго. ");
INSERT INTO beln_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","I назваў Абрагам імя месца гэтага: “ГОСПАД угледзіць” . Дзеля гэтага і цяпер кажуць: “На гары ГОСПАД дасьць угледзець”. ");
INSERT INTO beln_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","I паклікаў анёл ГОСПАДАВЫ Абрагам другі раз з неба, ");
INSERT INTO beln_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","і сказаў: “На Сябе Самога прысягаю, кажа ГОСПАД, за тое, што ты гэта зрабіў, і не пашкадаваў сына свайго, адзінага свайго, ");
INSERT INTO beln_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","дабраслаўляючы, дабраслаўлю цябе і, памнажаючы, памножу насеньне тваё, як зоркі нябесныя і як пясок на беразе мора; і успадкаеміць насеньне тваё брамы ворагаў сваіх. ");
INSERT INTO beln_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I будуць дабраслаўлёныя ў насеньні тваім усе народы зямлі за тое, што ты паслухаў голасу Майго”. ");
INSERT INTO beln_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","I вярнуўся Абрагам да юнакоў сваіх, і ўсталі, і пайшлі разам да Бээр-Шэвы. I жыў Абрагам у Бээр-Шэве. ");
INSERT INTO beln_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","I сталася пасьля гэтых падзеяў, паведамілі Абрагаму, кажучы: “Вось, нарадзіла таксама Мілька сыноў Нахору, брату твайму: ");
INSERT INTO beln_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уца, першароднага ягонага, і Буза, брата ягонага, і Кемуэля, бацьку Арама. ");
INSERT INTO beln_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","і Кесэда, і Хазо, і Пільдаша, і Ідлафа, і Бэтуэля”. ");
INSERT INTO beln_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","А Бэтуэль нарадзіў Рэбэку. Васьмёх гэтых нарадзіла Мілька Нахору, брату Абрагама. ");
INSERT INTO beln_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","I наложніца ягоная, імя якой Рэўма, нарадзіла таксама Тэваха, і Гахама, і Тахаша, і Маху. ");
INSERT INTO beln_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","I было жыцьця Сары сто дваццаць сем год, гэта гады жыцьця Сары. ");
INSERT INTO beln_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","I памерла Сара ў Кірыят-Арбе, гэта значыць, у Хеўроне, у зямлі Ханаан. I прыйшоў Абрагам, каб мець жалобу па Сары і плакаць па ёй. ");
INSERT INTO beln_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","I ўстаў Абрагам ад аблічча памёршае сваёй, і прамовіў да сыноў Хета, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Прыхадзень і пасяленец я у вас; дайце мне ў вас на ўласнасьць магілу, і я пахаваю памёршую маю ад аблічча майго”. ");
INSERT INTO beln_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","I адказалі сыны Хета Абрагаму, кажучы яму: ");
INSERT INTO beln_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Паслухай нас, пане мой! Князь Божы ты сярод нас; у найлепшай з нашых магілаў пахавай памёршую сваю; ніхто з нас не адмовіць табе магілы сваёй на пахаваньне памёршае тваёй”. ");
INSERT INTO beln_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","І ўстаў Абрагам, і пакланіўся народу зямлі, сынам Хета, ");
INSERT INTO beln_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","і гутарыў з імі, кажучы: “Калі жадае душа вашая, каб я пахаваў памёршую маю ад аблічча майго, паслухайце мяне і папрасіце за мяне Эфрона, сына Цахара, ");
INSERT INTO beln_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","і ён дасьць мне пячору Махпэля, што ў яго, якая на канцы поля ягонага, за поўнае срэбра дасьць мне яе, каб меў я сярод вас магілу на ўласнасьць”. ");
INSERT INTO beln_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","А Эфрон сядзеў сярод сыноў Хета. І адказаў Эфрон Хет Абрагаму ўслых усіх сыноў Хета, якія ўваходзілі ў брамы гораду ягонага, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Не, пане мой! Паслухай мяне: поле я даю табе і пячору, якая на ім, даю табе, перад вачыма сыноў народу майго даю табе яе, пахавай памёршую тваю”. ");
INSERT INTO beln_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","I пакланіўся Абрагам перад народам зямлі, ");
INSERT INTO beln_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","і сказаў Эфрону ўслых народу зямлі, кажучы: “Калі б ты толькі паслухаў мяне, я даю табе срэбра за поле гэтае; вазьмі ў мяне, і я пахаваю там памёршую маю”. ");
INSERT INTO beln_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","І адказаў Эфрон Абрагаму, кажучы яму: ");
INSERT INTO beln_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Пане мой, паслухай мяне! Зямля вартая чатырыста сыкляў срэбра; што гэта для мяне і для цябе? І пахавай памёршую тваю”. ");
INSERT INTO beln_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","I паслухаў Абрагам Эфрона; і адважыў Абрагам Эфрону срэбра, пра якое ён казаў услых сыноў Хета, чатырыста сыкляў срэбра, якое ўжывалася ў купцоў. ");
INSERT INTO beln_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","I атрымаў поле Эфрона, якое ў Махпэлі, што насупраць Мамрэ, поле тое і пячора, якая на ім, і кажнае дрэва, якое на полі, ў-ва ўсіх межах ягоных наўкола, ");
INSERT INTO beln_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Абрагам, які купіў яго перад вачыма сыноў Хета, усіх, якія ўваходзілі ў брамы гораду ягонага. ");
INSERT INTO beln_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","І пасьля гэтага Абрагам пахаваў Сару, жонку сваю, у пячоры на полі ў Махпэлі, насупраць Мамрэ, якое завецца Хеўрон, у зямлі Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","I атрымаў Абрагам тое поле і тую пячору, якая на ім, як магілу на ўласнасьць ад сыноў Хета. ");
INSERT INTO beln_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","I Абрагам быў стары, і меў шмат дзён, і ГОСПАД дабраславіў Абрагама ў-ва ўсім. ");
INSERT INTO beln_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","I сказаў Абрагам слузе свайму, старэйшаму ў доме сваім, які меў уладу над усім, што ў яго было: “Палажы руку сваю пад сьцягно маё, ");
INSERT INTO beln_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","і я прывяду цябе да прысягі на ГОСПАДА, Бога неба і Бога зямлі, што ты ня возьмеш жонкі сыну майму з дачок Хананейскіх, сярод якіх я жыву, ");
INSERT INTO beln_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","але пойдзеш у зямлю маю і да родзічаў маіх, і возьмеш жонку сыну майму Ісааку”. ");
INSERT INTO beln_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","I сказаў яму слуга: “Можа, не пажадае тая жанчына ісьці са мною сюды, у гэтую зямлю. Ці маю я завесьці сына твайго адсюль у тую зямлю, з якой ты выйшаў?” ");
INSERT INTO beln_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","I сказаў яму Абрагам: “Сьцеражыся, каб не завесьці туды сына майго. ");
INSERT INTO beln_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ГОСПАД, Бог неба, Які ўзяў мяне з дому бацькі майго і з зямлі нараджэньня майго, і Які казаў да мяне, і Які прысягнуў мне, кажучы: “Насеньню твайму Я дам гэтую зямлю”, — Ён пашле анёла Свайго перад абліччам тваім, і ты возьмеш адтуль жонку сыну майму. ");
INSERT INTO beln_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","А калі не пажаде тая жанчына ісьці з табою, ты будзеш вызвалены ад гэтае прысягі маёй; толькі сына майго не завядзі туды”. ");
INSERT INTO beln_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","I палажыў слуга руку сваю пад сьцягно Абрагама, пана свайго, і прысягнуў яму ў гэтай справе. ");
INSERT INTO beln_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","I ўзяў той слуга дзесяць вярблюдоў пана свайго, і пайшоў, і ўсялякае даброцьце пана ягонага было ў руцэ ягонай. І ўстаў ён, і пайшоў у Арам-Нагараім, ў горад Нахора. ");
INSERT INTO beln_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","I дазволіў ён вярблюдам ўкленчыць вонкі гораду каля студні вады пад вечар, у той час, калі выходзяць чэрпаць ваду. ");
INSERT INTO beln_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","I сказаў ён: “ГОСПАДЗЕ, Божа пана майго Абрагама! Зрабі, каб сталася ласка мне сёньня, і ўчыні міласэрнасьць пану майму Абрагаму. ");
INSERT INTO beln_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Вось, я стаю каля крыніцы вады, і дочкі жыхароў гораду выходзяць чэрпаць ваду. ");
INSERT INTO beln_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Няхай станецца, што тая дзяўчына, якой я скажу: “Нахілі збан свой, і я нап’юся”, і якая скажа: “Пі, я і вярблюды твае напаю”, вось гэта тая, якую Ты прызначыў слузе Твайму Ісааку, і з гэтага пазнаю, што Ты ўчыніў міласэрнасьць пану майму”. ");
INSERT INTO beln_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I сталася, перш, чым скончыў ён казаць, вось, выйшла Рэбэка, якая нарадзілася ў Бэтуэля, сына Мількі, жонкі Нахора, брата Абрагама, і збан ейны на плячы ў яе. ");
INSERT INTO beln_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","І была тая дзяўчына вельмі прыгожая з выгляду, дзяўчына, якую мужчына не пазнаў. І зыйшла яна да крыніцы, і напоўніла збан, і вярталася. ");
INSERT INTO beln_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","I пабег слуга насустрач ёй, і сказаў: “Дай мне глынуць крыху вады са збана твайго”. ");
INSERT INTO beln_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","I сказала яна: “Пі, пане мой”. I пасьпяшалася, і спусьціла збан на руку сваю, і дала яму напіцца. ");
INSERT INTO beln_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","I скончыла яна даваць яму піць, і сказала: “Таксама для вярблюдаў тваіх я буду чэрпаць, пакуль не нап’юцца”. ");
INSERT INTO beln_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","I пасьпяшалася, і выліла збан свой у карыта, і пабегла зноў да студні чэрпаць, і чэрпала для ўсіх вярблюдаў ягонымх. ");
INSERT INTO beln_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","І чалавек той моўчкі ўглядаўся на яе, каб спазнаць, ці даў ГОСПАД посьпех на шляху ягоным, ці не. ");
INSERT INTO beln_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","I сталася, як вярблюды напіліся, узяў чалавек той залатое колца ў паўсыкля вагою і два бранзалеты на рукі ейныя, вага якіх – дзесяць сыкляў золата, ");
INSERT INTO beln_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","і сказаў: “Чыя ты дачка? Скажы мне. Ці ёсьць у доме бацькі твайго месца для нас, каб начаваць?” ");
INSERT INTO beln_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","І яна сказала яму: “Я — дачка Бэтуэля, сына Мількі, якога яна нарадзіла Нахору”. ");
INSERT INTO beln_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","I сказала яму: “Таксама саломы і корму шмат у нас, а таксама месца, каб начаваць”. ");
INSERT INTO beln_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","I схіліўся чалавек той, і пакланіўся ГОСПАДУ, ");
INSERT INTO beln_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","і сказаў: “Дабраслаўлёны ГОСПАД, Бог пана майго Абрагама, Які не ўхіліў міласэрнасьці Сваёй і вернасьці Сваёй ад пана майго! Я — на шляху, якім прывёў мяне ГОСПАД да дому брата пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","I пабегла дзяўчына, і расказала дома маці сваёй пра тое, што здарылася. ");
INSERT INTO beln_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","А ў Рэбэкі быў брат, імя ягонае — Ляван. I пабег Ляван вонкі да таго чалавека да крыніцы. ");
INSERT INTO beln_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","I сталася, калі ўбачыў ён колца і бранзалеты на руках у сястры сваёй і пачуў словы Рэбэкі, сястры сваёй, якая сказала: “Гэтак гаварыў са мною чалавек той”, дык прыйшоў да чалавека таго, і вось, ён стаіць пры вярблюдах каля крыніцы. ");
INSERT INTO beln_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I сказаў Ляван: “Увайдзі, дабраслаўлёны ГОСПАДАМ. Чаму ты стаіш на двары? Я падрыхтаваў дом і месца для вярблюдаў”. ");
INSERT INTO beln_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","I ўвайшоў чалавек той у дом. I Ляван расьсядлаў вярблюдаў, і даў саломы і корму для вярблюдаў, і вады, каб памыць ногі ягоныя і ногі людзей, якія з ім. ");
INSERT INTO beln_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","I паставілі перад ім есьці; а ён сказаў: “Ня буду есьці, пакуль не скажу словы свае”. I сказаў Ляван: “Кажы!” ");
INSERT INTO beln_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","І ён сказаў: “Я — слуга Абрагама. ");
INSERT INTO beln_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","I ГОСПАД дабраславіў пана майго вельмі, і ён стаў вялікі. І Ён даў яму авечак і валоў, і срэбра, і золата, і слугаў, і нявольніцаў, і вярблюдаў, і аслоў. ");
INSERT INTO beln_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","I нарадзіла Сара, жонка пана майго, сына пану майму пасьля, у старасьці сваёй, і ён аддаў яму ўсё, што ў яго. ");
INSERT INTO beln_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","I ўзяў з мяне прысягу пан мой, кажучы: “Не бяры жонкі сыну майму з дачок Хананейскіх, сярод якіх я жыву, у зямлі іхняй, ");
INSERT INTO beln_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","але пойдзеш у дом бацькі майго і да сям’і маёй, і возьмеш жонку сыну майму”. ");
INSERT INTO beln_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I сказаў я пану майму: “Можа, ня пойдзе жанчына тая са мною”. ");
INSERT INTO beln_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","I сказаў ён мне: “ГОСПАД, перад абліччам Якога я хадзіў, пашле анёла Свайго з табою і дасьць посьпех на шляху тваім, і ты возьмеш жонку сыну майму з сям’і маёй і з дому бацькі майго. ");
INSERT INTO beln_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Тады будзеш ты вызвалены ад прысягі маёй, калі прыйдзеш да сям’і маёй, і калі яны не дадуць табе, ты будзеш вызвалены ад прысягі!” ");
INSERT INTO beln_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","І прыйшоў я сёньня да крыніцы, і сказаў: “ГОСПАДЗЕ, Божа пана майго Абрагама! Калі ёсьць воля Твая, дай посьпех на шляху маім, па якім іду. ");
INSERT INTO beln_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Вось, я стаю каля крыніцы вады, і няхай будзе, што тая дзяўчына, якая выйдзе чэрпаць, і я скажу ёй: “Дай мне напіцца крыху вады са збана твайго”, ");
INSERT INTO beln_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","а яна скажа мне: “Таксама ты пі, і я таксама для вярблюдаў начэрпаю”, яна будзе тою жанчынаю, якую прызначыў ГОСПАД сыну пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Перш чым скончыў я гаварыць у сэрцы сваім, вось, Рэбэка выйшла, і збан ейны на плячы ў яе. І зыйшла яна да крыніцы, і начэрпала; і я сказаў ёй: “Дай мне напіцца!” ");
INSERT INTO beln_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","І яна пасьпяшалася, і спусьціла збан з сябе, і сказала: “Пі, і таксама вярблюдаў тваіх я напаю”. I я піў, і вярблюдаў яна напаіла. ");
INSERT INTO beln_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","І я запытаўся ў яе і сказаў: “Чыя ты дачка?” Яна сказала: “Дачка Бэтуэля, сына Нахора, якога нарадзіла яму Мілька”. I надзеў я колца ў нос ейны, і бранзалеты на рукі ейныя. ");
INSERT INTO beln_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","I я схіліўся, і пакланіўся ГОСПАДУ, і дабраславіў ГОСПАДА, Бога пана майго Абрагама, Які прывёў мяне шляхам праўды, каб узяў я дачку брата пана майго для сына ягонага. ");
INSERT INTO beln_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","I калі вы жадаеце ўчыніць міласэрнасьць і вернасьць пану майму, скажыце мне, а калі не, скажыце мне, і я павярну направа альбо налева”. ");
INSERT INTO beln_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","I адказалі Ляван і Бэтуэль, і сказалі: “Ад ГОСПАДА выйшла слова гэтае, мы ня можам казаць табе ані ліхога, ані добрага. ");
INSERT INTO beln_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Вось, Рэбэка перад абліччам тваім, вазьмі і пайдзі, і няхай будзе яна жонкаю сыну пана твайго, як казаў ГОСПАД”. ");
INSERT INTO beln_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","I сталася, калі пачуў слуга Абрагама словы іхныя, пакланіўся да зямлі ГОСПАДУ. ");
INSERT INTO beln_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","I выняў слуга рэчы срэбныя, і рэчы залатыя, і шаты, і даў Рэбэцы; і каштоўныя рэчы даў брату ейнаму і маці ейнай. ");
INSERT INTO beln_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","I елі, і пілі ён і людзі, якія з ім, і пераначавалі. I ўсталі раніцаю, і ён сказау: “Адпусьціце мяне да пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","I сказаў брат ейны і маці ейная: “Няхай застанецца з намі дзяўчына на дзён дзесяць, потым пойдзе”. ");
INSERT INTO beln_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","І ён сказаў ім: “Не затрымлівайце мяне. ГОСПАД даў посьпех на шляху маім, адпусьціце мяне, і я пайду да пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","I яны сказалі: “Паклічам дзяўчыну і спытаемся ў яе”. ");
INSERT INTO beln_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","I паклікалі Рэбэку, і сказалі ёй: “Ці пойдзеш з гэтым чалавекам?” Яна сказала: “Пайду!” ");
INSERT INTO beln_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I адпусьцілі Рэбэку, сястру сваю, і няньку ейную, і слугу Абрагама, і людзей ягоных. ");
INSERT INTO beln_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I дабраславілі Рэбэку, і сказалі ёй: “Сястра наша, ты станься тысячай тысячаў, і няхай насеньне тваё успадкаеміць брамы ворагаў сваіх!” ");
INSERT INTO beln_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","I ўстала Рэбэка і служкі ейныя, і селі на вярблюдаў, і пайшлі за тым чалавекам. I ўзяў слуга Рэбэку, і пайшоу. ");
INSERT INTO beln_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","І прыйшоў Ісаак з дарогі ад Бээр-Ляхай-Рой, а ён жыў у зямлі Нэгеў. ");
INSERT INTO beln_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","I выйшаў Ісаак падумаць у поле пад вечар, і ўзьняў вочы свае, і ўбачыў, і вось, вярблюды прыходзяць. ");
INSERT INTO beln_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","I ўзьняла Рэбэка вочы свае, і ўбачыла Ісаака, і сьсела з вярблюда. ");
INSERT INTO beln_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","I сказала слузе: “Хто гэты чалавек, які ідзе па полі насустрач нам?” I сказаў слуга: “Гэта пан мой”. I яна ўзяла вэлюм, і засланілася. ");
INSERT INTO beln_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","I распавёў слуга Ісааку ўсе справы, якія ён зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I ўвёў яе Ісаак у намёт Сары, маці сваёй, і ўзяў Рэбэку, і яна стала яму жонкаю, і ён кахаў яе. І суцешыўся Ісаак па маці сваёй. ");
INSERT INTO beln_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","I зноў узяў Абрагам жонку, а імя ейнае — Кетура. ");
INSERT INTO beln_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","I нарадзіла яна яму Зімрана, і Ёкшана, і Мэдана, і Мадыяна, і Ішбака, і Шуаха. ");
INSERT INTO beln_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","А Ёкшан нарадзіў Шэву і Дэдана. Сынамі Дэдана былі Ашурым, і Летушым, і Леўмім. ");
INSERT INTO beln_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","А сынамі Мадыяна — Эфа, і Эфэр, і Ханох, і Авіда, і Эльдаа. Усі яны — сыны Кетуры. ");
INSERT INTO beln_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","I аддаў Абрагам усё, што было ў яго, Ісааку. ");
INSERT INTO beln_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","А сынам наложніцаў, якія былі ў Абрагама, даў Абрагам дары, і адаслаў іх ад Ісаака, сына свайго, яшчэ за жыцьця свайго, на ўсход, у зямлю ўсходнюю. ");
INSERT INTO beln_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","I вось дні гадоў жыцьця Абрагама, якія ён пражыў — сто семдзесят пяць гадоў. ");
INSERT INTO beln_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","I супачыў, і памёр Абрагам у старасьці добрай, стары і насычаны жыцьцём, і быў далучаны да народу свайго. ");
INSERT INTO beln_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","I пахавалі яго Ісаак і Ізмаэль, сыны ягоныя, у пячоры Махпеля на полі Эфрона, сына Цахара, Хета, што насупраць Мамрэ. ");
INSERT INTO beln_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Гэта тое поле, якое купіў Абрагам у сыноў Хета. Там пахаваныя Абрагам і Сара, жонка ягоная. ");
INSERT INTO beln_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","I сталася пасьля сьмерці Абрагама, дабраславіў Бог Ісаака, сына ягонага, і жыў Ісаак каля Бэер-Ляхай-Рой. ");
INSERT INTO beln_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Вось радавод Ізмаэля, сына Абрагама, якога нарадзіла Абрагаму Агар Эгіпцянка, нявольніца Сары. ");
INSERT INTO beln_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","I вось імёны сыноў Ізмаэля, паводле імёнаў іхных, паводле родаў іхніх: першародны Ізмаэля Наваёт, Кедар, Адбээль, Міўсам, ");
INSERT INTO beln_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мішма, Дума, Маса, ");
INSERT INTO beln_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Тэма, Етур, Нафіш і Кедма. ");
INSERT INTO beln_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Гэта сыны Ізмаэля, і гэта імёны іхнія ў паселішчах іхніх і ў табарах іхніх, дванаццаць князёў плямёнаў сваіх. ");
INSERT INTO beln_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","А гадоў жыцьця Ізмаэля — сто трыццаць сем гадоў. І ён супачыў, і памёр, і быў далучаны да народу свайго. ");
INSERT INTO beln_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","І жылі яны ад Хавілі да Шура, які насупраць Эгіпту, калі ідзеш у Асірыю. Перад абліччам усіх братоў сваіх пасяліўся ён. ");
INSERT INTO beln_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","А гэта радавод Ісаака, сына Абрагама: Абрагам нарадзіў Ісаака. ");
INSERT INTO beln_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","I было Ісааку сорак гадоў, калі ён узяў Рэбэку, дачку Бэтуэля Арамейца з Падан-Араму, сястру Лявана Арамейца, сабе за жонку. ");
INSERT INTO beln_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I прасіў Ісаак ГОСПАДА пра жонку сваю, бо яна была бясплодная; і ГОСПАД быў упрошаны ім, і зачала Рэбэка, жонка ягоная. ");
INSERT INTO beln_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","I штурхаліся сыны ў нутры ейным, і яна сказала: “Калі так, дык чаму ў мяне?” I пайшла спытацца ў ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I сказаў ГОСПАД ёй: “Два народы ў жываце тваім, і два народы з нутра твайго вылучацца; і адзін народ будзе мацнейшым за другі, і старэйшы будзе служыць малодшаму”. ");
INSERT INTO beln_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","I споўніліся дні ейныя, каб нарадзіць, і вось, двайняты ў жываце ейным. ");
INSERT INTO beln_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I выйшаў першы, чырвоны, увесь, як кажух, касматы; і назвалі імя ягонае Эзаў. ");
INSERT INTO beln_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Потым выйшаў брат ягоны, і рука ягоная трымала пяту Эзава, і назвалі імя ягонае Якуб. А Ісааку было шэсьцьдзесят гадоў, калі яны нарадзіліся. ");
INSERT INTO beln_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","I вырасьлі хлопчыкі, і быў Эзаў спрытным паляўнічым, чалавекам поля, а Якуб быў чалавекам рахманым, які жыў у намётах. ");
INSERT INTO beln_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I любіў Ісаак Эзава, бо ўпаляванае ім было ў вуснах ягоных; а Рэбэка любіла Якуба. ");
INSERT INTO beln_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","I варыў Якуб страву, і Эзаў прыйшоў з поля, і быў ён стомлены. ");
INSERT INTO beln_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","I сказаў Эзаў Якубу: “Дай мне крыху чырвонай, гэтай чырвонай стравы, бо я стомлены”. Дзеля гэтага названае імя ягонае Эдом. ");
INSERT INTO beln_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","I сказаў Якуб: “Прадай мне сёньня першародзтва тваё”. ");
INSERT INTO beln_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","I сказаў Эзаў: “Вось, я ледзь не паміраю, і на што гэта мне першародзтва?” ");
INSERT INTO beln_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","I сказаў Якуб: “Прысягні мне сёньня”. І той прысягнуў яму, і прадаў першародзтва сваё Якубу. ");
INSERT INTO beln_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","I Якуб даў Эзаву хлеб і страву з сачэвіцы, і ён еў, і піў, і ўстаў, і пайшоў; і пагрэбаваў Эзаў першародзтвам. ");
INSERT INTO beln_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","I была голад у зямлі той, апрача першага голаду, які быў за дзён Абрагама. І пайшоў Ісаак да Абімэлеха, валадара Філістынскага, у Герар. ");
INSERT INTO beln_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","I зьявіўся яму ГОСПАД, і сказаў: “Не зыходзь у Эгіпет; жыві ў зямлі, пра якую скажу табе. ");
INSERT INTO beln_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Жыві ў зямлі гэтай; і Я буду з табою, і дабраслаўлю цябе; бо табе і насеньню твайму Я дам усе краіны гэтыя, і споўню прысягу, якой Я прысягаў Абрагаму, бацьку твайму. ");
INSERT INTO beln_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I памножу насеньне тваё, як зоркі ў небе, і дам насеньню твайму ўсе краіны гэтыя; і дабраславяцца ў насеньні тваім усе народы зямлі, ");
INSERT INTO beln_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","таму што Абрагам паслухаў голасу Майго і захоўваў загады Мае, прыказаньні Мае, пастановы Мае і законы Мае”. ");
INSERT INTO beln_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","I пасяліўся Ісаак у Герары. ");
INSERT INTO beln_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","I пыталіся людзі месца таго пра жонку ягоную, і ён сказаў: “Яна — сястра мая”, бо баяўся сказаць: “жонка мая”, каб не забілі яго людзі месца таго за Рэбэку, бо яна была прыгожая з выгляду. ");
INSERT INTO beln_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I сталася, калі доўгія былі там дні ягоныя, глянуў Абімэлех, валадар Філістынскі, праз вакно, і ўбачыў, а вось, Ісаак гуляе з Рэбэкаю, жонкаю сваёю. ");
INSERT INTO beln_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","I паклікаў Абімэлех Ісаака, і сказаў: “Дык яна — жонка твая! А чаму ж ты казаў: “Яна — сястра мая”?” I сказаў яму Ісаак: “Бо я сказаў: “Каб я не памёр праз яе””. ");
INSERT INTO beln_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","I сказаў Абімэлех: “Што гэта ты нарабіў нам? Яшчэ б трохі, і мог бы легчы нехта з народу з жонкаю тваёю, і ты прывёў бы на нас віну”. ");
INSERT INTO beln_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","I загадаў Абімэлех усяму народу, кажучы: “Хто дакранецца да гэтага чалавека і да жонкі ягонае, той сьмерцю памрэ”. ");
INSERT INTO beln_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","I сеяў Ісак у зямлі той, і знайшоў у той год стакротны ўраджай, і дабраславіў яго ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I ставаўся вялікім муж гэты, і ішоў ўгору, і павялічыўся так, што стаў вельмі вялікі. ");
INSERT INTO beln_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","I былі ў яго статкі авечак, і статкі валоў, і мноства слугаў, і зайздросьцілі яму Філістынцы. ");
INSERT INTO beln_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","I ўсе студні, якія выкапалі слугі бацькі ягонага за дзён Абрагама, бацькі ягонага, засыпалі Філістынцы і запоўнілі пяском. ");
INSERT INTO beln_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","I сказаў Абімэлех Ісааку: “Адыйдзі ад нас, бо ты стаўся шмат дужэйшы за нас”. ");
INSERT INTO beln_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","I адыйшоў адтуль Ісаак, і паставіў намёты каля ручая Герарскага, і жыў там. ");
INSERT INTO beln_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","I вярнуўся Ісаак, і адкапаў студні вады, якія былі выкапаныя за дзён Абрагама, бацькі ягонага, і якія засыпалі Філістынцы пасьля сьмерці Абрагама, і назваў іх тымі самымі назвамі, якімі назваў іх бацька ягоны. ");
INSERT INTO beln_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","I капалі слугі Ісаака каля ручая, і знайшлі там студню вады жывой. ");
INSERT INTO beln_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","I спрачаліся пастухі герарскія з пастухамі Ісаака, кажучы: “Гэта наша вада”, і ён назваў імя студні Эсэк, бо вадзіліся з ім. ");
INSERT INTO beln_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","I выкапалі другую студню; і спрачаліся таксама за яе; і ён назваў яе імя Сітна. ");
INSERT INTO beln_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I выбраўся адтуль, і выкапаў іншую студню, і не спрачаліся за яе; і назваў яе імя Рэхабот, і сказаў: “Бо цяпер пашырыў нас ГОСПАД, і мы будзем памнажацца ў гэтай зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Адтуль узыйшоў ён у Бээр-Шэву. ");
INSERT INTO beln_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","I зьявіўся яму ГОСПАД у тую ноч, і сказаў: “Я — Бог Абрагама, бацькі твайго. Ня бойся, бо Я з табою; і дабраслаўлю цябе, і памножу насеньне тваё дзеля Абрагама, слугі Майго”. ");
INSERT INTO beln_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I ён збудаваў там ахвярнік, і клікаў імя ГОСПАДА. I паставіў там намёт свой, і выкапалі там слугі Ісаака студню. ");
INSERT INTO beln_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","I Абімэлех прыйшоў да яго з Герару, і Ахузат, сябра ягоны, і Піколь, гетман ягоны. ");
INSERT INTO beln_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I сказаў ім Ісаак: “Чаму вы прыйшлі да мяне, вы ж зьненавідзелі мяне і выслалі мяне ад сябе?” ");
INSERT INTO beln_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","I яны сказалі: “Мы, гледзячы, ўбачылі, што ГОСПАД з табою, і сказалі мы: “Няхай будзе прысяга паміж намі, паміж намі і табою, і мы заключым запавет з табою, ");
INSERT INTO beln_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","і ты ня будзеш рабіць нам ліха, як і мы не дакрануліся цябе, і як мы рабілі табе адно дабро і адпусьцілі цябе ў супакоі, і ты цяпер дабраслаўлёны ГОСПАДАМ”. ");
INSERT INTO beln_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","І ён зрабіў для іх гасьціну, і яны елі і пілі. ");
INSERT INTO beln_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","I ўсталі нараніцы, і прысягнулі адзін аднаму; і адпусьціў іх Ісаак, і яны пайшлі ад яго ў супакоі. ");
INSERT INTO beln_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","I сталася ў той дзень, прыйшлі слугі Ісаака, і паведамілі яму пра студню, якую яны выкапалі, і сказалі яму: “Мы знайшлі ваду!” ");
INSERT INTO beln_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I ён назваў яе Шыва. Дзеля гэтага імя гораду таго Бээр-Шэва аж да сёньняшняга дня. ");
INSERT INTO beln_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","I сталася, што меў Эзаў сорак гадоў, і ўзяў сабе за жонку Юдыту, дачку Бээры Хета, і Басэмат, дачку Элёна Хета, ");
INSERT INTO beln_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","і былі яны горыччу для духа Ісаака і Рэбэкі. ");
INSERT INTO beln_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","I сталася, што Ісаак састарэў, і зацемрыліся вочы ягоныя, так што ня мог бачыць, і паклікаў ён Эзава, сына свайго старэйшага, і сказаў яму: “Сыне мой”. І той сказаў яму: “Вось я”. ");
INSERT INTO beln_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I ён сказаў: “Вось, я састарэў, ня ведаю дня сьмерці маёй. ");
INSERT INTO beln_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","I цяпер вазьмі прылады твае, сагайдак твой і лук твой, і пайдзі ў поле, і ўпалюй мне дзічыны, ");
INSERT INTO beln_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","і зрабі мне прысмакі, якія я люблю, і прынясі мне, і я паем, каб дабраславіла цябе душа мая раней, чым я памру”. ");
INSERT INTO beln_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","А Рэбэка чула, як Ісаак казаў Эзаву, сыну свайму. I пайшоў Эзаў у поле, каб упаляваць дзічыны і прынесьці яе. ");
INSERT INTO beln_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","І сказала Рэбэка Якубу, сыну свайму, кажучы: “Вось, я чула бацьку твайго, як ён казаў брату твайму Эзаву, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Прынясі мне дзічыны і зрабі мне прысмакі, і я буду есьці, і дабраслаўлю цябе перад абліччам ГОСПАДА, перад сьмерцю сваёй”. ");
INSERT INTO beln_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","I цяпер, сыне мой, паслухай голасу майго ў тым, што я загадваю табе. ");
INSERT INTO beln_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Пайдзі да авечак і вазьмі мне адтуль двух казьлянят добрых; і я прыгатую з іх прысмакі для бацькі твайго, якія ён любіць. ");
INSERT INTO beln_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","I ты прынясеш іх бацьку твайму, і ён зьесьць, каб ён дабраславіў цябе перад сьмерцю сваёю”. ");
INSERT INTO beln_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","I сказаў Якуб Рэбэцы, маці сваёй: “Вось жа Эзаў, брат мой, чалавек касматы, а я — чалавек гладкі. ");
INSERT INTO beln_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Можа, памацае мяне бацька мой, і я буду ў вачах ягоных як той, які ашуквае яго, і навяду на сябе праклён, а не дабраславеньне”. ");
INSERT INTO beln_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","I сказала яму маці ягоная: “На мне будзе праклён твой, сыне мой, толькі паслухай голасу майго і ідзі, і вазьмі мне”. ");
INSERT INTO beln_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","І ён пайшоў, і ўзяў, і прынёс маці сваёй, і зрабіла маці ягоная прысмакі, якія любіў бацька ягоны. ");
INSERT INTO beln_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","I ўзяла Рэбэка адзежу Эзава, сына свайго старэйшага, найкаштоўнейшую, што была ў яе дома, і апранула Якуба, сына свайго малодшага, ");
INSERT INTO beln_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","і скуркамі казьлянят абкруціла рукі ягоныя і гладкую шыю ягоную, ");
INSERT INTO beln_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","і дала прысмакі і хлеб, які яна зрабіла, у рукі Якуба, сына свайго. ");
INSERT INTO beln_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","I ўвайшоў ён да бацькі свайго, і сказаў: “Ойча мой!” I сказаў ён: “Вось я. Хто ты, сыне мой?” ");
INSERT INTO beln_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","I сказаў Якуб бацьку свайму: “Я — Эзаў, першародны твой. Я зрабіў, як ты сказаў мне, Устань, сядзь і еш дзічыну маю, каб дабраславіла мяне душа твая”. ");
INSERT INTO beln_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","I сказаў Ісаак сыну свайму: “Як гэта так хутка ты знайшоў яе, сыне мой”. А той сказаў: “Бо справіў гэта ГОСПАД, Бог твой, перад абліччам маім”. ");
INSERT INTO beln_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","I сказаў Ісаак Якубу: “Наблізься, я памацаю цябе, сыне мой, ці ты сын мой Эзаў, ці не”. ");
INSERT INTO beln_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","I наблізіўся Якуб да Ісаака, бацькі свайго, і ён памацаў яго, і сказаў: “Голас — голас Якуба, але рукі — рукі Эзава”. ");
INSERT INTO beln_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","І не пазнаў яго, бо рукі ягоныя былі як рукі брата ягонага, касматыя, і дабраславіў яго. ");
INSERT INTO beln_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","I сказаў: “Ці ты — сын мой Эзаў?” І ён сказаў: “Я”. ");
INSERT INTO beln_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I сказаў: “Дай мне, і я буду есьці дзічыну, сыне мой, каб дабраславіла цябе душа мая”. I ён даў яму, і ён еў; і прынёс яму віна, і ён піў. ");
INSERT INTO beln_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","I сказаў яму Ісаак, бацька ягоны: “Наблізься і пацалуй мяне, сыне мой”. ");
INSERT INTO beln_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","I ён наблізіўся, і пацалаваў яго. I адчуў ён пах адзежы ягонае, і дабраславіў яго, і сказаў: “Вось, пах сына майго, як пах поля, якое дабраславіў ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","I няхай дасьць табе Бог расу з неба і тлустасьць з зямлі, і мноства збожжа і віна. ");
INSERT INTO beln_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Няхай служаць табе народы, і няхай кланяюцца табе плямёны. Будзь гаспадаром над братамі тваім, і няхай кланяюцца табе сыны маці тваёй. Хто праклінае цябе, будзе пракляты, а хто дабраслаўляе цябе, будзе дабраславёны”. ");
INSERT INTO beln_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","I сталася, калі скончыў Ісаак дабраслаўляць Якуба, і вось, адыходзячы, адыйшоў Якуб ад аблічча Ісаака, бацькі свайго, Эзаў, брат ягоны, прыйшоў з паляваньня свайго. ");
INSERT INTO beln_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","I зрабіў ён таксама прысмакі, і прынёс бацьку свайму, і сказаў бацьку свайму: “Устань, ойча мой, і зьеш дзічыну сына свайго, каб дабраславіла мяне душа твая”. ");
INSERT INTO beln_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","I сказаў яму Ісаак, бацька ягоны: “Хто ты?” І ён сказаў: “Я — сын твой першародны Эзаў”. ");
INSERT INTO beln_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","I задрыжэў Ісаак дрыжэньнем вельмі вялікім, і сказаў: “Хто ж быў той, які ўпаляваў дзічыну і прынёс мне, і я еў усё перш, чым ты прыйшоў, і я дабраславіў яго? Ён будзе дабраслаўлёны”. ");
INSERT INTO beln_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Калі пачуў Эзаў словы бацькі свайго, закрычаў крыкам вялікім і надта горкім, і сказаў бацьку свайму: “Дабраславі мяне, таксама і мяне, ойча мой!” ");
INSERT INTO beln_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","I сказаў той: “Брат твой прыйшоў падступна і ўзяў дабраславеньне тваё”. ");
INSERT INTO beln_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","I сказаў ён: “Ці не таму названае імя ягонае Якуб, і вось, ашукаў мяне ўжо двойчы! Ён забраў першародзтва маё, і вось цяпер забраў дабраславеньне маё”. I сказаў: “Няўжо ты не захаваў для мяне дабраславеньня?” ");
INSERT INTO beln_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","I адказаў Ісаак, і сказаў Эзаву: “Вось, я паставіў яго гаспадаром над табою, і ўсіх братоў ягоных аддаў яму за слугаў, і збожжам і віном абдарыў яго. А табе што я зраблю, сыне мой?” ");
INSERT INTO beln_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I сказаў Эзаў бацьку свайму: “Ці толькі адно дабраславеньне ў цябе, ойча мой? Дабраславі мяне, таксама мяне, ойча мой!” I узвысіў Эзаў голас свой, і заплакаў. ");
INSERT INTO beln_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","I адказаў Ісаак, бацька ягоны, і сказаў яму: “Вось, далёка ад тлустасьці зямлі будзе месца жыцьця твайго і далёка ад расы з неба з гары, ");
INSERT INTO beln_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","і з мяча свайго будзеш жыць, і брату свайму будзеш служыць. І станецца, што ты запануеш, і скінеш ярмо ягонае з шыі сваёй”. ");
INSERT INTO beln_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","I зьненавідзеў Эзаў Якуба дзеля дабраславеньня, якім дабраславіў яго бацька ягоны, і сказаў Эзаў у сэрцы сваім: “Набліжаюцца дні жалобы па бацьку маім, і я заб’ю Якуба, брата майго”. ");
INSERT INTO beln_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I распавялі Рэбэцы словы Эзава, сына ейнага старэйшага, і яна паслала, і паклікала Якуба, сына свайго малодшага, і сказала яму: “Вось, Эзаў, брат твой, суцяшае сябе адносна цябе, што заб’е цябе. ");
INSERT INTO beln_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","I цяпер, сыне мой, паслухай голасу майго, і ўстань, уцякай да Лявана, брата майго, ў Харан, ");
INSERT INTO beln_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","і пажыві з ім нейкі час, пакуль адыйдзе гнеў ад брата твайго. ");
INSERT INTO beln_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Калі адыйдзе гнеў на цябе ад брата твайго, і ён забудзецца, што ты ўчыніў яму, я пашлю і вазьму цябе адтуль. Дзеля чаго маю страціць абодвух у адзін дзень?” ");
INSERT INTO beln_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","I сказала Рэбэка Ісааку: “Абрыдла мне жыцьцё маё з прычыны дачок Хета. Калі возьме Якуб жонку з дачок Хета, якія з дачок гэтае зямлі, дык навошта мне жыцьцё?” ");
INSERT INTO beln_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","I паклікаў Ісаак Якуба, і дабраславіў яго, і загадаў яму, і сказаў яму: “Не бяры сабе жонкі з дачок Ханаану. ");
INSERT INTO beln_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Устань, ідзі ў Падан-Арам, у дом Бэтуэля, бацькі маці тваёй, і вазьмі сабе адтуль жонку з дачок Лявана, брата маці тваёй. ");
INSERT INTO beln_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","І Бог Усемагутны дабраславіць цябе, і зробіць цябе плодным, і памножыць цябе, і ты станешся грамадою народаў, ");
INSERT INTO beln_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","і Ён дасьць табе дабраславеньне Абрагама, табе і насеньню твайму з табою, каб ты ўзяў у спадчыну зямлю вандраваньня твайго, якую Бог даў Абрагаму”. ");
INSERT INTO beln_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I паслаў Ісаак Якуба, і ён пайшоў у Падан-Арам да Лявана, сына Бэтуэля Арамейца, брата Рэбэкі, маці Якуба і Эзава. ");
INSERT INTO beln_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","I бачыў Эзаў, што дабраславіў Ісаак Якуба, і, дабраслаўляючы яго, паслаў яго ў Падан-Арам узяць сабе адтуль жонку, і загадаў яму, кажучы: “Не бяры жонкі з дачок Ханаану”; ");
INSERT INTO beln_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","і што паслухаў Якуб бацьку свайго і маці сваю, і пайшоў у Падан-Арам. ");
INSERT INTO beln_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","I бачыў Эзаў, што ліхія дочкі Ханаану ў вачах Ісаака, бацькі ягонага. ");
INSERT INTO beln_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","I пайшоў Эзаў да Ізмаэля, і ўзяў за жонку сабе Махалят, дачку Ізмаэля, сына Абрагама, сястру Наваёта, акрамя тых жонак, якія меў. ");
INSERT INTO beln_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","I выйшаў Якуб з Бээр-Шэвы, і пайшоў у Харан. ");
INSERT INTO beln_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I трапіў ён на адно месца, і заначаваў там, бо зайшло сонца. I ўзяў камяні з таго месца, і палажыў пад галаву сваю, і лёг спаць на тым месцы. ");
INSERT INTO beln_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I сьніў ён, і вось, лесьвіца стаіць на зямлі, а верх яе дакранаецца да неба; і вось, анёлы Божыя ўзыходзяць і зыходзяць па ёй. ");
INSERT INTO beln_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","I вось, ГОСПАД стаў над ім і сказаў: “Я — ГОСПАД, Бог Абрагама, бацькі твайго, і Бог Ісаака. Зямлю, на якой ты ляжыш, Я дам табе і насеньню твайму. ");
INSERT INTO beln_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I станецца насеньне тваё, як пясок зямлі; і ты распаўсюдзішся на захад, і на ўсход, і на поўнач, і на поўдзень, і будуць дабраслаўлёныя ў табе і ў насеньні тваім усе плямёны зямлі. ");
INSERT INTO beln_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I вось, Я з табою, і буду захоўваць цябе ўсюды, куды ты пойдзеш, і вярну цябе ў гэтую зямлю, бо Я не пакіну цябе, пакуль не зраблю таго, што Я сказаў табе”. ");
INSERT INTO beln_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","I прачнуўся Якуб зо-сну свайго, і сказаў: “Сапраўды ГОСПАД ёсьць на месцы гэтым, а я ня ведаў!” ");
INSERT INTO beln_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I спалохаўся, і сказаў: “Якое страшнае месца гэтае! Гэта нішто іншае, як дом Божы, і гэта брама неба”. ");
INSERT INTO beln_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","I ўстаў Якуб рана раніцай, і ўзяў камень, які ён палажыў пад галаву сваю, і паставіў яго як слуп, і наліў алей на верх ягоны. ");
INSERT INTO beln_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","I назваў імя месца таго Бэтэль; а раней імя гораду таго было Люз. ");
INSERT INTO beln_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","I абяцаў Якуб абяцаньне, кажучы: “Калі Бог будзе са мною, і будзе захоўваць мяне на гэтым шляху, якім я іду, і дасьць мне хлеб есьці і адзежу адзецца, ");
INSERT INTO beln_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","і я вярнуся ў супакоі ў дом бацькі майго, і будзе ГОСПАД мне Богам, ");
INSERT INTO beln_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","дык камень гэты, які я паставіў як слуп, будзе домам Божым, і з усяго, што Ты дасі мне, я аддзялю Табе дзесяціну”. ");
INSERT INTO beln_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","I ўстаў Якуб на ногі свае, і пайшоў у зямлю сыноў Усходу. ");
INSERT INTO beln_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I ўбачыў, і вось, студня на полі, і вось, там тры чарады авечак ляжаць каля яе, бо са студні тае паілі чароды, і вялікі камень быў на адтуліне студні. ");
INSERT INTO beln_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","I зьбіраліся туды ўсе чароды, і адкочвалі камень з адтуліны студні, і паілі авечкі, і зноў вярталі камень на сваё месца. ");
INSERT INTO beln_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","I сказаў ім Якуб: “Браты мае, адкуль вы?” I яны сказалі: “Мы з Харану”. ");
INSERT INTO beln_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I ён сказаў ім: “Ці ведаеце вы Лявана, сына Нахора?” І яны сказалі: “Ведаем”. ");
INSERT INTO beln_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","I ён сказаў ім: “Ці добра ён маецца?” І яны сказалі: “Добра. А вось, Рахель, дачка ягоная, прыйшла з авечкамі”. ");
INSERT INTO beln_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I ён сказаў: “Вось, яшчэ вялікі дзень наперадзе; ня час зьбіраць статак; напаіце авечкі, і ідзіце, і пасьвіце”. ");
INSERT INTO beln_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","А яны сказалі: “Ня можам, аж пакуль не зьбяруцца ўсе чароды, і не адкоцяць камень з адтуліны студні, і тады напоім авечкі”. ");
INSERT INTO beln_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Яшчэ ён гаварыў з імі, і вось, Рахель прыйшла з авечкамі бацькі свайго, бо яна пасьвіла іх. ");
INSERT INTO beln_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","I сталася, калі ўбачыў Якуб Рахель, дачку Лявана, брата маці сваёй, і авечкі Лявана, брата маці сваёй, падыйшоў Якуб, і адкаціў камень з адтуліны студні, і напаіў авечкі Лявана, брата маці сваёй. ");
INSERT INTO beln_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","I пацалаваў Якуб Рахель, і ўзвысіў голас свой, і заплакаў. ");
INSERT INTO beln_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I распавёў Якуб Рахелі, што ён брат бацьку ейнаму, і што ён сын Рэбэкі. I яна пабегла, і распавяла бацьку свайму. ");
INSERT INTO beln_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","I сталася, калі пачуў Ляван навіну пра Якуба, сына сястры сваёй, выбег яму насустрач, і абняў яго, і пацалаваў яго, і прывёў яго ў дом свой, і ён распавёў Лявану пра ўсе падзеі. ");
INSERT INTO beln_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","I сказаў яму Ляван: “Вось, ты — костка мая і цела маё”. I жыў у яго цэлы месяц. ");
INSERT INTO beln_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","I сказаў Ляван Якубу: “Хоць ты брат мой, ці ж будзеш служыць мне задарма? Скажы мне, якая плата твая?” ");
INSERT INTO beln_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","А ў Лявана былі дзьве дачкі, імя старэйшае — Лея, а імя малодшае — Рахель. ");
INSERT INTO beln_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Вочы Леі былі кволыя, а Рахель была прыгожая пастацьцю і прыгожая абліччам. ");
INSERT INTO beln_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","I пакахаў Якуб Рахель, і сказаў: “Я буду служыць табе сем гадоў за Рахель, дачку тваю малодшую”. ");
INSERT INTO beln_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","I сказаў Ляван: “Лепш, калі я аддам яе за цябе, чым аддам за іншага чалавека. Жыві са мною”. ");
INSERT INTO beln_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","I служыў Якуб за Рахель сем гадоў, і былі яны ў вачах ягоных як некалькі дзён, бо ён кахаў яе. ");
INSERT INTO beln_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","I сказаў Якуб Лявану: “Дай жонку маю, бо споўніліся дні мае, і я пайду да яе”. ");
INSERT INTO beln_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","I сабраў Ляван усіх людзей таго месца, і справіў гасьціну. ");
INSERT INTO beln_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","I быў вечар, і ўзяў ён Лею, дачку сваю, і ўвёў яе да яго, і той увайшоў да яе. ");
INSERT INTO beln_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","I даў Ляван Зільпу, нявольніцу сваю, Леі, дачцэ сваёй, за нявольніцу. ");
INSERT INTO beln_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","I сталася раніцаю, што вось, гэта Лея. I сказаў Якуб Лявану: “Што ты зрабіў мне? Ці не за Рахель я служыў у цябе? Чаму ж ты ашукаў мяне?” ");
INSERT INTO beln_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","I сказаў Ляван: “Ня робіцца так у нашай мясцовасьці, каб малодшую выдаваць перад старэйшай. ");
INSERT INTO beln_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Споўні тыдзень з гэтай, і дам табе таксама тую, за якую ты будзеш служыць у мяне яшчэ сем іншых гадоў”. ");
INSERT INTO beln_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","I зрабіў Якуб так, і споўніў тыдзень з гэтай. I Ляван даў Рахель, дачку сваю, яму за жонку. ");
INSERT INTO beln_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","I даў Ляван Рахелі, дачцэ сваёй, Більгу, нявольніцу сваю, за нявольніцу для яе. ");
INSERT INTO beln_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","I ўвайшоў Якуб да Рахелі, і кахаў таксама Рахель больш за Лею; і служыў у яго яшчэ сем іншых гадоў. ");
INSERT INTO beln_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","I бачыў ГОСПАД, што зьненавіджана Лея, і адчыніў улоньне ейнае, а Рахель была бясплодная. ");
INSERT INTO beln_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","I зачала Лея, і нарадзіла сына, і назвала імя яго Рубэн, бо сказала: “Бо ўбачыў ГОСПАД гора маё, бо цяпер будзе кахаць мяне муж мой”. ");
INSERT INTO beln_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","I зачала яна ізноў, і нарадзіла сына, і сказала: “Бо пачуў ГОСПАД, што я зьненавіджана, і даў мне гэтага сына”. I назвала імя ягонае Сымон. ");
INSERT INTO beln_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","I зачала яшчэ, і нарадзіла сына, і сказала: “Цяпер, гэтым разам прытуліцца муж мой да мяне, бо я нарадзіла яму трох сыноў”. І таму назвала імя ягонае Левій. ");
INSERT INTO beln_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","I зачала яшчэ, і нарадзіла сына, і сказала: “Гэтым разам я буду славіць ГОСПАДА”. І таму назвала імя ягонае Юда, і перастала нараджаць. ");
INSERT INTO beln_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","I бачыла Рахель, што яна не нараджае Якубу, і зайздросьціла Рахель сястры сваёй, і казала Якубу: “Дай мне сыноў, а калі не, я памру”. ");
INSERT INTO beln_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","I ўзгарэўся гнеў Якуба на Рахель, і ён сказаў: “Ці ж гэта я, а ня Бог затрымаў у цябе плод улоньня?” ");
INSERT INTO beln_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","I яна сказала: “Вось, нявольніца мая Більга. Увайдзі да яе, і яна народзіць на каленях маіх, і я буду збудаваная праз яе”. ");
INSERT INTO beln_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","I яна дала яму Більгу, нявольніцу сваю, за жонку, і ўвайшоў да яе Якуб. ");
INSERT INTO beln_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","I зачала Більга, і нарадзіла Якубу сына. ");
INSERT INTO beln_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","I сказала Рахель: “Рассудзіў мяне Бог, і таксама пачуў голас мой, і даў мне сына”. І таму назвала імя ягонае Дан. ");
INSERT INTO beln_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","I зачала яшчэ, і нарадзіла Більга, нявольніца Рахелі, другога сына Якубу. ");
INSERT INTO beln_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","I сказала Рахель: “Ваяваньнем Божым змагалася я з сястрою сваёй і адолела”. I назвала імя ягонае Нэфталі. ");
INSERT INTO beln_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","I ўбачыла Лея, што перастала нараджаць, і ўзяла Зільпу, нявольніцу сваю, і дала яе Якубу за жонку. ");
INSERT INTO beln_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","I нарадзіла Зільпа, нявольніца Леі, Якубу сына. ");
INSERT INTO beln_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","I сказала Лея: “Прыйшоў посьпех!” I назвала імя ягонае Гад. ");
INSERT INTO beln_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","I нарадзіла Зільпа, нявольніца Леі, другога сына Якубу. ");
INSERT INTO beln_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","I сказала Лея: “На шчасьце маё, бо шчасьлівай будуць называць мяне дочкі”. I назвала імя ягонае Асэр. ");
INSERT INTO beln_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","I выйшаў Рубэн у дні жніва пшаніцы, і знайшоў мандрагоры ў полі, і прынёс іх Леі, маці сваёй. I сказала Рахель Леі: “Дай мне мандрагоры сына твайго”. ");
INSERT INTO beln_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","А тая сказала ёй: “Няўжо мала табе, што ты ўзяла мужа майго, і хочаш узяць мандрагоры сына майго?” I сказала Рахель: “Дык няхай ён ляжа з табою ў гэтую ноч за мандрагоры сына твайго”. ");
INSERT INTO beln_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","I прыйшоў Якуб з поля ўвечары, і выйшла Лея насустрач яму, і сказала: “Да мяне ўвойдзеш, бо наймаючы, наняла цябе за мандрагоры сына майго”. I ён лёг з ёю ў тую ноч. ");
INSERT INTO beln_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","I пачуў Бог Лею, і яна зачала, і нарадзіла Якубу пятага сына. ");
INSERT INTO beln_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I сказала Лея: “Даў Бог плату маю за тое, што я дала нявольніцу маю мужу майму”. I назвала імя ягонае Ісахар. ");
INSERT INTO beln_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","I зачала ізноў Лея, і нарадзіла шостага сына Якубу. ");
INSERT INTO beln_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","I сказала Лея: “Абдараваў мяне Бог добрым дарам. Гэтым разам будзе жыць са мною муж мой, бо я нарадзіла яму шэсьць сыноў”. I назвала імя ягонае Завулён. ");
INSERT INTO beln_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Потым нарадзіла дачку, і назвала імя ейнае Дзіна. ");
INSERT INTO beln_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","I ўзгадаў Бог пра Рахель, і пачуў яе Бог, і адчыніў улоньне ейнае, ");
INSERT INTO beln_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","і яна зачала, і нарадзіла сына, і сказала: “Забраў Бог ганьбу маю”. ");
INSERT INTO beln_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","I назвала імя ягонае Язэп, кажучы: “Няхай дадасьць мне ГОСПАД другога сына”. ");
INSERT INTO beln_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","I сталася, калі нарадзіла Рахель Язэпа, сказаў Якуб Лявану: “Пусьці мяне, і я пайду ў сваю мясцовасьць і ў сваю зямлю. ");
INSERT INTO beln_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дай мне жонак маіх і дзяцей маіх, бо я служыў табе за іх, і я пайду; бо ты ведаеш службу маю, якою я служыў табе”. ");
INSERT INTO beln_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","I сказаў яму Ляван: “О, каб я знайшоў ласку у вачах тваіх! Я пераканаўся, што ГОСПАД дабраславіў мяне дзеля цябе”. ");
INSERT INTO beln_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I сказаў: “Прызнач сабе плату сваю ад мяне, і я дам”. ");
INSERT INTO beln_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","I Якуб сказаў яму: “Ты ведаеш, як я служыў табе, і які стаўся статак твой пры мне; ");
INSERT INTO beln_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","бо мала было ў цябе да мяне, а памножылася ў мноства, і дабраславіў ГОСПАД цябе, як я прыйшоў. А цяпер, калі я буду рабіць для дому майго?” ");
INSERT INTO beln_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","I той сказаў: “Што маю даць табе?” I сказаў Якуб: “Не давай мне нічога, але зрабі для мяне такую рэч, і я вярнуся, і буду пасьвіць і захоўваць авечкі твае. ");
INSERT INTO beln_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Я прайду сёньня між усіх авечак тваіх, і аддзялю з іх кожнае ягня стракатае і пярэстае, і кожную рудую з авечак, і стракатых і пярэстых з козаў; і будзе гэта мая плата. ");
INSERT INTO beln_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","I будзе адказваць за мяне праведнасьць мая на наступны дзень, калі прыйдзеш даведацца пра плату маю перад табою. Усё, што не стракатае і не пярэстае паміж козаў, і не рудое паміж авечак, крадзенае гэта ў мяне”. ");
INSERT INTO beln_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","I сказаў Ляван: “Дык няхай будзе паводле слова твайго”. ");
INSERT INTO beln_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","I адлучыў у той дзень казлоў пасастых і пярэстых, і ўсіх козаў стракатых і пярэстых, усіх, што мелі нешта белае на сабе, і ўсіх рудых паміж авечак, і аддаў у рукі сыноў сваіх. ");
INSERT INTO beln_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","I вызначыў дарогу ў тры дні паміж сабою і Якубам. I Якуб пасьвіў авечкі Лявана, якія засталіся. ");
INSERT INTO beln_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","I ўзяў Якуб зялёных прутоў тапалёвых, і мігдалёвых, і яваровых, і выразаў на іх пасы белыя, зьняўшы кару да бялосьці, якая на прутах, ");
INSERT INTO beln_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","і ўткнуў тыя пруты, якія аблупіў, перад авечкамі пры карытах ля вадапою, куды прыходзілі авечкі піць і спалучаліся, прыходзячы піць. ");
INSERT INTO beln_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","I спалучаліся авечкі перад прутамі, і нараджаліся авечкі пасастыя, стракатыя і пярэстыя. ");
INSERT INTO beln_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","І авечак белых аддзяляў Якуб, і гнаў наперадзе авечак пярэстых і ўсіх рудых як авечкі Лявана, і трымаў свае чароды асобна, і не злучаў іх з авечкамі Лявана. ");
INSERT INTO beln_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","I было, калі спалучаліся мацнейшыя авечкі, Якуб клаў пруты перад вачыма авечак пры карытах, каб яны спалучаліся перад прутамі, ");
INSERT INTO beln_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","а калі авечкі былі слабыя, тады ня клаў. I былі слабейшыя у Лявана, а мацнейшыя — у Якуба. ");
INSERT INTO beln_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","I пашырыўся чалавек гэты вельмі, вельмі, і было ў яго мноства авечак, і нявольніцаў, і слугаў, і вярблюдаў, і аслоў. ");
INSERT INTO beln_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","I пачуў Якуб словы сыноў Лявана, якія казалі: “Забраў Якуб усё, што было ў бацькі нашага, і з таго, што было ў бацькі нашага, учыніў сабе ўсю гэтую славу”. ");
INSERT INTO beln_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","I бачыў Якуб аблічча Лявана, і вось, ён ня быў з ім такі, як учора і пазаўчора. ");
INSERT INTO beln_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","I сказаў ГОСПАД Якубу: “Вярніся ў зямлю бацькоў тваіх і нараджэньня твайго, і Я буду з табою”. ");
INSERT INTO beln_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","I паслаў Якуб, і паклікаў Рахель і Лею ў поле да авечак сваіх, ");
INSERT INTO beln_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","і сказаў ім: «Я бачу аблічча бацькі вашага, што ён не такі да мяне, як учора ці пазаўчора. I Бог бацькі майго быў са мною. ");
INSERT INTO beln_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","I вы ведаеце, што я ўсімі сіламі служыў бацьку вашаму, ");
INSERT INTO beln_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","і бацька ваш ашукваў мяне, і змяняў плату маю дзесяць разоў, але ня даў яму Бог зрабіць крыўду мне. ");
INSERT INTO beln_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Калі сказаў ён: “Стракатыя будуць платай тваёй”, нараджаліся ўсе авечкі стракатыя. А калі сказаў ён: “Пасастыя будуць платай тваёй”, нараджаліся ўсе авечкі пасастыя. ");
INSERT INTO beln_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","I забраў Бог статак у бацькі вашага, і даў яго мне. ");
INSERT INTO beln_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","I было ў часе параваньня авечак, і ўзьняў я вочы мае, і бачыў у сьне, і вось, бараны, якія ўскочылі на авечак, былі пасастыя, стракатыя і пярэстыя. ");
INSERT INTO beln_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","I сказаў мне анёл Божы ў сьне: “Якубе!” І я сказаў: “Вось я!” ");
INSERT INTO beln_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","I Ён сказаў: “Узьнімі вочы твае і паглядзі: усе бараны, якія ўскочылі на авечак, пасастыя, стракатыя і пярэстыя, бо Я бачыў усё, што Ляван робіць табе. ");
INSERT INTO beln_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Я — Бог з Бэтэлю, дзе ты памазаў слуп і дзе абяцаў Мне абяцаньне. Цяпер устань, выйдзі з зямлі гэтае, і вярніся ў зямлю нараджэньня твайго”». ");
INSERT INTO beln_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","I адказалі Рахель і Лея, і сказалі яму: “Ці ёсьць яшчэ ў нас частка і спадчына у доме бацькі нашага? ");
INSERT INTO beln_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ці не за чужых ён нас мае? Бо ён прадаў нас, і еў, зьядаючы срэбра нашае. ");
INSERT INTO beln_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Таму ўсё багацьце, якое забраў Бог у бацькі нашага, нашае яно і дзяцей нашых. I цяпер усё, што сказаў Бог табе, рабі”. ");
INSERT INTO beln_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","I ўстаў Якуб, і пасадзіў дзяцей сваіх і жонак сваіх на вярблюдаў. ");
INSERT INTO beln_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","I павёў усе статкі свае і ўсю маёмасьць сваю, якую прыдбаў, статкі ўласнасьці сваёй, якую ён прыдбаў у Падан-Араме, каб ісьці да Ісаака, бацькі свайго, у зямлю Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","А Ляван пайшоў стрыгчы авечкі свае. I ўкрала Рахель балваноў, якія былі ў бацькі ейнага. ");
INSERT INTO beln_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","I ашукаў Якуб сэрца Лявана Арамейца, бо не сказаў яму, што ўцякае. ");
INSERT INTO beln_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I ўцёк ён з ўсім, што ў яго; і устаў, і перайшоў праз раку, і скіраваў аблічча сваё да гары Гілеад. ");
INSERT INTO beln_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","I паведамілі Лявану на трэйці дзень, што ўцёк Якуб. ");
INSERT INTO beln_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","I ўзяў ён з сабою братоў сваіх, і гнаўся за ім дарогаю сем дзён, і дагнаў яго на гары Гілеад. ");
INSERT INTO beln_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","I прыйшоў Бог да Лявана Арамейца ў сьне ўначы, і сказаў яму: “Сьцеражыся, не гавары Якубу ані добрага, ані ліхога”. ");
INSERT INTO beln_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","I дагнаў Ляван Якуба, а Якуб паставіў намёт свой на гары. І Ляван паставіў намёт з братамі сваімі на гары Гілеад. ");
INSERT INTO beln_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","I сказаў Ляван Якубу: “Што ты зрабіў? Ты ашукаў сэрца маё, і вывеў дочак маіх, быццам палоненых мячом. ");
INSERT INTO beln_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Чаму ты патаемна ўцёк, і абакраў мяне, і не сказаў мне? І я адпусьціў бы цябе з радасьцю і сьпевамі, з бубнамі і гусьлямі. ");
INSERT INTO beln_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","А ты не дазволіў мне пацалаваць сыноў маіх і дочак маіх. Гэта ты дрэнна зрабіў. ");
INSERT INTO beln_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ёсьць сіла ў руцэ маёй учыніць вам ліха, але Бог бацькі вашага ўчора ўначы сказаў мне, кажучы: “Сьцеражыся, не гавары Якубу ані добрага, ані ліхога”. ");
INSERT INTO beln_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","І цяпер ты, ідучы, пайшоў, бо ты сумуючы, засумаваў па доме бацькі твайго. Але навошта ты скраў багоў маіх?” ");
INSERT INTO beln_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","I адказаў Якуб, і сказаў Лявану: “Бо я баяўся, бо я казаў, што ты забярэш дочак сваіх у мяне. ");
INSERT INTO beln_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","У каго знойдзеш багоў свае, той ня будзе жыць. Перад братамі нашымі правер, што ёсьць у мяне, і вазьмі сабе”. А ня ведаў Якуб, што Рахель украла іх. ");
INSERT INTO beln_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","I ўвайшоў Ляван у намёт Якуба, і ў намёт Леі, і намёт дзьвюх нявольніцаў, і не знайшоў. I выйшаў з намёту Леі, і ўвайшоў у намёт Рахелі. ");
INSERT INTO beln_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","А Рахель узяла балваноў, і палажыла іх пад вярблюджае сядло, і села на іх. I абшукаў Ляван увесь намёт, і не знайшоў. ");
INSERT INTO beln_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","I сказала яна бацьку свайму: “Няхай не ўзгарыцца гнеў у вачах пана майго, што я не магу ўстаць перад табою, бо слабасьць жаночая ў мяне”. I ён шукаў, і не знайшоў балваноў. ");
INSERT INTO beln_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","I ўзгарэўся гнеў Якуба, і ён сварыўся з Ляванам. I адказаў Якуб, і сказаў Лявану: “Якая віна мая, які грэх мой, што ты гнаўся за мною? ");
INSERT INTO beln_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Бо ты абшукаў усе рэчы мае. Ці знайшоў ты нешта з рэчаў дому свайго? Палажы іх тут перад братамі маімі і братамі тваімі. Няхай яны рассудзяць паміж намі двума. ");
INSERT INTO beln_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Вось, дваццаць год я быў з табою. Авечкі твае і козы твае не скідалі, і бараноў з авечак тваіх я ня еў. ");
INSERT INTO beln_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Разьдзёртага зьвярамі я не прыносіў да цябе, я сам нёс віну, з рукі маёй ты шукаў гэта, ці яно было ўкрадзена ўдзень, ці ўкрадзена ўначы. ");
INSERT INTO beln_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Было, што ўдзень жэрла мяне гарачыня, і мароз уначы; і ўцякаў сон мой з вачэй маіх. ");
INSERT INTO beln_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Гэтакія былі мае дваццаць гадоў у доме тваім. Я служыў табе чатырнаццаць гадоў за дзьве дочкі твае і шэсьць гадоў за авечак тваіх, і ты зьмяняў плату маю дзесяць разоў. ");
INSERT INTO beln_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Калі б Бог бацькі майго, Бог Абрагама і Той, Каго баіцца Ісаак, ня быў са мною, дык цяпер пустым ты выслаў бы мяне. Пакуты мае і працу рук маіх бачыў Бог і рассудзіў учора ўвечары”. ");
INSERT INTO beln_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","I адказаў Ляван, і сказаў Якубу: “Дочкі гэтыя — мае дочкі, і сыны гэтыя — мае сыны; і авечкі гэтыя — мае авечкі, і ўсё, што ты бачыш, — гэта маё. I дочкам маім, што я зраблю ім сёньня, або сынам іхным, якіх яны нарадзілі? ");
INSERT INTO beln_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","А цяпер хадзі, заключым запавет я і ты, і ён будзе сьведчаньнем паміж мной і табою”. ");
INSERT INTO beln_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","I ўзяў Якуб камень, і паставіў яго як слуп. ");
INSERT INTO beln_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","I сказаў Якуб братом сваім: “Назьбірайце камянёў”. І яны ўзялі камяні, і зрабілі крушню, і елі там на крушні. ");
INSERT INTO beln_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","I назваў яе Ляван Егар-Сагадута, а Якуб назваў яе Галед. ");
INSERT INTO beln_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","I сказаў Ляван: “Крушня гэтая — сьведчаньне паміж мной і табою сёньня”. Таму і назвалі імя ейнае Галед ");
INSERT INTO beln_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","і Міцпа, бо ён сказаў: “Няхай назірае ГОСПАД паміж мною і табою, калі разыйдземся адзін ад аднаго. ");
INSERT INTO beln_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Калі ты будзеш уціскаць дочак маіх і калі возьмеш жонак акрамя дочак маіх, хоць няма чалавека з намі, глядзі, Бог — сьведка паміж мною і табою”. ");
INSERT INTO beln_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I сказаў Ляван Якубу: “Вось крушня гэтая, і вось слуп, які я паставіў паміж мной й табою. ");
INSERT INTO beln_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Сьведкам будзе крушня гэтая і сьведкам будзе слуп, што ані я не перайду да цябе за гэтую крушню і за гэты слуп, ані ты не пярэйдзеш да мяне за гэтую крушню і за гэты слуп з ліхім намерам. ");
INSERT INTO beln_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Бог Абрагама і Бог Нахора, Бог бацькоў іхніх няхай судзіць нас”. I прысягнуў Якуб на Таго, Каго баіцца бацька ягоны Ісаак. ");
INSERT INTO beln_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","I ахвяраваў Якуб ахвяру на гары, і паклікаў братоў сваіх есьці хлеб. І яны елі хлеб, і начавалі на гары. ");
INSERT INTO beln_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","I ўстаў Ляван рана раніцай, і пацалаваў сыноў сваіх і дочак сваіх, і дабраславіў іх, і пайшоў, і вярнуўся Ляван на сваё месца. ");
INSERT INTO beln_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","А Якуб пайшоў дарогаю сваёй. I сустрэлі яго анёлы Божыя. ");
INSERT INTO beln_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","I сказаў Якуб, убачыўшы іх: “Гэта табар Божы”. I назваў імя месца таго: Маханаім. ");
INSERT INTO beln_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","I паслаў Якуб пасланцоў перад сабою да Эзава, брата свайго, у зямлю Сэір, на поле Едому. ");
INSERT INTO beln_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I загадаў ім, кажучы: “Гэтак скажаце пану майму Эзаву: “Так кажа слуга твой Якуб: У Лявана я жыў, і заставаўся аж дагэтуль. ");
INSERT INTO beln_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I сталася, што маю вала і асла, і авечку, і слугу, і нявольніцу, і я паслаў сказаць пану майму, каб знайсьці ласку ў вачах тваіх”. ");
INSERT INTO beln_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","I вярнуліся пасланцы да Якуба, кажучы: “Мы прыйшлі да брата твайго, да Эзава, і ён таксама ідзе насустрач табе, і чатырыста чалавек з ім. ");
INSERT INTO beln_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","I спалохаўся Якуб вельмі, і быў стрывожаны, і падзяліў людзей, якія былі з ім, і авечак, і валоў, і вярблюдаў на два табары, ");
INSERT INTO beln_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I сказаў: “Калі Эзаў прыйдзе на адзін табар і выб’е яго, табар, які застанецца, ўцячэ”. ");
INSERT INTO beln_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","I сказаў Якуб: “Божа бацькі майго Абрагама і Божа бацькі майго Ісаака, ГОСПАДЗЕ, Ты сказаў мне: “Вярніся ў зямлю тваю, да родзічаў тваіх, і Я зраблю, каб было добра табе”. ");
INSERT INTO beln_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Я ня варты ўсёй міласэрнасьці і ўсёй праўды, якую Ты ўчыніў для слугі Твайго, бо я з кіем маім перайшоў Ярдан гэты, а цяпер стаю з двума табарамі. ");
INSERT INTO beln_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Выратуй, прашу, мяне з рукі брата майго, з рукі Эзава, бо я баюся яго, каб ён не прыйшоў, і не забіў мяне, і матак разам з сынамі. ");
INSERT INTO beln_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ты сказаў: “Робячы дабро, буду рабіць дабро табе, і зраблю насеньне тваё як пясок марскі, якога нельга палічыць дзеля мноства яго”. ");
INSERT INTO beln_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I начаваў там у тую ноч, і ўзяў з таго, што прыйшло ў рукі яму, дары для Эзава, брата свайго: ");
INSERT INTO beln_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","козаў дзьвесьце, казлоў дваццаць, авечак дзьвесьце і бараноў дваццаць, ");
INSERT INTO beln_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","вярблюдзіцаў дойных з вярблюдзянятамі іхнымі трыццаць, кароў сорак і валоў дзесяць, асьліцаў дваццаць і асьлянят дзесяць. ");
INSERT INTO beln_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","I даў у рукі слугам сваім кажную чараду асобна, і сказаў слугам сваім: “Перайдзіце перада мною, і трымаце адлегласьць паміж чарадой і чарадоў”. ");
INSERT INTO beln_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I загадаў першаму, кажучы: “Калі сустрэне цябе Эзаў, брат мой, і спытаецца ў цябе, кажучы: “Чый ты і куды ідзеш? І чыё гэта перад абліччам тваім?” ");
INSERT INTO beln_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ты скажаш: “Слугі твайго Якуба. Гэты дар пасланы пану майму Эзаву. І вось, таксама ён ідзе за намі”. ");
INSERT INTO beln_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","І загадаў тое самае другому, і трэйцяму, і ўсім, якія ішлі за чародамі, кажучы: “Паводле словаў гэтых кажыце Эзаву, калі знойдзеце яго, ");
INSERT INTO beln_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","і скажаце таксама: “Вось, слуга твой Якуб ідзе за намі”. Бо ён казаў: “Умалю аблічча ягонае дарам, які ідзець перада мною, і потым убачу аблічча ягонае. Можа, ён узьніме аблічча маё”. ");
INSERT INTO beln_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","I перайшоў дар перад ім, а ён начаваў у тую ноч у табары. ");
INSERT INTO beln_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","I ўстаў ён у тую ноч, і ўзяў дзьве жонкі свае, і дзьве нявольніцы свае, і адзінаццаць дзяцей сваіх, і перайшоў у брод Ябок. ");
INSERT INTO beln_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I ўзяў іх, і перавёў іх праз ручай, і перавёў, што было ў яго. ");
INSERT INTO beln_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","I застаўся Якуб сам адзін. І дужаўся з ім Муж да ўзыходу зараніцы. ");
INSERT INTO beln_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","I Той убачыў, што не пераможа яго, і дакрануўся да сустава сьцягна ягонага, і пашкодзіў сустаў сьцягна Якуба, калі дужаўся з ім, ");
INSERT INTO beln_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","і сказаў: “Пусьці Мяне, бо ўзыйшла зараніца”. I сказаў Якуб: “Не пушчу Цябе, пакуль не дабраславіш мяне”. ");
INSERT INTO beln_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","I Ён сказаў яму: “Якое імя тваё?” А ён сказаў: “Якуб”. ");
INSERT INTO beln_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","I сказаў: “Не Якуб будуць называць ужо імя тваё, але Ізраіль, бо ты змагаўся з Богам і з людзьмі, і перамог”. ");
INSERT INTO beln_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","I спытаўся Якуб, і сказаў: “Скажы, калі ласка, імя Тваё”. I Ён сказаў: “Навошта ты пытаешся імя Маё?” I дабраславіў яго там. ");
INSERT INTO beln_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","I назваў Якуб імя таго месца: Пэніэль, бо казаў: “Я бачыў Бога абліччам да аблічча, і захаваная душа мая”. ");
INSERT INTO beln_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I ўзышло сонца, калі ён праходзіў Пэніэль, і ён накульгваў на сьцягно сваё. ");
INSERT INTO beln_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Дзеля гэтага не ядуць сыны Ізраіля жылы цягліцы, якая на суставе сьцягна, аж да сёньня, бо Ён дакрануўся да суставу сьцягна Якуба, да жылы цягліцы. ");
INSERT INTO beln_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","I ўзьняў Якуб вочы свае, і ўбачыў, і вось, Эзаў прыйшоў, і з ім чатырыста чалавек. I ён падзяліў дзяцей Леі, Рахелі і дзьвюх нявольніцаў. ");
INSERT INTO beln_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I паставіў нявольніц і дзяцей іхніх першымі, а Лею і дзяцей ейных за імі, а Рахель і Язэпа за імі. ");
INSERT INTO beln_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","І ён выйшаў перад імі, і пакланіўся да зямлі сем разоў, пакуль наблізіўся да брата свайго. ");
INSERT INTO beln_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","I пабег Эзаў яму насустрач, і абняў яго, і ўпаў на шыю яму, і цалаваў яго, і плакалі. ");
INSERT INTO beln_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","І ўзьняў ён вочы свае, і ўбачыў жанчынаў і дзяцей, і сказаў: “Хто яны табе?” I сказаў Якуб: “Дзеці, якімі Бог абдараваў слугу твайго”. ");
INSERT INTO beln_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","I наблізіліся нявольніцы, самі і дзеці іхнія, і пакланіліся. ");
INSERT INTO beln_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","I наблізілася таксама Лея і дзеці ейныя, і пакланіліся. А потым наблізіліся Язэп і Рахель, і пакланіліся. ");
INSERT INTO beln_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","I сказаў Эзаў: “Што ў цябе за цэлы табар гэты, які я сустрэў?” I сказаў Якуб: “Каб знайсьці ласку ў вачах пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","I сказаў Эзаў: “Маю я шмат, браце мой. Няхай будзе тваё тое, што ў цябе”. ");
INSERT INTO beln_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","I сказаў Якуб: “Не, прашу, калі я знайшоў ласку ў вачах тваім, прымі дар мой з рукі маёй, бо я, убачыўшы аблічча тваё, быццам убачыў аблічча Божае, і ты меў ласку да мяне. ");
INSERT INTO beln_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Прымі, прашу, дабраславенства мае, якое я прывёў табе; бо Бог абдараваў мяне, і я маю ўсё”. I ён упрасіў яго, і той узяў. ");
INSERT INTO beln_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","I сказаў Эзаў: “Вырушым і пойдзем, і я буду ісьці разам з табою”. ");
INSERT INTO beln_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","I сказаў яму Якуб: “Пан мой ведае, што дзеці кволыя, і авечкі котныя, і каровы цельныя ў мяне. Калі пагнаць іх адзін дзень, паздыхаюць усе авечкі. ");
INSERT INTO beln_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Няхай пан мой пойдзе перад абліччам слугі свайго, а я пайду паволі, паводле хады чарады, якая перада мною, і паводле хады дзяцей, аж прыйду да пана майго ў Сэір”. ");
INSERT INTO beln_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","I сказаў Эзаў: “Я пакіну з табою частку людзей, якія са мною”. I сказаў Якуб: “Навошта гэта, калі я знайшоў ласку ў вачах пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","I вярнуўся ў той дзень Эзаў шляхам сваім у Сэір. ");
INSERT INTO beln_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","А Якуб вырушыў у Сукот і пабудаваў сабе дом, а статку свайму парабіў буданы. Дзеля гэтага ён назваў імя месцу таму Сукот. ");
INSERT INTO beln_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","I прыйшоў Якуб у супакоі да горады Сыхем, які ў зямлі Ханаан, калі прыйшоў з Падан-Араму, і паставіў намёты перад горадам. ");
INSERT INTO beln_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","I купіў ён частку поля, на якім паставіў намёт свой, з рукі сыноў Гамора, бацькі Сыхема, за сто кесытаў. ");
INSERT INTO beln_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","I паставіў там ахвярнік; і назваў яго “Бог ёсьць Бог Ізраіля”. ");
INSERT INTO beln_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","I выйшла Дзіна, дачка Леі, якую яна нарадзіла Якубу, паглядзець на дочак зямлі той. ");
INSERT INTO beln_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","I ўбачыў яе Сыхем, сын Гамора Хівея, князя зямлі той, і ўзяў яе, і ляжаў з ёю, і згвалціў яе. ");
INSERT INTO beln_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","I прыляпілася душа ягоная да Дзіны, дачкі Якуба, і ён пакахаў дзяўчыну, і гаварыў да сэрца дзяўчыны. ");
INSERT INTO beln_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","I сказаў Сыхем Гамору, бацьку свайму, кажучы: “Вазьмі мне дзяўчыну гэтую за жонку”. ");
INSERT INTO beln_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","I Якуб пачуў, што зганьблена Дзіна, дачка ягоная, а сыны ягоныя былі пры статку на полі, і маўчаў Якуб, пакуль не прыйшлі яны. ");
INSERT INTO beln_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","I выйшаў Гамор, бацька Сыхему, да Якуба паразмаўляць з ім. ");
INSERT INTO beln_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","А сыны Якуба прыйшлі з поля, і, пачуўшы, засмуціліся мужы, і гневаліся вельмі, бо ганьбу зрабіў Сыхем Ізраілю, лёгшы з дачкою Якуба, бо гэтак ня робіцца. ");
INSERT INTO beln_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","I гаварыў Гамор з імі, кажучы: “Сыхем, сын мой, прыляпіўся душою сваёю да дачкі вашае. Дайце, прашу, яе яму за жонку. ");
INSERT INTO beln_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","І пасваячцеся з намі, дочак вашых дайце нам, а нашых дочак бярыце сабе. ");
INSERT INTO beln_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","I з намі жывіце, і зямля гэтая будзе перад абліччам вашым, жывіце і гандлюйце ў ёй, і бярыце яе на ўласнасьць”. ");
INSERT INTO beln_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","I сказаў Сыхем бацьку ейнаму і братам ейным: “Каб я знайшоў ласку ў вачах вашых, і што скажаце мне, я дам. ");
INSERT INTO beln_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Павялічце мне вельмі вена і дары, і я дам, што вы скажаце мне, толькі дайце мне дзяўчыну за жонку”. ");
INSERT INTO beln_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","I адказалі сыны Якуба Сыхему і Гамору, бацьку ягонаму, падступна, і гаварылі так, бо ён зганьбіў Дзіну, сястру іхнюю. ");
INSERT INTO beln_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I сказалі ім: “Ня можам зрабіць гэтага, выдаць сястру нашую чалавеку, які мае скуравінку, бо ганьба гэта для нас. ");
INSERT INTO beln_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Толькі тады мы пагодзімся з вамі, калі вы будзеце, як мы, каб быў абрэзаны ў вас кожны мужчына. ");
INSERT INTO beln_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","I будзем даваць дочак нашых вам, а дочак вашых браць сабе, і будзем жыць з вамі, і будзем адзін народ. ");
INSERT INTO beln_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","А калі не паслухаеце нас, каб абрэзацца, мы возьмем дачку нашую і адыйдзем”. ");
INSERT INTO beln_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","I былі добрымі словы іхнія ў вачах Гамора і ў вачах Сыхема, сына Гамора. ");
INSERT INTO beln_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","I не затрымаўся юнак той зрабіць гэтую справу, бо ён жадаў дачку Якуба. А ён быў найбольш шанаваны ў-ва ўсім доме бацькі свайго. ");
INSERT INTO beln_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","I прыйшоў Гамор і Сыхем, сын ягоны, да брамы гораду свайго, і гаварылі жыхарам гораду свайго, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Гэтыя людзі прыязныя да нас. Няхай яны жывуць у зямлі гэтай і гандлююць у ёй. І зямля гэтая прасторная перад абліччам іхнім. Дочак іхніх возьмем сабе за жонак, а дочак нашых дамо ім. ");
INSERT INTO beln_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Толькі пры адной умове пагодзяцца з намі людзі гэтыя, каб жыць з намі і быць адным народам, калі у нас будуць абрэзаныя ўсе мужчынскага роду, як яны абрэзаны. ");
INSERT INTO beln_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Статкі іхнія, і маёмасьць іхняя, і ўся скаціна іхняя, ці ж ня нашая будзе? Толькі пагодзімся з імі, і яны будуць жыць з намі”. ");
INSERT INTO beln_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","I паслухалі Гамора і Сыхема, сына ягонага, усе, што выходзізі з брамы гораду свайго; і былі абрэзаныя ўсе мужчынскага роду, усе, што выходзілі з брамы гораду свайго. ");
INSERT INTO beln_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","I сталася на трэйці дзень, калі яны былі ў вялікім болю, і ўзялі два сыны Якуба, Сымон і Левій, браты Дзіны, кожны меч свой, і ўвайшлі ў горад, які пачуваўся бясьпечна, і забілі ўсіх мужчынаў. ");
INSERT INTO beln_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","I Гамора, і Сыхема, сына ягонага, забілі мячом, і ўзялі Дзіну з дому Сыхема, і выйшлі. ");
INSERT INTO beln_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Сыны Якуба прыйшлі да забітых і зрабавалі горад за тое, што зганьбілі сястру іхнаю. ");
INSERT INTO beln_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I авечак іхніх, і валоў іхніх, і аслоў іхніх, і тое, што было ў горадзе і што было ў полі, яны ўзялі. ");
INSERT INTO beln_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I ўсё багацьце іхняе, і ўсіх дзяцей іхніх, і жанчынаў іхніх ўзялі ў палон, і зрабавалі ўсё, што было ў дамах. ");
INSERT INTO beln_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","I сказаў Якуб Сымону і Левію: “Вы зрабілі зьнішчэньне мяне, зрабіўшы мяне агідным для жыхароў зямлі гэтае, Хананейцаў і Пэрэзэяў, а ў мяне людзей няшмат, і зьбяруцца на мяне, і паб’юць мяне, і будуць зьнішчаны я і дом мой”. ");
INSERT INTO beln_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","А яны сказалі: “Ці ж можна рабіць з сястрою нашаю як з блудніцаю?” ");
INSERT INTO beln_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","I сказаў Бог Якубу: “Устань, узыйдзі ў Бэтэль, і жыві там, і зрабі там ахвярнік Богу, Які зьявіўся табе, калі ты ўцякаў ад аблічча Эзава, брата твайго”. ");
INSERT INTO beln_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","I сказаў Якуб дому свайму і ўсім, якія былі з ім: “Аддзяліце ад сябе багоў чужых, якія сярод вас, і ачысьціцеся, і зьмяніце адзеньні вашыя, ");
INSERT INTO beln_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","і ўстаньма, і ўзыйдзем у Бэтэль, і я зраблю там ахвярнік Богу, Які адказаў мне ў дзень нядолі маёй і быў са мною ў дарозе, якой я ішоў”. ");
INSERT INTO beln_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","I аддалі Якубу ўсіх багоў чужых, якія былі ў руках іхніх, і завушніцы, што былі ў вушах іхніх; і закапаў іх Якуб пад дубам, які каля Сыхему. ");
INSERT INTO beln_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","I вырушылі яны. I быў жах Божы на гарадах, што былі ў той ваколіцы, і ня гналіся яны за сынамі Якуба. ");
INSERT INTO beln_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","I прыйшоў Якуб у Люз, які ў зямлі Ханаан, ён жа Бэтэль, сам і ўвесь народ, які з ім. ");
INSERT INTO beln_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I пабудаваў ён там ахвярнік, і назваў гэтае месца Эль-Бэт-Эль, бо там зьявіўся яму Бог, калі ён уцякаў ад аблічча брата свайго. ");
INSERT INTO beln_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","I памерла Дэвора, нянька Рэбэкі, і была пахаваная ніжэй Бэтэлю пад дубам, і названа імя ягонае “Дуб плачу”. ");
INSERT INTO beln_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","I зьявіўся Бог Якубу ізноў пасьля прыходу ягонага з Падан-Араму, і дабраславіў яго. ");
INSERT INTO beln_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I сказаў яму Бог: “Імя тваё Якуб. Ня будзе ўжо называцца імя тваё Якуб, але Ізраіль будзе імя тваё”. I назваў яго імя Ізраіль. ");
INSERT INTO beln_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I сказаў яму Бог: “Я — Бог Ўсемагутны! Пладзіся і памнажайся! Народ і зграмаджэньне народаў будзе з цябе, і валадары выйдуць з паясьніцы тваёй. ");
INSERT INTO beln_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","І зямлю, якую Я даў Абрагаму і Ісааку, Я дам табе, і насеньню твайму пасьля цябе Я дам зямлю гэтую”. ");
INSERT INTO beln_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","I ўзыйшоў ад яго Бог з месца, на якім гаварыў з ім. ");
INSERT INTO beln_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","I паставіў Якуб слуп на месцы, на якім Бог гаварыў з ім, слуп каменны, і ўзьліў на яго ўзьліваньне, і ўзьліў на яго алей. ");
INSERT INTO beln_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","I назваў Якуб імя месца, на якім Бог гаварыў з ім, Бэтэль. ");
INSERT INTO beln_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","I вырушыў з Бэтэлю. I быў яшчэ кавалак зямлі, каб прыйсьці да Ефраты; і нарадзіла Рахель, і цяжкія былі роды. ");
INSERT INTO beln_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","I сталася, што яна нараджала з вялікім болем, і сказала ёй павітуха: “Ня бойся, бо таксама гэта сын у цябе”. ");
INSERT INTO beln_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","I сталася, калі выходзіла з яе душа, бо яна памірала, яна назвала імя ягонае Бэн-Оні, а бацька ягоны назваў яго Бэн’ямін. ");
INSERT INTO beln_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","I памерла Рахель, і была пахаваная пры дарозе ў Ефрату, гэта Бэтлеем. ");
INSERT INTO beln_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","I паставіў Якуб слуп над магілай ейнай. Гэта слуп магільны Рахелі да сёньня. ");
INSERT INTO beln_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","I вырушыў адтуль Ізраіль, і паставіў намёт свой за Мігдаль-Эдэрам. ");
INSERT INTO beln_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","I сталася, калі жыў Ізраіль у зямлі той, пайшоў Рубэн, і лёг з Більгай, наложніцай бацькі свайго. I пачуў пра гэта Ізраіль. I было сыноў Якуба дванаццаць. ");
INSERT INTO beln_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Сыны Леі: першародны Якуба Рубэн, Сымон, Левій, Юда, Ісахар і Завулён. ");
INSERT INTO beln_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Сыны Рахелі: Язэп і Бэн’ямін. ");
INSERT INTO beln_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","I сыны Більгі, нявольніцы Рахелі: Дан і Нэфталі. ");
INSERT INTO beln_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","I сыны Зільпы, нявольніцы Леі: Гад і Асэр. Гэта сыны Якуба, якія нарадзіліся ў яго ў Падан-Араме. ");
INSERT INTO beln_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","I прыйшоў Якуб да Ісаака, бацькі свайго, у Мамрэ, у Кірыят-Арбу, гэта значыць у Хеўрон, дзе жылі Абрагам і Ісаак. ");
INSERT INTO beln_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I было дзён Ісаака сто восемдзясят гадоў. ");
INSERT INTO beln_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I супачыў Ісаак, і памёр, і быў далучаны да народу свайго, стары і насычаны днямі, і пахавалі яго Эзаў і Якуб, сыны ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","I вось радавод Эзава, ён жа Эдом. ");
INSERT INTO beln_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Эзаў узяў сабе жонкі з дачок Ханаану: Аду, дачку Элёна Хета, і Агаліваму, дачку Аны, дачку Цывеона Хівея, ");
INSERT INTO beln_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","і Басэмат, дачку Ізмаэля, сястру Наваёта. ");
INSERT INTO beln_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I нарадзіла Ада Эзаву Эліфаза, а Басэмат нарадзіла Рэўэля, ");
INSERT INTO beln_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","а Агалівама нарадзіла Евуша, Яляма і Караха. Гэта сыны Эзава, якія нарадзіліся ў яго ў зямлі Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","I ўзяў Эзаў жонак сваіх, і сыноў сваіх, і дочак сваіх, і ўсе душы дому свайго, і статкі свае, і ўсю скаціну сваю, і ўсю маёмасьць сваю, якую ён прыдбаў у зямлі Ханаан, і пайшоў у іншую зямлю ад аблічча Якуба, брата свайго, ");
INSERT INTO beln_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","бо была маёмасьць іхняя вялікая, каб яны маглі жыць разам, і не магла зямля вандраваньня іхняга насіць іх з прычыны статкаў іхніх. ");
INSERT INTO beln_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","I пасяліўся Эзаў на гары Сэір, Эзаў, ён жа Эдом. ");
INSERT INTO beln_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","I вось радавод Эзава, бацькі Эдому на гары Сэір. ");
INSERT INTO beln_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Вось імёны сыноў Эзава: Эліфаз, сын Ады, жонкі Эзава; Рэўэль, сын Басэмат, жонкі Эзава. ");
INSERT INTO beln_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","І былі сыны Эліфаза: Тэман, Амар, Цэфо, Гатам і Кеназ. ");
INSERT INTO beln_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","А Тымна была наложніцай Эліфаза, сына Эзава, і яна нарадзіла Эліфазу Амалека. Гэта сыны Ады, жонкі Эзава. ");
INSERT INTO beln_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","І вось сыны Рэўэля: Нахат, Зэрах, Шамма і Міза. Гэтыя былі сынамі Басэмат, жонкі Эзава. ");
INSERT INTO beln_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","I вось сыны Агалівамы, дачкі Аны, дачкі Цывеона, жонкі Эзава. Яна нарадзіла Эзаву Евуша, Яляма і Караха. ");
INSERT INTO beln_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Вось князі сыноў Эзава. Сыны Эліфаза, першароднага Эзава: князь Тэман, князь Амар, князь Цэфо, князь Кеназ, ");
INSERT INTO beln_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","князь Карах, князь Гатам, князь Амалек. Гэта князі Эліфаза ў зямлі Эдом, гэта сыны Ады. ");
INSERT INTO beln_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","А вось сыны Рэўэля, сына Эзава: князь Нагат, князь Зэрах, князь Шамма, князь Міза. Гэта князі Рэўэля ў зямлі Эдом, гэта сыны Басэмат, жонкі Эзава. ");
INSERT INTO beln_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","А вось сыны Агалівамы, жонкі Эзава: князь Евуш, князь Ялям, князь Карах. Гэта князі Агалівамы, дачкі Аны, жонкі Эзава. ");
INSERT INTO beln_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Вось сыны Эзава, і вось князі іхныя. Гэта Эдом. ");
INSERT INTO beln_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Вось сыны Сэіра Харэя, жыхары зямлі той: Лётан, Шаваль, Цывеон, Ана, ");
INSERT INTO beln_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дышон, Эцэр і Дышан. Гэта князі Харэяў, сыны Сэіра ў зямлі Эдом. ");
INSERT INTO beln_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","I былі сыны Лётана: Хоры і Геман, а сястра Лётана — Тымна. ");
INSERT INTO beln_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","А вось сыны Шаваля: Альван, Манахат, Эваль, Шэфо і Анам. ");
INSERT INTO beln_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","А вось сыны Цывеона: Ая і Ана. Гэта той Ана, які знайшоў гарачыя крыніцы ў пустыні, калі пасьвіў аслоў Цывеона, бацькі свайго. ");
INSERT INTO beln_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","А вось сыны Аны: Дышон і Агалівама, дачка Аны. ");
INSERT INTO beln_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","А вось сыны Дышона: Хемдан, Эшбан, Ітран, і Херан. ");
INSERT INTO beln_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Вось сыны Эцэра: Більган, Зааван і Акан. ");
INSERT INTO beln_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Вось сыны Дышана: Уц і Аран. ");
INSERT INTO beln_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Вось князі Харэяў: князь Лётан, князь Шаваль, князь Цывеон, князь Ана, ");
INSERT INTO beln_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","князь Дышон, кянзь Эцэр, князь Дышан. Гэта князі Харэяў паводле княстваў сваіх у зямлі Сэір. ");
INSERT INTO beln_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","А вось валадары, якія валадарылі ў зямлі Эдом, раней за валадараньне валадароў у сыноў Ізраіля. ");
INSERT INTO beln_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","I валадарыў у Эдоме Бэла, сын Бэора, а імя гораду ягонага — Дынгава. ");
INSERT INTO beln_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","I памёр Бела, і валадарыў пасьля яго Ёваў, сын Зэраха, з Боцры. ");
INSERT INTO beln_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","I памёр Ёваў, і валадарыў пасьля яго Хушам, з зямлі Тэманскае. ");
INSERT INTO beln_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","І памёр Хушам, і валадарыў пасьля яго Гадад, сын Бэдада, які пабіў Мадыянцаў на полі Мааўскім; а імя гораду ягонага — Авіт. ");
INSERT INTO beln_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","I памёр Гадад, і валадарыў пасьля яго Самла з Масрэкі. ");
INSERT INTO beln_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","I памёр Самла, і валадарыў пасьля яго Шауль з Рэхавота, што каля ракі. ");
INSERT INTO beln_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","I памёр Шауль, і валадарыў пасьля яго Баал-Ханан, сын Ахбора. ");
INSERT INTO beln_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","I памёр Баал-Ханан, сын Ахбора, і валадарыў пасьля яго Гадар, а імя гораду ягонага — Паў; а імя жонкі ягонае — Мэгетавэль, дачка Матрэды, дачкі Мэзагава. ");
INSERT INTO beln_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","А вось імёны князёў Эзава, паводле плямёнаў іхніх, паводле мясцовасьцяў іхніх, названых імёнамі іхнімі: князь Тымна, князь Альва, князь Етэт, ");
INSERT INTO beln_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","князь Агалівама, князь Эла, князь Пінон, ");
INSERT INTO beln_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","князь Кеназ, князь Тэман, князь Міўцар, ");
INSERT INTO beln_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","князь Магдыель, князь Ірам. Вось князі Эдому, паводле слялібаў іхных, у зямлі ўласнасьці іхняй. Гэта Эзаў, бацька Эдому. ");
INSERT INTO beln_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","І жыў Якуб у зямлі вандраваньня бацькі свайго, у зямлі Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Вось радавод Якуба. Язэп, маючы сямнаццаць гадоў, пасьвіў авечкі з братамі сваімі. І быў ён юнаком, разам з сынамі Більгі і сынамі Зільпы, жонак бацькі свайго. I прыносіў Язэп ліхія весткі пра іх да бацькі іхняга. ");
INSERT INTO beln_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","А Ізраіль любіў Язэпа больш за ўсіх сыноў сваіх, бо ён быў сын старасьці ягонае; і ён справіў яму каляровую шату. ");
INSERT INTO beln_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","I ўбачылі браты ягоныя, што бацька іхні любіць яго больш за ўсіх братоў, і зьненавідзелі яго, і не маглі гаварыць з ім спакойна. ");
INSERT INTO beln_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","I сьніў Язэп сон, і расказаў братам сваім, і яны яшчэ больш зьненавідзелі яго. ");
INSERT INTO beln_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","І ён сказаў ім: “Паслухайце, калі ласка, сон гэты, які я сьніў: ");
INSERT INTO beln_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","I вось, мы вяжам снапы сярод поля; і вось, устаў сноп мой, і так стаяў; і вось, абступілі яго снапы вашыя і пакланіліся снапу майму”. ");
INSERT INTO beln_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","I сказалі яму браты ягоныя: “Няўжо валадарачы, ты будзеш валадарыць над намі? Ці, пануючы, будзеш панаваць над намі?” I яшчэ больш зьненавідзелі яго за сны ягоныя і за словы ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","I сьніў ён яшчэ другі сон, і расказаў яго братам сваім, і сказаў: “Вось, я сьніў яшчэ сон: і вось, сонца, і месяц, і адзінанцаць зорак кланяліся мне”. ");
INSERT INTO beln_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","I ён распавёў бацьку свайму і братам сваім; і насварыўся на яго бацька ягоны, і сказаў яму: “Што гэта за сон, які ты сьніў? Ці ж прыходзячы, прыйду я, і маці твая, і браты твае, каб пакланіцца табе да зямлі?” ");
INSERT INTO beln_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I зайздросьцілі яму браты ягоныя, а бацька ягоны захоўваў гэтае слова. ");
INSERT INTO beln_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","I пайшлі браты ягоныя пасьвіць авечкі бацькі свайго ў Сыхем. ");
INSERT INTO beln_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","I сказаў Ізраіль Язэпу: “Ці ж браты твае ня пасьвяць у Сыхеме? Ідзі, я пашлю цябе да іх”. А ён сказаў яму: “Вось я!” ");
INSERT INTO beln_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I сказаў яму: “Пайдзі, прашу, паглядзі, ці ў супакоі браты твае і ці ў супакоі авечкі, і прынясі мне вестк”. I паслаў яго з даліны Хеўрон; і ён пайшоў у Сыхем. ");
INSERT INTO beln_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I знайшоў яго нейкі чалавек, а вось, ён блукаў у полі, і спытаўся ў яго той чалавек, кажучы: “Што шукаеш?” ");
INSERT INTO beln_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","А ён сказаў: “Я шукаю братоў маіх. Прашу, скажы мне, дзе яны пасьвяць?” ");
INSERT INTO beln_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","I сказаў чалавек той: “Яны вырушылі адсюль, бо я чуў, як яны казалі: “Хадзем у Датан”.” I пайшоў Язэп за братамі сваімі, і знайшоў іх у Датане. ");
INSERT INTO beln_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","I яны ўбачылі яго здалёк, перш, чым ён наблізіўся да іх, і змовіліся супраць яго, каб усьмерціць яго. ");
INSERT INTO beln_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I сказалі адзін да аднаго: “Вось, гэты гаспадар сноў ідзе. ");
INSERT INTO beln_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","I цяпер хадзем, і заб’ем яго, і кінем яго ў нейкую яму, і скажам: “Злы зьвер зьеў яго”, і паглядзім, што будзе з ягоных сноў”. ");
INSERT INTO beln_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","I пачуў гэта Рубэн, і выбавіў яго з рук іхніх, і сказаў: “Не забівайма душы”. ");
INSERT INTO beln_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","I сказаў ім Рубэн: “Не разьлівайце крыві, кіньце яго ў гэтую яму, якая ў пустыні, а рукі не выцягніце на яго”, каб выбавіць яго ад рукі іхнае, каб вярнуць яго бацьку ягонаму. ");
INSERT INTO beln_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","I сталася, калі Язэп прыйшоў да братоў сваіх, яны зьнялі з Язэпа адзеньне ягонае, шату каляровую, якая была на ім. ");
INSERT INTO beln_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","I ўзялі яго, і кінулі яго ў яму; а яма была пустая, не было ў ёй вады. ");
INSERT INTO beln_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","I селі яны есьці хлеб, і ўзьнялі вочы свае, і ўбачылі, і вось, караван Ізмаэльцаў ідзе з Гілеаду, і вярблюды іхныя нясуць пахнідлы, бальзам і ладан, ідучы, каб завезьці гэта ў Эгіпет. ");
INSERT INTO beln_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","I сказаў Юда братам сваім: “Якая карысьць, што мы заб’ем брата нашага і схаваем кроў ягоную? ");
INSERT INTO beln_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Пойдзем і прадамо яго Ізмаэльцам, і рукі нашыя няхай ня будуць на ім; бо ён — брат наш, цела наша”. I паслухалі яго браты ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","I праходзілі тыя людзі, купцы Мадыянскія, а яны выцягнулі Язэпа з ямы, і прадалі Язэпа Ізмаэльцам за дваццаць срэбнікаў; і тыя завялі Язэпа ў Эгіпет. ");
INSERT INTO beln_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","I вярнуўся Рубэн да ямы, і вось, няма Язэпа ў яме. I разарваў ён адзеньне сваё, ");
INSERT INTO beln_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","і вярнуўся да братоў сваіх, і сказаў: “Хлопца няма, а я, куды я пайду?” ");
INSERT INTO beln_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","I ўзялі яны шату Язэпаву, і зарэзалі казла, і занурылі шату ў кроў; ");
INSERT INTO beln_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","I паслалі шату каляровую, і прынесьлі бацьку свайму, і сказалі: “Гэта мы знайшлі. Спраўдзь, просім, ці гэта адзеньне сына твайго, ці не?” ");
INSERT INTO beln_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","I ён пазнаў яго, і сказаў: “Шаты сына майго. Дзікі зьвер зьеў яго, разьдзіраючы; разьдзёрты Язэп”. ");
INSERT INTO beln_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","I разарваў Якуб адзеньне сваё, і апрануў зрэбніцу на сьцёгны свае, і плакаў па сыне сваім шмат дзён. ");
INSERT INTO beln_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","I ўсталі ўсе сыны ягоныя, і ўсе дочкі ягоныя, каб пацешыць яго, але ён адмаўляўся пацешыцца, і казаў: “Бо зыйду да сына майго са смуткам у апраметную” I плакаў па ім бацька ягоны. ");
INSERT INTO beln_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","А Мадыяняне прадалі яго ў Эгіпце Патыфару, урадоўцу фараона, начальніку варты. ");
INSERT INTO beln_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","I сталася ў той час, і зыйшоў Юда ад братоў сваіх, і паставіў намёт свой у аднаго Адулямца, імя якога — Хіра. ");
INSERT INTO beln_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I ўбачыў там Юда дачку аднаго Хананейца, імя якога — Шуа, і ўзяў яе, і ўвайшоў да яе. ");
INSERT INTO beln_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","I яна зачала, і нарадзіла сына; і ён назваў імя ягонае Ер. ");
INSERT INTO beln_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I зачала яна зноў, і нарадзіла сына, і назвала імя ягонае Анан. ");
INSERT INTO beln_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","I яшчэ дадала, і нарадзіла сына, і назвала імя ягонае Шэля. Яна была ў Хезіве, як нарадзіла яго. ");
INSERT INTO beln_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","I ўзяў Юда жонку для Ера, першароднага свайго, імя якой — Тамар. ");
INSERT INTO beln_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","I быў Ер, першародны Юды, ліхі ў вачах ГОСПАДА, і ўсьмерціў яго ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","I сказаў Юда Анану: «Увайдзі да жонкі брата свайго, і споўні абавязак швагра з ёю, і узнаві насеньне брату свайму». ");
INSERT INTO beln_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","I ведаў Анан, што не яму будзе насеньне; і было, што калі ён уваходзіў да жонкі брата свайго, выліваў на зямлю, каб ня даць насеньня брату свайму. ");
INSERT INTO beln_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I было ліхім у вачах ГОСПАДА тое, што ён рабіў; і Ён таксама ўсьмерціў яго. ");
INSERT INTO beln_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","I сказаў Юда Тамары, нявестцы сваёй: “Застанься ўдавою ў доме бацькі свайго, пакуль вырасьце Шэля, сын мой”. Бо ён сказаў: “Каб не памёр таксама ён, як браты ягоныя”. I пайшла Тамар, і жыла ў доме бацькі свайго. ");
INSERT INTO beln_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","I прайшло шмат дзён, і памерла дачка Шуа, жонка Юды. I суцешыўся Юда пасьля жалобы, і ўзыйшоў у Тымну да стрыгачоў авечак сваіх, сам і Хіра Адулямец, таварыш ягоны. ");
INSERT INTO beln_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","І паведамілі Тамар, кажучы: “Вось, сьвёкар твой узыходзіць у Тымну стрыгчы авечак сваіх”. ");
INSERT INTO beln_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","I яна скінула з сябе ўдовінае адзеньне сваё, і засланілася вэлюмам, і, захінуўшыся, села каля ўваходу ў Энаім, які на дарозе да Тымны, бо бачыла, што Шэля вырас, а яна ня дадзена яму за жонку. ");
INSERT INTO beln_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","I ўбачыў яе Юда, і падумаў, што яна — блудніца, бо яна закрыла аблічча сваё. ");
INSERT INTO beln_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","І ён павярнуў да яе з дарогі і сказаў: “Дазволь, прашу, увайду да цябе”. Бо ён ня ведаў, што яна — невестка ягоная. А яна сказала: “Што ты дасі мне, калі ўвойдзеш да мяне?” ");
INSERT INTO beln_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I ён сказаў: “Я прышлю табе казьляня з чарады”. А яна сказала: “Ці дасі мне заруку, пакуль прышлеш яго”. ");
INSERT INTO beln_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I ён сказаў: “Якую заруку даць табе?” А яна сказала: “Пячатку тваю, і пасак твой, і кій твой, які ў руцэ тваёй”. I ён даў ёй, і ўвыайшоў да яе; і яна зачала яму. ");
INSERT INTO beln_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","І ўстала, і пайшла, і зьняла вэлюм свой з сябе, і апранулася ва шдовіны шаты. ");
INSERT INTO beln_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","I паслаў Юда казьляня праз рукі таварыша свайго Адулямца, каб узяць заруку з рукі жанчыны; але ён не знайшоў яе. ");
INSERT INTO beln_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I пытаўся ён у людзей месца таго, кажучы: “Дзе блудніца, якая ў Энаіме пры дарозе?” А яны казалі: “Тут не было блудніцы”. ");
INSERT INTO beln_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","I вярнуўся ён да Юды, і сказаў: “Я не знайшоў яе; і таксама людзі таго месца казалі: “Тут не было блудніцы”. ");
INSERT INTO beln_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","I сказаў Юда: “Няхай яна возьме заруку сабе, каб толькі не было з нас кпінаў; вось, я паслаў казьляня гэтае, а ты не знайшоў яе”. ");
INSERT INTO beln_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","І сталася, што праз тры месяцы паведамілі Юдзе, кажучы: “Чужаложыла Тамар, нявестка твая, і нават яна цяжарная ад распусты”. I сказаў Юда: “Вывядзіце яе, і няхай будзе спаленая”. ");
INSERT INTO beln_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Яе павялі на спаленьне, а яна паслала да сьвёкра свайго, кажучы: “Ад чалавека, якога гэтыя рэчы, я цяжарная”. I сказала: “Пазнавай, чыя пячатка, і пас, і кій вось гэтыя”. ");
INSERT INTO beln_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","I пазнаў іх Юда, і сказаў: “Яна справядліўшая за мяне, бо я ня даў яе Шэлі, сыну свайму”. I больш не пазнаваў яе. ");
INSERT INTO beln_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","I сталася ў часе родаў ейных, і вось, блізьняты ў жываце ейным. ");
INSERT INTO beln_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","I сталася пры родах, і высунуў адзін ручку; і ўзяла павітуха, і завязала на ручку яму чырвоную нітку, кажучы: “Гэты выйшаў першы”. ");
INSERT INTO beln_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","I сталася, што схавалася рука ягоная, і вось, выйшаў брат ягоны. I яна сказала: “Як ты прарваў перагароду?”. I назвала імя ягонае Пэрэс. ");
INSERT INTO beln_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","А потым выйшаў брат ягоны, у якога на руцэ чырвоная нітка. I назвала імя ягонае Зарах. ");
INSERT INTO beln_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","А Язэп быў заведзены ў Эгіпет, і купіў яго Патыфар, урадовец фараона, начальнік варты, Эгіпцянін, з рук Ізмаэльцаў, якія завялі яго туды. ");
INSERT INTO beln_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","I быў ГОСПАД з Язэпам, і стаўся ён чалавекам, які мае посьпех, і быў у доме гаспадара свайго, Эгіпцяніна. ");
INSERT INTO beln_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","I бачыў гаспадар ягоны, што ГОСПАД з ім, і ўсяму, што ён робіць, ГОСПАД дае посьпех у руках ягоных. ");
INSERT INTO beln_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","I знайшоў Язэп ласку ў вачах ягоных, і служыў яму, і ён паставіў яго над домам сваім, і ўсё, што меў, аддаў у рукі ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","I сталася, што ад таго часу, як ён паставіў яго над домам сваім і над усім, што меў, ГОСПАД дабраславіў дом Эгіпцяніна дзеля Язэпа, і было дабраславеньне ГОСПАДА на ўсім, што меў ён у доме і ў полі. ");
INSERT INTO beln_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I аддаў ён усё, што меў, у рукі Язэпа; і ня рупіўся ні пра што, акрамя хлеба, які ён еў. А Язэп меў зграбную постаць і прывабны выгляд. ");
INSERT INTO beln_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","I сталася пасьля гэтых падзеяў, і ўзьняла жонка гаспадара ягонага вочы свае на Язэпа, і сказала: “Ляж са мною”. ");
INSERT INTO beln_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Але ён адмовіўся, і сказаў жонцы гаспадара свайго: “Вось, гаспадар мой ня рупіцца пры мне ні пра што ў доме, і ўсё, што мае, аддаў у руку маю. ");
INSERT INTO beln_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Няма нікога, важнейшага за мяне, у доме гэтым; і ён не забараняе мне нічога, акрамя толькі цябе, бо ты — жонка ягоная. І як я магу ўчыніць такое вялікае злачынства і зграшыць супраць Бога”. ");
INSERT INTO beln_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","I сталася, што яна зьвярталася да Язэпа штодня, а ён ня слухаў яе, каб легчы каля яе, і быць з ёю. ");
INSERT INTO beln_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","I сталася аднаго дня, і ён увайшоў у дом рабіць працу сваю, і нікога з людзей дому не было там у доме. ");
INSERT INTO beln_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","I яна схапіла яго за адзеньне ягонае, кажучы: “Ляж са мною”. Але ён пакінуў адзеньне сваё ў руцэ ейнай, і ўцёк, і выйшаў навонкі. ");
INSERT INTO beln_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","I сталася, калі яна ўбачыла, што ён пакінуў адзеньне сваё ў руцэ ейнай і выбег навонкі, ");
INSERT INTO beln_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","яна паклікала людзей дому свайго, і сказала ім, кажучы: “Гляньце, прывялі да нас Гебрая, каб ён сваволіў у нас. Ён прышоў да мяне, каб легчы са мною, і я закрычала голасам вялікім. ");
INSERT INTO beln_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","I сталася, калі ён пачуў, што я ўзьняла голас мой і закрычала, ён пакінуў адзеньне сваё ў мяне, і ўцёк, і выйшаў навонкі”. ");
INSERT INTO beln_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","I пакінула адзеньне ягонае ў сябе да прыходу гаспадара ягонага да дому свайго. ");
INSERT INTO beln_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","I гаварыла з ім гэткімі словамі, кажучы: “Прыйшоў да мяне гэты нявольнік Гебрай, якога ты прывёў да нас, каб сваволіць са мною. ");
INSERT INTO beln_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","I сталася, калі я ўзьняла голас мой і закрычала, ён пакінуў адзеньне сваё ў мяне і ўцёк навонкі”. ");
INSERT INTO beln_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","I сталася, што пачуў гаспадар ягоны словы жонкі сваёй, каторыя яна гаварыла яму, кажучы: “Гэткую рэч учыніў мне нявольнік твой!”, і ўзгарэўся гнеў ягоны. ");
INSERT INTO beln_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","I ўзяў гаспадар Язэпаў яго, і кінуў яго ў вязьніцу, месца, дзе былі ўвязьнены вязьні валадара. І быў ён там у вязьніцы. ");
INSERT INTO beln_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","I быў ГОСПАД з Язэпам, і зьявіў да яго міласэрнасьць, і даў ласку яму ў вачах начальніка вязьніцы. ");
INSERT INTO beln_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","I аддаў начальнік вязьніцы ў руку Язэпу ўсіх вязьняў, якія былі ў вязьніцы, і ўсё, што там рабілі, ён рабіў. ");
INSERT INTO beln_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Не пільнаваў начальнік вязьніцы нічога, што было у руках ягоных, бо ГОСПАД быў з ім, і ў тым, што ён рабіў, ГОСПАД даваў посьпех. ");
INSERT INTO beln_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","І сталася пасьля гэтых падзеяў, зграшылі чашнік валадара Эгіпецкага і пекар перад панам сваім, перад валадаром Эгіпецкім. ");
INSERT INTO beln_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","I загневаўся фараон на двух урадоўцаў сваіх, на начальніка чашнікаў і на начальніка пекараў, ");
INSERT INTO beln_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","і аддаў іх пад варту ў дом начальніка варты, у вязьніцу, месца, дзе Язэп быў вязьнем. ");
INSERT INTO beln_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","I прызначыў начальнік варты Язэпа да іх, і ён служыў ім. I былі яны шмат дзён пад вартаю. ");
INSERT INTO beln_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","I сьнілі ў адну ноч яны абодва кожны свой сон, кожны сьніў са значэньнем сон свой, чашнік і пекар, якія былі ў валадара Эгіпецкага і якія былі ўвязьненыя ў вязьніцы. ");
INSERT INTO beln_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","I прыйшоў да іх Язэп раніцай, і ўбачыў іх, і вось, яны засмучаныя. ");
INSERT INTO beln_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I спытаўся ён у ўрадоўцаў фараона, што былі пад вартаю з ім у доме пана ягонага, кажучы: “Чаму абліччы вашыя сёньня маюць благі выгляд?” ");
INSERT INTO beln_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I сказалі яны яму: “Сьнілі мы сон, а растлумачыць яго няма каму”. I сказаў ім Язэп: “Ці ж ня ў Бога тлумачэньне сну? Распавядзіце мне”. ");
INSERT INTO beln_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","I распавёў начальнік чашнікаў сон свой Язэпу, і сказаў яму: “У маім сьне, вось, вінаградная лаза перада мною. ");
INSERT INTO beln_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","I на вінаграднай лазе — тры галінкі. І яна, калі вырасла, разквітнела квеценьню сваёй, насьпелі гронкі вінаграду ейнага. ");
INSERT INTO beln_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I келіх фараона ў руцэ маёй, і я ўзяў вінаградныя ягады, і выціснуў іх у келіх фараона, і даў келіх ў рукі фараона”. ");
INSERT INTO beln_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","I сказаў яму Язэп: “Гэта тлумачэньне яго: тры галінкі — гэта тры дні. ");
INSERT INTO beln_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Праз тры дні падніме фараон галаву тваю, і верне цябе на месца тваё, і ты будзеш даваць келіх фараону ў руку ягоную паводле ранейшага звычаю, калі ты быў чашнікам ягоным. ");
INSERT INTO beln_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Толькі ўзгадай пра мяне, калі будзе табе добра; і зьяві мне міласэрнасьць, узгадай пра мяне перад фараонам, і вывядзі мяне з гэтага дому, ");
INSERT INTO beln_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","бо я крадзьма ўкрадзены з зямлі Гебраяў, і таксама тут нічога не зрабіў, за што б пасадзіць мяне ў вязьніцу”. ");
INSERT INTO beln_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","I ўбачыў начальнік пекараў, што ён добра патлумачыў, і сказаў Язэпу: “Я таксама сьніў, і вось, тры кашы плеценыя на галаве маёй. ");
INSERT INTO beln_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I ў кашы верхнім — усялякая ежа фараона, вырабленая пекарам; і птушкі елі яе з каша на галаве маёй”. ");
INSERT INTO beln_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","I адказаў Язэп, і сказаў: “Гэта тлумачэньне яго: тры кашы — гэта тры дні. ");
INSERT INTO beln_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Праз тры дні падніме фараон галаву з цябе, і павесіць цябе на дрэве; і птушкі будуць есьці цела тваё з цябе”. ");
INSERT INTO beln_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","I стаўся на трэйці дзень дзень нараджэньня фараона, і ён справіў бяседу для ўсіх слугаў сваімх, і падняў галаву начальніка чашнікаў і галаву начальніка пекараў сярод слугаў сваіх, ");
INSERT INTO beln_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","I вярнуў начальніка чашнікаў на ягонае месца чашніка, і ён даў келіх ў руку фараону. ");
INSERT INTO beln_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","А начальніка пекараў павесіў, як патлумачыў ім Язэп. ");
INSERT INTO beln_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","I не ўзгадаў начальнік чашнікаў пра Язэпа, і забыўся пра яго. ");
INSERT INTO beln_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","I сталася, што мінула два гады часу, і сьніў фараон, і вось, ён стаіць каля ракі. ");
INSERT INTO beln_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","I вось, з ракі выходзіць сем кароваў прыгожых з выгляду і сытых целам; і пасьвіліся на поплаве. ");
INSERT INTO beln_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","I вось, сем іншых кароваў выходзіць за імі з ракі, брыдкіх з выгляду і худых целам, і сталі каля тых кароваў на беразе ракі. ");
INSERT INTO beln_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","I пажэрлі каровы брыдкія з выгляду і худыя целам сем кароваў прыгожых з выгляду і сытых. I прачнуўся фараон, ");
INSERT INTO beln_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I заснуў, і сьніў ён другі раз, і вось, сем каласоў вырасьлі на адным сьцябле, здаровых і добрых. ");
INSERT INTO beln_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","I вось, сем каласоў пустых і высушаных усходнім ветрам вырастуаюць пасьля іх. ");
INSERT INTO beln_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","I праглынулі каласы пустыя сем каласоў здаровых і поўных. I прачнуўся фараон, і вось, гэта сон. ");
INSERT INTO beln_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","I сталася раніцаю, што быў стрывожаны дух ягоны, і ён паслаў, і паклікаў усіх варажбітоў Эгіпту і ўсіх мудрацоў яго, і распавёў ім фараон сон свой; і не было нікога, хто б патлумачыў яго фараону. ");
INSERT INTO beln_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","I прамовіў начальнік чашнікаў фараону, кажучы: “Грахі мае ўзгадваю я сёньня. ");
INSERT INTO beln_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Фараон загневаўся на слугаў сваіх і аддаў мяне пад нагляд у дом начальніка варты, мяне і начальніка пекараў. ");
INSERT INTO beln_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","I мы сьнілі сон у адну ноч, я і ён, кожны са значэньнем сон свой мы сьнілі. ");
INSERT INTO beln_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","I быў там з намі юнак Гебрай, нявольнік начальніка варты. I мы распавялі яму, і ён патлумачыў нам сны нашыя, кажнаму ягоны сон патлумачыў. ");
INSERT INTO beln_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","I сталася, як ён патлумачыў нам, так і сталася: мяне вярнулі на становішча мае, а таго павесілі”. ");
INSERT INTO beln_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","I паслаў фараон, і паклікаў Язэпа; і хутка вывялі яго з лёху. I ён пагаліўся, і зьмяніў адзеньне сваё, і прыйшоў да фараона. ");
INSERT INTO beln_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","I сказаў фараон Язэпу: “Я сьніў сон, і няма нікога, хто б патлумачыў яго. І я чуў, што пра цябе кажуць, што ты, выслухаўшы сон, тлумачыш яго”. ");
INSERT INTO beln_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","I адказаў Язэп фараону, кажучы: “Ня я, але Бог можа адкажа на супакой фараону”. ");
INSERT INTO beln_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","I сказаў фараон Язэпу: “У маім сьне, вось, стаю я на беразе ракі. ");
INSERT INTO beln_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","I вось, з ракі выходзіць сем кароваў сытых целам і прыгожых з выгляду, і пасьвіліся яны на поплаве. ");
INSERT INTO beln_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","I вось, сем кароваў іншых выходзяць пасьля іх, непафарэмныя, вельмі брыдкія з выгляду і худыя целам, я ня бачыў падобных, што да брыдкасьці, у-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","I пажэрлі каровы худыя і брыдкія сем кароваў першых сытых. ");
INSERT INTO beln_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","I ўвайшлі яны ў чэравы іхныя, і не было пазнаць, што яны ўвайшлі ў чэравы іхныя, і выгляд іхні быў паганы, як і спачатку. I я прачнуўся. ");
INSERT INTO beln_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I ўбачыў я ў сьне, і вось, сем каласоў вырастаюць на адным сьцябле, поўных і добрых. ");
INSERT INTO beln_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","I вось, сем каласоў ценькіх, пустых і высушаных усходнім ветрам растуць пасьля іх. ");
INSERT INTO beln_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I праглынулі каласы пустыя сем каласоў добрых. Я расказаў гэта варажбітам, але няма нікога, хто б патлумачыў гэта мне”. ");
INSERT INTO beln_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","I сказаў Язэп фараону: “Сон фараона — адзін ён. Што Бог зробіць, Ён паведаміў фараону. ");
INSERT INTO beln_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Сем кароваў добрых — гэта сем гадоў; і сем тых каласоў добрых — гэта сем гадоў. Гэта сон адзін. ");
INSERT INTO beln_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","I сем кароваў худых і брыдкіх, якія выйшлі пасьля іх — гэта сем гадоў; і сем каласоў пустых, высушаных усходнім ветрам — гэта будзе сем гадоў голаду. ");
INSERT INTO beln_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Гэта слова, якое я прамовіў да фараона. Што Бог зробіць, Ён паказаў фараону. ");
INSERT INTO beln_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Вось, сем гадоў прыйдзе вялікага дабрабыту ў-ва ўсёй зямлі эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","I настануць пасьля іх сем гадоў голаду; і забудзецца ўвесь той дабрабыт у зямлі Эгіпецкай, і вынішчыць голад гэтую зямлю. ");
INSERT INTO beln_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","I ня будзе відно дабрабыту у зямлі з прычыны голаду, які будзе пасьля, бо будзе ён вельмі цяжкі. ");
INSERT INTO beln_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","А тое, што паўтарыўся гэты сон фараону двойчы, азначае, што вызначана гэта справа ў Бога і неўзабаве Бог зьдзейсьніць гэта. ");
INSERT INTO beln_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","I цяпер няхай прыгледзіць фараон мужа кемлівага і мудрага, і няхай паставіць яго над зямлёю Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Няхай зробіць фараон, і прызначыць наглядчыкаў над краем, і зьбірае пятую частку ўраджаю з зямлі Эгіпецкае ў сем гадоў дабрабыту. ");
INSERT INTO beln_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","I зьбяруць усякае харчаваньне падчас гэтых добрых гадоў, якія надыйдуць, і няхай зьбіраюць збожжа пад руку фараона на харчаваньне ў гарадах, і няхай захоўваюць. ");
INSERT INTO beln_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","I будзе гэтае харчаваньне на запас зямлі на сем гадоў голаду”. ");
INSERT INTO beln_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","I добрае было гэтае слова ў вачах фараона і ў вачах усіх слугаў ягоных. ");
INSERT INTO beln_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","I сказаў фараон слугам сваім: “Ці знойдзецца такі чалавек, як гэты, які мае ў сабе Духа Божага?” ");
INSERT INTO beln_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","I сказаў фараон Язэпу: “Пасьля таго, як Бог паведаміў табе ўсё гэта, няма нікога такога кемлівага і мудрага, як ты. ");
INSERT INTO beln_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ты будзеш над домам маім, і вуснаў тваіх будзе слухацца ўвесь народ мой; толькі пасадам я буду перавышаць цябе”. ");
INSERT INTO beln_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","I сказаў фараон Язэпу: “Глядзі, я паставіў цябе над усёю зямлёю Эгіпецкаю”. ");
INSERT INTO beln_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","I зьняў фараон пярсьцёнак свой з рукі сваёй, і даў яго на руку Язэпу; і апрануў яго ў адзеньне з вісону, і ўзлажыў ланцуг залаты на шыю ягоную; ");
INSERT INTO beln_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","I загадаў вазіць яго на другой калясьніцы сваёй, і крычалі перад ім: “Кланяйцеся!” I паставіў яго над усёй зямлёю Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","I сказаў фараон Язэпу: “Я — фараон, але без цябе ніхто не падніме рукі сваёй і нагі сваёй ў-ва ўсёй зямлі Эгіпецкай”. ");
INSERT INTO beln_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","I назваў фараон імя Язэпава: Цафнат-Панэах, і даў яму за жонку Аснат, дачку Паты-Пэра, сьвятара з Ону. I узьняўся Язэп над зямлёю Эгіпецкаю. ");
INSERT INTO beln_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Язэпу было трыццаць гадоў, калі ён стаў перад фараонам, валадаром Эгіпту. I выйшаў Язэп ад аблічча фараона, і прайшоў па ўсёй зямлі Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","I выдала зямля ў сем гадоў дабрабыту поўныя жмані збожжа. ");
INSERT INTO beln_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","I зьбіраў ён усякае харчаваньне тых сямі гадоў, якія былі ў зямлі Эгіпецкай, і разьмясьціў харчаваньне ў гарадах; харчаваньне з вакалічных палёў гораду ён складаў у кожным з іх. ");
INSERT INTO beln_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","I сабіраў Язэп збожжа, як пяску марскога, так шмат, ажно перасталі лічыць, бо не было яму ліку. ");
INSERT INTO beln_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","I ў Язэпа нарадзіліся два сыны перш, чым прыйшоў год голаду, якіх нарадзіла яму Аснат, дачка Паты-Пэра, сьвятара з Ону. ");
INSERT INTO beln_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","I назваў Язэп імя першароднага Манаса, бо казаў: “Даў мне Бог забыцца ўсе цяжкасьці мае і ўвесь дом бацькі майго”. ");
INSERT INTO beln_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","А імя другога назваў Эфраім, бо казаў: распладзіў мяне Бог у зямлі нядолі маёй”. ");
INSERT INTO beln_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","I мінулі сем гадоў дабрабыту, які быў у зямлі Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","I пачалі сем гадоў голаду прыходзіць, як сказаў Язэп. I быў голад ва ўсіх краінах, але ў-ва ўсёй зямлі Эгіпецкай быў хлеб. ");
INSERT INTO beln_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","I галадавала ўся зямля Эгіпецкая, і крычаў народ да фараона пра хлеб, і сказаў фараон усім Эгіпцянам: “Ідзіце да Язэпа і рабіце, што ён вам скажа”. ");
INSERT INTO beln_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","I быў голад на ўсім абліччы зямлі, і адчыніў Язэп усе гумны, якія былі ў іх, і прадаваў Эгіпцянам. I павялічваўся голад ў зямлі Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","I з ўсёй зямлі прыходзілі ў Эгіпет купляць у Язэпа, бо павялічваўся голад па ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","I ўбачыў Якуб, што ёсьць збожжа ў Эгіпце, і сказаў Якуб сынам сваім: “Што вы паглядаеце адзін на аднаго?” ");
INSERT INTO beln_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I сказаў: “Вось, я чуў, што ёсьць збожжа ў Эгіпце. Зыйдзіце туды і купіце для нас там, і будзем жыць, і не памрэм”. ");
INSERT INTO beln_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","I зыйшлі дзесяць братоў Язэпавых купіць збожжа ў Эгіпце. ");
INSERT INTO beln_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","А Бэн’яміна, брата Язэпа, не паслаў Якуб з братамі ягонымі, бо сказаў: “Каб не здарылася з ім няшчасьце”. ");
INSERT INTO beln_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","I прыйшлі сыны Ізраіля купляць збожжа разам з тымі, што прыйшлі туды, бо быў голад у зямлі Ханаан. ");
INSERT INTO beln_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","А Язэп кіраваў у той зямлі, ён продаў збожжа ўсім людзям зямлі. I прыйшлі браты Язэпа, і пакланіліся яму тварам да зямлі. ");
INSERT INTO beln_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","I ўбачыў Язэп братоў сваіх, і пазнаў іх, і ўдаваў, што ён чужым ім, і размаўляў з імі сувора, і сказаў ім: “Адкуль вы прыйшлі?” I яны сказалі: “З зямлі Ханаан, каб купіць харчоў”. ");
INSERT INTO beln_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","I пазнаў Язэп братоў сваіх, а яны не пазналі яго. ");
INSERT INTO beln_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","I ўзгадаў Язэп сны, якія ён сьніў пра іх, і сказаў ім: “Шпегі вы, вы прыйшлі, каб агледзець голасьць зямлі гэтай”. ");
INSERT INTO beln_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","I сказалі яны яму: “Не, пане; і слугі твае прыйшлі купіць харчаваньне. ");
INSERT INTO beln_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Усе мы — сыны аднаго чалавека, шчырыя мы. Не былі слугі твае шпегамі”. ");
INSERT INTO beln_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Але ён сказаў ім: “Не, бо вы прыйшлі агледзець голасьць зямлі гэтай”. ");
INSERT INTO beln_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","А яны сказалі: “Дванаццаць слугаў тваіх, браты мы. Мы — сыны аднаго чалавека ў зямлі Ханаан, і вось, наймалодшы сёньня з бацькам нашым, а аднаго няма”. ");
INSERT INTO beln_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","I сказау ім Язэп: “Гэта я сказаў вам, кажучы: ‘Вы — шпегі’. ");
INSERT INTO beln_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Таму будзеце выспрабаваныя. Няхай жыве фараон! Вы ня выйдзеце адгэтуль, пакуль ня прыйдзе сюды наймалодшы брат ваш. ");
INSERT INTO beln_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Пашліце аднаго з вас, і няхай ён возьме брата вашага; а вы будзеце ўвязьнены. I выспрабуюцца словы вашыя, ці праўда ваша. А калі не, няхай жыве фараон! Вы — шпегі”. ");
INSERT INTO beln_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","I ўзяў іх пад варту на тры дні. ");
INSERT INTO beln_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","I сказаў ім Язэп на трэйці дзень: “Гэта зрабіце, і будзеце жывыя. Бо я баюся Бога. ");
INSERT INTO beln_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Калі вы — шчырыя, адзін брат ваш застанецца ўвязьнены ў доме, у якім вы пад вартаю, а вы ідзіце, занясіце збожжа дзеля заспакаеньня голаду дамоў вашых. ");
INSERT INTO beln_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","I брата вашага малодшага прывядзіце да мяне, і спраўдзяцца словы вашыя, і вы не памраце”. I яны зрабілі так. ");
INSERT INTO beln_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","I казалі яны кожны брату свайму: “Сапраўды, мы вінаватыя адносна брата нашага, што мы бачылі гора душы ягонае, як ён маліў нас, але мы не паслухалі, і за тое прыйшла на нас бяда гэтая”. ");
INSERT INTO beln_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","I адказаў ім Рубэн, кажучы: “Ці не казаў я вам, кажучы: ‘Не грашыце супраць хлопца’, і не паслухалі вы; і вось, кроў ягоная помсьціцца”. ");
INSERT INTO beln_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","І яны ня ведалі, што Язэп разумее, бо паміж імі быў перакладчык. ");
INSERT INTO beln_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I адвярнуўся ад іх, і плакаў. I павярнуўся да іх, і размаўляў з імі, і ўзяў з іх Сымона, і зьвязаў яго перад вачыма іхнімі. ");
INSERT INTO beln_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","I загадаў Язэп, каб напоўнілі мяхі іхнія збожжам, і вярнулі срэбра іхняе кожнаму ў мех ягоны, і далі ім ежу на дарогу. I зрабілі ім гэтак. ");
INSERT INTO beln_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","І яны ўсклалі збожжа сваё на аслоў сваіх, і пайшлі адтуль. ");
INSERT INTO beln_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","I разьвязаў адзін з іх мех свой, каб пакарміць асла свайго на папасе; і ўбачыў срэбра сваё, і вось, яно ў адтуліне мяха ягонага. ");
INSERT INTO beln_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I сказаў ён братам сваім: “Вярнулі срэбра маё, і вось, яно ў мяху маім”. I затрывожылася сэрца іхняе, і яны задрыжэлі, кажучы адзін аднаму: “Што гэта зрабіў нам Бог?” ");
INSERT INTO beln_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","I прыйшлі яны да Якуба, бацькі свайго, ў зямлю Ханаан, і распавялі яму ўсё, што здарылася з імі, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Гаварыў гэты чалавек, пан зямлі той, з намі сувора, і меў нас за шпегаў у зямлі той. ");
INSERT INTO beln_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","I сказалі мы яму: “Шчырыя мы, мы не былі шпегамі. ");
INSERT INTO beln_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Нас дванаццаць братоў, сыны бацькі нашага; аднаго няма, а малодшы сёньня з бацькам нашым у зямлі Ханаанскай”. ");
INSERT INTO beln_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","I сказаў гэты чалавек, пан зямлі той: “З гэтага я даведаюся, што вы шчырыя: аднаго брата вашага пакіньце ў мяне, а вы вазьміце збожжа дзеля заспакаеньня голаду дамоў вашых і ідзіце. ");
INSERT INTO beln_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","I прывядзіце да мяне малодшага брата вашага; і я даведаюся, што вы ня шпегі, але шчырыя вы. Брата вашага аддам вам, і вы будзеце падарожнічаць у зямлі гэтай”. ");
INSERT INTO beln_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","I сталася, калі яны высыпалі мяхі свае, вось, у кожнага капшук са срэбрам ягоным ў мяху ягоным. I ўбачылі яны капшукі са срэбрам сваім, яны і бацька іхні, і спалохаліся. ");
INSERT INTO beln_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","I сказаў ім Якуб, бацька іхні: “Вы пазбавілі мяне дзяцей. Язэпа няма; і Сымона няма, і Бэн’яміна хочаце ўзяць. Усё гэта на мяне прыйшло!” ");
INSERT INTO beln_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","I сказаў Рубіэн бацьку свайму: “Забі двух сыноў маіх, калі я не прывяду яго да цябе. Аддай яго ў рукі мае, і я вярну яго табе”. ");
INSERT INTO beln_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","А ён сказаў: “Ня зыйдзе сын мой з вамі; бо брат ягоны памёр, і ён адзін застаўся! Калі здарыцца з ім няшчасьце ў дарозе, у якую вы пойдзеце, вы зьвядзеце сівізну маю са смуткам у апраметную”. ");
INSERT INTO beln_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","А голад цяжыў на зямлі. ");
INSERT INTO beln_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","I сталася, што яны скончылі есьці збожжа, якое прывезьлі з Эгіпту, і сказаў ім бацька іхні: “Вярніцеся, купіце нам трохі харчаваньня”. ");
INSERT INTO beln_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","I сказаў яму Юда, кажучы: “Той чалавек сувора папярэдзіў нас, кажучы: ‘Ня ўбачыце аблічча майго, калі ня будзе брат ваш з вамі’. ");
INSERT INTO beln_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Калі згаджаешся паслаць брата нашага з намі, зыйдзем і купім табе харчаваньне. ");
INSERT INTO beln_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","А калі не пашлеш, ня зыйдзем, бо той чалавек сказаў нам: ‘Ня ўбачыце аблічча майго, калі ня будзе брат ваш з вамі’”. ");
INSERT INTO beln_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","I сказаў Ізраіль: “Навошта вы зрабілі мне ліха, сказаўшы таму чалавеку, што ў вас ёсьць яшчэ брат?” ");
INSERT INTO beln_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","І сказалі яны: «Пытаючыся, распытаваў гэты чалавек пра нас, пра сям’ю нашую, кажучы: ‘Ці яшчэ бацька ваш жыўвы? Ці ёсьць у вас брат?’ І мы адказвалі яму паводле гэтых словаў. Ці маглі мы ведаць, што ён скажа: ‘Прывядзіце брата вашага’». ");
INSERT INTO beln_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","I сказаў Юда Ізраілю, бацьку свайму: “Пашлі гэтага хлопца са мною; і мы ўстанем, і пойдзем, і будзем жыць, і не памром, і мы, і ты, і дзеці нашыя. ");
INSERT INTO beln_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Я паручаюся за яго, з рукі маёй будзеш вымагаць яго. Калі я не прывяду яго да цябе і не пастаўлю перад абліччам тваім, буду я грэшны перад табою на ўсё жыцьцё. ");
INSERT INTO beln_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Бо калі б мы не затрымліваліся, дык цяпер мы б ужо вярнуліся двойчы”. ");
INSERT INTO beln_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","I сказаў ім Ізраіль, бацька іхні: “Калі так, тады зрабіце вось што: вазьміце пладоў зямлі ў мяхі вашыя і занясіце гэтаму чалавеку дар, трохі бальзаму, і трохі мёду, і пахнідлы, і ладан, і фісташкі, і мігдалы. ");
INSERT INTO beln_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","I срэбра падвойна вазьміце ў рукі вашыя, і срэбра, якое назад паложана ў адтуліны мяхоў вашых, вярніце рукамі сваімі, можа, гэта памылка. ");
INSERT INTO beln_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","I брата вашага бярыце, і, устаўшы, вярніцеся да чалавека таго. ");
INSERT INTO beln_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","А Бог Усемагутны няхай дасьць вам ласку перад абліччам таго чалавека, і ён выпусьціць вам другога брата вашага і Бэн’яміна. А я, калі маю пазбыцца дзяцей, пазбудуся”. ");
INSERT INTO beln_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","I ўзялі мужы гэтыя дары свае, і срэбра падвойнае ўзялі ў рукі свае, і Бэн’яміна, і ўсталі, і зыйшлі ў Эгіпет, і сталі перад Язэпам. ");
INSERT INTO beln_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","I ўбачыў Язэп з імі Бэн’яміна, і сказаў загадчыку дому свайго: “Увядзі гэтых мужоў у дом, і зарэж, што можна зарэзаць, і прыгатуй, бо са мною будуць есьці гэтыя мужы апоўдні”. ");
INSERT INTO beln_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","I зрабіў той чалавек так, як сказаў Язэп, і ўвёў той чалавек мужоў гэтых у дом Язэпа. ");
INSERT INTO beln_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","I баяліся мужы гэтыя, што прывялі іх у дом Язэпа, і казалі: “Гэта з прычыны срэбра, вернутага ўперад у мяхі нашыя, прывялі нас, каб накінуцца на нас, і напасьці на нас, і ўзяць у няволю нас, і аслоў нашых”. ");
INSERT INTO beln_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","I наблізіліся яны да чалавека, які быў над домам Язэпа, і гаварылі з ім ля ўваходу ў дом, ");
INSERT INTO beln_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","і сказалі: “Паслухай, пане мой! Прыыходзячы, прыходзілі мы сюды ўперад купіць харчаваньне. ");
INSERT INTO beln_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","I сталася, як мы прыйшлі на папас, і разьвязалі мяхі свае, і вось, срэбра кожнага ў адтуліне мяха ягонага, срэбра нашае паводле вагі сваёй, і мы вяртаем яго рукамі сваімі. ");
INSERT INTO beln_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","I срэбра іншае мы прынесьлі ў руках сваіх, каб купіць харчаваньне. Мы ня ведаем, хто паклаў срэбра нашае ў мяхі нашыя”. ");
INSERT INTO beln_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","А ён сказаў: “Супакой вам! Ня бойцеся! Бог ваш і Бог бацькі вашага даў вам скарб у мяхах вашых. Вашае срэбра прыйшло да мяне”. I вывеў да іх Сымона. ");
INSERT INTO beln_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","I ўвёў чалавек той мужоў гэтых у дом Язэпа, і даў вады, і яны абмылі ногі свае; і даў корм аслам іхнім. ");
INSERT INTO beln_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","I яны прыгатавалі дары да прыходу Язэпа апоўдні, бо чулі, што там яны будуць есьці хлеб. ");
INSERT INTO beln_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","I прыйшоў Язэп у дом, і яны прынесьлі яму ў дом дары, якія ў руках іхніх, і пакланіліся яму да зямлі. ");
INSERT INTO beln_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","І ён спытаўся ў іх пра супакой, і сказаў: “Ці добра маецца бацька ваш стары, пра якога вы распавядалі? Ці ён яшчэ жыве?” ");
INSERT INTO beln_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","I сказалі яны: “Мае супакой слуга твой, бацька наш, ён яшчэ жыве”. I схіліліся, і, пакланяючыся, пакланіліся. ");
INSERT INTO beln_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","I ўзьняў ён вочы свае, і ўбачыў Бэн’яміна, брата свайго, сына маці сваёй, і сказаў: “Ці гэта брат ваш наймалодшы, пра якога вы распавядалі мне?” I сказаў: “Бог няхай зьмілуецца над табою, сыне мой”. ");
INSERT INTO beln_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","I хутка выйшаў Язэп, бо ўзгарэліся пачуцьці ягоныя да брата ягонага, і ён шукаў месца, каб плакаць; і ўвайшоў у пакой, і плакаў там. ");
INSERT INTO beln_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I абмыў ён аблічча сваё, і выйшаў, і апаваў сябе, і сказаў: “Пастаўце хлеб”. ");
INSERT INTO beln_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","I паставілі яму асобна, і ім асобна, і Эгіпцянам, якія елі з ім, асобна, бо Эгіпцяне ня могуць есьці з Гебраямі хлеб, бо гэта агіда для Эгіпту. ");
INSERT INTO beln_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I селі яны перад ім, першародны паводле першароднасьці сваёй, і наймалодшы паводле маладосьці сваёй, і зьдзіўляліся гэтыя мужы, гледзячы адзін на аднаго. ");
INSERT INTO beln_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","I падалі стравы ад яго аблічча для іх. I была страва для Бэн’яміна большая, чым стравы кажнага з іх у пяць разоў. I яны пілі, і ўпіліся з ім. ");
INSERT INTO beln_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","I загадаў Язэп загадчыку дому свайго, кажучы: “Напоўні мяхі гэтых мужоў харчамі, колькі яны могуць несьці, і палажы срэбра кожнага ў адтуліну мяха ягонага; ");
INSERT INTO beln_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","А келіх мой, келіх срэбны, палажы ў адтуліну мяха наймалодшага, і срэбра за збожжа ягонае”. I ён зрабіў паводле слова Язэпа, якое той сказаў. ");
INSERT INTO beln_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Раніцаю разьвіднела, і гэтых мужоў выправілі, іх і аслоў іхніх. ");
INSERT INTO beln_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Яны выйшлі з гораду, не адыйшлі далёка, і Язэп сказаў загадчыку дому свайго: “Устань, ганіся за тымі людзьмі, і дагоніш іх, і скажаш ім: ‘Чаму вы адплацілі ліхам за дабро? ");
INSERT INTO beln_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ці ж ня гэта той келіх, з якога п’е пан мой, і прадказваючы, прадказвае на ім? Ліха вы ўчынілі, гэтак зрабіўшы’”. ");
INSERT INTO beln_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","І ён дагнаў іх і прамовіў ім гэтыя словы. ");
INSERT INTO beln_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","А яны сказалі: “Навошта пане мой кажа такія словы? Далёкія слугі твае, каб ўчыніць гэткія рэчы. ");
INSERT INTO beln_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Тое срэбра, якое мы знайшлі ў адтулінах мяхоў сваіх, мы зьвярнулі табе з зямлі Ханаан. Як жа мелі мы красьці з дому гаспадара твайго срэбра альбо золата? ");
INSERT INTO beln_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","У каго са слугаў тваіх будзе знойдзена гэта, той няхай памрэ, а мы таксама станем нявольнікамі пана майго”. ");
INSERT INTO beln_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","І ён сказаў: “Дык цяпер няхай будзе паводле словаў вашых. У каго будзе знойдзена гэта, той стане мне нявольнікам, а вы будзеце нявінныя”. ");
INSERT INTO beln_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","І яны пасьпяшаліся, і зьнялі кожны мех свой на зямлю, і разьвязалі кожны мех свой. ");
INSERT INTO beln_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","А ён шукаў, пачаў ад найстарэйшага і скончыў наймалодшым; і знайшоў келіх ў мяху Бэн’яміна. ");
INSERT INTO beln_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","I разарвалі яны адзеньні свае, і ўсклалі мяхі кожны на асла свайго, і вярнуліся ў горад. ");
INSERT INTO beln_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","I прыйшлі Юда і браты ягоныя ў дом Язэпа, і ён яшчэ быў там, і ўпалі перад абліччам яго на зямлю. ");
INSERT INTO beln_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","I сказаў ім Язэп: “Што за ўчынак гэта вы ўчынілі? Ці ж вы ня ведалі, што, прадказваючы, прадказвае такі чалавек, як я?” ");
INSERT INTO beln_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","I сказаў Юда: “Што нам сказаць, пане мой? Што нам гаварыць і як нам апраўдвацца? Бог знайшоў правіну слугаў тваіх. Вось, мы — нявольнікі пана майго, і мы, і той, у чыіх руках быў знойдзены келіх”. ");
INSERT INTO beln_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","I сказаў Язэп: “Далёка ад мяне, каб я ўчыніў гэта. Той чалавек, у руках якога знойдзены келіх, ён будзе маім нявольнікам, а вы ўзыходзьце ў супакою да бацькі свайго”. ");
INSERT INTO beln_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","I наблізіўся да яго Юда, і сказаў: “Паслухай, пане мой, няхай скажа, прашу, слуга твой слова ў вушы пана свайго, і няхай не распальваецца гнеў твой на слугу твайго, бо ты — як сам фараон. ");
INSERT INTO beln_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Пан мой пытаўся ў слугаў сваіх, кажучы: ‘Ці ёсьць у вас бацька альбо брат?’ ");
INSERT INTO beln_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","І мы сказалі пану нашаму: ‘Ёсьць у нас бацька стары і дзіця старасьці ягонае малое, а брат ягоны памёр, і ён адзін застаўся па маці сваёй, і бацька ягоны любіць яго’. ");
INSERT INTO beln_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","I ты сказаў слугам тваім: ‘Прывядзіце яго да мяне, і я зьвярну вока маё на яго’. ");
INSERT INTO beln_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","І мы сказалі пану майму: ‘Ня можа хлопец пакінуць бацьку свайго; і калі ён пакіне бацьку свайго, дык той памрэ’. ");
INSERT INTO beln_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","I сказаў ты слугам тваім: ‘Калі ня прыйдзе брат ваш наймалодшы з вамі, не дазволю вам больш бачыць аблічча маё’. ");
INSERT INTO beln_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","I сталася, што мы ўзыйшлі да слугі твайго, бацькі майго, і пераказалі яму словы пана майго. ");
INSERT INTO beln_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","I сказаў бацька наш: ‘Вярніцеся, купіце нам трохі харчаваньня’. ");
INSERT INTO beln_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","I мы сказалі: ‘Ня можам зыйсьці. Калі будзе з намі брат наш наймалодшы, мы зыйдзем, бо ня зможам убачыць аблічча таго чалавека, калі брата нашага наймалодшага ня будзе з намі’. ");
INSERT INTO beln_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I сказаў нам слуга твой, бацька наш: ‘Вы ведаеце, што двух нарадзіла мне жонка мая. ");
INSERT INTO beln_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","I адыйшоў адзін ад мяне, і я сказаў: ‘Напэўна, ён разьдзёрты дзікім зьверам’, і я ня бачыў яго дагэтуль. ");
INSERT INTO beln_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","І возьмеце таксама гэтага ад аблічча майго, і здарыцца з ім няшчасьце, і завядзіцё вы сівізну маю у горы ў апраметную’. ");
INSERT INTO beln_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","І цяпер, як я прыйду да слугі тваго, бацькі майго, і хлопца няма з намі, а душа ягоная прывязана да душы ягонай. ");
INSERT INTO beln_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","I станецца, што ён убачыць, што няма хлапца, і памрэ, і зьвядуць слугі твае сівізну слугі твайго, бацькі нашага, са смуткам у апраметную. ");
INSERT INTO beln_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Бо слуга твой паручыўся за хлопца перад бацькам ім, кажучы: ‘Калі не прывяду яго да цябе, буду грэшны перад бацькам сваім на ўсе дні’. ");
INSERT INTO beln_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","I цяпер, прашу, няхай застанецца слуга твой замест хлопца нявольнікам пана майго, а хлопец няхай пойдзе з братамі сваімі. ");
INSERT INTO beln_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Бо як я прыйду да бацькі майго, а хлопца ня будзе са мною? Няхай ня ўбачу я ліха, якое спаткае бацька мой”. ");
INSERT INTO beln_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","I ня мог Язэп больш вытрываць пры ўсіх, што стаялі каля яго, і закрычаў: “Вывядзіце ўсіх людзей ад мяне!” I не застаўся ніхто пры ім, калі Язэп адкрыўся братам сваім. ");
INSERT INTO beln_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I голасна заплакаў, і пачулі Эгіпцяне, і пачуў дом фараона. ");
INSERT INTO beln_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I сказаў Язэп братам сваім: “Я — Язэп! Ці бацька мой яшчэ жывы?” I не маглі браты ягоныя адказаць яму, бо напалохаліся перад абліччам ягоным. ");
INSERT INTO beln_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","I сказаў Язэп братам сваім: “Наблізьцеся, калі ласка, да мяне”. Яны наблізіліся. І ён сказаў: “Я — Язэп, брат ваш, якога вы прадалі ў Эгіпет. ");
INSERT INTO beln_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Але цяпер не сумуйце, і няхай ня будзе жалю ў вачах вашых, што вы прадалі мяне сюды, бо дзеля захаваньня жыцьця паслаў мяне Бог перад вамі; ");
INSERT INTO beln_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Бо вось, два гады голаду на зямлі, і яшчэ пяць гадоў, у якія нельга будзе ані араць, ані жаць. ");
INSERT INTO beln_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","I паслаў мяне Бог перад вамі, каб пакінуць з вас рэшту на зямлі і захаваць жыцьцё вашае збаўленьнем вялікім. ");
INSERT INTO beln_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","I цяпер ня вы паслалі мяне сюды, але Бог, і Ён паставіў мяне як бацьку фараону і як пана ў-ва ўсім доме ягоным, і я кірую ў-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO beln_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Пасьпяшайцеся, і ўзыйдзіце да бацькі майго, і скажыце яму: “Гэтак сказаў сын твой, Язэп: “Бог паставіў мяне панам над усім Эгіптам. Прыйдзі да мяне, не марудзь. ");
INSERT INTO beln_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","I будзеш жыць у зямлі Гашэн; і будзеш блізка каля мяне, ты, і сыны твае, і сыны сыноў тваіх, і авечкі твае, і валы твае, і ўсё, што тваё. ");
INSERT INTO beln_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I я буду карміць цябе там, бо яшчэ пяць гадоў голаду, каб не згалеў ты, і дом твой, і ўсё, што тваё”. ");
INSERT INTO beln_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","I вось, бачаць вочы вашыя, і вочы брата майго Бэн’яміна, што вусны мае прамаўляюць да вас. ");
INSERT INTO beln_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","I распавядзіце бацьку майму пра ўсю славу маю ў Эгіпце і пра ўсё, што вы бачылі; і пасьпяшайцеся, і прывядзіце бацьку майго сюды”. ");
INSERT INTO beln_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","I ўпаў ён на шыю Бэн’яміну, брату свайму, і плакаў; і Бэн’ямін плакаў на шыі ягонай. ");
INSERT INTO beln_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","I цалаваў ён усіх братоў сваіх, і плакаў над імі. I потым размаўлялі з ім браты ягоныя. ");
INSERT INTO beln_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","I пачулі вестку ў доме фараона, якая казала: “Прыйшлі браты Язэпа”. І добра гэта было ў вачах фараона і ў вачах слугаў ягоных. ");
INSERT INTO beln_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","I сказаў фараон Язэпу: “Скажы братам сваім: “Зрабіце гэтак: абладуйце збожжам жывёлу сваю, і ідзіце, і прыйдзіце ў зямлю Ханаан, ");
INSERT INTO beln_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","і вазьміце бацьку свайго, і сем’і свае, і прыйдзіце да мяне; і я дам вам добрую зямлю Эгіпту, і вы будзеце есьці тлустасьць зямлі гэтай”. ");
INSERT INTO beln_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","А ты загадаеш: “Зрабіце гэтак: вазьміце сабе з зямлі Эгіпецкае вазы для дзяцей вашых і жонак вашых, і вазьміце бацьку вашага, і прыходзьце. ");
INSERT INTO beln_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","I вочы вашыя няхай не шкадуюць прыладаў вашых, бо дабро ўсёй зямлі Эгіпецкай — для вас”. ");
INSERT INTO beln_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I зрабілі так сыны Ізраіля. I даў ім Язэп вазы паводле загаду фараона, і даў ім сілкаваньня на дарогу. ");
INSERT INTO beln_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","І ўсім, кожнаму з іх, ён даў зьмену адзеньня, а Бэн’яміну даў трыста срэбнікаў і пяць зьменаў адзеньня. ");
INSERT INTO beln_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","А для бацькі свайго паслаў дзесяць аслоў, абладаваных даброцьцямі з Эгіпту, і дзесяць асьліцаў, абладаваных збожжам і хлебам, і ежаю для баьці свайго на дарогу. ");
INSERT INTO beln_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","I адаслаў ён братоў сваіх, і яны пайшлі. I сказаў ім: “Не сварыцеся ў дарозе”. ");
INSERT INTO beln_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","I ўзыйшлі яны з Эгіпту, і прыйшлі ў зямлю Ханаан да Якуба, баьці свайго. ");
INSERT INTO beln_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I паведамілі яму, кажучы: “Яшчэ жывы Язэп, і ён кіруе ў-ва ўсёй зямлі Эгіпецкай”. I не ўзварухнулася сэрца ягонае, бо ён не паверыў ім. ");
INSERT INTO beln_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","I прамовілі яму ўсе словы Язэпа, якія ён прамовіў ім, і ўбачыў ён вазы, якія прыслаў Язэп, каб прывезьці яго, і ажыў дух Якуба, бацькі іхняга. ");
INSERT INTO beln_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","I сказаў Ізраіль: “Досыць! Яшчэ жыве Язэп, сын мой! Пайду і ўбачу яго, перш, чым памру”. ");
INSERT INTO beln_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","I вырушыў Ізраіль у дарогу, і ўсё, што ў яго, і прыйшоў у Бэер-Шэву, і ахвяраваў ахвяры Богу бацькі свайго Ісаака. ");
INSERT INTO beln_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","I сказаў Бог Ізраілю ў відзежы начным, і сказаў: “Якубе! Якубе!” А ён сказаў: “Вось я”. ");
INSERT INTO beln_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I сказаў: “Я — Бог, Бог бацькі твайго! Ня бойся зыйсьці ў Эгіпет, бо Я зраблю цябе там народам вялікім. ");
INSERT INTO beln_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Я зыйду з табою ў Эгіпет, і Я, выводзячы, таксама вывяду цябе адтуль. I Язэп паложыць руку сваю на вочы твае”. ");
INSERT INTO beln_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","I падняўся Якуб з Бэер-Шэвы; і павезьлі сыны Ізраіля Якуба, бацьку свайго, і дзяцей сваіх, і жонак сваіх на вазах, якія паслаў фараон, каб прывезьці яго. ");
INSERT INTO beln_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I ўзялі яны статак свой і маёмасьць сваю, якую прыдбалі ў зямлі Ханаан, і прыйшлі ў Эгіпет Якуб і ўсё насеньне ягонае з ім. ");
INSERT INTO beln_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Сыноў сваіх і сыноў сыноў сваіх з сабою, і дочак сваіх і дочак сыноў сваіх, і ўсё насеньне сваё прывёў ён з сабою ў Эгіпет. ");
INSERT INTO beln_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","I вось імёны сыноў Ізраіля, што прыйшлі ў Эгіпет: Якуб і сыны ягоныя. Першародны Якуба Рубэн. ");
INSERT INTO beln_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","I сыны Рубэна: Ханох і Пальлю, і Хецрон, і Кармі. ");
INSERT INTO beln_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","I сыны Сымона: Емуэль і Ямін, і Агад, і Якін, і Цахар, і Шаўль, сын Хананейкі. ");
INSERT INTO beln_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","I сыны Леві: Гершон, Кегат і Мерары. ");
INSERT INTO beln_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","А сыны Юды: Ер, і Анан, і Шэля, і Пэрэс, і Зарах. І памерлі Ер і Анан у зямлі Ханаан. I былі сыны Пэрэса: Хецрон і Хамуль. ");
INSERT INTO beln_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","I сыны Ісахара: Тола і Пува, і Ёў, і Шымрон. ");
INSERT INTO beln_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","I сыны Завулёна: Сэрэд, і Элён, і Яхлеэль. ");
INSERT INTO beln_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Гэта сыны Леі, якіх яна нарадзіла Якубу ў Падан-Араме, і яшчэ Дзіну, дачку ягоную. Усіх душаў сыноў ягоных і дочак ягоных — трыццаць тры. ");
INSERT INTO beln_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","I сыны Гада: Цыф’ён і Хагі, Шуні і Эцбон, Еры і Ароды, і Ар’элі. ");
INSERT INTO beln_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","А сыны Асэра: Імна, і Ішва, і Ішві і Бэрыя, і Сэрах, сястра іхняя. А сыны Бэрыі: Хевер і Малхіэль. ");
INSERT INTO beln_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Гэта сыны Зільпы, якую даў Лаван Леі, дачцэ сваёй. Яна нарадзіла іх Якубу шаснаццаць душаў. ");
INSERT INTO beln_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Сыны Рахелі, жонкі Якуба: Язэп і Бэн’ямін. ");
INSERT INTO beln_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","I нарадзіліся ў Язэпа ў зямлі Эгіпецкай Манаса і Эфраім, якіх нарадзіла яму Аснат, дачка Паты-Пэра, сьвятара з Ону. ");
INSERT INTO beln_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","А сыны Бэн’яміна: Бела і Бэкер, і Ашбэль, Гера і Нааман, Эхі і Рош, Мупім і Хупім, і Ард. ");
INSERT INTO beln_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Гэта сыны Рахелі, якіх яна нарадзіла Якубу, усіх душаў — чатырнаццаць. ");
INSERT INTO beln_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","А сыны Дана: Хушым. ");
INSERT INTO beln_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Сыны Нэфталі: Яхцээль і Гуні, і Ецэр, і Шылем. ");
INSERT INTO beln_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Гэта сыны Більгі, якую даў Лаван дачцэ сваёй Рахелі. Яна нарадзіла іх Якубу, усіх душаў —сем. ");
INSERT INTO beln_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Усяго душаў, што прыйшлі з Якубам у Эгіпет, якія выйшлі са сьцёгнаў ягоных, акрамя жонак сыноў Якуба, усіх душаў — шэсьцьдзесят шэсьць. ");
INSERT INTO beln_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","А сыноў Язэпа, якія нарадзіліся яму ў Эгіпце, — дзьве душы. Усяго душаў з дому Якуба прыйшло ў Эгіпет семдзясят. ");
INSERT INTO beln_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","I паслаў ён Юду перад сабою да Язэпа, каб той скіраваў аблічча яго на Гашэн. I прыйшлі ў зямлю Гашэн. ");
INSERT INTO beln_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","I запрог Язэп калясьніцу сваю, і ўзыйшоў насустрач Ізраілю, бацьку свайму, у Гашэн, і паказаўся яму, і ўпаў на шыю ягоную, і плакаў на шыі ягонай зноў. ");
INSERT INTO beln_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","I сказаў Ізраіль Язэпу: “Магу паміраць я гэтым разам, як убачыў аблічча тваё, бо ты яшчэ жывы”. ");
INSERT INTO beln_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","I сказаў Язэп братам сваім і дому бацькі свайго: “Я пайду і паведамлю фараону, і скажу яму: “Браты мае і дом бацькі майго, якія былі ў зямлі Ханаан, прыйшлі да мяне. ");
INSERT INTO beln_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Гэтыя людзі — пастухі авечак, бо яны гадавалі статак. І авечак сваіх, і валоў сваіх, і ўсё, што ў іх, яны прывялі”. ");
INSERT INTO beln_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","I станецца, калі фараон пакліча вас і скажа: “Які занятак ваш?” ");
INSERT INTO beln_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","вы скажаце: “Гадавалі статак слугі твае, з маленства нашага і дагэтуль, і мы, і бацькі нашыя”, каб вы пасяліліся ў зямлі Гашэн, бо брыдзяцца Эгіпцяне кожным пастухом авечак”. ");
INSERT INTO beln_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","І прыйшоў Язэп, і паведаміў фараону, і сказаў: “Бацька мой, і браты мае, і авечкі іхнія, і валы іхнія, і ўсё, што ў іх, прыйшлі з зямлі Ханаан, і вось, яны ў зямлі Гашэн”. ");
INSERT INTO beln_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I з-паміж братоў сваіх ён узяў пяць чалавек і паставіў іх перад фараонам. ");
INSERT INTO beln_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","I сказаў фараон братам ягоным: “Які ваш занятак?” І яны сказалі фараону: “Пастухі авечак слугі твае, і мы, і бацькі нашыя”. ");
INSERT INTO beln_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","I сказалі яны фараону: “Вандраваць у зямлі гэтай мы прыйшлі, бо няма пашы для авечак слугаў тваіх, бо вялікі голад у зямлі Ханаан. І цяпер, просім, дазволь пасяліцца слугам тваім у зямлі Гашэн”. ");
INSERT INTO beln_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","I сказаў фараон Язэпу, кажучы: “Бацька твой і браты твае прыйшлі да цябе. ");
INSERT INTO beln_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Зямля Эгіпецкая перад абліччам тваім. У найлепшым месцы зямлі пасялі бацьку свайго і братоў сваіх. Няхай жывуць яны ў зямлі Гашэн. I калі ведаеш, што ёсьць паміж імі здольныя людзі, пастаў іх даглядчыкамі над статкамі, якія ў мяне”. ");
INSERT INTO beln_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","I прывёў Язэп Якуба, бацьку свайго, і паставіў яго перад абліччам фараона. І дабраславіў Якуб фараона. ");
INSERT INTO beln_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","I сказаў фараон Якубу: “Колькі дзён маюць гады жыцьця твайго?” ");
INSERT INTO beln_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","I сказаў Якуб фараону: “Дзён гадоў вандраваньня майго — сто трыццаць гадоў. Кароткія і ліхія былі дні гадоў жыцьця майго, і не дасягнулі яны да дзён гадоў жыцьця бацькоў маіх у днях вандраваньня іхняга”. ");
INSERT INTO beln_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","I дабраславіў Якуб фараона, і выйшаў ад аблічча фараона. ");
INSERT INTO beln_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","I пасяліў Язэп бацьку свайго і братоў сваіх, і даў ім уласнасьць у зямлі Эгіпецкай, у найлепшай частцы зямлі той, у зямлі Рамсэс, як загадаў фараон. ");
INSERT INTO beln_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","I жывіў Язэп бацьку свайго і братоў сваіх, і ўвесь дом бацькі свайго хлебам адпаведна ліку дзяцей. ");
INSERT INTO beln_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","А хлеба не было на ўсёй зямлі, бо голад быў вельмі цяжкі, і была вычарпаная зямля Эгіпецкая і зямля Ханаанская з прычыны голаду. ");
INSERT INTO beln_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","I сабраў Язэп усё срэбра, якое знайшлося ў зямлі Эгіпецкай і ў зямлі Ханаанскай, за збожжа, якое куплялі, і прынёс Язэп срэбра ў дом фараона. ");
INSERT INTO beln_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","I скончылася срэбра ў зямлі Эгіпецкай і ў зямлі Ханаанскай. I прыйшоў увесь Эгіпет да Язэпа, кажучы: “Дай нам хлеба! Навошта мы маем памерці перад табою, бо скончылася срэбра”. ");
INSERT INTO beln_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","І сказаў Язэп: “Дайце статак ваш, і я буду даваць вам за статак ваш, калі скончылася срэбра”. ");
INSERT INTO beln_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","I яны прыводзілі статак свой да Язэпа, і даваў ім Язэп хлеб за коней, і за статкі авечак, і за статкі валоў, і за аслоў; і жывіў іх хлебам за ўвесь статак іхні ў той год. ");
INSERT INTO beln_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","I скончыўся той год; і прыйшлі да яго у наступным годзе, і сказалі яму: “Ня ўтоім ад пана нашага, што скончылася срэбра, і статкі скаціны нашай — у пана нашага. Не засталося нічога ў нас перад абліччам пана нашага, акрамя целаў нашых і грунтоў нашых. ");
INSERT INTO beln_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Навошта маем памерці перад вачыма тваімі, і мы, і грунты нашыя? Купі нас і грунты нашыя за хлеб; і будзем мы і грунты нашыя нявольнікамі фараона, а ты дай нам зерня, і мы будзем жыць, і не памрэм, і грунты не спусьцеюць”. ");
INSERT INTO beln_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","I набыў Язэп усе грунты ў Эгіпце для фараона, бо прадалі Эгіпцяне кожны поле сваё, бо прыціснуў іх голад. I зямля стала фараонавай. ");
INSERT INTO beln_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","А народ ён перавёў у гарады ад аднаго канца мяжы Эгіпту аж да другога канца яго. ");
INSERT INTO beln_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Толькі грунты сьвятароў не набыў, бо частка сьвятароў была ад фараона, і яны жывіліся са сваёй часткі, якую даў ім фараон; таму яны і не прадалі грунты свае. ");
INSERT INTO beln_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","I сказаў Язэп народу: “Вось, я купіў сёньня вас і грунты вашыя для фараона. Вось вам зерне, і засявайце зямлю. ");
INSERT INTO beln_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","І калі будзе жніво, давайце пятую частку фараону, а чатыры часткі застануцца вам засеяць поле і на харчаваньне вам і тым, хто ў дамах вашых, і на харчаваньне дзецям вашым”. ");
INSERT INTO beln_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","А яны сказалі: “Ты захаваў нам жыцьцё. Няхай мы знойдзем ласку ў вачах пана нашага, і будзем слугамі фараону”. ");
INSERT INTO beln_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I паставіў гэта Язэп як пастанову, якая дагэтуль у зямлі Эгіпецкай, што для фараона пятая частка ураджаю, толькі грунты сьвятароў належаць ім самім, ня сталі яны фараонавымі. ");
INSERT INTO beln_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","I жыў Ізраіль у зямлі Эгіпецкай, у зямлі Гашэн, і мелі ўласнасьць у ёй, і пладзіліся, і памножыліся вельмі. ");
INSERT INTO beln_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","I жыў Якуб у зямлі Эгіпецкай сямнанцаць год; і было дзён Якуба, гадоў жыцьця ягонага — сто сорак сем гадоў. ");
INSERT INTO beln_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","I наблізіліся дні Ізраілю, каб памерці, і паклікаў ён сына свайго Язэпа, і сказаў яму: “Калі я знайшоў ласку ў вачах тваім, прашу, палажы руку сваю пад сьцягно маё і зрабі мне міласэрнасьць і праўду, што не пахаваеш мяне ў Эгіпце. ");
INSERT INTO beln_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Але буду я ляжаць з бацькамі сваімі. Вынясі мяне з Эгіпту і пахавай мяне ў магіле іхняй”. I той сказаў: “Зраблю паводле слова твайго”. ");
INSERT INTO beln_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","I сказаў Якуб: “Прысягні мне”. I прысягнуў яму. I схіліўся Ізраіль на верх ложка. ");
INSERT INTO beln_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","I сталася пасьля падзеяў гэтых: і сказалі Язэпу: “Вось, бацька твой хворы”. I ён узяў двух сыноў сваіх з сабою, Манасу і Эфраіма. ");
INSERT INTO beln_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","I паведамілі Якубу, і сказалі: “Вось, сын твой Язэп прыйшоў да цябе”. I сабраў сілы Ізраіль, і сеў на ложку. ");
INSERT INTO beln_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","I сказаў Якуб Язэпу: “Бог Усемагутны зьявіўся мне ў Люзе, у зямлі Ханаан, і дабраславіў мяне, ");
INSERT INTO beln_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","і сказаў мне: “Вось, Я зраблю цябе плодным, і памножу цябе, і дам табе быць зграмаджэньнем народаў, і дам зямлю гэтую насеньню твайму пасьля цябе на ўласнасьць вечную”. ");
INSERT INTO beln_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","I цяпер два сыны твае, што нарадзіліся табе ў зямлі Эгіпецкай, да прыходу майго да цябе ў Эгіпет, яны — мае; Эфраім і Манаса, як Рубэн і Сымон, будуць мае. ");
INSERT INTO beln_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","А нашчадкі твае, якія ты нарадзіў пасьля іх, будуць твае. Паводле імёнаў братоў сваіх будуць яны называцца у спадчыне сваёй. ");
INSERT INTO beln_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","А ў мяне, калі я прыйшоў з Падану, памерла ў мяне Рахель у зямлі Ханаан, у дарозе, калі яшчэ заставалася кіўра зямлі, каб дайсьці да Ефраты, і я пахаваў яе там, пры дарозе ў Ефрату, гэта значыць Бэтлеем”. ");
INSERT INTO beln_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","I ўбачыў Ізраіль сыноў Язэпа, і сказаў: “Хто яны?” ");
INSERT INTO beln_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","I сказаў Язэп бацьку свайму: “Яны — сыны мае, якіх Бог даў мне тут”. I сказаў Якуб: “Вазьмі, прашу, іх да мяне, і я дабраслаўлю іх”. ");
INSERT INTO beln_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","А вочы Ізраіля сталі цяжкія ад старасьці, ня мог ён бачыць. I наблізіў іх да яго, і ён пацалаваў іх, і абняў іх. ");
INSERT INTO beln_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I сказаў Ізраіль Язэпу: “Я не спадзяваўся ўбачыць аблічча тваё, і вось, Бог даў мне ўбачыць насеньне тваё”. ");
INSERT INTO beln_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","I адвёў іх Язэп ад каленяў ягоных, і пакланіўся яму абліччам сваім да зямлі. ");
INSERT INTO beln_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","I ўзяў Язэп іх абодвух, Эфраіма правіцай сваёю, леваруч Ізраіля, а Манасу — лявіцай сваёю, праваруч Ізраіля, і наблізіўся да яго. ");
INSERT INTO beln_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","I выцягнуў Ізраіль правіцу сваю, і палажыў на галаву Эфраіма, а ён быў малодшы, а лявіцу сваю — на галаву Манасы, скрыжаваў рукі свае, бо Манаса быў першародны. ");
INSERT INTO beln_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","I дабраславіў Язэпа, і сказаў: “Бог, перад абліччам Якога хадзілі бацькі мае, Абрагам і Ісаак, Бог, Які пасьвіў мяне ад моманту, як я існую, аж да гэтага дня, ");
INSERT INTO beln_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Анёл, што выбаўляе мяне ад усякага ліха, няхай дабраславіць юнакоў гэтых; і няхай яны будуць названыя імем маім і імем бацькоў маіх, Абрагама і Ісаака, і няхай разрастуцца яны ў мноства сярод зямлі”. ");
INSERT INTO beln_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","I ўбачыў Язэп, што бацька ягоны палажыў правую руку сваю на галаву Эфраіма, і было гэта ліхім у вачах ягоных. I падхапіў ён руку бацькі свайго, каб пералажыць яе з галавы Эфраіма на галаву Манасы. ");
INSERT INTO beln_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","I сказаў Язэп бацьку свайму: “Ня гэтак, ойча мой, бо гэта першародны. Палажы правіцу тваю на галаву ягоную”. ");
INSERT INTO beln_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","I запярэчыў бацька ягоны, і сказаў: “Ведаю, сыне мой, ведаю, таксама ён будзе народам, і таксама ён будзе вялікі, але брат ягоны малодшы будзе большы за яго, і насеньне ягонае будзе поўняю народаў”. ");
INSERT INTO beln_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I дабраславіў іх у той дзень, кажучы: «Табою будзе дабраслаўляць Ізраіль, кажучы: “Няхай зробіць табе Бог, як Эфраіму і Манасе”». I паставіў Эфраіма перад Манасам. ");
INSERT INTO beln_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","I сказаў Ізраіль Язэпу: «Вось, я паміраю. I Бог будзе з вамі, і верне вас у зямлю бацькоў вашых. ");
INSERT INTO beln_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","I я даў табе адну частку больш за братоў тваіх, тую, якую я ўзяў з рукі Амарэя мячом маім і лукам маім». ");
INSERT INTO beln_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","I паклікаў Якуб сыноў сваіх, і сказаў: «Зьбярыцеся, і я паведамлю вам, што спаткае вас у пазьнейшыя дні. ");
INSERT INTO beln_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Зыйдзіцеся і паслухайце, сыны Якуба, паслухайце Ізраіля, бацьку свайго. ");
INSERT INTO beln_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рубэн, першародны мой, ты — моц мая і пачатак сілы маёй, перавышаеш годнасьцю і перавышаеш магутнасьцю. ");
INSERT INTO beln_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ты пеніўся, як вада, ня будзеш вывышаны, бо ты ўзыйшоў на ложак бацькі свайго; тады ты зьняважыў пасьцель маю, узышоўшы на яе. ");
INSERT INTO beln_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Сымон і Левій, браты, зброя іхняя — прылада гвалту. ");
INSERT INTO beln_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","У нараду іхнюю ня ўвойдзе душа мая, і да зграмаджэньня іхняга не далучыцца слава мая, бо ў гневе сваім яны забілі мужа і ў свавольстве сваім скалечылі вала. ");
INSERT INTO beln_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Пракляты гнеў іхні, бо моцны, і лютасьць іхняя, бо заядлая. Падзялю іх у Якубе і расьцярушу іх у Ізраілі. ");
INSERT INTO beln_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Юда, цябе выслаўляць будуць браты твае. Рука твая — на карку ворагаў тваіх; паклоняцца табе сыны бацькі твайго. ");
INSERT INTO beln_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Юда — малады леў, ад здабычы, сыне мой, ты падымаешся. Прыхіліўся, лёг, як леў і як ільвіца, хто падыме яго? ");
INSERT INTO beln_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ня будзе аднята бэрла ад Юды і заканадаўца ад ног ягоных, аж пакуль ня прыйдзе Той, чыё яно, і Яму — паслухмянасць народаў. ");
INSERT INTO beln_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ён прывяжа да вінаграднай лазы асла свайго і да парастка выборнага вінаграду — асьлянятка асьліцы сваёй. Ён абмые ў віне шаты свае і ў крыві вінаграду — адзеньне сваё. ");
INSERT INTO beln_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Вочы ягоныя чырванейшыя за віно, а зубы — бялейшыя за малако. ");
INSERT INTO beln_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулён на беразе мора будзе жыць і ля прыстані караблёў, і межы ягоныя — да Сідону. ");
INSERT INTO beln_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ісахар — асёл касьцісты, што ляжыць паміж загарадаў. ");
INSERT INTO beln_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","I ўбачыў ён супачынак, што добры, і зямлю, што прыемная, і нахіліў плечы свае насіць цяжары і стаў слугою паднявольным. ");
INSERT INTO beln_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан будзе судзіць народ свой, як адзін з родаў Ізраіля. ");
INSERT INTO beln_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Будзе Дан зьмеем на дарозе, гадзюкай на сьцежцы, якая кусае пяты каня, і валіцца вершнік ягоны назад. ");
INSERT INTO beln_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","На збаўленьне Тваё спадзяюся, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гад — войскі будуць перамагаць яго, але ён пераможа пяты іхнія. ");
INSERT INTO beln_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Пра Ашэра — тлусты хлеб ягоны, і ён будзе даваць прысмакі валадарскія. ");
INSERT INTO beln_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нэфталі — ланя выпушчаная на свабоду, што дае прыгожыя словы. ");
INSERT INTO beln_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Галіна плодная Язэп, галіна плодная над крыніцаю, галіны ягоныя пнуцца па муры. ");
INSERT INTO beln_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","І засмучалі яго, і стралялі ў яго, і ненавідзілі яго стралцы. ");
INSERT INTO beln_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","I застаўся моцным лук ягоны, і ўмацаваліся рамёны рук ягоных — ад рук Магутнага Якубавага, адтуль Пастыр, Скала Ізраіля; ");
INSERT INTO beln_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ад Бога бацькі твайго, і Ён дапаможа табе, і ад Усемагутнага, і Ён дабраславіць цябе дабраславеньнямі неба згары і дабраславеньнямі бяздоньня, што ляжыць унізе, дабраславеньнямі грудзей і ўлоньня. ");
INSERT INTO beln_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Дабраславеньні бацькі твайго перавышаюць дабраславеньні бацькоў маіх, аж да вяршыняў узгоркаў адвечных. Няхай будуць яны на галаве Язэпа і на цемені выбранага між братамі сваімі. ");
INSERT INTO beln_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Бэн’ямін — воўк драпежны, раніцаю будзе есьці здабычу і ўвечары будзе дзяліць прыбытак». ");
INSERT INTO beln_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Усіх гэтых родаў Ізраіля — двананцаць, і гэта тое, што прамаўляў ім бацька іхні; і дабраславіў іх, і кожнага паводле дабраславеньня ягонага дабраславіў. ");
INSERT INTO beln_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","I загадаў ён ім, і сказаў ім: «Я буду далучаны да народу майго. Пахавайце мяне каля бацькоў маіх, у пячоры, якая на полі Эфрона Хета, ");
INSERT INTO beln_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","у пячоры, што на полі Махпэля, якое насупраць Мамрэ ў зямлі Ханаан, якую купіў Абрагам разам з полем Эфрона Хета, на ўласнасьць для пахаваньня. ");
INSERT INTO beln_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Там пахавалі Абрагама і Сару, жонку ягоную, там пахавалі Ісаака і Рэбэку, жонку ягоную; і там я пахаваў Лею. ");
INSERT INTO beln_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Набытыя гэтае поле і пячора, якая на ім, у сыноў Хета». ");
INSERT INTO beln_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","I скончыў Якуб загадваць сынам сваім, і палажыў ногі свае на ложак, і сканаў, і быў далучаны да народу свайго. ");
INSERT INTO beln_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","I ўпаў Язэп на аблічча бацькі свайго, і плакаў над ім, і цалаваў яго. ");
INSERT INTO beln_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","I загадаў Язэп слугам сваім лекарам забальсамаваць бацьку ягонага; і забальсамавалі лекары Ізраіля. ");
INSERT INTO beln_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I прайшло сорак дзён, бо столькі вымагаецца дзён на бальсамаваньне. I плакалі па ім Эгіпцяне семдзясят дзён. ");
INSERT INTO beln_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","I мінулі дні плачу па ім, і прамовіў Язэп дому фараона, кажучы: “Калі я знайшоў ласку ў вачах вашых, кажыце, калі ласка, у вушы фараону, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Бацька мой узяў з мяне прысягу, кажучы: “Вось, я паміраю. У магіле маёй, якую я выкапаў у зямлі Ханаан, там пахавай мяне”. I цяпер я ўзыйду, і пахаваю бацьку свайго, і вярнуся”. ");
INSERT INTO beln_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","I сказаў фараон: “Узыйдзі і пахавай бацьку твайго, як ён узяў у цябе прысягу”. ");
INSERT INTO beln_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","I ўзыйшоў Язэп хаваць бацьку свайго; і ўзыйшлі з ім усе слугі фараона, старшыні дому ягонага, і ўсе старшыні зямлі Эгіпецкае, ");
INSERT INTO beln_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","і ўвесь дом Язэпа, і браты ягоныя, і дом бацькі ягонага. Толькі дзяцей сваіх, і авечак сваіх, і валоў сваіх пакінулі ў зямлі Гашэн. ");
INSERT INTO beln_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","I ўзыйшлі з ім таксама калясьніцы і вершнікі, і быў табар вельмі вялікі. ");
INSERT INTO beln_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","I прыйшлі яны ў Гарэн-Гаатад на другім баку Ярдану, і галасілі там галашэньнем вялікім і вельмі жалосным; і ўчыніў Язэп жалобу па бацьку сваім сем дзён. ");
INSERT INTO beln_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","I ўбачылі жыхары зямлі той, Хананейцы, жалобу ў Гарэн-Гаатадзе, і сказалі: “Гэта вялікая жалоба ў Эгіпцян!” Дзеля гэтага назвалі імя яго: Абэль-Міцраім, які на другім баку Ярдану. ");
INSERT INTO beln_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","I зрабілі сыны Якуба з ім так, як ён загадаў ім. ");
INSERT INTO beln_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","I занесьлі яго сыны ягоныя ў зямлю Ханаан, і пахавалі яго ў пячоры на полі Махпэля, якую купіў Абрагам разам з полем на ўласнасьць на пахаваньне ў Эфрона Хета, насупраць Мамрэ. ");
INSERT INTO beln_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","I вярнуўся Язэп пасьля пахаваньня ім бацькі свайго ў Эгіпет, ён і браты ягоныя, і ўсе, што ўзыходзілі з ім хаваць бацьку ягонага. ");
INSERT INTO beln_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","I бачылі браты Язэпа, што памёр бацька іхні, і сказалі: “А што, калі зьненавідзіць нас Язэп і адплачваючы, адплаціць нам за ўсё тое ліха, якое мы яму зрабілі?” ");
INSERT INTO beln_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","I загадалі яны сказаць Язэпу, кажучы: «Бацька твой загадаў перад сьмерцю сваёю, кажучы: ");
INSERT INTO beln_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Гэтак скажыце Язэпу: “Даруй, прашу, правіну братоў тваіх і грэх іхні, бо ліха зрабілі яны табе”. I цяпер даруй, прашу, слугам Бога бацькі твайго”». I плакаў Язэп дзеля гэтых словаў да яго. ");
INSERT INTO beln_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","I прыйшлі таксама браты ягоныя, і ўпалі перад абліччам ягоным, і сказалі: “Вось, мы — слугі для цябе”. ");
INSERT INTO beln_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","I сказаў ім Язэп: “Ня бойцеся! Хіба я замест Бога? ");
INSERT INTO beln_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","I вы надумалі ліха супраць мяне, але Бог надумаў гэта на дабро, каб зрабіць так, як ёсьць сёньня, каб захаваць жыцьцё вялікаму народу. ");
INSERT INTO beln_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","І цяпер ня бойцеся, я буду карміць вас і дзяцей вашых”. I суцяшаў іх, і прамаўляў да сэрцаў іхніх. ");
INSERT INTO beln_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","I пасяліўся Язэп у Эгіпце, ён і дом бацькі ягонага. І жыў Язэп сто дзесяць гадоў. ");
INSERT INTO beln_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","I бачыў Язэп у Эфраіма сыноў да трэйцяга пакаленьня, таксама сыны Махіра, сына Манасы, нарадзіліся на каленях Язэпа. ");
INSERT INTO beln_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","I сказаў Язэп братам сваім: “Я паміраю, але Бог, наведваючы, наведае вас і вывядзе вас з зямлі гэтай у зямлю, пра якую прысягаў Абрагаму, Ісааку і Якубу”. ");
INSERT INTO beln_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","I ўзяў Язэп прысягу ў сыноў Ізраіля, кажучы: “Бог, наведваючы, наведае вас, і вы вынясіце косткі мае адгэтуль”. ");
INSERT INTO beln_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","I памёр Язэп, маючы сто дзесяць гадоў. I забальсамавалі яго, і палажылі ў дамавіну ў Эгіпце.");
INSERT INTO beln_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1"," Шчасьлівы чалавек, які не хадзіў паводле рады бязбожнікаў, не стаяў на шляху грэшнікаў і не сядзеў паміж насьмешнікаў, ");
INSERT INTO beln_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","бо да закону ГОСПАДА імкненьне яго і пра закон Ягоны будзе разважаць ён днём і ноччу. ");
INSERT INTO beln_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","І будзе ён як дрэва, пасаджанае пры цячэньні водаў, якое прыносіць плод свой у часе сваім, і лістота якога ня вяне, і ва ўсім, што ён робіць, ён посьпех мае. ");
INSERT INTO beln_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ня гэтак бязбожнікі, яны як мякіна, якую вецер разносіць. ");
INSERT INTO beln_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Таму не ўстаяць бязбожнікі на судзе, ані грэшнікі на сходзе праведных, ");
INSERT INTO beln_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","бо ГОСПАД ведае шлях праведных, а шлях бязбожнікаў загіне. ");
INSERT INTO beln_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Чаму бунтуюцца народы, і плямёны задумваюць марнае? ");
INSERT INTO beln_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Паўстаюць валадары зямлі, і князі сабраліся разам супраць ГОСПАДА і супраць Памазанца Ягонага: ");
INSERT INTO beln_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Парвема кайданы іхнія і путы іхнія скіньма з сябе!” ");
INSERT INTO beln_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Той, Які жыве ў небе, будзе сьмяяцца, Госпад будзе кпіць з іх. ");
INSERT INTO beln_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","І скажа да іх у гневе Сваім і ў ярасьці Сваёй напужае іх: ");
INSERT INTO beln_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Гэта Я паставіў Валадара Майго на Сыёне, гары Маёй сьвятой!” ");
INSERT INTO beln_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Я абвяшчу пастанову: “ГОСПАД сказаў да мяне: Ты – Сын Мой, Я сёньня нарадзіў Цябе! ");
INSERT INTO beln_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Зажадай ад Мяне, і дам Табе народы зямлі ў спадчыну, і межы зямныя — на ўласнасьць Табе. ");
INSERT INTO beln_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Кіем жалезным паб’еш іх, быццам начыньне глінянае скрышыш іх”. ");
INSERT INTO beln_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Дык цяпер, валадары, зразумейце, навучыцеся, судзьдзі зямлі! ");
INSERT INTO beln_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Служыце ГОСПАДУ са страхам і радуйцеся з дрыжаньнем. ");
INSERT INTO beln_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Слаўце Сына, каб не разгневаўся, і каб ня зьнішчыў шляху вашага, бо неўзабаве ўзгарыцца гнеў Ягоны! Шчасьлівыя ўсе, якія ў Ім маюць надзею. ");
INSERT INTO beln_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Псальм Давіда, калі ён уцякаў ад аблічча Абсалёма, сына свайго. ");
INSERT INTO beln_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","ГОСПАДЗЕ, як шматлікія сталі прыгнятальнікі мае! Шмат іх паўстае супраць мяне! ");
INSERT INTO beln_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Шмат тых, якія кажуць пра душу маю: “Няма для яго збаўленьня ў Бога” (Сэлях). ");
INSERT INTO beln_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Але Ты, ГОСПАДЗЕ, — шчыт для мяне, Ты – слава мая і Ты падыймаеш галаву маю. ");
INSERT INTO beln_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Голасам маім клікаў я да ГОСПАДА, і Ён адказаў мне з гары Сваёй сьвятое. (Сэлях). ");
INSERT INTO beln_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Я лёг і заснуў; і абудзіўся, бо ГОСПАД падтрымлівае мяне. ");
INSERT INTO beln_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Не палохаюся я многіх тысячаў народу, што абступілі мяне наўкола. ");
INSERT INTO beln_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Паўстань, ГОСПАДЗЕ! Збаў мяне, Божа мой! Бо Ты даў ворагам маім па сківіцах, Ты скрышыў зубы бязбожнікаў. ");
INSERT INTO beln_vpl VALUES ("PS3_9","020_3_9","PSA","3","9","9","У ГОСПАДА збаўленьне і для народу Твайго дабраслаўленьне Тваё. (Сэлях). ");
INSERT INTO beln_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Кіраўніку хору: на струнных інструмэнтах. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Калі я клічу, адкажы мне, Божа, Праведнасьць мая! Калі я быў ўцісканы, Ты даў мне прастору. Зьлітуйся нада мною і пачуй малітву маю! ");
INSERT INTO beln_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Сыны людзей, дакуль слава мая зьневажацца будзе, дакуль будзеце любіць марнасьць і шукаць няпраўды? (Сэлях.) ");
INSERT INTO beln_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Спазнайце, што ГОСПАД аддзяліў багабойнага Свайго; ГОСПАД пачуе, калі буду клікаць да Яго. ");
INSERT INTO beln_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Дрыжыце і не грашыце! Кажыце ў сэрцах вашых на ложках вашых і маўчыце! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Ахвяруйце ахвяры праведнасьці і спадзявайцеся на ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Шмат тых, якія кажуць: “Хто пакажа нам добрае?” Узьнімі над намі сьветласьць аблічча Твайго, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ты даў у сэрцы маім большую радасьць, чым маюць яны, сабраўшы збожжа і віна багата. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS4_9","020_4_9","PSA","4","9","9","У супакоі лягу я і засну, бо Ты, ГОСПАДЗЕ, адзін даеш мне жыць у бясьпецы. ");
INSERT INTO beln_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Кіраўніку хору: на флейтах. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Прыхілі вуха да словаў маіх, ГОСПАДЗЕ, зваж на ўздыханьне маё. ");
INSERT INTO beln_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Выслухай голас крыку майго, Валадару мой і Божа мой, бо я да Цябе малюся. ");
INSERT INTO beln_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","ГОСПАДЗЕ, раніцаю пачуй голас мой; на досьвітку стану перад Табою і буду выглядаць. ");
INSERT INTO beln_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Бо Ты – Бог, Якому недаспадобы няправасьць; злыдзень ня будзе жыць пры Табе! ");
INSERT INTO beln_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Тыя, што хваляцца сабою, ня ўстояць перад вачыма Тваімі, Ты ненавідзіш усіх злачынцаў. ");
INSERT INTO beln_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ты зьнішчаеш хлусьлівых; крыважэрнымі і падступнымі брыдзіцца ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","А я праз вялікую міласэрнасьць Тваю ўвайду ў дом Твой, і ў страху Тваім пакланюся ў сьвятыні сьвятасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","ГОСПАДЗЕ, вядзі мяне ў праведнасьці Тваёй; насупраць ворагам маім выпрастуй шлях Твой перад абліччам маім. ");
INSERT INTO beln_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Бо няма шчырасьці ў вуснах іхніх; нутро іхняе — распуста; горла іхняе — магіла адчыненая; языком сваім ашукваюць. ");
INSERT INTO beln_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Абвінаваць іх, Божа! Няхай загінуць яны ад намераў сваіх! За мноства правінаў іхніх адкінь Ты іх, бо яны збунтаваліся супраць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","І няхай радуюцца ўсе, якія ў Табе маюць надзею; няхай весяляцца навекі, бо Ты іх бароніш; і няхай узрадуюцца ў Табе тыя, якія любяць імя Тваё. ");
INSERT INTO beln_vpl VALUES ("PS5_13","020_5_13","PSA","5","13","13","Бо Ты дабраслаўляеш праведнага, ГОСПАДЗЕ, і ўпадабаньнем Тваім, як шчытом, засланяеш яго. ");
INSERT INTO beln_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Кіраўніку хору: на струнных інструмэнтах, на актаву. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","ГОСПАДЗЕ, у гневе Тваім не карай мяне і ў ярасьці Тваёй не вучы мяне! ");
INSERT INTO beln_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Зьлітуйся нада мною, ГОСПАДЗЕ, бо я нядужы; аздараві мяне, ГОСПАДЗЕ, бо спалоханыя косткі мае, ");
INSERT INTO beln_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","і душа мая вельмі спалоханая. О, ГОСПАДЗЕ, дакуль? ");
INSERT INTO beln_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Павярніся, ГОСПАДЗЕ, выратуй душу маю, збаў мяне дзеля міласэрнасьці Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Бо ў сьмерці няма памяці пра Цябе, і ў пекле хто будзе славіць Цябе? ");
INSERT INTO beln_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Я замарыўся ад уздыханьня майго; штоноч паліваю я ложак мой, сьлязамі паліваю пасьцель маю. ");
INSERT INTO beln_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Ад тугі высахла вока маё, састарэлася дзеля ўсіх, хто ўціскае мяне. ");
INSERT INTO beln_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Адступіцеся ад мяне, ўсе злачынцы, бо ГОСПАД пачуў голас плачу майго. ");
INSERT INTO beln_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","ГОСПАД пачуў маленьне маё, ГОСПАД прыняў малітву маю. ");
INSERT INTO beln_vpl VALUES ("PS6_11","020_6_11","PSA","6","11","11","Няхай будуць асаромленыя ворагі мае і моцна спалоханыя, няхай павернуцца назад і імгненна будуць асаромленыя. ");
INSERT INTO beln_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Лямант Давіда, які засьпяваў ён ГОСПАДУ з прычыны Куша, сына Бэн’яміна. ");
INSERT INTO beln_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","ГОСПАДЗЕ, Божа мой! У Табе маю надзею! Збаў мяне ад усіх перасьледвальнікаў маіх і вызваль мяне, ");
INSERT INTO beln_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","каб ня ўзяў, быццам леў, душы маёй і не разарваў мяне, калі няма каму ратаваць! ");
INSERT INTO beln_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","ГОСПАДЗЕ, Божа мой! Калі я ўчыніў гэткае, калі ёсьць беззаконьне ў руках маіх, ");
INSERT INTO beln_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","калі зло я зрабіў таму, хто жыў са мной мірна, і не ратаваў таго, хто ўціскаў мяне без прычыны, ");
INSERT INTO beln_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","тады няхай перасьледуе вораг душу маю і дагоніць, няхай ўтопча ў зямлю жыцьцё маё і славу маю кіне ў пыл! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Паўстань, ГОСПАДЗЕ, у гневе Тваім! Узьніміся супраць лютасьці тых, што ўціскаюць мяне! Збудзіся, Божа мой, на суд, які Ты прызначыў! ");
INSERT INTO beln_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","І зьбярэцца сход народаў вакол Цябе, і Ты зьвернешся да іх з вышыні. ");
INSERT INTO beln_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","ГОСПАДЗЕ, асудзі народы. Судзі мяне, ГОСПАДЗЕ, паводле праведнасьці маёй і паводле беззаганнасьці маёй, што ёсьць у-ва мне! ");
INSERT INTO beln_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Няхай счэзьне ліхота бязбожнікаў, але ўмацуй праведнага, Ты, Які выспрабоўваеш сэрцы і ныркі, Божа Праведны! ");
INSERT INTO beln_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Шчыт мой у Бога, Які збаўляе шчырых сэрцам, ");
INSERT INTO beln_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","у Бога, Які судзіць праведнага, і ў Бога, Які гневаецца штодзень на бязбожніка. ");
INSERT INTO beln_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Калі той не навернецца, Ён вострыць Свой меч, нацягнуў Свой лук і прыгатаваў, ");
INSERT INTO beln_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","і паклаў на яго прылады сьмерці, стрэлы Свае Ён робіць распаленымі. ");
INSERT INTO beln_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Вось, бязбожнік зачаў злачынства, і цяжарны ліхоцьцем, і народзіць хлусьню. ");
INSERT INTO beln_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Яму капаў ён і выкапаў, і сам уваліцца ў дол, што зрабіў. ");
INSERT INTO beln_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ліхоцьце зьвернецца на галаву ягоную, і на цемя ягонае зыйдзе няправасьць ягоная. ");
INSERT INTO beln_vpl VALUES ("PS7_18","020_7_18","PSA","7","18","18","Буду славіць ГОСПАДА паводле праведнасьці Ягонай і выслаўляць імя ГОСПАДА Найвышэйшага. ");
INSERT INTO beln_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Кіраўніку хору: на лад Гітыт. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","ГОСПАДЗЕ, Госпадзе наш! Якое слаўнае імя Тваё па ўсёй зямлі! Слава Твая ўзьнесеная па-над нябёсы! ");
INSERT INTO beln_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","З вуснаў немаўлятаў і тых, што пры грудзях, Ты заснаваў умацаваньне супраць ненавісьнікаў Тваіх, каб спыніць ворага і мсьціўцу. ");
INSERT INTO beln_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Калі я гляджу на неба Тваё, твор пальцаў Тваіх, на месяц і на зоркі, якія Ты паставіў, ");
INSERT INTO beln_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","я думаю: “Што ёсьць чалавек, што Ты памятаеш пра яго, і сын чалавечы, што Ты наведваеш яго? ");
INSERT INTO beln_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ня шмат Ты паменшыў яго перад анёламі*, і славай і веліччу ўкаранаваў Ты яго, ");
INSERT INTO beln_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","і даў яму панаваць над творамі рук Тваіх, і ўсё Ты паклаў пад ногі яму: ");
INSERT INTO beln_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","авечак і валоў усіх, і зьвяроў палявых, ");
INSERT INTO beln_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","птушак у небе, і рыбаў у моры, і ўсё, што ходзіць сьцежкамі марскімі. ");
INSERT INTO beln_vpl VALUES ("PS8_10","020_8_10","PSA","8","10","10","ГОСПАДЗЕ, Госпадзе наш! Якое слаўнае імя Тваё па ўсёй зямлі! ");
INSERT INTO beln_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Кіраўніку хору: на лад Мутлябэн. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Буду славіць ГОСПАДА ад усяго сэрца майго, буду абвяшчаць усе цуды Твае! ");
INSERT INTO beln_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Буду радавацца і весяліцца ў Табе, буду выслаўляць імя Тваё, Найвышэйшы! ");
INSERT INTO beln_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Калі ворагі мае павернуць назад, яны спатыкнуцца і загінуць перад абліччам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Бо Ты правёў суд мой і разгледзеў справу маю, Ты сеў на пасадзе, праведны Судзьдзя. ");
INSERT INTO beln_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ты ўтаймаваў народы, Ты зьнішчыў бязбожніка, імя іхняе сьцёр на вякі вечныя. ");
INSERT INTO beln_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Вораг спустошаны, канец яго назаўсёды. І гарады ягоныя Ты зруйнаваў, памяць пра іх зьнішчана. ");
INSERT INTO beln_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","А ГОСПАД сядзіць на пасадзе на вякі; Ён паставіў пасад Свой дзеля суду, ");
INSERT INTO beln_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","і Ён будзе судзіць сусьвет паводле праведнасьці і змагацца з народамі паводле справядлівасьці. ");
INSERT INTO beln_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","І будзе ГОСПАД умацаваным замкам для ўцісьнёнага, умацаваным замкам у час трывогі. ");
INSERT INTO beln_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","І будуць спадзявацца на Цябе тыя, што ведаюць імя Тваё, бо Ты не пакідаеш тых, хто шукае Цябе, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Выслаўляйце ГОСПАДА, Які сядзіць на Сыёне, апавядайце між народамі ўчынкі Ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Бо Ён шукае тых, што пралілі кроў, памятае пра іх, Ён не забыўся пра крык уцісканых. ");
INSERT INTO beln_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Зьлітуйся нада мною, ГОСПАДЗЕ! Глянь на пакуты мае ад тых, што ненавідзяць мяне, — Ты, Які падыймаеш мяне ад брамы сьмерці, ");
INSERT INTO beln_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","каб я абвяшчаў усю хвалу Тваю ў брамах дачкі Сыёну і радаваўся ў збаўленьні Тваім. ");
INSERT INTO beln_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Уваліліся пагане ў яму, якую зрабілі; у сетку, якую схавалі, патрапіла нага іхняя. ");
INSERT INTO beln_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","ГОСПАД даў пазнаць Сябе, учыніўшы суд; у справах рук сваіх заблытаўся бязбожнік. (Разважаньне. Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Зыйдуць бязбожнікі ў пекла, усе пагане, якія забыліся пра Бога. ");
INSERT INTO beln_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Бо не назаўсёды забыты будзе бедны, надзея прыгнечаных ня згіне навекі. ");
INSERT INTO beln_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Паўстань, ГОСПАДЗЕ, ня дай чалавеку мець перавагу; пагане будуць суджаныя перад абліччам Тваім! ");
INSERT INTO beln_vpl VALUES ("PS9_21","020_9_21","PSA","9","21","21","Напусьці жах на іх, ГОСПАДЗЕ, каб пазналі пагане, што яны – людзі! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Чаму стаіш здалёк, ГОСПАДЗЕ, хаваешся ў часе трывогі? ");
INSERT INTO beln_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Бязбожнік у пыхлівасьці сваёй перасьледуе ўбогага; няхай будзе ён схоплены ў зламыснасьці, якую надумаў. ");
INSERT INTO beln_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Бо хваліцца бязбожнік у пажаданьнях душы сваёй, і дабраслаўляе хціўца, і грэбуе ГОСПАДАМ. ");
INSERT INTO beln_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Бязбожнік у ганарыстасьці гневу свайго не шукае Бога. “Няма Бога!” — усе думкі ў яго. ");
INSERT INTO beln_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Шляхі ягоныя пасьпяховыя ва ўсякі час; суды Твае высока аддалёныя ад яго; на ўсіх ворагаў сваіх грэбліва дзьмухае ён. ");
INSERT INTO beln_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ён гаворыць у сэрцы сваім: “Я не пахіснуся, з пакаленьня ў пакаленьне ліха ня будзе ў мяне”. ");
INSERT INTO beln_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Вусны ягоныя поўныя праклёнаў, ашуканства і здрады; пад языком у яго — ліхота і злачынства. ");
INSERT INTO beln_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ён сядзіць у засадзе на загуменьнях, у таемным месцы забівае нявіннага; вочы ягоныя сочаць за нешчасьлівым, ");
INSERT INTO beln_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","ён пільнуе ў засадзе, быццам леў у схове сваім; пільнуе, каб схапіць убогага; хапае ўбогага, уцягваючы яго ў сваю сетку; ");
INSERT INTO beln_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","ён згінаецца, туліцца да зямлі, і ад моцы ягонае гіне шмат нешчасьлівых. ");
INSERT INTO beln_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ён кажа ў сэрцы сваім: “Бог забыўся, схаваў аблічча Сваё, ня ўбачыць ніколі!” ");
INSERT INTO beln_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Паўстань, ГОСПАДЗЕ, Божа! Узьнімі руку Тваю, не забывайся пра ўцісканых! ");
INSERT INTO beln_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Чаму бязбожнік пагарджае Богам, кажучы ў сэрцы сваім: “Ты ня будзеш шукаць гэтага”? ");
INSERT INTO beln_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Але Ты бачыш, Ты глядзіш на ліхоту і гора, каб даць аднагароду рукою Сваёю. Табе пакідае свой лёс нешчасьлівы; Ты быў дапамогай сіраце. ");
INSERT INTO beln_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Зламай рамяно бязбожніку і ліхотніку, шукай беззаконьне ягонае, каб больш яго было нельга знайсьці. ");
INSERT INTO beln_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","ГОСПАД — Валадар на вякі вечныя; пагане счэзнуць з зямлі Ягонай. ");
INSERT INTO beln_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ты пачуў жаданьне ўцісканых, ГОСПАДЗЕ! Ты ўмацуеш сэрцы іхнія, Ты прыхіліш вуха Тваё, ");
INSERT INTO beln_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","каб даць суд сіраце і пакрыўджанаму, каб больш не палохаў іх чалавек на зямлі! ");
INSERT INTO beln_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Кіраўніку хору. Давіда. У ГОСПАДЗЕ маю надзею. Чаму вы кажаце душы маёй: “Уцякаючы, уцякай на горы вашыя, як птушка?” ");
INSERT INTO beln_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Бо вось, бязбожнікі нацягнулі лук, палажылі стралу сваю на цяціве, каб упоцемках страляць у правых сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Калі падмуркі будуць раскіданыя, што зробіць праведнік? ");
INSERT INTO beln_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","ГОСПАД у сьвятой сьвятыні Сваёй; пасад ГОСПАДА ў небе, вочы Ягоныя бачаць, павекі Ягоныя выпрабоўваюць сыноў чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","ГОСПАД выпрабоўвае праведніка, але бязбожніка і таго, які любіць няправасьць, ненавідзіць душа Ягоная. ");
INSERT INTO beln_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Дажджом спашле Ён пасткі на бязбожнікаў; агонь, і серка, і вецер палючы будуць часткаю келіха іхняга, ");
INSERT INTO beln_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","бо ГОСПАД праведны і любіць праведнасьць; правыя будуць бачыць аблічча Ягонае. ");
INSERT INTO beln_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Кіраўніку хору: на актаву. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Збаў, ГОСПАДЗЕ, бо ня стала багабойных, бо верныя счэзьлі сярод сыноў чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Марнасьць прамаўляе кожны да бліжняга, вуснамі лісьлівымі і сэрцам дваістым гавораць. ");
INSERT INTO beln_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Няхай адсячэ ГОСПАД усе вусны лісьлівыя, язык, што дзёрзка прамаўляе, ");
INSERT INTO beln_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","якія кажуць: “Языком нашым пераможам, вусны нашыя з намі! Хто гаспадар для нас?” ");
INSERT INTO beln_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","За злачынствы супраць прыгнечаных, за стогны ўцісканых паўстану цяпер, – кажа ГОСПАД, – пастаўлю ў бясьпецы таго, на якога дыхаюць пагрозай. ");
INSERT INTO beln_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Словы ГОСПАДА – чыстыя словы, срэбра ў горне ад зямлі ачышчанае, сямікроць ператопленае. ");
INSERT INTO beln_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Ты, ГОСПАДЗЕ, абарані іх, захавай іх ад пакаленьня гэтага на вякі. ");
INSERT INTO beln_vpl VALUES ("PS12_9","020_12_9","PSA","12","9","9","Навокал ходзяць бязбожнікі, бо сярод сыноў чалавечых узвысіліся найбольш нягодныя. ");
INSERT INTO beln_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Дакуль, ГОСПАДЗЕ? Ці назаўсёды забудзешся пра мяне? Дакуль будзеш хаваць аблічча Сваё ад мяне? ");
INSERT INTO beln_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Дакуль я буду складаць парады ў душы маёй, смутак у сэрцы маім штодня? Дакуль вораг мой будзе ўздымацца нада мною? ");
INSERT INTO beln_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Глянь, адкажы мне, ГОСПАДЗЕ, Божа мой! Прасьвятлі вочы мае, каб не заснуў я сьмерцю, ");
INSERT INTO beln_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","каб не казаў вораг мой: “Я перамог яго”, каб прыгнятальнікі мае ня радаваліся, калі я пахіснуся. ");
INSERT INTO beln_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","А я спадзяюся на міласэрнасьць Тваю; будзе радавацца сэрца маё са збаўленьня Твайго. Буду сьпяваць ГОСПАДУ, бо Ён зрабіў дабро мне. ");
INSERT INTO beln_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Кіраўніку хору. Давіда. Сказаў бязглузды ў сэрцы сваім: “Няма Бога!” Сапсаваліся яны і агідныя рэчы робяць, няма таго, хто робіць дабро. ");
INSERT INTO beln_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Глянуў ГОСПАД з неба на сыноў чалавечых, каб пабачыць, ці ёсьць разумны, які Бога шукае. ");
INSERT INTO beln_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Усе ўхіліліся, усе разам нягодныя; няма нікога, хто робіць дабро, няма аніводнага! ");
INSERT INTO beln_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Няўжо ня маюць пазнаньня ўсе злачынцы, якія народ мой зьядаюць, быццам хлеб ядуць, і ГОСПАДА ня клічуць? ");
INSERT INTO beln_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","І будуць яны там у страху вялікім, бо ёсьць ГОСПАД у пакаленьні праведнікаў! ");
INSERT INTO beln_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Радай прыгнечанага вы пагарджаеце, але ГОСПАД — прыстанішча ягонае. ");
INSERT INTO beln_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Хто дасьць збаўленьне з Сыёну для Ізраіля? Калі ГОСПАД верне палон народу Свайго, будзе радавацца Якуб і будзе весяліцца Ізраіль! ");
INSERT INTO beln_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Псальм Давіда. ГОСПАДЗЕ! Хто будзе жыць у намёце Тваім, хто паселіцца на гары Тваёй сьвятой? ");
INSERT INTO beln_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Той, хто ходзіць беззаганна, і робіць праведнасьць, і кажа праўду ў сэрцы сваім, ");
INSERT INTO beln_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","хто языком сваім не ачарніў, не ўчыніў ліхога бліжняму свайму і ня ўзьвёў ганьбы на таго, хто побач, ");
INSERT INTO beln_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","у вачах якога пагарда для адкінутага і пашана для таго, хто баіцца ГОСПАДА; той, хто са шкодай для сябе прысягаў, але гэтага не зьмяняў, ");
INSERT INTO beln_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","хто срэбра свайго не аддаваў на квоту і хабару супраць нявіннага ня браў. Хто гэтак робіць, не пахісьнецца навекі! ");
INSERT INTO beln_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Залатая песьня Давіда. Захавай мяне, Божа, бо я ў Табе маю надзею. ");
INSERT INTO beln_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Кажу я да ГОСПАДА: “Ты – Госпад мой; добрасьць мая нішто перад Табою”. ");
INSERT INTO beln_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Да сьвятых, якія на зямлі, і да слаўных Тваіх, да іх усё імкненьне маё. ");
INSERT INTO beln_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Памножацца прыкрасьці ў тых, што сьпяшаюцца за чужым богам; я ня буду выліваць ахвяры іх крывавае, ані імёнаў іхніх браць у вусны мае. ");
INSERT INTO beln_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","ГОСПАД – частка долі маёй і келіху майго; Ты трымаеш лёс мой. ");
INSERT INTO beln_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Шнуры мае выпалі ў цудоўных мясьцінах, і спадчына прыемная для мяне. ");
INSERT INTO beln_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Буду дабраслаўляць ГОСПАДА, Які радзіць мне, і ўначы ўшчуваюць мяне ныркі мае. ");
INSERT INTO beln_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Маю я ГОСПАДА перад сабою заўсёды, бо Ён праваруч мяне, дык не пахіснуся. ");
INSERT INTO beln_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Дзеля гэтага ўзьвесялілася сэрца маё і радуецца слава мая, нават цела маё супачыне бясьпечна, ");
INSERT INTO beln_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","бо Ты не пакінеш душу маю ў пекле і не дасі сьвятомуТвайму ўбачыць парахненьне. ");
INSERT INTO beln_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ты дасі мне ведаць шлях жыцьця; перад абліччам Тваім поўня радасьці, праваруч Цябе раскоша заўсёды. ");
INSERT INTO beln_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Малітва Давіда. Пачуй, ГОСПАДЗЕ, справядлівасьць маю, зваж на галашэньне маё, прыхілі вуха да малітвы маёй з вуснаў нефальшывых! ");
INSERT INTO beln_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ад аблічча Твайго няхай выйдзе прысуд мой; вочы Твае бачаць, што справядліва. ");
INSERT INTO beln_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ты выспрабаваў сэрца маё, уначы адведаў і ачысьціў мяне, і не знайшоў нічога; думкі ліхія ня выйшлі з вуснаў маіх. ");
INSERT INTO beln_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","У справах чалавечых паводле слова вуснаў Тваіх я высьцерагаўся сьцежкаў гвалту, ");
INSERT INTO beln_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","крокі мае трымаліся каляінаў Тваіх, стопы мае не хісталіся. ");
INSERT INTO beln_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Да Цябе я гукаю, бо Ты, Божа, адкажаш мне. Прыхілі вуха Тваё да мяне, пачуй словы мае! ");
INSERT INTO beln_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Зьяві міласэрнасьць Тваю, Збаўца тых, якія да правіцы Тваёй уцякаюць ад тых, што паўсталі на іх. ");
INSERT INTO beln_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Захавай мяне, як зрэнку вока, у цяню крылаў Тваіх схавай Ты мяне ");
INSERT INTO beln_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","ад бязбожнікаў, якія руйнуюць мяне, ад ворагаў душы маёй, якія атачылі мяне. ");
INSERT INTO beln_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Тлушчам сваім яны закрылі сябе, вуснамі сваімі яны пыхліва гавораць. ");
INSERT INTO beln_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","На кожным кроку цяпер яны нас абступаюць; вочы свае скіравалі, каб нас кінуць на зямлю. ");
INSERT INTO beln_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Яны падобныя да ільва, які прагне здабычы, і да львяняці, якое ў засадзе ляжыць. ");
INSERT INTO beln_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Паўстань, ГОСПАДЗЕ! Выйдзі супраць аблічча ягонага, павалі Ты яго! Мячом Тваім выратуй душу маю ад бязбожніка, ");
INSERT INTO beln_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","ад сьмяротных людзей — Тваёй рукой, ГОСПАДЗЕ, ад сьмяротных людзей веку гэтага. Частка іхняя – ў гэтым жыцьці, і чэрава іхняе Ты са скарбніцы Тваёй напаўняеш, яны насычаюць сыноў сваіх, і лішак свой пакідаюць дзецям сваім. ");
INSERT INTO beln_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","А я ў праведнасьці ўбачу аблічча Тваё, абудзіўшыся, насычуся вобразам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Кіраўніку хору. Слугі ГОСПАДАВА Давіда, які выказаў ГОСПАДУ словы сьпеву гэтага ў дзень, калі ГОСПАД вызваліў яго з рук усіх ворагаў ягоных і з рукі Саўла. І ён казаў: ");
INSERT INTO beln_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Буду любіць Цябе, ГОСПАДЗЕ, сіла мая! ГОСПАД — скала мая, замчышча маё, мой Збаўца! ");
INSERT INTO beln_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Мой Бог — апора мая, у Ім я маю надзею; Ён — шчыт мой, рог збаўленьня майго і ўмацаваны замак мой! ");
INSERT INTO beln_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Паклічу я ГОСПАДА, Які годны хвалы, і ад ворагаў маіх збаўлены буду. ");
INSERT INTO beln_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ахапілі мяне путы сьмерці, і віры Бэліяла стурбавалі мяне; ");
INSERT INTO beln_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","путы пякельныя агарнулі мяне, і пасткі сьмерці схапілі мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","У прыгнечаньні маім клікаў я ГОСПАДА і галасіў да Бога майго. Ён пачуў са сьвятыні Сваёй голас мой, і лямант мой перад абліччам Ягоным дайшоў да вушэй Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","І, дрыжучы, задрыжэла зямля, і падваліны гор затрэсьліся і захісталіся, бо ўгнявіўся Ён. ");
INSERT INTO beln_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Узьняўся дым ад гневу Ягонага, і з вуснаў Ягоных — агонь палючы, вугольле распальваецца ад Яго. ");
INSERT INTO beln_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Нахіліў Ён неба і зыйшоў, і імгла пад нагамі Ягонымі. ");
INSERT INTO beln_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ён сеў на херувіма і паляцеў, і ўзьнёсься на крылах ветру. ");
INSERT INTO beln_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ён зрабіў цемру заслонай Сваёй, вакол Яго — намёт Ягоны з цёмных водаў, з густых хмараў. ");
INSERT INTO beln_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Ад бляску перад Ім разыйшліся хмары Ягоныя, град і вугольле вогненнае. ");
INSERT INTO beln_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","І загрымеў у небе ГОСПАД, і Найвышэйшы падаў голас Свой, град і вугольле вогненнае. ");
INSERT INTO beln_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","І Ён пусьціў стрэлы Свае, і расьцярушыў іх, а мноствам маланак зьбянтэжыў іх. ");
INSERT INTO beln_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","І сталі бачныя рэчышчы водаў, і адкрыліся падваліны сусьвету ад пагрозаў Тваіх, ГОСПАДЗЕ, і ад подыху духу гневу Твайго. ");
INSERT INTO beln_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Паслаўшы з вышыні, Ён схапіў мяне, выцягнуў мяне з водаў вялікіх, ");
INSERT INTO beln_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","вызваліў мяне ад ворага майго моцнага і ад тых, якія ненавідзяць мяне, бо яны былі дужэйшыя за мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Яны схапілі мяне ў дзень няшчасьця майго, але ГОСПАД быў падпорай для мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","І Ён вывеў мяне на вольны прастор, Ён выратаваў мяне, бо мне спагадае. ");
INSERT INTO beln_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","ГОСПАД даў мне паводле праведнасьці маёй, паводле чысьціні рук маіх мне аднагародзіў, ");
INSERT INTO beln_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","бо я захоўваў шляхі ГОСПАДАВЫ і не адступаў бязбожна ад Бога майго; ");
INSERT INTO beln_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","бо ўсе суды Ягоныя перада мною, і ад пастановаў Ягоных я не ўхіляўся. ");
INSERT INTO beln_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Я быў беззаганны перад Ім і захоўваў сябе ад беззаконьня. ");
INSERT INTO beln_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","І аднагародзіў мне ГОСПАД паводле праведнасьці маёй, паводле чысьціні рук маіх перад вачыма Ягонымі. ");
INSERT INTO beln_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","З багабойным Ты будзеш багабойным, з чалавекам беззаганным будзеш беззаганны, ");
INSERT INTO beln_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","для чыстага сэрцам Ты чысты сэрцам, і для крывадушнага Ты падступны, ");
INSERT INTO beln_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","бо людзей прыгнечаных Ты збаўляеш, а вочы пыхлівыя паніжаеш. ");
INSERT INTO beln_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ты запаліш сьветач мой; ГОСПАД, Бог мой, асьветліць цемру маю. ");
INSERT INTO beln_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Бо з Табою я атакую войскі і з Богам маім узыйду на муры. ");
INSERT INTO beln_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Бог, беззаганны шлях Ягоны; слова ГОСПАДА чыстае; Ён — шчыт для ўсіх, хто ў Ім мае надзею. ");
INSERT INTO beln_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Бо хто Бог, апрача ГОСПАДА, і хто скала, акрамя Бога нашага? ");
INSERT INTO beln_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Бог, Які падпярэзвае мяне сілай і дае беззаганнасьць шляху майму; ");
INSERT INTO beln_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ён робіць ногі мае як у аленя і на высачыні ставіць мяне, ");
INSERT INTO beln_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","навучае рукі мае для бітвы, і рамёны мае напінаюць мядзяны лук. ");
INSERT INTO beln_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","І Ты даў мне шчыт збаўленьня Твайго, і правіца Твая ўмацоўвала мяне, і ласкавасьць Твая памнажала мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ты даў прастору для кроку майго, і не хісталіся ногі мае. ");
INSERT INTO beln_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Я перасьледаваў ворагаў маіх і даганяў іх, і не варочаўся назад, пакуль ня зьнішчыў іх. ");
INSERT INTO beln_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Я гэтак скрышыў іх, што не маглі ўстаць; яны падалі пад ногі мае. ");
INSERT INTO beln_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ты падперазаў мяне сілай дзеля бітвы, Ты паваліў перада мною тых, што паўсталі супраць мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ты даў мне бачыць карак ворагаў маіх, і тых, што мяне ненавідзілі, я вынішчыў. ");
INSERT INTO beln_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Яны галасілі, і не было таго, хто іх збавіць; яны да ГОСПАДА, але Ён не адказаў ім. ");
INSERT INTO beln_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Я стоўк іх, як той пыл пад ветрам, як балота на вуліцы, я стаптаў іх. ");
INSERT INTO beln_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ты выратаваў мяне ад звадак людзей, паставіў мяне за галаву народам. Людзі, якіх я ня ведаў, будуць служыць мне. ");
INSERT INTO beln_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","На вестку пра мяне, чуюць мяне; сыны чужынцаў падпарадкаваліся мне. ");
INSERT INTO beln_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Сыны чужынцаў млеюць і трымцяць у агароджах сваіх. ");
INSERT INTO beln_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Жыве ГОСПАД, дабраслаўлёная скала мая; і няхай ўзвысіцца Бог збаўленьня майго, ");
INSERT INTO beln_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Бог, Які адпомсьціў за мяне і схіліў народы перада мною, ");
INSERT INTO beln_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","выратаваў мяне ад ворагаў маіх і ўзвысіў мяне па-над тымі, што паўсталі супраць мяне; ад чалавека злачыннага вызваліў мяне. ");
INSERT INTO beln_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Дзеля гэтага буду славіць Цябе, ГОСПАДЗЕ, сярод народаў і імя Тваё выслаўляць. ");
INSERT INTO beln_vpl VALUES ("PS18_51","020_18_51","PSA","18","51","51","Ты ўзьвялічыў збаўленьнем валадара Твайго і зьяўляеш міласэрнасьць памазанцу Твайму, Давіду, і насеньню ягонаму на вякі. ");
INSERT INTO beln_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Нябёсы абвяшчаюць славу Божую, і прасьцяг апавядае пра творы рук Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Дзень дню пераказвае вестку, і ноч ночы выказвае веданьне. ");
INSERT INTO beln_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Бяз гуку, бяз словаў, ня чутны голас іх. ");
INSERT INTO beln_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Па ўсёй зямлі разыходзіцца гучаньне іхняе, а мова іхняя — да краю сусьвету. На іх Ён паставіў намёт для сонца, ");
INSERT INTO beln_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","і яно як жаніх выходзіць з пакою свайго, яно радасна гукае, як волат, калі прабег сьцяжыну сваю. ");
INSERT INTO beln_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Ад краю неба выходзіць яно і бяжыць да краю яго, і нішто ня схаваецца ад гарачыні ягонай. ");
INSERT INTO beln_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Закон ГОСПАДАЎ беззаганны, ён навяртае душу. Сьведчаньне ГОСПАДА вернае, яно робіць мудрым неразумнага. ");
INSERT INTO beln_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Загады ГОСПАДА слушныя, яны радуюць сэрца. Прыказаньне ГОСПАДАВА чыстае, яно прасьвятляе вочы. ");
INSERT INTO beln_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Страх перад ГОСПАДАМ чысты, ён будзе трываць вечна. Суды ГОСПАДАВЫ праўдзівыя, а таксама справядлівыя. ");
INSERT INTO beln_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Яны больш пажаданыя, чым золата, больш, чым золата найчысьцейшае, і саладзейшыя за мёд і мёд сотавы. ");
INSERT INTO beln_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","І слуга Твой праз іх будзе навучаны; хто захоўвае іх, будзе мець нагароду вялікую. ");
INSERT INTO beln_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Хто зразумее памылкі свае? Ад схаваных грахоў дай мне пазьбегнуць пакараньня! ");
INSERT INTO beln_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","І трымай далёка слугу Твайго ад свавольства, няхай яно нада мною не пануе. Тады я буду беззаганны і ня буду мець пакараньня за правіну вялікую. ");
INSERT INTO beln_vpl VALUES ("PS19_15","020_19_15","PSA","19","15","15","Няхай словы вуснаў маіх і разважаньні сэрца майго будуць даспадобы Табе, ГОСПАДЗЕ, Скала мая і Абаронца мой! ");
INSERT INTO beln_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Кіраўніку хору: псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Няхай ГОСПАД пачуе цябе ў дзень трывогі, няхай абароніць цябе імя Бога Якубавага! ");
INSERT INTO beln_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Няхай Ён спашле табе дапамогу са сьвятыні і ўмацуе цябе з Сыёну! ");
INSERT INTO beln_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Няхай Ён узгадае ўсе дары твае і цэласпаленьнямі тваімі няхай насыціцца. ");
INSERT INTO beln_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Няхай Ён дасьць табе паводле сэрца твайго, і споўніць усе намеры твае, ");
INSERT INTO beln_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","каб мы ўзрадаваліся ў збаўленьні Тваім і ў імя Бога нашага сьцяг паднялі. Няхай споўніць ГОСПАД усе прагненьні твае! ");
INSERT INTO beln_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Цяпер я ведаю, што ГОСПАД збаўляе Памазанца Свайго; Ён адкажа яму са сьвятога неба Свайго праз збаўчую магутнасьць правіцы Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Гэтыя спадзяюцца на калясьніцы і коней, а мы ўзгадваем імя ГОСПАДА, Бога нашага. ");
INSERT INTO beln_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Яны пахіснуліся і ўпалі, а мы паўсталі і стаімо проста. ");
INSERT INTO beln_vpl VALUES ("PS20_10","020_20_10","PSA","20","10","10","Збаў нас, ГОСПАДЗЕ, і няхай валадар пачуе нас, калі будзем клікаць! ");
INSERT INTO beln_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","ГОСПАДЗЕ! У моцы Тваёй будзе радавцца валадар, у збаўленьні Тваім ён вельмі ўсьцешыцца. ");
INSERT INTO beln_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ты даў яму жаданьне сэрца ягонага, і просьбам вуснаў ягоных Ты не адмовіў. (Сэлях.) ");
INSERT INTO beln_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Бо Ты сустрэў яго дабраслаўленьнем дабра, усклаў яму на галаву карону з найчысьцейшага золата. ");
INSERT INTO beln_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Жыцьцё ён прасіў у Цябе, Ты даў яму доўгасьць дзён на вякі вечныя. ");
INSERT INTO beln_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Вялікая слава ягоная у збаўленьні Тваім; годнасьць і веліч Ты ўзлажыў на яго. ");
INSERT INTO beln_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Бо Ты даў яму дабраслаўленьне вечнае, Ты разьвесяліў яго радасьцю перад абліччам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Бо валадар спадзяецца на ГОСПАДА і праз міласэрнасьць Найвышэйшага не пахісьнецца, ");
INSERT INTO beln_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Рука Твая знойдзе ўсіх ворагаў Тваіх, правіца Твая знойдзе тых, якія ненавідзяць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ты зробіш з іх печ вогненную у час зьяўленьня аблічча Твайго; ГОСПАД у гневе Сваім выгубіць іх, і агонь зжарэ іх. ");
INSERT INTO beln_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Ты зьнішчыш плод іхні на зямлі і насеньне іхняе — спасярод сыноў чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Бо яны кнулі ліхое супраць Цябе, надумалі зламыснае, якое не змаглі зьдзейсьніць, ");
INSERT INTO beln_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","бо Ты павернеш іх наўцёкі, нацягнеш лук Твой супраць твару іхняга. ");
INSERT INTO beln_vpl VALUES ("PS21_14","020_21_14","PSA","21","14","14","Узьніміся, ГОСПАДЗЕ, у моцы Тваёй! Мы будзем сьпяваць і выслаўляць магутнасьць Тваю. ");
INSERT INTO beln_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Кіраўніку хору: на лад “Ланя на сьвітаньні”. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Божа мой, Божа мой! Чаму Ты пакінуў мяне, аддаліўся ад збаўленьня майго, ад словаў стагнаньня майго? ");
INSERT INTO beln_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Божа мой! Я клічу ўдзень, і Ты не адказваеш, і ўначы, і не супакойваюся. ");
INSERT INTO beln_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Але Ты — Сьвяты, Ты сядзіш па-над хвалою Ізраіля! ");
INSERT INTO beln_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","На Цябе спадзяваліся бацькі нашыя, спадзяваліся, і Ты выратоўваў іх. ");
INSERT INTO beln_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Да Цябе крычалі яны і былі збаўленыя; на Цябе спадзяваліся, і не былі асаромленыя. ");
INSERT INTO beln_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","А я — чарвяк, а не чалавек, зьневажаны людзьмі і пагарджаны народам. ");
INSERT INTO beln_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Усе, што бачаць мяне, кпяць з мяне, крывячы вусны і ківаючы галовамі: ");
INSERT INTO beln_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","“Ён усклаў надзею на ГОСПАДА! Дык няхай Ён выратуе яго, няхай вызваліць яго, калі яму спагадае!” ");
INSERT INTO beln_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Але Ты выцягнуў мяне з чэрава маці, пры грудзях маці маёй даў мне спадзяваньне. ");
INSERT INTO beln_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","На Цябе я пакінуты ад улоньня маці; ад чэрава маці маёй Ты — мой Бог! ");
INSERT INTO beln_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Не аддаляйся ад мяне, бо блізка бяда, бо няма дапамогі! ");
INSERT INTO beln_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Мяне абступілі дужыя быкі, бугаі Башанскія атачылі мяне. ");
INSERT INTO beln_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Яны разявілі ляпы свае на мяне, быццам леў, які прагне здабычы і рыкае. ");
INSERT INTO beln_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Я выліўся быццам вада, і разьдзяліліся ўсе косткі мае. Сталася сэрца маё як воск, растапілася ў нутры маім. ");
INSERT INTO beln_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Высахла як чарапок сіла мая, язык мой прыліп да паднябеньня майго, і ў пыл сьмерці Ты кідаеш мяне. ");
INSERT INTO beln_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Бо сабакі абступілі мяне, грамада злачынцаў атачыла мяне, яны прабілі рукі мае і стопы мае. ");
INSERT INTO beln_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Можна палічыць усе косткі мае. Яны глядзяць, на мяне ўглядаюцца. ");
INSERT INTO beln_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Яны падзялілі адзеньне маё між сабою і пра вопратку маю кідалі жэрабя. ");
INSERT INTO beln_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Але Ты, ГОСПАДЗЕ, не аддаляйся ад мяне! Моцнасьць мая, пасьпяшайся мне на ўспамогу! ");
INSERT INTO beln_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Выратуй ад мяча душу маю, з пашчы сабак адзіную маю. ");
INSERT INTO beln_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Збаў мяне з пашчы львінае, і з рагоў аднарога адкажы мне! ");
INSERT INTO beln_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Дык буду абвяшчаць імя Тваё братам маім, сярод грамады буду хваліць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Вы, якія баіцеся ГОСПАДА, хвалеце Яго! Усё насеньне Якуба, ушаноўвайце Яго, і бойся Яго, усё насеньне Ізраіля! ");
INSERT INTO beln_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Бо Ён не пагардзіў і ня брыдзіўся нэндзай прыгнечанага, і не схаваў аблічча Свайго ад яго, але пачуў яго, калі той галасіў да Яго. ");
INSERT INTO beln_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Пра Цябе хвала мая ў грамадзе вялікай; абяцаньне маё я споўню перад абліччам тых, што баяцца Яго. ");
INSERT INTO beln_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Будуць есьці ўцісканыя і насыцяцца; будуць хваліць ГОСПАДА тыя, што шукаюць Яго. Сэрца вашае будзе жыць вечна! ");
INSERT INTO beln_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Схамянуцца і зьвернуцца да ГОСПАДА ўсе канцы зямлі, і паклоняцца перад абліччам Тваім усе плямёны народаў. ");
INSERT INTO beln_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Бо ГОСПАДУ належыць валадараньне і панаваньне над народамі. ");
INSERT INTO beln_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Будуць есьці і паклоняцца перад Ім усе заможныя зямлі; упадуць перад абліччам Ягоным ўсе, што ў пыл зыходзяць і ня могуць захаваць пры жыцьці душу сваю. ");
INSERT INTO beln_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Насеньне маё будзе служыць Яму і будзе называцца Госпадавым у пакаленьні. ");
INSERT INTO beln_vpl VALUES ("PS22_32","020_22_32","PSA","22","32","32","Прыйдуць і будуць апавядаць народу, што мае нарадзіцца, праведнасьць Ягоную, бо Ён такое зрабіў. ");
INSERT INTO beln_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Псальм Давіда. ГОСПАД ёсьць Пастыр мой, ні ў чым ня буду мець нястачы! ");
INSERT INTO beln_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","На пашах зялёных Ён пасьвіць мяне, да водаў спакойных накіроўвае мяне. ");
INSERT INTO beln_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ён аднаўляе душу маю, на сьцежкі праведнасьці вядзе мяне дзеля імя Свайго. ");
INSERT INTO beln_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Нават калі буду ісьці далінаю ценю сьмерці, ня буду баяцца ліха, бо Ты са мною, Твой кій і Твая падпора, яны мяне пацяшаюць. ");
INSERT INTO beln_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ты прыгатаўляеш перад абліччам маім стол насуперак тым, якія ўціскаюць мяне; галаву маю Ты памазаў алеем і келіх мой да верху наліты. ");
INSERT INTO beln_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Толькі добрасьць і міласэрнасьць Твая будуць ісьці са мною ўсе дні жыцьця майго; і ў доме ГОСПАДА буду жыць доўгія дні. ");
INSERT INTO beln_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Псальм Давіда. ГОСПАДАВА зямля і што напаўняе яе, сусьвет і ўсё, што жыве ў ім. ");
INSERT INTO beln_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Бо Ён на моры заснаваў яго, і на рэках угрунтаваў яго. ");
INSERT INTO beln_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Хто ўзыйдзе на гару ГОСПАДАВУ, і хто стане на месцы Ягоным сьвятым? ");
INSERT INTO beln_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Той, у каго рукі бязьвінныя і сэрца чыстае, хто душы сваёй да марноты не схіляе і не прысягае крывадушна, — ");
INSERT INTO beln_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","той атрымае дабраслаўленьне ад ГОСПАДА і праведнасьць ад Бога збаўленьня свайго. ");
INSERT INTO beln_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Гэта пакаленьне тых, якія шукаюць Яго, якія шукаюць аблічча Твайго, Бог Якуба! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Узьніміце, брамы, вярхі вашыя! Узьніміцеся, дзьверы адвечныя, каб увайшоў Валадар славы! ");
INSERT INTO beln_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Хто-ж ёсьць Валадар славы? ГОСПАД моцны і магутны, ГОСПАД, магутны ў бітве. ");
INSERT INTO beln_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Узьніміце, брамы, вярхі вашыя! Узьніміцеся, дзьверы адвечныя, каб увайшоў Валадар славы! ");
INSERT INTO beln_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Хто ж ёсьць Валадар славы? ГОСПАД Магуцьцяў — Ён ёсьць Валадар славы! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Давіда. Да Цябе, ГОСПАДЗЕ, узьнімаю я душу маю. ");
INSERT INTO beln_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Божа мой! На Цябе спадзяюся; ня дай мне быць асаромленым, ня дай ворагам маім быць нада мной пераможцамі. ");
INSERT INTO beln_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Бо ўсе, што на Цябе спадзяюцца ня будуць асаромленыя. Будуць асаромлены тыя, што адступаюцца без прычыны. ");
INSERT INTO beln_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","ГОСПАДЗЕ, дай мне ведаць шляхі Твае, навучы мяне сьцежкам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Вядзі мяне ў праўдзе Тваёй і навучы, бо Ты — Бог збаўленьня майго, на Цябе спадзяюся ў-ва ўсякі дзень. ");
INSERT INTO beln_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Узгадай пра літасьць Тваю, ГОСПАДЗЕ, і пра міласэрнасьць Тваю, бо яны — ад вякоў. ");
INSERT INTO beln_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Пра грахі маладосьці маёй і пра правіны мае ня ўзгадвай. Паводле міласэрнасьці Тваёй Ты ўзгадай пра мяне, дзеля добрасьці Тваёй, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","ГОСПАД добры і справядлівы, таму Ён будзе навучаць Свайму шляху грэшнікаў. ");
INSERT INTO beln_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ён прывядзе ўцісканых на суд і навучыць уцісканых шляху Свайму. ");
INSERT INTO beln_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Усе сьцежкі ГОСПАДА — міласэрнасьць і праўда для тых, якія захоўваюць запавет Ягоны і сьведчаньні Ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Дзеля імя Твайго, ГОСПАДЗЕ, даруй мне беззаконьне маё, бо надта яно вялікае! ");
INSERT INTO beln_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Хто той чалавек, які баіцца ГОСПАДА? Яго Ён навучыць шляху, які трэба выбраць яму. ");
INSERT INTO beln_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Душа ягоная будзе жыць ў добрым, і насеньне ягонае зямлю ў спадчыну возьме. ");
INSERT INTO beln_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Таямніца ГОСПАДА з тымі, што баяцца Яго, і запавет Свой Ён дае ім ведаць. ");
INSERT INTO beln_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Вочы мае заўсёды глядзяць на ГОСПАДА, бо Ён выцягне з сеткі ногі мае. ");
INSERT INTO beln_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Павярніся да мяне і зьлітуйся нада мною, бо я самотны і прыгнечаны. ");
INSERT INTO beln_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Трывогі сэрца майго пашырыліся, выцягні мяне з бедаў маіх! ");
INSERT INTO beln_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Глянь на пакуты мае і нядолю маю, і даруй мне ўсе грахі мае! ");
INSERT INTO beln_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Глянь на ворагаў маіх, бо шмат іх і нянавісьцю злачыннаю яны ненавідзяць мяне. ");
INSERT INTO beln_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Захавай душу маю і выратуй мяне, каб ня быў я асаромлены, бо я ў Табе маю надзею. ");
INSERT INTO beln_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Беззаганнасьць і праведнасьць няхай захаваюць мяне, бо я на Цябе спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Божа, выбаў Ізраіля ад усіх трывогаў ягоных! ");
INSERT INTO beln_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Давіда. Судзі мяне, ГОСПАДЗЕ, бо хадзіў я ў беззаганнасьці маёй і на ГОСПАДА спадзяваўся, не хістаючыся. ");
INSERT INTO beln_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Выпрабуй мяне, ГОСПАДЗЕ, і дасьведчы; ачысьці ныркі мае і сэрца маё! ");
INSERT INTO beln_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Бо міласэрнасьць Твая перад вачыма маімі, і я хаджу ў праўдзе Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Я не сядзеў з людзьмі марнымі, і з крывадушнымі ня буду ўваходзіць. ");
INSERT INTO beln_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Я ненавідзеў сходы злачынцаў, і з бязбожнікамі ня буду сядзець разам. ");
INSERT INTO beln_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Я абмыю ў нявіннасьці рукі мае і абыйду вакол ахвярніку Твайго, ГОСПАДЗЕ, ");
INSERT INTO beln_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","каб голасна дзякаваць Табе і абвяшчаць ўсе цуды Твае. ");
INSERT INTO beln_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","ГОСПАДЗЕ, я ўлюбіў сядзібу дому Твайго і месца сялібы славы Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Не забяры душы маёй з грэшнікамі, ані жыцьця майго з людзьмі крывавымі, ");
INSERT INTO beln_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","у руках якіх брыдота, правіца якіх напоўнена хабарамі. ");
INSERT INTO beln_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","А я буду хадзіць у беззаганнасьці маёй. Выбаў Ты мяне і зьлітуйся нада мною! ");
INSERT INTO beln_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Нага мая на роўным месцы стаіць; у зграмаджэньнях я буду дабраслаўляць ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Давіда. ГОСПАД — сьвятло маё і збаўленьне маё. Каго мне баяцца? ГОСПАД — апора жыцьця майго. Каго мне палохацца? ");
INSERT INTO beln_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Калі злачынцы выйдуць супраць мяне, каб пажэрці цела маё, прыгнятальнікі і ворагі мае, яны самі спатыкнуцца і ўпадуць. ");
INSERT INTO beln_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Калі табар вайсковы стане супраць мяне, сэрца маё ня будзе баяцца; калі ўзьнімецца супраць мяне вайна, я і тады буду спадзяваццца. ");
INSERT INTO beln_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Аднаго я прашу ў ГОСПАДА і гэтага толькі шукаю, каб жыць мне ў доме ГОСПАДА ўсе дні жыцьця майго, каб бачыць хараство ГОСПАДА і разважаць у сьвятыні Ягонай. ");
INSERT INTO beln_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Бо Ён заслоніць мяне ў схове Сваім у дзень злы, Ён схавае мяне пад заслонай намёту Свайго, і ўзьнясе мяне на скалу. ");
INSERT INTO beln_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Гэтак будзе ўзьнесена цяпер галава мая па-над усімі ворагамі маімі вакол мяне, і буду ахвяроўваць ГОСПАДУ ахвяры ў намёце Ягоным пад трубныя гукі, буду сьпяваць і выслаўляць ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Пачуй, ГОСПАДЗЕ, голас мой, калі я клічу. Зьлітуйся нада мною і адкажы мне! ");
INSERT INTO beln_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Пра Цябе кажа сэрца маё: “Шукайце аблічча Маё!” Я буду шукаць, ГОСПАДЗЕ, аблічча Тваё! ");
INSERT INTO beln_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Не хавай ад мяне аблічча Тваё, не адцурайся ў гневе ад слугі Твайго! Ты быў мне ўспамогай! Не адкідай мяне і не пакінь мяне, Божа збаўленьня майго! ");
INSERT INTO beln_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Бо бацька мой і маці мая пакінулі мяне, а ГОСПАД прыгарнуў мяне. ");
INSERT INTO beln_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Навучы мяне, ГОСПАДЗЕ, шляху Твайму, і вядзі мяне роўнай сьцежкай насупраць ворагам маім! ");
INSERT INTO beln_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Не аддавай мяне ў рукі прыгнятальнікаў маіх, бо сьведкі фальшывыя паўсталі супраць мяне і той, што дыхае няправасьцю. ");
INSERT INTO beln_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Але я веру, што ўбачу добрасьць ГОСПАДА ў зямлі жывых. ");
INSERT INTO beln_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Спадзявайся на ГОСПАДА! Будзь цьвёрды і сэрца тваё ўмацуй, і спадзявайся на ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Давіда. Да Цябе, ГОСПАДЗЕ, я клічу. Скала мая, не маўчы на мой кліч, каб праз маўчаньне Тваё ня стаўся я падобным да тых, што зыходзяць у магілу. ");
INSERT INTO beln_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Пачуй голас маленьня майго, калі я галашу да Цябе, калі ўзьнімаю рукі мае да давіру сьвятыні Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Не цягні мяне да загубы разам з бязбожнікамі і злачынцамі, якія кажуць: “Супакой” бліжнім сваім, а ў сэрцах сваіх ліхое маюць. ");
INSERT INTO beln_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Дай ім паводле справаў іхніх і паводле ліхоты ўчынкаў іхніх; паводле таго, што рабілі рукі іхнія, дай ім; аднагародзь ім за тое, што зрабілі яны. ");
INSERT INTO beln_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Бо яны не разумеюць справаў ГОСПАДА і ўчынкаў рук Ягоных, дык Ён зруйнуе іх і не адбудуе. ");
INSERT INTO beln_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Дабраслаўлёны ГОСПАД, бо Ён пачуў голас маленьня майго. ");
INSERT INTO beln_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","ГОСПАД — моц мая і шчыт мой; на Яго спадзявалася сэрца маё, і Ён дапамог мне; і ўзрадавалася сэрца маё, і сьпевам маім буду славіць Яго. ");
INSERT INTO beln_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","ГОСПАД — моц для нас; Ён — апора збаўленьня памазанца Ягонага. ");
INSERT INTO beln_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Збаў народ Твой і дабраславі спадчыну Тваю; пасьві іх і ўзьнімі іх на вякі. ");
INSERT INTO beln_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Псальм Давіда. Аддайце ГОСПАДУ, сыны Божыя, аддайце ГОСПАДУ славу і моц! ");
INSERT INTO beln_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Аддайце ГОСПАДУ славу імя Ягонага, пакланіцеся ГОСПАДУ у велічы сьвятасьці! ");
INSERT INTO beln_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Голас ГОСПАДА над водамі; Бог славы загрымеў, ГОСПАД над водамі шматлікімі. ");
INSERT INTO beln_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Голас ГОСПАДА магутны, голас ГОСПАДА велічны. ");
INSERT INTO beln_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Голас ГОСПАДА крышыць кедры, ГОСПАД крышыць кедры Лібанскія, ");
INSERT INTO beln_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","і прымушае іх скакаць, быццам цяляты, Лібан і Сірыён, як маладых буйвалаў. ");
INSERT INTO beln_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Голас ГОСПАДА выкрасае полымя агню. ");
INSERT INTO beln_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Голас ГОСПАДА ўстрасае пустыняй, ГОСПАД устрасае пустыняй Кадэш. ");
INSERT INTO beln_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Ад голасу ГОСПАДА лані зьлягаюць і лясы асыпаюцца, і ў сьвятыні Ягонай усё кажа: Слава! ");
INSERT INTO beln_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Над патопам сядзеў ГОСПАД, і будзе сядзець ГОСПАД, як Валадар, навекі! ");
INSERT INTO beln_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","ГОСПАД дасьць сілу народу Свайму, ГОСПАД дабраславіць народ Свой супакоем. ");
INSERT INTO beln_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Псальм. Сьпеў пры пасьвячэньні дома Давіда. ");
INSERT INTO beln_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Вывышаю Цябе, ГОСПАДЗЕ, бо Ты выцягнуў мяне і ня даў ворагам маім радавацца нада мною. ");
INSERT INTO beln_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","ГОСПАДЗЕ, Божа мой! Я галасіў да Цябе, і Ты вылячыў мяне. ");
INSERT INTO beln_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","ГОСПАДЗЕ, Ты вывеў душу маю з пекла, Ты даў мне жыць, каб ня быў я сярод тых, што зыйшлі ў магілу. ");
INSERT INTO beln_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Выслаўляйце ГОСПАДА, вы, багабойныя Ягоныя, і слаўце на ўспамін сьвятасьці Ягонай! ");
INSERT INTO beln_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Бо на імгненьне гнеў Ягоны, на ўсё жыцьцё ўпадабаньне Ягонае; увечары можа быць плач, а раніцаю – радасьць. ");
INSERT INTO beln_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","А я сказаў у бясьпечнасьці сваёй: “Не пахіснуся навекі!” ");
INSERT INTO beln_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","ГОСПАДЗЕ, праз ласку Тваю Ты паставіў горы мае непарушна; але Ты схаваў аблічча Тваё, і я спалохаўся. ");
INSERT INTO beln_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Да Цябе, ГОСПАДЗЕ, я клікаў, і Госпада майго я маліў: ");
INSERT INTO beln_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","“Які зыск у крыві маёй, у тым, што зыйду я ў парахненьне? Ці пыл будзе славіць Цябе? Ці будзе апавядаць праўду Тваю?” ");
INSERT INTO beln_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Пачуй, ГОСПАДЗЕ, і зьлітуйся нада мною! ГОСПАДЗЕ, будзь дапамогай маёю! ");
INSERT INTO beln_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Ты перамяніў лямант мой у танец, Ты скінуў з мяне зрэбніцу і падперазаў мяне радасьцю. ");
INSERT INTO beln_vpl VALUES ("PS30_13","020_30_13","PSA","30","13","13","Дзеля гэтага будзе выслаўляць Цябе слава мая і ня будзе маўчаць. ГОСПАДЗЕ, Божа мой, навекі я буду славіць Цябе! ");
INSERT INTO beln_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Кіраўніку хору: псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","У Табе, ГОСПАДЗЕ, я маю надзею, ня дай мне асароміцца на вякі, у праведнасьці Тваёй выратуй Ты мяне! ");
INSERT INTO beln_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Прыхілі да мяне вуха Тваё, хутчэй выратуй мяне! Будзь для мяне скалою апоры, домам умацаваным, каб збавіць мяне! ");
INSERT INTO beln_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Бо Ты – скала мая і замчышча маё, дык дзеля імя Твайго будзеш весьці мяне і накіроўваць мяне. ");
INSERT INTO beln_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ты мяне выцягнеш з сеці, якую таемна наставілі супраць мяне, бо Ты – апора мая. ");
INSERT INTO beln_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","У рукі Твае аддаю я дух мой; Ты выбавіў мяне, ГОСПАДЗЕ, Бог праўды. ");
INSERT INTO beln_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ненавіджу я тых, што захоўваюць дарэмную марнасьць, бо я на ГОСПАДА спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Я буду радавацца і весяліцца праз міласэрнасьць Тваю, бо Ты глянуў на пакуты мае, спазнаў трывогі душы маёй, ");
INSERT INTO beln_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","і не аддаў мяне ў рукі ворага, паставіў ногі мае на вольны прастор. ");
INSERT INTO beln_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Зьлітуйся нада мною, ГОСПАДЗЕ, бо я прыгнечаны. Ад тугі высахла вока маё, і душа мая і нутро маё. ");
INSERT INTO beln_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Бо зьнікае ў смутку жыцьцё маё, і гады мае — у-ва ўздыханьні. Спатыкнулася ў беззаконьні маім сіла мая, і высахлі косткі мае. ");
INSERT INTO beln_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Я стаўся ганьбаю для ўсіх, што ўціскаюць мяне, і нават для суседзяў маіх, страхоцьцем для знаёмых маіх; хто бачыць мяне на вуліцы, уцякае ад мяне. ");
INSERT INTO beln_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Я забыты ў сэрцах, як мёртвы; я стаўся як начыньне разьбітае. ");
INSERT INTO beln_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Бо я чуў зласлоўе ад многіх, жах наўкола! Яны сабраліся разам супраць мяне, яны задумалі ліхое, каб забраць душу маю. ");
INSERT INTO beln_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Але я на Цябе спадзяюся, ГОСПАДЗЕ! Я кажу: “Ты — мой Бог!” ");
INSERT INTO beln_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","У Тваёй руцэ час мой; выратуй мяне з рукі ворагаў маіх і тых, што перасьледуюць мяне. ");
INSERT INTO beln_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Няхай сьвеціць аблічча Тваё над слугою Тваім; збаў мяне праз міласэрнасьць Тваю! ");
INSERT INTO beln_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","ГОСПАДЗЕ, ня дай Ты мне асароміцца, бо да Цябе я клічу! Няхай асаромяцца бязбожнікі, няхай яны змоўкнуць у пекле, ");
INSERT INTO beln_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","няхай занямеюць вусны хлусьлівыя, якія кажуць дзёрзка супраць праведніка з пыхлівасьцю і пагардай! ");
INSERT INTO beln_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Якая вялікая добрасьць Твая, якую Ты захоўваеш для тых, што баяцца Цябе, і якую ўчыняеш тым, што маюць надзею ў Табе насуперак сынам чалавечым! ");
INSERT INTO beln_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Пад заслонай аблічча Твайго Ты хаваеш іх ад закалотаў людзкіх, Ты засланяеш іх, як у намёце, ад языкоў звадлівых. ");
INSERT INTO beln_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Дабраслаўлёны ГОСПАД, бо Ён учыніў мне цуды міласэрнасьці у горадзе ўмацаваным. ");
INSERT INTO beln_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","А я сказаў у зьбянтэжанасьці маёй: “Я адкінуты ад вачэй Тваіх!” Але Ты пачуў голас маленьня майго, калі я галасіў да Цябе! ");
INSERT INTO beln_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Любіце ГОСПАДА, усе багабойныя Ягоныя! Верных захоўвае ГОСПАД, але тым, якія дзейнічаюць пыхліва, Ён адплочвае з наддаткам. ");
INSERT INTO beln_vpl VALUES ("PS31_25","020_31_25","PSA","31","25","25","Будзьце цьвёрдыя і ўмацуйце сэрца вашае, вы, якія спадзяецеся на ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Навучаньне Давіда. Шчасьлівы, каму дараваная правіна, каму пакрыты грэх. ");
INSERT INTO beln_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Шчасьлівы чалавек, якому не палічыў ГОСПАД беззаконьняў, і ў духу якога няма нядбальства. ");
INSERT INTO beln_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Калі я маўчаў, ссохлі косткі мае ў стагнаньні маім кожны дзень, ");
INSERT INTO beln_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","бо дзень і ноч абцяжала мяне рука Твая; сокі мае высахлі, быццам у летнюю сьпёку. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Грэх мой я паведаміў Табе і не схаваў беззаконьня майго. Я сказаў: “Вызнаю ГОСПАДУ правіны мае”, і Ты дараваў мне віну грэху майго. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Таму кожны багабойны будзе маліцца да Цябе ў часе, калі можна знайсьці Цябе; нават калі разальюцца вялікія воды, яго не дакрануцца яны. ");
INSERT INTO beln_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ты — заслона мая! Ты мяне ад бяды захаваеш, радасьцю выратаваньня аточыш мяне. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Навучу цябе і пакажу табе шлях, па якім ты павінен ісьці, дам табе раду, бо вока Маё над табою. ");
INSERT INTO beln_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Ня будзьце, як конь і як мул, якія разуменьня ня маюць, якіх трэба аздобай іхняю, аброцьцю і вуздою, зацугляць, каб не кідаліся на цябе. ");
INSERT INTO beln_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Шмат болю ў бязбожніка, а таго, хто спадзяецца на ГОСПАДА, міласэрнасьць атачае. ");
INSERT INTO beln_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Радуйцеся ў ГОСПАДЗЕ і цешцеся, праведнікі! Весяліцеся ўсе, правыя сэрцам! ");
INSERT INTO beln_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Весяліцеся ў ГОСПАДЗЕ, праведнікі; правым пасуе хвала. ");
INSERT INTO beln_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Слаўце ГОСПАДА на гусьлях, выслаўляйце Яго на псалтыры дзесяціструнным! ");
INSERT INTO beln_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Сьпявайце Яму новы сьпеў; спраўна грайце Яму пад трубныя гукі. ");
INSERT INTO beln_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Бо слушнае слова ГОСПАДАВА, і ўсе творы Ягоныя верныя. ");
INSERT INTO beln_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Ён любіць праведнасьць і суд; міласэрнасьцю ГОСПАДА напоўнена зямля. ");
INSERT INTO beln_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Словам ГОСПАДА зроблены нябёсы, а подыхам вуснаў Ягоных — усе войскі іхнія. ");
INSERT INTO beln_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ён сабраў як капу воды марскія, Ён склаў іх у скарбніцу бяздоньняў. ");
INSERT INTO beln_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Няхай баіцца ГОСПАДА ўся зямля, няхай дрыжаць перад Ім усе жыхары сусьвету. ");
INSERT INTO beln_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Бо Ён сказаў — і сталася, Ён загадаў — і паўстала. ");
INSERT INTO beln_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","ГОСПАД разьбіў намеры паганаў, запярэчыў думкам народаў. ");
INSERT INTO beln_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Намер ГОСПАДА будзе трываць на вякі, думкі сэрца Ягонага — з пакаленьня ў пакаленьне. ");
INSERT INTO beln_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Шчасьлівы народ, у якога ГОСПАД ёсьць Бог, народ, які Ён выбраў на спадчыну для Сябе. ");
INSERT INTO beln_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","З неба ГОСПАД глядзіць, Ён бачыць усіх сыноў чалавечых; ");
INSERT INTO beln_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","з мейсца, дзе Ён жыве, Ён паглядае на ўсіх жыхароў зямлі. ");
INSERT INTO beln_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ён уфармаваў сэрца кожнага з іх, Ён зважае на ўсе ўчынкі іхнія. ");
INSERT INTO beln_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ня будзе збаўлены валадар вялікім войскам, волат ня вызваліцца праз вялікую сілу сваю; ");
INSERT INTO beln_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","падманлівы конь для выратаваньня, і вялікая сіла ягоная ня дасьць выбаўленьня. ");
INSERT INTO beln_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Вось, вока ГОСПАДА над тымі, якія баяцца Яго, якія спадзяюцца на міласэрнасьць Ягоную, ");
INSERT INTO beln_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","што Ён вызваліць ад сьмерці душы іхнія, і захавае жыцьцё ў час голаду. ");
INSERT INTO beln_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Душа нашая чакае на ГОСПАДА; Ён — дапамога наша і шчыт наш. ");
INSERT INTO beln_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Бо ў Ім радуецца сэрца нашае; бо мы на імя Яго сьвятое спадзяемся. ");
INSERT INTO beln_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Няхай будзе міласэрнасьць Твая, ГОСПАДЗЕ, над намі, як мы на Цябе спадзяемся! ");
INSERT INTO beln_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Псальм Давіда, калі ён перад Абімэлехам удаваў вар’ята і быў выгнаны ім, і пайшоў сабе. ");
INSERT INTO beln_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Буду дабраслаўляць ГОСПАДА ў-ва ўсякі час; хвала Яго будзе заўсёды на вуснах маіх. ");
INSERT INTO beln_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","У ГОСПАДЗЕ будзе хваліцца душа мая; пачуюць пра гэта ўцісканыя і ўзрадуюцца. ");
INSERT INTO beln_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Узьвялічвайце ГОСПАДА са мною, і разам будзем вывышаць імя Ягонае! ");
INSERT INTO beln_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Я шукаў ГОСПАДА, і Ён адказаў мне, і ад усяго, чаго я баяўся, выратаваў мяне. ");
INSERT INTO beln_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Глядзіце на Яго і зыходзьцеся да Яго, і абліччы вашыя ня будуць у ганьбе. ");
INSERT INTO beln_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Убогі клікаў, і ГОСПАД пачуў яго, і збавіў яго ад усіх трывогаў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Анёл ГОСПАДАЎ ставіць табар вакол тых, якія баяцца Яго, і ратуе іх. ");
INSERT INTO beln_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Паспытайце і ўбачце, які добры ГОСПАД! Шчасьлівы той чалавек, які ў Ім мае надзею. ");
INSERT INTO beln_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Бойцеся ГОСПАДА, вы, сьвятыя Ягоныя! Бо ня маюць нястачы тыя, якія баяцца Яго. ");
INSERT INTO beln_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Львяняты бядуюць і галадуюць, але тыя, што шукаюць ГОСПАДА, не адчуюць нястачы ўсякага даброцьця. ");
INSERT INTO beln_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Хадзіце сюды, сыны, паслухайце мяне, я навучу вас страху перад ГОСПАДАМ. ");
INSERT INTO beln_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Хто ёсьць чалавек, якому даспадобы жыцьцё, які любіць доўгія дні, каб убачыць добрае? ");
INSERT INTO beln_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Захоўвай язык свой ад ліхога, а вусны свае — ад слова крывадушнага. ");
INSERT INTO beln_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Ухіляйся ад ліхога і рабі добрае; шукай супакою і імкніся да яго. ");
INSERT INTO beln_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Вочы ГОСПАДА — на праведных, і вушы Ягоныя — на лямант іхні. ");
INSERT INTO beln_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Аблічча ГОСПАДА — супраць тых, якія робяць ліхое, каб вынішчыць з зямлі памяць пра іх. ");
INSERT INTO beln_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Праведныя крычаць, і ГОСПАД чуе іх, і ад усіх іхніх бедаў ратуе іх. ");
INSERT INTO beln_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","ГОСПАД блізкі да тых, у каго сэрца скрышанае, і збаўляе тых, у каго дух разьбіты. ");
INSERT INTO beln_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Шмат ліхога здараецца ў праведнага, але з усяго гэтага ратуе яго ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Ён захоўвае ўсе косткі ягоныя, каб ніводную не паламалі. ");
INSERT INTO beln_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Ліхоцьце прывядзе да сьмерці бязбожніка, і будуць абвінавачаныя тыя, што ненавідзяць Праведнага. ");
INSERT INTO beln_vpl VALUES ("PS34_23","020_34_23","PSA","34","23","23","ГОСПАД выбаўляе душы слугаў Сваіх, і ўсе, якія маюць надзею ў Ім, ня будуць абвінавачаныя. ");
INSERT INTO beln_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Давіда. Змагайся, ГОСПАДЗЕ, з тымі, якія ідуць супраць мяне; ваюй супраць тых, што ваююць са мною. ");
INSERT INTO beln_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Вазьмі шчыт і панцыр, і паўстань на ўспамогу мне. ");
INSERT INTO beln_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","І схапі дзіду, і загарадзі дарогу тым, якія перасьледуюць мяне. Скажы душы маёй: “Я — збаўленьне тваё”. ");
INSERT INTO beln_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Няхай асаромяцца і будуць у сораме тыя, што шукаюць душу маю; няхай адступяцца і будуць у ганьбе тыя, што надумалі ліхое супраць мяне. ");
INSERT INTO beln_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Няхай будуць яны, як мякіна пад ветрам, і анёл ГОСПАДАЎ няхай гоніць іх. ");
INSERT INTO beln_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Няхай шлях іхні будзе цёмны і сьлізкі, і анёл ГОСПАДАЎ няхай перасьледуе іх. ");
INSERT INTO beln_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Бо яны без прычыны таемна наставілі на мяне ў яме сетку сваю, без прычыны выкапалі яму для душы маёй. ");
INSERT INTO beln_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Няхай прыйдзе на яго загуба нечакана, няхай сетка, якую ён таемна наставіў, зловіць яго, няхай на загубу ўваліцца ён. ");
INSERT INTO beln_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","А мая душа будзе радавацца ў ГОСПАДЗЕ, будзе цешыцца збаўленьнем сваім. ");
INSERT INTO beln_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Усе косткі мае скажуць: “ГОСПАДЗЕ, хто падобны да Цябе, Які ратуеш прыгнечанага ад дужэйшага за яго, беднага і прыгнечанага — ад таго, хто яго абдзірае? ");
INSERT INTO beln_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Паўстаюць сьведкі няправасьці, пра тое, чаго я ня ведаю, выпытваюць мяне, ");
INSERT INTO beln_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","плацяць мне злом за дабро; асірацела душа мая. ");
INSERT INTO beln_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","А я падчас нядужасьці іхняе апранаўся ў зрэбніцу, пастом прыгнятаў душу маю, і малітва мая вярталася ў грудзі мае. ");
INSERT INTO beln_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Быццам ён быў прыяцель, брат мой, хадзіў я да яго; як у жалобе па маці, сумаваў я ў смутку. ");
INSERT INTO beln_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Але калі я пачаў падаць, яны ўзрадаваліся і сабраліся разам, сабраліся разам супраць мяне, каб біць мяне, і я ня ведаў гэтага, зьневажалі мяне і не маўчалі. ");
INSERT INTO beln_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Разам з крывадушнікамі насьмешнікі банкетуюць, скрыгочуць на мяне зубамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Госпадзе, як доўга будзеш глядзець на гэта? Адвядзі ад загубы іхняй душу маю, вызваль ад львянят адзіную маю. ");
INSERT INTO beln_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Буду славіць Цябе ў грамадзе вялікай, сярод народу магутнага буду хваліць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Няхай ня радуюцца з мяне тыя, што варагуюць са мною няслушна, няхай не міргаюць вачыма тыя, што ненавідзяць мяне без прычыны. ");
INSERT INTO beln_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Бо не пра супакой гавораць яны і супраць ціхіх на зямлі падступныя словы надумляюць. ");
INSERT INTO beln_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Шырока разявіўшы вусны свае супраць мяне, яны казалі: “Ага, ага! Бачыла вока нашае!” ");
INSERT INTO beln_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ты бачыў гэта, ГОСПАДЗЕ! Дык не маўчы, Госпадзе, не аддаляйся ад мяне! ");
INSERT INTO beln_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Збудзіся! Абудзіся на суд мой, Бог мой і Госпад мой, каб весьці справу маю! ");
INSERT INTO beln_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Судзі мяне паводле праведнасьці Тваёй, ГОСПАДЗЕ, Божа мой, і няхай яны ня радуюцца, гледзячы на мяне, ");
INSERT INTO beln_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","няхай ня скажуць у сэрцы сваім: “Ага! Душа наша гэтага хацела!” Няхай яны ня скажуць: “Мы праглынулі яго!” ");
INSERT INTO beln_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Няхай асаромяцца і будуць у ганьбе ўсе, што радуюцца з няшчасьця майго; няхай у ганьбу і сорам апрануцца тыя, што вывышаюцца нада мною. ");
INSERT INTO beln_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Няхай весяляцца і радуюцца тыя, якім даспадобы праведнасьць мая, і няхай яны кажуць заўсёды: “Будзь узьвялічаны, ГОСПАД, Якому даспадобы супакой слугі Ягонага!” ");
INSERT INTO beln_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","А язык мой будзе выказваць праведнасьць Тваю і хвалу Тваю кожны дзень. ");
INSERT INTO beln_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Кіраўніку хору: слугі ГОСПАДА Давіда. ");
INSERT INTO beln_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Правіна бязбожніка засьведчана ў сэрцы маім: няма страху Божага перад вачыма ягонымі, ");
INSERT INTO beln_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","бо ён ашуквае сябе ў вачах сваіх, нібы шукае беззаконьня свайго, каб зьненавідзець яго. ");
INSERT INTO beln_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Словы вуснаў ягоных — злачынства і падступнасьць, ён не захацеў разумець, каб рабіць добрае. ");
INSERT INTO beln_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Ён злачынства надумляе на ложку сваім, ён стаіць на шляху нядобрым і ня грэбуе злом. ");
INSERT INTO beln_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","ГОСПАДЗЕ! Да нябёсаў міласэрнасьць Твая, а вернасьць Твая — аж да аблокаў! ");
INSERT INTO beln_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Праведнасьць Твая — быццам Божыя горы, суды Твае — як вялізнае бяздоньне! Людзей і скаціну Ты збаўляеш, ГОСПАДЗЕ. ");
INSERT INTO beln_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Якая каштоўная, Божа, міласэрнасьць Твая! Сыны чалавечыя ў ценю крылаў Тваіх маюць надзею. ");
INSERT INTO beln_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Яны насычаюцца ад тлустасьці дому Твайго, і са струменя асалодаў Тваіх Ты іх поіш, ");
INSERT INTO beln_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","бо крыніца жыцьця — у Табе, у сьвятле Тваім мы бачым сьвятло. ");
INSERT INTO beln_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Расьцягні міласэрнасьць Тваю над тымі, што ведаюць Цябе, і праведнасьць Тваю — над людзьмі са шчырым сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Няхай ня прыйдзе на мяне нага пыхлівых, і рука бязбожніка няхай ня зрушыць мяне. ");
INSERT INTO beln_vpl VALUES ("PS36_13","020_36_13","PSA","36","13","13","Там упадуць злачынцы, паваляцца і ня здолеюць паўстаць. ");
INSERT INTO beln_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Давіда. Ня гневайся на злачынцаў, не зайздросьці тым, што робяць беззаконьне, ");
INSERT INTO beln_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","бо яны, як трава, будуць хутка скошаныя і павянуць, як зялёная расьліна. ");
INSERT INTO beln_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Спадзявайся на ГОСПАДА і рабі добрае, жыві на зямлі і праўда няхай пасьвіць цябе; ");
INSERT INTO beln_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","мей прыемнасьць у ГОСПАДЗЕ, і Ён табе дасьць прагненьні сэрца твайго. ");
INSERT INTO beln_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Аддай ГОСПАДУ шлях свой і спадзявайся на Яго, і Ён усё зробіць, ");
INSERT INTO beln_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","і выведзе праведнасьць тваю як сьвятло, і суд твой — як белы дзень. ");
INSERT INTO beln_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ціхі будзь перад ГОСПАДАМ і чакай на Яго, ня гневайся на таго, хто мае посьпех на шляху сваім, на чалавека, які робіць зламыснае. ");
INSERT INTO beln_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ухіліся ад гневу, пакінь ярасьць, ня гневайся, каб ты ня стаўся злачынцам, ");
INSERT INTO beln_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","бо злачынцы будуць зьнішчаныя, а тыя, што спадзяюцца на ГОСПАДА, возьмуць у спадчыну зямлю. ");
INSERT INTO beln_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Яшчэ крыху, і ня будзе бязбожніка; глянеш на месца ягонае, а яго няма! ");
INSERT INTO beln_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","А пакорныя зямлю ў спадчыну возьмуць і будуць мець прыемнасьць у мностве супакою. ");
INSERT INTO beln_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Бязбожнік задумвае ліхое супраць праведнага і скрыгоча на яго зубамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Госпад сьмяецца з яго, бо бачыць, што прыходзіць дзень ягоны. ");
INSERT INTO beln_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Бязбожнікі выцягнулі меч і нацягнулі лук свой, каб паваліць прыгнечанага і беднага, каб замардаваць тых, у каго шлях просты. ");
INSERT INTO beln_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Меч іхні ўвойдзе ў іхняе сэрца, і лук іхні будзе зламаны. ");
INSERT INTO beln_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Малое ў праведніка лепшае за багацьце шматлікіх бязбожнікаў. ");
INSERT INTO beln_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Бо рамёны бязбожнікаў будуць скрышаныя, а праведнікаў падтрымлівае ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Ведае ГОСПАД дні беззаганных, і спадчына іхняя будзе на вякі. ");
INSERT INTO beln_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Ня будуць яны асаромленыя ў час ліхі, а ў дні голаду будуць насычаныя. ");
INSERT INTO beln_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Бо загінуць бязбожнікі, і ворагі ГОСПАДА зьнікнуць, як тлустасьць авечак у дыме зьнікае. ");
INSERT INTO beln_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Бярэ бязбожнік у доўг — і доўгу ня верне; а праведнік літуецца і дае. ");
INSERT INTO beln_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Бо дабраслаўленыя Богам зямлю ў спадчыну возьмуць, а тыя, што праклятыя Ім, будуць зьнішчаныя. ");
INSERT INTO beln_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","ГОСПАД умацоўвае крокі чалавека, калі шлях ягоны даспадобы Яму. ");
INSERT INTO beln_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Калі ўпадзе, не заб’ецца, бо Госпад падтрымлівае руку ягоную. ");
INSERT INTO beln_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Я быў малады і стаўся стары, і ня бачыў, каб праведнік быў пакінуты, каб насеньне ягонае шукала хлеба. ");
INSERT INTO beln_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Кожны дзень ён літуецца і пазычае, і насеньне ягонае мае дабраслаўленьне. ");
INSERT INTO beln_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Аддаліся ад зла і рабі добрае, і будзеш жыць на вякі. ");
INSERT INTO beln_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Бо ГОСПАД любіць суд, і Ён не пакіне багабойных Сваіх, на вякі захавае іх, а насеньне бязбожнікаў будзе зьнішчана. ");
INSERT INTO beln_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Праведнікі возьмуць у спадчыну зямлю і будуць жыць у ёй вечна. ");
INSERT INTO beln_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Вусны праведніка выказваюць мудрасьць, і язык ягоны гаворыць суд. ");
INSERT INTO beln_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Закон Бога ягонага ў сэрцы ягоным; ня будуць хістацца крокі ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Бязбожнік сочыць за праведнікам і шукае, каб прывесьці да сьмерці яго. ");
INSERT INTO beln_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","ГОСПАД не пакіне яго ў руцэ ягонай, не асудзіць яго, калі ён будзе суджаны. ");
INSERT INTO beln_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Спадзявайся на ГОСПАДА, і захоўвай шлях Ягоны, і Ён узвысіць цябе, каб ты ўзяў у спадчыну зямлю; і калі будуць зьнішчаныя бязбожнікі, ты ўбачыш. ");
INSERT INTO beln_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Я бачыў бязбожніка, моцнага і разгалінаванага, быццам галінастае тутэйшае дрэва, ");
INSERT INTO beln_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","але прамінуў ён, няма яго, і я шукаў яго, і не знайшоў. ");
INSERT INTO beln_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Зважай на беззаганнага і глядзі на правага, бо канец гэтага чалавека ёсьць супакой. ");
INSERT INTO beln_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","А адступнікі будуць зьнішчаны чыста; і канец бязбожных — зьнішчэньне. ");
INSERT INTO beln_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Выратаваньне праведнікаў ад ГОСПАДА, Ён — апора іхняя ў час трывогі. ");
INSERT INTO beln_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","ГОСПАД дапаможа ім і вызваліць іх; Ён вызваліць іх ад бязбожнікаў і збавіць іх, бо яны ў Ім маюць надзею. ");
INSERT INTO beln_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Псальм Давіда. Напамін. ");
INSERT INTO beln_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","ГОСПАДЗЕ, у абурэньні Тваім не карай мяне і ў ярасьці Тваёй не вучы мяне! ");
INSERT INTO beln_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Бо стрэлы Твае пранізалі мяне, і лягла на мяне рука Твая. ");
INSERT INTO beln_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Няма цэлага месца на целе дзеля гневу Твайго, няма супакою ў костках маіх дзеля грэху майго. ");
INSERT INTO beln_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Бо правіны мае ўзьняліся вышэй галавы маёй, як бярэмя цяжкое яны абцяжарваюць мяне. ");
INSERT INTO beln_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Сьмярдзяць, гнаяцца раны мае дзеля дурасьці маёй. ");
INSERT INTO beln_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Я скрывіўся, моцна схіліўся, усе дні ў смутку хаджу, ");
INSERT INTO beln_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Бо сьцёгны мае напоўненыя распаленымі ранамі, і няма цэлага месца ў целе маім. ");
INSERT INTO beln_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Я зьнямогся і моцна скрышаны, я выю дзеля енку сэрца майго. ");
INSERT INTO beln_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Госпадзе мой, перад Табою ўсё жаданьне маё, і уздыханьне маё ад Цябе не схаванае. ");
INSERT INTO beln_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Сэрца маё трапечацца; пакінула мяне сіла мая, і сьвятло вачэй маіх — няма яго ў мяне. ");
INSERT INTO beln_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Тыя, што любілі мяне, і бліжнія мае стаяць насупраць ранаў маіх, і сваякі мае стаяць здалёк ад мяне. ");
INSERT INTO beln_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Тыя, што шукаюць душу маю, ставяць сіло на мяне; а тыя, што жадаюць ліхога для мяне, гавораць пра згубу маю і ўвесь дзень задумваюць падступнасьць. ");
INSERT INTO beln_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","А я, быццам глухі, ня чую, і быццам нямы, які не расчыняе вуснаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","І стаўся я, быццам чалавек, які ня чуе, і няма дакараньня ў вуснах ягоных. ");
INSERT INTO beln_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Бо на Цябе, ГОСПАДЗЕ, я спадзяюся; Ты адкажаш, Госпадзе, Божа мой! ");
INSERT INTO beln_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Бо я сказаў: “Няхай яны ня радуюцца з мяне! Калі пахіснулася нага мая, няхай яны не вывышаюцца нада мною. ");
INSERT INTO beln_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Бо я блізкі да падзеньня, і боль мой заўсёды перада мною. ");
INSERT INTO beln_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Бо беззаконьне маё я апавядаю, сумую дзеля грэху майго. ");
INSERT INTO beln_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","А ворагі мае жывыя і ўзмацняюцца, і шматлікімі сталі тыя, якія няслушна мяне ненавідзяць. ");
INSERT INTO beln_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Яны плацяць мне злом за дабро; яны супрацьстаяць мне, бо я за добрым ганюся. ");
INSERT INTO beln_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Не пакінь мяне, ГОСПАДЗЕ, Божа мой, не аддаляйся ад мяне! ");
INSERT INTO beln_vpl VALUES ("PS38_23","020_38_23","PSA","38","23","23","Пасьпяшайся на ўспамогу мне, Госпадзе выратаваньня майго! ");
INSERT INTO beln_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Кіраўніку хору. Едутуну. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Я сказаў: “Буду захоўваць шлях мой, каб не саграшыць языком маім! Буду захоўваць вусны мае вуздою, пакуль бязбожнік перада мною”. ");
INSERT INTO beln_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Я зьнямеў ў маўчаньні; маўчаў пра добрае, але боль мой нішчыў мяне. ");
INSERT INTO beln_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Распалілася сэрца маё ў нутры маім; ва ўздыханьню маім запалаў агонь, і я прамовіў языком маім. ");
INSERT INTO beln_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Дай мне ведаць, ГОСПАДЗЕ, канец мой і меру дзён маіх, якая яна, дай мне ведаць, які я нетрывалы! ");
INSERT INTO beln_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Вось, на некалькі пядзяў Ты даў дні мае, і век мой — як нішто перад Табою! Толькі ўсякай марнасьцю ёсьць кожны чалавек, нават у сіле. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Толькі як здань ходзіць чалавек, і ёсьць толькі марнасьцю; ён трывожыцца, прагавіта зьбірае і ня ведае, хто забярэ гэта. ");
INSERT INTO beln_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","І цяпер на што яшчэ я спадзяюся, Госпадзе? Надзея мая ў Табе! ");
INSERT INTO beln_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ад усіх правінаў маіх выратуй мяне; на ганьбаваньне ад бязглуздых ня стаў мяне. ");
INSERT INTO beln_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Я зьнямеў, не адчыняю вуснаў маіх, бо Ты зрабіў гэта. ");
INSERT INTO beln_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Забяры ад мяне караньне Тваё, ад удараў рукі Тваёй я зьнікаю. ");
INSERT INTO beln_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Дакараньнем за беззаконьне Ты караеш чалавека і нявечыш, як ад молі, прагненьні ягоныя. Толькі марнасьцю ёсьць кожны чалавек! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Пачуй малітву маю, ГОСПАДЗЕ, і прыхілі вуха да ляманту майго! Не маўчы на сьлёзы мае, бо я прыхадзень у Цябе і пасяленец, як і ўсе бацькі мае. ");
INSERT INTO beln_vpl VALUES ("PS39_14","020_39_14","PSA","39","14","14","Не ўглядайся на мяне, каб я павесялеў перад тым, як зыйду, і ня будзе мяне! ");
INSERT INTO beln_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Кіраўніку хору: псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Спадзеючыся, спадзяваўся я на ГОСПАДА, і Ён схіліўся да мяне, і пачуў лямант мой. ");
INSERT INTO beln_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","І вывеў мяне з ямы бурлівае, з твані балотнае, і паставіў на скале ногі мае, і ўзмоцніў крокі мае. ");
INSERT INTO beln_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","І даў у вусны мае новы сьпеў, хвалу Богу нашаму. Шматлікія ўбачаць гэта, і будуць баяцца, і будуць спадзявацца на ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Шчасьлівы чалавек, які пэўнасьць сваю мае ў ГОСПАДЗЕ, і не зьвяртаецца да ганарыстых і тых, якія прыхіляюцца да няпраўды. ");
INSERT INTO beln_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Шмат учыніў Ты, ГОСПАДЗЕ, Божа мой, цудаў Тваіх, а намеры Твае дзеля нас ні з чым не параўнаеш перад Табою. Калі б я іх апавядаў і пра іх гаварыў, іх шматкроць больш, чым можна палічыць. ");
INSERT INTO beln_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Ахвяры і дары не даспадобы Табе; вушы Ты мне расчыніў. Цэласпаленьняў і ахвяры за грэх Ты не вымагаеш. ");
INSERT INTO beln_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Тады я сказаў: “Вось, я іду! У скрутку кнігі напісана пра мяне”. ");
INSERT INTO beln_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Рабіць тое, што падабаецца Табе, Божа мой, я жадаю, і Закон Твой — у нутры маім. ");
INSERT INTO beln_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Я дабравесьціў пра праведнасьць у грамадзе вялікай; вось жа, вуснаў сваіх я ня стрымліваў, Ты ведаеш гэта, ГОСПАДЗЕ. ");
INSERT INTO beln_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Праведнасьць Тваю я не хаваў у сэрцы маім, пра вернасьць Тваю і выратаваньне Тваё я казаў, міласэрнасьці Тваёй і праўды Тваёй перад грамадой вялікай ня ўтоіваў. ");
INSERT INTO beln_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","ГОСПАДЗЕ, ня стрымлівай літасьці Тваёй адносна мяне; міласэрнасьць Твая і праўда Твая няхай заўсёды захоўваюць мяне, ");
INSERT INTO beln_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","бо агарнулі мяне ліхоцьці бяз ліку, дагналі мяне правіны мае, ажно не магу я іх палічыць, іх больш, чым валасоў на галаве маёй, і сэрца маё пакінула мяне. ");
INSERT INTO beln_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Мей ласку, ГОСПАДЗЕ, вызваліць мяне! ГОСПАДЗЕ, пасьпяшайся на ўспамогу мне! ");
INSERT INTO beln_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Няхай асаромяцца і будуць у ганьбе ўсе, што шукаюць душы маёй, каб зьнішчыць яе; няхай адступяцца і будуць у сораме тыя, якім даспадобы ліхоцьце маё. ");
INSERT INTO beln_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Няхай аслупянеюць у сораме сваім тыя, якія кажуць мне: “Ага, ага!” ");
INSERT INTO beln_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Няхай радуюцца і весяляцца ў Табе ўсе, хто шукае Цябе. Няхай кажуць заўсёды тыя, што любяць выратаваньне Тваё: “Будзь узьвялічаны, ГОСПАДЗЕ!” ");
INSERT INTO beln_vpl VALUES ("PS40_18","020_40_18","PSA","40","18","18","Хоць я бедны і прыгнечаны, Госпад мой клапоціцца пра мяне. Ты — ўспамога мая і ратунак мой! Не затрымлівайся, мой Божа! ");
INSERT INTO beln_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Шчасьлівы той, хто гаротных разумее; у дзень ліхі ГОСПАД збавіць яго. ");
INSERT INTO beln_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","ГОСПАД захавае яго і дасьць яму жыць; ён будзе шчасьлівы на зямлі, і Ты не аддасі яго на волю ворагаў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","ГОСПАД умацуе яго на ложку немачы; увесь ложак ягоны Ты пераменіш у немачы ягонай. ");
INSERT INTO beln_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Я сказаў: “ГОСПАДЗЕ, зьлітуйся нада мною! Вылечы душу маю, бо я саграшыў перад Табою. ");
INSERT INTO beln_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ворагі мае кажуць ліхое пра мяне: “Калі ж ён памрэ, і будзе зьнішчана імя ягонае?” ");
INSERT INTO beln_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","І калі хто прыйдзе пабачыць мяне, гаворыць марнае, сэрца ягонае напаўняецца зласьлівасьцю, і як выйдзе, гаворыць гэта. ");
INSERT INTO beln_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Разам сабраўшыся, шэпчуцца супраць мяне тыя, што ненавідзяць мяне, выдумляючы ліхое на мяне: ");
INSERT INTO beln_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","“Слова нягоднае вылілася на яго; калі ён зьлёг, больш ня ўстане!” ");
INSERT INTO beln_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Нават чалавек супакою майго, на якога я спадзяваўся, які еў хлеб мой, падняў на мяне пяту. ");
INSERT INTO beln_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","А Ты, ГОСПАДЗЕ, зьлітуйся нада мною і падыймі мяне, каб я аддаў ім адплату! ");
INSERT INTO beln_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","З таго я пазнаю, што Ты зычлівы да мяне, калі вораг мой радасна гукаць ня будзе, ");
INSERT INTO beln_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","але ў беззаганнасьці маёй Ты падтрымаеш мяне і паставіш мяне перад абліччам Тваім на вякі. ");
INSERT INTO beln_vpl VALUES ("PS41_14","020_41_14","PSA","41","14","14","Дабраслаўлёны ГОСПАД, Бог Ізраіля, ад веку і навекі. Амэн, амэн! ");
INSERT INTO beln_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Кіраўніку хору. Навучаньне сыноў Караха. ");
INSERT INTO beln_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Як лань прагне вады з ручая, так душа мая, Божа, прагне Цябе! ");
INSERT INTO beln_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Душа мая прагне Бога, Бога Жывога! Калі ж я прыйду і ўбачу Божае аблічча? ");
INSERT INTO beln_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Сьлёзы мае былі хлебам маім дзень і ноч, калі да мяне гаварылі цэлы дзень: “Дзе Бог твой?” ");
INSERT INTO beln_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Успамінаючы гэта, я душу маю выліваю, бо хадзіў я ў грамадзе шматлюднай, вядучы яе ў дом Божы з голасам радасьці і падзякі мноства сьвяточнага. ");
INSERT INTO beln_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Чаму ты сумуеш, душа мая? Чаму ў-ва мне ты трывожышся? Спадзявайся на Бога, бо яшчэ будзеш славіць Яго, збаўленьне аблічча майго і Бога майго. ");
INSERT INTO beln_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Душа сумуе ў-ва мне; дык з зямлі Ярданскае, з гор Гермону, з гары Міцар Цябе ўспамінаю. ");
INSERT INTO beln_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Бяздоньне гукае бяздоньню пры шуме Тваіх вадаспадаў; усе воды Твае і ўсе хвалі Твае прайшлі праз мяне. ");
INSERT INTO beln_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Удзень ГОСПАД зьявіць міласэрнасьць Сваю, а ўначы сьпеў Ягоны будзе са мною, малітва да Бога жыцьця майго. ");
INSERT INTO beln_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Да Бога кажу я: “Скала мая! Чаму Ты забыўся пра мяне? Чаму я ў суме хаджу ад уціску ворагаў?” ");
INSERT INTO beln_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Як рана ў костках маіх, зьневажалі мяне ворагі мае, гаворачы мне цэлы дзень: “Дзе Бог твой?” ");
INSERT INTO beln_vpl VALUES ("PS42_12","020_42_12","PSA","42","12","12","Чаму ты сумуеш, душа мая? Чаму ў-ва мне ты трывожышся? Спадзявайся на Бога, бо яшчэ будзеш славіць Яго, збаўленьне аблічча майго і Бога майго! ");
INSERT INTO beln_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Судзі мяне, Божа, і барані мяне ў справе маёй супраць народу небагабойнага! Ад чалавека крывадушнага і беззаконнага збаў Ты мяне! ");
INSERT INTO beln_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Бо Ты — Бог мой, апора мая. Чаму Ты пакінуў мяне? Чаму я ў суме хаджу ад уціску ворагаў? ");
INSERT INTO beln_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Спашлі сьвятло Тваё і праўду Тваю, каб вялі мяне і прывялі на гару сьвятую Тваю і да сялібы Тваёй, ");
INSERT INTO beln_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","каб я прыйшоў да ахвярніка Божага, да Бога радасьці і пацяшэньня майго, і на гусьлях буду славіць Цябе, Божа, мой Божа! ");
INSERT INTO beln_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Чаму ты сумуеш, душа мая? Чаму ў-ва мне ты трывожышся? Бо яшчэ будзеш славіць Яго, збаўленьне аблічча майго і Бога майго! ");
INSERT INTO beln_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Кіраўніку хору. Сыноў Караха. Навучаньне. ");
INSERT INTO beln_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Божа! Вушамі нашымі мы чулі, бацькі нашыя нам абвясьцілі пра справы, якія Ты ўчыніў у дні іхнія, у дні старадаўныя. ");
INSERT INTO beln_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ты рукою Сваёю вырваў паганаў, а іх пасадзіў; вынішчыў народы, а іх разрасьціў. ");
INSERT INTO beln_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Бо не мячом сваім яны ўзялі на ўласнасьць зямлю, не рамяно іхняе збавіла іх, але правіца Твая і рамяно Тваё, і сьвятло аблічча Твайго, бо Ты меў ласку да іх. ");
INSERT INTO beln_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ты — Валадар мой, о Божа! Дык загадай, каб прыйшло збаўленьне Якубу! ");
INSERT INTO beln_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Праз Цябе мы паб’ем прыгнятальнікаў нашых, праз імя Тваё стопчам тых, што паўстаюць супраць нас. ");
INSERT INTO beln_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Бо не на лук спадзяюся я, і меч мой ня збавіць мяне, ");
INSERT INTO beln_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","але Ты збавіў нас ад прыгнятальнікаў нашых і асароміў тых, што нас ненавідзяць. ");
INSERT INTO beln_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","У Богу мы хвалімся усе дні, і імя Тваё навекі будзем славіць! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Але Ты нас пакінуў і нас асароміў, і не выходзіш разам з войскамі нашымі. ");
INSERT INTO beln_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ты павярнуў нас наўцёкі перад прыгнятальнікамі нашымі, а ненавісьнікі нашыя нас зрабавалі. ");
INSERT INTO beln_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ты нас аддаў, як авечкі, каб нас паелі, і расьцярушыў нас між паганаў. ");
INSERT INTO beln_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ты прадаў народ Твой за марную плату і не падняў кошту яго. ");
INSERT INTO beln_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ты выставіў нас на ганьбаваньне суседзям нашым, на кпіны і насьмешкі тых, што навокал нас. ");
INSERT INTO beln_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ты ў прыказку ўвёў нас сярод паганаў, і народы ківаюць галовамі над намі. ");
INSERT INTO beln_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Увесь дзень ганьба мая перада мною, і сорам аблічча майго пакрывае мяне ");
INSERT INTO beln_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","дзеля голасу тых, што зьневажаюць і лаюць мяне, дзеля аблічча ворага і мсьціўцы. ");
INSERT INTO beln_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Усё гэта прыйшло на нас, хоць мы не забыліся на Цябе і ня здрадзілі запавету з Табою. ");
INSERT INTO beln_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Не адступілася сэрца нашае і не адхіляліся крокі нашыя ад шляху Твайго, ");
INSERT INTO beln_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","хоць Ты скрышыў нас у месцы цмокаў і накрыў нас ценем сьмерці. ");
INSERT INTO beln_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Калі б мы забыліся імя Бога нашага і цягнулі рукі нашыя да бога чужога, ");
INSERT INTO beln_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","ці ж бы Бог не дазнаўся пра гэта? Бо Ён ведае таямніцы сэрца! ");
INSERT INTO beln_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Бо за Цябе забіваюць нас цэлы дзень, лічаць нас за авечкі на зарэз. ");
INSERT INTO beln_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Збудзіся! Чаму сьпіш, Госпадзе? Абудзіся, не пакінь нас навекі! ");
INSERT INTO beln_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Чаму Ты хаваеш аблічча Тваё, забываешся на пакуты і прыгнечаньне нашае? ");
INSERT INTO beln_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Бо ўкінута ў пыл душа нашая, прыляпілася да зямлі нутро нашае. ");
INSERT INTO beln_vpl VALUES ("PS44_27","020_44_27","PSA","44","27","27","Паўстань на ўспамогу нам, выбаў нас дзеля міласэрнасьці Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Кіраўніку хору: на лад “Лілеі”. Сыноў Караха. Навучаньне. Песьня вясельная. ");
INSERT INTO beln_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Сэрца маё пераліваецца словамі добрымі. Я выказваю твор мой пра валадара. Язык мой, як пёрка спраўнага пісара. ");
INSERT INTO beln_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Ты прыгажэйшы за ўсіх сыноў чалавечых, ласка ліецца з вуснаў тваіх! Таму дабраславіў цябе Бог на вякі. ");
INSERT INTO beln_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Падперажы, волаце, паясьніцу мячом тваім, славай тваёю і веліччу тваёю! ");
INSERT INTO beln_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","І ў велічы тваёй мей посьпех, сядзь пераможна са словам праўды і лагоднай праведнасьці, і правіца твая няхай навучыць цябе страху Божаму. ");
INSERT INTO beln_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Стрэлы твае вострыя, народы ўпадуць пад ногі твае, яны скіраваныя ў сэрцы ворагаў валадара. ");
INSERT INTO beln_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Пасад Твой, Божа, на вякі вечныя! Кій роўнасьці — кій валадарства Твайго. ");
INSERT INTO beln_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ты палюбіў праведнасьць і зьненавідзеў бязбожнасьць. Дзеля гэтага памазаў цябе Бог, Бог твой, алеем радасьці больш за таварышаў тваіх. ");
INSERT INTO beln_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Усё адзеньне Тваё — быццам міра, альвас і касья; у палацы з косьці слановае граньне на струнах вяселіць цябе. ");
INSERT INTO beln_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Дочкі валадароў сярод шанаваных тваіх; сужонка валадара стаіць праваруч цябе ў шчырым золаце з Афіру. ");
INSERT INTO beln_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","“Слухай, дачка, і ўзглянь, і прыхілі вуха тваё, і забудзься пра народ твой і пра дом бацькі твайго. ");
INSERT INTO beln_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","І калі валадар прыгажосьці тваёй зажадае, ты схіліся перад ім, бо ён – пан твой. ");
INSERT INTO beln_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","I дачка Тыру з дарам прыйдзе перад аблічча тваё, панізяцца багатыя народу. ");
INSERT INTO beln_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Уся аздоба дачкі валадара ўнутры, золатам апраўлены шаты яе. ");
INSERT INTO beln_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","У вопратках рознакаляровых вядуць яе да валадара; дзяўчыны ідуць за ёю, сяброўкі ейныя ідуць да цябе. ");
INSERT INTO beln_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Іх вядуць у радасьці і весялосьці, і ўваходзяць яны ў палац валадара. ");
INSERT INTO beln_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Замест бацькоў тваіх будуць сыны твае; іх паставіш князямі па ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("PS45_18","020_45_18","PSA","45","18","18","Я зраблю памятным імя тваё з пакаленьня ў пакаленьне; таму народы будуць славіць цябе на вякі вечныя. ");
INSERT INTO beln_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Кіраўніку хору. Сыноў Караха. На аламот. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Бог для нас — прыстанішча і моц, у бядзе ўспамога, якая заўсёды прыходзіць. ");
INSERT INTO beln_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Дык ня будзем баяцца, хоць бы захісталася зямля і горы рушылі ў сэрца мора, ");
INSERT INTO beln_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","хоць бы раўлі і ўздымаліся воды ягоныя, хоць бы трэсьліся горы ад шалу яго. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Вось рака, струмяні ейныя радуюць горад Божы, сьвятую сялібу Найвышэйшага. ");
INSERT INTO beln_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Бог пасярод яго, дык не захістаецца; Бог дапаможа яму, як настане раніца. ");
INSERT INTO beln_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Зараўлі народы, захісталіся валадарствы; Ён выдаў голас Свой, і зямля растапілася. ");
INSERT INTO beln_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","ГОСПАД Магуцьцяў з намі, умацаваны замак наш – Бог Якуба. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Хадзеце, пабачце дзеі ГОСПАДА, якое спусташэньне Ён зрабіў на зямлі, ");
INSERT INTO beln_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ён войны спыняе аж да краю зямлі, крышыць лукі і дзіды рассякае, калясьніцы паліць у агні. ");
INSERT INTO beln_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","“Спыніцеся, пазнайце, што Я — Бог! Я буду ўзьвялічаны між народамі, буду ўзьвялічаны на зямлі!” ");
INSERT INTO beln_vpl VALUES ("PS46_12","020_46_12","PSA","46","12","12","ГОСПАД Магуцьцяў з намі, умацаваны замак наш — Бог Якуба! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Кіраўніку хору. Сыноў Караха. Псальм. ");
INSERT INTO beln_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Усе народы, пляскайце рукамі, усклікайце Богу голасам радасьці! ");
INSERT INTO beln_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Бо страшны ГОСПАД Найвышэйшы, Валадар вялікі над усёй зямлёю. ");
INSERT INTO beln_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Ён скарыў народы, і кінуў паганаў пад ногі нашыя. ");
INSERT INTO beln_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ён выбраў для нас спадчыну нашую, гонар Якуба, якога Ён палюбіў. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Узьняўся Бог з гукам гучным, ГОСПАД узьняўся пры голасе трубы. ");
INSERT INTO beln_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Выслаўляйце Бога, выслаўляйце! Выслаўляйце Валадара нашага, выслаўляйце! ");
INSERT INTO beln_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Бо Валадар над усёй зямлёй — гэта Бог; выслаўляйце Яго з разуменьнем. ");
INSERT INTO beln_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Валадарыць Бог над усімі народамі; Бог сядзіць на пасадзе сьвятасьці Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Магнаты народаў сабраліся разам з народам Бога Абрагама, бо шчыты зямлі — Божыя; Ён высока ўзьняты. ");
INSERT INTO beln_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Сьпеў. Псальм сыноў Караха. ");
INSERT INTO beln_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Вялікі ГОСПАД і вельмі хвалёны ў горадзе Бога нашага, на гары сьвятасьці Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Прыгожае ўзьнясеньне, аздоба ўсёй зямлі, гара Сыён на схілах паўночных, горад вялікага Валадара. ");
INSERT INTO beln_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Бог у палацах ягоных вядомы як умацаваны замак. ");
INSERT INTO beln_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Бо вось валадары сабраліся, падыйшлі грамадою, ");
INSERT INTO beln_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","але, угледзеўшы, аслупянелі; спалохаліся, збянтэжыліся. ");
INSERT INTO beln_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Дрыжаньне ахапіла іх, болі, як ў жанчыны, што нараджае. ");
INSERT INTO beln_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ты ветрам усходнім скрышыў караблі з Таршышу. ");
INSERT INTO beln_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Як чулі мы гэта, гэтак і бачылі ў горадзе ГОСПАДА Магуцьцяў, у горадзе Бога нашага. Бог умацаваў яго на вякі. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Мы разважаем, Божа, пра міласэрнасьць Тваю пасярод сьвятыні Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Як імя Тваё, Божа, так і хвала Твая — аж да ўзьмежкаў зямлі; правіца Твая напоўнена праведнасьцю. ");
INSERT INTO beln_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Весяліцца гара Сыён, радуюцца дочкі Юды дзеля судоў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Станьце наўкола Сыёну, абыйдзіце вакол яго, палічыце вежы ягоныя, ");
INSERT INTO beln_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","прылажыце сэрца сваё да валоў ягоных, агледзьце палацы ягоныя, каб абвясьціць пакаленьням, што будуць; ");
INSERT INTO beln_vpl VALUES ("PS48_15","020_48_15","PSA","48","15","15","што гэты Бог ёсьць наш Бог на вякі вечныя, і Ён будзе весьці нас аж да сьмерці. ");
INSERT INTO beln_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Кіраўніку хору. Сыноў Караха. Псальм. ");
INSERT INTO beln_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Чуйце гэта, усе народы! Прыхіліце вуха, усе жыхары веку гэтага! ");
INSERT INTO beln_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Як сыны паспалітыя, так і сыны знакамітыя, разам багатыя і бедныя. ");
INSERT INTO beln_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Вусны мае кажуць мудрасьць, і думкі сэрца майго разважлівыя. ");
INSERT INTO beln_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Прыхілю да прыповесьці вуха маё, выяўлю пры гуках гусьляў загадку маю: ");
INSERT INTO beln_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Навошта мне баяцца ў дні няшчасьця, калі атачыла мяне беззаконьне напасьнікаў маіх, ");
INSERT INTO beln_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","якія спадзяюцца на сілу сваю і мноствам багацьця свайго хваляцца? ");
INSERT INTO beln_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Ніхто выбавіць брата ня можа і даць за яго выкуп Богу, ");
INSERT INTO beln_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","(Вельмі дарагая цана за іх душу, дык зрачыся гэтага мусіць навекі), ");
INSERT INTO beln_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","каб ён жыў назаўсёды і ня ўбачыў парахненьня. ");
INSERT INTO beln_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Бо кожны бачыць: мудрыя паміраюць, дурны і шалёны разам прападаюць, і пакідаюць іншым багацьце сваё. ");
INSERT INTO beln_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Думкі іхнія, што дамы іхнія на вякі, сялібы іхнія — з пакаленьня ў пакаленьне, і яны сваім імем назвалі цэлыя землі. ");
INSERT INTO beln_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Але чалавек у славе доўга трываць ня будзе, ён падобны да скаціны, што на зарэз. ");
INSERT INTO beln_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Гэткі шлях іхні, тых, што пэўныя сябе, і тых, у вуснах чыіх яны даспадобы. (Сэлях). ");
INSERT INTO beln_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Як авечкі, у пекла яны зыйдуць, сьмерць пасьвіць іх будзе, і раніцаю правыя будуць мець уладу над імі, сіла іхняя ссохне, пекла — жытло іхняе. ");
INSERT INTO beln_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Але Бог выбавіць душу маю з рукі пекла, бо Сам возьме мяне. (Сэлях). ");
INSERT INTO beln_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ня бойся, калі хто багацее, калі множыцца слава дому ягонага: ");
INSERT INTO beln_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","бо, калі памрэ, нічога ня возьме з сабою, і слава ягоная ня пойдзе за ім. ");
INSERT INTO beln_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Хоць бы за жыцьця свайго душу сваю ён дабраслаўляў, і хвалілі яго, калі добра рабіў для сябе, ");
INSERT INTO beln_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","ён пойдзе за пакаленьнем бацькоў сваіх, што ня ўбачаць ніколі сьвятла. ");
INSERT INTO beln_vpl VALUES ("PS49_21","020_49_21","PSA","49","21","21","Чалавек у славе і без разуменьня падобны да скаціны, што на зарэз. ");
INSERT INTO beln_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Псальм Асафа. Бог багоў, ГОСПАД прамовіў і кліча зямлю ад усходу сонца да захаду яго. ");
INSERT INTO beln_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","З Сыёну, вяршыні прыгажосьці, зазьзяў Бог. ");
INSERT INTO beln_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Прыйдзе Бог наш і ня будзе маўчаць, перад абліччам Ягоным агонь палючы, навакол Яго – бура вялізарная. ");
INSERT INTO beln_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ён кліча неба, што ўверсе, і зямлю на суд народу Свайго: ");
INSERT INTO beln_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Зьбярыце да Мяне багабойных Маіх, якія заключылі запавет са Мною пры ахвяры!” ");
INSERT INTO beln_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","І будуць тады нябёсы апавядаць справядлівасьць Ягоную, бо Сам Бог ёсьць Судзьдзя. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Слухай, народзе Мой, і Я буду гаварыць. Ізраілю, Я буду сьведчыць супраць цябе. Бог, твой Бог, — гэта Я! ");
INSERT INTO beln_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Не за ахвяры твае буду вінаваціць цябе: цэласпаленьні твае перада Мною заўсёды! ");
INSERT INTO beln_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Не вазьму Я быкоў з дому твайго, ані казлоў з абораў тваіх, ");
INSERT INTO beln_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","бо Мае ўсе зьвяры лясныя і скаціна, што тысячамі ходзіць па горах. ");
INSERT INTO beln_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Я ведаю ўсе птушкі ў гарах, і зьвяры палявыя перада Мною. ");
INSERT INTO beln_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Калі б Я згаладаўся, табе б Я не сказаў, бо Мой сусьвет і што напаўняе яго. ");
INSERT INTO beln_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Ці ж Я ем мяса валоў і п’ю кроў казлоў? ");
INSERT INTO beln_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ахвяруй падзяку Богу, і споўні перад Найвышэйшым абяцаньні твае. ");
INSERT INTO beln_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","І кліч Мяне ў дзень трывогі, Я выратую цябе, і будзеш ушаноўваць Мяне. ");
INSERT INTO beln_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","А да бязбожніка сказаў Бог: “Навошта ты пералічваеш пастановы Мае, узьнімаеш запавет Мой да вуснаў тваіх, ");
INSERT INTO beln_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","і ненавідзіш настаўленьне, і словы Мае за сябе кідаеш? ");
INSERT INTO beln_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Калі бачыш злодзея, маеш упадабаньне ў ім, і з чужаложнікамі частка твая. ");
INSERT INTO beln_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Вусны свае расчыняеш на злое, і язык твой кнуе падступнае. ");
INSERT INTO beln_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ты сядзіш і супраць брата твайго гаворыш, абмаўляеш сына маці тваёй. ");
INSERT INTO beln_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Гэтак ты рабіў, а Я маўчаў. Дык здалося табе, што Я такі самы, як ты! Але Я буду караць цябе і пастаўлю твае справы перад вачыма тваімі”. ");
INSERT INTO beln_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Зважайце цяпер на гэта вы, што Бога забываеце, каб Я не схапіў вас, бо ня будзе каму вызваліць. ");
INSERT INTO beln_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Хто ахвяруе падзяку, той ушаноўвае Мяне, і хто парадкуе шлях свой, таму Я пакажу збаўленьне Божае. ");
INSERT INTO beln_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Кіраўніку хору: псальм Давіда, ");
INSERT INTO beln_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","калі прарок Натан прыйшоў да яго пасьля таго, як ён увайшоў да Батшэбы. ");
INSERT INTO beln_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Зьлітуйся нада мною, Божа, паводле міласэрнасьці Тваёй, і праз вялікую літасьць Тваю даруй правіны мае! ");
INSERT INTO beln_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Абмый мяне ўсяго ад беззаконьня майго і ачысьці мяне ад грэху майго. ");
INSERT INTO beln_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Бо я ведаю правіну маю, і грэх мой заўсёды перада мною. ");
INSERT INTO beln_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Супраць Цябе, толькі супраць Цябе саграшыў я і ліхое ўчыніў перад вачыма Тваімі, бо Ты праведны ў словах Тваіх і чысты ў судзе Тваім. ");
INSERT INTO beln_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Вось, я ў беззаконьні нарадзіўся, і ў грэху зачала мяне маці мая. ");
INSERT INTO beln_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Вось, Табе даспадобы праўда ў нутры, дык дай мне пазнаць мудрасьць у сэрцы маім. ");
INSERT INTO beln_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Акрапі мяне ізопам, каб я ачысьціўся; абмый мяне, каб я стаўся бялейшым за сьнег. ");
INSERT INTO beln_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Дай мне пачуць радасьць і вясёласьць, каб узьвесяліліся косткі, якія Ты скрышыў. ");
INSERT INTO beln_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Адвярні аблічча Тваё ад грахоў маіх і даруй мне ўсе беззаконьні мае. ");
INSERT INTO beln_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Сэрца чыстае ствары ў-ва мне, Божа, і дух упэўнены аднаві ў-ва мне. ");
INSERT INTO beln_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Не адкінь Ты мяне ад аблічча Твайго і Духа сьвятога Твайго не забірай у мяне! ");
INSERT INTO beln_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Вярні мне радасьць збаўленьня Твайго, і духам шляхетным падтрымай мяне, ");
INSERT INTO beln_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","і я буду навучаць адступнікаў шляхам Тваім, і грэшнікі вернуцца да Цябе. ");
INSERT INTO beln_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Вызваль мяне ад віны за кроў, Божа, Бог выратаваньня майго, і язык мой будзе крычаць пра справядлівасьць Тваю. ");
INSERT INTO beln_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Адчыні, Госпадзе, вусны мае, і вусны мае будуць абвяшчаць хвалу Тваю. ");
INSERT INTO beln_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Бо Ты не жадаеш ахвяраў, хоць бы я іх даў, і цэласпаленьні не даспадобы Табе. ");
INSERT INTO beln_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ахвяра для Бога — скрышаны дух; сэрцам скрышаным і зламаным Ты, Божа, не пагарджаеш! ");
INSERT INTO beln_vpl VALUES ("PS51_20","020_51_20","PSA","51","20","20","Рабі добрае Сыёну паводле ласкі Тваёй, збудуй муры Ерусаліму. ");
INSERT INTO beln_vpl VALUES ("PS51_21","020_51_21","PSA","51","21","21","Тады будуць Табе даспадобы ахвяры праведнасьці, цэласпаленьні і ахвяры дасканалыя; тады быкоў узьнясуць на ахвярнік Твой. ");
INSERT INTO beln_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Кіраўніку хору. Навучаньне Давіда, ");
INSERT INTO beln_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","калі прыйшоў Даэг Эдомец, і паведаміў Саўлу, і сказаў яму: “Давід прыйшоў у дом Абімэлеха”. ");
INSERT INTO beln_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Навошта хвалішся злачынствам, волаце? Міласэрнасьць Божая кожны дзень трывае! ");
INSERT INTO beln_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Загубу выдумляе язык твой; як брытва вострая той, які здраду ўчыняе! ");
INSERT INTO beln_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Ты любіш ліхое больш, чым добрае; хлусьню гаворыш, а ня тое, што праведнае. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Любіш усе словы шкадлівыя, о, язык падступны. ");
INSERT INTO beln_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Дзеля гэтага Бог скрышыць цябе назаўсёды, схопіць цябе, і вырве цябе з намёту, і выкараніць цябе з зямлі жывых. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","І ўбачаць праведнікі, і будуць баяцца, і будуць сьмяяцца з яго: ");
INSERT INTO beln_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","“Вось чалавек, што ня Бога меў сабе апорай, і спадзяваўся на мноства багацьця свайго і ўмацоўваўся ў сваёй зласьлівасьці”. ");
INSERT INTO beln_vpl VALUES ("PS52_10","020_52_10","PSA","52","10","10","А я, як аліўка зялёная ў доме Божым, спадзяюся на міласэрнасьць Божую на вякі вечныя. ");
INSERT INTO beln_vpl VALUES ("PS52_11","020_52_11","PSA","52","11","11","Буду славіць Цябе на вякі за тое, што Ты ўчыніў, і буду спадзявацца на імя Тваё, бо Ты добры адносна багабойных Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Кіраўніку хору: на лад сумны. Навучаньне Давіда. ");
INSERT INTO beln_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Сказаў бязглузды ў сэрцы сваім: “Няма Бога! Сапсаваліся яны і агідныя рэчы робяць, няма таго, хто робіць дабро. ");
INSERT INTO beln_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Бог глянуў з неба на сыноў чалавечых, каб пабачыць, ці ёсьць разумны, які Бога шукае. ");
INSERT INTO beln_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Усе адступіліся, усе разам нягодныя; няма нікога, хто робіць дабро, няма аніводнага! ");
INSERT INTO beln_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Няўжо ня маюць пазнаньня ўсе злачынцы, якія народ мой зьядаюць, быццам хлеб ядуць, і Бога ня клічуць? ");
INSERT INTO beln_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Там яны будуць у страху вялікім, дзе няма страху, бо Бог раскідае косткі тых, якія паставілі табар супраць цябе, і ты асароміш іх, бо Бог іх адкінуў. ");
INSERT INTO beln_vpl VALUES ("PS53_7","020_53_7","PSA","53","7","7","Хто дасьць збаўленьне з Сыёну для Ізраіля? Калі Бог верне палон народу Свайго, будзе радавацца Якуб і будзе весяліцца Ізраіль! ");
INSERT INTO beln_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Кіраўніку хору: на струнных інструмэнтах. Навучаньне Давіда, ");
INSERT INTO beln_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","калі прыйшлі Зіфеі і сказалі Саўлу: “Ці ж гэта не Давід схаваўся у нас? ");
INSERT INTO beln_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Божа, імем Тваім збаў мяне, і магутнасьцю Тваёю вядзі справу маю! ");
INSERT INTO beln_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Божа, пачуй малітву маю, прыхілі вуха да словаў вуснаў маіх! ");
INSERT INTO beln_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Бо чужынцы паўсталі супраць мяне, і моцныя шукаюць душы маёй; яны ня маюць Бога перад сабою. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Вось, Бог – дапамога мая; Госпад падтрымлівае душу маю. ");
INSERT INTO beln_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Зьвяртаючыся, зьвернецца ліха на ворагаў маіх. У праўдзе Тваёй Ты вынішчы іх! ");
INSERT INTO beln_vpl VALUES ("PS54_8","020_54_8","PSA","54","8","8","Тады ахвотна буду ахвяроўваць Табе; буду славіць імя Тваё, ГОСПАДЗЕ, бо Ты – добры! ");
INSERT INTO beln_vpl VALUES ("PS54_9","020_54_9","PSA","54","9","9","Бо Ты вызваліў мяне ад усіх трывогаў, і на загубу ворагаў маіх глядзелі вочы мае. ");
INSERT INTO beln_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Кіраўніку хору: на струнных інструмэнтах. Навучаньне Давіда. ");
INSERT INTO beln_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Прыхілі вуха, Божа, да малітвы маёй і не хавайся ад маленьня майго! ");
INSERT INTO beln_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Зваж на мяне і адкажы мне; я стогну ў тузе маёй і енчу ");
INSERT INTO beln_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","ад голасу ворага, ад уціску бязбожніка, бо злачынства закідаюць мне і ў гневе змагаюцца са мною. ");
INSERT INTO beln_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Сэрца маё трапеча ў-ва мне, і жахі сьмерці напалі на мяне; ");
INSERT INTO beln_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","страх і дрыжаньне прыйшлі на мяне, і трывога ахапіла мяне. ");
INSERT INTO beln_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","І я сказаў: “Хто дасьць мне крылы, як у голуба! Я паляцеў бы і супачыў! ");
INSERT INTO beln_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Вось, уцёк бы далёка і жыў бы ў пустыні. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Я б сьпяшаўся, каб схавацца перад ветра віхурай, перад бурай! ");
INSERT INTO beln_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Вынішчы іх, Госпадзе, падзялі мову ім, бо я бачыў крыўды і спрэчкі ў горадзе. ");
INSERT INTO beln_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Дзень і ноч яны ходзяць па мурах ягоных наўкола, злачынства і ліхоцьце ў сярэдзіне яго. ");
INSERT INTO beln_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Загуба ў сярэдзіне яго, і не зыходзяць з плошчаў ягоных ашуканства і здрада. ");
INSERT INTO beln_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Бо ня вораг мяне зьневажае, я дараваў бы гэта — ня той, што мяне ненавідзіць, узьвялічаецца супраць мяне, ад яго б я схаваўся, ");
INSERT INTO beln_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","але ты, чалавек, як я, сябра мой і знаёмы мой, ");
INSERT INTO beln_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","з якім мы разам вялі шчырыя гутаркі, з якім у дом Божы хадзілі у грамадзе. ");
INSERT INTO beln_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Няхай зьнішчаючы, зьнішчыць іх сьмерць! Няхай зыйдуць жывыя ў пекла, бо ліхота жыве ў вандраваньні іхнім, у нутры іхнім. ");
INSERT INTO beln_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","А Я буду клікаць да Бога, і ГОСПАД збавіць мяне. ");
INSERT INTO beln_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Увечары, і раніцаю, і ў белы дзень я буду енчыць і галасіць, і Ён пачуе голас мой. ");
INSERT INTO beln_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Ён выбавіць душу маю, каб даць супакой ад тых, што варагуюць супраць мяне, бо шмат было тых, якія супраць мяне. ");
INSERT INTO beln_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Пачуе Бог, і ўпакорыць іх Той, Які жыве спрадвеку. (Сэлях.) Бо няма ў іх паправы, і яны не баяцца Бога, ");
INSERT INTO beln_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","руку сваю выцягваюць на тых, што з імі ў супакоі жылі, і парушаюць запавет свой; ");
INSERT INTO beln_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","гладкія, як тое масла, вусны ягоныя, а ў сэрцы — варожасьць; словы ягоныя лагаднейшыя за алей, але яны — мячы аголеныя. ");
INSERT INTO beln_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Ускладзі бярэмя тваё на ГОСПАДА, і Ён паклапоціцца пра цябе; ня дасьць Ён ніколі, каб пахіснуўся праведнік. ");
INSERT INTO beln_vpl VALUES ("PS55_24","020_55_24","PSA","55","24","24","І Ты, Божа, іх кінеш у ямы парахненьня; людзі крыважэрныя і падступныя не дажывуць паловы дзён сваіх. А я на Цябе спадзяюся! ");
INSERT INTO beln_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Кіраўніку хору: на лад “Галубка бязмоўная ў мясьцінах далёкіх”. Залатая песьня Давіда, калі яго ў Гаце схапілі Філістынцы. ");
INSERT INTO beln_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Зьлітуйся нада мною, Божа, бо прагне праглынуць мяне чалавек; ўсякі дзень нападаючы, уціскае мяне. ");
INSERT INTO beln_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Прагнуць праглынуць мяне ворагі мае цэлы дзень, бо шмат іх ваюе супраць мяне, Найвышэйшы! ");
INSERT INTO beln_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","У дзень, калі я баюся, я на Цябе спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","У Богу буду хваліцца словам Ягоным, на Бога я спадзяюся, ня буду баяцца. Што цела можа зрабіць мне? ");
INSERT INTO beln_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Штодзень яны перакручваюць словы мае; супраць мяне ўсе думкі іхнія, каб учыніць мне зло. ");
INSERT INTO beln_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Яны зьбіраюцца і хаваюцца, яны высочваюць сьляды мае, бо цікуюць на душу маю. ");
INSERT INTO beln_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Дзеля злачынства іхняга будзь выратаваньнем для мяне, у гневе Тваім адкінь народы, Божа! ");
INSERT INTO beln_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Туляньне маё Ты мне залічыў; зьбяры сьлёзы мае ў мяхі Твае, напэўна яны ў кнізе Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Тады павернуць наўцёкі ворагі мае ў дзень, калі паклічу. Я ведаю, што Бог са мною! ");
INSERT INTO beln_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","У Богу буду хваліцца словам, у ГОСПАДЗЕ буду хваліцца словам Ягоным. ");
INSERT INTO beln_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","На Бога я спадзяюся, ня буду баяцца. Што можа зрабіць мне чалавек? ");
INSERT INTO beln_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","На мне, Божа, абяцаньні Твае, дык прынясу падзяку Табе, ");
INSERT INTO beln_vpl VALUES ("PS56_14","020_56_14","PSA","56","14","14","бо Ты вызваліў душу маю ад сьмерці і стопы мае ад падзеньня, каб хадзіў я перад абліччам Бога ў сьвятле жывых. ");
INSERT INTO beln_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Кіраўніку хору: на лад: “Не загубляй!” Залатая песьня Давіда, калі ён уцякаў ад аблічча Саўла ў пячору. ");
INSERT INTO beln_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Зьлітуйся нада мною, Божа, зьлітуйся нада мною! Бо ў Табе мае надзею душа мая і ў ценю крылаў Тваіх буду хавацца, пакуль не міне загуба. ");
INSERT INTO beln_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Буду клікаць да Бога Найвышэйшага, да Бога, Які выканае справу маю для мяне. ");
INSERT INTO beln_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ён спашле з неба і збавіць мяне ад зьнявагаў таго, хто хоча мяне праглынуць. (Сэлях) Спашле Бог міласэрнасьць Сваю і праўду Сваю. ");
INSERT INTO beln_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Душа мая між ільвоў, я ляжу сярод тых, што палаюць агнём, сярод сыноў чалавечых, зубы іхнія — дзіды і стрэлы, языкі іхнія — мячы вострыя. ");
INSERT INTO beln_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Узьвялічся па-над неба, Божа, па-над ўсёй зямлёй няхай будзе слава Твая. ");
INSERT INTO beln_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Яны наставілі сетку дзеля стопаў маіх, прыгнялі душу маю, яны капалі яму перад абліччам маім, але самі ўваліліся ў яе. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Умацаванае сэрца маё, Божа, умацаванае сэрца маё, буду сьпяваць і выслаўляць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Збудзіся, слава мая! Збудзіцеся, псалтыр і гусьлі! Я пабуджу сьвітаньне. ");
INSERT INTO beln_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Буду славіць Цябе сярод людзей, Госпадзе, буду выслаўляць Цябе сярод народаў, ");
INSERT INTO beln_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","бо аж да неба вялікая міласэрнасьць Твая, і праўда Твая — да аблокаў. ");
INSERT INTO beln_vpl VALUES ("PS57_12","020_57_12","PSA","57","12","12","Узьвялічся па-над неба, Божа, па-над ўсёй зямлёй няхай будзе слава Твая! ");
INSERT INTO beln_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Кіраўніку хору: на лад: “Не загубляй!” Залатая песьня Давіда. ");
INSERT INTO beln_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Ці сапраўды маўчаньнем прамаўляеце праведна? Ці справядліва судзіце сыноў чалавечых? ");
INSERT INTO beln_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Але ж у сэрцы беззаконьне вы ўчынілі, злачынствы рук вашых на зямлі ўзважваеце. ");
INSERT INTO beln_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Адступіліся бязбожнікі ад улоньня маці, блукаюць ад нараджэньня тыя, што кажуць няпраўду. ");
INSERT INTO beln_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Атрута іхняя як атрута зьмяі, гадзюкі глухой, што вушы свае затыкае ");
INSERT INTO beln_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","і ня чуе голасу шаптуна, які заклінаць закляцьцямі ўмее. ");
INSERT INTO beln_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Божа, скрышы зубы іхнія ў вуснах іхніх! Выбі іклы львянятам, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Няхай зьнікнуць яны як вада, што разьлілася; няхай як будуць нацягваць лук, паломяцца стрэлы іхнія! ");
INSERT INTO beln_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Няхай як сьлімак, што ледзьве паўзе, яны счэзнуць! Няхай як спарон жанчыны яны сонца ня ўбачаць! ");
INSERT INTO beln_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Перш, чым катлы вашыя адчуюць агонь ад цярніны, няхай раскідае бура цярніну, ці сьвежую, ці распаленую. ");
INSERT INTO beln_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Узрадуецца праведнік, калі ўбачыць помсту; ён абмые стопы свае ў крыві бязбожнікаў! ");
INSERT INTO beln_vpl VALUES ("PS58_12","020_58_12","PSA","58","12","12","І скажа кожны чалавек: “Сапраўды, ёсьць плод у праведніка! Сапраўды, ёсьць Бог, Які судзіць на зямлі!” ");
INSERT INTO beln_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Кіраўніку хору: на лад “Не загубляй!” Залатая песьня Давіда, калі Саўл паслаў пільнаваць дом ягоны, каб яго забіць. ");
INSERT INTO beln_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Выратуй мяне ад ворагаў маіх, Божа мой! Ад тых, што паўстаюць супраць мяне, абарані мяне. ");
INSERT INTO beln_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Выратуй мяне ад злачынцаў і збаў мяне ад людзей крывавых. ");
INSERT INTO beln_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Бо вось, яны пільнуюць у засадзе душу маю, зьбіраюцца супраць мяне моцныя, і не за правіну маю, і не за грэх мой, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Без ніякай віны маёй яны зьбягаюцца і шыхтуюцца супраць мяне. Збудзіся, выйдзі на спатканьне мне і паглядзі! ");
INSERT INTO beln_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ты Сам, ГОСПАДЗЕ, Бог Магуцьцяў, Бог Ізраіля, абудзіся, каб наведаць усе народы! Ня мей літасьці для ўсіх ліхадзеяў і злачынцаў! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Увечары яны вяртаюцца, выюць, быццам сабакі, і горад абыходзяць наўкола. ");
INSERT INTO beln_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Вось, пена спадае з іхніх вуснаў, у губах іхніх — мячы, бо хто гэта чуе? ");
INSERT INTO beln_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Але Ты, ГОСПАДЗЕ, будзеш сьмяяцца з іх, Ты будзеш кпіць з усіх паганаў! ");
INSERT INTO beln_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Моц Тваю буду шукаць у Табе, бо Бог — умацаваны замак мой! ");
INSERT INTO beln_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Бог, Які міласэрны да мяне, у міласэрнасьці Сваёй сустрэне мяне; Бог дасьць мне ўгледзець перамогу над ворагамі маімі. ");
INSERT INTO beln_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Не забівай іх, каб не забыўся народ мой! Захістай іх сілаю Тваёй і павалі іх, Госпадзе, шчыце наш! ");
INSERT INTO beln_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Грэх вуснаў іхніх — словы на губах іхніх. Няхай злоўлены будуць у фанабэрыстасьці сваёй за праклёны і ману, што абвяшчаюць. ");
INSERT INTO beln_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Зьнішчы іх у ярасьці, зьнішчы, няхай іх ня будзе, і няхай ведаюць, што Бог у Якубе пануе да канцоў зямлі! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Увечары яны вяртаюцца, выюць, быццам сабакі, і горад абыходзяць наўкола. ");
INSERT INTO beln_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Бадзяючыся, бадзяюцца яны, каб што зьесьці; і не насыціўшыся, будуць жыць. ");
INSERT INTO beln_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","А я буду сьпяваць пра моц Тваю і раніцаю буду радавацца дзеля міласэрнасьці Тваёй, бо Ты стаўся для мяне ўмацаваным замкам і прытулкам у дзень уціску майго. ");
INSERT INTO beln_vpl VALUES ("PS59_18","020_59_18","PSA","59","18","18","Сіла мая, Цябе буду выслаўляць, бо Ты, Божа — умацаваны замак мой, Бог мой міласэрны! ");
INSERT INTO beln_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Кіраўніку хору: на лад: “Лілея сьведчаньня”. Залатая песьня Давіда. Дзеля навучаньня, ");
INSERT INTO beln_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","калі ён змагаўся з Арам-Нагараім і з Арам-Цова, і калі Ёаў, варочаючыся, пабіў Эдом у Саляной даліне, дванаццаць тысячаў. ");
INSERT INTO beln_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Божа, Ты нас пакінуў, нас раструшчыў! Ты разгневаўся, вярніся зноў да нас! ");
INSERT INTO beln_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Ты затрос зямлёю, расшчапіў яе; вылячы разломы ейныя, бо яна хістаецца! ");
INSERT INTO beln_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ты даў убачыць народу Твайму цяжкую долю, напаіў нас віном зьбянтэжаннасьці. ");
INSERT INTO beln_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Тым, што баяцца Цябе, Ты даў знак, каб уцяклі ад аблічча луку. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Каб былі ўратаваныя ўмілаваныя Твае, збаў правіцай Тваёй і адкажы нам, і адкажы мне. ");
INSERT INTO beln_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Бог сказаў у сьвятасьці Сваёй: “Я ўзрадуюся! Я падзялю Сыхэм, і даліну Сукот разьмераю. ");
INSERT INTO beln_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Мой Гілеад, і Мой Манаса, і Эфраім — моц галавы Маёй; Юда — заканадаўца Мой! ");
INSERT INTO beln_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Мааў — міса для мыцьця Майго; на Эдом кіну сандалы Мае, радасна гукай дзеля Мяне, зямля Філістынская”. ");
INSERT INTO beln_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Хто ўвядзе мяне ў горад умацаваны? Хто завядзе мяне ў Эдом? ");
INSERT INTO beln_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Ці ж ня Ты, Божа, нас пакінуў і не выходзіш, Божа, з войскамі нашымі? ");
INSERT INTO beln_vpl VALUES ("PS60_13","020_60_13","PSA","60","13","13","Дай нам успамогу ў прыгнечаньні нашым, бо марны ратунак чалавечы. ");
INSERT INTO beln_vpl VALUES ("PS60_14","020_60_14","PSA","60","14","14","З Богам мы зьявім сілу, і Ён растопча прыгнятальнікаў нашых. ");
INSERT INTO beln_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Кіраўніку хору: на струнных інструмэнтах. Давіда. ");
INSERT INTO beln_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Пачуй, Божа, галашэньне маё, зваж на малітву маю! ");
INSERT INTO beln_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ад краю зямлі да Цябе клічу, калі зьнемагае сэрца маё; на скалу, што ўзвышаецца нада мною, узьвядзі мяне! ");
INSERT INTO beln_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Бо Ты быў прыстанішчам маім, вежай моцы маёй супраць ворага. ");
INSERT INTO beln_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Буду жыць у намёце Тваім вечна, маю надзею пад заслонаю крылаў Тваіх. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Бо Ты, Божа, чуў абяцаньні мае, Ты даў валоданьне тым, што баяцца імя Твайго. ");
INSERT INTO beln_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Дадай дні да дзён валадара, няхай гады яго будуць з пакаленьня ў пакаленьне, ");
INSERT INTO beln_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Няхай жыве вечна перад абліччам Божым; прызнач міласэрнасьць і праўду, каб захоўвалі яго! ");
INSERT INTO beln_vpl VALUES ("PS61_9","020_61_9","PSA","61","9","9","Дык буду выслаўляць імя Тваё на вякі, буду спаўняць абяцаньні мае кожны дзень. ");
INSERT INTO beln_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Кіраўніку хору: на лад Едутуна. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Толькі ў Богу супакойваецца душа мая, ад Яго збаўленьне маё. ");
INSERT INTO beln_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Толькі Ён – скала мая і збаўленьне маё, умацаваны замак мой, дык я не пахіснуся. ");
INSERT INTO beln_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Як доўга будзеце насядаць на чалавека? Вы ўсе хочаце забіць яго, як тая сьцяна, што скранулася, як агароджа, што валіцца. ");
INSERT INTO beln_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Яны толькі і радзяцца, як скінуць яго з высакосьці; ім даспадобы няпраўда; яны вуснамі дабраслаўляюць, але ў нутры сваім праклінаюць! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Толькі ў Богу супачынеш, душа мая, бо на Яго спадзяваньне маё. ");
INSERT INTO beln_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Толькі Ён — скала мая і збаўленьне маё, умацаваны замак мой, дык не пахіснуся. ");
INSERT INTO beln_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","У Богу збаўленьне маё і слава мая; скала моцы маёй, прыстанішча маё ў Богу. ");
INSERT INTO beln_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","На Яго спадзявайся ў кожную часіну, народзе! Вылівайце перад абліччам Ягоным сэрцы вашыя, бо Бог — прыстанішча нашае. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Сыны чалавечыя — толькі марнасьць, сыны людзкія — няпраўда; калі пакладзеш іх на шалі, яны разам лягчэй за марнасьць! ");
INSERT INTO beln_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Не спадзявайцеся на крыўду, не марнейце ў зрабаваным, калі вам памножыцца багацьце, сэрца свайго да яго не прыкладайце! ");
INSERT INTO beln_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Раз сказаў Бог, а я двойчы пачуў гэта, што сіла — у Бога. ");
INSERT INTO beln_vpl VALUES ("PS62_13","020_62_13","PSA","62","13","13","І ў Цябе міласэрнасьць, Госпадзе, бо Ты даеш чалавеку паводле ўчынкаў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Псальм Давіда, калі ён быў у пустыні Юдэйскай. ");
INSERT INTO beln_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Божа! Ты — Бог мой! Цябе я шукаю, Цябе прагне душа мая, па Табе тужыць цела маё ў сухой і спрагнёнай зямлі, на бязводзьдзі. ");
INSERT INTO beln_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Гэтак я ўглядаўся на Цябе ў сьвятасьці Тваёй, каб убачыць моц Тваю і славу Тваю. ");
INSERT INTO beln_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Бо міласэрнасьць Твая лепшая за жыцьцё; вусны мае хваліць Цябе будуць. ");
INSERT INTO beln_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Гэтак буду я дабраслаўляць Цябе ў жыцьці маім, у імя Тваё буду рукі мае ўзьнімаць. ");
INSERT INTO beln_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Быццам тлушчам і тлустасьцю насычаецца душа мая, і сьпевам хвалы будуць хваліць Цябе вусны мае, ");
INSERT INTO beln_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","калі я на ложку маім пра Цябе ўспамінаю, калі ў часе варты начной пра Цябе разважаю. ");
INSERT INTO beln_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Бо Ты быў успамогай мне, і ў ценю крылаў Тваіх буду весяліцца. ");
INSERT INTO beln_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Прыляпілася да Цябе душа мая, падтрымлівае мяне правіца Твая. ");
INSERT INTO beln_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","А тыя, што шукаюць загубы душы маёй, пойдуць у глыбіні зямлі, ");
INSERT INTO beln_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","будуць аддадзены яны ў рукі мяча, стануцца здабычай шакалаў. ");
INSERT INTO beln_vpl VALUES ("PS63_12","020_63_12","PSA","63","12","12","І валадар узрадуецца ў Богу; і будзе хваліцца кожны, хто Ім прысягае, бо будуць заткнёныя вусны таго, хто гаворыць хлусьню. ");
INSERT INTO beln_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Пачуй, Божа, голас мой у смутку маім! Ад страху перад ворагам захавай жыцьцё маё! ");
INSERT INTO beln_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Схавай мяне ад таемных намераў злачынцаў, ад грамады тых, што чыняць нягоднае, ");
INSERT INTO beln_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","якія навастрылі як меч язык свой, нацягнулі лук са стрэламі сваімі — горкімі словамі, ");
INSERT INTO beln_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","каб страляць з засады ў беззаганнага; зьнянацку страляюць яны ў яго і не баяцца. ");
INSERT INTO beln_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Яны ўмацоўваюць сябе ў справах ліхіх; змаўляюцца пастку наставіць таемна; яны кажуць: “Хто гэта ўбачыць?” ");
INSERT INTO beln_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Яны шукаюць беззаконьня, мы гінем праз задумы беззаконныя! Бо нутро чалавека і сэрца — глыбокія воды. ");
INSERT INTO beln_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","І стрэліць Бог у іх стралою, зьнянацку атрымалі яны ўдар, ");
INSERT INTO beln_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","і яны спатыкнуліся праз язык свой; і ўцякаюць усе, хто іх убачыў. ");
INSERT INTO beln_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","І будуць баяцца ўсе людзі, і будуць апавядаць пра справы Божыя і будуць разважаць пра тое, што Ён учыніў. ");
INSERT INTO beln_vpl VALUES ("PS64_11","020_64_11","PSA","64","11","11","Узрадуецца праведнік у ГОСПАДЗЕ і будзе мець надзею ў Ім, і будуць хваліць Яго ўсе шчырыя сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Кіраўніку хору. Псальм Давіда. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Табе, Божа, прыналежыць хвала на Сыёне; і Табе будуць споўненыя абяцаньні. ");
INSERT INTO beln_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Ты чуеш малітву, да Цябе ўсякае цела імкнецца. ");
INSERT INTO beln_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Справы беззаконныя перамаглі мяне, але Ты дараваў нам правіны нашыя. ");
INSERT INTO beln_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Шчасьлівы той, каго Ты выбраў і наблізіў, каб жыў ён на панадворках Тваіх; мы будзем насычацца даброцьцем дому Твайго, сьвятой сьвятыні Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Страшнымі ўчынкамі у праведнасьці Ты адказваеш нам, Божа збаўленьня нашага, пэўнасьць усіх канцоў зямлі і далёкага мора, ");
INSERT INTO beln_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Які ўгрунтаваў горы сілаю Сваёй, Які падперазаны магутнасьцю, ");
INSERT INTO beln_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Які ўсьцішаеш шум мора, шум хваляў ягоных і мноства народу. ");
INSERT INTO beln_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","І будуць баяцца знакаў Тваіх жыхары канцоў сьвету, землі на ўсходзе і на захадзе Ты разьвесяляеш. ");
INSERT INTO beln_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ты адведаў зямлю і напаіў яе, Ты ўзбагаціў яе Божым струмянём, напоўненым водамі. Ты прыгатаваў збожжа на ёй, бо гэтак угрунтаваў яе. ");
INSERT INTO beln_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ты насычаеш разоры яе і разраўноўваеш скібы яе, кроплямі дажджу разьмякчаеш яе, парастак яе дабраслаўляеш. ");
INSERT INTO beln_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Ты ўкаранаваў год дабром Тваім, і сьцежкі Твае разьліваюць тлустасьць, ");
INSERT INTO beln_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","разьліваюць на пашы ў пустыні, і ўзгоркі падпярэзваюцца радасьцю, ");
INSERT INTO beln_vpl VALUES ("PS65_14","020_65_14","PSA","65","14","14","апранаюцца ў чароды авечак, і даліны атуляюцца збожжам, радасна гукаюць і сьпяваюць. ");
INSERT INTO beln_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Кіраўніку хору. Сьпеў. Псальм. Радасна гукай для Бога, уся зямля! ");
INSERT INTO beln_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Выслаўляйце славу імя Ягонага, узносьце славу і хвалу Яму! ");
INSERT INTO beln_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Кажыце да Бога: “Які Ты страшны ў дзеяньнях Тваіх! Дзеля вялікасьці моцы Тваёй падпарадкоўваюцца Табе ворагі Твае. ");
INSERT INTO beln_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Уся зямля паклоніцца Табе і будзе выслаўляць Цябе, будзе выслаўляць імя Тваё. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Хадзеце і паглядзіце на дзеі Бога, страшнага ў дзеях Сваіх адносна сыноў чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Ён перамяніў мора ў сухазем’е, праз раку перайшлі пехатою; там радаваліся мы ў Ім! ");
INSERT INTO beln_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ён пануе ў магутнасьці Сваёй на вякі; вочы Ягоныя сочаць за народамі, каб бунтаўнікі не вывышаліся перад Ім. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Дабраслаўляйце, народы, Бога нашага, і няхай будзе чутны голас хвалы Ягонай. ");
INSERT INTO beln_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Ён дараваў жыцьцё душы нашай і ня даў пахіснуцца назе нашай. ");
INSERT INTO beln_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Бо Ты выспрабаваў нас, Божа! Ачысьціў нас, як ачышчаецца срэбра. ");
INSERT INTO beln_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ты ўвёў нас у пастку, сьціснуў цяжкімі путамі сьцёгны нашыя. ");
INSERT INTO beln_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ты пасадзіў чалавека на галовы нашыя; мы прайшлі праз агонь і ваду, і Ты вывеў нас на прастор. ");
INSERT INTO beln_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Увайду ў дом Твой з цэласпаленьнямі, споўню Табе абяцаньні мае, ");
INSERT INTO beln_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","якія прамовілі губы мае, і сказаў я вуснамі маімі ў бядзе маёй. ");
INSERT INTO beln_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Цэласпаленьні з тлустых авечак прынясу Табе з дымам баранаў; дам Табе валоў і казлоў. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Хадзеце, паслухайце, і я раскажу ўсім, хто Бога баіцца, што Ён учыніў для душы маёй. ");
INSERT INTO beln_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Да Яго я клікаў вуснамі маімі, і ўзьвялічваньне было на языку маім. ");
INSERT INTO beln_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Калі б я глядзеў на нягоднае ў сэрцы маім, Госпад мяне б не пачуў! ");
INSERT INTO beln_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Але Бог пачуў і зьвярнуў увагу Сваю на голас малітвы маёй. ");
INSERT INTO beln_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Дабраслаўлёны Бог, Які не адкінуў малітвы маёй і міласэрнасьці Сваёй не пазбавіў мяне! ");
INSERT INTO beln_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Кіраўніку хору: на струнных інструмэнтах. Псальм. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Божа, зьлітуйся над намі і дабраславі нас; асьвяці нас абліччам Тваім, (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","каб на зямлі мы пазналі шлях Твой, між усімі народамі — збаўленьне Тваё. ");
INSERT INTO beln_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Тады будуць славіць народы Цябе, Божа, будуць славіць Цябе ўсе народы. ");
INSERT INTO beln_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Будуць весяліцца і радавацца ўсе народы, бо Ты будзеш судзіць народы справядліва і будзеш весьці народы на зямлі. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Тады будуць славіць народы Цябе, Божа, будуць славіць Цябе ўсе народы. ");
INSERT INTO beln_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Зямля дасьць ураджай свой; няхай дабраславіць нас Бог, Бог наш! ");
INSERT INTO beln_vpl VALUES ("PS67_8","020_67_8","PSA","67","8","8","Няхай дабраславіць нас Бог і няхай баяцца Яго ўсе канцы зямлі! ");
INSERT INTO beln_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Кіраўніку хору. Псальм Давіда. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Няхай паўстане Бог, і будуць расьцярушаныя ворагі Ягоныя, і ўцякуць перад абліччам Ягоным тыя, хто ненавідзіць Яго. ");
INSERT INTO beln_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Як разносіцца ветрам дым, так Ты разьвееш іх; як топіцца воск перад абліччам агню, так бязбожнікі загінуць перад абліччам Божым. ");
INSERT INTO beln_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","А праведнікі ўзрадуюцца, будуць весяліцца перад абліччам Божым і гукаць ад радасьці. ");
INSERT INTO beln_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Сьпявайце Богу, выслаўляйце імя Ягонае! Узьвялічвайце Таго, Які ўзносіцца па-над пустыняй, ГОСПАД — імя Яго, і радуйцеся перад абліччам Ягоным, ");
INSERT INTO beln_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Ён — Бацька сіротаў і Заступнік удоваў, Бог у сядзібе сьвятасьці Сваёй, ");
INSERT INTO beln_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Бог, Які пасяляе самотных у дамы, Які выводзіць вязьняў з путаў, але бунтаўнікоў пакідае ў пустыні сьпякотнай. ");
INSERT INTO beln_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Божа, калі Ты выходзіў перад народам Тваім, калі праходзіў праз пустыню, (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","зямля дрыжала, і нябёсы тапіліся перад абліччам Бога, і гэты Сыён дрыжаў перад абліччам Бога, Бога Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Шчодры дождж Ты выліў, Божа, на спадчыну Тваю, і тое, што зьнемаглося, Ты ўмацаваў. ");
INSERT INTO beln_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Жывыя Твае пасяліліся ў тым, што Ты ў добрасьці Тваёй уладкаваў для ўбогага, Божа. ");
INSERT INTO beln_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Госпад даў вестку, і тых, якія дабравесьцяць яе, — вялікае войска. ");
INSERT INTO beln_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Валадары з войскамі ўцякаюць, уцякаюць, а тая, што даглядае дом, дзеліць здабычу! ");
INSERT INTO beln_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Хоць вы ляжыце паміж абораў, вы сталіся, быццам галубка, у якой крылы пакрытыя срэбрам, а пер’е — золатам зелянявым. ");
INSERT INTO beln_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Калі Ўсемагутны расьцярушыў валадароў у ёй, яна сталася, як сьнег на Сальмоне. ");
INSERT INTO beln_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Гара Божая, гара Башан! Гара шматверхая, гара Башан. ");
INSERT INTO beln_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Чаму глядзіце з зайздрасьцю, горы шматверхія, на гару, на якой Бог пасяліцца пажадаў? І ГОСПАД будзе жыць там заўсёды. ");
INSERT INTO beln_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Калясьніцаў Божых дзясяткі тысячаў, тысячы тысячаў; Госпад сярод іх, як на Сінаі, у сьвятасьці. ");
INSERT INTO beln_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Ты ўзыйшоў на высокасьць, паланіў палон, узяў дары для людзей; і нават бунтаўнікоў, каб жылі пры Табе, ГОСПАДЗЕ Божа. ");
INSERT INTO beln_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Дабраслаўлёны Госпад! З дня на дзень Ён нас абдароўвае, Бог збаўленьня нашага. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Бог для нас — Бог ратунку, і ГОСПАД — Гаспадар над крыніцаю сьмерці. ");
INSERT INTO beln_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Сапраўды, Бог скрышыць галаву ворагаў Сваіх, валасатае цемя тых, што ходзяць у правінах сваіх. ");
INSERT INTO beln_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Сказаў Госпад: “З Башану вярну, вярну з глыбіняў марскіх, ");
INSERT INTO beln_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","каб змачыў нагу тваю ў крыві, а сабакі твае — языкі ў крыві ворагаў”. ");
INSERT INTO beln_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Бачылі шэсьце Тваё, Божа, шэсьце Бога майго і Валадара майго ў сьвятыні: ");
INSERT INTO beln_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","сьпевакі наперадзе ішлі, пасьля — музыкі, пасярэдзіне – дзяўчыны з бубнамі. ");
INSERT INTO beln_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","У зграмаджэньні дабраслаўляйце Бога, ГОСПАДА, вы, што з крыніцы Ізраіля! ");
INSERT INTO beln_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Там Бэн’ямін, наймалодшы, мае ўладу над імі; князі Юды з палкамі сваімі; князі Забулёна, князі Нэфталі. ");
INSERT INTO beln_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Загадаў Бог твой моцы тваёй! Умацуй, Божа, тое, што для нас учыніў! ");
INSERT INTO beln_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Дзеля сьвятыні Тваёй у Ерусаліме валадары будуць прыносіць дары. ");
INSERT INTO beln_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Утаймуй зьвера ў чароце, статак быкоў сярод цялятаў народаў, якія падаюць перад кавалкамі срэбра; расьцяруш народы, што жадаюць вайны! ");
INSERT INTO beln_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Прыйдуць магнаты з Эгіпту, Куш працягне рукі свае да Бога. ");
INSERT INTO beln_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Валадарствы зямлі, сьпявайце Богу, выслаўляйце Госпада, (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Які сядзіць па нябёсах, нябёсах адвечных. Вось, Ён дае голас Свой, голас моцы Сваёй! ");
INSERT INTO beln_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Прызнайце моц Божую! Над Ізраілем слава Ягоная, і моц Ягоная — у аблоках. ");
INSERT INTO beln_vpl VALUES ("PS68_36","020_68_36","PSA","68","36","36","Страшны Ты, Божа, у сьвятыні Тваёй, Бог Ізраіля. Ён дае сілу і магутнасьць народу Свайму. Дабраслаўлёны Бог! ");
INSERT INTO beln_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Кіраўніку хору: на лад “Лілеі”. Давіда. ");
INSERT INTO beln_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Збаў мяне, Божа, бо воды да душы маёй даходзяць! ");
INSERT INTO beln_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Я заграз у глыбокім балоце бяздонным; я патрапіў у глыбіню водную, і цячэньне мяне падхапіла. ");
INSERT INTO beln_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Я зьнямогся ад крыку майго, засохла горла маё; змарыліся вочы мае, пакуль я спадзяваўся на Бога майго. ");
INSERT INTO beln_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Больш, чым валасоў на галаве маёй, тых, што мяне ненавідзяць без прычыны, узмацніліся тыя, што нішчаць мяне, ворагі мае падступныя. Чаго не рабаваў, мушу аддаваць. ");
INSERT INTO beln_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Божа, Ты ведаеш дурасьць маю, і правіны мае ад Цябе не схаваныя. ");
INSERT INTO beln_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Ня дай праз мяне асароміцца тым, што на Цябе спадзяюцца, Госпадзе, ГОСПАД Магуцьцяў; ня дай праз мяне асароміцца тым, што шукаюць Цябе, Божа Ізраіля! ");
INSERT INTO beln_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Бо дзеля Цябе я ганьбу зношу, і сорамам пакрыта аблічча маё. ");
INSERT INTO beln_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Я стаўся чужым для братоў маіх і чужынцам для сыноў маці маёй. ");
INSERT INTO beln_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Бо руплівасьць пра дом Твой зьядае мяне, і зьнявагі тых, што Цябе зьневажаюць, зыйшлі на мяне. ");
INSERT INTO beln_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","І плакала ў посьце душа мая, і сталася гэта зьнявагай мне. ");
INSERT INTO beln_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","І зрабіў я зрэбніцу вопраткай маёй, і стаўся для іх прыповесьцю. ");
INSERT INTO beln_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Абмаўляюць мяне тыя, што сядзяць у браме гораду, і прыпеўкі пяюць тыя, што п’юць сікеру. ");
INSERT INTO beln_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","А я да Цябе малюся, ГОСПАДЗЕ, у час упадабаньня Твайго, Божа; у вялікай міласэрнасьці Тваёй пачуй Ты мяне, у праўдзе збаўленьня Твайго! ");
INSERT INTO beln_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Выратуй мяне з балота, каб я не заграз; ратуй ад тых, што ненавідзяць мяне, і з глыбіняў водных! ");
INSERT INTO beln_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Няхай не падхопіць мяне цячэньне водаў, няхай не праглыне мяне глыбіня, і няхай не сашчэміць нада мною калодзеж вуснаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Пачуй мяне, ГОСПАДЗЕ, бо добрая міласэрнасьць Твая! Паводле вялікай літасьці Тваёй павярніся да мяне. ");
INSERT INTO beln_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","І не хавай аблічча Твайго перад слугою Тваім, бо я прыгнечаны; хутчэй адкажы мне! ");
INSERT INTO beln_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Наблізься да душы маёй, барані яе; насупраць ворагам маім выбаў Ты мяне! ");
INSERT INTO beln_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Ты ведаеш ганьбу маю, і сорам мой, і зьнявагу маю; перад Табою ўсе, што перасьледуюць мяне. ");
INSERT INTO beln_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Ганьба разьбіла сэрца маё, і я ў роспачы; я спадзяваўся на спачуваньне, і ня маю яго, і на пацяшальнікаў, і не знайшоў іх. ");
INSERT INTO beln_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Яны далі мне замест стравы жоўць, і, калі я смагнуў, напаілі мяне воцатам. ");
INSERT INTO beln_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Няхай станецца стол іхні перад абліччам іхнім пасткаю, і бясьпечнасьць — сілом. ");
INSERT INTO beln_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Няхай зацемрацца вочы іхнія, каб ня бачылі, няхай сьцёгны іхнія заўсёды дрыжаць! ");
INSERT INTO beln_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Вылі на іх ярасьць Тваю, і жар гневу Твайго няхай дагоніць іх! ");
INSERT INTO beln_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Няхай апусьцее сяліба іхняя, у намётах іхніх няхай ніхто не жыве! ");
INSERT INTO beln_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Бо таго, каго Ты б’еш, яны перасьледуюць, і пра боль таго, каго Ты параніў, яны абвяшчаюць. ");
INSERT INTO beln_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Дадай беззаконьне да беззаконьня іхняга і ня дай ім прыйсьці да праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Няхай будуць выкрэсьленыя з кнігі жывых і ня будуць запісаныя разам з праведнікамі. ");
INSERT INTO beln_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","А я прыгнечаны і поўны тугі; збаўленьне Тваё, Божа, няхай падыме мяне! ");
INSERT INTO beln_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Я буду хваліць імя Божае сьпевам і ўзьвялічваць Яго з падзякаю. ");
INSERT INTO beln_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","І будзе гэта больш даспадобы ГОСПАДУ, чым вол, бык з рагамі і капытамі. ");
INSERT INTO beln_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Угледзяць гэта ўцісканыя і ўзрадуюцца; і ў вас, што Бога шукаеце, няхай ажыве сэрца вашае! ");
INSERT INTO beln_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Бо ГОСПАД выслухоўвае бедных і вязьнямі сваімі не пагарджае. ");
INSERT INTO beln_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Няхай хваляць Яго неба і зямля, і мора, і ўсё, што рухаецца ў іх. ");
INSERT INTO beln_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Бо збавіць Бог Сыён, і адбудуе гарады Юды, і яны паселяцца там, і возьмуць у спадчыну іх. ");
INSERT INTO beln_vpl VALUES ("PS69_37","020_69_37","PSA","69","37","37","I насеньне слугаў Ягоных ў спадчыну іх атрымае, і той, хто любіць імя Ягонае, жыць будзе ў іх. ");
INSERT INTO beln_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Кіраўніку хору. Давіда. Напамін. ");
INSERT INTO beln_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Божа, ратуй мяне! ГОСПАДЗЕ, пасьпяшайся на ўспамогу мне! ");
INSERT INTO beln_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Няхай асаромяцца і зганьбяцца тыя, што шукаюць душы маёй! Няхай адступяцца і будуць у сораме тыя, якім даспадобы ліхоцьце маё! ");
INSERT INTO beln_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Няхай павернуць наўцекі ў сораме сваім тыя, якія кажуць мне: “Ага! Ага!” ");
INSERT INTO beln_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Няхай радуюцца і весяляцца ў Табе ўсе, хто шукае Цябе. Няхай кажуць заўсёды тыя, што любяць выратаваньне Тваё: “Будзь узьвялічаны, Божа!” ");
INSERT INTO beln_vpl VALUES ("PS70_6","020_70_6","PSA","70","6","6","А я бедны і прыгнечаны, дык пасьпяшайся да мяне, Божа! Ты — ўспамога мая і ратунак мой. ГОСПАДЗЕ, не затрымлівайся! ");
INSERT INTO beln_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","У Табе, ГОСПАДЗЕ, я маю надзею. Ня дай мне асароміцца на вякі! ");
INSERT INTO beln_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Паводле праведнасьці Тваёй выратуй мяне і вызвалі! Прыхілі да мяне вуха Тваё і збаў мяне! ");
INSERT INTO beln_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Будзь мне скалой, дзе сяліба мая, куды прыходжу заўсёды, дзе Ты даў загад, каб збавіць мяне, бо Ты — скала мая і замчышча маё. ");
INSERT INTO beln_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Божа мой, вызваль мяне з рукі бязбожніка, з рукі беззаконьніка і прыгнятальніка. ");
INSERT INTO beln_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Бо Ты — надзея мая, Госпадзе, ГОСПАДЗЕ, пэўнасьць мая з маладосьці маёй! ");
INSERT INTO beln_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","На Цябе я абапіраўся ад чэрава маці; з нутра маці маёй Ты вывеў мяне; дык Табе заўсёды хвала мая! ");
INSERT INTO beln_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Быццам дзіва стаўся я для многіх, і Ты — прыстанішча маё моцнае. ");
INSERT INTO beln_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Няхай будуць напоўненыя вусны мае хвалой Табе, кожны дзень — услаўленьнем Цябе. ");
INSERT INTO beln_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Не адкінь мяне ў час старасьці маёй; калі счэзнуць сілы мае, Ты не пакінь мяне! ");
INSERT INTO beln_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Бо змаўляюцца ворагі мае супраць мяне, і тыя, што сочаць за душою маёй, радзяцца між сабою, ");
INSERT INTO beln_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","кажучы: “Бог пакінуў яго; дык ганіцеся за ім і схапіце яго, бо няма ў яго ратунку!” ");
INSERT INTO beln_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Божа, не аддаляйся ад мяне! Божа мой, пасьпяшайся на ўспамогу мне! ");
INSERT INTO beln_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Няхай будуць асаромленыя і зьнішчаныя тыя, што супрацьстаяць душы маёй! Няхай ганьбай і сорамам пакрыюцца тыя, што шукаюць ліхога для мяне! ");
INSERT INTO beln_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","А я заўсёды буду спадзявацца і множыць ўсю хвалу Тваю. ");
INSERT INTO beln_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Вусны мае будуць абвяшчаць праведнасьць Тваю, і цэлы дзень — выратаваньне Тваё, бо ім лічбы ня ведаю я! ");
INSERT INTO beln_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Перайду да магутнасьці Госпада, ГОСПАДА, буду ўзгадваць праведнасьць Тваю, толькі Тваю! ");
INSERT INTO beln_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Божа, Ты вучыў мяне з маладосьці маёй, і дагэтуль я пра цуды Твае апавядаю. ");
INSERT INTO beln_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","І да старасьці, і да сівізны не пакідай мяне, Божа, пакуль я пра рамяно Тваё не распавяду пакаленьню гэтаму і пра магутнасьць Тваю — ўсім, што народзяцца яшчэ. ");
INSERT INTO beln_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Бо праведнасьць Твая, Божа, аж да вышыняў, Ты чыніш вялікія рэчы. Божа, хто падобны да Цябе? ");
INSERT INTO beln_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ты даў нам угледзець шмат трывог і ліха, але Ты вернеш нас да жыцьця і з бяздоньняў зямлі зноў узьнімеш нас. ");
INSERT INTO beln_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ты памножыш велічнасьць маю і зноўку пацешыш мяне. ");
INSERT INTO beln_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Дык я буду славіць на музычных інструмэнтах Цябе, мой Божа, і праўду Тваю! Буду выслаўляць Цябе на гусьлях, Сьвяты Ізраіля! ");
INSERT INTO beln_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Узрадуюцца вусны мае, бо я Цябе выслаўляю, і душа мая, што Ты выбавіў яе. ");
INSERT INTO beln_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","І язык мой будзе цэлы дзень разважаць пра праведнасьць Тваю, бо асаромленыя і ў ганьбе тыя, што шукалі ліха для мяне. ");
INSERT INTO beln_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Для Салямона. Божа, дай суд Твой валадару, і праведнасьць Тваю — сыну валадара. ");
INSERT INTO beln_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Няхай судзіць ён народ Твой паводле справядлівасьці, і ўбогіх Тваіх — паводле права. ");
INSERT INTO beln_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Няхай прынясуць горы супакой народу, і ўзгоркі — праведнасьць. ");
INSERT INTO beln_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Няхай ён судзіць убогіх з народу, выбаўляе сыноў беднякоў і скрышыць прыгнятальнікаў. ");
INSERT INTO beln_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Няхай баяцца Цябе пакуль будзе сонца і перад абліччам месяца, з пакаленьня ў пакаленьне. ");
INSERT INTO beln_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Няхай зыходзіць, як дождж на атаву, як кроплі дажджу, што зямля ад іх вільгатнее. ");
INSERT INTO beln_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Няхай закрасуе праведнік у дні ягоныя, і будзе мноства супакою, аж пакуль месяц стаіць. ");
INSERT INTO beln_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","І няхай ён мае ўладу ад мора да мора і ад ракі аж да краю зямлі. ");
INSERT INTO beln_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Перад абліччам ягоным упадуць жыхары пустыні, і ворагі ягоныя будуць лізаць пыл. ");
INSERT INTO beln_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Валадары Таршышу і астравоў дары яму панясуць; валадары Шэбы і Сэбы прынясуць яму даніну. ");
INSERT INTO beln_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","І паклоняцца яму ўсе валадары, усе народы будуць служыць яму. ");
INSERT INTO beln_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Бо ён ратуе беднага, калі той галосіць, і прыгнечанага, і таго, у каго няма дапамогі. ");
INSERT INTO beln_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Ён літуецца над гаротным і бедным і выбаўляе душы бедакоў. ");
INSERT INTO beln_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Ад ашуканства і гвалту вызваляе душы іхнія, і ў вачах ягоных кроў іхняя вельмі каштоўная. ");
INSERT INTO beln_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","І будзе ён жыць, і даваць яму будуць золата Шэбы, і будуць маліцца за яго заўсёды, і будуць дабраслаўляць яго ўсе дні. ");
INSERT INTO beln_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","І будзе дастатак збожжа на зямлі, на вяршынях гор; будуць шумець, як Лібан, каласы ягоныя, і мяшчане заквітнеюць, як трава на зямлі. ");
INSERT INTO beln_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","І будзе імя ягонае на вякі, перад абліччам сонца будзе трываць імя ягонае, і будуць дабраслаўлёныя ў ім усе народы, і будуць шчасьлівыя ў ім. ");
INSERT INTO beln_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Дабраслаўлёны ГОСПАД Бог, Бог Ізраіля, Які Сам робіць цуды. ");
INSERT INTO beln_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","І дабраслаўлёнае імя славы Яго на вякі, і няхай напоўніцца славай Яго ўся зямля! Амэн, амэн! ");
INSERT INTO beln_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Канец малітвы Давіда, сына Есэя. ");
INSERT INTO beln_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Псальм Асафа. Які добры Бог для Ізраіля, для тых, што чыстыя сэрцам! ");
INSERT INTO beln_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","А я — амаль спатыкнуліся ногі мае, ледзь не пакаўзнуліся крокі мае. ");
INSERT INTO beln_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Бо я пазайздросьціў тым, што хваляць сябе, убачыўшы супакой бязбожнікаў, ");
INSERT INTO beln_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","бо яны не зазнаюць гора аж да сьмерці і добра ўскормлена цела іхняе, ");
INSERT INTO beln_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","нядолі людзкой яны ня маюць, і кары, як у іншых людзей, няма для іх. ");
INSERT INTO beln_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Дзеля гэтага атачае шыю іхнюю пыха, ліхадзейства нібы шатамі атуляе іх. ");
INSERT INTO beln_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ад тлустасьці павылазілі вочы іхнія, прыходзіць ім больш за ўяўленьні сэрца іхняга. ");
INSERT INTO beln_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Яны зьдзекуюцца і гавораць зласьліва; звысака гавораць пра крыўду. ");
INSERT INTO beln_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Да неба ўзьнімаюцца вуснамі сваімі, а язык іхні па зямлі гуляе. ");
INSERT INTO beln_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Дык туды і народ Ягоны паварочваецца, і шчодрыя воды выліваюцца на іх. ");
INSERT INTO beln_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","І тыя кажуць: “Як Бог даведацца? І ці мае веданьне пра гэта Найвышэйшы?” ");
INSERT INTO beln_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Вось, гэткія ёсьць бязбожнікі, і ў спакоі вечным зьбіраюць яны багацьці. ");
INSERT INTO beln_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Дык ці-ж зусім надарма я захоўваў ў чыстасьці сэрца сваё і абмываў у нявіннасьці рукі мае, ");
INSERT INTO beln_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","і білі мяне ўвесь дзень, і каралі мяне кожную раніцу? ");
INSERT INTO beln_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Калі б я сказаў: “Буду думаць, як яны!”— я б гэтым адрокся ад пакаленьня сыноў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","І разважаў я, каб зразумець усё гэта, і нядоляй гэта здавалася ў вачах маіх, ");
INSERT INTO beln_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","аж пакуль не ўвайшоў я ў сьвятыню Божую, і тады зразумеў канец іхні. ");
INSERT INTO beln_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Сапраўды, на коўзкім груньце Ты ставіш іх і спасылаеш на пагібель! ");
INSERT INTO beln_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Як жа імгненна яны спустошаныя, загінулі, счэзьлі ад жаху! ");
INSERT INTO beln_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Як сном пасьля абуджэньня, Ты, Госпадзе, збудзіўшыся, грэбуеш вобразам іхнім. ");
INSERT INTO beln_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Бо згоркла сэрца маё і курчыліся ныркі мае, ");
INSERT INTO beln_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","я стаўся дурнем і ня ведаў нічога, і быў перад Табой, як жывёла, ");
INSERT INTO beln_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","але я быў пры Табе заўсёды! Ты трымаеш мяне за правую руку маю, ");
INSERT INTO beln_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ты вядзеш мяне паводле рады Тваёй, і потым возьмеш мяне ў славу Тваю. ");
INSERT INTO beln_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Каго ж я маю ў небе? І на зямлі апроч Цябе мне ніхто не даспадобы. ");
INSERT INTO beln_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Зьнікаюць цела маё і сэрца маё, але Бог — скала сэрца майго і частка мая на вякі. ");
INSERT INTO beln_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Бо, вось, гінуць тыя, што ад Цябе адыходзяць; Ты вынішчаеш кожнага, хто чужаложыць, выракаючыся Цябе. ");
INSERT INTO beln_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","А для мяне блізкасьць Бога ёсьць дабро для мяне; я зрабіў у ГОСПАДЗЕ, Госпадзе маім, прыстанішча маё, каб абвяшчаць усе справы Твае. ");
INSERT INTO beln_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Навучаньне Асафа. Чаму Ты, Божа, нас назаўсёды адкінуў? Чаму ўзгарэўся Твой гнеў на авечкі чарады Тваёй? ");
INSERT INTO beln_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Узгадай пра грамаду Тваю, якую Ты здаўна набыў, якую бароніш, як кій спадчыны Сваёй, гару Сыён, на якой Ты жывеш! ");
INSERT INTO beln_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Зьвярні стопы Твае да таго, што загінула назаўсёды, усё панішчыў вораг у сьвятыні. ");
INSERT INTO beln_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Рыкаюць ненавісьнікі Твае пасярод намёту спатканьня Твайго; паставілі на знак гэтага знакаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Яны падобны да тых, што падымаюць ў гушчары лясным сякеру, ");
INSERT INTO beln_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","і цяпер усе разьбяныя рэчы ў сьвятыні бярдышамі і молатамі крышаць. ");
INSERT INTO beln_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Яны пусьцілі з агнём сьвятыню Тваю, кінуўшы на зямлю, апаганілі сялібу іменьня Твайго. ");
INSERT INTO beln_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Сказалі ў сэрцы сваім: “Усё зруйнуем дазваньня!”; папалілі ўсе месцы спатканьня з Богам на зямлі. ");
INSERT INTO beln_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Знакаў нашых ня бачым мы болей; няма больш прарока, і нікога няма, хто б ведаў, як доўга гэта будзе. ");
INSERT INTO beln_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Як доўга, Божа, будзе зьневажаць прыгнятальнік? Ці заўсёды вораг будзе пагарджаць імем Тваім? ");
INSERT INTO beln_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Чаму Ты стрымліваеш руку Тваю і правіцу Тваю? Вым яе з-за пазухі Тваёй і ўдар! ");
INSERT INTO beln_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Бог ёсьць Валадар мой заўсёды, Які збаўленьне дае на зямлі. ");
INSERT INTO beln_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ты моцай Тваёй разьдзяліў мора, скрышыў галовы цмокаў у водах. ");
INSERT INTO beln_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Ты раструшчыў галаву левіятану, аддаў яго на ежу народу, што жыве ў пустыні. ");
INSERT INTO beln_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ты расьсёк крыніцу і ручай, Ты высушыў рэкі магутныя. ");
INSERT INTO beln_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Твой ёсьць дзень, і Твая ёсьць ноч; Ты ўмацаваў сьвятло і сонца. ");
INSERT INTO beln_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Ты назначыў усе межы зямлі; лета і зіму — Ты іх уфармаваў. ");
INSERT INTO beln_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Памятай пра гэта: вораг зьневажае ГОСПАДА, і народ бязглузды пагарджае імем Тваім! ");
INSERT INTO beln_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Не аддавай хеўры гэтай душу турка Твайго; не забудзь назаўсёды грамаду прыгнечаных Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Узглянь на запавет Твой, бо цёмныя месцы зямлі напоўненыя сялібамі гвалту. ");
INSERT INTO beln_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Няхай не вяртаецца ўцісьнёны асаромленым, няхай бедныя і прыгнечаныя хваляць імя Тваё! ");
INSERT INTO beln_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Паўстань, Божа! Змагайся ў справе Тваёй! Узгадай, што бязглузды ганьбіць Цябе кожны дзень. ");
INSERT INTO beln_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Не забудзь голас ненавісьнікаў Тваіх, гармідар тых, якія паўстаюць супраць Цябе, што ўсьцяж узьнімаецца! ");
INSERT INTO beln_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Кіраўніку хору: на лад: “Не загубляй!”. Псальм Асафа. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Славім мы Цябе, Божа, славім, і тыя, што блізкія да імя Твайго, абвяшчаюць цуды Твае. ");
INSERT INTO beln_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","“Калі Я прызначу месца спатканьня, Я буду судзіць паводле справядлівасьці. ");
INSERT INTO beln_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Калі растапляецца зямля і ўсе, хто жыве на ёй, Я ўзважваю слупы яе. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Я кажу да тых, што хваляцца сабою: “Не хваліцеся!” і да бязбожных: “Не падыймайце рогі! ");
INSERT INTO beln_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Не падыймайце высока рогі свае, не прамаўляйце, дзёрзка трымаючы шыю!” ");
INSERT INTO beln_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Бо ані з усходу, ані з захаду, ані з пустыні вывышэньне, ");
INSERT INTO beln_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","але Бог ёсьць Судзьдзя, гэтага Ён паніжае, а таго вывышае. ");
INSERT INTO beln_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Бо ў руцэ ГОСПАДА келіх з віном, якое пеніцца; ён поўны напою зьмяшанага, і Ён з яго налівае, але толькі фуз яго піць будуць усе бязбожнікі на зямлі. ");
INSERT INTO beln_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","А я буду апавядаць пра гэта вечна, буду выслаўляць Бога Якуба. ");
INSERT INTO beln_vpl VALUES ("PS75_11","020_75_11","PSA","75","11","11","І ўсе рогі бязбожнікам я адсяку, і будуць узьнятыя рогі праведнага. ");
INSERT INTO beln_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Кіраўніку хору: на струнных інструмэнтах. Псальм Асафа. Сьпеў. ");
INSERT INTO beln_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Вядомы ў Юдэі Бог, вялікае ў Ізраілі імя Ягонае. ");
INSERT INTO beln_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","І паўстаў у Салеме схоў Ягоны, і жытло Ягонае — на Сыёне. ");
INSERT INTO beln_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Там Ён скрышыў стрэлы луку, шчыт і меч, і вайну. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ты зьзяеш, Ты слаўнейшы за горы здабычы. ");
INSERT INTO beln_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Зрабаваныя моцныя сэрцам, дрэмлюць сном сваім, і не знайшлі ўсе мужы дужыя рук сваіх. ");
INSERT INTO beln_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Ад пагрозаў Тваіх, Божа Якуба, здрантвелі і калясьніца, і конь. ");
INSERT INTO beln_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ты, толькі Ты напаўняеш страхам, і хто можа ўстаяць прад абліччам Тваім у час гневу Твайго? ");
INSERT INTO beln_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","З неба Ты даеш пачуць прысуд, зямля ў страху і маўчаньні, ");
INSERT INTO beln_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","калі Бог падняўся на суд, каб збавіць ўсіх уцісканых на зямлі. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Бо нават ярасьць чалавека будзе славіць Цябе, парэшткамі ярасьці Ты падпярэжашся. ");
INSERT INTO beln_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Давайце і спаўняйце абяцаньні ГОСПАДУ, Богу вашаму; усе, што навакол Яго, нясіце дары Страшліваму. ");
INSERT INTO beln_vpl VALUES ("PS76_13","020_76_13","PSA","76","13","13","Ён пазбаўляе духу князёў, Ён страшны для валадароў зямных. ");
INSERT INTO beln_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Кіраўніку хору. Едутуну. Псальм Асафа. ");
INSERT INTO beln_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Голас мой да Бога, і буду крычаць; голас мой да Бога, і Ён пачуў мяне. ");
INSERT INTO beln_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","У дзень трывогі маёй шукаю я Госпада; уначы рука мая працягнутая і не зьнемагаецца; адмаўляецца ад пацяшэньня душа мая. ");
INSERT INTO beln_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Узгадваю пра Бога і стогну; енчу і зьнемагае дух мой. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ты затрымаў павекі вачэй маіх; я ўстрывожаны, і не магу гаварыць. ");
INSERT INTO beln_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Разважаю пра дні старадаўныя, пра гады спрадвечныя. ");
INSERT INTO beln_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Уначы ўзгадваю песьні мае, енчу ў сэрцы маім, і дапытываецца дух мой: ");
INSERT INTO beln_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","“Няўжо Госпад навекі адкінуў мяне і ня будзе больш спагадаць? ");
INSERT INTO beln_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Няўжо назаўсёды канец міласэрнасьці Ягонай, і вестка з пакаленьня ў пакаленьне счэзла? ");
INSERT INTO beln_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Няўжо Бог забыўся пра літасьцівасьць Сваю і спыніў ў гневе Сваім літасьць Сваю?” (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","І сказаў я: “Гэта боль мой, што зьмянілася правіца Найвышэйшага. ");
INSERT INTO beln_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Буду ўзгадваць дзеяньні ГОСПАДА; бо хачу ўзгадваць цуды Твае старадаўныя. ");
INSERT INTO beln_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","І буду разважаць пра ўсе справы Твае, і пра вялікія ўчынкі Твае буду апавядаць. ");
INSERT INTO beln_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","У сьвятасьці, Божа, шлях Твой. Які бог гэтакі вялікі, як Бог? ");
INSERT INTO beln_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ты — Бог, Які цуды робіць. Ты даў спазнаць народам моц Тваю. ");
INSERT INTO beln_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ты бараніў рамяном Тваім народ Твой, сыноў Якуба і Язэпа. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Убачылі Цябе воды, Божа, убачылі Цябе воды і задрыжэлі, і затрэсьліся бяздоньні. ");
INSERT INTO beln_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Лінулі з хмараў воды; выдалі голас аблокі, і лёталі стрэлы Твае. ");
INSERT INTO beln_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Голас грымотаў Тваіх у віхры; маланкі сусьвет асьвятлялі; зямля трэслася і дрыжэла. ");
INSERT INTO beln_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Праз мора ішоў шлях Твой, і сьцяжына Твая — праз воды вялікія, і сьлядоў Тваіх нельга пазнаць. ");
INSERT INTO beln_vpl VALUES ("PS77_21","020_77_21","PSA","77","21","21","Ты вёў народ Твой, як авечкі, рукой Майсея і Аарона. ");
INSERT INTO beln_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Навучаньне Асафа. Зважай, народзе мой, на закон мой, прыхіліце вушы свае да словаў вуснаў маіх! ");
INSERT INTO beln_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Адчыню я вусны мае ў прыповесьці, буду апавядаць загадкі старадаўныя. ");
INSERT INTO beln_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Што чулі мы і даведаліся, і што бацькі нашыя расказалі нам, ");
INSERT INTO beln_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","гэтага не схаваем ад сыноў іхніх, абвяшчаючы пакаленьню наступнаму хвалу ГОСПАДА і магутнасьць Ягоную, і цуды Ягоныя, што Ён учыніў. ");
INSERT INTO beln_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","І Ён ўзьняў сьведчаньне ў Якубе, і паклаў Закон у Ізраілю, пра якія загадаў бацькам нашым, каб яны паведамілі гэта сынам сваім, ");
INSERT INTO beln_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","каб ведала пакаленьне наступнае, сыны, якія народзяцца, і каб яны ў свой час абвясьцілі гэта сынам сваім. ");
INSERT INTO beln_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","І ўскладуць на Бога надзею сваю, і не забудуцца пра дзеяньні Божыя, і прыказаньні Ягоныя будуць захоўваць, ");
INSERT INTO beln_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","і ня будуць падобныя да бацькоў сваіх, пакаленьня бунтаўнікоў і непакорных, пакаленьня, якое не трывалае ў сэрцы сваім і дух іхні ня верны Богу. ");
INSERT INTO beln_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Сыны Эфраіма, узброеныя лукамі, павярнулі назад у дзень бітвы. ");
INSERT INTO beln_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Яны не захавалі запавету Божага і адмовіліся хадзіць паводле Закону Ягонага. ");
INSERT INTO beln_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","І забыліся пра дзеі Ягоныя і цуды, якія Ён ім даў бачыць. ");
INSERT INTO beln_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Перад бацькамі іхнімі ўчыніў Ён цуды ў зямлі Эгіпецкай, на полі Цоан. ");
INSERT INTO beln_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ён расьсёк мора і перавёў іх праз яго, і паставіў воды, як капу. ");
INSERT INTO beln_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","І вёў іх удзень воблакам, і ўсю ноч — сьвятлом вогненным. ");
INSERT INTO beln_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Ён рашчапіў скалы ў пустыні і напаіў іх, быццам з вялікай бездані; ");
INSERT INTO beln_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","І вывеў струмяні са скалаў, і пацяклі рэкамі воды. ");
INSERT INTO beln_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Але яны і надалей грашылі супраць Яго, бунтаваліся супраць Найвышэйшага ў сухой зямлі. ");
INSERT INTO beln_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Яны выпрабоўвалі Бога ў сэрцах сваіх, жадаючы спажывы для душаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","І гаварылі супраць Бога, кажучы: “Хіба Бог можа прыгатаваць стол у пустыні?” ");
INSERT INTO beln_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Вось, Ён ударыў скалу, і люнулі воды, і ручаі пацяклі; але ці можа Ён даць таксама хлеба і паставіць мяса для народа Свайго?” ");
INSERT INTO beln_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Дык пачуў ГОСПАД, і абурыўся, і ўзгарэўся агонь на Якуба, і ўзьняўся гнеў на Ізраіля, ");
INSERT INTO beln_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","бо яны ня верылі Богу і не спадзяваліся на збаўленьне Ягонае. ");
INSERT INTO beln_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","І Ён загадаў хмарам высока, і адчыніў дзьверы неба, ");
INSERT INTO beln_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","і спаслаў дажджом ім манну, і даў ім збожжа нябеснага. ");
INSERT INTO beln_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Хлеб дужых еў чалавек; Ён спаслаў ім ежы ўдосталь. ");
INSERT INTO beln_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Ён рушыў вецер усходні ў небе і сілай Сваёю навёў вецер паўднёвы; ");
INSERT INTO beln_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","і спаслаў дажджом на іх мяса, быццам пыл, і птушак крылатых — як пясок ля мора. ");
INSERT INTO beln_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","І скінуў іх пасярод табару іхняга, навакол сялібаў іхніх. ");
INSERT INTO beln_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","І елі яны, і насыціліся добра, і тое, што яны жадалі, Ён даў ім. ");
INSERT INTO beln_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Яшчэ не пазбавіліся яны жаданьня свайго, яшчэ спажыва іхняя была ў вуснах іхніх, ");
INSERT INTO beln_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","як гнеў Божы ўзьняўся на іх, і забіў тлустых іхніх, і юнакоў Ізраіля паваліў. ");
INSERT INTO beln_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Пры ўсім гэтым яны далей грашылі і ня верылі ў цуды Ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","І сканчваліся ў марнасьці дні іхнія, і гады іхнія — ў страху. ");
INSERT INTO beln_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Калі Ён забіваў іх, яны шукалі Яго, і вярталіся, і імкнуліся да Бога, ");
INSERT INTO beln_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","і ўзгадвалі, што Бог — скала іхняя, і Бог Найвышэйшы — Абаронца іхні. ");
INSERT INTO beln_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","І яны лісьлівілі Яму вуснамі Сваімі, і языком сваім хлусілі перад Ім, ");
INSERT INTO beln_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","і сэрца іхняе не было трывалым у Ім, і не былі яны верныя запавету Ягонаму. ");
INSERT INTO beln_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","А Ён, спагадлівы да іх, дараваў ім беззаконьне іхняе і ня зьнішчыў іх, і неаднакроць супыняў гнеў Свой і не абуджаў ўсю ярасьць Сваю, ");
INSERT INTO beln_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","бо памятаў, што яны — цела, вецер, які адыходзіць і ня вернецца. ");
INSERT INTO beln_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Як часта яны бунтаваліся супраць Яго ў пустыні, засмучалі Яго ў зямлі бязьлюднай! ");
INSERT INTO beln_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","І зьвярталіся, і выпрабоўвалі Бога і абражалі Сьвятога Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Не памяталі яны рукі Ягонай, дня, калі Ён іх вызваліў ад прыгнёту, ");
INSERT INTO beln_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","калі знакі Свае рабіў у Эгіпце, і цуды Свае на полі Цоан. ");
INSERT INTO beln_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","І Ён перамяніў рэкі іхнія і ручаіны іхнія у кроў, што не маглі піць, ");
INSERT INTO beln_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","спаслаў на іх мухаў, што іх кусалі, і жабаў, што іх губілі. ");
INSERT INTO beln_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","І аддаў вусеням ураджаі іхнія, а працу іхнюю — саранчы. ");
INSERT INTO beln_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Пабіў градам вінаградныя лозы іхнія, фігавыя дрэвы іхнія — шэраньню. ");
INSERT INTO beln_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","І аддаў граду скаціну іхнюю, а статкі іхнія — маланкам; ");
INSERT INTO beln_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","І спаслаў на іх жар гневу Свайго, абурэньне, і ярасьць, і трывогі, навалу злых анёлаў. ");
INSERT INTO beln_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Выпрастаў сьцежку гневу Свайму, ня захоўваў ад сьмерці душы іхнія, і жыцьцё іхняе пошасьці аддаў. ");
INSERT INTO beln_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","І забіў усіх першародных у Эгіпце, пачаткі сілы ў намётах Хама. ");
INSERT INTO beln_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","І вывеў, як авечкі, народ Свой, і вёў іх як статак праз пустыню. ");
INSERT INTO beln_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","І вёў іх у бясьпецы, і яны не палохаліся, а ворагаў іхніх мора накрыла. ");
INSERT INTO beln_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","І прыйшлі яны да межаў сьвятасьці Ягонай, да гары, што набыла правіца Ягоная; ");
INSERT INTO beln_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","і Ён выгнаў перад абліччам іхнім народы, і кінуў шнур, каб падзяліць спадчыну іхнюю, і пасяліў у намётах іхніх калены Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Але яны выпрабоўвалі Бога Найвышэйшага і бунтаваліся супраць Яго, і сьведчаньняў Ягоных не захоўвалі, ");
INSERT INTO beln_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","і яны адступаліся і здраджвалі, як і бацькі іхнія, выварачваліся, быццам той лук здрадлівы. ");
INSERT INTO beln_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","І яны злавалі Яго ўзгоркамі сваімі і балванамі сваімі раздражнялі Яго. ");
INSERT INTO beln_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Пачуў гэта Бог і абурыўся, і вельмі пагрэбаваў Ізраілем. ");
INSERT INTO beln_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","І Ён пакінуў сялібу ў Шыло, намёт, у якім жыў сярод людзей; ");
INSERT INTO beln_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","і аддаў у палон моц Сваю, і славу Сваю — ў рукі прыгнятальніка. ");
INSERT INTO beln_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","І аддаў пад меч народ Свой, і на спадчыну Сваю абурыўся. ");
INSERT INTO beln_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Юнакоў ягоных агонь зьядаў, і дзяўчаты ягоныя не былі ўшанаваныя. ");
INSERT INTO beln_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Сьвятары ягоныя падалі ад мяча, і ўдовы ягоныя ня плакалі. ");
INSERT INTO beln_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","І быццам зо сну прачнуўся Госпад, як той волат, якога разьвесяліла віно, ");
INSERT INTO beln_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","і Ён выбіў прыгнятальнікаў дашчэнту, на вечную ганьбу аддаў іх. ");
INSERT INTO beln_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","І Ён адкінуў намёт Язэпа, і ня выбраў калена Эфраіма, ");
INSERT INTO beln_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","а выбраў калена Юды, гару Сыён, якую палюбіў. ");
INSERT INTO beln_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","І пабудаваў Ён як пад неба высокую сьвятыню Сваю; і як зямлю заснаваў яе навякі. ");
INSERT INTO beln_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","І выбраў Давіда, слугу Свайго, і ўзяў яго ад абораў авечых. ");
INSERT INTO beln_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Ад котных авечак забраў яго, каб пасьвіў Якуба, народ Ягоны, і Ізраіля, спадчыну Ягоную. ");
INSERT INTO beln_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","І той пасьвіў іх у беззаганнасьці сэрца свайго і ў разважлівасьці рук сваіх вадзіў іх. ");
INSERT INTO beln_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Псальм Асафа. Божа, пагане ўвайшлі ў спадчыну Тваю, апаганілі сьвятыню Тваю сьвятую, Ерусалім ператварылі ў купу друзу . ");
INSERT INTO beln_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Трупы слугаў Тваіх аддалі на ежу птушкам нябесным, целы багабойных Тваіх — зьвярам зямным. ");
INSERT INTO beln_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Вылілі кроў іхнюю, як ваду, вакол Ерусаліму, і не было каму іх хаваць. ");
INSERT INTO beln_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Мы сталіся ганьбаваньнем для суседзяў нашых, кпінамі і насьмешкамі для тых, што навокал нас. ");
INSERT INTO beln_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Як доўга, ГОСПАДЗЕ? Ці будзеш гневацца заўсёды? Ці як агонь будзе палаць рэўнасьць Твая? ");
INSERT INTO beln_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Вылі ярасьць Тваю на народы, якія ня ведаюць Цябе, і на валадарствы, якія імя Твайго ня клічуць, ");
INSERT INTO beln_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","бо зжэрлі Якуба і жытло ягонае спустошылі. ");
INSERT INTO beln_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Ня ўзгадвай нам беззаконьняў ранейшых; няхай чым хутчэй сустрэне нас літасьць Твая, бо вельмі мы зьнемагліся. ");
INSERT INTO beln_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Дапамажы нам, Божа збаўленьня нашага, дзеля славы імя Твайго; выратуй нас і даруй грахі нашыя дзеля імя Твайго! ");
INSERT INTO beln_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Навошта казаць паганам: “Дзе Бог іхні?” Няхай на паганах, у нас на вачох, вядомай станецца помста за кроў слугаў Тваіх, што праліта! ");
INSERT INTO beln_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Няхай дойдуць перад аблічча Тваё стогны вязьняў! Паводле вялікасьці рамяна Твайго пакінь пры жыцьці сыноў, сказаных на сьмерць. ");
INSERT INTO beln_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","І нашым суседзям вярні сямікротна ў грудзі іхнія зьнявагу іхнюю, якой яны, Госпадзе, Цябе зьневажалі! ");
INSERT INTO beln_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","А мы, Твой народ і авечкі чарады Тваёй, будзем славіць Цябе вечна і з пакаленьня ў пакаленьне будзем абвяшчаць хвалу Тваю. ");
INSERT INTO beln_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Кіраўніку хору: на лад: “Лілея сьведчаньня”. Псальм Асафа. ");
INSERT INTO beln_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Пастыру Ізраіля, прыхілі вуха! Ты, Які, як авечкі, водзіш Язэпа, Які на херувімах сядаеш, зазьзяй! ");
INSERT INTO beln_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Перад абліччам Эфраіма, і Бэн’яміна, і Манасы абудзі магутнасьць Тваю і прыйдзі збавіць нас! ");
INSERT INTO beln_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Божа, вярні нас назад. Асьвяці нас абліччам Тваім, і будзем збаўленыя! ");
INSERT INTO beln_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","ГОСПАДЗЕ, Божа Магуцьцяў, дакуль Ты будзеш ў гневе пры малітве народу Твайго? ");
INSERT INTO beln_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ты накарміў іх хлебам сьлёзаў і шчодра сьлязамі напаіў іх. ");
INSERT INTO beln_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Ты паставіў нас як костку нязгоды дзеля суседзяў нашых, і ворагі нашыя кпяць над намі. ");
INSERT INTO beln_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Божа Магуцьцяў, вярні нас назад. Асьвяці нас абліччам Тваім, і будзем збаўленыя! ");
INSERT INTO beln_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ты вінаградную лазу вынес з Эгіпту, выгнаў народы і яе пасадзіў. ");
INSERT INTO beln_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ты расчысьціў месца перад абліччам яе, і ўкараніў карані ейныя, і яна напоўніла зямлю. ");
INSERT INTO beln_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Горы пакрыліся ценем яе, і вецьце яе — як кедры Божыя. ");
INSERT INTO beln_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Яна пусьціла галіны свае аж да мора, і парасткі свае — да ракі. ");
INSERT INTO beln_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Чаму Ты раскідаў агароджу ейную, і кожны, хто ідзе дарогаю, абрывае яе? ");
INSERT INTO beln_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Дзік лясны падкопвае яе, і зьвер палявы пасьвіцца ў ёй. ");
INSERT INTO beln_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Божа Магуцьцяў, павярніся да нас, зірні з неба, і паглядзі, і наведай вінаградную лазу гэтую! ");
INSERT INTO beln_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Захавай тое, што правіца Твая пасадзіла, і парасткі, якія Ты для Сябе ўмацаваў. ");
INSERT INTO beln_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Яны спалены агнём і пасечаны, і гінуць ад гневу аблічча Твайго. ");
INSERT INTO beln_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Няхай рука Твая будзе над мужам правіцы Тваёй, над сынам чалавечым, якога Ты ўмацаваў для Сябе! ");
INSERT INTO beln_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","А мы не адступімся ад Цябе; ажыві нас, і мы будзем клікаць імя Тваё. ");
INSERT INTO beln_vpl VALUES ("PS80_20","020_80_20","PSA","80","20","20","ГОСПАДЗЕ, Божа Магуцьцяў, вярні нас назад. Асьвяці нас абліччам Тваім, і будзем збаўленыя! ");
INSERT INTO beln_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Кіраўніку хору: на лад Гітыт. Асафа. ");
INSERT INTO beln_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Весяліцеся перад Богам моцы нашай; радасна гукайце Богу Якубаваму! ");
INSERT INTO beln_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Пачніце сьпяваньне, вазьміце бубны, гусьлі мілагучныя і псалтыр. ");
INSERT INTO beln_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Дзьміце ў трубу ў маладзік, у поўню, у дзень нашага сьвята, ");
INSERT INTO beln_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","бо гэткая пастанова у Ізраілі, закон Бога Якубавага. ");
INSERT INTO beln_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Ён паставіў гэта на сьведчаньне для Язэпа, калі выводзіў з зямлі Эгіпецкай, і мы пачулі мову, якой ня ведалі: ");
INSERT INTO beln_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","“Я прыбраў цяжар з плячэй ягоных, рукі ягоныя вольныя ад кашоў. ");
INSERT INTO beln_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","У бядзе ты паклікаў Мяне, і Я выратаваў цябе; адказаў табе з-за заслоны грымотаў, выспрабаваў цябе пры водах Мэрыбы. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Слухай, народзе Мой! Я буду сьведчыць супраць цябе, Ізраіль, каб ты паслухаў Мяне, ");
INSERT INTO beln_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","і не было ў цябе бога чужога, і не пакланяўся ты богу чужынцаў! ");
INSERT INTO beln_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Я — ГОСПАД, Бог твой, Які вывеў цябе з зямлі Эгіпецкай! Расчыні шырока вусны твае, і Я напоўню іх. ");
INSERT INTO beln_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ды народ Мой не паслухаў голасу Майго, і Ізраіль ня быў паслухмяны Мне. ");
INSERT INTO beln_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Дык Я пакінуў іх закамянеласьці сэрца іхняга, і яны хадзілі паводле намераў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","О, калі б народ Мой паслухаў Мяне, калі б Ізраіль хадзіў шляхамі Маімі, ");
INSERT INTO beln_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Я б неўзабаве ўпакорыў ворагаў іхніх, і супраць прыгнятальнікаў іхніх павярнулася б рука Мая. ");
INSERT INTO beln_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Тыя, што ГОСПАДА ненавідзяць, падпарадкаваліся б ім, а шчасьце іхняе трывала б на вякі. ");
INSERT INTO beln_vpl VALUES ("PS81_17","020_81_17","PSA","81","17","17","І Я карміў бы іх з тлустасьці пшаніцы, мёдам са скалы насычаў бы іх”. ");
INSERT INTO beln_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Псальм Асафа. Бог стаіць на сходзе багоў, сярод багоў Ён судзіць: ");
INSERT INTO beln_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Дакуль будзеце судзіць беззаконна і ўздымаць абліччы бязбожнікаў? (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Судзіце беднага і сірату; убогага і бедака апраўдайце. ");
INSERT INTO beln_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Ратуйце беднага і гаротнага, з рукі бязбожнікаў вызваляйце! ");
INSERT INTO beln_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Нічога ня ведаюць і не разумеюць, і ў цемры ходзяць; і захісталіся ўсе падваліны зямлі! ");
INSERT INTO beln_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Я сказаў: “Вы — богі, усе вы — сыны Найвышэйшага, ");
INSERT INTO beln_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","аднак, вы памрацё, як людзі, упадзеце, як адзін з князёў. ");
INSERT INTO beln_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Паўстань, Божа, судзі зямлю, бо Ты возьмеш у спадчыну ўсе народы. ");
INSERT INTO beln_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Сьпеў. Псальм Асафа. ");
INSERT INTO beln_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Божа! Не маўчы, і ня будзь у маўчаньні і ў супакоі, Божа! ");
INSERT INTO beln_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Бо вось, узварухнуліся ворагі Твае, і ненавісьнікі Тваі паднялі галаву. ");
INSERT INTO beln_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Супраць народу Твайго яны кнуюць намеры таемныя і радзяцца супраць тых, каго Ты ахоўваеш. ");
INSERT INTO beln_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Яны сказалі: “Хадзіце і сатрэм іх між народамі, і імя Ізраіля ня будзе ўзгадвацца болей”. ");
INSERT INTO beln_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Бо радзіліся яны аднадумна, супраць Цябе заключылі запавет ");
INSERT INTO beln_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","намёты Эдому і Ізмаэляне, Мааў і Агаране, ");
INSERT INTO beln_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Геваль і Амон і Амалек, Філістынцы і жыхары Тыру. ");
INSERT INTO beln_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","І Асур далучыўся да іх, стаўся ён рамяном для сыноў Лёта. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Зрабі ж Ты ім як Мадыяну, як Сісэры, як Явіну ля ручая Кішон, ");
INSERT INTO beln_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","якія зьнішчаныя каля Эндору, сталіся як гной на зямлі. ");
INSERT INTO beln_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Учыні з імі, з магнатамі іхнімі як з Арэвам і Зэвам, і з усімі князямі іхнімі, як з Зэвахам і Сальмунам, ");
INSERT INTO beln_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","якія казалі: “Возьмем сабе ў спадчыну сялібы Божыя!” ");
INSERT INTO beln_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Божа мой! Зрабі іх як пыл у віхуры, як салому пад ветрам! ");
INSERT INTO beln_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Як агонь паліць лясы і як полымя апальвае горы, ");
INSERT INTO beln_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","гэтак перасьледуй Ты іх бурай Тваёю і віхрам Тваім напалохай! ");
INSERT INTO beln_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Напоўні сорамам твары іхнія, і будуць шукаць імя Тваё, ГОСПАДЗЕ. ");
INSERT INTO beln_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Няхай будуць асаромленыя і спалоханыя навечна, няхай будуць у сораме і загінуць, ");
INSERT INTO beln_vpl VALUES ("PS83_19","020_83_19","PSA","83","19","19","і пазнаюць, што імя Тваё — ГОСПАД, і толькі Ты — Найвышэйшы над усёй зямлёю. ");
INSERT INTO beln_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Кіраўніку хору: на лад Гітыт. Сыноў Караха. Псальм. ");
INSERT INTO beln_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Як умілаваныя сялібы Твае, ГОСПАД Магуцьцяў! ");
INSERT INTO beln_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Прагне і тужыць душа мая па панадворках ГОСПАДА; сэрца маё і цела маё весяляцца ў Богу Жывым. ");
INSERT INTO beln_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Нават птушка адшукала дом, ластаўка — гняздо для сябе, дзе птушанятак сваіх укладае: ля ахвярнікаў Тваіх, ГОСПАД Магуцьцяў, Валадар мой і Бог мой! ");
INSERT INTO beln_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Шчасьцівыя тыя, што жывуць у доме Тваім, заўсёды яны выхваляюць Цябе. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Шчасьлівы чалавек, сіла якога ў Табе, і ў сэрцы якога дарога да Цябе! ");
INSERT INTO beln_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Праходзячы далінаю Бака, яны адкрываюць крыніцы, і дождж раньні пакрывае яе дабраслаўленьнем. ");
INSERT INTO beln_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Ідуць яны ад сілы да сілы, і прыходзяць да Бога на Сыён. ");
INSERT INTO beln_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","ГОСПАДЗЕ, Божа Магуцьцяў, пачуй малітву маю! Прыхілі вуха, Божа Якубавы! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Божа, шчыце наш! Зірні і паглядзі на аблічча памазанца Твайго! ");
INSERT INTO beln_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Бо адзін дзень на панадворку Тваім лепшы за тысячу іншых; я выбіраю стаяць ля парога ў доме Божым, чым жыць у намётах беззаконьня. ");
INSERT INTO beln_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Бо ГОСПАД Бог ёсьць сонца і шчыт; ГОСПАД дае ласку і славу, і не адмовіць дабра аніякага тым, што ў беззаганнасьці ходзяць. ");
INSERT INTO beln_vpl VALUES ("PS84_13","020_84_13","PSA","84","13","13","ГОСПАД Магуцьцяў! Шчасьлівы чалавек, які на Цябе спадзяецца! ");
INSERT INTO beln_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Кіраўніку хору. Сыноў Караха. Псальм. ");
INSERT INTO beln_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ты зьявіў ласку, ГОСПАДЗЕ, для зямлі Тваёй, Ты вярнуў палон Якуба. ");
INSERT INTO beln_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Ты дараваў віну народу Твайго, Ты пакрыў усе грахі іхнія. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ты стрымаў усю лютасьць Тваю, адвярнуў жар гневу Твайго. ");
INSERT INTO beln_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Вярні нас, Божа збаўленьня нашага, і супыні абурэньне Тваё на нас. ");
INSERT INTO beln_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Няўжо вечна будзеш гневацца на нас і гнеў Твой працягнеш з пакаленьня ў пакаленьне? ");
INSERT INTO beln_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Няўжо не павернешся, каб ажывіць нас, каб народ Твой узрадаваўся ў Табе? ");
INSERT INTO beln_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Дай нам убачыць, ГОСПАДЗЕ, міласэрнасьць Тваю, і збаўленьне Тваё дай нам! ");
INSERT INTO beln_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Паслухаю, што кажа Бог ГОСПАД, бо Ён кажа пра супакой для народу Свайго і для багабойных Сваіх, і няхай не зьвяртаюцца яны да глупоты. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Вось, блізка збаўленьне Ягонае для тых, што баяцца Яго, каб слава Божая пасялілася на зямлі нашай. ");
INSERT INTO beln_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Міласэрнасьць і праўда сустрэнуцца, праведнасьць і супакой пацалуюцца. ");
INSERT INTO beln_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Праўда ўзыйдзе з зямлі, і праведнасьць з неба глядзець будзе. ");
INSERT INTO beln_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","І ГОСПАД дасьць даброцьце, і зямля наша дасьць ураджай свой. ");
INSERT INTO beln_vpl VALUES ("PS85_14","020_85_14","PSA","85","14","14","Праведнасьць будзе ісьці перад абліччам Яго і будзе стаяць на шляху крокаў Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Малітва Давіда. Прыхілі, ГОСПАДЗЕ, вуха Тваё, адкажы мне, бо я — бедны і прыгнечаны. ");
INSERT INTO beln_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Захавай душу маю, бо я багабойны. Збаў Ты, Божа, слугу Твайго, які на Цябе спадзяецца. ");
INSERT INTO beln_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Зьлітуйся нада мною, Госпадзе, бо я клічу да Цябе ўвесь дзень. ");
INSERT INTO beln_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Узрадуй душу слугі Твайго, бо да Цябе, Госпадзе, я душу маю ўзьнімаю. ");
INSERT INTO beln_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Бо Ты, Госпадзе, — добры і літасьцівы, і вельмі міласэрны для ўсіх, што Цябе клічуць. ");
INSERT INTO beln_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Прыхілі вуха, ГОСПАДЗЕ, на малітву маю і выслухай голас маленьня майго! ");
INSERT INTO beln_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","У дзень тугі маёй я клічу Цябе, бо Ты адкажаш мне. ");
INSERT INTO beln_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Няма між багамі падобнага да Цябе, Госпадзе, і няма такіх чынаў, як Твае. ");
INSERT INTO beln_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Усе народы, якія Ты стварыў, прыйдуць і паклоняцца прад абліччам Тваім, Госпадзе, і будуць ушаноўваць імя Тваё. ");
INSERT INTO beln_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Бо Ты — вялікі і робіш цуды, Ты — Бог, толькі Ты адзін. ");
INSERT INTO beln_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Навучы мяне, ГОСПАДЗЕ, шляху Твайму, каб хадзіў я ў праўдзе Тваёй; з’яднай сэрца маё, каб баялася імя Твайго. ");
INSERT INTO beln_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Буду славіць Цябе, Госпадзе, Божа мой, усім сэрцам маім, і буду ўшаноўваць імя Тваё на вякі. ");
INSERT INTO beln_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Бо міласэрнасьць Твая нада мною вялікая, і Ты выратаваў душу маю з глыбіні пекла. ");
INSERT INTO beln_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Божа, пыхлівы паўстаў супраць мяне, і грамада моцных шукае душу маю, і на Цябе не зважаюць яны. ");
INSERT INTO beln_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Але Ты, Госпадзе, — Бог спагадлівы і літасьцівы, павольны да гневу і багаты на міласэрнасьць і праўду. ");
INSERT INTO beln_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Павярніся да мяне і зьлітуйся нада мною; дай сілу Тваю слузе Твайму і збаў сына служкі Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Учыні Ты для мяне знак добрасьці Тваёй, і ўгледзяць гэта тыя, што ненавідзяць мяне, і будуць асаромленыя, бо Ты, ГОСПАДЗЕ, мне дапамог і пацешыў мяне. ");
INSERT INTO beln_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Сыноў Караха. Псальм. Сьпеў. Угрунтаваньне ягонае на гарах сьвятых. ");
INSERT INTO beln_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Любіць ГОСПАД брамы Сыёну больш за ўсе іншыя сялібы Якуба. ");
INSERT INTO beln_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Слаўныя рэчы казаныя пра цябе, горад Божы! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Узгадаю пра Рагаў і Бабілён перад тымі, што ведаюць мяне. Вось, Філістына і Тыр разам з Кушам скажуць: “Гэты нарадзіўся там”. ");
INSERT INTO beln_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","А пра Сыён будуць казаць: “Той чалавек і той чалавек нарадзіўся ў ім, і Найвышэйшы ўзмацняе яго”. ");
INSERT INTO beln_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","ГОСПАД палічыць, запісваючы народы: “Гэты нарадзіўся там” . (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","І тыя, што сьпяваюць, і тыя, што таньчаць скажуць: “Усе мае крыніцы ў Табе!”. ");
INSERT INTO beln_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Сьпеў. Псальм сыноў Караха. Кіраўніку хору: на лад сумны, суцішаны. Навучаньне Гемана Эзрахі. ");
INSERT INTO beln_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","ГОСПАДЗЕ, Божа збаўленьня майго! Удзень я крычу, і ўначы я перад Табою! ");
INSERT INTO beln_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Няхай прыйдзе перад аблічча Тваё малітва мая; прыхілі вуха Тваё да галашэньня майго. ");
INSERT INTO beln_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Бо перасычана ліхоцьцем душа мая, і жыцьцё маё дакранаецца да пекла. ");
INSERT INTO beln_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Я залічаны да тых, што зыходзяць у магілу; я стаўся, як чалавек, які сілы ня мае. ");
INSERT INTO beln_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Сярод памёршых, свабодны, падобны да забітых, што ляжаць у магіле, якіх Ты ўжо не ўзгадваеш, і адсечаны яны ад рукі Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Ты кінуў мяне ў яму найглыбейшую, у месца цёмнае, у глыбіню. ");
INSERT INTO beln_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Націснула на мяне ярасьць Твая, і ўсімі хвалямі Тваімі прыціснуў Ты мяне. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ты аддаліў ад мяне знаёмых маіх, Ты зрабіў мяне агідным для іх; я зьвязаны і выйсьці не магу. ");
INSERT INTO beln_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Самлела вока маё ад пакутаў; кожны дзень я клічу Цябе, ГОСПАДЗЕ, і выцягваю да Цябе рукі мае. ");
INSERT INTO beln_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Ці Ты зробіш цуд для памёршых? Ці нябожчыкі паўстануць і будуць славіць Цябе? (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Ці будзе абвешчана ў магіле міласэрнасьць Твая, і вернасьць Твая — у месцы загубы? ");
INSERT INTO beln_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Ці ў цемры даведаюцца пра цуды Твае, і пра справядлівасьць Тваю — у зямлі забыцьця? ");
INSERT INTO beln_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Але я галашу да Цябе, ГОСПАДЗЕ, і раніцаю малітва мая сустракае Цябе. ");
INSERT INTO beln_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Дзеля чаго, ГОСПАДЗЕ, Ты пакінуў душу маю, хаваеш аблічча Тваё ад мяне? ");
INSERT INTO beln_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","З маленства я прыгнечаны і паміраю; пераносячы жахі Твае, я зьнямогся. ");
INSERT INTO beln_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Нада мною прайшоў жар гневу Твайго, пагрозы Твае вынішчаюць мяне, ");
INSERT INTO beln_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","атачаюць мяне, як вада, кожны дзень, абступаюць мяне разам. ");
INSERT INTO beln_vpl VALUES ("PS88_19","020_88_19","PSA","88","19","19","Ты аддаліў ад мяне тых, што любяць мяне, і бліжніх, знаёмыя мае — у цемры. ");
INSERT INTO beln_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Навучаньне Этана Эзрахі. ");
INSERT INTO beln_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Пра міласэрнасьць ГОСПАДА буду сьпяваць вечна; з пакаленьня ў пакаленьне буду апавядаць пра вернасьць Тваю вуснамі маімі. ");
INSERT INTO beln_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Бо я сказаў: “Навечна збудаваная міласэрнасьць, на нябёсах Ты ўгрунтаваў вернасьць Тваю”. ");
INSERT INTO beln_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","“Я заключыў запавет Мой з выбранцам Маім, прысягнуў Давіду, слузе Майму: ");
INSERT INTO beln_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","На вякі ўгрунтую насеньне тваё, збудую пасад твой з пакаленьня ў пакаленьне. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","І нябёсы славяць цуды Твае, ГОСПАДЗЕ, і вернасьць Тваю — у зграмаджэньні сьвятых. ");
INSERT INTO beln_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Бо хто параўнаецца ў аблоках з ГОСПАДАМ? Хто падобны да ГОСПАДА сярод сыноў Божых? ");
INSERT INTO beln_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Бог гэтак страшлівы на нарадзе сьвятых, і страшны для ўсіх, што вакол Яго. ");
INSERT INTO beln_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","ГОСПАДЗЕ, Божа Магуцьцяў, хто гэтакі моцны, як Ты, ГОСПАДЗЕ? І вернасьць Твая навакол Цябе. ");
INSERT INTO beln_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ты пануеш над узьнёсласьцю мора, і калі хвалі ўздымаюцца, Ты іх сьцішаеш. ");
INSERT INTO beln_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ты скрышыў Рагава, быццам параненага; рамяном моцы Тваёй Ты раскідаў ворагаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Тваё ёсьць неба, і Твая — зямля; сусьвет і ўсё, што ў ім, Ты заснаваў. ");
INSERT INTO beln_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Поўнач і поўдзень — Ты іх стварыў; Табор і Гермон радуюцца дзеля імя Твайго. ");
INSERT INTO beln_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Рамяно Тваё магутнае; рука Твая дужая, ўзьнятая правіца Твая. ");
INSERT INTO beln_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Праведнасьць і суд — падставы пасаду Твайго; міласэрнасьць і праўда ідуць перад абліччам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Шчасьлівы народ, які ведае трубны голас Твой. ГОСПАДЗЕ, яны ходзяць ў сьвятле аблічча Твайго! ");
INSERT INTO beln_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","У іменьні Тваім будуць радавацца яны ўвесь дзень, і праведнасьцю Тваёй будуць узвышаны. ");
INSERT INTO beln_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Бо Ты — краса сілы іхняй, і праз ласку Тваю ўзьняты рог наш. ");
INSERT INTO beln_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Бо ад ГОСПАДА шчыт наш, і ад Сьвятога Ізраіля валадар наш. ");
INSERT INTO beln_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Тады гаворачы у відзежы да багабойнага Твайго, Ты сказаў: “Я даў успамогу волату, узвысіў юнака з народу. ");
INSERT INTO beln_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Знайшоў Я Давіда, слугу Майго, сьвятым алеем Маім памазаў яго. ");
INSERT INTO beln_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Рука Мая ўмацуе яго, і плячо Маё ўзмоцніць яго. ");
INSERT INTO beln_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Не пераможа вораг яго, і сын беззаконьня не асіліць яго. ");
INSERT INTO beln_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","І скрышу перад абліччам ягоным тых, што прыгнятаюць яго, а тых, што ненавідзяць яго, павалю. ");
INSERT INTO beln_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","І будзе вернасьць Мая і міласэрнасьць Мая з ім, і ў імя Маё ўзьнясецца рог ягоны. ");
INSERT INTO beln_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","І палажу руку ягоную на мора, а правіцу ягоную — на рэках. ");
INSERT INTO beln_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ён будзе клікаць Мяне: “Ты — Бацька Мой, Ты — Бог мой і скала збаўленьня майго!” ");
INSERT INTO beln_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Я зраблю яго першародным, найвышэйшым між валадароў зямлі. ");
INSERT INTO beln_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Навякі захоўваючы, захаваю для яго міласэрнасьць Маю, і запавет Мой з ім будзе верным. ");
INSERT INTO beln_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","І зраблю, што насеньне ягонае будзе трываць вечна, і пасад ягоны — як дні нябёсаў. ");
INSERT INTO beln_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Калі сыны ягоныя пакінуць закон Мой і ня будуць хадзіць паводле судоў Маіх, ");
INSERT INTO beln_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","калі парушаць пастановы Мае і прыказаньняў Маіх ня будуць захоўваць, ");
INSERT INTO beln_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Я наведаю правіны іхнія з кіем, і карамі беззаконьні іхняе, ");
INSERT INTO beln_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","але міласэрнасьці Маёй не забяру ў яго, і вернасьці Маёй ня здраджу. ");
INSERT INTO beln_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Не парушу Я запавету Майго і таго, што выйшла з вуснаў Маіх, не зьмяню. ");
INSERT INTO beln_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Раз Я пакляўся ў сьвятасьці Маёй, што не схлушу Давіду. ");
INSERT INTO beln_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Насеньне ягонае будзе на вякі, і пасад ягоны — як сонца перада Мною. ");
INSERT INTO beln_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Як месяц будзе умацаваны ён на вякі, а сьведка ў небе — верны. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Але Ты пакінуў і пагрэбаваў, адвярнуўся ад памазанца Твайго! ");
INSERT INTO beln_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ты пагардзіў запаветам са слугою Тваім, кінуў на зямлю дыядэму ягоную. ");
INSERT INTO beln_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Ты збурыў усе загарадкі ягоныя, прывёў загубу ў замкі ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Усе, што праходзілі дарогаю, рабавалі яго; ён стаўся ганьбаю для суседзяў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ты ўзьняў правіцы тых, што перасьледавалі яго, і ўзрадаваў ўсіх ворагаў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ты назад павярнуў джала мяча ягонага і ня даў перамогі ў вайне, ");
INSERT INTO beln_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ты прыбраў бляск ягоны і пасад яго паваліў на зямлю. ");
INSERT INTO beln_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Ты скараціў дні моладасьці ягонай, ганьбай пакрыў яго. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Як доўга, ГОСПАДЗЕ? Ці назаўсёды Ты будзеш хавацца? Ці будзе палаць як агонь ярасьць Твая? ");
INSERT INTO beln_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Узгадай, які век мой, якой марнасьцю Ты стварыў ўсіх сыноў чалавечых! ");
INSERT INTO beln_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Хто з людзей можа жыць і ня ўгледзіць сьмерці? Хто выбавіць душу сваю з рукі пекла? (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Дзе, Госпадзе, даўнейшая міласэрнасьць Твая, як Ты прысягаў Давіду ў вернасьці Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Узгадай, Госпадзе, ганьбу слугаў Тваіх, што ў нутры я нашу ад усіх народаў шматлікіх, ");
INSERT INTO beln_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","якою зьневажаюць ворагі Твае, ГОСПАДЗЕ, якой зьневажаюць сьляды памазанца Твайго! ");
INSERT INTO beln_vpl VALUES ("PS89_53","020_89_53","PSA","89","53","53","Няхай будзе дабраслаўлёны ГОСПАД на вякі. Амэн! Амэн! ");
INSERT INTO beln_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Малітва Майсея, мужа Божага. Госпадзе, Ты быў для нас сялібаю з пакаленьня ў пакаленьне! ");
INSERT INTO beln_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Перш, чым горы нарадзіліся, і Ты даў кшталт зямлі і сусьвету, ад веку і на вякі Ты ёсьць Бог. ");
INSERT INTO beln_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ты вяртаеш у друз чалавека і кажаш: “Вярніцеся, сыны Адама!” ");
INSERT INTO beln_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Бо тысяча год перад вачыма Тваімі — як учорашні дзень, што мінуў, і варта начная. ");
INSERT INTO beln_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ты іх зносіш разводзьдзем; яны — як сон; і як трава, якая раніцаю зелянее, ");
INSERT INTO beln_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","раніцаю квітнее яна і зелянее, а ўвечары зрэжуць яе і сохне. ");
INSERT INTO beln_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Бо мы зьнікаем ад гневу Твайго, ад ярасьці Тваёй мы спалоханыя. ");
INSERT INTO beln_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ты паклаў беззаконьні нашыя перад Сабою, нашыя схаваныя грахі — перад сьветласьцю аблічча Твайго. ");
INSERT INTO beln_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Бо ўсе дні нашыя прападаюць ад абурэньня Твайго, гады нашы сканчваюцца, быццам той уздых. ");
INSERT INTO beln_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Дзён гадоў нашых — гадоў семдзесят, а як пры сіле — гадоў восемдзесят; і найлепшае ў іх — гарапашнасьць і ліхоцьце, бо прамінаюць яны шыбка, і мы адлятаем. ");
INSERT INTO beln_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Хто ведае моц гневу Твайго і абурэньне Тваё, што як страх прад Табою? ");
INSERT INTO beln_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Лічыць нашыя дні навучы Ты нас, каб прыдбаць нам мудрае сэрца. ");
INSERT INTO beln_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Павярніся, ГОСПАДЗЕ! Дакуль Ты? Пашкадуй слугаў Тваіх! ");
INSERT INTO beln_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Насыць нас раніцаю міласэрнасьцю Тваёй, каб мы весяліліся і радаваліся ў-ва ўсе нашы дні. ");
INSERT INTO beln_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Узрадуй Ты нас паводле дзён, у якія Ты прыгнятаў нас, і паводле гадоў, у якія мы бачылі ліхое. ");
INSERT INTO beln_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Няхай зьявіцца над слугамі Тваімі справа Твая, і веліч Твая — над сынамі іхнімі. ");
INSERT INTO beln_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Няхай хараство Госпада, Бога нашага, будзе над намі і ўмацуе справы рук нашых. Умацуй Ты справы рук нашых! ");
INSERT INTO beln_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Той, які жыве пад заслонай Найвышэйшага і пад ценем Усемагутнага, ");
INSERT INTO beln_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","кажа да ГОСПАДА: “Ты – прыстанішча маё і цьвярдыня мая, мой Бог, на Якога спадзяюся”. ");
INSERT INTO beln_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Бо Ён выратуе цябе ад пасткі птушкалова, ад пошасьці сьмяротнай. ");
INSERT INTO beln_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Пер’ем Сваім закрые цябе, і пад крыламі Ягонымі будзеш мець надзею; праўда Ягоная — шчыт і заслона. ");
INSERT INTO beln_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Не спалохаешся страху ўначы, ані стралы, якая ўдзень ляціць, ");
INSERT INTO beln_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","ані пошасьці, якая ў цемры прыходзіць, ані заразы, якая сярод белага дня пустошыць. ");
INSERT INTO beln_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Тысяча побач з табой упадзе і дзесяць тысячаў праваруч ад цябе, а да цябе яна не падыйдзе. ");
INSERT INTO beln_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Толькі вачыма тваімі глядзець будзеш і ўбачыш з бязбожнымі расплату. ");
INSERT INTO beln_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","За тое, што ты ГОСПАДА, прыбежышча сваё, і Найвышэйшага выбраў за сялібу сабе, ");
INSERT INTO beln_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","не спаткае цябе злое, і пакараньне не наблізіцца да намёту твайго. ");
INSERT INTO beln_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Бо Ён анёлам Сваім загадае пра цябе, каб захоўвалі цябе на ўсіх шляхах тваіх. ");
INSERT INTO beln_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","На руках панясуць цябе, каб не спатыкнуўся аб камень нагою тваёю. ");
INSERT INTO beln_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Па ільвах і гадзюках хадзіць будзеш, львянятаў і цмокаў патопчаш. ");
INSERT INTO beln_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","“За тое, што ён Мяне ўзьлюбіў, збаўлю яго; узвышу яго, бо імя Маё ведае. ");
INSERT INTO beln_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Будзе клікаць Мяне, і Я адкажу яму; у бядзе Я буду з ім, выратую яго і ўшаную яго. ");
INSERT INTO beln_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Доўгімі днямі насычу яго і дам убачыць збаўленьне Маё”. ");
INSERT INTO beln_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Псальм. Сьпеў на дзень суботы. ");
INSERT INTO beln_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Добра славіць ГОСПАДА і выслаўляць імя Тваё, Найвышэйшы! ");
INSERT INTO beln_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Апавядаць раніцаю міласэрнасьць Тваю, і вернасьць Тваю — ўначы, ");
INSERT INTO beln_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","на дзесяціструнным псалтыры і на гусьлях граючы. ");
INSERT INTO beln_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Бо Ты ўзьвесяліў мяне, ГОСПАДЗЕ, справамі Тваімі, творам рук Тваіх буду радавацца. ");
INSERT INTO beln_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Якія вялікія ўчынкі Твае, ГОСПАДЗЕ; вельмі глыбокія думкі Твае. ");
INSERT INTO beln_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Чалавек бязглузды ня будзе ведаць, і дурань не зразумее гэтага. ");
INSERT INTO beln_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Калі бязбожнікі зелянеюць, як трава, і ўсе ліхадзеі квітнеюць, няхай будуць яны зьнішчаны на вякі! ");
INSERT INTO beln_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","А Ты, ГОСПАДЗЕ, узвышаны навекі! ");
INSERT INTO beln_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Бо вось ворагі Твае, ГОСПАДЗЕ, бо вось ворагі Твае загінуць, і будуць расьцярушаныя ўсе ліхадзеі. ");
INSERT INTO beln_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","І Ты ўзнясеш мой рог, як у аднарога, я буду памазаны сьвежым алеем. ");
INSERT INTO beln_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Будуць глядзець вочы мае на ворагаў маіх, і пра злачынцаў, якія паўсталі супраць мяне, пачуюць вушы мае. ");
INSERT INTO beln_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Праведнік быццам пальма зелянее, ён расьце, як той кедр на Лібане. ");
INSERT INTO beln_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Насаджаныя ў доме ГОСПАДА, зелянеюць на панадворках Бога нашага. ");
INSERT INTO beln_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Яны плод свой даюць і ў старасьці, яны сакавітыя і сьвежыя, ");
INSERT INTO beln_vpl VALUES ("PS92_16","020_92_16","PSA","92","16","16","каб абвяшчаць, што ГОСПАД справядлівы, скала мая, і няма ў Ім беззаконьня. ");
INSERT INTO beln_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","ГОСПАД валадарыць, апрануўся ў веліч, апрануўся ГОСПАД у моц і падперазаўся. Ён сусьвет умацаваў, што не захістаецца. ");
INSERT INTO beln_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Умацаваны пасад Твой ад спрадвечных часоў; і Ты — спакон вякоў! ");
INSERT INTO beln_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Узьнімаюць рэкі, ГОСПАДЗЕ, узьнімаюць рэкі голас свой, узьнімаюць рэкі хвалі свае. ");
INSERT INTO beln_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Слаўнейшы за голас водаў вялікіх, за хвалі марскія — слаўны на вышынях ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Сьведчаньні Твае вельмі верныя; сьвятасьць аздабляе дом Твой, ГОСПАДЗЕ, на вечныя дні! ");
INSERT INTO beln_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Божа помсты, ГОСПАДЗЕ, Божа помсты, зазьзяй! ");
INSERT INTO beln_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Узьніміся, Судзьдзя зямлі, аднагародзь пыхліўцам за тое, што зрабілі яны! ");
INSERT INTO beln_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Дакуль бязбожнікі, ГОСПАДЗЕ, дакуль бязбожнікі будуць радавацца? ");
INSERT INTO beln_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Дакуль будуць плявузгаць, гаварыць дзёрзка, прамаўляць усе злачынцы. ");
INSERT INTO beln_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Яны крышаць народ Твой, ГОСПАДЗЕ, прыціскаюць спадчыну Тваю. ");
INSERT INTO beln_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Удоваў і прыхадняў мардуюць і сіротаў забіваюць, ");
INSERT INTO beln_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","і кажуць: “Ня ўбачыць гэтага ГОСПАД, і не даведаецца Бог Якубавы!” ");
INSERT INTO beln_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Зразумейце, бязглуздыя з народу! І калі, бязглуздыя, паразумнееце? ");
INSERT INTO beln_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Ці ж Той, Які вуха стварыў, не пачуе? Ці ж Той, Які вока ўфармаваў, ня ўбачыць? ");
INSERT INTO beln_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ці ж Той, Які навучае народы, ня будзе караць, Той, Які вучыць чалавека ведам? ");
INSERT INTO beln_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","ГОСПАД ведае думкі чалавечыя, што яны — марнасьць. ");
INSERT INTO beln_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Шчасьлівы чалавек, якога Ты, ГОСПАДЗЕ, навучаеш і вучыш яго закону Твайму, ");
INSERT INTO beln_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","каб быў ён у супакоі ў дні ліхія, пакуль выкапаны будзе дол для бязбожніка. ");
INSERT INTO beln_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Бо не адкіне ГОСПАД народ Свой, і спадчыну Сваю не пакіне. ");
INSERT INTO beln_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Бо зьвернецца суд да справядлівасьці, і пойдуць за ім усе правыя сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Хто за мяне супраць злачынцаў паўстане? Хто заступіцца за мяне супраць тых, што робяць злачынства? ");
INSERT INTO beln_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Калі б ГОСПАД ня быў успамогай мне, хутка душа мая пасялілася б у месцы маўчаньня. ");
INSERT INTO beln_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Калі я сказаў: “Хістаецца нага мая!”, міласэрнасьць Твая, ГОСПАДЗЕ, ўмацавала мяне. ");
INSERT INTO beln_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Калі мноства цяжкіх думак у нутры маім, пацяшэньні Твае падбадзёрваюць душу маю. ");
INSERT INTO beln_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ці ж можа таварышаваць з Табою пасад загубы, які чыніць ліхоцьце супраць пастановы Тваёй? ");
INSERT INTO beln_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Яны зьбіраюцца супраць душы праведніка і кроў нявінную асуджаюць. ");
INSERT INTO beln_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Але ГОСПАД стаўся умацаваным замкам для мяне, і Бог мой — скалой прыстанішча майго. ");
INSERT INTO beln_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","І зьверне Ён на іх злачынства іхняе, і ў ліхоце іхняй вынішчыць іх; вынішчыць іх ГОСПАД, Бог наш. ");
INSERT INTO beln_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Хадземце, будзем весяліцца ў ГОСПАДЗЕ, усклікаць Скале збаўленьня нашага! ");
INSERT INTO beln_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Станьма перад абліччам Яго з падзякаю, гімны ўсклікайма Яму! ");
INSERT INTO beln_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Бо ГОСПАД ёсьць Бог вялікі і Валадар вялікі над усімі багамі. ");
INSERT INTO beln_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","У руцэ Ягонай глыбіні зямлі, і Ягоныя вяршыні найвышэйшыя гор. ");
INSERT INTO beln_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ягонае мора, бо Ён яго ўчыніў, і сухазем’е рукі Ягоныя ўкшталтавалі. ");
INSERT INTO beln_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Прыйдзіце, суклонімся і ўпадзем, укленчым прад Госпадам, Тварцом нашым! ");
INSERT INTO beln_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Бо Ён ёсьць Бог наш, а мы — народ чарады Ягонай і авечкі рукі Ягонай. Сёньня, калі пачуеце голас Ягоны, ");
INSERT INTO beln_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","ня рабіце цьвёрдымі сэрцы вашыя, як у Мэрыбе, як у дзень выпрабаваньня ў пустыні, ");
INSERT INTO beln_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","дзе бацькі вашыя выпрабоўвалі Мяне, спакушалі Мяне, хоць і бачылі справы Мае! ");
INSERT INTO beln_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Сорак гадоў Я брыдзіўся пакаленьнем гэтым, і Я сказаў: “Яны — народ, што блукаецца сэрцам, і яны не спазналі шляхоў Маіх”. ");
INSERT INTO beln_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Дык Я прысягнуў у гневе Маім, што яны ня ўвойдуць ў супачынак Мой. ");
INSERT INTO beln_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Сьпявайце ГОСПАДУ новы сьпеў, сьпявайце ГОСПАДУ, уся зямля! ");
INSERT INTO beln_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Сьпявайце ГОСПАДУ, дабраслаўляйце імя Ягонае! З дня на дзень дабравесьціце пра збаўленьне Ягонае! ");
INSERT INTO beln_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Абвяшчайце між народамі славу Ягоную, між усімі людзьмі — цуды Ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Бо вялікі ГОСПАД і годны ўсялякай хвалы, годны страху больш за ўсіх багоў! ");
INSERT INTO beln_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Бо ўсе богі народаў — ідалы, а ГОСПАД нябёсы стварыў. ");
INSERT INTO beln_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Годнасьць і велічнасьць перад абліччам Ягоным, моц і краса — у сьвятыні Ягонай. ");
INSERT INTO beln_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Аддайце ГОСПАДУ, плямёны народаў, аддайце ГОСПАДУ славу і моц! ");
INSERT INTO beln_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Аддайце ГОСПАДУ славу імя Ягонага, нясіце дары і ідзіце ў панадворкі Ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Пакланіцеся ГОСПАДУ ў велічы сьвятыні; дрыжыце перад абліччам Яго, усе землі! ");
INSERT INTO beln_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Скажыце народам: “ГОСПАД валадарыць! Ён сусьвет умацаваў, каб не пахіснуўся. І будзе судзіць Ён народы паводле справядлівасьці”. ");
INSERT INTO beln_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Няхай узьвесяляцца нябёсы і ўзрадуецца зямля; няхай мора гудзе, і ўсё, што ў ім. ");
INSERT INTO beln_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Няхай усьцешыцца поле і ўсё, што на ім; і будуць усклікаць тады ўсе дрэвы лясныя, ");
INSERT INTO beln_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","перад абліччам ГОСПАДА, бо Ён ідзе, бо Ён ідзе судзіць зямлю. Судзіць Ён будзе сусьвет паводле праведнасьці і народы — паводле вернасьці Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","ГОСПАД валадарыць! Няхай радуецца зямля, няхай весяліцца мноства астравоў! ");
INSERT INTO beln_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Хмары і імгла навакол Яго; праведнасьць і суд — падставы пасаду Ягонага. ");
INSERT INTO beln_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Агонь ідзе перад абліччам Ягоным і паліць наўкола супраціўнікаў Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Маланкі Ягоныя сусьвет асьвятляюць; бачыць гэта зямля і дрыжыць. ");
INSERT INTO beln_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Горы топяцца, быццам воск, ад аблічча ГОСПАДА, ад аблічча Госпада ўсёй зямлі. ");
INSERT INTO beln_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Апавядаюць нябёсы праведнасьць Ягоную, і ўсе народы бачаць славу Ягоную. ");
INSERT INTO beln_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Асаромяцца ўсе, што балванам служаць, што ідаламі сваімі хваляцца. Пакланіцеся Яму, усе богі! ");
INSERT INTO beln_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Чуе гэта Сыён і весяліцца, і радуюцца дочкі Юдавы дзеля судоў Тваіх, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Бо Ты, ГОСПАДЗЕ, над усёй зямлёй Найвышэйшы, Ты ўзьнёсся па-над усімі багамі. ");
INSERT INTO beln_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Вы, што любіце ГОСПАДА, ненавідзьце зло! Ён захоўвае душы багабойных Сваіх, з рукі бязбожных выратоўвае іх. ");
INSERT INTO beln_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Сьвятло ўзыходзіць для праведніка, і радасьць — для шчырых сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Весяліцеся ў ГОСПАДЗЕ, праведнікі, і слаўце на ўспамін сьвятасьці Ягонай! ");
INSERT INTO beln_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Псальм. Сьпявайце ГОСПАДУ новы сьпеў, бо Ён цуды ўчыніў! Правіца Ягоная і рамяно сьвятасьці Ягонай здабылі перамогу Яму. ");
INSERT INTO beln_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","ГОСПАД зьявіў збаўленьне Сваё, перад вачыма народаў адкрыў праведнасьць Сваю. ");
INSERT INTO beln_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Узгадаў пра міласэрнасьць Сваю і вернасьць Сваю для дому Ізраіля. Усе канцы зямлі ўбачылі збаўленьне Бога нашага. ");
INSERT INTO beln_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Усклікай ГОСПАДУ, уся зямля! Цешцеся, і радуйцеся, і выслаўляйце! ");
INSERT INTO beln_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Выслаўляйце ГОСПАДА на гусьлях, на гусьлях і галосным сьпяваньнем! ");
INSERT INTO beln_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","На трубах і гукам рогу усклікайце перад абліччам Валадара ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Няхай мора гудзе і ўсё, што ў ім, сусьвет і ўсё, што жыве ў ім! ");
INSERT INTO beln_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Няхай пляскаюць у далоні рэкі, і горы радуюцца разам з імі ");
INSERT INTO beln_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","перад абліччам ГОСПАДА, бо Ён ідзе судзіць зямлю. Сусьвет Ён будзе судзіць паводле праведнасьці і народы — паводле справядлівасьці. ");
INSERT INTO beln_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","ГОСПАД валадарыць, няхай дрыжаць народы! Ён сеў на херубімаў, няхай ўзварухнецца зямля! ");
INSERT INTO beln_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Вялікі ГОСПАД на Сыёне, Ён узвысіўся па-над усімі народамі. ");
INSERT INTO beln_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Няхай славяць імя Ягонае вялікае і страшнае; бо сьвятое яно! ");
INSERT INTO beln_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","І моц Валадара, Які любіць суд. Ты ўстанавіў справядлівасьць, Ты суд і праведнасьць учыніў у Якубе. ");
INSERT INTO beln_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Узьвялічвайце ГОСПАДА, Бога нашага, і пакланіцеся ля падножжа стоп Ягоных, бо сьвяты Ён! ");
INSERT INTO beln_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Майсей і Аарон сярод сьвятароў Ягоных, і Самуэль сярод тых, што клічуць імя Ягонае; яны клікалі ГОСПАДА, і Ён адказаў ім. ");
INSERT INTO beln_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","У слупе воблачным прамаўляў Ён да іх; яны захоўвалі сьведчаньні Ягоныя і пастановы, якія Ён даў ім. ");
INSERT INTO beln_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","ГОСПАДЗЕ, Божа наш, Ты адказваў ім. Ты быў для іх Богам, Які прабачаў іх і адплочваў за ўчынкі. ");
INSERT INTO beln_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Узьвялічвайце ГОСПАДА, Бога нашага, і пакланіцеся перад гарой Яго сьвятою, бо сьвяты ГОСПАД, Бог наш! ");
INSERT INTO beln_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Псальм падзякі. Усклікай ГОСПАДУ, ўся зямля! ");
INSERT INTO beln_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Служыце ГОСПАДУ з радасьцю, прыходзьце прад аблічча Ягонае з хвалою! ");
INSERT INTO beln_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ведайце, што ГОСПАД ёсьць Бог! Ён нас зрабіў, і мы — Ягоныя, народ Ягоны і авечкі чарады Ягонай. ");
INSERT INTO beln_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Уваходзьце ў брамы Ягоныя з падзякай, у панадворкі Ягоныя — з праслаўленьнем! Слаўце Яго, дабраслаўляйце імя Ягонае! ");
INSERT INTO beln_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Бо добры ёсьць ГОСПАД, на вякі міласэрнасьць Ягоная і з пакаленьня ў пакаленьне вернасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Псальм Давіда. Пра міласэрнасьць і суд буду сьпяваць, Цябе, ГОСПАДЗЕ, буду выслаўляць. ");
INSERT INTO beln_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Буду разважаць пра шлях беззаганны. Калі ж Ты прыйдзеш да мяне? Буду хадзіць у беззаганнасьці сэрца майго пасярод дому майго. ");
INSERT INTO beln_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Не пастаўлю перад вачыма маімі рэчы нягодныя; учынкі паганыя я ненавіджу, не прылепяцца яны да мяне. ");
INSERT INTO beln_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Сэрца падступнае далёка ад мяне, зла не хачу я і ведаць. ");
INSERT INTO beln_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Таго, хто ачарняючы, ачарняе таемна бліжняга свайго, я вынішчу; вочы пыхлівыя і сэрца надзьмутае ня буду зносіць. ");
INSERT INTO beln_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Вочы мае на верных зямлі, каб жылі пры мне. Той, хто ходзіць па шляху беззаганнасьці, будзе служыць мне. ");
INSERT INTO beln_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Ня будзе ў доме маім жыць той, хто здраду кнуе; той, хто гаворыць хлусьліва, ня будзе стаяць перад вачыма маімі. ");
INSERT INTO beln_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Раніцаю буду вынішчаць усіх бязбожнікаў зямлі, каб у горадзе ГОСПАДАВЫМ зьнішчыць усіх злачынцаў. ");
INSERT INTO beln_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Малітва прыгнечанага, калі ён зьнемагаў і перад ГОСПАДАМ вылівае смутак свой. ");
INSERT INTO beln_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","ГОСПАДЗЕ, пачуй малітву маю, і лямант мой няхай дойдзе да Цябе! ");
INSERT INTO beln_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Не хавай аблічча Твайго ад мяне ў дзень уціску, прыхілі да мяне вуха Тваё ў дзень, калі клічу; хутчэй адкажы мне. ");
INSERT INTO beln_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Бо зьніклі, як дым, дні мае, і косткі мае выпаленыя як у гарне. ");
INSERT INTO beln_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Скошанае як трава і высахлае сэрца маё, ажно забываюся я есьці хлеб свой. ");
INSERT INTO beln_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ад голасу ўздыханьня майго косткі мае прыляпіліся да цела майго. ");
INSERT INTO beln_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Я падобны да пэлікана ў пустыні, стаўся як пугач сярод спусташэньня. ");
INSERT INTO beln_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Я ня сплю і стаўся як птушка самотная на даху. ");
INSERT INTO beln_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Увесь дзень зьняважаюць мяне ворагі мае; тыя, што сьмяюцца з мяне, запрысягнуліся супраць мяне. ");
INSERT INTO beln_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Бо я ем попел як хлеб, і напой мой са сьлязамі мяшаю ");
INSERT INTO beln_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","праз гнеў Твой і абурэньне, бо Ты падняў мяне і кінуў. ");
INSERT INTO beln_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Дні мае, быццам цені, зьнікаюць, і я сохну, быццам трава. ");
INSERT INTO beln_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","А Ты, ГОСПАДЗЕ, будзеш жыць на вякі, і памяць Твая — з пакаленьня ў пакаленьне. ");
INSERT INTO beln_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Ты паўстанеш, зьлітуешся над Сыёнам, бо час дараваць яму, бо прыйшла пара. ");
INSERT INTO beln_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Бо слугі Твае маюць ласку да камянёў ягоных і літасьць — над пылам ягоным. ");
INSERT INTO beln_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","І будуць баяцца народы імя ГОСПАДА, і ўсе валадары зямныя — славы Тваёй, ");
INSERT INTO beln_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","бо адбудаваў ГОСПАД Сыён і даў убачыць Сябе ў славе Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Ты прыхіліўся да малітвы прыніжанага і не пагардзіў малітвамі іхнімі. ");
INSERT INTO beln_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Будзе запісана гэтае будзе для пакаленьня наступнага, і народ, які будзе створаны, будзе хваліць ГОСПАДА, ");
INSERT INTO beln_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","бо Ён глянуў з вышыні сьвятасьці Сваёй, паглядзеў ГОСПАД з нябёсаў на зямлю, ");
INSERT INTO beln_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","каб пачуць стогны вязьня, каб вызваліць сыноў, сказаных на сьмерць, ");
INSERT INTO beln_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","каб апавядалі на Сыёне імя ГОСПАДА, і хвалу Ягоную — ў Ерусаліме, ");
INSERT INTO beln_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","калі разам зьбяруцца народы і валадарствы, каб служыць ГОСПАДУ. ");
INSERT INTO beln_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Змардаваў Ён у дарозе сілу маю, скараціў дні мае. ");
INSERT INTO beln_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Я кажу: “Божа мой, не вазьмі Ты мяне ў палове дзён маіх! З пакаленьня ў пакаленьне гады Твае! ");
INSERT INTO beln_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Здаўна Ты заснаваў зямлю, і нябёсы — твор рук Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Яны згінуць, а Ты застанешся; і ўсе яны, як адзеньне, спарахнеюць, як вопратку іх пераменіш, і яны пераменяцца; ");
INSERT INTO beln_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","а Ты — Той самы, і гады Твае ня маюць канца! ");
INSERT INTO beln_vpl VALUES ("PS102_29","020_102_29","PSA","102","29","29","Сыны слугаў Тваіх будуць жыць, і насеньне іхняе будзе ўмацаванае перад абліччам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Псальм Давіда. Дабраславі, душа мая, ГОСПАДА, і ўсё нутро маё — імя Ягонае сьвятое! ");
INSERT INTO beln_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Дабраславі, душа мая, ГОСПАДА і не забывайся пра ўсё, што Ён зрабіў! ");
INSERT INTO beln_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ён даруе табе ўсе беззаконьні твае, вылечвае ўсякую немач тваю, ");
INSERT INTO beln_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","вызваляе ад магілы жыцьцё тваё, літасьцю вялікай і міласэрнасьцю карануе цябе, ");
INSERT INTO beln_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","насычае дабром старасьць тваю, аднаўляе, як у арла, маладосьць тваю. ");
INSERT INTO beln_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Справядлівасьць робіць ГОСПАД і суд для ўсіх прыгнечаных. ");
INSERT INTO beln_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Ён зрабіў вядомымі шляхі Свае Майсею, сынам Ізраіля — учынкі Свае. ");
INSERT INTO beln_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Спагадлівы і літасьцівы ГОСПАД, павольны да гневу і багаты на міласэрнасьць. ");
INSERT INTO beln_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Не назаўсёды Ён гневам палае і не навекі памятае ліхое. ");
INSERT INTO beln_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Не паводле грахоў нашых нам Ён дае і не ўчыняе з намі паводле беззаконьняў нашых, ");
INSERT INTO beln_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","бо як высока неба над зямлёю, так вялікая міласэнасьць Ягоная да тых, што баяцца Яго, ");
INSERT INTO beln_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","як далёкі ад захаду ўсход, так Ён нашыя правіны ад нас аддаліў, ");
INSERT INTO beln_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","як літуецца бацька над сынамі, так ГОСПАД літуецца над тымі, што баяцца Яго. ");
INSERT INTO beln_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Бо ведае Ён настаўленьне нашае, памятае, што мы — толькі пыл. ");
INSERT INTO beln_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Дні чалавечыя — як трава; як кветка ў полі, так ён квітнее, ");
INSERT INTO beln_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","бо пройдзе над ім вецер, і няма яго, і ўжо месца ягонае больш не пазнае яго. ");
INSERT INTO beln_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Але міласэрнасьць ГОСПАДА ад веку і на вякі над тымі, што баяцца Яго, і справядлівасьць Ягоная — над сынамі сыноў ");
INSERT INTO beln_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","тых, якія захоўваюць запавет Ягоны і загады Ягоныя памятаюць, каб выконваць іх. ");
INSERT INTO beln_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","ГОСПАД умацаваў пасад Свой на нябёсах, і валадарства Ягонае над усім пануе. ");
INSERT INTO beln_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Дабраславіце ГОСПАДА, анёлы Ягоныя, магутныя моцаю, што выконваеце слова Ягонае, чуючы голас слова Ягонага! ");
INSERT INTO beln_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Дабраславіце ГОСПАДА ўсе войскі Ягоныя, служыцелі Ягоныя, што выконваеце волю Ягоную! ");
INSERT INTO beln_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Дабраславіце ГОСПАДА ўсе творы Ягоныя па ўсіх месцах панаваньня Ягонага! Дабраславі, душа мая, ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Дабраславі, душа мая, ГОСПАДА! ГОСПАДЗЕ, Божа мой, Ты вельмі вялікі! У годнасьць і велічнасьць Ты апрануўся! ");
INSERT INTO beln_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ты ахінуўся ў сьвятло, быццам у шату, Ты раскінуў нябёсы, як намёт. ");
INSERT INTO beln_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ты паставіў над водамі хорамы Твае, Ты паставіў хмары як рыдван Твой, Ты ходзіш на крылах ветру. ");
INSERT INTO beln_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ты робіш вятры анёламі Тваімі, служыцелямі Тваімі — агонь, што палае. ");
INSERT INTO beln_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ты паставіў зямлю на мейсцы яе, ня можа яна пахіснуцца на вякі вечныя. ");
INSERT INTO beln_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Бяздоньнямі, як вопраткай, закрыў Ты яе; па-над горамі воды стаялі. ");
INSERT INTO beln_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Перад пагрозай Тваёй яны уцякалі, перад голасам грымотаў Тваіх адступаліся. ");
INSERT INTO beln_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Узьнімаліся горы, зыходзілі раўніны на месцы, якія Ты заснаваў для іх. ");
INSERT INTO beln_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ты паклаў ім мяжу, якую не пяройдуць; ня вернуцца, каб закрыць зямлю. ");
INSERT INTO beln_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Ты пасылаеш крыніцы для ручаёў, яны цякуць паміж гораў, ");
INSERT INTO beln_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","пояць усіх зьвяроў палявых, праганяюць дзікія аслы смагу сваю. ");
INSERT INTO beln_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Над імі жывуць птушкі нябесныя, праз вецьце голас падаюць. ");
INSERT INTO beln_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Ты поіш горы з хорамаў Тваіх; пладамі дзеяў Тваіх зямля насычаецца. ");
INSERT INTO beln_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ты ўзрошчваеш траву для скаціны і расьліны для працы чалавеку, каб вырастаў хлеб з зямлі ");
INSERT INTO beln_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","і віно, якое сэрца людзям весяліць, і алей, ад якога твар іх блішчыць, і хлеб, які сэрца людзей умацоўвае. ");
INSERT INTO beln_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Насычаюцца дрэвы ГОСПАДАВЫ, кедры Лібанскія, якія Ён пасадзіў. ");
INSERT INTO beln_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Там птушкі робяць гнёзды, бусел на кіпарысе мае дом свой. ");
INSERT INTO beln_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Высокія горы — для сарнаў, скалы — прыстанішча для горных мышэй. ");
INSERT INTO beln_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Ён месяц зрабіў, каб вызначаць пару; сонца ведае захад свой. ");
INSERT INTO beln_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Ты цемру кладзеш, і стаецца ноч, у ёй рухаюцца ўсе зьвяры лясныя. ");
INSERT INTO beln_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Львяняты рыкаюць пра здабычу, шукаючы ў Бога пажывы. ");
INSERT INTO beln_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Як узыйдзе сонца, яны зьбіраюцца разам і ў логвах залягаюць. ");
INSERT INTO beln_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Выходзіць чалавек на дзеі свае і на працу сваю аж да вечара. ");
INSERT INTO beln_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Якія шматлікія, ГОСПАДЗЕ, дзеі Твае! Усё Ты ў мудрасьці ўчыніў, зямля поўная даброцьцяў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Вось мора: вялікае і шырокае на абодва бакі; там рухаецца безьліч жывёлаў малых і вялікіх; ");
INSERT INTO beln_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","там караблі ходзяць, левіятан, якога Ты ўфармаваў, гуляе ў ім. ");
INSERT INTO beln_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Усе яны ўзіраюцца на Цябе, каб Ты даў ім пажыву ў свой час. ");
INSERT INTO beln_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Ты даеш ім, яны зьбіраюць; Ты адкрываеш руку Тваю, і яны дабром насычаюцца. ");
INSERT INTO beln_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ты хаваеш аблічча Тваё, і яны палохаюцца; забіраеш дух іхні, і яны паміраюць, і ў пыл назад вяртаюцца. ");
INSERT INTO beln_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Ты пашлеш Дух Твой, і яны створаныя, і Ты аднаўляеш аблічча зямлі. ");
INSERT INTO beln_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Няхай будзе слава ГОСПАДА на вякі, няхай радуецца ГОСПАД з дзеяў Сваіх. ");
INSERT INTO beln_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ён гляне на зямлю, і яна дрыжыць; дакранецца да гор, і яны палаюць. ");
INSERT INTO beln_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Буду сьпяваць ГОСПАДУ жыцьцём маім; буду выслаўляць Бога майго яшчэ больш. ");
INSERT INTO beln_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Няхай будзе салодкім Яму разважаньне маё, а я буду весяліцца ў ГОСПАДЗЕ. ");
INSERT INTO beln_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Няхай грэшнікі счэзнуць з зямлі, няхай больш ня будзе бязбожнікаў! Дабраславі, душа мая, ГОСПАДА! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Слаўце ГОСПАДА, клічце імя Ягонае! Паведамляйце між народамі пра дзеі Ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Сьпявайце Яму, выслаўляйце Яго! Размаўляйце пра ўсе цудоўныя дзеі Ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Хвалецеся імем Яго сьвятым! Няхай весяліцца сэрца тых, што шукаюць ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Шукайце ГОСПАДА і сілу Ягоную, шукайце аблічча Ягонае заўсёды! ");
INSERT INTO beln_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Узгадвайце цудоўныя дзеі Ягоныя, якія Ён зрабіў, цуды Ягоныя і прысуды вуснаў Ягоных, ");
INSERT INTO beln_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","вы, насеньне Абрагама, слугі Ягонага, сыны Якуба, выбранца Ягонага! ");
INSERT INTO beln_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Ён — ГОСПАД, Бог наш; над усёй зямлёй суды Ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ён памятае на вякі запавет Свой, слова, якое загадаў на тысячу пакаленьняў, ");
INSERT INTO beln_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","якое заключыў з Абрагамам, і прысягу Сваю Ісааку. ");
INSERT INTO beln_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","І паставіў Якубу як пастанову, Ізраілю — запавет вечны, ");
INSERT INTO beln_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","кажучы: “Табе Я дам зямлю Ханаан, пакладу шнур спадчыны вашай”, ");
INSERT INTO beln_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","калі было ў іх людзей мала на лік, вельмі мала, калі яны жылі там ");
INSERT INTO beln_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","і пераходзілі ад народу да народу, ад аднаго валадарства да другога народу. ");
INSERT INTO beln_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Не дазваляў Ён ніякаму чалавеку прыгнятаць іх, і караў дзеля іх валадароў, ");
INSERT INTO beln_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","кажучы: “Не чапайце памазанцаў Маіх, і прарокам Маім не рабіце благога!” ");
INSERT INTO beln_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","I паклікаў Ён голад на зямлю, усякую падпору хлеба зламаў, ");
INSERT INTO beln_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","і паслаў перад абліччам іхнім чалавека, які быў прададзены як нявольнік, Язэпа. ");
INSERT INTO beln_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Зашчамілі ў кайданы ногі ягоныя, жалезам сьціснулі душу ягоную ");
INSERT INTO beln_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","аж да часу, калі выйшла справа ягоная, слова ГОСПАДА ачысьціла яго. ");
INSERT INTO beln_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Валадар паслаў, каб звольніць яго, той, што пануе над народамі, вызваліў яго, ");
INSERT INTO beln_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","паставіў яго гаспадаром над домам сваім і чалавекам, што пануе над усім даброцьцем ягоным, ");
INSERT INTO beln_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","каб скіроўваў князёў ягоных паводле рашэньня душы сваёй, і старшыняў ягоных вучыў мудрасьці. ");
INSERT INTO beln_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","І прыйшоў Ізраіль у Эгіпет, і Якуб пасяліўся ў зямлі Хамавай. ");
INSERT INTO beln_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","І Бог зрабіў вельмі плодным народ Свой, і зрабіў яго мацнейшым за прыгнятальнікаў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Зьмяніў сэрца іхняе, каб ненавідзелі народ Ягоны, каб змовіліся супраць слугаў Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Ён паслаў Майсея, слугу Свайго, Аарона, якога выбраў Сабе. ");
INSERT INTO beln_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Ён зьявіў праз іх знакі Свае і цуды Свае ў зямлі Хамавай. ");
INSERT INTO beln_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Ён паслаў цемру, і зрабілася цёмна, і не маглі працівіцца слову Ягонаму. ");
INSERT INTO beln_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ён перамяніў воды іхнія ў кроў і памерлі рыбы іхнія. ");
INSERT INTO beln_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Напоўнілася зямля іхняя жабамі, нават у спальнях валадароў іхніх. ");
INSERT INTO beln_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Сказаў, і наляцела мух і камароў у-ва ўсіх іхніх межах. ");
INSERT INTO beln_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ён даў ім замест дажджу град, полымя агню на зямлю іхнюю. ");
INSERT INTO beln_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Пабіў вінаградныя лозы іхнія і дрэвы фігавыя, і паламаў дрэвы ў межах іхніх. ");
INSERT INTO beln_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Сказаў, і прыйшла саранча, і хрушчоў безьліч, ");
INSERT INTO beln_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","і яны паелі ўсе расьліны ў зямлі іхняй, і паелі плады палёў іхніх. ");
INSERT INTO beln_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ён пабіў ўсіх першародных у зямлі іхняй, зачаткі ўсёй сілы іхняй. ");
INSERT INTO beln_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","А іх вывеў са срэбрам і золатам, і не было ў каленах іхніх нядужага. ");
INSERT INTO beln_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Радаваўся Эгіпет з выхаду іхняга, бо ахапіў іх страх перад імі. ");
INSERT INTO beln_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Ён хмару разгарнуў як заслону і агонь, каб ноч асьвятляць. ");
INSERT INTO beln_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Зажадалі, і прывёў перапёлак, і хлебам нябесным насычаў іх. ");
INSERT INTO beln_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Ён расшчапіў скалу, і люнулі воды, і ракой пацяклі па сухой зямлі. ");
INSERT INTO beln_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Бо Ён ўзгадаў слова сьвятое Сваё да Абрагама, слугі Свайго, ");
INSERT INTO beln_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","і вывеў народ Свой у радасьці, выбранцаў Сваіх — са сьпяваньнем. ");
INSERT INTO beln_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","І даў ім зямлю народаў, і набытак народаў успадкаемілі яны, ");
INSERT INTO beln_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","каб захоўвалі пастановы Ягоныя і законаў Ягоных трымаліся. Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Альлелюя! Хвалеце ГОСПАДА, бо Ён добры, бо міласэрнасьць Ягоная на вякі. ");
INSERT INTO beln_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Хто выкажа магутнасьць ГОСПАДА, дасьць пачуць усю хвалу Ягоную? ");
INSERT INTO beln_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Шчасьлівыя тыя, што захоўваюць суд і робяць праведнасьць у кожным часе. ");
INSERT INTO beln_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Памятай пра мяне, ГОСПАДЗЕ, праз ласкавасьць да народу Твайго! Наведай мяне са збаўленьнем Тваім, ");
INSERT INTO beln_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","каб я ўгледзеў дабро выбранцаў Тваіх, каб я радаваўся радасьцю народу Твайго, каб хваліўся разам са спадчынаю Тваёю! ");
INSERT INTO beln_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Саграшылі мы разам з бацькамі нашымі, правініліся і адступіліся. ");
INSERT INTO beln_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Бацькі нашыя ў Эгіпце не зразумелі цудаў Тваіх, ня памяталі мноства міласэрнасьці Тваёй бунтаваліся ля мора, пры моры Чырвоным. ");
INSERT INTO beln_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Але Ён збавіў іх дзеля імя Свайго, каб зьявіць магутнасьць Сваю. ");
INSERT INTO beln_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Ён утаймаваў мора Чырвонае, і яно высахла; і Ён правёў іх праз бяздоньне як праз пустыню. ");
INSERT INTO beln_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","I збавіў іх з рукі ненавісьніка, і выбавіў іх з рукі ворага. ");
INSERT INTO beln_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","І пакрылі воды прыгнятальнікаў іхніх, ніводзін з іх не застаўся. ");
INSERT INTO beln_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","І хоць яны паверылі словам Ягоным і сьпявалі хвалу Яму, ");
INSERT INTO beln_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","але хутка забыліся пра дзеі Ягоныя, не чакалі на раду Ягоную. ");
INSERT INTO beln_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","І зажадалі жаданьнем у пустыні, і выпрабоўвалі Бога ў зямлі бязьлюднай. ");
INSERT INTO beln_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","І Ён даў ім тое, чаго хацелі, і спаслаў зьнемажэньне ў душу іхнюю. ");
INSERT INTO beln_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","I пазайздросьцілі Майсею ў табары, і Аарону, сьвятому ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Расчынілася зямля, і праглынула Датана, і пакрыла грамаду Авірама, ");
INSERT INTO beln_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","і загарэўся агонь пад грамадою іхняю, полымя спаліла бязбожнікаў. ");
INSERT INTO beln_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Яны зрабілі цяля пад Гарэбам і пакланяліся перад літым ідалам; ");
INSERT INTO beln_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","і замянілі Славу сваю на вобраз вала, які есьць траву. ");
INSERT INTO beln_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Яны забыліся на Бога, Збаўцу свайго, Які вялікае ўчыніў у Эгіпце, ");
INSERT INTO beln_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","цуды ў зямлі Хамавай, страшныя рэчы ля мора Чырвонага. ");
INSERT INTO beln_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","І сказаў Ён, што вынішчыць іх, калі б не Майсей, выбранец Ягоны, які стаў у выломе перад абліччам Ягоным, каб адвярнуць ярасьць Ягоную, каб Ён ня вынішчыў іх. ");
INSERT INTO beln_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","І пагрэбавалі яны зямлёй пажаданай, не паверылі словам Ягоным. ");
INSERT INTO beln_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","І наракалі ў намётах сваіх, ня слухаліся голасу ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","І Ён падняў руку Сваю на іх, каб пападалі яны ў пустыні ");
INSERT INTO beln_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","і пападала насеньне іхняе сярод народаў і расьцярушыць іх па зямлі. ");
INSERT INTO beln_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","І яны далучыліся да Баал-Пэгора, і елі ахвяры мёртвых, ");
INSERT INTO beln_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","і злавалі Яго дзеяньнямі сваімі, і абрынулася на іх пляга. ");
INSERT INTO beln_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","І паўстаў Пінхас, і спынілася пляга. ");
INSERT INTO beln_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","І залічана яму гэта за праведнасьць з пакаленьня ў пакаленьне на вякі. ");
INSERT INTO beln_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","І ўгнявілі яны Бога ля водаў Мэрыбы, і з-за іх пацярпеў Майсей, ");
INSERT INTO beln_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","бо бунтаваліся супраць духа ягонага, і ён неразважна гаварыў вуснамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Яны ня зьнішчылі народаў, як ім казаў ГОСПАД, ");
INSERT INTO beln_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","і зьмяшаліся з паганамі, і навучыліся справаў іхніх, ");
INSERT INTO beln_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","і служылі ідалам іхнім, і яны сталіся для іх пасткаю, ");
INSERT INTO beln_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","і ахвяроўвалі сыноў сваіх і дачок сваіх дэманам, ");
INSERT INTO beln_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","і пралівалі кроў бязьвінную, кроў сыноў сваіх і дачок сваіх, якую ахвяроўвалі ідалам Ханаанскім, і апаганілася зямля ад крыві. ");
INSERT INTO beln_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","І апаганілі сябе ўчынкамі сваімі, чужаложылі ў дзеяньнях сваіх. ");
INSERT INTO beln_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","І распаліўся гнеў ГОСПАДА на народ Ягоны, і абрыдла Яму спадчына Ягоная. ");
INSERT INTO beln_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","І Ён аддаў іх у рукі паганаў, і запанавалі над імі тыя, што ненавідзелі іх. ");
INSERT INTO beln_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","І ўціскалі іх ворагі іхнія, і яны скарыліся пад рукою іхняю. ");
INSERT INTO beln_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Шмат разоў Ён выратоўваў іх, але яны бунтаваліся ў задумах сваіх і паніжаны былі за беззаконьне сваё. ");
INSERT INTO beln_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Але Ён глянуў на іх у горы, пачуўшы галашэньне іхняе, ");
INSERT INTO beln_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","і ўзгадаў на іх дзеля запавету Свайго, і пашкадаваў іх дзеля мноства міласэрнасьці Сваёй, ");
INSERT INTO beln_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","і Ён даў літасьць да іх перад абліччам усіх, што паняволілі іх. ");
INSERT INTO beln_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Збаў нас, ГОСПАДЗЕ, Божа наш, і зьбяры нас ад паганаў, каб мы славіві сьвятое імя Тваё і хваліліся славай Тваёю! ");
INSERT INTO beln_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Дабраслаўлёны ГОСПАД, Бог Ізраіля, ад веку і на вякі! І няхай скажа ўвесь народ: Амэн! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Слаўце ГОСПАДА, бо Ён добры, бо на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Няхай гэтак скажуць выкупленыя ГОСПАДАМ, якіх Ён выкупіў з рукі прыгнятальніка ");
INSERT INTO beln_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","і сабраў з земляў з усходу і з захаду, з поўначы і ад мора. ");
INSERT INTO beln_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Яны блукалі па пустыні, па бязьлюдзьдзі, шляху да гораду, дзе будуць жыць, не знайшлі. ");
INSERT INTO beln_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Былі галоднымі і сасьмяглымі, душа іхняя ў іх зьнемаглася. ");
INSERT INTO beln_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","І крычалі яны да ГОСПАДА ў тузе сваёй, і Ён выратаваў іх з бяды іхняй. ");
INSERT INTO beln_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","І павёў Ён іх шляхам простым, каб прыйшлі да гораду, дзе будуць жыць. ");
INSERT INTO beln_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Няхай славяць ГОСПАДА за міласэрнасьць Ягоную і за цуды Ягоныя для сыноў чалавечых, ");
INSERT INTO beln_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","бо Ён насыціў душу спрагнёную і душу галодную напоўніў дабром. ");
INSERT INTO beln_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Яны сядзелі ў цемры і ў ценю сьмерці, увязьненыя пакутамі і жалезам, ");
INSERT INTO beln_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","бо яны бунтаваліся супраць словаў Бога і радай Найвышэйшага пагрэбавалі. ");
INSERT INTO beln_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","І Ён спакорыў сэрца іхняе нядоляй; яны спатыкнуліся, і не было дапамогі. ");
INSERT INTO beln_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","І крычалі яны да ГОСПАДА ў тузе сваёй, і Ён выратаваў іх з бяды іхняй, ");
INSERT INTO beln_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","і вывеў іх з цемры і ценю сьмерці, і кайданы іхнія парваў. ");
INSERT INTO beln_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Няхай славяць ГОСПАДА за міласэрнасьць Ягоную і за цуды Ягоныя для сыноў чалавечых, ");
INSERT INTO beln_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","бо Ён скрышыў брамы мядзяныя і расьсек жалезныя засаўкі. ");
INSERT INTO beln_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Яны былі неразумнымі на шляху правінаў сваіх і за беззаконьні свае пакутавалі. ");
INSERT INTO beln_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Усякая ежа абрыдла душы іхняй, і блізка былі яны ад брамаў сьмерці. ");
INSERT INTO beln_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","І крычалі яны да ГОСПАДА ў тузе сваёй, і Ён выратаваў іх з бяды іхняй, ");
INSERT INTO beln_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ён паслаў слова Сваё, і аздаравіў іх, і выбавіў іх ад магілы. ");
INSERT INTO beln_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Няхай славяць ГОСПАДА за міласэрнасьць Ягоную і за цуды Ягоныя для сыноў чалавечых! ");
INSERT INTO beln_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Няхай ахвяруюць ахвяры падзякі, і няхай абвяшчаюць з радасьцю пра дзеяньні Ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Тыя, што зыходзілі на мора на караблях і вялі справы на водах вялікіх, ");
INSERT INTO beln_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","яны бачылі справы ГОСПАДА і цуды Ягоныя ў глыбінях. ");
INSERT INTO beln_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Ён сказаў, і стаўся вецер бурны, і ўзьняліся хвалі, ");
INSERT INTO beln_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","і яны ўздымаюцца пад неба, і падаюць у бяздоньне; душа іхняя ў гэтым ліху млее, ");
INSERT INTO beln_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","бадзяюцца і хістаюцца, як п’яныя, і ўся мудрасьць іхняя на марна. ");
INSERT INTO beln_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","І крычалі яны да ГОСПАДА ў тузе сваёй, і Ён выратаваў іх з бяды іхняй. ");
INSERT INTO beln_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ён перамяніў буру ў цішу, і суцішыліся хвалі. ");
INSERT INTO beln_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","І ўзрадаваліся яны, што ўсё сьціхла, і Ён іх правёў да жаданае прыстані. ");
INSERT INTO beln_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Няхай славяць ГОСПАДА за міласэрнасьць Ягоную і за цуды Ягоныя для сыноў чалавечых! ");
INSERT INTO beln_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Няхай вывышаюць Яго ў зграмаджэньні народу і паміж старшыняў няхай хваляць Яго! ");
INSERT INTO beln_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Ён перамяніў рэкі ў пустыню і крыніцы водаў — у сухую зямлю, ");
INSERT INTO beln_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","і ўрадлівую зямлю — у салёную — за ліхоту тых, што жывуць на ёй. ");
INSERT INTO beln_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ён перамяніў пустыню ў возера водаў і сухую зямлю — у крыніцы водаў, ");
INSERT INTO beln_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","і там пасяліў галодных, і яны паставілі горад, дзе будуць жыць, ");
INSERT INTO beln_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","і засеялі палі, і пасадзілі вінаграднік, і атрымалі плод багаты. ");
INSERT INTO beln_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","І Ён дабраслаўляў іх, і яны множыліся вельмі; і не зьмяншалася ў іх скаціны. ");
INSERT INTO beln_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Але пасьля іх паменшала, і яны схіліліся пад цяжарам ліхоты і смутку. ");
INSERT INTO beln_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Ён вылівае пагарду на князёў і кідае іх блукаць па пустках без дарогі. ");
INSERT INTO beln_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","І паднімае прыгнечанага з нэндзы, і робіць плямёны як чароды авечак. ");
INSERT INTO beln_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Убачаць гэта правыя і ўзьвесяляцца; і ўсякая несправядлівасьць закрые вусны свае. ");
INSERT INTO beln_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Хто мудры, той гэта захавае, і зразумее міласэрнасьць ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Сьпеў. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Ўмацаванае сэрца маё, Божа! Буду сьпяваць і выслаўляць Цябе ў славе маёй! ");
INSERT INTO beln_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Збудзіцеся, псалтыр і гусьлі! Я пабуджу сьвітаньне! ");
INSERT INTO beln_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Буду славіць Цябе сярод людзей, ГОСПАДЗЕ, і буду выслаўляць Цябе сярод народаў, ");
INSERT INTO beln_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","бо па-над неба вялікая міласэрнасьць Твая, і праўда Твая — да аблокаў. ");
INSERT INTO beln_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Узьвялічся па-над неба, Божа, і па-над усёй зямлёй няхай будзе слава Твая! ");
INSERT INTO beln_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Каб былі ўратаваныя ўмілаваныя Твае, збаў правіцай Тваёй і адкажы мне! ");
INSERT INTO beln_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Бог сказаў у сьвятасьці Сваёй: “Я ўзрадуюся! Я падзялю Сыхем, і даліну Сукот разьмераю. ");
INSERT INTO beln_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Мой Гілеад, Мой Манаса, і Эфраім — моц галавы Маёй, Юда — заканадаўца Мой! ");
INSERT INTO beln_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Мааў — міса для мыцьця Майго; на Эдом кіну сандалы Мае; над зямлёй Філістынскай радасна гукаць буду! ");
INSERT INTO beln_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Хто ўвядзе мяне ў горад умацаваны? Хто завядзе мяне ў Эдом? ");
INSERT INTO beln_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Ці ж ня Ты, Божа, нас пакінуў і не выходзіш, Божа, з войскамі нашымі? ");
INSERT INTO beln_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Дай нам успамогу ў прыгнечаньні нашым, бо марны ратунак чалавечы. ");
INSERT INTO beln_vpl VALUES ("PS108_14","020_108_14","PSA","108","14","14","З Богам мы зьявім сілу, і Ён растопча прыгнятальнікаў нашых. ");
INSERT INTO beln_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Кіраўніку хору. Псальм Давіда. Божа, хвала мая, не маўчы! ");
INSERT INTO beln_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Бо вусны бязбожныя і вусны здрадлівыя расчыніліся супраць мяне, гавораць са мною языком хлусьлівым. ");
INSERT INTO beln_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","І словамі нянавісьці атачылі мяне, і ваююць супраць мяне без прычыны. ");
INSERT INTO beln_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","За любоў маю яны супрацьстаяць мне; а я малюся. ");
INSERT INTO beln_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Яны заплацілі мне злом за дабро, і нянавісьцяй — за любоў маю. ");
INSERT INTO beln_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Пастаў над ім бязбожніка, і шатан няхай стане праваруч яго; ");
INSERT INTO beln_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","калі будзе суджаны, няхай будзе як бязбожнік, а малітва ягоная няхай станецца грэхам. ");
INSERT INTO beln_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Няхай дні ягоныя будуць кароткія, а ўрад ягоны няхай возьме іншы. ");
INSERT INTO beln_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Няхай сыны ягоныя будуць сіротамі, а жонка ягоная — удавою. ");
INSERT INTO beln_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Няхай выгнаныя, будуць выгнанцамі сыны ягоныя, і няхай жабруюць і шукаюць хлеба на руінах сваіх! ");
INSERT INTO beln_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Няхай захопіць ліхвяр усё, што яму належыць, і няхай чужынцы захопяць працу ягоную. ");
INSERT INTO beln_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Няхай ня будзе нікога, хто яму зьявіць міласэрнасьць, і няхай ня будзе таго, хто зьлітуецца над сіротамі ягонымі. ");
INSERT INTO beln_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Насеньне ягонае няхай будзе зьнішчана; у пакаленьні наступным няхай будзе выкрэсьленае імя ягонае! ");
INSERT INTO beln_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Няхай будзе ўзгаданае беззаконьне бацькоў ягоных перад ГОСПАДАМ, і грэх маці ягонай няхай ня будзе змыты! ");
INSERT INTO beln_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Няхай будуць яны перад ГОСПАДАМ заўсёды, і няхай Ён вынішчыць на зямлі памяць пра яго, ");
INSERT INTO beln_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","бо ён не памятаў, каб чыніць міласэрнасьць, і перасьледаваў чалавека беднага і прыгнечанага, і з сэрцам зламаным, каб забіць яго. ");
INSERT INTO beln_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Любіў ён праклён, і ён прыйдзе на яго! Не было даспадобы яму дабраслаўленьне, і яно будзе далёка ад яго! ");
INSERT INTO beln_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","І ён апранецца праклёнам, быццам шатай сваёй, і ён увойдзе, як вада, у нутро ягонае, і як алей, — у косткі ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Няхай будзе яму як адзеньне, у якое ён адзяецца, і як пас, якім заўсёды падпярэзваецца! ");
INSERT INTO beln_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Гэткая будзе плата ад ГОСПАДА тым, што супрацьстаяць мне, і тым, што благое гавораць супраць душы маёй! ");
INSERT INTO beln_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","А Ты, ГОСПАДЗЕ, Госпадзе, учыні са мною дзеля імя Твайго, і, бо добрая міласэрнасьць Твая, выратуй мяне, ");
INSERT INTO beln_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","бо я бедны і прыгнечаны, і сэрца маё ў нутры маім зранена. ");
INSERT INTO beln_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Я зыходжу, як цень, што зьнікае; ганяюць мяне, як саранчу. ");
INSERT INTO beln_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Калені мае ад посту хістаюцца, і цела маё ссохла без алею. ");
INSERT INTO beln_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","І я стаўся ганьбаю для іх, яны глядзяць на мяне, ківаючы галовамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Дапамажы мне, ГОСПАДЗЕ, Божа мой! Збаў мяне паводле міласэрнасьці Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","І даведаюцца яны, што гэта рука Твая, што Ты, ГОСПАДЗЕ, зрабіў гэта! ");
INSERT INTO beln_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Яны праклінаюць, а Ты дабраславі! Яны паўстаюць супраць мяне, і будуць асаромленыя, а слуга Твой няхай узрадуецца! ");
INSERT INTO beln_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Няхай апрануцца ў зьнявагу тыя, што супрацьстаяць мне, і ахінуцца, быццам плашчом, у сорам свой! ");
INSERT INTO beln_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Я буду гучна славіць ГОСПАДА вуснамі маімі і сярод мноства народу буду хваліць Яго, ");
INSERT INTO beln_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","бо Ён стаіць праваруч прыгнечанага, каб збавіць яго ад тых, што асуджаюць душу ягоную. ");
INSERT INTO beln_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Псальм Давіда. Сказаў ГОСПАД Госпаду майму: “Сядзь праваруч Мяне, пакуль пакладу ворагаў Тваіх як падножжа пад стопы Твае!” ");
INSERT INTO beln_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Кій моцы тваёй пашле ГОСПАД з Сыёну: “Мей уладу сярод ворагаў тваіх!” ");
INSERT INTO beln_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Народ твой у дзень магутнасьці тваёй ахвотна зьбярэцца ў аздобе сьвятой; як раса з улоньня сьвітаньня будзе маладосьць твая. ");
INSERT INTO beln_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Прысягнуў ГОСПАД і не раскаецца: “Ты сьвятар на вякі паводле парадку Мэльхісэдэка”. ");
INSERT INTO beln_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Госпад праваруч цябе у дзень гневу Свайго скрышыць валадароў, ");
INSERT INTO beln_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","будзе судзіць народы, усё напоўніць трупамі, скрышыць галаву, што пануе над многімі землямі. ");
INSERT INTO beln_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Са струменя нап’ецца ў дарозе і дзеля таго ўзвысіць галаву. ");
INSERT INTO beln_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Альлелюя! Буду славіць ГОСПАДА ўсім сэрцам на нарадзе правых і ў грамадзе. ");
INSERT INTO beln_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Вялікія дзеяньні ГОСПАДА, годныя ўвагі ўсіх, што імкнуцца да іх. ");
INSERT INTO beln_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Годнасьць і велічнасьць — справы Ягоныя, і праведнасьць Ягоная будзе трываць вечна. ");
INSERT INTO beln_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Ён памятнымі зрабіў цуды Свае, ГОСПАД літасьцівы і спагадлівы. ");
INSERT INTO beln_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ён ежу дае тым, што баяцца Яго, памятае на вякі запавет Свой. ");
INSERT INTO beln_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Ён распавёў народу Свайму пра сілу дзеяньняў Сваіх, даючы яму спадчыну народаў. ");
INSERT INTO beln_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Дзеі рук Ягоных — праўда і суд; усе загады Ягоныя верныя, ");
INSERT INTO beln_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","замацаваныя на вякі вечныя, зробленыя ў праўдзе і шчырасьці. ");
INSERT INTO beln_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Збаўленьне паслаў Ён народу Свайму, пастанавіў на вякі запавет Свой; сьвятое і страшнае імя Ягонае! ");
INSERT INTO beln_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Страх перад ГОСПАДАМ — пачатак мудрасьці; добры розум маюць усе, што дзейнічаюць у страху Божым. Хвала Ягоная трывае вечна. ");
INSERT INTO beln_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Альлелюя! Шчасьлівы той чалавек, які баіцца ГОСПАДА і ў прыказаньнях Ягоных мае ўпадабаньне вялікае. ");
INSERT INTO beln_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Магутным будзе на зямлі насеньне ягонае; пакаленьне правых будзе дабраслаўлёнае. ");
INSERT INTO beln_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Маёмасьць і багацьце ў доме ягоным, і праведнасьць ягоная будзе трываць вечна. ");
INSERT INTO beln_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Узыходзіць у цемры сьвятло правым, літасьцівы і спагадлівы, і праведны Бог. ");
INSERT INTO beln_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Добра чалавеку, які літуецца і пазычае, які справы свае вядзе згодна з судом. ");
INSERT INTO beln_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Бо ён ніколі не пахісьнецца; у вечнай памяці будзе праведнік. ");
INSERT INTO beln_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Ня будзе баяцца, чуючы вестку благую; моцнае сэрца ягонае, ён спадзяецца на ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Умацаванае сэрца ягонае, ён ня будзе баяцца, аж пакуль угледзіць загубу прыгнятальнікаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Раскідаў, раздаў бедным; праведнасьць ягоная трывае вечна, рог ягоны ўзьнімецца ў славе. ");
INSERT INTO beln_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Угледзіць гэта бязбожнік і будзе злаваць, скрыгатаць ён будзе зубамі і змарнее, і жаданьне бязбожніка загіне. ");
INSERT INTO beln_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Альлелюя! Хвалеце, слугі ГОСПАДАВЫ, хвалеце імя ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Няхай будзе дабраслаўлёнае імя ГОСПАДА ад цяпер і на вякі! ");
INSERT INTO beln_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Ад усходу сонца да захаду яго няхай будзе хвалёнае імя ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Узьвялічаны ГОСПАД над усімі народамі; па-над нябёсы слава Ягоная. ");
INSERT INTO beln_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Хто як ГОСПАД, Бог наш, Які жыве ў вышыні ");
INSERT INTO beln_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","і схіляецца, каб паглядзець на неба і зямлю; ");
INSERT INTO beln_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Які з пылу падымае гаротніка, з гною узносіць беднага, ");
INSERT INTO beln_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","каб пасадзіць яго сярод магнатаў, сярод магнатаў народу Свайго; ");
INSERT INTO beln_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Які бясплодную садзіць у доме як маці, якая радуецца сынам сваім? Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Калі выходзіў Ізраіль з Эгіпту, дом Якуба з народу чужацкага, ");
INSERT INTO beln_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","стаўся Юда сьвятыняй Ягонай, Ізраіль — месцам панаваньня Ягонага. ");
INSERT INTO beln_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Мора ўбачыла і ўцякло, Ярдан павярнуў назад. ");
INSERT INTO beln_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Горы скакалі, быццам бараны, узгоркі — быццам ягняты. ");
INSERT INTO beln_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Што табе, мора, што ты ўцякло? Ты, Ярдане, што павярнуў назад? ");
INSERT INTO beln_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Што вы скачаце, горы, быццам бараны, узгоркі — быццам ягняты? ");
INSERT INTO beln_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Перад абліччам Госпада задрыжэла зямля, перад абліччам Бога Якубавага, ");
INSERT INTO beln_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Які перамяняе скалу ў возера воднае, крамень — у крыніцу водаў. ");
INSERT INTO beln_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ня нам, ГОСПАДЗЕ, ня нам, але іменьню Твайму дай Ты славу дзеля міласэрнасьці Тваёй, дзеля праўды Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Навошта казаць паганам: “Дзе ж Бог іхні?” ");
INSERT INTO beln_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","А Бог наш у небе; усё, што Яму да спадобы, Ён робіць. ");
INSERT INTO beln_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Іхнія ідалы — срэбра і золата, творы рук чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Маюць вусны, і не гавораць; маюць вочы, і ня бачаць; ");
INSERT INTO beln_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","маюць вушы, і ня чуюць, маюць ноздры, і нюху няма; ");
INSERT INTO beln_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","рукі ў іх, і ня мацаюць; ногі ў іх, і ня ходзяць; і не выказваюцца горлам сваім. ");
INSERT INTO beln_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Няхай стануцца падобнымі да іх тыя, што іх робяць, усе, што на іх спадзяюцца. ");
INSERT INTO beln_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Ізраілю, спадзявайся на ГОСПАДА. Ён — дапамога іхняя і шчыт іх! ");
INSERT INTO beln_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Доме Аарона, спадзявайся на ГОСПАДА. Ён — дапамога іхняя і шчыт іх! ");
INSERT INTO beln_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Вы, што ГОСПАДА баіцёся, спадзявайцеся на ГОСПАДА: Ён — дапамога іхняя і шчыт іх! ");
INSERT INTO beln_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","ГОСПАД памятае пра нас. Ён будзе дабраслаўляць, Ён будзе дабраслаўляць дом Ізраіля, Ён будзе дабраслаўляць дом Аарона, ");
INSERT INTO beln_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Ён будзе дабраслаўляць тых, што баяцца ГОСПАДА, разам малых і вялікіх. ");
INSERT INTO beln_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Няхай памножыць вас ГОСПАД, вас і вашых сыноў. ");
INSERT INTO beln_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Дабраслаўлёныя вы ГОСПАДАМ, Які стварыў неба і зямлю. ");
INSERT INTO beln_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Неба — неба ГОСПАДА, а зямлю Ён даў сынам чалавечым. ");
INSERT INTO beln_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Ня мёртвыя хваляць ГОСПАДА, ня ўсе тыя, што зыходзяць ў месца маўчаньня, ");
INSERT INTO beln_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","але мы будзем дабраслаўляць ГОСПАДА ад цяпер і на вякі. Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Люблю ГОСПАДА, бо Ён пачуў голас мой і маленьне маё, ");
INSERT INTO beln_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","бо Ён прыхіліў да мяне вуха Сваё ў дзень, калі я клікаў Яго. ");
INSERT INTO beln_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Ахапілі мяне путы сьмерці; мукі пякельныя адшукалі мяне; я знайшоў трывогу і смутак. ");
INSERT INTO beln_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","І паклікаў я імя ГОСПАДА: “Збаў, прашу, ГОСПАДЗЕ, душу маю!” ");
INSERT INTO beln_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Літасьцівы ГОСПАД і праведны, наш Бог міласьцівы. ");
INSERT INTO beln_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","ГОСПАД захоўвае неразумных; і калі зьнемагаю, Ён ратуе мяне. ");
INSERT INTO beln_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Вярніся, душа мая, да супачынку твайго, бо ГОСПАД робіць добрае табе. ");
INSERT INTO beln_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Бо Ты выратаваў душу маю ад сьмерці, вочы мае — ад сьлёзаў, ногі мае — ад падзеньня. ");
INSERT INTO beln_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Буду хадзіць перад абліччам ГОСПАДА ў зямлі жывых. ");
INSERT INTO beln_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Я веру, дык гавару: “Я моцна прыгнечаны”. ");
INSERT INTO beln_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Я сказаў у зьбянтэжанасьці маёй: “Усе людзі хлусяць!” ");
INSERT INTO beln_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Што я вярну ГОСПАДУ за ўсе дабрадзействы Ягоныя для мяне? ");
INSERT INTO beln_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Келіх збаўленьня ўзьніму і імя ГОСПАДА буду клікаць. ");
INSERT INTO beln_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Абяцаньні мае ГОСПАДУ споўню перад усім народам Ягоным. ");
INSERT INTO beln_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Каштоўная ў вачах ГОСПАДА сьмерць багабойных Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","О ГОСПАДЗЕ! Я ж слуга Твой, я — слуга Твой, сын служкі Тваёй! Ты разьбіў кайданы мае. ");
INSERT INTO beln_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Табе ахвярую ахвяру падзякі і імя ГОСПАДА буду клікаць. ");
INSERT INTO beln_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Абяцаньні мае ГОСПАДУ споўню перад усім народам Ягоным, ");
INSERT INTO beln_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","у панадворках дому ГОСПАДАВАГА, пасярод цябе, Ерусаліме! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Хвалеце ГОСПАДА, усе народы! Праслаўляйце Яго, усе плямёны! ");
INSERT INTO beln_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Бо вялікая над намі міласэрнасьць Ягоная, і праўда ГОСПАДА на вякі! Алелюя! ");
INSERT INTO beln_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Слаўце ГОСПАДА, бо Ён добры, бо на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Няхай скажа Ізраіль, што на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Няхай скажа дом Ааронавы, што на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Няхай скажуць тыя, што баяцца ГОСПАДА, што на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","У муках клікаў я ГОСПАДА, і Ён адказаў мне, Госпад вывеў мяне на вольны прастор. ");
INSERT INTO beln_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","ГОСПАД са мною, я не баюся. Што зробіць мне чалавек? ");
INSERT INTO beln_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","ГОСПАД са мною, Ён — дапамога мая, і я буду глядзець на загубу тых, што мяне ненавідзяць. ");
INSERT INTO beln_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Лепш мець надзею на ГОСПАДА, чым спадзявацца на чалавека. ");
INSERT INTO beln_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Лепш мець надзею на ГОСПАДА, чым спадзявацца на магнатаў. ");
INSERT INTO beln_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Усе народы мяне абступілі, але імем ГОСПАДА я зьнёс іх. ");
INSERT INTO beln_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Абступілі мяне, абступілі, але імем ГОСПАДА я зьнёс іх. ");
INSERT INTO beln_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Абселі мяне, быццам пчолы, і згарэлі яны, як агонь з цярніны, бо імем ГОСПАДА я зьнёс іх. ");
INSERT INTO beln_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Пхаючы, папхнулі мяне, каб я ўпаў, але ГОСПАД дапамог мне. ");
INSERT INTO beln_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","ГОСПАД — моц мая і песьня мая, Ён стаўся збаўленьнем маім. ");
INSERT INTO beln_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Голас радасьці і збаўленьня — у намётах праведнікаў. Правіца ГОСПАДА зьявіла сілу. ");
INSERT INTO beln_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Правіца ГОСПАДА ўзьнесена, правіца ГОСПАДА зьявіла сілу. ");
INSERT INTO beln_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Не памру, але буду жыць і буду абвяшчаць пра дзеяньні ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Караючы, пакараў мяне ГОСПАД, але сьмерці мяне не аддаў. ");
INSERT INTO beln_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Адчыніце мне брамы праведнасьці; я ўвайду праз іх і буду славіць ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Вось брама ГОСПАДАВА; праведнікі ўвойдуць праз яе. ");
INSERT INTO beln_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Буду славіць Цябе, бо Ты адказаў мне і стаўся збаўленьнем маім! ");
INSERT INTO beln_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Камень, які адкінулі будаўнікі, стаўся галавой вугла. ");
INSERT INTO beln_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Ад ГОСПАДА гэта сталася і гэта цуд у вачах нашых! ");
INSERT INTO beln_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Вось дзень, які стварыў ГОСПАД; будзем весяліцца і радавацца ў ім! ");
INSERT INTO beln_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Прашу, ГОСПАДЗЕ, збаў цяпер! Прашу, ГОСПАДЗЕ, дай посьпех цяпер! ");
INSERT INTO beln_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Дабраслаўлёны той, хто прыходзіць у імя ГОСПАДА; мы дабраслаўляем вас з дому ГОСПАДАВАГА. ");
INSERT INTO beln_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","ГОСПАД ёсьць Бог, Ён асьвятліў нас; прывяжыце вяроўкамі сьвяточную ахвяру да рагоў ахвярніку! ");
INSERT INTO beln_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ты —Бог мой, Цябе я буду славіць, Цябе, Божа мой, вывышаць! ");
INSERT INTO beln_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Слаўце ГОСПАДА, бо Ён — добры, бо на вякі міласэрнасьць Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Шчасьлівыя тыя, у якіх шлях беззаганны, якія ходзяць паводле закону ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Шчасьлівыя тыя, што захоўваюць сьведчаньні Ягоныя, якія ўсім сэрцам шукаюць Яго, ");
INSERT INTO beln_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","якія ня робяць беззаконьня, і ходзяць шляхам Ягоным. ");
INSERT INTO beln_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Ты загадаў, каб пільна захоўвалі загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","О, каб жа я ўмацаваў шлях мой, каб захоўваць пастановы Твае! ");
INSERT INTO beln_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Тады я ня буду асаромлены, калі буду глядзець на ўсе прыказаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Буду славіць Цябе ў шчырасьці сэрца, калі буду вучыцца судам праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Пастановы Твае я буду захоўваць, толькі не пакідай мяне! ");
INSERT INTO beln_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Якім чынам юнак захавае ў чыстасьці сьцежку сваю? Калі будзе захоўваць яе паводле слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Усім сэрцам маім я шукаю Цябе, ня дай мне адхіліцца ад прыказаньняў Тваіх! ");
INSERT INTO beln_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","У сэрцы маім я хаваю слова Тваё, каб не зграшыць супраць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Дабраслаўлёны Ты, ГОСПАДЗЕ! Навучы мяне пастановам Тваім! ");
INSERT INTO beln_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Вуснамі маімі абвяшчаю ўсе прысуды вуснаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","На шляху сьведчаньняў Тваіх я радуюся больш, чым ад усялякіх каштоўнасьцяў. ");
INSERT INTO beln_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Пра пастановы Твае буду разважаць і буду глядзець на сьцежкі Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","У пастановах Тваіх будзе ўцеха мая, не забудуся слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Рабі добрае слузе Тайму, каб я жыў і захоўваў слова Тваё. ");
INSERT INTO beln_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Расчыні вочы мае, і буду глядзець на цудоўныя дзеяньні закону Твайго! ");
INSERT INTO beln_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Я — прыхадзень на зямлі; не хавай ад мяне прыказаньні Твае! ");
INSERT INTO beln_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Зьнемаглася душа мая, прагнучы ўвесь час судоў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ты ўтаймаваў свавольнікаў, якія праклятыя, бо ўхіляюцца ад прыказаньняў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Аддалі ад мяне ганьбу і пагарду, бо я захоўваю сьведчаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Нават калі засядуць князі і будуць змаўляцца супраць мяне, слуга Твой будзе разважаць пра пастановы Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Бо сьведчаньні Твае — пацеха мая і рада. ");
INSERT INTO beln_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Прыліпла да пылу душа мая; ажыві мяне паводле слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Пра шляхі мае я апавядаў, і Ты адказаў мне; навучы мяне пастановам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Дай мне зразумець шлях загадаў Тваіх, і я буду разважаць пра цуды Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Сьлёзы ліе душа мая ад смутку, узьнімі мяне паводле слова Твайго! ");
INSERT INTO beln_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Шлях хлусьні аддалі ад мяне і закон Твой няхай будзе літасьцівы да мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Я выбраў шлях вернасьці, суды Твае паставіў перад вачыма. ");
INSERT INTO beln_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Я прыляпіўся да сьведчаньняў Тваіх; ГОСПАДЗЕ, ня дай мне асароміцца! ");
INSERT INTO beln_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Шляхам прыказаньняў Тваіх я пабягу, бо Ты пашыраеш сэрца маё. ");
INSERT INTO beln_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Навучы мяне, ГОСПАДЗЕ, шляху пастановаў Тваіх, і я буду пільнавацца яго аж да канца. ");
INSERT INTO beln_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Дай мне разуменьне, і буду пільнавацца закону Твайго і захоўваць яго ўсім сэрцам. ");
INSERT INTO beln_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Вядзі мяне па сьцежцы прыказаньняў Тваіх, бо ў гэтым упадабаньне маё. ");
INSERT INTO beln_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Нахіляй сэрца маё да сьведчаньняў Тваіх, а не да прыбытку. ");
INSERT INTO beln_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Адвярні вочы мае, каб на марнасьць не глядзелі; ажыві мяне на шляхах Тваіх! ");
INSERT INTO beln_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Няхай паўстане слова Тваё для слугі Твайго, які ходзіць у страху Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Аддалі ад мяне ганьбу, якое баюся, бо суды Твае добрыя. ");
INSERT INTO beln_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Вось, я прагну загадаў Тваіх; ажыві мяне праведнасьцю Тваёю. ");
INSERT INTO beln_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Няхай прыйдзе да мяне міласэрнасьць Твая, ГОСПАДЗЕ, і збаўленьне Тваё паводле слова Твайго, ");
INSERT INTO beln_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","каб я мог адказаць словам таму, хто зьневажае мяне, бо я спадзяюся на слова Тваё. ");
INSERT INTO beln_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","І не пазбаў вусны мае слова праўды зусім, бо я на суды Твае спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","І я буду захоўваць закон Твой заўсёды, і на вякі вечныя, ");
INSERT INTO beln_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","і буду хадзіць па прасторы шырокім, бо загадаў Тваіх я шукаў. ");
INSERT INTO beln_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","І буду гаварыць пра сьведчаньні Твае перад валадарамі і ня буду асаромлены. ");
INSERT INTO beln_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","І буду мець уцеху ў прыказаньнях Тваіх, якія я ўзьлюбіў. ");
INSERT INTO beln_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","І буду ўздымаць рукі мае да прыказаньняў Тваіх, якія я ўзьлюбіў, і буду разважаць пра пастановы Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Узгадай слова да слугі Твайго, на якое маю спадзявацца. ");
INSERT INTO beln_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Гэта пацяшэньне маё ў нядолі маёй, бо слова Тваё ажыўляе мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Свавольнікі вельмі зьдзекуюцца з мяне; але я ад закону Твайго ня ўхіляўся. ");
INSERT INTO beln_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Узгадваў я, ГОСПАДЗЕ, суды Твае спрад вякоў, і гэта пацяшала мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Гнеў палючы мяне агарнуў на бязбожнікаў, якія пакінулі закон Твой. ");
INSERT INTO beln_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Пастановы Твае сталіся гімнам для мяне ў доме вандраваньня майго. ");
INSERT INTO beln_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Імя Тваё, ГОСПАДЗЕ, я ўначы ўзгадваў і захоўваў закон Твой. ");
INSERT INTO beln_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Гэтак сталася са мною, бо я пільнаваўся загадаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","“Мая частка, ГОСПАДЗЕ, — сказаў я,— захоўваць слова Тваё”. ");
INSERT INTO beln_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Я прынізіўся перад абліччам Тваім ад усяго сэрца; зьлітуйся нада мною паводле слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Я думаў пра шляхі мае, і зьвярнуў ногі мае да сьведчаньняў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Сьпяшаўся я і не марудзіў захоўваць прыказаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Путы бязбожнікаў аблуталі мяне, але закон Твой я не забыўся. ");
INSERT INTO beln_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Сярод ночы я ўстаю, каб славіць Цябе за суды праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Я — суполькнік для ўсіх, што баяцца Цябе і захоўваюць загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Міласэрнасьць Твая, ГОСПАДЗЕ, напоўніла зямлю; навучы мяне пастановам Тваім! ");
INSERT INTO beln_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Дабро Ты зрабіў слузе Твайму, ГОСПАДЗЕ, паводле слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Добраму розуму і веданьню навучы мяне, бо я прыказаньням Тваім веру. ");
INSERT INTO beln_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Перш, чым я стаўся спакораным, я блукаў; цяпер слова Тваё я захоўваю. ");
INSERT INTO beln_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Ты добры і робіш добрае, навучы мяне пастановам Тваім! ");
INSERT INTO beln_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Свавольнікі надумалі хлусьню супраць мяне; а я ўсім сэрцам буду пільнавацца загадаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Сталася нячулым ад тлушчу сэрца іхняе; а я меў уцеху ў законе Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Добра мне, што я быў ўпакораны, каб навучыўся пастановам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Лепшы для мяне закон вуснаў Тваіх, чым тысячы золата і срэбра. ");
INSERT INTO beln_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Рукі Твае зрабілі мяне і ўмацавалі; дай мне разуменьне, каб я навучыўся прыказаньням Тваім! ");
INSERT INTO beln_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Тыя, што баяцца Цябе, убачаць мяне і ўзрадуюцца, бо я на слова Тваё спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Ведаю, ГОСПАДЗЕ, што праведныя суды Твае, і слушна Ты ўпакорыў мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Няхай, прашу, міласэрнасьць Твая пацяшае мяне паводле слова Твайго да слугі Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Няхай прыйдзе да мяне літасьць Твая, каб я жыў, бо закон Твой — пацеха мая. ");
INSERT INTO beln_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Няхай будуць асаромлены свавольнікі, бо яны падманліва блыталі мяне; а я буду разважаць пра загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Няхай да мяне навернуцца тыя, што баяцца Цябе, і тыя, што ведаюць сьведчаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Няхай будзе сэрца маё беззаганным у выкананьні пастановаў Тваіх, каб я ня быў асаромлены. ");
INSERT INTO beln_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Зьнемагае душа мая без збаўленьня Твайго; на слова Тваё спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Зьнемагаюць вочы мае бяз слова Твайго, кажучы: “Калі ж Ты пацешыш мяне?” ");
INSERT INTO beln_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Я стаўся, як мех скураны ў дыме; але пастановаў Тваіх не забыўся. ");
INSERT INTO beln_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Колькі будзе дзён слугі Твайго, калі Ты ўчыніш суд над тымі, што перасьледуюць мяне? ");
INSERT INTO beln_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Выкапалі свавольнікі яму для мяне, але гэта пярэчыць закону Твайму. ");
INSERT INTO beln_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Усё прыказаньні Твае — верныя; з дапамогай хлусьні перасьледуюць мяне, дапамажы Ты мне! ");
INSERT INTO beln_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Амаль вынішчылі мяне на зямлі; а я не пакінуў загадаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Праз міласэрнасьць Тваю захавай мне жыцьцё, і буду захоўваць сьведчаньні вуснаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","На вякі, ГОСПАДЗЕ, слова Тваё сьцьверджана на небе! ");
INSERT INTO beln_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","З пакаленьня ў пакаленьне вернасьць Твая; Ты ўгрунтаваў зямлю, і яна стаіць. ");
INSERT INTO beln_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Паводле прысуду Твайго стаяць яны да гэтага дня, бо ўсё гэта — слугі Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Калі б закон Твой ня быў ўцехай маёй, даўно б я згінуў у нядолі маёй. ");
INSERT INTO beln_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","На вякі не забудуся загадаў Тваіх, бо імі Ты захаваў мне жыцьцё. ");
INSERT INTO beln_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Я — Твой! Збаў мяне, бо я шукаю загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Цікуюць на мяне бязбожнікі, каб зьнішчыць мяне; а я пра сьведчаньні Твае разважаю. ");
INSERT INTO beln_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Я бачыў заканчэньне ўсякай дасканаласьці; але прыказаньні Твае ня маюць канца. ");
INSERT INTO beln_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Як я люблю закон Твой! Увесь дзень ён у думках маіх! ");
INSERT INTO beln_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Зрабілі мяне мудрэйшым за ворагаў маіх прыказаньні Твае, бо яны на вякі са мною. ");
INSERT INTO beln_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Я стаўся больш разважлівым за ўсіх, што вучылі мяне, бо сьведчаньні Твае ў думках маіх. ");
INSERT INTO beln_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Я стаўся разумнейшым за старых, бо пільнуюся загадаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ад усякай сьцежкі благой я стрымліваў ногі мае, каб захоўваць слова Тваё. ");
INSERT INTO beln_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ад прысудаў Тваіх я ня адступаўся, бо Ты мяне навучаеш. ");
INSERT INTO beln_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Як салодкія словы Твае паднябеньню майму, саладзей за мёд вуснам маім! ");
INSERT INTO beln_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Пра загады Твае буду разважаць, дзеля гэтага ненавіджу ўсякую сьцежку хлусьні. ");
INSERT INTO beln_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Слова Тваё — сьветач для ног маіх і сьвятло на сьцежцы маёй. ");
INSERT INTO beln_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Я прысягнуў і я падняўся, каб захоўваць суды праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Я вельмі моцна прыгнечаны; ГОСПАДЗЕ, ажыві мяне паводле слова Твайго! ");
INSERT INTO beln_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Мей упадабаньне, прашу, ГОСПАДЗЕ, у дабраахвотных абяцаньнях вуснаў маіх, і навучы мяне судам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Душа мая заўсёды ў руцэ маёй, і закону Твайго я не забываюся. ");
INSERT INTO beln_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Наставілі бязбожнікі пастку супраць мяне, але я не ўхіліўся ад загадаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Я ўспадкаеміў сьведчаньні Твае на вякі, бо яны — радасьць сэрца майго. ");
INSERT INTO beln_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Я нахіляю сэрца маё, каб рабіла паводле пастановаў Тваіх на вякі, аж да канца. ");
INSERT INTO beln_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Двудушных я ненавіджу, а закон Твой люблю. ");
INSERT INTO beln_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Ты — заслона мая і шчыт мой, на слова Тваё спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Адыйдзіце ад мяне, злачынцы, каб я мог захоўваць прыказаньні Бога майго. ");
INSERT INTO beln_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Падтрымай мяне паводле слова Твайго, і буду жыць, і ня буду асаромлены ў надзеі маёй. ");
INSERT INTO beln_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Умацуй мяне, і буду збаўлены, і буду ўглядацца ў пастановы Твае заўсёды. ");
INSERT INTO beln_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ты адапхнуў ўсіх, якія ўхіляюцца ад пастановаў Тваіх, бо хлусьлівы падман іхні. ");
INSERT INTO beln_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Быццам жужаль Ты выкідаеш усіх бязбожнікаў зямлі; дзеля гэтага я ўзьлюбіў сьведчаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Дрыжыць ад страху перад Табою цела маё, і судоў Тваіх я баюся. ");
INSERT INTO beln_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Я чыніў суд і праведнасьць; не аддай мяне прыгнятальнікам маім! ");
INSERT INTO beln_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Заступіся за слугу Твайго на дабро яму; каб не прыгняталі мяне свавольнікі. ");
INSERT INTO beln_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Зьнемагаюць вочы мае, выглядаючы збаўленьне Тваё і слова праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Учыні са слугою Тваім паводле міласэрнасьці Тваёй, і навучы мяне пастановам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Я — слуга Твой; дай мне разуменьне, каб пазнаў сьведчаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Час дзейнічаць для ГОСПАДА, бо яны парушылі закон Твой. ");
INSERT INTO beln_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Дзеля гэтага я люблю прыказаньні Твае больш, чым золата, золата найчысьцейшае. ");
INSERT INTO beln_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Дзеля гэтага ўсе загады Твае, усе лічу слушнымі, кожную сьцежку хлусьні ненавіджу. ");
INSERT INTO beln_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Цудоўныя сьведчаньні Твае, дзеля гэтага душа мая пільнуецца іх. ");
INSERT INTO beln_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Адкрыцьцё словаў Тваіх асьвятляе, дае разуменьне неразумным. ");
INSERT INTO beln_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Расчыняю я вусны мае і ўздыхаю, бо прагну прыказаньняў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Павярніся да мяне і зьлітуйся нада мною, паводле суду Твайго для тых, што любяць імя Тваё. ");
INSERT INTO beln_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Стопы мае ўмацуй Ты ў слове Тваім і ня дай беззаконьню авалодаць мною. ");
INSERT INTO beln_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Выбаў мяне ад крыўды чалавека, і буду захоўваць загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Аблічча Тваё няхай сьвеціць над слугою Тваім, і навучы мяне пастановам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Струмяні водаў цякуць з вачэй маіх, бо людзі не захоўваюць закон Твой. ");
INSERT INTO beln_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Ты праведны, ГОСПАДЗЕ, і справядлівыя суды Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Ты загадаў чыніць праведнасьць, сьведчаньні Твае і вернасьць вялікую. ");
INSERT INTO beln_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Зьядае мяне руплівасьць мая, бо забыліся на словы Твае прыгнятальнікі мае. ");
INSERT INTO beln_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Слова Тваё вельмі чыстае, і слуга Твой узьлюбіў яго. ");
INSERT INTO beln_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Малы я і пагарджаны, але загадаў Тваіх я не забываюся. ");
INSERT INTO beln_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Праведансьць Твая — праведнасьць на вякі, і закон Твой — праўда. ");
INSERT INTO beln_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Прыгнёт і гора знайшлі мяне; прыказаньні Твае — пацеха мая. ");
INSERT INTO beln_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Праведнасьць сьведчаньняў Тваіх — на вякі; дай мне разуменьне, і буду жыць. ");
INSERT INTO beln_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","З усяго сэрца я клічу, адкажы мне, ГОСПАДЗЕ, каб я пільнаваўся пастановаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Я клічу Цябе, збаў мяне, і буду захоўваць сьведчаньні Твае! ");
INSERT INTO beln_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Я апярэджваю сьвітаньне і галашу, на слова Тваё, на слова Тваё спадзяюся. ");
INSERT INTO beln_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Вочы мае апярэджваюць варту начную, каб мне разважаць пра слова Тваё. ");
INSERT INTO beln_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Голас мой пачуй паводле міласэрнасьці Тваёй, ГОСПАДЗЕ, паводле суду Твайго ажыві мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Набліжаюцца да мяне тыя, што імкнуцца да брыдоты; яны ад закону Твайго адступіліся. ");
INSERT INTO beln_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Але блізка Ты, ГОСПАДЗЕ, і ўсе прыказаньні Твае — праўда. ");
INSERT INTO beln_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Здаўна я ведаю сьведчаньні Твае, што Ты на вякі заснаваў іх. ");
INSERT INTO beln_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Глянь на нядолю маю і выратуй мяне, бо я пра закон Твой не забываўся. ");
INSERT INTO beln_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Барані мяне ў справе маёй і выбаў мяне, паводле слова Твайго ажыві мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Далёка ад бязбожнікаў збаўленьне, бо яны не шукалі пастановаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Літасьць Твая вялікая, ГОСПАДЗЕ; паводле суду Твайго ажыві мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Шмат тых, што перасьледуюць мяне і прыгнятаюць мяне; але ад сьведчаньняў Тваіх я не ўхіляўся. ");
INSERT INTO beln_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Я бачыў адступнікаў і брыдзіўся тымі, якія не захоўвалі слова Твайго. ");
INSERT INTO beln_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Глянь, ГОСПАДЗЕ, як я люблю загады Твае; паводле міласэрнасьці Тваёй ажыві мяне. ");
INSERT INTO beln_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Аснова слова Твайго — праўда, і на вякі кожны прысуд праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Князі перасьледуюць мяне без прычыны, але слова Твайго баіцца сэрца маё. ");
INSERT INTO beln_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Я радуюся са слова Твайго як той, хто знайшоў вялікі прыбытак. ");
INSERT INTO beln_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Хлусьню ненавіджу і брыджуся ёю, закон Твой люблю. ");
INSERT INTO beln_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Сямкротна ў дзень я хвалю Цябе за прысуды праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Вялікі супакой Ты даеш тым, якія любяць закон Твой, і яны не спатыкнуцца. ");
INSERT INTO beln_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Я ўзіраюся на збаўленьне Тваё, ГОСПАДЗЕ, і выконваю прыказаньні Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Захоўвала душа мая сьведчаньні Твае, і я моцна ўзьлюбіў іх. ");
INSERT INTO beln_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Я захоўваю загады Твае і сьведчаньні Твае, бо ўсе шляхі мае перад Табою. ");
INSERT INTO beln_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Няхай дойдзе галашэньне маё да аблічча Твайго, ГОСПАДЗЕ! Паводле слова Твайго дай мне разуменьне. ");
INSERT INTO beln_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Няхай прыйдзе маленьне маё перад аблічча Тваё! Паводле слова Твайго выратуй мяне! ");
INSERT INTO beln_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Вусны мае будуць апавядаць хвалу, бо Ты вучыш мяне пастановам Тваім. ");
INSERT INTO beln_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Язык мой будзе адказваць пра слова Тваё, бо ўсе прыказаньні Твае праведныя. ");
INSERT INTO beln_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Няхай станецца рука Твая дапамогай маёй, бо я выбраў загады Твае. ");
INSERT INTO beln_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Я прагну збаўленьня Твайго, ГОСПАДЗЕ, і закон Твой — пацеха мая. ");
INSERT INTO beln_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Няхай жыве душа мая, каб хваліць Цябе, і суды Твае няхай дапамогуць мне. ");
INSERT INTO beln_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Я заблукаў як авечка, што згубілася, адшукай Ты слугу Твайго, бо прыказаньняў Тваіх я не забываўся. ");
INSERT INTO beln_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Сьпеў узыходжаньня. Да ГОСПАДА я клікаў у бядзе маёй, і Ён адказаў мне. ");
INSERT INTO beln_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","ГОСПАДЗЕ, вызваль душу маю ад вуснаў хлусьлівых, ад языка здрадлівага. ");
INSERT INTO beln_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Што дасьць табе ды якую карысьць прынясе язык здрадлівы? ");
INSERT INTO beln_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Вострыя стрэлы волата і вугольле ядлоўцавае. ");
INSERT INTO beln_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Гора мне, што я жыву ў Мэшэка, што я пасяліўся ля намётаў Кедарскіх! ");
INSERT INTO beln_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Вельмі доўга душа мая жыла сярод тых, што ненавідзяць супакой. ");
INSERT INTO beln_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Я — сам супакой; ды, як толькі прамоўлю, яны пачынаюць вайну. ");
INSERT INTO beln_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Сьпеў узыходжаньня. Узьнімаю я вочы мае да гораў, адкуль прыйдзе да мяне дапамога. ");
INSERT INTO beln_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Дапамога мая ад ГОСПАДА, Які стварыў неба і зямлю. ");
INSERT INTO beln_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Ён ня дасьць пахіснуцца назе тваёй, не задрэмле Той, Які захоўвае цябе. ");
INSERT INTO beln_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Сапраўды, не задрэмле і ня будзе спаць Той, Які захоўвае Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","ГОСПАД — Той, Які захоўвае цябе, ГОСПАД — цень твой праваруч цябе. ");
INSERT INTO beln_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Удзень сонца ня ўдарыць цябе, ані месяц уначы. ");
INSERT INTO beln_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","ГОСПАД будзе захоўваць цябе ад усякага зла, будзе душу тваю Ён захоўваць. ");
INSERT INTO beln_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","ГОСПАД будзе захоўваць твой выхад і твой уваход ад цяпер і на вякі. ");
INSERT INTO beln_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Сьпеў узыходжаньня. Давіда. Узрадаваўся я, калі мне сказалі: “Хадзем у дом ГОСПАДА!” ");
INSERT INTO beln_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Вось, ногі нашыя стаяць у брамах тваіх, Ерусаліме! ");
INSERT INTO beln_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Ерусаліме! Ты пабудаваны, як горад, які злучаны разам, ");
INSERT INTO beln_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","куды ўваходзяць калены, калены ГОСПАДАВЫ, як сьведчаньне для Ізраіля славіць імя ГОСПАДА, ");
INSERT INTO beln_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","бо там стаяць пасады судовыя, пасады дому Давідавага. ");
INSERT INTO beln_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Прасіце пра супакой для Ерусаліму! Няхай маюць спакой тыя, што любяць цябе. ");
INSERT INTO beln_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Супакой няхай будзе ў мурах тваіх, дабрабыт у палацах тваіх. ");
INSERT INTO beln_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Дзеля братоў маіх і бліжніх маіх кажу цяпер: “Супакой табе!” ");
INSERT INTO beln_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Дзеля дому ГОСПАДА, Бога нашага, буду шукаць дабра для цябе. ");
INSERT INTO beln_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Сьпеў узыходжаньня. Узьнімаю я вочы мае да Цябе, Які жывеш у нябёсах. ");
INSERT INTO beln_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Сапраўды, як вочы слугаў глядзяць на руку паноў іхніх, як вочы служкі — на руку гаспадыні яе, так і вочы нашыя — на ГОСПАДА, Бога нашага, аж пакуль ня зьлітуецца над намі. ");
INSERT INTO beln_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Зьлітуйся над намі, ГОСПАДЗЕ, зьлітуйся, бо мы вельмі насычаныя пагардай! ");
INSERT INTO beln_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Вельмі моцна насычана душа нашая кпінамі ганарыстых і пагардай фанабэрыстых. ");
INSERT INTO beln_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Сьпеў узыходжаньня. Давіда. Калі б не было з намі ГОСПАДА, — скажы, прашу, Ізраіль, — ");
INSERT INTO beln_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","калі б не было з намі ГОСПАДА, калі паўстаў супраць нас чалавек, ");
INSERT INTO beln_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","тады яны б нас жывымі праглынулі, як гнеў іхні распаліўся на нас, ");
INSERT INTO beln_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","тады б воды нас затапілі, струмень заліў бы душы нашыя, ");
INSERT INTO beln_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","тады б воды бурлівыя залілі б душы нашыя. ");
INSERT INTO beln_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Дабраслаўлёны ГОСПАД, Які не аддаў нас зубам іхнім, як здабычу. ");
INSERT INTO beln_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Душа наша ўцякла, быццам птушка з сіла птушкалова; сіло парванае, і мы ўцяклі! ");
INSERT INTO beln_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Дапамога нашая — у імені ГОСПАДА, Які стварыў неба і зямлю. ");
INSERT INTO beln_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Сьпеў узыходжаньня. Тыя, што спадзяюцца на ГОСПАДА, яны як гара Сыён, якая не пахісьнецца і будзе на вякі. ");
INSERT INTO beln_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Горы вакол Ерусаліму, а ГОСПАД — вакол народу Свайго ад сёньня і на вякі. ");
INSERT INTO beln_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Бо кій бязбожнікаў не застанецца над лёсам праведнікаў, каб не цягнулі праведнікі рук сваіх да беззаконьня. ");
INSERT INTO beln_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Рабі, ГОСПАДЗЕ, добрае добрым і тым, хто шчыры ў сэрцы сваім. ");
INSERT INTO beln_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Але тых, што зыходзяць на сьцежкі крывыя свае, няхай выганіць ГОСПАД разам са злачынцамі. Супакой над Ізраілем! ");
INSERT INTO beln_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Сьпеў узыходжаньня. Калі ГОСПАД вярнуў палонных Сыёну, мы былі як у сьне. ");
INSERT INTO beln_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Былі тады нашыя вусны поўныя сьмеху, і язык наш — сьпяваньня. Казалі тады між паганамі: “Вялікае ГОСПАД з імі ўчыніў!” ");
INSERT INTO beln_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Вялікае ГОСПАД з намі ўчыніў, і мы былі радасныя. ");
INSERT INTO beln_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Вярні, ГОСПАДЗЕ, нашых палонных, як ручаі на зямлю паўднёвую. ");
INSERT INTO beln_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Той, хто ў сьлёзах сеяў, жаць будзе са сьпяваньнем. ");
INSERT INTO beln_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Тыя, што несьлі насеньне на пасеў, ішлі плачучы, але, вяртаючыся, вернуцца са сьпяваньнем, снапы свае несучы. ");
INSERT INTO beln_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Сьпеў узыходжаньня. Салямона. Калі ГОСПАД не збудуе дом, надарэмна цяжка працуюць будаўнікі; калі ГОСПАД не захоўвае горад, надарэмна чуваюць вартаўнікі. ");
INSERT INTO beln_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Надарэмна для вас рана ўставаць, позна сядзець і есьці хлеб у смутку, бо Свайму ўлюбёнаму Ён дае ў сьне. ");
INSERT INTO beln_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Вось, спадчына ад ГОСПАДА — дзеці, узнагарода Ягоная — плод чэрава. ");
INSERT INTO beln_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Быццам стрэлы ў магутнай руцэ, гэтак сыны маладыя. ");
INSERT INTO beln_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Шчасьлівы той чалавек, які напоўніў імі сагайдак свой. Ня будуць яны асаромленыя, калі з ворагамі ў браме будуць гаварыць. ");
INSERT INTO beln_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Сьпеў узыходжаньня. Шчасьлівы кожны, хто баіцца ГОСПАДА, хто ходзіць шляхамі Ягонымі. ");
INSERT INTO beln_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Ты будзеш працу рук тваіх есьці, ты шчасьлівы, і добра табе! ");
INSERT INTO beln_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Жонка твая ў доме тваим будзе плодная, быццам лаза вінаградная; сыны твае — як галіны аліўкавыя, наўкола стала твайго. ");
INSERT INTO beln_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Вось, гэтак будзе дабраслаўлёны муж, які баіцца ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","І дабраславіць цябе ГОСПАД з Сыёну, і ты будзеш бачыць дабрабыт Ерусаліму ў-ва ўсе дні жыцьця твайго, ");
INSERT INTO beln_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","і будзеш бачыць сыноў ад сыноў тваіх. Супакой над Ізраілем! ");
INSERT INTO beln_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Сьпеў узыходжаньня. Шмат уціскалі мяне з маладосьці маёй, — няхай скажа Ізраіль! — ");
INSERT INTO beln_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","шмат уціскалі мяне з маладосьці маёй, але мяне не перамаглі. ");
INSERT INTO beln_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","На хрыбце маім аралі аратыя, праганяючы доўгія барозны свае. ");
INSERT INTO beln_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","ГОСПАД праведны, Ён рассек вяроўкі бязбожнікаў. ");
INSERT INTO beln_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Няхай будуць асаромленыя і адступяцца назад усе, што ненавідзяць Сыён! ");
INSERT INTO beln_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Няхай будуць яны, як трава на даху, якая раней, чым вырвуць яе, засыхае, ");
INSERT INTO beln_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","і жнец не напоўніць ёю рукі сваёй, і вязальнік снапоў — жменяў сваіх. ");
INSERT INTO beln_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","I ня скажа той, што міма праходзіць: “Дабраслаўленьне ГОСПАДА няхай будзе над вамі! Дабраслаўляем вас імем ГОСПАДА!” ");
INSERT INTO beln_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Сьпеў узыходжаньня. З глыбіні я клічу Цябе, ГОСПАДЗЕ! ");
INSERT INTO beln_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Госпадзе, пачуй голас мой! Няхай вушы Твае зважаюць на голас маленьня майго! ");
INSERT INTO beln_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Калі Ты будзеш памятаць пра беззаконьні, ГОСПАДЗЕ, Госпадзе мой, хто устаіць? ");
INSERT INTO beln_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Бо ў Цябе прабачэньне, каб мелі страх перад Табою. ");
INSERT INTO beln_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Спадзяюся на ГОСПАДА, спадзяецца душа мая, і ў слове Ягоным маю спадзяваньне. ");
INSERT INTO beln_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Душа мая чакае на Госпада больш, чым стораж раніцы, чым стораж раніцы. ");
INSERT INTO beln_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Спадзявайся, Ізраілю, на ГОСПАДА, бо ў ГОСПАДА міласэрнасьць і шчодрасьць збаўленьня, ");
INSERT INTO beln_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","і Ён выбавіць Ізраіль ад ўсіх беззаконьняў ягоных. ");
INSERT INTO beln_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Сьпеў узыходжаньня. Давіда. ГОСПАДЗЕ, не вывышалася сэрца маё, і ня ўзносіліся вочы мае, і не хадзіў я за рэчамі занадта вялікімі і занадта для мяне недасяжнымі, ");
INSERT INTO beln_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","але я ўсьцішаў і супакойваў душу маю, як дзіця, што аднятае ад маці сваёй. Як дзіця, аднятае ад маці, душа мая ў-ва мне. ");
INSERT INTO beln_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Спадзявайся, Ізраіль, на ГОСПАДА, ад цяпер і на вякі! ");
INSERT INTO beln_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Сьпеў узыходжаньня. Узгадай, ГОСПАДЗЕ, пра Давіда і ўсе беды ягоныя, ");
INSERT INTO beln_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","як ён прысягаў ГОСПАДУ, даваў абяцаньне Моцнаму Якубаваму: ");
INSERT INTO beln_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Не ўвайду ў намёт дому майго, не ўзыйду на пасьцель ложка майго, ");
INSERT INTO beln_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ня дам вачам маім сну і павекам маім дрымоты, ");
INSERT INTO beln_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","пакуль не знайду месца для ГОСПАДА, сялібы для Моцнага Якубавага!” ");
INSERT INTO beln_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Вось, мы чулі пра яго ў Эфраце, знайшлі яго на палях Яару. ");
INSERT INTO beln_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Хадзем у сялібу Ягоную, паклонімся перад падножжам стопаў Ягоных. ");
INSERT INTO beln_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Паўстань, ГОСПАДЗЕ, ў месца супачынку Твайго, Ты і каўчэг моцы Тваёй! ");
INSERT INTO beln_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Сьвятары Твае няхай апрануцца ў праведнасьць, і багабойныя Твае няхай радуюцца! ");
INSERT INTO beln_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Дзеля Давіда, слугі Твайго, не адварочвай аблічча ад памазанца Твайго! ");
INSERT INTO beln_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Прысягаў ГОСПАД Давіду праўду і не адступіцца ад яе: “Таго, хто ёсьць плод улоньня твайго, пасаджу на пасадзе тваім. ");
INSERT INTO beln_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","І калі сыны Твае будуць захоўваць запавет Мой і сьведчаньні Мае, якім буду навучаць іх, таксама сыны іхнія будуць вечна сядзець на пасадзе тваім”. ");
INSERT INTO beln_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Бо ГОСПАД выбраў Сыён, пажадаў, каб быў сялібай для Яго, кажучы: ");
INSERT INTO beln_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“Вось месца супачынку Майго вечна. Тут буду жыць, бо яго ўпадабаў. ");
INSERT INTO beln_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Дабраслаўляючы, дабраслаўлю здабытак ягоны, убогіх ягоных насычу хлебам. ");
INSERT INTO beln_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","І сьвятароў ягоных апрану ў збаўленьне, і багабойныя ягоныя, радуючыся, радавацца будуць. ");
INSERT INTO beln_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Там Я ўзрашчу рог Давіду, там пастаўлю сьветач памазанцу Майму. ");
INSERT INTO beln_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Ворагаў ягоных апрану ў ганьбу, а над ім расквітнее дыядэма”. ");
INSERT INTO beln_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Сьпеў узыходжаньня. Давіда. О, як гэта добра і цудоўна, калі браты ў згодзе жывуць! ");
INSERT INTO beln_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Гэта быццам найлепшы алей на галаве, які сьцякае на бараду, на бараду Аарона, які сьцякае на край шаты ягонай, ");
INSERT INTO beln_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","нібы раса Гермону, якая зыходзіць на горы Сыёнскія, бо там ГОСПАД зьяўляе дабраслаўленьне і жыцьцё на вякі. ");
INSERT INTO beln_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Сьпеў узыходжаньня. О, дабраслаўляйце ГОСПАДА, усе слугі ГОСПАДАВЫ, якія начамі стаіцё ў доме ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Узьнімеце рукі вашыя да сьвятыні і дабраслаўляйце ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","З Сыёну няхай дабраславіць цябе ГОСПАД, Які стварыў неба і зямлю! ");
INSERT INTO beln_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Альлелюя! Хвалеце імя ГОСПАДА, хвалеце, слугі ГОСПАДАВЫ, ");
INSERT INTO beln_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","якія стаіцё ў доме ГОСПАДА, у панадворках дому Бога нашага! ");
INSERT INTO beln_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Хвалеце ГОСПАДА, бо добры ГОСПАД; выслаўляйце імя Ягонае, бо яно цудоўнае. ");
INSERT INTO beln_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Бо Якуба выбраў для Сябе ГОСПАД, Ізраіля — на ўласнасьць Сабе. ");
INSERT INTO beln_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Бо ведаю я, што ГОСПАД вялікі, і Госпад наш — па-над ўсімі багамі. ");
INSERT INTO beln_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Усё, што даспадобы ГОСПАДУ, робіць Ён у небе і на зямлі, у моры і у-ва ўсіх бяздоньнях. ");
INSERT INTO beln_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Ён уздымае хмары ад краю зямлі, робіць маланкі і дождж, выводзіць вецер са скарбніцы Сваёй. ");
INSERT INTO beln_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Ён пабіў першародных у Эгіпце, ад чалавека і да скаціны. ");
INSERT INTO beln_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Ён паслаў знакі і цуды пасярод цябе, Эгіпце, над фараонам і ўсімі слугамі ягонымі. ");
INSERT INTO beln_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Ён пабіў шматлікія народы і забіў валадароў магутных: ");
INSERT INTO beln_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Сыгона, валадара Амарэйскага, і Ога, валадара Башану, і ўсе валадарствы Ханаану. ");
INSERT INTO beln_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","І аддаў зямлю іхнюю у спадчыну, у спадчыну Ізраілю, народу Свайму. ");
INSERT INTO beln_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","ГОСПАДЗЕ, імя Тваё на вякі! ГОСПАДЗЕ, памяць Твая з пакаленьня ў пакаленьне! ");
INSERT INTO beln_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Бо ГОСПАД будзе судзіць народ Свой і пашкадуе слугаў Сваіх. ");
INSERT INTO beln_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Ідалы народаў — срэбра і золата, творы рук чалавечых. ");
INSERT INTO beln_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Маюць вусны, і не гавораць, маюць вочы, і ня бачаць; ");
INSERT INTO beln_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","маюць вушы, і ня чуюць, і духу няма ў вуснах іхніх. ");
INSERT INTO beln_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Падобныя да іх будуць тыя, што робяць іх, усе, хто на іх спадзяецца. ");
INSERT INTO beln_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Доме Ізраіля, дабраслаўляйце ГОСПАДА! Доме Аарона, дабраслаўляйце ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Доме Левія, дабраслаўляйце ГОСПАДА! Вы, што баіцёся ГОСПАДА, дабраслаўляйце ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Дабраслаўлёны ГОСПАД з Сыёну, Які жыве ў Ерусаліме! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Слаўце ГОСПАДА, бо Ён добры, бо на вякі міласэрнасьць Яго! ");
INSERT INTO beln_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Слаўце Бога багоў, бо на вякі міласэнасьць Яго! ");
INSERT INTO beln_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Слаўце Пана паноў, бо на вякі міласэрнасьць Яго! ");
INSERT INTO beln_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Таго, Які Сам робіць цуды вялікія, бо на вякі міласэрнасьць Яго: ");
INSERT INTO beln_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Таго, Які неба ўчыніў з разуменьнем, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Таго, Які зямлю расьцягнуў па-над водамі, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Таго, Які ўчыніў сьвяцільні вялікія, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","сонца, каб кіравала днём, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","месяц і зоркі, каб кіравалі ноччу, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Таго, Які пабіў Эгіпет у першародных ягоных, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","і вывеў Ізраіля спасярод яго, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","рукою дужаю і рамяном узьнятым, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Таго, Які мора Чырвонае расьсек, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","і правёў Ізраіля пасярод яго, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","і кінуў фараона і войска ягонае ў мора Чырвонае, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Таго, Які вёў народ Свой праз пустыню, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Таго, Які пабіў валадароў вялікіх, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","і забіў валадароў слаўных, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Сыгона, валадара Амарэйскага, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","і Ога, валадара Башану, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","і аддаў зямлю іхнюю ў спадчыну, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","у спадчыну Ізраілю, слузе Свайму, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Таго, Які ў паніжэньні нашым успомніў аб нас, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","і выратаваў нас ад прыгнятальнікаў нашых, бо на вякі міласэрнасьць Яго; ");
INSERT INTO beln_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Таго, Які дае хлеб усякаму целу, бо на вякі міласэрнасьць Яго. ");
INSERT INTO beln_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Слаўце Бога нябёсаў, бо на вякі міласэрнасьць Яго! ");
INSERT INTO beln_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Ля рэк Бабілёнскіх сядзелі мы там і плакалі, Сыён успамінаючы. ");
INSERT INTO beln_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","На вербах сярод яго мы павесілі нашыя гусьлі. ");
INSERT INTO beln_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Бо там тыя, што нас паланілі, жадалі ад нас словаў песьні, і нішчыцелі нашыя — радасьці: “Засьпявайце нам нешта з песьняў Сыёнскіх!” ");
INSERT INTO beln_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Як жа сьпяваць нам сьпеў ГОСПАДА ў чужой зямлі? ");
INSERT INTO beln_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Калі я забудуся цябе, Ерусаліме, няхай забудзецца мяне правіца мая! ");
INSERT INTO beln_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Няхай язык мой прыліпне да паднябеньня майго, калі я ня буду памятаць цябе, калі не ўзніму Ерусалім па-над найвышэйшую радасьць маю! ");
INSERT INTO beln_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Прыгадай, ГОСПАДЗЕ, сынам Эдому дзень Ерусаліму, калі казалі яны: “Руйнуйце яго, руйнуйце аж да падвалінаў!” ");
INSERT INTO beln_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Дачка Бабілёнская, ты будзеш зруйнаваная! Шчасьлівы той, хто адплаціць табе за тое, што ты нам зрабіла! ");
INSERT INTO beln_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Шчасьлівы той, хто немаўлятаў тваіх схопіць і паб’е аб скалу. ");
INSERT INTO beln_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Давіда. Я буду славіць Цябе ўсім сэрцам; перад абліччам анёлаў* буду выслаўляць Цябе. ");
INSERT INTO beln_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Пакланюся ў сьвятыні сьвятасьці Тваёй і буду славіць імя Тваё за міласэрнасьць Тваю і праўду Тваю, бо Ты ўзьвялічыў па-над усякае імя Тваё слова Тваё. ");
INSERT INTO beln_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","У дзень, калі я клікаў, Ты адказаў мне, і ўзмоцніў сілаю душу маю. ");
INSERT INTO beln_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Будуць славіць Цябе, ГОСПАДЗЕ, усе валадары зямлі, бо пачуюць словы вуснаў Тваіх. ");
INSERT INTO beln_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","І будуць сьпяваць пра шляхі ГОСПАДАВЫ, бо вялікая слава ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Бо ўзвышаны ГОСПАД, але бачыць пакорнага і ганарлівага пазнае здалёк. ");
INSERT INTO beln_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Калі буду хадзіць сярод турботаў, Ты ажывіш мяне, супраць гневу ворагаў маіх Ты выцягнеш руку Тваю, і мяне вызваліць правіца Твая. ");
INSERT INTO beln_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","ГОСПАД выканае справу маю для мяне. ГОСПАДЗЕ, міласэрнасьць Твая на вякі! Не пакінь твораў рук Тваіх! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Кіраўніку хору: Давіда. Псальм. ГОСПАДЗЕ, Ты дасьледаваў мяне і ведаеш мяне. ");
INSERT INTO beln_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ты ведаеш, калі я сядаю і калі я ўстаю; разумееш думку маю здалёк. ");
INSERT INTO beln_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Сьцежку маю і ляжаньне маё Ты спазнаў, і ўсе шляхі мае Табе вядомыя. ");
INSERT INTO beln_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Бо няма яшчэ словаў на языку маім, а Ты, ГОСПАДЗЕ, ведаеш усё. ");
INSERT INTO beln_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ззаду і сьпераду Ты абняў мяне і паклаў на мяне руку Тваю. ");
INSERT INTO beln_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Надзвычай дзівоснае веданьне, перавышае мяне, не магу яго сьцяміць! ");
INSERT INTO beln_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Куды мне ісьці ад Духа Твайго і ад аблічча Твайго куды ўцячы? ");
INSERT INTO beln_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Калі б я ўзыйшоў на неба, Ты там; калі б паслаў сабе ложак ў пекле, — вось, і там Ты! ");
INSERT INTO beln_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Калі б я ўзяў крылы сьвітаньня, калі б пасяліўся на канцы мора, ");
INSERT INTO beln_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","там таксама рука Твая вадзіла б мяне, і трымала б мяне правіца Твая. ");
INSERT INTO beln_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Калі б я сказаў: “Няхай цемра пакрые мяне, і ноччу няхай станецца сьвятло вакол мяне”, ");
INSERT INTO beln_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","дык і цемра ня будзе цёмнай для Цябе, і ноч заясьнее, як дзень; цемра, як сьвятло. ");
INSERT INTO beln_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Бо Ты ўтварыў ныркі мае, выткаў мяне ва ўлоньні маці маёй. ");
INSERT INTO beln_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Слаўлю Цябе, бо я захапляльна і дзівосна збудаваны; цудоўныя справы Твае, і душа мая ведае добра. ");
INSERT INTO beln_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Не былі схаваныя косткі мае перад Табою, калі я кшталтаваўся пад заслонай, быў вытканы ў глыбінях зямлі. ");
INSERT INTO beln_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Зародак мой бачылі вочы Твае; і ў кнізе Тваёй запісаны ўсе дні, што былі вызначаны, калі яшчэ ніводнага з іх не было. ");
INSERT INTO beln_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Якія каштоўныя для мяне думкі Твае, Божа, якая вялікая безьліч іх! ");
INSERT INTO beln_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Лічу іх, але іх больш, чым пяску. Я буджуся, і я ўсьцяж з Табою. ");
INSERT INTO beln_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Калі б Ты, Божа, забіў бязбожніка, тады людзі крывавыя адыйдуць ад мяне. ");
INSERT INTO beln_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Яны гавораць супраць Цябе зламыснае; дарэмна робяць сябе ворагамі Тваімі. ");
INSERT INTO beln_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Ці ж ня мушу я ненавідзець тых, што ненавідзяць Цябе, ГОСПАДЗЕ, і брыдзіцца тымі, што супраць Цябе паўстаюць? ");
INSERT INTO beln_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Нянавісьцю поўнай я іх ненавіджу, яны сталіся ворагамі для мяне. ");
INSERT INTO beln_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Дасьледуй мяне, Божа, і спазнай сэрца маё, выспрабуй мяне і спазнай думкі мае! ");
INSERT INTO beln_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","І паглядзі, ці не на гаротным я шляху, і шляхам вечнасьці вядзі мяне. ");
INSERT INTO beln_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Кіраўніку хору. Псальм Давіда. ");
INSERT INTO beln_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Ратуй мяне, ГОСПАДЗЕ, ад чалавека ліхога, ад чалавека злачыннага захоўвай мяне! ");
INSERT INTO beln_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Яны задумляюць ліхое ў сэрцы сваім, кожны дзень узьнімаюць вайну, ");
INSERT INTO beln_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","навастрылі язык свой, як зьмеі, атрута зьмяіная ў вуснах іхніх. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Захавай мяне, ГОСПАДЗЕ, ад рук бязбожніка! Захоўвай мяне ад чалавека злачыннага, ад тых, што мяркуюць пахіснуць стопы мае. ");
INSERT INTO beln_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Пыхліўцы таемна наставілі пастку для мяне і петлі, расьцягнулі сеці пры сьцежцы, паставілі сіло для мяне. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Сказаў я да ГОСПАДА: “Ты— мой Бог! Прыхілі вуха, ГОСПАДЗЕ, на голас маленьня майго! ");
INSERT INTO beln_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","ГОСПАДЗЕ, Госпадзе, моц збаўленьня майго, Ты засланяеш галаву мне ў дзень бітвы. ");
INSERT INTO beln_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Ня дай таго, ГОСПАДЗЕ, што жадае бязбожнік, намерам ягоным ня дай споўніцца, каб не ўзьнімаліся яны! (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Няхай голавы тых, што мяне абступілі, пакрыюцца ліхоцьцем вуснаў іхніх! ");
INSERT INTO beln_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Няхай пасыплецца на іх вугольле! У агонь няхай кіне Ён іх, у дол глыбокі, каб ім не паўстаць! ");
INSERT INTO beln_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Чалавек з ліхім языком на зямлі ня ўстоіць; на чалавека злачыннага ліхоцьце цікаваць будзе, каб загубіць яго. ");
INSERT INTO beln_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Ведаю я, што ГОСПАД выступіць у справе прыгнечанага, дасьць суд убогаму. ");
INSERT INTO beln_vpl VALUES ("PS140_14","020_140_14","PSA","140","14","14","Дык будуць праведнікі славіць імя Тваё, правыя будуць жыць перад абліччам Тваім! ");
INSERT INTO beln_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Псальм Давіда. ГОСПАДЗЕ, клічу Цябе! Пасьпяшайся да мяне! Прыхілі вуха на голас мой, калі клічу да Цябе! ");
INSERT INTO beln_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Няхай будзе малітва мая як кадзіла перад абліччам Тваім, а ўзьніманьне рук маіх— як дар вечаровы! ");
INSERT INTO beln_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Пастаў, ГОСПАДЗЕ, варту вуснам маім, захоўвай дзьверы губаў маіх! ");
INSERT INTO beln_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Ня дай прыхіліцца сэрцу майму да словаў ліхіх, да чыненьня справаў бязбожных з людзьмі злачыннымі, і няхай ня буду я есьці ласункі іхнія. ");
INSERT INTO beln_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Няхай б’е мяне праведнік, бо гэта міласэрнасьць; няхай карае мяне, бо гэта алей для галавы, які не пашкодзіць галаве маёй; бо малітва мая — супраць ліхоты іхняй. ");
INSERT INTO beln_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Няхай будуць скінутыя ў рукі скалы судзьдзі іхнія, і пачуюць яны словы мае, бо яны прыемныя. ");
INSERT INTO beln_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Быццам нехта трушчыць і сячэ дровы на зямлі, так сыплюцца косткі нашыя ў пашчу пекла. ");
INSERT INTO beln_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Але да Цябе, ГОСПАДЗЕ, Госпадзе мой, вочы мае; у Табе я маю надзею, не зруйнуй Ты душы маёй. ");
INSERT INTO beln_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Захавай Ты мяне ад пасткі, што яны наставілі на мяне, ад сіла, што наставілі злачынцы. ");
INSERT INTO beln_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Няхай пападуцца усе разам бязбожнікі ў сеці свае, а я абміну іх. ");
INSERT INTO beln_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Навучаньне Давіда, калі быў у пячоры. Малітва. ");
INSERT INTO beln_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Голасам маім крычу я да ГОСПАДА, голасам маім прашу ГОСПАДА пра літасьць. ");
INSERT INTO beln_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Прад абліччам Ягоным выліваю смутак мой, пра трывогу маю перад абліччам Ягоным апавядаю. ");
INSERT INTO beln_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Калі зьнемагае ў-ва мне дух мой, Ты ведаеш сьцежку маю. На дарозе, якой я хаджу, яны таемна наставілі сіло на мяне. ");
INSERT INTO beln_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Гляджу я ўправа, і бачу, што няма нікога, хто б ведаў мяне; загінуў прытулак мой, ніхто не шукае душы маёй. ");
INSERT INTO beln_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Я крычу да Цябе, ГОСПАДЗЕ, кажучы: “Ты — прыстанішча маё, Ты — частка мая ў зямлі жывых!” ");
INSERT INTO beln_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Зваж на галашэньне маё, бо вельмі я зьнямогся; ратуй Ты мяне ад тых, што перасьледуюць мяне, бо яны дужэйшыя за мяне. ");
INSERT INTO beln_vpl VALUES ("PS142_8","020_142_8","PSA","142","8","8","Вызваль з вязьніцы душу маю, каб я славіў імя Тваё. Праведнікі абступаюць мяне навакол, бо Ты робіш дабро для мяне. ");
INSERT INTO beln_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Псальм Давіда. ГОСПАДЗЕ, пачуй малітву маю, прыхілі вуха на маленьне маё, паводле праўды Тваёй адкажы мне, паводле праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","І не ўваходзь у суд са слугою Тваім, бо ня будзе праведны перад абліччам Тваім ніхто з жывых. ");
INSERT INTO beln_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Бо перасьледуе вораг душу маю, скрышыў да зямлі жыцьцё маё, змусіў жыць мяне ў месцы цёмным, быццам тых, што памерлі даўно. ");
INSERT INTO beln_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","І зьнямогся ў-ва мне дух мой, замерла ў нутры маім сэрца маё. ");
INSERT INTO beln_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Я ўзгадваю дні старадаўныя, разважаю пра ўсе дзеяньні Твае, пра ўчынкі рук Тваіх думаю. ");
INSERT INTO beln_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Выцягваю рукі мае да Цябе; душа мая прагне Цябе, як зямля бязводная. (Сэлях) ");
INSERT INTO beln_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Пасьпяшайся, адкажы мне, ГОСПАДЗЕ! Чэзьне дух мой! Не хавай жа аблічча Твайго ад мяне, каб ня стаўся я падобным да таго, хто зыходзіць у магілу. ");
INSERT INTO beln_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Дай мне раніцаю чуць міласэрнасьць Тваю, бо я на Цябе спадзяюся. Дай мне ведаць шлях, якім мне ісьці, бо да Цябе я ўзьнімаю душу маю. ");
INSERT INTO beln_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Ратуй мяне ад ворагаў маіх, ГОСПАДЗЕ, у Цябе я хаваюся. ");
INSERT INTO beln_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Навучы мяне рабіць тое, што даспадобы Табе, бо Ты — Бог мой. Няхай добры Твой дух вядзе мяне да зямлі роўнай. ");
INSERT INTO beln_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","ГОСПАДЗЕ, дзеля імя Твайго ажыві мяне! У праведнасьці Тваёй вывядзі з уціску душу маю! ");
INSERT INTO beln_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","І ў міласэрнасьці Тваёй вынішчы ворагаў маіх, і зьнішчы ўсіх, што ўціскаюць душу маю, бо я — слуга Твой! ");
INSERT INTO beln_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Давіда. Дабраслаўлёны ГОСПАД, скала мая, Які навучае рукі мае барацьбе, і пальцы мае — змаганьню. ");
INSERT INTO beln_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Міласэрнасьць для мяне і замчышча маё, умацаваны замак мой і Збаўца для мяне, шчыт мой, Той, у Якім маю надзею, Ён народ мой мне паддае! ");
INSERT INTO beln_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","ГОСПАДЗЕ, што ёсьць чалавек, што Ты ведаеш яго, і сын чалавечы, што Ты думаеш пра яго? ");
INSERT INTO beln_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Чалавек падобны да марнасьці; дні ягоныя — быццам цень, што мінае. ");
INSERT INTO beln_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","ГОСПАДЗЕ, нахілі неба Тваё і зыйдзі, дакраніся да гор, і яны запалаюць! ");
INSERT INTO beln_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Блісьні маланкай і расьцяруш іх, пусьці стрэлы Твае і пражані іх! ");
INSERT INTO beln_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Выцягні з вышыні руку Тваю, вызвалі мяне і выратуй мяне з водаў вялікіх, з рукі сыноў чужынскіх, ");
INSERT INTO beln_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","вусны якіх гавораць марнае, а правіца іхняя — правіца хлусьні. ");
INSERT INTO beln_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Божа, я новы сьпеў буду сьпяваць для Цябе, на псалтыры дзесяціструнным буду граць Табе, ");
INSERT INTO beln_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","бо Ты даеш выратаваньне валадару, і выбаўляеш Давіда, слугу Твайго, ад мяча злыдня! ");
INSERT INTO beln_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Выбаў мяне і выратуй мяне ад рукі сыноў чужынскіх, вусны якіх гавораць марнае, а правіца іхняя — правіца хлусьні. ");
INSERT INTO beln_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Няхай будуць сыны нашыя, быццам саджанцы, якія разрастаюцца ў маладосьці сваёй; дочкі нашыя — быццам слупы вуглавыя, якія высечаны паводле ўзору сьвятыні. ");
INSERT INTO beln_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Сьпіжарні нашыя няхай будуць поўныя, каб задаволіць любыя патрэбы, ўсялякія патрэбы; няхай у тысячу разоў памножацца авечкі нашыя на вуліцах нашых. ");
INSERT INTO beln_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Валы нашыя няхай будуць тлустыя, няхай ня будзе вылому, ані страты, ані ляманту на плошчах нашых! ");
INSERT INTO beln_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Шчасьлівы той народ, у якога гэтак дзеецца! Шчасьлівы той народ, у якога ГОСПАД ёсьць Бог ягоны! ");
INSERT INTO beln_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Хвала Давіда. Буду вывышаць Цябе, Божа мой і Валадару, і дабраслаўляць імя Тваё на вякі і вечна! ");
INSERT INTO beln_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Штодня буду дабраслаўляць Цябе і буду хваліць імя Тваё на вякі і вечна. ");
INSERT INTO beln_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Вялікі ГОСПАД і годны хвалы, і веліч Ягоная недасьледная. ");
INSERT INTO beln_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Пакаленьне пакаленьню будзе хваліць творы Твае і пра магутнасьць Тваю будзе апавядаць. ");
INSERT INTO beln_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Пра слаўную годнасьць велічнасьці Тваёй і пра цудоўныя дзеі Твае буду разважаць. ");
INSERT INTO beln_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Пра магутнасьць дзеяньняў страшных Тваіх няхай гавораць яны; а я пра веліч Тваю буду абвяшчаць. ");
INSERT INTO beln_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Успаміны пра вялікую добрасьць Тваю яны будуць пераказваць і весяліцца дзеля праведнасьці Тваёй. ");
INSERT INTO beln_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Літасьцівы і спагадлівы ГОСПАД, павольны да гневу і вельмі міласэрны. ");
INSERT INTO beln_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Добры ГОСПАД да ўсіх, і літасьць Ягоная — па-над усе Ягоныя справы. ");
INSERT INTO beln_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Няхай славяць Цябе, ГОСПАДЗЕ, усе творы Твае, і багабойныя Твае няхай дабраслаўляюць Цябе! ");
INSERT INTO beln_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Пра славу Валадарства Твайго няхай гавораць яны і пра магутнасьць Тваю расказваюць, ");
INSERT INTO beln_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","каб даведаліся сыны чалавечыя пра магутнасьць Ягоную і пра славу велічнасьці Валадарства Ягонага. ");
INSERT INTO beln_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Валадарства Тваё — валадарства на ўсе вякі, і панаваньне Тваё — ва усіх пакаленьнях. ");
INSERT INTO beln_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Падтрымлівае ГОСПАД усіх, хто падае, і падыймае ўсіх прыгнечаных. ");
INSERT INTO beln_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Вочы ўсіх на Цябе ўзіраюцца, і Ты ім спажыву даеш у свой час. ");
INSERT INTO beln_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ты расчыняеш руку Тваю і насычаеш усё, што жыве, паводле ўпадабаньня. ");
INSERT INTO beln_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Праведны ГОСПАД на ўсіх шляхах Сваіх і сьвяты ва усіх справах Сваіх. ");
INSERT INTO beln_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","ГОСПАД блізкі да ўсіх, што клічуць Яго, да ўсіх, што клічуць Яго ў праўдзе. ");
INSERT INTO beln_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Ён робіць паводле жаданьня тых, што баяцца Яго, і чуе лямант іхні і выбаўляе іх. ");
INSERT INTO beln_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","ГОСПАД захоўвае ўсіх, што любяць Яго, але ўсіх бязбожных Ён зьнішчыць. ");
INSERT INTO beln_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Хвалу ГОСПАДУ будуць казаць вусны мае, і ўсякае цела няхай дабрасаўляе сьвятое імя Ягонае на вякі і вечна. ");
INSERT INTO beln_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Альлелюя! Хвалі, душа мая, ГОСПАДА! ");
INSERT INTO beln_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Хваліць буду ГОСПАДА, пакуль жыву; выслаўляць буду Бога майго, пакуль існую. ");
INSERT INTO beln_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Не спадзявайцеся на магнатаў, на сына чалавечага, у якім няма выратаваньня! ");
INSERT INTO beln_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Выйдзе дух з яго, і ён вернецца ў зямлю; у той самы дзень зьнікнуць і задумы ягоныя. ");
INSERT INTO beln_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Шчасьлівы той, у каго Бог Якубаў — дапамога, у каго надзея на ГОСПАДА, Бога ягонага, ");
INSERT INTO beln_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Які стварыў неба і зямлю, мора і ўсё, што ў ім, Які захоўвае праўду на вякі, ");
INSERT INTO beln_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Які ўчыняе суд для пакрыўджаных, дае хлеба галодным. ГОСПАД разьвязвае зьвязаных, ");
INSERT INTO beln_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","ГОСПАД расплюшчвае вочы сьляпых, ГОСПАД падыймае прыгнечаных, ГОСПАД любіць праведных. ");
INSERT INTO beln_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","ГОСПАД захоўвае прыхадняў, дапамагае сіротам і ўдовам, але шлях бязбожнікаў блытае. ");
INSERT INTO beln_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Валадарыць ГОСПАД на вякі; твой Бог, Сыёне, з пакаленьня ў пакаленьне! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Хвалеце ГОСПАДА, бо Ён добры; выслаўляйце Бога нашага, бо прыемна гэта. Хвала належыць Яму! ");
INSERT INTO beln_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","ГОСПАД будуе Ерусалім, зьбірае выгнанцаў Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ён лечыць скрышаных сэрцам і перавязвае раны іхнія. ");
INSERT INTO beln_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Ён вызначае лік зоркам, кожную імем яе называе. ");
INSERT INTO beln_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Вялікі наш Госпад і багаты сілай, розум Ягоны меры ня мае. ");
INSERT INTO beln_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","ГОСПАД дапамагае ўцісканым, бязбожнікаў да зямлі паніжае. ");
INSERT INTO beln_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Адкажыце ГОСПАДУ падзякай, выслаўляйце Бога нашага на гусьлях. ");
INSERT INTO beln_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Ён закрывае неба хмарамі, рыхтуе для зямлі дождж, узрошчвае траву на гарах, ");
INSERT INTO beln_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","дае скаціне спажыву яе; і груганятам, што крычаць да Яго. ");
INSERT INTO beln_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Ня ў сіле каня Ён мае ўпадабаньне і ня ногі мужа даспадобы Яму, ");
INSERT INTO beln_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","але даспадобы ГОСПАДУ тыя, што баяцца Яго, што спадзяюцца на міласэрнасьць Ягоную. ");
INSERT INTO beln_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Слаў ГОСПАДА, Ерусалім, хвалі Бога твайго, Сыёне! ");
INSERT INTO beln_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Бо Ён умацаваў завалы брамаў тваіх, дабраславіў сыноў тваіх пасярод цябе. ");
INSERT INTO beln_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ён дае супакой ў межах тваіх, тлустасьцю пшаніцы насычае цябе. ");
INSERT INTO beln_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Ён спасылае слова Сваё на зямлю, вельмі хутка бяжыць пастанова Ягоная! ");
INSERT INTO beln_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Ён дае сьнег, быццам воўну, сыпле шэраш, як попел. ");
INSERT INTO beln_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Ён кідае лёд Свой кавалкамі; перад марозам Ягоным хто можа ўстаяць? ");
INSERT INTO beln_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Ён пасылае слова Сваё, і растапляецца ўсё; Ён павее ветрам Сваім, і воды цякуць. ");
INSERT INTO beln_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Ён паведаміў слова, слова Сваё Якубу, пастановы Свае і суды Свае — для Ізраіля. ");
INSERT INTO beln_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Не зрабіў такога ніводнаму народу, і судоў Ягоных не пазналі яны. Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Альлелюя! Хвалеце ГОСПАДА з неба, хвалеце Яго на вышынях! ");
INSERT INTO beln_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Хвалеце Яго, усе анёлы Ягоныя! Хвалеце Яго, усе войскі Ягоныя! ");
INSERT INTO beln_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Хвалеце Яго, сонца і месяц, хвалеце Яго, усе зоркі ясныя! ");
INSERT INTO beln_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Хвалеце Яго, нябёсы нябёсаў, і вы, воды, што па-над нябёсамі! ");
INSERT INTO beln_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Няхай яны хваляць імя ГОСПАДА, бо Ён загадаў, і былі створаныя, ");
INSERT INTO beln_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","і паставіў іх на вякі вечныя; даў ім пастанову, і не пераступяць яе. ");
INSERT INTO beln_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Хвалеце ГОСПАДА з зямлі, цмокі і ўсе бяздоньні, ");
INSERT INTO beln_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","агонь і град, сьнег і туман, вецер бурны, які дзее паводле слова Ягонага, ");
INSERT INTO beln_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","горы і ўзгоркі ўсе, дрэвы пладовыя і кедры ўсе, ");
INSERT INTO beln_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","зьвяры і ўся скаціна, паўзуны і птаства крылатае, ");
INSERT INTO beln_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","валадары зямныя і ўсе народы, князі і ўсе судзьдзі зямлі, ");
INSERT INTO beln_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","юнакі разам з дзяўчатамі, старыя і маладыя. ");
INSERT INTO beln_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Няхай яны хваляць імя ГОСПАДА, бо толькі Ягонае імя ўзьвялічанае, слава Ягоная над зямлёю і небам! ");
INSERT INTO beln_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ён узьняў рог народу Свайго. Хвала Яму ад усіх багабойных Ягоных, ад сыноў Ізраіля, ад народу, блізкага Яму! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Альлелюя! Сьпявайце ГОСПАДУ новы сьпеў; хвала Яму ў зграмаджэньні багабойных! ");
INSERT INTO beln_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Весяліся, Ізраілю, ў Творцы тваім; радуйцеся, сыны Сыёну, у Валадару вашым! ");
INSERT INTO beln_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Хвалеце імя Ягонае карагодамі, на бубнах і на гусьлях выслаўляйце Яго! ");
INSERT INTO beln_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Бо даспадобы ГОСПАДУ народ Ягоны; уцісканым Ён зьявіць збаўленьне. ");
INSERT INTO beln_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Будуць цешыцца багабойныя ў славе Ягонай, будуць весяліцца на ложках сваіх. ");
INSERT INTO beln_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Праслаўленьне Богу няхай будзе ў вуснах іхніх, а меч двусечны — у руцэ іхняй, ");
INSERT INTO beln_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","каб зьдзейсьніць помсту над паганамі, кару над народамі, ");
INSERT INTO beln_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","каб вязаць валадароў іхніх ланцугамі, і шляхту іхнюю — кайданамі жалезнымі, ");
INSERT INTO beln_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","каб учыніць для іх суд, як напісана. Гэткая велічнасьць для ўсіх багабойных Ягоных! Альлелюя! ");
INSERT INTO beln_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Альлелюя! Хвалеце Бога ў сьвятыні Ягонай, хвалеце Яго ў прасьцягу моцы Ягонай! ");
INSERT INTO beln_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Хвалеце Яго за магутнасьць Ягоную; хвалеце Яго дзеля мноства Ягонае велічы! ");
INSERT INTO beln_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Хвалеце Яго гукам трубаў, хвалеце Яго на псалтыры і гусьлях! ");
INSERT INTO beln_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Хвалеце Яго з бубнамі і карагодамі; хвалеце Яго на струнах і жалейках! ");
INSERT INTO beln_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Хвалеце Яго на цымбалах гучных; хвалеце Яго на цымбалах галосных! ");
INSERT INTO beln_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Усякае дыханьне няхай хваліць ГОСПАДА! Альлелюя!");
INSERT INTO beln_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1"," Прыповесьці Салямона, сына Давіда, валадара Ізраіля, ");
INSERT INTO beln_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","каб спазнаць мудрасьць і настаўленьне, зразумець словы розуму, ");
INSERT INTO beln_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","каб атрымаць настаўленьні ў разважлівасьці, праведнасьці, судзе і справядлівасьці. ");
INSERT INTO beln_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","каб неразумным даць разумнасьць, юнаку — веды і разважлівасьць. ");
INSERT INTO beln_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Мудры няхай слухае і павялічвае веды, а разумны няхай прыдбае мудрыя думкі, ");
INSERT INTO beln_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","каб зразумець выслоўе і прыповесьць, словы мудрых і загадкі іхнія. ");
INSERT INTO beln_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Страх перад ГОСПАДАМ — пачатак веданьня. Неразумныя пагарджаюць мудрасьцю і настаўленьнем. ");
INSERT INTO beln_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Сыне мой, паслухай перасьцярогаў бацькі свайго і не адкідай павучаньняў маці сваёй, ");
INSERT INTO beln_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","бо яны — прывабны вянок на галаве тваёй і каштоўныя каралі на шыі тваёй. ");
INSERT INTO beln_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Сыне мой, калі б цябе намаўлялі грэшнікі, не далучайся да іх. ");
INSERT INTO beln_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Калі яны скажуць: «Хадзем з намі! Зробім засаду дзеля праліцьця крыві; наставім без прычыны пастку на нявіннага; ");
INSERT INTO beln_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","праглынем іх жыўцом, як пекла, і цалкам, як тых, што зыходзяць у магілу; ");
INSERT INTO beln_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","знойдзем усялякія каштоўнасьці, напоўнім дамы свае здабычаю. ");
INSERT INTO beln_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Жэрабя сваё кідай разам з намі, няхай адзін мех будзе для нас усіх». ");
INSERT INTO beln_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Сыне мой, не хадзі з імі, устрымай нагу сваю ад сьцежкі іхняй, ");
INSERT INTO beln_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","бо ногі іхнія бягуць да злачынства і сьпяшаюцца на праліцьцё крыві. ");
INSERT INTO beln_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Бо надарэмна настаўляецца сетка на вачах усяго птаства. ");
INSERT INTO beln_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","А яны цікуюць на ўласную кроў, робяць засаду супраць душы? сваёй. ");
INSERT INTO beln_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Такія вось сьцежкі кожнага, хто прагне чужога даброцьця; яно забірае душу таго, хто завалодае ім. ");
INSERT INTO beln_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Мудрасьць гукае на вуліцах, на плошчах узьнімае голас свой, ");
INSERT INTO beln_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","на скрыжаваньнях шумлівых дарог кліча, у брамах гарадзкіх гучаць яе словы: ");
INSERT INTO beln_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","«Дакуль, неразумныя, будзеце любіць неразумнасьць; дакуль, насьмешнікі, будзеце захапляцца насьмешкамі сваімі, а невукі — пагарджаць веданьнем? ");
INSERT INTO beln_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Зьвярніцеся да настаўленьня майго, і я выльлю на вас духа майго, і абвяшчу вам словы мае. ");
INSERT INTO beln_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Вось жа я клікала, але вы адмаўляліся, працягвала руку сваю, але ніхто не зьвярнуў увагі. ");
INSERT INTO beln_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Вы ўзгардзілі радай маёю і адкінулі дакараньні мае. ");
INSERT INTO beln_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Дык і я буду сьмяяцца з вашага падзеньня, і насьмяхацца буду, калі прыйдзе на вас жах. ");
INSERT INTO beln_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Калі нахлыне жах, як бура, і загуба ваша, быццам віхор, калі прыйдуць на вас трывога і гора, ");
INSERT INTO beln_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","тады будуць клікаць мяне, але я не адкажу, шукаць мяне будуць, і ня знойдуць мяне. ");
INSERT INTO beln_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Бо яны зьненавідзелі веданьне і ня выбралі для сябе страху ГОСПАДАВА, ");
INSERT INTO beln_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","і не пайшлі за маімі парадамі, і ўзгардзілі маімі перасьцярогамі. ");
INSERT INTO beln_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Дык няхай ядуць яны плады шляху свайго і насыцяцца намерамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Бо адступніцтва неразумных заб’е іх, бяздумнасьць дурняў загубіць іх. ");
INSERT INTO beln_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","А хто слухае мяне, будзе жыць бясьпечна, будзе спакойны, не баючыся зла». ");
INSERT INTO beln_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Сыне мой, калі ты прыймеш словы мае і захаваеш у сябе прыказаньні мае, ");
INSERT INTO beln_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","прыхіляючы вуха сваё да мудрасьці і схіляючы сэрца сваё да разважлівасьці, ");
INSERT INTO beln_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","калі вось клікаць будзеш розум і голас свой уздымеш, заклікаючы развагу, ");
INSERT INTO beln_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","калі шукаць яе будзеш як срэбра, і прагнуць яе будзеш як багацьця, ");
INSERT INTO beln_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","тады зразумееш страх перад ГОСПАДАМ і знойдзеш пазнаньне Бога. ");
INSERT INTO beln_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Бо ГОСПАД дае мудрасьць, і з вуснаў Ягоных — веданьне і разуменьне. ");
INSERT INTO beln_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Ён захоўвае цьвярозы розум правым, Ён — шчыт для тых, якія ходзяць беззаганна. ");
INSERT INTO beln_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Ён пільнуе сьцежкі правасудзьдзя, захоўвае шляхі багабойных Сваіх. ");
INSERT INTO beln_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Тады зразумееш праведнасьць, суд і справядлівасьць, і кожны добры шлях, ");
INSERT INTO beln_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","калі ўвойдзе мудрасьць у сэрца тваё, і веданьне ўсьцешыць душу тваю. ");
INSERT INTO beln_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Разважлівасьць будзе пільнаваць цябе, і розум будзе захоўваць цябе, ");
INSERT INTO beln_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","каб выратаваць цябе ад шляху ліхога і ад чалавека, які гаворыць хлусьліва, ");
INSERT INTO beln_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","ад тых, якія пакідаюць шлях просты, каб хадзіць сьцежкамі цемры, ");
INSERT INTO beln_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","якія цешацца, робячы злое, і радуюцца з ліхіх учынкаў, ");
INSERT INTO beln_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","у якіх шляхі крывыя і якія блукаюцца на сьцежках сваіх, ");
INSERT INTO beln_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","каб выратаваць цябе ад чужой жанчыны і ад чужаніцы, што лісьліва гаворыць, ");
INSERT INTO beln_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","якая пакінула сябра маладосьці сваёй і забылася на запавет Бога свайго. ");
INSERT INTO beln_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Бо дом яе нахіліўся да сьмерці, і шлях ейны — да мёртвых; ");
INSERT INTO beln_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","усе, хто да яе ўваходзяць, назад не вяртаюцца і не знаходзяць сьцежак жыцьця. ");
INSERT INTO beln_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Дык хадзі ж ты шляхам добрых і трымайся сьцежкі праведнікаў, ");
INSERT INTO beln_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","бо правыя будуць жыць на зямлі, і беззаганныя застануцца на ёй. ");
INSERT INTO beln_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","А бязбожныя будуць вынішчаны з зямлі, ліхадзеі будуць выкарэнены з яе. ");
INSERT INTO beln_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Сыне мой, не забывайся настаўленьня майго, і няхай сэрца тваё захоўвае прыказаньні мае, ");
INSERT INTO beln_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","бо доўгія дні, гады жыцьця і супакой прынясуць яны табе. ");
INSERT INTO beln_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Міласэрнасьць і праўда няхай не пакідаюць цябе, абвяжы імі шыю сабе і напішы іх на табліцах сэрца твайго, ");
INSERT INTO beln_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","і знойдзеш ты ласку і спагаднасьць у вачах Бога і людзей. ");
INSERT INTO beln_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Спадзявайся на ГОСПАДА ўсім сэрцам сваім і не абапірайся на розум свой. ");
INSERT INTO beln_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Думай пра Яго на ўсіх шляхах тваіх, і Ён выпрастуе сьцежкі твае. ");
INSERT INTO beln_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Ня будзь мудры ў вачах сваіх, бойся ГОСПАДА і пазьбягай ліхоты. ");
INSERT INTO beln_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Гэта будзе здароўем для цела твайго і спасіленьнем косткам тваім. ");
INSERT INTO beln_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Шануй ГОСПАДА ўсёй маёмасьцю тваёй і пяршынамі ўсіх пладоў тваіх, ");
INSERT INTO beln_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","і напоўняцца гумны твае збожжам, а тоўчні твае перапоўняцца новым віном. ");
INSERT INTO beln_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Не адкідай, сыне мой, настаўленьня ГОСПАДАВА, і не ўхіляйся, калі Ён дакарае цябе, ");
INSERT INTO beln_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","бо каго любіць ГОСПАД, таго карае, як бацька, які спагадае сыну. ");
INSERT INTO beln_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Шчасьлівы чалавек, які знайшоў мудрасьць, і чалавек, які прыдбаў разуменьне. ");
INSERT INTO beln_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Бо здабыць яе лепш, чым здабыць срэбра, і плады ейныя лепшыя за золата. ");
INSERT INTO beln_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Яна — каштоўнейшая за пэрліны, і нішто з таго, што ты прагнеш, ня можа параўнацца з ёю. ");
INSERT INTO beln_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Доўгасьць дзён у правай руцэ яе, а ў левай руцэ — багацьце і слава. ");
INSERT INTO beln_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Шляхі яе — шляхі прыемныя, і ўсе сьцежкі ейныя — супакой. ");
INSERT INTO beln_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Яна — дрэва жыцьця для тых, што трымаюцца яе, шчасьлівыя тыя, якія абапіраюцца на яе. ");
INSERT INTO beln_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","ГОСПАД мудрасьцю заснаваў зямлю, нябёсы ўмацаваў розумам. ");
INSERT INTO beln_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Яго веданьнем расчыніліся бяздоньні і аблокі імгляць расою. ");
INSERT INTO beln_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Сыне мой, няхай гэта не адыходзіць ад вачэй тваіх, захоўвай разумнасьць і разважнасьць. ");
INSERT INTO beln_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","І яны стануцца жыцьцём для душы тваёй і аздобаю для шыі тваёй. ");
INSERT INTO beln_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Тады пойдзеш бясьпечна шляхам сваім, і нага твая не пахісьнецца. ");
INSERT INTO beln_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Калі ляжаш спаць, ня будзеш мець страху, і калі засьнеш, сон твой будзе салодкі. ");
INSERT INTO beln_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Не спалохаешся раптоўнага страху і загубы бязбожнікаў, калі яна прыйдзе, ");
INSERT INTO beln_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","бо ГОСПАД будзе тваім спадзяваньнем і захавае нагу тваю ад пасткі. ");
INSERT INTO beln_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Не адмаўляй у дабрадзействе таму, хто патрабуе, калі рука твая мае сілу зрабіць гэта. ");
INSERT INTO beln_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Не кажы бліжняму твайму: «Ідзі сабе і прыйдзі зноў, заўтра дам табе», калі маеш гэта пры сабе. ");
INSERT INTO beln_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Не надумляй ліхоцьця супраць бліжняга твайго, калі ён жыве пры табе бясьпечна. ");
INSERT INTO beln_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Не сварыся з чалавекам без прычыны, калі ён не зрабіў табе нічога благога. ");
INSERT INTO beln_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Не зайзросьці чалавеку злачыннаму і не выбірай ніводнага з шляхоў яго, ");
INSERT INTO beln_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","бо ГОСПАД брыдзіцца крывадушным, а з правымі Ён сябруе. ");
INSERT INTO beln_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Праклён ГОСПАДАЎ на доме бязбожніка, але жытло праведных Ён дабраслаўляе. ");
INSERT INTO beln_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Ён сьмяецца з насьмешнікаў, а пакорным ласку дае. ");
INSERT INTO beln_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Мудрыя атрымаюць у спадчыну славу, а бязглуздыя насіць будуць ганьбу. ");
INSERT INTO beln_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Слухайце, дзеці, настаўленьне бацькі і ўважайце, каб навучыцца розуму, ");
INSERT INTO beln_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","бо я даю вам добрую навуку; не пакідайце закону майго. ");
INSERT INTO beln_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Бо і я быў сы?нам у бацькі майго, пешчаны і адзіны ў маці маёй. ");
INSERT INTO beln_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","І ён вучыў мяне, і казаў мне: «Няхай трымаецца сэрца тваё словаў маіх, захоўвай прыказаньні мае і жыві. ");
INSERT INTO beln_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Набывай мудрасьць, набывай розум, не забывайся і не ўхіляйся ад словаў вуснаў маіх. ");
INSERT INTO beln_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Не пакідай яе, і яна захавае цябе, любі яе, і яна будзе пільнаваць цябе. ");
INSERT INTO beln_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Галоўнае — мудрасьць; набывай мудрасьць, і за ўсю маёмасьць сваю набывай розум. ");
INSERT INTO beln_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Узьвяліч яе, і яна падыме цябе, яна праславіць цябе, калі ты ўхопішся за яе, ");
INSERT INTO beln_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","ускладзе на галаву тваю вянок ласкі, аздобіць цябе каронаю славы». ");
INSERT INTO beln_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Слухай, сыне мой, і прыймі словы мае, і памножацца гады жыцьця твайго. ");
INSERT INTO beln_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Я паказваю табе шлях мудрасьці, вяду цябе сьцежкамі праведнасьці. ");
INSERT INTO beln_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Калі пойдзеш імі, ня будуць блытацца ногі твае, калі пабяжыш, не спатыкнешся. ");
INSERT INTO beln_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Трымайся настаўленьня, не занядбоўвай, захоўвай яго, бо яно — жыцьцё для цябе. ");
INSERT INTO beln_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Не ўзыходзь на сьцежку бязбожнікаў і не хадзі па шляху ліхотнікаў, ");
INSERT INTO beln_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","пазьбягай яго і не хадзі па ім, ухіляйся ад яго і абмінай яго, ");
INSERT INTO beln_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","бо не заснуць яны, калі ня ўчыняць благога, і сон іх ня возьме, калі не давядуць каго да падзеньня. ");
INSERT INTO beln_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Бо ядуць яны хлеб беззаконьня і п’юць віно гвалту. ");
INSERT INTO beln_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Але сьцежка праведных — як сьвятло зараніцы, што ўзыходзіць і расьце аж да поўнага дня. ");
INSERT INTO beln_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Шлях бязбожнікаў цёмны, яны ня ведаюць, дзе спатыкнуцца. ");
INSERT INTO beln_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Сыне мой, зважай на словы мае, прыхілі вуха тваё да прамоваў маіх. ");
INSERT INTO beln_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Няхай не зыходзяць яны з вачэй тваіх, захоўвай іх у глыбіні сэрца твайго, ");
INSERT INTO beln_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","бо яны — жыцьцё для таго, хто знайшоў іх, і здароўе для ўсяго цела яго. ");
INSERT INTO beln_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","З усёй стараннасьцю захоўвай сэрца сваё, бо з яго крыніца жыцьця. ");
INSERT INTO beln_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Адкінь ад сябе вусны хлусьлівыя, аддалі ад сябе язык крывадушны. ");
INSERT INTO beln_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Вочы твае няхай глядзяць проста, а павекі твае няхай скіраваныя будуць перад табою. ");
INSERT INTO beln_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Абдумай сьцежку для ног тваіх, і ўсе шляхі твае няхай будуць пэўныя. ");
INSERT INTO beln_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Не зыходзь ані направа, ані налева, аддалі нагу тваю ад ліхоцьця. ");
INSERT INTO beln_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Сыне мой, зважай на мудрасьць маю, прыхілі вуха тваё да розуму майго, ");
INSERT INTO beln_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","каб меў ты разважлівасьць, і вусны твае захавалі веданьне. ");
INSERT INTO beln_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Бо вусны распусьніцы ацякаюць мёдам, і паднябеньне яе мякчэйшае за алей, ");
INSERT INTO beln_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","але канец яе горкі, як палын, і востры, як меч двусечны. ");
INSERT INTO beln_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Ногі ейныя да сьмерці зыходзяць, а стопы ейныя на пекла абапіраюцца. ");
INSERT INTO beln_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Як яна не разумее сьцежкі жыцьця, дык хістаюцца крокі яе, і ты ня можаш ведаць іх. ");
INSERT INTO beln_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Дык вось цяпер, дзеці, паслухайце мяне, і не адыходзьцеся ад словаў вуснаў маіх. ");
INSERT INTO beln_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Аддалі ад яе шлях твой, і не падыходзь да дзьвярэй дому яе, ");
INSERT INTO beln_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","каб не аддаць годнасьці сваёй іншым і гадоў сваіх — бязьлітаснаму, ");
INSERT INTO beln_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","каб не сыцелі чужынцы з сілы тваёй, і з працы тваёй — у доме чужым. ");
INSERT INTO beln_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","І будзеш ты потым стагнаць, калі будуць зьняможаныя цела тваё і сілы твае. ");
INSERT INTO beln_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","І ты скажаш: «Чаму я зьненавідзеў настаўленьне, і сэрца маё ўзгардзіла дакараньнем. ");
INSERT INTO beln_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Ня слухаў я голасу настаўнікаў сваіх, і не прыхіляў я вуха свайго да тых, што вучылі мяне. ");
INSERT INTO beln_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Ледзь ня трапіў я ў вялікае няшчасьце сярод грамады? і народу!» ");
INSERT INTO beln_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Пі ваду са сваёй крыніцы, тую, што цячэ з твайго калодзежу. ");
INSERT INTO beln_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Навошта крыніцам тваім разьлівацца на вуліцы, а ручаям цячы па плошчах? ");
INSERT INTO beln_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Няхай яны служаць толькі табе, а не чужынцам разам з табою. ");
INSERT INTO beln_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Няхай крыніца твая будзе дабраслаўлёная, і цешся жонкай маладосьці тваёй. ");
INSERT INTO beln_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Яна — ланя ласкавая і сарна прыгожая, ейныя грудзі няхай поюць цябе ва ўсякую часіну, у каханьні яе мей асалоду заўсёды. ");
INSERT INTO beln_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Навошта табе, сыне мой, захапляцца распусьніцай і абдымаць улоньне чужаніцы? ");
INSERT INTO beln_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Бо перад вачамі ГОСПАДА шляхі чалавека, Ён ведае ўсе крокі яго. ");
INSERT INTO beln_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Бязбожніка схопяць ягоныя ўласныя правіны, і ён зьвязаны путамі грахоў сваіх. ");
INSERT INTO beln_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Ён памрэ без настаўленьня і будзе блукаць дзеля вялікай глупоты сваёй. ");
INSERT INTO beln_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Сыне мой, калі ты ручаўся за бліжняга твайго і даў руку тваю за чужога, ");
INSERT INTO beln_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","ты спутаў сябе словамі вуснаў сваіх, і ты злоўлены словамі вуснаў тваіх. ");
INSERT INTO beln_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Дык зрабі, што раю, сыне мой, і вызвалі сябе, бо ты трапіў у рукі бліжняга твайго: бяжы, упадзі да ног і ўпрошвай бліжняга свайго, ");
INSERT INTO beln_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","не давай сну вачам тваім і спачынку павекам тваім, ");
INSERT INTO beln_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","вырывайся, як сарна з рукі і як птушка з рукі птушкалова. ");
INSERT INTO beln_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Ідзі да мураша, гультаю, і паглядзі на шляхі ягоныя, і станься мудрым. ");
INSERT INTO beln_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Няма ў яго начальніка, ані наглядчыка, ані кіраўніка, ");
INSERT INTO beln_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","але ён летам загатаўляе хлеб сабе і зьбірае сваю ежу ў жніво. ");
INSERT INTO beln_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Як доўга, гультаю, будзеш спаць? Калі ты ўстанеш ад сну свайго? ");
INSERT INTO beln_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Крыху пасьпіш, крыху падрэміш, крыху, склаўшы рукі, паляжыш, ");
INSERT INTO beln_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","і прыйдзе, як валацуга, беднасьць твая, і нястача твая, як чалавек узброены. ");
INSERT INTO beln_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Чалавек нягодны, чалавек злачынны ходзіць з хлусьлівымі вуснамі, ");
INSERT INTO beln_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","лыпае вачыма сваімі, круціць нагамі сваімі, пальцамі сваімі знакі дае, ");
INSERT INTO beln_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","хавае ліхоту ў сэрцы сваім, увесь час прыдумляе благое, сваркі расьсявае. ");
INSERT INTO beln_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Таму зьнянацку прыйдзе на яго загуба, раптоўна будзе зьнішчаны, і ня будзе яму аздараўленьня. ");
INSERT INTO beln_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Вось шэсьць, якіх ненавідзіць ГОСПАД, і сем, якія агідныя для душы Яго: ");
INSERT INTO beln_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","вочы пыхлівыя, язык хлусьлівы, рукі, што праліваюць кроў нявінную, ");
INSERT INTO beln_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","сэрца, якое задумвае намеры зласьлівыя, ногі, што хутка бягуць на благое, ");
INSERT INTO beln_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","сьведка фальшывы, які дыхае няпраўдай, і той, хто сее нязгоду між братамі. ");
INSERT INTO beln_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Сыне мой, захавай прыказаньні бацькі твайго і не пакідай закон маці тваёй, ");
INSERT INTO beln_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","навяжы іх назаўсёды на сэрцы тваім і абвяжы імі шыю тваю. ");
INSERT INTO beln_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Калі пойдзеш, яны павядуць цябе, калі ляжаш спаць, будуць пільнаваць цябе, калі прабудзішся, будуць гаварыць да цябе. ");
INSERT INTO beln_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Бо прыказаньне — сьветач, і закон — сьвятло, а настаўленьне і дакараньне — шлях жыцьця, ");
INSERT INTO beln_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","каб захаваць цябе ад жанчыны ліхой, ад лісьлівага языка чужаніцы. ");
INSERT INTO beln_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Няхай не пажадае сэрца тваё прыгажосьці яе, няхай ня ўхопіць яна цябе вейкамі сваімі, ");
INSERT INTO beln_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","бо з прычыны распусьніцы галеюць да бохана хлеба, і чужаложніца цікуе на дарагую душу. ");
INSERT INTO beln_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Ці схавае хто агонь у запазуху, каб не загарэлася адзеньне ягонае? ");
INSERT INTO beln_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Ці можа хто хадзіць па распаленым вугольлі, не апёкшы ступняў сваіх? ");
INSERT INTO beln_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Так і той, хто ўваходзіць да жонкі бліжняга свайго, хто дакранаецца да яе, не пазьбегне кары. ");
INSERT INTO beln_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Не пагарджаюць злодзеем, калі ён крадзе, каб насыціць душу сваю, калі ён галодны, ");
INSERT INTO beln_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","але злоўлены, сямікроць аддасьць, аддасьць усю маёмасьць дому свайго. ");
INSERT INTO beln_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Хто чужаложыць з жанчынаю, той бязглузды, загубіць душу сваю той, хто гэтак чыніць. ");
INSERT INTO beln_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Біцьцё і сорам знойдзе ён сабе, і ганьба яго ня змыецца, ");
INSERT INTO beln_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","бо рэўнасьць раз’юшвае мужа, і не пашкадуе ён у дзень помсты, ");
INSERT INTO beln_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","ня гляне ён на ніякую аднагароду і адкіне дары, хоць іх павялічыш. ");
INSERT INTO beln_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Сыне мой, прыймі словы мае і захоўвай у сабе прыказаньні мае. ");
INSERT INTO beln_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Захоўвай прыказаньні мае і жыві, і закон мой — як зрэнку вока твайго. ");
INSERT INTO beln_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Навяжы іх на пальцы твае, напішы іх на табліцах сэрца твайго. ");
INSERT INTO beln_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Скажы мудрасьці: «Ты — сястра мая», і розум назаві сябрам, ");
INSERT INTO beln_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","каб яны захавалі цябе ад чужой жонкі, ад чужаніцы, што гаворыць лагодныя словы. ");
INSERT INTO beln_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Вось, глядзеў я праз вакно дому свайго, праз краты свае, ");
INSERT INTO beln_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","і ўбачыў сярод неразумных, заўважыў сярод маладых людзей юнака легкадумнага, ");
INSERT INTO beln_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","як праходзіў вуліцай каля рогу яе, як ішоў дарогаю ў дом яе, ");
INSERT INTO beln_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","у поцемках, у позьні час, у начной цемры і змроку. ");
INSERT INTO beln_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","І вось выходзіць насустрач яму жанчына, у распусным адзеньні, з падступным сэрцам, ");
INSERT INTO beln_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","галасьлівая і нястрыманая, ногі яе не бываюць у доме яе: ");
INSERT INTO beln_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","ці то на вуліцы, ці то на плошчы, і на кожным рагу растаўляе пасткі. ");
INSERT INTO beln_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","І схапіла яго, цалавала яго, і з бессаромным тварам казала яму: ");
INSERT INTO beln_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","«У мяне ахвяра мірная, сёньня споўніла абяцаньні мае, ");
INSERT INTO beln_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","таму выйшла на спатканьне табе, прагнула бачыць аблічча тваё і знайшла цябе. ");
INSERT INTO beln_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Дыванамі я заслала ложак мой, шматколернымі тканінамі з Эгіпту, ");
INSERT INTO beln_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","пакой мой пасыпала мірам, альвасам і цынамонам. ");
INSERT INTO beln_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Прыйдзі, будзем цешыцца пяшчотамі да раніцы, атрымліваць асалоду ад каханьня. ");
INSERT INTO beln_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Бо няма мужа ў доме, выбраўся ў далёкую дарогу, ");
INSERT INTO beln_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","капшук з грашыма ўзяў з сабою, у дзень поўні месяца мае вярнуцца дамоў». ");
INSERT INTO beln_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Мноствам ласкавых словаў прывабіла яго, лісьлівасьцю вуснаў сваіх зьвяла яго. ");
INSERT INTO beln_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Ён адразу пайшоў за ёю, як вол, ведзены на зарэз, як бязглузды, на ланцугу ведзены на пакараньне, ");
INSERT INTO beln_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","аж пакуль страла праб’е вантробы яго; як птушка, што кідаецца ў сіло, і ня ведае, што на загубу яе. ");
INSERT INTO beln_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Дык цяпер, дзеці, паслухайце мяне, і зважайце на словы вуснаў маіх. ");
INSERT INTO beln_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Няхай не схіляецца сэрца тваё да шляхоў яе, і не блукай па сьцежках яе, ");
INSERT INTO beln_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","бо шматлікія пакалечаныя ёю, і мноства магутных яна загубіла. ");
INSERT INTO beln_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Дом ейны — шлях у пекла, які вядзе ў сутарэньні сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Ці ж мудрасьць ня кліча? Ці ж розум ня ўзносіць голас свой? ");
INSERT INTO beln_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","На вяршынях гораў, пры дарозе, на ростанях стаіць яна, ");
INSERT INTO beln_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","ля брамаў, пры ўваходзе ў горад, пры дзьвярах кліча яна. ");
INSERT INTO beln_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","«Да вас, людзі, я клічу, да сыноў чалавечых голас мой! ");
INSERT INTO beln_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Навучыцеся, неразумныя, цьвярозаму мысьленьню, і вы, бязглуздыя, прыдбайце разумнае сэрца. ");
INSERT INTO beln_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Слухайце, бо буду гаварыць пра рэчы важныя, і расчыняцца вусны мае, каб сказаць рэчы справядлівыя. ");
INSERT INTO beln_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Бо праўду выкажа язык мой, і няправасьць — брыдота для вуснаў маіх. ");
INSERT INTO beln_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Выслоўі вуснаў маіх справядлівыя, няма ў іх хлусьні і крывадушнасьці. ");
INSERT INTO beln_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Усе яны простыя для разумнага і правыя для тых, што знайшлі веданьне. ");
INSERT INTO beln_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Прыйміце настаўленьне маё, а ня срэбра, лепш веды, чым чыстае золата, ");
INSERT INTO beln_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","бо мудрасьць лепшая за пэрлы, і ніякія каштоўнасьці не параўнаюцца з ёю. ");
INSERT INTO beln_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Я, мудрасьць, жыву разам з цьвярозым мысьленьнем і шукаю веданьня з разважнасьцю. ");
INSERT INTO beln_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Страх перад ГОСПАДАМ — ненавідзець ліхоту, пыху і фанабэрыстасьць, ліхія шляхі і крывадушныя вусны я ненавіджу. ");
INSERT INTO beln_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","У мяне рада і сапраўдная мудрасьць, я — розум, у мяне сіла. ");
INSERT INTO beln_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Дзякуючы мне валадары валадараць і князі дзейнічаюць справядліва. ");
INSERT INTO beln_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Дзякуючы мне начальнікі кіруюць, і магнаты, і ўсе судзьдзі зямлі. ");
INSERT INTO beln_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Я люблю тых, якія мяне любяць, і тыя, што мяне шукаюць, знойдуць мяне. ");
INSERT INTO beln_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","У мяне багацьце і слава, незьнішчальныя скарбы і праведнасьць. ");
INSERT INTO beln_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Плод мой лепшы за золата, і золата найчысьцейшае, і карысьць ад мяне лепшая за срэбра адборнае. ");
INSERT INTO beln_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Я хаджу сьцежкамі праведнасьці і шляхамі правасудзьдзя, ");
INSERT INTO beln_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","каб даць тым, што любяць мяне, у спадчыну даброцьці, і скарбніцы іх я напоўню. ");
INSERT INTO beln_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","ГОСПАД меў мяне на пачатку шляху Свайго, раней стварэньняў Сваіх, спакон вякоў. ");
INSERT INTO beln_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Спрадвеку я пастаўлена, ад пачатку, перш, чым зямля паўстала. ");
INSERT INTO beln_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Я нарадзілася, калі яшчэ не было бяздоньняў, калі не было крыніцаў, напоўненых водамі. ");
INSERT INTO beln_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Перш, чым горы былі асаджаны, перад узгоркамі я нарадзілася, ");
INSERT INTO beln_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","калі Ён яшчэ не стварыў ані зямлі, ані палёў, ані пачатковых пылінак сусьвету. ");
INSERT INTO beln_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Калі Ён прыгатоўваў нябёсы, я была там. Калі Ён крэсьліў скляпеньне над абліччам бяздоньня, ");
INSERT INTO beln_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","калі засноўваў аблокі ўгары?, калі ўмацоўваў крыніцы бяздоньня, ");
INSERT INTO beln_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","калі вызначаў для мора статут ягоны, каб воды не перакрочвалі рубяжы свае, калі закладаў падваліны зямлі, ");
INSERT INTO beln_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","я была ў Яго дойлідам і была пацехай Яго кожны дзень, радуючыся перад абліччам Яго кожны час, ");
INSERT INTO beln_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","радуючыся на заселенай зямлі Яго, і пацеха мая — з сынамі чалавечымі. ");
INSERT INTO beln_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Дык цяпер, дзеці, паслухайце мяне, і шчасьлівыя тыя, якія трымаюцца шляхоў маіх. ");
INSERT INTO beln_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Слухайце настаўленьне, і будзеце мудрымі, і не адкідайце яго. ");
INSERT INTO beln_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Шчасьлівы чалавек, які слухае мяне, чуваючы кожны дзень пры брамах маіх, стоячы на варце пры парозе дзьвярэй маіх. ");
INSERT INTO beln_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Бо хто знойдзе мяне, знойдзе жыцьцё і атрымае ласку ад ГОСПАДА, ");
INSERT INTO beln_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","а хто грашыць супраць мяне, шкодзіць душы сваёй; усе, якія ненавідзяць мяне, любяць сьмерць». ");
INSERT INTO beln_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Мудрасьць пабудавала сабе дом, вычасала сем слупоў яго, ");
INSERT INTO beln_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","закалола тое, што было на зарэз, зьмяшала віно і прыгатавала свой стол. ");
INSERT INTO beln_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Паслала служак сваіх, кліча на дзядзінцу і на вышынях гарадзкіх: ");
INSERT INTO beln_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","«Хто неразумны, няхай прыйдзе сюды», а да бязглуздага кажа: ");
INSERT INTO beln_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","«Прыходзьце, ешце хлеб мой і піце віно, якое я зьмяшала, ");
INSERT INTO beln_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","пакіньце дурноту і жывіце, і хадзіце шляхам розуму». ");
INSERT INTO beln_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Хто павучае насьмешніка, сьцягвае на сябе прыкрасьць, а хто дакарае бязбожніка, запляміцца. ");
INSERT INTO beln_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Не дакарай насьмешніка, каб ён не зьненавідзеў цябе, дакарай мудрага, і ён будзе любіць цябе. ");
INSERT INTO beln_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Настаўляй мудрага, і ён стане мудрэйшы, вучы праведнага, і ён павялічыць веды. ");
INSERT INTO beln_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Пачатак мудрасьці — страх ГОСПАДАЎ, і веданьне Сьвятога — розум. ");
INSERT INTO beln_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Бо праз мяне памножацца дні твае і дададуцца гады жыцьця твайго. ");
INSERT INTO beln_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Калі будзеш мудры, для сябе будзеш мудры, а калі станеш насьмешнікам — сам будзеш мець шкоду. ");
INSERT INTO beln_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Дурнота — жанчына крыклівая, неразумная і нічога ня ведае; ");
INSERT INTO beln_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","сядзіць ля дзьвярэй дому свайго на пасадзе, на вышынях гарадзкіх, ");
INSERT INTO beln_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","каб клікаць тых, што праходзяць дарогаю, што ідуць проста сьцежкамі сваімі: ");
INSERT INTO beln_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","«Хто неразумны, няхай прыйдзе сюды», а да бязглуздага кажа: ");
INSERT INTO beln_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","«Вада крадзеная салодкая, і схаваны хлеб смачнейшы». ");
INSERT INTO beln_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","І ня ведае той, што там мерцьвякі, і што ў цемры адхлані запрошаныя ёю. ");
INSERT INTO beln_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Прыповесьці Салямона. Мудры сын — радасьць для бацькі, а дурны сын — гора для маці. ");
INSERT INTO beln_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Не прыносяць карысьці скарбы бязбожныя, а праведнасьць ратуе ад сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Не дазволіць ГОСПАД галадаваць душы праведніка, але адкіне жаданьні бязбожнікаў. ");
INSERT INTO beln_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Лянівая рука робіць бедным, а рука працавітая ўзбагачае. ");
INSERT INTO beln_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Хто летам зьбірае, той сын разважлівы, а хто сьпіць у жніво — сын ганебны. ");
INSERT INTO beln_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Дабраславенствы — на галаве праведнага, а вусны бязбожнікаў хаваюць няправасьць. ");
INSERT INTO beln_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Памяць пра праведніка дабраслаўлёная, а імя бязбожнікаў спарахнее. ");
INSERT INTO beln_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Мудры сэрцам прыймае прыказаньні, а той, хто мае вусны неразумныя, упадзе. ");
INSERT INTO beln_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Хто ходзіць беззаганна, той ходзіць бясьпечна, а хто кры?віць шляхі свае, будзе выяўлены. ");
INSERT INTO beln_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Хто міргае вачыма, той робіць прыкрасьць, а той, хто мае вусны неразумныя, упадзе. ");
INSERT INTO beln_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Вусны праведніка — крыніца жыцьця, а вусны бязбожнікаў хаваюць няправасьць. ");
INSERT INTO beln_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Нянавісьць выклікае сваркі, а любоў пакрывае ўсе правіны. ");
INSERT INTO beln_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","У вуснах разумнага знаходзіцца мудрасьць, а кій — на сьпіне бязглуздага. ");
INSERT INTO beln_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Мудрыя захоўваюць веданьне, а вусны неразумнага вядуць да загубы. ");
INSERT INTO beln_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Маёмасьць багатага — умацаваны горад для яго, загуба для бедных — іхняя галеча. ");
INSERT INTO beln_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Праца праведніка вядзе да жыцьця, набытак бязбожніка — да грэху. ");
INSERT INTO beln_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","На сьцежцы жыцьця той, хто прыймае настаўленьне, а хто адкідае дакараньне — блукае. ");
INSERT INTO beln_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Хто хавае нянавісьць, у таго вусны хлусьлівыя, а хто паклёп разносіць, той дурань. ");
INSERT INTO beln_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","У мностве словаў не пазьбегнеш грэху, а хто стрымлівае вусны свае, той разважлівы. ");
INSERT INTO beln_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Язык праведніка — адборнае срэбра, а сэрца бязбожніка нічога ня вартае. ");
INSERT INTO beln_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Вусны праведнага пасьвяць многіх, а бязглуздыя паміраюць ад нястачы розуму. ");
INSERT INTO beln_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Дабраславенства ГОСПАДАВА, яно ўзбагачае, і смутку з сабою не прыносіць. ");
INSERT INTO beln_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Радасьць для дурня — учынкі ганебныя, а для чалавека разумнага — мудрасьць. ");
INSERT INTO beln_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Тое, чаго баіцца бязбожнік, прыйдзе на яго, а прагненьні праведных споўняцца. ");
INSERT INTO beln_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Калі пранясецца віхор, дык і ня будзе больш бязбожніка, а праведнік мае вечны падмурак. ");
INSERT INTO beln_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Як воцат для зубоў і як дым для вачэй, так гультай для тых, што яго пасылаюць. ");
INSERT INTO beln_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Страх ГОСПАДАЎ памнажае дні, а гады бязбожнікаў скароцяцца. ");
INSERT INTO beln_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Чаканьне праведнікаў — радасьць, а спадзяваньне бязбожнікаў загіне. ");
INSERT INTO beln_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Шлях ГОСПАДАЎ — апора для беззаганных і загуба для злачынцаў. ");
INSERT INTO beln_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Праведнік не пахісьнецца навекі, а бязбожнікі ня будуць жыць на зямлі. ");
INSERT INTO beln_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Вусны праведніка памнажаюць мудрасьць, а язык падступны будзе адсечаны. ");
INSERT INTO beln_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Вусны праведніка ведаюць, што даспадобы Богу, а вусны бязбожнікаў — падступнасьць. ");
INSERT INTO beln_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Агіда для ГОСПАДА — шалі падманлівыя, а вагі дакладныя даспадобы Яму. ");
INSERT INTO beln_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Прыходзіць пыхлівасьць, прыходзіць і ганьба, а ў пакорлівых — мудрасьць. ");
INSERT INTO beln_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Беззаганнасьць правых вядзе іх, а крывадушнасьць здрадлівых загубіць іх. ");
INSERT INTO beln_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Не дапаможа багацьце ў дзень гневу, а праведнасьць ратуе ад сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Праведнасьць беззаганнага раўняе шлях ягоны, а бязбожнік падае праз бязбожнасьць сваю. ");
INSERT INTO beln_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Праведнасьць правых ратуе іх, а ліхадзеі будуць злоўленыя злачынствам сваім. ");
INSERT INTO beln_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Калі памірае чалавек бязбожны, гіне надзея яго, і спадзяваньне злачынцаў прападае. ");
INSERT INTO beln_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Праведнік ратуецца ад бяды, а бязбожнік прыходзіць на месца яго. ");
INSERT INTO beln_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Крывадушнік вуснамі забівае бліжняга свайго, а праведнік ратуецца праз веданьне. ");
INSERT INTO beln_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Калі добра ідзе праведным, радуецца горад, і калі гінуць бязбожнікі, сьвяткуе. ");
INSERT INTO beln_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Дабраславенствам правых узвышаецца горад, а вуснамі бязбожнікаў руйнуецца. ");
INSERT INTO beln_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Той, хто пазбаўлены розуму, пагарджае бліжнім сваім, а чалавек разумны захоўвае мір. ");
INSERT INTO beln_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Хто ходзіць з абмовамі, адкрывае таямніцу, а той, хто верны духам, захоўвае слова. ");
INSERT INTO beln_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Дзе няма добрай рады, народ прападае, а пры мностве дарадцаў — выратаваньне. ");
INSERT INTO beln_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Шкодзіць сабе той, хто паручаецца за чужога, а хто ненавідзіць даваць руку, той бясьпечны. ");
INSERT INTO beln_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Пачцівая жанчына здабывае славу, і моцныя здабываюць багацьце. ");
INSERT INTO beln_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Чалавек міласэрны робіць дабро душы сваёй, а бязьлітасны нішчыць цела сваё. ");
INSERT INTO beln_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Падманлівы набытак здабудзе бязбожнік, а таму, хто сее праведнасьць, будзе пэўная нагарода. ");
INSERT INTO beln_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Праведнасьць вядзе да жыцьця, а хто імкнецца да зла, імкнецца да сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Агіда для ГОСПАДА крывадушныя сэрцам, але тыя, хто ходзяць беззаганна, даспадобы Яму. ");
INSERT INTO beln_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Можна паручы?цца, зло не пазьбегне пакараньня, а насеньне праведных будзе збаўленае. ");
INSERT INTO beln_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Як залатое колца ў лычы сьвіньні, так прыгожая жанчына, але бяз розуму. ");
INSERT INTO beln_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Прагненьне праведнікаў — толькі дабро, а чаканьне бязбожнікаў — гнеў. ");
INSERT INTO beln_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Адзін сыпе шчодра, і дадаецца яму, а другі лішне ашчадны, і бяднее. ");
INSERT INTO beln_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Дабрадзейная душа будзе насычана, і хто поіць другіх, сам напоены будзе. ");
INSERT INTO beln_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Хто затрымлівае збожжа, таго праклінае народ, але дабраславенства на галаве таго, хто продае. ");
INSERT INTO beln_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Хто імкнецца да дабра, той шукае зычлівасьці, а хто шукае зла, да таго яно прыйдзе. ");
INSERT INTO beln_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Хто спадзяецца на багацьце сваё, упадзе, а праведнікі, як лісьце, зелянеюць. ");
INSERT INTO beln_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Хто руйнуе дом свой, атрымае ў спадчыну вецер, і неразумны будзе слугою мудрага сэрцам. ");
INSERT INTO beln_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Плод праведнага — дрэва жыцьця, і мудры здабывае душы. ");
INSERT INTO beln_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Вось, праведнік будзе мець адплату на зямлі, пагатоў бязбожнік і грэшнік. ");
INSERT INTO beln_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Хто любіць настаўленьне, любіць веданьне, а хто ненавідзіць дакараньне, той дурань. ");
INSERT INTO beln_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Добры знойдзе ласку ў ГОСПАДА, але чалавека зламыснага Ён асудзіць. ");
INSERT INTO beln_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Ня будзе стаяць чалавек бязбожнасьцю, а корань праведных не захістаецца. ");
INSERT INTO beln_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Дабрадзейная жонка — карона для мужа свайго, а бессаромная — як гніль у костках ягоных. ");
INSERT INTO beln_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Думкі праведных слушныя, намеры бязбожнікаў падступныя. ");
INSERT INTO beln_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Словы бязбожнікаў цікуюць на кроў, але вусны правых ратуюць іх. ");
INSERT INTO beln_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Паваленыя бязбожнікі, і няма іх, а дом праведных будзе стаяць. ");
INSERT INTO beln_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Хваляць чалавека паводле розуму ягонага, але той, хто мае ліхое сэрца, будзе пагарджаны. ");
INSERT INTO beln_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Лепей быць простым і працаваць на сябе, чым выдаваць сябе за паважнага і ня мець хлеба. ");
INSERT INTO beln_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Праведнік рупіцца пра жыцьцё быдла свайго, а нутро бязбожных бязьлітаснае. ");
INSERT INTO beln_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Хто абрабляе сваю зямлю, той насыціцца хлебам, а хто ганяецца за марнасьцю, той ня мае розуму. ");
INSERT INTO beln_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Бязбожнік жадае злавіць у пасткі ліхоцьця, а корань праведных прыносіць плод. ");
INSERT INTO beln_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Ліхадзей заблытаецца праз правіны вуснаў сваіх, а праведнік выйдзе з бяды. ");
INSERT INTO beln_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","З плоду вуснаў сваіх чалавек насыціцца дабром, і праца рук чалавека зьвернецца да яго. ");
INSERT INTO beln_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Шлях неразумнага слушны ў вачах ягоных, але мудры той, хто слухае параду. ");
INSERT INTO beln_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Гнеў неразумнага выяўляецца адразу, а разумны хавае зьнявагу. ");
INSERT INTO beln_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Хто дыхае праўдаю, той выкажацца праўдзіва, а сьведка фальшывы хлусіць. ");
INSERT INTO beln_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Ёсьць такі, што лапоча і раніць як мечам, а язык мудрага лечыць. ");
INSERT INTO beln_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Вусны праўдамоўныя трываць будуць вечна, а язык хлусьлівы — імгненьне. ");
INSERT INTO beln_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Ашуканства ў сэрцы тых, якія задумляюць ліхоту, а ў тых, якія радзяць мір, — радасьць. ");
INSERT INTO beln_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Не спаткае праведніка нічога благога, а ў бязбожніка будзе поўна няшчасьцяў. ");
INSERT INTO beln_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Агіда для ГОСПАДА вусны хлусьлівыя, а тыя, што дзейнічаюць сумленна, падабаюцца Яму. ");
INSERT INTO beln_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Чалавек разумны прыхоўвае веданьне, а сэрца дурняў абвяшчае глупства. ");
INSERT INTO beln_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Рука руплівых будзе мець уладу, а нядбайныя будуць даньнікамі. ");
INSERT INTO beln_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Смутак у сэрцы чалавека прыгнятае яго, а добрае слова разьвяселіць яго. ");
INSERT INTO beln_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Праведнік мае перавагу над бліжнім сваім, а шлях бязбожнікаў зводзіць іх саміх. ");
INSERT INTO beln_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Гультай не сьпячэ ўпаляванага, а маёмасьць чалавека руплівага каштоўная. ");
INSERT INTO beln_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","На сьцежцы праведнасьці — жыцьцё, і на шляху яе няма сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Мудры сын слухае настаўленьне бацькі, а насьмешнік ня слухае дакараньня. ");
INSERT INTO beln_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","З плоду вуснаў сваіх чалавек будзе жывіцца дабром, а душа ліхадзеяў — гвалтам. ");
INSERT INTO beln_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Хто захоўвае вусны свае, захоўвае душу сваю, а хто шырока адкрывае свой рот, будзе мець зьнішчэньне. ");
INSERT INTO beln_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Душа гультая жадае і ня мае нічога, а душа руплівага будзе насычаная. ");
INSERT INTO beln_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Праведнік ненавідзіць слова хлусьлівае, а бязбожнік ганьбіць і зьневажае сябе. ");
INSERT INTO beln_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Праведнасьць захоўвае таго, хто беззаганны ў шляху сваім, а бязбожнасьць губіць грэшніка. ");
INSERT INTO beln_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Адзін выдае сябе за багатага, нічога ня маючы, іншы выдае сябе за беднага, маючы шмат багацьця. ");
INSERT INTO beln_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Выкуп душы чалавека — багацьце ягонае, а бедны пагрозы ня чуе. ");
INSERT INTO beln_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Сьвятло праведных радасна зьзяе, а сьветач бязбожнікаў стухне. ");
INSERT INTO beln_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Пыхлівасьць толькі да звадкі прыводзіць, а ў тых, што парады прыймаюць, — мудрасьць. ");
INSERT INTO beln_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Багацьце, здабытае марным чынам, змалее, а хто зьбірае яго рукою сваёю, — памнажае яго. ");
INSERT INTO beln_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Спадзяваньне, якое доўжыцца, — боль сэрца, а зьдзейсьненае жаданьне — дрэва жыцьця. ");
INSERT INTO beln_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Хто пагарджае Словам, той будзе зьнішчаны, а хто баіцца прыказаньняў, атрымае ўзнагароду. ");
INSERT INTO beln_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Закон мудрага — крыніца жыцьця, каб пазьбегнуць пастак сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Добры розум дае зычлівасьць, а шлях ліхадзеяў цяжкі. ");
INSERT INTO beln_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Кожны разумны дзейнічае з веданьнем, а дурны выяўляе неразумнасьць. ");
INSERT INTO beln_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Бязбожны пасланец трапляе ў бяду, а верны пасол — аздараўленьне. ");
INSERT INTO beln_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Галеча і ганьба таму, хто адкідае настаўленьне, а той, хто прыймае дакараньні, будзе ў пашане. ");
INSERT INTO beln_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Споўненае жаданьне — асалода для душы, але адвярнуцца ад зла — агіда для дурня. ");
INSERT INTO beln_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Хто ходзіць з мудрым, будзе мудрым, а хто сябруе з дурнем, загалосіць. ");
INSERT INTO beln_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Ліха гоніцца за грэшнікамі, а праведным будзе аднагароджана дабром. ");
INSERT INTO beln_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Добры пакідае спадчыну і ўнукам, а багацьце грэшнікаў захоўваецца для праведных. ");
INSERT INTO beln_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Многа хлеба і на ніве бедных, але некаторыя гінуць, бо няма суду. ");
INSERT INTO beln_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Хто шкадуе дубца свайго, той ненавідзіць сына свайго, а хто любіць яго, той з маленства настаўляе яго. ");
INSERT INTO beln_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Праведнік есьць і насычае душу сваю, а нутро бязбожнікаў будзе ў нястачы. ");
INSERT INTO beln_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Мудрая жонка будуе сабе дом, а неразумная руйнуе яго сваімі рукамі. ");
INSERT INTO beln_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Хто ходзіць проста, той баіцца ГОСПАДА, а хто кры?віць шляхі свае, той грэбуе Ім. ");
INSERT INTO beln_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","У вуснах неразумнага дубец пыхлівасьці, а вусны мудрых захоўваюць іх. ");
INSERT INTO beln_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Дзе няма скаціны, там ясьлі пустыя, але багата прыбытку ад сілы вала. ");
INSERT INTO beln_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Сьведка праўдзівы ня схлусіць, а сьведка фальшывы дыхае няпраўдай. ");
INSERT INTO beln_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Насьмешнік шукае мудрасьці, і яе няма, але веданьне лёгкае для разумнага. ");
INSERT INTO beln_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Адыйдзі ад чалавека дурнога, бо ня знойдзеш вуснаў разумных. ");
INSERT INTO beln_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Мудрасьць разумнага — разуменьне шляху свайго, а неразумнасьць дурняў — ашуканства. ");
INSERT INTO beln_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Неразумныя сьмяюцца з віны, а пасярод правых — зычлівасьць. ");
INSERT INTO beln_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Сэрца ведае горыч душы сваёй, і ў радасьць ягоную ня ўвойдзе чужынец. ");
INSERT INTO beln_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Дом бязбожнікаў будзе зьнішчаны, а намёт правых закрасуе. ");
INSERT INTO beln_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Ёсьць шлях, які слушны ў вачах чалавека, але канец яго — шляхі сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","І ў часе сьмеху баліць сэрца, і заканчэньне радасьці — смутак. ");
INSERT INTO beln_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Падступны сэрцам насыціцца шляхамі сваімі, а добры чалавек — сваімі. ");
INSERT INTO beln_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Неразумны верыць кожнаму слову, а разумны разважае пра крокі свае. ");
INSERT INTO beln_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Мудры баіцца і адварочваецца ад зла, а дурны гняўлівы і самаўпэўнены. ");
INSERT INTO beln_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Скоры на гнеў робіць дурасьць, а чалавек зламысны зьненавіджаны. ");
INSERT INTO beln_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Неразумныя атрымліваюць у спадчыну дурасьць, а разумныя ўкарануюцца веданьнем. ");
INSERT INTO beln_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Ліхія паклоняцца перад добрымі, а бязбожнікі — каля брамаў праведнікаў. ");
INSERT INTO beln_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Бедны зьненавіджаны нават бліжнім сваім, але шмат тых, хто любіць багатага. ");
INSERT INTO beln_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Хто цураецца бліжняга свайго, той грашыць, а хто літуецца над бедным, той шчасьлівы. ");
INSERT INTO beln_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Ці ж не заблукалі тыя, якія задумляюць зло? Але міласэрнасьць і праўда будзе тым, якія задумляюць добрае. ");
INSERT INTO beln_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","З кожнае працы будзе прыбытак, а ад пустых словаў — толькі нястача. ");
INSERT INTO beln_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Карона мудрых — багацьце іхняе, а вянок дурняў — глупства іхняе. ");
INSERT INTO beln_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Сьведка праўдзівы ратуе душы, а хлусьлівы дыхае няпраўдай. ");
INSERT INTO beln_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","У страху перад ГОСПАДАМ моцная пэўнасьць, і для сыноў Сваіх Ён будзе прыстанішчам. ");
INSERT INTO beln_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Страх ГОСПАДАЎ — крыніца жыцьця, каб пазьбегнуць пастак сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","У мностве народу веліч валадара, а ў малалікасьці людзей — загуба князя. ");
INSERT INTO beln_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","У павольнага на гнеў багата розуму, а запальчывы выяўляе дурасьць. ");
INSERT INTO beln_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Лагоднае сэрца — жыцьцё для цела, а зайздрасьць — парахненьне косткам. ");
INSERT INTO beln_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Хто прыгнятае ўбогага, той зьневажае Творцу ягонага, але шануе Яго той, хто літуецца над бедным. ");
INSERT INTO beln_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Бязбожнік будзе адкінуты за ліхоцьце сваё, а праведнік і пры сьмерці сваёй мае надзею. ");
INSERT INTO beln_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","У сэрцы разумнага жыве мудрасьць, і паміж дурняў яна вядомая. ");
INSERT INTO beln_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Праведнасьць узвышае народ, а грэх — ганьба для народаў. ");
INSERT INTO beln_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Зычлівы валадар да слугі разумнага, але абурэньне ягонае на таго, хто асаромлівае яго. ");
INSERT INTO beln_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Лагодны адказ адхінае ярасьць, а слова абразьлівае выклікае гнеў. ");
INSERT INTO beln_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Язык мудрых прыносіць веды, а вусны неразумных выказваюць глупства. ");
INSERT INTO beln_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Вочы ГОСПАДА на кожным месцы, яны бачаць добрых і ліхіх. ");
INSERT INTO beln_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Здаровы язык — дрэва жыцьця, а зласьлівы — заламаньне духа. ");
INSERT INTO beln_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Неразумны грэбуе настаўленьнем бацькі, а хто зважае на дакараньні — разумнее. ");
INSERT INTO beln_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","У доме праведніка шмат багацьця, а ў набытках бязбожніка — замяшаньне. ");
INSERT INTO beln_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Вусны мудрых сеюць веды, а сэрца бязглуздых не такое. ");
INSERT INTO beln_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Ахвяра бязбожнікаў — агіда для ГОСПАДА, а малітвы правых Яму даспадобы. ");
INSERT INTO beln_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Агіда для ГОСПАДА — шлях бязбожніка, а таго, хто імкнецца да праведнасьці, Ён любіць. ");
INSERT INTO beln_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Таму, хто ўхіляецца з дарогі, — строгая кара, і той, хто дакараньне ненавідзіць, — памрэ. ");
INSERT INTO beln_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Адхлань і пекла перад вачыма ГОСПАДА, а тым больш сэрцы сыноў чалавечых. ");
INSERT INTO beln_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Насьмешнік ня любіць таго, хто яго дакарае, і да мудрых ня пойдзе. ");
INSERT INTO beln_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Радаснае сэрца робіць аблічча вясёлым, а калі сэрца сумуе — дух разьбіты. ");
INSERT INTO beln_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Сэрца разумнае шукае веданьня, а вусны неразумных жывяцца дурнотаю. ");
INSERT INTO beln_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Усе дні прыгнечанага ліхія, а ў каго добра на сэрцы, у таго заўсёды бяседа. ");
INSERT INTO beln_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Лепш малое ў страху ГОСПАДАВЫМ, чым вялікія скарбы, а з імі трывога. ");
INSERT INTO beln_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Лепш крыху гародніны з любоўю, чым тлусты вол з нянавісьцю. ");
INSERT INTO beln_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Чалавек гняўлівы выклікае звадкі, а няскоры да гневу супакойвае спрэчку. ");
INSERT INTO beln_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Шлях гультая як жываплот з церня, а сьцежка правых — гладкая. ");
INSERT INTO beln_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Мудры сын — радасьць для бацькі, а дурны чалавек пагарджае маці сваёй. ");
INSERT INTO beln_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Дурасьць — радасьць для невука, а чалавек разумны ідзе простай дарогай. ");
INSERT INTO beln_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Бяз рады руйнуюцца намеры, а з мноствам дарадцаў яны зьдзяйсьняюцца. ");
INSERT INTO beln_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Радуецца чалавек з адказу вуснаў сваіх, і якое добрае слова адпаведнае. ");
INSERT INTO beln_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Сьцежка жыцьця ў разважлівага вядзе ўгару, каб пазьбегнуць адхлані, якая ў доле. ");
INSERT INTO beln_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","ГОСПАД развальвае дом пыхліўцаў, а мяжу ўдавы Ён вызначае. ");
INSERT INTO beln_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Агіда для ГОСПАДА — думкі бязбожных, а прамовы чыстыя прыемныя Яму. ");
INSERT INTO beln_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Нішчыць свой дом сквапны да зыску, а хто ненавідзіць падарункі, будзе жыць. ");
INSERT INTO beln_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Сэрца праведніка разважае адказ, а вусны бязбожнікаў вымаўляюць ліхоту. ");
INSERT INTO beln_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","ГОСПАД далёка ад бязбожнікаў, але малітвы праведных Ён чуе. ");
INSERT INTO beln_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Сьвятло вачэй радуе сэрца, і добрая вестка ўмацоўвае косьці. ");
INSERT INTO beln_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Вуха, якое слухае дакараньні жыцьця, будзе жыць сярод мудрых. ");
INSERT INTO beln_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Хто адкідае настаўленьне, грэбуе душою сваёю, а хто слухае дакараньняў, здабывае розум. ");
INSERT INTO beln_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Страх ГОСПАДАЎ навучае мудрасьці, і ўпакораньне папераджае славу. ");
INSERT INTO beln_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Да чалавека належыць меркаваньне сэрца, але ад ГОСПАДА адказ языка. ");
INSERT INTO beln_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Усе шляхі чалавека чыстыя ў вачах ягоных, але ГОСПАД узважвае душы. ");
INSERT INTO beln_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Ускладзі на ГОСПАДА ўсе справы свае, і ўсе намеры твае зьдзейсьняцца. ");
INSERT INTO beln_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Усё зрабіў ГОСПАД дзеля Сябе, і нават бязбожніка на дзень ліхі. ");
INSERT INTO beln_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Агіда для ГОСПАДА кожны пыхлівы сэрцам, можна паручы?цца, ён не застанецца непакараным. ");
INSERT INTO beln_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Міласэрнасьцю і праўдай адкупляецца беззаконьне, і страх ГОСПАДАЎ адводзіць ад зла. ");
INSERT INTO beln_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Калі ГОСПАДУ даспадобы шляхі чалавека, Ён нават ворагаў ягоных пагодзіць з ім. ");
INSERT INTO beln_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Лепш малое ў праведнасьці, чым багатыя прыбыткі ў беззаконьні. ");
INSERT INTO beln_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Сэрца чалавека абдумвае шлях свой, але ГОСПАД накіроўвае крокі ягоныя. ");
INSERT INTO beln_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Калі слова натхнёнае ў вуснах валадара, у судзе ня будзе падступным язык ягоны. ");
INSERT INTO beln_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Вага і шалі справядлівыя — ад ГОСПАДА, і ўсе камяні ваговыя ў торбе — справа Ягоная. ");
INSERT INTO beln_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Агіда для валадара — учынкі бязбожныя, бо пасад умацоўваецца праведнасьцю. ");
INSERT INTO beln_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Падабаюцца валадару вусны праведныя, і таго, хто гаворыць праўдзіва, ён любіць. ");
INSERT INTO beln_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Гнеў валадара — весьнік сьмерці, але мудры чалавек улагодзіць яго. ");
INSERT INTO beln_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","У сьвятле аблічча валадара — жыцьцё, і зычлівасьць ягоная — як воблака з позьнім дажджом. ");
INSERT INTO beln_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Нашмат лепш прыдбаць мудрасьць, чым золата, і лепей прыдбаць розум, чым срэбра. ");
INSERT INTO beln_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Шырокая дарога правых — адвярнуцца ад зла; хто пільнуе шлях свой, той захоўвае душу сваю. ");
INSERT INTO beln_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Перад загубай ідзе пыхлівасьць, і перад падзеньнем — дух ганарысты. ");
INSERT INTO beln_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Лепш скарацца духам з пакорнымі, чым дзяліць здабычу з пыхліўцамі. ");
INSERT INTO beln_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Разважлівы ў слове знойдзе добрае, і той, хто спадзяецца на ГОСПАДА, — шчасьлівы. ");
INSERT INTO beln_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Мудрага сэрцам называюць разумным, і слодыч вуснаў павялічвае веды. ");
INSERT INTO beln_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Розум — крыніца жыцьця для тых, хто мае яго, але настаўленьне неразумных — глупства. ");
INSERT INTO beln_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Сэрца мудрага робіць разважлівымі вусны ягоныя і мове ягонай дадае ведаў. ");
INSERT INTO beln_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Прыемныя словы — сотавы мёд, асалода для душы і лекі для цела. ");
INSERT INTO beln_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Ёсьць шлях, які слушны ў вачах чалавека, але канец яго — шляхі сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Работнік цяжка працуе для сябе, бо рот ягоны прымушае яго. ");
INSERT INTO beln_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Чалавек нягодны ліхоцьце рыхтуе, і ў вуснах ягоных нібы агонь, які паліць. ");
INSERT INTO beln_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Чалавек падступны сее звадкі, і пляткар разьдзяляе сяброў. ");
INSERT INTO beln_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Чалавек злачынны зводзіць бліжняга свайго і вядзе яго на шлях нядобры, ");
INSERT INTO beln_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","прыплюшчвае вочы свае, каб прыдумляць подступ, кры?віць губы свае, робячы ліха. ");
INSERT INTO beln_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Сівізна — слаўная карона, на шляху праведнасьці знаходзяць яе. ");
INSERT INTO beln_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Лепш павольны на гнеў, чым магутны, і той, які пануе над духам сваім, чым заваёўнік гораду. ");
INSERT INTO beln_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Жэрабя кідаюць у заўлоньне, але ад ГОСПАДА ўсе суды яго. ");
INSERT INTO beln_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Лепш сухая луста ў супакоі, чым дом, поўны заколатай жывёлы, са сваркамі. ");
INSERT INTO beln_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Разумны слуга будзе панаваць над шалапутным сы?нам і між братоў будзе дзяліць спадчыну. ");
INSERT INTO beln_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Літавальны гаршчок — для срэбра, і горан — для золата, а сэрцы выпрабоўвае ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Ліхотнік зважае на вусны нягодныя, хлус слухае язык згубны. ");
INSERT INTO beln_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Хто насьміхаецца з беднага, той зьневажае Творцу яго, і хто цешыцца з няшчасьця, не пазьбегне пакараньня. ");
INSERT INTO beln_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Карона старых — сыны сыноў, і слава сыноў — бацькі іхнія. ");
INSERT INTO beln_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Не пасуе бязглуздаму паважная мова, тым больш шляхетнаму вусны брахлівыя. ");
INSERT INTO beln_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Хабар — каштоўны камень у вачах гаспадара яго, куды толькі зьвернецца ён, будзе мець посьпех. ");
INSERT INTO beln_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Хто прыкрывае правіну, шукае любові, а хто паўтарае слова, разьдзяляе сяброў. ");
INSERT INTO beln_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Мацней дзейнічае нагана на разумнага, чым сто ўдараў на дурнога. ");
INSERT INTO beln_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Ліхадзей шукае толькі непаслухмянства, таму бязьлітасны анёл будзе пасланы супраць яго. ");
INSERT INTO beln_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Лепш спаткаць мядзьведзіцу, пазбаўленую дзяцей, чым дурня ў яго неразумнасьці. ");
INSERT INTO beln_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Хто адплочвае злом за дабро, у таго зло не адыйдзе ад дому ягонага. ");
INSERT INTO beln_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Пачатак звадкі — прарыў вады, перш, чым спрэчка пачнецца, пакінь яе. ");
INSERT INTO beln_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Той, хто апраўдвае злачынцу, і той, хто вінаваціць праведніка, — абодва агіда для ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Навошта грошы ў руцэ дурнога, каб набыць мудрасьці, калі няма розуму? ");
INSERT INTO beln_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Сябра любіць у кожны час, і ў нядолі робіцца братам. ");
INSERT INTO beln_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Чалавек, пазбаўлены розуму, дае руку і ручаецца перад абліччам бліжняга свайго. ");
INSERT INTO beln_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Хто любіць сваркі, любіць грэх, і хто падымае высока вароты свае, шукае загубы. ");
INSERT INTO beln_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Крывадушнае сэрца ня знойдзе дабра, і язык здрадлівы трапіць у бяду. ");
INSERT INTO beln_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Хто нараджае неразумнага, — на смутак сабе, і бацька бязглуздага ня будзе цешыцца. ");
INSERT INTO beln_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Радаснае сэрца аздараўляе, нібы лекі, а маркотны дух сушыць косьці. ");
INSERT INTO beln_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Бязбожнік бярэ хабар з-за пазухі, каб скрывіць сьцежкі правасудзьдзя. ");
INSERT INTO beln_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Перад абліччам разумнага — мудрасьць, а вочы дурня — на канцы зямлі. ");
INSERT INTO beln_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Сын неразумны — згрызота для бацькі свайго і горыч для той, якая яго нарадзіла. ");
INSERT INTO beln_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Таксама нядобра караць праведніка і біць шляхетнага за шчырасьць. ");
INSERT INTO beln_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Хто мае веданьне, той у словах ашчадны, і чалавек разумны мае спакойны дух. ");
INSERT INTO beln_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Таксама неразумны, калі маўчыць, лічыцца мудрым, і калі закрывае вусны свае, разважлівым. ");
INSERT INTO beln_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Свавольны шукае свайго жаданьня і кожнай цьвярозай думцы працівіцца. ");
INSERT INTO beln_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Дурань ня хоча застанаўляцца, а толькі каб выявіць свой розум. ");
INSERT INTO beln_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Калі прыходзіць бязбожнік, прыходзіць пагарда, і разам з сорамам — ганьба. ");
INSERT INTO beln_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Словы вуснаў чалавечых — глыбокія воды, крыніца мудрасьці — бурлівы ручай. ");
INSERT INTO beln_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Нядобра зважаць на аблічча бязбожнага, каб паваліць праведнага на судзе. ");
INSERT INTO beln_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Словы дурня прыводзяць да спрэчкі, і вусны ягоныя выклікаюць бойку. ");
INSERT INTO beln_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Вусны дурня — ягоная загуба, а мова ягоныя — пастка для душы яго. ");
INSERT INTO beln_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Словы пляткара — як прысмакі, яны зыходзяць у глыб нутра. ");
INSERT INTO beln_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Нядбайны ў рабоце сваёй — брат нішчыцеля. ");
INSERT INTO beln_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Імя ГОСПАДА — магутная вежа, пабяжыць туды праведнік і будзе ў бясьпецы. ");
INSERT INTO beln_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Маёмасьць багатага — умацаваны горад для яго, уяўляецца яна яму як муры? высокія. ");
INSERT INTO beln_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Перад загубай вывышаецца сэрца чалавека, а ўпакораньне папераджае славу. ");
INSERT INTO beln_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Хто дае адказ раней, чым выслухае, той неразумны, і сорам яму. ");
INSERT INTO beln_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Дух чалавека пераносіць немач сваю, але дух маркотны хто можа ўзьняць. ");
INSERT INTO beln_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Сэрца разважнае набывае веды, і вуха мудрых шукае веданьня. ");
INSERT INTO beln_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Падарунак чалавека дае яму прастору і да вялікіх прывядзе яго. ");
INSERT INTO beln_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Першы ў спрэчцы сваёй падаецца справядлівым, але прыйдзе бліжні ягоны і выспрабуе яго. ");
INSERT INTO beln_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Жэрабя спыняе сваркі і дзеліць між магутнымі. ");
INSERT INTO beln_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Пакрыўджаны брат — як умацаваны горад, а сваркі — як завалы ў замку. ");
INSERT INTO beln_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","З плоду вуснаў сваіх насыціць чалавек нутро сваё, з прыбыткаў губаў сваіх насыціцца. ");
INSERT INTO beln_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Сьмерць і жыцьцё ў руцэ языка; хто любіць яго, будзе есьці плады ягоныя. ");
INSERT INTO beln_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Хто знайшоў жонку, той знайшоў добрае і атрымаў ласку ад ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Бедны гаворыць, умольваючы, а багаты адказвае груба. ");
INSERT INTO beln_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Чалавек, які мае сяброў, сам павінен быць сяброўскі, і бывае, што сябар больш любіць, чым брат. ");
INSERT INTO beln_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Лепш бедны, які ходзіць у беззаганнасьці сваёй, чым крывадушны вуснамі сваімі, і да таго ж дурны. ");
INSERT INTO beln_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Таксама нядобра душы бяз ведаў, і хто сьпяшаецца нагамі сваімі, згрэшыць. ");
INSERT INTO beln_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Неразумнасьць чалавека кры?віць шлях ягоны, але сэрца ягонае гневаецца на ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Маёмасьць дадае шматлікіх сяброў, а ўбогага пакідае бліжні ягоны. ");
INSERT INTO beln_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Сьведка фальшывы не пазьбегне пакараньня, і хто дыхае няпраўдай, не ўратуецца. ");
INSERT INTO beln_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Шмат хто паніжаецца перад магнатам, і кожны — бліжні чалавеку, які дае падарункі. ");
INSERT INTO beln_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Усе браты беднага ненавідзяць яго, тым больш сябры ягоныя аддаляюцца ад яго; той бяжыць, каб паразмаўляць, але іх няма. ");
INSERT INTO beln_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Хто набывае розум, той любіць душу сваю, хто шукае разважлівасьці — знаходзіць дабро. ");
INSERT INTO beln_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Сьведка фальшывы не пазьбегне пакараньня, і хто дыхае няпраўдай, загіне. ");
INSERT INTO beln_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Не пасуе дурню раскоша, тым больш слузе мець уладу над князямі. ");
INSERT INTO beln_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Розум чалавека стрымлівае гнеў ягоны, і слава яго — у прабачэньні правінаў. ");
INSERT INTO beln_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Гнеў валадара — як ры?каньне ільва, а зычлівасьць ягоная — як раса на траве. ");
INSERT INTO beln_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Неразумны сын — загуба для бацькі, а сварлівая жонка — як няспыннае капаньне праз дах. ");
INSERT INTO beln_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Дом і маёмасьць — спадчына ад бацькоў, але разумная жонка — ад ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Лянота кідае ў сон, і нядбайная душа будзе цярпець голад. ");
INSERT INTO beln_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Хто захоўвае прыказаньні — захоўвае душу сваю, хто не шануе шлях Яго — памрэ. ");
INSERT INTO beln_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Хто літуецца над убогім, той пазычае ГОСПАДУ, за дабрадзейства Ён аднагародзіць яму. ");
INSERT INTO beln_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Карай сына свайго, пакуль ёсьць надзея, і няхай не спрычы?ніцца да загубы яго душа твая. ");
INSERT INTO beln_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Зласьлівы няхай атрымае пакараньне, бо калі пашкадуеш яго, яшчэ больш павялічыш кару. ");
INSERT INTO beln_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Слухай парады і прыймай настаўленьне, каб стаўся ты мудрым пры канцы дзён. ");
INSERT INTO beln_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Шмат думак у сэрцы чалавека, але збудзецца намер ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Пажаданая для чалавека міласэрнасьць ягоная, і бедны лепшы за чалавека хлусьлівага. ");
INSERT INTO beln_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Страх перад ГОСПАДАМ вядзе да жыцьця, і такі чалавек будзе жыць, і насыціцца, і зло не наведае яго. ");
INSERT INTO beln_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Гультай хавае руку сваю ў місе, але нават да вуснаў сваіх не падымае яе. ");
INSERT INTO beln_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Бі насьмешніка, і неразумны паразумнее, дакарай разумнага, і ён здабудзе веданьне. ");
INSERT INTO beln_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Руйнуе бацьку, выганяе маці сын, які прыносіць сорам і ганьбу. ");
INSERT INTO beln_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Перастань, сыне мой, слухаць настаўленьні, якія адводзяць ад словаў веданьня. ");
INSERT INTO beln_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Сьведка нягодны насьміхаецца над судом, і вусны бязбожнікаў глытаюць злачынства. ");
INSERT INTO beln_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Падрыхтаваныя прысуды для насьмешнікаў, а хвастаньне — на плечы дурняў. ");
INSERT INTO beln_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Віно зьдзеклівае, сікера галасьлівая, і кожны, хто блукае з імі, ня мае мудрасьці. ");
INSERT INTO beln_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Ярасьць валадара — як рыканьне ільва, хто выклікае яе, грашыць супраць душы сваёй. ");
INSERT INTO beln_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Слава для чалавека — пакінуць спрэчку, а ўсе неразумныя задзірлівыя. ");
INSERT INTO beln_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Дзеля холаду гультай ня хоча араць, таму будзе прасіць у час жніва, і не атрымае нічога. ");
INSERT INTO beln_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Намеры ў сэрцы чалавека — глыбокія воды, але разумны чалавек вычэрпвае іх. ");
INSERT INTO beln_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Багата людзей абвяшчае пра міласэрнасьць сваю, але праўдамоўнага чалавека хто можа знайсьці? ");
INSERT INTO beln_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Праведнік ходзіць у беззаганнасьці сваёй, шчасьлівыя сыны ягоныя пасьля яго. ");
INSERT INTO beln_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Валадар, які сядзіць на судовым пасадзе, расьцярушвае вачыма сваімі ўсякую ліхоту. ");
INSERT INTO beln_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Хто можа сказаць: «Я ачысьціў сэрца маё, я чысты ад грэху майго»? ");
INSERT INTO beln_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Неаднолькавыя вагі і неаднолькавая эфа, адно і другое — агіда для ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Нават у юнака па паводзінах можна зразумець, ці чыстыя, ці правыя справы ягоныя. ");
INSERT INTO beln_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Вуха, якое чуе, і вока, якое бачыць, — ГОСПАД зрабіў і адно, і другое. ");
INSERT INTO beln_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Не любі спаць, каб табе не зьбяднець, адкрый вочы свае, і насыцішся хлебам. ");
INSERT INTO beln_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","«Дрэннае, дрэннае», — кажа пакупнік, а калі адыдзецца, тады хваліцца. ");
INSERT INTO beln_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Ёсьць золата і мноства пэрлінаў, але найкаштоўнейшая рэч — вусны разумныя. ");
INSERT INTO beln_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Забяры адзеньне яго, бо ён паручы?ўся за чужога, і за чужынца вазьмі заклад ад яго. ");
INSERT INTO beln_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Салодкі чалавеку хлеб ашуканства, але потым пяском напоўняцца вусны ягоныя. ");
INSERT INTO beln_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Думкі ўмацоўваюцца парадамі, і з разважлівасьцю вядзі вайну. ");
INSERT INTO beln_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Хто ходзіць абмоўнікам, той выяўляе таямніцы, дык ня зьвязвайся з тым, хто рот свой разьзяўляе. ");
INSERT INTO beln_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Хто кляне бацьку свайго і маці сваю, у таго сьветач патухне сярод глыбокай цемры. ");
INSERT INTO beln_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Спадчына, спачатку пасьпешліва здабытая, ня будзе пры канцы дабраслаўлёная. ");
INSERT INTO beln_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Не кажы: «Я адплачу за зло», спадзявайся на ГОСПАДА, і Ён вы?бавіць цябе. ");
INSERT INTO beln_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Агіда для ГОСПАДА — неаднолькавыя вагі, і шалі падманлівыя — ня добра. ");
INSERT INTO beln_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Ад ГОСПАДА крокі чалавека, і як жа чалавеку зразумець шлях свой? ");
INSERT INTO beln_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Пастка для чалавека — пасьпешліва зрабіць шлюбаваньне, а пасьля абяцаньня разважаць. ");
INSERT INTO beln_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Мудры валадар расьцярушыць бязбожнікаў і зьверне на іх кола малатарнае. ");
INSERT INTO beln_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Сьветач ГОСПАДАЎ — дух чалавечы, ён дасьледуе ўсе сховы нутра. ");
INSERT INTO beln_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Міласэрнасьць і праўда ахоўваюць валадара, і міласэрнасьцю ўмацоўваецца пасад ягоны. ");
INSERT INTO beln_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Слава юнакоў — сіла іхняя, а веліч старых — сівізна. ");
INSERT INTO beln_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Вы?тні і раны — лекавальная масьць ад ліхоты, і ўдары ў глыбіню нутра. ");
INSERT INTO beln_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Сэрца валадара ў руцэ ГОСПАДА, як ручаі водаў, Ён скіроўвае яго, куды хоча. ");
INSERT INTO beln_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Усе шляхі чалавека слушныя ў вачах ягоных, але ГОСПАД узважвае сэрцы. ");
INSERT INTO beln_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Праведнасьць і суд даспадобы ГОСПАДУ больш, чым ахвяра. ");
INSERT INTO beln_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Узьнесеныя вочы і надзьмутае сэрца — баразна бязбожных, і гэта грэх. ");
INSERT INTO beln_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Думкі руплівага прыносяць прыбытак, а кожнага нецярплівага — нястачу. ");
INSERT INTO beln_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Зьбіраньне скарбаў языком падманлівым — пара, што зьнікае, шуканьне сьмерці. ");
INSERT INTO beln_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Злачыннасьць бязбожнікаў зьвернецца на іх, бо яны грэбуюць чыніць суд справядлівы. ");
INSERT INTO beln_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Крывы шлях чалавека нягоднага, а справы чыстага — простыя. ");
INSERT INTO beln_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Лепей жыць у куце на даху, чым са сварліваю жонкаю ў прасторным доме. ");
INSERT INTO beln_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Душа бязбожніка жадае зла, ня знойдзе ласкі ў вачах ягоных бліжні яго. ");
INSERT INTO beln_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Калі караюць насьмешніка, неразумны стаецца мудрэйшым, і калі мудрага вучаць, ён здабывае веданьне. ");
INSERT INTO beln_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Разважае праведнік пра дом бязбожніка, як гінуць бязбожнікі ў ліхоцьці сваім. ");
INSERT INTO beln_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Хто вушы свае затыкае на крык убогага, той сам будзе клікаць, але ня будзе адказу. ");
INSERT INTO beln_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Падарунак таемны тушыць гнеў, а гасьцінец у заўлоньне — вялікую ярасьць. ");
INSERT INTO beln_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Правасудзьдзе — радасьць для праведніка і загуба для злачынцаў. ");
INSERT INTO beln_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Чалавек, што зьбіваецца са шляху розуму, супачы?не ў грамадзе памёршых. ");
INSERT INTO beln_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Хто любіць весяліцца, будзе ў нястачы, а хто любіць віно і алей, ня будзе багатым. ");
INSERT INTO beln_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Вы?купам за праведніка будзе бязбожнік, а за правага — ліхадзей. ");
INSERT INTO beln_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Лепш жыць у зямлі пустыннай, чым з жонкай гняўлівай і сварлівай. ");
INSERT INTO beln_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Прывабныя скарбы і алей у жытле мудрага, а бязглузды чалавек змарнуе іх. ");
INSERT INTO beln_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Хто імкнецца да праведнасьці і міласэрнасьці, знойдзе жыцьцё, праведнасьць і славу. ");
INSERT INTO beln_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Мудры ўвойдзе ў горад магутных і зрыне моц, у якой яны мелі пэўнасьць. ");
INSERT INTO beln_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Хто захоўвае вусны свае і язык свой, захоўвае душу сваю ад бедаў. ");
INSERT INTO beln_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Пыхлівы і дзёрзкі, называны блюзьнерам, робіць усё ў шале нахабства. ");
INSERT INTO beln_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Жаданьне гультая заб’е яго, бо рукі ягоныя адмаўляюцца працаваць. ");
INSERT INTO beln_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Кожны дзень ён жадае і прагне, а праведнік дае і не шкадуе. ");
INSERT INTO beln_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Ахвяра бязбожнікаў — брыдота, тым больш тыя, якія складаюць яе з падступнасьцю. ");
INSERT INTO beln_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Сьведка хлусьлівы згіне, а чалавек, які слухае, будзе гаварыць заўсёды. ");
INSERT INTO beln_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Чалавек бязбожны ўпарты абліччам сваім, а правы разумее шлях свой. ");
INSERT INTO beln_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Няма мудрасьці, і няма розуму, і няма рады насуперак ГОСПАДУ. ");
INSERT INTO beln_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Каня рыхтуюць на дзень бітвы, але перамога — ад ГОСПАДА. ");
INSERT INTO beln_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Лепш добрае імя, чым вялікія багацьці, лепш добрая слава, чым срэбра і золата. ");
INSERT INTO beln_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Багаты і бедны сустракаюцца, Творца іх усіх — ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Разумны бачыць зло і хаваецца, а неразумныя ідуць і будуць пакараныя. ");
INSERT INTO beln_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Нагарода за пакору і страх перад ГОСПАДАМ — багацьце, і слава, і жыцьцё. ");
INSERT INTO beln_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Церні і пасткі на шляху крывадушнага, а хто захоўвае душу сваю, той аддаляецца ад іх. ");
INSERT INTO beln_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Пастаў юнака на слушны шлях, і ён ня збочыць з яго, нават калі састарэе. ");
INSERT INTO beln_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Багаты пануе над бедным, і чалавек, які ўзяў пазыку, — слуга паверніка. ");
INSERT INTO beln_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Хто сее беззаконьне, той будзе жаць ліха, і кій гневу ягонага будзе зьнішчаны. ");
INSERT INTO beln_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Хто мае добрае вока, той будзе дабраслаўлёны, бо з хлеба свайго дае ўбогаму. ");
INSERT INTO beln_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Выгані насьмешніка, і адыйдзе звадка, і суцішацца спрэчкі і абразы. ");
INSERT INTO beln_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Хто любіць чыстасьць сэрца, у таго ласка на вуснах яго, і валадар з ім сябруе. ");
INSERT INTO beln_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Вочы ГОСПАДА захоўваюць веданьне, Ён касуе словы ліхадзея. ");
INSERT INTO beln_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Гультай кажа: «Леў на двары, пасярод плошчы буду забіты». ");
INSERT INTO beln_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Вусны чужаніцы — глыбокая яма, на каго загневаўся ГОСПАД, той уваліцца туды. ");
INSERT INTO beln_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Дурасьць прывязаная да сэрца юнака, але дубец настаўленьня выганіць яе. ");
INSERT INTO beln_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Хто ўціскае ўбогага, каб памножыць сваё, і дае багатаму, той згалее. ");
INSERT INTO beln_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Прыхілі вуха тваё, і слухай словы мудрых, і сэрца тваё зьвярні да ведаў маіх, ");
INSERT INTO beln_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","бо цудоўна будзе, калі захаваеш іх у нутры тваім, і будуць яны таксама на вуснах тваіх, ");
INSERT INTO beln_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","каб пэўнасьць твая была ў ГОСПАДЗЕ, я вучу цябе сёньня. ");
INSERT INTO beln_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Ці ж не пісаў я табе тройчы парады і навучаньні, ");
INSERT INTO beln_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","каб паведаміць табе дакладныя словы праўды, каб ты мог перадаць словы праўды тым, што паслалі цябе? ");
INSERT INTO beln_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Не абдзірай убогага, таму што ён убогі, і не ўціскай прыгнечанага каля брамы, ");
INSERT INTO beln_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","бо ГОСПАД будзе бараніць у справе іхняй і адбярэ душу ў тых, што іх абіраюць. ");
INSERT INTO beln_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Не сябруй з васпанам гняўлівым і з чалавекам нястрыманым не хадзі, ");
INSERT INTO beln_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","каб ты не навучыўся сьцежкам яго і не нацягнуў пятлі на душу тваю. ");
INSERT INTO beln_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Ня будзь з тых, што даюць руку, што заручаюцца за даўгі. ");
INSERT INTO beln_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","Калі ня маеш, чым заплаціць, навошта маюць забраць з-пад цябе ложак твой? ");
INSERT INTO beln_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Не перасоўвай мяжы старадаўняй, якую вызначылі бацькі твае. ");
INSERT INTO beln_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Ці бачыў ты чалавека, спраўнага ў занятку сваім? Перад абліччам валадароў ён будзе стаяць, ня будзе ён стаяць перад прасьцякамі. ");
INSERT INTO beln_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Калі сядзеш есьці з вялікім панам, пільна зважай, што перад табою, ");
INSERT INTO beln_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","і прыстаў нож да горла твайго, калі прагавітая душа твая. ");
INSERT INTO beln_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Ня квапся на прысмакі ягоныя, бо гэта падманлівы хлеб. ");
INSERT INTO beln_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Не намагайся мець багацьце, пакінь разважаньні свае. ");
INSERT INTO beln_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Зьвернеш вочы твае на яго, а яго няма, бо справіць яно крылы сабе і паляціць, як арол, аж у неба. ");
INSERT INTO beln_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Ня еш хлеб з зайздросным і ня квапся на яго прысмакі, ");
INSERT INTO beln_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","бо якія думкі ў сэрцы ягоным, такі і ён. «Еш і пі», — кажа ён табе, але сэрца яго не з табою. ");
INSERT INTO beln_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Кавалак, які ты зьеў, званітуеш, дарэмныя будуць салодкія словы твае. ");
INSERT INTO beln_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Не гавары ў вушы дурня, бо ён узгардзіць разумнымі мовамі тваімі. ");
INSERT INTO beln_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Не перасоўвай мяжы старадаўняй і на поле сіротаў не ўваходзь, ");
INSERT INTO beln_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","бо дужы Абаронца іхні, і Ён будзе бараніць іх у справе іхняй з табою. ");
INSERT INTO beln_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Зьвярні сэрца тваё да настаўленьня, і вушы твае — да словаў веданьня. ");
INSERT INTO beln_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Не пакідай юнака без настаўленьня, бо калі пакараеш яго дубцом, ён не памрэ. ");
INSERT INTO beln_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Ты пакараеш яго дубцом і выратуеш душу ягоную ад пекла. ");
INSERT INTO beln_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Сыне мой, калі мудрым будзе сэрца тваё, будзе радавацца з табою і маё сэрца. ");
INSERT INTO beln_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","І будуць цешыцца ныркі мае, калі на вуснах тваіх будуць словы правасьці. ");
INSERT INTO beln_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Няхай сэрца тваё не зайздросьціць грэшнікам, але кожны дзень няхай будзе яно ў страху ГОСПАДАВЫМ, ");
INSERT INTO beln_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","бо ёсьць будучыня, і надзея твая не загіне. ");
INSERT INTO beln_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Слухай, сыне мой, і будзь мудры, і скіроўвай сэрца тваё на шлях просты. ");
INSERT INTO beln_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Ня будзь сярод тых, што напіваюцца віна, сярод тых, што аб’ядаюцца мясам, ");
INSERT INTO beln_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","бо п’яніца і абжора зьбяднеюць, і заспанасьць апране ў лахманы. ");
INSERT INTO beln_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Слухай бацьку твайго, які нарадзіў цябе, і не цурайся маці тваёй, калі яна састарэе. ");
INSERT INTO beln_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Купляй праўду і не прадавай мудрасьці, настаўленьня і розуму. ");
INSERT INTO beln_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Цешыцца і весяліцца бацька праведнага, і той, хто нарадзіў мудрага, радуецца з яго. ");
INSERT INTO beln_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Няхай радуецца бацька твой, і тая, што нарадзіла цябе, няхай весяліцца. ");
INSERT INTO beln_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Сыне мой, дай мне сэрца тваё, і няхай вачам тваім будуць даспадобы шляхі мае. ");
INSERT INTO beln_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Бо распусьніца — яма глыбокая, і чужая жонка — цесны калодзеж. ");
INSERT INTO beln_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Яна цікуе, быццам забойца, і памнажае ліхадзеяў паміж людзьмі. ");
INSERT INTO beln_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","У каго стогн? У каго гора? У каго сваркі? У каго смутак? У каго раны без прычыны? У каго чырвоныя вочы? ");
INSERT INTO beln_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","У тых, якія доўга сядзяць пры віне, у тых, якія прыходзяць спрабаваць віна мяшанага. ");
INSERT INTO beln_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Не глядзі на віно, як яно чырванее, як прамяніцца ў келіху, як роўненька ліецца, ");
INSERT INTO beln_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","у рэшце яно ўкусіць, як зьмяя, і ўджаліць, як гадзіна. ");
INSERT INTO beln_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Вочы твае будуць глядзець на чужых жонак, і сэрца тваё загаворыць падступна. ");
INSERT INTO beln_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","І будзеш ты як той, што ляжыць пасярод мора, і як той, што ляжыць на версе мачты. ");
INSERT INTO beln_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","І скажаш: «Білі мяне, а я не адчуваў, штурхалі мяне, а я ня ведаў. Калі прачнуся, зноў буду шукаць таго самага». ");
INSERT INTO beln_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Не зайздросьці людзям ліхім, не жадай быць з імі, ");
INSERT INTO beln_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","бо пра злачыннасьць думае сэрца іхняе, і пра ліхоту вусны іхнія гавораць. ");
INSERT INTO beln_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Мудрсьцю будуецца дом, і розумам умацоўваецца, ");
INSERT INTO beln_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","і праз веданьне напаўняюцца пакоі яго ўсялякай каштоўнай і прывабнай маёмасьцю. ");
INSERT INTO beln_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Мудры чалавек мае моц, і чалавек, які мае веды, умацоўвае сілу сваю. ");
INSERT INTO beln_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Таму з разважлівасьцю вядзі вайну тваю, і пры мностве дарадцаў — выратаваньне. ");
INSERT INTO beln_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Занадта высокая мудрасьць для неразумнага, ён не раскрывае ў брамах вуснаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Хто задумляе рабіць ліхое, таго называюць зламысным. ");
INSERT INTO beln_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Намеры бязглуздага — грэх, і намеры блюзьнера — агіда для чалавека. ");
INSERT INTO beln_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Калі ты слабы ў дзень бедства, дык малая сіла твая. ");
INSERT INTO beln_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Ратуй узятых на сьмерць, і ці ж не пашкадуеш тых, якія сказаныя на загубу? ");
INSERT INTO beln_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Калі скажаш: «Вось, мы ня ведалі гэтага?», ці ж Той, Хто дасьледуе сэрцы, не разумее? Ці ж Той, Хто захоўвае душу тваю, ня ведае? Ці ж Ён не аддасьць чалавеку паводле справаў ягоных? ");
INSERT INTO beln_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Еш мёд, сыне мой, бо ён добры, і соты салодкія для паднябеньня твайго. ");
INSERT INTO beln_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Гэтак сама веданьне мудрасьці для душы тваёй. Калі ты знайшоў яе, ёсьць будучыня, і надзея твая не загіне. ");
INSERT INTO beln_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Не цікуй, бязбожніку, каля жытла праведніка, не спусташай месца супачынку ягонага, ");
INSERT INTO beln_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","бо сем разоў упадзе праведнік і ўстане, а бязбожнікі трапяць у няшчасьце. ");
INSERT INTO beln_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Ня радуйся, калі ўпадзе вораг твой, і няхай ня цешыцца сэрца тваё, калі ён спатыкнецца, ");
INSERT INTO beln_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","бо часам убачыць ГОСПАД, і будзе гэта ліхім у вачах Ягоных, і Ён адверне гнеў Свой ад яго. ");
INSERT INTO beln_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Не абурайся на ліхотнікаў і не зайздросьці бязбожнікам, ");
INSERT INTO beln_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","бо ня будзе будучыні ліхому, і сьветач бязбожнікаў стухне. ");
INSERT INTO beln_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Бойся ГОСПАДА, сыне мой, і валадара, і ня зьвязвайся са змоўшчыкамі, ");
INSERT INTO beln_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","бо неспадзявана прыйдзе на іх загуба, і бедства ад іх абодвух хто можа ведаць. ");
INSERT INTO beln_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Гэта таксама для мудрых: нядобра зважаць на аблічча ў судзе. ");
INSERT INTO beln_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Таго, хто кажа бязбожніку: «Ты праведны», будуць праклінаць народы і будуць брыдзіцца ім людзі. ");
INSERT INTO beln_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","А тымі, што дакараюць, будуць захапляцца, і зыйдзе на іх шчодрае дабраславенства. ");
INSERT INTO beln_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","У вусны цалуе той, хто адказвае шчырымі словамі. ");
INSERT INTO beln_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Выканай працу тваю вонках дому і скончы яе на полі тваім, а пасьля пабудуй дом твой. ");
INSERT INTO beln_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Ня сьведчы без прычыны супраць бліжняга твайго, і не падманвай вуснамі тваімі. ");
INSERT INTO beln_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Не кажы: “Як ён мне зрабіў, так і я зраблю яму, аддам чалавеку паводле справаў яго”. ");
INSERT INTO beln_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Праходзіў я праз поле гультая і праз вінаграднік чалавека бяз розуму, ");
INSERT INTO beln_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","і вось, усё зарасло асотам, і крапіва пакрыла паверхню яго, і каменная агароджа зруйнаваная. ");
INSERT INTO beln_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","І паглядзеў я, і зьвярнуў на гэта сэрца маё, убачыў, і атрымаў настаўленьне: ");
INSERT INTO beln_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","«Крыху пасьпіш, крыху падрэміш, крыху, склаўшы рукі, паляжыш. ");
INSERT INTO beln_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","і прыйдзе, як валацуга, беднасьць твая, і нястача твая — як чалавек узброены». ");
INSERT INTO beln_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Гэта таксама прыповесьці Салямона, сабраныя людзьмі Эзэкіі, валадара Юды. ");
INSERT INTO beln_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Слава Божая — утоіць справу, а слава валадароў — дасьледаваць справу. ");
INSERT INTO beln_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Высокасьць неба, глыбокасьць зямлі і сэрца валадароў недасьледныя. ");
INSERT INTO beln_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Аддзялі жужаль ад срэбра, і выйдзе ў майстра начыньне. ");
INSERT INTO beln_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Прыбяры бязбожніка ад аблічча валадара, і пасад ягоны ўмацуецца праведнасьцю. ");
INSERT INTO beln_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Не ўзьвялічвай сябе перад абліччам валадара і на месцы вялікіх ня стой, ");
INSERT INTO beln_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","бо лепш, калі скажуць табе: “Узьніміся вышэй”, чым калі панізяць цябе перад абліччам магната, якога бачылі вочы твае. ");
INSERT INTO beln_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Не кідайся пасьпешліва судзіцца, бо што зробіш у канцы, калі асароміць цябе бліжні твой. ");
INSERT INTO beln_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Вядзі спрэчку з бліжнім тваім і не выяўляй таямніцу іншага, ");
INSERT INTO beln_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","каб той, хто пачуе, не ўпікнуў цябе, і каб не зьвярнулася супраць цябе гаворка твая. ");
INSERT INTO beln_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Як залатыя яблыкі са срэбнымі ўпрыгожваньнямі, так слова, сказанае дарэчы. ");
INSERT INTO beln_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Як залатыя завушніцы і аздоба са шчырага золата, так мудрае дакараньне для ўважлівага вуха. ");
INSERT INTO beln_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Як прахалода сьнегу ў дзень жніва, так верны пасланец для таго, хто паслаў яго, ён ажыўляе душу гаспадара свайго. ");
INSERT INTO beln_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Як хмары і вецер без дажджу, так чалавек, які хваліцца падарункам фальшывым. ");
INSERT INTO beln_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Цярплівасьцю пераканаеш начальніка, і лагодны язык ломіць костку. ");
INSERT INTO beln_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Як знайшоў мёд, еш, колькі трэба табе, каб ты не пераеў і не званітаваў. ");
INSERT INTO beln_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Стрымай нагу тваю ад дому бліжняга твайго, каб ты не надакучыў яму і каб ён не ўзьненавідзеў цябе. ");
INSERT INTO beln_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Як мачуга, меч і вострая страла, так чалавек, які кажа фальшывае сьведчаньне супраць бліжняга свайго. ");
INSERT INTO beln_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Як гнілы зуб і кульгавая нага, так надзея на ліхадзея ў дзень бедства. ");
INSERT INTO beln_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Як здымаць адзеньне ў халодны дзень, як ліць воцат на салетру, так сьпяваць песьні засмучанаму сэрцу. ");
INSERT INTO beln_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Калі ненавісьнік твой галодны, накармі яго хлебам, калі смагне, напаі яго вадою, ");
INSERT INTO beln_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","бо гэтым вугольле зьбіраеш на галаву ягоную, і ГОСПАД аднагародзіць табе. ");
INSERT INTO beln_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Паўночны вецер прыганяе дождж, а язык абмоўніка — гнеў на тварах. ");
INSERT INTO beln_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Лепей жыць у куце на даху, чым са сварліваю жонкаю ў прасторным доме. ");
INSERT INTO beln_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Як халодная вада для стомленай душы, так добрыя весткі з далёкага краю. ");
INSERT INTO beln_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Як скаламучанае жарало і зьнішчаная крыніца, так праведнік, які падае перад бязбожнікам. ");
INSERT INTO beln_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Як нядобра есьці шмат мёду, так дамагацца сваёй славы ня ёсьць слава. ");
INSERT INTO beln_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Як горад зруйнаваны і без муроў, так чалавек, які не валодае духам сваім. ");
INSERT INTO beln_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Як сьнег улетку, а дождж у жніво, так дурню не пасуе слава. ");
INSERT INTO beln_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Як птушка пераляціць і як ластаўка паляціць, так праклён беспрычынны ня збудзецца. ");
INSERT INTO beln_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Пуга — для каня, аброць — для асла, а кій — на сьпіну дурня. ");
INSERT INTO beln_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Не адказвай дурню паводле дурасьці ягонай, каб ня стаўся ты падобным да яго. ");
INSERT INTO beln_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Адказвай дурню паводле дурасьці ягонай, каб ня стаўся ён мудрым у вачах сваіх. ");
INSERT INTO beln_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Падцінае сабе ногі і п’е сваю шкоду той, хто праз рукі дурня слова пасылае. ");
INSERT INTO beln_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Няроўныя ногі кульгавага, таксама пры?казка ў вуснах дурня. ");
INSERT INTO beln_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Як прывязваць камень да вяроўкі, так аддаваць пашану дурню. ");
INSERT INTO beln_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Як калючка ў руцэ п’янага, так прыказка ў вуснах дурня. ");
INSERT INTO beln_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Вяльможны робіць усё: і дурня наймае, і мінака наймае. ");
INSERT INTO beln_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Як сабака вяртаецца да ванітаў сваіх, так дурань паўтарае дурасьць сваю. ");
INSERT INTO beln_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Ці бачыў ты чалавека, мудрага ў вачах сваіх? На дурня большая надзея, чым на такога. ");
INSERT INTO beln_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Гультай кажа: «Леў на шляху! Леў на плошчы!» ");
INSERT INTO beln_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Дзьверы варочаюцца на завесах сваіх, а гультай — на ложку сваім. ");
INSERT INTO beln_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Гультай хавае руку сваю ў місе, і яму цяжка падняць яе да вуснаў сваіх. ");
INSERT INTO beln_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Гультай мудрэйшы ў сваіх вачах за сямёх, што адказваюць з разуменьнем. ");
INSERT INTO beln_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Хапае сабаку за вушы той, хто мяшаецца ў чужую спрэчку. ");
INSERT INTO beln_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","Як вар’ят, які кідае агонь, стрэлы і сьмерць, ");
INSERT INTO beln_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","так чалавек, які падманвае бліжняга свайго і кажа: «Гэта я жартую». ");
INSERT INTO beln_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Калі няма дроваў, агонь гасьне, калі няма пляткара, звадка сьціхае. ");
INSERT INTO beln_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Вугаль — для жару, дровы — для агню, а чалавек сварлівы — для распальваньня спрэчкі. ");
INSERT INTO beln_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Словы пляткара — як прысмакі, яны зыходзяць у глыб нутра. ");
INSERT INTO beln_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Як гліна, паліваная срэбрам з жужалем, так гарачыя вусны і ліхое сэрца. ");
INSERT INTO beln_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Ненавісьнік прыкрываецца вуснамі сваімі, а ў нутры сваім рыхтуе ашуканства. ");
INSERT INTO beln_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Калі ён робіць лагодным голас свой, ня вер яму, бо сем брыдотаў у сэрцы ягоным. ");
INSERT INTO beln_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Чыя нянавісьць прыхоўваецца ашуканствам, таго ліхота выявіцца перад грамадою. ");
INSERT INTO beln_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Хто капае яму, той уваліцца ў яе, і хто пакоціць камень, на таго ён вернецца. ");
INSERT INTO beln_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Брахлівы язык ненавідзіць пакрыўджаных ім, і вусны лісьлівыя вядуць да загубы. ");
INSERT INTO beln_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Не хваліся заўтрашнім днём, бо ня ведаеш, што гэты дзень народзіць. ");
INSERT INTO beln_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Няхай іншы хваліць цябе, а ня вусны твае, нехта чужы, а ня губы твае. ");
INSERT INTO beln_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Камень цяжкі і пясок важкі, але гнеў неразумнага цяжэйшы за іх абодвух. ");
INSERT INTO beln_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Нястрымны гнеў і бязьлітасная ярасьць, але хто ўстаіць перад зайздрасьцю? ");
INSERT INTO beln_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Лепш адкрытае дакараньне, чым схаваная любоў. ");
INSERT INTO beln_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Раны ад таго, хто любіць, выказваюць вернасьць, але шматлікія пацалункі ненавісьніка. ");
INSERT INTO beln_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Душа насычаная топчацца па мёдзе, а душы галоднай усё горкае салодкае. ");
INSERT INTO beln_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Як птушка, што пакінула гняздо сваё, так чалавек, які пакідае месца сваё. ");
INSERT INTO beln_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Алей і кадзіла радуюць сэрца, а салодкасьць бліжняга — у парадзе ад душы. ");
INSERT INTO beln_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Не пакідай бліжняга твайго і бліжняга бацькі твайго, і ў дом брата твайго не хадзі ў дзень няшчасьця твайго, бо лепш сусед блізка, чым брат далёка. ");
INSERT INTO beln_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Будзь мудры, сыне мой, і ўзрадуй сэрца маё, каб мог я адказаць таму, хто зьневажае мяне. ");
INSERT INTO beln_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Разумны бачыць зло і хаваецца, а неразумныя ідуць і будуць пакараныя. ");
INSERT INTO beln_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Забяры адзеньне яго, бо ён паручы?ўся за чужога, і за чужынца вазьмі заклад ад яго. ");
INSERT INTO beln_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Таму, хто рана раніцаю гучным голасам дабраслаўляе бліжняга свайго, палічаць гэта за праклён. ");
INSERT INTO beln_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Няспыннае капаньне праз дах у дажджлівы дзень і сварлівая жонка — аднолькавыя. ");
INSERT INTO beln_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Хто спрабуе схаваць яе, хавае вецер і пахкі алей у правай руцэ сваёй, які выдае сябе. ");
INSERT INTO beln_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Жалеза жалезам вострыцца, а чалавек вострыць аблічча бліжняга свайго. ");
INSERT INTO beln_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Хто даглядае дрэва фігавае, будзе есьці плады яго, а хто пільнуецца гаспадара свайго, будзе ў пашане. ");
INSERT INTO beln_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Як у вадзе аблічча да аблічча, так сэрца чалавека — да чалавека. ");
INSERT INTO beln_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Адхлань і пекла ненасытныя, і вочы чалавека ненасытныя. ");
INSERT INTO beln_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Літавальны гаршчок для срэбра і горан для золата, а для чалавека — вусны, якія хваляць яго. ");
INSERT INTO beln_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Хоць будзеш таўчы неразумнага таўкачом паміж зерня ў ступе, дурнота ягоная не адыйдзе ад яго. ");
INSERT INTO beln_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Ведай добра авечак тваіх, зьвяртай сваё сэрца да статкаў тваіх, ");
INSERT INTO beln_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","бо багацьце ня вечнае, і ці ж дыядэма перадаецца з пакаленьня ў пакаленьне? ");
INSERT INTO beln_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Вырастае трава, і зьяўляецца зеляніна, і зьбіраюць сена з гораў. ");
INSERT INTO beln_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Ягняты — на вопратку табе, і казлы — плата за поле. ");
INSERT INTO beln_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","І досыць казінага малака на ежу табе, і на ежу дому твайму, і на жыцьцё для служак тваіх. ");
INSERT INTO beln_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Бязбожнік бяжыць, хоць ніхто не перасьледуе яго, а праведнікі ўпэўненыя, як ільвы. ");
INSERT INTO beln_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Дзеля правінаў зямлі шмат у ёй начальнікаў, а праз чалавека, які ведае і разважае, яна даўгавечная. ");
INSERT INTO beln_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Чалавек бедны, які ўціскае ўбогіх, як залеўны дождж, што пакідае бяз хлеба. ");
INSERT INTO beln_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Хто адступаецца ад закону, той хваліць бязбожніка, а хто захоўвае закон, паўстае супраць яго. ");
INSERT INTO beln_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Ліхія людзі не разумеюць суду, а тыя, што шукаюць ГОСПАДА, разумеюць усё. ");
INSERT INTO beln_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Лепш бедны, які ходзіць у беззаганнасьці сваёй, чым той, які кры?віць шляхі свае, дарма што багаты. ");
INSERT INTO beln_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Сын разумны захоўвае закон, а той, хто сябруе з абжорамі, сароміць бацьку свайго. ");
INSERT INTO beln_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Хто памнажае маёмасьць сваю квотай і ліхвай, той зьбірае яе для таго, хто літуецца над убогім. ");
INSERT INTO beln_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Хто адварочвае вуха сваё, каб ня чуць закону, таго малітва — брыдота. ");
INSERT INTO beln_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Хто схіляе правых на шлях зла, сам уваліцца ў яму сваю, а беззаганныя атрымаюць у спадчыну добрае. ");
INSERT INTO beln_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Мудры ў вачах сваіх чалавек багаты, але ўбогі, які мае розум, выспрабуе яго. ");
INSERT INTO beln_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Калі праведнікі перамагаюць — вялікая слава, а калі ўздымаюцца бязбожнікі, чалавек хаваецца. ");
INSERT INTO beln_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Той, хто хавае свае правіны, ня будзе мець посьпеху, а хто прызнаецца і пакідае іх, дазнае міласэрнасьці. ");
INSERT INTO beln_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Шчасьлівы чалавек, які мае трымценьне заўсёды, а хто робіць цьвёрдым сэрца сваё, трапіць у бяду. ");
INSERT INTO beln_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Леў рыклівы і мядзьведзь бадзяжны — бязбожны пан над бедным народам. ");
INSERT INTO beln_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Правадыр, пазбаўлены розуму, робіць шмат крыўды, а хто ненавідзіць хцівасьць, прадоўжыць дні свае. ");
INSERT INTO beln_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Чалавек, абцяжараны крывёю душы другога, будзе бегаць да магілы, і ніхто не падтрымае яго. ");
INSERT INTO beln_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Хто ходзіць беззаганна, будзе ўратаваны, а крывадушны на шляхах сваіх упадзе на адным з іх. ");
INSERT INTO beln_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Хто абрабляе сваю зямлю, насыціцца хлебам, а хто гоніцца за марнасьцю, насыціцца беднасьцю. ");
INSERT INTO beln_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Чалавек верны багаты ў дабраславенствы, а хто сьпяшаецца ўзбагацець, не міне пакараньня. ");
INSERT INTO beln_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Нядобра зважаць на аблічча, бо дзеля кавалку хлеба чалавек робіць беззаконьне. ");
INSERT INTO beln_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Сьпяшаецца да багацьця чалавек ліхога вока і ня ведае, што нястача прыйдзе на яго. ");
INSERT INTO beln_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Той, хто дакарае чалавека, знойдзе пасьля большую ласку, чым той, хто языком лісьлівіць. ");
INSERT INTO beln_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Хто абкрадае бацьку свайго і маці сваю і кажа: «Няма тут віны», той супольнік нішчыцелю. ");
INSERT INTO beln_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Душа надзьмутая ўзьнімае звадку, а хто спадзяецца на ГОСПАДА, будзе насычаны. ");
INSERT INTO beln_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Хто спадзяецца на сэрца сваё, той дурань, а хто ходзіць у мудрасьці, будзе збаўлены. ");
INSERT INTO beln_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Хто дае бедным, ня будзе мець нястачы, а хто хавае вочы свае, мецьме шмат праклёнаў. ");
INSERT INTO beln_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Калі бязбожнікі ўздымаюцца, людзі хаваюцца, а калі яны гінуць, памнажаюцца праведнікі. ");
INSERT INTO beln_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Чалавек, які на дакараньне робіць цьвёрдым карак свой, раптоўна будзе зьнішчаны, і ня будзе аздараўленьня. ");
INSERT INTO beln_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Калі памнажаюцца праведнікі, радуецца народ, а калі пануе бязбожнік, народ стогне. ");
INSERT INTO beln_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Чалавек, які любіць мудрасьць, радуе бацьку свайго, а той, які сябруе з распусьніцамі, распускае маёмасьць. ");
INSERT INTO beln_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Валадар правасудзьдзем умацоўвае зямлю, а чалавек, які любіць дары, руйнуе яе. ");
INSERT INTO beln_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Чалавек, які лісьлівіць бліжняму свайму, стаўляе сетку нагам ягоным. ");
INSERT INTO beln_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","У злачынстве ліхога чалавека пастка для яго, а праведнік сьпявае і радуецца. ");
INSERT INTO beln_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Праведнік ведае справу ўбогіх, а бязбожнік і ня думае ведаць яе. ");
INSERT INTO beln_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Блюзьнеры ўзбураюць горад, а мудрыя ўтаймоўваюць гнеў. ");
INSERT INTO beln_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Мудры чалавек, судзячыся з неразумным, і злуецца, і сьмяецца, і ня мае спакою. ");
INSERT INTO beln_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Людзі крывавыя ненавідзяць беззаганнага, а правыя дбаюць пра душу ягоную. ");
INSERT INTO beln_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Дурань выяўляе ўвесь свой дух, а мудры затрымлівае яго на пазьней. ");
INSERT INTO beln_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Калі пан зважае на словы фальшывыя, тады бязбожныя ўсе, што служаць яму. ");
INSERT INTO beln_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Бядак і прыгнятальнік сустракаюцца, сьвятло вачам іх абодвух дае ГОСПАД. ");
INSERT INTO beln_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Валадар, які судзіць убогіх паводле праўды, умацуе свой пасад на вякі. ");
INSERT INTO beln_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Дубец і дакор даюць мудрасьць, а дзіцё, пакінутае само сабе, — сорам для маці яго. ");
INSERT INTO beln_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Калі памнажаюцца бязбожнікі, памнажаюцца злачынствы, але праведнікі ўбачаць падзеньне іх. ");
INSERT INTO beln_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Карай сына твайго, і ён дасьць табе супачыць, і дасьць асалоду для душы тваёй. ");
INSERT INTO beln_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Без прароцкага відзежу народ неакелзаны, а хто захоўвае закон, той шчасьлівы. ");
INSERT INTO beln_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Словамі ня будзе настаўлены слуга, бо хоць зразумее, але ня дасьць адказу. ");
INSERT INTO beln_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Ці бачыў ты чалавека, хуткага на словы? На дурня большая надзея, чым на такога. ");
INSERT INTO beln_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Калі з маленства песьціць слугу свайго, урэшце, той станецца гаспадаром. ");
INSERT INTO beln_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Гняўлівы чалавек усчынае звадку, а раз’юшаны ўчыняе багата правінаў. ");
INSERT INTO beln_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Пыха чалавека прыніжае яго, а пакорлівы духам здабудзе славу. ");
INSERT INTO beln_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Хто супольнічае са злодзеем, ненавідзіць душу сваю, ён чуе праклёны, але не выяўляе гэтага. ");
INSERT INTO beln_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Страх перад чалавекам стаўляе пастку, а хто спадзяецца на ГОСПАДА, будзе ў бясьпецы. ");
INSERT INTO beln_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Шмат хто шукае аблічча пана, але ГОСПАД судзіць чалавека. ");
INSERT INTO beln_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Агіда для праведнікаў — чалавек беззаконны, а для бязбожніка агідны той, што ідзе простым шляхам. ");
INSERT INTO beln_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Словы Агура, сына Якэ, выслоўі, якія сказаў чалавек гэты да Ітыэля, да Ітыэля і Укаля: ");
INSERT INTO beln_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Бо я найдурнейшы між людзей, і розуму чалавечага няма ў мяне, ");
INSERT INTO beln_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","не навучыўся я мудрасьці і ведаў сьвятых ня ведаю. ");
INSERT INTO beln_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Хто ўзыходзіў на неба і зыходзіў? Хто сабраў вецер у жменю сваю? Хто зьвязаў воды ў адзежу? Хто ўмацаваў усе канцы зямлі? Якое імя яго і якое імя сына ягонага, ці ведаеш ты? ");
INSERT INTO beln_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Усе словы Бога чыстыя ад дамешкаў, Ён — шчыт для тых, што маюць у Ім надзею. ");
INSERT INTO beln_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Не дадавай да словаў Ягоных, каб Ён ня выкрыў цябе і ня стаўся ты падманшчыкам. ");
INSERT INTO beln_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Дзьве рэчы прашу ў Цябе, не адмаўляй мне перш, чым памру: ");
INSERT INTO beln_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Марнасьць і слова хлусьлівае аддалі ад мяне, ані беднасьці, ані багацьця не давай мне, сыць мяне хлебам, вызначаным для мяне, ");
INSERT INTO beln_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","каб я, насыціўшыся, ня выракся Цябе і не сказаў: «Хто ГОСПАД?», або каб, зьбяднеўшы, ня стаў красьці і ганьбіць імя Бога майго. ");
INSERT INTO beln_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Не ачарняй слугі перад гаспадаром ягоным, каб ён не пракляў цябе і ты ня стаўся вінаватым. ");
INSERT INTO beln_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Ёсьць пакаленьне, якое праклінае бацьку свайго і не дабраслаўляе маці сваю, ");
INSERT INTO beln_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","пакаленьне, якое чыстае ў вачах сваіх, але не абмытае ад бруду свайго, ");
INSERT INTO beln_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","пакаленьне, у якога пыхлівыя вочы і павекі ўзьнятыя, ");
INSERT INTO beln_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","пакаленьне, у якога зубы — мячы, а сківіцы — нажы, каб есьці ўцісьнёных на зямлі і гаротных між людзей. ");
INSERT INTO beln_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","У п’яўкі дзьве дачкі: «давай» і «давай». Вось тры ненасытныя і чатыры, якія ня скажуць: «Досыць»: ");
INSERT INTO beln_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","адхлань і чэрава няплоднае, зямля, якая не насычаецца вадою, і агонь, які ня кажа: «Досыць». ");
INSERT INTO beln_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Вока, якое зьдзекуецца з бацькі і пагарджае паслухмянасьцю маці, выдзяўбаюць груганы над ракою і зьядуць арляняты. ");
INSERT INTO beln_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Вось тры рэчы, дзіўныя для мяне, і чатырох не разумею: ");
INSERT INTO beln_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","шляху арла ў небе, шляху зьмяі на скале, шляху карабля сярод мора і шляху мужчыны да дзяўчыны. ");
INSERT INTO beln_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Такі самы шлях жанчыны чужаложнай: зьела, абцёрла вусны свае і кажа: «Я не зрабіла благога». ");
INSERT INTO beln_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Дзеля трох трасецца зямля, і чатырох яна зьнесьці ня можа: ");
INSERT INTO beln_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","слугі, калі ён валадарыць, бязглуздага, калі ён насычаецца хлебам, ");
INSERT INTO beln_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","ганебнай жанчыны, калі яна замуж выходзіць, і нявольніцы, калі яна спадкуе па гаспадыні сваёй. ");
INSERT INTO beln_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Вось чатыры малыя на зямлі, але яны мудрэйшыя за мудрых: ");
INSERT INTO beln_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","мурашкі — народ ня моцны, але летам назапашваюць хлеб свой, ");
INSERT INTO beln_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","горныя мышы — народ не магутны, але стаўляюць дамы свае на скале, ");
INSERT INTO beln_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","няма валадара ў саранчы, але ўсе выходзяць шыхтавана, ");
INSERT INTO beln_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","павук лапкамі чапляецца, але вось, ён у палацы валадара. ");
INSERT INTO beln_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Вось трое крочаць паважна, і чацьвёра паважна ходзяць: ");
INSERT INTO beln_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","леў, магутнейшы між зьвярамі, ні перад кім не саступае, ");
INSERT INTO beln_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","конь асядланы, і казёл, і валадар, супраць якога ніхто не паўстане. ");
INSERT INTO beln_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","Калі вывышаешся бяздумна або калі задумаў ліхое, палажы руку сваю на вусны. ");
INSERT INTO beln_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Бо хто зьбівае малако, атрымае масла, і хто ўдарыць у нос, атрымае кроў, а хто выклікае гнеў, атрымае сварку. ");
INSERT INTO beln_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Словы Лемуэля, валадара, выслоўі, якім навучыла яго маці ягоная. ");
INSERT INTO beln_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Што, сыне мой? Што, сыне жывата майго? Што, сыне абяцаньняў маіх? ");
INSERT INTO beln_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Не давай жанчынам сілы тваёй, ані шляхоў тваіх нішчыцелькам валадароў. ");
INSERT INTO beln_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Не валадарам, Лемуэлю, не валадарам піць віно, і не князям — сікеру, ");
INSERT INTO beln_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","каб не напіліся і не забыліся яны на напісанае, і каб не скрывілі суд для ўсіх прыгнечаных. ");
INSERT INTO beln_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Дайце сікеру таму, хто гіне, а віно — засмучаным душою. ");
INSERT INTO beln_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Няхай вып’е такі і забудзецца на бядоту сваю, і ня памятае больш цяжару свайго. ");
INSERT INTO beln_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Адчыні вусны твае дзеля нямых, дзеля абароны ўсіх сіротаў. ");
INSERT INTO beln_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Адчыні вусны твае, судзі праведна, абараняй прыгнечанага і беднага. ");
INSERT INTO beln_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Хто знойдзе жонку дабрадзейную? Яна даражэй за пэрліны. ");
INSERT INTO beln_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Пэўнае ў ёй сэрца мужа яе, і ён не застанецца без прыбытку. ");
INSERT INTO beln_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Яна дае яму дабро, а ня зло, ва ўсе дні жыцьця свайго. ");
INSERT INTO beln_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Шукае яна воўну і лён, і ахвотна працуе рукамі сваімі. ");
INSERT INTO beln_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Яна падобная да караблёў купецкіх, здалёк прыносіць хлеб свой. ");
INSERT INTO beln_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","І ўстае яна сярод ночы, і раздае ежу ў доме сваім, і належнае служкам сваім. ");
INSERT INTO beln_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Падумае яна пра поле, і купляе яго, з плоду рук сваіх закладае вінаграднік. ");
INSERT INTO beln_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Яна падпярэзвае моцаю сьцёгны свае і ўмацоўвае рамёны свае. ");
INSERT INTO beln_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Яна адчувае, што добры занятак яе, і сьветач яе ня тухне і ўначы. ");
INSERT INTO beln_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Працягвае рукі свае да кудзелі, а далоні яе трымаюць верацяно. ");
INSERT INTO beln_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Далоні свае адкрывае прыгнечанаму, і руку сваю працягвае беднаму. ");
INSERT INTO beln_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Не баіцца сьцюжы для дому свайго, бо ўвесь дом яе ў кармазы?н апрануты. ");
INSERT INTO beln_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Дываны? яна робіць сабе, вісон і пурпур — адзеньне яе. ");
INSERT INTO beln_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","У брамах гораду вядомы муж ейны, калі сядзіць сярод старшыняў зямлі. ");
INSERT INTO beln_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Робіць яна палатніну, і продае яе, і дастаўляе паясы купцам Хананейскім. ");
INSERT INTO beln_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Сіла і велічнасьць — адзеньне яе, і радуецца яна дню, што прыходзіць. ");
INSERT INTO beln_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Яна адкрывае вусны свае з мудрасьцю, і міласэрнае настаўленьне на языку ў яе. ");
INSERT INTO beln_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Яна пільнуе шэсьце дому свайго і ня есьць хлеба гультайства. ");
INSERT INTO beln_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Устаюць дзеці ейныя, і называюць шчасьлівай яе, і муж ейны хваліць яе: ");
INSERT INTO beln_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","«Шмат было жанчынаў дабрадзейных, але ты пераўзыйшла іх усіх!» ");
INSERT INTO beln_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Прывабнасьць падманлівая і прыгажосьць марная, але жанчына, якая баіцца ГОСПАДА, годная пахвалы. ");
INSERT INTO beln_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Дайце ёй з пладоў рук ейных, і няхай справы яе ў брамах гораду хваляць яе.");
INSERT INTO beln_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1"," Слова Эклезiяста, сына Давiда, валадара ў Ерусалiме. ");
INSERT INTO beln_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Марнасьць марнасьцяў, сказаў Эклезiяст, марнасьць марнасьцяў, усё — марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Якая карысьць чалавеку з усёй цяжкай працы ягонай, якую ён робіць пад сонцам? ");
INSERT INTO beln_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Пакаленьне адыходзiць i пакаленьне прыходзiць, а зямля на вякі трывае. ");
INSERT INTO beln_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Узышло сонца, i зайшло сонца, i сьпяшаецца на месца сваё, дзе яно ўзыходзiць. ");
INSERT INTO beln_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Вецер ідзе на поўдзень i паварочвае на поўнач, кружляючы, кружляе, дзьме вецер і вяртаецца вецер на кружэньне сваё. ");
INSERT INTO beln_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Усе рэкi цякуць у мора, і мора не перапаўняецца; да месца, з якога рэкi цякуць, вяртаюцца яны, каб зноў адтуль выцякаць. ");
INSERT INTO beln_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Усе словы стамляюць, ня можа чалавек выказаць усяго. Не насыцiцца вока гляджэньнем, i не напоўнiцца вуха слуханьнем. ");
INSERT INTO beln_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Што было, тое i будзе, а што рабілася, тое i будзе рабіцца, i няма нiчога новага пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Бывае рэч, пра якую кажуць: “Глядзi, вось гэта новае”, але гэта было ўжо ў вяках, што былі перад намi. ");
INSERT INTO beln_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Няма памяцi пра тых, што раней жылi, і таксама пра тых, што потым жыць будуць, ня будзе памяці ў тых, якія будуць пасьля іх. ");
INSERT INTO beln_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Я, Эклезiяст, быў валадаром Iзраіля ў Ерусаліме. ");
INSERT INTO beln_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","І аддаў я сэрца маё, каб шукаць i дасьледаваць з мудрасьцю ўсё, што дзеецца пад небам. Гэты кепскі занятак даў Бог сынам чалавечым, каб былі занятыя iм. ");
INSERT INTO beln_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Глядзеў я на ўсе справы, якія робяцца пад сонцам; i вось, ўсё — марнасьць i пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Крывое ня можна зрабіць простым, і тое, чаго няма, нельга палiчыць. ");
INSERT INTO beln_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Сказаў я ў сэрцы маiм, кажучы: “Вось, я ўзьвялічыўся i прыдбаў мудрасьцi больш за ўсiх, што былі раней за мяне ў Ерусалiме; і сэрца маё ўбачыла шмат мудрасьцi i веданьня”. ");
INSERT INTO beln_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","І аддаў я сэрца маё, каб пазнаць мудрасьць і пазнаць шаленства i глупоту; і спазнаў, што і гэта — турбаваньне духа. ");
INSERT INTO beln_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Бо з вялiкай мудрасьцi шмат смутку, і хто павялiчвае веданьне, павялiчвае боль. ");
INSERT INTO beln_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Сказаў я ў сэрцы маiм: “Вось жа цяпер паспрабую радасьцi i пагляджу на тое, што добрае”, але гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Пра сьмех сказаў я: “Шаленства!”, i пра радасьць: “Што яна зробіць?” ");
INSERT INTO beln_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Вырашыў я ў сэрцы маiм дазволіць целу майму вiно, але каб сэрца маё кiравалася мудрасьцю, i трымацца глупоты, аж пакуль ня ўбачу, што добра для сыноў чалавечых, каб рабiць пад сонцам у палічаных днях жыцьця свайго. ");
INSERT INTO beln_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Я павялічыў справы свае: пабудаваў сабе дамы i пасадзiў для сябе вiнаграднiкi, ");
INSERT INTO beln_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","залажыў для сябе сады і гаі, i пасадзіў у iх усялякiх дрэваў пладовых, ");
INSERT INTO beln_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","і зрабiў сабе сажалкі з вадою, каб абвадняць лес, у якім растуць дрэвы. ");
INSERT INTO beln_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Я набыў нявольнiкаў i нявольнiц, i чэлядзь была ў мяне, таксама статкі валоў і чароды авечак былі ў мяне большыя, чым у-ва ўсіх, што былi раней за мяне ў Ерусаліме. ");
INSERT INTO beln_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Я назьбiраў сабе таксама срэбра i золата, i каштоўнасьці валадароў i акругаў; завёў сьпевакоў i сьпявачак, і асалоду сыноў чалавечых, мноства наложніцаў. ");
INSERT INTO beln_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","I зрабiўся я вялiкшым і заможнейшым за ўсiх, якія былi раней за мяне ў Ерусалiме; а мудрасьць мая была са мною. ");
INSERT INTO beln_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","І ўсё, чаго жадалi вочы мае, я не адмаўляў iм, i не забараняў сэрцу свайму нiякай радасьці, бо сэрца маё радавалася з усёй цяжкай працы маёй, i гэта была доля мая ў-ва ўсёй цяжкай працы маёй. ");
INSERT INTO beln_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","І азірнуўся я на ўсе справы сваiе, якiя зрабiлi рукi мае, і на цяжкую працу маю, якую рабіў, працуючы, i вось, усё — марнасьць i пагоня за ветрам, і няма карысьцi з гэтага пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","І азірнуўся я, каб паглядзець на мудрасьць, i шаленства, i глупоту, бо што можа зрабiць чалавек, які прыйдзе пасьля валадара, звыш таго, што раней рабілася. ");
INSERT INTO beln_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","I ўбачыў я, што з мудрасьці большая карысьць, чым з глупоты, падобна як карысьць са сьвятла большая, чым з цемры. ");
INSERT INTO beln_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Мудры мае вочы свае ў галаве сваёй, а дурань ходзiць у цемры. І пазнаў я таксама, што тая самая доля спаткае іх усіх. ");
INSERT INTO beln_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","І сказаў я ў сэрцы маім: “Калi адна доля будзе для мяне i для дурня, навошта мне вялікая мудрасьць?” І сказаў я ў сэрцы маім: “Гэта таксама марнасьць”. ");
INSERT INTO beln_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Бо ня будзе на вякі памяцi пра мудрага, як i пра дурня. Тое, што цяпер ёсьць, у дні наступныя ўсё забудзецца, і мудры памірае гэтак сама, як і дурань. ");
INSERT INTO beln_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","І зьненавідзеў я жыцьцё, бо ліхімі былі для мяне справы, што робяцца пад сонцам; бо ўсё — марнасьць i пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","І зьненавідзеў я ўсю цяжкую працу маю, якой працаваў пад сонцам, якую мушу пакiнуць чалавеку, які будзе пасьля мяне. ");
INSERT INTO beln_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","І хто ведае, цi мудрым ён будзе, цi неразумным? А ён будзе панаваць над пладамі усёй цяжкай працы маёй, дзеля якіх я працаваў i якія мудрасьцю зьбіраў пад сонцам. І гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","І павярнуўся я, каб адцурацца сэрцу майму ад усёй цяжкай працы, якой я працаваў пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Бо ёсьць так, што чалавек, які працуе з мудрасьцю, і з веданьнем, i пасьпяхова, аддае набытак свой чалавеку, які не працаваў над гэтым. І гэта таксама марнасьць i вялiкае зло. ");
INSERT INTO beln_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Бо што будзе мець чалавек з усёй цяжкай працы сваёй i турбаваньняў сэрца свайго, якiмі ён спрацаваны пад сонцам? ");
INSERT INTO beln_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Бо ўсе днi ягоныя — боль, і занятак ягоны — смутак, нават уначы не адпачывае сэрца ягонае. І гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Няма нiчога лепшага чалавеку, як есьцi i пiць, i даваць душы сваёй карыстацца дабром цяжкай працы сваёй. Таксама ўбачыў я, што гэта з рукi Божай паходзiць. ");
INSERT INTO beln_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Бо хто еў і хто пасьпяшаўся мець усё так, як я? ");
INSERT INTO beln_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Бо чалавеку, які добры перад абліччам Ягоным, Ён дае мудрасьць, i веданьне, i радасьць, а грэшнiку дае занятак, каб зьбiраў, i назапашваў, і потым аддаў таму, хто добры перад абліччам Божым. І гэта таксама марнасьць і пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Для ўсяго ёсьць свой тэрмін, i час для кожнай рэчы пад небам; ");
INSERT INTO beln_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Час нараджацца i час памiраць, час садзiць i час вырываць тое, што пасаджана. ");
INSERT INTO beln_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Час забiваць i час лекаваць, час разбураць i час будаваць. ");
INSERT INTO beln_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Час плакаць i час сьмяяцца, час галасiць i час танчыць. ");
INSERT INTO beln_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Час кiдаць камянi i час зьбiраць камяні, час абдымаць i час пазьбягаць абдымкаў. ");
INSERT INTO beln_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Час шукаць i час губляць, час захоўваць i час пакiдаць. ");
INSERT INTO beln_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Час разьдзiраць i час сшываць, час маўчаць i час гаварыць. ");
INSERT INTO beln_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Час любiць i час ненавiдзець, час вайны i час мiру. ");
INSERT INTO beln_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","Што за карысьць мае з працы сваёй той, хто працуе? ");
INSERT INTO beln_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","І я ўбачыў занятак, які даў Бог сынам чалавечым, каб яны займалiся ім. ");
INSERT INTO beln_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Усё Ён зрабiў прыгожым у свой час; і даў iм вечнасьць у сэрца, аднак чалавек не спасьцігне справаў, якiя робіць Бог, ад пачатку аж да канца. ");
INSERT INTO beln_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","І даведаўся я, што няма для іх нiчога лепшага, як весяліцца i рабіць добрае ў жыцьці сваім. ");
INSERT INTO beln_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","І тое, што кожны чалавек есьць i п’е, i бачыць добрае з усёй цяжкай працы сваёй, — гэта дар Божы. ");
INSERT INTO beln_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","І даведаўся я, што ўсё, што робiць Бог, трывае на вякі; нельга да таго дадаць і нельга ад таго адняць, і Бог робіць так, каб баяліся аблічча Яго. ");
INSERT INTO beln_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","Тое, што было, цяпер ёсьць, і тое, што мае быць, ужо было, і Бог знаходзіць тое, што прамiнула. ");
INSERT INTO beln_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","І яшчэ бачыў я пад сонцам: месца суду, а там беззаконьне, месца праведнасьці, а там няправасьць. ");
INSERT INTO beln_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","Сказаў я ў сэрцы маiм: “Праведніка і бязбожніка будзе судзiць Бог, бо там ёсьць час на кожную рэч i на кожную справу”. ");
INSERT INTO beln_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","Сказаў я ў сэрцы маiм пра сыноў чалавечых, што Бог ачышчае іх i паказвае, што яны самi па сабе — як тая жывёла. ");
INSERT INTO beln_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","Бо доля сыноў чалавечых і доля жывёлы — аднолькавая доля, як тыя паміраюць, так і гэтыя паміраюць, і дух жыцьця аднолькавы для ўсіх, і няма ў чалавека перавагі над жывёлаю, бо ўсё — марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","Усё iдзе ў адно месца, усё з пылу паўстала, і ўсё ў пыл вяртаецца. ");
INSERT INTO beln_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","Хто ведае, цi дух сыноў чалавечых узыходзіць угору, цi дух жывёлы зыходзiць унiз, у зямлю? ");
INSERT INTO beln_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","I ўбачыў я, што нiчога няма лепшага для чалавека, як радавацца са справаў сваіх, бо гэта доля ягоная. Бо хто прывядзе яго паглядзець на тое, што будзе пасьля яго? ");
INSERT INTO beln_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","І я павярнуўся, i ўбачыў усякі прыгнёт, якi робіцца пад сонцам, i вось, слёзы прыгнечаных, і няма для іх суцяшэньня; і ў руцэ прыгнятальнiкаў — сіла, і няма для іх суцяшэньня. ");
INSERT INTO beln_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","І я больш пахвалiў памёршых, якія ўжо памерлi, чым жывых, якія яшчэ жывуць. ");
INSERT INTO beln_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","А лепшы за іх абодвух той, якога яшчэ няма, які ня бачыў лiхiя справы, што робяцца пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","І ўбачыў я, што кожная цяжкая праца i кожны посьпех у справах выклiкае зайздрасьць да чалавека ў блiжняга ягонага. Гэта таксама марнасьць i пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","Дурань складвае рукi свае i зьядае цела сваё. ");
INSERT INTO beln_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","Лепшая адна поўная жменя са спакоем, чым абедзьве жмені напоўненыя, а з імі цяжкая праца i пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","I я павярнуўся, і ўбачыў марнасьць пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","Чалавек адзін, i няма другога, таксама няма анi сына, анi брата ў яго, і няма канца ўсёй цяжкай працы ягонай, i вока ягонае не насычаецца багацьцем, і кажа ён: “Для каго я працую i пазбаўляю душу сваю дабра?” Гэта таксама марнасьць і кепскі занятак. ");
INSERT INTO beln_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Лепш двум, чым аднаму, таму што маюць добрую ўзнагароду за цяжкую працу сваю. ");
INSERT INTO beln_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Бо калi адзiн упадзе, другi падніме таварыша свайго. Але гора аднаму, як ён упадзе, і няма другога, каб падняць яго. ");
INSERT INTO beln_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Таксама, калi ляжаць двое, будзе цёпла ім; а як адзiн можа сагрэцца? ");
INSERT INTO beln_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","I, калi хто зможа перамагчы аднаго, дык двое супрацьстануць яму, i вяроўка патройная ня хутка парвецца. ");
INSERT INTO beln_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","Лепш хлопец бедны i мудры, чым валадар стары i дурны, які ня можа ўжо прыймаць парады. ");
INSERT INTO beln_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","Бо той выходзіць з вязьніцы, каб валадарыць, а гэты ў валадарстве сваім можа стаць бедаком. ");
INSERT INTO beln_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","І я бачыў усіх, хто жыве і ходзіць пад сонцам, з тым хлопцам, другiм, які стане на месца ягонае. ");
INSERT INTO beln_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","Няма канца ўсяму народу, усiм, якiя былі перад ім, але тыя, што пасьля будуць, ня будуць радавацца дзеля яго. I гэта таксама марнасьць i турбаваньне духа. ");
INSERT INTO beln_vpl VALUES ("EC4_17","022_4_17","ECC","4","17","17","Захоўвай ногі свае, калі ідзеш у дом Божы, і набліжайся туды, каб слухаць, а не складаць ахвяры як дурні, бо яны ня маюць веданьня, робячы зло. ");
INSERT INTO beln_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","Ня будзь хуткі вуснамі тваімі, і сэрца тваё няхай не сьпяшаецца вымавіць слова перад абліччам Божым, таму што Бог у небе, а ты — на зямлi. Дзеля гэтага няхай словы твае будуць нешматлікімі. ");
INSERT INTO beln_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","Бо ад мноства заняткаў прыходзіць сон, і мноства словаў мае голас дурня. ");
INSERT INTO beln_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","Калi абяцаеш абяцаньне Богу, не марудзь выканаць яго, бо Ён ня мае ўпадабаньня да дурняў. Калі што абяцаеш — споўні. ");
INSERT INTO beln_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","Шмат лепш не абяцаць, чым паабяцаць і ня споўнiць. ");
INSERT INTO beln_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","Не дазваляй вуснам тваiм уводзiць у грэх цела сваё i не кажы перад анёлам, што гэта памылка; навошта табе, каб Бог загневаўся на голас твой і зьнішчыў справы рук тваiх. ");
INSERT INTO beln_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","Бо ў мностве сноў і ў памнажэньні словаў — марнасьць, але ты бойся Бога! ");
INSERT INTO beln_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","Калi ты ўбачыш прыгнёт беднага i парушэньне суду i справядлiвасьцi ў нейкай акрузе, не зьдзіўляйся гэтым рэчам, бо высокага пільнуе вышэйшы, а над iмi — яшчэ вышэйшы. ");
INSERT INTO beln_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","Але карысна для зямлі ва ўсім, калі валадар дбае пра поле. ");
INSERT INTO beln_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","Хто любiць срэбра, той не насыціцца срэбрам, і хто любiць багацьце, той ня будзе мець прыбытку; і гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Памнажаюцца даброцьці, памнажаюцца i тыя, што іх зьядаюць; i што за карысьць уласьнiку з гэтага, хiба, гледзячы, глядзець вачыма сваім? ");
INSERT INTO beln_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Салодкi сон таго, хто працуе, цi мала, цi шмат ён пад’еў, але сытасьць багатага не дае яму заснуць. ");
INSERT INTO beln_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Ёсьць лiхая нядоля, якую я бачыў пад сонцам, — багацьце, якое захоўваецца на шкоду таму, хто мае яго. ");
INSERT INTO beln_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","І загінула багацьце тое ў нешчасьлівым выпадку; і нарадзiў ён сына, і няма нiчога ў руках ягоных. ");
INSERT INTO beln_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Бо як выйшаў ён з улоньня мацi сваёй голы, так і вернецца назад, як прыйшоў, i нiчога не забярэ рукою сваёю з таго, што прыйшло праз цяжкую працу ягоную. ");
INSERT INTO beln_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","I гэта таксама ліхая нядоля: якім прыйшоў, такім i адыйдзе, і якая карысьць яму з таго, што працаваў на вецер? ");
INSERT INTO beln_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","Таксама ўсе днi свае ён еў у цемры, у смутку вялiкiм, у немачы i прыкрасьці. ");
INSERT INTO beln_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","Вось што я ўбачыў, што добра i прыгожа чалавеку есьцi i пiць, i бачыць добры плод кожнай цяжкай працы сваёй, якой працаваў пад сонцам у палічаных днях жыцьця свайго, якое даў яму Бог; бо гэта доля ягоная. ");
INSERT INTO beln_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","Таксама калі якому чалавеку Бог даў багацьце i маёмасьць, i даў ўладу спажыць гэта, і браць частку сваю, i радавацца з цяжкай працы сваёй, дык гэта дар Божы. ");
INSERT INTO beln_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","Бо ня будзе ён шмат памятаць пра дні жыцьця свайго, таму Бог дае радасьць у сэрца ягонае. ");
INSERT INTO beln_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","Ёсьць ліха, якое я бачыў пад сонцам, і цяжкае яно для чалавека: ");
INSERT INTO beln_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","Чалавек, якому Бог дае багацьце, i маёмасьць, i славу, i няма нiякай нястачы для душы ягонай нi ў чым, чаго не пажадаў бы ён, і не дае яму Бог улады, каб спажыць гэта, але чужы чалавек спажывае тое. Гэта марнасьць i ліхая немач. ");
INSERT INTO beln_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","Калi б нарадзiў чалавек сто дзяцей, i пражыў шмат гадоў, i было б шмат дзён гадоў ягоных, але душа ягоная не насыцiлася дабром, i нават не было б магілы для яго, я скажу, што лепшая доля спарона, чым таго чалавека. ");
INSERT INTO beln_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","Бо ён прыйшоў як марнасьць, i ў цемру ідзе, і цемраю пакрыта iмя ягонае, ");
INSERT INTO beln_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","нават ня ўбачыў ён сонца, i нічога не спазнаў, але мае большы спакой, чым чалавек той. ");
INSERT INTO beln_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","І хоць бы той чалавек жыў дзьве тысячы гадоў, i ня ўбачыў дабра, цi ж не ў адно месца ўсе ідуць? ");
INSERT INTO beln_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","Уся цяжкая праца чалавека — дзеля вуснаў ягоных, але душа ягоная не насычаецца. ");
INSERT INTO beln_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","Бо чым лепшы мудры за дурня? Чым лепшы прыгнечаны, які ведае, як хадзiць перад жывымi? ");
INSERT INTO beln_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","Лепш тое, што бачаць вочы, чым тое, куды імкнецца душа. Таксама гэта — марнасьць i пагоня за ветрам. ");
INSERT INTO beln_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","Хто як названы, такое iмя ягонае; i вядома, што ён — чалавек, i ня можа ён судзіцца з тым, хто мацнейшы за яго. ");
INSERT INTO beln_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","Дзе шмат слоў, там памнажаецца марнасьць; i што мае з гэтага чалавек? ");
INSERT INTO beln_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","Бо хто ведае, што добра для чалавека ў жыцьцi, у палічаных днях марнага жыцьця, якое праходзіць, як цень? І хто распавядзе чалавеку, што будзе пасьля яго пад сонцам? ");
INSERT INTO beln_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","Лепш добрае iмя, чым добры алей, і лепш дзень сьмерцi, чым дзень нараджэньня. ");
INSERT INTO beln_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","Лепш iсьцi ў дом жалобы, чым ісьці ў дом сьвяткаваньня, бо там — канец кожнага чалавека, і чалавек жывы складае гэта ў сэрцы сваім. ");
INSERT INTO beln_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","Лепш смутак, чым сьмех, бо праз засмучанае аблічча будзе лепшым сэрца. ");
INSERT INTO beln_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","Сэрца мудрых — у доме жалобы, а сэрца дурняў — у доме радасьці. ");
INSERT INTO beln_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","Лепш чалавеку слухаць дакараньні мудрага, чым слухаць сьпеў дурняў. ");
INSERT INTO beln_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","Бо сьмех дурня — як трэскат трэсак пад гаршчком. І гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","Бо прыгнёт іншых мудрага робіць шалёным, і падарунак псуе сэрца. ");
INSERT INTO beln_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","Лепш канец справы, чым яе пачатак, лепш павольны на гнеў, чым фанабэрысты. ");
INSERT INTO beln_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","Ня будзь хуткі да гневу ў духу тваім, бо гнеў жыве ў заўлоньні дурняў. ");
INSERT INTO beln_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","Не кажы: “Што гэта такое, што ранейшыя дні былi лепшыя, чым цяперашнiя?”, бо ня з мудрасьці ты пытаешся пра гэта. ");
INSERT INTO beln_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","Добрая мудрасьць разам са спадчынай, асабліва для таго, хто бачыць сонца. ");
INSERT INTO beln_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","Бо ў ценю мудрасьці як у ценю срэбра; і карысьць веданьня ў тым, што мудрасьць дае жыцьцё таму, хто мае яе. ");
INSERT INTO beln_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","Паглядзі на справы Божыя, бо хто можа выпрастаць тое, што Ён скрывіў. ");
INSERT INTO beln_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","У дзень добры карыстайся з добрага, а ў дзень лiхi ўбач, што адно зрабіў Бог насупраць другога, так што не знойдзе чалавек, што будзе пасля яго. ");
INSERT INTO beln_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Усё гэта я бачыў у дні марнасьці маёй: вось, праведнік гiне ў праведнасьці сваёй, і вось бязбожнік доўга жыве ў лiхоце сваёй. ");
INSERT INTO beln_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Ня будзь залішне праведны, i ня будзь надта мудры! Навошта маеш нішчыць сам сябе? ");
INSERT INTO beln_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Не асуджай залішне і ня будзь дурнем! Навошта табе паміраць не ў свой час? ");
INSERT INTO beln_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","Добра, калi будзеш трымацца аднаго, i ад другога не прыбірай рукi тваёй, бо той, хто баiцца Бога, пазьбегне ўсяго гэтага. ");
INSERT INTO beln_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Мудрасьць робіць мудрага мацнейшым за дзесяць уладароў, якія ў горадзе. ");
INSERT INTO beln_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Бо няма на зямлi чалавека праведнага, які робіць дабро i не грашыць. ");
INSERT INTO beln_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","Таксама кожнае слова, што гавораць, не ўкладай у сэрца тваё, і ня слухай, як слуга твой праклiнае цябе; ");
INSERT INTO beln_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","бо ведае сэрца тваё, што ты шмат разоў таксама праклiнаў іншых. ");
INSERT INTO beln_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","Усё гэта я выпрабаваў мудрасьцю, я сказаў: “Я буду мудрым”, але мудрасьць далёка ад мяне. ");
INSERT INTO beln_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","Далёка тое, што ўжо было, i глыбокае, глыбокае. Хто знойдзе яго? ");
INSERT INTO beln_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","Зьвярнуў я сэрца маё, каб спазнаць і дасьледаваць, і шукаць мудрасьць i разуменьне, i каб спазнаць, што бязбожнасьць — дурасьць, а глупота — шаленства. ");
INSERT INTO beln_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","І знайшоў я, што гарчэйшая за сьмерць жанчына, у якой сэрца як пастка і сіло, а рукі ейныя — як путы. Хто добры перад абліччам Бога, той уратуецца ад яе; а грэшнiк будзе злоўлены ёю. ");
INSERT INTO beln_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","Вось гэта я знайшоў, сказаў Эклезiяст, адно з другiм дасьледуючы, каб знайсьцi разуменьне. ");
INSERT INTO beln_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","Чаго яшчэ шукала душа мая i не знайшла? Чалавека аднаго з тысячы я знайшоў, а жанчыны сярод усіх іх не знайшоў. ");
INSERT INTO beln_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","Вось толькi гэта я знайшоў, што Бог зрабіў чалавека правым, а яны шукаюць усялякія прыдумкі. ");
INSERT INTO beln_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","Хто як мудрэц, i хто ведае значэньне рэчаў? Мудрасьць чалавека прасьвятляе аблічча ягонае, і суровасьць аблічча ягонага зьмяняецца. ");
INSERT INTO beln_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","Я раю: Словы вуснаў валадара захоўвай дзеля словаў прысягi перад Богам. ");
INSERT INTO beln_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","Не сьпяшайся зыходзiць ад аблічча ягонага, не стой пры словах ліхіх, бо ўсё, што захоча, ён зробiць. ");
INSERT INTO beln_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","Дзе слова валадара, там улада, і хто скажа яму: “Што ты робiш?” ");
INSERT INTO beln_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","Хто захоўвае прыказаньне, не дазнае нiякага ліха. А сэрца мудрага спазнае і час, i суд, ");
INSERT INTO beln_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","бо для кожнай рэчы ёсьць час i суд, а вялікае ліха чалавеку з-за таго, ");
INSERT INTO beln_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","што ня ведае ён, што будзе, і як гэта будзе, хто паведаміць яму? ");
INSERT INTO beln_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","Няма чалавека, які мае ўладу над ветрам, каб утрымаць вецер, і няма ўладара над днём сьмерці, і няма звальненьня ў гэтай вайне, i не ўратуе беззаконьне таго, хто мае яго. ");
INSERT INTO beln_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","Усё гэта я бачыў, i прыкладаў сэрца маё да ўсiх справаў, якiя робяцца пад сонцам, бачыў час, калі чалавек сае ўладу над чалавекам на гора яму. ");
INSERT INTO beln_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","Таксама бачыў я злачынцаў пахаваных, і прыходзiлi да іх, і адыходзілі ад месца сьвятога, i забывалiся ў горадзе, што яны так рабiлi: І гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","Бо не адразу выносiцца прысуд супраць лiхiх учынкаў, дзеля гэтага сэрца сыноў чалавечых напоўнена імі, каб чынiць зло. ");
INSERT INTO beln_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","Хоць грэшнiк сто разоў чыніць зло, але доўга жыве. Але я ведаю таксама, што будзе добра тым, якія баяцца Бога, якія баяцца аблічча Ягонага. ");
INSERT INTO beln_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","І ня будзе добра бязбожніку, i не падоўжыць ён дзён сваiх, падобны да ценю той, хто ня мае страху перад абліччам Божым. ");
INSERT INTO beln_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","Ёсьць такая марнасьць, якая робіцца на зямлi, што ёсьць праведнікі, якіх спатыкае тое, на што заслугоўваюць учынкі бязбожнікаў, і ёсьць бязбожнікі, якiх спатыкае тое, на што заслугоўваюць учынкі праведнікаў. І я сказаў, што гэта таксама марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","І пахвалiў я радасьць, бо няма нiчога чалавеку лепшага пад сонцам, як есьцi i пiць, і весяліцца, i гэта няхай будзе з ім у цяжкай працы ягонай ў дні жыцьця ягонага, якія даў яму Бог пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Калi прыклаў я сэрца маё, каб спазнаць мудрасьць i ўбачыць заняткі, якiмі займаюцца на зямлi, бо дзень і ноч ня бачыць чалавек сну для вачэй сваіх, ");
INSERT INTO beln_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","тады ўбачыў я ўсе справы Божыя, што чалавек ня можа зразумець справы, якія робяцца пад сонцам; i колькі б чалавек ні намагаўся шукаць гэта, нічога не знойдзе; i хаця б мудры сказаў, што ведае, ён ня можа знайсьці. ");
INSERT INTO beln_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","Да ўсяго гэтага я прыклаў сэрца сваё, каб спасьцігнуць усё гэта, што праведныя i мудрыя, і ўчынкі iхнія — у руцэ Божай, і таксама любоў і нянавісьць. І чалавек ня ведае усяго таго, што перад ім. ");
INSERT INTO beln_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","Усё для ўсіх адно: адна доля для праведніка i для бязбожніка, для добрага і чыстага i для нячыстага, для таго, хто ахвяроўвае, і для таго, хто не ахвяроўвае i не складаючаму, як для добрага, так i для грэшнага; як для таго, які прысягае, так і для таго, які прысягаць баiцца. ");
INSERT INTO beln_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","І тое кепска ва ўсім, што робіцца пад сонцам, што адна доля для ўсiх; i таксама сэрца сыноў чалавечых поўнае зла, i шаленства маюць яны ў сэрцы пад час жыцьця свайго, а потым адыходзяць да памёршых. ");
INSERT INTO beln_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","Бо той, хто знаходзіцца мiж усiмi жывымi, мае надзею, бо лепш жывы сабака, чым здохлы леў. ");
INSERT INTO beln_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","Бо жывыя ведаюць, што памруць; а памёршыя нiчога ня ведаюць, i ня маюць больш ніякай платы, бо забытая памяць пра iх. ");
INSERT INTO beln_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","Таксама любоў iхняя i нянавiсьць іхняя, i зайздрасьць іхняя ўжо счэзьлi, i ня маюць яны ўжо часткі на вякі ў-ва ўсім, што робіцца пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","Ідзi, еш з радасьцю хлеб твой i пi са спакойным сэрцам вiно тваё, калі даспадобы Богу справы твае. ");
INSERT INTO beln_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","Увесь час няхай будзе белым адзеньне тваё, і алею на галаве тваёй няхай не бракуе. ");
INSERT INTO beln_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","Пражыві жыцьцё з жонкаю, якую кахаеш, ў-ва ўсе днi марнага жыцьця твайго, якiя дадзены табе пад сонцам на ўвесь час марнасьцi тваёй, бо гэта частка твая ў жыцьцi i ў-ва ўсёй цяжкай працы, якою працуеш пад сонцам. ");
INSERT INTO beln_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","Усё, што можа зрабiць рука твая, рабi паводле сілы тваёй, бо ў адхлані, у якую ты ідзеш, няма анi справаў, анi разуменьня, анi веданьня, анi мудрасьці. ");
INSERT INTO beln_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","І павярнуўся я, i ўбачыў пад сонцам, што не шпаркім даецца пасьпяховы бег i не магутным — перамога ў вайне, і ня мудрым — хлеб, і не разумным — багацьце, і ня знаўцам — зычлівасьць, бо ад часу i выпадку залежыць усё гэта. ");
INSERT INTO beln_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","Бо таксама ня ведае чалавек часу свайго. Як рыбы трапляюць у згубную сетку, і як птушкi заблытваюцца ў сiле, так сыны чалавечыя патрапляюць у лiхi час, які прыходзіць на іх нечакана. ");
INSERT INTO beln_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","Таксама бачыў я такую мудрасьць пад сонцам, і вялікай яна падалася для мяне: ");
INSERT INTO beln_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","Горад малы, i людзей у iм няшмат, і прыйшоў да яго вялiкi валадар, i атачыў яго, i насыпаў супраць яго вялікія валы. ");
INSERT INTO beln_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","І знайшоўся ў ім чалавек бедны i мудры, i выратаваў горад той мудрасьцю сваёю; i нiводзін чалавек не ўзгадаў гэтага беднага чалавека. ");
INSERT INTO beln_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","І я сказаў: “Мудрасьць лепшая за сілу, але мудрасьцю беднага пагарджаюць, i словаў ягоных ня слухаюць”. ");
INSERT INTO beln_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","Спакойныя словы мудрых паслухаць лепш, чым крык таго, хто пануе сярод дурняў. ");
INSERT INTO beln_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","Мудрасьць лепшая за зброю ваенную, а адзiн грэшнiк зьнішчыць шмат добрага. ");
INSERT INTO beln_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","Мёртвая муха робіць сьмярдзючым алей, і вылівае яго знаўца пахнідлаў. Больш важыць малое глупства, чым мудрасьць і слава. ");
INSERT INTO beln_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","Сэрца мудрага зьвяртаецца ў правы бок, а сэрца дурня — у левы. ");
INSERT INTO beln_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","Нават калi дурны iдзе дарогаю, яму не хапае розуму, і ён пакажа усiм, што дурны. ");
INSERT INTO beln_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","Калi гнеў вялікага пана ўзьнімецца супраць цябе, заставайся на месцы сваім, бо цьвярозыя паводзіны залагоджваюць вялікія правіны. ");
INSERT INTO beln_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","Ёсьць ліха, якое я бачыў пад сонцам, нібыта памылка, якая выходзіць ад аблічча ўладара: ");
INSERT INTO beln_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","дурань пастаўлены на высокасьці вялікай, а багатыя сядзяць нiзка. ");
INSERT INTO beln_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","Бачыў я слугаў на конях, і князёў, якія як слугі, ідуць па зямлі. ");
INSERT INTO beln_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","Хто капае яму, той упадзе ў яе, а таго, хто ломiць агароджу, укусiць зьмяя. ");
INSERT INTO beln_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","Хто перасоўвае камянi, можа скалечыцца iмi, і хто коле дровы, можа быць у небясьпецы ад іх. ");
INSERT INTO beln_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","Калi ступiцца жалезная сякера і лязо яе не навострана, трэба больш прыкладаць сілы, але больш карысьці будзе скарыстацца мудрасьцю. ");
INSERT INTO beln_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","Калi ўкусiць зьмяя незагавораная, няма ўжо карысьці ад таго, хто ўмеее загаворваць. ");
INSERT INTO beln_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","Словы вуснаў мудрага — прыемнасьць, але вусны дурня губяць яго самога. ");
INSERT INTO beln_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","Пачатак словаў вуснаў ягоных — глупота, а канец прамовы вуснаў ягоных – ліхое шаленства. ");
INSERT INTO beln_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","Бязглузды памнажае словы, хоць ня ведае чалавек, што будзе потым, i што пасьля яго станецца, хто распавядзе яму? ");
INSERT INTO beln_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","Праца дурняў стамляе iх, бо ня ведае ён нават, як дайсьцi ў горад. ");
INSERT INTO beln_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","Гора табе, зямля, калі валадар твой — юнак, i калi твае князi ад раніцы ядуць. ");
INSERT INTO beln_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","Шчасьлiвая зямля, калі валадар — сын шляхетных, калі князi ядуць у час адпаведны для спасіленьня, а не каб нажэрціся. ");
INSERT INTO beln_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","Дзе лянота, там правісае столь, і дзе апушчаны рукi, там працякае дом. ");
INSERT INTO beln_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","Дзеля забавы ладзяць банкет, і вiно разьвесяляе жыцьцё, а срэбра адказвае за ўсё. ");
INSERT INTO beln_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","Нават у думцы сваёй не кляні валадара, і ў спальнi сваёй не кляні багатага, бо птушкi нябесныя занясуць голас твой, i тыя, што маюць крылы, распавядуцт слова. ");
INSERT INTO beln_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","Пускай хлеб свой па вадзе, таму што праз шмат дзён знойдзеш яго. ");
INSERT INTO beln_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","Давай частку сямi, і нават васьмi, бо ня ведаеш, якая бяда будзе на зямлi. ");
INSERT INTO beln_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","Калi хмары будуць напоўненыя дажджом, яны выльюць яго на зямлю, і калi дрэва ўпадзе на поўдзень або на поўнач, на месцы, дзе ўпадзе, там i застанецца. ");
INSERT INTO beln_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","Хто назірае за ветрам, ня будзе сеяць, і хто глядзiць на хмары, ня будзе жаць. ");
INSERT INTO beln_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","Калі ты ня ведаеш, які шлях ветру і як паўстаюць косткi ва ўлоньні цяжарнай, падобна ня ведаеш дзеяў Бога, Якi робіць усё. ");
INSERT INTO beln_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","Раніцаю сей насеньне тваё, i ў вечары не спыняй рукі тваёй, бо ты ня ведаеш, з чаго будзе больш карысьці, з аднаго ці з другога, ці з абодвух будзе аднолькава добра. ");
INSERT INTO beln_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","Салодкае сьвятло, i добра вачам бачыць сонца. ");
INSERT INTO beln_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","Бо калi шмат гадоў жыве чалавек, няхай радуецца з іх усіх, і няхай памятае пра днi цемры, бо будзе iх шмат. Усё, што надыйдзе — марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Радуйся, юнача, у маладосьцi сваёй, і няхай сэрцу твайму будзе добра ў дні юнацтва твайго, і хадзi шляхамі сэрца твайго i паводле таго, што бачаць вочы твае, і ведай, што за ўсё гэта Бог прывядзе цябе на суд. ");
INSERT INTO beln_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","І прыбяры смутак з сэрца твайго, i аддалі лiхоцьце ад цела твайго, бо маладосьць i цёмнасьць валасоў — марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","І памятай пра Творцу твайго у дні юнацтва твайго, пакуль не прыйдуць дні ліхія, i пакуль не сустрэнуць цябе гады, пра якiя скажаш: “Не падабаюцца мне яны”, ");
INSERT INTO beln_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","пакуль не зацемрыцца сонца, i сьвятло, i месяц, i зоркi, пакуль ня вернуцца пасьля дажджу хмары, ");
INSERT INTO beln_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","у дні, калі будуць дрыжэць вартаўнiкi дому i хiстацца мужы моцныя, i кінуць малоць млынары, бо іх будзе мала, i пацямнеюць тыя, што глядзяць праз вокны, ");
INSERT INTO beln_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","і будуць замкнутыя дзьверы на вулiцу, і сціхне голас жорнаў, і будуць ўскокваць на голас птушкi, і змоўкнуць ўсе дочкі сьпеваў, ");
INSERT INTO beln_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","і будуць баяцца вышыняў, i жахацца на дарозе; i заквітнее дрэва мiгдалёвае, i пацяжэе саранча, i асыпецца капэрс, бо пойдзе чалавек у дом вечнасьці сваёй, i будуць хадзіць вакол яго па вулiцы плачкі, ");
INSERT INTO beln_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","пакуль не парвецца срэбны ланцужок, i не раструшчыцца залатая чаша, i не паб’ецца збан пры крынiцы, i ня зломіцца калаўрот над студняю, ");
INSERT INTO beln_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","i вернецца парахно ў зямлю, чым яно і было, а дух вернецца да Бога, Які даў яго. ");
INSERT INTO beln_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Марнасьць марнасьцяў, сказаў Эклезiяст, ўсё — марнасьць. ");
INSERT INTO beln_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Акрамя таго, што Эклезiяст быў мудры, ён вучыў таксама людзей ведам, і прыслухоўваўся, і дасьледаваў, i склаў шмат прыповесьцяў. ");
INSERT INTO beln_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Імкнуўся Эклезiяст знайсьці прыгожыя словы, i запісаць шчыра словы праўды. ");
INSERT INTO beln_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Словы мудрых — як джалы, i як цьвiкi моцна ўбiтыя — тыя, што сабралі іх; яны дадзены адзіным Пастырам. ");
INSERT INTO beln_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","А што звыш гэтага, сыне мой, таго сьцеражыся: складаньню шматлікіх кнiгаў няма канца, і доўгае вучэньне — стома для цела. ");
INSERT INTO beln_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Сутнасьць усяго слова, што было пачута: бойся Бога i захоўвай прыказаньнi Ягоныя, бо ў гэтым — усё для чалавека! ");
INSERT INTO beln_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Бо ўсе ўчынкі Бог прывядзе на суд, і ўсё схаванае, і добрае, і ліхое.");
INSERT INTO beln_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Кніга радаводу Ісуса Хрыста, Сына Давіда, Сына Абрагама: ");
INSERT INTO beln_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Абрагам нарадзіў Ісаака; Ісаак нарадзіў Якуба; Якуб нарадзіў Юду і братоў ягоных; ");
INSERT INTO beln_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Юда нарадзіў Пэрэса і Зару ад Тамар; Пэрэс нарадзіў Эсрома; Эсром нарадзіў Арама; ");
INSERT INTO beln_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Арам нарадзіў Амінадава; Амінадаў нарадзіў Наасона; Наасон нарадзіў Сальмона; ");
INSERT INTO beln_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Сальмон нарадзіў Боаза ад Рахаў; Боаз нарадзіў Абэда ад Рут; ");
INSERT INTO beln_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Абэд нарадзіў Есэя; Есэй нарадзіў Давіда валадара; Давід валадар нарадзіў Салямона ад Урыявай; ");
INSERT INTO beln_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Салямон нарадзіў Рабаама; Рабаам нарадзіў Абію; Абія нарадзіў Асу; ");
INSERT INTO beln_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Аса нарадзіў Ясафата; Ясафат нарадзіў Ярама; Ярам нарадзіў Озію; ");
INSERT INTO beln_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Озія нарадзіў Ёатама; Ёатам нарадзіў Ахаза; Ахаз нарадзіў Эзэкію; ");
INSERT INTO beln_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Эзэкія нарадзіў Манасу; Манаса нарадзіў Амона; Амон нарадзіў Ёсію; ");
INSERT INTO beln_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ёсія нарадзіў Ёакіма; Ёакім нарадзіў Ехонію і братоў ягоных перад перасяленьнем у Бабілон. ");
INSERT INTO beln_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","А пасьля перасяленьня ў Бабілон Ехонія нарадзіў Салятыэля; Салятыэль нарадзіў Зэрубабэля; ");
INSERT INTO beln_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Зэрубабэль нарадзіў Абіюда; Абіюд нарадзіў Эліякіма; Эліякім нарадзіў Азора; ");
INSERT INTO beln_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Азор нарадзіў Садока; Садок нарадзіў Ахіма; Ахім нарадзіў Эліюда; ");
INSERT INTO beln_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Эліюд нарадзіў Элеазара; Элеазар нарадзіў Маттана; Маттан нарадзіў Якуба; ");
INSERT INTO beln_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Якуб нарадзіў Язэпа, мужа Марыі, ад якой нарадзіўся Ісус, называны Хрыстос. ");
INSERT INTO beln_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Гэтак усіх пакаленьняў ад Абрагама да Давіда чатырнаццаць пакаленьняў; ад Давіда да перасяленьня ў Бабілон чатырнаццаць пакаленьняў; і ад перасяленьня ў Бабілон да Хрыста чатырнаццаць пакаленьняў. ");
INSERT INTO beln_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Нараджэньне Ісуса Хрыста было вось як: па заручынах маці Яго Марыі з Язэпам, раней, чым яны зыйшліся, выявілася, што яна цяжарная ад Духа Сьвятога. ");
INSERT INTO beln_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Язэп, муж ейны, будучы праведным і ня хочучы агаласіць яе, хацеў цішком адпусьціць яе. ");
INSERT INTO beln_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Але, калі ён падумаў гэтае, вось, анёл Госпадаў зьявіўся яму ў-ва сьне і сказаў: «Язэп, сыне Давідаў! Ня бойся прыняць Марыю, жонку тваю, бо Тое, што нарадзілася ў ёй, ёсьць ад Духа Сьвятога. ");
INSERT INTO beln_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Вось жа народзіць Сына, і дасі Яму імя Ісус, бо Ён збавіць народ Свой ад грахоў іхніх». ");
INSERT INTO beln_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","А ўсё гэтае сталася, каб споўнілася сказанае Госпадам праз прарока, які кажа: ");
INSERT INTO beln_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Вось, Дзева прыйме ва ўлоньне і народзіць Сына; і дадуць Яму імя Іммануэль, гэта значыць: З намі Бог». ");
INSERT INTO beln_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Устаўшы зо-сну, Язэп зрабіў, як загадаў яму анёл Госпадаў, і прыняў жонку сваю, ");
INSERT INTO beln_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","і не спазнаў яе, аж нарадзіла Сына свайго Першароднага, і ён даў Яму імя Ісус. ");
INSERT INTO beln_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Калі ж Ісус нарадзіўся ў Бэтлееме Юдэйскім у дні валадара Ірада, прыйшлі ў Ерусалім мудрацы з усходу і кажуць: ");
INSERT INTO beln_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«Дзе народжаны Валадар Юдэйскі? Бо мы бачылі зорку Ягоную на ўсходзе і прыйшлі пакланіцца Яму». ");
INSERT INTO beln_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Пачуўшы гэтае, Ірад валадар стрывожыўся, і ўвесь Ерусалім з ім. ");
INSERT INTO beln_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","І, сабраўшы ўсіх першасьвятароў і кніжнікаў народу, пытаўся ў іх, дзе павінен нарадзіцца Хрыстос. ");
INSERT INTO beln_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Яны ж сказалі яму: «У Бэтлееме Юдэйскім, бо гэтак напісана праз прарока: ");
INSERT INTO beln_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“І ты, Бэтлеем, зямля Юды, нічым ня меншы за ваяводзтвы Юды, бо з цябе выйдзе Правадыр, Які будзе пасьвіць народ Мой, Ізраіль”». ");
INSERT INTO beln_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Тады Ірад, цішком паклікаўшы мудрацоў, выведаў ад іх час зьяўленьня зоркі. ");
INSERT INTO beln_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","І, паслаўшы іх у Бэтлеем, сказаў: «Пайдзіце, добра даведайцеся пра Дзіцятка і, калі знойдзеце, паведаміце мне, каб і я, пайшоўшы, пакланіўся Яму». ");
INSERT INTO beln_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Яны, выслухаўшы валадара, пайшлі. І вось, зорка, якую бачылі яны на ўсходзе, ішла перад імі, пакуль, прыйшоўшы, не спынілася над месцам, дзе было Дзіцятка. ");
INSERT INTO beln_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Убачыўшы зорку, яны ўзрадаваліся радасьцю вельмі вялікаю. ");
INSERT INTO beln_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","І, увайшоўшы ў дом, убачылі Дзіцятка з Марыяй, маці Ягонай, і, упаўшы, пакланіліся Яму; і, адчыніўшы скарбы свае, прынесьлі Яму падарункі: золата, ладан і сьмірну. ");
INSERT INTO beln_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","І, меўшы ў сьне слова не варочацца да Ірада, іншым шляхам адыйшлі ў краіну сваю. ");
INSERT INTO beln_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Калі ж яны адыйшлі, вось, анёл Госпадаў зьяўляецца ў сьне Язэпу і кажа: «Устань, вазьмі Дзіцятка і маці Ягоную, і бяжы ў Эгіпет, і будзь там, пакуль не скажу табе; бо Ірад мае шукаць Дзіцятка, каб загубіць Яго». ");
INSERT INTO beln_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ён устаў уначы, узяў Дзіцятка і маці Ягоную, і пайшоў у Эгіпет. ");
INSERT INTO beln_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","І там быў да сьмерці Ірада, каб збылося сказанае Госпадам праз прарока, які кажа: «З Эгіпту паклікаў Я сына Майго». ");
INSERT INTO beln_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Тады Ірад, убачыўшы, што мудрацы з яго пасьмяяліся, вельмі разгневаўся і паслаў забіць усіх дзяцей у Бэтлееме і ўсіх ваколіцах яго, ад двух гадоў і малодшых, паводле часу, які даведаўся ад мудрацоў. ");
INSERT INTO beln_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Тады збылося сказанае праз прарока Ярэмію, які кажа: ");
INSERT INTO beln_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Голас у Раме чутны, плач, і галашэньне, і лямант вялікі; Рахель плача па дзецях сваіх і ня хоча суцешыцца, бо іх няма». ");
INSERT INTO beln_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","А пасьля сьмерці Ірада, вось, анёл Госпадаў у сьне зьяўляецца Язэпу ў Эгіпце ");
INSERT INTO beln_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","і кажа: «Устань, вазьмі Дзіцятка і маці Ягоную і ідзі ў зямлю Ізраіля, бо памерлі тыя, што шукалі душы Дзіцяці». ");
INSERT INTO beln_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ён устаў, узяў Дзіцятка і маці Ягоную, і прыйшоў у зямлю Ізраіля. ");
INSERT INTO beln_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","А пачуўшы, што ў Юдэі пануе Архелай замест Ірада, бацькі свайго, пабаяўся туды ісьці; але, атрымаўшы слова ў сьне, пайшоў у межы Галілейскія. ");
INSERT INTO beln_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","І, прыйшоўшы, асеў у горадзе, званым Назарэт, каб споўнілася сказанае праз прарокаў, што Ён Назарэем назавецца. ");
INSERT INTO beln_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","У тыя дні прыходзіць Ян Хрысьціцель, абвяшчаючы ў пустыні Юдэйскай ");
INSERT INTO beln_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","і кажучы: «Навярніцеся, бо наблізілася Валадарства Нябеснае». ");
INSERT INTO beln_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Бо ён той, пра якога сказаў прарок Ісая: «Голас таго, хто кліча ў пустыні: Падрыхтуйце шлях Госпаду, простымі рабіце сьцежкі Яму». ");
INSERT INTO beln_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Сам жа Ян меў адзеньне з вярблюдавага воласу і скураны пояс на паясьніцы сваёй, а ежаю яго была саранча і дзікі мёд. ");
INSERT INTO beln_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Тады выходзілі да яго Ерусалім, і ўся Юдэя, і ўсе ваколіцы Ярдану, ");
INSERT INTO beln_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","і хрысьціліся ў яго ў Ярдане, вызнаючы грахі свае. ");
INSERT INTO beln_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","А ўбачыўшы мноства фарысэяў і садукеяў, якія ішлі да яго хрысьціцца, сказаў ім: «Спараджэньні яхідны, хто навучыў вас уцякаць ад будучага гневу? ");
INSERT INTO beln_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Учыніце ж плод, годны навяртаньня, ");
INSERT INTO beln_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","і ня думайце гаварыць у думках сваіх: “Бацьку маем Абрагама”; бо кажу вам, што Бог можа з камянёў гэтых падняць дзяцей Абрагаму. ");
INSERT INTO beln_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ужо і сякера ля кораня дрэваў ляжыць; дык кожнае дрэва, якое не дае добрага плоду, сьсякаюць і кідаюць у агонь. ");
INSERT INTO beln_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Я хрышчу вас у вадзе на навяртаньне, але Той, Хто ідзе за мною, дужэйшы за мяне, і я ня варты несьці сандалы Ягоныя. Ён будзе хрысьціць вас у Духу Сьвятым і ў агні. ");
INSERT INTO beln_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Веялка Ягоная ў руцэ Ягонай, і Ён ачысьціць гумно Сваё, і зьбярэ пшаніцу Сваю ў сьвіран, а салому спаліць агнём нязгасным». ");
INSERT INTO beln_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Тады прыходзіць Ісус з Галілеі на Ярдан да Яна хрысьціцца ў яго. ");
INSERT INTO beln_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ян жа ўстрымліваў Яго, кажучы: «Мне трэба хрысьціцца ў Цябе, а Ты прыходзіш да мяне?» ");
INSERT INTO beln_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","А Ісус, адказваючы, сказаў яму: «Пакінь цяпер; бо гэтак нам належыць споўніць усякую праведнасьць». Тады дапускае Яго. ");
INSERT INTO beln_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","І, ахрысьціўшыся, Ісус адразу ж выйшаў з вады, і вось, расчынілася Яму неба, і ўгледзеў Духа Божага, Які зыходзіў, як голуб, і прыходзіў на Яго. ");
INSERT INTO beln_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","І вось, голас з неба, які казаў: «Гэта ёсьць Сын Мой улюбёны, у Якім маю ўпадабаньне». ");
INSERT INTO beln_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Тады Ісус заведзены быў Духам у пустыню дзеля спакушваньня праз д’ябла, ");
INSERT INTO beln_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","і, прапасьціўшы сорак дзён і сорак начэй, нарэшце згаладнеў. ");
INSERT INTO beln_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","І, падыйшоўшы да Яго, спакусьнік сказаў: «Калі Ты — Сын Божы, скажы, каб камяні гэтыя сталіся хлябамі». ");
INSERT INTO beln_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ён жа, адказваючы, сказаў яму: «Напісана: “Ня хлебам адным будзе жыць чалавек, але ўсякім словам, што выходзіць з вуснаў Божых”». ");
INSERT INTO beln_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Потым бярэ Яго д’ябал у сьвяты горад, і стаўляе на вільчаку сьвятыні, ");
INSERT INTO beln_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","і кажа Яму: «Калі Ты — Сын Божы, кінься ўніз, бо напісана: “Анёлам Сваім загадае пра Цябе, і на руках панясуць Цябе, каб не спатыкнуўся аб камень нагою Тваёю”». ");
INSERT INTO beln_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ісус сказаў яму: «Ізноў жа напісана: “Не спакушай Госпада, Бога твайго”». ");
INSERT INTO beln_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ізноў бярэ Яго д’ябал на вельмі высокую гару, і паказвае Яму ўсе валадарствы сьвету і славу іх, ");
INSERT INTO beln_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","і кажа Яму: «Усё гэта дам Табе, калі, упаўшы, паклонішся мне». ");
INSERT INTO beln_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Тады Ісус кажа яму: «Адыйдзі ад Мяне, шатан! Бо напісана: “Госпаду, Богу твайму, пакланяйся, і Яму аднаму служы”». ");
INSERT INTO beln_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Тады пакідае Яго д’ябал; і вось, анёлы прыступіліся, і служылі Яму. ");
INSERT INTO beln_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","А пачуўшы, што Ян у вязьніцы, Ісус адыйшоў у Галілею. ");
INSERT INTO beln_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","І, пакінуўшы Назарэт, прыйшоў і асеў у Капэрнауме прыморскім, у гарадах Забулёна і Нэфталі, ");
INSERT INTO beln_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","каб споўнілася сказанае праз прарока Ісаю, які кажа: ");
INSERT INTO beln_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Зямля Забулёна і зямля Нэфталі, на дарозе прыморскай за Ярданам, Галілея паганская, ");
INSERT INTO beln_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","народ, які сядзеў у цемры, убачыў сьвятло вялікае, і тым, што сядзелі ў краіне і ценю сьмерці, сьвятло зазьзяла». ");
INSERT INTO beln_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","З таго часу Ісус пачаў абвяшчаць і казаць: «Навярніцеся, бо наблізілася Валадарства Нябеснае». ");
INSERT INTO beln_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Праходзячы ж недалёка мора Галілейскага, Ён убачыў двух братоў, Сымона, называнага Пятром, і Андрэя, брата ягонага, якія закідалі сеткі ў мора, бо яны былі рыбаловы, ");
INSERT INTO beln_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","і кажа ім: «Ідзіце за Мною, і Я зраблю вас лаўцамі чалавекаў». ");
INSERT INTO beln_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","І яны адразу, пакінуўшы сеці, пайшлі за Ім. ");
INSERT INTO beln_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ідучы адтуль далей, убачыў Ён другіх двух братоў, Якуба Зэбэдэявага і Яна, брата ягонага, у чаўне з Зэбэдэем, бацькам іхнім, якія правілі сеці свае, і паклікаў іх. ");
INSERT INTO beln_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","І яны адразу, пакінуўшы човен і бацьку свайго, пайшлі за Ім. ");
INSERT INTO beln_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","І хадзіў Ісус па ўсёй Галілеі, навучаючы ў сынагогах іхніх і абвяшчаючы Эвангельле Валадарства, і аздараўляючы ўсякую хваробу і ўсякую немач у народзе. ");
INSERT INTO beln_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","І прайшлі пра Яго чуткі па ўсёй Сірыі, і прыводзілі да Яго ўсіх нядужых, з рознымі хворасьцямі і пакутамі, і апанаваных дэманамі, і люнатыкаў, і спараліжаваных, і Ён іх аздараўляў. ");
INSERT INTO beln_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","І ішлі за Ім шматлікія натоўпы з Галілеі, і Дэкапалю, і Ерусаліму, і Юдэі, і з таго боку Ярдану. ");
INSERT INTO beln_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Убачыўшы натоўпы, Ён узыйшоў на гару, і, калі сеў, падыйшлі да Яго вучні Ягоныя. ");
INSERT INTO beln_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","І Ён, расчыніўшы вусны Свае, навучаў іх, кажучы: ");
INSERT INTO beln_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Шчасьлівыя ўбогія духам, бо іх ёсьць Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Шчасьлівыя тыя, што плачуць, бо яны будуць суцешаныя. ");
INSERT INTO beln_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Шчасьлівыя ціхія, бо яны возьмуць у спадчыну зямлю. ");
INSERT INTO beln_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Шчасьлівыя тыя, што прагнуць і смагнуць праведнасьці, бо яны будуць насычаныя. ");
INSERT INTO beln_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Шчасьлівыя міласьцівыя, бо яны будуць памілаваныя. ");
INSERT INTO beln_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Шчасьлівыя чыстыя сэрцам, бо яны Бога ўбачаць. ");
INSERT INTO beln_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Шчасьлівыя міратворцы, бо яны сынамі Божымі будуць названыя. ");
INSERT INTO beln_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Шчасьлівыя тыя, каго перасьледуюць за праведнасьць, бо іх ёсьць Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Шчасьлівыя вы, калі дзеля Мяне будуць зьневажаць вас, і перасьледаваць, і казаць усякае злое слова хлусьліва. ");
INSERT INTO beln_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Радуйцеся і весяліцеся, бо вялікая нагарода вашая ў небе; бо так перасьледавалі прарокаў, якія былі раней за вас. ");
INSERT INTO beln_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Вы — соль зямлі. Калі ж соль згубіць сілу, то чым зробіш яе салёнаю? Яна ўжо ні на што не надаецца, хіба толькі выкінуць яе вон на патаптаньне людзям. ");
INSERT INTO beln_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Вы — сьвятло сьвету. Ня можа схавацца горад, які стаіць на вяршыні гары. ");
INSERT INTO beln_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ніхто не запальвае сьвечку, каб паставіць яе пад пасудзінай, але на сьвечніку, і яна сьвеціць усім, хто ёсьць у доме. ");
INSERT INTO beln_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Гэтак няхай сьвятло вашае сьвеціць перад людзьмі, каб яны бачылі вашыя добрыя справы і славілі Айца вашага, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ня думайце, што Я прыйшоў парушыць Закон ці Прарокаў; не парушыць прыйшоў Я, але споўніць. ");
INSERT INTO beln_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Бо сапраўды кажу вам: пакуль не праміне неба і зямля, аніводная ёта ці рыска не праміне з Закону, пакуль ня станецца ўсё. ");
INSERT INTO beln_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Вось жа, хто парушыць адно з гэтых найменшых прыказаньняў і навучыць гэтаму людзей, той найменшым названы будзе ў Валадарстве Нябесным; а хто выканае і навучыць, той вялікім названы будзе ў Валадарстве Нябесным. ");
INSERT INTO beln_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Бо кажу вам: калі праведнасьць вашая не перавысіць праведнасьці кніжнікаў і фарысэяў, вы ня ўвойдзеце ў Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Вы чулі, што сказана старадаўным: “Не забівай, а хто заб’е, падлягае суду”. ");
INSERT INTO beln_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","А Я кажу вам, што ўсякі, хто гневаецца на брата свайго дарэмна, падлягае суду; а хто скажа брату свайму: “Рака”, падлягае сынэдрыёну, а хто скажа: “Дурань”, падлягае гееньне вогненай. ");
INSERT INTO beln_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Дык калі ты прынясеш дар твой на ахвярнік, і там узгадаеш, што брат твой мае нешта супраць цябе, ");
INSERT INTO beln_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","пакінь дар твой перад ахвярнікам і пайдзі перш пагадзіся з братам тваім, а тады, прыйшоўшы, прынясі дар твой. ");
INSERT INTO beln_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Пагадзіся з супраціўнікам тваім хутчэй, пакуль ты яшчэ ў дарозе з ім, каб супраціўнік не аддаў цябе судзьдзі, а судзьдзя не аддаў бы цябе паслугачу, і ня быў ты кінуты ў вязьніцу. ");
INSERT INTO beln_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Сапраўды кажу табе: ты ня выйдзеш адтуль, пакуль не аддасі апошняга кадранта. ");
INSERT INTO beln_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Вы чулі, што сказана старадаўным: “Не чужалож”. ");
INSERT INTO beln_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","А Я кажу вам, што ўсякі, хто глядзіць на жанчыну, жадаючы яе, ужо чужаложыць з ёю ў сэрцы сваім. ");
INSERT INTO beln_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Калі ж правае вока тваё згаршае цябе, вырві яго і кінь ад сябе, бо лепш табе, каб загінуў адзін з членаў тваіх, а ня ўсё цела тваё было ўкінута ў геенну. ");
INSERT INTO beln_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","І калі правая рука твая згаршае цябе, адсячы яе і кінь ад сябе, бо лепш табе, каб загінуў адзін з членаў тваіх, а ня ўсё цела тваё было ўкінута ў геенну. ");
INSERT INTO beln_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Сказана таксама, што, калі хто разлучаецца з жонкаю сваёю, няхай дасьць ёй развод. ");
INSERT INTO beln_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","А Я кажу вам: хто разлучаецца з жонкаю сваёю не з прычыны распусты, той робіць яе чужаложніцай, і хто жэніцца з разьведзенай, той чужаложыць. ");
INSERT INTO beln_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Яшчэ чулі вы, што сказана старадаўным: “Не прысягай фальшыва, але спаўняй перад Госпадам прысягі твае”. ");
INSERT INTO beln_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","А Я кажу вам: не прысягай зусім, ані небам, бо яно — пасад Божы; ");
INSERT INTO beln_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ані зямлёю, бо яна — падножжа ног Ягоных, ані Ерусалімам, бо ён — горад вялікага Валадара; ");
INSERT INTO beln_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ані галавою сваёю не прысягай, бо ня можаш аніводнага воласу зрабіць белым ці чорным. ");
INSERT INTO beln_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Але няхай будзе слова вашае: “Так, так”, “Не, не”, а што больш таго, тое ад злога. ");
INSERT INTO beln_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Вы чулі, што сказана: “Вока за вока і зуб за зуб”. ");
INSERT INTO beln_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","А Я кажу вам: не праціўцеся злому, але, хто ўдарыць цябе ў правую шчаку тваю, павярні да яго і другую, ");
INSERT INTO beln_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","і хто захоча судзіцца з табою і ўзяць у цябе вопратку, аддай яму і шаты; ");
INSERT INTO beln_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","і хто прымусіць цябе ісьці з ім адну мілю, ідзі з ім дзьве. ");
INSERT INTO beln_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Таму, хто просіць у цябе, дай, і ад таго, хто хоча ў цябе пазычыць, не адварочвайся. ");
INSERT INTO beln_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Вы чулі, што сказана: “Любі бліжняга твайго і ненавідзь ворага твайго”. ");
INSERT INTO beln_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","А Я кажу вам: любіце ворагаў вашых, дабраслаўляйце тых, якія праклінаюць вас, рабіце дабро тым, якія ненавідзяць вас, і маліцеся за тых, якія крыўдзяць вас і перасьледуюць вас, ");
INSERT INTO beln_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","каб сталіся вы сынамі Айца вашага, Які ў небе, бо Ён узьнімае сонца Сваё над добрымі і злымі і спасылае дождж на праведных і няправедных. ");
INSERT INTO beln_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Бо калі вы любіце тых, якія вас любяць, якая вам нагарода? Ці ж ня так робяць і мытнікі? ");
INSERT INTO beln_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","І калі вы вітаеце толькі братоў вашых, што асаблівае робіце? Ці ж не такім чынам робяць і мытнікі? ");
INSERT INTO beln_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Дык будзьце ж дасканалымі, як дасканалы Айцец ваш, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Сьцеражыцеся, не рабіце міласьціны вашае перад людзьмі з тым, каб яны бачылі вас, бо тады ня будзеце мець нагароды ад Айца вашага, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Калі ж даеш міласьціну, не трубі перад сабою, як робяць крывадушнікі ў сынагогах і на вуліцах, каб людзі славілі іх. Сапраўды кажу вам: яны ўжо атрымоўваюць нагароду сваю. ");
INSERT INTO beln_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","У цябе ж, калі ты робіш міласьціну, няхай левая рука твая ня ведае, што робіць правая, ");
INSERT INTO beln_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","каб міласьціна твая была ўтоена, і Айцец твой, Які бачыць утоенае, дасьць табе яўна. ");
INSERT INTO beln_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","І калі молішся, ня будзь, як крывадушнікі, бо яны любяць у сынагогах і на вуглах вуліцаў, спыніўшыся, маліцца, каб паказацца перад людзьмі. Сапраўды кажу вам, што яны ўжо атрымоўваюць нагароду сваю. ");
INSERT INTO beln_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ты ж, калі молішся, увайдзі ў пакой твой і, зачыніўшы дзьверы твае, памаліся Айцу твайму, Які ўтоены, і Айцец твой, Які бачыць утоенае, дасьць табе яўна. ");
INSERT INTO beln_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","А молячыся, не гаварыце лішняга, як пагане, бо яны думаюць, што ў шматслоўі сваім будуць пачутыя. ");
INSERT INTO beln_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ня будзьце падобныя да іх, бо ведае Айцец ваш, у чым вы маеце патрэбу, раней, чым вы папросіце ў Яго. ");
INSERT INTO beln_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Маліцеся ж вось гэтак: “Ойча наш, Які ёсьць у небе! Сьвяціся імя Тваё; ");
INSERT INTO beln_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","прыйдзі Валадарства Тваё; будзь воля Твая як у небе, так і на зямлі. ");
INSERT INTO beln_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Хлеба нашага штодзённага дай нам сёньня. ");
INSERT INTO beln_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","І адпусьці нам правіны нашыя, як і мы адпускаем вінаватым нашым; ");
INSERT INTO beln_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","і ня ўводзь нас у спакусу, але збаў нас ад злога. Бо Тваё Валадарства, і моц, і слава навекі. Амэн”. ");
INSERT INTO beln_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Бо, калі вы будзеце адпускаць людзям грахі іхнія, то і вам адпусьціць Айцец ваш, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","А калі ня будзеце адпускаць людзям грахоў іхніх, то і Айцец ваш не адпусьціць грахоў вашых. ");
INSERT INTO beln_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","А калі посьціце, ня будзьце панурымі, быццам крывадушнікі; бо яны зьмяняюць абліччы свае, каб, посьцячыся, паказацца перад людзьмі. Сапраўды кажу вам, што яны ўжо атрымоўваюць нагароду сваю. ");
INSERT INTO beln_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","А ты, посьцячыся, памаж галаву тваю і абмый аблічча тваё, ");
INSERT INTO beln_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","каб ня перад людзьмі паказацца посьцячым, але перад Айцом тваім, Які ўтоены, і Айцец твой, Які бачыць утоенае, дасьць табе яўна. ");
INSERT INTO beln_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Не зьбірайце сабе скарбаў на зямлі, дзе моль і іржа нішчаць, і дзе злодзеі падкопваюць і крадуць; ");
INSERT INTO beln_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","але зьбірайце сабе скарбы ў небе, дзе ані моль, ані іржа ня нішчаць, і дзе злодзеі не падкопваюць і не крадуць. ");
INSERT INTO beln_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Бо дзе скарб ваш, там будзе і сэрца вашае. ");
INSERT INTO beln_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Сьветач цела ёсьць вока. Калі вока тваё чыстае, усё цела тваё будзе сьветлае. ");
INSERT INTO beln_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Калі ж вока тваё злое, усё цела тваё будзе цёмным. Калі ж сьвятло, якое ў табе, ёсьць цемра, дык якая ж цемра сама? ");
INSERT INTO beln_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ніхто ня можа служыць двум панам; бо ці аднаго будзе ненавідзець, а другога любіць, ці аднаго будзе трымацца, а другім пагарджаць. Ня можаце Богу служыць і мамоне. ");
INSERT INTO beln_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Таму кажу вам: не клапаціцеся пра душу вашую, што вам есьці і што піць, ані пра цела вашае, у што апрануцца. Ці ж душа ня большая за ежу, і цела — за адзеньне? ");
INSERT INTO beln_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Паглядзіце на птушак нябесных, што ані сеюць, ані жнуць і не зьбіраюць у сьвірны, і Айцец ваш Нябесны жывіць іх. Наколькі ж вы лепшыя за іх. ");
INSERT INTO beln_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Хто ж з вас сваім клопатам можа дадаць сабе росту хоць на адзін локаць? ");
INSERT INTO beln_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","І наконт адзеньня чаго клапоціцеся? Паглядзіце на палявыя лілеі, як яны растуць, не працуюць, не прадуць. ");
INSERT INTO beln_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","А Я кажу вам, што нават Салямон у-ва ўсёй славе сваёй не апранаўся так, як адна з іх. ");
INSERT INTO beln_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Калі ж траву на полі, якая сёньня ёсьць, а заўтра будзе кінутая ў печ, Бог так апранае, дык ці ня шмат больш вас, малаверы? ");
INSERT INTO beln_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Дык не клапаціцеся, кажучы: “Што нам есьці?”, ці: “Што нам піць?”, ці: “У што апрануцца?” ");
INSERT INTO beln_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Бо ўсяго гэтага шукаюць пагане. Бо Айцец ваш Нябесны ведае, што вам усё гэтае патрэбна. ");
INSERT INTO beln_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Шукайце ж перш Валадарства Божага і праведнасьці Яго, і тое ўсё дадасца вам. ");
INSERT INTO beln_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Дык не клапаціцеся пра заўтрашні дзень, бо заўтрашні дзень сам будзе клапаціцца пра сябе. Досыць дню свайго ліха. ");
INSERT INTO beln_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Не судзіце, каб не былі суджаныя. ");
INSERT INTO beln_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Бо якім судом судзіце, такім будзеце суджаны, і якою меркаю мераеце, гэткаю і вам адмераюць. ");
INSERT INTO beln_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Што ты глядзіш на сучок у воку брата твайго, а бервяна ў сваім воку ня бачыш? ");
INSERT INTO beln_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ці як скажаш брату твайму: “Дазволь, выму сучок з вока твайго”, а вось, у воку тваім — бервяно? ");
INSERT INTO beln_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Крывадушнік! Вымі перш бервяно з вока твайго, і тады ўбачыш, як выняць сучок з вока брата твайго. ");
INSERT INTO beln_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Не давайце сьвятога сабакам і ня кідайце пэрлаў вашых перад сьвіньнямі, каб яны не патапталі іх нагамі сваімі і, павярнуўшыся, не парвалі вас. ");
INSERT INTO beln_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Прасіце, і будзе вам дадзена; шукайце, і знойдзеце; стукайцеся, і адчыняць вам. ");
INSERT INTO beln_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Бо кожны, хто просіць, атрымлівае, і хто шукае, знаходзіць, і хто стукаецца, таму адчыняць. ");
INSERT INTO beln_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ці ёсьць між вамі чалавек, які, калі сын ягоны папросіць хлеба, дасьць яму камень? ");
INSERT INTO beln_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","І калі папросіць рыбы, дасьць яму зьмяю? ");
INSERT INTO beln_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Дык калі вы, будучы злымі, умееце добрыя дары даваць дзецям вашым, тым больш Айцец ваш, Які ў небе, дасьць добрае тым, што просяць у Яго. ");
INSERT INTO beln_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Дык усё, што хочаце, каб вам рабілі людзі, тое і вы ім рабіце; бо ў гэтым Закон і Прарокі. ");
INSERT INTO beln_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Уваходзьце праз цесную браму, бо шырокая брама і прасторны шлях, што вядуць да загубы, і шмат хто ўваходзіць праз іх, ");
INSERT INTO beln_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","бо цесная брама і вузкі шлях, што вядуць у жыцьцё, і мала хто знаходзіць іх. ");
INSERT INTO beln_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Сьцеражыцеся фальшывых прарокаў, якія прыходзяць да вас у авечым адзеньні, а ўнутры яны — ваўкі драпежныя. ");
INSERT INTO beln_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Паводле пладоў іхніх пазнаеце іх. Ці зьбіраюць з церняў вінаград або з асоту фігі? ");
INSERT INTO beln_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Гэтак усякае добрае дрэва дае плады добрыя, а благое дрэва дае плады дрэнныя. ");
INSERT INTO beln_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ня можа дрэва добрае даваць плады дрэнныя, ані благое дрэва даваць плады добрыя. ");
INSERT INTO beln_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Усякае дрэва, якое не дае добрага плоду, сьсякаюць і кідаюць у агонь. ");
INSERT INTO beln_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Таму паводле пладоў іхніх пазнаеце іх. ");
INSERT INTO beln_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ня кожны, хто кажа Мне: “Госпадзе! Госпадзе!”, увойдзе ў Валадарства Нябеснае, але той, хто выконвае волю Айца Майго, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Многія скажуць Мне ў той дзень: “Госпадзе, Госпадзе! Ці не ў Тваё імя мы прарочылі? І ці не ў Тваё імя выганялі дэманаў? І ці не ў Тваё імя шмат цудаў чынілі?” ");
INSERT INTO beln_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","І тады прызнаюся ім: “Я ніколі ня ведаў вас. Адыйдзіцеся ад Мяне, вы, што чыніце беззаконьне”. ");
INSERT INTO beln_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Дык кожнага, хто слухае гэтыя словы Мае і выконвае іх, прыраўняю да чалавека мудрага, які пабудаваў дом свой на скале. ");
INSERT INTO beln_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","І пайшоў дождж, і разьліліся рэкі, і падзьмулі вятры, і ўдарылі на дом той; і ён ня ўпаў, бо быў умацаваны на скале. ");
INSERT INTO beln_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","А кожны, хто слухае гэтыя словы Мае і не выконвае іх, будзе падобны да чалавека дурнога, які пабудаваў дом свой на пяску. ");
INSERT INTO beln_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","І пайшоў дождж, і разьліліся рэкі, і падзьмулі вятры, і ўдарылі на дом той, і ён упаў, і было падзеньне ягонае вялікае». ");
INSERT INTO beln_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","І сталася, калі Ісус скончыў гэтыя словы, натоўпы дзівіліся з вучэньня Ягонага, ");
INSERT INTO beln_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","бо Ён вучыў іх, як той, хто мае ўладу, і не як кніжнікі. ");
INSERT INTO beln_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Калі ж Ён зыйшоў з гары, пайшлі за Ім шматлікія натоўпы. ");
INSERT INTO beln_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","І вось пракажоны, падыйшоўшы, пакланіўся Яму, кажучы: «Госпадзе! Калі хочаш, можаш мяне ачысьціць». ");
INSERT INTO beln_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","І, працягнуўшы руку, Ісус дакрануўся да яго, кажучы: «Хачу, будзь ачышчаны». І ён адразу ачысьціўся ад праказы сваёй. ");
INSERT INTO beln_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","І кажа яму Ісус: «Глядзі, нікому не кажы, але пайдзі, пакажыся сьвятару і прынясі дар, які загадаў Майсей дзеля сьведчаньня ім». ");
INSERT INTO beln_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Калі ж увайшоў Ісус у Капэрнаум, падыйшоў да Яго сотнік, просячы Яго ");
INSERT INTO beln_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","і кажучы: «Госпадзе! Слуга мой ляжыць дома спараліжаваны і страшэнна мучыцца». ");
INSERT INTO beln_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","І кажа яму Ісус: «Я, прыйшоўшы, аздараўлю яго». ");
INSERT INTO beln_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","І, адказваючы, сотнік прамовіў: «Госпадзе! Я ня варты, каб Ты ўвайшоў пад дах мой, але скажы толькі слова, і будзе аздароўлены слуга мой. ");
INSERT INTO beln_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Бо і я чалавек, які пад уладаю, ды маю пад сабою жаўнераў, і кажу аднаму: “Ідзі”, і ён ідзе; і другому: “Прыйдзі”, і ён прыходзіць; і слузе майму: “Зрабі тое”, і ён робіць». ");
INSERT INTO beln_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Пачуўшы гэтае, Ісус зьдзівіўся і сказаў тым, якія за Ім ішлі: «Сапраўды кажу вам, нідзе ў Ізраілі Я не знайшоў гэткае веры. ");
INSERT INTO beln_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Кажу ж вам, што многія прыйдуць з усходу і захаду і ўзьлягуць з Абрагамам, і Ісаакам, і Якубам у Валадарстве Нябесным, ");
INSERT INTO beln_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","а сыны Валадарства будуць выгнаныя ў цемру вонкавую; там будзе плач і скрыгат зубоў». ");
INSERT INTO beln_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","І сказаў Ісус сотніку: «Ідзі, і, як ты паверыў, станецца табе». І паздаравеў слуга ягоны ў тую ж гадзіну. ");
INSERT INTO beln_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","І, прыйшоўшы ў дом Пятра, Ісус убачыў цешчу ягоную, якая ляжала ў гарачцы. ");
INSERT INTO beln_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","І Ён дакрануўся да рукі ейнай, і пакінула яе гарачка, і яна ўстала, і паслугавала ім. ");
INSERT INTO beln_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Калі ж надыйшоў вечар, прывялі да Яго шмат апанаваных дэманамі, і Ён выгнаў духаў словам, і ўсіх хворых аздаравіў, ");
INSERT INTO beln_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","каб споўнілася сказанае праз прарока Ісаю, які кажа: «Ён узяў нашыя нядужасьці і панёс хваробы». ");
INSERT INTO beln_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Убачыўшы ж навокал Сябе шматлікія натоўпы, Ісус загадаў адыйсьці на другі бок. ");
INSERT INTO beln_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","І, падыйшоўшы, адзін кніжнік сказаў Яму: «Настаўнік, я пайду за Табою, куды б Ты ні пайшоў». ");
INSERT INTO beln_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","І кажа яму Ісус: «Лісы маюць норы, і птушкі нябесныя — гнёзды, а Сын Чалавечы ня мае, дзе галаву схіліць». ");
INSERT INTO beln_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","А іншы з вучняў Ягоных сказаў Яму: «Госпадзе! Дазволь мне перш пайсьці і пахаваць бацьку майго». ");
INSERT INTO beln_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ісус жа сказаў яму: «Ідзі за Мною і пакінь мёртвым хаваць сваіх мёртвых». ");
INSERT INTO beln_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","І калі ўвайшоў Ён у човен, пайшлі за Ім вучні Ягоныя. ");
INSERT INTO beln_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","І вось, сталася вялікае ўзрушэньне на моры, так што хвалі залівалі човен, а Ён спаў. ");
INSERT INTO beln_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","І, падыйшоўшы, вучні Ягоныя пабудзілі Яго, кажучы: «Госпадзе! Збаў нас, мы гінем!» ");
INSERT INTO beln_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","І кажа ім: «Чаго вы палохаецеся, малаверы?» Тады, устаўшы, забараніў вятрам і мору, і сталася вялікая ціша. ");
INSERT INTO beln_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","А людзі зьдзіўляліся, кажучы: «Хто ж Ён, што і вятры, і мора слухаюцца Яго?» ");
INSERT INTO beln_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","І, калі Ён прыйшоў на другі бераг у край Гергесэнскі, перанялі Яго двое апанаваных дэманам, якія выйшлі з магілаў, страшэнна злыя, так што ніхто ня мог праходзіць тою дарогаю. ");
INSERT INTO beln_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","І вось яны закрычалі, кажучы: «Што нам і Табе, Ісусе, Сыне Божы? Ці Ты прыйшоў сюды перад часам мучыць нас?» ");
INSERT INTO beln_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Далёка ж ад іх пасьвіўся вялікі гурт сьвіняў. ");
INSERT INTO beln_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","А дэманы прасілі Яго, кажучы: «Калі нас выганяеш, дазволь нам адыйсьці ў гэты гурт сьвіняў». ");
INSERT INTO beln_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","І Ён сказаў ім: «Ідзіце». І тыя, выйшаўшы, адыйшлі ў гурт сьвіняў. І, вось, рынуўся ўвесь гурт сьвіняў са стромы ў мора, і загінуў у вадзе. ");
INSERT INTO beln_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","А тыя, што пасьвілі, уцяклі і, прыйшоўшы ў горад, паведамілі пра ўсё і пра тых, што былі апанаваныя дэманам. ");
INSERT INTO beln_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","І вось, увесь горад выйшаў насустрач Ісусу і, убачыўшы Яго, прасілі, каб зыйшоў ад межаў іхніх. ");
INSERT INTO beln_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","І, увайшоўшы ў човен, Ён пераплыў назад, і прыйшоў у Свой горад. ");
INSERT INTO beln_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","І вось, прынесьлі да Яго спараліжаванага, які ляжаў на ложку. І, бачачы веру іх, Ісус сказаў спараліжаванаму: «Будзь пэўным, дзіця! Адпускаюцца табе грахі твае». ");
INSERT INTO beln_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","І вось, некаторыя з кніжнікаў сказалі самі ў сабе: «Ён блюзьніць». ");
INSERT INTO beln_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","І, бачачы думкі іхнія, Ісус сказаў: «Чаму злое вы падумалі ў сэрцах вашых? ");
INSERT INTO beln_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Бо што лягчэй сказаць: “Адпускаюцца табе грахі”, ці сказаць: “Устань і хадзі”? ");
INSERT INTO beln_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Але, каб вы ведалі, што Сын Чалавечы мае ўладу на зямлі адпускаць грахі», — кажа тады спараліжаванаму: «Устань, вазьмі ложак твой і ідзі ў дом твой». ");
INSERT INTO beln_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","І, устаўшы, ён пайшоў у дом свой. ");
INSERT INTO beln_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Бачачы гэтае, натоўпы зьдзівіліся і славілі Бога, Які даў такую ўладу людзям. ");
INSERT INTO beln_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","І, праходзячы адтуль, Ісус убачыў чалавека, які сядзеў на мытні, званага Мацьвеем, і кажа яму: «Ідзі за Мною». І ён, устаўшы, пайшоў за Ім. ");
INSERT INTO beln_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","І сталася, як Ён узьлягаў у доме, вось, шмат мытнікаў і грэшнікаў, прыйшоўшы, узьляглі з Ісусам і вучнямі Ягонымі. ");
INSERT INTO beln_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","І фарысэі, якія бачылі гэта, сказалі вучням Ягоным: «Дзеля чаго Настаўнік ваш есьць з мытнікамі і грэшнікамі?» ");
INSERT INTO beln_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","А Ісус, пачуўшы, сказаў Ім: «Не здаровыя маюць патрэбу ў лекары, але хворыя. ");
INSERT INTO beln_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Пайдзеце ж, навучыцеся, што значыць: “Міласэрнасьці хачу, а не ахвяры”. Бо Я прыйшоў не праведнікаў, але грэшнікаў клікаць да навяртаньня». ");
INSERT INTO beln_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Тады прыходзяць да Яго вучні Янавы, кажучы: «Чаму мы і фарысэі шмат посьцім, а Твае вучні ня посьцяць?» ");
INSERT INTO beln_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","І сказаў ім Ісус: «Ня могуць плакаць сыны вясельля, пакуль з імі жаніх. Але прыйдуць дні, калі забяруць ад іх жаніха, і тады будуць посьціць. ");
INSERT INTO beln_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ніхто ж не прышывае латкі з новай тканіны да старога адзеньня, бо прышытае аддзярэцца ад адзеньня, і дзіра станецца большая. ");
INSERT INTO beln_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Не ўліваюць новага віна ў старыя мяхі, бо рвуцца мяхі, і віно выцякае, і мяхі гінуць; але новае віно ўліваюць у новыя мяхі, тады захоўваецца адно і другое». ");
INSERT INTO beln_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Калі Ён гаварыў ім гэта, вось, падыйшоўшы, начальнік пакланіўся Яму, кажучы: «Дачка мая цяпер памірае, але прыйдзі, ускладзі на яе руку Тваю, і яна ажыве». ");
INSERT INTO beln_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","І, устаўшы, Ісус пайшоў за ім, і вучні Ягоныя. ");
INSERT INTO beln_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","І вось, жанчына, якая дванаццаць гадоў хварэла на крывацечу, падыйшоўшы ззаду, дакранулася да краю шаты Ягонай, ");
INSERT INTO beln_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","бо яна казала ў сабе: «Калі толькі дакрануся да шаты Ягонай, буду выратаваная». ");
INSERT INTO beln_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ісус жа, павярнуўшыся і ўбачыўшы яе, сказаў: «Будзь пэўная, дачка! Вера твая збавіла цябе». І жанчына ў тую ж гадзіну паздаравела. ");
INSERT INTO beln_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","І, прыйшоўшы ў дом начальніка і ўбачыўшы жалейнікаў і ўзрушаны натоўп, ");
INSERT INTO beln_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ісус сказаў ім: «Адыйдзіцеся, бо не памерла дзяўчынка, але сьпіць». І сьмяяліся з Яго. ");
INSERT INTO beln_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Калі ж вывелі натоўп, Ён, увайшоўшы, узяў яе за руку, і дзяўчынка ўстала. ");
INSERT INTO beln_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","І разыйшлася чутка пра гэта па ўсёй той зямлі. ");
INSERT INTO beln_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","І калі Ісус ішоў адтуль, ішлі за Ім два сьляпыя, крычучы і кажучы: «Зьлітуйся над намі, Сыне Давідаў!» ");
INSERT INTO beln_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Калі ж Ён прыйшоў у дом, падыйшлі да Яго сьляпыя. І кажа ім Ісус: «Ці вы верыце, што Я магу гэтае зрабіць?» Кажуць яму: «Так, Госпадзе!» ");
INSERT INTO beln_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Тады Ён дакрануўся да вачэй іхніх, кажучы: «Паводле веры вашае няхай станецца вам». ");
INSERT INTO beln_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","І адчыніліся вочы іхнія. І Ісус грозна глянуў на іх, кажучы: «Глядзіце, каб ніхто ня ведаў». ");
INSERT INTO beln_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","А яны, выйшаўшы, шырылі вестку пра Яго па ўсёй той зямлі. ");
INSERT INTO beln_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Калі ж тыя выходзілі, вось прывялі да Яго чалавека нямога, апанаванага дэманам. ");
INSERT INTO beln_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","І, калі дэман быў выгнаны, нямы загаварыў, і натоўп зьдзіўляўся, кажучы: «Ніколі не здаралася гэткае ў Ізраілі». ");
INSERT INTO beln_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","А фарысэі казалі: «Праз князя дэманаў Ён выганяе дэманаў». ");
INSERT INTO beln_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","І абыходзіў Ісус усе гарады і мястэчкі, навучаючы ў сынагогах і абвяшчаючы Эвангельле Валадарства, і аздараўляючы ўсякую хваробу і ўсякую немач у народзе. ");
INSERT INTO beln_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Убачыўшы ж натоўпы, Ён зьлітаваўся над імі, што былі саслабелыя і расьцярушаныя, быццам авечкі, якія ня маюць пастуха. ");
INSERT INTO beln_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Тады кажа вучням Сваім: «Сапраўды, жніво багатае, а работнікаў мала. ");
INSERT INTO beln_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Дык прасіце Гаспадара жніва, каб выслаў работнікаў на жніво Сваё». ");
INSERT INTO beln_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","І, паклікаўшы дванаццаць вучняў Сваіх, Ён даў ім уладу над нячыстымі духамі, каб выганяць іх і аздараўляць усякую хваробу і ўсякую немач. ");
INSERT INTO beln_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","А дванаццаці апосталаў імёны такія: першы — Сымон, называны Пятром, і Андрэй, брат ягоны, Якуб Зэбэдэяў і Ян, брат ягоны, ");
INSERT INTO beln_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Філіп і Барталамей, Тамаш і Мацьвей мытнік, Якуб Алфеяў і Леўвей, якога звалі Тадэвушам, ");
INSERT INTO beln_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Сымон Кананіт і Юда Іскарыёт, які і выдаў Яго. ");
INSERT INTO beln_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Гэтых дванаццаць паслаў Ісус і загадаў ім, кажучы: «На шлях паганаў не ўзыходзьце і ў горад Самаранскі не ўваходзьце, ");
INSERT INTO beln_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","а ідзіце больш да авечак з дому Ізраіля, якія загінулі. ");
INSERT INTO beln_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ідучы ж, абвяшчайце, кажучы, што наблізілася Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Нядужых аздараўляйце, пракажоных ачышчайце, мёртвых уваскрашайце, дэманаў выганяйце. Дарма атрымалі, дарма давайце. ");
INSERT INTO beln_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Не бярыце з сабою ані золата, ані срэбра, ані медзі ў паясы вашыя, ");
INSERT INTO beln_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ані торбы на дарогу, ані дзьвюх вопратак, ані сандалаў, ані кія. Бо работнік варты ежы сваёй. ");
INSERT INTO beln_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","А ў які горад ці мястэчка ўвойдзеце, даведайцеся, хто ў ім дастойны, і там заставайцеся, пакуль ня выйдзеце. ");
INSERT INTO beln_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","А, уваходзячы ў дом, вітайце яго. ");
INSERT INTO beln_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","І, калі дом будзе сапраўды дастойны, супакой ваш прыйдзе на яго; а калі ня будзе дастойны, супакой ваш да вас вернецца. ");
INSERT INTO beln_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","І калі хто ня прыйме вас і ня будзе слухаць словаў вашых, то, выходзячы з дому ці з гораду таго, абтрасіце пыл з ног вашых. ");
INSERT INTO beln_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Сапраўды кажу вам: лягчэй будзе зямлі Садома і Гаморы ў дзень суду, чым гораду таму. ");
INSERT INTO beln_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Вось, Я пасылаю вас, як авечак сярод ваўкоў; дык будзьце мудрыя, як зьмеі, і шчырыя, як галубы. ");
INSERT INTO beln_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Сьцеражыцеся людзей, бо яны будуць выдаваць вас у сынэдрыёны і ў сынагогах сваіх будуць бічаваць вас. ");
INSERT INTO beln_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","І павядуць вас да ваяводаў і валадароў дзеля Мяне на сьведчаньне ім і паганам. ");
INSERT INTO beln_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Калі ж будуць выдаваць вас, не клапаціцеся пра тое, як ці што вам гаварыць, бо вам у тую гадзіну будзе дадзена, што гаварыць. ");
INSERT INTO beln_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Бо ня вы будзеце гаварыць, але Дух Айца вашага будзе гаварыць у вас. ");
INSERT INTO beln_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Выдасьць брат брата на сьмерць, і бацька — сына, і паўстануць дзеці на бацькоў, і пазабіваюць іх; ");
INSERT INTO beln_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","і будуць вас ненавідзець за імя Маё, але хто вытрывае да канца, збаўлены будзе. ");
INSERT INTO beln_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Калі ж будуць перасьледаваць вас у адным горадзе, уцякайце ў другі, бо сапраўды кажу вам: вы не абыйдзеце ўсіх гарадоў Ізраіля, як прыйдзе Сын Чалавечы. ");
INSERT INTO beln_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Вучань не вышэй за настаўніка свайго, і слуга не вышэй за гаспадара свайго. ");
INSERT INTO beln_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Досыць для вучня, каб ён стаўся як настаўнік ягоны, і для слугі, каб ён стаўся як гаспадар ягоны. Калі гаспадара дому назвалі Бэльзэбулам, тым больш хатніх яго. ");
INSERT INTO beln_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Дык ня бойцеся іх, бо няма нічога прыкрытага, каб не адкрылася, ані тайнага, каб ня сталася вядомым. ");
INSERT INTO beln_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Што кажу вам у цемры, кажыце пры сьвятле; і што чуеце на вуха, абвяшчайце з дахаў. ");
INSERT INTO beln_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","І ня бойцеся тых, што забіваюць цела, а душы забіць ня могуць; а бойцеся больш Таго, Хто можа і душу, і цела загубіць у гееньне. ");
INSERT INTO beln_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ці ж ня два вераб’і продаюцца за асар? І ніводзін з іх не ўпадзе на зямлю бяз волі Айца вашага. ");
INSERT INTO beln_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","А ў вас і валасы на галаве ўсе палічаны. ");
INSERT INTO beln_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Дык ня бойцеся, вы лепшыя за многіх вераб’ёў. ");
INSERT INTO beln_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Дык кожнага, хто Мяне прызнае перад людзьмі, таго і Я прызнаю перад Айцом Маім, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","А хто адрачэцца Мяне перад людзьмі, таго і Я адракуся перад Айцом Маім, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ня думайце, што Я прыйшоў прынесьці супакой на зямлю; не супакой прыйшоў Я прынесьці, але меч. ");
INSERT INTO beln_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Бо Я прыйшоў разлучыць чалавека з бацькам яго, і дачку — з маці яе, і нявестку — са сьвякрухай яе. ");
INSERT INTO beln_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","І ворагі чалавеку хатнія яго. ");
INSERT INTO beln_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Хто любіць бацьку ці маці больш за Мяне, ня варты Мяне; і хто любіць сына ці дачку больш за Мяне, ня варты Мяне. ");
INSERT INTO beln_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","І хто не бярэ крыжа свайго і ідзе за Мною, той ня варты Мяне. ");
INSERT INTO beln_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Хто знойдзе душу сваю, загубіць яе; а хто загубіць душу сваю дзеля Мяне, знойдзе яе. ");
INSERT INTO beln_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Хто прыймае вас, прыймае Мяне, а хто прыймае Мяне, прыймае Таго, Хто паслаў Мяне. ");
INSERT INTO beln_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Хто прыймае прарока ў імя прарока, дастане нагароду прарока; і хто прыймае праведніка ў імя праведніка, дастане нагароду праведніка. ");
INSERT INTO beln_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","І калі хто напоіць аднаго з малых гэтых толькі кубкам халоднай вады ў імя вучня, сапраўды кажу вам, ня страціць нагароды свае». ");
INSERT INTO beln_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","І сталася, як скончыў Ісус загадваць дванаццаці вучням Сваім, пайшоў адтуль вучыць і абвяшчаць у гарады іхнія. ");
INSERT INTO beln_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ян жа, пачуўшы ў вязьніцы пра дзеяньні Хрыста, паслаў двух вучняў сваіх ");
INSERT INTO beln_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","сказаць Яму: «Ці Ты — Той, Які прыходзіць, ці чакаць нам іншага?» ");
INSERT INTO beln_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","І, адказваючы, Ісус сказаў ім: «Ідзіце, паведаміце Яну, што чуеце і бачыце: ");
INSERT INTO beln_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","сьляпыя бачаць і кульгавыя ходзяць, пракажоныя ачышчаюцца і глухія чуюць, мёртвыя ўваскрасаюць і ўбогім дабравесьціцца. ");
INSERT INTO beln_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","І шчасьлівы той, хто ня згоршыцца праз Мяне». ");
INSERT INTO beln_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Калі ж тыя пайшлі, Ісус пачаў гаварыць да натоўпаў пра Яна: «Што глядзець хадзілі вы ў пустыню? Ці трысьціну, якую вецер хістае? ");
INSERT INTO beln_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Але што хадзілі вы ўбачыць? Ці чалавека, апранутага ў мяккія шаты? Вось, тыя, што носяць мяккія шаты, знаходяцца ў дамах валадарскіх. ");
INSERT INTO beln_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Але што хадзілі вы ўбачыць? Прарока? Так, кажу вам, і больш за прарока. ");
INSERT INTO beln_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Бо ён ёсьць той, пра якога напісана: “Вось, Я пасылаю анёла Майго перад абліччам Тваім, які пракладзе шлях Твой перад Табою”. ");
INSERT INTO beln_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Сапраўды кажу вам: Сярод народжаных жанчынамі не паўставаў большы за Яна Хрысьціцеля, але найменшы ў Валадарстве Нябесным большы за яго. ");
INSERT INTO beln_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ад дзён Яна Хрысьціцеля дагэтуль Валадарства Нябеснае сілаю здабываецца, і людзі гвалтоўныя захопліваюць яго. ");
INSERT INTO beln_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Бо ўсе Прарокі і Закон прарочылі да Яна. ");
INSERT INTO beln_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","І калі маеце прыняць, ён ёсьць Ільля, якому належыць прыйсьці. ");
INSERT INTO beln_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Хто мае вушы слухаць, няхай слухае. ");
INSERT INTO beln_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Да каго прыраўняю пакаленьне гэтае? Яно падобнае да дзяцей, якія сядзяць на вуліцы і клічуць да таварышаў сваіх, ");
INSERT INTO beln_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","і кажуць: “Мы гралі вам на жалейцы, і вы не скакалі; мы галасілі, і вы ня плакалі”. ");
INSERT INTO beln_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Бо прыйшоў Ян, ня есьць, ня п’е, і кажуць: “Дэмана мае”. ");
INSERT INTO beln_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Прыйшоў Сын Чалавечы, есьць і п’е; і кажуць: “Вось, чалавек — абжора і п’яніца, сябра мытнікаў і грэшнікаў”. І апраўдана мудрасьць дзецьмі яе». ");
INSERT INTO beln_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Тады пачаў Ён дакараць гарады, у якіх найбольш сталася цудаў Ягоных, за тое, што яны не навярнуліся: ");
INSERT INTO beln_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Гора табе, Харазін! Гора табе, Бэтсаіда! Бо калі б у Тыры і Сідоне сталіся цуды, якія былі стаўшыся ў вас, даўно б яны ў зрэбніцы і ў попеле навярнуліся. ");
INSERT INTO beln_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Аднак кажу вам: Тыру і Сідону лягчэй будзе ў дзень суду, чым вам. ");
INSERT INTO beln_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","І ты, Капэрнаум, які да неба ўзьнёсся, у пекла скінуты будзеш, бо калі б у Садоме сталіся цуды, якія былі стаўшыся ў табе, ён застаўся б да гэтага дня. ");
INSERT INTO beln_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Аднак кажу вам, што зямлі Садомскай лягчэй будзе ў дзень суду, чым табе». ");
INSERT INTO beln_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","У той час, адказваючы, Ісус сказаў: «Вызнаю Цябе, Ойча, Госпадзе неба і зямлі, што Ты схаваў гэтае ад мудрых і разумных, і адкрыў немаўлятам. ");
INSERT INTO beln_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Так, Айцец, бо гэтак было даспадобы Табе. ");
INSERT INTO beln_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Усё Мне аддадзена Айцом Маім, і ніхто не спазнаў Сына, акрамя Айца; і ніхто не спазнаў Айца, акрамя Сына і каму Сын пастанавіў адкрыць. ");
INSERT INTO beln_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Прыйдзіце да Мяне ўсе спрацаваныя і абцяжараныя, і Я дам вам супачынак. ");
INSERT INTO beln_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Вазьміце ярмо Маё на сябе і навучыцеся ад Мяне, бо Я — ціхі і пакорнага сэрца, і знойдзеце супачынак душам вашым. ");
INSERT INTO beln_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Бо ярмо Маё добрае, і цяжар Мой лёгкі». ");
INSERT INTO beln_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","У той час праходзіў Ісус у суботу праз палеткі. Вучні ж Ягоныя былі галодныя і пачалі зрываць каласы і есьці. ");
INSERT INTO beln_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","А фарысэі, убачыўшы гэтае, сказалі Яму: «Вось, вучні Твае робяць, што ня сьлед рабіць у суботу». ");
INSERT INTO beln_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ён жа сказаў ім: «Ці ж вы не чыталі, што зрабіў Давід, калі быў галодны сам і тыя, што з ім? ");
INSERT INTO beln_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Як ён увайшоў у дом Божы і еў хлябы пакладныя, якіх не належала есьці ані яму, ані тым, што з ім былі, а толькі адным сьвятарам? ");
INSERT INTO beln_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Альбо ці не чыталі вы ў Законе, што ў суботы сьвятары ў сьвятыні парушаюць суботу, і бязьвінныя? ");
INSERT INTO beln_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Кажу ж вам, што тут ёсьць большы за сьвятыню. ");
INSERT INTO beln_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Калі б вы разумелі, што значыць: “Міласэрнасьці хачу, а не ахвяры”, не асудзілі б бязьвінных. ");
INSERT INTO beln_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Бо Сын Чалавечы ёсьць Гаспадар і суботы». ");
INSERT INTO beln_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","І, адыйшоўшы адтуль, Ён увайшоў у сынагогу іхнюю. ");
INSERT INTO beln_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","І вось, быў чалавек, які меў сухую руку. І спыталіся ў Яго, каб абвінаваціць Яго, кажучы: «Ці належыцца аздараўляць у суботу?» ");
INSERT INTO beln_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ён жа сказаў ім: «Ці ёсьць сярод вас чалавек, які мае адну авечку, і калі яна ў суботу ўпадзе ў яму, ці ня возьме ён яе і ня выцягне? ");
INSERT INTO beln_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Дык на колькі чалавек лепшы за авечку? Так што можна ў суботу рабіць дабро». ");
INSERT INTO beln_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Тады кажа таму чалавеку: «Выцягні руку тваю!» І той выцягнуў, і зрабілася яна здаровая, як другая. ");
INSERT INTO beln_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","А фарысэі, выйшаўшы, учынілі нараду супраць Яго, каб Яго загубіць. ");
INSERT INTO beln_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Але Ісус, даведаўшыся, пайшоў адтуль; і пайшлі за Ім вялікія натоўпы, і Ён аздаравіў іх усіх. ");
INSERT INTO beln_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","І забараніў ім, каб не выяўлялі Яго, ");
INSERT INTO beln_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","каб споўнілася сказанае праз прарока Ісаю, які кажа: ");
INSERT INTO beln_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Вось, Юнак Мой, Якога Я выбраў, Улюбёны Мой, у Якім мае ўпадабаньне душа Мая. Ускладу Дух Мой на Яго, і абвесьціць народам суд. ");
INSERT INTO beln_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ня будзе сварыцца, ані крычаць, і ніхто не пачуе на вуліцах голасу Яго. ");
INSERT INTO beln_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Трысьціны надламанай не пераломіць і лёну, што дыміцца, не загасіць, пакуль ня дасьць суду перамогі. ");
INSERT INTO beln_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","І на імя Ягонае будуць спадзявацца народы». ");
INSERT INTO beln_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Тады прывялі да Яго апанаванага дэманам сьляпога і нямога, і Ён аздаравіў яго, так што сьляпы і нямы стаў і гаварыць, і бачыць. ");
INSERT INTO beln_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","І дзівіліся ўсе натоўпы, і казалі: «Ці ня гэта Сын Давідаў?» ");
INSERT INTO beln_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","А фарысэі, пачуўшы, казалі: «Ён выганяе дэманаў не іначай, як праз Бэльзэбула, князя дэманаў». ");
INSERT INTO beln_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","А Ісус, ведаючы думкі іхнія, сказаў ім: «Усякае валадарства, якое разьдзялілася само ў сабе, апусьцее; і ўсякі горад ці дом, які разьдзяліўся сам у сабе, ня ўстоіць. ");
INSERT INTO beln_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","І калі шатан шатана выганяе, ён разьдзяліўся сам у сабе. Як можа ўстаяць валадарства ягонае? ");
INSERT INTO beln_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","І, калі Я праз Бэльзэбула выганяю дэманаў, дык сыны вашыя праз каго выганяюць? Дзеля гэтага яны будуць вам судзьдзямі. ");
INSERT INTO beln_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","А калі Я Духам Божым выганяю дэманаў, значыцца, дасягнула вас Валадарства Божае. ");
INSERT INTO beln_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Або як можа хто ўвайсьці ў дом асілка і абрабаваць рэчы ягоныя, калі раней ня зьвяжа асілка, і тады абрабуе дом ягоны. ");
INSERT INTO beln_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Хто не са Мною, той супраць Мяне; і хто не зьбірае са Мною, той раскідвае. ");
INSERT INTO beln_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Дзеля гэтага кажу вам: усякі грэх і блюзьнерства будзе адпушчана людзям, а блюзьнерства на Духа ня будзе адпушчана людзям. ");
INSERT INTO beln_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","І калі хто скажа слова супраць Сына Чалавечага, будзе адпушчана яму; а калі хто скажа супраць Духа Сьвятога, ня будзе адпушчана яму ані ў гэтым веку, ані ў будучым. ");
INSERT INTO beln_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Або ўчыніце дрэва добрым і плод ягоны добрым, або ўчыніце дрэва благім і плод ягоны благім, бо дрэва пазнаецца паводле пладоў. ");
INSERT INTO beln_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Спараджэньне яхідны! Як вы можаце гаварыць добрае, калі вы злыя? Бо з перапоўненага сэрца гавораць вусны. ");
INSERT INTO beln_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Добры чалавек з добрага скарбу сэрца выносіць добрае, а злы чалавек са злога скарбу выносіць злое. ");
INSERT INTO beln_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Кажу ж вам, што ўсякае пустое слова, якое скажуць людзі, аддасцца ім у дзень суду. ");
INSERT INTO beln_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Бо паводле словаў сваіх будзеш апраўданы і паводле словаў сваіх будзеш асуджаны». ");
INSERT INTO beln_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Тады адказалі некаторыя з кніжнікаў і фарысэяў, кажучы: «Настаўнік! Хочам бачыць ад Цябе знак». ");
INSERT INTO beln_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ён жа, адказваючы, сказаў ім: «Пакаленьне злое і чужаложнае шукае знакаў, і знакі ня будуць дадзены яму, апрача знаку Ёны прарока. ");
INSERT INTO beln_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Бо як Ёна быў у чэраве кіта тры дні і тры ночы, так і Сын Чалавечы будзе ў сэрцы зямлі тры дні і тры ночы. ");
INSERT INTO beln_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Нініўцы ўстануць на суд з пакаленьнем гэтым і асудзяць яго, бо яны навярнуліся праз пропаведзь Ёны; і вось, тут большы за Ёну. ");
INSERT INTO beln_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Валадарка з Поўдня паўстане на суд з пакаленьнем гэтым і асудзіць яго, бо яна прыходзіла з краю зямлі паслухаць мудрасьці Салямона; і вось, тут большы за Салямона. ");
INSERT INTO beln_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Калі нячысты дух выйдзе з чалавека, праходзіць праз бязводныя месцы, шукаючы супачынку, і не знаходзіць. ");
INSERT INTO beln_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Тады кажа: “Вярнуся ў дом мой, адкуль я выйшаў”. І, прыйшоўшы, знаходзіць яго незанятым, вымеценым і прыбраным. ");
INSERT INTO beln_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Тады ідзе і бярэ з сабою сем іншых духаў, зьлейшых за сябе, і, увайшоўшы, жывуць там; і для чалавека таго апошняе стаецца горш за першае. Так будзе і з гэтым пакаленьнем злым». ");
INSERT INTO beln_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Калі ж Ён яшчэ гаварыў да натоўпаў, вось, маці і браты Ягоныя сталі вонкі, шукаючы гаварыць з Ім. ");
INSERT INTO beln_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","А нехта сказаў Яму: «Вось маці Твая і браты Твае стаяць вонкі, шукаючы гаварыць з Табою». ");
INSERT INTO beln_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ён жа, адказваючы, сказаў таму, які гаварыў з Ім: «Хто маці Мая, і хто браты Мае?» ");
INSERT INTO beln_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","І, выцягнуўшы руку Сваю на вучняў Сваіх, сказаў: «Вось маці Мая і браты Мае. ");
INSERT INTO beln_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Бо хто выконвае волю Айца Майго, Які ў небе, той Мне брат, і сястра, і маці». ");
INSERT INTO beln_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","У той самы дзень, выйшаўшы з дому, Ісус сеў ля мора. ");
INSERT INTO beln_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","І сабраліся да Яго шматлікія натоўпы, так што Ён увайшоў у човен і сеў, а ўвесь натоўп стаяў на беразе. ");
INSERT INTO beln_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","І гаварыў ім шмат у прыповесьцях, кажучы: «Вось, выйшаў сейбіт сеяць. ");
INSERT INTO beln_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","І калі сеяў, адны зярняты ўпалі пры дарозе, і наляцелі птушкі, і падзяўблі іх. ");
INSERT INTO beln_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Іншыя ж упалі на камяністае месца, дзе не было шмат зямлі; і адразу ўзыйшлі, бо зямля была неглыбокая, ");
INSERT INTO beln_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","а калі ўзыйшло сонца, зьвялі і, як ня мелі кораня, высахлі. ");
INSERT INTO beln_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Іншыя ж упалі ў церні, і вырасьлі церні, і заглушылі іх. ");
INSERT INTO beln_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","А іншыя ўпалі ў добрую зямлю і далі плод: адно — сто, адно — шэсьцьдзесят, а адно — трыццаць. ");
INSERT INTO beln_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Хто мае вушы, каб слухаць, няхай слухае». ");
INSERT INTO beln_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","І, падыйшоўшы, вучні сказалі Яму: «Дзеля чаго гаворыш ім у прыповесьцях?» ");
INSERT INTO beln_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","А Ён, адказваючы, сказаў ім: «Бо вам дадзена ведаць таямніцы Валадарства Нябеснага, а ім ня дадзена. ");
INSERT INTO beln_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Бо хто мае, таму дадзена будзе і памножыцца, а хто ня мае, у таго адымецца і тое, што мае. ");
INSERT INTO beln_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Дзеля таго гавару ім у прыповесьцях, што яны, гледзячы, ня бачаць і, слухаючы, ня чуюць, і не разумеюць. ");
INSERT INTO beln_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","І спаўняецца над імі прароцтва Ісаі, якое кажа: “Слыхам пачуеце, і не зразумееце, і, гледзячы, глядзець будзеце, і ня ўбачыце. ");
INSERT INTO beln_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Бо атлусьцела сэрца народу гэтага, і вушамі з цяжкасьцю чуюць, і вочы свае заплюшчылі, каб ня ўбачылі вачыма, і не пачулі вушамі, і не зразумелі сэрцам, і не навярнуліся, каб Я аздаравіў іх” . ");
INSERT INTO beln_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Вашыя ж шчасьлівыя вочы, што бачаць, і вушы вашыя, што чуюць. ");
INSERT INTO beln_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Бо сапраўды кажу вам, што многія прарокі і праведнікі жадалі ўбачыць, што вы бачыце, і ня бачылі, і пачуць, што вы чуеце, і ня чулі. ");
INSERT INTO beln_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","А вы паслухайце прыповесьць пра сейбіта. ");
INSERT INTO beln_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Да ўсякага, хто чуе слова пра Валадарства і не разумее, прыходзіць злы і крадзе пасеянае ў сэрцы ягоным; гэта тое, што пасеянае пры дарозе. ");
INSERT INTO beln_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","А пасеянае на камяністае месца — гэта той, хто чуе слова і адразу з радасьцю прыймае яго, ");
INSERT INTO beln_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","але ня мае ў сабе кораня і нетрывалы: калі надыходзіць прыгнёт ці перасьлед дзеля слова, адразу горшыцца. ");
INSERT INTO beln_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","А пасеянае ў цярніне — гэта той, хто чуе слова, але клопаты веку гэтага і падман багацьця заглушаюць слова, і яно стаецца бясплодным. ");
INSERT INTO beln_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","А пасеянае ў добрую зямлю — гэта той, хто чуе слова і разумее, які дае плод, і дае адзін сто, а іншы — шэсьцьдзесят, а іншы — трыццаць». ");
INSERT INTO beln_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Іншую прыповесьць даў Ён ім, кажучы: «Падобнае Валадарства Нябеснае да чалавека, які пасеяў добрае насеньне на полі сваім. ");
INSERT INTO beln_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Калі ж людзі спалі, прыйшоў вораг ягоны, і пасеяў між пшаніцаю кукаль, і пайшоў. ");
INSERT INTO beln_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Калі ж узыйшла рунь і дала плод, тады паказаўся і кукаль. ");
INSERT INTO beln_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Прыйшоўшы ж, слугі гаспадара дому сказалі яму: “Пане, ці ж ня добрае насеньне пасеяў ты на полі тваім? Адкуль тады кукаль?” ");
INSERT INTO beln_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ён жа сказаў ім: “Вораг чалавек зрабіў гэтае”. А слугі сказалі яму: “Дык хочаш, мы пойдзем зьбярэм яго?” ");
INSERT INTO beln_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","А ён мовіў: “Не, каб, зьбіраючы кукаль, вы не павырывалі разам з ім і пшаніцы. ");
INSERT INTO beln_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Пакіньце расьці разам тое і другое да жніва; і ў час жніва я скажу жняцам: 'Зьбярыце спачатку кукаль і зьвяжыце яго ў снапы, каб спаліць іх, а пшаніцу зьбярыце ў сьвіран мой'”». ");
INSERT INTO beln_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Іншую прыповесьць даў Ён ім, кажучы: «Падобнае Валадарства Нябеснае да зярняці гарчычнага, якое чалавек, узяўшы, пасеяў на полі сваім. ");
INSERT INTO beln_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Яно меншае за ўсякае насеньне, а калі вырасьце — большае за ўсе расьліны і становіцца дрэвам, так што прылятаюць птушкі нябесныя і хаваюцца ў галінах яго». ");
INSERT INTO beln_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Іншую прыповесьць сказаў Ён ім: «Падобнае Валадарства Нябеснае да рашчыны, якую жанчына, узяўшы, умяшала ў тры меры мукі, пакуль ня ўкісла ўсё». ");
INSERT INTO beln_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Усё гэтае Ісус гаварыў да натоўпаў у прыповесьцях і без прыповесьці не гаварыў ім, ");
INSERT INTO beln_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","каб споўнілася сказанае праз прарока, які кажа: «Адчыню ў прыповесьцях вусны Мае; выкажу схаванае ад стварэньня сьвету». ");
INSERT INTO beln_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Тады Ісус, пакінуўшы натоўпы, увайшоў у дом, і падыйшлі да Яго вучні Ягоныя, кажучы: «Растлумач нам прыповесьць пра кукаль на полі». ");
INSERT INTO beln_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ён жа, адказваючы, сказаў ім: «Сейбіт добрага насеньня — гэта Сын Чалавечы. ");
INSERT INTO beln_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Поле — гэта сьвет, добрае насеньне — гэта сыны Валадарства, а кукаль — сыны злога; ");
INSERT INTO beln_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","вораг, які пасеяў іх, — гэта д’ябал, жніво — сканчэньне веку, а жняцы — анёлы. ");
INSERT INTO beln_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Бо як зьбіраюць кукаль і агнём паляць, так будзе пры сканчэньні веку гэтага: ");
INSERT INTO beln_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","пашле Сын Чалавечы анёлаў Сваіх, і зьбяруць з Валадарства Ягонага ўсе згаршэньні і ўсіх, хто чыніць беззаконьне. ");
INSERT INTO beln_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","І ўкінуць іх у печ вогненную, там будзе плач і скрыгат зубоў. ");
INSERT INTO beln_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Тады праведнікі зазьяюць, як сонца, у Валадарстве Айца іхняга. Хто мае вушы, каб слухаць, няхай слухае. ");
INSERT INTO beln_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Яшчэ падобнае Валадарства Нябеснае да скарбу, схаванага ў полі, які, знайшоўшы, чалавек схаваў, і ў радасьці сваёй ідзе, і прадае ўсё, што мае, і купляе тое поле. ");
INSERT INTO beln_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Яшчэ падобнае Валадарства Нябеснае да чалавека купца, які шукае добрых пэрлінаў, ");
INSERT INTO beln_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","які, знайшоўшы адну каштоўную пэрліну, пайшоў, прадаў усё, што меў, і купіў яе. ");
INSERT INTO beln_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Яшчэ падобнае Валадарства Нябеснае да нерату, які закінуты ў мора і сабраў усякага роду рыбы. ");
INSERT INTO beln_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Калі ён напоўніўся, выцягнуўшы яго на бераг і сеўшы, добрую сабралі ў пасудзіны, а благую выкінулі вонкі. ");
INSERT INTO beln_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Так будзе пры сканчэньні веку: выйдуць анёлы, і аддзеляць злых спасярод праведных, ");
INSERT INTO beln_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","і ўкінуць іх у печ вогненную, там будзе плач і скрыгат зубоў». ");
INSERT INTO beln_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Кажа ім Ісус: «Ці зразумелі вы ўсё гэтае?» Яны кажуць Яму: «Так, Госпадзе!» ");
INSERT INTO beln_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ён жа сказаў ім: «Дзеля гэтага ўсякі кніжнік, навучаны пра Валадарства Нябеснае, падобны да гаспадара дому, які выносіць са скарбу свайго новае і старое». ");
INSERT INTO beln_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","І сталася, калі скончыў Ісус прыповесьці гэтыя, Ён выйшаў адтуль. ");
INSERT INTO beln_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","І, прыйшоўшы ў бацькаўшчыну Сваю, навучаў іх у сынагозе іхняй, так што яны дзівіліся і гаварылі: «Адкуль у Яго гэткая мудрасьць і моц? ");
INSERT INTO beln_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ці ж ня цесьляў Ён сын? Ці не Ягоная маці завецца Марыя, і браты Ягоныя — Якуб, і Ёсія, і Сымон, і Юда? ");
INSERT INTO beln_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","І сёстры Ягоныя ці ж ня ўсе сярод нас? Адкуль жа ў Яго ўсё гэтае?» ");
INSERT INTO beln_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","І горшыліся дзеля Яго. А Ісус сказаў ім: «Няма прарока без пашаны, хіба толькі ў бацькаўшчыне сваёй і ў доме сваім». ");
INSERT INTO beln_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","І не ўчыніў там шмат цудаў дзеля недаверства іхняга. ");
INSERT INTO beln_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","У той час пачуў Ірад тэтрарх чутку пра Ісуса ");
INSERT INTO beln_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","і сказаў слугам сваім: «Гэта Ян Хрысьціцель; ён уваскрошаны з мёртвых, і дзеля гэтага цуды дзеюцца праз яго». ");
INSERT INTO beln_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Бо Ірад, схапіўшы Яна, увязьніў яго і пасадзіў у вязьніцу за Ірадыяду, жонку Філіпа, брата свайго, ");
INSERT INTO beln_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","бо Ян казаў яму: «Не належыцца табе мець яе». ");
INSERT INTO beln_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","І, хочучы забіць яго, баяўся натоўпу, бо яго мелі за прарока. ");
INSERT INTO beln_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","А калі Ірад спраўляў урадзіны, дачка Ірадыяды таньчыла пасярод іх і спадабалася Іраду. ");
INSERT INTO beln_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Таму ён з прысягаю паабяцаў ёй даць, чаго б ні папрасіла. ");
INSERT INTO beln_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Яна ж, падвучаная маці сваёй, сказала: «Дай мне тут на місе галаву Яна Хрысьціцеля». ");
INSERT INTO beln_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","І засумаваў валадар, але дзеля прысягі і тых, што ўзьлягалі з ім, загадаў даць. ");
INSERT INTO beln_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","І паслаў адсячы галаву Яну ў вязьніцы. ");
INSERT INTO beln_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","І прынесьлі галаву яго на місе, і далі дзяўчыне, і яна занесла маці сваёй. ");
INSERT INTO beln_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","І вучні ягоныя, прыйшоўшы, узялі цела і пахавалі яго; і, пайшоўшы, паведамілі Ісусу. ");
INSERT INTO beln_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","І, пачуўшы, Ісус адыйшоў адтуль на чаўне ў пустыннае месца адзін, і натоўп, пачуўшы тое, пайшоў за Ім з гарадоў пехатою. ");
INSERT INTO beln_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","І, выйшаўшы, Ісус убачыў шматлікія натоўпы, і зьлітаваўся над імі, і аздаравіў нямоглых іхніх. ");
INSERT INTO beln_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","А калі настаў вечар, падыйшлі да Яго вучні Ягоныя, кажучы: «Тут месца пустыннае, і гадзіна ўжо позьняя; адпусьці натоўпы, каб, пайшоўшы ў мястэчкі, купілі сабе ежы». ");
INSERT INTO beln_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","А Ісус сказаў ім: «Ня трэба ім ісьці. Вы дайце ім есьці». ");
INSERT INTO beln_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Яны ж кажуць Яму: «Нічога тут ня маем, толькі пяць хлябоў і дзьве рыбы». ");
INSERT INTO beln_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","А Ён сказаў: «Прынясіце Мне іх сюды». ");
INSERT INTO beln_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","І, загадаўшы натоўпам узьлегчы на траве, узяў пяць хлябоў і дзьве рыбы, і, зірнуўшы ў неба, дабраславіў і, паламаўшы, даў вучням хлеб, а вучні — натоўпу. ");
INSERT INTO beln_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","І елі ўсе, і насыціліся; і сабралі кавалкаў, што засталіся, дванаццаць поўных кашоў. ");
INSERT INTO beln_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","А тых, што елі, было каля пяці тысячаў мужчынаў, акрамя жанчынаў і дзяцей. ");
INSERT INTO beln_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","І адразу змусіў Ісус вучняў Сваіх увайсьці ў човен і плысьці перш за Яго на другі бок, пакуль Ён адпусьціць натоўпы. ");
INSERT INTO beln_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","І, адпусьціўшы натоўпы, Ён узыйшоў на гару памаліцца насамоце; і, як надыйшоў вечар, быў там адзін. ");
INSERT INTO beln_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","А човен ужо быў пасярод мора, кіданы хвалямі, бо вецер быў супраціўны. ");
INSERT INTO beln_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","А ў чацьвёртую варту ночы пайшоў да іх Ісус, ідучы па моры. ");
INSERT INTO beln_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","І вучні, убачыўшы Яго, як ішоў па моры, стрывожыліся, кажучы: «Гэта здань», і ад страху закрычалі. ");
INSERT INTO beln_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ісус жа адразу загаварыў з імі, кажучы: «Будзьце пэўныя, гэта Я; ня бойцеся». ");
INSERT INTO beln_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Адказваючы ж Яму, Пётар сказаў: «Госпадзе! Калі гэта Ты, загадай мне ісьці да Цябе па вадзе». ");
INSERT INTO beln_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ён жа сказаў: «Ідзі». І, выйшаўшы з чаўна, Пётар пайшоў па вадзе, ідучы да Ісуса. ");
INSERT INTO beln_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Але, бачачы моцны вецер, спалохаўся і, пачаўшы тануць, закрычаў, кажучы: «Госпадзе, ратуй мяне!» ");
INSERT INTO beln_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","А Ісус адразу, працягнуўшы руку, схапіў яго і кажа яму: «Малаверны! Чаму ты засумняваўся?» ");
INSERT INTO beln_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","І калі ўвайшлі яны ў човен, вецер сьціх. ");
INSERT INTO beln_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","А тыя, што былі ў чаўне, падыйшоўшы, пакланіліся Яму, кажучы: «Сапраўды, Ты — Сын Божы!» ");
INSERT INTO beln_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","І, пераплыўшы, прыйшлі ў зямлю Генэсарэцкую. ");
INSERT INTO beln_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","І людзі тамтэйшыя, пазнаўшы Яго, паслалі ва ўсю ваколіцу тую, і прынесьлі да Яго ўсіх хворых. ");
INSERT INTO beln_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","І прасілі Яго, каб толькі дакрануцца да краю адзеньня Ягонага; і ўсе, якія дакрануліся, былі аздароўленыя. ");
INSERT INTO beln_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Тады прыходзяць да Ісуса з Ерусаліму кніжнікі і фарысэі, кажучы: ");
INSERT INTO beln_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Чаму вучні Твае адступаюцца ад традыцыяў старэйшых? Бо ня мыюць рукі свае, калі ядуць хлеб». ");
INSERT INTO beln_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ён жа, адказваючы, сказаў ім: «Чаму і вы адступаецеся ад прыказаньня Божага дзеля традыцыяў вашых? ");
INSERT INTO beln_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Бо Бог загадаў, кажучы: “Шануй бацьку твайго і маці”, і: “Хто праклінае бацьку ці маці, няхай сьмерцю памрэ”. ");
INSERT INTO beln_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","А вы кажаце: “Калі хто скажа бацьку або маці: 'Дар Богу тое, чым ты ад мяне карыстаўся', ");
INSERT INTO beln_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","той можа і не шанаваць бацьку свайго ці маці сваю”. І вы пазбавілі сілы прыказаньне Божае дзеля традыцыяў вашых. ");
INSERT INTO beln_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Крывадушнікі! Слушна прарочыў пра вас Ісая, кажучы: ");
INSERT INTO beln_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Народ гэты набліжаецца да Мяне вуснамі сваімі і губамі шануе Мяне; а сэрца іхняе трымаецца далёка ад Мяне. ");
INSERT INTO beln_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Але марна пакланяюцца Мне, навучаючы вучэньняў і пастановаў чалавечых”». ");
INSERT INTO beln_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","І, паклікаўшы натоўп, сказаў ім: «Слухайце і разумейце: ");
INSERT INTO beln_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ня тое, што ўваходзіць у вусны, апаганьвае чалавека, але тое, што выходзіць з вуснаў, апаганьвае чалавека». ");
INSERT INTO beln_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Тады вучні Ягоныя, падыйшоўшы, казалі Яму: «Ці ведаеш, што фарысэі, пачуўшы слова гэтае, згоршыліся?» ");
INSERT INTO beln_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ён жа, адказваючы, сказаў: «Усякая расьліна, якую не пасадзіў Айцец Мой Нябесны, будзе выкарчавана. ");
INSERT INTO beln_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Пакіньце іх; яны — сьляпыя павадыры сьляпых; а калі сьляпы вядзе сьляпога, абодва ўваляцца ў яму». ");
INSERT INTO beln_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Пётар жа, адказваючы, сказаў Яму: «Растлумач нам прыповесьць гэтую». ");
INSERT INTO beln_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","А Ісус сказаў: «Няўжо і вы такія няцямкія? ");
INSERT INTO beln_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ці ж яшчэ не разумееце, што ўсё, што ўваходзіць у вусны, трапляе ў жывот і выкідаецца прэч? ");
INSERT INTO beln_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","А тое, што выходзіць з вуснаў, — з сэрца выходзіць; гэта апаганьвае чалавека, ");
INSERT INTO beln_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","бо з сэрца выходзяць злыя думкі, забойствы, распуснасьць, чужалоства, крадзяжы, фальшывыя сьведчаньні, блюзьнерствы. ");
INSERT INTO beln_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Гэта апаганьвае чалавека, а есьці нямытымі рукамі не апаганьвае чалавека». ");
INSERT INTO beln_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","І, выйшаўшы адтуль, Ісус адыйшоў у межы Тыру і Сідону. ");
INSERT INTO beln_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","І вось жанчына Хананейская, выйшаўшы з тых ваколіцаў, крычала Яму, кажучы: «Зьлітуйся нада мною, Госпадзе, Сыне Давідаў! Дачка мая цяжка апанаваная дэманам!» ");
INSERT INTO beln_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","А Ён не адказаў ёй ані слова. І вучні Ягоныя, падыйшоўшы, прасілі Яго, кажучы: «Адпусьці яе, бо яна крычыць за намі». ");
INSERT INTO beln_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ён жа, адказваючы, сказаў: «Я пасланы толькі да авечак з дому Ізраіля, якія загінулі». ");
INSERT INTO beln_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","А яна, прыйшоўшы, пакланілася Яму, кажучы: «Госпадзе! Дапамажы мне». ");
INSERT INTO beln_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ён жа, адказваючы, сказаў: «Ня добра ўзяць хлеб у дзяцей і кінуць сабакам». ");
INSERT INTO beln_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","А яна сказала: «Так, Госпадзе! Але і сабакі ядуць крошкі, якія падаюць са стала гаспадароў іхніх». ");
INSERT INTO beln_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Тады, адказваючы, Ісус сказаў ёй: «О, жанчына! Вялікая вера твая; няхай станецца табе, як ты хочаш». І была аздароўленая дачка ейная з тае гадзіны. ");
INSERT INTO beln_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","І, перайшоўшы адтуль, прыйшоў Ісус да мора Галілейскага і, узыйшоўшы на гару, сеў там. ");
INSERT INTO beln_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","І падыйшлі да Яго шматлікія натоўпы, маючы з сабою кульгавых, сьляпых, нямых, калекаў і шмат іншых, і пакінулі іх ля ног Ісуса; і Ён аздаравіў іх, ");
INSERT INTO beln_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","так што натоўп зьдзіўляўся, бачачы, што нямыя гавораць, калекі здаравеюць, кульгавыя ходзяць і сьляпыя бачаць, і славіў Бога Ізраіля. ");
INSERT INTO beln_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","А Ісус, паклікаўшы вучняў Сваіх, сказаў: «Шкада Мне гэтых людзей, што ўжо тры дні са Мною і ня маюць, што есьці; і не хачу адпусьціць іх галоднымі, каб не саслабелі ў дарозе». ");
INSERT INTO beln_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","І кажуць Яму вучні Ягоныя: «Адкуль у нас у пустыні гэтулькі хлеба, каб накарміць гэтакі натоўп?» ");
INSERT INTO beln_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","І кажа ім Ісус: «Колькі маеце хлябоў?» Яны ж сказалі: «Сем, і некалькі рыбак». ");
INSERT INTO beln_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","І Ён загадаў натоўпам узьлегчы на зямлі. ");
INSERT INTO beln_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","І, узяўшы сем хлябоў і рыбы, падзякаваўшы, паламаў і даў вучням Сваім, а вучні — натоўпу. ");
INSERT INTO beln_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","І елі ўсе, і наеліся; і сабралі кавалкаў, што засталіся, сем кашоў поўных. ");
INSERT INTO beln_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","А тых, што елі, было чатыры тысячы мужчынаў, акрамя жанчынаў і дзяцей. ");
INSERT INTO beln_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","І, адпусьціўшы натоўп, Ён увайшоў у човен і прыйшоў у ваколіцы Магдалы. ");
INSERT INTO beln_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","І, падыйшоўшы, фарысэі і садукеі, спакушаючы Яго, прасілі паказаць ім знак з неба. ");
INSERT INTO beln_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ён жа, адказваючы, сказаў ім: «Увечары вы кажаце: “Будзе пагода, бо неба чырвонае”. ");
INSERT INTO beln_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","І раніцаю: “Сёньня непагадзь, бо неба чырвонае і пахмурнае”. Крывадушнікі! Аблічча неба адрозьніваеце, а знакаў часу ня можаце? ");
INSERT INTO beln_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Пакаленьне злое і чужаложнае знаку шукае, і знак ня будзе дадзены яму, апрача знаку Ёны прарока». І, пакінуўшы іх, адыйшоў. ");
INSERT INTO beln_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","І, перабраўшыся на другі бок, вучні Ягоныя забыліся ўзяць хлеба. ");
INSERT INTO beln_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","А Ісус сказаў ім: «Глядзіце, сьцеражыцеся кісьлі фарысэйскай і садукейскай». ");
INSERT INTO beln_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Яны ж разважалі між сабою, кажучы: «Бо мы хлябоў ня ўзялі». ");
INSERT INTO beln_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Зразумеўшы ж гэта, Ісус сказаў ім: «Чаму разважаеце між сабою, малаверы, што хлябоў ня ўзялі? ");
INSERT INTO beln_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ці яшчэ не разумееце і ня памятаеце тыя пяць хлябоў на пяць тысячаў, і колькі кашоў назьбіралі? ");
INSERT INTO beln_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ці тыя сем хлябоў на чатыры тысячы, і колькі кашоў назьбіралі? ");
INSERT INTO beln_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Як не разумееце, што не наконт хлеба сказаў Я вам сьцерагчыся кісьлі фарысэйскай і садукейскай?» ");
INSERT INTO beln_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Тады яны зразумелі, што Ён гаварыў ім сьцерагчыся ня кісьлі хлебнае, але навукі фарысэйскае і садукейскае. ");
INSERT INTO beln_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","А прыйшоўшы ў межы Цэзарэі Філіпавай, Ісус спытаўся ў вучняў Сваіх, кажучы: «Кім людзі называюць Мяне, Сына Чалавечага?» ");
INSERT INTO beln_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","А яны сказалі: «Адны — Янам Хрысьціцелем, другія — Ільлём, а іншыя — Ярэміем ці адным з прарокаў». ");
INSERT INTO beln_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ён кажа ім: «А вы кім Мяне называеце?» ");
INSERT INTO beln_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Сымон жа Пётар, адказваючы, сказаў: «Ты — Хрыстос, Сын Бога Жывога». ");
INSERT INTO beln_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","І, адказваючы, Ісус сказаў яму: «Шчасьлівы ты, Сымон, сын Ёны, бо ня цела і кроў адкрылі табе гэтае, але Айцец Мой, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","І Я кажу табе: Ты — скала, і на гэтай скале Я збудую Царкву Маю, і брамы пекла не перамогуць яе. ");
INSERT INTO beln_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","І дам табе ключы Валадарства Нябеснага, і што зьвяжаш на зямлі, тое будзе зьвязана ў небе; і што разьвяжаш на зямлі, тое будзе разьвязана ў небе». ");
INSERT INTO beln_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Тады загадаў Ён вучням Сваім, каб нікому не казалі, што Ён ёсьць Ісус Хрыстос. ");
INSERT INTO beln_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ад таго часу пачаў Ісус паказваць вучням Сваім, што Ён мусіць пайсьці ў Ерусалім і шмат перацярпець ад старшыняў, і першасьвятароў, і кніжнікаў, і быць забітым, і на трэці дзень уваскрэснуць. ");
INSERT INTO beln_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","І, адклікаўшы Яго, Пётар пачаў забараняць Яму, кажучы: «Будзь міласьцівы да Сябе, Госпадзе! Няхай ня будзе гэтага з Табою!» ");
INSERT INTO beln_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ён жа, павярнуўшыся, сказаў Пятру: «Адыйдзі ад Мяне, шатан! Ты Мне згаршэньне, бо думаеш не пра тое, што Божае, але што чалавечае». ");
INSERT INTO beln_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Тады Ісус сказаў вучням Сваім: «Калі хто хоча ісьці за Мною, няхай адрачэцца ад сябе, і возьме крыж свой, і ідзе за Мною. ");
INSERT INTO beln_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Бо хто хоча душу сваю выратаваць, той загубіць яе, а хто загубіць душу сваю дзеля Мяне, той знойдзе яе. ");
INSERT INTO beln_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Бо якая карысьць чалавеку, калі ён здабудзе ўвесь сьвет, а душы сваёй пашкодзіць? Або што дасьць чалавек у выкуп за душу сваю? ");
INSERT INTO beln_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Бо мае прыйсьці Сын Чалавечы ў славе Айца Свайго з анёламі Сваімі; і тады аддасьць кожнаму паводле ўчынкаў ягоных. ");
INSERT INTO beln_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Сапраўды кажу вам: ёсьць некаторыя, што тут стаяць, якія не пакаштуюць сьмерці, пакуль ня ўбачаць Сына Чалавечага, Які ідзе ў Валадарстве Сваім». ");
INSERT INTO beln_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","І праз шэсьць дзён бярэ Ісус Пятра, Якуба і Яна, брата ягонага, і вядзе іх на гару высокую адных. ");
INSERT INTO beln_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","І Ён перамяніўся перад імі, і сьвяцілася аблічча Ягонае, як сонца, а шаты Ягоныя сталіся белыя, як сьвятло. ");
INSERT INTO beln_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","І вось, зьявіліся ім Майсей і Ільля, ведучы гутарку з Ім. ");
INSERT INTO beln_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Адказваючы, Пётар сказаў Ісусу: «Госпадзе! Добра нам тут быць; калі хочаш, зробім тут тры намёты: Табе адзін, і Майсею адзін, і адзін Ільлі». ");
INSERT INTO beln_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Калі ён яшчэ гаварыў, вось, воблака сьветлае ахінула іх; і вось, голас з воблака, які кажа: «Гэта Сын Мой улюбёны, у Якім маю ўпадабаньне; Яго слухайце». ");
INSERT INTO beln_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","І, пачуўшы, вучні ўпалі на аблічча сваё і моцна спужаліся. ");
INSERT INTO beln_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","І Ісус, падыйшоўшы, дакрануўся да іх і сказаў: «Устаньце і ня бойцеся!2 ");
INSERT INTO beln_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Падняўшы ж вочы свае, яны нікога ня ўбачылі, акрамя аднаго Ісуса. ");
INSERT INTO beln_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","І як зыходзілі яны з гары, Ісус загадаў ім, кажучы: «Нікому не кажыце пра гэты відзеж, пакуль Сын Чалавечы не ўваскрэсьне з мёртвых». ");
INSERT INTO beln_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","І спыталіся ў Яго вучні Ягоныя, кажучы: «Чаму ж кніжнікі кажуць, што Ільля мусіць прыйсьці спачатку?» ");
INSERT INTO beln_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","А Ісус, адказваючы, сказаў ім: «Ільля сапраўды прыйдзе спачатку і направіць усё. ");
INSERT INTO beln_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","А Я кажу вам, што Ільля ўжо прыйшоў, і не пазналі яго, але ўчынілі з ім, як хацелі; гэтак і Сын Чалавечы мае перацярпець ад іх». ");
INSERT INTO beln_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Тады вучні зразумелі, што Ён казаў ім пра Яна Хрысьціцеля. ");
INSERT INTO beln_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","І як прыйшлі яны да натоўпу, падыйшоў да Яго чалавек, падаючы перад ім на калені і кажучы: ");
INSERT INTO beln_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Госпадзе! Зьлітуйся над сынам маім, ён люнатык і цяжка церпіць; бо часта кідаецца ў вагонь і часта ў ваду. ");
INSERT INTO beln_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","І я прыводзіў яго да вучняў Тваіх, і яны не маглі аздаравіць яго». ");
INSERT INTO beln_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ісус жа, адказваючы, сказаў: «О, пакаленьне бязьвернае і сапсаванае! Дакуль буду з вамі? Дакуль буду цярпець вас? Прывядзіце яго да Мяне сюды». ");
INSERT INTO beln_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","І забараніў яму Ісус, і дэман выйшаў з яго, і хлопец быў аздароўлены ў тую гадзіну. ");
INSERT INTO beln_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Тады вучні, падыйшоўшы да Ісуса насамоце, сказалі: «Чаму мы не маглі выгнаць яго?» ");
INSERT INTO beln_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","А Ісус сказаў ім: «Дзеля недаверства вашага. Бо сапраўды кажу вам: калі вы маеце веру, як гарчычнае зерне, і скажаце гары гэтай: “Перайдзі адгэтуль туды”, дык яна пяройдзе; і нішто ня будзе немагчымым для вас. ");
INSERT INTO beln_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Гэты ж род выходзіць толькі праз малітву і пост». ");
INSERT INTO beln_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Калі ж былі яны ў Галілеі, Ён сказаў ім: «Сын Чалавечы мае быць выдадзены ў рукі людзей, ");
INSERT INTO beln_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","і заб’юць Яго, і на трэці дзень Ён уваскрэсьне». І яны дужа засмуціліся. ");
INSERT INTO beln_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Калі ж прыйшлі яны ў Капэрнаум, падыйшлі да Пятра зьбіральнікі дыдрахмаў і сказалі: «Настаўнік ваш ці ня дасьць дыдрахмы?» ");
INSERT INTO beln_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ён кажа: «Так». І калі ён увайшоў у дом, Ісус папярэдзіў яго, кажучы: «Як ты думаеш, Сымоне, валадары зямныя з каго бяруць мыта ці даніну, ці са сваіх сыноў, ці з чужых?» ");
INSERT INTO beln_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Пётар кажа Яму: «З чужых». Сказаў яму Ісус: «Значыцца, сыны вольныя. ");
INSERT INTO beln_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Але, каб нам не згаршаць іх, пайшоўшы на мора, кінь вуду, і першую рыбу, якая пападзецца, вазьмі, і, расчыніўшы ёй рот, знойдзеш статыр; узяўшы яго, аддай ім за Мяне і за сябе». ");
INSERT INTO beln_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","У тую гадзіну падыйшлі вучні да Ісуса, кажучы: «Дык хто большы ў Валадарстве Нябесным?» ");
INSERT INTO beln_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","І, паклікаўшы дзіцятка, Ісус паставіў яго пасярод іх ");
INSERT INTO beln_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","і сказаў: «Сапраўды кажу вам: калі не навернецеся і ня станецеся, як дзеці, ня ўвойдзеце ў Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Дык хто панізіць сябе, як гэтае дзіця, той большы ў Валадарстве Нябесным. ");
INSERT INTO beln_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","І хто прыйме адно гэткае дзіцятка ў імя Маё, той Мяне прыймае. ");
INSERT INTO beln_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","А хто згоршыць аднаго з малых гэтых, якія вераць у Мяне, такому лепш было б, каб павесілі млынавы камень на шыю ягоную і ўтапілі яго ў глыбіні мора. ");
INSERT INTO beln_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Гора сьвету ад згаршэньняў, бо патрэбна, каб прыйшлі згаршэньні; але гора таму чалавеку, праз якога прыходзіць згаршэньне. ");
INSERT INTO beln_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Калі ж рука твая ці нага твая горшыць цябе, адсячы іх і кінь ад сябе: лепш табе ўвайсьці ў жыцьцё кульгавым ці калекаю, чым, маючы дзьве рукі або дзьве нагі, быць укінутым у агонь вечны. ");
INSERT INTO beln_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","І калі вока тваё горшыць цябе, вырві яго і кінь ад сябе: лепш табе аднавокім увайсьці ў жыцьцё, чым, маючы двое вачэй, быць укінутым у геенну вогненную. ");
INSERT INTO beln_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Глядзіце, не пагарджайце ані адным з малых гэтых, бо кажу вам, што анёлы іхнія ў небе заўсёды бачаць аблічча Айца Майго Нябеснага. ");
INSERT INTO beln_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Бо Сын Чалавечы прыйшоў, каб збавіць тое, што загінула. ");
INSERT INTO beln_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Як вы думаеце, калі б нейкі чалавек меў сто авечак, і адна з іх заблукала, ці, пакінуўшы дзевяноста дзевяць у гарах, ня пойдзе ён шукаць тую, што заблукала? ");
INSERT INTO beln_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","І, калі станецца, што знойдзе яе, сапраўды кажу вам: ён узрадуецца з яе больш, чым з дзевяноста дзевяці, якія не заблукалі. ");
INSERT INTO beln_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Гэтак няма волі Айца вашага, Які ў небе, каб загінуў адзін з малых гэтых. ");
INSERT INTO beln_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Калі ж саграшыць супраць цябе брат твой, пайдзі і дакары яго між табою і ім адным; калі паслухаецца цябе, ты здабыў брата твайго. ");
INSERT INTO beln_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Калі ж не паслухаецца, вазьмі з сабою яшчэ аднаго ці двух, каб вуснамі двух або трох сьведак змацавалася ўсякае слова. ");
INSERT INTO beln_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Калі ж не пачуе, скажы царкве, а калі і царквы не пачуе, няхай будзе ён табе, як паганін і мытнік. ");
INSERT INTO beln_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Сапраўды кажу вам: усё, што вы зьвяжаце на зямлі, будзе зьвязана ў небе, і што разьвяжаце на зямлі, будзе разьвязана ў небе. ");
INSERT INTO beln_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ізноў кажу вам, што калі двое з вас на зямлі згодзяцца адносна любой справы, дык што ні папросяць, станецца ім ад Айца Майго, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Бо дзе двое або трое сабраныя дзеля імя Майго, там Я сярод іх». ");
INSERT INTO beln_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Тады Пётар, падыйшоўшы да Яго, сказаў: «Госпадзе! Колькі разоў брат мой будзе грашыць супраць мяне, і я дарую яму? Ці да сямі разоў?» ");
INSERT INTO beln_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Кажа яму Ісус: «Не кажу табе: да сямі, але да сямідзесяці разоў па сем. ");
INSERT INTO beln_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Дзеля гэтага Валадарства Нябеснае падобнае да чалавека валадара, які захацеў разрахавацца са слугамі сваімі. ");
INSERT INTO beln_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Калі ж пачаў ён рахавацца, прывялі да яго аднаго, які вінен быў дзесяць тысячаў талентаў. ");
INSERT INTO beln_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","А як ня меў што аддаць, пан ягоны загадаў прадаць яго, і жонку ягоную, і дзяцей, і ўсё, што меў, і заплаціць. ");
INSERT INTO beln_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Тады слуга той, упаўшы, пакланіўся яму, кажучы: “Пане! Будзь доўгацярплівым да мяне, і ўсё табе аддам”. ");
INSERT INTO beln_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Пан, зьлітаваўшыся над слугою тым, адпусьціў яго і дараваў яму пазыку. ");
INSERT INTO beln_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","А слуга той, выйшаўшы, знайшоў аднаго з таварышаў сваіх, які вінен быў яму сто дынараў, і, схапіўшы яго, душыў, кажучы: “Аддай мне, што вінен”. ");
INSERT INTO beln_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Тады таварыш ягоны, упаўшы да ног яго, прасіў яго, кажучы: “Будзь доўгацярплівым да мяне, і ўсё аддам табе”. ");
INSERT INTO beln_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","А той не захацеў, але адыйшоўшы, кінуў яго ў вязьніцу, пакуль не аддасьць доўгу. ");
INSERT INTO beln_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Таварышы ягоныя, убачыўшы, што сталася, вельмі засмуціліся і, прыйшоўшы, паведамілі пану свайму ўсё, што сталася. ");
INSERT INTO beln_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Тады пан ягоны, паклікаўшы яго, кажа яму: “Злы слуга! Увесь твой доўг я дараваў табе, калі ты прасіў мяне. ");
INSERT INTO beln_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ці ж ня мусіў і ты зьлітавацца над таварышам тваім, як і я зьлітаваўся над табою?” ");
INSERT INTO beln_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","І, загневаўшыся, пан ягоны аддаў яго катам, пакуль не аддасьць яму ўсяго доўгу. ");
INSERT INTO beln_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Так і Айцец Мой Нябесны ўчыніць вам, калі не даруе кожны з вас ад сэрца свайго брату свайму грахоў ягоных». ");
INSERT INTO beln_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","І сталася, калі скончыў Ісус словы гэтыя, выйшаў з Галілеі і прыйшоў у межы Юдэйскія на той бок Ярдану. ");
INSERT INTO beln_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","І пайшлі за Ім шматлікія натоўпы, і Ён аздаравіў іх там. ");
INSERT INTO beln_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","І падыйшлі да Яго фарысэі, спакушаючы Яго і кажучы Яму: «Ці за ўсякую віну можна чалавеку разводзіцца з жонкаю сваёю?» ");
INSERT INTO beln_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ён жа, адказваючы, сказаў ім: «Ці вы не чыталі, што Той, Хто стварыў на пачатку, мужчынай і жанчынай стварыў іх? ");
INSERT INTO beln_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","І Ён сказаў: “Дзеля гэтага пакіне чалавек бацьку і маці, і прылепіцца да жонкі сваёй; і будуць двое адным целам”. ");
INSERT INTO beln_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Так што яны ўжо ня двое, але адно цела. Вось жа, што Бог злучыў, таго чалавек няхай не разлучае». ");
INSERT INTO beln_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Яны кажуць Яму: «Як тады Майсей даў прыказаньне даць разводны ліст і пакінуць яе?» ");
INSERT INTO beln_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ён кажа ім: «Майсей дзеля жорсткасьці сэрца вашага дазволіў вам разводзіцца з жонкамі вашымі, а на пачатку не было гэтак. ");
INSERT INTO beln_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","А Я кажу вам: хто пакіне жонку сваю не за распусту і ажэніцца з іншаю, той чужаложыць; і хто ажэніцца з разьведзенаю, чужаложыць». ");
INSERT INTO beln_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Кажуць Яму вучні Ягоныя: «Калі гэткі абавязак чалавека да жонкі, не карысна жаніцца». ");
INSERT INTO beln_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ён жа сказаў ім: «Ня ўсе ўмяшчаюць слова гэтае, але каму дадзена. ");
INSERT INTO beln_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Бо ёсьць скапцы, што з улоньня маці гэткімі нарадзіліся; і ёсьць скапцы, якія выпакладаныя людзьмі; і ёсьць скапцы, якія самі сябе выпакладалі дзеля Валадарства Нябеснага. Хто можа ўмясьціць, няхай умесьціць». ");
INSERT INTO beln_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Тады прыносілі да Яго дзяцей, каб Ён усклаў на іх рукі і памаліўся; а вучні забаранялі ім. ");
INSERT INTO beln_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","А Ісус сказаў: «Пакіньце дзяцей і не забараняйце ім прыходзіць да Мяне; бо гэткіх ёсьць Валадарства Нябеснае». ");
INSERT INTO beln_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","І, усклаўшы на іх рукі, пайшоў адтуль. ");
INSERT INTO beln_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","І вось нехта, падыйшоўшы, сказаў Яму: «Настаўнік добры! Што мне зрабіць добрага, каб мець жыцьцё вечнае?» ");
INSERT INTO beln_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ён жа сказаў яму: «Чаму ты называеш Мяне добрым? Ніхто ня добры, акрамя аднаго Бога. Калі ж хочаш увайсьці ў жыцьцё, захоўвай прыказаньні». ");
INSERT INTO beln_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Кажа Яму: «Якія?» Ісус жа сказаў: «Не забівай; не чужалож; не крадзі; ня сьведчы фальшыва; ");
INSERT INTO beln_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","шануй бацьку твайго і маці; і любі бліжняга твайго, як самога сябе». ");
INSERT INTO beln_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Кажа Яму юнак: «Усё гэта я захаваў ад юнацтва майго. Чаго яшчэ мне не стае?» ");
INSERT INTO beln_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ісус мовіў яму: «Калі хочаш быць дасканалым, ідзі, прадай маёмасьць тваю і раздай убогім, і будзеш мець скарб у небе, і прыходзь, ідзі за Мною». ");
INSERT INTO beln_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Пачуўшы гэтае слова, юнак адыйшоў засмучаны, бо меў вялікую маёмасьць. ");
INSERT INTO beln_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","А Ісус сказаў вучням Сваім: «Сапраўды кажу вам, што цяжка багатаму ўвайсьці ў Валадарства Нябеснае. ");
INSERT INTO beln_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Зноў жа кажу вам: лягчэй вярблюду прайсьці праз вушка іголкі, чым багатаму ўвайсьці ў Валадарства Божае». ");
INSERT INTO beln_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Пачуўшы гэтае, вучні Ягоныя надта дзівіліся, кажучы: «Хто ж тады можа быць збаўленым?» ");
INSERT INTO beln_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","А Ісус, паглядзеўшы, сказаў ім: «У людзей гэта немагчыма, а ў Бога ўсё магчыма». ");
INSERT INTO beln_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Тады Пётар, адказваючы, сказаў Яму: «Вось, мы пакінулі ўсё і пайшлі за Табою; што ж будзе нам?» ");
INSERT INTO beln_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","А Ісус сказаў ім: «Сапраўды кажу вам, што вы, якія пайшлі за Мною, у адроджаным сьвеце, калі Сын Чалавечы сядзе на пасадзе славы Сваёй, сядзеце на дванаццаці пасадах судзіць дванаццаць каленаў Ізраіля. ");
INSERT INTO beln_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","І кожны, хто пакінуў дамы, або братоў, або сёстраў, або бацьку, або маці, або жонку, або дзяцей, або палі дзеля імя Майго, атрымае ў стакроць больш і ўспадкаеміць жыцьцё вечнае. ");
INSERT INTO beln_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Многія ж першыя будуць апошнімі, і апошнія — першымі. ");
INSERT INTO beln_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Бо Валадарства Нябеснае падобнае да чалавека гаспадара дому, які выйшаў рана раніцаю наняць работнікаў у вінаграднік свой. ");
INSERT INTO beln_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","І, умовіўшыся з работнікамі па дынару за дзень, паслаў іх у вінаграднік свой. ");
INSERT INTO beln_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","І, выйшаўшы каля трэцяе гадзіны, ён убачыў іншых, якія стаялі на рынку бяз працы. ");
INSERT INTO beln_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","І сказаў ім: “Ідзіце і вы ў вінаграднік мой і, што будзе справядліва, дам вам”. Яны пайшлі. ");
INSERT INTO beln_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Зноў выйшаўшы каля шостае і дзявятае гадзіны, зрабіў гэтак сама. ");
INSERT INTO beln_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","А выйшаўшы каля адзінаццатае гадзіны, ён знайшоў іншых, якія стаялі бяз працы, і кажа ім: “Чаму вы стаіцё тут цэлы дзень бяз працы?” ");
INSERT INTO beln_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Яны кажуць яму: “Ніхто нас не наняў”. Ён кажа ім: “Ідзіце і вы ў вінаграднік і, што будзе справядліва, атрымаеце”. ");
INSERT INTO beln_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","А як надыйшоў вечар, кажа гаспадар вінаградніку наглядчыку свайму: “Пакліч работнікаў і аддай ім плату, пачаўшы з апошніх да першых”. ");
INSERT INTO beln_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","І тыя, што прыйшлі каля адзінаццатае гадзіны, атрымалі па дынару. ");
INSERT INTO beln_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","А тыя, што прыйшлі першымі, думалі, што яны атрымаюць больш, але і яны атрымалі па дынару. ");
INSERT INTO beln_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","І, атрымаўшы, пачалі наракаць на гаспадара дому, ");
INSERT INTO beln_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","кажучы: “Гэтыя апошнія рабілі адну гадзіну, і ты зраўняў іх з намі, якія перанесьлі цяжар дня і сьпёку”. ");
INSERT INTO beln_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ён жа, адказваючы, сказаў аднаму з іх: “Дружа! Я ня крыўджу цябе. Ці ж не за дынар ты ўмовіўся са мною? ");
INSERT INTO beln_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Вазьмі сваё і ідзі. А я хачу даць гэтаму апошняму тое, што і табе. ");
INSERT INTO beln_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ці ж я не магу ў сваім рабіць, што хачу? Або вока тваё злоснае, што я добры?” ");
INSERT INTO beln_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Гэтак будуць апошнія першымі, і першыя — апошнімі, бо шмат пакліканых, але мала выбраных». ");
INSERT INTO beln_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","І, узыходзячы ў Ерусалім, Ісус дарогаю ўзяў дванаццаць вучняў Сваіх і сказаў ім: ");
INSERT INTO beln_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Вось, мы ўзыходзім у Ерусалім, і Сын Чалавечы будзе выдадзены першасьвятарам і кніжнікам, і яны асудзяць Яго на сьмерць, ");
INSERT INTO beln_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","і выдадуць Яго паганам на зьдзек, і бічаваньне, і ўкрыжаваньне; і на трэці дзень Ён уваскрэсьне». ");
INSERT INTO beln_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Тады падыйшла да Яго маці сыноў Зэбэдэя з сынамі сваімі, кланяючыся і нечага просячы ў Яго. ");
INSERT INTO beln_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ён жа сказаў ёй: «Чаго ты хочаш?» Яна кажа Яму: «Скажы, каб гэтыя два сыны мае селі адзін праваруч Цябе, а другі — леваруч у Валадарстве Тваім». ");
INSERT INTO beln_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","А Ісус, адказваючы, сказаў: «Ня ведаеце, чаго просіце. Ці можаце піць келіх, які Я маю піць, і хрысьціцца хрышчэньнем, якім Я хрышчуся?» Яны кажуць Яму: «Можам». ");
INSERT INTO beln_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","І Ён кажа ім: «Сапраўды, келіх Мой будзеце піць і хрышчэньнем, якім Я хрышчуся, будзеце хрысьціцца, а сесьці праваруч Мяне і леваруч Мяне не магу даць вам, але каму падрыхтавана Айцом Маім». ");
INSERT INTO beln_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","І пачуўшы гэта, дзесяцёра абурыліся на двух братоў. ");
INSERT INTO beln_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","А Ісус, паклікаўшы іх, сказаў: «Вы ведаеце, што князі народаў пануюць над імі і магнаты маюць уладу над імі. ");
INSERT INTO beln_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","А ў вас ня гэтак мае быць, але хто хоча між вамі стацца большым, няхай будзе служыцелем вашым, ");
INSERT INTO beln_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","і хто хоча між вамі быць першым, няхай будзе вашым слугою, ");
INSERT INTO beln_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","як і Сын Чалавечы не прыйшоў, каб Яму служылі, але каб паслужыць і аддаць душу Сваю на адкупленьне многіх». ");
INSERT INTO beln_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","І як выходзілі яны з Ерыхону, за Ім ішоў шматлікі натоўп. ");
INSERT INTO beln_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","І вось, два сьляпыя, што сядзелі пры дарозе, пачуўшы, што Ісус праходзіць, закрычалі, кажучы: «Зьлітуйся над намі, Госпадзе, Сыне Давідаў!» ");
INSERT INTO beln_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","А натоўп сварыўся на іх, каб маўчалі; а яны яшчэ мацней закрычалі, кажучы: «Зьлітуйся над намі, Госпадзе, Сыне Давідаў!» ");
INSERT INTO beln_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","І, супыніўшыся, Ісус паклікаў іх і сказаў: «Чаго вы хочаце, каб Я зрабіў вам?» ");
INSERT INTO beln_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Яны кажуць Яму: «Госпадзе! Каб адчыніліся вочы нашыя». ");
INSERT INTO beln_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ісус жа, зьлітаваўшыся, дакрануўся да вачэй іхніх, і адразу сталі бачыць вочы іхнія, і яны пайшлі за Ім. ");
INSERT INTO beln_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","І калі наблізіліся да Ерусаліму і прыйшлі да Бэтфагі на гары Аліўнай, тады Ісус паслаў двух вучняў, ");
INSERT INTO beln_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","кажучы ім: «Ідзіце ў мястэчка, якое перад вамі, і адразу знойдзеце асьліцу прывязаную і асьляня з ёю; адвязаўшы, прывядзіце да Мяне. ");
INSERT INTO beln_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","І калі хто скажа вам нешта, адкажыце, што Госпад іх патрабуе: і адразу пашле іх». ");
INSERT INTO beln_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","А ўсё гэтае сталася, каб споўнілася сказанае праз прарока, які кажа: ");
INSERT INTO beln_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Скажыце дачцэ Сыёну: “Вось, Валадар твой ідзе да цябе ціхі, які сядзіць на асьліцы і асьляняці, сыне пад’ярэмнай”». ");
INSERT INTO beln_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Пайшоўшы, вучні зрабілі так, як загадаў ім Ісус. ");
INSERT INTO beln_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Прывялі асьліцу і асьляня і ўсклалі на іх адзеньне сваё, і Ён сеў на іх. ");
INSERT INTO beln_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","А шматлікі натоўп пасьцілаў на дарозе адзеньне сваё, а іншыя рэзалі галіны з дрэваў і пасьцілалі на дарозе. ");
INSERT INTO beln_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","А натоўпы, што наперадзе і за Ім ішлі, крычалі, кажучы: «Гасанна Сыну Давіда! Дабраслаўлёны Той, Хто ідзе ў імя Госпада! Гасанна на вышынях!» ");
INSERT INTO beln_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","І як увайшоў Ён у Ерусалім, узварухнуўся ўвесь горад, кажучы: «Хто гэта?» ");
INSERT INTO beln_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","А натоўпы казалі: «Гэта Ісус, прарок з Назарэту Галілейскага». ");
INSERT INTO beln_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","І ўвайшоў Ісус у сьвятыню Божую, і выгнаў усіх, што продалі і куплялі ў сьвятыні, і сталы мяняльнікаў і лаўкі прадаўцоў галубоў перавярнуў. ");
INSERT INTO beln_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","І кажа ім: «Напісана: “Дом Мой домам малітвы будзе названы”. А вы зрабілі яго пячорай разбойнікаў». ");
INSERT INTO beln_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","І падыйшлі да Яго ў сьвятыні сьляпыя і кульгавыя, і Ён аздаравіў іх. ");
INSERT INTO beln_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","А першасьвятары і кніжнікі, убачыўшы цуды, якія Ён учыніў, і дзяцей, якія крычалі ў сьвятыні і казалі: «Гасанна Сыну Давіда!», — абурыліся ");
INSERT INTO beln_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","і сказалі Яму: «Ці чуеш, што яны кажуць?» А Ісус кажа ім: «Так! Ці вы ніколі не чыталі: “З вуснаў немаўлятаў і тых, што пры грудзях, Ты ўчыніў хвалу?”» ");
INSERT INTO beln_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","І, пакінуўшы іх, выйшаў з гораду да Бэтаніі, і правёў там ноч. ");
INSERT INTO beln_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","А раніцою, вяртаючыся ў горад, адчуў голад. ");
INSERT INTO beln_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","І, убачыўшы пры дарозе адно дрэва фігавае, падыйшоў да яго, і нічога не знайшоў на ім, акрамя адной лістоты, і кажа да яго: «Няхай больш ня будзе з цябе плоду да веку». І адразу ж засохла дрэва фігавае. ");
INSERT INTO beln_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","І, убачыўшы гэта, вучні зьдзівіліся, кажучы: «Як гэта адразу ж засохла дрэва фігавае?» ");
INSERT INTO beln_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","А Ісус, адказваючы, сказаў ім: «Сапраўды кажу вам: калі вы будзеце мець веру і ня будзеце сумнявацца, ня толькі зробіце тое, што з дрэвам фігавым, але калі і гары гэтай скажаце: “Будзь узятая і кінутая ў мора”, — станецца. ");
INSERT INTO beln_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","І ўсё, што будзеце прасіць у малітве з вераю, атрымаеце». ");
INSERT INTO beln_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","І калі прыйшоў Ён у сьвятыню, падыйшлі да Яго, калі Ён вучыў, першасьвятары і старшыні народу, кажучы: «Якою ўладаю Ты гэта робіш? І хто Табе даў гэтую ўладу?» ");
INSERT INTO beln_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","А Ісус, адказваючы, сказаў ім: «Спытаюся і Я ў вас адно слова; калі на гэта скажаце Мне, і Я вам скажу, якою ўладаю раблю гэта. ");
INSERT INTO beln_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Хрышчэньне Яна адкуль было: з неба ці ад людзей?» Яны ж разважалі між сабою, кажучы: «Калі скажам: “З неба”, — Ён скажа нам: “Чаму ж вы не паверылі яму?” ");
INSERT INTO beln_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","А калі скажам: “Ад людзей”, — баімся натоўпу, бо ўсе маюць Яна за прарока». ");
INSERT INTO beln_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","І, адказваючы, сказалі Ісусу: «Ня ведаем». І Ён сказаў ім: «І Я вам не скажу, якою ўладаю гэтае раблю. ");
INSERT INTO beln_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","А як вы думаеце: чалавек меў двух дзяцей, і ён, падыйшоўшы да першага, сказаў: “Дзіцятка, ідзі сёньня працаваць у вінаграднік мой”. ");
INSERT INTO beln_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Той жа, адказваючы, сказаў: “Не хачу”, а пасьля, пакаяўшыся, пайшоў. ");
INSERT INTO beln_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","І, падыйшоўшы да другога, ён сказаў тое самае. Той, адказваючы, сказаў: “Іду, пане”, і не пайшоў. ");
INSERT INTO beln_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Каторы з двух выканаў волю бацькі?» Кажуць Яму: «Першы». Кажа ім Ісус: «Сапраўды кажу вам, што мытнікі і распусьніцы ідуць наперадзе вас у Валадарства Божае. ");
INSERT INTO beln_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Бо прыйшоў да вас Ян шляхам праведнасьці, і вы не паверылі яму, а мытнікі і распусьніцы паверылі яму; вы ж, бачачы гэтае, не пакаяліся пасьля, каб паверыць яму. ");
INSERT INTO beln_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Паслухайце другую прыповесьць: быў нейкі чалавек, гаспадар дому, які пасадзіў вінаграднік, і абгарадзіў яго плотам, і выкапаў у ім тоўчню, і пабудаваў вежу, і здаў яго вінаградарам, і выехаў. ");
INSERT INTO beln_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Калі ж наблізіўся час пладоў, ён паслаў слугаў сваіх да вінаградараў узяць плады свае. ");
INSERT INTO beln_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","І схапілі вінаградары слугаў ягоных, аднаго зьбілі, другога забілі, а іншага ўкаменавалі. ");
INSERT INTO beln_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Зноў паслаў ён іншых слугаў, больш, чым раней; і з імі зрабілі тое самае. ");
INSERT INTO beln_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Нарэшце паслаў да іх сына свайго, кажучы: “Пасаромеюцца сына майго”. ");
INSERT INTO beln_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","А вінаградары, убачыўшы сына, сказалі адзін аднаму: “Гэта спадкаемца! Хадзем, заб’ем яго і атрымаем спадчыну ягоную”. ");
INSERT INTO beln_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","І, схапіўшы яго, выгналі вон з вінаградніку і забілі. ");
INSERT INTO beln_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Калі ж прыйдзе гаспадар вінаградніку, што зробіць ён з гэтымі вінаградарамі?» ");
INSERT INTO beln_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Кажуць Яму: «Ліхадзеяў гэтых жорстка выгубіць, а вінаграднік здасьць іншым вінаградарам, якія будуць аддаваць яму плады ў свой час». ");
INSERT INTO beln_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Кажа ім Ісус: «Няўжо вы ніколі не чыталі ў Пісаньні: “Камень, які адкінулі будаўнікі, стаўся галавою вугла. Ад Госпада гэта сталася, і дзіўна ў вачах нашых”. ");
INSERT INTO beln_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Дзеля гэтага кажу вам, што будзе забранае ў вас Валадарства Божае і дадзена будзе народу, які ўчыняе плады ягоныя. ");
INSERT INTO beln_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","І той, хто ўпадзе на гэты камень, разаб’ецца; а на каго ён упадзе, таго раздушыць». ");
INSERT INTO beln_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","І, пачуўшы прыповесьці Ягоныя, першасьвятары і фарысэі зразумелі, што Ён гаворыць пра іх. ");
INSERT INTO beln_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","І, шукаючы ўзяць Яго, збаяліся натоўпаў, таму што яны мелі Яго за прарока. ");
INSERT INTO beln_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","І, адказваючы, Ісус зноў гаварыў з імі ў прыповесьцях, кажучы: ");
INSERT INTO beln_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Валадарства Нябеснае падобнае да чалавека валадара, які справіў вясельле для сына свайго. ");
INSERT INTO beln_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","І ён паслаў слугаў сваіх клікаць пакліканых на вясельле; і тыя не хацелі прыйсьці. ");
INSERT INTO beln_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Зноў паслаў ён іншых слугаў, кажучы: “Скажыце пакліканым: Вось, я падрыхтаваў бяседу маю, валы мае і, што ўкормлена, зарэзаны, і ўсё падрыхтавана. Прыходзьце на вясельле”. ");
INSERT INTO beln_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","А яны, ня дбаючы на тое, пайшлі, хто на поле сваё, а хто да свайго гандлю. ");
INSERT INTO beln_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","А іншыя, узяўшы слугаў ягоных, зьняважылі іх і забілі. ");
INSERT INTO beln_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Пачуўшы пра гэтае, валадар загневаўся і, паслаўшы жаўнераў сваіх, выгубіў забойцаў тых, і горад іхні спаліў. ");
INSERT INTO beln_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Тады кажа ён слугам сваім: “Сапраўды, вясельле падрыхтаванае, але пакліканыя не былі вартыя. ");
INSERT INTO beln_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Дык пайдзіце на ростані дарог, і ўсіх, каго знойдзеце, клічце на вясельле”. ");
INSERT INTO beln_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","І слугі тыя, выйшаўшы на дарогі, сабралі ўсіх, каго толькі знайшлі, злых і добрых; і на вясельлі было поўна гасьцей. ");
INSERT INTO beln_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Увайшоўшы ж пабачыць тых, што ўзьлягалі, валадар убачыў там чалавека, не апранутага ў вясельнае адзеньне, ");
INSERT INTO beln_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","і кажа яму: “Дружа, як ты ўвайшоў сюды, ня маючы вясельнага адзеньня?” Той жа маўчаў. ");
INSERT INTO beln_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Тады сказаў валадар слугам: “Зьвязаўшы яму рукі і ногі, вазьміце яго і ўкіньце ў цемру вонкавую; там будзе плач і скрыгат зубоў. ");
INSERT INTO beln_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Бо шмат пакліканых, але мала выбраных”». ");
INSERT INTO beln_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Тады, пайшоўшы, фарысэі зрабілі нараду, як злавіць Яго ў словах. ");
INSERT INTO beln_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","І пасылаюць да Яго вучняў сваіх з ірадыянамі, кажучы: «Настаўнік! Мы ведаем, што Ты праўдзівы і пра шлях Божы паводле праўды навучаеш, і не дагаджаеш нікому, бо не глядзіш на аблічча людзей. ");
INSERT INTO beln_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Дык скажы нам, як Ты думаеш, ці належыцца даваць даніну цэзару, ці не?» ");
INSERT INTO beln_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","А Ісус, разумеючы зласьлівасьць іхнюю, сказаў: «Чаму спакушаеце Мяне, крывадушнікі? ");
INSERT INTO beln_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Пакажыце Мне манэту для даніны». Яны ж прынесьлі Яму дынар. ");
INSERT INTO beln_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","І кажа ім: «Чый гэта вобраз і надпіс?» ");
INSERT INTO beln_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Кажуць Яму: «Цэзара». Тады кажа ім: «Дык аддавайце тое, што цэзара, цэзару, а што Божае, — Богу». ");
INSERT INTO beln_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","І, пачуўшы гэта, яны зьдзівіліся, і, пакінуўшы Яго, адыйшлі. ");
INSERT INTO beln_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","У той дзень падыйшлі да Яго садукеі, якія кажуць, што няма ўваскрасеньня, і спыталіся ў Яго: ");
INSERT INTO beln_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Настаўнік, Майсей сказаў: “Калі хто памрэ, ня маючы дзяцей, брат ягоны няхай возьме жонку ягоную і адновіць насеньне брату свайму”. ");
INSERT INTO beln_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Было ж у нас сем братоў, і першы, ажаніўшыся, памёр і, ня маючы насеньня, пакінуў жонку сваю брату свайму. ");
INSERT INTO beln_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Таксама і другі, і трэці, аж да сёмага. ");
INSERT INTO beln_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Пасьля ўсіх памерла і жонка. ");
INSERT INTO beln_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Дык пры ўваскрасеньні якога з сямі будзе яна жонкаю? Бо ўсе мелі яе». ");
INSERT INTO beln_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Адказваючы, Ісус сказаў ім: «Вы памыляецеся, ня ведаючы ані Пісаньня, ані моцы Божае. ");
INSERT INTO beln_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Бо пры ўваскрасеньні ані жэняцца, ані замуж выходзяць, але будуць як анёлы Божыя ў небе. ");
INSERT INTO beln_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","А наконт уваскрасеньня мёртвых, ці не чыталі вы сказанага вам Богам, Які кажа: ");
INSERT INTO beln_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Я — Бог Абрагама, і Бог Ісаака, і Бог Якуба!” Бог ня ёсьць Бог мёртвых, але жывых». ");
INSERT INTO beln_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","І, пачуўшы, натоўпы дзівіліся з навукі Ягонай. ");
INSERT INTO beln_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","А фарысэі, пачуўшы, што Ён прымусіў змоўкнуць садукеяў, сабраліся супраць Яго. ");
INSERT INTO beln_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","І спытаўся адзін з іх, законьнік, спакушаючы Яго і кажучы: ");
INSERT INTO beln_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Настаўнік, якое найбольшае прыказаньне ў Законе?» ");
INSERT INTO beln_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","А Ісус сказаў яму: «“Любі Госпада, Бога твайго, усім сэрцам тваім, і ўсёю душою тваёю, і ўсім разуменьнем тваім”. ");
INSERT INTO beln_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Гэта ёсьць першае і найбольшае прыказаньне. ");
INSERT INTO beln_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Другое ж падобнае да яго: “Любі бліжняга свайго, як самога сябе”. ");
INSERT INTO beln_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","На гэтых двух прыказаньнях трымаецца ўвесь Закон і Прарокі». ");
INSERT INTO beln_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","А ў фарысэяў, якія сабраліся, Ісус спытаўся, ");
INSERT INTO beln_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","кажучы: «Што вы думаеце пра Хрыста? Чый Ён Сын?» Кажуць Яму: «Давіда». ");
INSERT INTO beln_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Кажа ім: «Як жа Давід у Духу называе Яго Госпадам, кажучы: ");
INSERT INTO beln_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Сказаў Госпад Госпаду майму: Сядзь праваруч Мяне, пакуль пакладу ворагаў Тваіх як падножжа ног Тваіх”. ");
INSERT INTO beln_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Дык калі Давід называе Яго Госпадам, як жа Ён — сын ягоны?» ");
INSERT INTO beln_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","І ніхто ня змог адказаць Яму ані слова; і з таго дня ніхто ўжо не адважваўся пытацца ў Яго. ");
INSERT INTO beln_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Тады Ісус прамовіў да натоўпаў і вучняў Сваіх, ");
INSERT INTO beln_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","кажучы: «На Майсеевай лаве паселі кніжнікі і фарысэі. ");
INSERT INTO beln_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Дык усё, што скажуць вам захоўваць, захоўвайце і рабіце, але не рабіце паводле ўчынкаў іхніх, бо яны кажуць і ня робяць. ");
INSERT INTO beln_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Бо яны вяжуць цяжары цяжкія і невыносныя і ўскладаюць на плечы людзям, а самі пальцам сваім ня хочуць зрушыць іх. ");
INSERT INTO beln_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Усе ж учынкі свае яны робяць, каб бачылі іх людзі; пашыраюць філяктэрыі свае і павялічваюць крысо шатаў сваіх, ");
INSERT INTO beln_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","і любяць першыя месцы на вячэрах і першыя месцы ў сынагогах, ");
INSERT INTO beln_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","і вітаньні на рынку, і каб людзі называлі іх: “Раббі, раббі!” ");
INSERT INTO beln_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","А вы не называйцеся “раббі”, бо адзін у вас Настаўнік — Хрыстос, а ўсе вы — браты. ");
INSERT INTO beln_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","І айцом сабе не называйце нікога на зямлі, бо адзін у вас Айцец, Які ў небе. ");
INSERT INTO beln_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","І не называйцеся настаўнікамі, бо адзін у вас Настаўнік — Хрыстос. ");
INSERT INTO beln_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","А большы з вас няхай будзе вам за слугу. ");
INSERT INTO beln_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Усякі ж, хто ўзвысіць сябе, паніжаны будзе, а хто паніжае сябе, будзе ўзвышаны. ");
INSERT INTO beln_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Гора вам, кніжнікі і фарысэі, крывадушнікі, што зачыняеце Валадарства Нябеснае перад людзьмі; бо самі не ўваходзіце, і тым, што ўваходзяць, не дазваляеце ўвайсьці. ");
INSERT INTO beln_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Гора вам, кніжнікі і фарысэі, крывадушнікі, што аб’ядаеце дамы ўдоваў і дзеля віду доўга моліцеся; за гэта атрымаеце цяжэйшы прысуд. ");
INSERT INTO beln_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Гора вам, кніжнікі і фарысэі, крывадушнікі, што абыходзіце мора і сухмень, каб зрабіць хоць аднаго празэлітам, і, калі станецца, робіце яго сынам геенны, удвая горшым за вас. ");
INSERT INTO beln_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Гора вам, павадыры сьляпыя, якія кажаце: “Калі хто прысягне бажніцаю, гэта нічога, а калі хто прысягне золатам бажніцы, дык вінен”. ");
INSERT INTO beln_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Дурныя і сьляпыя! Бо што большае: золата або бажніца, якая асьвячае золата? ");
INSERT INTO beln_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","І: “Калі хто прысягне ахвярнікам, гэта нічога, а калі хто прысягне дарам, які на ім, дык вінен”. ");
INSERT INTO beln_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Дурныя і сьляпыя! Бо што большае: дар або ахвярнік, які асьвячае дар? ");
INSERT INTO beln_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Дык той, хто прысягае ахвярнікам, прысягае і ім, і ўсім, што на ім; ");
INSERT INTO beln_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","і хто прысягае бажніцаю, прысягае ёю і Тым, Хто жыве ў ёй; ");
INSERT INTO beln_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","і хто прысягае небам, прысягае пасадам Божым і Тым, Хто сядзіць на ім. ");
INSERT INTO beln_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Гора вам, кніжнікі і фарысэі, крывадушнікі, што даяцё дзесяціну з мяты, аніжу і кмену, і пакінулі найважнейшае ў Законе: суд, і міласэрнасьць, і веру; гэтае трэба было рабіць, і таго не пакідаць. ");
INSERT INTO beln_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Павадыры сьляпыя, якія адцэджваеце камара, а глытаеце вярблюда! ");
INSERT INTO beln_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Гора вам, кніжнікі і фарысэі, крывадушнікі, што ачышчаеце звонку келіх і місу, а ўнутры яны напоўненыя рабункам і непаўстрыманасьцю. ");
INSERT INTO beln_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Фарысэй сьляпы, ачысьці перш знутры келіх і місу, каб і звонку сталіся чыстымі. ");
INSERT INTO beln_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Гора вам, кніжнікі і фарысэі, крывадушнікі, што падобныя да магілаў павапленых, якія звонку выглядаюць прыгожымі, а ўнутры напоўненыя косткамі мёртвых і ўсялякай нячыстасьцю. ");
INSERT INTO beln_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Гэтак і вы звонку выглядаеце людзям праведнымі, а ўнутры поўныя крывадушнасьці і беззаконьня. ");
INSERT INTO beln_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Гора вам, кніжнікі і фарысэі, крывадушнікі, што будуеце магілы прарокам і аздабляеце надмагільлі праведнікаў, ");
INSERT INTO beln_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","і кажаце: “Калі б мы былі ў дні бацькоў нашых, не былі б супольнікамі іхнімі ў крыві прарокаў”. ");
INSERT INTO beln_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Так што вы самі сьведчыце, што вы — сыны тых, якія забівалі прарокаў. ");
INSERT INTO beln_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Дапаўняйце ж меру бацькоў вашых. ");
INSERT INTO beln_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Зьмеі, спараджэньні яхідны, як уцячэце вы асуджэньня ў геенну? ");
INSERT INTO beln_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Вось, дзеля гэтага Я пасылаю да вас прарокаў, і мудрых, і кніжнікаў; і вы адных заб’яцё і ўкрыжуеце, і іншых будзеце біць у сынагогах вашых і гнаць з горада ў горад. ");
INSERT INTO beln_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Няхай жа прыйдзе на вас уся кроў праведная, пралітая на зямлі, ад крыві Абэля праведнага да крыві Захарыі, сына Барахіі, якога вы забілі між бажніцаю і ахвярнікам. ");
INSERT INTO beln_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Сапраўды кажу вам, што ўсё гэтае прыйдзе на пакаленьне гэтае. ");
INSERT INTO beln_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ерусалім, Ерусалім, які забіваеш прарокаў і камянуеш пасланых да цябе! Колькі разоў хацеў Я сабраць дзяцей тваіх, як птушка зьбірае птушанят сваіх пад крылы, і вы не захацелі. ");
INSERT INTO beln_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Вось, пакідаецца вам дом ваш пусты. ");
INSERT INTO beln_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Бо кажу вам: ня будзеце бачыць Мяне ад сёньня, пакуль ня скажаце: “Дабраслаўлёны Той, Хто ідзе ў імя Госпада”». ");
INSERT INTO beln_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","І, выйшаўшы, Ісус ішоў ад сьвятыні; і падыйшлі вучні Ягоныя, каб паказаць Яму пабудовы сьвятыні. ");
INSERT INTO beln_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","А Ісус сказаў ім: «Ці бачыце ўсё гэтае? Сапраўды кажу вам: не застанецца тут камяня на камяні, які б ня быў зруйнаваны». ");
INSERT INTO beln_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","А калі сядзеў Ён на гары Аліўнай, падыйшлі да Яго вучні насамоце, кажучы: «Скажы нам, калі гэта будзе, і які знак Твайго прыйсьця і сканчэньня веку?» ");
INSERT INTO beln_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","І, адказваючы, Ісус сказаў ім: «Глядзіце, каб ніхто не падмануў вас, ");
INSERT INTO beln_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","бо многія прыйдуць пад імем Маім, кажучы: “Я — Хрыстос”, — і шмат каго падмануць. ");
INSERT INTO beln_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Маеце чуць пра войны і чуткі ваенныя. Глядзіце, не трывожцеся, бо ўсё гэта мусіць стацца, але гэта яшчэ не канец. ");
INSERT INTO beln_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Бо паўстане народ на народ і валадарства на валадарства; і будуць голад, і пошасьці, і землятрусы месцамі. ");
INSERT INTO beln_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","А ўсё гэтае — пачатак мукаў. ");
INSERT INTO beln_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Тады будуць выдаваць вас на пакуты і забіваць вас, і зьненавідзяць вас усе народы за імя Маё. ");
INSERT INTO beln_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","І тады згоршацца многія; і будуць выдаваць адзін аднаго, і ненавідзець адзін аднаго. ");
INSERT INTO beln_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","І многія фальшывыя прарокі паўстануць, і падмануць многіх. ");
INSERT INTO beln_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","І дзеля памнажэньня беззаконьня ў многіх асьцюдзянее любоў. ");
INSERT INTO beln_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","А хто вытрывае да канца, будзе збаўлены. ");
INSERT INTO beln_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","І будзе абвешчанае гэтае Эвангельле Валадарства па ўсім сьвеце на сьведчаньне ўсім народам, і тады прыйдзе канец. ");
INSERT INTO beln_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Дык калі ўбачыце агіду спусташэньня, пра якую сказаў Данііл прарок, што паўстане на месцы сьвятым, — хто чытае, няхай зразумее, — ");
INSERT INTO beln_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","тады тыя, што ў Юдэі, няхай бягуць у горы, ");
INSERT INTO beln_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","хто на даху, няхай не зыходзіць узяць што з дому свайго, ");
INSERT INTO beln_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","і хто ў полі, няхай не варочаецца назад узяць адзеньне сваё. ");
INSERT INTO beln_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Гора ж тым, якія цяжарныя і якія кормяць грудзьмі, у тыя дні. ");
INSERT INTO beln_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Маліцеся ж, каб ня сталіся ўцёкі вашыя зімою або ў суботу. ");
INSERT INTO beln_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Бо тады будзе вялікі прыгнёт, якога не было ад пачатку сьвету аж дагэтуль, і ня будзе. ");
INSERT INTO beln_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","І калі б не былі скарочаныя тыя дні, не было б збаўленае ніводнае цела, але дзеля выбраных будуць скарочаныя тыя дні. ");
INSERT INTO beln_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Тады, калі хто скажа вам: “Вось, тут Хрыстос, ці там”, — ня верце. ");
INSERT INTO beln_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Бо паўстануць фальшывыя хрысты і фальшывыя прарокі і дадуць вялікія знакі і цуды, каб падмануць, калі магчыма, і выбраных. ");
INSERT INTO beln_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Вось, Я наперад сказаў вам. ");
INSERT INTO beln_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Дык, калі скажуць вам: “Вось, Ён у пустыні”, — не выходзьце; “Вось, Ён у пакоях”, — ня верце. ");
INSERT INTO beln_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Бо, як бліскавіца выходзіць з усходу і сьвеціць да захаду, так будзе і прыйсьце Сына Чалавечага. ");
INSERT INTO beln_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Бо дзе мёртвае цела, там зьбяруцца і арлы. ");
INSERT INTO beln_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","А адразу пасьля прыгнёту дзён тых сонца зацьмее, і месяц ня дасьць сьвятла свайго, і зоркі ўпадуць з неба, і сілы нябесныя захістаюцца. ");
INSERT INTO beln_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","І тады зьявіцца знак Сына Чалавечага ў небе, і тады заплачуць усе калены зямлі і ўгледзяць Сына Чалавечага, Які ідзе на аблоках нябесных з сілаю і славаю вялікаю. ");
INSERT INTO beln_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","І пашле Ён анёлаў Сваіх з гучным голасам трубным, і зьбяруць яны выбраных Ягоных ад чатырох вятроў, ад краю неба да краю яго. ");
INSERT INTO beln_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","У дрэва фігавага навучыцеся прыповесьці: калі ўжо галінка ягоная робіцца мяккаю і пускае лісты, ведаеце, што блізка лета. ");
INSERT INTO beln_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Гэтак і вы, калі ўбачыце ўсё гэтае, ведайце, што блізка, у дзьвярах. ");
INSERT INTO beln_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Сапраўды кажу вам: не прамі