﻿USE sofia;
DROP TABLE IF EXISTS sofia.bel_vpl;
CREATE TABLE bel_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bel_vpl WRITE;
INSERT INTO bel_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," На пачатку стварыў Бог неба і зямлю. ");
INSERT INTO bel_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","І зямля была бязладная і пустая, і цемра над бяздоньнямі, і Дух Божы ўзносіўся над водамі. ");
INSERT INTO bel_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","І сказаў Бог: «Няхай станецца сьвятло». І сталася сьвятло. ");
INSERT INTO bel_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","І бачыў Бог сьвятло, што яно добрае, і разьдзяліў Бог сьвятло і цемру. ");
INSERT INTO bel_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","І назваў Бог сьвятло днём, а цемру — ноччу. І быў вечар, і была раніца — дзень адзін. ");
INSERT INTO bel_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","І сказаў Бог: «Няхай станецца прасьцяг сярод водаў і няхай аддзеліць воды ад водаў». ");
INSERT INTO bel_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","І зрабіў Бог прасьцяг, і разьдзяліў воды, якія былі пад прасьцягам, і воды, якія былі над прасьцягам. І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","І назваў Бог прасьцяг небам. І быў вечар, і была раніца — дзень другі. ");
INSERT INTO bel_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","І сказаў Бог: «Няхай зьбяруцца воды, якія пад небам, у адно месца, і няхай зьявіцца сухазем’е». І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","І назваў Бог сухазем’е зямлёю, а збор водаў назваў морам. І бачыў Бог, што гэта добра. ");
INSERT INTO bel_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","І сказаў Бог: «Няхай зазелянее зямля зелянінай, травой, якая сее насеньне, і дрэвамі пладовымі, якія даюць плады паводле гатунку свайго і маюць у сабе насеньне на зямлі». І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","І выдала зямля зеляніну, траву, якая сее насеньне паводле гатунку свайго, і дрэвы, якія даюць плады і маюць у сабе насеньне паводле гатунку свайго. І бачыў Бог, што гэта добра. ");
INSERT INTO bel_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","І быў вечар, і была раніца — дзень трэці. ");
INSERT INTO bel_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","І сказаў Бог: «Няхай стануцца сьвяцілы на прасьцягу неба, каб разьдзяляць дзень і ноч, і няхай будуць дзеля знакаў, і вызначаных часоў, і дзён, і гадоў. ");
INSERT INTO bel_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","І няхай будуць сьвяціламі на прасьцягу неба, каб сьвяцілі на зямлю». І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","І зрабіў Бог два сьвяцілы вялікія: сьвяціла большае, каб кіравала днём, і сьвяціла меншае, каб кіравала ноччу, і зоркі. ");
INSERT INTO bel_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","І зьмясьціў іх Бог на прасьцягу неба, каб сьвяцілі на зямлю, ");
INSERT INTO bel_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","і кіравалі днём і ноччу, і аддзялялі сьвятло ад цемры. І бачыў Бог, што гэта добра. ");
INSERT INTO bel_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","І быў вечар, і была раніца — дзень чацьвёрты. ");
INSERT INTO bel_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","І сказаў Бог: «Няхай узварушацца воды рухам душы жывой, і птушкі няхай лётаюць над зямлёю па прасьцягу неба». ");
INSERT INTO bel_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","І стварыў Бог цмокаў вялікіх і ўсякую душу жывую, якая рухаецца, якімі ўзварушыліся воды, паводле гатункаў сваіх, і ўсякую птушку крылатую паводле гатунку свайго. І бачыў Бог, што гэта добра. ");
INSERT INTO bel_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","І дабраславіў іх Бог, кажучы: «Пладзіцеся і множцеся, і напаўняйце воды мораў, а птушкі няхай множацца на зямлі». ");
INSERT INTO bel_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","І быў вечар, і была раніца — дзень пяты. ");
INSERT INTO bel_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","І сказаў Бог: «Няхай выдасьць зямля душу жывую паводле гатунку свайго: скаціну, паўзуноў і зьвяроў зямных паводле гатункаў сваіх». І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","І зрабіў Бог зьвяроў зямных паводле гатункаў сваіх, і скаціну паводле гатунку свайго, і ўсякіх паўзуноў зямных паводле гатункаў сваіх. І бачыў Бог, што гэта добра. ");
INSERT INTO bel_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","І сказаў Бог: «Зробім чалавека на вобраз Наш, як падабенства Нашае, і няхай ён мае ўладу над рыбамі марскімі і над птушкамі паднебнымі, і над скацінай, і над усёй зямлёй, і над усякім паўзуном, які поўзае па зямлі». ");
INSERT INTO bel_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","І стварыў Бог чалавека на вобраз Свой, на вобраз Божы стварыў яго, мужчыну і жанчыну стварыў іх. ");
INSERT INTO bel_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","І дабраславіў іх Бог, і сказаў ім Бог: «Пладзіцеся і множцеся, і напаўняйце зямлю, і падпарадкоўвайце яе сабе, і мейце ўладу над рыбамі марскімі, і над птушкамі паднебнымі, і над усякім зьверам, які рухаецца па зямлі». ");
INSERT INTO bel_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","І сказаў Бог: «Вось, Я даў вам усякую траву, якая сее насеньне, якая на абліччы ўсёй зямлі, і ўсякія дрэвы, якія маюць плод дрэва і сеюць насеньне, каб былі вам на ежу. ");
INSERT INTO bel_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","І ўсім зьвярам зямным, і ўсім птушкам паднебным, і ўсяму, што рухаецца па зямлі, у якім ёсьць душа жывая, Я даў усякую траву зялёную на ежу». І сталася так. ");
INSERT INTO bel_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","І бачыў Бог усё, што зрабіў, і вось, усё вельмі добра. І быў вечар, і была раніца — дзень шосты. ");
INSERT INTO bel_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","І былі скончаны неба і зямля, і ўсё войска іхняе. ");
INSERT INTO bel_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","І скончыў Бог у сёмы дзень працу Сваю, якую зрабіў, і супачыў у сёмы дзень ад усёй працы Сваёй, якую зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","І дабраславіў Бог дзень сёмы, і асьвяціў яго, бо ў ім супачыў ад усёй працы Сваёй, калі ствараў Бог, робячы. ");
INSERT INTO bel_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Такі вось радавод неба і зямлі, калі былі яны створаныя, у дзень, калі ГОСПАД Бог зрабіў зямлю і неба. ");
INSERT INTO bel_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","І не было яшчэ ніводнага куста палявога на зямлі, і ніводная трава палявая яшчэ не вырасла, бо ГОСПАД Бог не спаслаў дождж на зямлю і не было чалавека, каб абрабляць зямлю. ");
INSERT INTO bel_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","І пара падымалася ад зямлі, і напойвала ўсё аблічча зямлі. ");
INSERT INTO bel_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","І зьляпіў ГОСПАД Бог чалавека з пылу зямлі, і ўдыхнуў у ноздры ягоныя дыханьне жыцьця, і стаўся чалавек душою жывою. ");
INSERT INTO bel_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","І пасадзіў ГОСПАД Бог сад у Эдэме, на ўсходзе, і зьмясьціў там чалавека, якога зьляпіў. ");
INSERT INTO bel_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","І вырасьціў ГОСПАД Бог з зямлі ўсякае дрэва, прыгожае на выгляд і добрае на ежу, і дрэва жыцьця ў сярэдзіне саду, і дрэва спазнаньня дабра і зла. ");
INSERT INTO bel_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","І рака выцякала з Эдэму, каб напойваць сад, і адтуль яна разьдзялялася на чатыры галоўныя ракі. ");
INSERT INTO bel_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Назва адной — Пішон, яна атачае ўсю зямлю Хавіля, у якой золата. ");
INSERT INTO bel_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","А золата той зямлі добрае, там бдалях і камень онікс. ");
INSERT INTO bel_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","А назва другой ракі — Гіхон, яна атачае ўсю зямлю Куш. ");
INSERT INTO bel_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","А назва трэцяй ракі — Хідэкель, яна цячэ на ўсход Асірыі; а чацьвёртая рака — Эўфрат. ");
INSERT INTO bel_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","І ўзяў ГОСПАД Бог чалавека, і зьмясьціў яго ў садзе Эдэм, каб абрабляў яго і захоўваў яго. ");
INSERT INTO bel_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","І загадаў ГОСПАД Бог чалавеку, кажучы: «З кожнага дрэва ў садзе будзеш есьці, ");
INSERT INTO bel_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","але з дрэва спазнаньня дабра і зла ня еш з яго, бо ў дзень, у які будзеш есьці з яго, сьмерцю памрэш». ");
INSERT INTO bel_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","І сказаў ГОСПАД Бог: «Ня добра быць чалавеку аднаму; зраблю яму дапамогу, адпаведную яму». ");
INSERT INTO bel_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","І зьляпіў ГОСПАД Бог з зямлі ўсіх зьвяроў палявых і ўсіх птушак паднебных, і прывёў да чалавека, каб пабачыць, як ён назаве іх, і як чалавек назаве кожную душу жывую, такое і імя ёй. ");
INSERT INTO bel_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","І назваў чалавек імёны ўсёй скаціны, і ўсіх птушак паднебных, і ўсіх зьвяроў палявых, але для чалавека не знайшлося дапамогі, адпаведнай яму. ");
INSERT INTO bel_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","І спусьціў ГОСПАД Бог моцны сон на чалавека, і той заснуў. І ўзяў Ён адно з рэбраў ягоных, і закрыў целам тое месца. ");
INSERT INTO bel_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","І збудаваў ГОСПАД Бог з рабра, якое ўзяў з чалавека, жанчыну, і прывёў яе да чалавека. ");
INSERT INTO bel_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","І сказаў чалавек: «Вось, на гэты раз, гэта костка з костак маіх і цела з цела майго. Яна будзе называцца жанчынаю, бо ўзятая з мужа». ");
INSERT INTO bel_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Таму пакіне мужчына бацьку свайго і маці сваю і прылепіцца да жонкі сваёй, і будуць адным целам. ");
INSERT INTO bel_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","І былі абое голыя, чалавек і жонка ягоная, і не саромеліся. ");
INSERT INTO bel_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","А зьмей быў хітрэйшы за ўсіх зьвяроў палявых, якіх зрабіў ГОСПАД Бог. І сказаў ён жанчыне: «Ці ж гэта сказаў Бог: “Ня ешце з кожнага дрэва ў садзе”?» ");
INSERT INTO bel_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","І сказала жанчына зьмею: «Плады дрэваў саду можам есьці, ");
INSERT INTO bel_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","але пра плады дрэва, якое пасярод саду, сказаў Бог: “Ня ешце з яго і не дакранайцеся да яго, каб вы не памерлі”». ");
INSERT INTO bel_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","І сказаў зьмей жанчыне: «Не памрацё сьмерцю! ");
INSERT INTO bel_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Бо ведае Бог, што ў дзень, калі зьясьцё з яго, расплюшчацца вочы вашыя і станецеся як Бог, тымі, хто спазнае дабро і зло». ");
INSERT INTO bel_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","І ўбачыла жанчына, што дрэва добрае для ежы, і прывабнае для вачэй, і пажаданае дрэва дзеля разуменьня, і ўзяла яна плод ягоны, і ела, і дала мужу свайму, які быў з ёю, і ён еў. ");
INSERT INTO bel_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","І расплюшчыліся вочы ў іх абодвух, і спазналі, што яны голыя, і сплялі лісты фігавыя, і зрабілі сабе перапаяскі. ");
INSERT INTO bel_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","І пачулі яны голас ГОСПАДА Бога, Які хадзіў у садзе ў ветры дня, і схаваліся чалавек і жонка ягоная ад аблічча ГОСПАДА Бога сярод дрэваў саду. ");
INSERT INTO bel_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","І паклікаў ГОСПАД Бог чалавека, і сказаў яму: «Дзе ты?» ");
INSERT INTO bel_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","І той сказаў: «Голас Твой я пачуў у садзе і спалохаўся, бо я — голы, і схаваўся». ");
INSERT INTO bel_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","І сказаў Бог: «Хто распавёў табе, што ты голы? Ці ня еў ты з дрэва, з якога Я загадаў табе ня есьці?» ");
INSERT INTO bel_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","І сказаў чалавек: «Жанчына, якую Ты даў, каб была са мною, яна дала мне з дрэва, і я еў». ");
INSERT INTO bel_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","І сказаў ГОСПАД Бог жанчыне: «Што ты гэта зрабіла?» І сказала жанчына: «Зьмей падмануў мяне, і я ела». ");
INSERT INTO bel_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","І сказаў ГОСПАД Бог зьмею: «За тое, што ты зрабіў гэта, пракляты ты між усёй скаціны і ўсіх зьвяроў палявых! На жываце сваім поўзаць будзеш і будзеш пыл есьці ў-ва ўсе дні жыцьця твайго. ");
INSERT INTO bel_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","І Я кладу варожасьць паміж табой і жанчынай, паміж насеньнем тваім і насеньнем яе. Яно скрышыць табе галаву, а ты скрышыш яму пяту». ");
INSERT INTO bel_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","А жанчыне сказаў: «Памнажаючы, памножу мучэньні твае і цяжарнасьці твае, з болем будзеш нараджаць сыноў; і да мужа твайго памкненьне тваё, а ён будзе панаваць над табою». ");
INSERT INTO bel_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","А Адаму сказаў: «За тое, што ты паслухаўся голасу жонкі тваёй і еў з дрэва, пра якое Я загадаў табе, кажучы: “Ня еш з яго”, праклятая зямля з-за цябе. У мучэньнях будзеш есьці з яе ў-ва ўсе дні жыцьця твайго. ");
INSERT INTO bel_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Церні і асот будзе радзіць яна табе, і будзеш есьці траву палявую. ");
INSERT INTO bel_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","У поце аблічча твайго будзеш есьці хлеб, аж пакуль ня вернешся ў зямлю, бо з яе ты ўзяты, бо пыл ты і ў пыл вернешся». ");
INSERT INTO bel_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","І назваў чалавек імя сваёй жонцы — Ева, бо яна была маці ўсіх, што жывуць. ");
INSERT INTO bel_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","І зрабіў ГОСПАД Бог Адаму і жонцы ягонай адзеньне са скуры, і апрануў іх. ");
INSERT INTO bel_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","І сказаў ГОСПАД Бог: «Вось, чалавек стаўся як адзін з Нас, спазнаўшы дабро і зло. І цяпер няхай ня выцягне ён рукі сваёй і ня возьме таксама з дрэва жыцьця, і ня зьесьць, і ня будзе жыць вечна». ");
INSERT INTO bel_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","І выслаў яго ГОСПАД Бог з саду Эдэм, каб абрабляў зямлю, з якой быў узяты. ");
INSERT INTO bel_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","І выгнаў чалавека, і паставіў на ўсходзе ад саду Эдэм херувімаў і меч палымяны, які паварочваецца наўкола, каб сьцерагчы шлях да дрэва жыцьця. ");
INSERT INTO bel_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","І чалавек спазнаў Еву, жонку сваю, і яна зачала, і нарадзіла Каіна, і сказала: «Атрымала я мужа ад ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","І яшчэ нарадзіла брата ягонага Абэля. І быў Абэль пастухом авечак, а Каін быў земляробам. ");
INSERT INTO bel_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","І сталася, калі прайшлі дні, Каін прынёс з пладоў зямлі дар ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","І Абэль таксама прынёс з першародных авечак сваіх і з тлустасьці іх. І ўзглянуў ГОСПАД на Абэля і на дар ягоны, ");
INSERT INTO bel_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","а на Каіна і на дар ягоны ня ўзглянуў. І вельмі загневаўся Каін, і пахілілася аблічча яго. ");
INSERT INTO bel_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","І сказаў ГОСПАД Каіну: «Чаму ты загневаўся і чаму пахілілася аблічча тваё? ");
INSERT INTO bel_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ці ж ты не ўзьнімаеш аблічча, калі робіш добра, а калі ня робіш добра, грэх ляжыць пры дзьвярах, да цябе памкненьне ягонае, але ты павінен панаваць над ім». ");
INSERT INTO bel_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","І сказаў Каін Абэлю, брату свайму: «Пойдзем у поле». І сталася, калі былі яны ў полі, паўстаў Каін на Абэля, брата свайго, і забіў яго. ");
INSERT INTO bel_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","І сказаў ГОСПАД Каіну: «Дзе Абэль, брат твой?» А той сказаў: «Ня ведаю. Ці ж я вартаўнік брата майго?» ");
INSERT INTO bel_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","І сказаў Бог: «Што ты зрабіў? Голас крыві брата твайго кліча да Мяне ад зямлі. ");
INSERT INTO bel_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","І цяпер пракляты ты ад зямлі, якая адчыніла вусны свае прыняць кроў брата твайго з рукі тваёй. ");
INSERT INTO bel_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Калі будзеш абрабляць зямлю, яна ня будзе больш даваць табе сілы свае. Выгнанцам і ўцекачом будзеш на зямлі». ");
INSERT INTO bel_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","І сказаў Каін ГОСПАДУ: «Большае беззаконьне маё, чым можна зьнесьці. ");
INSERT INTO bel_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Вось, Ты выганяеш мяне сёньня з аблічча зямлі, і буду хавацца ад аблічча Твайго, і буду я выгнанцам і ўцекачом на зямлі, і станецца, што кожны, хто сустрэне мяне, заб’е мяне». ");
INSERT INTO bel_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","І сказаў яму ГОСПАД: «Таму кожнаму, хто заб’е Каіна, сем разоў будзе адпомшчана». І пазначыў ГОСПАД Каіна знакам, каб не забіў яго кожны, хто сустрэне яго. ");
INSERT INTO bel_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","І адыйшоў Каін ад аблічча ГОСПАДА, і пасяліўся ў зямлі Нод, на ўсход ад Эдэму. ");
INSERT INTO bel_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","І спазнаў Каін жонку сваю, і яна зачала, і нарадзіла Эноха. І пабудаваў ён горад, і назваў імя горада ад імя сына свайго — Энох. ");
INSERT INTO bel_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","І нарадзіў Энох Ірада, а Ірад нарадзіў Мэхіяэля, а Мэхіяэль нарадзіў Мэтушаэля, а Мэтушаэль нарадзіў Лямэха. ");
INSERT INTO bel_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","І ўзяў сабе Лямэх дзьве жонкі. Імя адной — Ада, а імя другой — Цыля. ");
INSERT INTO bel_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","І нарадзіла Ада Яваля, ён быў бацька тых, што жывуць у намётах і маюць статкі. ");
INSERT INTO bel_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","А імя брата ягонага — Юваль, ён быў бацька ўсіх, што граюць на гусьлях і жалейцы. ");
INSERT INTO bel_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","І Цыля таксама нарадзіла Туваль-Каіна, які быў кавалём усякіх прыладаў з медзі і жалеза. А сястра Туваль-Каіна — Наама. ");
INSERT INTO bel_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","І сказаў Лямэх жонкам сваім: «Ада і Цыля, паслухайце голас мой! Жонкі Лямэха, прыхіліце вуха да мовы маёй! Бо забіў я чалавека за рану сваю і юнака за скалечаньне сваё. ");
INSERT INTO bel_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Бо за Каіна будзе адпомшчана сем разоў, а за Лямэха — семдзясят сем». ");
INSERT INTO bel_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","І спазнаў яшчэ Адам жонку сваю, і яна нарадзіла сына, і назвала імя ягонае Сэт, бо казала: «Даў мне Бог іншае насеньне замест Абэля, якога забіў Каін». ");
INSERT INTO bel_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","У Сэта таксама нарадзіўся сын, і ён назваў імя ягонае Энос. Тады пачалі клікаць імя ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Вось кніга радаводу Адама. У дзень, калі Бог стварыў Адама, зрабіў яго на падабенства Божае, ");
INSERT INTO bel_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","мужчыну і жанчыну стварыў іх, і дабраславіў іх, і назваў іх імя “чалавек” у дзень стварэньня іх. ");
INSERT INTO bel_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","І жыў Адам сто трыццаць гадоў, і нарадзіў сына на падабенства сваё, як вобраз свой, і назваў імя яго Сэт. ");
INSERT INTO bel_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","І было дзён Адама па нараджэньні Сэта васемсот гадоў, і нарадзіў ён сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","І былі ўсе дні Адама, якія ён жыў, дзевяцьсот трыццаць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","І жыў Сэт сто пяць гадоў, і нарадзіў Эноса. ");
INSERT INTO bel_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","І жыў Сэт па нараджэньні Эноса васемсот сем гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","І былі ўсе дні Сэта дзевяцьсот дванаццаць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","І жыў Энос дзевяноста гадоў, і нарадзіў Кейнана. ");
INSERT INTO bel_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","І жыў Энос па нараджэньні Кейнана васемсот пятнаццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","І былі ўсе дні Эноса дзевяцьсот пяць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","І жыў Кейнан семдзясят гадоў, і нарадзіў Магалялеэля. ");
INSERT INTO bel_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","І жыў Кейнан па нараджэньні Магалялеэля васемсот сорак гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","І былі ўсе дні Кейнана дзевяцьсот дзесяць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","І жыў Магалялеэль шэсьцьдзясят пяць гадоў, і нарадзіў Ярэда. ");
INSERT INTO bel_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","І жыў Магалялеэль па нараджэньні Ярэда васемсот трыццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","І былі ўсе дні Магалялеэля васемсот дзевяноста пяць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","І жыў Ярэд сто шэсьцьдзясят два гады, і нарадзіў Эноха. ");
INSERT INTO bel_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","І жыў Ярэд па нараджэньні Эноха васемсот гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","І былі ўсе дні Ярэда дзевяцьсот шэсьцьдзясят два гады, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","І жыў Энох шэсьцьдзясят пяць гадоў і нарадзіў Мэтушэляха. ");
INSERT INTO bel_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","І хадзіў Энох з Богам па нараджэньні Мэтушэляха трыста гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","І былі ўсе дні Эноха трыста шэсьцьдзясят пяць гадоў. ");
INSERT INTO bel_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","І хадзіў Энох з Богам, і ня стала яго, бо забраў яго Бог. ");
INSERT INTO bel_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","І жыў Мэтушэлях сто восемдзясят сем гадоў, і нарадзіў Лямэха. ");
INSERT INTO bel_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","І жыў Мэтушэлях па нараджэньні Лямэха семсот восемдзясят два гады, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","І былі ўсе дні Мэтушэляха дзевяцьсот шэсьцьдзясят дзевяць гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","І жыў Лямэх сто восемдзясят два гады, і нарадзіў сына, ");
INSERT INTO bel_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","і назваў яго імя Ной, кажучы: «Ён пацешыць нас у рабоце нашай і ў працы рук нашых на зямлі, якую пракляў ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","І жыў Лямэх па нараджэньні Ноя пяцьсот дзевяноста пяць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","І былі ўсе дні Лямэха семсот семдзясят сем гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","І было Ною пяцьсот гадоў, і нарадзіў Ной Сэма, Хама i Яфэта. ");
INSERT INTO bel_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","І сталася, што людзі пачалі множыцца на абліччы зямлі, і нарадзіліся ім дочкі. ");
INSERT INTO bel_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","І бачылі сыны Божыя дочак чалавечых, што яны прыгожыя, і ўзялі сабе за жонак усіх, якіх абралі. ");
INSERT INTO bel_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","І сказаў ГОСПАД: «Ня будзе Дух Мой змагацца ў чалавеку вечна, бо ён — цела. І будуць дні ягоныя сто дваццаць гадоў». ");
INSERT INTO bel_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","У тыя дні нэфілімы жылі на зямлі, а таксама пазьней, калі сыны Божыя прыходзілі да дочак чалавечых, і тыя ім нараджалі. Былі гэта волаты, ад вякоў мужы слаўныя. ");
INSERT INTO bel_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","І бачыў ГОСПАД, што вялікае зло сярод людзей на зямлі, і што ўсе намеры думак сэрца іхняга — толькі на зло ўсякі дзень. ");
INSERT INTO bel_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","І пашкадаваў ГОСПАД, што зрабіў чалавека на зямлі, і засмуціўся ў сэрцы Сваім. ");
INSERT INTO bel_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","І сказаў ГОСПАД: «Зьнішчу чалавека, якога стварыў, з аблічча зямлі, ад чалавека да скаціны, да паўзуна, да птушкі паднебнай, бо шкадую, што зрабіў іх». ");
INSERT INTO bel_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","А Ной знайшоў ласку ў вачах ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Вось радавод Ноя. Ной быў чалавек праведны і беззаганны ў пакаленьні сваім. Ной хадзіў з Богам. ");
INSERT INTO bel_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","І нарадзіў Ной трох сыноў: Сэма, Хама і Яфэта. ");
INSERT INTO bel_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","І сапсаваная была зямля перад абліччам Бога, і напоўнілася зямля ліхадзействам. ");
INSERT INTO bel_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","І бачыў Бог зямлю, і вось, яна сапсаваная, бо кожнае цела скрывіла шлях свой на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","І сказаў Бог Ною: «Канец усякаму целу прыйшоў перад аблічча Маё, бо зямля напоўнілася ліхадзействам праз іх. І вось, Я вынішчу іх з зямлі. ");
INSERT INTO bel_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Зрабі сабе каўчэг з дрэва гафэр; зробіш у каўчэгу перагародкі і пацягні яго смалой звонку і знутры. ");
INSERT INTO bel_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Вось так маеш зрабіць яго: трыста локцяў даўжыня каўчэгу, пяцьдзясят локцяў шырыня яго і трыццаць локцяў вышыня яго. ");
INSERT INTO bel_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Зробіш вакно ў каўчэгу, і ў локаць скончыш яго ўгары. Уваход у каўчэг разьмесьціш з боку яго; ніжні, другі і трэці паверхі зробіш у ім. ");
INSERT INTO bel_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","І вось, Я ўзьвяду патоп водны на зямлю, каб вынішчыць пад небам усякае цела, у якім ёсьць дух жыцьця. Усё, што на зямлі, — загіне. ");
INSERT INTO bel_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","І Я заключу запавет Мой з табою, і ўвойдзеш у каўчэг ты, і сыны твае, і жонка твая, і жонкі сыноў тваіх з табою. ");
INSERT INTO bel_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","І з усяго жывога, з кожнага цела прывядзеш па двое ў каўчэг, каб засталіся жывыя з табою, мужчынскага роду і жаночага няхай яны будуць. ");
INSERT INTO bel_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","З птушак паводле гатункаў іх, са скаціны паводле гатунку яго і з усіх паўзуноў зямных паводле гатункаў іх, з усіх па двое ўвойдуць да цябе, каб засталіся жывыя. ");
INSERT INTO bel_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","І ты вазьмі сабе ўсякай ежы, якою яны кормяцца, і зьбяры яе да сябе; і будзе яна для цябе і для іх ежаю». ");
INSERT INTO bel_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","І зрабіў Ной; усё, што загадаў яму Бог, так ён і зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","І сказаў ГОСПАД Ною: «Увайдзі ты і ўвесь дом твой у каўчэг, бо ўбачыў Я цябе праведным перад абліччам Маім у пакаленьні гэтым. ");
INSERT INTO bel_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","З усякай скаціны чыстай вазьмі з сабою сем самцоў і сем саміц, а са скаціны нячыстай — па двое, самца і саміцу. ");
INSERT INTO bel_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Таксама з птушак паднебных — сем мужчынскага роду і сем жаночага, каб захаваць жывым насеньне іхняе на абліччы ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Бо праз сем дзён Я выльлю дождж на зямлю сорак дзён і сорак начэй і вынішчу з аблічча зямлі ўсіх жывых істотаў, якіх Я зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","І зрабіў Ной усё, што загадаў яму ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","І Ною было шэсьцьсот гадоў, і патоп водны быў на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","І ўвайшоў Ной, і сыны ягоныя, і жонка ягоная, і жонкі сыноў ягоных з ім у каўчэг ад вады патопу. ");
INSERT INTO bel_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Са скаціны чыстай і са скаціны, якая нячыстая, з птушак і з усяго, што поўзае па зямлі, ");
INSERT INTO bel_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","па двое ўвайшлі ў каўчэг да Ноя, мужчынскага роду і жаночага, як Бог загадаў Ною. ");
INSERT INTO bel_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","І сталася праз сем дзён, што вада патопу была на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","У шэсьцьсотым годзе жыцьця Ноя, у другім месяцы, у сямнаццаты дзень месяца, у гэты дзень выбіліся ўсе жаролы вялікай бездані, і вокны нябесныя адчыніліся, ");
INSERT INTO bel_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","і ішоў дождж на зямлю сорак дзён і сорак начэй. ");
INSERT INTO bel_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","У гэты самы дзень увайшоў у каўчэг Ной, і Сэм, і Хам, i Яфэт, сыны Ноя, і жонка Ноя, і тры жонкі сыноў ягоных з імі. ");
INSERT INTO bel_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Яны, і ўсякія зьвяры паводле гатунку свайго, і ўсякая скаціна паводле гатунку свайго, і ўсякія паўзуны, якія поўзаюць па зямлі, паводле гатунку свайго, і ўсякія птушкі паводле гатунку свайго, усё птаства, усе крылатыя. ");
INSERT INTO bel_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","І ўвайшлі яны па двое ў каўчэг да Ноя, па двое з кожнага цела, у якім быў дух жыцьця. ");
INSERT INTO bel_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","І тыя, што ўвайшлі, былі мужчынскага роду і жаночага з усякага цела, як загадаў Бог. І зачыніў ГОСПАД за імі каўчэг. ");
INSERT INTO bel_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","І стаўся патоп на зямлі сорак дзён, і разьліліся воды, і паднялі каўчэг, і ён узвысіўся над зямлёю. ");
INSERT INTO bel_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","І падымаліся воды, і вельмі ўзьняліся над зямлёю, і каўчэг плаваў па абліччы водаў. ");
INSERT INTO bel_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","І вельмі моцна падняліся воды над зямлёю, і закрылі ўсе высокія горы, якія ёсьць пад усім небам. ");
INSERT INTO bel_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","На пятнаццаць локцяў угору падняліся воды, і закрылі горы. ");
INSERT INTO bel_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","І загінула ўсякае цела, якое рухаецца па зямлі: і птушкі, і скаціна, і зьвяры, і ўсе паўзуны, што поўзаюць па зямлі, і ўсе людзі. ");
INSERT INTO bel_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Усе, якія мелі дыханьне духа жыцьця ў ноздрах сваіх, усе, што былі на сухазем’і, — паўміралі. ");
INSERT INTO bel_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","І вынішчыў Бог усякую жывую істоту, якая была на абліччы зямлі, ад чалавека да скаціны, да паўзуноў і да птушак паднебных, і былі яны вынішчаны з зямлі. І застаўся толькі Ной і тыя, што былі з ім у каўчэгу. ");
INSERT INTO bel_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","І падымаліся воды над зямлёю сто пяцьдзясят дзён. ");
INSERT INTO bel_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","І ўзгадаў Бог пра Ноя і пра ўсіх зьвяроў, і пра ўсю скаціну, што былі з ім у каўчэгу, і прывёў Бог вецер на зямлю, і супакоіліся воды. ");
INSERT INTO bel_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","І зачыніліся жаролы бездані і вокны нябесныя, і спыніўся дождж з неба. ");
INSERT INTO bel_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","І вярталіся воды з зямлі, сьцякаючы і вяртаючыся, і паменшалі воды па заканчэньні ста пяцідзесяці дзён. ");
INSERT INTO bel_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","І спыніўся каўчэг у сёмы месяц, у сямнаццаты дзень месяца, на гарах Арарат. ");
INSERT INTO bel_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","І воды сьцякалі і меншалі аж да дзясятага месяца, а ў дзясяты месяц, у першы дзень месяца, сталі бачныя вяршыні гораў. ");
INSERT INTO bel_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","І сталася па заканчэньні сарака дзён Ной адчыніў вакно каўчэгу, якое зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","І выпусьціў ён крумкача, і той лятаў туды і сюды, і варочаўся, аж пакуль ня высахла вада на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","І выпусьціў ён ад сябе галубку, каб убачыць, ці зыйшлі воды з аблічча зямлі. ");
INSERT INTO bel_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","І не знайшла галубка месца спачынку для ног сваіх, і вярнулася да яго ў каўчэг, бо воды былі яшчэ на абліччы ўсёй зямлі. І ён выцягнуў руку сваю, і схапіў яе, і забраў да сябе ў каўчэг. ");
INSERT INTO bel_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","І пачакаў ён яшчэ сем дзён, і зноў выпусьціў галубку з каўчэгу. ");
INSERT INTO bel_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","І вярнулася галубка да яго ўвечары, і вось, сьвежы аліўкавы лісток у дзюбе ў яе. І зразумеў Ной, што зыйшлі воды з зямлі. ");
INSERT INTO bel_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","І пачакаў ён яшчэ іншых сем дзён, і выпусьціў галубку, і яна ўжо больш да яго не вярнулася. ");
INSERT INTO bel_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","І сталася, у шэсьцьсот першым годзе, у першым месяцы, у першы дзень месяца, што воды на зямлі павысыхалі. І Ной адкрыў дах каўчэгу, і ўбачыў, што, вось, высахла аблічча зямлі. ");
INSERT INTO bel_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","А ў другім месяцы, у дваццаць сёмы дзень месяца зямля абсохла. ");
INSERT INTO bel_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","І сказаў Бог Ною, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Выйдзі з каўчэгу ты і жонка твая, і сыны твае, і жонкі сыноў тваіх з табою. ");
INSERT INTO bel_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Усіх зьвяроў, якія з табою з кожнага цела, як з птушак, так i са скаціны, і з усіх паўзуноў, што рухаюцца па зямлі, вывядзі з сабою. І няхай разыходзяцца яны на зямлі, няхай плодзяцца і множацца на зямлі». ");
INSERT INTO bel_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","І выйшаў Ной, і сыны ягоныя, і жонка ягоная, і жонкі сыноў ягоных з ім. ");
INSERT INTO bel_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Усе зьвяры, усе паўзуны, усе птушкі і ўсё, што рухаецца па зямлі, паводле родаў сваіх, выйшлі з каўчэгу. ");
INSERT INTO bel_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","І збудаваў Ной ахвярнiк ГОСПАДУ, і ўзяў з кожнай скаціны чыстай і з кожнай птушкі чыстай, і склаў іх у ахвяру цэласпаленьня на ахвярнiку. ");
INSERT INTO bel_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","І адчуў ГОСПАД пах прыемны, і сказаў ГОСПАД у сэрцы Сваім: «Ня буду больш праклінаць зямлю з-за чалавека, бо настаўленьне сэрца чалавечага злое ад маладосьці яго. І больш ня буду забіваць усяго жывога, як гэта зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","І яшчэ, у-ва ўсе дні зямлі ня спыняцца сяўба і жніво, сьцюжа і сьпякота, лета і зіма, дзень і ноч». ");
INSERT INTO bel_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","І дабраславіў Бог Ноя і сыноў ягоных, і сказаў ім: «Пладзіцеся і множцеся, і напаўняйце зямлю. ");
INSERT INTO bel_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Няхай баяцца вас і дрыжаць перад вамі ўсе зьвяры зямныя, і ўсе птушкі паднебныя; і ўсё, што рухаецца па зямлі, і ўсе рыбы марскія аддадзеныя ў рукі вашыя. ");
INSERT INTO bel_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Усё, што рухаецца, што жыве, будзе вам на ежу; як траву зялёную, Я даў вам усё. ");
INSERT INTO bel_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Толькі цела з душою ягонай, з крывёю яго, ня ешце. ");
INSERT INTO bel_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","І толькі кроў вашу душаў вашых Я буду шукаць; з рукі ўсякага зьвера буду шукаць яе; i з рукі чалавека, з рукі кожнага брата ягонага буду шукаць душу чалавека. ");
INSERT INTO bel_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Хто праліе кроў чалавека, таго кроў будзе праліта рукою чалавека, бо чалавек зроблены на вобраз Божы. ");
INSERT INTO bel_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","А вы пладзіцеся і множцеся, распаўсюджвайцеся на зямлі і множцеся на ёй». ");
INSERT INTO bel_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","І сказаў Бог Ною і сынам ягоным з ім, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Вось, Я заключаю запавет Мой з вамі і з насеньнем вашым пасьля вас, ");
INSERT INTO bel_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","і з усякаю душою жывою, якая з вамі: з птушкамі, са скацінай і з усімі зьвярамі зямнымі, якія з вамі, з усімі, што выйшлі з каўчэгу, з усімі зьвярамі зямлі. ");
INSERT INTO bel_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","І Я заключаю запавет Мой з вамі, і ўжо больш ня будзе вынішчана ўсякае цела водамі патопу, і больш ня будзе патопу, каб нiшчыць зямлю». ");
INSERT INTO bel_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","І сказаў Бог: «Гэта знак запавету, якi Я заключаю паміж Мною і вамі і ўсякай душой жывою, якая з вамі, у пакаленьні вечныя. ");
INSERT INTO bel_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Вясёлку Маю кладу на хмарах, і будзе яна знакам запавету паміж Мною і паміж зямлёю. ");
INSERT INTO bel_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","І станецца, калі расьцягну хмары над зямлёю, будзе відаць вясёлку на хмарах, ");
INSERT INTO bel_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","і Я ўзгадаю запавет Мой, якi паміж Мною і вамі і ўсякай душой жывою ў-ва ўсякім целе, і ня будзе больш водаў патопу, каб нішчыць усякае цела. ");
INSERT INTO bel_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","І будзе гэтая вясёлка на хмарах, і Я ўбачу яе, і ўзгадаю запавет вечны паміж Богам і ўсякай душой жывою ў-ва ўсякім целе, якое ёсьць на зямлі». ");
INSERT INTO bel_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","І сказаў Бог Ною: «Гэта знак запавету, якi Я даю, паміж Мною і ўсякім целам, якое ёсьць на зямлі». ");
INSERT INTO bel_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","І былі сыны Ноя, якія выйшлі з каўчэгу: Сэм, Хам і Яфэт. А Хам быў бацькам Ханаана. ");
INSERT INTO bel_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Гэтыя тры былі сынамі Ноя, і ад іх напоўнілася людзьмі ўся зямля. ");
INSERT INTO bel_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","І Ной пачаў абрабляць зямлю, і пасадзіў вінаграднік. ");
INSERT INTO bel_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","І выпіў ён віна, і напіўся, і ляжаў голы ў сярэдзіне намёту. ");
INSERT INTO bel_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","І ўбачыў Хам, бацька Ханаана, голасьць бацькі свайго, і распавёў двум братам сваім, якія былі звонку. ");
INSERT INTO bel_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","І ўзялі Сэм і Яфэт адзежу і ўсклалі на плечы свае, і пайшлі сьпінаю, і накрылі голасьць бацькі свайго; і абліччы іхнія былі зьвернутыя назад, і яны ня бачылi голасьцi бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","І прачнуўся Ной ад ап’яненьня свайго, і даведаўся, што яму зрабіў малодшы сын ягоны, ");
INSERT INTO bel_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","і сказаў: «Пракляты Ханаан! Будзе ён слугою слугаў у братоў сваіх». ");
INSERT INTO bel_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","І сказаў: «Дабраслаўлёны ГОСПАД, Бог Сэма! Няхай будзе Ханаан слугою ягоным. ");
INSERT INTO bel_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Няхай пашырыць Бог Яфэта, і будзе ён жыць у намётах Сэма, і Ханаан будзе ў яго слугою». ");
INSERT INTO bel_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","І жыў Ной пасьля патопу трыста пяцьдзясят гадоў. ");
INSERT INTO bel_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","І было ўсіх дзён Ноя дзевяцьсот пяцьдзясят гадоў, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Вось радавод сыноў Ноя: Сэма, Хама і Яфэта. І нарадзіліся ім сыны пасьля патопу. ");
INSERT INTO bel_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Сыны Яфэта: Гамэр, Магог, Мадай, Яван, Туваль, Мэшэх і Тырас. ");
INSERT INTO bel_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Сыны Гамэра: Ашкеназ, Рыфат і Тагарма. ");
INSERT INTO bel_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Сыны Явана: Эліша i Таршыш, Кіттым і Даданім. ");
INSERT INTO bel_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ад іх паходзяць астравы народаў у землях іхніх, кожны паводле мовы сваёй і паводле плямёнаў сваіх, у народах сваіх. ");
INSERT INTO bel_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Сыны Хама: Куш, Міцраім, Пут i Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Сыны Куша: Сэва, Хавіля, Саўта, Раама i Саўтэха. Сыны Раамы: Шэва і Дэдан. ");
INSERT INTO bel_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","А Куш нарадзіў Німрода. Ён пачаў быць волатам на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ён быў магутны паляўнічы перад абліччам ГОСПАДА. Таму кажуць: «Як Німрод, магутны паляўнічы перад абліччам ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","І пачаткам валадараньня яго былі Бабілон, Эрэх, Акад і Кальнэ ў зямлі Шынаар. ");
INSERT INTO bel_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","З той зямлі выйшаў Ашур і пабудаваў Нініву, Рэхавот-Ір, Калях ");
INSERT INTO bel_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","і Рэсэн, вялікі горад між Нінівай і Каляхам. ");
INSERT INTO bel_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","А Міцраім нарадзіў Людыма, Анаміма, Легавіма, Нафтухіма, ");
INSERT INTO bel_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Патрусіма і Касьлюхіма, ад якіх паходзяць Філістынцы, і Кафторыма. ");
INSERT INTO bel_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","А Ханаан нарадзіў Сідона, першароднага свайго, і Хета, ");
INSERT INTO bel_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Евусэя, Амарэя, Гіргашэя, ");
INSERT INTO bel_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Хівея, Аркея, Сінэя, ");
INSERT INTO bel_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Арвадэя, Цэмарэя і Хаматэя; а пасьля расьсеяліся плямёны Хананейскія. ");
INSERT INTO bel_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","І была мяжа Хананейцаў ад Сідону ў накірунку Герару аж да Газы, а ў накірунку Садома і Гаморы, Адмы і Цэвоіма — аж да Ляшы. ");
INSERT INTO bel_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Гэта сыны Хама паводле плямёнаў сваіх, паводле моваў сваіх, у землях сваіх і ў народах сваіх. ");
INSERT INTO bel_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","А Сэм, бацька ўсіх сыноў Эвэра, старэйшы брат Яфэта, нарадзіў сыноў. ");
INSERT INTO bel_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Сыны Сэма: Элям, Ашур, Арпахшад, Люд і Арам. ");
INSERT INTO bel_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Сыны Арама: Уц, Хуль, Гетэр і Маш. ");
INSERT INTO bel_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","А Арпахшад нарадзіў Шэляха, а Шэлях нарадзіў Эвэра. ");
INSERT INTO bel_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","А ў Эвэра нарадзіліся два сыны: аднаго імя Пэлег, таму што ў дні ягоныя разьдзялілася зямля, а імя брата ягонага — Ёктан. ");
INSERT INTO bel_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ёктан нарадзіў Альмадада, Шалефа, Хацармавэта, Яраха, ");
INSERT INTO bel_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Гадарама, Узаля, Дыклю, ");
INSERT INTO bel_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Аваля, Авімаэля, Шэву, ");
INSERT INTO bel_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Афіра, Хавіля і Ёвава. Гэтыя ўсе — сыны Ёктана. ");
INSERT INTO bel_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Месца іх пражываньня было ад Мэшы ў накірунку Сэфару на ўсход. ");
INSERT INTO bel_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Гэта сыны Сэма паводле плямёнаў сваіх, паводле моваў сваіх, у землях сваіх і ў народах сваіх. ");
INSERT INTO bel_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Гэта вось плямёны сыноў Ноя паводле радаводаў у народах сваіх. Ад іх распаўсюдзiліся народы на зямлі пасьля патопу. ");
INSERT INTO bel_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","І была на ўсёй зямлі адна мова і адны словы. ");
INSERT INTO bel_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","І сталася, калі яны вандравалі з усходу, знайшлі раўніну ў зямлі Шынаар і там пасяліліся. ");
INSERT INTO bel_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","І сказалі яны адзін аднаму: «Давайце наробім цэглы і абпалім яе агнём». І была ў іх цэгла замест камянёў, а смала была ў іх замест вапны. ");
INSERT INTO bel_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","І сказалі яны: «Давайце зробім сабе горад і вежу, у якой верх будзе да неба, і гэтым зробім сабе імя, каб не расьцярушыліся мы па абліччы ўсёй зямлі». ");
INSERT INTO bel_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","І зыйшоў ГОСПАД, каб убачыць горад і вежу, якую будавалі сыны чалавечыя. ");
INSERT INTO bel_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","І сказаў ГОСПАД: «Вось, адзін народ і адна для ўсіх мова. І вось, што пачалі яны рабіць. І цяпер не спыніць іх у-ва ўсім, што яны задумалі зрабіць. ");
INSERT INTO bel_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Давайце зыйдзем і памяшаем там мову іхнюю, каб не маглі разумець мовы адзін аднаго». ");
INSERT INTO bel_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","І расьцярушыў іх ГОСПАД з таго месца па абліччы ўсёй зямлі, і яны перасталі будаваць горад. ");
INSERT INTO bel_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Дзеля таго названа імя яго Бабілон, бо там зьмяшаў ГОСПАД мову ўсёй зямлі, і адтуль расьцярушыў іх ГОСПАД па абліччы ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Вось радавод Сэма. Сэм меў сто гадоў і нарадзіў Арпахшада праз два гады пасьля патопу. ");
INSERT INTO bel_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","І жыў Сэм па нараджэньні Арпахшада пяцьсот гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","І Арпахшад жыў трыццаць пяць гадоў, і нарадзіў Шэляха. ");
INSERT INTO bel_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","І жыў Арпахшад па нараджэньні Шэляха чатырыста тры гады, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","І Шэлях жыў трыццаць гадоў, і нарадзіў Эвэра. ");
INSERT INTO bel_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","І жыў Шэлях па нараджэньні Эвэра чатырыста тры гады, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","І жыў Эвэр трыццаць чатыры гады, і нарадзіў Пэлега. ");
INSERT INTO bel_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","І жыў Эвэр па нараджэньні Пэлега чатырыста трыццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","І жыў Пэлег трыццаць гадоў, і нарадзіў Рэву. ");
INSERT INTO bel_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","І жыў Пэлег па нараджэньні Рэву дзьвесьце дзевяць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","І жыў Рэву трыццаць два гады, і нарадзіў Сэруга. ");
INSERT INTO bel_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","І жыў Рэву па нараджэньні Сэруга дзьвесьце сем гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","І жыў Сэруг трыццаць гадоў, і нарадзіў Нахора. ");
INSERT INTO bel_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","І жыў Сэруг па нараджэньні Нахора дзьвесьце гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","І жыў Нахор дваццаць дзевяць гадоў, і нарадзіў Тэраха. ");
INSERT INTO bel_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","І жыў Нахор па нараджэньні Тэраха сто дзевятнаццаць гадоў, і нарадзіў сыноў і дачок. ");
INSERT INTO bel_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","І жыў Тэрах семдзясят гадоў, і нарадзіў Абрама, Нахора і Арана. ");
INSERT INTO bel_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","І вось радавод Тэраха. Тэрах нарадзіў Абрама, Нахора і Арана, а Аран нарадзіў Лота. ");
INSERT INTO bel_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","І памёр Аран перад абліччам Тэраха, бацькі свайго, у зямлі нараджэньня свайго, у Уры Халдэйскім. ");
INSERT INTO bel_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","І ўзялі Абрам і Нахор сабе жонак. Імя жонкі Абрама — Сарай, а імя жонкі Нахора — Мілька, дачка Арана, бацькі Мількі і бацькі Іскі. ");
INSERT INTO bel_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","І была Сарай бясплодная, яна ня мела дзяцей. ");
INSERT INTO bel_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","І ўзяў Тэрах Абрама, сына свайго, і Лота, сына Арана, унука свайго, і Сарай, нявестку сваю, жонку Абрама, сына свайго, і выйшаў з імі з Уру Халдэйскага, каб ісьці ў зямлю Ханаан. І прыйшлі ў Харан, і пасяліліся там. ");
INSERT INTO bel_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","І было дзён Тэраха дзьвесьце пяць гадоў жыцьця, і памёр Тэрах у Харане. ");
INSERT INTO bel_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","І сказаў ГОСПАД Абраму: «Выйдзі з зямлі тваёй і ад родзічаў тваіх, і з дому бацькі твайго ў зямлю, якую Я пакажу табе. ");
INSERT INTO bel_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","І Я зраблю з цябе вялікі народ, і дабраслаўлю цябе, і ўзьвялічу імя тваё, і будзеш ты дабраславенствам. ");
INSERT INTO bel_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","І Я дабраслаўлю тых, якія будуць дабраслаўляць цябе, а тых, якія будуць праклінаць цябе, Я пракляну. І будуць дабраслаўлёныя ў табе ўсе плямёны зямлі». ");
INSERT INTO bel_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","І пайшоў Абрам, як загадаў яму ГОСПАД, і з ім пайшоў Лот. Абрам меў семдзясят пяць гадоў, калі выйшаў з Харану. ");
INSERT INTO bel_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","І ўзяў Абрам Сарай, жонку сваю, і Лота, сына брата свайго, і ўсю маёмасьць, якую прыдбалі, і слугаў, якіх набылі ў Харане, і выйшлі, каб пайсьці ў зямлю Ханаан. І прыйшлі яны ў зямлю Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","І прайшоў Абрам гэтую зямлю аж да мясцовасьці Сыхем, аж да дубровы Марэ. А ў той зямлі жылі тады Хананейцы. ");
INSERT INTO bel_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","І зьявіўся ГОСПАД Абраму, і сказаў: «Насеньню твайму Я дам гэтую зямлю». І ён збудаваў там ахвярнiк ГОСПАДУ, Які зьявіўся яму. ");
INSERT INTO bel_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Адтуль перайшоў ён на гару на ўсход ад Бэтэлю і паставіў намёт свой, маючы Бэтэль на захадзе, а Гай на ўсходзе. І там збудаваў ахвярнiк ГОСПАДУ, і заклікаў імя ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","І вандраваў Абрам далей, і павандраваў у Нэгеў. ");
INSERT INTO bel_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","І стаўся голад у той зямлі. І зыйшоў Абрам у Эгіпет, каб пажыць там, бо вялікі голад быў у той зямлі. ");
INSERT INTO bel_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","І сталася, калі набліжаліся яны да Эгіпту, сказаў ён жонцы сваёй Сарай: «Вось, я ведаю, што ты жанчына прыгожая, ");
INSERT INTO bel_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","і станецца, калі ўбачаць цябе Эгіпцяне і скажуць: “Гэта жонка яго”, яны заб’юць мяне, а цябе пакінуць. ");
INSERT INTO bel_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Дык кажы, што ты — сястра мая, каб мне было добра дзеля цябе і каб я застаўся жывы дзякуючы табе». ");
INSERT INTO bel_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","І сталася, калі Абрам прыйшоў у Эгіпет, убачылі Эгіпцяне, што Сарай вельмі прыгожая жанчына. ");
INSERT INTO bel_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","І ўбачылі яе князі фараона, і хвалілі яе перад фараонам. І была ўзятая жанчына ў дом фараона. ");
INSERT INTO bel_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","А Абраму было добра дзеля яе. І сталася, што атрымаў ён авечак і валоў, і аслоў, і слугаў, і нявольніцаў, і асьліцаў, і вярблюдаў. ");
INSERT INTO bel_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","І наведаў ГОСПАД фараона і дом ягоны вялікімі карамі з прычыны Сарай, жонкі Абрама. ");
INSERT INTO bel_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","І паклікаў фараон Абрама, і сказаў яму: «Што ты мне зрабіў? Чаму не сказаў мне, што яна — жонка твая? ");
INSERT INTO bel_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Чаму ты казаў: “Яна — сястра мая”, і я ўзяў яе сабе за жонку? Вось табе жонка твая, бяры і ідзі!» ");
INSERT INTO bel_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","І загадаў фараон людзям сваім, і яны выслалі Абрама, і жонку ягоную, і ўсё, што ён меў. ");
INSERT INTO bel_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","І падняўся Абрам з Эгіпту сам і жонка ягоная, і ўсё, што ён меў, і Лот з ім, у Нэгеў. ");
INSERT INTO bel_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","І быў Абрам вельмі багаты статкамі, срэбрам і золатам. ");
INSERT INTO bel_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","І ён ішоў у падарожжы сваім з Нэгеву ў Бэтэль, аж да месца, дзе раней быў намёт ягоны між Бэтэлем і Гаем, ");
INSERT INTO bel_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","да таго месца, дзе раней ён збудаваў ахвярнiк; і там клікаў Абрам імя ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Таксама Лот, які ішоў з Абрамам, меў авечак, валоў і намёты. ");
INSERT INTO bel_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","І не магла зямля насіць іх, каб жылі разам, бо маёмасьць іх была вялікая і не маглі яны жыць разам. ");
INSERT INTO bel_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","І была спрэчка паміж пастухамі статкаў Абрама і пастухамі статкаў Лота. А ў той час Хананейцы і Пэрэзэі жылі ў той зямлі. ");
INSERT INTO bel_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","І сказаў Абрам Лоту: «Няхай ня будзе спрэчкі паміж мной і табой, і паміж пастухамі маімі і пастухамі тваімі, бо мы ж браты. ");
INSERT INTO bel_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ці ня ўся гэтая зямля перад табою? Прашу, адлучыся ад мяне! Калі ты ўлева, дык я — управа, а калі ты ўправа, дык я — улева». ");
INSERT INTO bel_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","І ўзьняў Лот вочы свае, і ўбачыў усю ваколіцу каля Ярдану аж да Цаару, бо ўся яна была напоеная вадой перад тым, як зьнішчыў ГОСПАД Садом і Гамору, як сад ГОСПАДА і як зямля Эгіпецкая. ");
INSERT INTO bel_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","І выбраў сабе Лот усю ваколіцу каля Ярдану. І рушыў Лот на ўсход, і аддзяліліся яны адзін ад аднаго. ");
INSERT INTO bel_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Абрам жыў у зямлі Ханаан, а Лот жыў у гарадах той ваколіцы і паставіў намёты аж да Садому. ");
INSERT INTO bel_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","А жыхары Садому былі ліхімі і вялікімі грэшнікамі перад ГОСПАДАМ. ");
INSERT INTO bel_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","І сказаў ГОСПАД Абраму пасьля таго, як Лот адлучыўся ад яго: «Узьнімі вочы твае і паглядзі з месца, дзе ты цяпер, на поўнач і на поўдзень, на ўсход і на захад. ");
INSERT INTO bel_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Бо ўсю зямлю, якую бачыш, Я дам табе і насеньню твайму на вякі. ");
INSERT INTO bel_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","І зраблю насеньне тваё, як пясок зямлі. Калі чалавек зможа палічыць пясок зямлі, тады і тваё насеньне палічана будзе. ");
INSERT INTO bel_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Устань і прайдзі па зямлі гэтай у даўжыню і шырыню яе, бо Я дам яе табе». ");
INSERT INTO bel_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","І паставіў Абрам намёт, і пайшоў, і абжыўся каля дубровы Мамрэ, што ў Хеўроне, і пабудаваў там ахвярнiк ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","І сталася ў дні Амрафэля, валадара Шынаару, і Арыёха, валадара Элясару, і Кедарляамэра, валадара Эляму, і Тыдаля, валадара Гаіму, ");
INSERT INTO bel_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","пачалі яны вайну супраць Бэры, валадара Садому, і Біршы, валадара Гаморы, і Шынава, валадара Адмы, і Шэмэвэра, валадара Цэвоіму, і валадара Бэлі або Цаару. ");
INSERT INTO bel_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Усе яны злучыліся ў даліне Сыддым, яна цяпер Мора Салёнае. ");
INSERT INTO bel_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дванаццаць гадоў служылі яны Кедарляамэру, а ў трынаццатым годзе ўзбунтаваліся. ");
INSERT INTO bel_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","А ў чатырнаццатым годзе прыйшоў Кедарляамэр і валадары, якія з ім, і пабілі Рэфаімаў у Аштэрот-Карнаіме, і Зузімаў у Гаме, і Эмімаў у Шавэ-Кірыятаіме, ");
INSERT INTO bel_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","і Харэяў на гары іхняй Сэір аж да Эль-Парану, што ў пустыні. ");
INSERT INTO bel_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","І вярнуліся яны, і прыйшлі да Эн-Мішпату, які цяпер Кадэш, і пабілі ўсю краіну Амалека, а таксама Амарэяў, што жылі ў Хацацон-Тамары. ");
INSERT INTO bel_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","І выйшаў валадар Садому, і валадар Гаморы, і валадар Адмы, і валадар Цэвоіму, і валадар Бэлі або Цаару, і пашыхтаваліся ў даліне Сыддым да бою ");
INSERT INTO bel_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","з Кедарляамэрам, валадаром Эляму, і Тыдалем, валадаром Гаіму, і Амрафэлем, валадаром Шынаару, і Арыёхам, валадаром Элясару, чатыры валадары супраць пяці. ");
INSERT INTO bel_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","І былі ў даліне Сыддым ямы, ямы смалавыя. І ўцякалі валадары Садому і Гаморы, і ўпалі ў тыя ямы, а астатнія ўцяклі на гару. ");
INSERT INTO bel_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","І ўзялі пераможцы ўсю маёмасьць Садому і Гаморы і ўсе запасы харчоў, і пайшлі. ");
INSERT INTO bel_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","І ўзялі яны Лота, сына брата Абрама, і маёмасьць ягоную, і пайшлі. А ён жыў у Садоме. ");
INSERT INTO bel_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","І прыйшоў адзін з тых, што ўцяклі, і паведаміў Абраму Гебраю, які жыў каля дубровы Мамрэ Амарэя, брата Эшколя і брата Анэра, якія заключылі запавет з Абрамам. ");
INSERT INTO bel_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","І пачуў Абрам, што ўзяты ў палон брат ягоны, і ўзброіў трыста васямнаццаць спраўных слугаў сваіх, народжаных у доме яго, і рушыў у пагоню аж пад Дан. ");
INSERT INTO bel_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","І, падзяліўшыся, напаў на іх ноччу, ён і слугі ягоныя, і разьбіў іх, і гнаў іх аж да Ховы, што зьлева ад Дамаску. ");
INSERT INTO bel_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","І вярнуў ён усю маёмасьць, а таксама Лота, брата свайго, і маёмасьць ягоную, і жанчынаў, і народ. ");
INSERT INTO bel_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","І выйшаў валадар Садому насустрач яму, калі ён вяртаўся пасьля пабіцьця Кедарляамэра і валадароў, што з ім былі, у даліну Шавэ, яна цяпер даліна Валадарская. ");
INSERT INTO bel_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","І Мэльхісэдэк, валадар Салему, вынес хлеб і віно, а ён быў сьвятаром Бога Найвышэйшага, ");
INSERT INTO bel_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","і дабраславіў яго, і сказаў: «Дабраслаўлёны Абрам праз Бога Найвышэйшага, Пана неба і зямлі. ");
INSERT INTO bel_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","І дабраслаўлёны Бог Найвышэйшы, Які аддаў ворагаў тваіх у рукі твае». І даў яму Абрам дзесяціну з усяго. ");
INSERT INTO bel_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","І сказаў валадар Садому Абраму: «Аддай мне людзей, а маёмасьць вазьмі сабе». ");
INSERT INTO bel_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","І сказаў Абрам валадару Садому: «Узьнімаю руку маю да ГОСПАДА, Бога Найвышэйшага, Пана неба і зямлі, ");
INSERT INTO bel_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","што ані ніткі, ані раменьчыка ад сандалаў, нічога не вазьму з усяго таго, што тваё, каб ты не сказаў: “Я ўзбагаціў Абрама”, ");
INSERT INTO bel_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","акрамя таго, што зьелі юнакі, і акрамя часткі для людзей, якія хадзілі са мною. Анэр, Эшколь і Мамрэ няхай возьмуць частку сваю». ");
INSERT INTO bel_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Пасьля гэтых падзеяў было слова ГОСПАДА да Абрама ў відзежы, кажучы: «Ня бойся, Абраме! Я — шчыт твой, узнагарода твая вельмі вялікая». ");
INSERT INTO bel_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","І сказаў Абрам: «Госпадзе ГОСПАДЗЕ, што Ты дасі мне? Я хаджу бязьдзетны, і распарадчык у доме маім — Эліезэр з Дамаску». ");
INSERT INTO bel_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","І сказаў Абрам: «Вось, ня даў Ты мне насеньня. І вось, народжаны ў доме маім слуга будзе спадкаемцам маім». ");
INSERT INTO bel_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","І вось, слова ГОСПАДА да яго, кажучы: «Ня ён успадкаеміць цябе, але той, які выйдзе з нутра твайго, успадкаеміць цябе». ");
INSERT INTO bel_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","І вывеў яго вонкі, і сказаў: «Паглядзі на неба і палічы зоркі, калі зможаш палічыць іх». І сказаў яму: «Такім будзе насеньне тваё». ");
INSERT INTO bel_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","І паверыў ён ГОСПАДУ, і Ён залічыў гэта яму за праведнасьць. ");
INSERT INTO bel_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","І сказаў яму: «Я — ГОСПАД, Які вывеў цябе з Уру Халдэйскага, каб даць табе гэтую зямлю ў валоданьне». ");
INSERT INTO bel_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","А ён сказаў: «Госпадзе ГОСПАДЗЕ, з чаго магу ведаць, што я буду валодаць ёю?» ");
INSERT INTO bel_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","І Госпад сказаў яму: «Вазьмі Мне трохгадовую цялушку, і трохгадовую казу, і трохгадовага барана, туркаўку і галубянятка». ");
INSERT INTO bel_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","І Абрам узяў усё гэта, і расьцяў іх уздоўж, і паклаў кожную частку адну насупраць другой, але птушак не расьцінаў. ");
INSERT INTO bel_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","І зьляцеліся драпежныя птушкі на гэтае мяса, і Абрам адганяў іх. ");
INSERT INTO bel_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","І сталася, калі сонца заходзіла, моцны сон ахапіў Абрама. І вось, жах і цемра вялікая ахапілі яго. ");
INSERT INTO bel_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","І сказаў Госпад Абраму: «Ведаючы, ведай, што насеньне тваё будзе прыхаднямі ў зямлі не сваёй, і будуць служыць яны, і будуць прыгнятаць іх чатырыста гадоў. ");
INSERT INTO bel_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Але з народам, якому будуць яны служыць, Я буду змагацца, і пасьля таго выйдуць яны з вялікай маёмасьцю. ");
INSERT INTO bel_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","А ты пойдзеш да бацькоў сваіх у супакоі, і будзеш пахаваны ў добрай старасьці. ");
INSERT INTO bel_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","І ў чацьвёртым пакаленьні яны вернуцца сюды, бо яшчэ не дапоўнілася мера беззаконьняў Амарэяў». ");
INSERT INTO bel_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","І сталася, калі зайшло сонца і была цемра, вось, дым, нібы з печы, і полымя агню прайшлі між расьцятымі жывёламі. ");
INSERT INTO bel_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","У той дзень заключыў ГОСПАД з Абрамам запавет, кажучы: «Я даю гэтую зямлю насеньню твайму, ад ракі Эгіпецкай аж да вялікай ракі, ракі Эўфрат: ");
INSERT INTO bel_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Кенэяў, Кенэзэяў, Кад­манеяў, ");
INSERT INTO bel_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Хетаў, Пэрэзэяў, Рэфаімаў, ");
INSERT INTO bel_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Амарэяў, Хананейцаў, Гіргашэяў і Евусэяў». ");
INSERT INTO bel_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","А Сарай, жонка Абрама, не нараджала яму. І мела яна нявольніцу Эгіпцянку, а імя ейнае — Агар. ");
INSERT INTO bel_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","І сказала Сарай Абраму: «Вось, замкнуў ГОСПАД мяне, каб я не нараджала. Дык увайдзі да нявольніцы маёй, можа ад яе атрымаю дзіця». І паслухаў Абрам голасу Сарай. ");
INSERT INTO bel_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","І ўзяла Сарай, жонка Абрама, Агар Эгіпцянку, нявольніцу сваю, калі мінула дзесяць гадоў жыцьця Абрама ў зямлі Ханаан, і дала яе Абраму, мужу свайму, за жонку. ");
INSERT INTO bel_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","І ён увайшоў да Агар, і яна зачала, і ўбачыла, што зачала, і стала пагарджаць гаспадыняй сваёй у вачах сваіх. ");
INSERT INTO bel_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","І сказала Сарай Абраму: «Крыўда мая праз цябе! Я дала табе нявольніцу маю на ўлоньне тваё, і яна ўбачыла, што зачала, і стала пагарджаць мною ў вачах сваіх. Няхай ГОСПАД судзіць паміж мной і табой». ");
INSERT INTO bel_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","І сказаў Абрам Сарай: «Вось, нявольніца твая ў руцэ тваёй, рабі з ёй, што добра ў вачах тваіх». І Сарай стала ўціскаць яе, і яна ўцякла ад аблічча яе. ");
INSERT INTO bel_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","І знайшоў яе анёл ГОСПАДА каля крыніцы вады ў пустыні, каля крыніцы пры дарозе на Шур, ");
INSERT INTO bel_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","і сказаў: «Агар, нявольніца Сарай, адкуль ты прыйшла і куды ідзеш?» Яна адказала: «Ад аблічча Сарай, гаспадыні маёй, я ўцякаю». ");
INSERT INTO bel_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","І сказаў ёй анёл ГОСПАДА: «Вярніся да гаспадыні сваёй і скарыся пад руку яе». ");
INSERT INTO bel_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","І сказаў ёй анёл ГОСПАДА: «Памнажаючы, памножу насеньне тваё, нельга будзе палічыць яго з прычыны мноства». ");
INSERT INTO bel_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","І сказаў ёй анёл ГОСПАДА: «Вось, ты зачала і народзіш сына, і назавеш імя ягонае Ізмаэль, таму што ГОСПАД пачуў пра ўціск твой. ");
INSERT INTO bel_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","І будзе ён чалавекам, падобным да дзікага асла, рука ягоная супраць усіх, і рукі ўсіх — супраць яго; і будзе ён жыць перад абліччам усіх братоў сваіх». ");
INSERT INTO bel_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","І назвала яна імя ГОСПАДА, Які прамаўляў да яе: «Ты — Бог, Які бачыць мяне». Бо сказала яна: «Ці ня тут я бачыла Таго, Які бачыць мяне». ");
INSERT INTO bel_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Дзеля таго калодзеж гэты назвалі Бээр-Ляхай-Рой. Вось, ён паміж Кадэшам і Барэдам. ");
INSERT INTO bel_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","І нарадзіла Агар Абраму сына. І назваў Абрам імя сына свайго, якога нарадзіла яму Агар, Ізмаэль. ");
INSERT INTO bel_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Абрам меў восемдзясят шэсьць гадоў, калі Агар нарадзіла Ізмаэля Абраму. ");
INSERT INTO bel_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","І было Абраму дзевяноста дзевяць гадоў. І зьявіўся ГОСПАД Абраму, і сказаў яму: «Я — Бог Усемагутны. Хадзі перад абліччам Маім і будзь беззаганны. ");
INSERT INTO bel_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","І Я заключу запавет Мой паміж Мной і табой, і павялічу цябе вельмі, вельмі». ");
INSERT INTO bel_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","І ўпаў Абрам на аблічча сваё, а Бог прамовіў да яго, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Я ёсьць, вось запавет Мой з табою, і ты будзеш бацькам мноства народаў. ");
INSERT INTO bel_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","І ўжо ня будзе звацца імя тваё Абрам, але будзе імя тваё Абрагам, бо Я паставіў цябе бацькам мноства народаў. ");
INSERT INTO bel_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","І Я павялічу цябе вельмі, вельмі, і выведу з цябе народы, і будуць паходзіць ад цябе валадары. ");
INSERT INTO bel_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","І Я заключу запавет Мой паміж Мною і табой, і насеньнем тваім пасьля цябе ў пакаленьнях іхніх як запавет вечны, што Я буду Богам тваім і насеньня твайго пасьля цябе. ");
INSERT INTO bel_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","І Я дам табе і насеньню твайму пасьля цябе зямлю вандраваньня твайго, усю зямлю Ханаан на ўласнасьць вечную, і Я буду ім Богам». ");
INSERT INTO bel_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","І сказаў Бог Абрагаму: «А ты захоўвай запавет Мой, ты і насеньне тваё пасьля цябе ў пакаленьнях сваіх. ");
INSERT INTO bel_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Гэта вось запавет Мой, які вы павінны захаваць паміж Мной і вамі, і насеньнем тваім пасьля цябе: няхай будзе ў вас абрэзаны кожны мужчынскага роду. ");
INSERT INTO bel_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","І вы будзеце абразаць цела скуравінкі вашай, і будзе гэта на знак запавету паміж Мною і вамі. ");
INSERT INTO bel_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","У восьмы дзень ад нараджэньня няхай будзе абрэзаны ў вас кожны мужчынскага роду ў пакаленьнях вашых, народжаны ў доме або куплены за грошы ў кожнага чужынца, які ня ёсьць з насеньня твайго. ");
INSERT INTO bel_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Мае быць абрэзаны і народжаны ў доме тваім, і куплены за срэбра тваё; і будзе запавет Мой на целе вашым як запавет вечны. ");
INSERT INTO bel_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","А неабрэзаны мужчынскага роду, які не абрэжа цела скуравінкі сваёй, няхай будзе вынішчана душа тая з народу свайго, бо ён парушыў запавет Мой». ");
INSERT INTO bel_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","І сказаў Бог Абрагаму: «Сарай, жонку тваю, ня будзеш зваць імя яе Сарай, але Сара будзе імя яе. ");
INSERT INTO bel_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","І Я дабраслаўлю яе, і дам з яе табе сына. І Я дабраслаўлю яе, і стануцца з яе народы, і валадары народаў будуць з яе». ");
INSERT INTO bel_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","І ўпаў Абрагам на аблічча сваё, і засьмяяўся, і сказаў у сэрцы сваім: «Ці ж стогадоваму народзіцца хто? І ці Сара, дзевяностагадовая, можа нарадзіць?» ");
INSERT INTO bel_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","І сказаў Абрагам Богу: «О, каб хоць Ізмаэль жыў перад абліччам Тваім!» ");
INSERT INTO bel_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","І сказаў Бог: «Але Сара, жонка твая, народзіць табе сына, і ты назавеш імя ягонае Ісаак; і Я заключу запавет Мой з ім як запавет вечны і з насеньнем яго пасьля яго. ");
INSERT INTO bel_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","І адносна Ізмаэля Я пачуў цябе. Вось, Я дабраслаўлю яго, і распладжу яго, і памножу яго вельмі, вельмі; ён народзіць дванаццаць князёў, і Я зраблю яго народам вялікім. ");
INSERT INTO bel_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Але запавет Мой Я заключу з Ісаакам, якога народзіць табе Сара ў гэты самы час у наступным годзе». ");
INSERT INTO bel_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","І скончыў прамаўляць да яго, і ўзьняўся Бог ад Абрагама. ");
INSERT INTO bel_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","І ўзяў Абрагам Ізмаэля, сына свайго, і ўсіх народжаных у доме сваім, і ўсіх купленых за срэбра сваё, усіх мужчынскага роду з дому Абрагама, і абрэзаў цела скуравінкі іхняй у той самы дзень, калі прамаўляў да яго Бог. ");
INSERT INTO bel_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Абрагам меў дзевяноста дзевяць гадоў, калі абрэзаў цела скуравінкі сваёй, ");
INSERT INTO bel_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","а Ізмаэль, сын ягоны, меў трынаццаць гадоў, калі было абрэзана цела скуравінкі ягонай. ");
INSERT INTO bel_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","У той самы дзень былі абрэзаны Абрагам і Ізмаэль, сын ягоны. ");
INSERT INTO bel_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","І ўсе мужчыны дому ягонага, народжаныя ў доме і купленыя за срэбра ў чужынцаў, былі абрэзаныя з ім. ");
INSERT INTO bel_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","І зьявіўся яму ГОСПАД каля дубровы Мамрэ, калі ён сядзеў каля ўваходу ў намёт у сьпякоту дня. ");
INSERT INTO bel_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","І падняў ён вочы свае, і глянуў, і вось, тры мужы стаяць насупраць яго. І ён убачыў, і выбег ад уваходу ў намёт насустрач ім, і пакланіўся да зямлі, ");
INSERT INTO bel_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","і сказаў: «Госпадзе, калі я знайшоў ласку ў вачах Тваіх, прашу, не мінай слугі Свайго. ");
INSERT INTO bel_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Возьмуць трохі вады, і абмыюць ногі Вашыя, і прыхінецеся пад дрэвам. ");
INSERT INTO bel_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","А я вазьму кавалак хлеба, і пасіліце сэрцы Вашыя, потым пойдзеце, бо дзеля гэтага вы прайшлі каля слугі Вашага». Яны сказалі: «Зрабі так, як сказаў». ");
INSERT INTO bel_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","І пасьпяшаўся Абрагам у намёт да Сары, і сказаў: «Пасьпяшайся, замяшай тры меркі найлепшай мукі і зрабі аладак». ");
INSERT INTO bel_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","І пабег Абрагам да быдла, і ўзяў тлустае і добрае цяля, і даў юнаку, і той хутка прыгатаваў яго. ");
INSERT INTO bel_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","І ўзяў масла і малака, і цяля, якое прыгатаваў, і паклаў перад абліччам Іх, і сам стаў каля Іх пад дрэвам, і яны елі. ");
INSERT INTO bel_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","І сказалі яму: «А дзе Сара, жонка твая?» Ён сказаў: «Вось, у намёце». ");
INSERT INTO bel_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","А Той сказаў: «Вяртаючыся, вярнуся да цябе ў гэты час жыцьця праз год, і вось, будзе сын у Сары, жонкі тваёй». А Сара слухала каля ўваходу ў намёт, які быў за ім. ");
INSERT INTO bel_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Абрагам жа і Сара былі старыя, увайшлі ў гады, і спынілася ў Сары звычайнае жаночае. ");
INSERT INTO bel_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","І засьмяялася Сара ў сабе, кажучы: «Пасьля таго, як я састарэла, ці ж буду мець асалоду? І гаспадар мой стары». ");
INSERT INTO bel_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","І сказаў ГОСПАД Абрагаму: «Чаму сьмяялася Сара, кажучы: “Няўжо я сапраўды магу нарадзіць, калі я старая?” ");
INSERT INTO bel_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ці ж ёсьць справа, цяжкая для ГОСПАДА? У прызначаны час вярнуся да цябе ў гэты час жыцьця праз год, і Сара будзе мець сына». ");
INSERT INTO bel_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","І запярэчыла Сара, кажучы: «Я не сьмяялася», бо яна спалохалася. Але Ён сказаў: «Не, ты сьмяялася!» ");
INSERT INTO bel_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","І падняліся адтуль тыя мужы, і скіравалі аблічча Сваё да Садому, а Абрагам пайшоў з Імі, праводзячы Іх. ");
INSERT INTO bel_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","І ГОСПАД сказаў: «Ці ж схаваю Я перад Абрагамам, што маю зрабіць? ");
INSERT INTO bel_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Абрагам станецца народам вялікім і магутным, і будуць дабраслаўлёныя ў ім усе народы зямлі. ");
INSERT INTO bel_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Бо Я спазнаў яго, каб ён загадаў сынам сваім і дому свайму пасьля сябе, і будуць захоўваць шлях ГОСПАДА, чыніць праведнасьць і суд, каб ГОСПАД зьдзейсьніў Абрагаму ўсё, што сказаў яму». ");
INSERT INTO bel_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","І сказаў ГОСПАД: «Крык Садому і Гаморы вялікі, і грэх іхні вельмі цяжкі. ");
INSERT INTO bel_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Дык зыйду і пагляджу, ці паводле крыку, які даходзіць да Мяне, учыняюць усё, ці не, і буду гэта ведаць». ");
INSERT INTO bel_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","І павярнуліся тыя мужы, і пайшлі ў Садом, а Абрагам яшчэ стаяў перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","І падыйшоў Абрагам, і сказаў: «Няўжо загубіш праведнага разам з бязбожным? ");
INSERT INTO bel_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Можа, ёсьць у горадзе пяцьдзясят праведнікаў, няўжо Ты загубіш і не прабачыш гэтай мясцовасьці дзеля пяцідзесяці праведнікаў, якія ў ім? ");
INSERT INTO bel_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Няхай будзе далёкім ад Цябе, каб Ты ўчыніў такую справу, каб забіць праведнага з бязбожным, каб праведнаму было таксама, як і бязбожнаму! Няхай будзе далёкім ад Цябе! Ці ж Судзьдзя ўсёй зямлі ня ўчыніць правасудзьдзя?» ");
INSERT INTO bel_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","І сказаў ГОСПАД: «Калі знайду ў Садоме пяцьдзясят праведнікаў у горадзе, дзеля іх прабачу ўсёй мясцовасьці». ");
INSERT INTO bel_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","І адказаў Абрагам, і сказаў: «Вось жа пачаў я гаварыць да Госпада майго, хоць я — пыл і попел. ");
INSERT INTO bel_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Можа, ня хопіць пяці да гэтых пяцідзесяці праведнікаў, няўжо дзеля нястачы пяці зьнішчыш увесь горад?» І сказаў Госпад: «Ня зьнішчу, калі знайду там сорак пяць». ");
INSERT INTO bel_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","І працягваў гаварыць з Ім, і сказаў: «Можа, знойдзецца там сорак?» І Ён сказаў: «Не зраблю гэтага дзеля сарака». ");
INSERT INTO bel_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","І сказаў ён: «Няхай ня гневаецца Госпад мой, і я буду гаварыць. Можа, знойдзецца там трыццаць?» І Ён сказаў: «Не зраблю, калі знайду там трыццаць». ");
INSERT INTO bel_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","І сказаў ён: «Вось, я пачаў гаварыць да Госпада майго. Можа, знойдзецца там дваццаць?» І Ён сказаў: «Ня зьнішчу дзеля дваццаці». ");
INSERT INTO bel_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","І сказаў ён: «Няхай ня гневаецца Госпад мой, і я буду гаварыць яшчэ раз. Можа, знойдзецца там дзесяць?» І Ён сказаў: «Ня зьнішчу дзеля дзесяці». ");
INSERT INTO bel_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","І пайшоў ГОСПАД, скончыўшы гаварыць з Абрагамам, а Абрагам вярнуўся да месца свайго. ");
INSERT INTO bel_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","І прыйшлі два анёлы ў Садом увечары, а Лот сядзеў у браме Садома. І ён убачыў, і пайшоў насустрач ім, і пакланіўся абліччам да зямлі, ");
INSERT INTO bel_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","і сказаў: «Вось, прашу, гаспадары мае, зьвярніце ў дом слугі вашага і пераначуйце, і памыйце ногі свае, а раніцаю ўстанеце і пойдзеце ў дарогу сваю». А яны сказалі: «Не, бо мы будзем начаваць на вуліцы». ");
INSERT INTO bel_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Але ён іх вельмі ўпрошваў, і яны зьвярнулі да яго, і ўвайшлі ў дом ягоны. І ён справіў ім гасьціну, і напёк праснакоў, і яны елі. ");
INSERT INTO bel_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Яшчэ не ляглі яны спаць, як людзі з гораду, людзі Садомскія, ад малога да старога, увесь народ з усіх канцоў, атачылі дом. ");
INSERT INTO bel_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","І паклікалі яны Лота, і сказалі яму: «Дзе тыя людзі, якія прыйшлі да цябе ноччу? Выведзі іх да нас, і мы спазнаем іх». ");
INSERT INTO bel_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","І выйшаў да іх Лот да ўваходу, і замкнуў за сабою дзьверы, ");
INSERT INTO bel_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","і сказаў: «Прашу, браты мае, не рабіце ліхога. ");
INSERT INTO bel_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Вось, маю дзьве дачкі, якія не спазналі мужа. Выведу іх да вас, і вы рабіце з імі, што добра ў вачах вашых! Толькі людзям гэтым нічога не рабіце, бо яны прыйшлі ў цень даху майго». ");
INSERT INTO bel_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Але яны сказалі: «Ідзі прэч». І сказалі: «Сам прыйшоў пажыць, і будзе судзіць, судзячы нас? Цяпер будзе табе горш, чым ім». І накінуліся на чалавека гэтага, на Лота, і падыйшлі, каб выламіць дзьверы. ");
INSERT INTO bel_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","І выцягнулі мужы тыя рукі свае, і ўцягнулі Лота да сябе ў дом, і замкнулі дзьверы. ");
INSERT INTO bel_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","А людзей, якія былі пры ўваходзе ў дом, ад найменшага да найбольшага, пакаралі сьлепатою, і яны змучыліся, шукаючы выхаду. ");
INSERT INTO bel_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","І сказалі тыя мужы Лоту: «Ці хто яшчэ ёсьць тут у цябе? Зяця, сыноў тваіх і дачок тваіх, усіх, хто ў цябе ёсць у горадзе, выведзі з гэтага месца, ");
INSERT INTO bel_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","бо мы зьнішчым гэтую мясцовасьць, таму што вялікі крык іхні перад абліччам ГОСПАДА, і ГОСПАД паслаў нас зьнішчыць яе». ");
INSERT INTO bel_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","І выйшаў Лот, і гаварыў да зяцёў сваіх, якія мелі ўзяць дочак ягоных, і сказаў: «Уставайце, выходзьце з гэтага месца, бо ГОСПАД мае зьнішчыць горад». І было ў вачах зяцёў ягоных гэта, нібыта ён жартуе. ");
INSERT INTO bel_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Калі ўзыйшла зараніца, анёлы прысьпешвалі Лота, кажучы: «Уставай, бяры жонку тваю і дзьве дочкі твае, якія тут, каб не загінуў ты праз беззаконьні гораду гэтага». ");
INSERT INTO bel_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","А як ён марудзіў, схапілі тыя мужы за руку яго, і за руку жонку ягоную, і за руку абедзьвух дачок ягоных, бо ГОСПАД меў спагаду да яго, і вывелі яго, і паставілі па-за горадам. ");
INSERT INTO bel_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","І сталася, калі вывелі іх вонкі, сказаў адзін з іх: «Уцякай дзеля душы тваёй, і не аглядайся назад, і не затрымлівайся ў гэтай ваколіцы. Уцякай на гору, каб ты не загінуў!» ");
INSERT INTO bel_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","І сказаў Лот да іх: «О не, Госпадзе! ");
INSERT INTO bel_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Вось жа, слуга Твой знайшоў ласку ў вачах Тваіх, і Ты павялічыў міласэрнасьць Тваю, якую зьявіў для мяне, захоўваючы пры жыцьці душу маю. Але я не магу ўцячы на гору, каб не напаткала мяне ліхое, і я не памёр. ");
INSERT INTO bel_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Вось жа горад гэты блізка, каб бегчы туды, і ён малы. Дазволь уцячы мне туды, — ці ж не малы ён, — і будзе жыць душа мая». ");
INSERT INTO bel_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","І сказаў яму: «Вось, Я прыняў аблічча тваё і ў гэтым слове, і ня зьнішчу горад, пра які ты гаварыў. ");
INSERT INTO bel_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Сьпяшайся, уцякай туды, бо Я не магу нічога рабіць, пакуль ты ня прыйдзеш туды». Таму і названае імя гэтаму гораду Цаар. ");
INSERT INTO bel_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Сонца ўзыйшло над зямлёю, і Лот увайшоў у Цаар. ");
INSERT INTO bel_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","І ГОСПАД лінуў на Садом і Гамору дождж серкі і агню ад ГОСПАДА з неба, ");
INSERT INTO bel_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","і зруйнаваў гарады гэтыя, і ўсю ваколіцу, і ўсіх жыхароў гарадоў гэтых, і расьліны зямлі. ");
INSERT INTO bel_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","І аглянулася жонка Лота, ідучы за ім, і сталася слупом солі. ");
INSERT INTO bel_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","І ўстаў Абрагам раніцаю на тое месца, дзе стаяў перад абліччам ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","і глянуў на аблічча Садома і Гаморы, і на аблічча ўсёй зямлі той ваколіцы, і ўбачыў, і вось, дым падымаецца з зямлі, быццам з печы. ");
INSERT INTO bel_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","І сталася, калі Бог зьнішчыў гарады гэтай ваколіцы, узгадаў Бог пра Абрагама, і выслаў Лота спаміж руйнаваньня, калі руйнаваў гарады, у якіх жыў Лот. ");
INSERT INTO bel_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","І падняўся Лот з Цаару, і жыў на гары, і дзьве дачкі ягоныя з ім, бо баяўся жыць у Цаары. І жыў ён у пячоры, сам і дзьве дачкі ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","І сказала старэйшая малодшай: «Бацька наш стары, і няма мужчыны на зямлі, каб мог прыйсьці да нас паводле звычаю ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Хадзем, напоім бацьку нашага віном і ляжам з ім, каб ажывіць насеньне бацькі нашага». ");
INSERT INTO bel_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","І напаілі яны ў тую ноч бацьку свайго віном; і ўвайшла старэйшая, і ляжала з бацькам, а ён ня ведаў, ані калі яна легла, ані калі ўстала. ");
INSERT INTO bel_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","І сталася на другі дзень, сказала старэйшая малодшай: «Вось, я ў мінулую ноч ляжала з бацькам нашым. Напоім яго віном таксама ў гэтую ноч, і ты ўвойдзеш, і ляжаш з ім, і мы ажывім насеньне бацькі нашага». ");
INSERT INTO bel_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","І напаілі яны таксама ў гэтую ноч бацьку свайго віном, і ўвайшла малодшая дачка, і ляжала з ім, а ён ня ведаў, ані калі яна легла, ані калі ўстала. ");
INSERT INTO bel_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","І зачалі абедзьве дачкі Лота ад бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","І нарадзіла старэйшая сына, і назвала імя ягонае Мааў. Ён — бацька Мааву аж да сёньня. ");
INSERT INTO bel_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","І малодшая таксама нарадзіла сына, і назвала імя ягонае Бэн-Аммі. Ён — бацька сыноў Амона аж да сёньня. ");
INSERT INTO bel_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","I рушыў адтуль Абрагам у зямлю Нэгеў, і пасяліўся між Кадэшам і Шурам, і жыў у Герары. ");
INSERT INTO bel_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","I сказаў Абрагам пра Сару, жонку сваю: «Яна — сястра мая». I паслаў Абімэлех, валадар Герару, і ўзяў Сару. ");
INSERT INTO bel_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","I прыйшоў Бог да Абімэлеха ў сьне ўначы, і сказаў яму: «Вось, ты памрэш з прычыны жанчыны, якую ты ўзяў, бо яна мае мужа». ");
INSERT INTO bel_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","А Абімэлех не набліжаўся да яе, і сказаў: «Госпадзе! Няўжо і народ праведны Ты заб’еш? ");
INSERT INTO bel_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ці ж ня ён сказаў мне: “Яна — сястра мая”. I яна таксама казала: “Ён — брат мой”. У прастаце сэрца майго і ў чысьціні рук маіх учыніў я гэта». ");
INSERT INTO bel_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","I сказаў яму Бог у сьне: «І Я ведаю, што ў прастаце сэрца свайго ты ўчыніў гэта, і Я ўтрымаў цябе, каб ты не саграшыў перада Мною; і Я ня даў табе дакрануцца да яе. ");
INSERT INTO bel_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","А цяпер вярні жонку гэтага мужа, бо ён — прарок, і ён будзе маліцца за цябе, і ты будзеш жыць. А калі ня вернеш, ведай, што сьмерцю памрэш ты і ўсе, хто твае». ");
INSERT INTO bel_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","I ўстаў Абімэлех раніцай, і паклікаў усіх слугаў сваіх, і расказаў усе словы гэтыя ў вушы іхнія; і моцна напалохаліся людзі гэтыя. ");
INSERT INTO bel_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","I паклікаў Абімэлех Абрагама, і сказаў яму: «Што ты нам нарабіў? Чым саграшыў я супраць цябе, што ты навёў на мяне і на валадарства маё грэх вялікі? Учынкі, якія ня робяць, ты зрабіў мне». ");
INSERT INTO bel_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","I сказаў Абімэлех Абрагаму: «Што ж ты думаў, калі рабіў гэтыя рэчы?» ");
INSERT INTO bel_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","I сказаў Абрагам: «Вось, я сказаў: “Напэўна, няма страху Божага на месцы гэтым, і заб’юць мяне з прычыны жонкі маёй”. ");
INSERT INTO bel_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","І, сапраўды, яна — сястра мая, яна — дачка бацькі майго, толькі не дачка маці маёй; і яна стала маёй жонкаю. ");
INSERT INTO bel_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","I сталася, калі вывеў мяне Бог з дому бацькі майго, я сказаў ёй: “У тым міласэрнасьць твая, якую ты можаш зрабіць для мяне: у кожным месцы, куды мы прыйдзем, кажы пра мяне: ‘Ён — брат мой’”». ");
INSERT INTO bel_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","I ўзяў Абімэлех авечак і валоў, і слугаў, і нявольніцаў, і даў Абрагаму, і вярнуў яму Сару, жонку ягоную. ");
INSERT INTO bel_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I сказаў Абімэлех: «Вось, зямля мая перад табою. Дзе добра ў вачах тваіх, жыві». ");
INSERT INTO bel_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","А Сары сказаў: «Вось, я даю тысячу срэбнікаў брату твайму. Няхай гэта будзе табе заслонаю перад вачамі ўсіх, якія з табою, і перад усімі ты без віны». ");
INSERT INTO bel_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","I памаліўся Абрагам да Бога, і аздаравіў Бог Абімэлеха, і жонку ягоную, і нявольніцаў ягоных, і яны нараджалі, ");
INSERT INTO bel_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","бо зачыніўшы, зачыніў ГОСПАД кожнае ўлоньне ў доме Абімэлеха з прычыны Сары, жонкі Абрагама. ");
INSERT INTO bel_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","І ГОСПАД наведаў Сару, як сказаў; і ўчыніў ГОСПАД Сары, як гаварыў. ");
INSERT INTO bel_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","I зачала Сара, і нарадзіла сына Абрагаму ў старасьці ягонай, у час, пра які казаў яму Бог. ");
INSERT INTO bel_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","I назваў Абрагам сына свайго, які нарадзіўся яму, якога нарадзіла яму Сара, Ісаак. ");
INSERT INTO bel_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I абрэзаў Абрагам Ісаака, сына свайго, на восьмы дзень, як загадаў яму Бог. ");
INSERT INTO bel_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","І было Абрагаму сто гадоў, калі нарадзіўся ў яго Ісаак, сын ягоны. ");
INSERT INTO bel_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","I сказала Сара: «Сьмех учыніў з мяне Бог. Кожны, хто пачуе, будзе сьмяяцца з мяне». ");
INSERT INTO bel_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","I сказала: «Хто сказаў бы Абрагаму: “Сара будзе карміць грудзьмі сыноў”, бо я нарадзіла сына ў старасьці ягонай». ");
INSERT INTO bel_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","I вырасла дзіцятка, і было аднятае ад грудзей, і ўчыніў Абрагам вялікую гасьціну ў той дзень, калі Ісаак быў адняты ад грудзей. ");
INSERT INTO bel_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","I ўбачыла Сара сына Агар Эгіпцянкі, якога тая нарадзіла Абрагаму, што ён насьміхаецца, ");
INSERT INTO bel_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","і сказала Абрагаму: «Выгані гэтую нявольніцу і сына ейнага, бо ня будзе мець спадчыну сын нявольніцы гэтай з сынам маім Ісаакам». ");
INSERT INTO bel_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","I было гэта ліхім у вачах Абрагама адносна сына ягонага. ");
INSERT INTO bel_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","I сказаў Бог Абрагаму: «Няхай ня будзе гэта ліхім у вачах тваіх адносна хлопчыка і адносна нявольніцы тваёй. У-ва ўсім, што скажа табе Сара, слухай голасу ейнага, бо ў Ісааку будзе названа насеньне тваё. ");
INSERT INTO bel_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Таксама сына нявольніцы Я зраблю народам, бо ён — насеньне тваё». ");
INSERT INTO bel_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","І ўстаў Абрагам раніцаю, і ўзяў хлеб і мех вады, і даў Агар, і палажыў ёй на плечы, і выслаў яе разам з дзіцём. І яна пайшла, і блукала ў пустыні Бээр-Шэва. ");
INSERT INTO bel_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","I скончылася вада ў мяху, і яна пакінула дзіця пад адным з кустоў, ");
INSERT INTO bel_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","і пайшла, і села насупраць так далёка, як стрэліць з луку, бо яна сказала: «Няхай ня буду глядзець на сьмерць дзіцяці». I сядзела насупраць, і ўзьняла голас свой, і плакала. ");
INSERT INTO bel_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","I пачуў Бог голас хлопчыка. І паклікаў анёл Божы да Агар з неба, і сказаў ёй: «Што з табою, Агар? Ня бойся, бо пачуў Бог голас хлопчыка з месца, дзе Ён ёсьць. ");
INSERT INTO bel_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Устань, падымі хлопца і трымай яго моцна рукою сваёю, бо Я зраблю яго народам вялікім». ");
INSERT INTO bel_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","I адчыніў Бог вочы ейныя, і яна ўбачыла студню з вадою, і пайшла, і напоўніла мех вады, і дала піць хлопцу. ");
INSERT INTO bel_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","I быў Бог з хлопцам; і ён вырас, і жыў у пустыні, і быў стралец з луку. ");
INSERT INTO bel_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","І ён жыў у пустыні Паран; і ўзяла яму маці ягоная жонку з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","I сталася ў той час, і сказаў Абімэлех і Піколь, гетман ягоны, Абрагаму, кажучы: «Бог з табою ў-ва ўсім, што ты робіш. ");
INSERT INTO bel_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","I цяпер прысягні мне Богам тут, што ты ня здрадзіш ані мне, ані нашчадку майму, ані ўнуку майму, і як я чыніў міласэрнасьць табе, так ты будзеш рабіць са мною і з зямлёю, у якой ты жывеш». ");
INSERT INTO bel_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","I сказаў Абрагам: «Прысягаю». ");
INSERT INTO bel_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","I дакараў Абрагам Абімэлеха з прычыны студні вады, якую забралі слугі Абімэлеха. ");
INSERT INTO bel_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","I сказаў Абімэлех: «Я ня ведаю, хто ўчыніў гэтую рэч, і ты не расказваў мне, і я ня чуў нічога аж да сёньняшняга дня». ");
INSERT INTO bel_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","I ўзяў Абрагам авечак і валоў, і даў Абімэлеху, і заключылі яны абодва запавет. ");
INSERT INTO bel_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","I паставіў Абрагам сем ягнятаў з чарады асобна. ");
INSERT INTO bel_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","I сказаў Абімэлех Абрагаму: «Навошта гэтыя сем ягнятаў, якіх ты паставіў асобна?» ");
INSERT INTO bel_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","I сказаў Абрагам: «Бо сем гэтых ягнятаў возьмеш з рукі маёй, каб яны былі мне сьведчаньнем, што я выкапаў гэтую студню». ");
INSERT INTO bel_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Дзеля таго і названа гэтае месца Бээр-Шэва, бо там яны абодва прысягалі. ");
INSERT INTO bel_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","I заключылі запавет у Бээр-Шэве. I ўстаў Абімэлех і Піколь, гетман ягоны, і вярнуліся ў зямлю Філістынскую. ");
INSERT INTO bel_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","I пасадзіў Абрагам гай у Бээр-Шэве, і клікаў там імя ГОСПАДА, Бога вечнага. ");
INSERT INTO bel_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","I жыў Абрагам у зямлі Філістынскай шмат дзён. ");
INSERT INTO bel_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","I сталася пасьля гэтых падзеяў, і Бог выспрабоўваў Абрагама, і сказаў яму: «Абрагаме!» I ён сказаў: «Вось я!» ");
INSERT INTO bel_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I сказаў Бог: «Вазьмі сына твайго, адзінага твайго, якога ты любіш, Ісаака; і ідзі ў зямлю Морыя, і там складзі яго ў ахвяру цэласпаленьня на адной гары, пра якую Я скажу табе». ");
INSERT INTO bel_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","І ўстаў Абрагам рана раніцаю, і асядлаў асла свайго, узяў двух юнакоў сваіх з сабою і Ісаака, сына свайго, і насек дроваў на цэласпаленьне, і ўстаў, і пайшоў на месца, пра якое сказаў яму Бог. ");
INSERT INTO bel_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","На трэці дзень узьняў Абрагам вочы свае і ўбачыў тое месца здалёк. ");
INSERT INTO bel_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","I сказаў Абрагам юнакам сваім: «Застаньцеся тут з аслом, а мы з хлопцам пойдзем аж туды, і паклонімся, і вернемся да вас». ");
INSERT INTO bel_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","I ўзяў Абрагам дровы на цэласпаленьне, і ўзлажыў на Ісаака, сына свайго; і ўзяў у рукі агонь і вялікі нож, і пайшлі абодва разам. ");
INSERT INTO bel_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I сказаў Ісаак Абрагаму, бацьку свайму: «Ойча мой!» Той сказаў: «Вось я, сыне мой». Ён сказаў: «Вось агонь і дровы, а дзе ягня на цэласпаленьне?» ");
INSERT INTO bel_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","I сказаў Абрагам: «Бог угледзіць Сабе ягня на цэласпаленьне, сыне мой». I ішлі абодва разам. ");
INSERT INTO bel_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","I прыйшлі на месца, пра якое казаў яму Бог; і збудаваў там Абрагам ахвярнік, і разлажыў дровы, і зьвязаў Ісаака, сына свайго, і палажыў яго на ахвярнік зьверху на дровы. ");
INSERT INTO bel_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","I выцягнуў Абрагам руку сваю, і ўзяў вялікі нож, каб закалоць сына свайго. ");
INSERT INTO bel_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","I паклікаў яго анёл ГОСПАДА з неба, і сказаў: «Абрагаме! Абрагаме!» Той сказаў: «Вось я!» ");
INSERT INTO bel_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","I сказаў Госпад: «Не выцягвай рукі сваёй на хлопца і не рабі яму нічога, бо цяпер Я ведаю, што ты баішся Бога і не пашкадаваў дзеля Мяне сына твайго, адзінага твайго». ");
INSERT INTO bel_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","I ўзьняў Абрагам вочы свае, і ўбачыў, і вось, баран ззаду, увязаны ў хмызах рагамі сваімі. I пайшоў Абрагам, і ўзяў барана, і ахвяраваў яго на цэласпаленьне замест сына свайго. ");
INSERT INTO bel_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","I назваў Абрагам імя месца гэтага: «ГОСПАД угледзіць». Дзеля гэтага і цяпер кажуць: «На гары ГОСПАД дасьць угледзець». ");
INSERT INTO bel_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","I паклікаў анёл ГОСПАДА Абрагама другі раз з неба, ");
INSERT INTO bel_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","і сказаў: «На Сябе Самога прысягаю, кажа ГОСПАД, за тое, што ты гэта зрабіў, і не пашкадаваў сына твайго, адзінага твайго, ");
INSERT INTO bel_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","дабраслаўляючы, дабраслаўлю цябе і, памнажаючы, памножу насеньне тваё, як зоркі нябесныя і як пясок на беразе мора; і ўспадкаеміць насеньне тваё брамы ворагаў сваіх. ");
INSERT INTO bel_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I будуць дабраслаўлёныя ў насеньні тваім усе народы зямлі за тое, што ты паслухаў голасу Майго». ");
INSERT INTO bel_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","I вярнуўся Абрагам да юнакоў сваіх, і ўсталі, і пайшлі разам да Бээр-Шэвы. I жыў Абрагам у Бээр-Шэве. ");
INSERT INTO bel_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","I сталася пасьля гэтых падзеяў, паведамілі Абрагаму, кажучы: «Вось, нарадзіла таксама Мілька сыноў Нахору, брату твайму: ");
INSERT INTO bel_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уца, першароднага ягонага, і Буза, брата ягонага, і Кемуэля, бацьку Арама, ");
INSERT INTO bel_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","і Кесэда, і Хазо, і Пільдаша, і Ідлафа, і Бэтуэля». ");
INSERT INTO bel_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","А Бэтуэль нарадзіў Рэбэку. Васьмёх гэтых нарадзіла Мілька Нахору, брату Абрагама. ");
INSERT INTO bel_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","I наложніца ягоная, імя якой Рэўма, нарадзіла таксама Тэваха, і Гахама, і Тахаша, і Маху. ");
INSERT INTO bel_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","I было жыцьця Сары сто дваццаць сем гадоў, гэта гады жыцьця Сары. ");
INSERT INTO bel_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","I памерла Сара ў Кірыят-Арбе, гэта значыць, у Хеўроне, у зямлі Ханаан. I прыйшоў Абрагам, каб мець жалобу па Сары і плакаць па ёй. ");
INSERT INTO bel_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","I ўстаў Абрагам ад аблічча памёршай сваёй, і прамовіў да сыноў Хета, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Прыхадзень і пасяленец я ў вас. Дайце мне ў вас на ўласнасьць магілу, і я пахаваю ад аблічча майго памёршую маю». ");
INSERT INTO bel_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","I адказалі сыны Хета Абрагаму, кажучы яму: ");
INSERT INTO bel_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Паслухай нас, пане мой! Князь Божы ты сярод нас; у найлепшай з нашых магілаў пахавай памёршую сваю. Ніхто з нас не адмовіць табе магілы сваёй на пахаваньне памёршай тваёй». ");
INSERT INTO bel_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","І ўстаў Абрагам, і пакланіўся народу зямлі, сынам Хета, ");
INSERT INTO bel_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","і прамовіў да іх, кажучы: «Калі жадае душа вашая, каб я пахаваў ад аблічча майго памёршую маю, паслухайце мяне і папрасіце за мяне Эфрона, сына Цахара, ");
INSERT INTO bel_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","і ён дасьць мне пячору Махпэля, што ў яго, якая на канцы поля ягонага, за поўнае срэбра дасьць мне яе, каб меў я сярод вас магілу на ўласнасьць». ");
INSERT INTO bel_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","А Эфрон сядзеў сярод сыноў Хета. І адказаў Эфрон Хет Абрагаму ўслых усіх сыноў Хета, якія ўваходзілі ў брамы гораду ягонага, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Не, пане мой! Паслухай мяне: поле я даю табе, і пячору, якая на ім, я даю табе, перад вачыма сыноў народу майго даю табе яе, пахавай памёршую тваю». ");
INSERT INTO bel_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","I пакланіўся Абрагам перад народам зямлі, ");
INSERT INTO bel_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","і сказаў Эфрону ўслых народу зямлі, кажучы: «Калі б ты толькі паслухаў мяне, я даю табе срэбра за поле гэтае; вазьмі ў мяне, і я пахаваю там памёршую маю». ");
INSERT INTO bel_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","І адказаў Эфрон Абрагаму, кажучы яму: ");
INSERT INTO bel_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Пане мой, паслухай мяне! Зямля вартая чатырыста сыкляў срэбра. Што гэта для мяне і для цябе? І пахавай памёршую тваю». ");
INSERT INTO bel_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","I паслухаў Абрагам Эфрона; і адважыў Абрагам Эфрону срэбра, пра якое ён казаў услых сыноў Хета, чатырыста сыкляў срэбра, якое ўжывалася ў купцоў. ");
INSERT INTO bel_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","I атрымаў поле Эфрона, якое ў Махпэлі, што насупраць Мамрэ, поле тое і пячору, якая на ім, і ўсе дрэвы, якія на полі, у-ва ўсіх межах ягоных наўкола. ");
INSERT INTO bel_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Абрагам купіў яго перад вачыма сыноў Хета, усіх, якія ўваходзілі ў брамы гораду ягонага. ");
INSERT INTO bel_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","І пасьля гэтага Абрагам пахаваў Сару, жонку сваю, у пячоры на полі ў Махпэлі, насупраць Мамрэ, якое завецца Хеўрон, у зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","I атрымаў Абрагам тое поле і тую пячору, якая на ім, як магілу на ўласнасьць ад сыноў Хета. ");
INSERT INTO bel_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","I Абрагам быў стары, і меў шмат дзён, і ГОСПАД дабраславіў Абрагама ў-ва ўсім. ");
INSERT INTO bel_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","I сказаў Абрагам слузе свайму, старэйшаму ў доме сваім, які меў уладу над усім, што ў яго было: «Палажы руку сваю пад сьцягно маё, ");
INSERT INTO bel_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","і я прывяду цябе да прысягі на ГОСПАДА, Бога неба і Бога зямлі, што ты ня возьмеш жонкі сыну майму з дачок Хананейскіх, сярод якіх я жыву, ");
INSERT INTO bel_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","але пойдзеш у зямлю маю і да родзічаў маіх, і возьмеш жонку сыну майму Ісааку». ");
INSERT INTO bel_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","I сказаў яму слуга: «Можа, не пажадае тая жанчына ісьці са мною сюды, у гэтую зямлю. Ці маю я завесьці сына твайго адсюль у тую зямлю, з якой ты выйшаў?» ");
INSERT INTO bel_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","I сказаў яму Абрагам: «Сьцеражыся, каб не завесьці туды сына майго. ");
INSERT INTO bel_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ГОСПАД, Бог неба, Які ўзяў мяне з дому бацькі майго і з зямлі нараджэньня майго, і Які казаў да мяне, і Які прысягнуў мне, кажучы: “Насеньню твайму Я дам гэтую зямлю”, — Ён пашле анёла Свайго перад абліччам тваім, і ты возьмеш адтуль жонку сыну майму. ");
INSERT INTO bel_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","А калі не пажадае тая жанчына ісьці з табою, ты будзеш вызвалены ад гэтае прысягі маёй; толькі сына майго не завядзі туды». ");
INSERT INTO bel_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","I палажыў слуга руку сваю пад сьцягно Абрагама, пана свайго, і прысягнуў яму ў гэтай справе. ");
INSERT INTO bel_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","I ўзяў той слуга дзесяць вярблюдаў пана свайго, і пайшоў, і ўсялякае даброцьце пана ягонага было ў руцэ ягонай. І ўстаў ён, і пайшоў у Арам-Нагараім, у горад Нахора. ");
INSERT INTO bel_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","I дазволіў ён вярблюдам укленчыць вонкі гораду каля студні вады пад вечар, у той час, калі выходзяць чэрпаць ваду. ");
INSERT INTO bel_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","I сказаў ён: «ГОСПАДЗЕ, Божа пана майго Абрагама! Зрабі, каб сталася ласка мне сёньня, і ўчыні міласэрнасьць пану майму Абрагаму. ");
INSERT INTO bel_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Вось, я стаю каля крыніцы вады, і дочкі жыхароў гораду выходзяць чэрпаць ваду. ");
INSERT INTO bel_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Няхай станецца, што тая дзяўчына, якой я скажу: “Нахілі збан свой, і я нап’юся”, і якая скажа: “Пі, я і вярблюдаў тваіх напаю”, вось гэта тая, якую Ты прызначыў слузе Твайму Ісааку, і з гэтага пазнаю, што Ты ўчыніў міласэрнасьць пану майму». ");
INSERT INTO bel_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I сталася, перш, чым скончыў ён казаць, вось, выйшла Рэбэка, якая нарадзілася ў Бэтуэля, сына Мількі, жонкі Нахора, брата Абрагама, і збан ейны на плячы ў яе. ");
INSERT INTO bel_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","І была тая дзяўчына вельмі прыгожая з выгляду, дзяўчына, якую мужчына не пазнаў. І зыйшла яна да крыніцы, і напоўніла збан, і вярталася. ");
INSERT INTO bel_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","I пабег слуга насустрач ёй, і сказаў: «Дай мне глытнуць крыху вады са збана твайго». ");
INSERT INTO bel_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","I сказала яна: «Пі, пане мой». I пасьпяшалася, і спусьціла збан на руку сваю, і дала яму напіцца. ");
INSERT INTO bel_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","I скончыла яна даваць яму піць, і сказала: «Таксама для вярблюдаў тваіх я буду чэрпаць, пакуль не нап’юцца». ");
INSERT INTO bel_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","I пасьпяшалася, і выліла збан свой у карыта, і пабегла зноў да студні чэрпаць, і чэрпала для ўсіх вярблюдаў ягоных. ");
INSERT INTO bel_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","І чалавек той моўчкі ўглядаўся на яе, каб спазнаць, ці даў ГОСПАД посьпех на шляху ягоным, ці не. ");
INSERT INTO bel_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","I сталася, як вярблюды напіліся, узяў чалавек той залатое колца ў паўсыкля вагою і два бранзалеты на рукі ейныя, вага якіх дзесяць сыкляў золата, ");
INSERT INTO bel_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","і сказаў: «Чыя ты дачка? Скажы мне. Ці ёсьць у доме бацькі твайго месца для нас, каб начаваць?» ");
INSERT INTO bel_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","І яна сказала яму: «Я — дачка Бэтуэля, сына Мількі, якога яна нарадзіла Нахору». ");
INSERT INTO bel_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","I сказала яму: «Таксама саломы і корму шмат у нас, а таксама месца, каб начаваць». ");
INSERT INTO bel_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","I схіліўся чалавек той, і пакланіўся ГОСПАДУ, ");
INSERT INTO bel_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","і сказаў: «Дабраслаўлёны ГОСПАД, Бог пана майго Абрагама, Які не ўхіліў міласэрнасьці Сваёй і вернасьці Сваёй ад пана майго! Я — на шляху, якім прывёў мяне ГОСПАД да дому брата пана майго». ");
INSERT INTO bel_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","I пабегла дзяўчына, і расказала дома маці сваёй пра тое, што здарылася. ");
INSERT INTO bel_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","А ў Рэбэкі быў брат, імя ягонае — Ляван. I пабег Ляван вонкі да таго чалавека да крыніцы. ");
INSERT INTO bel_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","I сталася, калі ўбачыў ён колца і бранзалеты на руках у сястры сваёй і пачуў словы Рэбэкі, сястры сваёй, якая сказала: «Гэтак гаварыў са мною чалавек той», дык прыйшоў да чалавека таго, і вось, ён стаіць пры вярблюдах каля крыніцы. ");
INSERT INTO bel_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I сказаў Ляван: «Увайдзі, дабраслаўлёны ГОСПАДАМ. Чаму ты стаіш на двары? Я падрыхтаваў дом і месца для вярблюдаў». ");
INSERT INTO bel_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","I ўвайшоў чалавек той у дом. I Ляван расьсядлаў вярблюдаў, і даў саломы і корму для вярблюдаў, і вады, каб памыць ногі ягоныя і ногі людзей, якія з ім. ");
INSERT INTO bel_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","I паставілі перад ім есьці; а ён сказаў: «Ня буду есьці, пакуль не скажу словы свае». I сказаў Ляван: «Кажы!» ");
INSERT INTO bel_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","І ён сказаў: «Я — слуга Абрагама. ");
INSERT INTO bel_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","I ГОСПАД вельмі дабраславіў пана майго, і ён стаў вялікі. І Ён даў яму авечак і валоў, і срэбра, і золата, і слугаў, і нявольніцаў, і вярблюдаў, і аслоў. ");
INSERT INTO bel_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","I нарадзіла Сара, жонка пана майго, сына пану майму пасьля, у старасьці сваёй, і ён аддаў яму ўсё, што ў яго. ");
INSERT INTO bel_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","I ўзяў з мяне прысягу пан мой, кажучы: “Не бяры жонкі сыну майму з дачок Хананейскіх, сярод якіх я жыву, у зямлі іхняй, ");
INSERT INTO bel_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","але пойдзеш у дом бацькі майго і да сям’і маёй, і возьмеш жонку сыну майму”. ");
INSERT INTO bel_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I сказаў я пану майму: “Можа, ня пойдзе жанчына тая са мною”. ");
INSERT INTO bel_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","I сказаў ён мне: “ГОСПАД, перад абліччам Якога я хадзіў, пашле анёла Свайго з табою і дасьць посьпех на шляху тваім, і ты возьмеш жонку сыну майму з сям’і маёй і з дому бацькі майго. ");
INSERT INTO bel_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Тады будзеш ты вызвалены ад прысягі маёй, калі прыйдзеш да сям’і маёй, і калі яны не дадуць табе, ты будзеш вызвалены ад прысягі!” ");
INSERT INTO bel_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","І прыйшоў я сёньня да крыніцы, і сказаў: “ГОСПАДЗЕ, Божа пана майго Абрагама! Калі ёсьць воля Твая, дай посьпех на шляху маім, па якім іду. ");
INSERT INTO bel_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Вось, я стаю каля крыніцы вады, і няхай будзе, што тая дзяўчына, якая выйдзе чэрпаць, і я скажу ёй: \"Дай мне напіцца крыху вады са збана твайго\", ");
INSERT INTO bel_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","а яна скажа мне: \"І ты пі, і я таксама для вярблюдаў начэрпаю\", яна будзе тою жанчынаю, якую прызначыў ГОСПАД сыну пана майго”. ");
INSERT INTO bel_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Перш чым скончыў я гаварыць у сэрцы сваім, вось, Рэбэка выйшла, і збан ейны на плячы ў яе. І зыйшла яна да крыніцы, і начэрпала; і я сказаў ёй: “Дай мне напіцца!” ");
INSERT INTO bel_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","І яна пасьпяшалася, і спусьціла збан з сябе, і сказала: “Пі, і таксама вярблюдаў тваіх я напаю”. I я піў, і вярблюдаў яна напаіла. ");
INSERT INTO bel_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","І я запытаўся ў яе і сказаў: “Чыя ты дачка?” Яна сказала: “Дачка Бэтуэля, сына Нахора, якога нарадзіла яму Мілька”. I надзеў я колца ў нос ейны, і бранзалеты на рукі ейныя. ");
INSERT INTO bel_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","I я схіліўся, і пакланіўся ГОСПАДУ, і дабраславіў ГОСПАДА, Бога пана майго Абрагама, Які прывёў мяне шляхам праўды, каб узяў я дачку брата пана майго для сына ягонага. ");
INSERT INTO bel_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","I калі вы жадаеце ўчыніць міласэрнасьць і вернасьць пану майму, скажыце мне, а калі не, скажыце мне, і я павярну направа альбо налева». ");
INSERT INTO bel_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","I адказалі Ляван і Бэтуэль, і сказалі: «Ад ГОСПАДА выйшла слова гэтае, мы ня можам казаць табе ані ліхога, ані добрага. ");
INSERT INTO bel_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Вось, Рэбэка перад абліччам тваім, вазьмі і пайдзі, і няхай будзе яна жонкаю сыну пана твайго, як казаў ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","I сталася, калі пачуў слуга Абрагама словы іхныя, пакланіўся да зямлі ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","I выняў слуга рэчы срэбныя, і рэчы залатыя, і шаты, і даў Рэбэцы; і каштоўныя рэчы даў брату ейнаму і маці ейнай. ");
INSERT INTO bel_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","I елі, і пілі ён і людзі, якія з ім, і пераначавалі. I ўсталі раніцаю, і ён сказаў: «Адпусьціце мяне да пана майго». ");
INSERT INTO bel_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","I сказаў брат ейны і маці ейная: «Няхай застанецца з намі дзяўчына на дзён дзесяць, потым пойдзе». ");
INSERT INTO bel_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","І ён сказаў ім: «Не затрымлівайце мяне. ГОСПАД даў посьпех на шляху маім, адпусьціце мяне, і я пайду да пана майго». ");
INSERT INTO bel_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","I яны сказалі: «Паклічам дзяўчыну і спытаемся ў яе». ");
INSERT INTO bel_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","I паклікалі Рэбэку, і сказалі ёй: «Ці пойдзеш з гэтым чалавекам?» Яна сказала: «Пайду!» ");
INSERT INTO bel_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I адпусьцілі Рэбэку, сястру сваю, і няньку ейную, і слугу Абрагама, і людзей ягоных. ");
INSERT INTO bel_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I дабраславілі Рэбэку, і сказалі ёй: «Сястра наша, ты станься тысячай тысячаў, і няхай насеньне тваё ўспадкаеміць брамы ворагаў сваіх!» ");
INSERT INTO bel_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","I ўстала Рэбэка і служкі ейныя, і селі на вярблюдаў, і пайшлі за тым чалавекам. I ўзяў слуга Рэбэку, і пайшоў. ");
INSERT INTO bel_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","І прыйшоў Ісаак з дарогі ад Бээр-Ляхай-Рой, а ён жыў у зямлі Нэгеў. ");
INSERT INTO bel_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","I выйшаў Ісаак падумаць у поле пад вечар, і ўзьняў вочы свае, і ўбачыў, і вось, вярблюды прыходзяць. ");
INSERT INTO bel_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","I ўзьняла Рэбэка вочы свае, і ўбачыла Ісаака, і сьсела з вярблюда. ");
INSERT INTO bel_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","I сказала слузе: «Хто гэты чалавек, які ідзе па полі насустрач нам?» I сказаў слуга: «Гэта пан мой». I яна ўзяла вэлюм, і засланілася. ");
INSERT INTO bel_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","I распавёў слуга Ісааку ўсе справы, якія ён зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I ўвёў яе Ісаак у намёт Сары, маці сваёй, і ўзяў Рэбэку, і яна стала яму жонкаю, і ён кахаў яе. І суцешыўся Ісаак па маці сваёй. ");
INSERT INTO bel_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","I зноў узяў Абрагам жонку, а імя ейнае — Кетура. ");
INSERT INTO bel_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","I нарадзіла яна яму Зімрана, і Ёкшана, і Мэдана, і Мадыяна, і Ішбака, і Шуаха. ");
INSERT INTO bel_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","А Ёкшан нарадзіў Шэву і Дэдана. Сынамі Дэдана былі Ашурым, і Летушым, і Леўмім. ");
INSERT INTO bel_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","А сынамі Мадыяна — Эфа, і Эфэр, і Ханох, і Авіда, і Эльдаа. Усе яны — сыны Кетуры. ");
INSERT INTO bel_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","I аддаў Абрагам усё, што было ў яго, Ісааку. ");
INSERT INTO bel_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","А сынам наложніцаў, якія былі ў Абрагама, даў Абрагам дары, і адаслаў іх ад Ісаака, сына свайго, яшчэ за жыцьця свайго, на ўсход, у зямлю ўсходнюю. ");
INSERT INTO bel_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","I вось дні гадоў жыцьця Абрагама, якія ён пражыў — сто семдзясят пяць гадоў. ");
INSERT INTO bel_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","I супачыў, і памёр Абрагам у старасьці добрай, стары і насычаны жыцьцём, і быў далучаны да народу свайго. ");
INSERT INTO bel_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","I пахавалі яго Ісаак і Ізмаэль, сыны ягоныя, у пячоры Махпэля, што насупраць Мамрэ, на полі Эфрона Хета, сына Цахара. ");
INSERT INTO bel_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Гэта тое поле, якое купіў Абрагам у сыноў Хета. Там пахаваныя Абрагам і Сара, жонка ягоная. ");
INSERT INTO bel_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","I сталася пасьля сьмерці Абрагама, дабраславіў Бог Ісаака, сына ягонага, і жыў Ісаак каля Бэер-Ляхай-Рой. ");
INSERT INTO bel_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Вось радавод Ізмаэля, сына Абрагама, якога нарадзіла Абрагаму Агар Эгіпцянка, нявольніца Сары. ");
INSERT INTO bel_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","I вось імёны сыноў Ізмаэля, паводле імёнаў іхніх, паводле родаў іхніх: першародны Ізмаэля Наваёт, Кедар, Адбээль, Міўсам, ");
INSERT INTO bel_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мішма, Дума, Маса, ");
INSERT INTO bel_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Тэма, Етур, Нафіш і Кедма. ");
INSERT INTO bel_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Гэта сыны Ізмаэля, і гэта імёны іхнія ў паселішчах іхніх і ў табарах іхніх, дванаццаць князёў плямёнаў сваіх. ");
INSERT INTO bel_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","А гадоў жыцьця Ізмаэля — сто трыццаць сем гадоў. І ён супачыў, і памёр, і быў далучаны да народу свайго. ");
INSERT INTO bel_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","І жылі яны ад Хавілі да Шура, які насупраць Эгіпту, калі ідзеш у Асірыю. Перад абліччам усіх братоў сваіх пасяліўся ён. ");
INSERT INTO bel_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","А гэта радавод Ісаака, сына Абрагама. Абрагам нарадзіў Ісаака. ");
INSERT INTO bel_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","I было Ісааку сорак гадоў, калі ён узяў Рэбэку, дачку Бэтуэля Арамейца з Падан-Араму, сястру Лявана Арамейца, сабе за жонку. ");
INSERT INTO bel_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I прасіў Ісаак ГОСПАДА пра жонку сваю, бо яна была бясплодная; і ГОСПАД быў упрошаны ім, і зачала Рэбэка, жонка ягоная. ");
INSERT INTO bel_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","I штурхаліся сыны ў нутры ейным, і яна сказала: «Калі так, дык чаму ў мяне?» I пайшла спытацца ў ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I сказаў ГОСПАД ёй: «Два народы ў жываце тваім, і два народы выйдуць з нутра твайго; і адзін народ будзе мацнейшым за другі, і старэйшы будзе служыць малодшаму». ");
INSERT INTO bel_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","I споўніліся дні ейныя, каб нарадзіць, і вось, двайняты ў жываце ейным. ");
INSERT INTO bel_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I выйшаў першы, чырвоны, увесь, як кажух, касматы; і назвалі імя ягонае Эзаў. ");
INSERT INTO bel_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Потым выйшаў брат ягоны, і рука ягоная трымала пяту Эзава, і назвалі імя ягонае Якуб. А Ісааку было шэсьцьдзясят гадоў, калі яны нарадзіліся. ");
INSERT INTO bel_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","I вырасьлі хлопчыкі, і быў Эзаў спрытным паляўнічым, чалавекам поля, а Якуб быў чалавекам рахманым, які жыў у намётах. ");
INSERT INTO bel_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I любіў Ісаак Эзава, бо ўпаляванае ім было ў вуснах ягоных; а Рэбэка любіла Якуба. ");
INSERT INTO bel_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","I варыў Якуб страву, і Эзаў прыйшоў з поля, і быў ён стомлены. ");
INSERT INTO bel_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","I сказаў Эзаў Якубу: «Дай мне крыху чырвонай, гэтай чырвонай стравы, бо я стомлены». Дзеля гэтага названае імя ягонае Эдом. ");
INSERT INTO bel_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","I сказаў Якуб: «Прадай мне сёньня першародзтва тваё». ");
INSERT INTO bel_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","I сказаў Эзаў: «Вось, я ледзь не паміраю, і на што мне гэта першародзтва?» ");
INSERT INTO bel_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","I сказаў Якуб: «Прысягні мне сёньня». І той прысягнуў яму, і прадаў першародзтва сваё Якубу. ");
INSERT INTO bel_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","I Якуб даў Эзаву хлеб і страву з сачэвіцы, і ён еў, і піў, і ўстаў, і пайшоў; і пагрэбаваў Эзаў першародзтвам. ");
INSERT INTO bel_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","I быў голад у зямлі той, ня лічачы першага голаду, які быў у дні Абрагама. І пайшоў Ісаак да Абімэлеха, валадара Філістынскага, у Герар. ");
INSERT INTO bel_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","I зьявіўся яму ГОСПАД, і сказаў: «Не зыходзь у Эгіпет; жыві ў зямлі, пра якую скажу табе. ");
INSERT INTO bel_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Жыві ў зямлі гэтай; і Я буду з табою, і дабраслаўлю цябе, бо табе і насеньню твайму Я дам усе краіны гэтыя, і споўню прысягу, якой Я прысягаў Абрагаму, бацьку твайму. ");
INSERT INTO bel_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I памножу насеньне тваё, як зоркі ў небе, і дам насеньню твайму ўсе краіны гэтыя; і дабраславяцца ў насеньні тваім усе народы зямлі, ");
INSERT INTO bel_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","таму што Абрагам паслухаў голасу Майго і захоўваў загады Мае, прыказаньні Мае, пастановы Мае і законы Мае». ");
INSERT INTO bel_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","I пасяліўся Ісаак у Герары. ");
INSERT INTO bel_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","I пыталіся людзі месца таго пра жонку ягоную, і ён сказаў: «Яна — сястра мая», бо баяўся сказаць: «Жонка мая», каб не забілі яго людзі месца таго за Рэбэку, бо яна была прыгожая з выгляду. ");
INSERT INTO bel_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I сталася, калі доўгія былі там дні ягоныя, глянуў Абімэлех, валадар Філістынскі, праз вакно, і ўбачыў, а вось, Ісаак гуляе з Рэбэкаю, жонкаю сваёю. ");
INSERT INTO bel_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","I паклікаў Абімэлех Ісаака, і сказаў: «Дык яна — жонка твая! А чаму ж ты казаў: “Яна — сястра мая”?» I сказаў яму Ісаак: «Бо я сказаў: “Каб я не памёр праз яе”». ");
INSERT INTO bel_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","I сказаў Абімэлех: «Што гэта ты нарабіў нам? Яшчэ б трохі, і мог бы легчы нехта з народу з жонкаю тваёю, і ты прывёў бы на нас віну». ");
INSERT INTO bel_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","I загадаў Абімэлех усяму народу, кажучы: «Хто дакранецца да гэтага чалавека і да жонкі ягонай, той сьмерцю памрэ». ");
INSERT INTO bel_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","I сеяў Ісаак у зямлі той, і сабраў у той год стакротны ўраджай, і дабраславіў яго ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I ставаўся вялікім муж гэты, і ішоў угору, і павялічыўся так, што стаў вельмі вялікі. ");
INSERT INTO bel_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","I былі ў яго статкі авечак, і статкі валоў, і мноства слугаў, і зайздросьцілі яму Філістынцы. ");
INSERT INTO bel_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","I ўсе студні, якія выкапалі слугі бацькі ягонага ў дні Абрагама, бацькі ягонага, засыпалі Філістынцы і запоўнілі пяском. ");
INSERT INTO bel_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","I сказаў Абімэлех Ісааку: «Адыйдзі ад нас, бо ты стаўся шмат дужэйшы за нас». ");
INSERT INTO bel_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","I адыйшоў адтуль Ісаак, і паставіў намёты каля ручая Герарскага, і жыў там. ");
INSERT INTO bel_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","I вярнуўся Ісаак, і адкапаў студні вады, якія былі выкапаныя ў дні Абрагама, бацькі ягонага, і якія засыпалі Філістынцы пасьля сьмерці Абрагама, і назваў іх тымі самымі назвамі, якімі назваў іх бацька ягоны. ");
INSERT INTO bel_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","I капалі слугі Ісаака каля ручая, і знайшлі там студню вады жывой. ");
INSERT INTO bel_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","I спрачаліся пастухі Герарскія з пастухамі Ісаака, кажучы: «Гэта наша вада», і ён назваў імя студні Эсэк, бо вадзіліся з ім. ");
INSERT INTO bel_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","I выкапалі другую студню; і спрачаліся таксама за яе; і ён назваў яе імя Сітна. ");
INSERT INTO bel_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I выбраўся адтуль, і выкапаў іншую студню, і не спрачаліся за яе; і назваў яе імя Рэхавот, і сказаў: «Бо цяпер пашырыў нас ГОСПАД, і мы будзем памнажацца ў гэтай зямлі». ");
INSERT INTO bel_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Адтуль узыйшоў ён у Бээр-Шэву. ");
INSERT INTO bel_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","I зьявіўся яму ГОСПАД у тую ноч, і сказаў: «Я — Бог Абрагама, бацькі твайго. Ня бойся, бо Я з табою; і дабраслаўлю цябе, і памножу насеньне тваё дзеля Абрагама, слугі Майго». ");
INSERT INTO bel_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I ён збудаваў там ахвярнік, і клікаў імя ГОСПАДА. I паставіў там намёт свой, і выкапалі там слугі Ісаака студню. ");
INSERT INTO bel_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","I Абімэлех прыйшоў да яго з Герару, і Ахузат, сябра ягоны, і Піколь, гетман ягоны. ");
INSERT INTO bel_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I сказаў ім Ісаак: «Чаму вы прыйшлі да мяне? Вы ж зьненавідзелі мяне і выслалі мяне ад сябе». ");
INSERT INTO bel_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","I яны сказалі: «Мы, гледзячы, убачылі, што ГОСПАД з табою, і мы сказалі: “Няхай будзе прысяга паміж намі, паміж намі і табою, і мы заключым запавет з табою, ");
INSERT INTO bel_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","і ты ня будзеш рабіць нам ліха, як і мы не дакрануліся цябе, і як мы рабілі табе адно дабро і адпусьцілі цябе ў супакоі, і ты цяпер дабраслаўлёны ГОСПАДАМ”». ");
INSERT INTO bel_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","І ён зрабіў для іх гасьціну, і яны елі і пілі. ");
INSERT INTO bel_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","I ўсталі раніцаю, і прысягнулі адзін аднаму; і адпусьціў іх Ісаак, і яны пайшлі ад яго ў супакоі. ");
INSERT INTO bel_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","I сталася ў той дзень, прыйшлі слугі Ісаака, і паведамілі яму пра студню, якую яны выкапалі, і сказалі яму: «Мы знайшлі ваду!» ");
INSERT INTO bel_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I ён назваў яе Шыва. Дзеля гэтага імя гораду таго Бээр-Шэва аж да сёньняшняга дня. ");
INSERT INTO bel_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","I сталася, што меў Эзаў сорак гадоў, і ўзяў сабе за жонку Юдыту, дачку Бээры Хета, і Басэмат, дачку Элёна Хета, ");
INSERT INTO bel_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","і былі яны горыччу для духа Ісаака і Рэбэкі. ");
INSERT INTO bel_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","I сталася, што Ісаак састарэў, і зацемрыліся вочы ягоныя, так што ня мог бачыць, і паклікаў ён Эзава, сына свайго старэйшага, і сказаў яму: «Сыне мой». І той сказаў яму: «Вось я». ");
INSERT INTO bel_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I ён сказаў: «Вось, я састарэў, ня ведаю дня сьмерці маёй. ");
INSERT INTO bel_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","I цяпер вазьмі прылады твае, сагайдак твой і лук твой, і пайдзі ў поле, і ўпалюй мне дзічыны, ");
INSERT INTO bel_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","і зрабі мне прысмакі, якія я люблю, і прынясі мне, і я паем, каб дабраславіла цябе душа мая раней, чым я памру». ");
INSERT INTO bel_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","А Рэбэка чула, як Ісаак казаў Эзаву, сыну свайму. I пайшоў Эзаў у поле, каб упаляваць дзічыны і прынесьці яе. ");
INSERT INTO bel_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","І сказала Рэбэка Якубу, сыну свайму, кажучы: «Вось, я чула бацьку твайго, як ён казаў брату твайму Эзаву, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Прынясі мне дзічыны і зрабі мне прысмакі, і я буду есьці, і дабраслаўлю цябе перад абліччам ГОСПАДА, перад сьмерцю сваёй”. ");
INSERT INTO bel_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","I цяпер, сыне мой, паслухай голасу майго ў тым, што я загадваю табе. ");
INSERT INTO bel_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Пайдзі да авечак і вазьмі мне адтуль двух казьлянят добрых; і я прыгатую з іх прысмакі для бацькі твайго, якія ён любіць. ");
INSERT INTO bel_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","I ты прынясеш іх бацьку твайму, і ён зьесьць, каб ён дабраславіў цябе перад сьмерцю сваёю». ");
INSERT INTO bel_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","I сказаў Якуб Рэбэцы, маці сваёй: «Вось жа Эзаў, брат мой, чалавек касматы, а я — чалавек гладкі. ");
INSERT INTO bel_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Можа, памацае мяне бацька мой, і я буду ў вачах ягоных як той, які ашуквае яго, і навяду на сябе праклён, а не дабраславеньне». ");
INSERT INTO bel_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","I сказала яму маці ягоная: «На мне будзе праклён твой, сыне мой, толькі паслухай голасу майго і ідзі, і вазьмі для мяне казьлянят». ");
INSERT INTO bel_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","І ён пайшоў, і ўзяў, і прынёс маці сваёй, і зрабіла маці ягоная прысмакі, якія любіў бацька ягоны. ");
INSERT INTO bel_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","I ўзяла Рэбэка адзежу Эзава, сына свайго старэйшага, найкаштоўнейшую, што была ў яе дома, і апранула Якуба, сына свайго малодшага, ");
INSERT INTO bel_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","і скуркамі казьлянят абкруціла рукі ягоныя і гладкую шыю ягоную, ");
INSERT INTO bel_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","і дала прысмакі і хлеб, які яна зрабіла, у рукі Якуба, сына свайго. ");
INSERT INTO bel_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","I ўвайшоў ён да бацькі свайго, і сказаў: «Ойча мой!» I сказаў ён: «Вось я. Хто ты, сыне мой?» ");
INSERT INTO bel_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","I сказаў Якуб бацьку свайму: «Я — Эзаў, першародны твой. Я зрабіў, як ты сказаў мне. Устань, сядзь і еш дзічыну маю, каб дабраславіла мяне душа твая». ");
INSERT INTO bel_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","I сказаў Ісаак сыну свайму: «Як гэта так хутка ты знайшоў яе, сыне мой». А той сказаў: «Бо справіў гэта ГОСПАД, Бог твой, перад абліччам маім». ");
INSERT INTO bel_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","I сказаў Ісаак Якубу: «Наблізься, я памацаю цябе, сыне мой, ці ты — сын мой Эзаў, ці не». ");
INSERT INTO bel_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","I наблізіўся Якуб да Ісаака, бацькі свайго, і ён памацаў яго, і сказаў: «Голас — голас Якуба, але рукі — рукі Эзава». ");
INSERT INTO bel_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","І не пазнаў яго, бо рукі ягоныя былі як рукі брата ягонага, касматыя, і дабраславіў яго. ");
INSERT INTO bel_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","I сказаў: «Ці ты — сын мой Эзаў?» І ён сказаў: «Я». ");
INSERT INTO bel_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I сказаў: «Дай мне, і я буду есьці дзічыну, сыне мой, каб дабраславіла цябе душа мая». I ён даў яму, і ён еў; і прынёс яму віна, і ён піў. ");
INSERT INTO bel_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","I сказаў яму Ісаак, бацька ягоны: «Наблізься і пацалуй мяне, сыне мой». ");
INSERT INTO bel_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","I ён наблізіўся, і пацалаваў яго. I адчуў ён пах адзежы ягонай, і дабраславіў яго, і сказаў: «Вось, пах сына майго, як пах поля, якое дабраславіў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","I няхай дасьць табе Бог расу з неба і тлустасьць з зямлі, і мноства збожжа і віна. ");
INSERT INTO bel_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Няхай служаць табе народы, і няхай кланяюцца табе плямёны. Будзь гаспадаром над братамі тваімі, і няхай кланяюцца табе сыны маці тваёй. Хто праклінае цябе, будзе пракляты, а хто дабраслаўляе цябе, будзе дабраслаўлёны». ");
INSERT INTO bel_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","I сталася, калі скончыў Ісаак дабраслаўляць Якуба, і вось, адыходзячы, адыйшоў Якуб ад аблічча Ісаака, бацькі свайго, Эзаў, брат ягоны, прыйшоў з паляваньня свайго. ");
INSERT INTO bel_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","I зрабіў ён таксама прысмакі, і прынёс бацьку свайму, і сказаў бацьку свайму: «Устань, ойча мой, і зьеш дзічыну сына свайго, каб дабраславіла мяне душа твая». ");
INSERT INTO bel_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","I сказаў яму Ісаак, бацька ягоны: «Хто ты?» І ён сказаў: «Я — сын твой першародны Эзаў». ");
INSERT INTO bel_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","I задрыжэў Ісаак дрыжэньнем вельмі вялікім, і сказаў: «Хто ж быў той, які ўпаляваў дзічыну і прынёс мне, і я еў усё перш, чым ты прыйшоў, і я дабраславіў яго? Ён будзе дабраслаўлёны». ");
INSERT INTO bel_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Калі пачуў Эзаў словы бацькі свайго, закрычаў крыкам вялікім і надта горкім, і сказаў бацьку свайму: «Дабраславі мяне, таксама і мяне, ойча мой!» ");
INSERT INTO bel_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","I сказаў той: «Брат твой прыйшоў падступна і ўзяў дабраславеньне тваё». ");
INSERT INTO bel_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","I сказаў ён: «Ці не таму названае імя ягонае Якуб, і вось, ашукаў мяне ўжо двойчы! Ён забраў першародзтва маё, і вось цяпер забраў дабраславеньне маё». I сказаў: «Няўжо ты не захаваў для мяне дабраславеньня?» ");
INSERT INTO bel_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","I адказаў Ісаак, і сказаў Эзаву: «Вось, я паставіў яго гаспадаром над табою, і ўсіх братоў ягоных аддаў яму за слугаў, і збожжам і віном абдарыў яго. А табе што я зраблю, сыне мой?» ");
INSERT INTO bel_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I сказаў Эзаў бацьку свайму: «Ці толькі адно дабраславеньне ў цябе, ойча мой? Дабраславі мяне, таксама мяне, ойча мой!» I ўзвысіў Эзаў голас свой, і заплакаў. ");
INSERT INTO bel_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","I адказаў Ісаак, бацька ягоны, і сказаў яму: «Вось, далёка ад тлустасьці зямлі будзе месца жыцьця твайго і далёка ад расы з неба ўгары, ");
INSERT INTO bel_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","і з мяча свайго будзеш жыць, і брату свайму будзеш служыць. І станецца, што ты запануеш, і скінеш ярмо ягонае з шыі сваёй». ");
INSERT INTO bel_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","I зьненавідзеў Эзаў Якуба дзеля дабраславеньня, якім дабраславіў яго бацька ягоны, і сказаў Эзаў у сэрцы сваім: «Набліжаюцца дні жалобы па бацьку маім, і я заб’ю Якуба, брата майго». ");
INSERT INTO bel_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I распавялі Рэбэцы словы Эзава, сына ейнага старэйшага, і яна паслала, і паклікала Якуба, сына свайго малодшага, і сказала яму: «Вось, Эзаў, брат твой, суцяшае сябе адносна цябе, што заб’е цябе. ");
INSERT INTO bel_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","I цяпер, сыне мой, паслухай голасу майго, і ўстань, уцякай да Лявана, брата майго, у Харан, ");
INSERT INTO bel_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","і пажыві з ім нейкі час, пакуль адыйдзе гнеў ад брата твайго. ");
INSERT INTO bel_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Калі адыйдзе гнеў на цябе ад брата твайго, і ён забудзецца, што ты ўчыніў яму, я пашлю і вазьму цябе адтуль. Дзеля чаго маю страціць абодвух сыноў у адзін дзень?» ");
INSERT INTO bel_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","I сказала Рэбэка Ісааку: «Абрыдла мне жыцьцё маё з прычыны дачок Хета. Калі возьме Якуб жонку з дачок Хета, якія з дочак зямлі гэтай, дык навошта мне жыцьцё?» ");
INSERT INTO bel_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","I паклікаў Ісаак Якуба, і дабраславіў яго, і загадаў яму, і сказаў яму: «Не бяры сабе жонкі з дачок Ханаану. ");
INSERT INTO bel_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Устань, ідзі ў Падан-Арам, у дом Бэтуэля, бацькі маці тваёй, і вазьмі сабе адтуль жонку з дачок Лявана, брата маці тваёй. ");
INSERT INTO bel_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","І Бог Усемагутны дабраславіць цябе, і зробіць цябе плодным, і памножыць цябе, і ты станешся супольнасьцю народаў, ");
INSERT INTO bel_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","і Ён дасьць табе дабраславеньне Абрагама, табе і насеньню твайму з табою, каб ты ўзяў у спадчыну зямлю вандраваньня твайго, якую Бог даў Абрагаму». ");
INSERT INTO bel_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I паслаў Ісаак Якуба, і ён пайшоў у Падан-Арам да Лявана, сына Бэтуэля Арамейца, брата Рэбэкі, маці Якуба і Эзава. ");
INSERT INTO bel_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","I бачыў Эзаў, што дабраславіў Ісаак Якуба, і, дабраслаўляючы яго, паслаў яго ў Падан-Арам узяць сабе адтуль жонку, і загадаў яму, кажучы: «Не бяры жонкі з дачок Ханаану»; ");
INSERT INTO bel_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","і што паслухаў Якуб бацьку свайго і маці сваю, і пайшоў у Падан-Арам. ");
INSERT INTO bel_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","I бачыў Эзаў, што ліхія дочкі Ханаану ў вачах Ісаака, бацькі ягонага. ");
INSERT INTO bel_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","I пайшоў Эзаў да Ізмаэля, і ўзяў за жонку сабе Махалят, дачку Ізмаэля, сына Абрагама, сястру Наваёта, акрамя тых жонак, якія меў. ");
INSERT INTO bel_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","I выйшаў Якуб з Бээр-Шэвы, і пайшоў у Харан. ");
INSERT INTO bel_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I трапіў ён на адно месца, і заначаваў там, бо зайшло сонца. I ўзяў камяні з таго месца, і палажыў пад галаву сваю, і лёг спаць на тым месцы. ");
INSERT INTO bel_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I сьніў ён, і вось, лесьвіца стаіць на зямлі, а верх яе дакранаецца да неба; і вось, анёлы Божыя ўзыходзяць і зыходзяць па ёй. ");
INSERT INTO bel_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","I вось, ГОСПАД стаў над ім і сказаў: «Я — ГОСПАД, Бог Абрагама, бацькі твайго, і Бог Ісаака. Зямлю, на якой ты ляжыш, Я дам табе і насеньню твайму. ");
INSERT INTO bel_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I станецца насеньне тваё, як пясок зямлі; і ты распаўсюдзішся на захад, і на ўсход, і на поўнач, і на поўдзень, і будуць дабраслаўлёныя ў табе і ў насеньні тваім усе плямёны зямлі. ");
INSERT INTO bel_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I вось, Я з табою, і буду захоўваць цябе ўсюды, куды ты пойдзеш, і вярну цябе ў гэтую зямлю, бо Я не пакіну цябе, пакуль не зраблю таго, што Я сказаў табе». ");
INSERT INTO bel_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","I прачнуўся Якуб зо-сну свайго, і сказаў: «Сапраўды ГОСПАД ёсьць на месцы гэтым, а я ня ведаў!» ");
INSERT INTO bel_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I спалохаўся, і сказаў: «Якое страшнае месца гэтае! Гэта нішто іншае, як дом Божы, і гэта брама неба». ");
INSERT INTO bel_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","I ўстаў Якуб рана раніцай, і ўзяў камень, які ён палажыў пад галаву сваю, і паставіў яго як слуп, і наліў алей на верх ягоны. ");
INSERT INTO bel_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","I назваў імя месца таго Бэтэль; а раней імя гораду таго было Люз. ");
INSERT INTO bel_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","I абяцаў Якуб абяцаньне, кажучы: «Калі Бог будзе са мною, і будзе захоўваць мяне на гэтым шляху, якім я іду, і дасьць мне хлеб есьці і адзежу адзецца, ");
INSERT INTO bel_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","і я вярнуся ў супакоі ў дом бацькі майго, і будзе ГОСПАД мне Богам, ");
INSERT INTO bel_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","дык камень гэты, які я паставіў як слуп, будзе домам Божым, і з усяго, што Ты дасі мне, я аддзялю Табе дзесяціну». ");
INSERT INTO bel_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","I ўстаў Якуб на ногі свае, і пайшоў у зямлю сыноў Усходу. ");
INSERT INTO bel_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I ўбачыў, і вось, студня на полі, і вось, там тры чарады авечак ляжаць каля яе, бо са студні гэтай паілі чароды, і вялікі камень быў на адтуліне студні. ");
INSERT INTO bel_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","I зьбіраліся туды ўсе чароды, і адкочвалі камень з адтуліны студні, і паілі авечак, і зноў вярталі камень на месца сваё. ");
INSERT INTO bel_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","I сказаў ім Якуб: «Браты мае, адкуль вы?» I яны сказалі: «Мы з Харану». ");
INSERT INTO bel_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I ён сказаў ім: «Ці ведаеце вы Лявана, сына Нахора?» І яны сказалі: «Ведаем». ");
INSERT INTO bel_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","I ён сказаў ім: «Ці добра ён маецца?» І яны сказалі: «Добра. А вось, Рахель, дачка ягоная, прыйшла з авечкамі». ");
INSERT INTO bel_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I ён сказаў: «Вось, яшчэ вялікі дзень наперадзе; ня час зьбіраць статак; напаіце авечак, і ідзіце, і пасьвіце». ");
INSERT INTO bel_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","А яны сказалі: «Ня можам, аж пакуль не зьбяруцца ўсе чароды, і не адкоцяць камень з адтуліны студні, і тады напоім авечак». ");
INSERT INTO bel_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Яшчэ ён гаварыў з імі, і вось, Рахель прыйшла з авечкамі бацькі свайго, бо яна пасьвіла іх. ");
INSERT INTO bel_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","I сталася, калі ўбачыў Якуб Рахель, дачку Лявана, брата маці сваёй, і авечкі Лявана, брата маці сваёй, падыйшоў Якуб, і адкаціў камень з адтуліны студні, і напаіў авечак Лявана, брата маці сваёй. ");
INSERT INTO bel_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","I пацалаваў Якуб Рахель, і ўзвысіў голас свой, і заплакаў. ");
INSERT INTO bel_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I распавёў Якуб Рахелі, што ён брат бацьку ейнаму, і што ён сын Рэбэкі. I яна пабегла, і распавяла бацьку свайму. ");
INSERT INTO bel_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","I сталася, калі пачуў Ляван навіну пра Якуба, сына сястры сваёй, выбег яму насустрач, і абняў яго, і пацалаваў яго, і прывёў яго ў дом свой, і ён распавёў Лявану пра ўсе падзеі. ");
INSERT INTO bel_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","I сказаў яму Ляван: «Вось, ты — костка мая і цела маё». I жыў у яго цэлы месяц. ");
INSERT INTO bel_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","I сказаў Ляван Якубу: «Хоць ты брат мой, ці ж будзеш служыць мне задарма? Скажы мне, якая плата твая?» ");
INSERT INTO bel_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","А ў Лявана былі дзьве дачкі, імя старэйшай — Лея, а імя малодшай — Рахель. ");
INSERT INTO bel_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Вочы Леі былі кволыя, а Рахель была прыгожая пастацьцю і прыгожая абліччам. ");
INSERT INTO bel_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","I пакахаў Якуб Рахель, і сказаў: «Я буду служыць табе сем гадоў за Рахель, дачку тваю малодшую». ");
INSERT INTO bel_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","I сказаў Ляван: «Лепш, калі я аддам яе за цябе, чым аддам за іншага чалавека. Жыві са мною». ");
INSERT INTO bel_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","I служыў Якуб за Рахель сем гадоў, і былі яны ў вачах ягоных як некалькі дзён, бо ён кахаў яе. ");
INSERT INTO bel_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","I сказаў Якуб Лявану: «Дай жонку маю, бо споўніліся дні мае, і я пайду да яе». ");
INSERT INTO bel_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","I сабраў Ляван усіх людзей таго месца, і справіў гасьціну. ");
INSERT INTO bel_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","I быў вечар, і ўзяў ён Лею, дачку сваю, і ўвёў яе да яго, і той увайшоў да яе. ");
INSERT INTO bel_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","I даў Ляван Зільпу, нявольніцу сваю, Леі, дачцэ сваёй, за нявольніцу. ");
INSERT INTO bel_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","I сталася раніцаю, што ўбачыў Якуб, вось, гэта Лея. I сказаў Якуб Лявану: «Што ты зрабіў мне? Ці не за Рахель я служыў у цябе? Чаму ж ты ашукаў мяне?» ");
INSERT INTO bel_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","I сказаў Ляван: «Ня робіцца так у мясцовасьці нашай, каб малодшую выдаваць перад старэйшай. ");
INSERT INTO bel_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Споўні тыдзень з гэтай, і дам табе таксама тую, за якую ты будзеш служыць у мяне яшчэ сем іншых гадоў». ");
INSERT INTO bel_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","I зрабіў Якуб так, і споўніў тыдзень з гэтай. I Ляван даў Рахель, дачку сваю, яму за жонку. ");
INSERT INTO bel_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","I даў Ляван Рахелі, дачцэ сваёй, Більгу, нявольніцу сваю, за нявольніцу для яе. ");
INSERT INTO bel_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","I ўвайшоў Якуб да Рахелі, і кахаў Рахель больш за Лею; і служыў у яго яшчэ сем іншых гадоў. ");
INSERT INTO bel_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","I бачыў ГОСПАД, што зьненавіджана Лея, і адчыніў улоньне ейнае, а Рахель была бясплодная. ");
INSERT INTO bel_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","I зачала Лея, і нарадзіла сына, і назвала імя яго Рубэн, бо сказала: «Бо ўбачыў ГОСПАД гора маё, бо цяпер будзе кахаць мяне муж мой». ");
INSERT INTO bel_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","I зачала яна ізноў, і нарадзіла сына, і сказала: «Бо пачуў ГОСПАД, што я зьненавіджана, і даў мне гэтага сына». I назвала імя ягонае Сымон. ");
INSERT INTO bel_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","I зачала яшчэ, і нарадзіла сына, і сказала: «Цяпер, гэтым разам прытуліцца муж мой да мяне, бо я нарадзіла яму трох сыноў». І таму назвала імя ягонае Левій. ");
INSERT INTO bel_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","I зачала яшчэ, і нарадзіла сына, і сказала: «Гэтым разам я буду славіць ГОСПАДА». І таму назвала імя ягонае Юда, і перастала нараджаць. ");
INSERT INTO bel_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","I бачыла Рахель, што яна не нараджае Якубу, і зайздросьціла Рахель сястры сваёй, і казала Якубу: «Дай мне сыноў, а калі не, я памру». ");
INSERT INTO bel_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","I ўзгарэўся гнеў Якуба на Рахель, і ён сказаў: «Ці ж гэта я, а ня Бог затрымаў у цябе плод улоньня?» ");
INSERT INTO bel_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","I яна сказала: «Вось, нявольніца мая Більга. Увайдзі да яе, і яна народзіць на каленях маіх, і я буду збудаваная праз яе». ");
INSERT INTO bel_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","I яна дала яму Більгу, нявольніцу сваю, за жонку, і ўвайшоў да яе Якуб. ");
INSERT INTO bel_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","I зачала Більга, і нарадзіла Якубу сына. ");
INSERT INTO bel_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","I сказала Рахель: «Рассудзіў мяне Бог, і таксама пачуў голас мой, і даў мне сына». І таму назвала імя ягонае Дан. ");
INSERT INTO bel_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","I зачала яшчэ, і нарадзіла Більга, нявольніца Рахелі, другога сына Якубу. ");
INSERT INTO bel_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","I сказала Рахель: «Ваяваньнем Божым змагалася я з сястрою сваёй і адолела». I назвала імя ягонае Нэфталі. ");
INSERT INTO bel_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","I ўбачыла Лея, што перастала нараджаць, і ўзяла Зільпу, нявольніцу сваю, і дала яе Якубу за жонку. ");
INSERT INTO bel_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","I нарадзіла Зільпа, нявольніца Леі, Якубу сына. ");
INSERT INTO bel_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","I сказала Лея: «Прыйшоў посьпех!» I назвала імя ягонае Гад. ");
INSERT INTO bel_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","I нарадзіла Зільпа, нявольніца Леі, другога сына Якубу. ");
INSERT INTO bel_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","I сказала Лея: «На шчасьце маё, бо шчасьлівай будуць называць мяне дочкі». I назвала імя ягонае Асэр. ");
INSERT INTO bel_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","I выйшаў Рубэн у дні жніва пшаніцы, і знайшоў мандрагоры ў полі, і прынёс іх Леі, маці сваёй. I сказала Рахель Леі: «Дай мне мандрагоры сына твайго». ");
INSERT INTO bel_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","А тая сказала ёй: «Няўжо мала табе, што ты ўзяла мужа майго, і хочаш узяць мандрагоры сына майго?» I сказала Рахель: «Дык няхай ён ляжа з табою ў гэтую ноч за мандрагоры сына твайго». ");
INSERT INTO bel_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","I прыйшоў Якуб з поля ўвечары, і выйшла Лея насустрач яму, і сказала: «Да мяне ўвойдзеш, бо наймаючы, наняла цябе за мандрагоры сына майго». I ён лёг з ёю ў тую ноч. ");
INSERT INTO bel_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","I пачуў Бог Лею, і яна зачала, і нарадзіла Якубу пятага сына. ");
INSERT INTO bel_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I сказала Лея: «Даў Бог плату маю за тое, што я дала нявольніцу маю мужу майму». I назвала імя ягонае Ісахар. ");
INSERT INTO bel_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","I зачала ізноў Лея, і нарадзіла шостага сына Якубу. ");
INSERT INTO bel_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","I сказала Лея: «Абдараваў мяне Бог добрым дарам. Гэтым разам будзе жыць са мною муж мой, бо я нарадзіла яму шэсьць сыноў». I назвала імя ягонае Завулён. ");
INSERT INTO bel_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Потым нарадзіла дачку, і назвала імя ейнае Дзіна. ");
INSERT INTO bel_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","I ўзгадаў Бог пра Рахель, і пачуў яе Бог, і адчыніў улоньне ейнае, ");
INSERT INTO bel_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","і яна зачала, і нарадзіла сына, і сказала: «Забраў Бог ганьбу маю». ");
INSERT INTO bel_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","I назвала імя ягонае Язэп, кажучы: «Няхай дадасьць мне ГОСПАД другога сына». ");
INSERT INTO bel_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","I сталася, калі нарадзіла Рахель Язэпа, сказаў Якуб Лявану: «Пусьці мяне, і я пайду ў мясцовасьць сваю і ў зямлю сваю. ");
INSERT INTO bel_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дай мне жонак маіх і дзяцей маіх, бо я служыў табе за іх, і я пайду; бо ты ведаеш службу маю, якою я служыў табе». ");
INSERT INTO bel_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","I сказаў яму Ляван: «О, каб я знайшоў ласку ў вачах тваіх! Я пераканаўся, што ГОСПАД дабраславіў мяне дзеля цябе». ");
INSERT INTO bel_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I сказаў: «Прызнач сабе плату сваю ад мяне, і я дам». ");
INSERT INTO bel_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","I Якуб сказаў яму: «Ты ведаеш, як я служыў табе, і які стаўся статак твой пры мне; ");
INSERT INTO bel_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","бо мала было ў цябе да мяне, а памножылася ў мноства, і дабраславіў ГОСПАД цябе, калі я прыйшоў. А цяпер, калі я буду рабіць для дому майго?» ");
INSERT INTO bel_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","I той сказаў: «Што маю даць табе?» I сказаў Якуб: «Не давай мне нічога, але зрабі для мяне такую рэч, і я вярнуся, і буду пасьвіць і захоўваць авечкі твае. ");
INSERT INTO bel_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Я прайду сёньня між усіх авечак тваіх, і аддзялю з іх кожнае ягня стракатае і пярэстае, і кожную рудую з авечак, і стракатых і пярэстых з козаў; і будзе гэта мая плата. ");
INSERT INTO bel_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","I будзе адказваць за мяне праведнасьць мая на наступны дзень, калі прыйдзеш даведацца пра плату маю перад табою. Усё ў мяне, што не стракатае і не пярэстае паміж козаў, і не рудое паміж авечак, крадзенае гэта». ");
INSERT INTO bel_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","I сказаў Ляван: «Няхай будзе паводле слова твайго». ");
INSERT INTO bel_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","I адлучыў у той дзень казлоў пасастых і пярэстых, і ўсіх козаў стракатых і пярэстых, усіх, што мелі нешта белае на сабе, і ўсіх рудых паміж авечак, і аддаў у рукі сыноў сваіх. ");
INSERT INTO bel_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","I вызначыў дарогу ў тры дні паміж сабою і Якубам. I Якуб пасьвіў авечкі Лявана, якія засталіся. ");
INSERT INTO bel_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","I ўзяў Якуб зялёных прутоў тапалёвых, і мігдалёвых, і яваровых, і выразаў на іх пасы белыя, зьняўшы кару да бялосьці, якая на прутах, ");
INSERT INTO bel_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","і ўткнуў тыя пруты, якія аблупіў, перад авечкамі пры карытах каля вадапою, куды прыходзілі авечкі піць і спалучаліся, прыходзячы піць. ");
INSERT INTO bel_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","I спалучаліся авечкі перад прутамі, і нараджаліся авечкі пасастыя, стракатыя і пярэстыя. ");
INSERT INTO bel_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","І авечак белых аддзяляў Якуб, і гнаў, як авечкі Лявана, наперадзе авечак пярэстых і ўсіх рудых, і трымаў свае чароды асобна, і не злучаў іх з авечкамі Лявана. ");
INSERT INTO bel_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","I было, калі спалучаліся мацнейшыя авечкі, Якуб клаў пруты перад вачыма авечак пры карытах, каб яны спалучаліся перад прутамі, ");
INSERT INTO bel_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","а калі авечкі былі слабыя, тады ня клаў. I былі слабейшыя ў Лявана, а мацнейшыя — у Якуба. ");
INSERT INTO bel_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","I пашырыўся чалавек гэты вельмі, вельмі, і было ў яго мноства авечак, і нявольніцаў, і слугаў, і вярблюдаў, і аслоў. ");
INSERT INTO bel_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","I пачуў Якуб словы сыноў Лявана, якія казалі: «Забраў Якуб усё, што было ў бацькі нашага, і з таго, што было ў бацькі нашага, учыніў сабе ўсю гэтую славу». ");
INSERT INTO bel_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","I бачыў Якуб аблічча Лявана, і вось, ён ня быў з ім такі, як учора і пазаўчора. ");
INSERT INTO bel_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","I сказаў ГОСПАД Якубу: «Вярніся ў зямлю бацькоў тваіх і нараджэньня твайго, і Я буду з табою». ");
INSERT INTO bel_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","I паслаў Якуб, і паклікаў Рахель і Лею ў поле да авечак сваіх, ");
INSERT INTO bel_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","і сказаў ім: «Я бачу аблічча бацькі вашага, што ён не такі да мяне, як учора ці пазаўчора. I Бог бацькі майго быў са мною. ");
INSERT INTO bel_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","I вы ведаеце, што я ўсімі сіламі служыў бацьку вашаму, ");
INSERT INTO bel_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","і бацька ваш ашукваў мяне, і зьмяняў плату маю дзесяць разоў, але ня даў яму Бог зрабіць крыўду мне. ");
INSERT INTO bel_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Калі сказаў ён: “Стракатыя будуць платай тваёй”, нараджаліся ўсе авечкі стракатыя. А калі сказаў ён: “Пасастыя будуць платай тваёй”, нараджаліся ўсе авечкі пасастыя. ");
INSERT INTO bel_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","I забраў Бог статак у бацькі вашага, і даў яго мне. ");
INSERT INTO bel_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","I было ў часе параваньня авечак, і ўзьняў я вочы мае, і бачыў у сьне, і вось, бараны, якія ўскочылі на авечак, былі пасастыя, стракатыя і пярэстыя. ");
INSERT INTO bel_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","I сказаў мне анёл Божы ў сьне: “Якубе!” І я сказаў: “Вось я!” ");
INSERT INTO bel_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","I Ён сказаў: “Узьнімі вочы твае і паглядзі: усе бараны, якія ўскочылі на авечак, пасастыя, стракатыя і пярэстыя, бо Я бачыў усё, што Ляван робіць табе. ");
INSERT INTO bel_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Я — Бог з Бэтэлю, дзе ты памазаў слуп і дзе абяцаў Мне абяцаньне. Цяпер устань, выйдзі з зямлі гэтае, і вярніся ў зямлю нараджэньня твайго”». ");
INSERT INTO bel_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","I адказалі Рахель і Лея, і сказалі яму: «Ці ёсьць яшчэ ў нас частка і спадчына ў доме бацькі нашага? ");
INSERT INTO bel_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ці не за чужых ён нас мае? Бо ён прадаў нас, і еў, зьядаючы срэбра нашае. ");
INSERT INTO bel_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Таму ўсё багацьце, якое забраў Бог у бацькі нашага, нашае яно і дзяцей нашых. I цяпер усё, што сказаў Бог табе, рабі». ");
INSERT INTO bel_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","I ўстаў Якуб, і пасадзіў дзяцей сваіх і жонак сваіх на вярблюдаў. ");
INSERT INTO bel_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","I павёў усе статкі свае і ўсю маёмасьць сваю, якую прыдбаў, статкі ўласнасьці сваёй, якую ён прыдбаў у Падан-Араме, каб ісьці да Ісаака, бацькі свайго, у зямлю Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","А Ляван пайшоў стрыгчы авечкі свае. I ўкрала Рахель балваноў, якія былі ў бацькі ейнага. ");
INSERT INTO bel_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","I ашукаў Якуб сэрца Лявана Арамейца, бо не сказаў яму, што ўцякае. ");
INSERT INTO bel_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I ўцёк ён з усім, што ў яго; і ўстаў, і перайшоў праз раку, і скіраваў аблічча сваё да гары Гілеад. ");
INSERT INTO bel_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","I паведамілі Лявану на трэці дзень, што ўцёк Якуб. ");
INSERT INTO bel_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","I ўзяў ён з сабою братоў сваіх, і гнаўся за ім дарогаю сем дзён, і дагнаў яго на гары Гілеад. ");
INSERT INTO bel_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","I прыйшоў Бог да Лявана Арамейца ў сьне ўначы, і сказаў яму: «Сьцеражыся, не гавары Якубу ані добрага, ані ліхога». ");
INSERT INTO bel_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","I дагнаў Ляван Якуба, а Якуб паставіў намёт свой на гары. І Ляван паставіў намёт з братамі сваімі на гары Гілеад. ");
INSERT INTO bel_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","I сказаў Ляван Якубу: «Што ты зрабіў? Ты ашукаў сэрца маё, і вывеў дочак маіх, быццам палоненых мячом. ");
INSERT INTO bel_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Чаму ты патаемна ўцёк, і абакраў мяне, і не сказаў мне? І я адпусьціў бы цябе з радасьцю і сьпевамі, з бубнамі і гусьлямі. ");
INSERT INTO bel_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","А ты не дазволіў мне пацалаваць сыноў маіх і дочак маіх. Гэта ты дрэнна зрабіў. ");
INSERT INTO bel_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ёсьць сіла ў руцэ маёй учыніць вам ліха, але Бог бацькі вашага ўчора ўначы сказаў мне, кажучы: “Сьцеражыся, не гавары Якубу ані добрага, ані ліхога”. ");
INSERT INTO bel_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","І цяпер ты, ідучы, пайшоў, бо ты сумуючы, засумаваў па доме бацькі твайго. Але навошта ты скраў багоў маіх?» ");
INSERT INTO bel_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","I адказаў Якуб, і сказаў Лявану: «Бо я баяўся, бо я казаў, што ты забярэш дочак сваіх у мяне. ");
INSERT INTO bel_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","У каго знойдзеш багоў сваіх, той ня будзе жыць. Перад братамі нашымі правер, што ёсьць у мяне, і вазьмі сабе». А ня ведаў Якуб, што Рахель скрала іх. ");
INSERT INTO bel_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","I ўвайшоў Ляван у намёт Якуба, і ў намёт Леі, і намёт дзьвюх нявольніцаў, і не знайшоў. I выйшаў з намёту Леі, і ўвайшоў у намёт Рахелі. ");
INSERT INTO bel_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","А Рахель узяла балваноў, і палажыла іх пад вярблюджае сядло, і села на іх. I абшукаў Ляван увесь намёт, і не знайшоў. ");
INSERT INTO bel_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","I сказала яна бацьку свайму: «Няхай не ўзгарыцца гнеў у вачах пана майго, што я не магу ўстаць перад табою, бо слабасьць жаночая ў мяне». I ён шукаў, і не знайшоў балваноў. ");
INSERT INTO bel_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","I ўзгарэўся гнеў Якуба, і ён сварыўся з Ляванам. I адказаў Якуб, і сказаў Лявану: «Якая віна мая, які грэх мой, што ты гнаўся за мною? ");
INSERT INTO bel_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Бо ты абшукаў усе рэчы мае. Ці знайшоў ты нешта з рэчаў дому свайго? Палажы іх тут перад братамі маімі і братамі тваімі. Няхай яны рассудзяць паміж намі двума. ");
INSERT INTO bel_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Вось, дваццаць год я быў з табою. Авечкі твае і козы твае не скідалі, і бараноў з авечак тваіх я ня еў. ");
INSERT INTO bel_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Разьдзёртага зьвярамі я не прыносіў да цябе, я сам нёс віну, з рукі маёй ты шукаў гэта, ці яно было ўкрадзена ўдзень, ці ўкрадзена ўначы. ");
INSERT INTO bel_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Было, што ўдзень жэрла мяне гарачыня, і мароз — уначы; і ўцякаў сон мой з вачэй маіх. ");
INSERT INTO bel_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Гэтакія былі мае дваццаць гадоў у доме тваім. Я служыў табе чатырнаццаць гадоў за дзьве дочкі твае і шэсьць гадоў за авечак тваіх, і ты зьмяняў плату маю дзесяць разоў. ");
INSERT INTO bel_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Калі б Бог бацькі майго, Бог Абрагама і Той, Каго баіцца Ісаак, ня быў са мною, дык цяпер пустым ты выслаў бы мяне. Пакуты мае і працу рук маіх бачыў Бог і рассудзіў учора ўвечары». ");
INSERT INTO bel_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","I адказаў Ляван, і сказаў Якубу: «Дочкі гэтыя — мае дочкі, і сыны гэтыя — мае сыны; і авечкі гэтыя — мае авечкі, і ўсё, што ты бачыш, — гэта маё. I дочкам маім, што я зраблю ім сёньня, або сынам іхнім, якіх яны нарадзілі? ");
INSERT INTO bel_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","А цяпер хадзі, заключым запавет я і ты, і ён будзе сьведчаньнем паміж мною і табою». ");
INSERT INTO bel_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","I ўзяў Якуб камень, і паставіў яго як слуп. ");
INSERT INTO bel_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","I сказаў Якуб братам сваім: «Назьбірайце камянёў». І яны ўзялі камяні, і зрабілі крушню, і елі там на крушні. ");
INSERT INTO bel_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","I назваў яе Ляван Егар-Сагадута, а Якуб назваў яе Галед. ");
INSERT INTO bel_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","I сказаў Ляван: «Крушня гэтая — сьведчаньне паміж мною і табою сёньня». Таму і назвалі імя ейнае Галед ");
INSERT INTO bel_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","і Міцпа, бо ён сказаў: «Няхай назірае ГОСПАД паміж мною і табою, калі разыйдземся адзін ад аднаго. ");
INSERT INTO bel_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Калі ты будзеш уціскаць дочак маіх і калі возьмеш жонак акрамя дочак маіх, хоць няма чалавека з намі, глядзі, Бог — сьведка паміж мною і табою». ");
INSERT INTO bel_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","I сказаў Ляван Якубу: «Вось крушня гэтая, і вось слуп, які я паставіў паміж мною і табою. ");
INSERT INTO bel_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Сьведкам будзе крушня гэтая і сьведкам будзе слуп, што ані я не перайду да цябе за гэтую крушню і за гэты слуп, ані ты не пяройдзеш да мяне за гэтую крушню і за гэты слуп з ліхім намерам. ");
INSERT INTO bel_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Бог Абрагама і Бог Нахора, Бог бацькоў іхніх няхай судзіць нас». I прысягнуў Якуб на Таго, Каго баіцца бацька ягоны Ісаак. ");
INSERT INTO bel_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","I ахвяраваў Якуб ахвяру на гары, і паклікаў братоў сваіх есьці хлеб. І яны елі хлеб, і начавалі на гары. ");
INSERT INTO bel_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","I ўстаў Ляван рана раніцай, і пацалаваў сыноў сваіх і дочак сваіх, і дабраславіў іх, і пайшоў, і вярнуўся Ляван на месца сваё. ");
INSERT INTO bel_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","А Якуб пайшоў дарогаю сваёй. I сустрэлі яго анёлы Божыя. ");
INSERT INTO bel_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","I сказаў Якуб, убачыўшы іх: «Гэта табар Божы». I назваў імя месца таго Маханаім. ");
INSERT INTO bel_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","I паслаў Якуб пасланцоў перад сабою да Эзава, брата свайго, у зямлю Сэір, на поле Эдому. ");
INSERT INTO bel_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I загадаў ім, кажучы: «Гэтак скажаце пану майму Эзаву: “Так кажа слуга твой Якуб. У Лявана я жыў, і заставаўся аж дагэтуль. ");
INSERT INTO bel_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I сталася, што маю вала і асла, і авечку, і слугу, і нявольніцу, і я паслаў сказаць пану майму, каб знайсьці ласку ў вачах тваіх”». ");
INSERT INTO bel_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","I вярнуліся пасланцы да Якуба, кажучы: «Мы прыйшлі да брата твайго, да Эзава, і ён таксама ідзе насустрач табе, і чатырыста чалавек з ім». ");
INSERT INTO bel_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","I спалохаўся Якуб вельмі, і быў стрывожаны, і падзяліў людзей, якія былі з ім, і авечак, і валоў, і вярблюдаў на два табары, ");
INSERT INTO bel_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I сказаў: «Калі Эзаў прыйдзе на адзін табар і выб’е яго, табар, які застанецца, уцячэ». ");
INSERT INTO bel_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","I сказаў Якуб: «Божа бацькі майго Абрагама і Божа бацькі майго Ісаака, ГОСПАДЗЕ, Ты сказаў мне: “Вярніся ў зямлю тваю, да родзічаў тваіх, і Я зраблю, каб было добра табе”. ");
INSERT INTO bel_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Я ня варты ўсёй міласэрнасьці і ўсёй праўды, якую Ты ўчыніў для слугі Твайго, бо я з кіем маім перайшоў Ярдан гэты, а цяпер стаю з двума табарамі. ");
INSERT INTO bel_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Выратуй, прашу, мяне з рукі брата майго, з рукі Эзава, бо я баюся яго, каб ён не прыйшоў, і не забіў мяне, і матак разам з сынамі. ");
INSERT INTO bel_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ты сказаў: “Робячы дабро, буду рабіць дабро табе, і зраблю насеньне тваё як пясок марскі, якога нельга палічыць дзеля мноства яго”». ");
INSERT INTO bel_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I начаваў там у тую ноч, і ўзяў з таго, што прыйшло ў рукі яму, дары для Эзава, брата свайго: ");
INSERT INTO bel_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","козаў дзьвесьце, казлоў дваццаць, авечак дзьвесьце і бараноў дваццаць, ");
INSERT INTO bel_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","вярблюдзіцаў дойных з вярблюдзянятамі іхнімі трыццаць, кароў сорак і валоў дзесяць, асьліцаў дваццаць і асьлянят дзесяць. ");
INSERT INTO bel_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","I даў у рукі слугам сваім кожную чараду асобна, і сказаў слугам сваім: «Ідзіце перада мною і трымайце адлегласьць паміж чарадой і чарадой». ");
INSERT INTO bel_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I загадаў першаму, кажучы: «Калі сустрэне цябе Эзаў, брат мой, і спытаецца ў цябе, кажучы: “Чый ты і куды ідзеш? І чыё гэта перад абліччам тваім?\", ");
INSERT INTO bel_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ты скажаш: “Слугі твайго Якуба. Гэты дар пасланы пану майму Эзаву І вось, таксама ён ідзе за намі”». ");
INSERT INTO bel_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","І загадаў тое самае другому, і трэцяму, і ўсім, якія ішлі за чародамі, кажучы: «Паводле словаў гэтых кажыце Эзаву, калі знойдзеце яго, ");
INSERT INTO bel_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","і скажаце таксама: “Вось, слуга твой Якуб ідзе за намі”». Бо ён казаў: «Умалю аблічча ягонае дарам, які ідзе перада мною, і потым убачу аблічча ягонае. Можа, ён узьніме аблічча маё». ");
INSERT INTO bel_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","I перайшоў ручай дар перад ім, а ён начаваў у тую ноч у табары. ");
INSERT INTO bel_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","I ўстаў ён у тую ноч, і ўзяў дзьве жонкі свае, і дзьве нявольніцы свае, і адзінаццаць дзяцей сваіх, і перайшоў у брод Ябок. ");
INSERT INTO bel_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I ўзяў іх, і перавёў іх праз ручай, і перавёў, што было ў яго. ");
INSERT INTO bel_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","I застаўся Якуб сам адзін. І дужаўся з ім Муж да ўзыходу зараніцы. ");
INSERT INTO bel_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","I Той убачыў, што не пераможа яго, і дакрануўся да сустава сьцягна ягонага, і пашкодзіў сустаў сьцягна Якуба, калі дужаўся з ім, ");
INSERT INTO bel_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","і сказаў: «Пусьці Мяне, бо ўзыйшла зараніца». I сказаў Якуб: «Не пушчу Цябе, пакуль не дабраславіш мяне». ");
INSERT INTO bel_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","I Ён сказаў яму: «Якое імя тваё?» А ён сказаў: «Якуб». ");
INSERT INTO bel_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","I сказаў: «Не Якуб будуць называць ужо імя тваё, але Ізраіль, бо ты змагаўся з Богам і з людзьмі, і перамог». ");
INSERT INTO bel_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","I спытаўся Якуб, і сказаў: «Скажы, калі ласка, імя Тваё». I Ён сказаў: «Навошта ты пытаешся імя Маё?» I дабраславіў яго там. ");
INSERT INTO bel_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","I назваў Якуб імя таго месца: Пэніэль, бо казаў: «Я бачыў Бога абліччам да аблічча, і захаваная душа мая». ");
INSERT INTO bel_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I ўзыйшло сонца, калі ён праходзіў Пэніэль, і ён накульгваў на сьцягно сваё. ");
INSERT INTO bel_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Дзеля гэтага не ядуць сыны Ізраіля жылы цягліцы, якая на суставе сьцягна, аж да сёньня, бо Ён дакрануўся да суставу сьцягна Якуба, да жылы цягліцы. ");
INSERT INTO bel_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","I ўзьняў Якуб вочы свае, і ўбачыў, і вось, Эзаў прыйшоў, і з ім чатырыста чалавек. I ён падзяліў дзяцей Леі, Рахелі і дзьвюх нявольніцаў. ");
INSERT INTO bel_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I паставіў нявольніцаў і дзяцей іхніх першымі, а Лею і дзяцей ейных за імі, а Рахель і Язэпа за імі. ");
INSERT INTO bel_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","І ён выйшаў перад імі, і пакланіўся да зямлі сем разоў, пакуль наблізіўся да брата свайго. ");
INSERT INTO bel_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","I пабег Эзаў яму насустрач, і абняў яго, і ўпаў на шыю яму, і цалаваў яго, і плакалі разам. ");
INSERT INTO bel_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","І ўзьняў ён вочы свае, і ўбачыў жанчынаў і дзяцей, і сказаў: «Хто яны табе?» I сказаў Якуб: «Дзеці, якімі Бог абдараваў слугу твайго». ");
INSERT INTO bel_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","I наблізіліся нявольніцы, самі і дзеці іхнія, і пакланіліся. ");
INSERT INTO bel_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","I наблізілася таксама Лея і дзеці ейныя, і пакланіліся. А потым наблізіліся Язэп і Рахель, і пакланіліся. ");
INSERT INTO bel_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","I сказаў Эзаў: «Што ў цябе за цэлы табар гэты, які я сустрэў?» I сказаў Якуб: «Каб знайсьці ласку ў вачах пана майго». ");
INSERT INTO bel_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","I сказаў Эзаў: «Маю я шмат, браце мой. Няхай будзе тваё тое, што ў цябе». ");
INSERT INTO bel_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","I сказаў Якуб: «Не, прашу, калі я знайшоў ласку ў вачах тваіх, прыймі дар мой з рукі маёй, бо я, убачыўшы аблічча тваё, быццам убачыў аблічча Божае, і ты меў ласку да мяне. ");
INSERT INTO bel_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Прыймі, прашу, дабраславенства маё, якое я прывёў табе, бо Бог абдараваў мяне, і я маю ўсё». I ён упрасіў яго, і той узяў. ");
INSERT INTO bel_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","I сказаў Эзаў: «Вырушым і пойдзем, і я буду ісьці разам з табою». ");
INSERT INTO bel_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","I сказаў яму Якуб: «Пан мой ведае, што дзеці кволыя, і авечкі котныя, і каровы цельныя ў мяне. Калі пагнаць іх адзін дзень, паздыхаюць усе авечкі. ");
INSERT INTO bel_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Няхай пан мой пойдзе перад абліччам слугі свайго, а я пайду паволі, паводле хады чарады, якая перада мною, і паводле хады дзяцей, аж прыйду да пана майго ў Сэір». ");
INSERT INTO bel_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","I сказаў Эзаў: «Я пакіну з табою частку людзей, якія са мною». I сказаў Якуб: «Навошта гэта, калі я знайшоў ласку ў вачах пана майго». ");
INSERT INTO bel_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","I вярнуўся ў той дзень Эзаў шляхам сваім у Сэір. ");
INSERT INTO bel_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","А Якуб вырушыў у Сукот і пабудаваў сабе дом, а статку свайму парабіў буданы. Дзеля гэтага ён назваў імя месцу таму Сукот. ");
INSERT INTO bel_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","I прыйшоў Якуб у супакоі да гораду Сыхем, які ў зямлі Ханаан, калі прыйшоў з Падан-Араму, і паставіў намёты перад горадам. ");
INSERT INTO bel_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","I купіў ён частку поля, на якім паставіў намёт свой, з рукі сыноў Гамора, бацькі Сыхема, за сто кесытаў. ");
INSERT INTO bel_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","I паставіў там ахвярнік, і назваў яго «Бог ёсьць Бог Ізраіля». ");
INSERT INTO bel_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","I выйшла Дзіна, дачка Леі, якую яна нарадзіла Якубу, паглядзець на дочак зямлі той. ");
INSERT INTO bel_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","I ўбачыў яе Сыхем, сын Гамора Хівея, князя зямлі той, і ўзяў яе, і ляжаў з ёю, і згвалціў яе. ");
INSERT INTO bel_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","I прыляпілася душа ягоная да Дзіны, дачкі Якуба, і ён пакахаў дзяўчыну, і гаварыў да сэрца дзяўчыны. ");
INSERT INTO bel_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","I сказаў Сыхем Гамору, бацьку свайму, кажучы: «Вазьмі мне дзяўчыну гэтую за жонку». ");
INSERT INTO bel_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","I Якуб пачуў, што зганьбавана Дзіна, дачка ягоная, а сыны ягоныя былі пры статку на полі, і маўчаў Якуб, пакуль не прыйшлі яны. ");
INSERT INTO bel_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","I выйшаў Гамор, бацька Сыхему, да Якуба паразмаўляць з ім. ");
INSERT INTO bel_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","А сыны Якуба прыйшлі з поля, і, пачуўшы, засмуціліся мужы, і гневаліся вельмі, бо ганьбу зрабіў Сыхем Ізраілю, лёгшы з дачкою Якуба, бо гэтак ня робіцца. ");
INSERT INTO bel_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","I гаварыў Гамор з імі, кажучы: «Сыхем, сын мой, прыляпіўся душою сваёю да дачкі вашае. Дайце, прашу, яе яму за жонку. ");
INSERT INTO bel_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","І пасваячцеся з намі, дочак вашых дайце нам, а дочак нашых бярыце сабе. ");
INSERT INTO bel_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","I з намі жывіце, і зямля гэтая будзе перад абліччам вашым, жывіце і гандлюйце ў ёй, і бярыце яе на ўласнасьць». ");
INSERT INTO bel_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","I сказаў Сыхем бацьку ейнаму і братам ейным: «Каб я знайшоў ласку ў вачах вашых, і што скажаце мне, я дам. ");
INSERT INTO bel_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Павялічце мне вельмі вена і дары, і я дам, што вы скажаце мне, толькі дайце мне дзяўчыну за жонку». ");
INSERT INTO bel_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","I адказалі сыны Якуба Сыхему і Гамору, бацьку ягонаму, падступна, і гаварылі так, бо ён зганьбіў Дзіну, сястру іхнюю. ");
INSERT INTO bel_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I сказалі ім: «Ня можам зрабіць гэтага, выдаць сястру нашую чалавеку, які мае скуравінку, бо ганьба гэта для нас. ");
INSERT INTO bel_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Толькі тады мы пагодзімся з вамі, калі вы будзеце, як мы, каб быў абрэзаны ў вас кожны мужчына. ");
INSERT INTO bel_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","I будзем даваць дочак нашых вам, а дочак вашых браць сабе, і будзем жыць з вамі, і будзем адзін народ. ");
INSERT INTO bel_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","А калі не паслухаеце нас, каб абрэзацца, мы возьмем дачку нашую і адыйдзем». ");
INSERT INTO bel_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","I былі добрымі словы іхнія ў вачах Гамора і ў вачах Сыхема, сына Гамора. ");
INSERT INTO bel_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","I не затрымаўся юнак той зрабіць гэтую справу, бо ён жадаў дачку Якуба. А ён быў найбольш шанаваны ў-ва ўсім доме бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","I прыйшоў Гамор і Сыхем, сын ягоны, да брамы гораду свайго, і гаварылі жыхарам гораду свайго, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Гэтыя людзі прыязныя да нас. Няхай яны жывуць у зямлі гэтай і гандлююць у ёй. І зямля гэтая прасторная перад абліччам іхнім. Дочак іхніх возьмем сабе за жонак, а дочак нашых дамо ім. ");
INSERT INTO bel_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Толькі пры адной умове пагодзяцца з намі людзі гэтыя, каб жыць з намі і быць адным народам, калі ў нас будуць абрэзаныя ўсе мужчынскага роду, як яны абрэзаныя. ");
INSERT INTO bel_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Статкі іхнія, і маёмасьць іхняя, і ўся скаціна іхняя, ці ж ня нашая будзе? Толькі пагодзімся з імі, і яны будуць жыць з намі». ");
INSERT INTO bel_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","I паслухалі Гамора і Сыхема, сына ягонага, усе, што выходзілі з брамы гораду свайго; і былі абрэзаныя ўсе мужчынскага роду, усе, што выходзілі з брамы гораду свайго. ");
INSERT INTO bel_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","I сталася на трэці дзень, калі яны былі ў вялікім болю, узялі два сыны Якуба, Сымон і Левій, браты Дзіны, кожны меч свой, і ўвайшлі ў горад, які пачуваўся бясьпечна, і забілі ўсіх мужчынаў. ");
INSERT INTO bel_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","I Гамора, і Сыхема, сына ягонага, забілі вострывам мяча, і ўзялі Дзіну з дому Сыхема, і выйшлі. ");
INSERT INTO bel_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Сыны Якуба прыйшлі да забітых і зрабавалі горад за тое, што зганьбілі сястру іхнюю. ");
INSERT INTO bel_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I авечак іхніх, і валоў іхніх, і аслоў іхніх, і тое, што было ў горадзе і што было ў полі, яны ўзялі. ");
INSERT INTO bel_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I ўсё багацьце іхняе, і ўсіх дзяцей іхніх, і жанчынаў іхніх узялі ў палон, і зрабавалі ўсё, што было ў дамах. ");
INSERT INTO bel_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","I сказаў Якуб Сымону і Левію: «Вы зрабілі зьнішчэньне мне, зрабіўшы мяне агідным для жыхароў зямлі гэтае, Хананейцаў і Пэрэзэяў, а ў мяне людзей няшмат, і зьбяруцца на мяне, і паб’юць мяне, і будуць зьнішчаны я і дом мой». ");
INSERT INTO bel_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","А яны сказалі: «Ці ж можна рабіць з сястрою нашаю як з блудніцаю?» ");
INSERT INTO bel_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","I сказаў Бог Якубу: «Устань, узыйдзі ў Бэтэль, і жыві там, і зрабі там ахвярнік Богу, Які зьявіўся табе, калі ты ўцякаў ад аблічча Эзава, брата твайго». ");
INSERT INTO bel_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","I сказаў Якуб дому свайму і ўсім, якія былі з ім: «Аддзяліце ад сябе багоў чужых, якія сярод вас, і ачысьціцеся, і зьмяніце адзеньні вашыя, ");
INSERT INTO bel_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","і ўстаньма, і ўзыйдзем у Бэтэль, і я зраблю там ахвярнік Богу, Які адказаў мне ў дзень нядолі маёй і быў са мною ў дарозе, якой я ішоў». ");
INSERT INTO bel_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","I аддалі Якубу ўсіх багоў чужых, якія былі ў руках іхніх, і завушніцы, што былі ў вушах іхніх; і закапаў іх Якуб пад дубам, які каля Сыхему. ");
INSERT INTO bel_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","I вырушылі яны. I быў жах Божы на гарадах, што былі ў той ваколіцы, і ня гналіся яны за сынамі Якуба. ");
INSERT INTO bel_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","I прыйшоў Якуб у Люз, які ў зямлі Ханаан, ён жа Бэтэль, сам і ўвесь народ, які з ім. ");
INSERT INTO bel_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I пабудаваў ён там ахвярнік, і назваў гэтае месца Эль-Бэт-Эль, бо там зьявіўся яму Бог, калі ён уцякаў ад аблічча брата свайго. ");
INSERT INTO bel_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","I памерла Дэвора, нянька Рэбэкі, і была пахаваная ніжэй Бэтэлю пад дубам, і названа імя ягонае «Дуб плачу». ");
INSERT INTO bel_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","I зьявіўся Бог Якубу ізноў пасьля прыходу ягонага з Падан-Араму, і дабраславіў яго. ");
INSERT INTO bel_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I сказаў яму Бог: «Імя тваё Якуб. Ня будзе ўжо называцца імя тваё Якуб, але Ізраіль будзе імя тваё». I назваў яго імя Ізраіль. ");
INSERT INTO bel_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I сказаў яму Бог: «Я — Бог Усемагутны! Пладзіся і памнажайся! Народ і супольнасьць народаў будзе з цябе, і валадары выйдуць з паясьніцы тваёй. ");
INSERT INTO bel_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","І зямлю, якую Я даў Абрагаму і Ісааку, Я дам табе, і насеньню твайму пасьля цябе Я дам зямлю гэтую». ");
INSERT INTO bel_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","I ўзыйшоў ад яго Бог з месца, на якім гаварыў з ім. ");
INSERT INTO bel_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","I паставіў Якуб слуп на месцы, на якім Бог гаварыў з ім, слуп каменны, і ўзьліў на яго ўзьліваньне, і ўзьліў на яго алей. ");
INSERT INTO bel_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","I назваў Якуб імя месца, на якім Бог гаварыў з ім, Бэтэль. ");
INSERT INTO bel_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","I вырушыў з Бэтэлю. I быў яшчэ кавалак зямлі, каб прыйсьці да Эфраты; і нарадзіла Рахель, і цяжкія былі роды. ");
INSERT INTO bel_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","I сталася, што яна нараджала з вялікім болем, і сказала ёй павітуха: «Ня бойся, бо таксама гэта сын у цябе». ");
INSERT INTO bel_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","I сталася, калі выходзіла з яе душа, бо яна памірала, яна назвала імя ягонае Бэн-Оні, а бацька ягоны назваў яго Бэн’ямін. ");
INSERT INTO bel_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","I памерла Рахель, і была пахаваная пры дарозе ў Эфрату, гэта Бэтлеем. ");
INSERT INTO bel_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","I паставіў Якуб слуп над магілай ейнай. Гэта слуп магільны Рахелі да сёньня. ");
INSERT INTO bel_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","I вырушыў адтуль Ізраіль, і паставіў намёт свой за Мігдаль-Эдэрам. ");
INSERT INTO bel_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","I сталася, калі жыў Ізраіль у зямлі той, пайшоў Рубэн, і лёг з Більгай, наложніцай бацькі свайго. I пачуў пра гэта Ізраіль. I было сыноў Якуба дванаццаць. ");
INSERT INTO bel_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Сыны Леі: першародны Якуба Рубэн, Сымон, Левій, Юда, Ісахар і Завулён. ");
INSERT INTO bel_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Сыны Рахелі: Язэп і Бэн’ямін. ");
INSERT INTO bel_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","I сыны Більгі, нявольніцы Рахелі: Дан і Нэфталі. ");
INSERT INTO bel_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","I сыны Зільпы, нявольніцы Леі: Гад і Асэр. Гэта сыны Якуба, якія нарадзіліся ў яго ў Падан-Араме. ");
INSERT INTO bel_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","I прыйшоў Якуб да Ісаака, бацькі свайго, у Мамрэ, у Кірыят-Арбу, гэта значыць у Хеўрон, дзе жылі Абрагам і Ісаак. ");
INSERT INTO bel_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I было дзён Ісаака сто восемдзясят гадоў. ");
INSERT INTO bel_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I супачыў Ісаак, і памёр, і быў далучаны да народу свайго, стары і насычаны днямі, і пахавалі яго Эзаў і Якуб, сыны ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","I вось радавод Эзава, ён жа Эдом. ");
INSERT INTO bel_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Эзаў узяў сабе жонак з дачок Ханаану: Аду, дачку Элёна Хета, і Агаліваму, дачку Аны, дачку Цывеона Хівея, ");
INSERT INTO bel_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","і Басэмат, дачку Ізмаэля, сястру Наваёта. ");
INSERT INTO bel_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I нарадзіла Ада Эзаву Эліфаза, а Басэмат нарадзіла Рэўэля, ");
INSERT INTO bel_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","а Агалівама нарадзіла Евуша, Яляма і Караха. Гэта сыны Эзава, якія нарадзіліся ў яго ў зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","I ўзяў Эзаў жонак сваіх, і сыноў сваіх, і дочак сваіх, і ўсе душы дому свайго, і статкі свае, і ўсю скаціну сваю, і ўсю маёмасьць сваю, якую ён прыдбаў у зямлі Ханаан, і пайшоў у іншую зямлю ад аблічча Якуба, брата свайго, ");
INSERT INTO bel_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","бо была маёмасьць іхняя вялікая, каб яны маглі жыць разам, і не магла зямля вандраваньня іхняга насіць іх з прычыны статкаў іхніх. ");
INSERT INTO bel_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","I пасяліўся Эзаў на гары Сэір, Эзаў, ён жа Эдом. ");
INSERT INTO bel_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","I вось радавод Эзава, бацькі Эдому на гары Сэір. ");
INSERT INTO bel_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Вось імёны сыноў Эзава: Эліфаз, сын Ады, жонкі Эзава; Рэўэль, сын Басэмат, жонкі Эзава. ");
INSERT INTO bel_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","І былі сыны Эліфаза: Тэман, Амар, Цэфо, Гатам і Кеназ. ");
INSERT INTO bel_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","А Тымна была наложніцай Эліфаза, сына Эзава, і яна нарадзіла Эліфазу Амалека. Гэта сыны Ады, жонкі Эзава. ");
INSERT INTO bel_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","І вось сыны Рэўэля: Нахат, Зэрах, Шамма і Міза. Гэтыя былі сынамі Басэмат, жонкі Эзава. ");
INSERT INTO bel_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","I вось сыны Агалівамы, дачкі Аны, дачкі Цывеона, жонкі Эзава. Яна нарадзіла Эзаву Евуша, Яляма і Караха. ");
INSERT INTO bel_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Вось князі сыноў Эзава. Сыны Эліфаза, першароднага Эзава: князь Тэман, князь Амар, князь Цэфо, князь Кеназ, ");
INSERT INTO bel_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","князь Карах, князь Гатам, князь Амалек. Гэта князі Эліфаза ў зямлі Эдом, гэта сыны Ады. ");
INSERT INTO bel_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","А вось сыны Рэўэля, сына Эзава: князь Нагат, князь Зэрах, князь Шамма, князь Міза. Гэта князі Рэўэля ў зямлі Эдом, гэта сыны Басэмат, жонкі Эзава. ");
INSERT INTO bel_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","А вось сыны Агалівамы, жонкі Эзава: князь Евуш, князь Ялям, князь Карах. Гэта князі Агалівамы, дачкі Аны, жонкі Эзава. ");
INSERT INTO bel_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Вось сыны Эзава, і вось князі іхныя. Гэта Эдом. ");
INSERT INTO bel_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Вось сыны Сэіра Харэя, жыхары зямлі той: Лётан, Шаваль, Цывеон, Ана, ");
INSERT INTO bel_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дышон, Эцэр і Дышан. Гэта князі Харэяў, сыны Сэіра ў зямлі Эдом. ");
INSERT INTO bel_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","I былі сыны Лётана: Хоры і Геман, а сястра Лётана — Тымна. ");
INSERT INTO bel_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","А вось сыны Шаваля: Альван, Манахат, Эваль, Шэфо і Анам. ");
INSERT INTO bel_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","А вось сыны Цывеона: Ая і Ана. Гэта той Ана, які знайшоў гарачыя крыніцы ў пустыні, калі пасьвіў аслоў Цывеона, бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","А вось сыны Аны: Дышон і Агалівама, дачка Аны. ");
INSERT INTO bel_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","А вось сыны Дышона: Хемдан, Эшбан, Ітран, і Херан. ");
INSERT INTO bel_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Вось сыны Эцэра: Більган, Зааван і Акан. ");
INSERT INTO bel_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Вось сыны Дышана: Уц і Аран. ");
INSERT INTO bel_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Вось князі Харэяў: князь Лётан, князь Шаваль, князь Цывеон, князь Ана, ");
INSERT INTO bel_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","князь Дышон, князь Эцэр, князь Дышан. Гэта князі Харэяў паводле княстваў сваіх у зямлі Сэір. ");
INSERT INTO bel_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","А вось валадары, якія валадарылі ў зямлі Эдом, раней за валадараньне валадароў у сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","I валадарыў у Эдоме Бэла, сын Бэора, а імя гораду ягонага — Дынгава. ");
INSERT INTO bel_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","I памёр Бэла, і валадарыў пасьля яго Ёваў, сын Зэраха, з Боцры. ");
INSERT INTO bel_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","I памёр Ёваў, і валадарыў пасьля яго Хушам, з зямлі Тэман. ");
INSERT INTO bel_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","І памёр Хушам, і валадарыў пасьля яго Гадад, сын Бэдада, які пабіў Мадыянцаў на полі Мааўскім; а імя гораду ягонага — Авіт. ");
INSERT INTO bel_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","I памёр Гадад, і валадарыў пасьля яго Самла з Масрэкі. ");
INSERT INTO bel_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","I памёр Самла, і валадарыў пасьля яго Шауль з Рэхавота, што каля ракі. ");
INSERT INTO bel_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","I памёр Шауль, і валадарыў пасьля яго Баал-Ханан, сын Ахбора. ");
INSERT INTO bel_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","I памёр Баал-Ханан, сын Ахбора, і валадарыў пасьля яго Гадар, а імя гораду ягонага — Паў; а імя жонкі ягонае — Мэгетавэль, дачка Матрэды, дачкі Мэзагава. ");
INSERT INTO bel_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","А вось імёны князёў Эзава, паводле плямёнаў іхніх, паводле мясцовасьцяў іхніх, названых імёнамі іхнімі: князь Тымна, князь Альва, князь Етэт, ");
INSERT INTO bel_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","князь Агалівама, князь Эла, князь Пінон, ");
INSERT INTO bel_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","князь Кеназ, князь Тэман, князь Міўцар, ");
INSERT INTO bel_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","князь Магдыель, князь Ірам. Вось князі Эдому, паводле сялібаў іхніх, у зямлі ўласнасьці іхняй. Гэта Эзаў, бацька Эдому. ");
INSERT INTO bel_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","І жыў Якуб у зямлі вандраваньня бацькі свайго, у зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Вось радавод Якуба. Язэп, маючы сямнаццаць гадоў, пасьвіў авечкі з братамі сваімі. І быў ён юнаком, разам з сынамі Більгі і сынамі Зільпы, жонак бацькі свайго. I прыносіў Язэп ліхія весткі пра іх да бацькі іхняга. ");
INSERT INTO bel_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","А Ізраіль любіў Язэпа больш за ўсіх сыноў сваіх, бо ён быў сын старасьці ягонай; і ён справіў яму каляровую шату. ");
INSERT INTO bel_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","I ўбачылі браты ягоныя, што бацька іхні любіць яго больш за ўсіх братоў, і зьненавідзелі яго, і не маглі гаварыць з ім спакойна. ");
INSERT INTO bel_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","I сьніў Язэп сон, і расказаў братам сваім, і яны яшчэ больш зьненавідзелі яго. ");
INSERT INTO bel_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","І ён сказаў ім: «Паслухайце, калі ласка, сон гэты, які я сьніў. ");
INSERT INTO bel_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","I вось, мы вяжам снапы сярод поля; і вось, устаў сноп мой, і так стаяў; і вось, абступілі яго снапы вашыя і пакланіліся снапу майму». ");
INSERT INTO bel_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","I сказалі яму браты ягоныя: «Няўжо валадарачы, ты будзеш валадарыць над намі? Ці, пануючы, будзеш панаваць над намі?» I яшчэ больш зьненавідзелі яго за сны ягоныя і за словы ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","I сьніў ён яшчэ другі сон, і расказаў яго братам сваім, і сказаў: «Вось, я сьніў яшчэ сон. І вось, сонца, і месяц, і адзінаццаць зорак кланяліся мне». ");
INSERT INTO bel_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","I ён распавёў бацьку свайму і братам сваім; і насварыўся на яго бацька ягоны, і сказаў яму: «Што гэта за сон, які ты сьніў? Ці ж прыходзячы, прыйду я, і маці твая, і браты твае, каб пакланіцца табе да зямлі?» ");
INSERT INTO bel_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I зайздросьцілі яму браты ягоныя, а бацька ягоны захоўваў гэтае слова. ");
INSERT INTO bel_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","I пайшлі браты ягоныя пасьвіць авечкі бацькі свайго ў Сыхем. ");
INSERT INTO bel_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","I сказаў Ізраіль Язэпу: «Ці ж браты твае ня пасьвяць у Сыхеме? Ідзі, я пашлю цябе да іх». А ён сказаў яму: «Вось я!» ");
INSERT INTO bel_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I сказаў яму: «Пайдзі, прашу, паглядзі, ці ў супакоі браты твае і ці ў супакоі авечкі, і прынясі мне вестку». I паслаў яго з даліны Хеўрон; і ён пайшоў у Сыхем. ");
INSERT INTO bel_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I знайшоў яго нейкі чалавек, а вось, ён блукаў у полі, і спытаўся ў яго той чалавек, кажучы: «Што шукаеш?» ");
INSERT INTO bel_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","А ён сказаў: «Я шукаю братоў маіх. Прашу, скажы мне, дзе яны пасьвяць?» ");
INSERT INTO bel_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","I сказаў чалавек той: «Яны вырушылі адсюль, бо я чуў, як яны казалі: “Хадзем у Датан”». I пайшоў Язэп за братамі сваімі, і знайшоў іх у Датане. ");
INSERT INTO bel_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","I яны ўбачылі яго здалёк, перш, чым ён наблізіўся да іх, і змовіліся супраць яго, каб усьмерціць яго. ");
INSERT INTO bel_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I сказалі адзін да аднаго: «Вось, гэты гаспадар сноў ідзе. ");
INSERT INTO bel_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","I цяпер хадзем, і заб’ем яго, і кінем яго ў нейкую яму, і скажам: “Злы зьвер зьеў яго”, і паглядзім, што будзе з ягоных сноў». ");
INSERT INTO bel_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","I пачуў гэта Рубэн, і выбавіў яго з рук іхніх, і сказаў: «Не забівайма душы». ");
INSERT INTO bel_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","I сказаў ім Рубэн: «Не разьлівайце крыві, кіньце яго ў гэтую яму, якая ў пустыні, а рукі не выцягніце на яго», каб выбавіць яго ад рукі іхняй, каб вярнуць яго бацьку ягонаму. ");
INSERT INTO bel_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","I сталася, калі Язэп прыйшоў да братоў сваіх, яны зьнялі з Язэпа адзеньне ягонае, шату каляровую, якая была на ім. ");
INSERT INTO bel_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","I ўзялі яго, і кінулі яго ў яму; а яма была пустая, не было ў ёй вады. ");
INSERT INTO bel_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","I селі яны есьці хлеб, і ўзьнялі вочы свае, і ўбачылі, і вось, караван Ізмаэльцаў ідзе з Гілеаду, і вярблюды іхныя нясуць пахошчы, бальзам і ладан, ідучы, каб завезьці гэта ў Эгіпет. ");
INSERT INTO bel_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","I сказаў Юда братам сваім: «Якая карысьць, што мы заб’ем брата нашага і схаваем кроў ягоную? ");
INSERT INTO bel_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Пойдзем і прадамо яго Ізмаэльцам, і рукі нашыя няхай ня будуць на ім; бо ён — брат наш, цела наша». I паслухалі яго браты ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","I праходзілі тыя людзі, купцы Мадыянскія, а яны выцягнулі Язэпа з ямы, і прадалі Язэпа Ізмаэльцам за дваццаць срэбнікаў; і тыя завялі Язэпа ў Эгіпет. ");
INSERT INTO bel_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","I вярнуўся Рубэн да ямы, і вось, няма Язэпа ў яме. I разарваў ён адзеньне сваё, ");
INSERT INTO bel_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","і вярнуўся да братоў сваіх, і сказаў: «Хлопца няма, а я, куды я пайду?» ");
INSERT INTO bel_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","I ўзялі яны шату Язэпа, і зарэзалі казла, і намачылі шату ў крыві, ");
INSERT INTO bel_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","і паслалі шату каляровую, і прынесьлі бацьку свайму, і сказалі: «Гэта мы знайшлі. Спраўдзь, просім, ці гэта адзеньне сына твайго, ці не?» ");
INSERT INTO bel_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","I ён пазнаў яго, і сказаў: «Шаты сына майго. Дзікі зьвер зьеў яго, разьдзіраючы; разьдзёрты Язэп». ");
INSERT INTO bel_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","I разарваў Якуб адзеньне сваё, і апрануў зрэбніцу на сьцёгны свае, і плакаў па сыне сваім шмат дзён. ");
INSERT INTO bel_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","I ўсталі ўсе сыны ягоныя, і ўсе дочкі ягоныя, каб пацешыць яго, але ён адмаўляўся пацешыцца, і казаў: «Бо зыйду да сына майго са смуткам у апраметную». I плакаў па Язэпе бацька ягоны. ");
INSERT INTO bel_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","А Мадыянцы прадалі яго ў Эгіпце Патыфару, урадоўцу фараона, начальніку варты. ");
INSERT INTO bel_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","I сталася ў той час, і зыйшоў Юда ад братоў сваіх, і паставіў намёт свой у аднаго Адулямца, імя якога — Хіра. ");
INSERT INTO bel_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I ўбачыў там Юда дачку аднаго Хананейца, імя якога — Шуа, і ўзяў яе, і ўвайшоў да яе. ");
INSERT INTO bel_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","I яна зачала, і нарадзіла сына; і ён назваў імя ягонае Ер. ");
INSERT INTO bel_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I зачала яна зноў, і нарадзіла сына, і назвала імя ягонае Анан. ");
INSERT INTO bel_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","I яшчэ дадала, і нарадзіла сына, і назвала імя ягонае Шэля. Яна была ў Хезіве, калі нарадзіла яго. ");
INSERT INTO bel_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","I ўзяў Юда жонку для Ера, першароднага свайго, імя якой — Тамар. ");
INSERT INTO bel_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","I быў Ер, першародны Юды, ліхі ў вачах ГОСПАДА, і ўсьмерціў яго ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","I сказаў Юда Анану: «Увайдзі да жонкі брата свайго, і споўні абавязак швагра з ёю, і ўзнаві насеньне брату свайму». ");
INSERT INTO bel_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","I ведаў Анан, што не яму будзе насеньне; і было, што калі ён уваходзіў да жонкі брата свайго, выліваў на зямлю, каб ня даць насеньня брату свайму. ");
INSERT INTO bel_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I было ліхім у вачах ГОСПАДА тое, што ён рабіў; і Ён таксама ўсьмерціў яго. ");
INSERT INTO bel_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","I сказаў Юда Тамар, нявестцы сваёй: «Застанься ўдавою ў доме бацькі свайго, пакуль вырасьце Шэля, сын мой». Бо ён сказаў: «Каб не памёр таксама ён, як браты ягоныя». I пайшла Тамар, і жыла ў доме бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","I прайшло шмат дзён, і памерла дачка Шуа, жонка Юды. I суцешыўся Юда пасьля жалобы, і ўзыйшоў у Тымну да стрыгачоў авечак сваіх, сам і Хіра Адулямец, таварыш ягоны. ");
INSERT INTO bel_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","І паведамілі Тамар, кажучы: «Вось, сьвёкар твой узыходзіць у Тымну стрыгчы авечак сваіх». ");
INSERT INTO bel_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","I яна скінула з сябе ўдовінае адзеньне сваё, і засланілася вэлюмам, і, захінуўшыся, села каля ўваходу ў Энаім, які на дарозе да Тымны, бо бачыла, што Шэля вырас, а яна ня дадзена яму за жонку. ");
INSERT INTO bel_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","I ўбачыў яе Юда, і падумаў, што яна — блудніца, бо яна закрыла аблічча сваё. ");
INSERT INTO bel_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","І ён павярнуў да яе з дарогі, і сказаў: «Дазволь, прашу, увайду да цябе». Бо ён ня ведаў, што яна — нявестка ягоная. А яна сказала: «Што ты дасі мне, калі ўвойдзеш да мяне?» ");
INSERT INTO bel_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I ён сказаў: «Я прышлю табе казьляня з чарады». А яна сказала: «Ці дасі мне заруку, пакуль прышлеш яго». ");
INSERT INTO bel_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I ён сказаў: «Якую заруку даць табе?» А яна сказала: «Пячатку тваю, і пас твой, і кій твой, які ў руцэ тваёй». I ён даў ёй, і ўвайшоў да яе; і яна зачала яму. ");
INSERT INTO bel_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","І ўстала, і пайшла, і зьняла вэлюм свой з сябе, і апранулася ва ўдовіны шаты. ");
INSERT INTO bel_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","I паслаў Юда казьляня праз рукі таварыша свайго Адулямца, каб узяць заруку з рукі жанчыны, але ён не знайшоў яе. ");
INSERT INTO bel_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I пытаўся ён у людзей месца таго, кажучы: «Дзе блудніца, якая ў Энаіме пры дарозе?» А яны казалі: «Тут не было блудніцы». ");
INSERT INTO bel_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","I вярнуўся ён да Юды, і сказаў: «Я не знайшоў яе; і таксама людзі таго месца казалі: “Тут не было блудніцы”». ");
INSERT INTO bel_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","I сказаў Юда: «Няхай яна возьме заруку сабе, каб толькі не было з нас кпінаў; вось, я паслаў казьляня гэтае, а ты не знайшоў яе». ");
INSERT INTO bel_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","І сталася, што праз тры месяцы паведамілі Юдзе, кажучы: «Чужаложыла Тамар, нявестка твая, і нават яна цяжарная ад распусты». I сказаў Юда: «Вывядзіце яе, і няхай будзе спаленая». ");
INSERT INTO bel_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Яе павялі на спаленьне, а яна паслала да сьвёкра свайго, кажучы: «Ад чалавека, якога гэтыя рэчы, я цяжарная». I сказала: «Пазнавай, чыя пячатка, і пас, і кій вось гэтыя». ");
INSERT INTO bel_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","I пазнаў іх Юда, і сказаў: «Яна больш праведная, чым я, бо я ня даў яе Шэлі, сыну свайму». I больш не пазнаваў яе. ");
INSERT INTO bel_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","I сталася ў часе родаў ейных, і вось, блізьняты ў жываце ейным. ");
INSERT INTO bel_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","I сталася пры родах, і высунуў адзін ручку; і ўзяла павітуха, і завязала на ручку яму чырвоную нітку, кажучы: «Гэты выйшаў першы». ");
INSERT INTO bel_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","I сталася, што схавалася рука ягоная, і вось, выйшаў брат ягоны. I яна сказала: «Як ты прарваў перагароду?». I назвала імя ягонае Пэрэс. ");
INSERT INTO bel_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","А потым выйшаў брат ягоны, у якога на руцэ чырвоная нітка. I назвала імя ягонае Зарах. ");
INSERT INTO bel_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","А Язэп быў заведзены ў Эгіпет, і купіў яго Патыфар, урадовец фараона, начальнік варты, Эгіпцянін, з рук Ізмаэльцаў, якія завялі яго туды. ");
INSERT INTO bel_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","I быў ГОСПАД з Язэпам, і стаўся ён чалавекам, які мае посьпех, і быў у доме гаспадара свайго, Эгіпцяніна. ");
INSERT INTO bel_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","I бачыў гаспадар ягоны, што ГОСПАД з ім, і ўсяму, што ён робіць, ГОСПАД дае посьпех у руках ягоных. ");
INSERT INTO bel_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","I знайшоў Язэп ласку ў вачах ягоных, і служыў яму, і ён паставіў яго над домам сваім, і ўсё, што меў, аддаў у рукі ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","I сталася, што ад таго часу, як ён паставіў яго над домам сваім і над усім, што меў, ГОСПАД дабраславіў дом Эгіпцяніна дзеля Язэпа, і было дабраславеньне ГОСПАДА на ўсім, што меў ён у доме і ў полі. ");
INSERT INTO bel_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I аддаў ён усё, што меў, у рукі Язэпа; і ня рупіўся ні пра што, акрамя хлеба, які ён еў. А Язэп меў зграбную постаць і прывабны выгляд. ");
INSERT INTO bel_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","I сталася пасьля гэтых падзеяў, і ўзьняла жонка гаспадара ягонага вочы свае на Язэпа, і сказала: «Ляж са мною». ");
INSERT INTO bel_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Але ён адмовіўся, і сказаў жонцы гаспадара свайго: «Вось, гаспадар мой ня рупіцца пры мне ні пра што ў доме, і ўсё, што мае, аддаў у руку маю. ");
INSERT INTO bel_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Няма нікога, важнейшага за мяне, у доме гэтым; і ён не забараняе мне нічога, акрамя толькі цябе, бо ты — жонка ягоная. І як я магу ўчыніць такое вялікае злачынства і зграшыць супраць Бога». ");
INSERT INTO bel_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","I сталася, што яна зьвярталася да Язэпа штодня, а ён ня слухаў яе, каб легчы каля яе, і быць з ёю. ");
INSERT INTO bel_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","I сталася аднаго дня, і ён увайшоў у дом рабіць працу сваю, і нікога з людзей дому не было ў доме. ");
INSERT INTO bel_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","I яна схапіла яго за адзеньне ягонае, кажучы: «Ляж са мною». Але ён пакінуў адзеньне сваё ў руцэ ейнай, і ўцёк, і выйшаў навонкі. ");
INSERT INTO bel_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","I сталася, калі яна ўбачыла, што ён пакінуў адзеньне сваё ў руцэ ейнай і выбег навонкі, ");
INSERT INTO bel_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","яна паклікала людзей дому свайго, і сказала ім, кажучы: «Гляньце, прывялі да нас Гебрая, каб ён сваволіў у нас. Ён прыйшоў да мяне, каб легчы са мною, і я закрычала голасам вялікім. ");
INSERT INTO bel_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","I сталася, калі ён пачуў, што я ўзьняла голас мой і закрычала, ён пакінуў адзеньне сваё ў мяне, і ўцёк, і выйшаў навонкі». ");
INSERT INTO bel_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","I пакінула адзеньне ягонае ў сябе да прыходу гаспадара ягонага да дому свайго. ");
INSERT INTO bel_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","I гаварыла з ім гэткімі словамі, кажучы: «Прыйшоў да мяне гэты нявольнік Гебрай, якога ты прывёў да нас, каб сваволіць са мною. ");
INSERT INTO bel_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","I сталася, калі я ўзьняла голас мой і закрычала, ён пакінуў адзеньне сваё ў мяне і ўцёк навонкі». ");
INSERT INTO bel_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","I сталася, што пачуў гаспадар ягоны словы жонкі сваёй, якія яна гаварыла яму, кажучы: «Гэткую рэч учыніў мне нявольнік твой!», і ўзгарэўся гнеў ягоны. ");
INSERT INTO bel_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","I ўзяў гаспадар Язэпаў яго, і кінуў яго ў вязьніцу, месца, дзе былі ўвязьнены вязьні валадара. І быў ён там у вязьніцы. ");
INSERT INTO bel_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","I быў ГОСПАД з Язэпам, і зьявіў да яго міласэрнасьць, і даў ласку яму ў вачах начальніка вязьніцы. ");
INSERT INTO bel_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","I аддаў начальнік вязьніцы ў руку Язэпу ўсіх вязьняў, якія былі ў вязьніцы, і ўсё, што там рабілі, ён рабіў. ");
INSERT INTO bel_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Не пільнаваў начальнік вязьніцы нічога, што было ў руках ягоных, бо ГОСПАД быў з ім, і ў тым, што ён рабіў, ГОСПАД даваў посьпех. ");
INSERT INTO bel_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","І сталася пасьля гэтых падзеяў, саграшылі чашнік валадара Эгіпецкага і пекар перад панам сваім, перад валадаром Эгіпецкім. ");
INSERT INTO bel_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","I загневаўся фараон на двух урадоўцаў сваіх, на начальніка чашнікаў і на начальніка пекараў, ");
INSERT INTO bel_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","і аддаў іх пад варту ў дом начальніка варты, у вязьніцу, месца, дзе Язэп быў вязьнем. ");
INSERT INTO bel_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","I прызначыў начальнік варты Язэпа да іх, і ён служыў ім. I былі яны шмат дзён пад вартаю. ");
INSERT INTO bel_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","I сьнілі ў адну ноч яны абодва кожны свой сон, кожны сьніў са значэньнем сон свой, чашнік і пекар, якія былі ў валадара Эгіпецкага і якія былі ўвязьненыя ў вязьніцы. ");
INSERT INTO bel_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","I прыйшоў да іх Язэп раніцай, і ўбачыў іх, і вось, яны засмучаныя. ");
INSERT INTO bel_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I спытаўся ён у ўрадоўцаў фараона, што былі пад вартаю з ім у доме пана ягонага, кажучы: «Чаму абліччы вашыя сёньня маюць благі выгляд?» ");
INSERT INTO bel_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I сказалі яны яму: «Сьнілі мы сон, а растлумачыць яго няма каму». I сказаў ім Язэп: «Ці ж ня ў Бога тлумачэньне сну? Распавядзіце мне». ");
INSERT INTO bel_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","I распавёў начальнік чашнікаў сон свой Язэпу, і сказаў яму: «У сьне маім, вось, вінаградная лаза перада мною. ");
INSERT INTO bel_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","I на вінаграднай лазе — тры галінкі. І яна, калі вырасла, расквітнела квеценьню сваёй, насьпелі гронкі вінаграду ейнага. ");
INSERT INTO bel_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I келіх фараона ў руцэ маёй, і я ўзяў вінаградныя ягады, і выціснуў іх у келіх фараона, і даў келіх у рукі фараона». ");
INSERT INTO bel_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","I сказаў яму Язэп: «Гэта тлумачэньне сну: тры галінкі — гэта тры дні. ");
INSERT INTO bel_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Праз тры дні падыме фараон галаву тваю, і верне цябе на месца тваё, і ты будзеш даваць келіх фараону ў руку ягоную паводле ранейшага звычаю, калі ты быў чашнікам ягоным. ");
INSERT INTO bel_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Толькі ўзгадай пра мяне, калі будзе табе добра; і зьяві мне міласэрнасьць, узгадай пра мяне перад фараонам, і вывядзі мяне з гэтага дому, ");
INSERT INTO bel_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","бо я крадзьма ўкрадзены з зямлі Гебраяў, і таксама тут нічога не зрабіў, за што б пасадзіць мяне ў вязьніцу». ");
INSERT INTO bel_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","I ўбачыў начальнік пекараў, што ён добра патлумачыў, і сказаў Язэпу: «Я таксама сьніў, і вось, тры кашы плеценыя на галаве маёй. ");
INSERT INTO bel_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I ў кашы верхнім — усялякая ежа фараона, вырабленая пекарам; і птушкі елі яе з каша на галаве маёй». ");
INSERT INTO bel_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","I адказаў Язэп, і сказаў: «Гэта тлумачэньне сну: тры кашы — гэта тры дні. ");
INSERT INTO bel_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Праз тры дні здыме фараон галаву з цябе, і павесіць цябе на дрэве; і птушкі будуць есьці цела тваё з цябе». ");
INSERT INTO bel_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","І праз тры дні быў дзень нараджэньня фараона, і ён справіў бяседу для ўсіх слугаў сваіх, і падняў галаву начальніка чашнікаў і галаву начальніка пекараў сярод слугаў сваіх. ");
INSERT INTO bel_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","I вярнуў фараон начальніка чашнікаў на ягонае месца чашніка, і ён даў келіх у руку фараону, ");
INSERT INTO bel_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","а начальніка пекараў павесіў, як патлумачыў ім Язэп. ");
INSERT INTO bel_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","I не ўзгадаў начальнік чашнікаў пра Язэпа, і забыўся на яго. ");
INSERT INTO bel_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","I сталася, што мінула два гады часу, і сьніў фараон, і вось, ён стаіць каля ракі. ");
INSERT INTO bel_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","I вось, з ракі выходзяць сем кароваў прыгожых з выгляду і сытых целам; і пасьвіліся на поплаве. ");
INSERT INTO bel_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","I вось, сем іншых кароваў выходзяць за імі з ракі, брыдкіх з выгляду і худых целам, і сталі каля тых кароваў на беразе ракі. ");
INSERT INTO bel_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","I пажэрлі каровы брыдкія з выгляду і худыя целам сем кароваў прыгожых з выгляду і сытых. I прачнуўся фараон. ");
INSERT INTO bel_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I ён заснуў, і сьніў другі раз, і вось, сем каласоў вырасьлі на адной сьцябліне, здаровых і добрых. ");
INSERT INTO bel_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","I вось, сем каласоў пустых і высушаных усходнім ветрам вырастаюць пасьля іх. ");
INSERT INTO bel_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","I праглынулі каласы пустыя сем каласоў здаровых і поўных. I прачнуўся фараон, і вось, гэта сон. ");
INSERT INTO bel_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","I сталася раніцаю, што быў устрывожаны дух ягоны, і ён паслаў, і паклікаў усіх варажбітоў Эгіпту і ўсіх мудрацоў яго, і распавёў ім фараон сон свой; і не было нікога, хто б патлумачыў яго фараону. ");
INSERT INTO bel_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","I прамовіў начальнік чашнікаў фараону, кажучы: «Грахі мае ўзгадваю я сёньня. ");
INSERT INTO bel_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Фараон загневаўся на слугаў сваіх і аддаў мяне пад нагляд у дом начальніка варты, мяне і начальніка пекараў. ");
INSERT INTO bel_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","I мы сьнілі сон у адну ноч, я і ён, кожны са значэньнем сон свой мы сьнілі. ");
INSERT INTO bel_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","I быў там з намі юнак Гебрай, нявольнік начальніка варты. I мы распавялі яму, і ён патлумачыў нам сны нашыя, кожнаму сон ягоны патлумачыў. ");
INSERT INTO bel_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","I сталася, што як ён патлумачыў нам, так і адбылося: мяне вярнулі на становішча маё, а таго павесілі». ");
INSERT INTO bel_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","I паслаў фараон, і паклікаў Язэпа; і хутка вывялі яго з лёху. I ён пагаліўся, і зьмяніў адзеньне сваё, і прыйшоў да фараона. ");
INSERT INTO bel_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","I сказаў фараон Язэпу: «Я сьніў сон, і няма нікога, хто б патлумачыў яго. І я чуў, што пра цябе кажуць, што ты, выслухаўшы сон, тлумачыш яго». ");
INSERT INTO bel_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","I адказаў Язэп фараону, кажучы: «Ня я, але Бог можа казаць на супакой фараону». ");
INSERT INTO bel_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","I сказаў фараон Язэпу: «У сьне маім, вось, стаю я на беразе ракі. ");
INSERT INTO bel_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","I вось, з ракі выходзяць сем кароваў сытых целам і прыгожых з выгляду, і пасьвіліся яны на поплаве. ");
INSERT INTO bel_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","I вось, сем кароваў іншых выходзяць пасьля іх, някшталтныя, вельмі брыдкія з выгляду і худыя целам, я ня бачыў падобных, што да брыдкасьці, у-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","I пажэрлі каровы худыя і брыдкія першых сем кароваў сытых. ");
INSERT INTO bel_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","I ўвайшлі яны ў чэравы іхныя, і не было пазнаць, што яны ўвайшлі ў чэравы іхныя, і выгляд іхні быў паганы, як і спачатку. I я прачнуўся. ");
INSERT INTO bel_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I ўбачыў я ў сьне, і вось, сем каласоў вырастаюць на адной сьцябліне, поўных і добрых. ");
INSERT INTO bel_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","I вось, сем каласоў ценькіх, пустых і высушаных усходнім ветрам растуць пасьля іх. ");
INSERT INTO bel_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I праглынулі каласы пустыя сем каласоў добрых. Я расказаў гэта варажбітам, але няма нікога, хто б патлумачыў гэта мне». ");
INSERT INTO bel_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","I сказаў Язэп фараону: «Сон фараона — адзін ён. Што Бог зробіць, Ён паведаміў фараону. ");
INSERT INTO bel_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Сем кароваў добрых — гэта сем гадоў; і сем тых каласоў добрых — гэта сем гадоў. Гэта сон адзін. ");
INSERT INTO bel_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","I сем кароваў худых і брыдкіх, якія выйшлі пасьля іх — гэта сем гадоў; і сем каласоў пустых, высушаных усходнім ветрам — гэта будзе сем гадоў голаду. ");
INSERT INTO bel_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Гэта слова, якое я прамовіў да фараона. Што Бог зробіць, Ён паказаў фараону. ");
INSERT INTO bel_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Вось, прыйдзе сем гадоў вялікага дабрабыту ў-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","I настануць пасьля іх сем гадоў голаду; і забудзецца ўвесь той дабрабыт у зямлі Эгіпецкай, і вынішчыць голад гэтую зямлю. ");
INSERT INTO bel_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","I ня будзе відно дабрабыту ў зямлі з прычыны голаду, які будзе пасьля, бо будзе ён вельмі цяжкі. ");
INSERT INTO bel_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","А тое, што паўтарыўся гэты сон фараону двойчы, азначае, што вызначана гэта справа ў Бога і неўзабаве Бог зьдзейсьніць гэта. ");
INSERT INTO bel_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","I цяпер няхай прыгледзіць фараон мужа кемлівага і мудрага, і няхай паставіць яго над зямлёю Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Няхай так зробіць фараон, і прызначыць наглядчыкаў над краем, і зьбірае пятую частку ўраджаю з зямлі Эгіпецкай у сем гадоў дабрабыту. ");
INSERT INTO bel_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","I зьбяруць усякае харчаваньне падчас гэтых добрых гадоў, якія надыйдуць, і няхай зьбіраюць збожжа пад руку фараона на харчаваньне ў гарадах, і няхай захоўваюць. ");
INSERT INTO bel_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","I будзе гэтае харчаваньне на запас зямлі на сем гадоў голаду». ");
INSERT INTO bel_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","I добрае было гэтае слова ў вачах фараона і ў вачах усіх слугаў ягоных. ");
INSERT INTO bel_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","I сказаў фараон слугам сваім: «Ці знойдзецца такі чалавек, як гэты, які мае ў сабе Духа Божага?» ");
INSERT INTO bel_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","I сказаў фараон Язэпу: «Пасьля таго, як Бог паведаміў табе ўсё гэта, няма нікога такога кемлівага і мудрага, як ты. ");
INSERT INTO bel_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ты будзеш над домам маім, і вуснаў тваіх будзе слухацца ўвесь народ мой; толькі пасадам я буду перавышаць цябе». ");
INSERT INTO bel_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","I сказаў фараон Язэпу: «Глядзі, я паставіў цябе над усёй зямлёю Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","I зьняў фараон пярсьцёнак свой з рукі сваёй, і даў яго на руку Язэпу; і апрануў яго ў адзеньне з вісону, і ўзлажыў ланцуг залаты на шыю ягоную; ");
INSERT INTO bel_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","і загадаў вазіць яго на другой калясьніцы сваёй, і крычалі перад ім: «Кланяйцеся!» I паставіў яго над усёй зямлёю Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","I сказаў фараон Язэпу: «Я — фараон, але без цябе ніхто не падыме рукі сваёй і нагі сваёй у-ва ўсёй зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","I назваў фараон імя Язэпава Цафнат-Панэах, і даў яму за жонку Аснат, дачку Паты-Пэра, сьвятара з Ону. I ўзьняўся Язэп над зямлёю Эгіпецкаю. ");
INSERT INTO bel_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Язэпу было трыццаць гадоў, калі ён стаў перад фараонам, валадаром Эгіпту. I выйшаў Язэп ад аблічча фараона, і прайшоў па ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","I выдала зямля ў сем гадоў дабрабыту поўныя жмені збожжа. ");
INSERT INTO bel_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","I зьбіраў ён усякае харчаваньне тых сямі гадоў, якія былі ў зямлі Эгіпецкай, і разьмясьціў харчаваньне ў гарадах; харчаваньне з вакалічных палёў гораду ён складаў у кожным з іх. ");
INSERT INTO bel_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","I назьбіраў Язэп збожжа, як пяску марскога, так шмат, ажно перасталі лічыць, бо не было яму ліку. ");
INSERT INTO bel_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","I ў Язэпа нарадзіліся два сыны перш, чым прыйшоў год голаду, якіх нарадзіла яму Аснат, дачка Паты-Пэра, сьвятара з Ону. ");
INSERT INTO bel_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","I назваў Язэп імя першароднага Манаса, бо казаў: «Даў мне Бог забыцца ўсе цяжкасьці мае і ўвесь дом бацькі майго». ");
INSERT INTO bel_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","А імя другога назваў Эфраім, бо казаў: «Распладзіў мяне Бог у зямлі нядолі маёй». ");
INSERT INTO bel_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","I мінулі сем гадоў дабрабыту, які быў у зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","I пачалі прыходзіць сем гадоў голаду, як сказаў Язэп. I быў голад у-ва ўсіх краінах, але ў-ва ўсёй зямлі Эгіпецкай быў хлеб. ");
INSERT INTO bel_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","I галадавала ўся зямля Эгіпецкая, і крычаў народ да фараона пра хлеб, і сказаў фараон усім Эгіпцянам: «Ідзіце да Язэпа і рабіце, што ён вам скажа». ");
INSERT INTO bel_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","I быў голад на ўсім абліччы зямлі, і адчыніў Язэп усе гумны, якія былі ў іх, і прадаваў Эгіпцянам. I павялічваўся голад у зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","I з усёй зямлі прыходзілі ў Эгіпет купляць у Язэпа, бо павялічваўся голад па ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","I ўбачыў Якуб, што ёсьць збожжа ў Эгіпце, і сказаў Якуб сынам сваім: «Што вы паглядаеце адзін на аднаго?» ");
INSERT INTO bel_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I сказаў: «Вось, я чуў, што ёсьць збожжа ў Эгіпце. Зыйдзіце туды і купіце для нас там, і будзем жыць, і не памром». ");
INSERT INTO bel_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","I зыйшлі дзесяць братоў Язэпавых купіць збожжа ў Эгіпце. ");
INSERT INTO bel_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","А Бэн’яміна, брата Язэпа, не паслаў Якуб з братамі ягонымі, бо сказаў: «Каб не здарылася з ім няшчасьце». ");
INSERT INTO bel_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","I прыйшлі сыны Ізраіля купляць збожжа разам з тымі, што прыйшлі туды, бо быў голад у зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","А Язэп кіраваў у той зямлі, ён продаў збожжа ўсім людзям зямлі. I прыйшлі браты Язэпа, і пакланіліся яму тварам да зямлі. ");
INSERT INTO bel_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","I ўбачыў Язэп братоў сваіх, і пазнаў іх, і ўдаваў, што ён чужы ім, і размаўляў з імі сувора, і сказаў ім: «Адкуль вы прыйшлі?» I яны сказалі: «З зямлі Ханаан, каб купіць харчоў». ");
INSERT INTO bel_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","I пазнаў Язэп братоў сваіх, а яны не пазналі яго. ");
INSERT INTO bel_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","I ўзгадаў Язэп сны, якія ён сьніў пра іх, і сказаў ім: «Шпегі вы, вы прыйшлі, каб агледзець голасьць зямлі гэтай». ");
INSERT INTO bel_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","I сказалі яны яму: «Не, пане. Слугі твае прыйшлі купіць харчаваньне. ");
INSERT INTO bel_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Усе мы — сыны аднаго чалавека, шчырыя мы. Не былі слугі твае шпегамі». ");
INSERT INTO bel_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Але ён сказаў ім: «Не, бо вы прыйшлі агледзець голасьць зямлі гэтай». ");
INSERT INTO bel_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","А яны сказалі: «Дванаццаць слугаў тваіх, браты мы. Мы — сыны аднаго чалавека ў зямлі Ханаан, і вось, наймалодшы сёньня з бацькам нашым, а аднаго няма». ");
INSERT INTO bel_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","I сказаў ім Язэп: «Гэта я сказаў вам, кажучы: “Вы — шпегі”. ");
INSERT INTO bel_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Таму будзеце выспрабаваныя. Няхай жыве фараон! Вы ня выйдзеце адгэтуль, пакуль ня прыйдзе сюды наймалодшы брат ваш. ");
INSERT INTO bel_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Пашліце аднаго з вас, і няхай ён возьме брата вашага; а вы будзеце ўвязьненыя. I выспрабуюцца словы вашыя, ці праўда ваша. А калі не, няхай жыве фараон! Вы — шпегі». ");
INSERT INTO bel_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","I ўзяў іх пад варту на тры дні. ");
INSERT INTO bel_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","I сказаў ім Язэп на трэці дзень: «Гэта зрабіце, і будзеце жывыя. Бо я баюся Бога. ");
INSERT INTO bel_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Калі вы — шчырыя, адзін брат ваш застанецца ўвязьнены ў доме, у якім вы пад вартаю, а вы ідзіце, занясіце збожжа дзеля заспакаеньня голаду дамоў вашых. ");
INSERT INTO bel_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","I брата вашага малодшага прывядзіце да мяне, і спраўдзяцца словы вашыя, і вы не памраце». I яны зрабілі так. ");
INSERT INTO bel_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","I казалі яны кожны брату свайму: «Сапраўды, мы вінаватыя адносна брата нашага, што мы бачылі гора душы ягонай, як ён маліў нас, але мы не паслухалі, і за тое прыйшла на нас бяда гэтая». ");
INSERT INTO bel_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","I адказаў ім Рубэн, кажучы: «Ці не казаў я вам, кажучы: “Не грашыце супраць хлопца”, а вы не паслухалі; і вось, за кроў ягоную помсьціцца». ");
INSERT INTO bel_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","І яны ня ведалі, што Язэп разумее, бо паміж імі быў перакладчык. ");
INSERT INTO bel_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I Язэп адвярнуўся ад іх, і плакаў. I павярнуўся да іх, і размаўляў з імі, і ўзяў з іх Сымона, і зьвязаў яго перад вачыма іхнімі. ");
INSERT INTO bel_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","I загадаў Язэп, каб напоўнілі мяхі іхнія збожжам, і вярнулі срэбра іхняе кожнаму ў мех ягоны, і далі ім ежу на дарогу. I зрабілі ім гэтак. ");
INSERT INTO bel_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","І яны ўсклалі збожжа сваё на аслоў сваіх, і пайшлі адтуль. ");
INSERT INTO bel_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","I разьвязаў адзін з іх мех свой, каб пакарміць асла свайго на папасе; і ўбачыў срэбра сваё, і вось, яно ў адтуліне мяха ягонага. ");
INSERT INTO bel_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I сказаў ён братам сваім: «Вярнулі срэбра маё, і вось, яно ў мяху маім». I ўстрывожылася сэрца іхняе, і яны задрыжэлі, кажучы адзін аднаму: «Што гэта зрабіў нам Бог?» ");
INSERT INTO bel_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","I прыйшлі яны да Якуба, бацькі свайго, у зямлю Ханаан, і распавялі яму ўсё, што здарылася з імі, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Гаварыў гэты чалавек, пан зямлі той, з намі сувора, і меў нас за шпегаў у зямлі той. ");
INSERT INTO bel_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","I сказалі мы яму: “Шчырыя мы, мы не былі шпегамі. ");
INSERT INTO bel_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Нас дванаццаць братоў, сыны бацькі нашага; аднаго няма, а малодшы сёньня з бацькам нашым у зямлі Ханаан”. ");
INSERT INTO bel_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","I сказаў гэты чалавек, пан зямлі той: “З гэтага я даведаюся, што вы шчырыя: аднаго брата вашага пакіньце ў мяне, а вы вазьміце збожжа дзеля заспакаеньня голаду дамоў вашых і ідзіце. ");
INSERT INTO bel_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","I прывядзіце да мяне малодшага брата вашага; і я даведаюся, што вы ня шпегі, але шчырыя вы. Брата вашага аддам вам, і вы будзеце падарожнічаць у зямлі гэтай”». ");
INSERT INTO bel_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","I сталася, калі яны высыпалі мяхі свае, вось, у кожнага капшук са срэбрам ягоным у мяху ягоным. I ўбачылі яны капшукі са срэбрам сваім, яны і бацька іхні, і спалохаліся. ");
INSERT INTO bel_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","I сказаў ім Якуб, бацька іхні: «Вы пазбавілі мяне дзяцей. Язэпа няма; і Сымона няма, і Бэн’яміна хочаце ўзяць. Усё гэта гора на мяне прыйшло!» ");
INSERT INTO bel_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","I сказаў Рубэн бацьку свайму: «Забі двух сыноў маіх, калі я не прывяду яго да цябе. Аддай яго ў рукі мае, і я вярну яго табе». ");
INSERT INTO bel_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","А ён сказаў: «Ня зыйдзе сын мой з вамі; бо брат ягоны памёр, і ён адзін застаўся! Калі здарыцца з ім няшчасьце ў дарозе, у якую вы пойдзеце, вы зьвядзеце сівізну маю са смуткам у апраметную». ");
INSERT INTO bel_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","А голад цяжэў на зямлі. ");
INSERT INTO bel_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","I сталася, што яны скончылі есьці збожжа, якое прывезьлі з Эгіпту, і сказаў ім бацька іхні: «Вярніцеся, купіце нам трохі харчаваньня». ");
INSERT INTO bel_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","I сказаў яму Юда, кажучы: «Той чалавек сувора папярэдзіў нас, кажучы: “Ня ўбачыце аблічча майго, калі ня будзе брат ваш з вамі”. ");
INSERT INTO bel_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Калі згаджаешся паслаць брата нашага з намі, зыйдзем і купім табе харчаваньне. ");
INSERT INTO bel_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","А калі не пашлеш, ня зыйдзем, бо той чалавек сказаў нам: “Ня ўбачыце аблічча майго, калі ня будзе брат ваш з вамі”». ");
INSERT INTO bel_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","I сказаў Ізраіль: «Навошта вы зрабілі мне ліха, сказаўшы таму чалавеку, што ў вас ёсьць яшчэ брат?» ");
INSERT INTO bel_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","І сказалі яны: «Пытаючыся, распытаваў гэты чалавек пра нас, пра сям’ю нашую, кажучы: “Ці яшчэ бацька ваш жывы? Ці ёсьць у вас брат?” І мы адказвалі яму паводле гэтых словаў. Ці маглі мы ведаць, што ён скажа: “Прывядзіце брата вашага”». ");
INSERT INTO bel_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","I сказаў Юда Ізраілю, бацьку свайму: «Пашлі гэтага хлопца са мною; і мы ўстанем, і пойдзем, і будзем жыць, і не памром, і мы, і ты, і дзеці нашыя. ");
INSERT INTO bel_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Я паручаюся за яго, з рукі маёй будзеш вымагаць яго. Калі я не прывяду яго да цябе і не пастаўлю перад абліччам тваім, буду я грэшны перад табою на ўсё жыцьцё. ");
INSERT INTO bel_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Бо калі б мы не затрымліваліся, дык цяпер мы б ужо вярнуліся двойчы». ");
INSERT INTO bel_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","I сказаў ім Ізраіль, бацька іхні: «Калі так, тады зрабіце вось што: вазьміце пладоў зямлі ў мяхі вашыя і занясіце гэтаму чалавеку дар, трохі бальзаму, і трохі мёду, і пахошчы, і ладан, і фісташкі, і мігдалы. ");
INSERT INTO bel_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","I срэбра падвойна вазьміце ў рукі вашыя. І срэбра, якое назад паложана ў адтуліны мяхоў вашых, вярніце рукамі сваімі; можа, гэта памылка. ");
INSERT INTO bel_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","I брата вашага бярыце, і, устаўшы, вярніцеся да чалавека таго. ");
INSERT INTO bel_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","А Бог Усемагутны няхай дасьць вам ласку перад абліччам таго чалавека, і ён выпусьціць вам другога брата вашага і Бэн’яміна. А я, калі маю пазбыцца дзяцей, пазбудуся». ");
INSERT INTO bel_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","I ўзялі мужы гэтыя дары свае, і срэбра падвойнае ўзялі ў рукі свае, і Бэн’яміна, і ўсталі, і зыйшлі ў Эгіпет, і сталі перад Язэпам. ");
INSERT INTO bel_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","I ўбачыў Язэп з імі Бэн’яміна, і сказаў загадчыку дому свайго: «Увядзі гэтых мужоў у дом, і зарэж, што можна зарэзаць, і прыгатуй ежу, бо са мною будуць есьці мужы гэтыя апоўдні». ");
INSERT INTO bel_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","I зрабіў той чалавек так, як сказаў Язэп, і ўвёў той чалавек мужоў гэтых у дом Язэпа. ");
INSERT INTO bel_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","I баяліся мужы гэтыя, што прывялі іх у дом Язэпа, і казалі: «Гэта з прычыны срэбра, вернутага ўперад у мяхі нашыя, прывялі нас, каб накінуцца на нас, і напасьці на нас, і ўзяць у няволю нас і аслоў нашых». ");
INSERT INTO bel_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","I наблізіліся яны да чалавека, які быў над домам Язэпа, і гаварылі з ім каля ўваходу ў дом, ");
INSERT INTO bel_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","і сказалі: «Паслухай, пане мой! Прыходзячы, прыходзілі мы сюды ўперад купіць харчаваньне. ");
INSERT INTO bel_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","I сталася, калі мы прыйшлі на папас, і разьвязалі мяхі свае, і вось, срэбра кожнага ў адтуліне мяха ягонага, срэбра нашае паводле вагі сваёй, і мы вяртаем яго рукамі сваімі. ");
INSERT INTO bel_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","I срэбра іншае мы прынесьлі ў руках сваіх, каб купіць харчаваньне. Мы ня ведаем, хто паклаў срэбра нашае ў мяхі нашыя». ");
INSERT INTO bel_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","А ён сказаў: «Супакой вам! Ня бойцеся! Бог ваш і Бог бацькі вашага даў вам скарб у мяхах вашых. Вашае срэбра прыйшло да мяне ў свой час». I вывеў да іх Сымона. ");
INSERT INTO bel_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","I ўвёў чалавек той мужоў гэтых у дом Язэпа, і даў вады, і яны абмылі ногі свае; і даў корм аслам іхнім. ");
INSERT INTO bel_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","I яны прыгатавалі дары да прыходу Язэпа апоўдні, бо чулі, што там яны будуць есьці хлеб. ");
INSERT INTO bel_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","I прыйшоў Язэп у дом, і яны прынесьлі яму ў дом дары, якія ў руках іхніх, і пакланіліся яму да зямлі. ");
INSERT INTO bel_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","І ён спытаўся ў іх пра супакой, і сказаў: «Ці добра маецца бацька ваш стары, пра якога вы распавядалі? Ці ён яшчэ жыве?» ");
INSERT INTO bel_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","I сказалі яны: «Мае супакой слуга твой, бацька наш, ён яшчэ жыве». I схіліліся, і, пакланяючыся, пакланіліся. ");
INSERT INTO bel_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","I ўзьняў ён вочы свае, і ўбачыў Бэн’яміна, брата свайго, сына маці сваёй, і сказаў: «Ці гэта брат ваш наймалодшы, пра якога вы распавядалі мне?» I сказаў: «Бог няхай зьмілуецца над табою, сыне мой». ");
INSERT INTO bel_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","I хутка выйшаў Язэп, бо ўзгарэліся пачуцьці ягоныя да брата ягонага, і ён шукаў месца, каб плакаць; і ўвайшоў у пакой, і плакаў там. ");
INSERT INTO bel_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I абмыў ён аблічча сваё, і выйшаў, і апанаваў сябе, і сказаў: «Пастаўце хлеб». ");
INSERT INTO bel_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","I паставілі яму асобна, і ім асобна, і Эгіпцянам, якія елі з ім, асобна, бо Эгіпцяне ня могуць есьці з Гебраямі хлеб, бо гэта агіда для Эгіпту. ");
INSERT INTO bel_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I селі яны перад ім, першародны паводле першароднасьці сваёй, і наймалодшы паводле маладосьці сваёй, і зьдзіўляліся мужы гэтыя, гледзячы адзін на аднаго. ");
INSERT INTO bel_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","I падалі стравы ад яго аблічча для іх. I была страва для Бэн’яміна большая, чым стравы кожнага з іх у пяць разоў. I яны пілі, і ўпіліся з ім. ");
INSERT INTO bel_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","I загадаў Язэп загадчыку дому свайго, кажучы: «Напоўні мяхі гэтых мужоў харчамі, колькі яны могуць несьці, і палажы срэбра кожнага ў адтуліну мяха ягонага. ");
INSERT INTO bel_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","А келіх мой, келіх срэбны, палажы ў адтуліну мяха наймалодшага, і срэбра за збожжа ягонае». I ён зрабіў паводле слова Язэпа, якое той сказаў. ");
INSERT INTO bel_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Раніцаю разьвіднела, і гэтых мужоў выправілі, іх і аслоў іхніх. ");
INSERT INTO bel_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Яны выйшлі з гораду, не адыйшлі далёка, і Язэп сказаў загадчыку дому свайго: «Устань, ганіся за тымі людзьмі, і дагоніш іх, і скажаш ім: “Чаму вы адплацілі ліхам за дабро? ");
INSERT INTO bel_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ці ж ня гэта той келіх, з якога п’е пан мой, і прадказваючы, прадказвае на ім? Ліха вы ўчынілі, гэтак зрабіўшы”». ");
INSERT INTO bel_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","І ён дагнаў іх, і прамовіў ім гэтыя словы. ");
INSERT INTO bel_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","А яны сказалі: «Навошта пан мой кажа такія словы? Далёкія слугі твае, каб учыніць гэткія рэчы. ");
INSERT INTO bel_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Тое срэбра, якое мы знайшлі ў адтулінах мяхоў сваіх, мы вярнулі табе з зямлі Ханаан. Як жа мелі мы красьці з дому гаспадара твайго срэбра альбо золата? ");
INSERT INTO bel_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","У каго са слугаў тваіх будзе знойдзена гэта, той няхай памрэ, а мы таксама станем нявольнікамі пана майго». ");
INSERT INTO bel_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","І ён сказаў: «Дык цяпер няхай будзе паводле словаў вашых. У каго будзе знойдзена гэта, той стане мне нявольнікам, а вы будзеце нявінныя». ");
INSERT INTO bel_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","І яны пасьпяшаліся, і зьнялі кожны мех свой на зямлю, і разьвязалі кожны мех свой. ");
INSERT INTO bel_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","А ён шукаў, пачаўшы ад найстарэйшага і скончыўшы наймалодшым; і знайшоў келіх у мяху Бэн’яміна. ");
INSERT INTO bel_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","I разарвалі яны адзеньні свае, і ўсклалі мяхі кожны на асла свайго, і вярнуліся ў горад. ");
INSERT INTO bel_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","I прыйшлі Юда і браты ягоныя ў дом Язэпа, а ён яшчэ быў там. І яны ўпалі перад абліччам яго на зямлю. ");
INSERT INTO bel_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","I сказаў ім Язэп: «Што за ўчынак гэта вы ўчынілі? Ці ж вы ня ведалі, што, прадказваючы, прадказвае такі чалавек, як я?» ");
INSERT INTO bel_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","I сказаў Юда: «Што нам сказаць, пане мой? Што нам гаварыць і як нам апраўдвацца? Бог знайшоў правіну слугаў тваіх. Вось, мы — нявольнікі пана майго, і мы, і той, у чыіх руках быў знойдзены келіх». ");
INSERT INTO bel_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","I сказаў Язэп: «Далёка ад мяне, каб я ўчыніў гэта. Той чалавек, у руках якога знойдзены келіх, ён будзе нявольнікам маім, а вы ўзыходзьце ў супакоі да бацькі свайго». ");
INSERT INTO bel_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","I наблізіўся да яго Юда, і сказаў: «Паслухай, пане мой, няхай скажа, прашу, слуга твой слова ў вушы пана свайго, і няхай не распальваецца гнеў твой на слугу твайго, бо ты — як сам фараон. ");
INSERT INTO bel_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Пан мой пытаўся ў слугаў сваіх, кажучы: “Ці ёсьць у вас бацька альбо брат?” ");
INSERT INTO bel_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","І мы сказалі пану нашаму: “Ёсьць у нас бацька стары і дзіця старасьці ягонае малое, а брат ягоны памёр, і ён адзін застаўся па маці сваёй, і бацька ягоны любіць яго”. ");
INSERT INTO bel_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","I ты сказаў слугам тваім: “Прывядзіце яго да мяне, і я зьвярну вока маё на яго”. ");
INSERT INTO bel_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","І мы сказалі пану майму: “Ня можа хлопец пакінуць бацьку свайго; і калі ён пакіне бацьку свайго, дык той памрэ”. ");
INSERT INTO bel_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","I сказаў ты слугам тваім: “Калі ня прыйдзе брат ваш наймалодшы з вамі, не дазволю вам больш бачыць аблічча маё”. ");
INSERT INTO bel_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","I сталася, што мы ўзыйшлі да слугі твайго, бацькі майго, і пераказалі яму словы пана майго. ");
INSERT INTO bel_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","I сказаў бацька наш: “Вярніцеся, купіце нам трохі харчаваньня”. ");
INSERT INTO bel_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","I мы сказалі: “Ня можам зыйсьці. Калі будзе з намі брат наш наймалодшы, мы зыйдзем, бо ня зможам убачыць аблічча таго чалавека, калі брата нашага наймалодшага ня будзе з намі”. ");
INSERT INTO bel_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I сказаў нам слуга твой, бацька наш: “Вы ведаеце, што двух нарадзіла мне жонка мая. ");
INSERT INTO bel_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","I адыйшоў адзін ад мяне, і я сказаў: \"Напэўна, ён разьдзёрты дзікім зьверам\", і я ня бачыў яго дагэтуль. ");
INSERT INTO bel_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","І возьмеце таксама гэтага ад аблічча майго, і здарыцца з ім няшчасьце, і заведзіцё вы сівізну маю ў горы ў апраметную”. ");
INSERT INTO bel_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","І цяпер, як я прыйду да слугі твайго, бацькі майго, і хлопца няма з намі, а душа ягоная прывязана да душы ягонай. ");
INSERT INTO bel_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","I станецца, што ён убачыць, што няма хлопца, і памрэ, і зьвядуць слугі твае сівізну слугі твайго, бацькі нашага, са смуткам у апраметную. ");
INSERT INTO bel_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Бо слуга твой паручыўся за хлопца перад бацькам сваім, кажучы: “Калі не прывяду яго да цябе, буду грэшны перад бацькам сваім на ўсе дні”. ");
INSERT INTO bel_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","I цяпер, прашу, няхай застанецца слуга твой замест хлопца нявольнікам пана майго, а хлопец няхай пойдзе з братамі сваімі. ");
INSERT INTO bel_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Бо як я прыйду да бацькі майго, а хлопца ня будзе са мною? Няхай ня ўбачу я ліха, якое спаткае бацька мой». ");
INSERT INTO bel_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","I ня мог Язэп больш вытрываць пры ўсіх, што стаялі каля яго, і закрычаў: «Вывядзіце ўсіх людзей ад мяне!» I не застаўся ніхто пры ім, калі Язэп адкрыўся братам сваім. ");
INSERT INTO bel_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I голасна заплакаў Язэп, і пачулі Эгіпцяне, і пачуў дом фараона. ");
INSERT INTO bel_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I сказаў Язэп братам сваім: «Я — Язэп! Ці бацька мой яшчэ жывы?» I не маглі браты ягоныя адказаць яму, бо яны трымцелі перад абліччам ягоным. ");
INSERT INTO bel_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","I сказаў Язэп братам сваім: «Наблізьцеся, калі ласка, да мяне». Яны наблізіліся. І ён сказаў: «Я — Язэп, брат ваш, якога вы прадалі ў Эгіпет. ");
INSERT INTO bel_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Але цяпер не сумуйце, і няхай ня будзе жалю ў вачах вашых, што вы прадалі мяне сюды, бо дзеля захаваньня жыцьця паслаў мяне Бог перад вамі. ");
INSERT INTO bel_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Бо вось, два гады голаду на зямлі, і яшчэ пяць гадоў, у якія нельга будзе ані араць, ані жаць. ");
INSERT INTO bel_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","I паслаў мяне Бог перад вамі, каб пакінуць з вас рэшту на зямлі і захаваць жыцьцё вашае збаўленьнем вялікім. ");
INSERT INTO bel_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","I цяпер ня вы паслалі мяне сюды, але Бог, і Ён паставіў мяне як бацьку фараону і як пана ў-ва ўсім доме ягоным, і я кірую ў-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Пасьпяшайцеся, і ўзыйдзіце да бацькі майго, і скажыце яму: “Гэтак сказаў сын твой, Язэп: \"Бог паставіў мяне панам над усім Эгіптам. Прыйдзі да мяне, не марудзь. ");
INSERT INTO bel_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","I будзеш жыць у зямлі Гашэн; і будзеш блізка каля мяне ты, і сыны твае, і сыны сыноў тваіх, і авечкі твае, і валы твае, і ўсё, што тваё. ");
INSERT INTO bel_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I я буду карміць цябе там, бо яшчэ пяць гадоў голаду, каб не згалеў ты, і дом твой, і ўсё, што тваё\"”. ");
INSERT INTO bel_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","I вось, бачаць вочы вашыя, і вочы брата майго Бэн’яміна, што вусны мае прамаўляюць да вас. ");
INSERT INTO bel_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","I распавядзіце бацьку майму пра ўсю славу маю ў Эгіпце і пра ўсё, што вы бачылі; і пасьпяшайцеся, і прывядзіце бацьку майго сюды». ");
INSERT INTO bel_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","I ўпаў ён на шыю Бэн’яміну, брату свайму, і плакаў; і Бэн’ямін плакаў на шыі ягонай. ");
INSERT INTO bel_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","I цалаваў ён усіх братоў сваіх, і плакаў над імі. I потым размаўлялі з ім браты ягоныя. ");
INSERT INTO bel_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","I пачулі вестку ў доме фараона, якая казала: «Прыйшлі браты Язэпа». І добра гэта было ў вачах фараона і ў вачах слугаў ягоных. ");
INSERT INTO bel_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","I сказаў фараон Язэпу: «Скажы братам сваім: “Зрабіце гэтак: абладуйце збожжам жывёлу сваю, і ідзіце, і прыйдзіце ў зямлю Ханаан, ");
INSERT INTO bel_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","і вазьміце бацьку свайго, і сем’і свае, і прыйдзіце да мяне; і я дам вам добрую зямлю Эгіпту, і вы будзеце есьці тлустасьць зямлі гэтай”. ");
INSERT INTO bel_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","А ты загадаеш: “Зрабіце гэтак: вазьміце сабе з зямлі Эгіпецкай вазы для дзяцей вашых і жонак вашых, і вазьміце бацьку вашага, і прыходзьце. ");
INSERT INTO bel_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","I вочы вашыя няхай не шкадуюць прыладаў вашых, бо даброцьці ўсёй зямлі Эгіпецкай — для вас”». ");
INSERT INTO bel_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I зрабілі так сыны Ізраіля. I даў ім Язэп вазы паводле загаду фараона, і даў ім пасілкі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","І ўсім, кожнаму з іх, ён даў зьмену адзеньня, а Бэн’яміну даў трыста срэбнікаў і пяць зьменаў адзеньня. ");
INSERT INTO bel_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","А для бацькі свайго паслаў дзесяць аслоў, абладаваных даброцьцямі з Эгіпту, і дзесяць асьліцаў, абладаваных збожжам і хлебам, і ежаю для бацькі свайго на дарогу. ");
INSERT INTO bel_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","I адаслаў ён братоў сваіх, і яны пайшлі. I сказаў ім: «Не сварыцеся ў дарозе». ");
INSERT INTO bel_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","I ўзыйшлі яны з Эгіпту, і прыйшлі ў зямлю Ханаан да Якуба, бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I паведамілі яму, кажучы: «Яшчэ жывы Язэп, і ён кіруе ў-ва ўсёй зямлі Эгіпецкай». I не ўзварухнулася сэрца ягонае, бо ён не паверыў ім. ");
INSERT INTO bel_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","I прамовілі яму ўсе словы Язэпа, якія ён прамовіў ім, і ўбачыў ён вазы, якія прыслаў Язэп, каб прывезьці яго, і ажыў дух Якуба, бацькі іхняга. ");
INSERT INTO bel_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","I сказаў Ізраіль: «Досыць! Яшчэ жыве Язэп, сын мой! Пайду і ўбачу яго, перш, чым памру». ");
INSERT INTO bel_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","I вырушыў Ізраіль у дарогу, і ўсё, што ў яго, і прыйшоў у Бээр-Шэву, і ахвяраваў ахвяры Богу бацькі свайго Ісаака. ");
INSERT INTO bel_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","I сказаў Бог Ізраілю ў відзежы начным, і сказаў: «Якубе! Якубе!» А ён сказаў: «Вось я». ");
INSERT INTO bel_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I сказаў: «Я — Бог, Бог бацькі твайго! Ня бойся зыйсьці ў Эгіпет, бо Я зраблю цябе там народам вялікім. ");
INSERT INTO bel_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Я зыйду з табою ў Эгіпет, і Я, выводзячы, таксама выведу цябе адтуль. I Язэп паложыць руку сваю на вочы твае». ");
INSERT INTO bel_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","I падняўся Якуб з Бээр-Шэвы; і павезьлі сыны Ізраіля Якуба, бацьку свайго, і дзяцей сваіх, і жонак сваіх на вазах, якія паслаў фараон, каб прывезьці яго. ");
INSERT INTO bel_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I ўзялі яны статак свой і маёмасьць сваю, якую прыдбалі ў зямлі Ханаан, і прыйшлі ў Эгіпет Якуб і ўсё насеньне ягонае з ім. ");
INSERT INTO bel_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Сыноў сваіх і сыноў сыноў сваіх з сабою, і дочак сваіх і дочак сыноў сваіх, і ўсё насеньне сваё прывёў ён з сабою ў Эгіпет. ");
INSERT INTO bel_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","I вось імёны сыноў Ізраіля, што прыйшлі ў Эгіпет: Якуб і сыны ягоныя. Першародны Якуба Рубэн. ");
INSERT INTO bel_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","I сыны Рубэна: Ханох і Пальлю, і Хецрон, і Кармі. ");
INSERT INTO bel_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","I сыны Сымона: Емуэль і Ямін, і Агад, і Якін, і Цахар, і Шаўль, сын Хананейкі. ");
INSERT INTO bel_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","I сыны Левія: Гершон, Кегат і Мэрары. ");
INSERT INTO bel_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","А сыны Юды: Ер, і Анан, і Шэля, і Пэрэс, і Зарах. І памерлі Ер і Анан у зямлі Ханаан. I былі сыны Пэрэса: Хецрон і Хамуль. ");
INSERT INTO bel_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","I сыны Ісахара: Тола і Пува, і Ёў, і Шымрон. ");
INSERT INTO bel_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","I сыны Завулёна: Сэрэд, і Элён, і Яхлеэль. ");
INSERT INTO bel_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Гэта сыны Леі, якіх яна нарадзіла Якубу ў Падан-Араме, і яшчэ Дзіну, дачку ягоную. Усіх душаў сыноў ягоных і дочак ягоных — трыццаць тры. ");
INSERT INTO bel_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","I сыны Гада: Цыф’ён і Хагі, Шуні і Эцбон, Еры і Ароды, і Ар’элі. ");
INSERT INTO bel_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","А сыны Асэра: Імна, і Ішва, і Ішві і Бэрыя, і Сэрах, сястра іхняя. А сыны Бэрыі: Хевер і Малхіэль. ");
INSERT INTO bel_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Гэта сыны Зільпы, якую даў Ляван Леі, дачцэ сваёй. Яна нарадзіла іх Якубу шаснаццаць душаў. ");
INSERT INTO bel_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Сыны Рахелі, жонкі Якуба: Язэп і Бэн’ямін. ");
INSERT INTO bel_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","I нарадзіліся ў Язэпа ў зямлі Эгіпецкай Манаса і Эфраім, якіх нарадзіла яму Аснат, дачка Паты-Пэра, сьвятара з Ону. ");
INSERT INTO bel_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","А сыны Бэн’яміна: Бэла і Бэкер, і Ашбэль, Гера і Нааман, Эхі і Рош, Мупім і Хупім, і Ард. ");
INSERT INTO bel_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Гэта сыны Рахелі, якіх яна нарадзіла Якубу, усіх душаў — чатырнаццаць. ");
INSERT INTO bel_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","А сыны Дана: Хушым. ");
INSERT INTO bel_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Сыны Нэфталі: Яхцээль і Гуні, і Ецэр, і Шылем. ");
INSERT INTO bel_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Гэта сыны Більгі, якую даў Ляван дачцэ сваёй Рахелі. Яна нарадзіла іх Якубу, усіх душаў — сем. ");
INSERT INTO bel_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Усяго душаў, што прыйшлі з Якубам у Эгіпет, якія выйшлі са сьцёгнаў ягоных, акрамя жонак сыноў Якуба, усіх душаў — шэсьцьдзясят шэсьць. ");
INSERT INTO bel_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","А сыноў Язэпа, якія нарадзіліся яму ў Эгіпце, — дзьве душы. Усяго душаў з дому Якуба прыйшло ў Эгіпет семдзясят. ");
INSERT INTO bel_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","I паслаў ён Юду перад сабою да Язэпа, каб той скіраваў аблічча яго на Гашэн. I прыйшлі ў зямлю Гашэн. ");
INSERT INTO bel_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","I запрог Язэп калясьніцу сваю, і ўзыйшоў насустрач Ізраілю, бацьку свайму, у Гашэн, і паказаўся яму, і ўпаў на шыю ягоную, і плакаў на шыі ягонай зноў. ");
INSERT INTO bel_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","I сказаў Ізраіль Язэпу: «Магу паміраць я гэтым разам, як убачыў аблічча тваё, бо ты яшчэ жывы». ");
INSERT INTO bel_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","I сказаў Язэп братам сваім і дому бацькі свайго: «Я пайду і паведамлю фараону, і скажу яму: “Браты мае і дом бацькі майго, якія былі ў зямлі Ханаан, прыйшлі да мяне. ");
INSERT INTO bel_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Гэтыя людзі — пастухі авечак, бо яны гадавалі статак. І авечак сваіх, і валоў сваіх, і ўсё, што ў іх, яны прывялі”. ");
INSERT INTO bel_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","I станецца, калі фараон пакліча вас і скажа: “Які занятак ваш?”, ");
INSERT INTO bel_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","вы скажаце: “Гадавалі статак слугі твае з маленства нашага і дагэтуль, і мы, і бацькі нашыя”, каб вы пасяліліся ў зямлі Гашэн, бо брыдзяцца Эгіпцяне кожным пастухом авечак». ");
INSERT INTO bel_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","І прыйшоў Язэп, і паведаміў фараону, і сказаў: «Бацька мой, і браты мае, і авечкі іхнія, і валы іхнія, і ўсё, што ў іх, прыйшлі з зямлі Ханаан, і вось, яны ў зямлі Гашэн». ");
INSERT INTO bel_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I спаміж братоў сваіх ён узяў пяць чалавек, і паставіў іх перад фараонам. ");
INSERT INTO bel_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","I сказаў фараон братам ягоным: «Які ваш занятак?» І яны сказалі фараону: «Пастухі авечак слугі твае, і мы, і бацькі нашыя». ");
INSERT INTO bel_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","I сказалі яны фараону: «Вандраваць у зямлі гэтай мы прыйшлі, бо няма пашы для авечак слугаў тваіх, бо вялікі голад у зямлі Ханаан. І цяпер, просім, дазволь пасяліцца слугам тваім у зямлі Гашэн». ");
INSERT INTO bel_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","I сказаў фараон Язэпу, кажучы: «Бацька твой і браты твае прыйшлі да цябе. ");
INSERT INTO bel_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Зямля Эгіпецкая перад абліччам тваім. У найлепшым месцы зямлі пасялі бацьку свайго і братоў сваіх. Няхай жывуць яны ў зямлі Гашэн. I калі ведаеш, што ёсьць паміж імі здольныя людзі, пастаў іх даглядчыкамі над статкамі, якія ў мяне». ");
INSERT INTO bel_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","I прывёў Язэп Якуба, бацьку свайго, і паставіў яго перад абліччам фараона. І дабраславіў Якуб фараона. ");
INSERT INTO bel_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","I сказаў фараон Якубу: «Колькі дзён маюць гады жыцьця твайго?» ");
INSERT INTO bel_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","I сказаў Якуб фараону: «Дзён гадоў вандраваньня майго — сто трыццаць гадоў. Кароткія і ліхія былі дні гадоў жыцьця майго, і не дасягнулі яны да дзён гадоў жыцьця бацькоў маіх у днях вандраваньня іхняга». ");
INSERT INTO bel_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","I дабраславіў Якуб фараона, і выйшаў ад аблічча фараона. ");
INSERT INTO bel_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","I пасяліў Язэп бацьку свайго і братоў сваіх, і даў ім уласнасьць у зямлі Эгіпецкай, у найлепшай частцы зямлі той, у зямлі Рамсэс, як загадаў фараон. ");
INSERT INTO bel_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","I жывіў Язэп бацьку свайго і братоў сваіх, і ўвесь дом бацькі свайго хлебам адпаведна ліку дзяцей. ");
INSERT INTO bel_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","А хлеба не было на ўсёй зямлі, бо голад быў вельмі цяжкі, і была вычарпаная зямля Эгіпецкая і зямля Ханаанская з прычыны голаду. ");
INSERT INTO bel_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","I сабраў Язэп усё срэбра, якое знайшлося ў зямлі Эгіпецкай і ў зямлі Ханаанскай, за збожжа, якое куплялі, і прынёс Язэп срэбра ў дом фараона. ");
INSERT INTO bel_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","I скончылася срэбра ў зямлі Эгіпецкай і ў зямлі Ханаанскай. I прыйшоў увесь Эгіпет да Язэпа, кажучы: «Дай нам хлеба! Навошта мы маем памерці перад табою, бо скончылася срэбра». ");
INSERT INTO bel_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","І сказаў Язэп: «Дайце статак ваш, і я буду даваць вам хлеб за статак ваш, калі скончылася срэбра». ");
INSERT INTO bel_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","I яны прыводзілі статак свой да Язэпа, і даваў ім Язэп хлеб за коней, і за статкі авечак, і за статкі валоў, і за аслоў; і жывіў іх хлебам за ўвесь статак іхні ў той год. ");
INSERT INTO bel_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","I скончыўся той год; і прыйшлі да яго ў наступным годзе, і сказалі яму: «Ня ўтоім ад пана нашага, што скончылася срэбра, і статкі скаціны нашай — у пана нашага. Не засталося нічога ў нас перад абліччам пана нашага, акрамя целаў нашых і грунтоў нашых. ");
INSERT INTO bel_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Навошта маем памерці перад вачыма тваімі, і мы, і грунты нашыя? Купі нас і грунты нашыя за хлеб; і будзем мы і грунты нашыя нявольнікамі фараона, а ты дай нам зерня, і мы будзем жыць, і не памрэм, і грунты не спусьцеюць». ");
INSERT INTO bel_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","I набыў Язэп усе грунты ў Эгіпце для фараона, бо прадалі Эгіпцяне кожны поле сваё, бо прыціснуў іх голад. I зямля стала фараонавай. ");
INSERT INTO bel_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","А народ ён перавёў у гарады ад аднаго канца мяжы Эгіпту аж да другога канца яго. ");
INSERT INTO bel_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Толькі грунты сьвятароў не набыў, бо частка сьвятароў была ад фараона, і яны жывіліся са сваёй часткі, якую даў ім фараон; таму яны і не прадалі грунты свае. ");
INSERT INTO bel_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","I сказаў Язэп народу: «Вось, я купіў сёньня вас і грунты вашыя для фараона. Вось вам зерне, і засявайце зямлю. ");
INSERT INTO bel_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","І калі будзе жніво, давайце пятую частку фараону, а чатыры часткі застануцца вам засеяць поле і на харчаваньне вам і тым, хто ў дамах вашых, і на харчаваньне дзецям вашым». ");
INSERT INTO bel_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","А яны сказалі: «Ты захаваў нам жыцьцё. Няхай мы знойдзем ласку ў вачах пана нашага, і будзем слугамі фараону». ");
INSERT INTO bel_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I паставіў гэта Язэп як пастанову, якая дагэтуль у зямлі Эгіпецкай, што для фараона пятая частка ўраджаю, толькі грунты сьвятароў належаць ім самім, ня сталі яны фараонавымі. ");
INSERT INTO bel_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","I жыў Ізраіль у зямлі Эгіпецкай, у зямлі Гашэн, і мелі ўласнасьць у ёй, і пладзіліся, і памножыліся вельмі. ");
INSERT INTO bel_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","I жыў Якуб у зямлі Эгіпецкай сямнаццаць гадоў; і было дзён Якуба, гадоў жыцьця ягонага — сто сорак сем гадоў. ");
INSERT INTO bel_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","I наблізіліся дні Ізраілю, каб памерці, і паклікаў ён сына свайго Язэпа, і сказаў яму: «Калі я знайшоў ласку ў вачах тваіх, прашу, палажы руку сваю пад сьцягно маё і зрабі мне міласэрнасьць і праўду, што не пахаваеш мяне ў Эгіпце. ");
INSERT INTO bel_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Але буду я ляжаць з бацькамі сваімі. Вынясі мяне з Эгіпту і пахавай мяне ў магіле іхняй». I той сказаў: «Зраблю паводле слова твайго». ");
INSERT INTO bel_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","I сказаў Якуб: «Прысягні мне». I прысягнуў яму. I схіліўся Ізраіль на верх ложка. ");
INSERT INTO bel_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","I сталася пасьля падзеяў гэтых, і сказалі Язэпу: «Вось, бацька твой хворы». I ён узяў двух сыноў сваіх з сабою, Манасу і Эфраіма. ");
INSERT INTO bel_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","I паведамілі Якубу, і сказалі: «Вось, сын твой Язэп прыйшоў да цябе». I сабраў сілы Ізраіль, і сеў на ложку. ");
INSERT INTO bel_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","I сказаў Якуб Язэпу: «Бог Усемагутны зьявіўся мне ў Люзе, у зямлі Ханаан, і дабраславіў мяне, ");
INSERT INTO bel_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","і сказаў мне: “Вось, Я зраблю цябе плодным, і памножу цябе, і дам табе быць супольнасьцю народаў, і дам зямлю гэтую насеньню твайму пасьля цябе на ўласнасьць вечную”. ");
INSERT INTO bel_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","I цяпер два сыны твае, што нарадзіліся табе ў зямлі Эгіпецкай, да прыходу майго да цябе ў Эгіпет, яны — мае; Эфраім і Манаса, як Рубэн і Сымон, будуць мае. ");
INSERT INTO bel_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","А нашчадкі твае, якіх ты нарадзіў пасьля іх, будуць твае. Паводле імёнаў братоў сваіх будуць яны называцца ў спадчыне сваёй. ");
INSERT INTO bel_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","А ў мяне, калі я прыйшоў з Падану, памерла ў мяне Рахель у зямлі Ханаан, у дарозе, калі яшчэ заставаўся кавалак зямлі, каб дайсьці да Эфраты, і я пахаваў яе там, пры дарозе ў Эфрату, гэта значыць у Бэтлеем». ");
INSERT INTO bel_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","I ўбачыў Ізраіль сыноў Язэпа, і сказаў: «Хто яны?» ");
INSERT INTO bel_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","I сказаў Язэп бацьку свайму: «Яны — сыны мае, якіх Бог даў мне тут». I сказаў Якуб: «Вазьмі, прашу, іх да мяне, і я дабраслаўлю іх». ");
INSERT INTO bel_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","А вочы Ізраіля сталі цяжкія ад старасьці, ня мог ён бачыць. I наблізіў іх да яго, і ён пацалаваў іх, і абняў іх. ");
INSERT INTO bel_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I сказаў Ізраіль Язэпу: «Я не спадзяваўся ўбачыць аблічча тваё, і вось, Бог даў мне ўбачыць насеньне тваё». ");
INSERT INTO bel_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","I адвёў іх Язэп ад каленяў ягоных, і пакланіўся яму абліччам сваім да зямлі. ");
INSERT INTO bel_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","I ўзяў Язэп іх абодвух, Эфраіма правіцай сваёю, леваруч Ізраіля, а Манасу — лявіцай сваёю, праваруч Ізраіля, і наблізіўся да яго. ");
INSERT INTO bel_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","I выцягнуў Ізраіль правіцу сваю, і палажыў на галаву Эфраіма, а ён быў малодшы, а лявіцу сваю — на галаву Манасы, і скрыжаваў рукі свае, бо Манаса быў першародны. ");
INSERT INTO bel_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","I дабраславіў Язэпа, і сказаў: «Бог, перад абліччам Якога хадзілі бацькі мае, Абрагам і Ісаак, Бог, Які пасьвіў мяне ад моманту, як я існую, аж да гэтага дня, ");
INSERT INTO bel_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","анёл, што выбаўляе мяне ад усякага ліха, няхай дабраславіць юнакоў гэтых; і няхай яны будуць названыя імем маім і імем бацькоў маіх, Абрагама і Ісаака, і няхай разрастуцца яны ў мноства сярод зямлі». ");
INSERT INTO bel_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","I ўбачыў Язэп, што бацька ягоны палажыў правую руку сваю на галаву Эфраіма, і было гэта ліхім у вачах ягоных. I падхапіў ён руку бацькі свайго, каб пералажыць яе з галавы Эфраіма на галаву Манасы. ");
INSERT INTO bel_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","I сказаў Язэп бацьку свайму: «Ня гэтак, ойча мой, бо гэта першародны. Палажы правіцу тваю на галаву ягоную». ");
INSERT INTO bel_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","I запярэчыў бацька ягоны, і сказаў: «Ведаю, сыне мой, ведаю, таксама ён будзе народам, і таксама ён будзе вялікі, але брат ягоны малодшы будзе большы за яго, і насеньне ягонае будзе поўняю народаў». ");
INSERT INTO bel_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I дабраславіў іх у той дзень, кажучы: «Табою будзе дабраслаўляць Ізраіль, кажучы: “Няхай зробіць табе Бог, як Эфраіму і Манасе”». I паставіў Эфраіма перад Манасам. ");
INSERT INTO bel_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","I сказаў Ізраіль Язэпу: «Вось, я паміраю. I Бог будзе з вамі, і верне вас у зямлю бацькоў вашых. ");
INSERT INTO bel_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","I я даў табе на адну частку больш за братоў тваіх, тую, якую я ўзяў з рукі Амарэя мячом маім і лукам маім». ");
INSERT INTO bel_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","I паклікаў Якуб сыноў сваіх, і сказаў: «Зьбярыцеся, і я паведамлю вам, што спаткае вас у пазьнейшыя дні. ");
INSERT INTO bel_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Зыйдзіцеся і паслухайце, сыны Якуба, паслухайце Ізраіля, бацьку свайго. ");
INSERT INTO bel_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рубэн, першародны мой, ты — моц мая і пачатак сілы маёй, перавышаеш усіх годнасьцю і перавышаеш магутнасьцю. ");
INSERT INTO bel_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ты пеніўся, як вада, і ня будзеш узвышаны, бо ты ўзыйшоў на ложак бацькі свайго; тады ты зьняважыў пасьцель маю, узыйшоўшы на яе. ");
INSERT INTO bel_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Сымон і Левій, браты, зброя іхняя — прылада гвалту. ");
INSERT INTO bel_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","У нараду іхнюю ня ўвойдзе душа мая, і да супольнасьці іхняй не далучыцца слава мая, бо ў гневе сваім яны забілі мужа і ў свавольстве сваім скалечылі вала. ");
INSERT INTO bel_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Пракляты гнеў іхні, бо моцны, і лютасьць іхняя, бо заядлая. Падзялю іх у Якубе і расьцярушу іх у Ізраілі. ");
INSERT INTO bel_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Юда, цябе выслаўляць будуць браты твае. Рука твая — на карку ворагаў тваіх; паклоняцца табе сыны бацькі твайго. ");
INSERT INTO bel_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Юда — малады леў; ад здабычы, сыне мой, ты падымаешся. Прыхіліўся, лёг, як леў і як ільвіца, хто падыме яго? ");
INSERT INTO bel_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ня будзе адняты скіпетр ад Юды і заканадаўца — ад ног ягоных, аж пакуль ня прыйдзе Той, чыё яно, і Яму — паслухмянасць народаў. ");
INSERT INTO bel_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ён прывяжа да вінаграднай лазы асла свайго і да парастка выборнага вінаграду — асьлянятка асьліцы сваёй. Ён абмые ў віне шаты свае і ў крыві вінаграду — адзеньне сваё. ");
INSERT INTO bel_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Вочы ягоныя чырванейшыя за віно, а зубы — бялейшыя за малако. ");
INSERT INTO bel_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулён на беразе мора будзе жыць і каля прыстані караблёў, і межы ягоныя — да Сідону. ");
INSERT INTO bel_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ісахар — асёл касьцісты, што ляжыць паміж загарадаў. ");
INSERT INTO bel_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","I ўбачыў ён супачынак, што добры, і зямлю, што прыемная, і нахіліў плечы свае насіць цяжары і стаў слугою паднявольным. ");
INSERT INTO bel_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан будзе судзіць народ свой, як адзін з родаў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Будзе Дан зьмеем на дарозе, гадзюкай на сьцежцы, якая кусае пяты каня, і валіцца вершнік ягоны назад. ");
INSERT INTO bel_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","На збаўленьне Тваё спадзяюся, ГОСПАДЗЕ! ");
INSERT INTO bel_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гад — войскі будуць перамагаць яго, але ён пераможа пяты іхнія. ");
INSERT INTO bel_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Пра Асэра — тлусты хлеб ягоны, і ён будзе даваць прысмакі валадарскія. ");
INSERT INTO bel_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нэфталі — ланя, выпушчаная на свабоду, што дае прыгожыя словы. ");
INSERT INTO bel_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Галіна плодная Язэп, галіна плодная над крыніцаю, галіны ягоныя пнуцца па муры. ");
INSERT INTO bel_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","І засмучалі яго, і стралялі ў яго, і ненавідзелі яго стральцы. ");
INSERT INTO bel_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","I застаўся моцным лук ягоны, і ўмацаваліся рамёны рук ягоных — ад рук Магутнага Якубавага, адтуль Пастыр, Скала Ізраіля; ");
INSERT INTO bel_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ад Бога бацькі твайго, і Ён дапаможа табе, і ад Усемагутнага, і Ён дабраславіць цябе дабраславеньнямі неба згары і дабраславеньнямі бяздоньня, што ляжыць унізе, дабраславеньнямі грудзей і ўлоньня. ");
INSERT INTO bel_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Дабраславеньні бацькі твайго перавышаюць дабраславеньні бацькоў маіх, яны аж да вяршыняў узгоркаў адвечных. Няхай будуць яны на галаве Язэпа і на цемені выбранага між братамі сваімі. ");
INSERT INTO bel_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Бэн’ямін — воўк драпежны, раніцаю будзе есьці здабычу і ўвечары будзе дзяліць прыбытак». ");
INSERT INTO bel_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Усіх гэтых родаў Ізраіля — дванаццаць, і гэта тое, што прамаўляў ім бацька іхні; і дабраславіў іх, і кожнага паводле дабраславеньня ягонага дабраславіў. ");
INSERT INTO bel_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","I загадаў ён ім, і сказаў ім: «Я буду далучаны да народу майго. Пахавайце мяне каля бацькоў маіх, у пячоры, якая на полі Эфрона Хета, ");
INSERT INTO bel_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","у пячоры, што на полі Махпэля, якое насупраць Мамрэ ў зямлі Ханаан, якую купіў Абрагам разам з полем Эфрона Хета на ўласнасьць для пахаваньня. ");
INSERT INTO bel_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Там пахавалі Абрагама і Сару, жонку ягоную, там пахавалі Ісаака і Рэбэку, жонку ягоную; і там я пахаваў Лею. ");
INSERT INTO bel_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Набытыя гэтае поле і пячора, якая на ім, у сыноў Хета». ");
INSERT INTO bel_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","I скончыў Якуб загадваць сынам сваім, і палажыў ногі свае на ложак, і сканаў, і быў далучаны да народу свайго. ");
INSERT INTO bel_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","I ўпаў Язэп на аблічча бацькі свайго, і плакаў над ім, і цалаваў яго. ");
INSERT INTO bel_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","I загадаў Язэп слугам сваім лекарам забальзамаваць бацьку ягонага; і забальзамавалі лекары Ізраіля. ");
INSERT INTO bel_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I прайшло сорак дзён, бо столькі вымагаецца дзён на бальзамаваньне. I плакалі па ім Эгіпцяне семдзясят дзён. ");
INSERT INTO bel_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","I мінулі дні плачу па ім, і прамовіў Язэп дому фараона, кажучы: «Калі я знайшоў ласку ў вачах вашых, скажыце, калі ласка, у вушы фараону, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Бацька мой узяў з мяне прысягу, кажучы: \"Вось, я паміраю. У магіле маёй, якую я выкапаў у зямлі Ханаан, там пахавай мяне\". I цяпер я ўзыйду, і пахаваю бацьку свайго, і вярнуся”». ");
INSERT INTO bel_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","I сказаў фараон: «Узыйдзі і пахавай бацьку твайго, як ён узяў у цябе прысягу». ");
INSERT INTO bel_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","I ўзыйшоў Язэп хаваць бацьку свайго; і ўзыйшлі з ім усе слугі фараона, старшыні дому ягонага, і ўсе старшыні зямлі Эгіпецкай, ");
INSERT INTO bel_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","і ўвесь дом Язэпа, і браты ягоныя, і дом бацькі ягонага. Толькі дзяцей сваіх, і авечак сваіх, і валоў сваіх пакінулі ў зямлі Гашэн. ");
INSERT INTO bel_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","I ўзыйшлі з ім таксама калясьніцы і вершнікі, і быў табар вельмі вялікі. ");
INSERT INTO bel_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","I прыйшлі яны ў Гарэн-Гаатад на другім баку Ярдану, і галасілі там галашэньнем вялікім і вельмі жалосным; і ўчыніў Язэп жалобу па бацьку сваім сем дзён. ");
INSERT INTO bel_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","I ўбачылі жыхары зямлі той, Хананейцы, жалобу ў Гарэн-Гаатадзе, і сказалі: «Гэта вялікая жалоба ў Эгіпцянаў!» Дзеля гэтага назвалі імя яго: Абэль-Міцраім, які на другім баку Ярдану. ");
INSERT INTO bel_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","I зрабілі сыны Якуба з ім так, як ён загадаў ім. ");
INSERT INTO bel_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","I занесьлі яго сыны ягоныя ў зямлю Ханаан, і пахавалі яго ў пячоры на полі Махпэля, якую купіў Абрагам разам з полем на ўласнасьць на пахаваньне ў Эфрона Хета, насупраць Мамрэ. ");
INSERT INTO bel_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","I вярнуўся Язэп пасьля пахаваньня ім бацькі свайго ў Эгіпет, ён і браты ягоныя, і ўсе, што ўзыходзілі з ім хаваць бацьку ягонага. ");
INSERT INTO bel_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","I бачылі браты Язэпа, што памёр бацька іхні, і сказалі: «А што, калі зьненавідзіць нас Язэп і адплочваючы, адплоціць нам за ўсё тое ліха, якое мы яму зрабілі?» ");
INSERT INTO bel_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","I загадалі яны сказаць Язэпу, кажучы: «Бацька твой загадаў перад сьмерцю сваёю, кажучы: ");
INSERT INTO bel_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Гэтак скажыце Язэпу: \"Даруй, прашу, правіну братоў тваіх і грэх іхні, бо ліха зрабілі яны табе\". I цяпер даруй, прашу, слугам Бога бацькі твайго”». I плакаў Язэп дзеля гэтых словаў да яго. ");
INSERT INTO bel_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","I прыйшлі таксама браты ягоныя, і ўпалі перад абліччам ягоным, і сказалі: «Вось, мы — слугі для цябе». ");
INSERT INTO bel_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","I сказаў ім Язэп: «Ня бойцеся! Хіба я замест Бога? ");
INSERT INTO bel_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","I вы надумалі ліха супраць мяне, але Бог надумаў гэта на дабро, каб зрабіць так, як ёсьць сёньня, каб захаваць жыцьцё народу вялікаму. ");
INSERT INTO bel_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","І цяпер ня бойцеся, я буду карміць вас і дзяцей вашых». I суцяшаў іх, і прамаўляў да сэрцаў іхніх. ");
INSERT INTO bel_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","I пасяліўся Язэп у Эгіпце, ён і дом бацькі ягонага. І жыў Язэп сто дзесяць гадоў. ");
INSERT INTO bel_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","I бачыў Язэп у Эфраіма сыноў да трэцяга пакаленьня, таксама сыны Махіра, сына Манасы, нарадзіліся на каленях Язэпа. ");
INSERT INTO bel_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","I сказаў Язэп братам сваім: «Я паміраю, але Бог, наведваючы, наведае вас і выведзе вас з зямлі гэтай у зямлю, пра якую прысягаў Абрагаму, Ісааку і Якубу». ");
INSERT INTO bel_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","I ўзяў Язэп прысягу ў сыноў Ізраіля, кажучы: «Бог, наведваючы, наведае вас, і вы вынясіце косткі мае адгэтуль». ");
INSERT INTO bel_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","I памёр Язэп, маючы сто дзесяць гадоў. I забальзамавалі яго, і палажылі ў дамавіну ў Эгіпце.");
INSERT INTO bel_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1"," І вось імёны сыноў Ізраіля, якія прыйшлі ў Эгіпет з Якубам, увайшлі кожны з домам сваім: ");
INSERT INTO bel_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рубэн, Сымон, Левій і Юда, ");
INSERT INTO bel_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ісахар, Завулён і Бэн’ямін, ");
INSERT INTO bel_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан і Нэфталі, Гад і Асэр. ");
INSERT INTO bel_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","I ўсіх душаў, якія выйшлі з паясьніцы Якуба, было семдзясят, а Язэп быў у Эгіпце. ");
INSERT INTO bel_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","I памёр Язэп, і ўсе браты ягоныя, і ўсё пакаленьне тое. ");
INSERT INTO bel_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","І сыны Ізраіля пладзіліся, і нараджаліся, і памнажаліся, і ставаліся вельмі-вельмі магутнымі, і напоўнілася імі зямля. ");
INSERT INTO bel_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","I паўстаў новы валадар у Эгіпце, які ня ведаў Язэпа. ");
INSERT INTO bel_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I сказаў ён народу свайму: «Вось, народ сыноў Ізраіля больш шматлікі і мацнейшы за нас. ");
INSERT INTO bel_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Давайце мудра ўчынім адносна яго, каб ён не памнажаўся; бо як здарыцца вайна, ён злучыцца з ворагамі нашымі, і будзе ваяваць з намі, і выйдзе з зямлі гэтай». ");
INSERT INTO bel_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","І ён паставіў над ім наглядчыкаў працаў, каб уціскалі яго цяжкімі працамі. I пабудаваў Ізраіль на склады фараону гарады Пітом і Рамсэс. ");
INSERT INTO bel_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","I колькі ўціскалі яго, ён памнажаўся і пашыраўся. I Эгіпцяне трывожыліся з прычыны сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","I зьняволілі Эгіпцяне сыноў Ізраіля, і ўціскалі, ");
INSERT INTO bel_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","і рабілі горкім жыцьцё іхняе цяжкаю працаю з глінаю і цэглаю, і ўсякаю працаю ў полі, і ўсякімі працамі зьневалялі іх і ўціскалі. ");
INSERT INTO bel_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","I сказаў валадар Эгіпту павітухам гебрайскім, якіх адной імя было Шыфра, а імя другой — Пуа, ");
INSERT INTO bel_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","і сказаў: «Калі будзеце пры радзінах у Гебраек, глядзіце на радзільны ложак: калі будзе сын, дык забіце яго, а калі дачка, няхай застанецца жывая». ");
INSERT INTO bel_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Але павітухі баяліся Бога, і не рабілі так, як загадаў ім валадар Эгіпту, і пакідалі хлопцаў жывымі. ");
INSERT INTO bel_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","I паклікаў валадар Эгіпту павітухаў, і сказаў ім: «Чаму вы робіце гэта, чаму пакідаеце хлопцаў жывымі?» ");
INSERT INTO bel_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","І сказалі павітухі фараону: «Жанчыны гебрайскія не такія, як эгіпецкія; яны здаровыя, і яны нараджаюць перш, чым прыйдзе да іх павітуха». ");
INSERT INTO bel_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","I спагадаў Бог павітухам; і народ памнажаўся і вельмі мацнеў. ");
INSERT INTO bel_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","I сталася, за тое, што павітухі баяліся Бога, Ён збудаваў ім дамы. ");
INSERT INTO bel_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","I загадаў фараон усяму народу свайму, кажучы: «Кожнага сына, які народзіцца ў Гебраяў, кідайце ў раку; а кожную дачку пакідайце жывую». ");
INSERT INTO bel_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","I пайшоў чалавек з дому Левія, і ўзяў дачку з дому Левія. ");
INSERT INTO bel_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","I зачала тая жанчына, і нарадзіла сына, і бачыла яго, што ён прыгожы, і хавала яго тры месяцы. ");
INSERT INTO bel_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","І не магла даўжэй хаваць яго, і ўзяла кошык з трысьнёгу, і абмазала яго асфальтам і смалою; і палажыла ў яго хлопчыка, і паставіла ў чароце каля берагу ракі. ");
INSERT INTO bel_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","I стаяла сястра ягоная воддаль, каб ведаць, што станецца з ім. ");
INSERT INTO bel_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","I зыйшла дачка фараона мыцца да ракі, а служкі ейныя хадзілі каля ракі. I яна ўбачыла кошык сярод чароту, і паслала служку сваю ўзяць яго. ");
INSERT INTO bel_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","I адчыніла, і ўбачыла яго, гэтае дзіцятка; і вось, хлопчык плача; і пашкадавала яго, і сказала: «Ён з дзяцей Гебрайскіх». ");
INSERT INTO bel_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","I сказала сястра ягоная дачцэ фараона: «Ці не пайсьці мне і ці не паклікаць да цябе жанчыну карміцельку з Гебраек, каб яна выкарміла гэтае дзіцятка». ");
INSERT INTO bel_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","I сказала ёй дачка фараона: «Ідзі». I пайшла дзяўчынка, і паклікала маці дзіцяці. ");
INSERT INTO bel_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","I сказала ёй дачка фараона: «Вазьмі сабе дзіцятка гэтае і выкармі яго для мяне; і я дам табе плату тваю». І ўзяла жанчына дзіцятка, і выкарміла яго. ");
INSERT INTO bel_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","I вырасла дзіця, і яна прывяла яго да дачкі фараона, і ён стаў у яе за сына, і назвала імя ягонае — Майсей, і казала яна: «Бо з вады я выцягнула яго». ");
INSERT INTO bel_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","I сталася ў тыя дні, што вырас Майсей, і выйшаў да братоў сваіх, і ўбачыў цяжкія працы іхнія; і ўбачыў, што Эгіпцянін б’е аднаго Гебрая з братоў ягоных. ");
INSERT INTO bel_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I павярнуўся ён туды і сюды, і ўбачыў, што нікога няма, і забіў Эгіпцяніна, і схаваў яго ў пяску. ");
INSERT INTO bel_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","I выйшаў ён на наступны дзень, і вось, два Гебраі вадзяцца. I сказаў ён таму, які крыўдзіў: «Навошта ты б’еш бліжняга свайго?» ");
INSERT INTO bel_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","А той сказаў: «Хто паставіў цябе начальнікам і судзьдзём над намі? Ці ня хочаш ты забіць мяне, як забіў Эгіпцяніна?» I спалохаўся Майсей, і сказаў: «Напэўна, сталася вядомым гэта». ");
INSERT INTO bel_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","I пачуў фараон пра гэтую справу, і шукаў забіць Майсея. I ўцёк Майсей ад фараона, і жыў у зямлі Мадыян. І вось сеў ён каля студні. ");
INSERT INTO bel_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","У сьвятара Мадыянскага было сем дочак. I яны прыйшлі, і начэрпалі вады, і напоўнілі карыты, каб напаіць авечак бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","I прыйшлі пастухі, і адагналі іх. I ўстаў Майсей, і дапамог ім, і напаіў авечак іхніх. ");
INSERT INTO bel_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","I прыйшлі яны да Рэўэля, бацькі свайго, і ён сказаў ім: «Чаму вы так хутка прыйшлі сёньня?» ");
INSERT INTO bel_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Яны сказалі: «Эгіпцянін выратаваў нас ад пастухоў і нават начэрпаў нам вады, і напаіў авечак». ");
INSERT INTO bel_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ён сказаў дочкам сваім: «Дзе ж ён? Чаму вы пакінулі чалавека гэтага? Паклічце яго, і няхай ён зьесьць хлеб». ");
INSERT INTO bel_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","I ўпадабаў Майсей жыць у гэтага чалавека, і ён выдаў за Майсея дачку сваю Цыпору. ");
INSERT INTO bel_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","I яна нарадзіла сына, і Майсей назваў імя ягонае Гершом, бо ён казаў: «Я стаўся прыхаднем у чужой зямлі». ");
INSERT INTO bel_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","I сталася праз шмат дзён, што памёр валадар Эгіпту. I стагналі сыны Ізраіля ад працаў цяжкіх, і галасілі, і ўзыйшоў да Бога лямант іхні ад працаў цяжкіх. ");
INSERT INTO bel_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","I пачуў Бог стагнаньні іхнія, і ўзгадаў Бог запавет Свой з Абрагамам, Ісаакам і Якубам. ");
INSERT INTO bel_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","I глянуў Бог на сыноў Ізраіля, і даведаўся Бог пра справы іхнія. ");
INSERT INTO bel_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","А Майсей пасьвіў авечак Етра, цесьця свайго, сьвятара Мадыянскага. I павёў ён чараду на другі бок пустыні, і прыйшоў да гары Божае Харэў. ");
INSERT INTO bel_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","I зьявіўся яму анёл ГОСПАДА ў полымі агню з сярэдзіны цярновага куста. І ён бачыў, і вось, цярновы куст гарэў агнём, але куст не згараў. ");
INSERT INTO bel_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","I сказаў Майсей: «Пайду і пагляджу на зьяву гэтую вялікую, чаму куст не згарае». ");
INSERT INTO bel_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","I ўбачыў ГОСПАД, што ён зьвярнуўся паглядзець на гэта, і паклікаў яго Бог з сярэдзіны куста, і сказаў: «Майсей, Майсей!» Ён сказаў: «Вось я!» ");
INSERT INTO bel_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","I сказаў Бог: «Не падыходзь сюды; здымі абутак твой з ног тваіх, бо месца, на якім ты стаіш, ёсьць зямля сьвятая». ");
INSERT INTO bel_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","I сказаў: «Я — Бог бацькі твайго, Бог Абрагама, Бог Ісаака і Бог Якуба». I закрыў Майсей аблічча сваё, бо баяўся глянуць на Бога. ");
INSERT INTO bel_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","I сказаў ГОСПАД: «Гледзячы, Я ўбачыў гора народу Майго, які ў Эгіпце, і Я пачуў стогн ягоны з прычыны прыгнятальнікаў ягоных, бо Я ведаю пакуты ягоныя. ");
INSERT INTO bel_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I Я зыходжу, каб вызваліць яго з рукі Эгіпцянаў і вывесьці яго з зямлі гэтай у зямлю добрую і прасторную, у зямлю, якая цячэ малаком і мёдам, на месца Хананейцаў, і Хетаў, і Амарэяў, і Пэрэзэяў, і Хівеяў, і Евусэяў. ");
INSERT INTO bel_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I цяпер вось, стогн сыноў Ізраіля дайшоў да Мяне, і таксама Я бачу ўціск, якім Эгіпцяне прыгнятаюць іх. ");
INSERT INTO bel_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","I цяпер ідзі, і Я пашлю цябе да фараона; і выведзі з Эгіпту народ Мой, сыноў Ізраіля». ");
INSERT INTO bel_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","I сказаў Майсей Богу: «Хто я, каб мне ісьці да фараона і каб мне вывесьці сыноў Ізраіля з Эгіпту?» ");
INSERT INTO bel_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","I сказаў Бог: «Бо Я буду з табою. І вось табе знак, што Я паслаў цябе: калі ты выведзеш народ з Эгіпту, будзеце служыць Богу на гэтай гары». ");
INSERT INTO bel_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","I сказаў Майсей Богу: «Вось, я прыйду да сыноў Ізраіля і скажу ім: “Бог бацькоў вашых паслаў мяне да вас”. А яны скажуць мне: “Якое імя Яго?” Што я маю сказаць ім?» ");
INSERT INTO bel_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","I сказаў Бог Майсею: «Я Ёсьць, Хто Ёсьць». I сказаў: «Гэтак скажы сынам Ізраіля: “Той, Хто Ёсьць, паслаў мяне да вас”». ");
INSERT INTO bel_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","I сказаў яшчэ Бог Майсею: «Гэтак скажы сынам Ізраіля: “ГОСПАД, Бог бацькоў вашых, Бог Абрагама, Бог Ісаака і Бог Якуба паслаў мяне да вас!” Гэта імя Маё на вякі, і гэта памятка пра Мяне з пакаленьня ў пакаленьне. ");
INSERT INTO bel_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ідзі, зьбяры старшыняў Ізраіля і скажы ім: “ГОСПАД, Бог бацькоў вашых, зьявіўся мне, Бог Абрагама, Ісаака і Якуба, кажучы: \"Наведваючы, наведаў Я вас і бачыў, што робіцца вам у Эгіпце. ");
INSERT INTO bel_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I Я сказаў: ‘Я выведу вас з прыгнёту Эгіпецкага ў зямлю Хананейцаў, Хетаў, Амарэяў, Пэрэзэяў, Хівеяў і Евусэяў, у зямлю, якая цячэ малаком і мёдам’\"”. ");
INSERT INTO bel_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","I яны паслухаюць голасу твайго, і прыйдзеш ты і старшыні Ізраіля да валадара Эгіпту, і вы скажаце яму: “ГОСПАД, Бог Гебраяў, зьявіўся нам, і цяпер дай нам ісьці ў дарогу на тры дні ў пустыню, каб мы склалі ахвяру ГОСПАДУ, Богу нашаму”. ");
INSERT INTO bel_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","I Я ведаю, што ня дасьць вам валадар Эгіпту ісьці, хіба будзе змушаны рукой магутнай. ");
INSERT INTO bel_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","I Я выцягну руку Маю, і ўдару Эгіпет усімі цудамі Маімі, якія ўчыню пасярод яго, і пасьля гэтага ён пусьціць вас. ");
INSERT INTO bel_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","I Я дам ласку народу гэтаму ў вачах Эгіпцянаў; і будзе, што калі вы пойдзеце, ня пойдзеце з пустымі рукамі. ");
INSERT INTO bel_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","І папросіць жанчына ў суседкі сваёй і ў гаспадыні дому свайго посуд срэбны і посуд залаты, і адзеньне, і вы апранеце ў яго сыноў сваіх і дочак сваіх, і спустошыце Эгіпет». ");
INSERT INTO bel_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","І адказаў Майсей, і сказаў: «А калі яны не павераць мне і не паслухаюць голасу майго, бо скажуць: “Не зьявіўся табе ГОСПАД”?». ");
INSERT INTO bel_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","I сказаў яму ГОСПАД: «Што гэта ў руцэ тваёй?» Ён адказаў: «Кій». ");
INSERT INTO bel_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I сказаў: «Кінь яго на зямлю». I ён кінуў яго на зямлю, і стаўся ён зьмеем, і ўцякаў Майсей ад яго. ");
INSERT INTO bel_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","I сказаў ГОСПАД Майсею: «Выцягні руку тваю і схапі яго за хвост!» І выцягнуў ён руку сваю, і схапіў яго, і ён стаўся кіем у далоні ягонай. ");
INSERT INTO bel_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","«Гэта каб паверылі, што зьявіўся табе ГОСПАД, Бог бацькоў іхніх, Бог Абрагама, Бог Ісаака і Бог Якуба». ");
INSERT INTO bel_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","I сказаў ГОСПАД яму яшчэ: «Улажы руку тваю ў заўлоньне тваё». I ён улажыў руку сваю ў заўлоньне сваё, і выняў, і вось, рука ягоная пракажоная, як сьнег. ");
INSERT INTO bel_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","I сказаў: «Улажы зноў руку тваю ў заўлоньне тваё». I ён улажыў зноў руку сваю ў заўлоньне сваё. I выняў яе з заўлоньня свайго, і вось, яна ізноў як цела ягонае. ");
INSERT INTO bel_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","«I станецца, што калі яны не павераць табе і не паслухаюць голасу першага знаку, дык павераць голасу знаку апошняга. ");
INSERT INTO bel_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","I станецца, што калі не павераць таксама двум гэтым знакам і не паслухаюць голасу твайго, возьмеш з ракі ваду і выльеш на сухую зямлю, і станецца, што вада, якую ты возьмеш з ракі, станецца крывёй на сухой зямлі». ");
INSERT INTO bel_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","I сказаў Майсей ГОСПАДУ: «О Госпадзе мой, я — чалавек невымоўны і ўчора, і пазаўчора, і цяпер, калі Ты гаворыш да слугі Свайго, бо я маю цяжкія вусны і цяжкі язык». ");
INSERT INTO bel_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","I сказаў ГОСПАД яму: «Хто даў вусны чалавеку? Хто робіць немым або глухім, або відушчым, або сьляпым? Ці ня Я, ГОСПАД? ");
INSERT INTO bel_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","I цяпер ідзі; і Я буду з вуснамі тваімі, і навучу цябе, што маеш гаварыць». ");
INSERT INTO bel_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","I сказаў Майсей: «О Госпадзе мой! Пашлі, прашу, другога, каго маеш паслаць». ");
INSERT INTO bel_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","I ўзгарэўся гнеў ГОСПАДА на Майсея, і Ён сказаў: «Ці ж няма Аарона, брата твайго, Лявіта? Я ведаю, што ён, гаворачы, добра гаворыць, і вось, ён выйдзе насустрач табе, і ўбачыць цябе, і ўзрадуецца ў сэрцы сваім. ");
INSERT INTO bel_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I ты будзеш гаварыць да яго і ўкладаць словы ў вусны ягоныя; і Я буду з вуснамі тваімі і з вуснамі ягонымі, і буду вучыць вас, што вам рабіць. ");
INSERT INTO bel_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","I будзе ён гаварыць замест цябе да народу. I ён будзе вуснамі тваімі, а ты будзеш яму як Бог. ");
INSERT INTO bel_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","I возьмеш у руку тваю кій гэты, якім зробіш знакі». ");
INSERT INTO bel_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","I пайшоў Майсей, і вярнуўся да Етра, цесьця свайго, і сказаў яму: «Пайду і вярнуся да братоў маіх, якія ў Эгіпце, і пагляджу, ці яны яшчэ жывыя?» I сказаў Етра Майсею: «Ідзі ў супакоі». ");
INSERT INTO bel_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","I сказаў ГОСПАД Майсею ў Мадыяне: «Ідзі, вярніся ў Эгіпет, бо памерлі ўсе людзі, якія шукалі душы тваёй». ");
INSERT INTO bel_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","I ўзяў Майсей жонку сваю і сыноў сваіх, і пасадзіў іх на асла, і вярнуўся ў зямлю Эгіпецкую. I ўзяў кій Божы ў руку сваю. ");
INSERT INTO bel_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","I сказаў ГОСПАД Майсею: «Калі пойдзеш, каб вярнуцца ў Эгіпет, глядзі, каб усе цуды, якія Я ўлажыў у руку тваю, ты зрабіў іх перад фараонам. А Я зраблю цьвёрдым сэрца ягонае, і ён не адпусьціць народ. ");
INSERT INTO bel_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I скажы фараону: “Гэтак кажа ГОСПАД. Сын Мой, першародны Мой — Ізраіль. ");
INSERT INTO bel_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Я кажу табе: \"Адпусьці сына Майго, каб ён служыў Мне. А калі адмовішся адпусьціць яго, вось, Я заб’ю сына твайго, першароднага твайго\"”». ");
INSERT INTO bel_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","I сталася ў дарозе, у месцы начаваньня пераняў яго ГОСПАД і шукаў забіць яго. ");
INSERT INTO bel_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","I ўзяла Цыпора крэмень, і абрэзала скуравінку сына свайго, і дакранулася да ног ягоных, і сказала: «Бо ты мне жаніх крыві». ");
INSERT INTO bel_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","I адступіў Госпад ад яго. Тады яна сказала: «Ты — жаніх крыві праз абразаньне». ");
INSERT INTO bel_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","I сказаў ГОСПАД Аарону: «Ідзі насустрач Майсею ў пустыню». I ён пайшоў, і пераняў яго на гары Божай, і пацалаваў яго. ");
INSERT INTO bel_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","I пераказаў Майсей Аарону ўсе словы ГОСПАДА, Які паслаў яго, і ўсе знакі, якія Ён загадаў яму зрабіць. ");
INSERT INTO bel_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","I пайшлі Майсей і Аарон, і сабралі яны ўсіх старшыняў сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","І пераказаў Аарон усе словы, якія казаў ГОСПАД Майсею, і зрабіў знакі перад вачыма народу. ");
INSERT INTO bel_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","I паверыў народ, і яны пачулі, што ГОСПАД наведаў сыноў Ізраіля і ўбачыў прыгнёт іхні, і схіліліся, і пакланіліся. ");
INSERT INTO bel_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","І потым прыйшлі Майсей і Аарон, і сказалі фараону: «Гэтак кажа ГОСПАД, Бог Ізраіля: “Адпусьці народ Мой, і яны будуць сьвяткаваць сьвята Мне ў пустыні”». ");
INSERT INTO bel_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","І сказаў фараон: «Хто такі ГОСПАД, каб я паслухаў голасу Ягонага адпусьціць Ізраіля? Я ня ведаю ГОСПАДА і таксама Ізраіля не адпушчу». ");
INSERT INTO bel_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","I яны сказалі: «Бог Гебраяў зьявіўся нам. Дык мы пойдзем на тры дні дарогі ў пустыню, і складзем ахвяру ГОСПАДУ, Богу нашаму, каб Ён не наведаў нас пошасьцю або мячом». ");
INSERT INTO bel_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","I сказаў ім валадар Эгіпту: «Навошта вы, Майсей і Аарон, адцягваеце народ ад працы ягонай? Ідзіце да работаў вашых». ");
INSERT INTO bel_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","I сказаў фараон: «Вось, шматлікі цяпер народ зямлі гэтай, а вы адцягваеце іх ад работаў іхніх». ");
INSERT INTO bel_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","I загадаў фараон у той дзень прыганятым народу і наглядчыкам яго, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Не давайце больш народу саломы на выраб цэглы, як учора і пазаўчора. Няхай яны ідуць і зьбіраюць сабе салому. ");
INSERT INTO bel_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","А колькасьць цэглы, якую яны выраблялі ўчора і пазаўчора, налажыце на іх і не зьмяншайце яе; бо яны лянуюцца і таму крычаць, кажучы: “Пойдзем, складзем ахвяру Богу нашаму”. ");
INSERT INTO bel_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Няхай абцяжарыць праца людзей, і няхай яны працуюць і ня слухаюць словаў хлусьлівых». ");
INSERT INTO bel_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","I выйшлі прыганятыя народу і наглядчыкі яго, і сказалі народу, кажучы: «Гэтак кажа фараон: “Не даю вам саломы. ");
INSERT INTO bel_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Самі ідзіце, бярыце сабе салому, дзе знойдзеце, бо нічога ня зьменшыцца ў працы вашай”». ");
INSERT INTO bel_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","І расьсеяўся народ па ўсёй зямлі Эгіпецкай зьбіраць іржышча замест саломы. ");
INSERT INTO bel_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","А прыганятыя прынукалі, кажучы: «Выконвайце працу вашую, норму дзённую ў той самы дзень, як тады, калі была салома». ");
INSERT INTO bel_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","I білі наглядчыкаў сыноў Ізраіля, якіх паставілі над імі прыганятыя фараона, кажучы: «Чаму ня выканалі норму вырабу цэглы, што была ўчора і пазаўчора, ані ўчора, ані сёньня?» ");
INSERT INTO bel_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","I прыйшлі наглядчыкі сыноў Ізраіля, і крычалі да фараона, кажучы: «Чаму ты так робіш адносна слугаў тваіх? ");
INSERT INTO bel_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Саломы не даюць слугам тваім, а цэглу, кажуць нам, рабіце. I вось, слугаў тваіх б’юць; і вінавацяць народ твой». ");
INSERT INTO bel_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Але ён сказаў: «Лайдакі вы, лайдакі; і таму вы кажаце: “Хадземце, складзем ахвяру ГОСПАДУ”. ");
INSERT INTO bel_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","I цяпер ідзіце, працуйце, і саломы не дадуць вам, але вызначаную колькасьць цэглы давайце». ");
INSERT INTO bel_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","I ўбачылі наглядчыкі сыноў Ізраіля, што яны ў бядзе, бо сказана: «Не зьмяншайце колькасьць цэглы, норму дзённую ў той самы дзень». ");
INSERT INTO bel_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","I сустрэлі яны Майсея і Аарона, якія стаялі, чакаючы іх, калі яны выйшлі ад фараона, ");
INSERT INTO bel_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","і сказалі ім: «Няхай узгляне ГОСПАД на вас і асудзіць, бо вы зрабілі нас агіднымі ў вачах фараона і ў вачах слугаў ягоных, і далі меч у рукі іхнія, каб забіць нас». ");
INSERT INTO bel_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","I зьвярнуўся Майсей да ГОСПАДА, і сказаў: «Госпадзе, чаму Ты робіш зло народу гэтаму? Навошта Ты паслаў мяне? ");
INSERT INTO bel_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Бо ад таго часу, як я прыйшоў да фараона, каб гаварыць у імя Тваё, зло робіцца народу гэтаму; а вызваліць, Ты ня вызваліў народ Твой!» ");
INSERT INTO bel_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","І сказаў ГОСПАД Майсею: «Цяпер ты ўбачыш, што Я зраблю фараону, бо дзеля моцнае рукі ён выпусьціць іх і дзеля моцнае рукі ён выганіць іх з зямлі сваёй». ");
INSERT INTO bel_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","I прамовіў Бог да Майсея, і сказаў яму: «Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I Я зьяўляўся Абрагаму, Ісааку і Якубу як Бог Усемагутны, але імя Маё, ГОСПАД, Я ня даў ведаць ім. ");
INSERT INTO bel_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I Я заключыў запавет Мой з імі, каб даць ім зямлю Ханаан, зямлю вандраваньня іхняга, у якой яны вандравалі. ");
INSERT INTO bel_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","I таксама Я пачуў стогны сыноў Ізраіля, якіх Эгіпцяне зрабілі нявольнікамі, і ўзгадаў запавет Мой. ");
INSERT INTO bel_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Дзеля гэтага скажы сынам Ізраіля: “Я — ГОСПАД, і Я выведу вас з-пад ярма Эгіпецкага, і выратую вас з няволі іхняе, і вызвалю вас рамяном узьнятым і судамі вялікімі. ");
INSERT INTO bel_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I Я вазьму вас Сабе за народ, і буду вам Богам, і вы даведаецеся, што Я — ГОСПАД, Бог ваш, Які вывеў вас з-пад ярма Эгіпецкага. ");
INSERT INTO bel_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I Я прывяду вас у тую зямлю, пра якую Я падняў руку Сваю, каб даць яе Абрагаму, Ісааку і Якубу, і дам яе вам на ўласнасьць. Я — ГОСПАД”». ");
INSERT INTO bel_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","I гаварыў Майсей гэтак да сыноў Ізраіля, але яны ня слухалі Майсея з прычыны маладушнасьці і цяжкай працы. ");
INSERT INTO bel_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Ідзі, скажы фараону, валадару Эгіпту, каб адпусьціў сыноў Ізраіля з зямлі сваёй». ");
INSERT INTO bel_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","I прамовіў Майсей перад абліччам ГОСПАДА, кажучы: «Вось, сыны Ізраіля ня слухаюць мяне; і як жа паслухае мяне фараон? А я маю неабрэзаныя вусны». ");
INSERT INTO bel_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","I прамовіў ГОСПАД да Майсея і Аарона, і загадаў ім казаць да сыноў Ізраіля і да фараона, валадара Эгіпту, каб вывесьці сыноў Ізраіля з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Гэта галовы дамоў бацькоў іхніх. Сыны Рубэна, першароднага Ізраіля: Ганох і Пальлю, Хецрон і Кармі. Гэта плямёны Рубэна. ");
INSERT INTO bel_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","А сыны Сымона: Емуэль і Ямін, і Агад, і Яхін, і Цахар, і Шаўль, сын Ханаанянкі. Гэта плямёны Сымона. ");
INSERT INTO bel_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","I вось імёны сыноў Левія паводле радаводаў іхніх: Гершон, і Кегат, і Мэрары. А гадоў жыцьця Левія было сто трыццаць сем гадоў. ");
INSERT INTO bel_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Сыны Гершона: Ліўні і Шымэй паводле плямёнаў іхніх. ");
INSERT INTO bel_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","А сыны Кегата: Амрам, і Іцгар, і Хеўрон, і Узіэль. А гадоў жыцьця Кегата было сто трыццаць тры гады. ");
INSERT INTO bel_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","А сыны Мэрары: Махлі і Мушы. Гэта плямёны Левія паводле радаводаў іхніх. ");
INSERT INTO bel_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","I ўзяў Амрам Ёхабэд, цётку сваю, сабе за жонку, і яна нарадзіла яму Аарона і Майсея. А гадоў жыцьця Амрама было сто трыццаць сем гадоў. ");
INSERT INTO bel_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","А сыны Іцгара: Карах, і Нэфэг, і Зіхры. ");
INSERT INTO bel_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","А сыны Узыэля: Мішаэль, і Эльцафан, і Сытры. ");
INSERT INTO bel_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","I ўзяў Аарон Элішэбу, дачку Амінадава, сястру Нахшона, сабе за жонку, і яна нарадзіла яму Надава і Абігу, Элеазара і Ітамара. ");
INSERT INTO bel_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","I сыны Караха: Асір, і Элькана, і Абіясаф. Гэта плямёны Караха. ");
INSERT INTO bel_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","I Элеазар, сын Аарона, узяў адну з дачок Путыэля сабе за жонку, і яна нарадзіла яму Пінхаса. Вось галовы бацькоў Лявітаў паводле плямёнаў іхніх. ");
INSERT INTO bel_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Гэта вось Аарон і Майсей, якім сказаў ГОСПАД: «Выведзіце сыноў Ізраіля з зямлі Эгіпецкай паводле дружынаў іхніх». ");
INSERT INTO bel_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Яны прамаўлялі да фараона, валадара Эгіпту, каб вывесьці сыноў Ізраіля з Эгіпту, гэтыя Майсей і Аарон. ");
INSERT INTO bel_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","I сталася ў дзень, калі ГОСПАД прамаўляў да Майсея ў зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","I сказаў ГОСПАД Майсею, кажучы: «Я — ГОСПАД. Кажы фараону, валадару Эгіпту, усё, што Я кажу табе». ");
INSERT INTO bel_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","I Майсей сказаў перад абліччам ГОСПАДА: «Вось, я маю неабрэзаныя вусны, і як жа паслухае мяне фараон?» ");
INSERT INTO bel_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","I сказаў ГОСПАД Майсею: «Глядзі, Я паставіў цябе як Бога для фараона, а Аарон, брат твой, будзе прарокам тваім. ");
INSERT INTO bel_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ты будзеш гаварыць усё, што Я загадаю табе, а Аарон, брат твой, будзе гаварыць да фараона, і ён адпусьціць сыноў Ізраіля з зямлі сваёй. ");
INSERT INTO bel_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","I Я зраблю цьвёрдым сэрца фараона, і памножу знакі Мае і цуды Мае ў зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I не паслухае вас фараон, і Я пакладу руку Маю на Эгіпет, і выведу войска Маё, народ Мой, сыноў Ізраіля з зямлі Эгіпецкай праз суды вялікія. ");
INSERT INTO bel_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","I даведаюцца Эгіпцяне, што Я — ГОСПАД, калі выцягну руку Маю на Эгіпет і выведу сыноў Ізраіля спаміж іх». ");
INSERT INTO bel_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","I зрабілі так Майсей і Аарон; як загадаў ім ГОСПАД, так яны і ўчынілі. ");
INSERT INTO bel_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","І Майсею было восемдзясят гадоў, а Аарону — восемдзясят тры гады, калі прамаўлялі яны да фараона. ");
INSERT INTO bel_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","I сказаў ГОСПАД Майсею і Аарону, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Калі скажа вам фараон, кажучы: “Дайце ваш цуд”, ты скажы Аарону: “Вазьмі кій твой і кінь перад фараонам”; і ён станецца цмокам». ");
INSERT INTO bel_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","I прыйшоў Майсей і Аарон да фараона, і ўчынілі так, як загадаў ГОСПАД. I кінуў Аарон кій свой перад фараонам і перад слугамі ягонымі, і ён стаўся цмокам. ");
INSERT INTO bel_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","I паклікаў фараон мудрацоў і чараўнікоў, і ўчынілі варажбіты Эгіпецкія варажбою сваёю тое самае. ");
INSERT INTO bel_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","I кінуў кожны кій свой, і яны сталіся цмокамі, але праглынуў кій Ааронаў кіі іхнія. ");
INSERT INTO bel_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Але зацьвярдзела сэрца фараона, і ён не паслухаў іх, як гаварыў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","I сказаў ГОСПАД Майсею: «Закамянела сэрца фараона; ён адмаўляецца адпусьціць народ. ");
INSERT INTO bel_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ідзі да фараона раніцаю. Вось, ён выйдзе да вады, а ты стань насупраць яго на беразе ракі; і кій, які перамяняўся ў зьмея, возьмеш у руку тваю. ");
INSERT INTO bel_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I скажы яму: “ГОСПАД, Бог Гебраяў, паслаў мяне да цябе, кажучы: \"Адпусьці народ Мой, і ён будзе служыць Мне ў пустыні\". І вось, ты не паслухаў аж да цяпер. ");
INSERT INTO bel_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Гэтак кажа ГОСПАД: \"З гэтага ты даведаешся, што Я — ГОСПАД\". Вось, я ўдару кіем, які ў руцэ маёй, па вадзе, якая ў рацэ, і яна пераменіцца ў кроў, ");
INSERT INTO bel_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","і рыба, якая ў рацэ, здохне, і рака засьмярдзіць, і агідна будзе Эгіпцянам піць ваду з ракі”». ");
INSERT INTO bel_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","I сказаў ГОСПАД Майсею: «Скажы Аарону: “Вазьмі кій твой і выцягні руку тваю на воды Эгіпту, на рэкі іхнія, на ручаі іхнія, на сажалкі іхнія і на ўсялякія ставы водаў іхніх; і стануцца яны крывёй, і будзе кроў па ўсёй зямлі Эгіпецкай, і ў начыньнях драўляных і каменных”». ");
INSERT INTO bel_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","І зрабілі Майсей і Аарон так, як загадаў ГОСПАД. I падняў ён кій, і ўдарыў па вадзе, якая ў рацэ, перад вачыма фараона і перад вачыма слугаў ягоных, і перамянілася ўся вада, якая ў рацэ, у кроў. ");
INSERT INTO bel_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","І рыба, якая ў рацэ, падохла, і засьмярдзела рака, і не маглі Эгіпцяне піць вады з ракі; і была кроў у-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","I зрабілі гэтаксама варажбіты Эгіпецкія варажбою сваёю. I зацьвярдзела сэрца фараона, і ён не паслухаў іх, як і казаў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","I павярнуўся фараон, і пайшоў у дом свой; і не зьвярнуў сэрца свайго да гэтага. ");
INSERT INTO bel_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","I капаў увесь Эгіпет вакол ракі ваду, каб піць, бо не маглі піць вады з ракі. ");
INSERT INTO bel_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","I споўнілася сем дзён пасьля таго, як ГОСПАД ударыў раку. ");
INSERT INTO bel_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","І сказаў ГОСПАД Майсею: «Прыйдзі да фараона і скажы яму: “Адпусьці народ Мой, і ён будзе служыць Мне. ");
INSERT INTO bel_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Калі ж ты адмаўляешся адпусьціць, вось, Я ўдару ўсе межы твае жабамі. ");
INSERT INTO bel_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","I будзе раіцца рака жабамі, і яны выйдуць, і ўвойдуць у дом твой, і ў спальню тваю, і на ложак твой, і ў дом слугі твайго, і ў народ твой, і ў печы твае, і ў дзежы твае. ");
INSERT INTO bel_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","І на цябе, і на народ твой, і на ўсіх слугаў тваіх узыйдуць жабы”». ");
INSERT INTO bel_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","I сказаў ГОСПАД Майсею: «Скажы Аарону: “Выцягні руку тваю з кіем тваім на ручаі, і на рэкі, і на азёры, і ўзьвядзі жабаў на зямлю Эгіпецкую”». ");
INSERT INTO bel_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","I выцягнуў Аарон руку сваю на воды Эгіпецкія, і выйшлі жабы, і пакрылі зямлю Эгіпецкую. ");
INSERT INTO bel_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","I зрабілі так варажбіты варажбою сваёю, і ўзьвялі жабаў на зямлю Эгіпецкую. ");
INSERT INTO bel_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","I паклікаў фараон Майсея і Аарона, і сказаў: «Прасіце ГОСПАДА, каб Ён аддаліў жабаў ад мяне і ад народу майго, і я адпушчу народ, і яны складуць ахвяры ГОСПАДУ». ");
INSERT INTO bel_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","I сказаў Майсей фараону: «Прызнач мне, калі прасіць за цябе, і за слугаў тваіх, і за народ твой, каб жабы былі зьнішчаны ў цябе, у дамах тваіх, і засталіся толькі ў рацэ». ");
INSERT INTO bel_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ён сказаў: «Заўтра». I сказаў Майсей: «Паводле слова твайго, каб ты даведаўся, што няма нікога як ГОСПАД, Бог наш. ");
INSERT INTO bel_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","I адыйдуць жабы ад цябе, ад дамоў тваіх, і ад слугаў тваіх, і ад народу твайго, толькі ў рацэ застануцца». ");
INSERT INTO bel_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","I выйшлі Майсей і Аарон ад фараона, і Майсей клікаў да ГОСПАДА адносна жабаў, якіх узьвёў на фараона. ");
INSERT INTO bel_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","I зрабіў ГОСПАД паводле слова Майсея, і здохлі жабы ў дамах, і ў дварах, і на палях. ");
INSERT INTO bel_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","I пазьбіралі іх купы купаў, і засьмярдзелася зямля. ");
INSERT INTO bel_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","I ўбачыў фараон, што сталася палёгка, і закамяніў сэрца сваё, і не паслухаў іх, як і гаварыў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","I сказаў ГОСПАД Майсею: «Скажы Аарону: “Выцягні кій твой і ўдар у пыл зямлі, і станецца пыл камарамі ў-ва ўсёй зямлі Эгіпецкай”». ");
INSERT INTO bel_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","I яны зрабілі так, і выцягнуў Аарон руку сваю з кіем сваім, і ўдарыў у пыл зямлі, і зьявіліся камары на людзях і на скаціне. Увесь пыл зямлі стаўся камарамі ў-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","I рабілі так варажбіты варажбою сваёй, каб зьявіліся камары, але не змаглі. I былі камары на людзях і на скаціне. ");
INSERT INTO bel_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","I сказалі варажбіты фараону: «Палец Божы гэта». Але сэрца фараона зацьвярдзела, і ён не паслухаў іх, як і гаварыў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","I сказаў ГОСПАД Майсею: «Устань раніцаю і стань перад фараонам. Вось, ён ідзе да вады, і ты скажы яму: “Гэтак кажа ГОСПАД: \"Адпусьці народ Мой, і ён будзе служыць Мне. ");
INSERT INTO bel_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Бо калі не адпусьціш народ Мой, вось, Я пашлю на цябе, і на слугаў тваіх, і на народ твой, і на дамы твае мухаў, і напоўняцца дамы Эгіпцянаў мухамі, і таксама грунты, на якіх яны. ");
INSERT INTO bel_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","I Я аддзялю ў той дзень зямлю Гашэн, у якой жыве народ Мой, каб ня было там мухаў, каб ты даведаўся, што Я — ГОСПАД пасярод зямлі. ");
INSERT INTO bel_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","І Я зраблю розьніцу паміж народам Маім і народам тваім. Заўтра станецца знак гэты\"”». ");
INSERT INTO bel_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","I зрабіў ГОСПАД гэтак, і наляцелі ўцяжлівыя мухі на дом фараона, і на дом слугаў ягоных, і на ўсю зямлю Эгіпецкую; гінула зямля ад мухаў. ");
INSERT INTO bel_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","I паклікаў фараон Майсея і Аарона, і сказаў ім: «Ідзіце, складзіце ахвяру Богу свайму ў гэтай зямлі». ");
INSERT INTO bel_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","I сказаў Майсей: «Не належыцца рабіць гэтак, бо агіду для Эгіпцянаў мы складзем у ахвяру ГОСПАДУ, Богу нашаму; вось, мы будзем складаць у ахвяру тое, што агіднае ў Эгіпцянаў, перад вачыма іхнімі, і ці не ўкамянуюць яны нас? ");
INSERT INTO bel_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","На тры дні дарогі мы пойдзем у пустыню і складзем ахвяру ГОСПАДУ, Богу нашаму, як Ён скажа нам». ");
INSERT INTO bel_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","I сказаў фараон: «Я адпушчу вас, і вы складзеце ахвяру Богу свайму ў пустыні; толькі аддаляючыся, не аддаляйцеся, каб зыйсьці. Прасіце за мяне». ");
INSERT INTO bel_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","I сказаў Майсей: «Вось, я выйду ад цябе, і буду прасіць ГОСПАДА, і адыйдуць мухі ад фараона, і ад слугаў ягоных, і ад народу ягонага заўтра. Толькі няхай фараон больш не падманвае, не адпускаючы народ скласьці ахвяру ГОСПАДУ». ");
INSERT INTO bel_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","I выйшаў Майсей ад фараона, і прасіў ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","I зрабіў ГОСПАД паводле слова Майсея, і адвёў мухаў ад фараона, ад слугаў ягоных і ад народу ягонага; не засталося аніводнай. ");
INSERT INTO bel_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Але фараон закамяніў сэрца сваё таксама гэтым разам і не адпусьціў народ. ");
INSERT INTO bel_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","I сказаў ГОСПАД Майсею: «Увайдзі да фараона і прамоў яму: “Гэтак кажа ГОСПАД, Бог Гебраяў: “Адпусьці народ Мой, і ён будзе служыць Мне”. ");
INSERT INTO bel_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Бо калі ты адмовішся выпусьціць і будзеш яшчэ трымаць іх, ");
INSERT INTO bel_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","вось, рука ГОСПАДА будзе на статку тваім, які ў полі, на конях, на аслах, на вярблюдах, на валах і авечках, зараза вельмі цяжкая. ");
INSERT INTO bel_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","I аддзеліць ГОСПАД статак Ізраіля ад статку Эгіпецкага, і нічога ня здохне з усяго таго, што ў сыноў Ізраіля”». ");
INSERT INTO bel_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","I прызначыў ГОСПАД час, кажучы: «Заўтра зробіць ГОСПАД гэтае слова ў зямлі». ");
INSERT INTO bel_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","I зрабіў ГОСПАД гэтае слова назаўтра, і паздыхаў увесь статак Эгіпецкі; а ў статку сыноў Ізраіля ня здохла аніводнага. ");
INSERT INTO bel_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","I паслаў фараон, і вось, ня здохла ў статку Ізраіля аніводнага. І закамянела сэрца фараона, і ён не адпусьціў народ. ");
INSERT INTO bel_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","I сказаў ГОСПАД Майсею і Аарону: «Вазьміце сабе поўныя жмені сажы з печы, і няхай сыпне яе Майсей у неба перад вачыма фараона. ");
INSERT INTO bel_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","I станецца яна пылам па ўсёй зямлі Эгіпецкай, і будзе яна на людзях і на скаціне як запаленьне са скуламі па ўсёй зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","І ўзялі яны сажу з печы, і сталі перад фараонам. І сыпнуў яе Майсей у неба, і сталася запаленьне са скуламі на людзях і на скаціне. ");
INSERT INTO bel_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","I не маглі варажбіты ўстаяць перад Майсеем з прычыны запаленьня, бо запаленьне было на варажбітах і на ўсіх Эгіпцянах. ");
INSERT INTO bel_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","I зацьвярдзіў ГОСПАД сэрца фараона, і ён не паслухаў іх, як казаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","I сказаў ГОСПАД Майсею: «Устань раніцаю, і стань перад фараонам, і скажы яму: “Гэтак кажа ГОСПАД, Бог Гебраяў: \"Адпусьці народ Мой, і ён будзе служыць Мне. ");
INSERT INTO bel_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Бо гэтым разам Я пашлю ўсе плягі Мае ў сэрца тваё, і на слугаў тваіх, і на народ твой, каб ты даведаўся, што няма падобнага да Мяне на ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Бо цяпер, калі Я выцягнуў руку Маю, і ўдару цябе і народ твой заразаю, ты будзеш выгублены з зямлі. ");
INSERT INTO bel_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Але дзеля таго Я захаваў цябе, каб паказаць табе сілу Маю і каб абвяшчалі імя Маё па ўсёй зямлі. ");
INSERT INTO bel_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ты яшчэ ўзьвялічваешся над народам Маім, каб не адпусьціць іх. ");
INSERT INTO bel_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Вось, Я спашлю заўтра ў гэты самы час град вельмі вялікі, да якога падобнага не было ў Эгіпце ад дня яго заснаваньня аж дагэтуль. ");
INSERT INTO bel_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","I цяпер пашлі, каб схаваць статак твой і ўсё, што ёсьць у цябе ў полі. Кожны чалавек і скаціна, якія будуць засьпетыя ў полі і ня будуць забраныя ў дамы, — зыйдзе на іх град, і яны памруць\"”». ");
INSERT INTO bel_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Тыя са слугаў фараонавых, якія спужаліся слова ГОСПАДА, сабралі слугаў сваіх і статкі свае ў дамы. ");
INSERT INTO bel_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","А хто не зьвярнуў сэрца свайго да слова ГОСПАДА, той пакінуў слугаў сваіх і статкі свае ў полі. ");
INSERT INTO bel_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","I сказаў ГОСПАД Майсею: «Выцягні руку тваю да неба, і будзе град у-ва ўсёй зямлі Эгіпецкай, на чалавека, на скаціну і на ўсю траву палявую ў зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","I выцягнуў Майсей кій свой да неба; і ГОСПАД даў грымоты і град, і зыйшоў агонь на зямлю, і спаслаў ГОСПАД град на ўсю зямлю Эгіпецкую. ");
INSERT INTO bel_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","I быў град і агонь, зьмяшаны з градам, вельмі вялікі, якога не было ў-ва ўсёй зямлі Эгіпецкай з часу, як Эгіпет стаў народам. ");
INSERT INTO bel_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","I пабіў град у-ва ўсёй зямлі Эгіпецкай усё, што было ў полі, ад чалавека да скаціны, і ўсю траву палявую пабіў град, і ўсе дрэвы ў полі паламіў. ");
INSERT INTO bel_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Толькі ў зямлі Гашэн, дзе былі сыны Ізраіля, не было граду. ");
INSERT INTO bel_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","I паслаў фараон, і паклікаў Майсея і Аарона, і сказаў ім: «Саграшыў я гэтым разам. ГОСПАД — праведны, а я і народ мой — ліхія. ");
INSERT INTO bel_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Прасіце ГОСПАДА, бо ўжо досыць грымотаў Божых і граду, і я пушчу вас, і ня будзеце больш заставацца». ");
INSERT INTO bel_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","I сказаў яму Майсей: «Як толькі выйду з гораду, выцягну далоні свае да ГОСПАДА; грымоты спыняцца і граду больш ня будзе, каб ты ведаў, што ГОСПАДАВА зямля. ");
INSERT INTO bel_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Але ты і слугі твае, я ведаю, яшчэ ня маеце страху перад абліччам ГОСПАДА Бога». ");
INSERT INTO bel_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I лён, і ячмень былі пабітыя, бо ячмень красаваў, а лён квітнеў. ");
INSERT INTO bel_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","А пшаніца і жыта не былі пабітыя, бо яны пазьнейшыя. ");
INSERT INTO bel_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","I выйшаў Майсей ад фараона з гораду, і выцягнуў далоні свае да ГОСПАДА; і спыніліся грымоты і град, і дождж больш ня ліў на зямлю. ");
INSERT INTO bel_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","I ўбачыў фараон, што спыніліся дождж, і град, і грымоты, і далей грашыў, і закамяніў сэрца сваё ён сам і слугі ягоныя. ");
INSERT INTO bel_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","I зацьвярдзела сэрца фараона, і ён не адпусьціў сыноў Ізраіля, як і казаў ГОСПАД праз Майсея. ");
INSERT INTO bel_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","I сказаў ГОСПАД Майсею: «Увайдзі да фараона, бо Я закамяніў сэрца ягонае і сэрца слугаў ягоных, каб рабіць гэтыя знакі Мае пасярод яго, ");
INSERT INTO bel_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","і каб ты распавядаў у вушы сына твайго і сына сына твайго пра тое, што Я зрабіў у Эгіпце, і пра знакі Мае, якія Я ўчыніў ім, і каб вы ведалі, што Я — ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","I ўвайшлі Майсей і Аарон да фараона, і сказалі яму: «Гэтак кажа ГОСПАД, Бог Гебраяў: “Дакуль ты будзеш адмаўляцца скарыцца перада Мною? Адпусьці народ Мой, і яны будуць служыць Мне. ");
INSERT INTO bel_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Бо калі адмовішся адпусьціць народ Мой, вось, Я прывяду заўтра саранчу ў межы твае. ");
INSERT INTO bel_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","І яна пакрые паверхню зямлі, і нельга будзе бачыць зямлі, і паесьць рэшту, што ацалела, што засталося ў вас пасьля граду, і паесьць кожнае дрэва, якое расьце ў вас на полі. ");
INSERT INTO bel_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","І яна напоўніць дамы твае, і дамы ўсіх слугаў тваіх, і дамы ўсіх Эгіпцянаў, чаго ня бачылі бацькі твае і бацькі бацькоў тваіх з дня, як былі на зямлі, аж да дня гэтага”». I павярнуўся Майсей, і выйшаў ад фараона. ");
INSERT INTO bel_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","I сказалі слугі фараонавы яму: «Дакуль гэта будзе для нас пасткаю? Адпусьці людзей гэтых, і няхай яны служаць ГОСПАДУ, Богу свайму. Няўжо ты яшчэ не разумееш, што гіне Эгіпет?» ");
INSERT INTO bel_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","I вярнулі Майсея і Аарона да фараона, і ён сказаў ім: «Ідзіце, служыце ГОСПАДУ, Богу вашаму. Але хто мае пайсьці?» ");
INSERT INTO bel_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","I сказаў Майсей: «Пойдзем з малымі нашымі і са старымі нашымі, з сынамі нашымі і дочкамі нашымі, пойдзем з авечкамі нашымі і валамі нашымі, бо сьвята ГОСПАДУ ў нас». ");
INSERT INTO bel_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","I сказаў ім фараон: «Няхай так будзе ГОСПАД з вамі! Як я адпушчу вас і дзяцей вашых? Глядзіце, бо ліхое маеце перад абліччам сваім. ");
INSERT INTO bel_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Не, ня будзе так. Ідзіце мужчыны і служыце ГОСПАДУ, бо вы гэтага жадалі». I выгналі іх ад аблічча фараона. ");
INSERT INTO bel_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","I сказаў ГОСПАД Майсею: «Выцягні руку тваю на зямлю Эгіпецкую дзеля саранчы, і яна прыйдзе на зямлю Эгіпецкую, і паесьць усю траву зямлі, усё, што пакінуў град». ");
INSERT INTO bel_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","I выцягнуў Майсей кій свой на зямлю Эгіпецкую; і ГОСПАД прывёў на зямлю ўсходні вецер увесь той дзень і ўсю ноч. Настала раніца, і ўсходні вецер прынёс саранчу. ");
INSERT INTO bel_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","I прыйшла саранча на ўсю зямлю Эгіпецкую, і асела ў-ва ўсіх межах Эгіпецкіх вельмі ўцяжліва; уперад не было такой саранчы, як гэта, і пасьля яе ня будзе такой. ");
INSERT INTO bel_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","I яна пакрыла паверхню ўсёй зямлі, і зямля пацямнела, і яна паела ўсю траву зямную і ўсе плады дрэваў, якія засталіся пасьля граду; і не засталося ніякай зеляніны на дрэвах і на траве палявой у-ва ўсёй зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","I пасьпяшаўся фараон паклікаць Майсея і Аарона, і сказаў: «Саграшыў я перад ГОСПАДАМ, Богам вашым, і перад вамі. ");
INSERT INTO bel_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","I цяпер даруйце, прашу, грэх мой хаця б у гэты раз, і прасіце ГОСПАДА, Бога вашага, каб толькі Ён прыбраў ад мяне гэтую сьмерць». ");
INSERT INTO bel_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","I выйшаў Майсей ад фараона, і прасіў ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","I павярнуў ГОСПАД заходні вецер, вельмі моцны, і ён панёс саранчу, і ўкінуў яе ў Мора Чырвонае; не засталося аніводнае саранчы ў-ва ўсіх межах Эгіпецкіх. ");
INSERT INTO bel_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","І ГОСПАД зрабіў цьвёрдым сэрца фараона, і ён не адпусьціў сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","I сказаў ГОСПАД Майсею: «Выцягні руку тваю да неба, і станецца цемра на зямлі Эгіпецкай, і будзе адчувацца цемра». ");
INSERT INTO bel_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","I ён выцягнуў руку сваю да неба, і сталася густая цемра ў-ва ўсёй зямлі Эгіпецкай тры дні. ");
INSERT INTO bel_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ня бачылі людзі адзін аднаго, і ніхто не ўставаў з месца свайго тры дні; а ў-ва ўсіх сыноў Ізраіля было сьветла ў сядзібах іхніх. ");
INSERT INTO bel_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","I паклікаў фараон Майсея, і сказаў: «Ідзіце, служыце ГОСПАДУ, толькі авечкі вашыя і валы вашыя няхай застануцца, і таксама дзеці вашыя няхай ідуць з вамі». ");
INSERT INTO bel_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","І сказаў Майсей: «Таксама ты павінен даць у рукі нашыя ахвяры і цэласпаленьні, і мы зробім служэньне гэта ГОСПАДУ, Богу нашаму. ");
INSERT INTO bel_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","I таксама статак наш пойдзе з намі, і не застанецца ані капыта; бо з яго мы возьмем для служэньня ГОСПАДУ, Богу нашаму; але мы ня ведаем, чым будзем служыць ГОСПАДУ, пакуль ня прыйдзем туды». ");
INSERT INTO bel_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","I зрабіў цьвёрдым ГОСПАД сэрца фараона, і ён не захацеў адпусьціць іх. ");
INSERT INTO bel_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","I сказаў Майсею фараон: «Ідзі ад мяне! Сьцеражыся, каб ты ня бачыў больш аблічча маё, бо ў той дзень, калі ты ўбачыш аблічча маё, памрэш». ");
INSERT INTO bel_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","I сказаў Майсей: «Так станецца, як ты сказаў. Я больш ня буду бачыць аблічча тваё». ");
INSERT INTO bel_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","І сказаў ГОСПАД Майсею: «Яшчэ адну загубу Я навяду на фараона і на Эгіпет. Пасьля гэтага ён адпусьціць вас адгэтуль. Калі ён будзе адпускаць вас, выганяючы, выганіць вас адгэтуль. ");
INSERT INTO bel_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Прамоў, прашу, у вушы народу, і няхай мужчына папросіць у бліжняга свайго, і жанчына — у бліжняй сваёй начыньне срэбнае і начыньне залатое». ");
INSERT INTO bel_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","I даў ГОСПАД ласку народу ў вачах Эгіпцянаў, таксама гэты чалавек Майсей быў вельмі вялікі ў зямлі Эгіпецкай, у вачах слугаў фараона і ў вачах народу. ");
INSERT INTO bel_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","I сказаў Майсей: «Гэтак кажа ГОСПАД: “Апоўначы Я прайду пасярод Эгіпту. ");
INSERT INTO bel_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","I памрэ кожны першародны ў зямлі Эгіпецкай, ад першароднага фараона, які сядзіць на пасадзе сваім, да першароднага нявольніцы, якая пры жорнах, і ўсе першародныя скаціны. ");
INSERT INTO bel_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I будзе крык вялікі ў-ва ўсёй зямлі Эгіпецкай такі, што падобнага да яго не было і падобнага да яго больш ня будзе. ");
INSERT INTO bel_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","А ў сыноў Ізраіля не варухне сабака языком сваім ані на чалавека, ані на скаціну, каб вы ведалі, што робіць адрозьненьне ГОСПАД паміж Эгіптам і Ізраілем”. ");
INSERT INTO bel_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","I прыйдуць усе гэтыя слугі твае да мяне, і паклоняцца мне, кажучы: “Выйдзі ты і ўвесь народ, які каля ног тваіх”, і пасьля гэтага я выйду». I выйшаў Майсей ад фараона, палаючы гневам. ");
INSERT INTO bel_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","I сказаў ГОСПАД Майсею: «Не паслухае вас фараон, каб памножыліся цуды Мае ў зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","I Майсей і Аарон зрабілі ўсе цуды гэтыя перад фараонам, і зацьвярдзіў ГОСПАД сэрца фараона, і ён не адпусьціў сыноў Ізраіля з зямлі сваёй. ");
INSERT INTO bel_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","I сказаў ГОСПАД Майсею і Аарону ў зямлі Эгіпецкай, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Месяц гэты няхай будзе ў вас пачаткам месяцаў; першым няхай ён будзе ў вас месяцам году. ");
INSERT INTO bel_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Прамоўце да ўсёй грамады Ізраіля, кажучы: “У дзясяты дзень гэтага месяца няхай возьме сабе кожны ягня для дому бацькоў, ягня на дом. ");
INSERT INTO bel_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","I калі малы дом, каб спажыць ягня, няхай возьме ён і сусед найбліжэйшы да дому ягонага, паводле ліку душаў; паводле таго, колькі кожны зьесьць, палічыце на ягня. ");
INSERT INTO bel_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ягня беззаганнае, самец аднагодак мае быць у вас; з авечак альбо з козаў возьмеце яго. ");
INSERT INTO bel_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","I будзеце захоўваць яго да чатырнаццатага дня гэтага месяца. І зарэжа яго ўся царква грамады Ізраіля адвячоркам. ");
INSERT INTO bel_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","I возьмуць кроў ягоную, і памажуць абодва вушакі і вершнікі ў дамах, у якіх будуць есьці яго. ");
INSERT INTO bel_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","І будуць есьці ў гэтую ноч мяса ягонае, сьпечанае на агні, і праснакі; з горкімі травамі будуць есьці яго. ");
INSERT INTO bel_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ня ешце з яго сырога або зваранага ў вадзе, але сьпечанае на агні, галаву ягоную з галёнкамі ягонымі і нутром ягоным. ");
INSERT INTO bel_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","I не пакідайце нічога з яго да раніцы; і тое, што застанецца з яго да раніцы, спаліце на агні. ");
INSERT INTO bel_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","I гэтак будзеце есьці яго: няхай будуць сьцёгны вашыя падперазаныя, абутак ваш — на нагах вашых і кій ваш — у руцэ вашай, і ешце яго пасьпешліва. Гэта — Пасха для ГОСПАДА”. ");
INSERT INTO bel_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","I Я прайду па зямлі Эгіпецкай у гэтую ноч, і заб’ю кожнага першароднага ў зямлі Эгіпецкай, ад чалавека аж да скаціны, і над усімі багамі Эгіпту Я ўчыню суды. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","I будзе для вас кроў знакам на дамах, у якіх вы будзеце, і Я ўбачу кроў, і абміну вас, і ня будзе сярод вас плягі зьнішчэньня, калі Я буду забіваць у зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","I будзе дзень гэты для вас на ўспамін, і будзеце сьвяткаваць яго як сьвята для ГОСПАДА ў пакаленьнях вашых; як пастанову вечную будзеце сьвяткаваць яго. ");
INSERT INTO bel_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Сем дзён будзеце есьці праснакі; і ўжо ў першы дзень прыміце кісьлю з дамоў вашых; бо кожны, хто будзе есьці кіслае з першага дня да сёмага дня, душа таго будзе выгублена з Ізраілю. ");
INSERT INTO bel_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","А ў першы дзень — сьвяты збор, і ў сёмы дзень сьвяты збор будзе ў вас, ніякай работы ня будзеце рабіць у іх; толькі тое, што есьці кожнай душы, адно тое можна рабіць вам. ");
INSERT INTO bel_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I захоўвайце Сьвята Праснакоў, бо ў гэты дзень Я вывеў войска вашае з зямлі Эгіпецкай; і захоўвайце гэты дзень у пакаленьнях вашых як пастанову вечную. ");
INSERT INTO bel_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","У першы месяц, у чатырнаццаты дзень месяца з вечара будзеце есьці праснакі аж да вечара дваццаць першага дня таго самага месяца. ");
INSERT INTO bel_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Сем дзён кісьля няхай ня знойдзецца ў дамах вашых; бо хто будзе есьці кіслае, выгублена будзе душа тая з грамады Ізраіля, ці гэта прыхадзень, ці той, што нарадзіўся ў гэтай зямлі. ");
INSERT INTO bel_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Нічога кіслага ня будзеце есьці; у-ва ўсіх сядзібах вашых будзеце есьці праснакі». ");
INSERT INTO bel_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","I паклікаў Майсей усіх старшыняў Ізраіля, і сказаў ім: «Выберыце і вазьміце сабе ягнятка паводле плямёнаў вашых і зарэжце яго як ахвяру пасхальную. ");
INSERT INTO bel_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","I вазьміце вязку ізопу, і занурыце ў кроў, якая ў мядніцы, і памажаце вершнік і абодва вушакі крывёю, якая ў мядніцы, і вы самі не выходзьце ніхто за дзьверы дому свайго аж да раніцы. ");
INSERT INTO bel_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","I пойдзе ГОСПАД, каб губіць Эгіпет, і ўбачыць кроў на вершніку і на абодвух вушаках, і пройдзе ГОСПАД каля дзьвярэй, і ня дасьць нішчыцелю ўвайсьці ў дамы вашыя, каб губіць. ");
INSERT INTO bel_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","I будзеце захоўваць слова гэтае, як пастанову для сябе і для сыноў вашых на вякі. ");
INSERT INTO bel_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","I станецца, што, калі вы ўвойдзеце ў зямлю, якую дасьць вам ГОСПАД, як Ён казаў, вы будзеце захоўваць служэньне гэтае. ");
INSERT INTO bel_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","I станецца, што скажуць вам сыны вашыя: “Што гэта за служэньне ў вас?\", ");
INSERT INTO bel_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","а вы адкажаце: “Гэта ахвяра — Пасха для ГОСПАДА, Які абмінуў дамы сыноў Ізраіля ў Эгіпце, калі губіў Эгіпет, а дамы нашыя захаваў”». I схіліўся народ, і пакланіўся. ");
INSERT INTO bel_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","I пайшлі, і зрабілі сыны Ізраіля; як загадаў ГОСПАД Майсею і Аарону, так і зрабілі. ");
INSERT INTO bel_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","I сталася а палове ночы, і забіў ГОСПАД усіх першародных у зямлі Эгіпецкай, ад першароднага фараона, які сядзеў на пасадзе сваім, аж да першароднага вязьня, які ў вязьніцы, і ўсіх першародных у жывёлы. ");
INSERT INTO bel_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","I ўстаў фараон уначы, сам і ўсе слугі ягоныя, і ўвесь Эгіпет; і сталася вялікае галашэньне ў Эгіпце, бо не было дому, у якім не было б памерлага. ");
INSERT INTO bel_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","I паклікаў ён Майсея і Аарона ўначы, і сказаў: «Устаньце, выйдзіце з асяродзьдзя народу майго, і вы, і таксама сыны Ізраіля, і ідзіце, служыце ГОСПАДУ, як вы казалі. ");
INSERT INTO bel_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Таксама авечак вашых, таксама валоў вашых вазьміце, як вы казалі, і ідзіце, і дабраславіце таксама мяне». ");
INSERT INTO bel_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","I прысьпешвалі Эгіпцяне народ, каб хутчэй выслаць яго з зямлі той, бо яны казалі: «Усе мы памром». ");
INSERT INTO bel_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","I панёс народ цеста сваё перш, чым яно скісла, дзежы свае, завязаныя ў шаты свае, на плячах сваіх. ");
INSERT INTO bel_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","I сыны Ізраіля зрабілі паводле слова Майсея, і пазычылі ў Эгіпцянаў начыньне срэбнае і начыньне залатое, і адзеньне. ");
INSERT INTO bel_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","I ГОСПАД даў ласку народу ў вачах Эгіпцянаў, і яны пазычалі ім; і абрабавалі яны Эгіпет. ");
INSERT INTO bel_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","I вырушылі сыны Ізраіля з Рамсэса ў Сукот у ліку каля шасьцісот тысячаў пешых мужчынаў, апрача дзяцей. ");
INSERT INTO bel_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Таксама мноства плямёнаў выйшла з імі, і авечкі, і валы, набытак вельмі вялікі. ");
INSERT INTO bel_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I сьпяклі яны з цеста, якое вынесьлі з Эгіпту, прэсныя аладкі, бо яно яшчэ ня скісла, бо яны былі выгнаныя з Эгіпту і не маглі затрымацца, і нават ежы не прыгатавалі сабе ў дарогу. ");
INSERT INTO bel_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","А час аселасьці сыноў Ізраіля, колькі яны жылі ў Эгіпце, быў чатырыста трыццаць гадоў. ");
INSERT INTO bel_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","I сталася па заканчэньні чатырыста трыццаці гадоў, што ў гэтым самы дзень выйшла ўсё войска ГОСПАДА з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Гэта ноч чуваньня для ГОСПАДА, калі Ён вывеў іх з зямлі Эгіпецкай, і гэтая самая ноч — чуваньне перад ГОСПАДАМ для ўсіх сыноў Ізраіля ў пакаленьні іхнія. ");
INSERT INTO bel_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I сказаў ГОСПАД Майсею і Аарону: «Вось пастанова Пасхі: ніякі чужынец ня будзе есьці яе. ");
INSERT INTO bel_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","А кожны слуга — чалавек, набыты за срэбра, калі ты абрэжаш яго, можа есьці яе. ");
INSERT INTO bel_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Прыхадзень і найміт ня будзе есьці яе. ");
INSERT INTO bel_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","У адным доме маеце есьці яе, не выносьце мяса вонкі з дому, і косткі яе не ламіце. ");
INSERT INTO bel_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Уся грамада Ізраіля мае рабіць гэта. ");
INSERT INTO bel_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","I калі чужынец будзе жыць з табою, і захоча ўчыніць Пасху ГОСПАДА, абрэж у яго ўсіх мужчынаў, і тады няхай наблізіцца, каб рабіць яе, і будзе ён як тутэйшы ў зямлі; але ніхто неабрэзаны ня будзе есьці яе. ");
INSERT INTO bel_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Адзін закон будзе для тутэйшага і для чужынца, што жыве сярод вас». ");
INSERT INTO bel_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","I зрабілі гэта ўсе сыны Ізраіля; як ГОСПАД загадаў Майсею і Аарону, так і зрабілі. ");
INSERT INTO bel_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","I сталася, што ў той самы дзень ГОСПАД вывеў сыноў Ізраіля з зямлі Эгіпецкай паводле дружынаў іхніх. ");
INSERT INTO bel_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Пасьвяці Мне ўсіх першародных, што адкрываюць усякае ўлоньне ў сыноў Ізраіля, у чалавека і ў жывёлы. Мае яны». ");
INSERT INTO bel_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","I сказаў Майсей народу: «Памятайце гэты дзень, у які вы выйшлі з Эгіпту, з дому няволі, бо рукою моцнаю вывеў вас ГОСПАД адгэтуль, і ня ешце кіслага. ");
INSERT INTO bel_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Сёньня вы выходзіце ў месяцы Авіў. ");
INSERT INTO bel_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","I будзе, калі ўвядзе вас ГОСПАД у зямлю Хананейца, і Хета, і Амарэя, і Хівея, і Евусэя, пра якую Ён прысягаў бацькам тваім, што дасьць табе зямлю, якая цячэ малаком і мёдам, захоўвай служэньне гэтае ў месяцы гэтым. ");
INSERT INTO bel_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Сем дзён будзеш есьці праснакі, а ў сёмы дзень — сьвята для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Праснакі будзеш есьці сем дзён; і ня будзе бачана ў цябе кіслага, і ня будзе бачана ў цябе кісьлі ў-ва ўсіх межах тваіх. ");
INSERT INTO bel_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","I распавядзеш сыну твайму ў гэты дзень, кажучы: “Гэта дзеля таго, што зрабіў ГОСПАД мне, калі я выходзіў з Эгіпту”. ");
INSERT INTO bel_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","I будзе для цябе гэта знакам на руцэ тваёй і памяткаю між вачыма тваімі, каб Закон ГОСПАДА быў на вуснах тваіх, бо рукою моцнаю вывеў цябе ГОСПАД з Эгіпту. ");
INSERT INTO bel_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","I будзеш захоўваць пастанову гэтую ў вызначаны час з году ў год. ");
INSERT INTO bel_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","I станецца, што ўвядзе цябе ГОСПАД у зямлю Хананейца, як Ён прысягаў табе і бацькам тваім, і дасьць яе табе. ");
INSERT INTO bel_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","І ты аддзеліш усё, што адкрывае ўлоньне, для ГОСПАДА, і ўсё першароднае, што адкрывае ўлоньне ў жывёлы, якое будзе тваё, мужчынскага роду — для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","І кожнага асла, які адкрывае ўлоньне, выкупіш баранчыкам; а калі ня выкупіш, зламі карак ягоны; і кожнага першароднага чалавека з сыноў сваіх выкупіш. ");
INSERT INTO bel_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","I станецца, што спытаецца ў цябе сын твой заўтра, кажучы: “Што гэта?”, і ты скажы яму: “Моцнаю рукою вывеў нас ГОСПАД з Эгіпту, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","I сталася, што зацяўся фараон, каб не адпусьціць нас, і забіў ГОСПАД усіх першародных у зямлі Эгіпецкай, ад першароднага чалавека аж да першароднага жывёлы. Дзеля гэтага я ахвярую ГОСПАДУ ўсіх самцоў, якія адкрываюць улоньне, і ўсіх першародных сыноў маіх выкупляю”. ");
INSERT INTO bel_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","I будзе гэта знакам на руцэ тваёй і павязкаю між вачэй тваіх, бо моцнаю рукою вывеў нас ГОСПАД з Эгіпту». ");
INSERT INTO bel_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","I сталася, калі адпусьціў фараон народ, не павёў іх Бог па шляху зямлі Філістынскай, хоць яна блізкая, бо сказаў Бог: «Каб не пашкадаваў народ, калі ўбачыць вайну, і не вярнуўся ў Эгіпет». ");
INSERT INTO bel_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","I павёў Бог народ шляхам пустыні да мора Чырвонага. I выйшлі збройныя сыны Ізраіля з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","I ўзяў Майсей з сабою косткі Язэпа, бо прысягаю запрысяг Язэп сыноў Ізраіля, кажучы: «Наведваючы, наведае вас Бог, і вы вынясіце з сабою косткі мае адгэтуль». ");
INSERT INTO bel_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","I вырушылі з Сукоту, і сталі табарам у Этаме, на скраю пустыні. ");
INSERT INTO bel_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","I ГОСПАД ішоў перад імі ўдзень у слупе воблачным, каб весьці іх па дарозе, а ўначы — у слупе вогненым, каб сьвяціць ім, каб маглі ісьці ўдзень і ўначы. ");
INSERT INTO bel_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Не адыходзіў слуп воблачны ўдзень і слуп вогнены ўначы ад аблічча народу. ");
INSERT INTO bel_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Скажы сынам Ізраіля, каб яны павярнуліся і сталі табарам перад Пі-Гахіротам, між Мігдолам і морам, перад Баал-Цэфонам. Насупраць яго станьце табарам каля мора. ");
INSERT INTO bel_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","I скажа фараон пра сыноў Ізраіля: “Яны заблукалі ў зямлі гэтай, замкнула іх пустыня”. ");
INSERT INTO bel_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","І Я зраблю цьвёрдым сэрца фараона, і ён пагоніцца за імі, і Я ўслаўлюся над фараонам і над усім войскам ягоным; і пазнаюць Эгіпцяне, што Я — ГОСПАД». I зрабілі гэтак. ");
INSERT INTO bel_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","I паведамілі валадару Эгіпецкаму, што народ уцёк; і павярнулася сэрца фараона і слугаў ягоных супраць народу Ізраіля, і сказалі яны: «Што гэта мы зрабілі, што адпусьцілі Ізраільцянаў са службы нам?» ");
INSERT INTO bel_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","I запрог ён калясьніцу сваю, і народ свой узяў з сабою. ");
INSERT INTO bel_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I ўзяў шэсьцьсот калясьніцаў выборных, і ўсе калясьніцы Эгіпецкія, і па тры ваяры на кожнай з іх. ");
INSERT INTO bel_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","I зацьвярдзіў ГОСПАД сэрца фараона, валадара Эгіпту, і ён пагнаўся за сынамі Ізраіля; а сыны Ізраіля выйшлі пад рукою ўзьнятаю. ");
INSERT INTO bel_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","I пагналіся Эгіпцяне за імі, і ўсе коні і калясьніцы фараона, і вершнікі ягоныя, і ўсё войска ягонае дагналі іх, калі тыя стаялі табарам каля мора, каля Пі-Гахіроту насупраць Баал-Цэфону. ");
INSERT INTO bel_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","I фараон наблізіўся, і ўзьнялі сыны Ізраіля вочы свае, і вось, Эгіпет рушыць за імі, і моцна напужаліся, і клікалі сыны Ізраіля да ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I сказалі Майсею: «Ці ж не было магілаў у Эгіпце, што ты ўзяў нас паміраць у пустыні? Што гэта ты зрабіў нам, што вывеў нас з Эгіпту? ");
INSERT INTO bel_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ці ня гэтае слова гаварылі мы табе ў Эгіпце, кажучы: “Пакінь нас, і мы будзем служыць у Эгіпцянаў”? Бо лепш нам служыць у Эгіпцянаў, чым паміраць у пустыні». ");
INSERT INTO bel_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","І сказаў Майсей народу: «Ня бойцеся! Стойце і ўбачыце збаўленьне ГОСПАДА, якое Ён учыніць для вас сёньня. Бо Эгіпцянаў, якіх вы бачыце сёньня, больш ня ўбачыце ўжо на вякі. ");
INSERT INTO bel_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ГОСПАД будзе ваяваць за вас, а вы маўчыце». ");
INSERT INTO bel_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","I сказаў ГОСПАД Майсею: «Чаго ты клічаш да Мяне? Прамоў да сыноў Ізраіля, і няхай вырушаць у дарогу. ");
INSERT INTO bel_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","А ты ўзьнімі кій твой і выцягні руку тваю на мора, і расьсячы яго, і ўвойдуць сыны Ізраіля ў сярэдзіну мора па сухому. ");
INSERT INTO bel_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","А Я, вось, зраблю цьвёрдым сэрца Эгіпцянаў, і яны ўвойдуць за імі, і Я ўслаўлюся над фараонам і над усім войскам ягоным, над калясьніцамі ягонымі і над вершнікамі ягонымі. ");
INSERT INTO bel_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","I даведаецца Эгіпет, што Я — ГОСПАД, калі Я ўслаўлюся над фараонам, над калясьніцамі ягонымі і над вершнікамі ягонымі». ");
INSERT INTO bel_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","I рушыў анёл Божы, які ішоў перад табарам Ізраіля, і пайшоў ззаду іх. І рушыў слуп воблачны ад аблічча іхняга, і стаў ззаду іх, ");
INSERT INTO bel_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","і ўвайшоў паміж табарам Эгіпецкім і табарам Ізраільскім, і быў хмарай і цемраю для адных, і асьвятляў ноч для другіх; і не наблізіліся адны да адных праз усю ноч. ");
INSERT INTO bel_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","I выцягнуў Майсей руку сваю на мора, і гнаў ГОСПАД мора гвалтоўным усходнім ветрам усю ноч, і зрабіў мора сухменем, і расьсекліся воды. ");
INSERT INTO bel_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","I прайшлі сыны Ізраіля па сярэдзіне мора па сухому, і воды былі для іх мурам праваруч іх і леваруч іх. ");
INSERT INTO bel_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","I пагналіся Эгіпцяне, і пайшлі за імі ў сярэдзіну мора ўсе коні фараона, калясьніцы ягоныя і вершнікі ягоныя. ");
INSERT INTO bel_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","I сталася ў ранішнюю варту, і глянуў ГОСПАД на табар Эгіпцянаў са слупа вогненнага і воблачнага, і зьмяшаў табар Эгіпцянаў. ");
INSERT INTO bel_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","I затрымаў колы калясьніцаў іхніх, і яны цягнулі іх з цяжкасьцю. I сказаў Эгіпет: «Уцякайма ад аблічча Ізраіля, бо ГОСПАД змагаецца за іх супраць Эгіпту!» ");
INSERT INTO bel_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","I сказаў ГОСПАД Майсею: «Выцягні руку тваю на мора, і няхай вернуцца воды на Эгіпет, на калясьніцы ягоныя і на вершнікаў ягоных». ");
INSERT INTO bel_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","I выцягнуў Майсей руку сваю на мора, і вярнула мора сілу сваю на сьвітаньні, а Эгіпцяне ўцякалі напярэймы яму; і кінуў ГОСПАД Эгіпцянаў у сярэдзіну мора. ");
INSERT INTO bel_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","I вярнуліся воды, і пакрылі калясьніцы і вершнікаў усяго войска фараона, якія ўвайшлі за імі ў мора; не засталося з іх аніводнага. ");
INSERT INTO bel_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","А сыны Ізраіля ішлі па сухому па сярэдзіне мора, і воды былі для іх мурам праваруч іх і леваруч іх. ");
INSERT INTO bel_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","I выбавіў ГОСПАД у дзень гэты Ізраіля з рукі Эгіпцянаў; і ўбачыў Ізраіль Эгіпет мёртвым на беразе мора. ");
INSERT INTO bel_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","I ўбачыў Ізраіль руку вялікую, якую зьявіў ГОСПАД над Эгіптам; і баяўся народ ГОСПАДА, і паверылі ГОСПАДУ і Майсею, слузе Ягонаму. ");
INSERT INTO bel_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Тады засьпяваў Майсей і сыны Ізраіля гэты сьпеў ГОСПАДУ, і сказалі, кажучы: «Засьпяваю ГОСПАДУ, бо, узьвялічваючыся, узьвялічыўлся Ён; каня і вершніка ягонага ўкінуў у мора. ");
INSERT INTO bel_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Сіла мая і песьня — ГОСПАД, і Ён стаўся для мяне збаўленьнем. Ён — Бог мой, і я ўслаўляю Яго, Ён — Бог бацькі майго, і я вывышаю Яго. ");
INSERT INTO bel_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ГОСПАД — Муж вайны, ГОСПАД — імя Ягонае. ");
INSERT INTO bel_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Калясьніцы фараона і войска ягонае Ён укінуў у мора, і выборныя ваяры ягоныя патанулі ў моры Чырвоным. ");
INSERT INTO bel_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Бездані пакрылі іх, яны пайшлі ў глыбіні, як камень. ");
INSERT INTO bel_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Правіца Твая, ГОСПАДЗЕ, праславілася моцаю; правіца Твая, ГОСПАДЗЕ, скрышыла ворага. ");
INSERT INTO bel_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I ў велічы маестату Твайго Ты зруйнаваў тых, што паўсталі супраць Цябе. Ты паслаў гнеў Твой, і ён спаліў іх, як салому. ");
INSERT INTO bel_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I ад подыху гневу Твайго сабраліся воды, сталіся як копы струмяні, сьселіся бездані ў сэрцы мора. ");
INSERT INTO bel_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Вораг сказаў: “Буду гнацца, даганю, падзялю здабычу; насыціцца імі душа мая, выхаплю меч мой, схопіць іх рука мая”. ");
INSERT INTO bel_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ты павеяў духам Тваім, і пакрыла іх мора. Яны патанулі, як волава, у водах магутных. ");
INSERT INTO bel_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Хто, як Ты, ГОСПАДЗЕ, між багамі? Хто, як Ты, праслаўлены ў сьвятасьці, страшны ў хвале, Той, Які робіць цуды? ");
INSERT INTO bel_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ты выцягнуў правіцу Тваю, праглынула іх зямля. ");
INSERT INTO bel_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ты вёў у міласэрнасьці Тваёй народ, які Ты адкупіў, прывёў сілаю Тваёю ў жытло сьвятасьці Тваёй. ");
INSERT INTO bel_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Пачулі народы, задрыжалі; болі ахапілі жыхароў Філістынскіх. ");
INSERT INTO bel_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Тады спалохаліся князі Эдому, моцных Мааву ахапіла дрыжаньне, млеюць усе жыхары Ханаану. ");
INSERT INTO bel_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Няхай ахопіць іх жах і баязьлівасьць. Ад вялікасьці рамяна Твайго замоўкнуць яны як камень, аж пакуль пройдзе народ Твой, ГОСПАДЗЕ, пакуль пройдзе народ гэты, які Ты набыў для Сябе. ");
INSERT INTO bel_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ты завядзеш іх і пасадзіш іх на гары спадчыны Тваёй, на месцы, якое Ты, ГОСПАДЗЕ, учыніў на жытло, сьвятыню, Госпадзе, якую ўгрунтавалі рукі Твае. ");
INSERT INTO bel_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ГОСПАД будзе валадарыць на вякі вечныя. ");
INSERT INTO bel_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Бо ўвайшоў конь фараона з калясьніцамі ягонымі і з вершнікамі ягонымі ў мора, і абрынуў ГОСПАД на іх воды мора, а сыны Ізраіля прайшлі па сухому па сярэдзіне мора». ");
INSERT INTO bel_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","I ўзяла Мірыям прарочыца, сястра Аарона, бубен у руку сваю, і выйшлі за ёю ўсе жанчыны з бубнамі і танцамі. ");
INSERT INTO bel_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","I адказала ім Мірыям: «Сьпявайце ГОСПАДУ, бо ўзьвялічваючыся, узьвялічыўся Ён; каня і вершніка ягонага ўкінуў у мора». ");
INSERT INTO bel_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","I павёў Майсей Ізраіль ад мора Чырвонага, і яны ўвайшлі ў пустыню Шур; і ішлі яны тры дні па пустыні, і не знайшлі вады. ");
INSERT INTO bel_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","I прыйшлі ў Мару, і не маглі піць ваду ў Мары, бо яна была горкая; таму назвалі яе Мара. ");
INSERT INTO bel_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","I наракаў народ на Майсея, кажучы: «Што будзем піць?» ");
INSERT INTO bel_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","I клікаў Майсей да ГОСПАДА, і паказаў яму ГОСПАД дрэва, і ён кінуў яго ў ваду, і стала салодкая вада. Там Ён даў яму пастановы і суд, і там выспрабаваў яго, ");
INSERT INTO bel_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","і сказаў: «Калі ты будзеш, слухаючы, слухаць голас ГОСПАДА, Бога твайго, і робячы, будзеш рабіць тое, што правільнае ў вачах Ягоных, і прыхіліш вуха да прыказаньняў Ягоных, і будзеш захоўваць усе пастановы Ягоныя, ніводнае з немачаў, якія Я навёў на Эгіпет, не навяду на цябе, бо Я — ГОСПАД, Лекар твой». ");
INSERT INTO bel_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","I прыйшлі яны ў Элім. Там было дванаццаць крыніцаў вады і семдзясят пальмаў; і сталі там табарам каля водаў. ");
INSERT INTO bel_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","I вырушылі з Эліму, і прыйшла ўся грамада сыноў Ізраіля ў пустыню Сін, якая паміж Элімам і Сынаем, у пятнаццаты дзень другога месяца пасьля выхаду іхняга з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","I наракала, і наракала ўся грамада сыноў Ізраіля на Майсея і Аарона ў пустыні. ");
INSERT INTO bel_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","I сказалі ім сыны Ізраіля: «Лепш бы мы памерлі ад рукі ГОСПАДА ў зямлі Эгіпецкай, калі мы сядзелі пры катлах з мясам, калі мы елі хлеб да насычэньня! Бо вы вывелі нас у гэтую пустыню, каб памерла з голаду ўся царква гэтая». ");
INSERT INTO bel_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","I сказаў ГОСПАД Майсею: «Вось, Я спашлю вам, як дождж, хлеб з неба; і выйдзе народ, і будзе зьбіраць штодня патрэбнае на дзень, каб Я выпрабаваў яго, ці будзе ён хадзіць паводле закону Майго, ці не. ");
INSERT INTO bel_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","I станецца ў шосты дзень, і прыгатуеце тое, што прынясуць, і будзе падвойная мера адносна таго, што вы зьбіралі дзень пры дні». ");
INSERT INTO bel_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","I сказаў Майсей і Аарон усім сынам Ізраіля: «Будзе вечар, і вы пазнаеце, што ГОСПАД вывеў вас з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","А будзе, раніца, і вы ўбачыце славу ГОСПАДА, бо Ён пачуў нараканьне вашае на ГОСПАДА; а мы, хто мы, што вы наракаеце і наракаеце на нас?» ");
INSERT INTO bel_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","I сказаў Майсей: «Гэта будзе, калі дасьць ГОСПАД увечары вам мяса на ежу, а раніцаю — хлеб, каб насыціцца, бо ГОСПАД пачуў нараканьне вашае, як вы наракалі на Яго. А мы, што мы? Не на нас нараканьне вашае, але на ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","I сказаў Майсей Аарону: «Скажы ўсёй грамадзе сыноў Ізраіля: “Наблізьцеся перад аблічча ГОСПАДА, бо Ён пачуў нараканьне вашае”». ");
INSERT INTO bel_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","I сталася, калі гаварыў Аарон да ўсёй грамады сыноў Ізраіля, і яны зьвярнуліся ў бок пустыні, і вось, слава ГОСПАДА зьявілася ў воблаку. ");
INSERT INTO bel_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Я пачуў нараканьне сыноў Ізраіля. Прамоў да іх, кажучы: “Адвячоркам будзеце есьці мяса, а раніцаю насыціцеся хлебам, і пазнаеце, што Я — ГОСПАД, Бог ваш”». ");
INSERT INTO bel_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","I сталася ўвечары, і наляцелі перапёлкі, і пакрылі табар, а раніцаю быў пласт расы вакол табару. ");
INSERT INTO bel_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","I падняўся пласт расы, і вось, на абліччы пустыні нешта дробнае і крупчастае, дробнае, як шэрань на зямлі. ");
INSERT INTO bel_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","I ўбачылі сыны Ізраіля, і казалі адзін аднаму: «Што гэта?» Бо ня ведалі, што гэта. I сказаў ім Майсей: «Гэта хлеб, які ГОСПАД даў вам есьці. ");
INSERT INTO bel_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Гэта слова, якое загадаў ГОСПАД: “Зьбірайце яго кожны паводле таго, колькі яму зьесьці, па гомару на галаву, паводле ліку душаў вашых. Кожны будзе зьбіраць для тых, якія ў намёце ягоным\"». ");
INSERT INTO bel_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","I зрабілі так сыны Ізраіля, і сабралі хто больш, а хто менш. ");
INSERT INTO bel_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","I мералі гомарам, і не было лішку ў таго, хто сабраў больш, і не было нястачы ў таго, хто сабраў менш. Кожны сабраў паводле таго, колькі яму зьесьці. ");
INSERT INTO bel_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","I сказаў ім Майсей: «Няхай ніхто не пакіне з яго да раніцы». ");
INSERT INTO bel_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","І не паслухалі яны Майсея, і некаторыя пакінулі з яго да раніцы; і завяліся ў ім чэрві, і яно стала сьмярдзець. І разгневаўся на іх Майсей. ");
INSERT INTO bel_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","I яны зьбіралі гэта раніцай пры раніцы, кожны паводле таго, колькі яму зьесьці. І калі прыпякала сонца, яно раставала. ");
INSERT INTO bel_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","I сталася ў шосты дзень, што сабралі хлеба падвойную меру, па два гомары на аднаго чалавека, і прыйшлі ўсе начальнікі грамады, і паведамілі Майсею. ");
INSERT INTO bel_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","I ён сказаў ім: «Гэта тое, што гаварыў ГОСПАД, заўтра супачынак, святая субота для ГОСПАДА. Што маеце пячы — пячыце, і што маеце варыць — варыце, а што застанецца, пакіньце сабе на схоў да раніцы». ");
INSERT INTO bel_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","I пакінулі гэта да раніцы, як загадаў Майсей, і яно не засьмярдзела, і чарвей не было ў ім. ");
INSERT INTO bel_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","I сказаў Майсей: «Ешце яго сёньня, бо сёньня — субота для ГОСПАДА; сёньня ня знойдзеце яго на полі. ");
INSERT INTO bel_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Шэсьць дзён будзеце зьбіраць яго; а сёмы дзень — субота, ня будзе ў ёй гэтага». ");
INSERT INTO bel_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","I сталася ў сёмы дзень, выйшлі некаторыя з народу зьбіраць, і не знайшлі. ");
INSERT INTO bel_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","I сказаў ГОСПАД Майсею: «Як доўга будзеце адмаўляцца захоўваць прыказаньні Мае і законы Мае? ");
INSERT INTO bel_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Глядзіце, бо ГОСПАД даў вам суботу; дзеля гэтага Ён дае вам у шосты дзень хлеба на два дні. Заставайцеся кожны ў сябе, няхай не выходзіць ніхто з месца свайго ў сёмы дзень». ");
INSERT INTO bel_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","I супачыў народ у сёмы дзень. ");
INSERT INTO bel_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","I назваў дом Ізраіля імя ягонае — “манна”, і яна была як насеньне каляндры, белая, а смак ягоны — як печыва з мёдам. ");
INSERT INTO bel_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","I сказаў Майсей: «Вось слова, якое загадаў ГОСПАД: “Поўны гомар пакіньце на захаваньне ў пакаленьні вашыя, каб бачылі хлеб, якім Я карміў вас у пустыні, калі вывеў вас з зямлі Эгіпецкай”». ");
INSERT INTO bel_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","I сказаў Майсей Аарону: «Вазьмі адну пасудзіну, і палажы ў яе поўны гомар манны, і пастаў яе перад абліччам ГОСПАДА на захаваньне ў пакаленьні вашыя». ");
INSERT INTO bel_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Як загадаў ГОСПАД Майсею, так паставіў яго Аарон перад Каўчэгам Сьведчаньня на захаваньне. ");
INSERT INTO bel_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","А сыны Ізраіля елі манну сорак гадоў, пакуль не прыйшлі ў зямлю абжытую; яны елі манну, пакуль не прыйшлі да межаў зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","А гомар — гэта дзясятая частка эфы. ");
INSERT INTO bel_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","I вырушыла ўся грамада сыноў Ізраіля з пустыні Сін у падарожжы свае, паводле слова з вуснаў ГОСПАДА, і сталі табарам у Рэфідыме, і не было вады, каб піць народу. ");
INSERT INTO bel_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","I спрачаўся народ з Майсеем, і сказалі: «Дайце нам вады, і будзем піць». I сказаў ім Майсей: «Што вы спрачаецеся са мною? Што выпрабоўваеце ГОСПАДА?». ");
INSERT INTO bel_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","I смагнуў там народ вады, і наракаў народ на Майсея, і сказаў: «Навошта ты вывеў нас з Эгіпту? Каб памерлі ад смагі я, і сыны мае, і статак мой?» ");
INSERT INTO bel_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","I клікаў Майсей да ГОСПАДА, кажучы: «Што мне рабіць з народам гэтым? Яшчэ крыху, і яны ўкамянуюць мяне». ");
INSERT INTO bel_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","I сказаў ГОСПАД Майсею: «Прайдзі перад абліччам народу, і вазьмі з сабою старшыняў Ізраіля, і кій твой, якім ты ўдарыў раку, возьмеш у руку тваю, і пойдзеш. ");
INSERT INTO bel_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Вось, Я стану перад абліччам тваім там на скале на Харэве, і ты ўдарыш у скалу, і выйдзе з яе вада, і будзе піць народ». I зрабіў так Майсей на вачах старшыняў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","I назваў імя месца таго — Маса і Мэрыва, таму што сварыліся сыны Ізраіля і таму што яны выпрабоўвалі ГОСПАДА, кажучы: «Ці ёсьць ГОСПАД сярод нас, ці не?» ");
INSERT INTO bel_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","I прыйшоў Амалек, і ваяваў з Ізраілем у Рэфідыме. ");
INSERT INTO bel_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","I сказаў Майсей Егошуа: «Выбяры нам мужоў і ідзі, каб ваяваць з Амалекам. Заўтра я стану на вяршыні ўзгорку, і кій Божы будзе ў руцэ маёй». ");
INSERT INTO bel_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","I зрабіў Егошуа так, як сказаў яму Майсей, каб ваяваць з Амалекам; а Майсей, Аарон і Хур узыйшлі на вяршыню ўзгорку. ");
INSERT INTO bel_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","I было, што калі Майсей падымаў руку сваю, перамагаў Ізраіль; а калі апускаў руку сваю, перамагаў Амалек. ");
INSERT INTO bel_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","І рукі Майсея сталіся цяжкімі; і ўзялі камень, і падлажылі пад яго; і ён сеў на ім. І Аарон і Хур падпіралі рукі ягоныя, адзін з аднаго, а другі — з другога боку. I рукі ягоныя былі ўзьнятыя аж да заходу сонца. ");
INSERT INTO bel_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","I перамог Егошуа Амалека і народ ягоны лязом мяча. ");
INSERT INTO bel_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","I сказаў ГОСПАД Майсею: «Запішы гэта на памятку ў кнігу, і ўлажы ў вушы Егошуа, што Я вынішчаючы, вынішчу памяць пра Амалека пад небам!». ");
INSERT INTO bel_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","I пабудаваў Майсей ахвярнік, і назваў імя яго: “ГОСПАД — сьцяг мой”. ");
INSERT INTO bel_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","І сказаў ён: «Бо рука на пасадзе ГОСПАДА, што вайна ў ГОСПАДА з Амалекам з пакаленьня ў пакаленьне». ");
INSERT INTO bel_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","I пачуў Етра, сьвятар Мадыянскі, цесьць Майсея, пра ўсё, што зрабіў Бог для Майсея і Ізраіля, народу Свайго, бо вывеў ГОСПАД Ізраіля з Эгіпту. ");
INSERT INTO bel_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","I ўзяў Етра, цесьць Майсея, Цыпору, жонку Майсея, якую той быў адаслаўшы, ");
INSERT INTO bel_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","і двух сыноў ейных, у якіх аднаго імя — Гершом, бо казаў Майсей: «Я стаўся прыхаднем у зямлі чужой», ");
INSERT INTO bel_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","а імя другога — Эліезэр, бо казаў: «Бог бацькі майго быў дапамогай маёй і выбавіў мяне ад мяча фараона». ");
INSERT INTO bel_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","I прыйшоў Етра, цесьць Майсея, і сыны ягоныя, і жонка ягоная да Майсея ў пустыню, дзе ён стаяў табарам каля гары Божай, ");
INSERT INTO bel_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","і сказаў Майсею: «Я, цесьць твой Етра, прыйшоў да цябе, і жонка твая, і два сыны ейныя з ёю». ");
INSERT INTO bel_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","I выйшаў Майсей насустрач цесьцю свайму, і пакланіўся, і пацалаваў яго, і пыталіся адзін у аднаго, як маюцца, і ўвайшлі ў намёт. ");
INSERT INTO bel_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","I распавёў Майсей цесьцю свайму пра ўсё, што зрабіў ГОСПАД з фараонам і Эгіптам з прычыны Ізраіля, і пра ўсе цяжкасьці, якія напаткалі іх у дарозе, і як выбавіў іх ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","I радаваўся Етра з усяго дабра, якое ГОСПАД зрабіў для Ізраіля, калі выбавіў яго з рукі Эгіпцянаў. ");
INSERT INTO bel_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","I сказаў Етра: «Дабраслаўлёны ГОСПАД, Які выбавіў вас з рукі Эгіпцянаў і з рукі фараона, Які выбавіў народ з-пад рукі Эгіпцянаў. ");
INSERT INTO bel_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Цяпер я ведаю, што большы ГОСПАД за ўсіх багоў, бо ў той справе, у якой яны выхваляліся, Ён быў па-над імі». ");
INSERT INTO bel_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","I ўзяў Етра, цесьць Майсея, цэласпаленьне і ахвяры для Бога, і прыйшоў Аарон і ўсе старшыні Ізраіля, каб есьці хлеб з цесьцем Майсея перад абліччам Бога. ");
INSERT INTO bel_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","I сталася назаўтра, і сеў Майсей судзіць народ, і стаяў народ перад Майсеем з раніцы да вечара. ");
INSERT INTO bel_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","I бачыў цесьць Майсея ўсё, што ён рабіў для народу, і сказаў: «Што гэта за справа, якую ты робіш для народу? Дзеля чаго ты сядзіш сам адзін, а ўвесь народ стаіць перад табою з раніцы да вечара?» ");
INSERT INTO bel_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","I сказаў Майсей цесьцю свайму: «Бо прыходзіць народ да мяне, каб пытацца ў Бога. ");
INSERT INTO bel_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Бо калі яны маюць нейкую справу, прыходзяць да мяне, і я суджу паміж адным чалавекам і другім, і абвяшчаю пастановы Божыя і законы Ягоныя». ");
INSERT INTO bel_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","I сказаў цесьць Майсея яму: «Нядобрая гэтая рэч, якую ты робіш. ");
INSERT INTO bel_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Мучаешся ты і мучаеш народ гэты, які з табою; бо цяжкая для цябе справа гэтая, ты ня можаш рабіць яе сам адзін. ");
INSERT INTO bel_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Цяпер паслухай голас мой; я дам табе раду, і будзе Бог з табою. Ты будзь заступнікам за народ перад Богам і прынось Богу справы гэтыя. ");
INSERT INTO bel_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","I ты навучай іх пастановам і законам, і дай ім ведаць шлях, па якім яны маюць ісьці, і ўчынкі, якія яны маюць рабіць. ");
INSERT INTO bel_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","I ты выглядзі з усяго народу людзей здольных, якія баяцца Бога, людзей праўды, якія ненавідзяць хцівасьць, і пастаў іх як начальнікаў над тысячамі, начальнікаў над сотнямі, начальнікаў над пяцідзясяткамі і начальнікаў над дзясяткамі. ");
INSERT INTO bel_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","I няхай яны судзяць народ у кожным часе. І станецца, што кожную справу вялікую яны будуць прыносіць да цябе, а кожную справу малую будуць судзіць самі. І будзе табе лягчэй, і яны панясуць цяжар з табою. ");
INSERT INTO bel_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Калі гэтую рэч зробіш, і Бог загадае гэта табе, ты зможаш стаяць, і таксама ўвесь народ гэты прыйдзе на сваё месца ў супакоі». ");
INSERT INTO bel_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","I паслухаў Майсей голасу цесьця свайго, і зрабіў усё, што той сказаў. ");
INSERT INTO bel_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","I выбраў Майсей людзей здольных з усяго Ізраіля, і прызначыў іх галоўнымі над народам, начальнікамі над тысячамі, начальнікамі над сотнямі, начальнікамі над пяцідзясяткамі і начальнікамі над дзесяткамі. ");
INSERT INTO bel_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","I судзілі яны народ у кожным часе, справу цяжкую прыносілі да Майсея, а кожную справу малую судзілі самі. ");
INSERT INTO bel_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","I адпусьціў Майсей цесьця свайго, і той пайшоў у зямлю сваю. ");
INSERT INTO bel_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","У трэці месяц пасьля выхаду сыноў Ізраіля з зямлі Эгіпецкай, у першы дзень прыйшлі яны ў пустыню Сынай. ");
INSERT INTO bel_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","I вырушылі яны з Рэфідыму, і прыйшлі ў пустыню Сынай, і сталі табарам у пустыні; і стаў табарам там Ізраіль насупраць гары. ");
INSERT INTO bel_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","А Майсей узыйшоў да Бога, і паклікаў яго ГОСПАД з гары, кажучы: «Гэтак скажы дому Якуба і паведамі сынам Ізраіля: ");
INSERT INTO bel_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Вы бачылі, што Я зрабіў Эгіпту, а вас насіў на крылах арліных, і прынёс вас да Сябе. ");
INSERT INTO bel_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","І цяпер, калі вы, слухаючы, будзеце слухаць голас Мой і будзеце захоўваць запавет Мой, дык вы будзеце Маёй уласнасьцю з усіх народаў, бо Мая ўся зямля. ");
INSERT INTO bel_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","І вы будзеце Маім валадарствам сьвятароў і народам сьвятым”. Гэта словы, якія ты прамовіш да сыноў Ізраіля». ");
INSERT INTO bel_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","I прыйшоў Майсей, і паклікаў старшыняў народу, і прадставіў перад імі ўсе тыя словы, якія загадаў яму ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","I адказаў увесь народ разам, і сказалі: «Усё, што сказаў ГОСПАД, зробім». I перадаў Майсей ГОСПАДУ словы народу. ");
INSERT INTO bel_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","I сказаў ГОСПАД Майсею: «Вось, Я прыйду да цябе ў густым воблаку, каб чуў народ, як Я буду гаварыць з табою, і каб таксама паверылі табе на вякі». I пераказаў Майсей ГОСПАДУ словы народу. ");
INSERT INTO bel_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","I сказаў ГОСПАД Майсею: «Ідзі да народу і асьвяці яго сёньня і заўтра; і няхай памыюць адзеньне сваё, ");
INSERT INTO bel_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","і няхай будуць гатовыя да трэцяга дня; бо ў трэці дзень зыйдзе ГОСПАД перад вачыма ўсяго народу на гару Сынай. ");
INSERT INTO bel_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I правядзі мяжу народу наўкола, кажучы: “Сьцеражыцеся, каб узыходзіць на гару і дакранацца да краю яе; кожны, хто дакранецца да гары, сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Няхай не дакранецца да яе рука, бо камянуючы, укамянуюць яго альбо прабіваючы, праб’юць стралою; жывёла гэта ці чалавек, ня будуць жыць”. Калі працягла затрубіць рог, могуць узыйсьці на гару». ");
INSERT INTO bel_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","I зыйшоў Майсей з гары да народу, і асьвяціў народ, і яны памылі адзеньне сваё. ");
INSERT INTO bel_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","I сказаў народу: «Будзьце гатовыя да трэцяга дня; не набліжайцеся да жанчыны». ");
INSERT INTO bel_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","I сталася ў трэці дзень, прыйшла раніца, і былі грымоты, і маланкі, і воблака цяжкае над гарою, і гук трубы вельмі моцны; і задрыжаў увесь народ, які быў у табары. ");
INSERT INTO bel_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","I вывеў Майсей народ з табару насустрач Богу, і стаялі ля падножжа гары. ");
INSERT INTO bel_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","А гара Сынай уся дымілася, бо зыйшоў на яе ГОСПАД у агні; і ўзыходзіў ад яе дым, як дым з печы, і ўся гара вельмі хісталася. ");
INSERT INTO bel_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","I быў гук трубы, і павялічваўся, і мацнеў. Майсей гаварыў, а Бог адказаваў яму голасам. ");
INSERT INTO bel_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","I зыйшоў ГОСПАД на гару Сынай, на вяршыню гары, і паклікаў ГОСПАД Майсея на вяршыню гары, і ўзыйшоў Майсей. ");
INSERT INTO bel_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","I сказаў ГОСПАД Майсею: «Зыйдзі, папярэдзь народ, каб ня рваўся да ГОСПАДА, каб убачыць, і не загінула з яго мноства. ");
INSERT INTO bel_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","I таксама сьвятары, якія набліжаюцца да ГОСПАДА, няхай асьвяцяцца, каб ня выгубіў іх ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","I сказаў Майсей ГОСПАДУ: «Ня можа народ узыйсьці на гару Сынай, бо Ты папярэдзіў нас, кажучы: “Правядзі мяжу наўкола гары і асьвяці яе”». ");
INSERT INTO bel_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","I сказаў яму ГОСПАД: «Ідзі, зыйдзі і ўзыйдзі ты і Аарон з табою; а сьвятары і народ няхай ня рвуцца ўзыйсьці да ГОСПАДА, каб Я ня выгубіў іх». ");
INSERT INTO bel_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","I зыйшоў Майсей да народу і сказаў ім. ");
INSERT INTO bel_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","I прамовіў Бог усе словы гэтыя, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Я — ГОСПАД, Бог твой, Які вывеў цябе з зямлі Эгіпецкай, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ня будзеш мець іншых багоў перад абліччам Маім. ");
INSERT INTO bel_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Не рабі сабе статуі і ніякай выявы таго, што на небе высока, і што на зямлі нізка, і што ў вадзе ніжэй зямлі. ");
INSERT INTO bel_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ня будзеш пакланяцца ім і ня будзеш служыць ім, бо Я — ГОСПАД, Бог твой, Бог зайздросны, Які карае за беззаконьні бацькоў дзяцей да трэцяга і аж да чацьвёртага пакаленьня тых, што ненавідзяць Мяне, ");
INSERT INTO bel_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","і Які чыніць міласэрнасьць тысячам пакаленьняў тых, што любяць Мяне і захоўваюць прыказаньні Мае. ");
INSERT INTO bel_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ня будзеш ужываць імя ГОСПАДА, Бога твайго, для марноты, бо ГОСПАД не пакіне без пакараньня таго, хто ўжывае імя Ягонае для марноты. ");
INSERT INTO bel_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Памятай дзень супачынку, каб сьвяціць яго. ");
INSERT INTO bel_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Шэсьць дзён будзеш працаваць і будзеш рабіць усю работу тваю, ");
INSERT INTO bel_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","а дзень сёмы — супачынак для ГОСПАДА, Бога твайго. Ня будзеш рабіць ніякай работы ты і сын твой, і дачка твая, слуга твой і служка твая, і жывёла твая, і прыхадзень твой, які ў брамах тваіх, ");
INSERT INTO bel_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","бо за шэсьць дзён зрабіў ГОСПАД неба і зямлю, мора і ўсё, што ў іх, і спыніўся ў дзень сёмы. Дзеля гэтага дабраславіў ГОСПАД дзень супачынку і асьвяціў яго. ");
INSERT INTO bel_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Шануй бацьку твайго і маці тваю, каб працягнуліся дні твае на зямлі, якую ГОСПАД, Бог твой, дае табе. ");
INSERT INTO bel_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ня будзеш забіваць як забойца. ");
INSERT INTO bel_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ня будзеш чужаложыць. ");
INSERT INTO bel_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ня будзеш красьці. ");
INSERT INTO bel_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ня будзеш сьведчыць супраць бліжняга твайго сьведчаньнем фальшывым. ");
INSERT INTO bel_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ня будзеш жадаць дому бліжняга твайго; ня будзеш жадаць жонкі бліжняга твайго, ані слугі ягонага, ані служкі ягонай, ані вала ягонага, ані асла ягонага, ані нічога, што ў бліжняга твайго!» ");
INSERT INTO bel_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","I ўвесь народ глядзеў на грымоты і бліскавіцы, і гук трубы, і гару, якая дымілася; і, глядзеў народ, і хістаўся, і стаяў здалёк. ");
INSERT INTO bel_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","I сказалі яны Майсею: «Ты прамаўляй да нас, і мы будзем слухаць; але няхай не прамаўляе да нас Бог, каб нам не памерці». ");
INSERT INTO bel_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","I сказаў Майсей народу: «Ня бойцеся, бо дзеля таго, каб выпрабаваць вас, прыйшоў Бог, і каб праз гэта страх Ягоны быў перад абліччам вашым, каб вы не грашылі». ");
INSERT INTO bel_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","I стаяў народ здалёк, а Майсей наблізіўся да імглы, туды, дзе Бог. ");
INSERT INTO bel_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","I сказаў ГОСПАД Майсею: «Гэтак скажаш сынам Ізраіля: “Вы бачылі, што Я з неба прамаўляў да вас. ");
INSERT INTO bel_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Не рабіце побач са Мною багоў срэбных, і багоў залатых не рабіце сабе. ");
INSERT INTO bel_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ахвярнік з зямлі зрабі для Мяне, і ахвяруй на ім цэласпаленьні твае і мірныя ахвяры твае, і авечак тваіх, і валоў тваіх. На кожнае месца, дзе Я ўзгадаю імя Маё, Я прыйду да цябе і дабраслаўлю цябе. ");
INSERT INTO bel_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","А калі ахвярнік з камянёў зробіш для Мяне, не будуй яго з чэсаных камянёў, бо калі апрацуеш яго мячом сваім, апаганіш яго. ");
INSERT INTO bel_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","I ня будзеш узыходзіць па прыступках да ахвярніка Майго, каб не была адкрытая пры ім голасьць твая”. ");
INSERT INTO bel_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","А вось суды, якія ты паставіш перад абліччам іхнім. ");
INSERT INTO bel_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Калі купіш слугу Гебрая, шэсьць гадоў няхай ён служыць, а ў сёмы год няхай выйдзе на волю дарма. ");
INSERT INTO bel_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Калі ён адзін прыйшоў, няхай адзін і выйдзе. А калі ён жанаты, няхай выйдзе з ім жонка ягоная. ");
INSERT INTO bel_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Калі гаспадар ягоны даў яму жонку, і яна нарадзіла яму сыноў альбо дочак, дык жонка і дзеці ейныя застануцца ў гаспадара ейнага, а ён выйдзе адзін. ");
INSERT INTO bel_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Але калі, кажучы, скажа слуга: “Люблю гаспадара майго, жонку маю і сыноў маіх; не пайду на волю”, ");
INSERT INTO bel_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","тады прывядзе яго гаспадар ягоны да Бога, і прывядзе яго да дзьвярэй або да вушака, і праколе яму гаспадар ягоны вуха ягонае шылам, і ён застанецца слугою ягоным на вякі. ");
INSERT INTO bel_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","І калі нейкі чалавек прадасьць дачку сваю як служку, няхай ня выйдзе яна, як выходзяць слугі. ");
INSERT INTO bel_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Калі ліхая яна ў вачах гаспадара ейнага, які не заручыўся з ёю, няхай дазволіць выкупіць яе; а чужому народу ня мае ўлады яе прадаць, калі адмовіцца ад яе. ");
INSERT INTO bel_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","А калі для сына свайго ён заручыць яе, няхай робіць з ёю паводле права адносна дочак. ");
INSERT INTO bel_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Калі іншую возьме сабе, няхай ня зьменшыць жыўленьня ейнага, адзеньня ейнага і супольнага ложку. ");
INSERT INTO bel_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","А калі ён гэтых трох рэчаў ня зробіць для яе, няхай яна адыйдзе дарма, бяз выкупу. ");
INSERT INTO bel_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Той, хто ўдарыў чалавека, і той памёр, няхай сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Але калі ён ня меў намеру, але Бог выдаў таго чалавека ў руку ягоную, Я вызначу табе месца, куды ён мае ўцякаць. ");
INSERT INTO bel_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","А калі хто намысьліў супраць бліжняга свайго, каб забіць яго падступна, ад ахвярніка Майго возьмеш яго на сьмерць. ");
INSERT INTO bel_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Той, хто ўдарыць бацьку свайго і маці сваю, няхай сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","I той, хто ўкраў чалавека і прадаў яго, альбо ён знойдзены ў руцэ ягонай, няхай сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Той, хто праклінае бацьку свайго і маці сваю, няхай сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","I калі людзі спрачаюцца, і ўдарыць чалавек бліжняга свайго камянём альбо кулаком, і той не памрэ, але зьляжа ў ложак, ");
INSERT INTO bel_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","дык калі ён устане і будзе выходзіць навонкі з кійком сваім, той, хто ўдарыў, будзе без пакараньня, толькі няхай аддасьць яму за перапынак у працы і, лечачы, няхай вылечыць яго. ");
INSERT INTO bel_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","А калі хто будзе біць слугу свайго альбо служку сваю кіем, і яны памруць пад рукою ягонай, няхай помстай адпомсьціцца яму. ");
INSERT INTO bel_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Але калі яны дзень або два дні застануцца жыць, ён ня мае быць помшчаны, бо гэта срэбра ягонае. ");
INSERT INTO bel_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Калі будуць біцца мужчыны і ўдараць цяжарную жанчыну, і яна спароніць дзіця сваё, але ня будзе іншай шкоды, вінаваты будзе пакараны пакараньнем, якое наложыць на яго муж той жанчыны, і мае заплаціць пры судзьдзях. ");
INSERT INTO bel_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","А калі будзе шкода, аддасі душу за душу, ");
INSERT INTO bel_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","вока за вока, зуб за зуб, руку за руку, нагу за нагу, ");
INSERT INTO bel_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","апёк за апёк, рану за рану, сіняк за сіняк. ");
INSERT INTO bel_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","I калі хто ўдарыць у вока слугу свайго альбо ў вока служку сваю, і пашкодзіць яго, няхай адпусьціць іх на волю за вока. ");
INSERT INTO bel_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","А калі выб’е зуб слузе свайму або зуб служцы сваёй, няхай адпусьціць іх на волю за зуб. ");
INSERT INTO bel_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","I калі вол забадае мужчыну альбо жанчыну, і яны памруць, вала, камянуючы, трэба ўкаменаваць, і мяса ягонага ня есьці; а гаспадар вала невінаваты. ");
INSERT INTO bel_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","А калі вол бадлівы быў і ўчора, і пазаўчора, і папярэджвалі ўласьніка ягонага, і ён не пільнаваў яго, а ён забіў мужчыну альбо жанчыну, тады вол будзе ўкаменаваны і ўласьнік ягоны таксама памрэ. ");
INSERT INTO bel_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Калі выкуп прызначаць яму, няхай дасьць выкуп за душу сваю, які прызначаны яму. ");
INSERT INTO bel_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Калі сына забадае, або дачку забадае, паводле гэтага суду ўчыніць з ім. ");
INSERT INTO bel_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Калі слугу альбо служку забадае вол, тады трыццаць сыкляў срэбра даць пану іхняму, а вол будзе ўкаменаваны. ");
INSERT INTO bel_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","I калі хто адкрые яму, альбо калі выкапае яму і не накрые яе, і ўваліцца ў яе вол або асёл, ");
INSERT INTO bel_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","тады гаспадар ямы мае заплаціць, аддаць срэбра ўласьніку іхняму, а мёртвая жывёла будзе ягонай. ");
INSERT INTO bel_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","А калі забадае вол нейкага чалавека вала бліжняга ягонага, і той памрэ, няхай прададуць жывога вала і падзеляць папалам срэбра за яго, і таксама мёртвага няхай падзеляць папалам. ");
INSERT INTO bel_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","А калі вядома было, што вол бадлівы і ўчора, і пазаўчора, але ўласьнік ягоны не пільнаваў яго, тады мае ён заплаціць вала за вала, а мёртвы будзе ягоны. ");
INSERT INTO bel_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Калі хто ўкрадзе вала або ягня, і зарэжа яго або прадасьць яго, тады пяць валоў заплаціць за вала і чатыры авечкі — за ягня. ");
INSERT INTO bel_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Калі пры падкопаваньні будзе знойдзены злодзей, і будзе біты, і памрэ, тады няма віны крыві за яго. ");
INSERT INTO bel_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Калі ўзыйшло над ім сонца, будзе віна крыві за яго. Плацячы, мае заплаціць злодзей, а калі ня мае чым заплаціць, няхай прададуць яго за ўкрадзенае ім. ");
INSERT INTO bel_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Калі шукаючы, знойдуць украдзенае ў руцэ ягонай ад вала аж да асла і да ягняці, і яны жывыя, няхай заплаціць падвойна. ");
INSERT INTO bel_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Калі хто спасьвіў поле або вінаграднік, і пусьціў статак свой, і пасьвіць на полі іншага, няхай заплаціць найлепшым з поля свайго і найлепшым з вінаградніку свайго. ");
INSERT INTO bel_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Калі выйдзе агонь і ахопіць цярніну, і пажарэ снапы, або збожжа, або поле, тады плацячы, заплаціць той, хто запаліў агонь. ");
INSERT INTO bel_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Калі хто дасьць бліжняму свайму срэбра альбо рэчы на захаваньне, і яны будуць украдзеныя з дому таго чалавека, калі будзе знойдзены злодзей, няхай заплаціць падвойна. ");
INSERT INTO bel_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","А калі ня будзе знойдзены злодзей, тады наблізіцца гаспадар дому да Бога, і скажа, што ня выцягнуў рукі сваёй на ўласнасьць бліжняга свайго. ");
INSERT INTO bel_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Пра ўсялякую рэч, пра якую няма згоды, пра вала, пра асла, пра авечку, пра плашч, пра ўсялякую згубу, пра якую нехта скажа, што яна яго, справа абодвух мае прыйсьці да Бога. Каго прызнае вінным Бог, той заплаціць бліжняму свайму падвойна. ");
INSERT INTO bel_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Калі хто дасьць бліжняму свайму асла, альбо вала, альбо ягня, альбо якую іншую скаціну на захаваньне, а яна здохне, або будзе скалечана, або ўзята ў палон, і ніхто гэтага ня бачыў, ");
INSERT INTO bel_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","тады прысяга перад ГОСПАДАМ няхай будзе між абодвума, што той, што захоўваў, ня выцягнуў рукі сваёй на ўласнасьць бліжняга свайго; і прыйме гэтую прысягу гаспадар ейны, і той, што захоўваў, ня будзе плаціць. ");
INSERT INTO bel_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","А калі, крадучы, украдуць у яго, тады заплаціць гаспадару ейнаму. ");
INSERT INTO bel_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Калі разьдзіраючы, разьдзярэ яе дзікі зьвер, тады як сьведчаньне прынясе разьдзёртае, і ня будзе плаціць. ");
INSERT INTO bel_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","І калі хто пазычыць у бліжняга свайго жывёлу, і яна будзе скалечана або здохне, а гаспадара ейнага не было пры ёй, тады, плацячы, заплаціць за яе. ");
INSERT INTO bel_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","А калі гаспадар ейны быў пры ёй, тады ня будзе плаціць. Калі яна нанята была за грошы, тады атрымае цану найму. ");
INSERT INTO bel_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Калі хто зьвядзе дзяўчыну, якая не заручаная, і будзе ляжаць з ёю, мае заплаціць вена і ўзяць яе сабе за жонку. ");
INSERT INTO bel_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","А калі бацька ейны, адмаўляючыся, адмовіцца выдаць яе за яго, няхай адважыць срэбра паводле вена дзяўчыны. ");
INSERT INTO bel_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Варажбіткі не пакінеш пры жыцьці. ");
INSERT INTO bel_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Кожны, хто ляжа са скацінаю, няхай сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Той, хто складае ахвяры багам, апрача адзінага ГОСПАДА, будзе аддадзены закляцьцю. ");
INSERT INTO bel_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","А прыхадня ня будзеш крыўдзіць, і ня будзеш уціскаць яго, бо вы самі былі прыхаднямі ў зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ніякай удавы і сіраты ня будзеш прыгнятаць. ");
INSERT INTO bel_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Калі ты, прыгнятаючы, будзеш прыгнятаць іх, тады яны крыкам будуць клікаць да Мяне, і Я слухаючы, выслухаю крык іхні, ");
INSERT INTO bel_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","і ўзгарыцца гнеў Мой, і Я заб’ю вас мячом, і будуць жонкі вашыя ўдовамі, і дзеці вашыя — сіротамі. ");
INSERT INTO bel_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Калі пазычыш грошы чалавеку з народу Майго, беднаму, які ў цябе, ня будзеш для яго як ліхвяр, не накладай на яго адсоткаў. ");
INSERT INTO bel_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Калі, беручы ў заклад, возьмеш у заклад плашч бліжняга твайго, да заходу сонца зьвернеш яму, ");
INSERT INTO bel_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","бо гэта — адзінае накрыцьцё ў яго, якім накрываецца ён, гэта — адзеньне для скуры ягонай. На чым будзе ён спаць? І станецца, што ён будзе клікаць да Мяне, і Я пачую, бо Я — міласэрны. ");
INSERT INTO bel_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Бога не праклінай, і начальніка ў народзе сваім не кляні. ");
INSERT INTO bel_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Не марудзь з ахвярамі са шчодрасьці току твайго і тоўчні тваёй. Першароднага з сыноў тваіх аддасі Мне. ");
INSERT INTO bel_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Гэтаксама зробіш з валом тваім і з авечкаю тваёй. Сем дзён няхай яны будуць пры матцы сваёй, а ў восьмы дзень аддасі іх Мне. ");
INSERT INTO bel_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","I вы будзеце сьвятымі людзьмі для Мяне; і мяса, разьдзёртага ў полі, ня ешце; сабакам кідайце яго. ");
INSERT INTO bel_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ня будзеш разносіць весткі марнай, і не давай рукі тваёй бязбожніку, каб быць сьведкам няправасьці. ");
INSERT INTO bel_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Не станавіся з большасьцю, каб рабіць зло, і не адказвай у справе судовай, прыхіляючыся да большасьці, калі гэта перакручвае праўду. ");
INSERT INTO bel_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","I ўбогаму не патурай у справе судовай. ");
INSERT INTO bel_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Калі сустрэнеш вала ворага твайго альбо асла ягонага, якія заблукалі, вяртаючы, зьвярні яго яму. ");
INSERT INTO bel_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Калі ўбачыш, што асёл ненавісьніка твайго ўпаў пад цяжарам сваім, не дазволь сабе пакінуць яго, але застаючыся, застанься з ім. ");
INSERT INTO bel_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ня будзеш перакручваць суд беднага твайго ў судовай справе ягонай. ");
INSERT INTO bel_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ад слова фальшывага будзь далёка, і не забівай нявіннага і праведнага, бо Я не апраўдаю бязбожніка. ");
INSERT INTO bel_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Дароў не бяры, бо дар засьляпляе відушчых і перакручвае словы праведных. ");
INSERT INTO bel_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","I прыхадня не ўціскай, таму што вы ведаеце душу прыхадня, бо самі былі прыхаднямі ў зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","I шэсьць гадоў засявай зямлю тваю і зьбірай ураджай ейны, ");
INSERT INTO bel_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","а ў сёмы год запусьці яе і пакінь яе, і будуць жывіцца з яе бедныя народу твайго, а рэштаю пасьля іх будуць жывіцца зьвяры палявыя. Так зробіш з вінаграднікам тваім і з аліўнікам тваім. ");
INSERT INTO bel_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Шэсьць дзён будзеш рабіць справы твае, а ў дзень сёмы супачынеш, каб спыніўся вол твой і асёл твой, і адпачыў сын служкі тваёй і прыхадзень. ");
INSERT INTO bel_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","I ўсё, што Я сказаў вам, захоўвайце, і імя багоў іншых ня ўзгадвайце, няхай ня будзе чуваць яго з вуснаў тваіх. ");
INSERT INTO bel_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Тройчы ў год будзеш сьвяткаваць сьвяты Мае. ");
INSERT INTO bel_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Сьвята Праснакоў будзеш захоўваць. Сем дзён будзеш есьці праснакі, як Я загадаў табе, у вызначаным часе месяца Авіў, бо ў гэты час ты выйшаў з Эгіпту. І не зьяўляйцеся перад аблічча Маё з пустымі рукамі. ");
INSERT INTO bel_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","I Сьвята Жніва пяршынаў працы тваёй, якія ты сеяў на полі, і Сьвята Збору ўраджаю пры заканчэньні году, калі зьбярэш працу тваю з поля. ");
INSERT INTO bel_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Тройчы ў год мае зьяўляцца кожны мужчына твой перад аблічча Госпада ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Не ахвяроўвай над кіслым крыві ахвяры Маёй, і не пакідай на ноч тлушч сьвяточны да раніцы. ");
INSERT INTO bel_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Першыя пяршыны зямлі тваёй прынось у дом ГОСПАДА, Бога твайго. Не вары казьляняці ў малацэ маці ягонай. ");
INSERT INTO bel_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Вось, Я пасылаю перад табою анёла, каб ён захоўваў цябе ў дарозе і ўвёў цябе ў месца, якое Я падрыхтаваў. ");
INSERT INTO bel_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Сьцеражыся перад абліччам ягоным і слухайся голасу ягонага; ня будзь горкім для яго, бо ён не даруе віны вашай, бо імя Маё ў ім. ");
INSERT INTO bel_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Калі ты, слухаючы, будзеш слухаць голас ягоны і зробіш усё, што Я прамоўлю, Я буду ворагам ворагаў тваіх і буду ўціскаць тых, што ўціскаюць цябе. ");
INSERT INTO bel_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Калі пойдзе анёл Мой перад табою, і прывядзе цябе да Амарэя, Хета, Пэрэзэя, Хананейца, Хівея і Евусэя, і Я выгублю іх, ");
INSERT INTO bel_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","не пакланяйся багам іхнім, і не служы ім, і не рабі паводле ўчынкаў іхніх, але руйнуючы, зруйнуй іх, і крышачы, скрышы слупы іхнія. ");
INSERT INTO bel_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","I служыце ГОСПАДУ, Богу вашаму, і Ён дабраславіць хлеб твой і ваду тваю; і Я аддалю хваробы спасярод цябе. ");
INSERT INTO bel_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ня будзе той, якая спароніць, і бясплоднай у зямлі тваёй; лік дзён тваіх Я напоўню. ");
INSERT INTO bel_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Жах Мой Я пашлю перад табою і стрывожу кожны народ, да якога ты выйдзеш супраць яго, і павярну да цябе каркам усіх ворагаў тваіх. ");
INSERT INTO bel_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I пашлю перад табою шаршанёў, і яны выганяць перад табою Хівея, Хананейца і Хета. ");
INSERT INTO bel_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ня выганю іх перад абліччам тваім за адзін год, каб зямля ня сталася пусткаю і не памножыліся супраць цябе зьвяры палявыя. ");
INSERT INTO bel_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Памалу, памалу буду праганяць іх перад абліччам тваім, аж пакуль ты не памножышся і ня возьмеш у спадчыну зямлю гэтую. ");
INSERT INTO bel_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","І Я пастаўлю мяжу тваю ад Мора Чырвонага аж да Мора Філістынскага і ад пустыні аж да Ракі; бо дам у рукі вашыя жыхароў зямлі гэтай, і ты выганіш іх ад аблічча твайго. ");
INSERT INTO bel_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Не заключай запавету ані з імі, ані з багамі іхнімі. ");
INSERT INTO bel_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Няхай не жывуць яны ў зямлі тваёй, каб яны не ўвялі цябе ў грэх супраць Мяне; бо калі ты будзеш служыць багам іхнім, гэта станецца для цябе пасткаю». ");
INSERT INTO bel_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","I сказаў Госпад Майсею: «Узыйдзі да ГОСПАДА ты і Аарон, Надаў і Абігу, і семдзясят са старшыняў Ізраіля, і пакланіцеся здалёк. ");
INSERT INTO bel_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","I наблізіцца Майсей адзін да ГОСПАДА; а яны няхай не набліжаюцца, і народ няхай не ўзыходзіць з ім». ");
INSERT INTO bel_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","I прыйшоў Майсей, і пераказаў народу ўсе словы ГОСПАДА і ўсе суды Ягоныя; і адказаў увесь народ у адзін голас, і сказалі: «Усе словы, якія прамовіў ГОСПАД, выканаем!». ");
INSERT INTO bel_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","I напісаў Майсей усе словы ГОСПАДА, і ўстаў раніцаю, і збудаваў ахвярнік пад гарою і дванаццаць слупоў паводле дванаццаці плямёнаў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I паслаў юнакоў з сыноў Ізраіля, і яны ўзьнесьлі цэласпаленьні і ахвяравалі валоў як ахвяры мірныя для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","I ўзяў Майсей палову крыві, і ўліў у чару, а паловаю крыві пакрапіў ахвярнік. ");
INSERT INTO bel_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","I ўзяў кнігу запавету, і прачытаў у вушы народу, і сказалі яны: «Усё, што сказаў ГОСПАД, зробім, і будзем слухаць». ");
INSERT INTO bel_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","I ўзяў Майсей кроў, і пакрапіў народ, і сказаў: «Вось, кроў запавету, які ГОСПАД заключыў з вамі, паводле ўсіх словаў гэтых». ");
INSERT INTO bel_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","I ўзыйшоў Майсей і Аарон, Надаў і Абігу і семдзясят старшыняў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","I бачылі Бога Ізраіля; і пад нагамі Ягонымі нібыта выраб з каменю шафіру і нібыта само неба ў яснасьці сваёй. ");
INSERT INTO bel_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","I на выбраных сыноў Ізраіля Ён ня выцягнуў рукі Сваёй. I яны бачылі Бога, і елі, і пілі. ");
INSERT INTO bel_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","I сказаў ГОСПАД Майсею: «Узыйдзі да Мяне на гару, і будзь там, і Я дам табе табліцы каменныя, і закон, і прыказаньні, якія Я напісаў, каб навучыць іх». ");
INSERT INTO bel_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","І ўстаў Майсей і Егошуа, служыцель ягоны, і ўзыйшоў Майсей на гару Божую. ");
INSERT INTO bel_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","А старшыням сказаў: «Заставайцеся дзеля нас тут, пакуль мы вернемся да вас. І вось, Аарон і Хур з вамі. Калі хто будзе мець якую справу, няхай наблізіцца да іх». ");
INSERT INTO bel_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","I ўзыйшоў Майсей на гару; і закрыла воблака гару. ");
INSERT INTO bel_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","I супачыла слава ГОСПАДА на гары Сынай; і закрывала воблака яе шэсьць дзён. І паклікаў Бог у сёмы дзень Майсея з сярэдзіны воблака. ");
INSERT INTO bel_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","А выгляд славы ГОСПАДА быў як агонь палючы на вяршыні гары перад вачыма сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","I ўвайшоў Майсей у сярэдзіну воблака, і ўзыйшоў на гару; і быў Майсей на гары сорак дзён і сорак начэй. ");
INSERT INTO bel_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Прамоў да сыноў Ізраіля, і няхай яны зьбяруць для Мяне дары. Ад кожнага чалавека, у якога сэрца ягонае дабраахвотна пажадае даць, бярыце дар Мой. ");
INSERT INTO bel_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","I вось дары, якія вы будзеце зьбіраць ад іх: золата, срэбра і медзь, ");
INSERT INTO bel_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","і блакіт, і пурпур, і барвовы кармазын, і вісон, і казіную поўсьць, ");
INSERT INTO bel_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","і скуры бараноў, фарбаваныя на чырвона, і скуры тахаш, і дрэва акацыі, ");
INSERT INTO bel_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","алей для асьвятленьня, пахошчы для алею памазаньня і для пахкага каджэньня, ");
INSERT INTO bel_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","камяні оніксу і камяні для аздабленьня эфоду і нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","I няхай зробяць для Мяне сьвятыню, і Я буду жыць сярод іх. ");
INSERT INTO bel_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Усё, як Я пакажу табе, паводле ўзору сялібы і паводле ўзору ўсяго начыньня яе, так і зрабіце. ");
INSERT INTO bel_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","I няхай зробяць каўчэг з дрэва акацыі; два з паловаю локці даўжыня яго, і паўтары локці шырыня яго, і паўтары локці вышыня яго. ");
INSERT INTO bel_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","I пакрыеш яго шчырым золатам; знутры і звонку пакрыеш яго; і зробіш наверсе наўкола вянок залаты. ");
INSERT INTO bel_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","I выльеш да яго чатыры колцы залатыя, і прыладзіш іх на чатырох кутах яго, два колцы на адным баку яго, і два колцы на другім баку яго. ");
INSERT INTO bel_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","I зробіш насілы з дрэва акацыі, і пакрыеш іх золатам. ");
INSERT INTO bel_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I ўложыш насілы ў колцы па баках каўчэгу, каб на іх насіць каўчэг. ");
INSERT INTO bel_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","У колцах каўчэгу маюць быць насілы, ня будуць іх вымаць адтуль. ");
INSERT INTO bel_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","I ўложыш у каўчэг Сьведчаньне, якое Я дам табе. ");
INSERT INTO bel_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","I зробіш накрыўку са шчырага золата, два локці з паловаю даўжыня яе, і паўтары локці шырыня яе. ");
INSERT INTO bel_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","I зробіш двух херувімаў з золата, каванымі зробіш іх з абодвух бакоў накрыўкі. ");
INSERT INTO bel_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","I зробіш аднаго херувіма на тым баку, і аднаго херувіма на гэтым баку; разам з накрыўкай зробіце херувімаў на абодвух баках яе. ");
INSERT INTO bel_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","I будуць херувімы, распусьціўшы крылы ўгару, захінаць крыламі сваімі накрыўку, а абліччамі сваімі будуць зьвернуты адзін да аднаго; да накрыўкі будуць зьвернутыя абліччы херувімаў. ");
INSERT INTO bel_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","I паложыш накрыўку на каўчэг зьверху, і ў каўчэг паложыш Сьведчаньне, якое Я дам табе. ");
INSERT INTO bel_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I Я буду сустракацца з табою там, і гаварыць з табою з-над накрыўкі, паміж двух херувімаў, якія над Каўчэгам Сьведчаньня, пра ўсё, што буду загадваць табе для сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","I зробіш стол з дрэва акацыі, два локці даўжыня яго, локаць шырыня яго, і паўтары локці вышыня яго. ");
INSERT INTO bel_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","I пакрыеш яго шчырым золатам, і зробіш яму вянок залаты наўкола. ");
INSERT INTO bel_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","I зробіш яму наўкола ліштву шырынёю ў далонь, і зробіш наўкола вянок залаты да ліштвы ягонай. ");
INSERT INTO bel_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","I зробіш для яго чатыры колцы залатыя, і прыладзіш колцы да чатырох рагоў, якія пры чатырох ножках ягоных. ");
INSERT INTO bel_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Пры ліштвах маюць быць колцы, каб укладаць насілы і насіць стол. ");
INSERT INTO bel_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","I зробіш насілы з дрэва акацыі, і пакрыеш іх золатам, і будуць насіць на іх стол. ");
INSERT INTO bel_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","I зробіш да яго місы, і чашы, і збаны, і кубкі для складаньня ахвяраў вадкіх; са шчырага золата зробіш іх. ");
INSERT INTO bel_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","I будзеш класьці на стол хлябы пакладныя перад абліччам Маім заўсёды. ");
INSERT INTO bel_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","I зробіш сьвечнік з золата шчырага, каваным будзе зроблены сьвечнік; падстава яго, і сьцябло яго, чарачкі яго, яблыкі яго і кветкі яго маюць выходзіць з яго. ");
INSERT INTO bel_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","I шэсьць сьцяблінаў маюць выходзіць з бакоў яго: тры сьцябліны сьвечніка з аднаго боку яго, і тры сьцябліны сьвечніка з другога боку яго. ");
INSERT INTO bel_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Тры чарачкі, падобныя да мігдалу, з яблыкам і кветкаю, на адной сьцябліне, і тры чарачкі, падобныя да мігдалу, на другой сьцябліне, з яблыкам і кветкаю. Гэтак на шасьці сьцяблінах, што выходзяць са сьвечніка. ");
INSERT INTO bel_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","А на камлі сьвечніка маюць быць чатыры чарачкі, падобныя да мігдалу, з яблыкам і кветкаю. ");
INSERT INTO bel_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","I яблык пад двума сьцяблінамі, што выходзяць з яго, і яблык пад двума сьцяблінамі, што выходзяць з яго, і яблык пад двума сьцяблінамі, што выходзяць з яго, на ўсіх шасьці сьцяблінах, што выходзяць са сьвечніка. ");
INSERT INTO bel_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Яблыкі іхнія і сьцябліны іхнія будуць выходзіць з яго; ён увесь суцэльна мае быць каваны са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","I зробіш сем лямпаў для яго, і будуць прыладжаны лямпы ягоныя, і будуць сьвяціць на пярэдні бок яго. ");
INSERT INTO bel_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","I абцужкі да яго, і папяльнічкі да яго зробіш са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","З таленту золата шчырага няхай зробяць яго з усімі гэтымі прыладамі. ");
INSERT INTO bel_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","I глядзі, і зрабі паводле ўзору іхняга, які Я паказаў табе на гары. ");
INSERT INTO bel_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","А Сялібу зробіш з дзесяці палотнаў з кручанага вісону, з блакіту, з пурпуру і барвовага кармазыну; і херувімаў зрабі на іх мастацкай работаю. ");
INSERT INTO bel_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Даўжыня аднаго палатна — дваццаць восем локцяў, а шырыня аднаго палатна — чатыры локці; мера адна для ўсіх палотнаў. ");
INSERT INTO bel_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Пяць палотнаў няхай будуць злучаныя адно з адным, і пяць палотнаў злучаныя адно з адным. ");
INSERT INTO bel_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I зробіш пяцелькі з блакіту на краі аднаго палатна на канцы для сьпінаньня; і гэтак зробіш на краі апошняга палатна для сьпінаньня з іншага боку. ");
INSERT INTO bel_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Пяцьдзясят пяцелек зробіш на адным палатне, і пяцьдзясят пяцелек зробіш на краі палатна ў месцы, дзе маюць быць сьпятыя з іншага боку; пяцелькі будуць насупраць адна адной. ");
INSERT INTO bel_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","I зробіш пяцьдзясят гачыкаў залатых, і злучыш гачыкамі палотны адно з адным, і будзе Сяліба адным цэлым. ");
INSERT INTO bel_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","I зробіш палотны з казінае поўсьці для намёту Сялібы, адзінаццаць палотнаў зробіш іх. ");
INSERT INTO bel_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Даўжыня аднаго палатна — трыццаць локцяў, а ў шырыню адно палатно — чатыры локці; мера адна для адзінаццаці палотнаў. ");
INSERT INTO bel_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","I злучыш пяць палотнаў асобна і шэсьць палотнаў асобна. I зложыш удвая шостае палатно з пярэдняга боку намёту. ");
INSERT INTO bel_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","I зробіш пяцьдзясят пяцелек на краі аднаго палатна на канцы для сьпінаньня, і пяцьдзясят пяцелек на краі другога палатна для сьпінаньня з іншага боку. ");
INSERT INTO bel_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","I зробіш пяцьдзясят гачыкаў мядзяных, і ўложыш гачыкі ў пяцелькі, і злучыш намёт, і будзе ён адным цэлым. ");
INSERT INTO bel_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","А лішак, які застанецца ад палотнаў намёту, палова палатна, што засталася, няхай вісіць з задняга боку Сялібы. ");
INSERT INTO bel_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","А локаць з аднаго і локаць з другога боку, якія застануцца ад даўжыні палотнаў намёту, няхай вісяць па баках сялібы, з аднаго і з другога боку прыкрываючы яе. ");
INSERT INTO bel_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","I зробіш пакрыцьцё на намёт са скураў бараноў, фарбаваных на чырвона, і пакрыцьцё на верх са скураў тахаш. ");
INSERT INTO bel_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","I зробіш з дрэва акацыі дошкі для Сялібы, якія будуць стаяць проста. ");
INSERT INTO bel_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Дзесяць локцяў даўжыня дошкі, і паўтары локці шырыня адной дошкі. ");
INSERT INTO bel_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Два шыпы будуць у кожнай дошцы, асаджаныя адзін насупраць другога. Гэтак зробіш у-ва ўсіх дошках Сялібы. ");
INSERT INTO bel_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","I зробіш дошкі для Сялібы — дваццаць дошак для паўднёвага боку, што глядзіць на поўдзень. ");
INSERT INTO bel_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","I сорак срэбных падставак зробіш пад дваццаць дошак; дзьве падстаўкі пад адну дошку да двух шыпоў ейных, і дзьве падстаўкі пад другую дошку да двух шыпоў ейных. ");
INSERT INTO bel_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","I да другога боку Сялібы на паўночны бок зробіш дваццаць дошак. ");
INSERT INTO bel_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","I сорак падставак для іх срэбных — дзьве падстаўкі пад адну дошку, і дзьве падстаўкі пад другую дошку. ");
INSERT INTO bel_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","I для боку Сялібы, што глядзіць на захад, зробіш шэсьць дошак. ");
INSERT INTO bel_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","I дзьве дошкі зробіш для вуглоў Сялібы пры заходнім боку. ");
INSERT INTO bel_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","I будуць яны злучаныя ўнізе, і разам злучаныя ўгары адным колцам. Гэтак мае быць з імі абедзьвума; для двух вуглоў яны будуць. ");
INSERT INTO bel_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","I так будзе восем дошак, і падставак іхніх срэбных шаснаццаць: дзьве падстаўкі пад адну дошку, і дзьве падстаўкі пад другую дошку. ");
INSERT INTO bel_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","І зробіш жэрдкі з дрэва акацыі — пяць да дошак аднаго боку Сялібы, ");
INSERT INTO bel_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","і пяць жэрдак да дошак другога боку Сялібы, і пяць жэрдак да дошак задняга боку Сялібы, што глядзіць на захад. ");
INSERT INTO bel_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","І жэрдка сярэдняя будзе праходзіць па сярэдзіне дошак ад аднаго канца да другога. ");
INSERT INTO bel_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","I дошкі пакрыеш золатам, і колцы на іх для ўкладаньня жэрдак зробіш залатыя, і пакрыеш жэрдкі золатам. ");
INSERT INTO bel_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","I паставіш Сялібу паводле статуту ейнага, які Я паказаў табе на гары. ");
INSERT INTO bel_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","I зробіш заслону з блакіту, пурпуру, барвовага кармазыну і кручанага вісону; мастацкай работай маеш зрабіць яе разам з херувімамі. ");
INSERT INTO bel_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I павесіш яе на чатырох слупах з акацыі, пакрытых золатам, з кручкамі залатымі, на чатырох падстаўках срэбных. ");
INSERT INTO bel_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","I павесіш заслону на гачыках, і ўнясеш туды, унутр, за заслону Каўчэг Сьведчаньня; і будзе аддзяляць заслона вам месца Сьвятое ад Сьвятога Сьвятых. ");
INSERT INTO bel_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","I паложыш накрыўку на Каўчэг Сьведчаньня ў Сьвятым Сьвятых. ");
INSERT INTO bel_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I паставіш стол навонкі ад заслоны, і сьвечнік насупраць стала пры паўднёвым боку Сялібы; а стол паставіш на паўночным баку. ");
INSERT INTO bel_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","I зробіш заслону на ўваходзе з блакіту, пурпуру, барвовавага кармазыну і кручанага вісону гафтаванае работы. ");
INSERT INTO bel_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","I зробіш для заслоны пяць слупоў з акацыі, і пакрыеш іх золатам, і кручкі да іх залатыя; і выльеш для іх пяць падставак мядзяных. ");
INSERT INTO bel_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","I зробіш ахвярнік з дрэва акацыі, пяць локцяў у даўжыню і пяць локцяў у шырыню, чатырохкутні будзе ахвярнік, і тры локці ў вышыню. ");
INSERT INTO bel_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","I зробіш рогі ягоныя на чатырох вуглах ягоных, з яго будуць выходзіць рогі ягоныя, і пакрыеш іх медзьдзю. ");
INSERT INTO bel_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","I зробіш да яго гаршчкі для высыпаньня попелу з яго, і лапаткі ягоныя, і місы ягоныя, і відэльцы ягоныя, і кадзільніцы ягоныя. Усе начыньні зробіш з медзі. ");
INSERT INTO bel_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","I зробіш да яго крату, плеценай работы, мядзяную, і зробіш на пляцёнцы чатыры колцы мядзяныя на чатырох вуглах яе. ");
INSERT INTO bel_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","I паложыш яе зьнізу пад вобад ахвярніка так, каб пляцёнка была да паловы ахвярніка. ");
INSERT INTO bel_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","I зробіш насілы для ахвярніка, насілы з дрэва акацыі, і пакрыеш іх медзьдзю. ");
INSERT INTO bel_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","I ўкладзеш насілы ягоныя ў колцы, і будуць насілы па абодвух баках ахвярніка для нашэньня яго. ");
INSERT INTO bel_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Пустым унутры з дошак зробіш яго. Як паказана табе на гары, так няхай зробяць. ");
INSERT INTO bel_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","І зробіш панадворак Сялібы. З паўднёвага боку, што глядзіць на поўдзень, заслоны для панадворку з кручанага вісону, даўжынёй у сто локцяў з аднаго боку. ");
INSERT INTO bel_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","I слупоў да іх дваццаць, і падставак да іх дваццаць мядзяных; а кручкі на слупах і клямкі да іх — срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Таксама з паўночнага боку ўздоўж будуць заслоны ў сто локцяў даўжыні; і слупоў да іх дваццаць, і падставак да іх дваццаць мядзяных; а кручкі на слупах і клямкі да іх — срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","А на шырыню панадворку з заходняга боку будуць заслоны ў пяцьдзясят локцяў; слупоў да іх дзесяць, і падставак да іх дзесяць. ");
INSERT INTO bel_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","I шырыня панадворку з пярэдняга боку, што глядзіць на ўсход, — пяцьдзясят локцяў. ");
INSERT INTO bel_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Пятнаццаць локцяў — заслоны з аднаго краю; слупоў да іх тры, і падставак да іх тры. ");
INSERT INTO bel_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","I з другога краю — заслоны ў пятнаццаць локцяў; слупоў да іх тры, і падставак да іх тры. ");
INSERT INTO bel_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","А для брамы панадворку — заслона ў дваццаць локцяў з блакіту, пурпуру, барвовага кармазыну і кручанага вісону, гафтаванае работы; слупоў да яе чатыры, і падставак да іх чатыры. ");
INSERT INTO bel_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Усе слупы вакол панадворку злучаны срэбнымі клямкамі; кручкі ў іх — срэбныя, а падстаўкі да іх — мядзяныя. ");
INSERT INTO bel_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Даўжыня панадворку — сто локцяў, а шырыня — пяцьдзясят і пяцьдзясят паўсюль, а вышыня — пяць локцяў; заслоны — з кручанага вісону, а падстаўкі слупоў — мядзяныя. ");
INSERT INTO bel_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Усе начыньні Сялібы для ўсялякага ўжываньня ў ёй і ўсе калкі ейныя, і ўсе калкі панадворку — мядзяныя. ");
INSERT INTO bel_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","I ты загадаеш сынам Ізраіля, і возьмуць табе алей з аліўкаў, чысты, выціснуты, для асьвятленьня, каб лямпы гарэлі заўсёды. ");
INSERT INTO bel_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","У Намёце Спатканьня навонкі ад заслоны, якая перад Сьведчаньнем, будуць запальваць іх Аарон і сыны ягоныя з вечара да раніцы перад абліччам ГОСПАДА. Гэта пастанова вечная для пакаленьняў іхніх ад сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","I ты наблізь да сябе Аарона, брата твайго, і сыноў ягоных з ім спасярод сыноў Ізраіля, каб яны былі сьвятарамі Маімі: Аарона і Надава, Авігу, Элеазара і Ітамара, сыноў Аарона. ");
INSERT INTO bel_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","I зробіш сьвятыя адзеньні Аарону, брату твайму, дзеля славы і аздабленьня. ");
INSERT INTO bel_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","I скажаш усім мудрым сэрцам, якіх Я напоўніў духам мудрасьці, каб яны зрабілі Аарону адзеньні для асьвячэньня яго, каб ён быў сьвятаром Маім. ");
INSERT INTO bel_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","I вось адзеньні, якія яны маюць зрабіць: нагруднік і эфод, і верхняя шата, і хітон плецены, мітра і пояс. I зробяць сьвятыя адзеньні Аарону, брату твайму, і сынам ягоным, каб яны былі сьвятарамі Маімі. ");
INSERT INTO bel_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Няхай яны возьмуць золата, і блакіт, і пурпур, і барвовы кармазын, і вісон, ");
INSERT INTO bel_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","і зробяць эфод з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону мастацкай работаю. ");
INSERT INTO bel_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Два злучаныя нараменьнікі будзе ён мець на двух канцах сваіх, і так будзе злучаны. ");
INSERT INTO bel_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","I пас эфоду, які падпярэзвае яго, мае быць аднолькавае з ім работы, з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону. ");
INSERT INTO bel_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","I возьмеш два камяні оніксу, і выражаш на іх імёны сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Шэсьць імёнаў іхніх на адным камяні, і шэсьць імёнаў астатніх на другім камяні, паводле парадку нараджэньня іхняга. ");
INSERT INTO bel_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Як разьбяр на камяні выразае пячатку, так ты выражаш на двух камянях імёны сыноў Ізраіля; асаджанымі ў залатыя аправы зробіш іх. ");
INSERT INTO bel_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","I паложыш абодва камяні гэтыя на нараменьнікі эфоду як камяні на ўспамін пра сыноў Ізраіля, і будзе насіць Аарон імёны іхнія перад абліччам ГОСПАДА на абодвух плячах сваіх як напамін. ");
INSERT INTO bel_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","I зробіш аправы з золата, ");
INSERT INTO bel_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","і два ланцужкі са шчырага золота, плеценымі зробіш іх, як зрабіў пас, і прымацуеш плеценыя ланцужкі да аправаў. ");
INSERT INTO bel_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","І зробіш нагруднік судовы мастацкаю работаю, такою самаю работаю як эфод зробіш яго; з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону зробіш яго. ");
INSERT INTO bel_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Чатырохкутны ён мае быць і падвойны, у пядзю даўжыня ягоная і ў пядзю шырыня ягоная. ");
INSERT INTO bel_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","I напоўніш яго асаджанымі камянямі, чатырма шэрагамі камянёў. Рубін, тапаз і шмарагд — гэта шэраг адзін. ");
INSERT INTO bel_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","А шэраг другі — гранат, шафір і дыямэнт. ");
INSERT INTO bel_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","А шэраг трэці — яхонт, агат і амэтыст. ");
INSERT INTO bel_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","А шэраг чацьвёрты — хрызаліт, онікс і ясьпіс. Яны маюць быць асаджаны ў золата ў асадах сваіх. ");
INSERT INTO bel_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","I камяні будуць паводле імёнаў сыноў Ізраіля, дванаццаць паводле імёнаў іхніх, і на кожным будзе выразанае як пячатка імя паводле імёнаў дванаццаці. ");
INSERT INTO bel_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","I зробіш для нагрудніку ланцужкі плеценыя вітою работаю, са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","I зробіш для нагрудніку два колцы залатыя, і прымацуеш два колцы да двух канцоў нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","I ўкладзеш два плеценыя залатыя ланцужкі ў абодва колцы на канцах нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","А іншыя два канцы двух плеценых ланцужкоў прычэпіш да двух аправаў, і прымацуеш да нараменьнікаў эфоду з пярэдняга боку яго. ");
INSERT INTO bel_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","I зробіш два колцы залатыя, і прымацуеш іх да двух канцоў нагрудніку на тым краі ягоным, які пры ўнутраным боку эфоду. ");
INSERT INTO bel_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","I зробіш два колцы залатыя, і прымацуеш іх да двух нараменьнікаў эфоду зьнізу з пярэдняга боку ягонага, каля злучэньня ягонага, над пасам эфоду. ");
INSERT INTO bel_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","I прымацуеш нагруднік з колцамі ягонымі колцамі ягонымі да колцаў эфоду шнурком з блакіту, каб ён быў над пасам эфоду, і каб не ссоваўся нагруднік з эфоду. ");
INSERT INTO bel_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","I будзе насіць Аарон імёны сыноў Ізраіля на нагрудніку судовым на сэрцы сваім, калі будзе ўваходзіць у сьвятыню, як успамін перад абліччам ГОСПАДА заўсёды. ");
INSERT INTO bel_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I ўложыш у нагруднік судовы урым і тумім, і яны будуць каля сэрца Аарона, калі ён будзе ўваходзіць у сьвятыню перад аблічча ГОСПАДА; і будзе Аарон насіць суд сыноў Ізраіля каля сэрца свайго перад абліччам ГОСПАДА заўсёды. ");
INSERT INTO bel_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","I зробіш верхнюю шату да эфоду, усю з блакіту. ");
INSERT INTO bel_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","I будзе мець яна ў сярэдзіне адтуліну для галавы; абшыўка мае быць наўкола адтуліны, ткацкай работы, як пры адтуліне панцыра, каб не разьдзёрлася. ");
INSERT INTO bel_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","I зробіш на прыполе ейным яблыкі гранатовыя з блакіту, пурпуру і барвовага кармазыну, на прыполе ейным наўкола; і званочкі залатыя пасярод іх наўкола, ");
INSERT INTO bel_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","залаты званочак і гранатовы яблык, залаты званочак і гранатовы яблык, на прыполе верхняе шаты наўкола. ");
INSERT INTO bel_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","I будзе гэта на Аароне ў часе служэньня ягонага, і чутны будзе голас ягоны, калі ён будзе ўваходзіць у сьвятыню перад аблічча ГОСПАДА, і калі будзе выходзіць, каб ён не памёр. ");
INSERT INTO bel_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","I зробіш дыядэму са шчырага золата, і выражаш на ёй, як выразаюць на пячатцы: “Сьвятыня для ГОСПАДА!”, ");
INSERT INTO bel_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","і прымацуеш шнурком з блакіту, і будзе яна на мітры, на пярэднім баку мітры яна будзе. ");
INSERT INTO bel_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","I будзе яна на чале Аарона, і панясе Аарон беззаконьне, якое будзе ў асьвячоных рэчах, якія пасьвяцілі сыны Ізраіля, у-ва ўсіх дарах, якія пасьвяцілі яны. I будзе яна на чале ягоным заўсёды, каб былі дары даспадобы перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","I вытчаш хітон з вісону, і зробіш мітру з вісону, і пояс зробіш гафтаванае работы. ");
INSERT INTO bel_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","I для сыноў Аарона зробіш хітоны, і зробіш для іх паясы, і турбаны зробіш для іх дзеля славы і аздабленьня. ");
INSERT INTO bel_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I апранеш у іх Аарона, брата свайго, і сыноў ягоных з ім, і памажаш іх, і напоўніш рукі іхнія, і пасьвяціш іх, і яны будуць сьвятарамі Маімі. ");
INSERT INTO bel_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","I зробіш нагавіцы ільняныя, каб прыкрыць голасьць цела, ад сьцёгнаў да галёнкаў няхай будуць. ");
INSERT INTO bel_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","I будуць яны на Аароне і на сынах ягоных, калі яны будуць уваходзіць у Намёт Спатканьня або набліжацца да ахвярніка, каб служыць у сьвятыні, і тады яны не панясуць беззаконьня і не памруць. Гэта пастанова вечная для яго і насеньня ягонага пасьля яго. ");
INSERT INTO bel_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","I вось тая рэч, якую зробіш для іх, каб пасьвяціць іх на сьвятароў для Мяне. Возьмеш аднаго маладога бычка і двух бараноў без заганы, ");
INSERT INTO bel_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","і хлябы прэсныя, і печыва прэснае, рашчыненае на алеі, і аладкі прэсныя, памазаныя алеем; з найлепшае мукі зробіш іх. ");
INSERT INTO bel_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I паложыш іх у адзін кош, і прынясеш іх у кашы, і бычка, і двух бараноў. ");
INSERT INTO bel_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","I Аарона і сыноў ягоных прывядзеш да ўваходу ў Намёт Спатканьня, і абмыеш іх у вадзе, ");
INSERT INTO bel_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","і возьмеш адзеньні, і апранеш на Аарона хітон і верхнюю шату эфоду, і эфод, і нагруднік, і падпярэжаш яго поясам эфоду. ");
INSERT INTO bel_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I ўскладзеш мітру на галаву ягоную, і прымацуеш дыядэму сьвятасьці на мітру. ");
INSERT INTO bel_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","I возьмеш алей памазаньня, і выльеш на галаву ягоную, і памажаш яго. ");
INSERT INTO bel_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","I сыноў ягоных прывядзеш, і апранеш на іх хітоны, ");
INSERT INTO bel_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","і падпярэжаш іх поясам, Аарона і сыноў ягоных, і адзенеш на іх турбаны, і будзе ім належаць сьвятарства паводле пастановы вечнае, і напоўніш рукі Аарона і сыноў ягоных. ");
INSERT INTO bel_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","I прывядзеш бычка перад Намёт Спатканьня, і ўскладуць Аарон і сыны ягоныя рукі свае на галаву бычка. ");
INSERT INTO bel_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I зарэжаш бычка перад абліччам ГОСПАДА каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I возьмеш кроў бычка, і памажаш рогі ахвярніка пальцам тваім, і ўсю кроў выльеш на падставу ахвярніка. ");
INSERT INTO bel_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","I возьмеш увесь тлушч, які пакрывае нутро, і лой з вантробаў, і абедзьве ныркі, і тлушч, які на іх, і спаліш на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","А мяса бычка, і скуру ягоную, і гной ягоны спаліш на агні па-за табарам. Гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","I возьмеш аднаго з бараноў, і ўскладуць Аарон і сыны ягоныя рукі свае на галаву барана. ");
INSERT INTO bel_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","I зарэжаш барана, і возьмеш кроў ягоную, і пакропіш на ахвярнік наўкола. ");
INSERT INTO bel_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","I барана расьсячэш на кавалкі ягоныя, і вымыеш нутро ягонае і ногі ягоныя, і паложыш іх на расьсечаныя кавалкі ягоныя і на галаву ягоную. ");
INSERT INTO bel_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I спаліш усяго барана на ахвярніку. Гэта цэласпаленьне ГОСПАДУ, пах прыемны, ахвяра агню для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","I возьмеш другога барана, і ўскладуць Аарон і сыны ягоныя рукі свае на галаву барана. ");
INSERT INTO bel_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","I зарэжаш барана, і возьмеш кроў ягоную, і памажаш верх правага вуха Аарона і верх правага вуха сыноў ягоных, вялікі палец правай рукі іхняй, і вялікі палец правай нагі іхняй; і пакропіш крывёю ахвярнік наўкола. ");
INSERT INTO bel_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","I возьмеш кроў, якая на ахвярніку, і алей памазаньня, і пакропіш Аарона і сыноў ягоных, і адзеньне ягонае, і адзеньні сыноў ягоных з ім; і будзе асьвячоны ён і адзеньне ягонае, і сыны ягоныя, і адзеньні сыноў ягоных з ім. ");
INSERT INTO bel_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","I возьмеш тлушч барана і хвост, і тлушч, які пакрывае нутро, і лой з вантробаў, і абедзьве ныркі, і тлушч, які на іх, і правую лапатку, бо гэта баран пасьвячэньня, ");
INSERT INTO bel_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","і адзін бохан хлеба, і адно печыва хлеба, зробленае на алеі, і адну аладку з каша праснакоў, які перад абліччам ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","і паложыш усё гэта на далоні Аарона і на далоні сыноў ягоных, і будзеш патрэсваць іх як ахвяру патрэсваньня перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","I возьмеш іх з рук іхніх, і спаліш на ахвярніку як цэласпаленьне, пах прыемны перад абліччам ГОСПАДА. Гэта ахвяра вагню для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","I возьмеш грудзіну барана пасьвячэньня, які быў для Аарона, і будзеш патрэсваць ёю як ахвярай патрэсваньня перад абліччам ГОСПАДА, і гэта будзе частка твая. ");
INSERT INTO bel_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","I асьвяціш грудзіну патрасаную і лапатку ўзьнесеную, якія былі патрэсваныя і якія былі ўзьнесеныя з барана пасьвячэньня, які быў для Аарона і які быў для сыноў ягоных. ");
INSERT INTO bel_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","I будуць яны для Аарона і сыноў ягоных паводле пастановы вечнай ад сыноў Ізраіля, бо гэта ўзьнясеньне, і гэтае ўзьнясеньне мае быць ад сыноў Ізраіля з іхніх ахвяраў мірных, узьнясеньне іхняе для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","I адзеньні сьвятыя, якія належаць Аарону, будуць належаць сынам ягоным пасьля яго, каб у іх памазваць іх і напаўняць рукі іхнія. ");
INSERT INTO bel_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Сем дзён мае апранацца ў іх сьвятар з сыноў ягоных, які будзе замест яго, які будзе ўваходзіць у Намёт Спатканьня, каб служыць у сьвятыні. ");
INSERT INTO bel_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","I барана пасьвячэньня возьмеш, і зварыш мяса ягонае на месцы сьвятым. ");
INSERT INTO bel_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","I будзе есьці Аарон і сыны ягоныя мяса барана гэтага і хлеб, які ў кашы, каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","I будуць яны есьці тое, што было перамаленьнем за іх, каб напоўніць рукі іхнія і асьвяціць іх; а чужы ня будзе есьці гэта, бо гэта сьвятое. ");
INSERT INTO bel_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","I калі застанецца мяса пасьвячэньня і хлеб да раніцы, спаліш астачу на агні, нельга есьці яго, бо гэта сьвятое. ");
INSERT INTO bel_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","I ўсё зробіш Аарону і сынам ягоным паводле таго, што Я загадаў табе: сем дзён будзеш напаўняць рукі іхнія. ");
INSERT INTO bel_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","I бычка як ахвяру за грэх будзеш складаць кожны дзень дзеля перамольваньня, і ачысьціш ахвярнік ад грэху, учыніўшы перамольваньне за яго, і памажаш яго, і асьвяціш яго. ");
INSERT INTO bel_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Сем дзён будзеш зьдзяйсьняць перамольваньне за ахвярнік і будзеш асьвячаць яго, і будзе ахвярнік сьвятое сьвятых; усё, што дакранецца да ахвярніка, будзе сьвятым. ");
INSERT INTO bel_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Вось што будзеш складаць у ахвяру на ахвярніку: двух ягнятаў аднагодак кожны дзень заўсёды. ");
INSERT INTO bel_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Адно ягня складзеш у ахвяру раніцай, а другое ягня складзеш у ахвяру вечарам. ");
INSERT INTO bel_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","I на адно ягня возьмеш дзясятую частку эфы найлепшае мукі, зьмяшанай з алеем выціснутым, якога чвэрць гіну, і на ўзьліваньне — чвэрць гіну віна. ");
INSERT INTO bel_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","А другое ягня складзеш у ахвяру ўвечары, падобна як ахвяраваньне раніцаю і ўзьліваньне пры ёй складзеш яго на пах прыемны, на ахвяру агню для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Гэта цэласпаленьне, якое будзе заўсёды ў пакаленьнях вашых перад уваходам у Намёт Спатканьня перад абліччам ГОСПАДА, дзе буду сустракацца з вамі, каб размаўляць там з табою. ");
INSERT INTO bel_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I буду сустракацца там з сынамі Ізраіля, і будзе асьвячонае тое месца славаю Маёю. ");
INSERT INTO bel_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I Я асьвячу Намёт Спатканьня і ахвярнік; і Аарона і сыноў ягоных асьвячу, каб яны былі сьвятарамі Маімі. ");
INSERT INTO bel_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I буду жыць сярод сыноў Ізраіля, і буду ім Богам. ");
INSERT INTO bel_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","I пазнаюць, што Я — ГОСПАД, Бог іхні, Які вывеў іх з зямлі Эгіпецкай, каб Мне жыць сярод іх. Я — ГОСПАД, Бог іхні. ");
INSERT INTO bel_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","I зробіш ахвярнік для каджэньня кадзіла; з дрэва акацыі зробіш яго. ");
INSERT INTO bel_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Локаць — даўжыня ягоная, і локаць — шырыня ягоная; ён мае быць чатырохкутны; і два локці — вышыня ягоная; з яго маюць выходзіць рогі. ");
INSERT INTO bel_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","I пакрыеш яго шчырым золатам, верх ягоны і сьценкі ягоныя наўкола, і рогі ягоныя; і зробіш да яго залаты вянок наўкола. ");
INSERT INTO bel_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","I два колцы залатыя зробіш да яго, пад вянком ягоным, на двух вуглах ягоных; зробіш іх з двух бакоў ягоных; і будуць яны месцам для насілаў, каб насіць яго на іх. ");
INSERT INTO bel_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","I зробіш насілы з дрэва акацыі, і пакрыеш іх золатам. ");
INSERT INTO bel_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","I паставіш яго перад заслонаю, якая перад Каўчэгам Сьведчаньня, перад накрыўкаю, якая над Сьведчаньнем, дзе Я буду сустракацца з табою. ");
INSERT INTO bel_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","I будзе паліць на ім Аарон пахкае кадзіла кожную раніцу. Калі ён будзе папраўляць лямпы, будзе паліць кадзіла. ");
INSERT INTO bel_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","I калі Аарон будзе запальваць лямпы ўвечары, ён будзе паліць кадзіла. Гэта заўсёднае каджэньне перад ГОСПАДАМ у пакаленьнях вашых. ");
INSERT INTO bel_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Не паліце на ім ніякага кадзіла чужога, ані цэласпаленьня, ані дару; і ўзьліваньня не ўзьлівайце на яго. ");
INSERT INTO bel_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","I будзе спраўляць Аарон перамольваньне над рогамі яго раз у год. Крывёю ахвяры за грэх раз у год перамольваньнем будзе перамольваць на ім за пакаленьні вашыя. Гэта сьвятое сьвятых для ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Калі будзеш зьбіраць падатак з галавы ў сыноў Ізраіля пры лічэньні іх, няхай дасьць кожны мужчына выкуп душы сваёй ГОСПАДУ пры лічэньні іх, і ня будзе між імі плягі, калі будуць лічыць іх. ");
INSERT INTO bel_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Гэта павінны даць усе, хто падлягае лічэньню — палову сыкля, паводле сыкля сьвятыні, у якім дваццаць гер у сыклі; палова сыкля — дар для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Усе, хто падлягае лічэньню, ад дваццаці гадоў і вышэй, маюць даць дар ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Багаты ня будзе павялічваць, і бедны ня будзе памяншаць ад паловы сыкля, што маюць даваць як дар ГОСПАДУ дзеля перамольваньня за душы вашыя. ");
INSERT INTO bel_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","I возьмеш срэбра перамольваньня ад сыноў Ізраіля, і дасі яго на служэньне ў Намёце Спатканьня; і будзе гэта сынам Ізраіля на памяць перад абліччам ГОСПАДА дзеля перамольваньня за душы вашыя». ");
INSERT INTO bel_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«І зробіш мыцельнік мядзяны і падставу мядзяную да ўмываньня, і паставіш яго паміж Намётам Спатканьня і ахвярнікам, і нальеш у яго вады. ");
INSERT INTO bel_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","I будуць Аарон і сыны ягоныя мыць у ім рукі свае і ногі свае. ");
INSERT INTO bel_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Калі яны будуць уваходзіць у Намёт Спатканьня, няхай яны абмыюцца вадою, і яны не памруць; таксама калі яны будуць набліжацца да ахвярніка дзеля служэньня, дзеля ахвяраваньня вогненнага для ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","І будуць яны абмываць рукі свае і ногі свае, і не памруць. I будзе гэта ім пастанова вечная, яму і насеньню ягонаму ў пакаленьнях іхніх». ");
INSERT INTO bel_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«І ты вазьмі сабе найлепшых пахошчаў: міра найчысьцейшага пяцьсот сыкляў, цынамону пахкага палову гэтага, дзьвесьце пяцьдзясят сыкляў, трысьнёгу пахкага дзьвесьце пяцьдзясят сыкляў, ");
INSERT INTO bel_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","і касіі пяцьсот сыкляў, паводле сыклю сьвятыні, і алею аліўкавага гін. ");
INSERT INTO bel_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","I зробіш з гэтага алей сьвятога памазаньня, масьць мяшаную работы мяшальніка масьцяў. Алей сьвятога памазаньня гэта будзе. ");
INSERT INTO bel_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","I памажаш ім Намёт Спатканьня, і Каўчэг Сьведчаньня, ");
INSERT INTO bel_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","і стол, і ўсе начыньні ягоныя, і сьвечнік, і ўсе начыньні ягоныя, і ахвярнік каджэньня, ");
INSERT INTO bel_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","і ахвярнік цэласпаленьня, і ўсе начыньні ягоныя, і мыцельнік, і падставу ягоную. ");
INSERT INTO bel_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I асьвяціш іх, і будуць яны сьвятое сьвятых; усё, што дакранецца да іх, будзе сьвятым. ");
INSERT INTO bel_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","I Аарона і сыноў ягоных памажаш і асьвяціш іх, каб былі сьвятарамі Маімі. ");
INSERT INTO bel_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","А да сыноў Ізраіля прамоў, кажучы: “Гэта будзе для Мяне алей сьвятога памазаньня ў пакаленьнях вашых. ");
INSERT INTO bel_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","На цела чалавека ня будуць узьліваць яго, і паводле складу ягонага не рабіце падобнага да яго. Ён — сьвяты, сьвятым мае быць для вас. ");
INSERT INTO bel_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Чалавек, які зробіць работай мяшальніка масьцяў алей, падобны да яго, і які памажа ім чужынца, будзе выгублены з народу свайго”». ");
INSERT INTO bel_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I сказаў ГОСПАД Майсею: «Вазьмі сабе пахошчы: бальзам, і жывіцу, і галбан пахкі, і ладан чысты, кожнае ў роўнай частцы. ");
INSERT INTO bel_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","I зробіш з гэтага кадзіла мяшанае работай мяшальніка масьцяў, пасоленае, чыстае, сьвятое. ");
INSERT INTO bel_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I стаўчэш яго дробна, і паложыш перад Сьведчаньнем у Намёце Спатканьня, дзе Я буду сустракацца з табою. Гэта сьвятое сьвятых будзе для вас. ");
INSERT INTO bel_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","I кадзіла, якое зробіш, падобнага да яго паводле складу ягонага не рабіце сабе. Сьвятое яно будзе ў цябе для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Чалавек, які зробіць падобнае да яго, каб адчуваць пах ягоны, будзе выгублены з народу свайго». ");
INSERT INTO bel_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Глядзі, Я паклікаў па іменьні Бэцалеэля, сына Урыя, сына Хура, з калена Юды. ");
INSERT INTO bel_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I Я напоўніў яго Духам Божым, мудрасьцю, разумнасьцю, веданьнем і ўменьнем да ўсялякай працы, ");
INSERT INTO bel_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","мастацкімі здольнасьцямі рабіць з золата, срэбра і медзі, ");
INSERT INTO bel_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","і абрабляць камяні для асаджэньня іх, і абрабляць дрэва, каб рабіць з ім усялякую працу. ");
INSERT INTO bel_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","I вось, Я даў яму Агаліява, сына Ахісамаха, з калена Дана, і ў сэрца кожнага мудрага сэрцам Я даў мудрасьць, і яны зробяць усё, што Я загадаў табе: ");
INSERT INTO bel_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Намёт Спатканьня і Каўчэг Сьведчаньня, і накрыўку, якая на ім, і ўсе начыньні Намёту, ");
INSERT INTO bel_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","і стол, і начыньні ягоныя, і сьвечнік чысты, і ўсе начыньні, і ахвярнік каджэньня, ");
INSERT INTO bel_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","і ахвярнік цэласпаленьня, і ўсе начыньні ягоныя, і мыцельнік, і падставу ягоную, ");
INSERT INTO bel_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","і адзеньні службовыя, і адзеньні сьвятыя для Аарона сьвятара, і адзеньні сыноў ягоных да сьвятарства, ");
INSERT INTO bel_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","і алей памазаньня, і кадзіла пахкае для сьвятыні. Усё так, як Я загадаў табе, яны зробяць». ");
INSERT INTO bel_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","I сказаў ГОСПАД Майсею, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«I ты прамовіш да сыноў Ізраіля, кажучы: “Толькі захоўвайце супачынкі Мае, бо гэта знак паміж Мною і вамі ў пакаленьнях вашых, каб вы пазналі, што Я — ГОСПАД, Які асьвячае вас. ");
INSERT INTO bel_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","I захоўвайце суботу, бо яна — сьвятая для вас. Хто апаганіць яе, сьмерцю памрэ. Хто будзе ў яе рабіць работу, будзе выгублена душа тая спаміж народу свайго. ");
INSERT INTO bel_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Шэсьць дзён будуць рабіць работу, а дзень сёмы — субота супачынку, сьвятая для ГОСПАДА. Кожны, хто будзе рабіць работу ў дзень супачынку, сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","I будуць захоўваць сыны Ізраіля суботу, каб рабіць супачынак у пакаленьнях сваіх. Гэта запавет вечны. ");
INSERT INTO bel_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Паміж Мною і сынамі Ізраіля гэта знак на вякі; бо за шэсьць дзён зрабіў ГОСПАД неба і зямлю, а ў сёмы дзень супачыў і адпачыў”». ");
INSERT INTO bel_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","I даў Бог Майсею, калі скончыў прамаўляць да яго на гары Сынай, дзьве табліцы сьведчаньня, табліцы каменныя, запісаныя пальцам Божым. ");
INSERT INTO bel_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","I бачыў народ, што Майсей затрымліваецца, каб зыйсьці з гары, і сабраўся народ перад Ааронам, і сказалі яму: «Устань, зрабі нам багоў, якія будуць ісьці перад намі, бо з гэтым Майсеем, гэтым чалавекам, які вывеў нас з зямлі Эгіпецкай, ня ведаем, што сталася з ім». ");
INSERT INTO bel_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","I сказаў ім Аарон: «Зьніміце завушніцы залатыя, якія ў вушах жонак вашых, сыноў вашых і дочак вашых, і прынясіце да мяне». ");
INSERT INTO bel_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","I зьняў увесь народ завушніцы залатыя, якія ў вушах іхніх, і прынесьлі да Аарона. ");
INSERT INTO bel_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","І ён узяў гэта з рук іхніх, і ўфармаваў яго разцом, і зрабіў з яго цяля літое. I сказалі яны: «Вось бог твой, Ізраілю, які вывеў цябе з зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","I ўбачыў Аарон, і збудаваў перад ім ахвярнік, і ўсклікнуў Аарон, і сказаў: «Сьвята для ГОСПАДА заўтра». ");
INSERT INTO bel_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","I яны ўсталі рана назаўтра, і ахвяроўвалі цэласпаленьні, і прынесьлі ахвяры мірныя; і сеў народ есьці і піць, і ўсталі гуляць. ");
INSERT INTO bel_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","I прамовіў ГОСПАД да Майсея: «Ідзі, зыйдзі, бо сапсаваўся народ твой, які ты вывеў з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Хутка зьвярнулі яны са шляху, які Я загадаў ім, зрабілі сабе цяля літое, і пакланіліся яму, і ахвяроўвалі яму, і сказалі: “Вось бог твой, Ізраілю, які вывеў цябе з зямлі Эгіпецкай”». ");
INSERT INTO bel_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","I сказаў ГОСПАД Майсею: «Я бачыў народ гэты, і вось, ён — народ з цьвёрдым каркам. ");
INSERT INTO bel_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","I цяпер пакінь Мяне, і ўзгарыцца гнеў Мой на іх, і Я выгублю іх, і зраблю з цябе народ вялікі». ");
INSERT INTO bel_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","I маліў Майсей аблічча ГОСПАДА, Бога свайго, і сказаў: «Дзеля чаго, ГОСПАДЗЕ, палае гнеў Твой на народ Твой, які Ты вывеў з зямлі Эгіпецкай сілаю вялікай і рукою моцнай? ");
INSERT INTO bel_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Навошта маюць казаць Эгіпцяне, кажучы: “На ліха вывеў іх, каб забіць іх у гарах і вынішчыць іх з аблічча зямлі”. Адвярніся ад ярасьці гневу Твайго і пашкадуй рабіць ліха народу Твайму. ");
INSERT INTO bel_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Узгадай Абрагама, Ісаака і Ізраіля, слугаў Тваіх, якім Ты прысягаў на Сябе Самога, і прамовіў да іх: “Памножу насеньне вашае, як зоркі ў небе, і ўсю зямлю гэтую, пра якую Я сказаў, дам насенню вашаму, і яны ўспадкаемяць яе на вякі”». ");
INSERT INTO bel_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I пашкадаваў ГОСПАД рабіць ліха, пра якое Ён казаў, што ўчыніць яго народу Свайму. ");
INSERT INTO bel_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","I павярнуўся, і зыйшоў Майсей з гары; і дзьве табліцы Сьведчаньня былі ў руцэ ягонай, табліцы, на якіх было напісана з абодвух бакоў, на адным і на другім баку было напісана на іх. ");
INSERT INTO bel_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","I табліцы былі творам Бога, і пісьмо было пісьмом Божым, высечаным на табліцах. ");
INSERT INTO bel_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","I пачуў Егошуа голас народу, які ўсклікаў, і сказаў Майсею: «Голас вайны ў табары». ");
INSERT INTO bel_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","I сказаў Майсей: «Гэта ані голас крыку перамогі, ані голас крыку паразы, але я чую голас пяяньня». ");
INSERT INTO bel_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","I сталася, калі ён наблізіўся да табару і ўбачыў цяля і танцы, узгарэўся гнеў Майсея, і ён кінуў з рук сваіх табліцы, і разьбіў іх пад гарою. ");
INSERT INTO bel_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","I ўзяў ён цяля, якое яны зрабілі, і спаліў яго ў агні, і сьцёр на попел, і рассыпаў на абліччы вады, і даў яго піць сынам Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","I сказаў Майсей Аарону: «Што зрабіў табе народ гэты, што ты ўвёў яго ў грэх вялікі?» ");
INSERT INTO bel_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","I сказаў Аарон: «Няхай не ўзгараецца гнеў пана майго; ты ведаеш народ гэты, што ён поўны ліха. ");
INSERT INTO bel_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","I яны сказалі мне: “Зрабі нам багоў, якія будуць ісьці перад намі, бо з гэтым Майсеем, чалавекам, які вывеў нас з зямлі Эгіпецкай, ня ведаем, што сталася з ім”. ");
INSERT INTO bel_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","I я сказаў ім: “Хто мае золата, няхай здыме яго”. I яны далі мне, я кінуў яго ў агонь, і выйшла гэта цяля». ");
INSERT INTO bel_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","I ўбачыў Майсей народ, што ён неакелзаны, бо Аарон раскелзаў яго на паганьбеньне перад ворагамі ягонымі. ");
INSERT INTO bel_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","I стаў Майсей у браме табару, і сказаў: «Хто за ГОСПАДА — да мяне!» I сабраліся да яго ўсе сыны Левія. ");
INSERT INTO bel_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","I ён сказаў ім: «Гэтак кажа ГОСПАД, Бог Ізраіля: “Падперажыце кожны меч свой да сьцягна свайго, перайдзіце і зьвярніцеся ад брамы да брамы праз табар, і забівайце кожны брата свайго, кожны сябра свайго, кожны бліжняга свайго”». ");
INSERT INTO bel_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","I зрабілі сыны Левія паводле слова Майсея, і палегла з народу ў той дзень каля трох тысячаў чалавек. ");
INSERT INTO bel_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","I сказаў Майсей: «Напоўніце рукі свае сёньня для ГОСПАДА, бо кожны быў супраць сына свайго і супраць брата свайго, каб Ён даў вам сёньня дабраслаўленьне». ");
INSERT INTO bel_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","I сталася назаўтра, і сказаў Майсей народу: «Вы саграшылі грахом вялікім, і цяпер я ўзыйду да ГОСПАДА, можа, змагу перамаліць Яго за грэх ваш». ");
INSERT INTO bel_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","I вярнуўся Майсей да ГОСПАДА, і сказаў: «Прашу, саграшыў народ гэты грэхам вялікім, і зрабілі сабе багоў залатых. ");
INSERT INTO bel_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","I цяпер, ці можаш дараваць ім грэх іхні? А калі не, вытры мяне, прашу, з кнігі Тваёй, якую Ты напісаў». ");
INSERT INTO bel_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","I сказаў ГОСПАД Майсею: «Таго, хто саграшыў перада Мною, Я вытру з кнігі Маёй. ");
INSERT INTO bel_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","I цяпер ідзі, вядзі народ гэты, куды Я казаў табе. Вось, анёл Мой пойдзе перад табою, і ў дзень наведваньня Майго Я наведаю іх за грэх іхні». ");
INSERT INTO bel_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","I ўдарыў ГОСПАД народ за тое, што зрабілі цяля, якога зрабіў Аарон. ");
INSERT INTO bel_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","I прамовіў ГОСПАД да Майсея: «Ідзі, узыйдзі адгэтуль ты і народ, які ты вывеў з зямлі Эгіпецкай, у зямлю, пра якую Я прысягаў Абрагаму, Ісааку і Якубу, кажучы: “Насеньню твайму дам яе”. ");
INSERT INTO bel_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I Я пашлю перад абліччам тваім анёла, і выганю Хананейца, Амарэя, Хета, Пэрэзэя, Хівея і Евусэя. ");
INSERT INTO bel_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","I ўвядзе ён вас у зямлю, дзе цячэ малако і мёд, бо Сам Я не пайду сярод цябе, бо ты — народ з цьвёрдым каркам, каб Я не выгубіў вас у дарозе». ");
INSERT INTO bel_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","I пачуў народ ліхое слова гэтае, і загаласіў, і не ўзлажыў ніхто аздобаў сваіх на сябе. ");
INSERT INTO bel_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","I сказаў ГОСПАД Майсею: «Скажы сынам Ізраіля: “Ты — народ з цьвёрдым каркам. Калі Я адну хвіліну буду ісьці сярод цябе, Я выгублю цябе. А цяпер здымі з сябе аздобы свае, і Я буду ведаць, што маю рабіць з табою”». ");
INSERT INTO bel_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","I зьнялі з сябе сыны Ізраіля аздобы свае каля гары Харэў. ");
INSERT INTO bel_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","I Майсей узяў намёт, і паставіў яго па-за табарам, воддаль ад табару, і назваў яго Намётам Спатканьня; і было, што кожны, хто шукаў ГОСПАДА, выходзіў да Намёту Спатканьня, які быў па-за табарам. ");
INSERT INTO bel_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","I было, калі Майсей выходзіў да Намёту, уставаў увесь народ, і стаяў кожны каля ўваходу ў намёт свой, і глядзеў на Майсея, аж пакуль ён не ўваходзіў у Намёт. ");
INSERT INTO bel_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","I было, калі Майсей уваходзіў у Намёт, зыходзіў слуп воблачны і станавіўся каля ўваходу ў Намёт, і Бог гаварыў з Майсеем. ");
INSERT INTO bel_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","I бачыў увесь народ слуп воблачны, які стаяў каля ўваходу ў Намёт; і ўставаў увесь народ, і кланяўся кожны каля ўваходу ў намёт свой. ");
INSERT INTO bel_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","I гаварыў ГОСПАД з Майсеем абліччам да аблічча, як гаворыць чалавек з сябрам сваім; і ён вяртаўся ў табар; а служыцель ягоны Егошуа, сын Нуна, юнак, не адыходзіў з сярэдзіны Намёту. ");
INSERT INTO bel_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","I сказаў Майсей ГОСПАДУ: «Глядзі, Ты кажаш мне: “Узьвядзі народ гэты”, а Ты не паведаміў мне, каго пашлеш са мною. І Ты сказаў: “Я ведаю цябе на імя”, і таксама: “Ты знайшоў ласку ў вачах Маіх”. ");
INSERT INTO bel_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","I цяпер, калі я знайшоў ласку ў вачах Тваіх, дай мне спазнаць, прашу, шлях Твой, і я спазнаю Цябе, каб знайсьці ласку ў вачах Тваіх. І Ты паглядзі, што гэты народ — народ Твой». ");
INSERT INTO bel_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","І сказаў Госпад: «Аблічча Маё пойдзе перад табою, і Я супакою цябе». ");
INSERT INTO bel_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","I сказаў Майсей Яму: «Калі ня пойдзе аблічча Тваё, не выводзь нас адгэтуль. ");
INSERT INTO bel_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Бо з чаго я спазнаю, што знайшоў ласку ў вачах Тваіх, я і народ Твой? Ці не з таго, што Ты пойдзеш з намі? І будзем аддзеленыя я і народ Твой ад усіх народаў, якія на абліччы зямлі». ");
INSERT INTO bel_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","I сказаў ГОСПАД Майсею: «Таксама паводле гэтага слова, якое ты прамовіў, Я зраблю, бо ты знайшоў ласку ў вачах Маіх, і Я ведаю цябе на імя». ");
INSERT INTO bel_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","I сказаў Майсей: «Пакажы мне, прашу, славу Тваю». ");
INSERT INTO bel_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","I сказаў Госпад: «Я правяду перад абліччам тваім усю добрасьць Сваю, і назаву імя ГОСПАДА перад табою, і буду літасьцівы для таго, для каго буду літасьцівы, і буду міласьцівы для таго, для каго буду міласьцівы». ");
INSERT INTO bel_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","I сказаў Госпад: «Ня зможаш паглядзець на аблічча Маё, бо ня можа глядзець на Мяне чалавек і застацца жывы». ");
INSERT INTO bel_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","I сказаў ГОСПАД: «Вось месца пры Мне, і ты стань на гэтай скале. ");
INSERT INTO bel_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","I станецца, калі будзе ісьці слава Мая, Я пастаўлю цябе ў шчыліне скалы, і захіну цябе далоньню Маёй, пакуль не прайду. ");
INSERT INTO bel_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","I калі Я прыбяру далонь Маю, ты ўбачыш Мяне ззаду, але аблічча Маё ня будзе відаць». ");
INSERT INTO bel_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","I сказаў ГОСПАД Майсею: «Вычашы сабе дзьве табліцы каменныя, падобныя да першых, і Я напішу на тых табліцах словы, якія былі на першых табліцах, якія ты разьбіў. ");
INSERT INTO bel_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I будзь гатовы на раніцу, і ўзыйдзеш раніцаю на гару Сынай, і станеш перада Мною там на вяршыні гары. ");
INSERT INTO bel_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","І ніхто няхай ня ўзыйдзе з табою, і таксама ніхто няхай не паказваецца на ўсёй гары; таксама авечкі і валы ня будуць пасьвіцца насупраць гары гэтай». ");
INSERT INTO bel_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","I вычасаў Майсей дзьве табліцы каменныя, падобныя да першых, і ўстаў рана раніцай, і ўзыйшоў на гару Сынай, як загадаў яму ГОСПАД; і ўзяў у рукі свае дзьве табліцы каменныя. ");
INSERT INTO bel_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","I зыйшоў ГОСПАД у воблаку, і стаў там пры ім, і ён назваў імя ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","I прайшоў ГОСПАД перад абліччам ягоным, і абвясьціў: «ГОСПАД, ГОСПАД, Бог спагадлівы і літасьцівы, павольны да гневу і багаты на міласэрнасьць і праўду, ");
INSERT INTO bel_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Які захоўвае міласэрнасьць тысячам, Які даруе беззаконьне, і правіну, і грэх, але не пакідае без пакараньня, Які наведвае за беззаконьне бацькоў сыноў і сыноў сыноў да трэцяга і чацьвёртага пакаленьня». ");
INSERT INTO bel_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","I пасьпяшаўся Майсей, і схіліўся да зямлі, і пакланіўся, ");
INSERT INTO bel_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","і сказаў: «Калі я знайшоў ласку ў вачах Тваіх, Госпадзе, няхай ідзе Госпад сярод нас, бо народ гэты — народ з цьвёрдым каркам, і прабач беззаконьні нашыя і грахі нашыя, і мей нас за спадчыну Тваю». ");
INSERT INTO bel_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","I сказаў Госпад: «Вось, Я заключу запавет, перад усім народам тваім учыню цуды, якія не былі твораныя на ўсёй зямлі і ні ў якім з народаў; і ўбачыць увесь народ, сярод якога ты, учыненае ГОСПАДАМ, бо страшнае будзе тое, што Я ўчыню праз цябе. ");
INSERT INTO bel_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Захавай тое, што Я загадваю табе сёньня. Вось, Я выганю перад абліччам тваім Амарэя, Хананейца, Хета, Пэрэзэя, Хівея і Евусэя. ");
INSERT INTO bel_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Сьцеражыся, не заключай запавет з жыхарамі той зямлі, у якую ты ўвойдзеш, каб ён ня стаўся пасткаю сярод цябе. ");
INSERT INTO bel_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Але ахвярнікі іхнія скрышыце, і слупы іхнія паламіце, і гаі іхнія высячыце, ");
INSERT INTO bel_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","бо ня будзеш пакланяцца богу іншаму, акрамя ГОСПАДА; Зайздросны імя Ягонае, Ён — Бог зайздросны. ");
INSERT INTO bel_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Не заключай запавет з жыхарамі той зямлі, бо яны будуць распусьнічаць з багамі сваімі, і будуць складаць ахвяры багам сваім, і паклічуць цябе, і ты будзеш есьці ахвяры іхнія, ");
INSERT INTO bel_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","і возьмеш дочак іхніх сынам тваім, і яны будуць распусьнічаць з багамі сваімі, і будуць распусьнічаць сыны твае з багамі іхнімі. ");
INSERT INTO bel_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Багоў літых не рабіце сабе. ");
INSERT INTO bel_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Сьвята Праснакоў захоўвай. Сем дзён будзеш есьці праснакі, як Я загадаў табе, у вызначаным часе месяца Авіў, бо ў месяцы Авіў ты выйшаў з Эгіпту. ");
INSERT INTO bel_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Усё, што адкрывае ўлоньне, Мне належыць, і ўсё першароднае мужчынскага роду са статку твайго, вол і авечка. ");
INSERT INTO bel_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Асла, які адкрывае ўлоньне, выкупіш баранчыкам, а калі ня выкупіш, зламі карак ягоны. Усіх першародных сыноў тваіх выкупіш, і няхай ня бачаць аблічча Майго з пустымі рукамі. ");
INSERT INTO bel_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Шэсьць дзён працуй, а ў сёмы дзень супачынь; і ў часе араньня, і ў часе жніва супачынь. ");
INSERT INTO bel_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","I Сьвята Тыдняў зробіш сабе, і Сьвята Пяршынаў жніва пшаніцы, і Сьвята Збору ўраджаю ў канцы году. ");
INSERT INTO bel_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Тройчы ў год мае зьяўляцца кожны мужчына твой перад аблічча Госпада ГОСПАДА, Бога Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Бо Я выганю народы перад абліччам тваім, і пашыру межы твае, і ніхто не пажадае зямлі тваёй, калі ты ўзыйдзеш, каб зьявіцца перад абліччам ГОСПАДА, Бога твайго, тройчы ў год. ");
INSERT INTO bel_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Не ахвяроўвай над кіслым крыві ахвяры Маёй, і не пакідай на ноч да раніцы ахвяру Сьвята Пасхі. ");
INSERT INTO bel_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Першыя пяршыны зямлі тваёй прынось у дом ГОСПАДА, Бога твайго. Не вары казляняці ў малацэ маці ягонай». ");
INSERT INTO bel_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","I сказаў ГОСПАД Майсею: «Напішы сабе словы гэтыя, бо паводле гэтых словаў Я заключыў запавет з табою і з Ізраілем». ");
INSERT INTO bel_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","I быў там Майсей з ГОСПАДАМ сорак дзён і сорак начэй, хлеба ня еў і вады ня піў, і напісаў на табліцах словы запавету, Дзесяць словаў. ");
INSERT INTO bel_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","I сталася, калі зыходзіў Майсей з гары Сынай, і дзьве табліцы Сьведчаньня былі ў руцэ Майсея пры зыходзе яго з гары, а Майсей ня ведаў, што праменявала скура аблічча ягонага, бо Бог гаварыў з ім. ");
INSERT INTO bel_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","I ўбачыў Аарон і ўсе сыны Ізраіля Майсея, і вось, праменявала скура аблічча ягонага, і баяліся наблізіцца да яго. ");
INSERT INTO bel_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","I паклікаў іх Майсей, і зьвярнуліся да яго Аарон і ўсе начальнікі грамады, і прамовіў Майсей да іх. ");
INSERT INTO bel_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","I пасьля гэтага наблізіліся ўсе сыны Ізраіля, і ён загадаў ім усё, што ГОСПАД прамовіў да яго на гары Сынай. ");
INSERT INTO bel_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","I скончыў Майсей прамаўляць да іх, і ўсклаў на аблічча сваё заслону. ");
INSERT INTO bel_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","А калі Майсей узыходзіў перад аблічча ГОСПАДА, каб гаварыць з Ім, тады здыймаў заслону, аж пакуль не выходзіў. I выйшаў, і прамаўляў да сыноў Ізраіля, што было загадана яму. ");
INSERT INTO bel_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","I бачылі сыны Ізраіля аблічча Майсея, што праменявала скура аблічча Майсея, і ўскладаў Майсей заслону на аблічча сваё, пакуль не ўваходзіў, каб гаварыць з Богам. ");
INSERT INTO bel_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","I сабраў Майсей усю грамаду сыноў Ізраіля, і сказаў: «Вось словы, якія загадаў ГОСПАД, каб выконваць іх. ");
INSERT INTO bel_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Шэсьць дзён будзеш рабіць работу, а ў сёмы дзень будзе ў вас сьвята, супачынак супачынку для ГОСПАДА; кожны, хто будзе рабіць у ім работу, памрэ. ");
INSERT INTO bel_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Не паліце агню ў-ва ўсіх сядзібах вашых у дзень супачынку». ");
INSERT INTO bel_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","I сказаў Майсей усёй грамадзе сыноў Ізраіля: «Гэта слова, якое загадаў ГОСПАД, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“Зьбярыце ад сябе дар ГОСПАДУ. Кожны шляхетнага сэрца няхай прынясе дар ГОСПАДУ: золата, срэбра і медзь, ");
INSERT INTO bel_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","і блакіт, і пурпур, і барвовы кармазын, і вісон, і казіную поўсьць, ");
INSERT INTO bel_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","і скуры бараноў, фарбаваныя на чырвона, і скуры тахаш, і дрэва акацыі, ");
INSERT INTO bel_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","і алей для асьвятленьня, і пахошчы для алею памазаньня і для пахкага каджэньня, ");
INSERT INTO bel_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","і камяні оніксу, і камяні для аздабленьня эфоду і нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","I ўсе з вас, хто мудры сэрцам, няхай прыйдуць і зробяць усё, што загадаў ГОСПАД: ");
INSERT INTO bel_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Сялібу і намёт для яе, і пакрыцьцё для яе, гачыкі для яе і дошкі для яе, насілы яе, слупы яе і падстаўкі яе, ");
INSERT INTO bel_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Каўчэг Сьведчаньня і насілы для яго, накрыўку і заслону, якая вісіць, ");
INSERT INTO bel_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","стол і насілы для яго, і ўсё начыньне ягонае, і хлябы пакладныя, ");
INSERT INTO bel_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","і сьвечнік для асьвятленьня з начыньнямі ягонымі, і лямпы для яго, і алей для асьвятленьня, ");
INSERT INTO bel_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","і ахвярнік каджэньня, і насілы для яго, і алей памазаньня і пахкае кадзіла, і заслону на ўваходзе ў Сялібу, ");
INSERT INTO bel_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ахвярнік цэласпаленьня і крату мядзяную для яго, і насілы для яго, і ўсё начыньне ягонае, мыцельнік і падставу ягоную, ");
INSERT INTO bel_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","заслоны панадворку, слупы ягоныя і падстаўкі іхнія, і заслону на ўваходзе ў панадворак, ");
INSERT INTO bel_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","калкі Сялібы і калкі панадворку, і вяроўкі да іх, ");
INSERT INTO bel_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","адзеньні службовыя для служэньня ў сьвятыні, і адзеньні сьвятыя для Аарона сьвятара, і адзеньні для сыноў ягоных для служэньня сьвятарскага”». ");
INSERT INTO bel_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","I адыйшла ўся грамада сыноў Ізраіля ад аблічча Майсея. ");
INSERT INTO bel_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","I прыходзіў кожны чалавек, якога прынукала да гэтага сэрца ягонае, і кожны, якога заахвочваў дух ягоны, і прыносілі дар ГОСПАДУ на вырабленьне Намёту Спатканьня, і на ўсё служэньне ў ім, і на адзеньні сьвятыя. ");
INSERT INTO bel_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","I прыходзілі мужчыны і жанчыны, усе ахвотнага сэрца, і прыносілі кольцы і завушніцы, і пярсьцёнкі, і бранзалеты, і ўсялякія рэчы залатыя, і кожны, патрэсваючы, складаў золата для ГОСПАДА як ахвяру патрэсваньня. ");
INSERT INTO bel_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","I кожны, у каго быў блакіт і пурпур, і барвовы кармазын, і вісон, і казіная поўсьць, і скуры бараноў, фарбаваныя на чырвона, і скуры тахаш, прыносіў іх. ");
INSERT INTO bel_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","I кожны, хто ахвяроўваў дар срэбра і медзі, прыносіў гэты дар для ГОСПАДА. І кожны, у каго знайшлося дрэва акацыі, прыносіў яго на ўсялякую патрэбу служэньня. ");
INSERT INTO bel_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","I ўсе жанчыны, мудрыя сэрцам, пралі рукамі сваімі і прыносілі пражу блакіту, пурпуру і барвовага кармазыну, і вісону. ");
INSERT INTO bel_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","I ўсе жанчыны, якіх прынукала сэрца іхняе, пралі ў мудрасьці казіную поўсьць. ");
INSERT INTO bel_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","А начальнікі прыносілі камяні оніксу і камяні для аздабленьня эфоду і нагрудніку, ");
INSERT INTO bel_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","і пахошчы, і алей для асьвятленьня, і алей памазаньня, і пахкае кадзіла. ");
INSERT INTO bel_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Кожны мужчына і жанчына з сыноў Ізраіля, якіх заахвочвала сэрца іхняе прынесьці на ўсялякую работу, якую ГОСПАД загадаў зрабіць рукою Майсея, прыносілі дабраахвотна для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","I сказаў Майсей сынам Ізраіля: «Глядзіце, ГОСПАД паклікаў па іменьні Бэцалеэля, сына Урыя, сына Хура, з калена Юды, ");
INSERT INTO bel_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","і напоўніў яго Духам Божым, мудрасьцю, разумнасьцю, веданьнем і ўменьнем да ўсялякай працы, ");
INSERT INTO bel_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","і мастацкімі здольнасьцямі рабіць з золата, срэбра і медзі, ");
INSERT INTO bel_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","і абрабляць камяні для асаджэньня іх, і абрабляць дрэва, і рабіць з ім усялякую мастацкую работу. ");
INSERT INTO bel_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","I здольнасьць вучыць даў у сэрца яго і Агаліява, сына Ахісамаха, з калена Дана. ");
INSERT INTO bel_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","І Ён напоўніў іх мудрасьцю сэрца, каб яны рабілі ўсякую працу разьбяра, і мастака, і вышывальніка на блакіце, пурпуры, барвовым кармазыне і вісоне, і ткача, які робіць усякую працу і мастацкі аздабляе тканіну. ");
INSERT INTO bel_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","I зробіць Бэцалеэль, і Агаліяў, і кожны мудры сэрцам, якому даў ГОСПАД мудрасьць і разумнасьць у нутры іхнім, каб маглі зрабіць усю працу для служэньня ў сьвятыні, усё, як загадаў ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","I паклікаў Майсей Бэцалеэля, і Агаліява, і кожнага мудрага сэрцам, якому ГОСПАД даў мудрасьць у сэрца ягонае, усіх, каго прынукала сэрца ягонае ўзяцца за працу і зрабіць яе. ");
INSERT INTO bel_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","I ўзялі яны ад аблічча Майсея ўсе дары, якія прынесьлі сыны Ізраіля на працы для служэньня ў сьвятыні, каб зрабіць яе. І яны прыносілі да яго яшчэ дабраахвотна кожную раніцу. ");
INSERT INTO bel_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","I прыйшлі ўсе мудрыя, якія рабілі ўсялякія працы ў сьвятыні, кожны ад працы сваёй, якою яны займаліся, ");
INSERT INTO bel_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","і сказалі Майсею, кажучы: «Народ вельмі шмат прыносіць, больш, чым патрэбна для працы, якую загадаў ГОСПАД зрабіць». ");
INSERT INTO bel_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","I загадаў Майсей, і абвешчана было ўголас у табары, кажучы: «Ані мужчына, ані жанчына няхай ня робяць ужо нічога як дар для сьвятыні». І перастаў народ прыносіць дары. ");
INSERT INTO bel_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","I прынесенага на работу было даволі на ўсялякую працу, якую належала зрабіць, і яшчэ заставалася. ");
INSERT INTO bel_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","I зрабілі ўсе мудрыя сэрцам, якія займаліся працаю ў Сялібе, дзесяць палотнаў з кручанага вісону, блакіту, пурпуру і барвовага кармазыну, і херувімаў майстэрскай работай зрабілі на іх. ");
INSERT INTO bel_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Даўжыня аднаго палатна — дваццаць восем локцяў, а шырыня аднаго палатна — чатыры локці. Адна мера для ўсіх палотнаў. ");
INSERT INTO bel_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","I злучыў Бэцалеэль пяць палотнаў адно з адным, і пяць іншых палотнаў злучыў адно з адным. ");
INSERT INTO bel_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","I зрабіў пяцелькі з блакіту на краі аднаго палатна для спінаньня; гэтак зрабіў ён на краі апошняга палатна, для спінаньня з іншага боку. ");
INSERT INTO bel_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Пяцьдзясят пяцелек зрабіў ён на адным палатне, і пяцьдзясят пяцелек зрабіў на канцы палатна для спінаньня з другім; пяцелькі гэтыя — насупраць адна адной. ");
INSERT INTO bel_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","I зрабіў пяцьдзясят гачыкаў залатых, і злучыў гачыкамі палотны адно з адным, і сталася Сяліба адным цэлым. ");
INSERT INTO bel_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","I зрабіў палотны з казінае поўсьці для намёту Сялібы; адзінаццаць палотнаў зрабіў іх. ");
INSERT INTO bel_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Даўжыня аднаго палатна — трыццаць локцяў, і чатыры локці — шырыня аднаго палатна; мера адна для адзінаццаці палотнаў. ");
INSERT INTO bel_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","I злучыў ён пяць палотнаў асобна, і шэсьць палотнаў асобна. ");
INSERT INTO bel_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","I зрабіў пяцьдзясят пяцелек на краі палатна на канцы для спінаньня, і пяцьдзясят пяцелек зрабіў на краі палатна для спінаньня з іншага боку. ");
INSERT INTO bel_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","I зрабіў пяцьдзясят гачыкаў мядзяных для злучэньня намёту, каб быў адным цэлым. ");
INSERT INTO bel_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","I зрабіў пакрыцьцё на намёт са скураў бараноў, фарбаваных на чырвона, і пакрыцьцё на верх са скураў тахаш. ");
INSERT INTO bel_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","I зрабіў дошкі для Сялібы, якія будуць стаяць проста, з дрэва акацыі. ");
INSERT INTO bel_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Дзесяць локцяў — даўжыня дошкі, і паўтары локці — шырыня адной дошкі. ");
INSERT INTO bel_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Па два шыпы ў кожнай дошцы, асаджаныя адзін насупраць другога; гэтак зрабіў ён у-ва ўсіх дошках Сялібы. ");
INSERT INTO bel_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","I зрабіў дошкі для Сялібы — дваццаць дошак для паўднёвага боку, што глядзіць на поўдзень. ");
INSERT INTO bel_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","I сорак срэбных падставак зрабіў пад дваццаць дошак: дзьве падстаўкі пад адну дошку да двух шыпоў ейных, і дзьве падстаўкі пад другую дошку да двух шыпоў ейных. ");
INSERT INTO bel_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","I да другога боку сялібы, што глядзіць на поўнач, зрабіў дваццаць дошак, ");
INSERT INTO bel_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","і сорак падставак для іх срэбных: дзьве падстаўкі пад адну дошку, і дзьве падстаўкі пад другую дошку. ");
INSERT INTO bel_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","I да задняга боку Сялібы, што глядзіць на захад, зрабіў шэсьць дошак. ");
INSERT INTO bel_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","I дзьве дошкі зрабіў для вуглоў Сялібы пры заходнім боку. ");
INSERT INTO bel_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","I яны былі злучаныя ўнізе, і разам злучаныя ўгары адным колцам. Гэтак зрабіў ён з імі абедзьвума на абодвух вуглах. ");
INSERT INTO bel_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","I так было восем дошак, і падставак іхніх срэбных шаснаццаць, дзьве падстаўкі пад адну дошку, і дзьве падстаўкі пад другую дошку. ");
INSERT INTO bel_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","I зрабіў ён жэрдкі з дрэва акацыі, пяць жэрдак да дошак аднаго боку сялібы, ");
INSERT INTO bel_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","і пяць жэрдак да дошак другога боку сялібы, і пяць жэрдак да дошак задняга боку сялібы. ");
INSERT INTO bel_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","I зрабіў сярэднюю жэрдку, што праходзіла пасярэдзіне дошак ад аднаго канца да другога. ");
INSERT INTO bel_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","I дошкі пакрыў золатам; і колцы на іх для ўкладаньня жэрдак зрабіў з золата, і жэрдкі пакрыў золатам. ");
INSERT INTO bel_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","I зрабіў заслону з блакіту, пурпуру, барвовага кармазыну і кручанага вісону; і мастацкай работай зрабіў на ёй херувімаў. ");
INSERT INTO bel_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","I зрабіў да яе чатыры слупы з акацыі, і пакрыў іх золатам, і кручкі на іх — залатыя, і выліў да іх чатыры падстаўкі срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","I зрабіў заслону на ўваходзе намёту з блакіту, пурпуру, барвовага кармазыну і кручанага вісону, гафтаванае работы, ");
INSERT INTO bel_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","і слупоў для яе пяць з кручкамі да іх, і пакрыў вярхі іхнія і клямкі іхнія золатам, і выліў да іх пяць падставак мядзяных. ");
INSERT INTO bel_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","I зрабіў Бэцалеэль каўчэг з дрэва акацыі; два локці з паловаю даўжыня яго, і паўтары локці шырыня яго, і паўтары локці вышыня яго. ");
INSERT INTO bel_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","I пакрыў яго шчырым золатам унутры і звонку, і зрабіў наўкола яго вянок залаты. ");
INSERT INTO bel_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","I выліў да яго чатыры колцы залатыя, на чатырох кутах яго, два колцы на адным баку яго, і два колцы на другім баку яго. ");
INSERT INTO bel_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","I зрабіў насілы з дрэва акацыі, і пакрыў іх золатам. ");
INSERT INTO bel_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","I ўлажыў насілы ў колцы па баках каўчэга, каб насіць каўчэг. ");
INSERT INTO bel_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","I зрабіў накрыўку са шчырага золата; два локці з паловаю даўжыня яе, і паўтары локці шырыня яе. ");
INSERT INTO bel_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","I зрабіў двух херувімаў з золата; каванымі зрабіў іх з абодвух бакоў накрыўкі: ");
INSERT INTO bel_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","аднаго херувіма з гэтага канца, і аднаго херувіма з другога канца; разам з накрыўкай зрабіў херувімаў на абодвух баках яе. ");
INSERT INTO bel_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","I былі херувімы распусьціўшы крылы ўгару, і захіналі крыламі сваімі накрыўку, а абліччамі сваімі былі зьвернуты адзін да аднаго; да накрыўкі былі зьвернуты абліччы херувімаў. ");
INSERT INTO bel_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","I зрабіў стол з дрэва акацыі, два локці даўжыня яго, і локаць шырыня яго, і паўтары локці вышыня яго. ");
INSERT INTO bel_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","I пакрыў яго шчырым золатам, і зрабіў яму вянок залаты наўкола. ");
INSERT INTO bel_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","I зрабіў яму наўкола ліштву шырынёю ў далонь, і зрабіў вянок залаты для ліштвы ягонай. ");
INSERT INTO bel_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","I выліў для яго чатыры колцы залатыя, і прыладзіў колцы да чатырох рагоў, якія пры чатырох ножках ягоных. ");
INSERT INTO bel_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Пры ліштвах былі колцы, каб укладаць насілы і насіць стол. ");
INSERT INTO bel_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","I зрабіў насілы з дрэва акацыі для нашэньня стала, і пакрыў іх золатам. ");
INSERT INTO bel_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","I зрабіў са шчырага золата начыньне, што на стале: місы ягоныя, і чашы ягоныя, кубкі ягоныя і збаны, каб наліваць імі. ");
INSERT INTO bel_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","I зрабіў сьвечнік са шчырага золата, каваным зрабіў сьвечнік; падстава яго, і сьця­бло яго, чарачкі яго, яблыкі яго і кветкі яго выходзілі з яго. ");
INSERT INTO bel_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","I шэсьць сьцяблінаў выходзіла з бакоў яго: тры сьцябліны сьвечніка з аднаго боку яго, і тры сьцябліны сьвечніка з другога боку яго. ");
INSERT INTO bel_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Тры чарачкі, падобныя да мігдалу, з яблыкам і кветкаю, былі на адной сьцябліне, і тры чарачкі, падобныя да мігдалу, з яблыкам і кветкаю, былі на другой сьцябліне. Гэтак на шасьці сьцяблінах, што выходзяць са сьвечніка, ");
INSERT INTO bel_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","А на камлі сьвечніка былі чатыры чарачкі, падобныя да мігдалу, з яблыкам і кветкаю. ");
INSERT INTO bel_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","I яблык пад двума сьцяблінамі, што выходзяць з яго, і яблык пад двума сьцяблінамі, што выходзяць з яго, і яблык пад двума галінамі, што выходзяць з яго, на шасьці сьцяблінах, што выходзяць з яго. ");
INSERT INTO bel_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Яблыкі іхнія і сьцябліны іхнія выходзілі з яго; ён увесь суцэльна каваны са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","I зрабіў сем лямпаў для яго, і абцужкі да яго, і папяльнічку да яго са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","З таленту золата шчырага зрабіў яго з усімі прыладамі ягонымі. ");
INSERT INTO bel_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","I зрабіў ахвярнік каджэньня з дрэва акацыі; локаць — даўжыня яго, і локаць — шырыня яго, ён чатырохкутны; і два локці — вышыня ягоная; з яго выходзілі рогі ягоныя. ");
INSERT INTO bel_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","I пакрыў яго шчырым золатам, верх ягоны і сьценкі ягоныя наўкола, і рогі ягоныя, і зрабіў да яго вянок залаты наўкола. ");
INSERT INTO bel_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","I два колцы залатыя зрабіў пад вянком ягоным на двух вуглах ягоных; з двух бакоў ягоных зрабіў месцы да насілаў, каб насіць яго на іх. ");
INSERT INTO bel_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","I зрабіў насілы з дрэва акацыі, і пакрыў іх золатам. ");
INSERT INTO bel_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","I зрабіў алей памазаньня сьвятога і пахкае кадзіла чыстае, работы мяшальніка масьцяў. ");
INSERT INTO bel_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","I зрабіў ахвярнік цэласпаленьня з дрэва акацыі, пяць локцяў даўжыня яго і пяць локцяў шырыня яго, ён чатырохкутны, і тры локці вышыня яго. ");
INSERT INTO bel_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","I зрабіў рогі ягоныя на чатырох вуглах ягоных, з яго выходзілі рогі ягоныя; і пакрыў іх медзьдзю. ");
INSERT INTO bel_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","I зрабіў усе начыньні ахвярніка: гаршчкі, лапаткі, місы, відэльцы і кадзільніцы; усе начыньні ягоныя зрабіў з медзі. ");
INSERT INTO bel_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","I зрабіў да ахвярніка крату, плеценай работы, мядзяную, пад вобадам зьнізу да паловы яго. ");
INSERT INTO bel_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","I выліў чатыры колцы на чатырох вуглах краты мядзянай, каб укладаць насілы. ");
INSERT INTO bel_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","I зрабіў насілы з дрэва акацыі, і пакрыў іх медзьдзю. ");
INSERT INTO bel_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","I ўлажыў насілы ў колцы на баках ахвярніка для нашэньня яго імі. Пустым унутры зрабіў яго з дошак. ");
INSERT INTO bel_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","I зрабіў мыцельнік мядзяны і падставу ягоную мядзяную з люстэрак жанчынаў, якія зьбіраліся каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","I зрабіў панадворак: з паўднёвага боку, што глядзіць на поўдзень — заслоны з кручанага вісону ў сто локцяў, ");
INSERT INTO bel_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","слупоў да іх дваццаць і падставак да іх дваццаць мядзяных, а кручкі на слупах і клямкі да іх срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","I на паўночным баку — заслоны ў сто локцяў, слупоў да іх дваццаць і падставак да іх дваццаць мядзяных; а кручкі на слупах і клямкі да іх — срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","I з заходняга боку — заслоны ў пяцьдзясят локцяў, слупоў да іх дзесяць і падставак да іх дзесяць; а кручкі на слупах і клямкі да іх — срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","I з пярэдняга боку, што глядзіць на ўсход — адлегласьць у пяцьдзясят локцяў. ");
INSERT INTO bel_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Пятнаццаць локцяў — заслоны з аднаго краю, слупоў да іх тры і падставак да іх тры. ");
INSERT INTO bel_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","I з другога краю, з іншага боку брамы панадворку — заслоны ў пятнаццаць локцяў; слупоў да іх тры і падставак да іх тры. ");
INSERT INTO bel_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Усе заслоны вакол панадворку — з кручанага вісону, ");
INSERT INTO bel_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","і падстаўкі да слупоў мядзяныя, кручкі на слупах і клямкі да іх — срэбныя, і пакрытыя вярхі іхнія срэбрам, і ўсе яны павязаныя срэбрам, усе слупы панадворку. ");
INSERT INTO bel_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Заслона для брамы панадворку — гафтаванае работы з блакіту, пурпуру, барвовага кармазыну і кручанага вісону, дваццаць локцяў — даўжыня яе, а вышыня і шырыня яе — пяць локцяў, падобна да іншых заслонаў панадворку; ");
INSERT INTO bel_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","і слупоў да яе чатыры, і падставак да іх чатыры мядзяных; кручкі іхнія срэбныя, і пакрыцьцё вярхоў іх і клямкі да іх срэбныя. ");
INSERT INTO bel_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","А ўсе калкі Сялібы і панадворку наўкола — мядзяныя. ");
INSERT INTO bel_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Вось каштарыс Сялібы, Сялібы Сьведчаньня, які падлічаны паводле словаў Майсея працаю лявітаў пад рукою Ітамара, сына Аарона, сьвятара. ");
INSERT INTO bel_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","І Бэцалеэль, сын Урыя, сын Хура, з калена Юды, зрабіў усё, што загадаў ГОСПАД Майсею; ");
INSERT INTO bel_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","а з ім Агаліяў, сын Ахісамаха, з калена Дана, разьбяр і мастак, і вышывальнік на блакіце, пурпуры, барвовым кармазыне і вісоне. ");
INSERT INTO bel_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Усяго золата, ужытага на работу, на ўсе працы ў сьвятыні, — а было гэта золата, ахвяраванае патрэсваньнем, — было дваццаць дзевяць талентаў і сямсот трыццаць сыкляў, паводле сыкля сьвятыні. ");
INSERT INTO bel_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","А срэбра ад палічаных у грамадзе было сто талентаў і тысяча сямсот семдзясят пяць сыкляў, паводле сыкля сьвятыні. ");
INSERT INTO bel_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Бэка з галавы, значыцца, палова сыкля, паводле сыкля сьвятыні, з кожнага, хто прыйшоў, каб быць палічаным, ад дваццаці гадоў і вышэй, з шасьцісот трох тысячаў пяцьсот пяцідзесяці чалавек. ");
INSERT INTO bel_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","I было сто талентаў срэбра ўжыта на адліцьцё падставак сьвятыні і падставак заслонаў; сто падставак са ста талентаў, па таленту на падстаўку. ");
INSERT INTO bel_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","А з тысячы сямсот сямідзесяці пяці сыкляў зрабіў Бэцалеэль кручкі на слупах, і пакрыў вярхі іхнія, і злучыў іх клямкамі. ");
INSERT INTO bel_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","А медзі, ахвяраванай патрэсваньнем, было семдзясят талентаў і дзьве тысячы чатырыста сыкляў. ");
INSERT INTO bel_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","І зрабіў ён з яе падстаўкі да слупоў каля ўваходу ў Намёт Спатканьня, і ахвярнік мядзяны, і крату мядзяную да яго, і ўсё начыньне ахвярніка, ");
INSERT INTO bel_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","і падстаўкі панадворку наўкола, і падстаўкі брамы панадворку, і ўсе калкі Сялібы, і ўсе калкі панадворку наўкола. ");
INSERT INTO bel_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","А з блакіту, пурпуру і барвовага кармазыну зрабілі яны службовыя адзеньні для служэньня ў сьвятыні; і зрабілі адзеньні сьвятыя для Аарона, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","I зрабіў Бэцалеэль эфод з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону. ");
INSERT INTO bel_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","I выкляпалі яны бляшкі залатыя, і павыціналі з іх ніткі, каб уплесьці іх у блакіт, пурпур, барвовы кармазын і вісон мастацкаю работаю. ");
INSERT INTO bel_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Нараменьнікі зрабілі да яго злучаныя; на двух канцах сваіх яны былі злучаныя. ");
INSERT INTO bel_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","I пас эфоду, які падпярэзвае яго, аднолькавае з ім работы, з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","I зрабілі камяні оніксу, асадзіўшы іх у аправы залатыя, і выразалі на іх, як выразаюць пячатку, імёны сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","I палажыў ён іх на нараменьнікі эфоду, як камяні на ўспамін пра сыноў Ізраіля, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","I зрабіў нагруднік мастацкаю работаю, такою самаю работаю, як эфод, з золата, блакіту, пурпуру, барвовага кармазыну і кручанага вісону. ");
INSERT INTO bel_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ён быў чатырохкутны; падвойным зрабілі яны нагруднік, у пядзю даўжыня ягоная і ў пядзю шырыня ягоная, ён падвойны. ");
INSERT INTO bel_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","I напоўнілі яго чатырма шэрагамі камянёў у шэраг. Рубін, тапаз і шмарагд — шэраг адзін. ");
INSERT INTO bel_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","А шэраг другі — гранат, шафір і дыямэнт. ");
INSERT INTO bel_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","А шэраг трэці — яхонт, агат і амэтыст. ");
INSERT INTO bel_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","А шэраг чацьвёрты — хрызаліт, онікс і ясьпіс. Яны асаджаныя ў золата ў аправах сваіх. ");
INSERT INTO bel_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","I камяні паводле імёнаў імёнаў сыноў Ізраіля, іх дванаццаць паводле імёнаў іхніх, і выразанае як пячатка на кожным імя сваё паводле дванаццаці плямёнаў. ");
INSERT INTO bel_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","I зрабілі для нагрудніку ланцужкі плеценыя вітою работаю, са шчырага золата. ");
INSERT INTO bel_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","I зрабілі дзьве аправы залатыя і два колцы залатыя, і прымацавалі два колцы да двух канцоў нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","I ўклалі два плеценыя залатыя ланцужкі ў абодва колцы па канцах нагрудніку. ");
INSERT INTO bel_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","А іншыя два канцы двух ланцужкоў прычапілі да двух аправаў і прымацавалі іх да нараменьнікаў эфоду з пярэдняга боку яго. ");
INSERT INTO bel_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","I зрабілі два колцы залатыя, і прымацавалі да двух канцоў нагрудніку на тым краі ягоным, які пры ўнутраным боку эфоду. ");
INSERT INTO bel_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","I зрабілі два колцы залатыя, і прымацавалі іх да двух нараменьнікаў эфоду зьнізу, з пярэдняга боку ягонага, каля злучэньня ягонага, над пасам эфоду. ");
INSERT INTO bel_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","I прымацавалі нагруднік колцамі ягонымі да колцаў эфоду шнурком з блакіту, каб ён быў над пасам эфоду, і каб ня ссоваўся нагруднік з эфоду, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","I зрабіў Бэцалеэль верхнюю шату да эфоду, тканую ўсю з блакіту, ");
INSERT INTO bel_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","і адтуліну шаты ў сярэдзіне яе, як адтуліна панцыра, і абшыўку наўкола адтуліны, каб не разьдзёрлася. ");
INSERT INTO bel_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","I зрабілі яны на прыполе верхняе шаты яблыкі гранатовыя з блакіту, пурпуру і барвовага кармазыну кручанага. ");
INSERT INTO bel_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","I зрабілі званочкі са шчырага золата, і памясьцілі званочкі паміж гранатовых яблыкаў на прыполе верхняе шаты наўкола, паміж гранатовых яблыкаў, ");
INSERT INTO bel_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","званочак і гранатовы яблык, званочак і гранатовы яблык, на прыполе верхняе шаты наўкола для служэньня, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","I зрабілі хітоны з вісону, тканае работы, для Аарона і сыноў ягоных, ");
INSERT INTO bel_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","і мітру з вісону, і турбаны аздобныя з вісону, і нагавіцы ільняныя з кручанага вісону, ");
INSERT INTO bel_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","і пояс з кручанага вісону, блакіту, пурпуру і барвовага кармазыну, гафтаванае работы, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","I зрабілі дыядэму вянца сьвятасьці са шчырага золата, і напісалі на ёй пісьмом, як выразаюць на пячатцы: “Сьвятыня для ГОСПАДА”, ");
INSERT INTO bel_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","і прымацавалі да яе шнурок з блакіту, каб прывязваць яе да мітры зьверху, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","I скончылася ўся праца пабудовы Сялібы, Намёту Спатканьня, і зрабілі сыны Ізраіля ўсё; як загадаў ГОСПАД Майсею, так і зрабілі. ");
INSERT INTO bel_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","I прынесьлі да Майсея Сялібу, намёт і ўсе прыналежнасьці ягоныя, гачыкі ягоныя, дошкі ягоныя, жэрдкі ягоныя, слупы ягоныя і падстаўкі ягоныя, ");
INSERT INTO bel_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","і пакрыцьцё са скураў бараноў, фарбаваных на чырвона, і пакрыцьцё са скураў тахаш, і заслону, якая вісіць, ");
INSERT INTO bel_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Каўчэг Сьведчаньня, і насілы ягоныя, і накрыўку ягоную, ");
INSERT INTO bel_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","стол, усе начыньні ягоныя і хлябы пакладныя, ");
INSERT INTO bel_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","сьвечнік чысты, лямпы ягоныя, лямпы ў шэрагах, і ўсё начыньне ягонае, і алей для асьвятленьня, ");
INSERT INTO bel_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","і ахвярнік залаты, і алей памазаньня, і пахкае кадзіла, і заслону на ўваходзе ў намёт, ");
INSERT INTO bel_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ахвярнік мядзяны і крату мядзяную да яго, насілы ягоныя і ўсё начыньне ягонае, мыцельнік і падставу ягоную, ");
INSERT INTO bel_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","заслоны панадворку, слупы ягоныя і падстаўкі ягоныя, заслону да брамы панадворку, вяроўкі ягоныя і калкі ягоныя, і ўсе прыналежнасьці да служэньня Сялібы ў Намёце Спатканьня, ");
INSERT INTO bel_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","адзеньні службовыя да служэньня ў сьвятыні, адзеньні сьвятыя для Аарона сьвятара і адзеньні для сыноў ягоных да служэньня сьвятарскага. ");
INSERT INTO bel_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Усё, як загадаў ГОСПАД Майсею, так і зрабілі сыны Ізраіля, усю працу. ");
INSERT INTO bel_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","I ўбачыў Майсей усё зробленае, і вось, яны зрабілі гэта; як загадаў ГОСПАД, так і зрабілі. I дабраславіў іх Майсей. ");
INSERT INTO bel_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","I прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«У першы месяц, у першы дзень месяца паставіш Сялібу Намёту Спатканьня. ");
INSERT INTO bel_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I паставіш там Каўчэг Сьведчаньня, і закрыеш Каўчэг заслонаю. ");
INSERT INTO bel_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","I ўнясеш стол, і разложыш на ім тое, што належыць, і ўнясеш сьвечнік, і запаліш лямпы ягоныя. ");
INSERT INTO bel_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","I паставіш ахвярнік залаты для каджэньня перад Каўчэгам Сьведчаньня; і завесіш заслону на ўваходзе ў Сялібу. ");
INSERT INTO bel_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","I паставіш ахвярнік цэласпаленьня перад уваходам у Сялібу Намёту Спатканьня. ");
INSERT INTO bel_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","I паставіш мыцельнік паміж Намётам Спатканьня і ахвярнікам, і нальеш у яго вады. ");
INSERT INTO bel_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","I паставіш панадворак наўкола, і завесіш заслону ў браме панадворку. ");
INSERT INTO bel_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","I возьмеш алей памазаньня, і памажаш Сялібу і ўсё, што ў ёй, і асьвяціш яе і ўсе прыналежнасьці ейныя, і бу­дзе Сьвятой. ");
INSERT INTO bel_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","I памажаш ахвярнік цэласпаленьня і ўсё начыньне ягонае, і асьвяціш ахвярнік, і будзе ахвярнік Сьвятым Сьвятых. ");
INSERT INTO bel_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","I памажаш мыцельнік і падставу ягоную, і асьвяціш яго. ");
INSERT INTO bel_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","I наблізіш Аарона і сыноў ягоных да ўваходу ў Намёт Спатканьня, і абмыеш іх вадою. ");
INSERT INTO bel_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","I апранеш Аарона ў адзеньні сьвятыя, і памажаш яго, і асьвяціш яго, і ён будзе сьвятаром Маім. ");
INSERT INTO bel_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","I сыноў ягоных наблізіш, і апранеш іх у хітоны, ");
INSERT INTO bel_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","і памажаш іх, як ты памазаў бацьку іхняга, і яны будуць сьвятарамі Маімі, і будзе ім памазаньне іхняе на сьвятарства вечнае ў пакаленьнях іхніх». ");
INSERT INTO bel_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","I зрабіў Майсей усё; як загадаў яму ГОСПАД, так і зрабіў. ");
INSERT INTO bel_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I сталася, у першы месяц другога году, у першы дзень месяца была пастаўлена Сяліба. ");
INSERT INTO bel_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","I паставіў Майсей Сялібу, і палажыў падстаўкі яе, і паставіў дошкі яе, і палажыў жэрдкі яе, і паставіў слупы яе, ");
INSERT INTO bel_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","і расьцягнуў намёт над Сялібай, і палажыў пакрыцьцё намёту зьверху над ім, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","I ўзяў, і палажыў Сьведчаньне ў Каўчэг, і ўлажыў насілы ў Каўчэг, і палажыў накрыўку на Каўчэг зьверху. ");
INSERT INTO bel_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","I ўнёс Каўчэг у Сялібу, і завесіў заслону, якая вісіць, і засланіў ёю Каўчэг Сьведчаньня, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","I паставіў стол у Намёт Спатканьня, на паўночным баку Сялібы, звонку ад заслоны. ");
INSERT INTO bel_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","I разлажыў шэрагі хлябоў перад абліччам ГОСПАДА, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","I паставіў сьвечнік у Намёт Спатканьня насупраць стала, на паўднёвым баку Сялібы. ");
INSERT INTO bel_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","I запаліў лямпы перад абліччам ГОСПАДА, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","I паставіў ахвярнік залаты ў Намёце Спатканьня перад заслонаю. ");
INSERT INTO bel_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","I кадзіў на ім пахкім кадзілам, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","I завесіў заслону на ўваходзе ў Сялібу. ");
INSERT INTO bel_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","I ахвярнік цэласпаленьня паставіў каля ўваходу ў Сялібу Намёту Спатканьня, і ахвяраваў на ім цэласпаленьне і ахвяру хлебную, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","I паставіў мыцельнік паміж Намётам Спатканьня і ахвярнікам, і наліў у яго вады для абмываньня. ");
INSERT INTO bel_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","I абмывалі ў ім Майсей і Аарон, і сыны ягоныя рукі свае і ногі свае. ");
INSERT INTO bel_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Калі ўваходзілі ў Намёт Спатканьня і калі набліжаліся да ахвярніка, яны абмываліся, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","I паставіў панадворак вакол Сялібы і ахвярніка, і завесіў заслону ў браме панадворку. I скончыў Майсей работу. ");
INSERT INTO bel_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","І закрыла воблака Намёт Спатканьня, і слава ГОСПАДА напоўніла Сялібу. ");
INSERT INTO bel_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","I ня мог Майсей увайсьці ў Намёт Спатканьня, бо ляжала на ім воблака, і слава ГОСПАДА напаўняла Сялібу. ");
INSERT INTO bel_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","I калі падымалася воблака па-над Сялібаю, тады вырушалі сыны Ізраіля ў-ва ўсе падарожжы свае. ");
INSERT INTO bel_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","А калі не падымалася воблака, тады не вырушалі, аж да дня, калі яно падымалася. ");
INSERT INTO bel_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Бо воблака ГОСПАДА было над Сялібай удзень, і агонь быў над ёй уначы перад вачыма ўсяго дому Ізраіля ў-ва ўсіх падарожжах іхніх.");
INSERT INTO bel_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1"," І паклікаў ГОСПАД Майсея, і прамовіў да яго з Намёту Спатканьня, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Калі хто з вас захоча скласьці ахвяру з хатняе жывёлы, няхай складае ахвяру з валоў або жывёл драбнейшых. ");
INSERT INTO bel_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Калі ён захоча скласьці ахвяру цэласпаленьня з быдла, няхай ахвяруе самца без заганы і прывядзе яго да ўваходу Намёту Спатканьня, каб ГОСПАД прыняў яго ласкава, ");
INSERT INTO bel_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","і паложыць руку на галаву ахвяры, каб была прынята як перамаленьне за яго. ");
INSERT INTO bel_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Потым заб’е цяля перад ГОСПАДАМ, а сыны Аарона, сьвятары, ахвяруюць кроў і пакрапяць ёю кругом ахвярнік, які стаіць перад уваходам у Намёт Спатканьня; ");
INSERT INTO bel_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","а пасьля здыме ён скуру з ахвяры цэласпаленьня і пасячэ ахвяру на часткі. ");
INSERT INTO bel_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Сыны ж Аарона, сьвятары, прынясуць агонь на ахвярнік і паложаць дровы на агні. ");
INSERT INTO bel_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Потым сыны Аарона, сьвятары, паложаць часткі разам з галавой і тлушчам на дровах, што ляжаць на агні на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","А нутро ахвяры і ногі яе вымые ён вадою, і спаліць сьвятар усё гэта на ахвярніку; гэта цэласпаленьне, ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Калі вось хто хоча скласьці ахвяру цэласпаленьня з дробнай жывёлы, з авечак або козаў, няхай возьме самца без заганы, ");
INSERT INTO bel_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","і заб’е яго перад ГОСПАДАМ на паўночным баку ахвярніка, а сыны Аарона, сьвятары, пакропяць крывёй яго ахвярнік наўкола. ");
INSERT INTO bel_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","І расьсячэ яго на часткі, а сьвятар паложыць іх разам з галавой і тлушчам на дровы, што ляжаць на агні на ахвярніку, ");
INSERT INTO bel_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","а нутро і ногі вымые ён вадой; і сьвятар зложыць гэта ўсё на ахвярніку і спаліць; гэта цэласпаленьне, ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","А калі хто захоча скласьці ў ахвяру ГОСПАДУ птушку на цэласпаленьне, няхай ахвяруе туркаўку або маладога галуба. ");
INSERT INTO bel_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","І сьвятар прынясе яго на ахвярнік, зломіць яму галаву і спаліць на ахвярніку, а кроў яго выцісьне на сьцяну ахвярніка; ");
INSERT INTO bel_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","і возьме валяк з пер’ем, і выкіне каля ахвярніку на ўсходнім баку, дзе попел; ");
INSERT INTO bel_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","і надломіць яго паміж крыламі, не аддзяляючы іх, і спаліць іх сьвятар на ахвярніку, на дровах, што ляжаць на агні; гэта цэласпаленьне, ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Калі хто захоча скласьці ахвяру хлебную ГОСПАДУ, няхай прынясе пшанічнай мукі, зьмяшае яе з алеем і дадасьць да яе кадзіла, ");
INSERT INTO bel_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","потым прынясе яе да сьвятароў, сыноў Аарона, і возьме сьвятар поўную жменю мукі з алеем і з усім кадзілам і спаліць гэта як памятную частку на ахвярніку; гэта ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","А што застанецца ад ахвяры хлебнай, будзе для Аарона і сыноў ягоных. Гэта сьвятое сьвятых з ахвяраў агнявых для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Калі захочаш скласьці ахвяру хлебную, з мукі, печанай у печы, няхай гэта будуць праснакі, запраўленыя алеем, ці аладкі прэсныя, памазаныя алеем. ");
INSERT INTO bel_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Калі ахвяра тая будзе з патэльні, няхай будзе з пшанічнай мукі, няквашанай, запраўленай алеем. ");
INSERT INTO bel_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Падзеліш яе на кавалкі і пальеш яе алеем. Гэта ахвяра хлебная. ");
INSERT INTO bel_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Калі ахвяра твая будзе ў гаршчку смажаная, няхай яна будзе з мукі, запраўленай алеем. ");
INSERT INTO bel_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Тады прынясеш гэтак прыгатаваную ахвяру ГОСПАДУ і аддасі яе ў рукі сьвятара, а ён прынясе яе да ахвярніка; ");
INSERT INTO bel_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","і возьме сьвятар памятную частку яе, і спаліць на ахвярніку; гэта ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","А ўсё, што застанецца, будзе для Аарона і сыноў ягоных. Гэта сьвятое сьвятых з ахвяраў агнявых для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Усякая ахвяра з мукі, якую складаеце Госпаду, няхай ня будзе квашанай, бо анічога квашанага, ані мёду не павінны вы паліць у ахвяру ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Прыносьце гэтыя рэчы як пяршыны, як дары ГОСПАДУ, але не кладзіце іх на ахвярнік, каб паліць на пах прыемны. ");
INSERT INTO bel_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Кожную ахвяру, якую складаеш з ежы, пасалі сольлю. І не пакідай хлебнай ахвяры тваёй бяз солі запавету Бога твайго. Кожную ахвяру тваю пасалі сольлю. ");
INSERT INTO bel_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Калі прыносіш ахвяру з пяршынаў пладоў тваіх ГОСПАДУ, прынось каласы, высушаныя на агні, або тоўчанае зерне як ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","палі іх алеем і палажы на іх кадзіла. Гэта ахвяра хлебная. ");
INSERT INTO bel_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","І спаліць сьвятар як памятную частку з тоўчанага зерня і алею з усім кадзілам. Гэта ахвяра агнявая для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Калі чыя ахвяра ёсьць ахвярай мірнай, ён складае яе з валоў; самца або саміцу без заганы няхай прыносіць ГОСПАДУ, ");
INSERT INTO bel_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","і паложыць руку сваю на галаву ахвяры сваёй, якую заб’е перад уваходам у Намёт Спатканьня, а пасьля сьвятары, сыны Аарона, пакропяць ахвярнік крывёю яе наўкола. ");
INSERT INTO bel_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","І складзе ён з ахвяры мірнай ахвяру цэласпаленьня ГОСПАДУ з тлустасьці, што пакрывае нутро, і ўвесь тлушч, які над ім, ");
INSERT INTO bel_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","а таксама абедзьве ныркі і тлушч на іх, які на сьцёгнах, і тлушч, які на вантробе; разам з ныркамі няхай аддзеліць яго. ");
INSERT INTO bel_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","І сыны Аарона спаляць гэта на ахвярніку як цэласпаленьне на дровах, якія на агні; гэта ахвяра цэласпаленьня, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Калі б чыя ахвяра складалася з дробнай жывёлы як ахвяра мірная для ГОСПАДА, няхай складае ахвяру з жывёлы без заганы, самца або саміцы. ");
INSERT INTO bel_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Калі з авечак ён прыносіць ахвяру, няхай прынясе яе перад аблічча ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","і паложыць руку сваю на галаву ахвяры сваёй, і потым заб’е яе перад Намётам Спатканьня, а сыны Аарона пакропяць крывёю яе ахвярнік наўкола. ");
INSERT INTO bel_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","І складзе ён як ахвяру мірную ГОСПАДУ тлушч яе, увесь курдзюк, адрэзаўшы яго па самую хрыбетную косьць, і тлушч, які пакрывае нутро, і ўвесь тлушч над ім, ");
INSERT INTO bel_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","і абедзьве ныркі і тлушч на іх, які на сьцёгнах, і тлушч, які на вантробе; разам з ныркамі няхай аддзеліць яго. ");
INSERT INTO bel_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","І сьвятар спаліць гэта на ахвярніку. Гэта хлеб, ахвяра агнявая для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Калі б хто складаў ахвяру з козаў, няхай прынясе яе перад аблічча ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","і паложыць ён руку сваю на галаву яе і заб’е яе перад Намётам Спатканьня, а сыны Аарона пакропяць крывёй яе ахвярнік наўкола. ");
INSERT INTO bel_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","І складзе ён з яе ахвяру сваю як ахвяру агнявую для ГОСПАДА — тлушч, які пакрывае нутро, разам увесь тлушч, які на нутры, ");
INSERT INTO bel_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","і абедзьве ныркі разам з тлушчам на іх, які на сцёгнах, а таксама тлушч, які на вантробе; з ныркамі няхай аддзеліць яго. ");
INSERT INTO bel_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Пасьля сьвятар спаліць усё гэта на ахвярніку; гэта хлеб, ахвяра агнявая, мілы пах ГОСПАДУ; увесь тлушч належыць ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Гэта пастанова вечная для пакаленьняў вашых у-ва ўсіх паселішчах вашых: ані крыві, ані тлушчу зусім ня ешце”». ");
INSERT INTO bel_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Гавары сынам Ізраіля: “Калі хто праз няўвагу саграшыць адносна прыказаньняў ГОСПАДА, якія забараняюць нешта рабіць, а ён гэта зрабіў бы, ");
INSERT INTO bel_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","дык калі гэтага грэху дапусьціцца памазаны сьвятар, так што яго віна спадае на народ, тады складзе ён у ахвяру ГОСПАДУ як перамольную ахвяру за дапушчаны грэх маладога бычка без заганы. ");
INSERT INTO bel_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","І прывядзе бычка да ўваходу ў Намёт Спатканьня перад аблічча ГОСПАДА, і пало­жыць руку на галаву яго, і заб’е яго перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","І памазаны сьвятар возьме крыві таго бычка, і ўнясе ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","І памочыць сьвятар палец у крыві, і пакропіць крывёй сем разоў перад абліччам ГОСПАДА, перад заслонай Месца Сьвятога. ");
INSERT INTO bel_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","І памажа сьвятар крывёй рагі ахвярніка пахкага каджэньня, які перад абліччам ГОСПАДА ў Намёце Спатканьня, а рэшту крыві бычка вылье ён на падставу ахвярніка цэласпаленьня, які перад уваходам у Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","І выме з ахвяраванага бычка ўвесь тлушч, які пакрывае нутро, і ўсю тлустасьць, якая на нутры, ");
INSERT INTO bel_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","і абедзьве ныркі разам з тлушчам, які над імі, які дастае да сьцёгнаў, а таксама тлушч, які на вантробе; разам з ныркамі няхай аддзеліць яго, ");
INSERT INTO bel_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","такім жа чынам, як аддзяляецца тлушч бычка ахвяры мірнай. І спаліць сьвятар усё гэта на ахвярніку цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","А скуру цяляці, усё мяса ягонае, галаву ягоную, ногі ягоныя, і нутро ягонае, і нячыстасьць ягоную, ");
INSERT INTO bel_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","усяго бычка няхай выня­суць па-за табар; на чыстае месца, дзе высыпаюць попел, і там няхай будзе спалены агнём на дровах. ");
INSERT INTO bel_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Калі ўся грамада Ізраіля саграшыць праз няўвагу, і схавана гэта будзе перад вачыма царквы, што такім чынам правініліся супраць прыказаньняў ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","а потым яны зразумеюць грэх, якім саграшылі, дык няхай царква прывядзе да ўваходу ў Намёт Спатканьня бычка ў ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","І старшыні грамады ўскладуць рукі на галаву бычка перад абліччам ГОСПАДА, і той бычок будзе забіты перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","І памазаны сьвятар унясе ў Намёт Спатканьня частку крыві цяляці, ");
INSERT INTO bel_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","і памочыць палец у крыві, і пакропіць сем разоў перад абліччам ГОСПАДА перад заслонай. ");
INSERT INTO bel_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","І памажа тою крывёю рагі ахвярніку, які перад абліччам ГОСПАДА ў Намёце Спатканьня, а рэшту крыві вылье на падставу ахвярніка цэласпаленьня, які каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","А ўвесь тлушч яго аддзеліць ад яго і спаліць на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","І зробіць з бычком тое, што робіцца з бычком ахвяры за грэх; так павінен зрабіць з ім. Так ачысьціць іх сьвятар, і будзе даравана ім. ");
INSERT INTO bel_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","І вынясе бычка па-за табар, і спаліць яго так, як спаліў папярэдняга бычка. Гэта ахвяра перамольная за грэх царквы. ");
INSERT INTO bel_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Калі саграшыць князь і праз няўвагу дапусьціцца таго, што забараняецца прыказаньнем ГОСПАДА, Бога ягонага, і гэтак правініцца, ");
INSERT INTO bel_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","калі будзе даведзены грэх ягоны, якім саграшыў, няхай прывядзе ў ахвяру ГОСПАДУ казла без заганы. ");
INSERT INTO bel_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","І паложыць ён руку сваю на галаву ягоную, і заб’е яго на месцы, дзе забіваюцца ахвяры цэласпаленьня перад абліччам ГОСПАДА. Гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","І памочыць сьвятар палец у крыві ахвяры за грэх, і памажа ёю рагі ахвярніка цэласпаленьня, а рэшту крыві вылье на падставу ахвярніка цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","А ўвесь тлушч яго спаліць на ахвярніку, падобна як тлушч ахвяры мірнай. Так вось ачысьціць яго сьвятар ад грэху ягонага, і будзе яму даравана. ");
INSERT INTO bel_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Калі хто спаміж народу зямлі праз няўвагу саграшыць і дапусьціцца таго, што забараняецца прыказаньнем ГОСПАДА, і гэтак правініцца, ");
INSERT INTO bel_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","калі будзе выяўлены яму грэх ягоны, якім саграшыў, няхай прывядзе ў ахвяру за грэх свой казу без заганы. ");
INSERT INTO bel_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Пасьля паложыць руку на галаву ахвяры за грэх, і заб’е яе на месцы ахвяры цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Сьвятар возьме пальцам сваім крыві і памажа ёю рагі ахвярніка цэласпаленьня, а рэшту вылье на падставу ахвярніка. ");
INSERT INTO bel_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Потым аддзеліць увесь тлушч так, як быў аддзелены тлушч ахвяры мірнай. І спаліць яго сьвятар на ахвярніку на мілы пах ГОСПАДУ. Так ачысьціць яго сьвятар, і грэх будзе яму адпушчаны. ");
INSERT INTO bel_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","А калі хто захоча скласьці за грэх авечку, няхай прывядзе авечку без заганы, ");
INSERT INTO bel_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","узложыць руку на галаву ейную і заб’е яе як ахвяру за грэх на месцы, дзе забіваюць ахвяры цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","І возьме сьвятар пальцам сваім крыві і памажа рагі ахвярніку цэласпаленьня, а рэшту вылье на падставу ахвярніка. ");
INSERT INTO bel_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","А ўвесь тлушч яе аддзеліць, як аддзяляецца лой авечкі з ахвяры мірнай, і спаліць яго сьвятар на ахвярніку ў ахвяру ГОСПАДУ. Так ачысьціць яго сьвятар ад грэху, якім ён саграшыў, і будзе яму даравана. ");
INSERT INTO bel_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Калі хто саграшыць тым, што чуў праклён і мог засьведчыць пра праступак, які бачыў або ведаў, і не зрабіў гэтага, і такім чынам правініўся, ");
INSERT INTO bel_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","або калі хто дакранецца чаго нячыстага, трупа зьвера нячыстага, або жывёлы, або паўзуна нячыстага, але ня будзе ведаць гэтага, што стаўся нячыстым, і гэтак правініўся, ");
INSERT INTO bel_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","або калі нехта дакранецца нейкай нячыстасьці чалавечай, нейкай рэчы нячыстай, дзеля якой мог занячысьціцца, і спачатку не ўсьведамляў сабе гэтага, а потым даведаецца, што правініўся, ");
INSERT INTO bel_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","або калі хто прысягае, гаворачы легкадумна вуснамі на ліха або на дабро, так як бывае, што чалавек легкадумна прысягае, спачатку не ўсьведамляючы сабе гэтага, а пасьля спасьцерагае, што правініўся праз адну з гэтых рэчаў, ");
INSERT INTO bel_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","дык калі хто правініўся ў адной з гэтых рэчаў, няхай прызнаецца, што саграшыў, ");
INSERT INTO bel_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","і няхай прынясе ён ГОСПАДУ за грэх свой, якім саграшыў, у ахвяру перамольную авечку са статку або казу як ахвяру за грэх, і ачысьціць яго сьвятар ад грэху ягонага. ");
INSERT INTO bel_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Калі хто ня можа ахвяраваць авечку, няхай ахвяруе за грэх свой дзьве туркаўкі або двух маладых галубоў ГОСПАДУ: аднаго ў ахвяру за грэх, а другога на цэласпаленьне. ");
INSERT INTO bel_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Няхай прынясе іх да сьвятара, і ён першага ахвяруе за грэх і надломіць яму галаву пры карку, але яе не аддзеліць. ");
INSERT INTO bel_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Пасьля пакропіць крывёй яго сьцяну ахвярніку, а рэшту крыві вылье на падставу ахвярніка. Гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Другога галуба няхай складзе ён у ахвяру цэласпаленьня, як звычайна бывае; так ачысьціць яго сьвятар ад грэху яго, якім ён правініўся, і ён будзе яму адпушчаны. ");
INSERT INTO bel_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Калі б хто ня мог ахвяраваць дзьвюх туркавак або двух маладых галубоў, няхай прынясе за тое, што саграшыў, дзясятую частку эфы пшанічнай мукі ў ахвяру за грэх; няхай не палівае яе алеем і няхай не кладзе на яе кадзіла, бо гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","І прынясе яе да сьвятара, а той возьме з гэтага поўную жменю мукі як памятную частку і спаліць на ахвярніку ў ахвяру ГОСПАДУ. Гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Так ачысьціць яго сьвятар ад грэху ягонага, якім ён саграшыў супраць аднаго з тых прыказаньняў, і будзе яму адпушчана. Пазасталую частку возьме сьвятар як ахвяру хлебную”». ");
INSERT INTO bel_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Калі хто дапусьціцца злачынства праз памылку, прысвойваючы сабе рэчы, пасьвячоныя ГОСПАДУ, няхай за віну сваю са свайго статку авечак прынясе ГОСПАДУ ягня без заганы па цане двух сыкляў срэбра паводле вагі сьвятыні як ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Няхай тое, што прысвоіў, верне і дадасьць да таго пятую частку вартасьці, і аддасьць гэта сьвятару, а сьвятар ачысьціць яго ахвярай ягняці, і грэх будзе яму адпушчаны. ");
INSERT INTO bel_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Калі хто саграшыць, дапускаючыся нечага супраць прыказаньняў ГОСПАДА праз няведаньне, і правініцца, дапускаючыся злачынства, ");
INSERT INTO bel_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","няхай прынясе да сьвятара ягня без заганы, узятае са статку, па сваёй ацэнцы, у ахвяру за грэх. Тады сьвятар ачысьціць яго ад праступку, якога несьвядома дапусьціўся, і будзе ён яму адпушчаны. ");
INSERT INTO bel_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Гэта ахвяра за праступак, якім ён правініўся перад ГОСПАДАМ». ");
INSERT INTO bel_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Калі хто саграшыць і дапусьціцца праступку перад ГОСПАДАМ тым, што адмовіцца аддаць бліжняму тое, што яму было дадзена на захаваньне, або што яму было дадзена ў заклад, або што было ім скрадзена, або што было адабрана яшчэ якім чынам у бліжняга, ");
INSERT INTO bel_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","або калі знайшоў ён згубленую рэч і запярэчыў гэтаму, або што фальшыва сьведчыў адносна якой рэчы, праз якую чалавек можа саграшыць, ");
INSERT INTO bel_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","вось жа хто так саграшыў і мусіць аднагарадзіцца, павінен аддаць тое, што ўкраў, або тое, што адабраў, або што яму было даручана на захаваньне, або згубленае, што ён знайшоў, ");
INSERT INTO bel_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","або рэч, адносна якой прысягаў фальшыва, і няхай ён верне поўную вартасьць той рэчы, дадаючы пры тым да яе пятую частку яе вартасьці. Павінен ён аддаць гэта ўласьніку ў той самы дзень, калі будзе складаць ахвяру аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","А за праступак ахвяруе ён ГОСПАДУ ягня без заганы са статку, паводле ацаненьня твайго, на ахвяру аднагараджэньня, і прывядзе яго да сьвятара. ");
INSERT INTO bel_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","І ачысьціць сьвятар яго перад ГОСПАДАМ, і дараваны будзе яму праступак, якім саграшыў». ");
INSERT INTO bel_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Загадай Аарону і сынам ягоным, кажучы: “Вось закон адносна ахвяры цэласпаленьня. Ахвяра цэласпаленьня будзе прыносіцца на вогнішчы на ахвярніку ўсю ноч аж да раніцы, і агонь будзе гарэць на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Сьвятар апранецца ў ільняную шату і льняную бялізну, і зьбярэ попел ахвяры цэла­спаленьня, якую спаліў агонь на ахвярніку, і высыпе каля ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Потым здыме з сябе адзеньне сваё, а апране на цела другое адзеньне, і вынясе попел за табар на чыстае месца. ");
INSERT INTO bel_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Агонь жа на ахвярніку будзе гарэць заўсёды і ня бу­дзе гаснуць. На ім сьвятар кожную раніцу будзе паліць дровы, і будзе складаць ахвяру цэласпаленьня, і паліць на ім тлушч ахвяраў мірных. ");
INSERT INTO bel_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Агонь будзе заўсёды гарэць на ахвярніку і ніколі ня згасьне. ");
INSERT INTO bel_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Гэта закон адносна ахвяраў хлебных. Сыны Аарона павінны прыносіць іх перад аблічча ГОСПАДА перад ахвярнікам. ");
INSERT INTO bel_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Сьвятар возьме жменю мукі, палітай алеем, з усім кадзілам, пакладзеным на муку, і спаліць на ахвярніку на мілы пах як напамін ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","А рэшту мукі няхай зьядуць Аарон з сынамі сваімі, праснакі няхай яны ядуць на месцы сьвятым, на панадворку Намёту Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ня будзеце пекчы хлеб квашаны. Гэта частка, якую Я даю ім з Маіх ахвяраў агнявых. Гэта сьвятое сьвятых, як і ахвяра за грэх, і ахвяра аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Толькі мужчыны з сыноў Аарона будуць есьці яе. Гэта закон вечны для пакаленьняў вашых адносна ахвяраў цэласпаленьня ГОСПАДУ. Кожны, хто іх дакранецца, будзе асьвечаны”». ");
INSERT INTO bel_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Гэта вось ахвяра Аарона і сыноў ягоных, якую павінны яны складаць ГОСПАДУ ў дзень іхняга памазаньня. Будуць яны складаць ахвяру штодзённую з дзясятай часткі эфы мукі пшанічнай: палову яе раніцаю і палову — вечарам. ");
INSERT INTO bel_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Яна павінна быць прыгатавана з алеем на патэльні. Прынясеш яе цёплую і ахвяруеш яе, падзеленую на кавалкі, на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Сьвятар, памазаны на месца бацькі свайго, зробіць гэта. Гэта закон вечны. Ахвяра цалкам павінна быць спалена для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Бо кожная ахвяра хлебная сьвятара будзе спалена агнём, і ніхто ня будзе есьці яе». ");
INSERT INTO bel_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Скажы Аарону і сынам ягоным: “Такі вось закон адносна ахвяры за грэх. Ахвяра за грэх павінна быць забітая перад абліччам ГОСПАДА на тым самым месцы, дзе забіваецца ахвяра цэласпаленьня. Гэта справа сьвятая. ");
INSERT INTO bel_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Сьвятар, які будзе складаць ахвяру за грэх, будзе яе есьці на месцы сьвятым, на панадворку Намёту Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Кожны, хто дакранецца мяса яе, будзе асьвечаны. А калі кроўю яе будзе апырскана адзеньне, апырсканае абмый на месцы сьвятым. ");
INSERT INTO bel_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Калі тое мяса будзе варана ў пасудзіне глінянай, яе трэба разьбіць, а калі пасудзіна мядзяная, яна павінна быць добра вышаравана і выпаласкана. ");
INSERT INTO bel_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Кожны мужчына з роду сьвятарскага будзе есьці яе. Гэта сьвятое сьвятых. ");
INSERT INTO bel_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","А ўсякую ахвяру за грэх, кроў якой уносяць у Намёт Спатканьня для ачышчэньня ў Месцы Сьвятым, ніхто няхай ня есьць, яна спальваецца ў агні. ");
INSERT INTO bel_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Вось закон адносна ахвяры аднагараджэньня. Гэта сьвятая рэч. ");
INSERT INTO bel_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","На тым самым месцы, дзе забіваецца ахвяра цэласпаленьня, будуць забіваць ахвяру аднагараджэньня, і кроў яе выльюць вакол ахвярніка, ");
INSERT INTO bel_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","але ўвесь тлушч з яе будзе складзены ў ахвяру: курдзюк, тлушч, які пакрывае нутро, ");
INSERT INTO bel_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","абедзьве ныркі, а тлушч на вантробе разам з ныркамі няхай будзе аддзелены. ");
INSERT INTO bel_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Спаліць гэта ўсё сьвятар на ахвярніку на мілы пах ГОСПАДУ. Гэта ахвяра аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Кожны мужчына з роду сьвятарскага будзе спажываць мяса гэтае на месцы сьвятым. Бо гэта сьвятое сьвятых. ");
INSERT INTO bel_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Для ахвяры за грэх і для ахвяры аднагараджэньня закон адзін. Яна належыць сьвятару, які складаў гэтую ахвяру. ");
INSERT INTO bel_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Сьвятар, які складае ахвяру цэласпаленьня, атрымоўвае скуру жывёлы, якую склаў у ахвяру. ");
INSERT INTO bel_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Таксама кожная ахвяра хлебная, смажаная ў печы, у гаршчку або на патэльні, належыць сьвятару, якім гэтая ахвяра складзена. ");
INSERT INTO bel_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Але кожная ахвяра хлебная з алеем або сухая нале­жыць усім сынам Аарона, як аднаму, так і другому. ");
INSERT INTO bel_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Вось закон адносна ахвяры мірнай, якую складаюць ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Калі хто складае ахвяру гэтую як падзяку, няхай далу­чыць да гэтай ахвяры падзякі таксама прэсныя аладкі з алеем, і прэсныя сухарыкі, запраўленыя алеем, і пшанічную муку з алеем. ");
INSERT INTO bel_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Таксама няхай прыносіць аладкі з цеста квашанага пры ахвяры мірнай ў падзяку. ");
INSERT INTO bel_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","З усіх ахвяраў няхай адна будзе ахвяраваная як асаблівы дар ГОСПАДУ. Яна будзе належаць сьвятару, які вылье кроў ахвяры мірнай. ");
INSERT INTO bel_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Мяса ахвяраў мірных у падзяку мусіць быць зьедзена ў той самы дзень, нельга нічога з іх пакідаць да раніцы. ");
INSERT INTO bel_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Калі хто складае ахвяру як шлюбаваньне або з добрай волі, ахвяру ягоную трэба есьці ў дзень ахвяраваньня, але і на другі дзень можна есьці рэшту яе. ");
INSERT INTO bel_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Калі што застанецца на трэці дзень, тое трэба спаліць. ");
INSERT INTO bel_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Калі хто зьесьць штосьці з ахвяры мірнай на трэці дзень, такая ахвяра ня будзе прынятая; ня будзе яна залічана таму, хто яе склаў, бо гэта зьнявага; а той, хто будзе есьці яе, дапусьціцца грэху. ");
INSERT INTO bel_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Мяса, якое дакраналася чагосьці нячыстага, нельга есьці, але спальваецца яно ў агні; а мяса чыстае можа есьці кожны чысты. ");
INSERT INTO bel_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Калі нейкая душа, будучы ў нячыстасьці, будзе есьці мяса ахвяры мірнай, якая для ГОСПАДА, будзе выключана душа гэтая з народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Калі хто дакранецца нейкай нячыстасьці, нячыстасьці чалавечай, або нячыстасьці жывёлы, або нячыстага паўзуна, і будзе есьці мяса ахвяры мірнай, якая для ГОСПАДА, той будзе выключаны з народу свайго». ");
INSERT INTO bel_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Скажы сынам Ізраіля: “Нельга вам есьці тлушч цялят, авечак і казлоў. ");
INSERT INTO bel_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Тлушчам зьвяроў мёртвых або разьдзёртых можна карыстацца ў кожнай патрэбе, але ня ешце яго. ");
INSERT INTO bel_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Калі хто будзе есьці тлушч жывёлаў, якіх прынесьлі на ахвяру агнявую для ГОСПАДА, той будзе выключаны з народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Дзе толькі будзеце жыць, нельга вам есьці ніякай крыві, ані крыві птушак, ані крыві быдла. ");
INSERT INTO bel_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Кожная душа, якая будзе есьці кроў, будзе выключана душа гэтая з народу свайго”». ");
INSERT INTO bel_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Скажы сынам Ізраіля: “Хто складае ахвяру мірную для ГОСПАДА, няхай прынясе свой дар ГОСПАДУ з ахвяры мірнай. ");
INSERT INTO bel_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Сваімі рукамі няхай прынясе ён ахвяру агнявую для ГОСПАДА: тлушч з грудзіны і грудзіну, каб трэсьці імі перад ГОСПАДАМ. ");
INSERT INTO bel_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Тлушч спаліць сьвятар на ахвярніку, а грудзіна належыць Аарону і сынам ягоным. ");
INSERT INTO bel_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Таксама правую лапатку аддасьцё сьвятару як частку сьвятарскую з ахвяраў мірных. ");
INSERT INTO bel_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Які з сыноў Аарона складае ў ахвяру кроў і тлушч ахвяры мірнай, той як частку сваю атрымае правую лапатку, ");
INSERT INTO bel_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","бо грудзіну патрасаную і лапатку ўздыманую Я бяру ад сыноў Ізраіля з іхніх ахвяраў мірных і даю іх Аарону сьвятару і сынам ягоным як вечны закон ад усяго народу Ізраіля”». ");
INSERT INTO bel_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Гэта ёсьць частка з ахвяраў, паленых для ГОСПАДА, якая належыць Аарону і сынам ягоным ад дня пасьвячэньня іх на сьвятароў ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","У дзень, калі іх ГОСПАД памазаў, загадаў Ізраілю даваць ім гэта. Гэта пастанова вечная ў пакаленьні іхнія. ");
INSERT INTO bel_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Гэта вось закон адносна ахвяры цэласпаленьня, ахвяры хлебнай, ахвяры за грэх, ахвяры аднагараджэньня, ахвяры пасьвячэньня і ахвяры мірнай. ");
INSERT INTO bel_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Гэта загадаў ГОСПАД Майсею на гары Сынай у дзень, калі загадаў сынам Ізраіля складаць ахвяры ГОСПАДУ ў пустыні Сынай. ");
INSERT INTO bel_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Вазьмі Аарона і сыноў ягоных, адзеньне, алей памазаньня, бычка на ахвяру за грэх, два бараны і кош прэсных хлябоў. ");
INSERT INTO bel_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Пасьля зьбяры ўсю грамаду каля ўваходу ў Намёт Спатканьня». ");
INSERT INTO bel_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Майсей зрабіў так, як яму ГОСПАД загадаў, і грамада сабралася каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","І сказаў Майсей грамадзе: «Вось слова, якое загадаў ГОСПАД выканаць!» ");
INSERT INTO bel_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","І прывёў Майсей Аарона і сыноў ягоных, і абмыў іх вадою. ");
INSERT INTO bel_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","І ўсклаў на яго шату льняную, і падперазаў яго паясом, і апрануў на яго верхнюю шату, і наверх усклаў эфод, і апаясаў яго пасам эфоду, і прымацаваў на ім эфод. ");
INSERT INTO bel_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","І ўсклаў на яго нагруднік, на якім разьмясьціў урым і тумім, ");
INSERT INTO bel_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","і ўсклаў яму на галаву мітру і на ёй залатую дыядэму, сьвяты вянок, як загадаў Майсею ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Потым узяў Майсей алей памазаньня, і памазаў Сялібу разам з усім, што ў ёй было, і асьвяціў гэта. ");
INSERT INTO bel_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","І пакрапіў ён ахвярнік сем разоў, і памазаў ахвярнік разам з яго прыналежнасьцямі, і мыцельнік, і яго падставу, каб асьвяціць іх. ");
INSERT INTO bel_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","І паліў ім галаву Аарона, і памазаў яго, каб асьвяціць яго. ");
INSERT INTO bel_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","І наблізіў сыноў Аарона, і апрануў іх у шаты, і падперазаў іх паясамі, і ўсклаў на іх галовы турбаны, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","І прывёў Майсей бычка ў ахвяру за грэх. І Аарон і сыны ягоныя ўсклалі рукі свае на галаву ахвяры за грэх. ");
INSERT INTO bel_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","І Майсей забіў яго, і, узяўшы крыві яго, пальцам памазаў рагі ахвярніка кругом, і ачысьціў ахвярнік. А рэшту крыві выліў на падставу ахвярніка, і асьвяціў яго, ачышчаючы яго. ");
INSERT INTO bel_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","І ўзяў ён увесь тлушч, які на нутры, і тлушч на вантробе, і абедзьве ныркі разам з тлушчам, і спаліў іх на ахвярніку, ");
INSERT INTO bel_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","а бычка і скуру ягоную, і мяса ягонае, і нячыстасьці ягоныя спаліў у агні па-за табарам, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","І прывёў Майсей барана ў ахвяру цэласпаленьня. І Аарон і сыны ягоныя ўсклалі на галаву ягоную рукі свае. ");
INSERT INTO bel_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","І Майсей забіў яго, і пакрапіў кругом ахвярніка крывёю, ");
INSERT INTO bel_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","і пасек барана на часткі, і спаліў галаву, і кавалкі, і тлушч, ");
INSERT INTO bel_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","а нутро і ногі памыў вадой. І спаліў Майсей усяго барана ў агні на ахвярніку. Гэта цэласпаленьне, мілы пах, ахвяра агнявая для ГОСПАДА, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","І прывялі другога барана, барана асьвячэньня. І Аарон і сыны ягоныя ўсклалі рукі свае на галаву ягоную. ");
INSERT INTO bel_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","І Майсей забіў яго, і ўзяў крыві ягонай, і памазаў ёю верх правага вуха Аарона, вялікі палец яго правай рукі і вялікі палец яго правай нагі. ");
INSERT INTO bel_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","І прывёў Майсей сыноў Аарона, і памазаў крывёй верх правага вуха іхняга, і вялікі палец правай рукі іхняй, і вялікі палец правай нагі іхняй, і пакрапіў Майсей крывёю ахвярнік з усіх бакоў. ");
INSERT INTO bel_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Потым узяў тлушч, хвост і ўвесь тлушч, які на нутры, разам з тлушчам на вантробе, абедзьве ныркі і іхні тлушч, і правую лапатку, ");
INSERT INTO bel_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","і з каша праснакоў, які стаяў перад абліччам ГОСПАДА, узяў адзін праснак, адну аладку на алеі і адзін сухарык, і палажыў на тлушч і на правую лапатку. ");
INSERT INTO bel_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","І палажыў усё гэта на рукі Аарона і сыноў яго, і патрос гэтым перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","І ўзяў усё гэта Майсей з рук іхніх, і спаліў на ахвярніку разам з цэласпаленьнем. Гэта ахвяра асьвячэньня на мілы пах, ахвяра агнявая для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","І ўзяў Майсей грудзіну, і патрос яе перад абліччам ГОСПАДА. Гэта была частка Майсею з барана ахвяры асьвячэньня, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","І ўзяў Майсей крыху алею памазаньня і крыху крыві з ахвярніка, і пакрапіў Аарона і шаты ягоныя, а таксама сыноў ягоных і шаты іхнія. І асьвяціў Аарона і шаты ягоныя, а таксама сыноў ягоных і шаты іхнія. ");
INSERT INTO bel_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","І сказаў Майсей Аарону і сынам ягоным: «Зварыце мяса каля ўваходу ў Намёт Спатканьня і там ешце яго і хлеб, які ў кашы ахвяры асьвячэньня, як мне было загадана: “Аарон і сыны ягоныя будуць есьці яго”. ");
INSERT INTO bel_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","А што застанецца з мяса і хлябоў, спаліце агнём. ");
INSERT INTO bel_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ад уваходу ў Намёт Спатканьня не адыходзьцеся сем дзён, аж да дня заканчэньня асьвячэньня вашага, бо сем дзён будзе працягвацца асьвячэньне. ");
INSERT INTO bel_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","І што я зрабіў сёньня, так загадаў ГОСПАД рабіць, каб ачысьціць вас. ");
INSERT INTO bel_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Каля ўваходу ў Намёт Спатканьня заставайцеся днём і ноччу сем дзён на варце ГОСПАДА, каб не паўміралі, бо гэтак мне было загадана». ");
INSERT INTO bel_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","І зрабілі Аарон і сыны ягоныя ўсё, што загадаў ім ГОСПАД праз Майсея. ");
INSERT INTO bel_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","У восьмы дзень паклікаў Майсей Аарона, сыноў ягоных і старшыняў Ізраіля і сказаў Аарону: ");
INSERT INTO bel_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","«Вазьмі са статку бычка ў ахвяру за грэх і барана ў ахвяру цэласпаленьня, абодвух без заганы, і прынясі перад аблічча ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","А сынам Ізраіля скажы: “Вазьміце казла ў ахвяру за грэх, і цяля, і барана аднагадовага без заганы ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","і вала і барана ў ахвяру мірную, каб ахвяраваць іх перад абліччам ГОСПАДА, і ахвяру хлебную, запраўленую алеем, бо сёньня ГОСПАД зьявіцца вам”». ");
INSERT INTO bel_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","І прынесьлі ўсё тое, што загадаў ім Майсей, да ўваходу ў Намёт Спатканьня, і прыйшла ўся грамада, і стала перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","І сказаў Майсей: «Вось слова, якое загадаў ГОСПАД. Зрабіце гэта, і зьявіцца вам слава ГОСПАДА!» ");
INSERT INTO bel_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","І сказаў Майсей Аарону: «Наблізься да ахвярніка, і складзі ахвяру за грэх і ахвяру цэласпаленьня, і ачысьці сябе і народ. І складзі ахвяру за народ, і ачысьці яго, як загадаў ГОСПАД”. ");
INSERT INTO bel_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","І наблізіўся Аарон да ахвярніка, і забіў цяля за грэх свой. ");
INSERT INTO bel_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","І сыны ягоныя далі яму кроў цяляці, і ён, памачыўшы палец у крыві, памазаў ёю рагі ахвярніку, а рэшту выліў на падставу ахвярніка. ");
INSERT INTO bel_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Тлушч, ныркі і тлушч на вантробе з ахвяры за грэх спаліў ён на ахвярніку, як загадаў ГОСПАД Майсею, ");
INSERT INTO bel_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","а мяса і скуру ягоную спаліў на агні па-за табарам. ");
INSERT INTO bel_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","І забіў ахвяру цэласпаленьня; і сыны ягоныя далі яму кроў, і ён выліў яе кругом ахвярніка. ");
INSERT INTO bel_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Далі яму таксама ахвяру цэласпаленьня, падзеленую на часткі, і галаву яе, і ён спаліў гэта на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","І абмыў ён нутро і ногі, і спаліў як цэласпаленьне на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","І склаў ён ахвяру за народ, і ўзяў казла, які быў прызначаны ў ахвяру за грэх народу, і забіў яго, і ахвяраваў за грэх, як і першага. ");
INSERT INTO bel_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","І ўзяў ахвяру цэласпаленьня, і ахвяраваў яе паводле пастановы. ");
INSERT INTO bel_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","І прынёс ён ахвяру хлебную, і напоўніў ёю руку сваю, і спаліў на ахвярніку, апрача ранішняй ахвяры цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","І забіў вала і барана, ахвяры мірныя ад народу; і сыны ягоныя далі яму кроў, якую ён выліў кругом ахвярніка. ");
INSERT INTO bel_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","А тлушч вала і хвост барана, і ныркі з лоем, і тлушч на вантробе ");
INSERT INTO bel_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","палажылі на грудзіну; і тлушч быў спалены на ахвярніку; ");
INSERT INTO bel_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","а грудзіну і правае плячо Аарон прынёс, патрасаючы перад абліччам ГОСПАДА, як загадаў яму Майсей. ");
INSERT INTO bel_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","І падняў Аарон рукі ў бок народу, і дабраславіў яго, і, склаўшы ахвяры за грэх, ахвяры цэласпаленьня і ахвяры мірныя, зыйшоў уніз. ");
INSERT INTO bel_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","І ўвайшлі Майсей і Аарон у Намёт Спатканьня і, выйшаўшы адтуль, дабраславілі народ. І зьявілася слава ГОСПАДА ўсяму народу. ");
INSERT INTO bel_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","І выйшаў агонь ад аблічча ГОСПАДА, і спаліў ахвяру цэласпаленьня і тлушч, якія былі на ахвярніку. І ўбачыў гэта ўвесь народ, і ўзрадаваліся, і ўпалі на абліччы свае. ");
INSERT INTO bel_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","І ўзялі сыны Аарона, Надаў і Абігу, кожны кадзільніцу сваю, і набралі ў іх агонь, і паклалі на яго кадзіла і ахвяравалі перад абліччам ГОСПАДА іншы агонь, а ня той, што быў ім загаданы. ");
INSERT INTO bel_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","І выйшаў агонь ад ГОСПАДА, і спаліў іх, і яны памерлі перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","І сказаў Майсей Аарону: «Вось што сказаў ГОСПАД: “Я зьяўлю сьвятасьць Маю тым, якія набліжаюцца да Мяне, і зьяўлю славу перад усім народам”». І замаўчаў Аарон. ");
INSERT INTO bel_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","І паклікаў Майсей Мішаэля і Эльцафана, сыноў Узіэля, дзядзькі Аарона, і сказаў ім: «Ідзіце і забярыце братоў вашых, і вынясіце іх з Месца Сьвятога па-за табар». ");
INSERT INTO bel_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","І яны пайшлі, і забралі іх, што ляжалі ў шатах сваіх, і вынесьлі па-за табар, як ім было загадана Майсеем. ");
INSERT INTO bel_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","І сказаў Майсей Аарону і Элеазару і Ітамару, сынам ягоным: «Не галіце валасоў вашых і не разьдзірайце адзеньня, каб часам не былі вы пакараныя сьмер­цю, і каб не ўзгарэўся гнеў Госпада на ўсю грамаду. Але браты вашыя і ўвесь дом Ізраіля можа плакаць дзеля тых, якіх спаліў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Вы ж не адыходзьце ад уваходу ў Намёт Спатканьня, бо загінеце, бо алей памазаньня ГОСПАДА на вас». І яны зрабілі так, як Майсей загадаў ім. ");
INSERT INTO bel_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","І прамовіў ГОСПАД да Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Ня піце ані віна, ані сікеры ты і сыны твае, калі будзеце ўваходзіць у Намёт Спатканьня, і не памрацё. Гэта пастанова вечная ў-ва ўсе пакаленьні вашыя, ");
INSERT INTO bel_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","каб вы маглі адрозьніваць паміж сьвятым і несьвятым, чыстым і нячыстым, ");
INSERT INTO bel_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11",". і вучылі сыноў Ізраіля ўсім пастановам Маім, якія аб’явіў ГОСПАД ім праз Майсея». ");
INSERT INTO bel_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","І прамовіў Майсей да Аарона і пазасталых сыноў ягоных, Элеазара і Ітамара: «Вазьміце ахвяру хлебную, якая засталася ад ахвяраў ГОСПАДАВЫХ, і ешце яе прэсную каля ахвярніка, бо гэта сьвятое сьвятых. ");
INSERT INTO bel_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ешце яе ў месцы сьвятым, бо гэта частка твая і сыноў тваіх з ахвяраў агнявых для ГОСПАДА, бо так мне загадана. ");
INSERT INTO bel_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Грудзіну патрасаную і лапатку падыманую будзеце есьці на месцы чыстым ты і сыны твае, і дочкі твае з табою, бо гэта частка твая і сыноў тваіх з ахвяраў мірных сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Лапатка падыманая і грудзіна патрасаная разам з часткамі тлустымі ахвяры цэласпаленьня, якія будуць патрэсваць перад абліччам ГОСПАДА, будуць належаць табе і сынам тваім з табою як пастанова вечная, як загадаў ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","І Майсей, шукаючы, шукаў казла ахвяры за грэх, і вось, ён спалены. І разгневаўся ён на Элеазара і Ітамара, пазасталых сыноў Аарона, і сказаў ім: ");
INSERT INTO bel_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Чаму ня зьелі вы ахвяры за грэх у месцы сьвятым? Бо гэта сьвятое сьвятых. Яна дадзена вам, каб зьняць правіны з грамады, каб ачысьціць яе перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Вось, кроў яе ня ўнесена ў Месца Сьвятое, а вы мусілі зьесьці яе ў Месцы Сьвятым, як загадана мне». ");
INSERT INTO bel_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","І прамовіў Аарон да Майсея: «Вось, складзеная сёньня імі ахвяра за грэх і цэласпаленьне перад абліччам ГОСПАДА, і такое здарылася. Калі сёньня зьем ахвяру за грэх, ці гэта будзе добра ў вачах ГОСПАДА?” ");
INSERT INTO bel_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","І Майсей выслухаў гэта, і было гэта добра ў вачах ягоных. ");
INSERT INTO bel_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы ім: ");
INSERT INTO bel_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Прамоўце да сыноў Ізраіля, кажучы: “Вось жывёлы з усіх жывёлаў зямных, якіх можаце есьці. ");
INSERT INTO bel_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Кожную жывёлу, у якой раздвоеныя капыты і глыбокі разрэз на капыце, і якая жуе жвайку, можаце есьці. ");
INSERT INTO bel_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Але з тых, якія маюць раздвоеныя капыты і якія жуюць жвайку, ня ешце вярблюда, бо ён жуе жвайку, але ня мае раздвоеных капытоў, нячысты ён для вас; ");
INSERT INTO bel_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","дамана, бо ён жуе жвайку, але ня мае раздвоеных капытоў, нячысты ён для вас; ");
INSERT INTO bel_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","зайца, бо ён жуе жвайку, але ня мае раздвоеных капытоў, нячысты ён для вас; ");
INSERT INTO bel_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","і сьвіньню, бо яна мае раздвоеныя капыты і на капытах разрэз глыбокі, але не жуе жвайку, нячыстая яна для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Мяса іхняе ня ешце і падліны іхняй не дакранайцеся, бо яны нячыстыя для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Гэта будзеце есьці з усяго, што ёсьць у вадзе: усё ў ва­дзе, што мае плаўнік і луску, ці ў моры, ці ў рацэ, можаце есьці. ");
INSERT INTO bel_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Але ўсё, што ня маеплаўніка і лускі, ці ў моры, ці ў рацэ, з усяго, што плавае ў вадзе, і з усякай душы жывой, якая ў вадзе, агідныя яны для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Яны будуць агідай для вас. Ня ешце мяса іхняга і высьцерагайцеся падліны іхняй. ");
INSERT INTO bel_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Усе жывёлы ў вадзе, якія ня маюць плаўніка і лускі, будуць для вас агіднымі. ");
INSERT INTO bel_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","З птушак будзеце вы бры­дзіцца, бо яны — агіда для вас, і ня будзеце есьці арла, грыфа і марскога арла, ");
INSERT INTO bel_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","каршука і сокала з усімі гатункамі яго, ");
INSERT INTO bel_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","крумкачоў усякіх гатункаў яго, ");
INSERT INTO bel_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","страуса, савы, чайкі і ястрабаў усякіх гатункаў, ");
INSERT INTO bel_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","пугача, рыбалова, ібіса, ");
INSERT INTO bel_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","лебедзя, пэлікана і сыча, ");
INSERT INTO bel_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","чаплі, буслоў усякіх гатункаў, удода і кажана. ");
INSERT INTO bel_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Усе жужлы крылатыя, якія на чатырох нагах, агіднымі будуць для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Але спаміж жужлаў крылатых, якія ходзяць на чатырох нагах, будзеце есьці толькі тых, у якіх галені вышэй за ногі, каб маглі скакаць па зямлі. ");
INSERT INTO bel_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Спаміж іх ешце саранчу ўсіх гатункаў, салам усіх гатункаў, харголь усіх гатункаў і хагаб усіх гатункаў. ");
INSERT INTO bel_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Усе іншыя гатункі жужлаў крылатых, якія на чатырох нагах, будуць для вас агідныя. ");
INSERT INTO bel_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ад іх вы будзеце нячыстыя; хто дакранецца падліны іхняй, будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","І кожны, хто будзе несьці падліну іхнюю, няхай вымые адзеньне сваё і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Кожная жывёла, якая мае капыты раздвоеныя, але ня мае разрэзу і не жуе жвайку, будзе нячыстая для вас. Кожны, хто дакранецца яе, станецца нячыстым. ");
INSERT INTO bel_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","З усіх жывёлаў, якія ходзяць на чтырох нагах, тыя, што ходзяць на лапах, нячыстыя для вас. Кожны, хто дакранецца падліны іхняй, нячысты будзе да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","І той, хто нёс бы падліну іхнюю, няхай вымые адзеньне сваё і будзе нячысты да вечара, бо яны нячыстыя для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Спаміж малых жывёлін, якія рухаюцца па зямлі, нячыстыя крот, мыш і яшчаркі ўсіх гатункаў, ");
INSERT INTO bel_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","анака, хамэлеон, летаа, хамэт і тыншамэт. ");
INSERT INTO bel_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Усе яны нячыстыя спаміж малых жывёлаў. Кожны, хто дакранецца падліны іхняй, будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","І ўсё, на што ўпадзе нейкая з іх нежывая, будзе нячыстым, усякі посуд драўляны, адзеньне, скура, мяшок, усякая рэч, якою карыстаюцца. Трэба намачыць іх у вадзе, і будуць яны нячыстыя аж да вечара, а потым будуць чыстыя. ");
INSERT INTO bel_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","А посуд гліняны, у які штосьці з гэтага ўпала, будзе ўнутры нячысты, і яго трэба разьбіць. ");
INSERT INTO bel_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Кожная страва, якую ясьцё, калі на яе выцячэ вада з таго посуду, будзе нячыстай, і ўсякае пітво, якое п’юць з такога посуду, будзе нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Усё, на што ўпадзе падліна іхняя, будзе нячыстым. Печ ці грубка маюць быць зьнішчаны, бо яны нячыстыя, і будуць нячыстыя для вас. ");
INSERT INTO bel_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Толькі крыніцы і студні, дзе ёсьць вада, будуць чыстымі. Але той, хто дакранецца падліны іхняй, будзе нячысты. ");
INSERT INTO bel_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Калі нешта ад падліны іхняй упадзе на насеньне, якое маюць сеяць, яно будзе чыстае. ");
INSERT INTO bel_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Але калі зерне было мокрае, і ўпала на яго падліна іхняя, яно будзе для вас нячыстым. ");
INSERT INTO bel_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Калі здохне жывёла, якую вам можна есьці, той, хто дакрануўся падліны яе, будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Калі хто зьесьць падліну тую, няхай памые адзеньне сваё і будзе нячысты да вечара. І той, хто будзе несьці падліну тую, няхай вымые адзеньне сваё і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Усякая малая жывёліна, якая поўзае па зямлі — гэта брыдота, нельга яе есьці. ");
INSERT INTO bel_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Усё, што поўзае па зямлі на жываце, і ўсё, што ходзіць на чатырох нагах, або мае шмат ног, або цягнецца па зямлі, ня ешце гэтага, бо гэта брыдота. ");
INSERT INTO bel_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Не паганьце душаў вашых усялякімі паўзунамі і не дакранайцеся да іх, каб ня сталіся нячыстымі. ");
INSERT INTO bel_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Бо Я — ГОСПАД, Бог ваш. Асьвячайцеся і будзьце сьвятымі, бо Я — Сьвяты! Не паганьце душаў вашых нейкім паўзуном, які поўзае па зямлі, ");
INSERT INTO bel_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","бо Я — ГОСПАД, Які вывеў вас з зямлі Эгіпецкай, каб быць для вас Богам. Будзьце сьвятымі, бо Я — Сьвяты! ");
INSERT INTO bel_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Гэта вось закон адносна быдла і птушак і ўсякай душы жывой, якая жыве ў вадзе і поўзае па зямлі, ");
INSERT INTO bel_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","каб вы адрозьнівалі, што чыстае, а што нячыстае, і ведалі, што маеце есьці, а што нельга есьці». ");
INSERT INTO bel_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Прамоў да сыноў Ізраіля і скажы: “Калі жанчына зачне і народзіць сына, сем дзён застанецца нячыстай; як у дні месячніцы яна будзе нячыстай. ");
INSERT INTO bel_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","А ў восьмы дзень будзе абрэзана скуравінка хлопца, ");
INSERT INTO bel_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","а яна трыццаць тры дні будзе ачышчацца ад крыві сваёй, ня будзе дакранацца нічога сьвятога, і ня будзе ўваходзіць у сьвятыню, пакуль ня скончацца дні ачышчэньня ейнага. ");
INSERT INTO bel_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Калі народзіць дачку, нячыстай будзе яна два тыдні як у дні месячніцы, і шэсьць­дзясят дзён будзе ачышчацца ад крыві сваёй. ");
INSERT INTO bel_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Калі скончацца дні ачышчэньня ейнага дзеля нараджэньня сына або дачкі, прынясе яна аднагадовага барана ў ахвяру цэласпаленьня і маладога галубка або туркаўку ў ахвяру за грэх да сьвятара да ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","І ён складзе іх у ахвяру перад абліччам ГОСПАДА, і ачысьціць яе, і так будзе яна ачышчаная ад цячэньня крыві сваёй. Гэта закон адносна той, якая нарадзіла сына або дачку. ");
INSERT INTO bel_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Калі б яна не змагла ахвяраваць барана, няхай ахвяруе двух туркавак або два маладыя галубкі, аднаго ў ахвяру цэласпаленьня, а другога ў ахвяру за грэх, і ачысьціць яе сьвятар, і яна будзе ачышчаная». ");
INSERT INTO bel_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Калі ў чалавека на скуры цела ягонага зьявіцца пухліна, або лішай, або белая пляма, і будзе на скуры цела ягонага хвароба праказы, няхай прывядуць яго да Аарона сьвятара, або да аднаго з сыноў ягоных, сьвятароў. ");
INSERT INTO bel_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","І сьвятар агледзіць пляму на скуры, і калі валасы на пляме зьменяцца на белыя і пляма паглыбіцца на скуры цела, гэта хвароба праказы. Сьвятар агледзіць яго і прызнае яго нячыстым. ");
INSERT INTO bel_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Але калі пляма на скуры цела яго белая, але ня ўглыбіўшыся ў цела, і валасы не пабялелыя, сьвятар адасобніць яго на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","У сёмы дзень сьвятар агледзіць яго. І вось, пляма не павялічылася і не пашырылася на скуры, і адасобніць яго сьвятар яшчэ на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Пасьля сямі дзён сьвятар зноў агледзіць яго. І вось, пляма пацямнела і не пашырылася на скуры, і сьвятар прызнае яго чыстым; гэта лішай, дык няхай ён вымые адзеньне сваё і будзе чысты ");
INSERT INTO bel_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","А калі лішай пашырыўся па скуры пасьля таго, як ён стаў перад сьвятаром для праверкі, ён другі раз павінен стаць перад сьвятаром. ");
INSERT INTO bel_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","І сьвятар агледзіць яго, і вось, лішай пашырыўся на скуры, і сьвятар прызнае яго нячыстым; гэта праказа. ");
INSERT INTO bel_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Калі на чалавеку выявіцца праказа, няхай прывядуць яго да сьвятара. ");
INSERT INTO bel_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","І сьвятар агледзіць яго, і вось, на скуры ягонай белая пухліна, і валасы на ёй белыя, і на пухліне жывое мяса. ");
INSERT INTO bel_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Гэта застарэлая праказа на скуры цела яго, і сьвятар прызнае яго нячыстым, і адасоб­ніць яго, бо ён нячысты. ");
INSERT INTO bel_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Калі ж праказа расьцьвіце на скуры і пакрые ўсю скуру хворага ад галавы да ног, на колькі могуць бачыць вочы сьвятара, ");
INSERT INTO bel_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","і ўбачыць сьвятар, што праказа пакрыла ўсё цела ягонае, ён прызнае хворага чыстым, таму што ўсё цела перамянілася ў белае; ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","А ў дзень, калі выявіцца на ім жывое мяса, ён нячысты. ");
INSERT INTO bel_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","І ўбачыць сьвятар жывое мяса, і прызнае яго нячыстым; бо жывое мяса нячыстае; гэта праказа. ");
INSERT INTO bel_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","А калі жывое мяса станецца зноў белым, няхай ён прыйдзе да сьвятара. ");
INSERT INTO bel_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","І сьвятар агледзіць яго, і вось, плямы сталіся белымі, і сьвятар прызнае яго чыстым; ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Калі ў каго на скуры цела была скула і зажыла, ");
INSERT INTO bel_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","але на месцы скулы будзе белая пухліна, або белая пляма, або чырвоная, ён павінен паказацца сьвятару. ");
INSERT INTO bel_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","І сьвятар агледзіць яго і вось, тая пляма паглыблена адносна скуры і валасы на ёй пабялеўшыя, і сьвятар прызнае яго нячыстым. Гэта хвароба праказы, якая зацьвіла на скуле. ");
INSERT INTO bel_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","А калі сьвятар убачыць, што вось, няма белых валасоў, і што пляма не паглыблена адносна скуры, і што яна пацямнеўшы, сьвятар адасобніць яго на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","І калі яна, пашыраючыся, пашырыцца на скуры, сьвятар прызнае яго нячыстым. Бо гэта хвароба праказы. ");
INSERT INTO bel_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","А калі пляма застанецца бяз зьмены і не пашырыцца, гэта шнар на скуле, і сьвятар прызнае яго чыстым. ");
INSERT INTO bel_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Калі хто мае на целе сваім апёк скуры, і калі на той скуры зьявіцца чырвоная або белая пляма, ");
INSERT INTO bel_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","сьвятар агледзіць яго. І вось, валасы на пляме пабялеўшы, і пляма паглыблена адносна скуры, гэта праказа, якая зацьвіла на апёку. І сьвятар прызнае яго нячыстым; гэта хвароба праказы. ");
INSERT INTO bel_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","А калі сьвятар агледзіць яго, і вось, на пляме няма белых валасоў і яна не паглыблена адносна скуры, і яна пацямнеўшы, тады сьвятар адасобніць яго на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","У сёмы дзень сьвятар зноў агледзіць яго. Калі пляма, пашыраючыся, пашырылася на скуры, сьвятар прызнае яго нячыстым. Гэта хвароба праказы. ");
INSERT INTO bel_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","А калі пляма не пашырыцца на скуры, але пацямнее, гэта шнар ад апёку. Сьвятар прызнае яго чыстым, бо гэта шнар ад апёку. ");
INSERT INTO bel_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Калі ў мужчыны або жанчыны на галаве або барадзе зьявіцца пляма, ");
INSERT INTO bel_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","няхай сьвятар агледзіць пляму, і калі яна паглыблена адносна скуры і валасы на ёй сталіся жоўтыя і ценькія, сьвятар прызнае яго нячыстым. Гэта паршывасьць, праказа галавы або барады. ");
INSERT INTO bel_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","А калі сьвятар агледзіць пляму паршывасьці, і вось, яна не паглыблена адносна скуры, і няма чорных валасоў на ёй, сьвятар адасобніць хворага на паршывасьць на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","У сёмы дзень сьвятар агледзіць пляму, і вось, паршывасьць не пашырылася і на ёй няма жоўтых валасоў, і паршывасьць не паглыбілася адносна скуры. ");
INSERT INTO bel_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Тады чалавек паголіцца, але не абголіць месца паршывасьці, і сьвятар зноў адасобніць яго на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","У сёмы дзень сьвятар агледзіць паршывасьць, і вось, паршывасьць не пашырылася і не паглыбілася адносна скуры, і сьвятар прызнае яго чыстым, і ён памые адзеньне сваё, і бу­дзе чыстым. ");
INSERT INTO bel_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","А калі пасьля таго, як прызнаюць яго чыстым, пашыраючыся, пашырыцца паршы­васьць на скуры, ");
INSERT INTO bel_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","сьвятар агледзіць яго. І вось, паршывасьць пашырылася на скуры, і ўжо ня будзе сьвятар шукаць жоўтых валасоў, бо чалавек той нячысты. ");
INSERT INTO bel_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","А калі ў вачах сьвятара застаецца паршывасьць у сваім выглядзе, і вырас на ёй чорны волас, паршывасьць вылекаваная, ён чысты, і сьвятар прызнае яго чыстым. ");
INSERT INTO bel_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Калі ў мужчыны або жанчыны зьявіцца на скуры цела іхняга шмат плямаў белых, ");
INSERT INTO bel_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","няхай агледзіць іх сьвятар. І вось, на скуры цела іхняга шмат плямаў белых. Гэта крапіўка, якая закрасавала на скуры; яны чыстыя. ");
INSERT INTO bel_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Калі з чыёй галавы выпадуць валасы, ён лысы, і ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","і калі ў каго лоб палысее, ён лысы, і ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Але калі на лысіне або палыселым чале зьявіцца пляма белая або чырвоная, гэта праказа, якая закрасавала на лысіне або палыселым чале. ");
INSERT INTO bel_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","І сьвятар агледзіць яго, і вось, у яго пухліна белая або чырвоная на лысіне або палыселым чале, падобная да праказы на скуры цела. ");
INSERT INTO bel_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Гэта чалавек пракажоны, ён нячысты. Сьвятар прызнае яго нячыстым. У яго на галаве хвароба ягоная. ");
INSERT INTO bel_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Пракажоны, крануты гэтай хваробай, будзе мець раза­дранае адзеньне, нячэсаныя валасы на галаве і бараду заслоненую, і будзе крычаць: “Нячысты, нячысты!” ");
INSERT INTO bel_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Усе дні хваробы сваёй ён будзе нячыстым. Будзе жыць асобна, па-за табарам жытло ягонае. ");
INSERT INTO bel_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Калі на нейкім адзеньні зьявіцца хвароба праказы, ці на адзеньні ваўняным, ці на ільняным, ");
INSERT INTO bel_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ці на аснове, ці на ўтоку льняным, ці ваўняным, ці на скуры, ці на нейкім вырабе скураным, ");
INSERT INTO bel_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","і калі зьявіцца пляма зелянявая або чырвоная на адзе­ньні або на скуры, на ўтоку або аснове, або на нейкім вырабе скураным, гэта хвароба праказы. Трэба паказаць гэта сьвятару. ");
INSERT INTO bel_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Сьвятар агледзіць гэта і замкне заражанае хваробай на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","У сёмы дзень агледзіць зноў хваробу, і калі яна пашырылася на адзеньні, або на аснове, або на ўтоку, або на скуры, або на ўсім, што зроблена са скуры, гэта праказа ліхая; гэта ўсё нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","І ён спаліць гэтае адзеньне, ці аснову, ці ўток ільняны, ці ваўняны, ці выраб скураны, на якіх будзе гэтая хвароба, бо гэта праказа ліхая, яна павінна быць спалена агнём. ");
INSERT INTO bel_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","А калі сьвятар убачыць, што хвароба не пашырылася на адзеньні, або на аснове, або на ўтоку, або на скураным вырабе, ");
INSERT INTO bel_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","тады сьвятар загадае вымыць рэч, на якой была хвароба, і замкне яе яшчэ на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","І агледзіць яе сьвятар пасьля таго, як было вымытае заражанае хваробай, і вось, пляма не зьмянілася ў вачах ягоных, і пляма не пашырылася. Гэта нячыстае, спаліш яго ў агні, ці рэч заражаная з аднаго, ці з другога боку. ");
INSERT INTO bel_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","А калі сьвятар агледзіць яе, і вось, пасьля таго, як рэч была вымытая, пляма сталася сьвятлейшай, ён аддзярэ гэтае месца ад адзеньня, або скуры, або асновы, або ўтоку. ");
INSERT INTO bel_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","А калі хвароба зноў зьявіцца на адзеньні, або на аснове, або на ўтоку, або на вырабе скураным, і закрасуе, спаліш у агні тое, на чым ёсьць хвароба. ");
INSERT INTO bel_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","А тое адзеньне, або аснова, або ўток, або ўсякі выраб скураны, які ты вымыў і з якога зьнікла хвароба, няхай будзе вымыты паўторна, і будзе ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Гэта закон адносна хваробы праказы на адзеньні ваўняным ці льняным, або на аснове, або на ўтоку, або на ўсялякім вырабе скураным, каб прызнаць іх чыстымі або нячыстымі». ");
INSERT INTO bel_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Гэта закон адносна пракажонага ў дзень ачышчэньня ягонага. Няхай прывядуць яго да сьвятара, ");
INSERT INTO bel_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","і сьвятар выйдзе па-за табар, і агледзіць яго сьвятар, і вось, хвароба праказы вылечаная ў пракажонага. ");
INSERT INTO bel_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","І загадае сьвятар, каб за таго, які ачышчаны, узялі дзьве птушкі жывыя, чыстыя, і дрэва кедровага, і ніткі кармазыновыя, і гізоп. ");
INSERT INTO bel_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","І сьвятар загадае забіць адну птушку над гліняным начыньнем, напоўненым вадой жывою. ");
INSERT INTO bel_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","І возьме другую жывую птушку разам з дрэвам кедровым, і ніткі кармазыновыя, і гізоп, і ўмочыць іх і птушку жывую ў крыві птушкі, забітай над вадою жывою, ");
INSERT INTO bel_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","і папырскае на ачышчанага ад праказы сем разоў, і прызнае яго чыстым. А птушку жывую выпусьціць у поле. ");
INSERT INTO bel_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ачышчаны памые адзеньне сваё, абголіць усе валасы свае, і вымыецца ў вадзе, і будзе чысты. Пасьля ачышчаны ўвой­дзе ў табар і будзе жыць сем дзён па-за намётам сваім. ");
INSERT INTO bel_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","У сёмы дзень абголіць ён усе валасы свае, абголіць галаву і бараду, і бровы свае, вымые адзеньне, абмые цела сваё вадой і будзе чысты. ");
INSERT INTO bel_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","У восьмы дзень возьме ён двух ягнятаў без заганы, адну авечку аднагадовую без заганы і тры дзясятыя эфы пшанічнай мукі, зьмяшанай з алеем, як ахвяру хлебную, і адзін лог алею. ");
INSERT INTO bel_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","І сьвятар, які ачышчае, паставіць чалавека ачышчанага з усім гэтым перад абліччам ГОСПАДА каля ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","І сьвятар возьме адно ягня, і складзе яго ў ахвяру аднагараджэньня, і возьме лог алею, і прынясе ўсё гэта, патрэсваючы перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","І заб’е ягня гэтае на месцы, на якім забіваюцца ахвяры за грэх і ахвяры цэласпаленьня, на месцы сьвятым, бо ахвяра аднагараджэньня, як і ахвяра за грэх, належыць сьвятару; гэта сьвятое сьвятых. ");
INSERT INTO bel_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","І возьме сьвятар кроў ахвяры аднагараджэньня, і памажа ёю верх правага вуха чалавека, які ачышчаецца, а таксама вялікі палец яго правай рукі і вялікі палец яго правай нагі. ");
INSERT INTO bel_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","І возьме сьвятар лог алею, і вылье яго на сваю левую далонь. ");
INSERT INTO bel_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","І памочыць сьвятар палец правай рукі сваёй у алеі, які на яго левай далоні, і пакра­піць пальцам, памочаным у алеі, сем разоў перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Рэштаю алею, што на далоні ягонай, сьвятар памажа верх правага вуха чалавека, які ачышчаецца, а таксама вялікі палец яго правай рукі і вялікі палец яго правай нагі над крывёй ахвяры аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","А рэшту алею, якая на далоні сьвятара, вылье ён на галаву таго, хто ачышчаецца. Гэтак перапросіць за яго сьвятар перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","І складзе сьвятар ахвяру за грэх, і перапросіць за таго, хто ачышчаецца, за нячыс­тасьць ягоную, і пасьля складзе ахвяру цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","І складзе сьвятар ахвяру цэласпаленьня на ахвярніку разам з ахвярай хлебнай. І так сьвятар ачысьціць таго чалавека, і будзе ён чысты. ");
INSERT INTO bel_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Калі ж хто бедны і няма ў руцэ ягонай дастатку, няхай возьме адно ягня ў ахвяру аднагараджэньня для патрэс­ваньня, каб быць ачышчаным, а таксама дзясятую частку эфы мукі, запраўленай алеем, у ахвяру хлебную, і лог алею, ");
INSERT INTO bel_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","і дзьве туркаўкі або два маладыя галубы, на што будзе здольная рука ягоная; адну птушку ў ахвяру за грэх, а другую — на цэласпаленьне. ");
INSERT INTO bel_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","І прынясе іх на восьмы дзень ачышчэньня свайго да сьвятара да ўваходу ў Намёт Спатканьня перад аблічча ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","І сьвятар возьме ягня ў ахвяру аднагараджэньня і лог алею, і будзе патрэсваць патрэс­ваньнем перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","І заб’е ягня ў ахвяру аднагараджэньня, і возьме сьвятар кроў ахвяры аднагараджэньня, і памажа верх правага вуха чалавека, які ачышчаецца, і вялікі палец яго правай рукі, і вялікі палец яго правай нагі. ");
INSERT INTO bel_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","І налье сьвятар алей на левую далонь сваю, ");
INSERT INTO bel_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","і, памачыўшы ў ім палец правай рукі сваёй, пакрапіць сем разоў перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","І сьвятар памажа алеем, які ў яго на далоні, верх правага вуха таго, хто ачышчаецца, а таксама вялікі палец яго правай рукі і вялікі палец яго правай нагі ў месцы крыві ахвяры аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","А рэшту алею, што застаўся на левай руцэ яго, вылье сьвятар на галаву таго, хто ачышчаецца, каб перапрасіць за яго перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","І ахвяруе адну туркаўку або маладога галуба, якога прынясе рука таго, хто ачышчаецца, ");
INSERT INTO bel_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","і ахвяруе аднаго за грэх, а другога на цэласпаленьне разам з ахвярай хлебнай, і так ачысьціць яго сьвятар перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Гэта закон адносна пракажонага, якому не стае маёмасьці ў руцэ ягонай дзеля ачышчэньня свайго». ");
INSERT INTO bel_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Калі ўвойдзеце ў зямлю Ханаан, якую Я дам вам на ўласнасьць, і калі спашлю хваробу праказы на нейкі дом у зямлі пасяленьня вашага, ");
INSERT INTO bel_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","няхай той, чый гэта дом, ідзе і паведаміць сьвятару, кажучы: “Хваробу я ўгледзеў у доме маім”. ");
INSERT INTO bel_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","І сьвятар загадае, каб прыбралі ўсё з дому, пакуль ён увойдзе ў яго, каб агледзець заразу, каб яна не апаганіла ўсяго, што ў доме. І ўвойдзе сьвятар, каб агледзець дом. ");
INSERT INTO bel_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","І ён агледзіць хваробу тую, і вось, на сьценах хвароба дому, нібы ямінкі, зелянявыя ці чырвоныя, што ўеліся ў сьцяну. ");
INSERT INTO bel_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","І выйдзе сьвятар з дому да дзьвярэй дому, і зачыніць дом на сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","У сёмы дзень вернецца сьвятар і агледзіць дом. І вось, пашырылася хвароба на сьцяне дому. ");
INSERT INTO bel_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","І загадае сьвятар, і выр­вуць тыя камяні заражаныя, і выкінуць іх за горад на месца нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","А дом кругом унутры аб­скра­буць, і тынк, які абскрэб­лі, выкінуць на месца нячыстае за горадам. ");
INSERT INTO bel_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","І возьмуць іншыя камяні, і пакладуць на месца папярэдніх камянёў, і возьмуць іншую заправу, і атынкуюць дом. ");
INSERT INTO bel_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Калі ж зараза зноў закрасавала ў доме, хоць вырвалі камяні, а дом абскрэблі і атынкавалі, ");
INSERT INTO bel_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","прыйдзе сьвятар і агледзіць яго. І вось, зараза ў доме пашырылася, гэта ліхая праказа ў доме гэтым, і ён нячысты. ");
INSERT INTO bel_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","І дом гэты зруйнуюць, а камяні, і дрэва, і ўвесь тынк дому таго выкінуць за горад у месца нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","І калі нехта ўвойдзе ў дом, калі ён зачынены, будзе ён нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","А калі нехта сьпіць у доме гэтым або есьць у доме гэтым, няхай памые адзеньне сваё. ");
INSERT INTO bel_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","А калі сьвятар прыйдзе, і агледзіць яго, і вось, зараза не пашырылася ў доме гэтым пасьля атынкаваньня, сьвятар прызнае гэты дом чыстым, бо зараза была вылекавана. ");
INSERT INTO bel_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","І дзеля ачышчэньня дому сьвятар возьме дзьве птушкі, кавалак дрэва кедровага, ніткі кармазыновыя і гізоп. ");
INSERT INTO bel_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","І заб’е адну птушку над пасудзінай глінянай над вадою жывою. ");
INSERT INTO bel_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","І возьме дрэва кедровае, гізоп, ніткі кармазыновыя і жывую птушку, памочыць іх у крыві забітай птушкі і ў вадзе жывой, і пакрапіць сем разоў дом. ");
INSERT INTO bel_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","І ачысьціць дом той крывёй птушкі, і вадой жывой, і дрэвам кедровым, і ніткамі кармазыновымі, і гізопам. ");
INSERT INTO bel_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","А жывую птушку пусьціць за горадам у полі. І перапросіць за дом гэты, і ён будзе чыстым. ");
INSERT INTO bel_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Гэта закон адносна ўсякай заразы, праказы і паршывасьці, ");
INSERT INTO bel_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","праказы на адзеньні і ў доме, ");
INSERT INTO bel_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","пухліны, скулаў і белых плямаў, ");
INSERT INTO bel_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","каб навучыць, калі што чыстае, а калі нячыстае. Гэта закон адносна праказы». ");
INSERT INTO bel_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Аб’явіце сынам Ізраіля і скажыце ім: “Мужчына, які мае выцёкі з цела свайго, нячысты. ");
INSERT INTO bel_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Нячыстасьць яго ў выцёках ягоных, калі цела ягонае дапускае выцёк, ці калі затрымоўваецца выцёк у целе; гэта нячыстасьць ягоная. ");
INSERT INTO bel_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Кожны ложак, на якім ляжаў той, хто мае выцёкі, бу­дзе нячысты, а таксама ўсякая рэч, на якой ён сядзеў. ");
INSERT INTO bel_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Кожны, хто дакранецца ложка ягонага, няхай памые адзеньне сваё, вымыецца ў ва­дзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Той, хто сеў на рэчы, на якіх сядзеў той, хто мае выцёкі, няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Той, хто дакранецца цела чалавека, які мае выцёкі, няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Калі той, хто мае выцёкі, плюне на чалавека чыстага, той няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Кожнае сядло, на якім сядзеў чалавек, што мае выцёкі, будзе нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Кожны, хто дакранецца чаго-колечы, што той, хто мае выцёкі, меў пад сабою, будзе нячысты аж да вечара. Кожны, хто пераносіць такія рэчы, няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Кожны, да каго дакранецца той, хто мае выцёкі, не памыўшы перш рукі ў вадзе, няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Кожны посуд гліняны, да якога дакранаецца той, хто мае выцёкі, няхай будзе пабіты, а кожны посуд драўляны няхай будзе вымыты ў вадзе. ");
INSERT INTO bel_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Калі той, хто мае выцёкі, паздаравее ад выцёкаў, тады няхай адлічыць сем дзён на ачышчэньне сваё, і, памыўшы адзеньне сваё і цела сваё ў жывой вадзе, будзе чысты. ");
INSERT INTO bel_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","У восьмы дзень возьме дзьвюх туркавак або двух маладых галубоў, і пойдзе перад аблічча ГОСПАДА да ўваходу ў Намёт Спатканьня, і аддасьць іх сьвятару. ");
INSERT INTO bel_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Сьвятар складзе іх у ахвяру: аднаго — у ахвяру за грэх, другога — у ахвяру цэласпаленьня, і перапросіць за яго сьвятар перад абліччам ГОСПАДА за выцёкі ягоныя. ");
INSERT INTO bel_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Калі ў каго выльецца насеньне, няхай ён абмые вадою ўсё цела сваё, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","І ўсякае адзеньне, і ўсякую скуру, на якую выльецца насеньне, трэба вымыць вадою, і яны будуць нячыстыя да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Калі мужчына ляжа з жанчынаю, і ў яго выльецца насень­не, няхай абодва абмыюцца ў вадзе, і будуць нячыс­тыя да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Калі жанчына мае цячэньне крыві з цела свайго, і гэта ме­сячніца, яна сем дзён будзе ў ня­чыстасьці сваёй. Кожны, хто яе дакранецца, будзе нячысты да вечара, ");
INSERT INTO bel_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","і ўсё, на чым яна ляжала або сядзела ў дні нячыстасьці сваёй, будзе нячыстым. ");
INSERT INTO bel_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Хто дакранецца ложка ейнага, няхай памые адзеньне сваё і вымыецца ў вадзе, і бу­дзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Кожны, хто дакранецца рэчаў, на якіх яна сядзела, няхай памые адзеньне сваё, вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Калі хто дакранецца таго, што ляжала на ложку яе, або на рэчах, на якіх яна ся­дзела, будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Калі мужчына ляжа тады з ёю, нячыстасьць ейная будзе на ім, і ён будзе нячысты сем дзён. Кожны ложак, на які ён ляжа, будзе нячысты. ");
INSERT INTO bel_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Калі жанчына церпіць цячэньне крыві многія дні і ня ў час месячніцы, або калі пасьля месячніцы кроў не спыняецца, яна нячыстая ўсе гэтыя дні; як доўга будзе мець нячыс­тасьць сваю, будзе нячыстая. ");
INSERT INTO bel_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Кожны ложак, на якім бу­дзе ляжаць яна падчас цячэньня крыві сваёй, і рэчы, на якіх будзе сядзець, будуць нячыс­ты­мі, як нячыстыя падчас месячніцы яе. ");
INSERT INTO bel_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Хто дакранецца іх, бу­дзе ня­чысты, няхай памые адзе­нь­не сваё ў вадзе, і вымыецца ў вадзе, і будзе нячысты да вечара. ");
INSERT INTO bel_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Калі кроў спыніцца цячы, няхай яна адлічыць сем дзён, і потым будзе чыстая. ");
INSERT INTO bel_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","У восьмы дзень возьме яна за сябе дзьвюх туркавак або двух маладых галубоў і прынясе сьвятару да ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Сьвятар складзе аднаго ў ахвяру за грэх, а другога — на цэласпаленьне, і перапро­сіць за яе сьвятар перад абліччам ГОСПАДА за цячэньне нячыстасьці яе. ");
INSERT INTO bel_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Аддзяляйце сыноў Ізраіля ад нячыстасьці іхняй, каб яны не памерлі ў нячыстасьці сваёй, паганячы Сялібу Маю, якая ёсьць сярод іх. ");
INSERT INTO bel_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Гэта закон адносна таго, хто мае выцёкі насеньня і стаецца нячыстым, ");
INSERT INTO bel_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","і адносна жанчыны, якая мае месячніцу, і адносна муж­чы­ны і жанчыны, якія ма­юць выцёкі, і адносна мужчы­ны, які ляжа з жанчынай нячыстай”». ");
INSERT INTO bel_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","І прамовіў ГОСПАД да Майсея пасьля сьмер­ці двух сыноў Аарона, калі яны прыйшлі перад аблічча ГОСПАДА і памерлі, ");
INSERT INTO bel_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","і сказаў ГОСПАД Майсею: «Скажы Аарону, брату твайму, каб ня ў кожны час ён уваходзіў у Месца Сьвятое за заслону перад накрыўкай, якая на Каўчэгу, каб ён не памёр, калі Я буду аб’яўляцца ў воблаку над накрыўкай. ");
INSERT INTO bel_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Вось, будзе ён уваходзіць у Месца Сьвятое, узяўшы маладое цяля ў ахвяру за грэх і барана ў ахвяру цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","І няхай апранецца ён у шату льняную сьвятую, і сподні льняныя будуць на целе ягоным, і перапаяшацца паясом ільняным, а на галаву ўскладзе ільняны кідар; гэта шаты сьвятыя. Няхай ён абмые цела сваё ў вадзе і апране іх. ");
INSERT INTO bel_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","І возьме ад грамады сыноў Ізраіля двух казлоў: аднаго — у ахвяру за грэх, а другога — у ахвяру цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","І Аарон прывядзе цяля ў ахвяру за грэх за сябе і перапросіць за сябе і за дом свой. ");
INSERT INTO bel_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","І возьме двух казлоў, і паставіць іх перад абліччам ГОСПАДА перад уваходам у Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","І кіне Аарон жэрабя на гэтых казлоў: адно жэрабя — для ГОСПАДА, а другое жэрабя — для Азазэля. ");
INSERT INTO bel_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","І прывядзе Аарон таго казла, на якога выпала жэрабя для ГОСПАДА, і складзе яго ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","а казла, на якога выпала жэрабя для Азазэля, паставіць жывога перад абліччам ГОСПАДА, каб выканаць перамаленьне і каб выгнаць яго для Азазэля ў пустыню. ");
INSERT INTO bel_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","І прывядзе Аарон цяля ў ахвяру за грэх за сябе і на перамаленьне за сябе і за свой дом, і заб’е цяля ў ахвяру за грэх за сябе. ");
INSERT INTO bel_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","І возьме поўную кадзільніцу напаленых вуглёў з ахвярніка, які перад абліччам ГОСПАДА, і поўныя жмені пахкага тоўчанага кадзіла, і занясе за заслону; ");
INSERT INTO bel_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","і кіне кадзіла на агонь перад абліччам ГОСПАДА. Воблака кадзіла закрые накрыўку, якая над Каўчэгам Сьведчаньня, і ён не памрэ. ");
INSERT INTO bel_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","І возьме крыві цяляці, і пакрапіць пальцам сваім перад накрыўкай з усходу. Сем разоў пакрапіць перад накрыўкай пальцам, змочаным у крыві. ");
INSERT INTO bel_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","І заб’е казла за грэх народу, і ўнясе кроў яго за заслону, і зробіць з крывёй яго тое самае, што зрабіў з крывёй цяляці, і пакрапіць ёю накрыўку зьверху і сьпераду, ");
INSERT INTO bel_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","і перапросіць за Месца Сьвятое, за нячыстасьць сыноў Ізраіля і за злачынствы іх паводле ўсіх грахоў іхніх. Гэтак сама зробіць ён з Намётам Спатканьня, які знаходзіцца ў іх сярод нячыстасьці іхняй. ");
INSERT INTO bel_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ніводзін чалавек не павінен быць у Намёце Спатканьня, калі Аарон увойдзе, каб выканаць перамаленьне ў Месцы Сьвятым, аж пакуль ён ня выйдзе. І ён перапро­сіць за сябе, за дом свой і за ўсю царкву Ізраіля. ");
INSERT INTO bel_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","І выйдзе да ахвярніка, які перад абліччам ГОСПАДА, і ўчыніць перамольваньне над ім, і возьме крыві бычка і крыві казла, і памажа ёю рогі ахвярніка з усіх бакоў, ");
INSERT INTO bel_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","і пакропіць сем разоў яго пальцам, умочаным у крыві, і ачысьціць яго ад нячыстасьці сыноў Ізраіля, і асьвяціць яго. ");
INSERT INTO bel_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","І скончыць перамольваньне над Месцам Сьвятым, Намётам Спатканьня і ахвярні­кам, і прывядзе жывога казла. ");
INSERT INTO bel_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","І ўскладзе Аарон абедзьве рукі свае на галаву жывога казла, і выкажа над ім усе правіны сыноў Ізраіля, усе злачынствы іхнія і ўсе грахі іхнія, і ўзло­жыць іх на галаву казла, і выганіць яго праз прызначанага чалавека ў пустыню. ");
INSERT INTO bel_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","І панясе казёл з сабой усе пра­віны іхнія ў зямлю бязьлюдную, і выганіць ён казла ў пустыню. ");
INSERT INTO bel_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","І Аарон увойдзе ў Намёт Спатканьня, здыме шаты льняныя, якія апрануў, увахо­­дзячы ў Месца Сьвятое, і пакладзе іх там. ");
INSERT INTO bel_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","І абмые цела вадою ў месцы сьвятым, і апране адзеньне сваё, і выйдзе, і складзе ахвяру цэласпаленьня за сябе і за народ, і перапросіць за сябе і за народ. ");
INSERT INTO bel_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","І тлушч ахвяры за грэх спаліць на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","А чалавек, які выгнаў казла для Азазэля, памые адзеньне сваё, абмые цела сваё ў вадзе, і вернецца ў табар. ");
INSERT INTO bel_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","А бычка ахвяры за грэх і казла ахвяры за грэх, кроў якіх унесена была для перамаленьня за Месца Сьвятое, вынясуць па-за табар і спаляць разам са скураю, мясам і нячыстасьцю іхняй. ");
INSERT INTO bel_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Той, хто спаліць іх, памые адзеньне сваё і абмые цела сваё ў вадзе, і вернецца ў табар. ");
INSERT INTO bel_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Гэта будзе для вас пастановай вечнай. У сёмы месяц, у дзясяты дзень месяца пры­гня­тайце душы вашыя пакутаю, не выконвайце ніякай працы ані тутэйшы, ані прыхадзень, які паселіцца паміж вамі. ");
INSERT INTO bel_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","У той дзень будзе перамаленьне за вас дзеля ачышчэньня ад усіх грахоў вашых, каб былі вы чыстымі перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Гэта для вас супачынак супачынку, прыгнятайце душы вашыя. Гэта пастанова вечная. ");
INSERT INTO bel_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","І будзе перамольваць сьвятар, які быў памазаны і пасьвя­чоны на сьвятарства на месца бацькі свайго. І ўскла­дзе ён на сябе шаты льняныя, шаты сьвятыя, ");
INSERT INTO bel_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","і ўчыніць перамольваньне за Сьвятое Сьвятых і Намёт Спатканьня, ахвярнік, і за сьвятароў і за ўвесь народ царквы. ");
INSERT INTO bel_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Гэта будзе для вас пастанова вечная, каб раз у год перамольваць за сыноў Ізраіля за ўсе грахі іхнія». І зрабіў ён, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Прамоў да Аарона, і да сыноў ягоных, і да ўсіх сыноў Із­ра­іля, і скажы ім: “Гэта слова, якое загадаў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Калі хто з дому Ізраіля заб’е вала, або авечку, або казу ў табары або па-за табарам ");
INSERT INTO bel_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","і не прывядзе іх да ўваходу ў Намёт Спатканьня, каб скласьці ў ахвяру ГОСПАДУ перад сялібай ГОСПАДА, будзе вінен крыві. Ён праліў кроў, і будзе выключаны той чалавек з народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Дзеля таго сыны Ізраіля будуць прыводзіць ахвяры свае, якія дасюль складалі ў полі, да ГОСПАДА да ўваходу ў Намёт Спатканьня, да сьвятара, і будуць складаць іх як ахвяры мірныя для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","І пакропіць сьвятар крывёй ахвярнік ГОСПАДА пры ўваходзе ў Намёт Спатканьня, а тлушч спаліць на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ужо ня будуць складаць ахвяраў для казлоў, з якімі распусьнічалі. Гэта будзе ім пастанова вечная для пакаленьняў іхніх”. ");
INSERT INTO bel_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","І скажаш ім: “Калі хто з дому Ізраіля або з прыхадняў, якія жывуць сярод вас, будзе складаць ахвяру цэласпаленьня або іншую ахвяру ");
INSERT INTO bel_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","і не прывядзе яе да ўваходу ў Намёт Спатканьня, каб ахвяраваць ГОСПАДУ, будзе чалавек той выключаны з народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Калі хто з дому Ізраіля або з прыхадняў, якія жывуць сярод вас, будзе есьці кроў, Я скірую аблічча Маё супраць душы, якая есьць кроў, і вынішчу яе спаміж народу яе. ");
INSERT INTO bel_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Бо душа цела ў крыві, і Я даў яе вам, каб на ахвярніку перамольвалі ёю за душы вашыя, бо кроў перамольвае за душу. ");
INSERT INTO bel_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Дзеля таго Я сказаў сынам Ізраіля: \"Ніхто з вас ня будзе спажываць крыві\". І прыха­дзень, які жыве сярод вас, ня будзе спажываць крыві. ");
INSERT INTO bel_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Калі хто з сыноў Ізраіля або з прыхадняў, якія жывуць сярод вас, упалюе дзікага зьвера або птушку, якіх можна есьці, няхай вылье з іх кроў і закрые яе пылам зямлі. ");
INSERT INTO bel_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Бо душа кожнага цела ў крыві ягонай; і Я сказаў сынам Ізраіля: \"Не спажывайце крыві ніводнага цела, бо душа кожнага цела ў крыві ягонай. Кожны, хто будзе спажываць яе, будзе вынішчаны\". ");
INSERT INTO bel_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Кожны тутэйшы або прыхадзень, які будзе есьці мяса падліны або разьдзёртай жывёлы, няхай памые адзеньне і вымыецца ў вадзе, і будзе ён нячысты да вечара, а пасьля станецца чыстым. ");
INSERT INTO bel_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Калі ж хто не памые адзеньня і ня вымые цела свайго, бу­дзе насіць правіну сваю”». ");
INSERT INTO bel_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Я — ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Не рабіце паводле звычаю зямлі Эгіпецкай, у якой вы жылі. І паводле звычаю зямлі Ханаан, у якую Я ўвяду вас, не рабіце, і не хадзіце паводле пастановаў іхніх. ");
INSERT INTO bel_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Будзеце спаўняць прысуды Мае і пастановы Мае, захоў­ваць і хадзіць паводле іх. Я — ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Захоўвайце пастановы Мае і прысуды Мае. Выконваючы іх, чалавек будзе жыць дзякуючы ім. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ніхто ня можа набліжацца да сваяка, каб адкрыць голасьць ягоную. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Не адкрывай голасьці бацькі твайго і маці тваёй, бо гэта — маці твая, не адкрывай голасьць ейную. ");
INSERT INTO bel_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Не адкрывай голасьці жонкі бацькі твайго, бо гэта голасьць бацькі твайго. ");
INSERT INTO bel_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Не адкрывай голасьці сястры тваёй, дачкі бацькі твайго або дачкі маці тваёй, ці яна нарадзілася ў доме, ці па-за домам. Не адкрывай голасьці іх. ");
INSERT INTO bel_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Не адкрывай голасьці дачкі сына твайго або дачкі дачкі тваёй, бо гэта голасьць твая. ");
INSERT INTO bel_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Не адкрывай голасьці дачкі жонкі бацькі твайго, народжанай ад бацькі твайго; гэта сястра твая, не адкрывай голасьці яе. ");
INSERT INTO bel_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Не адкрывай голасьці сястры бацькі твайго, бо яна сваячка бацькі твайго. ");
INSERT INTO bel_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Не адкрывай голасьць сястры маці тваёй, бо яна сваячка маці тваёй. ");
INSERT INTO bel_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Не адкрывай голасьці брата бацькі твайго, ня ўваходзь да жонкі ягонай, бо гэта цётка твая. ");
INSERT INTO bel_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Не адкрывай голасьці нявесткі тваёй, бо яна жонка сына твайго, не адкрывай голасьці яе. ");
INSERT INTO bel_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Не адкрывай голасьці жонкі брата твайго, бо гэта голасьць брата твайго. ");
INSERT INTO bel_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Не адкрывай голасьці жанчыны і дачкі яе. Не бяры дачкі сына ейнага ані дачкі дачкі ейнай, каб адкрыць голасьць яе, бо яны — сваячкі яе. Гэта брыдота. ");
INSERT INTO bel_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Не бяры жанчыны разам з сястрой яе, каб не зрабіць яе суперніцай, адкрываючы голасьць яе за жыцьця гэтай. ");
INSERT INTO bel_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Не набліжайся да жанчыны ў час месячніцы, каб адкрыць голасьць яе. ");
INSERT INTO bel_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Не ўваходзь да жонкі бліжняга твайго, выліваючы насеньне; праз гэта станешся ты нячысты. ");
INSERT INTO bel_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Не аддавай дзіцяці твайго, каб прывесьці да Малоха, і ня будзеш паганіць імя Бога твайго. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Не ляжы з мужчынам так, як ляжаць з жанчынаю. Гэта агіда. ");
INSERT INTO bel_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Не лажыся ні з якою жывёлаю, бо праз гэта станешся нячысты. І жанчына ня стане перад жывёлаю, каб злучыцца з ёю, бо гэта вычварэньне. ");
INSERT INTO bel_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Не паганьцеся ўсім гэтым, бо ўсім гэтым апаганілі сябе на­роды, якія Я выганю перад вамі. ");
INSERT INTO bel_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","І апаганілася зямля, і Я пакараў яе за беззаконьні ейныя, і выкінула яна з сябе жыхароў сваіх. ");
INSERT INTO bel_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Дык вы захоўвайце пастановы Мае і прысуды Мае, і не дапускайцеся ўсіх гэтых брыдотаў, ані тутэйшыя, ані прыхадні, якія жывуць сярод вас, ");
INSERT INTO bel_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","бо ўсіх гэтых брыдотаў дапускаліся жыхары зямлі, якія былі перад вамі, і апаганілася зямля. ");
INSERT INTO bel_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Сьцеражыцеся, каб і вас гэтая зямля ня выкінула, калі будзеце паганіць яе, як яна выкінула з сябе народ, які быў перад вамі. ");
INSERT INTO bel_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Бо кожны чалавек, які ўчыніць адну з гэтых брыдотаў, будзе вынішчаны спасярод народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Захоўвайце загады Мае. Не дапускайцеся брыдотных звычаяў, як дапускаліся тыя, што былі перад вамі, і не паганьцеся імі. Я — ГОСПАД, Бог ваш”». ");
INSERT INTO bel_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Прамоў да ўсёй грамады сыноў Ізраіля і скажы ім: “Будзьце сьвятымі, бо сьвяты Я, ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Няхай кожны баіцца маці сваю і бацьку свайго. І захоўвайце суботы Мае. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Не зьвяртайцеся да ідалаў і не вылівайце сабе багоў з мэталю. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Калі будзеце складаць ГОСПАДУ ахвяру мірную, складайце так, каб была яна Яму прыемнай. ");
INSERT INTO bel_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Будзеце есьці яе ў сам дзень ахвяры вашай і ў наступны дзень. Тое, што застанецца на трэці дзень, будзе спалена агнём. ");
INSERT INTO bel_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Калі хто гэта будзе есьці на трэці дзень, паганым гэта будзе і ня будзе прыемным Госпаду. ");
INSERT INTO bel_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Хто будзе яе есьці, учыніць беззаконьне, бо спаганіў сьвятасьць ГОСПАДА, і зьнішчана будзе душа тая спасярод народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Калі будзеце жаць збожжа зямлі вашай, не выжынай аж да канца поля і не зьбірай каласоў, што засталіся. ");
INSERT INTO bel_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Не абірай вінаградніка твайго да рэшты і ягадаў, што пападалі ў вінаградніку, не падбірай; пакінь гэта бедным і прыхадням. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Не крадзіце, і не хлусіце, і не ашуквайце адзін аднаго. ");
INSERT INTO bel_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Не прысягайце на імя Маё дзеля хлусьні, і не зьневажай імя Бога твайго. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Не прыгнятай бліжняга твайго і ня крыўдзі яго. І няхай не застаецца ў цябе плата найміта аж да раніцы. ");
INSERT INTO bel_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Не праклінай глухога і перад сьляпым не кладзі перашкоды, але бойся Бога твайго. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Не дапускайцеся несправядлівасьці на судзе. Не пагарджай бедным і не патурай багатаму. Праведна судзі бліжняга твайго. ");
INSERT INTO bel_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ня будзь паклёпнікам у народзе сваім. Не цікуй на кроў бліжняга твайго. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ня мей у сэрцы тваім нянавісьці да брата твайго. Дакараючы, дакарай бліжняга твайго, і ня будзеш мець грэху з прычыны яго. ");
INSERT INTO bel_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ня помсьці і не насі крыўду на сыноў народу твайго. Любі бліжняга твайго як самога сябе. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Захоўвай пастановы Мае. Жывёлы тваёй не лучы з жывёлай другой пароды; поля твайго не засявай двума гатункамі насеньня. Не апранай адзеньня з двух матэрыялаў. ");
INSERT INTO bel_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Калі хто ўвойдзе да жанчы­ны, выліваючы насеньне, а яна ёсьць нявольніцай, прызначанай для іншага мужа, але яшчэ ня выкуплена і не надзелена свабодай, абодва будуць пакараныя, але не карай сьмерцю, бо не была яна свабоднай. ");
INSERT INTO bel_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","І ён складзе ахвяру аднагараджэньня ГОСПАДУ каля ўваходу ў Намёт Спатканьня, барана ў ахвяру аднагараджэньня. ");
INSERT INTO bel_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","І перапросіць за яго сьвятар бараном ахвяры аднагараджэньня за грэх ягоны, якім саграшыў перад абліччам ГОСПАДА, і будзе адпушчаны яму грэх, якім саграшыў. ");
INSERT INTO bel_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Калі прыйдзеце вы ў зямлю і пасадзіце дрэвы пладовыя ўсякіх гатункаў, будзеце ўважаць плады іхнія за неабрэзаныя; тры гады будуць яны для вас неабрэзаныя, і нельга іх есьці. ");
INSERT INTO bel_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","У чацьвёртым годзе ўсе плады іхнія будуць пасьвячоныя як дар для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","А ў пяты год будзеце есьці плады іхнія, каб павялічыўся для вас ураджай з іх. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ня ешце нічога з крывёй. Не варажыце і не займайцеся чараваньнем. ");
INSERT INTO bel_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Не стрыжы валасоў кругом галавы, і не калеч край барады сваёй. ");
INSERT INTO bel_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Не рабіце нарэзы на целе вашым на знак жалобы па памерлых і не наколвайце надпісы на скуры. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Не выдавай на ганьбу дачку тваю, робячы з яе распусьніцу, каб не апаганілася зямля і не напоўнілася распустай. ");
INSERT INTO bel_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Захоўвайце суботы Мае і шануйце сьвятыню Маю. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Не зьвяртайцеся ані да тых, што выклікаюць духаў памерлых, ані да варажбітоў, каб у іх раіцца, каб праз іх не апаганіліся. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Перад сівой галавой устань, і шануй аблічча старога, і бойся Бога твайго. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Калі ў зямлі вашай паселіцца прыхадзень, ня крыўдзі яго, ");
INSERT INTO bel_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","але няхай будзе ён пасярод вас як тутэйшы, і любі яго як самога сябе, бо і вы былі прыхаднямі ў зямлі Эгіпецкай. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Не дапускайцеся несправядлівасьці на судзе, у меры, у вазе і ў вымярэньнях. ");
INSERT INTO bel_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Няхай будуць у вас вагі праведныя, эфа праведная і гін праведны. Я — ГОСПАД, Бог ваш, Які вывеў вас з зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","І вы будзеце захоўваць усе пастановы Мае і ўсе пысуды Мае, і выконваць іх. Я — ГОСПАД”». ");
INSERT INTO bel_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Кажы сынам Ізраіля: “Калі нехта з сыноў Ізраіля або з сыноў прыхадняў, якія пасяліліся ў Ізраілі, дасьць адно з дзяцей сваіх Малоху, сьмерцю памрэ; землякі ягоныя ўкамянуюць яго. ");
INSERT INTO bel_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","І Я Сам зьвярну аблічча Маё супраць яго, і выкараню яго спаміж народу яго за тое, што ён даў насеньне сваё Малоху, спаганіў сьвятыню Маю і зьняважыў сьвятое імя Маё. ");
INSERT INTO bel_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Калі землякі ягоныя закрыюць вочы свае на такога чалавека, які аддаў адно з дзяцей сваіх Малоху, і не заб’юць яго, ");
INSERT INTO bel_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Я Сам зьвярну аблічча Маё супраць такога чалавека і супраць сям’і ягонай, і выкараню яго спасярод народу яго, а таксама ўсіх тых, якія насьлядуюць яго, якія распусьнічаюць з Малохам. ");
INSERT INTO bel_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","І супраць душы, якая зьвернецца да тых, што выклікаюць духаў памерлых, або да варажбітоў, каб распусьнічаць з імі, Я зьвярну аблічча Маё, і выкараню яго спаміж народу яго. ");
INSERT INTO bel_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Дык асьвяціцеся і будзьце сьвятыя, бо Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Захоўвайце пастановы Мае і выконвайце іх. Я — ГОСПАД, Які асьвячае вас! ");
INSERT INTO bel_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Хто праклінае бацьку свайго і маці сваю, сьмерцю памрэ; хто праклінаў бацьку свайго і маці сваю, кроў ягоная будзе на ім. ");
INSERT INTO bel_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Калі хто будзе чужаложыць з жонкай бліжняга свайго, сьмерцю памрэ і чужаложнік, і чужаложніца. ");
INSERT INTO bel_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Хто ляжа з жонкаю бацькі свайго, той адкрывае го­ласьць бацькі свайго; сьмерцю па­мруць абое, кроў іхняя бу­дзе на іх. ");
INSERT INTO bel_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Хто ляжа з нявесткай сваёй, сьмерцю памруць абое. Яны дапусьціліся брыдоты, і кроў іхняя будзе на іх. ");
INSERT INTO bel_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Хто ляжа з мужчынам так, як з жанчынай, робіць вычварэньне. Абодва сьмерцю памруць; кроў іхняя будзе на іх. ");
INSERT INTO bel_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Калі хто бярэ за жонку жанчыну і маці ейную, дапускаецца распусты; ён і яна будуць спалены ў агні, каб не было распусты сярод вас. ");
INSERT INTO bel_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Хто ляжа з жывёлай, выліваючы насеньне, сьмерцю памрэ. Жывёлу таксама трэба забіць. ");
INSERT INTO bel_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Калі жанчына наблізіцца да якой жывёлы, каб злучыцца з ёй, заб’еш і жанчыну, і жывёлу. Абое сьмерцю памруць; кроў іхняя будзе на іх. ");
INSERT INTO bel_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Калі хто возьме сястру сваю, дачку бацькі свайго або дачку маці сваёй, і будзе агля­даць голасьць яе, а яна будзе аглядаць голасьць яго, гэта сорам; няхай будуць забітыя перад вачыма сыноў народу свайго; ён адкрыў голасьць сястры сваёй, беззаконьня ён дапусьціўся. ");
INSERT INTO bel_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Калі хто ляжа з жанчынай у час месячніцы і адкрые голасьць яе, ён адкрывае крыніцу крыві, і яна таксама адкрывае крыніцу крыві сваёй; абодва вынішчаны будуць спасярод народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Не адкрывай голасьці сястры маці тваёй або сястры бацькі твайго, бо выяўляеш голасьць сваячкі сваёй. Беззаконьне сваё яны панясуць. ");
INSERT INTO bel_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Хто ляжа з цёткай сваёй, той адкрывае голасьць дзядзькі свайго. Яны панясуць грэх свой, памруць бязьдзетныя. ");
INSERT INTO bel_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Хто бярэ жонку брата свайго, гэта паскудства. Ён адкрыў голасьць брата свайго, будуць яны бязьдзетныя. ");
INSERT INTO bel_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Захоўвайце ўсе пастановы Мае і ўсе прысуды Мае і выконвайце іх, каб ня выкінула вас зямля, у якую Я ўвяду вас, каб вы жылі ў ёй. ");
INSERT INTO bel_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Не хадзіце паводле звычаяў народаў, якія Я выганю перад вамі. Бо ўсяго гэтага дапускаліся яны, і яны сталіся для Мяне брыдкімі. ");
INSERT INTO bel_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","І Я сказаў вам: \"Вы ўспадкаеміце зямлю іхнюю, і Я дам яе вам на ўласнасьць, зямлю, якая ацякае малаком і мёдам. Я — ГОСПАД, Бог ваш, Які аддзяліў вас ад іншых народаў\". ");
INSERT INTO bel_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Дык адрозьнівайце жывёлу чыстую ад нячыстай і птушку чыстую ад нячыстай, каб не апаганілі вы душаў вашых жывёлай, і птушкамі, і ўсім, што рухаецца па зямлі, і што Я вылучыў вам як нячыстае. ");
INSERT INTO bel_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Будзьце для Мяне сьвятымі, бо сьвяты Я, ГОСПАД, Які аддзяліў вас ад іншых народаў, каб вы былі Маімі. ");
INSERT INTO bel_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Мужчына або жанчына, калі будуць яны выклі­каць духаў памерлых або варажыць, сьмерцю памруць. Укамянуеце іх камянямі; кроў іхняя будзе на іх”». ");
INSERT INTO bel_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","І сказаў ГОСПАД Майсею: «Гавары сьвятарам, сынам Аарона, і кажы ім: “Няхай не занечышчаецца сьвятар, дакранаючыся памёршага з народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Толькі да блізкіх сваякоў, да бацькі свайго і маці сваёй, сына свайго і дачкі сваёй, і брата свайго, ");
INSERT INTO bel_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","і сястры сваёй, дзяўчыны, што жыве пры ім незамужняя, можна яму дакранацца і занячысьціць сябе. ");
INSERT INTO bel_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","І няхай не занячысьціць сябе сьвятар з прычыны сваякоў жонкі сваёй, бо было б гэта зьнявагаю. ");
INSERT INTO bel_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ня будуць яны стрыгчы галавы сваёй і ня будуць галіць краёў барады, і на целе сваім ня будуць рабіць нарэзаў. ");
INSERT INTO bel_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Сьвятымі будуць яны перад Богам сваім і ня будуць паганіць імя Бога свайго, бо яны складаюць ахвяры агнявыя ГОСПАДУ, хлеб Богу свайму, таму мусяць яны быць сьвятымі. ");
INSERT INTO bel_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ня возьмуць яны за жонку распусьніцы або зьняслаўленай; ня возьмуць жанчыны, выгнанай мужам, бо яны пасьвячоныя для Бога свайго. ");
INSERT INTO bel_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Будзеш уважаць яго за асьвячонага, бо ён складае хлеб Богу твайму. Няхай будзе ён сьвяты для цябе, бо сьвяты Я, ГОСПАД, Які асьвячае вас. ");
INSERT INTO bel_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Калі дачка сьвятара паганіць сябе распустаю і няславіць імя бацькі свайго, будзе яна спалена ў агні. ");
INSERT INTO bel_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Сьвятар вялікі паміж братоў сваіх, галава якога была па­мазана алеем, і рукі якога напоўненыя на сьвятарства, і які апрануты ў шаты сьвятыя, ня будзе распускаць валасоў сваіх і разьдзіраць шатаў сваіх, ");
INSERT INTO bel_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","і ня будзе ён набліжацца да ніводнага памёршага, ня можа ён занячысьціцца нават з прычыны бацькі свайго і маці. ");
INSERT INTO bel_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ня будзе ён выходзіць са сьвятыні і не апаганіць сьвятыню Бога свайго, бо ён памазаны алеем памазаньня для Бога свайго. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","За жонку возьме ён толькі дзяўчыну. ");
INSERT INTO bel_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ня возьме за жонку ані ўдавы, ані разьведзенай, ані зьняслаўленай, ані распусьніцы, але возьме за жонку дзяўчыну спасярод народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","І не зьняславіць ён насеньня свайго сярод народу свайго, бо Я — ГОСПАД, Які асьвячаю яго”». ");
INSERT INTO bel_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Прамоў да Аарона, кажучы: “Ніхто з насеньня твайго ў пакаленьнях іхніх, у якога на целе будзе загана, не павінен набліжацца, каб складаць ахвяру для Бога свайго. ");
INSERT INTO bel_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ніхто, у каго на целе загана, не павінен набліжацца, ані сьляпы, ані кульгавы, ані той, хто мае скалечаны твар, ані някшталтны, ");
INSERT INTO bel_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ані той, хто мае зламаную нагу або зламаную руку, ");
INSERT INTO bel_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ані гарбаты, ані кволы, ані той, хто мае бяльмо на воку, ані каросьлівы, ані паршывы, ані той, хто мае пашкоджаныя яечкі. ");
INSERT INTO bel_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ніводзін чалавек з нашчадкаў Аарона сьвятара, у якога на целе загана, не павінен набліжацца, каб складаць ахвяру агнявую ГОСПАДУ; ён мае загану, не павінен ён набліжацца, каб складаць ахвяру хлеба для Бога свайго. ");
INSERT INTO bel_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Але можа ён есьці хлеб Бога свайго як з дароў сьвятых, так і са сьвятога сьвятых. ");
INSERT INTO bel_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Толькі ня будзе ён увахо­дзіць за заслону і ня будзе падыходзіць да ахвярніка, бо мае загану. Ня будзе ён паганіць сьвятыню Маю, бо Я — ГОСПАД, Які асьвячаю іх”». ");
INSERT INTO bel_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","І Майсей прамовіў гэта да Аарона, да сыноў ягоных і да ўсіх сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Прамоў да Аарона і да сыноў ягоных, каб яны паважалі сьвятыя дары сыноў Ізраіля і не зьнеслаўлялі сьвятое імя Маё ў тым, што яны Мне пасьвячаюць. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Скажы ім, каб ведалі пакаленьні вашыя: “Калі нехта з нашчадкаў вашых наблізіцца да рэчаў сьвятых, якія сыны Ізраіля пасьвячаюць ГОСПАДУ, а нячыстасьць ягоная на ім, такая душа будзе вынішчана спрад аблічча Майго. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ніводзін з насеньня Аарона, які пракажоны або мае выцёкі, ня будзе есьці сьвятых дароў, пакуль не ачысьціцца. І хто дакранецца да чаго нячыстага ад памёршага або ў каго здарыцца выцёк насеньня, ");
INSERT INTO bel_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","або хто дакранецца паўзуна, якім занячысьціцца, або чалавека, які зрабіў бы яго нячыстым нячыстасьцю сваёю, ");
INSERT INTO bel_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","душа, якая дакранецца гэтага, будзе нячыстай аж да вечара і ня будзе есьці сьвятых дароў, пакуль не абмые цела сваё ў вадзе. ");
INSERT INTO bel_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Пасьля заходу сонца будзе ён ачышчаны, і тады будзе есьці сьвятыя дары, бо яны ёсьць ежай ягонаю. ");
INSERT INTO bel_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ня будзе ён есьці падліны ані разьдзёртых жывёлаў, бо праз гэта станецца нячысты. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Няхай захоўваюць загады Мае, каб ня мелі грэху і каб не памерлі з прычыны таго, што зьняважаць іх. Я — ГОСПАД, Які асьвячаю іх. ");
INSERT INTO bel_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ніводзін чужынец ня будзе есьці сьвятых дароў; ані той, што жыве ў сьвятара, ані найміт ня будзе есьці сьвятых рэчаў. ");
INSERT INTO bel_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Калі ж сьвятар купіць нявольніка за грошы, той можа есьці сьвятое, таксама народжаныя ў доме ягоным могуць есьці хлеб ягоны. ");
INSERT INTO bel_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Калі б дачка сьвятара выйшла замуж за чужога чалавека, яна не павінна есьці гэтых сьвятых ахвяраваных дароў. ");
INSERT INTO bel_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Аднак, калі дачка сьвятара аўдавела або была кінута і, ня маючы дзяцей, вярнулася ў дом бацькі свайго, як у маладосьці сваёй, будзе жывіцца хлебам бацькі свайго. Але ні­хто чужы ня будзе есьці яго. ");
INSERT INTO bel_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Калі ж нехта несьвядома зьесьць сьвятое, дадасьць пятую частку яго вартасьці і аддасьць сьвятое сьвятару. ");
INSERT INTO bel_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Сьвятары ня будуць паганіць сьвятых дароў, якія сыны Ізраіля складаюць у ахвяру ГОСПАДУ, ");
INSERT INTO bel_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","і ня будуць сьцягваць на іх віну, калі будуць есьці сьвятыя рэчы. Я — ГОСПАД, Які асьвячаю іх”». ");
INSERT INTO bel_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Прамоў да Аарона, і да сыноў ягоных, і да ўсіх сыноў Ізраіля, і скажы ім: “Калі хто з дому Ізраіля або спаміж прыхадняў, якія ў Ізраілі, паводле шлюбаваньня або як дар дабраахвотны свой складае ахвяру сваю, якую прыносіць ГОСПАДУ на цэласпаленьне, ");
INSERT INTO bel_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","каб яна была прынятаю, мусяць прынесьці самца без заганы мужчынскага роду з валоў, бараноў ці козаў. ");
INSERT INTO bel_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ніякай жывёлы, якая мае загану, не складайце ў ахвяру, бо ня будзе яна прынятая. ");
INSERT INTO bel_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Калі хто захоча скласьці ГОСПАДУ ахвяру мірную, каб споўніць шлюбаваньне або як дар дабраахвотны, ці гэта з валоў, ці з авечак, няхай будзе яна без заганы, каб была прынятай. ");
INSERT INTO bel_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ня будзеце складаць ГОС­ПАДУ ў ахвяру жывёлаў сьляпых, скалечаных, кульгавых, апухлых, паршывых, у балячках. Ня будзеце такіх жывёлаў складаць на ахвярніку ў ахвяру агнявую для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Цяля або барана някшталтнага ці хворага можаш скласьці як ахвяру дабраахвотную, але як шлюбаваная ахвяра ня будзе прынятая. ");
INSERT INTO bel_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Жывёлу, у якой яечкі сьціснутыя, разьбітыя, вырваныя або выразаныя, не складайце ў ахвяру ГОСПАДУ. І ня будзеце такога рабіць у зямлі вашай, ");
INSERT INTO bel_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ані з рук чужынцаў ня будзеце складаць такіх жывёлаў як хлеб Богу вашаму, таму што гэты недахоп іхні ёсьць заганаю, і ня будуць яны прынятыя”». ");
INSERT INTO bel_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Калі народзіцца табе цяля, або ягня, або казляня, будзе яно сем дзён пры матцы. Пачынаючы ад восьмага дня і далей будзе яно прынятае як ахвяра агнявая для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Але ані каровы, ані авечкі не забівайце ў адзін дзень разам з іх малым. ");
INSERT INTO bel_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Калі складаеце ГОСПАДУ ахвяру падзякі, складайце яе так, каб была яна прынятай; ");
INSERT INTO bel_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","у той самы дзень зьешце яе; няхай не застаецца з яе нічога да раніцы другога дня. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Захоўвайце прыказаньні Мае і выконвайце іх. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Не паганьце імя Маё сьвятое, каб быў Я сьвятым паміж сыноў Ізраіля. Я — ГОСПАД, Які асьвячае вас ");
INSERT INTO bel_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","і Які вывеў вас з зямлі Эгіпецкай, каб быць Богам вашым. Я — ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Гэта сьвяты ГОСПАДА, у якія вы будзеце склікаць сходы сьвятыя; гэта сьвяты Мае. ");
INSERT INTO bel_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Шэсьць дзён будзеце працаваць, а сёмы дзень — супачынак супачынку, сход сьвяты, ня будзеце зусім працаваць, бо гэта супачынак ГОСПАДА ў-ва ўсіх сядзібах вашых. ");
INSERT INTO bel_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Вось сьвяты ГОСПАДА, сходы сьвятыя, якія павінны вы сьвяткаваць у свой час. ");
INSERT INTO bel_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","У першы месяц, у чатырнаццаты дзень месяца, вечарам Пасха ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","А ў пятнаццаты дзень таго самага месяца сьвята Праснакоў для ГОСПАДА. Сем дзён будзеце есьці праснакі. ");
INSERT INTO bel_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","У першы дзень будзе ў вас сход сьвяты; ня будзеце выконваць ніякай працы штодзённай, ");
INSERT INTO bel_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","але сем дзён будзеце скла­даць ГОСПАДУ ахвяры агнявыя. У сёмы ж дзень будзе сход сьвяты, ніякай працы што­дзённай ня будзеце рабіць”». ");
INSERT INTO bel_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Прамоў да сыноў Ізраіля і скажы ім: “Калі вы ўвойдзеце ў зямлю, якую Я дам вам, і будзеце жаць збожжа, прынясіце сьвятару першы сноп жніва вашага. ");
INSERT INTO bel_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ён патрасе сноп перад абліччам ГОСПАДА, каб Ён прыняў яго; у другі дзень пасьля суботы прынясе ён яго. ");
INSERT INTO bel_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","І ў той дзень, у якім будзеце патрэсваць сноп, складзіцё ў ахвяру цэласпаленьня ГОСПАДУ ягня аднагадовае без заганы, ");
INSERT INTO bel_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","і ахвяру хлебную з двух дзясятых эфы мукі, запраўленай алеем, як ахвяру агнявую на мілы пах ГОСПАДУ, і ахвяру вадкую, чвэрць гіна віна. ");
INSERT INTO bel_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Аж да гэтага дня ня будзеце есьці ані хлеба, ані пражанага зерня, ані сырога зерня, пакуль не складзеце дар Богу вашаму. Гэта пастанова вечная ўсім пакаленьням вашым у-ва ўсіх сядзібах вашых. ");
INSERT INTO bel_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Адлічыце сабе ад другога дня пасьля суботы, ад дня, у які прынесяцё снапы для патрэс­ваньня, сем поўных тыдняў, ");
INSERT INTO bel_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","аж да дня пасьля сёмай суботы адлічыце пяцьдзясят дзён, і тады складзіце новую ахвяру хлебную для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Прынясіце з сядзібаў вашых па два хлябы для патрэс­ваньня, кожны з двух дзясятых эфы мукі квашанай, якія будуць сьпечаныя як пяршыны ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Апрача хлеба складзіце ў ахвяру сем бараноў без заганы, аднагадовых, аднаго маладога бычка і двух бараноў. Яны будуць ахвяраю цэласпаленьня ГОСПАДУ разам з ахвяраю хлебнаю і з ахвяраю вадкай. Будзе гэта ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ахвяруйце таксама аднаго казла як ахвяру за грэх і двух ягнятаў аднагадовых як ахвяру мірную. ");
INSERT INTO bel_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Сьвятар патрасе іх перад ГОСПАДАМ разам з хлябамі пяршынаў і разам з двума ягнятамі; будзе гэта пасьвячоным для ГОСПАДА на ўжытак сьвятара. ");
INSERT INTO bel_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","У той самы дзень склічце сход, гэта будзе для вас сход сьвяты. Ніякай працы штодзённай ня будзеце рабіць. Гэта пастанова вечная на ўсякім месцы пражываньня вашага ў-ва ўсіх пакаленьнях вашых. ");
INSERT INTO bel_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Калі будзеце жаць у зямлі вашай, ня будзеш дажы­наць да мяжы поля твайго і ня бу­дзеш зьбіраць да рэшты каласоў на жніве тваім. Пакіньце іх убогім і прыхадням. Я — ГОСПАД, Бог ваш”». ");
INSERT INTO bel_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Прамоў да сыноў Ізраіля, кажучы: “У першы дзень сёмага месяца будзе ў вас супачынак, сход сьвяты пры гуку трубаў. ");
INSERT INTO bel_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ня будзеце рабіць аніякай працы штодзённай, але будзеце складаць ГОСПАДУ ахвяру агнявую”». ");
INSERT INTO bel_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Вось, у дзясяты дзень гэтага самага сёмага месяца будзе Дзень Перамольваньня, і будзе ў вас сход сьвяты. І бу­дзеце ўпакорваць душы вашыя і складаць ГОСПАДУ ахвяры агнявыя. ");
INSERT INTO bel_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ня будзеце рабіць у той дзень аніякай працы, бо гэта Дзень Перамольваньня, дзеля перамольваньня за вас перад абліччам ГОСПАДА, Бога вашага. ");
INSERT INTO bel_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Усякая душа, якая ня будзе ўпакорваць сябе ў той дзень, будзе вынішчана спасярод народу свайго. ");
INSERT INTO bel_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","І кожную душу, якая будзе рабіць працу ў той дзень, Я вынішчу спасярод народу яе. ");
INSERT INTO bel_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ніякай працы ня будзеце рабіць. Гэта пастанова вечная ў-ва ўсіх пакаленьнях вашых у-ва ўсіх сядзібах вашых. ");
INSERT INTO bel_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Гэта супачынак супачынкаў для вас. І будзеце ўпакорваць душы вашыя з вечара дзявятага дня месяца; з вечара да вечара дзясятага дня месяца будзеце сьвяткаваць суботу вашую». ");
INSERT INTO bel_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Прамоў да сыноў Ізраіля, кажучы: “У пятнаццаты дзень гэтага сёмага месяца сьвята Намётаў, сем дзён для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","У першы дзень — сход сьвяты; не рабіце ніякай працы штодзённай. ");
INSERT INTO bel_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Сем дзён складайце ахвяры агнявыя ГОСПАДУ. У восьмы дзень будзе ў вас сход сьвяты, і складзіце ахвяру агнявую ГОСПАДУ. Гэта ўрачысты сход, не рабіце ніякай працы штодзённай. ");
INSERT INTO bel_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Гэта сьвяты ГОСПАДА, у якія вы будзеце склікаць сходы сьвятыя, у якія будзеце складаць ахвяры агнявыя ГОСПАДУ: цэласпаленьні, ахвяры хлебныя, ахвяры крывавыя і ахвяры вадкія, кожную ў свой дзень, ");
INSERT INTO bel_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","апрача суботаў ГОСПАДАВЫХ і апрача дароў вашых, і апрача ўсяго, што будзеце ахвяроўваць паводле шлюбаваньня або дабраахвотна ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","У пятнаццаты дзень сёмага месяца, калі зьберыцё плады зямлі, будзеце сьвяткаваць урачыстасьць ГОСПАДА сем дзён; у першы дзень і ў восьмы будзе супачынак. ");
INSERT INTO bel_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","У першы дзень возьмеце сабе найпрыгажэйшыя плады дрэваў, лісты пальмавыя і галіны дрэваў густых і вербаў рачных, і будзеце весяліцца перад абліччам ГОСПАДА, Бога вашага, сем дзён. ");
INSERT INTO bel_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Будзеце сьвяткаваць гэтае сьвята штогод сем дзён. Гэта пастанова вечная для пакаленьняў вашых. У сёмы месяц будзеце сьвяткаваць гэтае сьвята. ");
INSERT INTO bel_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Сем дзён будзеце жыць у намётах. Кожны, хто з роду Ізраіля, будзе жыць у намёце, ");
INSERT INTO bel_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","каб памяталі пакаленьні вашыя, што загадаў Я сынам Ізраіля жыць у намётах, калі вывеў іх з зямлі Эгіпецкай. Я — ГОСПАД, Бог ваш!”» ");
INSERT INTO bel_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Гэта прамовіў Майсей да сыноў Ізраіля пра ўрачыстасьці ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Загадай сынам Ізраіля, каб прынесьлі табе для сьвечніка найчысьцейшага алею, выціснутага з алівак, празрыстага, каб гарэлі лямпы сьвечніка заўсёды. ");
INSERT INTO bel_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Прыгатуе яго Аарон за заслонай сьведчаньня ў Намёце Спатканьня, каб заўсёды ад вечара аж да раніцы гарэў перад абліччам ГОСПАДА. Гэта пастанова вечная для пакаленьняў вашых. ");
INSERT INTO bel_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Прыгатуе ён тыя лямпы на чыстым сьвечніку, каб гарэлі заўсёды перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Вазьмі таксама мукі і сьпячы з яе дванаццаць боханаў хлеба; у кожным бохане павінна быць дзьве дзясятых эфы. ");
INSERT INTO bel_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","І пакладзеш іх у два шэрагі, па шэсьць у кожным шэрагу, на чыстым стале перад абліччам ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","і пакладзеш на кожны шэраг найчысьцейшага кадзіла; гэта будзе памятная частка хлеба, ахвяра агнявая для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","У кожную суботу заўсёды будуць класьці іх перад абліччам ГОСПАДА як дар ад сыноў Ізраіля, як запавет вечны. ");
INSERT INTO bel_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Яны належаць Аарону і сынам ягоным, каб спажывалі іх у месцы сьвятым, бо гэта сьвятое сьвятых, гэта належыць яму спаміж ахвяраў агнявых для ГОСПАДА. Гэта пастанова вечная». ");
INSERT INTO bel_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","І выйшаў спаміж сыноў Ізраіля сын адной Ізраільцянкі, народжаны ад Эгіпцяніна. І ён пасварыўся ў табары з адным Ізраільцянінам, ");
INSERT INTO bel_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","і сын Ізраільцянкі блюзьніў супраць імя Госпада, і кляў Яго. І прывялі яго да Майсея. Імя маці ягонай — Шэляміт, дачка Дыбры, з калена Дана. ");
INSERT INTO bel_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Аддалі яго пад варту, пакуль ня высьветліцца, што прамовяць вусны ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Выведзі блюзьнерцу па-за табар, і ўсе, хто яго чуў, паложаць рукі свае на галаву ягоную, і ўся грамада ўкамянуе яго. ");
INSERT INTO bel_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","А да сыноў Ізраіля прамоў, кажучы: “Чалавек, які бу­дзе клясьці Бога свайго, панясе грэх свой. ");
INSERT INTO bel_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","І хто зблюзьніць супраць імя ГОСПАДА, сьмерцю памрэ. Уся грамада, камянуючы, укамянуе яго, ці ён будзе пры­ха­дзень, ці тутэйшы. Хто блюзьніць на імя ГОСПАДА, той сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Хто ўдарыць і заб’е душу чалавечую, сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Хто заб’е жывёлу, будзе абавязаны да звароту: жывёлу за жывёлу. ");
INSERT INTO bel_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Калі хто скалечыць бліжняга свайго, як ён зрабіў, так і яму зробяць. ");
INSERT INTO bel_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Пералом за пералом, вока за вока, зуб за зуб. У які спосаб ён скалечыў, такім чынам і ён будзе скалечаны. ");
INSERT INTO bel_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Хто заб’е жывёлу, аддасьць іншую жывёлу; хто заб’е чалавека, сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Роўны суд няхай будзе ў вас, ці для прыхадня, ці для тутэйшага. Бо Я — ГОСПАД, Бог ваш!”» ");
INSERT INTO bel_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","І прамовіў Майсей да сыноў Ізраіля, і вывелі блюзьнерцу па-за табар і ўкаменавалі яго камянямі. І сыны Ізраіля зрабілі так, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","І прамовіў ГОСПАД да Майсея на гары Сынай, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Калі вы ўвойдзеце ў зямлю, якую Я дам вам, зямля таксама павінна супачы­ваць у супачынкі ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Шэсьць гадоў будзеш засяваць поле сваё і шэсьць гадоў будзеш абразаць вінаграднік свой і зьбіраць з іх плады, ");
INSERT INTO bel_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","але ў сёмы год няхай будзе супачынак супачынкаў, для зямлі будзе супачынак ГОСПАДА. Ня будзеш засяваць поля твайго і падразаць вінаграднік твой. ");
INSERT INTO bel_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Таго, што само вырасьце на пожні тваёй, ня будзеш жаць, і ня будзеш зьбіраць вінаграду неабрэзанага. Гэта будзе год супачынку для зямлі. ");
INSERT INTO bel_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Што само вырасьце падчас супачынку зямлі, будзе вам на ежу, табе, слузе твайму, служцы тваёй, парабку твайму і пасяленцу твайму, які жыве ў цябе, ");
INSERT INTO bel_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","і жывёле тваёй, і зьвярам, якія жывуць на зямлі тваёй, увесь ураджай будзе на ежу. ");
INSERT INTO bel_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","І палічыш сем гадоў суботніх, сем разоў па сем гадоў, і будзе дзён сямі гадоў суботніх сорак дзевяць гадоў. ");
INSERT INTO bel_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","У дзясяты дзень сёмага месяца затрубіш у рог, у Дзень Перамольваньня няхай разыйдзецца гук рогу па ўсёй зямлі вашай. ");
INSERT INTO bel_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","І будзеце сьвяціць пяці­дзясяты год, і абвесьціце свабоду на зямлі ўсім жыхарам ейным. Гэта будзе для вас юбілей. Кожны з вас вернецца да уласнасьці сваёй, і кожны вернецца ў сям’ю сваю. ");
INSERT INTO bel_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Гэты пяцідзясяты год будзе для вас годам юбілейным; ня будзеце сеяць, ня будзеце жаць таго, што вырасьце, і ня будзеце зьбіраць неабрэзанага вінаграду, ");
INSERT INTO bel_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","бо гэта будзе для вас юбілей, гэта будзе для вас сьвяты час. Будзеце есьці тое, што вырасьце на полі. ");
INSERT INTO bel_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","У гэты год юбілейны кожны з вас вернецца да ўласнасьці сваёй. ");
INSERT INTO bel_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Калі што будзеш прадаваць бліжняму свайму або купляць з рукі бліжняга свайго, ня крыўдзіце адзін аднаго. ");
INSERT INTO bel_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Паводле ліку гадоў пасьля юбілею ты павінен купляць у бліжняга свайго, і паводле ліку гадоў ураджаю ён павінен прадаваць табе. ");
INSERT INTO bel_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Чым больш гадоў застаецца да юбілею, тым большую цану заплаціш; а чым менш гадоў застаецца, тым меншую цану заплаціш, бо колькасьць ураджаяў ён прадае табе. ");
INSERT INTO bel_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ня крыўдзіце адзін аднаго, але бойцеся Бога свайго, бо Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Выконвайце пастановы Мае і прысуды Мае захоўвайце і выконвайце іх, і будзеце жыць на зямлі гэтай у бясьпецы. ");
INSERT INTO bel_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","І будзе зямля даваць плод свой, і вы будзеце есьці ўдосталь, і будзеце жыць на зямлі ў бясьпецы. ");
INSERT INTO bel_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","А калі скажаце: “Што мы будзем есьці ў сёмым годзе, калі ня будзем ані сеяць, ані зьбі­раць ураджаю нашага?” ");
INSERT INTO bel_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Я спашлю на вас дабраславенства ў шостым годзе, і хо­піць вам ураджаю на тры гады. ");
INSERT INTO bel_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","У восьмым годзе будзеце сеяць і будзеце есьці са старога ўраджаю аж да дзявятага году, аж да новага ўраджаю будзеце есьці даўнія плады. ");
INSERT INTO bel_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Зямлю ня будзеце прада­ваць назаўсёды, бо Мая зямля, а вы — прыхадні і пасяленцы ў Мяне. ");
INSERT INTO bel_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Таму ўся зямля, якая ў валоданьні вашым, будзе прадавацца вамі пад умовай выкупу. ");
INSERT INTO bel_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Калі зьбяднее брат твой і прадасьць частку маёмасьці сваёй, няхай прыйдзе адкупіцель, сваяк ягоны, і выку­піць маёмасьць, прададзеную братам ягоным. ");
INSERT INTO bel_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Калі ж хто ня мае адкупіцеля, але рука ягоная знойдзе належныя сродкі на выкуп, ");
INSERT INTO bel_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","няхай падлічыць ён гады ад часу продажу і зьверне рэш­ту таму, каму прадаў зямлю, і вернецца да маёмасьці сваёй. ");
INSERT INTO bel_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Калі не здабудзе рука ягоная належных сродкаў на выкуп, маёмасьць застанецца ў валоданьні таго, хто купіў, аж да юбілейнага году. А ў юбілейны год яна выйдзе ад яго, і вернецца ранейшы ўладальнік да маёмасьці сваёй. ");
INSERT INTO bel_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Калі хто прадасьць дом жылы ў горадзе, які акружаны мурам, той будзе мець права выкупу аж да канца году продажу; столькі дзён будзе права выкупу. ");
INSERT INTO bel_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Калі дом ня выкупяць на працягу году, дом у горадзе, акружаным мурам, застанецца назаўсёды ўласнасьцю таго, хто купіў, і нашчадкаў яго. Ня выйдзе з рук іхніх у юбілейны год. ");
INSERT INTO bel_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","А дамы ў вёсках, якія не акружаныя мурам, бу­дуць лічыцца на роўні з зямлёю; будуць яны падлягаць выкупу, а ў юбілейным годзе выйдуць з валоданьня таго, хто купіў. ");
INSERT INTO bel_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Што да гарадоў лявітаў і дамоў у гарадах, якія яны маюць на ўласнасьць, дык лявіты заўсёды могуць выкупіць дамы свае. ");
INSERT INTO bel_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Калі хто купіць у лявітаў дом у горадзе, маёмасьць гэтая выйдзе з рук ягоных у юбілейным годзе, бо дамы лявітаў — гэта маёмасьць іхняя сярод сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Таксама палёў вакол гарадоў іхніх нельга прадаваць, бо гэта іх маёмасьць вечная. ");
INSERT INTO bel_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Калі брат твой зьбяднее і аслабее рука ягоная, ты падтрымай яго, каб ён мог жыць з табою як прыхадзень або пасяленец. ");
INSERT INTO bel_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Не бяры ад яго ані адсоткаў, ані ліхвы. Бойся Бога твайго, каб брат твой мог жыць у цябе. ");
INSERT INTO bel_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Не давай яму грошы твае на адсоткі і не вымагай ад яго ліхвы за ежу тваю. ");
INSERT INTO bel_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Я — ГОСПАД, Бог ваш, Які вывеў вас з зямлі Эгіпецкай, каб даць вам зямлю Ханаан і каб быць вашым Богам! ");
INSERT INTO bel_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Калі брат твой з убогасьці змушаны будзе прадацца табе, не прыціскай яго працаю нявольнічай, ");
INSERT INTO bel_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","але будзеш з ім абыходзіцца як з парабкам і пасяленцам. Будзе ён табе служыць да юбілейнага году, ");
INSERT INTO bel_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","а тады выйдзе ён, і сыны ягоныя з ім і вернецца да сям'і сваёй, і вернецца ў валоданьне бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Бо яны — нявольнікі Мае, якіх Я вывеў з зямлі Эгіпецкай; не павінны яны быць прадаваныя як нявольнікі. ");
INSERT INTO bel_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ня будзеш уціскаць іх сурова, але будзеш баяцца Бога твайго. ");
INSERT INTO bel_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Нявольнік твой або нявольніца твая няхай будуць купленыя ў народаў, якія вакол цябе, у іх купляй нявольніка і нявольніцу. ");
INSERT INTO bel_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Таксама купляйце дзяцей пасяленцаў, якія пасяліліся ў вас, і з сем’яў іхніх, якія жывуць у вас, і якія нарадзіліся ў зямлі вашай. Яны будуць уласнасьцю вашай, ");
INSERT INTO bel_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","і як спадчыну перадавайце іх сынам вашым, і мейце іх назаўсёды як нявольнікаў. Але над братамі сваімі, сынамі Ізраіля, не пануйце сурова. ");
INSERT INTO bel_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Калі прыхадзень або пасяленец твой разбагацее, а брат твой зьбяднее і прадасьць сябе прыхадню, які пасяліўся ў цябе, або нашчадку сям’і прыхадня, ");
INSERT INTO bel_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","пасьля продажу можа ён быць выкуплены. Няхай адзін з братоў ягоных выкупіць яго. ");
INSERT INTO bel_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Або дзядзька ягоны, або сын дзядзькі, або нехта са сваякоў з сям'і ягонай няхай выкупіць яго. Або калі знойдзе сілу рука ягоная, няхай выкупіць сам сябе. ");
INSERT INTO bel_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","І ён разьлічыцца з тым, хто купіў яго, пачынаючы з таго году, калі ён прадаў сябе, да юбілейнага году, і грошы, за якія ён прадаў сябе, належыць аддаць яму паводле ліку гадоў; як дні найміта, колькі ён павінен быць у яго. ");
INSERT INTO bel_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Калі да юбілейнага году застаецца шмат гадоў, адпаведна ліку іх няхай верне ён срэбра як выкуп свой. ");
INSERT INTO bel_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","А калі застаецца мала гадоў да юбілейнага году, ён палі­чыць іх і, адпаведна ліку тых гадоў, заплаціць выкуп свой. ");
INSERT INTO bel_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ён будзе ў прыхадня як найміт, з году на год. Няхай ён не ўціскае яго строга на вачах тваіх. ");
INSERT INTO bel_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Калі ж такім чынам выкупіцца ня зможа, у юбілейным годзе выйдзе вольны ён і сыны ягоныя з ім. ");
INSERT INTO bel_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Бо сыны Ізраіля — гэта нявольнікі Мае, якіх Я вывеў з зямлі Эгіпецкай. Я — ГОСПАД, Бог ваш! ");
INSERT INTO bel_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Не рабіце сабе ідалаў і выяваў, і не стаўляйце слупоў, і каменных фігураў не стаўляйце ў зямлі вашай, каб пакланяцца ім. Бо Я — ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Захоўвайце суботы Мае і шануйце сьвятыню Маю. Я — ГОСПАД! ");
INSERT INTO bel_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Калі будзеце хадзіць паводле пастановаў Маіх, і захоў­ваць прыказаньні Мае, і спаўняць іх, ");
INSERT INTO bel_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Я дам вам дажджы ў патрэбны час, і зямля будзе даваць ураджай, і дрэвы палявыя дадуць плады свае. ");
INSERT INTO bel_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","І малацьба хлеба працягне­ц­ца да збору вінаграду, а зьбі­раньне вінаграду працягнецца да сяўбы, і будзеце есьці хлеб ваш удосталь, і будзеце жыць у бясьпецы на зямлі сваёй. ");
INSERT INTO bel_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","І Я дам мір у зямлі вашай, і будзеце вы спаць, і ня бу­дзе каму вас палохаць. І Я прыбя­ру дзікіх зьвяроў з зямлі, і меч ня будзе праходзіць па зямлі вашай. ");
INSERT INTO bel_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Вы будзеце гнаць ворагаў вашых, і будуць яны падаць перад абліччам вашым ад мяча. ");
INSERT INTO bel_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Пяцёх з вас прагоняць сотню, і сотня з вас прагоніць дзесяць тысячаў. І будуць падаць ворагі вашыя перад абліччам вашым ад мяча. ");
INSERT INTO bel_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","І Я прыхілюся да вас, і дам вам плоднасьць, і вы памножыцеся; і Я заключу запавет Мой з вамі. ");
INSERT INTO bel_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","І вы будзеце есьці збожжа з леташніх збораў, а калі прыйдуць новыя зборы, павыкідаеце старыя. ");
INSERT INTO bel_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","І Я пастаўлю Сялібу Маю сярод вас, і ня будзе брыдзіцца вамі душа Мая. ");
INSERT INTO bel_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Я буду хадзіць сярод вас і буду Богам вашым, а вы будзеце народам Маім. ");
INSERT INTO bel_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Я — ГОСПАД, Бог ваш, Які вывеў вас з зямлі Эгіпецкай, каб вы не былі там нявольнікамі. Я зламаў ярмо вашае, каб хадзілі вы з узьнятымі галовамі. ");
INSERT INTO bel_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","А калі вы ня будзеце слу­хаць Мяне і ня будзеце выконваць усе гэтыя прыказаньні, ");
INSERT INTO bel_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","калі пагардзіце пастанова­мі Маімі, і ня будзеце зважаць на прысуды Мае, і ня будзеце вы­конваць усіх прыказаньняў Маіх, і будзеце парушаць запавет Мой, ");
INSERT INTO bel_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","тады Я гэтак зраблю вам, і наведаю вас жахам раптоўным, сухотамі і гарачкай, якія спрычыняюць сьлепату і нішчаць здароўе. Дарэмна будзеце сеяць насеньне вашае, бо зьядуць яго ворагі вашыя. ");
INSERT INTO bel_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","І Я зьвярну аблічча Маё супраць вас, і будзеце вы падаць перад абліччам ворагаў вашых, і будуць панаваць над вамі тыя, якія вас ненавідзяць, і будзеце вы ўцякаць, хоць ніхто ня бу­дзе гнацца за вамі. ");
INSERT INTO bel_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","А калі і тады ня будзеце слухаць Мяне, Я павялічу кары на вас за грахі вашыя ў сем разоў, ");
INSERT INTO bel_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","і зьнішчу пыхлівасьць сілы вашай, і зраблю для вас неба як жалеза, а зямлю — як медзь. ");
INSERT INTO bel_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Дарэмна будзе марнавацца праца вашая, і зямля вашая ня будзе даваць ураджаю свайго, а дрэвы палявыя не дадуць пладоў сваіх. ");
INSERT INTO bel_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Калі і далей будзеце Мне працівіцца і не захочаце слухаць Мяне, Я павялічу кары на вас за грахі вашыя ў сем разоў. ");
INSERT INTO bel_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Я напушчу на вас зьвяроў палявых, якія пазбавяць вас дзяцей і зьнішчаць жывёлу вашую, і зьменшаць вас; і пустымі стануцца шляхі вашыя. ");
INSERT INTO bel_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Калі і далей ня будзеце навучаныя Мною і будзеце працівіцца Мне, ");
INSERT INTO bel_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Я таксама пайду супраць вас, і буду вас караць у сем разоў цяжэй за грахі вашыя. ");
INSERT INTO bel_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Я навяду на вас меч, мсьці­ўцу за парушэньне запавету. А калі паўцякаеце ў гарады вашыя, Я пашлю заразу на вас, і будзеце выдадзеныя ў рукі ворагаў. ");
INSERT INTO bel_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Калі Я зьнішчу вашую падпору хлебную, тады пекчы будуць дзесяць жанчынаў хлеб сабе ў адной печцы і будуць выдаваць пад мерку, і вы будзеце есьці, і не насыціцеся! ");
INSERT INTO bel_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","А калі тады ня будзеце слухаць Мяне і будзеце працівіцца Мне, ");
INSERT INTO bel_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Я выступлю супраць вас з гвалтоўнай ярасьцю; і Я пакараю вас сямікроць за грахі вашыя, ");
INSERT INTO bel_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","і вы будзеце есьці целы сыноў вашых і дачок вашых. ");
INSERT INTO bel_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","і Я зруйную ўзгоркі ва­шыя, і паб’ю слупы вашыя, і кі­ну трупы вашыя на ідалаў ва­шых, і будзе брыдзіцца душа Мая вамі. ");
INSERT INTO bel_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Гарады вашыя зраблю руінамі, і спустошу сьвятыні вашыя, і не прыйму больш паху ахвяраў вашых. ");
INSERT INTO bel_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","І Я спустошу зямлю гэтую, аж будуць дзівіцца ворагі вашыя, якія заселяць яе. ");
INSERT INTO bel_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","А вас Я расьцярушу між народамі і пушчу меч усьлед за вамі; і будзе зямля вашая пусткаю, а гарады вашыя будуць руінамі. ");
INSERT INTO bel_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Тады зямля будзе адзначаць суботы свае ўсе дні спусташэньня свайго, а вы бу­дзеце ў зямлі ворагаў вашых. Тады зямля будзе адпачываць і сьвяткаваць суботы свае. ");
INSERT INTO bel_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Усе дні спусташэньня свайго будзе яна адпачываць, бо не адпачывала ў гады суботнія, калі вы ў ёй жылі. ");
INSERT INTO bel_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","А для тых, хто з вас застанецца, Я спашлю страх у сэрцы іхнія ў зямлі ворагаў іхніх. Будзе палохаць іх шум лістка, што ляціць, і будуць уцякаць, як ад мяча; і хоць ніхто ня будзе за імі гнацца, і будуць падаць. ");
INSERT INTO bel_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","І будуць спатыкацца адзін аб другога, быццам ад мяча, хоць ніхто ня будзе гнацца за імі. Ня зможаце вы ўстаяць перад абліччам ворагаў вашых. ");
INSERT INTO bel_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","І вы загінеце паміж народамі, і праглыне вас зямля ворагаў вашых! ");
INSERT INTO bel_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","А тыя, хто з вас застануцца, будуць марнець у беззаконьнях сваіх у землях ворагаў сваіх, і за беззаконьні бацькоў сваіх змарнеюць, як і яны. ");
INSERT INTO bel_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","І прызнаюць яны беззаконьні свае і беззаконьні бацькоў сваіх, здраду, якой здрадзілі Мне і працівіліся Мне. ");
INSERT INTO bel_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Таму Я выйшаў супраць іх і ўвёў іх у зямлю ворагаў іхніх, каб упакорылася неабразанае сэрца іхняе, і каб яны панесьлі кару за беззаконьні свае. ");
INSERT INTO bel_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","І Я ўзгадаю запавет Мой з Якубам, і запавет Мой з Ісаакам, і запавет Мой з Абрагамам. І Я ўзгадаю зямлю гэтую. ");
INSERT INTO bel_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Зямля гэтая была пакінутая імі; і будзе яна сплочваць суботы свае праз тое, што будзе спустошана за правіны іх, а яны будуць несьці кару за беззаконьні свае, бо адкінулі прысуды Мае і брыдзілася душа іхняя пастановамі Маімі. ");
INSERT INTO bel_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Але і тады, калі яны бу­дуць у зямлі ворагаў іхніх, Я не адкіну іх зусім і ня буду брыдзіцца імі так, каб цалкам іх зьнішчыць і зламаць запавет Мой з імі, бо Я — ГОСПАД, Бог іхні. ");
INSERT INTO bel_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","І Я прыгадаю ім запавет Мой з продкамі іхнімі, якіх Я вывеў з зямлі Эгіпецкай на вачах народаў, каб быць іх Богам. Я — ГОСПАД!» ");
INSERT INTO bel_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Гэта пастановы, прысуды і законы, якія даў ГОСПАД на гары Сынай адносна Сябе і сыноў Ізраіля у рукі Майсея. ");
INSERT INTO bel_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Калі які чалавек дае шлюбаваньне пасьвяціць душу ГОСПАДУ паводле ацэнкі тваёй, ");
INSERT INTO bel_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","калі гэта будзе мужчына ад дваццаці да шасьцідзесяці гадоў, ён будзе ацэнены ў пяцьдзясят сыкляў срэбра паводле сыкля сьвятыні, ");
INSERT INTO bel_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","а калі жанчына, яна будзе ацэнена ў трыццаць сыкляў. ");
INSERT INTO bel_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","А калі яму ад пяці гадоў да дваццаці будзе ацэнка твая за мужчыну — дваццаць сык­ляў, а за жанчыну — дзесяць сыкляў. ");
INSERT INTO bel_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","А калі яму ад аднаго месяца да пяці гадоў, будзе ацэнка твая за мужчыну пяць сыкляў, а за жанчыну — тры сыклі. ");
INSERT INTO bel_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","А калі яму ад шасьцідзесяці гадоў і вышэй, будзе ацэнка твая за мужчыну пятнаццаць сыкляў, а за жанчыну — дзе­сяць сыкляў. ");
INSERT INTO bel_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","А калі хто такі бедны, каб заплаціць ацэнку тваю, няхай паставяць яго перад абліччам сьвятара, і ацэніць яго сьвятар паводле таго, што можа даць рука яго, і няхай тое дасьць. ");
INSERT INTO bel_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Калі гэта будзе быдла, якое складаецца ў ахвяру ГОСПАДУ, тады ўсё, што шлюбаваў для ГОСПАДА, ёсьць сьвятым. ");
INSERT INTO bel_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Нельга яго замяніць, ані лепшае — горшым, ані горшае — лепшым. А калі хто заменіць быдла на быдла, і тое, што заменена, і на што заменена, будзе сьвятым для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","А калі гэта будзе жывёла нячыстая, якой нельга скла­даць у ахвяру ГОСПАДУ, няхай паставяць яе перад абліччам сьвятара, ");
INSERT INTO bel_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","і сьвятар ацэніць яе, ці яна добрая, ці благая, і як ацэніць яе сьвятар, так і будзе. ");
INSERT INTO bel_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Калі хто захоча выкупіць яе, няхай дадасьць пятую частку да ацэнкі яго. ");
INSERT INTO bel_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Калі хто пасьвяціць дом свой ГОСПАДУ як сьвятую рэч, тады сьвятар ацэніць той дом, ці ён добры, ці благі. Як сьвятар ацэніць яго, так і будзе. ");
INSERT INTO bel_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","А калі той, хто пасьвяціў яго, захоча выкупіць дом свой, няхай дадасьць пятую частку кошту яго, і будзе яго. ");
INSERT INTO bel_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Калі хто пасьвяціць ГОСПАДУ частку поля ўласнасьці сваёй, ацэнка твая павінна быць паводле зерня на засеў: за засеў гомару ячменя — пяць­дзясят сыкляў срэбра. ");
INSERT INTO bel_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Калі хто пасьвяціць поле сваё ў год юбілейны, твая ацэнка будзе важная. ");
INSERT INTO bel_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Калі ж хто пасьвяціць зямлю сваю пасьля году юбілейнага, тады сьвятар палічыць срэбра паводле гадоў, якія застаюцца да наступнага году юбілейнага, і зьменшыць ацэнку. ");
INSERT INTO bel_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Калі той, хто пасьвяціў поле, хоча выкупіць яго, няхай дадасьць пятую частку вышэй ацэнкі тваёй, і будзе яго. ");
INSERT INTO bel_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","А калі ён ня выкупіць поля, і калі гэтае поле бу­дзе прададзена некаму іншаму, яно ня можа быць выкупленае. ");
INSERT INTO bel_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","І станецца поле гэтае ў го­дзе юбілейным свабодным, сьвятым для ГОСПАДА, як поле пад закляцьцем. Станецца яно ўласнасьцю сьвятара. ");
INSERT INTO bel_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","А калі хто пасьвяціць ГОСПАДУ поле набытае, якое не з уласнасьці ягонай, ");
INSERT INTO bel_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","тады сьвятар палі­чыць вялікасьць ацэнкі тваёй да юбілейнага году, і павінен ён аддаць у той самы дзень ГОСПАДУ кошт ацэнкі тваёй як сьвятыню. ");
INSERT INTO bel_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","У год юбілейны зямля вернецца да таго, ад каго была куплена, чыёй была ўласнасьцю. ");
INSERT INTO bel_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Кожная ацэнка твая павінна быць паводле сыклю сьвятыні. Адзін сыкль будзе дваццаць гераў. ");
INSERT INTO bel_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Першароднае з быдла, якое першароднае для ГОСПАДА, ці то вол, ці то баран, ніхто ня можа пасьвяціць Госпаду, бо яны — ГОСПАДАВЫ. ");
INSERT INTO bel_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Калі гэта жывёла нячыстая, можна яе выкупіць паводле ацэнкі тваёй, дадаючы да яе адну пятую. Калі ня будзе выкуплена, будзе прададзена паводле ацэнкі тваёй. ");
INSERT INTO bel_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Калі хто пасьвяціць штосьці з уласнасьці сваёй ГОСПАДУ як заклятае: чалавека, жывёлу або поле ўласнасьці сваёй, ня будзе гэта ані прададзена, ані выкуплена. Кожная рэч заклятая — гэта сьвятое сьвятых для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ніводзін чалавек, які пасьвячоны ГОСПАДУ як закляцьце, ня можа быць выкуплены, але сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Кожная дзесяціна зямлі з пасеву зямлі і з пладоў дрэваў належыць ГОСПАДУ, гэта сьвятое для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Калі б хто хацеў выкупіць частку дзесяціны сваёй, няхай дадасьць да яе адну пятую. ");
INSERT INTO bel_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Кожная дзесяціна з валоў і авечак, усё дзясятае, што праходзіць пад кіем пастуха, пасьвячона ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ня будзе адрозьнівацца, што добрае, а што благое, і ня будзе рабіцца ніякай заме­ны. Калі хто зробіць замену, абедзьве жывёлы будуць пасьвячоныя ГОСПАДУ. Ня будуць яны выкупленыя». ");
INSERT INTO bel_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Гэта прыказаньні, якія даў ГОСПАД Майсею для сыноў Ізраіля на гары Сынай.");
INSERT INTO bel_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1"," І прамовіў ГОСПАД да Майсея ў пустыні Сынай у Намёце Спатканьня ў першы дзень другога месяца, у другім годзе пасьля выхаду з Эгіпту, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Пералічыце ўсю грамаду сыноў Ізраіля паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, усіх мужчынаў паводле імёнаў па галовах. ");
INSERT INTO bel_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ад дваццаці гадоў і вышэй, усіх здатных да бою ў Ізраілі палічыце паводле дружынаў іхніх ты і Аарон. ");
INSERT INTO bel_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","З кожнага пакаленьня павінен быць з вамі чалавек, князь роду бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Вось імёны тых мужоў, якія будуць з вамі: для Рубэна — Эліцур, сын Шэдэура, ");
INSERT INTO bel_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","для Сымона — Шэлюміэль, сын Цурышадая, ");
INSERT INTO bel_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","для Юды — Нахшон, сын Амінадава, ");
INSERT INTO bel_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","для Ісахара — Натанаэль, сын Цуара, ");
INSERT INTO bel_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","для Завулёна — Эліяў, сын Гэлёна, ");
INSERT INTO bel_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","для сыноў Язэпа: для Эфраіма — Элішама, сын Амігуда; для Манасы — Гамаліэль, сын Пэдагсура; ");
INSERT INTO bel_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","для Бэн’яміна — Абідан, сын Гідэоні, ");
INSERT INTO bel_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","для Дана — Ахіезэр, сын Амішадая, ");
INSERT INTO bel_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","для Асэра — Пагіэль, сын Акрана, ");
INSERT INTO bel_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","для Гада — Эліясаф, сын Дэўэля, ");
INSERT INTO bel_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","для Нэфталі — Ахіра, сын Энана». ");
INSERT INTO bel_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Гэтыя пакліканыя з усёй грамады, князі пакаленьняў бацькоў сваіх і начальнікі тысячаў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Іх узяў Майсей і Аарон, тых мужоў, якія былі паіменна названыя. ");
INSERT INTO bel_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","У першы дзень другога месяца сабралі яны ўсю грамаду дзеля сьпісу іх паходжаньня паводле сем'яў іхніх, паводле дамоў бацькоў іхніх і лічылі кожнага па імені ад дваццаці гадоў і вышэй. ");
INSERT INTO bel_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Як загадаў ГОСПАД Майсею, быў зроблены перапіс у пустыні Сынай. ");
INSERT INTO bel_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Сыноў Рубэна, першароднага Ізраіля, паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, усіх мужчынаў ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","тых, якіх палічылі з пакаленьня Рубэна, было сорак шэсьць тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Сыноў Сымона паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, усіх мужчынаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","тых, якіх палічылі з пака­леньня Сымона, было пяць­дзясят дзевяць тысячаў трыста. ");
INSERT INTO bel_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Сыноў Гада паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, усіх мужчынаў ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","тых, якіх палічылі з пакаленьня Гада, было сорак пяць тысячаў шэсьцьсот пяцьдзясят. ");
INSERT INTO bel_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Сыноў Юды паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, усіх мужчынаў ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","тых, якіх палічылі з пакаленьня Юды, было семдзясят чатыры тысячы шэсьцьсот. ");
INSERT INTO bel_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Сыноў Ісахара паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","тых, якіх палічылі з пакаленьня Ісахара, было пяцьдзясят чатыры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Сыноў Завулёна паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","тых, якіх палічылі з пакаленьня Завулёна, было пяць­дзясят сем тысячаў чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Сыноў Язэпа, сыноў Эфраіма паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","тых, якіх палічылі з пакаленьня Эфраіма, было сорак тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Сыноў Манасы паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","тых, якіх палічылі з пакаленьня Манасы, было трыц­цаць дзьве тысячы дзьвесьце. ");
INSERT INTO bel_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Сыноў Бэн’яміна паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","тых, якіх палічылі з пакаленьня Бэн’яміна, было трыццаць пяць тысячаў чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Сыноў Дана паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","тых, якіх палічылі з пакаленьня Дана, было шэсьцьдзясят дзьве тысячы семсот. ");
INSERT INTO bel_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Сыноў Асэра паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","тых, якіх палічылі з пакаленьня Асэра, было сорак адна тысяча пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Сыноў Нэфталі паводле радаводу іхняга, паводле сем'яў іхніх, паводле дамоў бацькоў іхніх, па ліку імёнаў, ад дваццаці гадоў і вышэй, усіх, здольных да бою, ");
INSERT INTO bel_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","тых, якіх палічылі з пакаленьня Нэфталі, было пяцьдзясят тры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Гэта палічаныя, якіх палічылі Майсей і Аарон, і князі Ізраіля, дванаццаць мужоў, па адным з кожнага дому бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","І было ўсіх палічаных сыноў Ізраіля паводле дамоў бацькоў іхніх, ад дваццаці гадоў і вышэй, усіх, здольных да бою ў Ізраілі, ");
INSERT INTO bel_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","шэсьцьсот тры тысячы пяцьсот пяцьдзясят. ");
INSERT INTO bel_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Лявіты паводле пакаленьняў бацькоў сваіх не былі палічаны сярод іх, ");
INSERT INTO bel_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","бо ГОСПАД прамовіў да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Не перапісвай пакаленьня Левія і не лічы іх разам з сынамі Ізраіля, ");
INSERT INTO bel_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","але даручы лявітам Сялібу Сьведчаньня, усе прылады яе і ўсё, што да яе належыць. Яны будуць насіць Сялібу і ўсе прылады яе, будуць пры ёй служыць і вакол Сялібы разложаць табар свой. ");
INSERT INTO bel_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Калі трэба рушыць Сялібе ў дарогу, разьбяруць яе лявіты, а калі трэба затрымацца Сялібе, паставяць яе лявіты. Калі нехта чужы наблізіцца да яе, будзе забіты. ");
INSERT INTO bel_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Сыны Ізраіля разложацца табарам, кожны на месцы сваім, кожны пад сьцягам сваім, паводле дружынаў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","А лявіты разложацца табарам вакол Сялібы Сьведчаньня; і кара не спадзе на грамаду сыноў Ізраіля. Лявіты будуць вартаваць каля Сялібы Сьведчаньня». ");
INSERT INTO bel_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","І зрабілі сыны Ізраіля ўсё; як ГОСПАД загадаў Майсею, так і зрабілі. ");
INSERT INTO bel_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Няхай сыны Ізраіля разложаць табар, кожны пад сьця­гам сваім, пад знакамі паводле дамоў бацькоў сваіх. Вакол Намёту Спатканьня на адлегласьці разложаць яны табар. ");
INSERT INTO bel_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Разложыць табар з усходу, дзе ўзыходзіць сонца, сьцяг табару Юды з дружынамі сваімі, а князем сыноў Юды будзе Нахшон, сын Амінадава. ");
INSERT INTO bel_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Лік войска ягонага, паводле падліку, — семдзясят чатыры тысячы шэсьцьсот. ");
INSERT INTO bel_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Побач іх разложыцца табар пакаленьня Ісахара, а князем сыноў Ісахара будзе Натанаэль, сын Цуара. ");
INSERT INTO bel_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Лік войска ягонага, паводле падліку, — пяцьдзясят чатыры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Потым пакаленьне Завулёна, а князем сыноў Завулёна будзе Эліяў, сын Хэлёна. ");
INSERT INTO bel_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Лік войска ягонага, паводле падліку, — пяцьдзясят сем тысячаў чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Усіх, палічаных у табары Юды паводле дружынаў іхніх, — сто восемдзясят шэсьць тысячаў чатырыста. Яны першыя будуць выходзіць. ");
INSERT INTO bel_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","З поўдня будзе сьцяг табару Рубэна з дружынамі сваімі, а князем сыноў Рубэна будзе Эліцур, сын Шэдэура. ");
INSERT INTO bel_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Лік войска ягонага, паводле падліку, — сорак шэсьць тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Побач іх разложыцца табар пакаленьня Сымона, а князем сыноў Сымона будзе Шэлюміэль, сын Цурышадая. ");
INSERT INTO bel_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Лік войска ягонага, паводле падліку, — пяцьдзясят дзевяць тысячаў трыста. ");
INSERT INTO bel_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Пасьля пакаленьне Гада, а князем сыноў Гада будзе Эліясаф, сын Дэўэля. ");
INSERT INTO bel_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Лік войска ягонага, паводле падліку, — сорак пяць тысячаў шэсьцьсот пяцьдзясят. ");
INSERT INTO bel_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Усіх, палічаных у табары Рубэна паводле дружынаў сваіх, — сто пяцьдзясят адна тысяча чатырыста пяцьдзясят. Яны другімі будуць выходзіць. ");
INSERT INTO bel_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Пасля вырушыць Намёт Спатканьня і табар лявітаў у сярэдзіне другіх табараў. Паводле таго, як раскладаліся табарам, так і выходзіць будуць, кожны на месцы сваім, пад сьцягам сваім. ");
INSERT INTO bel_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","З захаду будзе сьцяг табару Эфраіма з дружынамі сваімі, а князем сыноў Эфраіма будзеЭлішама, сын Амігуда. ");
INSERT INTO bel_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Лік войска ягонага, паводле падліку, — сорак тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Побач іх пакаленьне Манасы; а князем сыноў Манасы будзе Гамаліэль, сын Пэдагсура. ");
INSERT INTO bel_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Лік войска ягонага, паводле падліку, — трыццаць дзьве тысячы дзьвесьце. ");
INSERT INTO bel_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Потым пакаленьне Бэн’­яміна; а князем сыноў Бэн’яміна будзе Абідан, сын Гідэоні. ");
INSERT INTO bel_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Лік войска ягонага, паводле падліку, — трыццаць пяць тысячаў чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Усіх, палічаных у табары Эфраіма паводле дружынаў іхніх, — сто восем тысячаў сто. Яны трэція будуць выходзіць. ");
INSERT INTO bel_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","З поўначы будзе сьцяг табару Дана з дружынамі сваімі, а князем сыноў Дана будзеАхіезэр, сын Амішадая. ");
INSERT INTO bel_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Лік войска ягонага, паводле падліку, — шэсьцьдзясят дзьве тысячы семсот. ");
INSERT INTO bel_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Побач іх разложыцца табарам пакаленьне Асэра, а князем сыноў Асэра будзе Пагіэль, сын Акрана. ");
INSERT INTO bel_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Лік войска ягонага, паводле падліку, — сорак адна тысяча пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Потым пакаленьне Нэфталі, а князем сыноў Нэфталі будзе Ахіра, сын Энана. ");
INSERT INTO bel_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Лік войска ягонага, паводле падліку, — пяцьдзясят тры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Усіх, палічаных у табары Дана, — сто пяцьдзясят сем тысячаў шэсьцьсот. Яны як апошнія будуць выходзіць пад сьцягамі сваімі. ");
INSERT INTO bel_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Гэта палічаныя сыны Ізраіля паводле дамоў бацькоў сваіх. Усіх, палічаных у табары паводле дружынаў сваіх, — шэсьцьсот тры тысячы пяцьсот пяцьдзясят. ");
INSERT INTO bel_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Лявіты не былі палічаныя сярод сыноў Ізраіля, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Сыны Ізраіля зрабілі ўсё, што загадаў ГОСПАД Майсею: раскладаліся табарам пад сьцягамі сваімі і выходзілі паводле сем'яў сваіх і дамоў бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Вось такі радавод Аарона і Майсея ў дні, калі прамаўляў ГОСПАД да Майсея на гары Сынай. ");
INSERT INTO bel_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Вось гэта імёны сыноў Аарона: першародны Надаў, Абігу, Элеазар і Ітамар. ");
INSERT INTO bel_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Вось гэта імёны сыноў Аарона, памазаных сьвятароў, якім напоўнілі рукі іхнія, каб былі сьвятарамі. ");
INSERT INTO bel_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Але Надаў і Абігу памерлі перад абліччам ГОСПАДА ў пустыні Сынай, калі наблізіліся з чужым агнём перад аблічча ГОСПАДА, і не было ў іх сыноў. І былі сьвятарамі Элеазар і Ітамар перад абліччам Аарона, бацькі свайго. ");
INSERT INTO bel_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Прывядзі пакаленьне Ле­вія, і пастаў яго перад абліччам Аарона сьвятара, і няхай яны паслугуюць яму. ");
INSERT INTO bel_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Няхай захоўваюць усё, што пад вартай яго і пад вартай ўсёй грамады адносна Намёту Спатканьня, каб выконваць службу пры Сялібе, ");
INSERT INTO bel_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","і няхай захоўваюць усе прыналежнасьці Намёту Спатканьня, спаўняючы абавязкі сыноў Ізраіля, каб выконваць службу пры Сялібе. ");
INSERT INTO bel_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Аддай лявітаў Аарону і сынам ягоным, няхай яны будуць дадзеныя яму з сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","А Аарона і сыноў ягоных пастаў, каб яны захоўвалі службу сьвятарскую. А калі нехта чужы наблізіцца да службы, мае памерці». ");
INSERT INTO bel_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Вось, Я ўзяў лявітаў спасярод сыноў Ізраіля замест усіх першародных, якія адчыня­юць улоньне, і лявіты будуць Маімі. ");
INSERT INTO bel_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Бо Мой кожны першародны. У той дзень, калі ў зямлі Эгіпецкай Я выбіў усё першароднае, Я пасьвяціў для Сябе ўсё першароднае ў Ізраілі, ад чалавека аж да жывёлы. Яны Мае! Я — ГОСПАД!» ");
INSERT INTO bel_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","І прамовіў ГОСПАД да Май­сея ў пустыні Сынай, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Палічы сыноў Левія паводле дамоў бацькоў іхніх, і паводле сем’яў іхніх, усіх мужчынскага роду ад аднаго месяца і вышэй». ");
INSERT INTO bel_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","І палічыў іх Майсей паводле слова з вуснаў ГОСПАДА, як Ён загадаў яму. ");
INSERT INTO bel_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","І вось імёны сыноў Левія: Гершон, Кегат і Мэрары. ");
INSERT INTO bel_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","А вось імёны сыноў Гершона паводле сем’яў іхніх: Лібні і Шымэй. ");
INSERT INTO bel_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Сыны Кегата паводле сем’яў іхніх: Амрам, Іцгар, Хеўрон і Узіэль. ");
INSERT INTO bel_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Сыны Мэрары паводле сем’яў іхніх: Махлі і Мушы. Вось гэта сем'і Левія паводле дамоў бацькоў іхніх. ");
INSERT INTO bel_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ад Гершона паходзяць сям’я Лібні і сям’я Шымэя. Гэта сем’і Гершона ");
INSERT INTO bel_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Лік палічаных мужчынаў ад аднаго месяца і вышэй — сем тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Сем’і Гершона разложацца табарам за Сялібай з захаду. ");
INSERT INTO bel_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Князем дому бацькоў Гершона быў Эліясаф, сын Ляэля. ");
INSERT INTO bel_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Сынам Гершона ў Намёце Спатканьня даручана Сяліба, Намёт і пакрыцьцё ягонае, заслона пры ўваходзе ў Намёт Спатканьня, ");
INSERT INTO bel_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","заслоны панадворку, заслона пры выхадзе на панадворак, які пры Сялібе і ахвярніку, і вяроўкі, патрэбныя для ўсялякай службы. ");
INSERT INTO bel_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ад Кегата паходзяць сем’і Амрама, Іцгара, Хеўрона і Узіэля. Гэта сем’і Кегата. ");
INSERT INTO bel_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Лік усіх мужчынаў ад аднаго месяца і вышэй — восем тысячаў шэсьцьсот. Яны ма­юць вартаваць Сялібу. ");
INSERT INTO bel_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Сем’і сыноў Кегата разложацца табарам з паўднёвага боку Сялібы. ");
INSERT INTO bel_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Князем дому бацькоў Кегата быў Эліцафан, сын Узіэля. ");
INSERT INTO bel_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Яны мелі рупіцца пра каўчэг, стол, сьвечнік, ахвярнікі, пра прылады сьвятыні, прызначаныя для служэньня, пра заслону і абслугу яе. ");
INSERT INTO bel_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","А князем князёў лявітаў быў Элеазар, сын Аарона сьвятара. Ён наглядаў за тымі, што спаўнялі служэньне ў сьвятыні. ");
INSERT INTO bel_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ад Мэрары паходзяць сем’і Махлі і Мушы. Гэта сем’і Мэрары. ");
INSERT INTO bel_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Лік палічаных мужчынаў ад аднаго месяца і вышэй — шэсьць тысячаў дзьвесьце. ");
INSERT INTO bel_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","А князем дамоў бацькоў Мэрары быў Цурыэль, сын Абігаіля. Яны разложацца табарам з паўночнага боку Сялібы. ");
INSERT INTO bel_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Сынам Мэрары даручаны былі дошкі Сялібы, жэрдкі іхнія, слупкі, падставы і ўсе рэчы для абслугі яе, ");
INSERT INTO bel_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","і слупкі панадворку з усіх бакоў, і падставы іхнія, і колцы іхнія з вяроўкамі іхнімі. ");
INSERT INTO bel_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","А з пярэдняга боку Сялібы, з усходу, перад Намётам Спатканьня разложацца табарам Майсей, і Аарон, і сыны ягоныя, якім даручана Сяліба ад імя сыноў Ізраіля. Калі хто наблізіцца чужы, будзе забіты. ");
INSERT INTO bel_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Поўны лік лявітаў, якіх палічылі Майсей і Аарон паводле слова з вуснаў ГОСПАДА, усіх мужчынаў ад аднаго месяца і вышэй — дваццаць дзьве тысячы. ");
INSERT INTO bel_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","І сказаў ГОСПАД Майсею: «Падлічы ўсіх першародных мужчынаў сыноў Ізраіля ад аднаго месяца і вышэй, і палічы іх паіменна, ");
INSERT INTO bel_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","і вазьмі лявітаў для Мяне як замену ўсіх першародных сярод сыноў Ізраіля. Я — ГОСПАД. І вазьмі жывёлу лявітаў замест усёй першароднай жывёлы сыноў Ізраіля». ");
INSERT INTO bel_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","І палічыў Майсей, як загадаў яму ГОСПАД, усіх першародных сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","І было ўсіх першародных мужчынаў па ліку імёнаў, ад аднаго месяца і вышэй, паводле падліку — дваццаць дзьве тысячы дзьвесьце семдзясят тры. ");
INSERT INTO bel_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Вазьмі лявітаў замест усіх першародных сыноў Ізраіля і жывёлу лявітаў замест жывёлы іхняй. І лявіты будуць Маімі. Я — ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Як выкуп за гэтых дзьвесьце семдзясят трох з першародных сыноў Ізраіля, што перавышаюць лік лявітаў, ");
INSERT INTO bel_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","вазьмі па пяць сыкляў ад галавы, паводле сыкля сьвятыні; сыкль мае дваццаць гераў. ");
INSERT INTO bel_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","І дасі срэбра Аарону і сынам ягоным як выкуп за тых, што перавышаюць лік». ");
INSERT INTO bel_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","І ўзяў Майсей срэбра выкупу за тых, што перавышалі лік выкупленых лявітамі. ");
INSERT INTO bel_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ад першародных сыноў Ізраіля атрымаў Майсей срэбра тысячу трыста шэсьцьдзясят пяць сыкляў паводле сыкля сьвятыні. ");
INSERT INTO bel_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","І аддаў Майсей срэбра выкупу Аарону і сынам ягоным паводле слова з вуснаў ГОСПАДА, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Аддзялі спаміж сыноў Левія сыноў Кегата, паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ад трыццаці гадоў і да пяцідзесяці гадоў, усіх, здольных да службы, каб выконвалі работу ў Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Гэта вось служба сыноў Кегата ў Намёце Спатканьня — насіць сьвятое сьвятых. ");
INSERT INTO bel_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","І ўвойдуць Аарон і сыны ягоныя, і здымуць заслону, што вісіць перад Каўчэгам, і накрыюць ёю Каўчэг Сьведчаньня. ");
INSERT INTO bel_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","І паложаць на яго накрыцьцё са скуры тахаш, і над ім расьцягнуць тканіну, усю з блакіту, а потым укладуць насілы ягоныя. ");
INSERT INTO bel_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","І стол хлябоў пакладных накрыюць тканінаю з блакіту, і паставяць на ім посуд, талеркі, чашы і кубкі на ахвяры вадкія; і хлябы пакладныя будуць на ім. ");
INSERT INTO bel_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","І паложаць на іх тканіну кармазыновую, і накрыюць накрыцьцём са скураў тахаш, і ўкладуць насілы ягоныя. ");
INSERT INTO bel_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","І возьмуць тканіну з блакіту, і накрыюць ёй сьвечнік асьвятленьня, лямпы ягоныя, нажніцы, пасудзіны на кнаты і ўсе пасудзіны для алею, ужываныя пры ім. ");
INSERT INTO bel_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","І ўсё гэтае накрыюць накрыцьцём са скуры тахаш, і пакладуць на насілы. ");
INSERT INTO bel_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","І на ахвярнік залаты пало­жаць тканіну з блакіту, і накрыюць яго накрыцьцём са ску­ры тахаш, і ўкладуць насілы. ");
INSERT INTO bel_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","І возьмуць усе прыналежнасьці, ужываныя для службы ў сьвятыні, і накрыюць іх тканінай з блакіту і накрыцьцём са скуры тахаш, і пакладуць на насілы. ");
INSERT INTO bel_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","І ачысьцяць ахвярнік ад попелу, і накрыюць яго тканінаю з пурпуру. ");
INSERT INTO bel_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","І пакладуць на ім увесь посуд, ужываны для службы пры ахвярніку: папяльніцы, віл­кі, лапаткі, крапільнікі. Усе гэ­тыя прыналежнасьці ахвяр­ні­ка накрыюць накрыцьцём са скуры тахаш і ўкладуць насілы. ");
INSERT INTO bel_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Пры складваньні табару, калі Аарон і сыны ягоныя скончаць накрываць рэчы сьвятыя і ўсе прыналежнасьці сьвятыні, падыйдуць сыны Кегата, каб іх несьці. І нельга ім дакранацца рэчаў сьвятых, каб не памерлі. Такі вось цяжар сыноў Кегата пры Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","А Элеазар, сын Аарона сьвятара, будзе рупіцца пра алей на асьвятленьне, пра пахкія кадзілы, пра заўсёдную ахвяру хлебную, і пра алей памазаньня, і пра ўсё, патрэбнае для служэньня ў Сялібе, пра сьвя­тыню і прыналежнасьці ейныя». ");
INSERT INTO bel_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Не дазвольце зьнікнуць сям’і Кегата сярод лявітаў, ");
INSERT INTO bel_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","але рабіце так, каб яны жылі і не памерлі, калі будуць набліжацца да Сьвятога Сьвятых. Аарон і сыны ягоныя няхай прыйдуць і вызначаць кожнаму служэньне ягонае і цяжар, які маюць несьці. ");
INSERT INTO bel_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Але лявіты няхай не ўваходзяць у сьвятыню хоць на хвіліну, каб паглядзець, і не памруць». ");
INSERT INTO bel_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Палічы сыноў Гершона паводле дамоў бацькоў іхніх і паводле сем’яў іхніх. ");
INSERT INTO bel_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Палічы ўсіх ад трыццаці гадоў і да пяцідзесяці гадоў, усіх, здольных да службы, каб выконвалі служэньне ў Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Вось служэньне сям'і Гершона, якое яны будуць рабіць, і цяжары іхнія. ");
INSERT INTO bel_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Яны будуць насіць заслоны Сялібы і Намёт Спатканьня, і накрыцьцё ягонае, і накрыцьцё са скуры тахаш, якое на ім, і заслону, што каля ўваходу ў Намёт Спатканьня, ");
INSERT INTO bel_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","і заслоны панадворку, і заслону каля ўваходу ў панадворак, які вакол Сялібы і ахвярніка, і вяроўкі, і ўсе прыналежнасьці, патрэбныя для служэньня, і ўсё, што зроблена для іх і служэньня іхняга. ");
INSERT INTO bel_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Паводле слова з вуснаў Аарона і сыноў ягоных будзе праходзіць усё служэньне сыноў Гершона пры пераносцы цяжараў і пры ўсякім служэньні іхнім. Даручы ім пільнаваць усё, што яны носяць. ");
INSERT INTO bel_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Гэта служэньне сыноў Гершона ў Намёце Спатканьня. Будуць яны пад наглядам Ітамара, сына Аарона сьвятара. ");
INSERT INTO bel_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Палічы сыноў Мэрары паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ад трыццаці да пяцідзесяці гадоў, усіх, здольных да службы, каб служыць у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","І гэта абавязкі іхнія ў-ва ўсім служэньні ў Намёце Спатканьня: насіць дошкі Сялібы і жэрдкі яе, слупкі яе і падставы іх, ");
INSERT INTO bel_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","і слупкі панадворку з усіх бакоў і падставы іхнія, калкі намёту і вяроўкі іхнія, і ўсе рэчы пры іх, і ўсе прыналежнасьці іхнія, і запішыце ўсе рэчы, якія яны павінны насіць. ");
INSERT INTO bel_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Гэта служэньне сем'яў сыноў Мэрары адносна служэньня іх у Намёце Спатканьня. Будуць яны пад наглядам Ітамара, сына Аарона сьвятара». ");
INSERT INTO bel_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","І Майсей, і Аарон, і князі грамады палічылі сыноў Кегата паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ад трыццаці гадоў і аж да пяцідзесяці гадоў, усіх, здольных да службы, каб служыць у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","І было налічана іх паводле сем’яў іхніх дзьве тысячы семсот пяцьдзясят. ");
INSERT INTO bel_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Гэта палічаныя сем'і Кегата, усе, якія служаць у Намёце Спатканьня, якіх палічыў Майсей і Аарон паводле слова з вуснаў ГОСПАДА, дадзенага праз Майсея. ");
INSERT INTO bel_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","І былі палічаны сыны Гершона паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ад трыццаці гадоў і аж да пяцідзесяці гадоў, усе, здольныя да службы, каб служыць у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","І было налічана іх паводле сем’яў іхніх і паводле дамоў бацькоў іхніх дзьве тысячы шэсьцьсот трыццаць. ");
INSERT INTO bel_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Гэта палічаныя сем'і сыноў Гершона, усе, якія слу­жаць у Намёце Спатканьня, якіх палічылі Майсей і Аарон паводле слова з вуснаў ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","І былі палічаны сем'і сыноў Мэрары паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ад трыццаці гадоў і да пяцідзесяці гадоў, усе, здольныя да службы, каб служыць у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","І было налічана іх паводле сем’яў іхніх тры тысячы дзьвесьце. ");
INSERT INTO bel_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Гэта палічаныя сем'і сыноў Мэрары, якіх палічылі Майсей і Аарон паводле слова з вуснаў ГОСПАДА, дадзенага праз Майсея. ");
INSERT INTO bel_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Былі палічаныя ўсе лявіты, якіх палічылі Майсей, і Аарон, і князі Ізраіля паводле сем’яў іхніх і паводле дамоў бацькоў іхніх, ");
INSERT INTO bel_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ад трыццаці гадоў і да пяцідзесяці гадоў, усіх, здольных да спаўненьня службы ў Сялібе і да працаў пры нашэньні цяжараў у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","І было налічана іх восем тысячаў пяцьсот восемдзясят. ");
INSERT INTO bel_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Паводле слова з вуснаў ГОСПАДА, дадзенага Майсею, прызначаны яны кожны да свайго служэньня і для нашэньня цяжару свайго. І былі яны палічаны, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Загадай сынам Ізраіля выдаліць з табару ўсіх пракажоных, хворых на выцёкі і апаганеных ад нябожчыка. ");
INSERT INTO bel_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Як мужчыну, так і жанчыну выдаліце па-за табар, каб не паганілі табару, дзе Я жыву сярод вас». ");
INSERT INTO bel_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","І зрабілі так сыны Ізраіля, і выдалілі іх па-за табар; як прамовіў ГОСПАД да Майсея, так і зрабілі сыны Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Прамоў да сыноў Ізраіля: “Калі мужчына або жанчына дапусьціцца нейкага грэху адносна людзей, і парушыць загад ГОСПАДА, будзе вінаватая душа гэтая. ");
INSERT INTO bel_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Няхай яны вызнаюць грэх свой, які ўчынілі, і аддадуць аднагароджаньне таму, перад кім саграшылі, з дадаткам пятай часткі. ");
INSERT INTO bel_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Калі ў яго няма чалавека, якому мог бы зьвярнуць, аднагарадзжэньне будзе для ГОСПАДА, аднагараджэньне гэта будзе для сьвятара, апрача барана перамольваньня, якім будзе перамольваць за грэх. ");
INSERT INTO bel_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Усе сьвятыя дары, якія прыносяць сьвятару сыны Ізраіля, яму належаць. ");
INSERT INTO bel_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Сьвятыя дары кожнагачалавека, якія нехта прынясе сьвятару, будуць належаць сьвятару”». ");
INSERT INTO bel_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Прамоў да сыноў Ізраіля і скажы ім: “Муж, жонка якога здрадзіць яму, і будзе няверная яму нявернасьцю, ");
INSERT INTO bel_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","і ляжа з ёй чужы мужчына, і вылье насеньне, і гэта будзе схавана ад мужа ейнага, і яна будзе нячыстай, але няма сьведкаў і яе не злавілі на распусьце, ");
INSERT INTO bel_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","і дух рэўнасьці зый­дзе на мужа, і ён будзе рэўна­ваць жонку сваю, што яна занячысьцілася, або зыйдзе на яго дух рэўнасьці, і ён будзе рэўна­ваць жонку сваю, а яна не занячысьцілася, ");
INSERT INTO bel_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","няхай прывядзе муж жонку сваю да сьвятара і складзе ў ахвяру за яе дзясятую частку эфы мукі ячменнай, але ня вылье на яе алею і не пакладзе кадзіла, бо гэта ахвяра рэўнасьці, ахвяра выяўленьня, якая мае выявіць віну. ");
INSERT INTO bel_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","І няхай прывядзе сьвятар жанчыну, і паставіць яе перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","І возьме сьвятар асьвячонай вады ў посуд гліняны, і возьме сьвятар пыл з падлогі Сялібы, і ўсыпле ў ваду. ");
INSERT INTO bel_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","І паставіць сьвятар жанчыну перад абліччам ГОСПАДА, і адкрые валасы на галаве жанчыны, і паложыць на яе далоні ахвяру выяўленьня, ахвяру рэўнасьці; і ў руцэ сьвятара будзе вада горкая, якая нясе праклён. ");
INSERT INTO bel_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","І запрысягне сьвятар жанчыну, і скажа ёй: “Калі ніво­дзін мужчына не ляжаў з табой, і калі з іншым ты не занячысьцілася адносна мужа твайго, тады вада горкая, якая нясе праклён, ачысьціць цябе. ");
INSERT INTO bel_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","А калі ты здрадзіла мужу свайму і сталася нячыстая, і іншы мужчына, а ня муж твой ляжаў з табой, выліваючы насеньне,” — ");
INSERT INTO bel_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","і сьвятар запрысягне жанчыну прысягай праклёну, і скажа сьвятар жанчыне: “Няхай аддасьць цябе ГОСПАД на праклён і закляцьце ў народзе тваім, і няхай зробіць ГОСПАД, што ўпадзе сьцягно тваё і апухне жывот твой. ");
INSERT INTO bel_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","І ўвойдзе вада праклёну ў нутро тваё, каб апух жывот твой і ўпала сьцягно тваё”. І скажа жанчына: “Амэн, амэн”. ");
INSERT INTO bel_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","І напіша сьвятар на скрутку словы праклёну, і змые іх вадою горкаю, ");
INSERT INTO bel_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","і напоіць жанчыну вадою горкаю, якая нясе праклён, і вада праклёну ўвойдзе ў яе і спрычыніць горкі боль. ");
INSERT INTO bel_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","І возьме сьвятар з рук жанчыны ахвяру рэўнасьці, і патрасе перад абліччам ГОСПАДА як ахвяру хлебную, і складзе яе на ахвярніку. ");
INSERT INTO bel_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","І возьме жменяй частку ахвяры хлебнай як памятную частку, і спаліць яе на ахвярніку, а пасьля дасьць жанчыне выпіць вады. ");
INSERT INTO bel_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","І вып’е жанчына ваду і калі была яна нячыстай і нявернай мужу свайму, вада праклёну ўвойдзе ў яе, і справіць горкі боль, ўпадзе сьцягно ейнае і жывот ейны апухне, і станецца тая жанчына праклятаю ў народзе сваім. ");
INSERT INTO bel_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","А калі тая жанчына не была нячыстай, але яна чыстая, будзе ачышчаная і наро­дзіць нашчадкаў”. ");
INSERT INTO bel_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Гэта закон адносна рэўнасьці, калі жонка здра­дзіць мужу свайму і станецца нячыстай. ");
INSERT INTO bel_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Або калі на мужа зыйдзе дух рэўнасьці і ён будзе рэўнаваць жонку сваю, і ён паставіць яе перад абліччам ГОСПАДА, і сьвятар зробіць усё паводле закону гэтага. ");
INSERT INTO bel_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","І будзе муж чысты ад віны, а тая жонка панясе віну сваю». ");
INSERT INTO bel_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Калі нейкі мужчына або жанчына складуць шлюбаваньне назіру, каб пасьвяціцца ГОСПАДУ, ");
INSERT INTO bel_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","мусяць яны ўстрымацца ад віна і сікеры, воцату з віна і воцату з сікеры ня будуць піць, і ўсякага піцьця з вінаграду ня будуць піць. Сьвежага вінаграду і сушанага ня будуць есьці. ");
INSERT INTO bel_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","У-ва ўсе дні пасьвячэньня свайго ня будзе такі чалавек есьці нічога з вінаграду, ад недасьпелага вінаграду аж да выцісканага. ");
INSERT INTO bel_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Усе дні пасьвячэньня ягонага нажніцы не дакрануцца галавы ягонай. Аж споўняцца дні, на якія ён пасьвяціўся ГОСПАДУ, будзе ён сьвяты і мае даць свабоду валасам расьці на галаве ягонай. ");
INSERT INTO bel_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Усе дні пасьвячэньня ягонага ГОСПАДУ не наблізіцца ён да нябожчыка. ");
INSERT INTO bel_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Няхай пры пахаваньні бацькі, маці, брата або сястры не занячысьціцца, бо пасьвячэньне Богу ягонаму на галаве ягонай. ");
INSERT INTO bel_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","У-ва ўсе дні пасьвячэньня свайго сьвятым будзе ён для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","А калі хто раптам пры ім памрэ, і ён занячысьціць галаву пасьвячэньня свайго, ён абстрыжэ галаву ў сёмы дзень, у дзень ачышчэньня свайго паголіць яе. ");
INSERT INTO bel_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","А ў восьмы дзень прынясе дзьвюх туркавак або двух маладых галубоў сьвятару да ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Аднаго складзе сьвятар у ахвяру за грэх, а другога — у ахвяру цэласпаленьня і перапросіць за яго, бо ён саграшыў дзеля нябожчыка, і ў той дзень будзе пасьвячоная галава яго. ");
INSERT INTO bel_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","І зноў пасьвяціць ён ГОСПАДУ дні пасьвячэньня свайго, і прывядзе ў ахвяру ягня аднагадовае як аднагараджэньне, а дні папярэднія ня будуць залічаны, бо ён занячысьціў пасьвячэньне сваё. ");
INSERT INTO bel_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","І вось закон пасьвячэньня. У дзень, калі скончацца дні, якія шлюбаваў, прывядуць яго да ўваходу ў Намёт Спатканьня, ");
INSERT INTO bel_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","і ён прынясе ў ахвяру ГОСПАДУ адно аднагадовае ягня без заганы ў ахвяру цэласпаленьня, і адну аднагадовую авечку без заганы ў ахвяру за грэх, і аднаго барана без заганы ў ахвяру мірную, ");
INSERT INTO bel_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","і кошык праснакоў з мукі пшанічнай, запраўленых алеем, і аладак прэсных, памаза­ных алеем, і належную ахвяру хлебную і ахвяру вадкую. ");
INSERT INTO bel_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Сьвятар занясе ўсё гэта перад аблічча ГОСПАДА і складзе ахвяру за грэх і ахвяру цэласпаленьня. ");
INSERT INTO bel_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Барана ён складзе ГОСПАДУ ў ахвяру мірную разам з кошыкам праснакоў, і скла­дзе сьвятар ахвяру хлебную і ахвяру вадкую. ");
INSERT INTO bel_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","І абстрыжэ назір каля ўваходу ў Намёт Спатканьня галаву пасьвячэньня свайго, і кіне валасы ў агонь, у якім гарыць ахвяра мірная. ");
INSERT INTO bel_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","І возьме сьвятар звараную лапатку барана, праснак з каша і прэсную аладку, і скла­дзе іх на далоні назіра пасьля таго, як пастрыжэ ён галаву пасьвячэньня свайго. ");
INSERT INTO bel_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","І сьвятар будзе патрэсваць іх патрэсваньнем перад абліччам ГОСПАДА, бо гэта дар сьвяты, які належыць сьвятару, апрача грудзіны патрасанай і пляча ахвяраванага. І пасьля гэтага назір можа піць віно. ");
INSERT INTO bel_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Гэта закон адносна назіра, які шлюбаваў ахвяру сваю ГОСПАДУ за пасьвячэньне сваё апрача таго, што дазволіць яму рука ягоная. Паводле шлюбаваньня свайго, якое прамовілівусны ягоныя, ён зробіць, паводле закону пасьвячэньня свайго». ");
INSERT INTO bel_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Прамоў да Аарона і сыноў ягоных, кажучы: “Гэтак вы будзеце дабраслаўляць сыноў Ізраіля і казаць ім: ");
INSERT INTO bel_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","\"Няхай дабраславіць цябе ГОСПАД і захавае цябе! ");
INSERT INTO bel_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Няхай спагадна гляне ГОСПАД на цябе і зьлітуецца над табою! ");
INSERT INTO bel_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Няхай зьверне ГОСПАД аблічча Сваё на цябе і дасьць табе супакой!\" ");
INSERT INTO bel_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Няхай так заклікаюць імя Маё на сыноў Ізраіля, і Я буду дабраслаўляць іх”». ");
INSERT INTO bel_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","І сталася ў дзень, калі Майсей скончыў буда­ваць Сялібу і памазаў яе, і пасьвяціў яе і ўсе прыналежнасьці ейныя, і ахвярнік, і ўсе прылады ягоныя, і памазаў іх, і пасьвяціў іх, ");
INSERT INTO bel_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","прыйшлі князі Ізраіля, галовы дамоў бацькоў сваіх, князі пакаленьняў, якія стаялі на чале перапісаных, ");
INSERT INTO bel_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","і прынесьлі дары свае перад аблічча ГОСПАДА: шэсьць крытых вазоў і дванаццаць валоў, па адным возе ад двух князёў і па аднаму валу ад кожнага, і паставілі гэта перад Сялібай. ");
INSERT INTO bel_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","І сказаў ГОСПАД Майсею: ");
INSERT INTO bel_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Вазьмі гэта ад іх; і няхай будзе на службу пры Намёце Спатканьня. І дасі гэта лявітам адпаведна да іх паслугі». ");
INSERT INTO bel_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","І ўзяў Майсей вазы і валоў, і аддаў іх лявітам. ");
INSERT INTO bel_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Адпаведна да іх паслугі сынам Гершона даў два вазы і чатыры валы. ");
INSERT INTO bel_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Восем валоў і чатыры вазы даў сынам Мэрары, адпаведна да іхняй паслугі пад наглядам Ітамара, сына Аарона сьвятара. ");
INSERT INTO bel_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","А сынам Кегата ня даў нічога, бо іх паслуга пры рэчах сьвятых, каб насіць іх на рамёнах сваіх. ");
INSERT INTO bel_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","І прынесьлі князі дары свае на пасьвячэньне ахвярніка перад ахвярніка ў дзень пасьвячэньня ягонага. ");
INSERT INTO bel_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","І сказаў ГОСПАД Майсею: «Няхай кожны з князёў што­дзень прыносіць дар свой на пасьвячэньне ахвярніка». ");
INSERT INTO bel_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","У першы дзень прынёс дар свой Нахшон, сын Амінадава, з пакаленьня Юды. ");
INSERT INTO bel_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ягоным дарам ахвярным былі міса срэбная ў сто трыццаць сыкляў вагі, чаша срэбная ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнаю мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","залатая чаша ў дзе­сяць сыкляў, напоўненая кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","адзін бычок, адзін баран і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","казёл у ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","і ў ахвяру мірную два валы, пяць бараноў, пяць казлоў і пяць аднагадовых ягнят. Гэта дар ахвярны Нахшона, сына Амінадава. ");
INSERT INTO bel_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","У другі дзень прынёс дарНатанаэль, сын Цуара, князь Ісахара. ");
INSERT INTO bel_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ён прынёс свой дар ахвярны: місу срэбную ў сто трыц­цаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абе­дзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","залатую чашу ў дзе­сяць сыкляў, напоўненую кадзілам; ");
INSERT INTO bel_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","і ў ахвяру мірную два валы, пяць бараноў, пяць казлоў і пяць аднагадовых ягнят. Гэта дар ахвярны Натанаэля, сына Цуара. ");
INSERT INTO bel_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","У трэці дзень прынёс дар ахвярны князь сыноў Завулёна Эліяў, сын Хэлёна. ");
INSERT INTO bel_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ягоным дарам былі: міса срэбная ў сто трыццаць сыкляў вагі, чаша срэбная ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","залатая чаша ў дзе­сяць сыкляў, напоўненая кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","адзін бычок, адзін баран і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","казёл у ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Эліява, сына Хэлёна. ");
INSERT INTO bel_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","У чацьвёрты дзень прынёс дар ахвярны князь сыноў Рубэна Эліцур, сын Шэдэура. ");
INSERT INTO bel_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Эліцура, сына Шэдэура. ");
INSERT INTO bel_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","У пяты дзень прынёс дар ахвярны князь сыноў Сымона Шэлюміэль, сын Цурышадая. ");
INSERT INTO bel_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Шэлюміэля, сына Цурышадая. ");
INSERT INTO bel_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","У шосты дзень прынёс дар ахвярны князь сыноў Гада Эліясаф, сын Дэўэля. ");
INSERT INTO bel_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Эліясафа, сына Дэўэля. ");
INSERT INTO bel_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","У сёмы дзень прынёс дар ахвярны князь сыноў Эфраіма Элішама, сын Амігуда. ");
INSERT INTO bel_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Элішамы, сына Амігуда. ");
INSERT INTO bel_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","У восьмы дзень прынёс дар ахвярны князь сыноў Манасы Гамаліэль, сын Пэдагсура. ");
INSERT INTO bel_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Гамаліэля, сына Пэдагсура. ");
INSERT INTO bel_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","У дзявяты дзень прынёс дар ахвярны князь сыноў Бэн’яміна Абідан, сын Гідэоні. ");
INSERT INTO bel_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Абідана, сына Гідэоні. ");
INSERT INTO bel_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","У дзясяты дзень прынёс дар ахвярны князь сыноў Дана Ахіезэр, сын Амішадая. ");
INSERT INTO bel_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Ахіезэра, сына Амішадая. ");
INSERT INTO bel_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","У адзінаццаты дзень прынёс дар ахвярны князь сыноў Асэра Пагіэль, сын Акрана. ");
INSERT INTO bel_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Пагіэля, сына Акрана. ");
INSERT INTO bel_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","У дванаццаты дзень прынёс дар ахвярны князь сыноў Нэфталі Ахіра, сын Энана. ");
INSERT INTO bel_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ён ахвяраваў місу срэбную ў сто трыццаць сыкляў вагі, чашу срэбную ў семдзясят сыкляў, паводле сыклю сьвятыні, абедзьве напоўненыя пшанічнай мукой, запраўленай алеем, у ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","залатую чашу ў дзесяць сыкляў, напоўненую кадзілам, ");
INSERT INTO bel_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","аднаго бычка, аднаго барана і аднагадовае ягня ў ахвяру цэласпаленьня, ");
INSERT INTO bel_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","казла ў ахвяру за грэх, ");
INSERT INTO bel_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","і два валы, пяць бараноў, пяць казлоў, пяць аднагадовых ягнят у ахвяру мірную. Гэта дар ахвярны Ахіры, сына Энана. ");
INSERT INTO bel_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Вось дары ад князёў Ізраіля пры пасьвячэньні ахвярніка, у дзень яго памазаньня: дванаццаць срэбных місаў, дванаццаць срэбных чашаў, дванаццаць залатых чашаў. ");
INSERT INTO bel_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Кожная міса важыла сто трыццаць сыкляў срэбра, а кожная чаша — семдзясят сыкляў. Усяго срэбра начыньняў — дзьве тысячы чатырыста сыкляў, паводле сыклю сьвятыні. ");
INSERT INTO bel_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Чашаў залатых, напоўненых кадзілам, было дванаццаць; кожная чаша важыла дзесяць сыкляў, паводле сыклю сьвятыні. Усяго золата чашаў было сто дваццаць сыкляў. ");
INSERT INTO bel_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Усяго быдла для цэласпаленьня, было: дванаццаць бычкоў, дванаццаць бараноў, дванаццаць аднагадовых ягнят, і належныя ахвяры хлебныя, і дванаццаць казлоў у ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Усяго быдла, прызначанага ў ахвяру мірную, было: дваццаць чатыры валы, шэсьцьдзясят бараноў, шэсьцьдзясят казлоў і шэсьцьдзясят аднагадовых ягнят. Гэта дары на пасьвячэньне ахвярніка, калі ён быў памазаны. ");
INSERT INTO bel_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","І калі Майсей уваходзіў у Намёт Спатканьня, каб гаварыць з Богам, ён чуў голас, які прамаўляў да яго з-над накрыўкі, якая была над Каўчэгам Сьведчаньня паміж двума херувімамі, і Бог прамаўляў да яго. ");
INSERT INTO bel_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Прамоў да Аарона і скажы яму: “Калі будзеш запаль­ваць лямпы, на пярэднім баку сьвечніка павінны гарэць сем лямпаў”». ");
INSERT INTO bel_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Аарон зрабіў гэтак і на пярэднім баку сьвечніка запаліў лямпы, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Такі вось быў выраб сьвечніка: куты ён быў з золата, ад падставы аж да кветак быў куты паводле ўзору, які паказаў ГОСПАД Майсею, і так ён зрабіў сьвечнік. ");
INSERT INTO bel_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Вазьмі лявітаў спаміж сыноў Ізраіля і ачысьці іх. ");
INSERT INTO bel_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ачысьці іх так: пакрапі іх вадой ахвяры за грэх, і няхай паголяць яны ўсё цела сваё, і няхай вымыюць адзеньне сваё, і будуць чыстымі. ");
INSERT INTO bel_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","І возьмуць цяля са статку і ахвяру хлебную з мукі, запраўленай алеем, а другое цяля са статку ты возьмеш у ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","І прывядзеш лявітаў перад Намёт Спатканьня, і зьбярэш ўсю грамаду сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","І прывядзеш лявітаў перад аблічча ГОСПАДА, і сыны Ізраіля пакладуць на лявітаў рукі свае. ");
INSERT INTO bel_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","І Аарон як патрэсванае перад абліччам ГОСПАДА ахвяруе лявітаў ад сыноў Ізраіля, і будуць яны служыць ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","А лявіты ўскладуць рукі свае на галовы цялят, і ты аднаго з іх складзеш у ахвяру за грэх, а другога — у ахвяру цэласпаленьня для ГОСПАДА, каб перапрасіць за лявітаў. ");
INSERT INTO bel_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","І паставіш лявітаў перад абліччам Аарона і сыноў ягоных, і ахвяруеш іх як патрасанае ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","І аддзеліш лявітаў спаміж сыноў Ізраіля, і лявіты будуць Маімі. ");
INSERT INTO bel_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","А потым няхай прыходзяць лявіты, каб служыць у Намёце Спатканьня, і ты ачысьціш іх, і ахвяруеш іх як ахвяру патрэсваньня. ");
INSERT INTO bel_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Бо яны Мне аддадзены спасярод сыноў Ізраіля. Узяў Я іх у сыноў Ізраіля замест усіх першародных, якія адкрыва­юць улоньне. ");
INSERT INTO bel_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Бо Мае ўсе першародныя з сыноў Ізраіля, як з людзей, так і з жывёлы. Ад таго дня, у які Я выгубіў усё першароднае ў зямлі Эгіпецкай, Я іх пасьвяціў для Сябе. ");
INSERT INTO bel_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","І ўзяў Я лявітаў замест усіх першародных спаміж сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","І Я даю лявітаў Аарону і сынам ягоным спаміж сыноў Ізраіля, каб яны служылі Мне за сыноў Ізраіля ў Намёце Спатканьня, каб перамольваць ГОСПАДА за сыноў Ізраіля, і ня будзе кары на сыноў Ізраіля, калі наблізяцца сыны Ізраіля да Сялібы». ");
INSERT INTO bel_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Дык Майсей і Аарон і ўся грамада сыноў Ізраіля зрабілі з лявітамі гэтак; усё, што загадаў ГОСПАД Майсею адносна лявітаў, так і зрабілі з імі сыны Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","І ачысьціліся лявіты, і памылі адзеньне сваё, а Аарон, патрэсваючы, ахвяраваў іх ГОСПАДУ і перамольваў за іх Аарон, каб былі ачышчаныя. ");
INSERT INTO bel_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Пасьля ўвайшлі лявіты, каб спаўняць службу сваю ў Намёце Спатканьня перад абліччам Аарона і сыноў ягоных. Як загадаў ГОСПАД Майсею адносна лявітаў, так і зрабілі з імі. ");
INSERT INTO bel_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Гэта закон адносна лявітаў: ад дваццаці пяці гадоў і вышэй няхай прыходзяць яны і слу­жаць у Намёце Спатканьня; ");
INSERT INTO bel_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","а калі будуць мець пяцьдзясят гадоў, няхай не спаўняюць службы і больш не працуюць, ");
INSERT INTO bel_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","а будуць дапамагаць братам сваім у Намёце Спатканьня ў спаўненьні службы, і служэньня ня будуць выконваць. Так зробіш з лявітамі адносна службы іхняй». ");
INSERT INTO bel_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","І прамовіў ГОСПАД да Майсея ў першы месяц другога году пасьля выхаду з Эгіпту ў пустыні Сынай, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«У вызначаны час сыны Ізраіля павінны спраўляць Пасху. ");
INSERT INTO bel_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","У чатырнаццаты дзень гэтага месяца вечарам справіце яе паводле ўсіх адносна яе пастановаў і звычаяў». ");
INSERT INTO bel_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","І прамовіў Майсей да сыноў Ізраіля, каб яны справілі Пасху. ");
INSERT INTO bel_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","І яны спраўлялі Пасху ў чатырнаццаты дзень месяца вечарам у пустыні Сынай. Усё, што загадаў ГОСПАД Майсею, зрабілі сыны Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","І былі людзі, якія дзеля дакрананьня да нябожчыка сталіся нячыстымі і не маглі ў той дзень спраўляць Пасху, і прыйшлі яны да Майсея і Аарона, ");
INSERT INTO bel_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","і сказалі ім: «Мы нячыстыя дзеля дакрананьня да нябожчыка, але дзеля чаго мы пазбаўлены таго, каб сярод сыноў Ізраіля ў вызначаны час скласьці дар ахвярны ГОСПАДУ?» ");
INSERT INTO bel_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","І сказаў ім Майсей: «Пачакайце, і я паслухаю, што адносна вас загадае ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Прамоў да сыноў Ізраіля, кажучы: “Чалавек з вас ці з нашчадкаў вашых, які стаўся нячыстым дзеля нябожчыка або дзеля далёкай дарогі, павінен спраўляць Пасху ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","У чатырнаццаты дзень другога месяца вечарам будзе спраўляць яе. Праснакі і горкія травы няхай спажывае. ");
INSERT INTO bel_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Няхай не пакідаюць з яе анічога да раніцы, і косткі яе ня будуць ламаць. Няхай спраўляюць яе паводле ўсіх пастановаў Пасхі. ");
INSERT INTO bel_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","А калі хто чысты і не ў дарозе, а Пасхі не спраўляе, вынішчана будзе душа тая з народу свайго, бо ён не склаў дару ахвярнаго ГОСПАДУ ў свой час. Грэх свой панясе чалавек гэты. ");
INSERT INTO bel_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","А калі прыхадзень, які жыве ў вас, справіць Пасху паводле пастановаў і звычаяў Пасхі, парадак той самы будзе ў вас і для чужынца, і для тутэйшага на зямлі гэтай”». ");
INSERT INTO bel_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","У дзень, у які была пастаўлена Сяліба, воблака накрыла Сялібу з Намётам Сьведчаньня, і ад вечара да раніцы заставалася над Сялібай у бляску агню. ");
INSERT INTO bel_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","І так было заўсёды: днём пакрывала яе воблака, а ноччу — нібы бляск агню. ");
INSERT INTO bel_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Калі воблака падымалася над Намётам, тады сыны Ізраіля выходзілі ў дарогу, а на тым месцы, дзе затрымоўвалася воблака, там раскладаліся табарам сыны Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Паводле слова з вуснаў ГОСПАДА выходзілі ў дарогу сыны Ізраіля, і паводле слова з вуснаў ГОСПАДА раскладаліся табарам. Усе дні, у якія воблака стаяла над Сялібай, яны стаялі табарам. ");
INSERT INTO bel_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","І калі воблака доўгі час стаяла над Сялібай, шмат дзён, сыны Ізраіля захоўвалі волю ГОСПАДА і не выходзілі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","І здаралася, што мала дзён стаяла над Сялібай, і сыны Ізраіля паводле слова з вуснаў ГОСПАДА раскладаліся табарам і паводле слова з вуснаў ГОСПАДА выходзілі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","І здаралася, што воблака стаяла ад вечара да раніцы, а раніцаю падымалася, і яны выходзілі ў дарогу. Або стаяла воблака дзень і ноч, і воблака падымалася, і яны выхо­дзілі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Або два дні, або месяц, або некалькі дзён стаяла воблака над Сялібай, і сыны Ізраіля стаялі табарам і не выходзілі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Паводле слова з вуснаў ГОСПАДА яны раскладаліся табарам, і паводле слова з вуснаў ГОСПАДА выходзілі ў дарогу. Яны захоўвалі волю ГОСПАДА паводле слова з вуснаў ГОСПАДА праз Майсея. ");
INSERT INTO bel_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Зрабі сабе дзьве трубы срэбныя, кутыя, і будуць яны склікаць усю грамаду, каб рыхтаваць табар у дарогу. ");
INSERT INTO bel_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","І затрубяць у трубы, і зьбя­рэцца да цябе ўся грамада да ўваходу ў Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","А калі ў адну затрубяць, зьбяруцца да цябе князі і начальнікі дружынаў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Калі затрубіш працягла, выйдзе ў дарогу табар, які з усходняга боку. ");
INSERT INTO bel_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Калі другі раз працягла затрубіш, выйдзе ў дарогу табар, які з паўднёвага боку. Знакам на вырушаньне табару будзе працяглае трубеньне. ");
INSERT INTO bel_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","На зьбіраньне царквы затрубіце, але не працягла. ");
INSERT INTO bel_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Трубіць у трубы будуць сыны Аарона, сьвятары. Будзе гэта вам і нашчадкам вашым пастанова вечная. ");
INSERT INTO bel_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Калі будзеш ісьці на вайну ў зямлі вашай супраць ворага, які наступае на вас, будзеце трубіць у трубы. Гэта будзе кліч ваш перад абліччам ГОСПАДА, Бога вашага, і Ён збавіць вас ад ворагаў вашых. ");
INSERT INTO bel_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","У дзень радасьці вашай, у сьвяты і ў маладзікі, пры вашых цэласпаленьнях і ахвярах мірных, будзеце тру­біць у трубы; і яны будуць нагадваньнем перад абліччам Бога вашага пра вас. Я — ГОСПАД, Бог ваш!» ");
INSERT INTO bel_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","І сталася ў другі год, у другі месяц, у дваццаты дзень месяца, паднялося воблака з-над Сялібы Сьведчаньня. ");
INSERT INTO bel_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","І вырушылі сыны Ізраіля ў дарогу сваю з пустыні Сынай, і спынілася воблака ў пустыні Паран. ");
INSERT INTO bel_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Першы раз паводле слова з вуснаў ГОСПАДА, дадзенага праз Майсея, вырушылі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Першым вырушыў сьцяг табару сыноў Юды з дружынамі сваімі, а над дружынамі ягонымі быў Нахшон, сын Амінадава. ");
INSERT INTO bel_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","А над дружынамі пакаленьня сыноў Ісахара быў Натанаэль, сын Цуара. ");
INSERT INTO bel_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","А над дружынамі пакаленьня сыноў Завулёна быў Эліяў, сын Хэлёна. ");
INSERT INTO bel_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","І разабралі Сялібу, і вырушылі сыны Гершона і сыны Мэрары, несучы Сялібу. ");
INSERT INTO bel_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","І выйшаў у дарогу сьцяг табару сыноў Рубэна з дружынамі сваімі, а над дружынамі ягонымі быў Эліцур, сын Шэдэура. ");
INSERT INTO bel_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","А над дружынамі пакаленьня сыноў Сымона быў Шэлюміэль, сын Цурышадая. ");
INSERT INTO bel_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Над дружынамі пакаленьня сыноў Гада быў Эліясаф, сын Дэўэля. ");
INSERT INTO bel_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","І выйшлі ў дарогу сыны Кегата, несучы рэчы сьвятыя, і пакуль яны прыйшлі, Сяліба была ўжо пастаўлена. ");
INSERT INTO bel_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","І выйшаў у дарогу сьцяг табару сыноў Эфраіма з дружынамі сваімі, а над дружынамі ягонымі быў Элішама, сын Амігуда. ");
INSERT INTO bel_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","А над дружынай пакаленьня сыноў Манасы быў Гамаліэль, сын Пэдагсура. ");
INSERT INTO bel_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","А над дружынамі пакаленьня сыноў Бэн’яміна быў Абідан, сын Гідэоні. ");
INSERT INTO bel_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","І выйшаў у дарогу сьцяг табару сыноў Дана з дружынамі сваімі, а над дружынамі ягонымі быў Ахіезэр, сын Амішадая. ");
INSERT INTO bel_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","А над дружынамі пакаленьня сыноў Асэра быў Пагіэль, сын Акрана. ");
INSERT INTO bel_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","А над дружынамі сыноў Нэфталі быў Ахіра, сын Энана. ");
INSERT INTO bel_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Вось такі быў парадак паходу сыноў Ізраіля з дружынамі сваімі, калі выходзілі ў дарогу. ");
INSERT INTO bel_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","І сказаў Майсей Хававу, сыну Рэгуэля, Мадыянца, цесьця свайго: «Мы выходзім у месца, пра якое сказаў ГОСПАД: \"Я дам яго вам\". Хадзі з намі, і будзе табе добра, бо ГОСПАД абяцаў дабро Ізраілю». ");
INSERT INTO bel_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Той сказаў яму: «Не пайду, але пайду ў зямлю маю і да сваякоў маіх». ");
INSERT INTO bel_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","І сказаў Майсей: «Не пакідай нас, бо ты ведаеш, як мы маем раскладацца табарам у пустыні, і будзеш для нас вачыма. ");
INSERT INTO bel_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Калі пойдзеш з намі, тады калі будзе нешта добрае, што дасьць нам ГОСПАД, мы дамо табе». ");
INSERT INTO bel_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","І вырушылі яны з гары ГОСПАДА, і ішлі на працягу трох дзён. Каўчэг Запавету ГОСПАДА ішоў наперадзе іх на працягу трох дзён, каб знайсьці месца на табар. ");
INSERT INTO bel_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","І воблака ГОСПАДА было над імі ўдзень, калі яны выхо­дзілі з табару. ");
INSERT INTO bel_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","І было, калі вырушаў Каўчэг у дарогу, Майсей казаў: «Паўстань, ГОСПАДЗЕ, і няхай разьбягуцца ворагі Твае, і няхай паўцякаюць тыя, што ненавідзяць Цябе, перад абліччам Тваім». ");
INSERT INTO bel_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","А калі ставілі Каўчэг, казаў: «Вярніся, ГОСПАДЗЕ, да шматлікага войска Ізраіля!» ");
INSERT INTO bel_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","І сталася, што народ наракаў, і кепска гэта было ў вушах ГОСПАДА. І пачуў гэта ГОСПАД, і разгневаўся, і ўзгарэўся на іх агонь ГОСПАДА, і зьнішчыў крайнюю частку табара. ");
INSERT INTO bel_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","І народ стаў клікаць Майсея, і Майсей маліў ГОСПАДА, і агонь спыніўся. ");
INSERT INTO bel_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","І назвалі тое месца Табэра, бо там узгарэўся супраць іх агонь ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Іншапляменьнікі, якія былі паміж імі, зажадалі пажаданьнем і захацелі вярнуцца, і разам з імі сыны Ізраіля плакалі і казалі: «Хто дасьць нам есьці мяса? ");
INSERT INTO bel_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Мы памятаем, як у Эгіпце мы елі дарма рыбу, і агуркі, дыні, салат, цыбулю і часнык. ");
INSERT INTO bel_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","А цяпер душа нашая ссохла, нічога іншага ня бачаць вочы нашыя, апрача манны». ");
INSERT INTO bel_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","А манна была падобная да насеньня каляндры і мела выгляд як бдалах. ");
INSERT INTO bel_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Людзі выходзілі і зьбіралі яе, і малолі ў жорнах або таўклі ў ступе і варылі ў гаршчках, і рабілі з яе аладкі; і смак іх быў падобны да аладак з алеем. ");
INSERT INTO bel_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Калі ноччу раса ападала на табар, адначасова ападала і манна. ");
INSERT INTO bel_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","І пачуў Майсей, як народ плача сем’ямі сваімі, кожны каля ўваходу ў намёт свой. І вельмі ўзгарэўся гнеў ГОСПАДА, і гэта кепскім было ў вачах Майсея. ");
INSERT INTO bel_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","І сказаў Майсей ГОСПАДУ: «Чаму Ты мучыш слугу Твайго? Чаму не магу я знайсьці ласкі ў вачах Тваіх? Чаму Ты ўсклаў на мяне цяжар усяго народу гэтага? ");
INSERT INTO bel_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ці ж з мяне пачаўся ўвесь народ гэты, або я нарадзіў яго, што Ты кажаш мне: “Насі яго на ўлоньні тваім, як носіць карміцелька дзіцятка, і занясі ў зямлю, якую запрысяг бацькам іхнім”? ");
INSERT INTO bel_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Адкуль у мяне мяса, каб даць усяму народу гэтаму? З плачам наракаюць на мяне, кажучы: “Дай нам мяса, каб мы наеліся!” ");
INSERT INTO bel_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Не магу я сам насіць увесь народ гэты, бо ён зацяжкі для мяне. ");
INSERT INTO bel_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Калі Ты такім чынам робіш са мною, прашу, забі мяне, калі я знайшоў ласку ў вачах Тваіх, каб ня бачыў я няшчасьця майго!» ");
INSERT INTO bel_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","І сказаў ГОСПАД Майсею: «Скліч Мне семдзясят чалавек спасярод старшыняў Ізраіля, пра якіх ты ведаеш, што яны паважаныя ў народзе і наглядаюць за ім, і прывядзі іх у Намёт Спатканьня, і няхай там яны стануць разам з табою. ");
INSERT INTO bel_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","А Я зыйду і буду гава­рыць з табою, і вазьму з духа, які на табе, і дам ім, каб яны разам з табою насілі цяжар народу, а ня толькі ты насіў цяжар гэты. ");
INSERT INTO bel_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","А народу скажы: “Ачысьціцеся назаўтра і будзеце есьці мяса, бо вы плакалі на вачах ГОСПАДА, кажучы: ‘Хто дасьць нам есьці мяса? Добра было нам у Эгіпце’. І дасьць вам ГОСПАД мяса, і будзеце есьці, ");
INSERT INTO bel_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","і не адзін дзень будзеце есьці, і ня два або пяць, або дзе­сяць, або дваццаць, ");
INSERT INTO bel_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","але ўвесь месяц, аж пакуль вам ня выйдзе мяса праз ноздры вашыя і не абрыдзіць вам, бо вы адвярнуліся ад ГОСПАДА, Які сярод вас, і наракалі перад абліччам Ягоным, кажучы: ‘Навошта выйшлі мы з Эгіпту?’”» ");
INSERT INTO bel_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","І сказаў Майсей: «Шэсьцьсот тысячаў пешых у народзе гэтым, пасярод якога я жыву, а Ты кажаш: “Я дам ім мяса, і будуць есьці цэлы месяц”? ");
INSERT INTO bel_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ці ж усе авечкі і валы будуць забітыя для іх, каб ім хапіла? Або ці ўсе рыбы ў моры будуць сабраныя для іх, каб ім хапіла?» ");
INSERT INTO bel_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","І сказаў ГОСПАД Майсею: «Ці ж рука ГОСПАДА скарацілася? Цяпер убачыш, ці слова Маё споўніцца, ці не». ");
INSERT INTO bel_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","І выйшаў Майсей, і прамовіў да народу словы ГОСПАДА, і склікаў семдзясят старшыняў народу, і паставіў іх вакол Намёту. ");
INSERT INTO bel_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","І ГОСПАД зыйшоў у воблаку, і гаварыў з ім, і ўзяў з духа, які быў на Майсею, і даў сямідзесяці старшыням. І сталася, што дух супачыў на іх, і яны прарочылі, і перасталі. ");
INSERT INTO bel_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","А два чалавекі засталіся ў табары, імя аднаго Эльдад, а другога — Мэдад. І на іх зыйшоў дух, бо былі яны пакліканыя, але не пайшлі ў Намёт. І яны прарочылі ў табары. ");
INSERT INTO bel_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","І прыбег юнак, і паведаміў Майсею, і сказаў: «Эльдад і Мэдад прарочаць у табары». ");
INSERT INTO bel_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","І адказаў Егошуа, сын Нуна, які ад юнацтва свайго быў на паслузе ў Майсея: «Гаспадару мой, Майсей, забарані ім!» ");
INSERT INTO bel_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Але Майсей сказаў яму: «Ці не зайздросны ты замест мяне? Каб жа ўвесь народ так прарочыў, калі дасьць ім ГОСПАД Духа Свайго!» ");
INSERT INTO bel_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","І вярнуліся ў табар Майсей і старшыні Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","І зыйшоў вецер ад ГОСПАДА, і прынёс ад мора перапёлак, і кінуў іх на табар з абодвух бакоў на дзень дарогі, і пакрылі яны аблічча зямлю на два локці вышыні. ");
INSERT INTO bel_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","І ўстаў народ, і ўвесь той дзень і ўсю ноч, і ўвесь наступны дзень зьбіралі перапёлак; хто мала сабраў, прынёс ня менш дзесяці гомараў; і разлажылі іх навакол табару. ");
INSERT INTO bel_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Яшчэ мяса было ў зубах іхніх і не было яшчэ зьедзена, калі ўзгарэўся гнеў ГОСПАДА супраць народу і ўдарыў ГОСПАД народ плягаю вельмі вялікай. ");
INSERT INTO bel_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","І назвалі імя таго месца Кіброт-Гатава, бо там пахавалі прагавіты народ. ");
INSERT INTO bel_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","З Кіброт-Гатавы выйшаў народ у Хацэрот і былі там. ");
INSERT INTO bel_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","І гаварылі Мірыям і Аарон супраць Майсея з прычыны жанчыны Кушанкі, якую ён узяў за жонку, ");
INSERT INTO bel_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","і казалі: «Ці ж толькі да Майсея прамаўляў ГОСПАД? Ці таксама да нас Ён не прамаўляў?» І пачуў гэта ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","А Майсей быў чалавекам пакорным, больш за ўсіх людзей, якія на зямлі. ");
INSERT INTO bel_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","І сказаў раптам ГОСПАД да Майсея, і да Аарона, і да Мірыям: «Вы трох падыйдзіце да Намёту Спатканьня». І падыйшлі ўсе трое. ");
INSERT INTO bel_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","І ГОСПАД зыйшоў у слупе воблачным, і затрымаўся каля ўваходу ў Намёт, і паклікаў Аарона і Мірыям, і ўвайшлі яны абое. ");
INSERT INTO bel_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","І Ён сказаў ім: «Слухайце словы Мае. Калі бу­дзе ў вас прарок ГОСПАДА, Я аб’яўлюся яму ў відзежы, і ў снах буду прамаўляць да яго. ");
INSERT INTO bel_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ня так са слугой Маім Майсеем, ён — верны ў-ва ўсім доме Маім! ");
INSERT INTO bel_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Вуснамі ў вусны Я прамаўляю да яго, і адкрыта, а не ў загадках, і ён бачыць ГОСПАДА! Дык чаму адважыліся вы прамаўляць супраць слугі Майго Майсея?» ");
INSERT INTO bel_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","І запалаў гнеў ГОСПАДА супраць іх, і Ён адыйшоў. ");
INSERT INTO bel_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","І воблака адыйшло ад Намёту. І вось, Мірыям сталася белая, як сьнег, ад праказы. І павярнуўся Аарон да Мірыям, і вось, яна пракажоная. ");
INSERT INTO bel_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","І сказаў Аарон Майсею: «Прашу, гаспадару мой, не карай нас за грэх, якога мы неразважна дапусьціліся і якім саграшылі. ");
INSERT INTO bel_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Няхай ня будзе яна, як спарон, які напалову гнілы выходзіць з улоньня маці сваёй». ");
INSERT INTO bel_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","І клікаў Майсей да ГОСПАДА, кажучы: «Божа, прашу Цябе, аздараві яе!» ");
INSERT INTO bel_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","І сказаў ГОСПАД Майсею: «Калі б бацька яе плюнуў ёй у твар, ці ня мусіла б яна сем дзён саромецца? Так мае яна на сем дзён быць па-за табарам, а потым вернецца». ");
INSERT INTO bel_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","І выдалена была Мірыям па-за табар на сем дзён, і народ не выходзіў у дарогу, пакуль Мірыям не вярнулася. ");
INSERT INTO bel_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Пасьля народ выйшаў з Хацэроту і стаў табарам у пустыні Паран. ");
INSERT INTO bel_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Пашлі людзей, і яны выведаюць зямлю Ханаан, якую Я даю сынам Ізраіля, па адным з кожнага пакаленьня бацькоў іхніх, вышліце ўсіх князёў сярод іх». ");
INSERT INTO bel_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","І паслаў іх Майсей з пустыні Паран паводле слова з вуснаў ГОСПАДА, а ўсе яны галовы сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Вось імёны іхнія: з пакаленьня Рубэна — Шамуа, сын Закура; ");
INSERT INTO bel_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","з пакаленьня Сымона — Шафат, сын Хоры; ");
INSERT INTO bel_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","з пакаленьня Юды — Халеў, сын Ефунны; ");
INSERT INTO bel_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","з пакаленьня Ісахара — Ігаль, сын Язэпа; ");
INSERT INTO bel_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","з пакаленьня Эфраіма — Ошэа, сын Нуна; ");
INSERT INTO bel_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","з пакаленьня Бэн’яміна — Пальты, сын Рафу; ");
INSERT INTO bel_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","з пакаленьня Завулёна — Гадыэль, сын Соды, ");
INSERT INTO bel_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","з пакаленьня Язэпа, пакаленьня Манасы — Гады, сын Сусі, ");
INSERT INTO bel_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","з пакаленьня Дана — Аміэль, сын Гемальлі, ");
INSERT INTO bel_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","з пакаленьня Асэра — Сэтур, сын Міхаэля, ");
INSERT INTO bel_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","з пакаленьня Нэфталі — Нахбі, сын Вафсі, ");
INSERT INTO bel_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","з пакаленьня Гада — Геўэль, сын Махі. ");
INSERT INTO bel_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Гэта вось імёны мужчынаў, якіх паслаў Майсей для выведваньня зямлі Ханаан. І Ошэа, сына Нуна, назваў Майсей Егошуа. ");
INSERT INTO bel_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","І паслаў іх Майсей дзеля выведваньня зямлі Ханаан, і сказаў ім: «Ідзіце праз Нэгеў, і прыйдзеце ў горы, ");
INSERT INTO bel_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","і разгледзьце зямлю, якая яна, і народ, які жыве на ёй, ці моцны ён, ці кволы, ці нямногія лікам, ці шматлікія? ");
INSERT INTO bel_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","І якая зямля, на якой яны жывуць, ці добрая, ці ліхая? Якія гарады, у якіх яны жывуць, ці як табар, ці з мурамі? ");
INSERT INTO bel_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","І якая зямля, ці ўрадлівая, ці пустая, ці ёсьць там дрэвы, ці няма іх? Будзьце мужныя і прынясіце пладоў той зямлі». А былі тады дні дасьпяваньня вінаграду. ");
INSERT INTO bel_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","І яны пайшлі, і выведалі зямлю ад пустыні Сін аж па Рэхоб каля ўваходу ў Хамат. ");
INSERT INTO bel_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","І дайшлі да Нэгеву, а адтуль прыйшлі ў Хеўрон, дзе жылі Ахіман, Шэшай і Тальмай, нашчадкі Анака. А Хеўрон пабудаваны на сем гадоў раней, чым Цаан у Эгіпце. ");
INSERT INTO bel_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","І дайшлі яны аж да даліны Эшколь, там зрэзалі галінку з адной гронкай вінаграду, якую несьлі на жэрдцы два чалавекі, ўзялі яблыкаў гранатовых і фігаў. ");
INSERT INTO bel_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","І назвалі месца тое далінай Эшколь, таму што адтуль сыны Ізраіля несьлі гронку вінаграду. ");
INSERT INTO bel_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","І вярнуліся выведчыкі зямлі праз сорак дзён. ");
INSERT INTO bel_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","І ішлі, і прыйшлі да Майсея і Аарона, і да ўсёй грамады сыноў Ізраіля ў пустыню Паран, у Кадэш. І зьвярнулі словы да іх і да ўсёй грамады, і паказалі ім плады той зямлі. ");
INSERT INTO bel_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","І расказвалі ім, і сказалі: «Мы прыйшлі ў зямлю, у якую ты паслаў нас, якая сапраўды ацякае малаком і мёдам, і такія плады ейныя. ");
INSERT INTO bel_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Але народ, які жыве на ёй, дужы, і гарады вельмі вялікія і ўмацаваныя. Бачылі мы там таксама нашчадкаў Анака. ");
INSERT INTO bel_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Амалекцы жывуць у зямлі Нэгеў; Хеты, Евусэі і Амарэйцы жывуць у гарах, а Хананейцы жывуць каля мора і на беразе Ярдану». ");
INSERT INTO bel_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","І Халеў супакойваў абу­рэньне народу супраць Майсея, і казаў: «Пойдзем і здабудзем зямлю, бо мы можамавалодаць ёю». ");
INSERT INTO bel_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","А іншыя, якія хадзілі з ім, казалі: «Ня зможам мы ваяваць з тым народам, бо ён дужэйшы за нас». ");
INSERT INTO bel_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","І гаварылі ліхія весткі пра зямлю, якую аглядалі, паміж сыноў Ізраіля, кажучы: «Зямля, якую мы прайшлі, каб выведаць яе, пажырае жыхароў сваіх, а ўвесь народ, які мы бачылі ў ёй, — высокага росту. ");
INSERT INTO bel_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Бачылі мы там нэфілімаў, сыноў Анака, з роду нэфілімаў, і ў вачах нашых мы былі як саранча, і такімі ж мы былі ў вачах іхніх». ");
INSERT INTO bel_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","І ўстала ўся грамада, і ўзьняла голас свой, і плакаў народ у тую ноч, ");
INSERT INTO bel_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","і наракалі на Майсея і Аарона ўсе сыны Ізраіля, і ўся грамада казала: «Лепш, каб мы памерлі ў Эгіпце, або ў пустыні гэтай. ");
INSERT INTO bel_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Навошта завёў нас ГОСПАД у зямлю гэтую, каб мы загінулі ад мяча, а жонкі нашыя і дзеці нашыя пайшлі ў палон? Ці ня лепш нам вярнуцца ў Эгіпет?» ");
INSERT INTO bel_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","І казалі адзін аднаму: «Паставім сабе правадыра і вернемся ў Эгіпет». ");
INSERT INTO bel_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","І ўпалі Майсей і Аарон на абліччы свае перад усёй царквою грамады сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","А Егошуа, сын Нуна, і Халеў, сын Ефунны, якія былі сярод выведнікаў зямлі, разь­дзёрлі шаты свае ");
INSERT INTO bel_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","і сказалі ўсёй грамадзе сыноў Ізраіля, кажучы: «Зямля, якую мы абыйшлі, каб выве­даць яе, вельмі, вельмі добрая. ");
INSERT INTO bel_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Калі ласкавы будзе ГОСПАД, Ён увядзе нас у зямлю гэтую і дасьць нам зямлю, якая ацякае малаком і мёдам. ");
INSERT INTO bel_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Не бунтуйцеся супраць ГОСПАДА і ня бойцеся народу той зямлі, бо яны як хлеб для нас. Адыйшла абарона іхняя ад іх, а з намі ГОСПАД. Ня бойцеся іх». ");
INSERT INTO bel_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","І казала ўся грамада, каб закідаць іх камянямі, але над Намётам Спатканьня зьявілася слава ГОСПАДА перад усімі сынамі Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","І сказаў ГОСПАД Майсею: «Дакуль будзе зьнева­жаць Мяне народ гэты? Дакуль ня будзе ён верыць усім знакам, якія Я ўчыніў сярод іх? ");
INSERT INTO bel_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Я наведаю яго пошасьцю і зьнішчу яго. А з цябе Я зраблю вялікі народ, мацнейшы за яго». ");
INSERT INTO bel_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","І сказаў Майсей ГОСПАДУ: «І пачуюць Эгіпцяне, ад якіх Ты вывеў народ гэты магутнасьцю Тваёй, ");
INSERT INTO bel_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","і скажуць жыхарам зямлі, якія чулі, што Ты, ГОСПА­ДЗЕ, пасярод народу гэтага, якому даеш бачыць Сябе вачамі, і воблака Тваё стаіць над імі, і Ты ідзеш перад імі ўдзень у слупе воблачным, а ўначы — у слупе вогненным. ");
INSERT INTO bel_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Калі народ гэты выб’еш да апошняга чалавека, скажуць народы, якія пра гэта пачу­юць, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“ГОСПАД ня змог увесьці народ у зямлю, якую ім запрысяг, дзеля таго Ён зьнішчыў іх у пустыні!” ");
INSERT INTO bel_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","А цяпер няхай праславіцца моц Госпада, як Ты прамовіў, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“ГОСПАД павольны да гневу і бязьмежнай міласэрнасьці, Які прабачае правіны і беззаконьні і не пакідае без пакараньня, але карае беззаконьні бацькоў на сынах да трэцяга, а нават да чацьвёртага пакаленьня”. ");
INSERT INTO bel_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Даруй, прашу, правіну народу гэтаму дзеля вялікай міласэрнасьці Тваёй, як Ты насіў народ гэты ад Эгіпту аж дасюль». ");
INSERT INTO bel_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","І сказаў ГОСПАД: «Я прабачаю паводле слова твайго. ");
INSERT INTO bel_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Але, як Я жывы, слава ГОСПАДА напоўніць усю зямлю! ");
INSERT INTO bel_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Усе людзі, якія бачылі славу Маю і знакі Мае, якія Я рабіў у Эгіпце і ў пустыні, але спакушалі Мяне ўжо дзесяць разоў і ня слухалі голасу Майго, ");
INSERT INTO bel_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","не пабачаць яны зямлі, якую Я абяцаў бацькам іхнім, і ніхто з тых, хто зьневажаў Мяне, ня ўбачыць яе. ");
INSERT INTO bel_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Але слугу Майго Халева, бо ён напоўнены іншым духам, Я ўвяду ў тую зямлю, у якую ён ужо ўвайшоў, і насеньне ягонае авалодае ёю. ");
INSERT INTO bel_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Няхай Амалек і Хананейцы жывуць у далінах. Заўтра выйдзеце ў дарогу і вернецеся ў пустыню ў накірунку Мора Чырвонага». ");
INSERT INTO bel_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Дакуль гэтая грамада ліхая будзе наракаць на Мяне? Я пачуў нараканьні сыноў Ізраіля, якімі яны наракаюць супраць Мяне. ");
INSERT INTO bel_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Скажы ім: “Як жывы Я, кажа ГОСПАД. Як вы гаварылі, гэтак Я зраблю вам! ");
INSERT INTO bel_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","У гэтай пустыні папада­юць трупы вашыя! Усе палічаныя, якія наракалі на Мяне, ад дваццаці гадоў і вышэй, паводле падліку. ");
INSERT INTO bel_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ня ўвойдзеце вы ў зямлю, на якой Я, падымаючы руку Маю, запрысяг пасяліць вас, апрача Халева, сына Ефунны, і Егошуа, сына Нуна. ");
INSERT INTO bel_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","А дзяцей вашых, пра якіх вы казалі, што яны будуць здабычай, Я ўвяду, і яны авалодаюць зямлёю, якою вы ўзгардзілі. ");
INSERT INTO bel_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","А трупы вашыя будуць ляжаць у пустыні гэтай. ");
INSERT INTO bel_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","І сыны вашыя будуць блукаць у пустыні сорак гадоў і будуць насіць нявернасьць вашую, пакуль ня счэзнуць трупы вашыя ў пустыні. ");
INSERT INTO bel_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Па ліку сарака дзён, на працягу якіх аглядалі вы зямлю, дзень будзе залічаны за год, сорак гадоў вы будзеце насіць беззаконьне вашае і даведаецеся, што такое, калі Я пакінуў вас. ");
INSERT INTO bel_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Я, ГОСПАД, прамовіў і гэтак зраблю гэтай грамадзе ліхой, якая бунтуецца супраць Мяне. У гэтай пустыні вы загінеце і памрацё”». ");
INSERT INTO bel_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","І тыя людзі, якіх паслаў Майсей на выведваньне зямлі, і якія, вярнуўшыся, наракалі і схілілі ўсю грамаду да нараканьня, даючы ліхія весткі пра зямлю, ");
INSERT INTO bel_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","тыя, што разносілі ліхія весткі пра зямлю тую, памерлі раптоўна перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Але Егошуа, сын Нуна, і Халеў, сын Ефунны, засталіся жывымі з усіх тых людзей, якія хадзілі выведваць зямлю. ");
INSERT INTO bel_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","І прамовіў Майсей усе гэтыя словы да ўсіх сыноў Ізраіля, і народ вельмі засмуціўся. ");
INSERT INTO bel_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","І ўсталі яны раніцаю, і ўзыйшлі на вяршыню гары, кажучы: «Вось мы, і мы пойдзем на месца, пра якое казаў ГОСПАД, бо мы саграшылі». ");
INSERT INTO bel_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","І сказаў Майсей: «Навошта вы пераступаеце слова з вуснаў ГОСПАДА? Гэта ня будзе мець посьпеху. ");
INSERT INTO bel_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Не ідзіце, бо няма ГОСПАДА з вамі, каб не пагінулі вы перад абліччам ворагаў вашых! ");
INSERT INTO bel_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Бо Амалек і Хананейцы перад вамі, ад мяча іхняга вы пагінеце, бо вы адвярнуліся ад ГОСПАДА, і ня будзе з вамі ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Але яны вырашылі ўзыйсьці на вяршыню гары; а Каўчэг Запавету ГОСПАДА і Майсей ня выйшлі з табару. ");
INSERT INTO bel_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","І зыйшлі Амалекцы і Хананейцы, якія жылі на гары, і разьбілі іх, і гналі іх аж да Хармы. ");
INSERT INTO bel_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Прамоў да сыноў Ізраіля і скажы ім: “Калі ўвойдзеце ў зямлю пражываньня вашага, якую Я даю вам, ");
INSERT INTO bel_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","і будзеце складаць ахвяры ГОСПАДУ, цэласпаленьні або ахвяры крывавыя, або як спаўненьне шлюбаваньняў, або дабраахвотныя, або пры ўрачыстасьцях вашых, каб прынесьці мілы пах ГОСПАДУ з валоў ці з авечак, ");
INSERT INTO bel_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","тады той, хто прыносіць дар ахвярны ГОСПАДУ, прынясе ў ахвяру хлебную адну дзясятую эфы пшанічнай мукі, запраўленай адной чацьвёртай гіну алею. ");
INSERT INTO bel_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","І віна як ахвяру вадкую дасьць разам з ахвярай цэласпаленьня або з ахвярай крывавай чацьвёртую частку гіну на кожнае ягня. ");
INSERT INTO bel_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","А разам з ахвярай з барана складзеш як ахвяру хлебную дзьве трэці эфы пшанічнай мукі, запраўленай адной трэцяй гіну алею, ");
INSERT INTO bel_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","і віна як ахвяру вадкую адну траціну гіну прынясеш на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Калі складаеш у ахвяру цяля на цэласпаленьне або ў ахвяру крывавую як спаўненьне шлюбаваньня, або ў ахвяру мірную для ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","дасі разам з цялём у ахвяру хлебную тры дзясятыя часткі эфы пшанічнай мукі, запраўленай паловай гіну алею, ");
INSERT INTO bel_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","а ў ахвяру вадкую дасі палову гіну віна. Гэта ахвяра агнявая на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Так трэба рабіць пры кожнай ахвяры з цяляці, або барана, або ягняці як з авечак, так і з козаў. ");
INSERT INTO bel_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Паводле ліку ахвяраў, якія вы складаеце, так рабіце пры кожнай, паводле лічбы іх. ");
INSERT INTO bel_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Кожны тутэйшы так павінен рабіць гэта, складаючы ахвяру агнявую на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","А калі нейкі прыхадзень, які ў вас, або які шмат пакаленьняў сярод вас, складзе ахвяру агнявую на мілы пах ГОСПАДУ, павінен складаць яе, як і вы. ");
INSERT INTO bel_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Пастанова царкоўная адна і для вас, і для прыхадняў у-ва ўсе пакаленьні вашыя; як вы, так і прыхадзень будзе перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Адзін закон і адзін суд будзе як для вас, так і для прыхадняў, якія жывуць у вас”». ");
INSERT INTO bel_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Прамоў да сыноў Ізраіля і скажы ім: “Калі вы прыйдзеце ў зямлю, у якую Я заводжу вас, ");
INSERT INTO bel_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","і калі будзеце есьці хлеб той зямлі, выдзяліце дар для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Пяршыны цеста вашага печыва прынясіце як дар, як дар з току прынясіце яго. ");
INSERT INTO bel_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Будзеце складаць пяршыны цеста вашага як дар для ГОСПАДА ў-ва ўсе пакаленьні вашыя. ");
INSERT INTO bel_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Калі праз няведаньне вы ня споўніце ўсіх гэтых прыказаньняў, якія прамовіў ГОСПАД да Майсея, ");
INSERT INTO bel_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","таго ўсяго, што загадаў вам ГОСПАД праз Майсея, ад дня, у які ГОСПАД загадаў гэта, і праз усе пакаленьні вашыя, ");
INSERT INTO bel_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","і станецца, што перад вачыма грамады будзе зроблена гэта занядбаньне, павінна ўся грамада скласьці цяля ў ахвяру цэласпаленьня на мілы пах ГОСПАДУ, адпаведную ахвяру хлебную і ахвяру вадкую, і казла ў ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","І перамоліць сьвятар за ўсю грамаду сыноў Ізраіля, і бу­дзе ім адпушчана, бо было гэта зроблена па няведаньні, і яны прынесьлі свой дар ахвярны, ахвяру агнявую для ГОСПАДА, і ахвяру за грэх перад абліччам ГОСПАДА за занядбаньне сваё. ");
INSERT INTO bel_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","І будзе адпушчана ўсёй грамадзе сыноў Ізраіля і прыхадням, якія жывуць сярод іх, бо гэта занядбаньне ўсяго народу. ");
INSERT INTO bel_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Калі адна душа саграшыць занядбаньнем, няхай прынясе аднагадовую казу ў ахвяру за грэх. ");
INSERT INTO bel_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","І сьвятар перапросіць за душу, якая праз занядбаньне саграшыла перад абліччам ГОСПАДА, і будзе за яе перапрошана, і будзе адпушчана ёй. ");
INSERT INTO bel_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Адзін закон будзе для ўсіх, як для тутэйшых спасярод сыноў Ізраіля, так і для прыхадняў, якія жывуць сярод вас, адносна таго, што рабіць пры занядбаньні. ");
INSERT INTO bel_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","А калі душа з тутэйшых або з прыхадняў зробіць з узьнятай рукой зьнявагу ГОСПАДУ, будзе вынішчана душа тая спаміж народу свайго, ");
INSERT INTO bel_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","бо яна пагардзіла словам ГОСПАДА і парушыла прыказаньне Ягонае. Такая душа будзе вынішчаная, і беззаконьне ейнае будзе на ёй”». ");
INSERT INTO bel_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","І былі сыны Ізраіля ў пустыні, і знайшлі яны чалавека, які зьбіраў дровы ў дзень суботы. ");
INSERT INTO bel_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","І прывялі яго тыя, кія знайшлі яго, да Майсея і Аарона, і да ўсёй грамады. ");
INSERT INTO bel_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Яны пакінулі яго пад вартай, бо ня ведалі, што з ім зрабіць. ");
INSERT INTO bel_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","І сказаў ГОСПАД Майсею: «Гэты чалавек сьмерцю памрэ. Няхай уся грамада ўкамянуе яго па-за табарам». ");
INSERT INTO bel_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","І вывела яго ўся грамада па-за табар, і ўкаменавалі яго, як загадаў ГОСПАД Майсею, і ён памёр. ");
INSERT INTO bel_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","І сказаў ГОСПАД Майсею, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Прамоў да сыноў Ізраіля і скажы ім, каб яны зрабілі сабе фрэнзьлі на краях шатаў сваіх і нашчадкаў сваіх і ўклалі ў іх ніткі з блакіту. ");
INSERT INTO bel_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","І будзе, калі ўбачыце фрэнзлі вашыя, узгадаеце ўсе прыказаньні ГОСПАДА, каб выканаць іх і каб не ісьці вам за пажаданьнямі сэрца вашага і вачэй вашых, якія валакуць вас у распуснасьць, ");
INSERT INTO bel_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","каб вы памяталі і каб выконвалі ўсе прыказаньні Мае, і будзеце сьвятымі перад Богам вашым. ");
INSERT INTO bel_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Я — ГОСПАД, Бог ваш, Які вывеў вас з зямлі Эгіпецкай, каб быць Богам вашым. Я — ГОСПАД, Бог ваш!» ");
INSERT INTO bel_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","І ўзяліся Карах, сын Іцгара, сына Кегата, сына Левія, і Датан і Абірам, сыны Эліява, і Он, сын Пэлета, з сыноў Рубэна, ");
INSERT INTO bel_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","і паўсталі перад абліччам Майсея, і з імі мужы з сыноў Ізраіля, дзьвесьце пяцьдзясят чалавек, начальнікі грамады, прадстаўнікі народу, лю­дзі слаўныя. ");
INSERT INTO bel_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","І выступілі яны супраць Майсея і супраць Аарона, і сказалі ім: «Досыць вам, бо ўся грамада, усе — сьвятыя, і пасярод іх ёсьць ГОСПАД. Дык чаму вы ставіце сябе вышэй царквы ГОСПАДА?» ");
INSERT INTO bel_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","І пачуў гэта Майсей, і ўпаў на аблічча сваё. ");
INSERT INTO bel_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","І прамовіў да Караха і да ўсёй грамады, кажучы: «Заўтра пакажа ГОСПАД, хто да Яго належыць, і хто сьвяты, і каго наблізіць да Сябе; і каго Ён выбраў, таго Ён наблізіць да Сябе. ");
INSERT INTO bel_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Вось што зрабіце. Няхай Карах і ўся грамада ягоная возьмуць кадзільніцы свае, ");
INSERT INTO bel_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","і няхай у іх укладуць агонь, і заўтра пакладуць у іх кадзіла перад абліччам ГОСПАДА, і каго выбярэ ГОСПАД, той сьвяты. Досыць вам, сыны Левія». ");
INSERT INTO bel_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","І сказаў Майсей Караху: «Слухайце, сыны Левія! ");
INSERT INTO bel_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ці мала вам, што Бог Ізраіля аддзяліў вас ад грамады Ізраіля, і выбраў вас Сабе, каб вы служылі Яму ў Сялібе ГОСПАДА, і каб стаялі перад абліччам грамады, паслугуючы Госпаду? ");
INSERT INTO bel_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","І Ён даў наблізіцца да Сябе табе і ўсім братам тваім, сынам Левія. А вы дамагаецеся яшчэ сьвятарства? ");
INSERT INTO bel_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Навошта ты і ўся грамада твая злучыліся супраць ГОСПАДА? Хто такі Аарон, што вы наракаеце супраць яго?» ");
INSERT INTO bel_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","І паслаў Майсей паклікаць Датана і Абірама, сыноў Эліява, але яны сказалі: «Ня пойдзем! ");
INSERT INTO bel_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ці мала табе, што ты вывеў нас з зямлі, якая ацякае малаком і мёдам, каб выгубіць нас у пустыні, і яшчэ хочаш панаваць над намі? ");
INSERT INTO bel_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Але ж ты ня ўвёў нас у зямлю, якая ацякае малаком і мёдам, і ня даў нам на ўласнасьць палёў і вінаграднікаў! Хочаш вочы людзей засьляпіць? Ня пойдзем!» ");
INSERT INTO bel_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","І надта разгневаўся Майсей, і сказаў ГОСПАДУ: «Не прыймай ахвяры іхняй! У ніводнага з іх я ня ўзяў нават асла, і нікога з іх я не пакрыўдзіў». ");
INSERT INTO bel_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","І сказаў Майсей Караху: «Заўтра ты і ўся грамада твая няхай стане перад абліччам ГОСПАДА, ты з імі, і Аарон асобна. ");
INSERT INTO bel_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","І няхай возьме кожны ка­дзільніцу сваю і пакладзе ў іх кадзіла, і прынясе перад аблічча ГОСПАДА кожны кадзільніцу сваю, дзьвесьце пяцьдзясят кадзільніцаў; і ты, і Аарон кожны кадзільніцу сваю». ");
INSERT INTO bel_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","І кожны ўзяў кадзільніцу сваю, уклаў у яе агонь, і насыпаў кадзіла, і сталі яны каля ўваходу ў Намёт Спатканьня, сталі таксама Майсей і Аарон. ");
INSERT INTO bel_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","І сабраў Карах суп­раць іх усю грамаду каля ўваходу ў Намёт Спатканьня. І зьявілася ўсёй грамадзе слава ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Адлучыцеся ад грамады гэтай, Я іх зьнішчу ў момант». ");
INSERT INTO bel_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","І яны ўпалі на абліччы свае, і сказалі: «Божа, Божа, Які даеш дух усякаму целу, ці будзеш гневацца на ўсю грамаду, калі толькі адзін чалавек саграшыў?» ");
INSERT INTO bel_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Прамоў да грамады, кажучы: “Адыйдзіце ад жытлаў Караха, Датана і Абірама”». ");
INSERT INTO bel_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","І ўстаў Майсей, і пайшоў да Датана і Абірама, і старшыні Ізраіля пайшлі за ім. ");
INSERT INTO bel_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","І прамовіў ён да грамады, кажучы: «Адыйдзіце ад намётаў гэтых бязбожных людзей! І не дакранайцеся нічога, што да іх належыць, каб вы не пагінулі праз усе грахі іхнія!» ");
INSERT INTO bel_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","І адыйшліся ўсе ад сялібаў Караха, Датана і Абірама. А Датан і Абірам выйшлі і сталі перад уваходам у намёты свае разам з жонкамі сваімі, сынамі і малымі дзецьмі. ");
INSERT INTO bel_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","І сказаў Майсей: «З гэтага даведаецеся, што ГОСПАД паслаў мяне, каб чыніў усе гэтыя справы і што гэта не з майго сэрца выйшла. ");
INSERT INTO bel_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Калі гэтыя людзі памруць, як усе людзі паміраюць, і калі лёс іхні будзе такі, які і ў кожнага чалавека, ГОСПАД не паслаў мяне. ");
INSERT INTO bel_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","А калі ГОСПАД ство­рыць незвычайнае, і зямля разявіць пашчу сваю, і праглыне іх і ўсё, што да іх належыць, і жывыя трапяць яны ў адхлань, ведайце, што яны зьневажалі ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","І сталася, калі ён скончыў прамаўляць слова, расчынілася зямля пад нагамі іхнімі, ");
INSERT INTO bel_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","і разявіла зямля пашчу сваю, і праглынула іх, і дамы іхнія, і ўсіх людзей, якія з Карахам, і ўсю маёмасьць іхнюю. ");
INSERT INTO bel_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","І так жывыя трапілі яны і ўсё, што ў іх, у адхлань, і зямля накрыла іх, і так былі яны вынішчаныя спаміж царквы. ");
INSERT INTO bel_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","А ўсе Ізраільцяне, якія стаялі навокал, пачуўшыкрык іхні, паўцякалі, кажучы: «Каб і нас зямля не праглынула». ");
INSERT INTO bel_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","І выйшаў агонь ад ГОСПАДА, і спаліў дзьвесьце пяцьдзясят чалавек, якія ахвяроўвалі кадзіла. ");
INSERT INTO bel_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Скажы Элеазару, сыну Аарона сьвятара, каб сабраў з пажарышча кадзільніцы, а агонь з іх няхай выкіне далёка, бо яны асьвячоныя. ");
INSERT INTO bel_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","А з кадзільніцаў тых, якія саграшылі супраць душаў сваіх, няхай зробяць тонкія бляхі на пакрыцьцё ахвярніка, бо іх прынесьлі перад аблічча ГОСПАДА, і яны асьвячоныя, і будуць яны знакам для сыноў Ізраіля». ");
INSERT INTO bel_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","І ўзяў Элеазар сьвятар ка­дзільніцы мядзяныя, якія прынесьлі тыя, што былі спалены, і перарабілі іх на бляху на пакрыцьцё ахвярніка, ");
INSERT INTO bel_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","як напамін для сыноў Ізраіля, каб ніхто чужы, які не належыць да насеньня Ааро­на, не прыносіў кадзіла перад аб­лічча ГОСПАДА і ня стала­ся з ім тое, што з Карахам і супольнікамі ягонымі, як прамо­віў да яго ГОСПАД праз Майсея. ");
INSERT INTO bel_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Назаўтра ўся грамада сыноў Ізраіля наракала на Майсея і Аарона, кажучы: «Вы забілі народ ГОСПАДАЎ». ");
INSERT INTO bel_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","І сталася, калі сабралася грамада супраць Майсея і Аарона, яны накіраваліся да Намёту Спатканьня. І вось, воблака ахутала Намёт, і зьявілася слава ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","І прыйшлі Майсей і Аарон перад Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Адыйдзіцеся ад грамады гэтай, і Я зьнішчу іх у момант». А яны ўпалі на абліччы свае. ");
INSERT INTO bel_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","І сказаў Майсей Аарону: «Вазьмі кадзільніцу і ўлажы ў яе агонь з ахвярніка, улажы кадзіла, і пабяжы хутка да грамады, і перамольвай за яе, бо ўзгарэўся гнеў ГОСПАДА і пачалася пляга». ");
INSERT INTO bel_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","І зрабіў Аарон, як сказаў Майсей, і прыбег да царквы, і вось, ужо пачалася пляга сярод народу. І ён палажыў кадзіла, і перамольваў за народ. ");
INSERT INTO bel_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","І ён стаў паміж памёршымі і жывымі, і пляга спынілася. ");
INSERT INTO bel_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","А тых, што згінула ад плягі гэтай, было чатырнаццаць тысячаў семсот, апрача памёршых з прычыны Караха. ");
INSERT INTO bel_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","І вярнуўся Аарон да Майсея да ўваходу ў Намёт Спатканьня, і спынілася пляга. ");
INSERT INTO bel_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Прамоў да сыноў Ізраіля і вазьмі ад іх па кію, кій паводле дому бацькоў іхніх, ад усіх князёў паводле дому бацькоў іхніх, дванаццаць кіёў. Імя кожнага напішы на кіі ягоным. ");
INSERT INTO bel_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","А на кіі Левія напішы імя Аарона, бо павінна быць па адным кіі на князя дому бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","І палажы іх у Намёце Спатканьня перад Каўчэгам Сьведчаньня, дзе Я сустракаюся з табою. ");
INSERT INTO bel_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","І станецца, што каго з іх Я абяру, таго кій заквітнее, і Я спыню нараканьні сыноў Ізраіля супраць Мяне, якімі яны наракаюць вам». ");
INSERT INTO bel_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","І прамовіў Майсей да сыноў Ізраіля, і далі яму ўсе князі кіі ад князя дому бацькоў сваіх, адзін кій ад князя, дванаццаць кіёў, і кій Аарона паміж іх. ");
INSERT INTO bel_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Гэтыя кіі палажыў Майсей перад абліччам ГОСПАДА ў Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","І сталася назаўтра, і ўвайшоў Майсей у Намёт Спатканьня, і вось, заквітнеў кій Аарона з дому Левія, і выпусьціў пупышкі, закрасаваў і вырасьлі сьпелыя мігдалы. ");
INSERT INTO bel_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","І вынес Майсей ад аблічча ГОСПАДА ўсе кіі да ўсіх сыноў Ізраіля, і яны ўбачылі, і кожны ўзяў кій свой. ");
INSERT INTO bel_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","І сказаў ГОСПАД Майсею: «Кій Аарона палажы назад перад Каўчэгам Сьведчаньня, каб захаваўся як знак суп­раць сыноў бунту і каб спыніліся нараканьні супраць Мяне, і яны не памруць». ");
INSERT INTO bel_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","І зрабіў Майсей, як загадаў яму ГОСПАД, так і зрабіў. ");
INSERT INTO bel_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","І сказалі сыны Ізраіля Майсею, кажучы: «Вось, мы гінем, паміраем, усе паміраем! ");
INSERT INTO bel_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Усе, хто набліжаюцца да Сялібы ГОСПАДА, паміраюць. Ці ж мы, паміраючы, будзем вынішчаны?» ");
INSERT INTO bel_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","І сказаў ГОСПАД Ааро­ну: «Ты і сыны твае, і дом бацькі твайго з табой будзеце насіць віну за беззаконьні адносна Сялібы. Ты і сыны твае будзеце насіць віну за беззаконьні адносна сьвятарства вашага. ");
INSERT INTO bel_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Таксама браты твае, пакаленьне Левія, племя бацькі твайго, няхай наблізяцца да цябе і дапамагаюць табе; а ты і сыны твае з табою будзеце пры Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","І будуць яны захоўваць тое, што патрэбнае для цябе і для Сялібы, але да сьвятых рэчаў і да ахвярніка ня будуць яны набліжацца, каб не памерлі ані яны, ані вы. ");
INSERT INTO bel_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","І будуць яны пры табе і будуць захоўваць усё адносна Намёту Спатканьня, усю службу пры Сялібе, але ніводзін чужынец ня будзе набліжацца да вас. ");
INSERT INTO bel_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","І вы будзеце захоўваць службу пры сьвятыні і пры ахвярніку, каб не было больш гневу на сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Вось, Я ўзяў братоў вашых, лявітаў, спасярод сыноў Ізраіля і даў іх як дар ГОСПАДУ, каб яны выконвалі служэньне ў Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","А ты і сыны твае з табою будзеце захоўваць сьвятарства вашае і ўсё, што належыць да ахвярніка і месца за заслонай. Я даю вам як дар сьвятарства вашае, а калі чужынец наблізіцца да яго, памрэ». ");
INSERT INTO bel_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","І прамовіў ГОСПАД да Аарона: «Вось, Я даю табе нагляд за дарамі Маімі. Усе дары, якія пасьвячаюць Мне сыны Ізраіля, Я даю табе і сынам тваім за служэньне сьвятарскае як пастанову вечную. ");
INSERT INTO bel_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Гэта будзе табе са сьвятога сьвятых, з ахвяраў агнявых: возьмеш кожны дар ахвярны, ахвяру хлебную, ахвяру за грэх і ахвяру аднагараджэньня, якія Мне прыносяць; як сьвятое сьвятых будуць яны для цябе і для сыноў тваіх. ");
INSERT INTO bel_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","У Сьвятым Сьвятых бу­дзеш іх есьці; кожны мужчына можа есьці гэта, бо гэта сьвятыня для цябе. ");
INSERT INTO bel_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","А ўсе дары ахвярныя, якія патрэсваюць, складаючы, сыны Ізраіля, Я даю табе, і сынам тваім, і дочкам тваім як пастанову вечную; кожны чысты ў доме тваім будзе есьці іх. ");
INSERT INTO bel_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Табе Я даю ўсю тлус­тасьць алею, і ўсю тлустасьць віна і збожжа, якое сыны Ізраіля прыносяць ГОСПАДУ як першыя плады. ");
INSERT INTO bel_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","І пяршыны, якія яны прыносяць ГОСПАДУ з усёй зямлі іхняй, будуць твае. Кожны чысты ў доме тваім, будзе есьці іх. ");
INSERT INTO bel_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Усё, што пад закляцьцем у Ізраілі, будзе тваім. ");
INSERT INTO bel_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Усе першародныя ўлоньня кожнага цела, якія прыносяцца ГОСПАДУ, ці з людзей, ці з жывёлы, будуць тваімі. Але людзей першародных і кожнай жывёлы, якая нячыстая, выкупіш, выкупляючы. ");
INSERT INTO bel_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Выкупіш іх праз месяц пасьля нараджэньня за пяць сыкляў срэбра паводле сыклю сьвятыні; сыкль мае дваццаць гераў. ");
INSERT INTO bel_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Першародных каровы, першародных авечкі і першародных казы ня будзеш выкупляць, бо яны сьвятыя. Кроў іхнюю выльеш на ахвярнік, а тлушч іхні спаліш у агні на мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Мяса іхняе будзе тваім, таксама грудзіна патрасаная і правая лапатка будуць тваімі. ");
INSERT INTO bel_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Усе дары сьвятыя, якія прыносяць сыны Ізраіля ГОСПАДУ, Я даю табе, і сынам тваім, і дочкам тваім з табою як пастанову вечную. Гэта вечны запавет солі перад абліччам ГОСПАДА для цябе і насеньня твайго з табою». ");
INSERT INTO bel_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","І сказаў ГОСПАД Аарону: «У зямлі іхняй ня будзеш мець спадчыны і ня будзеш мець між імі часткі зямлі. Я — частка твая і спадчына твая між сынамі Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Вось, сынам Левія Я даю як спадчыну ўсе дзесяціны ў Ізраілі за служэньне, якое яны выконваюць у Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","А сыны Ізраіля ня бу­дуць больш набліжацца да Намёту Спатканьня, каб не ўчыніць грэху, які вядзе да сьмерці. ");
INSERT INTO bel_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Толькі лявіты будуць выконваць служэньне ў Намёце Спатканьня, і яны самі бу­дуць несьці правіну сваю. Гэта пастанова вечная для пакаленьняў вашых. І ня бу­дуць лявіты мець спадчыны між сынамі Ізраіля, ");
INSERT INTO bel_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","бо Я даў лявітам у спадчыну дзесяціны, якія сыны Ізраіля ахвяроўваюць ГОСПАДУ. Дзеля таго Я сказаў ім: “Між сыноў Ізраіля ня будзеце вы мець спадчыны”». ");
INSERT INTO bel_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Прамоў да лявітаў і скажы ім: “Калі вы атрымаеце дзесяціны ад сыноў Ізраіля, якія Я даў вам у спадчыну, дзесяціну з дзесяціны маеце прынесьці ў дар ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","І будзе гэта вам залічана як дар ад збожжа з току або ад таго, што напаўняе тоўчню. ");
INSERT INTO bel_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","І вы таксама павінны складаць ахвяры ГОСПАДУ з усіх дзесяцінаў вашых, якія вы атрымліваеце ад сыноў Ізраіля; прынясіце іх ГОСПАДУ і дайце Аарону сьвятару як дар. ");
INSERT INTO bel_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","З усяго, што атрымліваеце, прыносьце ўсялякія дары ГОСПАДУ, і з усяго найлепшага як сьвятой часткі гэтага”. ");
INSERT INTO bel_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","І скажы ім: “Калі вы зложыце з дзесяцінаў ў ахвяру тлустасьць дароў, гэта будзе вам залічана як ахвяра з току і ахвяра з тоўчні. ");
INSERT INTO bel_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","І будзеце гэта есьці на кожным месцы вы і дом ваш, бо гэта плата за службу вашую ў Намёце Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","І вы не панясеце на сабе грэху, калі ахвяруеце тлустасьць іхнюю, і не зьняважыце сьвятых дароў Ізраіля, і не памрацё”». ");
INSERT INTO bel_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","І прамовіў ГОСПАД да Майсея і Аарона, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Вось пастанова Закону, якую загадаў ГОСПАД. Прамоў да сыноў Ізраіля, і няхай яны прывядуць да цябе рудую карову без заганы, на якую яшчэ не было ўскладанае ярмо. ");
INSERT INTO bel_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","І аддасьцё яе Элеазару сьвятару, і ён выведзе яе па-за табар, і заб’іцё яе перад абліччам ягоным. ");
INSERT INTO bel_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","І Элеазар сьвятар памо­чыць палец свой у крыві ейнай, і пакропіць сем разоў крывёю ейнай пярэдні бок Намёту Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","І спаляць карову гэтую перад вачыма ягонымі, і скуру ейную, і кроў ейную, і нячыстасьць ейную спаляць. ");
INSERT INTO bel_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","І возьме сьвятар дрэва кедровае, гізоп і ніткі кармазыновыя, і кіне ў нутро каровы, якая гарыць у агні. ");
INSERT INTO bel_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","І памые сьвятар шаты свае, і абмые цела сваё ў вадзе, і ўвойдзе ён у табар, і будзе нячысты сьвятар аж да вечара. ");
INSERT INTO bel_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","І той, хто спальваў карову, памые шаты свае ў вадзе, і абмые цела сваё ў вадзе, і нячысты будзе ён аж да вечара. ");
INSERT INTO bel_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","І зьбярэ чалавек чысты попел каровы, і высыпе па-за табарам у месцы чыстым, і ён будзе для грамады сыноў Ізраіля захаваны для прыгатаваньня вады ачышчэньня. Гэта ахвяра за грэх. ");
INSERT INTO bel_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Той, хто зьбіраў попел каровы, вымые адзеньне сваё і будзе нячысты аж да вечара. Гэта пастанова вечная як для сыноў Ізраіля, так і для прыхадняў, якія ў іх жывуць. ");
INSERT INTO bel_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Хто дакранецца нябожчыка, будзе нячысты сем дзён. ");
INSERT INTO bel_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Павінен ён вадой з попелу каровы ачысьціцца ў трэці і сёмы дзень, і будзе чысты. Калі ў трэці дзень і ў сёмы дзень ня будзе ачышчаны, ня будзе чысты. ");
INSERT INTO bel_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Кожны, хто дакрануўся нябожчыка і не ачысьціўся, ро­біць нячыстай Сялібу ГОСПАДА; будзе вынішчана душа тая з Ізраіля, бо вада ачышчэньня не пакрапіла яго, і ён будзе нячысты, і нячыстасьць ягоная застанецца на ім. ");
INSERT INTO bel_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Гэта закон адносна чалавека, які памёр у намёце. Кожны, хто ўвойдзе ў гэты намёт, і кожны, хто ў ім знаходзіцца, будзе нячысты сем дзён. ");
INSERT INTO bel_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","І кожная пасудзіна адкрытая, якая ня мае накрыўкі, прымацаванай на шнурку, будзе нячыстай. ");
INSERT INTO bel_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","І кожны, хто на абліччы поля дакранецца або забітага мячом, або памёршага, або костак людзкіх, або магілы, будзе нячысты сем дзён. ");
INSERT INTO bel_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","І возьмуць для нячыстага попел той спаленай ахвяры за грэх і нальюць на яго жывой вады ў посуд. ");
INSERT INTO bel_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","І чалавек чысты возьме гізоп, і памочыць яго ў вадзе, і пакропіць намёт, і ўвесь посуд, і людзей, якія былі ў ім, і таго, хто дакрануўся костак, або забітага, або памёршага, або магілы. ");
INSERT INTO bel_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","І пакропіць чалавек чысты таго, хто нячысты, у трэці і сёмы дзень, і ачысьціць яго ў сёмы дзень. Чалавек нячысты памые адзеньне сваё і абмые сябе ў вадзе, і вечарам будзе чысты. ");
INSERT INTO bel_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Але калі той, хто нячысты, ня будзе ачышчаны, бу­дзе зьнішчана душа яго спаміж царквы, бо ён зрабіў нячыстай Сялібу ГОСПАДА; вадою ачышчэньня ён не абмыты, ён нячысты. ");
INSERT INTO bel_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Гэта будзе для вас пастанова вечная. І той, хто кропіць вадой ачышчэньня, вымые адзеньне сваё; і той, хто дакранецца вады ачышчэньня, нячысты будзе аж да вечара. ");
INSERT INTO bel_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","І ўсё, да чаго дакранецца нячысты, і душа, якая яго дакранецца, будзе нячыстай аж да вечара». ");
INSERT INTO bel_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","І прыйшлі ў першы месяц сыны Ізраіля, уся грамада, у пустыню Сін, і затрымаўся народ у Кадэшы. Там памерла Мірыям, і там была пахаваная. ");
INSERT INTO bel_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","І не было вады для грамады, і зграмадзіліся яны супраць Майсея і Аарона. ");
INSERT INTO bel_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","І спрачаўся народ з Майсеем, і яны казалі: «Лепш, каб мы загінулі, калі загінулі браты нашыя перад абліччам ГОСПАДА! ");
INSERT INTO bel_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Навошта вывелі вы царкву ГОСПАДА ў пустыню гэтую, каб там загінулі мы і жывёла нашая? ");
INSERT INTO bel_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Навошта вы нас вывелі з Эгіпту, каб завесьці нас у гэтае месца ліхое, дзе сеяць нельга, дзе дрэва фігавае не расьце, ані вінаград, ані дрэвы гранатовыя, і вады няма для піцьця?» ");
INSERT INTO bel_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","І Майсей і Аарон адыйшлі ад аблічча царквы да ўваходу ў Намёт Спатканьня, і ўпалі на абліччы свае. І зьявілася слава ГОСПАДА над імі. ");
INSERT INTO bel_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Вазьмі кій і зьбярыце грамаду, ты і Аарон, брат твой, і прамоўце да скалы перад вачыма іхнімі, і яна дасьць ваду. І ты выведзеш ваду са скалы, і напоіш грамаду і жывёлу ейную». ");
INSERT INTO bel_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","І ўзяў Майсей кій спрад аблічча ГОСПАДА, як Госпад загадаў яму. ");
INSERT INTO bel_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","І Майсей і Аарон сабралі царкву перад скалою, і сказаў Майсей: «Слухайце, бунтаўнікі! Ці зможам мы з гэтай скалы вывесьці ваду для вас?» ");
INSERT INTO bel_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","І падняў Майсей руку сваю, і ўдарыў скалу кіем сваім два разы. І выцякла шмат вады, і напілася грамада і жывёла іх. ");
INSERT INTO bel_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","І сказаў ГОСПАД Майсею і Аарону: «За тое, што вы не паверылі Мне, каб выявіць сьвятасьць Маю перад вачыма сыноў Ізраіля, вы не ўвядзіцё царкву гэтую ў зямлю, якую Я даў ім». ");
INSERT INTO bel_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Гэта вось вада Мэрывы, дзе спрачаліся сыны Ізраіля суп­раць ГОСПАДА і дзе Ён выявіў сьвятасьць Сваю перад імі. ");
INSERT INTO bel_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","І паслаў Майсей з Кадэшу паслоў да валадара Эдому, каб яны сказалі: «Я — брат твой, Ізраіль: Ты ведаеш усе беды, якія спаткалі нас. ");
INSERT INTO bel_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","І зыйшлі бацькі нашыя ў Эгіпет, і жылі ў Эгіпце шмат дзён, і Эгіпцяне крыўдзілі нас і бацькоў нашых, ");
INSERT INTO bel_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","і мы клікалі да ГОСПАДА, і Ён выслухаў голас наш, і паслаў анёла, і вывеў нас з Эгіпту. І вось, мы ў горадзе Кадэшы, на мяжы тваёй. ");
INSERT INTO bel_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Просім, дазволь прайсьці праз зямлю тваю. Ня пой­дзем мы праз палі і вінаграднікі і ня будзем піць вады са студняў. Мы пойдзем шляхам валадарскім, не адхіляючыся ані направа, ані налева, пакуль не мінем межаў тваіх». ");
INSERT INTO bel_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","І сказаў ім Эдом: «Ня пройдзеш праз мяне, бо я з мячом выйду насустрач табе». ");
INSERT INTO bel_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","І сказалі яму сыны Ізраіля: «Мы пойдзем бітаю дарогай, а калі будзем піць ваду тваю, мы і жывёла наша, заплацім. Нічога не жадаем, толькі прайсьці пехатою». ");
INSERT INTO bel_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","І сказаў Эдом: «Ня пройдзеце!» І выйшаў Эдом супраць іх з народам шматлікім і рукою моцнаю. ");
INSERT INTO bel_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","І забараніў Эдом Ізраілю пераходзіць межы свае, і Ізраіль адыйшоў у бок ад яго. ");
INSERT INTO bel_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","І вырушылі з Кадэшу, і прыйшлі сыны Ізраіля, уся грамада, пад гару Гор. ");
INSERT INTO bel_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","І сказаў ГОСПАД Майсею і Аарону каля гары Гор, якая на мяжы зямлі Эдому, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Аарон будзе далучаны да народу свайго, бо ён ня ўвойдзе ў зямлю, якую Я дам сынам Ізраіля, таму што вы супрацівіліся слову з вуснаў Маіх ля водаў Мэрывы. ");
INSERT INTO bel_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Вазьмі Аарона і Элеазара, сына ягонага, і завядзі іх на гару Гор. ");
INSERT INTO bel_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Здымі з Аарона адзеньне ягонае, і апрані ў яго Элеазара, сына ягонага, і Аарон няхай далучыцца да народу свайго, і памрэ там». ");
INSERT INTO bel_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","І зрабіў Майсей, як загадаў ГОСПАД. І ўзыйшлі яны на гару Гор на вачах усёй грамады. ");
INSERT INTO bel_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","І зьняў Майсей з Аарона адзеньне ягонае, і апрануў у яго Элеазара, сына ягонага. І памёр Аарон там на вяршыні гары, а Майсей і Элеазар зыйшлі з гары. ");
INSERT INTO bel_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","І ўбачыла ўся грамада, што памёр Аарон, і плакаў увесь дом Ізраіля па Аароне трыц­цаць дзён. ");
INSERT INTO bel_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","І пачуў валадар Араду, Хананеец, які жыў у Нэгеве, што Ізраільцяне ідуць шляхам ад Атарыму, і напаў ён на Ізраіля, і ўзяў палонных. ");
INSERT INTO bel_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","І шлюбаваў Ізраіль ГОСПАДУ, і сказаў: «Калі Ты, выдаючы, выдасі народ гэты ў рукі нашыя, мы паложым закляцьце на гарады ягоныя». ");
INSERT INTO bel_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","І выслухаў ГОСПАД голас Ізраіля, і выдаў яму Хананейцаў, і яны палажылі закляцьце на іх і на гарады іхнія, і назвалі імя месцу гэтаму Харма. ");
INSERT INTO bel_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","І выйшлі яны ад гары Гор шляхам да Мора Чырвонага, каб абыйсьці зямлю Эдом. І ў часе дарогі душа народу страціла цярплівасьць. ");
INSERT INTO bel_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","І гаварыў народ супраць Бога і супраць Майсея: «Навошта вы вывелі нас з Эгіпту, каб мы памерлі ў пустыні? Няма хлеба, няма вады. І душы нашай абрыд гэты марны хлеб». ");
INSERT INTO bel_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","І паслаў ГОСПАД на народ палючых зьмеяў, і яны кусалі народ, і памерла шмат народу ў Ізраілі. ");
INSERT INTO bel_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","І прыйшоў народ да Майсея, і сказаў: «Саграшылі мы, бо гаварылі супраць ГОСПАДА і супраць цябе. Маліся да ГОСПАДА, каб забраў Ён ад нас гэтых зьмеяў». І маліўся Майсей за народ. ");
INSERT INTO bel_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","І сказаў ГОСПАД Майсею: «Зрабі зьмея палючага і падымі яго як сьцяг. Кожны ўкушаны, калі гляне на яго, будзе жыць». ");
INSERT INTO bel_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","І зрабіў Майсей зьмея мядзянага, і ўзьняў яго як сьцяг, і сталася, што калі зьмей укусіў чалавека, а ён глянуў на зьмея мядзянага, дык заставаўся жыць. ");
INSERT INTO bel_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","І выйшлі ў дарогу сыны Із­раіля, і сталі табарам у Абоце. ");
INSERT INTO bel_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","І выйшлі з Аботу, і сталі табарам пад Іе-Абарымам у пустыні, якая на ўсход ад Мааву. ");
INSERT INTO bel_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Адтуль выйшлі і сталі табарам каля ручая Зарэд. ");
INSERT INTO bel_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Адтуль выйшлі і сталі табарам за ракою Арнон, якая цячэ праз пустыню з межаў Амарэйцаў, бо Арнон — мяжа між Мааўлянамі і Амарэйцамі. ");
INSERT INTO bel_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Таму сказана ў Кнізе войнаў ГОСПАДА: «Вагэў каля Суфа і ручаёў Арнону. ");
INSERT INTO bel_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Схіл ручаёў сягае аж да мясцовасьці Ар і прылягае аж да межаў Мааву». ");
INSERT INTO bel_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Адтуль рушылі ў Бээр. Гэта тая студня, пра якую сказаў ГОСПАД Майсею: «Зьбяры народ, і Я дам яму вады». ");
INSERT INTO bel_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Тады засьпяваў Ізраіль гэты сьпеў: «Напаўняйся, студня, сьпявайце пра яе! ");
INSERT INTO bel_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Студня, якую выкапалі князі, начальнікі народу капалі скіпетрамі і кіямі сваімі». З пустыні яны вырушылі ў Матану, ");
INSERT INTO bel_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","з Матаны — у Нахаліэль, з Нахаліэлю — у Бамот, ");
INSERT INTO bel_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","з Бамоту — у лагчыну, якая на полі Мааву, каля вяршыні гары Пісга, што ўзвышаецца перад абліччам зямлі бязьлюднай. ");
INSERT INTO bel_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","І паслаў Ізраіль пасланцоў да Сыгона, валадара Амарэйцаў, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Дазволь мне прайсьці праз зямлю тваю; ня збочым мы на палі і на вінаграднікі, ня будзем піць са студняў, пойдзем шляхам валадарскім, пакуль ня пройдзем межы твае». ");
INSERT INTO bel_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Але Сыгон не дазволіў Ізраілю прайсьці праз межы свае, і сабраў Сыгон увесь народ свой, і пераняў Ізраіля ў пустыні, і прыйшоў у Ягцу, і напаў на Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","І перамог яго Ізраіль вострывам мяча, і заняў зямлю ягоную ад Арнону аж да Ябоку, аж да зямлі сыноў Амона, бо моцнымі былі межы сыноў Амона. ");
INSERT INTO bel_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","І авалодаў Ізраіль усімі гарадамі тымі, і абжыўся Ізраіль у гарадах Амарэйцаў, у Хешбоне і ў-ва ўсіх ваколіцах ягоных. ");
INSERT INTO bel_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Хешбон быў горадам Сыгона, валадара Амарэйцаў, які ваяваў з папярэднім валадаром Мааву і забраў з рукі ягонай ўсю зямлю аж да Арнону. ");
INSERT INTO bel_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Таму гаворыцца ў прыказцы: «Ідзіце ў Хешбон! Няхай будзе адбудаваны і ўмацаваны горад Сыгона! ");
INSERT INTO bel_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Бо агонь выйшаў з Хешбону, полымя з гораду Сыгона, спаліў Ар-Мааў і ўладароў узгорышчаў Арнону. ");
INSERT INTO bel_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Гора табе, Мааў; прапаў ты, народ Хамоша! Змусіў ён сыноў тваіх да ўцёкаў, а дочак тваіх аддаў у палон Сыгону, валадару Амарэйцаў. ");
INSERT INTO bel_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Пусьцілі мы стрэлы ў іх, загінуў Хешбон аж да Дыбону. Зьнішчылі мы ўсё аж да Нофы і аж да Мэдэвы». ");
INSERT INTO bel_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","І абжыўся Ізраіль у зямлі Амарэйцаў. ");
INSERT INTO bel_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","І паслаў Майсей выведчыкаў у Язэр. І яны здабылі яго і ваколіцы ягоныя, і выгналі Амарэйцаў, якія былі там. ");
INSERT INTO bel_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","І яны павярнулі, і пайшлі па шляху ў Башан. І выйшаў Ог, валадар Башану, насустрач ім на бітву з усім народам сваім у Эдрэі. ");
INSERT INTO bel_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","І ГОСПАД сказаў Майсею: «Ня бойся яго, бо Я аддаў ў рукі твае яго і ўвесь народ ягоны, і зямлю ягоную, і ты зробіш з ім так, як зрабіў з Сыгонам, валадаром Амарэйцаў, які жыў у Хешбоне». ");
INSERT INTO bel_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","І яны пабілі яго і сыноў ягоных, і ўвесь народ ягоны, аж нікога не засталося з іх, і авалодалі зямлёй ягонай. ");
INSERT INTO bel_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","І выйшлі сыны Ізраіля, і сталі табарам на раўнінах Мааву на другім баку Ярдану, насупраць Ерыхону. ");
INSERT INTO bel_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","І ўбачыў Балак, сын Цыпора, усё, што зрабіў Ізраіль Амарэйцам. ");
INSERT INTO bel_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","І Мааў вельмі спалохаўся гэтага народу, бо ён быў шматлікі, і баяўся Мааў сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","І сказаў Мааў старшыням Мадыяну: «Цяпер гэтая супольнасьць паесьць усё кругом, як вол саскубае траву на полі». У той час валадаром Мааву быў Балак, сын Цыпора. ");
INSERT INTO bel_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","І паслаў ён пасланцоў да Білеама, сына Бэора, у Пэтор, які над ракой зямлі сыноў народу ягонага, каб паклікаць яго, кажучы: «Вось, выйшаў народ з Эгіпту. Вось, ён пакрыў аблічча зямлі і пасяліўся насупраць мяне. ");
INSERT INTO bel_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","І цяпер прыйдзі, прашу, і пракляні мне народ гэты, бо ён дужэйшы за мяне. Можа, я здолею перамагчы яго і выгнаць з зямлі, бо ведаю, што каго ты дабраславіш, будзе дабраслаўлёны, а каго ты праклянеш, будзе пракляты». ");
INSERT INTO bel_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","І прыйшлі старшыні Мааву са старшынямі Мадыяну, і плата за прадказаньне была ў руцэ іхняй, і прыйшлі да Білеама, і перадалі яму словы Балака. ");
INSERT INTO bel_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","І ён сказаў ім: «Застаньцеся тут на ноч, і я прынясу вам слова, якое скажа мне ГОСПАД». І засталіся князі Мааву ў Білеама. ");
INSERT INTO bel_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","І прыйшоў Бог да Білеама, і сказаў: «Што гэта за людзі ў цябе?» ");
INSERT INTO bel_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","І Білеам сказаў Богу: «Балак, сын Цыпора, валадар Мааву, прыслаў да мяне ");
INSERT INTO bel_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","сказаць: “Вось, народ выйшаў з Эгіпту і пакрыў паверхню зямлі. Цяпер прыйдзі і пракляні мне яго, каб мог я перамагчы яго і выгнаць яго”». ");
INSERT INTO bel_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","І сказаў Бог Білеаму: «Ты ня пойдзеш з імі, не праклянеш народ, бо ён дабраслаўлёны». ");
INSERT INTO bel_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","І ўстаў Білеам раніцаю, і сказаў князям Балака: «Варочайцеся ў зямлю вашую, бо ГОСПАД не дазволіў мне ісьці з вамі». ");
INSERT INTO bel_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","І ўсталі князі Мааву, і прыйшлі да Балака, і сказалі яму: «Білеам не згадзіўся ісьці з намі». ");
INSERT INTO bel_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","І Балак паслаў яшчэ раз князёў, больш лікам і больш паважаных, чым тыя. ");
INSERT INTO bel_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","І прыйшлі яны да Білеама, і сказалі яму: «Так кажа Балак, сын Цыпора: “Не адмаўляйся, прашу, прыйсьці да мяне. ");
INSERT INTO bel_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Бо, ушаноўваючы, вельмі ўшаную цябе і ўсё, што скажаш мне, зраблю. Прыйдзі і пракляні мне народ гэты”». ");
INSERT INTO bel_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","І адказаў Білеам, і сказаў слугам Балака: «Калі нават дасьць мне Балак поўны дом свой срэбра і золата, не магу парушыць слова з вуснаў ГОСПАДА, Бога майго, каб зрабіць што малое, або вялікае. ");
INSERT INTO bel_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","А цяпер, прашу, застаньцеся таксама ў гэтую ноч, а я даведаюся, што зноў прамовіць да мяне ГОСПАД». ");
INSERT INTO bel_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","І прыйшоў Бог да Білеама ўначы, і сказаў яму: «Калі прыйшлі гэтыя людзі паклікаць цябе, устань і ідзі з імі, але слова, якое Я прамоўлю да цябе, выканаеш». ");
INSERT INTO bel_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","І ўстаў Білеам раніцаю, і асядлаў асьліцу сваю і вырушыў разам з князямі Мааву. ");
INSERT INTO bel_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","І ўзгарэўся гнеў Бога, што ён паехаў. І стаў анёл ГОСПАДА на шляху як супраціўнік ягоны. А ён ехаў на асьліцы сваёй, і два юнакі ягоныя з ім. ");
INSERT INTO bel_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","І ўбачыла асьліца анёла ГОСПАДА, які стаяў на шляху, і меч ягоны выцягнуты ў руцэ ягонай, і зыйшла асьліца з дарогі, і пайшла ў поле. І Білеам ударыў асьліцу, каб яна завярнула на дарогу. ");
INSERT INTO bel_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","І стаў анёл ГОСПАДА на сьцеж­цы паміж вінаграднікамі, і мур быў з таго і з гэтага боку. ");
INSERT INTO bel_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","І ўбачыла асьліца анёла ГОС­ПАДА, і прыціснулася да му­ру, і прыціснула нагу Білеама да муру, і ён зноў пачаў біць яе. ");
INSERT INTO bel_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","І анёл ГОСПАДА перайшоў і стаў у месцы такім вузкім, што не было дарогі, каб абмінуць яго ані з правага, ані з левага боку. ");
INSERT INTO bel_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","І ўбачыла асьліца анёла ГОСПАДА, і лягла пад Білеамам. І ўзлаваўся Білеам, і біў асьліцу кіем. ");
INSERT INTO bel_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","І адкрыў ГОСПАД вусны асьліцы, і яна сказала Білеаму: «Што я табе зрабіла? Чаму ты б’еш мяне ўжо трэці раз?» ");
INSERT INTO bel_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","І сказаў Білеам асьліцы: «Бо ты глумішся з мяне. Каб меў я меч у руцэ маёй, я забіў бы цябе!» ");
INSERT INTO bel_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","І сказала асьліца Білеаму: «Ці ж я не твая асьліца, на якой ты езьдзіш ад пачатку да сёньняшняга дня? Ці ж я мела звычку так рабіць з табой?» І ён сказаў: «Не». ");
INSERT INTO bel_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","І адкрыў ГОСПАД вочы Білеама, і ён угледзеў анёла ГОСПАДА, які стаяў на шляху, і меч выцягнуты ў руцэ ягонай. І пакланіўся ён, і схіліў аблічча сваё. ");
INSERT INTO bel_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","І сказаў яму анёл ГОСПАДА: «Навошта тры разы ты біў асьліцу сваю? Вось, я прыйшоў як супраціўнік твой, бо нядобрая дарога твая перад табою. ");
INSERT INTO bel_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","І ўбачыла мяне асьліца, і тры разы ўхілялася ад мяне, і каб яна не ўхілялася ад мяне, я забіў бы цябе, а яе пакінуў бы жывую». ");
INSERT INTO bel_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","І сказаў Білеам анёлу ГОСПАДА: «Саграшыў я, бо ня ведаў, што ты стаіш супраць мяне на шляху; а цяпер, калі гэта кепска ў вачах тваіх, я вярнуся назад». ");
INSERT INTO bel_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","І сказаў анёл ГОСПАДА Білеаму: «Ідзі з тымі людзьмі, але сьцеражыся, бо слова, якое Я прамоўлю да цябе, прамовіш». І пайшоў Білеам з князямі Балака. ");
INSERT INTO bel_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","І пачуў Балак, што Білеам прыйшоў, і выйшаў яму на спатканьне аж да Ір-Мааву, які на мяжы пры Арноне. ");
INSERT INTO bel_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","І сказаў Балак Білеаму: «Ці ж, пасылаючы, я не пасылаў да цябе, каб паклікалі цябе? Чаму ты не прыйшоў да мяне? Няўжо я не магу ўшанаваць цябе?» ");
INSERT INTO bel_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","І сказаў Білеам Балаку: «Вось, я прыйшоў да цябе цяпер. Ці ж я магу што іншае прамовіць? Слова, якое ўложыць Бог у вусны мае, я прамоўлю». ");
INSERT INTO bel_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","І пайшлі Балак разам з Білеамам, і прыйшлі ў Кірыят-Хуцот. ");
INSERT INTO bel_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","І Балак склаў у ахвяру валоў і авечак, і паслаў Білеаму і князям, якія з ім. ");
INSERT INTO bel_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","І сталася раніцаю, і ўзяў Балак Білеама, і завёў яго на ўзгорышча Баала, і адтуль убачыў ён частку народу Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","І сказаў Білеам Балаку: «Пастаў мне тут сем ахвярнікаў і падрыхтуй мне сем бычкоў і сем бараноў». ");
INSERT INTO bel_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","І Балак зрабіў так, як прамовіў Білеам, і склалі ў ахвяру Балак і Білеам бычка і барана на кожным ахвярніку. ");
INSERT INTO bel_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","І сказаў Білеам Балаку: «Застанься каля цэласпаленьня твайго, а я пайду, можа, мяне спаткае ГОСПАД, і слова, якое Ён мне зьявіць, я паведамлю табе». І ён узыйшоў на лысы ўзгорак. ");
INSERT INTO bel_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","І сустрэў Бог Білеама, і той сказаў Яму: «Паставіў я сем ахвярнікаў, і на кожным ахвярніку склалі ў ахвяру бычка і барана». ");
INSERT INTO bel_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","І ўлажыў ГОСПАД слова ў вусны Білеама, і сказаў: «Вярніся да Балака і гэта скажы». ");
INSERT INTO bel_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","І вярнуўся Білеам, і вось, Балак стаіць каля цэласпаленьня свайго, ён і ўсе князі Мааву. ");
INSERT INTO bel_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","І абвясьціў ён прароцтва сваё, і сказаў: «З Араму прывёў мяне Балак, валадар Мааву, з гор усходніх, кажучы: “Прыйдзі і пракляні мне Якуба! Прыйдзі і навядзі няшчасьце на Ізраіля!” ");
INSERT INTO bel_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Як магу я праклінаць таго, каго не праклінае Бог? Як магу навесьці на каго няшчасьце, калі ГОСПАД не наводзіць яго? ");
INSERT INTO bel_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Бо я бачу яго з вяршыні скалаў і з узгорышчаў гляджу на яго. Вось, народ, які жыве асобна і сярод народаў ня лічыцца. ");
INSERT INTO bel_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Хто можа палічыць пыл Якуба, і лік чацьвёртай часткі Ізраіля? Няхай памрэ душа мая сьмерцю справядлівых, і няхай будзе канец мой падобны іхняму». ");
INSERT INTO bel_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","І сказаў Балак Білеаму: «Што ты робіш? Я цябе паклікаў праклінаць ворагаў маіх, а ты, вось, дабраслаўляючы, дабраслаўляеш іх!» ");
INSERT INTO bel_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","І адказаў Білеам, і сказаў: «Хіба ня тое, што ўложыць ГОСПАД у вусны мае, я павінен прамаўляць?» ");
INSERT INTO bel_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","І сказаў яму Балак: «Ха­дзі са мной на іншае месца, з якога толькі частку Ізраіля ўбачыш, а ўсяго ня будзеш бачыць, і адтуль яго пракляні». ");
INSERT INTO bel_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","І завёў ён яго на Поле Вартаўнікоў, на вяршыню Пісгі, і пабудаваў сем ахвярнікаў, і ахвяраваў на кожным ахвярніку бычка і барана. ");
INSERT INTO bel_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","І сказаў Білеам Балаку: «Застанься тут каля цэласпаленьня твайго, а я спаткаюся з Госпадам». ");
INSERT INTO bel_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","І сустрэў ГОСПАД Білеама, і ўлажыў словы ў вусны ягоныя, і сказаў: «Вяртайся да Балака і гэта прамовіш». ");
INSERT INTO bel_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","І вярнуўся Білеам, і вось, Балак стаіць каля цэласпаленьня свайго, і князі Мааву з ім, і сказаў яму Балак: «Што прамовіў ГОСПАД?» ");
INSERT INTO bel_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","І ён абвясьціў прароцтва сваё, і сказаў: «Устань, Балак, і слухай, і прыхілі вуха, сыне Цыпора! ");
INSERT INTO bel_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Бог — гэта не чалавек, каб Ён падманваў, і ня сын чалавечы, каб памыляўся. Ці ж Ён кажа і ня робіць? Ці ж Ён прамовіў і ня споўніў? ");
INSERT INTO bel_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Вось, дабраслаўляць прывёў Ён мяне, і Ён дабраславіў, і я не стрымаю гэтага. ");
INSERT INTO bel_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Не заўважна беззаконьня ў Якуба і ня бачна гора ў Ізраіля. ГОСПАД, Бог ягоны, з ім, і гоман у яго на славу валадара ягонага. ");
INSERT INTO bel_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Бог вывеў яго з Эгіпту. Ён для іх — як рог аднарога. ");
INSERT INTO bel_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Няма варажбы ў Якуба, ані прадказаньняў у Ізраіля. У свой час будзе сказана Якубу і Ізраілю, што ўчыніць Бог. ");
INSERT INTO bel_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Вось, народ, як ільвіца, падымаецца і, як леў, становіцца; ён ня ляжа, пакуль ня зьесьць здабычы і пакуль не нап’ецца крыві забітых». ");
INSERT INTO bel_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","І сказаў Балак Білеаму: «Калі ты праклёнам не праклянеш яго, дык не дабраслаўляй яго, дабраслаўляючы!» ");
INSERT INTO bel_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","І адказаў Білеам, і сказаў Балаку: «Ці ж я табе не прамаўляў, кажучы: \"Усё тое, што мне ГОСПАД прамовіць, я зраблю\"?» ");
INSERT INTO bel_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","І сказаў Балак Білеаму: «Хадзі, я завяду цябе на іншае месца. Можа, спадабаецца ў вачах Бога, і ты адтуль праклянеш яго?» ");
INSERT INTO bel_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","І завёў Балак Білеама на вяршыню гары Пэор, што ўзвышаецца перад абліччам зямлі бязьлюднай. ");
INSERT INTO bel_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","І сказаў Білеам Балаку: «Пабудуй мне тут сем ахвярнікаў і падрыхтуй мне тут сем бычкоў і сем бараноў». ");
INSERT INTO bel_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","І зрабіў Балак, як яму сказаў Білеам, і ахвяраваў бычка і барана на кожным ахвярніку. ");
INSERT INTO bel_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","І ўбачыў Білеам, што добра ў вачах ГОСПАДА, каб дабраславіць Ізраіля, і ён не пайшоў, як раней хадзіў, каб варажыць, але павярнуў аблічча сваё на пустыню. ");
INSERT INTO bel_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","І падняў Білеам вочы свае, і ўбачыў Ізраіля, што стаяў паводле каленаў сваіх, і агарнуў яго Дух Божы, ");
INSERT INTO bel_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","і абвясьціў ён прароцтва сваё, і сказаў: «Кажа Білеам, сын Бэора, кажа чалавек, у якога адкрытыя вочы, ");
INSERT INTO bel_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","кажа той, хто чуе слова Божае, той, хто бачыць відзежы Усемагутнага, той, хто падае, але мае вочы адкрытыя. ");
INSERT INTO bel_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Якія добрыя намёты твае, Якубе, і сялібы твае, Ізраілю! ");
INSERT INTO bel_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Раскінуліся яны як даліны рэкаў, як сады на беразе ручая, як альвасы, якія ГОСПАД пасадзіў, як кедры над водамі. ");
INSERT INTO bel_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Цячэ вада з нетраў ягоных, і зерне ягонае мае ўдосталь вады. Валадар ягоны мацнейшы за Агага, і ўзвышаецца валадарства ягонае. ");
INSERT INTO bel_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Бог вывеў яго з Эгіпту. Ён для яго — як рог аднарога. Праглыне ён народы, прыгнятальнікаў сваіх, косткі іхнія патрушчыць і праб'е стрэламі сваімі. ");
INSERT INTO bel_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ён прыхіліўся, лёг, як леў і як ільвіца. Хто адважыцца пабудзіць яго? Хто дабраслаўляе цябе, сам будзе дабраслаўлёны; хто праклінае цябе, сам будзе пракляты!» ");
INSERT INTO bel_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","І разгневаўся Балак на Білеама, і пляснуў у далоні свае, і сказаў Балак Білеаму: «Праклінаць ворагаў маіх я паклікаў цябе. А вось, ты іх ўжо трэці раз, дабраслаўлючы, дабраслаўляеш! ");
INSERT INTO bel_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Дык цяпер уцякай у месца сваё! Хацеў я цябе, ушаноўваючы, ушанаваць, але вось, ГОСПАД пазбавіў цябе ўшанаваньня». ");
INSERT INTO bel_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","І сказаў Білеам Балаку: «Ці ж да пасланцоў тваіх, якіх ты паслаў да мяне, я не прамаўляў, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","“Хоць бы Балак даваў мне поўны дом свой срэбра або золата, не магу працівіцца слову з вуснаў ГОСПАДА, каб што добрае, ці што ліхое ўчы­ніць з сэрца майго, але тое, што ГОСПАД прамовіць, я прамаў­ляць буду”. ");
INSERT INTO bel_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","І цяпер, вось, я іду да народу майго, але падыйдзі, я паведамлю табе, што зробіць народ гэты з народам тваім у наступныя дні». ");
INSERT INTO bel_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","І абвясьціў ён прароцтва сваё, і сказаў: «Кажа Білеам, сын Бэора, кажа чалавек, які мае адкрытыя вочы, ");
INSERT INTO bel_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","кажа той, хто чуе словы Божыя, які ведае думку Найвышэйшага і бачыць відзежы Усемагутнага, які падае, але мае адкрытыя вочы. ");
INSERT INTO bel_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Бачу яго, але яшчэ не цяпер, аглядаю яго, але ня зблізка. Узыходзіць зорка з Якуба, і паўстае скіпетр з Ізраіля; і ён струшчыць скроні Мааву і зьні­шчыць усіх сыноў Сэта. ");
INSERT INTO bel_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","І Эдом станецца ўласнасьцю ягонай, і Сэір станецца ўласнасьцю ворагаў сваіх, а Ізраіль станецца моцным. ");
INSERT INTO bel_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ад Якуба выйдзе той, які мае ўладу, і зьнішчыць ён рэшткі гораду». ");
INSERT INTO bel_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","І ўбачыў ён Амалека, і абвясьціў прароцтва сваё, і сказаў: «Амалек — першы з народаў, але канец ягоны — загуба». ");
INSERT INTO bel_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","І ўбачыў ён Кенэяў, і абвясьціў прароцтва сваё, і сказаў: «Моцнае жытло тваё, і на скале пабудаванае гняздо тваё; ");
INSERT INTO bel_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","але будзе на спаленьне Кенэй, калі Асур зьняволіць цябе». ");
INSERT INTO bel_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","І абвясьціў ён прароцтва сваё, і сказаў: «Гора! Хто бу­дзе жыць, калі Бог зробіць гэта? ");
INSERT INTO bel_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Прыплывуць караблі з Кіттыму, і перамогуць Асура, і перамогуць Эвэра, але ўрэшце самі загінуць». ");
INSERT INTO bel_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","І ўстаў Білеам, і вярнуўся ў месца сваё, а Балак таксама пайшоў дарогай сваёй. ");
INSERT INTO bel_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","І жыў Ізраіль у Шыттыме, і народ стаў распусьнічаць з дочкамі Мааву, ");
INSERT INTO bel_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","а яны запрашалі народ складаць ахвяры багам сваім. Разам яны елі і пакланяліся багам іхнім. ");
INSERT INTO bel_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","І прыляпіўся Ізраіль да Баал-Пэора, і ўзгарэўся гнеў ГОСПАДА супраць Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","І сказаў ГОСПАД Майсею: «Зьбяры ўсіх вінаватых начальнікаў народу і павесь іх перад ГОСПАДАМ на сонцы, і адвернецца ярасьць гневу ГОСПАДА ад Ізраіля». ");
INSERT INTO bel_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","І сказаў Майсей судзьдзям Ізраіля: «Забіце тых людзей вашых, якія прыляпіліся да Баал-Пэора». ");
INSERT INTO bel_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","І вось, адзін з сыноў Ізраіля прыйшоў, і прывёў да братоў сваіх Мадыянку на вачах Майсея і на вачах усёй грамады сыноў Ізраіля, якія лямантавалі перад уваходам у Намёт Спатканьня. ");
INSERT INTO bel_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","І ўбачыў гэта Пінхас, сын Элеазара, сына Аарона сьвятара, і ўстаў спаміж грамады, і схапіў дзіду ў руку сваю, ");
INSERT INTO bel_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","і пайшоў за мужчынам Ізраільцянінам пад заслону намёту, і прабіў іх дзідаю абодвух, мужчыну Ізраільцяніна і жанчыну, праз улоньні. І спынілася кара на сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","А загінула ад той кары дваццаць чатыры тысячы чалавек. ");
INSERT INTO bel_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Пінхас, сын Элеазара, сына Аарона сьвятара, адвярнуў гнеў Мой ад сыноў Ізраіля, бо ён загарэўся рэўнасьцю Маёю сярод іх, і Я ня зьнішчыў сыноў Ізраіля ў рэўнасьці Маёй. ");
INSERT INTO bel_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Дзеля гэтага скажы яму: “Вось, Я заключаю з ім Мой запавет супакою”. ");
INSERT INTO bel_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","І будзе гэта яму і насеньню ягонаму запавет вечнага сьвятарства за тое, што ён рупіўся пра Бога свайго і перамольваў за сыноў Ізраіля». ");
INSERT INTO bel_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","А імя таго мужчыны Ізраільцяніна, забітага разам з Мадыянкай, было Зімры, сын Салю, князь дому бацькоў калена Сымона. ");
INSERT INTO bel_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","А імя забітай жанчыныМадыянкі было Казьбі, яна —дачка Цура, начальніка аднаго з пакаленьняў Мадыянскіх. ");
INSERT INTO bel_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Ваюйце супраць Мадыянцаў і выбіце іх, ");
INSERT INTO bel_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","бо яны варожа паставіліся да вас і ашуквалі вас праз Пэора і праз Казьбі, дачку князя Мадыянскага, сястру іхнюю, забітую ў дзень кары за Пэора». ");
INSERT INTO bel_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","І сталася пасьля гэтай плягі, і сказаў ГОСПАД Майсею і Элеазару, сыну Аарона сьвятара, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Палічыце лічбу ўсёй грамады сыноў Ізраіля ад дваццаці гадоў і вышэй паводле дамоў бацькоў іхніх, усіх, здольных да бою». ");
INSERT INTO bel_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","І прамовілі Майсей і Элеазар сьвятар на раўнінах Мааву, насупраць Ерыхону, над Ярданам, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Палічыце ўсіх ад дваццаці гадоў і вышэй, як ГОСПАД загадаў Майсею і сынам Ізраіля, якія выйшлі з зямлі Эгіпецкай». ");
INSERT INTO bel_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Рубэн, першародны Ізраіля. Сыны Рубэна: Ханох, ад якога сям'я Ханоха, і Пальлю, ад якога сям'я Пальлю, ");
INSERT INTO bel_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","і Хецрон, ад якога сям'я Хецрона, і Кармі, ад якога сям'я Кармі. ");
INSERT INTO bel_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Гэта сем'і пакаленьня Рубэна, і было палічана іх сорак тры тысячы семсот трыццаць. ");
INSERT INTO bel_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Сыны Пальлю: Эліяў, ");
INSERT INTO bel_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","а сыны Эліява: Нэмуэль, Датан і Абірам. Датан і Абірам — гэта тыя пакліканыя грамадою, якія збунтаваліся супраць Майсея і Аарона разам з Карахам, калі яны паднялі бунт супраць ГОСПАДА, ");
INSERT INTO bel_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","і зямля разьзявіла вусны свае, і праглынула іх і Караха, і паўмірала грамада, калі агонь спаліў дзьвесьце пяцьдзясят чалавек, і сталіся яны знакам. ");
INSERT INTO bel_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Але сыны Караха не памерлі. ");
INSERT INTO bel_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Сыны Сымона паводле сем'яў іхніх: ад Нэмуэля паходзіць сям'я Нэмуэля; ад Яміна — сям'я Яміна; ад Яхіна — сям'я Яхіна, ");
INSERT INTO bel_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ад Зэраха — сям'я Зэраха; ад Шаўля — сям'я Шаўля. ");
INSERT INTO bel_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Гэта сем'і пакаленьня Сымона, дваццаць дзьве тысячы дзьвесьце. ");
INSERT INTO bel_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Сыны Гада паводле сем'яў іхніх: Цэфон, ад якога сям'я Цэфона; Хаггі, ад якога сям'я Хаггі; Шуні, ад якога сям'я Шуні, ");
INSERT INTO bel_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Озьні, ад якога сям'я Озьні; Эры, ад якога сям'я Эры, ");
INSERT INTO bel_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Арод, ад якога сям'я Арода; Арыэль, ад якога сям'я Арыэля. ");
INSERT INTO bel_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Гэта сем'і сыноў Гада, іх палічана сорак тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Сыны Юды: Ер і Янан, але яны абодва памерлі ў зямлі Ханаан. ");
INSERT INTO bel_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Вось сыны Юды паводле сем'яў іхніх: Шэля, ад якога сям'я Шэлі; Пэрэс, ад якога сям'я Пэрэса; Зэрах, ад якога сям'я Зэраха. ");
INSERT INTO bel_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","А вось сыны Пэрэса: Хецрон, ад якога сям'я Хецрона, і Хамуль, ад якога сям'я Хамуля. ");
INSERT INTO bel_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Гэта сем'і Юды, іх палічана семдзясят шэсьць тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Сыны Ісахара паводле сем'яў іхніх: Толя, ад якога сям'я Толі; Пува, ад якога сям'я Пувы; ");
INSERT INTO bel_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Яшуў, ад якога сям'я Яшува; Шымрон, ад якога сям'я Шымрона. ");
INSERT INTO bel_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Гэта сем'і Ісахара, палічана іх шэсьцьдзясят чатыры тысячы трыста. ");
INSERT INTO bel_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Сыны Завулёна паводле сем'яў іхніх: Сэрэд, ад якога сям'я Сэрэда; Элён, ад якога сям'я Элёна; Яхлеэль, ад якога сям'я Яхлеэля. ");
INSERT INTO bel_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Гэта сем'і Завулёна, палічана іх шэсьцьдзясят тысячаў пяцьсот. ");
INSERT INTO bel_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Сыны Язэпа паводле сем'яў іхніх: Манаса і Эфраім. ");
INSERT INTO bel_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Сыны Манасы: Махір, ад якога сям'я Махіра; Махір нарадзіў Гілеада, ад якога сям'я Гілеада. ");
INSERT INTO bel_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Сыны Гілеада: Езэр, ад якога сям'я Езэра; Хэлек, ад якога сям'я Хэлека; ");
INSERT INTO bel_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Асрыэль, ад якога сям'я Асрыэля; Мэхем, ад якога сям'я Мэхема, ");
INSERT INTO bel_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Шэміда, ад якога сям'я Шэміды; Хэфэр, ад якога сям'я Хэфэра. ");
INSERT INTO bel_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","А Цэлафхад, сын Хэфэра, ня меў сыноў, а толькі дочак, а імёны дочак Цэлафхада: Махля, Ноа, Хогля, Мілька і Тырца. ");
INSERT INTO bel_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Гэта сем'і Манасы, іх падлічана пяцьдзясят дзьве тысячы семсот. ");
INSERT INTO bel_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Гэта сыны Эфраіма паводле сем'яў іхніх: Шутэлях, ад якога сям'я Шутэляха; Бэхэр, ад якога сям'я Бэхэра; Тахан, ад якога сям'я Тахана. ");
INSERT INTO bel_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","А гэта сыны Шэтэляха: Эран, ад якога сям'я Эрана. ");
INSERT INTO bel_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Гэта сем'і сыноў Эфраіма, палічана іх трыццаць дзьве тысячы пяцьсот. Гэта сыны Язэпа паводле сем'яў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Сыны Бэн’яміна паводле сем'яў іхніх: Бэля, ад якога сям'я Бэлі; Ашбэль, ад якога сям'я Ашбэля; Ахірам, ад якога сям'я Ахірама; ");
INSERT INTO bel_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Шэфуфам, ад якога сям'я Шэфуфама; Хуфам ад якога сям'я Хуфама. ");
INSERT INTO bel_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","І былі сыны Бэлі: Ард і Нааман; ад Арда пахо­дзіць сям'я Арда, ад Наамана — сям'я Наамана. ");
INSERT INTO bel_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Гэта сыны Бэн’яміна паводле сем'яў сваіх, палічана іх сорак пяць тысячаў шэсьцьсот. ");
INSERT INTO bel_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Гэта сыны Дана паводле сем'яў іхніх: Шухам, ад якога сям'я Шухама. Гэта сем'і Дана паводле сем'яў сваіх; ");
INSERT INTO bel_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","усе яны сям'я Шухама, палічана іх шэсьцьдзясят чатыры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Сыны Асэра паводле сем'яў іхніх: Імна, ад якога сям'я Імны; Ішві, ад якога сям'я Ішві; Бэрыя, ад якога сям'я Бэрыі. ");
INSERT INTO bel_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Сыны Бэрыі: Хэвэр, ад якога сям'я Хэвэра; і Малькіэль, ад якога сям'я Малькіэля. ");
INSERT INTO bel_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","А імя дачкі Асэра — Сэраха. ");
INSERT INTO bel_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Гэта сем'і сыноў Асэра, палічана іх пяцьдзясят тры тысячы чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Сыны Нэфталі паводле сем'яў іхніх: Яхцэль, ад якога сям'я Яхцэля; Гуні, ад якога сям'я Гуні; ");
INSERT INTO bel_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Ецэр, ад якога сям'я Ецэра; Шылем, ад якога сям'я Шылема. ");
INSERT INTO bel_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Гэта сем'і Нэфталі паводле сем'яў сваіх, палічана іх сорак пяць тысячаў чатырыста. ");
INSERT INTO bel_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Гэта лічба сыноў Ізраіля: шэсьцьсот адна тысяча семсот трыццаць. ");
INSERT INTO bel_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Паміж імі будзе падзелена зямля ў спадчыну паводле лічбы імёнаў. ");
INSERT INTO bel_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Больш шматлікім павялічыш спадчыну іхнюю; менш шматлікім паменшыш спадчыну іхнюю; кожнаму асобна, паводле сьпісу, будзе дадзена спадчына. ");
INSERT INTO bel_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Зямля павінна быць падзелена жэрабям, і спадчыну атрымаюць паводле лічбы імёнаў у родах бацькоў іхніх. ");
INSERT INTO bel_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Жэрабям будзе падзеленая спадчына паміж шматлікімі і малалікімі сем'ямі». ");
INSERT INTO bel_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","А гэта лічба лявітаў паводле сем'яў іхніх: Гершон, ад якога сям'я Гершона; Кегат, ад якога сям'я Кегата; і Мэрары, ад якога сям'я Мэрары. ");
INSERT INTO bel_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Гэта сем'і Левія: сям'я Лібні, сям'я Хеўрона, сям'я Махлі, сям'я Мушы, сям'я Караха. І Кегат нарадзіў Амрама. ");
INSERT INTO bel_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Імя жонкі Амрама — Ёкэбэд, дачка Левія, якая нарадзілася Левію ў Эгіпце. Яна нарадзіла Амраму Аарона і Майсея, і сястру іхнюю Мірыям. ");
INSERT INTO bel_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","І нарадзіліся Аарону сыны: Надаў, Абігу, Элеазар і Ітамар. ");
INSERT INTO bel_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Але Надаў і Абігу памерлі, калі прынесьлі чужы агонь перад аблічча ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","І ўсіх было палічана іх дваццаць тры тысячы мужчынаў ад аднаго месяца і вышэй. Яны не палічаныя сярод сыноў Ізраіля, бо ня дадзена ім спадчына сярод сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Гэта палічаныя Майсеем і Элеазарам сьвятаром, якія палічылі сыноў Ізраіля на раўнінах Мааву над Ярданам насупраць Ерыхону. ");
INSERT INTO bel_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Між імі не было нікога з тых, якіх лічылі Майсей і Аарон сьвятар, калі лічылі сыноў Ізраіля ў пустыні Сынай, ");
INSERT INTO bel_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","бо сказаў ім ГОСПАД, што яны сьмерцю памруць у пустыні, і не застанецца з іх аніводнага, апрача Халева, сына Ефунны, і Егошуа, сына Нуна. ");
INSERT INTO bel_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","І наблізіліся дочкі Цэлафхада, сына Хэфэра, сына Гілеада, сына Махіра, сына Манасы, з сям'і Манасы, сына Язэпа, а імёны іхнія: Махля, Ноа, Хогля, Мілька і Тырца. ");
INSERT INTO bel_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","І сталі яны перад абліччам Майсея і Элеазара сьвятара, і перад абліччам князёў і усёй грамады каля ўваходу ў Намёт Спатканьня, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Бацька наш памёр у пустыні, але ня быў ён сярод грамады, якая сабралася разам з Карахам супраць ГОСПАДА, бо ён памёр у граху сваім, і не было сыноў у яго. ");
INSERT INTO bel_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Чаму мае зьнікнуць імя бацькі нашага з сям'і ягонай, бо ня меў ён сына? Дайце нам уласнасьць паміж братоў бацькі нашага». ");
INSERT INTO bel_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","І прынёс Майсей справу іхнюю перад аблічча ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","І сказаў ГОСПАД Майсею, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Справядліва дамагаюцца дочкі Цэлафхада. Дай ім уласнасьць, спадчыну паміж братоў бацькі іхняга, і няхай яны маюць спадчыну бацькі іхняга. ");
INSERT INTO bel_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","А да сыноў Ізраіля прамоў, кажучы: “Калі чалавек памрэ і сына мець ня будзе, спадчына ягоная пераходзіць на дачку ягоную. ");
INSERT INTO bel_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Калі ён ня мае дачкі, спадчыну ягоную аддайце братам ягоным. ");
INSERT INTO bel_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Калі ён ня мае братоў, аддайце спадчыну ягоную братам бацькі ягонага. ");
INSERT INTO bel_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Калі няма братоў бацькі ягонага, тады спадчына ягоная пераходзіць найбліжэйшаму сваяку ў сям'і ягонай, і ён возьме спадчыну”. І гэта будзе пастанова для сыноў Ізраіля, прысуд, які загадаў ГОСПАД Майсею». ");
INSERT INTO bel_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","І сказаў ГОСПАД Майсею: «Узыйдзі на гару Абарым і паглядзі на зямлю, якую Я дам сынам Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","І ты ўбачыш яе, і будзеш далучаны да народу свайго, як быў далучаны Аарон, брат твой, ");
INSERT INTO bel_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","бо вы супрацівіліся слову з вуснаў Маіх у пустыні Сін падчас бунту грамады, бо вы не зьявілі сьвятасьць Маю перад вачыма іхнімі, даючы ім вады». Гэта вада Мэрывы каля Кадэшу ў пустыні Сін. ");
INSERT INTO bel_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","І прамовіў Майсей да ГОСПАДА, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Няхай ГОСПАД, Бог духаў і кожнага цела, прызна­чыць чалавека, які будзе кіраваць грамадой гэтай, ");
INSERT INTO bel_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","і які будзе выходзіць і ўваходзіць перад абліччам іхнім, выводзіць іх і ўводзіць, каб ня сталася грамада ГОСПАДА як авечкі без пастуха». ");
INSERT INTO bel_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","І сказаў ГОСПАД Майсею: «Вазьмі Егошуа, сына Нуна, чалавека, на якім Дух Божы; і ўскладзі рукі твае на яго. ");
INSERT INTO bel_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","І пастаў яго перад абліччам Элеазара сьвятара і перад абліччам усёй грамады, і перад вачыма іхнімі пастаў яго правадыром. ");
INSERT INTO bel_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","І ўладай сваёй падтрымай яго, каб слухала яго ўся грамада сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","І стане ён перад абліччам Элеазара сьвятара, а ён пра яго спытаецца перад абліччам ГОСПАДА праз суд урыму. Паводле слова з вуснаў Ягоных будзе выходзіць і ўваходзіць ён сам, і ўсе сыны Ізраіля з ім, і ўся грамада». ");
INSERT INTO bel_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","І зрабіў Майсей так, як яму загадаў ГОСПАД. І ўзяў Егошуа, і паставіў яго перад абліччам Элеазара сьвятара і ўсёй грамады, ");
INSERT INTO bel_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","і ўсклаў на яго рукі свае, і паставіў яго правадыром, як прамовіў ГОСПАД праз Майсея. ");
INSERT INTO bel_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Загадай сынам Ізраіля і скажы ім: “Няхай пільну­юць, каб у свой час складаць дары ахвярныя Мне і хлеб Мой, ахвяру агнявую на мілы пах Мне”. ");
INSERT INTO bel_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","І скажаш ім: “Гэта ахвяра агнявая, якую вы павінны складаць ГОСПАДУ: два аднагадовыя ягняты штодзень у ахвяру цэласпаленьня заўсёды. ");
INSERT INTO bel_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Адно ягня складзіцё ў ахвяру раніцай, а другое скла­дзіцё ўвечары, ");
INSERT INTO bel_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","і дзясятую частку эфы пшанічнай мукі, запраўленай чацьвёртай часткай гіну най­чысьцейшага алею як ахвяру хлебную. ");
INSERT INTO bel_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Гэта цэласпаленьне заўсёднае, якое склалі вы на гары Сынай на мілы пах, ахвяра агнявая ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","І як ахвяру вадкую чацьвёртую частку гіну віна на кожнае ягня. На сьвятым месцы вылівайце ахвяру вадкую, сікеру для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","А другое ягня складзіцё ў ахвяру ўвечары, і ахвяру хлебную, і ахвяру вадкую, як раніцаю. Гэта ахвяра агнявая, мілы пах ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","А ў дзень суботы ахвяруеце двух аднагадовых ягнятаў без заганы і дзьве дзясятыя эфы мукі, запраўленай алеем, як ахвяру хлебную, і ахвяру вадкую. ");
INSERT INTO bel_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Гэта суботняя ахвяра цэласпаленьня на кожную суботу, апрача заўсёднай ахвяры цэласпаленьня і ахвяры вадкай. ");
INSERT INTO bel_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","А ў кожны першы дзень вашага месяца складайце ГОСПАДУ ахвяру цэласпаленьня: два бычкі, аднаго барана і сем аднагадовых ягнят без заганы. ");
INSERT INTO bel_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","На кожнага бычка палажыце тры дзясятыя эфы пшанічнай мукі, запраўленай алеем, як ахвяру хлебную, і на кожнага барана — дзьве дзясятыя эфы пшанічнай мукі, запраўленай алеем, як ахвяру хлебную, ");
INSERT INTO bel_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","і на кожнае ягня як ахвяру хлебную палажыце дзясятую частку эфы пшанічнай мукі, запраўленай алеем. Гэта цэла­спаленьне, мілы пах, ахвяра агнявая ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","І ахвяра вадкая: палова гіну віна на бычка, адна трэцяя гіну на барана і адна чацьвёртая гіну на ягня. Гэта цэласпаленьне ў кожны першы дзень месяца на ўсе месяцы году. ");
INSERT INTO bel_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","І адзін казёл будзе складзены ГОСПАДУ ў ахвяру за грэх, апрача заўсёднай ахвяры цэласпаленьня і належная ахвяра вадкая. ");
INSERT INTO bel_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","А ў першы месяц, у чатырнаццаты дзень месяца — Пасха ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","У пятнаццаты дзень гэтага месяца будзе сьвята. Сем дзён будзеце есьці толькі праснакі. ");
INSERT INTO bel_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","У першы дзень будзе сьвяты сход, ніякай працы, ніякай работы ў той дзень не рабіце. ");
INSERT INTO bel_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","І складзіце ахвяру агнявую, цэласпаленьне ГОСПАДУ: два бычкі, аднаго барана і сем аднагадовых ягнят без заганы; ");
INSERT INTO bel_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","і ахвяру хлебную з пшанічнай мукі, запраўленай алеем: тры дзясятыя эфы на бычка, дзьве дзясятыя на барана, ");
INSERT INTO bel_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","і адна дзясятая на кожнага з сямі ягнят, ");
INSERT INTO bel_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","і аднаго казла ў ахвяру за грэх, каб перапрасіць за вас. ");
INSERT INTO bel_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Апрача ранішняга цэла­спаленьня, якое цэласпаленьне заўсёднае, складайце гэтыя ахвяры. ");
INSERT INTO bel_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Такія ахвяры будзеце складаць штодзень сем дзён, як спажыву, ахвяру агнявую, мілы пах ГОСПАДУ. Апрача цэласпаленьня заўсёднага і ахвяры вадкай будуць складацца гэтыя ахвяры. ");
INSERT INTO bel_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","А ў дзень сёмы будзе для вас сьвяты сход, ніякай працы, ніякай работы не рабіце. ");
INSERT INTO bel_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","У дзень пяршынаў, калі складаеце ГОСПАДУ ахвяру з новага збожжа ў сьвята Тыдняў, будзе сьвяты сход, і ніякай працы, ніякай работы не рабіце. ");
INSERT INTO bel_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","І складзіце цэласпаленьне на мілы пах ГОСПАДУ: двух бычкоў, аднаго барана і сем аднагадовых ягнят, ");
INSERT INTO bel_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","і ахвяру хлебную: пшанічную муку, запраўленую алеем; тры дзясятыя эфы на аднаго бычка, дзьве дзясятыя на барана ");
INSERT INTO bel_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","і адна дзясятая на кожнага з сямі ягнят. ");
INSERT INTO bel_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","І аднаго казла, каб перапрасіць за вас. ");
INSERT INTO bel_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Апрача цэласпаленьня заўсёднага, і ахвяры хлебнай, і ахвяры вадкай, складайце гэта ў ахвяру; ахвяры маюць быць без заганы. ");
INSERT INTO bel_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","У сёмы месяц, у першы дзень месяца будзе ў вас сьвяты сход; ніякай працы, ніякай работы не рабіце, бо дзень гэты — дзень трубнага гуку. ");
INSERT INTO bel_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","І складзіце цэласпаленьне на мілы пах ГОСПАДУ: аднаго бычка, аднаго барана і сем ягнят аднагадовых без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","і ахвяру хлебную: пшанічную муку, запраўленую алеем; тры дзясятыя эфы на бычка, дзьве дзясятыя на барана, ");
INSERT INTO bel_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","і адну дзясятую на кожнага з сямі ягнят. ");
INSERT INTO bel_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","І аднаго казла ў ахвяру за грэх, каб перапрасіць за вас. ");
INSERT INTO bel_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Апрача цэласпаленьня на пачатак месяца і яго ахвяры хлебнай і апрача цэласпаленьня заўсёднага і яго ахвяры хлебнай і ахвяры вадкай, паводле пастановы складайце іх на мілы пах, ахвяру агнявую ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","У дзясяты дзень таго самага сёмага месяца будзе сьвяты сход і будзеце ўпакорваць душы вашыя; ніякай працы ня будзеце рабіць. ");
INSERT INTO bel_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","І складзіце ў ахвяру цэла­спаленьня ГОСПАДУ, на мілы пах аднаго бычка, аднаго барана і сем аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","і ахвяру хлебную: пшанічную муку, запраўленую алеем; тры дзясятыя эфы на бычка, дзьве дзясятыя на барана, ");
INSERT INTO bel_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","і адну дзясятую на кожнага з сямі ягнят. ");
INSERT INTO bel_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","І аднаго казла ў ахвяру за грэх, апрача ахвяры за грэх дзеля перамольваньня і цэласпаленьня заўсёднага разам з яго ахвярамі хлебнымі і вадкімі. ");
INSERT INTO bel_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","А ў пятнаццаты дзень сёмага месяца будзе сьвяты сход. Ніякай працы, ніякай работы ня будзеце рабіць. Будзеце сьвяткаваць сем дзён сьвята ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","І складзіце ў цэласпаленьне, ахвяру агнявую, на мілы пах ГОСПАДУ трынаццаць бычкоў, двух бараноў, чатыр­наццаць ягнят аднагадовых без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","і ахвяру хлебную: пшанічную муку, запраўленую алеем, тры дзясятыя эфы на аднаго бычка; дзьве дзясятыя на аднаго барана, ");
INSERT INTO bel_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","і адну дзясятую на кожнага з чатырнаццаці ягнят. ");
INSERT INTO bel_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","І аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","У другі дзень ахвяруеце дванаццаць бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","У трэці дзень ахвяруеце адзінаццаць бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","У чацьвёрты дзень ахвяруеце дзесяць бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","У пяты дзень ахвяруеце дзевяць бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","У шосты дзень ахвяруеце восем бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","У сёмы дзень ахвяруеце сем бычкоў, двух бараноў і чатырнаццаць аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","У восьмы дзень будзе ўрачысты сход; ніякай працы, ніякай работы ня будзеце рабіць. ");
INSERT INTO bel_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","І складзіце цэласпаленьне, ахвяру агнявую на мілы пах ГОСПАДУ: аднаго бычка, аднаго барана і сем аднагадовых ягнят без заганы, ");
INSERT INTO bel_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","і ахвяру хлебную, і ахвяру вадкую да іх, да бычкоў, бараноў і ягнят, адпаведна да іх лічбы, паводле пастановы, ");
INSERT INTO bel_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","і аднаго казла ў ахвяру за грэх, апрача цэласпаленьня заўсёднага і яго ахвяраў хлебных і вадкіх. ");
INSERT INTO bel_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Гэта маеце складаць ГОСПАДУ пад час сьвятаў вашых, апрача таго, што ахвяруеце паводле шлюбаваньняў вашых і як дабраахвотныя дары на ахвяры цэласпаленьня, на ахвяры хлебныя, на ахвяры вадкія, і на ахвяры мірныя”». ");
INSERT INTO bel_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","І сказаў Майсей сынам Ізраіля ўсё, што загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","І прамовіў Майсей да пакаленьняў Ізраіля, кажучы: «Вось слова, якое загадаў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Калі мужчына паабяцае нешта ГОСПАДУ або зьвяжа сябе прысягай, забавязаўшы душу сваю, няхай не парушыць словы свае, але ўсё, што выйшла з вуснаў ягоных, зробіць. ");
INSERT INTO bel_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Калі жанчына паабяцае нешта ГОСПАДУ, або зьвяжа сябе прысягай у доме бацькі свайго і ў маладосьці сваёй, ");
INSERT INTO bel_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","і пачуе бацька ейны абяцаньне яе і забавязаньне, якім яна зьвязала душу сваю, і не запярэчыць бацька ейны, усе яе абяцаньні і ўсе яе забавязаньні, якімі яна зьвязала душу сваю, застануцца. ");
INSERT INTO bel_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Калі ў той дзень, калі пачуе бацька ейны, ён забароніць ёй гэта, усе абяцаньні яе і ўсе забавязаньні, якімі яна зьвязала душу сваю, будуць няважныя. ГОСПАД даруе ёй, бо бацька ейны забараніў ёй. ");
INSERT INTO bel_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Калі станецца, што вый­дзе яна замуж, і яна зьвязаная абяцаньнем або прысягай вуснаў сваіх, якімі яна зьвязала душу сваю, ");
INSERT INTO bel_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","і калі пачуе муж ейны і, пачуўшы, не запярэчыць, яе абяцаньні і яе забавязаньні, якімі яна зьвязала душу сваю, застануцца. ");
INSERT INTO bel_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","А калі пачуе муж ейны і забароніць ёй, тады абяцаньні яе, якія на ёй, і прысягі вуснаў яе, якімі яна зьвязала душу сваю, будуць няважныя; і ГОСПАД даруе ёй. ");
INSERT INTO bel_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Але абяцаньне ўдавы або разьведзенай, кожнае, якім яна зьвязала душу сваю, застанецца на ёй. ");
INSERT INTO bel_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Калі жонка ў доме мужа свайго зьвязала душу сваю абяцаньнем або прысягаю, ");
INSERT INTO bel_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","і пачуе пра гэта муж, і будзе маўчаць, і не запярэ­чыць, тады ўсе абяцаньні і ўсе забавязаньні, якімі яна зьвязала душу сваю, застануцца на ёй. ");
INSERT INTO bel_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","А калі муж ейны, забараняючы, забароніць ёй, пачуўшы пра гэта, усё, што выйшла вуснаў яе, яе абяцаньні, якімі яна зьвязала душу сваю, будуць няважныя, бо муж забараніў; і ГОСПАД даруе ёй. ");
INSERT INTO bel_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Усе абяцаньні і ўсе прысягі, якімі яна зьвязала душу сваю, муж ейны можа пакінуць і можа забараніць. ");
INSERT INTO bel_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","А калі муж моўчкі маўчаў з дня на дзень, усе яе абяцаньні і ўсе прысягі застаюцца на ёй, павінна споўніць, бо муж маўчаў, калі пачуў пра гэта. ");
INSERT INTO bel_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","А калі ён забароніць праз нейкі час пасьля таго, як пачуў, ён сам панясе правіну сваю». ");
INSERT INTO bel_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Гэта пастановы, якія загадаў ГОСПАД Майсею адносна мужа і жонкі, бацькі і дачкі, калі яна яшчэ ў юнацтве жыве ў доме бацькі свайго». ");
INSERT INTO bel_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Помстай адпомсьці за сыноў Ізраіля Мадыянцам, а потым будзеш далучаны да народу свайго». ");
INSERT INTO bel_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","І прамовіў Майсей да народу, кажучы: «Узбройце спаміж сябе мужчынаў на вайну, і няхай яны выйдуць супраць Мадыянцаў, і выканаюць помсту ГОСПАДА над Мадыянцамі. ");
INSERT INTO bel_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Выбярыце па тысячы з пакаленьня, з кожнага пакаленьня Ізраіля і пашліце на вайну». ");
INSERT INTO bel_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","І выдзелена было па тысячы з кожнага пакаленьня Ізраіля, дванаццаць тысячаў узброеных да бою. ");
INSERT INTO bel_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","І паслаў іх Майсей па тысячы з пакаленьня, і Пінхас, сын Элеазара сьвятара, на вайну. І посуд сьвяты, і трубы былі ў руцэ ягонай. ");
INSERT INTO bel_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","І ваявалі яны супраць Мадыянцаў, як загадаў ГОСПАД Майсею, і выбілі ўсіх мужчынаў, ");
INSERT INTO bel_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","і валадароў Мадыяну пазабвалі, акрамя тых, якія загінулі ў бітве: Эвія, Рэкема, Цура, Хура, Рэву, пяць валадароў Мадыяну; і Білеама, сына Бэора, забілі мячом. ");
INSERT INTO bel_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","І ўзялі ў палон сыны Ізраіля жанчынаў Мадыянскіх і дзяцей іхніх. І ўсю жывёлу іхнюю, і ўсе статкі іхнія, і ўсю маёмасьць іхнюю забралі, ");
INSERT INTO bel_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","а ўсе гарады іхнія, усе паселішчы іхнія і ўсе мястэчкі іхнія спалілі агнём. ");
INSERT INTO bel_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","І забралі яны здабычу сваю, як людзей, так і жывёлу. ");
INSERT INTO bel_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","І прывялі яны палонных, і здабычу, і нарабаванае да Майсея і Элеазара сьвятара, і да ўсёй грамады сыноў Ізраіля ў табар на раўнінах Мааву над Ярданам насупраць Ерыхону. ");
INSERT INTO bel_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","І выйшлі Майсей і Элеазар сьвятар, і ўсе князі грамады на сустрэчу ім па-за табар. ");
INSERT INTO bel_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","І загневаўся Майсей на начальнікаў войска, на тысячнікаў і сотнікаў, якія вярталіся з вайны. ");
INSERT INTO bel_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","І сказаў ім Майсей: «Чаму вы пакінулі пры жыцьці ўсіх жанчынаў? ");
INSERT INTO bel_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ці ж не яны за намовай Білеама сыноў Ізраіля зрабілі нявернымі перад ГОСПАДАМ праз Пэора, і была пляга сярод грамады ГОСПАДА? ");
INSERT INTO bel_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","І цяпер забіце ўсіх дзяцей мужчынскага роду і ўсіх жанчынаў, якія пазналі мужчынаў. ");
INSERT INTO bel_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","А ўсіх дзяўчат, якія не пазналі мужчынаў, пакіньце пры жыцьці. ");
INSERT INTO bel_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","І вы будзеце па-за табарам сем дзён. Усе, хто забіў душу або дакрануўся да забітага, мусіць ачысьціцца ў трэці і ў сёмы дзень, вы і палонныя вашыя. ");
INSERT INTO bel_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","І ўсё адзеньне, і ўсе вырабы са скуры, і ўсё, што зроблена з воўны казінай, і ўсе драўляныя рэчы будуць ачышчаны». ");
INSERT INTO bel_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","І сказаў Элеазар сьвятар ваярам, якія былі на вайне: «Гэта пастанова закону, якую загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Золата, срэбра, медзь, жалеза, цына, волава ");
INSERT INTO bel_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","і ўсе рэчы, якія мо­гуць прайсьці праз агонь, няхай пройдуць праз агонь і будуць чыстымі. Тое, што ня можа прайсьці праз агонь, няхай пройдзе праз ваду, і будзе ачышчана нячыстасьць. ");
INSERT INTO bel_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","І ў сёмы дзень вы памыеце адзеньне вашае, і будзеце ачышчаныя, і ўвойдзеце ў табар». ");
INSERT INTO bel_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","І сказаў ГОСПАД Майсею, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Палічыце здабычу, якая здабытая, ад чалавека да жывёлы, ты і Элеазар сьвятар, і галовы дамоў грамады. ");
INSERT INTO bel_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","І падзеліш здабычу паміж тымі, што ваявалі і выйшлі на вайну, і паміж усёй грамадой. ");
INSERT INTO bel_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","І выдзеліш частку ГОСПАДУ ад ваяроў, якія былі на вайне — адну душу на пяцьсот, як з людзей, так і з валоў, аслоў і авечак. ");
INSERT INTO bel_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","І з гэтай паловы возьмеш і дасі Элеазару сьвятару як ахвярны дар ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","А з паловы сыноў Ізраіля вазьмі адну частку з пяцідзесяці: з людзей, валоў, аслоў і авечак, з усяго быдла, і дасі гэта лявітам, якія служаць пры Сялібе ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","І зрабілі Майсей і Элеазар сьвятар, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","І была здабыча, якую народ здабыў на вайне, — шэсьцьсот семдзясят пяць тысячаў авечак, ");
INSERT INTO bel_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","семдзясят дзьве тысячы валоў, ");
INSERT INTO bel_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","шэсьцьдзясят адна тысяча аслоў, ");
INSERT INTO bel_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","а душаў людзкіх, жанчынаў, якія не пазналі мужчынаў, было разам трыццаць дзьве тысячы. ");
INSERT INTO bel_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","І была палова дадзена тым, якія былі на вайне: трыста трыццаць сем тысячаў пяцьсот авечак. ");
INSERT INTO bel_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","І была частка ГОСПАДУ з авечак — шэсьцьсот семдзясят пяць авечак. ");
INSERT INTO bel_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","І было валоў трыццаць шэсьць тысячаў, а частка ГОСПАДУ была семдзясят два валы. ");
INSERT INTO bel_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","І было трыццаць тысячаў пяцьсот аслоў, а частка ГОСПАДУ была шэсьцьдзясят адзін асёл. ");
INSERT INTO bel_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","І было шаснаццаць тысячаў душаў людзкіх, а частка ГОСПАДУ была трыццаць дзьве душы. ");
INSERT INTO bel_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","І аддаў Майсей Элеазару сьвятару частку гэтую як дар ахвярны ГОСПАДУ, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","А палова для сыноў Ізраіля, якую ўзяў Майсей у ваяроў, была: ");
INSERT INTO bel_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","трыста трыццаць сем тысячаў пяцьсот авечак, ");
INSERT INTO bel_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","трыццаць шэсьць тысячаў валоў, ");
INSERT INTO bel_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","трыццаць тысячаў пяцьсот аслоў ");
INSERT INTO bel_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","і шаснаццаць тысячаў душаў людзкіх. ");
INSERT INTO bel_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","І ўзяў Майсей з паловы сыноў Ізраіля адну пяцідзясятую частку з людзей і жывёлы, і аддаў яе лявітам, якія служаць пры Сялібе ГОСПАДА, як загадаў ГОСПАД Майсею. ");
INSERT INTO bel_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","І прыйшлі да Майсея правадыры, начальнікі дружынаў войска, тысячнікі і сотнікі, ");
INSERT INTO bel_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","і сказалі Майсею: «Мы, слугі твае, палічылі ваяроў, якія пад рукой нашай, і не загінуў ніводзін з іх. ");
INSERT INTO bel_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","І прынесьлі мы як дар ахвярны ГОСПАДУ знойдзеныя вырабы з золата: ланцужкі, бранзалеты, пярсьцёнкі, завушніцы і нашыйнікі, каб перапрасіць за душы нашыя перад абліччам ГОСПАДА». ");
INSERT INTO bel_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","І ўзялі Майсей і Элеазар сьвятар золата і ўсе вырабы з яго. ");
INSERT INTO bel_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","І было золата, аддадзенага тысячнікамі і сотнікамі ў ахвяру ГОСПАДУ, шаснац­цаць тысячаў семсот пяцьдзясят сыкляў. ");
INSERT INTO bel_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","А кожны з ваяроў меў яшчэ сваю здабычу. ");
INSERT INTO bel_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","І ўзялі Майсей і Элеазар сьвятар золата ад тысячнікаў і сотнікаў, і занесьлі ў Намёт Спатканьня як памятны дар сыноў Ізраіля перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","А ў сыноў Рубэна і сыноў Гада былі шматлікія статкі, вельмі шматлікія. І яны ўбачылі зямлю Язэр і зямлю Гілеад, і вось, гэта на гадоўлю быдла. ");
INSERT INTO bel_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","І прыйшлі сыны Рубэна і сыны Гада, і сказалі Майсею, і Элеазару сьвятару, і князям грамады, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Атарот, Дыбон, Язэр, Німра, Хешбон, Элеале, Сэвам, Нэво і Вэон, ");
INSERT INTO bel_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","зямля, якую здабыў ГОСПАД перад абліччам грамады Ізраіля, зямля для гадоўлі быдла, а слугі твае маюць статкі». ");
INSERT INTO bel_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","І сказалі: «Калі мы знайшлі ласку ў вачах тваіх, дай гэтую зямлю слугам тваім на ўласнасьць, не пераводзь нас праз Ярдан». ");
INSERT INTO bel_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","І сказаў Майсей сынам Гада і сынам Рубэна: «Браты вашыя пойдуць ваяваць, а вы тут бу­дзеце сядзець? ");
INSERT INTO bel_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Навошта вы стрымліваеце сэрца сыноў Ізраіля, каб яны не перайшлі ў зямлю, якую даў ім ГОСПАД? ");
INSERT INTO bel_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Так зрабілі бацькі вашыя, калі я паслаў іх з Кадэш-Барнэа выведаць зямлю. ");
INSERT INTO bel_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","І дайшлі яны да даліны Эшколь, і ўбачылі яны зямлю, і збунтавалі яны сэрцы сыноў Ізраіля, каб не ішлі яны ў зямлю, якую даў ім ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","І ўзгарэўся гнеў ГОСПАДА ў той дзень і Ён прысягнуў, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","“Ня ўбачаць гэтыя людзі, якія выйшлі з Эгіпту ў дваццаць гадоў і вышэй, зямлі, якую Я пад прысягай абяцаў Абрагаму, Ісааку і Якубу, бо яны ня слухаліся Мяне, ");
INSERT INTO bel_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","акрамя Халева, сына Ефунны, Кенэзеяніна, і Егошуа, сына Нуна, бо яны слухаліся ГОСПАДА!” ");
INSERT INTO bel_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","І гневаўся ГОСПАД на Ізраіля, і вадзіў яго па пустыні сорак гадоў, пакуль не памерла ўсё пакаленьне, якое рабіла зло перад вачыма ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","І вось, вы сталі замест бацькоў вашых, людзей грэшных, каб павялічыць лютасьць гневу ГОСПАДА на Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Калі зноў адвернецеся ад Яго, зноў Ён будзе вадзіць вас па пустыні, і вы загубіце ўвесь народ гэты». ");
INSERT INTO bel_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","І яны падыйшлі бліжэй да яго, і сказалі: «Мы пабудуем загарадкі для авечак і для статкаў нашых і гарады для дзяцей нашых, ");
INSERT INTO bel_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","а самі, узброеныя, пойдзем хутка перад абліччам сыноў Ізраіля, пакуль не ўвядзём іх у месцы, дзе яны будуць жыць. Дзеці нашыя будуць жыць у гарадах мураваных дзеля небясьпекі ад жыхароў зямлі гэтай. ");
INSERT INTO bel_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ня вернемся мы ў дамы нашыя, пакуль не авалодаюць сыны Ізраіля спадчынай сваёй. ");
INSERT INTO bel_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Мы ня будзем шукаць спадчыны з імі на тым баку Ярдану або далей, бо ўжо маем спадчыну сваю на ўсходнім беразе Ярдану». ");
INSERT INTO bel_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","І Майсей сказаў ім: «Калі ўчыніце паводле слова гэтага, калі ўзброеныя пойдзеце перад абліччам ГОСПАДА на бітву, ");
INSERT INTO bel_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","і калі кожны з вас, узброены, пяройдзе Ярдан перад абліччам ГОСПАДА, аж пакуль Ён ня выганіць ворагаў Сваіх перад абліччам Сваім, ");
INSERT INTO bel_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","і будзе здабытая зямля перад абліччам ГОСПАДА, а потым вернецеся, тады ня будзеце вінаватыя перад ГОСПАДАМ і перад Ізраілем і возьмеце зямлю гэтую на ўласнасьць перад абліччам ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","А калі ня зробіце так, вы дапусьціцеся грэху перад ГОСПАДАМ, і ведайце, што грэх ваш знойдзе вас. ");
INSERT INTO bel_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Дык будуйце гарады дзецям вашым і загарадкі для авечак вашых, і тое, што выйшла з вуснаў вашых, зрабіце». ");
INSERT INTO bel_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","І сказалі сыны Гада і сыны Рубэна Майсею, кажучы: «Слугі твае зробяць так, як загадаў гаспадар наш. ");
INSERT INTO bel_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Дзеці нашыя, жонкі нашыя, статкі нашыя і ўсё быдла нашае застануцца ў гарадах Гілеаду, ");
INSERT INTO bel_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","а слугі твае, усе ўзброеныя, пойдуць перад абліччам ГОСПАДА на вайну, як прамовіў гаспадар наш». ");
INSERT INTO bel_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","І загадаў Майсей Элеазару сьвятару і Егошуа, сыну Нуна, і галовам дамоў бацькоў сыноў Ізраіля, ");
INSERT INTO bel_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","і сказаў ім Майсей: «Калі сыны Гада і сыны Рубэна разам з вамі пяройдуць Ярдан, усе ўзброеныя на бітву перад абліччам ГОСПАДА, і вы завалодаеце зямлёю, дайце ім зямлю Гілеад на ўласнасьць. ");
INSERT INTO bel_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","А калі ня пойдуць разам з вамі, узброеныя, атрымаюць пасяленьні паміж вас у зямлі Ханаан». ");
INSERT INTO bel_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","І адказалі сыны Гада і сыны Рубэна, кажучы: «Як прамовіў ГОСПАД да слугаў тваіх, так і зробім. ");
INSERT INTO bel_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Мы пойдзем, узброеныя, перад абліччам ГОСПАДА ў зямлю Ханаан, а ўласнасьць нашая, спадчына нашая з гэтага боку Ярдану». ");
INSERT INTO bel_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","І даў Майсей сынам Гада і Рубэна і палове пакаленьня Манасы, сына Язэпа, валадарства Сыгона, валадара Амарэйцаў, і валадарства Ога, валадара Башану, зямлю з гарадамі і гарады зямлі навокал. ");
INSERT INTO bel_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","І адбудавалі сыны Гада Дыбон, Атарот, Араэр, ");
INSERT INTO bel_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Атрот-Шафан, Язэр і Ёгбэгу, ");
INSERT INTO bel_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Бэт-Німру і Бэт-Гаран, мураваныя гарады і загарадкі для авечак. ");
INSERT INTO bel_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","А сыны Рубэна адбудавалі Хешбон, Элеале, Кірыятаім, ");
INSERT INTO bel_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Нэво, Баал-Мэон, зьмяніўшы іх назвы, Сібму, і назвалі імёны гарадоў, якія адбудавалі. ");
INSERT INTO bel_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","І пайшлі сыны Махіра, сына Манасы, у Гілеад, і занялі яго, і выгналі Амарэйцаў, што жылі ў ім. ");
INSERT INTO bel_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","І даў Майсей Гілеад Махіру, сыну Манасы, і ён абжыўся ў ім. ");
INSERT INTO bel_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","А Яір, сын Манасы, пайшоў і заняў мястэчкі Амарэйцаў, якія назваў Хават-Яір. ");
INSERT INTO bel_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","А Нобах пайшоў і заняў Кенат з ваколіцамі ягонымі, і назваў яго імем сваім, Нобах. ");
INSERT INTO bel_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Гэта месцы прыпынку сыноў Ізраіля, якія выйшлі з Эгіпту дружынамі сваімі пад рукою Майсея і Аарона. ");
INSERT INTO bel_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","І запісаў Майсей месцы табараў, з якіх яны паводле слова з вуснаў ГОСПАДА выхо­дзілі. Вось месцы прыпынку іхняга. ");
INSERT INTO bel_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","У першы месяц, у пятнаццаты дзень першага месяца, у другі дзень Пасхі вырушылі сыны Ізраіля з Рамсэсу, ведзеныя рукой узьнятай на вачах усіх Эгіпцянаў. ");
INSERT INTO bel_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","А Эгіпцяне хавалі ўсіх першародных сваіх, якіх забіў ГОСПАД, і ГОСПАД учыніў суд над багамі іхнімі. ");
INSERT INTO bel_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","І вырушылі сыны Ізраіля з Рамсэсу, і сталі табарам у Сукоце. ");
INSERT INTO bel_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","І вырушылі з Сукоту, і сталі табарам у Этаме, які на мяжы пустыні. ");
INSERT INTO bel_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","І вырушылі з Этаму, і завярнулі ў Пі-Гахірот, што каля Баал-Цэфону, і сталі табарам перад Мігдолам. ");
INSERT INTO bel_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","І выйшлі з Пі-Гахіроту, і перайшлі сярэдзінай мора ў пустыню, і тры дні ішлі праз пустыню, і сталі табарам у Мары. ");
INSERT INTO bel_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","І вырушылі з Мары, і прыйшлі ў Элім, а ў Эліме было дванаццаць крыніцаў водных і семдзясят пальмаў, і там сталі табарам. ");
INSERT INTO bel_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","І вырушылі з Эліму, і сталі табарам каля Мора Чырвонага. ");
INSERT INTO bel_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","І вырушылі ад Мора Чырвонага, і сталі табарам у пустыні Сін. ");
INSERT INTO bel_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","І вырушылі з пустыні Сін, і сталі табарам у Дафцы. ");
INSERT INTO bel_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","І вырушылі з Дафкі, і сталі табарам у Алушы. ");
INSERT INTO bel_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","І вырушылі з Алушы, і сталі табарам у Рэфідыме, і не было там вады для піцьця народу. ");
INSERT INTO bel_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","І вырушылі з Рэфідыму, і сталі табарам у пустыні Сынай. ");
INSERT INTO bel_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","І вырушылі з пустыні Сынай, і сталі табарам у Кіброт-Гатаве. ");
INSERT INTO bel_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","І вырушылі з Кіброт-Гатавы, і сталі табарам у Хацэроце. ");
INSERT INTO bel_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","І врушылі з Хацэроту, і сталі табарам ў Рытме. ");
INSERT INTO bel_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","І вырушылі з Рытмы, і сталі табарам у Рымон-Пэрэсе. ");
INSERT INTO bel_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","І вырушылі з Рымон-Пэрэсу, і сталі табарам у Лібне. ");
INSERT INTO bel_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","І вырушылі з Лібны, і сталі табарам у Рысе. ");
INSERT INTO bel_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","І вырушылі з Рысы, і сталі табарам у Кэгеляце. ");
INSERT INTO bel_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","І вырушылі з Кэгеляты, і сталі табарам на гары Шафэр. ");
INSERT INTO bel_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","І вырушылі з гары Шафэр, і сталі табарам у Харадзе. ");
INSERT INTO bel_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","І вырушылі з Хараду, і сталі табарам у Макэлёце. ");
INSERT INTO bel_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","І вырушылі з Макэлёту, і сталі табарам у Тахаце. ");
INSERT INTO bel_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","І вырушылі з Тахату, і сталі табарам у Тэраху. ");
INSERT INTO bel_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","І вырушылі з Тэраху, і сталі табарам у Мітцы. ");
INSERT INTO bel_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","І вырушылі з Міткі, і сталі табарам у Хашмоне. ");
INSERT INTO bel_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","І вырушылі з Хашмоны, і сталі табарам у Масэроце. ");
INSERT INTO bel_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","І вырушылі з Масэроту, і сталі табарам у Бэнэй-Яакане. ");
INSERT INTO bel_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","І вырушылі з Бэнэй-Яакану, і сталі табарам у Хар-Гагідгадзе. ");
INSERT INTO bel_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","І вырушылі з Хар-Гагідгаду, і сталі табарам у Ётбаце. ");
INSERT INTO bel_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","І вырушылі з Ётбаты, і сталі табарам у Аброне. ");
INSERT INTO bel_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","І вырушылі з Аброны, і сталі табарам у Эцыён-Гебэры. ");
INSERT INTO bel_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","І вырушылі з Эцыён-Гебэру, і сталі табарам у пус­тыні Сін, у Кадэшы. ");
INSERT INTO bel_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","І вырушылі з Кадэшу, і сталі табарам на гары Гор, на мяжы зямлі Эдому. ");
INSERT INTO bel_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","І ўзыйшоў Аарон сьвятар на гару Гор перад аблічча ГОСПАДА, і там памёр у саракавым годзе пасьля выхаду сыноў Ізраіля з зямлі Эгіпецкай, у пятым месяцы, у першы дзень месяца. ");
INSERT INTO bel_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Аарон меў сто дваццаць тры гады, калі памёр на гары Гор. ");
INSERT INTO bel_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","І пачуў валадар Араду, Хананеец, які жыў у Нэгеве ў зямлі Ханаан, што ідуць сыны Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","А яны вырушылі ад гары Гор і сталі табарам у Цальмоне. ");
INSERT INTO bel_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","І вырушылі з Цальмону, і сталі табарам у Пуноне. ");
INSERT INTO bel_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","І вырушылі з Пунону, і сталі табарам у Абоце. ");
INSERT INTO bel_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","І вырушылі з Аботу, і сталі табарам у Іе-Абарыме на мяжы Мааву. ");
INSERT INTO bel_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","І вырушылі з Іе-Абарыму, і сталі табарам у Дыбон-Гадзе. ");
INSERT INTO bel_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","І вырушылі з Дыбон-Гаду, і сталі табарам у Альмон-Дыблатаіме. ");
INSERT INTO bel_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","І вырушылі з Альмон-Дыблатаіму, і сталі табарам пад гарой Абарым, насупраць Нэво. ");
INSERT INTO bel_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","І вырушылі ад гары Абарым, і сталі табарам на раўнінах Мааву над Ярданам насупраць Ерыхону. ");
INSERT INTO bel_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","І яны сталі табарам паміж Бэт-Гаешымотам і Абэль-Шытымам на раўнінах Мааву. ");
INSERT INTO bel_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","І прамовіў ГОСПАД да Майсея на раўнінах Мааву над Ярданам насупраць Ерыхону, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«Прамоў да сыноў Ізраіля і скажы ім: “Вы пяройдзеце праз Ярдан у зямлю Ханаан, ");
INSERT INTO bel_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","дык выганіце перад сабою ўсіх жыхароў той зямлі, і паламіце ўсе выявы іхнія, і разьбіце ўсіх ідалаў іхніх, і ўсе ўзгоркі спусташыце. ");
INSERT INTO bel_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","І вы авалодаеце зямлёй, і будзеце жыць на ёй, бо Я даў вам яе на ўласнасьць. ");
INSERT INTO bel_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Падзяліце зямлю жэрабям паміж сем'ямі вашымі, шматлікай павялічце спадчыну яе, малалікай зьменшыце спадчыну яе. Як жэрабя выпадзе, так будзе падзелена спадчына. Паводле пакаленьняў бацькоў вашых атрымаеце спадчыну. ");
INSERT INTO bel_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","А калі ня выганіце перад сабою жыхароў зямлі гэтай, будуць тыя, якія з іх застануцца, цернямі ў вачах вашых і калючкамі ў баках вашых, і будуць яны ўціскаць вас у зямлі, у якой вы будзеце жыць. ");
INSERT INTO bel_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","І станецца тое, што Я задумаў ім зрабіць, Я вам зраблю”». ");
INSERT INTO bel_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Загадай сынам Ізраіля і скажы ім: “Калі ўвойдзеце ў зямлю Ханаан, вось зямля, якая будзе вам у спадчыну, зямля Ханаан у межах ейных. ");
INSERT INTO bel_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Паўднёвая мяжа будзе ад пустыні Сін да ваколіц Эдому, і будзе паўднёвая мяжа з усходу ад краю Мора Салёнага. ");
INSERT INTO bel_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","І зьверне мяжа вашая на поўдзень да ўзвышша Акраббім, і пойдзе праз Сін на поў­дзень да Кадэш-Барнэа, і пойдзе да Хацар-Адару, і дойдзе да Ацмону. ");
INSERT INTO bel_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Ад Ацмону паверне мяжа да ручаю Эгіпецкага і спыніцца на беразе мора. ");
INSERT INTO bel_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Вашай мяжой заходняй будзе для вас Мора Вялікае, гэта будзе ваша мяжа заходняя. ");
INSERT INTO bel_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","На поўначы будзе ў вас мяжа ад Мора Вялікага пачынаючы і аж да гары Гор, ");
INSERT INTO bel_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","і ад гары Гор павядзіце мяжу да ўваходу ў Хамат і далей, да мяжы Цэдаду. ");
INSERT INTO bel_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","І пойдзе мяжа да Зіфрону, і дойдзе да Гацар-Энану. Гэта будзе для вас мяжа паўночная. ");
INSERT INTO bel_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Усходнюю мяжу правядзіце ад Гацар-Энану да Шэфамы, ");
INSERT INTO bel_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","і ад Шэфамы пойдзе мяжа да Рыўлі на ўсход да Аіну, і зыйдзе мяжа далей, і прой­дзе праз горы на ўсход ад мора Кінэрэт, ");
INSERT INTO bel_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","і зыйдзе мяжа ўздоўж Ярдану, і спыніцца пры Моры Салёным. Гэта будзе зямля вашая з межамі сваімі наўкола”». ");
INSERT INTO bel_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","І загадаў Майсей сынам Ізраіля, кажучы: «Вось зямля, якую маеце падзяліць жэрабям і якую загадаў ГОСПАД даць дзевяці пакаленьням і палове пакаленьня. ");
INSERT INTO bel_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Бо пакаленьне сыноў Рубэна паводле дамоў бацькоў сваіх, і пакаленьне сыноў Гада паводле дамоў бацькоў сваіх, і палова пакаленьня Манасы атрымалі спадчыну сваю. ");
INSERT INTO bel_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Гэтыя два пакаленьні і палова пакаленьня ўзялі спадчыну сваю з таго боку Ярдану насупраць Ерыхону на ўсход». ");
INSERT INTO bel_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Гэта імёны людзей, якія падзеляць вам зямлю: Элеазар сьвятар і Егошуа, сын Нуна. ");
INSERT INTO bel_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","І возьмеце па адным князі з кожнага пакаленьня, каб падзяліць зямлю на ўласнасьць. ");
INSERT INTO bel_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Вось імёны тых людзей: з пакаленьня Юды — Халеў, сын Ефунны, ");
INSERT INTO bel_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","з пакаленьня сыноў Сымона — Шэмюэль, сын Амігуда, ");
INSERT INTO bel_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","з пакаленьня Бэн’яміна — Элідад, сын Кісьлёна, ");
INSERT INTO bel_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","з пакаленьня сыноў Дана — Букі, сын Ёглі, ");
INSERT INTO bel_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","з сыноў Язэпа, з пакаленьня сыноў Манасы — Ханіэль, сын Эфода, ");
INSERT INTO bel_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","з пакаленьня сыноў Эфраіма — Кэмуэль, сын Шыфтана, ");
INSERT INTO bel_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","з пакаленьня сыноў Завулёна — Эліцафан, сын Парнаха, ");
INSERT INTO bel_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","з пакаленьня сыноў Ісахара — Пальтыэль, сын Азана, ");
INSERT INTO bel_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","з пакаленьня сыноў Асэра — Эхігуд, сын Шэломіі, ");
INSERT INTO bel_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","з пакаленьня сыноў Нэфталі — Пэдагель, сын Амігуда». ");
INSERT INTO bel_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Гэта тыя, якім загадаў ГОСПАД падзяліць зямлю Ханаан між сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","І прамовіў ГОСПАД да Майсея на раўнінах Мааву каля Ярдану насупраць Ерыхону, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Загадай сынам Ізраіля, каб далі лявітам са спадчыны сваёй гарады, у якіх яны б жылі, і пашы кругом гарадоў дайце лявітам. ");
INSERT INTO bel_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","У гарадах яны будуць жыць, а пашы будуць для быдла іхняга, для статку іхняга і для ўсёй жывёлы іхняй. ");
INSERT INTO bel_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","І будуць пашы гарадоў, якія дасьцё лявітам, ад муроў гарадзкіх на тысячу локцяў наўкола. ");
INSERT INTO bel_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Адмерайце за горадам дзьве тысячы локцяў з боку ўсходняга, дзьве тысячы локцяў з боку паўднёвага, дзьве тысячы локцяў з боку заходняга і дзьве тысячы локцяў з боку паўночнага, каб сам горад быў пасярэдзіне; гэта будуць пашы вакол тых гарадоў. ");
INSERT INTO bel_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Гарады, якія дасьцё лявітам, будуць шэсьць гарадоў прыбежышча, каб забойца мог у іх схавацца, і апрача іх яшчэ сорак два гарады. ");
INSERT INTO bel_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Усіх гарадоў, якія разам з пашамі дасьцё лявітам, будзе сорак восем. ");
INSERT INTO bel_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Адносна гарадоў, якія дасьцё са спадчыны сыноў Ізраіля: ад шматлікага пакаленьня — большую лічбу, ад малалікага — меншую. Кожнае пакаленьне паводле вялікасьці атрыманай спадчыны дасьць гарады свае лявітам». ");
INSERT INTO bel_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","І прамовіў ГОСПАД да Майсея, кажучы: ");
INSERT INTO bel_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Прамоў да сыноў Ізраіля і скажы ім: “Калі пяройдзеце праз Ярдан у зямлю Ханаан, ");
INSERT INTO bel_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","выбярыце сабе гарады, якія будуць для вас прыбежышчам, уцячэ туды забойца, які выпадкова забіў душу. ");
INSERT INTO bel_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","І яны будуць вам гарадамі прыбежышча ад мсьціўцы за кроў, і забойца не памрэ, пакуль ня стане перад грамадою на суд. ");
INSERT INTO bel_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","А гарадоў, якія дасьцё як гарады прыбежышча, будзе шэсьць. ");
INSERT INTO bel_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Тры гарады дайце за Ярданам, а тры гарады — у зямлі Ханаан як гарады прыбежышча. ");
INSERT INTO bel_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Для сыноў Ізраіля і для прыхадняў, і для тых, хто пасяліўся сярод вас, будуць тыя шэсьць гарадоў прыбежышча, каб мог у іх уцячы той, хто ненаўмысна забіў душу. ");
INSERT INTO bel_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Калі чалавек ударыць іншага жалезам, і той памрэ, той, хто ўдарыў, — забойца; забойца сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Калі чалавек ударыў камянём, якім можна забіць, і забіў, ён — забойца; забойца сьмер­цю памрэ. ");
INSERT INTO bel_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Калі чалавек паленам, якім можна забіць, так ударыў чалавека, што той памёр, ён — забойца, забойца сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Мсьціўца за кроў заб’е забойцу; дзе сустрэне яго, заб'е яго. ");
INSERT INTO bel_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Калі хто з нянавісьці напаў на чалавека, або кінуў у яго штосьці з намерам забіць, і той памёр, ");
INSERT INTO bel_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","або калі хто ў злосьці ўдарыў рукою сваёй, і той памёр, той, хто ўдарыў, сьмерцю памрэ, бо ён — забойца; і мсьціў­ца за кроў заб'е яго, калі сустрэне. ");
INSERT INTO bel_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","А калі нехта выпадкова і бяз злосьці ўдарыў чалавека або кінуў у яго нечым ненаўмысна, ");
INSERT INTO bel_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","або, ня бачачы яго, пусьціў у яго камень, які можа забіць, і той памёр, але ён ня быў яго ворагам і ён не хацеў яму зла, ");
INSERT INTO bel_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","тады грамада павінна су­дзіць паміж тым, які ўдарыў, і мсьціўцам за кроў паводле судоў гэтых. ");
INSERT INTO bel_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","І выратуе грамада забойцу ад рукі мсьціўца за кроў і верне яго грамада ў горад прыбежышча, куды ён уцёк, і ён будзе там жыць да сьмерці сьвятара вялікага, які памазаны сьвятым алеем. ");
INSERT INTO bel_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Калі ж забойца выйдзе за межы гораду прыбежышча, у які схаваўся, ");
INSERT INTO bel_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","і калі мсьціўца за кроў сустрэне яго па-за межамі гораду прыбежышча, і заб'е мсьціўца за кроў забойцу, ён ня мае віны за кроў. ");
INSERT INTO bel_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Бо да сьмерці сьвятара вялікага павінен забойца быць у горадзе прыбежышча свайго. Пасьля сьмерці сьвятара вялікага можа ён вярнуцца ў зямлю спадчыны сваёй. ");
INSERT INTO bel_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","І будзе гэта для вас пастановай у-ва ўсе пакаленьні вашыя і ў-ва ўсіх месцах пражываньня вашага. ");
INSERT INTO bel_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Кожны, хто забіў душу, на падставе словаў з вуснаў сьведкаў будзе забіты як забойца. Але адзін сьведка ня будзе асуджаць душу на сьмерць. ");
INSERT INTO bel_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Не бярыце выкупу за душу забойцы, які варты сьмерці; ён сьмерцю памрэ. ");
INSERT INTO bel_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Не бярыце выкупу за ўцёк­шага ў горад прыбежышча, каб яму дазволіць жыць у зямлі сваёй перад сьмерцю першасьвятара. ");
INSERT INTO bel_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Не паганьце зямлі пражываньня вашага, бо кроў пага­ніць зямлю, і ніяк ня можа быць перапрошана за кроў, пралітую на зямлю, як толькі праз кроў таго, хто праліў яе. ");
INSERT INTO bel_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Не рабіце нячыстай зямлю, на якой будзеце жыць, бо Я буду жыць пасярод вас. Бо Я — ГОСПАД, Які жыву пасярод сыноў Ізраіля”». ");
INSERT INTO bel_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","І прыйшлі галовы бацькоў сем’яў сыноў Гілеада, сына Махіра, сына Манасы, з роду сыноў Язэпа, і расказалі Майсею, і князям, і галовам бацькоў сыноў Ізраіля, ");
INSERT INTO bel_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","і сказалі: «Гаспадару нашаму загадаў ГОСПАД жэрабям падзяліць зямлю паміж сынамі Ізраіля, і гаспадар наш атрымаў загад ГОСПАДА даць спадчыну Цэлафхада, брата нашага, дочкам ягоным. ");
INSERT INTO bel_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Але калі яны будуць жонкамі аднаго з сыноў іншага калена сыноў Ізраіля, спадчына іхняя адымецца ад спадчыны бацькоў нашых і далучыцца да таго пакаленьня, у якім яны будуць жыць, і наша частка, атрыманая жэрабям, змалее. ");
INSERT INTO bel_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","І калі для сыноў Ізраіля прыйдзе год юбілейны, тады іх спадчына будзе назаўсёды належаць да пакаленьня, да якога яны ўвайшлі, а спадчына пакаленьня бацькоў нашых паменшыцца на спадчыну іхнюю». ");
INSERT INTO bel_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","І загадаў Майсей сынам Ізраіля паводле слова з вуснаў ГОСПАДА, кажучы: «Справядлівае слова пакаленьня сыноў Язэпа. ");
INSERT INTO bel_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Вось слова, якое загадаў ГОСПАД дочкам Цэлафхада, кажучы: \"Яны могуць ісьці замуж за таго, хто добры ў вачах іхніх, але за мужчынаў пакаленьня бацькі свайго могуць ісьці замуж. ");
INSERT INTO bel_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Няхай не пераходзіць спадчына сыноў Ізраіля з аднаго пакаленьня ў другое пакаленьне. Няхай сыны Ізраіля трымаюцца спадчыны пакаленьня бацькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Кожная дзяўчына, якая атрымае спадчыну ў пакаленьні сыноў Ізраіля, стане жонкаю аднаго з мужчынаў пакаленьня бацькоў сваіх, каб сыны Ізраіля захавалі спадчыну бацькоў сваіх, ");
INSERT INTO bel_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","і каб спадчына не перахо­дзіла з аднаго пакаленьня ў другое пакаленьне. Пакаленьні сыноў Ізраіля павінны трымацца спадчыны сваёй\"». ");
INSERT INTO bel_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Як загадаў ГОСПАД Майсею, так і зрабілі дочкі Цэлафхада, ");
INSERT INTO bel_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","і выйшлі замуж Махля, Тырца, Хогля, Мілька і Ноа, дочкі Цэлафхада, за сыноў дзядзькоў сваіх. ");
INSERT INTO bel_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Пайшлі яны замуж за лю­дзей з сям'і сыноў Манасы, сына Язэпа, і так спадчына іхняя засталася пры пакаленьні сям'і бацькі іхняга. ");
INSERT INTO bel_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Гэта прыказаньні і прысуды, якія загадаў ГОСПАД праз Майсея сынам Ізраіля на раўнінах Мааву каля Ярдану насупраць Ерыхону.");
INSERT INTO bel_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1"," Вось словы, якія прамовіў Майсей да ўсяго Ізраіля за Ярданам у пустыні, у Арабе насупраць Суфу, паміж Паранам, Тафэлем, Лябанам, Хацэротам і Дызагабам, ");
INSERT INTO bel_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","на адлегласьці ў адзінаццаць дзён дарогі ад Харэву праз горы Сэір да Кадэш-Барнэа. ");
INSERT INTO bel_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","І сталася ў саракавым годзе, у адзінаццатым месяцы, у першы дзень месяца прамовіў Майсей да сыноў Ізраіля ўсё, што яму ГОСПАД загадаў сказаць ім. ");
INSERT INTO bel_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Пасьля перамогі над Сыгонам, валадаром Амарэйцаў, які жыў у Хешбоне, і Огам, валадаром Башану, які жыў у Аштароце ў Эдрэі, ");
INSERT INTO bel_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","за Ярданам, у зямлі Мааў, пачаў Майсей тлумачыць закон гэты, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«ГОСПАД, Бог наш, прамовіў да нас на Харэве, кажучы: “Досыць ужо вам быць на гэтай гары. ");
INSERT INTO bel_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Павярніцеся і выйдзіце, і ідз­іце на гару Амарэйцаў і да ўсіх суседзяў іхніх, у Арабу, у горы і ў даліны, і ў Нэгеў, і на бераг мора, у зямлю Хананейцаў, і ў Лібан, аж да ракі вялікай, ракі Эўфрат. ");
INSERT INTO bel_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Глядзіце, Я даў вам гэтую зямлю. Увайдзіце, вазьміце на ўласнасьць зямлю гэтую, якую запрысяг ГОСПАД даць Абрагаму, Ісааку і Якубу, і насеньню іхняму пасьля іх”. ");
INSERT INTO bel_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","І сказаў я вам у той час: “Не магу я адзін весьці вас; ");
INSERT INTO bel_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ГОСПАД, Бог ваш, па­множыў вас, і вось, сёньня вы шматлікія, як зоркі ў небе. ");
INSERT INTO bel_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ГОСПАД, Бог бацькоў вашых, няхай павялічыць вас у тысячу разоў і дабраславіць вас, як Ён гаварыў вам. ");
INSERT INTO bel_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Як я адзін панясу патрэбы вашыя, цяжары вашыя і спрэчкі вашыя? ");
INSERT INTO bel_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Выберыце сабе ў каленах вашых людзей мудрых, разумных і выспрабаваных, і я пастаўлю іх начальнікамі вашымі”. ");
INSERT INTO bel_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","І адказалі вы мне, і сказалі: “Добрая гэта рэч, якую ты кажаш зрабіць”. ");
INSERT INTO bel_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","І выбраў я тады з начальнікаў каленаў вашых мужоў справядлівых і выспрабаваных, і паставіў іх начальнікамі над вамі: тысячнікамі, сотнікамі, пяцідзясятнікамі, дзясятнікамі і загадчыкамі працы для каленаў вашых. ");
INSERT INTO bel_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","І загадаў я судзьдзям вашым, кажучы: “Слухайце справу братоў вашых і судзіце справядліва між чалавекам і братам ягоным, і прыхаднем. ");
INSERT INTO bel_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Не глядзіце на аблічча ў судзе, выслухайце як малога, так і вялікага. Ня бойцеся аблічча чалавека, бо гэта суд Божы. А справу, якая для вас будзе цяжкай, прынясіце да мяне, і я выслухаю яе”. ");
INSERT INTO bel_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","І я загадаў вам пра ўсе рэчы, якія вы маеце рабіць. ");
INSERT INTO bel_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","І вырушылі мы ад Харэву і прайшлі ўсю пустыню гэтую, вялікую і страшную, якую вы бачылі, па шляху да гор Амарэйскіх, як загадаў нам ГОСПАД, Бог наш, і прыйшлі ў Кадэш-Барнэа. ");
INSERT INTO bel_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","І я сказаў вам: “Вы прыйшлі да гор Амарэйскіх, якія ГОСПАД, Бог наш, дае нам. ");
INSERT INTO bel_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Глядзі, ГОСПАД, Бог ваш, даў зямлю перад абліччам вашым, увайдзі і вазьмі яе ў валоданьне, як сказаў табе ГОСПАД, Бог бацькоў тваіх; ня бойся і не палохайся”. ");
INSERT INTO bel_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","І падыйшлі вы ўсе да мяне, і сказалі: “Пашлём людзей перад абліччам нашым, каб агледзелі зямлю і паведамілі пра дарогу, якою маем ісьці, і пра гарады, у якія маем увайсьці”. ");
INSERT INTO bel_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","І было добрым у вачах маіх слова гэтае, і я выбраў спаміж вас дванаццаць мужоў, па адным з кожнага калена. ");
INSERT INTO bel_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","І яны выйшлі, і скіраваліся ў горы, і дайшлі да даліны Эшколь, і агледзелі яе. ");
INSERT INTO bel_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","І ўзялі яны ў рукі свае плады той зямлі, і прынесьлі нам, і паведамілі нам, і сказалі: “Добрая тая зямля, якую дае нам ГОСПАД, Бог наш”. ");
INSERT INTO bel_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Але вы не хацелі ісьці і не паслухалі слова ГОСПАДА, Бога нашага. ");
INSERT INTO bel_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","І наракалі ў намётах сваіх, і казалі: “З нянавісьці да нас вывеў нас ГОСПАД з зямлі Эгіпецкай, каб выдаць нас у рукі Амарэйцаў на загубу. ");
INSERT INTO bel_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Куды пойдзем? Браты нашыя напалохалі сэрцы нашыя, кажучы: “Народ той шматлікі і большы за нас, гарады там вялікія і аж у неба ўмацаваныя; і бачылі мы таксама там сыноў Анака”. ");
INSERT INTO bel_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","І сказаў я вам: “Не дрыжыце і ня бойцеся іх. ");
INSERT INTO bel_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ГОСПАД, Бог наш, Які ідзе перад намі, будзе ваяваць за нас, як зрабіў Ён у Эгіпце на вачах нашых, ");
INSERT INTO bel_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","і ў пустыні, дзе ты бачыў, як ГОСПАД, Бог твой, насіў цябе, як носіць чалавек сына свайго, на ўсім шляху, якім вы ішлі, аж пакуль не прыйшлі вы ў месца гэтае. ");
INSERT INTO bel_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Але вы так і не паверылі слову ГОСПАДА, Бога вашага, ");
INSERT INTO bel_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Які ішоў перад вамі ў дарозе, каб шукаць вам месца для табару вашага — ноччу ў агні, каб асьвятляць вам шлях, якім маеце ісьці, а ўдзень — у воблаку”. ");
INSERT INTO bel_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","І пачуў ГОСПАД голас словаў вашых, і разгневаўся, і прысягнуў, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Ня ўбачыць ніводзін чалавек з гэтага пакаленьня ліхога тую добрую зямлю, якую Я прысягнуў даць бацькам вашым, ");
INSERT INTO bel_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","акрамя Халева, сына Ефунны. Ён яе ўбачыць, яму і сынам яго дам Я зямлю гэтую, па якой ён хадзіў, бо ён спаўняў слова ГОСПАДА”. ");
INSERT INTO bel_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Таксама на мяне загневаўся ГОСПАД з-за вас, кажучы: “І ты туды ня ўвойдзеш. ");
INSERT INTO bel_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Егошуа, сын Нуна, які стаіць перад абліччам тваім, ён туды ўвойдзе. Яго падбадзёрвай, бо ён дасьць Ізраілю ў валоданьне зямлю. ");
INSERT INTO bel_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Дзеці вашыя, пра якіх вы гаварылі, што павядуць іх у палон, і сыны вашыя, якія сёньня не разумеюць, што добрае, а што ліхое, яны ўвойдуць туды; ім Я дам зямлю гэтую, і яны завалодаюць ёю. ");
INSERT INTO bel_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","А вы павярніце і рушце ў пустыню шляхам да Мора Чырвонага”. ");
INSERT INTO bel_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","І адказалі вы мне, і сказалі: “Саграшылі мы перад ГОСПАДАМ, мы пойдзем і будзем ваяваць, як загадаў нам ГОСПАД, Бог наш”. І вы перапаясаліся зброяй баявой і адважыліся пайсьці на гару. ");
INSERT INTO bel_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","І сказаў ГОСПАД мне: “Скажы ім: \"Не ўзыходзьце і не ваюйце, бо няма Мяне сярод вас, каб не пабілі вас ворагі вашыя\"”. ");
INSERT INTO bel_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","І я прамаўляў да вас, і вы не паслухалі, і супрацівіліся слову ГОСПАДА, і, гнаныя пыхаю, узыйшлі на гару. ");
INSERT INTO bel_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","І выйшлі супраць вас Амарэйцы, якія жылі на той гары, і пагналі вас, як робяць пчолы, і білі вас ад Сэіру аж да Хармы. ");
INSERT INTO bel_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","І вярнуліся вы, і плакалі перад абліччам ГОСПАДА, але ГОСПАД ня выслухаў голасу вашага і не прыхіліў вуха да вас. ");
INSERT INTO bel_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","І былі вы ў Кадэшы шмат дзён, столькі дзён, колькі там заставаліся. ");
INSERT INTO bel_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","І павярнуліся мы, і рушылі мы ў пустыню шляхам да Мора Чырвонага, як да мяне прамовіў ГОСПАД, і шмат дзён абыходзілі вакол гару Сэір. ");
INSERT INTO bel_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","І сказаў ГОСПАД мне, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Досыць вам хадзіць кругом гары гэтай, Зьвярніце на поўнач. ");
INSERT INTO bel_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","А народу загадай, кажучы: \"Вы будзеце праходзіць праз пасяленьні братоў вашых, сыноў Эзава, якія жывуць у Сэіры, і яны будуць баяцца вас, і вы будзьце вельмі ўважлівыя, ");
INSERT INTO bel_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","не чапайце іх, бо Я ня дам вам зямлі іхняй нават на стапу нагі, таму што гару Сэір Я даў у валоданьне Эзаву. ");
INSERT INTO bel_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ежу купляйце ў іх за срэбра і ешце; таксама ваду купляйце ў іх за срэбра і піце. ");
INSERT INTO bel_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Бо ГОСПАД, Бог твой, дабраславіў цябе ў кожнай справе рук тваіх. Ён ведае вандроўку тваю ў гэтай пустыні вялікай. Вось, сорак гадоў ГОСПАД, Бог твой, з табою, і нічога табе не бракавала\"”. ");
INSERT INTO bel_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","І абмінулі мы братоў нашых, сыноў Эзава, якія жылі ў Сэіры, шляхам на Арабу, Элят і Эцыён-Гэбэр, і завярнулі, і пайшлі шляхам у пустыню Мааў. ");
INSERT INTO bel_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","І сказаў мне ГОСПАД: “Не варагуй супраць Мааву і не пачынай з імі вайны, бо Я ня дам нічога ў валоданьне табе з зямлі іхняй, бо Я аддаў Ар у валоданьне сынам Лота’”. ");
INSERT INTO bel_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Перад тым жылі ў ёй Эмімы, народ вялікі, шматлікі і высокі, як сыны Анака. ");
INSERT INTO bel_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Лічылі іх Рэфаімамі, як і сыноў Анака. А Мааўляне называюць іх Эмімамі. ");
INSERT INTO bel_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","А ў Сэіры жылі раней Харэі, але сыны Эзава выгналі іх, і вынішчылі іх перад абліччам сваім, і пасяліліся на месцы іхнім, як зрабіў Ізраіль у зямлі спадчыны сваёй, якую даў яму ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Цяпер уставайце і перайдзіце праз ручай Зарэд”. І перайшлі мы ручай Зарэд. ");
INSERT INTO bel_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","А дзён, калі мы ішлі з Кадэш-Барнэа да ручая Зарэд, было трыццаць восем гадоў, аж пакуль не згінула ў табары ўсё тое пакаленьне ваяроў, як ім гэта запрысяг ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Таксама рука ГОСПАДА была супраць іх, каб зьнішчыць іх у табары, аж пакуль яны не загінулі. ");
INSERT INTO bel_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","І сталася, калі згінулі ўсе ваяры, паміраючы сярод народу, ");
INSERT INTO bel_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","прамовіў да мяне ГОСПАД, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Ты сёньня пяройдзеш Ар, мяжу Мааву, ");
INSERT INTO bel_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","і наблізішся да сыноў Амона. Не чапай іх і не пачынай вайны з імі, бо Я ня дам табе нічога ў валоданьне з зямлі сыноў Амона, бо Я аддаў зямлю гэтую ў валоданьне сынам Лота”. ");
INSERT INTO bel_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Яна лічылася зямлёй Рэфаімаў; раней жылі ў ёй Рэфаімы, а сыны Амона называлі іх Замзумімамі. ");
INSERT INTO bel_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Народ гэта вялікі, шматлікі і высокі ростам, як сыны Анака, і зьнішчыў іх ГОСПАД перад абліччам сыноў Амона, і яны пасяліліся на месцы іхнім. ");
INSERT INTO bel_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Таксама зрабіў ГОСПАД сынам Эзава, якія жывуць у Сэіры, вынішчаючы перад імі Харэяў, і яны выгналі іх, і самі жывуць на месцы іхнім аж да гэтага дня. ");
INSERT INTO bel_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","І Авімаў, што жылі ў паселішчах аж да Газы, выгубілі Кафтарымы, якія выйшлі з Кафтору, і пасяліліся на месцы іхнім. ");
INSERT INTO bel_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Уставайце, рушце ў дарогу, і пераходзьце ручай Арнон. Вось, Я аддаў у рукі твае Сыгона, валадара Хешбону, Амарэйца; бяры на ўласнасьць зямлю ягоную, і пачынай вайну супраць яго. ");
INSERT INTO bel_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Сёньня Я пачну распаўсюджваць страх і жах перад табою на народы пад усім небам, каб пачуўшы імя тваё, яны баяліся і дрыжэлі перад табою”. ");
INSERT INTO bel_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","І паслаў я пасланцоў з пустыні Кэдэмот да Сыгона, валадара Хешбону, са словамі мірнымі, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Дазволь мне прайсьці праз зямлю тваю. Я пайду гасьцінцам, ня збочу ані ўправа, ані ўлева. ");
INSERT INTO bel_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Жыўнасьць продай мне за срэбра, каб я мог есьці. Таксама ваду продай мне за срэбра, каб я мог піць. Дазволь мне толькі прайсьці пехатою, ");
INSERT INTO bel_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","як дазволілі мне сыны Эзава, якія жывуць у Сэіры, і Мааўляне, якія жывуць у Ары, аж пакуль я дайду да Ярдану і перайду ў зямлю, якую мае даць нам ГОСПАД, Бог наш”. ");
INSERT INTO bel_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Але Сыгон, валадар Хешбону, не захацеў дазволіць нам прайсьці праз зямлю ягоную, бо ГОСПАД, Бог наш, закамяніў дух ягоны і сэрца ягонае зрабіў цьвёрдым, каб аддаць яго ў рукі твае, як гэта сталася сёньня. ");
INSERT INTO bel_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","І сказаў ГОСПАД мне: “Вось, Я пачынаю аддаваць табе Сыгона і зямлю ягоную. Пачынай, авалодвай, каб успадкаеміць зямлю ягоную”. ");
INSERT INTO bel_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","І выйшаў супраць нас Сыгон, ён і ўвесь народ ягоны, на вайну ў Ягац. ");
INSERT INTO bel_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","І выдаў яго нам ГОСПАД, Бог наш; і пабілі мы яго, і сыноў ягоных, і ўвесь народ ягоны. ");
INSERT INTO bel_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","У той час узялі мы ўсе гарады ягоныя і палажылі закляцьце на кожны горад, на мужчынаў, і жанчынаў, і дзяцей, нікога з іх не пакінулі, ");
INSERT INTO bel_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","акрамя жывёлы, якую ўзялі сабе, і здабычы з гарадоў, занятых намі. ");
INSERT INTO bel_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ад Араэру, які на беразе ручая Арнон, і ад гораду ў даліне аж да Гілеаду не было для нас гораду, які быў мацнейшы за нас; усё аддаў нам ГОСПАД, Бог наш. ");
INSERT INTO bel_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Толькі да зямлі сыноў Амона ты не набліжаўся, і да мясцовасьцяў вакол ручая Ябок, да гарадоў у гарах, і ўсё было, як загадаў ГОСПАД, Бог наш. ");
INSERT INTO bel_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","І мы зьвярнулі, і пайшлі шляхам на Башан; і выйшаў Ог, валадар Башану, супраць нас, ён і ўвесь народ ягоны, на вайну ў Эдрэі. ");
INSERT INTO bel_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","І сказаў ГОСПАД мне: “Ня бойся яго, бо Я выдаў у рукі твае яго, і ўвесь народ ягоны, і зямлю ягоную, і ты зробіш яму тое, што зрабіў Сыгону, валадару Амарэйцаў, які жыў у Хешбоне”. ");
INSERT INTO bel_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","І аддаў ГОСПАД, Бог наш, у рукі нашыя таксама Ога, валадара Башану, і ўвесь народ ягоны, і вынішчылі мы яго так, што ніхто не ацалеў. ");
INSERT INTO bel_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","І здабылі мы ўсе гарады ягоныя ў той час, і не засталося гораду, які б мы не занялі, шэсьцьдзясят гарадоў, увесь абшар Аргоб, валадарства Ога ў Башане. ");
INSERT INTO bel_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Усе гэтыя гарады былі ўмацаваныя мурамі высокімі, і брамамі, і заваламі, ня лічачы шматлікіх гарадоў адкрытых. ");
INSERT INTO bel_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","І палажылі мы закляцьце на іх, як зрабілі Сыгону, валадару Хешбону, аддаючы закляцьцю ўсе гарады, мужчынаў, і жанчынаў, і дзяцей, ");
INSERT INTO bel_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","а ўсю жывёлу і здабычу з гарадоў мы пакінулі сабе. ");
INSERT INTO bel_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","І ўзялі мы ў той час зямлю з рук двух валадароў Амарэйскіх, якія жылі за Ярданам, ад ручая Арнон аж да гары Гермон. ");
INSERT INTO bel_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Сідонцы называюць Гермон Сырыёнам, а Амарэйцы называюць яго Сэнірам. ");
INSERT INTO bel_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Усе гарады на раўніне, увесь Гілеад і ўвесь Башан аж да Сальхі і Эдрэі, гарады валадарства Ога ў Башане, ");
INSERT INTO bel_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","бо Ог, валадар Башану, быў апошні з Рэфаімаў. Вось, дамавіна ягоная, дамавіна жалезная знаходзіцца ў Раббе сыноў Амона; дзевяць локцяў даўжыня яе, і чатыры локці шырыня яе меркаю локця чалавечага. ");
INSERT INTO bel_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","І ўзялі мы на ўласнасьць у той час усю зямлю гэтую ад Араэру, які над ручаём Арнон, і палову гары Гілеад, і гарады іхнія я даў сынам Рубэна і Гада. ");
INSERT INTO bel_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","А рэшту Гілеаду і ўвесь Башан, валадарства Ога, я даў палове калена Манасы, увесь абшар Аргоб. А ўвесь Башан называўся зямлёй Рэфаімаў. ");
INSERT INTO bel_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Яір, сын Манасы, узяў увесь абшар Аргоб аж да мяжы сыноў Гешура і Мааха, і назваў яго імем сваім. І да сёньня называюць гэтую частку Башану Хавот-Яір. ");
INSERT INTO bel_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","А Махіру я даў Гілеад. ");
INSERT INTO bel_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","І сынам Рубэна і Гада я даў зямлю ад Гілеаду аж да ручая Арнон, сярэдзіну ручая і мяжу, і аж да ручая Ябок, які ёсьць мяжою сыноў Амона, ");
INSERT INTO bel_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","і Арабу, і Ярдан як мяжу ад Кінэрэту да мора Арабы, Мора Салёнага каля падножжа гары Пісга на ўсход. ");
INSERT INTO bel_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","І я загадаў вам у гэты час, кажучы: “ГОСПАД, Бог ваш, даў вам зямлю гэтую на ўласнасьць; а вы ўсе, здатныя да бою, пойдзеце ўзброеныя перад абліччам братоў вашых, сыноў Ізраіля. ");
INSERT INTO bel_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Толькі жонкі вашыя, дзеці вашыя і статкі вашыя, — бо ведаю, што маеце вялікія статкі, — застануцца ў гарадах вашых, якія я даў вам, ");
INSERT INTO bel_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","аж пакуль ГОСПАД дасьць супачынак братам вашым, як даў вам, і яны возьмуць на ўласнасьць зямлю, якую ГОСПАД, Бог ваш, дае вам на тым баку Ярдану; і кожны вернецца да ўласнасьці сваёй, якую я даў вам”. ");
INSERT INTO bel_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","У той час я загадаў Егошуа, кажучы: “Вочы твае бачылі ўсё, што зрабіў ГОСПАД, Бог ваш, двум валадарам гэтым. Так зробіць ГОСПАД усім валадарствам, да якіх ты прыйдзеш. ");
INSERT INTO bel_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ня бойся іх, бо ГОСПАД, Бог ваш, будзе ваяваць за вас”. ");
INSERT INTO bel_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","І маліў я ў той час ГОСПАДА, кажучы: ");
INSERT INTO bel_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Госпадзе ГОСПАДЗЕ, Ты пачаў слузе Твайму аб’яўляць веліч Тваю і руку Тваю магутную. Які ж бог на небе або на зямлі зрабіў такія справы і чыны магутныя? ");
INSERT INTO bel_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Дазволь мне, калі ласка, перайсьці і ўбачыць тую добрую зямлю за Ярданам, тыя добрыя горы і Лібан”. ");
INSERT INTO bel_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Але разгневаўся ГОСПАД на мяне з-за вас, і ня выслухаў мяне, і сказаў ГОСПАД мне: “Досыць, больш не гавары Мне пра гэта. ");
INSERT INTO bel_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Узыйдзі на вяршыню гары Пісга і скіруй вочы свае на захад і на поўнач, на поў­дзень і на ўсход, і агледзь вачыма сваімі, бо гэтага Ярдану ты не пяройдзеш. ");
INSERT INTO bel_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","І загадай Егошуа, і падбадзёр яго, і падтрымай яго, бо ён пяройдзе наперадзе народу гэтага і дасьць Ізраілю ў валоданьне тую зямлю, якую ты ўбачыш”. ");
INSERT INTO bel_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","І былі мы ў даліне насупраць Бэт-Пэору. ");
INSERT INTO bel_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","А цяпер, Ізраіль, слухай пастановы і прысуды, якім я вучу вас, каб, выконваючы іх, вы жылі, і ўвайшлі, і завалодалі зямлёю, якую ГОСПАД, Бог бацькоў вашых, дае вам. ");
INSERT INTO bel_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Не дадавайце нічога да таго, што я загадваю вам, і не адымайце ад яго, захоўваючы прыказаньні ГОСПАДА, Бога вашага, якія я загадваю вам. ");
INSERT INTO bel_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Вочы вашыя бачылі тое, што зрабіў ГОСПАД у Баал-Пэоры, як ГОСПАД вынішчыў сярод вас кожнага, хто пайшоў за Баалам. ");
INSERT INTO bel_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","А вы ўсе, якія засталіся пры ГОСПАДЗЕ, Богу вашаму, жывецё аж па сёньня. ");
INSERT INTO bel_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Вось, я навучыў вас пастановам і прысудам, як загадаў мне ГОСПАД, Бог мой, каб вы так рабілі ў той зямлі, у якую ўваходзіце, каб атрымаць яе ў валоданьне. ");
INSERT INTO bel_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Захоўвайце і выконвайце іх, бо ў гэтым мудрасьць вашая і разумнасьць вашая перад вачыма народаў, якія, чуючы пра ўсе пастановы гэтыя, будуць казаць: \"Толькі такі народ мудры і разумны, як народ гэты вялікі!\" ");
INSERT INTO bel_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Бо дзе ж ёсьць такі народ вялікі, які б меў так блізкіх сабе багоў, як ГОСПАД, Бог наш, калі мы Яго клічам? ");
INSERT INTO bel_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","І які ж другі народ такі вялікі, які б меў пастановы і суды праведныя, як увесь гэты закон, які я сёньня даю вам? ");
INSERT INTO bel_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Толькі сьцеражыся і пільна захоўвай душу сваю, і не за­будзь усіх словаў, якія бачылі вочы твае, і няхай не адыйдуць яны ад сэрца твайго ў-ва ўсе дні жыцьця твайго, і ты дасі ве­даць гэта сыноў тваіх і сыноў сыноў тваіх. ");
INSERT INTO bel_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Памятай дзень, калі ты стаяў перад абліччам ГОСПАДА, Бога твайго, на Харэве, калі ГОСПАД сказаў мне: \"Зьбя­ры да Мяне народ, няхай пачуюць словы Мае, каб навучыліся баяцца Мяне ў-ва ўсе дні жыцьця на зямлі і навучылі гэтаму сыноў сваіх\". ");
INSERT INTO bel_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","І вы наблізіліся, і стаялі каля падножжа гары, а гара палала агнём аж пад неба, схаваная ў цемры, хмарах і змроку. ");
INSERT INTO bel_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","І прамовіў ГОСПАД да вас з сярэдзіны агню; і гук словаў вы чулі, але па-за голасам нічога ня бачылі. ");
INSERT INTO bel_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ён паведаміў вам запавет Свой, калі загадаў вам выконваць Дзесяць прыказаньняў, і напісаў іх на двух каменных табліцах. ");
INSERT INTO bel_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","У гэты час загадаў мне ГОСПАД вучыць вас пастановам і прысудам, каб вы іх выконвалі ў зямлі, якую маеце атрымаць на ўласнасьць. ");
INSERT INTO bel_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Сьцеражыце моцна душы вашыя, бо ня бачылі вы ў той дзень ніякага вобразу, калі гаварыў да вас ГОСПАД на гары Харэў спасярод агню, ");
INSERT INTO bel_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","каб вы не сапсуліся і не зрабілі сабе ідала, выявы ў выгля­дзе мужчыны або жанчыны, ");
INSERT INTO bel_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","або ў выглядзе нейкай жывёлы, якая на зямлі, або ў выглядзе птушкі, якая лётае ў небе, ");
INSERT INTO bel_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","або ў выглядзе нейкага паўзуна, які рухаецца па зямлі, або ў выглядзе рыбы, якая плавае ў вадзе ніжэй зямлі; ");
INSERT INTO bel_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","і каб часам, калі падымеш вочы свае ў неба і ўбачыш сонца, і месяц, і зоркі, і ўсё войска нябеснае, ты ня быў зьве­дзены імі і не пачаў пакланяцца ім і служыць ім, бо ГОСПАД, Бог твой, прызначыў іх усім народам пад небам. ");
INSERT INTO bel_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","А вас выбраў ГОСПАД і вывеў вас з печы жалезнай, з Эгіпту, каб вы сталіся народам Ягоным, уласнасьцю Ягонай, як гэта ёсьць сёньня. ");
INSERT INTO bel_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","З прычыны словаў вашых разгневаўся ГОСПАД на мяне і прысягнуў, што я не перайду Ярдан і не ўвайду ў зямлю добрую, якую дае табе ў спадчыну ГОСПАД, Бог твой. ");
INSERT INTO bel_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Бо я памру ў гэтай зямлі і не перайду праз Ярдан, але вы пяройдзеце праз яго і возьмеце на ўласнасьць гэтую зямлю добрую. ");
INSERT INTO bel_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Сьцеражыцеся, каб не забыліся вы пра запавет ГОСПАДА, Бога вашага, які заключыў Ён з вамі, і каб не рабілі вы сабе аніякай выявы, як загадаў табе ГОСПАД, Бог твой, ");
INSERT INTO bel_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","бо ГОСПАД, Бог твой, ёсьць агонь зьнішчальны, Бог зайздросны. ");
INSERT INTO bel_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Калі вы народзіце сыноў і ўнукаў і дажывяцё да старасьці ў зямлі гэтай, і спаганіцеся, і зробіце сабе статуі, нейкія выявы, і зробіце тое, што ліхім ёсьць у вачах ГОСПАДА, Бога вашага, і будзеце гнявіць Яго, ");
INSERT INTO bel_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","я бяру сёньня неба і зямлю за сьведкаў супраць вас, што хутка будзеце выгубленыя з зямлі, у якую вы пераходзіце праз Ярдан, каб атрымаць яе. Ня будуць доўгімі дні вашыя на ёй, бо зьнішчыць вас Госпад. ");
INSERT INTO bel_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","І расьцярушыць вас ГОСПАД сярод народаў, і няшмат з вас застанецца сярод народаў, да якіх выселіць вас ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","І там вы будзеце служыць багам, якія зробленыя рукамі людзей, дрэву і камяню, якія ня бачаць і ня чуюць, не ядуць і ня адчуваюць паху. ");
INSERT INTO bel_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","І там будзеш шукаць ГОСПАДА, Бога твайго, і зной­дзеш Яго, калі будзеш шу­каць Яго ўсім сэрцам тваім і ўсёю душою тваёй. ");
INSERT INTO bel_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","У горы тваім спаткаюць цябе ў апошнія дні ўсе гэтыя словы, і ты вернешся да ГОСПАДА, Бога твайго, і будзеш слухаць голас Ягоны, ");
INSERT INTO bel_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","бо ГОСПАД, Бог твой, — Бог міласэрны, Ён не пакіне цябе, і ня зьнішчыць, і не забудзецца пра запавет з бацькамі тваімі, які заключыў з імі. ");
INSERT INTO bel_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Спытайся ў дзён старадаўніх, якія былі перад табой ад дня, калі стварыў Бог чалавека на зямлі, і ад края неба да края неба, ці было нешта такое, як гэтая справа вялікая, і ці было чутно пра штосьці падобнае? ");
INSERT INTO bel_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ці які народ чуў голас Бога, Які прамаўляў з сярэдзіны агню, які ты чуў, і застаўся жывым? ");
INSERT INTO bel_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Або ці спрабаваў які бог прыйсьці і выбраць сабе народ спасярод іншых народаў праз выпрабаваньні, знакі, цуды і войны, рукою моцнаю і рамяном узьнятым праз жахі вялікія, як ўсё, што зрабіў вам ГОСПАД, Бог ваш, у Эгіпце на вачах тваіх? ");
INSERT INTO bel_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ты бачыў гэта, каб даведаўся, што ГОСПАД ёсьць Бог, і акрамя Яго няма іншага. ");
INSERT INTO bel_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ён даў табе з неба чуць голас Свой, каб навучыць цябе; на зямлі Ён даў табе ўбачыць агонь Свой вялікі, і Ты чуў словы Ягоныя з сярэдзіны агню. ");
INSERT INTO bel_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","І Ён палюбіў бацькоў тваіх, і выбраў насеньне іхняе пасьля іх, і вывеў цябе перад абліччам Сваім з Эгіпту сілаю Сваёю вялікаю, ");
INSERT INTO bel_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","каб выгнаць перад табой народы большыя і мацнейшыя за цябе і каб увесьці цябе ў зямлю іхнюю, і даць табе яе ў спадчыну, як ты гэта сёньня бачыш. ");
INSERT INTO bel_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Дык пераканайся сёньня і вазьмі ў сэрца тваё, што ГОСПАД ёсьць Бог у небе высока і на зямлі нізка, і няма іншага. ");
INSERT INTO bel_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","І захоўвай пастановы Ягоныя і прыказаньні Ягоныя, якія сёньня я загадваю табе, каб добра было табе і сынам тваім пасьля цябе і каб былі доўгія дні твае на зямлі, якую ГОСПАД, Бог твой, дае табе». ");
INSERT INTO bel_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","І вызначыў Майсей тры га­рады за Ярданам на ўсход сонца, ");
INSERT INTO bel_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","каб туды мог уцячы забойца, які забіў бліжняга свайго ненаўмысна, і ён ня меў яго ў нянавісьці ані ўчора, ані пазаўчора, і каб уцёк у адзін з гарадоў гэтых, і застаўся жыць. ");
INSERT INTO bel_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Гэта Бэцэр у пустыні на раўніне для сыноў Рубэна, Рамот у Гілеадзе для сыноў Гада, і Галян у Башане для сыноў Манасы. ");
INSERT INTO bel_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Такі вось закон даў Майсей сынам Ізраіля; ");
INSERT INTO bel_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","гэта сьведчаньні, пастановы і прысуды, якія абвясьціў ён сынам Ізраіля пасьля выхаду іхняга з Эгіпту ");
INSERT INTO bel_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","за Ярданам у даліне насуп­раць Бэт-Пэору, у зямлі Сыгона, валадара Амарэйцаў, які жыў у Хешбоне, якога зьнішчыў Майсей і сыны Ізраіля пасьля выхаду з Эгіпту. ");
INSERT INTO bel_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","І завалодалі яны зямлёй ягонай і зямлёй Ога, валадара Башану, двух валадароў Амарэйскіх, якія жылі за Ярданам на ўсход сонца; ");
INSERT INTO bel_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ад Араэру, які на беразе ручая Арнон, аж да гары Сырыён, значыць Гермон, ");
INSERT INTO bel_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","і ўсю Арабу за Ярданам на ўсходзе, аж да Мора Арабы каля падножжа гары Пісга. ");
INSERT INTO bel_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","І склікаў Майсей усяго Ізраіля, і сказаў ім: «Слухай, Ізраіль, пастановы і прысуды, якія я сёньня прамаўляю ў вушы вашыя, каб вы навучыліся ім і каб захоўвалі іх і выконвалі іх. ");
INSERT INTO bel_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ГОСПАД, Бог наш, заключыў запавет з намі на Харэве. ");
INSERT INTO bel_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Не з бацькамі нашымі заключыў Ён запавет гэты, але з намі, якія тут сёньня ўсе жывём. ");
INSERT INTO bel_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Абліччам да аблічча гаварыў з вамі ГОСПАД на гары з сярэдзіны агню. ");
INSERT INTO bel_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","У той час я стаяў між ГОСПАДАМ і вамі, каб вам абвясьціць слова ГОСПАДА, бо вы баяліся агню і не ўзыйшлі на гару, калі Ён казаў: ");
INSERT INTO bel_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Я — ГОСПАД, Бог твой, Які вывеў цябе з зямлі Эгіпецкай, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Ня будзеш мець іншых багоў перад абліччам Маім. ");
INSERT INTO bel_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Не рабі сабе статуі і ніякай выявы таго, што на небе высока і што на зямлі нізка, і што ў вадзе ніжэй зямлі. ");
INSERT INTO bel_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ня будзеш пакланяцца ім і ня будзеш служыць ім, бо Я — ГОСПАД, Бог твой, Бог зайздросны, Які карае за беззаконьні бацькоў дзяцей да трэцяга і чацьвёртага пакаленьня тых, што ненавідзяць Мяне, ");
INSERT INTO bel_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","і Які чыніць міласэрнасьць тысячам пакаленьняў тых, што любяць Мяне і захоўваюць прыказаньні Мае. ");
INSERT INTO bel_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Не ўжывай імя ГОСПАДА, Бога твайго, для марноты, бо ГОСПАД не пакіне без пакараньня таго, хто гаворыць імя Ягонае для марноты. ");
INSERT INTO bel_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Захоўвай дзень супачынку, каб сьвяціць яго, як загадаў табе ГОСПАД, Бог твой. ");
INSERT INTO bel_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Шэсьць дзён будзеш працаваць і будзеш рабіць усю работу тваю, ");
INSERT INTO bel_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","а дзень сёмы — супачынак для ГОСПАДА, Бога твайго. Ня будзеш рабіць аніякай работы ты і сын твой, і дачка твая, і слуга твой, і служка твая, і вол твой, і асёл твой, і ўся жывёла твая, і прыха­дзень, які ў брамах тваіх, каб адпачыў слуга твой і служка твая, як і ты. ");
INSERT INTO bel_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","І памятай, што ты быў нявольнікам у зямлі Эгіпецкай, і што вывеў цябе адтуль ГОСПАД, Бог твой, рукою моц­наю і рамяном узьнятым, і таму загадаў табе ГОСПАД, Бог твой, адзначаць дзень супачынку. ");
INSERT INTO bel_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Шануй бацьку твайго і маці тваю, як загадаў табе ГОСПАД, Бог твой, каб працягнуліся дні твае і добра табе было на зямлі, якую ГОСПАД, Бог твой, дае табе. ");
INSERT INTO bel_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Не забівай як забойца. ");
INSERT INTO bel_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Не чужалож. ");
INSERT INTO bel_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Не крадзі. ");
INSERT INTO bel_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ня сьведчы супраць бліжняга твайго сьведчаньнем фальшывым. ");
INSERT INTO bel_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Не жадай жонкі бліжняга твайго, і не жадай ані дому бліжняга твайго, ані поля ягонага, ані слугі ягонага, ані служкі ягонай, ані вала ягонага, ані асла ягонага, ані нечага з таго, што ў бліжняга твайго”. ");
INSERT INTO bel_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Словы гэтыя прамовіў ГОСПАД да ўсёй царквы вашай на гары, з сярэдзіны агню і хмары, і змроку голасам моцным, і нічога больш не гаварыў; і напісаў гэта на двух табліцах каменных, якія даў мне. ");
INSERT INTO bel_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","І вось, калі пачулі вы голас спасярод цемры і калі ўбачылі гару, якая гарэла агнём, падыйшлі да мяне ўсе галовы каленаў вашых і старшыні, ");
INSERT INTO bel_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","і сказалі мне: “Вось, зьявіў нам ГОСПАД, Бог наш, славу Сваю і веліч Сваю. Мы чулі голас Ягоны з сярэдзіны агню і пераканаліся сёньня, што Бог можа прамовіць да чалавека, і ён застанецца жывы. ");
INSERT INTO bel_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Але цяпер навошта мы маем паміраць? Бо праглыне нас гэты агонь вялікі; калі мы яшчэ будзем слухаць голас ГОСПАДА, Бога нашага, мы паўміраем. ");
INSERT INTO bel_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Бо хто з тых, якія чулі, як мы, голас Бога Жывога, Які прамаўляе з сярэдзіны агню, і застаўся жывым? ");
INSERT INTO bel_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ты сам падыйдзі і выслухай усё, што скажа ГОСПАД, Бог наш, і ты перакажаш нам усё, што скажа табе ГОСПАД, Бог наш, і мы выслухаем, і зробім гэта”. ");
INSERT INTO bel_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","І пачуў ГОСПАД голас словаў вашых да мяне, і сказаў мне ГОСПАД: “Я чуў голас словаў народу гэтага, што яны казалі табе. Усё добра яны казалі. ");
INSERT INTO bel_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Хто дасьць ім, каб засталося ў сэрцы іхнім, каб яны баяліся Мяне і захоўвалі ўсе прыказаньні Мае ўсе дні, каб добра ім было і сынам іхнім на вякі? ");
INSERT INTO bel_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ідзі і скажы ім: \"Вярніцеся ў намёты вашыя\". ");
INSERT INTO bel_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","А ты застанься тут са Мною, і Я скажу табе ўсе прыказаньні, пастановы і прысуды, якім ты навучыш іх, і яны будуць выконваць іх у зямлі, якую Я дам ім на ўласнасьць”. ");
INSERT INTO bel_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Дык захоўвайце і выконвайце тое, што загадаў вам ГОСПАД, Бог ваш, і не адхіляйцеся ані ўправа, ані ўлева. ");
INSERT INTO bel_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","У-ва ўсім ідзіце дакладна тым шляхам, які загадаў вам ГОСПАД, Бог ваш, каб вы жылі і былі шчасьлівыя, і каб доўгімі былі дні вашыя на зямлі, якую атрымаеце. ");
INSERT INTO bel_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","І вось прыказаньні, пастановы і прысуды, якія загадаў ГОСПАД, Бог ваш, каб навучыць вас, каб вы выконвалі іх у зямлі, у якую вы ідзіцё, каб узяць яе на ўласнасьць, ");
INSERT INTO bel_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","каб ты баяўся ГОСПАДА, Бога твайго, і захоўваў усе прыказаньні і загады Ягоныя, якія я загадваю табе, сынам тваім і сынам сыноў тваіх на ўсе дні жыцця твайго, каб даўгавечныя былі дні твае. ");
INSERT INTO bel_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Слухай, Ізраіль, і захоўвай, і выконвай іх, каб добра табе было, і ты вельмі памножыўся ў зямлі, якая ацякае малаком і мёдам, як прамаўляў да цябе ГОСПАД, Бог бацькоў тваіх. ");
INSERT INTO bel_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Слухай, Ізраіль! ГОСПАД, Бог наш, — ГОСПАД адзіны. ");
INSERT INTO bel_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Любі ГОСПАДА, Бога твайго, усім сэрцам тваім, усёй душой тваёй і ўсёй моцай тваёю. ");
INSERT INTO bel_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Гэтыя словы, якія я загадваю табе сёньня, няхай будуць у сэрцы тваім. ");
INSERT INTO bel_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Паўтарай іх дзецям тваім, гавары іх, седзячы ў доме тваім, ідучы па дарозе, калі засынаеш і калі прачынаешся. ");
INSERT INTO bel_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Прывяжы іх як знак да рукі сваёй, няхай будуць яны павязкаю над вачыма тваімі. ");
INSERT INTO bel_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Напішы іх на дзьвярах дому твайго і на брамах тваіх. ");
INSERT INTO bel_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Калі ўвядзе цябе ГОСПАД, Бог твой, у зямлю, якую запрысяг бацькам тваім, Абрагаму, Ісааку і Якубу, калі дасьць табе гарады вялікія і добрыя, якіх ты не будаваў, ");
INSERT INTO bel_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","дамы, поўныя ўсякіх багацьцяў, якіх ты не зьбіраў, выкапаныя студні, якіх ты не капаў, вінаграднікі і аліўкавыя сады, якіх ты не садзіў, калі будзеш есьці і наясіся, ");
INSERT INTO bel_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","сьцеражыся, каб не забыўся ты пра ГОСПАДА, Які вывеў цябе з зямлі Эгіпецкай, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ГОСПАДА, Бога твайго, бойся, і Яму служы, і Ягоным імем прысягай. ");
INSERT INTO bel_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Не ідзі за багамі чужымі, за багамі народаў, якія навакол цябе, ");
INSERT INTO bel_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","бо ГОСПАД, Бог твой, Які ёсьць пасярод цябе, — Бог зай­здросны. Сьцеражыся, каб не ўзгарэўся гнеў ГОСПАДА, Бога твайго, на цябе і каб ня сьцёр Ён цябе з аблічча зямлі. ");
INSERT INTO bel_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Не выпрабоўвайце ГОСПАДА, Бога вашага, як вы выпрабоўвалі ў Масе. ");
INSERT INTO bel_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Захоўваючы, захоўвайце прыказаньні ГОСПАДА, Бога вашага, і сьведчаньні Ягоныя, і пастановы Ягоныя, якія Ён загадаў вам; ");
INSERT INTO bel_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","і рабі тое, што належыцца і што добрае ў вачах ГОСПАДА, каб было табе добра і ты ўвайшоў і ўспадкаеміў зямлю добрую, якую запрысяг ГОСПАД бацькам тваім, ");
INSERT INTO bel_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","каб выгнаў Ён усіх ворагаў тваіх перад абліччам тваім, як прамовіў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Калі спытаецца цябе ў будучыні сын твой, кажучы: “Што гэта за сьведчаньні, пастановы і прысуды, якія загадваў вам ГОСПАД, Бог наш?”, ");
INSERT INTO bel_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ты скажаш сыну твайму: “Былі мы нявольнікамі ў фараона ў Эгіпце, але вывеў нас ГОСПАД з Эгіпту рукою моцнаю, ");
INSERT INTO bel_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","і чыніў цуды і знакі вялікія і жудасныя ў Эгіпце супраць фараона і ўсяго дому ягонага на вачах нашых, ");
INSERT INTO bel_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","і вывеў нас адтуль, каб увесьці нас у зямлю, якую запрысяг бацькам нашым даць нам. ");
INSERT INTO bel_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","І загадаў нам ГОСПАД, каб мы выконвалі ўсе пастановы гэтыя і баяліся ГОСПАДА, Бога нашага, і каб добра нам было ўсе дні жыцьця нашага, як гэта ёсьць сёньня. ");
INSERT INTO bel_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","І будзе праведнасьць нашая ў тым, што мы будзем захоўваць і выконваць усе прыказаньні гэтыя перад абліччам ГОСПАДА, Бога нашага, як Ён нам загадаў”. ");
INSERT INTO bel_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Калі ГОСПАД, Бог твой, увядзе цябе ў зямлю, у якую ідзеш, каб завалодаць ёю, Ён выганіць перад табой шматлікія народы, Хетаў і Гіргашэяў, Амарэйцаў, Хананейцаў, Пэрэзэяў, Хівеяў і Евусэяў, сем народаў, большых і дужэйшых за цябе. ");
INSERT INTO bel_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ГОСПАД, Бог твой, аддасьць іх табе, і ты выгубіш іх, і пакладзеш на іх закляцьце, і не заключыш з імі запавет, і ня зьлітуешся над імі. ");
INSERT INTO bel_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ня будзеш з імі мець сужонстваў; сынам іхнім не аддасі за жонку дачкі сваёй і ня возьмеш ад іх дачкі для сына свайго, ");
INSERT INTO bel_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","бо яны адцягнуць сыноў тваіх ад Мяне, каб служыць багам чужым. І ўзгарыцца гнеў ГОСПАДА на вас, і Ён хутка вас зьнішчыць. ");
INSERT INTO bel_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Але так маеце зрабіць з імі: ахвярнікі іхнія разбурыце, слупы іхнія скрышыце, астартаў іхніх пасячыце, а статуі спаліце агнём. ");
INSERT INTO bel_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Бо ты — народ, пасьвячоны ГОСПАДУ, Богу твайму. Цябе выбраў ГОСПАД, Бог твой, каб быў ты выбраным народам Ягоным з усіх народаў, якія жывуць на абліччы зямлі. ");
INSERT INTO bel_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","ГОСПАД выбраў вас і ўпадабаў вас не таму, што вы перавышаеце лікам усе народы, бо з усіх народаў вы найменшыя, ");
INSERT INTO bel_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","але таму, што ГОСПАД любіць вас і захаваў прысягу, якою прысягнуў бацькам вашым, і Ён вывеў вас рукою моцнаю, і вызваліў вас з дому няволі, з рукі фараона, валадара Эгіпецкага. ");
INSERT INTO bel_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","І ведай, што ГОСПАД, Бог твой, ёсьць Бог, Бог верны, Які захоўвае запавет і міласэр­насьць тым, якія любяць Яго, і тым, якія захоўваюць прыказаньні Ягоныя, на тысячы пакаленьняў, ");
INSERT INTO bel_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","і аднагароджвае тым, якія ненавідзяць Яго, так, каб зьні­шчыць іх, і безадкладна адплочвае тым, якія ненавідзяць Яго. ");
INSERT INTO bel_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Дык захоўвай прыказаньні, пастановы і прысуды, якія я сёньня загадваю табе, каб ты выконваў. ");
INSERT INTO bel_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Калі вы будзеце слухаць прысуды гэтыя, і захоўваць іх, і выконваць іх, ГОСПАД, Бог твой, захавае для цябе запавет і міласэрнасьць, якія запрысяг бацькам тваім, ");
INSERT INTO bel_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","і будзе любіць цябе, і дабраславіць цябе, і памножыць, і дабраславіць плод жывата твайго, і плод зямлі тваёй, і збожжа тваё, збор вінаграду твайго і алею твайго, і нараджэньне быдла твайго, прыплод авечак тваіх у зямлі, якую запрысяг бацькам тваім, што дасьць табе. ");
INSERT INTO bel_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Дабраслаўлёны ты будзеш больш за ўсе народы. Ня будзе ў цябе бясплоднага і бясплоднай, як у людзей, так і ў жывёлы тваёй. ");
INSERT INTO bel_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Ухіліць ад цябе ГОСПАД усякую немач, і страшныя хваробы Эгіпецкія, якія ты ведаў, не спашле на цябе, але дасьць іх тым, якія ненавідзяць цябе. ");
INSERT INTO bel_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ты выгубіш усе народы, якія дае табе ГОСПАД, Бог твой. Няхай не пашкадуе іх вока тваё, і ня будзеш служыць багам іхнім, каб ня сталіся яны табе пасткаю. ");
INSERT INTO bel_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Калі скажаш у сэрцы тваім: “Народы гэтыя большыя лікам за мяне, не змагу іх выгубіць”, ");
INSERT INTO bel_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ня бойся іх, але памятай, што зрабіў ГОСПАД, Бог твой, фараону і ўсім Эгіпцянам; ");
INSERT INTO bel_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","вялікія кары, якія бачылі вочы твае, і знакі, і цуды, і руку моцную, і рамяно ўзьнятае, якімі вывеў цябе ГОСПАД, Бог твой. Так зробіць ГОСПАД, Бог твой, усім народам, якіх ты баішся. ");
INSERT INTO bel_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","І спашле на іх ГОСПАД, Бог твой, шэршанёў, пакуль не загінуць тыя, што засталіся, якія схаваліся перад абліччам тваім. ");
INSERT INTO bel_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ня бойся іх, бо ГОСПАД, Бог твой, пасярод цябе, Бог вялікі і страшны. ");
INSERT INTO bel_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ГОСПАД, Бог твой, бу­дзе прыбіраць народы гэтыя перад табою памалу. Ня зьнішчыць іх хутка, каб не памножыліся супраць цябе зьвяры палявыя. ");
INSERT INTO bel_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","І аддасьць іх табе ГОСПАД, Бог твой, і будзе іх трывожыць вялікай трывогай, аж пакуль ня будуць вынішчаныя. ");
INSERT INTO bel_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","У рукі твае аддасьць Ён валадароў іхніх, і ты сатрэш імёны іхнія з-пад неба; ніхто з іх не ўстаіць перад абліччам тваім, пакуль ня выгубіш іх. ");
INSERT INTO bel_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Выявы багоў іхніх спаліш агнём. Не пажадай срэбра і золата, якое на іх, і не бяры сабе, каб яно не зьвяло цябе, бо гэта брыдота для ГОСПАДА, Бога твайго. ");
INSERT INTO bel_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ніякай брыдоты не ўнясеш у дом твой, і ня будзеш ты закляцьцем, як яно. Пагарджаючы, будзеш пагарджаць і, брдзячыся, будзеш брыдзіцца гэтым, бо яно заклятае. ");
INSERT INTO bel_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Усе прыказаньні, якія я загадваю табе сёньня, захоўвайце і выконвайце, каб вы жылі, і памножыліся, і ўвайшлі, і авалодалі зямлёю, якую запрысяг ГОСПАД бацькам вашым. ");
INSERT INTO bel_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","І памятай увесь шлях, якім вёў цябе ГОСПАД, Бог твой, сорак гадоў праз пустыню, каб зьмяніць цябе і выспрабаваць цябе, і даведацца, што ў сэрцы тваім, ці будзеш ты захоўваць прыказаньні Ягоныя, ці не. ");
INSERT INTO bel_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ён выпрабоўваў цябе голадам і карміў цябе маннай, якой ня ведаў ты і ня ведалі бацькі твае, каб даць зразумець табе, што ня толькі хлебам жыве чалавек, але кожным словам, якое выходзіць з вуснаў ГОСПАДА, будзе жыць чалавек. ");
INSERT INTO bel_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Аадзеньне тваё ня нішчылася на табе, і нага твая ня пухла ўсе гэтыя сорак гадоў. ");
INSERT INTO bel_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Дык зразумей у сэрцы тваім, што як бацька выхоўвае сына свайго, так ГОСПАД, Бог твой, выхоўваў цябе, ");
INSERT INTO bel_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","і захоўвай прыказаньні ГОСПАДА, Бога твайго, каб ха­дзіць шляхам Ягоным і мець страх перад Ім. ");
INSERT INTO bel_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Бо ГОСПАД, Бог твой, завядзе цябе ў зямлю добрую, зямлю ручаёў і водаў, рэкаў і крыніцаў, што выбіваюцца ў далінах і на гарах, ");
INSERT INTO bel_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","у зямлю пшаніцы і ячменю, вінаграду і дрэваў фігавых і гранатовых, у зямлю алівак, алею і мёду, ");
INSERT INTO bel_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","у зямлю, дзе без ніякай нястачы будзеш есьці хлеб і нічога ня будзе бракаваць табе ў ёй; у зямлю, у якой камяні — жалеза, а з гор ейных будзеш здабываць медзь. ");
INSERT INTO bel_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","І будзеш ты есьці, і насыцішся, і будзеш дабраслаўляць ГОСПАДА, Бога твайго, за зямлю добрую, якую Ён даў табе. ");
INSERT INTO bel_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Сьцеражыся, каб не забыўся ты пра ГОСПАДА, Бога твайго, і каб не занядбаў прыказаньні Ягоныя, прысуды Ягоныя і пастановы Ягоныя, якія я загадваю табе сёньня. ");
INSERT INTO bel_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Калі наясіся і насыцішся, пабудуеш сабе прыгожыя дамы і ў іх будзеш жыць, ");
INSERT INTO bel_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","і памножыцца быдла тваё і авечкі твае, і памножыцца ў цябе срэбра і золата, і па­множыцца ўсё, што ты маеш, ");
INSERT INTO bel_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","тады ўзганарыцца сэрца тваё і ты забудзешся пра ГОСПАДА, Бога твайго, Які вывеў цябе з зямлі Эгіпецкай, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Ён правёў цябе праз пустыню вялікую і страшную, у якой былі атрутныя зьмеі і скарпіёны, зямля сухая і бязводз­ьдзе. Ён вывеў табе ваду са скалы цьвёрдай, ");
INSERT INTO bel_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ён карміў цябе ў пустыні маннай, якой ня ведалі бацькі твае, каб цябе загартаваць і выспрабаваць цябе, каб даць табе добрае ў будучыні тваёй. ");
INSERT INTO bel_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","І не кажы ў сэрцы тваім: “Сіла мая і моц рукі маёй учынілі ўсё гэтае багацьце для мяне”, ");
INSERT INTO bel_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","але памятай ГОСПАДА, Бога твайго, што Ён даў табе сілы, каб ты здабыў багацьце, што Ён споўніў запавет Свой, які запрысяг бацькам тваім, як гэта ёсьць сёньня. ");
INSERT INTO bel_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","А калі забываючыся, ты забудзешся пра ГОСПАДА, Бога твайго, і пойдзеш за багамі чужымі, і будзеш ім служыць і будзеш пакланяцца ім, я папярэджваю вас сёньня, што гінучы, загінеце. ");
INSERT INTO bel_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Як тыя народы, якія ГОСПАД зьнішчыў перад абліччам вашым, так і вы загінеце, калі ня будзеце слухаць голас ГОСПАДА, Бога вашага. ");
INSERT INTO bel_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Слухай, Ізраіль, ты сёньня маеш перайсьці праз Ярдан, каб увайсьці і завалодаць народамі большымі і мацнейшымі за цябе, гарадамі вялікімі і ўмацаванымі аж пад неба, ");
INSERT INTO bel_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","народам вялікім і высокім, сынамі Анака, якіх ты ведаеш і пра якіх ты чуў: \"Хто можа супрацівіцца сынам Анака?\" ");
INSERT INTO bel_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Дык ведай, што сёньня ГОСПАД, Бог твой, пяройдзе перад абліччам тваім, як агонь палючы. Ён зьнішчыць іх і паваліць іх перад абліччам тваім, і ты хутка выганіш іх і зьнішчыш іх, як ГОСПАД прамовіў да цябе. ");
INSERT INTO bel_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Не кажы ў сэрцы тваім, калі ГОСПАД, Бог твой, выганіць іх перад абліччам тваім, кажучы: “Дзеля праведнасьці маёй увёў мяне ГОСПАД, каб завалодаў я зямлёю гэтаю”, бо дзеля злачынства народаў гэтых выганяе іх ГОСПАД перад абліччам тваім. ");
INSERT INTO bel_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ня дзеля праведнасьці тваёй і ня дзеля шчырасьці сэрца твайго ўваходзіш ты, каб завалодаць зямлёю іхняй, але за бязбожнасьць народаў гэтых ГОСПАД, Бог твой, выганяе іх перад абліччам тваім, каб споўніць слова, якое Ён абяцаў бацькам тваім, Абрагаму, Ісааку і Якубу. ");
INSERT INTO bel_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Дык ведай, што не дзеля праведнасьці тваёй ГОСПАД, Бог твой, даў табе гэтую добрую зямлю на ўласнасьць, бо ты — народ з цьвёрдым каркам. ");
INSERT INTO bel_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Памятай і не забывайся, як гнявіў ты ГОСПАДА, Бога твайго, у пустыні. З таго дня, як выйшаў ты з Эгіпту і аж пакуль прыйшлі ў гэтае месца, вы працівіліся ГОСПАДУ. ");
INSERT INTO bel_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","І на Харэве вы гнявілі ГОСПАДА, і разгневаўся ГОСПАД на вас, і хацеў зьнішчыць вас. ");
INSERT INTO bel_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Калі я ўзыйшоў на гару, каб атрымаць табліцы каменныя, табліцы запавету, які заключыў ГОСПАД з вамі, я быў на гары сорак дзён і сорак начэй, ня еў хлеба і ня піў вады. ");
INSERT INTO bel_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","І даў мне ГОСПАД дзьве табліцы каменныя, запісаныя пальцам Бога, на якіх былі ўсе словы, якія да вас прамовіў ГОСПАД на гары з сярэдзіны агню ў дзень супольнага сходу. ");
INSERT INTO bel_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Калі мінула сорак дзён і сорак начэй, даў мне ГОСПАД дзьве табліцы каменныя, табліцы запавету, ");
INSERT INTO bel_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","і сказаў мне ГОСПАД: “Устань і зыйдзі адсюль з гары, бо саграшыў народ твой, які вывеў ты з Эгіпту; хутка зыйшлі з дарогі, якую Я загадаў ім, і зрабілі сабе ідала”. ");
INSERT INTO bel_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","І сказаў ГОСПАД мне, кажучы: “Бачу гэты народ, і вось, гэта народ з цьвёрдым каркам. ");
INSERT INTO bel_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Пакінь Мяне! І Я зьнішчу іх, і сатру імя іхняе з-пад неба, а з цябе Я зраблю народ дужэйшы і большы за гэты”. ");
INSERT INTO bel_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","І я павярнуўся, і зыйшоў з гары, а гара палала агнём, і дьзве табліцы каменныя ў абедзьвух руках маіх. ");
INSERT INTO bel_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","І я ўбачыў, і вось, вы саграшылі супраць ГОСПАДА, Бога вашага, і зрабілі сабе літае цяля, і хутка зыйшлі са шляху, які ГОСПАД загадаў вам. ");
INSERT INTO bel_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","І схапіў я абедзьве табліцы, і кінуў іх з рук маіх, і разьбіў іх на вачах вашых. ");
INSERT INTO bel_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","І я ляжаў перад абліччам ГОСПАДА як раней, сорак дзён і сорак начэй, ня еў хлеба і ня піў вады дзеля ўсіх грахоў вашых, якіх вы дапусьціліся, чынячы зло ў вачах ГОСПАДА, і змусілі Яго да гневу, ");
INSERT INTO bel_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","бо я баяўся ярасьці і гневу, якім разгневаўся ГОСПАД, каб зьнішчыць вас. І выслухаў мяне ГОСПАД у гэты раз. ");
INSERT INTO bel_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","І на Аарона быў ГОСПАД надта разгневаны, і хацеў забіць яго, і я маліўся за Аарона ў той час. ");
INSERT INTO bel_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","А грэх ваш, які вы ўчынілі, цяля літае, я, схапіўшы, спаліў агнём, і разьбіў, і сьцёр на дробны пыл, і кінуў у ручай, які сьцякаў з гары. ");
INSERT INTO bel_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","І ў Табэры, і ў Масе, і ў Кіброт-Гаттаве вы спакушалі ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","І калі пасылаў вас ГОСПАД з Кадэш-Барнэа, кажучы: “Ідзіце і авалодайце зямлёй, якую Я даў вам”, вы супрацівіліся слову з вуснаў ГОСПАДА, Бога вашага, і не паверылі Яму, і не паслухалі голасу Ягонага. ");
INSERT INTO bel_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Вы заўсёды працівіліся ГОСПАДУ, ад дня, як я стаў ве­даць вас. ");
INSERT INTO bel_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Сорак дзён і сорак начэй я ляжаў перад абліччам ГОСПАДА і маліў Яго, бо ГОСПАД сказаў, што зьнішчыць вас. ");
INSERT INTO bel_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","І я маліўся ГОСПАДУ, і казаў: “Госпадзе ГОСПАДЗЕ, не губі народ Твой і спадчыну Тваю, якую адкупіў Ты веліччу Тваёй, якую Ты вывеў з Эгіпту рукою моцнаю. ");
INSERT INTO bel_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Памятай слугаў Тваіх, Абрагама, Ісаака і Якуба; і не глядзі на закамянеласьць народу гэтага і на бязбожнасьць ягоную, і на грахі ягоныя, ");
INSERT INTO bel_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","каб не казалі ў зямлі, з якой Ты вывеў нас: \"Ня мог ГОСПАД увесьці іх у зямлю, якую абяцаў ім. З нянавісьці да іх вывеў Ён іх, каб памерлі ў пустыні\". ");
INSERT INTO bel_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","А яны — народ Твой і спадчына Твая, тыя, якіх Ты вывеў сілаю Тваёй вялікаю і рамяном Тваім узьнятым”. ");
INSERT INTO bel_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","У гэты час сказаў мне ГОСПАД: “Вычашы сабе дзьве табліцы каменныя, падобныя да першых, і ўзыйдзі да Мяне на гару, і зрабі таксама каўчэг з дрэва. ");
INSERT INTO bel_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Я напішу на табліцах словы, якія былі на першых табліцах, якія ты разьбіў, і ты ўложыш іх у каўчэг”. ");
INSERT INTO bel_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","І я зрабіў каўчэг з дрэва акацыі, і вычасаў дзьве табліцы каменныя, падобныя да першых, і ўзыйшоў на гару, маючы ў руках дзьве табліцы. ");
INSERT INTO bel_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","І напісаў Госпад на табліцах падобна, як раней напісаў, Дзесяць Словаў, якія прамовіў ГОСПАД на гары з сярэдзіны агню ў дзень супольнага сходу. І даў мне іх ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","І я разьвярнуўся, і зыйшоў з гары, і палажыў табліцы ў каўчэг, які зрабіў; і яны засталіся там, як мне загадаў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","А сыны Ізраіля выйшлі з Бээроту сыноў Яакана ў Масэру. Там памёр Аарон і быў пахаваны, а Элеазар, сын ягоны, стаў сьвятаром замест яго. ");
INSERT INTO bel_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Адтуль мы прыйшлі ў Гудгоду, а з Гудгоды — у Ётбату, у зямлю ручаёў водных. ");
INSERT INTO bel_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","У гэты час ГОСПАД аддзяліў калена Левія, каб яны насілі Каўчэг Запавету ГОСПАДА і каб стаялі перад абліччам ГОСПАДА і служылі Яму, і дабраслаўлялі ў імя Ягонае па сёньняшні дзень. ");
INSERT INTO bel_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Дзеля таго Левій ня мае часткі зямлі, ані спадчыны паміж братоў сваіх, бо спадчына ягоная — ГОСПАД, як прамовіў да яго ГОСПАД, Бог твой. ");
INSERT INTO bel_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","І я стаяў на гары, як у ранейшыя дні, сорак дзён і сорак начэй, і таксама ў гэты раз выслухаў мяне ГОСПАД, і не захацеў ГОСПАД выгубіць цябе. ");
INSERT INTO bel_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","І сказаў ГОСПАД мне: “Устань, ідзі і ачольвай народ, каб яны пайшлі і завалодалі зямлёй, якую Я запрысяг бацькам іхнім, каб даць ім”. ");
INSERT INTO bel_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","І цяпер, Ізраіль, чаго жадае ад цябе ГОСПАД, Бог твой? Каб ты баяўся ГОСПАДА, Бога твайго, і хадзіў усімі шляхамі Ягонымі, любіў Яго і служыў ГОСПАДУ, Богу твайму, усім сэрцам тваім і ўсёй душою тваёй, ");
INSERT INTO bel_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","каб выконваў ты прыказаньні ГОСПАДА і пастановы Ягоныя, якія я сёньня загадваю табе, каб добра было табе. ");
INSERT INTO bel_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Вось, ГОСПАДУ, Богу твайму, належыць неба і нябёсы нябёсаў, зямля і ўсё, што на ёй. ");
INSERT INTO bel_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Толькі да бацькоў тваіх прыхінуўся ГОСПАД і палюбіў іх, і выбраў насеньне іхняе пасьля іх, выбраў вас з усіх народаў, як гэта ёсьць сёньня. ");
INSERT INTO bel_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Дык абрэжце скуравінку сэрца вашага і не рабіце больш цьвёрдым карку вашага, ");
INSERT INTO bel_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","бо ГОСПАД, Бог ваш, — Бог багоў і Госпад гаспадароў, Бог вялікі, магутны і страшны, Які не глядзіць на аблічча, і не бярэ падарункі. ");
INSERT INTO bel_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ён дае суд сіраце і ўдаве, і любіць прыхадня, даючы яму хлеб і адзеньне. ");
INSERT INTO bel_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","І вы любіце прыхадня, бо і вы былі прыхаднямі ў зямлі Эгіпецкай. ");
INSERT INTO bel_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ГОСПАДА, Бога твайго, бойся, Яму служы, да Яго туліся і на імя Ягонае прысягай. ");
INSERT INTO bel_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ён — хвала твая і Бог твой, Ён учыніў дзеля цябе вялікія і жудасныя рэчы, якія бачылі вочы твае. ");
INSERT INTO bel_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Маючы семдзясят душаў, зыйшлі бацькі твае ў Эгіпет, а цяпер памножыў цябе ГОСПАД, Бог твой, як зоркі ў небе. ");
INSERT INTO bel_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Любі ГОСПАДА, Бога твайго, і захоўвай загады Ягоныя, і пастановы Ягоныя, і прысуды Ягоныя, і прыказаньні Ягоныя ўсе дні. ");
INSERT INTO bel_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","І вы ведаеце сёньня тое, чаго ня ведаюць сыны вашыя, якія ня бачылі караньня ГОСПАДА, Бога вашага, велічы Ягонай, і моцнай рукі Ягонай, і ўзьнятага рамяна Ягонага, ");
INSERT INTO bel_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","знакаў Ягоных і справаў Ягоных, якія Ён учыніў у Эгіпце над фараонам, валадаром Эгіпту, і над усёй зямлёй ягонай, ");
INSERT INTO bel_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","і што зрабіў Ён з усім войскам Эгіпецкім, конямі ягонымі і калясьніцамі ягонымі; калі нахлынулі на іх воды Мора Чырвонага перад абліччам іхнім, калі яны гналіся за вамі, і зьнішчыў іх ГОСПАД, і так ёсьць да сёньняшняга дня, ");
INSERT INTO bel_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","і што Ён зрабіў для вас у пустыні, пакуль вы не прыйшлі на месца гэтае, ");
INSERT INTO bel_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","і што Ён зрабіў Датану і Абіраму, сынам Эліява, сына Рубэна, якіх праглынула зямля, адкрыўшы пашчу сваю, дамы іхнія і намёты іхнія, і ўсе жывыя істоты, якія мелі спасярод усяго Ізраіля ішлі за імі. ");
INSERT INTO bel_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Вочы вашыя бачылі ўсе вялікія справы ГОСПАДА, якія Ён учыніў, ");
INSERT INTO bel_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","каб вы захоўвалі ўсе прыказаньні, якія сёньня я загадваю вам, каб вы ўмацаваліся і ўвайшлі, і ўзялі на ўласнасьць зямлю, у якую ўваходзіце, каб авалодаць ёю, ");
INSERT INTO bel_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","і каб доўгія былі дні вашыя ў той зямлі, якую з прысягай абяцаў ГОСПАД бацькам вашым даць ім і насеньню іхняму, зямлю, якая ацякае малаком і мёдам. ");
INSERT INTO bel_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Бо зямля, у якую ты ўваходзіш, каб авалодаць ёю, ня ёсьць такою, як зямля Эгіпецкая, з якой ты выйшаў, якую, укінуўшы зерне сваё, ты паліваў працаю ног тваіх, як у агародзе. ");
INSERT INTO bel_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Зямля тая, у якую ты ўваходзіш, каб авалодаць ёю, — зямля гор і лагчынаў, якая п'е ваду з неба. ");
INSERT INTO bel_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Гэта зямля, якою ГОСПАД, Бог твой, апякуецца, і вочы ГОСПАДА, Бога твайго, заўсёды зьвернуты на яе ад пачатку году аж да канца году. ");
INSERT INTO bel_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“Дык калі ты будзеш слухаць прыказаньні Мае, якія сёньня Я загадваю вам, каб вы любілі ГОСПАДА, Бога вашага, і служылі Яму ўсім сэрцам вашым і ўсёю душой вашай, ");
INSERT INTO bel_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","Я дам зямлі вашай у свой час дождж раньні і дождж позьні, і ты зьбярэш збожжа тваё, і віно тваё, і алей твой. ");
INSERT INTO bel_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","І дам Я траву на палях тваіх для быдла твайго, і ты будзеш есьці і насыцішся”. ");
INSERT INTO bel_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Сьцеражыцеся, каб не ашукалася сэрца вашае, каб не адыйшлі вы ад Госпада, і не служылі чужым багам, і не пакланяліся ім, ");
INSERT INTO bel_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","бо запалае ГОСПАД гневам на вас, і зачыніць неба, і ня будзе дажджу, і зямля ня дасьць плёну свайго, і загінеце вы хутка на добрай зямлі, якую ГОСПАД дае вам. ");
INSERT INTO bel_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","І прыйміце гэтыя словы Мае ў сэрца вашае і ў душу вашую, і прывяжыце іх на знак на руку вашую, і няхай будуць яны павязкаю над вачыма вашымі. ");
INSERT INTO bel_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","І навучыце ім сыноў вашых, прамаўляючы іх ім, калі ты сядзіш у доме тваім, калі ты ідзеш дарогаю, калі ты кладзешся і калі ўстаеш. ");
INSERT INTO bel_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","І напішы іх на дзьвярах дому твайго і на брамах тваіх, ");
INSERT INTO bel_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","каб памножыліся дні твае і дні сыноў тваіх на зямлі, якую прысягнуў ГОСПАД бацькам тваім даць ім, як дні неба над зямлёй. ");
INSERT INTO bel_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Калі будзеце захоўваць усе прыказаньні гэтыя, якія я загадваю вам, і будзеце выконваць іх, і будзеце любіць ГОСПАДА, Бога вашага, і бу­дзеце хадзіць усімі шляхамі Ягонымі, і будзеце туліцца да Яго, ");
INSERT INTO bel_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ГОСПАД прагоніць перад вамі ўсе народы гэтыя, і вы авалодаеце народамі, якія большыя і дужэйшыя за вас. ");
INSERT INTO bel_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Кожнае месца, на якое стане нага вашая, будзе вашым. Ад пустыні і да Лібана, ад вялікай ракі Эўфрат аж да Мора Заходняга будуць межы вашыя. ");
INSERT INTO bel_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ніхто не ўстаіць перад вамі, бо ГОСПАД, Бог ваш, навядзе страх і трывогу перад вамі на аблічча ўсёй зямлі, на якую вы ступіце, як Ён прамовіў да вас. ");
INSERT INTO bel_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Глядзі, Я даю вам сёньня дабраславенства і праклён; ");
INSERT INTO bel_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","дабраславенства, калі будзеце слухаць прыказаньні ГОСПАДА, Бога вашага, якія я загадваю вам сёньня, ");
INSERT INTO bel_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","і праклён, калі ня будзеце слухаць прыказаньняў ГОСПАДА, Бога вашага, і зыйдзеце са шляху, які я загадваю вам сёньня, і пойдзеце за багамі чужымі, якіх ня ведаеце. ");
INSERT INTO bel_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","І станецца, калі ўвядзе цябе ГОСПАД, Бог твой, у зямлю, якую ты ідзеш атрымаць на ўласнасьць, ты абвясьці дабраславенства на гары Гарызім, а праклён — на гары Эваль. ");
INSERT INTO bel_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Горы гэтыя за Ярданам, на шляху на захад сонца, у зямлі Хананейцаў, якія жывуць у Арабе насупраць Гільгалу, каля дубоў Марэ. ");
INSERT INTO bel_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Бо вы пяройдзеце праз Ярдан, каб прыйсьці і завало­даць зямлёю, якую ГОСПАД, Бог ваш, дае вам, і возьмеце яе на ўласнасьць, і будзеце жыць на ёй. ");
INSERT INTO bel_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Дык захоўвайце і выконвайце ўсе пастановы і прысуды, якія я даю вам сёньня. ");
INSERT INTO bel_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Гэта пастановы і прысуды, якія вы будзеце захоўваць і выконваць у зямлі, якую ГОСПАД, Бог бацькоў вашых, даў вам, каб валодалі ёю ў-ва ўсе дні жыцьця вашага на зямлі. ");
INSERT INTO bel_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Зьнішчэньнем зьнішчыце ўсе месцы, дзе народы, якімі вы авалодаеце, служылі багам сваім на гарах высокіх, на ўзгорках і пад кожным дрэвам зялёным. ");
INSERT INTO bel_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Зруйнуйце ахвярнікі іхнія, скрышыце слупы іхнія, агнём спаліце астартаў іхніх, і паразь­бівайце выявы багоў іхніх, і сатрыце імёны іхнія з месца гэтага. ");
INSERT INTO bel_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Не рабіце так ГОСПАДУ, Богу вашаму, ");
INSERT INTO bel_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","але месца, якое выбраў ГОСПАД, Бог ваш, з усіх каленаў вашых, каб там памясьціць імя Сваё і ў ім жыць, будзеце шукаць, і туды прыходзіць, ");
INSERT INTO bel_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","і туды будзеце прыносіць цэласпаленьні вашыя, ахвяры крывавыя вашыя, дзесяціны вашыя і дары рук вашых, і шлюбаваньні вашыя, і дабра­ахвотныя ахвяры вашыя, і першародных валоў вашых і авечак вашых. ");
INSERT INTO bel_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Там, перад абліччам ГОСПАДА, Бога вашага, будзеце есьці вы і дамы вашыя і будзеце радавацца з усяго, што зрабілі рукі вашыя, у чым дабраславіў вас ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Ня будзеце там рабіць таго, што мы тут робім сёньня, калі кожны робіць усё, што слушнае ў вачах ягоных, ");
INSERT INTO bel_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","бо вы яшчэ не прыйшлі ў месца супачынку і да ўласнасьці, якую дае вам ГОСПАД, Бог ваш. ");
INSERT INTO bel_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","І вы пяройдзеце Ярдан, і абжывіцёся ў зямлі, якую дае вам ГОСПАД, Бог ваш, каб жылі ў супакоі ад усіх ворагаў навокал і жылі ў бясьпецы. ");
INSERT INTO bel_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","І будзе месца, якое выбраў ГОСПАД, Бог ваш, каб у ім жыло імя Ягонае. Туды прыносьце ўсё, што я загадваю вам: цэласпаленьні вашыя, ахвяры крывавыя вашыя, дзесяціны вашыя, дары рук вашых і ўсе шлюбаваньні вашыя, якія вы абяцалі для ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","І будзеце радавацца перад абліччам ГОСПАДА, Бога вашага, вы, і сыны вашыя, і дочкі вашыя, слугі вашыя і служкі вашыя, і лявіт, які ў брамах вашых, бо ня мае ён ані часткі, ані спадчыны паміж вамі. ");
INSERT INTO bel_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Сьцеражыцеся, каб не складаць цэласпаленьняў тваіх на кожным месцы, якое ўбачыш. ");
INSERT INTO bel_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Але на тое месца, якое выбраў ГОСПАД у адным з каленаў тваіх, занясеш усе ахвяры твае і зробіш усё, што я загадваю табе. ");
INSERT INTO bel_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Але колькі зажадае душа твая будзеш забіваць жывёлу і есьці мяса паводле дабраславенства ГОСПАДА, Бога твайго, якое Ён дасьць табе ў-ва ўсіх брамах тваіх; чысты і нячысты можа есьці яго, як сарну і аленя. ");
INSERT INTO bel_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Толькі крыві ня будзеш есьці; выльеш яе на зямлю, як ваду. ");
INSERT INTO bel_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Ня будзеш есьці ў брамах тваіх дзесяціны збожжа твайго, віна твайго і алею твайго, першародных валоў тваіх і авечак тваіх, усяго шлюбаваньня твайго, якое ты абяцаў ГОСПАДУ, Богу твайму, ахвяраў дабраахвотных і дароў з рукі тваёй. ");
INSERT INTO bel_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Але толькі перад абліччам ГОСПАДА, Бога твайго, у месцы, якое выбраў ГОСПАД, Бог твой, будзеш есьці іх ты і сын твой, і дачка твая, і слуга твой, і служка твая, і лявіт, які ў брамах тваіх; і будзеш радавацца перад абліччам ГОСПАДА, Бога твайго, з усяго, што здабыла рука твая. ");
INSERT INTO bel_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Сьцеражыся, каб не пакінуў ты лявіта ў-ва ўсе дні твае на зямлі тваёй. ");
INSERT INTO bel_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Калі пашырыць ГОСПАД, Бог твой, межы твае, як Ён сказаў табе, і ты скажаш: \"Хачу есьці мяса\", калі зажадае душа твая есьці мяса, паводле прагненьня душы тваёй еш мяса. ");
INSERT INTO bel_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Калі месца, якое выбраў ГОСПАД, Бог твой, каб там зьмя­сьціць імя Сваё, будзе далёка ад цябе, тады забі вала твайго і авечку тваю, якіх даў табе ГОСПАД, як я загадаў табе, і еш у брамах тваіх паводле прагненьня душы тваёй. ");
INSERT INTO bel_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Як ясьцё сарну і аленя, так іх еш; чысты, і нячысты нароўні могуць гэта есьці. ");
INSERT INTO bel_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Толькі будзь моцны, каб ня еў ты крыві; бо кроў ёсьць душа, і ты ня будзеш есьці душу разам з мясам. ");
INSERT INTO bel_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ня будзеш есьці яе, але вылі яе на зямлю, як ваду. ");
INSERT INTO bel_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ня будзеш есьці яе, каб было добра табе і сынам тваім пасьля цябе, калі будзеш рабіць тое, што слушна ў вачах ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Але тое, што пасьвяціў ты і шлюбаваў ГОСПАДУ, вазьмі і занясі на тое месца, якое выбраў ГОСПАД. ");
INSERT INTO bel_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","І ахвяруеш цэласпаленьні твае, мяса і кроў, на ахвярніку ГОСПАДА, Бога твайго; і кроў ахвяраў тваіх выльеш на ахвярніку ГОСПАДА, Бога твайго, а мяса зьясі. ");
INSERT INTO bel_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Захоўвай і слухай усе словы гэтыя, якія я загадваю табе, каб было добра табе і сынам тваім пасьля цябе на вякі, калі будзеш рабіць тое, што добрае і што слушнае ў вачах ГОСПАДА, Бога твайго. ");
INSERT INTO bel_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Калі ГОСПАД, Бог твой, выганіць перад табою народы, да якіх ты ідзеш, каб завалодаць імі, і ты завалодаеш імі, і абжывешся на зямлі іхняй, ");
INSERT INTO bel_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","сьцеражыся, каб не патрапіць у пастку з імі, калі яны будуць выгубленыя перад табою, і не шукаць багоў іхніх, кажучы: “Як служылі народы гэтыя багам сваім, так і я буду служыць ім”. ");
INSERT INTO bel_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Не рабі гэтак ГОСПАДУ, Богу твайму, бо ўсё, чым брыдзіцца ГОСПАД і што ненавідзіць, яны багам сваім рабілі, нават сыноў сваіх і дачок сваіх у агні палілі для багоў сваіх. ");
INSERT INTO bel_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Усе словы, якія я загадваю вам, захоўвайце і выконвайце. Не дадавайце да іх і не адымайце ад іх. ");
INSERT INTO bel_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Калі паўстане сярод цябе прарок або той, які сьніць сны, і пакажа табе знак або цуд. ");
INSERT INTO bel_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","і споўніцца той знак або цуд, які ён прадказаў, і скажа той прарок: “Пойдзем за іншымі багамі, якіх ты ня ведаеш, і будзем ім служыць”, ");
INSERT INTO bel_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ня слухай словаў такога прарока або таго, які сьніць сны, бо выспрабоўвае вас ГОСПАД, Бог ваш, каб даведацца, ці ты любіш ГОСПАДА, Бога твайго, усім сэрцам тваім і ўсёй душой тваёй. ");
INSERT INTO bel_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","За ГОСПАДАМ, Богам вашым, ідзіце і Яго бойцеся, і прыказаньні Ягоныя выконвайце, і слухайцеся голасу Ягонага, Яму служыце і да Яго туліцеся. ");
INSERT INTO bel_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","А прарок той або той, які сьніць сны, няхай будзе забіты, бо гаварыў, каб адвярнуць вас ад ГОСПАДА, Бога вашага, Які вывеў вас з зямлі Эгіпецкай і вызваліў цябе з дому няволі, каб зьвесьці цябе з таго шляху, які табе загадаў ГОСПАД, Бог твой, каб ісьці па ім. І выкараніш зло з асяродзьдзя твайго. ");
INSERT INTO bel_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Калі будзе намаўляць цябе брат твой, сын маці тваёй, або сын твой, або дачка твая, або жонка ўлоньня твайго, або сябра твой, якога любіш, як душу сваю, таемна кажучы: “Хадзем і будзем служыць багам чужым”, якіх ані ты ня ведаеш, ані бацькі твае, ");
INSERT INTO bel_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","багам тых народаў, якія вакол цябе, блізкіх да цябе ці далёкіх ад цябе ад аднаго канца зямлі да другога канца зямлі, ");
INSERT INTO bel_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ня слухай яго і не згаджайся з ім, і няхай ня літуецца вока тваё над ім, ня мей шкадаваньня, і не хавай злачынства ягонага, ");
INSERT INTO bel_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","але, забіваючы, забі яго. Рука твая няхай будзе першай, каб забіць яго, а рука ўсяго народу — пасьля цябе. ");
INSERT INTO bel_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Укамянуй яго камянямі, і ён памрэ, бо ён хацеў адцягнуць цябе ад ГОСПАДА, Бога твайго, Які вывеў цябе з зямлі Эгіпецкай, з дому няволі. ");
INSERT INTO bel_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","І ўвесь Ізраіль пачуе гэта, і будзе баяцца, і кіне рабіць гэткія рэчы, ліхоту ў асяродзь­дзі тваім. ");
INSERT INTO bel_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Калі пачуеш у адным з гарадоў тваіх, якія ГОСПАД, Бог твой, дае табе на пражываньне, як нехта кажа: ");
INSERT INTO bel_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","“Выйшлі з асяродзьдзя твайго людзі, сыны Бэліяла, і яны зводзяць жыхароў гораду свайго, кажучы: \"Хадзем і будзем служыць багам чужым, якіх ня ведаеце\"”, — ");
INSERT INTO bel_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","тады распытай, і дасьледуй, і добра правер. І вось, праўду гаворыць слова гэтае і такую брыдоту робяць у асяродзьдзі тваім. ");
INSERT INTO bel_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","Тады, забіваючы, забі вострывам мяча жыхароў гораду гэтага і аддай закляцьцю яго і ўсё, што ў ім; і жывёлу ягоную заб'еш вострывам мяча. ");
INSERT INTO bel_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","А ўсю здабычу з яго зьбяры на сярэдзіну плошчы і спалі агнём горад і ўсю здабычы дашчэнту для ГОСПАДА, Бога твайго, і будзе ён у руінах на вякі, і не адбудуецца болей. ");
INSERT INTO bel_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","І няхай не прыліпне да рукі тваёй нічога з заклятага, каб ГОСПАД адвярнуў ярасьць гневу Свайго, і зьявіў табе літасьць, і зьлітаваўся над табой, і памножыў цябе, як Ён прысягнуў бацькам тваім, ");
INSERT INTO bel_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","калі будзеш слухаць голас ГОСПАДА, Бога твайго, захоўваючы ўсе прыказаньні Ягоныя, якія я загадваю табе сёньня, і робячы тое, што слушна ў вачах ГОСПАДА, Бога твайго. ");
INSERT INTO bel_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Вы — сыны ГОСПАДА, Бога вашага; ня будзеце рабіць нарэзы на скуры, і ня будзеце выстрыгаць валасоў над вачыма вашымі па памёршых, ");
INSERT INTO bel_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","бо ты — народ сьвяты для ГОСПАДА, Бога твайго, бо цябе выбраў ГОСПАД, каб ты стаўся выбраным народам Ягоным спасярод усіх народаў, якія на абліччы зямлі. ");
INSERT INTO bel_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Ня будзеш есьці нічога паганага. ");
INSERT INTO bel_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Вось зьвяры, якіх вы будзеце есьці: вол, ягня авечак і козаў, ");
INSERT INTO bel_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","алень, сарна, казуля, ланя, зубар, антылёпа, горны казёл. ");
INSERT INTO bel_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","І кожную жывёлу, якая мае разьдзеленыя капыты і на абодвух капытах глыбокі разрэз, і тую жывёлу, якая жуе жвайку, будзеце есьці. ");
INSERT INTO bel_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Але ня будзеце есьці тых, якія жуюць жвайку і ня маюць разьдзеленыя капыты з глыбокім разрэзам: вярблюда, зайца і дамана, бо яны жуюць жвайку, але капыты ў іх не разьдзелены, яны для вас нячыстыя. ");
INSERT INTO bel_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","І сьвіньня, хоць капыты ў яе разьдзеленыя, але яна не жуе жвайку, будзе для вас нячыстай; мяса яе ня ешце і падліны не дакранайцеся. ");
INSERT INTO bel_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","З усяго, што ў вадзе, будзеце есьці ўсіх, якія маюць плаўнікі і луску. ");
INSERT INTO bel_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","А ўсё, што без плаўніка і лускі, ня будзеце есьці, бо яны для вас нячыстыя. ");
INSERT INTO bel_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Усіх птушак чыстых будзеце есьці. ");
INSERT INTO bel_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Спасярод птушак ня будзеце есьці: арла, грыфа і марскога арла, ");
INSERT INTO bel_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","каршука, сокала і каню паводле гатункаў іхніх, ");
INSERT INTO bel_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","і ўсякага крумкача паводле гатунку яго, ");
INSERT INTO bel_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","страуса, савы, чайкі і ястраба паводле гатункаў яго, ");
INSERT INTO bel_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","пугача, ібіса і лебедзя, ");
INSERT INTO bel_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","пэлікана, сыча і рыбалова, ");
INSERT INTO bel_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","чаплі, буслоў паводле гатункаў іхніх, удода і кажана. ");
INSERT INTO bel_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Кожная жужла крылатая для вас нячыстая, ня будзеце яе есьці. ");
INSERT INTO bel_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Усіх птушак чыстых будзеце есьці. ");
INSERT INTO bel_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Ня будзеце есьці ніякай падліны. Дасі яе прыхадню, які ў брамах тваіх, і будзе есьці, або прадасі чужынцу, бо ты — народ сьвяты для ГОСПАДА, Бога твайго. Не вары казьляняці ў малацэ маці ягонай. ");
INSERT INTO bel_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Давай дзесяціну з усіх пладоў насеньня твайго, з таго, што поле штогод родзіць. ");
INSERT INTO bel_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","І еш перад абліччам ГОСПАДА, Бога твайго, на тым месцы, якое Ён выбраў, каб было там імя Ягонае, дзесяціну збожжа твайго, і віна твайго, і алею твайго, і першародных валоў тваіх і авечак тваіх, каб вучыўся ты баяцца ГОСПАДА, Бога твайго, у-ва ўсе дні. ");
INSERT INTO bel_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Калі ж далёкай будзе дарога твая і ня зможаш гэта прынесьці, бо далёка ад цябе месца, якое выбраў ГОСПАД, Бог твой, каб там было імя Ягонае, і калі ГОСПАД, Бог твой, дабраславіў цябе, ");
INSERT INTO bel_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","тады памяняй гэта на срэбра, і вазьмі срэбра ў руку тваю, і ідзі на месца, якое выбраў ГОСПАД, Бог твой, ");
INSERT INTO bel_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","і купляй там за гэта срэбра ўсё, чаго жадае душа твая, ці валоў, ці авечак, ці віно, ці сікеру, ці ўсё, чаго жадае душа твая; і будзеш есьці там перад абліччам ГОСПАДА, Бога твайго, і будзеш весяліцца ты і дом твой. ");
INSERT INTO bel_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","І не пакідай лявіта, які ў брамах тваіх, бо ён ня мае ані часткі, ані спадчыны з табою. ");
INSERT INTO bel_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Пад канец трэцяга году адлажы ўсе дзесяціны з пладоў тваіх году гэтага і пакінь у брамах тваіх. ");
INSERT INTO bel_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","І прыйдзе лявіт, бо ён ня мае ані часткі, ані спадчыны з табой, і прыхадзень, і сірата, і ўдава, якія ў брамах тваіх, і будуць яны есьці, і насыцяцца, каб дабраславіў цябе ГОСПАД, Бог твой, у кожнай працы рук тваіх, якую будзеш рабіць. ");
INSERT INTO bel_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","У канцы сёмага году даруй даўгі. ");
INSERT INTO bel_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Дараваньне даўгоў палягае на тым, што кожны пазыкадавец, які пазычыў бліжняму свайму з рукі сваёй, ня бу­дзе вымагаць звароту пазыкі ад бліжняга або брата свайго, бо абвешчана дараваньне даўгоў на ўшанаваньне ГОСПАДА. ");
INSERT INTO bel_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Ад чужога будзеш вымагаць звароту доўга, але што будзе тваё ў брата твайго, няхай даруе рука твая. ");
INSERT INTO bel_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Не павінна быць у цябе ўбогага, бо ГОСПАД, дабраслаўляючы, дабраславіць цябе ў зямлі, якую ГОСПАД, Бог твой дае табе як спадчыну на ўласнасьць, ");
INSERT INTO bel_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","калі толькі будзеш слу­хаць голас ГОСПАДА, Бога твайго, і захоўваць, і выконваць усе прыказаньні гэтыя, якія сёньня я загадваю табе. ");
INSERT INTO bel_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Бо ГОСПАД, Бог твой, бу­дзе дабраслаўляць цябе, як абяцаў табе. І ты будзеш пазы­чаць шматлікім народам, а сам ня будзеш браць пазыкі; будзеш панаваць над шматлікімі народамі, а над табою ніхто ня бу­дзе панаваць. ");
INSERT INTO bel_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Калі адзін з братоў тваіх, які ў адной з брамаў тваіх у зямлі тваёй, якую дае табе ГОСПАД, Бог твой, будзе ўбогім, не зацьвярдзі сэрца твайго і ня сьцісьні рукі тваёй перад убогім братам тваім, ");
INSERT INTO bel_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","але, адкрываючы, адкрый яму руку тваю і шчодра дай яму пазыку паводле патрэбы ягонай, што будзе патрэбна яму. ");
INSERT INTO bel_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Сьцеражыся, каб не было ў сэрцы тваім слова нягоднага, кажучы: “Блізка сёмы год, год дараваньня даўгоў”, і ліхім вокам ты паглядзіш на ўбогага брата твайго, і не дасі яму дапамогі, і ён будзе клікаць ГОСПАДА супраць цябе, і ты абцяжарышся грэхам. ");
INSERT INTO bel_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Даючы, дай яму, і няхай не сумуе сэрца тваё, што даеш, бо за гэта будзе дабраслаўляць цябе ГОСПАД, Бог твой, у кожнай справе і ў кожнай працы, і ў кожным дзеяньні рук тваіх. ");
INSERT INTO bel_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Бо будуць убогія ў зямлі гэтай. Дзеля гэтага я загадваю табе, кажучы: “Адкрываючы, адкрывай руку тваю брату твайму, які ў патрэбе, і ўбогаму, які ў зямлі тваёй”. ");
INSERT INTO bel_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Калі прадасца табе брат твой, Гебрай або Гебрайка, няхай будзе нявольнікам шэсьць гадоў. У сёмы год выпусьціш яго вольным ад сябе. ");
INSERT INTO bel_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Калі будзеш, вызваляючы, вызваляць яго, не адпусьціш яго з пустымі рукамі. ");
INSERT INTO bel_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Адорваючы, адаруеш яго і дасі яму з авечак тваіх, з току твайго і з тоўчні тваёй, якімі дабраславіў цябе ГОСПАД, Бог твой. ");
INSERT INTO bel_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Памятай, што ты быў нявольнікам у зямлі Эгіпецкай, і вызваліў цябе ГОСПАД, Бог твой. Дзеля гэтага я загадваю табе гэта слова сёньня. ");
INSERT INTO bel_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","А станецца, што ён скажа табе: “Не адыйду ад цябе, бо люблю цябе і дом твой”, бо добра яму ў цябе. ");
INSERT INTO bel_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","Тады возьмеш шыла і праколеш вуха яму пры дзьвярах, і будзе ён табе служыць вечна, і падобна зробіш і з нявольніцай тваёй. ");
INSERT INTO bel_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Няхай ня будзе прыкрым у вачах тваіх, што пускаеш яго свабодна ад цябе, бо служачы табе шэсьць гадоў, ён зарабіў табе падвойную плату найміта, а ГОСПАД, Бог твой, будзе дабраслаўляць цябе ў-ва ўсім, што робіш. ");
INSERT INTO bel_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Усіх першародных мужчынскага роду, якія родзяцца ў валоў тваіх і авечак тваіх, маеш пасьвяціць ГОСПАДУ, Богу твайму. Ня будзеш працаваць першародным валом тваім і ня будзеш стрыгчы першароднага з авечак тваіх. ");
INSERT INTO bel_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Штогод перад абліччам ГОСПАДА, Бога твайго, у месцы, якое выбраў ГОСПАД, Бог твой, будзеш есьці іх ты і дом твой. ");
INSERT INTO bel_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Калі яно будзе мець загану, будзе сьляпое, кульгавае або з нейкім недахопам, ня зложыш такога ў ахвяру ГОСПАДУ, Богу твайму. ");
INSERT INTO bel_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","У брамах тваіх зьясі яго. Чысты і нячысты чалавек можа есьці яго, як сарну і аленя. ");
INSERT INTO bel_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Толькі крыві іхняй ня будзеш есьці; выльлеш яе на зямлю, як ваду. ");
INSERT INTO bel_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Захоўвай месяц Авіў і сьвяткаваньне Пасхі ГОСПАДА, Бога твайго, бо ў месяцы Авіў вывеў цябе ГОСПАД, Бог твой, з Эгіпту ноччу. ");
INSERT INTO bel_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","І ахвяруеш ахвяру Пасхі ГОСПАДУ, Богу твайму, авечку ці цяля, у месцы, якое выбраў ГОСПАД, Бог твой, каб было там імя Ягонае. ");
INSERT INTO