﻿USE sofia;
DROP TABLE IF EXISTS sofia.bef_vpl;
CREATE TABLE bef_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bef_vpl WRITE;
INSERT INTO bef_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ma fayahi Yesu Kilisitohi tataꞌagi enigiꞌani mana niꞌibe. Yesuhi tataꞌafu mone Tebiti yabe. To ana bomofihi tataꞌafu mone koyapa bo giꞌa Abalaha yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalaha ai Isakahi afoꞌafu yabe. To Isaka ai Yakopuhi afoꞌafu yabe. To Yakopu ai Yutahi to gonaꞌamagihi afoꞌanifu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","To Yuta ai lihaꞌa Tema yagi etali panaꞌatiti loemo Pelesi to Yelaha yabe. To Pelesi ai Hesolonihi afoꞌafu yabe. To Hesoloni ai Lamihi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","To Lami ai Aminatapehi afoꞌafu yabe. To Aminatape ai Nasonihi afoꞌafu yabe. To Nasoni ai Salamohi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","To Salamo ai lihaꞌa Lehapu yagi etali panaꞌatiti Boasa yabe. To Boasahi ai lihaꞌa Luti yagi etali panaꞌatiti Opeti yabe. To Opeti ai Yesehi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","To Yese ai Tebitihi afoꞌafu yagi yaꞌma Tebiti sipi kibina bo huto huꞌehina yabe. To Tebitiu ai mone bo Yulaiya yabe ana bomofihi lihaꞌa Tebitiu lilago panaꞌa ketoꞌehina giꞌa Solomoni yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","To Solomoni ai Lehoboamuhi afoꞌafu yabe. To Lehoboamu ai Abaiyahi afoꞌafu yabe. To Abaiya ai Asahi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","To Asa ai Yehosofatihi afoꞌafu yabe. To Yehosofati ai Yolamuhi afoꞌafu yabe. To Yolamu ai Asaiyahi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","To Asaiya ai Yotamuhi afoꞌafu yabe. To Yotamu ai Ehasihi afoꞌafu yabe. To Ehasi ai Hesekaiyahi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","To Hesekaiya ai Manasehi afoꞌafu yabe. To Manase ai Emosihi afoꞌafu yabe. To Emosi ai Yosaiyahi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","To Yosaiya ai Yekonaiyahi to gonaꞌamagihi afoꞌanifu yagi fatehaꞌanimagi enaliꞌi Bebiloni metoga eneleꞌmete biꞌahanamofihi kanaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","To ana Bebiloni melugu mineꞌahananamofihi kanaꞌagu Yekonaiya ai Sialitielihi afoꞌafu yabe. To Sialitieli ai Yelababelihi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","To Yelababeli ai Abiutihi afoꞌafu yabe. To Abiuti ai Elaiyakimihi afoꞌafu yabe. To Elaiyakimi ai Asohi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","To Aso ai Yatokihi afoꞌafu yabe. Yatoki ai Ekimihi afoꞌafu yabe. To Ekimi ai Eliutihi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","To Eliuti ai Eliesahi afoꞌafu yabe. To Eliesa ai Matanihi afoꞌafu yabe. To Matani ai Yakopuhi afoꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","To Yakopu ai Yosefehi afoꞌafu yabe. To Yosefe Maliahi bahaꞌa yabe. Yaꞌma Malia ai Yesuhi itoꞌafu yabe. To Yesuhi giꞌa mone Kilisito yabe. Ana giꞌamofihi hapaꞌa Huꞌmau leꞌmo ho tiꞌehina bo nelanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ya huꞌehigo asaga Abalahahi nagaꞌaloti tito Tebitito pa sago nayahi luga luga su hoto nigigusagati loegi loegi heleko malago nagaꞌi mineꞌahana yabe. To nayahi luga luga su hago to nigigusagati loegi loegi heleko malago Tebitihi megesaloti tigo minana enali Bebiloni hepato eneleꞌmete biꞌahana. To ana huto nayahi luga luga su holoto nigigusagati loegi loegi heleko malago minana nagaꞌa enali mineme tite Mesiau huto hina kanalo mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu huto huꞌehinamofihi kagaꞌa ma huto niꞌibe. Ai itoꞌafu Malia, ai Yosefe hiti li alobole hiluꞌibe lite kehelite mineꞌahaꞌina. Ya huꞌehina etali li alobole hite yafi gofa hete etayanugu meliꞌahaꞌinamo Maliau molo kehelina Sikalafuꞌuba ailugu minago yagapanaꞌi ketalubeꞌmu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maliahi bahaꞌa Yosefeu, ai bati bo, to ai Maliahi ya huꞌahane luto leꞌmo buya mehuꞌehina. Ai legeso huto fala kito sugunaꞌi Maliahi heꞌmi etalube luto keheliꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ai Yosefeu Maliahi sugunaꞌi heꞌmi etalina ekesa yigiba yigiba huto nohigo bamulugu agelouba bulo huloto ma luto lu emiꞌehina: Yosefeo, Abalahahi tataꞌaga, kai Maliahi lihaka leꞌmo lolo hilatanaꞌmu koli mehubo. Ai Sikalafuꞌuba Maliahi yagapanaꞌi emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ai panaꞌi ketolenogo kai giꞌa Yesu yabe luto hobo. Henaꞌmugope ai boanaꞌamagihi foipanaꞌani li heꞌmi epoloto hetofa kapogu eneleꞌmo malalinaꞌmu yabe luto Sikalafuꞌuba Yosefehi lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yaꞌmana asagaꞌna ma huto huto hilina ai kaga mone Sipi Bouba lu huto huto bomofihi bagagu lulago oꞌehinamofihi legeyaꞌa huto hilibe. Lu huto huto bouba ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yafanaꞌuba yagapana hiti huloto panaꞌi ketoto giꞌa Emanueli luto malalinaꞌmu yabe. Yaꞌmana giꞌamofihi hapaꞌaya ma luto niꞌibe: Huꞌma lali hiti nominabe. ");
INSERT INTO bef_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefeu buꞌi koꞌehinati ho tiloto Huꞌmamofihi ageloꞌauba bamulugu lu eminaꞌa huto Maliahi li etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ya huꞌehina Yosefeu ai Malia hiti nohi kete ya hite mehuse nohigo Maliau panaꞌi ketoꞌehina. Ya higo Yosefeu ana panaꞌmofihi giꞌa Yesu yabe luto moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesuhi Betelehe hepato Yutia melugu Heloti sipi bo minana kanagu Maliau ketoꞌehina. Ya hulago alihi keheli bati huse bo lugaꞌa enali yege notinagati sonofiꞌi kene ite Yelusale hepato nehetiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","To enali ma lite enoloka heꞌahana: Yuhufa panaꞌi huto huꞌehina ai Yuta bonaꞌmagi sipi boꞌani lolo hilina hiyaꞌa nohibe? Ai sonofiꞌa yege notinagati tiꞌehigo bu golototi lali fokehi halune luto noone lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sipi bo Heloti yaꞌmana kaga keheliloto topa holoto lesaꞌa noligo ana huto asaga Yelusale boanaꞌi enelesa lu baga iꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helotiu asaga keya ka tisa bonaꞌi to mono noto kaba bonaꞌi kehe i nupa iloto ma luto enoloka hoꞌehina: Mesia hiyaꞌalo huto nohilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Enali lu emiꞌahana: Betelehe hepato Yutia melugu yabe. Lu huto huto bouba ya luto fayanugu go moloꞌehina yabe: ");
INSERT INTO bef_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Kai Betelehe Yuta melugu, kai sipi bo Yuta meꞌi kaba hiꞌahana bo enali enemegeꞌi olata mehubo. Kailuguti sipi bo mone huto huloto to ai Isilaeli nagaꞌnimagi kaba hu epalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ya higo Helotiu Yesuhi bu galune lite yege tinagati ana bonaꞌi kehe iloto ma luto sugunaꞌi enoloka hoꞌehina: Hena kanaꞌalo ana sonofiꞌi huto huꞌehifi luto enoloka hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","To ai ana bonaꞌi heꞌmi epalago nebago ma luto kaga lu epoloꞌehina: Bite ana panaꞌi sa hu bati hilete to bu getetinimo lenali ete lu nimilo, ya hinogo nani ana huto buto ai kumu fokehi halube. ");
INSERT INTO bef_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Enali Helotihi kagaꞌa akehelilete abiꞌahana. To enali ana sonofiꞌi koyapaꞌi yege notinagati bu gelete lifite eꞌahana kohe to epoloto buto ana panaꞌi nohina noto latahaꞌalo minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Enali sonofiꞌi bu gelete komopa bati higo sipi enegelo biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Enali ana nonuga tilete ana panaꞌi itoꞌafihi Malia hiti nehaꞌigo enali enalapusa fi emilete mono ka li etete hilete sisaku guꞌaniguti hetofa hatofana hefite emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","To bamulugu Huꞌmau hu enubulo mololoto Heloti nohinaga mebilo luto lu epigo enali fato kapoga bite hepaꞌaniga nehetiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Enali abilago Huꞌmamofihi ageloꞌauba Yosefehi bamuꞌi hu bulo mololoto ma lu emiꞌehina: Ho tito panaꞌi hiti itoꞌafi hiti eteleꞌmoto koli huto Iyipi melugu buto nohitogo alihi nani lu kiminogoꞌni alane. Helotiu pana kumu sa huto halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ya ligo ana foluguꞌi Yosefeu ho tiloto ana panaꞌi itoꞌafi hiti eteleꞌmoloto Iyipitoga biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya hite anaga nehago Helotiu filiꞌehina yabe. Yaꞌmana kana Huꞌmau lu yege hose bomagi enabagagu luꞌehina noseꞌnaꞌa huto hilibe luto Iyipi meluguti akuꞌi kehe ugo oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yege notinagati Yesuhi bu galuneꞌmu ana bonaꞌi enali Helotihi ya hite miꞌi malana akeheliloto italuga logo biꞌehina. Ya higo ai bonaꞌi lugaꞌa enoho lifigo Betelehe hepato hiti to hepaꞌi lugaꞌa ana lebato ninalo hiti asaga panaꞌi kufuꞌani loemo buꞌehinafi to yuhufa huto nehana asagaꞌi enoho fili su heꞌahana. To ai yege notinagati ana bomagihi enoloka nohago lu emina kaga ekesa yigiloto yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ya huꞌehigo kaga mone Huꞌmau koyapaꞌi lu huto huto bo, Yelemaiyaha, bagalo moloꞌehinaꞌa huto nohibe luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Enali Lama hepaluguti bona nogo mone keheliꞌahana. Sipi eniginaga figo yibi ahi ahi lite nehana enali keheliꞌahana Laseliu ai yagapanaꞌa asagaꞌi afili su heꞌahago sipi yibi huto minago bonaꞌmagi leꞌmo fulu mone mehiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Alihi Helotiu afililago Huꞌmamofihi ageloꞌauba Yosefehi Iyipi melugu bamuꞌi hu bulo moloto ma luto lu emiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ho tito panaꞌi hiti itoꞌafi hiti eteleꞌmoto Isilaeli hepatoga akuꞌi bubo, enali panaꞌi haluneꞌmu sa sa hiꞌahana bonaꞌi yatai afiliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ya ligo Yosefeu ho tiloto ana panaꞌi itoꞌafi hiti eteleꞌmoto Isilaeli hepatoga akuꞌi legete biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ya huꞌehina Akeleasiu afoꞌafihi Helotihi nonaꞌa Yutia bonaꞌmagihi kaba boꞌani nohibe lana Yosefeu koli huto Huꞌmau bamulugu kaga mone hiti lu emigo keheliꞌehina. Ya huloto ai ana hepa heꞌmito Galili kegiꞌa bu moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ai buto Nasalete hepato nohi gito minoꞌehina. Ya higo kaga lu huto huto bonaꞌmagi liꞌahanauba legeyaꞌa li huto nohibe lite liꞌahana: Enali Nasalete bo yabe lite lilata hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yaꞌmana yupahi Yoniu Yutia kamelugu humofaꞌna huto mono ka ma luto lu epimofaꞌna huꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Komopatini i gelehe hite foipanatini heꞌmi su halo luꞌehina. Huꞌmamofihi kokulumalugu kapoꞌa hokolo hilina kanaꞌa epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Huꞌmamofihi bagaꞌa lu huto huto bo Aisaiyau liyafa huloto ma luto Yoni kumuꞌi luꞌehina yabe: Bonaꞌi menehanaga meluguti bo moneꞌmofihi bagaguti ma luto nolibe: Sipi Bomofihi kapoꞌa li loloba hi etalo. Kapo kuyugu huꞌehilina li fu nelite li yuhufana hi eteꞌehinogo ai analo kapo malalibe. ");
INSERT INTO bef_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoniu guketeꞌa hepilata hina kameli yaga okaꞌa gukete hepito humofaꞌna huꞌehina. To gilimiꞌa fatipagu ilata hinaya yaga gufaꞌatu lolo huto iꞌehina yabe. To kenuꞌi hiti to lopi upeꞌi fiꞌehinaꞌa hiti noseꞌnaꞌa nolata huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ana yupahi Yelusale bonaꞌi to Yutia kegiꞌa bonaꞌi to asaga hepaꞌi Yotani nagami bele belehi ninalo neminana bonaꞌi asagaꞌi Yonihi aitoga eꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ya hite foipanaꞌani aitoga pa sago Yotani nagamilugu nagami folo epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoniu Felosi bonaꞌi to Satusi bonaꞌi babu lite nagamiꞌi folo letalane lite ago bu enogoloto ma luto lu epiꞌehina: Lenali foipa osifaꞌmofihi yagapanaꞌa, kuyuꞌafu lu lepigo Huꞌmamofihi italuga logo biseꞌna alihi huto hilubeꞌmu nohina koli falaluneꞌmu nehabe luto ka epekiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lenali komopatini i gelehe hilete yalo etonaguti mineme binogo buto komopatini i gelehe i baga ilibe. ");
INSERT INTO bef_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lenali lenipatinigu ma lite mekehelilo: Abalahau ai afotifu yabe, lali mino fu luse bonaꞌi Huꞌmau lifisa meilibe. Nani lu nolepube, Huꞌmau ai kaꞌma nina efahi liloto Abalahahi panaꞌa lolo hilina bati nohibe. ");
INSERT INTO bef_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Luhi loloba huto yafa hapaꞌalo niꞌibe. Asaga yafa legeyaꞌa mehalinamofihi hetigi su hoto logogu genogo logouba lo su halibe. ");
INSERT INTO bef_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lenali komopatini i gelehe hanaꞌmu luto nani faꞌmene nagamitu nofolo lepolobe. Ya nohunaya ai bo mone nani nemegesalo alina bouba ai Sikalafuꞌi to logoꞌa hiti folo lepalalinaꞌmu yabe luto Yoniu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","To ai emuhaꞌa yanuga liꞌehibe. To kifi foyaguti lilina yabe. To ai noseꞌna yufagahaꞌa li nomalana nonugu li nupa huto li malalinaꞌmu yabe. To yana huto sibinaꞌa li nupa huto mesobose loba logogu galinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ya luto luꞌehina kanaꞌaluga Yesu Galili hepaꞌi heꞌmito Yotaniꞌi kegiꞌa Yoniu nagamiꞌi folo netalibeꞌmu yabe luto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ya huꞌehina Yoniu: Oꞌe, luto laga hu etoloto ma luto lu emiꞌehina: Kai nagami folo netalata bati huto niꞌinamo kai nanitoga noane. ");
INSERT INTO bef_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ya ligo Yesu kaꞌalo ma luto lu emiꞌehina: Anaꞌa hiligi ya meluto yatai kai lu nokumuna suhi hubo. Ya huto yaꞌma kapolo li moloto hiluꞌinauba Huꞌmau luꞌehinamofihi hinogo bati hilinaꞌmu yabe. Ya ligo Yoniu Yesuhi kaga lina megeꞌi moloto nagami folo etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu nagamiꞌi afolo etolago meleꞌisi faꞌmene kugutatoga ti moloꞌehina. Ya nohigo analo kokulumaꞌi hokolo nohigo anaguti Huꞌmamofihi Sikalafuꞌa limiꞌehina, ai kigopa nama legitana lolo huto oto Yesuhi latahaꞌalo fi besa loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ya nohigo kokulumaluguti kaga mone ma luto luꞌehina: Yaꞌma naniꞌni panaꞌni manaꞌa nohibe. Laga nebesina panaꞌni nohigo ai kumuko hetofa panaꞌni yabe luto negelo bi emilata nohuna yabe luto kokulumaluguti luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ya hulago Huꞌmamofihi Sikalafuꞌauba Yesuhi leꞌmoto ka melugu Satau fi taga hu etalibe luto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu yege 40 to 40 sinihi noseꞌna menose anaga minoꞌehina. Ya huloto alihi sipi kauꞌna hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ya higo Satau aitoga henetiloto ma luto lu emiꞌehina: Kai Huꞌmamofihi panaꞌmo nohutomo kaꞌma niꞌina efahi lu epitogo noseꞌna lolo hino. ");
INSERT INTO bef_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu kaꞌalo nonaꞌa ma luto lu emiꞌehina: Monolugu ma luto niꞌibe: Bonaꞌmofihi komopaꞌa noseꞌnauba li buto mebilina ai asaga kaga Huꞌmau moloꞌehinaubagoko leꞌmo buto bito hetofa kapolo malalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ya luto ligo akuꞌi heꞌmito Satau Yesuhi leꞌmoto mone hepato buloto mono nohi latahaꞌa kosa kosa huꞌehinalo leꞌmoto tito heꞌmi etoloto ");
INSERT INTO bef_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ma luto lu emiꞌehina: Kai Huꞌmamofihi panaꞌa nohutomo maloti heleko lago uma melugu limibo. Mono kauba ma luto lulata nohibe: Huꞌmau kai kumu luto ageloꞌa enoho lifinogo limite nehinogo enali enayanugu limito ketogo keleꞌmo saga hilanaꞌmu yabe. Ya hinogo efahuba kigika noto ya huto mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ya noligo Yesu kaꞌalo ma luto nonaꞌa lu emiꞌehina: Monolugu moneꞌa hiti ma luto niꞌibe: Kai Sipi Bomofihi fi taga mehu etobo, ai Huꞌmakafu nohibe. ");
INSERT INTO bef_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","To yaloti heꞌmito Satau Yesuhi leꞌmoto yatama kosa mone ninalo leꞌmoto tiloto asagako kapo lepito anana anana hetofana ninamofihi lepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ya huloto ma luto Yesuhi lu emiꞌehina: Kai kolohupa nohi filoto nunumu lu netoto nigi li saga huto nofokehi halata asagaꞌna kaigo kimi su halube. ");
INSERT INTO bef_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ya ligo Yesu Satahi ho lifito ma luꞌehina: Satao, abufa hubo. Mono kauba: Huꞌmamofihi Sipi Bo aisigo giꞌa li saga huto fokehi hoto agoya hu emibo, luto lulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ya ligo Satau heꞌmi etoto abufa nohigo agelomagi ete analo Yesuhi heꞌmeꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yonihi naga foyagu leꞌmo malabe lite lanaꞌa Yesu akeheliloto ai Galili melugu bufa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya huloto ai Nasalete hepato meminoꞌehina ai heꞌmito buto Kapaneami hepato minoꞌehina. Kapaneami ai Galili Hefuhi belehaꞌalo Sebuluni to Nafatali melugu minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ya huꞌehigo Huꞌmau kaga mone lu huto huto bo Aisaiyaha bagalo moloꞌehinauba legeyaꞌa huto nohibe. Ai ma luto noli: ");
INSERT INTO bef_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebuluni meꞌi to Nafatali meꞌi nagami hefutoga nina, to hepaꞌi Yotani Nagami beletoga mino bego bego huꞌehina, to Galili ifoꞌaga fegutoga bonaꞌi neminana kegiꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bonaꞌi enali metepunagu neminana enali sipi logo fana mehenaꞌa abu geꞌahabe. Enali bonaꞌi metepu ito filisemofihi hepaꞌi ninalo neminana enalitoga fana mehena ahuto hu epolo baga iꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yaꞌmana kanaloti hapi fito Yesu mono ka ma luto lu epiꞌehina: Foipanatiniguti komopatini i gelehe hilo. Kokulumamofihi kapoꞌa anasi aꞌo leba toꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili nagami Hefuhi belehaꞌaga kapo moloto notubuto loe kogunale bu etogoꞌehina. Simoni, enali Pita lite giꞌa helata nehana hiti to gonaꞌa Atulu, etali hefunugu faya gutalafa melete nehaꞌigo bu etogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ya huloto Yesu ma luto lu etimiꞌehina: Nani nemegeꞌi meleꞌinogo nani letelepinogoꞌni bonaꞌi eneleꞌmo kefefe hite lilaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ya ligo etali hololu lite faya gutalafaꞌatiti neheꞌmite Yesuhi megeꞌi meleꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bu fotoꞌalo mololoto ana huto kogunale Yemesi to Yoni, etali Sepetihi panaꞌa nehaꞌigo bu etogoꞌehina. Etali botiꞌatitigu afoꞌatitifi hiti faya gutalafa li loloba hite nehaꞌigo Yesu kehe i etimiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ya higo hololu lite afoꞌatitifi hiti to boti hiti neheꞌmite Yesuhi megeꞌi meleꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili kegiꞌa minomofaꞌna huto mono nohaꞌanigu tiloto boanaꞌi mono ka lu epila to Huꞌmamofihi Kapoꞌa kumu kaga lu epila nohuto to boanaꞌi enebesiꞌehinana li heꞌmi epolola to enigi enayahi sibina hula ya hula huꞌehina bonaꞌi eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ai kagaꞌa Silia kegiꞌa bu baga ilago kehelilete enali bonaꞌi anaga enebesinafi to foipa liꞌahana bonaꞌifi to fato fatoꞌna epesiꞌehina bonaꞌi eneleꞌmete Yesu nohinalo eꞌahana. Ya hago Yesu asaga bonaꞌi eneleꞌmo bati nohuto eneleꞌmo ye ko su hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Babu boanaꞌi Galiliti Tekapoli kegiꞌati to Yelusale hepatoti, Yutia kegiꞌati to Yotani beletoga neminana boanaꞌi asagaꞌi babu lite li nupa hite, Yesuhi megeꞌi molomofaꞌna hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu bu gana babu boanaꞌi megeꞌi lifite nebago ai kosagu tito analo nohigo koko pananaꞌa ai metoga ete mino bego hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ya hago Yesu kaga ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Bonaꞌi enali komopaꞌanigu nani bati mehina bo nohube lite kehelite yaꞌma minelata nehana enali enegelo bilo. Enali Huꞌmamofihi kapoꞌalugu tilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bonaꞌi enali eniginage figo neminana enofokehi lilo. Huꞌmau eneleꞌmo fulu hu epoloto soso hu epalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Agoya bonaꞌi enali enegelo bilo. Enali kaga molo epoloꞌehinalo asaga meꞌi lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bonaꞌi enali bebe sete hapaꞌani minenogo Huꞌmamofihi kaꞌalo megeꞌi melete minalana enali enegelo bilo. Huꞌmau alihi asagaꞌna epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bonaꞌi enali lugaꞌa bonaꞌi eniginaga ka lu epite agoya hu epilata nehana bonaꞌi enegelo bilo. Alihi Huꞌmau enegelo bi epito agoya hu epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bonaꞌi enali komopaꞌani gulu gulu ligo neminana bonaꞌi enali enegelo bilo. Enali Huꞌmamofihi bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bonaꞌi enali luba hiluneꞌmu nehinogomo ana luba folagahaꞌanigu bite kofa hu epelelata nehana bonaꞌi enali enegelo bilo. Huꞌmau ai pananaꞌni yabe lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Huꞌmamofihi kaꞌa megeꞌi melete minelata nehana bonaꞌi enali enagabu foya nelitemo enegelo bilo. Huꞌmamofihi kokuluma kapoꞌa enaliꞌna lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","To lenali naniꞌi nemegeꞌi melete neminenogo lugaꞌa bonaꞌmagi bu lenegelete enitaluga logo binogo foipa faipa ka li lepelete lenegene mane ite ka fato fatoꞌmofihi lenalitoga lu nemelenogomo lenali lenegelo bilo. ");
INSERT INTO bef_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ya nehinogomo kugufaluga laga kebesinogo kegelo bibo. Sipi minaka kokuluma hepatoga Huꞌmau kaba hu ketoꞌehina kimilinaꞌmu yabe. Koyapaꞌi ana suhi hite lu yege hose bonaꞌi kohe tete huto hanamagihi enegene mane ite eneheꞌahana yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Bonaꞌi lenali meꞌmofihi hegeꞌa legi hite nehabe. Ya huꞌehina ana hegemofihi lagaꞌa abu su holagomo lenali akuꞌi hena hago ana hegemofihi laga lenalitoga olata nohibe? Ya hina hegemofihi lilinaꞌa meminolata nohibe. Enali bati mehuꞌehibe lite li neheꞌmigo boanaꞌi analo lapasa ite kapo melelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lenali melugu fana mehenaꞌa legi hite nehabe. To hepaꞌi mone kosagu minolata nohina ana hepaꞌi bona enubulo fala kito meminolata nohibe. Ai hutoꞌi minolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bonaꞌi enali libiꞌi li kulu tilete somotu ifi metalibe. Enali ifo hitalo malago nonugu nehana bonatoga kululu tuto fi besa lo baga igo be ge fana tete minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ya huto ninagi lenali libitini ligite boanaꞌi enali enubulo binogo lenali hetofa hapatini bu gelete to enali ana hite Sipi Bo Huꞌmatinifu kokuluma hepatoga nohinamofihi enegelo bite giꞌa liyafa hilabe. ");
INSERT INTO bef_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Lenali nani kumuꞌi Mosehi keya kaꞌa hiti to lu yege hose bonaꞌmagihi kaꞌani hiti li heꞌmilube luto oꞌehibe lite mekehelilo. Nani li heꞌmilube luto meoꞌohuna ana kagaꞌa luꞌehinamofihi pa salibe luto oꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Uleꞌale huto lusiga maꞌnaka luto nani lu nolepube, asagaꞌna ma meꞌi hiti kokuluma hiti su hoto bilinaya Huꞌmamofihi keya kaꞌa kitili kitiliꞌna su hoto mebilina analo minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ya huꞌehinagi bo moneuba Huꞌmamofihi keya kaꞌa nesiꞌasi li gofa hoto pelesa iloto lugaꞌa bonaꞌi ana suhi huto enelepilina kokuluma kapolo giꞌa nesiꞌasi minalibe. To bo moneuba hetofana huto keya kamofihi liyafa huloto megeꞌi moloto nominoto boanaꞌi ma kaga megeꞌi malalo luto eneleꞌmo ho tiloto hetofa kapogu malalina ai kokulumalugu sipi giꞌa minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya huꞌehina nani lenekesa nobube. Lenali Huꞌmamofihi laga besina suhi hite hetofanaguti minalanauba Felosi bonaꞌi hiti to keya kaga enelepise bonaꞌmagihi hapaꞌani enebe liginogoko lenali kokuluma kapolo nehetilanaꞌmu yabe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Koyapaꞌi kaga mone ma lite keya kagu tatatinigihi lu keyeꞌahana akeheliꞌahabe: Bo moneuba mone bo ho fililina ana bo ai ka foyagu filinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ya huꞌehina yatai aku nani lu nolepube. Bo moneuba gonaꞌa ipakafa halina ai ka foya lilinaꞌmu yabe. To bo moneuba gonaꞌamofihi kaiya faꞌmene bati mehina bo nohane luto ka emekilina kanisole bolo ho tito ka foya lilinaꞌmu yabe. To bo moneuba gonaꞌamofihi negi nagi noto bati mehuꞌahata bo nohane luto ka emekilina aiya loba loba logo kapogu bilinaꞌmu yabe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ya huꞌehinagi kai Huꞌmamofihi lokiya fi emilubeꞌmu hitalo oloto yataꞌa kogonaka ka emekiꞌehilata kekesa hokolo hinogomo ");
INSERT INTO bef_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","asagaꞌna ana hitalo nomoloto hololu luto buto kogonaka leꞌmo fulu huto ya huto kipakafa hoto ka emekiꞌohuna yatai lubeyaga nounagihe luto li koguna ileteꞌatiti yalo alihi oto Huꞌmamofihi hitalo lokiya fi emibo. ");
INSERT INTO bef_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","To bo moneuba ka foyagu keleꞌmo malalubeꞌmu keleꞌmoto nobinogomo kapoga nebitetiti kai meleꞌisi hololu luto ipakafa mehoto kiya yogokolo hu emibo to ka hetofaꞌa lu emito koguna ito minobo. Bonaka ana bouba yasimofihi yato keleꞌmo melenogo to yaloti yaꞌmauba polisi bomofihi yato keleꞌmo melenogo yaloti polisi bouba naga foyagu keleꞌmo molo lalibe. ");
INSERT INTO bef_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya hinogo anaga nohutoka efahi tina hu ketoꞌehinamo molo emiloto nagaluguti su halane, to tinakalo emi pa mesotomo ana naga foyagu minomo buto emiletogomo su halataꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Lenali koyapaꞌi yaꞌma kaga lago akeheliꞌahana yabe. Lenali bo alobo gofa mehalo. ");
INSERT INTO bef_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ya huꞌehina nani yatai ma luto lu nolepube. Bo moneuba aꞌi mone bu goloto buluꞌi hoto ipaꞌa emito minalina, ai komopaꞌagu ya huto kehelilinauba, ai alobo huto minosemofihi keya kaꞌa li gofa hoto komopaꞌagu foipana nohibe. ");
INSERT INTO bef_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","To lamagakaga kubukauba ligo foipana nohutomo li kutu hoto heꞌmilago bubo. Kugufaka luga kegiꞌa fenene hinogo nohuto minoba minoba kapogu bilata bati huto yabe. To kugufaka asagaꞌi niꞌinogo nohuto logo kapogu bilata ya bati mehuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","To kayahi lamagaꞌauba ligo foipana li huto nohutomo ana kayahi laga huto heꞌmilago bubo. Mone kayahi laga hu heꞌmilago ya hina bati hutitaꞌmu asaga kugufaka niꞌinogo logo kapogu bilata bati mehutitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Koyapaꞌi bina kagu ka mone ma luto minoꞌehina yabe: Bo moneuba lihaꞌa heꞌmi etalubeꞌmu nohutomo fayahi mone ya huto lihaꞌni heꞌmi etobe luto koyoto emibo luto nina yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ya huꞌehina nani yatai lu nolepube. Bo moneꞌmofihi lihaꞌa fato bo hiti koto ho tito mehuse bati huto nominago to ana bouba yaꞌma lihaꞌa heꞌmi etolenogo to yalo ana lihaꞌauba fato bolo buto minalina ai yaꞌma bomofihi hapaꞌauba ligo lihaꞌauba li alobo huꞌehina keya ka gofa nohabe. To bo moneuba ana aꞌi lilotomo ai bo alobomagi keya ka li gofa holago foipanaꞌa nominabe. ");
INSERT INTO bef_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","To mone keya ka tatatigi alago lenali hiti akeheli su heꞌahanaya ma luto niꞌibe: Kaga mone nolutomo ana kaga faga yabeꞌamu leꞌmo amuya malalubeꞌmu lutomo lusiga luto ifoloti nolube luto melubo. To lusiga nolutomo lusiga maꞌnaka nolunagihe luto lu hokolo huto lubo. ");
INSERT INTO bef_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ya huꞌehina yatai nani lu nolepube. Lenali kaga mone leꞌmo amuya malaluneꞌmu nehitemo ifo muya kokuluma hepatoti nolune lite melilo. Kokulumaꞌi ai Huꞌmamofihi hepaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","To lenali kaga mone leꞌmo amuya malaluneꞌmu nehitemo meꞌi gi mehalo. Meꞌi Huꞌmamofihi lagaso hepaꞌa niꞌigo aiꞌnanalo giꞌa mololata nohibe. To lenali kaga mone leꞌmo amuya malaluneꞌmu nehitemo lenali Yelusale hepaꞌi giꞌa mehalo. Yelusale hepaꞌi ai Sipi Bomofihi hepaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","To kaga mone latahakalo li moloto lu amuya memolobo. Okaka legeyaꞌa moneꞌisi koholina li lolo hula to nupaꞌna li lolo hula mehilataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ya huꞌehinagi lenali oꞌyo lila, to oꞌe lila hite anaꞌasiya lilata hilo. To kaga analo lu yatama hite lilata nehana kagamoya foipa bo Satatogati olata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yaꞌma kaga koyapaꞌi ahuto hina lenali akeheliꞌahabe. Kai kubuka i polo nehinogomo ana huto enali enubu i polo hubo. To kabaga yogoꞌa ife nesenogomo kai ana huto enali enabaga yogoꞌa ife sobo. ");
INSERT INTO bef_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ya huꞌehina nani akuꞌi yatai lu nolepube. Lenali bo moneuba osahi lenehenogomo lenali ana bo nonaꞌa mehalo. Lenabaga hapaꞌalo lamagatiniga inogomo mone kegiꞌa i gelehe hu emitogo ino. ");
INSERT INTO bef_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","To bo moneuba ka foyagu keleꞌmo malalubeꞌmu nohuto kefeka nolinogomo guka hiti heti emitogo lino. ");
INSERT INTO bef_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","To bo moneuba anaꞌinaꞌa neheꞌmoto lito buto emasilo limilane linogomoya kai heꞌmoto buto ai luꞌehina be ligito fotoꞌalo emibo. ");
INSERT INTO bef_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","To bo moneuba anaꞌina nimibo luto kehe inogomo kai emibo. To anaꞌina kaitogati yokaꞌi lilune lite kehe neinogomo kai oꞌe luto kemegesa hu meepibo. ");
INSERT INTO bef_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Koyapaꞌi yaꞌma kaga huto huꞌehina lenali akeheliꞌahabe: Lenali bonaꞌi lenalalutinigigo eneleꞌmo bati nehite fatehatini lenipakafa ho epite eneleꞌmo fato malalo. ");
INSERT INTO bef_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ya huꞌehina nani yatai akuꞌi lu nolepube. Fatehatini eneleꞌmo bati nehite to lenaliꞌi leneleꞌmo bati mehilana bonatoga nunumu Huꞌmamofitoga hu epelenogo ai eneheꞌmalibe. ");
INSERT INTO bef_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ya hilete yalo lenali kokulumalugu Afotinifihi pananaꞌa lolo hilanaꞌmu yabe. Ai bo foipaꞌafi to bo manaꞌafi enogo moneꞌago huloto anabo anabo yegeꞌamofihi fana mehaꞌa epilata nohibe. To ana huto koꞌi bo manaꞌa noepito bo sibinaꞌa noepito hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","To lenali bonaꞌi enipa lepilata nehana bonaꞌi enipa epite eneleꞌmo bati hilata nehanaguti hena minaꞌa lilana niꞌibe? Enali foipa boanaꞌi hiti takisi lilata bonaꞌi hiti ana suhi hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","To kai kalalukafinogo yahi emito be notigito fatehakamofito kubu bu go fatoga nomalata henanaloti lugaꞌa bonaꞌi enebe ligilata niꞌibe? To fegutoga bonaꞌmagi hiti ana suhi hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ya huꞌehinagi lenali asaga yupahi hetofanaguti minete hetofa foya lite bebe sete kokulumalugu Afotinifu hinaꞌa hite minalo, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lenali kaba hu bati hilo. Lenali hetofa hapatini asaga boanaꞌmagihi enubulo enali be galabe lite li huto hite lolo mehilo. To lenali ya hilana kokulumalugu Afotinifitogati minaꞌa melilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","To feꞌnohaꞌa meniꞌise bomofihi anaꞌina heꞌmoto emilubeꞌmu nohutomo, kai fagalo bonaꞌmagi mono nonugu hila to kapo napagu hila nehanaꞌa huto bona enubugu fi yotili katili ito bula ola mehubo. Ya hilata nehana bonaꞌiya enali boanaꞌmagi bu lagalabe lite hilata nehabe. Nani lusiga luto lu nolepube. Enali alihi melilana minaꞌani yatai alite neminabe. ");
INSERT INTO bef_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","To feꞌnohaꞌani menilina bonaꞌi eneheꞌmalubeꞌmu nohutomo legeso huto fala kito sugunaꞌi lolo hubo, to kayahi lamagaꞌagati ya hilubeꞌmu nohutomo kayahi sogaꞌa lu meemibo. ");
INSERT INTO bef_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","To kai ya huto fenene huto sugunaꞌi lolo huletogomo Afokafu kokulumalugu nohinauba asaga sugunaꞌna bu go baga ilata bouba bu kogoloto alihi mina kimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kai nunumu hilubeꞌmu nohutomo fagalo bomagi hilata nehana suhi kai mehubo. Enali mono nonugu ho tite nehite nunumu lilata nehabe, to hepalugu sipi kapo i loe lae huꞌehinalo bite bona enubugu nehite nunumu hilata nehabe. Nani lusiga luto lu nolepube. Enali minaꞌani aliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","To kai nunumu hilubeꞌmu nohutomo legeso huto kose nohakagu tiloto kafeka li hekini loloto Afokafitoga numuna hu emitogo ai fala kito nohinati keheli ketalibe. To ai Afokafu asaga sugunaꞌi ninana bu golata bouba bu kogoloto analo nonaꞌa kimilibe. ");
INSERT INTO bef_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","To lenali numuna hiluneꞌmu nehitemo kegeiyo bonaꞌmagi nehanaꞌa hite yatamalo kaga babu lite melilo. Enali babu kaga linogoti Huꞌmau nunumuti keheli bati hilibe lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lenali enali suhi lite enemegeꞌi memalalo. Nunumu mehiꞌahago Huꞌma Afotinifihi kaga lu emilanaꞌa komopatinigu abu go su holata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lenali ma lite numuna hu emilo: Afotiga, kokulumalugu minane, kigika hetofa huto fato minalibe. ");
INSERT INTO bef_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kai kapoka ai huto hino, luto nolune. Enali kabaga liyafa hite kokuluma agoya hi nekimigo lali melugu ana suhi huto kabaga liyafa huto kofokehi haluneꞌmu nolune. ");
INSERT INTO bef_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kai yatai noseꞌnati limibo. ");
INSERT INTO bef_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","To kai foipanati li heꞌmi letobo, to lali ana huto bonaꞌmagi foipana nehiletana li heꞌmi epalalune. ");
INSERT INTO bef_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kai sipi fi taga huseꞌnagu leleꞌmo memoloto foipanamofihi afoꞌafitogati leleꞌmo lubuto bibo. ");
INSERT INTO bef_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kehelilo. Lenali bonaꞌmagitoga foipana li huto hu epeleꞌahana lenali li heꞌmi epelenogo, ana huto kokulumalugu Afotinifu lenali foipanatini li heꞌmi lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","To lenali boanaꞌi enali foipanaꞌani li meheꞌmi epalana ana huto kokulumalugu Afotinifu lenali foipanatini li meheꞌmi lepalalinaꞌmu yabe, Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Lenali mono kaꞌmu lite noseꞌna mo site neminetemo fagalo bomagi hilata nehana suhi hite lenokaba li sibina mehilo. Enali enokaba li sibina hilata nehanaya asaga boanaꞌmagi bu enegelete noseꞌna mo siꞌahabe lite lu epalalabe lite nehabe. Nani maꞌnaka luto lu nolepube. Enali ya hilata nehana bonaꞌmagi minaꞌani aliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ya huto niꞌinagi kai noseꞌna mo sito nominotomo okakagu mesebe nofoloto kokabaluga nagami koto li kosaba huto humofaꞌna hubo. ");
INSERT INTO bef_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ya hitogo boanaꞌmagi enali ya huto noseꞌna mo siꞌehina bo menohibe lite lilanaꞌmu yabe. Ya huletogo Afokafu fala kito fenene nohuto asagaꞌna bu golata nohinauba alihi hetofa minaꞌa kimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Lenali ma melugu hetofa hatofa feꞌnohatini li nupa mehilo. Ma melugu molepa kafamagi hiti to kagopa logoseꞌnauba anana anana li sibina hulata nohigo to guminalo bomagi kafe sigite gumina felelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ya huꞌehina lenali kokulumaluguꞌnatini li nupa hilo. Asagaꞌna kokulumalugu nina ai kagopa melogolata nohibe, to molepa kafauba menolata nohibe, to guminalo bouba kafe sigito tito gumina melilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yogo feꞌnohaka niꞌilinaga asaga yupahi komopaka minolata hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lubumoya lugufamofihi libiꞌa legi huto niꞌibe. Kubukauba bati huto niꞌitomo asaga kugufakaloga i besa lo baga ilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","To kubuka sibina huꞌehigomo asaga kugufakalo metepu i baga noibe. To kailugu fana mehena ninauba akuꞌi metepu hapi fito gilotomo analo sipi metepu i baga noibe. ");
INSERT INTO bef_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Koko panaꞌi moneuba loe bolo moneko kumu liliꞌna lilata menohibe. Ya hilina ai mone bomofihi liliꞌna li bati nohuto mone bomofihi liliꞌna li bati mehilinaꞌmu yabe. Lenali Huꞌmamofihi liliꞌnalo boꞌa neminete efapofihi liliꞌnalo boꞌa moneko kumu meminalo. ");
INSERT INTO bef_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yaꞌmu luto nani lu nolepube. Lenali nagamiꞌi to noseꞌna nete minalanaꞌmufi to gukete lenugufalo li hekelete minalanamuꞌi lenelesa nolinogo lenekesa yigiba yigiba mehilo. Bati huto minoseꞌnauba noseꞌna hoꞌehifi to bati huto minoseꞌnauba guketemofihi hoꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lenali nama helo lili hilata nehanamagihi bu enagalo. Enali noseꞌna foyagu hekelelete limo limo melete nelata menehabe. Huꞌma Afotinifu kokulumalugu nominanauba noseꞌnaꞌani epilata nohibe. Lenali nama enebege ligite nehana menekehelifiye? ");
INSERT INTO bef_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hiya bomaka minomo bilata kanaꞌagu kelesanaguti minalata niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","To hena hibe lite lenali gukete li hekelete minalanaꞌamuꞌi lenekesa yigiba yigiba hilata nehabe? Lose toseꞌna fegutoga minolata nohina enali hena hena huto tilata nehafi lenali bu galo. Enali liliꞌnaꞌani lila to guketeꞌani li hekelela menehabe. ");
INSERT INTO bef_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nani lusiga luto lu nolepube. Solomoni feꞌnoho bo minanaꞌa huto guketeꞌa ma lose tose kifinamagi li nehekalanaꞌa huto li hekoloto meminoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yatai huto hilete yago fenene hilete nehana lose tose kifiꞌnamagihi Huꞌmau guketeꞌani hu epololata nohibe. To lenaliꞌiba ana huto leneleꞌmo bati huto guketetini mehu lepalalina niꞌifihe? Lenegekesa menina bonaꞌi nehafi? ");
INSERT INTO bef_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ya huꞌehinagi lenali noseꞌna nalanaꞌmufi to gukete li hekalalanaꞌmu lenekesa yigiba yigiba hilete lenelesa melino. ");
INSERT INTO bef_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enali mono ka mekehelise bonaꞌmagi asaga yaꞌmananaꞌmu megeꞌi lifite kene ilata nehabe. Ya huꞌehina kokulumalugu Afotinifu asagaꞌna lilanana ya huseꞌna lilanagi luto akeheliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ya huꞌehinagi kai yataꞌa Huꞌmamofihi kapoꞌalo li kubulo moloto megeꞌi meletogo ai gelo biloto asagaꞌna batiꞌa kimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ya huꞌehinagi yagomoꞌmu henaꞌni hilube luto kekesa yigi babu melubo. Huꞌmau yagomo kaba hu ketalibe. Kai moneko moneko kanamuꞌi kekesa kehelito minobo. ");
INSERT INTO bef_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Lenali bonaꞌi enipakafa hete eneleꞌmo yegelo memalalo. To Huꞌmau alihi lenaliꞌi leneleꞌmo yegelo ana huto memalalibe. ");
INSERT INTO bef_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","To Huꞌmau huꞌehilata bameto li moloto keleꞌmo yegelo malalinaꞌmu yabe. To kaga luto bonaꞌi ya amuyaꞌniloti yabe lilata Huꞌmau ana moneꞌago kagaloti keleꞌmo yegelo malalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kai kogonakamofihi pehena bugu nina hena hibe luto gili gili nohu etane? Kai kubukagu kefa fulupa sipiꞌa ana huto koꞌehina bu goto li heꞌmiloto hubo. ");
INSERT INTO bef_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kefa fulupa felaꞌa kubukagu niꞌilina li meheꞌmise hena hibe luto kogonakamofihi ma luto lu emilata niꞌibe: Nogonao, pehena kubugu niꞌina li heꞌmi ketaluna bati huto niꞌifihe? Ya luto lilapiye? ");
INSERT INTO bef_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kai faga fagalo bo. Yataꞌa kai kubukagu kefa fulupa felaꞌa koyofo huꞌehina li heꞌmiloto yalo bu go fana toꞌohuto kogonakamofihi buguti pehena li heꞌmi etobo. ");
INSERT INTO bef_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lenali hetofa nasana kalamagihi meepilo. Enali i behe hite heni lepele lalabe nolube. To lenali pesesutini hetofa hatofaꞌa yagamagihi meepilo. Enali pesesutini libe hepulu tibe hite lapasa i lalabe nolube. ");
INSERT INTO bef_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lenali Huꞌmamofitoga nunumu hite kehe ilenogo lepilibe. Lenali sa sa hite lilabe. Lenali kasito inogo Huꞌmau kafe sigi lepalalibe. ");
INSERT INTO bef_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bonaꞌi enali Huꞌmamofitoga loka hete nunumu nehana. Ai epilata nohibe. Bonaꞌi sa sa hilinauba li huto hulata nohibe. To kasito noina bonaꞌmofihi kasihi hokolo hu etolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","To lenali afoꞌanigita panatinimagi noseꞌnamu kehe neinogomo efa kosahi li epilana niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","To faya kumu kehe neinogomo osifaꞌi li epilata nehafihe? Oꞌe, ya menehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ya huꞌehinagi lenali bati menehana bonaꞌmagita yagapanatinimagihi hetofana epilata nehinogomo yalo lali kehelilune, Huꞌma Afotinifu kokulumalugu nohinauba lenali nunumu hu emite ya hite hilana bonaꞌi hetofana lepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nanitoga ya suhi hu netalo luto kekesa noyigilata suhi enali fato bonatoga ana suhi hu epolobo. Yaꞌma ai Mosehi keya kaꞌamofihi hapaꞌa koyapaꞌi ninamolo to lu yege hose bonaꞌmagihi kaga enelepiseꞌnaꞌani hiti manaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Lenali kitili kapoguti ti hokolo hilo. Fenene huse hepaꞌi logo kapolo buꞌehina kapoya ai sipi fela kapo hokolo huto buꞌehibe. Ya huꞌehigo yege yege boanaꞌi ana kapogu bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","To hetofa hepato buse kapoya ai kitiliꞌi niꞌigo ana kapomofihi liliꞌnaꞌa uleꞌale huto lise suhi huto niꞌibe. Ya huꞌehigo moneꞌisi moneꞌisi boanaꞌmagi ana kapolo sa hite bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Lenali fagalo lu yege hose bomagihi kaba hu bati hilo. Enali sipisipi yagamofihi gufaꞌa gukete li hekelelete lenalitoga elata nehabe. Ya hiꞌahana enali komopaꞌanigu lopi kala suhi hite nehanago lenaliꞌiya lenehete salu kite nalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Enali hilana hapaꞌaniya lenali enogo hokolo hite bu enagalanaꞌmu yabe. Ufehe yafamagi nemuya legeyaꞌa helata menehabe, to nemuya yafamagi ufehe yafamofihi legeyaꞌa holata menehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","To bati huto mesebe lele tele huto tilata nohina yafauba legeyaꞌa bati huto sipina holata nohibe, to numutopa loloto sako bako logo huto lilata nohina yafauba legeyaꞌa sibina huto lagasoꞌasi holata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mesebe lele tele huto bati huto tilata nohina yafauba legeyaꞌa mone sibina huto holata menohibe, to numutopa ito sako bako huto lilata nohina yafauba legeyaꞌa bati huto sipina mone holata menohibe. ");
INSERT INTO bef_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","To yafa lugaꞌamagi enali noseꞌna legeyaꞌa meholata nehanaya laga huto logogu gelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ya huto niꞌinagi fagalo lu yege hose bomagi hilana hapaꞌaniya lenali enogo hokolo hite bu enagalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Asaga bonaꞌi nani kumuꞌi: Kibina boꞌnio, Kibina boꞌnio, lilata nehana enali kokulumamofihi kapoꞌalo mebilanaꞌmu yabe. To bonaꞌi lugaꞌamagi nani Afoꞌnifu kokulumalugu nohinamofihi bita hina suhi hilata nehana bonaꞌisi eneleꞌmalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ana kanaꞌa huto hilina yupahi babu boanaꞌmagi ma lite lilanaꞌmu yabe: Kibina boꞌnio, Kibina boꞌnio, kai kigilo Huꞌmamofihi mono kaꞌa lu epiꞌohuta yabe, to kai kigilo babeyafana sipi liliꞌna li huto huloto to foipa fele enoho lifiꞌohuta yabe lite lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ya lite nelinogo nani ma luto lu epilunaꞌmu yabe: Nani lenaliꞌi mekeheliꞌohube. Foipa faipa bonaꞌi lenali mino koli hite abufa hilo. ");
INSERT INTO bef_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ya huꞌehinagi, bo moneuba kagaꞌni kehelito liyafa huloto nemegeꞌi malalinauba ai bo moneuba hetofa ekesa keheliloto efaha meꞌi ninalo nohi gilata nohina suhi hilibe. ");
INSERT INTO bef_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ya huꞌehigo koꞌi noito habafahi nolito huloto nagamiꞌi bilito ya huto ana noto nohibe. To ana nohi li tele tulu menobibe. To henaꞌmugope efaha meꞌmolo ana nohi giꞌehigo lapusa yafaꞌauba limito ema melugu sipi efato li tokolo huꞌehigo yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","To asaga bonaꞌi enali kaꞌni kehelilete ana kaꞌnimofihi liyafa hite megeꞌi menemalana bonaꞌiya enali negi bomagi nagami beleto kehelugu nohi gilata nehana suhi lite nehabe. ");
INSERT INTO bef_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya hiꞌahago koꞌi noito habafahi nolito huloto nagamiꞌi ana nohi belehaꞌalo bilito ana nohi li kusago hekili higo limito kolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu yaꞌmana kaga alu su holago asaga li nupa hite minana boanaꞌi Yesuhi kagaꞌa kehelilete keheli fato fato hite sipi enelesaꞌani luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yesu ai bonaꞌmagi keya ka enelepilata nehanaꞌa huto meluꞌehina yabe. Ai amuyanaꞌani nina bomagi kaga lilata nehana suhi huto kagaꞌa lu epinaꞌmu enali boanaꞌi keheli meheꞌmiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu kosaguti limitogo babu boanaꞌmagi megeꞌi biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","To sipi hepuhi loꞌehina bo moneuba Yesutoga oto lahupa nohi fito luꞌehina: Sipi bomaka. Kai kegekesa kehelito nugufaꞌni leꞌmo bati hilataꞌmu nohane. ");
INSERT INTO bef_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ya ligo Yesu yatu su toto gufaꞌalo bako huto ma lu emiꞌehina: Nani ya hilubeꞌmu nohuto kugufaka gulu gulu hilinagi kehepuhaka asu hoꞌehina, Yesu ya luto ligo anaꞌasilo hepuhaꞌa asagaꞌna asu hoto fenene huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ya higo Yesu lu emiꞌehina: Kehelibo. Fato fato bonaꞌmagi kaga lu meepibo. Mono bomofitoga buloto kugufaka lepibo. Ai bu go bati huto higo mone nonaꞌa Mosehi koyapaꞌi kaga moloꞌehinamoꞌmu mono bomofihi emibo. Ya huletogo asaga bonaꞌi enubulo kugufaka gulu guluꞌehinana bu kagalabe, Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","To Yesu kapo moloto mone hepato Kapaneami tito nohigo mone Lomu gimi bouba oto lu emiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Sipi bomaka neheꞌmobo. Koko panaꞌni moneuba hepaꞌnimogu sipi besito nebelusaga minoba minoba nohigo gabu sipiꞌa nogibe, luto ligo, ");
INSERT INTO bef_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu lu emiꞌehina: Hepakaloga buto leꞌmo bati hilube. ");
INSERT INTO bef_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gimi bouba luꞌehina: Ya hilapi? Oꞌe. Nani faꞌmene bo nohunagi kai nohaꞌnigu metilane luto nokehelube. Kai faꞌmene lusa kaꞌago litogo koko panaꞌni gufaꞌaluga bati hilibe. ");
INSERT INTO bef_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","To henaꞌmube? Nani ana huto napa liꞌehina sipi bomofihi mahaꞌaluga nohugo liliꞌna nonimina yabe. To naniꞌni ana huto gimi boꞌni nehana nani namanuga ana hite nehabe. To nani mone keneꞌmofihi bubo luto nolugomo ai bulata nohibe. To mone fatoꞌamofihi obo luto nolugomo aꞌolata nohibe. To koko panaꞌnimofihi ya liliꞌna libo luto nolu etogomo ana liliꞌna lilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya luto ana bouba Yesuhi lu emilago Yesu ana kaꞌa keheliloto ekesa yigi babu lu emiꞌehina. Ya huloto boanaꞌi megeꞌi lefeliꞌali hana kaga ma luto lu epiꞌehina: Kehelilo. Nani lu nolepube. Isilaeli bo moneuba yaꞌma bouba hinaꞌa huto komopaꞌa li nimiꞌehina bu megolata nohube. ");
INSERT INTO bef_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lenekesu meheno. Asagaꞌi yege notinagati noliminagati fato fato hepatogati eteꞌani Huꞌmamofihi kapoꞌalo Abalahagi, Isakagi to Yakopugi li nupa hilete mineteꞌani noseꞌna nalabe. ");
INSERT INTO bef_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","To Isilaeli bonaꞌi moneꞌamagi ana kapoꞌalo tiluneꞌmu nehago Huꞌmau fegutoga sipi metepumogu heꞌmi epalalibe. Fegutoga sipi yibi hiba hiba hilete enabaga heni kofilabe. ");
INSERT INTO bef_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu gimi bomofihi lu emiꞌehina: Hepakaloga abubo. Keheli uleꞌale huseꞌnaka, to komopaka li nimiꞌahatana yaꞌma huto hilibe, Yesu luto luꞌehina. Ana kanaꞌagu meleꞌisi yaꞌma gimi bomofihi koko panaꞌa leꞌmo bati huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu Pitahi nohaꞌagu buloto bu ganamo Pitahi litayamiꞌafipo gufa mukoho akohona besiꞌehigo sipalo koꞌehigo bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ana aꞌmofihi yahi bako huto besinanaꞌa meleꞌisi fa hu etoꞌehina. Ana aꞌuba sipaloti ho tito noseꞌna laita hu epoloto gabu ito epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Utepoya bonaꞌmagi babu bonaꞌi epesina foipa felemo tiꞌahana bonaꞌi Yesutoga eneleꞌmete eꞌahana. Ya nehago Yesu ana foipa felemagi amuya kagaꞌasigo monekoꞌisi lu epigo bi fa hiꞌahana. To fato epesina bonaꞌi hiti eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ai ana huto huꞌehinagi koyapaꞌi Aisaiyau bu goꞌohuto kaga moloꞌehina: Ai lebesiseꞌnamo li heꞌmi letoꞌehibe. Ai lugufati sibina huꞌehinanamo aigokoꞌi kofito buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu babu boanaꞌi li nupa hilete nehago bu goto koko panaꞌamagi lu epiꞌehina: Muya hefutoga bilutagihe. ");
INSERT INTO bef_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kaga lu noepinogo keya ka enelepise bo moneuba aitoga oto ma luꞌehina: Tisao, kai hiti hiyaꞌaga bilapi bilatamoga bilube luto neleꞌmoto biluꞌibe luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","To Yesu lu emiꞌehina: Lopi kalamo kalina muliꞌi niꞌibe to namamo kalina nohi niꞌinaya to Kokulumaguti limiꞌehina Bouba koto basu bilina hepaꞌi meniꞌibe luto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","To bo mone Yesuhi megeꞌi moloꞌehinanauba lu emiꞌehina: Kibina boꞌnio, yataꞌa hepaꞌniga bulotoꞌni afoꞌnifu fililenogo keli hoto i behe huto kai hiti nani hiti minaluꞌibe luto ligo, ");
INSERT INTO bef_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu lu emiꞌehina: Kai nemegeꞌi molobo. Filiꞌahanana bonaꞌi komopaꞌani menimiseꞌnamagi filiꞌehina bonaꞌi keli halabe, Yesu ya luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu hiti koko panaꞌamagi hiti botigu tilete hefuhu nagamilugu biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","To Yesu buꞌi koꞌehina. Ya huꞌehigo meleꞌisi amuya habafahi hefupoguti liloto nagamiꞌmouba bililoto sipinamo botigu foloꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","To koko panaꞌa Yesutoga leꞌmo ho tilete ma lite liꞌahana: Sibi bo yale. Lali maꞌasi afililutaꞌa nohinagi leheꞌmobo. Meleꞌisi. ");
INSERT INTO bef_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu lu epiꞌehina: Koli gofana nehana henabe lutobe? Nani kumu keheliseꞌnatini nesiꞌasi niꞌigo uleꞌale hitemo memineꞌahabe. Koꞌehinati ho tiloto ana sipi amuya habapofihi hiti to nagamiꞌi bilina hiti kaga lu etimigo analo meleꞌisi felele huto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ya huꞌehigo asaga bonaꞌi enelesaꞌani liꞌahana. Ma bose. Henana bo nohibe? Habapofihifi nagamiꞌi bilinamofihifi kaga lu epigo enali kaꞌa keheli emina bo yabe, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu kapo molotoꞌa hefupo muya beletoga heleko moloto Gatala bonaꞌmagihi kapoꞌanigu nehetigo bo loemaleꞌi aitoga kene mala mala muliluguti eꞌahaꞌibe. Ana bomaleꞌi komopaꞌatitigu foipa felemagi tiꞌahanagi luba hise nehite hagulu netaꞌina bomaleꞌi yabe. Yana hepaꞌmo mineꞌahaꞌigo fato bonaꞌi koli nehite tilina mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesu olenogo etali sipi kehe ilete: Huꞌmamofihi panaꞌise. Hena suhi hu leꞌetalubeꞌmu nohane? Alihi asaga bonaꞌi halata yupahi yatai aku leꞌahalapiye? liꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Analo afehi yaga babu lite noseꞌnaꞌani line mane hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Foipa felemagi Yesuhi loka heꞌahana: Heꞌmi lepelenogomo miya yagamagi enugufagu leleꞌmo molobo lago, ");
INSERT INTO bef_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu: Abilo, luto enoho lifiꞌehina. Ya higo enali ana foipa felemagi bomaleꞌititihi heꞌmite yagamagi enugufagu tite falago ana yaga enali asagaꞌi yabatoga limilete bite hefunugu nofu ti su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ya hago yaga afoꞌagi analoti heꞌmite hololu lite bite tauniga nehetite asaga huto hinanamo hiti bomaleꞌi foipa fele komopaꞌatitigu nemina kagamo hiti lu epiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ya lu epilago tauniga neminana boanaꞌi asagaꞌna Yesutoga bilune litemo biꞌahana. Yesu nohinalo nehetite loka heba heba hite: Lali metimoloti heꞌmiloto bufa hubo, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu botigu tiloto i behe huto hefunugu i gofa hoto muya beletoga heleko moloto aiꞌa hepaꞌalo nehetiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lugaꞌa bonaꞌmagi bo mone gi yahi sibina huꞌehina bo sipaꞌalo koꞌehigo Yesutoga leꞌmete eꞌahana. Ya hago Yesuhi aitoga komopaꞌani meleꞌahana bu goloto Yesu ana gigusaꞌa sibina huꞌehina bo ma luto lu emiꞌehina: Panaꞌni, kipagu fulu hino. Nani foipanaka li noheꞌmi ketobe. ");
INSERT INTO bef_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ya ligo Mosehi keya ka enelepise bonaꞌmagi musi musi ka enaliꞌani ma lite liꞌahana: Ma bouba ai Huꞌmamofihi megeka nolu etabe. ");
INSERT INTO bef_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ya nelago Yesu kagaꞌani akeheliloto ma luto lu epiꞌehina: Lenali henabe lite foipa faipa lenekesa neyigibe? ");
INSERT INTO bef_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","To yaꞌmana bomofihi foipanaka li noheꞌmi ketobe nolunauba keta huꞌehifi, to ho tito kapo molobo lilunauba keta huꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ya huꞌehina nani lenaliꞌi lenelepilube, Kokulumaguti limiꞌehina Bouba ma melugu amuya liꞌehinago foipana li heꞌmilinaꞌa huto niꞌibe. Ya luto lu epiloto gi yahaꞌa sibina huꞌehina bomofihi: Ho tito sipaka kofito hepakaga bubo. ");
INSERT INTO bef_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ya ligo ana bo anaꞌasi ho tiloto hepaꞌaga bufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","To boanaꞌi enali anana huto hina be gelete koli hiꞌahana. Huꞌma yaꞌma huse amuyana bologa moloꞌehibe lite enali akeheliꞌahana yabe, ya hilete enali Huꞌmamofihi giꞌa liyafa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ana hepaꞌi heꞌmiloto kapo moloto binaga takisi nolina bo mone giꞌa Matiu yabe lite helata nehana bo ai takisi lilata nohina nonuga nohigo Yesu bu goloto ma luto lu emiꞌehina: Nemegeꞌi molobo. Ya ligo Matiu ho tiloto Yesuhi megeꞌi lifito buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","To Yesu ai nohaꞌagu noseꞌna noto nohigo takisi nelina bonaꞌi hiti to foipa bonaꞌi hiti babu lite eꞌahana. Enali Yesu hiti to koko pananaꞌa hiti noseꞌna nete mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ya nehago Felosi bonaꞌmagi be gelete Yesuhi koko pananaꞌa ma lite enoloka heꞌahana: Henabe luto tisa botiniuba ai takisi nelina bo hiti to foipa bo hiti noseꞌna nonabe? ");
INSERT INTO bef_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu enali kagaꞌani akehelito ma luto lu epiꞌehina: Enali meepesiꞌehina bo lusa bo nohinalo mebilata nehabe. To enali epesiꞌehina bonako lusa bo nohinalo bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lenali bite yaꞌma mono kamofihi hapa keheli bebe sete li buto hilo. Nani yagakafa eneheꞌahanamagi nimite nehago menebesibe. To nani fulu huseꞌnaꞌmuko nebesibe Huꞌmau luꞌehina niꞌibe, luto Yesu lu epiꞌehina yabe. To nani komopaꞌani bebe sana bonaꞌi kehe ilube luto meoꞌohube. Nani foipa bonaꞌi kehe ilube luto oꞌohuna yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yaꞌmana kanalo Yonihi koko pananaꞌa Yesutoga nehetilete ma lite loka heꞌahana: Hena huꞌehigo lali hiti to Felosi bo hiti noseꞌna mo silata nohunogo to enali kai koko panakamagi noseꞌna mo silata menehabe? ");
INSERT INTO bef_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ya lago Yesu ai lu epiꞌehina: To bo moneuba ana kata hilubeꞌmu nohigomo laluꞌagi hiti ete li nupa hite neminabe, ya nehanamagi enali enipagu sibina hulata nohifihe? Ya hulata menohibe. Ya huꞌehina alihi yaꞌmana ana kata nohina bo leꞌmo neheꞌmibe. Ya hago ai laluꞌagi hiti meminolata nohibe. Ya hilana yupahi analo enali noseꞌna mo site minalanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bo moneꞌamagi yuhufa kata letuhaꞌatu koyapa kata hepu toꞌehinalo hetilata menehabe. To ya hilana ai yuhufa kata letuhaꞌauba koyapa kata akuꞌi i hegege hinogo sipi hokolo kapo akuꞌi lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","To bonaꞌi moneꞌamagi yuhufa bai nagamiꞌi lite koyapa meme yaga gufaꞌa konugu heki bilata menehabe. To enali ya hilana koyapa meme yaga gufaꞌa kohi i hegege hinogo to bai nagamiꞌi melugu i heki su halinaꞌmu yabe. Ya hinaꞌmu yabe lite enali yuhufa bai nagamiꞌi yuhufa meme gufaꞌa konugu heki bigo to etali loe sana sana bati hite minelata nehaꞌibe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ana kaga lu epito nohigo kaba bo mone Yesuhi metoga o leba toloto to ai lapusa nohi fi emiloto ma luꞌehina: Paꞌni maꞌasi afiliꞌehibe. Ya huꞌehinaya kai oto kayahaꞌatu gufaꞌalo meko hitogo ai akuꞌi ho tito minalibe. ");
INSERT INTO bef_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To Yesu ho tito ana bo megeꞌi nobigo Yesuhi koko panaꞌa ana hite megeꞌi melete biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aꞌi mone minoꞌehina ai asaga yupahi golahaꞌa heꞌmiba heꞌmiba huto minago kufuꞌa nayahi luga luga su hoto nigigusagati loemo heleko malago minoꞌehina aꞌi yabe. Ai ana aꞌuba Yesuhi megesagati oto Yesuhi kefeꞌa nekisaꞌalo yahi liꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ai ana aꞌuba ma luto aiꞌa keheliꞌehina: Nani kefeꞌalo meko hulenogoꞌni nebesiseꞌnaꞌni su ho netalibe. ");
INSERT INTO bef_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu i behe huto ana aꞌi bu goloto ma luto lu emiꞌehina: Paꞌni, kipakagu fuluna kebesino. Kai nanitoga komopaka moloto minalatanauba keleꞌmo buto bito kebesiseꞌnaka li noheꞌmibe luto Yesu lu emiꞌehina yabe. Ya noligo anaꞌasilo ana aꞌmofihi nobesinana su ho etago bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ya huloto Yesu kaba bomofihi nohaꞌaluga buto tiꞌehina. Ya huloto bonaꞌmagi folonemeyahi melete nehago bu goꞌehina. To asaga boanaꞌi sipi yibi nama hite nehite kaga babu lite nelite henati hilune, lite enelesa ka lite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ya nehago Yesu asaga bonaꞌi: Fegutoga bilo luto enoho lifiꞌehina yabe. Ma lagaso paꞌiya mefiliꞌehibe, ai faꞌmene buꞌi koꞌehibe. Ya noligo asaga boanaꞌmagi Yesuhi kiya yokolo hi eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","To asaga boanaꞌi fegutoga limi su nehago Yesu ana paꞌmofihi hasagu tiloto ana paꞌi yato li saga higo analo meleꞌisi ho tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya higo anana huto hinanamofihi kagaꞌa ana hepalugu bula ola higo asaga bonaꞌmagi keheli baga iꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ana hepaꞌi heꞌmiloto kapo moloto nobigo etubu pisi luꞌehina bo loemaleꞌi megeꞌi lifite nebite ma lite liꞌahaꞌina: Tatatifu Tebitihi panaꞌamaka kai leꞌaliꞌi kiginaga fi leꞌemibo lite kehe iꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ya nelaꞌigo Yesu ai nonuga notigo etali ana bole Yesutoga nehetiꞌahaꞌina yabe. Ya haꞌigo Yesu etoloka hoꞌehina: Letali leꞌeleꞌmo bati hilinaꞌmu yabe lite nanitoga komopatiti nenimiꞌifihe? Etali liꞌahaꞌina: Oꞌyo, Sipi Bo, leꞌali keheliꞌohuꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","To Yesu yatuꞌi etubulo meko huloto lu etimiꞌehina: Letali nanitoga komopatiti nimiꞌahaꞌinago letubutiti bati hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesu ya ligo etubuꞌatiti anaꞌasilo meleꞌisi i gili huꞌehina yabe. Ya higo Yesu etekesa bito ma luto lu etimiꞌehina: Letali yaꞌmana huto nohu letotonamofihi kagaꞌa bonaꞌi lu meepilo. ");
INSERT INTO bef_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Etali bite Yesu hu etotoꞌehina kagaꞌa asaga hepatoga lu epimofaꞌna hiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ana bole nebaꞌigo bonaꞌi lugaꞌamagi negi bo mone foipa feleuba gufagu tigo kaga meluse nominana bo Yesutoga leꞌmete eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ya hago Yesu ana foipa fele li heꞌmi etago ana bouba kaga hapi fito luꞌehina yabe. Ya higo asaga boanaꞌi topa hete enekesa yigi babu lilete ma lite liꞌahana: Koyapaꞌi Isilaeli melugu yaꞌma huseꞌna huto higo bu megoꞌohuta suhi huto hibe, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ya nelago Felosi bonaꞌmagi ma liꞌahana: Ai foipa felemagihi kaba boꞌaniuba amuyana emigo foipa fele li noheꞌmi epalabe, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","To Yesu asaga hepatoga bego humofaꞌna huꞌehina. Ya huloto asaga boanaꞌi mono nohaꞌanigu lu enelepito Huꞌmamofihi ka lamanaꞌa lu noepito to enebesina boanaꞌi eneleꞌmo ye nokoto to enugufagu ketana nina li heꞌmi epolomofaꞌna huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Babu boanaꞌi Yesuhi leꞌmo bego hite minago bu enogoloto Yesu eniginaga fi epiꞌehina yabe. Henaꞌmugope enali enekesa yigi babu lilete bo moneuba meeneheꞌmago sipisipi yaga kaba boꞌani meminago tili tele hite minelata nehana suhi lite minanaꞌmu luto yabe. ");
INSERT INTO bef_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ya huloto Yesu koko pananaꞌa ma luto lu epiꞌehina: Babu noseꞌna foyagu uyaꞌi loto mupa ito ninaya ana noseꞌna li nupa hilana bonaꞌa loeꞌasi nehabe. ");
INSERT INTO bef_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ya huꞌehinagi lenali bite foya afoꞌafihi numuna hi etenogo ai foyaꞌagu ete liliꞌna lite noseꞌnaꞌa li nupa hilana bonaꞌi eneleꞌmo babu lilibe, luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","To Yesu aposolo pananaꞌa nayahaꞌni su hago nigigusaga loemo leheko malago eneleꞌmo nupa huloto foipa felefi to bonaꞌi enugufagu enebesila to ketana nina li heꞌmi epalalabe luto amuyana epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nayahaꞌni su hago nigigusaga loemo leheko malago aposolo panaꞌmagihi enigiꞌani li keheliꞌehina ma luto niꞌibe. Yataꞌa Simoni fato giꞌa Pita, to Atulu ai gonaꞌa yabe. To Yemesi Sepetihi panaꞌa ai Yoni gonaꞌa hiti yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","To Filipi hiti to Batolomu hiti yabe. To Tomasi hiti Matiu hiti etali takisi efahi lilata bole yabe. To Yemesi ai Alifiasihi panaꞌa yabe, to Tatiasi yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","To Simoni ai fato giꞌa Seloti yabe. To Yutasi fato giꞌa Isikelioti, ai Yesuhi miꞌi moloto fatehaꞌamagihi epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nayahaꞌni su hago nigigusaga loemo leheko malago koko panana enoho lifiloto ma kaga lu epiꞌehina: Lenali fegutoga bona nagatoga bite ise megilo. To lenali Samalia bonaꞌmagi hepatoga mebilo. ");
INSERT INTO bef_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lenali Isilaeli nagalugu sipisipi yaga fenene hite nehanalo bilo. ");
INSERT INTO bef_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lenali bite kaga ma lite lu epilo: Kokulumamofihi kapoꞌa anasi aꞌo leba notabe. ");
INSERT INTO bef_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lenali enebesise bonaꞌi eneleꞌmo ye kalo, to filiꞌahana bonaꞌi eneleꞌmo ho tilo, to sipi enehepuhi loꞌehilina bonaꞌi ana enehepuhaꞌani li gololo ti epalalo, to foipa fele li heꞌmi epalalo. Lenali mina melise nelinagi ana hite minaꞌa melise lu nolepuna suhi hi epalalo. ");
INSERT INTO bef_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lenali efa gutini luga li gu meise bilo. ");
INSERT INTO bef_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lenali sisaku gutinifi, guketetini loefi, lenigigusagu sutinifi to fatusatinifi melise lenayapako bilo. To lenali eneleꞌmalana bonaꞌmagi noseꞌna lepilanaꞌmu yabe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","To lenali tauni hepaꞌi ninalofi to lagaso hepaꞌi ninalo nehetiletemo lenali ana hepato bonaꞌi hapaꞌani bu go bati hiletebe. Hiya bo bati bo nohifi to hiya bo bati mehina bo nohifi lite enogo kehelilete hapaꞌa bati huꞌehilina bo be geletemo lenali ana bo hiti nehite fato hepatoga biluneꞌmuko ho tite bilo. ");
INSERT INTO bef_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","To lenali nohi moneluga tiletemo ana nonuga nehilana bonaꞌi lenipagu fuluna mineno lite lu epilete tilo. ");
INSERT INTO bef_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","To yaꞌmana nonuga bonaꞌi bati bonaꞌmo nehinogomo lenali enebe tigite fulunatini epilo. To hapaꞌani bebe mesana bonaꞌmo nehinogomo lenali fulunatini akuꞌi i behe huto lenalitiniloga alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","To hepaꞌi monetotifi to nohi monelugutifi lenebe metiginogomofi to kagatini keheli melepinogomo lenali lenigigusagati mumusopa li tili nehite ana hepaꞌi heꞌmite fato hepatoga bilo. ");
INSERT INTO bef_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nani maꞌnaka luto lu nolepube. Huꞌmau ana boanaꞌi kagaꞌani loko hu epalalina yupapogu Huꞌmau Sotomu hepaꞌi hiti to Gomola hepaꞌi hiti nesiꞌa enahalibe. To leneleꞌmo bati mehilana hepaꞌiya Huꞌmau sipi enoho su halinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lenali kehelilo. Nani lenaliꞌi sipisipi yaga legi huto lopi kalamagihi folagahaꞌanigu lenoho lufube. Ya huꞌehinagi lenali ka keheliya ise osifa legi hite anaꞌina lolo hiluneꞌmu nehitemo yataꞌa lenekesa yigi fe liletebe. To lenali lufu namamofihi hapaꞌa agoyaꞌa nina suhi lite minalo. ");
INSERT INTO bef_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lenali kaba hu bati hilo. Enali bonaꞌi lugaꞌamagi nagaꞌi lepelete ka foya li lepelete enali li nupa hite minelata nehana nonugu leneleꞌmo melete naga osatu lenibi yigilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Enali nani kumu lite lenaliꞌi gamani bonaꞌi hiti to enikibina bona enubulo leneleꞌmo yegelo melete ka foya li lepalalanaꞌmu yabe. To mono ka ana gamani bonaꞌi hiti to fegutoga bonaꞌi hiti lu epilanaꞌmu lite ya hi lepalanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","To ka foyagu leneleꞌmete nebinogomo lenali kaga lilanaꞌmu henabe lilune lite lenekesa yigi to hiyaꞌa huto kaga lilupi lite lenekesa yigi babu melilo. To ana kanaꞌa noenogomo kaga lilana lenabagalo alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ana kaga lilanaya lenalitini melilanaꞌmu yabe, to kokulumaguti Afotinifu ana kaga lenelepilenogo ana kaga lenali lu epilanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bomagi enali enogoꞌanigihi ka foyagu eneleꞌme melete enoho fililanaꞌmu yabe. To afoꞌafu panaꞌamofihi ana suhi luto ho fililinaꞌmu yabe. To pananaꞌanimagi afoꞌanigihi ana hite fatehaꞌani eneleꞌmo lolo hite enoho fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","To anaga bonaꞌmagi lenipakafa halanaꞌmu yabe. Henaꞌmugope lenali nani yagapanaꞌni minanaꞌmu lite yabe. Ya huꞌehina to bo moneuba amuya moloto minomo buto bonaꞌi guna ise kanaꞌalo minalina Huꞌmau akuꞌi leꞌmenogo ana bo ai Huꞌmamofihi panaꞌa minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","To mone hepatoti lenehenogomo lenali ana hepaꞌi heꞌmite hololu lite fato hepatoga bilo. Nani maꞌnaka luto lu nolepube. Lenali asaga Isilaeli hepalugu bite liliꞌna li baga meiꞌehinogo nani akuꞌi alunaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","To sukulu panaꞌi moneuba tisa boꞌamofihi mone be ligito meminolata nohibe. To koko panaꞌuba kaba boꞌamofihi be ligito meminolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","To sukulu panaꞌuba tisa boꞌa lolo hilina bati huto niꞌibe. To koko panaꞌuba sipi boꞌa lolo huto minalina bati huto niꞌibe. Nani afotinifita enali foipa felemofihi giꞌa Bielesebulu nanitoga meleꞌahana suhi hite lenaliꞌi ana hite babu lite foipa lenigi halanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ya huꞌehinagi lenali bonaꞌi koli mehi epalalo. Asagaꞌna fenene huto ninana alihi huto hi su halanaꞌmu yabe. To asagaꞌna ifi toto fala kito ninana kugumatogago huto hinogo enali bonaꞌmagi bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kaga nani sininugu lu nolepuna lenali yegelo lu epilo. To kaga fulu huto lenalitinigo lu nolepuna lenali nohi latahaꞌalo ho tiꞌehite lu yege he epilo. ");
INSERT INTO bef_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma melugu lenugufaꞌa lenoho fililafa to lenemehatini hiti lenoho mefililana bona kumuꞌi koli mehilo. Lenali Huꞌmau ai lenugufatini hiti to lenemehatini hiti loe sana sana sipi logo kapogu lenoho fililina bomofihi ai kumukoꞌi koli hi etete minalo. ");
INSERT INTO bef_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Enali nama lagasoꞌasi loemo moneko toealoti mina filata nehabe. Ya huꞌehina Afotinifihi lagaꞌa mebesilina to nama lagasoꞌa moneꞌmofihi suhi luto meluguꞌi limo meilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","To lenaliꞌiya latahatinigu nina okatiniya aleka so su hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ya huꞌehinagi lenali koli mehilo. Lenaliya lagaso nama babu lite nehanamagihi minaꞌani enebe ligite nehabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bo moneuba Yesuhi panaꞌi nohube luto lu yege homofaꞌna hilina nani alihi ana huto Afoꞌnifu kokulumalugu nohinamofihi buloꞌi giꞌa lu yege halunaꞌmu yabe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","To mone bouba Yesuhi panaꞌa menohube luto nigiꞌni li fala kito minalina nani ana huto ai giꞌa Afoꞌnifu kokulumalugu nohina bomofihi bulo li fala kilunaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma melugu luba mehilo luto leneleꞌmo baba ilubeꞌmu oꞌehibe lite nani kumuꞌi melilo. Nani luba bonaꞌi leneleꞌmo baba ilubeꞌmu meoꞌohunaya kosa kosa emitaꞌi lito ma melugu limiꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nani fatehena li huto hilube luto limiꞌohube. Bouba afoꞌafihi leꞌmo fatehaꞌa lolo hilinaꞌmu yabe, paꞌanimagi itoꞌanigihi fatehaꞌani eneleꞌmo lolo hilanaꞌmu yabe, to aꞌuba bahaꞌamofihi itoꞌafihi fatehaꞌa leꞌmo lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bomofihi fatehaꞌa manaꞌiya ai lalamehaꞌa minalanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Bo moneuba itoꞌafinogo afoꞌafinogo eteleꞌmo bati nohuto naniꞌi neleꞌmo bati mehilina bo ai naniꞌi nalaluꞌnifu legi huto meminalinaꞌmu yabe. To bo moneuba lihaꞌa yagapanaꞌa eneleꞌmo bati huloto naniꞌi neleꞌmo bati mehilina bo ai naniꞌi nalaluꞌnifu legi huto meminalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","To bo moneuba malipu yafaꞌa lito kofiloto nemegeꞌi memalalinauba ai nani nalaluꞌnifu lolo mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bo moneuba gufaꞌa leꞌmo bati huto minalina ai mehaꞌa heꞌmi mana hilinaꞌmu yabe. To mone bouba nani kumu luto gufaꞌa heꞌmi yakalesa hilinauba ai mehaꞌa li buto bilinaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Bo moneubafi moneuba lenebe tigilinaya naniꞌi nebe tigilinaꞌmu yabe. To naniꞌi nebe tigilina bonaꞌiya ai noho lifigo limiꞌohuna bomofihi be tigilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","To bo moneuba Huꞌmamofihi kaꞌa leliꞌali nohina bo noago bu goloto heꞌmalube luto ekesa kehelito nohaꞌaluga leꞌmoto buto noseꞌna emito kaba hu etalina ai yaꞌmana bouba lu huto huto bomofihi suhi lito minaꞌa lilinaꞌmu yabe. To bo mone hapaꞌa bebe sana bo noenogo bu goloto ana bo heꞌmalube luto luloto leꞌmoto buto nohaꞌagu kaba batiꞌa hu etalina bo ai minaꞌa bati huto hapaꞌa bebe sana bouba lilinaꞌa huto lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","To bo moneuba fatoga boanaꞌi neago bu enogolotoꞌa: Akae, ma boanaꞌi Yesuhi nagaꞌamo nehanago eneheꞌmalube luto ekesa kehelito yatipa nagamiꞌi konugu hefito epi fulu hilina boya maꞌnaka luto lu lepube. Ai ana bouba minaꞌa liba liba hilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu nayahaꞌni su hago nigigusaga loemo leheko malago koko panaꞌamagi liliꞌna lilana kaga alu epi su holoto ana hepaꞌi heꞌmito ana kegiꞌa hepaꞌi nila nila huꞌehinalo bula ola huto boanaꞌi kaga lu enelepito to hetofa kaga lu yege homofaꞌna huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","To Yoniu ai nagami folo epolose bo nagaꞌi emiꞌahago nohuto asaga liliꞌna Yesu nolinamofihi kaꞌa keheliloto koko panaꞌa enoho lifigo Yesutoga eꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ya hilete ma lite Yesuhi loka heꞌahana: Kaiba Yoniu alane luto luꞌehina bomo nohapi, fato bo geba hiluta niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ya lago Yesu kaꞌanilo lu epiꞌehina: Lenali i behe hite bite Yonihi sipi liliꞌna li huto nohugo be enaganamofihi hapaꞌa lu emilo. ");
INSERT INTO bef_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Enali enubu pisi lina bonaꞌi akuꞌi enubuꞌani i gili higo asagaꞌna bu negabe. To enigi enayahi sibina huꞌehina bonaꞌi kapo malabe. To ililogo bonaꞌi eneleꞌmo gololo tugo babe. To enekesa hekini lana bonaꞌi enekesa li hokolo hugo kaga kehelite babe. To filiꞌahana bonaꞌi akuꞌi ho ti kosaba habe. To feꞌnohaꞌani menina boanaꞌi ka lamanaꞌa kehelibe. ");
INSERT INTO bef_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","To bo moneuba nani kumuꞌi ekesa yigi yigi huto Huꞌmamofihi panaꞌa nohifi fato bo nohifi yaꞌma meluse akuꞌi nanitoga komopaꞌa nimilina bo ai gelo bino. ");
INSERT INTO bef_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ya luto Yesu kaga lu su holago Yonihi koko panaꞌa abilago Yesu Yoni kumu kaga babu boanaꞌi lu epiꞌehina: Koyapaꞌi lenali bonaꞌi menehana kamelugu biꞌahana henana bu galune lite biꞌahanabe? To lenali akepa moneꞌmofihi habafahuba li pisi huꞌehina bu galune litefihe? ");
INSERT INTO bef_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","To lenali henana bu galune lite biꞌahanabe? To lenali bo moneuba hetofa gukete li hekoloto nohinogo bu galune lite biꞌahanafihe? Nani lu nolepube. Enali bonaꞌi hetofa gukete li hekelete to hetofana enugufalo li melete neminana bonaꞌiya enali sipi kibina bomofihi nohaꞌagu minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya huꞌehina lenali hena hibe lite biꞌahanabe? Lenali henana bu galune lite biꞌahanabe? To lu huto huto bo bu galune lite biꞌahanafihe? Oꞌyo nani lu nolepube. Ai lusi mono bo yabe. To ai asaga mono bonaꞌi lugaꞌa enohoto nohibe. ");
INSERT INTO bef_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yaꞌmana bo Yoni kumu luto mono kagu ma luto lulata nohina yabe: Mono kaꞌni leliꞌali boꞌni yaꞌma nohibe luto Huꞌma luꞌehina yabe. To nani yataꞌa aleꞌmo heꞌminogoꞌni ai buto kapo li hokolo hu ketalibe. ");
INSERT INTO bef_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu kaga molo emito luꞌehina: Nani maꞌnaka luto lu nolepube. Yoni ai nagami folo epolose bouba asaga bonaꞌi ma melugu nehana enohoto nohibe. Ya huꞌehina bo mone Huꞌmamofihi kapolo lagaso huto nohilinauba ai Yonihi be ligito nohibe. ");
INSERT INTO bef_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoni huto hina kanaloti minomo tito yaloꞌi kanaꞌalo ago luba nehana bonaꞌmagi kokulumamofihi kapoꞌa li heꞌmiluneꞌmu nehite luba hiba hiba hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Asaga lu yege hose bonaꞌi kaga hiti keya ka hite Huꞌmamofihi Kapoꞌamofihi kaꞌa Yoniu huto hina kanaꞌaloti moneka huto hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","To lenali keheli bati hilunemoꞌmu keheli bati hilo. Yoniu aiꞌya Elaiyau yabe, ai yaꞌmana bo alibe luto luꞌohuta bo yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ai ekesaꞌa niꞌilina bouba keheli bati hino. ");
INSERT INTO bef_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yatai kanalo boanaꞌi henanalo lu malalube? Enali yagapanaꞌi hepaꞌi folagahaꞌagu luga filete nehite lugaꞌa yagapanaꞌi kehe ite ma lite lu epilata nehana suhi lite nehabe: ");
INSERT INTO bef_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Lali folonemeyahi fu lu lepolotamo lenali nama lilana suhi hite melekehi ite memineꞌahabe. To lali eniginaga fise suhi huto yibi nama hutamo enali yibi hilana suhi hite memineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yoniu oꞌehina ai noseꞌna nola to bai nagamiꞌi nola mehuꞌehina yabe. Ya nohigo lenali ma lite liꞌahana yabe: Foipa fele ai komopaꞌagu niꞌibe lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","To yatai Kokulumaguti limiꞌehina Bouba oloto noseꞌna noto nagamiꞌi noto nohigo to lenali ma lite neli etabe: Bu galo. Ai noseꞌna lauꞌi iba iba bo yabe nelabe. To bai nagamiꞌi ana huto babu luto noba noba bo yabe lite nelabe. To ai takisi nelina bo to foipa bonaꞌmagihi enalaluꞌanifu yabe lite lilata nehabe. To yaꞌmananalo bu golototi Huꞌmamofihi keheli bati huseꞌnaꞌa maꞌnaka niꞌibe luto lilutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hepaꞌi lugaꞌaga Yesu topa hoseꞌna li hu enebe liꞌehinalo bonaꞌmagi komopaꞌani i gelehe mehiꞌahana yabe. Ya hiꞌahago yaꞌma kanalo Yesu ka epekito minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ai luꞌehina: Ke, Kolasini bonaꞌise. Ke, lenali Betesaita bonaꞌise. Lenalitoga babeyafana li huto nohunana enali Taiya bonaꞌi hiti Saitoni bonaꞌi hiti enalitoga li huto hutita enali meleꞌisi melugu mino laba hite gebona gukete li hekelete lahi enugufalo felete eniginaga foipanaꞌanimuꞌi finogo nehinogo ya bu goto foipanaꞌanimoꞌmu nehabe luto huto hulata nohinagi lenali komopatini i gelehe mehiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lenali kehelilo. Meꞌi su halina kanaꞌa to ka foya lilina yupahi Huꞌmau Taiya bonaꞌi hiti Saitoni bonaꞌi hiti enalitoga babu lito keta mehu etalinaya lenalitoga sipi keta besilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","To lenali Kapaneami bonaꞌise. Lenalitini kokulumalugu li saga hite tilana niꞌifihe? Logo kapogu limilanaꞌmu yabe. To topa hoseꞌna lenalilugu li huto huꞌohunana Sotomu hepalugu li huto hutita yatai hiti analo huto huba huba nohititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","To ka foya sipina yupahi Huꞌmau Sotomu bonaꞌi babu luto kekeꞌi lu epalalinaya to lenaliꞌi loeꞌasi kekeꞌi lu lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yaꞌmana yupahi Yesu ma luto luꞌehina: Oho. Afoꞌniga, kokulumaꞌi hiti meꞌi hiti sipi kaba boꞌa nohane. Kai anaꞌinaka kehelise bonaꞌmagihi enubulo li fala nokito to kai lagaso yagapanaꞌmagihi enubulo li huto hulata nohataꞌmu nani kofokehi lito bati huto yabe luto kegepohi nolube. ");
INSERT INTO bef_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oꞌyo, Afoꞌniga kaika luꞌahatalo ana suhi ana suhi fato fatoꞌi huto hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nani afoꞌnifu asagaꞌna nani nayanuguko moloꞌehibe. Bo moneuba Huꞌmamofihi panaꞌa nohibe luto mekeheliꞌehina. Afoꞌnifu aisigo keheliꞌehibe. To bo moneuba Huꞌmamofihi ai nohibe luto mekeheliꞌehina, Panaꞌa aisigo keheliꞌohuto ai Panaꞌauba Afoꞌafihi enelepito kaga lu epina bonaꞌi enali ana hite Huꞌma nohibe lite kehelilata nehabe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Lenali ketana kofilete ketatiniꞌmu koseleꞌise bonaꞌi nanitoga ete lenabasu bilo. ");
INSERT INTO bef_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yaꞌma yafa nani nigiꞌnagu nina lenali lite lenali lenigiꞌnagu malalo. Lenali nani hapaꞌni lilo. Henaꞌmugope nani fulu fulu kaga bonaꞌi lu noepuna bo nohube. To koyone huto legeso huto nominona bo nohube. To lenali komopatinimofihi nanitoga ete leꞌmo basu bilo. ");
INSERT INTO bef_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yaꞌma ketana lenigiꞌnagu nomolo lepolonanaya hetofana niꞌibe. To anaꞌina kofilabe luto nani nolepunanaya keta mehina baba hana niꞌibe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Alihi fuli kana monelugu Yesu noseꞌna foya folagahaꞌagu kapo moloto buꞌehina. Ya nohigo koko pananaꞌa megeꞌi nebanati kauꞌna enahago legeyaꞌa nesiꞌasi tegete nohaꞌa li neheꞌmite manaꞌa nete nebabe. Ana noseꞌna laisi tegina nina ligite neꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","To Felosi bonaꞌi lugaꞌamagi ya hanana be gelete ma liꞌahana: Fuli kanagu oꞌe lite liꞌahana supo lenali henaꞌmu ya nehabe? ");
INSERT INTO bef_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ya lago Yesu lu epiꞌehina: To lenali Tebitiu huꞌehinamofihi fayahaꞌa leka sete mekeheliꞌahafihe? Tebitiu laluꞌagi hiti sipi kauꞌna enohoꞌehinamoꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ya nohigo ai Huꞌmamofihi nohaꞌagu tiloto Huꞌmamofihi bulo niꞌina beleti noseꞌna litoꞌa nonoto laluꞌagi megeꞌi ana noepito neꞌahana yabe. To yaꞌmana beleti mono bonaꞌmagigo nelata nehabe. To fato fato bonaꞌi menalabe. To ya huꞌehinamofihi kaꞌa leka sete mekeheliꞌahafihe? ");
INSERT INTO bef_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","To lenali Mosehi ka foya bukuꞌagu nina mono kamoba leka sete mekeheliꞌahafihe? Asaga fuli kanaꞌagu mono noto kaba hiꞌahana bomagi fuli kanaꞌalo yaꞌma keya ka li gofa helata hiꞌahana to enali bati mehina suhi mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nani lu nolepube. Anaꞌina mone niꞌinaubaya mono nohi be ligito niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ya huꞌehina lenali ma mono kaga keheli bati hite keheli fe lilana: Nani yagakafa heꞌahananamagi nimitogo menebesibe. Nani fulu huto minoseꞌnamuꞌi nebesibe. Yalo lenali ketana lite bati mehina suhi mehilata nehana bonaꞌi enalitoga ligo mefi epalalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kokulumaguti limiꞌehina Bouba ai fuli kanamofihi sipi kaba boꞌa nohibe. ");
INSERT INTO bef_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu hepaꞌi heꞌmiloto buto li gehesa hite minelata nehana nohaꞌanigu tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","To bo mone yahaꞌa sibina huꞌehina bo anagu minoꞌehina. To Yesu hilina hapaꞌa li kuguma hu etalune lite bonaꞌi lugaꞌamagi mapahi fite ana nonuga mineꞌahana yabe. Enali loka heꞌahana: Fuli kanaguꞌi enebesiꞌehina bonaꞌi eneleꞌmo bati huseꞌiba bati huto niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kaꞌanilo lu epiꞌehina: Mone bomaka sipisipi yagaka fuli kanagu keligu limiꞌehilina hena hilata niꞌibe? To ana keliguti gufalo lito leꞌmo lago metilata niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","To bouba sipisipi yaga be ligito nohibe. Ya huꞌehinagi fuli kanagu bonaꞌi eneleꞌmo bati hilo luto keya kagatiuba nolibe. ");
INSERT INTO bef_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ya luloto yahaꞌa sibina huꞌehina bo ma luto lu emiꞌehina: Kayaha li su tobo. Ya ligo ana bouba yahaꞌa li su tago mone kegiꞌa yahaꞌauba huꞌehinaꞌa huto bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ya higo enali Felosi bonaꞌi heleko limite bite li nupa hilete Yesuhi halune lite kaga lu keheli fa keheli hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu ana kagaꞌani akeheliloto ana hepaꞌi heꞌmiloto nobigo babu bonaꞌi megeꞌi lifite biꞌahana yabe. Ya nehago enebesiꞌehinanaꞌani li heꞌmi su ho epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ya nohuto ana bonaꞌi enekesa biloto lenali nani kumuꞌi bonaꞌi lu meepilo luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","To kaga mone lu huto huto bo Aisaiyau ma luto luꞌehina kagauba legeyaꞌa huto hilinaꞌmu yabe: ");
INSERT INTO bef_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yaꞌma liliꞌnalo boꞌni nohibe luto Huꞌma luꞌehina, ai naniꞌni leꞌmo ho notube. Ai nebesina bo nohigo ai kumuꞌi nipagu bati hulata nohina panaꞌni yabe. Nani Sikalafuꞌni aitoga malalunaꞌmu yabe, to ai fato nagaꞌmagitoga hetofanaguti minosemofihi kagu lu epimofaꞌna hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ai bonaꞌi ka epekito enubunepa ito mehilinaꞌmu yabe. To sipi kapoguti kehe kehe ito kaga nolinogo nogoꞌa mekehelilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","To akepa mone i pisi huꞌehilina ai li gofa mehilinaꞌmu yabe. To logo mone loloto yuhufa sabalubeꞌmu nohilina ai li sobo su mehalinaꞌmu yabe. Ai liliꞌna liba liba huto nohuto mino fe luseꞌnamofihi be ligilotoꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","To asaga bonaꞌi aitogago komopaꞌani molo emite minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bonaꞌi lugaꞌamagi bo mone buꞌa pisi ligo kaga meluse nominana bo leꞌmete Yesutoga eꞌahana yabe. Henaꞌmugope foipa fele aitoga niꞌigo yabe. Yesu ana bo leꞌmo bati higo buꞌa i gili hula to kaga lula huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ya higo enali leꞌmo bego hite babu boanaꞌi minanamagi be gelete topa helete ma lite liꞌahana: Yaꞌma boba Tebitihi panaꞌmouba nohifi fato bobe? ");
INSERT INTO bef_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ya nelago Felosi bonaꞌmagi kehelilete ma lite liꞌahana: Ai foipa fele li noheꞌmi epalanaya foipa felemagihi sipi boꞌani Bielesebulu amuya emiꞌehigo nohibe. ");
INSERT INTO bef_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kaga lu keheli fa keheli enali nehana kagaꞌani Yesu akeheliloto ma luto lu epiꞌehina: Hepaꞌi lugaꞌa enaliꞌaniguti loko luku hilete luba hilata nehana yatamalo luba hite minelata menehabe. To hepaꞌi moneꞌmagifi to lalamehe nagaꞌi moneꞌmagi loko hilete luba hilata nehana enali yaꞌmana hepaꞌifi to lalamehe nagaꞌifi mino bati hite meminalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To Satau ai fato foipa felemofihi leꞌmo heꞌmilina ai nagaꞌa enali aloko nehabe. Ya hinogo Satahi hepa kapoꞌa hena huto amuya moloto minalina niꞌibe? Enali amuya melete enigi binogo meminalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lenali nani kumuꞌi Bielesebulu amuya nimigo foipa fele li heꞌmi heꞌmi nohibe lite nelafihe? To yagapanatinimagihi kuyuꞌafu eneheꞌmoto amuya epigo foipa fele hesi heꞌmilata nehabe? Ya hiꞌehite enaliꞌani yasi bo lolo hite nehite yaꞌmana kagatini loko hite kehelilabe. ");
INSERT INTO bef_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ai Huꞌmamofihi Sikalafuꞌauba amuya nimigo foipa fele hesi noheꞌmi nogoꞌnimo lenali Huꞌmamofihi kapoꞌa lalitoga aꞌo leba notanagi lite kehelilabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bonaꞌi enali amuya bomofihi nohaꞌaguti tite feꞌnohaꞌa bu goꞌehigo lilata menehabe. Enali ana bo gilo yato naga ilete yato nohaꞌagu tite silaga feꞌnohaꞌa lilanaꞌa huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Bo moneuba nanitoga komopaꞌa nimito meminalina ai nani fatehaꞌni nohibe. Bo moneuba naniꞌi neheꞌmoto sipisipi yaga eneleꞌmo tulu menohina aiꞌya ana sipisipi yaga eneleꞌmo tili tele nohibe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yaꞌma kaꞌmu luto nani lu nolepube. Asaga foipanafi to bona enemegeka boanaꞌmagi lilata nehana Huꞌmau ana foipanaꞌani li heꞌmilinaꞌmu yabe. Ya hilinaya to mone bouba Sikalafuꞌmofihi megeka luto kaga emekilina foipanaꞌa Huꞌmau li meheꞌmi etalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","To mone bouba Huꞌmamofihi panaꞌamofihi kaga foipa lu etalinaya Huꞌmau ana foipanaꞌa li heꞌmi etalinaꞌmu yabe. Ya hilinaya bo moneuba Sikalafuꞌmofihi kaga foipaꞌa lu etalinaya ana foipanaꞌa Huꞌmau li meheꞌmi etalinaꞌmu yabe. Yatai hiti alihaꞌa yupa hiti ana sunogo hilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","To yafa moneuba bati huto mesebe lele tele huto tiloto legeyaꞌa bati huto sipina holata nohibe. To numutopa loto tilata nohina yafauba legeyaꞌa ana huto ho foipa lolata nohibe. To bonaꞌmagi yafa legeyaꞌalo belelete be gelete ya yafaya bati huto notinagi lila to numutopa loto notinagi lila hite li kehelilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lenali foipa osifaꞌmofihi yagapanaꞌa nehabe. Lenaliba hena hite bati ka lilanaꞌa huto niꞌibe? Lenali foipa bonaꞌi yabe. Asaga foipa foipa kaga bomofihi komopaꞌagu bai toto nina kagaꞌa ai bagaꞌaloti huto hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To hetofa bomofihi komopaꞌagu kaga batiꞌa babu luto minolata nohibe. Ya huꞌehigo ai hetofa sunogo hulata nohibe. To foipa bonaꞌmagi komopaꞌanigu kaga foipa faipaꞌa bai toto niꞌigo foipa faipaꞌi suhi babu lite li huto hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ya huꞌehinagi nani lu lepilube. Asaga kaga boanaꞌmagi lilata nehana kagaꞌanilo alihi Huꞌmau boanaꞌi eneleꞌmo fato fato hilina yupahi enoloka halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaika luꞌehilata kagakaloꞌmu Huꞌmau bati bo nohane luto kigi molola foipa bo nohane luto kigi molola hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","To Mosehi keya kaꞌmu tisa bo hiti Felosi bonaꞌi lugaꞌamagi liꞌahana: Tisao, topa hose foyaka mone li huto hitogo bu galune. ");
INSERT INTO bef_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ya lago Yesu enali kagaꞌanilo lu epiꞌehina: Lenali yatai boanaꞌise, lenali bati mehana foipa boanaꞌi nehabe. Lenali topa hoseꞌna li huto hubo nelanaya lito mehilunaꞌmu yabe. To moneko yaꞌma koyapa lu huto huto bo Yonaha topa hoseꞌnamo li huto hinogoꞌni bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonau loegi monegi yege hiti sinihi hiti fayaꞌmofihi komopaꞌagu koꞌehinaꞌa huto Kokulumaguti limiꞌehina Bouba yege loegi monegi hiti sinihi loegi monegi ana suhi huto ma meꞌi komopaꞌagu kalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Alihi Huꞌmau sipi ka foya lilina yupahi Nineba bonaꞌmagi ho tilete lenaliꞌi ka lepekilanaꞌmu yabe. Henaꞌmugope Yonau kaga enalitoga lu epigo kehelilete komopaꞌani i gelehe hi su heꞌahabe. To moneꞌna Yonahi be ligito ma niꞌina lu lepilube. ");
INSERT INTO bef_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","To Huꞌmau ka foya lilina yupahi sipi aꞌi mone gihiti aꞌi yabe lilata nehana aꞌmouba ai koyapaꞌi sofo kegiꞌa oloto lenali hapatini li yege halinaꞌmu yabe. Henaꞌmugope ai asaga meꞌi folagahaꞌaga buba buba huto Solomonihi hetofa kagaꞌa kehelimofaꞌna huꞌehinaꞌmu yabe. Nani lu nolepube, maloꞌi kene moneuba yaꞌmanaꞌma Solomonihi hoto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Foipa feleuba bonaꞌmagi enugufaguti heleko nolimitomo ai ka meꞌi niꞌilinalo mino fulu hilina hepa kumu sa sa hulata nohibe. To ana foipa feleuba mino fulu hilina hepaꞌi bu megotomo ai gufaꞌagu ma luto lulata nohibe: ");
INSERT INTO bef_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nani heꞌmito oꞌohuna nohaꞌnigu akuꞌi bilube luto ekesa yigilata nohibe. Ya luto ekesa yigiloto i behe huto heꞌmito oꞌehina nohaꞌa leꞌmo bati hago gulu gulu luto niꞌigo ana foipa feleuba bu golata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","To ya huto niꞌigo ana nohaꞌa bu goloto ai akuꞌi ana nohaꞌaguti heleko limito buto sebeniꞌa foipa fele eneleꞌmoto ago ana nohaꞌagu minelata nehabe. Koyapaꞌi ana bo nesiꞌa bati huto minolata hinamo yatai babu foipa fele ete ai gufagu bai tago ana bomoya foipa loto bati mehulata nohibe. To akuꞌi su holotomo ema afetogati hapi fito tilata nohibe. Yatai kanalo foipa bonatoga yaꞌma suhi luto huto hilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu babu boanaꞌi kaga lu epito nohigo itoꞌafi hiti gonaꞌa hiti aitoga eꞌahana. Bonaꞌmagi Yesuhi leꞌmo bego hiꞌahago enali enemegesaga nehite Yesuhi kaga lu emiluneꞌmu nohune lite bonaꞌi enoloka heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ya lago mone bouba ma luto Yesuhi lu emiꞌehina: Itokafi hiti kogonaka hiti kaga li kimiluneꞌmu ema fegutoga ho tiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya ligo Yesu luꞌehina: Kiyiꞌafu itoꞌnifu nohibe? Kiyigi nogonaꞌni nehabe? ");
INSERT INTO bef_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ya luloto Yesu koko panaꞌamagi nehanalo bu goloto enali kumu luꞌehina: Lenali bu galo. Itoꞌnigi to nogonaꞌni ma li nupa hite nehabe. ");
INSERT INTO bef_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kokulumalugu Afoꞌnifu nohinamofihi agoya hu emise bonaꞌiya nani nogonaꞌni netaliꞌnigi to nani itoꞌnigi nehabe. Ya luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana yupahi Yesu ana nohi heꞌmiloto nagami hefuhu beletoga buto metoga minoloto boanaꞌi kaga enelepilubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ya nohigo babu boanaꞌi ete leꞌmo bego hiꞌahana yabe. Ya hago ai boti monelugu tito minago asaga boanaꞌi enali hefuhu beletoga keheto ho tilete mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","To Yesu babu bame ka ma luto lu epiꞌehina: Bo mone minoꞌehina ai foyaꞌagu noseꞌna legeyaꞌa tili hilubeꞌmu buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ai ana noseꞌna legeyaꞌa tili humo nobigo lugaꞌa kapogu limo koko huꞌehigo namamagi ete fite neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","To lugaꞌa noseꞌna legeyaꞌa meꞌi nesiꞌasi niꞌito efahubago huꞌehinagu limo koko huꞌehina yabe. Ya hina noseꞌna legeyaꞌamagi meleꞌisi belete tiꞌahana yabe, to henaꞌmugope meꞌi keta huto meniꞌigo yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ya higo analo yege lo malago ana noseꞌna yegeuba lo hosopa noibe, henaꞌmugope lufusaꞌa meꞌi emaꞌalo melimiꞌohuto yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","To noseꞌna legeyaꞌa lugaꞌa ufehe naga yafamagihi folagahaꞌanigu limo iloto tilata nehabe. Ya nehana enali ufehe yafamagi yamuꞌi gite ifi telata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","To lugaꞌa noseꞌna legeyaꞌa enali meꞌi foba huto nogoya hina melugu limo ilata nehabe. Ya hite tilete, enali legeyaꞌa bati hite helata nehabe. Lugaꞌamagi babu lite yafa ho figi gite legeya helata nehabe, lugaꞌa nesi bati hite helata nehabe, to lugaꞌamagi loefi monefi hite helata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ya luto lu epiloto Yesu luꞌehina: Lenali lenekesa niꞌinogomo keheli bati hite kehelilo. ");
INSERT INTO bef_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","To Yesuhi koko pananaꞌa Yesutoga ete ma lite loka heꞌahana: Henabe luto kai boanaꞌmagihi bame kaguti kaga lu noepine? ");
INSERT INTO bef_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya nelago Yesu lu epiꞌehina: Nani Huꞌmamofihi Kapoꞌamofihi suguna ka yamofihi hapaꞌa lu hokolo hu lepoloꞌohuna to lenali yaꞌma kagaya keheliꞌahabe. Akuꞌi enaliꞌi yaꞌma kamofihi meenelepise nohugo mekeheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bo moneuba anaꞌina liꞌehilinaya Huꞌmau moneꞌa hiti molo eminogo li babu luto lilata hilinaꞌmu yabe. To bo moneuba anaꞌina yanuga meliꞌehilina koyapaꞌi liꞌehilinana minigilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bame ka nolunamofihi hapaꞌaya yaꞌma hilata nehana kaꞌmu luto nolube. Enali enubuꞌanituꞌi gili gili nehanaya anaꞌina manaꞌa bu go fiya ite bu gelata menehabe. To enekesaꞌanituꞌi kaga kehelilata nehanaya enali keheli fiya ite enekesa yigi bati hilata menehabe. ");
INSERT INTO bef_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ma boanatoꞌi lu huto huto bo Aisaiyau kaga mone luꞌehinauba noseꞌna legeyaꞌa li huto nohibe. Ai ma luto luꞌehina yabe: Lenali kaga kehelilanaya ana kaga hapaꞌa keheli fe melilanaꞌmu yabe. Lenali lenubutu gili gili hilanaya ananamofihi manaꞌa bu go fiya ite bu megalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma bonaꞌmagihi komopaꞌani hekini loto niꞌibe, ya huꞌehigo enekesaꞌaniuba kaga kehelilinaꞌmu koseleꞌi ahoꞌehibe. To enali enekesaꞌani negi no su hoꞌehibe. Ya huꞌehigo enubuꞌaniuba anaꞌina bu megalinaꞌmu yabe, to enekesaꞌaniuba kaga mekehelilinaꞌmu yabe, to latahaꞌaniguti kaga manaꞌa keheli fe melilanaꞌmu yabe. To enali nanitoga leleꞌmo bati hilibe lite i behe hite enogo nani eneleꞌmo bati hilunaꞌmu yabe, luto Huꞌmau luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ya huꞌehinaya lenali lenegelo bilo. Lenubutiniuba anaꞌina bu galibe. Lenekesatiniuba kaga kehelilibe. ");
INSERT INTO bef_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nani maꞌnaka luto lu nolepube. Koyapaꞌi babu lu huto huto bonaꞌi hiti to komopaꞌanigu bati hina bonaꞌmagi yaꞌma yatai lenali bu neganana bu galune lite hiꞌahanaya enali bu megeꞌahana yabe. To lenali yatai nekehelina kaga kehelilune lite hiꞌahanaya mekeheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bo moneuba noseꞌna legeyaꞌa foyaꞌagu tili nohinamofihi bame ka hapaꞌa lenali kehelilete ana bame kaloti manaꞌa lilo. ");
INSERT INTO bef_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Asaga bonaꞌi enali hetofa kaga kehelilete enali enekesa yigi bati menehana Satau hololu luto enalitoga nehetiloto enalilugu Huꞌma hetofa kaga nohekalana komopaꞌaniguti li heꞌmilata nohibe. Yaꞌmamofihiya ai noseꞌna legeyaꞌa kapogu limo koko nohinamofihi hapaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","To noseꞌna legeyaꞌa lugaꞌa efahubago hinagu limo ilata nohibe, ya nohina suhiya bo moneuba kaga keheliloto ai meleꞌisi lito gelo bilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ya huꞌehina ai lufusaꞌa meꞌi komopaꞌalo mebuꞌehibe. Ya huꞌehigo ai nesi kanasi minoto hosopa ilata nohibe. Alihi bonaꞌi lugaꞌamagi Huꞌmamofihi kagaꞌa lu sibina hiluneꞌmu hilete enali ana bomofihi ketana li kofi etete foipana suhi babu lite li huto hi etalanaꞌmu yabe. Ya hinogo ana bomofihi hetofa kaga kehelito minoseꞌnaꞌa meleꞌisi heꞌmi etolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","To noseꞌna legeyaꞌa ufehe yamuꞌubago hinagu limo ito notinamoya ma huto niꞌibe. Bo moneuba mono ka kehelilago ma melugu faga efaha feꞌnohuba loe lae hu etoto keta besigo ai ana bomofinuguti maꞌnaka legeyaꞌa huto hulata menohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","To noseꞌna legeyaꞌa meꞌi bati huto gilibaꞌa hiti meꞌi ninagu limo ilata nohinamoya ma huto niꞌibe. Bo moneuba mono ka keheliloto ekesa yigi bati huꞌehina supo huto ai noseꞌnaꞌa samahi tito li huto hulata nohinaꞌa niꞌigo to bo moneuba babu lito li huto hulata nohinaꞌa niꞌigo to bo moneuba nesiꞌasi lito li huto hulata niꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu bame ka mone fatoꞌi ma luto lu epiꞌehina: Bo moneuba noseꞌna legeyaꞌa batiꞌa foyaꞌagu tili nohinaꞌa huto Huꞌmamofihi kapoꞌaya niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ya huꞌehina mone sininugu asaga boanaꞌi enubuꞌi ke su heꞌahago bo moneuba kifina legeyaꞌa lito oto ana fatehaꞌa bomofihi foyaꞌa folagahaꞌagu tili huloto bu fa nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","To alihi ana noseꞌna foyaꞌagu nina noseꞌna aꞌnose huto niꞌigo buto bu gana ana foipa kifina hiti notigo bu goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","To ana foyamofihi afoꞌafihi liliꞌnalo boꞌamagi be gelete bite ma lite lu emiꞌahana: Sipi bo, kai noseꞌna legeyaꞌa manaꞌi hekoloꞌahapi luto lutamoba hena huꞌahanogo foipa kifina foyakagu noligibe? ");
INSERT INTO bef_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ya lago ai lu epiꞌehina: Enali fatehaꞌnimagi hiꞌahabe luꞌehina. Ya ligo enali liꞌahana, bite ana foipa kifiꞌna su ti heꞌmilo luto nokehelipi henabe luto nokeheline? ");
INSERT INTO bef_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ya lite loka hago ai foya afoꞌafu luꞌehina: Oꞌe. Lenali foipa kifiꞌna bite li su ti heꞌmilanaga noseꞌna hite li su tilanaꞌmu yagi mebilo. ");
INSERT INTO bef_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kifiꞌna hiti noseꞌna hiti anagu heꞌminogo sibi sibi hite tilenogo alihi noseꞌna li nupa hiluta yupahi li gehe lilune. To nani ma luto lu lepilunaꞌmu yabe. Liliꞌnalo panaꞌni, lenali foipa kifiꞌna li nupa hite sa gilo. Lali logogu galutaꞌmu yabe. To noseꞌnaꞌaya li nupa hite nohaꞌniluga malalo luto lu lepilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu fato bame ka mone ma luto lu epiꞌehina: Kokulumamofihi kapoꞌaya noseꞌna legeyaꞌamofihi suhi luto niꞌibe. To ana noseꞌna legeyaꞌa masiteti yabe lite lilata nehabe. Ana noseꞌna legeyaꞌa bo moneuba lito foyaꞌagu nokafabe. ");
INSERT INTO bef_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masiteti legeyaꞌaya lugaꞌa noseꞌna legeyaꞌamagihi suhi luto sipina ma niꞌibe, ai lagasoꞌnasi niꞌibe. To ai ana noseꞌna hofa toto tiloto alihi tilotoꞌa asaga fato fatoꞌmofihi nina noseꞌnaya enebe noligibe. Ai yafa lolo hulago namamagi ete ana yafamofihi yahaꞌalo nohaꞌani ete gilata nehabe. Yaꞌma kokulumamofihi kapoꞌa ana suhi huto hilibe. ");
INSERT INTO bef_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu fato bame ka mone lu epiꞌehina: Kokulumamofihi kapoꞌaya yisiti yabe nelananamofihi suhi luto niꞌibe. Aꞌi moneuba lito falaꞌua magulu sipiꞌagu li tili hu mololoto li meyalo emalo huto li sibi sibi hulata nohibe. Ya nohigo alihaꞌa ana falaꞌuaꞌi yeye bito hofa tolata nohibe. Yaꞌma kokulumamofihi kapoꞌa ana suhi huto huto hilibe. ");
INSERT INTO bef_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu asaga kaga boanaꞌi lu epi kagaya bame kagutigo lu epiꞌehina yabe. Ai kaga mone lu hokolo huto lu meepiꞌehina yabe. Ai bame kagutigo lu epiba epiba huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ai lu huto huto bo moneuba ma luto kaga luꞌehinamofihi mana kaꞌa huto hilibeꞌmu yabe: Nani kaga lu noepitoꞌnimo bame kagutigo lilunaꞌmu yabe, Kaga koyapaꞌi meꞌmo li huto huto moloꞌehina yana kanaguti fala kito minomo tito oto yatai kanaꞌalo hiti nina nani lu lepilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu asaga boanaꞌi heꞌmi epololoto nonuga tiꞌehina. Ya higo koko pananaꞌa aitoga elete ma liꞌahana: Foipa kifiꞌna foyagu noliginamofihi hapaꞌa lu limibo. ");
INSERT INTO bef_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","To Yesu kaꞌanilo luꞌehina: Bo ai hetofa noseꞌna legeyaꞌa foyagu tili hulata nohinaya Kokulumaguti limiꞌehina Bo nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","To foyamoya asaga ma meꞌi yabe. To bati noseꞌnaya kokuluma kapolo boanaꞌi yabe. To foipa kifiꞌnaya enali Satahi boanaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ai fatehuba foipa kifiꞌna legeyaꞌa tili nohina bomoya Satau yabe. To noseꞌna li nupa huse kanaꞌaya ma meꞌi su halina kanaꞌa suhi huto yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","To enali foipa kifiꞌna li nupa hite logogu negana ana suhi ma melugu li huto hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ai Kokulumaguti limiꞌehina Bouba ageloꞌa enoho lifigo limite enali asagaꞌnauba bonaꞌmagihi hetofa hapaꞌani li sibina nehilanana hiti to asaga bonaꞌi foipa faipa suhi lite neminalana Huꞌmamofihi kapoꞌaloti kaba hiꞌehite eneleꞌmo heꞌmilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ya hilete enali loba loba huto nina logogu eneleꞌmo heꞌminogo bilete enagabu kumu behe behe baha baha ite sipi yibi hilete enabaga yogoꞌa henibe gofa hibe hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yaꞌmana yupahi Huꞌmamofitoga komopaꞌani melete minalana bonaꞌi enalitoga yege legi huto Afoꞌanifihi hepaꞌaloti fi besa lo epalalinaꞌmu yabe. To lenali bomagita lenekesa niꞌinogomo keheli bati hite kehelilo. ");
INSERT INTO bef_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Efaha guꞌi mone foyagu fala kite meleꞌahana suhi luto Huꞌmamofihi kokuluma kapoꞌaya niꞌibe. Bomouba bu goloto akuꞌi ifi notabe. Ya huloto ai sipi gelo bito buto asaga feꞌnohaꞌa epigo mina filago ai ana efatoti ana foya buto mina filata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bo moneuba pesesuꞌi hetofa hatofaꞌa mina filube luto sa sa hulata nohinaꞌa huto Huꞌmamofihi kapoꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ai pesesuꞌi hetofa mina filoto ai buto asaga feꞌnohaꞌa fato bonaꞌi noepito efaha nolibe. Ya huto ai efahi liloto i behe huto buto hetofa pesesuꞌi bu goꞌehina lilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ana huto kokuluma kapoya faya gutalafa melelete fayaꞌi fato fatoꞌmofihi tite bai netanaꞌa huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Fayaꞌi tite bai telago fayaꞌna nehana bomagi li kefefa hite kehetoga libiti nemalabe. Ya hilete enali meto minelete fayaꞌi batiꞌmofihaꞌa lapelugu li nemalabe. To bati mehina fayaꞌi menoseꞌmofihi niꞌigomo enali heꞌmilago bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma meꞌi su halina yupahi yaꞌmana suhi hilinaꞌmu yabe. Bati bonaꞌmagi folagahaꞌanigu bonaꞌi foipaꞌa nehilana agelomagi ete eneleꞌmo heꞌmilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ya hite sipi logo loba loba logogu eneleꞌmo malalanaꞌmu yabe. Ya hinogo ana sipi logogu sipi yibi bena nehite enabaga yogoꞌa henibe kolibe hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","To Yesu enoloka hoꞌehina: Lenali asaga kaga lu nolepunamofihi hapaꞌa akeheli hokolo hite nekehelifihe? Ya ligo enali lu emiꞌahana: Oꞌyo. ");
INSERT INTO bef_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ya lago Yesu lu epiꞌehina: Ya huꞌehigo asaga keya kaga enelepise bonaꞌi enali kokulumamofihi kapoꞌalo kagaꞌmu enelepise lite akeheli su heꞌahabe. Enali sipi nohi moneꞌmofihi afoꞌa legi hite nehabe. Ai situa nohaꞌagu tiloto yuhufana hiti tafana hiti li munu munu huto lito fegutoga limilata nohina suhi lite nehabe. ");
INSERT INTO bef_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu asaga bame ka lu epi su holoto ana hepaꞌi heꞌmiloto bufa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","To ai hepaꞌaga i behe huto buloto asaga boanaꞌmagihi Huꞌmamofihi mono kaꞌa enali mono nohaꞌanigu lu epiꞌehina yabe. Ya nohigo enali topa helete ma lite liꞌahana: Yaꞌma bouba kaga keheli bati huseꞌnaꞌa hiti to topa hoseꞌna li huto huseꞌnamofihi ka hapaꞌaba hiyaꞌagati liꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yafa lolo huse bomofihi panaꞌamo nohifi fato bobe? Maliau itoꞌafu nohifi fato panaꞌmofihi itoꞌafube? To Yemesiu, Yosefeu, Simoniu, to Yutasiu ai gonaꞌamo nehafi fato bomofihi enogonaꞌani nehabe? ");
INSERT INTO bef_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","To ai etaliꞌagiba magu lali hiti neminanamo niꞌifi hena hibe? Yaꞌma keheliya iseꞌnaꞌa asagaꞌi ai hiyagati liꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ya lite lilete enali siko nehite ipakafa helete enemegesa hu emiꞌahana. Ya hago Yesu ma luto lu epiꞌehina: Lu yege hose bomofihi giꞌa asaga hepatoga mino baga iꞌehibe. Ya huꞌehina aiꞌa noho hepaꞌagu giꞌa meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","To yaꞌmu mana hepalugu Yesu sipi liliꞌna babu luto li hu enubulo memoloꞌehina yabe. Henaꞌmugope enali Yesu li huto hinanaꞌmufi to kaga lu epinalo enali keheli meemise mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yataꞌa sipi kibina bo Helotiu yaꞌmana kanalo Yesuhi kagaꞌa keheliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ya huloto ai liliꞌnalo boꞌa lu epiꞌehina: Yaꞌma bo ai Yoniu nagami folo epolose bo yabe. Kene keliguti akuꞌi ho tiꞌehibe. Ya huꞌehigo yaꞌma asaga amuyana ai yato huto nohibe. ");
INSERT INTO bef_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ai yaꞌma huto niꞌibe. Koyapaꞌi Helotiu Yonihi yato seni nagatu nagaꞌi etoloto nagalugu heꞌmi etoꞌehina yabe. Helotiasiu ai Filipihi lihaꞌa Helotihi ai etaliꞌafihi hapaꞌamu lite ya hi eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yataꞌa Yoniu nagami folo epolose Heloti kumuꞌi bati mehina suhi luto ma aꞌi liꞌahane luto lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ya noligo Helotiu Yonihi lubahaꞌa laga hilubeꞌmu hinaya asaga boanaꞌmagi enubulo koli huto heꞌmi etoꞌehina yabe. Henaꞌmugope enali Yoniu lu yege hose bo nohibe lite lilata nehanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mone yupahi Helotihi itoꞌafu ketoꞌehina kanaꞌalo bonaꞌi lugaꞌa ete li gehesa hite noseꞌna gete nete mineꞌahana yabe. Ya nehago Helotiasihi paꞌauba folagahaꞌanigu melekehi ito bula ola huꞌehina yabe. Ya higo Helotihi lagaꞌa gofa besiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ya higo ai ana paꞌi lu emiꞌehina: Nani asaga bonaꞌmagi enubulo maꞌnaka luto nolu ketobe. Kai anaꞌina mone lilube luto gi halatana kimilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ya ligo ana paꞌmofihi itoꞌafu ekesa biꞌehina kaga luꞌehina: Kai lapeꞌi monelugu Yonihi nagami folo epolose bomofihi latahaꞌa mololoto malo nimibo. ");
INSERT INTO bef_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ya luto ligo Helotihi gufagu keta besiꞌehina yabe. Ya hinaya ai asaga bonaꞌi li nupa hite minete noseꞌna nana bona enubugu maꞌnaka luto lu emiꞌehina yabe. Yaꞌmu luto ai luꞌehina: Anana li emilo. ");
INSERT INTO bef_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yoni naga nonugu nohinalo bonaꞌi lugaꞌa Helotiu enoho lifigo bite lubahaꞌa laga hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ya hite lapeꞌi monelugu Yonihi latahaꞌa melete ite ete ana yafaꞌamofihi emiꞌahana yabe. Ai ana lape lito itoꞌafu nohinaga buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ya hago Yonihi koko panaꞌmagi ete gufaꞌa lite bite keli he eteꞌahana yabe. Enali akeli he etelete Yesuhi bite lu emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ana kaga keheliloto ana hepaꞌi noheꞌmito boti lito bonaꞌi menehana hepalugu buꞌehina yabe. Aiꞌasi buꞌehina yabe. Ya huꞌehigo enali boanaꞌmagi kehelilete hepaꞌani neheꞌmite megeꞌi lifite biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Alihi Yesu nagami beletoga keheto buloto babu boanaꞌi nehago bu enogoꞌehina yabe. Ya hago ai ginaga fi epiloto enebesiꞌehina bonaꞌani eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Utehe kana nohigo Yesuhi koko panaꞌa aitoga elete ma lite lu emiꞌahana: Ma hepatoga bonaꞌi menehabe, to sinihi agilinaꞌa nohibe. Ya nohinagi kai boanaꞌi enoho lifitogo enali abino. Enali hepatoga bila ela hite noseꞌnaꞌani sa sa hite nalabe. ");
INSERT INTO bef_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ya lago Yesu lu epiꞌehina: Hena hibe lite enali bilabe? Lenalitini noseꞌna epilo. ");
INSERT INTO bef_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ya ligo enali lu emiꞌahana: Maga lali noseꞌna babu lito meliꞌohune. Lali loegi loegi monegi beleti noseꞌna hiti to fayaꞌi loe hitisi ma liꞌohune. ");
INSERT INTO bef_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ya lago Yesu lu epiꞌehina: Lenali ana noseꞌna ite ete nimilo. ");
INSERT INTO bef_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","To ana boanaꞌi kifiꞌnalo melugu minalo luto lu epiꞌehina. Ya luloto ai loegi loegi monegi beleti hiti to loe fayaꞌi hiti liloto kokulumalugu bu golago tiloto nunumu huto fokehi liꞌehina. To ai beleti li pata putu siloto koko panaꞌa epigo enali asaga boanaꞌi lite bite epimofaꞌna hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","To enali asagaꞌi ana beleti nelago enumuꞌi huꞌehina. Ya higo enali nelete heꞌmina noseꞌna letuhaꞌa li nupa hite safe 12 agu li bai teꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bo ana noseꞌna neꞌahana makiꞌaya 5000 yabe. To enali anaꞌi yagapanaꞌi leka meseꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu koko panaꞌamagihi lenali botigu tilete kohe tete bite nagami hefuhi mula beletoga nehilo luꞌehina. Ya hiloto aiꞌa asaga boanaꞌi enoho lifinogo hepaꞌaniga bilabeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ai boanaꞌi enoho lifigo hepaꞌaniga aꞌnebago bohupoꞌi mone ninalo tito nunumu hilubeꞌmu tiꞌehina. Utehe kanaꞌalo aiꞌasigo ana kosalo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","To boti nagami hefuhi folagahaꞌagu abulago sipi habafahi enubulogati oto nagamiꞌi li galafu tuto botigu heꞌmi molo heꞌmi molo nohuto boti nagamilugu li koseꞌna huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Etehi foluguꞌi go metepuꞌa hiti Yesu nagami hefuhi mupaꞌalo kapo moloto koko panaꞌa nehanalo oꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Koko panaꞌamagi Yesu nagami mupaꞌalo kapo moloto noago be gelete topa hete afoya foya ilete felemo noabe lite koli hiꞌahana yabe. Enali sipi koli fatoꞌmofihi hilete kehe sipi iꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ya hago hololu luto Yesu enali kehe iꞌehina: Lenali amuya malalo. Naniꞌni nohube. Naniꞌni nohube. Lenali koli mehilo. ");
INSERT INTO bef_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","To Pitau lu emiꞌehina: Sipi Boꞌni. Maꞌnaka luto kaikamo nohutomo naniꞌi kehe itogo nani nagamiꞌi mupaꞌalo kapo moloto kaitoga bilube luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ya ligo Yesu lu emiꞌehina: Obo. Ya ligo Pitau botiguti leheko limiloto nagami mupaꞌalo li hapi fito kapo moloto Yesu nohinalo buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ya hina ai akuꞌi habafahi bu goloto koli huꞌehina, ya huloto nagamilugu hapi fito limiꞌehina. Ya nohutoꞌa ai kehe sipi iloto luꞌehina: Sipi Bo. Kai neheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ya noligo Yesu hololu luto Pitahi yato liloto lu emiꞌehina: Kai kagaꞌni li pili mekoꞌahane. Kai hena hibe luto loe lae kekesa nokeheline? ");
INSERT INTO bef_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Etali loe sana sana botigu tite neminaꞌigo habafahi felele huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","To bonaꞌi enali botigu minanamagi Yesuhi fokehi helete ma lite liꞌahana: Maꞌnaka luto kai Huꞌmamofihi Panaꞌa nohane. ");
INSERT INTO bef_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","To nagamiꞌi mula beletoga heleke melete bilete Genesalete hepa kegiꞌa biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ya hago ana hepato bonaꞌmagi Yesu okabaꞌa be geꞌahana. Ya hilete enebesiꞌehina bonatoga enoho lifigo bite enebesina bonaꞌi Yesutoga eneleꞌmete eba eba hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ya hilete enali Yesuhi buka tilete ma lite liꞌahana: Ke, kai kaga melitogo enebesise bonaꞌmagi guketeka nekisaꞌalo meko hilana bati huto niꞌifihe? To enali ana bonaꞌi Yesuhi guketeꞌalo meko hana bonaꞌi bati hi su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","To Felosi bonaꞌi lugaꞌa hiti keya kamuꞌi tisa bonaꞌi lugaꞌa hiti Yelusale hepatogati ete Yesu nohinalo nehetilete ma lite loka heꞌahana: ");
INSERT INTO bef_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kai koko panakamagi hena hibe lite tatatigi limiꞌahana kaꞌani megeꞌi menemalabe? Enali noseꞌna naluneꞌmu nehitemo enayahi sese mehise faꞌmene nelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ya lago Yesu kagaꞌanilo lu epiꞌehina: Lenali kagatinisigo megeꞌi nemelete hena hibe lite Huꞌmamofihi keya kagaꞌa megeꞌi menemalabe? ");
INSERT INTO bef_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mono ka bukugu Huꞌmau ma luto luꞌehina yabe: Itokafinogo afokafinogo eneleꞌmo bati huto etemegeꞌi molobo. To mone keneꞌuba itoꞌafinogo afoꞌafinogo kaga foipaꞌa lu etatalina ho fililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ya huꞌehina lenali ma lite lilata nehabe: To bo moneuba itoꞌafinogo afoꞌafinogo eteheꞌmalina efahi niꞌinamo meetimilube, to nani Huꞌmamofihi emilube luꞌohuna yabe lulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ya luloto ai itoꞌafinogo afoꞌafinogo eteleꞌmo bati mehulata nohibe. Lenali yaꞌmana suhi li huto nehitemo Huꞌmamofihi keya kaꞌa li gofa nehete lenali hapatinimofinogo li saga hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lenali fagalo bonaꞌi. Koyapaꞌi lu huto huto bo mone Aisaiyau lenali kumu luto fayahi ma luto goꞌehibe: ");
INSERT INTO bef_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yaꞌma kanaꞌalo boanaꞌmagi nigiꞌni enabagaꞌanituꞌi li saga nehite to akuꞌi komopaꞌani nanitoga memelese fotoꞌi melete minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enali faꞌmene bonaꞌmagihi kaga lu epimofaꞌna nehite: Yaꞌma kaga Huꞌmamofihi kagaꞌa yabe lilata nehite. Enali nani nigiꞌni faꞌmenenaꞌmu helata nehabe luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","To asaga boanaꞌi Yesu kehe i nupa huloto ma luto lu epiꞌehina: Kaga mone lu lepilunagi lenali lenekesatuꞌi kehelilete keheli fiya ilo. ");
INSERT INTO bef_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","To bomofihi komopaꞌagu tilata nohinanauba ana bo leꞌmo kolo tolata menohibe. To bomofihi ai komopaꞌaguti fegutoga heleko limilata nohinanauba bo leꞌmo kolo tolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yaꞌmana kanaꞌalo Yesuhi koko panaꞌa aitoga ete ma lite lu emiꞌahana: Felosi bonaꞌmagi kagaka kehelilete kipakafa nehabe. Ya nehana kai yaꞌmanana akeheliꞌahapihe? ");
INSERT INTO bef_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ya lago Yesu kaꞌanilo lu epiꞌehina: Afoꞌnifu kokulumalugu nohinamofihi foyaꞌa samahi tito niꞌibe. Asaga kifina Afoꞌnifu kokulumalugu nohinauba foyaꞌagu mehekoloꞌehina kifina nina hapaꞌa hiti li su ti heꞌmi su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","To lenali heꞌmi epelenogo enali mineno. Enali enubu pisi lina bonaꞌi nehite enali ana hite enubuꞌani pisi luꞌehina bonaꞌi fatoꞌamagihi kapo enelepiluneꞌmu nehabe. Ya huꞌehinaya buꞌa pisi luꞌehina bouba fato bo ana huto buꞌa pisi luꞌehina bo kapo lepilubeꞌmu hilinaya etali loe sana sana ho kete keli kapogu limilaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ya ligo Pitau Yesuhi kaꞌalo luꞌehina: Kai yaꞌmana bame kamofihi hapaꞌa lu hokolo hitogo kehelilune. ");
INSERT INTO bef_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ya ligo Yesu lu epiꞌehina: Lenali hiti kaga keheli fe melilanaꞌa hite nehafihe? ");
INSERT INTO bef_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Lenali keheli bati menehafihe? Anaꞌinaꞌa bomofihi bagagu tilata nohinana gupaꞌagu tito minoloto akuꞌi gufaꞌaguti heleko limilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ya huꞌehina anaꞌina bomofihi bagaꞌagu niꞌinati fegutoga heleko limilata nohinaya komopaꞌaguti huto huloto tilata nohibe. Ai yaꞌmananauba bomofihi komopaꞌa li kolo tolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Anaꞌina enipaguti tilata nohinana ma huto niꞌibe. Foipa enekesa yigiseꞌna, bonaꞌi enoho filiseꞌna, bo alobo loko huseꞌna, moko liseꞌna, gumina huseꞌna, faga faga luseꞌna, to bonaꞌi enipakafa hoto enemegeka luseꞌna yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Asaga yaꞌmanauba bomofihi leꞌmo kolo tuba ilata nohibe. Ya huꞌehina bo moneuba yahi okala mehuse noseꞌna lito nolata nohina yaꞌmananauba bomofihi leꞌmo kolo tuba meilata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","To Yesu ana hepaꞌi heꞌmiloto Taiya hiti to Saitoni hepa kegiꞌa buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kena aꞌi mone ana kegiꞌa nominana aꞌuba Yesutoga oꞌehina. Tebitihi panaꞌabe. Ai ya luto kehe iꞌehina. Kai kiginaga fi nimibo. Foipa feleuba paꞌnimofihi leꞌmo sibina nohinagi neheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ya ligo Yesu kaga meluse minoꞌehina. To enali Yesuhi koko panaꞌa aitoga elete ma lite lu emiꞌahana: Ma aꞌauba lemege lemege nohuto kaga luba luba nohina kai ho lifitogo bufa hino. ");
INSERT INTO bef_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ya lago Yesu lu emiꞌehina: Isilaeli sipisipi yaga fenene hiꞌahanaloꞌmu luto Huꞌmau noho lifigo maga limiꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ya ligo ana aꞌuba Yesuhi gigusagu oto okabagati lipito koloto luꞌehina: Ke. Sipi Bo, kai neheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","To Yesu ana aꞌmofihi kaꞌalo lu emiꞌehina: Yagapanaꞌmagihi noseꞌna lito kalamagihi heꞌmi epiluta bati mehuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ya ligo ana aꞌuba Yesuhi lu emiꞌehina: Sipi Bo, ya maꞌnaka nolane. Ya nohataya kalamagi afoꞌanigi noseꞌna nenago letuhaꞌa hitamofihi meꞌagu limo ilata nohina enali kehelite nelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ya ligo Yesu ai aꞌmofihi lu emiꞌehina: Akae, ma aꞌi yale. Kaga keheli fe luseꞌnaka sipina niꞌibe. Anaꞌina lolo hu netalane luto nolatanaya huto hu kimilinaꞌmu yabe. Ya ligo anaꞌasilo ana aꞌmofihi paꞌa kaꞌmuya hepalugu nohigo bati hu etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ana hepaꞌi heꞌmiloto Galili hefuhi beletoga kapo moloto tubuꞌehina. Ai kosa bohupoꞌisi mone ninalo tito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ya nohigo babu boanaꞌi enali li nupa hite ai nohinalo eꞌahana. To enigigusa sibina hina bonaꞌi, enubu pisi luꞌehina bonaꞌi, felisaꞌani kuyugu huꞌehina bonaꞌi, enabaga hekini loꞌehina bonaꞌi to fato fato epesiꞌehina bonaꞌi enali babu lite Yesutoga eneleꞌmete eꞌahana yabe. Enali eneleꞌmete ete Yesuhi gigusaꞌagu malago ai asagaꞌi eneleꞌmo bati hu su hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ya higo asaga boanaꞌi enali enekesa yigi babu liꞌahana yabe. Henaꞌmugope negi bonaꞌi akuꞌi kaga lila, felisaꞌani kuyugu hina bonaꞌi bati hu epolola, enigiꞌani sibina huꞌehina bonaꞌi kapo melela, to enali enubuꞌani pisi luꞌehina bonaꞌi enubuꞌani i gili hula hinana be geleteꞌani yabe. Ya hilete enali Isilaeli bonaꞌmagihi Huꞌmaꞌanifu ai kumu fokehi hete giꞌa li saga hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu koko pananaꞌa kehe i nupa huloto ma luto lu epiꞌehina: Ma bona kumuꞌi nani niginaga nofibe. Henaꞌmugope enali loegi monegi yupahi nani hiti mineꞌahana yatai noseꞌna nalanaꞌa meniꞌibe. Nani noseꞌna meepise enoho lifinogoꞌni bilana enali kapoga nebinogo enubu neta neta bilenogo ho kete kela ya hila hilabeꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Koko panaꞌamagi Yesuhi loka heꞌahana: Yaꞌma ka me hepatoti lali babu noseꞌna hiyaꞌagati liloto yaꞌma babu boanaꞌi epilune? ");
INSERT INTO bef_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ya lago Yesu enoloka hoꞌehina: Lenali henakiꞌa beleti noseꞌna liꞌahabe? Enali lu emiꞌahana: Sebeniꞌa beleti hiti to fayaꞌi lagaso mesoꞌa loesi hiti liꞌohune. ");
INSERT INTO bef_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ya lago Yesu asaga boanaꞌi melugu minalo ligo enali melugu mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","To ai sebeniꞌa beleti hiti to fayaꞌi lagaso mesoꞌa loesi hiti yanuga liloto Huꞌmamofitoga nunumu huto fokehi holoto gofa gofa holoto koko panaꞌa epiꞌehina. Ya higo koko panaꞌamagi enali leliꞌali hite asaga boanaꞌi epiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asaga bonaꞌi ana noseꞌna nelago enumu huꞌehina yabe. Ya higo Yesuhi koko panaꞌamagi letuhaꞌa li nupa nupa hite sipi sepekeꞌna 7 agu li bai teꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","To asaga bo ana noseꞌna neꞌahanaya 4000 bomagi neꞌahana yabe. To anaꞌi yagapanaꞌi hiti leka mesone. ");
INSERT INTO bef_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","To silaga boanaꞌi Yesu enoho lifigo nebago ai boti monelugu tiloto Magatani hepa kegiꞌa buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Felosi bonaꞌi to Satusi bonaꞌi yabe nelana hiti lugaꞌa enali Yesutoga elete fi taga hu etaluneꞌmu hiꞌahana. Enali: Kokulumalugu topa hoseꞌna mone li huto hitogo bu galune liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ya lago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Utehi yege limi falalubeꞌmu nohuto kokulumaꞌi fi beyege toloto safa logo nohigomo lenali bati huto yago yege lalinagi lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","To etehi sopohi giloto kokulumaꞌi safa logo nohigomo yasi hiti koꞌi yatai ilibe lite lilata nehabe. Oꞌyo, lenali bati hite kokulumamofihi mehaꞌa be gelete loko hilata nehabe. Ya nehana lenali yatai kanamofihi mehaꞌa be gelete loko mehilana nehabe. ");
INSERT INTO bef_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lenali bati mehana boana moko fako lite neminana boanaꞌmagita nani kumuꞌi topa hoseꞌna li huto hu lubulo molobo nelabe. Ya nelana nani topa hoseꞌna mone li huto hu lenubulo memalalunaꞌmu yabe. Lenali koyapa bo Yona huto huꞌehinanamofihi topa hoseꞌnaꞌago anasi bu galanaꞌmu yabe. Ya luto luloto Yesu heꞌmi epololoto bu fa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Enali Yesuhi koko panaꞌamagi botigu tite hefuhu nagamiꞌi helekete nebitemo enekesu hago beleti noseꞌna moneꞌa melise biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","To Yesu ma luto lu epiꞌehina: Lenali kaba hu bati hilo. Lenali Felosi bonaꞌi hiti to Satusi bonaꞌi hiti enali yisiti legita hapaꞌanilo kaba hu bati hilo. ");
INSERT INTO bef_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ya ligo enaliꞌani ma lite musi musi ka liꞌahana: Lali beleti melise oꞌohuta kamoꞌmu nolibe. ");
INSERT INTO bef_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ya lana kagaꞌani Yesu akeheliloto ma luto lu epiꞌehina: Kaga keheli bebe soseꞌnatini nesiꞌasi niꞌi lepalana bo hena hibe lite lali beleti lito meoꞌohune ya lite musi musi ka nelabe? ");
INSERT INTO bef_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lenali keheli bati mehiꞌahafihe? 5000 bonato to 5 beleti gofa gofa hoꞌohunamoba lenali lenekesu hoꞌehifihe? Henakiꞌa safegu letuhaꞌa li bai teꞌahana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","To 7 beleti 4000 bomagi epugo neꞌahana kagamoba lenekesu hoꞌehifihe? To henakiꞌa sepekeꞌnagu letuhaꞌa li bai teꞌahana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Beleti noseꞌnamu meluꞌohuna. Lenali hena hibe lite mekeheliꞌahabe? Lenali Felosi bo hiti Satusi bomagihi yisiti suhi luto fagalo hapaꞌani niꞌinagi kaba hu bati hilo. ");
INSERT INTO bef_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ya ligo enali beletimofi yisitimuꞌi kaba hu bati hilo melibe. Ai Felosi bomagi hiti to Satusi bomagihi kagaꞌanilo kaba hu bati hilo luto nolinagi lite enekesa yigi fe liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu Sisalia Filipai kegiꞌa buloto yaꞌmana kanalo koko panaꞌa ma luto enoloka hoꞌehina: Asaga boanaꞌmagi Kokulumaguti limiꞌehina Bo kumuꞌi hena hibe lite lilata nehabe? ");
INSERT INTO bef_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","To enali lu emiꞌahana: Lugaꞌa bonaꞌmagi Yoniu nagami folo epolose bo nohibe nelabe. To lugaꞌa bonaꞌmagi Elaiyau nohibe nela. To lugaꞌamagi ai Yelemaiya nohifi fato lu huto huto bo nohifi lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ya lago Yesu lu epiꞌehina: To lenalitini nani kumuꞌi kiyiꞌafube lite nigiꞌni nehabe? ");
INSERT INTO bef_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ya ligo Simoni Pitau kaꞌalo nonaꞌa luꞌehina: Kai Huꞌma nominanamofihi panaꞌa leꞌmo ho tiꞌehina bo Mesia nohane. ");
INSERT INTO bef_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ya ligo Yesu lu emiꞌehina: Simonio, kai Yonihi panaꞌa yale. Kai kegelo bibo. Ma melugu bo moneuba yaꞌma lamana kaga mekelepiꞌehinagi Afoꞌnifu kokulumalugu nohinauba aiꞌa kelepiꞌehigo yaꞌma kaga nolane. ");
INSERT INTO bef_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya hanogo nani lu nokumube: Pita, kaiya efa tegi suhi luto nohane. Ya huꞌahatago yaꞌmana efato nani mono nohaꞌni gilunaꞌmu yabe. Filiseꞌnamofihi amuyaꞌauba be megilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","To nani kokuluma kapolo hokolo hilatanafi to hekini lolatanafi kimilunaꞌmu yabe. To kai ma melugu nominotoka hapaꞌa mone hekini loto lu laga hu epelenogo kokulumalo bo, Huꞌmau ana huto lu laga hilinaꞌmu yabe. To ma melugu nominotoka hapaꞌa mone hokolo hu epelenogo kokulumalo bo, Huꞌmau ana huto hokolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","To Yesu koko panaꞌa amuya luto enekesa biꞌehina: Nani kumu luto lenali Huꞌmau ho lifiꞌehina panaꞌi Mesia nohibe lite lu yege hete asaga bonaꞌi lu meepilo. ");
INSERT INTO bef_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yana kanaꞌalo Yesu koko panaꞌa kaga hapi fito lu hokolo huto lu epiꞌehina: Nani Yelusale hepatoga bulotoꞌni enikibina bo, sipi mono bo to keya ka tisa bo enalitogati nagabu foya li kofilube. Enali noho fililenogo yege loebe monebe minolotoꞌni akuꞌi ho tilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ya ligo Pitau leꞌmo beletoga moloto amuya ka emekiloto ma luto lu emiꞌehina: Sipi Bo, enali ya mehi ketalanaꞌmu yabe. Yaꞌmana suhi kaitoga huto mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To Yesu i behe huto Pitahi bu goloto ma luto lu emiꞌehina: Sata, kai nanitogati bufa hubo. Kai kapo bilunaꞌa hekini lo netalubeꞌmu nohapihe? Kai kaga nolataya ma melugu bonaꞌmagihi kaga nolane, to ai Huꞌmamofitogati meoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yalo Yesu koko panaꞌa ma luto lu epiꞌehina: Bo moneuba naniꞌi hiti bilube lutomo aiꞌa gufaꞌamu ekesa meyigise malipu yafaꞌa lito kofiloto nemegeꞌi meleno. ");
INSERT INTO bef_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","To bo moneuba aiꞌa gufaꞌa li buto bito koli koli huto minalina ai gufaꞌamofihi mino kosaba huseꞌnaꞌa minigilinaꞌmu yabe. To bo moneuba nani kumu luto gufaꞌa heꞌmilina alihi ai gufaꞌamofihi mino kosaba huseꞌnaꞌa akuꞌi lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","To bo moneuba ma melugu asaga feꞌnohi ninana lilube luto lilinaya to aiꞌa mehaꞌa minigilibe. Ya hinogo asaga feꞌnohanauba hena huto li buto bito heꞌmalina niꞌibe? To bouba hena minaꞌa heꞌmito mehaꞌa akuꞌi lilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kokulumaguti limiꞌehina Bouba Afoꞌafihi fana mehenaꞌa hiti akuꞌi noenogo to ageloꞌa hiti alanaꞌmu yabe. Ya hilina yupahi asaga boanaꞌmagi fato fato suhi hiꞌahana hapa hapaꞌanimofihi nonaꞌa li yege ho epalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nani maꞌnaka lu nolepube. Bo lugaꞌa ma ho tilete nehanaguti mefilise nehite bu geꞌehinogo Kokulumaguti limiꞌehina Bouba kibina bo lolo huto minoloto aku alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","To loebe loebe loebe yege bulago minelete Yesu Pita hiti Yemesi hiti to ai gonaꞌa Yoni hiti eneleꞌmo megeꞌi toloto yatama kosagu eneleꞌmoto tilago ana kosalo enaliꞌanisigo mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","To Yesuhi gufaꞌa enali enubulo leꞌmo fato suhi hu etoꞌehina yabe. To okabaꞌa fi besa loloto yege legi huto huto huꞌehina. To guketeꞌa koholina huloto gulu gulu luto fi besa loꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To koyapa bomaleꞌi Moseugo Elaiyaugo Yesutoga nehetilete kaga lite nehago bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitau ya hago bu enogoloto ma luto Yesuhi lu emiꞌehina: Sipi Bo, yaꞌmaga nohuta bati huto nohune. Kai bati huto yabe litogomo yege nohi loegi monegi maga gilune. Mone kaiꞌi yagi mone Mosehi yagi to mone Elaiyahi yagi huto gi lepalalube. ");
INSERT INTO bef_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ai kaga luto nohigo sopohi mone besa loꞌehinauba eneleꞌmo samapahi buꞌehina. To ana soponuguti nogo mone ma luto huto huꞌehina: Yaꞌma ai nibita hina panaꞌni nohibe. Nani nipaꞌni aitoga emilata nohube. Lenali kagaꞌa keheli emilo. ");
INSERT INTO bef_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ya noligo Yesuhi koko panaꞌamagi topa hete sipi koli hilete melugu enokabagati lipi gehesa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ya hago Yesu enalitoga oloto enugufalo meko huloto lu epiꞌehina: Lenali koli mehite ho tilo. ");
INSERT INTO bef_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ya ligo enali be go saga hilete Yesu aiꞌasigo nohigo bu geꞌahana yabe. To loemaleꞌi minigiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Enali ana kosa heꞌmilete kapo melete nelimite amuya kaga luto enekesa biloto Yesu ma luto lu epiꞌehina: Yaꞌmanana huto higo lenali bu geꞌahana lenali bonaꞌi lugaꞌa meepilo. Lenali komopatinigu melelete nehinogo Kokulumaguti limiꞌehina Bouba keli heꞌmiloto ho tilenogo ana kaga lu huto hilo. ");
INSERT INTO bef_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","To Yesuhi koko panaꞌamagi ma lite loka heꞌahana: Keya ka kehelise bomagi hena hibe lite Elaiyau yataꞌa alibe lilata nehabe? ");
INSERT INTO bef_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ya lago Yesu lu epiꞌehina: Oꞌyo, maꞌnaka nelabe. Elaiyau asagaꞌna oto li loloba hilubeꞌmu yataꞌa kohe toto oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ya huꞌehina nani maꞌnaka luto lu nolepube. Elaiyau ai aoꞌehibe. Ya huꞌehinamo bonaꞌmagi Elaiyau nohibe lite menekehelibe. Ya hite enali enemehuba hinanamofihi megeꞌi melete nehite fato fato suhi hi eteꞌahana yabe. Kokulumaguti limiꞌehina Bomofihi ana suhi hi etete gabuꞌi gilinana hi etalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu ya luto lu epigo enali koko panaꞌamagi enekesa i hokolo higo Yoniu nagami folo epolose bomoꞌmu linagi lite keheli bebe seꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","To enali babu boanaꞌi nupa hite nehanalo nehe netigo bo moneuba Yesutoga oto gigusaꞌagu lipito minoloto ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Sipi Bo, kai panaꞌnimofihi kiginaga fi emibo. Ai negi nagi noto nominago gufaꞌa nohetibe. To ai babu yupahi afoya tibibi nohuto nagamilugu ho koto kola to logogu ho koto kola nohibe. ");
INSERT INTO bef_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","To nani koko panaka nehanalo leꞌmo bati hu etalafi luto leꞌmoto onamo enali leꞌmo bati mehilanaꞌa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ya ligo Yesu kaꞌalo luꞌehina: Akae, lenali yatai kanalo boanaꞌise, lenali ka keheli uleꞌale huseꞌnatini meminabe, to komopatini bebe soto meminolata hibe. Henaki yupahi lenali hiti nani minoto foipanatini kofeliꞌali nohube? To ana bomofi kumu ma luto lu emiꞌehina: Panaka leꞌmoto maga obo. ");
INSERT INTO bef_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ana foipa felemofihi panaꞌi heꞌmi etoto bufa hubo ligo ana foipa fele nohigo anaꞌasilo ana panaꞌi bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yalo Yesuhi koko panaꞌasigo Yesutoga elete ma lite loka heꞌahana: Hena huꞌehigo lali foipa fele ho menolufune? ");
INSERT INTO bef_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ya lago Yesu ma luto lu epiꞌehina: Henaꞌmugope lenali nanitoga komopatini nesiꞌasi meleꞌahanaꞌmu yabe. Lenali maꞌnaka lu lepilunagi kehelilo. Lenali nalepa legeyaꞌa legi huto nanitoga komopatini nimiseꞌnatini minalina, ma kosamofihi mula kegiꞌa bu molobo lilana ai lenabaga liyafa huto bilinaꞌmu yabe. To liliꞌna yege yegeꞌi lenalitini lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ya huꞌehina yaꞌmanamofihi foipa fele ho lifise kapoꞌa fatoꞌi mone meniꞌibe. To noseꞌna mo sito nunumu foya liseubago anasi ana foipa fele ho lifilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuhi koko panaꞌa Galili hepato akuꞌi e nupa hilago kaga mone ma luto lu epiꞌehina: Kokulumaguti limiꞌehina Bomofihi fatehaꞌamagi enayanugu leꞌmete bite bilana kanaꞌa anasi hupamone nohibe. ");
INSERT INTO bef_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ya hinogo enali ho fililabe. To ai melugu limito yege loegi monegi minoto akuꞌi ho tilinaꞌmu yabe. Ya luto Yesu lu epigo koko panaꞌamagi enipagu keta huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu koko panaꞌa hiti Kapaneami hepatoga nehetilago sipi mono noto takisi efahi lise bomagi Pitatoga ete ma lite loka heꞌahana: Tisatiniuba sipi mono noto takisiba noheꞌmina niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ya ligo Pitau: Oꞌyo, luꞌehina. To Pitau nonuga notigo Yesu aitogati yataꞌa ma luto loka hoꞌehina: Simoni, kai hena hibe luto nokeheline? Ma melugu enikibina bolo kiyiꞌafu takisi holata nohibe? Mana hepato boanaꞌmagifi to bonoho bonaꞌmagibe? ");
INSERT INTO bef_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitau lu emiꞌehina: Bonoho bonaꞌmagi yabe. Ya ligo Yesu lu emiꞌehina: Ya huꞌehinagi yaꞌmana hepato bonaꞌi takisi efahi meheꞌmilanaꞌa huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ya huꞌehina lali eneleꞌmo topa ho lalune. Kai nagami hefuto buloto faya huku molobo. To yataꞌa lilata fayaꞌi lito bagaꞌa li aka huloto efahi bu galataꞌmu yabe. Kai yaꞌmana efahi liloto nani kaika hiti takisi heꞌmitogo su halibe. ");
INSERT INTO bef_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yana kanaꞌalo Yesuhi koko panaꞌa aitoga nehetilete ma lite loka heꞌahana: Lugaꞌa enebe ligito kuyuꞌafu sipi bo kokuluma kapolo kaba hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ya lite loka hago Yesu panaꞌi lagasoꞌa mone kehe igo ago folagahaꞌanigu leꞌmo ho tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ya huloto ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Lenali komopatini i gelehe hilete panaꞌi lagasoꞌa legi mehilana lenali kokuluma kapoꞌalo mebilanaꞌmu yabe. Maꞌnaka luto lu nolepube. ");
INSERT INTO bef_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","To bo moneuba mino laba huto minoloto ma lagaso pana suhi huto minalina, yaꞌmana bouba lugaꞌa bo enohoto kokuluma kapolo minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","To bo moneuba nani nigiꞌnimu ekesa keheliloto yagapanaꞌi yaꞌmaꞌa eneleꞌmo bati huto eneheꞌmalina, aiꞌya naniꞌi neheꞌmalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ya huꞌehina bo moneuba yagapanaꞌi yaꞌma huseꞌa nehilana folagahaꞌaniguti komopaꞌani nanitoga melete minaluneꞌmu hilana eneleꞌmo nanitogati heꞌmiletemoꞌmu yaꞌma bo lubahaꞌagu sipi efa kosahi naga i etelete leꞌmete bite hege nagami folagahaꞌagu heꞌmi meleno. ");
INSERT INTO bef_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","To ma melugu bomagi bonaꞌi lugaꞌa foipanagu enelepite bilata nehana boya sipi keta epesilinaꞌmu yabe. Maꞌnaka luto yaꞌmanana huto hilinaꞌmu yabe. To anana li huto hilina boya sipi keta besilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","To kigi kayahakauba foipana li huto nohinogomo kai laga huto heꞌmilago bubo. To kayahi mone kegiꞌa hiti kigigusa mone kegiꞌa hitigo minolenogo bati huto minoba minoba hepato bilataꞌmu yabe. To kigi kayahi luga luga hiti niꞌinogo nohuto logo loba loba huto mesobose hepatoga bilata bati mehuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","To kubukauba foipana li huto nohinogomo kai li kutu hoto heꞌmilago bubo. To mone kegiꞌa kubusigo niꞌinogo minoba minoba hepatoga bilata bati huto niꞌibe. To kubuka luga luga bati huto niꞌinogo nohuto logo loba loba huto mesobose hepato bilata bati mehuꞌehibe. Ya luto Yesu koko panaꞌa lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Lenali yaꞌma yagapanaꞌi faꞌmenena nehabe lite li lalabe. Lenali kaba hu bati hilo. Nani maꞌnaka luto lu nolepube. Kokulumalugu nani Afoꞌnifihi buꞌalo enali ageloꞌani kaba hu epelete neminabe. ");
INSERT INTO bef_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Henaꞌmugope Kokulumaguti limiꞌehina Bouba minigiꞌahana sipisipi yaga eneleꞌmo huto hilube luto limiꞌehinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Lenali hena hibe lite nekehelibe? To bo moneꞌmofihi sipisipi yagaꞌa 100 nehilanaguti monekoꞌisi minigilina hena hilina niꞌibe? Ai sipisipi yagaꞌa 99 analo heꞌmi epelenogo kosagu kifiꞌna laga hite nete nehinogo moneko sipisipi yagaꞌa minigiꞌehina sa sa hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nani maꞌnaka luto lu lepilube. Ai sa sa huto ana sipisipi yaga leꞌmo huto hulotomo ana moneko yagaꞌmu luto sipi gelo biloto nu kito bilinaꞌmu yabe. To 99 sipisipi yaga silagaꞌi fenene mehiꞌahanamagi kumu luto gelo mebilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yaꞌmana suhi luto kokulumalugu Afotinifu nohinauba ma yagapanaꞌi nehana folagahaꞌaniguti mone meminigilibe luto lulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","To bonaka moneuba kaga foipaꞌa lu ketoꞌehinogomo kai bitogo letalititisigo nehitetiti ana foipanaꞌa lepibo. Letali letugufatitigu fala kite yaꞌmana kaga lu koguna iliyo. To kagaka keheli kiminogomo kalalukafihi aleꞌmo fulu huꞌahane. ");
INSERT INTO bef_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","To kagaka keheli mekiminogomo kai moneꞌisifi loefi bonaꞌi eneleꞌmoꞌohuto moneka bilo. Ya hitogo lugufa bomagi enali kaga mono kagu ninaꞌa hite lu huto hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","To ana bomagihi kagaꞌanilo keheli meepinogomo mono nonugu asaga mono boanaꞌi lu huto huto lu epibo. To asaga boanaꞌmagi kagaꞌani keheli meepinogomo bonoho bonaꞌifi takisi nelina bomagihi suhi luto nohane luto keheli emibo. ");
INSERT INTO bef_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Maꞌnaka luto lu nolepube. Lenali asagaꞌna ma melugu ninanamofi kumu lu laga hilana Huꞌmau kokulumalugu ana suhi huto lu laga hu epalalinaꞌmu yabe. To asagaꞌna ma melugu bati huto lilinaꞌa Huꞌma kokulumalugu ana huto bati huto yabe lilibe. ");
INSERT INTO bef_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Maꞌnaka moneꞌa hiti luto lu lepilube. Ma melugu bonaꞌmagita folagahatiniguti bo loemaleꞌi anaꞌina monekoto komopaꞌatiti li hepilete anana liluꞌibe lite nunumu hilaꞌina, yalo Afoꞌnifu Huꞌma kokulumalugu nohinauba anana etimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","To bo loefi to loegi monegifi nani nigiꞌnimu enekesa kehelilete moneko hepato li nupa hite minalana yaꞌmana hepato nani folagahaꞌanigu enali hiti minalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","To Pitau Yesutoga oloto ma luto loka hoꞌehina: Sipi Bo henaki yupahi nalaluꞌnifu ka foipa lu netolenogo leꞌmo fulu hilube? Sebeniꞌa yupahifi? ");
INSERT INTO bef_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ya ligo Yesu ma luto lu emiꞌehina: Nani sebeniꞌa yupahi yabe luto lu mekimiꞌohube. Sebeniꞌa teni yupahi babu yupahi kalalukafihi leꞌmo fulu hubo luto luꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ya huꞌehina gihiti bo moneuba liliꞌnalo panaꞌa hiti tina hiꞌahana li eto hiluneꞌmu nehana suhi luto kokuluma kapoya niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ai hapi fito tina hu eteꞌahana li eto hilubeꞌmu nohigo bo mone samahi tito tola efahi liꞌehina bo leꞌmete eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ya hago ana bo ai tinaꞌalo heꞌmilina efahaꞌa meminoꞌehina yabe. Ya higo ana bo hiti feꞌnohaꞌa hiti lihaꞌa yagapanaꞌa hiti fato bonatoga noepito efahi lilube luꞌehina. Ya hinogo tina huꞌehina efahaꞌni heꞌmiꞌehina okaneꞌa baga ilibe. ");
INSERT INTO bef_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ya ligo ana koko panaꞌauba ana gihiti boꞌamofihi gigusagu lipiloto melugu bu goloto ma luto gihiti boꞌamofihi lu emiꞌehina: Kai kiginaga fi nimito negeba huꞌohubo. Nani asaga tinaꞌni pa so su halunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","To akuꞌi ana gihiti bouba koko panaꞌamofi kumu ginaga figo tina hu etoꞌehina anaꞌa hilibe noluto ana koko panaꞌa heꞌmi etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ya higo yaꞌmana bouba heleko limito buto liliꞌna moneka neliꞌina bo moneꞌmofihi tina huto tola efahaꞌa nesiꞌa emiꞌehina bo bu goto lubahaꞌalo lito li geka geka huloto meleꞌisi tinaka pa sobo lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ya ligo moneka liliꞌna neliꞌina bouba melugu li piloto buka tito luꞌehina: Kai kiginaga fi nimito nesiꞌa negeba huꞌohubo. Nani tinaꞌni alihi pa salunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ya lina ana bomofihi ginaga mefiꞌehina. Ya higo ana bo leꞌmoto buto naga foyagu moloꞌehina yabe. To ai anaga nohuto tinaꞌa pa so su halibe luto huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","To ya higo enali moneko liliꞌna nelina bomagi ana suhi hinamofihi hapaꞌa be gelete ipakafa heꞌahana yabe. To enali asaga kaga bite kaba boꞌanimofihi lu emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ya lago gihiti boꞌaniuba yaꞌmana koko panaꞌa kehe iloto ma luto lu emiꞌehina: Kai hapaka bati mehina liliꞌnalo bo yabe. Kai yataꞌa nanito yibi hanogo tinaka pa mesalata anaꞌa hilibe luto lu ketoꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nani yataꞌa kiginaga fi kimito heꞌmi ketoꞌohuna yabe. To hena huꞌehigo kai moneka liliꞌna neliꞌina bo kiginaga fi meemiꞌahane? ");
INSERT INTO bef_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ya luloto ana kaba boꞌamofihi gufagu logo bigo asaga tinaꞌa pa solotogo yabe luto nagaꞌi emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","To Yesu kagaꞌa ma luto lu su hoꞌehina: To lenali komopatinigu lenalalutinigihi foipanaꞌani li pa meso epolo baga meilana kokulumalugu Afoꞌnifu nohinauba ana huto lenali foipanatini li meheꞌmi lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu yaꞌma kaga lu epi su holoto Galili hepatogati heꞌmito Yutia kapogu, Yotani nagamiꞌi muya beletoga buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ya nobigo babu boanaꞌmagi megeꞌi melelete anaga nehetiꞌahana. Yesu analoꞌi enebesise bonaꞌi eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","To Felosi bonaꞌi moneꞌamagi ai nohinalo ete fi taga nehite loka heꞌahana: Lali keya kaguti henana niꞌigo bo moneuba lihaꞌamofihi faꞌmene leꞌmo heꞌmilenogo bati huto niꞌifiye? ");
INSERT INTO bef_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu lu epiꞌehina: Lenali mono bukugu bu gelete ana ka mekeheliꞌahanafiye? Yaꞌma kagaguti goꞌehina: Yataꞌa kanagu Huꞌmau bomo hiti aꞌmo hiti lolo hu moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ya lolo huꞌehinagi bouba itoꞌafihi afoꞌafihi nohaꞌatitiguti heꞌmito lihaꞌa leꞌmoto bigo etali nupa hite minete moneko bonaꞌi minalaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Etali loe bonaꞌi meminese hiteꞌatiti moneko bonaꞌi neminaꞌina yabe. Huꞌmau eteleꞌmo moneko huꞌehina alobole lenali bonaꞌmagita loko mehi etatalo. ");
INSERT INTO bef_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ya ligo Felosi bonaꞌmagi loka heꞌahana: Koyapa Moseu kaga moloꞌehinaꞌauba bo moneuba lihaꞌamoꞌmu fayahi goloto li emito leꞌmo heꞌmilubeꞌmu huꞌehinaya henabe lutobe? ");
INSERT INTO bef_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu lu epiꞌehina: Moseu komopatinigu sibina huseꞌna kehelito fayahi agobo luto lihaꞌamo leꞌmo heꞌmiloto ya hilina niꞌibe. Yataꞌa Huꞌmau asaga lolo huꞌehina kanaꞌagu ya heꞌmiloto meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nani lu nolepube. Bo moneuba lihaꞌa fato bolo mebuꞌehinamofihi leꞌmo heꞌmiloto fato aꞌi lilina huto gumina nofalabe, Yesu ya luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ya ligo koko panaꞌamagi lu emiꞌahana: Yana huseꞌnamo niꞌigo bomouba lihaꞌa meliloto faꞌmene minolenogo bati huto niꞌinagihe, lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu lu epiꞌehina: Asaga boanaꞌmagi enali yaꞌmana kaga melilanaꞌmu yabe. Huꞌmau ai bo lugaꞌamagihi amuya epiꞌehina, enali yaꞌma bomagigo lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kehelilo. Bo enali komopaꞌanigu kaga fato fatoꞌi niꞌinaꞌmu lite anaꞌi menelibe. Bo lugaꞌamagihi itoꞌanifu aꞌi melise minose bo enegetelata nehabe. To bo lugaꞌamagihi enugufa laga hago anaꞌi melise neminabe. To lugaꞌa bomagi kokuluma kapolo enekesa keheli emite minete mono ka fato fato melugu leliꞌali hilune lanamagi lihaꞌani melise minalune lite lu laga hite neminabe. Bo moneuba yaꞌma kaga keheli bati hilube lilina ai keheli bati hino. ");
INSERT INTO bef_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yaꞌmana yupahi enali yagapanaꞌi lagaso mesoꞌa Yesutoga eneleꞌmete eꞌahana. Enali Yesu enugufalo yahi liloto nunumu hu epalalibe lite yabe. Ya nehago ana bonaꞌi Yesuhi koko panaꞌamagi ka epekiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu luꞌehina: Lenali yagapanaꞌi heꞌmi epelenogo nanitoga eno. Lenali eneleꞌmo memalalo. Kokuluma kapoya yagapana yaꞌmaꞌasimagihina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","To Yesu enugufalo yahi liloto lusa gi epoloto heꞌmi epoloto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mone yupahi bo moneuba Yesutoga nehetiloto loka hoꞌehina: Tisao, nani hetofa suhi hena huto hulotoꞌni minoba minoba hepaꞌi lilube? ");
INSERT INTO bef_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ya ligo Yesu lu emiꞌehina: Hena hibe luto hetofanamu noloka nohane? Moneko keneꞌisi nohina Huꞌma aisigo bati huꞌehibe. To kai minoba hepaꞌi lilube lutomo keya ka li pili koloto megeꞌi molobo. ");
INSERT INTO bef_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","To ana bouba Yesuhi loka hoꞌehina: Hena keya kabe? Ya ligo Yesu lu emiꞌehina: Keya ka ma luto niꞌibe: Kai bonaꞌi ho mefilibo. Kai bo alobole eteleꞌmo loko mehubo. Kai gumina mefolobo. Kai bo moneꞌmofihi faga faga lu meemibo. ");
INSERT INTO bef_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kai itokafinogo afokafinogo agoya hu etimibo. To kaika keleꞌmo bati hilana suhi luto kalalukagihi eneleꞌmo bati hubo. ");
INSERT INTO bef_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ya ligo neheya kola bouba luꞌehina: Yaꞌma asaga keya ka nani liyafa huto megeꞌi amoloꞌohube. Anaꞌina moneꞌa henana hiti hilube? ");
INSERT INTO bef_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ya ligo Yesu ana neheya kola bomofihi ma luto lu emiꞌehina: Kai bati huto minalube lutomo asaga feꞌnohaka buto bonaꞌi noepito efahi lilotoka guna ito musufalo bonaꞌi epibo. Ya hitogo hetofanaka kokulumalo minalibe. To kai ya huloto naniꞌi oto nemegeꞌi molobo. ");
INSERT INTO bef_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yaꞌmana neheya bouba Yesu lina kaga keheliloto ipagu gabu gigo ginaga fina bo kaga meluse buꞌehina. Henaꞌmugope ai feꞌnohaꞌa babu luꞌehina bo nohuto ai ana feꞌnohaꞌa fato bonaꞌi meepilube lutoꞌa ekesa kehelito buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","To Yesu koko panaꞌa ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Feꞌnohaꞌa hiti bouba ai kokuluma kapoꞌalo tilinaya aitoga sipi keta hu etalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nani moneꞌa hiti kaga lu lepilube luꞌehina. Kameli yagauba kata hetise nekaꞌmofihi hokolo kapoꞌagu nesiꞌasi keta besinogo tilinaya to feꞌnohaꞌa babu luto nina bouba Huꞌmamofihi kapoꞌalo bilubeꞌmu hilinaya sipi keta besilinaꞌmu yabe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Enali koko panaꞌa yaꞌmana kagaꞌa kehelilete topa helete ma lite liꞌahana: Ya latago minoba minoba hepaꞌi kuyuꞌafu lilinabe? lite Yesuhi loka heꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ya lago Yesu enubugu enogo fiya iloto ma luto lu epiꞌehina: Ma melugu bonaꞌmagi yaꞌmanana mehilanaꞌmu yabe. Huꞌmau aisigo asagaꞌna lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yesu ya ligo Pitau kagaꞌalo nonaꞌa lu emiꞌehina: Kai bu gobo. Lali asaga feꞌnohati heꞌmiloto kaiꞌi kemegeꞌi moloto noone. Ya nohuta lali henana liluta niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","To Yesu ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Alihi asagaꞌnamagi yuhufanago lolo hilina yupahi Kokulumaguti limiꞌehina Bo ai fana mehenagu minoto kibina bomofihi kefa hisalo minalinaꞌmu yabe. To naniꞌi nemegeꞌi melete mineꞌahana bomagita yaꞌmana yupahi 12 kefa hisalo minalanaꞌmu yabe. To lenali ya hilete Isilaeli nagaꞌi 12 magihi kaba hi epalalabe. ");
INSERT INTO bef_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","To enali bonaꞌi lugaꞌamagi nani kumu lite enekesa yigilete nohaꞌanifi enogonaꞌanifi enetaliꞌanigifi itoꞌanigi afoꞌanigihifi yagapanaꞌanifi to foyaꞌanifi heꞌmilete nanitoga alanamagi enali ananaꞌanilo babu lite lilanaꞌmu yabe. To enali bati huto minoba minoba hepaꞌi lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ya huꞌehina babu bo lugaꞌa yatai yataꞌa kohe kohe hite nebanamagi alihaꞌa yupahi alihi alabe. To babu bo lugaꞌa enali alihi nebanamagi alihi yupahi enali kohe tete bilanaꞌmu yabe. Yesu yaꞌma luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kokulumamofihi kapoꞌaya bo moneꞌmofihi sipi foyaꞌa niꞌina suhi luto niꞌibe. Ya huꞌehigo ai mone etehi foluguꞌi heleko limito buto bai nagami lolo hilina noseꞌna foyaꞌagu kifiꞌna li etalana panaꞌi noeneleꞌmabe. ");
INSERT INTO bef_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ai enali lugaꞌa liliꞌnalo panaꞌi hiti kaga lilete mone kina mone kina yatai lilana liliꞌnalo lilanaꞌmu yabe lina kaga komopaꞌani monetoga nemalabe. Ya luto lu epoloto ai bai nagaꞌi noseꞌna foyaꞌagu enoho lifigo bite liliꞌna liluneꞌmu nebabe. ");
INSERT INTO bef_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","To yege ti olopa nohago bo lugaꞌa hepaꞌi folagahaꞌagu faꞌmene fuli nehago ai bu enogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ya huloto ai lu epiꞌehina: Lenali bite foyaꞌnigu liliꞌna lilenogo nani mina eto huto lepilube. ");
INSERT INTO bef_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ya ligo enali biꞌahana. To fuligaha belo kanalo hiti to utehi yege liyofo nohina kanalo hiti ana suhi huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","To yege limi falalubeꞌmu nohigo tauniga nobinati bo lugaꞌa ho tilete nehago bu enogoꞌehina. Ya huloto ai ma luto lu epiꞌehina: Hena huꞌehigo lenali yatai malo faꞌmene ho tilete nehabe? Kana su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Enali kaꞌalo nonaꞌa lu emiꞌahana: Bo moneuba liliꞌna melimigo faꞌmene nohune liꞌahana. Ya lago ai lu epiꞌehina: Lenali hiti kaꞌmuya abite bai nagaꞌi foyaꞌnigu liliꞌna lilo. ");
INSERT INTO bef_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","To sinihi giseꞌna nohigo ana foya afoꞌafu kaba boꞌa kehe iloto ma luto lu emiꞌehina: Kai liliꞌna nelina bonaꞌi kehe ito mina epibo. Alihi eꞌahana liliꞌnalo panatogati hapi fito mina epimo buto yataꞌa kohe tete ete liliꞌna liꞌahanamagihi alihi epitogo su heno. ");
INSERT INTO bef_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","To enali yege limi falalubeꞌmu nohigo ete liliꞌna liꞌahana bonaꞌi kohe tete ete mone kina mone kina liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","To kohe tete ete yataꞌa liliꞌna liꞌahanamagi nehetilete lali efahi enohoto babu lito li nupa lite enekesa yigiꞌahana. Ya hana moneko suhi hite mone kina mone kina liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Enali ana minaꞌani lilete enugufagu logo bigo gulu gulu foya afoꞌafihi ma lite ka emekiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Yaꞌma alihi eꞌahana bonaꞌi liliꞌna hupamone kanasi liꞌahana minaꞌani lali limiꞌahata moneko legege suhi luto epiꞌahane. Ya huꞌehina lali keta liliꞌna sipi yege lanalo logobi hiti hiti huto lagabu liliꞌna liꞌohune. ");
INSERT INTO bef_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Enali ya lite lago enali kagalo nonaꞌa foya afoꞌafu ma luto enali folagahaꞌanigu mone nohina bomofihi lu emiꞌehina: Nalaluo, nani keleꞌmo negi noto faga melu ketoꞌohube. Kaga lutofi mone kinalo liliꞌna lilabe lugo komopati monetoga yataꞌa melelete alihi liliꞌna liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kai efahaka lito hepakaga bubo. Efahi kimiꞌohuna suhi luto alihi ete liliꞌna liꞌahana bonaꞌi epilubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","To hena huꞌehibe? Yaꞌmana naniꞌni efahaꞌniloti anaꞌina mone li huto hilube lilunaba bati mehilina niꞌifi? Nani hetofa suhi nohu ketonamo yaꞌmana hapaꞌnimu luto naniꞌi kipakafa nonahafihe? Ya luto foyamofihi afoꞌafu luꞌehina fono ka yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ya luloto Yesu ma luto molo emito luꞌehina: Yaꞌmana suhi luto bonaꞌi enali alihi alanamagi kohe talanaꞌmu yabe, to bonaꞌi enali kohe tete alanamagi enali alihi bilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Yelusale hepatoga bilubeꞌmu nohuto 12 aposolo nagaꞌa hiti eneleꞌmoto buꞌehina. Enali kapo melete nebite Yesu sumi ka ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Lenali kehelilo. Lali Yelusale hepato yatai notune. To nani Kokulumaguti limiꞌohuna Bo, enali neleꞌmete bite sipi mono bonaꞌi to keya kaga lu enelepise bonaꞌi enali enayanuga bilanaꞌmu yabe. Enali ka foya li netete to ho fililune lite kaga lu hetofa hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ya hilete enali Lomu gamanilo neleꞌmete binogo enali kiya yokolo ka li netete to naga osatu nibi yigilete to malipu yafalo noho fililanaꞌmu yabe. Ya hinogo loegi monegi yegegu akuꞌi ho tilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yaꞌmana yupahi Yemesinogo Yoninogo itoꞌatitifu, Sebetihi lihaꞌauba ana panaꞌale Yesutoga eteleꞌmoto oto melugu lipito minoloto moneꞌnalo loka halubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ya nohigo Yesu ma luto loka hoꞌehina: Henanakaꞌmu nokebesibe? Ya ligo ai Yesuhi ma luto lu emiꞌehina: Ma panaꞌni loemo nehaꞌina kai alihi gihiti bo lolo nohitogomo moneba kayahi lamagaꞌaga minenogo moneuba kayahi sogaꞌaga minenogo hilaꞌibe lutoka kaga molobo luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ya ligo Yesu ana aꞌi lu emiꞌehina: Noloka nohata kaga hapaꞌa hena kaga nolufi luto keheli bati mehuse nolane. Nanitoga huto hilina ekesa nagamiꞌi naluna legitana niꞌinagi letaliba ana konugutiba nalaꞌina niꞌifihe? Ya ligo etali liꞌahaꞌina: Leꞌali naluꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ya laꞌigo Yesu lu etimiꞌehina: Maꞌnaka lite letali nani yaꞌma nagami konuguti nalaꞌinaꞌmu yabe. Ya hilaꞌina ninaya moneuba nayahi lamagaꞌaga minenogo moneuba nayahi sogaꞌaga minenogo hilaꞌinamofihi hapaꞌaya nani nasanaꞌni meniꞌibe. Yaꞌmana kefa hisalo lugaꞌa bonaꞌmagihina yabe luto, nani afoꞌnifu li loloba hu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Enali nayahi luga luga su hago aposolo nagaꞌmagi yaꞌmana kaga kehelilete ana kogunale ka etemekiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ya nehago Yesu kehe i nupa huloto ma luto lu epiꞌehina: Lenali keheliꞌahabe. Kibina bo moneꞌmofihi nagaꞌa mone nagaꞌmagi eneleꞌmo laba hilete enali kaba nehi epalabe. To enali sipi bomagi boanaꞌmagi labaga liyafa hite lemegeꞌi malalabe tite amuya kaga lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yaꞌma suhi lenali folagahatinigu memineno. Mone bo lenali folagahatiniguti sipi bo minalube lutomo ai lenali kele kele botini minoto leneheꞌmeno. ");
INSERT INTO bef_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mone bouba lenaliꞌi kaba hu lepalalube lilinauba ai lenali koko kako panatini mineno. ");
INSERT INTO bef_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yaꞌma Kokulumaguti limiꞌehina Bo ai ana suhi huto nohibe. Bonaꞌmagi aito liliꞌna heꞌmete li etalabe luto meoꞌehina yabe. Ai boanaꞌmagitoga liliꞌna li epoloto eneheꞌmalube luto oꞌehina. To ai boanaꞌmagi kumu luto gufaꞌa heꞌmiloto asaga boanaꞌi foipanaꞌani pa so epalalube luto oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Enali Yeliko hepaꞌi heꞌmite nebago babu boanaꞌi enemegeꞌi lifite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Etubu pisi lina bo loemo kapo belehaꞌalo nehaꞌinagati Yesu noabe lanaꞌa kehelilete sipi kehe ilete ma lite liꞌahaꞌina: Tebitihi Panaꞌase. Kiginaga fi leꞌemibo. ");
INSERT INTO bef_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya nelaꞌigo babu boanaꞌmagi bohoya ka lite etubunepa ilete heꞌmiliyo liꞌahana. Enali ya lana etali mekehelise koyo koyo ite kehe napa ite liꞌahaꞌina: Tebitihi Panaꞌase. Kiginaga fi leꞌemibo. ");
INSERT INTO bef_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ya laꞌigo Yesu ho tiloto kehe i etimiloto ma luto etoloka hoꞌehina: Nani hena hu letatalugo nelaꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ya ligo etali lu emiꞌahaꞌina: Sipi Bo, kai leꞌubutiꞌa li gili hu leꞌetalane luto noluꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ya laꞌigo Yesu kekeꞌi sipi lu etotoloto yahaꞌa ana bomaleꞌi etubulo meko nohigo anaꞌasilo meleꞌisi etubuꞌatiti i gili higo asagaꞌna bu gelete Yesuhi megeꞌi melete biꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Enali Yelusaleꞌi o leba telete Betefasi hepa kegiꞌa Oliba kosagu nehetiꞌahana. Ya hilete Yesu aposolo panaꞌa loemo ma luto lu etototo etoho lifiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Letali hepaꞌi monelugu nehetilete ana hepalugu toki yaga naga iꞌehinogo nalaꞌa hiti nehinogo bu galaꞌinaꞌmu yabe. Letali ana yaga nagaꞌa gulu fete eteleꞌmete nanitoga aliyo. ");
INSERT INTO bef_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","To bo moneuba kaga mone nolinogomo ma lite lu emiliyo: Sipi Bouba liliꞌna lilubeꞌmu yabe liꞌinogo ai hololu luto letiminogo ana yagale yete aliyo. ");
INSERT INTO bef_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yaꞌmanana huto hilinaya koyapaꞌi kaga lu huto huto bouba kaga mone ma luto luꞌehinalo pa salinaꞌmu yabe: ");
INSERT INTO bef_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lenali Yelusale hepatoga neminana bonaꞌi ma lite lu epilo: Bu galo, lenalitoga kibina botini noabe. Ai koyone bo, ai toki yaga gupisalo minoto noabe. Ai toki yaga ikeleꞌamofihi gupisalo minoto noabe. ");
INSERT INTO bef_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","To loe aposolo bomaleꞌi kohe toga bite Yesu lu etimiꞌehina suhi liꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Etali toki yaga lalamehi eteleꞌmete aꞌigo enali kefeꞌani toba hete ana toki yaga gupisalo meleꞌahane. Ya hago Yesu ana toki yaga gupisalo tito minoto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ya nehago babu boanaꞌmagi guketeꞌani toba hete kapogu molo helele tete nebago to lugaꞌa bonaꞌmagi yafa yahaꞌa yegete kapogu melete biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","To enali kohe toga bana bonaꞌi hiti to alihi bana bonaꞌi hiti ma lite kehe napa iꞌahana: Tebitihi Panaꞌa yege filo. Sipi Bomofihi giꞌalo ma noana bomofihi Huꞌmau lusana emilibe. Huꞌmamofihi lenegelo bi emilo. Ya lite babu boanaꞌmagi kehe napa ite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu Yelusale hepalugu notigo ana hepalugu boanaꞌi bu gelete henana huto nohifi lite ho ti baga ite ete li yege yege hilete liꞌahana: Yaꞌma bo kuyuꞌafube liꞌahana? ");
INSERT INTO bef_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To babu boanaꞌi Yesu hiti kapo melete banamagi ma lite liꞌahana: Ai kaga lu yege hose bomo Yesu Nasalete hepato Galili kegiꞌa bomo nohibe. ");
INSERT INTO bef_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu mono nonuga tiloto babu bonaꞌmagi bisinisi melete anaꞌinaꞌani salimi hila to mina fila hite nehana yaꞌma bonaꞌi hesiꞌehina. To hitalo efahi senisi hila to hitalo minete nama salimi hila nehanana libe behe hube huto li fulugu felege nobito eneleꞌmo tili tele huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","To ai kaga ma luto lu epiꞌehina: Mono bukugu Huꞌmau ma luto kaga koyoꞌehina: Nani nohaꞌni numuna nohaꞌni yabe lite giꞌa nehabe. Ya huꞌehina lenali ana nohi guminalo bomagihi suguna hepaꞌani li lolo nehabe. ");
INSERT INTO bef_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ya luloto Yesu mono nonuga nohigo enubu pisi luꞌehina bonaꞌi lugaꞌa hiti to enalapusa sibina huꞌehina bonaꞌi lugaꞌa hiti enali Yesutoga ago eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ya huto Yesu hetofana li huto nohinaꞌmu lite yagapanaꞌi mono nonugu nehanamagi sipi kehe ilete: Tebitihi Panaꞌa yege filo liꞌahana, ya nelago mono bo hiti to keya kamofihi tisa bo hiti enali bu gelete enitaluga logo biꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ya higo enali bu gelete Yesuhi ma lite lu emiꞌahana: Ma nelana kagaba keheliꞌahapihe? Ya lago Yesu lu epiꞌehina: Nani keheliꞌohube. Mono ka mone ma luto nina lenali leka meseꞌahana niꞌifihe? Kai lagaso yagapanaꞌi hiti to yagapana ikilihaꞌa hiti enali Huꞌmamofitoga enegelo bi emilabe. ");
INSERT INTO bef_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ya luto lu epiloto ai enalitogati heꞌmiloto Betani hepatoga buto ana foluguꞌi minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu Betani hepatogati etehi i behe huto Yelusale hepato noago kapogu kauꞌna hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ya higo ai nemuya yafa kapo belehaꞌalo nina bu goloto buto legeyaꞌa niꞌifi luto bu gana hayaꞌago niꞌigo ana yafamofihi ma luto lu etoꞌehina: Kai alihi yupahi legeyaka huto mehilibe. Ya ligo anaꞌasilo meleꞌisi ana nemuya yafa hayaꞌa hiti to lufusaꞌa hiti logo bi su hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ya higo Yesuhi koko panaꞌamagi topa helete ma lite liꞌahana: Hena suhi luto nemuya yafa meleꞌisi logo nobibe? ");
INSERT INTO bef_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ya lago Yesu kaꞌanilo nonaꞌa ma luto lu epiꞌehina: Lenali lenekesu meheno. Lenali komopatini nanitoga melelete lenali loe lae komopatini meminalina nani ma nemuya yafamofihi huꞌohuna suhi hilanaꞌmu yabe. To lenali yaꞌma sunogo mehilanaꞌmu yabe. Ma kosamofihi ma lite lu emilanaꞌmu yabe. Ma kosa ho tito hege nagamilugu limibo lilana lenabaga liyafa huto limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lenali komopatini Huꞌmamofitoga melelete anaꞌina mone kumuꞌi nunumu hilana ana nunumutinilo nonaꞌa lilanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu mono nonuga akuꞌi oto tito minoto boanaꞌi kaga enelepito minoꞌehina. Ya nohigo enali mono bo hiti to Isilaeli hepato enikibina bo hiti enali Yesutoga elete ma lite loka heꞌahana: Hiyaꞌagati lito oꞌahata suhi li huto nohane? Yaꞌmana suhi kuyuꞌafu kelepiꞌehina suhi nohane? ");
INSERT INTO bef_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ya lite loka hago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Nani ana huto kaga moneꞌya lenoloka halube. To lenali kaga lenoloka haluna kaga lu niminogomo nani ana huto kagatinilo nonaꞌa hiyaꞌagati lito oꞌohuna suhi li huto nohufi lu lepilube. ");
INSERT INTO bef_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ya yagi Yoni bonaꞌi nagamiꞌi folo epoloꞌehina, yaꞌmana nagamiꞌi folo epoloseꞌna hiyaꞌagati oꞌehibe? Huꞌmamofitogati oꞌehifi to ma melugu bomagitogati oꞌehibe? Ya luto enoloka hago enali yaꞌmana kaga kehelilete musi musi ka lite ma lite liꞌahana: Huꞌmamofitogatiꞌna yabe liluta ai ma luto lilinaꞌmu yabe. Hena huꞌehigo lenali Yonihi komopatinigu li menemalabe lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","To ma melugu bonaꞌmagihina yabe liluta ya asaga boana kumuꞌi lelesa nolibe. Henaꞌmugope enali asagaꞌi Yoni kumu kaga lu yege nohana bo nohibe lite komopaꞌani neeminamo yabe liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ya lite lilete enali Yesuhi ma lite lu emiꞌahana: Lali mekeheliꞌohune. Ya lago Yesu lu epiꞌehina: Hiyaꞌagati lito oꞌohuna suhi nani li huto nohufi nani ana huto hapaꞌa lu melepilube. ");
INSERT INTO bef_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ya huꞌehina ma kaga lenali hena hibe lite lenekesa nekehelibe? Bo moneꞌmofihi panaꞌa loemo mineꞌahaꞌina yabe. Mone yupahi panaꞌa yegeꞌa nohinaga buloto ma luto kaga lu emiꞌehina: Panaꞌni, kai yatai foyagu buto liliꞌna libo. ");
INSERT INTO bef_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","To panaꞌauba baga li gofa hoto luꞌehina: Nani ya liliꞌna melilunaꞌmu yabe. Ya luto luloto alihi minoto komopaꞌa i gelehe huloto foyaga buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Afoꞌatitifu mone panaꞌamofihi ana luto lu emiꞌehina yabe. Ya higo mone panaꞌauba afoꞌatitifihi lu emiꞌehina: Afoꞌniga nani foyagu buto liliꞌna lilunaꞌmu yabe. Ya luto faga oꞌyo luloto ana foyaꞌanigu liliꞌna buto meliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yalo lenali lu nimilo luto Yesu luꞌehina: Yaꞌma loe panaꞌmaleꞌi kuyuꞌafu afoꞌatitifu lu etimina kagalo megeꞌi moloꞌehibe? Ya ligo enali Yesuhi lu emiꞌahana: Yege panaꞌauba yabe lite, ya lago Yesu ma luto lu epiꞌehina: Nani lusiga luto lu nolepube, takisi efahi nelina bo hiti to mokolo anaꞌi hiti enali kohe tete Huꞌmamofihi kapoꞌagu nebabe. ");
INSERT INTO bef_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Henaꞌmube? Yoniu lenalitoga oloto ai mino bati huto minosemofihi hapa hapaꞌa lenelepiꞌehina lenali ai kagaꞌa keheli meemiꞌahabe. Ya hago enali takisi efahi lise bo hiti to mokolo anaꞌi hiti enali Yonihi kagaꞌa aliyafa hiꞌahabe. Lenali yaꞌmanana huto hina abu geꞌahanaya lenali alihi komopatini i gelehe hite li latahatinigu memeleꞌahabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ma bame ka moneꞌya akuꞌi kehelilo, luto Yesu lu epiꞌehina. Bo moneꞌmofihi sipi foya niꞌigo ana foyaꞌagu bai nagaꞌi hekololoto gegisa hu bego huꞌehina. Ya huloto yatama nohi ana foyagu giloto bai nagamiꞌa letiseꞌna mone lolo huꞌehina yabe. Yalo ai ana foya bisinisi malalubeꞌmu hina bomofihi yanuga biꞌehina. Ya huto emiloto ai ana foya afoꞌafu bonohi foto kapoga buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Alihi noseꞌnaꞌa li nupa huse kanaꞌa o leba tolago ai liliꞌnalo panaꞌa enoho lifigo bai nagaꞌi foyagu liliꞌna nelina bo nehanalo biꞌahana. Ai noseꞌna lugaꞌa nimilabe luto enoho lifigo biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ya higo enali ana foyagu liliꞌna nelina bomagi koko panaꞌa eneleꞌmete bilete moneꞌamofihi osahi nehete moneꞌamofihi ho fala nekite to moneꞌamofihi efa kosatu heꞌmibe molobe hite i yopo hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ya hago foya afoꞌafu koko panaꞌa moneꞌa hiti akuꞌi enoho lifiꞌehina yabe. Ai babu luto enoho lifiꞌehina yabe. Ya higo enali foyagu liliꞌna nelina bomagi ana suhi hite enegene mane ilete yataꞌa hiꞌahana suhi hi epeleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","To alihi aiꞌa panaꞌa ho lifigo enalitoga limiꞌehina. Ya nohigo afoꞌafu ma luto luꞌehina: Enali panaꞌnimofihi kagaꞌa keheli emilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ya higo enali foyagu liliꞌna nelina bomagi ana panaꞌa bu gelete ma lite musi musi ka liꞌahana: Yaꞌma bouba ai afoꞌafihi feꞌnohaꞌa li su halinaꞌmu yabe. Lenali ho tilo, lali mana panaꞌa ho fililototi yaꞌmana foyaꞌa laliti lilune. ");
INSERT INTO bef_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ya lilete enali ana foyaguti leꞌmo fegutoga melelete ho filiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yalo lenali henabe lite nekehelibe luto Yesu enoloka hoꞌehina: Alihi foya afoꞌafu oloto foyagu liliꞌna nelina nagaꞌi hena hu epalalina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ya luto Yesu enoloka hago enali ma lite lu emiꞌahana: Ai oto yaꞌma foipa bonaꞌi eneleꞌmo asagaꞌi sibina hu epoloto enahalinaꞌmu yabe. Ya huloto ai ana foyaꞌa lito fato bo epinogo kaba nehite kana noseꞌnaꞌa huto nohinogo enali lite bite foya afoꞌafihi aiꞌa lugaꞌa emilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ya lite lago Yesu ma luto lu epiꞌehina: Mono bukugu kaga mone ma luto nina lenali mekeheliꞌahafihe? Liliꞌnalo bomagi yaꞌma efahi bati mehina efahi yabe lite li heꞌmiꞌahana. Yatai yaꞌmana efahuba nohi nekisaꞌa li tokolo huꞌehibe. Sipi Bouba ai yaꞌmana suhi li huto higo lali bu gota laga gofa hibe. ");
INSERT INTO bef_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yaꞌmu luto nani lu nolepube. Huꞌmau ai kapoꞌa lenalitogati lenebe silito fato boanaꞌmagi enali bati liliꞌna ma melugu lite nehilanamagihi epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","To mone bouba ai ana efapo gupisalo heleko malalina ai ibe laga hube huto gufaꞌa nesi nesi hilinaꞌmu yabe. To yaꞌmana efahuba bo moneꞌmofihi limo ito i lilika ilinaya ana bo gufaꞌa mumusopa lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Enali mono bo hiti to Felosi bo hiti Yesu luꞌehina bame ka kehelilete lalitoga lu moloto nolibe lite akeheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ya hilete enali yato liluneꞌmu nehana. To Yesu kumu lu yege hose bo nohifi boanaꞌmagi lite nehite Felosi bomagi enali kumu koli hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu bame ka mone hiti ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kokulumamofihi kapoꞌaya gihiti bo moneꞌmofihi hapaꞌa legita huto niꞌibe. Gihiti bomofihi panaꞌauba lihaꞌa liꞌehigo afoꞌafu sipi noseꞌna laita huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya huloto koko panaꞌa enoho lifigo enali bite bonaꞌi noseꞌna nalabe lite kehe iꞌahana, ya hago ana bonaꞌmagi mebilune liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","To ai koko panaꞌa akuꞌi moneꞌa enoho lifito ma luto lu epiꞌehina: Nani bonaꞌi kehe iꞌohuna bonatoga lenali bite ma lite lu epilo: Hohe, hohe. Lenali kehelilo. Nani noseꞌna ali loloba huꞌohube. Nani bulumaka yagaꞌni boꞌa hiti to yagakafa gilibaꞌa hiti hoto linohi biꞌohube. To asagaꞌnaya ali loloba hugo nose molose huto niꞌibe. Lenali ete ana kata nohuna noseꞌna nalo. ");
INSERT INTO bef_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ya luto lu epigo enali koko panaꞌamagi ana kaga lite bite kehe ina ana bonaꞌmagi ana kaga koseleꞌani enahago mekehelise bu folola e felela hiꞌahana yabe. Moneuba foyaꞌaga nobigo moneuba bisinisi liliꞌnaꞌalo nobigo hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ya nehago lugaꞌa bonaꞌmagi ana gihiti bomofihi koko panaꞌa enayato lilete naga osatu lugaꞌa nebiyigite to luga enoho filiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ya hago gihiti bouba italuga logo bigo gimi boꞌa enoho lifigo bite koko panaꞌa eneheꞌahana bonaꞌi nohaꞌa gobe posa gibe hite enoho su heꞌahana. Ya hilete hepaꞌani logo goyoboto su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ya huloto gihiti bouba koko panaꞌa kehe iloto ma luto lu epiꞌehina: Ana kata huse noseꞌnaya laita huto li loloba huꞌohuta ma ninaya to bonaꞌi kehe uta bonaꞌmagi hapaꞌani bati mehigo meabe. ");
INSERT INTO bef_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ya huꞌehinagi lenali kapo loe lae huꞌehinalo bite nehite bonaꞌi bila ela hilana enaliꞌi kehe i nupa hite eneleꞌmete enogo ana kata noseꞌna nalabe. ");
INSERT INTO bef_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ya luto lu epigo ana koko panaꞌamagi kapolo kapolo bite mine baga iꞌehite bonaꞌi manaꞌafi to sibina hanaꞌafi kapolo huto hana kehe i nupa nupa hite eneleꞌmete ago enali ana kata nehana nohi li bai tete mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Enali boanaꞌi tite mine su helago gihiti bouba bu enagalubeꞌmu nonuga tiꞌehina. Ya huloto ai bo mone gukete manaꞌa li mehekoloꞌehina bo nohina bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","To gihiti bouba yaꞌmana bo ma luto lu emiꞌehina: Nalaluo, kai hena hibe luto kimiꞌohuna gukete manaꞌa mehepise ma nonuga tiꞌahane? Ya luto loka hago ana bouba ai kaga meluse faꞌmene minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ya higo gihiti bouba koko panaꞌa ma luto lu epiꞌehina: Lenali ma bo gilo, yato naga ite fegutoga heꞌmi melenogo ai metepugu minalibe. Ai ana metepugu nohuto yibi nama huloto baga yogoꞌa henibe yugupobe hilibe. ");
INSERT INTO bef_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu kagaꞌa lu pa so su hoto luꞌehina: Huꞌmau bonaꞌi babu lito kehe ilata nohibe. Ya huloto ai ana bonaluguti moneꞌisi moneꞌisi eneleꞌmalinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Enali Felosi bonaꞌmagi Yesuhi fi taga huto kaga loka mika halune lite enali lu keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To enali panaꞌaloboꞌani hiti to Helotihi panaꞌalobo hiti enoho lifigo Yesutoga bite ma lite liꞌahana: Tisao, kai maꞌnakago lu epilata nohanogo lali akeheliꞌohune. To kai maꞌnakago luto Huꞌmamofihi hapaꞌamu babu boanaꞌi kaga lu enelepilata nohane. To kai moneko bomofi kumuko luto kekesa yigiba yigiba mehulata nohane. Kai asaga bonaꞌi moneko kagago lu epilata nohata bo nohane. ");
INSERT INTO bef_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ya huꞌehinagi kai ma kaga lu limibo. Kai henabe luto kekesa noyigine? Lomu gamani bomofito takisi heꞌmilata nohutaba lali keya kagati li gofa nohopi to bati huto noheꞌmune? Ya, kagatilo nonaꞌa lu limibo. ");
INSERT INTO bef_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu miꞌi malaluneꞌmu nehana kagaꞌani akeheliloto ma luto lu epiꞌehina: Lenali fagalo bonaꞌi. Lenali henabe lite nimiꞌi nemalabe? ");
INSERT INTO bef_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi efahi legeyaꞌa moneꞌa li nelepilo. Ya ligo enali efahi legeyaꞌa mone li emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ya hago ai li enelepiloto enoloka hoꞌehina: Ma okabaꞌa hiti giꞌa hiti kiyiꞌafihina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sipi Lomu kaba bomofihinaꞌa niꞌibe, liꞌahana. Ya nelago Yesu ma luto lu epiꞌehina: Ya hinogomo Lomu kaba bomofihi nasanaꞌa emilo, to Huꞌmamofihi nanaꞌaya Huꞌmamofitogago emilo, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu ya luto kagaꞌanilo nonaꞌa lu epina kaga hapaꞌa kehelilete keka keka latahaꞌanitu hilete abifa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ana yupahisigo Satusi bonaꞌi Yesutoga eꞌahana. Enali yaꞌmana bomagi filise bonaꞌi akuꞌi ho metilabe lite lilata nehana yabe. Ya nehana bomagi Yesutoga elete ma lite loka heꞌahana: ");
INSERT INTO bef_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tisao, Moseu ma luto luꞌehibe. Bo moneuba yagapanaꞌi meketose nohuto fililenogo ana bomofihi gonauba goꞌafihi aꞌi liloto yagapanaꞌi filiꞌehina bomofihi nonaꞌa ketalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To koyapaꞌi sebeni koguna mineꞌahana, enogoꞌanifu lihaꞌa liloto yagapanaꞌi meketose filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ya higo gonaꞌauba ana aꞌi liꞌehina ana huto yagapanaꞌi meketose filiꞌehina. Ya higo ana megesalo gonaꞌauba ana aꞌi liloto ana suhi huto yagapanaꞌi meketose filiꞌehina. Ya hite asagaꞌi ana kogunamagi ana aꞌi lina yagapanaꞌi meketese fili su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ya hilago alihi ana anaꞌi filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Asaga bonaꞌi filiꞌahanagati akuꞌi ho tilana yupahi ana koguna sebeniꞌa ho tilana ai ana aꞌiba kiyiꞌafihi lihaꞌa lolo hilina niꞌibe? Asagaꞌi sebeniꞌa kogunamagi ana aꞌi lihaꞌani leꞌmo lolo hiꞌahana yabe. Enali ya lite Yesuhi loka heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ya lago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Lenali mono ka hiti to Huꞌmamofihi amuyaꞌa hiti keheli bati mehiꞌahabe. Lenali lenekesa yigiseꞌnatini asagaꞌi sibina huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bonaꞌi filiꞌahanagati ho tilana yupahi bo hiti aꞌi hiti li bo alobo mehilana kokulumalugu agelomagi suhi hite minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya huꞌehina yaꞌma filise bonaꞌi akuꞌi ho tise kagamofihi lenoloka halube. Mono bukugu Huꞌmau ma luto lu lepiꞌehina kaga mekeheliꞌahafihe? Ai ma luto luꞌehibe: ");
INSERT INTO bef_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nani Abalahahi afoꞌafita nohube, to nani Isakahi afoꞌafita nohube, to nani Yakopuhi afoꞌafita nohube, luto Huꞌma luꞌehina yabe. Huꞌma ai filiꞌahana bonaꞌmagi afoꞌanifu menohunagi enali minoba minoba bonaꞌmagihi afoꞌanifita nohibe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To asaga boanaꞌmagi Yesu enelepiꞌehinanaꞌmu lite enegelo biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesu lina kagauba Satusi bomagihi enabagalo ifi tago enali kaga meluse mineꞌahana. Ya hite Yesuhi kagaꞌauba enoho fi tago kaga melise nehago Felosi bomagi be gelete enali Yesutoga ete li nupa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ya hago keya ka tisa bo moneuba Yesuhi loka mika hoto miꞌi malalubeꞌmu huloto ma luto loka hoꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisao, hiya keya kauba asaga keya ka enebe ligito sipiꞌa niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ya luto Yesuhi loka hago Yesu ma luto lu epiꞌehina: Sipi bo ai Huꞌmakafu yabe. Kai asaga kugufaka hiti kemehaka hiti kekesa yigiseꞌnaka hiti to asaga komopaka Huꞌmamofihi aisigo emi su hobo. ");
INSERT INTO bef_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yaꞌma keya kaya ai kohe toto sipi keya ka niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","To ana megesalo keya kaya yataꞌa keya kamofihi suhi huto moneꞌago huto nesiꞌa niꞌibe. Ai ma luto niꞌibe: Kaika kugufaka leꞌmo bati huto kaba nohata suhi luto kigi bonaka koyone hu epito eneleꞌmo bati hu epolobo. ");
INSERT INTO bef_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yaꞌma keya ka loemaleꞌi hapaꞌa lufusaꞌa lolo hite emalo keꞌahaꞌigo lugaꞌa Moseu luꞌehina keya ka hiti to kaga lu yege hese bomagihi enelepimofaꞌna huseꞌnaꞌani ifo etali etugupisalo neminabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Enali Felosi bonaꞌi li nupa hite analo nehago Yesu ma luto enoloka hoꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Lenali Mesia kumu hena hibe lite nekehelibe? Ai kiyiꞌafihi panaꞌa nohibe? ");
INSERT INTO bef_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya luto enoloka hago enali ma lite lu emiꞌahana: Tebitihi panaꞌamo nohibe. Ya lago Yesu lu epiꞌehina: Ya lanagi to hena higo Sikalafuꞌuba Tebitihi leꞌmo kugu higo ho tito Sipi Boꞌnibe luꞌehinabe? Yalo Tebitiu ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Sipi Bo Huꞌmau ma luto nani Sipi Boꞌnimofihi lu emiꞌehina: Kai nayahi lamagaꞌnilo minolotoka to nani fatehaka enoho su holenogo, melugu minelenogo, kai kigigusatu ifi to epalalane. ");
INSERT INTO bef_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tebitiu aiꞌa Sipi Boꞌni yabe luto gi moloꞌehinamo to akuꞌi hena hibe luto Mesiau Tebitihi tataꞌafu lolo hilibe? Ya luto Yesu enoloka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ya luto enoloka hago bo moneuba ho tito Yesuhi loka mehalinaꞌa huꞌehina yabe. Yaꞌmana yupahi Yesuhi kagaꞌalo koli hilete alihi yupahaꞌa loka meheꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Alihi Yesu babu boanaꞌi li gehesa hite minana hiti to aiꞌa koko panaꞌa hiti kaga ma luto beto hu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kaga keheli bati huse bo hiti to Felosi bo hiti enali Mosehi keya kamofihi hapaꞌa lu hokolo hise minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ya huꞌehinagi enali kaga lu lepilete ya hilo ya hilo nelinogomo lenali enabaga liyafa hite enemegeꞌi melete minalo. Ya huꞌehina moneꞌnaya enali bati mehina suhi li huto nehinogomo lenali ana hapaꞌamofihi enemegeꞌi memalalo. Enali babu kaga fato fatoꞌi lilata nehanaya ana kaga enaliꞌani megeꞌi melelata menehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Enali kaga lu keta fi epilete enaliꞌani mino saga hiꞌehite enayatu meeneheꞌmelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Asagaꞌna li huto hilata nehanaya enali bonaꞌmagi bu galabe lite li huto hilata nehabe. Enali mono ka fayahi geꞌahanana enogo gobisalo li hekelela to numuna fayahi geꞌahanana enayanugu sahi bila to yatama guketeꞌaniga naga ilago limila hite li hekelelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mono nonugu enali Felosi bonaꞌmagi kefa hisa bati hinalo bona folaganugu mino saga hite nehago asaga bonaꞌmagi lenebe tigite lenigitini bona enubulo li saga hilata nehabe. To asaga bonaꞌi li gehesa hite noseꞌna nete minelata nehanagu ana hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Enali bonaꞌmagi folagahaꞌanigu bite ho tite nehago asaga bonaꞌmagi enofokehi lite enugufaga soso hu epelelete Tisao lite ligiti halabe lite hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ya huꞌehina lenali kumuꞌi Tisao lite lenigi meheno. Moneko bo nohina aisigo tisa botini nohibe, ya huꞌehinagi lenali koguna ite minalo. ");
INSERT INTO bef_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","To ma melugu bo moneꞌmofihi afotifu yabe lite gi mehalo. Afotinifu monekoꞌisi aiꞌasigo kokulumalugu nohibe. ");
INSERT INTO bef_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Enali lenikibina bonaꞌi yabe lite lenigi memeleno. Lenali kibina botini moneꞌisi nohina ai Mesia nohibe. ");
INSERT INTO bef_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ya huꞌehina lenali folagahatiniguti kaba botini ai lenali koko panatini mineno. ");
INSERT INTO bef_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","To bo moneuba giꞌa li saga huloto hutu hata hilina ai giꞌa alihi melugu limo ilinaꞌmu yabe. Bo moneuba giꞌa li saga mehuse legeso huto minalina alihi sipi gihiti bo minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lenali kaga keheli bati hulata bo hiti to Felosi bo lenali, ehetinio, kaba hite mino sepa ite minalo. Lenali loe ka luse bo nehabe. Lenali boanaꞌmagihi enubulo kokulumamofihi kasihaꞌa li hekini lelata nehabe. Lenalitini ana kapoꞌalo metise nehite boanaꞌmagi tiluneꞌmu nehana ana kapo lenali li hokolo mehi epelelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lenali keya kaga keheli bati huse bo hiti to Felosi bo, ehetinio, lenali kaba hite minalo. Lenali loe lenabaga hiti bo yabe. Lenali keto anaꞌmagihi nohi feꞌnohaꞌani kaꞌi legelata bo yabe. To lenali yaꞌmana foipanatini yatama nunumu lilete ifi telata nehanabe. Lenali osahi lepilinaꞌa hofa talibe. ");
INSERT INTO bef_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Keya kaga kehelise bo hiti Felosi bo, lenali ehetinio. Lenali loe kaga lulata bo lenabaga kaba hilo. Lenali koko boti lilune lite mone bo ai mono kagatimofihi megeꞌi malalibe lite hege nagami beletoga to hepato hepato sa sa hilata bo yabe. Ya hite, koko panatini leꞌmeletemo akuꞌi lenali logo kapolo lenalitini suhi lite leꞌmo melelata nehabe. Ya huꞌehina ai lenebege ligito babu luto foipanaꞌa nominabe. ");
INSERT INTO bef_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lenali lenubutini pisi lina bomagita bonaꞌi kapo enelepilune lite nehafiye? Ehetinio, lenali kaba hu bati hilo. Lenali ma lite lilata nehabe: Bo moneuba Huꞌmamofihi mono nohaꞌa gi holoto lusiga luto ifogati yabe lilinaya faꞌmene yabe lilata nehabe. Ya huꞌehina bo moneuba fayahaꞌa lubo labo lina goli efapo gi holoto maꞌnaka luto ifogati Huꞌmamofihi nohaꞌa yabe lilina. Yalo ai ana luꞌehina kaꞌa megeꞌi moloto anana li huto hino. ");
INSERT INTO bef_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lenali lenubu pisi luto negi nagi bo. Henana ai sipina niꞌibe? Ai goli sipina niꞌifi to Huꞌmamofihi nohaꞌauba golimofihi leꞌmo lagaso nohibe? ");
INSERT INTO bef_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","To lenali ma lite lilata nehabe: Bo moneuba Huꞌmamofihi emise nasana emilata nehana hita gi holoto ifogati maꞌnaka nolube nolina, ya bati huto yabe. Ya huꞌehina to emise nasana hitalo ninamofihi gi holoto maꞌnaka luto ifogati yabe lilina, yalo ai luꞌehina suhi lino. ");
INSERT INTO bef_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lenali lenubu pisi lina bo. Henana ai sipina niꞌibe? Ai emise nasana sipina to nasana hitauba emiseꞌnamofihi leꞌmo gi nobibe? ");
INSERT INTO bef_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ya huꞌehina to bouba ai Huꞌmamofihi emiseꞌna go emise hita gi holoto ifogati nolube lilina, ai asagaꞌna emiseꞌna hitalo ninana hiti to ana hitamofi hiti kagaꞌamofihi lu amuya nomalabe. ");
INSERT INTO bef_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","To bo moneuba Huꞌmamofihi mono nohaꞌa gi holoto maꞌnaka luto ifogati nolube lilina, ai Huꞌmamofihi sipi nohaꞌa hiti to Huꞌma ana nonuga nohibe luto kehelito kagaꞌamofihi lu amuya nomalabe. ");
INSERT INTO bef_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","To bo moneuba kokulumaꞌi gi holoto maꞌnaka luto ifogati nolube nolina ai kefa hisa hiti to Huꞌma, anaga nomina bo hiti to bo ana kefa hisalo nohinaꞌmu luto kagaꞌa lu amuya nomalabe. ");
INSERT INTO bef_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lenali keya kaga keheli bati huse bo hiti Felosi bo, ehetinio. Lenali loe kaga lilata bo lenabagatini kaba hu bati hilo. Asagaꞌna yuhufa foyagu niꞌinana guna ite nayahi luga luga su hago melelete nayahi su hanaꞌamofihi Huꞌmamofihi emilata nehabe. Ya hiꞌahana lenali asaga kaga nekisaꞌaga sipi loto ninamofihi heꞌmilata nehabe. Bonaꞌi eneleꞌmo bati huse kagafi, bonaꞌi hiti koguna ito minoseꞌnafi to komopatini monetoga molosemofihi kaga hapa heꞌmilata nehabe. Nayahi luga luga su hana batiꞌna ninaloti nesiꞌasi Huꞌmamofihi emise kaga meheꞌmilutaya ma sipina ninauba li yege halibe. ");
INSERT INTO bef_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lenali lenubu pisi lina bo bonaꞌi kapo enelepiluneꞌmu nehafihe? Lenali guya noseꞌnagu umeꞌumeꞌi noagomo hesi neheꞌmite to kameli yaga noagomo lenali faꞌmene asagaꞌi mikili helata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Keya kaga keheli bati hulata bo hiti to Felosi bo, lenali ehetinio. Lenali loe lenabaga hiti bo lenabaga kaba hilo. Lenali kohi to lapeꞌi gupisaꞌa loko sese hilata bo. Ya nehite guminanatini hiti to lenugufalo niꞌinanatu komopaꞌagu li bai telata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Felosi bo lenali lenubutini pisi luꞌehina. Yataꞌa kohi komopaꞌa luga okala huto li gulu gulu luletogo alihi gupisaꞌaga hiti ana huto gulu gulu lilibe. ");
INSERT INTO bef_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Keya kaga keheli bati huse bo hiti to Felosi bo, lenali ehetinio. Lenali loe lenabaga hiti bo kaba hu bati hilo. Lenali kene mala mala hepaꞌi koholi penituꞌi nefalanaꞌa hite nehabe. Fegutoga bu go bati huseꞌa ninaga to komopaꞌaluga filise bona felisaꞌanifi to asagaꞌna kolo tuba inana fato fatoꞌi babu luto bai toto minolata nohibe. ");
INSERT INTO bef_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lenali yaꞌma suhi lite nehabe. Bonaꞌmagi fegutoga lenugufa be gelete lenebebe sana bonaꞌi nehabe lite lilata nehabe. Ya hana komopatinigu faga faga lusemofihi to kaga li gofa hosemofihi fato fatoꞌi bai toto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lenali keya kaga kehelise bo hiti to Felosi bo, lenali ehetinio. Lenali kaga loe lulata bo kaba hu bati hite minalo. Lenali kaga leliꞌali bomagihi kene mala mala nohaꞌani gi epelelata nehabe, to lenali bebe sana bomagihi kene mala malato lose tose kifiꞌna fato fatoꞌi hekelelata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","To lenali ma lite lilata nehabe: Koyapaꞌi tatatigi mineꞌahana kanagu lali minotitaya tatatigi eneheꞌmoto kaga lu yege hose bo meenohotitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yaꞌmana kagauba lenalitini lu kuguma nohibe, lenali kaga lu yege helata nehana bo enoho fililata nehana bonaꞌi ana nagaꞌmo lenaliya nehabe. ");
INSERT INTO bef_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ya hite enali hapi fiꞌahago lenali kehelite enemegeꞌi melete ana suhi hime bilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lenali osifaꞌi yabe. Lenali foipa osifaꞌmofihi yagapanaꞌa yabe. Huꞌma ka foyagu leneleꞌmo malalinauba logo kapogu lenoho lifilinaꞌmu yabe. Hena hite lenali koli felenogo Huꞌmamofihi ka foyauba lenugufalo melilina niꞌibe? Lenali koli mehilanaꞌa huto niꞌibe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ya huꞌehinagi lenali kehelilo. Nani kaga lu yege hose bo lugaꞌa hiti, to latahaꞌanigu kaga bati huto niꞌilina bo hiti to mono ka keheli bati hiꞌahana bonaꞌi hiti lenalitoga enoho lifinogoꞌni bilanaꞌmu yabe. Enali folagahaꞌaniguti lugaꞌa enoho fililabe, to lugaꞌa malipu yafalo enahalabe, to lugaꞌa mono nohatinigu nehinogo naga osatuꞌi enibi yigilanaꞌmu yabe. To lenali mone hepatoti eneleꞌmo heꞌminogo fato hepalugu netinogo enegene mane ite eneleꞌmo fato hepato malalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","To enali komopaꞌani bati huꞌehina bonaꞌi melugu nehago lugaꞌa bonaꞌmagi enoho filiꞌahana, enali asaga yaꞌmana bonaꞌmagihi gumiꞌani lenali lenugufalo pa salinaꞌmu yabe. Bati bo Ebeli ai filiꞌehina, ya hulago analoti oto Sekalaiya ai Belakaiyahi panaꞌa, aiꞌi lenali mono nohi folagahaꞌagu ho filiꞌahana. Asaga yaꞌma bomagihi gumiꞌani lenalito oto pa salinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nani maꞌnaka luto lu nolepube. Asaga yaꞌmana gumiꞌanimofihi foipa minaꞌauba yatai ma nehana boanaꞌi enali enugufalo huto hilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hege, Yelusale bonaꞌise. Kaga lu yege hose bo kai enoho fililata hane, to Huꞌma liliꞌnalo bo kai kumu luto enoho lifigo limina kai efa kosatu enoho nofiline. Babu yupahi yagapanaka nani eneleꞌmo nupa hilubeꞌmu hulata nohube. To nala kokoleuba yagapanaꞌa koketapaꞌaluga eneleꞌmo nupa nohina suhi luto leneleꞌmo nupa hilubeꞌmu nohunamo lenali melepesibe. ");
INSERT INTO bef_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lenali kehelilo, yatai hepatini faꞌmene hepaꞌi yafaꞌa minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nani yaꞌma kaga luto lu nolepunaya, lenali aku akuꞌi nani bu menegese mineme bite alihi yupahaꞌa ma lite lilana yupahi yabe, Sipi Bomofihi giꞌalo oꞌehina bo ai Huꞌmau be tigilibe luto lu emilibe. ");
INSERT INTO bef_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu mono nohi heꞌmiloto nobigo enali koko pananaꞌamagi aitoga eꞌahana. Enali sipi mono nohi niꞌinaꞌmu lepiluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ya hago Yesu ma luto lu epiꞌehina: Lenali ma asagaꞌna bu geꞌahafihe? Nani maꞌnaka luto lu nolepube, asaga efahi ma ninaya heꞌminogo ikupilo akupilo hite meminalinaꞌmu yabe. Enali ibe fologobe hite meluguko limo i su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Oliba kosagu nohigo koko pananaꞌamagi sugunaꞌi ete ma lite loka heꞌahana: Hiya yupahi yaꞌma asagaꞌna huto hilina niꞌibe? Hena huse kana yataꞌa huto hinogo, to yatai ma meꞌi su nohenogo kai alubeꞌmu nohane luto liluta niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kaꞌanilo nonaꞌa ma luto lu epiꞌehina: Lenali kaba hu bati hilo. Bo moneuba lenimiꞌi molo lalibeꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Babu bonaꞌi elete nani nigiꞌni nehete ma lite lilanaꞌmu yabe: Naniꞌni Mesia nohube. Huꞌmau noho lifiꞌehina bo lenubuto bilubeꞌmu nohube, ya lilabe. To enali babu boanaꞌi enimiꞌi malalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Lenali lebato luba nehanamofihi nogoꞌa kehelilanaꞌmu yabe. To fotoꞌi nehilana lubamofihi kagaꞌa kehelilanaꞌmu yabe. Ya huꞌehina lenali koli mehilo. Yaꞌma asagaꞌna huto hilinaya to ana su halina kanaꞌa manaꞌa huto mehuꞌehilibe. ");
INSERT INTO bef_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mone nagaꞌmagi ho tite mone nagaꞌi hiti luba hilanaꞌmu yabe. To mone gihiti bo moneꞌmofihi nagaꞌamagi ho tite mone kibina bomofihi nagaꞌa hiti luba hilanaꞌmu yabe. To babu hepatoga sipi kauꞌna enahalina to sipi imimaꞌi hiti lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Asaga yaꞌmana kana huto hilinaya aiꞌi moneuba yagapanaꞌi ketalubeꞌmu nohigo yataꞌa gabu foya nolina suhi luto huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yalo bomagi lenayato lite nagalugu leneleꞌmo melenogo kosele liliꞌna lilenogo alihi lenoho fililanaꞌmu yabe. To nani kumu lite asaga boanaꞌmagi lenipakafa halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yaꞌmana yupahi babu boanaꞌmagi komopaꞌani sibina hinogo enogoꞌanigihi eneleꞌmete bite fatehaꞌanimagihi enayanuga nebite to enaliꞌani enogonaꞌani fatehaꞌani eneleꞌmoloto hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","To kaga lu yege holata bo faga faga lite babu lite huto hilete babu boanaꞌi enimiꞌi molomofaꞌna hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Foipa faipa suhi sipiꞌa tili tele hulenogo babu bomagi enali koguna ito minoseꞌnaꞌani heꞌmi su halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ya huꞌehina bonaꞌmagi amuya melete nani kumu li pili kete nehago nani aku aluna Huꞌmau enubuto bilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","To Huꞌmamofihi kapoꞌamu luto ka lamanaꞌa yaꞌma asaga noto noto kapoga lu yege henogo asaga boanaꞌi kehelilete fato fato hepalugu bai toto ana kanaꞌa su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","To foipa bati mehina napauba hepaꞌi li sibina hulata nohina lenali bu galanaꞌmu yabe. To koyapaꞌi kaga lu huto huto bo Tanieliu ananaꞌmu aluꞌehina yabe. Yaꞌmanana ai hepaꞌi Huꞌmamofihi molo emise hetofa hepaꞌi folagahaꞌalo ho tito yaꞌma sibina huto hilinamoꞌmu kaga luꞌehina yabe. Bo moneuba yaꞌmana kaga leka soloto ai ekesa yigi fe lino. ");
INSERT INTO bef_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","To yaꞌmana yupahi Yutia melugu nehana lenali koli hite kosaguko tilo. ");
INSERT INTO bef_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","To bo moneuba nohaꞌa lebato nohutomo ai nohaꞌalugati feꞌnohaꞌa limito melino. ");
INSERT INTO bef_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","To bo mone foyagu nohutomo nohaꞌnigati guketeꞌni lilube luto mebino. ");
INSERT INTO bef_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Enali anaꞌi yaꞌmana kanalo yagapana hiti hiꞌehilana to yagapanaꞌi amihi epite minalanamagi kumu niginaga fi noepube. ");
INSERT INTO bef_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lenali nunumu hite minalo, ya hilete yasi hilina yupahifi to fuli yupahi lenali koli mefelese minalabe. ");
INSERT INTO bef_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yaꞌmana yupahi sipi keta huto minalinaꞌmu yabe. To meꞌi yuhufa huto hina kanaꞌalofi to koyapaꞌi yaꞌmana ketana huto mehuꞌehina yabe. To alihi yupa hiti ana ketana huto mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","To Huꞌmau yaꞌmana kana li hupa mone mehititaya asaga boanaꞌi ma melugu meminatitaꞌmu yabe. Ya huꞌehina Huꞌma ai eneleꞌmo eto huꞌehina bona kumuꞌi ekesu mehalibe. Yaꞌmu luto ai yaꞌmana kanaꞌa li hupa mone hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yaꞌmana yupahi bo moneuba ma luto lu epilibe: Bu galo. Mesia ma nohibe, eꞌe muyaga nohibe, ya luto nolinogomo lenali kagaꞌa keheli meemilo. ");
INSERT INTO bef_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","To faga faga Mesiagi to faga faga kaga lu yege hose bo babu lite nehetilete Huꞌmau eneleꞌmo eto huꞌehina bonaꞌa enimiꞌi malalune lite babeyafana lumofihi lumofihi fato fatoꞌi li huto hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lenali kehelilo. Yaꞌma kaꞌmu luto kohe toto yataꞌa kaga alu lepiꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ka melugu nohibe lite bonaꞌmagi nelinogomo lenali anaga kaꞌani liyafa hite mebilo. To bu galo. Magaꞌma fala kito nohibe lite nelinogomo lenali kaꞌani keheli meepilo. ");
INSERT INTO bef_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sopohi fi besa lolata nohina lenali akeheliꞌahabe, yaꞌmana kegiꞌati yege tiloto oto mobuto limi fololata nohinaga limi nofalabe. Ana suhi huto Kokulumaguti limiꞌehina Bouba nani aku alubeꞌmu hiluna yupahi alunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Filise bonaꞌi gufaꞌa mone hepatoga niꞌigomo anaga lupahi ete li gehesa hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu ka mone hiti luꞌehina: Ma melugu sipi ketana huto hilina su ho su nohenogo anaꞌasilo meleꞌisi yege fi metepu noinogo to ikahi melenogo asaga sonofiꞌi kokulumalugu nina melugu limo i su halabe. Kokulumalugu amuyana ninana mopo hu baga ilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yaꞌmana yupahi Kokulumaguti limiꞌehina Bomofihi gufa fayahaꞌa kokulumato huto nohinogo asaga boanaꞌi ma melugu nehanamagi yibi hu baga ilabe. To Kokulumaguti limiꞌehina Bo sopohi ifoꞌalo minoto noenogo bu galabe. To ai sipi amuyaꞌa hiti to sipi fana mehaꞌatu fi besa loto alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","To ai ageloꞌa babu lito enoho lifinogo enali ufehi fu linogo sipi nogo nomelenogo analo bonaꞌa eneleꞌmo eto huꞌehina guna ilinaꞌmu yabe. To enali meꞌi nekisaꞌa loegi loegi ninalo mine baga ilete anagati bonaꞌi guna ite ete bite meꞌi mone kegiꞌa nekisaꞌaga su halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nemuya yafaloti lenali manaꞌa be go fiya ilete lilo. Nemuya yafa yahaꞌagu fobaꞌa babu lito niꞌigomo yuhufa hayaꞌa nohesibe, ya nohigomo lenali hetofa yege kotaga luꞌehibe ya nohinagihe lite lilala nehabe. ");
INSERT INTO bef_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yaꞌmana suhi luto alihi asagaꞌna huto nohinogo lenali be geletemo ma lite kehelilo, kanaꞌa anasi aꞌo leba toloto hapi afilubeꞌmu nohibe lite kehelilo. ");
INSERT INTO bef_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nani maꞌnaka luto lu nolepube. Yatai kanaꞌalo boanaꞌi mefilise nehinogo ma asagaꞌna huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kokulumaꞌi hiti meꞌi hiti su halinaya nani kaꞌni fenene mehilinaꞌmu minomo buto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Anana huto hilina yupahifi to kanaꞌafi bo moneuba mekeheliꞌehibe, kokulumalugu agelouba ana huto mekeheliꞌehibe, to nani Huꞌmamofihi panaꞌa naniꞌni hiti ana huto mekeheliꞌohube. Huꞌmau aisigo anasi ana kanaꞌa keheliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kokulumaguti limiꞌehina Bo aku alina yupahiya Noaha yupahi huto huꞌehina suhi luto huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Koyapaꞌa Noaha kanalo nagamiꞌi bilito enoho fi metoꞌehigo asaga boanaꞌmagi yaꞌmana kanaꞌalo sipi noseꞌna nete to anaꞌi kata hite nehago ana kanaꞌalo Noau sipi botigu tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ya hina enali ana boanaꞌmagi yanaꞌmu huto hilubeꞌmu nohinagi lite enekesa meyigise negi nagi nete nehago sipi nagamiꞌi bililoto enoho fi to su hoꞌehina yabe. Kokulumaguti limiꞌehina Bo aku alubeꞌmu hilina yupahi yaꞌmana suhi luto huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yaꞌmana yupahi bo loemaleꞌi foyagu liliꞌna lite nehiꞌinogo moneꞌamofihi leꞌmo fenene nohinogo moneꞌa ana foyagu lita i heꞌminogo minalibe. ");
INSERT INTO bef_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aꞌi loemaleꞌi noseꞌna hesite nehiꞌinogo mone koto nehilaꞌinaloti mone aꞌi leꞌmo fenene nohinogo mone aꞌi analo aiꞌasigo minalibe. ");
INSERT INTO bef_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ya huꞌehinagi lenali Mesiau alina kanaꞌa mekeheliꞌahanagi kaba hu bati hite minalo. ");
INSERT INTO bef_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lenali yaꞌma kaga keheli bati hilo. Bo moneuba guminalo bo alina kanaꞌa keheliꞌehitita ai nohaꞌalo kaba gimi giloto nohigo guminalo bouba ai nohaꞌagu tiloto feꞌnohaꞌa li su mehalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ya huꞌehinagi lenali asaga yupahi lele hite kosaba kosaba hite minalo, henaꞌmugope? Kokulumaguti limiꞌehina Bo aku limilina ya yupahi alibe lite lele hilana kanaꞌalo mealina fato kanalo nehetilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Liliꞌnalo panaꞌi mone hiyaꞌa batiꞌa nohuto ai ekesa yigi bati huto liliꞌnaꞌalo kaba hu bati nohibe? Kaba boꞌauba lugaꞌa liliꞌnalo panaꞌmagi kaba boꞌani leꞌmo nomoloto kanaꞌa nohinogo noseꞌna epilata panaꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Alihi sipi boꞌauba olenogo asaga lu emiꞌehina suhi li su hoꞌohutomo yaꞌma liliꞌnalo panaꞌi ai sipi gelo bino. ");
INSERT INTO bef_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nani maꞌnaka luto lu nolepube, sipi boꞌauba yaꞌmana panaꞌi leꞌmoloto asaga feꞌnohaꞌalo li kaba gi etalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","To ai bati mehina liliꞌnalo panaꞌi nohutomo ai ma luto lilibe: Sipi boꞌni meleꞌisi i behe huto meabe. ");
INSERT INTO bef_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ya luto luloto ai kaba hu epoloꞌehina pana laluꞌagi hiti luba nohuto to bia nagamiꞌi nelete negi nagi nete nehana bo hiti nagamiꞌi nalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ya huto yaꞌmana liliꞌnalo panaꞌuba sipi boꞌa geba huto meminalinalo ana kanaꞌasilo sipi boꞌa nehetilibe. To ana panaꞌuba alina kana mekehelise nohilinalo yabe. ");
INSERT INTO bef_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ya huto nohinogo sipi boꞌauba naga osatu ana panaꞌi bi yigiloto leꞌmoto buto fagalo bona enayanuga bilinaꞌmu yabe. Ya hinogo enali yaꞌmanaga nehite sipi yibi bena nehite enagabu kumu usegi asegi ise hepato buto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu kaga luloto bame ka mone lu epiꞌehina: Yaꞌmana yupahi kokulumamofihi kapo nayahi luga luga su hago nehana yafanaꞌmagihi suhi hilinaꞌmu yabe. Bo mone lihaꞌa hiti etayanugu liluꞌibeꞌmu hilina bo alubeꞌmu hilibe. Ya nohinogo enali yaꞌmana yafanaꞌmagi lamu libiꞌani li gilete kapoga bite sa sa hite leꞌmoto alune lite yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","To nayahi mone kegiꞌa su hana yafanaꞌi enali enekesagu fe melina yafanaꞌi yabe. To nayahi luga kegiꞌa su hana yafanaꞌi enali enekesagu fe luꞌehina yafanaꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Enekesagu fe melina yafanaꞌmagi lamu libiꞌani lite banaya to kalasini su nohenogo heki bilana kabaꞌa melise biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","To enali enekesa hiti yafanaꞌi enali lamu libiꞌani nelite to kilulu kohaꞌanigu kalasini heki bai tete su nohenogo heki bilana kabaꞌa lite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lihaꞌa hiti etayanugu liluꞌibeꞌmu haꞌina bo ai meleꞌisi meago asaga yafanaꞌi geba hite minapa minapa higo enubu loko toko higo enubuꞌi keꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","To foluguꞌi sipi kehe mone ilete ma lite liꞌahana: Lihaꞌa hite etayanugu lilubeꞌmu nohina bomo ma noabe. Lenali kapoga bite be gete be tigite leꞌmete alo lite kehe iꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ya lago enali yaꞌmana yafanaꞌi ho tilete lamu libiꞌani li kulu tite li loloba hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","To enali enekesa fe melina yafanaꞌmagi enekesa niꞌigo enekesagati kalasini kabaꞌa hiti lite eꞌahana yafanaꞌmagihi ma lite enoloka heꞌahana: Lenali kalasini lugaꞌa limilo. Lali libiti asabalubeꞌmu nohibe liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ya lago enali enekesagati kalasiniꞌani hiti lite ana yafanaꞌmagi liꞌahana: Oꞌe, ma liꞌohuta kalasiniuba lali hiti lenali hiti bati mehilinaꞌmu yabe. Lenali situaluguti bite fatoꞌi mina filo. ");
INSERT INTO bef_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Enali enekesa fe melina yafanaꞌmagi kalasini mina filuneꞌmu aꞌnebago yaꞌmana bo lihaꞌa yanugu lilubeꞌmu hina bo nehetiꞌehina. Ya higo enali lele hite minana yafanaꞌi ana bo hiti nonuga tilete ana bouba lihaꞌa hiti etayanugu liꞌigo ana gukete noseꞌna babu lite nete mineꞌahana. Ya nehago ana noto kasihi hekini loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","To alihi enekesagu fe melina yafanaꞌi ete kasitoti ma lite kehe iꞌahana: Sipi boti yale. Sipi boti yale. Kai kafe sigi letobo. ");
INSERT INTO bef_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ya lago ai sipi bouba ma luto lu epiꞌehina: Nani lenaliꞌi mekeheliꞌohube luꞌehina yabe. Yesu ana bame ka moneꞌa hiti molo emiloto ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ya huꞌehinagi lenali kaba hu bati hilo. Kokulumaguti limiꞌehina Bouba aku alina yupahi to kanaꞌa hiti lenali mekeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bo moneuba hepaꞌa heꞌmiloto foto hepatoga bonohi bilubeꞌmu hilina suhi huto kokulumamofihi kapoꞌa minalinaꞌmu yabe. Ai liliꞌna panaꞌa kehe i nupa huloto ai enali enayanugu feꞌnohaꞌa moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ai liliꞌnalo panaꞌamagihi hapaꞌanilo hiti to enali liliꞌna lilata nehana hapaꞌani keheli fe luloto moni efahi guna ito epiꞌehina. Moneꞌamofihi 5,000 kina emiꞌehina, to moneꞌamofihi 2,000 kina emiꞌehina, to moneꞌamofihi 1,000 kina emiꞌehina. Ya huto guna ito epiloto abufa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ai ana kaba boꞌani abufa hulago 5,000 kina lina bouba hololu luto ana efatoti bisinisi mololoto 5,000 kina akuꞌi molo emito moneꞌa hiti efahi huto liꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","To kaba boꞌauba 2,000 kina emiꞌehina bouba ana huto bisinisi mololoto akuꞌi 2,000 kina molo emito moneꞌa hiti efahi huto liꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ya haꞌina ai 1,000 kina kaba boꞌauba emina bouba ai lito buto melugu keli kifiloto anagu keli hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yatama kanaꞌa aꞌmino yatama huloto sipi bo ai akuꞌi hepaꞌaga oꞌehina. Ya huloto liliꞌnalo panaꞌamagihi efahaꞌa epiꞌehina li nupa huto li eto hilubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","To 5,000 kina emiꞌehina bo ai oꞌehina, ai 5,000 kina mone hiti molo emito liloto oto ma luto luꞌehina: Sipi bo, kai 5,000 kina nimiꞌahane. Bu gobo, nani bisinisi molotoꞌni 5,000 kina moneꞌa akuꞌi okalago liꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sipi bouba ma luto lu emiꞌehina: Kai hetofa liliꞌnalo bo amuya bo nohane. Kai hetofa suhi li huto huꞌahane. Kai liliꞌnalo kaba hu bati hulata nohane. Kai lagasoꞌnasimofihi kumunalo hetofana huto kaba hu bati huꞌahatalo yatai nani babu feꞌnoto kaba kimi gi ketalube. Kai sipi boka hiti kegelonaguti ete minaliyo. ");
INSERT INTO bef_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","To 2,000 kina sipi boꞌauba emiꞌehina bo ana huto oꞌehina. Ai ma luto luꞌehina: Sipi bo, kai 2,000 kina nimiꞌahane. Bu gobo, nani bisinisi molotoꞌni 2,000 kina moneꞌa hiti molo emito liꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ya ligo sipi boꞌauba ma luto lu emiꞌehina: Kai hetofana huto amuya liliꞌnalo bo yabe. Kai liliꞌnalo bati huto kaba hulata nohane. Kai lagasoꞌnasimofihi leꞌmo bati huto kaba kimi gitamofihi okaneꞌa yatai babu feꞌnoto kimi gi ketalube. Sipi boka hiti kai kegelonaguti ete minaliyo. ");
INSERT INTO bef_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","To 1,000 kina sipi boꞌauba emiꞌehina bo ana huto oloto ma luto sipi boꞌa lu emiꞌehina: Sipi bo, nani akeheli ketoꞌohube, kai hakale kaga lulata nohata bo nohane. Mone bouba foya hekoloꞌehinaguti kai noseꞌna kifilata nohane. To mone meto bo moneuba noseꞌna legeyaꞌa tili huꞌehinaloti kai noseꞌnaꞌa lilata nohane. ");
INSERT INTO bef_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yaꞌmu luto nani kai kumu nelesaꞌni ligo 1,000 kina nimitamo lito buto melugu keli hoto fala ki ketoꞌohuna yabe. Ya huꞌohuna efahaka nimiꞌahata eto huto ma li ketoꞌohunagi libo. ");
INSERT INTO bef_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ya ligo sipi boꞌauba kaꞌalo ma luto lu emiꞌehina: Kai bati mehina liliꞌnalo bo fuligo koloto nominata bo yabe. Bo moneꞌmofihi foyaguti noseꞌna nokifito to mone melugu bo moneuba noseꞌna legeyaꞌa tili huꞌehinaloti noseꞌnaꞌa nani kumu noline luto noho fisa nokitaba kai keheli bati huꞌohuto nolapihe? ");
INSERT INTO bef_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ya latagi, kai hena hibe luto efahaꞌni efaha nonugu memalane? Ya hatita nani oto ana efahaꞌnilo molo emiꞌahago to mone hiti lutitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ya hinagi kai 1,000 kina liꞌehina be silito 10,000 kina liꞌehina bomofihi li emibo. ");
INSERT INTO bef_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Henaꞌmube? Asaga bonaꞌi anaꞌinaꞌani ninalo nani moneꞌa hiti epiluneꞌmu yabe. To mone bouba anaꞌinaꞌa meniꞌinogo nesiꞌnasi yanuga liꞌehinana nani be sili heꞌmilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ya huto niꞌinagi ma bo liliꞌna melise fulilo bo fegutoga metepu inagu nu kite leꞌmo heꞌmilo, ya hinogo enali anaga metepugu usegi asegi ite enagabu kumu yolege balege ite gelehe gelehe hite enabagalo heni kofiꞌehite yibi hite metepugu minalabe luto Yesu bame ka lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nani Kokulumaguti limiꞌohuna Bo nohuto gihiti bo suhi huto oto agelomagi hiti aku aluta yupahi sipi kefa hisalo nani minalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ya huꞌehinogoꞌni asaga melugu boanaꞌi nani nubulo li gehesa hilanaꞌmu yabe. Ya hinogo yaga kaba bouba sipisipi yaga hiti meme yaga hiti eneleꞌmo guna iloto loegu eneleꞌmo luga luga ilata nohina suhi huto nani ana huto ilube. ");
INSERT INTO bef_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nani sipisipi yagamagi nayahi lamagaꞌaga eneleꞌmo nomoloto to meme yaga nayahi sogaꞌaga eneleꞌmo malalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ya hinogoꞌni kibina bouba ai oloto nayahi lamagaꞌniga nehana bonaꞌi ma luto lu epilinaꞌmu yabe: Lenali alo. Afoꞌnifu leneleꞌmo bati hilibe. Koyapaꞌi ai kokuluma hiti meꞌi hiti lolo huꞌehina kanaꞌalo Afoꞌnifu kapoꞌa li hokolo hu lepoloꞌehina kapo lenali ete tilo. ");
INSERT INTO bef_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Henaꞌmugope? Koyapaꞌi nani kauꞌna nonalago lenali noseꞌna nimiꞌahana yabe. To nagami kumu lubahaꞌni hosopa noigo lenali nagamiꞌi nimigo noꞌohuna yabe. To nani hepaꞌni heꞌmiloto ka bo oto nohugo lenali nohatinigu neleꞌmo meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","To nani nugufa yapako nohugo lenali nugufalo gukete li hekele neteꞌahana yabe. Nani nebesigo koloto nohugo lenali fulu fulunatu ite ete soso hi neteꞌahana yabe. Nani naga nonugu nohugo lenali ete bu negete nebe tigiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ya linogo enali bati bonaꞌi sipi bomofihi yahi lamagaꞌaga minanamagi ma lite sipi bomofihi loka halabe: Sipi boti. Hiya yupahi kauꞌna nokalago bu kogoto noseꞌna kimiꞌohutabe? To hiya yupahi nagami kumu lubahaka hosopa noigo nagamiꞌi kimiꞌohutabe? ");
INSERT INTO bef_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hiya yupahi ka bo lolo huto nohanogo lali nohatigu keleꞌmo moloꞌohutabe? To hiya yupahi kai kugufa yapako nohanogo lali gukete li hekolo ketoꞌohutabe? ");
INSERT INTO bef_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kai hiya yupahi kebesiꞌehigo lali buto soso hu ketola, to naga nonugu nohanogo lali buto kebe tigila huꞌohutabe? ");
INSERT INTO bef_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ya lite noloka henogo nani sipi gihiti bomofita ma luto lu epilube: Nani maꞌnaka luto lu nolepube. Musufalo bo mone nalaluꞌnifihi ma melugu yaꞌmana suhi hi eteꞌehilana yaꞌma naniꞌi neleꞌmo bati hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","To nani nayahi sogaꞌniga nehana bonatoga i behe huloto ma luto lu epilube: Lenali foipa bonaꞌi. Lenali logo mesobose logo loba loba huto nina hepatoga bilo. Yaꞌmana logo Afoꞌnifu Sata hiti foipa feleꞌa hiti mesobose loba loba logo go epoloꞌehinalo yabe. Lenali analo bilo. ");
INSERT INTO bef_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Henaꞌmugope? Nani kauꞌna nahago nohugo lenali noseꞌna menimiꞌahanabe, nagami kumu lubahaꞌni hosopa noigo lenali nagamiꞌi menimiꞌahanabe. ");
INSERT INTO bef_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nani ka bo oto hepatinigu nehetuna nohatiniluga neleꞌmete metiꞌahabe. Nani nugufa yapako nohugo lenali gukete nugufalo li mehekele neteꞌahana yabe. Nani nebesigo koloto nohugo lenali ete soso mehi neteꞌahabe. To nani naga nonugu nohugo lenali ete bu negete nebe metigiꞌahana yabe luto gihiti bo lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ya luto lu epinogo enali kaꞌalo nonaꞌa ma lite lu emilabe: Sipi Botimaka. Hiya yupahi kauꞌna kohola, lubahaka hosopa ila, ka bo minola, kugufa yapako minola, kebesila, naga nonugu minola huꞌahanogo lali keleꞌmo bati mehuꞌohune? ");
INSERT INTO bef_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ya lite loka henogo gihiti bouba ma luto lu epilube: Nani maꞌnaka luto lu nolepube. Musufalo bo nalaluꞌnigihi ma melugu eneleꞌmo bati mehiꞌahanaya naniꞌi neleꞌmo bati hite meneheꞌmeꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ya linogo yaꞌmana bonaꞌi enali enagabu ginogo minoba minoba hepalugu bite minalabe. To bati bonaꞌa enali hetofa hepaꞌi minoba minoba hilana hepato bilanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu kaga alu epi su holoto alihi koko pananaꞌamagihi ma ka lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Lenali akeheliꞌahabe, loe yupahisi minolototi koyapa Huꞌmau lubuto buꞌehina yupa kumu Pasa yabe nelana yaꞌma noseꞌna naluta kanaꞌa huto hilinaꞌmu yabe. Ya hulenogoti Kokulumaguti limiꞌehina Bomofihi leꞌmete bite fatehaꞌamagihi enayanuga melenogo malipu yafalo ho fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yaꞌma kanaꞌalo sipi mono nohi kaba bonaꞌi hiti to Isilaeli enikibina bonaꞌi hiti sipi mono bo Kaiyafasihi nonugu li nupa hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Enali Yesuhi fibe bataga hube hi etelete yato lite ho fililana kaga lube kehelibe hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ya huꞌehina yaꞌmana suhi asaga bonaꞌi li nupa hite noseꞌna nete minelata kanalo ya mehilune. Ya hiluta asaga boanaꞌmagi luba li huto hilanaꞌmu yabe lite sumi ka liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betani hepato Simoniu ai koyapaꞌi lepolosi hepuhi loꞌehina bomofihi nonuga Yesu minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ya higo aꞌi moneuba efaha konugu tu mesebe minaꞌa tito nina mesebe liloto Yesu hitalo noseꞌna noto nohinalo oloto ana tu mesebe Yesuhi latahaꞌagu heki su hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ya higo enali Yesuhi koko panaꞌamagi anana be gelete enitaluga logo bigo ipakafa helete ma lite liꞌahana: Sipi minaꞌa tito nina mesebe henabe luto heki hapotili nohibe? ");
INSERT INTO bef_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","To yaꞌmana tu mesebe bo moneꞌmofihi emutita sipi minaꞌa tito lilototi enumuhi menina bonaꞌi guna ito eputitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya lite nelago Yesu kagaꞌanimofihi bu go fulu tito enogoloto ma luto lu epiꞌehina: Lenali henabe lite ma aꞌmofihi ekesagu hina kaga nelabe? Ai hetofa suhi nani keheli bati hu etona suhi nohu netabe. ");
INSERT INTO bef_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lenali asaga yupahi enumuhi menina bonaꞌi hiti minalanaꞌmu yabe. Ya huꞌehina naniya lenali hiti minoba minoba mehilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma aꞌuba ma tu mesebe latahaꞌnigu heki netoꞌehinaya kene keligu bilunamofihi neleꞌmo loloba nohibe. ");
INSERT INTO bef_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nani maꞌnaka luto lu nolepube, asaga noto noto kapoga ma aꞌuba li huto hinanamofihi hetofa kagaꞌa lu yege halabe, ya hilete enali enekesa yigi emite ai kumuꞌi enekesu mehalibe. ");
INSERT INTO bef_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yaꞌmana yupahi Yesuhi koko panaꞌa 12 nehanaguti Yutasi Isikelioti yabe lite gi nemalana bouba sipi mono nopo kaba bonatoga gutunu ka ma luto buto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yesuhi lenelepilunaba lenali henana minaꞌa nimilanabe? Ya ligo enali kaba bonaꞌmagi efahi legeyaꞌa leka selete 30 li nupa hite emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ya hilago yaꞌmana kanaꞌaloti Yutasiu Yesuhi fatehaꞌamagihi enelepilina kanaꞌamu sa sa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yeye mebise beleti nelata nehana kanaꞌalo yataꞌa Yesuhi koko panaꞌa aitoga elete ma lite loka heꞌahana: Asagaꞌna hiyaꞌalo li loloba hu ketoꞌehinogoti kai Pasa noseꞌna nalane? ");
INSERT INTO bef_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ya lago Yesu lu epiꞌehina: Lenali hepalugu tiletetini bo moneꞌmofitoga bilete ma lite lu emilo: Tisau ma luto libe: Nani kanaꞌni aꞌo leba notabe. Nani koko panaꞌni hiti kai nonugu Pasa noseꞌna nalube luꞌehibe lilo. ");
INSERT INTO bef_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu ya luto koko panaꞌa lu epalago enali bite luꞌehina suhi huto hulago Pasa noseꞌna bagita hite li loloba hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ute kana nohigo Yesu koko panaꞌa 12 hiti hitalo minete noseꞌna nenete Yesu ma luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nani maꞌnaka luto lu nolepube. Lenali folagahatiniguti mone bouba naniꞌi nayato lito fatehaꞌnimagihi enelepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ya ligo koko panaꞌamagi enali enugufagu sibina hu baga igo eniginaga fina bomagi moneꞌisi moneꞌisi ho tilete ma lite Yesuhi loka heꞌahana: Sipi Bo, nani kumu nolapihe? ");
INSERT INTO bef_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ya lite lago Yesu kaꞌani ma luto lu epiꞌehina: Nani hiti lapelugu yahaꞌatuꞌi beleti nagami i fulu huto nalina bouba ya hilibe. ");
INSERT INTO bef_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mono kagu koyapaꞌi kaga lu yege hose bomagi nani yaꞌma Kokulumaguti limiꞌohuna Bo fililunaꞌmu fayahi geꞌahana kaga ninalo nani filinogoꞌni pa salinaꞌmu yabe. Ya huꞌehinaya ai nayato lito fatehaꞌnimagi epilina bose. Ke. Ana bo lesaꞌa gofana lino. Itoꞌafu ana bo meketatitaya bati huto minatitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yutasiu Yesuhi fatehaꞌamagihi enelepise bouba ma luto luꞌehina: Tisao, nani kumu nolapihe? Ya luto loka hago Yesu luꞌehina: Oꞌyo, kai alu huto nohane. ");
INSERT INTO bef_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Enali noseꞌna nete nehago Yesu beleti liloto Huꞌmamofitoga fokehi hoto nunumu luloto koko panaꞌa ana beleti li pata sito epila epila nohuto ma luto lu epiꞌehina: Lenali lite nalo. Yaꞌma nani nugufaꞌni niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","To ai bai nagami kohi mone liloto Huꞌmamofitoga fokehi hoto nunumu luloto koko panaꞌa noepito ma luto lu epiꞌehina: Lenali asagaꞌi ma bai nagamiluguti nalo. ");
INSERT INTO bef_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yaꞌma nani golahaꞌni niꞌibe. Huꞌmau lu mu tifiseꞌnaꞌa golahaꞌni huto hu moloꞌohube. Asaga boanaꞌmagihi foipanaꞌani li gololo tu epalalibe luto nani nohekube. ");
INSERT INTO bef_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nani maꞌnaka luto lu nolepube. Nani mana bai nagamiꞌi menose minomo buto butoꞌni Afoꞌnifihi kokuluma kapoꞌalo lenali hiti yuhufa bai nagamiꞌi nalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ya luto lu baga igo enali mono nama mone lilete fegutoga heleko limite Oliba kosagu tite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","To Yesu ma luto lu epiꞌehina: Yatai lenali naniꞌi heꞌmi netete koli fele su halanaꞌmu yabe. Monolugu ma lite kaga lu huto huto bouba goꞌehina yabe: Sipisipi yaga kaba huꞌehina bo Huꞌmau ho filinogo sipisipi yagaꞌa koli hite tili tele hite fele su halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ya huꞌehinaya nani filiꞌehilunagati akuꞌi ho tilotoꞌni kohe toga Galili kapogu nobilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ya luto Yesu noligo Pitau ma luto Yesu lu emiꞌehina: Lugaꞌamagi heꞌmi ketete koli hi su halanaya nani maꞌnaka heꞌmi ketoto mebilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ya luto ligo Yesu kaꞌalo lu emiꞌehina: Kai ma kaga matuhakagu li molobo. Yatai foluguꞌi kokole nogo memoloꞌehinogo kai loegi monegi yupahi naniꞌi mekeheliꞌohube luto bahane halataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yesu ya luto Pitahi lu emigo Pitau luꞌehina: Nani kaiꞌi bahane meho ketalunaya, kaiꞌi hiti moneka fililuꞌinamo niꞌibe. Ya luto Pita lulago Yesuhi koko panaꞌa lugaꞌamagi Pita linaꞌa hite moneko ka lu baga iꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ya huloto Yesu koko panaꞌa hiti eneleꞌmoto hepaꞌi mone giꞌa Gesemani yabe luto ninalo bilete Yesu ma luto koko panaꞌa lu epiꞌehina: Nani meyasilo buto nunumu hilunagi lenali malo nehilo. ");
INSERT INTO bef_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya luloto Pitahi yagi to Sepetihi panaꞌa loe hiti eneleꞌmo mege toto moneka biꞌahana. Ya hite nebago Yesuhi gufaꞌagu sipi keta besigo ligo pisigigo huloto ginaga gofa fiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ya huloto ai ma luto lu epiꞌehina: Nani fililuna suhi luto nugufagu sipi keta nonebesibe. Lenali malo ho tilete minenogo nani hiti ikaba akaba huto minalune. ");
INSERT INTO bef_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya luto luloto ai nesiꞌasi i gofa hoto buloto okabagati melugu koloto ma luto nunumu huꞌehina: Oho, Afoꞌniga, kai kekesa yigilata bati hinogomo, ma ekesa nagamiꞌi nalunamofihi kohi li heꞌmi netobo. Ya huꞌehina kai naniꞌi nemegeꞌi moloto kaꞌni liyafa mehuto, kaika kemehuba hilina suhi hubo. ");
INSERT INTO bef_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ya luto nunumu luloto koko panaꞌa nehanaga buto enubuꞌi kelete nehago bu enogoꞌehina. Ya huloto Pitahi lu emiꞌehina: Henaꞌmu nehabe? Ho tite lenubu gili gili hite hupamone kanasilo nani hiti kaba gimi gite meminalanaꞌa hiꞌahafihe? ");
INSERT INTO bef_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lenali kaba hite minete nunumu hilo. Fibe taga hu lepoloseꞌna lenalitoga huto hu lalibeꞌmu nolube. Komopatinigu ninanauba leneleꞌmo kosaba kosaba nohinaya ifo lenugufatini amuyaꞌa meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya luloto Yesu i behe huto buto loe yupahi ma luto huꞌehina: Afoꞌniga. Ma kohi nanitogati i nebe silito mebinogomo nani nalube, ya hinogoꞌni kaika kipagu niꞌilina suhi pa salibe. ");
INSERT INTO bef_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya luto nunumu lu su holoto i behe huto oto koko panaꞌa enubulo sipi keta higo enubuꞌi kelete nehago bu enogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu akuꞌi heꞌmi epololoto i behe huto buto loegi monegi yupahi yataꞌa luꞌehina nunumu akuꞌi luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ya luto nunumu hu su holoto koko panaꞌa nehanaga i behe huto oto ma luto lu epiꞌehina: Lenali lenubuꞌi batiꞌa kelete nehafihe? Lenali kehelilo. Kokulumaguti limiꞌehina Bomofihi yato lite bite foipa bomagihi enayanuga bilana kanaꞌa maꞌasi huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lenali ho tilo, abilutagihe. Bu galo, naniꞌi fatehaꞌnimagi enayanugu li bilina bo ma ahuto huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu kaga luto nohigo Yutasiu 12 Yesuhi koko panaꞌa minoꞌehinauba Yesu nohinalo nehetiꞌehina. Ya nohigo babu bonaꞌi megeꞌi melete yanamagi emitaꞌi yatamana nelite osahi ko nefite bululu hite eꞌahana. Yaꞌmana bonaꞌi enali sipi mono bonaꞌi hiti to soga bonaꞌmagi enoho lifigo eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutasiu eneleꞌmoto ana bonaꞌi yaha babeyafa hu epiloto ma luto luꞌehina: Nani soso hilunaꞌmu bomoya lenali sa nehana bo nu kilunaꞌmu yagi lenali bite yato lilo. ");
INSERT INTO bef_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yutasiu nehetiloto Yesu nohinalo fu luto buto ma luto luꞌehina: Tisao, foluguꞌi yabe, luto soso huꞌehina. Ya luto luloto Yutasiu Yesuhi nu kiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ya higo Yesu lu emiꞌehina: Nalaluo, lolo hilube luto noata suhi meleꞌisi li huto hubo. Ya noligo Yesuhi fatehaꞌa bufalo elete yato liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuhi hiti moneka mineꞌahana bo moneuba yatama emitaꞌi li saga huloto sipi mono bomofihi koko panaꞌa inaya koli nopigo i fakala bito ekesa ilaga luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ya higo Yesu bu goloto ana bo lu emiꞌehina: Yatama emitaka nohaꞌaluga li bibo. Asaga bonaꞌi emitatuꞌi luba hilata nehana enali ana emitaꞌaniuba laga hu enugufa melenogo fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nani Afoꞌnifihi neheꞌmalibe luto kehe ilunaya agelo gimi bo 12 tauseniꞌa be ligito babu lito enoho mefilibe luto kai mekehelipiye? ");
INSERT INTO bef_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nani ya hilunaya Huꞌmau fayanugu goꞌehinamofihi manaꞌa hiyaꞌa huto huto hilinabe? Monolugu ma lite geꞌahana yabe, asagaꞌna yaꞌma suhi luto huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ana kanaꞌasilo Yesu fatehaꞌamagi ma luto lu epiꞌehina: Lenali baukalo bo helata nehana suhi lite naniꞌi nahalune lite yatama emitaꞌi hiti yatama hoso hiti kefefa hite neafihe? Henabe lutobe? Asaga yupahi nani babu boanaꞌi hiti sipi mono nonugu ka enelepito minolata huna lenali bite nayato meliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ya huꞌehinaya kaga lu huto huto bomagi mono kagu fayahi geꞌahanalo pa salinaꞌmu yabe. Ya luto ligo Yesuhi koko panaꞌa tili tele hite koli fele su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Enali Yesuhi yato lina bomagi sipi mono bo Kaiyafasihi nonuga leꞌmete biꞌahana. Enali keya kaga keheli bati hiꞌahana bo hiti to soga bonaꞌi ana nonuga li nupa hite nehanaloga tiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitau foto foto huto enemegeꞌi lifito buꞌehina yabe. Ya huloto ai babafi bomofihi noho gegisagu tiꞌehina. Analo tito ai hiti gimi bomagi hiti metoga minete nehana. Anana anana Yesuhi li huto hi etalanamofihi hapa hapaꞌa bu go bati hilube luto yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Enali sipi mono babafi bonaꞌi hiti to asaga kanisole bomagi bo moneuba Yesuhi faga lu etenogo ho fililana boꞌmu sa sa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","To babu bomagi Yesuhi faga faga li eteꞌahana. Ya hana Yesuhi ho fililanamofihi kaga manaꞌa lu huto mehiꞌahana. Alihi loe bole nehetiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ya hilete etali ma lite liꞌahaꞌina: Ma bouba ma luto luꞌehina yabe: Huꞌmamofihi sipi mono nohaꞌa tele biloto loegi monegi yegegu akuꞌi gi baga ilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ya lite laꞌigo sipi mono bouba ho tiloto Yesuhi loka hoꞌehina: Kaiꞌi kaga kifisa neiꞌinalo nonaꞌa lilata niꞌifihe? Yaꞌma kifisa neiꞌina kagaloba kai hena hibe luto nokeheline? ");
INSERT INTO bef_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ya luto loka hago Yesu kaga meluse legeso huto minoꞌehina. Ya higo yaꞌma sipi mono bouba ma lu emiꞌehina: Nani maꞌnaka luto Huꞌma mehiti bomofihi giꞌalo koloka nohonagi kai lu nimibo. Kai Mesiaga Huꞌmamofihi Panaꞌa nohapi fatoꞌibe? ");
INSERT INTO bef_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kaꞌalo nonaꞌa luꞌehina: Kai aꞌnolane. Ya huꞌehina lenali asagaꞌi kaga mone lu lepilube. Yatai hiti to alihaꞌa yupa hiti Kokulumaguti limiꞌehina Bouba ifo muya Sipi Boti Huꞌmamofihi yahi lamagaꞌaga minoloto kokulumamofihi sopohaꞌalo aku alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu ya luto lulago sipi mono bouba kataꞌa li bolala ito pekene pakunu nohuto luꞌehina: Ai Huꞌmamofihi kiya yokolo ka lu etoꞌehibe. Lali bonaꞌi lugaꞌa hiti kehe meilune. Ai Huꞌmamofihi kiya yokolo ka yatai aꞌnolu etago lenalitini akeheli baga iꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lenali henabe lite nekehelibe? Asaga bomagi ma liꞌahana: Ai bati mehina kaga luꞌehinago henogoti fililibe lite lu baga iꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ya lilete enali Yesuhi okabagu libiꞌna nehete osahi emiꞌahana. To lugaꞌamagi enayaha osatu bu i polo hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ya nehago lugaꞌamagi loka heꞌahana: Kuyuꞌafu nokahabe? Kai Mesiaga nohutomo lu huto hubo. ");
INSERT INTO bef_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitau fegutoga noho gegisa foyaꞌaluga minoꞌehina yabe. Ya higo sipi mono bo moneꞌmofihi liliꞌnalo paꞌuba bu goloto lu emiꞌehina: Kai hiti Yesu Galili bo hiti minoꞌahata yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ya ligo Pitau asaga bonaꞌmagi enubulo bahane holoto luꞌehina: Kai kaga nolatamofihi nani mekeheliꞌohube luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ya luto luloto ai fegutoga nohi kasito nohigo kele kele yafa aꞌi moneuba bu goloto bo lugaꞌamagihi lu epiꞌehina: Muya panaꞌi ai Nasalete bo Yesu hiti moneka mineꞌahaꞌina bo yabe. ");
INSERT INTO bef_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ya ligo Pitau akuꞌi bahane holoto ma luto luꞌehina: Nani maꞌnaka luto mekeheli etoꞌohuna boꞌmu nelabe. ");
INSERT INTO bef_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nesi kanasi minoto bo moneꞌa analo minanamagi Pitatoga ete ma lite liꞌahana: Maꞌnaka luto Galili bona nagaluguti nohane. Kai nogokauba hutoꞌi noago nokehelune. ");
INSERT INTO bef_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ya lite lago Pitau lusi amuya mololoto bahane hoto luꞌehina: Faga nolinogoꞌnimo Huꞌmau nagaꞌi nimilibe. Nani maꞌnaka luto ana bo mekeheliꞌohuna boꞌmu nelabe. Ya luto noligo ana bagaꞌa hiti kokole nogo moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ya higo Pitahi koyapaꞌi Yesu kaga lu emiꞌehina, ekesa hokolo huꞌehina: Kokole nogo memoloꞌehinogo loegi monegi yupahi naniꞌi mekeheliꞌohube luto bahane halataꞌmu yabe. Ya luto lu emiꞌehina kaga ekesalo ago fegutoga heleko limito buto ginaga sipi huto yibi huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Goꞌi noligo asaga sipi mono bo hiti to Isilaeli bo olopaꞌa hiti li nupa hilete Yesuhi ho fililana kaga lu keheli fa keheli hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Enali seni nagatuꞌi Yesuhi yato nagaꞌi ilete leꞌmete bite Lomu gamani bo Pailatihi sipi bo nohinamofihi emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yutasiu Yesuhi fatehaꞌamagihi enayanuga li biꞌehinauba Yesuhi ka foya li etete ai kaꞌa li melugu malana bu goꞌehina. Ya huloto ai komopaꞌa i gelehe huloto 30 siliba efahi legeyaꞌa sipi mono bomagi to babafi olopa bomagi emiꞌahana akuꞌi ito buto epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya huloto ai lu epiꞌehina: Nani foipana ameniꞌina bomofihi yato li lepilotoꞌni naniꞌni foipana li nubufalo moloꞌohube. To ai fililinaꞌmu yabe. Ya luto ligo enali liꞌahana: Ya lalinati meniꞌibe. Yaꞌma kaiꞌnaka niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ya lite lago Yutasiu ana efahi mono nohi hasagu heꞌmi lago notito fegutoga buto nagato aiꞌa naga hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ya higo sipi mono bonaꞌmagi ana efahi lilete liꞌahana: Yaꞌma golaha efahi niꞌibe, mono nonugu efanugu li sibi huto malalutaya lali keya kagati oꞌe luꞌohutomofihi li gofa halutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Enali ana efa kumu kaga lite lite melelete moneko kalo li meleꞌahana: Enali ana efatuꞌi me somo lolo hulata nohina bomofihi foya mina filete bonoho bonaꞌi ete filise bonaꞌmagihi kene mala malaluta hepaꞌi li lolo hilune liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yaꞌmu lite yaꞌmana meꞌi giꞌa Golaha Meꞌi yabe lite gi meleꞌahana yabe. Yaꞌmana giꞌa yatai hiti helata nehabe. ");
INSERT INTO bef_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Koyapaꞌi kaga lu huto huto bo Yelemaiyahi bagalo Huꞌma kaga moloꞌehina yatai manaꞌa pa soꞌehibe. Ana kaga ma luto niꞌina: Enali efahi legeyaꞌa 30 siliba lilete ana efatoti yaꞌma bo mina filuta minaꞌa yabe lite Isilaeli bonaꞌmagi ka meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ana efatu me somo lolo hulata bomofihi meꞌi Sipi Boꞌniuba mina fibo luto lu nimiꞌehinaꞌa huto mina fiꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Enali Yesuhi sipi Lomu gamani bomofihi bulo leꞌmo ho tigo ma luto loka hoꞌehina: Kai Yuta bonaꞌmagi sipi gihiti boꞌani nohapihe? Ya luto loka hago Yesu luꞌehina: Kaika alu huto nohane. ");
INSERT INTO bef_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Enali sipi mono bo hiti Yuta bo olopa bomagi hiti Yesuhi fisa ina kagaꞌanilo Yesu kaga nonaꞌa meluse legeso huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ya higo Pailatiu lu emiꞌehina: Ma bonaꞌmagi babu kaga lite kifisa ite ka foyagu keleꞌme nemalana kai mekeheliꞌahapihe? ");
INSERT INTO bef_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","To Yesu Pailatihi kagaꞌalo nonaꞌa akuꞌi meluse legeso huto minoꞌehina. Ya higo yaꞌma sipi Lomu gamani bouba babu ekesa yigiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Asaga kufugu Pasa noseꞌna nelata nehana kanalo Lomu gamani bouba naga foyagu nehanaguti asaga boanaꞌmagi yaꞌmuya bo li gulu ho etobo lanamofihi nagaluguti fulu ho etolata nohina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yaꞌmana kanaꞌalo asaga bonaꞌmagi giꞌa keheli baga iꞌahana bo Balabasiu nagalugu minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Asaga boanaꞌi li nupa hago Pailatiu enoloka hoꞌehina: Kiyiꞌafihi lepilube? Balabasihi li gulu ho etobo ya lite nekehelifi to Yesuhi li gulu ho etobo lite lilete nekehelibe? ");
INSERT INTO bef_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Enali Yesuhi ipakafa helete neminanati ka foyalo leꞌmo ho tiꞌahanamo niꞌibe luto Pailatiu akeheliꞌohuto enoloka hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ya luto luloto Pailatiu ka foya nonugu kaba huto nominago lihaꞌauba koko panaꞌaloga ma luto kaga malago ete lu emiꞌahana: Kai foipanaꞌa menina bomofihi gufalo anaꞌina mone li huto mehubo. Nani yatai foluguꞌi ana hetofa bomofihi bamuꞌi bati mehinaꞌa bu golotoꞌni ai kumu nugufaꞌnigu sipi keta nebesiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Enali sipi mono bo hiti to Yuta olopa bomagi hiti asaga boanaꞌi sipi ka lite enekesa bilete liꞌahana: Kai Balabasihi noheꞌmi etoto Yesuhi limitogo ho fililune lite lilo liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","To yaꞌma Lomu gamani bouba ka luto enoloka hoꞌehina: Ma loe bo nehaꞌina kiyiꞌafihi leꞌmo nagaluguti gulu ho etalube? Ya ligo enali kehe sipi ite: Balabasi yabe, liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailatiu ya lago lu epiꞌehina: Ya lanagi Mesiatini yaꞌma Yesuhi nani hena hu etalube? Ya luto enoloka hago asaga bonaꞌmagi sipi kehe ite liꞌahana: Malipu yafalo ho filibo. ");
INSERT INTO bef_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ya lago Pailatiu lu epiꞌehina: Henaꞌmube? Ai henana li sibina huꞌehibe? Ya lina kaga mekehelise enali amuya melete kehe sipi moneꞌa hiti ite liꞌahana: Malipu yafalo ho filibo. ");
INSERT INTO bef_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailatihi kagaꞌa asaga bonaꞌmagi ho fi telete luba li huto hilana suhi hago Pailatiu bu enogoꞌehina. Ya hago ai silaga boanaꞌi enubulo nagamiꞌi liloto yahaꞌa sese nohuto ma luto lu epiꞌehina: Ma bomofihi ho filise foipana kumu nani nugufalo metilibe. Ya asagaꞌna lenalitinilogagoko minalibe. ");
INSERT INTO bef_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ya ligo asaga boanaꞌmagi ai kaꞌalo nonaꞌa lu emiꞌahana: Yaꞌmana ho filiseꞌnamofihi foipanafi lali lugufalo tiloto yagapanatimagi enugufalo leheko malalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ya lite lago Balabasihi gulu ho etoto leꞌmo epiꞌehina. Ya huloto Yesuhi naga osatu bi yigiloto ho etalo luto gimi bomagi malipu yafalo halabeꞌmu enali enayanuga epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Enali Lomu gamanimofihi gimilo bomagi Yesuhi leꞌmete gamani nonuga leꞌmete netigo gimi bo ana nonuga babu lite nehana ete leꞌmo bego hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ya hilete enali guketeꞌa li toba helete golaha kata hupa moneꞌi li hepi eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","To ufehaꞌa hiti nagatuꞌi kakiliꞌi mone lolo hilete latahaꞌagu bi eteꞌahana. Ya nehite akepa osahi yahi lamagaꞌaga bilete enalapusa nohi fi emilete kiya yokolo ka ma lite lu eteꞌahana: Yuta bonaꞌmagihi gihiti boꞌani yale. ");
INSERT INTO bef_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ya lite lilete okabaluga libiꞌna nehete akepa osahi yahi lamagaꞌaga li binatu lite latahaꞌalo iꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Enali ya lite kiya yokolo ka li etelete golaha kata li hepi etana li toba nehete aiꞌa kataꞌa akuꞌi li hepi eteꞌahana. Ya hilete malipu yafalo haluneꞌmu leꞌmete biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Enali kapo melete nebite Sailini metoga bo giꞌa Simoni aiꞌi be gelete fitu fo etete Yesuhi heꞌmoto malipu yafaꞌa kofi etobo lago ai kofi heꞌmoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Enali hepaꞌi giꞌa mone Gologota yabe luto niꞌinalo nehetiꞌahana. Ana giꞌa hapaꞌamofihi latahaꞌani felisa hepaꞌi yabe lite lilata nehanalo yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ekesaꞌna hiti li sibi sibi hiꞌahana bai nagamiꞌi Yesu nalibe lite emigo nesiꞌasi nokehelinati aku akuꞌi no bati mehuse heꞌmiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Enali malipu yafalo nekatu Yesuhi ahelete guketeꞌa guna ito laliti fato fatoꞌi lilune lite masisi suhi hite heꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ya hilete enali analo nehite Yesu hena hilifi lite ai bota hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ifo latahaꞌaga kaga mone ma lite lilete ka foya emiꞌahana kaga fayahi gelete meleꞌahana: Ana kaga ma luto leka nesabe: Yaꞌma Yesu, Ai Yuta Boanaꞌmagi Gihiti Boꞌani Yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesuhi luga luga ya kegiꞌa foipa bole loemo malipu yafalo eteheꞌahana. Mone bomofihi Yesuhi yahi lamagaꞌaga nehete moneꞌamofihi yahi sogaꞌaga heꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Boanaꞌi enali bila ela hanamagi Yesuhi bugu gili gili nehite bai ka ma lite li eteꞌahana: ");
INSERT INTO bef_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kai mono nohi li tele biloto loegi monegi yegegu akuꞌi gilube luꞌahata bo, yatai kaika kubuto bi negabe. Kai Huꞌmamofihi Panaꞌa nohutomo malipu yafaloti maga limibo. ");
INSERT INTO bef_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ana hite, to sipi mono bomagi hiti to keya kaga enelepilata nehana bomagi hiti olopa bomagi hiti moneko ka lite Yesuhi baiꞌi emite ma lite liꞌahana: ");
INSERT INTO bef_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ai lugaꞌa bonaꞌi li enubuto bilata huꞌehinaꞌa huto aiꞌa li buto mebibe. Yuta bonaꞌmagi gihiti boꞌanimo nohifi fato bo nohibe? Ai malipu yafa heꞌmiloto magu liminogo lali bu goloto oꞌyo, ai maꞌnaka luto gihiti bo nohibe lilune. ");
INSERT INTO bef_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ai Huꞌmamofihi komopaꞌa emito ai panaꞌa nohube lulata huꞌehina ai Huꞌmau yatai abuto bino. ");
INSERT INTO bef_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Etali foipa bo loemo Yesuhi luga luga sopaloga eteheꞌahana yaꞌmaleꞌi moneko ka lite Yesuhi baiꞌi emiꞌahaꞌina. p ");
INSERT INTO bef_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","To fuligaha kanalo asaga hepaꞌi fi metepu i baga ito buto akuꞌi yege limi folose kanalo i besa loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yege alimi falalina kanaꞌa nohigo Yesu sipi kehe ito ma luto luꞌehina: Eli, Eli, lema sabakatani? Ai yaꞌmana kaga ma luto lu gelehe nohune: Huꞌmaꞌnigabe, Huꞌmaꞌnigabe, kai henaꞌmu noheꞌmi netane? ");
INSERT INTO bef_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ya ligo enali lugaꞌa bonaꞌi ana hepato ho tite nehanamagi ana kaga kehelilete ma lite liꞌahana: Yaꞌma ai Elaiyahi kehe i noemibe. ");
INSERT INTO bef_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","To bo mone enali folagahaꞌaniguti ho tito hololu luto buto kosopa iseꞌna lite bai nagamilugu i pota giloto lito oto akepalo itini noloto Yesu bili tuto nalibe luto emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ya nohigo bonaꞌi lugaꞌamagi liꞌahana: Heꞌmiꞌohubo. Elaiyau oto heꞌmalifi bu galuneꞌmu nohune lite nelago, ");
INSERT INTO bef_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu fililubeꞌmu huloto kehe sipi akuꞌi iloto filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ya higo ana kanaꞌasilo kaꞌmuya sipi mono nonugu hekini lose kata hasalo meleꞌahana folaganuguti i hegege huloto ifogati hapi fito siꞌaga limito i pa soꞌehina. To imimaꞌi hiti noligo efahi ibe kolibe huto limiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","To kene mala mala keli i hokolo i baga igo Huꞌmamofihi boanaꞌa babu lite koyapaꞌi filiꞌahana yatai akuꞌi ho ti su heꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Enali kene mala mala hepaꞌi heꞌmi su hete nehago alihi Yesu ho tilago li mone hite sipi tauni hepalugu netigo analo babu bonaꞌmagi bu enegeꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gimi bomagihi sipi boꞌani analo minoto Yesuto kaba huꞌehina hiti to lugaꞌa bonaꞌi hiti imimaꞌi linana hiti to asaga huto hinana be gelete enelesaꞌani gofa ligo ma lite liꞌahana: Maꞌnaka luto ma boya Huꞌmamofihi Panaꞌa nohibe. ");
INSERT INTO bef_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Babu anaꞌi Galili hepaꞌi heꞌmilete Yesuhi heꞌmalune lite megeꞌi lifite eꞌahana anaga mineꞌahana. Yaꞌmana anaꞌmagi fotoꞌi ho tilete nehite gili gili hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Enali folagahaꞌanigu Magatala meluguti aꞌi mone Malia yabe. To mone Malia Yemesinogo Yosefenogo itoꞌatitifu yabe. To Sepetihi panaꞌa loemaleꞌi itoꞌatitifu hiti mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yege limi nofalago feꞌnoho bo Alimatia hepatogati oꞌehina bo giꞌa Yosefe, ai ana huto Yesuhi megeꞌi molomofaꞌna huto minoꞌehina bo yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ai Pailati nohinaga buloto Yesuhi gufaꞌa lilube luto loka hoꞌehina. Ya higo Pailatiu lu epigo gimi bomagi gufaꞌa ite ete emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To Yosefeu Yesuhi gufaꞌa alito gulu gulu katatu li sa giloto yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","To yuhufa lolo huꞌehina muli efa kapoꞌagu gufaꞌa li biꞌehina. Ya huloto sipi efahi mone li behe behe huto kasihaꞌalo hekini loloto abufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ya nohigo aꞌi loemaleꞌi Magatala aꞌi Malia yagi to mone Malia hiti mulito mapahi fite mineꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","To Yuta bonaꞌmagihi fuli kana anaꞌina li tulu huse kanaꞌani yagoꞌa yabe luto nina asu holago enali sipi mono bonaꞌi hiti to Felosi bonaꞌi hiti Pailati nohinaga li nupa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ya hilete ma liꞌahana: Sipi bo yale, ai fagalo bouba mefiliꞌohuto kaga mone ma luto luꞌehina lu kimilune. Loegi monegi yupahi minotoꞌni akuꞌi ho tilunaꞌmu yabe luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ya huꞌehinagi kai gimi bonakamagihi kaga litogo bite loegi monegi yupahi minalifa lite kene keli bagaꞌalo amuya melete i hekini leno. Koko panaꞌamagi faga lite gufaꞌa gumina lilete asaga boanatoga ai akuꞌi kene keliguti ho tiꞌehibe lite enimiꞌi mele lalabe. Yatai faga liꞌahanauba koyapaꞌi faga lilanamofihi be ligilibe. ");
INSERT INTO bef_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailatiu ma luto lu epiꞌehina: Lenali mono nohi kaba gimi gilata nehana bonaꞌi lugaꞌa bite eneleꞌmalo. ");
INSERT INTO bef_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ai ya ligo enali bite kene mala mala keli bagaꞌalo uleꞌale hite keyaꞌi suhi hite hekini lo bati hiꞌahana yabe. To gimi bo lugaꞌa analo kaba gimi gite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","To etehi goꞌi noligo Yuta bonaꞌmagi fuli yupahaꞌani salelegu su halubeꞌmu nohigo loe aꞌi Malia Magatala to yaꞌma fato Malia hiti muliꞌmogu biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","To meleꞌisi mone imimaꞌi sipinamo liꞌehina. Huꞌmau mone agelo ho lifigo limiꞌehina bouba yaꞌma mulimofihi efapo hekini loseꞌna li koli heꞌmito ana efapolo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yaꞌma agelo okabaꞌalo kopisiꞌna suhi huto besa besa loꞌehigo to gukete ana huto koholina sipiꞌamo huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","To gimi bomagi aiꞌi be gelete sipi koli hite afoya foya ilete enubu neta neta bite melugu keꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","To agelouba aꞌmaleꞌi lu etimiꞌehina: Letali koli mehiliyo. Yesu malipu yafalo ho filiꞌahana bo kumu sa sa nehaꞌinamoꞌmu akeheliꞌohube. ");
INSERT INTO bef_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ai maloꞌi menohinagihe. Ai filiꞌehinagati aku ho tilube luto luꞌehinaꞌa ya huto ho tiꞌehibe. Ete manugu tilete koyapaꞌi gufaꞌa koꞌehinalo be galiyo. ");
INSERT INTO bef_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","To letali yatai koko panaꞌa nehanalo meꞌme hite bite filiꞌehinagati ho tiꞌehibe lite lu epiliyo. Ai Galili kapogu tubuto enali hiti analo fo tumala hilune luto luꞌehinagihe lite lu epiliyo. To nani alu noletumube agelouba ya luto luꞌehina kaga. ");
INSERT INTO bef_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ya noligo ana aꞌmaleꞌi sipi koli hite aku etegepohi nelite muliꞌmoguti heꞌmite hololu lite bite koko panaꞌaloga agelomofihi nonaꞌa lu epilubeꞌmu biꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","To etali hololu lite nebaꞌigo anaꞌasi enubulo Yesu kapogu huto huꞌehibe. Nehaꞌifiye? luto lu etimiꞌehina. Ya ligo etali ete gigusaꞌalo nu kilete meto kelete aitoga agoya hu emite mineꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","To Yesu lu etimiꞌehina: Koli mehiliyo. Nogonamu tamuꞌni nehanaga bite Galili kapogu nanitoga enogo fo tumala hilune, luto lu epiliyo, Yesu ya luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","To aꞌmaleꞌi kapo melete tauniga nebaꞌigo gimi bonaꞌi mulimogu kaba hiꞌahanamagi sipi mono bomagitoga bilete asagaꞌi be geꞌahananamo lu yege heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","To sipi mono bomagi ana kaga kehelilete mono kanisole bonaꞌmagitoga bite li gehesa hiꞌahana. To yaꞌma mono bomagi gimi bonaꞌi efahi epiluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Henaꞌmugope? Enali lu epiꞌahana: Yesuhi koko panaꞌamagi foluguꞌi ete gufaꞌa lenali lenubuꞌi kelete nehago gumina lite fenene hiꞌahabe. Ya kaga lu epilo, lite lu epiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","To ana kanisole bomagi kaga mone hiti lu epiꞌahana: To, Lomu kaba bouba yaꞌma lenali lenubuꞌi keꞌahana kagamofihi kehelilenogo lali yaꞌmana aitoga bati hu lepalalune, lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ya lu epiꞌahago gimi bomagi oꞌyo lite efahaꞌani nonaꞌa lilete to mono kanisole bonaꞌi kagaꞌani boanaꞌmagihi yaꞌma lu epiꞌahabe. Yaꞌma faga luseꞌnaꞌani minoba minoba huto bilinaꞌmu yabe. Yatai Yuta bonaꞌi anana keheli amuya meleꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","To Yesuhi koko panaꞌa nayahi luga luga su hago nigigusagati mone heleko malago Galili kapologa bilete koyapaꞌi Yesu mone kosagu enelepiꞌehinaga fo tumala hilune lutomo tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","To nehetite Yesuhi be gelete aitoga agoya hu emiꞌahana. Enali mone lugaꞌamagi yigise loe lae hilete Yesu nohifi fato bo nohifi lite keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu koko panaꞌamagihi ma luto lu epiꞌehina: Kokulumalugu hiti melugu hiti asagaꞌna kaba hilane lutomo Afoꞌnifu yaꞌma nimiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yamuꞌi lenali asaga melugu bonatoga bite nani nagaꞌni eneleꞌmo lolo hilo. To ana bonaꞌmagihi afoꞌnifihi giꞌalo hiti panaꞌamofihi giꞌalo hiti to Sikalafuꞌmofihi enigilo li melete nagamiꞌi folo epalalo. ");
INSERT INTO bef_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","To asaga nani lu lepiꞌohuna ka lenali bite lu enelepinogo kehelite liyafa hite megeꞌi malalabe. To lenali kehelilo. Nani lenali hiti asaga yupahi moneka nohinogoti ma meꞌi su halina kanagu hiti lenali akuꞌi minalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ka lamanaꞌa, Huꞌmamofihi panaꞌa Yesu Kilisito kumu maga hapi fito nogobe. ");
INSERT INTO bef_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Koyapa, ka lu huto huto huꞌehina bouba Aisaiya, Yoni kumu ma luto fayahi goꞌehina: Kehelibo. Nani Huꞌmau kalo lili bonaꞌni ho lifinogo, kohe toto buto kapo hokolo hu ketalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","To ai nogoꞌa ka hepatogati kehe ito ma lilibe: Kibina bo kumuꞌi kapo li hokolo hubo. Ai kumu kapo leꞌmo bati hubo. Ya luto goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","To Yoniu, nagamiꞌi folo epoloꞌehina bouba, ka hepatoga huto hulotoꞌa yafege goloto ma luꞌehibe: Komopatini i gelehe hite, nagami felelenogo, Huꞌmau foipanatini pa so lepalalinagihe. ");
INSERT INTO bef_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ya ligo, Yutia melugu bonaꞌmagi to sipi hepato Yelusale yaꞌma bonaꞌmagi hiti aitoga bite foipanaꞌanimofihi lu hokolo hilago, ai Yotani nagamilugu nagami folo epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","To Yoniu, ai gu kataꞌa kameli yagamofihi okaꞌa nakuꞌi hepiꞌohuto, to kafaꞌnama gufaꞌa gilimi biꞌehibe. To noseꞌnaꞌa kenuꞌi hiti upeꞌmofihi nogoyaꞌa hiti nolata minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","To kaꞌa ma luto lu yege hoꞌehina: Nani nemegeꞌi maꞌasi alina bo ai lusi bo nohibe. Nani faꞌmene bo nohube. Nani bati mehina bomofita, faꞌmene lipito suꞌamofihi nagaꞌi kisi etaluna bati menohube. ");
INSERT INTO bef_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nani nagamitu okala hu lepoloꞌohuna, to ai Sikalafuꞌi ho lifinogo komopatini okala huto leꞌmo bati hu lepalalibe. ");
INSERT INTO bef_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ana kanagu Yesu, Galili kapoguti Nasalete hepatogati ago, Yoniu Yotani nagamilugu nagami folo etoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","To Yesu nagamiluguti notigo anaꞌasilo kokulumaꞌi loko higo Sikalafuꞌuba nama supo huto aitoga nolimigo bu goꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","To kokulumaguti Huꞌmamofihi nogoꞌauba ma luto luꞌehibe: Kai nigi moneko panaꞌni, nebesita panaꞌni nohane. Nani kofokehi gofa nolube. ");
INSERT INTO bef_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","To yalo anaꞌasi Sikalafuꞌuba Yesuhi fitu foto ho lifigo, ai ka melugu buꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Buto melugu nohutoꞌa Satau oto fibe taga ho etoba etoba nohigo, 40 yegegu minoꞌehibe. To ana hepaꞌi ka melugu niꞌigo lopi yagakafa anasi nehanaga minotoꞌa, agelomagi kaba nehi etago minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","To alihi Yonihi naga nonugu leꞌme meleꞌahago, Yesu Galili kapogu nehetito Huꞌmamofihi kapoꞌmu ka lamanaꞌa lu yege nohoto ma luto luꞌehibe: ");
INSERT INTO bef_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Huꞌmau moloꞌehina kana abaga iꞌehinagi, Huꞌmamofihi kapoꞌa huto hilina kanaꞌa maꞌasi aꞌalinaꞌmu yabe. Lenali komopatini i gelehe hitetini ka lamanaꞌa kehelite agoya hi emilo. ");
INSERT INTO bef_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","To Galili nagami beletoga kapo moloto nobuto Simoni to Atulu kogunale faya gutalafa nagamilugu li nemalaꞌigo bu etogoꞌehibe. Etali liliꞌnaꞌatiti faya gutalafa fise bole nehaꞌibe. To Yesu bu etogoto ma lu etimiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Letali fayaꞌi kefefe hilata liliꞌnalo neminaꞌibe. Nemegeꞌi eꞌinogomo, to nani bonaꞌi kefefe hilata bomaleꞌi leteleꞌmo ho tilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ya ligo anaꞌasi faya gutalafaꞌatiti heꞌmilete megeꞌi biꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","To Yesu nesiꞌasi buloto, Sepetihi panaꞌamaleꞌi Yemesi to Yoni bu etogoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Enali ana nagaꞌi botigu nehite faya gutalafaꞌani mu netifigo Yesu bu enogoto anaꞌasi ana loe panate kehe igo etali afoꞌatitifu Sepeti to liliꞌnalo bonaꞌmagihi hiti botigu heꞌmi epelete megeꞌi bifa hiꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","To enali Kapaneami kapogu bite nehetigo yalo fuli yupapogu Yesu mono nonugu tito kaga enelepilubeꞌmu nohuto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","To ka lu noepigo enali yege fite minete ma lite liꞌahana: Ai keheli bati huꞌehina bomofihi supo huto ka lu nolimibe. Mono ka negana bonaꞌmagihi supo huto lu menolimibe. Aiꞌa amuya hiti kagamofihi hapaꞌa lu lelepise nohibe. ");
INSERT INTO bef_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","To yalo ana mono nonugu bo mone komopaꞌagu foipa felemo limiꞌehina bouba nehetito sipi nogo moloto ma luꞌehibe: ");
INSERT INTO bef_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ahi. Yesuo. Nasalete nagaꞌise. Lalitoga henaꞌmu noane? Lali lahalubeꞌmu nohuto noapiye? Nani kaimo keheliꞌohube. Kai Huꞌmamofihi panaꞌa, foipa mehuse bo nohane. ");
INSERT INTO bef_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ya ligo Yesu keleꞌna ka lu emito ma luꞌehina: Kaga meluse nohutoka komopaꞌaguti toto heꞌmi etobo. ");
INSERT INTO bef_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ya ligo foipa feleuba ana bomofihi leꞌmo igo kesepu kesepu ito sipi nogo nomoloto moha tuto heꞌmi etoto komopaꞌaguti tito bufa huꞌehibe. Ya higo asaga bonaꞌmagi topa nehete: Yaꞌma hena huꞌehibe? lite, ai loka hago ai loka hago nehite ma lite liꞌahana: ");
INSERT INTO bef_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yaꞌma yuhufa monoꞌi ahuto huꞌehina niꞌifihe? Ai foipa felemagi kumu ka epekinogo kaꞌa keheli emilata nehabe. ");
INSERT INTO bef_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","To yalo meleꞌisi Yesu kumu ka leliꞌali hite bite asaga hepatoga Galili kapogu niꞌina hepatoga bite kaga beto hite lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","To Yesu ana mono nonuguti limito, Yemesi hiti Yoni hiti limite bite Simoni Atulu kogunale etali nohaꞌatitigu tiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","To ana nonugu, Simonihi yamiꞌafu mukohona nobesigo nebelusalo koꞌehigo enali meleꞌisi Yesuhi ka lu emiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka lu emilago ai buto yato lito ana aꞌmo leꞌmo ho tigo nobesinana anaꞌasi fa hu etago, ai noseꞌna huto gabu ito epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","To utehi yege nolimigo, asaga noepesina bonaꞌi hiti to foipa fele komopaꞌanigu neminana bonaꞌi hiti aitoga eneleꞌmete eꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Asaga ana hepato bonaꞌmagi aitoga ete kasito li gehesa nehago ai fato fato epesiꞌehina bonaꞌi babu lite eneleꞌmo bati huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","To foipa fele komopaꞌanigu nemina bonaꞌmagihi foipa felemagi li heꞌmi epoloꞌehibe. To enali foipa felemagi aimo Huꞌmamofihi panaꞌa nohibe lite keheliꞌahanaya nigiꞌni mehalabe luto Yesu kaga lu laga hu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","To yaloꞌi, etehi foluguꞌi ho tito buto bonaꞌi menemina hepatoga buto nohuto Huꞌmamofitoga kaga luto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","To ya higo Simonigi megeꞌi lifite sa sa hite bite ai nohinalo nehetite ma luto lu emiꞌahana: ");
INSERT INTO bef_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Asaga bonaꞌmagi kai kumu sa nehabe. ");
INSERT INTO bef_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ya lago Yesu ma lu epiꞌehina: Ana, lali kaꞌmuya nina hepatoga buloto nani ana huto ka lu epilube. Nani ana liliꞌnalo aoꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ya luloto buto asaga Galili kapogu bego bego huto mono nohaꞌanigu tito ka lu noepito, to foipa fele li heꞌmi epololata huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To yaloꞌi hehe bo hepuhaꞌa gofana huꞌehina bo moneuba aitoga lahupa nohi fito amuya moloto ma luto loka hoꞌehina: Oho. Neleꞌmo bati hilapiye? Keheliꞌahata bo nohatagi, neleꞌmo bati hilapiye? luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ya ligo Yesu sipi kekeꞌi nolu etoto yahi li su toto bako huto ma lu emiꞌehina: Ana hu ketalube. Gufa hu bati hino. ");
INSERT INTO bef_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ya ligo anaꞌasi gufalo hehe nobesinana i gololo tigo gufaꞌa gulu gulu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","To Yesu amuya ka lu emito ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kehelibo. Kai yaꞌma hu ketoꞌohunana ka lu meepise minotoka buto sipi mono nonugu tito mono bo kugufaka lepitogo to Moseu koyapa lu moloꞌehinana emiletogo, asaga bonaꞌmagi bu kegelete kugufaka gulu gulu luꞌehinaya kehelilabe. ");
INSERT INTO bef_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ya luto ho lififa hu etoꞌehigo ai akuꞌi kaga beto huto luba luba higo, asaga bonaꞌi kehelite Yesutoga li gehesa sipi hiluneꞌmu nehago Yesu faꞌmene enubuꞌanilo olopa hepatoga metise nohuto holupagu nohigo bonaꞌmagi yege yege hepatogati aitoga eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kana nesiꞌasi su holago Yesu Kapaneami hepatoga nehetito nonuga tiꞌehibe. Ya higo asaga bonaꞌmagi: Nohaꞌagu tito nohibe, lite keheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","To ai nonugu minoto Huꞌmamofihi kagamo lu noepigo, babu bonaꞌmagi anaga bite li gehesa nehite kasihaꞌalo ikini ikini hite minago kapo mone hokolo mehuꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","4","Ya huto niꞌigo, loegi loegi bomagi keni bo mone aitoga leꞌmete aluneꞌmu nehite ago, to kasito bonaꞌi mino kikipa heꞌahago aitoga lebatoꞌisi mebise nehite tite nohupitalo li hokolo hiꞌahabe. Ai nohinalo li hokolo hiteꞌani to ana hokolo kapoguti keni bomofihi nebelusalo nokago leꞌmo heꞌmi etago limoto koꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Enali Yesu leꞌmo bati hilibe lite enegekesa kehelite leꞌme heꞌmiꞌahabe. To Yesu yaꞌma enegekesa keheliꞌahanana komopaꞌatu keheliloto keni bomofihi ma luto lu emiꞌehina: Panaꞌni, nani foipanaka ali noheꞌmi ketobe. ");
INSERT INTO bef_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","To ya ligo, enali mono ka negana bonaꞌmagi anaga nehanaloti kehelite ma lite enegekesa yigiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yaꞌma bo henabe luto ya nolibe? Yaꞌma foipana li heꞌmi epololata kiyiꞌafu nohibe? Huꞌmau aigo ya hulata bo nohina niꞌibe. To ai yaꞌma bouba Huꞌmamofi kumu megeka nolibe. ");
INSERT INTO bef_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","To Yesu anaꞌasi yaꞌma enegekesa neyiginana komopaꞌatu keheliloto ma luto lu epiꞌehibe: ");
INSERT INTO bef_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lenali henabe lite yaꞌma lenegekesa neyigibe? Keta mehuse supo hiyaꞌa niꞌibe? Nani keni bomofihi foipanaka li noheꞌmi ketobe, luto lu emiꞌohuna yaꞌma keta huꞌehina suhi huꞌohufiye? Oꞌe. To ho tito nebelusaka kofito bubo luto lu emutita yaꞌma keta hinaga lutitaꞌmu niꞌifiye? ");
INSERT INTO bef_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","To nani Kokulumaguti limiꞌohuna Bo nohuna, amuyaꞌni hiti bo nohutoꞌni melugu bonaꞌmagihi foipanaꞌani pa so epololata bo nohunagihe. To lenali yaꞌma kehelilabe luto lenelepilube. ");
INSERT INTO bef_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ya luloto ai keni bomofihi ma luto lu emiꞌehina: Kehelibo. Lu nokumube nolugi kai ho tito nebelusaka kofito bufa hubo. ");
INSERT INTO bef_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To ya ligo ana bouba anaꞌasi ho tito nebelusaꞌa kofito bufa huꞌehigo, enali asagaꞌi yege fite topa hete Huꞌmamofi kumu fokehi lite ma liꞌahana: Akae. Lali koyapa bu megoꞌohuta suhi yatai li huto hibe. ");
INSERT INTO bef_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","To Yesu mone kanagu ana huto nagami beletoga buto nohigo to asaga bonaꞌmagi aitoga bite li gehesa nehago ai kaga lu epito minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","To anagati heꞌmito buto Alifiasihi panaꞌa Libai takisi nonugu nohigo bu goto ma lu emiꞌehina: Ma bo yale. Kai nemegeꞌi obo. To ya ligo, ai ho tito megeꞌi buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","To alihi babu bonaꞌmagi Yesuhi megeꞌi nebite ai hiti panaꞌalobomagi hiti to takisi bomagi hiti foipa bomagi hiti babu lite Libaihi nohaꞌagu noseꞌna nete nehago enali Felosi bomagi to mono ka negana bomagi hiti enali ete bu geꞌahabe. Ai Yesu takisi bomagi hiti foipa bomagi hiti noseꞌna nenago enali bu gete panaꞌalobomagihi ma lite enoloka heꞌahana. Ai yaꞌma takisi bomagi hiti foipa bomagi hiti henabe luto nenabe? ");
INSERT INTO bef_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","To Yesu, yaꞌma nelana ka kehelito ma luto lu epiꞌehina: Bati hite neminana bonaꞌmagi lusa bo kehe neifiye? Oꞌe. Epesiꞌehina bonaꞌmagi kehe neibe. To nani ana huto bati hite neminana bonaꞌmagi kumu menoobe. Nani foipa bonaꞌmagihi kehe ito eneleꞌmo bati hilube luto aoꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","To ana kanagu Yoni, nagami folo epolose bo ai hiti to panaꞌalobomagi hiti to Felosi bomagi hiti enali nunumu hiluneꞌmu nehite noseꞌna mo site li pisigilete mineꞌahabe. Ya hilata nehago bonaꞌmagi Yesutoga ete ma lite loka heꞌahabe: Yaꞌma Yonihi panaꞌalobomagi to Felosi bomagi hiti noseꞌna mo site li pisigilata nehabe. Ya hago to kaika panaꞌaloboka henabe lite noseꞌna mo site li pisigilete meneminabe? ");
INSERT INTO bef_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ya lago, Yesu ma luto lu epiꞌehina: Mone panaꞌmofihi lihaꞌa mina filuneꞌmu nehana yupahi ana panaꞌuba faluꞌagi hiti noseꞌna mo site li pisigilete neminafihe? Lali Yuta bona hapati ya huto niꞌifihe? Oꞌe. ");
INSERT INTO bef_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","To alihi yupahi ana panaꞌuba eneheꞌmito buto lihaꞌa hiti minalaꞌina kanagu, faluꞌagi kekeꞌi li etete li pisigilete minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","To, katamo tafa loto pekene hulenogo enali yuhufa katatu li bati hilune lite nehe metibe. Ya hatita akuꞌi yuhufana nesi notago tafanaꞌa hilune lite menehetibe. Ya hatita akuꞌi yuhufana nesi notago tafanaꞌa hetiꞌehina kapolo i lala bititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","To ana huto, bai nagamiꞌi yuhufana lolo hilete tafa kopogu heki menebibe. Ya hatita, alihi bai nagamiꞌuba hofa toto bilito kohi fi polo huto sibina hulago, nagamiꞌi limi su hatitaꞌmu yabe. Yuhufa bai nagamiꞌi yuhufa kopogu heki nebina yabe. Yesu ya luto kaꞌanilo nonaꞌa lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","To alihi mone fuli yupahi Yesu panaꞌalobo hiti foya kapogu nebite, panaꞌalobomagi hapi fite noseꞌna legeyaꞌa nesiꞌasi ligite nenete biꞌahabe. Ana noseꞌna laisi tegina niꞌina noseꞌna ligite neꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","To ya nehago, Felosi bomagi bu enegete ma lu emiꞌahana: Bu gobo. Fuli yupahi lu laga huꞌehina supo kai panaꞌaloboka henabe lite nehabe? ");
INSERT INTO bef_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ya lago ai ma lu epiꞌehina: Lenali mono kalugu bu megeꞌahafiye? Koyapasana Abiata sipi mono bo minoꞌehina kanagu yaꞌma sipi bouba Tebitiu kauꞌna gofa nohago buto Huꞌmamofihi nonugu tito anagati Beleti noseꞌna lito noꞌehibe. Nonoto to ai hiti nehana bomagi epilago neꞌahana yabe. Ana mono beleti noseꞌna Lepise Beleti yabe, lite gi nehana yaꞌma noseꞌnamofihi faꞌmene bomagita nalana lu laga hiꞌahana yabe. Mono bomagi anasi nalabe lite meleꞌahana niꞌibe. To ana beleti noseꞌna Tebitiu kauꞌna gofa nohago lito noꞌehina ka mekeheliꞌahafiye? Mono kalugu bu megeꞌahafiye? ");
INSERT INTO bef_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","To mone hiti ma luto lu epiꞌehina: Huꞌmau fuli yupahi henaꞌmu leꞌmo huto huꞌehibe? Bonaꞌmu leꞌmo buto huꞌehina yabe. Lenali bonaꞌmo fuli yupapomuꞌi leneleꞌmo huto mehuꞌehina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","To ya higo nani Kokulumaguti limiꞌohuna Bomofita nani fuli yupahi kaba bo nominobe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mone kanagu hitimono nonugu tiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","To ana nonugu bo mone yahi yufu noꞌehina bo nohigo, enali Felosi bomagi Yesu fuli yupapogu leꞌmo bati hilifi lite mapahi fite mineꞌahana yabe. Enali ai ya hulenogo bugu ka emekilune lite mapahi fite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ya nehago, Yesu yahi yufu noꞌehina bomofihi lu emiꞌehina: Ho tito maga obo, luto lu emitoꞌa yalo enali kumu ma luto enoloka habe: ");
INSERT INTO bef_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Fuli yupapogu nani hetofa suhi hilufi sibi suhi hilube? Bomo leꞌmo bati hilufi keye lilube? Hiyaꞌa etoꞌehina suhi niꞌibe. Lenali ka lu nimilo. Ya ligo enali kaga meluse mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ya nehite komopaꞌani uleꞌale hite nehago Yesu ipagu gabu gigo ipaluga logo bigo buluꞌi enohoto bu golotoꞌa yalo ana bomofihi: Kayahi su tobo, luto lu emigo, ai yahi su tolago hetofa yahaꞌa legita lolo huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yesu ya hu etago Felosi bomagi anaꞌasi limite Helotihi nagaꞌi hitiꞌi kaga lite boga liꞌahabe: Lali yaꞌma Yesuhi hiyaꞌa huto ho fililune lite boga liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","To Yesu panaꞌalobomagi hiti anagati heꞌmite bite Galili nagami beletoga bi fa hiꞌahago, yege yege boanaꞌmagi Galili kegiꞌati Yutia kegiꞌati Yelusale hepatogati, Itumia kapoguti, Yotani nagami muya beletogati ete to Taiya kegiꞌati, Saitoni kegiꞌati, babu lite yege yege bonaꞌmagi Yesu huꞌehinana kehelilete aitoga eꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ya hite babu bonaꞌmagi eꞌahago, Yesu: Nani lilika ilafiye? luto ekesa yigitoꞌa panaꞌalobo kumu: Lagaso boti mone li bati hi netalo, luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ai epesiꞌehina bonaꞌmagihi babu lite eneleꞌmo bati huꞌehigo, yalo epesiꞌehina bonaꞌmagi yege yegeꞌna aitoga akuꞌi li gehesa hite, aimo bako hilune liteꞌani aitoga ikini ikini hite li gehesa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","To foipa felemagi Yesuhi bu geleteꞌani aitoga kana futite kete sipi nogo melete: Kai Huꞌmamofihi panaꞌa nohane lite lilata hiꞌahago, ");
INSERT INTO bef_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu: Ya kaya melise minalo, luto enekesa lito lu laga huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","To yaloꞌi Yesu kosagu tito minotoꞌa, bita huꞌehina bomagi kumu kehe igo aitoga biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","To aitoga ago ai 12 bomagi eneleꞌmo ho tiꞌehibe. Enali aposolo bonaꞌi yabe luto enigi moloꞌehina to enali ai hiti minalabe luto eneleꞌmo ho tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","To ai enoho lifilenogo bite kaga lu epilabe luto to foipa felemagihi eneheꞌmi epalalabe luto eneleꞌmo ho tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ana 12 bomagi enigiꞌani yaꞌma yabe. Simoni, ai giꞌa mone Pita yabe lite gi nehana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","To Yemesi Yoni kogunale, etali Sepetihi panaꞌale yabe. To etigiꞌatiti moneꞌa Boanege yabe lite gi heꞌahana yabe. Enali kaguti kokililika nasanamofihi panaꞌamaleꞌi yabe lite etigi meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","To Atulu yagi, Filipi yagi, Batolomu yagi, Tomasi yagi, Yemesi ai Alifiasihi panaꞌa ai yagi, Simoni ai Kena kapoguti bo ai yagi, ");
INSERT INTO bef_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","To Yutasi ai Kelioti kapoguti bo yabe. Ana bouba ai alihi Yesuhi gutunu ka fatehaꞌamagihi lu epiꞌehina bo yabe. Enaligo eneleꞌmo ho tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","21","To Yesu yaꞌma aposolo bomagihi eneleꞌmo ho tilotoꞌa yalo hepaꞌaga bufa huꞌehibe. To ya higo bonaꞌi babu lite aitoga akuꞌi bite li gehesa hilago, Yesugi panaꞌalobomagi noseꞌna menese mineꞌahanagihe. To ya hago Yesuhi bonaꞌamagi yaꞌma kehelilete: Sibi lalibe, lite bite aimo anagati leꞌmo nu kite bufa hiluneꞌmu habe. ");
INSERT INTO bef_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","To Yelusale hepatogati mono ka negana bomagi limite Yesu kumu ma lite liꞌahabe: Oho. Ai komopaꞌagu foipa feleuba, olopa felemo, giꞌa Bielesebulu, ana feleuba komopaꞌagu tito nohibe. To ana amuya feleuba aimo leꞌmo amuya nomalago ai bonaꞌi komopaꞌaniguti fele li noheꞌmi epalabe. ");
INSERT INTO bef_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ya lago, Yesu enali kumu kehe igo ago kaga mone fono ka luto lu noepito yaꞌma enoloka hoꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Satau ai hiyaꞌa huto Satahi leꞌmo heꞌmilibe? Ya huto meniꞌibe. To moneko nagaꞌi loko hilete ai henogo ai henogo nehite minalana, enali moneko nagaꞌi minalafihe? Oꞌe. ");
INSERT INTO bef_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","To moneko lalamete loko hilete ai henogo ai henogo nehite minalana, moneko lalamete minalafihe? Oꞌe. ");
INSERT INTO bef_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","To ana suhi huto Satahi nagaꞌi loko hilete ai leꞌmo heꞌminogo ai leꞌmo heꞌminogo nehite minalana, monekoꞌi minalafihe? Oꞌe. Ana nagaꞌi su halina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","To bo moneuba amuya bomofihi feꞌnopo gumina lilubeꞌmu nohuto yataꞌa hena hilibe? Ai yataꞌa ana amuya bomofihi nagaꞌmotu sa gi uleꞌale hulotoꞌa, alihi nohaꞌagu tito feꞌnohaꞌa bauna hilibe. ");
INSERT INTO bef_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","To ya huto niꞌigo, nani kaꞌni lusiga luto lu lepilunagi keheliꞌehilo. Bonaꞌmagihi foipanaꞌani silagaꞌna Huꞌmau pa so epalalibe. To ana huto megeka nelanaꞌani fato fatoꞌna pa so epalalibe. ");
INSERT INTO bef_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Akuꞌi monekoꞌna pa meso epalalinaꞌa niꞌibe. Aiꞌa Sikalafuꞌamofi kumu megeka linogomo pa meso epalalinaꞌmu yabe. Yaꞌma enugupisalo minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ya luto mono ka negana bomagihi lu epiꞌehina yabe. Henabe lutobe? Enali komopaꞌagu foipa feleuba tito nohigo yaꞌma yege fise suhi nohibe lite lago ai ya luto ka epekito lipoti epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","To alihi itoꞌafu to gonaꞌamagi ete nehetite fegutoga minete, bo moneꞌa ho lifigo tito Yesuhi kehe iꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ya higo, aitoga li gehesa hite minana bonaꞌmagi ma lite lu emiꞌahana: Buga. Itokagi kogonakamagi ete nehetilete fegutoga minete kai kumu kehe neibe. ");
INSERT INTO bef_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","To ai: Yaꞌma itoꞌnigi to nogonaꞌni kuyu kuyu nehabe, luto lutoꞌa yalo aitoga neminana bonaꞌmagihi bu go beloloto ma lu epiꞌehina: Bu galo. Yaꞌma bonaꞌmo itoꞌnigi nogonaꞌni nehabe. ");
INSERT INTO bef_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yaꞌma Huꞌmamofihi kaꞌa kehelite agoya hi emilata nehanamagi enali nogoꞌnigi netaliꞌnigi itoꞌnigi nehana yabe, luto Yesu ya lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","To mone yupahi hiti Yesu Galili nagami beletoga buto nohuto kaga lu noepitoꞌa to babu bonaꞌi aitoga li gehesa nehago ai boti nagamilugu niꞌigo buto tito anagu minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","To asaga bonaꞌmagi nagami beletoga meto minete kehelite mineꞌahabe. Ya hago ai fono kalugu asaga kaga lu noepito ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kehelilo. Bo moneuba noseꞌna bigahaꞌa tili huto kafalube luto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","To tili hu noheꞌmigo bigahaꞌa mone kegiꞌa soto limiꞌehigo namamagi ete fine pine hite ne su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","To mone kegiꞌa me balafaga limito to meꞌa nesiꞌasi niꞌigo meleꞌisi tiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tiloto yalo lufusaꞌa meniꞌigo, to yege tito lolago, meleꞌisi lo hosopa ito lo i pigiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","To mone kegiꞌa foya kifigu limiꞌehinaꞌa foya kifiuba tito noi etago, legeya mehoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","To mone kegiꞌa hetofa melugu limiꞌehinaꞌauba meluguti fifaya nolito tito legeya hoꞌehina yabe. Mone 30 hoto mone 60 hoto to mone 100 hoto legeya hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ya huꞌehina fono ka yabe. Lenegekesatini niꞌina bonaꞌi ka keheli fe lilo. ");
INSERT INTO bef_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu ya lulago alihi bonaꞌmagi bi su helago aiꞌa panaꞌalobo 12 magi, to anaga minana bonaꞌmagi fono kamofihi hapaꞌamuꞌi loka heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","To ai ma luto lu epiꞌehina: Lenali Huꞌmamofihi kapoꞌamuꞌi suguna ka hekele lite kehelilabe. To enali fegutoga bonaꞌmagihi fono ka anasi lu noepube. Henaꞌmube? ");
INSERT INTO bef_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Enali bu geba bu geba nehite bu megalabe. To keheliba keheliba nehite mekehelilabe. Enali kehelitita komopaꞌani i gelehe hinogo Huꞌmau foipanaꞌani li heꞌmititaꞌmu yabe. To enali mekehelilabe luto fono kalugu lu noepube, Yesu ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","To Yesu ma luto lu epiꞌehina: Lenali yaꞌma fono kamofihi hapaꞌa mekeheliꞌahafiye? Ana, asaga fono ka hiya hite kehelilabe? Hapaꞌa yaꞌma yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Noseꞌna tili huꞌehina bouba ai Huꞌmamofihi kaga tili hu noheꞌmibe. ");
INSERT INTO bef_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","To tili hu noheꞌmigo soto limiꞌehinaꞌa yaꞌma ma hise bonaꞌmo nehabe. Enali kaga kehelilago anaꞌasi Satau oto komopaꞌaniguti kagamo enebe nosilibe. ");
INSERT INTO bef_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","To me balafaga limiꞌehinaꞌa yaꞌma ma hise bonaꞌi nehabe. Enali kaga kehelite anaꞌasi enegelo bite kagamo komopaꞌanigu li melete hupamone kanagu ya hite minete yalo akuꞌi bonaꞌmagi ana kagamomuꞌi fi taga nehi epelete to enegene mane inogo, enali kaga meleꞌisi neheꞌmibe. Lufusaꞌani meniꞌigo meleꞌisi neheꞌmibe. ");
INSERT INTO bef_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","To foya kifigu limiꞌehinaꞌa yaꞌma ma hise bonaꞌi nehabe. ");
INSERT INTO bef_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Enali kaga kehelileteꞌani akuꞌi nasanaꞌanimuꞌi enegekesa keheli keheli hite minete to efahaꞌanimuꞌi enofokehi lite minete to fato fatoꞌnamuꞌi laga epesinogo mineteꞌani kaga neheꞌmibe. Yaꞌma luna lanauba kagamo noi etago komopaꞌanigu legeya menohabe. ");
INSERT INTO bef_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","To hetofa melugu limiꞌehinaꞌa yaꞌma ma hise bonaꞌi nehabe. Enali kagamo kehelite komopaꞌanigu li nemalabe. Ya nehago kagauba komopaꞌanigu tito legeya nohabe. Mone 30 hoto, mone 60 hoto, to mone 100 hoto nohabe. Yaꞌma fono kamofihi hapaꞌa ya niꞌibe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","To ka mone hiti ma luto lu epiꞌehina: Bonaꞌmagi libiꞌmo li giteꞌani somomotu ifi netafi sipa kapogu fala nekifi hitalo nemalabe? Hitalo nemalana yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","To Huꞌmau ana huto yatai fala kiꞌehinana asagaꞌi alihi leꞌmo huto hilibe. To sugunaꞌasi ifi toꞌehinaꞌa alihi lu hokolo hilibe. ");
INSERT INTO bef_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lenegekesa nina bonaꞌi ka kehelilo. ");
INSERT INTO bef_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","To ma ka hiti lu epiꞌehina: Lenali nekehelina kagamomuꞌi kaba hite minalo. Huꞌmau ka kehelilata bomofitoga kaga hapaꞌa mone hiti lu emilibe. To kaga mekehelilata bomofitoga mone nesiꞌasi keheliꞌehina kagamofihi hapaꞌa akuꞌi fala ki etalibe. Huꞌmau ya huto lenali aitoga hi emilata supo huto akuꞌi babu luto hu epalalibe. ");
INSERT INTO bef_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","To Yesu ma kaga lu epiꞌehina: Huꞌmamofihi kapoꞌa legi huto ma niꞌibe. Bo moneuba noseꞌna bigahaꞌa foyagu tili hu heꞌmiloto, ");
INSERT INTO bef_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","yalo buto foluguꞌi buꞌi kola etehi ho tila huto minotoꞌa noseꞌna boloto tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","To hiya huto notina ana bouba menokehelibe. Aiꞌa meluguti notina yabe. Kapaꞌa yataꞌa fifaya nolito tiloto gelemuꞌa hu mololoto yalo legeyaꞌa hu nomalabe. ");
INSERT INTO bef_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","To ana legeyaꞌa hosa lolenogo ana bouba tagaluna kanaꞌa leba notabe luto buto notagabe. ");
INSERT INTO bef_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","To Yesu ma luto lu epiꞌehina: Huꞌmamofihi kapoꞌa hena legita niꞌibe? Lali hena fono ka luloto hapaꞌamofihi lu hokolo hilune? ");
INSERT INTO bef_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Yaꞌma legita niꞌibe. Noseꞌna moneꞌmofihi bigahaꞌa kitili keteleꞌasi niꞌinagi akuꞌi melugu kofolenogo tito asaga noseꞌna bege ligito sipina huto tito yahaꞌa haꞌi fito niꞌinogomo namamagi samapaꞌagu nohaꞌani negibe. Huꞌmamofihi kapoꞌa ana noseꞌna legi huto hofa notabe. ");
INSERT INTO bef_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","To Yesu fato fato fono ka ana huto lu epiꞌehibe. To enali boanaꞌmagi mone kehelilago mone hiti lu epila huto minoꞌehibe. Yege yege kagamo fono kalugu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","To asaga bonaꞌi nehago fono kagutiko anasi kaga lu epiꞌehina, to alihi bi su helago aiꞌa panaꞌaloboꞌa enaligo nehago ai yaꞌma kaga hapaꞌa asagaꞌna lu hokolo hu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","To, ana yupahi utehi lulago Yesu panaꞌalobomagihi ma luto lu epiꞌehina: Nagami muya beletoga bilune. ");
INSERT INTO bef_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ya luto ligo enali asaga boanaꞌi heꞌmi epelete ai hiti botigu tite biꞌahabe. To fato fato boti hiti hetegete biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ya hite nebago sipi abafahuba lito nagamiꞌi bilitoꞌa i gala fuka ito botigu tigo bai talubeꞌmu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","To ya nohigo, Yesu boti siꞌagu nebelusalo buꞌi nokago, enali leꞌmo ho tite ma lu emiꞌahana: Oho. Babafio, lali afililuneꞌmu nohutaya kai faꞌmene minalapiye? ");
INSERT INTO bef_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ya lago Yesu ho titoꞌa abafahi ka emekitoꞌa to nagamiꞌmofihi: Lege nobo. Legeso hubo, luto lu emigo abafahuba lege noto to nagamiꞌuba legeso huto fulu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","To yalo Yesu ma luto lu epiꞌehina: Lenali henabe lite koli hiꞌahabe? Nani kaba hu lepalaluna niꞌinaya mekeheliꞌahafiye? Nanitoga lenemehi menimise keheli uleꞌale mehiꞌahanafiye? ");
INSERT INTO bef_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","To ya ligo, enali enelesaꞌani gofa noligo ai lu emigo ai lu emigo hite ma liꞌahabe: Akae. Yaꞌma bo kiyiꞌafu nohibe? Ai abafapomuꞌi nagamiꞌmomuꞌi kaga noligo ka keheli emiꞌahaꞌibe. Enali ya lite topa heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","To enali nagami muya beletoga, Gatala bonaꞌmagihi kapoꞌanigu nehetite, to Yesu botiguti nolimigo anaꞌasi bo moneuba foipa fele ekesa igo negi noꞌehina bouba kene mala mala hepatogati oto aitoga oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ana bouba kene mala mala hepatoga minolata huꞌehina yabe. To bonaꞌmagi faꞌmene nagaꞌmotu to seni nagaꞌmotu ana bomofihi sa gi uleꞌale hago, ai li hepulu tulata huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fato fato yupapogu, seni nagatu sa gilago ai ana nagaꞌi li hepulu tutoꞌa to gi yahaꞌalo giꞌahana nagaꞌi li pa solata huꞌehina yabe. Ana bouba lopi fito minago enali leꞌmo fulu mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ai asaga yupapo foluguꞌi fuligahi hiti kene mala mala hepatoga hiti to kosalo hiti minotoꞌa, efapotu gufaꞌa laga hulata to sipi nogo moloto ahi ahi lulata huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","7","Ana bouba Yesu fotoꞌi noago, bu goto hololu luto buto aitoga lahupa nohi fito minotoꞌa sipi nogo moloto hekele luto ma lu emiꞌehina: Oho Yesuo, Huꞌma sipi kibinamofihi panaꞌa nohane. Henana hu netalubeꞌmu noane? Oho, menohobo. Huꞌmamofihi giꞌa hoto koloka nohobe. Menohobo. ");
INSERT INTO bef_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesu ana felemofihi: Ma bomofitogati heꞌmi etobo, luto lu emiꞌehigo ai ya lu emiꞌehinagihe. ");
INSERT INTO bef_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","To ya ligo Yesu: Kigika ho nimibo ligo ai: Nigiꞌni Yege yegeꞌnao yabe, lutoꞌa, lali yege yege fele nohutagihe, luto lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","To ya luloto Yesuhi buka tito: Ke. Feleꞌnimagi mana kapoguti neleꞌmo meheꞌmibo luto amuya moloto loka hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","To kosalo lebatoꞌisi, babu yagamagi lomi kifite nenago felemagi bu gete: ");
INSERT INTO bef_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ke. Yagamagitoga loho lifitogo buto enali hiti minalune, lite Yesuhi loka heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","To ya lago, Yesu: Oꞌyo. Anaga bilo, ligo foipa felemagi ana bomofitogati heꞌmi eteteꞌani bite yagamagihi komopaꞌanigu tite falago, ana yaga, 2000 magi hololu lite nemebite yabaꞌmogu limite nagamilugu felete filiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ya hilago, yaga kaba bonaꞌmagi sipi koli hite meꞌme hite bite hepatoga bonaꞌi to kifigu bonaꞌi hiti asagaꞌi ana ka beto hite lu epite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yalo asaga bonaꞌmagi ete bu galune lite ete Yesutoga nehetite, to ana negi bo ekesa hokolo higo kata bito legeso huto meto nominago bu gelete enelesaꞌani luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","To enali bu geꞌahana bonaꞌmagi bite ana negi boꞌmu to yagamagi kumu kaga beto hilago, ");
INSERT INTO bef_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","asaga bonaꞌmagi ete Yesuhi ma lu emiꞌahana: Kai abufa hubo. Hepatiloti heꞌmito bubo lite ka liba liba hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","To ya lago, Yesu enalitogati heꞌmito buto botigu notigo, ana negi bouba oto: Kai hiti biluꞌibe, luto buka tito loka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","To Yesu ma lu emiꞌehina: Oꞌe. Kai hepakaloga buto bonaka lu epibo. Sipi Bo, Huꞌmau kekeꞌi nolu ketoto keleꞌmo bati huꞌehinamofihi asagaꞌi buto lu epibo. Huꞌmau amuyaꞌa hiti bouba keheꞌmoꞌehina ka yaꞌma beto huto lu epibo. ");
INSERT INTO bef_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ya ligo ai keheliloto buto Tekapoli hepatoga asagaꞌi bego bego huto, Yesu hu etoꞌehinamofihi asagaꞌi yaꞌma ka beto huba huba higo, silaga bonaꞌmagi yege fite topa heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","To Yesu botigu tito nagami muya beletoga akuꞌi nehetitoꞌa nagami nekisaꞌalo nohigo, babu bonaꞌmagi aitoga li gehesa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Ya nehago, mono nohi kaba bo moneuba, giꞌa Yailusi ai Yesuhi bu nogoto oto aitoga lipito minoto amuya moloto ma luto loka hoꞌehina: Oho. Lagaso paꞌni sibina nobesigo maꞌasi fililubeꞌmu nohibe. Kai buloto kayahi gufaꞌalo li keheli etetogo mefilise ye koto fulu besilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ya ligo, Yesu kehelito ai hiti biꞌahaꞌibe. To nebaꞌigo yege yege bonaꞌmagi etali hiti hetegete nebago ikini ikini huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","To aiꞌi moneuba sopaluga buba buba huꞌehina aꞌmouba anaga nobina yabe. Ana aꞌuba 12 foya kanagu ya huto minoto, ");
INSERT INTO bef_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","efahaꞌa asaga lusa bomagihi epi su hago to enali luna lana asagaꞌi hi etete leꞌmo bati mehi eteꞌahanaya ai gabuꞌi nogigo minoto lusina nobesigo mone gofana huto minomo buto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ana aꞌuba enali Yesuhi kaga nelago, kehelito buto komopaꞌagu ekesa kehelito ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nani kataꞌa anasi bako hulenogo nebesiseꞌna fa hu netalinaꞌmu yabe. Ya luto buto asaga bonaꞌmagi nebana hiti butoꞌa Yesuhi megeꞌi buꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","To kataꞌa bako higo Yesu anaꞌasi amuyaꞌa bu su hoꞌehina komopaꞌatu kehelito i behe huto bonaꞌmagihi enoloka hoꞌehina: Kiyiꞌafu kataꞌnilo bako huꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ya ligo, panaꞌalobomagi ma lu emiꞌahana: Akae. Silaga bonaꞌmagi kaitoga ikini ikini hite nehago bu goꞌahane. To kai, kiyiꞌafu bako he netoꞌehibe luto nolataya henabe lutobe? ");
INSERT INTO bef_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ya lago ai bu go beloloto bako hu netoꞌehina bonaꞌi bu galube luto bu go beloloꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ya nohigo ana gufaꞌa leꞌmo bati huꞌehina aꞌuba ai ekesa nokehelito koli nohuto to afoya foya noito oto, aitoga lipito asaga ka lu hokolo huto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ya ligo Yesu kehelito ma luto lu emiꞌehina: Oho, paꞌnimaka. Kai nanitoga keheli uleꞌale huꞌahata yanauba kugufaka leꞌmo bati hibe. Kebesiꞌehinana yatai fa hu ketoꞌehinagihe. Kelesaka melinogo fulu huto bubo. ");
INSERT INTO bef_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","To Yesu ya noluto nohigo, Yailusihi nohaꞌagati bonaꞌi lugaꞌamagi ete ma kaga liꞌahana: Pakamo afili su hoꞌehina yabe. Ma babafi bo leꞌmo heꞌmibo. Ai yatai li mekeheꞌmalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","To Yesu kehelito enali kaꞌani heꞌmito to anaga bilubeꞌmu nohutoꞌa ai mono nohi kaba bomofihi ma luto lu emiꞌehina: Kai koli mehubo. Nanitoga keheli uleꞌale huto minobo. ");
INSERT INTO bef_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","To ya luloto Pitagi Yemesigi to Yemesihi gonaꞌa Yonigi enaligo eneleꞌmoto buto mono nohi kaba bomofihi nohaꞌaga nehetiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nehetigo, anagu bonaꞌmagi li nupa hite: Akae, akae, lite yibi nama hite nehago Yesu bu goto nonugu tito ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lenali henabe lite sipi nogo melete yibi hafili nehabe? Yaꞌma paꞌi mefilise nohuto faꞌmene buꞌi nokabe. ");
INSERT INTO bef_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ya ligo enali: Faga yabe lite, kiya hi etago ai enali nonuguti eneleꞌmo heꞌmitoꞌa ana paꞌmofihi itoꞌafu hiti afoꞌafu hiti to ai hiti eꞌahana panaꞌalobomagi hiti eneleꞌmoto buto ana paꞌi koꞌehinalo hasagu tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","To ana paꞌmofihi yahaꞌa lito kaꞌaguti Taliya kumi luto, lali kaguti ma luꞌehibe: Paꞌnise, ho tibo lutoꞌni lu nokumube. ");
INSERT INTO bef_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ya ligo, anaꞌasi meleꞌisi ana paꞌmouba koꞌehinagati ho tito humofaꞌna higo, enali sipi enelesaꞌani lite yege fiꞌahabe. Ana paꞌmofihi foya kanaꞌa 12 yabe. ");
INSERT INTO bef_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","To ho tito humofaꞌna nohigo Yesu: Ma paꞌmofihi noseꞌna moneꞌa lite ete emilo, lutoꞌa yalo amuya ka lu laga huto ma luto ka epekiꞌehina: Lenali yaꞌma asaga bonaꞌmagihi ka lu meepilo. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","To Yesu ana kapoguti heꞌmito buto kapoꞌaga nehetigo panaꞌalobo hiti bite nehetiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","To fuli yupapogu Yesu mono nonugu tito nominoto kaga hapi fito lu epito nohigo, enali kehelite otopa hete ma liꞌahana: Akae. Yaꞌma ka kiyiꞌafu lu emigo nolibe? To keheli fe luseꞌnamo hiyagati kehelito nohibe? To ai mana hepato bo nohinaya yaꞌma topa hose foya liseꞌnamofihi amuyaꞌa hiyaꞌagati liꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ai nohi gise liliꞌnalo bo nohina, ai faꞌmene Maliahi panaꞌa nohina yabe. To Yemesigi Yosesegi Yutasigi Simonigi enogoꞌanifu nohibe. To etaliꞌagi mana hepatiga nehana yabe. Ai hepatilo bo nohinaya yaꞌma ka nolinaꞌa hiyaꞌagati keheliꞌehibe? ");
INSERT INTO bef_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ya lite ai kumu enipagu sibina hite mineꞌahana. Ya hago Yesu ma luto lu epiꞌehina: Ana, lenali hapatini ya huto niꞌibe. Huꞌmamofihi kaꞌa lu huto huto bo moneꞌmofi kumu asaga bonaꞌmagi fokehi nelibe. Ya huto niꞌinaya akuꞌi aiꞌa bonaꞌa hiti hepaꞌalo bonaꞌmagi hiti to ai lalamehaꞌa hiti enali fokehi menelibe. Hapaꞌa ya huto niꞌibe. To lenali ya hapaꞌamu megeꞌi melelata nehabe. Yesu ya lu epiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","To enali enipa sibina higo, Yesu anaga topa hose foya melise nohuto epesiꞌehina bonaꞌi loeꞌasi yatu bako hutoꞌa eneleꞌmo bati huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Enali aitoga keheli amuya memelese komopaꞌani uleꞌale higo, Yesu topa hoto enali kumu ipagu gabuꞌi giꞌehina yabe. To anagati heꞌmito buto lebato hepatoga asagaꞌi bego bego huto buto ka lu enelepimofaꞌna huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","To yalo Yesu panaꞌalobo 12 magi kehe igo agoꞌa ma luto lu epiꞌehina: Nani yatai lenoho lifinogoꞌni bite bonaꞌmagi komopaꞌaniguti foipa fele eneleꞌme heꞌmilabe. Lenali loemo loemo hite bilo. To ya hite loemaleꞌita bitetiti ma hiliyo. ");
INSERT INTO bef_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Noseꞌnatiti efa gutiti to anaꞌina fato fatoꞌna melise faꞌmene biliyo. Letayanugu fatusa anasi lite bilaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","To letigigusaguꞌna bitetiti, to letugupisalo nakuꞌi moneko moneko biliyo. Loemo loemo bilaꞌinaꞌa meniꞌibe. Ya hite bilo, luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","To ka mone hiti ma luto lu epiꞌehina: Bite hepaꞌi moneto nehetite bo nohi tite kalaꞌina nopogu kelata hite minaliyo. Fato fato nopogu mekaliyo. Ya hite minetetiti alihi ana hepaꞌmo minalaꞌinaꞌa kana su henogo ana nonuguti heꞌmite biliyo. ");
INSERT INTO bef_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","To mone hepato nehetilaꞌinamo to enali letebe metigise to kagatiti mekehelise minenogomo letali ana hepatogati heꞌmiluꞌibeꞌmu nehitemo letigigusaloti meꞌani kele li heꞌmiliyo. Ya hinogo enali bu gete: Huꞌmau ka lemekiꞌehina yabe lite kehelilabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ya ligo, enali loemo loemo hite bifa hiꞌahabe. Asaga hepatoga bite: Komopatini i gelehe hite foipanatini li heꞌmilo, lite kaga lu epiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","To foipa fele bonaꞌmagihi komopaꞌaniguti leꞌme heꞌmite, to epesiꞌehina bonaꞌmagihi enugufalo ueli nagamiꞌi folo epelete eneleꞌmo bati hiꞌahana yabe. Enali ya hite babu bonaꞌi eneleꞌmo bati hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","To yalo asaga bonaꞌmagi Yesu kumu kaga liba liba hago, gihiti bo mone, giꞌa Heloti, ai yaꞌma kaga keheliꞌehibe. To bonaꞌmagi moneꞌa Yesu kumu: Ai Yoniu nagami folose bouba filiꞌehinaguti aho notibe. Yaꞌma Yesu ai ana bo nohuto, amuya hiti nohutoꞌa yaꞌma yege fiseꞌna legi huto nominanagihe, lite liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","To moneꞌamagi: Ai koyapa bo Elaiyau akuꞌi huto nohibe, lite liꞌahabe. To moneꞌamagi: Ai Huꞌmamofihi kaꞌa lu huto huto bo nohibe, lite, yaꞌma koyapa emasana ka lu huto huto bo minoꞌehina legi nohibe lite liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","To mone gihiti bo, Helotiu yaꞌma kagaꞌani lilata nehanaga keheliloto ma luꞌehina: Ahi. Ai Yoni nagami folose bo nohibe. Yonihi nani latahaꞌa laga hu heꞌmi etoꞌohuna bouba filiꞌehinaguti aho tiꞌehinagihe. Helotiu ya luto keheliꞌehibe. To henaꞌmube? ");
INSERT INTO bef_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Koyapaꞌi Helotiu moneꞌamagihi enoho lifigo bite Yonihi lite nagaꞌi emite leꞌmete bite kalabusi nonugu heꞌmi eteꞌahana yabe. To henabe lutobe? Ai Helotiu, goꞌafihi Filipihi lihaꞌa, giꞌa Helotiasi, yaꞌma aꞌi gumina foloꞌehigo, Yoniu: Yaꞌma kogokafihi lihaꞌa liꞌahata ya bebe mesoꞌehina yabe, luto lu emigo Helotiu Yonihi kalabusi emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","To ana aꞌuba, Helotiasiu ai Yoni kumu ipaꞌagu sibina higo halubeꞌmu nohuto minoꞌehina yabe. Ai ya huto minago, to Helotiu ai Yoni kumu koli nohuto kaba hu etoꞌehibe. Yoni ai hetofa bo nohuto to hapaꞌa bati huꞌehigo, Helotiu ai koli nohuto kaba hu etoꞌehina yabe. To Yoniu hetofa kaga lu emigo, Helotiu komopaꞌagu keheli keheli nohuto minoto kaꞌa kehelilataꞌa lagaꞌa besiꞌehina. Ai Yonihi kaꞌa kehelito ekesa keheli keheli huto minotoꞌa henaꞌni hilube luto kehelito minoꞌehina. Ya huto minoto ai Yonihi kaba hu etago Helotiasiu ho mefilise minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","To yalo mone yupahi Helotiasiu yaꞌma Yonihi nonaꞌa emilinamofihi geba huto ho fililina kapoꞌa bu goꞌehibe. Ana yupahi Helotiu sipi noseꞌna laita huto yege yege bonaꞌi kehe igo eꞌahabe. Yaꞌma koyapa Helotihi itoꞌafu aiꞌa ketoꞌehinamofi kumu beto hilanaꞌmu li gehesa hiꞌahana yupapo yabe. Kanisole bo hiti gimi bo hiti to Galili kapoguti sipi bomagi hiti eꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","To ete noseꞌna neꞌahana yupahi Helotiasihi paꞌauba Helotitoga buto enubulo melekehi igo, Helotigi ana melekepo lagaꞌani epesiꞌehina yabe. Helotiu ai sipi laga besigo ana paꞌmofi kumu ma luto lu emiꞌehina: Oho. Yaꞌma melekehi italo henana kimilube? Mone kebesilinana kimilunagi kai lu nimibo. ");
INSERT INTO bef_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","To kai kapokaga meꞌi mone lugaꞌa nimibo luto noloka holetogomo, nani oꞌe meluse kimilunagihe. Henanaka lilane? ");
INSERT INTO bef_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Helotiu yahi tito ana ka lu emiꞌehina yabe. To ya ligo ana palalaꞌuba aitogati heꞌmito buto itoꞌafu nohinalo buto: Henanaꞌmu loka halube luto ligo itoꞌafu ma luto lu emiꞌehina: Yaꞌma Yoni, nagami folose bomofihi latahaꞌa nimibo luto loka hobo. ");
INSERT INTO bef_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ya ligo palalaꞌuba anaꞌasi i behe huto buto Helotitoga hololu luto buto ma luto lu emiꞌehina: Kai yatai, maꞌasi, Yoniu nagami folose bomofihi latahaꞌa ho gitigito lapelugu li moloto ito oto nimibo. ");
INSERT INTO bef_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ya ligo Helotiu sipi ginaga fiꞌehibe. Akuꞌi ai yahi tito lu emiꞌehina kaꞌa asaga bonaꞌmagi kehelite aimo bu gete neminago, enali kumu lesaꞌa luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Lesaꞌa ligo gimi boꞌa mone ho lifiꞌehina yabe: Kai buto Yonihi hoto latahaꞌa ho gitigiloto ito obo, luto lu emigo ana bouba buto Yoni kalabusi nonugu nohinaga tito latahaꞌa ho gitigitoꞌa lapelugu li moloto ito oto palalaꞌi emilago ai ito buto itoꞌafihi emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","To Yonihi panaꞌalobomagi yaꞌma kehelilete bite gufaꞌa lite yafa bite keli heꞌahana yabe. Helotiu ai koyapa ya huto Yonihi ho filiꞌehina yabe. Ya huꞌehinaya ai alihi Yesu kumu kaga kehelilotoꞌa: Yaꞌma Yoniu filiꞌehinaguti aho notibe luto keheliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","To Yesuhi panaꞌalobomagi enoho lifiꞌehinagati aitoga akuꞌi eteꞌani enali hiꞌahana ka hiti to lu epiꞌahana ka hiti beto hite lu emiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","To ya ka lilago Yesu ma lu epiꞌehina: Lenali mana hepatogati heꞌmite ete nani hiti butoti bonaꞌi menehanaga bite lenabasu bite minalabe, luto luꞌehibe. Ana hepatoga bonaꞌmagi babu lite bila ela hite nehago enali panaꞌalobomagi mineꞌahanagihe. Ya hite minago Yesu: Bite lenabasu bite minalabe, luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","To enaligo bite suguna hilete bite botigu tite yu hepatoga biluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","To nebago yege yege bonaꞌmagi bu enegete kehelite nohi hepaꞌanigati heꞌmite hololu lite melugu kohe tete bite Yesugi panaꞌalobomagi bilana hepatoga enebege ligite yataꞌa nehetiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","To Yesu alihi anaga nehetito enali li gehesa nehanamo bu enogoto kekeꞌi lu epoloꞌehina yabe. Enali sipisipi yagamagi, kaba boꞌani meminana suhi lite nehago bu goto kekeꞌi lu epoloꞌehina yabe. Ya hutoꞌa kaga lu enelepiba enelepiba huto minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya huto minago sinihi gigo, panaꞌalobomagi aitoga neete me lite lu emiꞌahana: Yaꞌma hepato yu hepaꞌi niꞌigo to sinihi nogigo, to enali noseꞌnaꞌani melise eꞌahago kauꞌna enahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kai enoho lifitogo bite asaga bego bego huꞌehina hepatogati bite noseꞌna mina fite nalabe. ");
INSERT INTO bef_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ya lago Yesu: Lenali nehanaya, lenalitini noseꞌna epilo, luto lu epiꞌehina. Ya ligo enali ma lu emiꞌahana: Kai kekesa kehelito lali buto 200 kinalotiꞌi noseꞌna mina fito ito oto epilupiye? ");
INSERT INTO bef_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ya lite lago, Yesu: Lenalitoga beleti noseꞌna henaki niꞌibe? Bite bu gete kehelilo, luto lu epiꞌehina yago enali bite kehelilete ete ma lu emiꞌahana: Beleti noseꞌnaꞌa loe yagi loe yagi mone yagi niꞌito, to fayaꞌi loeꞌasi hiti niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ya lago yalo Yesu ma luto lu epiꞌehina: Ana lenali asaga bonaꞌmagihi eneleꞌmo nupa hinogo meto mineno. ");
INSERT INTO bef_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ya ligo, yege yege bonaꞌi kifina niꞌinalo minela minela hite meto mineꞌahabe. Mone 100 bonaꞌi li nupa hite minela hiꞌahabe. To moneꞌa 50 bonaꞌi li nupa hite minela hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ya hite meto mineꞌahago, Yesu ana beleti noseꞌna loe yagi loe yagi mone yagi to ana fayaꞌi loemo hiti litoꞌa, kokulumaga bu go saga nohuto Huꞌmamofitoga fokehi lu emito beleti noseꞌna li gofa huto panaꞌalobo noepigo enali lite bite gabu ite epiꞌahabe. To fayaꞌi ana huto li gofa huto epigo enali lite bite epiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","To enali yege yege bonaꞌi noseꞌna nenete enumu higo heꞌmilete mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","To ya hago, fakene huꞌehina noseꞌna, beleti letuhaꞌa hiti fayaꞌi hiti sulu suluꞌya 12 aguꞌi he gigite liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Enali ana noseꞌna neꞌahana bonaꞌi babu lite, bomagi 5000 neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","To yalo Yesu anaꞌasi panaꞌaloboꞌa amuya ka lu epito ma luꞌehina: Lenali nani kohe tete bite botigu tite nagami muya beletoga Betesaita hepatoga lofotula hilutagi bilo. ");
INSERT INTO bef_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","To enali nebago Yesu asaga boanaꞌi enebe tigito: Hepatiniga abilo ligo bi su heꞌahabe. To bi su helago, ai nunumu hilubeꞌmu buto bohupogu tito Huꞌmamofihi ka lu emito minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","To sinihi gilago, panaꞌaloboꞌamagi botigu nagamito folaganugu neminago, to aigo melugu minotoꞌa bu enogoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","To sipi abafahuba noligo enali osatu boti kefefe nehite lusi foya neligo Yesu bu enogoto, foluguꞌi kokole nogo nomalago buto nagami ifoꞌalo kapo moloto enalitoga buꞌehibe. Buto to enebege ligilubeꞌmu i pebisa nohago enali asagaꞌi bu gete koli gofa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ai nagami ifoꞌalo kapo nomalago bu gete: Felemo yabe, lite enegekesa kehelite enonogoꞌani ahi sipi lite koli habe. To ai anaꞌasi kaga luto: Nani yabe. Koli mehilo, luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","To ya luloto enalitoga botigu tito nohigo, anaꞌasi abafahi li lege noꞌehibe. To panaꞌaloboꞌamagi enegekesa keheli keheli hite otopa heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Enali koyapa Yesu beleti noseꞌna leꞌmo babu luꞌehigo enegekesa hokolo mehigo ai Huꞌmamofihi panaꞌa nohibe lite mekeheliꞌahabe. To yaꞌma kana ana huto mekehelise nehite enegekesa keheli keheli hite yege fiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","To, nagami muya beletoga bite Genesalete hepatoga nehetite boti nagami nekisaꞌalo nehetiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Yalo botiguti heꞌmite limite nehago asaga bonaꞌmagi anaꞌasi: Yesu yabe, lite okabaꞌa kehelite bite hololu lite bite asaga hepatoga bite epesiꞌehina bonaꞌi ukogu ke epelete yafa bite Yesuhi nohinalo eneleꞌmete biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","To Yesu fato fato hepatoga asagaꞌi lagaso hepatogafi sipi hepatogafi kifi hepatogafi nehetigo, enali epesiꞌehina bonaꞌi aitoga eneleꞌmete maketi hepaꞌi ke epalago Yesuhi buka tiba tiba hite mineꞌahana. Ai kataꞌa nekisaꞌasi bako hulenogo fa hu lepalalinagihe lite enegekesa kehelite ukimi ukimi hite loka heꞌahabe. To kataꞌa bako hiꞌahana bonaꞌmagi epesiꞌehinana fa hu epoloto enugufaꞌani ye koꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","To mone yupahi Felosi bonaꞌmagi to Yelusale hepatogati mono babafimagi hiti ete Yesuhi panaꞌaloboꞌamagi enayahi nagamilugu okala mehise noseꞌna nenago bu geꞌahabe. Yaꞌma bu gete enipagu sibina huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Enali Felosi bonaꞌmagi to Yuta bonaꞌmagi asagaꞌi, koyapa bonaꞌamagihi hapaꞌanilo megeꞌi melete enayahi nagamilugu okala hilete yalo noseꞌna nenana yabe. To enayahi nagamilugu melise nehiteꞌani noseꞌna mo nesibe. ");
INSERT INTO bef_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","To ana huto maketi hepatogati noseꞌna anaꞌina lileteꞌani yataꞌa enugufaꞌani nagami felelete alihi nenabe. To fato fato hapaꞌani koyapa bonaꞌanimagi hiꞌahana suhi yaꞌma silagaꞌi ana hite nehana yabe. Masuꞌani somoꞌani kopa lapeꞌani kohaꞌani asagaꞌi nagamitu ifepa afepa ite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Enali Felosi bonaꞌmagi to mono ka babafimagi hapaꞌani ya huto niꞌigo, Yesuhi panaꞌaloboꞌamagi ya hite enayahi okala mehise nenago, bu enegete Yesuhi ma lite loka heꞌahana: Akae. Kaika panaꞌaloboka henabe lite afotigihi hapaꞌani neheꞌmite, enayahi okala mehise nenabe? ");
INSERT INTO bef_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ya lago, ai ma lu epiꞌehina: Lenali soya kalo bonaꞌi nehabe. Aisaiyau koyapa Huꞌmamofihi kaꞌa lenali kumu maꞌnaka luto koyoꞌehina yabe. Ai ma luto koyoꞌehina: Yaꞌma bonaꞌmagi enabagaguti nofokehi nelinaya, akuꞌi komopaꞌaniguti agoya hi menenimibe. ");
INSERT INTO bef_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","To nani kumu yege filata nehanagi, akuꞌi bonaꞌmagihi kaꞌani monoꞌi yabe lite, soya ka lite li epilata nehanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaiyau lenali kumu maꞌnaka luto ya luto goꞌehina yabe. Lenali Huꞌmamofihi kaꞌa neheꞌmite bonaꞌmagihi kaꞌani kehelite megeꞌi melelata nehabe, Yesu ya luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","To ya luloto ka mone hiti ma lu epiꞌehina: Lenali ma suhi hite Huꞌmamofihi kagaꞌa neheꞌmibe. Ma suhi hite Huꞌmamofihi lenemegesa hi emite lenali hapatinimofihi liyafa nehana yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseu koyapa keya ka luꞌehina kaꞌa ma luto koyoꞌehina: Kai afokafinogo itokafinogo kaba hu etototo minobo. To, ana huto ka mone hiti ma koyoꞌehina: Yaꞌma afoꞌafinogo itoꞌafinogo gumiꞌi etahalina bomofihi aiꞌi ho fililanaꞌmu yabe. Moseu ya loe ka koyoꞌehinamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ya huto niꞌinaya to lenali akuꞌi ma lite nelabe: Bo moneꞌmofihi afoꞌafitoga itoꞌafitoga lu etimibe: Ke, mana efahaꞌni Huꞌmamofihi efahaꞌa yabe, luto moloꞌohube. Ya melutita letumutitaꞌmu yabe. Ana ka luto lulata bomomuꞌi lenali bati bo nohibe lite nekehelibe. ");
INSERT INTO bef_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lenali ana bouba afoꞌafugo itoꞌafugo bati huto heꞌmi etotoꞌehina yabe lite nelana soya ka nelabe. Lenali ya hite Huꞌmamofihi kaꞌa leꞌmo sibina nehabe. ");
INSERT INTO bef_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lenali hapatinimuꞌi kaga litetini Huꞌmamofihi kaꞌa neheꞌmite soya ka lu epilata nehana niꞌibe. To luna lana fato fatoꞌna ana suhi hite nehana yabe. Yesu ya luto ka epekiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","To Yesu yalo asaga bonaꞌmagihi aku kehe igo ago ma luto lu epiꞌehina: Ka lu lepilunagi asagaꞌi kehelilo. ");
INSERT INTO bef_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Anaꞌina asagaꞌi bomofihi komopaꞌagu limilinaꞌa mehaꞌa leꞌmo sibina mehilibe. Akuꞌi aiꞌa komopaꞌaguti tilinaꞌa yaꞌma mehaꞌa leꞌmo sibina hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Lenegekesatini nina bonaꞌi ka kehelilo. ");
INSERT INTO bef_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","To ya luloto yalo asaga bonaꞌi heꞌmi epoloto buto nonugu tito nominago aiꞌa panaꞌalobomagi ana fono kaꞌmu ma lite loka heꞌahabe: Suguna ka lu epiꞌahatana lu hokolo hu letobo. ");
INSERT INTO bef_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","To ai ma lu epiꞌehina: Lenali hiti ana hite lenegekesa meniꞌigo neminafiye? To mekeheliꞌahafiye? Mafi. Bomofihi komopaꞌagu limilinaꞌauba hiya huto mehaꞌa leꞌmo sibina hilibe? ");
INSERT INTO bef_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ai anana nolenogomo kupaꞌagu limito yalo ipaꞌagu limiloto bu su nohabe. Hiyaꞌa huto mehaꞌa leꞌmo sibina hilibe? Ya mehilibe. To Yesu ya ligo lali asaga noseꞌna bati huto nalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","To Yesu ka mone hiti ma luto luꞌehibe: Bomofihi komopaꞌaguti notinaꞌa yaꞌmanauba mehaꞌa leꞌmo sibina hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Bomofihi komopaꞌaguti ekesa noyiginana asagaꞌi notina yabe. Moko liseꞌna, bauna iseꞌna, bonaꞌi ho filiseꞌna, aꞌi gumina foloseꞌna, to komopaka hosopa ito anaꞌinaꞌmu naniꞌni babu luto lilube lulata yaꞌma, to foipana fato fatoꞌi huseꞌna yaꞌma yabe. To, bahane hoseꞌna, kolota kolota hapaꞌa huseꞌna, siko huseꞌna, megeka luseꞌna, kugufaka limo titi huseꞌna, to keheli sibina huseꞌna, ");
INSERT INTO bef_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","yaꞌmana asagaꞌi bomofihi komopaꞌagu ekesa kehelilata nohina yabe. Yaꞌmanauba komopaꞌaguti tito mehaꞌa leꞌmo sibina hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu ya luloto, ana hepatogati heꞌmito buto Taiya hepaꞌi to Saitoni hepaꞌi niꞌina kapogu butoꞌa, nonugu tito suguna huto minoꞌehibe. Ya huto suguna huto nonugu foloꞌehigo yalo bonaꞌmagi kehelilago, ");
INSERT INTO bef_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","to aꞌi mone paꞌamofihi komopaꞌagu foipa fele tiꞌehina paꞌi yaꞌma itoꞌafu Yesuhi kaga nelago kehelito aitoga buto gigusaꞌalo lipito minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ana aꞌmo Giliki ka nolina to Silia metogati Fonisia nagaꞌi nohina aꞌi yabe. Ai Yesutoga lipito minoto, amuya moloto ma luto loka hoba hoba huto minoꞌehina: Oho. Paꞌnimofihi komopaꞌagu foipa fele tito nohina kai leꞌmo heꞌmi etobo. ");
INSERT INTO bef_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ya ligo, Yesu fi taga hu etoto ma luto lu emiꞌehina: Mafi. Yagapanaꞌmagi noseꞌna yataꞌa nelenogo kalamagi alihi nenabe. Yagapanaꞌmagihi noseꞌnaꞌani be silito kalamagihi epilotoꞌni bati supo hilufihe? ");
INSERT INTO bef_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","To ya ligo ana aꞌuba ma luto luꞌehibe: Afoꞌnigabe, maꞌnaka nolataya akuꞌi kalamagi hita kapoluga minete noseꞌna letuhaꞌa limo iꞌehinaꞌa nelata nehana yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ya ligo, Yesu ma lu emiꞌehina: Ma aꞌise, kai komopakaguti keheli bati huto yaꞌma kaga lu huto hatalo pakamofihi komopaꞌaguti foipa fele leꞌmo heꞌmiꞌohube. Kipakagu bati hinogo hepakaga bubo. ");
INSERT INTO bef_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ya ligo ana aꞌuba hepaꞌaga buto nehetito paꞌa bati huto nebelusalo nokago bu goꞌehina. Foipa fele heꞌmi etoto bufa huꞌehigo yaꞌma paꞌi bati huto nohigo bu goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","To yalo, Yesu Taiya hepatogati heꞌmito buto Saitoni hepaꞌi folaganugu buto muya beletoga Tekapoli kapo bege ligito buto Galili nagamito nehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya higo bonaꞌmagi mone ekesa hekini loꞌehina to kaga lu bati mehina bo aitoga leꞌmete bite ma lite Yesuhi loka hete buka tiꞌahabe: Oho, ma bose. Kai kayapotu bako huletogo yaꞌma bomo bati hilinaꞌmu yabe. Enali ya lite loka heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ya lago, Yesu ana bomo enalitogati leꞌmoto buto yahaꞌa ekesa kapogu luga luga bito, to libiꞌna hoto ana bomofihi kenetufaꞌalo folo etoto, ");
INSERT INTO bef_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","yalo kokulumagu bu go saga hutoꞌa: Ke, luloto to aiꞌa kaꞌaguti Efata luto, lali kaguti: Hokolo hubo, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ya ligo anaꞌasi ana bomofihi ekesaꞌa hokolo higo to kenetufa nagaꞌi i hepulu tulago kaga lu bati huto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ya higo, Yesu asaga bonaꞌmagihi ma luto lipoti epiꞌehina: Lenali fato bonaꞌmagihi yaꞌma huꞌohunana lu meepilo. Ai ya luto lu laga huto lu epiꞌehibe. Yesu luto lu epiba epiba huto hulago, enali akuꞌi bite fato fato bonaꞌi lu epiba epiba hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","To asaga bonaꞌmagi lusi topa nehete enegelo bite ma liꞌahabe: Bogiyo. Yaꞌma Yesu ai asagaꞌna keheli bati nohina yabe. Ai ekesa hekini loꞌehina bomofihi leꞌmo bati higo, kaga nokehelibe. To kaga meluse minoꞌehina bomofihi leꞌmo bati higo, kaga lu bati huto nolibe. Enali ya lite yege fiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","To yalo ana kanagu, silaga bonaꞌmagi Yesutoga li gehesa babu lite nehago, to noseꞌnaꞌani meniꞌigo Yesu yaꞌma kehelito panaꞌalobo kehe igo ago ma lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ke. Nani yaꞌma boanaꞌmagihi kekeꞌi nolu epolobe. Enali nanitoga loe yagi mone yagi yegegu mineꞌahana to noseꞌnaꞌani meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","To nani eneleꞌmo heꞌminogo, kauꞌna enehenogo kapogu fililanaꞌmu yabe. To moneꞌamagi foto hepatogati eꞌahabe. Yaꞌmu nani kekeꞌi nolu epolobe. ");
INSERT INTO bef_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ya luto ligo panaꞌalobomagi ma lu emiꞌahana: Lali yaꞌma yu hepatoga nohutaya hiyaꞌa huto noseꞌna lito asaga bonaꞌi epilune? ");
INSERT INTO bef_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","To ya lago ai ma luto enoloka habe: Beleti noseꞌna lenalitoga henaki niꞌibe? To enali: 7 yabe, lu emiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ya lago, ai asaga boanatoga: Meto minalo luto ka lu noepitoꞌa, yalo ana beleti noseꞌna 7 liloto, Huꞌmamofitoga fokehi lilotoꞌa yahaꞌatu beleti li gofa huloto panaꞌalobomagihi epigo, enali lite bite yege yege bonaꞌmagihi gabu ite epigo neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","To ana huto lagaso fayaꞌi loeꞌasi niꞌigo, Yesu lito Huꞌmamofitoga fokehi lito panaꞌalobomagihi: Lite bite epilo, luto lu epigo enali lite bite epiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","To asagaꞌi nenete enumu higo heꞌmiꞌahago, Yesuhi panaꞌalobomagi noseꞌna fakene huꞌehina letuhaꞌa lite he gigite, sipi sepekeꞌna 7 bai toto liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","To ana noseꞌna neꞌahana bonaꞌi babu lite, 4000 boanaꞌmagi yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne su helago, Yesu eneleꞌmo heꞌmigo hepaꞌaniloga biꞌahana yabe. To bi su helago, Yesu panaꞌalobo hiti anaꞌasi boti moneꞌagu tilete Talamanuya kapogu bifa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Anaga bite neminago, Felosi bonaꞌmagi kehelileteꞌani ete Yesuhi hiti kenasabo biluneꞌmu ete to ai kumu miꞌi melete fi taga hi etaluneꞌmu nehite Yesuhi nohinalo nehetite loka heꞌahabe: Kokulumaguti sipi liliꞌna topa hoseꞌi fato fatoꞌi liletogo lali Huꞌmau keleꞌmo ho tiꞌehina bo nohapi menohapi bu galune. ");
INSERT INTO bef_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ya lite lago, Yesu komopaꞌagu, abo, luloto, yalo ma luto lu epiꞌehina: Lenali yatai bonaꞌi yale. Henabe lite nani fi taga hi netete, kokulumagati sipi liliꞌna topa hose fato fatoꞌi liletogo bu galune lite nelabe? Maꞌnaka lu nolepube. Nani lenali yatai bonaꞌmagita sipi liliꞌna topa hose fato fatoꞌi meli lepalalubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu ya luloto, enalitogati heꞌmito buto panaꞌaloboꞌamagi hiti botigu tite nagami muya beletoga akuꞌi biluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","To botigu biluneꞌmu nehite yaꞌma panaꞌalobomagi enegekesu hago noseꞌna asagaꞌi melise beleti noseꞌna monekoꞌisi anasi lite nebago, ");
INSERT INTO bef_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu fato kaga kehelito lipoti epito ma luꞌehina: Lenali kaba hu bati hite minalo. Yaꞌma Felosi bonaꞌmagihi hapaꞌani to Heloti nagaꞌi nehana bonaꞌmagihi hapaꞌani megeꞌi memelese minete kaba hilo. Enali hapaꞌani yaꞌma yisiti beleti kelo kelo tilinaꞌa legitana niꞌibe. Foipa hapaꞌani niꞌigo asaga bonaꞌmagihi hapaꞌani leꞌmo sibina hulatanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ya ligo, enali kehelite: Abo. Lali beleti noseꞌna lito meoꞌohutamolo ya linago lite ai lu emigo ai lu emigo hite nehago Yesu kehelito ma lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Lenali henabe lite beleti noseꞌna meniꞌibe lite kaga nelabe? Nani yamofi kumu menolube. Kaꞌnimofihi hapaꞌa menekehelifiye? Lenegekesa hokolo mehuꞌehina niꞌifiye? To lenubutini niꞌigo, bu megaluneꞌmu nehafiye? To lenegekesa niꞌigo, mekeheliluneꞌmu nehafiye? Nani ologosi huꞌohunanamofihi beto menehafiye? ");
INSERT INTO bef_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nani ologo beleti noseꞌna 5 li gofa hutoꞌni 5000 bonaꞌmagi epiꞌohuna yupahi letuhaꞌa henaki sulu suluꞌya liꞌahabe? Ya ligo, enali: 12 sulu suluꞌya yabe lite lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","To ai ma lu epiꞌehina: To maꞌasi, beleti noseꞌna 7 li gofa huto 4000 bonaꞌmagi epiꞌohuna yupahi letuhaꞌaya henaki sepekeꞌna liꞌahabe? Ya ligo, enali: 7 sepekeꞌna yabe lite lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ya lago, ai: Ana henabe lite menekehelibe? Nani beleti noseꞌnamoꞌmu nekesa keheli keheli hilunaꞌa meniꞌibe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","To yalo Yesu to panaꞌalobomagi hiti Betesaita hepatoga nehetite neminago, bonaꞌmagi bo mone bu pisi luꞌehina bomo Yesutoga leꞌmete bite: Oho. Kayapotu bako huletogobe lite buka tilago, ");
INSERT INTO bef_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ai bu pisi luꞌehina bomofihi yapo lito, leꞌmoto buto nohi hepatogati heꞌmito buto leꞌmo fegutoga moloto libiꞌna buꞌalo ho folo etoto to yatu buꞌalo bako hu etotoꞌa: Henana bu nogane luto loka hago, ");
INSERT INTO bef_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ai gili huto bu go saga huloto ma luꞌehibe: Nani yatai bonaꞌmagihi yafa legi hite kapo nemalago bu nogobe. ");
INSERT INTO bef_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ya ligo, Yesu mone hiti yatu buꞌalo bako higo, ai gili gili huto nohutoꞌa buꞌa i gili huto bu go bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","To Yesu: Yaꞌma nohi hepatoga metise nohutoka hepatoga faꞌmene bufa hubo, luto ho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","To yalo, Yesu panaꞌalobo hitiꞌi Sisalia Filipai kapogu niꞌina hepaꞌmo bego bego hiluneꞌmu nebago Yesu panaꞌalobo ma luto enoloka hoꞌehina: Asaga bonaꞌmagi nani kumu hena ka nelabe? ");
INSERT INTO bef_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ya ligo, enali ma liꞌahana: Moneꞌamagi Yoniu nagami folose bo yabe lite nelabe. To moneꞌamagi Elaiya yabe lite nelabe. To moneꞌamagi koyapa ka lu huto huto bo moneuba akuꞌi ho notibe lite nelabe. Kai kumu ya lite nelana yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ya lago, ai: To lenaliya? Lenali nani kumu kaga henana lite nekehelibe? Yaꞌma ya luto enoloka nohago, Pitau ma luto lu emibe: Kai Huꞌmau keleꞌmo ho tiꞌehina bo, Mesia nohane. ");
INSERT INTO bef_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ya ligo, Yesu amuya kaga lu epito ma lu epiꞌehina: Lenali ana kaga nani kumu bonaꞌmagihi lu meepilo. Ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","To yalo, kaga lu noepito ma luꞌehibe: Nani Kokulumaguti limiꞌohuna Bomofita alihi kalanaꞌi mele netete to bagaꞌa hitiꞌna nugupisalo tinogo kofilube. To enali olopa mono bonaꞌmagi hiti sipi monoꞌi kaba bomagi hiti to mono ka negana bonaꞌmagi hiti enemegesa hi nimilete nahalabe. To malipu yafalo noho fililenogoꞌni loeyagi moneyagi yegegu keligu minolotoꞌni yalo filiꞌohunaguti gololo tuto ho tito minalube. ");
INSERT INTO bef_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu yaꞌma huto hilina hapaꞌa lu hokolo hu epiꞌehina yabe. To ya lulago Pitau Yesuhi sugunaꞌi nesiꞌasi leꞌmoto buto bugu ka ma luto lu emiꞌehina: Yaꞌma ka lege nobo. Henabe luto koho fililabe? ");
INSERT INTO bef_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To ya noligo, Yesu i behe huto panaꞌalobo asagaꞌi bu enogoto ma luto Pitahi ka emekiꞌehina: Satao, nemegesalo minobo. Kai Huꞌmamofitoga keheli emito menominane. Kai melugu bonaꞌmagihi keheliseꞌnaꞌani lito nominane. ");
INSERT INTO bef_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yalo Yesu panaꞌalobo hiti asaga bonaꞌmagi hiti kehe igo ago ma lu epiꞌehina: Nemegeꞌi malalubeꞌmu nohina bouba ma huto minalibe. Ai hapaꞌamuꞌi: Nemetahana meniꞌibe luto heꞌmiloto malipu li kofilotoꞌa nemegeꞌi bati huto malalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","To bo moneuba mehaꞌa li pili koto minalina bomofi ai mehaꞌa fenene hilibe. To bo moneuba nani kumu luto to ka lamanaꞌa kumu luto mehaꞌa nimilina bomofi, ai mehaꞌa minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","To bouba hena minaꞌa heꞌmito mehaꞌa akuꞌi lilina niꞌibe? Mone meniꞌibe. Yogo feꞌnohi asagaꞌi yaꞌma melugu niꞌinana li baga ilenogo, to mehaꞌa fenene higo bati huto minalifihe? Oꞌe. Ya huto meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","To bo moneubafi yaꞌma ka mekehelise foipa nehana kanagu nani kumu to kaꞌnimu megesa hu nimilenogo, nani Kokulumaguti limiꞌohuna Bomofita, alihi ana huto nemegesa hu emito minalube. Nani alihi afoꞌnifu neleꞌmo bati hulenogo to fana mehaꞌni besa lago nohutoꞌni to hetofa agelomagi hiti aluna kanagu nani ana boꞌmu nemegesa hu emito minalube. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","To Yesu ka mone hiti ma lu epiꞌehina: Lusiga lu nolepube. Alihi Huꞌmau ai kapoꞌa amuya hiti leꞌmo huto hilina kanagu yaꞌma bonaꞌi yatai malo nehanaꞌa moneꞌamagi enali mefilise nehite bu galanaꞌmu yabe. Yesu ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","To yalo, loeyagi loeyagi loeyagi yege yupahi su holago, Yesu Pitanogo Yemesinogo Yonigihi eneleꞌmoto buto sipi kosagu titoꞌa, anaga enubuꞌanilo gufaꞌa gulu foto besa lago yege fiseꞌna huto minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","To kataꞌa ana huto besa lago lusi koholina lolo huꞌehibe. Melugu bonaꞌmagi kata okala henogo ya suhi huto koholina lolo menohibe. Lusi koholina gofa huto lolo huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","To Yesu ya huto yege fiseꞌna lolo nohigo, koyapa bomaleꞌi Elaiya hiti Mose hiti enubulo huto hiteꞌatiti Yesu hiti kaga lite nehago bu geꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","To Pitau Yesuhi ma lu emiꞌehina: Oho, babafio. Lali ma hepatoga bati huto nominone. Lali yege goli nohi loe yagi mone yagi gilune. Kaika mone Mosehi mone Elaiyahi mone ya huto gilenogo nokebesifiye? ");
INSERT INTO bef_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Enali panaꞌalobomagi enelesa gofa ligo, Pitau koli nohuto hena ka lilube, luto ekesa kehelito ana ka luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","To yalo enalitoga sopohi gilago soponuguti nogo moloto ma luꞌehina: Yaꞌma bo naniꞌni panaꞌni nohibe. Nigi moneko panaꞌni nibita huꞌehina panaꞌni nohinagi kaꞌa kehelilo. ");
INSERT INTO bef_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ya ligo, enali bu ge saga hiteꞌani fato bomaleꞌi felefa haꞌigo, Yesu aiꞌasigo nohigo bu geꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","To alihi kosaloti nelimigo, Yesu amuya ka lu epito ma luto ka epekiꞌehina: Lenali yatai bu geꞌahanana bonaꞌmagihi lu meepilo. Alihi nani, Kokulumaguti limiꞌohuna Bomofita filiꞌohunaguti ho notinogoꞌni bati hite ka lu epilabe. ");
INSERT INTO bef_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ya ligo, enali kehelite ka lu meepise mineteꞌani, suguna hite enegekesa yigiba yigiba hite mineꞌahabe. Ai filiꞌehinaguti ho tilube luto nolina kamofihi hapaꞌa henana niꞌibe lite enegekesa kehelite ai loka hago ai loka hago hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","To Yesuhi ma lite loka heꞌahabe: Enali mono ka negana bonaꞌmagi Elaiya yataꞌa olenogo yabe lite nelana ka henabe lite ya nelabe? ");
INSERT INTO bef_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya lago, ai kaꞌanilo nonaꞌa ma lu epiꞌehina: Maꞌnaka. Elaiya yataꞌa oloto asagaꞌna leꞌmo bati hilibe luto mono kagu akeyeꞌahana niꞌibe. To Kokulumaguti limilina Bomomuꞌi henana keyeꞌahana niꞌibe? Ai kumu ma lite liꞌahanamo niꞌina: Bonaꞌmagi enemegesa hi emite luna lana asagaꞌi hi etelenogo gabuꞌa sipina gilinaꞌmu yabe. Ai kumu ya luto mono fayanugu keyeꞌahanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","To nani ma luto lu lepilugi keheliꞌehilo. Elaiya ao su hoꞌehinagihe. To olago, enali sibi suhi asagaꞌna hi eteꞌahabe. Asagaꞌna enegekesa yigiꞌahanamofihi suhi yaꞌma hi eteꞌahana yabe. Mono kalugu ana hi etalabe luto koyapa koyoꞌehina niꞌibe. Ai kumu koyoꞌehina ka asagaꞌi ahuto huꞌehina yabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","To alihi enali limite bite asaga panaꞌalobomagi nehanaga nehetite, babu bonaꞌmagi enalitoga ete li gehesa nehago mono ka negana bonaꞌmagi enali hiti kenasabo nebigo bu geꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","To nehetigo, asaga bonaꞌmagi Yesuhi bu negeteꞌani yege fite aitoga hololu lite bite be tigiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","To Yesu panaꞌaloboꞌamagihi ma luto enoloka hoꞌehina: Lenali enali hiti hena ka lite mineꞌahabe? ");
INSERT INTO bef_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To bo moneuba, li gehesa nehanaguti, ma luto lu emiꞌehina: Oho, Babafio. Nani panaꞌnimo foipa fele komopaꞌagu nohigo, ka meluse nominabe. ");
INSERT INTO bef_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","To fato fato yupapogu feleuba ekesalo i hekini lolago, ai kana fu tito libiꞌna goya goya nohuto to baga yogoꞌa heni sala nokoto to gufaꞌa kesepu kesepu ilata nohibe. To nani ana panaꞌni kaitoga leꞌmoto bilubeꞌmu nohutoꞌni yaꞌma panaꞌaloboka, lenali leꞌmo heꞌmi etalo luto enoloka honamo enali leꞌmo bati mehi etese mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ya ligo, ai ma luto lu epiꞌehina: Abo. Lenali yatai bonaꞌi nanitoga lenemehi mebina bonaꞌi nehabe. Nani lenalitoga henaki yupahi minelenogomo nanitoga lenemehuba bilibe? To henaki yupahi lenegeba hulenogo ka kehelilabe? Ana panaꞌmo nanitoga leꞌmete alo. ");
INSERT INTO bef_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ya ligo, enali ana panaꞌmo aitoga leꞌmete ago, ana feleuba Yesuhi bu nogotoꞌa panaꞌi kalake nohago melugu kanafu tito nokoto kese kese noito, libiꞌna goya goya huto koꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","To Yesu ana panaꞌmofihi afoꞌafihi ma luto loka hoꞌehina: Panaka henaki kanagu ya huto minoꞌehibe? To afoꞌafu: Koyapasana, lagasoꞌasi nohinati ya suhi luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya huto minoba minoba nohigo ana feleuba panaꞌnimofihi halubeꞌmu fato fato yupahi logogu leꞌmo laki huꞌehina yabe. To fato fato yupahi nagami hefunugu leꞌmo nofu tuꞌehina. To kaiya leꞌeheꞌmalatamo keheli bati nohapiye? To kai keheli bati hulotoka kekeꞌi nolu leꞌetotoka leꞌeheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ya ligo, Yesu ma lu emiꞌehina: Kai henabe luto keheli bati nohapiye luto noloka hane? Nanitoga keheli uleꞌale huto komopaꞌa nimilina bouba asagaꞌna bati huto li huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To panaꞌmofihi afoꞌafu anaꞌasi sipi nogo moloto ma luto lu emiꞌehina: Babafio. Kaitoga keheli uleꞌale nohube. Akuꞌi mone keheli sibina nohunagi, neheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ya ligo asaga bonaꞌmagi hololu lite hetegete neago, Yesu bu enogoto foipa felemofihi ma luto ka emekiꞌehina: Kai foipa fele yale. Ekesaꞌa bagaꞌa i hekini loꞌahata fele yale. Ma panaꞌmofihi komopaꞌaguti heꞌmi etoto bufa hulotoka akuꞌi aitoga meobo. Heꞌmi etoto buboꞌma. ");
INSERT INTO bef_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ya ligo ana feleuba sipi nogo moloto panaꞌi kalake gofana huto ho etoto heꞌmi etoto bufa hulago, ana panaꞌi filiꞌehina legi huto minabe. To asaga bonaꞌmagi bu gete: Afilifa huꞌehibe lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","To Yesu buto yato lito leꞌmo saga higo, ana panaꞌi ho tito batiꞌna minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","To alihi Yesu nonugu tilago panaꞌaloboꞌamagi suguna hite ma lite loka heꞌahana: Lali ana felemofihi heꞌmi etaluta henabe luto bati mehuꞌohune? ");
INSERT INTO bef_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","To ai ma luto lu epiꞌehina: Yaꞌmana felemo amuya keneꞌi nohina yabe. Lenali faꞌmene leꞌmo heꞌmilana meniꞌibe. Huꞌmamofitoga yataꞌa nunumu hite loka helete alihi bati hite leꞌmo heꞌmilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","To enali ana hepatogati heꞌmite bite Galili kapogu kapo melete biꞌahabe. To Yesu: Nani kumu bonaꞌmagi kehelilana lagaꞌni menebesibe luto ligo sugunaꞌi biꞌahabe. Ai panaꞌalobo kaga lu epito nohigo sugunaꞌi biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","To ai ma luto kaga lu epiꞌehina: Bonaꞌmagi alihi nani Kokulumaguti limiꞌohuna Bomofita neleꞌmete bite nahalabe. To nehe fililenogoꞌni loeyagi moneyagi yegegu keligu minolotoꞌni akuꞌi ho tilube. ");
INSERT INTO bef_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ya ligo, enali yaꞌma kaꞌa enelepiseꞌnamofihi mekehelise nehanati to akuꞌi enelesaꞌani ligo hapaꞌa loka mehese mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bite bite Kapaneami hepatoga nehetigo Yesu nonugu tito nominotoꞌa panaꞌalobo ma luto enoloka habe: Lali kapogu noototi lenali henabe kaga lite kenasabo bite mineꞌahabe? ");
INSERT INTO bef_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","To enali kaga melise mineꞌahana. Henaꞌmube? Enali kapogu neete yaꞌma folagahaꞌanigu kiyiꞌafu sipi bo minalibe lite kenasabo bite mineꞌahana yabe. To yaꞌmu enelesaꞌani ligo, ka melise mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ya hago Yesu komopaꞌatu keheliloto meto minotoꞌa panaꞌaloboꞌa 12 magi kehe igo ago ma lu epiꞌehina: Kibina bouba faꞌmenenaꞌmu kibina bo lolo nohifihe? Oꞌe. Ai yataꞌa faꞌmene bo nohuto asaga bonaꞌmagihi koko hu epoloto alihi kibina bo lolo nohibe. ");
INSERT INTO bef_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ya luloto, lagaso yagapanaꞌi mone leꞌmo saga huto enali folagahaꞌanigu leꞌmo ho tito nu kiloto nohuto ma lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Bo moneuba nani kumu luto yaꞌma yagapanaꞌmagihi moneꞌa be tigito leꞌmoto gulu hilina bouba ai ana huto nebe notigibe. To nani nebe tigilina bouba ai ana huto noho lifiꞌehina bo Huꞌmau ana huto be notigibe. Yesu ya luto lu epiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","To Yoniu ma lu emiꞌehina: Babafio. Laliya, bo moneuba kigika hoto foipa fele eneleꞌmo noheꞌmigo bu gototi: Ya mehubo luto lu laga hu etoꞌohuta yabe. Ai lali lemegeꞌi menomalana bo nohinagihe. ");
INSERT INTO bef_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ya ligo, Yesu ma luto lu emiꞌehina: Oꞌe, ya luto lu laga mehu etobo. Boubafi nigiꞌni hoto hetofa suhi topa hose suhi hulata bouba ai akuꞌi meleꞌisi nemegeka melilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lalitoga megesa hu melimilina bouba lalitoga nominana bo nohibe. ");
INSERT INTO bef_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lusiga lu nolepugi keheliꞌehilo. Bo moneubafi moneuba lenali Kilisitohi nagaꞌi nehana kumu luto nagamiꞌi mone nesiꞌasi lepinogo, Huꞌmau alihi nonaꞌa hetofanaꞌa emilibe. Nani bonaꞌni nagami epiꞌahatalo yabe luto minaꞌa emilibe. Yesu ya luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","To ka mone hiti ma luto lu epiꞌehina: Akuꞌi bo moneubafi moneuba yaꞌma lagaso yagapana mone leꞌmo foipa hulenogomo, Huꞌmau ana bomofihi gofana huto ka emekiloto osahi emilinaꞌmu yabe. Ana bomofihi lubahaꞌalo efa kosa sipina nagatu mu tifilete to sipi hefupogu leꞌmo heꞌmi eteꞌahatita bati hititaꞌmu yabe. Huꞌmau lusina huto halina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","To ya huto niꞌigo, kayapotu foipana huse bo nohapi, ana kayapo laga hu heꞌmibo. Kayahi luga luga hiti niꞌigo logo loba loba huto mesobose hepatoga bilata bati mehuꞌehibe. To kayahi mone kegiꞌa meniꞌinogo Huꞌmamofihi kapogu tito minoba minoba hilata ya bati huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","To ana huto kigitu foipana huse bo nohapi, ana kigigusaka laga hu heꞌmibo. Kigi luga luga hiti nohuto logo loba loba huto mesobose hepatoga bilata bati mehuꞌehibe. To kigigusa mone kegiꞌa meniꞌinogo Huꞌmamofihi kapogu tito minoba minoba hilata, ya bati huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","To kubuloti foipana huse bo nohapi, ana kubu li buyu hu heꞌmibo. Kubuka luga luga hiti nohuto logo mesobose hepatoga bilata bati mehuꞌehibe. To kubuka mone kegiꞌa meniꞌinogo Huꞌmamofihi kapogu tito minoba minoba hilata, ya bati huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yaꞌma logo hepatogaya logoꞌa mesobose loba loba huto nolago anaga bilana bonaꞌmagihi enugufaꞌani pata siba siba nohigo sigifaꞌmagi enugufa neba neba hite nelabe. ");
INSERT INTO bef_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","To anaga bilana bonaꞌmagihi enugufaꞌanilo, lali noseꞌnagu hege kusu kusu tito nohuta suhi huto, anaga enugufalo logomo kusu kusu tito lalibe. Yesu ya luto lipoti epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","To ka mone hiti ma luto lu epiꞌehina: Hegemoya hetofa noseꞌna niꞌibe. Akuꞌi ekesaꞌa meniꞌigo, bati menohibe. Ekesaꞌa meniꞌinogomo lali hiyaꞌa huto leꞌmo bati hilune? Leꞌmo bati hilutaꞌa meniꞌibe. To lenaliya hetofa hege legi hite minete sibina mehise bati hite minalo. Lenali koguna ite minalo. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yalo Yesu to panaꞌalobomagi anagati heꞌmite bite Yutia kapogu biteꞌani to Yotani nagami muya beletoga niꞌina kapogu biꞌahabe. To anagu babu bonaꞌmagi Yesutoga ete li gehesa nehago ai mone yupahi hiti kaga lu epilata huto minoꞌehibe. Ai hapaꞌa ya huto niꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To Felosi bonaꞌmagi aiꞌi fi taga hi etaluneꞌmu nehite ete ma lite loka heꞌahana: Ma bose. Bo moneuba lihaꞌa leꞌmo heꞌmilinaꞌa yaꞌma bati huꞌehifi bati mehuꞌehibe. Kai lu limibo. ");
INSERT INTO bef_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ya lite lago ai ma luto lu epibe: Moseu hena ka luto koyoꞌehina nekehelifiye? ");
INSERT INTO bef_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","To enali ma lite lu emiꞌahana: Moseu ma luto luꞌehina: Bo moneuba lihaꞌa leꞌmo heꞌmilubeꞌmu nohuto ai yataꞌa fayahi mone goto emiloto yalo leꞌmo heꞌmilinaꞌmu yabe. Moseu ya luto koyoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","To ya lago, Yesu ma luto lu epiꞌehina: Moseu lenali komopatini efahi fiꞌehina bo nehago keheliꞌohutoꞌa ana ka luto koyoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","To koyapa Huꞌmau asagaꞌna hapi fito li huto huꞌehina kanagu ai ma luꞌehina: Bo hiti aꞌi hiti li huto huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","To yalo ai ma luto luꞌehina: Bouba itoꞌafinogo afoꞌafinogo heꞌmi etototo lihaꞌa nohinalo buto minalibe. ");
INSERT INTO bef_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","To anaga bigo, etali li nupa hite minete kogunale lolo hite minalaꞌibe. Huꞌmau ya luto lu moloꞌehigo, yaꞌmu etali alobole loe bonate meminese moneko bonaꞌi minalaꞌina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","To ya higo, Huꞌmau leꞌmo nupa huꞌehina alobole, lenali bonaꞌmagi loko mehi etatalo. Yesu kaꞌanilo ya luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","To alihi nonugu tite neminete, panaꞌalobomagi ana kagaꞌmu loka heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","To ai ma luto lu epiꞌehina: Bouba lihaꞌa leꞌmo heꞌmiloto to fato aꞌi lilina bouba, ai gumina nofalabe. ");
INSERT INTO bef_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","To ana huto, aꞌuba bahaꞌa heꞌmeto fato bolo bilina aꞌuba, ai ana huto gumina nofalabe. Yaꞌma suhi sigimi hilata nehana yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","To yalo, bonaꞌmagi yagapanaꞌani aitoga eneleꞌmete ete Yesu bako hu epoloto enunu kito lusa gi epalalibe lite eneleꞌmete neago, panaꞌaloboꞌamagi ka epekite lu laga hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","To ya hago, Yesu bu enogoto keheliloto panaꞌaloboꞌa sipi ka epekito ma lu epiꞌehina: Oꞌe. Ya mehilo. Lagaso yagapanaꞌmagi nanitoga bati hite alanaꞌmu yabe. Lu laga mehilo. Yagapanaꞌi suhi hite nemina bonaꞌmagi Huꞌmamofihi kapogu tilanaꞌmu yabe. Lusiga lu nolepube. ");
INSERT INTO bef_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bo moneubafi moneuba lagaso yagapanaꞌmofihi suhi huto Huꞌmamofitoga agoya hu emilina bouba, ai Huꞌmamofihi kapogu tilinaꞌmu yabe. To bo moneubafi moneuba lagaso yagapanaꞌmofihi suhi huto Huꞌmamofitoga agoya hu meemilina bouba, ai Huꞌmamofihi kapogu metilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu ya luloto, yagapanaꞌmagi enunu kito yapo enugufalo li moloto bebe sana ka lu epito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","To alihi Yesu kapo malalubeꞌmu nohigo, bo moneuba hololu luto oto aitoga lahupa nohi fito ma luto loka hoꞌehina: Oho afoꞌnigabe. Bati bo nohane. Nani henaꞌni hulenogoꞌni nemehuba minoba minoba hilibe? Lu nimibo. ");
INSERT INTO bef_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ya ligo, Yesu ma luto lu emiꞌehina: Kai nani kumu henabe luto bati bo nohane luto nolane? Asaga bonaꞌmagi bati bo menehana yabe. Huꞌmau aiꞌasigo bati bo nohina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","To Moseu keya ka luꞌehina kaꞌa asagaꞌi kai keheliꞌahata niꞌibe. Mone: Kai bonaꞌi ho mefilibo, nolibe. To mone: Aꞌi gumina mefolobo, nolibe. To mone: Gumina melibo, nolibe. To mone: Ka foya nelinogo kai faga faga melubo. To mone: Soya ka luto feꞌnohi melibo. To mone: Itokafinogo afokafinogo kagaꞌatiti keheli etimibo. Yaꞌma keya ka kai akeheliꞌahata niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","To ya ligo, ana bouba ma luto lu emiꞌehina: Oho, afoꞌnigabe. Yaꞌma keya ka asagaꞌi lagasoꞌasi minona kanaguti kehelito megeꞌi mololata nohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ya ligo, Yesu aiꞌi bu goto minoto ginaga nofigo ma luto lu emiꞌehina: Kaika hapaka monekoꞌisi mehuꞌahatana niꞌibe. Kai buto feꞌnohakalotiꞌi minaꞌa lilotoka ito buto enumuhi menina bonaꞌmagihi epiletogomo Huꞌmau kokulumaga kemetahanaka yege yegeꞌna molo ketalinaꞌmu yabe. To yaꞌma hulotoka oto nemegeꞌi molobo. ");
INSERT INTO bef_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ya ligo, ana bouba keheliloto li pisigito minoꞌehibe. Henaꞌmube? Aiꞌa feꞌnohaꞌa babu luto niꞌigo kehelito komopaꞌa keta higo li pisigiloto nohinagati bufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ya higo, Yesu bu goto bonaꞌi bu go beloloto panaꞌalobomagihi ma luto lu epiꞌehina: Ke. Yogo feꞌnoho bonaꞌmagi Huꞌmamofihi kapogu tilana keta gofa nohibe. ");
INSERT INTO bef_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ya ligo, panaꞌalobomagi kaꞌamuꞌi topa hete: Abo. Keta hina ka nolibe lite ai lu eminogo ai lu eminogo hite nehago Yesu ka mone hiti ma luto lu epiꞌehina: Panaꞌaloboꞌnise. Enali yogo feꞌnohi enemetahanaꞌani niꞌina bonaꞌmagi Huꞌmamofihi kapogu tilana keta gofa nohibe. ");
INSERT INTO bef_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameli yagauba neka hokolo kapoꞌagu kikipa hoꞌehinaꞌa faꞌmene bati huto bilifiye? Oꞌe. Amuya moloto fito foloto bilinaꞌmu yabe. To ana huto feꞌnohaꞌa silagaꞌi niꞌina bouba Huꞌmamofihi kapogu tilina keta gofa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ya ligo enali lusina hite topa hete ma lite lu emiꞌahana: Yahi, hiya bonaꞌmagi Huꞌmamofihi kapogu tilabe? Kiyiꞌafu bati hinogo Huꞌmau buto bilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ya lago Yesu enali enamapahi fito ma luto lu epiꞌehina: Bonaꞌmagi lolo mehilanaꞌa huto niꞌibe. To Huꞌmau ai bati nohuto eneheꞌmalinaꞌa huto niꞌibe. Ma melugu bonaꞌmagi lolo hilanaꞌa keta hilina asagaꞌnamofihi enali lolo mehilanaꞌmu yabe. Huꞌmau ai amuyaꞌa hiti bouba ketaꞌa hitiꞌnamofihi lolo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ya ligo Pitau: Laliya nasana asagaꞌnati heꞌmitoti kemegeꞌi moloto oꞌohuta yabe, luto noligo Yesu ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Oꞌyo, to lusiga lu nolepunagi kehelilo. Bo moneubafi moneuba nani kumu luto to ka lamanaꞌamofi kumu luto nasanaꞌa heꞌmilina bouba faꞌmene minalifihe? Oꞌe. Nani kumu to kaꞌnimu luto hepaꞌagati to meꞌagati heꞌmito, to gonamu tamuꞌamagi etaliꞌagi afoꞌagi itoꞌagi heꞌmi epalalina bouba ai yatai ma melugu nohutoꞌa, to bonaꞌmagi kalanaꞌi nehi etago nohutoꞌa ai asagaꞌna lilibe. Hepaꞌa hiti, meꞌa hiti, gonamu tamuꞌa hiti etaliꞌagi hiti itoꞌagi hiti yagapanaꞌa hiti yege yegeꞌna lilibe. Yatai ma melugu nohuto lilinaꞌmu yabe. To alihi yupahi, kokulumagu mino kosaba huseꞌna liloto to minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","To yatai sipi bo nehanaꞌamagi moneꞌa akuꞌi alihi faꞌmene bo minalabe. To yatai faꞌmene bo nehanaꞌamagi moneꞌa enali alihi sipi bo minalabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","To alihi, enali Yelusale hepatoga biluneꞌmu nehite kapo meleteꞌani to Yesu kohe toto nobigo panaꞌaloboꞌamagi enuluhaya bigo kapo nebago to enali enemegeꞌi melete nebana boanaꞌmagi koli hite biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","To Yesu panaꞌaloboꞌa 12 magihi eneleꞌmoto butoꞌa, bonaꞌmagi alihi hi etalana ka hapi fito lu epito ma lu epiꞌehina: Bu galo. Lali Yelusale hepatoga notubune. To anaga sipi mono bomagi to mono ka negana bomagi hiti enali Kokulumaguti limiꞌehina Bomofihi ka foya li etelete fisa ilanaꞌmu yabe. Ya hilete leꞌmete bite fegutoga bonaꞌmagitoga heꞌmi etalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","To enali kiya hi etete to gufaꞌalo libiꞌna hetete osahi emite yalo ho fililabe. Filifa huloto loeyagi moneyagi yege yupahi keligu minoloto, yalo akuꞌi ho tilinaꞌmu yabe, luto Yesu aiꞌa kumu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","To Yesu ya ka noligo, Sepetihi panaꞌamaleꞌi Yemesigi Yonigi aitoga ete ma lite lu emiꞌahaꞌina: Afotiꞌagase. Leꞌali yatai koloka haluꞌinaꞌa kai oꞌe meluse leꞌemibo. ");
INSERT INTO bef_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","To ai: Henana hu letetalube? Henana noloka halaꞌibe, luto lu etimigo, ");
INSERT INTO bef_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","etali ma lu emiꞌahaꞌina: Alihi Huꞌmau sipi bo keleꞌmo ho tilenogo leꞌali sogakalo lamagakalo luga luga minaluꞌina bati hilifiye? ");
INSERT INTO bef_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ya nelaꞌigo Yesu ma lu etimiꞌehina: Letali noloka haꞌinamofihi mekeheliꞌahaꞌibe. Nani ekesaꞌa nagamiꞌi naluna legitana huto hu netalina niꞌigi letaliba ana konugutiba bati hite nalaꞌina niꞌifiye? To nani alihi nugupisalo keta hina nasana kofilunaꞌa letugupisalo tilenogo letaliba bati hite kofilaꞌina niꞌifiye? Ya ligo, etali: Leꞌali bati huto kofiluꞌibe lite liꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ya laꞌigo Yesu ma luto lu etimiꞌehina: Maꞌnaka. Letali yaꞌma nagami konuguti nalaꞌinaꞌmu yabe. To ana nani nugupisalo alihi tilinaꞌa letali ana hite kofilaꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","To yaꞌma lamagaꞌnigago sogaꞌnigago minalaꞌinamofihi yaꞌma nani foyaꞌni meniꞌibe. Afoꞌnifu, Huꞌmau ai leꞌmo bati hu etotoꞌehina bomaleꞌi luga lugaꞌni minalaꞌibe. Yesu ya lu etimiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","To fato panaꞌaloboꞌa 10 magi yaꞌma ka kehelite Yemesihi Yonihi sipi ka etemekiluneꞌmu nehago, ");
INSERT INTO bef_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu enali kehe igo ago ma luto lu epiꞌehina: Lenali fato bonaꞌmagihi hapaꞌani keheliꞌahana yabe. Enali kibina boꞌanimagi kaba boꞌanimagi hutu hata hite enugufa limo titi hite ka epekiba epekiba hite neminana yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","To lenali ana suhi hite meminalabe. Lenalitoga sipi botini lolo hilina bouba ai liliꞌna bonatini nohilibe. ");
INSERT INTO bef_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","To kibina botini lolo hilina bouba ai kele kele panatini nohilibe. Lenali hapatini ya huto minalibe. ");
INSERT INTO bef_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","To Kokulumaguti limiꞌehina Bo ai henabe luto melugu noabe? Ai asaga bonaꞌmagi kele keleꞌi hi eminogo kibina boꞌani minalube luto oꞌehifiye? Oꞌe. Ai kele keleꞌi hu epalalube luto to eneheꞌmalube luto oꞌehina yabe. To bonaꞌmagi aiꞌi he fililenogo gufaꞌalotiꞌi silaga bonaꞌi foipanaguti mina fito pa so epalalube luto oꞌehina yabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","To enali bite Yeliko hepatoga nehetite mineꞌahabe. To ana hepatogati, Yesu panaꞌaloboꞌamagi hiti babu bonaꞌmagi hiti heꞌmite bite nebago bu pisi luꞌehina bouba giꞌa Batimeusi, Timeusihi panaꞌa yagi, ana bouba me kapo beletogaꞌa minoto bonaꞌi ukimi ukimi huto minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ya huto minotoꞌa bonaꞌmagi: Yaꞌma Nasalete hepalo bo Yesu noabe lite nelago, ai keheliloto ma luto kehe iba iba huto minoꞌehina: Akae. Akae. Yesuo. Kai Tebitihi nagaꞌi yale. Kekeꞌi lu netobo. ");
INSERT INTO bef_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ya ligo, asaga bonaꞌmagi: Heꞌmibo. Legeꞌnobo, lite ka emekigo ai akuꞌi sipi nogo moloto amuya moloto ma luto kehe iba iba huꞌehina: Oho. Tebitihi nagaꞌi yale. Kekeꞌi lu netobo. ");
INSERT INTO bef_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ya luto luba luba higo, Yesu kehelilotoꞌa kapogu heꞌmito buto: Ana bo eno, luto lu epigo enali bu pisi luꞌehina bomofihi kehe ite ma liꞌahana: Ma bo yale. Kofokehi lubo. Kai kumu kehe noinagi ho tito aitoga bubo. ");
INSERT INTO bef_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ya lago, ana bouba gutalafaꞌa heꞌmiloto topa hoto hololu luto Yesutoga buto nehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ya higo, Yesu ma luto loka hoꞌehina: Nani henana hu ketalube? To bu pisi luꞌehina bouba ma luto lu emiꞌehina: Oho. Babafio. Nubuꞌni li bati hu netoletogo akuꞌi bu goto minalube. ");
INSERT INTO bef_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","To Yesu ma lu emiꞌehina: Kai nanitoga keheli uleꞌale nohataloꞌi keleꞌmo bati nohunagihe. Ya hugo hepakaga bati huto bubo. Ya ligo, anaꞌasi buꞌa bati higo bu goto Yesuhi megeꞌi moloto kapo moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","To enali Yelusale hepaꞌi lebato bite Oliba kosalo tite, hepaꞌi mone giꞌa Betani, bege ligite bite mone hepatoga giꞌa Betefasi, anaga nehetiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","To Yesu panaꞌaloboꞌa loemo ho lifilubeꞌmu nohuto ma luto lu etimiꞌehina: Letali miya niꞌina hepatoga bite tilete bihu kasihaꞌasilo toki yaga naga iꞌahana gulu hete nanitoga leꞌmete aliyo. Ana toki yaga kosaba yaga yagi, bonaꞌi megesalo metiꞌahana niꞌibe. Ana toki yagamo leꞌmete aliyo. ");
INSERT INTO bef_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","To bo moneubafi moneuba: Henabe lite neliꞌibe luto letoloka nehenogomo letali ma lite li epiliyo: Kibina bouba kehe noinagihe. To aku alihi leꞌoho lifinogo leꞌmoto aluꞌinaꞌmu yabe. Letali ya lite li epiliyo. To enali meleꞌisi kehelite ana toki yaga nanitoga ho lifilabe. ");
INSERT INTO bef_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu ya ligo, etali kehelilete bite ana hepalugu tite, to kugumalugu nohi kasito toki yaga mone naga iꞌahago, ");
INSERT INTO bef_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bu gete gulu hete leꞌmete nebaꞌigo anaga neminana bomagi bu gete: Henabe lite toki yaga gulu hete leꞌmete nebaꞌibe, lite lago, ");
INSERT INTO bef_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","etali Yesu lu etimiꞌehina ka nonaꞌa lu epiꞌigo enali kehelite: Ana, leꞌmete biliyo, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bite toki yaga Yesu nohinalo leꞌmete baꞌigo enali megesaꞌalo nakuꞌani lu malago Yesu analo tito minoto kapogu buꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","To babu bonaꞌi moneꞌamagi nakuꞌani kapogu li malago, to moneꞌamagi kifiguti yafa haya hetigite lite ete kapomolo tili tele hilete li melela melela hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","To kohe tete biꞌahana bonaꞌmagi to megeꞌi biꞌahana bonaꞌmagi hiti bite kanipo fite ma lite fokehi liꞌahana: Bogiyo. Fokehi lilo. Huꞌmamofitogati kibina boti noabe. Ai kumu fokehi lilo. Oho. Afotifi Tebitihi nagaꞌi noabe. Kibina bo ho tito minalina kana ahuto hibe. Ananaꞌmu fokehi lilo. Huꞌmamofi kumu fokehi gofa lilo. ");
INSERT INTO bef_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ya lite nelago, Yesu Yelusale hepatoga nehetito tito buto sipi mono nonugu tiꞌehibe. Tito ana nonugu niꞌinanamofihi asagaꞌi bu go beloloto to sinihi gigo, ai i behe huto anaguti heꞌmito buto panaꞌaloboꞌa 12 magi hiti bite Betani hepatoga nehetite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kelete etepo, Betani hepatogati heꞌmite nebago Yesu kauꞌna hago, ");
INSERT INTO bef_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","to sifehi yafa mone hayaꞌa hesiꞌehigo fotoꞌi bu goto: Legeya hoꞌehilibe, luto anaga buꞌehibe. Buto bu goto to legeyaꞌa halina yupahi meoꞌehigo yaꞌmu legeya mehoꞌehina hayaꞌa anasi niꞌigo bu goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bu goto ma luꞌehina: Abo. Ma yafa yale. Bonaꞌmagi alihi kanagu legeyaꞌaka ligite menalabe. To ya noligo panaꞌaloboꞌamagi kaꞌa keheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To bite alihi Yelusale hepatoga nehetigo, Yesu sipi mono nonugu tiloto bu goto ipaluga logo bigo ma huꞌehina. Mono nonugu bisinisi melete minaꞌa lilata hite neminana bonaꞌmagihi ana nonuguti eneleꞌmo tufago biꞌahabe. To efahi senisi hila bonaꞌmagihi hitaꞌani li gelehe hu heꞌmigo, efahaꞌani tili tele huꞌehibe. To namalotiꞌi minaꞌa lilata hite neminana bonaꞌmagihi nebelusaꞌani li gelehe hu heꞌmiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","To mono nonugu koko kapoꞌani nemalana bonaꞌmagi lu laga huto kapo hekini loꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","To asaga bonaꞌi ma luto kaga lu epiꞌehina: Huꞌmamofihi kagu henabe luto koyoꞌehina niꞌibe? Ma luto koyoꞌehina: Nani nohaꞌnigu asaga bonaꞌi noto noto bonaꞌi enali nunumu hite minalabe. Yaꞌmu nunumu nopo yabe lite gi halabe. Ya luto koyoꞌehina niꞌinagi, aku lenaliya ana nonugu efahi gumina nelina yabe. Ya nehago guminalo nohi alolo huꞌehina yabe, Yesu ya luto ka epekiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","To ya higo, olopa mono bomagi to mono ka negana enali ya huꞌehinaꞌmuꞌi kehelite yalo Yesuhi he fililana kapoꞌa sa sa hiꞌahabe. To silaga bonaꞌmagi Yesuhi kagaꞌamu fokehi lite nehago yamofihi enali ai kumu koli hite ho mefilise faꞌmene mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","To utehi noligo, Yesugi ana olopa hepatogati heꞌmite bite kifi hepaluga keꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","To etehi foluguꞌi neete sifehi yafa hayaꞌa hiti lufusaꞌa hiti asagaꞌi lo hosopa ito lo i pigiꞌehigo bu geꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","To Pitau bu goto Yesuhi kaꞌa beto huto ma luꞌehina: Oho. Afoꞌnigabe. Bu gobo. Sifehi yafamo kai gumiꞌi hoꞌahatogo alo i pigiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ya ligo Yesu ma luto lu epiꞌehina: Oꞌyo, Huꞌma amuya bo nohinamofitoga keheli uleꞌale hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lusiga lu nolepube. Lenali bo moneubafi moneuba mana kosamofihi ka emekito: Managati heꞌmito buto sipi nagamilugu folobo, luto noluto to komopaꞌagu ekesa loe lae mehuse maꞌnaka luto huto hilibe luto keheli uleꞌale hinogo, Huꞌmau kaꞌa kehelito anana hu etalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yaꞌmu nani kaga lu nolepunagi keheliꞌehilo. Kai Huꞌmamofitoga nunumu huto anaꞌina loka nohotoka, to komopakagu: Hu netalibe luto lamaꞌnaka keheli uleꞌale huto ya huletogo Huꞌmau ai lolo hu ketalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","To numuna hilubeꞌmu nohutoka to bo moneuba koyapa sibina mone hu ketoꞌehinaꞌa niꞌinogomo kai yaꞌma huꞌehinana komopakaguti li heꞌmiloto komopaka fulu hino. Ya nohutoka numuna hilane. Kai ya huletogo kokulumalo Afokafu Huꞌmau ana huto kaika foipanaka heꞌmi ketoto kaitoga komopaꞌa fulu hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","To kai bonaꞌmagihi foipana hi keteꞌahanana komopakaguti meheꞌmiletogo Huꞌmau kokulumalo Afokafu ana huto kaika foipanaka yaꞌma meheꞌmi ketalinaꞌmu yabe. To kaitoga komopaꞌa fulu mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","To Yelusale hepatoga mone yupahi hiti nehetiꞌahana. To Yesu sipi mono nopogu humofaꞌna nohigo sipi mono nohi kaba bomagi hiti to mono ka negana bomagi hiti, ");
INSERT INTO bef_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","enali aitoga ete ma lite loka heꞌahana: Kiyiꞌafu sipi bo nohane luto koho lifigo oto yaꞌma hulata nohane? Kiyiꞌafu lu kimiꞌehigo ya suhi lulata nohane? Lu limibo. ");
INSERT INTO bef_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ya lago ai ma luto lu epiꞌehina: Nani ana huto lenoloka halube. Lenali lenoloka halunaꞌa yataꞌa ka nonaꞌa lu nimilenogo nani alihi noho lifiꞌehina bomofihi giꞌa ho lepilube. ");
INSERT INTO bef_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mafi. Yonihi, kiyiꞌafu ho lifigo oto nagami folo epoloꞌehibe? Kokulumalo bouba ho lifigo oto nagami foloꞌehifi, melugu bonaꞌmagi ho lifigo oto ya huꞌehibe? Lenali ya noluna kagalo lu nimilo. ");
INSERT INTO bef_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ya luto ligo enali musi musi ka lite ai loka hago ai loka hago hite ma liꞌahana: Henabe kaga lu emilune? Lali: Kokulumalo bouba ho lifiꞌehibe, luto lu emilenogo ai: Ya ya, henabe lite agoya hi meemiꞌahabe? luto loloka halibe. ");
INSERT INTO bef_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","To lali: Melugu bonaꞌmagi ho lifiꞌahabe luto lilupiye? to asaga boanaꞌmagi Yoni kumu hetofa bo, lu huto huto bo yabe, lite nekeheligo yaꞌmu enali koli nehite Yesutoga bite ma lu emiꞌahana: Lali mekeheliꞌohune. ");
INSERT INTO bef_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ya lite kaꞌalo lu emigo ai: Nani ana huto noho lifiꞌehina bomofihi giꞌa ho melepilunaꞌmu yabe, luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","To yalo, Yesu kaga lu epilubeꞌmu nohuto fono ka ma luto lu epiꞌehina: Bo moneuba nagaꞌi foya kofoto to gegisa fi bego bego hutoꞌa, to kaba bo minalana noho gitoꞌa, to nagaꞌi legeyaꞌa li letite bai nagamiꞌi lolo hilana keli mone kifilotoꞌa, yalo kaba bomagi eneleꞌmo ho tilotoꞌa, fato kapogu buto minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","To alihi legeya hoto uyaꞌi lago, legeyaꞌa mone ligilube luto kele kele panaꞌa mone ho lifigo bigo, ");
INSERT INTO bef_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","enali luba sabo hite osahi emite kehe neigo, ai legeya meligise faꞌmene oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ya hi etago, foya afoꞌafu kele kele panaꞌa mone hiti ho lifigo bigo, enali ana hite osahi emite latahaꞌa i loko hite golahi hilete bati mehina suhi hi eteꞌahana yabe. To yalo kele kele panaꞌa mone hiti ho lifigo bigo aiꞌi he filiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","To yalo fato fato yupahi kele kele panaꞌa fato fatoꞌi enoho lifigo bago enali moneꞌa osahi epite to moneꞌa enehe filite ya hi epeleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","To yalo foya afoꞌafu ma luꞌehibe: Nani ketoꞌohuna panaꞌni ho lifilenogo buto ka lu epilenogo ka kehelilabe. Ya luto aiꞌa panaꞌa, gi moneko panaꞌa yagi aimo ho lifigo bigo, ");
INSERT INTO bef_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","enali foya kaba bomagi ana panaꞌi fotoꞌi bu gete ma liꞌahana: Oho. Foya molo lilina panaꞌa noabe. Lali ho fililototi foyaꞌa laliti lilune. ");
INSERT INTO bef_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ya liteꞌani ana panaꞌi leꞌmete bite he fililete, foyaguti leꞌmete bite heꞌmi eteꞌahana yaꞌma luꞌehina kiliheꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","To ya hago foya afoꞌafu keheliloto henana hu epalalibe? Ai keheliloto buto ana foya kaba bomagihi asagaꞌi enoho fililotoꞌa, foya fato bomagi epinogo kaba hilabe. Yesu ya lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","To ai ma luto ka mone hiti lu epiꞌehina: Lenali mono bukugu yaꞌma leka mesoꞌahafiye? Ma luto koyoꞌehina niꞌibe: Liliꞌnalo bomagi yaꞌma efapo bati mehina efahi yabe, lite heꞌmiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yatai ana efahuba hetofana huto huꞌehina. Sipi Bouba ai ya suhi li huto higo lali fokehi lito nominone. Lenali ana ka mekeheliꞌahafiye? ");
INSERT INTO bef_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu ya ligo, enali sipi mono bomagi kehelite: Laliꞌi ka lemekito ana fono ka luꞌehina yabe lite kehelite Yesuhi nagaꞌi emilubeꞌmu hiꞌahana akuꞌi asaga bonaꞌmagi kumu koli hite heꞌmite bifa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bite yalo Felosi bomagi lugaꞌa to Heloti nagaꞌi bomagi lugaꞌa hiti enoho lifigo, ");
INSERT INTO bef_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","bite Yesuhi miꞌi malaluneꞌmu nehite aitoga ete ma liꞌahana: Babafio. Kai lusiga lulata bo nohane. Kai Huꞌmamofihi kaꞌa maꞌnaka luto lu lepise bo nohane. Bona kumu koli mehuse bo nohuto Huꞌmamofihi kaꞌa lusiga luto lu epise bo nohatagihe. Mafi. Sipi kaba bo, giꞌa Sisa aimofihi takisi efahi emiluta bati huꞌehifi bati mehuꞌehibe? Ana efahi emilupi meemilune? Yaꞌma Lomu gamanimofihi keya ka megeꞌi malalupi, heꞌmilune? Kai lu limibo. ");
INSERT INTO bef_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ya nelago, Yesu enali aiꞌi fi taga hiluneꞌmu enipa nehago kehelitoꞌa ma luto lu epiꞌehina: Lenali henabe lite nimiꞌi nemalabe? Efahi legeyaꞌa mone ite ete nimitogo bu galube. ");
INSERT INTO bef_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To ya ligo, enali efahi mone ite ete emilago, ai li saga nohuto ma luto enoloka hoꞌehina: Mana efapolo kiyiꞌafihi mehaꞌa hiti fayahaꞌa hiti niꞌibe? ");
INSERT INTO bef_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ya ligo, enali: Sipi kaba bo Sisahi mehaꞌa yabe, lite lago ai ma lu epiꞌehina: Ya. Ana, Sisahi nasanaꞌa Sisahi emilo. To ana huto Huꞌmamofihi nasanaꞌa Huꞌmamofihi emilo. Ya ligo, enali hetofa ka nonaꞌa epiꞌehinamofi hiti to ai kumu topa hete ka melise faꞌmene mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","To yalo Satusi bomagi, enali bonaꞌi fili su helete alihi akuꞌi ho metilabe lite nelana bomagi, enali aitoga ete ma lite loka heꞌahana: ");
INSERT INTO bef_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Babafio. Moseu ma luto koyoꞌehina keheliꞌohune: Bo mone yagapanaꞌi meketose fililenogomo lihaꞌa gonaꞌauba lilibe. Gonaꞌauba lihaꞌa liloto yagapanaꞌi ketolenogo ya huto goꞌafihi bihaꞌa huto hilabe. Moseu ya luto koyoꞌehina keheliꞌohune. ");
INSERT INTO bef_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","To mafi. Koguna 7 mineꞌahabe. To yege bouba ai lihaꞌa lito to yagapanaꞌi meketose fililago, ai megesaꞌalo bouba ana aꞌi liꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","To ai ana huto yagapanaꞌi meketose fililago, aiꞌa gonaꞌauba liꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","To ya huto buto yaꞌma kohona silagaꞌi ana suhi huto ana aꞌi lite yagapanaꞌi meketese fililago, yalo alihi ana aꞌuba ana huto filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To ya higo, alihi filiꞌahanaguti ho tilana yupahi kiyiꞌafihi lihaꞌa lolo hilina niꞌibe? Yaꞌma kogunamagi asagaꞌi ana aꞌi liꞌahana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ya lago, Yesu kaꞌanilo ma luto lu epiꞌehina: Ya. Lenali ya hite keheli fetaga nehabe. Lenali Huꞌmamofihi kaꞌa hiti hapaꞌa hiti mekeheliꞌahabe. To Huꞌmau amuyaꞌa hiti bo nohigo, lenali menekehelibe. ");
INSERT INTO bef_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","To bonaꞌmagi alihi filiꞌahanaguti ho tilana kanagu anaꞌi kata mehilanaꞌmu yabe. To anaꞌi melilanaꞌmu yabe. Ana kanagu kokulumalo agelomagihi suhi hite minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","To filiꞌahanaguti ho tilana kagaꞌmu Moseu koyoꞌehina ka mone bu megeꞌahafiye? Moseu yaꞌma i kulu tito loꞌehina yafa bu goꞌehina yupahi, Huꞌmau hena ka lu emiꞌehina niꞌibe? Ai ma luto lu emiꞌehibe: Nani Abalahahi kibina boꞌa Isakahi kibina boꞌa Yakopuhi kibina boꞌa nohube, luto lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ana kaꞌamofihi hapaꞌa ma huto niꞌibe. Huꞌmau ai enubu hiti nehana bonaꞌmagihi kibina boꞌani nohina keheliꞌohune. To ya higo, enali koyapa bonaꞌmagi, Abalaha yagi, Isaka yagi Yakopu yagi enali fenene mehise nehabe enali mineme bite nehana yabe, luto nolina ka yaꞌma niꞌibe. To lenaliya yaꞌma keheli fetaga nehana yabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","To enali Yesuhi kaga yaꞌma loka nehago, to Yesu kaꞌanilo kaga bati huto lu noepigo, mono ka enelepise bo moneuba anaga minoto kehelito oto Yesuhi ma luto loka hoꞌehina: Keya ka asagaꞌi niꞌigo, to hiyaꞌa hofa toto be ligiꞌehina ka niꞌibe? Lu nimibo. ");
INSERT INTO bef_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ya ligo, Yesu ma luto lu emiꞌehina: Yataꞌa yaꞌma hofa toꞌehina ka ma niꞌibe. Isilaeli nagaꞌi kehelilo. Kibina bo Huꞌmau monekoꞌna nohuto aiꞌasigo kibina bo nohibe. ");
INSERT INTO bef_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","To kai kibina boka, Huꞌmamofihi kemehi emito, keheli emito minalane. Kipakatu kemehakatu komopakatu kugufakatu amuya moloto aimomuꞌi keheli emito minobo. Yataꞌa yaꞌma niꞌigo to analo yaꞌma ka mone ma niꞌibe: ");
INSERT INTO bef_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kai bonaka kumu kiginaga fito minobo. Kaika kugufaka kaba nohata suhi huto bonakamofihi kaba hu etobo. Yaꞌma keya ka loemoya, asaga kamofihi be ligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ya ligo, mono ka enelepise bouba ma luto lu emiꞌehina: Oho. Afoꞌnigabe. Maꞌnaka nolane. Huꞌmau monekoꞌna nohibe luto lusiga nolane. To aiꞌasigo kibina bo nohibe luto lusiga nolane. ");
INSERT INTO bef_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","To lali bonaꞌmofita ai kumu lipatitu lemehatitu komopatitu lugufatitu amuya moloto lebesito keheli emiluta bati ka nolane. To bonatiꞌmu liginaga fito lugufati kaba nohuto suhi huto kaba hu epalaluta bati ka nolane. To bona moneuba yaꞌma keya ka loemofitoga keheli emilata yauba silagaꞌnamofihi Huꞌmamofitoga noemutana to salamana go emutana silagaꞌi be ligiꞌehina yabe. Kai maꞌnaka nolane. ");
INSERT INTO bef_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","To yaꞌma bouba ya huto keheli bati huto kaga lu emigo, Yesu kehelise ma lu emiꞌehina: Kai Huꞌmamofihi kapoꞌalo lebatoꞌisi tilubeꞌmu nohane. To ya ligo, bonaꞌmagi enali enelesaꞌani noligo kaga loka mehese mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","To Yesu sipi mono nonugu minoto ka lu noepito ma luto enoloka hoꞌehina: Enali mono ka lu enelepise bonaꞌmagi henabe lite Kilisito bo Tebitihi panaꞌa nohibe lite nelabe? ");
INSERT INTO bef_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Koyapaꞌa Tebitiu Hetofa Sikalafuꞌuba lu emiꞌehina ka yaꞌma luto ma luꞌehina: Sipi Bo Huꞌmau nani Sipi Boꞌni ma lu emiꞌehina: Kai lamagaꞌnilo minotoka, to nani fatehakamagihi enoho su holenogo melugu minelenogo kai kigigusakatu enemegesaꞌanilo kifita ilane. ");
INSERT INTO bef_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ya luto luꞌehigo Tebitiu ana ka luloto Kilisito kumu: Nani kibina boꞌni yabe, luto yaꞌma gi hoꞌehina. Ya huꞌehigo enali henabe lite Kilisito Tebitihi yagapanaꞌa anasi nohibe, lite nelabe? Yesu ya ligo asaga boanaꞌmagi kaꞌamofihi keheliba keheliba hite ai kumu fokehi liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","To yalo Yesu kaga luto lipoti epiloto ma luꞌehina: Lenali mono ka lu enelepise bomagi kumu kaba hu bati hilo lu nolepube. Enali yatama kata lusi hetofa kata hepite maketi hepaluga hutu hata hite humofaꞌna hite nehago bonaꞌmagi enalitoga lipite enebe netigibe. ");
INSERT INTO bef_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","To enali mono nonugu titeꞌani olopa bomagihi hetofa nebelusalo tite neminabe. To sipi noseꞌna nalana yupahi ho tite yafege gelete mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","To enali keto aꞌmagihi feꞌnohaꞌani be nesilite gumina lilata nehana. To asaga bonaꞌmagi kehelite lofokehi lilabe lite yaꞌmu yatama yatama kaga lite nunumu hite mineꞌahana yamofihi hapaꞌani ya huto niꞌibe. Niꞌinaya alihi Huꞌmau ka foya lilina kanagu enaliꞌaniꞌmu fagalo bonaꞌi nehabe lilina, to osahi sipiꞌa mone hiti epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","To Yesu sipi mono nonugu minoto efahi neheꞌmina hepaꞌmo bu goto minago babu bonaꞌmagi ete efahaꞌani neheꞌmigo bu goꞌehina. Yaga foya bomagi efahaꞌani babu luto anagu heꞌmiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yalo keto aꞌi moneuba oto efahaꞌa loe toea anagu heꞌmigo Yesu bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ya bu goto panaꞌalobo kehe igo ago ma luto lu epiꞌehina: Lusiga lu nolepube. Yaꞌma keto aꞌuba heꞌmiꞌehina efahaꞌa yauba asaga bonaꞌi heꞌmiꞌahanaꞌamagihi enebe ligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Enali efahaꞌani silagaꞌi niꞌinaloti moneꞌa lite ete heꞌmiꞌahabe. To ai muhi menina aꞌi nohuto efahaꞌa asagaꞌi niꞌina to noseꞌna mina fito nalube luto moloꞌehina efahaꞌa yaꞌma aheꞌmi su hoꞌehinagihe. Yanaꞌmu aiꞌa hapaꞌa bati huꞌehinauba enebe ligiꞌehibe, luto Yesu ya luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","To Yesu sipi mono nonuguti heꞌmito nolimigo, kolo panaꞌa moneuba ma luto lu emiꞌehina: Oho. Babafio. Bu gobo. Yaꞌma nohi fela nopo yabe. Sipi efaha nohi niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","To Yesu ma luto lu emiꞌehina: Yaꞌma sipi mono nohi bu nogapiye? Bu go bati hubo. Alihi kanagu, ana efaha nohi asagaꞌi i tobo silenogo, ana efahi asagaꞌi limo ito moneꞌisi moneꞌisi melugu minalibe. ");
INSERT INTO bef_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","To alihi, panaꞌalobo hiti ana hepatogati heꞌmite bite mone kosalo, giꞌa Oliba, ana kosalo tilete to miya yaꞌma sipi mono nohi bu gete nehago Pitagi Yemesigi Yonigi Atulugi suguna hite ma lite loka heꞌahana: Yaꞌma sipi efaha nohi i tobo silina kana huto hilinaꞌa lali hiyaꞌa huto kehelilune? ");
INSERT INTO bef_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yaꞌma luna lana asagaꞌi hiya kanagu huto hilibe. Lu hokolo hu letobo. ");
INSERT INTO bef_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","To ya lago ai ma luto hapi fito lu epiꞌehina: Nani yatai lipoti lu nolepube. Lenali kaba hilo. Bonaꞌmagi bahane hete leneleꞌmo keheli fetaga hiluneꞌmu nehinogomo, keheli bati hilo. ");
INSERT INTO bef_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yaꞌma alihi kanagu fato fato bonaꞌmagi babu lite lenalitoga melugu huto hilete ete to faga lite nani nigiꞌni hete: Nani Mesia bo nohube, lenubuto bise linogofi, nani Mesia bo leneheꞌmose nohube linogo, ya hite faga lite lu epiteꞌani yalo babu bonaꞌmagihi eneleꞌmo keheli fetaga hilanaꞌmu yabe. Lenali yaꞌmu kaba hi bati hilo. Bo moneubafi moneuba lenimiꞌi molo lalibe, luto nolube. ");
INSERT INTO bef_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","To alihi kanagu hiti, noto noto hepatoga luba hilenogo to luba ka nelinogo lenali kehelite koli mehilo. Yaꞌma maꞌnaka luto huto hilinaꞌmu yabe. To yaꞌma kana huto nohinogo meꞌi su halina kana huto hilubeꞌmu menohibe. ");
INSERT INTO bef_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yataꞌa fato fato nagaꞌmagi fato fato nagaꞌi hiti luba hilabe. To mone gihiti bomofihi nagaꞌamagi ho tite mone fato kibinamofihi nagaꞌa hiti luba hilabe. To fato fato hepatoga imimaꞌi lilibe. To fato fato hepatoga noseꞌna fenene hinogo sipi kauꞌna enahalinaꞌmu yabe. To yaꞌmana asagaꞌi huto hulenogo, lenali ma lite kehelilabe. Luna lana keta hina nasana asagaꞌi gofana hilina kana yuhufasi hapi filubeꞌmu nohibe lite kehelilabe. ");
INSERT INTO bef_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","To yaꞌma huto nohinogo lenalitini kaba hi bati hilo. Boanaꞌmagi alihi lenaliꞌi kefefe hite bite mono nonugu leneleꞌmete bite ka foya lilete osahi lepilabe. Nani kumu lite leneleꞌmete bite gamani bona enubulo to enikibina bona enubulo leneleꞌmete bite ka foya li lepalalabe. To ya hinogo lenali nani kumu ka lamanaꞌa lu epilabe. ");
INSERT INTO bef_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yataꞌa kohe toto lenali naniꞌni hetofa ka lamanaꞌni asaga noto noto kapogu lu yege hete lu epinogo yalo alihi meꞌi asaga baga ito su halina kana huto hilibe. ");
INSERT INTO bef_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","To enali nagaꞌi lepite leneleꞌmete bite ka foya li lepalana yupahi lenali koli mehilo. To kaga lilana ka lenegekesa keheli keheli hite meminalo. Henaꞌmube? Huꞌmau, ana kanagu leneheꞌmenogo kaga lilabe. Ai lu lepilina ka yaꞌma lu epilo. Lenaligo kaga lilana meniꞌibe. Sikalafuꞌuba lenali hiti moneka nehite fatehatinimagihi kaga li epilabe. ");
INSERT INTO bef_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","To ana huto, yaꞌma kanagu gonamu tamuꞌa moneꞌamagi ai ho filinogo ai ho filinogo hite minalabe. To bonaꞌi moneꞌamagi yagapanaꞌani enehe fililabe. To panalaꞌi panaꞌmagi moneꞌa ana hite itoꞌanigi afoꞌanigi enehe fililabe. Ana kanagu ya hite minalabe. ");
INSERT INTO bef_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","To asaga bonaꞌmagi nani kumu lite enipagu sibina nohinogo sipi ka lepekilabe. Ya hi lepalanaya akuꞌi nanitoga koseleꞌi mehose uleꞌale huto minalina bomofi, kanaꞌa su holenogo, Huꞌmau leꞌmalinaꞌmu yabe. Yesu ya luto lu epiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","To Yesu mone ka hiti ma luto lu epiꞌehina: To alihi, sipi mono nonugu foipa suhi napauba hepaꞌi nohi li sibina gofana hulata nohinamofihi lenali bu galanaꞌmu yabe. To yaꞌma koyapa fayapo leka salata bomofita kehelibo. Yaꞌma mono nonugu foipa suhi li huto hilenogo, lenali bu gelete yalo lenali Yutia kapogu nemina bonaꞌi meꞌme hite kosaga tite minalo. ");
INSERT INTO bef_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","To nohupitalo nominata bomaka feꞌnohi lilube luto nohakagu metise kana su halinagi faꞌmene meleꞌisi bubo. ");
INSERT INTO bef_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","To ana huto foyagu kai gu kata lilube luto i behe huto hepatoga mebuse faꞌmene bubo. ");
INSERT INTO bef_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ke. Ana kanagu yagapanaꞌani hiti nehana aꞌmagi kumu kekeꞌi li epalalo. To yagapanaꞌi yuhufasi keteꞌahana aꞌmagi kumu leniginaga fi epilo. ");
INSERT INTO bef_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","To yaꞌma foipa nasana huto hilina kanamuꞌi lenali ma lite nunumu hilo. Yaꞌma kufuga kana huto hu lalibe lite Huꞌmamofihi loka halo. ");
INSERT INTO bef_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Henaꞌmube? Yaꞌma kanagu gumiꞌi gofana huto hofa toto tilinaꞌmu yabe. Koyapa kanagu gumiꞌi ya huto metiꞌehina niꞌibe. Huꞌmau meꞌi hiti to asagaꞌna li huto huꞌehina kanaguti buto buto yatai kanagu nehetito, yaꞌma ya huto gofana huto gumiꞌi hoseꞌna metiꞌehina niꞌibe. To ana huto fotoꞌi alihaꞌa hiti, ya huto gofana huto sipi gumiꞌi hoseꞌna metilinaꞌmu yabe. Yaꞌma moneko kanagu gumiꞌi gofana huto sipi huto tilina kana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ya higo, Sipi Bouba ana kana leꞌmo tupa mehutita asaga bonaꞌmagi filitine. To Huꞌmau aiꞌa eneleꞌmoꞌehina bonaꞌmagi kumu luto kana aleꞌmo nesi huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","To ana kanagu, bonaꞌi moneꞌamagi ma lite lilabe: Bu galo. Mesia bouba maga nehetito lubuto bilibe lite lilabe. To moneꞌamagi: Bu galo. Meyaga nehetito leheꞌmalibe lite lilabe. To yaꞌma ka li lepelenogo lenali kaꞌani mekehelilo. ");
INSERT INTO bef_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Akili ka lilabe. To ana kanagu faga faga kaga lu huto huto bomagi hiti to faga mono ka luse bomagi hiti ma lite lilabe: Nani Mesia bo yabe, lite faga lite lilabe. To enali fato fato suhi hite topa hese suhi hite hilete yaꞌma Huꞌmau eneleꞌmoꞌehina bonaꞌmagihi keheli sibina hu epalalune lite babeyafa hite enimiꞌi malalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ya hilanagi to lenali kaba hi bati hilo. Nani yaꞌma huto hilina nasanaꞌmu asagaꞌi lipoti alepiꞌohuna yabe. Yaꞌmu kaba hu bati hilo. ");
INSERT INTO bef_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","To Yesu mone ka hiti ma luto lu epiꞌehina: To yaꞌma gumiꞌi gofana huto tilina kana su holenogo yege fenene higo sinihi gilibe. To ikahi hiti besa besa meloto li sabalibe. ");
INSERT INTO bef_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","To kokulumaguti sonofiꞌi yege yegeꞌna limilibe. To kokulumagu nasana asagaꞌi li gusili gusili hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","To yalo, Kokulumaguti limiꞌehina Bouba amuya hiti nohuto to fana mehaꞌa sipi besa nolago, ai sopohi hite akuꞌi kokulumaguti nolimigo, bu galabe. ");
INSERT INTO bef_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","To ai agelomagihi enoho lifilenogo, bite aiꞌa bita huꞌehina bonaꞌi asagaꞌi noto noto hepaꞌi fato fatoꞌi anagati asaga melugu hepatogati meꞌi nekisalo niꞌina hepatogati silagaꞌi eneleꞌmete elenogo li gehesa hilabe. Yesu ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","To mone ka hiti ma lu epiꞌehina: Mafi. Sifehe yafa hapaꞌa lepilugi, kehelilo. Hapaꞌa ma huto niꞌibe. Ana yafamo yahaꞌalo mokoꞌa biloto to hayaꞌa yuhufasi nohesigo, lenali bu gete: Kotaga lilibe lite nekehelibe. ");
INSERT INTO bef_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To ana huto yaꞌma maꞌasi lu lepiꞌohunana huto hulenogo, lenali: Kokulumaguti Sipi Botiuba akuꞌi alina yupahi maꞌasi huto hilibe lite, maꞌasi leke ho malalubeꞌmu hibe, lite kehelilabe. Nani lusiga nolepunagihe. ");
INSERT INTO bef_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yaꞌma yatai nehana bonaꞌmagihi kanaꞌani su mehenogo, ana kana hapi filinaꞌmu yabe. Nani kaꞌni fenene huto mefilise yaꞌma huto hilina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kokuluma hiti meꞌi hiti alihi fenene huto su halinaꞌmu yabe. To nani kaꞌni lusiga yagi mefilise huto hilinaꞌmu yabe. Yesu ya luto lu epiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","To Yesu mone ka hiti ma luto lu epiꞌehina: Yaꞌma huto hilina kana asaga bonaꞌmagi menekehelibe. Kokulumaga agelomagi enali hiti menekehelibe. To nani Huꞌmamofihi panaꞌamofita menokehelube. Afoꞌnifu, Huꞌmau aiꞌasigoko keheliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","To ya huto niꞌinaya, lenali bu gete minalo. To lenegekesa keheli bati hite minalo. Ana kana huto hilinaꞌa lenali ana hite menekehelibe. Ya huꞌehinagi be go bati hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ma huto anana huto hilibe. Bo moneuba hepato heꞌmito fatoga bilubeꞌmu nohutoꞌa liliꞌna bonaꞌmagihi liliꞌnaꞌaniꞌmu lu epito to bihu kasito minoto kaba nohina bomofihi lu emilina: Kaba huto minobo, luto bufa hilibe. Ya suhi lenali ana hite kaba hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hepa afoꞌafu hiya kanagu alibe lite lenali menekehelibe. Utehi alifi, foluguꞌi alifi, kokole nogo nomelenogo alifi, goꞌi nolinogo alifi, yaꞌma menekehelibe. ");
INSERT INTO bef_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","To lenubuꞌi keꞌehinogo ai meleꞌisi noenogomo henatini hilabe? To ya higo bu gefe lite minalo. ");
INSERT INTO bef_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nani yaꞌma lu nolepuna ka asaga bonaꞌmagihi ana huto lu noepube. Bu go bati hite kaba hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","To yalo ana kanagu, sipi mono bomagi to mono ka enelepise bomagi hiti Yesuhi suguna huto nagaꞌi emito ho fililune lite mineꞌahabe. To ana kanagu, Yuta bonaꞌmagi asagaꞌi sipi mono yupapo hapi filuneꞌmu hite minete: Loe yupahi su holenogo nagaꞌi emilune lite kana meleꞌahabe. Henaꞌmube? Ana loe yupahi, mono yupahi yagi, sipi noseꞌna loemo laita hilata nehana kana yabe. Mone noseꞌna kana Pasa yabe nelana, yaꞌma koyapa Huꞌmau enubuto buꞌehina yupa kumu yabe. To mone noseꞌna kana enali beleti noseꞌnaꞌani yisiti hiti lolo mehise faꞌmene nenana yaꞌma yupa kumu yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ana sipi mono kana maꞌasi hapi filuneꞌmu nehago yaꞌma sipi mono bomagi ma lite enegekesa keheliꞌahabe: Lali yaꞌma Yesuhi sipi noseꞌna kanagu ho fililenogomo, asaga bonaꞌmagi kehelite luba hilabe. Ya higo, yaꞌma noseꞌna kana su holenogo ho fililune. Enali ya lite kehelite geba hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","To Yesu Betani hepatoga buto mone bomofihi nohaꞌagu tito minoꞌehibe. Yaꞌma koyapa hehe bomofihi, giꞌa Simoni, aiꞌa nohaꞌagu minoꞌehibe. To anaga minoto noseꞌna nonago, aꞌi moneuba efaha kopo kofito aitoga oꞌehina. Ana konugu mesebe nagamiꞌi hetofana niꞌigo, giꞌa Nati yabe, sipi efapoloti mina fiꞌehinaꞌa yaꞌma kofito oto li hokolo huto Yesuhi latahaꞌalo i heki etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","To bonaꞌmagi moneꞌa bu gete enipagu logo bigo, ai lu emigo ai lu emigo hite ma liꞌahana: Akae. Henabe luto ya huto i hekibe? ");
INSERT INTO bef_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ana mesebelotiꞌi minaꞌa 300 kina lito buto musufalo bonaꞌi epitita bati hutitaꞌmu yabe. To ya huto latahaꞌalo faꞌmene hekiꞌehina bati mehina supo hibe. Enali ya lite ana aꞌmofihi ka emekiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","To ya lago, Yesu ma lu epiꞌehina: Oꞌe. Ya ka heꞌmilo. Henabe lite ka emekiꞌahabe? Ka meemekilo. Ai bati suhi hu netoꞌehina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Enali musufalo bonaꞌi lenalitoga asaga yupahi mineba mineba nehanagi to lenali bati hite fato fato yupahi efahi epilanaꞌmu yabe. To nani lenalitoga asaga yupahi minoba minoba mehilube. ");
INSERT INTO bef_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yaꞌma aꞌmouba nanimo nehe filite keli halanaꞌmu luto yataꞌa mesebe nugufaꞌnilo folo netoꞌehina niꞌibe. Bonaꞌi keli haluneꞌmu nehana suhi huto nugufaꞌnilo mesebe foloꞌehina yabe. Aiꞌa so kiꞌehinaꞌa ahu netoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","To lusiga nolube. Alihi nani kumu ka lamanaꞌa asaga melugu hepatoga bite kaga beto hite lu epilana nehite yaꞌma aꞌuba hu netoꞌehinamofihi kaꞌmu ana hite lu epilabe. Ai hu netoꞌehinamofihi beto hite kaga lilabe. ");
INSERT INTO bef_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ya noligo aposolo bo moneuba, Kelio nagaꞌi nohina bo, giꞌa Yutasi, ai anagati heꞌmito buto sipi mono bonaloga buto Yesu kumu gutunu ka lu epilubeꞌmu buꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Buto Yesu nohinalo yamofihi lenelepilube luto lu epigo, enali fokehi lite: Efahi kimilutagihe, lite lu emite meleꞌahana. Yalo ai Yutasiu Yesuhi enelepilina kapoꞌa sa sa huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","To ana kanagu, sipi noseꞌna beleti noseꞌna yisiti hiti lolo mehise nalana yupahi utehi hapi filuneꞌmu nehago sipisipi yaga nalaꞌa Pasa mono yupapo kumu luto helata nehana kanagu, Yesuhi panaꞌaloboꞌamagi ma lu emiꞌahana: Lali Pasa noseꞌna hiyaga buto nalune? Hiya nonugu noseꞌna li nupa huto laita hu ketalune? ");
INSERT INTO bef_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ya lago, Yesu panaꞌaloboꞌa loemofihi ma lu etimito etoho lifiꞌehina: Olopa hepatoga tite to bo moneuba nagami kohi kofito nobinogo letali bu geletetiti bite megeꞌi biliyo. ");
INSERT INTO bef_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","To ai tilina nonugu nehetite noho bo ma lite lu emiliyo: Afotifu panaꞌaloboꞌni hiti Pasa noseꞌna naluta nohi hiyaꞌa niꞌibe luto nolibe. Ya lite lu emiliyo. ");
INSERT INTO bef_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","To ai ifo nonugu leteleꞌmoto tilibe. Anagu sipi nohi mone aiꞌa aleꞌmo bati huꞌehinana letelepilibe. Ana nonugu letali Pasa noseꞌnati li nupa hite leꞌmo bati hiliyo. ");
INSERT INTO bef_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ya ligo, ana loe bomaleꞌi aitogati heꞌmite bite olopa hepatoga tite to Yesu lu etimiꞌehinana yamofihi asagaꞌi bu gelete nohi tite anagu Pasa noseꞌna leꞌmo bati hiꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","To utehi noligo Yesugi panaꞌalobo 12 magi enigiꞌa aposolo bomagi enali hiti ana nonugu tiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","To noseꞌna nete nehago Yesu ma luto lu epiꞌehina: Lusiga nolube. Lenali nani hiti noseꞌna nenana bonaꞌi lenali folagahatiniguti bo moneuba fatehatimagihi nani kumu gutunu ka lu epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ya ligo, enali enipagu keta higo, hapi fite moneꞌisi moneꞌisi: Nanifiye ligo, nanifiye ligo ya lite loka heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","To ai ma lu epiꞌehina: Lenali folagahatiniguti, aposolo bo moneuba ana hilibe. Nani hiti moneko lapelugu lifito nonana bo yabe, Yesu ya luto luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","To ka mone hiti ma luto lu epiꞌehina: Nani Kokulumaguti limiꞌohuna Bomofita noho fililabe yaꞌma nani kumu mono kagu koyapa keyeꞌahana ka nanitoga ahuto hilibe. To Kokulumaguti limiꞌohuna Bo kumu gutunu ka fatehatimagihi lu epilina bomofihi Huꞌmau gumiꞌi gofa huto halinaꞌmu yabe. Akae. Ana bomofihi itoꞌafu meketatita bati hutitaꞌmu yabe. Huꞌmau gofana huto halinaꞌmu yabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","To noseꞌna nenago, Yesu beleti noseꞌna lito bebe sana ka luto yalo i gofa huto epito ma lu epiꞌehina: Lite nalo. Yaꞌmana nani nugufaꞌni yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","To yalo bai nagami kohi lito, Huꞌmamofitoga foke ka lutoꞌa yalo li epilago, enali asagaꞌi neꞌahana yabe. To nenago, Yesu ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yaꞌma nagamiꞌi golahaꞌni yabe. Huꞌmau bonaꞌmagi kumu luto kaga lu moloꞌehinaloꞌi golahaꞌni limi su halibe. Yaꞌma Huꞌmamofitoga lu mu tifiseꞌnaꞌamu yabe luto golahaꞌni li huto hu moloꞌohube. Yege yege bona kumu luto limi su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","To lusiga lu nolepube. Nani yatai bai nagamiꞌi nonobe. Akuꞌi asaga yupahi menalube. To alihi Huꞌmamofihi kapoꞌa huto akuꞌi yalo yuhufasi nalunaꞌmu yabe luto Yesu ya luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ya ligo, enali mono nama mone lilete yalo nonuguti heꞌmite bite Oliba kosaga tite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","To anaga Yesu ma luto lu epiꞌehina: Lenali asagaꞌi heꞌmi netete koli felefa hilabe. Mono kagu Huꞌmau koyapa kaga ma ligo keyeꞌahana: Nani kaba bomofihi holenogo, enali sipisipi yagaꞌa tili tele hite bilabe. Yaꞌma ka luꞌehinaꞌa nanitoga ahuto hilibe. Lenali heꞌmi netete ya hite tili tele hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","To alihi Huꞌmau filiꞌohunaguti neleꞌmo ho tilenogo, nani kohe toto buto Galili kapogu buloto akuꞌi li gehesa hilune. ");
INSERT INTO bef_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ya ligo, Pitau ma lu emiꞌehina: Oꞌe. Enali asagaꞌi heꞌmi ketete fele su nehenogo nanigo minalube. ");
INSERT INTO bef_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ya ligo, Yesu kaꞌalo ma luto lu emiꞌehina: Nani lusiga lu nokumube. Kai yatai foluguꞌi kokole loe yupahi nogo memoloꞌehinogo kai nani kumu: Ana bo mekeheliꞌohube, luto bahane hoto loeyagi moneyagi yupahi bahane hoto lu epilane. Yesu Pitahi ya lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ya ligo, Pitau amuya moloto ma luto lu emiꞌehina: Oꞌe. Nani kai kumu bahane hoto lu meepilube. Kai hiti nehe fililuneꞌmu nehinogo, ana huto bahane hoto lu meepilube. To nani ana huto nehe fililana bati huto yabe nolube. To panaꞌaloboꞌamagi asagaꞌi ana hite yaꞌma lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yalo bite mone hepatoga, giꞌa Gesemani bite nehetite, Yesu panaꞌlobomagihi ma luto lu epiꞌehina: Nani Huꞌmamofihi ka lu emito nunumu hu emilubeꞌmu nohunagi, lenali maga minete meto minalo. ");
INSERT INTO bef_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya luto ai Pitagi Yemesigi Yonigi, enaligo eneleꞌmoto nobigo, komopaꞌagu sipi keta higo ipaꞌagu gabuꞌi gofa gigo ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ke. Nemehuba sipi keta higo, nipagu gabuꞌi gofa gigo fililubeꞌmu nohube. Lenali maga minete, kaba hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ya luto yalo nesiꞌasi buloto melugu kana fu tito koloto nunumu huto Huꞌmamofitoga yaꞌma gupisalo gabuꞌi giseꞌnamofihi kanaꞌa akuꞌi huto mehilifi to huto hilifi ya luto loe lugufa ekesa kehelito loka hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","To ma luto nunumu huto luꞌehina: Oho. Apaobe. Afoꞌnigase. Kai amuyaka hiti bo nohane. Kai asagaꞌna hilatana mone keta mehu ketoꞌehina niꞌibe. To yaꞌma hu netalubeꞌmu nohataya heꞌmilapiye? Kai keheliꞌahane. Yaꞌma nani foyaꞌni meniꞌibe. Kaika so kiꞌahatanamofihi hu netobo. Afoꞌnigabe. ");
INSERT INTO bef_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya luloto, i behe huto oto panaꞌaloboꞌamagi enubuꞌi nekago, oto bu goto Pitatoga ma luto lu emiꞌehina: Akae. Simonio. Kubuꞌi nokapiye? Kai hupamone kanagu bati huto kaba hu netalataꞌa mehuꞌahapihe? ");
INSERT INTO bef_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yalo enalitoga ma luto lu epiꞌehina: Lenali kaba hite minalo. Yaꞌma Satau fi taga hu lepololenogo lenali foipana hilafi mehilabe. Lenali foipana hi lalagi luto kaba hite minete nunumu hilo. Lenemehuba uleꞌale huto minalubeꞌmu nohinagi akuꞌi lenugufa lapa mebiꞌehina niꞌibe. Yaꞌmu kaba hi bati hite minete nunumu hite minalo. ");
INSERT INTO bef_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","To Yesu ya luloto mone hiti buto Huꞌmamofitoga nunumu huto yaꞌma koyapa lu emiꞌehina ka ana huto akuꞌi lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","To yalo i behe huto oto bu enagago, enali ana hite enubuꞌi kefa hiꞌahabe. Enubu kolo kolo higo, kefa hiꞌahabe. To ai kaga lu epinamo, enali ka melise mineꞌahana. Henaꞌmube? Enubuya higo, henabe ka lu emilune lite, enegekesa yigite legese hite ka melise faꞌmene mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To ai mone kana hiti buloto oloto bu enogoto ma luto lu epiꞌehina: Lenali ana hite lenabasu bite ke fa nehafiye? Yatai anasi yabe. Kanaꞌni aoꞌehibe. Bo moneuba nani Kokulumaguti limiꞌohuna Bomofita kumu gutunu ka lu epilago, yaꞌma fatehatimagi, foipa bonaꞌmagi nagaꞌi nimiluneꞌmu nealabe. Bu galo. ");
INSERT INTO bef_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nani kumu nagaꞌi fatehatimagihi enelepilata bouba aꞌnoabe. Ho tilo. Lali aitoga bilune. ");
INSERT INTO bef_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ya noligo, anaꞌasi aposolo bo moneuba, giꞌa Yutasi, ai hiti babu bonaꞌmagi hiti muki osahi to emita osahi kofite neabe. Enali sipi mono bomagi to mono ka enelepise bomagi hiti to olopa mono bomagi hiti enoho lifilago ete nehetiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","To Yutasiu koyapa ma luto alu epiꞌehina: Buga. Yaꞌma nani soso hu etaluna bomofihi lenali bu gete nagaꞌi emite li pili kete leꞌmete bilo. ");
INSERT INTO bef_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","To Yutasiu yalo Yesutoga anaꞌasi oto be tigito: Afoꞌnigabe luto soso hu etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ya higo, enali meꞌme hite bite nagaꞌi emiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","To ya hago, anaga minana bo moneuba emitaꞌi li saga hutoꞌa sipi mono kaba bomofihi koko panaꞌamofihi ekesaꞌa i gitigito laga hu heꞌmiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ya higo, Yesu ma lu epiꞌehina: Lenali yatai henabe lite osahi hiti emitaꞌi hiti nanitoga kofite neabe? Nani guminalo bo nohufihe? ");
INSERT INTO bef_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","To nani asaga yupahi sipi mono nonugu lenali nehanalo minoto kaga lu lepilata huto minonamo niꞌinaya to lenali nagaꞌi menimiꞌahanaya yatai henabe lite emitaꞌi hiti osahi hiti lite neabe? Ana, yaꞌma mono kagu koyoꞌehinanauba yatai nanitoga huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ya ligo, panaꞌaloboꞌamagi asagaꞌi aitogati heꞌmite koli feleꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","To anaga neheya kola bo moneuba gu kata mehepise koholi kata anasi hepiꞌehina bouba Yesuhi megeꞌi nobigo, enali ai hiti nagaꞌi emilune lite nu nekigo, ");
INSERT INTO bef_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ai meleꞌisi kataꞌa enayanugu heto nomoloto gufayapago koli folofa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","To enali Yesuhi leꞌmete bite sipi olopa mono bologa leꞌmete biꞌahabe. To anaga sipi mono bomagi asagaꞌi to olopa bomagi hiti to mono ka enelepise bomagi hiti li nupa hite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesu anaga leꞌmete nebago Pitau fotoꞌi minoto megeꞌi buto sipi olopa mono bomofihi kugumaꞌalugu tito gimi boꞌamagi hiti meto minoto logo lota huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","To sipi mono bomagi to mono kanisolemagi asagaꞌi ka foya liꞌahabe. Ka foya lite, to Yesuhi ho filune lite ai kumu mukulu filina bo sa sa hiꞌahabe. Akuꞌi ho filise ka lilata bo mone huto mehuꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Fato fato bomagi Yesu kumu faga lite megeka liꞌahago akuꞌi moneko ka legege hite meliꞌahabe. Fato fato ka liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","To moneꞌamagi ho tite faga lite ma liꞌahabe: ");
INSERT INTO bef_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Lali yaꞌma bomofi kumu kaga noligo keheliꞌohuta yabe. Ai ma lulata luꞌehina: Yaꞌma sipi mono nohi bonaꞌmagi giꞌahana nohi nani tele bilotoꞌni akuꞌi loeyagi moneyagi yege yupahi bonaꞌmagi megilana nohi meleꞌisi gilube. Ya noligo, keheliꞌohuta yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enali ya lite akuꞌi ana hite moneko ka melise sibi sibi ka lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","To yalo, sipi olopa mono bouba folagato ho tito Yesuhi ma luto loka hoꞌehina: Kai ka meluse minalapiye? Kai kumu kifisa neinaya henabe ka akuꞌi lilane? Ya ligo, Yesu enali kaꞌani gusunupaꞌa meniꞌigo kehelito ka meluse faꞌmene minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ya higo, sipi olopa mono bouba, mone hiti loka hoto ma luꞌehibe: Kai hetofa bo Huꞌmamofihi panaꞌa, Mesia bo nohapiye? ");
INSERT INTO bef_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ya ligo, Yesu ma luto luꞌehina: Nani ana bo nohube. To alihi yupahi nani Kokulumaguti limiꞌohuna Bomofita Huꞌmamofihi lamagaꞌalo minenogoꞌni bu galane. To aku kokulumaguti sopohi hiti noliminogoꞌni bu galane. ");
INSERT INTO bef_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ya ligo, ana sipi mono bouba komopaꞌagu logo bigo, gu kataꞌa li botala itoꞌa Yesuhi ka emekiloto ma lu epiꞌehina: Anasi nolibe. Lali henabe luto fato bonaꞌi enoloka halune? ");
INSERT INTO bef_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aiꞌa bagaꞌaluguti Huꞌmamofihi megeka noligo keheliꞌohune. Henana hu etalune? Lenali kehelite lu nimilo. ");
INSERT INTO bef_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ya ligo enali asagaꞌi: Ho fililune lite moneko ka liꞌahana. Yalo bonaꞌi moneꞌamagi Yesuhi libiꞌna heteꞌani to buꞌa ifi tete enaya osatu hoto ma liꞌahana: Oho, kiyiꞌafu kohoꞌehibe. Lu hokolo hubo. To ya nelago gimi bomagi ana hite enaya osatu heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ya nehago Pitau afetoga kugumalugu minoto logo lota huto nominago ana sipi mono bomofihi kele kele paꞌa moneuba oto bu goto gili gili huto nohutoꞌa ma lu emiꞌehina: Kai yaꞌma Yesu Nasalete nagaꞌi nohina bo hiti mineꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ya ligo Pitau bahane hoto amuya moloto ma luto luꞌehina: Oꞌe. Kai nolataka menokehelube. Ya luto bihu kasito buto minoꞌehibe. To kokole nogo moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","To ana kele kele paꞌuba bu goto anaga neminana bonaꞌmagihi lu epiꞌehina: Bu galo. Kaꞌmeya bo Yesuhi panaꞌa nohibe. ");
INSERT INTO bef_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ya luto ligo Pitau ana huto: Oꞌe, luto bahane hoꞌehina. To kana nesiꞌasi bu su holago logo lota huto minana bo moneuba Pitahi ma luto lu emiꞌehina: Maꞌnaka. Kai panaꞌa nohutoka yaꞌma faga meluboꞌma. Galili nagaꞌi nohata keheliꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ya noligo Pitau huli ka luto to yahi tito amuya moloto ma lu epiꞌehina: Oꞌe. Nani ana bomofi kumu lenali kaga lu nimilata nehana yaꞌma mekeheliꞌohube. ");
INSERT INTO bef_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ya ligo anaꞌasi kokole nogo mone hiti moloꞌehina yabe. To Pitau Yesu lu emiꞌehina ka beto huꞌehina. Yesu koyapaꞌi lu emiꞌehina: Kokole loe yupahi nogo memoloꞌehigo nani kumu loeyagi moneyagi yupahi bahane halane. Pitau ana kaꞌamofihi kehelito beto hutoꞌa yibi hafili gofa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Etehi foluguꞌi sipi mono bomagi hiti mono ka enelepise bomagi hiti olopa bomagi hiti mono kanisole bomagi hiti asagaꞌi tutumaꞌi hite mineꞌahabe. Tutumaꞌi hite Yesuhi yahaꞌalo seni naga ite leꞌmete bite gamani koti kaba bomofihi, giꞌa Pailati, ai nohinalo leꞌmete biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","To Pailatiu Yesu ma luto loka hoꞌehina: Kai Yuta bonaꞌmagihi kigihiti boꞌani nohapiye? To Yesu: Aꞌnolane, luto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","To sipi mono nohi kaba bomagi fato fato ka lite bugu ka liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ya lago, yaꞌmu Pailatiu mone hiti loka hoto ma luꞌehibe: Kai kaga meluse minalapiye? Enali yege yege ka lite kubugu ka nelanagi kaꞌanilo nonaꞌa lu meepilapiye? ");
INSERT INTO bef_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","To Yesu enali kaꞌani bebe mesago, kehelitoꞌa ka meluse faꞌmene minago Pailatiu topa hoto minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","To ana sipi Pasa noseꞌna kanagu Pailatihi hapaꞌa ma hulata huto minoꞌehina. Ana kanagu kalabusi bo mone enali Yuta bonaꞌmagi gi halana bo moneꞌmofihi kalabusi nonuguti leꞌmo heꞌmilata huto huꞌehina hapaꞌa yaꞌma niꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","To ana kanagu kalabusi nonugu bo mone, giꞌa Balabasi yabe luto minoꞌehibe. Ai luba hiꞌahana yupahi bo moneꞌmofihi ho filiꞌehina bo yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","To yaꞌma kanagu, asaga bonaꞌmagi Pailatitoga ete me lite loka heꞌahana: Kai mana kanagu hulata huꞌahata hapaka hu letobo. ");
INSERT INTO bef_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","To ya lago, ai ma luto lu epiꞌehina: Nani yaꞌma Yesuhi lenali Yuta bonaꞌmagita kibina botinimofihi leꞌmo heꞌmi etalufihe? Lu nimilo. ");
INSERT INTO bef_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ai yaꞌma mono bomagi Yesu kumu siko nehite nagaꞌi emiꞌahana kehelitoꞌa ya luto enoloka hoꞌehinagihe. ");
INSERT INTO bef_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","To ya luto enoloka hago, enali sipi mono bomagi yaꞌma anaga li nupa hite nehana bonaꞌi asagaꞌi eneleꞌmo topa hago, to sipi mono bomagi amuya melete lu epiꞌahana: Yesuhi anaꞌa hiligi lu emilo. Balabasihi gulu ho etobo, lu emilo. Ya nelago yaꞌma li nupa nehanamagi asagaꞌi kehe ite Pailatihi ma lite lu emiꞌahana: Yesuhi anaꞌa hiligi. Balabasihi gulu ho etetogo bino. Ai kalabusi nonuguti faꞌmene limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ya nelago Pailatiu mone hiti ma luto enoloka hoꞌehina: Yaꞌma boꞌmu, lenali Yuta bona gihiti bo yabe lite gi nehana bomofihi henana hu etalube? ");
INSERT INTO bef_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ya ligo, enali hekele lite: Ho filibo. Malipu yafalo ho filibo, lite lago, ");
INSERT INTO bef_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailatiu: Henabe lutobe? Ai hiya foipa suhi huꞌehibe, luto ligo enali sipi nogo bela ka lite: Ho filibo, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ya lago, Pailatiu komopaꞌani leꞌmo fulu hilube luto Balabasihi leꞌmo heꞌmi etoꞌehina yabe. To yalo Yesu kumu kaga ligo, gimi boꞌamagi naga osatu heba heba hiꞌahabe. To leꞌmete bite malipu yafalo halo luto lu epilago, gimi bomagi leꞌmete biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gimi boꞌamagi Yesuhi leꞌmete bite yaꞌma sipi kaba bomofihi nopo, Gamani Nohi yabe, ana nonugu leꞌmete biꞌahabe. To enali enalaluꞌani mone lugaꞌamagihi kehe igo ago li nupa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yalo Yesuhi okoho nakuꞌi hepi etete to latahaꞌalo ufehaꞌa hiti nagaꞌi hesete kofi etete, ");
INSERT INTO bef_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","to hapi fite be tigite: Oho. Yuta bonaꞌmagihi enikibina bo, lite meꞌna meꞌna biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","To latahaꞌa osatu heba heba hite, to libiꞌna hete aitoga lipite nehite meꞌna meꞌna biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","To yokoloꞌna hi su helago, ana okoho nakuꞌi li heꞌmi etete yalo aiꞌa kataꞌa hepi etete fegutoga leꞌmete bite malipu yafalo ho fililuneꞌmu leꞌmete biꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","To leꞌmete nebago bo moneuba Sailini nagaꞌi nohina bo giꞌa Simoni, Alekasatahi to Lufusihi afoꞌatitifu yagi, ai ana kapolo kifiguti noago enali bu gete leꞌme kefefe hite nagaꞌi emite Yesuhi malipu yafaꞌa gupisalo li malago ai kofito buꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kofito bigo enali Yesuhi leꞌmete bite Gologota kosalo nehetiꞌahana. Ana hepaꞌi giꞌa mone lali kaguti, Lataha Felisaꞌa hepaꞌi yabe luto gi hoꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anaga nehetite Yesuhi bai nagamiꞌi hiti to mone yafa nogoyaꞌa hiti, giꞌa mila yabe, yana emiluneꞌmu hanaꞌa mo siꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","To yalo, Yesuhi malipu yafalo nili hete heꞌahana yabe. To gu kataꞌa kiyiꞌafu lilibe lite, li gehe lite melete kati supo hite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","To yaꞌma malipu yafalo heꞌahana kana etehi foluguꞌi bonaꞌi foyaga nebana kanagu yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","To bo moneuba Yesuhi heꞌahanamomuꞌi fayahi goꞌehinamofihi ana yafa ifoꞌalo li meleꞌahana yaꞌma niꞌibe. Yuta Bonaꞌmagihi Gihiti Boꞌani Yabe, luto yaꞌma fayahi goꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","To Yesuhi hiti guminalo bo loemo ana hite malipu yafalo eteheꞌahabe. Mone hete lamagaꞌaga yafa fite to mone hete sogaꞌaga yafa fite eteheꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ya hite etahago mono ka koyapa koyoꞌehina ka yaꞌma huto huꞌehibe. Ana kaga ma luꞌehina: Ai hiti foipa bole hiti eneheꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","To anaga kapo melete biꞌahana bonaꞌmagi enali bu gete, enayahi koke ite Yesuhi kiya hi etete ma liꞌahabe: Ahe. Kubuyaka hino. Kai sipi mono nohi tele biloto akuꞌi loeyagi moneyagi yegegu gilube luꞌahata bo yale. ");
INSERT INTO bef_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kai malipu yafaloti limito kugufaka leꞌmo bati huto minobo. ");
INSERT INTO bef_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","To sipi mono kaba bomagi hiti mono ka enelepise bomagi hiti enali ana hite kanipo fite kiya hi etete ai lu emigo ai lu emigo nehite ma lite liꞌahana: Yaꞌma bouba fato fato bonaꞌi enubuto biꞌehinaya akuꞌi aiꞌa gufaꞌa leꞌmo bati hilina meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ai Mesia bo Isilaeli nagaꞌmagihi gihiti boꞌani nohifi? Ana, malipu yafaloti limilenogo, lali bu goloto aitoga kehelito agoya hu emilune. Enali mono bomagi ya lite liꞌahabe. To ai hiti malipulo eteheꞌahana bomaleꞌi ana hite Yesuhi huli ka lu emiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","To fuligahi lulago, asaga hepatoga metepu ito minoto minomo buto utehi 3 kiloki yalo yege akuꞌi loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To ana kanagu Yesu sipi nogo moloto hekele luto kaꞌaguti ma luꞌehina: Eloi Eloi, lema sabakatani. Yaꞌma lali kaguti ma luꞌehina: Oho. Huꞌmao, afoꞌnigabe, afoꞌnigabe. Henabe luto heꞌmi netoꞌahane? ");
INSERT INTO bef_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya ligo, anaga neminana bonaꞌi moneꞌamagi kaꞌa kehelite ma liꞌahana: Akae. Ai yaꞌma koyapa bo Elaiya, ai kumu kehe noibe. ");
INSERT INTO bef_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","To bo moneuba kehelito hololu luto buto lututuhi lito buto ekesa bai nagamilugu li moloto yalo lito oto eminogoꞌni nalibe luto, lito oto yatama osatu li saga huto noemito ma luꞌehina: Bu galo. Yaꞌma Elaiyau oto yafaloti leꞌmo heꞌmi etalifi bu galune. ");
INSERT INTO bef_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","To Yesu sipi nogo moloto anaꞌasi sikalafuꞌi molo su hoto filiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","To nofiligo, kaꞌmeya sipi mono nonugu kata hasamo ifoꞌagati hapi fito limito i bololo i su hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","To Yesu sipi nogo moloto sikalafuꞌi molo su hoto filigo, gimi kaba bo moneuba Yesuhi hapaꞌa bu goto kehelito ma luto luꞌehina: Maꞌnaka. Yaꞌma bo Huꞌmamofihi panaꞌa maꞌnaka luto nohibe. ");
INSERT INTO bef_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","To anaꞌi moneꞌamagi fotoꞌi nehite bu gete mineꞌahabe. Mone giꞌa Malia, ai Magatala aꞌi yabe. To mone ana huto giꞌa Malia, ai Yosese hiti to lagaso Yemesi hiti itoꞌatitifu yabe. To mone giꞌa Salome yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yaꞌma anaꞌmagi koyapaꞌi Yesuhi Galili kapogu minoꞌehigo megeꞌi melelata hite to noseꞌna emilata hite mineꞌahana yabe. To fato anaꞌmagi babu luto Yesuhi megeꞌi bite Yelusale hepatoga eꞌahana anaꞌmagi ana hite bu gete mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","To utehi noligo, ana kanagu fuli yupahi hapi filubeꞌmu nohigo, fuli yupahi nalana noseꞌna leꞌmo bati hilata kana niꞌigo, bo moneuba. ");
INSERT INTO bef_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimatia nagaꞌi nohina bo, giꞌa Yosefe, ai olopa mono kanisole bo nohuto, ai Huꞌmamofihi kapoꞌa alina kana geba huto minolata nohina bo nohuto, ai lesaꞌa meligo buto Pailatihi nohinaga tito: Yesuhi gufaꞌa li nimilapiye, luto loka hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Loka hago, Pailatiu: Akae. Afiliꞌehifiye luto ekesa yigitoꞌa gimi boꞌa mone kehe igo ago: Afiliꞌehifiye luto loka hago, ai: Oꞌyo, luto lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","To gimi bouba: Afili labata huꞌehibe luto lu emigo, Pailatiu Yosefehi: Gufaꞌa bati huto lito bubo, luto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To ya ligo, Yosefeu buto yuhufa koli kata hetofanaꞌa mina filoto lito buto Yesuhi gufaꞌa yafaloti ho kutu foto ana katamotu sa gito kofiloto buto keli halube luto, buto efaha kosagu kifiꞌahana muliꞌmogu li moloꞌehina yabe. To ana muliꞌmofihi kasihaꞌalo mone sipi efahi felaꞌa li behe behe huto hekini loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","To ya nohigo, yaꞌma Magatala aiꞌi giꞌa Malia, ai to Yosesehi itoꞌafu, giꞌa ana huto Malia, ana aꞌmaleꞌi Yesuhi gufaꞌa keli hoꞌehina hepaꞌi bu gete keheliꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Fuli yupahi su holago, Malia Magatala aꞌi to Malia Yemesihi itoꞌafu to Salome, enaligo Yesuhi gufaꞌalo mesebe falalune lite bite hetofa mesebe mina fiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","To etehi goꞌi noligo bite muliꞌi niꞌinaga nebite ai lu emigo ai lu emigo hite ma liꞌahana: ");
INSERT INTO bef_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yaꞌma muli bagaꞌaga niꞌinalo efahi fela efapo niꞌigo, kiyiꞌafu li behe behe hu heꞌmi letalibe? ");
INSERT INTO bef_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","To anaga nehetilete bu gago ana sipi efahi bagaꞌagati ali behe hi heꞌmiꞌahago bu gete: Akae, lite topa heꞌahana. ");
INSERT INTO bef_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","To mulilugu tite bu gete, muliꞌmofihi kasihi lamagaꞌaga neheya kola bo mone koholi kata yatamana hepiꞌehina bouba meto nohigo bu gete lusi koli hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","To ai ma luto lu epiꞌehina: Koli mehilo. Lenali Nasalete bo, Yesu, malipu yafalo filiꞌehina bomofihi sa nehana keheliꞌohube. Ai maga menohibe. Aho tiꞌehinagihe. Bu galo. Yaꞌma meleꞌahana hepaꞌi bu galo. Menohibe. ");
INSERT INTO bef_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","To lenali abilo. Bite Pitagi to panaꞌalobomagihi asagaꞌi ma lite lu epilo: Yesu koyapa lu lepiꞌehinana yamofihi ahuꞌehibe. Ai kohe toto Galili kapogu aꞌnobinagihe. Lenali ya lite lu epilo. ");
INSERT INTO bef_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ya ligo, enali kehelite enelesaꞌani ligo, sipi koli hiteꞌani ana muliꞌmoguti tite hololu bite koli felefa hiꞌahabe. Sipi koli hiteꞌani asaga bonaꞌi ka lu meepise faꞌmene mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","To Yesu, fuli yupahi su holago, etehi foluguꞌi filiꞌehinaguti ho tiꞌehina yupahi ai yataꞌa Malia Magatala aꞌmofihi bulo huto huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana aꞌi Yesu koyapa foipa fele 7 heꞌmi etoꞌehina aꞌi yabe. Yesu ana aꞌmofihi bulo yataꞌa huto higo, ai buto Yesuhi megeꞌi melelata hiꞌahana bonaꞌmagi yibi gofana hite nehanaga buto nehetito lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesu huto nohigo bu goꞌohube luto lu epigo, enali: Faga yabe lite enipagu huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","To yalo panaꞌi loemaleꞌi kifigu biluꞌibeꞌmu kapo nemalaꞌigo Yesu huto huse fatoꞌi etubulo huto huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ya higo, etali kehelilete i behe hite bite panaꞌalobo asagaꞌi yaꞌma lu epiꞌigo, enali: Faga yabe lite enipagu huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","To alihi, aposolo bomagi 11 magi li nupa hite noseꞌna nenago, Yesu enubulo huto huloto ka epekibe. Henaꞌmube? Enali, bonaꞌi moneꞌamagi Yesu filiꞌehinaguti ho tiꞌehigo bu gete ka lu epigo, enali: Faga yabe, lite enipagu higo komopaꞌani uleꞌale higo Yesu yaꞌmu ka epekiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","To ai ma luto lu epiꞌehina: Lenali asaga melugu hepatoga bite bonaꞌmagihi hetofa kaꞌni yaꞌma ka lamanaꞌa lu epilo. ");
INSERT INTO bef_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","To bo moneubafi moneuba ana ka kehelito agoya hu nimito nagami falalina bo, aiꞌi buto bilunagihe. To bo moneubafi moneuba kehelito agoya hu menimilina bomofihi nani gumiꞌi hoto leꞌmo heꞌmilunagihe. ");
INSERT INTO bef_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","To agoya hu nimilana bonaꞌmagi enali yaꞌma topa hese foya suhi lilabe. Enali nigiꞌni hete foipa felemagihi bona komopaꞌaniguti eneleꞌmo heꞌmilabe. To enali fato fato bonaꞌmagihi kaꞌaniguti kaga lilabe. ");
INSERT INTO bef_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","To enali osifaꞌi enayahi lilana to nalisa nagamiꞌi nalanafi ya hilana mefililabe. To enali epesiꞌehina bonaꞌmagihi enugufalo enayahi melenogo fa hu epalalibe. Huꞌmamofihi amuyanaꞌa enalitoga minenogo yaꞌma topa hose foya suhi lilabe. ");
INSERT INTO bef_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","To Sipi Bo Yesu ai ana kaga lu epi su holotoꞌa yalo kokulumalugu tito folofa huꞌehibe. Anaga tito Huꞌmamofihi yahi lamagaꞌaga mino moloto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","To enali bu gelete, bite asaga hepatoga biba biba nehite Yesuhi hetofa kagaꞌa lu yege helata mineꞌahabe. To Sipi Bouba eneheꞌmoto enalitoga minago, enali sipi liliꞌna amuyaꞌa hiti topa hose suhi lite hiꞌahabe. To yanaꞌmu bonaꞌmagi yaꞌma bu gete enali: Lusiga nelabe lite keheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Oho, Tiofilusi, nalaluꞌniga. Babu bonaꞌmagi lalitoga huto huꞌehinamofihi kagaꞌa fayanugu geꞌahana yabe. Enali enubuguti bu geꞌahana to Huꞌmamofihi kagaꞌa lu hokolo hiꞌahana bonaꞌmagi lu epiꞌahago fayahi keyeꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Enali ana bonaꞌmagi enubuguti bu geꞌahago anana huto huꞌehina bonaꞌmagihi enabaga enemegeꞌi meleꞌahana yataꞌa mana kaga to asaga yupahi yabe. Enali yaꞌmana bonaꞌi Huꞌmamofihi kagaꞌalo liliꞌnalo boꞌa mineꞌahana to yaꞌmana kaga lalitoga nelimibe. ");
INSERT INTO bef_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ya higo nani ana huto yaꞌmana kaga fayahi gotoꞌni kaitoga heꞌminogo bilibe. Koyapaꞌi nani yaꞌmananamofihi hapaꞌamu leꞌmo bati huto negeꞌnoka hoꞌohube. Yatai nani leꞌmo fotogo huto nogobe. ");
INSERT INTO bef_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya huꞌehinagi kai keheliya iloto yaꞌmana ka enali kelepiꞌahanaꞌa to maꞌnaka luto yaꞌma keheli baga iluneꞌmu hane. ");
INSERT INTO bef_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","To Yutia bonaꞌi enigihiti bo Heloti ai minana kanaꞌagu mono bo mone minoꞌehina giꞌa Sekalaiya ai Abaisa mono bo nagaluguti lihaꞌa ai Alonihi nagaluguti to ana aꞌmofihi giꞌa Elisapeti yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Etali Huꞌmamofihi bulo bati hite mineꞌahaꞌina. Etali asaga keya kafi to Sipi Bomofihi kagafi liyafa hite pelesa meise hite fulu liꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Moneꞌnaya etali yagapanaꞌatiti memineꞌahana. Elisapeti namopa minoto yagapanaꞌi meketose minoꞌehina. To etali ya litana oyafale mineꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","To mone yupahi Sekalaiya ai yaꞌma Huꞌmamofihi okabalo mamufa gi emilatamofihi liliꞌna nolito ana kanagu mono liliꞌna lugaꞌa aiꞌamoya liloto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Enali mono bomagihi suhi hite leꞌmo ho tiꞌahana to ai sipi mono nohi folagahaꞌagu tito kefa hitalo Huꞌmamofihi tu lokiya go emilibe litemo yabe. Ya hago ai Sipi Botimofihi mono nohaꞌagu notigo, ");
INSERT INTO bef_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","babu boanaꞌi fegutoga li nupa hite nunumu hite lokiya go emilatana kanagu mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","To Huꞌmamofihi ageloꞌa yahi lamagaꞌaga tu lokiya fi emiseꞌnalo ho tito nohigo Sekalaiyau bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ai agelo bu goto topa hoto koli nohigo, ");
INSERT INTO bef_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","agelouba ma luto lu emiꞌehina: Sekalaiyao, kai koli mehubo. Huꞌmau ai nunumuka akeheliꞌehibe. Lihaka Elisapetiu ai panaka ketalinaꞌmu yabe. To kai giꞌa Yonio luto molobo. ");
INSERT INTO bef_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ya hinogo kai kipagu bati hinogo kai kofokehi halane. Babu boanaꞌi enali sipi enofokehi ai huto hilinaꞌmu halabe. ");
INSERT INTO bef_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ai Sipi Bomofihi buꞌalo sipi giꞌa lilinaꞌmu yabe. To ai bai nagamiꞌifi to amuya nagamiꞌifi menalinaꞌmu yabe. Itoꞌafihi ipaꞌagu nohinogo Hetofa Sikalafuꞌuba aitoga bai talinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ai Isilaeli boanaꞌi asagaꞌi enipaꞌani li gelehe hinogo enali Sipi Boꞌani Huꞌmamofitoga bilabe. ");
INSERT INTO bef_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ai Huꞌmamofihi kaꞌa leliꞌali bo legi huto bilinaꞌmu yaꞌma lu yege hose bo Elaiya suhi huto amuya bo hilibe. Ai afoꞌanigi yagapanaꞌani akuꞌi eneleꞌmo nupa hilina to ai ana huto kegeiyo bonaꞌi komopaꞌani li gelehe hinogo komopaꞌani bebe sana bonaꞌmagihi hapaꞌani lilabe. To ai Huꞌmamofihi bonaꞌa eneleꞌmo kosaba hinogo Huꞌmamofihi geba hite alinaꞌmu minalabe. ");
INSERT INTO bef_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","To Sekalaiyau ai agelomofihi loka hoto luꞌehina: Yaꞌmana ka nani henabe luto lusiga yabe lilube? Nani oyafa aloꞌohube to lihaꞌniuba hiti litanaꞌi aloꞌehibe, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","To agelouba Sekalaiyahi kaꞌalo ma luto luꞌehina: Nani nigiꞌni Gebilielita sipi ageloꞌi Huꞌmamofihi okabalo ho notuna yabe. Aiꞌa noho lifito lu emibo ligo yaꞌmana hetofa ka oto lu nokumube. ");
INSERT INTO bef_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","To kai kehelibo. Kai nani kamo keheli menimitamofihi kai kabagaka hekini lolenogo kaga meluse nohitogo asagaꞌna huto hilina yupapogo yabe. Ya huto nohitogo kaga moloto nokumuna yupahi anana huto nohinogo kaga lilane. ");
INSERT INTO bef_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Boanaꞌi enali Sekalaiyau mono nonugu minoꞌehinamoꞌmu geba hiba hiba hite mineteꞌani enali enegekesa yigiba yigiba hite ma lite liꞌahana: Ai ya meyaluga henana huto nohigo mino yatama nohibe liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Alihi Sekalaiyau mono nonuguti leheko limito boanaꞌi kaga lu meepiꞌehina ya higo enali fegutoga geba hite minana boanaꞌi ma lite akeheliꞌahana: Ai mono nonuga tinamoga bame kafi anaꞌina mone bu goꞌehibe. Ya lite nehago ai bagaguti kaga meluse yatuko babeyafa huꞌehina. To bagaꞌa hepito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Alihi Sekalaiyahi mono nonugu liliꞌna lugaꞌa su holago ai hepaꞌaga buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","To alihi lihaꞌa Elisapeti ai yagapanaꞌamuꞌi hiti minoꞌehina. Ya huto ai nayahi mone kegiꞌa su hago ikahi fala kito nonugugo minoꞌehina. Ai luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yatai Sipi Boꞌniuba yaꞌma suhi huto neheꞌmabe ya huto boanaꞌmagi enali enubuloti nubuya huseꞌna li heꞌmi netabe. ");
INSERT INTO bef_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","To Elisapeti yagapanaꞌa hiti ikahi nayahi mone kegiꞌa su hoto mone nayatoga leheko malago nohigo Huꞌmau ai yaꞌma agelo Gebilielihi ho lifigo Galili hepaꞌi monelugu limiꞌehina ana hepaꞌi giꞌa Nasalete. ");
INSERT INTO bef_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ai yafanaꞌi mone panaꞌi moneto lepiꞌahana pato buꞌehina panaꞌmofihi giꞌa Yosefe. Ai Tebitihi nagaluguti yabe. To yaꞌma paꞌmofihi giꞌa Malia yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","To agelouba Malia nohinalo buto ma luto lu emiꞌehina: Maliao. Nohapihe? Fuluna kaitoga mineno. Huꞌmau kai hiti nohuto sipi lusa gi ketalinaꞌmu hetofa hu ketalibe. ");
INSERT INTO bef_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliau ai yaꞌmana ka keheliloto latahaꞌa keta huꞌehina. Ipaꞌagu ekesa yigito ma luto luꞌehina: Yaꞌma ka hena ka niꞌibe? luto ligo, ");
INSERT INTO bef_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","to agelouba lu emiꞌehina: Malia, kai koli mehubo. Huꞌmau ipaꞌa kaitoga bati nohibe. ");
INSERT INTO bef_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kehelibo. Kai yagapana kumu hiti huto panaꞌi ketalataꞌmu yabe. To kai giꞌa Yesu luto molobo. ");
INSERT INTO bef_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ai sipi bo minalinaꞌmu yabe. To yege yege bonaꞌmagi giꞌa liyafa hite Sipi Boti enebe ligiꞌehina bomofihi panaꞌa yabe lilanaꞌmu yabe. To Huꞌmau ai sipi gihiti bo leꞌmo ho tilinaꞌmu yabe. Tataꞌafihi Tebitihi suhi luto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ai Yakopuhi nagaꞌamagihi sipi boꞌani asaga yupahi minalinaꞌmu yabe. To kaba huseꞌnaꞌa hiti kapoꞌa yaꞌma minomo buto su mehalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliau ai agelomofihi lu emiꞌehina: Yaꞌmana ka nolatamofihi hena huto huto hilibe? Nani yafanaꞌi nohuto bolo mebuꞌohube. ");
INSERT INTO bef_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","To agelouba Maliahi kagaꞌalo ma luto luꞌehina: Sikalafuꞌuba kaitoga alinaꞌmu yabe. To Huꞌmamofihi amuyaꞌauba kifi talinaꞌmu yabe. To ya hinogo yaꞌmana panaꞌi alihi ketalataꞌmu yabe, to bonaꞌmagi Huꞌmamofihi Panaꞌa yabe lite giꞌa liyafa hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kehelibo. Kofokafu Elisapeti litanaꞌi aloꞌehinamo ninaya ipaꞌagu panaꞌi koꞌehibe. Koyapaꞌi yagapanaꞌi meketalibe lilata hiꞌahana yabe. Ya huꞌehinamo yatai yagapanaꞌi minoꞌehibe to ikahaꞌa nayahi mone kegiꞌa su hoto mone kegiꞌati loemo leheko malago abuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anaꞌina mone Huꞌmau fetaga huto lolo hilinaꞌa huto meniꞌinagihe. ");
INSERT INTO bef_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To Maliau agelo luꞌehina: Nani Sipi Bomofihi koko aꞌi yabe. Kaga nolatamofihi Sipi Boꞌniuba lolo hu netalibe, Maliau ya luto ligo agelouba heꞌmi etoto abufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yaꞌmana kanalo Maliau ho tito kosa mone Yuta hepalugu niꞌinalo meꞌme huto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","To nonuga tito Sekalaiya nohinalo: Nohapihe? luto Elisapetitoga lu emito be tigiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisapetiu ai Maliahi nohapihe linaꞌa kehelilago yagapanaꞌi ipaꞌagu nohina lehe kolago tiꞌehina. To Sikalafuꞌuba Elisapetitoga bai toꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","To ai nogoꞌa sipiꞌa kehe ito Maliahi lu emiꞌehina: Kai lugaꞌa anaꞌi folagahaꞌanigu keleꞌmo ho tiꞌehinaꞌmu hetofana nohane. To yaꞌmana yagapanaꞌi kipagu nohina aitoga hiti Huꞌmau hetofana hu etalibe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","To nani hena huꞌohugo Sipi Boꞌnimofihi itoꞌafu nanitoga noabe, luto Elisapetiu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kai nebe tigiꞌahana nani nubuꞌniuba nohapihe latamoya keheliꞌehinagi yagapanaꞌi nipagu nohinauba fokehi hotoꞌa leke ho tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Alihi Sipi Bouba alu kimiꞌehina suhi hilinaꞌmu yagi kai keheli uleꞌale huto sipi kofokehi halataꞌmu yabe, Elisapetiu yaꞌma luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","To Maliau ai luꞌehina: Nipaꞌniuba Sipi Bomofihi giꞌa li saga nohibe. Nipaꞌniuba Huꞌma kumu yege nofibe. ");
INSERT INTO bef_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","To nemehaꞌniuba Sipi Bomofitoga fokehi nohoto neheꞌmoseꞌnaꞌamofi kumu negelo nobube. ");
INSERT INTO bef_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nani lilinaꞌalo aꞌi yabe. Nani faꞌmenena nohunamoya ai ekesu mehago nanitoga fuluna nonebesibe. Yatai hiti to alihaꞌa yupa hiti silaga boanaꞌi enali sipi fokehi nanitoga hoꞌehinaꞌmu kaga lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Huꞌmau amuya Bouba sipina nanitoga lolo huꞌehibe. Aiꞌa giꞌa hetofana lamanaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Leꞌmo fulunaꞌauba asaga bonaꞌi manuga minana agoya hu emiꞌahanamagi enalitoga mino baga iꞌehibe. To ya huto buto yagapanaꞌmagitoga buto enali yagapanaꞌmagitoga buloto analo ya humo buba buba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yahaꞌa amuyauba su toto kegeiyo bonaꞌi foipa lu keheliseꞌna hiti enipaꞌanigu kegeiyo hiꞌahana ya nehago ai li sibi sibi huto katili huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ai gihiti bomagi amuyaꞌani nehago kefa hisaloti eneleꞌmo manuga nomoloto to enali enigiꞌani menina bonaꞌi enigi liyafa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ai hetofa noseꞌnatuꞌi enakauꞌna lana bonaꞌi enipaꞌani li bai toꞌehina. To enali bonaꞌi feꞌnohaꞌani babu linaꞌa eneleꞌmo heꞌmigo faꞌmene biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ai Isilaeli liliꞌnalo boꞌa heꞌmoꞌehina. To ai tataꞌtifitoga kaga lu moloꞌehina li hetofa huto hu etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ana huto lali tatatifitoga luꞌehinaꞌa huto yabe. Nani Abalahatoga kekeꞌi lutoꞌni to ana huto ai nagaꞌa alihi huto hilanamagi hiti analo minoba minoba hilinaꞌmu yabe. Maliau ya luto nama luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","To Maliau ai Elisapeti hiti minoto kanaꞌa ikahi loegi monegi minoloto alihi hepaꞌaga i behe huto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetiu yagapanaꞌi ketalina kanaꞌa leba toꞌehina. To ya higo ai panaꞌi ketoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Enali Elisapetihi hepaꞌalo bonaꞌi to ai nagaꞌa ya huto Huꞌmau Elisapetihi ginaga fi emigo panaꞌi mone ketoꞌehibe lanaꞌa kehelilete Elisapeti hiti enali asagaꞌi enofokehi heꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","To nayahi mone kegiꞌa su hoto loegi monegi mone nayatogati leheko malana kanagu ana panaꞌi gufaꞌa laga hiluneꞌmu enali eꞌahana. Enali giꞌa Sekalaiya lite afoꞌafito bahalapao lite malaluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Enali ya nehago ana panaꞌmofihi itoꞌafu ma luto luꞌehina: Oꞌe. Lali Yonio luto giꞌa malalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","To enali lu emiꞌahana: Mone kofokagi yaꞌmana suhi luto enigiꞌani meniꞌibe lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","To enali enayatu babeyafa hite afoꞌafihi lu emite ma lite liꞌahana: Kai hena hibe luto panakamofihi giꞌa malalane? ");
INSERT INTO bef_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekalaiyau fayahi galinanaꞌmu ligo ite ete emigo ananalo panaꞌamofihi giꞌa Yoni luto goꞌehina. To enali yaꞌmana giꞌa bu geleteꞌani enekesa yigiba yigiba hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","To analoꞌi Sekalaiyahi bagaꞌa i aka higo kenetufaꞌa akuꞌi bati huꞌehina. Ya higo ai kaga luto Huꞌmamofihi giꞌa liyafa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","To enali hepaꞌalo bonaꞌi asagaꞌi koli hiꞌahana. To yaꞌmanana huto hinamofihi kaga futili katili huto Yutia kosa hepalugu bula ola huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Asaga bonaꞌi ana kaga kehelilete enekesa yigi fato hiteꞌani ma lite liꞌahana: Alihi yaꞌmana panaꞌuba ai hena hena huto minalibe? Sipi Bomofihi amuyaꞌa yaꞌmana panaꞌmofitoga niꞌibe lite enali akeheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","To Sikalafuꞌuba yaꞌma panaꞌmofihi afoꞌafinugu bai tago ka mone lu huto huto ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Lali Isilaeli bonaꞌmagihi Sipi Bomofihi giꞌa liyafa hilo. Huꞌmamofitoga yege filo. Ai lali boanaꞌa leheꞌmalubeꞌmu oꞌehibe. To fatehatimagihi gegisaguti gulu ho letoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ai sipi amuya boti lubuto biꞌehinana mone leꞌmo ho ti letabe. Ai yaꞌmana bo koko bo Tebitihi tataꞌafu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ana suhi huto ai koyapaꞌi mono bonaꞌamagi enali enabagagu alu epiꞌehinamo yaꞌma niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ai ma luto ka moloꞌehinamo niꞌibe: Nani fatehatinimagihi enayanuguti akuꞌi leneleꞌmalunaꞌmu yabe. To bonaꞌi enali ipakafa nehana bonaꞌmagi enayanuguti hiti akuꞌi leneleꞌmalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nani fuluna lepito leneheꞌmalunaꞌmu yabe, ai ya luto to tatatigi lu epiꞌehina. To ai ana huto ka lamanaꞌa moloꞌehinamofihi ekesalo moloto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ai maꞌnaka luto koyapaꞌi tatatifihi Abalahatoga ka moloꞌehina yabe. To yatai ai koyapa hapati supo ai luꞌehinaꞌa hilubeꞌmu nolibe. ");
INSERT INTO bef_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ai fatehatimagi enayanuguti lubuto bilubeꞌmu nohigo liliꞌnaꞌa lali koko panaꞌa suhi huto lilutaꞌmu koli mehilune. ");
INSERT INTO bef_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ai buꞌalo foipana melise minalutaya hetofana huto minoba minoba hilutaꞌmu yabe. To Sekalaiyau panaꞌa kumu ka mone hiti ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Panaꞌnise, enebe ligiꞌehina bo Huꞌma, aiꞌa kaga lu yege hose boꞌa huto hilane. To yaꞌma giꞌa kai kumu bonaꞌmagi molo ketalabe. Kai yataꞌa kohe toto liliꞌna lito bulotoka Sipi Bomofihi kapoꞌa li hokolo hilane. ");
INSERT INTO bef_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","To bonaꞌamagitoga buto lu epitogo enali kehelilete foipanaꞌani li heꞌmilenogo bati hite minalabe. ");
INSERT INTO bef_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","To afotifu Huꞌmamofihi fuluna hiti kekeꞌi luseꞌna hiti yaꞌmana nohibe. Ai kokulumalugu fana toseꞌna lali kumuꞌi huto hilina yanaꞌuba leheꞌmoto ana huto bonaꞌi lugaꞌa filiseꞌnamofihi metepugu nehanaꞌa yaꞌma eneleꞌmo fana talinaꞌmu yabe. To ai fulu kapogu leleꞌmoto bilinaꞌmu yabe. Sekalaiyau ya luto nama luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","To ana panaꞌi hofa toloto gufaꞌamo hiti mehaꞌamo hiti amuya moloꞌehina. Ai ka melugu minoꞌehina kanagu baga ilenogo Isilaeli bonaꞌi enubuꞌanilo huto huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yaꞌmana yupahi Sisa Ogasitasi ai Lomu gihiti bouba asaga boanatoga enigiꞌani liloto leka salube luto kaga mololoto lenigi lilube luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yaꞌmana enigi lise kana yataꞌa Sailiniasi ai gamani bouba Silia melugu bonaꞌmagihi kaba boꞌani minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Asaga boanaꞌi enigiꞌani liluneꞌmu nehite hepaꞌanilo bila bila hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe ai Tebitihi nagaluguti oꞌehina. Ya higo ai Nasalete hepato Galili kegiꞌati heꞌmito gihiti bo Tebiti ana hepato itoꞌafu ketoꞌehinaꞌa yaꞌma Yutia melugu buꞌehina. Ana hepaꞌi giꞌa Betelehe yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ai giꞌa hiti to aꞌi giꞌa lilubeꞌmu Malia noleꞌmoto biꞌahaꞌina. Yaꞌma aꞌmo Yosefeu alihi lihaꞌa lilina aꞌi yabe. To Malia ai yagapanaꞌmu hiti huꞌehigo biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betelehe hepato bite nehaꞌigo Maliau yagapanaꞌi ketalina kanaꞌa leba tago huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","To ai yagapanaꞌi yegeꞌa panaꞌi ketotoꞌa katatu sa gi etoloto bulumaka yagamagi noseꞌna nenana sepekeꞌnagu ko etoꞌehina. To etali yaꞌma yagamagihi nohaꞌanigu mineꞌahaꞌina. To henaꞌmugope, bonaꞌi kose nohi bai to su hoꞌehinagi anagu metiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","To yaꞌmana yupahi ana hepato sipisipi yaga kabalo bo enali fegutoga yaga kaba hite sininugu mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","To Huꞌmamofihi ageloꞌa ana yaga kabalo bo nehanalo Sipi Bomofihi fana mehenaꞌa hiti nehetigo enali ana sipisipi yaga kabalo bo lusina hite koli hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ya hite koli nehago agelouba ma luto lu epiꞌehina: Koli mehite kehelilo. Nani hetofa kaga lenalitoga ito noo lepolona yaꞌmana kagauba asaga boanaꞌi eneleꞌmo sipi enofokehi halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yatai sininugu Tebitihi hepalugu aꞌi moneuba panaꞌi mone ketoꞌehibe. Ai yaꞌmana bouba laliꞌi leleꞌmo kosaba huto lenubuto bilinaꞌmu yabe. Ai sipi bo Yesu Kilisito yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","To bu galanaꞌaya ma huto hilinamo niꞌibe. Lenali panaꞌi mone katatu sa gite bulumakamagi noseꞌna nenana sepekeꞌnagu ko etago nohinogo bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kaga agelouba lu epi su nohago ana bagaꞌa hiti babu agelomagi kokulumaluguti eteꞌani Huꞌmamofitoga fokehi hete nama ma lite liꞌahana: ");
INSERT INTO bef_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ifo muyagu Huꞌmamofihi giꞌa leꞌmo saga hite mineno. To melugu bonaꞌmagi kumu Huꞌmau ipaꞌagu ai laga besinana enalitoga fuluna hu noepalabe. ");
INSERT INTO bef_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","To agelomagi heꞌmi epelete kokulumalugu nebagomo enali ma lite ai lu emigo ai lu emigo hite liꞌahana: Ho tilo. Betelehe hepato butoti yaꞌmana huto hinana Sipi Bouba lu limiꞌehinana yaꞌma bu galune liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","To enali ho tite hololu lite bite Malianogo Yosefenogo nehaꞌinalo henetite bu gelete to panaꞌi bulumaka noseꞌna sepekeꞌnagu koꞌehigo bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Enali ana panaꞌi bu gelete Malianogo Yosefenogo agelouba yaꞌmana pana kumu lu epiꞌehinana kaga lu etimiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","To asaga bonaꞌi sipisipi yaga kabalo bomagi lana ka akeheli su helete ana pana kumu topa hete enekesa yigi babu liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","To ya huꞌehinamoya Maliau asaga ka ipaꞌagu li mololoto ekesa yigito legeso huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","To sipisipi yaga kabalo bomagi i gelehe hite heꞌmite bite Huꞌmamofihi giꞌa liyafa hite fokehi heꞌahana. Enali asagaꞌna agelouba lu epinana huto su hana bu geteꞌani sipi enofokehi heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Alihi nayahi mone kegiꞌa su hoto mone kegiꞌati loegi monegi heleko malago kana minelete ana panaꞌmofihi gufaꞌa laga nehite gi Yesu lite meleꞌahana. Koyapaꞌi ai itoꞌafihi ipaꞌagu huto mehuꞌehigo agelouba yamana gi hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Itoꞌafinogo afoꞌafinogo panaꞌanogo mono nagamitu okala hi etatalana kanaꞌa huꞌehina ana legitana koyapaꞌi Moseu keya kaga moloꞌehina suhi lite hiꞌahaꞌina. Yaꞌmu itoꞌafugo afoꞌafugo ana panaꞌi leꞌmete bite Yelusale hepato Sipi Bomofihi emiluꞌibeꞌmu biꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Manana Sipi Bomofihi keya kagaꞌalo fayanugu geꞌahana: Asaga yege panaꞌi huto hinamo Sipi Bomofitoga leꞌmete bite lepilata hilo. Etali yaꞌma kagamofihi keheli emiꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Etali ana hite Huꞌmamofihi fokehi hete lokiya fi emiluꞌibeꞌmu hiti biꞌahaꞌina. To Sipi Bomofihi keya kagauba luꞌehinaꞌa huto: Loemo yataꞌa kigopafi to loemo kigopa gapaꞌa hiti Huꞌma kumu keye lite emilo luto geꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","To yalo bo mone Yelusale hepato minoꞌehina giꞌa Simioni yabe. To aiya bati huse bo to Huꞌmamofihi agoya hu emise bo yabe. Ai Isilaeli bonaꞌmagi enubuto bilina boꞌmu geba huto minoꞌehina. To Sikalafuꞌi hiti Simionitoga minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sikalafuꞌuba Simionitoga alu emiꞌehina mefilise nohitogo Huꞌmau leꞌmo ho tiꞌehina bo, yaꞌma Mesiau huto hilibe luꞌehina bu goloto fililataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","To Simionihi Sikalafuꞌuba leꞌmo kapo malago sipi mono nonugu titoꞌa Malianogo Yosefenogo to ana panaꞌi Yesuhi keya kagauba luꞌehina suhi hu etaluꞌibeꞌmu nehaꞌigo bu enogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioniu ai ana panaꞌi yahi komopaꞌalo leꞌmo mololotoꞌa Huꞌmamofitoga fokehi hoto ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Oho. Sipi Bo. Yatai yaꞌma liliꞌnalo panaka heꞌmi etetogo fulunagu bino. Ya hitogo nipaꞌni koyapaꞌi kaga lu moloꞌahataꞌa huto fuluna nebesilibe. ");
INSERT INTO bef_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","To nani nubuꞌniuba anaꞌina lubuto bilatana lolo hatamoya bu nogabe. ");
INSERT INTO bef_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Yaꞌmanana kai asaga noto noto boanaꞌmagi enubulo leꞌmo lele huꞌahane. ");
INSERT INTO bef_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ai libiꞌmo moneuba fegutoga bonatoga metepunagu nehilana bonatoga eneleꞌmo besa lalibe. To ai Isilaeli boanaka enigiꞌa leꞌmo sipi hilinaꞌmu yabe. Simioniu ya luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Etali Yesuhi itoꞌafugo afoꞌafugo Simioniu Yesu kumu lina kalo etegekesa yigi babu liꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioniu lusa gi etimito ma luto panaꞌmofihi itoꞌafitogo Malia lu emiꞌehina: Kehelibo. Ma panaꞌi ai babu Isilaeli bonaꞌi lugaꞌa eneleꞌmo melugu malalinaꞌmu yabe. To ai ana huto babu bonaꞌi lugaꞌa eneleꞌmo ho tilinaꞌmu yabe. To ai Huꞌmamofitogati mone babeyafaꞌa legi huto huto minalinaꞌmu yabe. Analoꞌi babu bonaꞌmagi ka sibinaꞌa li etalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ya hinogo babu bonaꞌmagi enekesa yigiseꞌnaꞌani hutoꞌi minalibe. To mone kosa kosa emitauba ana legitana lutumopakagu fi fulu tilibe. ");
INSERT INTO bef_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","To Huꞌmamofihi kaꞌa leliꞌali aꞌi mone minoꞌehina, giꞌa Ana. Ai afoꞌafihi giꞌa Fanueli, yaꞌma bo Ase nagaluguti oꞌehina. To Ana aiya litanaꞌi koyapaꞌi bo lito bahaꞌa hiti nayahi mone kegiꞌa su hago mone kegiꞌati loemo heleko malago kufu mineꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Alihi bahaꞌa fililago ai faꞌmene minoꞌehina. To yatai kufuꞌa 84 nominabe ya nohutoꞌa sipi mono nohi hepato menoheꞌmina litanaꞌi yabe. To ai noseꞌnamofihi mo sito to nunumu huto minoto Huꞌmamofihi yege fito to mono liliꞌnaꞌa fuliga hiti foluguꞌi hiti lito minolata huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","To yana kanaꞌagu ai enali nehanalo henetitoꞌa Huꞌmamofihi fokehi hoꞌehina. To ai yaꞌmana panaꞌmofihi huto huꞌehina kagaꞌa asaga bonaꞌi Huꞌma kumuꞌi Yelusale hepaꞌi oto akuꞌi lilinaꞌmu geba hiꞌahana bonaꞌi lu epiꞌehina: Ma panaꞌuba lali hepati, Yelusale yaꞌma leꞌmo bati hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Etali asagaꞌna Sipi Bomofihi keya kaꞌauba luꞌehinaꞌa hi su helete i behe hite Galili melugu hepaꞌani Nasalete biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","To ana panaꞌi olopa hoto amuya bo minotoꞌa keheliseꞌnaꞌa hetofana babu luto minago Huꞌma lusa giseꞌnauba ai hiti minolata huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Asaga kufu kanagu Yesuhi itoꞌafugo afoꞌafugo bonaꞌi Yelusale hepato li nupa hilata hanalo bilata hiꞌahaꞌina. Koyapaꞌi Huꞌmau lubuto buꞌehinaꞌa kumu Pasa yabe nelana yaꞌma sipi noseꞌna nalata, yanaꞌmu biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuhi kufuꞌa 12 niꞌinamo enali ananalo bilata yaꞌma asaga kufu kana Yelusale hepato mono noseꞌna naluneꞌmu hite moneko kumu biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yaꞌmana sipi noseꞌna nalatamofihi kana su hago enali i behe hite hepaꞌaniga biluneꞌmu kapo melete hapi fiꞌahana. To ana panaꞌi Yesu, ai Yelusale minoꞌehina. Itoꞌafugo afoꞌafugo ya huto Yelusale minabeꞌa mekeheliꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Etali ma lite etegekesa yigi ahaꞌina: Ai lugaꞌa bonaꞌi hiti alihi noabe lite yaꞌma yupahi moneꞌa kapo meleꞌahana. To alihi etali hapi fite bonaꞌatitimagihi folagahaꞌanigu sa sa hiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Etali bu megeteꞌatiti akuꞌi Yelusale sa sa hite biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","To kana loegi monegimogu sipi mono nonugu tite babafi bonaꞌi hiti kagaꞌanilo keheli minoto enoloka hoto nohigo leꞌmo huto hiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Asaga kaga kehelina bonaꞌmagi Yesu keheliseꞌnaꞌamu to enali loka hana kaga lu epinaꞌamu topa hete enekesa yigi babu lite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Etali itoꞌafugo afoꞌafugo Yesuhi mono nonugu nohigo bu gelete topa hete ligo itoꞌafu kehe ito luꞌehina: Panaꞌni kai henabe luto yaꞌma suhi nohane? To kai ya hanogo leꞌali leꞌelesatiꞌa ligo kai kumuꞌi higo sa sa nohuꞌibe luto ligo, ");
INSERT INTO bef_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ai kagaꞌatitilo luꞌehina: Letali henabe lite nani kumuꞌi sa sa nehaꞌibe? Letali mekeheliꞌahaꞌifiye? Nani afoꞌnifihi nonugu ai kumu nohilunamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","To etali yaꞌmana kaga Yesu luꞌehinamofihi hapaꞌa keheli bebe meseꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ya hilete akuꞌi heꞌmito ago etali leꞌmete moneka Nasalete hepato biꞌahana. To kagaꞌatiti etabaga liyafa huto minoꞌehina yabe. To itoꞌafu asaga yaꞌmana kaga komopaꞌagu li moloto ai minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","To Yesu sipi bo hulago keheliseꞌnaꞌa hetofana huto minago melugu bonaꞌi hiti to Huꞌma hiti enali bu gana hapaꞌa bati huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sipi Lomu bo Taibiliasi 15 kufuꞌa kana kaba huꞌehinalo gamani bo Ponitiasi Pailati, ai Yutia melugu bonaꞌmagihi kohe toto kaba huto minoꞌehina. To yaꞌmana kanalo Heloti ai kohe toto Galili kegiꞌa sipi kaba bo minoꞌehina. To goꞌafu Filipi ai Itulia to Telekonaitisi kegiꞌa yataꞌa kaba bo minoꞌehina. To gamani bo Laiseniasi ai Abilini kegiꞌa kaba huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","To Anasiugo Kaiyafasiugo etali sipi mono nohi kabalo bole mineꞌahaꞌina. To yaꞌmana kanalo Sekalaiyahi panaꞌa Yoni ai ka melugu nohigo Huꞌmamofihi kaꞌa aitoga lu huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ya higo ai Yotani nagamiꞌmo kegiꞌa Huꞌmamofihi kagaꞌa leliꞌali huto boanaꞌi nehanalo lu yege ho epiꞌehina: Komopatini i gelehe hite foipanatinigati li heꞌmite nagami felelenogo Huꞌmau foipanatini li heꞌmi lepalalibe, luto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ai ya higo ana legitana lu huto huto bo mone Aisaiyau kaꞌa bukugu goꞌehina suhi huto ma niꞌibe: Ka melugu bo moneuba nogo moloto kehe sipi noibe: Sipi Bomofihi kapoꞌa leꞌmo lele hi etete to kapoꞌa leꞌmo fu lite li kosaba hi etalo. ");
INSERT INTO bef_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","To ya lenali asaga kemuya li hekini lo su hete moneko legege hu etalo. Ana hite kosa sipiꞌafi bohupoꞌafi li gofa hinogo limo i su halo. To asaga kapo kiyugu huꞌehina, leꞌmo bebe salo. To asaga kapo efahubago huꞌehina, leꞌmo bati hilo. ");
INSERT INTO bef_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","To asaga bonaꞌi Huꞌmau ai akuꞌi leleꞌmose lilinaꞌa bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","To babu boanaꞌi enali nagami falaluneꞌmu Yonitoga elago ai ma luto ana boanaꞌi lu epiꞌehina: Lenali laga mehina osifaꞌmofihi yagapanaꞌi yabe. Kuyuꞌafu lu lepinaꞌa hite Huꞌmamofihi ipakafa hilinamomuꞌi koli hite heꞌmite alihi huto hilinanalo be ligite biluneꞌmu nehabe? ");
INSERT INTO bef_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","To lenali foipanatiniguti i gelehe hilananaꞌmuko kehelite minalo. Ya hilenogo nelepilata bu galube. Lenalitiniguti ka mone lu ho tite Abalaha tatatifu yabe lite melilo. Lenali lenegekesa kehelite Abalahau kaba hu letalibe lite ya melilo. To nani lu nolepube. Huꞌmau ma efahi lito Abalahahi tataꞌafi lolo hilibe. ");
INSERT INTO bef_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","To sopoloꞌi hutoꞌi niꞌinagi yafa lufusaꞌa laga huseꞌna niꞌibe. Ya huꞌehinago asaga yafa legeyaꞌa mehalina hetigito logoguko falalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","To ai ya luto lu epilago boanaꞌmagi loka heꞌahana: Lali hena hilune? ");
INSERT INTO bef_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","To Yoniu ai kaꞌanilo luꞌehina: Bo moneuba gukete loemo liꞌohutomo mone kalalukafihi meniꞌilinamofihi emibo. To bo mone maka noseꞌna niꞌilina maka noseꞌnaꞌa meniꞌilina bo hiti guna ite naliyo. ");
INSERT INTO bef_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","To takisi lise bo moneꞌa hiti enali ana hite nagamiꞌi falaluneꞌmu eꞌahanati enali Yonihi loka heꞌahana: Tisao, lali hena hilune? ");
INSERT INTO bef_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","To Yoniu ai lu epiꞌehina: Lenali moni efahi gamaniuba luꞌehilina legege aloko lilo to mone li be ligite melilo. ");
INSERT INTO bef_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","To gimi bo moneꞌamagi ana hite loka heꞌahana: Lalimoya, lali ana huto hena hilune? To Yoniu lu epiꞌehina: Lenali faga lite ai goꞌna binogo ai goꞌna binogo hite fato fato bonaꞌi enehete faga lite ka foyagu eneleꞌme melete efahaꞌani meli epalalo. To lenali efahatini loko lilo. ");
INSERT INTO bef_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asaga boanaꞌmagi komopaꞌanigu keheli baga ite Yoni kumu ma lite keheliꞌahana: Huꞌmau leꞌmo ho tiꞌehina bo, ya Mesia aiꞌimomuꞌi nohifi lite enekesa yigi babu liteꞌani keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ya higo Yoniu kehelito ma luto lu epiꞌehina: Nani faꞌmene nagamituꞌi nofolo lepolobe. To alihi bo mone alina ai amuyaꞌauba naniꞌi nebe ligito amuyaꞌni hoto alinaꞌmu yabe. To naniya bati huto gigusa suꞌamofihi naga li heꞌmilunaꞌa huto meniꞌibe. To ai Hetofa Sikalafuꞌi lepilinaꞌa hiti to logoꞌa suhi huto mone hiti folo lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","To ai emuhaꞌa yanuga liꞌehibe. To kifi foyaꞌaguti lilina yabe. To ai noseꞌna yufagahaꞌa li nomalana nonugu li nupa huto li malalinaꞌmu yabe. To ya nohuto sibinaꞌa li nupa huto mesobose loba logogu galinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","To Yoniu asagaꞌi fato fato kaga boanaꞌi enekesa li hokolo huse kaga lu noepito Huꞌmamofihi kaꞌa lamanaꞌa lu yege hoto epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","To ya huꞌehina Yoni Helotihi yataꞌa gamani boꞌaniuba babu foipa faipana huto to Helotiu goꞌafihi lihaꞌa lito giꞌa Helotiasi aitoga huꞌehinanaꞌmu Yoniu yaꞌmanaꞌmu ka emekiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","To ya higo asaga ka Helotitoga Yoniu lina kaga molo emito italuga logo bigo mone hiti tiꞌehina foipanaꞌalo nagaꞌi emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asaga boanaꞌi nagami felete nehago to Yesu ana huto nagami fololoto nohuto nunumu nohigo kokulumaꞌi hokolo huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ya nohigo Sikalafuꞌi kigopa nama legitana huto aitoga nolimigo bu negago kokulumaluguti nogo moneuba ma luto luꞌehina: Kai nani panaꞌni yabe. Kai nibita huse panaꞌni nohane. Komopaꞌni kaitogago nokumube. ");
INSERT INTO bef_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu liliꞌna hapi fiꞌehina kanagu foya kanaꞌa 30 bulago hapi fiꞌehina. Enali Yosefehi panaꞌa yabe lite enegekesa keheliꞌahana. To Yosefe ai Hilai panaꞌa. Hilai ai panaꞌa Matati yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","To Matati ai Libaihi panaꞌa yabe. To Libai ai Melekaihi panaꞌa yabe. To Melekai ai Yanaihi panaꞌa yabe. To Yanai ai Yosefehi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","To Yosefe ai Matatiasihi panaꞌa yabe. To Matatiasi ai Emosihi panaꞌa yabe. To Emosi ai Nehamihi panaꞌa yabe. To Nehami ai Esilihi panaꞌa yabe. To Esili ai Nagaihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","To Nagai ai Meatihi panaꞌa yabe. To Meati ai Matatiasihi panaꞌa yabe. To Matatiasi ai Semenihi panaꞌa yabe. To Semeni ai Yosekihi panaꞌa yabe. To Yoseki ai Yotahi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","To Yota ai Yoananahi panaꞌa yabe. To Yoanana ai Lesahi panaꞌa yabe. To Lesa ai Selababelihi panaꞌa yabe. To Selababeli ai Sialitielihi panaꞌa yabe. To Sialitieli ai Nelaihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","To Nelai ai Melekaihi panaꞌa yabe. To Melekai ai Etaihi panaꞌa yabe. To Etai ai Kosamehi panaꞌa yabe. To Kosame ai Elemetamehi panaꞌa yabe. To Elemetame ai Elehi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","To Ele ai Yosuahi panaꞌa yabe. To Yosua ai Eliesahi panaꞌa yabe. To Eliesa ai Yolimihi panaꞌa yabe. To Yolimi ai Matatihi panaꞌa yabe. To Matati ai Libaihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","To Libai ai Simionihi panaꞌa yabe. To Simioni ai Yutahi panaꞌa yabe. To Yuta ai Yosefehi panaꞌa yabe. To Yosefe ai Yonamehi panaꞌa yabe. To Yoname ai Elaiyakimihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","To Elaiyakimi ai Meliahi panaꞌa yabe. To Melia ai Menahi panaꞌa yabe. To Mena ai Matatahi panaꞌa yabe. To Matata ai Netanihi panaꞌa yabe. Netani ai Tebitihi panaꞌa yabe. To Tebiti ai Yesihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","To Yesi ai Obetihi panaꞌa yabe. To Obeti ai Boasahi panaꞌa yabe. To Boasa ai Salamohi panaꞌa yabe. To Salamo ai Nasonihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","To Nasoni ai Aminatapehi panaꞌa yabe. To Aminatape ai Atiminihi panaꞌa yabe. To Atimini ai Anaihi panaꞌa yabe. To Anai ai Hesolonihi panaꞌa yabe. To Hesoloni ai Pelesihi panaꞌa yabe. To Pelesi ai Yutahi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","To Yuta ai Yakopuhi panaꞌa yabe. To Yakopu ai Isakahi panaꞌa yabe. To Isaka ai Abalahahi panaꞌa yabe. To Abalaha ai Telahi panaꞌa yabe. To Tela ai Nehohi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","To Neho ai Selagahi panaꞌa yabe. To Selaga ai Liyuhi panaꞌa yabe. To Liyu ai Pelekehi panaꞌa yabe. To Peleke ai Ibahi panaꞌa yabe. To Iba ai Silahi panaꞌa yabe. To Sila ai Kenihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","To Keni ai Afakasatihi panaꞌa yabe. To Afakasati ai Semihi panaꞌa yabe. To Semi ai Noahi panaꞌa yabe. To Noa ai Lemekihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","To Lemeki ai Metusalahi panaꞌa yabe. To Metusala ai Inokihi panaꞌa yabe. To Inoki ai Yeletihi panaꞌa yabe. To Yeleti ai Mahalalihi panaꞌa yabe. To Mahalali ai Kenanihi panaꞌa yabe. To Kenani ai Inosihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","To Inosi ai Setihi panaꞌa yabe. To Seti ai Ataha panaꞌa yabe. To Atau ai Huꞌmamofihi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sikalafuꞌuba Yesutoga bai tago Yota nagamiꞌi heꞌmito nobigo Sikalafuꞌuba bonaꞌi menehana ka melugu leꞌmoto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesu yaꞌma ka melugu 40 yegegu su hago nohigo Satau Yesutoga fi taga hu etoꞌehina. Ya higo Yesu ana kanagu noseꞌna menose mo sito minoꞌehina. To asaga yaꞌmana kanamo su hago Yesuhi kauꞌna hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","To kauꞌna nohago Satau Yesutoga nehetito ma luto lu emiꞌehina: To kai Huꞌmamofihi panaꞌa nohutomo ma efahi lu emitogo noseꞌna lolo hino. ");
INSERT INTO bef_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu Sataha kalo nonaꞌa ma luto lu emiꞌehina: Mono kauba ma nolibe. Bonaꞌmagi noseꞌna nenana suhi anasi minalanaꞌa meniꞌibe. Huꞌmamofihi kaꞌa kehelite minalanaꞌa huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","To Satau Yesuhi ifoꞌalo leꞌmoto tito meleꞌisi asaga hepaꞌmo bonaꞌmagihi nagaꞌi lepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","To Satau Yesuhi ma luto lu emiꞌehina: Yaꞌma bu nogata hepato bonaꞌmagihi sipi boꞌani keleꞌmo ho tinogo kigika sipi hilibe. To yaꞌmana yaga foya asagaꞌi kimilunaꞌmu yabe. To asaga yaꞌmana nanitoga oꞌehinana ninaya bo moneꞌmofihi emilube liluna emilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","To kai yatai kalapusa nohi fito nigiꞌni liyafa hilata yaꞌma ya huletogo asagaꞌna kaiꞌnaka lolo hilube. ");
INSERT INTO bef_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","To Yesu ana kalo ma luto ka emekiꞌehina: Mono kalugu ma huto niꞌibe. Kai Sipi Bo Huꞌmamofihi giꞌa liyafa hubo. To aigo ka kehelise emibo. ");
INSERT INTO bef_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","To yaloti heꞌmito Yelusale mono nohi latahaꞌalo Satau Yesuhi leꞌmoto tiloto ma luto lu emiꞌehina: Kai Huꞌmamofihi panaꞌa nohutomo malo ho tiꞌohuto lehe kolago melugu limibo. ");
INSERT INTO bef_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","To mono kagu mone ma luto niꞌibe. Huꞌmau ai ageloꞌa enoho lifinogo limite kaba hu bati hi ketalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","To enali kayato linogo efahuba kigigusagu mefilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu kaꞌalo ma luto lu emiꞌehina: Kaga ma huto niꞌibe. Kai Sipi Boka Huꞌmamofihi fi taga mehu etobo. Ai Sipi Bokafu nohibe. ");
INSERT INTO bef_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","To Satau asaga kaga luto miꞌi molo su holoto heꞌmito buto fato kana geba huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu Galili hepatoga i gelehe huto nobigo Hetofa Sikalafuꞌmofihi amuyanaꞌauba ai hiti buꞌehina yabe. To ai huꞌehinanamofihi kagaꞌa asaga hepatoga bu baga iꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu asaga boanaꞌi mono nohaꞌanigu kaga lu epilata higo enali fokehi heteꞌani giꞌa liyafa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu Nasalete buꞌehina. Koyapaꞌi ai yagapanaꞌi nohuto yaꞌmana hepato nohuto hofa toto olopa huꞌehina. To ai fuli kanagu asaga hulata nohinaꞌa hapaꞌa huto mono nonugu Huꞌmamofihi kaꞌa lu epilubeꞌmu tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","To enali mono lu huto huto bo Aisaiyahi bukuꞌa ite ete emiꞌahana. Ya nehago ai aho tito ana buku fokoloto ka mone ma luto niꞌinaꞌmu sa huto leka soꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Sipi Bomofihi mehaꞌa nani hiti niꞌibe. Ai ka lamanaꞌa fenoꞌhaꞌani menina bonatoga leliꞌali hubo luto neleꞌmo ho tiꞌehina yabe. Ai kaga yaꞌma luto lubo luto noho lifiꞌehina yabe. Lenali nagaꞌi liꞌahana bonaꞌi heꞌmite faꞌmene bilo. Lenali lenubu metepu iꞌehina bonaꞌi lenubutini i fana talibe. To lenali sipi ketana liꞌahana bonaꞌi bati hite minalabe. ");
INSERT INTO bef_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","To bonaꞌa kosabaꞌi eneleꞌmo malalina kanaꞌa lu yege hobo luto ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ana buku akuꞌi li kefigito kaba bomofihi emiloto melugu minoꞌehina. Asaga bonaꞌi mono nonugu mineꞌahana Yesunogo buluꞌi heꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","To ai kaga luto lu epiꞌehina: Yaꞌma mono ka lenali keheliꞌahago leka soꞌohuna yatai huto nohibe nolube. ");
INSERT INTO bef_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","To enali giꞌa liyafa hilete kaga hetofana bagaꞌaguti linaꞌmu enekesa yigi babu liꞌahana. Ya hileteꞌani enali liꞌahana: Ma bose, yaꞌmana panaꞌiba Yosefehe panaꞌmo nohifi fato panaꞌi nohibe? ");
INSERT INTO bef_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","To ya nelago Yesu lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Lenali fono ka mone ma lite nanitoga lilanaꞌmu yabe: Lusa bo kaika kugufaka leꞌmo bati hubo. To kai koyapaꞌi Kapaneami hepato huꞌahatana lali keheliꞌohutana yatai ana huto hepakalo ana suhi hubo lite li netalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","To ai ya luto lu noepito luꞌehina: Nani lusiga luto lu nolepube. To mono ka lu yege hose bomofihi hepaꞌalo bonaꞌmagi kaꞌa keheli meemilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","To nani lusiga lu nolepube. Koyapaꞌi Huꞌmamofihi kaꞌa lu yege hose boti Elaiyaha kanaꞌagu keto anaꞌi Isilaeli kapogu babu lite mineꞌahana yabe. Yaꞌmana kanagu sopohi hekini melose to koꞌi hiti meigo asagaꞌna hosopa igo yege yege bonaꞌi kauꞌna sipi hete kufu loebe monebe to ikahi nayahi mone kegiꞌa leke hago asaga hepatoga mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ya huꞌehinaya Huꞌmau ai Elaiyahi ho lifigo Isilaeli anatoga mone mebuꞌehina. Ai fato melugu Salefate, Saitoni kapogu nina hepato keto aꞌi mone bahaꞌa fililago nohinalo buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","To ana huto mono bo Elaisaha kanaꞌalo enehepuhi nolana bonaꞌi babu lite Isilaeli kapogu mineꞌahana yabe. To ya hite mineꞌahanaya mone folagahaꞌaniguti bo mone leꞌmo bati mehuꞌehina. To Neamani ai Silia melugu bo yagi aigo leꞌmo bati huꞌehina yabe luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To asaga bonaꞌi mono nonugu mineꞌahana ana kaꞌa kehelilete enitaluga lusina huto logo biꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Enali enitaluga logo bigo ho tite Yesuhi yato lite hepaluguti fegutoga leꞌmo heꞌmiꞌahana. Ya mana hepaꞌani kosagu minoꞌehina. Ya huꞌehigo yaꞌmana kosa beletoga leꞌmete bite yabalugu heꞌmi etelago limiluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","To ya hite, lusina hite haluneꞌmu hanamoya ai faꞌmene folagahaꞌanigu kapo moloto abufa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu Kapaneami hepato Galili kegiꞌa limiꞌehina ya huto fuli kanagu boanaꞌi kaga enelepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","To enali kaga enelepiseꞌnaꞌamu kehelilete topa hete ho tiꞌahana. Henaꞌmube? To Yesuhi kaꞌa amuyaꞌa hiti niꞌigo yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","To mono nonugu bo mone minoꞌehina aitoga komopaꞌagu laga mehina foipa felemo minoꞌehina. Ai nogoꞌauba ka mone sipi kehe ito luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Oho, Yesuo, Nasalete bo. Kai hena hu letalubeꞌmu noane? Nekesa noyuguna kai laliꞌi leleꞌmo sibina hilubeꞌmu noapiye? Kai nani akeheliꞌohuna bomo nohane. Kai Huꞌmamofihi fana mehe boꞌamo nohane. ");
INSERT INTO bef_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ya ligo Yesu ana foipa felemofihi ka emekito lu emiꞌehina: Kai kaga nolata kabaga li sumu kito yaꞌma bo heꞌmi etobo. To asaga enubuꞌanilo yaꞌmana foipa fele komopaꞌagu nohinana ana boti heꞌmi etoto nobuto leꞌmo felu hago buto koꞌehina mone gufaꞌa leꞌmo sibina hula ya hula mehuꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","To asaga bonaꞌi ananalo yege fite minana bu gelete enelesaꞌani ligo ai lu emigo ai lu emigo hite liꞌahana yabe: Yaꞌma henamofihi kaga nolibe? Ai foipa felemofihi enikibina bomagifi to lusi amuya bomagi nelanaꞌa huto ka tugoꞌi ho nolifigo bomofihi gufaꞌaguti heleko limito nobibe lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","To Yesu li huto hinanamofihi kagaꞌa leliꞌali yana kegiꞌa hago sipi huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu yaꞌmana sipi mono nohi heꞌmiloto Simonihi nonuga tiꞌehina. Simonihi lihaꞌamofihi itoꞌafihi gufaꞌa mukoho akoho gofana lito nohigo laluꞌafu Yesu heꞌmalibe lite kehe iꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu ai ana aꞌmo koꞌehinalo buto ho tiloto ana nobesinanamofihi ka emekiꞌehina yabe. Ya higo ana nobesinana heꞌmi etoto nobigo analo meleꞌisi ana aꞌuba ho tiloto noseꞌna leꞌmo lele huto epila epila huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","To yege alimi falalubeꞌmu nohigo babu bonaꞌi enalaluꞌanigihi fato fatoꞌna enebesiꞌehina eneleꞌmete Yesu nohinalo elago ai moneko monekoꞌisi enugufalo yahi ligo enebesiseꞌna akuꞌi felele hu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","To foipa felemagi babu boanaꞌmagitoga mineꞌahanana Yesu eneleꞌmo heꞌmi su hoꞌehina. Ya nohigo ana foipa felemagi sipi ka kehe ite liꞌahana: Kai Huꞌmamofihi panaꞌa yabe. To ya nelago Yesu ka epekigo enali akuꞌi kaga melise biꞌahana. To henaꞌmube? Enali Yesu Huꞌmau leꞌmo ho tiꞌehina bo yabe lite akeheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Etehi foluguꞌi ana hepaꞌi heꞌmiloto bonaꞌi menehana hepaꞌi mone niꞌinalo buꞌehina. Ya hulago boanaꞌi enali ai kumuꞌi sa sa hite biꞌahana. To ya hite enali fatoga heꞌmi epoloto mebilibe lite leꞌmo meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ya nehago ai lu epiꞌehina: Nani ana huto Huꞌmamofihi kapoꞌa kumu ka lamanaꞌa fato hepaꞌmolo hiti buto lu epilunamo niꞌibe. To lenaligo mone menehabe. Huꞌmau ai yaꞌmana foya libo luto noho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ya luto kaga lu epiloto ai Yutia kapogu buto mono nonugu tito ka lamanaꞌa lu yege hoto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mone yupahi Yesu Genesalete hefupomofihi kehetoga ho tiloto nohigo Huꞌmamofihi kaꞌa kehelilune lite ai nohinalo babu bonaꞌi ikini ikini hite eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ya nehago ai bu golago binaga boti loemo nagami beletoga netiꞌigo bu goꞌehina yabe. To ana botilo bomagi enali faya gutalafaꞌani okala hiluneꞌmu botiguti aleke he malago yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu mone botigu tiꞌehina. Yaꞌmana boti Simonihi boti niꞌigo loka hago nagami folagahaꞌagu nesiꞌasi fitu fo moloꞌehina. Ya hulago Yesu botigu nohuto bonaꞌi kaga lu enelepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","To Yesu kaga lu epi su holoto Simonihi lu emito luꞌehina: Botika nesiꞌasi fitu fetogo nagami hefuhaꞌagu bulenogo kalalukagi hiti faya gutalafa lilago limilete melete halabe. ");
INSERT INTO bef_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoniu kaꞌalo luꞌehina: Sipi Bo, lali asagaꞌi yatai foluguꞌi faya gutalafa moloto nohunogo goꞌi luꞌehina mone nesiꞌa mehoꞌohuta yabe. Ya huꞌohutamo ninaya kai lata kemegeꞌi moloto faya gutalafa akuꞌi heꞌminogoꞌni limilibe. ");
INSERT INTO bef_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ya luto ligo enali baga liyafa hite faya gutalafaꞌani li heꞌmi etago limilago fayaꞌi ti bai telete i bili mo ite faya gutalafaꞌani i bolala iseꞌna huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ya higo enalaluꞌanigihi fato botigu nehanaꞌamo eneheꞌmalabe lite kehe iꞌahana. Enali ete loe sana sana botigu fayaꞌi li bai te su helago ana boti keta huloto nagamilugu maꞌasi limiseꞌna huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","To Simoni Pitau huto hinana bu goloto lapusa nohi Yesuhi bulo melugu minoto lapusa filoto luꞌehina. Sipi Bo, heꞌmi netoto abufa hubo. Nani bo foipaꞌa nohube, luto luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ai hiti to lugaꞌa enalaluꞌanigi hiti minana babu fayaꞌi linana bu gelete enelesa sipi luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebetihi loe panaꞌa Yemesiugo Yoniugo etali Simonihi laluꞌafugo etali ana hite etelesa luꞌehina. To ya hago Yesu Simonihi lu emiꞌehina: Koli mehubo. Yatai fayaꞌi kefefe hilata liliꞌnalo yaꞌma Huꞌmamofi kumu boanaꞌi kefefe hilata bo suhi huto leneleꞌmo ho tilube. ");
INSERT INTO bef_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ya luto kaga lulago enali boti nagami beletoga ite bite melelete asagaꞌna analo neheꞌmite Yesuhi megeꞌi lifite biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mone yupahi Yesu hepaꞌi monelugu nohigo bo mone sipi lepolosi hepuhaꞌauba gufaꞌalo bai toto minana bo minoꞌehina. To ai Yesuhi bu goloto okabagati lapusa nohi fito nunumu hu emito luꞌehina: Sipi Bo, kaikamo neleꞌmo gololo tilata bati huto niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu gufaꞌalo yahi mololoto luꞌehina: Nani yaꞌma bati huto gololo tilaneꞌmu nokehelube. Ya noligo analoꞌi meleꞌisi ana sipi lepolosi hepuhaꞌa i gololo tu etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ya hulago Yesu amuya moloto ekesa biꞌehina: Kai yaꞌma hunanamofihi bonaꞌi lu meepise kigi bito mono bo nohilinalo bitogo ai kugufaka beloloto bu kogolenogo kai kugufa gololo tinalo nonaꞌa tu lokiya fi emibo. To Mosehi kaꞌauba luꞌehinaꞌa huto yabe. Ya hitogo asaga bonaꞌi enali yatai agololo tiꞌahane lilabe. ");
INSERT INTO bef_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","To Yesu hinanamofihi kaꞌa asaga hepatoga bu baga ilago babu bonaꞌi kagaꞌa keheliluneꞌmu eꞌahana. To enebesiseꞌnaꞌani hiti li heꞌmi epalalibe lite aitoga eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ya huꞌehinaya ai asaga yupahi heꞌmiloto bonaꞌi menehana suguna hinaluga buto nunumu hulata huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mone yupahi Yesu boanaꞌi kaga lu epita minanalo keya ka tisa bo to Felosi bo mineꞌahana. Enali asaga hepatoti Galili to Yutia kapoguti to Yelusale hepatoti eꞌahana. To Huꞌmamofihi amuyaꞌauba Yesu hiti minago enebesise bonaꞌi eneleꞌmo bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","To bonaꞌi lugaꞌamagi bo mone felisaꞌa asagaꞌi filiꞌehina bo sipalo leꞌme melete kofite eꞌahana. Enali nonuga leꞌmete tite Yesu nohina bufasilo malaluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","To babu boanaꞌmagi kapo i hekini lete minago enali ana besise bo leꞌmete nonuga tilana kapoꞌmu sa sa hiꞌahana. To enali nohupitalo leꞌmete tilete hokolo kapo mone lolo hiꞌahana li hokolo hilete ana kapoguti ana bo sipaꞌa hiti heꞌmi etago babu boanaꞌmagi folagahaꞌanigu Yesu nohinalo limiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","To Yesu ai komopaꞌanigu keheli amuya meleꞌahanamofihi bu goloto luꞌehina: Nalaluꞌniga foipanaka ali noheꞌmi ketobe. ");
INSERT INTO bef_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To keya ka enelepise bonaꞌi to Felosi bonaꞌi Yesu hinana bu gelete kaga ai lu emigo ai lu emigo hite liꞌahana: Yaꞌma bo kuyuꞌafu Huꞌmamofihi bulo keleꞌme ka nolu etabe? To bo moneuba foipanaꞌani li meheꞌmi epalalinaꞌmu yabe. To Huꞌma aisigo ya hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kaga nelana akeheliloto lu epiꞌehina: Henabe lite lenali lenekesagu kaga fato fatoꞌi lenipaguti notibe? ");
INSERT INTO bef_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","To hena kauba keta mehuꞌehibe? To foipanaka li noheꞌmube luna kauba keta mehuꞌehifi to kai ho tito kapo molobo luna kauba mehuꞌehibe? ");
INSERT INTO bef_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","To nani amuyaꞌni lenelepilubeꞌmu lu hokolo huto lu lepilube. Kokulumaguti limiꞌehina Bouba foipana li heꞌmilinamofihi ma melugu amuyaꞌa liꞌehibe. To gi yahi sibina huꞌehina bo lu emito luꞌehina: Nani lu nokumube, ho tito sipaka lito hepakaga bubo. ");
INSERT INTO bef_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ana baga hiti ana bo asaga bona enubulo ho tiloto koloto minoꞌehina sipaꞌa nolito Huꞌmamofihi fokehi homo homo huto hepaꞌaga buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","To asaga bonaꞌi topa hete afoya gofa ilete Huꞌmamofihi giꞌa li saga hite liꞌahana: Yatai fato huseꞌi hetofana bu gone lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Alihi Yesu kapo moloto buto bo mone takisi nolina ai giꞌa Libai yabe, ai takisi nonugu nohigo bu goloto ana bo lu emito luꞌehina: Kai nemegeꞌi moloto obo. ");
INSERT INTO bef_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","To Libaiu ho tiloto asagaꞌna analo noheꞌmito Yesuhi megeꞌi moloto buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Libaiu nohaꞌagu sipi noseꞌna Yesuhi go etago takisi nelina bo to bonaꞌi lugaꞌamagi hiti ete etali hiti minete noseꞌna neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","To Felosi bonaꞌi to keya kamofihi tisa bonaꞌi lugaꞌa enali ana nagaluguti Yesuhi koko panaꞌamagi lu epite liꞌahana: Lenali henabe lite takisi nelina bonaꞌi hiti to foipa bonaꞌi hiti noseꞌna nenabe? ");
INSERT INTO bef_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","To Yesu kaꞌani akeheliloto lu epiꞌehina: To bonaꞌi meepesina bonaꞌi tota bologa menebabe. To enebesina bonalogo tota bologa bulata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nani bonaꞌi foipanaꞌani menelina bonaꞌi eneleꞌmo bati hilubeꞌmu meoꞌohuna yabe. Oꞌe. Nani foipa bonaꞌi kehe inogoꞌni komopaꞌani i gelehe hise nehanamagi enali kumu oto enubuto bilunaꞌmu yabe, Yesu ya luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bonaꞌi moneꞌamagi Yesutoga ka liꞌahana: Yonihi koko panaꞌamagi noseꞌna mo site minete nunumu asaga yupahi nehabe. To ana hite Felosi bomagi koko panaꞌani ana suhi nehabe. To kai koko panakamagi noseꞌna noba noba nehite mo site menehabe. ");
INSERT INTO bef_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu lu epiꞌehina: Lenali bo moneuba lihaꞌa lilenogo ana aꞌmofihi bonaꞌa alana melekehi ite nose li mo silana niꞌifiye? Ana yupahi yaꞌmana bouba hiti nohinogo yana suhiba hilana niꞌifihe? Oꞌe, ya mehilanaꞌa huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ya huꞌehina alihi ana bo lihaꞌa lilubeꞌmu nohilina leꞌme neheꞌminogo enalaluꞌanigi hiti minomo mebilinaꞌmu yabe. To yaꞌmana kanaꞌalo hiti noseꞌna mo si ete mebilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu bame ka mone ma luto hiti lu epiꞌehina yabe. Bo moneuba yuhufa siotiꞌaloti ho hegege huto tafaꞌa sioti hokolo huꞌehilinalo hetilinaꞌa huto meniꞌibe. To ai ya hilina yuhufa siotiꞌa li sibina hilinaꞌmu yabe. To yaꞌmana yuhufa sioti lito tafaꞌa siotilo hetinauba legege mehibe. ");
INSERT INTO bef_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","To bo moneuba bai nagamiꞌi yuhufa lolo huꞌohuto lito koyapa sipisipi yagamofihi gufaꞌa konugu heki memalalinaꞌmu yabe. To ai ya hilina yuhufa bai nagamiꞌuba i kusu tito sipisipi yaga gufaꞌa kohi i polo tiloto bai nagamiꞌi i hekito melugu limi su halinaꞌmu yabe. To sipisipi yaga gufaꞌa kohiti i hegege hu su halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","To yuhufa bai nagamiꞌiya yuhufa sipisipi yaga gufaꞌa konugu limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","To bonaꞌmagi koyapa bai nagamiꞌi aꞌnelete akuꞌi yuhufa bai nagami kumu menoepesibe. To enali yaꞌma nelabe koyapa bai nagamiꞌi bati huto yabe nelanamo niꞌibe. Yesu ya luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","To Yesu fuli kana moneluguti nose foya yaꞌma laisi legeya tegina niꞌinagi folagahaꞌagu kapo moloto buꞌehina. Ya nohigo koko panaꞌa megeꞌi lifite nebanati legeya nesiꞌasi li laga hite enayanuga lilete li goso gusu ite nohaꞌa li neheꞌmite noseꞌnaꞌa neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","To Felosi bonaꞌi lugaꞌamagi bu gelete ma liꞌahana: Fuli yupapogu oꞌe liꞌahana supo lenali henaꞌmu ya nehabe? ");
INSERT INTO bef_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","To Yesu kaꞌanilo nonaꞌa ma luto luꞌehina: To lenali koyapa sipi bo Tebitiu huꞌehinanamofihi fayahaꞌa leka sete mekeheliꞌahafihe? Tebitiu laluꞌagi hiti sipi enakauꞌna loꞌehinamoꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ya nohigo ai Huꞌmamofihi nohaꞌagu tiloto Huꞌmamofihi bulo niꞌina beleti litoꞌa nonoto laluꞌagi megeꞌi ana noepito neꞌahana. To yaꞌmana beleti mono bonaꞌmagigo nelata nehabe. To fato fato bonaꞌi mo silabe. To ya huꞌehinamofihi kaꞌa leka sete mekeheliꞌahafiye? ");
INSERT INTO bef_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","To Yesu ai ma luto lu epiꞌehina: To nani Kokulumaguti limiꞌohuna Boya yaꞌma fuli yupapofihi sipi kaba bo nohube. ");
INSERT INTO bef_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mone fuli kanagu Yesu mono nonugu buto tito mono ka boanaꞌi lu epiꞌehina. Ya nohigo bo mone yahi lamagaꞌaga sibina huꞌehina bo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","To Felosi bonaꞌi hiti keya ka kehelise bonaꞌi hiti Yesuhi mapahi fite mineꞌahana. To enali fuli kanagu enebesise bonaꞌi eneleꞌmo bati hilifi to eneleꞌmo bati mehilifi lite mapahi fite mineꞌahana. To enali fisa iluneꞌmu ka foyagu Yesuhi leꞌmo malalana kapoꞌmu kaba hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","To Yesu alꞌa komopaꞌanigu abu goloto yahi sibina huꞌehina bomofihi ma luto lu emiꞌehina: Kai ho tito malo tobo. Ya noligo ana bo ho tito analo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","To Yesu ma luto lu epiꞌehina: Nani lenoloka nohobe. To keya kauba fuli kanagu hena hilo luto luꞌehinabe? To bonaꞌi eneheꞌmalo luꞌehifi to enahalo luꞌehibe? Leꞌmo bati hilo luꞌehifi to leꞌmo sibina hilo luꞌehibe? ");
INSERT INTO bef_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","To Yesu asaga bonaꞌi mono nonugu minananamagihi bu bego huto bu enogoloto ai ma luto yahi sibina huꞌehina bomofihi ma luto lu emiꞌehina: Kayahaka li su tobo. Ya ligo ana bouba yahaꞌa li su notago akuꞌi anaꞌasilo bati ahuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","To enali enitaluga logo bilago ai lu emigo ai lu emigo ma lite liꞌahana: Lali Yesuhi hena hu etalune? ");
INSERT INTO bef_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","To yaꞌmana yupahi Yesu nunumu hilubeꞌmu kosa monelugu tiloto Huꞌmamofitoga nunumu hu emiꞌehina. To nunumu huba huba nohigo sinihi gito goꞌi luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","To yege tilago koko panaꞌa kehe igo eꞌahana. To ai nayahi luga luga su hago to nigigusagati loemo heleko malago panaꞌaloboꞌa liloto aposolo bonaꞌi yabe luto enigiꞌani moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","To mone folagahaꞌanigu Simoniu yabe luto minoꞌehina giꞌa Yesu Pita yabe luto moloꞌehina. To Atulu ai Simonihi gonaꞌaya. To Yemesiugo Yoniugo to Filipiugo Batolomugo yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","To Matiuꞌugo to Tomasiugo. To Yemesi ai Alifiasihi panaꞌa. To Simoni ai fato giꞌa, amuya ka bo yabe, luto giꞌa minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","To Yutasi ai Yemesihi panaꞌa. To Yutasi Isikelioti ai alihaꞌa minoto Yesuhi fatehaꞌamagihi epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","To Yesu enali hiti limito meꞌi kuguma hinalo koko panaꞌa lugaꞌa hiti ho tiꞌahana. To babu boanaꞌi Yutia kegiꞌati to Yelusale hepatoti yagi to Taiya nagami beletoga bonaꞌi yagi to Saitoni hepato bonaꞌi ete mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","To enali enebesiseꞌnaꞌani li heꞌmilibe lite to ai kaꞌa hiti kehelilune lite eꞌahana yabe. To foipa feleuba enugufalo tiꞌehina bonaꞌi ete minago Yesu li heꞌmi epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","To asaga boanaꞌi Yesuhi gufaꞌalo enayatuꞌi meko liluneꞌmu hiꞌahana yabe. To henaꞌmube? To Yesuhi amuyaꞌauba buto asaga bonaꞌi eneleꞌmo bati higo ye keꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","To Yesu koko pananaꞌa bu enogoloto lu epiꞌehina: Lenofokehi hoseꞌna lenali feꞌnohatini meniꞌilina bomagitaloga mineno, to Huꞌmamofihi kapoꞌa hetofanaꞌa lenaliꞌna yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","To bonaꞌi lenali yatai kauꞌna nolenahana lenofokehi hete mineno. Alihi noseꞌna nelete lenumu hilinaꞌmu yabe. To lenali yibi yatai hite nehana bonaꞌi lenofokehi halo. To alihi lenali kiya hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","To bonaꞌmagi enipakafa lenehenogomo lenofokehi halo. To lenali Kokulumaguti limiꞌehina Bo megeꞌi nemelenogomo bonaꞌmagi lenipakafa halanamoꞌmu nolube. To enali leneleꞌmo heꞌmilana yabe. To ka foipaꞌa li lepalalabe. To lenigitini li sibina sabana hite halanaꞌmu yabe. To asaga yaꞌmana nehi lepelenogo lenali sipi lenofokehi halo. ");
INSERT INTO bef_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yaꞌmana huto nohinogomo kofokehi nohoto hele kolago tila limila nohuto melekehi ibo. To ya hilananamofihi minaꞌa kokulumalugu sipiꞌa mino lepalalinaꞌmu yabe. To koyapaꞌi tataꞌanigi yaꞌmana suhi mono lu yege hose bonatoga foipana hi epeleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ehe. Lenali feꞌnohatini babu lina bonaꞌise. Lenali bati huto minoseꞌnatini ali su heꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ehe. Bonaꞌi lenali noseꞌna yatai lenumu higo nete neminana alihaꞌa kauꞌna lenoho laligi. Ehe. Bonaꞌi lenali yatai kiya hite neminana kaba hilo. To lenali alihi sipi yibi hite lenubu nogoya limo ilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","To asaga bonaꞌi lenigitini li saga hilanamoya, ehe, kaba hite minalo. Koyapaꞌi tatatinigi ana suhi hite fagalo mono bomagitoga liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","To kaꞌni nekehelina bonaꞌi kehelilo. Fatehatini eneleꞌmo bati hilo. Lenipakafa nehalana bonaꞌi eneleꞌmo bati hite hetofanaguti kaga lu epilo. ");
INSERT INTO bef_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","To leneleꞌmo sibina hiluneꞌmu huli ka lu lepilana bonaꞌi bebe sana ka lu neepite ana hite ka lu sibina hi ketalana bonaꞌi eneheꞌmoto numuna hu epolobo. ");
INSERT INTO bef_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","To bo moneuba kabaga hapaꞌalo noinogomo mone kegiꞌa hu emitogo ino. To bo moneuba kefeka nolinogomo guketeka mone hiti li goli mehuto li anaga meletogo lino. ");
INSERT INTO bef_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","To bo moneuba kai anaꞌinakalo nimibo luto kehe ilina emibo. To bo moneuba anaꞌinaka gumina liꞌehinogomo amuya moloto ka emekito nasanaꞌani ito obo luto melubo. ");
INSERT INTO bef_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","To bonaꞌmagi suhi mone hu epalalube luto nokehelilata suhi kalalukagi enalitoga hubo. ");
INSERT INTO bef_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","To bo moneuba kaitoga ipaꞌa nokiminogo to kai ana bomofihi kipaꞌa ana huto emilata alihaꞌa hetofa bo nohube luto kofokehi lilifiye? To bo foipaꞌamagi hiti enipa epina bonaꞌmagi ana hite enipa epilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","To lenali bonaꞌi leneleꞌmo bati hana bonalogo eneleꞌmo bati hilata nehana henana manaꞌa huto hulata nohibe? To bo foipaꞌamagi hiti ana suhi ya hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","To kai anaꞌina bonaꞌi moneꞌmagitoga akuꞌi nonaꞌa nimilanalo yabe luto noepitanalo nonaꞌa hena huse hetofana lilata nohane? To foipa bomagi hiti foipa bologa anaꞌinaꞌani neepite ana babeyafa hinana nonaꞌa lilutamo yabe lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Oꞌe. Lenali fatehatini eneleꞌmo bati hilo. Ya nehite anaꞌina lepilanalo akuꞌi nonaꞌa limilabe lite melilo. To lenali ya hite minalana alihaꞌa lenali minaꞌa sipi lilete Sipi Bo Huꞌmamofihi pananaꞌa minalanaꞌmu yabe. To ai ipaꞌa fokehi menehana bonaꞌi hiti to foipa bonaꞌi hiti noepito hetofana hu noepolobe. ");
INSERT INTO bef_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","To lenali ana hite Huꞌmau leneleꞌmo bati nohinaꞌa hite lenalalutinigihi eneleꞌmo bati hilo. ");
INSERT INTO bef_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Lenali bonaꞌi eneleꞌmo yegelo memelenogo Huꞌmau ana huto leneleꞌmo yegelo memalalibe. To lenali bonaꞌi enifisa fato fato meinogo ya hinogo Huꞌmau lenaliꞌi lenifisa fato meilibe. To lenali bonaꞌi foipanaꞌa hu lepololenogo li heꞌmilanaya Huꞌmau ana huto foipanatini li heꞌmito pa so lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","To lenali lenalalutinigihifi bonoho bofi nasana epilo ya hinogo Huꞌmau ana huto nasana lepilibe. To ya hinogo bonaꞌmagi leꞌmo bati hite guna i lepite lepi babu linogo bai toto i bili mo iseꞌna hinogo lepilabe. To bonaꞌi nasana neepina legegeꞌasilo Huꞌmau akuꞌi ana legegeꞌalo nasanatini lepilibe. ");
INSERT INTO bef_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu ma bame ka lu epiꞌehina: To bu sibina hina bo moneuba ana huto bu sibina huꞌehina bo mone yato lito buyu huto mebilinaꞌmu yabe. Ya hilinagi etali loe sana sana keligu limilaꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","To sukulu panaꞌi moneuba tisaꞌamofihi hoto meminolata nohibe. To ai sukulugu buloto lepise kanaꞌa su holenogo hulotoꞌa yaloꞌi tisaꞌa hiti moneko legege nehaꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","To kai hena hibe luto kefa fulupa kubugu nina bu megose kogonakamofihi bugu pehena nina bu nogane? ");
INSERT INTO bef_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","To kai hena huto kogonokamofihi ma luto lu emilatabe? Ke, nogonaꞌnimakabe, kubugu pehena nina bati huto li heꞌmi ketalufihe? To kaika kubugu kefa fulupa koꞌehilina bu megose ya lilataꞌmu yabe. To kai fagalo bo yataꞌa kai kubukagu niꞌilina kefa fulupa li heꞌmiloto alihi kogonakamofihi buguti pehena niꞌilina bu go fana toꞌohuto li heꞌmi etobo, luto Yesu bame ka lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","To hetofa yafauba legeyaꞌa sibina huto holata menohibe. To ana suhi huto yafa numutopaꞌa loꞌehinaꞌauba legeyaꞌa leꞌmo bati huto holata menohibe. ");
INSERT INTO bef_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","To bonaꞌmagi yataꞌa yafa legeyaꞌa loko be geleteꞌani ya uma yafa bati yafa yagi lila to yafa numutopaꞌa niꞌinagi lite be go kehelilata nehabe. To enali bonaꞌmagi nemuya legeyaꞌa ufehena nina nagatoti ligilata menehabe. To bai nagamiꞌi lolo nehana legeyaꞌa sibina huꞌehina yafa mone ufehi niꞌilinaloti ligilata menehabe. ");
INSERT INTO bef_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","To hetofa bo moneꞌmofihi ka keheliseꞌnaꞌa babu lito ipagu hetofana minolata nohibe. Ya huꞌehigo hetofa sunogo li huto hulata nohibe. To bo sibinaꞌamofihi ka bati mehinaꞌa babu lito ipaguti huto hulata nohibe. Ya nohigo bati mehina suhi li huto hulata nohibe. To yakaꞌmana kaga enipagu bai toto nominana enabagaguti tito bulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Lenali henabe luto kibina botimakase kibina botimakase lite nani kumu nelana akuꞌi kaꞌni heꞌmite kegeiyo hite neminabe? ");
INSERT INTO bef_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nani kaꞌni kehelito nominata bomo henana legita nohibe? Ai kaꞌni kehelito to akili mehuse nanitoga keheli nimito nominata bomo, henana legita nohibe? Nani lu lepilube. ");
INSERT INTO bef_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bo moneuba nohaꞌa gilubeꞌmu nohutoꞌa, lukesa keli iba iba huto ya ema kifito buto buto, to efahi huto nohinogomo lukesa filinaꞌmu yabe. Nohaꞌa ya huto ginogomo, alihi koꞌmo ito to nagamiꞌi holoto tito nopo giꞌehinalo bilito tiloto nohi tele mebilinaꞌmu yabe. Bati huto giꞌehina nopo niꞌigi, nagamiꞌuba ana nopo tele mebilinaꞌmu yabe. To nani kaꞌni kehelito agoya hu nimilata bouba, ai yaꞌma legita nohibe. ");
INSERT INTO bef_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","To akuꞌi bo moneuba kaꞌni kehelito to ana kaꞌni heꞌmito akili huto nominata bouba, ai yaꞌma legita nohibe. Bo moneuba noha ꞌa gilubeꞌmu nohutoꞌa, lukesa keli nesiꞌasi ito faꞌmene efapolo lukesa mefise nohaꞌa gilibe. Ya huto ginogomo, alihi koꞌmo ito to nagamiꞌi holoto tito nopo giꞌehinalo bilito tito ana nopo anaꞌasi, meleꞌisi tele bilinaꞌmu yabe. Nohi asagaꞌi gofana huto tele bi su halinaꞌmu yabe. Ai akili huto nominata bouba ai yaꞌma legita nohibe. Ai kaꞌni kehelito to ana kaꞌni heꞌmito akili huto nominata boube, yaꞌma legita nohibe. Yesu ya luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu asaga kaga boanaꞌmagihi lu epi su holoto Kapaneami hepaluga buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","To Lomu hepato gimi bomagihi kaba boꞌanimofihi koko panaꞌa mone minoꞌehina. Ya higo ana gimi boꞌauba ai hetofa panaꞌni yabe luto leꞌmo bati huꞌehina yatai ana koko panaꞌa sipina besito afiliseꞌna huꞌehinalo Yesu ana hepalugu henetiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ya higo gimi bomagihi sipi boꞌaniuba Yesu noabe lite lanaꞌa keheliloto Yuta mono bonaꞌi lugaꞌa Yesutoga koko panaꞌa oto lusa gi etenogo fa hu etalibe luto enoho lifigo biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","To enali Yesutoga enoho lifigo bana bonaꞌi Yesu nohinalo bilete enali amuya melete eniginaga fina ka lu emiꞌahana: Yaꞌma bo lalalutifube, ai hetofa bouba kai neheꞌmalane luto nolinaya bati huto heꞌmalata niꞌifiye? ");
INSERT INTO bef_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","To ai yaꞌmana bouba lali Yuta bonaꞌi leleꞌmo bati nohuto aiꞌa mono nohati mone gi letoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ya lago Yesu kaꞌani keheli epito ana bonaꞌi hiti moneka biꞌahana. To ana bomofihi nohi kasitoga lebatosi nebago laluꞌagihi enoho lifigo bite Yesuhi leꞌmo melete ma lite lu emiꞌahana: Sipi Bo kai kosele kahalibe. To nani bati bo menohunagi nohaꞌnigu kai metilane luto nokehelube. ");
INSERT INTO bef_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","To ana huto nani faꞌmene bo nohunago kaitoga mebilunaꞌa huto niꞌibe. To kai faꞌmene lusa kaꞌago litogo koko panaꞌni bati hilibe. ");
INSERT INTO bef_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","To henaꞌmube? Nani ana huto napa liꞌehina sipi bomofihi mahaꞌaluga nohugo liliꞌna nonimina yabe. To naniꞌni ana huto gimi boꞌni nehana nani namanuga ana hite nehabe. To nani mone keneꞌmofihi bubo luto nolugomo ai bulata nohibe. To mone fatoꞌamofihi obo luto nolugomo aꞌolata nohibe. To koko panaꞌnimofihi ya liliꞌna libo luto nolu etogomo ana liliꞌna lilata nohibe. Yaꞌmu kai lusa kaꞌago li molotogo koko panaꞌni leꞌmo bati hilibe. ");
INSERT INTO bef_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya luto ana bouba Yesuhi lu emilago Yesu ana kaꞌa keheliloto ekesa yigi babu lu emiꞌehina. Ya huloto i gelehe huto boanaꞌi megeꞌi lefeliꞌali hana kaga ma luto lu epiꞌehina: Kehelilo. Nani lu nolepube, Isilaeli bo moneuba yaꞌma fegutoga bouba hinaꞌa huto komopaꞌa li nimito keheli uleꞌale huꞌehinaꞌa yaꞌma bu megolata nohube. ");
INSERT INTO bef_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","To gimi bomagihi kaba boꞌaniuba Yesuhi bite kapogu leꞌmotaga hite lu eminogo kaꞌasigo bagaguti lilibe ligo bana bonaꞌi akuꞌi notoga ete bu gana ana koko panaꞌa bati huto ye koꞌehigo bu geꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu nesiꞌasi minoloto akuꞌi heꞌmito Naini hepalugu buꞌehina. To ai koko pananaꞌa yagi to babu boanaꞌi hiti biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ya hite ana hepaꞌmofihi sipi gegisa he meleꞌahanalo buho netigo bo mone filiꞌehina yafa bite neete kene mala mala hepalugu biluneꞌmu nehabe. To ana filiꞌehina panaꞌi ya keto aꞌi mone bahaꞌa koyapaꞌi afililago moneꞌisi nohina panaꞌa filiꞌehigo yafa bite neago babu boanaꞌi ana hepaluguti yibi nama hite enemegeꞌi eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ya nehago Yesu ana panaꞌmofihi itoꞌafihi komopaꞌagu panaꞌamu luto sipi yibi huto hepuhi nolago ma luto lu emiꞌehina: Yibi mehubo. ");
INSERT INTO bef_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ya luloto Yesu i mobuto ana filiꞌehina panaꞌi koꞌehina sipaꞌalo bu leba toto yahi liꞌehina. Ya nohigo enali filise bo koꞌehina sipa liꞌahana bonaꞌi analo ho tite lilete nehago Yesu luꞌehina: Panaꞌise, nani lu nokumube, kai ho tibo. ");
INSERT INTO bef_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ya luto ligo, meleꞌisi ana baga hiti ana panaꞌi ho tito sipaꞌalo minoloto kaga hapi fito baga li aka huto luꞌehina. Ya nohigo ana panaꞌi itoꞌafihi emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ya higo asaga boanaꞌi anana bu gelete enelesaꞌani gofa ligo Huꞌmamofihi giꞌa li saga hite fokehi hete ma lite liꞌahana: Mono ka lu yege hose bo sipi mone folagahatigu huto nohibe. To Huꞌmau boanaꞌa eneheꞌmoto enubuto bilibe luto aꞌnoabe. ");
INSERT INTO bef_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya nelite Yesu hinanamofihi kaꞌa leliꞌali Yutia hepaluga nehago tili tele huto kapo beletoga bula ola huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yonihi koko panaꞌamagi yaꞌma kaga Yesu huto huꞌehinaꞌamuꞌi kehelite Yonitoga bite lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ai kehelito koko panaꞌa loemo kehe i bufalo mololoto etoho lifigo kaga mone lite bite Yesuhi loka haluꞌibeꞌmu biꞌahaꞌina. Kaiba Yoniu kaitoga alubeꞌmu nohina bomomuꞌi luto luꞌehinana nohapi to fato bona kumu geba hilune? ");
INSERT INTO bef_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To etali ana bole Yesutoga henetilete lu emiꞌahaꞌina. Leꞌali Yoniu nagami folo epolose bouba kaiꞌi ka mone ma lite loka haliyo ligo nooꞌibe. Kaiba alane luto luꞌehinaꞌa kegeba nohuta bomofi to fato bo geba hilune? ");
INSERT INTO bef_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","To yaꞌmana yupahi Yesu babu boanaꞌi fatoꞌna epesiꞌehina eneleꞌmo bati huꞌehina. To foipa fele babu lito komopaꞌanigu minoꞌehinana li heꞌmi epolo su hoꞌehina. To enubu mone kegiꞌa sipina huꞌehina bonaꞌi babu lito enubuꞌani akuꞌi li gili hu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To Yonihi koko panaꞌamaleꞌi ete loka hana kalo Yesu ma luto lu etimiꞌehina: Letali heꞌmite bite Yonihi letali bu negago lolo nohunana to letekesatu keheliꞌahaꞌinana lu emiliyo. To enubu sibina hina bonaꞌi i gili habe. To enigi enayahi foipa lana bonaꞌi kapo malabe. To hehe bonaꞌi eneleꞌmo gololo tugo babe. To negi bonaꞌi enekesa hokolo higo kaga kehelibe. To filiꞌahana bonaꞌi akuꞌi ya ho ti kosaba habe. To ana huto Huꞌmamofihi hetofa kaꞌa enumuhi menina bonaꞌmagi nekehelibe. ");
INSERT INTO bef_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","To bonaꞌi enali nani kumu enekesa keheli loe lae menehana bati hite enofokehi lite neminabe. ");
INSERT INTO bef_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ya luto Yesu kaga lu su holago Yonihi koko panaꞌa abilaꞌigo Yesu Yoni kumu kaga babu boanaꞌi lu epiꞌehina: Koyapaꞌi lenali bonaꞌi menehanalo ka melugu biꞌahana henana bu galune lite biꞌahanabe? To lenali akepa moneꞌmofihi habahuba li pisi huꞌehina bu galune litefiye? ");
INSERT INTO bef_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","To henana bu galune lite biꞌahanabe? To lenali bo moneuba hetofa gukete li hekoloto nohigo bu galune lite biꞌahanafiye? Nani lu nolepube. Enali bonaꞌi hetofa gukete li hekelete to hetofa enugufalo li melete neminana bonaꞌi ya enali gihiti bomofihi nohaꞌagu minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","To ya huꞌehina lu nimilo, lenali henanaya meyaga bu galune lite biꞌahana? To mono ka lu yege hose bofi? Oꞌyo, nani maꞌnaka luto lu nolepube. Ai lu yege hose bo nohibe. To ai asaga lugaꞌa mono bonaꞌi enohoto yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","To bo mone Yoni kumu mono kagu ma luto lulatamo niꞌibe: Mono kaꞌni leliꞌali boꞌni yaꞌma nohibe, luto Huꞌmau luloto, to nani yataꞌa aleꞌmo heꞌminogoꞌni ai kohe toto buto kapo li hokolo hu ketalibe. ");
INSERT INTO bef_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kaga molo emito luꞌehina: Nani lu nolepube. Yoniu ai asaga bonaꞌi melugu nehana enohoto nohibe. Ya huꞌehina bo mone Huꞌmamofihi bulo lagaso huto nohinauba ai Huꞌmamofihi kapoꞌalugu Yonihi be ligito nohibe, Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","To asaga boanaꞌi to takisi nelina bo enali asagaꞌi Yesu lina kaga kehelilete ma lite liꞌahana. Oꞌyo, Huꞌmamofihi hapaꞌa bati huto niꞌibe liꞌahana. To enali ya hite Huꞌmamofihi megeꞌi malago koyapaꞌi Yoni yanuga mone nagamiꞌi feleꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","To ya huꞌehina enali Felosi bonaꞌi to keya kaga babafi bonaꞌi enali Yonihi yanuga nagamiꞌi mefeleꞌahana. Yamomuꞌi lite enali Huꞌmamofihi kapo hetofaꞌa noenelepinamo enali enemegesa hu emite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","To Yesu luꞌehina: Nani yatai ma nehana boanaꞌi henanalo eneleꞌmo ho tilube? To enali hena huse bo nehabe? ");
INSERT INTO bef_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","To enali yagapanaꞌmagi suhi hite hepaꞌi folagahaꞌagu nehite fato yagapanaꞌi kehe ilete ma lite lu neepinaꞌa hite nehabe. Lali ufehi fi lepiꞌohutamo lenali kehe meiꞌahabe. To lali ana huto eniginaga fise yibi nama hutamo lenali yibi hilanaꞌa hite memineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","To Yoni oꞌehina noseꞌna nola to bai nagamiꞌi nola mehuꞌehina yabe. Ya nohigo lenali ma lite lu eteꞌahana yabe: Foipa fele ai komopaꞌagu niꞌibe lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","To yatai Kokulumaguti limiꞌehina Bo ai oloto noseꞌna noto nagamiꞌi noto nohigo to lenali ma lite neli etabe: Bu galo. Ai noseꞌna babu lito noba noba bo yabe nelabe. To bai nagamiꞌi ana huto babu lito noba noba bo yabe lite nelabe. To ai takisi nelina bo to foipa bonaꞌmagihi enalaluꞌanifu yabe lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","To bonaꞌmagi komopaꞌanigu keheliseꞌna hetofana niꞌifi sibina niꞌifi, luto hapaꞌani huto hulenogo bu galabe. ");
INSERT INTO bef_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To Felosi bo moneuba giꞌa Simoni yabe, ai Yesu nohaꞌaluga buto noseꞌna naluꞌibe luto kehe iꞌehina. To Yesu ai ana Felosi bomofihi nohaꞌaluga buto minoloto noseꞌna naluꞌibeꞌmu hiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ya nehaꞌigo ana hepato foipa aꞌi mone nominanati Yesu ya huto Felosi bomofihi nonugu noseꞌna nenaꞌibe lanaꞌa kaꞌa keheliꞌehina. Ya huloto ana aꞌuba efaha kohi mone hetofaꞌa liloto oꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","To ai buto Yesuhi megesaga ho tiloto gigusaluga minoto yibi huto minoꞌehina. Yibi nohigo bu nogoyauba Yesuhi gigusaꞌalo bili bili nohigo soso hu etoto latahaꞌalo yatama okaꞌatu li sepa i etoꞌehina yabe. Ya nohuto ai efaha konugu tu mesebe nina liꞌehinamo Yesuhi gigusaꞌalo hoto nonoto ana tu mesebe folo etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To ai Felosi bouba Yesuhi noseꞌna naluꞌibe luto kehe iꞌehina bouba ana aꞌuba hinana bu goloto ma huto ekesa yigiꞌehina yabe. Yaꞌma bo ai mana ka luto mono bomo nohutomo yaꞌma aꞌuba gufaꞌalo meko nohina hena huse aꞌi nohifi luto bu galibe luꞌehina yabe. To hena huse foipana lito nominafi luto ai lilibe. ");
INSERT INTO bef_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kaga lu saga huto luꞌehina: Simonio, nani kaga mone ya liꞌohuna lu kimilube. Simoniu luꞌehina: Babafio, kai alubo. ");
INSERT INTO bef_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ya ligo Yesu ma luꞌehina: Loe bomaleꞌi bo moneꞌmofitogati efahi hite liꞌahaꞌina yabe. Mone bouba loe yagi loe yagi mone yagi bonaꞌmagi enigi enayahi su hago kina moni liꞌehina yabe. To mone bouba nayahi luga luga su hago kina moneꞌisi liꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","To ana bomaleꞌi tinau moniꞌatiti meheꞌmilaꞌinaꞌa haꞌigo moni afoꞌafu ana moniꞌamu ekesa meyigise anaꞌa hilibe luto heꞌmiꞌehina yabe. To yaꞌmana bo loemaleꞌi kuyuꞌafu ipaꞌa ana moni etimina bomofihi fokehi hoto leꞌmo bati hilinabe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","To Simoniu Yesuhi kaꞌalo ma luto lu emiꞌehina: Nani nekesa noyuguna moni efahi sipiꞌa emiꞌehina bouba yabe luto luꞌehina. Ya ligo Yesu ma luto lu emiꞌehina: Kai bati huto lusiga lane. ");
INSERT INTO bef_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","To Yesu i behe huto ana aꞌi bu goloto Simonihi lu emiꞌehina: Ma aꞌi kai bu nogapiye? Nani kai nohakagu oto tugo nigiꞌnimofihi okala huse nagamiꞌi meniminogo ai yaꞌma aꞌuba bu nogoyaꞌatu nigigusaꞌni okala huloto okaꞌatuꞌi li sepa noi netabe. ");
INSERT INTO bef_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","To kai nebe metigiꞌahata aꞌnoane luto soso mehu netoꞌahane. Ya huꞌahata bu gobo, ai yaꞌma aꞌuba yuhufa nonugu notugo nigigusalo soso hu netoꞌehina analo ya huba huba nohibe. ");
INSERT INTO bef_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kai tu mesebetuꞌi okaꞌnigu mefolo netoꞌahata ai yaꞌma aꞌuba tu mesebetuꞌi nigigusaꞌnilo nofalabe. ");
INSERT INTO bef_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yatai nani lu nokumube. Nani yaꞌma aꞌmofihi babu foipanaꞌa asagaꞌi li noheꞌmi etoꞌohunogo ai nani kumu sipina nobesibe. To bo moneꞌmofihi Huꞌmau foipanaꞌa nesiꞌasi li heꞌmi etalina akuꞌi ana bouba nani kumuꞌi nesiꞌasi nobesibe. ");
INSERT INTO bef_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yalo Yesu ana aꞌmo ma luto lu emibe: Kai foipanaka a li noheꞌmi ketobe. ");
INSERT INTO bef_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ya ligo asaga bonaꞌi ai hiti hitalo minete enali kaga ma lite liꞌahana: Yaꞌma bo kiyiꞌafu fato fato bonaꞌmagihi foipanaꞌani li heꞌmi noepalabe? ya lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","To Yesu ana aꞌmofihi ma luto lu emiꞌehina: Kai agoyanaka nanitoga malalata yauba keleꞌmo bati nohinagi komopaka fulu hinogo kofokehi hoto hepakaga bubo, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Alihaꞌa nesiꞌa minoto Yesu sipi hepaꞌifi to lagaso hepaꞌi ninalo ninalo bula ola huto Huꞌmamofihi kapoꞌamofihi hetofa kagaꞌa boanaꞌi enalitoga lu epimofaꞌna huꞌehina yabe. To nayahi luga luga su hoto nigigusagati loemo heleko malago hite Yesuhi koko panaꞌa minana megeꞌi melete biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","To ana huto anaꞌi lugaꞌa Yesu enebesiseꞌnafi to foipa fele li heꞌmi epalana megeꞌi melete biꞌahana yabe. To analuguti moneya Maliau yabai Magatala hepalo aꞌi yabe lite giꞌa helata hana ailuguti koyapaꞌi Yesu foipa fele nayahi mone kegiꞌa su huto mone kegiꞌati loemo heleko malago li heꞌmi etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","To Yoana, Susahi lihaꞌa ai Helotihi nohaꞌalo kaba bomofihi lihaꞌa yagi to Susana to babu anaꞌi lugaꞌa hiti enali Yesu hiti to koko pananaꞌamagihi feꞌnohaꞌanilo eneheꞌma eneheꞌma hite biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Boanaꞌi hepato hepatoti Yesutoga eba eba hite ete babu lite li nupa hago Yesu yaꞌma bame ka mone ma luto lu epiꞌehina yabe: ");
INSERT INTO bef_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Bo moneuba noseꞌna bigahaꞌa foyaꞌagu buto hekalalube luto buꞌehina yabe. Ana noseꞌna bigahaꞌa li futili katili huto nohekalago lugaꞌa kapogu limo koko huꞌehigo bonaꞌmagi enigigusatuꞌi i emagu meleꞌahago namamagi fite neꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lugaꞌa efahubago hina melugu limo ito i polo huto hofa toto linaya meꞌi nogoyaꞌa meniꞌigo hosopa ito logo bibe. ");
INSERT INTO bef_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Lugaꞌa noseꞌna bihaꞌa ana huto ufehaꞌa hiti nina nagaꞌi hapaꞌagu limo iloto polo huto nalaꞌa hiti moneka hofa tete tiꞌina ai ufehaꞌa hiti nagauba i etago ti bati mehuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","To lugaꞌa meꞌi nogoya hiti bati huto ninalo limo ina bati huto polo felana hofa toloto noseꞌna legeyaꞌa babu luto legeya hoꞌehina yabe. To Yesu molo emiloto ma luto lu epiꞌehina: Kehelilo. Lenekesa niꞌinogomo yaꞌma ka keheliya ilo. ");
INSERT INTO bef_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesuhi koko panaꞌamagi ana bame kamofihi hapa lu limibo lite Yesuhi loka heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ya hite loka nehago Yesu ma luto lu epiꞌehina: Huꞌmau aiꞌa suguna ka hapaꞌa alu lepiꞌehibe. Ya huꞌehina lugaꞌa boanaꞌi enali bame kagutiko lu noepune ya hulenogo enali gili gili hilete be megalabe to enekesatuꞌi keheli lanaya ka mana melilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bame kamofihi hapa ma huto niꞌibe. Noseꞌna bihaꞌamoya Huꞌmamofihi kagaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Noseꞌna bihaꞌa kapogu limo inamoya ma huto niꞌibe. Bonaꞌmagi kaga manaꞌa kehelilago analo Satau oto ana kaga komopaꞌaniguti lito bufa nohibe. To ana kaga kehelite komopaꞌanigu li melelete bite Huꞌmau enubuto bilenogo aiꞌa kapo batiꞌalo mine lalabe luto yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","To noseꞌna bihaꞌa efahubago hina melugu liminamoya ma huto niꞌigi bonaꞌi lugaꞌamagi Huꞌmamofihi kagaꞌmu enegelo bite nelibe. Ya nehana ana mono ka komopaꞌanigu fulu tuto emagu menominabe, enali nesi kanaꞌasi komopaꞌanigu li melelete nehite fi taga huseꞌna huto nohigomo meleꞌisi ho kete ana kaga heꞌmi su helata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","To ufehe nagaꞌi hapaꞌagu limo ina noseꞌna bihaꞌamoya ma huto hapaꞌa niꞌigi bonaꞌi enali kaga kehelilata nehabe ya nehana enelesa luseꞌna to yogo feꞌnohi batiꞌamu to enegelonaguti ma melugu minoseꞌnauba neminanalo komopaꞌanigu bai toto minoto ka manaꞌa kehelinamofihi leꞌmo emagu mololago noseꞌna bihaꞌa manaꞌa enaliluguti huto hulata menohibe. ");
INSERT INTO bef_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","To noseꞌna bihaꞌa meꞌi bati huto nogoyaꞌa ninalo limo ito bati huto tinamofihi hapaꞌa ma huto niꞌibe, bonaꞌi enali ka keheli uleꞌale hite lilete amuya melete minago enaliluguti noseꞌna bihaꞌa huto huba huba hulata nohibe, Yesu ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","To mone ka hiti ma luꞌehina: Bonaꞌmagi libiꞌi ligite lapetuꞌi ifi tela to sipa kapoluga melelata menehabe. Hitalo nemalana yabe. To libiꞌi ya hutoꞌi meleꞌahago besa besa nolago bonaꞌi ana logo fana meto be gelete bila ela hite minelata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Asagaꞌna fala kito ninana alihi ai hepaꞌi kugumato huto hilinaꞌmu yabe. Asagaꞌna bonaꞌmagi ifi togo ninana alihi ai hepaꞌi kugumato huto hulago logo fana mehaꞌalo huto hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yanaꞌmu lenali kaba hu bati hilo. Lenali kaga keheli bati hilanamoꞌmu nolube. To bo moneuba keheliseꞌna lilana Huꞌmau ai moneꞌa hiti babu lito emilinaꞌmu yabe. To bo moneuba keheliseꞌna melise faꞌmene nohilina yalo ai keheliseꞌna mone aliꞌohube luto ekesa noyigilina Huꞌmau li heꞌmilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuhi itoꞌafu to gonamu tamuꞌa aitoga anamo babu bonaꞌmagi leꞌmo bego hiꞌahago enali Yesuhi buꞌalo mebiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ya hite nehago mone keneꞌuba bu enogoloto Yesuhi kehe i emito luꞌehina: Kai itokafumo to kogonamu tamukamomagi bu kagalune lite ma fegutoga ho tilete nehabe. ");
INSERT INTO bef_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ya noligo Yesu ma luto asagaꞌi lu epiꞌehina: Enali Huꞌmamofihi kaꞌa kehelilete megeꞌi nemalana boanaꞌmagiya nani itoꞌnigi nogonamu tamuꞌni nehabe. ");
INSERT INTO bef_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mone yupahi Yesu koko panaꞌa hiti botigu tilete ma luto lu epiꞌehina: Ma hefuhu nagamilugu ilaga huto muya beletoga bilune, luto lu epiꞌehina. Enali hapi fite ana hefunugu botiꞌanigu biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Boti nagamilugu nobigo Yesu buꞌi koꞌehina. Ya huꞌehigo amuya habahi hefupoguti liloto nagamiꞌmouba botiꞌanimogu ti bai toseꞌna huloto nagami hefunugu eneleꞌmo ifi talinaꞌa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesuhi koko panaꞌa enelesa ligo bite Yesuhi leꞌmo ho tilete ma lite liꞌahana: Sipi Bo. Sipi Bo yale. Lali anaꞌasi fililuta suhi nohibe lite liꞌahana. Yesu buꞌi koꞌehinati ho tiloto ana sipi amuya habapofi hiti to nagamiꞌi bilina hiti ka etemekito kaga lu etimigo analo meleꞌisi felele huto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ya huto felele hulago Yesu ma luto koko pananaꞌa lu epiꞌehina: Lenali keheli uleꞌale hiseꞌnatini hiyaꞌa niꞌibe? Ya ligo enali enekesa yigi babu lite sipi enelesaꞌani ligo enali ai lu emigo ai lu emigo hilete ma lite liꞌahana: Yaꞌma bo kiyiꞌafu nohibe? Ai nagamiꞌi nobilinamofihifi to sipi habapofihifi kaga lu epigo enali kaꞌa keheli emina bo yabe lite enaliꞌani lugo keheligo hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Alihi enali heꞌmite botiꞌanigu bite Gegese hepato Galili hefuhu nagami muya beleto kegiꞌa niꞌigo biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu botiguti heleko limito nagami kehetoga gigusa notigo bo mone foipa fele ailuga nina ana hepatoti Yesutoga oꞌehina yabe. Ana bo koyapaꞌi gufaꞌalo guketeꞌa mehepise gufa yapako kifi kifi kene mala mala hepaꞌi ninalo bula ola huto muliꞌmogu minolata nohina bo yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ai Yesuhi bu goloto sipi kehe iloto okabagati ifi toto Yesuhi gigusagu hekili higo koloto sipi kehe ito ma luto luꞌehina: Yesuo, kai ifo muya kokulumalugu Bo Huꞌmamofihi Panaꞌa. Kai hena suhi hu netalubeꞌmu nohane? Ke, kai nagabu giseꞌna li nugufalo memolobo, luto Yesuhi kehe ito lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu yataꞌa foipa fele komopaꞌaguti li heꞌmi etana molo nokehelito kehe iꞌehina. Babu yupahi yaꞌmana foipa feleuba ana bo li sa gilago to bonaꞌmagi gigusa yapolo nagaꞌi gi pili ko eteꞌahanaꞌmu i pulu tigo ka melugu leꞌmoto bulata nohina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ana bo loka hoꞌehina: Kigika giꞌaga nohane? Ya ligo ana bouba luꞌehina: Nani nigiꞌni yege yegeloita yabe. Henaꞌmugope babu foipa fele ailuguti bai tete mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Foipa fele enali ana bomofinugu bai tete minana Yesuhi kehe i emite liꞌahana: Kai yatama keligu leleꞌmo memolobo, lite buka tite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Analo afehi lapaluga yaga babu lite noseꞌnaꞌani line mane hite foipa felemagi Yesu kumu yagamagi enugufagu leleꞌmo molobo lago Yesu bilo luto enoho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ya higo enali ana foipa fele ana bomofihi gufaguti heꞌmite yagamagi enugufagu tite falago ana yaga enali asagaꞌi yabatoga limilete bite hefunugu nofu ti su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ya hago yaga kaba bomagi anana huto hinana bu gelete asaga boanaꞌi ya huꞌehibe lite lu epimofaꞌna ana hepato hila to yaga kaba nehana hepato hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Babu boanaꞌi hena suhi huꞌehifi lite bu galune lite biꞌahana. Enali Yesu nohinalo elete ana bo gufaguti foipa fele heleko limiꞌahana gufalo gukete li hekololoto ekesaꞌa hokolo nohigo Yesuhi gigusagu nominana ana boanaꞌi bu gelete enelesaꞌani ligo koli hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bonaꞌi lugaꞌa enali ana huto hinana bu gete minanamagi kaga beto hite lugaꞌa bonaꞌmagi ya huto ana bo negi noto nominanamo Yesu oto leꞌmo bati huꞌehibe lite lu epiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ya hago babu boanaꞌi Gegese hepatoti ete li nupa hite minanamagi Yesuhi: Bufa hubo lite liꞌahana, lali sipi lelesati nolibe liꞌahana yabe. Ya lite lago Yesu botigu tito heꞌmi epoloto bufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ana bo gufaguti foipa fele Yesu li heꞌmi etana bouba Yesu kumu: Nani hiti biluꞌibe luto megeꞌi lifito nobinamo Yesu akuꞌi ho lifi heꞌmiloto ma luto lu emiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Hepakaga buto Huꞌmau keleꞌmo bati huꞌehinanaꞌmu bonaꞌi lu epimofaꞌna hubo. Ya ligo ana bo hepaꞌalo buloto asaga boanaꞌi ana kegiꞌa neminana Yesu leꞌmo bati huꞌehina kaga lu epi baga iꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu nagami hefuhi mula kegiꞌa nina hepato henetigo babu boanaꞌi li nupa hite geba hite nehanati be gelete hetofana huto ane lite sipi fokehi heꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bo mone giꞌa Yailusi yabe luto nohina bo ai mono noto kaba nohina bo henetiꞌehina yabe. Ya huloto ana bouba Yesuhi gigusagu ho koto koloto: Kai hiti nani hiti nani nonuga biluꞌibe luto Yesuhi loka hoꞌehinagi ");
INSERT INTO bef_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yege paꞌa moneꞌisi besito filiseꞌna nohigo biluꞌibe luto loka hoꞌehina. Ana paꞌi nayahi luga luga su hoto mone kegiꞌati loemo heleko malago kufuꞌa buꞌehina. Yesu kapo moloto nobigo babu bonaꞌmagi leꞌmo folaganugu melelete luga lugati peninite nebago buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aꞌi mone minoꞌehina asaga yupahi golahaꞌa heꞌmiba heꞌmiba huto minago kufuꞌa nayahi luga luga su hoto mone kegiꞌati loemo heleko malago minoto asaga yogo feꞌnohaꞌa lusa gi etana bonaꞌmagi epi su hana mone ana lusa bonaꞌmagi nobesinana li felele mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ai ana aꞌuba babu bonaꞌmagi Yesuhi leꞌmo bego hite minanalo tiloto Yesuhi megesalo oloto kefeꞌalo ana aꞌuba bako higo nobesinana meleꞌisi felele hu etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ya higo Yesu: Nugufalo kuyuꞌafu bako nohibe luto asaga bonaꞌi enoloka hago enali ya mehuꞌohune lite bahane nehago Pitau ma luto lu emiꞌehina: Kaba boꞌni babu boanaꞌmagi keleꞌmo bego hiꞌahabe. Henabe luto bahane halube? ");
INSERT INTO bef_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aku Yesu luꞌehina: Mone keneꞌuba kefeꞌnilo bako higo amuyaꞌni heꞌmi netoto nobigo molo nokehelito nolube luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ana aꞌmouba Yesuhi gufalo linanamoꞌmu leꞌmo huto hilago keheliloto ai asaga bonaꞌmagi enubulo tubuto Yesuhi gigusagu hekili higo koloto asaga bona enogoko bilo Yesuhi gufalo bako huꞌehina kaga hapaꞌa lu noemito to yana higo nobesinana meleꞌisi i saki tuto felele hu etoꞌehinamo hiti lu hokolo huto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu lu emiꞌehina: Paꞌnimaka kaika kaga keheli uleꞌale huto minoseꞌnakauba keleꞌmo ye nokabe. Kai nobitogo kipaka fulu hino. ");
INSERT INTO bef_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ana kaga Yesu lu su mehoꞌehigo bo mone kaba bomofihi nonugati kaga lito oto pakamo filibe luto Yailusihi lu noemito anaꞌa hiligi yabe luto tisa bo leꞌmo heꞌmibo luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu kagaꞌatiti akeheliloto Yailusihi ma luto lu emiꞌehina: Kai koli mehuse nohutoka, paꞌi nohibe luto kehelito kagaꞌni li pili ko minetogo ai akuꞌi buna salinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu ana bomofihi nohaꞌalo henetiloto asaga bonaꞌi fegutoga nehago Pitagi Yonigi to Yemesigi enali hiti eneleꞌmago hiti to ana paꞌmofihi itoꞌafugo afoꞌafugo hiti tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Asaga bonaꞌi analo minana ana paꞌmofi kumu lite noseꞌna mo site yibi hiba hiba hite nehago Yesu bu goloto ma luto lu epiꞌehina: Lenali yibi nama mehilo. Ma paꞌi mefiliꞌehina faꞌmene buꞌi koꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ya nohigo asaga bonaꞌmagi enali afiliꞌehinaguti hena huto akuꞌi ho tiligo nolibe lite Yesuhi kiya hi eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu ana paꞌmofihi yahaꞌalo liloto kehe i emito luꞌehina: Ma paꞌi kai ho tibo. ");
INSERT INTO bef_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ya ligo ana paꞌmofihi mehaꞌa i behe huto ago ai meleꞌisi ho tito buꞌi gili higo Yesu noseꞌna ite ete eminogo neno luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","To ana paꞌmofihi itoꞌafugo afoꞌafugo topa helete etelesaꞌatiti ligo Yesu ma luto etegekesa biꞌehina: Letali ma huto hinanamofihi hapaꞌa bonaꞌi lu meepiliyo luto lu etotoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu panaꞌaloboꞌa nayahi luga luga su hoto nigigusagati loemo heleko malago neminana kehe ito eneleꞌmo nupa huloto ai giꞌalo foipa felefi to enebesiseꞌnafi li heꞌmilabe luto eneleꞌmo ho tiꞌehinaꞌa hiti to sipi amuya molo epolotoꞌa epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ya huloto ai Huꞌmamofihi kapoꞌa kumu bite ka lu yege nehete enebesiseꞌna li heꞌmi heꞌmi hilabe luto enoho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesu ma luto lu epiꞌehina: Lenali kapo nemeletemo lenayanuga anaꞌina melise faꞌmene bilo. Fatusa osahifi sisaku gutinifi noseꞌnatinifi efahatinifi to guketetini mone li fakene hite melise faꞌmene lenayapako bilo. ");
INSERT INTO bef_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","To enali lenebe tigilago nohi moneluga tilete analo noseꞌna nelata fatoga bila ela mehise ana nonugago nehite ana hepaꞌi heꞌmite fatoga biluneꞌmuko bilata hilo. ");
INSERT INTO bef_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","To hepaꞌi mone luga nehe netinogomo nonuga leneleꞌmo menemelenogomo enubulo lenemegesatini epite heꞌmilata hilo. ");
INSERT INTO bef_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ya luto Yesu panaꞌaloboꞌa lu epololago enali asaga hepato hepato bula ola hite ka lamanaꞌa lu yege hete lu epimofaꞌna nehite epesina bonaꞌi eneleꞌmo ye komofaꞌna hite asaga kapoga bula ola hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heloti Galili kapo kibina bo ai asagaꞌna huto hinamofihi kagaꞌa akehelito nohigo lugaꞌa bonaꞌmagi Yoniu nagami folo epolose bo filiꞌehinati akuꞌi ho tiꞌehibe lago ai ekesagu pisili bito loe lae huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lugaꞌa bonaꞌmagi koyapa bo Elaiyau huto nohibe nelago to lugaꞌa bonaꞌmagi koyapa mono ka leliꞌali huꞌehina bo akuꞌi ho tiꞌehibe lila hite kaga lu samahi tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ya nelago Helotiu ma luto luꞌehina: Nani koyapaꞌi Yonihi lubahaꞌa laga huto latahaꞌa liꞌohunamo yagi ai yaꞌma bo kiyiꞌafu nohigo kagaꞌa fato fatoꞌi babu lito nokehelube? Ya luto luloto ai Yesu kumu mapahi fito sa sa huba huba huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesuhi aposolo pananaꞌa akuꞌi ete li nupa hi su helete asagaꞌna enali hiꞌahana Yesuhi lu emiꞌahana. Ai asagaꞌi panaꞌaloboꞌa eneleꞌmoto lugaꞌa fato bonaꞌi noheꞌmi epoloto enaligo Betesaita hepato biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yege yege bonaꞌi Yesu ya huto nobibe lanaꞌa kehelilete megeꞌi lifite biꞌahana. Ai enebe tigito Huꞌmamofihi kapo kumuꞌi kaga lu epito epesiꞌehina bonaꞌi eneleꞌmo ye koꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Utehi yege limi falalubeꞌmu nohigo Yesuhi 12 panaꞌaloboꞌamagi aitoga ete ma luto lu emiꞌahana: Ma hepaꞌmo ka meꞌi niꞌinagi kai asaga bonaꞌi enoho lifitogo hepaꞌi ninalo bila ela hite noseꞌnaꞌani sa sa hite nelete kalabe. ");
INSERT INTO bef_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ya nelago Yesu ma luto lu epiꞌehina: Lenalitini noseꞌna epilo, luꞌehina. Enali ma lite liꞌahana: Lali beleti noseꞌna loegi loegi monegi hiti fayaꞌi loe hiti anasi liꞌohune. Kai kekesa nokehelita asaga yaꞌma babu bonaꞌmagihi noseꞌna sa sa huto mina filoto ito oto epilupihe? ");
INSERT INTO bef_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Babu bona 5,000 analo mineꞌahana Yesu panaꞌaloboꞌa ma luto lu epiꞌehina: Lenali ana bona lu epinogo li nupa hila hila hite 50 50 melugu mineno, luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesuhi panaꞌaloboꞌamagi ana kaga ana bonaꞌi lu epilete eneleꞌmo melugu malago mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ya nehago Yesu beleti noseꞌna loegi loegi monegi hiti fayaꞌi loemo liloto kokulumatoga bu go saga huloto Huꞌmamofihi fokehi holoto ana noseꞌna li tobo sito panaꞌaloboꞌa epigo enali lite bite ana bonaꞌi bite muyaga epila maga epila hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Enali asagaꞌi ana noseꞌna nelete enumuꞌi hulago limo koko hinaꞌa Yesuhi pananaꞌamagi li nupa hite safe nayahi luga luga su hoto nigigusagati loemo heleko malago li gu iꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mone yupahi Yesu aiꞌasigo nunumu huto nohigo panaꞌaloboꞌa aitoga eꞌahana. Asaga bonaꞌmagi nani kumuꞌi hena hibe lite liꞌahabe? Yesu enoloka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ya ligo enali lugaꞌamagi: Yoniu nagami folo epolose bo nohibe lite nelago lugaꞌamagi Elaiyau nohibe lite nelago to lugaꞌamagi koyapaꞌi lu huto huto bonaꞌi filiꞌehina akuꞌi meluguti ho tiꞌehibe lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ai panaꞌaloboꞌa enoloka hoꞌehina: Lenali nani kumuꞌi kiyiꞌafu nohibe lite lenekesa nekehelibe? Yesu ya luto enoloka hago Pitau ma luto kaꞌalo luꞌehina: Kai Huꞌmau koho lifiꞌehina panaꞌa Mesia nohane luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu suguna ka pananaꞌa amuya ka ma luto lu epiꞌehina: Bo moneꞌmofihi lenali mana kaga lu meemilo. ");
INSERT INTO bef_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kokulumaguti limiꞌehina Bo sipi gabuꞌi gilenogo enali olopa bonaꞌi to sipi mono noto kaba bonaꞌi to keya ka babafi bonaꞌi enali enemegesa hu nimite naniꞌi nehelenogo filiꞌohunagati akuꞌi loegi monegi yupahi minoloto Huꞌmau neleꞌmo ho tilibe luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","To ai ma luto lu epiꞌehina: Bo moneuba nani hiti alube lutomo aiꞌamuꞌi ekesa yigi fatoga mololoto malipu yafaꞌa asaga yupahi nani ana huseꞌna suhi li saga huba huba nohuto nemegeꞌi meleno. ");
INSERT INTO bef_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","To bo moneuba aiꞌa komopaꞌa li tokolo huto lu uleꞌale huto minalina alihaꞌa mino bati huse hepato mebuse mehaꞌa minigilinaꞌmu yabe. To bo moneuba nani kumu luto komopaꞌa nanitoga molo nimito minalina alihaꞌa mehaꞌa heꞌmilina meminigise mino kosabaꞌna huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","To bo moneuba liliꞌna amuya moloto liloto yogo foya bo huto minoto asagaꞌna melugu ninana ai li su holoto minoto aiꞌa komopaꞌa li sibina huto mehaꞌa minigilenogo alihaꞌa ana yogo feꞌnohaꞌauba li buto bito heꞌmalina yaꞌmana asaganauba hena huto heꞌmalina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","To bo moneuba nani kumu to kagaꞌni enelepiseꞌnamoꞌmu lesa linogo to megesa hu niminogo alihaꞌa Kokulumaguti limiꞌohuna Bo hiti Huꞌma hiti ageloꞌamagi hiti yaꞌma fana mehenaguti alana yupahi ana bomofihi nemegesa hu noemito minalube. ");
INSERT INTO bef_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lenekesu kaꞌni meheno. Yatai nani lu nolepube, luga ma ho tite nehana mefilise nehite Huꞌmamofihi kapoꞌa huto hilina enali yataꞌa bu gelete fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asaga kaga lu epiloto salele mone minoto Yesu ai Pitahi Yonihi to Yemesigihi eneleꞌmoto numuna hilune lite kosagu tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu nunumu huto nohigo okabaꞌa fato suhi huto huto huloto guketeꞌa koholi logo huloto gulu gulu luto fi besa loꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Meleꞌisi analo bo loemaleꞌi Yesu hiti kaga beto hiꞌahana. Ana bole etali Moseugo Elaiyaugo nehaꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Etali kokulumamofihi fana mehaꞌa hiti nehetilete Yesu Yelusale hepalugu Huꞌmau lu etoꞌehina kapolo moloto fililinamofihi kaꞌa lugo keheligo hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","To Pitagi laluꞌafugi koseleꞌani enehete enubuꞌi nokoto kaluneꞌmu nehabe. Keleteꞌani ho tite gili hite Yesuhi fana toꞌehinana to koyapa bomaleꞌi ho tiꞌahaꞌina bu geꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","To bomaleꞌi Yesutogati heꞌmite bilaꞌigo Pitau Yesu ma lu emiꞌehibe: Tisao, lali mana bu goꞌohunanaga bati huto nominone. Lali yege nopo loegi monegi gilune. Kaiꞌnaka mone to Mosehi mone Elaiyahi mone ya huto gilune, Pitau luto ai lesa nohutoꞌa ekesa mekeheliꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ya noligo enalitoga sopohi gilago samapagu panaꞌalobomagi minete sipi koli hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yaloꞌi sopopoguti nogoꞌa moloto ma luꞌehibe: Yaꞌma bo naniꞌni panaꞌni nohibe. Nigi moneko panaꞌni leꞌmo ho tiꞌohuna panaꞌni kaꞌa kehelilo. ");
INSERT INTO bef_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ya luto lu su hoꞌehigo Yesu aiꞌasigo faꞌmene nohinagi bu geꞌahabe. Panaꞌalobomagi bu geꞌahanana asagaꞌi suguna hite fato bonaꞌi kaga mone meepise nehite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mone kanagu enali kosa heꞌmite nelimigo babu bonaꞌi li nupa hite ete Yesuhi kapogu bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","To bo moneuba ana bonaꞌmagi folagahaꞌaniguti kehe ito ma luꞌehina: Tisao, kai yege panaꞌni bu gobo. Nani moneko panaꞌni nohibe. ");
INSERT INTO bef_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","To foipa fele moneuba ana panaꞌi nu nokigo ai sipi kehe ilata nohibe. Ya nohigo ana foipa feleuba ana panaꞌi nu kito melugu leꞌmo ho kago melugu afoya tibibi huto nokago bagalugati gele yau yau huto libiꞌna limilata nohina yabe. Ya nohigo ana panaꞌmofihi gufaꞌa hetito sibina huto meleꞌisi meheꞌmi etoseꞌna nohibe. ");
INSERT INTO bef_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","To nani koko pananaka leꞌmo bati hu etalo luto enoloka honamo enali leꞌmo bati mehilanaꞌa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kaꞌalo luꞌehina: Akae. Lenali yatai kanalo boanaꞌise, lenali ka keheliseꞌnatini meminabe to komopatini bebe soto meminolata hibe. Henaki yupahi lenali hiti nani minoto keheli sibinanatini kofeliꞌali nohube? Panaka leꞌmoto maga obo. ");
INSERT INTO bef_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ya noligo ana panaꞌa noago ana foipa feleuba leꞌmo ho kago melugu koloto kesepu kesepu noigo Yesu ana foipa felemo ka emekito ana panaꞌi leꞌmo bati huloto afoꞌafihi ana panaꞌi emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To asaga boanaꞌi Huꞌmamofihi sipi amuyaꞌa bu gelete enali hetofa suhi hibe lilete enegelo biꞌahabe. Boanaꞌmagi enali sipi amuyaꞌamu enegelo nebigo Yesu panaꞌaloboꞌa ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Maꞌasi ka mone lu lepilubeꞌmu nohuna lenekesu meheno. Alihi bonaꞌmagi Kokulumaguti limiꞌehina Bomofihi leꞌmete bite nagaꞌi emilago Huꞌmau keheliloto lu laga mehilibe. ");
INSERT INTO bef_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ya lina enali ana ka hapaꞌa mekeheliꞌahana yabe. Ana kamofihi hapaꞌa fala kito niꞌigo enali keheli hokolo mehite akuꞌi loka halupi hena hilupi lite loe lae hite enelesa luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuhi koko panaꞌamagi enaliꞌaniguti kiyiꞌafu sipi nohibe lite lilete kenasabo biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu kaga nelana akeheliloto ai yagapanaꞌi mone metoga leꞌmo ho tiloto ");
INSERT INTO bef_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma luto lu epiꞌehina: Bo moneuba ma lagaso yagapanaꞌi nani kumu heꞌmalina ai naniꞌi neheꞌmalinaꞌmu yabe. To bo moneuba naniꞌi neheꞌmalina ai naniꞌi noho lifigo limiꞌohuna bo heꞌmalinaꞌmu yabe. Bo mone folagahatiniguti nesi bo laba huto nohilina ai sipi bo nohibe. ");
INSERT INTO bef_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoniu luꞌehina: Kaba Bo, bo moneuba kai kigi hoto foipa fele li heꞌmi heꞌmi nohigo bu goloto ai lali nagaluguti menohigo ya mehubo luto lu laga hu etoꞌohune. ");
INSERT INTO bef_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ya ligo Yesu luꞌehina: Lenali lilinaꞌa laga mehi etalo, ai fatehatini legi huto menohina ai lenali lenalalutinifu yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Huꞌmau Yesuhi leꞌmalina kanaꞌa leba tago Yesu Yelusale hepato kapo moloto bilube luto ekesa kehelite minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ai bonaꞌi lugufa kohe tete kaga lite Samalia kegiꞌamofihi hepato mone bite anana anana li loloba nehi etenogo ai alihi bilube luto enoho lifiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ya hinamo Samalia hepato bonaꞌmomagi enali Yelusale hepato bilubeꞌmu nohibe lana akehelilete enali Yesu hepatigu mealibe lite be metigiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuhi koko panaꞌa Yemesiugo Yoniugo yaꞌma hana hapaꞌani bu gelete etali Yesuhi loka heꞌahaꞌina: Sipi Bo, kai kekesa nokehelita kokulumalugu logomuꞌi kehe inogo ma bonaꞌi oto enoloboto su halina bati huto niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ya lite haꞌigo Yesu i gelehe huto: Oꞌe, luto ka etemekiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ya hulago enali ana hepaꞌi heꞌmite fato hepato biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kapo melete nebago bo moneuba Yesuhi ma luto lu emiꞌehina: Bula ola hilataga nani kemegeꞌi lefelili hilube luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ma luto luꞌehina: Ya hilapi? Nani lipoti nokumube. Lopi kalamagi mehi kapolugu minago namamagi yafagu nohaꞌani minago huꞌehinaya Kokulumaguti limiꞌehina Bouba basu bito ko fulu hilina hepaꞌa meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu mone bomofihi: Nemegeꞌi molobo luto lu emiꞌehina. Ya ligo ana bouba ma luto luꞌehina: Sibi Bo, yataꞌa nani buto afoꞌnifu fililenogo keli ho etolotoꞌni yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ma luto luꞌehina: Kai heꞌmitogo filise bonaꞌi suhi hite komopaꞌani menimiseꞌnamagi filiꞌehina bonaꞌi keli halabe. Kai buto Huꞌmamofihi kapoꞌa kumu lu yege homofaꞌna hubo, luto Yesu ana bo lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","To bo mone fatouba ma luꞌehina: Kemegeꞌi malalunamoya negeba huꞌehitogo yataꞌa nani buto lalamehaꞌni nayahi epito soso hu epelenogoꞌni yabe, luto Yesuhi lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ma luto ana bo lu etoꞌehina: Bo moneuba keꞌmuya kifilubeꞌmu golagaꞌaga minoloto to megesaꞌaga bu go bu go hilina keꞌmuya kifilinaꞌa bati mehilibe. To ana huto bo moneuba nemegeꞌi malalubeꞌmu minoloto koyapa minose hapaꞌamu ekesa yigi yigi hilina bo yaꞌma ai Huꞌmamofihi kapoꞌalo tilina bati mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Alihi Yesu 70 boꞌa eneleꞌmo ho tito loemo loemo hepato fato fatolo enoho lifila, enoho lifila higo enali kohe tete nebinogo ai alihi bilubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ai ma luto lu epiꞌehina: Babu noseꞌna foyagu uyaꞌi loto mupa ito ninaya ana noseꞌna li nupa hilana bonaꞌa loeꞌasi nehabe. Ya huꞌehinagi lenali bite foya Afoꞌafihi numuna hi etenogo ai foyaꞌagu ete liliꞌna lite noseꞌnaꞌa li nupa hilana bonaꞌi eneleꞌmo babu lilibe luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lenali bilo. Nani lenaliꞌi sipisipi yaga ikeleꞌa legi huto lopi kalamagihi folagahaꞌanigu lenoho lufube. ");
INSERT INTO bef_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lenali efaha guꞌifi gukete gutinifi to lenigigusagu sutinifi melise nebite kapogu lenofo talana bonaꞌi kiya yogokololuguti ka lu meepilete bilata hilo Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","To lenali nohi monelugu tiluneꞌmu nehitemo yataꞌa metiꞌehite ma lite lilete tilo: Ma nonugu enali enipagu fuluna agoyaꞌa mineno. ");
INSERT INTO bef_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","To fulu bo mone gufaluga bati huꞌehilina bo ana nonuga nohilina lenali kaga leꞌmo bati hite lu emite be netigite fulunatini lenalitogati emilo. To ana bonaꞌi komopa mehana bohoya kagago nelana bonaꞌmo nehinogomo lenali fulunatini i behe huto akuꞌi lenalitoga alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lenali ana nonugu legese hite minete noseꞌna lepiꞌahanana nete minalo. Henaꞌmugope liliꞌnalo bouba liliꞌnalo minaꞌa lilubeꞌmu hilina yabe. To lenali nohi fato fatolugu tila limila mehilo. ");
INSERT INTO bef_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","To hepaꞌi moneto nebinogo ana hepato bonaꞌmagi leneleꞌmo hepalugu melete nohaꞌaniluga leneleꞌmete nebinogomo lenali noseꞌna guna ite lepilana noseꞌnasigo nalo luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lenali yana hepato enebesiꞌehilina bonaꞌi eneleꞌmo ye kelete ma lite lu epilo: Huꞌmamofihi Kapoꞌa hokolo hilina kanaꞌa anasi lenalitoga aꞌo leba notabe lite lu epilo. ");
INSERT INTO bef_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","To lenali mone hepato bite tiluneꞌmu nehinogo ana hepato bonaꞌmagi leneleꞌmo nohaꞌaniluga melete noseꞌna melepinogomo lenali bite ana hepaꞌmofihi kapolo ho tiꞌehite ma lite lilo: ");
INSERT INTO bef_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Lenali hepatinigu mumusopauba ligigusagu minana akuꞌi ana hepatinilo li fopo nohune. Yaꞌma lenemegesa hu epite ya nohutagi lenali ka moneꞌya kehelilo, Huꞌmamofihi Kapoꞌa anasi lenugufalo o leba notabe lite ana hepato bonaꞌi lu epilo. ");
INSERT INTO bef_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","To nani lu nolepuna, yaꞌma Huꞌmau asaga bonaꞌmagihi kaga loko hilina yupahi Sotomu hepaꞌi ginaga fi noepito to hepaꞌmofihi bonaꞌi leneleꞌmo bati mehilanamagi kumu ginaga fi meepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ke, Kolasini bonaꞌise. Ke, lenali Betesaita bonaꞌise. Lenalitoga amuya liliꞌna nohunana enali koyapaꞌi Taiya bonaꞌi hiti Saitoni bonaꞌi hiti enalitoga li huto hutita enali meleꞌisi melugu mino laba hite gebona gukete li hekelete lahi enugufalo felete eniginaga foipanaꞌanimuꞌi finogo nehinogo ya bu goto foipanaꞌanimuꞌi nehabe luto huto hulata nohibe. Lenali komopatini i gelehe hilanamo meniꞌinagihe. ");
INSERT INTO bef_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Huꞌmau bonaꞌi kaga loko hilina yupahi ai Taiya bonaꞌi hiti Saitoni bonaꞌi hiti enalitoga ginaga fi epito lenalitoga sipi keta hu etago ginaga fi melepilibe. ");
INSERT INTO bef_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","To lenali Kapaneami bonaꞌise. Lenalitini kokulumalugu leleꞌmo saga hilune lite yaꞌiya tilafihe? Logo hepalugu limilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu koko pananaꞌamagihi ma luto lu epoloꞌehina: Bo moneuba katini keheli lepilinaya naniꞌni ka keheli nimilibe. To bo moneuba megesa hu lepilinaya naniꞌi megesa hu nimilinaꞌmu yabe. To bo moneuba naniꞌi megesa hu nimilina aiya noho lifiꞌehina Bomofihi yaꞌma Huꞌmamofihi megesa hu emilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","To 70 boꞌa Yesu enoho lifito liliꞌna epina enofokehenaguti akuꞌi ete li nupa hiꞌahana. Ya hilete enali ma liꞌahana: Sipi Bo, kai kigika nohonogo foipa felemagi hiti labaga liyafa hite ka keheli limibe liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu lu epiꞌehina: Satahi bu nogogo kopisiꞌna legi huto kokulumaluguti limo noibe. ");
INSERT INTO bef_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kehelilo. Osifa gufalo fito kakamukeꞌmagi luba nehana yagakafamagihi ibe lilika ibe hite nebite ana hite fatehatinimagihi asaga amuyaꞌani li gofa halabe luto nani amuya lepiꞌohube. To anaꞌina moneuba lenugufa li sibina mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ya huꞌehina lenali lenegelo bite foipa felemagi kagati keheli limibe lila oꞌe lutoꞌni ya nasanamofi kumu lenegelo mebibo. Lenagitini Huꞌmamofihi kokulumalugu fayahi geꞌahana yananaꞌmu lenegelo bilo, luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ana yupahi Sikalafuꞌuba Yesutoga bai tago gelo biloto ma luꞌehina: Oho. Afoꞌniga, kokulumaꞌi hiti meꞌi hiti sipi kaba boꞌa. Kai enegekesa keheli bati hiꞌahanamagihi kaika suguna ka lu hokolo mehu epoloꞌahata niꞌinaya to enali enegekesa keheli bati mehinamagihi alu hokolo hu epoloꞌahata niꞌigo kofokehi nolube. Oꞌyo Afoꞌniga, kaika luꞌahatalo ana suhi ana suhi huto bati huto hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nani Afoꞌnifu asagaꞌna nani nayanuguko moloꞌehibe. Bo moneuba Huꞌmamofihi Panaꞌa nohibe luto mekeheliꞌehina. Afoꞌnifu aisigo keheliꞌehibe. To bo moneuba Huꞌmamofihi ai nohibe luto mekeheliꞌehinagi Panaꞌa aisigo keheliꞌohuto ai Panaꞌauba Afoꞌafihi enelepito kaga lu epina bonaꞌi enali ana hite Huꞌma nohibe lite kehelilata nehabe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","To Yesu koko pananaꞌa nehanaga i behe huto okaba hu epiloto sumi ka enekesa luga ma luto lu epiꞌehina: Lenali yaꞌma huto huꞌehinana bu geꞌahana bonaꞌi enegelo bilo. ");
INSERT INTO bef_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","To henaꞌmube? Enali koyapa lu huto huto bonaꞌi hiti to gihiti bonaꞌi enali kumu lu nolepube. Lenali bu gela to lenekesagu kehelila nehanana ana huto lekesagu kehelila to lubutiguti bu galune lite helebe helebe hanaya enali mekehelila to bu megalana suhi habe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Keya ka keheli bati huse bo moneuba Yesuhi miꞌi malalube luto Yesu nohinalo tiloto ma luꞌehina: Tisao, nani hena hulotoꞌni mino kosaba hepaꞌi lilube? luto loka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ya ligo Yesu ma luto ana bo loka hoꞌehina: Mono ka fayahi geꞌahanagu henabe luto niꞌibe? To hena huto lu gelehe huto leka solata nohane? ");
INSERT INTO bef_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ana bouba loka hanalo ma luto luꞌehina: Sipi Bo, Huꞌmakafu yabe to kai lutumopaka asagaꞌi aiꞌi emi su hobo to kemehaka asagaꞌi ai emi su hobo to amuyaka asagaꞌi ai emi su hobo to keheliseꞌnaka emi su hobo. To kaika kugufakamofihi nohataꞌa huto kalalukafihi leꞌmo laga hubo. ");
INSERT INTO bef_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ana bomofihi ma luto lu emiꞌehina: Kai kagauba fotogo hinaga lane ya hatagi kai ana lata suhi buto huloto mino bati hilane lu etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ya noligo ana keya kaga kehelise bouba aiꞌa giꞌa leꞌmo bati hilubeꞌmu Yesuhi ma luto loka hoꞌehina: Kiyiꞌafu nani nalaluꞌnifu nohibe? luto Yesuhi loka hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ma luto luꞌehina: Bo moneuba Yelusale hepatogati Yeliko hepatoga bilubeꞌmu nohuto nomobigo, guminalo bonaꞌmagi kofohi melelete ana bo osahi ho emite to kataꞌa li hete heꞌmi etete bifa higo, ai anaga fililubeꞌmu nohuto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","To ana kapolo mono kaba bo moneuba mekehelise nomobuto ana bomo bu gopa, kapo muya beletoga i pebisa ho etoto buto ya huto fotoꞌi nohuto be ligibe. ");
INSERT INTO bef_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","To ana huto mone Libai nagaꞌaluguti oꞌehina bo ai hiti mono bo nohinaya ana hepatoga nehetito heꞌahana bomofihi bu goloto anaꞌasi kapo beletoga buto be ligito bufa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","To akuꞌi fateha bo moneuba Samalia kegiꞌa nohina bouba ai kapo nomoloto anaga oloto bu gopa meleꞌisi kekeꞌi nolu etabe. ");
INSERT INTO bef_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kekeꞌi nolu etoto buto gufaꞌa gitigiꞌehinalo lusa gi etoto bai nagamiꞌi hiti ueli hiti nofoloto sa gi etoꞌehina yabe. To ya huloto nu kito leꞌmo saga huto toki yagaꞌamofihi megesaꞌalo leꞌmo mololoto ya huto buto bo nohi alana bonaꞌi nekana nopogu leꞌmoto tiꞌehina. Ana nonugu kaba huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Koloto etehi efahaꞌa loemo leka soto noho bomo noemito ma luto lu emiꞌehina: Yaꞌma bomofihi kaba hu etoto minobo. To efahi bati mehinogomo nani aluna yupahi moneꞌa hiti kimilunagihe. ");
INSERT INTO bef_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu, yaꞌma bame ka lu epi su hoto yaꞌma babafi bomofihi ma luto loka hoꞌehibe: Guminalo bonaꞌmagi ana bomo hago, to fililubeꞌmu nohigo loe yagi mone yagi bomagi bite bu geꞌahabe. To hiya bouba bonaꞌamofihi supo huto kaba hu etoꞌehibe? Lu nimibo. ");
INSERT INTO bef_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","To ai: Ginaga fi etoꞌehina bouba yabe ligo, Yesu: Kai buto ana supo huto minobo luto lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu koko pananaꞌa hiti kapo melete bilete hepaꞌi moneto nehetigo aꞌi mone giꞌa, Mata yabe, luto nohina aꞌuba Yesuhi nohaꞌaluga leꞌmoto buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matahi gonaꞌa paꞌi mone minoꞌehina, giꞌa Malia, ai Yesu nohina mehaꞌasilo oto minoto Yesuhi kagaꞌa keheliba keheliba huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ya nohigo Matau aisigo noseꞌna laita hula to fato liliꞌna lila ya hula nohigo kosele hago Matau Yesuhi ma luto lu emiꞌehina: Sipi Bo, asaga liliꞌna Maliau heꞌmito naniꞌigo nimigo noluna kai naniꞌi kegekesa yigi menonimipihe? Kai Maliahi leꞌmo heꞌmitogo ai oto naniꞌi neheꞌmalibe, luto Matau luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ya noligo Yesu ka lu emito luꞌehina: Matao, Matao. Kaiya kekesa yigiba yigiba silagaꞌnamuꞌi nohuto kipakagu keta hulata nohane. ");
INSERT INTO bef_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yaꞌma nohata niꞌigo monekoꞌnasiya anasi niꞌibe. To Maliau ai etoꞌehina suhi nohina yabe. Ai yaꞌma ka lamanaꞌa kehelilata nohina niꞌigo mone li heꞌmi etalinaꞌa meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mone yupahi Yesu hepaꞌi moneto buto minoloto nunumu lu su nohago mone koko panaꞌauba ho tito ma luto lu emiꞌehina: Sipi Bo, koyapaꞌi Yoniu koko pananaꞌa nunumu enelepiꞌehina ana suhi huto kai nunumu lelepibe luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ya noligo Yesu ma luto lu epiꞌehina: Lenali nunumu hiluneꞌmu nehitemo ma lite lilo: Afotiga, kai kigika hetofana huto minalibe. Kai kapoka ai huto hino. ");
INSERT INTO bef_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Noseꞌnati kai kanaꞌamu kanaꞌamu limilata hubo. ");
INSERT INTO bef_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kai foipanati li heꞌmi letetogo lali ana huto asaga bonaꞌmagi foipana nehi letana li heꞌmi epalalune. To kai sipi fi taga huseꞌnagu leleꞌmo memolobo. ");
INSERT INTO bef_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","To Yesu ma luto koko panaꞌa lu epiꞌehina: Lenaliluguti moneuba laluꞌafihi nonuga foluguꞌi buto ma luto lu emilibe: Nalaluo. Kai beleti noseꞌna loegi monegi nimibo. ");
INSERT INTO bef_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mone nalaluꞌnifu kapo moloto nanitoga oꞌehinagi nanitoga noseꞌna emilunaꞌa meniꞌigo kaitogati nimitogo ito buto emilube. ");
INSERT INTO bef_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To ya luto kehe noitogo ana nohaꞌalugati kalalukafu ma luto lilinaꞌmu yabe: Kafe ahekini lolotoꞌni yagapanaꞌni hiti sipalo akoꞌohutagu hena hibe luto oto kosele nahanaga luto kehe kehe noine? Nani koꞌohunaguti ho tito buto anana li mekimilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu ma luꞌehina: Nani lusiga lu nolepube. Ana bo kai kalalukafu minanaꞌa huto noseꞌna nimibo luto kehe itamo ai ho tito li mekimilubeꞌmu hilinamoya to kai kubuya mehinogo kehe iba iba huto minataꞌmu ai kalalukafu alihi ana noseꞌna ho tito li kimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yaꞌmuꞌi nani lu nolepube. Lenali Huꞌmamofitoga loka henogo ai anaꞌina lepilibe. Lenali anaꞌinaꞌmu sa sa huba huba hilete alihi li huto hilabe. Lenali kasito begele begele nehinogo Huꞌmau kafe sigi lepalalibe. ");
INSERT INTO bef_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Asaga bonaꞌi Huꞌmamofihi loka holenogo ai anaꞌina epilinaꞌmu lilata nehabe. To bo moneuba anaꞌinaꞌmu sa sa huloto li huto hulata nohibe. To bo moneuba kasito begele begele nohigo Huꞌmau kafe sigi etolata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","To lenaliluguti monepi monepi yagapanatinimagi faya kumu kehe noinogomo osifaꞌi lite bite epilafi? Oꞌe. ");
INSERT INTO bef_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","To yagapanatini moneuba kokole muꞌamu kehe noinogomo kakamukeꞌi mone lite bite epilafi? Oꞌe. Yaꞌma hiti bati mehuꞌehibe luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yalo ana huto lenali bo foipaꞌamagita yagapanatini eneleꞌmo hofa telete anaꞌina bati huꞌehina enegelo bite epilata nehabe. Ya suhi lito ana huto kokulumalugu nohina bo, Afotinifu, aiꞌa hapaꞌa sipi hetofana niꞌigo aitoga loka haluneꞌmu nehana Hetofa Sikalafuꞌa epilinaꞌmu yabe, luto Yesu koko pananaꞌa lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu bo mone foipa feleuba bagaꞌa li hekini lago minolata hina ya Yesu ana foipa fele li heꞌmi etolago ana bo bagaguti kaga luꞌehina. Ya nohigo boanaꞌi analo minete bu geꞌahana. Enali enelesa ligo enekesa yigi fato fato hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yesu ya hinana bu gelete lugaꞌa bonaꞌmagi ma lite liꞌahana: Bielesebulu foipa felemagihi sipi kabaꞌani nohinago ai ma bomofihi aitogati amuya emiꞌehigo yanatuꞌi foipa fele li noheꞌmibe lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","To lugaꞌa bonaꞌmagi Yesuhi miꞌi malaluneꞌmu ma lite lu emiꞌahana: Kai kokulumalugu Huꞌmamofihi babeyafaꞌa hu lepibo lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu kagaꞌani akeheliloto ma luto lu epiꞌehina: Hepaꞌi moneto bonaꞌi loko hite guna ite mino luga luga hite loe bonaꞌi lolo hite luba hilana yaꞌmana hepaꞌi sibina hilinaꞌmu yabe to koguna nagaꞌi mone neminanaguti fuku lite luba hilete fato fatoꞌi minalana enali asagaꞌi bati mehilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","To Satahi ai nagaꞌa fuku lite loe nagaꞌi hilete enaliꞌani luba hilana fato fato hite minalana Satahi kapoꞌa hena huto minalina niꞌibe? Lenali nani kumuꞌi Bielesebulu amuya emiꞌehigo foipa fele li heꞌmi heꞌmi nohibe lite nelanamoꞌmu lenaliꞌi lenoloka nohobe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","To maꞌnaka luto Bielesebulu amuya emiꞌehigo foipa fele li heꞌmi heꞌmi nohibe lite nekehelina to kiyiꞌafu panatini eneheꞌmago foipa fele li heꞌmi heꞌmi nehabe? Ya huꞌehigo enaliꞌani panatinimagi yasi lolo hilete katini li loko hite kehelilabe. ");
INSERT INTO bef_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oꞌe, Huꞌmamofihi ai amuyaꞌaloti foipa fele li noheꞌmube ya nohugo ana nohunanauba Huꞌmamofihi kapoꞌa anasi lenalitoga aꞌo leba toꞌehibe luto lenubulo huto huloto lenelepilata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","To amuya bo moneuba gimi mageꞌi huloto nohi feꞌnohaꞌa kaba gimi gito minolata nohina ya yogo feꞌnohaꞌa bati huto enubu nini minolata nohibe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","To lusi amuya bo mone nehetiloto hepa kaba nominalina bo hiti luba hilete ana bo holoto gimi mageꞌa li su holoto asagaꞌna gumina lina feꞌnohaꞌa guna ito bonaꞌi epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Bo mone ai nalaluꞌnifu legi huto menohilina aiꞌya fatehaꞌni nohibe. To bo moneuba neheꞌmoto panaꞌaloboꞌni eneleꞌmo nupa mehilina ai maꞌnaka luto panaꞌaloboꞌni enegene ito eneleꞌmo tili tele hulata nohibe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Foipa feleuba bonaꞌmagi enugufaguti leheko nolimitomo ai ka meꞌi ninalo mino fulu hilina hepa kumu sa sa hulata nohibe to ana foipa feleuba mino fulu hilina hepaꞌi sa sa hina bu megotomo aiꞌa ma luto lulata nohibe: Nani heꞌmito oꞌohuna nohaꞌnilo akuꞌi bilube luto ana foipa feleuba ekesa yigilata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ya luto ekesa yigilotomo ai i behe huto buto heꞌmito oꞌehina nohaꞌa leꞌmo bati hago gulu gulu luto niꞌigo buto ana foipa feleuba bu golata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","To ya huꞌehigo ai akuꞌi ana nohaꞌaguti heleko limiloto buto nayahi mone kegiꞌa su hago mone kegiꞌati loemo heleko malago foipa fele eneleꞌmoto ago ana nohaꞌagu minelata nehabe. Koyapaꞌi ana bo nesiꞌa sibina huto minolata hinamo yatai babu foipa fele ete ai gufagu minago aimoya moneꞌna suhi huto foipa gofana loto sibina bo minolata nohibe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu yaꞌmana kaga lu baga ilago aꞌi moneuba babu bonaꞌmagihi folagahaꞌaniguti ka mone ma luto Yesuhi kehe ito lu emiꞌehina: Ai koyapaꞌi keketoloto amihi kimiꞌehina aꞌuba ai fokehenaguti gelo bito minalibe luto ana aꞌuba Yesutoga luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ya noligo Yesu ma luto lu emiꞌehina: Oꞌyo. To enali bonaꞌi Huꞌmamofihi kaꞌa keheli emite megeꞌi melete minelata nehana bonaꞌi enali fokehenaguti enegelo bite minalabe luto Yesu ana aꞌi lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Babu bonaꞌi li nupa hite Yesu leꞌmo folagahi hite minago Yesu ka mone ma luto lu epiꞌehina: Yatai boanaꞌise, bati mehana boanaꞌi nehabe. Enali sipi liliꞌnakamofi kumu topa hoseꞌnaꞌa Huꞌmau bati huto yabe lilina yamofihi hu lelepibo lite noloka nehanaya nani hu meenelepiluna moneko Yonaha topa hoseꞌnaꞌa hu enelepilunaꞌmu yabe luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Koyapaꞌi Yonau Huꞌmamofihi makiꞌa lolo huto Nineba bonatoga nehetiꞌehina yabe. Ana suhi huto Kokulumaguti limiꞌehina Bo Huꞌmamofihi makiꞌa lolo huto yatai boanaꞌi enalitoga minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","To kokuluma hiti meꞌi hiti alihi su nohenogo Huꞌmau bonaꞌa eneleꞌmo fato fato nohinogo sipi aꞌi gihiti aꞌi yabe lilata nehana aꞌmouba ai sofo kegiꞌati aiꞌa hiti to yatai boanaꞌi hiti ho tilete ai ana gihiti aꞌuba foipanaꞌanimuꞌi li yege ho epalalinaꞌmu to enifisa ilinaꞌmu yabe. Henaꞌmugope yaꞌmana gihiti aꞌi ai meꞌi belehaꞌaga nominoto kapo moloto Solomoni hetofana huto bonaꞌi mono ka lu epimofaꞌna nohina nokehelibe. Ya huꞌehina Solomonihi be ligito hoto nohina maloꞌi niꞌibe to lenali komopatini i gelehe menehanagihe. ");
INSERT INTO bef_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kokuluma hiti meꞌi hiti su nohenogo Huꞌmau bonaꞌi eneleꞌmo kehelilubeꞌmu hilina yupahi Nineba bonaꞌi enali ho tilete enali yatai bonaꞌmagihi enifisa ilete foipanaꞌanimuꞌi li yege ho epalalinaꞌmu yabe. Henaꞌmugope enali Nineba bonaꞌmagi Yonau lu epina kaꞌa kehelilete enali komopaꞌani li gelehe hiꞌehite yabe. Ya huꞌehina yatai Yonahi be ligito nohina magaꞌma niꞌibe luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bonaꞌmagi libi logoꞌani li kulu tilete fala kite lapetu ifi tete memelelata nehabe. Enali nohaꞌanigu hutoꞌi meleꞌahago besa besa loto niꞌigo ana fana meto bonaꞌi bu gelete nonuga bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kugufamofihi libiꞌi logoꞌaya suhi huto kubuka niꞌibe. To kubuka bati huto niꞌigomo asaga kugufaka bati huto fana toto minolata nohibe. To kubuka bati mehuꞌehigomo asaga kugufaka metepu ito minolata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ya huꞌehinagi kai asaga yupahi kaba hu bati hubo fana mehena kailugu nina asagaꞌi metepu i lalibeꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","To asaga kugufaka fana mehi huto bai toto mone metepuna nila ya hula mehuꞌehinogomo ai besa asaga kapoga bilinaꞌmu yabe. To libiꞌuba fana mehaꞌa kaitoga besa besa nolanaꞌa hilinaꞌmu hapakamofihi hetofanaꞌa ahuto hilibe. ");
INSERT INTO bef_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ana kaga lu su holago Felosi bo moneuba: Nohaꞌnigu buto noseꞌna naniꞌi hiti naluꞌibe luto kehe igo Yesu buto hitalo minoto noseꞌna nalubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ya nohigo ana Felosi bouba Yesuhi bu gana ai yahi okala mehuse noseꞌna nonago ekesa yigi babu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Felosi bouba ya huto ekesa yigi babu noligo Yesu ma luto lu emiꞌehina: Lenali Felosi bonaꞌi, lenali asaga yupahi kohatinimofihi feguꞌaga leꞌmo gulu gulu lila to lapetinimofihi fegu gupisaꞌaga li gulu gulu lilata nehabe. Ya nehana lenali komopatinigu luba huseꞌna to foipa faipana babu luto bai toto niꞌibe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lenali negi nagi bo yabe. Huꞌmau ai feguꞌaga lolo huꞌehina bouba ai ana huto komopaꞌaluga lolo mehilina niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ya huꞌehinagi kai kohakagu to lapekagu niꞌilinana musufalo bonaꞌi epiletogo asaga nasanaka gulu gulu lu su halibe luto Yesu Felosi bonaꞌi lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ehe, lenali Felosi bonaꞌise. Lenali kaba hu bati hilo. Lenali noseꞌna tu kifina fato fatoꞌi to ketuyafi mamufafi agepafi nayahi luga luga su hago nina to lenali naeniꞌa nelite monekoꞌisi Huꞌmamofitoga emilata nehabe. Ya hite Huꞌmamofitoga komopatini meemise to bonaꞌi eneleꞌmo bati mehiꞌahabe. To lenali bonaꞌmagihi eneleꞌmo lenemetoga melete minalana to Huꞌmamofihi nasanaꞌa lenegekesu mehose emilata nehite komopatini bebe senogo minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ehe, lenali Felosi bonaꞌise. Lenali mono nonugu siaꞌa bati hinalo bona folaganugu minelago asaga bonaꞌmagi lenebe tigite lenigitini li saga bona folaganugu hilata habe. ");
INSERT INTO bef_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ehe, lenali kaba hu bati hilo. Lenali kene mala mala hepa suhi hite fala kite nehago bonaꞌi ifoꞌalo bila ela nehite lenali kumuꞌi meꞌi afehaꞌalo nehabe lite mekehelilata nehabe, Yesu ya luto Felosi bonaꞌi lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Keya ka tisa bo moneuba ma luto Yesuhi lu emiꞌehina: Babafio, kai ya luto kaga nolutomo lalitoga hiti kaga lu sibina nohu letane luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ya ligo Yesu kaꞌalo luꞌehina: Ehe, lenali keya kaga kehelise bo kaba hu bati hilo. Lenali asaga yupahi boanaꞌi keya kagatinimofihi anaꞌina li keta fi epelelago enali enigiꞌnalo ketaꞌmu filite kofite nebago to lenali lenayahi kosaꞌatuꞌi mone anana li eneheꞌmelata menehabe. ");
INSERT INTO bef_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ehe lenaliꞌmase. Lenali koyapaꞌi ligike fakehatinimagi lu huto huto bonaꞌi enehete mamufa gilata kapogu keli heꞌahana yatai lenali li hokolo hilete li kuguma hite ana kene mala malaꞌani nehabe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yaꞌmana hapatinimuꞌi koyapa ligike fakehatinimagihi enemegeꞌi melete minete lenali komopatini yaꞌmana hiꞌahana sukumu bati hulago neminabe. Enali lu huto huto bonaꞌi enehete keli heꞌahago lenali kene mala malaꞌani li hokolo hite li kuguma nehabe. ");
INSERT INTO bef_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ya huꞌehigo koyapaꞌi Huꞌmamofitoga kaga keheliseꞌnaꞌa bati huto niꞌigo ai ma luto luꞌehina yabe: Nani lu huto huto bonaꞌi hiti kaga lu yege hose bonaꞌi hiti enalitoga enoho lifinogo nehetilenogo bonaꞌmagi enegene mane inogo luga koli nefelenogo lugaꞌa enahalabe. ");
INSERT INTO bef_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ya huꞌehina enali yatai boanaꞌmagi koyapaꞌi kokulumaꞌi hiti meꞌi hiti huto nohigo minete filiꞌahana lu huto huto bonaꞌmagi kumu lite ka foyagu bite Huꞌmau osahi epilinamo yaꞌma lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Koyapa Ebeli filiꞌehina kanaloti oto Sekalaiya ai sipi mono nohi gegisaꞌagu mamufa gilata hitalo filiꞌehinalo yananaꞌmu asagaꞌi luto yatai boanaꞌi enalitoga minalinaꞌmu yabe. Maꞌnaka luto lu nolepube, yaꞌmananaꞌmu luto minaꞌa sipi yatai boanaꞌmagi ma nehana heꞌmilabe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ehe, lenali keya kaga kehelise bonaꞌise. Lenali bonaꞌmagi kaga keheliseꞌnaꞌani li sibina hilete lenali kaga keheli kapo li hokolo mehise nehago bonaꞌi kaga batiꞌa keheliluneꞌmu nehana lenali lu laga hi epelenogo mekehelilata nehago to lenali hiti ana kaga batiꞌalo megeꞌi memalalata nehabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu ana hepaꞌi heꞌmito nobigo Felosi bonaꞌi to loto kaga kehelise bonaꞌmagi enali ipakafa Yesuhi helete enali amuya enipa hulago kaga Yesunugu lu bilune lite liꞌahana. Ya hite enali ");
INSERT INTO bef_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yesuhi bagalo ka fato fato babeyafa hite loka helete kaba bagalo hiꞌehite ka mone sibinaꞌa nolinogomo ka foyagu leꞌmo malalune lite hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Babu boanaꞌi li nupa hite yege yegeꞌmagi ikini ikini hite ai gufalo ai gufalo hite moneꞌmofihi gigusalo i sala kose suhi hite nehago ana kanaꞌalo Yesu panaꞌaloboꞌa yataꞌa luto lu epiꞌehina: Lenali Felosi bonaꞌmagi faga faga lilanaꞌmu hapaꞌani kaba hu bati hite minalo. ");
INSERT INTO bef_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Asagaꞌna fenene huto ninana alihi hepaꞌi kugumato huto nohinogo to asagaꞌna ifi toto ninana alihi bonaꞌmagi bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ana huto asaga kaga foluguꞌi metepu inagu lilata nehana bonaꞌmagi yegelo kehelilabe. To asaga kaga lenali sumi sumi hite nonugu fala kite nelana enali hepaꞌi kugumato ti saga hite ho tiꞌehite kehe ite lu hokolo hite lilanaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nalaluꞌnigita, nani lu nolepube. Lenali bonaꞌmagi mone bo gufaꞌa halanaꞌmu lenali koli mehilo to enali akuꞌi alihaꞌa fato suhi moneꞌa hiti mehilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lenali koli hilana bonaꞌi nani lenelepilube, luto Yesu luꞌehina. Bonaꞌi enohogo enohogo nohina bo Huꞌmau, lenali aiꞌi koli hi etalo to yaꞌma amuyaꞌa hiti bo nohuto bonaꞌi logo kapogu eneleꞌmo heꞌmi epololenogo limilanaꞌmu yabe, luto Yesu luꞌehina yabe. Nani lusiga luto lu nolepube, lenali yaꞌmana bo kaba hu bati hilanaꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nayahi mone kegiꞌa su hago namamo loe toealotiꞌi mina filata nehanamoba keheliꞌahafihe? luꞌehina. Ya huꞌehina Huꞌmau mone lagaso nama ekesu halinaꞌa huto meniꞌibe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","To latahatinigu nina okaya Huꞌmau leka soꞌehinaꞌmu yabe. Ya huꞌehinagi lenali lenelesa linogo koli mehilo. Lenaliya Huꞌmamofihi bulo asaga lagaso meso namamagihi minaꞌani enebe ligite nehabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","To nani lu nolepube. Bo moneuba nani nigiꞌni boana enubulo lu yege homofaꞌna hilina ana huto Kokulumaguti limiꞌehina Bouba ai ana bomofihi giꞌa lu yege homofaꞌna Huꞌmamofihi ageloꞌamagihi enubulo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ya huꞌehina to bo moneuba naniꞌi megesa hu nimito boanaꞌmagi enubugu buya hinogo minalina nani ana huto megesa hu emito Huꞌmamofihi ageloꞌamagi enubulo minalunaꞌmu yabe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bo moneuba Kokulumaguti limiꞌehina Bomuꞌi ka foipaꞌa lu etalina Huꞌmau ai foipanaꞌa li heꞌmi etalinaꞌmu yabe. To bo moneuba Sikalafuꞌmofihi ka foipaꞌa lu etalina Huꞌmau foipanaꞌa li meheꞌmi etalinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","To enali ka foya liluneꞌmu nehite mono nonugu leneleꞌmete bite gamani bonaꞌi to kibina bonaꞌi nehilana enubulo leneleꞌmete nebinogomo lenali koli hilete lenegekesa yigi yigi hite ma lite mekehelilo: Lali hena huto kagaꞌanilo lilune? Lali hena kaga lu epilune? ");
INSERT INTO bef_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yaꞌma lite lenekesa yigi babu nelilana kanaꞌalo kagaꞌanilo lilana kaga Sikalafuꞌuba lenelepilinaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Babu boanaꞌmagihi folagahaꞌaniguti bo moneuba Yesuhi ma luto kaga lu emiꞌehina: Tisa, kai nogoꞌnifihi lu emitogo yogo feꞌnohi afotiꞌafihi omihaꞌa liluꞌinaꞌa guna ito lugaꞌa naniꞌi nimilibe. ");
INSERT INTO bef_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ya ligo Yesu kaꞌalo ma luto lu emiꞌehina: Ma bose. Hena hibe nolane? Kuyuꞌafu naniꞌiyasiba neleꞌmo ho tiꞌehigo kagatiti loko hoto yaga feꞌnohatiti guna ise bo nohube? ");
INSERT INTO bef_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ya luto luloto asaga boanatoga ma luto lu epiꞌehina: Lenali kaba hu bati hilo. Lenali kaba hu bati hite nehite moleꞌaleꞌnamuꞌi muyanaꞌnise lite melilo. Yaga feꞌnohaꞌa babu lito minana bouba ya feꞌnohi malanaꞌa huto komopaꞌa bebe mesalata nohibe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sipi bo moneuba meꞌaluguti noseꞌna babu luto hu moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","To ya higo ana sipi bouba komopaꞌagu ma luto ekesa yigiꞌehibe: Henaꞌni hilube? Nohaꞌni noseꞌna li nupa huto molose nohaꞌnimo kikipa habe. Henaꞌni hilube? ");
INSERT INTO bef_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","To ekesa yigito ma luꞌehibe: Ma hilube. Ana nopo tele bitoꞌni yuhufa nohi sipina gilotoꞌni noseꞌnaꞌni hiti feꞌnohaꞌni hiti yaguꞌi li malalube. ");
INSERT INTO bef_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","To yaloꞌi nipaꞌnigu ma luto lilube: Fokehi libo nipaꞌniyao. Noseꞌna hiti feꞌnohi hiti babu luto niꞌinagi yatai asaga foya kanagu fuli minalube. Fuli minotoꞌni to noseꞌna noba nobo hutoꞌni to yokoloꞌna huba huba huto minalube. Fokehi libo nipaꞌniyao. ");
INSERT INTO bef_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","To ana bouba ya ligo, Huꞌmau: Kai negi bo nohane, luto, kai yatai foluguꞌi fililataꞌmu yabe. Filito to felekamo kugufaka heꞌmito bilinaꞌmu yabe. To ya huto nofilitogomo, yaꞌmana li nupa hu moloꞌahatanamo kuyu kuyu hite lilabe? Huꞌmau ya luto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","To Yesu ma luto lu epiꞌehina: Nani yaꞌma lu nolepube. Ana huto asaga bonaꞌmo Huꞌmamofitoga hosapa ite nehana to enaliꞌani kumu salahi fiba fiba nehana bonaꞌmagi enali asagaꞌi ana bomofihi supo hite neminabe. To Huꞌmau enali hapaꞌani sibina niꞌigo bu goto ana huto ka epekilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","To Yesu panaꞌaloboꞌa lu epiloto ma luto luꞌehina: Nani lu nolepube. Lenali minosenatiniꞌmu lenekesa yigi babu melite to lenali ma melilo: Lali henana nalune? To lenali lenugufatiniꞌmu lenekesa yigi babu lilete ma lite melilo: Lali henanatuꞌi lugufatilo ifi talune? ");
INSERT INTO bef_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","To hetofana huto minoseꞌnauba noseꞌnamofihi hoto niꞌibe to kugufauba guketemofihi hoto maꞌnaka niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Namamagi lenubu galo. Enali noseꞌna hekelete noseꞌna li nupa hite to noseꞌna nohaꞌanifi to anaꞌinaꞌani malalana nohaꞌani meniꞌibe. Ya huꞌehinagi Huꞌmau noseꞌna epilata nohibe. To lenali Huꞌmamofihi bulo boanaꞌmagita namaya enehete enebe ligite nehabe. ");
INSERT INTO bef_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma nehana folagahatiniguti bo moneuba ekesa keheliba keheliba huto kufu kanaꞌa mone hiti lugufaba minomo buto minalina niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","To ana lagasoꞌna mone ya hite lolo menehanaloti hena hibe lite lenali fatoꞌnamu lenekesa yigi babu lilata nehabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lopi kifiꞌna taloꞌa tilata nehanamo hena hena hite tilata nehafi lenali bu galo. Enali liliꞌna lila to enali guketeꞌani lolo hila menehabe. Ya huꞌehinagi nani lu nolepuna. Koyapa bo Solomoniu sipi feꞌnoho bo minanaꞌa huto gukete manaꞌa li mehekolose kifiꞌna taloꞌa hetofaꞌamagi hanaꞌa huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huꞌmau aiꞌa kifiꞌnamagihi gukete hu epololata nohibe. Kifiꞌna malo yatai nehana yago bifa hilanaꞌmu yabe to logouba enoloboto su halinaꞌmu yabe. Faꞌmene kifiꞌnamolo Huꞌmau gukete nohu epalanamo ninago ana huto Huꞌmau gukete hu ketalinaꞌmu yabe. Ya huꞌehina Huꞌmamofihi keheli bati hite keheli emilenogo Huꞌmau ai leneleꞌmo bati hu lepalalinaꞌmu yabe. Lenalise, ka keheli uleꞌale huseꞌnatini nesiꞌasi minana boanaꞌi yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ya huꞌehinagi lenali lenekesa yigi babu lite hena noseꞌnati nalune lila to hena nagamiti nalune lila ya hite melilo. Lenali lenegekesa yigiba yigiba mehilo. ");
INSERT INTO bef_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Enali ma melugu fegutoga bonaꞌmagi asagaꞌnamu enegekesa yigi babu lilata nehabe. Ya huꞌehina Afotinifu anana anana lilana yaꞌmana yaꞌmana lilabe luto akeheliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yaꞌiyanaꞌmu lenekesa meyigise Huꞌmamofihi kapoꞌa lenugufa komopaꞌalo li kohe tete yataꞌa melelenogo ai Huꞌmau asagaꞌnamu lepesilinaꞌa hiti lepilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lenali lagaso nagaꞌnise, koli mehilo. Afotinifu aiꞌa kapoꞌa lepilunagihe luto kaga lu hetofa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lenali asaga feꞌnohatini bonaꞌi lugaꞌamagihi epinogo efahi ananalo lepilenogo akuꞌi ana efahi musufalo bonaꞌi epilo. To lenali kosaba guꞌi efahi li malalatamo analoꞌi sibina mehilinaꞌmu yabe. To lenali ifo muya yogo feꞌnohatini kokulumalo meminigilinaꞌmu yabe. To kokulumalugu guminalo bonaꞌi menehabe to efahatini sifolohi megilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lenali hetofa minaꞌa lenalitini niꞌilinalo ana hepato komopatini minalibe. ");
INSERT INTO bef_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lenali katatini li hupa mone hite hepite to gilimitini ilete to logo kokululu lite lele hite minalo. ");
INSERT INTO bef_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","To lenali bonaꞌi lugaꞌamagi kaba boꞌani heꞌmi epololoto ana gukete nehanaga buꞌehigo lele hite nehago kaba boꞌaniuba oto gelo bi epoloto enofokehi nohana suhi lite lenali minalo. Ya hite, geba kaba boꞌani hite nehago kaba boꞌaniuba oto kasito noigomo meleꞌisi kafe nekisi etabe. ");
INSERT INTO bef_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","To kaba boꞌaniuba oto koko pananaꞌa bu enagalina enubuꞌi mekese geba hite nehinogomo yalo ana koko panaꞌalobo enofokehi halabe. Nani lu nolepube. Sipi bouba aiꞌa kataꞌa li hupa mone huto hepilotoꞌa to gilimiꞌa iloto hitalo eneleꞌmo moloto aiꞌa noseꞌna gabu ito epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","To ai foluguꞌifi foluguꞌi kokole nogo memoloꞌehinogofi otomo koko pananaꞌa bu enagalina enubuꞌi mekeꞌehitemo enali yaꞌmana koko pananaꞌamuꞌi fokehi lilibe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","To ka mone hiti lipoti nolepugo yaꞌma kehelilo. To nohi afoꞌafu guminalo bouba oto nohaꞌaguti gumina lilina kanaꞌa keheliꞌohutomo ai heꞌmiꞌehigo nohaꞌaguti tito gumina lilata menohibe. To henaꞌmugope ai kaba gimi gito minolata nohigo yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Lenali hiti ana hite lele hite minalo. Kokulumaguti limiꞌehina Bo ana huto lenali lenekesa meyigise faꞌmene nehinogo yaꞌma kanagu alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitau ma luto Yesuhi lu emiꞌehina: Sipi Bo yaꞌmana kaga laliꞌisigo lu nolimipi to ma asaga bonaꞌi hiti lu limi baga noine? ");
INSERT INTO bef_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","To Yesu luꞌehina: Kaba bo mone ekesagu fe lina bo nohuto ai liliꞌnaꞌa kaba hu bati huto minoto to sipi boꞌauba kaba bo leꞌmo ho tiloto liliꞌnalo boꞌa noseꞌna li keheli epilifi? ");
INSERT INTO bef_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Alihi sipi boꞌa oloto koko panaꞌa bu galina koyapaꞌi lu etoꞌehinaꞌa huto nohutomo yaꞌmana koko panaꞌa gelo bilibe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nani maꞌnaka luto lu nolepube. Sipi bouba asaganaꞌalo ana bo kaba bo leꞌmo ho tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","To ya huꞌehina yaꞌmana koko panaꞌauba ma luto ekesa kehelilibe: Kaba boꞌni minoba minoba nohuto meleꞌisi menoabe, ya luloto ai lugaꞌa koko panaꞌa hiti luba hilete boanaꞌi asagaꞌi amuya nagamiꞌi nelete negi nagi nete minalabe. ");
INSERT INTO bef_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ya nehinogo sipi boꞌa oto bu galina lele mehuse nohinogo italuga logo binogo kai bati mehata koko panaꞌi yabe luto keye luto emitatuꞌi ibe laga hube huto nesi nesi huto kegeiyo hinaꞌmu luto heꞌmilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sipi boꞌamofihi hapaꞌa akeheliꞌehilina bo ai akuꞌi anaꞌinaꞌa leꞌmo lele mehuse kegeiyo huto sipi boꞌamofihi kaꞌa keheli meemise nohilina sipi boꞌauba ana koko panaꞌa osahi sipi halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","To liliꞌnalo bo moneuba sipi boꞌamofihi kaꞌa keheli bati menohina mone foipa huꞌehigo aiꞌi osahi nesiꞌasi fulu huto halinaꞌmu yabe. To Huꞌmau bonaꞌi monoꞌmofihi nasana epiꞌehinana enali akuꞌi babu lite analo molo emite epilabe. To boanaꞌi enali babu anaꞌina bo moneꞌmofihi yanugu melelata nehana alihi enali ananalo akuꞌi babu lito molo emito ana bouba epilata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nani ma meꞌi fiꞌmo suhi huto galube, luto limiꞌohuna yabe. To yaꞌmana fiꞌmo meleꞌisi ma melugu hololu luto lalifi luto nemehi nomolobe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nani mone fi taga huseꞌna nanitoga huto hilibe, luto nekesa noyugube, luꞌehina. Ya nohuna yatai ana fi taga huseꞌna su mehenogo sipi keta nonebesibe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lenali lenekesa neyigina nani ma melugu fuluna lito noabe lite nelafihe? Oꞌe, fuluna meniꞌibe. Nani boanaꞌi eneleꞌmo luga luga hilubeꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yatai hiti alihaꞌa hiti lalamehi nayahi mone kegiꞌa su hago moneko nonugu neminabe. Ya nehana loko hite loe nagaꞌi hilete loegi monegimagi loelo fatehaꞌani eteleꞌmo lolo nehinogo to loemaleꞌi loegi monegimagi eneleꞌmo fatehi hilana yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ya hite loko hilete afoꞌanifu pananaꞌa eneleꞌmo fatehi lolo nohinogo to panaꞌamagi afoꞌanifihi leꞌmo fatehi lolo hilabe. To itoꞌanifu paꞌa eneleꞌmo fatehaꞌa lolo nohinogo paꞌamagi itoꞌanifihi leꞌmo fatehi hilanaꞌmu yabe. To aꞌmofihi litoꞌafu leꞌmo fatehi nohinogo ana aꞌuba litoꞌafi leꞌmo fatehi hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu boanaꞌi hiti ma luto lu epiꞌehina: Lenali yege limi nofalanagati sopohi notinogo bu geletemo analo meleꞌisi ma lite lilata nehabe: Koꞌi ilubeꞌmu nohibe lite nelago analo koꞌi ilata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","To yofo kegiꞌati habafahi noagomo lenali yege lalubeꞌmu nohibe lite nelago analo mukoho luto yege lolata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lenali faga fagalo bonaꞌi. Lenali meꞌi hiti kokulumaꞌi hiti bu go bati hilete hena huseꞌna niꞌifi lite bu galo. Ya huꞌehina lenali hena hibe lite yatai kanamofihi hapaꞌa yaꞌma nani kumuꞌi bu go bati menehabe? Yesu ya luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","To hena hibe lite lenalitini lenekesa yigi bati hite to bati hina sukumu loko hite latahatinigu li fu lilata menehabe? ");
INSERT INTO bef_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","To bo moneuba ka foyagu keleꞌmo malalubeꞌmu keleꞌmoto nobinogomo kapoga nebite ana bo kaga leꞌmo bati huto moneꞌna lu emibo. Bonaka ka foyagu kefefe huto buto koti kaba bomofihi yanugu melenogo koti kaba bomagi keleꞌmete bite gimi bomagihi epinogo enali nagalugu leneleꞌmo mele lalabe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nani yatai lenaliꞌi lipoti lu nolepube. Lenali nagalugu minalana hepatogati meleꞌisi su mehalanaꞌmu yabe. Yataꞌa lenalitoga sipiꞌafi lagasoꞌafi efa lenaya heꞌahanana epi pa se su heletogo yabe, luto Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ana kanalo bonaꞌi lugaꞌa mineꞌahanamagi Galili bonaꞌi lugaꞌamagi Huꞌmamofitoga lokiya fi emite Pailatihi bomagi eneheꞌahana kaga Yesuhi lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ya nelago Yesu kaꞌanilo ma luto lu epiꞌehina: Lenali nekehelina yaꞌmana Galili bonaꞌi ya hite filinaꞌmu enali asaga Galili bonaꞌi enehete sipi foipa bonaꞌi nehabe lite lenekesa neyigifihe? ");
INSERT INTO bef_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oꞌe. Nani lu nolepunaya lenali foipanatini li meheꞌmilana lenali asagaꞌi enali hiꞌahana suhi lite fili su halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","To ma 18 bonaꞌi Siloami hepalugu yatama nohuba i tele bito limito enoho gehesa koyapaꞌi huꞌehinamoba lenali nekehelina asaga Yelusale boanaꞌi enehete foipa bonaꞌi nehafihe? ");
INSERT INTO bef_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oꞌe. Nani lu nolepunaya, lenali foipanatini li meheꞌmilana lenali asagaꞌi enali hiꞌahana suhi hite fili su halanaꞌmu yabe, luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","To Yesu bame ka mone ma luto lu epiꞌehina: Bo moneuba nemuya yafa foyaꞌagu hekoloꞌehina yabe. Mone yupahi legeyaꞌa hoꞌehifi luto buto bu ganamo mehoꞌehigo bu goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ya huloto foya kaba boꞌamofihi ma luto lu emiꞌehina: Kehelibo. Yatai loegi monegi kufu kanalo oto nemuya legeyaꞌa loꞌehifi luto bu nogonamo ana yafalo legeyaꞌa mehoꞌehibe. Kai yaꞌmu mana yafa hetigitogo limino. Henabe luto faꞌmene tiba tiba huto niꞌito meꞌi nogoyaꞌa no su halibe? ");
INSERT INTO bef_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Foya kaba boꞌauba ma luto sipi boꞌa lu emiꞌehina: Sipi bo, kai yatai kufugu moneꞌa heꞌmitogo niꞌinogo nani ana yafa hapaꞌagu keꞌmuya kifiloto kifiꞌna pata sito foba huꞌehilina ana hapaꞌalo molo bego hilube. ");
INSERT INTO bef_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ya huꞌehinogo mone kufu kanagu legeyaꞌa halifi bu goloto menohenogomo kai ana yafa hetigilane, luto foya kaba boꞌauba sipi boꞌamofihi lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mone fuli yupahi Yesu mono nonugu minoto bonaꞌi mono ka lu enelepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ya hinalo aꞌi mone foipa feleuba besiseꞌna leꞌmo gufalo malago 18 kufuꞌa minoꞌehina aꞌi minoꞌehina. Ana aꞌi asaga yupahi koliꞌali huto ho tito humofaꞌna mehuse minolata nohina aꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu ana aꞌi bu goloto kehe i emito ma luto luꞌehina: Aꞌise, kai kebesiseꞌnaka ali noheꞌmi ketobe. ");
INSERT INTO bef_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ya luloto Yesu ana aꞌmofihi gufalo yahi ligo analo meleꞌisi besiseꞌna heꞌmi etago ana aꞌi ho ti fefe luloto Huꞌmamofihi giꞌa li saga huto fokehi hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","To mono noto kaba huꞌehina bouba ya huto Yesu ana aꞌi fuli yupahi leꞌmo bati hinaꞌmu luto ipagu logo loꞌehina. Ya higo ma luto asaga boanaꞌi lu epiꞌehina: Liliꞌna lise kanaꞌa loegi loegi loegi yupahi minolata nohune. To lenali lenebesiseꞌnatini li heꞌmi lepalalabe litemo liliꞌna lilata nohuta kanalo elata hilo. Ya huto lepesiꞌehinogomo fuli kanagu mealo luto, mono nohi kaba bouba luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ya ligo Yesu kaꞌalo ma luto lu emiꞌehina: Lenali fagalo bonaꞌi yabe. Fuli kanaꞌalo lenali asagaꞌi toki yagatini naga iꞌahanati gulu fete eneleꞌmete bite nagamiꞌi epilata nehana yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya huꞌehina yatai ma aꞌi Abalahahi tataꞌafu yabe. To Satau kufu kanagu 18 leꞌmo naga iꞌehina yabe. Ya huꞌehina fuli kanalo nani ana nagaꞌi ya li gulu noho etobe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya luto Yesu lulago Yesuhi kaꞌauba fatehaꞌa bonaꞌi enubuya sipi higo lipite nehago lugaꞌamagi asaga Yesu Yesu hetofana hinanaꞌmu lite enegelo bite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu luꞌehina: Huꞌmamofihi Kapoꞌa hena suhi luto niꞌibe luꞌehina? Henana hiti eteleꞌmo legege hilube? ");
INSERT INTO bef_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ai noseꞌna moneꞌmofihi kitili legeyaꞌa legi huto niꞌibe. Bo moneuba ana yafa legeyaꞌa lito buto foyaꞌagu he kofolenogo anana hofa toto yafa legi huto tilenogo ana yafa musaꞌalo namamagi nohaꞌani gilata nehabe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Akuꞌi Yesu enoloka hoꞌehina: Henana hiti Huꞌmamofihi Kapoꞌa li legege hilube? ");
INSERT INTO bef_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aꞌi moneuba beleti noseꞌna lolo nohuto yisiti ana falaꞌualugu heꞌmi lago ana beleti hofa toto yeye bito notina suhi huto Huꞌmamofihi Kapoꞌa sipi huto hilinamo niꞌibe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","To Yesu sipi hepaꞌifi lagaso hepaꞌifi ninalo bula ola huto boanaꞌi mono kaga lu epimo lu epimo Yelusale hepatoga bilubeꞌmu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ya nohigo bo moneuba ma luto Yesuhi lu emiꞌehina: Sipi bo, Huꞌmau bonaꞌi loeꞌasi eneleꞌmalina niꞌifihe? Ya luto loka hago Yesu ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Lenali felisatini li amuya melete minalana Huꞌmamofihi hepatoga bilana kapogu kitiliꞌa folo hokolo hite bilanaꞌmu yabe. Nani lu nolepube. Asaga bonaꞌi ana hite ana kapogu folo hokolo hite tiluneꞌmu hilanaya folo hokolo hite metilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Alihi nohi afoꞌafu ho tiloto kafe li hekini lolenogo lenali fegutoga ho tilete nehite kasito begele begele hiba hiba nehite: Kafe sigi letobo, nelinogo nohi afoꞌafu ma luto lilinaꞌmu yabe: Lenali hiyaꞌagati neana bonaꞌi nehabe? Nani lenaliꞌi mekeheli lepoloꞌohuna bonaꞌi nehabe luto lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nohi afoꞌafu ya nolinogo lenali akuꞌi ma lite lu emilanaꞌmu yabe: Kai laliꞌi hiti noseꞌna noloto hepatigu mono ka lu limiꞌahatamo yabe lite lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ya nelinogo nohi afoꞌafu akuꞌi ma luto lu lepilinaꞌmu yabe: Lenali hiyaꞌagati eꞌahafi nani mekeheli lepoloꞌohube. Lenali foipa hise fagalo bonaꞌi bifa hilo, luto nohi afoꞌafu lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","To Abalahau Isakau Yakopu to asaga lu yege hose bonaꞌi Huꞌmamofihi hepaꞌalo nehinogo lenali bu gelete lenali fegutoga minalanaꞌmu yabe. Ya nehinogo lenali sipi yibi hite lenabaga yogoꞌalo heni heni hite minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","To boanaꞌi yege notinagatifi yege limi nofalanagatifi to luga luga yofo kegiꞌatifi li nupa hi su helete Huꞌmamofihi hepaꞌalo minete noseꞌna nete minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yatai bonaꞌi alihi neana enali yataꞌa neenogo to bonaꞌi yataꞌa yatai neana enali alihi alanaꞌmu yabe, luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ana yupahi Felosi bonaꞌi lugaꞌamagi ete ma lite Yesuhi lu emiꞌahana: Helotiu kahalubeꞌmu nohinagi kai ma hepaꞌi heꞌmito fotoꞌi fatoga bubo, lite lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kaꞌanilo ma luto lu epiꞌehina: Lenali bite yaꞌma lopi kalamofihi lu emilo: Nani foipa fele enoho lifi heꞌmila to bonaꞌi eneleꞌmo bati hula huto yatai nohuna to yago akuꞌi ana hilunaꞌmu yabe. Ya huloto yege loebe monebe nehinogo liliꞌnaꞌni su halunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ya huꞌehina yatai hiti yago hiti to ologo hiti nani kapo moloto Yelusale hepato bilunaꞌmu yabe. Henaꞌmugope bo mone hete enali fato hepato memalabe. Enali Yelusale hepatoko he fili melelata hiꞌahana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ke, Yelusale nagaꞌise. Yelusale nagaꞌise. Lenali lu yege hose bonaꞌi enehela to Huꞌmau enoho lifigo kaitoga elata hana bonaꞌi efa kosahi heꞌmi melete enehelata habe. Henaki yupahi nani keleꞌmo namanuga asaga yupahi malalube. To kokole itoꞌafu nalaꞌa eneleꞌmo kokeꞌnaꞌaluga mololata nohibe ya suhi luto yabe. To lenali heꞌmi netenogo lenaliꞌi leneleꞌmo namanuga memalalunaꞌa habe. ");
INSERT INTO bef_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yatai Huꞌmau yaꞌmuꞌi kehelito hepatini aheꞌmi su hoꞌehibe. Nani lu nolepube. Lenali naniꞌi bu menegese nehite alihi Sipi Bomofihi giꞌalo noana bomofihi lenegelo bi emilanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mone yupahi fuli kanagu Yesu sipi bo Felosimofihi hepato buto noseꞌna nalubeꞌmu nohigo asaga bonaꞌi ana nonuga minana Yesuhi mapahi fiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bo mone gi yahi hofa tago nominana bo Yesu nohina nonuga tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Keya ka lu epise bo to Felosi bomagihi Yesu ma luto enoloka hoꞌehina: Mono fuli kanagu bati huto bonaꞌi eneleꞌmo bati hilina niꞌifi ya hilina meniꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ya ligo ana bonaꞌi enali kaga mone meliꞌahana. Yesu ana bo gufaꞌa leꞌmo bati huloto heꞌmi etago buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ya huloto ma luto lu epiꞌehina: To bo mone lenali folagahatiniguti panaꞌafi to bulumaka moneꞌafi fuli kanalo kelimogu limilina ana bouba buto fuli kana niꞌibe luto meleꞌisi leꞌmo saga mehilina niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","To enali ana bonaꞌmagi Yesu enoloka hana kaꞌalo nonaꞌa lu emilana bati mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Asaga bonaꞌi ana nonugati ete noseꞌna naluneꞌmu ana bonaꞌi enali yataꞌa siatoko minaluneꞌmu hago Yesu bu enogoto bame ka mone ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mone yupahi ana gukete hite sipi noseꞌna naluneꞌmu kehe neinogomo lenali hetofa hepaꞌi lite minelata mehilo. Kibina bo moneꞌmofihi ana gukete noseꞌnalo kehe iꞌehilanaꞌmu lenali ai hepaꞌa li lalabe. ");
INSERT INTO bef_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lenali ya hiꞌehinogomo ana sipi noseꞌna nogoto lenali kehe ilina bouba ma luto lu lepilinaꞌmu yabe: Lenali yaꞌma hetofa siaꞌi ma bomofihi emilo. Ya linogo lenalitoga sipi lenubuya hinogo asaga bona enemegesaga melugu bite minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ya huꞌehinagi lenali bo moneuba ana gukete huloto sipi noseꞌna nogoto lenaliꞌi kehe noinogomo lenali kasitoga bite melugu minalo. Ya nehinogo nohi afoꞌafu ma luto lilinaꞌmu yabe: Nalaluꞌniga, kai malo oto siaꞌi hetofaꞌalo minobo. Ya linogo asaga bona enubugu kegelo bito minalataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","To bo moneuba ti saga huto nohuto giꞌa li saga hilina Huꞌmau leꞌmo laba huto leꞌmo lagaso bo lolo nohuto to, bo mone laba huto minoto agoya bo minalina Huꞌmau sipi bo leꞌmo lolo hilinaꞌmu yabe luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","To ana noseꞌna laita hinalo kehe igo ana bonaꞌi Yesu ma luto lu emiꞌehina: Kai fuligaha noseꞌnafi to utehe noseꞌna epilubeꞌmu nohanemo kalalukagihifi to kai kalamehakafi to yogo feꞌnohaꞌani babu lina bonaꞌi enaligo kehe ilata mehubo. Henaꞌmube? Enali alihi ana hite noseꞌna go noeputa nonaꞌa gete kimilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","To kai noseꞌna goto nalubeꞌmu nohanemo musufalo bonaꞌifi gi yahi filiꞌehina bonaꞌifi enigigusa sibina huꞌehina bonaꞌifi to enubu pisi luꞌehina bonaꞌi yaꞌma kehe ito noseꞌna efahi goloto epito nalo lu epilane. ");
INSERT INTO bef_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enali yaꞌmana bonaꞌmagi noseꞌnaka nonaꞌa gete mekimilinaya kai alihi kegelo bilanaꞌmu yabe. Henaꞌmu kegelo bilabe? Alihi Huꞌmau bulo bonaꞌi bati hite mine filiꞌahana to ti su nehenogo Huꞌmau ana noseꞌnakalo minaꞌa kimiloto pa salinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","To ana noseꞌnalo gehesa hiꞌahanamagi moneuba kehelito Yesuhi kaꞌalo alu emiꞌehina: Huꞌmamofihi Kapoꞌalugu noseꞌna naluneꞌmu nehite li gehesa hilanamagi enofokehi lilanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ya luꞌehigo Yesu ma luto bame ka lu emiꞌehina: Bo moneuba sipi noseꞌna laita hilubeꞌmu nohuto yege yege bonaꞌmo elesa moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","To laita nohina yupapogu kele kele panaꞌa ho lifigo, buto kehe iꞌehina: Alo. Alo, luto, noseꞌna li nupa hunogo nalanagi alo, luto lu epigo, enali asagaꞌi: ");
INSERT INTO bef_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Oꞌe. Mebilune, ai ya ligo ai ya ligo enipaꞌani nehite soya ka ana kele kele panaꞌamofihi lu emite fato fato ka lu emiꞌahabe. Mone: Ke. Meꞌmo mone yuhufasi mina fiꞌohunagi yaꞌma buto bu galubeꞌmu nohube, luto lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","To mone: Ke. Bulumaka yagamo nayahi luga luga su hago yuhufasi mina fiꞌohuna yabe. Foyaꞌnigu meꞌmo kifiseꞌna kefefe hite meꞌi lilabe luto mina fiꞌohunagi buto babeyafa hilubeꞌmu nohube, luto lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","To mone: Ke. Aꞌi yuhufasi kata huꞌohunagi yaꞌmu mebilubeꞌmu nohube, luto lu emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ya lite lago, kele kele panaꞌmo i behe huto buto afoꞌafihi yaꞌma kagaꞌani asagaꞌna lu emigo, ai ipaluga logo bigo luꞌehina: Kai meꞌme huto buto hepatoga buto lagaso hepaꞌmo hiti sipi hepaꞌmo hiti sa sa hutoka fato bonaꞌmo enelemoto obo. Keneꞌi nehana bonaꞌi hiti enayahi sibina huꞌehina bonaꞌi hiti enubu pisi luꞌehina bonaꞌi hiti to enigigusa sibina huꞌehina bonaꞌi hiti sa sa huto eneleꞌmoto obo, luto lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","To ya ligo kele kele panaꞌa buto ana huloto oto: Afoꞌniga, yaꞌma lu nimiꞌahatana to hepaꞌi keleko moneꞌi hibe, luto lu emigo ");
INSERT INTO bef_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","afoꞌafu ma luto lu emiꞌehina: Kai akuꞌi buto olopa me kapolo hiti to kifigu hiti analoꞌi sa sa huloto maloꞌi eneleꞌmo kefefe huto hepaꞌni leꞌmo kikipa halabe luto eneleꞌmoto obo. ");
INSERT INTO bef_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","To kaꞌni mone lu nokumuna keheliꞌohubo. Enali yataꞌa elesa moloꞌohunamofihi bonaꞌmagi enogomo meepilunagihe. Noseꞌnaꞌni menalabe luto noluna yabe. Yesu ya luꞌehina bame ka yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Babu boanaꞌi Yesuhi megeꞌi lifite nebago Yesu i behe huto ma luto ana boanaꞌi lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Bo moneuba nanitoga oꞌehilinaya ai itoꞌagi afoꞌagi etaliꞌagi to gonamu tamuꞌa to aiꞌa mehaꞌamofi gufaꞌamofi yaꞌma enalito megesa hu meepiꞌehilina ai ana bouba nani koko panaꞌni lolo mehilinaꞌmu. To ana huto aiꞌa gufaꞌa laga besilina bonaꞌi nani koko panaꞌni lolo mehilinaꞌmu. ");
INSERT INTO bef_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","To bo moneuba ai malipu yafaꞌa kofiloto naniꞌi nemegeꞌi memalalina nani koko panaꞌni lolo mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","To bo mone lenali folagahatiniguti ai yatama yatama nohi gilago tilube lutomo ai yataꞌa ana noto minaꞌa heꞌmilinaꞌamu melugu minoto yakiꞌa heꞌmito ana nohi gilunagi luto ekesa yigi bati hulata nohibe. Ai ekesa yigiloto henakiꞌa efatuꞌi ana nohi gi baga ilufi luto kehelilata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","To ai ekesa yigi bati mehuse hagulu hagulu tito ana nohi kefa hisa lolo huto mololoto efahi su nohenogomo heꞌmiꞌehigo kifi noligigo bila ela nehana bonaꞌmagi ana bomofihi kiyaꞌa hi eteme bila ela hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ya nehite ma lite ana bonaꞌmagi lilata nehabe: Ma bouba nohi gilufi luto gi hapi finaya ana nohi gi baga meibe lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","To gihiti bo moneuba fato gihiti bo hiti luba hiluꞌibe luto bilubeꞌmu nohutomo ai minoto ma luto ekesa yigi bati huto ma luto nolibe. Nani gimi boꞌni 10 tauseni eneleꞌmoto nobinogoꞌnimo ai fato gihiti bouba 20 tauseni gimi boꞌa hiti eneleꞌmoto alinaꞌmu keheli bati huloto ma luto lulata nohibe. Ai yaꞌmana 20 tauseni gimi boꞌa nehana gihiti bouba naniꞌi nohoto neleꞌmo heꞌmilifi luto yataꞌa ekesa yigi bati hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","To ai gimi boꞌa babu lite menehagomo ai amuya molo fato gihiti bo halunaꞌa huto menohube lulotoꞌa fatehaꞌa fotoꞌi nohigo luba mehiluꞌina akuꞌi fulu hiluꞌibe luto kaga leliꞌali bolo kaga heꞌmi etago bulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu ana kagaꞌa lu baga iꞌehina: Ana suhi huto mone bomaka asaga yogo feꞌnohaka kemegesa hu emiloto ya suhi meminalata nani koko panaꞌni lolo mehilataꞌmu yabe luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hegemoya batiꞌna niꞌinaꞌmu to lenali hegemo legitana nehabe. To hege lagaꞌa fenene hilina akuꞌi enali hena hinogo hege bati huto lagaꞌa hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yaꞌiya hina hege foyagu tili hilana foya leꞌmo bati mehilinaꞌmu yabe. To yagamagihi siꞌani hiti li nupa mehilata nehabe. Faꞌmene li heꞌmilata nehabe. Lenali yalo kehelilo, lenali lenekesa niꞌinogomo keheli bati hite kehelilo, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mone yupahi takisi nelina bonaꞌi hiti to kaꞌi leli nehana bonaꞌi hiti Yesu nohinalo ete ai kagaꞌa linalo kehelite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ya nehago Felosi bonaꞌi to keya ka tisa bo bu gelete gulu gulu bite ma lite Yesuhi ka emekiꞌahana: Ma bouba ai foipa bonaꞌi hiti eneleꞌmo bati huto enali hiti noseꞌna nolata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ya lite lana kagaꞌani Yesu akeheliloto bame ka mone ma luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Lenali bonatini moneuba sipisipi yagaꞌa babu lite 100 nehago to mone fenene hinogo, hena nohibe? Sipisipi yagaꞌa yege yegeꞌna holupa hepatoga eneheꞌmito yaꞌma fenene huꞌehinamofihi buto sa sa nohibe. ");
INSERT INTO bef_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","To sa sa huto bu goba bu goba hutoꞌa to etafa huloto fokehi nolito nu nokibe. ");
INSERT INTO bef_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ya huloto kofito buto to hepatoga nehetilotoꞌa faluꞌagi hiti to bonaꞌagi kehe noibe. To neenogo ma luto lu epibe: Sipisipi yagaꞌni fenene huꞌehinana huto higo leꞌmoto oto lenali hiti nani hiti legelo bilunagihe. Ya luꞌehina kiliheꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","To nani ana huto ma luto lu nolepube. Foipa bo moneuba foipa hapaꞌa heꞌmito to komopaꞌa i gelehe hinogomo ifo muya nehanamagi kokulumalugu gofana hite enegelo bilanaꞌmu yabe. To bonaꞌi yege yegeꞌnamagi hapaꞌani batiꞌna niꞌina to komopaꞌani i gelehe mehise nehinogomo, enali kumu kokulumalugu yege nesiꞌa filabe. To foipa bouba, ai foipa hapaꞌa heꞌmito, to komopaꞌa i gelehe hinogomo, lusina hite enegelo bilanaꞌmu yabe. Yesu ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","To mone hiti niꞌigi aꞌi moneuba siliba efahaꞌa 10 moloꞌehina. To mone fenene hinogo, hena nohibe? Ai libiꞌmo fulu kulu tiloto lito buto nohaꞌa asagaꞌi lito sa sa nohibe. ");
INSERT INTO bef_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","To sa sa huba huba hulago alihi efahaꞌa huto hinogomo, giꞌaꞌagi hiti bonaꞌagi kehe ito ago ma nolibe: Lenali nanilo li nupa hitemo legelo bilune. Efahaꞌni fenene higo, yatai bu goto nolube. Ya luꞌehina kiliheꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","To nani ana huto, ma luto lu nolepube. Foipa bouba sibi hapaꞌa heꞌmito to komopaꞌa i gelehe hinogomo, Huꞌmamofihi agelomagi yaꞌma bomofi kumu yege filanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ka mone hiti luꞌehina: Bo moneuba panaꞌi loemo eteketoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","To nehite gonaꞌauba afoꞌafihi lu emiꞌehina: Apaobe. Alihi nimilata nasana yatai nimibo. Ya luto ligo afoꞌatitifu anaꞌinaꞌa kita huto fuku luto etimiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","To ya hulago gonaꞌauba kana loemofi moneꞌafi minoto akuꞌi anaꞌinaꞌa li gu ito kofiloto foto hepatoga buto minoꞌehibe. Ana hepatoga nohutoꞌa foipa hapaꞌa huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","To efahaꞌa asagaꞌna ana hapaꞌalo heꞌmiba heꞌmiba huto meleꞌisi su hoꞌehibe. To ana hepato sibi kanaꞌa niꞌigo noseꞌna fenene huꞌehina yabe. Ya higo ana panaꞌmo efahaꞌa menina keneꞌi nohuto kauꞌna hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kauꞌna nohoto buto ana hepato bonaꞌmo moneꞌa hiti minoꞌehibe. To yaꞌma bouba ana panaꞌmo ho lifigo yaga hepatoga buto yaga maya epilata huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","To bonaꞌmagi noseꞌna meemise nehago yagamagihi noseꞌna nalube luto ekesa kehelito anana bati huto natitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","To alihi ekesaꞌa hokolo higo ma luto luꞌehibe: Ke. Afoꞌnifihi liliꞌnalo bonaꞌmagi henakiꞌa noseꞌna nelete moneꞌa neheꞌmibe? Asagaꞌi ya nehanagi to nani kauꞌna gofa nonahago mana hepatoga nofulube. ");
INSERT INTO bef_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma hilube. Ho titoꞌni buto afoꞌnifuloga buto ma lu emilube: Ke. Afoꞌnigabe. Nani Huꞌmamofi kumu to kai kumu foipana huꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya huꞌohunagi kai yatai panaꞌni yabe, luto nigi mehalataꞌmu yabe. Liliꞌna panaka neleꞌmalataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ya luto ho tiloto kapo moloto afoꞌafuloga bibe. To fotoꞌi noago afoꞌafu bu goto sipi ginaga nofigo hololu luto buto nu kito soso hu etoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","To panaꞌauba ma luto luꞌehibe: Ke. Afoꞌniga, nani Huꞌma kumu to kai kumu foipana huꞌohunagi kai yatai panaꞌni yabe, luto nigi mehalataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ya ligo afoꞌafu liliꞌnalo bonaꞌa kehe ito ma luto lu epiꞌehina: Meꞌme hite bite laga hina kata lite ete hepi etalo. To sahi yahaꞌalo bilinaꞌa, to suꞌmo gigusaꞌalo bilinaꞌa lite ete emilo. ");
INSERT INTO bef_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","To bulumaka yaga noseꞌna emiꞌohuta yaga bite keye lite laita hilo. Lofokehi hilutagihe. ");
INSERT INTO bef_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yaꞌma panaꞌnimo filiꞌehina legita minoto akuꞌi nohibe. To fenene huto minoto yatai akuꞌi huto huꞌehibe. Ya ligo enali hapi fite noseꞌna nenete enegelo nebite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","To olopa panaꞌa foyagati noago enali nama nelite to melekehi neite nehago kehelito, ");
INSERT INTO bef_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","liliꞌnalo panaꞌi moneꞌamofihi kehe igo ago ma loka hoꞌehibe: Enali henabe lite ya nehabe? ");
INSERT INTO bef_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","To ai ma lu emiꞌehibe: Kogonaka aꞌoto nohibe. To afokafu panaꞌni bati huto nohibe, luto yege nofito bulumaka yagaꞌa noseꞌna emiꞌohutana keye luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ya ligo olopa panaꞌuba ipaꞌagu logo bigo okaba huto anagu metise nohuto fegutoga siko huto minoꞌehina. Ya huꞌehinaꞌmu afoꞌafu limito: Atibo, atibo, ligo, ");
INSERT INTO bef_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ana panaꞌuba afoꞌafitoga ma lu emiꞌehibe: Abo. Kaika liliꞌnakalo foya kana babu luto minoꞌohuna yabe. To kaikamo kehelito minotoꞌni akili mehuꞌohunagihe. To kaimo meme yaga mone, lagasoꞌasi mone, menimise minoꞌahata yabe. Nafaluꞌnifu hiti noloto yege fititaꞌmu yabe. Menimise minoꞌahatagihe. ");
INSERT INTO bef_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","To akuꞌi yaꞌma panaka kapo anaꞌmo hiti efahaka heꞌmi su hoꞌehina panaꞌmo ai ago bulumaka yagaka noseꞌna emiꞌohutana ai kumu keye luꞌahatagihe. ");
INSERT INTO bef_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ya ligo afoꞌafu ma lu emiꞌehibe: Panaꞌni. Kai hiti asaga yupahi nohuꞌibe. To anaꞌinaꞌni asagaꞌi kaiꞌnaka niꞌinagi yege panaꞌni nohatagihe. ");
INSERT INTO bef_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","To yaꞌma kogonaka filiꞌehina legita minoto yatai nohibe. To fenene huto minoto yatai huto huꞌehibe. Ya huꞌehinanaꞌmu lali bati huto yege fito lofokehi nolune, luto luꞌehina. Yesu ya lu epiꞌehina kiliheꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu koko pananaꞌa ma luto lu epiꞌehina: Feꞌnoho bo mone minolata hina bomofihi kaba boꞌa mone minolata huꞌehina yabe. Ya higo bonaꞌi lugaꞌamagi ana feꞌnoho bomofihi ma lite lu emiꞌahana yabe: Kaba bokauba efahakamo heꞌmi su nohabe. ");
INSERT INTO bef_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ya lago ana feꞌnoho bouba kaba boꞌa kehe iloto ma luto loka hoꞌehina: Hena huꞌahanogo kai kaga yaꞌma nokehelube? Kai asaga feꞌnohaꞌni maꞌasi buto leka so su holoto fayahi go molo su ho netobo. Kai akuꞌi asagaꞌna naniꞌnilo kaba bo yatai meminalaneꞌmu nolube. ");
INSERT INTO bef_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ya luto feꞌnoho bouba ligo ana kaba bouba ma luto luꞌehina: Nani sipi boꞌniuba liliꞌnaꞌniloti aꞌneleꞌmo heꞌmilubeꞌmu linogo nani henaꞌni hilube? Nani amuya moloto keꞌmuya mekifila to fato bonaꞌi noseꞌnaꞌmu kehe iluna nubuyaꞌni hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya huꞌehina yatai nekesa moneꞌya noyugube. Liliꞌnaꞌniloti sipi boꞌniuba neleꞌmo heꞌminogomo bo moneuba nohaꞌaluga neleꞌmo bati huloto neleꞌmo bilina bomofihi nonuga bilube. ");
INSERT INTO bef_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yalo ai asaga bonaꞌi sipi boꞌamofihi efahi tina hiꞌahana bonaꞌi moneꞌisi moneꞌisi kehe iloto yataꞌa bomofihi henaki sipi boꞌnimofitoga tina huꞌahane? ");
INSERT INTO bef_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nani 100 mesebe kopo liꞌohube lilinaꞌmu yabe. Ya linogo kaba bouba tinaꞌalo tiketi noemito meleꞌisi malo minoto 50 yabe luto gobo, luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","To mone bomofihi loka hoꞌehina: Kaibe, kai henaki tina huꞌahane? Mone tauseniꞌa kile guꞌi liꞌohube. Tinalo tiketika malo nolito 800 yabe luto fayahi gobo, luto kaba bouba lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","To alihi sipi bouba ana kaba bomofihi bu goloto yege fiꞌehina yabe. Henaꞌmugope ai latahaꞌanigu bebe sana bonaꞌmagihi suhi liꞌehina. Ma melugu bonaꞌmagi enali ya huse bonaꞌi hiti liliꞌna moneka lilana, enali Huꞌma ka megeꞌi nemalana bonaꞌi enahalanaꞌmu yabe. Guminalo hapaꞌa yaꞌma keheli bati nehabe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nani lu nolepube, luto Yesu mone hiti ma luꞌehina: Lenali bati mehina efahi ma melugu nina hiti lenali bonaꞌi eneleꞌmo bati hite eneleꞌmo lenalalutinigi eneleꞌmo lolo hilafiye? Oꞌe. Ya hilenogo alihi efahi lise kanaꞌa su halina yupahi lenali leneleꞌmete kokulumatoga minoba minoba hepato bilanafiye? Oꞌe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","To bo moneuba nesiꞌnasilo kaba huto hilinamofi to amuya moloto kaba hu bati hilina alihi sipina huto hilinalo ana huto kaba hu bati hilinaꞌmu yabe. To bo moneuba nesiꞌnasilo kaba hu bati mehilina ana huto sipina huto hilinalo kaba hu bati mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ma melugu batiꞌnaꞌa kaba hu bati mehilata alihi kokuluma hepalugu lusi batiꞌnaꞌa hena huto kaba hilana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","To kai bo moneꞌmofihi efahaꞌafi feꞌnohaꞌafi kaba hu bati mehilata yanaꞌmu kai efahakafi feꞌnohakafi kuyuꞌafu kimilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sipi bo loemaleꞌi liliꞌnaꞌatiti moneko bouba lilinaꞌa huto meniꞌibe. Moneꞌmofihi ipakafa nohoto moneꞌmofihi fokehi halinaꞌmu yabe. To moneꞌmofihi leꞌmo bati nohuto moneꞌmofihi leꞌmo hale hilinaꞌmu yabe. Lenali moneko kumu Huꞌmamofihi nasanaꞌa leꞌmo bati nehite efahi leꞌmo bati nehite mehilanaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Felosi bonaꞌmagi asaga kaga Yesu lina kehelilete kiya hi eteꞌahana yabe. Henaꞌmugope enali efa kumuꞌi batiꞌnati yabe lite li enogolagalo nemalana bonaꞌmagi yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu ma luto ana Felosi bonaꞌi lu epiꞌehina: Asaga bomagihi enubulo lenali bati huꞌohuta bo nohune lite lilata nehanaya Huꞌmau komopatinigu bu go fulu tuto abu goꞌehibe. Bonaꞌmagi enali hetofa feꞌnohati yabe lite li pili kete minelata nehananaya Huꞌmamofihi bulo kisilito tuguma bito bati mehinana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosehi keya kagaꞌa hiti to lu huto huto bonaꞌmagi kaga keyeꞌahanana hiti Yonihi kanalo mino bati huꞌehina yabe. Ya huꞌehina Yoniu minana kanaꞌaloti oto oto yatai yaꞌma yupahi Huꞌmamofihi ka lamanaꞌamofihi kapoꞌa asaga hepatoga huto nohibe. Ya nohigo asaga bonaꞌi amuya melete peninite Huꞌmamofihi ana kapoꞌalo li hokolo hite biluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alihi kokuluma hiti meꞌi hiti su hoto bilinaya keya kaꞌa nesi kasi hupamoneꞌi mone ninaya su hoto mebilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bo moneuba lihaꞌa noheꞌmi etoto fato aꞌi lihaꞌa lilina ai bo alobo sibi sibina higo foipanaꞌa nominabe. To bo moneuba lihaꞌa leꞌmo heꞌmiꞌehilina fato bouba lihaꞌni yabe luto lilina ai ana bouba sipi foipanaꞌa li huto hulata nohibe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bo moneuba efahaꞌa babu luto niꞌigo ai asaga yupahi hetofa gu kata hepilata huto to hetofa hatofa noseꞌna babu luto nolata huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","To, kasihaꞌalo bo mone giꞌa Lasalasi, analo kolata huꞌehina yabe. Ai keneꞌi nohuto to gufaꞌalo hepuhi babu luto loba loba huto minoꞌehibe. To keneꞌi nohuto to kauꞌna nohoto ana sipi bomofihi noseꞌna letuhaꞌa bati huto natitaꞌmu yabe. To anaga nokago kalamagi ete hepuhaꞌa kehe nenete mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ya huto minolotoꞌa alihi fililago agelomagi leꞌmete bite Abalaha koyapa filito buꞌehina hepatoga leꞌmete bago Abalahau ai nu kito minoꞌehina yabe. To, alihi yupahi ana sipi fenoho bomo ai ana huto fililago keli heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","To ai logo hepaꞌmo aiꞌa Hete hepaꞌi anaga buto gabu sipiꞌa nogigo ya nohuto hiha luꞌehina: Akae. Akae, luto minoloto bu go saga hutoꞌa Abalaha fotoꞌi nohuto Lasalasihi nu kiꞌehinalo bu goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","To, bu nogoto kehe ito ma luꞌehibe: Oho. Abalahao, afoꞌnigase. Kekeꞌi nolu netobo. Kai Lasalasi ho lifigo ai yahaꞌa nagamilugu mololoto kenetufaꞌniloga mololenogo ketipa ilinaꞌmu yabe. Nani mana logo guluya meꞌmogu nagabuꞌni sipi nogigo nohunagihe. ");
INSERT INTO bef_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","To Abalahau ma lu emiꞌehibe: Panaꞌni. Koyapa hapaka beto hubo. Kai koyapa anaꞌinaka hetofana babu luto niꞌigo, kofokehi luto minoꞌahata yabe. To Lasalasi ai koyapa keneꞌi nohuto sibina huto minoꞌehina yabe. To yatai ai bati huto nohigo to kai kagabuꞌi nogigo nominane. ");
INSERT INTO bef_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","To lali hiya huto keheꞌmalune. Folaganugu mone sipi yabaꞌmo niꞌigo bo moneuba lali kegiꞌagati kaitoga bilina kapo meniꞌibe. To ana huto kai beletogati lalitoga alina mone meniꞌibe ");
INSERT INTO bef_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","To Abalahau ya ligo ai ma luꞌehina: Ke. Afoꞌnigase. Yalo Lasalasi afoꞌnifihi hepatoga ho lifibo. ");
INSERT INTO bef_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nani nogonaꞌni 5 magi nehana. Enali yaꞌmana gabuꞌi gise hepatoga mealabe luto Lasalasiu lipoti epilina niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ya ligo, Abalahau kaꞌalo nonaꞌa lu emiꞌehina: Henabe luto ho lifilube luto, mono buku niꞌibe. Moseu koyoꞌehina ka hiti, to Huꞌmamofihi ka lu huto hulata bonaꞌmo keyeꞌahana ka hiti niꞌina yabe. Ana kaga kehelilanaꞌmu yabe, ligo ");
INSERT INTO bef_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ai: Oꞌe. Abalahao, afoꞌnigase, mekehelilabe luto, to bo mone filiꞌehina bouba akuꞌi anagati ho tito buto kaga lu epinogomo ka kehelite komopaꞌani i gelehe hilanaꞌmu yabe, ligo ");
INSERT INTO bef_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ai: Oꞌe luto, enali koyapa koyoꞌehina kagamo mekehelise nehanagi to ana huto filiꞌehina bo moneuba filiꞌehinagati ho tito buto kaga lu epinogomo kaꞌa ana hite mekehelilanaꞌmu komopaꞌani uleꞌale hite minalabe, lu emiꞌehina. Yesu ya luto luꞌehina kiliheꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu koko pananaꞌa lu epiꞌehina: Asagaꞌna fato fato ninauba huto hulenogo asaga boanaꞌi foipanagu eneleꞌmo malalina huto huꞌehina yabe. Ya huꞌehina enaliꞌani anana li huto hilata nehana bonaꞌmoya ke luto nolu epolobe. ");
INSERT INTO bef_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma lagaso meso boanaꞌmagihi foipanagu eneleꞌmoto folo lalibe. Ya hu laligi sipi efahi mone lubahaꞌalo naga ilete hege nagamilugu lita fo bilenogo ai akuꞌi ana foipa foipana li huto mehilibe. ");
INSERT INTO bef_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Lenali kaba hu bati lenalitinimuꞌi hilo. Kogonakauba foipana li huto nohinogomo kai ka emekibo. To komopaꞌa i gelehe nohinogomo kai foipanaꞌa li heꞌmi etobo. ");
INSERT INTO bef_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","To sebeniꞌa yupahi moneko yegegu foipana huloto sebeniꞌa yupahi kaitoga oto ma luto lu kimilibe: Nani yatai komopaꞌni i gelehe nohube, ya lulenogomo kai yalo foipanaꞌa li heꞌmi etobo. ");
INSERT INTO bef_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo panaꞌmagi Yesuhi ma lite lu emiꞌahana: Kaga keheliloto uleꞌale huseꞌnati leꞌmo sipi hu letobo. ");
INSERT INTO bef_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu kaꞌanilo ma luto lu epiꞌehina: Lenali yafa legeya lagasoꞌasi moneꞌmofihi suhi luto kaga keheliseꞌnatini niꞌinogomo yaꞌmana nemuya yafaꞌa ma lite lu etalo: Kai ma yafamaka hapaꞌaka hiti i gonomi huloto buto hege nagamilugu kaika hekololoto tibo, lite linogo ana yafauba lenabaga liyafa huto kagatini kehelilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Liliꞌnalo boka moneuba foyakagu keꞌmuya nokifilinatifi to holupa kifigu yagaka kaba nohilinagati noenogomo meꞌme huto oto noseꞌnaka nobo, luto lulata nohata niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oꞌe, ya lulata menohane. Noseꞌnaꞌni li loloba hu netoloto gilimika i hetofa nohuto noseꞌnaꞌni alifito ito oto nimitogo nani yataꞌa nolenogoꞌni kaika alihi noseꞌnaka nalane, luto lulata nohibe. ");
INSERT INTO bef_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Liliꞌnalo boꞌauba sipi boꞌamofihi baga liyafa huto agoya hu eminaꞌmu sipi boꞌauba liliꞌnalo boꞌamofihi bati huto hetofa suhi hane, luto gepohi lilata nohifi? ");
INSERT INTO bef_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ana suhi luto lenalitoga hiti niꞌibe. Ya huꞌehinagi asagaꞌna Huꞌmau lu lepoloꞌehilina suhi hi su heletemo lenali ma lite lilo: Lali liliꞌnalo bati mehuta bo yabe. Anaꞌina nolutaya ai lali liliꞌnati niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yelusale hepatoga megeꞌi mololoto Samalia kapoꞌa hiti Galili kapoꞌa hiti folagahaꞌatitigu buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ya huto hepaꞌi monelugu notigo falame bonaꞌi nayahi luga luga su hago nehana Yesutoga eꞌahana. Enali ete Yesuhi gufasilo ete ho metina fotoꞌi ete ho tite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ya hilete kehe sipi ma lite iꞌahana: Yesuo. Sipi Boti. Kai kiginaga fi limibo. ");
INSERT INTO bef_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu bu enogoloto ma luto lu epiꞌehina: Lenali binogo mono bonaꞌmagi belelete lenugufatini bi geno. Enali kapogu nebago falameꞌani gololo ti su ho epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ya higo moneko bouba falameꞌa bu gana gololo ti su nohago bu goloto ai i behe huto nooto sipi kehe ito Huꞌmamofihi fokehi ho emito oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya huloto oto Yesuhi gigusagu golaga fito nokoto Yesuhi gepohi liꞌehina yabe. Yaꞌmana bo ai Samalia kapolo bouba yabe. Yuta bonaꞌmagi yaꞌma Samalia bonaꞌmofihi eneleꞌmo laba hilata nehana. ");
INSERT INTO bef_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ya nohigo Yesu kehe ito luꞌehina: Nayahi luga luga su hago bo eneleꞌmo bati huꞌohube. Ya huꞌohuna naeniꞌa hiyaꞌa nehabe? Enali henabe lite ete Huꞌmamofihi fokehi menehabe? ");
INSERT INTO bef_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hena hibe luto fatoga bouba aisigo oto Huꞌmamofihi giꞌa li saga huto fokehi nohabe? ");
INSERT INTO bef_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu ma luto ana bo lu emiꞌehina: Kai kaga keheli uleꞌale nohatanauba keleꞌmo bati nohinagi kai ho tito bubo. ");
INSERT INTO bef_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Felosi bonaꞌi lugaꞌamagi Huꞌmamofihi Kapoꞌa hiya yupahi huto hilina niꞌibe, lite Yesuhi loka heꞌahana. Ya lago Yesu kaꞌanilo ma luto lu epiꞌehina: Huꞌmamofihi Kapoꞌa alina yupahi boanaꞌmagi enubuꞌanituꞌi be megalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bo moneuba Huꞌmamofihi Kapoꞌa ma nina bu galo lula muya nina bu galo lula mehilinaꞌmu yabe. Henaꞌmugope Huꞌmamofihi Kapoꞌa lenali folagahatinigu hiti niꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yalo koko panaꞌa ma luto lu epiꞌehina: Alihi kana mone huto hilina yupahi lenali lenipagu yibi hilete ma lite lilabe: Kokulumaguti limiꞌehina Bomofihi kanaꞌa meleꞌisi aku huto hulenogo bu galune. Ya lilana lenali bu megalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","To bonaꞌi moneꞌa ana lite minalanamagi muyana bu gobo lila to mana bu gobo lila hilanaꞌmu yabe. Ya lilenogo lenali heleko limite bite anana sa sa mehilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kopisiꞌnauba i begena huloto kokulumatoga mone kegiꞌa buto i begena hula oto mone kegiꞌa i begena hula nohinana yago Kokulumaguti limiꞌehina Bouba yatai yaꞌma kanaꞌalo ana suhi hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ya huꞌehina ai yataꞌa sipi gabu foya kofila to enali yatai bonaꞌi ma nehanamagi okabagu bu go bati mehise megesa hu emila hilenogo yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Koyapaꞌi Noaha kanalo huto huꞌehina suhi lito ana huto Kokulumaguti limiꞌehina Bomofihi kanaꞌalo huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Asaga bonaꞌi minete noseꞌna neba neba nehite anaꞌi kata hite nehago Noau sipi botigu tilago nagamiꞌi bilito asaga boanaꞌi enoho fito su hoꞌehina suhi hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Koyapaꞌa Lotiu minana kanalo enali noseꞌna nelete nagamiꞌi nelete fato fatoꞌna mina filete foya hekelete to nohi gila hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ana yupahi Lotiu Sotomu hepaꞌi heꞌmito nobigo kokulumaluguti sipi logo loto ekesa efahi goꞌi ito limiloto asaga boanaꞌi enoho su hoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kokulumaguti limiꞌehina Bo aku alina yupahi yana suhi luto hepaꞌi kugumato hutoꞌi huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ya hilina yupahi bo moneuba nohupitaꞌalo nohilina akuꞌi nohaꞌaluga limito feꞌnohaꞌa lilubeꞌmu mehilinaꞌmu yabe. Henaꞌmugope hololu luto bufa hilinaꞌmu. Ana huto bo moneuba foyaꞌagu minalina hepaꞌaga mebilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotihi lihaꞌamoga lenekesa yigilo. Ai kapogu i behe huto fulu huto minoto anaꞌasi filiꞌehinanaꞌmu beto hilo. ");
INSERT INTO bef_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bo moneuba nugufaꞌni sibina hiligi luto kaba huto leꞌmo bati bati hilina gufaꞌa heꞌmilinaꞌmu yabe. To bo moneuba nani liliꞌna nolito gufaꞌa kaba hu bati mehuse heꞌmi hale hilina alihi gufaꞌa huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nani lu nolepube. Yaꞌma kanalo mone sininugu bonaꞌi loemo moneka sipalo keꞌehilaꞌinaloti mone leꞌmo bufa nohinogo moneꞌisi ana sipalo koloto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aꞌi loemaleꞌi noseꞌna laita hite nehilaꞌinaloti mone aꞌi ai leꞌmo saga nohinogo moneko aꞌi melugu minalibe. ");
INSERT INTO bef_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","To ana huto bo loemomaleꞌi foyagu liliꞌna lite nehilaꞌina mone bo ai leꞌmo saga nohinogo moneko bo ana foyagu minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu ya luto lu epigo enali ma lite loka heꞌahana: Sipi Bo, yaꞌma nolata kaba hiyaꞌalo huto hilina niꞌibe? To Yesu lu epiꞌehina: Yaga filiꞌehina hepaꞌi nina analo lupahi ete li nupa hite he loliꞌali hite bego bego hite neminana yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","To kosele meenehenogo ute etehi nunumu hilana bame ka Yesu lu epito ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kaga loko hulata bo hepaꞌi moneto minoꞌehina ai ana bouba Huꞌmamofihi koliꞌa mehula to asaga bonaꞌi agoya hu meepiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ana hepato keto aꞌi mone minoꞌehina ai asaga yupahi kaga loko hulata bo nohinalo ma luto oto buka tito lu emilata huꞌehina: Fatehaꞌniuba naniꞌi neleꞌmo sibina hilubeꞌmu nohinagi kai ka foyagu nobinogomo neheꞌmobo, luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kaga loko nohina bouba yataꞌa ana eto aꞌi meheꞌmalubeꞌmu huꞌehina alihi ma luto ekesa yigito luꞌehina yabe: Nani Huꞌmamofihi koliꞌa menohu etona ana huto bonaꞌi eneleꞌmo bati menohuna yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ya huꞌehina ma keto aꞌi ai kosele liliꞌna nimilina suhi nohibe. Ya hinogo nani ka foyagu leꞌmo nemelenogomo mana aꞌi heꞌmalube. To mone ya huto meheꞌmaluna ai asaga yupahi oba oba nanitoga hinogo nugufaꞌni nagabu gito koseleꞌni nahalibe, luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","To Yesu luꞌehina: Bati mehina suhi luto kaga loko hulata nohina bomofihi kagaꞌa kehelilo. ");
INSERT INTO bef_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ana suhi huto Huꞌmau boanaꞌa eneleꞌmo eto huꞌehina enali asaga utehi etehi aitoga kehe ite leheꞌmalibe lite lilata nehana meeneheꞌmalina niꞌifihe? Huꞌmau tala tele huto eneheꞌmalina niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nani lu nolepube, Huꞌmau hololu luto eneheꞌmalinaꞌmu yabe. Ya huꞌehina Kokulumaguti limiꞌehina Bouba akuꞌi alina yupahi ma melugu bonaꞌi aitoga enipa molo emite keheli uleꞌale hite nehinogo alina niꞌifi, ya mehilanabe? ");
INSERT INTO bef_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bonaꞌi lugaꞌamagi lali bati bonaꞌi nohune lite enaliꞌani enugufamofihi fokehi nehite to fato bonaꞌmomuꞌi enali bati mehana bonaꞌi nehabe lite lilata nehanaꞌmu Yesu ma bame ka luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Bo loemo nunumu hiluꞌibeꞌmu mono nonugu tiꞌahaꞌina yabe. Mone Felosi bo yagi to mone bo takisi lilata nohina bo yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ai Felosi bouba ho tiloto fahaꞌalo buto ho tito nohuto ma luto nunumu komopaꞌagu huꞌehina: O Huꞌmao, nani bonaꞌi lugaꞌamagi suhi huto menohube yaꞌmu nani kegepohi nolube. Bonaꞌi gumina felete to bo alobo loko hila ya hila nehana bomagihi suhi huto naniya menohube. Ana huto yaꞌma bo ai takisi lilata nohina bo legi huto menohube. ");
INSERT INTO bef_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Asaga liliꞌna kanagu loe yupapo noseꞌna mo sito menose nominotoꞌni to noseꞌnafi to feꞌnohaꞌni leka soloto teniꞌa huto nohinogomo loko huto moneꞌa kaitoga mololata nohuna yabe, luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","To takisi lilata bo fatoꞌi ho tito minoloto kokulumatoga bu go saga huto bu megose melugu lipito bu goloto minoto yahi gofa holoto ma luto nunumu luꞌehina: O Huꞌmao, nani foipa bo kai kiginaga fi nimibo. ");
INSERT INTO bef_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu luꞌehina: Nani lu nolepube, takisi lilata bo ai Huꞌmamofihi ipaꞌa emiꞌehinamofihi ai yaꞌma lamana bo yabe luto ligo nohaꞌaga nobibe. Ya huꞌehina to yaꞌma fato bo ai bati mehuꞌehibe. To bo moneuba giꞌa li saga hilubeꞌmu lilina Huꞌmau leꞌmo melugu nomoloto niꞌibe. To bo moneuba agoya huse to giꞌa laba hilina Huꞌmau fokehi hoto giꞌa li saga hilinaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bonaꞌi lugaꞌamagi Yesu yahaꞌatu yagapanaꞌi lagaso mesoꞌani lusa gi epalalibe lite eneleꞌme eꞌahana yabe. Ye nehago Yesuhi koko panaꞌamagi bu gelete kaꞌani epekiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ya nehago Yesu ana yagapanaꞌi: Alo, luto kehe i bufalo moloꞌehina. Yagapanaꞌi lenali heꞌmi epelenogo nanitoga eno. Lenali eneleꞌmo memalalo. Huꞌmamofihi Kapoꞌa ana huto yaꞌma yagapanaꞌmagina hiti niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nani lusiga luto lu nolepube. Bo moneuba yagapanaꞌmagi Huꞌmamofitoga agoya hu emise nehana ya suhi huto menohinogomo yaꞌma bo ai Huꞌmamofihi Kapoꞌalugu lusiga luto metilinaꞌmu yabe, Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yuta bo moneuba ma luto Yesuhi loka hoꞌehina: Tisao, hetofa bo yale, nani hena hulotoꞌni minoba minoba hepato bilube? ");
INSERT INTO bef_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ya ligo Yesu ma luto lu emiꞌehina: Kai hena hibe luto hetofa bo yabe luto luꞌahane? Asaga bonaꞌi bati bonaꞌi menehabe, Huꞌma ai monekoꞌisi hetofa bo nohibe. ");
INSERT INTO bef_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kai keya ka keheliꞌahane: Kai bo alobole eteleꞌmo loko huto aꞌi gumina mefolobo. Kai bonaꞌi mone ho mefilibo. Kai gumina melibo. Kai faga melubo. Kai itokafinogo afokafinogo etabaga liyafa huto agoya hu etimibo. ");
INSERT INTO bef_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ana bouba Yesuhi ma luto lu emiꞌehina: Nani lagasoꞌasi nohutoꞌni ana keya ka megeꞌi molomo molomo noona yatai hiti ana huto megeꞌi mololata nohube. ");
INSERT INTO bef_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu kagaꞌa keheliloto ma luto ana bo lu emiꞌehina: Kai moneꞌnasi hilata niꞌibe. Kai asaga yogo feꞌnohaka bonaꞌi epi su nohoto to efahaka feꞌnohaꞌani menilina bonaꞌi noepito huletogo kokulumaluguti batiꞌnaka lilataꞌmu yabe. Ya huloto naniꞌi nemegeꞌi molobo, Yesu lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ya ligo ana Yuta bo ai ana kagaꞌa keheliloto feꞌnoho bo nohinaꞌmu ekesa asaga nasanaꞌni musufalo bonaꞌi meepiluna yana yigito ipagu nunu gigo ginaga fiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ana bo bu gana yogo feꞌnohaꞌamu luto ginaga nofigo ma luto lu epiꞌehina: Bonaꞌi enali yogo feꞌnohaꞌani babu lito nina bonaꞌi Huꞌmamofihi Kapoꞌalo biluneꞌmu hilana keta epesinogo metilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nekaꞌmofihi kapoꞌalo kameli yagauba folo hokolo huto tilina keta besilinaꞌmu yagi to Huꞌmamofihi Kapoꞌalo yogo feꞌnohaꞌa babu lito niꞌina bouba sipi keta besilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bonaꞌi enali ana kaga kehelinamagi ma lite Yesuhi loka heꞌahana: Ya latago Huꞌmamofihi Kapoꞌalo minoba minoba hepaꞌiba kuyuꞌafu analo tilubeꞌmu bati hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kaꞌanilo nonaꞌa luꞌehina: Anaꞌina bonaꞌmagi lolo mehilana Huꞌmau ai leꞌmo huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitau luꞌehina: Bu gobo. Lali hepati heꞌmiloto kaiꞌi kemegeꞌi oꞌohuta yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Nani lusiga luto lu nolepube, luto Yesu luꞌehina. Asaga bonaꞌi Huꞌmamofihi Kapoꞌamu lilete nohaꞌani lihaꞌani enogonaꞌani to itoꞌanigi afoꞌanigi to yagapanaꞌanigi heꞌmi epelelete alana alihi Huꞌmau babu lito batiꞌnaꞌanilo maꞌasi kanalo epilinaꞌmu yagi, to alihi kanaꞌa alubeꞌmu hilina yupahi enali hetofa hepaꞌi minoba minoba huseꞌi nina yaꞌma lilinaꞌmu yabe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu yahi luga luga su hago gigusaga loemo leke ho malago aposolo pananaꞌa eneleꞌmoloto ma luto lu epiꞌehina: Kehelilo. Yatai Yelusale hepato tilune. Ya hulenogoti lu huto huto bonaꞌmagi koyapaꞌi asaga kaga Kokulumaguti limiꞌehina Bomofi kumu lime lime tiꞌahana yatai noseꞌnaꞌa huto hilibe. ");
INSERT INTO bef_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Enali fegutoga bonaꞌmagi enayanugu epilanaꞌmu yabe. Ya hilenogo enali kaga bati mehinaꞌa li etelete leꞌmo sibina hilete okabaluga libiꞌna he etalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","To enali nagatuꞌi biyigi etelete yafalo nili henogo fililoto akuꞌi loegi monegi yegegu su holenogo ho tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesu ya luto lu epina kaga enali aposolo pananaꞌamagi hapaꞌa mekeheliꞌahana yabe. Yesu lina kaga hapaꞌauba enalitoga fala ki epoloꞌehigo ana kaga lu epina enali keheli bati mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Yeliko hepa lebato noago musufalo bo mone buꞌa pisi luꞌehina bouba kapo belehaꞌaga nohuto kapolo bila ela hana bonaꞌmagi efahifi noseꞌnafi moneꞌa nimilo, luto kehe ilata nohigo bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Babu boanaꞌi kapo melete bila ela nehago ana buꞌa pisi lina bouba keheliloto enoloka hoꞌehina: Lenali hena nehabe? ");
INSERT INTO bef_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","To enali ma lite lu emiꞌahana: Yesu Nasalete hepalo bo kapo moloto noabe. ");
INSERT INTO bef_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ya lite nelago ai meleꞌisi kehe ito ma luto luꞌehina: Ke, Yesuo. Sipi boti Tebitihi Panaꞌase. Kai kiginaga fi nimibo. ");
INSERT INTO bef_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ya noligo bonaꞌi analo minanamagi ka emekite: Kaga meluse faꞌmene minobo liꞌahana. Ya nelago ana bouba akuꞌi ai sipi kehe ito luꞌehina: Tebitihi Panaꞌase. Kai kiginaga fi nimibo. ");
INSERT INTO bef_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ya ligo Yesu kapo moloto nobinati ho tiloto: Ana bo leꞌmete alo luꞌehina. Ana bo Yesu nohinalo olago Yesu: Hena hu ketalube? luto loka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ya higo ana bouba luꞌehina: Sipi bo, nani nubuꞌni pisi luꞌehina neleꞌmo bati hitogo aku bu galube luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ya ligo Yesu ma luto lu emiꞌehina: Kai nanitoga komopaka nimiꞌahata yaꞌmu kubuka yatai i gili hinogo bu gobo. ");
INSERT INTO bef_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesu ya luto noligo anaꞌasi kaꞌa megeꞌi moloto ana bomofihi buꞌa i gili meleꞌisi huꞌehina yabe. Ya hulago ana bouba Yesuhi megeꞌi moloto nobuto Huꞌmamofihi gelo bi emiꞌehina yabe. To babu bonaꞌmagi anana huto hina bu gelete Huꞌmamofihi ana hite fokehi hete giꞌa li saga hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Yeliko hepalugu tiloto ana hepaꞌi folaganugu bilubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bo mone minoꞌehina giꞌa Sakiasi. Ai takisi lilata nehanalo kaba huꞌehina aitoga efahaꞌa babu lito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ai Yesu hena huse bo nohifi luto bu galubeꞌmu huꞌehina. Ya hina ai hupamone bo nohigo asaga bonaꞌmagi Yesuhi leꞌmo folagahaꞌanigu meleꞌahago ai Yesuhi bu megoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ya huloto ai kohe toga hololu luto buto sifehe yafagu tilotoꞌa afenuga oto Yesu nobinogo ai bu golago limito bu galubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ya higo Yesu ana yafa hapaꞌalo oto ho tiloto bu golago tito Sakiasihi bu goloto ma luto luꞌehina: Sakiasio, kai hololu luto limibo. Nani yatai kai hiti buto nohakagu minaluꞌibeꞌmu nohube, luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiasiu yafaloti hololu luto limito yahi emito gelonaguti be tigito nohaꞌaga biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ya nehaꞌigo asaga bonaꞌi bu gelete gulu gulu bite ma lite liꞌahana: Akae. Bati mehina suhi luto hetofa bomouba buto foipa bomofihi nonugu minalubeꞌmu nohibe, lite enitaluga logo biꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiasiu ho tiloto ma luto Sipi Bo Yesuhi lu emiꞌehina: Sipi Bo, kai kehelibo. Nani yatai asaga feꞌnohaꞌni folaganuguti fuku luto luga kegiꞌa feꞌnohaꞌani menilina bonaꞌi epilube. To bo moneꞌmofihi faga faga lu etolotoꞌni anaꞌinaꞌa gumina liꞌehiluna yaꞌma lugaꞌa loegi loegi molo babu lito emilunaꞌmu yabe, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ya ligo Yesu ma luto Sakiasi kumu lu emiꞌehina: Yatai kaika nagaꞌi Huꞌmau aꞌeneleꞌmoꞌehibe. Yaꞌma bo hiti ai Abalahahi tataꞌafu nohibe. ");
INSERT INTO bef_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Henaꞌmugope Kokulumaguti limiꞌehina Bouba ai bonaꞌi fenene hiꞌahana sa sa huto eneleꞌmo huto hilube luto oꞌehina yabe, luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu lina kaga kehelina bonaꞌi bame ka mone luto lu epiꞌehina. Henaꞌmugope ai Yelusale hepaꞌi lebato oloto nominago enali Huꞌmamofihi Kapoꞌa yatai maꞌasi huto hilinaꞌmu yabe, lite nekeheligo yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yaꞌmu Yesu ma luꞌehina: Sipi bo mone foto hepatoga bulenogo gihiti bo leꞌmo lolo hiluneꞌmu hilana ai akuꞌi i behe huto hepaꞌaga alinaꞌmu yabe ");
INSERT INTO bef_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mebuꞌohuto yataꞌa teniꞌa liliꞌnalo boꞌa kehe i nupa huto goli efahi epila nohuto ma luto lu epoloꞌehina: Lenali yaꞌmana efahi nolepunaloti bisinisi melete efahi lugaꞌa mone hiti li huto hilafi nani alihi oto bu lenagalube. ");
INSERT INTO bef_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ya nohigo hepaꞌalo bonaꞌmagi enali ana bo sipi ipakafa heꞌahana. Ya nehago ana bo abufa nohigo bonaꞌi lugaꞌa enoho lifigo kaga lite megeꞌi lifite bite enali ma lite liꞌahana: Yaꞌma bouba ai lali gihiti boti lolo mehilibe luto keheliꞌohune liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ya huꞌehina alihi ana bo leꞌmo gihiti lolo hiꞌahana. Ya hago ai oto ma luto luꞌehina: Koyapaꞌi efahi epiꞌohuna liliꞌnalo boꞌnimo kehe ilo. Nani epila epila huloto buꞌohuna efatoti henaki lugaꞌa hiti efahi lila lila hiꞌahafi nani bu go kehelilube. ");
INSERT INTO bef_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ya ligo yataꞌa nehetina bouba ma luto luꞌehina: Sipi bo, kai mone goli efahi nimiꞌahatamoloti bisinisi molotoꞌni teniꞌa lolo huto huꞌehina liꞌohube. ");
INSERT INTO bef_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ya ligo gihiti bouba lu emiꞌehina: Kai hetofa liliꞌna liꞌahane. Kai bati liliꞌnalo panaꞌni yabe. Kai lagaso mesonalo kaba hu bati hatago yatai sipi kigi kiminogo teniꞌa kaba hilane. ");
INSERT INTO bef_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yalo ana megesalo bouba oto luꞌehina: Sipi bo, kai goli efahi monekoꞌisi nimiꞌahatamoloti nani liliꞌna emugo lugaꞌa yatai efapo faifuꞌa liꞌohube. ");
INSERT INTO bef_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ya higo gihiti bouba lu emiꞌehina: Kai nayahi mone kegiꞌa su hago hepaꞌi kaba hilane, luto keleꞌmo nomolobe. ");
INSERT INTO bef_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","To mone liliꞌnalo panaꞌa nehetiloto ma luto lu emiꞌehina: Sipi bo, mone goli efapo nimiꞌahatamo ma liꞌohube. Nani gulugu fala kito li guꞌi ketoꞌohuna ma bati huto asagaꞌi niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kaimo bu kogonamoya hosopa bo nohane, luto yaꞌma bouba lu emiꞌehina. Fato bonaꞌmagi anaꞌina melelata nehana kai lilata nohane. Bonaꞌmagi noseꞌna foyaꞌanigu hekelelata nehana kai yaꞌma noseꞌna lilata nohane. Yaꞌmu kai kumuꞌi nani koli nohube luto yaꞌma liliꞌnalo bouba luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yalo gihiti bouba ana liliꞌnalo panaꞌa ma luto lu emiꞌehina: Kai bati mehata liliꞌnalo panaꞌi yabe. Kaika kagakamu ka foyagu keleꞌmo malalunaꞌmu yabe. Naniꞌya bo nohutoꞌni bonaꞌmagi anaꞌinaꞌani nolito to noseꞌna foyaꞌanigu hekeleꞌahana yanaꞌani lilata nohuna bomo nohube. Keheliꞌahapi, ya? ");
INSERT INTO bef_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ya huꞌehinaꞌmu kai hena hibe luto efahaꞌni efaha nonuga memolo netane? Ya huꞌahatita nani oto ana efaha nonugati efahi moneꞌa hiti molo emiꞌahago lutitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","To sipi bouba ma luto analo nehana bonaꞌi lu epiꞌehina: Lenali ai yaꞌma bologati mone goli efahi emiꞌohunanamo lite lugaꞌa teniꞌa liꞌehina bo emilo, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","To enali ana bonaꞌmagi sipi bo lu emiꞌahana: Sipi bo, ai babu liꞌehinamo akuꞌi hena hibe luto yaꞌma goli efahi mone hiti li emilune? liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nani lu nolepube, luto sipi bouba lu epiꞌehina: Asaga bonaꞌi anaꞌina lugaꞌa liꞌehilana nani akuꞌi nanaꞌanilo molo emi epalalunaꞌmu yabe. Ya huꞌehina to bo moneuba anaꞌina melise faꞌmene nohuto nesiꞌnasi liꞌehilina be silito li heꞌmilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ya huꞌehina enali nani kumuꞌi gihiti bo meminalane liꞌahana fatehaꞌni eneleꞌmete ete nani nubulo enoho fililo, luto gihiti bouba lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ana bame ka lu epiloto kohe toga Yelusale hepa kapo megeꞌi moloto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya huloto ai Betefasi hepaꞌi hiti Betani hepaꞌi hiti nina o leba toloto Oliba kosaloti loe koko panaꞌa etoho lifigo etali kohe tete bifa hiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ai ma luto lu etimiꞌehina: Letali muya nina hepato bite tilete ana hepalugu toki yaga ikeleꞌa mone naga iꞌehinogo ana yaga megesalo bonaꞌi metiꞌahana bigelete nagaꞌa gulu fete leꞌmete aliyo. ");
INSERT INTO bef_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","To bo moneuba letoloka hoto hena hibe lite toki yaga gulu nehaꞌibe? nolinogomo letali ma lite lu emiliyo: Sipi botiꞌauba kehe igo yabe liliyo. ");
INSERT INTO bef_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Etali ana kapo melete bilete asaga kaga Yesu lu etimiꞌehina suhi niꞌigo bu geꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ana toki yaga gulu fete nehaꞌigo toki yaga afoꞌafu ma luto etoloka hoꞌehina: Letali hena hibe lite yagaꞌni gulu nefaꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ya noligo etali: Sipi botiꞌauba leꞌmete aliyo luto kehe igo yabe, lite liꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ya lilete ana toki yaga leꞌmete Yesu nohinalo biꞌahaꞌina. Ya hilete ana toki yaga gupisalo guketeꞌani melelete Yesuhi ifoꞌalo leꞌmo malago minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu ya huto toki yaga gupisalo nobigo asaga boanaꞌmagi guketeꞌani kapogu molo lehete lite tibiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yelusale hepatoti kapo mone Oliba kosalo limiꞌehinalo Yesu o leba notago Yesuhi babu panaꞌalobomagi li nupa hilete Huꞌmamofihi fokehi hete sipi kehe ilete hite Yesu asagaꞌna fato fatoꞌi bu geꞌahago li huto hinaꞌmu enegelo Huꞌmamofihi bi emite: Hetofa suhi hu letane, liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Huꞌma ai Sipi Bomofihi giꞌalo oꞌehina bo lusa gi etoto amuya emilinaꞌmu nohigo lali giꞌa li saga hilune. Huꞌmamofihi komopaꞌaguti ma bonaꞌmagitaloga bati hulata nohibe. Ifo muya Sipi Boti Huꞌmamofihi giꞌa liyafa hilune, liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ya lite nehago Felosi bonaꞌi lugaꞌamagi ana bona folagahaꞌaniguti Yesuhi kehe ite ma lite liꞌahana: Tisa kai pananaka lu epitogo kaga nelana anasi heꞌmino. ");
INSERT INTO bef_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu Felosi bonaꞌmagi kaꞌanilo luꞌehina: Nani lu nolepube. Nani heꞌmilo luto lu epiluna nani kumu efahi kaꞌma ninamagi kaga lilete yege fite enegelo bilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu Yelusale hepa lebato nehetiloto ana hepaꞌi bu golago bula ola huto beloloto yibi huto ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yelusale nagaꞌise. Kai yatai bati huto fulunaguti minosemofihi hapaꞌa akehelitita bati huto mina tino. Ya huꞌehina yatai yaꞌmanana fenene huto niꞌigo kai bu megane. ");
INSERT INTO bef_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kai kehelibo. Alihi kana mone huto hilina yupahi fatehakamagi ete keleꞌmo bego hilete luba hilana keꞌmuya kifilanaꞌmu yabe. Ya hite asaga kegiꞌati keleꞌmo bego hite keleꞌmo folaganugu malalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ya hite enali keleꞌmo tigili tegele sete keleꞌmo sibina sabana hilete ana hite anagu boanaꞌi nehilana hiti eneleꞌmo sibina sabana hilanaꞌmu yabe. Ya hite efaha nohaꞌa asagaꞌi tele bi su hete tili tele hite heꞌmilanaꞌmu yabe. Henaꞌmube? Kai Huꞌmamofihi kanaꞌalo oto nubuto bilibe luto keheli meemise minataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu sipi mono nonugu tiloto maketi melete ana mono nonugu nehana bona eneleꞌmo fitu fo heꞌmiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ya nohuto ma luto lu epiꞌehina. Mono kauba ma luto lulata nohibe: Nohaꞌniya nunumu nohi minalibe. Ya huꞌehina lenali guminalo bonaꞌmagi suguna hepaꞌani li lolo nehabe. ");
INSERT INTO bef_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu kanaꞌamu kanaꞌamu mono nonugu boanaꞌi kaga lu epilata huꞌehina. Ya nohigo enali mono noto kaba bo keya kaga keheli bati hulata bo to asaga boanaꞌmagi kaba boꞌani enali asagaꞌi Yesuhi mapahi fite nehite kapo mone li hokolo hilete haluneꞌmu hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ya hana asaga boanaꞌi Yesuhi kagaꞌa amuya melete keheli bati hiluneꞌmu hago yanaꞌmu enali ana bomagi Yesuhi halana kapoꞌa li hokolo mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mone yupahi Yesu boanaꞌi sipi mono nonugu eneleꞌmo nupa huloto kaga lu epito to ka lamanaꞌa lu epito nohigo enali sipi mono noto kaba hiꞌahana bo yagi enali keya kaga keheli bati hulata bo yagi to asaga boanaꞌmagi kaba boꞌani yagi enali asagaꞌi Yesutoga ete ma lite loka heꞌahana: ");
INSERT INTO bef_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kai lu limibo. Kai hena huse kigi liꞌohuto yaꞌma asagaꞌna li huto nohane? To kiyiꞌafu yaꞌmana sipi kigi kimiꞌehigo yaꞌma liliꞌna noline? ");
INSERT INTO bef_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ya lite loka hago Yesu ma luto kaꞌanilo ma luto luꞌehina: Yatai lenali kehelilo. Nani kaga mone lenoloka halunagi lenali lu nimilo. ");
INSERT INTO bef_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoniu nagamiꞌi folo epololata huꞌehinanaba kokulumaluguꞌna niꞌifi faꞌmene bonaꞌmagi hina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ya ligo ana bonaꞌmagi enali ai bugu egago ai bugu egago hilete komopaꞌanigu kenasabo bilete ma lite liꞌahana: Hena hibe luto kaꞌalo lilune? Huꞌmamofitogati yabe liluta ai ma luto lilinaꞌmu: Hena hibe lite lenali Yonihi keheli meneemibe? ");
INSERT INTO bef_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","To lali faꞌmene bonaꞌmagi hina yabe luto liluta asaga bonaꞌi ma nehanamagi efa kosatuꞌi heꞌmilago hehe hite lahalanaꞌmu yabe. Henaꞌmugope enali Yoniu lu yege hose bo yabe lite amuya melete keheli neemina yabe lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ya lilete Yesuhi kaꞌalo ma lite nonaꞌa liꞌahana: Yoniu nagami nofolo epalanana hiya hepatogati oꞌehifi lali mekeheliꞌohune. ");
INSERT INTO bef_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ya lago Yesu ma luto lu epiꞌehina: Ana huto nani liliꞌna nolunamofihi hapaꞌa lu melepilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","To Yesu boanaꞌmagihi kiliheꞌi mone lu epiꞌehina: Bo moneuba nagaꞌi foya kofolotoꞌa, to kaba bonaꞌmo eneleꞌmo ho tito buto, foto hepatoga buto minoba minoba huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","To alihi legeyaꞌa hoto uyaꞌi lago legeyaꞌa moneꞌa ligilube luto, kele kele panaꞌa mone ho lifigo bigo enali luba sabo hite osahi emite kene igo meligise faꞌmene oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ya hi etago foya afoꞌafu kele kele panaꞌa mone hiti ho lifigo bigo enali aiꞌi ana hite osahi emite to golahi hite leꞌmete bite fegutoga heꞌmi eteꞌahana. Ai ana huto meligise i behe huto faꞌmene oꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","To foya afoꞌafu kele kele panaꞌa mone hiti ho lifigo bigo enali ana hite, osahi emite fegutoga heꞌmi eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ya hi etago foya afoꞌafu: Henaꞌni hilube? luto, naniꞌni panaꞌnimo nibita huꞌehina panaꞌmo ho lifilube. To ho lifilenogo bigo enali bu gete enelesaꞌani lite kaꞌa kehelilafiye? bu galube, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","To ho lifigo bigo enali bu gete kaga lite liꞌahana: Oho. Yaꞌma yege panaꞌa noabe lite, ho fililototi foyaꞌa laliti liluneꞌmu nohune lite, ");
INSERT INTO bef_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","leꞌmete bite fegutoga heꞌmi etete ho filiꞌahana yabe. Yesu enoloka hoꞌehina: Ya hago foya afoꞌafu keheliloto hena hu epalalibe? ");
INSERT INTO bef_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ai buto enali enoho su holotoꞌa foyamo fato bonaꞌmo epinogo kaba hilabe. Yesu ya luto lu epiꞌehina kiliheꞌi yabe. Ya lu epigo boanaꞌmagi kehelilete ma liꞌahana: Abo, yaꞌma kaba bonaꞌmagi ya hilalafi? Oꞌe, ya mehilabe. ");
INSERT INTO bef_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yalo Yesu enubu goloto ma luto lu epiꞌehina: Kehelilo, hena kagauba yaꞌmaguti mono ka fayahi geꞌahana ninagu hapaꞌa legeyaꞌa huto hilibe? Yaꞌma efapo lapusaꞌa liliꞌnalo bomagi bati mehina yabe lite li heꞌmiꞌahana akuꞌi yatai yuhufa noto folaganugu lapusa finogo amuyana hetofana minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Asaga bonaꞌi yaꞌmana lapusaꞌamofihi hapaꞌaluga felete minalana enali asagaꞌi i gofa he su halanaꞌmu yabe. To yaꞌmana lapusaꞌa limo ito bo moneꞌmofihi halina ana bo ai pehena legi huto i keye luto meꞌi lolo hu etalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ana yupahi keya ka babafi bo to sipi mono noto kaba enali kumu luto Yesu bame ka ligo enali keheli sibina hilete Yesuhi ana hepato nagaꞌi emiluneꞌmu hana babu boanaꞌmagi megeꞌi nemalago koli heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ya hago enali fato kanalo nagaꞌi emilune lite mapahi fite biꞌahana. To Yesuhi mapahi fite minalabe lite bonaꞌi luga enoho lifigo biꞌahana yabe. Enali yaꞌmana bonaꞌi enali bati bonaꞌi suhi hite Yesuhi laluꞌagita nohune lite biꞌahana yabe. Enali ya hite bite nehite loka babu lite heba heba hite fi taga hi etelenogo ai Yesu kaga bati hinaga lilifi to bati mehinaga nolinogomo naga ito leꞌmete sipi gamani bo nohinalo bilune lite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Enali yaꞌmana Yesuhi mapahi fite bana bonaꞌmagi ma lite Yesuhi loka heꞌahana: Tisa kai fotogo hina kaga lula to boanaꞌmagi hetofa kaga lu epilata nohanogo keheli ketolata nohuta yabe. Kai sipi enigihiti bomagihi koliꞌani menohata yabe. Kai lusigago luto Huꞌmamofihi mono kaꞌa boanaꞌi lu epilata nohata yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ya hulata nohata kai kehelitaba takisi bati huto epilata nohupi bati mehina suhi luto epilata nohune? ");
INSERT INTO bef_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ya hana Yesu faga faga nelana kaꞌanimofihi hapaꞌa akeheliloto ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Efahi legeyaꞌa mone li nelepilo. Kiyiꞌafihi okabaꞌa hiti giꞌa hiti yaꞌmana efahi legeyaꞌalo niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ya luto enoloka hago enali sipi bo Sisahi giꞌa hiti okabaꞌa hiti niꞌibe liꞌahana. Ya lago Yesu lu epiꞌehina: Sisahi nanaꞌa Sisahi emilo to Huꞌmamofihi nanaꞌa ya Huꞌmamofitogago emilo. ");
INSERT INTO bef_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu kaꞌanilo lu epina kagauba enoholago enelesa ligo babu bonaꞌi minanalo Yesuhi naga ilupi naga meilupi lilete kaga melise enabaga hekini lelete faꞌmene mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mono bonaꞌi lugaꞌa enali filiseꞌnaguti bonaꞌi akuꞌi ho metilanaꞌmu yabe lite lilata nehana enigiꞌani Satusi bonaꞌi enali Yesutoga eꞌahana. Enali Yesuhi loka heꞌahana: ");
INSERT INTO bef_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tisao, Moseu ma kaga limiꞌehina yabe: Bo moneuba yagapanaꞌi meketose nohuto fililoto lihaꞌa heꞌmi etoto nobinogomo ana bomofihi gonaꞌauba lihaꞌa lilenogo etali yagapanaꞌi filiꞌehina bomofito nonaꞌa ketalaꞌinaꞌmu yabe luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mone yupahi koguna sebeniꞌa mineꞌahana enogoꞌanifu lihaꞌa liloto yagapana meketose filiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ya higo ana megesalo gonaꞌauba goꞌafihi lihaꞌa koyoꞌi liꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ai ana huto yagapana meketose filito nobigo ana bomofihi megesalo gonaꞌauba koyoꞌi liꞌehina. Ananago hite sebeniꞌa kogunamagi ana aꞌi yagapana ketalufi lite linamo enali asagaꞌi ana aꞌi hiti yagapana meketose fili su heꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ya hilago alihi ana aꞌi filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To asaga bonaꞌi filiꞌahanagati ho ti su halana yupahi ana koguna ho tilana ai ana aꞌiba kiyiꞌafihi lihaꞌa minalina niꞌibe? luto Yesuhi loka heꞌahana yabe. To asaga sebeniꞌa kogunamagi ana aꞌi lihaꞌani li etalafihe? ");
INSERT INTO bef_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Boanaꞌi yatai kanaꞌalo neminana enali li bo alobo hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ya huꞌehina boanaꞌi Huꞌmau lamana nehana yabe luto ho tilabe luꞌehina enali alihi kanaꞌalo mine bati hilanamagi li bo alobo mehilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Enali akuꞌi mefililanaꞌmu yabe. Enali agelo bonaꞌmagi suhi lite minalanaꞌmu yabe. Huꞌmau filiꞌahanaguti eneleꞌmo ho tilinaꞌmu yago enali aiꞌa yagapanaꞌa minalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","To koyapaꞌi Moseu bonaꞌi filiꞌahanaguti akuꞌi ho tilanaꞌmu yabe luto huto lelepiꞌehina. Ai fayahi mone koyoto luꞌehinagi lagaso yafa logo lana guluya mehaꞌaguti nogoꞌauba Sipi Bo kumu yaꞌma Abalahagi Yakopugi to Isakagi Huꞌma, Sipi Boꞌanifita nohube luto Mosehi lu emiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ya huꞌehina Huꞌmau ai filise bonaꞌmagihi Sipi Boꞌanifu menohibe. Enali nehana bonaꞌmagi Sipi Boꞌanifu nohibe. Ai Huꞌmamofihi buꞌalo asaga bonaꞌi mefilise asagaꞌi ho tite nehabe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesu ya luto noligo keya ka enelepise bonaꞌmagi ma lite liꞌahana: Tisao, kai bati ka luto mana ka lane. ");
INSERT INTO bef_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ya lilete enali koli hite aku akuꞌi Yesuhi mone ka loka meheꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ya huꞌehina Yesu ma luto enoloka hoꞌehina: Huꞌmau leꞌmo ho tiꞌehina bo kumu hena hibe lite enali Tebitihi Panaꞌa yabe lite lilata nehabe? ");
INSERT INTO bef_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mono nama buku monelugu Tebitiu aiꞌa ma luto luꞌehina: Sipi Bo Huꞌmau ma luto nani Sipi Boꞌni lu emiꞌehina: Kai nayahi lamagaꞌaga minobo. ");
INSERT INTO bef_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ya huꞌehitogo nani alihi fatehaka kamanuga eneleꞌmo malalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tebitiu aiꞌa Sipi Boꞌni yabe luꞌehinamo akuꞌi hena hibe luto Mesiau Tebitihi panaꞌa lolo hilibe? ");
INSERT INTO bef_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Babu bonaꞌmagi Yesuhi kagaꞌalo kehelite nehago Yesu ma luto koko pananaꞌa lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Lenali keya ka babafi bonaꞌi kaba hu bati hite minalo. Enali yatama yatama gukete li hekelelete enali yoleꞌale ite humofaꞌna nehago asaga bonaꞌmagi soso hu epelete enebe tigite hila asaga bonaꞌi li nupa hite minelata nehana enubulo hilata nehabe. To enali mono nonugu asaga boanaꞌmagi enubulo minelete to sipi noseꞌna nelata nehanalo hepaꞌi batiꞌa lite minelata nehago asaga li nupa hite minana bonaꞌmagi, akae enali hetofa bonaꞌi yabe lite lu epelelata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Enali keto anaꞌmagihi feꞌnohaꞌani mone yupahaꞌa enimiꞌi melete gumina lilete to mone yupahaꞌa bonaꞌmagi enubulo lali bati bo nohune lite sipi nunumu yatamalo hilata nehabe. Huꞌmau foipa bonaꞌi enahalina yupahi ma bonaꞌi lusina huto enoho fala kilinaꞌmu yabe, luto Yesu koko pananaꞌa lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sipi mono nonugu feꞌnoho bonaꞌmagi efaha lapelugu nemalana Yesu minoto bu enogoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ya nehago feꞌnohaꞌa menina keto aꞌi mone bahaꞌa fililago nominana aꞌuba nesi safa efahaꞌa loemo lapelugu heꞌmi malana Yesu bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ya huloto Yesu ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Ma keto aꞌi bahaꞌa fililago feꞌnohaꞌa menina aꞌi nominana ai asaga boanaꞌi enohoto efaha lapelugu noheꞌmibe. ");
INSERT INTO bef_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Enali yaꞌma bonaꞌi lugaꞌa enali feꞌnohaꞌani babu lito nina nesiꞌasi Huꞌmamofitoga neemibe. Ya huꞌehina yaꞌma keto aꞌi ai feꞌnohaꞌa maꞌnaka luto menina aitoga nina efahaꞌa asagaꞌi heꞌmi su nohabe. To aitoga noseꞌnaꞌa lito nalina efahaꞌa lusiga luto nohaꞌa luga meniꞌibe, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bonaꞌi lugaꞌamagi sipi mono nopofi kumu ma lite kaga liꞌahana: Enali yaꞌma mono nohi hetofa efatuꞌi li hekelete to Huꞌmamofitoga moneꞌna boanaꞌmagi meleꞌahananaꞌmu hiti kaga nelago Yesu ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Asagaꞌna yatai lenali bu neganana alihi kanaꞌa mone huto hilina yupahi ma asaga efahi ilala kete ibe gofa hibe hite meluguko limi su halanaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Enali ma lite Yesuhi loka heꞌahana: Tisa, hiya yupahi yaꞌmana huto hilina niꞌibe? Henana yataꞌa huto hinogo bu goloto yaꞌmanana kai luꞌahatana anasi yatai huto hilubeꞌmu nohibe luto keheliluta niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ya lago Yesu lu epiꞌehina: Lenali kaba hu bati hilo. Mone lenimiꞌi mele lalabeꞌmu nolube. Babu bonaꞌi nani nigiꞌni hete ma lite lilanaꞌmu yabe: Naniꞌni yaꞌmana bomo nohube. To ma lite lilanaꞌmu yabe: Kanaꞌa anasi yatai lebato huto nohibe. Ya nelinogomo lenali ana bonaꞌi bite enemegeꞌi memalalo. ");
INSERT INTO bef_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","To alihaꞌa sipi luba nehabe lite nelinogomo lenali lenuluhayaguti fiki fiki hinogo koli mehilo. Lubana hena asagaꞌna yataꞌa fato fatoꞌi huto hu su holenogo alihi anana meꞌme huto mehilinaꞌmu. ");
INSERT INTO bef_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu ma luto ka mone lu epiꞌehina: Mone bo nagaꞌmagi ho tite mone bo nagaꞌi hiti luba hilinaꞌmu yabe. To mone gihiti bomofihi boꞌa hiti fato gihiti bomofihi boꞌa hiti luba li huto hite hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sipi imimaꞌi melugu lilinaꞌmu yabe. To mone kegiꞌa sipi kauꞌna helenogo enebesiseꞌna babu lito huto hilinaꞌmu yabe. To kokulumalugu babeyafana sipi sipi, fato fatoꞌi huto huloto leneleꞌmo lenelesa fatoꞌna huto lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ya huꞌehina yaꞌmana asagaꞌna huto mehuꞌehinogo yataꞌa lenegene mane hite leneleꞌmo sibina hilanaꞌmu yabe. Enali mono nonugu leneleꞌmo melete nagaꞌi lepilanaꞌmu yabe. Enali nani nigiꞌni li melugu malalune lite leneleꞌmo gihiti bo enubulo hiti gamani bona enubulo hiti bite ka foya lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yaꞌma lenali kapotini hokolo hinogo kaꞌni lu yege halana kanaꞌa huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ya huꞌehinagi lenali yaꞌma ka foyalo kaga mone ete nelilete nogo lu epiluta kaga yabe lite kaga lenekesagu li gehe lite loloba hite meminalo. ");
INSERT INTO bef_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naniꞌni kaga hetofaꞌa lenabagalo mololotoꞌni to ka keheliseꞌna hetofaꞌa lepilunaꞌmu yabe. To asaga fatehatinimagi nani lepilina kaga li gofa mehila to lisiꞌani luga mebilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Itokafugo afokafugo to kogonamu tamuka to kalalukagi hiti enali asagaꞌi fatehaka lolo hilanaꞌmu yabe. Ya hilete monepi monepi lenoho fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","To asaga bonaꞌmagi sipi lenipakafa halanaꞌmu yabe. Henaꞌmugope lenali nani nigiꞌni lu yege homofaꞌna hilanaꞌmu lite yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ya huꞌehina Huꞌmamofihi bulo okatiniguti monekoꞌisi mone fenene mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lenali amuya melete kehelise uleꞌale hite mino bati hite nehite akuꞌi lenali mino bati huse hepatini lilabe. ");
INSERT INTO bef_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","To alihi gimi bomagi ete Yelusale hepaꞌi li bego nehinogo lenali bu gelete ma lite kehelilo. Yelusale hepaꞌi li sibina huse kanaꞌa yatai huto nohibe lite lilo. ");
INSERT INTO bef_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yaꞌmana yupahi Yutia hepato nehana bonaꞌi koli hite kosagago ti su halo. To Yelusale bonaꞌi lenali hepatini heꞌmite legete fato hepatogago bi su halo. To lenali fegutoga nehana bonaꞌi ana nohi hepa gegisagu metilo. ");
INSERT INTO bef_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yaꞌmana yupahiya Huꞌmau bonaꞌi osahi epilina to li sibina hilinaꞌmu yabe. Ya hulenogo asaga kaga mono bukugu ninamofihi manaꞌa huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ke. Enali anaꞌi yatai yagapanaꞌani hiti hiꞌahanafi to yagapanaꞌani amihi neepina anaꞌise. Ana kanagu sipi ketana ma melugu huto hulenogo Huꞌmamofihi ipagu logo biseꞌnaꞌauba asaga boanaꞌi sa sa hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sipi emitauba enohoto nalinaꞌmu yabe. Fatehaꞌanimagi nagaꞌi epite eneleꞌmete bite fato bona folagahaꞌanigu heꞌmi epalalanaꞌmu. To fatoga bonaꞌmagi enigiꞌaniuba Yelusale hepaꞌi ilenogo akuꞌi fato bonaꞌmagi enehete eneleꞌmo neheꞌmite enaliꞌani minalanaꞌmu yabe. Enali Huꞌmau moloꞌehina kanagu minete to kana su holenogo heꞌmilabe. ");
INSERT INTO bef_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ikato yegelo to sonofito fato fato lu huse lu huseꞌna huto hilinaꞌmu yabe. To melugu asaga bonaꞌmagi enipaꞌanigu koli hulenogo hege nagamiluguti sipi nogo moloto bililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Asaga boanaꞌmagi melugu anaꞌina mone huto hilubeꞌmu nohibe lite enekesa yigi fato fato hite minete sipi enelesa luto enubuꞌani metepu ito loe loe hilinaꞌmu yabe. Henaꞌmugope kokulumalugu sonofiꞌi hiti ifo muya hiti asagaꞌi mopo hu baga ilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ya hulenogo analo Kokulumaguti limiꞌehina Bo aku huto hilinaꞌmu yabe. Soponugu lusi sipi amuyaꞌa hiti fana mehenaꞌaguti aꞌalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yaꞌmanana hapi fito huto hilubeꞌmu nohinogomo lenali ho tilete latahatini li saga hilo. To Huꞌmau leneleꞌmalubeꞌmu hilina kanaꞌa huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yalo Yesu ma bame ka lu epiꞌehina: Lenali nemuya yafamo hiti to asaga yafa lugaꞌa minelata nehanalo lenekesa yigi malalo. ");
INSERT INTO bef_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hayaꞌani helililoto nohesigomo yege anasi lalina kanaꞌa o leba notabe lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ana suhi luto asagaꞌna huto nohinogomo Huꞌma bonaꞌa eneleꞌmalina kanaꞌa o leba notabe lite lilo, luto Yesu lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lenali ma kaga lenekesagu li malalo. Enali yatai boanaꞌi mefilise nehinogo asagaꞌna huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kokulumaꞌi hiti meꞌi hiti su hoto fenene huto bilinaya nani kagaꞌni su hoto fenene huto mebilina mino lito buto minalinaꞌmu yabe, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ya huꞌehina lenali kaba hu bati hilo. Lenali asaga yupahi amuya nagamiꞌi nelete negi nagi ne lalabe. Lenali lenugufaloꞌnamuꞌi lenekesa yigiba yigiba mehilo. Yaꞌmana suhi lenalitoga huto nohinogomo yalo Sipi Bomofihi Kanaꞌa hololu luto analo meleꞌisi lenalitoga nehetilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Asaga kapoga meꞌi tinaꞌa liminaꞌaga mino baga ite nehana boanatoga yaꞌmana kanaꞌa huto hu baga ilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lenali kanaꞌamu kanaꞌamu ute etehi asaga yupahi kaba hu bati hite minalo. Lenali asaga yupahi Huꞌmamofitoga nunumu foya liba liba hinogo ai amuya lepilibe. Ya hinogo asagaꞌna huto hilinamofihi lenali li lenemegesaga nemelete Kokulumaguti limiꞌehina Bo ai okabalo ho tilanaꞌmu yabe luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","To asaga yupahi Yesu sipi mono nonugu boanaꞌi mono kaga lu enelepiꞌehina. Ya huloto foluguꞌa Oliba kosagu tito kolata huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","To asaga etehi foluguꞌi asaga boanaꞌi Yesuhi ai kaꞌa kehelilune lite sipi mono nonugu elata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Anaꞌinatu mone yeye mebise beleti noseꞌna lolo hite nelata nehana ai Pasa yabe lite lolo hite fuli kanalo nelatana yaꞌma o leba toꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","To enali mono bonaꞌi to kaga keheli bati hiꞌahana bonaꞌi enali boanaꞌmagihi koli hilete ma lite liꞌahana: Lali hena hulototi Yesuhi ho fala kilune? ");
INSERT INTO bef_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To Yutasi Isikelioti yabe lite gi helata hana bomofitoga Satau nehetito komopaꞌagu tiꞌehina. Ai aposolo bo 12 yaꞌma nagaluguti yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ya higo Yutasiu sipi mono bo to mono noto kaba gimi negina bonaꞌi enalitoga Yesuhi enayanuga bilinamofihi gutunu ka lu epilubeꞌmu buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ya ligo enali enegelo bilete fokehi kaga lu bati hilete efahi kimilutaꞌmu yabe liꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","To Yutasiu bati huto yabe, luto kaꞌanilo luꞌehina. To ai Yesuhi miꞌi moloto leꞌmoto oto enayanugu malalinamofihi kapoꞌa sa sa huꞌehina. Ai boanaꞌi babu lite Yesu hiti meminalana yupahi yabe luto ana kana geba huto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pasa noseꞌna nose kana o leba tago sipisipi yaga nalaꞌa hiti yaꞌma keye liluneꞌmu nehana. ");
INSERT INTO bef_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu Pitanogo Yoninogo eteleꞌmo kohe toloto bite letali Pasa noseꞌna li loloba nehiꞌinogo buto nalune luto etoho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Etali Yesuhi loka helete ma lite liꞌahaꞌina: Hiyaꞌalo buto ana noseꞌna li loloba hiluꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ai ma luto lu etimiꞌehina: Letali Yelusale hepalugu netiꞌinogo bo moneuba nagami sipi somo kofito nobuto letofo talinaꞌmu yabe. Letali ana bo megeꞌi lifite bitetiti ai nonuga notinogomo ana nonuga tiliyo. ");
INSERT INTO bef_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ya hilete nohi afoꞌafihi ma lite lu emiliyo: Tisauba kai kumu ma luto luꞌehibe koko panaꞌni hiti Pasa noseꞌna naluta nohiba hiyaꞌa niꞌibe? luto luꞌehibe lite lu emiliyo. ");
INSERT INTO bef_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","To ai sipi hasa mone ifolo hita hiti to sia hiti niꞌilina letelepinogo letali anaga asaga Pasa noseꞌna li loloba hiliyo. ");
INSERT INTO bef_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yalo etali bilete asaga Yesu kaga lu etimiꞌehina suhi huto huto higo etali Pasa noseꞌna li nupa hiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kanaꞌa o leba tolago Yesu hepaꞌanilo hepaꞌanilo lito hitalo siato minolago analo aposolo panaꞌa hiti mino bego hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","To Yesu ma luto lu epiꞌehina: Nani ma Pasa noseꞌna lenali hiti moneko kumu yataꞌa no kohe tolototi lagaꞌni nobesigo nani alihi nagabu foya li kofilube. ");
INSERT INTO bef_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nani lusiga maꞌnaka luto lu nolepube, nani akuꞌi mone hiti Pasa noseꞌna lenali hiti menose nohinogo ananamofihi noseꞌna legeyaꞌa li huto Huꞌmamofihi Kapoꞌalo hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","To ai masu mone lito Huꞌmamofihi fokehi holoto ma luto luꞌehina: Lenali yaꞌmana lilete lenalitini guna ilo. ");
INSERT INTO bef_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nani lu nolepube, yatai hiti to alihi hiti nani bai nagamiꞌmofihi panaꞌa menose nohinogoꞌni alihi Huꞌmamofihi Kapoꞌa alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","To ai beleti lito Huꞌmamofihi fokehi ho emiloto li gofa holoto enaliꞌi epiloto ma luto lu epiꞌehina: Yaꞌmana nani nugufaꞌni yabe. Lenali kumu nugufaꞌni heꞌmito fililunaꞌmu yabe luto nolepube. Lenali yaꞌmana suhi hilete nelata nehite nani kumuꞌi lenekesu meheno. ");
INSERT INTO bef_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Alihi enali ne su helete ai bai nagamiꞌi lito ana suhi huloto ma luto luꞌehina: Yaꞌma bai nagamiꞌi nolepunaya nani golahaꞌnilo lenali kumu kaga lu moloꞌehina yabe luto Huꞌmau lu mu tifiseꞌnamo yuhufasi niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ya huꞌehinaya lenali bu galo. Ma nohuta hita folagahatigu lalalutifu moneuba naniꞌi nimiꞌi moloto fatehaꞌnimagihi enayanugu bilina bo nohibe. ");
INSERT INTO bef_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kokulumaguti limiꞌehina Bo Huꞌmau luꞌehina megeꞌi moloto fililinaꞌmu yabe. Ya huꞌehinaya ai fatehe bomagihi enayanugu neleꞌmoto buto malalina bomofi buya hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesu ya luto lu epilago to enali ai loka hago ai loka hago hilete ma lite liꞌahana: Kiyiꞌafu yaꞌmana suhi hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesuhi koko pananaꞌaguti kiyiꞌafu sipi bo nohilibe lilete kenasabo bi lumala hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ya nehago Yesu ma luto lu epiꞌehina: Kibina bo ma melugu nehanamagi enalitoga amuyana niꞌigo bonaꞌani kaba nehi epalabe to kaba bonaꞌi enaliya Bonaꞌmagi Enalaluꞌanigi yabe, luto enigiꞌani niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ya huꞌehinagi lenali yaꞌmana suhi mehilo. To bo mone folagahatiniguti nani sipiꞌa nohube luloto ai yagapanaꞌi lagasoꞌa legita huto mineno, to kaba bo ai koko pana tegi huto mineno. ");
INSERT INTO bef_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","To butinilo kiyiꞌafu kaba bo nohibe ai mino laba huto noseꞌna nonanaubafi to ai koko kako humo emilata nohinaubabe? Ai mino laba huto noseꞌna nolata nohinauba kaba bo nohibe. Ya huꞌehina nani folagahatinigu nohuna ya koko bo legi huto leneheꞌmalube luto nohube. ");
INSERT INTO bef_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Asaga yupahi nanitoga fi taga huseꞌna nehetilata hinalo naniꞌi meheꞌmi netose lenali nani hiti minelata hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","To Afoꞌnifu ai Kapoꞌa naniꞌi nimiꞌehina ana suhi huto Kapoꞌa nani lenaliꞌi nolepube. ");
INSERT INTO bef_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","To Kapoꞌnilo lenali noseꞌna nete to nagami nete hitaꞌnilo hilabe. To lenali gihiti bomagihi kefa hisalo minelete ma melugu nayahi luga luga su hoto nigigusagati loemo heleko malago yaꞌma Isilaeli nagaꞌi nehana enali kagaꞌanilo kaba hilete nehite ya huto kaga latagi lite keheli epalalanaꞌmu yabe, luto Yesu aposolo panaꞌa lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simonio. Simonio. Kai kehelibo. Satau lenali kumu enimiꞌi malalube luto higo Huꞌmau lu laga mehu etobe. Ai lenaliꞌi leneleꞌmalube luto uiti legeyaꞌa hiti nohaꞌa hiti li gelehe huba huba huto kehe noibe yaꞌma tegi huto lenebe ligilubeꞌmu nohinagihe, luto Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ya huꞌehina nani afoꞌnifihi loka hoto kaitoga keheꞌmalibe luto ahuꞌohube to kai nanitoga komopaka moloto nominatana meheꞌmibo. To alihi komopaka i gelehe huto olotomo yalo kaikagoꞌi kai to kogonakamagihi eneleꞌmo amuya molobo. ");
INSERT INTO bef_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","To Pitau ma luto lu emiꞌehina: Sipi Bo, nani kai hiti buto nagalugu moneka biluꞌibe luto loloba huto nohube. To kai hiti moneka fililuꞌibe luto loloba huto nohube. ");
INSERT INTO bef_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ya ligo Yesu Pitahi lu emiꞌehina: Pitao, nani maꞌnaka luto lu nokumube. Yatai foluguꞌi kokole nogo memoloꞌehinogo loegi monegi yupahi nani nigiꞌni li fala kito aiꞌi mekeheliꞌohuna boꞌmu kaga nelabe luto lilataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","To Yesu lu epiꞌehina: Yataꞌa lenoho lifiꞌohuna yupahi efahatinifi gutinifi to lenigiguꞌnatinifi melise bilo, luto lu lepuna yupahi lenali lugaꞌa meniꞌibe lite sa sa hiꞌahafi ya mehiꞌahabe? To enali liꞌahana: Oꞌe ya mehuꞌohune. ");
INSERT INTO bef_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","To yatai kehelilo, luto Yesu lu epiꞌehina: Mone bouba guꞌafi to efahaꞌa niꞌinogomo yatai li pili keno. To bo moneuba sipi emitaꞌa meniꞌinogomo bufaloꞌna hetito buto bonaꞌi epinogo efatoti mina filenogo ai sipi emitaꞌa alino. ");
INSERT INTO bef_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Henaꞌmube? Mono bukugu kaga ma luto niꞌibe: Enali foipa bo hiti leꞌmo malalabe. To nani lu nolepube luꞌehina. Yaꞌmana kagauba nanitoga huto hilinaꞌmu yabe. Asaga fayahi keyeꞌahana yaꞌma kaga monolugu nani kumuꞌi ninalo yatai manaꞌa huto hilubeꞌmu nohibe. ");
INSERT INTO bef_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ya luto lu noepigo enali ma lite liꞌahana: Sipi Bo, kai bu gobo. Lali sipi emitaꞌi loemo ma moloꞌohune. To ai: Anasi yagi heꞌmilo, luto lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","To Yesu fegutoga limiloto asaga yupahi hulata nohina suhi huto Oliba kosagu tiꞌehina. Ya nohigo aposolo pananaꞌa megeꞌi lifite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ai ana kosalo nehetiloto ma luto lu epiꞌehina: Lenali nunumu hite nehinogo lenalitoga fi taga hu lepoloseꞌna huto mehilibe. ");
INSERT INTO bef_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","To Yesu analo enaliꞌi heꞌmi epololoto aiꞌasigo bo moneuba efahi heꞌmi nomalana legegeꞌalo bu mololoto lapusa nohifito lipito minoloto ma luto nunumu huꞌehina: ");
INSERT INTO bef_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Afoꞌniga kehelitomo yaꞌma nagabu giseꞌna nanitoga niꞌina li heꞌmi netobo. Kaikamo kekesa kehelito bati huto yabe lutomo anana li heꞌmi netobo. To kai oꞌe litogomo nani ana nagabu gise foya li kofilube. ");
INSERT INTO bef_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","To agelo bo mone aitoga nehetiloto leꞌmo amuya moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesuhi sipi keta besilago moneꞌa hiti nunumu huꞌehina. Ya nohigo golaha gobi holoto melugu limo iꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ai nunumu ahu su holoto tito koko panaꞌa nehanaga buꞌehina. Enali sipi keta epesilago enubuꞌi ke filiꞌahago bu enogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","To ai ma luto lu epiꞌehina: Lenali hena hibe lite lenubuꞌi kelete nehabe? Lenali ho tite lenubuna hete mine fe lite nunumu hilenogo lenimiꞌi moloseꞌnauba lenalitoga huto mehilibe. ");
INSERT INTO bef_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu kaga noluto babu bonaꞌmagi neago Yutasiu, aposolo nagaluguti moneuba kohe to epalago eꞌahana. Ai Yesuhi nu kiloto yaꞌma bo yabe luto enelepilubeꞌmu Yesu nohinalo o leba toꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ya higo Yesu lu emiꞌehina: Kai yaꞌma nunu nokitanasiuba Kokulumaguti limiꞌehina Bomofihi fatehe bomagihi enayanugu neleꞌmo nomalapihe? ");
INSERT INTO bef_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Enali aposolo panaꞌamagi ana huto nohinana bu gelete ma lite lu emiꞌahana: Sipi Bo, sipi emitati ma liꞌohutatuꞌi enahaluta bati hutofihe? ");
INSERT INTO bef_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ya nelite moneuba emitatuꞌi lito sipi mono kaba boꞌanimofihi koko panaꞌa inaya igeka higo lamagaꞌaga ekesa i hesi heꞌmiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ya higo Yesu bu goloto ma luto lu emiꞌehina: Yaꞌma suhi anasi yagi lenali yatai heꞌmilo. Ya luloto ana bomofihi gufalo meko higo ana ekesaꞌa akuꞌi bati huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","To sipi mono bonaꞌi to mono noto kaba gimi negina bonaꞌi to olopa bonaꞌi enali Yesuhi leꞌmalune lite ana bonaꞌi ma luto Yesu lu epiꞌehina: Lenali emitaꞌi nelite osahi nelite hite neanaba lenali lubalo bo leꞌmaluneꞌmu nehafihe? ");
INSERT INTO bef_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nani asaga yupahi lenali hiti sipi mono nonugu minolata huꞌohuna lenali nani nagaꞌi menimiꞌahana yabe. Ya hiꞌahana yatai lenali kanatini huto nohigo metepunamofihi amuyaꞌa hiti yabe, Yesu ya luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ai ya luto alulago enali yato lite bilete leꞌmete mono bomagihi kaba boꞌanimofihi nonuga leꞌmete tiꞌahana. Ye nehago Pitau ai enemegeꞌi lifito fala kito buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Logo mone yaꞌmana nohi gegisagu geꞌahana ya hilete enali mineꞌahana. To Pitau ana bonaꞌi hiti ana logo gete nehanalo minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","To koko palalaꞌi mone ana logolo minanauba Pitahi bu go bati bati huꞌehina. Yaꞌmana palalaꞌuba amuya moloto buluꞌi holoto yahi fisu ho emito ma luto luꞌehina: Ma bo ai Yesu hiti minolata nohina bo yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ya ligo Pitau oꞌe luto luloto luꞌehina: Apaꞌniga. Nani ana bo mekeheliꞌohuna bomofi kumu nolane. ");
INSERT INTO bef_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nesiꞌasi mino ka nohigo bo moneuba Pitahi etafa huto bu goloto luꞌehina: Kai yaꞌma bo Yesuhi nagaꞌmoguti nohane. Ya ligo Pitau bahane hoto lu emiꞌehina: Nalaluꞌniga, nani fato bo nohube. ");
INSERT INTO bef_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ya luloto nesiꞌa mino yatama nohigo fato bo moneuba amuya mololoto yahi Pitatoga fisu holoto ma luto luꞌehina: Lusiga luto ma boya Yesuhi koko panaꞌa nohibe. Ai ana huto Galili kapolo bo nohibe, luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ya ligo Pitau: Oꞌe. Ma boya nani mekeheliꞌohuna kaga nolane. Ya noligo loegi monegi yupahi bahane holoto luto meleꞌisi ana baga hiti kokole nogo moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ya nohigo Yesu i behe huto bu golago buto Pitahi bugu bu gago Pitau koyapaꞌi Yesu ma luto lu emiꞌehina kaga ekesa hokolo huꞌehina: Yaꞌmana foluguꞌi kokole nogo memoloꞌehinogo loebe monebe yupahi Yesuhi mekeheliꞌohube luto bahane ho netalataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ya huloto Pitau fegutoga limiloto ginaga fito lubahaꞌa hosopa igo ginaga sipi huto amuya moloto yibi huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Enali Yesuhi yato lite kaba hu etete minana bomagi kiya yokolo hu emilete osahi heꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Enali Yesuhi bulo alo nagatu gi pili kelete osahi helete ma lite loka heꞌahana: Kiyiꞌafu osahi kohoꞌehifi kai lu limibo. ");
INSERT INTO bef_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ya nehite enali kaga bati mehinaꞌa hiti to huli ka hiti li eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Alihi yege tilago enali Isilaeli kaba bonaꞌi to monoto sipi kaba bonaꞌi to keya ka enelepise bonaꞌi enali li gehesa hilete enali Yesuhi leꞌmete kanisole bo nohaꞌanigu bilete ma lite liꞌahana: ");
INSERT INTO bef_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kai lu limibo. Kai Huꞌmau leꞌmo ho tiꞌehina bo, Mesia nohapi to fato bobe? To Yesu lu epiꞌehina: Nani lu lepilunaya nani kaꞌni keheli menimilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","To nani kaga mone lenoloka halunaya lenali ana kaꞌnilo nonaꞌa lu hokolo hite lu menimilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ya huꞌehinaya yatai hiti to asaga yupahi alihi Kokulumaguti limiꞌehina Bo ai Huꞌma asaga amuya aitogago nina Bomofihi yahi lamagaꞌaga minalinaꞌmu yabe, Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","To enali: Ya huꞌehinaya kaiya Huꞌmamofihi panaꞌa nohapihe? Ya lago Yesu lu epiꞌehina: Lenali alu huto hite nelabe. ");
INSERT INTO bef_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ya ligo enali liꞌahana: Lali fato bo Yesuhi kagaꞌa keheliꞌehina bo sa sa mehilune to lali yatai ma bomofihi bagaꞌaguti aꞌnoligo aꞌnokehelune. ");
INSERT INTO bef_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ya hilete enali asagaꞌi ho tilete Yesuhi leꞌmete Pailatihi bulo biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Enali hapi fite ka foya li etelete ma lite liꞌahana: Lali yaꞌma bo bu gota ai nagatimagihi hapaꞌani leꞌmo fato fato suhi huꞌehibe. Ai takisi sipi Lomu bo yaꞌma Sisatoga meheꞌmilo luto laga hu letalina kaga nolina bo yabe. To ai Mesiaꞌita gihiti bo nohube luto lulata nohina. ");
INSERT INTO bef_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ya lago Pailatiu Yesuhi loka hoꞌehina: Kai maꞌnaka luto Mesiaga Yuta bonaꞌmagi gihiti boꞌani nohapihe? Ya ligo Yesu Pailatihi kaꞌalo nonaꞌa lu emito luꞌehina: Kaika alu huto nohane. ");
INSERT INTO bef_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","To Pailatiu i behe huloto sipi monoto bonaꞌi hiti to asaga boanaꞌi minanamagihi ma luto lu epiꞌehina: Ma bomofihi foipanaꞌa bu megobe. ");
INSERT INTO bef_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ya ligo asaga bonaꞌmagi sipi hite kehe ilete ma lite liꞌahana: Ai boanaꞌmagitoga kaga lu epilago ai kaꞌauba asaga Yutia kegiꞌa boanaꞌi eneleꞌmo luba hulata nohina yabe. Ai Galili kapoguti hapi filoto yaꞌmana suhi humofaꞌna nohigo yatai yaꞌmalo noabe. ");
INSERT INTO bef_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatiu ana kaꞌanilo keheliloto ma luto enoloka hoꞌehina: Yaꞌmana boba Galili kapolo bo nohifihe? ");
INSERT INTO bef_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Enali lu emigo akeheliloto Yesu ai Helotiu kaba huꞌehina melugu bo nohigo keheliloto Helotiu nohinaga Yesuhi ho lifiꞌehina. To yaꞌmana yupahi Helotiu Yelusale hepatoga olotoꞌa minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helotiu Yesu bu goloto gelo biꞌehibe. Ai Yesuhi kaꞌago kehelilata nohuto hena huto ana bo bu galube luto kana yatamalo geba huto minoꞌehina. Yesu topa hoseꞌna foya mone li huto hinogo bu galube luto ekesa kehelito minolata huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ya higo Helotiu Yesuhi kaga babu luto fato fatoꞌi loka hoꞌehina yabe. To Yesu Helotihi kagaꞌalo nonaꞌa lu meemise minoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Enali sipi monoto bonaꞌi to keya kagalo keheli bati hiꞌahana bonaꞌi enali Yesuhi mehaꞌasilo nehite kaga amuya melete lilete ka foya li eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","To Helotiu gimi boꞌa hiti Yesu kaga foipa foipaꞌa lu etelete kiya hu eteꞌahabe. Ya nehite enali kata mone hetofa fayahaꞌauba lubo labo luꞌehina katatuꞌi hepi etelete heꞌmi etago Pailatiu nohinalo akuꞌi buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helotiu koyapaꞌi Pailati hiti fatehi lolo hite minelata hiꞌahaꞌina yabe. Ya hiꞌahaꞌina yatai li koguna iꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","To Pailatiu sipi mono bonaꞌi to kibina bonaꞌi to boanaꞌi hiti eneleꞌmo nupa higo enali ete li gehesa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ya hago ai lu epiꞌehina: Lenali yaꞌma bo akuꞌi leꞌmete nanitoga elete ma lite liꞌahabe, ai boanatimagihi bati mehina kaga lu noepina bo yabe. Ya liꞌahana nani yatai lenali lenogobisalo mana bouba kegeiyoꞌna li huto huꞌehilinaꞌmu beloloto bu gona asaga lenali lilete ka foyagu leꞌme nemalana suhi ai li huto mehuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","To Helotiu hiti ana huto yaꞌmanamofihi kegeiyo huꞌehilinanaꞌa bu megose nanitoga ho lifigo akuꞌi leꞌmete neabe. Lenali kehelilo, to ai yaꞌma bouba foipana sipiꞌa li huto ya huto haluta bati huto yabe to ai sipi foipana li huto mehuꞌehinaya hena hibe luto ho fililune. ");
INSERT INTO bef_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ya huꞌehinagi nani nagatuꞌi yaꞌmana bo biyigilotoꞌni gulu hoto heꞌmi etenogoꞌni bilibe. ");
INSERT INTO bef_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ya huꞌehina koyapa kanagu suhi mone ma hite megeꞌi melelata hiꞌahana. To Pasa noseꞌna nelata nehana yaꞌma sipi fuli kanagu Pailatiu nagalugu nehana boguti moneꞌisi eneleꞌmo heꞌmigo bilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ya noligo asaga boanaꞌi li nupa hite minanamagi sipi kehe ilete ma lite liꞌahana. Yaꞌma bo ho nefilite Balabasihi leꞌmo buto bi letobo. ");
INSERT INTO bef_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasiu ai gamani bonaꞌmagi kagaꞌmu luto luba li ho tiloto bo mone ho filiꞌehinalo nagalugu leꞌmo malago nominana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","To Pailatiu akuꞌi kehe ito lu epiloto Yesuhi heꞌmi etenogo bilubeꞌmu huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ya ligo enali kehe napa ilete ma lite liꞌahana: Malipu yafalo halo. Malipu yafalo halo. ");
INSERT INTO bef_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ya lago akuꞌi loegi monegi yupahi Pailatiu lu epiꞌehina: Lenali henaꞌmu nelabe? Ai yaꞌma bouba hena huse foipana li huto huꞌehibe? Aiꞌi ho fililuta foipanaꞌa nani bu megona bomuꞌi lenali halune halune nelabe. Ya huꞌehinagi nani naga osatuꞌi biyigilotoꞌni heꞌmi etenogo bilibe. ");
INSERT INTO bef_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ya ligo enali amuya melete uleꞌale hilete sipi kehe ite babu kaga lite ya hite malipu yafalo haluneꞌmu hiꞌahabe. To enali sipi kehe ite kaga lanauba Pailatihi kaꞌa hete leꞌmo meluga meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ya hago Pailatiu enali lana kaꞌaniuba hago enali enemegeꞌi moloto enabaga liyafa hilubeꞌmu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yaꞌma bo ai gamani bonatoga luba li huto huloto bonaꞌi enoho filiꞌehina bomofihi boanaꞌmagi akuꞌi leꞌmalune lite lago Pailatiu Balabasihi li gulu fo etago buꞌehina. To enali kaga lana enemegeꞌi moloto Yesuhi gimi bomagihi enayanugu moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Enali Yesuhi leꞌmete kapo melete nebite kapogu bo mone Simoni ai Sailini melugu bo fo telete yato liꞌahana. Ai kifiguti oto sipi hepalugu tilubeꞌmu nohina bo yabe. To enali Yesuhi malipu yafa lite giꞌnalo malago kofiloto Yesuhi megeꞌi moloto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","To babu boanaꞌi bululu hite megeꞌi lifite nebago lugaꞌa anaꞌmagi eniginaga fi emilete yibisu kalasu hi etete lubahaꞌani hosopa igo biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ya nehago Yesu i behe huloto ma luto lu epiꞌehina: Lenali Yelusale anaꞌise. Nani kumuꞌi yibi nama mehi netalo. Lenalitiniꞌmu hiti to lenali yagapanatinimagitoga yibi nama hi epalalo. Sipi ketanauba hu epalalibe. ");
INSERT INTO bef_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","To kana alihi mone huto hilina yupahi ma lite lilanaꞌmu: Enali anaꞌi yagapanaꞌi meketose, enali yagapanaꞌi meketeꞌahana, enali anaꞌi yagapanaꞌi amihi meligiꞌahana, yaꞌma enali bati hite minalunagihe. ");
INSERT INTO bef_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ya manana huto hilina yupahi enali kosamagihi ma lite lu epilanaꞌmu: Miya kosamaka limito ifi to letobo. To bohupoꞌmagihi leleꞌmo fala ki letobo, lite lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yatai yaꞌmana suhi yafa nogoyaꞌa hiti ninalo nehabe ya nehana enali yafa hosopa iꞌehinalo hena suhi hilana niꞌibe? yaꞌma luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Enali ana hite foipa bole loemo eteleꞌmete hiti biꞌahana. Enali Yesu hiti moneko kumu enoho fililuneꞌmu hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Enali bohupoꞌi mone nina kosa lataha felisa legita kosa yabe lite lilata nehanalo Yesuhi malipu yafalo nehete to foipa bole luga luga eteheꞌahana yabe. Moneꞌi yahi lamagaꞌaga nehete moneꞌi Yesuhi yahi sogaꞌaga malipu yafalo nehete hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ya hite neenahago Yesu ma luto luꞌehina: Foipanaꞌani li heꞌmi epolobo, Afoꞌniga. Enali yaꞌmana li huto nehananamofihi hapaꞌa ya suhi nohutagihe lite keheli bati mehiꞌehite nehabe. Ya noligo enali guketeꞌalo enaliꞌani kati yokoloꞌna hilete li futili katili hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bonaꞌi lugaꞌa analo ho tite minete gili gili nehago Yuta kaba bomagi Yesuhi kiya hi etete yokolo ka lu etete ma lite liꞌahana: Ai fato bonaꞌi eneheꞌmoꞌehina yabe. To ai lusiga luto kokulumaguti oꞌehina bo, Mesiau, Huꞌmamofihi panaꞌa nohutomo ai aiꞌa heꞌmalibe. Enali ya lite baiꞌi emite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Enali gimi bomagi hiti ana hite kiya yokolo hu eteꞌahana. Enali gufasilo bu leba telete ekesa nagamiꞌi emiluneꞌmu hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ya hilete enali ma lite baiꞌi emilete liꞌahana: Kai lusiga luto Yuta bonaꞌmagi kibina boꞌani nohutomo yalo yatai kaika kubuto bibo. ");
INSERT INTO bef_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","To fayahi mone ifo latahaꞌalo gete meleꞌahanamofihi kaꞌa ma luto minoꞌehina: Ma Bo Ai Yuta Bonaꞌmagi Gihiti Boꞌani Yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Foipa bo loemo malipu yafalo Yesu hiti etahana moneuba ma luto Yesuhi baiꞌi emito huli ka lu etoꞌehina yabe: Kai lusiga luto Mesiaga nohutomo kaika kubuto biloto leꞌaliꞌi leꞌeheꞌmobo. ");
INSERT INTO bef_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ya ligo mone malipu yafalo lugaꞌaga heꞌahana bouba ana kaꞌa keheliloto ma luto ka emekiꞌehina: Kai ai hina suhi luto kagabu noginaya kai Huꞌma kumu koli mehapihe? ");
INSERT INTO bef_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enali leꞌaliꞌi leꞌahanaya bati hite neleꞌahabe. Leꞌali bati mehina suhi li huto huꞌohuꞌina hapatiꞌamu lite bati hite neleꞌahabe. Ya huꞌehina ai yaꞌma bouba kegeiyo huto foipana li huto mehuꞌehina bo nohibe. ");
INSERT INTO bef_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ya luloto ma luto Yesuhi lu emiꞌehina: Yesuo. Kai alihi kaba bo lolo hulotomo nani kumuꞌi kekesu meheno. ");
INSERT INTO bef_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ya ligo Yesu ma luto lu emiꞌehina: Nani maꞌnaka luto lu nokumube. Yatai maꞌasi kai nani hiti miya omihi foyagu minaluꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","To fuligaha kana lolo hulago analo asaga melugu metepu i baga ito buto utehi yege nesiꞌasi limiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","To kaꞌmuya sipi mono nonugu pa sose kagamofi kumu hasa hu meleꞌahanalo kata mone sipi yatamalo li putu putu tite i hekini leꞌahana yaꞌma folaganuguti i hegege huto i loe huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","To Yesu sipi kehe moneꞌa hiti iloto ma luto luꞌehina: Afoꞌniga. Kai kayanugu nemehaꞌni nomolobe. Ai ya luto luloto afiliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Gimi bomagihi kaba boꞌaniuba yaꞌmanana huto hinamofihi hapaꞌa bu go su holoto Huꞌmamofihi gelo bi emito ma luto luꞌehina: Maꞌnaka luto yaꞌma boya bebe sana bo yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","To asaga boanaꞌi ete li nupa hite gili gili hana asagaꞌna huto higo enubuꞌaniguti bu ganamagihi sipi enelesaꞌani ligo yaꞌmana fato huseꞌna huto hibe lite enekesa keheli keheli hilete i behe hite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuhi laluꞌagi lugaꞌa hiti to anaꞌi lugaꞌa hiti Galili kapoguti Yesuhi megeꞌi lifite eꞌahanamagi nesiꞌasi fotoꞌi mino melete mineꞌahana enali asagaꞌna Yesuhi hu etanana bu geꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","To bo mone minoꞌehina ai giꞌa Yosefe. Ai sipi hepaꞌi mone Yuta melugu nina hepaꞌi giꞌa Alimatia hepato bo yabe. Ai kanisole nohuto komopaꞌa bati huto niꞌigo bebe soto koyone huto nominana bo. ");
INSERT INTO bef_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","To ai mono kanisole bonaꞌi lugaꞌamagi Yesu kumu lulata hana kaꞌani lagaꞌa mebesilata huꞌehina. Ai Huꞌmamofihi Kapoꞌa alinaꞌmu yabe luto geba huto nominana bo. ");
INSERT INTO bef_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yaꞌmana bouba Pailatitoga buto loka hoto luꞌehina: Nani Yesuhi gufaꞌa lilubeꞌmu nohunaya bati hutofi lilubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ya luto luloto Pailatiu: Oꞌyo, ligo Yosefeu buto Yesuhi gufaꞌa malipu yafaloti lilago limiloto koholi katagu leꞌmo mololoto sa gi etoto lito buto muli kapo efanugu lolo hiꞌahana koyapaꞌi filiꞌehina bonaꞌi memeleꞌahana ana mulilugu moloꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yaꞌma kana ai fuli kanalo nete minalana noseꞌna li loloba huse kanagu niꞌinamo to fuli kanaꞌa yatai ahuto hilubeꞌmu nohibe. ");
INSERT INTO bef_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","To anaꞌi enali Galili kapoguti ho tilete Yesuhi megeꞌi lifite eꞌahana anaꞌi enali Yosefehi megeꞌi melete biꞌahana yabe. Ya hilete enali efaha muliꞌi bu geꞌahana yabe. To ana bite Yosefeu Yesuhi gufaꞌa hena hena huto malafi lite bu go bati hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Enali abu gelete nohaꞌaniga bila bila hiꞌahana. Ya hilete enali tu mesebe hiti to hetofa kifina hiti li loloba hiꞌahana yabe. To fuli yupahi enali keya kauba luꞌehina suhi hite mino fulu hite enabasu biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","To yalo etehi foluguꞌi ana anaꞌmagi tu mesebe hiti to tu bina kifina hiti li loloba hite meleꞌahana lileteꞌani Yesuhi gufaꞌa meleꞌahana efaha mulito biꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","To sipi efatuꞌi muli kasihaꞌalo i hekini leꞌahana ali behe hu heꞌmiꞌahago hokolo huto niꞌigo bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ya hilete enali ana muli kasito bilete heꞌmi eteꞌahana nebelusalo bu gana Sipi Bo Yesuhi gufaꞌa meniꞌigo bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya huꞌehigo enali enekesa yigi fato fato hilete negi nagi nete nehago bo loemo ana lebato ho tiꞌahaꞌina to etali guketeꞌatitiuba fi besa lo baga iꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Enali ana anaꞌi enelesaꞌani ligo koli hilete melugu lipi gehesa i baga iꞌahana. Ya nehago etali ana anaꞌi lu epiꞌahaꞌina: Lenali hena hibe lite filiꞌahana bonaꞌmagi hepalugu aho tiꞌehina bomofi kumuꞌi sa sa nehabe? ");
INSERT INTO bef_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ai malo menohibe. Ai aho tiꞌehibe. Ai Galili kapolo lenali hiti nohuto ma luto lu lepiꞌehina kaga molo lenali lenekesa yigilo. ");
INSERT INTO bef_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Enali Kokulumaguti limiꞌehina Bo foipa bomagihi enayanugu binogo malipu yafalo henogo filito loegi monegi yupahi ho tilinaꞌmu yabe luto lu lepiꞌehinamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ya laꞌigo enali ana anaꞌi Yesu koyapaꞌi lu epiꞌehina kaꞌa enekesa hokolo huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ya higo enali ana muli efa kapo heꞌmite i behe hite biꞌahana. Ya hilete enali bite aposolo panaꞌa nayahi luga luga su hoto nigigusagati mone heleko malago nehanamagi hiti to asaga bonaꞌi lugaꞌa hiti asaga kaga lu epiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","To ana anaꞌi enali anana huto hina bu geꞌahanaya Malia yaꞌma Magatala hepato aꞌi yagi Yoana yagi to Malia, Yemesihi itoꞌafu yagi to lugaꞌa anaꞌi hiti bite bu geꞌahanamagi Yesuhi aposolo panaꞌa ya huto asagaꞌna huto huꞌehibe lite lu epiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ya lite lu epigo enali aposolo panaꞌamagi kilihe ka beto hu nelimibe lite ana kaꞌani li latahaꞌanigu memeleꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","To akuꞌi Pitau ho tito hololu luto buto ana Yesuhi heꞌmi eteꞌahana mulito nehetiꞌehina. Ya huloto ai lipito ana muli kapoluga bu golago tina Yesuhi sa gi eteꞌahana kataꞌago niꞌigo bu goꞌehina. Ya huloto ai akuꞌi i behe huto hepatoga buloto yaꞌmana huto huꞌehinanamuꞌi ekesa keheli keheli huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana yupahi Yesuhi panaꞌaloboꞌa loemo kapo melete lagaso hepaꞌi mone Emeasi yabe lilata nehanalo biꞌahaꞌina. Ana hepaꞌi Yelusaleti foto huka huto nina hepato yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Etali kapo melete nebite asagaꞌna huto nohinanamofihi kaꞌa beto hite biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Etali kaga beto hite nebite ana kaga ai lu emigo ai lu emigo hite nebaꞌigo Yesu aiꞌa oto folagahaꞌatitigu huto hulago li moneko hite moneka biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","To etali ai abu gaꞌinaya to ai Yesu nohibe lite okabaꞌa bu go fe lite hite bu megeꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","To ai ma luto etoloka hoꞌehina: Letali henanaꞌmu kaga lime lime nebite kapo nemalaꞌibe? Ya ligo etali etiginaga fina bole mopo mehise ho ti fefe hiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ya hilete mone bo giꞌa Kiliopasi yabe lite giꞌa nehana bouba ma luto lu emiꞌehina: Babu bonaꞌi fato fato hepatoti li nupa hite yatai Yelusale hepato nehabe. To kai moneꞌisimaka asagaꞌna Yelusale hepalugu yatai kanaꞌagu huto huꞌehinanaya mekeheliꞌahapihe? ");
INSERT INTO bef_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ai ya luto loka hago Yesu ma luto loka hoꞌehina: Henana huto huꞌehibe? Kai lu nimibo. Etali ma lite lu emiꞌahaꞌina: Yaꞌmana Nasalete bo Yesu aito huto huꞌehinana yabe. Ai ka lu yege hose bo nohuto ai asaga boana enubulo hiti to Huꞌmamofihi bulo hiti amuya liliꞌna liloto to amuya kaga lu epiꞌehina bo yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","To enali sipi mono boti to enali enikibina botimagi enali gamani bomagihi enayanugu meleꞌahana yabe. Ya hago enali malipu yafalo ho filiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ya huꞌehina lali koyapaꞌi ma luto lekesa yigi emiꞌohuta. Ai yaꞌmana bouba Isilaeli boanaꞌi enubuto bito eneleꞌmo hetofa kapogu malalibe luto keheliꞌohuta yabe. To mone kaya ma huto niꞌibe. Asagaꞌna ahuto huꞌehina kanaꞌaya yatai loegi monegi yupahi lolo hilubeꞌmu nohibe. ");
INSERT INTO bef_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","To yatai etehi foluguꞌi anaꞌi lugaꞌa lali nagaluguti mulito bite Yesuhi gufaꞌa sa sa hana minigiꞌehigo enali i behe hite ete ana kaga lu limigo lali topa hoto tili huꞌohuta yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","To enali ya hite ete lalitoga ma lite liꞌahana yabe: Lali agelo bomagihi enemehaꞌani bu gonogo ana agelouba ma luto lu limiꞌehina: Ai aho tito nohinagihe luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","To lalitiguti bo lugaꞌamagi ana hite bite ana Yesuhi meleꞌahana muliꞌi bu geꞌahana yaꞌa anaꞌmagi liꞌahana suhi lite Yesuhi gufaꞌa bu megeꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ya luto lulago Yesu ma luto lu etimiꞌehina: Letaliya negi neꞌahaꞌibe. Koyapaꞌi lu huto huto bonaꞌmagi geꞌahana kaꞌanimu letali keheli fulu hite li latahatitigu meleꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Henabe lutobe? Mesiahi yataꞌa gabu foya kofiloto su henogo Huꞌmau leꞌmo ho tigo alihi Huꞌmamofihi fana mehenaꞌagu tiꞌehibe, luto, ");
INSERT INTO bef_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","to ai Moseu hiti to lu huto huto bomagi hiti ai kumu fayahi koyapaꞌi geꞌahanaloti mono kaga silagaꞌnamo hapi fito luto tiloto etegekesa lu hokolo huꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ya ligo enali kapo melete bite etali neminaꞌina hepato tiluꞌibeꞌmu nehaꞌigo Yesu ai etimiꞌi molo ka huloto kapogagoꞌi bu bebe salubeꞌmu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ya nohigo etali yato lite leꞌmo melelete ma lite lu emiꞌahaꞌina: Yege alimi foloseꞌna nohina sinihi gilinaꞌmu yagi kai leꞌali hiti buto kalune. Ya laꞌigo Yesu etali nonuga tite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Alihi enali noseꞌna naluneꞌmu nehite Yesu etali hiti moneto mineꞌahana. Ya huloto ai beleti noseꞌna liloto Huꞌmamofitoga fokehi ho emiloto gofa hoto etimiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ai ya nohigo etali etubuꞌatiti i fana tago Yesuhi bu gete akeheliꞌahaꞌina yabe. Ya nehaꞌigo anaꞌasilo Yesu etali etubulo minigiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","To etali kaga liꞌahaꞌina: Leꞌali kapo moloto nooꞌigo ai mono kamofihi hapa hapaꞌa lu leꞌemiꞌehina nohigo ana kanalo komopatiꞌagu sabiyana lolo hu leꞌetoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Etali ya lite lilete anaꞌasilo ho tite i behe hite Yelusale hepatoga biꞌahaꞌina. Etali nehetilete nayahi luga luga su hoto nigigusagati mone heleko malago Yesuhi aposolo panaꞌa hiti to lugaꞌa bonaꞌi hiti li nupa hite nehago bu enegeꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","To enali lu etimiꞌahana: Lusiga luto Sipi Boti aho tiꞌehibe. Simoniu aiꞌa abu goꞌehibe. ");
INSERT INTO bef_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Enali ya lago etalitoga ana hite kapo melete nebaꞌigo Yesu etubulo huto huꞌehina kaga ana hite beto hite lu neepite to ya huto beleti noseꞌna lito gofa hoto leꞌemigo bu go bati huꞌohuꞌibe, lite lu epiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Enali yaꞌmana kaga beto kato hite lu keheli fa keheli hite nehago Sipi Bo aiꞌa folagahaꞌanigu huto huꞌehina: Fuluna lenalitoga mineno, luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ya higo enali topa hete sipi koli hilete fele noabe lite keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ya nehago Yesu ma luto lu epiꞌehina: Lenali henabe lite topa nehabe? To lenali henabe lite lenekesa yigi yigi nehabe? ");
INSERT INTO bef_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lenali nigi nayahaꞌni bu galo. Naniꞌni nohube. Lenali nani nugufalo li kehelite, bu galo. Ai felemofihi gufaꞌa hiti felisaꞌa hiti meminolata nohibe. To naniya nugufaꞌni hiti felisaꞌni hiti niꞌigo bu negabe. ");
INSERT INTO bef_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesu ya luto lu epiloto ai yahaꞌa hiti gigusaꞌa hiti enelepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ya ligo enali enegelo gofa bilete Yesuhi kaꞌa li latahaꞌanigu memelese ai nohibe lite mekeheligo Yesu enoloka hoꞌehina: Lenali noseꞌna meleꞌahafihe? ");
INSERT INTO bef_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ya ligo enali laita hiꞌahana fayaꞌi nekisa meleꞌahanana li emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ya hago ai ana fayaꞌi liloto enubulo noꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ya huloto ai ma luto lu epiꞌehina: Koyapaꞌi nani lenali hiti nohutoꞌni alu lepiꞌohuna yabe. Asaga kaga nani kumu lite Mosehi bukugufi to lu huto huto bomagi bukugufi to nama liꞌahana bukugufi koyapaꞌi fayahi geꞌahana asaga yaꞌmana kagauba legeyaꞌa manaꞌa huto hilibe luto lu lepiꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","To ai ya luto lu epito enegekesa lu hokolo higo enali Huꞌmamofihi kaꞌa fayahi goꞌehina keheli bebe seꞌahana. ");
INSERT INTO bef_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ya hago ai lu epiꞌehina: Mono kagu ma luto nina yabe. Mesiau gabu giseꞌna li kofito fililoto loegi monegi yupanugu akuꞌi kene keliguti ho tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","To ai giꞌalo Yelusale hepatoti hapi filete kagaꞌa lite noto noto bonaꞌi asaga kapoga lu yege henogo ai giꞌalo komopaꞌani i gelehe hilete foipanaꞌaniꞌguti mino bati hinogo Huꞌmau foipanaꞌani li heꞌmi epalalibe. ");
INSERT INTO bef_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lenaliya yaꞌma lu nolepuna kaga li futili katili hite yege yege bonaꞌi lu epilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ya nehinogo Afoꞌnifu ka molo yofo huꞌehinana naniꞌni lenalitoga ho lifinogoꞌni limilinaꞌmu. Lenali yaꞌmana nohi hepalugu geba hite nehinogo kokulumamofihi amuyanaꞌa lenalitoga alina yupahi hapi filinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ya huto lu epiloto ai eneleꞌmo bululu huto hepaluguti fegutoga limilete Betani eneleꞌmoto buꞌehina yabe. Ya huloto ai yahi li saga huloto lusa gi epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ai lusaꞌa gi epoloto nohigo Huꞌmau fulu fulu huto kokulumalugu leꞌmo saga huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","To enali Yelusale hepaꞌani i gelehe hite nebite enegelo bime bime biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ya hilete enali asaga yupahi sipi mono nonugu nehite Huꞌmamofihi giꞌa liyafa hiba hiba hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Koyapaꞌi yataꞌa meꞌmo asagaꞌna huto mehuꞌehigo Kaga minoꞌehina. Ai to Huꞌma hiti moneka mineꞌahaꞌina yabe. Kaga to Huꞌma aiꞌa moneko legege nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Koyapaꞌi yataꞌa Kaga Huꞌma hiti moneka mineꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Huꞌmamofihi Kagaꞌauba asagaꞌna ailugutiko lolo huto tiꞌehina to mone lolo huꞌehinaꞌa be meligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mino kosaba husemofihi kaga ailugu niꞌigo yaꞌmana kagauba asaga bonaꞌi eneleꞌmo fana tolata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yaꞌmana fana mehuba metepu li besa lolata nohinagi metepuꞌuba fana mehi leꞌmo fi tolata menohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","To Huꞌmau bo mone ho lifiꞌehina ai giꞌa Yoni yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yoniu kohe toto fana mepofi kumu yaꞌma kagaꞌa boanatoga lu yege henogo asaga bonaꞌmagi kehelilete ana kaga komopaꞌanigu li malalabe luto huto huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoniu aiꞌa fana mehi menohina ai yaꞌma fana mehi kumu boanatoga kaga lu yege halubeꞌmu oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yaꞌmana fana mehi lamanaꞌauba asaga melugu noto noto bonaꞌi eneleꞌmo besa lo baga ilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ana Kaga ai melugu nohuto to yana Huꞌmamofihi Kagaꞌauba asaga meꞌmomuꞌi lolo li huto huꞌehina niꞌinaya to melugu boanaꞌmagi aiꞌi keheli bati mehiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aiꞌa meꞌalo oꞌehinagi akuꞌi aiꞌa bonaꞌamagi bu go bati hite be tigite agoya hu meemiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","To bonaꞌi lugaꞌamagi be tigite leꞌmo bati hite agoya hu emiꞌahana. To ya hiꞌahanamagihi yaꞌma Huꞌmamofihi yagapanaꞌa yabe luto ai eneleꞌmoto enebe tigiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Enali Huꞌmamofihi yagapanaꞌa lolo hiꞌahana itoꞌanigihi afoꞌanigihi enugufa enemeto meniꞌibe. Huꞌmau aiꞌa yagapanaꞌni yabe luloto afoꞌanifu nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kagauba ai bo huto huloto lali folagahatigu minoꞌehina. Lali ai fana mehaꞌa abu goꞌohune. Ai yaꞌma moneko panaꞌmofihi fana mehaꞌa afotifu ho lifigo oꞌehina aitoga fulunaꞌa hiti ka lamanaꞌa hiti bai toto minoꞌehibe. Ai fana mehaꞌaya panaꞌa yegeꞌa aigo afoꞌafitogati liꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoniu sipi kehe ito kagaꞌa ai kumu ma luto lu yege hoꞌehina: Ai yaꞌma alihi nemegeꞌi noanauba nebe ligito kibina bo nohina luto henaꞌmugope ai koyapaꞌi yataꞌa mino lito buꞌehigo nani alihi itoꞌnifu neketoꞌehina yabe. Ai yaꞌma bomofi kumu luꞌohuna yabe luto Yoniu ya luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bonaꞌi eneheꞌmoseꞌnaꞌa samahi tiꞌehinaguti limito lusa gi letoꞌehina koyo koyo bito lusa limiba limiba nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Henaꞌmugope Huꞌmau keya ka Mosehi bagalo moloꞌehina. Ya huꞌehinaya leheꞌmoseꞌna hiti to ka lamanaꞌa hiti Yesu Kilisitotogati noabe. ");
INSERT INTO bef_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","To bonaꞌi moneuba Huꞌmamofihi bu megoꞌehibe. Yaꞌma Huꞌmamofihi panaꞌa monekoꞌuba ai afoꞌafi hiti moneka mine hepiꞌahaꞌinauba Huꞌmamofihi hapaꞌa lu huto huto lu limiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuta bonaꞌmagi mone yupahi mono noto bonaꞌi lugaꞌa hiti to Libai nagaꞌamofihi bonaꞌi lugaꞌa Yelusale hepatogati enoho lifigo Yoni nohinalo henetite loka haluneꞌmu hiꞌahana: Kaibe, kiyiꞌaga nohane? ");
INSERT INTO bef_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ya lite loka hago Yoniu kaga mone bahane mehose lu huto huto ma luto lu epiꞌehina: Nani Huꞌma leꞌmo ho tiꞌehina bo, Mesiaꞌita yaꞌma menohube. ");
INSERT INTO bef_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Enali akuꞌi loka heꞌahana: Kai kiyiꞌaga nohane? Kai Elaiyaga nohapihe? Yoniu nonaꞌa luꞌehina: Oꞌe, yaꞌma menohube. To akuꞌi loka heꞌahana: Kai kaga lu huto hulata kegeba huꞌohuta bomo nohapihe? Ya lite loka hago Yoniu: Oꞌe, luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kai kiyiꞌaga nohapi lu limibo. Lali loho lifiꞌahana bonatoga kagalo nonaꞌa lu epilutaꞌmu yagi kaika kiyiꞌaga nohube nolane? ");
INSERT INTO bef_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ya lite lago Yoniu lu epiꞌehina: Nani mana nohube: Bo moneuba ka meluguti Sipi Bomofihi Kapoꞌa bili etobo luto, sipi kehe noinamofihi nogoꞌa nohibe. Yaꞌma kehe noinana nani nohube. Koyapaꞌi lu huto hulata bo Aisaiyau yanana luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Loka heꞌahanamagi enali Felosi bonaꞌmagi yaꞌma Yonitoga enoho lifigo eꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Enali loka heꞌahana: Kai Mesiaꞌita menohube lane to Elaiyaꞌita menohube lane to kaga lu huto hulata bo sipiꞌa menohube lane, yalo kai hena hibe luto boanaꞌi nagamiꞌi nofolo epalane? ");
INSERT INTO bef_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ya lite loka hago Yoniu kaꞌanilo nonaꞌa ma luto epiꞌehina: Nani faꞌmene nagami lafatu nagamiꞌi nofolo epolonaya folagahatinigu bo mone ho tito nohina bu megeꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ai nani nemegeꞌi alihi noabe ya nohina nani ana bomofihi gigu suꞌamofihi naga gulu ho etalunaꞌa huto bati menohube. ");
INSERT INTO bef_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yaꞌmana kaga liꞌahana Betani hepato Yotani nagamiꞌi muya beletoga huto huꞌehina. Analo Yoniu nagamiꞌi folo epoloꞌehina hepatoya. ");
INSERT INTO bef_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Etekaꞌa Yesu Yoni nohinalo ago bu goloto ma luto lu epiꞌehina: Malo Huꞌmamofihi sipisipi yaga nalaꞌa nohibe. Ai asaga noto noto bonaꞌmagi foipanaꞌani li heꞌmi noepololata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yaꞌma bomofi kumu ma luto lu lepilata nohuna: Bo mone alihi nemegeꞌi noana ai nebe ligito nohibe. Henaꞌmugope ai koyapaꞌi analo nohigo alihi nani itoꞌnifu neketoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nani aiꞌi keheli bati mehuꞌohuna. Ya huꞌohunaya yaꞌmana bo Isilaeli bonaꞌi enelepilube luto nagami lafahi boanaꞌi folo epoloꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yoniu kaga mone ma luto lu huto huꞌehina: Sikalafuꞌuba nama lolo huto kokulumaꞌi heꞌmito limito aito minoꞌehigo bu goꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nani aiꞌi keheli bati mehuꞌohuna niꞌinaya Huꞌma aiꞌa nagamiꞌi buto folo epolobo luto noho lifiꞌehina ma luto lu nimiꞌehina: Kokulumaluguti limito bo moneꞌmofito latahaꞌalo nominenogo bu galata bouba ai bonaꞌmagitoga Hetofa Sikalafu ho lifigo limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","To nani anana abu goꞌohube. Ana bo Huꞌmamofihi panaꞌa nohibe lu nolepube, luto Yoniu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yago etekaꞌa Yoni panaꞌaloboꞌa loe hiti ho tite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ya hiꞌahago Yesu anaga kapo moloto nobigo Yoniu bu goloto ma luto luꞌehina: Bu galo. Ma bo ai Huꞌmamofihi sipisipi nalaꞌa nohibe. ");
INSERT INTO bef_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Loe panaꞌalobomaleꞌi Yoniu ya luto linaꞌa akehelilete Yesuhi megeꞌi lifite biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ya nehaꞌigo Yesu i behe huto bu etogoloto ma luto lu etimiꞌehina: Letali henanaꞌmu sa sa nehaꞌibe? Ya ligo etali ma lite lu emiꞌahaꞌina: Labai, kai hiya nonugu nominane? liꞌahaꞌina. Yaꞌma Labai lali kagaluguti lu gelehe huto babafi bo yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ya lite loka haꞌigo: Letali ete bu galiyo, luto Yesu lu etimiꞌehina. Ya ligo etali nohi nominana bite bu gelete ai hiti ana yupahi analo mineꞌahana. Henaꞌmugope utehi yege alimi falalubeꞌmu nohigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Atulu, Simoni Pitahi gonaꞌauba Yonihi kagaꞌa kehelilata nohinauba Yesuhi megeꞌi moloto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ai yataꞌa buto goꞌafihi Simonihi sa sa huto bu goloto ma luto lu emiꞌehina: Lali Mesiahi abu goꞌohune, luꞌehina. Yaꞌma Mesiahi ho gelehe huto Kilisito, gimofihi hapaꞌa Huꞌmau leꞌmo ho tiꞌehina bo, nolune. ");
INSERT INTO bef_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ya lu emiloto Simonihi leꞌmoto Yesutoga buꞌehina. Ya higo Yesu bu goloto ma luto luꞌehina: Kai Yonihi panaꞌa Simonigamo nohane. Alihi kai kigika Kifasio luto halutaꞌmu yabe, luꞌehina. Yaꞌmana giꞌa lu gelehe hiluta Pita, ai mana gimofihi hapaꞌa Efahi yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yago etekaꞌa Yesu Galili kapogu bilubeꞌmu nohuto Filipi bu goloto: Nemegeꞌi obo, luto kehe iꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipiu ai Betesaita hepaꞌi Atulunogo Pitanogo ana hepato bo yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","To Filipiu bo mone Natanielihi sa sa huto bu goloto ma luto lu emiꞌehina: Koyapaꞌi Moseu ma bomofi kumu keya kagu goꞌehinamo lali abu goꞌohune. Ai Nasalete hepatoti Yosefehi panaꞌa yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ya luto ligo Natanieliu loka hoꞌehina: Nasalete hepatoti anaꞌina hetofaꞌa mone huto hilina niꞌifihe? Oꞌe. Ya luto loka hago Filipiu lu emiꞌehina: Kai oto bu gobo. ");
INSERT INTO bef_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanieliu Yesu nohinalo nobigo bu goloto ai kumu ma luto luꞌehina: Bu galo. Ma bo lusi Isilaeli meto bo faga faga menina bo nohinagihe. ");
INSERT INTO bef_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ya ligo Natanieliu loka hoꞌehina: Kai naniꞌi hena huto keheliꞌahane? Yesu lu emiꞌehina: Filipiu kaiꞌi kehe meiꞌehigo nemuya yafa hapaꞌaluga nohanogo bu kogoꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ya luto lu emigo Filipiu luꞌehina: Tisao, kai Huꞌmamofihi panaꞌa nohane. Kai Isilaeli meto gihiti bomo nohane. ");
INSERT INTO bef_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ya ligo Yesu kaꞌalo nonaꞌa ma luto lu emiꞌehina: Kai nemuya yafa hapaꞌaluga nohanogo bu kogoꞌohube noluna kaga keheli uleꞌale huloto nolapihe? Alihi yaꞌmana mone be ligito sipina bu galataꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","To Yesu ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube, kokulumaꞌi hokolo nohinogo Huꞌmamofihi ageloꞌamagi Kokulumaguti limiꞌehina Bomofilo tila limila nehinogo lenali bu galanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Galili kegiꞌa Kena hepato loegi monegi yege minoloto bo alobole loemo etayanugu liꞌahaꞌina. Bo alobole etayanugu liꞌina nonugu Yesuhi itoꞌafu minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bo alobole etayanugu lilaꞌina ete bu galube lite Yesu hiti panaꞌaloboꞌa hiti kehe ite elesana meleꞌahago anaga bite nehetiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","To bai nagamiꞌi aꞌne su helago Yesuhi itoꞌafu lu emiꞌehina: Enali bai nagamiꞌani asu hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ya ligo Yesu lu emiꞌehina: Ma aꞌi yale, nani kumu ka ya hubo ya hubo melubo. Nani kanaꞌni meoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ya ligo koko panaꞌamagihi Yesuhi itoꞌafu ma luto lu epiꞌehina: Lenali ai kaga lu lepilinamofihi megeꞌi malalo. ");
INSERT INTO bef_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","To Yuta bonaꞌmagi mono hapaꞌaniuba luꞌehinaꞌa huto enayahaꞌani okala hilanaꞌmu lite me somo loegi loegi loegi babu nagamiꞌi moneko mesomogu hefiseꞌa nonuga minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma me somogu asagaꞌi nagamiꞌi hefi bai talo, luto koko panaꞌi Yesu lu epiꞌehina. Ya ligo enali nagamiꞌi hefi bai te su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ya hilago ai lu epiꞌehina: Lenali nagami anaguti lugaꞌa hekite lite bite noseꞌnalo kaba huꞌehina bomofihi emilo ligo enali ana hite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ya hago noseꞌna kaba huꞌehina bouba nagamiꞌuba bai nagami lolo huꞌehina nesiꞌa hekito nokeheliꞌehina. Hiyagati yaꞌma bai nagamiꞌi ite eꞌahafi luto ekesa yigiꞌehina. Ya hinaya to enali ana nagami hefite bana koko panaꞌmagi akeheliꞌahana yabe. To noseꞌnalo kaba huꞌehina bouba lihaꞌa yanugu nolina bomofihi kehe ito lu emiꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Asaga bonaꞌmagi bai nagamiꞌi manaꞌa yataꞌa guna igo ne su helete alihi bai nagamiꞌi nesiꞌa sibina huꞌehinana guna igo nelata nehanana ninaya kai bai nagamiꞌi manaꞌamo mololoto nohatiti yatai lito ane. ");
INSERT INTO bef_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galili kegiꞌa Kena hepato Yesu amuya liliꞌnaꞌa yaꞌma yataꞌa yupahi li huto huꞌehina. To ai hetofa hapaꞌa enelepilago panaꞌalobomagi Yesuhi komopaꞌani emite keheli bati hi eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yaꞌmanana su holago Yesuhi itoꞌafu yagi gonaꞌa hiti to panaꞌaloboꞌa hiti Kapaneami hepato limite lugufa kana mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuta bonaꞌmagi Pasa noseꞌna yaꞌma koyapaꞌi Huꞌmau lubuto biꞌehina yupa kumu luto noseꞌna naluta kanaꞌa leba notago Yesu Yelusale hepato tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","To sipi mono nonuga bonaꞌi lugaꞌamagi bulumaka yaga, sipisipi yaga to namalo maketi melete nehago ai tito bu enogoꞌehina. To lugaꞌa bonaꞌmagi efahi li behe hite epilata hite nehago bu enogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ya huloto Yesu nagaꞌi mone lito bonaꞌi i biyigilata nagaꞌi lolo huloto bulumaka yaga, sipisipi yaga to bonaꞌi hiti sipi mono nonuguti enegene ito fegutoga eneleꞌmo heꞌmiꞌehina. To efahi leka sose to li behe hite epite nehana bomagihi hitaꞌani ai li tiligi soto efahaꞌani libe fulugu bibe huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","To namalo bisinisi li huto bomagihi ma luto lu epiꞌehina: Lenali afoꞌnifihi nohaꞌa situa li lolo mehite anaꞌinatini lite bufa hilo. ");
INSERT INTO bef_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ya ligo enali koko panaꞌamagi koyapaꞌi mono bukugu ka mone ma luto niꞌinauba enekesa i hokolo huꞌehina: Oho, Huꞌmao, kai nohaka sipina nebesinana niꞌigo bonaꞌmagi li sibina hilana komopaꞌnigu golo nobibe. ");
INSERT INTO bef_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesu ya huꞌehigo Yuta bonaꞌmagi i behe hite loka heꞌahana: Kai amuya liliꞌna hena huseꞌi sipi li huto hitogo kai maꞌnaka luto kigi niꞌigo yaꞌmana liliꞌna noline lilune? ");
INSERT INTO bef_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ya lite lago Yesu kaꞌanilo nonaꞌa luꞌehina: Lenali ma Huꞌmamofihi nopo tele bilenogo nohi loegi monegi yegegu nani akuꞌi gilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ya ligo enali Yuta bomagi liꞌahana: Kufu 46 enebe ligigo ma nohi gi su heꞌahanamo ninaya kai loegi monegi yupahi li ho tito akuꞌi gi su halube nolapihe? ");
INSERT INTO bef_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu kaga luꞌehina mono nohiya aiꞌa yaꞌma gufaꞌamu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Alihi Yesu mala mala hepaga limito yege loegi monegi minotoꞌa akuꞌi filiꞌehinaguti ho tina yupahi panaꞌalobomagi koyapaꞌi yaꞌmana ka luꞌehinaꞌa enekesa i hokolo huꞌehina. Ya higo yaꞌma mono bukugu fayahi goꞌehina kaꞌa hiti to Yesu yaꞌmana luꞌehina kaꞌa hiti beto hite keheliya ite komopaꞌanigu meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","To Pasa noseꞌna nelatana bonaꞌi Yelusale li gehesa hite nose kanaꞌalo Yesu lusi amuya liliꞌna fato fatoꞌi li huto hina yaꞌma babu bonaꞌmagi bu gelete aitoga komopaꞌani emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ya hana enaliꞌi Yesu keheli meepiꞌehibe, henaꞌmugope ai asaga bonaꞌmagi hapaꞌani akeheli su hoꞌohuto yabe. ");
INSERT INTO bef_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bonaꞌmagi kumu bo moneuba ya huse bo nohibe luto lu meemilinaꞌmu. Henaꞌmugope ai asaga bonaꞌi yege yegeꞌi nehanamagi komopaꞌani hiti hapaꞌani hiti akeheli baga iꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yuta bonaꞌmagi kaba boꞌani mone minoꞌehina ai Felosi nagaluguti bo giꞌa Nikotimasi yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mone yupahi ai sininugu Yesutoga oloto ma luto lu emiꞌehina: Tisao, kai Huꞌmau koho lifigo limiꞌahata babafi nohataya lali akeheliꞌohune. Kai lusi liliꞌna nolitaꞌa huto mone keneꞌuba melilina Huꞌma aitoga mino hetofa hulenogomo yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ya ligo Yesu luꞌehina: Nani maꞌnaka luto lu nokumube. Keneꞌi moneuba Huꞌmamofihi Kapoꞌa bu megalina ai itoꞌafu akuꞌi keto kosaba hu tegi hilinaubago yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ya ligo Nikotimasiu loka hoꞌehina: Olopa bouba itoꞌafihi mupaguti akuꞌi hiyaꞌa huto limilinabe? Itoꞌafihi mupagu akuꞌi tinogo loe yupahi ketalinaꞌa huto meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ya luto ligo Yesu kaꞌalo nonaꞌa luꞌehina: Nani maꞌnaka lusiga luto lu nokumube. Keneꞌi moneuba Huꞌmamofihi Kapoꞌa bu galube linogomo ai nagamiꞌuba hiti to Sikalafuꞌuba hiti yataꞌa keto kosaba hilinaubago yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Anaꞌina bona enugufaguti huto hulata nohina ya enugufa yabe. To Sikalafuꞌuba li huto hulata nohina ya Sikalafuꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Itokafihi mupaguti akuꞌi huto hubo luto lu nokumunaꞌmu kai kekesa yigito topa mehobo. ");
INSERT INTO bef_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yasi nolitomo mehuba hinaga fato fato kegiꞌa lito nobigo nogoꞌago kehelilata nohataya to hiyaꞌaloti huto huloto hapi nofifi to hiya kegiꞌa nobifi yaꞌa mekeheliꞌahane. Asaga bonaꞌi Sikalafulugu mino kosaba nehana enali yaꞌmanana legita hite nehabe. ");
INSERT INTO bef_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ya ligo Nikotimasiu kaꞌalo nonaꞌa loka hoꞌehina: Hiyaꞌa huto yaꞌmanana huto hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ya luto loka hago Yesu lu emiꞌehina: Kai Isilaeli bonaꞌmagi babafiꞌanimo nohataya mana kaga keheli hokolo mehane. ");
INSERT INTO bef_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nani maꞌnaka luto lu nokumube. Lali keheliꞌohutanamofihi kagaꞌa noluto to lubutu bu goꞌohutanamofihi lu yege nohotaya to lenali folaganugu mone keneꞌmaka lali kaga keheli limilataꞌa mehane. ");
INSERT INTO bef_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nani ma meluguꞌnamofihi kaga lu lepugo kaꞌni keheli menimibe. Ya hanogo to kokulumaguꞌnamofihi kagaꞌa lu lepilunauba hiyaꞌa hite kaꞌni keheli nimilana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bo moneuba kokulumalugu metiꞌehibe. Huꞌmau leꞌmo ho tiꞌehina bo, yaꞌma Kokulumaguti limiꞌehina Bouba moneko aisigo kokuluma hepaꞌi heꞌmito limiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Koyapaꞌi Moseu ka melugu osifaꞌi yafaloꞌi li saga huꞌehina, ana supo lite Kokulumaguti limiꞌehina Bouba yafalo li saga hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ya hilenogo aitoga komopaꞌani emite minalana bonaꞌmagi alihaꞌa minoba minoba hepaꞌi lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Huꞌmau ma melugu bonaꞌi asaga kumu lagaꞌa besinaꞌmu luto sipi ginaga nofigo gi moneko panaꞌasi ho lifigo limiꞌehina. Asaga bonaꞌmagi aitoga keheli uleꞌale hite komopaꞌani molo emite mefililana minoba minoba hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","To Huꞌmau ma melugu panaꞌa ho lifigo limiꞌehina ai mana melugu bonaꞌi loko hilibe lutogope eneleꞌmo enubuto bilibe luto ho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bo moneuba Huꞌmamofihi panaꞌa agoya hu emilina ai ka foya melilinaꞌmu. To bo moneuba aiꞌi agoya hu meemilina ai ka foya aliꞌehilibe. Henaꞌmugope ai Huꞌmamofihi moneko panaꞌamofihi agoya hu meemiꞌehinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","To ka foya lisemofihi hapaꞌa ma huto niꞌibe. Ma melugu fana mehena ahuto huꞌehina to bonaꞌmagi metepunamu laga epesibe. Enali metepunamuꞌi laga epesinaya henaꞌmugope enali foipa faipana lite nehana hapaꞌaniuba bati mehuꞌehigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","To bo moneuba foipa faipana lito minoto fana mehenamofihi ipakafa halina fana tose kapogu mebilinaꞌmu yabe. Henaꞌmugope foipa faipa suhaꞌa asaga bona enubugu hu yege mefilubeꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ya huꞌehina ai maꞌnaka suhi hulata nohina bouba fana tanalo huto hulata nohibe. Ya higo asaga bonaꞌmagi bu go bati hilete Huꞌmamofihi megeꞌi moloto ai amuyalo liliꞌnaꞌa liꞌehibe lite lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Alihi Yesu to panaꞌalobomagi Yutia kegiꞌa henetilete analo kana loemo minete ana moneka nehite boanaꞌi nagamiꞌi folo epoloꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","To Aenoni hepato Selimi lebato nagamiꞌi babu lito ninalo Yoniu ana huto bonaꞌi nagamiꞌi folo epoloꞌehina. To boanaꞌi aitoga ete hago nagamiꞌi folo epoloꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yonihi gihiti bo Helotiu nagalugu leꞌmo memoloꞌehigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","To Yonihi panaꞌaloboꞌa lugaꞌamagi Yuta bo moneꞌmofihi kenasabo bite Yuta bonaꞌmofihi mono kaꞌanigu gufaꞌani okala hilata nehana hapaꞌaniꞌmu yaꞌma kaga moneya kenasabo biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ya hilete enali Yonitoga bite aiꞌa panaꞌaloboꞌamagi lu emiꞌahana: Tisao, ai kumu lulata nohata bomo Yotani nagami mula beletoga kai hiti mineꞌahaꞌina bomoba kai keheli etoꞌahapihe? Ya bomouba ai nagamiꞌi nofolo epalago asaga boanaꞌi aitogago nebabe. ");
INSERT INTO bef_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ya lite lago kaꞌanilo Yoniu nonaꞌa luꞌehina: Kokulumaluguti Huꞌmau anaꞌina mone bomofihi emilina ya aiꞌa lilinaꞌa huto menohibe. ");
INSERT INTO bef_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Koyapaꞌi kaga mone ma luto lu lepiꞌohunamo lenalitini akeheliꞌahabe. Nani Mesiaꞌita menohunaya Huꞌmau neleꞌmo kohe to etoto noho lifigo oꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","To bo moneuba aꞌi mone lilagomo ana aꞌi aiꞌa lihaꞌa minolata nohibe. To lihaꞌa lina bomofihi laluꞌafu ho tito bagaguti lina kaga keheliloto gelo sipi bito lihaꞌa maꞌasi liꞌehina bomofihi bagaguti kaga kehelilata nohibe. Yaꞌma suhi luto yatai nani komopaꞌnigu sipi negelo nobube. ");
INSERT INTO bef_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ai giꞌa tito sipi nominenogo nani nigiꞌni limito nesiꞌasi minalibe. ");
INSERT INTO bef_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ai ifogati oꞌehina bo asagaꞌnalo ai kabaꞌa nohibe. To ma meto huto huꞌehina bo ai mana melugu bomo nohinogo melugu ninanamofihi kagago lulata nohibe. To ai kokulumatogati oꞌehina bouba asagaꞌna be ligito tito nohibe. ");
INSERT INTO bef_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ai asagaꞌna abu goꞌehinamofi hiti to asaga kaga akeheliꞌehinamofi hiti lu yege holata nohibe. Ya hulata nohinaya bo moneuba ana kagaꞌa keheli bati huto megeꞌi memololata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","To bo moneuba kagaꞌa li pili kolotomo Huꞌmau maꞌnakago lulata bo nohibe lulata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Huꞌmau ho lifigo oꞌehina bouba Huꞌmamofihi kagaꞌago lu yege holata nohinaya henaꞌmugope Huꞌmamofihi Sikalafuꞌauba aitoga bai toꞌehigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afoꞌafu Panaꞌa lagaꞌa gofa besigo kibiꞌehina panaꞌni yabe luto aitogago mehaꞌa emi su holoto asagaꞌna ai yahaꞌa loko moloꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bo moneuba Huꞌmamofihi Panaꞌa komopaꞌa emito giꞌa liyafa hilina bati huto minoba minoba hilinaꞌmu yabe. To bo moneuba Huꞌmamofihi Panaꞌa kagaꞌa keheli meemilina to megeꞌi memalalina yaꞌma Huꞌmau hima muhi fi etenogo minoba minoba hepaꞌi melilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yaꞌmana kanaꞌalo Felosi bomagi Yesu Yonihi be ligito babu boanaꞌi nagamiꞌi folo epoloto aposolo nagaꞌa eneleꞌmo lolo nohibe lana kaga keheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ya huꞌehinaya Yesu boanaꞌi nagamiꞌi mefolo epoloꞌehina ai aposolo panaꞌamagi nagamiꞌi fele epeleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu Felosi bomagi ai kumu liꞌahana kaga akeheliloto Yutia meluguti heꞌmito Galili kegiꞌa bilubeꞌmu nohuto, ");
INSERT INTO bef_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samalia kegiꞌa folaganugu i gofa hoto buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ya huloto Samalia kegiꞌa Saika hepato koyapaꞌi Yakopu panaꞌa Yosefehi emiꞌehina meꞌi lebato nehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Analo koyapaꞌi Yakopu hepeligiꞌehina nagami gelumuꞌi ninalo Yesu kapo fotoꞌi moloto ago koseleꞌi hago analo mino basu biꞌehina ya fuligaha kanaꞌalo yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ai analo nohigo Samalia aꞌi moneuba nagamiꞌi hefilubeꞌmu oꞌehina. Ya higo ana aꞌi lu emiꞌehina: Nagamiꞌi mone hefi nimitogo nalube. ");
INSERT INTO bef_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","To enali aposolo panaꞌamagi hepatogati noseꞌna mina fite lite aluneꞌmu abiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ana aꞌuba Yesuhi lu emiꞌehina: Akae, kai Yuta bomo nohata nani Samalia aꞌmo nohube. Enali Yuta bonaꞌmagi Samalia bonaꞌi hiti koguna ite meneminanamo ninaya henabe luto nagamiꞌi hefi nimibo nolane? ");
INSERT INTO bef_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ya ligo Yesu kaꞌalo nonaꞌa lu emiꞌehina: Huꞌmau hetofana epilata nohina hiti to nagamiꞌi hefi nimibo luto koloka nohana bo hiti kai keheliꞌahatita, aiꞌi loka hatago mino kosaba nagamiꞌi kimititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ya ligo ana aꞌuba luꞌehina: Sipi bo, kai somoka ito meoꞌahata ma keligu nagamiꞌi afehi emagu nina kai mino kosaba nagamiꞌi hiyaꞌagati lilata niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Koyapaꞌi Yakopu tatatifu ma hepeligise nagami keli limiꞌehibe. To ai yagapanaꞌa hiti bulumaka sipisipi yagaꞌa hiti mana nagamiluguti hefi epigo neꞌahanamo ninaya kai amuyakauba Yakopuhi amuyaꞌa be ligiꞌehibe nolapihe? ");
INSERT INTO bef_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ya ligo Yesu lu emiꞌehina: Ma nagamiꞌi nalana bonaꞌi akuꞌi nagami kumu epesilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","To nani epilubeꞌmu nohuna nagamiꞌi bo moneuba nalina aku akuꞌi nagami kumu mebesilinaꞌmu yabe. Nani emiluna nagamiꞌuba ailuguti ipi opoho nagamiꞌuba nohinaꞌa huto se menose logoba logoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yesu Ya luto ligo ana aꞌuba luꞌehina: Sipi bo, kai yaꞌmana nagamiꞌi nimiꞌehitogo nagami kumu menebesinogo alihi yupahaꞌamagati oto kosele liliꞌna tito nagamiꞌi akuꞌi mehefilube. ");
INSERT INTO bef_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ya ligo Yesu lu emiꞌehina: Kai buto bahaka kehe ito malo aliyo. ");
INSERT INTO bef_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ya ligo Yesuhi ana aꞌuba lu emiꞌehina: Nani bahaꞌni menohibe. Ya luto ligo Yesu lu emiꞌehina: Bahaꞌni menohibe luto nolata yaꞌma maꞌnaka nolane. ");
INSERT INTO bef_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","To bo 5 yamagi liꞌahatamoya yatai nehaꞌina bo ai bahaka menohibe. Kai maꞌnaka lu nimiꞌahane. ");
INSERT INTO bef_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ya noligo ana aꞌuba topa hoto luꞌehina: Akae. Sipi bo, yatai aꞌnokeheli ketobe, kai kaga lu huto hulata bo nohane. ");
INSERT INTO bef_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Koyapaꞌa Samalia tataꞌnigi ma kosagu tite Huꞌmamofihi enegelo bi emite giꞌa li saga hiꞌahana ninaya lenali Yuta bonaꞌmagita ma lite lilata nehabe. Huꞌmamofihi gelo bi emilata hepaꞌi Yelusale niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ya ligo Yesu lu emiꞌehina: Ma aꞌi yale, nani lusiga luto lu nokumube. Alihi mone kanaꞌalo ma kosalokofi to Yelusale hepatokofi bonaꞌmagi Huꞌmamofihi enegelo bi meemilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","To lenali Samalia bonaꞌmagita ya bomofihi gelo bino emutagi lite keheliya meise minelata nehabe. Lali Yuta bonaꞌmagita legelo bi emilata nohuta boya lali keheli sepa i etoꞌohune. To Huꞌmau leleꞌmo lubuto biseꞌna lali Yuta bonaꞌmagitagu li huto huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ya huꞌehina kanaꞌa alubeꞌmu huꞌehina kanaꞌa ma ahuto huꞌehibe. To bonaꞌi Huꞌmamofihi enegelo bi emilata nehanamagi enali enemehaꞌa hiti bati suhi lusiga suhi lite gelo bi emilabe. Ya nehinogo Afoꞌnifu ana suhi lite gelo bi emilana bonaꞌi lagaꞌa besilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Huꞌmau ai Sikalafuꞌi nohibe. Enali Sikalafuꞌuba eneheꞌmenogo gelo bi emiluneꞌmu nehite maꞌnaka suhi hilabe. ");
INSERT INTO bef_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ya ligo ana aꞌuba luꞌehina: Huꞌmau ho lifiꞌehina bo ai Kilisitou yabe lite giꞌa helata nehana bo alibe liꞌahanamoya nani akeheliꞌohube. Ai oloto asagaꞌnamofihi kagaꞌa lu limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ya ligo Yesu lu emiꞌehina: Kai hiti kaga luto yatai nohuꞌina, nanimo nohube. ");
INSERT INTO bef_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ya noligo anaꞌasilo Yesuhi koko panaꞌamagi nehetilete ai aꞌi mone hiti kaga beto nehaꞌigo bu gete topa heꞌahana. Enali aꞌmo henana lilane melite to Yesu henabe luto lu noemine loka mehese faꞌmene mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ya hago ana aꞌuba nagami somoꞌa analo noheꞌmito tauniga buto bonaꞌi ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Nani koyapaꞌi lolo huꞌohunana lu hokolo huto lu nimi su nohana bo lenali bite bu galo. Ai Huꞌma ho lifiꞌehina bo Mesia nohifi fato bo nohibe? ");
INSERT INTO bef_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ya luto lu epigo enali hepaꞌanigati heꞌmite bite Yesuhi bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ya nehago koko panaꞌamagi Yesuhi noseꞌnaka nobo lite goꞌna biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ya nelago ai lu epiꞌehina: Lenali mekeheliꞌahana noseꞌna lugaꞌa nani liꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ya ligo koko panaꞌamagi ai loka hago ai loka hago hete ma liꞌahana: Noseꞌna mone bouba ito oto emiꞌehifi lite lu keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ya nehago Yesu lu epiꞌehina: Noho lifiꞌehina bouba liliꞌna malalina agoya hu emito liliꞌnaꞌa li baga iluna yaꞌma noseꞌnaꞌni legi huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lenali yaꞌma lite nehabe. Noseꞌna legeyaꞌa ligisemofihi kanaꞌa ikahi loegi loegi niꞌibe. Nani lu nolepunagi foyatini belelete bu go bati hilo. Noseꞌna uyaꞌi alo su hoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bo mone ai noseꞌna legeyaꞌa ligi nupa nohinalo minaꞌa lito minoba minoba husemofihi noseꞌnaꞌa li nupa nohibe. Noseꞌna he kololata nohina bo hiti ligi nupa hulata nohina bo hiti etali moneko suhi lite etegelo bilaꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bo moneuba noseꞌna nohekelenogo moneuba ligi nupa husemofihi kagaꞌa lu nolepunaya maꞌnaka niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Koyapaꞌi fato bonaꞌmagi liliꞌna lite he keleꞌahana foyagu lenali bite noseꞌnaꞌa ligi nupa hilabe luto nani lenoho lifiꞌohube. Lenali ana foyagu liliꞌna meliꞌahana faꞌmene minaꞌa enalitogati lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","To asagaꞌna koyapaꞌi huꞌohunamofihi ma bouba lu huto hu su ho netoꞌehibe luto ana aꞌuba lu epinaꞌmu lite Samalia nohi hepaga nehana bonaꞌmagi babu lite Yesuhi keheli uleꞌale hi eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Enali Samalia bonaꞌmagi Yesutoga ete lali hiti minalune lite koyo koyo bite kehe iꞌahana. Ya hanaꞌmu luto Yesu enali hiti yege loemo minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ai lu epina kagamofihi babu bonaꞌmagi keheli emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ya hilete ana aꞌmofihi ma lite lu emiꞌahana: Yatai lali keheli amuya molone. Kai lu limita kaga niꞌigopa laliti bagaꞌaguti akeheli etone. To ai lusiga maꞌnaka luto asaga melugu boanaꞌi oto eneleꞌmo enubuto bilibe liꞌahana bomo nohibe lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu yege loemo ana hepato minoto alihi heꞌmito Galili metoga buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu aiꞌa kaga mone ma lulata luꞌehina yaꞌma akuꞌi lu epiꞌehina: Kaga lu hokolo lulata bouba meꞌalo nehetilina aiꞌa bonaꞌamagi koyone hu meemiꞌahanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ya luloto ai Galili melugu nehetigo anaga bonaꞌmagi be tigiꞌahana. Henaꞌmugope koyapaꞌi Pasa noseꞌna Yelusale hepato li nupa hite nana kanalo topa hoseꞌna fato fatoꞌi li huto huꞌehina enaliꞌani bu geꞌahanaꞌmu lite yabe. ");
INSERT INTO bef_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Koyapaꞌi Kena hepato Galili melugu Yesu nagami lafatu bai nagamiꞌi li lolo huꞌehinalo buꞌehina. Kapaneami hepato gamani bomofihi panaꞌa besigo minoꞌehina bo ana hepato minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesu Yutia meluguti heꞌmito Galili kegiꞌa noabe lanaꞌa ana bouba keheliloto panaꞌa Kapaneami hepato filiseꞌna maꞌasi nohina kehe inogoꞌni oto leꞌmo ye kalibe, luto Yesu nohinalo buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ya higo Yesu lu emiꞌehina: Lenali kagaꞌni keheli menimise nehite babeyafana fato fatoꞌi li huto hinogoꞌni bu gelete nani kumu keheli uleꞌale hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gamani bouba luꞌehina: Sipi Bo, panaꞌni fili laligi meleꞌisi nemegeꞌi obo. ");
INSERT INTO bef_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ya noligo Yesu lu emiꞌehina: Kai panaka ye kalinaꞌmu yagi abubo. Ya luto ligo ana bouba Yesu lu emiꞌehina kaꞌa keheli uleꞌale huto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kapogu nobigo koko panaꞌamagi kaga lite ete ma lite lu emiꞌahana: Panaka aye koto nohibe. ");
INSERT INTO bef_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ya nelago ai hena kanaꞌalo panaꞌni ye koꞌehibe? Ya ligo enali lu emiꞌahana: Yago utehi gufalo mukoho akoho nolina su ho etoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Panaka ye kalibe luto yaꞌmana kanaꞌalo Yesu lu emiꞌehina kaꞌauba ekesa hokolo huꞌehina. Yaꞌmu lite ai nagaꞌa hiti Yesu kumu keheli uleꞌale hi eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Alihi Yesu Yutiꞌa metogati heꞌmito Galili kegiꞌa oloto yaꞌma loe yupahi sipi liliꞌna babeyafana li huto huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yaꞌmanana su holago alihi Yuta bonaꞌmagi mono fuli li nupa hite noseꞌna nalana yupahi Yesu Yelusale hepatoga tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mone nagami gelumu kumu Hibulu nogoguti Betesaita yabe lite giꞌa helata nehana mone sipisipi yagamagi sipi kasihaꞌanilo Yelusale minoꞌehina. Yaꞌmana gelumu nagami beleto mino enabasu bilata nohi nayahi mone kegiꞌa su hago minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","To yaꞌmana gelumu nagamiꞌuba mopo hilinaꞌmu geba hite babu bonaꞌi enubu pisi luꞌehinafi, enigi enayahi foipa loꞌehinafi, to felisaꞌani amuya memoloꞌehinafi babu lite enabasu bilata nonugu li gehesa hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","To kanaꞌamu kanaꞌamu Huꞌmamofihi ageloꞌauba ana nagami gelumuꞌi li mopo nohigo besiꞌehina bo moneuba kohe toto ana gelumu nagamilugu nokago besiseꞌna leꞌmo ye kolata huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bo mone koyapaꞌi besigo 38 kufu be ligiꞌehina anagu minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ai analo melugu koloto nohigo Yesu bu golotoꞌa besigo yatama kanaꞌa minoꞌehibe luto akehelito ma luto loka hoꞌehina: Kai ye kalube luto nokehelipihe. ");
INSERT INTO bef_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ya luto loka hago ana bouba Yesuhi lu emiꞌehina: Sipi Bo, gelumu nagamiꞌi mopo nohigomo bo moneuba neheꞌmoto anagu neleꞌmo menomalabe. Naniꞌni ana nagamilugu limilubeꞌmu nohugomo fato bonaꞌmagi nebe ligite yataꞌa limite ye kelata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ya luto ligo Yesu lu emiꞌehina: Ho tito nebelusaka lito kapo molobo. ");
INSERT INTO bef_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ya noligo anaꞌasi meleꞌisi ana bo besiseꞌna su hago nebelusaꞌa lito kapo moloꞌehina yabe. To yaꞌmana kanaꞌa fuli yupahi yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yaꞌmu lite Yuta bomagi besiseꞌna ye kana bomofihi li emiꞌahana: Yatai fuli yupapo nina. Kai keya kaga oꞌe luto moloꞌohutamofihi pelesa ito nebelusaka kofito noane. ");
INSERT INTO bef_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ya lago enali kaꞌanilo nonaꞌa lu epiꞌehina: Neleꞌmo ye kana bouba nebelusaka lito kapo molobo luto lu nimigo ai bagaꞌa liyafa huto noobe. ");
INSERT INTO bef_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ya ligo enali loka heꞌahana: Nebelusaka lito kapo molobo luꞌehina bo ai kiyiꞌafube. ");
INSERT INTO bef_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","To ai ye koꞌehina bouba leꞌmo ye kana bomofihi giꞌa keheli bati mehuꞌehina. Henaꞌmugope bonaꞌi babu lite li gehesa hanaꞌmu luto Yesu abufa huꞌehigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Alihaꞌa Yesu ana bo sipi mono nonugu nohigo bu goloto lu emiꞌehina: Kai bu gobo, yatai ye koto nohane. Mone sipi ketaꞌa hiti alihi kaitoga akuꞌi huto hu laligi foipana nohata heꞌmibo. ");
INSERT INTO bef_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ya ligo yaꞌmana bouba buto Yuta bo lu epiꞌehina: Yaꞌma bo Yesu neleꞌmo ye koꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Fuli kanagu besiꞌehina bomofihi leꞌmo bati huꞌehinaꞌmu lite Yuta bomagi ana yupahi fite Yesuhi kalanaꞌi molo etaluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ya nehago Yesu lu epiꞌehina: Nani afoꞌnifu asaga kanagu liliꞌna lilata nohinago nani ana huto liliꞌna lilube. ");
INSERT INTO bef_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ya luto lina kamuꞌi Yuta bomagi enipagu logo sipi bigo enugufaꞌani uleꞌale hite Yesuhi ho fililuneꞌmu anaꞌasilo hiꞌahana. Henaꞌmugope ai fuli kanaꞌanilo oꞌe liꞌahanamofihi pelesa noito Huꞌma naniꞌni afoꞌnifu nohibe luto Huꞌma hiti aiꞌa leꞌmo moneko hinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ya hago Yesu lu epiꞌehina: Nani maꞌnaka lu nolepube. Panaꞌuba nasana ai ekesaguti mone li huto hulata menohibe. Yataꞌa afoꞌafu lolo higo bu goloto lolo hulata nohibe. To afoꞌafu lolo hulata nohina suhi Panaꞌauba ana suhi lolo hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Henaꞌmugope bita hina Panaꞌa nohigo asagaꞌna lolo nohina Panaꞌa lepilata nohibe. To yaꞌmana be ligito sipi amuyana afoꞌafu lepinogo lenali bu gelete lenekesa yigi babu lite akae lilanaꞌmu topa hilabe. ");
INSERT INTO bef_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afoꞌafu filiꞌahana bonaꞌi akuꞌi eneleꞌmo ho ti kosaba hulata nohinaꞌa yaꞌma ana huto Panaꞌauba lagaꞌa besilina bonaꞌi filiꞌahanaguti eneleꞌmo ho tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","To afoꞌafu bonaꞌi foipanalo ka foya melilina ai Panaꞌamofitoga ana liliꞌna moloꞌehinago aisigo foipa bonaꞌi ka foya li epalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","To asaga bonaꞌmagi afoꞌafitoga enegelo bi emite giꞌa li saga nehanaꞌa hite Panaꞌamofihi ana hilabe. To mone keneꞌuba Panaꞌa agoya hu meemilina, ho lifiꞌehina afoꞌafihi agoya hu meemilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nani maꞌnaka lu nolepube, keneꞌi moneuba nani kaꞌni kehelito li pili kotoꞌa to noho lifiꞌehina bomofitoga komopaꞌa malalina yanauba mino bati huto minoba minoba huseꞌna yaꞌma liꞌehibe. To ai ka foya melilina filiseꞌnamofihi be ligito akuꞌi mino kosaba huseꞌi ali su hoto nominabe. ");
INSERT INTO bef_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nani maꞌnaka lu nolepube, kanaꞌa huto hilubeꞌmu huꞌehina kanaꞌa yatai ahuto huꞌehibe. To enali filise bonaꞌmagi Huꞌmamofihi Panaꞌamofihi nogoꞌa kehelinogo luga bonaꞌi kehelite li pili kalanamagi mino kosaba hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mino kosaba huseꞌnamofihi Afoꞌafinugu nina Panaꞌmofitoga fitu fo emigo aiꞌagu mino kosaba huseꞌna niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","To ai Kokulumaguti limiꞌehina Bomo nohinago asaga ka foya li epoloseꞌnalo Panaꞌamofihi gi emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Asaga bonaꞌi kene keligu nehanamagi Huꞌmamofihi Panaꞌamofihi nogolo lilana kanaꞌa noanagi lenali topa hete lenekesa yigi babu melilo. ");
INSERT INTO bef_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","To enali filise bonaꞌi ya hite nogoꞌa kehelilete kene keliguti ho tilabe. Ya hilete enali bati foya liꞌahanaꞌamagi ho tite mino kosaba nehinogo to foipa foya liꞌahanaꞌamagi ho tite minago Huꞌmau enifisa iloto ka foya li epalalibe. ");
INSERT INTO bef_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Anaꞌina mone naniꞌni nekesaguti li huto mehilunaꞌmu yabe. Afoꞌnifu kaga lu nimiꞌehinaꞌa huto bonaꞌi kagaꞌani loko hilunaꞌmu yabe. Ka foya noli epolonauba bati hulata nohinaya henaꞌmugope naniꞌni nemehaꞌnilo meluna ai noho lifigo limiꞌohunamofihi megeꞌi moloto nolugo yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","To naniꞌnisigo kaga mone naniꞌnimuꞌi lu noepugomo lamaꞌnaka lolo menohinaya to fato bo moneuba nani kumu ya huse bo nohibe luto kaga noligomo nani kumu ya maꞌnaka nolibe luto kehelilata nohube. ");
INSERT INTO bef_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Koyapaꞌi lenali koko panatini enoho lifigo Yonitoga lite bago ai maꞌnaka alu epiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bo moneuba nani hapaꞌni lu lepilinamofi kumu nekesa yigi mupa ito meluna lenaliꞌi Huꞌmau akuꞌi lenubuto bilinamofi kumu luto yaꞌma kaga lu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Libi logouba asaga bonaꞌi eneleꞌmo besa nolanaꞌa huto Yoniu nohigo ana fana mehaꞌagu lenali hupamone kanaꞌasilo komopatinigu laga higo lenegelo bite mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ya huꞌehinaya Yonihi be ligiꞌehinanauba nani hapaꞌni yatai lu huto nohibe. Asaga liliꞌna nani kumu lito li su halane luto Afoꞌnifu nimiꞌehina nani nolube. Yaꞌmana liliꞌna nolunauba aiꞌa boanaꞌi enelepinogo bu gelete Huꞌmau ho lifigo limiꞌehinagi lite lilabe. ");
INSERT INTO bef_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","To Afoꞌnifu aiꞌa noho lifiꞌehinauba nani hapaꞌni lu huto ahuꞌehibe. Lenali okabaꞌa mone bu gela to bagaguti kaga mone nesiꞌa kehelila mehiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yaꞌmu luto ai kaꞌa lenalilugu meniꞌibe. Henaꞌmugope ai Panaꞌa ho lifigo oꞌehinamofihi keheli uleꞌale mehilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lenali mono bukugu fayahi keyeꞌahanamofihi mino kosaba hilana limilibe lite ana fayahi loko luku hite asaga kaga goꞌehina bu gelata nehabe. To yaꞌmana fayahuba nani hapaꞌni kumu lu huto huto lu lepilata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nani yaꞌma mino kosaba huseꞌna lepilube luto nolugo lenali lilune lite akuꞌi nanitoga mealuneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Bonaꞌmagi nani nigiꞌni li saga hilanamofi kumu nani sa sa menohube. ");
INSERT INTO bef_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ya nohuna lenali hapatini akeheliꞌohube. Huꞌmau kekeꞌi lu lepoloꞌehinana lenali komopatinigu meninamoya nani akeheli lepoloꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nani Afoꞌnifihi giꞌalo oꞌohunamo lenali nani kaꞌni keheli menenimibe. To bo moneuba aiꞌa giꞌalo oꞌehigomo lenali be tigite kaꞌa lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mone lenalalutinigitogati sipi lenigi lilata nehana lenigi Huꞌmamofihi aitogatiko olata nohina lenali melilata nehabe. Ya hiꞌahana hiyaꞌa keheli uleꞌale hite komopatini emilabe? ");
INSERT INTO bef_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nani kumu afoꞌafito lenifisa inogo ka foya li letalibe lite lenali mekehelilo. Moseu ai leheꞌmalibe lite kehelilata nehana bouba ai lenifisa iloto ka foya li lepalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Lenali Mosehi kaꞌa keheli li pili keꞌahatita ana hite nani kaꞌni keheli pili katitaꞌmu yabe. Henaꞌmugope ai nani kumu luto fayahi koyapaꞌi goꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","To Moseu fayahi goꞌehina kagaꞌa li pili kete megeꞌi memalanago hiyaꞌa hite nani kaꞌni li komopatinigu malalana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu ya luto kaga alu epi su holoto alihi Galili nagami hefuhi Taibiliasi yabe lite gi helata nehanaga i gofa hoto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","To ai topa hosemofihi fato fatoꞌi enebesiꞌehina bonato li huto higo babu boanaꞌi bu geꞌahanamagi megeꞌi lifite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu lapa luga tito kosa bohupoto panaꞌaloboꞌa hiti meto mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yuta bonaꞌmagi fuli kanaꞌani Pasa noseꞌna li nupa hite nelata nehana kanaꞌani o leba toꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesutoga babu boanaꞌi megeꞌi lifite neago bu enogolotoꞌa Filipihi ma luto lu emiꞌehina: Hiyaꞌagati noseꞌna mina fito ma boanaꞌi epinogo nalabe? ");
INSERT INTO bef_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu aiꞌi hilina suhi akeheliꞌehinamoya Filipiu henabe lilifi luto fi taga hu etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ya ligo Filipiu luꞌehina: Noseꞌna 200 kinaloti mina fito ma bonaꞌi epiluta lugaꞌa butomo heꞌmilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ya ligo aposolo panaꞌa mone Simoni Pitahi gonaꞌa Atulu ma luto luꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Beleti noseꞌna nayahi mone kegiꞌa su hago fayaꞌi loe hiti panaꞌi moneuba liꞌehinaya ma babu boanaꞌi enubuto mebilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ya luto lulago Yesu lu epiꞌehina: Lenali silaga boanaꞌi lu epinogo melugu mineno. Analo kifiꞌna nebelusa legi ninalo bosigo 5,000 mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Enali melugu mine su helago Yesu beleti noseꞌna lito nunumu huto Huꞌmamofitoga fokehi holoto ana bonaꞌi guna i epi epi huꞌehina. To loe fayaꞌmo lito ana suhi huloto epigo nete enumu huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Asaga bonaꞌi ana noseꞌna nete enumu hulago Yesu panaꞌaloboꞌa lu epiꞌehina: Noseꞌna letuhaꞌa nelete neheꞌmina yakalesa mehilutagi lenali li nupa hilo. ");
INSERT INTO bef_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ya ligo nayahi mone kegiꞌa su hago tumo beleti neꞌahanaguti letuhaꞌa li nupa hite 12 sulu suluꞌya li bai teꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ana boanaꞌmagi Yesu babeyafa suhi sipiꞌa li huto hina bu gelete liꞌahana: Maꞌnaka luto ma boya kaga lu huto huto hulata bo ma melugu limilibe liꞌahana aisimo nohibe. ");
INSERT INTO bef_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ya nelago enali ete eneleꞌmete bite nigihiti bo kabaꞌani leleꞌmo lolo hilanaꞌmu yabe luto akeheli epoloꞌehina. Ya huloto anagati i minigito kosa moneto aiꞌago tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Utehe kana nohigo panaꞌaloboꞌa hefuhu nagami beletoga limiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Enali botigu tilete hefuhu nagamiꞌi i gofa hete Kapaneami hepatoga enubu bu go lite nebago sinihi giꞌehina to Yesu belesaꞌi enalitoga menehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","To sipi habafahi liloto hege nagamiꞌi lusina huto biliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Enali botigu bu fotoꞌi nemalago Yesu nagami gupisaꞌalo kapo moloto boti lebato noago bu gelete enelesa ligo koli gofa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ya nehago Yesu lu epiꞌehina: Nanimo noonagi lenali koli mehilo. ");
INSERT INTO bef_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ya luto ligo enali Yesuhi botigu leꞌmo malaluneꞌmu nehago anaꞌasilo botiuba nebana hepaꞌmofihi nagami keheto buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yago etekaꞌa babu boanaꞌi nagami hefuhi mula kegiꞌa minanamagi boti moneꞌisi niꞌigo bu geꞌahana. Yesu panaꞌalobomagi hiti mone botigu mebuꞌehina enali heꞌmi etete enaliꞌanigo bago bu geꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","To Yesu beleti noseꞌna hiti fayaꞌi hiti lito fokehi holotoꞌa babu boanaꞌi epigo neꞌahana hepa lebato Taibiliasi boti lugaꞌa nebago bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ana botigu Yesu panaꞌalobomagi hiti menehago bu gelete Yesuhi sa sa hilune lite lugaꞌa botigu ana boanaꞌi tite Kapaneami biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nagami hefuhi muya beletoga ana bonaꞌmagi Yesuhi etafa hilete ma lite loka heꞌahana: Tisao, maga hiya yupahi oꞌahatabe? ");
INSERT INTO bef_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ya lite loka hago Yesu lu epiꞌehina: Nani maꞌnaka lu nolepube. Lenali nani kumu sa sa nehanaya nani liliꞌna sipiꞌa suhi li huto huꞌohuna muyaꞌalogope, beleti no lenumu hiꞌahanamoꞌmu lite naniꞌi sa sa nehabe. ");
INSERT INTO bef_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Minoba minoba mehilina noseꞌnalo lenali foya melite minomo tito minoba minoba hilina noseꞌnaloko foya lilo. Ai yaꞌma noseꞌna mino bati minoba minoba huseꞌnamo yabe. Huꞌmau Panaꞌamofihi yaꞌmana noseꞌna mino kosaba husemofihi lepilibe luto giꞌa aꞌemiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ya luto enali Yesuhi loka heꞌahana: Lali hena suhi huloto Huꞌmamofihi liliꞌnaꞌa li etalune? ");
INSERT INTO bef_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ya lago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Huꞌmamofihi liliꞌnaꞌa ma huto niꞌibe. Aiꞌa ho lifigo oꞌehina bomofitoga komopatini emite minalo. ");
INSERT INTO bef_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ya ligo enali loka heꞌahana: Amuya babeyafana hena huseꞌi kai li lubulo hitogo bu goloto kaitoga komopati kimilune? Kai hena foya li huto hilata niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mono kagu ma luto ninaꞌa hite tatatigi mana noseꞌna ka melugu aꞌneꞌahana yabe. Ai kokulumalugu beleti noseꞌna nalabe luto epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ya lite lago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Nani maꞌnaka lu nolepube. Moseu kokulumalugu beleti melepiꞌehina, nani Afoꞌnifu kokulumalugu lusi beleti lepilata huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yaꞌmana beleti Huꞌmau epilata huꞌehinauba melugu boanaꞌi eneleꞌmo mino kosaba hilibe luto kokuluma hepaꞌi heꞌmito limiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ya luto ligo enali Yesuhi lu emiꞌahana: Sipi bo, yaꞌmana beleti asaga yupahi limibo. ");
INSERT INTO bef_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ya lite lago Yesu lu epiꞌehina: Eneleꞌmo mino kosaba huse beleti naniꞌni nohube. Bo moneuba nanitoga alinamofihi kauꞌna mehalibe. To komopaꞌa nanitoga nimilina bomofihi nagami kumu mebesilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya huꞌehinaya koyapaꞌi nani alu lepiꞌohube. Lenali naniꞌi abu negeꞌahanaya keheli pili menekabe. ");
INSERT INTO bef_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Asaga bonaꞌi nani Afoꞌnifu nimilinamagi nanitoga alanaꞌmu yabe. To nanitoga alana bonaꞌi enubunepa ito eneleꞌmo meheꞌmilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nani noho lifiꞌehinamofihi megeꞌi moloto liliꞌna lilube luto kokuluma heꞌmito limiꞌohube. To naniꞌni nemehaꞌnilo liliꞌna mone melilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ai noho lifigo limiꞌohuna bomofihi mehaꞌa ma huto niꞌibe. Ai boanaꞌi nimiꞌehinaguti mone keneꞌi li sibina mehu etalibe kokuluma hiti meꞌi hiti su halina yupahi akuꞌi eneleꞌmo saga huto kosaba hilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Afoꞌnifu ma luto keheliꞌehibe. Asaga bonaꞌi panaꞌa bu gelete komopaꞌani emilanamagi mino kosaba hepaꞌi lilabe. Ya hinogo nani kokuluma hiti meꞌi hiti su halina yupahi eneleꞌmo ho ti kosaba hilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nani kokulumaluguti limiꞌohuna beleti nohube lina kamuꞌi Yuta bonaꞌmagi gulu gulu bilete ipakafa heꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ya hilete liꞌahana: Yaꞌma bo Yosefehe panaꞌa Yesuumo nohifihe? Ai afoꞌafinogo itoꞌafinogo akeheliꞌohutamo minaya yatai ai hena hibe luto kokulumaluguti limiꞌohuna bo nohube nolibe? ");
INSERT INTO bef_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ya lite nelago Yesu lu epiꞌehina: Lenalitini lenugufagu gulu gulu mebilo. ");
INSERT INTO bef_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bo moneuba aiꞌagati nanitoga mealina Afoꞌnifu noho lifiꞌehinauba nanitoga leꞌmo kefefe higo olenogo alihi kokulumaꞌi hiti meꞌi hiti su halina yupahi nani ana bomofihi leꞌmo ho ti kosaba hilube. ");
INSERT INTO bef_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kaga lu yege holata bomagi fayahi mone ma lite: Asaga bonaꞌi Huꞌmau enelepilibe. Yaꞌma koyapaꞌi geꞌahana niꞌibe. Afoꞌnifitogati kaga lite kehelilete li pili kelata nehanamagi nanitoga elata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bo moneuba Afoꞌnifihi bu megoꞌehibe. Ai Huꞌma hiti nohinati oꞌehina bouba aisigo Afoꞌafihi bu goꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nani maꞌnaka lu nolepube: Bo moneuba naniꞌi keheli nimilina ai minoba minoba hepaꞌi batiꞌa lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mino kosaba huto minoba minoba beleti noseꞌna naniꞌni nohube. ");
INSERT INTO bef_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ka melugu tatatinigi mana noseꞌna neꞌahana ya enali filiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ya hiꞌahanaya to kokulumaꞌi heꞌmito limiꞌehina beleti mone keneꞌuba nalina ai akuꞌi mefililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mino kosaba huse beleti kokulumaluguti heꞌmito limiꞌehinamoya naniꞌni nohube. Yaꞌmana beleti noseꞌna mone bouba nalina ai minoba minoba hilinaꞌmu yabe. Ana beleti noseꞌna nani emiluna naniꞌi nugufaꞌni yago melugu asaga bonaꞌi epi baga inogo enali ana hite minoba minoba hepaꞌi lilabe. ");
INSERT INTO bef_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ya luto lu epina kagaꞌmu Yuta bomagi bela ka lite kenasabo bibu bibu hite liꞌahana: Yaꞌma bouba hiyaꞌa huto gufaꞌa liminogo naluta kaga nolibe? ");
INSERT INTO bef_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ya lite lago Yesu lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Kokulumaguti limiꞌehina Bomofihi gufaꞌa hiti golahaꞌa hiti menalana mino kosaba huseꞌi lenalilugu meminalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","To bo moneuba nani nugufa hiti golahaꞌni hiti nalinauba minoba minoba hepaꞌi batiꞌa liꞌehinogo su hose kanaꞌalo alihi nani leꞌmo ho ti kosaba hilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Henaꞌmugope nani nugufaꞌniya noseꞌna manaꞌa niꞌibe, to golahaꞌniya ana huto nagamiꞌi manaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","To mone keneꞌuba nani nugufaꞌni hiti golahaꞌni hiti nalinauba naniloga mineno to nani aimogu minenogo huto monekolugu minaluꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mino kosaba huse Afoꞌnifu noho lifiꞌehinaꞌmu nani ai kehelito minoba minoba nohube. Yaꞌmana suhi huto naniꞌi nalina bouba nani keheli minomo tubuto minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaꞌma noluna beletiya kokulumaluguti limiꞌehibe. To koyapaꞌi tatatinigi nelete filiꞌahana beletiꞌmu menolube. Yaꞌma nani noluna beleti nalinauba mefililina minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kapaneami hepato bonaꞌi li gehesa huto mono kaga lu kehelilata nehana nonugu Yesu asaga kaga yaꞌma enelepiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuhi koko panaꞌamagi kehelilete ma lite liꞌahana: Ai enebe ligiꞌehina ka amuya kaga nolelepibe. Kiyiꞌafu ana kaga kehelilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuhi panaꞌaloboꞌamagi ya lite gulu gulu bite nelana kagalo komopaꞌanigu bu enogoloto lu epiꞌehina: Nani ma noluna kagauba latahatini leneleꞌmo negi nonago heꞌmiluneꞌmu nehafihe? ");
INSERT INTO bef_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kokulumaguti limiꞌehina Bouba koyapaꞌi minoꞌehina hepatoga akuꞌi tilina ya hena huto niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sikalafuꞌuba aiꞌa akuꞌi bonaꞌi eneleꞌmo kosaba hulata nohibe. Faꞌmene lugufauba nesiꞌasi leheꞌmolata nohibe. Yaꞌma nani noluna kagaya mino kosaba huseꞌna hiti Sikalafuꞌi hiti nina ninamofihi lu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ya nohunaya lugaꞌamagita nani kagaꞌni keheli pili mekabe. Yesuhi fatehaꞌa li enayanugu bilina bo hiti to kagaꞌa li pili mekalana bonaꞌi hiti koyapaꞌi komopaꞌanigu abugo fulu tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yaꞌmu luto kaga moneꞌa hiti molo emito ma luto lu epiꞌehina: Yaꞌma lilabe lutoꞌni nani ma luto lu lepiꞌohuna yabe. Bo moneꞌmofihi Afoꞌnifu amuya meemilina nanitoga mealinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesu ya luto lina kaꞌamu lite panaꞌaloboꞌa megeꞌi lefelili hana enali lugaꞌamagi heꞌmi etete tili tele hite bila ela hiꞌahana yabe. To aku akuꞌi i behe hite ai hiti minomofaꞌna mehiluneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ya hago 12 koko panaꞌamagihi Yesu enoloka hoꞌehina: Lenalibe, lenali ana hite heꞌmi netete bilafi? ");
INSERT INTO bef_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ya luto enoloka hago Simoni Pitau kaꞌalo nonaꞌa luꞌehina: Sipi Bo, lali kiyiꞌafitoga bilutaꞌmu nolane? Minoba minoba huseꞌna episemofihi kagaꞌa kaitogago niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","To kai Huꞌmamofihi lamana panaꞌa monekomo nohane luto komopati kaito kimito keheli uleꞌale ahu ketoꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ya luto lina kaꞌalo Yesu nonaꞌa lu epiꞌehina: Nani 12 koko pananaꞌi leneleꞌmoꞌohunamo niꞌifihe? Lenali folagahatiniguti mone keneꞌi foipa fele nohibe. ");
INSERT INTO bef_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simoni Isikelioti yabe lite gi helata nehana bomofihi panaꞌa ai aposolo bo mone nohinaꞌa giꞌa Yutasi ai Yesu kumu fatehaꞌamagi enelepilina yananaꞌmu Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ana kaga su holago Yesu Galili kegiꞌa kapo moloto buꞌehina. To Yuta bonaꞌi Yutia melugu nehanamagi kofohi legete ho fililune liꞌahanaꞌmu luto ana kegiꞌa mebuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","To Yuta bonaꞌmagi fuli kanaꞌani keya ka meleꞌahana bokisimofihi yege nohi gi eteꞌahana kanꞌa yabe lilata nehana kanaꞌa leba toꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ya higo Yesuhi gonamu tamuꞌamagi ma lite lu emiꞌahana: Kai ma hepaꞌi heꞌmito Yutia kegiꞌa bitogo panaꞌalobokamagi yatai nolita foya bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bo moneuba giꞌa keheli baga ilabe lutomo ai asagaꞌna suguna huto lolo hulata menohibe. To kai yaꞌmana supo nohutomo asaga boanaꞌmagi enubulo li huto huto lolo hitogo bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aiꞌa gonamu tamuꞌamagi keheli sepa meiꞌehite yaꞌma kaga li eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ya lite lago Yesu lu epiꞌehina: Nani kanaꞌni lamanaꞌa meoꞌehibe. Asaga kanaya lenalitini bilata kanatini bati hutomo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","To ma melugu boanaꞌmagi lenaliꞌi fatehi mehilana naniꞌi nipakafa hete fatehi hi netalanaꞌmu yabe. Henaꞌmugope enali foipa suhi nehanamofihi hapaꞌani lu huto nohu epolonaꞌmu lite yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yaꞌmana fuli kanaꞌa lifupa nehanalo lenalitini bilo. To nani yaꞌmana fuli kana lifupa nehanalo biluna kanaꞌni bati huseꞌnaꞌa meoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ai ya luto lu epiloto Galili melugu minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ya luto lulago alinaꞌa Yesuhi gonamu tamuꞌa fulu kana lifupa nehanalo abilago ai fatoꞌi mone yupahi enemegeꞌi buꞌehina. Ai hutoꞌi mebuꞌehina fala kito sugunaꞌi buꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Enali Yuta bonaꞌmagi aiꞌi sa sa hite enoloka heꞌahana: Yaꞌma bomoba hiyaga nohibe? ");
INSERT INTO bef_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ya lago enali li gehesa hite nehana boanaꞌmagi sumi sami kaga ai kumu liꞌahana: Ai hetofa bomo nohibe, lite lugaꞌa bonaꞌmagi nelago to lugaꞌa bonaꞌmagi ma lite liꞌahana: Ai bonaꞌi faga faga lu epilata nohina bo yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Enali Yuta bonaꞌmagi koli hite Yesu kumu kaga hutoꞌi meliꞌahana sugunako lilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fuli kana lifupa hite noseꞌna nete folaga talaga nohigo Yesu sipi mono nonugu tito boanaꞌi hapi fito mono kaga hutoꞌi lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ya nohigo enali Yuta bomagi enekesa yigi babu lilete ma lite liꞌahana: Ma bomofihi mone bouba melepiꞌehinamo ninaya hena suhi luto buku leka nosabe? ");
INSERT INTO bef_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ya lite lago Yesu lu epiꞌehina: Nani lu nolepuna kagaya naniꞌni kagaꞌni menina ai Huꞌmau noho lifigo limiꞌohuna bomofihi kagaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","To bo moneuba Huꞌmamofihi bagaꞌa liyafa huto megeꞌi malalubeꞌmu nani lu yege nohona kagamofihi hapaꞌa keheli bebe salinaꞌmu yabe. Huꞌmamofihi kagaꞌa nolufi to naniꞌni komopaꞌniguti tina kaga nolufi aiꞌa keheli sepa ilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bo moneuba komopaꞌaguti tina kaga lulata nohina aiꞌa giꞌa li saga hilubeꞌmu nohibe. To ai ho lifiꞌehina bomofihi giꞌa li saga hu etalubeꞌmu nohina boya faga faganaꞌa menina fotogo huto nohibe. ");
INSERT INTO bef_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseu keya ka melepiꞌehina niꞌifihe? Lenali yaꞌmana keya ka li pili kete megeꞌi memeleꞌahabe. Lenali hena hibe lite noho fililuneꞌmu nehabe? ");
INSERT INTO bef_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ya luto ligo asaga boanaꞌmagi Yesuhi kaꞌalo nonaꞌa liꞌahana: Kaitoga foipa fele niꞌibe. Kiyiꞌafu koho fililubeꞌmu nohibe? ");
INSERT INTO bef_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Enali ya lite loka hago Yesu lu epiꞌehina: Nani topa hoseꞌna sipi amuyaꞌa hiti hu lenubulo mologo be gelete topa hete lenekesa yigi babu liꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Panatini enugufa laga huse suhi koyapaꞌi Moseu lenelepiꞌehinamoya maꞌnaka luto yaꞌma suhi Mosetogati meoꞌehina yataꞌa tatatinigi hapi fiꞌahana yabe. Ya huꞌehina fuli kanaꞌagu panatinimagihi enugufaꞌani laga hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lenali Mosehi keya kaꞌa megeꞌi malalupi lite lenekesa kehelilete fuli kanagu panatini enugufa laga hilata nehabe. Ya hilata nehanamo nani fuli kanaꞌalo bo mone leꞌmo ye koꞌohunamomuꞌi lenali henabe lite kafa nehabe? ");
INSERT INTO bef_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lenubutu bu gelata nehananamofi loko hilata nehanana neheꞌmite maꞌnakamofinogo loko hilo. ");
INSERT INTO bef_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yelusale bonaꞌi lugaꞌamagi ma lite liꞌahana: Enali ho fililuneꞌmu nehana bomo yaꞌma nohifi? ");
INSERT INTO bef_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bu galo. Ai asaga bonaꞌi li gehesa hite nehanagu kaga nolinalo mone keneꞌuba ho tito kaꞌalo nonaꞌa melibe. Enali kaba bomagi Mesiau manaꞌi nohibe lite akeheliꞌahafi hena hiꞌahabe? ");
INSERT INTO bef_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","To Mesiau huto hilina hepaꞌiya bo moneuba mekehelinogo huto hilibe. To yaꞌma bo huto huꞌehina hepaꞌaya akeheli baga iꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu sipi mono nonugu kaga enelepito nohinagati sipi kehe ito lu epiꞌehina: Naniꞌni hiti to nani oꞌohuna hepaꞌi hiti lenali akeheli bati hiꞌahafihe? Naniꞌni nemehaꞌnilo meoꞌohube. To maꞌnaka luto naniꞌi noho lifiꞌehina boya yaꞌma fotogo huꞌehina bo lenali bu megeꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ya hiꞌahana nani aiꞌi akeheli etoꞌohube. Henaꞌmugo aiꞌa noho lifigo aitogati nani oꞌohunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ya luto ligo enali yato hite nagaꞌi emiluneꞌmu hanaya mone bufalo lite ya hite mehiꞌahana henaꞌmugope ai kanaꞌa meoꞌehinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ya nehago babu boanaꞌi lugaꞌamagi ai kaꞌa keheli pili kelete ma lite liꞌahana: Alihi Mesiau oloto sipi liliꞌna ma bouba li huto huꞌehinamofihi hoto sipiꞌa li huto hilina be ligilifihe? ");
INSERT INTO bef_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yesu kumu lugaꞌa bonaꞌmagi ya lite musi musi ka lanaꞌa Felosi bomagi akeheliꞌahana. Ya hilete enaliꞌani hiti babafi bo hiti bite gimi bomagi Yesuhi naga ilabe, lite enoho lifiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ya nehago Yesu lu epiꞌehina: Lenali hiti nani nesi kanaꞌasi nohutoꞌni ai noho lifiꞌehina bo nohinaga aku i behe huto bilunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ya hinogoꞌni lenali naniꞌi sa sa hilana bu menagalanaꞌmu yabe. To nani minaluna hepatoga lenali mealanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ya ligo Yuta bomagi ai loka hago ai loka hago hite ma lite liꞌahana: Ai hiyaꞌaga buꞌehinogo lali sa sa hilutagaꞌmu nolibe? Giliki nogo nehana metoga Yuta bo nehite Giliki bonaꞌmagihi hepato buto mono kaga enelepito bilubeꞌmu nolifihe? ");
INSERT INTO bef_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","To ai ma luto nolibe: Naniꞌi sa sa hilana bu menagalanaꞌmu. Nani buto minaluna hepato lenali mebilanaꞌmu yabe. Ya luto nolina kagamofihi hapaꞌa hena huto niꞌibe? enali ya lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fuli kana lifupa nehanamofihi su hose yupahiya Yuta bonaꞌmagihi sipi kanaꞌa yabe. Yaꞌmana yupahi Yesu ho tito kehe sipi ito lu epiꞌehina: Mone keneꞌmofi nagami kumu nobesilina nanitogati oto neno. ");
INSERT INTO bef_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mono kagu Huꞌmau ma luto fayahi goꞌehina yabe: Mone keneꞌuba naniꞌi keheli pili kalina ai komopaꞌaguti mino kosaba huse nagami ipi opohi lagalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Aitoga komopaꞌani emi malalanamagi Sikalafu lilanaꞌmu Yesu yaꞌma kaga luꞌehina. Yaꞌmana kanaꞌagu Huꞌmau Yesu kokulumalugu leꞌmo saga hilina to fana mehenaꞌa meliꞌehinaꞌmu luto Huꞌmau Sikalafuꞌi metoga ho melifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Babu bonaꞌmagi ai kaga linamofihi kehelilete liꞌahana: Maꞌnaka luto ma boya kaga lu huto hulata bomo nohibe. ");
INSERT INTO bef_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","To lugaꞌamagi liꞌahana: Ai Mesiaumo nohibe. Ya nelago lugaꞌamagi liꞌahana: Mesiau Galili metogati huto mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mono bukugu lite geꞌahana: Tebiti minoꞌehina hepalugu Betelehe yagi Tebitihi aiꞌa nagaꞌaguti Mesiau huto hilibe luto niꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ya lite Yesu kumu lilete ana bonaꞌi minanamagi loko hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lugaꞌamagi Yesuhi yato lite nagalugu leꞌmo malaluneꞌmu hanaya mone gufalo enayahi meliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gimi bomagi i behe hite sipi mono noto bo hiti Felosi bo hiti nehanalo bago enoloka heꞌahana: Lenali henabe lite leꞌmete meabe? ");
INSERT INTO bef_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ya lite enoloka hago gimi bomagi lu epiꞌahana: Yaꞌmana bouba kaga luꞌehinaꞌa huto koyapaꞌi mone bouba kaga meluꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ya lite lago Felosi bomagi lu epiꞌahana: Lenaliꞌi hiti leneleꞌmo negi nagi noꞌehifihe? ");
INSERT INTO bef_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Felosi bomagita kabati moneuba ana bomofitoga komopaꞌa emiꞌehigo bu geꞌahana niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma li gehesa hite nehana bonaꞌmagi Mosehi keya kaꞌa keheli bati mehiꞌahabe. Yamomuꞌi luto enali asagaꞌi Huꞌmamofihi buꞌalo bati mehiꞌahabe. Gumiꞌi enahalibe. ");
INSERT INTO bef_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikotimasiu koyapaꞌi Yesutoga buꞌehina bo enali nagaluguti boyago analo nohinati ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Lali keya katigu ninaꞌa huto bo moneuba li huto huꞌehinanamofihi hapaꞌa li huto mehula kagaꞌa mekehelila huꞌohutomo fakupagu nagaꞌi meemilutamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ya luto ligo enali loka heꞌahana: Kai hiti Galili bomo nohapihe? Mono ka leka so bati huto bu gobo, kaga lu hokolo hulata bo Galili metogati huto mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Asaga boanaꞌi nohaꞌaniga bu su nehago Yesu aiꞌasigo Oliba kosagu tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ya huꞌehinagati etehi foluguꞌi sipi mono nonuga akuꞌi nehetiꞌehina. Ya nohigo babu boanaꞌmagi ete leꞌmo bego hago ai melugu minoto kaga hapi fito lu enelepiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ya nohigo kaga enelepilata nehana bo yagi to Felosi bo yagi hite enali aꞌi moneuba fato bo hiti koꞌehina leꞌmete nehetite ete asaga bonaꞌmagi enubu folagato leꞌmo ho tiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ya hilete Yesuhi ma lite lu emiꞌahana: Tisao ma aꞌuba fato bo hiti nokago etafa hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lali keya katigu Moseu ka mone moloꞌehina ya aꞌi moneuba ya nohinogomo efa kosatu i fililo, luꞌehibe. To kai hena hibe luto nokeheline? ");
INSERT INTO bef_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Enali fisa iluneꞌmu yaꞌma kaga miꞌi melete loka heꞌahana. Ya hana ai Yesu melugu lipi tipi huto yahi kosaꞌatu mumusopagu fayahi goto minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ya higo enali analo ho tilete nehite loka heba heba hago Yesu bu go saga huto lu epiꞌehina: Lenali folagahatinigu bo moneꞌmofihi foipanaꞌa menilinauba mana aꞌmofihi gufalo efa kosahi yataꞌa heꞌmi meleno. ");
INSERT INTO bef_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ya luto lu epiloto akuꞌi melugu lipito mumusopagu fayahi goba goba huto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Enali ya luto epiꞌehina ka kehelilete moneko moneko bila bila hite bu su heꞌahana. Yataꞌa olopa bomagi bilago ana megeꞌi bila bila hiꞌahana. Ya hago Yesu aiꞌago nohinalo ana aꞌi ho tiloto analo minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ya hilago Yesu bu go saga huto ana aꞌi loka hoꞌehina: Ma aꞌi yale, hiyaga babe? Ka foya li ketalina bo mone meminoꞌehifihe? ");
INSERT INTO bef_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ya luto loka hago ana aꞌuba lu emiꞌehina: Sipi Bo, bo mone meminoꞌehibe. Ya ligo Yesu lu emiꞌehina. Nani ana huto ka foya meli ketalunaꞌmu yabe. Kai bufa hulotoka aku akuꞌi foipana mehubo. ");
INSERT INTO bef_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu akuꞌi ma luto lu epiꞌehina: Nani ma meꞌmofihi libiꞌa nohube. Bo moneuba naniꞌi nemegeꞌi malalinauba lo mesobose libiꞌi ligiloto metepulugu kapo memalalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ya luto ligo Felosi bomagi li emiꞌahana: Yatai kaikaꞌmu kaga nolatauba lemanaꞌa li huto menohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ya lite lago Yesu kaꞌanilo nonaꞌa luꞌehina: Naniꞌnimu kaga nolunaya ya maꞌnaka nolube. Nani ho tito oꞌohunaꞌa hiti to nobuna hepaꞌi hiti naniꞌni akeheliꞌohube. Henaꞌmugope nani ho tito oꞌohuna hepaꞌi hiti to nobuna hepaꞌi hiti yaꞌma lenali mekeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lenali ma melugu suhi hite bonaꞌi hapaꞌani loko hilata nehanaya nani bo moneꞌmofihi hapaꞌa loko mehulata nohube. ");
INSERT INTO bef_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","To nani bonaꞌi hapaꞌani loko hilube lilunaya eto huto loko hilunaꞌmu yabe. Henaꞌmugope naniꞌnigo ya mehiluna ai noho lifigo limiꞌohuna Afoꞌnifu nani hiti moneka nohigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","To keya katinigu ka mone ma luto niꞌibe: Loe bomaleꞌi moneko kaga laꞌigomo ana kaꞌatiti maꞌnaka lolo hohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","To naniꞌnimu kaga noluna ana huto noho lifigo limiꞌohuna Afoꞌnifu nani kumu kagaꞌni nolibe. ");
INSERT INTO bef_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ya ligo enali loka heꞌahana: Afoꞌkafu hiyaꞌa nohibe? Ya lago Yesu lu epiꞌehina: Naniꞌi hiti nani afoꞌnifi hiti lenali mekeheliꞌahabe. Nanimo keheliꞌahatita nani afoꞌnifihi ana hite akehelititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Asaga yaꞌmana kaga sipi mono nonugu efapo melelata nehana lapeꞌi nina hasagu minoto enelepiꞌehina yabe. To bonaꞌmagi anagati ete yato lite nagaꞌi meemiꞌahana ya henaꞌmugope ai kanaꞌa meoꞌehinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu akuꞌi ma luto lu epiꞌehina: Nani abuꞌehinogoꞌni lenali sa sa hilapa hinogo foipanatinigu fililanaꞌmu yabe. Nani biluna hepato lenali mebilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ya luto ligo Yuta bomagi liꞌahana: Nani biluna hepato lenali mebilabe nolinaya aiꞌa ho fililubeꞌmu nolifihe? ");
INSERT INTO bef_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ya lite lago Yesu kaꞌanilo nonaꞌa luꞌehina: Lenali maloti huto hiꞌahanaya nani ifogati oꞌohube. Lenali ma melugu bonaꞌi nehanaya nani ma melugu bo menohube. ");
INSERT INTO bef_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yaꞌmu luto lenali foipanatini hiti fililabe nolube. Nani kumu yaꞌma bo kiyiꞌafu nohifi lite keheli pili meke netalana foipanatini niꞌinogo fililanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ya luto ligo enali loka heꞌahana: Kai kiyiꞌagamo nohane? Ya lite loka hago Yesu lu epiꞌehina: Nani yataꞌa hapi nohuto lu epiꞌohuna bomo nohube. ");
INSERT INTO bef_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lenali hapatinimofihi kagatini loko hu lepalaluna babu lito niꞌibe. Ai noho lifigo limiꞌohuna bomofihi hapaꞌa bebe soto ninamofitogati keheliꞌohuna kaga ma melugu boanatoga lu yege holata nohube. ");
INSERT INTO bef_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","To enali afoꞌafi kumu nolina kaga keheli bati mehiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ya hago Yesu ma luto lu epiꞌehina: Alihi Kokulumaguti limiꞌehina Bomofihi giꞌa li saga hilana yupahi aimo nohinagi lite keheli sepa neite to naniꞌni nemehaꞌnilo anaꞌina mone li huto mehuꞌohuna. Afoꞌnifu nelepiꞌehinamofihi enelepiꞌohuna keheli fotogo hilabe. ");
INSERT INTO bef_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","To ai noho lifiꞌehina bomofihi bita hina suko hulata nohunaꞌmu luto ai heꞌmi netoto mebuꞌehina, nani hiti moneka nohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ya luto enelepina kaga babu bonaꞌmagi kehelilete aiꞌi keheli pili keteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuhi keheli mana hi etana Yuta bomagihi ai ma luto lu epiꞌehina: Nani lenelepiꞌohuna kaga megeꞌi melete li hetofa hilana yaꞌamagi panaꞌalobo nagaꞌni lolo hilabe. ");
INSERT INTO bef_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ya hinogo ka lamanaꞌauba lenalitoga minoto ana ka lamanaꞌauba leneleꞌmo lenubuto bilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ya ligo enali liꞌahana: Lali Abalahahi tataꞌagitamo nohune. Koyapaꞌi moneꞌa bonaꞌmagi koko panaꞌani lali meminoꞌohuta yabe. Lenali lenubuto bilabe luto nolataba ya henaꞌmu nolane? ");
INSERT INTO bef_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ya lite lago Yesu kaꞌanilo nonaꞌa ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Asaga bonaꞌi foipana li huto nehanamagi foipanamofihi kele keleꞌa nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Koko panaꞌuba lalamehi monelugu i koloto minomogoneꞌna menohina ana lalamenugu panaꞌuba analo minomogoneꞌna nohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ya huꞌehina panaꞌuba lenubuto binogomo maꞌnaka luto lenubuto biꞌehina bonaꞌi nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lenali Abalahahi tataꞌagita nehanaya nani akeheliꞌohube. Ya hiꞌahanamo ninaya nani lenelepiꞌohuna kaꞌni lenalilugu meminoꞌehinaꞌmu lite nani noho fililuneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nani Afoꞌnifu nelepiꞌehinanamofihi kaga nolunamo to lenali afotinigi lu lepiꞌahana suhi nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ya ligo enali kaꞌalo nonaꞌa liꞌahana: Afoꞌtifu Abalahau nohibe. Ya lago Yesu lu epiꞌehina: Lenali Abalahahi panaꞌa manaꞌi nehatita ai liꞌehina liliꞌna lititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","To nani Huꞌmamofitogati ma ka keheliꞌohunamofinogo lu epiꞌohube. Ya nohunamo lenali keheli menimise noho fililuneꞌmu nehabe. Abalahau yaꞌma huseꞌna li huto mehuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lenali afotinigi hiꞌahana supo nebabe. Ya ligo enali liꞌahana: Lali gulu bo menohune. Lali afoꞌtifu nohina ya Huꞌmau nohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ya lite lago Yesu lu epiꞌehina: Huꞌmau lenali afoꞌtinifu manaꞌi nohitita, aitogati oꞌohunamofita yatai ma nohuna neleꞌmo laga hatitaꞌmu yabe. Nani nemehaꞌnilo meoꞌohuna ai noho lifiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nani lenelepuna kaga lenali henabe lite keheli fe menelabe? Henaꞌmugope nani kagaꞌni lenali mekeheliluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lenali foipa bo Sataha yagapanaꞌmo nehanago ai megeꞌi malaluneꞌmu nehabe. Yataꞌa kanagu bonaꞌi enoho filiꞌehina yabe. Ai bati suhi megeꞌi moloto meminoꞌehina henaꞌmugope aitoga bati hapaꞌa meniꞌigo yabe. Ai faga lusemofihi afoꞌafu nohinago faga luseꞌnamoya aitoga bai toto niꞌibe. To faga fagauba kagaꞌa lamanaꞌa lolo hulata nohina bo nohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ya huꞌehina nani ka maꞌnaka lenelepunamo lenali ana kaꞌni keheli hetofa mehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lenali folagahatiniguti hiya bouba nani foipanaꞌni lu huto hilina niꞌibe? Ya huꞌehina nani maꞌnaka lu lepiꞌohunamofihi lenali hena hibe lite keheli menimiꞌahabe? ");
INSERT INTO bef_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Enali Huꞌmamofihi panaꞌamagi asaga kagaꞌa kehelilata nehanamo ninaya aku lenali Huꞌmamofihi panaꞌa menehabe. Yamoꞌmu lite nani kaꞌni keheli menenimibe. ");
INSERT INTO bef_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuta bomagi aku i behe hite Yesutoga ete loka heꞌahana: Kai Samalia kegiꞌa bo nohane, to foipa fele kai kugufagu niꞌibe lulata nohuta ya maꞌnaka nolupihe? ");
INSERT INTO bef_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ya lite loka hago Yesu lu epiꞌehina: Nanitoga foipa fele menohibe. Nani Afoꞌnifihi giꞌa li saga nohunaꞌmu lenali naniꞌi neleꞌmo melugu nemalabe. ");
INSERT INTO bef_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nani nigiꞌni li saga hilube luto foya menolube. Ai bonaꞌi guna malalina bo monekoꞌuba nani nigiꞌni li saga hilubeꞌmu nohibe. ");
INSERT INTO bef_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nani maꞌnaka luto lu nolepube. Nani kagaꞌni liyafa huto megeꞌi malalinauba mefililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ya ligo Yuta bomagi lu emiꞌahana: Yatai keheli bati hu ketone. Kailugu foipa fele nohibe. Abalahau filigo, kaga lu huto hulata bo filigo hiꞌahanamo ninaya, kai: Nani kagaꞌni liyafa huto megeꞌi malalinauba mefililibe nolane. ");
INSERT INTO bef_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Lali afoꞌtifu Abalahau filiꞌehibe. To kai be ligilubeꞌmu nolapihe? To kaga lu huto hulata bo ana hite filiꞌahanamo ninaya kai hena huse bo lolo hilubeꞌmu nolane? ");
INSERT INTO bef_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ya lite loka hago Yesu kaꞌanilo nonaꞌa lu epiꞌehina: Naniꞌni nigiꞌni liyafa hilunaya nani nigiꞌni faꞌmenena lolo hilinaꞌmu yabe. Ya huꞌehina Afoꞌnifu aiꞌa nigiꞌni li saga huto gelo nobinamo laliti Huꞌmatifu nohibe lilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lenali aiꞌi mekeheliꞌahana, nani keheli etoꞌohube. Aiꞌi nani mekeheliꞌohube lutita suhi huto faga lutine. Ya hutitamo ninaya aiꞌi keheli etoꞌohuto kaꞌa liyafa nohube. ");
INSERT INTO bef_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Lenali afotinifu Abalahau nani huto hiluna kanaꞌa bu galube luto gelo biꞌehina abu goloto fokehi ahoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ya ligo Yuta bomagi lu emiꞌahana: Kai olopa bo lolo mehuꞌahatamo ninaya Abalahahi abu goꞌohuto nolapihe? ");
INSERT INTO bef_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ya lite lago Yesu kaꞌanilo nonaꞌa ma luto lu epiꞌehina: Nani maꞌnaka luto lu nolepube. Abalahau huto mehuꞌehina kanaꞌalo nani minomo buto minoꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ya luto ligo enali efa kosahi lite Yesuhi iluneꞌmu hiꞌahana. Ya hana Yesu fala kito sipi mono nonuguti heꞌmito bufa huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu kapo mololoto nobuto bo mone ketoꞌehina kanalo bu pisi luꞌehina bu goto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","To panaꞌalobomagi loka heꞌahana: Babafio, ma bo bu pisi luꞌehina hena hu etoꞌehibe? Aiꞌa foipanaꞌaubafi to itoꞌafinogo afoꞌafinogo etali foipanaꞌatitiꞌmube? ");
INSERT INTO bef_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ya lago Yesu lu epiꞌehina: Oꞌe. Enali foipanaꞌaniuba mehu etoꞌehibe. Ai bu pisi luꞌehinanaꞌmu Huꞌmamofihi amuyaꞌauba leꞌmo hetofa hu etenogo gili hinogo boanaꞌi yaꞌmananamofihi bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lali yege lenogo noho lifiꞌehina bo afoꞌnifihi liliꞌnaꞌa lilata nohune. To sinihi ginogo bonaꞌmagi liliꞌna meliluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nani ma melugu minoto asaga noto noto bonaꞌmagihi libiꞌani besa loseꞌnaꞌa nohube. ");
INSERT INTO bef_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu ya lutoꞌa meꞌi mone lito yatu yigito libiꞌna ho moloto oifaꞌi lolo huto yaꞌma bomofihi buꞌalo nofolo etoto lu emiꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kai buto mone nagamiꞌi Siloami hefuto kokabana bilibo. Yaꞌma hefuhi giꞌamofihi hapaꞌa Ho Lifiꞌehina Yabe nela. Ya ligo ana bomo buto hefuto okabana bilito i behe huto noago buꞌi gili gili huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ya huꞌehigo laluꞌagi koyapaꞌi yaꞌma bouba noseꞌnamu buka buka tilatamo bu geꞌahanamagi loka heꞌahana: Muya bouba meto minoto buka tuꞌehina bo ai nohifihe? ");
INSERT INTO bef_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ya lago moneꞌamagi: Oꞌyo, ana bo nohibe, lite lago moneꞌamagi: Oꞌe, lite, menohibe. Ai okabaꞌa ana legita yaꞌma buka tuse bo nohibe. Ya lite nelago yaꞌma bouba lu epiꞌehina: Nanisi nohube. ");
INSERT INTO bef_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Enali aiꞌi loka heꞌahana: Kubuka hena huto leꞌmo bati huꞌehina? ");
INSERT INTO bef_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ya loka hago ai kagaꞌanilo nonaꞌa lu epiꞌehina: Yesu yabe nelana bouba meꞌi lito libiꞌna hoto oifaꞌi lolo huto nubuꞌnilo foloto Siloami hefuto kokabana bilibo luto ligo analo butoꞌni nokabana nobilito meleꞌisi gili gili huto nominobe. ");
INSERT INTO bef_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ya ligo enali loka heꞌahana: Ana bo hiyaga nohibe? lite lago ai: Nani mekeheliꞌohube, luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","To enali yaꞌma bo bu pisi luꞌohutoꞌamo leꞌmete Felosi bonaꞌi nehanalo bite nehetiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yaꞌma Yesu oifaꞌi lolo huto bomofihi buꞌa leꞌmo bati huꞌehina kanaꞌa yaꞌma mono fuli yupahi yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ya huꞌehinaꞌmu Felosi bonaꞌmagi ana bomofihi loka heꞌahana: Kubuka hena huto leꞌmo bati huꞌehina? Ai ma lu epiꞌehina: Bo moneuba oifatu nubuꞌnilo folo netago nagamito nokabana bilito yatai nubuꞌnitu bu nogobe. ");
INSERT INTO bef_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ya ligo Felosi bonaꞌi moneꞌamagi ma liꞌahana: Yaꞌma keneꞌi kubuka li hetofa hu etoꞌehinauba mono fuli yupapogu foya liꞌehinaꞌmu ai Huꞌmamofitogati meoꞌehinagi yaꞌma keya kalugu mone: Mono fuli yupapogu liliꞌna melilo, litomo niꞌigo yaꞌma bo kagamofihi keheli heꞌmiꞌehinagihe, lite liꞌahana. To moneꞌamagi liꞌahana: Henabe? Ai ma bomofi kumu amuya liliꞌna li etoꞌehinaꞌmu henabe luto foipa bo nohibe? Ya lite lilete folaganuguti teleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yaꞌmu Felosi bonaꞌmagi ana bomo aku loka heꞌahana: Nubuꞌni gili gili hu netoꞌehina lulata nohuta, ai kumu hena kekesa kehelilata nohane? Ya lago ai luꞌehina: Kaga lu huto huto bo nohifi? ");
INSERT INTO bef_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","To yaꞌma bo yataꞌa bu pisi luꞌehigo gili huꞌehinaꞌa yamofihi Yuta bonaꞌmagi keheli uleꞌale mehite itoꞌafinogo afoꞌafinogo etali kumu kehe ite ago etoloka heꞌahana: Ma boya panatiti nohifihe? To ketona kanaꞌagu bu pisi luꞌehina lilata nehaꞌifihe? Yatai hena huto bu nogabe? Lu limiliyo. ");
INSERT INTO bef_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Itoꞌafugo afoꞌafugo etali lu epiꞌahaꞌina: Panatiꞌa nohibe, lite to ketona kanagu bu pisi luꞌehinaꞌmu yaꞌma keheliꞌohuꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yaloꞌi ai gili huto bu noganaꞌmu hiti to bu li gili hu etoꞌehina yaꞌma bomofihi leꞌali mekeheliꞌohuꞌibe. Panatiꞌa ai olopa bo nohinagi kaga bagaꞌaguti lu lepilina aiꞌago loka halo. ");
INSERT INTO bef_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Itoꞌafugo afoꞌafugo Yuta bonaꞌi kumu koli nehite yaꞌma kaga lu epiꞌahaꞌigo henaꞌmube? Koyapaꞌi Yuta bonaꞌmagi kaga lu laga hiꞌahana: Bonaꞌi moneuba Yesu kumu Huꞌmamofihi leꞌmo ho tiꞌehina panaꞌa nohibe luto linogomo yanaꞌmu enali sipi mono nonuguti heꞌmi etete aku metilibe lite lu laga hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ya hiꞌahanaꞌmu itoꞌafugo afoꞌafugo yaꞌma kagaꞌatiti lite: Loka halo, ai olopa bo nohinagihe, lu epiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","To Yuta bonaꞌmagi ketona kanagu bu pisi luꞌehina bomofihi akuꞌi kehe ite ago lu emiꞌahana: Yaꞌma hetofa huto hu ketoꞌehinaꞌmu Huꞌmamofihi aiꞌago foke ka lu emibo. Yaꞌmana Yesu foipana lilata bo nohina keheliya iꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ya lago ai lu epiꞌehina: Ai foipa bo nohifi lamana bo nohibe luto yaꞌma nani mekehelitoꞌni yataꞌa nani nubu pisi luꞌehinamo yatai gili huto bu nogobe lutoꞌni aꞌnokehelube. ");
INSERT INTO bef_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ya ligo enali loka heꞌahana: Ai hena hena hu ketoꞌehibe? Hena huto kubuka leꞌmo bati huꞌehibe? ");
INSERT INTO bef_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ya lago ai luꞌehina: Abo. Nani yaꞌmana alu lepi su hoꞌohunamo lenali keheli sibina nehabe. Lenali henana mone hiti kehelilabe? Lenalimoya panaꞌaloboꞌa lolo hilafihe? ");
INSERT INTO bef_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ya ligo enali huli ka lu emite liꞌahana: Kai yaꞌma bomofihi panaꞌa nohane. Lali Mosehi kaꞌalo megeꞌi nomoloto panaꞌaloboꞌa nohuta yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Huꞌmau koyapaꞌi Mosehi kaga lu emiꞌehina yamofihi akeheliꞌohune. To Yesu yaꞌmana bomofihi hepaꞌagati oꞌehina lali mekeheliꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ya nelago ana bouba lu epiꞌehina: Abo. Lenali nelanamolo topa nohobe. Ai nubu pisi luꞌehinamo li hetofa huto ye ko hu netoꞌehinagi lenali ai kumu asagaꞌi mekeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","To Huꞌmau foipa bonaꞌmagihi mekehelito megesa hu epilatanaꞌmu akeheliꞌohube. To moneꞌamagi aitoga agoya hu emiꞌahanaꞌa to megeꞌi melelata nehanaꞌamagihi kehelilata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","To afehi emaꞌaga ma meꞌi huto huꞌehinagati kana nobigo keneꞌi moneuba bu pisi luꞌehina bonaꞌmofihi li gili hu etoꞌehinana lali mekeheliꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ya huꞌehinaꞌmu yaꞌma bomo Huꞌmamofitogati meoꞌehitita ai amuyaꞌa hiti bonaꞌi eneleꞌmo bati mehititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ya ligo enali kagaꞌalo nonaꞌa emiꞌahana: Kai foipanagu keketona bose. Lalitiꞌmu kaga mone li lelepilata nohapi? Ya lite nelite ana bomofihi leꞌmete mono nonuguti heꞌmi eteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Enali ana bomo heꞌmi eteꞌahana yamofihi Yesu kehelito ai kumu sa huꞌehina. Ai etafa huto lu emiꞌehina: Kai Kokulumaguti limiꞌehina Bomofi kumu keheli pili koꞌahatafihe? ");
INSERT INTO bef_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ya ligo ai lu emiꞌehina: Sipi Bo yale, ai kumu nelepiletogoꞌni komopaꞌni emito kehelilube, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","To Yesu lu emiꞌehina: Kai bu go su hoꞌahatagi yatai lu nokimina bo ma nohinagihe. ");
INSERT INTO bef_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ya noligo ai Yesuhi lu emiꞌehina: Sipi Boꞌnimaka. Nani kaitoga keheli uleꞌale nohube, luto gigusagu golaga fito koꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ya nohigo Yesu luꞌehina: Nani ma metoga oloto bonaꞌmagihi hapaꞌani bu goloto loko hilube. Bonaꞌi lugaꞌa enubu pisi luꞌehina suhi hite yanamagihi bu galana lolo hu epalalube. To bu galana suhi hite nehanamagihi li fili ko epalalube nolube, Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ya luto ligo Felosi bonaꞌi moneꞌamagi yaꞌma kagaꞌamofihi kehelite loka heꞌahana: Lali kumu nolapi, ya? Lenali hiti lenubu pisi luꞌehibe luto ya nolapiye? ");
INSERT INTO bef_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ya lago Yesu lu epiꞌehina: Lenali lenubu pisi nelinogomo nani fakupa ka lu melepiꞌohuna. To lali lubuti niꞌinagi bu go fe nolune lite yaꞌma nelana yanaꞌmu lenali komopatinigu fi hekini lo su hago fakupa ka nolu lepolobe. ");
INSERT INTO bef_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu mone kaga lu epiꞌehina: Nani maꞌnaka lu nolepube. Bonaꞌi moneuba sipisipi yagamagihi bihu kasito metise buto folaganuguti leke ho limito baukalo bo to lubalo bo nohibe. ");
INSERT INTO bef_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","To bomo moneuba kasitogati tilinamo ana bonaꞌi sipisipi yagamagihi kaba bo nohibe. ");
INSERT INTO bef_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kasito nomina bouba kafe sigi etenogo sipisipi kaba bouba tiloto sipisipi yagaꞌamagihi enigi nohenogo moneko monekoꞌisi henogo enali nogoꞌa kehelite megeꞌi melete bilabe. ");
INSERT INTO bef_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bihuguti eneleꞌmo fegu toto kohe toto nobigo sipisipi yagamagi nogoꞌa kehelilete kapogu fi hele tete megeꞌi lifite bilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Enali fato bonaꞌmofihi mekeheliꞌahana ai megeꞌi melete mebilanaꞌmu koli hite aitogati heꞌmite bifa hilabe. Henaꞌmube? Enali fato bomofihi nogoꞌa mekeheliꞌahana yabe, luto Yesu ya luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ana bame ka lu epiꞌehinaya Felosi bonaꞌi enali yaꞌma bame kamofihi hapaꞌa mekeheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu ka mone hiti akuꞌi lu epiꞌehina: Maꞌnaka lu nolepube. Naniꞌni sipisipi yagamofihi komogeꞌnamofihi kafemo nohube. ");
INSERT INTO bef_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Koyapaꞌi kohe teꞌahanamagi faga lilata enali baukalo bo to lubalo bonaꞌi huto hiꞌahana. Ya hago sipisipi yagamagi kaꞌani mekeheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nani kafe legi huto nohube. Bonaꞌmagi neleꞌmo felu mehese tite nehago Huꞌmau enubuto bito kaba hu epalalinaꞌmu yabe. Ana bonaꞌmagi fegutoga bilete nonugu tilete yaꞌma bite ete hiteꞌani sipisipi yagamagihi suhi hite noseꞌna nelata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Baukalo bonaꞌuba tilubeꞌmu nohuto sipisipi yagamagihi eneleꞌmo sibina huto gumina liloto enoho fililinaꞌmu nohibe. Nani eneheꞌmalube luto enubuto bilubeꞌmu oꞌohunagihe. Ya nohuto mino kosaba huseꞌi epilubeꞌmu nohugo enali minomo buto minoseꞌnaꞌa lilete asagaꞌi hetofa hite minalabe. ");
INSERT INTO bef_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nani sipisipi yagamagita kaba boꞌani batiꞌa nohube. Nani yaꞌma kaba boꞌani nohutoꞌni sipisipi kumu fililube luto enubuto biluna yaꞌma nani nohube. ");
INSERT INTO bef_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","To bo kaba huseꞌnamofihi liliꞌnalo efatoko lilina bo yaꞌma sipisipi yaga aiꞌa lusi kaba bo menohinaꞌa to kaba hu bati menohibe. Ai sipisipi yaga hiti ketoloto minotoꞌa to lopi kala moneuba hagulu tilubeꞌmu ago yaꞌma kaba bo bu goto sipisipi yaga heꞌmi epoloto meleꞌisi koli nofalago lopi kalauba enohoto nalubeꞌmu nohigo sipisipi yagamagi bu gete tili tele hilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Henaꞌmube? Yaꞌma liliꞌnalo efatoko lilina bo ai sipisipi yagamagi kumu mekehelise faꞌmene minoto peꞌmo mone lilinaꞌmuko keheliꞌehibe. Ai sipisipi yagamagihi lusi kaba boꞌani menohibe. ");
INSERT INTO bef_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nani sipisipi yaga kaba boꞌani batiꞌa nohube. Afoꞌnifu nani kumu keheliꞌehibe. To nani ana huto ai kumu keheliꞌohube. Ya nohutoꞌni sipisipi yagaꞌni enali kumu ana huto akeheliꞌohuna yabe. To enali ana hite nani kumu akeheliꞌahana yabe. To nani enali kumu enubuto bito fililubeꞌmu nohube luto lu moloꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","To fato fato sipisipi yagaꞌni mana bihugu menehanaꞌa enaliꞌi sa sa huloto eneleꞌmoto oto li nupa hu epalalube. Enali nogoꞌni kehelite ete li nupa hite to kaba boꞌani monekoꞌisi nohigo monekoꞌna hite minaluneꞌmu habe. ");
INSERT INTO bef_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Enali kumu fililube luto nohugo Afoꞌnifu nani kumu bita huto komopaꞌa niminogo akuꞌi filiꞌohunaguti neleꞌmo ho tinogo minalube. ");
INSERT INTO bef_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Bonaꞌi moneuba noho fililubeꞌmu nohuto nemehaꞌni li heꞌmi menetalinaꞌmu yabe. Enali kumu fililube luto naniꞌni liluna malaluna niꞌibe. To nemehaꞌni li heꞌmilufi to li heꞌmiloto akuꞌi lilube yanamofihi nani foyaꞌni niꞌibe. Yaꞌma Afoꞌnifu ya hubo luto lu nimiꞌehina kaga keheli emiꞌohube, luto Yesu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ana kaga lu epigo Yuta bonaꞌmagi kehelite yaꞌmana luꞌehina kagamofi kumu lilete ana bonaꞌi minanamagi loko hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Moneꞌamagi ma liꞌahana: Foipa felemo komopaꞌagu tito minago negi noꞌehinagihe. Henabe lite aiꞌa kaꞌa nekehelibe, lenaliya? ");
INSERT INTO bef_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","To moneꞌamagi ma liꞌahana: Oꞌe. Bo moneꞌmofihi komopaꞌagu foipa fele nohinogomo yaꞌma hetofa kaga menolibe. Foipa feleuba bu pisi luꞌehina bomofihi buꞌa li bati hu etalifihe? Oꞌe, yaꞌma mehu etalibe. ");
INSERT INTO bef_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ko ito yasi hina kana huto higo to Yelusale hepalugu koyapaꞌi sipi mono nohi aku giꞌahananamofihi enali yaꞌma beto hise yaꞌmu sipi noseꞌna nalata yupahi analo Yuta bonaꞌi li gehesa hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ana yupapo Yesu yaꞌma mono nonugu tito mone nosipetoga giꞌa Solomonihi Nosipeto yabe ya nelana ai anagu kapo nomalago ");
INSERT INTO bef_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuta bonaꞌmagi aitoga ete leꞌmo bego bego hite loka heꞌahana: Lali loe lae nohuta henaki kana bulenogo komopati li hokolo hu letalane? Huꞌmau kokulumaluguti ho lifiꞌehina bo, Mesiau, yaꞌma nohapi maꞌnaka luto lu limibo. ");
INSERT INTO bef_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ya nelago Yesu kagaꞌanilo nonaꞌa lu epiꞌehina: Yataꞌa nani alu lepi su hoꞌohugo lenali yaꞌma kagaꞌmu keheli uleꞌale mehiꞌahana. Afoꞌnifu kaga lu molo netoꞌehinamofihi liliꞌnauba yaꞌma nani kumu ya suhi lenelepiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lenali ka lamanaꞌa lu lepiꞌohunanamofihi lenali keheli uleꞌale mehiꞌahana yagi sipisipi yagaꞌni menehanagihe. ");
INSERT INTO bef_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","To sipisipi yagaꞌnimagi nogoꞌni kehelilata nehabe. Nani enali kumu keheliya igo nemegeꞌi meleꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yaꞌma yagapanaꞌnimagi mino kosaba huseꞌna epilube luto mefilise mineme bite minalabe. Nani enunu kiꞌohunaguti fato bouba nebe mesililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yaꞌma yagapanaꞌni nimiꞌehina bo, Afoꞌnifu ai asagaꞌi enebe ligiꞌehina. To kaba hu epoloꞌehinaguti fato bo moneuba oto be mesililinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Afoꞌnifu hiti nani hiti moneko babeyafalo nohuꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ya ligo Yuta bonaꞌmagi efahi lite aku halune lite lago ");
INSERT INTO bef_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu lu epiꞌehina: Afoꞌnifu liliꞌna nimiꞌehina yaꞌma lenogobisalo babu luto li huto huꞌohugo ana hetofa liliꞌna monekoꞌi liꞌohuna, henaꞌmu nahaluneꞌmu nehabe? ");
INSERT INTO bef_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yuta bonaꞌmagi enali kaꞌalo nonaꞌa ma lite lu emiꞌahana: Lali hetofa liliꞌnaka liꞌahataꞌmu yaꞌma mekahaluta kai faꞌmene bo nohatitamo niꞌigo Huꞌmamofihi lube sibina huto luꞌahatamo afoꞌnifu ai hiti nani hiti moneko babeyafalo nohuꞌibe luto ya luꞌahataꞌmu fakupa ka lu ketoto kahaluneꞌmu hune. ");
INSERT INTO bef_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ya lago Yesu lu epiꞌehina: Lenali keya katinigu Huꞌmau luꞌehinamo keyeꞌahana: Lenali huꞌma suhi hite nehabe. ");
INSERT INTO bef_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yaꞌma lali mono kaga keyeꞌahana lamana ka niꞌigo mino lito buꞌehina kaga niꞌibe. Huꞌmau kaꞌa lu epiꞌehinaꞌa enali kumu nani suhi hite mineꞌahabe luto Huꞌmau luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","To nanimoya Afoꞌnifu neleꞌmo ho tito melugu noho lifiꞌehina. Nani Huꞌmamofihi panaꞌa nohube lutoꞌni yaꞌma lenali henabe luto lube sibina huto luꞌahatabe lite nelabe? ");
INSERT INTO bef_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Afoꞌnifihi amuya liliꞌnaꞌa menolinogoꞌnimo nanitoga keheli menimilabe. ");
INSERT INTO bef_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Analoꞌi nani kumu keheli uleꞌale mehite yaꞌma liliꞌna liꞌohunanaꞌmu keheli uleꞌale hite minaluneꞌmu hilo. Henaꞌmube? Yaꞌma liliꞌna liꞌohutamo niꞌigo Huꞌmau neheꞌmoto nanitoga i keꞌmoto monekoꞌna nominoꞌibe. To nani ana huto aitoga i keꞌmobe. ");
INSERT INTO bef_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ya luto lu epigo enali mone hiti aku nagaꞌi emiluneꞌmu nehago ai enayanuguti enebe silito bufa huꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","To Yesu buto Yotani nagamito leke hoto koyapaꞌi Yoniu ana nagami folo epolose hepato buto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Anagu nohigo babu boanaꞌi nehetite liꞌahana: Yoniu liliꞌna amuyaꞌa hiti meliꞌohuto to ai ma bo kumu kaga luꞌehinaꞌa yaꞌma lamaꞌnaka lu huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yaꞌmana kegiꞌa bonaꞌmagi babu luto Yesu kumu keheli uleꞌale hite agoya hu emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hepato mone Betani analugu bo mone Lasalasi yabe giꞌa nelana ai minoto besiꞌehina. Yaꞌma Betani hepaꞌi loe ate Malia to Mata mineꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yaꞌma Maliau ai Yesuhi gigusaꞌalo tu mesebe hekito folo etoto okaꞌatu kele li etoꞌehinamofihi etaliꞌafu Lasalasi yaꞌma besiꞌehina bo yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","To ana aꞌmaleꞌi Yesutoga kaga melete lu emiꞌahaꞌina: Sipi Bo, kai kibita huse bo kalalukafihi besiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","To Yesu yaꞌmana besiꞌehinaga obo luto liꞌahaꞌinaꞌmu kehelito luꞌehina: Yaꞌmana Lasalasihi besiseꞌna huto hu eminogo fililoto meminalinaꞌmu yaꞌma bonaꞌmagi kehelite Huꞌmamofihi giꞌa liyafa hilabe. Yanaꞌmu nani panaꞌa nohugo enali ana hite nigiꞌni liyafa hiluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","To Yesu Matahi to gonaꞌa hitiꞌi to Lasalasi hiti komopaꞌa epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","To Lasalasi besiꞌehinamofihi kaga kehelito Yesu nominana hepalugu loe yupahi hiti minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Minoto panaꞌalobo lu epiꞌehina: Lali i behe huto Yutia melugu bilune, Yesu luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ya ligo panaꞌalobomagi lu emiꞌahana: Babafio, henabe luto anaga bilune? Hupamone kana Yuta bonaꞌmagi efa kosatu kahalune lite lago lanamoya to ana kegiꞌa lu kehelito bilune lapiye? ");
INSERT INTO bef_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ya lago Yesu lu epiꞌehina: Yege tilengo mone yupahi goꞌi luto fana talibe. Bonaꞌi moneuba kapo moloto nobinogo yege notigo efanuguti kanafu tito mekalinaꞌmu yabe. Henaꞌmube? Fana toseꞌnamofihi melugu bu go bati huto ho koto mekalibe. ");
INSERT INTO bef_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","To bo moneuba sinihi ginogo kapo moloto bilina ho kalinaꞌmu yabe. Henaꞌmube? Komopaꞌagu fana toseꞌnaꞌa meniꞌigo yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu ya luto mone hiti luꞌehina: Lalalutifu Lasalasi ai buꞌi koꞌehina to nani buto leꞌmo ho tilube. ");
INSERT INTO bef_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ya ligo panaꞌalobomagi lu emiꞌahana: Sipi Bo yale. Buꞌi koꞌehina ye kalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu lu epiꞌehinamofihi hapaꞌa yaꞌma Lasalasi afiliꞌehibe. Enali enegekesa kehelite ai faꞌmene buꞌi koꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Enali sibi enegekesa kehelite nehago Yesu lu hokolo huto lu epiꞌehina: Lasalasi afiliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Afilitita aitoga nani meminotitaꞌmu nipagu bati huto nohigo yaꞌma lenali kumu ya luto nolugo alihi nanitoga keheli uleꞌale hi nimilabe. Yaloꞌi lali aitoga bilune. ");
INSERT INTO bef_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ya ligo Tomasiu fato giꞌa Ubabeya yabe laluꞌagihi panaꞌalobo lu epiꞌehina: Ke, bati huto babafi boti ai hiti lali hiti binogoti loho fililabe. ");
INSERT INTO bef_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","To Yesu to panaꞌaloboꞌa Betani hepato nehetite Lasalasi filiꞌehinogo enali gufaꞌa keli heꞌahana yege yupahi loegi loegi niꞌigo keheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Betani hepaꞌi Yelusale hepato lebatoꞌi niꞌinalo yaꞌmu Yuta boanaꞌi babu lite Mata hiti Malia hiti bu galune lite ete soso hi etete eniginaga fi etimiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","To Matau Yesu noana kehelito nonuguti heꞌmito limito aitoga nobigo Maliau nohaꞌanigu faꞌmene minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matau buto Yesuhi fo tula hoto lu emiꞌehina: Oho, Sipi Boꞌnimaka. Kai nohaꞌnigu minatita netaliꞌnifu mefilititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","To yatai hiti nani aꞌnokehelube. Kai afokafitoga loka hetogo Huꞌmau moneꞌna kimilinagihe, luto Mata luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","To Yesu lu emiꞌehina: Ketalikafu filiꞌehinaguti leꞌmo ho tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ya ligo Matau lu emiꞌehina: Su halina kana sipiꞌa yanugu Huꞌmau netaliꞌnifihi leꞌmo ho tilina keheli fe luꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ya ligo Yesu lu emiꞌehina: Nanisigo filiꞌahana bonaꞌi eneleꞌmo ho tilata bo nohuto mino kosaba huseꞌna epilata bo nohube. To bonaꞌi moneuba nanitoga keheli uleꞌale nohinogo gufaꞌa fililenogo aku yaꞌma bo mino lito buto minalube. ");
INSERT INTO bef_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","To bonaꞌi moneuba nanitoga i keꞌmoto minoto to keheli uleꞌale hu nimito minalina mefililinaꞌmu yabe. Yaꞌma keheliya ito nominatafihe? ");
INSERT INTO bef_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ya ligo Matau lu emiꞌehina: Oꞌyo. Sipi Bo, Huꞌmamofihi panaꞌa leꞌmo ho tiꞌehina bo nohane. To kokulumaluguti koho lifigo melugu limiꞌahata yaꞌma akeheli amuya moloꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matau ya lu emito i behe huto buto gonaꞌa Malia nohinalo buto musi huto kaga lu emiꞌehina: Babafiti noanogo kai kumu kehe noibe. ");
INSERT INTO bef_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ya ligo Maliau kehelito meleꞌisi ho tito aitoga buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nohi hepato menehetito Matau yataꞌa lu emiꞌehina kapoꞌalo ya minago Maliau anaga nehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","To Yuta bonaꞌmagi Maliahi eniginaga fi emiꞌahanamagi nonugu minete ai ho tito meleꞌisi leke ho nolimigo enali bu gete enegekesa kehelite ai kene mala malatoga buto yibi bilubeꞌmu nobibe lite megeꞌi melete biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliau Yesu nohinalo nehetito lipito gigusalugu nu kito lu emiꞌehina: Sipi Boꞌnimaka. Kai nohatita netaliꞌnifu mefilititaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Ya luto yibi nohigo Yuta bonaꞌi eꞌahanamagi hiti yibi nehago Yesu bu goꞌehina. Bu goto komopaꞌagu sipi ginaga figo mehi epito enoloka hoꞌehina: Lenali hiyaga keli heꞌahana? luto ligo enali: Maloꞌi oto bu gobo, Sipi Bo yale, lite lu emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ya nelago Yesu yibi huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yibi nohigo Yuta bonaꞌmagi ma lite liꞌahana: Bu galo. Ai yaꞌma bo kumu sipi kekeꞌi li etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ya lago moneꞌamagi ma liꞌahana: Abo. Bu pisi luꞌehina bomofihi leꞌmo bati huꞌehinamo yanaꞌmu henabe luto Lasalasi besiꞌehinamo leꞌmo ye katita mefilititaꞌmu ya hifihe? ");
INSERT INTO bef_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ya liꞌahago Yesu mone hiti komopaꞌa sipi ginaga figo kene mala malatoga buto yaꞌma mulimofihi efahi mone bagaꞌalo hekini leꞌahanaga nehetiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ma lu epiꞌehina: Yaꞌma efahi li heꞌmiꞌehilo. Ya ligo filiꞌehina bomofihi etaliꞌafu Matau lu emiꞌehina: Sipi Boꞌni yale, Loegi loegi yupahi meleꞌahanagi tugumaꞌi gofa nobibe. ");
INSERT INTO bef_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ya ligo Yesu lu emiꞌehina: Henaꞌmube? Yataꞌa lu kimiꞌohunamofihi mekeheliꞌahatafihe? Kai nanitoga keheli uleꞌale hinogomo Huꞌmamofihi amuyaꞌa hiti fana toseꞌnaꞌa hiti bu galane luto lu kimiꞌohunagihe. ");
INSERT INTO bef_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ya ligo hekini leꞌahana efahi li heꞌmiꞌahana. To Yesu bu go saga huto ma luꞌehina: Afoꞌniga, nani kumu kehelilata nohane. Yanaꞌmu foke ka lu kimilata nohube. ");
INSERT INTO bef_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nani kumu kehelilata nohatana keheliya iꞌohube. Yaloꞌi nani aku ya nolugo henaꞌmube? Ma bonaꞌmagi kai melugu noho lifiꞌahataꞌmu yaꞌma keheli uleꞌale hilabe. ");
INSERT INTO bef_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ya luto luloto ai ka mone sipi kehe ito: Lasalasio, leke ho limibo, luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ya ligo filiꞌehina bouba ho tito yogolo poto leke ho limigo gigusaꞌa yahaꞌa katatu sa giꞌahana to okabaꞌa hiti sa giꞌahana. Lasalasi ya minago Yesu lu epiꞌehina: Gulu ho etenogo bino. ");
INSERT INTO bef_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","To babu Yuta bonaꞌi Maliatoga nehetiꞌahanamagi Yesu huꞌehinanamo bu gete aitoga keheli li pili keꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","To lugaꞌamagi i behe hite Felosi bonaꞌi nehanalo bite Yesu huꞌehinanaꞌmu lu epiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ya lu epite nehago Felosi bo hiti to sipi mono noto kaba bonaꞌi hiti li nupa hite mono kanisole bonaꞌi li gehesa hite ma kaga liꞌahana: Yaꞌma bouba amuya liliꞌna babu luto liꞌehinagi henati hilune? ");
INSERT INTO bef_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lali meheꞌmi etenogo ai amuya moloto nominago yege yege boanaꞌi aitoga kehelite agoya hu emilabe. Enali ya hilenogo Lomu gamani bonaꞌi kehelite lali sipi mono nohati tele bite lali nagati hiti asagaꞌi enoho fililuneꞌmu habe. ");
INSERT INTO bef_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ya nelago enaliluguti bo moneuba giꞌa Kaiyafasi, ai kufugu mono nohi kaba bo sipiꞌa yaꞌmauba ho tito lu epiꞌehina: Lenali negi nete mekehelilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Henabe lite asaga Yuta bonaꞌmagita fililabe? Filinogo fenene hilibe, menekehelifihe? Ana bouba ai monekoꞌisi boanaꞌmofi kumu fililina bati huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Yaꞌma kaga lu epiꞌehinaꞌmu aiꞌa keheliꞌehinaꞌa meniꞌibe. Ana kufugu sipi mono noto kaba bo nohigo lu huto huto bo legi huto yaꞌma Yesu ai asaga Yuta bonaꞌmagi kumu fililina to enali kumu hiti fililoto to Huꞌmamofihi pananaꞌa futili hiꞌahanaꞌamo eneleꞌmo nupa hilibe. Yaꞌma kagaꞌamofihi hapaꞌa mekehelise faꞌmene bagaguti lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ya lu epiꞌehigo ana kanagu Yuta kaba bomagi lu kehelite ho fililune lite yamofihi kapoꞌa sa sa hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yanaꞌmu Yesu Yutia metoga folaganugu kapo memoloto anagati heꞌmito mone hepaꞌi giꞌa Efelemu ka metoga lebatoꞌi ana hepato buto minoto panaꞌalobo hiti mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","To analoꞌi Yuta bonaꞌmagi Pasa noseꞌna nalana kana maꞌasi huto hinogo to bonaꞌi fato fato hepatogati ete Yelusale nehetite enugufa okala hilana yanamofihi mono noseꞌna nalabe lite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Enali Yesu kumu sa sa nehite sipi mono nonugu li nupa hite ai loka hago ai loka hago hite liꞌahana: Kai henabe luto nokeheline? Mana sipi noseꞌna nalanaga alifi mealibe? lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","To sipi mono nohi kaba bomagi hiti to Felosi bonaꞌmagi hiti boanaꞌi lu epiꞌahana: Yesu nominalina hepaꞌa kehelilete ete lu limilo, lite yaꞌma kaga meleꞌahana. Henaꞌmube? Nagaꞌi emilune, lite liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","To yege yupahi nayahaꞌni su hoto mone kegiꞌa monekoꞌisi leke ho malago Pasa noseꞌna nalana kana huto meoꞌehibe. Yesu yaꞌma filiꞌehina bo Lasalasi leꞌmo ho tiꞌehinaꞌa hepaꞌi, Betani yabe, ai buto analo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ana hepato enali Yesu kumu noseꞌna mone laita hite loloba nehago Matau guna ito epigo Lasalasi hiti Yesu hiti hitalo minete neꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ya nehago Maliau mone kopogu tu mesebe nagamiꞌi nina yama mesebe sipi efatoti mina fiꞌehinamofihi ai lito Yesuhi gigusalo i hekito folo etoto yatama okaꞌatu kele li etoꞌehina. Ana mesebeuba nonugu asagaꞌi tu hetofaꞌa biꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ya higo Yesuhi panaꞌalobo moneuba giꞌa Yutasi Isikelioti yaꞌmana bo alihi Yesu kumu Felosi bonaꞌi gutunu ka lu epilina ai ma luꞌehina: ");
INSERT INTO bef_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Abo. Yaꞌma tu mesebemofihi fato bouba mina finogo minaꞌaloti 300 kina yabe lite bite enumuhi menina bonaꞌi epilina niꞌibe. Henabe luto faꞌmene folo etoꞌehibe? ");
INSERT INTO bef_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yutasiu ya luto faga luꞌehina muhi menina bonaꞌi kumu kaba mehu epolose ai gumina lilata bo nohibe. Aiꞌago efaha guꞌi lito kaba hulata aku ai hapaꞌa ana efaha guꞌmoguti gumina lilata huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","To Yesu luꞌehina: Oꞌe, heꞌmi etalo. Ma aꞌuba nehete keli halana yupapofi kumu mesebe folo netoꞌehinagi yaꞌma aiꞌa niꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Asaga kana enumuhi menina bonaꞌi lenalitoga neminabe. Asaga kana nani lenalitoga meminalube, luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","To Yuta bonaꞌmagi babu lite Yesu Betani hepalugu nominanamofihi kehelite anaga biꞌahana. Enali Yesuhi bu galune lite to filiꞌehinaguti leꞌmo ho tiꞌehina Lasalasi bu galune lite biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yaꞌma huꞌehinaꞌmu sipi mono noto kaba bomagi kehelite Lasalasi halana ka lu hetofa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Henaꞌmube? Babu Yuta bonaꞌmagi Lasalasi filiꞌehinaguti leꞌmo ho tiꞌehinaꞌmu kehelite mono kaba nagatogati heꞌmite to Yesutoga keheli uleꞌale hite agoya hi emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mone yupahi etekaꞌa babu boanaꞌmagi Pasa noseꞌna nalana kanaꞌalo li gehesa hite Yesu Yelusale hepato alibe lite keheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ya kehelilete yafa hayaꞌa i gofa hete mone olopa kapo nekisaꞌalo melete to mone yafa hayaꞌamo lite bite fo tula helete enegelo biꞌahana: Oho, Huꞌmamofitoga fokehi li emilo. Huꞌmamofihi bo noananamofihi giꞌa liyafa hilo. Huꞌmao, kai Isilaeli gihiti bomofihi lusa gi etobo, lite hekele liꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ya nelago Yesu toki yaga sa huto moneꞌmofihi gupisaꞌalo minoto oꞌehina. Ya huto koyapaꞌi ai kumu mono bukugu fayahi keyeꞌahana: ");
INSERT INTO bef_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yiona hepato bonaꞌmagita koli mehilo. Gihiti botini lenalitoga nooto toki yaga ikeleꞌamofihi megesalo minoto noana. Bu galo. ");
INSERT INTO bef_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yaꞌma hiꞌahana kanaꞌagu Yesuhi panaꞌalobomagi mono kaga koyapaꞌi fayahi geꞌahanamofihi hapaꞌamu mekehelite to boanaꞌmagi Yesu kumu enegelo biꞌahananamu ana hite hapaꞌamu mekeheliꞌahana. To alipo Yesu filiꞌehinaguti ho tito kokulumamofihi fana toseꞌnagu tiꞌehina yana kanagu yaꞌma mono fayahi geꞌahanamofihi beto hite keheliya iꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Koyapaꞌi Yesu Lasalasi mulilugu meleꞌahana filiꞌehinaguti leꞌmo ho tiꞌehinamofihi kanaꞌa babu boanaꞌi minete bu geꞌahanaꞌamagi bite Yesu kumu lu yege heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ya huꞌehinaꞌmu yaꞌma babu boanaꞌi Yesuhi amuya liliꞌnaꞌamu akehelite kapogu fo tula hete li nupa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ya nehago Felosi bomagi ai lu emigo ai lu emigo ma lite liꞌahana: Bu gete kehelilo. Lali ai be meligilata nohune. Bu galo, noto noto boanaꞌi silagaꞌmagi megeꞌi melelata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","To Yelusale hepalugu boanaꞌi tite mono nonugu sipi noseꞌna nalana yupahi lugaꞌamagi Giliki bonaꞌi hiti moneko kumu tiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Enali ete Yesuhi panaꞌaloboꞌa mone Filipi, ai Betesaita hepato Galili meluguti oꞌehina bo aitoga ete lu emiꞌahana: Babafio, lali Yesuhi bu galuneꞌmu hune. ");
INSERT INTO bef_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ya lago Filipiu kehelito laluꞌafihi Atulu nohinalo buto ana kaga lu emiꞌehina. To keheligo etali moneka Yesutoga bite lu emiꞌahaꞌina: Giliki bonaꞌi enali kai kumu sa sa nehabe. ");
INSERT INTO bef_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ya laꞌigo Yesu lu etimiꞌehina: Yatai Kokulumaguti limiꞌehina Bomo sipi fana mehaꞌa aitoga huto hilina yaꞌma kanaꞌa maꞌasi huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lusiga lu nolepube. Mone noseꞌna bihaꞌa melugu melimilina, faꞌmene minoto pata sito boloto metilinaꞌmu. To noseꞌna bihaꞌa mone tili hu mo ito bololoto tito legeyaꞌa babu luto halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","To ana huto bo moneuba mino lito buseꞌnaꞌa amuyaꞌa hiti li pili nokenogo aiꞌa fenene hilinaꞌmu. To bo moneuba ma melugu mino lito buseꞌnaꞌa li pili mekalina, megesa hu emilina, yaꞌma bomofihi fenene mehuse ai kokulumalugu minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","To bonaꞌi moneuba foyaꞌni li netalubeꞌmu nohutoꞌa nemegeꞌi malalinaꞌmu yabe. Ana kele kele panaꞌni suhi huto nani nominonaga ai hiti minaluꞌibe. Ana bo foyaꞌni netalata nohigo afoꞌnifu leꞌmo ho tito sipi gi molo etalibe. ");
INSERT INTO bef_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","To Yesu kaga mone hiti lu epiꞌehina: Yatai nani nipaꞌnigu nagabu gofa nogibe. To nani henabe lilube? Afoꞌniga ma kana lolo mehu netalata ya lilufi? Henaꞌmube? Yaꞌma kekeꞌi luseꞌna nugupisalo huto hina kanagu oꞌohunagi huto hu netolenogo minalube. ");
INSERT INTO bef_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ke, afoꞌniga. Kigikamo leꞌmo hofa tobo. Ya ligo kokulumaluguti nogoꞌa moneuba lu emiꞌehina: Nani nigiꞌni leꞌmo hofa toꞌohunagi to aku mone hiti leꞌmo hofa talunagihe. ");
INSERT INTO bef_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ya ligo li nupa hiꞌahana boanaꞌmagi ana nogoꞌa kehelite ma liꞌahana: Kokililika nolibe, lite to moneꞌamagi: Agelo moneuba lu emiꞌehibe, lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","To Yesu lu epiꞌehina: Yaꞌmana nogoꞌauba kaga nani kumu meluꞌehina. Yaꞌma lenalitiniꞌmu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yatai Huꞌmau asaga melugu boanaꞌmagihi guna malalibe. Yaꞌma meꞌi kaba bo, Satahi leꞌmo laba hinogo amuyaꞌa limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","To enali meluguti neleꞌmo saga hilenogo nani babu boanaꞌi nanitoga eneleꞌmo moloto kefefe hilunagihe. ");
INSERT INTO bef_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu ya luto luꞌehinaꞌamofihi hapaꞌa ma nina, malipu yafalo henogo fililinamofihi gabu giseꞌnaꞌa hiti lilina yaꞌma kagauba lu hokolo hu epoloto enelepiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","To ya luto ligo bonaꞌmagi kagalo nonaꞌa lu emiꞌahana: Lali keya ka bukugu fayahi geꞌahana: Mesia ai minoba minobo hilinaꞌmu, henabe luto enali Kokulumaguti limiꞌehina Bomofihi meluguti leꞌmo saga hite ho fililabe, luto luꞌahata? Kokulumaguti limiꞌehina Bo kiyiꞌafu nohibe? ");
INSERT INTO bef_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ya lago Yesu luꞌehina: Lenali folaganugu fana toseꞌnauba bula ola huto huꞌehinamofihi hupamone kana su halinaꞌmu. Lenali yaꞌma fana toseꞌna niꞌigo analo nehilo. Ya hite, metepuna lenalitoga lenebe ligi lalibe luto luꞌohube. Bonaꞌi metepunagu minoto kapo bilina bu go bati mehuse kapoꞌa menokehelibe. ");
INSERT INTO bef_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yaꞌma fana mehaꞌalo lenali megeꞌi nemelete anagu foya lamanaꞌa lite minalo. Lenali ya hilete fana toseꞌnamofihi boanaꞌi lolo hilabe. Yesu ya luto lu epito ai buto fato hepatoga fala kito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yaꞌma amuyaꞌa hiti foya babu luto enubulo liꞌehinamoꞌmu enali aitoga keheli uleꞌale mehite to agoya hu meemiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ya huꞌehinaꞌmu koyapaꞌi lu huto huto bo mone, Aisaiyau ai fayahi koyoꞌehinamofihi yaꞌma lamaꞌnaka luto lu huto huꞌehina: Sipi bo yale. Lali ka lamanaꞌa lu yege hoꞌohuna, kiyiꞌafu ana kagati keheli uleꞌale huꞌehibe? To Sipi Bouba amuyaꞌa enelepiꞌehinogo kiyi kiyiꞌafu keheliya iꞌahabe? ");
INSERT INTO bef_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Enali aitoga keheli uleꞌale mehiꞌahanamo henabe lutobe? Yanaꞌmu Aisaiyau mone hiti fayahi koyoꞌehinamo ma niꞌibe: ");
INSERT INTO bef_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Huꞌmau enubu li fili ko epoloꞌehina. Ai enegekesa fi hekini lo epoloꞌehina. Ya hu epoloꞌehinagi enali enubutu bu megalanaꞌmu to enegekesatu keheliya meilanaꞌmu to komopaꞌani i gelehe hite nanitoga mealana leneleꞌmo ye kalube luto lunamobe. Oꞌe, kaitoga mebilune lite liꞌahanagihe. ");
INSERT INTO bef_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yaꞌma koyapaꞌi lu huto huto bo, Aisaiya aiꞌi Huꞌmau leꞌmo ho tiꞌehina bomofihi fana mehaꞌa bu goꞌohuto Yesu kumu kaga luto koyoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","To Yuta enikibina bonaꞌmagi babu lite Yesutoga keheli uleꞌale hite aku Felosi bonaꞌi kumu koli hite lu huto mehise faꞌmene mineꞌahana. Lu meepiꞌahana henaꞌmube? Enali Yesuhi kaga li pili kaluneꞌmu nehanamagi enegekesa kehelite Felosi bonaꞌmagi Yesuhi agoya hu emiꞌohunaꞌmu kehelilete mono nonuguti leleꞌmo heꞌmi lalibe lite faꞌmene mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Enali Huꞌmau foke ka lu epiꞌehinaꞌa nesiꞌasi epesigo to noto noto bonaꞌmagi enofoke ka lu epiꞌahana yaꞌmana sipi epesiꞌehinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","To Yesu bonaꞌi li nupa hiꞌahanamagihi kehe ito sipi kaga lu epiꞌehina: Bonaꞌmagi nani kumu keheli nimilana enali naniꞌnimuko mekehelite noho lifiꞌehina bo, Afoꞌnigi hiti leꞌalitoga enali keheli uleꞌale hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","To bonaꞌmagi bu nenegete noho lifiꞌehina bo, Afoꞌnifihi hiti bu negabe. ");
INSERT INTO bef_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","To nani yaꞌma melugu oto minoto libiꞌi mone suhi huto nominobe. Ya nohugo bonaꞌmagi nanitoga keheli uleꞌale hite metepuna monelugu meminalanaꞌmu. ");
INSERT INTO bef_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","To bonaꞌmagi yaꞌma kagaꞌni keheli heꞌmilenogo nani aiꞌa hapaꞌa loko mehilubeꞌmu hube. Nani melugu oto noto noto bonaꞌi kagaꞌani loko hilubeꞌmu meoꞌohube. Noto noto bonaꞌmagihi enubuto bilunaꞌmu yabe lutoꞌni yanaꞌmu oꞌohunagihe. ");
INSERT INTO bef_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bonaꞌmagi enemegesa hi nimilana to kaꞌni keheli heꞌmilana enaliꞌi keneꞌi moneuba ka foya li epoloto kagaꞌani loko hilibe. Yaꞌma lu epiꞌohuna kagaꞌauba meꞌmo hiti kokulumamo su halina kanaꞌagu hapaꞌanimofihi loko hilibe. ");
INSERT INTO bef_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yaꞌma kaga luꞌohunamofihi naniꞌnisigo meniꞌibe. Noho lifiꞌehina bo, Afoꞌnifu aiꞌa lu huto hilane luto luꞌehina kagamo yaꞌma nani lu yege holata nohube. ");
INSERT INTO bef_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","To Afoꞌnifu kaga lu moloꞌehina yanauba bonaꞌi enubuto binogo mino kosaba hilanaꞌa yaꞌma lilabe akeheliꞌohube. Kagaꞌya lu nolepuna Afoꞌnifu luꞌehina bagaꞌaguti yaꞌma lu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","To mone kanaꞌa noseꞌna laita hite nalana Pasa yabe nelana yaꞌma yupahi leba talina Yesu ma meluguti heꞌmito afoꞌafihi hepato bilina kana maꞌasi huto hilibe luto akeheliꞌehina. Ai boanaꞌa ma melugu mineꞌahanamagihi asaga yupahi kekeꞌi lu epoloꞌehina. To ai kekeꞌi lu epoloseꞌnaꞌa minomo buto su mehoꞌehigo ai filiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Utehi Yesu to panaꞌalobomagi hiti noseꞌna nete mineꞌahana. Ya nehago Satau lu kehelito Yutasi, Simoni Isikeliotihi panaꞌa, ai Yesuhi fatehaꞌa gutunu ka epilibe luto lu molo etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu afoꞌafu asaga kaba huseꞌna emiꞌehina kehelito to Huꞌmamofitogati limito oꞌehina hiti to i behe huto Huꞌmamofitoga akuꞌi bilina yaꞌmana akeheliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ya huꞌehinaꞌmu Yesu hitaloti heꞌmito kefe guꞌa kisi heꞌmito tauli kata mone lito li bilisa hoto ");
INSERT INTO bef_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","to nagamiꞌi somogu hefito panaꞌaloboꞌamagihi enigigusaꞌani okala hu hapi fito ho tiloto tauli kata li bilisa hoꞌehinatu kele li epoloꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","To ya hutoꞌa Simoni Pita nohinaga buto minago Pitau loka hoꞌehina: Sipi Bo yale. Nigigusaꞌni okala hu netalapi, luto ligo ");
INSERT INTO bef_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu lu emiꞌehina: Yaꞌma huto hu ketonana mekeheline. Alihi yaꞌma hapaꞌamu komopakatu keheliya ilane. ");
INSERT INTO bef_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ya ligo Pitau lu emiꞌehina: Oꞌe, kai nigigusaꞌni okala mehu netalataꞌmu lusiga nolube. Ya ligo Yesu lu emiꞌehina: To nani okala mehu ketolenogoꞌni kai panaꞌaloboꞌni lolo mehilane. ");
INSERT INTO bef_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ya ligo Pitau lu emiꞌehina: Sipi Bo, nigigusaꞌnigo okala mehutoka nayahaꞌni latahaꞌni asagaꞌi okala hu netobo. ");
INSERT INTO bef_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ya ligo Yesu lu emiꞌehina: Bonaꞌi moneuba nagamilugu kolago yaꞌma bomofihi gufaꞌa gulu gulu ligo akuꞌi okala mehilinaꞌmu. Mone yupahi gigusaꞌago okala huloto yaꞌma anasi gulu gulu lilibe. To lenali ana hite komopatinigu gulu gulu luꞌehina. Folagahatinigu keneꞌi monekoꞌisi gulu gulu meluꞌehina yabe luto Yesu lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yaꞌma kamofihi monekoꞌi gulu gulu meluꞌehinamo henana niꞌibe? Bo moneuba fatehaꞌamagihi gutunu ka lu epilina yaꞌma boꞌmu Yesu kohe toto akeheliꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ai enigigusaꞌani okala hu su ho epoloto kefe guꞌa akuꞌi i kololo bito hitalo buto meto minoto enoloka hoꞌehina: Ya hu lepoloꞌohunamofihi hapaꞌa akeheliꞌahanafihe? ");
INSERT INTO bef_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lenali nani kumu Babafio lite to Sipi Botio nigi hana maꞌnaka lite nigi habe. Yaꞌma nohube. ");
INSERT INTO bef_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nani Sipi Botini hiti Babafitini nohube. To nani lenigigusatini maꞌasi okala hu lepoloꞌohunagi lenalitini ana hite yaꞌma ai okala hu etenogo ai okala hu etenogo yaꞌma hilo. ");
INSERT INTO bef_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nani babeyafaꞌa lenelepiꞌohunagi lenali yaꞌma hu lepoloꞌohunamofihi kehelite ana hite agoya hu epite minalo. ");
INSERT INTO bef_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Lusiga lu nolepube. Koko panaꞌa mone afoꞌafihi be ligiꞌehina panaꞌi menohibe. Ana huto kaga lito buꞌehina bo mone ai ho lifiꞌehinaꞌamofihi be meligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yaꞌmu lusiga lu lepiꞌohuna, yatai lenali keheliꞌahana. Kehelilete megeꞌi melete nehago komopatinigu babahi hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nani lenali kumu asagaꞌi menolube. Eneleꞌmo ho tiꞌohunaꞌamofihi akeheliꞌohube. Koyapaꞌi mono bukugu fayahi geꞌahana yaꞌma lamaꞌnaka lu huto hilinamo niꞌibe: Noseꞌna noto minoꞌina bouba gigusatu laꞌmisa nefiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nani yaꞌma huto mehuꞌehinamofihi kaꞌa yataꞌa lu lepiꞌohunamo yaꞌma alihi huto hinagi nanitoga keheli uleꞌale hu nimilabe. ");
INSERT INTO bef_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Maꞌnaka lu nolepube. Enali nani ho lifiꞌohuna bomofihi be tigilana enali ana suhi hite nani nebe netigibe. To ana huto nani nebe tigilana bonaꞌmagi enali yaꞌma noho lifiꞌehina bo Afoꞌnifu be netigibe. ");
INSERT INTO bef_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu ya luto luloto komopaꞌagu sipi keta higo lu hokolo huto lu epiꞌehina: Maꞌnaka lu nolepube. Folagahatiniguti keneꞌi moneuba fatehaꞌnimagihi nani kumu lu epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ya ligo panaꞌalobomagi ai bu gago ai bu gago hite enegekesa loe lugufa yigite luꞌehinamofihi hapaꞌa mekeheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Panaꞌalobo moneꞌa Yesu bita hinaꞌa ai Yesutoga hepito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ya nohigo Pitau kisuma huto obo luto ligo noago lu emiꞌehina: Kai Yesu luꞌehina boꞌmu kiyiꞌafube luto loka hobo. ");
INSERT INTO bef_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ya ligo ana panaꞌuba Yesutoga minomo tubuto loka hoꞌehina: Sipi Bo, fatehakamagihi lu epilina bo kiyiꞌafu nohibe? ");
INSERT INTO bef_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ya ligo kagalo nonaꞌa Yesu lu emiꞌehina: Nani mone beleti noseꞌna tobo sito lito supu nagamilugu i fulu huto emiluna yaꞌma bo nohilibe. Ya luto luloto mone beleti nekisa i fulu huto Yutasi Simoni Isikelioti panaꞌa li emiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Emigo Yutasiu lito noto nohigo anaꞌasi Satau komopaꞌagu tiꞌehina. Ya higo Yesu lu emiꞌehina: Anaꞌina lolo hilubeꞌmu nohata meꞌme huto lolo hubo. ");
INSERT INTO bef_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ya ligo hitalo neminanamagi Yesu lu emiꞌehina ka yaꞌma keheli bati mehiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yutasiu efaha guꞌi kaba huꞌehinagi panaꞌalobomagi enegekesa kehelite yaꞌma noseꞌna li nupa hite nalanaꞌmu Yesu noseꞌna mone hiti buto mina fi letobo lutomofi to mone noseꞌna lito buto enumuhi menina bonaꞌi li epibo, yaꞌma ka lu noemunafi enali yaꞌma enegekesa keheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","To Yutasiu beleti lito anaꞌasi nonuguti leke ho limito buꞌehibe. Metepu ito folugu kana huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutasiu enalitogati leke ho limito nobigo Yesu lu epiꞌehina: Yatai kanaꞌni huto nohigo nani Kokulumaguti limiꞌehina Bomofita nani fana mehaꞌni ahuto hibe bu galabe. Yatai Huꞌmamofihi fana mehaꞌa nanitoga huto hulenogo bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Huꞌmamofihi fana mehaꞌa nanitoga huto nohinogo nani Kokulumaguti limiꞌehina Bomofita enelepilube. To ana suhi huto Huꞌmau fana mehaꞌnimo enelepilinaꞌmu, meleꞌisi ya hilina huto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Oho, panaꞌnimagita. Lenali hiti nani nesi kanasi minotoꞌni maꞌasi atibilube. Lenali nani kumu sa hilete koyapaꞌi Yuta bonaꞌi lu epiꞌohuna: Biluna hepatoga mebilanaꞌmu yaꞌma lenali hiti ana hite anaga mebilabe luto lu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","To yuhufa kaga lu moloꞌohuna ma lu nolepube. Lenali komopatini lenogotinifihi emilo. Nani komopaꞌni lenalitoga lepiꞌohunagi lenali ana hite ai komopaꞌa eminogo ai eminogo hite ya hilo. ");
INSERT INTO bef_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lenali komopatini lenogotinifihi eminogo yege yege bonaꞌmagi Yesuhi panaꞌaloboꞌa nehabe lite lilete kehelilabe. ");
INSERT INTO bef_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu ya ligo Simoni Pitau loka hoꞌehina: Sipi Bo yale, hiyaga bilubeꞌmu nohane? ligo Yesu ma lu emiꞌehina: Biluna hepato mebilataꞌmu yabe. Nani kohe toto bulenogoꞌni alihi nemegeꞌi moloto bilane. ");
INSERT INTO bef_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ya ligo Pitau loka hoꞌehina: Sipi Bo, kai kohe toto buletogo henabe luto nani yatai kemegeꞌi mebilube? Nani yatai kai kumu meleꞌisi fililubeꞌmu nohuto lu nokumube. ");
INSERT INTO bef_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ya ligo Yesu lu emiꞌehina: Ya hifi? Nani kumu fililubeꞌmu lusiga nolapi? Nani maꞌnaka lu nokumube. Etehi foluguꞌi kokole nogo memalalina kana kai yupahi loebe monebe nani kumu menokehelube luto bahane hoto lu epilane, Yesu ya luto lu emiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","To Yesu panaꞌaloboꞌa ka lu epiꞌehina: Komopatinigu koli mehilo. Lenali Huꞌmamofitoga keheli uleꞌale hite to naniꞌnitoga ana hite keheli uleꞌale hilo. ");
INSERT INTO bef_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Ifo muyalo Afoꞌnifihi hepaꞌi niꞌinalo nohi babu luto niꞌinagi nani kohe toto tito hepatini li kuguma hilube. Yanuga li kuguma hu su holotoꞌni i behe hu limito lenali kumu leneleꞌmalube lutoꞌni lenali hiti nani nohunalo minalune. Yaꞌma huto hilinamo meniꞌitita lu hokolo hu leputitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","To nani biluna hapaꞌnimofihi kapo yaꞌma lenali akeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesu ya luto lu epigo Tomasiu lu emiꞌehina: Sipi Bo yale, bilata hepaꞌi mekeheliꞌohuta yaꞌma kapoꞌa hiyaꞌa huto kehelilune? ");
INSERT INTO bef_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ya ligo Yesu lu emiꞌehina: Yaꞌma kapomo naniꞌni nohube. To ka lamanaꞌa hiti nohuna to mino kosaba huseꞌna hiti naniꞌni nohube. Ya nohunagi bonaꞌi moneꞌamagi Afoꞌnifitoga biluneꞌmu nohune lite aku i pebisa ho netete aitoga bi menehetilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lenali nanimomuꞌi kehelite Afoꞌnifi kumu keheliluneꞌmu habe. To ma kanagu lenali bite ai kumu nekehelite to bu negabe. ");
INSERT INTO bef_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ya luto ligo Filipiu lu emiꞌehina: Sipi Bo yale, Afokafihi lelepibo. Lelepiletogo lali keheli baga ito anasiꞌya minalibe. ");
INSERT INTO bef_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ya ligo Yesu lu emiꞌehina: Yatama kanaꞌa nani hiti lenali asagaꞌi mineꞌahanamo nani kumu mekeheliꞌahatafi, ya Filipio? Afokafihi lepibo luto henabe lutobe nolane? Buga. Bonaꞌi moneꞌamagi bu negeꞌehinogomo yaꞌma enali Afoꞌnifi hiti be geꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipio, nani hiti Afoꞌnifi hiti moneka nohuꞌina yamofihi keheli uleꞌale huꞌahatafihe? To ana huto Afoꞌnifu nanitoga i keꞌmoto nominana keheliya iꞌahatafihe? Yaꞌma kaga maꞌasi lu lepiꞌohunana naniꞌni meniꞌigo Afoꞌnifu nanitoga i keꞌmoꞌehinamofihi kagaꞌa lu nolepube. Afoꞌnifu ai liliꞌnaꞌa nonimigo yaꞌma liliꞌna li etoꞌohube, ya luto Yesu panaꞌalobomagihi lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ya luto ma luꞌehina: Nani hiti Afoꞌnifi hiti moneka minoꞌohuꞌinamo to nanitoko i keꞌmoto minoꞌehinamo hiti yaꞌma keheli uleꞌale hilo. Yamofihi keheli uleꞌale mehitemo amuya liliꞌna li huto huꞌohunanamofi kumu lenali nanitoga keheli uleꞌale hu nimilo. ");
INSERT INTO bef_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Lusiga lu nolepube. Bonaꞌi moneꞌamagi nanitoga keheli uleꞌale hu niminogo yaꞌma nani amuya foyaꞌni suhi hite lilanaꞌmu to, maꞌnaka luto mone hiti foyaꞌnimofihi be ligite babu lite lilabe. Henaꞌmube? Nani Afoꞌnifitoga tito minenogoꞌni eneheꞌmenogo babu lite amuya liliꞌnamo lilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","To lenali hena hena nasanaꞌmu nigiꞌnilo lite loka helenogo nani yaꞌma huto hu lepalalube. Afoꞌnifihi panaꞌa nohunagi ya hu lepalalubeꞌmu hugo bonaꞌmagi kehelite Afoꞌnifihi enofoke ka li emilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","To lenali fato fatoꞌnamu nigi hete noloka helenogo yaꞌma huto hu lepalalube. ");
INSERT INTO bef_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Lenali komopatini neniminogo yaꞌma kaga lu moloꞌohunanamo keheli nimilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ya hilenogoꞌni Afoꞌnifitoga Sikalafuꞌi ka lamanaꞌamofihi afoꞌafu ai leneheꞌmalina aiꞌi loka holenogo lepilibe. Yaꞌma Sikalafuꞌi lepilenogo ai hiti lenalitoga minoba minoba hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Noto noto bonaꞌmagi aiꞌi bu megelata to mekehelilata nehite ana Sikalafu enalitoga melimilinaꞌmu yabe. To lenali aiꞌi kehelilata nehabe. Henaꞌmube? Ai lenali hiti moneka minoto komopatinigu huto nohibe. ");
INSERT INTO bef_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","To nanimoya heꞌmi lepololenogoꞌni megusa pana suhi hite meminalabe. Lenali nehanalo aku alube. ");
INSERT INTO bef_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hupamone kanaꞌa minolenogo noto noto bonaꞌmagi bu menegenogo aku lenali bu nagalabe. To nani lito buto nohunagi lenali ana hite mine lite bite minalanagihe. ");
INSERT INTO bef_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yana yupahi huto hulenogo lenali Afoꞌnifitoga i keꞌmaluna yaꞌma kehelilabe. To lenali nanitoga i keꞌmalana to nani lenali hiti minaluna yaꞌma kehelilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","To bonaꞌi moneꞌamagi komopaꞌani nimiꞌahanamagi kaga moloꞌohunana kehelite nemegeꞌi melelata nehabe. Ana komopaꞌani nimiꞌahanamagihi Afoꞌnifu enaliꞌi komopaꞌa epilibe. Nani ana huto yaꞌma bonaꞌmagihi komopaꞌni epito nani hapaꞌni enelepilube. ");
INSERT INTO bef_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu ya luto ligo Yutasiu, fato Yutasi yaꞌma Isikelioti menohina, ai loka hoꞌehina: Sipi Bo yale, henabe luto noto noto bonaꞌi kaiꞌnaka meenelepise lalisigo nolelepine? ");
INSERT INTO bef_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ya ligo Yesu lu emiꞌehina: Bo moneuba komopaꞌa nimito nohutomo kagaꞌnilo megeꞌi malalibe. Afoꞌnifu ana bomofihi komopaꞌa emilibe. Ya huto Afoꞌnifi hiti nani hiti ana bomofitoga buto ai hiti moneka minalune. ");
INSERT INTO bef_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","To bo moneuba komopaꞌa menimilina kagaꞌni megeꞌi memalalibe. Yaꞌma kaga keheliꞌahanaꞌa naniꞌni kagaꞌni meniꞌibe. Noho lifiꞌehina bo Afoꞌnifu, ai kagaꞌa lu nimiꞌehinaꞌa yaꞌma lu nolepunamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nani maꞌasi bilunagi yaꞌma kaga lu nolepuna lenali hiti nominone. ");
INSERT INTO bef_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Afoꞌnifu nigiꞌnilo leneheꞌmalina yaꞌma Sikalafuꞌi lenalitoga ho lifilinaꞌmu yabe. Ai nehetito asaga nasanaꞌmu lenelepiloto to asaga kagaꞌni lu lepiꞌohunaꞌa beto hu lepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","To nani heꞌmi lepoloto fuluna mone lepinogoꞌni yaꞌma fulunaꞌniuba lenalitoga minolata nohibe. Noto noto bonaꞌmagi fulunaꞌa episeꞌna yaꞌma nani melepilubeꞌmu, fatoꞌna lepilubeꞌmu nohube. Lenegekesa yigi yigi mehise to komopatinigu lenelesa linogo koli mehilo. ");
INSERT INTO bef_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Heꞌmi lepalalube luto akuꞌi lenalitoga alube lutomo yaꞌma lenegekesa keheliꞌahana. Lenali komopatini nimiꞌehinogomo Afoꞌnifitoga tilube lutomomuꞌi kehelite lenegelo bilanaꞌmu yabe. Henaꞌmube? Ai amuya hiti nebe ligiꞌehina bo nohinagi leneheꞌmalibe. ");
INSERT INTO bef_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kohe toto yatai kanaꞌagu lu nolepunamofihi alipo yaꞌma kaga huto hulenogo lenali keheli uleꞌale hilabe. ");
INSERT INTO bef_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yatai kanaꞌa hupamone niꞌigo mone kaga melepilunagi asaga noto noto bonaꞌmagihi kaba bo sibi huꞌehinauba oto huto hilibe. Ai neleꞌmo sibina huto babeyafa hilinamofihi amuyaꞌauba nebe meligilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ya huto hilenogo nani komopaꞌni Afoꞌnifihi emiꞌohuna yanamofihi noto noto bonaꞌmagi yaꞌma keheliluneꞌmu habe. Yanaꞌmu Afoꞌnifu kaga lu nimiꞌehina megeꞌi mololata nohube, Yesu ya luto to kaga mone lu epiꞌehina: Lali yatai ho tito ma hepatogati heꞌmito nobune. ");
INSERT INTO bef_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu molo emito ma luto lu epiꞌehina: Nani yaꞌma bai nagaꞌi hapaꞌa lamanaꞌa nohube. To Afoꞌnifu bai nagaꞌi foya afoꞌafu nohibe. ");
INSERT INTO bef_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nanitogati yafa moneuba yaꞌma legeyaꞌa mehalinaꞌa yamofihi laga hu heꞌmilinaꞌmu yabe. To yafa moneꞌmofihi legeyaꞌa helenogo legeyaꞌa silagaꞌi halibe luto noluto sibina hinaꞌa laga hu heꞌmi heꞌmi nohibe. ");
INSERT INTO bef_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","To yaꞌma mono ka kohe toto lu lepiꞌohunauba lenali komopatini gulu gulu ligo mino bati hite nehabe. ");
INSERT INTO bef_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lenali yaꞌma nanitoga ete hepite minalo. Ya hiꞌahanaꞌmu nani lenalitoga buto i hepito minalubeꞌmu hube. Hapaꞌa hiti yahaꞌa hiti i mehepise minoto yahaꞌauba aiꞌasigo niꞌito legeyaꞌa halinaꞌa mone meniꞌibe. Lenali yaꞌma ana suhi hite ete nanitoga i mehepilana ana huto lenalitoga legeyaꞌa mone mehalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Bai nagaꞌmofihi hapaꞌa nani yaꞌma nohube. Lenali yaꞌma letohaꞌa nehabe. Moneꞌa enali nanitoga ete hepite minalana yaꞌma nani ana suhi huto enalitoga buto i hepilenogo enalitoga legeyaꞌa babu luto halinaꞌmu yabe. Lenali yaꞌma nani hiti i mehepise anaꞌina legeyaꞌa lilanaꞌa mone meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lugaꞌamagi enali nanitoga ete i mehepilana yaꞌma i pigilata nohina ya suhi hite gulu gulu bilenogo laga hu heꞌmilubeꞌmu hibe. Hayaꞌa yaꞌma i pigilago logogu laga hite keyelata nehabe. Nanitoga ete i mehepina bonaꞌi enalitoga ana suhi huto hilinamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lenali yaꞌma nani hiti minototi kagaꞌni komopatinigu minalina anaꞌinaꞌmu buka tilana huto hu lepilubeꞌmu hibe. ");
INSERT INTO bef_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lenalitoga legeyaꞌa babu luto helenogo lenali lamaꞌnaka nani bonaꞌni lolo hite minelenogo Afoꞌnifihi fana mehaꞌa yaꞌma sekele mamuꞌa hiti huto hilinaꞌmu yege yege bonaꞌmagi be gelete kehelilabe. ");
INSERT INTO bef_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Afoꞌnifu aiꞌa komopaꞌa nimilata nohibe. Nani ana suhi huto komopaꞌni emilata nohube. Ya hulago lenali komopaꞌni lepilata nohunamo yanamofihi kaba huseꞌnaꞌnigu minalo ");
INSERT INTO bef_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nani Afoꞌnifihi bagaguti kaꞌa kehelito liloto komopaꞌa nimilata nohina yanamofihi kaba huseꞌnaꞌnigu nohunamo niꞌibe. Ana suhi hite nabagaguti kaga kehelite lilete komopaꞌni lepilata nohuna yamofihi kaba huseꞌnaꞌnigu minalabe. ");
INSERT INTO bef_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nani komopaꞌnigu haya noinago komopatinigu ana suko huto haya ilina yauba i futili huto bai toto minalibe luto kaga yaꞌma lu lepi su hoto nominobe. ");
INSERT INTO bef_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yaꞌma luto nolu lepolobe. Komopaꞌni lepilata nohuna ana suko hite lenali komopatini ai eminogo ai eminogo helite bilabe. ");
INSERT INTO bef_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kene moneuba ai gibo laluꞌagi kumu yabe luto minoto lito nohinaꞌaloti heꞌmiloto fililina yaꞌma komopaꞌa epiꞌehinamofihi hapaꞌa huto hilubeꞌmu hibe. Fato suhi komopaꞌa ai epilata nohinamofihi nasana be meligilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lenali kaga nolenelepunalo megeꞌi melelata nehana nalaluꞌnigita yabe luto lilubeꞌmu hube. ");
INSERT INTO bef_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kele kele panaꞌi moneuba kaba boꞌamofihi lolo hu etoto moloto huꞌehina komopaꞌagu kaga niꞌina mekehelinago nani yaꞌma kanalo lenali kumu kele kele panaꞌni yabe luto melilube. Nani yaꞌma Afoꞌnifitogati kaga keheliꞌohuna lu huto huto alu lepi su hoꞌohunamo ninaya yatai lenali kumu nalaluꞌnigita nehabe luto nolube. ");
INSERT INTO bef_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Lenali naniꞌi yaꞌma neleꞌmo eto menehabe. Nani yaꞌma leneleꞌmo eto hugo lenali bite legeyaꞌi li huto hilenogo amuya moloto minoba minoba huto minalibe luto lu lepoloꞌohuna. Ya hilete nani nigiꞌni kehelite anaꞌina henanaꞌmufi Afoꞌnifitoga buka tilanaꞌalo lepilubeꞌmu hibe. ");
INSERT INTO bef_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Komopatini ai eminogo ai eminogo hilabe luto nolu lepolobe. ");
INSERT INTO bef_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Metoga bonaꞌmagi mono ka mekehelise lenali kumu enitaluga logo binogo luba hi epelenogomo lenali yaꞌma lite lenegekesu mehese kehelilabe. Sipi Boti metoga nohigo hapi fite luba heꞌahanamo niꞌibe lite kehelilabe. ");
INSERT INTO bef_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lenali mono ka mekeheliꞌahana bonaꞌmagihi folagahaꞌanigu minalana enali lenalitoga komopaꞌani lepitine. Nani yaꞌma enali folagahaꞌanigu leneleꞌmo eto hugo enali lite melete hiꞌahana yaꞌma lenali heꞌmiꞌahanamo niꞌibe. Yanaꞌmu lenaliꞌi yaꞌma luba ka li lepilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nani kaga mone ma luto lu lepiꞌohunamo yamofihi lenegekesu mehese kehelilo. Kele kele panaꞌuba kaba boꞌauba lolo huto moloto nohina nasana be meligilinaꞌmu yabe. Enali naniꞌi kalanaꞌi mele netelata nehanaya lenali hiti ana hite kalanaꞌi mele lepalaluneꞌmu habe. Nani kagaꞌni kehelite li gu meiꞌahanamo niꞌinagi lenali kagatini ana suhi hite kehelite li gu meiluneꞌmu habe. ");
INSERT INTO bef_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Noho lifiꞌehina bomuꞌi keheli fe meliꞌahana yaꞌmu nani nigiꞌni lenalitoga niꞌinaꞌmu yabe lite ya hi lepalaluneꞌmu habe. ");
INSERT INTO bef_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nani enalitoga limito huto huto kaga lu meepiꞌohunalo niꞌitita enalitoga foipanaꞌani mino meepalatitaꞌmu yabe. To ka foya melilinaꞌmu yabe. Ya huꞌehinaya foipanaꞌani hena hena hite heꞌmilana niꞌibe? ");
INSERT INTO bef_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Moneuba naniꞌi luba ka lu nimilata nohilina Afoꞌnifi hiti ananago huto luba ka lu noemibe. ");
INSERT INTO bef_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nani folagahaꞌanigu fato suhi amuyaꞌa hiti yaꞌma koyapaꞌi bonaꞌmagi li huto mehiꞌahanamofihi li huto hutita enalitoga foipana meminatine. To yaꞌma be gologo bi heꞌmiꞌehite naniꞌi luba ka li nimiba li nimiba nehite Afoꞌnifihi ananago hite luba ka neli etabe. ");
INSERT INTO bef_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ya hilago mono bukugu ka mone ma lite fayahi keyeꞌahana yaꞌma amuya moloto niꞌibe: Enali yaꞌma faꞌmeneꞌmu naniꞌi luba ka li nimiꞌahanamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Afoꞌnifu lolo huto fi hetofa hu lepalalina kamofihi latahaꞌa Sikalafuꞌuba yaꞌma Afoꞌnifitoga nohibe. Aiꞌi ho lufugo Afoꞌnifitogati limito hapaꞌni lu huto hilubeꞌmu hibe. ");
INSERT INTO bef_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lenali yaꞌma foya hapi huꞌohunaguti nani hiti mineme bite mineꞌahanamo niꞌinagihe, lenali hiti hapaꞌnimu ana suko hite li huto hilanaꞌmu yabe, luto Yesu ya luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Alihaꞌa anaꞌina mone lolo hi neepelenogo mono ka heꞌmi lalabe luto kaga yaꞌma kohe toto lu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Enali ya hite mono nohi fi hekini lo lepalalanaꞌmu. To kana mone hupamone hilubeꞌmu lenoho fililabe lite nehinogo Huꞌmamofihi lemehi noemupihe lite lenahalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Enali yaꞌma Afoꞌnifi hiti nani hiti bu leꞌego bati mehise ya suhi lolo hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nani kohe toto kaga yaꞌma lu nolepuna yaꞌma amuya nemelenogo yaꞌma lite lilanaꞌmu: Afotifu koyapaꞌi lu limiꞌehinamo yaꞌma huto hibe lite beto hilabe. Hapi huna kanalo lenali hiti minoto lito hiluta kana yatamalo niꞌigo meleꞌisi lu melepiꞌohunamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yatai yaꞌma noho lifiꞌehina bomofihi nohinaga i behe huto bilubeꞌmu nohugo lenalitogati bo moneuba hiyaga bilubeꞌmu nohane luto noloka mehoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kaga yaꞌma lu nolepugo kekeꞌi luseꞌnamofihi komopatinigu bai notabe. ");
INSERT INTO bef_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nani ka legeyaꞌa lilugi kehelilo. Nani i behe huto tiluna nasanauba anaꞌina lamanaꞌa li huto hu lepilinaꞌmu yabe. Heꞌmi lepoloto metutita leneheꞌmalina bo yaꞌma melimititaꞌmu yabe. Tilotoꞌni yaꞌma ho lifinogo lenalitoga limilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Limiloto metoga bonaꞌmagihi foipanaꞌanimofihi to li lamana hulatanamofihi hapaꞌamu to foipana lepilinamofihi hapaꞌamu ka foya lilatanamofihi hapaꞌamu keheli fe lilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Enali nani kumu keheli uleꞌale menehana foipanamofihi hapaꞌamu linogo kehelilabe. ");
INSERT INTO bef_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Lamananamofihi hapaꞌamu lilenogo ma lite kehelilanaꞌmu yabe, nani Afoꞌnifitoga i behe huto netinogo alihaꞌa moneꞌa hiti be menagalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ka foya lilatanamofihi hapaꞌamu linogo ma lite kehelilanaꞌmu yabe, yaꞌma melugu gihiti bo, Satau foipanaꞌmu ka foya liꞌehinamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kaga lu lepiluna babu luto niꞌinaya yatai meleꞌisi lu lepi su hoꞌehinogoꞌni keta lepesi laligi. ");
INSERT INTO bef_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mono ka lamanaꞌamofihi afoꞌafu fana mehaꞌa hiti Sikalafuꞌuba aiꞌa limiloto lamana kaga komopaꞌagu leneleꞌmoto bilubeꞌmu hibe. Yamofihi aiꞌa ekesa kehelito lu melepilinaꞌa huto niꞌinaya, Huꞌmau luꞌehinaꞌa huto lu lepilinaꞌmu yabe. Ya huloto minoto anaꞌina huto hilinaꞌmu lu lepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ai kaga yaꞌma nanitogati liloto nolenelepinogo fana mehaꞌni liloto nohinogo huto hilubeꞌmu hibe. ");
INSERT INTO bef_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Afoꞌnifitoga anaꞌina ninamofihi nanigo nimi su hoꞌehinamo niꞌibe. Yamofihi Sikalafuꞌuba kaga yaꞌma nanitogati liloto lu lepilubeꞌmu hibe luto alu nolepube. ");
INSERT INTO bef_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Lenali kanaꞌa nesiꞌa neminete naniꞌi be menagaluneꞌmu habe. Yamofihi ifoꞌalo nesiꞌa minete naniꞌi aku bu nagalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ya luto lulago panaꞌalobo lugaꞌamagi enali ma lite li keheli fa keheli nehite liꞌahana: Kaꞌa yaꞌma henanaꞌmu nolibe? Kana mone minete naniꞌi be menagalanaꞌmu yabe. To yamofihi ifoꞌalo nesiꞌa minete bu nagalanaꞌmu yabe. To Afoꞌnifitoga i behe huto tilube luto nolina yaꞌma henaꞌmu nolibe? ");
INSERT INTO bef_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ya lite lilete mone ma lite liꞌahana: Kanaꞌa nesiꞌa yabe luto nolina yaꞌma hiya kanaꞌmu nolibe? Kaga liꞌehina yamofihi hapaꞌa menokehelune. ");
INSERT INTO bef_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lite lilete loka haluneꞌmu nehago Yesu yaꞌma keheli fotogo huloto ma luto lu epiꞌehina: Kanaꞌa nesiꞌa neminete naniꞌi be menagalanaꞌmu to yanamofihi ifoꞌalo nesiꞌa neminete naniꞌi akuꞌi bu nagalanaꞌmu yabe luto luꞌehinaꞌmu lu keheli fa keheli hiꞌahafihe? ");
INSERT INTO bef_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lamaꞌnaka lu lepilugi kehelilo. Lenali yaꞌma yibisu kalasu hite nehinogo melugu bonaꞌi mono ka mekeheliꞌahanaꞌamagi enali enegelo biluneꞌmu habe. Ya nehinogo lenali kekeꞌi lilanaꞌmu yabe. Ya nehinogo komopatini leꞌmo gelehe hinogo babahi hinogo haya ilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aꞌi moneuba yagapanaꞌi ketalina nohinogo hupamone kana kekeꞌi lilibe. Minoto keto ha foloto panaꞌa huto huꞌehinaꞌmu luto gelo bito kekeꞌi luꞌehinaꞌa yamofihi ekesu henogo mekehelilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lenali hiti ana suhi hite yatai kekeꞌi lilana akuꞌi bu lenegenogoꞌni komopatinigu haya ilubeꞌmu hinaꞌa bai talinaꞌmu. Yaꞌma huto hulenogo kene moneuba lenebesilito li meheꞌmilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ana huto hilina kanagu anaꞌinaꞌmu noloka mehalanaꞌmu yabe. Nani lamaꞌnaka lu nolepube. Lenali bonaꞌni nehanamuꞌi Afoꞌnifitoga buka tilana yamofihi nani nigiꞌnilo lepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lenali afehaꞌaga ema mine lite tiꞌahanalo yaꞌma nani nigiꞌni lite nehite anaꞌinaꞌmu buka buka metiꞌahanamo niꞌibe. Komopatinigu haya ilina nasanauba i futili huto bai toto minalibe lite buka tite liluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","To kaga yaꞌma lu lepiba lepiba humo buto minoꞌohunamofihi bame kaꞌa lu lepiꞌohuna. Kana mone tupa hilubeꞌmu hibe yamofihi kaꞌa bame ka lepila aku suguna ka lu melepilunaꞌmu Afoꞌnifihi hapaꞌamu lu hokolo huto lu lepilubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Kanaꞌa ya yupahi nigiꞌni lite minete buka tilanaꞌmu yabe. Nani Afoꞌnifitogati limiꞌohunamofihi kaꞌa keheliya ilete komopatini nimiꞌahana yaꞌmu Afoꞌnifu aiꞌa komopaꞌa nolepinamo niꞌibe. Yamofihi lenali kumu luto Afoꞌnifitoga buka ti lepalalube luto yaꞌma lu menolepugi aiꞌa komopaꞌa nolepinagihe. ");
INSERT INTO bef_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nani Afoꞌnifihi heꞌmi etoto metoga limiꞌohuna. To yaꞌma hepaꞌi heꞌmito Afoꞌnifitoga tilubeꞌmu hube. ");
INSERT INTO bef_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ya luto ligo panaꞌalobomagi ma lite lu emiꞌahana: Yatai bame ka menolane. Lu hokolo hu letoꞌahatamo lu nolimine. ");
INSERT INTO bef_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yaꞌma yataꞌisi kai kumu yaꞌma luto nokehelune. Bonaꞌmagi enali yataꞌa kaga lu hokolo hu ketalana meniꞌibe. Kaika silaga nasanaꞌmu keheli su hoꞌahana. Kai Huꞌmamofitogati limiꞌahata yanaꞌmu keheli amuya moloꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ya lite linogo Yesu ma luto lu epiꞌehina: Lenali yataꞌisi keheli amuya nemalafihe? ");
INSERT INTO bef_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kana mone hupamone hilubeꞌmu huto ana kanaꞌa maꞌasi aꞌnohinogo lenali heꞌmi netete tili tele hite hepatiniga bi su haluneꞌmu nehabe. Bilenogo naniꞌnisigo minalube. To Afoꞌnifi hiti minaluꞌibeꞌmu nohuꞌibe. Yamofihi naniꞌnigo meminalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nani fulunaꞌniuba lenalitoga minalibe luto kaga yaꞌma lu nolepube. Lenali yaꞌma metoga kalanaꞌi nemele lepelenogo lenipagu sibina mehino. Naniꞌni yamofihi ma metoga nasanamofihi abe ligi su holoto nohube. ");
INSERT INTO bef_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ai kaga lu su holoto kokulumagu bu go saga huto ma luto Huꞌmamofihi lu emiꞌehina: Afoꞌnigabe. Kanaꞌa tupa nohibe. Kai naniꞌi panakamofihi fana mehaꞌa li huto huto mololatogo panakamofita nani kai fana mehaka li huto hilube. ");
INSERT INTO bef_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kai noto noto bonaꞌmagihi afoꞌanifita noho lifiꞌahata bomofita nanitoga eneleꞌmo moloꞌahata kai mino kosaba huseꞌna epilube luto luꞌahatamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mino kosaba huseꞌnamofihi hapaꞌa ma huto niꞌibe, Huꞌmau lamanaꞌa monekoꞌi kai hapaka to noho lifiꞌahata panaka Yesu Kilisito nani hapaꞌni keheliꞌehinogo mino kosaba huseꞌnaka yamofihi huto hu epilibe. ");
INSERT INTO bef_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","To foya nimiꞌahata li su nohago metoga kaika fana mehaka huto hulata nohigo enelepiꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ke, Afoꞌniga, meꞌi huto mehuꞌehigo kai hiti kokuluma fana mehaꞌni hiti minoꞌohuna, ana suhi huto yatai kubulo nohugo akuꞌi fana mehaka nimitogo lito minalube luto nolube. ");
INSERT INTO bef_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Melugu bonatogati moneꞌa nanitoga eneleꞌmo moloꞌahata enalitoga fuluna ka amuya moloto lu epiꞌohunamo niꞌibe. Kai nagaka nanitoga eneleꞌmo malatogo enali kagaka kehelite kemegeꞌi meleꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","To nanitoga nasana niꞌina yaꞌma kaitogatiko niꞌibe lite akeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","To kaga lu moloto nimiꞌahata yaꞌma lu epugo yaloꞌi akeheli su heꞌahabe. To kaika noho lifitogo kaitogati limiꞌohunaꞌa yaꞌma keheli uleꞌale hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nani enali kumu yabe luto kaitoga koloka nohobe. Melugu bonaꞌi mono ka mekeheliꞌahanamagi enali kumu menolube. Nimiꞌahata enaliꞌi kai nagaka nehanagihe luto enali kumu koloka nohobe. ");
INSERT INTO bef_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","To nani nagaꞌi yaꞌma kaika nagaꞌi nehabe. Kai nagaꞌi yaꞌma nani nagaꞌi nehabe. To komopaꞌanitu hite melete nehana nasanauba nani fana mehenaꞌni li huto hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nani metoga minaluna kanaꞌni asu nohabe. Kaitoga molo emite nehinogo nani kaitoga meleꞌisi tilubeꞌmu nohugo enali melugu minalanaꞌmu. Ke, hetofa Afoꞌniga, kai ka lamanaꞌamofihi kigika nimilatogo epiꞌohunamofihi kaika eneleꞌmo hetofa huꞌehitogo yaꞌma kagamofihi kaba huseꞌnakagu minalabe. Ya hilete leꞌali komopatiꞌa hepito ninamofihi suhi hite enali komopaꞌani moneko hepito minalube. ");
INSERT INTO bef_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Enali hiti minota yupahi yaꞌma nanitoga eneleꞌmo moloꞌahata bonaꞌi yaꞌma kaika kigika nimiꞌahata yamofihi amuyaꞌauba yaꞌma kagakaloti eneheꞌmoto nohugo yamofihi kaba huseꞌnakagu mineꞌahana. Ya hilago kaba hu epoloto nohugo haya mekeleꞌahana yabe. To mono bukugu keyeꞌahanamofihi kaga mone uleꞌale hilibe luto logo hepaꞌmofihi nasana bo, aiꞌa monekoꞌisi yaꞌma fakene huto huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yaꞌma kaitoga bilubeꞌmu nohuto yaꞌma metoga enipagu haya ilinamofihi nasanauba i tili tele huto bai toto minalibe luto melugu minoto ma luto lu nokumube. ");
INSERT INTO bef_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nani kaga lu moloꞌahata lu epiꞌohunamo niꞌibe. Nani metoga nasana menohugo enali ana hite metoga nagaꞌi menehabe. Metoga nasana bonaꞌmagi enali luba enehelata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kaika nani bonaꞌni eneleꞌmoto kokulumalugu tilane luto menolube. Melugu minenogo bo foipaꞌa Satau luba huto enoho lalibe luto yaꞌma kaba hu epalalane luto lu nokumube. ");
INSERT INTO bef_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ya huꞌehinaꞌmu nani melugu nagaꞌi menohube. To ana hite enali melugu nagaꞌi menehabe. ");
INSERT INTO bef_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ka lamanaꞌa yaꞌma komopaꞌanigu limilinaꞌa yamofitu eneleꞌmo eto hubo. Kai kaka yaꞌma lamanaꞌa niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kaika yaꞌma metoga liliꞌna ka lu netoto noho lifitogo ana huto metoga enali liliꞌna ka lu epito enoho lifito li epi su hoꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Enali ka lamanaꞌauba komopaꞌanigu limiloto eneleꞌmo eto hulenogo enali bonakamagi huto hilana yanaꞌmu naniꞌni komopaꞌni nugufaꞌni leꞌmo eto huto nomolobe. ");
INSERT INTO bef_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","To enali kumuko menolube. Bonaꞌi lugaꞌamagi panaꞌaloboꞌnimagihi ka lamanaꞌamu megeꞌi melelata hite nanitoga keheli uleꞌale hilana bonaꞌi enali kumu kaitoga koloka nohobe. ");
INSERT INTO bef_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Komopaꞌani hepito minela minela hite minalabe luto lu nokumube. Ke, Afoꞌniga. Kai to nani hiti minetogo nani to kai hiti mino mone huto minaluꞌibe. To enali ana hite leꞌalitoga mine melenogo mino mone huto minalune. Ya hilenogo melugu bonaꞌi kaika noho lifitogo limiꞌohuna yamofihi keheli uleꞌale hilabe. ");
INSERT INTO bef_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leꞌali komopatiꞌa moneko legege huto niꞌibe. Ana huto enali komopaꞌani moneko legege hinogo minalabe luto sekele mamuꞌa hiti fana mehaka nimiꞌahata yaꞌma ana huto epiꞌohube. ");
INSERT INTO bef_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nani nemehi epugo to enali enemehi nimilago enali komopaꞌanitu mu tifite moneko lolo hite minalabe. Ya hilete nehinogo melugu bonaꞌmagi enali noho lifitogo limiꞌohunamofihi keheliya ilabe. To komopaka nanitoga mololata nohata nasanauba panaꞌaloboꞌni enalitoga ana huto komopaka mololata yanamofihi melugu bonaꞌmagi be gelete keheliya ilabe. ");
INSERT INTO bef_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ke, Afoꞌniga. Nanitoga eneleꞌmo moloꞌahata bonaꞌi yaꞌma enali nani minalunaga mine malalabe luto lu nokumube. Yalo nehite yaꞌma meꞌi huto mehuꞌehigo komopaka nanitoga moloꞌahata kokulumagu fana mehaꞌa molo netoꞌahatamofihi bu go fe lilabe. ");
INSERT INTO bef_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ke, hetofa Afoꞌniga. Melugu bonaꞌmagi enali kai hapakamofihi keheliya meiꞌahana. Naniꞌnisigo yaꞌma akeheliꞌohube. To panaꞌaloboꞌnimagi enali kaika noho lifitogo limiꞌohunamofihi akeheliꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nani hapaka lu hokolo huto lu epiꞌohuna to lu epito minalunaꞌmu yabe. To komopaka nonimitanauba enalitoga minalibe luto nani nemehaꞌauba ana huto enalitoga minenogo nani ana huto enalitoga mino hepito minalube luto yaꞌma nohuna yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yana kaga lu epito Yesu to panaꞌaloboꞌa hiti hepaluguti heꞌmite kohoꞌya mone giꞌamofihi Kitoloni yabe analo limite tite yafa noseꞌna foya monelugu enali tite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","To Yutasiu, Yesuhi fatehaꞌamagihi enelepilina bouba, ai ana foya hepaꞌmo keheliꞌehina. Yesugi panaꞌalobomagi anaga li nupa hilata nehana foyamo niꞌina keheliꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ya huto kehelito ai sipi mono noto kaba bonaꞌmagi to Felosi bonaꞌmagi enali gimi bonaꞌi lugaꞌa to mono noto liliꞌna bonaꞌi lugaꞌa hiti enoho lifigo Yutasiu eneleꞌmoto buꞌehina. Enali emitaꞌi lite to kunufa libiꞌmo hiti lamu hiti ligi besa lelite kapogu melete foyalo bilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","To Yesu yataꞌa yaꞌma asaga huto hu epalalinaꞌmu akehelito gimi bomagi nehetigo ai nehanalo kohe toto buto lu epiꞌehina: Kiyiꞌafi kumu sa nehabe? ");
INSERT INTO bef_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ya luto enali lu emiꞌahana: Nasalete hepato bo, Yesu yabe, nelana bomo lite lago: Nani ana bo nohube, Yesu luꞌehina. Yaꞌma gimi bomagi nehanalo Yutasiu Yesuhi fatehaꞌamagihi enelepise bo, ai hiti enalitoga moneko ho tito minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu ana bo nohube luto lu epigo enali topa hete enemegesagati bite ho kete keꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Keꞌahago Yesu aku enoloka hoꞌehina: Kiyiꞌafihi sa sa nehabe? luto ligo enali: Yesu yaꞌma Nasalete bo yabe, lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu lu epiꞌehina: Nani alu lepi su hoto ana bo nohube luto noluna. Nani kumu sa nehanaya ma panaꞌaloboꞌni nehanaya heꞌmi epelenogo bino. ");
INSERT INTO bef_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ana kagaꞌa koyapaꞌi lu moloꞌehina: Afoꞌniga, asaga panaꞌni nimiꞌahataguti bo moneꞌmofihi meminigiꞌehina yabe luto luꞌehina. Yana kaga huto hu su hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","To Yesu lu noepigo Simoni Pitau yatama emita mone yahaꞌalo minago ai li saga huto sipi mono noto kaba bomofihi koko panaꞌa nohigo ko kese kese igo ekesaꞌa mone kegiꞌa i hapati heꞌmiꞌehina. Ana bomofihi giꞌa Malakasi yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Laga higo Yesu Pitahi lu emiꞌehina: Heꞌmibo. Emitaka nohaꞌagu aku li molobo. Menokehelipi? Yaꞌma Afoꞌnifu nagabu gi netalina ekesa nagamiꞌi suhi huto nalubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","To gimi bomagi hiti to kaba boꞌaniuba Yesuhi nagaꞌi emite to Yuta gimi bonaꞌi hiti leꞌmete bite ");
INSERT INTO bef_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sipi mono bo giꞌa Anasa nohinalo nehetiꞌahana. Yaꞌma kufugu mone sipi mono noto bo giꞌa Kaiyafasi yabe, ai mono nopo kaba huse to Anasa ai yamiꞌafu nohibe. ");
INSERT INTO bef_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ana bo, Kaiyafasi koyapaꞌi sipi mono nonugu li nupa hiꞌahanamagihi bagaguti lu epiꞌehina: Henaꞌmugope lali asaga nagatiloti bo monekoꞌisi ho fili letalinaꞌmu bati huto yabe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Enali Yesuhi leꞌmete nebago Simoni Pitau to panaꞌalobo moneuba megesaꞌagu meleꞌahaꞌina. To sipi mono noto kaba bouba ana panaꞌa keheliꞌohuto Yesu hiti ai hiti nebaꞌigo nohaꞌamofihi nosipehaꞌaga tibo ligo Yesu hiti tiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tiꞌahaꞌigo Pitau fegutoga kasihaꞌalo minoꞌehibe. Yaꞌma Yesuhi panaꞌa sipi mono noto kaba bouba keheli bati huꞌehina panaꞌuba ai i behe huto Pita fegutoga nohinalo buto palalaꞌi moneuba kasihaꞌalo kaba hulata nohinamofihi lu emiꞌehina: Ma bo bati huto leꞌmoto nonugu tiluꞌibe luto Pitahi leꞌmoto tiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ana palalaꞌuba Yesutoga bu go saga huto Pitahi lu emiꞌehina: Miya bomofihi panaꞌa mone nohapi menohane? luto ligo: Oꞌe, nanimoya menohube, luto Pitau luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ana folugu yasi noligo koko panaꞌmagi hiti to gimi bomagi hiti logo mone gete lota bata hite nehago Pitau enalitoga buto ana logolugu ho tito lota huto yalo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","To sipi mono kaba bouba Yesuhi megeꞌi meleꞌahana boꞌamofi hiti to kagaꞌa enelepise nasanaꞌmu loka hoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Loka hago Yesu lu emiꞌehina: Yege yege yupahi nani kagaꞌni asaga boanaꞌmagihi lu epilata nohuto ya nasanamofihi fala mekiꞌohuna. To Yuta bonaꞌi asaga li gehesa mono nonugufi to sipi mono nonugufi analo kaga lu epito nohuto suguna kaga lu meepiꞌohuna. ");
INSERT INTO bef_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yaꞌmu henabe luto negeꞌnoka nohane? Kagaꞌni kehelilata nehana boanaꞌmagihi enoloka hobo. Enali kaga li epiꞌohunanamofihi keheli bati hiꞌahanago enegeꞌnoka hobo. ");
INSERT INTO bef_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu ya luto lu emigo gimi bo moneuba yatu baga hapaꞌalo ito lu emiꞌehina: Ma bo sipi mono noto kaba boꞌmu nohigo henabe luto yaꞌma kaga lu noemine? Kelesaka menolifihe? ");
INSERT INTO bef_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ya ligo Yesu kaꞌalo nonaꞌa lu emiꞌehina: Nani bahane hoꞌohuna ka niꞌinogomo mana bonaꞌmagihi enubuꞌanilo ana kagaꞌni lu hokolo huto epibo. To nani ka luꞌohunanamofihi lamaꞌnaka niꞌinogomo henabe luto nohoꞌahane? ");
INSERT INTO bef_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Analoꞌi Yesuhi nagaꞌi emiꞌahanaꞌa Anasau sipi mono noto kaba bo Kaiyafasitoga ho lifiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","To Pitau logo lota huto nohigo bonaꞌi lugaꞌamagi lu emiꞌahana: Miya bo, kai panaꞌa nohapihe? nelago Pitau bahane hoto lu epiꞌehina: Oꞌe, panaꞌa menohube. ");
INSERT INTO bef_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","To ya noligo sipi mono noto bomofihi koko panaꞌauba Pitau bonaꞌamofihi ekesa laga hu etoꞌehinaꞌa ai loka hoꞌehina; Ana foyagu Yesu minoꞌehinalo kai hiti minoꞌahatamo bu kogoꞌohunamo niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Loka hago Pitau luꞌehina: Oꞌe, luto bahane hago anaꞌasi fegutoga kokole moneuba nogo moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","To etehi foluguꞌi enali Kaiyafasihi nohaꞌaguti heꞌmite Yesuhi sipi gamani bomofihi nohaꞌalo leꞌmete biꞌahana. Yuta bonaꞌmagi ana nohaꞌagu metiꞌahana. Henaꞌmube? Enali Pasa noseꞌna nalana kana leba tago Yuta bonaꞌmagi fegutoga bonaꞌi li gehesa mehilune lite lugufati kolota kolota hu leto lalibe lite ana nonuga metiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Metiꞌahanago Pailatiu fegutoga nehanalo limito lu epiꞌehina: Ma boya, henana fisa noi etabe? ");
INSERT INTO bef_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ya ligo enali ka nonaꞌalo lu emiꞌahana: Ma bouba foipa meliꞌehinagi kaitoga leꞌmoto meoꞌohunagihe, foipana meliꞌehitita kaitoga leꞌmoto meotitaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ya lago Pailatiu lu epiꞌehina: Lenali leꞌmete bite keya katini ninaya ka foya yanatu kaꞌa loko hilata hilo, lenalitini yabe. Ya ligo Yuta bonaꞌmagi li emiꞌahana: Oꞌe, lali keya kaguti mone kaga bonaꞌi mone malipu yafalo ho mefilibo luꞌehinagi leꞌmoto oꞌohuta. ");
INSERT INTO bef_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yaꞌma kaga liꞌahananamomuꞌi koyapaꞌi Yesu ana yafalo filinamofihi hapaꞌa panaꞌaloboꞌa enelepiꞌehina ka ya suhi kagaꞌani niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","To Pailatiu i behe huto yaꞌma gamani nonugu tito Yesuhi kehe igo ago loka hoꞌehina: Kai Yuta bonaꞌmagihi gihiti bo nohapihe? ");
INSERT INTO bef_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ya ligo Yesu ka nonaꞌalo lu emiꞌehina: Yaꞌma noloka hoꞌahataꞌmu kaika kekesaguti keheliꞌahatafi fato bonaꞌmagi nani kumu lu kimiꞌahana yabe? ");
INSERT INTO bef_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ya luto ligo Pailatiu lu emiꞌehina: Nani Yuta nagaluguti bo menohube. Kaika bonaꞌi to sipi mono bonaꞌani enali nanitoga keleꞌmete eꞌahanamo niꞌinaya, kaibe, henana huꞌahatabe? ");
INSERT INTO bef_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ya ligo Yesu lu emiꞌehina: Nani kapogu kaba huseꞌnaꞌni ma melugu meniꞌibe. Nani kapogu kaba huseꞌnaꞌni ma melugu niꞌitita panaꞌaloboꞌnimagi nani kumu naga i lalibe lite Yuta bonaꞌi luba hilete nagaꞌi menimititaꞌmu yabe. Oꞌe, nani kaba huseꞌna ma melugu huto mehuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ya ligo Pailatiu loka hoꞌehina: Kai kigihiti bo nohane ya hifi? luto ligo Yesu luꞌehina: Oꞌyo, kigihiti bo nohane luto lusiga nolane. To itoꞌnifu neketoꞌehinaꞌmu to huto huꞌohunaꞌmu ma melugu ka lamanaꞌamu yaꞌma lu yege haluta yaꞌma nasanaꞌmuko oꞌohunagi kehelilabe. To bonaꞌi ka lamanaꞌalo megeꞌi melete nehanamagi nani kagaꞌni lu episeꞌnamofihi akehelilata nehabe. ");
INSERT INTO bef_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ya luto noligo ai loka hoꞌehina: To yaꞌma ka lamanaꞌa henana niꞌibe? Pailatiu ya luꞌehina yabe. Analo Pailatiu Yuta bonaꞌi fegutoga nehanalo buto lu epiꞌehina: Meya boya foipana meliꞌehinago mone fakupa ka melu etoꞌohunagihe. ");
INSERT INTO bef_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","To asaga Pasa noseꞌna nalata kanaꞌagu mone hapaꞌa niꞌigi lenali kumu akuꞌi nagaꞌi meleꞌahana bonaꞌi monekoꞌisimofihi gulu hago bilina. Ya huto ma Yuta bomofihi gihiti bo nohigo gulu ho lepelenogo bilibe, bati huto niꞌifihe? luto Pailatiu ya luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ya ligo enali nogoꞌa felana melete liꞌahana: Oꞌe, aiꞌa ya mehubo. Lali Balabasihi gulu ho etobo. Lite liꞌahana. Yaꞌma bo Balabasiu koyapaꞌi luba huto gumina lilata bo nagaꞌi emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","To lite nehago Pailatiu kehelito Yesuhi leꞌmoto buto gimi bonaꞌi naga osatu biyigiloto ho etalo luto ligo enali ho eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","To gimi bomagi Yesuhi latahaꞌalo ufehaꞌa hiti nagaꞌi hesete kofi etete to okoho nakuꞌi mone li hepi eteꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ya hilete Yesuhi gigusaꞌalo lahupa nohi fite li emiꞌahana: Oho, Yuta bonaꞌmagihi kigihiti bonaꞌanise, lite yokoloꞌna ka lu emite bite enayatu heꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ya nehite minago Pailatiu i behe huto fegutoga buto Yuta bonaꞌi li nupa nehanalo kaga mone hiti lu epiꞌehina: Bu galo, nani loka ho etoba ho etoba nohuto foipanaꞌa mone sa nohugo li sibina mehuꞌehinagi lenalitoga leꞌmoto ago bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ya luto ligo Yesu latahaꞌalo ufehaꞌa hiti nagaꞌi heseꞌahanaya to okoho nakuꞌi hepi eteꞌahanaya ai fegutoga nobigo Pailatiu lu epiꞌehina: Ma botinise, bu galo, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","To sipi mono noto kaba bonaꞌi hiti to gimi bonaꞌi hiti Yesuhi bu gete nogoꞌani sipiꞌa liꞌahana: Yafalo ho filibo. Yafalo ho filibo. Ya lite lago Pailatiu lu epiꞌehina: Lenali leꞌmete malipu yafalo ho fililo. Yaꞌma nasanaꞌmu lenali foyatini yabe. Nani foipanaꞌa bu megoꞌohunaꞌmu luto hetofa bo nohinaya henana fisa i etalube? ");
INSERT INTO bef_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","To Yuta bonaꞌmagi ka nonaꞌalo lu emiꞌahana: Ai miya bo Huꞌmamofihi panaꞌa nohube luꞌehina yanaꞌmu ai hiti Huꞌmamofi hiti monekoꞌna nohuꞌibe nolina yanaꞌmu ho fililibe. Lali keya kaguti ya luto nolibe. ");
INSERT INTO bef_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ya lite liꞌahago Pailatiu ana kagaꞌani kehelito koli gofa huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ai Yesuhi leꞌmoto akuꞌi gamani nohaꞌanugu tito loka hoꞌehina: Kai kapoka hiyaꞌa niꞌinaꞌmu? Ya ligo Yesu legeso huto ka lu meemise minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailatiu luꞌehibe: Kaga meluse nohapi, ya? Malipu yafalo ho filibo lutofi gulu ho ketolenogo bilane lutoꞌni amuyana nanitoga niꞌibe. Menokehelipihe? Amuya bo hiti nohube. ");
INSERT INTO bef_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ka nonaꞌalo lu emiꞌehina: Kai amuya hiti bo nohapi? Afoꞌnifu yana amuyanaka kimiꞌehina niꞌibe. Aiꞌasigo kaba hu netago nahalataꞌmufi gulu ho netalataꞌmu kaika meniꞌibe. Miya bouba lu laga menohigo to yaꞌma bouba kayanugu neleꞌmo moloꞌehina bo aiꞌa foipa nasanaꞌmu kebe ligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesu ya noligo Pailatiu kehelito ekesa yigi yigi huto koli gofana huꞌehina. Ai ekesa kehelito gulu ho etalinaꞌmu aku Yuta bonaꞌmagi hekele lite lu emiꞌahana: Kai gulu ho etoletogo yaꞌma sipi gihiti bo, Sisau, Lomu hepato nomina bo ai hiti kalalukaleꞌi menehaꞌibe. Bonaꞌi moneuba nani sipi gihiti bo nohube lilina yaꞌma Sisahi fatehaꞌa lolo nohibe, lite liꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ya nelago Pailatiu kagaꞌani kehelito Yesuhi fegutoga leꞌmoto limito kagamofihi loko hilata hepato mone kefa hisalo minoꞌehina. Anaga babu efa meleꞌahanalo Hibulu kaluguti Gabata yabe nelana yalo minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","To Pasa noseꞌna nalata kana mone yege meoꞌehigo fuligahi nohigo Pailatiu Yuta bonaꞌi lu epiꞌehina: Bu galo. Ma bo lenali gihiti botini nohibe. ");
INSERT INTO bef_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ya noligo enali nogoꞌani sipiꞌa lu emiꞌahana: Ho filibo. Ho filibo. Malipu yafalo ho filibo. Ya lago Pailatiu enoloka hoꞌehina: Gihiti botini yafalo ho lepalalufihe? luto ligo yaꞌma sipi mono noto kaba bomagi lu emiꞌahana: Lali ligihiti bo, Sisa aiꞌasigo nohina. ");
INSERT INTO bef_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ya lite nelago Pailatiu kagaꞌanilo keheli epito Yesuhi malipu yafalo ho fililabe luto enayanugu leꞌmo moloꞌehina yabe. Enali Yesuhi leꞌmete biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","To Yesu ai malipu yafaꞌalo kofito nobigo enali hepatogati heꞌmite mone lataha felisaꞌa hepato bite nehetiꞌahana. Yana hepaꞌi Hibulu kaluguti Gologota yabe nelana. ");
INSERT INTO bef_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","To analoꞌi enali Yesuhi malipu yafalo nilitu he etelete melugu ana yafamo li saga hite fiꞌahana. To enali bo loemo ana hite yafalo hete Yesuhi yafaꞌalo luga luga melugu fiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ya hiꞌahago Pailatiu mone keyaꞌa lolo huto ma fayahi koyoꞌehina: Yesu Nasalete Bo Yuta Bonaꞌmagihi Enigihiti Bo Yabe. Ana fayahi koyoꞌehinana yafa latahaꞌalo ifoga meleꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Meleꞌahago yaꞌma Yesuhi malipu yafalo nili heꞌahanaga Yelusale hepato lebatoꞌi niꞌigo Yuta bonaꞌi babu lite ete ana fayahi koyoꞌehinanamo bu gelete leka seꞌahana. Ana fayapo kaꞌa loegi monegi ma niꞌina, Hibulu ka, Lomu ka, Giliki ka koyoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sipi Yuta bo, monoꞌi kaba hilata nehanamagi Pailatihi lu emiꞌahana: Yuta bonaꞌmagihi enigihiti bo koyoꞌahatamo melebesigo bati mehuꞌehinagi heꞌmibo. Aku mone hiti koyoto: Ma bouba nani Yuta bonaꞌmagihi enigihiti bo nohube luꞌehinanamo yaꞌma akoyobo. ");
INSERT INTO bef_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Enali ya lite lu emigo Pailatiu ka nonaꞌalo lu epiꞌehina: Nani koyoꞌohunanamomuꞌi koyo su henogoꞌnimo minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","To gimi bomagi Yesu malipu yafalo nili nekatu heteꞌani gu kataꞌa lite guna ite loebe loebe meleꞌahago gimi bonaꞌi moneꞌisi moneꞌisi lilube lite liꞌahana. To Yesuhi yatama nakuꞌa aiꞌa li mehetiꞌehina kata hetofana niꞌibe lite, ");
INSERT INTO bef_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","gimi bomagi kaga ai lu emigo ai lu emigo liꞌahana: Ma kata loko hiluneꞌmu pekene mehiluta kiyiꞌafu lilibe lutoti kati supo hite liꞌahana. Yana hite hiꞌahanaꞌmu koyapaꞌi mono bukugu fayahi geꞌahana. Enali kataꞌni guna ite moneko monekoꞌisi lite to nakuꞌnimofihi kati suhi hite liꞌahana. Yaꞌma kagaꞌmu ana huto huto huꞌehina. Gimi bomagi yaꞌma kataꞌa kumu ya hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","To Yesu malipu yafaꞌalo nekisaꞌaga itoꞌafu ho tito minoꞌehina. To ana hite bo moneꞌmofihi giꞌa Kolopasi, aiꞌi lihaꞌa Maliagi to Magatala hepato aꞌi hiti, Maliagi enaliya nehana. ");
INSERT INTO bef_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Enali ya minete nehago Yesu itoꞌafi hiti to bita hinaꞌa koko panaꞌa hiti bu etogoto itoꞌafihi lu emiꞌehina: Ma aꞌise, muya bo panakamo nohibe, luto ");
INSERT INTO bef_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","to ana koko panaꞌamofihi lu emiꞌehina: Ma aꞌi, itokafu nohibe, luto luꞌehina. To ya luꞌehigo ana koko panaꞌauba itoꞌafihi nohaꞌaluga leꞌmoto kaba hu etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","To Yesu liliꞌnamofihi nasanaꞌmu baga iꞌehina akehelito koyapaꞌi mono fayahi keyeꞌahana kagaꞌa huto hilinagi ai luꞌehina: Nani nagamiꞌi naluna nipaꞌni nohibe. ");
INSERT INTO bef_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ya luto ligo analo mone bai nagamiꞌi kopogu niꞌigo bonaꞌmagi heletuyaꞌa legitana lito yafa haya hisope yabe nelana yafalo moloto li saga hite melete emiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ya li emigo Yesu bili tuto noloto luꞌehina: Nani liliꞌna asu habe, luto ligo latahaꞌa bu go lipito filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","To Yuta bonaꞌmagi Pailatihi loka hoꞌehina: Malipu yafalo heꞌahanamofihi gigusaꞌani li gofa hu epalaluneꞌmu yafaloti li heꞌmilune. Ya litemo henaꞌmube? Gigusaꞌani li gofa hilenogo meleꞌisi fililabe. To Yuta bonaꞌmagihi filiꞌehina bonaꞌmofihi fuli yupapogu malipu yafalo meminalinaꞌmu yabe nelana yaꞌmu gufaꞌani li heꞌmi epalalune lite Pailatihi anana loka heꞌahana. Yaꞌma heꞌahana yupahi falate yagi to ana fuli yupahi monoꞌi leba talinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ya lite liꞌahago Pailatiu lu laga mehuꞌehigo gimi bonaꞌi lugaꞌamagihi enoho lifigo enali bite Yesu hiti to gumina lise bomaleꞌmofi hiti eteheꞌahanalo nehetite moneꞌmofihi gigusaꞌa hete li gofa hite to mone lugaꞌalo bite ana huto li gofa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","To Yesuhi malipu yafalo bilete ai afili su hoꞌehinaya enali bu gete gigusaꞌa li gofa mehiꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ya mehiꞌahago gimi bo moneuba heni biꞌehina osahi lito Yesuhi fatipa fi laga huꞌehibe. Ya fi etoꞌehigo golapo hiti nagamiꞌi hiti anaꞌasi fatipaguti limiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma fayapo nogana bouba yanamofihi nasana abu goꞌehina yabe. To lali maꞌnaka luꞌehinamofihi keheliya iꞌunogo to ai hiti lusiga lulata nohina akeheliꞌehigo yanaꞌmu lenali Yesu kumu keheli uleꞌale hite agoya hu emilabe. ");
INSERT INTO bef_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bonaꞌmagi Yesuhi yaꞌma asagaꞌi hi eteꞌahana koyapaꞌi mono bukugu fayahi keyeꞌahanaꞌmu ana huto huꞌehina: Felisaꞌa monekoꞌisi li gofa mehi etalabe, koyoꞌehinana hiti ");
INSERT INTO bef_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","To mone hiti keyeꞌahana niꞌina: Boanaꞌmagi fi eteꞌahana bomofihi bu galabe. ");
INSERT INTO bef_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","To alipo bo moneuba giꞌa Yosefe yabe, Alimatia hepato bo ai Pailatitoga buto Yesuhi gufaꞌamo lilubeꞌmu keligu halube luto loka hoꞌehina. Yaꞌma Yosefeu Yesu megeꞌi moloꞌehina bo to Yuta bonaꞌmagi kumu koli nohuto legeso huꞌehina. Ai loka hago Pailatiu lu emiꞌehina: Oꞌyo, alibo ligo Yosefeu buto yafaloti Yesuhi gufaꞌa li heꞌmito moloꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","To bo mone hiti, giꞌa Nikotimasi ai koyapaꞌi mone foluguꞌi buto kaga liꞌahaꞌina yana bouba tu kifina fato fatoꞌi giꞌa mea to aloe yabe yaꞌma babu li loloba huto yanamofihi lito buto Yosefeu hiti malipulo biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Etali bite nehetite Yesuhi gufaꞌa yafaloti leꞌme heꞌmite katatuꞌi sa gite tu kifina hiti melege figite sa giꞌahaꞌina. Etali ya Yuta bonaꞌmagihi hapaꞌani ana hite filiꞌehina bonaꞌmofihi keligu melelata yaꞌma etali ana suhi hite sa giꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","To yaꞌma hepaꞌi bonaꞌmagihi Yesuhi ho filiꞌahanaga mone noseꞌna foya lebatoꞌisi ninaya to analo efaha muliꞌi mone niꞌigo koyapaꞌi filiꞌahana bonaꞌi memeleꞌahanagu meleꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","To ana muliꞌmofihi fotoꞌi meniꞌigo to Yuta bonaꞌmagihi fuli yupahi maꞌasi huto hilinaꞌmu etali meleꞌisi Yesuhi gufaꞌa ana mulilugu malaꞌigo koꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","To Salele napaꞌa etehi foluguꞌi goꞌi meluꞌehigo Maliau, Magadala hepato aꞌi yabe, ai ho tito buloto mulito nehetito bagaꞌalo hekini loꞌehina efapo aiꞌa li koli heꞌmiꞌehinamofihi bu goꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ya bu golotoꞌa i behe huto hololu luto Simoni Pita hiti to Yesu bita huꞌehina koko panaꞌa hiti etalitoga buto lu etimiꞌehina: Enali Sipi Boti muliꞌmoguti leꞌme heꞌmite kofite bifa hiꞌahanagi hiyaga meleꞌehilabe? Mekehelune, luto luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ya ligo Pitau to yaꞌma koko panaꞌa hiti kehelite hepatoti heꞌmite kene mala malatoga biꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Etali anaga hololu lite nebaꞌigo yaꞌma koko panaꞌauba Pitahi be ligito mulito nehetito kaba fito bu goloto gufaꞌa sa giꞌahana koholi kata yasigo bu goto melimiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Ya huto fegutoga nominago Simoni Pitau alihi oto meleꞌisi muliꞌmogu limiꞌehina. Ai ana huto Yesuhi gufaꞌa sa giꞌahana koholi kata bu goto to latahaꞌalo sa giꞌahana kata fatoꞌi niꞌigo bu goꞌehina. Yaꞌma latahalo katamo fato koholi kata hiti meniꞌigo ke figito li fatoꞌi moloꞌehina niꞌigo bu goꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","To yaꞌma koko panaꞌi kohe toto mulito yataꞌa nehetiꞌehinauba ai hiti muliꞌmogu limito bu goto Yesuhi fililago aku ho tiꞌehinaꞌmu keheli uleꞌale huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Etali yaꞌma mono bukugu fayahi mone keyeꞌahana: Ai fililoto Huꞌmau akuꞌi filiꞌehinaguti leꞌmo ho tilina yaꞌma kumu keheli bati mehiꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","To panaꞌalobomaleꞌi bu gete i behe hite hepaꞌatitiga biꞌahaꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","To Maliau kene mala malatoga minoto yibi huto mulito fegutoga minoꞌehina: Ai yibisu kalasu nohuto kaba fito muliꞌmogu bu goto agelo bo loemo koli kata hepiꞌahaꞌinamaleꞌi nehaꞌigo bu goꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ana muligu Yesuhi gufaꞌa meleꞌahana hepato agelo moneuba Yesuhi latahaꞌa koꞌehinalo minago to agelo moneuba gigusaꞌa minoꞌehinalo anaga minabe. ");
INSERT INTO bef_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","To etali Maliahi loka heꞌahaꞌina: Ma aꞌise, henabe luto yibi nohane? Ya nelaꞌigo ai ka nonaꞌalo lu etimiꞌehina: Enali Sipi Boꞌni magati leꞌme heꞌmite kofite hepaꞌa meleꞌahanalo mekeheliꞌohunagihe. ");
INSERT INTO bef_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ya lutoꞌa fegutoga mino ho tito i behe huto kene mone anaga lebato ho tiꞌehinamofihi bu goꞌehina. Ana bo Yesu nohinaya Maliau aiꞌi mekeheliꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mekeheligo Yesu lu emiꞌehina: Ma aꞌise, henabe luto yibi nohane? Kiyiꞌafihi sa sa nohane? luto ligo Maliau ai foya kaba bo nohina ekesa kehelito lu emiꞌehina: Nalaluꞌniga, kai gufaꞌa li kofito moloꞌahata hepato nelepitogo analo buto leꞌmoto alube. ");
INSERT INTO bef_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ya luto ligo Yesu lu emiꞌehina: Maliao, ligo Maliau aitoga i behe huto Hibulu kaluguti lu emiꞌehina: Labonio. Yaꞌma kagaꞌa hapaꞌa Babafio yabe. ");
INSERT INTO bef_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ya ligo Yesu lu emiꞌehina: Kai nunu mekibo. Nani yataꞌa aku afoꞌnifitoga metise nohugo nogonaꞌni nehanalo buto ka lu epi netobo: Nani kokulumalugu Huꞌmamofitoga tito afoꞌnifu afotinifu aitoga tilubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yesu ya luto ligo Maliau buto panaꞌaloboꞌamagihi ana kagaꞌa lu epito Sipi Boꞌani bu goꞌehinamo ka lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yaꞌma Salele napagu utehi yege limiꞌehigo Yesuhi panaꞌalobo enali mone nonugu li gehesa nehite Yuta bonaꞌmagi kumu koli nehite kasito hekini loꞌehinaga mineꞌahabe. To yaꞌma nehanago Yesu folaganugu mino ho tito kaga lu epiꞌehina: Lenalitoga fulunaꞌa mineno. ");
INSERT INTO bef_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ya luto luloto yaha hiti fatipa hiti enelepiꞌehina. Ya nohigo panaꞌalobomagi be gelete Sipi Boꞌanimofihi enofokehi napaꞌa heꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","To Yesu ka mone hiti lu epiꞌehina: Lenalitoga fulunaꞌa aꞌmineno. Afoꞌnifu ma melugu noho lifigo limiꞌohunaya nani ana huto lenoho lifinogo melugu tili tele hilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ai ya luto nohuto sikalafuꞌi fulu bi epoloto lu epiꞌehina: Hetofa Sikalafuꞌmo lepilenogo komopatinigu limito mineno. ");
INSERT INTO bef_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","To bonaꞌi komopaꞌani i gelehe hilenogo lenali foipanaꞌani li heꞌmi epalalabe kagaꞌni moloꞌohube. To bonaꞌi komopaꞌani i gelehe mehilenogo foipanaꞌani meheꞌmi epalalanaya ana foipanaꞌani minalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Panaꞌa moneuba, Tomasiu fato giꞌa Loe Lae ketoꞌehina panaꞌi ai Yesu yataꞌa enubuꞌanilo huto huꞌehina yupahi mehuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","To alihi panaꞌaloboꞌmagi lu emiꞌahana: Lali Sipi Boti bu goꞌohune, lite lago Tomasiu lu epiꞌehina: Yaꞌma kaga lu neniminamofi kumu mekehelilunaꞌmu yabe. Nani yahaꞌalo nilitu fiꞌahanaꞌa bu golotofi to nayahi museꞌa fuheto li kehelitofi to nayahi fatipa fiꞌehinalo li kehelitofi ya hutoꞌni aho tiꞌehina yabe luto keheli uleꞌale hilubeꞌmu nohube. ");
INSERT INTO bef_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","To kana mone salele buꞌehigo panaꞌalobomagi Tomasi hiti li nupa nonuga nehite kasito hekini loꞌehigo mineꞌahana. Ya nehago Yesu ai huto folagahaꞌanigu mino huto huto lu epiꞌehina: Lenalitoga fulunaꞌa mineno. ");
INSERT INTO bef_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ya luto luloto Tomasihi lu emiꞌehina: Maloꞌi kayaka musoka afito nayahaꞌni luga luga bu gobo. To ya huloto kayatu li su toto fatipaꞌnigu nufuheto li keheli molobo. Ya huloto kekesa yigi yigi huseꞌnaka heꞌmiloto nanitoga keheli uleꞌale huto agoya hu nimibo. ");
INSERT INTO bef_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ya ligo Tomasiu lu emiꞌehina: Oho, Sipi Boꞌni yale. Kai Huꞌmaꞌniga nohane, luꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","To Yesu lu emiꞌehina: Tomasiu, kai kubukatu bu nogoto keheli uleꞌale nohata yabe. Bonaꞌi moneuba bu menonogoto keheli uleꞌale huto agoya hu nimilina ya bomo gelo sipi bilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","To Yesu sipi liliꞌna amuyaꞌa hiti panaꞌaloboꞌamagihi enubuꞌanilo babu lito fato fatoꞌi liꞌehina anana ma bukugu fayahi mekoyoꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yesu yaꞌmana sipi liliꞌna liꞌehinamofihi kaga lu lenelepiꞌehinaꞌa fayahi koyoꞌehinago kehelite Huꞌmamofihi Panaꞌa nohinaya to leꞌmo ho tiꞌehina bo, Mesia nohinaya lenali yaꞌma keheli uleꞌale hilanaꞌmu to aitoga agoya hu emilenogo mino kosaba huseꞌna lepilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","To alihi Yesu mone kana hiti panaꞌalobomagihi Galili hefupo nagamito beletoga huto huꞌehina. Ma suhi huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Panaꞌaloboꞌamagi Simoni Pitagi Tomasigi fato giꞌa Loe Lae eteketoꞌehina yabe nelana to Natanieligi ai Galili kapomofihi Kena hepato bo to Sepetihi panaꞌamaleꞌi hiti to Yesuhi fato panaꞌaloboꞌa loemo etali hiti li nupa hite ana hefuhi nagami beletoga mineꞌahabe. ");
INSERT INTO bef_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ya nehite Simoni Pitau lu epiꞌehina: Nani buto fayaꞌi lilubeꞌmu nohube, ligo enali lu emiꞌahana: Lali hiti bilune, lite enali nagamiꞌi beletoga bite boti monelugu tilete nagami mupaꞌalo bite foluguꞌmo fayaꞌi babeyafa hite aku akuꞌi fayaꞌi meliꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","To etehi yege tilubeꞌmu nohigo Yesu oloto nagamiꞌi beletoga kehetoga mino ho tiꞌehina. Ya higo panaꞌalobomagi Yesuhi mehaꞌa mekeheliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","To Yesu kehe ito lu epiꞌehina: Panaꞌise. Fayaꞌmo liꞌahafihe? luto ligo enali lu emiꞌahana: Oꞌe, meliꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","To Yesu lu epiꞌehina: Botihi lamagaꞌaga fayaꞌi gutalafaꞌi heꞌmi malalo. Fayaꞌi lugaꞌa lilabe. Ya ligo enali kehelite gutalafa heꞌmi malago fayaꞌi babu lite gutalafatu kefefe hite botigu li malaluneꞌmu nehago ana fayaꞌi sipi keta higo memeleꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","To Yesu bita huꞌehina panaꞌauba Pitahi lu emiꞌehina: Miya keneꞌi Sipi Boti nohibe, luto ligo Simoni Pitau, Sipi Boti nohibe nolinaꞌmu kehelito koyapaꞌi gu kata aheꞌmiꞌehinagi nakuꞌa mone sa gito biloto nagamilugu leke ho moloto Yesutoga buꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","To ya higo panaꞌalobo botigu nehanamagi beletoga biluneꞌmu nehite faya gutalafaꞌi kefefe hite kehetoga lebatoꞌisi 100 mitalo biꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","To enali ya hite nehetite botiguti limite to meya fayaꞌi hiti beleti noseꞌna hiti logogu moloꞌehinana bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","To Yesu lu epiꞌehina: Fayaꞌi maꞌasi liꞌahanaꞌa moneꞌa maloꞌi ite alo. ");
INSERT INTO bef_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Pitau botiga buto fayaꞌi gutalafaꞌmo abai toꞌehinagu fayaꞌi babu lite napaꞌa hiti leke seꞌahana 153 fayaꞌmo li nupa hiꞌahana. Yaꞌma babu fayaꞌi gutalafalugu bai toꞌehinagi i hepulu metuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ya kefefe hite minago Yesu lu epiꞌehina: Lenali maga ete noseꞌna nalabe. To asaga panaꞌalobomagi ai kumu enelesa noligo kiyiꞌaga nohane lite loka meheꞌahanaya, Sipi Boti nohibe lite enegekesa keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","To Yesu logo nolanaga buto fayaꞌi guna ito to beleti noseꞌna hiti ana huto guna ito epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Koyapaꞌi Yesu panaꞌalobomagihi filiꞌehinaguti ho tiꞌehinaꞌa kohe toto loe kana enubuꞌanilo huto huꞌehinagi to yaꞌma noseꞌna guna iꞌehina kana hiti enalitoga huto huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","To enali noseꞌna ne su heꞌahago Yesu Simoni Pitahi lu emiꞌehina: Simonio, kai Yonihi panaꞌa yale, kiginaga fi nonimitana enaliꞌanimofihi be ligiꞌehina niꞌifihe? ya ligo Pitau lu emiꞌehina: Oꞌyo, Sipi Bo yale, niginaga fi nokumuna yamofihi akeheliꞌahane. Ya ligo Yesu lu emiꞌehina: Kai sipisipi yagaꞌni nalaꞌa kaba hu epolobo. ");
INSERT INTO bef_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","To Yesu geꞌnoka Pitahi mone hiti hoꞌehina: Simonio, Yonihi panaꞌa yale, kiginaga fi nonimitana niꞌifihe? ya ligo Pitau lu emiꞌehina: Oꞌyo, kai kumu nonebesinana akeheliꞌahane, Sipi Boꞌnimaka. Ya ligo Yesu lu emiꞌehina: Kai sipisipi yagaꞌni kaba hu epolobo. ");
INSERT INTO bef_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","To Yesu geꞌnoka mone hiti Pitahi hoꞌehina: Simonio, Yonihi panaꞌa yale, nani kumu nokebesifihe? Ya luto loka hago Pitau kehelito Yesu loegi monegi loka hoꞌehina kiginaga fi nonimitaya yanaꞌmu ipaꞌagu gabu nogigo ka lu emiꞌehina: Sipi Bo yale, kai yege yegeꞌna keheli baga ito niginaga fi nokumunaya akeheliꞌahane. Ya luto ligo Yesu lu emiꞌehina: Kai sipisipi yagaꞌni kaba hu epolobo. ");
INSERT INTO bef_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nani maꞌnaka lu nokumube. Koyapaꞌi kai neheya kola nohutoka gu kata hiti letika hiti biloto hepaꞌi fato fatoꞌi bula ola huꞌahata kaiꞌnaka niꞌibe. To alihi oyafa loloto mone kanagu kayaka su toloto nohitogo bonaꞌmagi nagaꞌi kimite hepaꞌi monelugu mebilubeꞌmu nohilata anaga kaimofihi keleꞌmete bilabe. ");
INSERT INTO bef_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu yaꞌma kaga lu emiꞌehinaꞌmu Pitahi fililinamofihi hapaꞌa mone yupahi huto hilina yaꞌma lepiꞌehibe. To Pitahi ho fililinaꞌmu Huꞌmamofihi giꞌa liyafa hilinaꞌmu yabe. To Yesu lu emiꞌehina: Pitao, Nemegeꞌi molobo. ");
INSERT INTO bef_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","To Yesu lu emigo Pitau i behe huto yaꞌma Yesu bita huꞌehina panaꞌa nohigo bu goꞌehina. Yaꞌma bouba koyapaꞌi Yesu hiti panaꞌaloboꞌa hiti nonugu minete Pasa noseꞌna nete nehago loka hoꞌehina: Sipi Bo, kai kumu kiyiꞌafu fatehakamagihi gutunu ka lu epilina. ");
INSERT INTO bef_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yaꞌma loka hoꞌehina bomofihi nohigo Pitau bu goto Yesuhi lu emiꞌehina: Sipi Bo, mana bomofihi henana hu etalibe? ");
INSERT INTO bef_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ya ligo Yesu lu emiꞌehina: Ai minoba minoba huto nani aluna yupapo minenogo yaꞌma kaika foyakamo niꞌifiye? Kaika nemegeꞌi moloꞌohubo. ");
INSERT INTO bef_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ana kagaꞌmu Yesu panaꞌalobomagi kehelite yaꞌma bita huꞌehina panaꞌamuꞌi mefililibe lite liꞌahana. Yesu yaꞌma kaga mefililibe, luto meluꞌehinagi ai luꞌehina: Ai minoba minoba huto nani aluna yupapo minenogo yaꞌma kaiꞌnaka niꞌifiye? yaꞌma Yesu lu moloꞌehinana niꞌibe. ");
INSERT INTO bef_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","To yaꞌma Yesu bita huꞌehina panaꞌauba kaga nasanaꞌmu lu epito to anana fayahi koyoꞌehina bo ma nohibe. To ya huꞌehinaꞌmu lali kaga luꞌehinamofihi akehelito maꞌnaka luꞌehina yabe luꞌohune. ");
INSERT INTO bef_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","To Yesu huto huꞌehinana fato fatoꞌi babu luto niꞌigo mekoyoꞌohube. Anaꞌina babu luto niꞌinaya pepagu fayahi gomolo gomolo huto babu buku huto hulenogo asaga melugu moloto kikipa halinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Oho Tiofilusio. Nani yataꞌa bukuꞌnigu Yesu yataꞌa hapi fito li huto huꞌehinana hiti to kaga lu epiꞌehina hiti ninamofihi fayahi goꞌohube. To liliꞌnaꞌa hapi fito liꞌehinamoloti ti baga iloto, ");
INSERT INTO bef_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kokulumalugu tiꞌehina kana moloto oto pa sobe. Kokulumalugu metiꞌehigo Sikalafuꞌuba Yesuhi heꞌmago kaga ma luto eneleꞌmo nupa huꞌehina aposolo pananaꞌa lu epiꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Koyapaꞌi Yesu ai gabu foya li kofito fililoto ai alihi aposolo panaꞌamagitoga huto huꞌehina. Ai filiꞌehinagati ho tiloto kosaba bo nohube luto babuna fato fatoꞌi aposolo panaꞌa hu enubulo moloꞌehina. To 40 yupaha kanagu aposolo panaꞌamagi Yesu enubulo huto huto huloto Huꞌmamofihi Kapoꞌamofihi kagaꞌa beto hu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yesu aposolo panaꞌa hiti nohuto kaga ma luto lu epiꞌehina: Lenali Yelusale hepaꞌi heꞌmite mebilo. Lenaliꞌi lepilube luto Afoꞌnifu kaga koyapaꞌi moloꞌehinana lenalitoga alinaꞌmu geba hite minalo. To nani ananaꞌmu koyapaꞌi kaga alu lepiꞌohuna yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoniu nagami lafatuꞌi boanaꞌi nagamiꞌi folo epoloꞌehina yabe, Ya huꞌehina lenali yatama kana mebuꞌehinogo Sikalafuꞌuba komopaꞌanigu tilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposolo nagaꞌmagi Yesu hiti bite li nupa hite minelete ma lite loka heꞌahana: Sipi Bo, yatai yaꞌma kanaꞌalo Isilaeli kapo akuꞌi li kosaba hilata niꞌifihe? ");
INSERT INTO bef_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ya lite loka hago Yesu ma luto lu epiꞌehina: Ana suhi huto hilina yupa hiti to kanaꞌa hiti molosemofihi nani Afoꞌnifugo keheliꞌehibe. To ya yupahi huto hilibe lite lenali mekehelilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ya huꞌehinaya Sikalafuꞌuba lenalitoga alina yupahi lenali amuya lilete, Yelusale kegiꞌafi, to asagaꞌi Yutia to Samalia kegiꞌa buto noheꞌmuna to melugu fotoꞌi nekisaꞌaga nani kumuꞌi lu yege halanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu ya luto kaga lu su holago enali be gelete nehago Yesu kokulumalugu notigo sopohi moneuba oto leꞌmo fenene enubuloti huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ai ya huto notigo aposolo panaꞌa enali kokulumalugu be goba be goba lite nehago anaꞌasilo bo loemo koholi gukete li hekolose bole enali nehanalo ho tiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Etali ma hite lu epiꞌahaꞌina: Lenali Galili bose, henabe lite maga ho tiꞌehite kokulumamofihi buluꞌi nehabe? Yaꞌma Yesuhi, yatai Huꞌmau lenalitogati leꞌmoto kokulumalugu notina okaba hiti bo ana suhi luto akuꞌi mone yupahi alinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ya laꞌigo enali yaꞌmana Oliba kosa heꞌmite Yelusale i behe hite biꞌahana yabe. Oliba kosa ai Yelusale hepaꞌi lebatosi minoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ya huꞌehigo enali Yelusaleꞌi nehetilete minelata nehana nohi hasagu tiꞌahana. Enali enigiꞌani, Pitau, Yoniu, Yemesiu yagi to Batolomu, Filipiu yagi to Tomasi, Atulu yagi to Matiu, Alifiasihi panaꞌa Yemesi, Simoni gimi bo yagi, to Yutasiu Yemesihi panaꞌa ya hite enali asagaꞌi mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yaꞌma bo asagaꞌi enali komopaꞌani monetoga melete li nupa hite numuna hite minelata hiꞌahana. To anaꞌi lugaꞌa hiti to Maliau Yesuhi itoꞌafi hiti to gonamu tamuꞌa enali ana hite moneko ete li nupa hite nunumu hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nunumu hite minana kanaꞌa nesiꞌa babu luto enebe ligilago mone yupahi 120 bonaꞌi li nupa hite minago Pitau ho tiloto ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nogonamu tamuꞌnimagita lenali kehelilo. Koyapaꞌi monolugu fayahi mone nina Sikalafuꞌuba Tebitihi bagalo lu huto huꞌehina yabe. Ai Yutasi kumu luꞌehina, yaꞌma bouba ai Yesuhi halana bonaꞌmagihi kapoꞌani li hokolo hilinaꞌmu yabe. Ya lite fayahi geꞌahana ana suhi ahuꞌehibe. ");
INSERT INTO bef_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Koyapaꞌi Yutasiu ai lali hiti moneka minototi ai hiti yaꞌmana liliꞌna moneka liꞌohuta yabe luto Pitau lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yutasiu Yesuhi fatehaꞌamagi emina efatuꞌi meꞌi nesiꞌa mone mina fiꞌehina yabe. Ai ana melugu buto ho kago ipaꞌa folaganuguti i hokolo gehesa higo asaga komopaꞌagu ninana fegutoga limi su hago filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Alihi asaga bonaꞌi Yelusale minanamagi yaꞌmana kaga keheliꞌahana yabe. To enali kagaꞌaniguti yaꞌmana hepaꞌi giꞌa Akelatama yabe liꞌahana. Yaꞌmana kagaguti giꞌa heꞌahanamofihi hapaꞌa golaha meꞌi yabe luto niꞌibe. ");
INSERT INTO bef_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yalo Pitau luꞌehina: Yaꞌma fayahi namamo lise bukugu niꞌina, ai ma luto yabe. Ai nohaꞌa yuꞌnohi mineno. Bonaꞌi mone ana nonugu memineno. To mone hiti ma luto niꞌina yabe. Bo moneuba ai hepaꞌi lito nonaꞌa liliꞌna alino. ");
INSERT INTO bef_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yaꞌmu luto yatai bo mone lali hiluta suhi luto Yesu filito ho tiꞌehinamofihi bu goto yaꞌma kagaꞌa lu yege halune, ai yaꞌmana bo Yesu hiti moneka humofaꞌna huta kanaꞌa luga lemegeꞌi molomofaꞌna huꞌehilina boguti leꞌmo ho tilutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Koyapaꞌi Yoniu boanaꞌi nagamiꞌi folo epolomofaꞌna higo to Yesu liliꞌnaꞌa hapi filoto limo limo oto Huꞌmau lalitogati Yesuhi leꞌmoto ifoga tiꞌehina, yaꞌma asagaꞌna nolunamofihi bu go baga iꞌehilina bo leꞌmo ho tilune. To ai yaꞌmana bouba lali hiti moneka liliꞌna lito Yesu filiꞌehinaguti ho tiꞌehibe luto lu yege haluta bo yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pitau ya luto lulago bo loemo eteleꞌmo ho tiꞌahana; Yosefe, ai Basabasi, to mone fato giꞌa Yasitasi yabe luto nohina hiti to Mataiyasi hiti eteleꞌmo ho tiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ya hilete yalo enali nunumu ma lite hiꞌahana: Sipi Bo, kai asaga bomagihi komopaꞌanigu bu go fulu tise bo nohane. To yamuꞌi, Sipi Botimaka, ma bo loeguti hiya bouba yaꞌmana hepaꞌi lito liliꞌna lilifi kai lelepibo. To Yutasiu kapoꞌaga bilubeꞌmu nohuto aposolo liliꞌna heꞌmiꞌehinanaꞌa ana liliꞌna kosaba bo lilinamo niꞌibe. ");
INSERT INTO bef_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ya lite nunumu hilete enali lugaꞌamagi Mataiyasio yabe lite enayahi netigo to lugaꞌamagi Basabasio yabe lite enayahi tina Mataiyasiu be ligiꞌehina yabe. Ya higo enali Mataiyasihi nayahi luga luga su hoto nigigusagati mone heleko malago aposolo panaꞌi minanalo leꞌmo meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sikalafuꞌi limise kanaꞌa olago enali moneko nonuga ete li nupa hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ya hiꞌahago meleꞌisi kokulumaluguti nogo moloꞌehina, ai amuya habafahi suhi luto nogo moloꞌehina, ya huloto li nupa hite nehana nonugu tito ana habafahuba bai toꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","To logo guluya mehaꞌa legina huto nohigo bu geꞌahana. Ya nehago ana logo guluya mehaꞌa nesi nesi huloto moneko moneko bonato mino baga iꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","To Sikalafuꞌuba asaga aposolo pana enalitoga bai tago enali fato fato kaga liꞌahana, ai Sikalafuꞌuba li enabagalo malana kaga liꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yuta bonaꞌi lugaꞌa Yelusale ete mineꞌahana, enali mono bonaꞌi hiti to bonaꞌi lugaꞌa fato fato hepatoti ete li nupa hite mineꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ya hite nehanalo sipi nogo kokulumaluguti malana kehelilete babu bonaꞌi limo gehesa hilete aposolo panaꞌmagi kaga fato fato nogo hite nelago limo gehesa hana bonaꞌmagi nogoꞌaniguti fato fatoꞌi kaga nelago kehelila kehelila hiꞌahana. Ya hilete enali ana kagalo topa helete enegelo gofa biꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ya hilete enali lugaꞌaga enekesa yigi babu nelite luga kegiꞌa enegelo bilete ma lite liꞌahana: Enali asaga bo ma kaga nelana asagaꞌi Galili bogo nehabe. ");
INSERT INTO bef_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hena hiꞌehite enali moneko moneko bomagita nogoti hite kaga fato fato nogoguti nelabe? Enali itotigi atotigi lago keheliꞌohuta nogomoguti kaga nelabe. ");
INSERT INTO bef_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Maga li gehesa huto nohuta bonaꞌiya Patia to Mitia to Ilama hepato bo yabe, to lali Mesopotamia bonaꞌi yagi, Yutia to Kapatosia hepatoti, to Ponitasi to Esia bonaꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Filigia to Pamifilia kegiꞌati, Iyipi bonaꞌi Libia kegiꞌa Sailini lebatoti yagi, lali Lomu bo maga oto nominota. ");
INSERT INTO bef_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Lali Yuta bo hiti to fato bonaꞌi Yuta bonaꞌmagi hapaꞌani liꞌohuta bonaꞌi yagi, Kiliti to Alebia bonaꞌi yagi lali asagaꞌi fato fato nogoti nina nohuta enali ana moneꞌisi nogotiguti Huꞌma amuya liliꞌna li huto huꞌehinamofihi lu yege hago nogotiguti keheli baga une. ");
INSERT INTO bef_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ya hilete enali topa helete enekesa yigi babu lilete enaliꞌani ma lite ai loka hago ai loka hago hiꞌahana: Yaꞌma kaga nelanaguti hena suhi huto hilina niꞌibe? ");
INSERT INTO bef_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ya nelite lugaꞌamagi kiya yokolo ka lu epelete enali kosaba bai nagamiꞌi babu lite neꞌehite nelabe liꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ya lago Pitau hiti to nayahi luga luga su hoto nigigusagati mone heleko malago nehana aposolo nagaꞌi hiti asagaꞌi ho tilete kehe sipi iloto kaga lu hokolo huto asaga boanaꞌi ma luto lu epiꞌehina: Lenali Yuta bonaꞌi hiti to asaga boanaꞌi lenali Yelusale ete li gehesa hite nehanamagita nani kaga moneꞌya lilubeꞌmu nohunagi kehelilete yaꞌmananamofihi hapaꞌa keheli bati hilabe. ");
INSERT INTO bef_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lenali lu keheli fa keheli nehanaꞌa hite ma bomagi enali bai nagamiꞌi neꞌehite negi nagiga nelabe lite melilo. Yataꞌisi maꞌasi etehi niꞌibe. Bonaꞌi ete yaꞌma kanaꞌa bai nagamiꞌi menelata nehabe. ");
INSERT INTO bef_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ya huꞌehinaya yaꞌma huto nohinanalo koyapaꞌi lu huto huto bo Yoeliu ma luꞌehina yabe: ");
INSERT INTO bef_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yaꞌma suhi kokuluma hiti meꞌi hiti su halina yupahi li huto hilunaꞌmu yabe luto Huꞌma luꞌehina: Nani Sikalafuꞌnimofihi amuyaꞌa asaga boanatoga molo baga ilunaꞌmu yabe. Lenali panatinimagi to patinimagi hiti enali lu huto huto bona suhi lite kaga lu yege halanaꞌmu yabe. To nani fato fatoꞌna neheya kola botinimagihi enali enubulo li huto hilunaꞌmu yabe, to oyafatinimagi bamuꞌi nani hu enubulo malalunaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","To ana huto yaꞌmana yupahi asaga boanaꞌi enali nani liliꞌna neli netanamagihi Sikalafuꞌnimofihi amuyaꞌa enalitoga malalube, yahi nogoꞌni enali babafi bana suhi lite kagaꞌni lu yege halabe. ");
INSERT INTO bef_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nani babeyafana fato huseꞌi kokulumatoga ifoga li huto nohuto ana huto ma afetoga melugu li huto nohinogoꞌni golahi hiti logo hiti to lokiya sopohi huto hilibe. ");
INSERT INTO bef_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nani yege li gelehe hinogoꞌni metepu gilibe. To ikahi leꞌmo gelehe hinogo golahi huto hilibe. Ya huto asagaꞌna huto hu su holenogo Sipi Bo kibinamofihi kanaꞌa huto huloto i besa lo baga ilibe. ");
INSERT INTO bef_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ya hinogo boanaꞌmagi Sipi Bomofihi giꞌa halana enaliꞌi Huꞌmau eneleꞌmenogo ai boanaꞌa minalabe. Kaga lu yege holata bo Yoeliu yaꞌma luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Lenali Isilaeli bomagita yaꞌma kaga kehelilo. Nasalete bo Yesuhu kaga lu lepilubeꞌmu nohube. Yaꞌmana bomofihi yato Huꞌmau amuya liliꞌna emigo liꞌehina hiti topa hoseꞌna hiti to babeyafana hiti li huto huto lenali folagahatigu buꞌehina, ya Huꞌmau ho lifiꞌehina bo nohibe lite lenali bu go bati hilabe luto yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Koyapaꞌi Huꞌmau aiꞌa ekesa yigito mololoto ai yaꞌmana bo Yesuhi lenali lenayanugu moloꞌehina yabe. To enali kaga li gofa hose bomagihi enayanugu meleletetini malipu yafalo hago filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ya hiꞌahana Huꞌmau yaꞌmana bo akuꞌi leꞌmo ho tiꞌehibe. Ai gabu gigo filiꞌehinana asagaꞌi li heꞌmi su hoꞌehibe. Henaꞌmugope kene mala malauba yaꞌmana bomofihi gufaꞌalo meligo yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yaꞌma luto Tebitiu ai kumuꞌi kaga mone ma luto luꞌehina: Sipi Bouba asaga yupahi nubulo higo bu goꞌohube. Ai nayahi lamagaꞌaga nohinago naniꞌi anaꞌina moneuba neleꞌmo felu mehalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yaꞌmu luto nani nipaꞌnigu laga nohigo nani nofokehe kaga nolube. Nugufaꞌniuba hiti hetofanaꞌmu geba huto minalibe. ");
INSERT INTO bef_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kai nugufaꞌni heꞌmitogo filise bonaꞌmagi hepatoga meminalibe. To ana huto lamana bomofihi gufaꞌa heꞌmitogo tuguma mebilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kai minoba minoba hepaꞌi niꞌinamofihi kapoꞌa aꞌnelepiꞌahane. Yalo kai nani hiti moneka minaluꞌinauba nani nugufaꞌnigu laga gofa nebesilinaꞌmu yabe. Tebitiu yaꞌma luto luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nigibo nagabose, nani maꞌnaka luto Tebitiu tatatimofihi kagaꞌa lu hokolo huto lu lepilube. Ai afiligo akeli heꞌahana ai kene keliꞌa yatai kanaꞌalo lali hiti ma folagahatigu niꞌibe. ");
INSERT INTO bef_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ya huꞌehina ai Tebitiu kaga lu yege hose bo nohibe, ai Huꞌmau ma luto lu moloꞌehina kaga akeheli yafa huꞌehina yabe. Nani panaka mone kai siakalo nonaꞌa minalina kiminogoꞌni kai hepaꞌi lilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tebitiu Huꞌmau li huto hilubeꞌmu nohinamofihi hapaꞌa abu goloto Mesiau akuꞌi ho tilina kaga ma luto luꞌehina: Huꞌmau filise bonaꞌmagihi hepalugu gufaꞌa heꞌminogo meminalinaꞌmu yabe. To gufaꞌa tuguma mebilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yaꞌmana Yesuhi Huꞌmau aleꞌmo ho tiꞌehigo lali bu golototi ai kagaꞌa lu yege nohone. ");
INSERT INTO bef_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yatai ai kokulumalugu tito Huꞌmamofihi yahi lamagaꞌaga nohibe. Ai koyapaꞌi afoꞌafu emilube ka lu moloꞌehinaꞌa huto Sikalafuꞌi afoꞌafitogati aliꞌehibe. To lenali yatai bu gela kehelila nehananaya Yesu ai yatai lalitoga molo baga i letabe. ");
INSERT INTO bef_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tebitiu aiꞌa kokulumalugu metiꞌehinaya, ai ma luto luꞌehina: Sipi Bo Huꞌmau Sipi Boꞌnimofihi ma luto lu emiꞌehina: Malo nayahi lamagaꞌaga minobo. ");
INSERT INTO bef_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ya huꞌehitogo alihi fatehaka kigigusaluga eneleꞌmo melenogo bilabe. ");
INSERT INTO bef_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ya huꞌehinagi asaga Isilaeli nagaꞌmagita yaꞌmananalo keheli bebe salune. Yaꞌmana Yesuhi lenali malipu yafalo hago filiꞌehina, aiꞌi Huꞌmau Sipi Bo leꞌmo lolo higo nohina ai Yesu Kilisitou nohibe luto, Pitau ya luto lu epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asaga boanaꞌmagi yaꞌmana kaga kehelilete enali enelesaꞌani ligo Pita hiti to lugaꞌa aposolo panaꞌmagitoga ma lite enoloka heꞌahana: Ligibo lagabose. Ya lanago lali hena hiluta niꞌibe? ");
INSERT INTO bef_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitau kaꞌanilo ma luto lu epiꞌehina: Lenali moneꞌisi moneꞌisi komopatini i gelehe hilete Yesuhi gilo nagamiꞌi falalana lenali foipanatini li heꞌminogo Huꞌmamofitogati amuyana Sikalafuꞌa lepilibe. ");
INSERT INTO bef_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Koyapaꞌi Huꞌmau ka moloꞌehinaya lenalitoga hiti to yagapanatiniloga hiti to asagaꞌi meꞌi foto nehana hiti, asagaꞌi enali Sipi Boti Huꞌmatifu kehe ilina bonaꞌi yaꞌmanana epilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","To Pitau fato fato kaga lu hokolo luto lu epiꞌehina. Ai ma luto luꞌehina: Lenali kaba hu bati hilo. Huꞌmau foipa bonaꞌi osahi epilinagi bonatini ma bati mehana bonaꞌi enemegeꞌi melete enali hapaꞌani li lalagi kaba hite minalo. ");
INSERT INTO bef_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ya luto Pitau lulago ai kaꞌa keheli bati hana bonaꞌi ana yupahi nagamiꞌi fele su heꞌahana. Yaꞌmana yupahi bonaꞌi nehanaꞌalo Huꞌmau molo emiꞌehina 3,000 boanaꞌi yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Enali aposolo panaꞌmagi kagaꞌani moneꞌa hiti kehelilune lite amuya meleꞌahana, to enigibo nagabo eneheꞌmola, noseꞌna monekolugu li nupa hite nela hite to nunumu monekolugu li nupa hilete hilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sipi liliꞌna fato fatoꞌi to topa hoseꞌna hiti aposolo nagaꞌmagihi enayato Huꞌmau babu luto li huto higo asaga boanaꞌi enali be gelete enelesaꞌani ligo koli hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","To asaga boanaꞌi enali Yesutoga komopaꞌani neeminamagi enali hiti ho ti baga iꞌahana. To asaga enali nasanaꞌani keheligo asaga mono bonaꞌi li nupa hite minanamagihina lolo huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Enali feꞌnohaꞌani bonaꞌi neepite efahi lilete ana efa guna i eto eto lite lilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Asaga yupahi utehi etehi moneko nagaꞌi lolo hite sipi mono nonuga li nupa hite bilata hiꞌahana, to nohaꞌanigu noseꞌna monekolugu nupa hite nelata hiꞌahana, to fuluna kiya yokoloꞌnagu minete noseꞌna nelata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Asaga yupahi utehi etehi Huꞌmamofihi giꞌa li saga hite minelata hago asaga boanaꞌmagi enugufagu bati huꞌehina yabe. To asaga yupahi Sipi Bouba boanaꞌi lugaꞌa enubuto bito enali folagahaꞌanigu molo emilata higo boanaꞌi babu luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mone yupahi Pitaugo Yoniugo utehi yege limito sili sili noligo nunumu hilata kanalo sipi mono nohi niꞌinaloga tiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","To Hetofa Kasito yabe luto giꞌa nina kasito bo mone gigusaꞌa sibina loꞌehina itoꞌafu ketoꞌehina minoꞌehina. Asaga yupahi yaꞌmana kasito leꞌmete ete heꞌmi etago nohuto boanaꞌi mono nonugu elata hanamagihi efa kumu kehe ito nominana bo yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yaꞌmana bouba Pitaugo Yoniugo sipi mono nonugu tiluꞌibeꞌmu nehaꞌigo bu etogoloto anaꞌina nimiliyo luto kehe iꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ya ligo Pitaugo Yoniugo ana bo bu go fiya ilete ma luto Pitau lu emiꞌehina: Leꞌaliꞌi bu leꞌegobo. ");
INSERT INTO bef_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ya laꞌigo anaꞌina nimiluꞌibeꞌmu nelaꞌifi luto etubugu etogoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ya higo Pitau ma luto lu emiꞌehina: Nani efahi meliꞌohube, ya huꞌohunaya nani liꞌohunana kimilube. Yesu Kilisitou Nasalete Bomofihi giꞌalo nolu ketonagi kai kapo molobo. ");
INSERT INTO bef_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ya luto lu emiloto Pitau ana bomofihi yahi lamagaꞌa liloto heꞌmoto leꞌmo ho tiꞌehina. Ya higo anaꞌasilo meleꞌisi ana bomofihi giꞌa hiti to gihupabaꞌa hiti akuꞌi amuya moloto bati huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ya hulago ana bouba leke holago tiloto kapo nesiꞌa i gofa huto mololoto Pitanogo Yoninogo hiti sipi mono nonuga buꞌehina. To ai sipi gelo biloto kapo moloto nobuto, heleko lago tiloto limiloto huto Huꞌmamofihi giꞌa li saga huto fokehi liꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ya huto nobigo asaga li gehesa hite minana boanaꞌmagi ana bo bu geꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Enali ana bonaꞌmagi yaꞌma bo ai sipi mono nopofihi Hetofa Kasihaꞌalo nohuto anaꞌinaꞌmu kehe ilata bo ma nohibe lite akeheliꞌahana. Ya hilete hena suhi huto hifi lite topa he baga ilete enekesauba loe lae huꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ana bouba Pitanogo Yoninogo etunu ki pili koloto Solomonihi Hasa yabe lite giꞌa meleꞌahanagu nehago babu boanaꞌi lime gehesa hite yege fiꞌahana. To enali ana boanaꞌi enekesaꞌubago higo enelesaꞌani luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ya hago Pitau bu enogoloto kaga ma luto ana boanaꞌi lu epiꞌehina: Isilaeli Nagaꞌise. Hena hibe lite yaꞌmanalo lenekesa yigi babu nelabe? Lenali henaꞌmu leꞌaliꞌi buluꞌi neheꞌahabe? Etaliꞌatiti amuyaꞌatitiloti ma bo lusa gi etaꞌigo kapo nemalabe lite nekehelifihe? Oꞌe, ya huto meniꞌibe. ");
INSERT INTO bef_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ai Abalaha to Isaka, to Yakopu hiti to lali tatatigi asagaꞌi enali Huꞌmaꞌanifu ai Yesu koko panaꞌamofihi giꞌa liyafa huꞌehina yabe. Ai yaꞌmana bo fatehaꞌamagi enayanuga epilago Pailatiu lu kehelito leꞌmo buto bito heꞌmi etalubeꞌmu hina lenali Pailatihi bulo lenemegesa hu emiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ai hetofa bo foipanaꞌa meniꞌina bomofihi lenali lenemegesa hu emiꞌahana yabe. Ya hilete lenali fato bo moneuba bo mone ho filiꞌehina yaꞌma bo limibo lite Pailatihi kehe igo ai leꞌmo lepiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ai hetofa bo kapo batiꞌa lelepito mino kosaba huse hepato leleꞌmoto bilubeꞌmu nohina bo lenali ho filiꞌahabe. Ya hilago Huꞌmau akuꞌi kene keliguti leꞌmo ho tiꞌehina, leꞌali yaꞌmananamofihi kagaꞌa lu yege hose bole nohuꞌibe. ");
INSERT INTO bef_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","To leꞌali Yesutoga komopatiꞌa moloto leꞌemehi emiꞌohuꞌibe. Yaꞌmu luto Yesuhi giꞌauba ma gigusa sibina nohina bomofihi leꞌmo amuya nomalago lenali kehelilete bu go bati nehabe. Yesutoga komopatiꞌa emito leꞌemehi emiꞌohuꞌina Huꞌmamofitogati leꞌalitoga oꞌehinauba yaꞌma amuyana hetofana aitogati oto lenali lenubulo huto nohigo asagaꞌi bu go baga neibe. ");
INSERT INTO bef_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nalaluꞌnigita maꞌnaka lite lenali hiti to kaba botinimagi hiti lenali ka keheli bati huseꞌnatini meniꞌigo yaꞌma suhi li huto hiꞌahabe. ");
INSERT INTO bef_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ya hiꞌahana koyapaꞌi Huꞌmau kaga mone ma luto kaga lu yege hose bomagihi enabagalo luꞌehina, Mesiaꞌnifu ai gabu giseꞌna li kofilibe. Ya luꞌehinalo lenali yaꞌma suhi li huto hiꞌahanauba ana kaga baga iꞌehibe. ");
INSERT INTO bef_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ya huꞌehinagi lenali komopatini i gelehe hinogo ai Huꞌmau foipanatini kele li heꞌmi lepalalibe. ");
INSERT INTO bef_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ya hite nehinogo kana monelugu Sipi Bouba yuhufa amuya lepilibe. Ya huloto Mesiahi lenalitoga ho lifilibe. Yaꞌmana bo Huꞌmau koyapaꞌi leꞌmo ho tiꞌehina, ai Yesu yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ai yatai kokulumalugu nohuto mone yupahi Huꞌmau asagaꞌna kokulumagu hiti melugu hiti niꞌinana leꞌmo kosaba hilina kanaꞌa geba hilinaꞌmu yabe. To koyapaꞌi kagaꞌa lu yege holata bomagi enabagalo Huꞌma luꞌehinaꞌa huto yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moseu ma luto luꞌehina: Sipi Bo ai Huꞌma afotinifu nohibe, ai naniꞌi huꞌehina suhi luto kaga lu yege hose bo mone ho lifinogo lenalitiniguti huto hilinaꞌmu yabe. Ai asaga kaga lu lepilinamofihi keheli bati hite minalo. ");
INSERT INTO bef_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","To asaga boanaꞌi yaꞌmana bomofihi kagaꞌa keheli meemilana Huꞌmau enoho filinogo ai bonaꞌa hiti aku akuꞌi meminalanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","To Samueliu yagi to kaga lu huto huto bo lugaꞌa alihi ai megesalo huto hiꞌahanamagi enali asagaꞌi yatai kanaꞌamofihi kaga lu yege heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lenali kaga lu yege hose bomagihi yagapanaꞌani minalo. Koyapaꞌi Huꞌmau tatatinigitoga uleꞌale kaga moloꞌehina lenali li enebe sililata bonaꞌi yabe. Ai ma luto Abalahahi lu emiꞌehina: Kai tatakafitoti asaga melugu boanaꞌmagi lusa li baga ilabe. ");
INSERT INTO bef_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Huꞌmau koko panaꞌa leꞌmo ho tiloto lenali lusa lepilibe luto lenalitoga yataꞌa ho lifiꞌehina. Ai komopatini li gelehe huto foipanatini li heꞌmi lepalalube luto oꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitaugo Yoniugo etali sipi mono nonugu boanaꞌi kaga lu epite nehaꞌigo sipi mono noto kaba bo hiti to kimi bomagihi kaba boꞌani hiti to Satusi bonaꞌi enali analo eꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yesu filiꞌehinagati akuꞌi ho tiꞌehina ana suhi lite asaga filise bonaꞌi akuꞌi ho tilanaꞌmu yabe lite boanaꞌi lu epite nehaꞌinaꞌmu enali enitaluga logo biꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ya hilete enali etayato lite naga ite sinihi agilubeꞌmu nohigo nonuga eteleꞌme meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ya hana enali babu boanaꞌi etali kaꞌatiti akeheli bati hilete liyafa hite megeꞌi meleꞌahana. Enali yaꞌmana boanaꞌi asagaꞌi 5,000 yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yago etehaꞌa kaba boꞌani hiti babafi bonaꞌi hiti to keya kaga lu neepina bo hiti enali asagaꞌi Yelusale li gehesa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Enali sipi mono bonaꞌi enikibina Anasiu, to Kaiyafasiu hiti, to Yoniu to Alekasatau yagi asagaꞌi sipi kaba enikibina bo nagaꞌi li monekolugu ete li nupa he su heꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Enali enubulo Pitanogo Yoninogo eteleꞌmo ho tilete ma lite etoloka heꞌahana: Letali hena hite li huto nehaꞌibe? Hena huse amuyana liꞌehite li huto nehaꞌibe? To letali kiyiꞌafihi gi helete yaꞌmana suhi li huto nehaꞌibe? ");
INSERT INTO bef_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ya lite etoloka hago Pitatoga Sikalafuꞌuba bai tolago ai ma luto lu epiꞌehina: Lenali Isilaeli bonaꞌmagi kaba boꞌanise. To olopa babafi bonaꞌise. ");
INSERT INTO bef_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Leꞌali bo mone gigusaꞌa sibina huꞌehina yatai leꞌmo bati huꞌohuꞌinamofihi leꞌoloka helete yaꞌmana bo hena huto bati huꞌehifi lite keheli bati hiluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ya hiletemo lenali asagaꞌi hiti to Isilaeli nagaꞌi hiti yaꞌmanana keheli bebe salo. Yesu Kilisitou Nasalete Bo ai giꞌalo ma bomofihi gufaꞌa amuya moloto bati huꞌehibe. Ya higo ai folagahatinigu yatai lenubulo ho tiꞌehibe. Lenali Yesuhi malipu yafalo hago filiꞌehinamoya Huꞌmau akuꞌi kene keliguti leꞌmo ho tiꞌehibe. ");
INSERT INTO bef_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesuhi ai kumu luto mono bukulugu ma luto niꞌina yabe: Efaha nohi gilata bomagita laga melepesina efahuba alihaꞌa sipi huto huto hetofa amuya efahi lolo hulata nohibe. ");
INSERT INTO bef_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bo mone fatoꞌi nohinauba meleheꞌmalinaꞌmu yabe. Yesu aiꞌasigoko leleꞌmo lubuto bilata bo nohibe. To asaga hepaꞌi niꞌinalogati mone gihiti bo fatoꞌi lubuto biloto leleꞌmalibe luto Huꞌmau leꞌmo huto mehuꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pitaugo Yoniugo etali koli mehise amuya melete kaga lu yege haꞌina enali bu geꞌahana. To etali babafi bomaleꞌi meminaꞌina faꞌmene bole nehaꞌibe lite kanisole bomagi akeheliꞌahana. Yaꞌmu lite enali kaba kanisole bomagi enekesa yigi babu lilete ma lite akeheliꞌahana, koyapaꞌi etali Yesuhi megeꞌi melete moneka mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","To etali gufaꞌa leꞌmo bati hiꞌahaꞌina bo hiti moneka ho tite nehago be gelete yaꞌmu lite enali kanisole bomagi etali laꞌina kagaꞌatitilo nonaꞌa mone meliꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ya hilete enali kanisole bomagi nonugati eteleꞌmo fegutoga heꞌmigo nelimiꞌigo enaliꞌani musi musi ka ma lite liꞌahana: ");
INSERT INTO bef_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ma bole hena hu etatalune? Asaga Yelusale bonaꞌmagi etali topa hoꞌehinanamo yaꞌma sipi foya mone li huto huto hiꞌahaꞌinamofihi kagaꞌa akeheli su heꞌahanamofihi lali bahane mehalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yaꞌmu luto etali yaꞌmana kaga fato fato hepatoga boanaꞌmagihi lu epimofaꞌna mehiliyo, to letali Yesuhi giꞌa aku akuꞌi moneꞌa hiti helete boanaꞌi kaga lu meepiliyo luto etegekesa bilune liꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ya lite kaga lu kehelilete Pitanogo Yoninogo akuꞌi nonuga kehe ite eteleꞌmete tilete ma lite lu etimiꞌahana: Letali aku akuꞌi Yesuhi giꞌa helete ai giꞌalo boanaꞌi enelepilata lu meepiliyo lite etegekesa biꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ya lite lago Pitaugo Yoniugo ma lite kanisole bomagihi kaꞌanilo lu epiꞌahaꞌina: Lenalitini loko hite hiya kagauba Huꞌmamofihi bulo bati hilifi lite kehelilo. Lenali kagamofihi megeꞌi malaluꞌifi to Huꞌmamofihi megeꞌi malaluꞌifi lenaligo kehelilo lite liꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","To leꞌali kaga lu yege hoseꞌnatiꞌa meheꞌmiluꞌinaꞌmu yabe. Asagaꞌna leꞌubulo huto higo bu goꞌohuꞌinanamofihifi to leꞌekesatuꞌi keheliꞌohuꞌina leꞌali lu yege homofaꞌna hiluꞌinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ya lite laꞌigo enali kanisole bonaꞌmagi amuya melete kaga lu etetelete eteleꞌmo heꞌmiꞌahana. Enali nagaꞌi etimilana kaga li huto mehiꞌahana yabe. Henaꞌmugope asaga boanaꞌmagi huto hu enubulo moloꞌehinamofi kumu lite Huꞌmamofitogago enegelo bi emite giꞌa liyafa hanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","To Pitaugo Yoniugo topa hoꞌehinamo sipi liliꞌna li huto hite leꞌmo bati hiꞌahaꞌina bo ai koyapa bo kufuꞌa 40 li heꞌmiꞌehina bo yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitanogo Yoninogo eteleꞌmo heꞌmina ana kanaꞌasilo etalaluꞌatitigi nehanaga bilete asaga kaga kanisole bonaꞌmagi lu eteteꞌahana enaliꞌi beto hu epiꞌahaꞌina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ya hilaꞌigo enali asagaꞌi akehelilete komopaꞌani monetoga melelete ma lite Huꞌmamofitoga nunumu hiꞌahana: Sipi Bo, kai kokuluma hiti meꞌi hiti to hege nagamiꞌi hiti to asagaꞌna sigina mehinanalo niꞌina kaika lolo huꞌahata yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Koyapaꞌi Sikalafu kagu kaga mone ma luto Tebitiu ai koko panaka lali tatatifihi bagalo luꞌahata yabe: Enali fegutoga bonaꞌi henabe lite enitaluga logo bilata nohigo, lali nagatimagi sibi sibi enekesa fato fatoꞌi neyigibe? ");
INSERT INTO bef_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Enali enikibina bo asaga noto noto hepatogati ho ti baga to sipi bo hepato hepato mino baga iꞌahana to ti su helete Sipi Bo Huꞌma hiti to Mesiaꞌafi hiti enemegesa hu etimite eteleꞌmo melugu malalune lite ho ti baga ilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yaꞌma Tebitiu koyapaꞌi ya luꞌehinagi to lusiga maꞌnaka luto Helotiugo Ponitiasi Pailati hiti enali fato nagaꞌa hiti to Isilaeli bonaꞌi enali Yesuhi leꞌmo melugu malalune lite moneko ma hepalugu li nupa hiꞌahana, yaꞌma koko panaka manaꞌa koyapaꞌi leꞌmo moloꞌahata yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Enali asagaꞌi monekolugu li nupa hilete asagaꞌna koyapaꞌi li huto hilabe luto amuya kaga luꞌahata ai anana huto hilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oho, Sipi Bo, amuya kaga asagaꞌi liꞌahanamofito kai yatai kehelibo, ya huloto lali kai koko pananaka leheꞌmobo. Ya huꞌehitogo lali amuya moloto koli mehuse kai kagaka lu yege ho ketalune. ");
INSERT INTO bef_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","To kai kayahaka li saga huloto enebesise bonaꞌi eneleꞌmo bati nohuto to topa hoseꞌna fato fatoꞌi to sipi liliꞌna koko panaka hetofaꞌa Yesuhi ai giꞌalo li huto hubo. ");
INSERT INTO bef_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Enali ya hite nunumu ahilago li nupa hite nehana nonugu imimaꞌi liꞌehina. Ya huloto enali to Sikalafuꞌuba tito bai tolago enali Huꞌmamofihi kagaꞌa lu yege homofaꞌna hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Huꞌmamofitoga komopaꞌani emite minana bonaꞌi enali moneko kaga liyafa hite mineꞌahana. To bo moneuba ai feꞌnohaꞌalo bu goloto naniꞌni nasanaꞌni niꞌibe luto meluꞌehina. Asaga feꞌnohaꞌa enali asagaꞌi nehanamagi enaliꞌna hiti li baga iꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Enali aposolo nagaꞌmagi Sipi Bo Yesu filiꞌehinagati akuꞌi ho tiꞌehinamofihi kagaꞌa lu yege nehago ana kaꞌaniuba amuya sipi moloꞌehina yabe. Ya hago Huꞌmau fuluna enalitoga epi baga ito hetofa lu epoloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bo mone enali folagahaꞌaniguti noseꞌnamu fito feꞌnohaꞌamu sa mehuꞌehina yabe. Enali meꞌani hiti to nohaꞌani hiti niꞌinamagi fato bonaꞌi efaloti neepite enali ana efahi lite bite, ");
INSERT INTO bef_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposolo nagaꞌmagihi epigo enali guna ite enemeto enemeto hite epilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ya hite minanagu bo mone minoꞌehina ai giꞌa Yosefe. Enali aposolo nagaꞌmagi Banabasio lite fato gi meleꞌahana. Yaꞌmana gimofihi hapaꞌaya ma luto niꞌibe, ai amuya kaga lu epito enekesa bilata bo yabe. Ai Libai nagaluguti Saipalasi hepato bo yabe. ");
INSERT INTO bef_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","To aiꞌa meꞌa nesiꞌa fato bomofihi noemito efahi liloto ana efahi lito buto aposolo nagaꞌmagihi epiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bo mone minoꞌehina giꞌa Ananiasi, to lihaꞌamofihi giꞌa Safaila. Ananiasiu bo moneꞌmofihi meꞌa noemito efahi aitogati liꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ya huloto lihaꞌa hiti lu kehelilete efahi lugaꞌa etaliꞌatiti fala nekite lugaꞌa lite bite aposolo nagaꞌi epiꞌahaꞌina. ");
INSERT INTO bef_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ya haꞌigo Pitau ma luto luꞌehina: Ananiasio, henaꞌmu Satau kai komopakagu tilago Sikalafuꞌi miꞌi moloto faga luloto efahi lugaꞌa li fala kiꞌahane? ");
INSERT INTO bef_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Koyapaꞌi ana meꞌi mina mefiꞌahago, yaꞌmana kanaꞌalo yaꞌmana meꞌi kai meꞌi minoꞌehina yabe, to ana meꞌi bonaꞌi noepito efahi litogomo ana efahi kaiꞌnaka lolo nohibe. Komopakagu henabe luto kehelito yaꞌma suhi li huto hane? Kai laliꞌi limiꞌi memoloꞌahata Huꞌmamofihi miꞌi moloto faga lu emiꞌahata yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasiu ana kaga keheliloto anaꞌasilo fililoto melugu limito koꞌehina. Ya higo enali ya hinamofihi kagaꞌa kehelina bonaꞌi nelesaꞌani gofa luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","To enali neheya kola bomagi ho tilete gukete li hekele telete leꞌmete bite keli heteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ya hilete nesiꞌa mino yatama nehago Ananiasihi lihaꞌa oto nonuga tiꞌehina. To ai anana huto huꞌehina mekeheliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ya higo Pitau lu emiꞌehina: Lu nimibo, metitiloti efahi liꞌahaꞌina yaꞌmasi anasi niꞌifihe? Luto ligo, Oꞌyo. Anasi ya liꞌohuꞌina yabe luꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ya ligo Pitau lu emiꞌehina: Kai hiti bahaka hiti letali henabe lite lu kehelilete Sipi Bomofihi Sikalafuꞌa miꞌi meleꞌahaꞌibe? Bahaka akeli he eteꞌahana bonaꞌi yatai maꞌasi kasito foiya nehanago enali kaiꞌi ana hite kofite bilanaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ya luto Pitau noligo anaꞌasilo fililoto gigusaꞌagu limito koꞌehina. Ya higo enali neheya kola bo lite bu gana ana aꞌi filiꞌehigo bu gelete kofite bite bahaꞌa keli heꞌahana yaꞌma belehaꞌalo keli heteꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Asaga Huꞌmamofitoga komopaꞌani emiꞌahananamagi to lugaꞌa fato fato boanaꞌmagi hiti anana huto huꞌehinamofihi kagaꞌa keheli baga ilete enelesaꞌani sipi luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Enali aposolo bomagi topa hoꞌehinana babeyafana fato fatoꞌi babu lite boanaꞌmagi folagahaꞌanigu li huto hiꞌahana. Ya hago enali Huꞌmamofitoga komopaꞌani emite minelata hanamagi enali asaga yupahi utehi etehi Solomonihi Nosipenugu li nupa hilata hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Enali mone lugaꞌa Huꞌmamofihi komopaꞌani emiꞌahanamagi koli hilete enali hiti ete li nupa mehiꞌahana yabe. Yaꞌmu lite enali boanaꞌmagi enofokehi helete lusi kaga lu epeleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ya hana babu boanaꞌi Sipi Bomofitoga komopaꞌani emiꞌahana nehanalo lugaꞌa yuhufa babu lite ete ikele ikele hiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ya nehago enali boanaꞌmagi enebesiꞌehina bonaꞌi ukogu eneleꞌmo melelete kapolo fato fato ukogu ko epeleꞌahana yabe. To Pitau kapo moloto nobinogo ai mehaꞌauba enebesise bona lugaꞌamagihi enugufalo heleko melenogo ye kalabe lite yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yelusale hepa kegiꞌati babu bonaꞌi li nupa hite neete enebesise bonaꞌanifi to foipa fele komopaꞌanigu minana hiti eneleꞌmete ana bonaꞌi ye ke su heꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","To ya higo mono sipi kaba bo hiti to asaga bonaꞌa hiti moneka mineꞌahana to enali Satusi nagaꞌmagi hiti enali asagaꞌi enipakafa sipi heꞌahana. Enali enegekesa kehelilete naga epilune lite lu keheliꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Enali aposolo bonaꞌi enayato lite sipi naga nonugu eneleꞌme meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ya hilago ana foluguꞌi Sipi Bomofihi ageloꞌauba naga gegisa li hokolo huloto aposolo bonaꞌi eneleꞌmo fegu toloto ma luto lu epiꞌehina: ");
INSERT INTO bef_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Lenali bite sipi mono nonugu ho tilete hetofa kapomuꞌi lite bonaꞌi ka lamanaꞌa lu epilo. ");
INSERT INTO bef_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposolo bonaꞌmagi kaꞌa liyafa hilete foluguꞌi goꞌi yuhufa noligo sipi mono nonugu tilete hapi fite ka enelepite mineꞌahana. To sipi mono noto kaba bo yagi laluꞌagihi kehe i nupa huloto kanisole bonaꞌi hiti Yuta bonaꞌmagi olopa boꞌani hiti ete li gehesa hiꞌahana. Ya hilete aposolo bonaꞌi naga nonugati eneleꞌmete alabe lite enoho lifiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Enoho lifiꞌahana bonaꞌmagi naga noto nehetilete aposolo bonaꞌi menehago sa hiꞌahana. Ya hilete enali i behe hite bite kanisole bonatoga ma lite lu epiꞌahana: ");
INSERT INTO bef_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Lali naga noho kasito nehetito bu gota kasihaꞌa amuya melete loki helete kaba bo kasito gimi gi baga ite mineꞌahabe. Ya huloto lali kafe sigito bu gota anagu bonaꞌi memineꞌahana afele su heꞌahana. Heꞌahago bu goloto noone. ");
INSERT INTO bef_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ya lite lago enali sipi mono noto kaba bo hiti to enali sipi mono noto gimi bonaꞌmagi hiti aposolo bonaꞌi hena hiꞌahafi lite enegekesa yigi babu liꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ya nehago bo mone nehetinauba ma luto lu epiꞌehina: Kehelilo. Lenali naga nonugu eneleꞌmo meleꞌahana bomoya sipi mono nonugu ho tite nehite boanaꞌi kaga neenelepibe. ");
INSERT INTO bef_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ya lite lago enali mono noto gimi bo yagi to lugaꞌa gimi boꞌa hiti eneleꞌmo mege toloto buto aposolo bonaꞌi sipi mono nonugati eneleꞌmete eꞌahana. Enali gimi bomagi aposolo bonaꞌi osahi meepise eneleꞌmete eꞌahana yabe. Henaꞌmugope aposolo bomagi kagaꞌanilo kehelite nehana bonaꞌmagi enitaluga logo binogo efa kosatuꞌi legene ite loho fililafi lite enelesaꞌani ligo yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Enali gimi bomagi aposolo bonaꞌi eneleꞌmete ete kanisole bonaꞌmagi folagahaꞌanigu eneleꞌmo ho tiꞌahana. Ya hilago sipi mono noto bomagi kabaꞌaniuba ma luto enoloka hoꞌehina: ");
INSERT INTO bef_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Lenali boanaꞌmagitoga Yesuhi giꞌa helete kaga lu meepilo luto uleꞌale ka luto laga hu lepoloꞌohuta yabe. Ya huꞌohuto bu galo, lenali kagaꞌtinimouba asaga Yelusale hepaꞌmogu bu baga iꞌehibe. To lenali lali kaluga lilete Yesuhi enali ho filiꞌahana yabe liluneꞌmu nehabe. ");
INSERT INTO bef_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ya lite lago Pitau yagi to lugaꞌa aposolo bomagi kagaꞌanilo nonaꞌa lu epiꞌahana: Lali bonaꞌmagi kagaꞌanilo enemegeꞌi memalaluta, Huꞌmamofihi ai kagaꞌasigo megeꞌi malalutaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lenali Yesuhi malipu yafalo hu so kilete malipu yafalo ho filiꞌahana lali tatatigi Huꞌmaꞌanifu ai akuꞌi leꞌmo ho tiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Huꞌmau leꞌmoto tito yahi lamagaꞌaga moloꞌehigo nohibe. Lali Isilaeli bonaꞌmagita kaba boti leheꞌmalube luto nohinago lali aitogago komopati emito aitoga binogo foipanati li heꞌmi letalinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Asaga yaꞌmananamofihi kagaꞌa lu yege hose bo lali nohune, to Sikalafuꞌuba hiti yaꞌmana kaga lu yege nohabe. To yaꞌmana kaga keheli komopaꞌanigu malana boanaꞌi Huꞌmau Sikalafuꞌa enalitoga nomalabe. ");
INSERT INTO bef_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Enali kanisole bonaꞌmagi aposolo bomagi lanaga kehelilete enitaluga logo bigo enoho fililuneꞌmu hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ya hago kanisole bonaꞌmagihi folagahaꞌaniguti bo mone ho tiꞌehina. Ai giꞌa Gamelieliu, Felosi bo yabe. Ai keya ka lu enelepilata bo, to enali asaga boanaꞌmagi ya nohinanaꞌmu lite sipi fokehi lilata nehana, ai aposolo bonaꞌi enoho lifigo fegutoga limiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ya nehago ai kanisole bonaꞌi ma luto lu epiꞌehina: Isilaeli nagaꞌise. Lenali ma bomagihi enugufalo li huto hiluneꞌmu nehananalo lenali lenegekesa yigi fe lilete li huto hilo. ");
INSERT INTO bef_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lenali akeheliꞌahabe. Kohe kanagu Teutasiu ho tiloto ma luꞌehina yabe: Nani amuyaꞌni hiti bo nohube. Ya luto ligo 400 bonaꞌmagi megeꞌi meleꞌahana yabe. Ya higo gamani bouba ho fililago asaga bonaꞌi megeꞌi meleꞌahanamagi tili tele hite bula ola nehago aiꞌa liliꞌnaꞌa li huto huꞌehina fenene hale huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Alihi ai megesalo gamani bouba boanaꞌmagi enigi lina kanaꞌalo Yutasi Galili bouba ho tiloto lugaꞌa boanaꞌmagihi kaga lu epigo ai megeꞌi ana suhi meleꞌahana. Enali ho tilete megeꞌi melete gamani bonaꞌi hiti luba hite eneleꞌmo heꞌmiluneꞌmu hiꞌahana. Ya hina ai ana huto fililago megeꞌi malana boanaꞌi tili tele hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ya huꞌehinagi nani yatai lu nolepube. Lenali yaꞌma bomagihi koliꞌani hiletetini heꞌmi epelenogo mineno. Yaꞌma liliꞌnamofihi hapaꞌa faꞌmene bonaꞌmagi nelinogomo sibina huto fenene hilibe. ");
INSERT INTO bef_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","To Huꞌmau yaꞌmana liliꞌnalo kaba huꞌehinogomo lenali laga mehi epalalanaꞌmu yabe. To lenali Huꞌmau hiti luba hite neminana bonaꞌi lolo hi lalabeꞌmu lu nolepube. ");
INSERT INTO bef_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ya luto ligo kanisole bonaꞌmagi kagaꞌa megeꞌi meleꞌahana. Ya hilete aposolo bonaꞌi kehe ilete naga osatu enibi yigiꞌahana. To enali amuya ka epekite aku akuꞌi Yesuhi giꞌa helete kaga lu epimofaꞌna mehilo. Ya lite lu epilete aposolo bonaꞌi heꞌmi epalago biꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposolo bonaꞌi enali kanisole bona nohi heꞌmilete fegutoga limilete enegelo biꞌahana. Henaꞌmugope, Yesuhi giꞌa lu yege hananalo Huꞌmau enagabu foya kofilabe luto ekesa keheliꞌehinalo yabe. ");
INSERT INTO bef_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","To asaga yupahi sipi mono nonugufi to enaliꞌani nohaꞌanilugafi li nupa hite minete boanaꞌi kaga lamanaꞌa enelepite to Yesu Huꞌmau leꞌmo ho tiꞌehina bomofi kumuꞌi lu epiba lu epiba hite mineꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yaꞌmana kanaꞌalo ka lamanaꞌa megeꞌi malana bonaꞌi lugaꞌa babu lite ete ikeleꞌahana. To lugaꞌa ka lamanaꞌa megeꞌi malana bonaꞌmagi Giliki nogo nehanamagi enali lugaꞌa Hibulu nogo nehanamagi ka epekiꞌahana. Ma lite liꞌahana: Lenali asaga yupahi noseꞌnaꞌani meniꞌina boanaꞌi eneheꞌmelata nehanaya to keto anaꞌi enemegesa hu epite meneheꞌmelata nehabe. ");
INSERT INTO bef_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ya lago 12 aposolo bomagi lugaꞌa boanaꞌi enemegeꞌi malana kehe i nupa hilete ma lite lu epiꞌahana: Lali Huꞌmamofihi kagaꞌa lu episeꞌna heꞌmiloto boanaꞌmagi noseꞌna guna ito epimofaꞌna hiluta bati mehilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nigibo nagabose. Lenali nayahi mone kegiꞌa su hago mone kegiꞌati loemo heleko melenogo lenali folagahatiniguti eneleꞌmo ho tilo. Enalitoga Sikalafuꞌuba bai tago kaga keheli bati hiꞌahago boanaꞌmagi enali kumuko nelilana bo yabe. Ya hilete yaꞌmana bo eneleꞌmo melenogo yaꞌmana liliꞌna kaba hite lilabe. ");
INSERT INTO bef_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ya hinogo laliti nunumu huseꞌna hiti to boanaꞌi kaga lu yege hoseꞌnamofihi liliꞌnaꞌasigo li eto huto lito bilune. ");
INSERT INTO bef_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Asaga boanaꞌmagi aposolo bonaꞌmagi lu huto hana kalo enegelo biꞌahana. Ya hilete Sitifenitoga Sikalafuꞌuba bai tana bo leꞌmo ho tiꞌahana. To Filipiu yagi Polokolu yagi Nikeno yagi Timoni yagi Pamenasiu yagi to Nikolasiu ai Atioki hepatogati fegutoga bo Yuta bonaꞌmagi mono kagamofitoga komopaꞌa moloꞌehina bo hiti eneleꞌmo ho tiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Enali yaꞌmana bo li nupa hite ete aposolo bonaꞌmagi nagaꞌmagi enubulo ho tigo enali ana bomagihi enugufalo enayahi li saga hite melelete nunumu hi epelete lusana epiꞌahana lusa gi epeleꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","To Huꞌmamofihi kaga fato fato hepato leliꞌali hago bu baga iꞌehina. Ya higo babu boanaꞌi lugaꞌa hiti Yelusale hepatogati komopaꞌani i gelehe hite Huꞌma kagaꞌa liyafa hiꞌahana. To enali sipi mono noto kaba bonaꞌi lugaꞌa babu lite ana hite komopaꞌani i gelehe hite ka lamanaꞌa megeꞌi meleꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitifenitoga Huꞌmau Sikalafuꞌa emilago amuya sipi liloto boanaꞌmagihi folagahaꞌanigu babeyafana fato fatoꞌi li huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ya nohigo lugaꞌa bomagi ho tilete ai kagaꞌa pelesa iꞌahana. Yaꞌmana bonaꞌi enali Yuta bonaꞌi fato mono ka nekehelina bo, enali fato monoꞌani Lali Foyati yabe lite giꞌa helata nehabe. To enali Sailini hepatoti yagi Alekasatilia yagi, to moneꞌamagi Silisia yagi to Esia, asaga yaꞌma hepatogati ete li nupa hite nehana bomagi yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sikalafuꞌuba kaga bati hinaꞌago Sitifenihi lu bagalo malago ana bomagi lana kagaꞌaniuba ai kagaꞌa be meligiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ya hilete yaꞌmana bonaꞌmagi bati mehina suhi li huto hilete fato bonaꞌi moneꞌamagihi enekesa bigo enali ma lite liꞌahana: Ai Mosenogo Huꞌmanogo etigi holoto kiya yokolo ka lu etotoꞌehibe. ");
INSERT INTO bef_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Enali ya lite lana kagauba asaga boanaꞌi to keya ka enelepilata bo hiti to olopa napa bo enali enipaluga lu boyogo fiꞌahana. Ya hago enali Sitifenitoga bite yato lite leꞌmete bite mono kanisole bonaꞌmagitoga leꞌmete biꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","To enali faga faga lu melete ka foya li etalana bonaꞌi lugaꞌa eneleꞌmo meleꞌahana. Yaꞌmana bomagi ma lite liꞌahana: Asaga yupahi yaꞌma bouba suguna mono nohatimofi hiti to Moseu keya ka liꞌehinamofi kumu luto kaga lu sibina hulata nohina yabe. ");
INSERT INTO bef_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Lali keheliꞌohunogo ma luto luꞌehina yabe: Yesu Nasalete bouba yaꞌma hepaꞌi sipi mono nohi tele bito li foipa loloto koyapaꞌi Moseu limigo ana suhi lilata nohuta ai li noheꞌmito fato suhi lepilunaꞌmu yabe luꞌehibe. ");
INSERT INTO bef_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ya lago asaga bonaꞌi kanisolelugu mineꞌahanamagi Sitifenihi buluꞌi heꞌahana. Ya nehago Sitifenihi okabaꞌa agelomofihi suhi lito i besa loꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sipi mono noto kaba bouba Sitifenihi loka hoꞌehina: Enali maꞌnaka nelafihe? ");
INSERT INTO bef_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ya luto loka hago Sitifeniu lu emiꞌehina: Nogoꞌnigita afoꞌnigita kehelilo. Huꞌmau fana mehaꞌa hiti bouba koyapaꞌi tatatifu Abalahau Halani hepato mebuꞌohuto Mesopotamia hepato minana kanaꞌaluga nehetito bulo huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ya huloto ma luto lu emiꞌehina: Kai meka hiti to kogokagi afokagi heꞌmi epololoto nani meꞌi mone kelepilubeꞌmu nohunalo bubo. ");
INSERT INTO bef_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ya luto lu emigo Abalahau Kalitia meꞌi heꞌmiloto Halani buto minoꞌehina. Alihi Abalahahi afoꞌafu fililago yatai ma nehana hepato Huꞌmau leꞌmo moloꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Huꞌmau: Kaika meꞌi yabe luto Abalahahi nesiꞌa loko huto melepiꞌehina yabe. Alihi ma meꞌi kiminogoꞌni liꞌehitogo yagapanaka ana hite huto alihi hilanamagi mana meꞌi molo lilanaꞌmu yabe luto Huꞌmau lu emiꞌehina. Abalahahi yagapanaꞌa memineꞌahana kanaꞌalo yaꞌmana kaga Huꞌmau lu molo etoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Huꞌmau ma luto luꞌehina: Yagapanaka nagaꞌi fato bonaꞌmagi melugu minalanaꞌmu yabe. Ya hiꞌehinogo meꞌi hapaꞌa bonaꞌmagi kai yagapanaka koko kako panaꞌani eneleꞌmoloto hilenogo 400 kufuꞌa bilinaꞌmu yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ya hilenogo alihi nani yaꞌmana bonaꞌi kai yagapanaka eneleꞌmo koko kakoꞌani lolo hiꞌahana bonaꞌi nani ka foya li epoloto osahi epilube. To lihaꞌa kai yagapanakamagi yaꞌmana meꞌi heꞌmilete bilabe. Ya hilete enali alihi elete maꞌasi niꞌina meto ete naniꞌi komopaꞌani nimite nunumu nama lilabe luto Huꞌmau luꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ya luto luloto Huꞌmau enugufa laga huseꞌmofihi moneꞌna kaga Abalahatoga moloꞌehina. To alihi minoto Abalahau panaꞌa Isakahi ketoloto ai nayahi mone kegiꞌa su hoto mone kegiꞌati loegi monegi leheko malana kanaꞌa minoloto gufaꞌa laga hu etoꞌehina. Isakau ai Yakopuhi afoꞌafu, to Yakopu 12 tatatigi afoꞌanifu minoto ana huto enugufaꞌanilo laga hu epoloꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Enali tatatigi Yosefehi ipakafa helete fato bonaꞌi leꞌmo neepite efahi liꞌahana yabe. Ya hago Iyipi metoga leꞌmete biꞌahana. To Huꞌmau ai hiti moneka minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ya huto asaga ketana aitoga huto huꞌehina. Aitoga fuluna emito ka keheliya iseꞌna kibina bo Felo ai okabaꞌalo bulo emiꞌehina. Ya higo Iyipi gamani bomagihi kaba boꞌani hiti to ai nohaꞌagu asaga feꞌnohaꞌalo hiti kaba gimi gilibe luto Felou Yosefehi leꞌmo moloꞌehina ho tiꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ya hulago Iyipi me kegiꞌa hiti Kena me kegiꞌa hiti noseꞌna minigigo sipi kauꞌna heꞌahana. To enali tatatigi noseꞌna nalananaꞌmu sa sa hiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yamuꞌi Iyipi melugu noseꞌna niꞌibe lite lana kaga Yakopu keheliloto tatatigi enoho lifigo yataꞌa yupahi ana hepato nehetiꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Alihi akuꞌi ana hite nebago Yosefeu goꞌagihi kaga lu hokolo huto nani Yosefeita lu epiꞌehina. To ya nohigo Felou Yosefehi nagaꞌa ana yupahi bu enogoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefeu afoꞌafu Yakoputoga kaga moloto kai hiti to asaga nagaꞌi Iyipi alo luto ligo biꞌahana. Enali 75 boanaꞌi eꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ya luto kaga malago Yakopu Iyipi melugu limito minoto anaga filiꞌehina. To tatatigi hiti ana hite ana melugu filiꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","To alihi enali felisaꞌani Sekeme hepatoga lite bite koyapaꞌi Abalahau mone meꞌi nesiꞌa Hemoho panaꞌamofitoti mina fiꞌehina melugu mulilugu keli heꞌahana. ");
INSERT INTO bef_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Huꞌmamofihi kana alo yaꞌmana li huto hilubeꞌmu hilina, yataꞌa Abalahatoga yama li huto hilubeꞌmu nohube ligo keheliꞌehina supomofihi kanaꞌa yatai ahuto hilubeꞌmu nohibe. Isilaeli nagaꞌi hofa telete sipi hite Iyipi melugu pulu tite babu nelabe. ");
INSERT INTO bef_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Alihi kibina bo Iyipi melugu huto huloto kaba huꞌehinauba Yosefehi giꞌa mekeheliꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yaꞌma kibina bouba ai bonati eneleꞌmo bati mehuꞌehina yabe. Ai bati mehina suhi tatatigitoga li huto huloto fitu fo epoloto amuya kaga ma luto lu epiꞌehina: Yagapanatini nonugati heꞌmite fegutoga eneleꞌmo melenogo enali fililabe. ");
INSERT INTO bef_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ya hina kanaluga Mosehi itoꞌafu ketoꞌehina. Ai hetofa panaꞌi nohigo Huꞌma lagaꞌa besiꞌehina. Itoꞌafugo afoꞌafugo fala kite nonuga kaba hi etaꞌigo ikahi loegi monegi bu filiꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Alihi leꞌmo fegu telago Felohi paꞌauba leꞌmoto buto aiꞌa panaꞌa legi huto kaba hu etoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","To Moseu Iyipi bonaꞌmagihi keheliya iseꞌnamo yaꞌma asaga kaga keheli su hose sukulugu buloto amuya kaga noluto liliꞌna amuya moloto nolito sipi bo huto huloto minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Alihi Mosehi kufuꞌa 40 bulago Isilaeli bonaꞌi laluꞌagihi buto bu enagalube luto ekesa keheliloto buꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Iyipi bo moneuba Isilaeli bomofihi kaga lube sibina hube nohu etago bu goloto Isilaeli bomofitoga moloto Iyipi bo nonaꞌa emito ho filiꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosehi ai nagaꞌamagi ma lite enekesa kehelilafi luto ai keheliꞌehina yabe. Yaꞌma bouba Iyipi bonaꞌmagi enayanuguti leleꞌmo lubuto bilifi lite keheli bebe salafi luto keheliꞌehina. Enali keheli bebe meseꞌahana yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nohi koto ete kaga Moseu ana huto Isilaeli bo loemo luba nehaꞌigo bu etogoꞌehina. Ai ana bole eteleꞌmo baba ilubeꞌmu huloto ma luto lu etimiꞌehina: Nalaluꞌnileꞌita letali moneko nagaꞌmo nehaꞌina letali letugufagu hena luba nehaꞌibe? ");
INSERT INTO bef_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ya noligo ai gonaꞌa nohana bouba Mosehi leꞌmo felu holoto ma luto lu emiꞌehina: Kuyuꞌafu lu ketago kai kabatiꞌa minoto leꞌali kaga loko hilubeꞌmu nohane? ");
INSERT INTO bef_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","To yago Iyipi bo mone ho filiꞌahata ana supo luto yatai naniꞌi nahalubeꞌmu nolapihe? ");
INSERT INTO bef_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ai ya luto lina kaga Moseu keheliloto koli huto Mitia melugu buto minoloto anaga lihaꞌa liloto panaꞌa loemo eteketoꞌehina yabe. ");
INSERT INTO bef_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","To 40 kufu kana bulago agelo moneuba Sainai kosa lebato ka meꞌi niꞌinalo nohigo bulo huꞌehina. Agelouba logo guluya mehaꞌagu ufehaꞌa hiti yafa lagasoꞌagu minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moseu ana logo guluya mehaꞌa bu goloto topa holoto hena suhi nolifi luto bu go bati hilubeꞌmu anaꞌasilo bu leba toꞌehina. Ya huloto Huꞌmamofihi nogoꞌa keheliꞌehina: ");
INSERT INTO bef_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nani tatakamagihi tataꞌanifita yabe. Abalahagi Isakagi to Yakopugi Huꞌmaꞌanifita nohube. Ya luto ligo Moseu afoya iloto lesaꞌa ligo ana logo guluya mehaꞌa bu megose minoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ya nohigo Sipi Bo lu emiꞌehina: Ho tiꞌahata meꞌiya lamanaꞌa niꞌinagi kigigu biꞌahata suka kisi heꞌmibo. ");
INSERT INTO bef_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nani bonaꞌni Iyipi nehanamagi asaga enagabu liliꞌna nelina abu enogoꞌohube. Enali usegi asegi ite yibi nama nelana nani akeheliloto eneleꞌmo enubuto bilube luto alimiꞌohube. Yatai kai ho titogo Iyipi koho lifinogoꞌni bilane. ");
INSERT INTO bef_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yaꞌmana Mosehi Isilaeli bonaꞌmagihi enemegesa hu emiꞌahana yabe. Kuyuꞌafu keleꞌmo ho tigo kaba hu letoto kagati loko hilubeꞌmu nohane? Enali ya lite loka heꞌahana. Yaꞌmana bouba kaba boꞌanifi to eneheꞌmose bo yabe luto Huꞌmau ho lifiꞌehina yabe. Ufehaꞌa hiti yafa lagasoꞌagu agelouba logo guluya mehaꞌagu bu goꞌehinana yaꞌma keneꞌuba Mosehi heꞌmoꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ai Iyipi hepatogati eneleꞌmoto nobuto babeyafana hiti topa hoseꞌna hiti Iyipi melugufi Safa Nagami beletogafi to ka melugu hiti 40 kufugu li huto huꞌehina. ");
INSERT INTO bef_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yaꞌmana Moseu ma luto Isilaeli bonaꞌa lu epiꞌehina: Nani neleꞌmo huto huꞌehina bameto suhi huto li moloto kaga lu yege hose bo lenali folagahatiniguti leꞌmo ho tilinaꞌmu yabe luꞌehina. 