﻿USE sofia;
DROP TABLE IF EXISTS sofia.bea_vpl;
CREATE TABLE bea_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bea_vpl WRITE;
INSERT INTO bea_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hatseto mawotich oochu Jesus Christ, Tikeaootli ma chue; ");
INSERT INTO bea_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Takeh nichatinkles akehe koonachatya kehe, Oosooasi sakewotihche nachatyea atghuni oochu naaootle. ");
INSERT INTO bea_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hligi otyesta tike kemweh toowe ooli, Atghuni oochu ahasoonesun, aghahati tsiwoeseh kwetooyakehe. ");
INSERT INTO bea_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John tane tukeghingklit kemweh, hatse tane tatilon tunaghakeooskliti ahtilon otlwechi keochehlalon kehe aghametseli oneochetolel asilon. ");
INSERT INTO bea_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kahchu yinkhadeshalon tike okehe otsi Judaea, kahchu aghatane yateh otsi Jerusalem, kuihe sahke Jordan aghanetye tukukeghinklilon, koometselihi kooatuoochatihi. ");
INSERT INTO bea_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John ghatai manatsunne ghigheze gha eghayulon natun atyetlalon atazi syeh kahchu atazi syeh ihe nanihklulon: oohchu yaskesi yu achalinoo yu ayilai yetsetlon; ");
INSERT INTO bea_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Oochu toowe ooli yehtilon, yetsi ootelon, Hligi sooniya sataihchi anati, nakyeklule aghoo atu enasoo machi chunoostyeli mamakeoosut. ");
INSERT INTO bea_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Suni la tu ihe naghakyeihklit: ahwole atai tu ihe naghakyeihlili Atsinde Oochu ihe. ");
INSERT INTO bea_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Occhu gheise wazeluh ayi dzine, Jesus otsidesha Ion Nazareth Galilee otsi, John tuyakeghinklilon Jesus Jordan otsi. ");
INSERT INTO bea_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kwete tu tsi tghatyeza tsiwohzon, wailon yake kwa matahatsataghiolon, yakeotine yetsi natezalon oietli etye: ");
INSERT INTO bea_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Oochu otech yake otsi atitsuklon, toowela ooli oti ihe, Nila otaihchi nwasti Sachue. ");
INSERT INTO bea_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kwete atsinde achu tike tsi yatehalon kemwehchi. ");
INSERT INTO bea_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Koochi kemwehchi atu tane nuklechi tioketi dzineke kooali, yakaotehun Metseli aghaghatai; kahchu ghatai metseli ihkyateslon; kahchu oochu woei oochu yetsinatilon. ");
INSERT INTO bea_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kootoo John kwechaghinhtyilon tane kwechaghinhtyinti, Jesus yuhchidesha Galilee, koohootyeh otech oochu Nagha Tgha makaoonadzutti otsi, ");
INSERT INTO bea_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kahchu toowela ooli, Tyeneti Nagha Tgha kyeyi: naghametselihi kyechahli, oochu otech oochu aha kootahti. ");
INSERT INTO bea_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ihtyezon tu chok Galilee tghamweh klontyesha, yailon Simon yu Andrew yu mekye yu tyemil tayesklu tu chok: atai tane taesklu tane eli. ");
INSERT INTO bea_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Oochu Jesus toowela ooli yehti, Sakyetahtyel, kooh hanahooslihi oohchu hluge kehchi enahooslihi tane niyutooleli chon otsi. ");
INSERT INTO bea_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kwete taghatyemile echaghanelelon kikyehtyeshalon. ");
INSERT INTO bea_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Oohchu oontsutli tontyo tyesha, yaih James Zebedee machue, kahchu John mekye, atilon tachin ela ehkye atyi tyemil keyatinklulon. ");
INSERT INTO bea_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kwete tyechi yehtilon: kwa taghata echughanelilon tachin ela ehkye atyi Zebedee oochu keotihche yu, oohchu kikyetyesklit. ");
INSERT INTO bea_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oohchu kochi ghatyestyetl Capernaum; kahchu kwete taneghaotatyech kwa kwiya menejitti dzineneh tane chehotyeh. ");
INSERT INTO bea_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Oneghanintyellon yaotihche: kooatinti yaotatiheh otech oochu tatihi natsuti kehchi ayihoo mawoochuli, atu adeskles tane kehchi. ");
INSERT INTO bea_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oohchu iehti kweh atiih hligi teze ta kwa taneghaotatyech yaghati metseli ayiih; kahchu ootyestalon, ");
INSERT INTO bea_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Toowe ooli, Atu aghaititaniah; atu ooli nagha assitli iyo aoohti, nuni Jesus Nazareth otsi? Yuhchitiyala aghayaonila? Atanasti nelesi Nagha Tgha Maatsinde Oochu ooih. ");
INSERT INTO bea_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus toowela ooli yehti, yachioote, Atu oonatih yehti, setseghatiyah yetsun tsi. ");
INSERT INTO bea_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kootoo aghaghatai tsunale too yayaghinchil, oohtye ootyestalo, yetsi hadesha. ");
INSERT INTO bea_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aghanetye ooghatesta, aghanetye chu koohtaghoati, tiyeohtye, yetike aloontye? ye tane tsi oochatihi koonte? Aha kootesti otech oochu gha saghatai mayis atu natset. ");
INSERT INTO bea_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Koohchu oonthe atyeh meghoyuh yito kwa Galilee. ");
INSERT INTO bea_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ayite otsi, ghaghatestyetlon taneghaotatyechi kwa otsi, kweghaghintyetl Simon yu Andrew yu kwa, James chu John chu. ");
INSERT INTO bea_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon tsiyue ma tyelasatyi teskoone ayila, oohchu koohoohati. ");
INSERT INTO bea_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yechidesha yila inchut, kahchu tahyatinti; kwete ayi teskoone ayila yecheli, ayi oota yakeotihch. ");
INSERT INTO bea_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hatse kahkachi, naghioo, kiya nanila yatitine, yaghi chu mazichi yaghatai metselihi. ");
INSERT INTO bea_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kahchu atghe ehlaititi tane natihti tyechiklaghatati tusklahti. ");
INSERT INTO bea_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kahchu atghazi tatihi akooyilalon ayeeah natlone yehtanintyelon, kooyaghatai metselihi natlon oonteslalon; kahchu atu ketselihoo wahti iyao-ohti, achi atayatilon ayiwooh ayehti. ");
INSERT INTO bea_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kahchu hatlindo, setsehto tsitike satalon, hadesha, kahchu koondeshalon aghasuchalechi, kahchu iehti yachutatyeheh. ");
INSERT INTO bea_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kahchu Simon yehkyatehchi kikyehtestyetllon. ");
INSERT INTO bea_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kikihtitsi, toowela ooli kiyehtilon, Atghe tane ninkhaghanatgha. ");
INSERT INTO bea_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Towehchu yehti, Tane natehtsi otsidooshai kooche oohoostihi oochu, kootatooshigha lasasta aoontye. ");
INSERT INTO bea_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kahchu tane tsiwoghintalon taneghaotatyech kwa kwe Galilee, kahchu atsinde metseli ghayatehalon. ");
INSERT INTO bea_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kahchu machitatestyel tane tsusachi yaghoone yatsi nioonunisit, kahchu machi nachustachaklih, kahchu toowela ooli yehtilon Kooh koodinti ate oochu asaghoonlehassi. ");
INSERT INTO bea_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kahchu Jesus, atyetastihtoo madzye tatilon nati gha tiesunni ihe, yetsi tahtatitichlon, kahchu yakatehtich lon, kahchu toowela ooli yehtilon, Kooh koosti; kwakoola oochu anatyeh. ");
INSERT INTO bea_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsiwohzon otatyech otye, susuchi yetselilon, kahchu oochu oohtyelon. ");
INSERT INTO bea_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kahchu yatatilon tsiwohzon itintiah, kahchu oochu tyehalon; ");
INSERT INTO bea_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kahchu toowela ooli yehtilon, Atu kahchu ooli ataoonti niwotine: kahchu achutiya, nazi yueh taneghaotatyech metihi, kahchu khaniah naoochu oohtyi ihe yaghi Moses za kyehchi, ata kiyutihi. ");
INSERT INTO bea_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kahchu hadesha, oohtye awonetye khootawootyelon, kahchu tike okehe khootawotyelon, kwa hlilon Jesus atu tanetghakweya tyetachatlihi kwa iyu meheaoontye, ahwole kemwehchi tike alilon, kahchu kiyinkhatestyetllon ewonetyetsi otsi. ");
INSERT INTO bea_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kahchu kwiyalon Capernaum tahke dzine oolitatatich wazilate; kahchu kooachatilon ayiti nito kwa oota ko-ochati ihe mewoyu. ");
INSERT INTO bea_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kwete natlone tyechi ghlaghatilon, kwa hlilon taghadesmanlon atulitah ookuzze ooli ghintlon kye, kwa hlilon tusla aghoo ooghata taghadesman ghintlon kye; kahchu sa yatatilon. ");
INSERT INTO bea_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kahchu kiyinkhatestyetl yatilonooh yatitihi ihe, tyentane kooyahtyel. ");
INSERT INTO bea_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kahchu atu ugha otsighatatyel iyua aoontye ootaneghutl kye, nighatilalon anetiyi ootaneghutl kye alinti; kootoo ghaghatagheoo yatilone, kitaghintsut takeustyi tyela satyechti. ");
INSERT INTO bea_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kootoo Jesus wai aha oochati, toowela ooli yehtilon ayi yatilone, Sechue, nametselihi naoonchatuleli. ");
INSERT INTO bea_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ahwole tahkine ayiti tyechii adesklesne, kahchu koodzye otsi indighateshalon, ");
INSERT INTO bea_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yeoogha ti teze atu oochu ateotye? mea metsehhi ka oontoolelassi kootahtye Nagha Tgha zon? ");
INSERT INTO bea_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kwete Jesus ataotio yaghatei intidesakehe, toowela ooli yehtilon, Yehoo oohtye naghadzye ihe intidaa aoontye? ");
INSERT INTO bea_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tyeyi meotena achatooti kehe yatilone, Nametselihi naoonchatoolel; koolehe, Tsitike sinta, nustyi neodiah? ");
INSERT INTO bea_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Atawahtihi iyu aoontye hligi teze Machue natsutti ayehi chode tike kakametselihi naghaoontooleli, (toowela ooli yehtilon yatilone,) ");
INSERT INTO bea_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Toowela nesiih, Niiya, nustye nioodiah, nakwa otsidiya. ");
INSERT INTO bea_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kwa kwete niiya, ustyi nioodioo, kahchu hadesha aitye yai; kwa hlilon atghe yaooli, kiyaooli Nagha Tgha, toowela ghatyeh, Atu haoontyedi oohwetyi tahooli. ");
INSERT INTO bea_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kahchu tu chok meootyesha; atghe aghanetye machichatyesha, kwa yaotatich. ");
INSERT INTO bea_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Intyizon ghayalu, yailon Levi Alphaeus ma chue sata sooniya mechetilichti, toowela ooli yehtilon, Sakyetiya. Kahchu niiya yekehtesha. ");
INSERT INTO bea_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hesai wazeluh Jesus yakwa kwesata atsitsoo, natlone tanechowhoine chu metseline chu Jesus yakahtehtsi yaotatichne chu: oohchu ghintlone, kooketestyetl chu. ");
INSERT INTO bea_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kootoo hatseto adesklesne chu Phariseene chu kiyaichi inka aghatsitsoo tanechowhoine chu metseline chu, toowela ooli yehtilon yaotatichne, Yehoo yakaatsits aoontye yakah chu tuaton tane chowhoine chu metseline chu? ");
INSERT INTO bea_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kootoo Jesus ootitsahoo, toowela ooli yehti, Yaghine oochu oontyene atu kiyinkhasootati yutane, yatitihizon: atu yuhchideya tyechi kooyusine tyeswe yaghitane, ahwole ayi atu tyeswe yaghitane chodeh kyetsahanohoolehe koometselihi ooghatihuali. ");
INSERT INTO bea_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kahchu yaotatichne John chu Phariseene chu ooneaghatatihya toonkye: kahchu yuhchihatestyetl toowela ooli, yehoogha yaotatichne John chu Phariseene chu ooneatatehya aoontye, ahwole nuni maghotintichne atu ooneatatehya? ");
INSERT INTO bea_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kahchu Jesus toowela ooli yehti, Maskyege la kwa nichiyehi kooyehkyatechi ooneatatulela la? kooyehkyatechton atu ooneatatehya iyu aoontye. ");
INSERT INTO bea_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ahwole kwa kwete khoonahwozetasi, kootoo mka tuchainklitne kwiya kwa oochayihate, kahchu ayi dzine ooneatatuyelassi. ");
INSERT INTO bea_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Atu chu ooli koonde ale ooli tsatse ihe kyechatoohkatassi, yaikoole koonde ihe kechaghinghati kwa hlilon hleooyu awotiassi. ");
INSERT INTO bea_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kahchu atuline tata ahklitassi chiche tu koonde satsoone tontyeto otsi: atu chu chiche tu ooli tsatse tataoohklit ootookyezasi, kahchu natesklitchiche tu, kahchu mataootsayih oontookyezasi: ahwole chiche tu koonde ooli ta koonde chuhklitassi. ");
INSERT INTO bea_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kahchu otles tghah niya achuniyehti Menejitti Dzine; kahchu yaotichne makye ghatehlu atghe inchaghakinesla otles. ");
INSERT INTO bea_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kahchu Phariseene toowehchu vehti, Nye, yehoo koohghaghati aoontye Menejitti Dzine atu tu dzine kooh ghatsati iyu aoontye? ");
INSERT INTO bea_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kahchu toowela ooli yehti, Atu makyeh ootahtyech tah oolila David aoontli kootoo intaklinto kahchu tapatoo, atane chu ayi vehkyatiche chu? ");
INSERT INTO bea_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kwiye sikooh Nagha Tgha kwa, intyizon Abiathar taneghaotatyechi metihi chok acha, kahchu kiyatsetslon otles oochu atuline yetsitslon gha yai zon taneghaotatyech, kahchu yayigholon ayi yehkyatiche. ");
INSERT INTO bea_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kahchu toowela ooli yehti, Menejitti Dzine achilalon tane gha, kahchu atu chu tane Menejitti Dzine gha: ");
INSERT INTO bea_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ayigho teze Chue ghakaoodzut Menejitti Dzine. ");
INSERT INTO bea_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kahchu tyetachatlihi kwa kwiya: ayiti teze natyelon mila taneskyelon. ");
INSERT INTO bea_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kahchu kiyunailon, ooka ooli asityeh kha Menejitti Dzine nai; kitalih iyu aoontye. ");
INSERT INTO bea_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kahchu toowela ooli yehti ayi teze mila taneskye, Hatelon atichi nazutooh. ");
INSERT INTO bea_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tooweh chu yehti, Oochu la oochu keoochuahch Menejitti Dzine, ketseliooh keoochuahch? tane ghaghatai gha kasoochatooti gha koole? Ahwole atu ooghati. ");
INSERT INTO bea_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kahchu anetye klokanatghalon madzyehatsutooh, kyeoocheklah ihe tane dzye natsutti, tooweh chu yehti teze, Tahtatinti. Ooh kahchu tahtatintieh: oohchu mila natsaghinhtalon achune kehchi. ");
INSERT INTO bea_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kahchu Phariseene achughatestyelon, kwete hla nighohanintalon yai chu Herodianuk, tihakehe soo ookitoohtelu. ");
INSERT INTO bea_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ahwole Jesus achutyezha yaghotine chu tu chok tsi: Kahchu tane natlone Galilee otsi yu Judaea otsi yu yekehtestyetl. ");
INSERT INTO bea_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kahchu Jerusalem otsi, kahchu Idumaea otsi, kahchu o-one otehchi otsi Jordan, kahchu aghatane ahthaze Tyre yu Sidon yu, ghintlon ke, ooghatitsuk chi ayi oochu keoahchi, kiyinkhadesha. ");
INSERT INTO bea_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kahchu yaotatichne tatilon, ela ckok natsutli ootagha iiti wothoogha kooghohtyi tane natlon ke kha ati makechichiticha. ");
INSERT INTO bea_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Atane natlone yaghihti ihe; kwa hlilon yinkghanotyesuts yakatutihikha, anetye ayi tatihi akooyahine. ");
INSERT INTO bea_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tane yaghatai mindicheli kahchu kiyainchi ate, kyechinachustaklih, kahchu ghatyezul toowe la ooli kiyehti ihe. Nuni Nagha Tgha Chue nelaoontye. ");
INSERT INTO bea_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kooh oochu atu soohchiwoti atu atachutihikha. ");
INSERT INTO bea_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kahchu khis ehkyeghiyalon, kahchu ayizon ayuti tyechi yehti: yachidesha. ");
INSERT INTO bea_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kahchu keneti onketi matgha kliniyanila, yekyeootichigha, kahchu achutehalon udzih oohootigha. ");
INSERT INTO bea_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kahchu ayulhi gha natsutti, kahchu atsinde metselihi hayatuhi gha: ");
INSERT INTO bea_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kahchu Simon yindizi yakechioosun Peterlon; ");
INSERT INTO bea_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Kahchu James Zebedee machue, kahchu John, James mekye; kahchu nindizi yakechioosun Boanerges, ayi nahthunni uskyege chatyeh: ");
INSERT INTO bea_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kahchu Andrew, kahchu Philip, kahchu Bartholomew, kahchu Matthew, kahchu Thomas, kahchu James Alphaeus machue, kahchu Thaddaeus, kahchu Simon ayi Canaanite, ");
INSERT INTO bea_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Kahchu Judas Iscariot, mazi atahootalon: kahchu nito kwa kwighaghintyetl. ");
INSERT INTO bea_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kahchu natlone natsughanestlalon, ehtye kwa hlilon atu otles atsitslon natlonke. ");
INSERT INTO bea_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kootoo meootinoo ootitsukoo, achughatestyetl kiyuhchutigha: aghatune kooghatyeh, Tinditaodesooissi. ");
INSERT INTO bea_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kahchu adesklesne yuhchighatestyetl Jerusalem otsi ghati, Ayehi Beelzebub, kahchu yaghatai metselihi iiti otsi hayateha. ");
INSERT INTO bea_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kahchu koohchu yinkhawoti, kahchu too we yehti, tyecha otsi aghaghatai metselihi hatsatoohtyel oontye ayi aghaghatai metselihi? ");
INSERT INTO bea_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kahchu hlahti tane natehti intsake yawoinklit ate, ayiti tike ii oowotoehassi. ");
INSERT INTO bea_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kahchu ayi nito kwa yaooghinkliti ate, ayi nito kwa oowotoehassi. ");
INSERT INTO bea_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kahchu aghaghatai metselihi ataniiya ate, kahchu tezi yanile ate, atu oowotoehassi. ");
INSERT INTO bea_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atuline kweyali iyua aoontye teze natsutti kwa, yenatunne yatatulelu, hatse tahyaghesklu teze natsutti; atezon ya kwa yaghonile iyu aoontye. ");
INSERT INTO bea_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kwa hli anaghaisilon, Atghe metselihi kooya oochatoolelassi tane uskyege, kahchu soocha oochatihi: ");
INSERT INTO bea_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ahwole ayi ketselioo atii Menejitti Oochu atu ihlaotateoo ayehi kha, ahwole seghaai ayehi nioonizutti oonchatalihi: ");
INSERT INTO bea_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ayighoo ayehti, Ayehi aghaghatai metselihi. ");
INSERT INTO bea_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kahchu mekye chu ma chu iiti otsighatestyetl, kahchu tsehtsi nazutooh, kilati, kiyinkhaooti. ");
INSERT INTO bea_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kahchu tane natlone yaka tghanatihtsi, tooweh chu kiyehti, Nea, noo chu nehtghizinne chu tsehtsi naghatehya ninkhaghanata. ");
INSERT INTO bea_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kahchu ateyatetla, toowehchu yehti, Mea anne eli, setghezinne koole? ");
INSERT INTO bea_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kahchu khlonkanatgha ayi yaka khlontyetsi, kahchu toowela yehti, Ahi anne chu sehtghezoon chu! ");
INSERT INTO bea_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Atunne zon kooh ghawoteassi ayi Nagha Tgha indi, ayi akye chu, ustye chu, unne chu. ");
INSERT INTO bea_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kahchu tyigha tane ootatech tu chok tghamweh: kahchu natlone yinkhadesha, kahchu tachin ela ehkyiya, kahchu tu chok tih ali; kahchu atghe tane natlone tike wohzon. ");
INSERT INTO bea_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kahchu yachioteh ooli natlon yughotyeh, kahchu toowe ehti otsiootihi, ");
INSERT INTO bea_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Oochu atahtsuk; Oochu hadesha otles alihi tane anihyihi niyilihi gha: ");
INSERT INTO bea_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kahchu intyizon achunihyehti, tahkine yainkhyi tinkuzze, kahchu chua etye yaghatehtyetllon. ");
INSERT INTO bea_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kahchu tahke nooghinklit tsyetgha, atu oonchadi tike ooliite; kahchu kwete ghanaghiyu, atu tike tatghoe: ");
INSERT INTO bea_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ahwole chelon sa niniya, maziche ninihklitlon; aha oona maghaye toontooeyi, ayi ihe taihtsutii. ");
INSERT INTO bea_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kahchu tahke nooghinklit ghoos chine chok tgha, kahchu ghoos chine chok ghanaghiyu, kahchu klighatanityetUon, kahchu atuli machiche oolilon. ");
INSERT INTO bea_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kahchu achu nooghinklitlon tike oochu ti, kahchu machiche ooghilyelon ghanaghiyu yu kahchu tainyezho; kahchu yahlonihyu tahke taoketyi tahke chu edzetaiti ketyi, tahke chu keoneti ketyi. ");
INSERT INTO bea_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Koohchu yehti, Yaghi matsaghe ooli, inkai ootootsuke yehti. ");
INSERT INTO bea_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kootoo chlatyo ayi yehkatyelichi yaghi chu keneti onketi matgha tawotya yehti kawotzutne gha. ");
INSERT INTO bea_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kalichu toewela ooli yehti, Naghunni aghaoochuneoh aoontye atawohtihiglia tyewotye hai koosti Nagha Tgha kyeyi: ahwole ayine tsehtsi natihne, atghe ooli keowaahch yehe achatih: ");
INSERT INTO bea_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wai oochui, kahchu atu hlyenahotihi gha; kahchu ooghatitsukooh ooghatootsukassi lon, kahchu atu klaghatootsukassilon; koohchu oolita ghooghanetyela, koometselihi kooya oone oochatulel akhe. ");
INSERT INTO bea_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kahchu toowela ooli yehti, Tiyeghakehe atawahtiha ooli kehe yaghaghahtai kehe? koohchu yeghateh atawahtiha atghe otech? ");
INSERT INTO bea_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Oonehyene oonehyoh sa. ");
INSERT INTO bea_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kahchu aghatane tinkuzze tatihne sa chunihyehti; ahwole kootoo ooghatitsukassi kooh ghaghatai metseli kwoto otsidesha, kahchu yazake yuhniyatiooh yadzye ta otsi. ");
INSERT INTO bea_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kahchu aghatane chunihye ine tsye tgha; kootoo sa ooghatitsuk, kwete neooatiooh soochanetye; ");
INSERT INTO bea_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kahchu atu ghai ighutaklilon aghatane hahte, kwa tiootsi zon ghaghatalon, ootlwe kootoo sookhaootaya kootoo hlachatatane niwoya sa tachi kwete chahte intighatesah. ");
INSERT INTO bea_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kahchu aghatane ayi yachunihyene ghoos chok chine tgha; ayi sa ooghatitsuh, ");
INSERT INTO bea_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kooh tidi tike indi, kahchu mihe atsunnetahe yu mihe tatintlon yu, kahchu machachintye achu ooli kwenachaghila otcho ooli sa, kahchu atu machiche ooli. ");
INSERT INTO bea_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kahchu ayi mehoochunihyehe tike oochute; ayi ootitsukne sa, kahchu niooatioone, kahchu machiche ooli, tahke taoketyi enetyi, tahke chu edzetaitiketyi, tahke chu keonetiketyi. ");
INSERT INTO bea_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kahchu toowela yehti, Nachila takooche nichualli ghotwetghulle yue take ustyi koole? koohchu atu nichiooite takoochechine? ");
INSERT INTO bea_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Agha atuli nachunehi atu mewotuti; kahchu atuli tanetcha maghuchata iyu aoontye, ahwole atachuteassi. ");
INSERT INTO bea_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Koole matsaghe oolyetane inkai ootootsukassi. ");
INSERT INTO bea_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kahchu toowela ooli yehti, Tyeke ayi ootahtsukki: ayi ihe tikeghaklyeli, ayieh nagha tsi tiketsalelassi: kahchu naghai ootaghahtsukki, ootehchi nahachuallassi. ");
INSERT INTO bea_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yaghi ayehi, machuallassi: kahchu yaghi atu ayehi, mehwayachutallassi koole ayi ayehi. ");
INSERT INTO bea_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kahchu toowela ooli yehti, Koohia ootye oontye Nagha Tgha kyeyi, hletye teze oochunehyehti oodihyitl keoontye; ");
INSERT INTO bea_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kahchu satyi, kahchu niiya hatleke chu dzine chu, kahchu achunehyehti ghanaghihu, atu ataoti noontye sikooh. ");
INSERT INTO bea_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ghoo yaghi tike atai hahte otsi ghanaghihu; hatse kloke eli, kahchu hachaghinaghiyu, kahchu otlweh ootles. ");
INSERT INTO bea_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kahchu yaghi chiche ghanaghihuta, kwete atataz, khoo chotazze dzine eli. ");
INSERT INTO bea_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Towehchu yehtilon, Tyechi otsi gha Nagha Tgha kehchi niwowotal aoontye manatake? koole hletyi indi nighaootal aoontye? ");
INSERT INTO bea_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hleoontye oochuniliyehti ehlatye yutanikluchi machiche, kwa nichalesta oonahyehe tike, eyi zon natsutli anetye oochu ihyehe tike tih: ");
INSERT INTO bea_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kwa aochelesta, oochu nichulesta ayi zon otehchi yaincha anetye nichulihchassi, kahchu matatse natlon; kahchu ayiti chua yayue sacha iyue tehtsi. ");
INSERT INTO bea_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kahchu ayi etye akyehchi oochatihi ihe ehyatatilon, ghanawesittih oohasoohtsoo gha. ");
INSERT INTO bea_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ahwole atu ya-i-ti-tyes ate atu yachiwotyehlon: kahchu sahta aghatinta, yaotatichne atghe yatatilon. ");
INSERT INTO bea_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kahchu ayi dzinee, kahkachi aocha, toowehchu yehti, Onka nataghokye taityechi. ");
INSERT INTO bea_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kahchu yite kitehalon tane natlone, nighatila aoontye sikooh. Kahchu kooyeh testyetlon tachin ela ihe. ");
INSERT INTO bea_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kahchu intsi chok niya, kahchu tuyune nachalon tachin ela kooyeghe tiketlalon, kwa hlilon tadesmanooh. ");
INSERT INTO bea_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ahwole atai haiseuhi, satyi tsiatakyeh: kahchu tsikiyaniha, toowehchu kiyehti Metihi, atu aghaititawoala tghataozitassi? ");
INSERT INTO bea_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kahchu niiya, kahchu intsi tsiwoti, toowehchu yehti tu chok, Tyeke tahtsi. Kahchu intsi atyehzut, kahchu ohtye tyesghutl. ");
INSERT INTO bea_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kahchu toowela ooli yehti, Yehoogha onenatyetl aoontye? yehoogha atu a kootahti aoontye? ");
INSERT INTO bea_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kahchu ohtye onighanintyetl, kahchu toowela klaghatati, Ye teze alontye koole intsi ateate chu tu chok yuzehtso? ");
INSERT INTO bea_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","KAHCHU nighatiooh taityechi chisinchi tu chok, kootike tsi Gadarene matike. ");
INSERT INTO bea_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kwa kootoo tasaya ela ehkye otsi, kwete yatitityesha ehlatye teze natine kwa otsi ayehi yaghatai atu mayis natsutooh, ");
INSERT INTO bea_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Makwa ooli natine tgha; kahchu atuline yatahnatsut iyu aoontye ihe ayii ihe atu tah taghatsakluh iyu aoontye, atu satsoone klule aghoo ihe taghachakluhassi: ");
INSERT INTO bea_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tewotye oontlon tahtsughesklu mihe klule ihe kahchu satsoone klule ihe, kahchu satsoone klule yatayaghechil, kahchu makye chine klule oochu yatayaghechil: kahchu atuline oochu ayilih iyuntyeh. ");
INSERT INTO bea_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kahchu inkaa hatleketahwoyu dzinetahwoyu, ali khis tah, natine tgha woyu, otyesta, kahchu atakhai tatazo tsye ihe. ");
INSERT INTO bea_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ahwole tontye tsi ghotsi Jesus ya-i, otsitehtla yatsi nachustaklyeh, ");
INSERT INTO bea_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kahchu ohtye otyesta, kahchu toowela ooli yehti, Tyeka kehe na-kye-o-os-tyi-cha, Jesus, nuni otehchi ooli yatehchi Nagha Tgha chue neli? Natsinioonunisit Nagha Tgha tsi, atu nidisawositi. ");
INSERT INTO bea_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Atai toowela yehtie, Sachighatiya teze zi tsi, nuni atu neyis natsutti aghaghintai. ");
INSERT INTO bea_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kahchu tawotya yehti nindizi tyeoolya yehtilon? Kahchu toowela yehti, Legion, oohzi: nitlon ihe. ");
INSERT INTO bea_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kahchu yatsinioonunisit atu achu tsutoohigha ayiti tike otsi. ");
INSERT INTO bea_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kahchu ieti alii hwaza khis tah koohkoos natlon eghihta. ");
INSERT INTO bea_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kahchu atghe aghaghatai metselihi yatsinioonunisit, toowehchu yehti, ghotsiaghatiha koohkoos natyehti, koohkoos zi toontyelikha. ");
INSERT INTO bea_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kahchu kwete Jesus ghatyeh yasehla. Kahchu naghaghatai atu mayis natsutti ghaghatestyetl, kahchu koohkoos zi tintyetl: kahchu koohkoos ohtye kyehodihsut ichulti tu chok tghamweh, (oolitah onkye keoneti keoneti;) kootoo chu etye tukooghiwolon. ");
INSERT INTO bea_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yaghaine koohkoos zaaliine taghatestyetl kooghohwati nito kwa atyih kahchu ayiti tike. Kahchu otsighatestyetl ayi ye keochaahch aoontye. ");
INSERT INTO bea_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kahchu Jesus kiyunintyetl, kahchu kiya-i ayi tane atsinde metselihi ayehi, kahchu kootoo ayehii ligiona, sata, kahchu natunne tasata, kahchu tyeswe indi ahi: kooh onighanityetl. ");
INSERT INTO bea_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kahchu yaghine oohwa-i ine kitati oontye sikooh ayi tane atsinde metselihi ayehi, kahchu koohkoos ihe. ");
INSERT INTO bea_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kahchu tyikichi niooghaghananintyetl achutooyigha kootike otsi. ");
INSERT INTO bea_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kootoo tachin ela ehkyiya, yaghi ayehii tane atsinde metselihi yachinioonunisit yehtootyeli gha. ");
INSERT INTO bea_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Atu ghate yasehla Jesus, ahwole toowela ooli yehti, Ootinta niootinoo khadiya, oochu kootinti ooli Ghakaoozutti nakeoahchi, kahchu noohchuya. ");
INSERT INTO bea_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kahchu achutyesha, kahchu khootaootyeh Decapolis yechatgheze Jesus oochu nanakeochaahch: koohchu aitye tane khaooghali. ");
INSERT INTO bea_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kootoo Jesus natyeski tachin ela ihe taityechi, natlone tane yachitestyetl: kahchu hwa tuchok alii. ");
INSERT INTO bea_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nea koohzon ehlaiti yinkhatyesha kakaoozutti tyetachatlihi kwa, Jairus ooyi; kootoo ya-ichi, nakye kuchi naitsut, ");
INSERT INTO bea_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kahchu ohtye koonoo yachinioonunisit, toowehchu yehti, Setue tyele satyi koola tehtsutooh: nachinoonunisit, samakataootihi, naghaootai gha; koohzon hanalaite ootesi. ");
INSERT INTO bea_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kahchu Jesus yehkatich, kahchu natlone tane yakehtestyetl, kahchu kikyeoohsut. ");
INSERT INTO bea_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kahchu ehlaiti tsege, yaghi keneti onketi matgha yaskehe matulle natatyehizon, ");
INSERT INTO bea_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kahchu natlone ooli yakeoohchi natlon yutane, kahchu yaghatestla ayi oontyei, atuli akehe naghiteyo oontye, atatihe tati, ");
INSERT INTO bea_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kootoo Jesus otsi ootitsukoo nooja otsi keistla otsi yatsityesha ootaneghutl ihe, kahchu yakestue katehtich. ");
INSERT INTO bea_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Atune toowela ehtie, Manatunne zon aghoo katyestich ate, oochu awostyeassi. ");
INSERT INTO bea_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kahchu kwete otsi tul natatyehti sakoon; kahchu atyetastyiht mazi tsi nachagihta avi tatihi tsi. ");
INSERT INTO bea_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kahchu Jesus kwete ataotihoo mehnatsutsutti mazi tsi hatsatooh, natunesha tanetiche, kahchu ehti, Mea ali senatunne katehtichlon? ");
INSERT INTO bea_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kahchu yaotatichne toowela yehti, Natlone tane ghii tanighatlu, kooh tinti, Mea sekahtihtich? ");
INSERT INTO bea_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kahchu klokanatgha yui gha ayi ooli keoachine. ");
INSERT INTO bea_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kahchu tsege ooniya kahchu ghati ihe, ataootioo ooli maachahi matsun tsihi, yuhchi yachi yuenenitooh, kahchu yatati aitye hlonchati. ");
INSERT INTO bea_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kahchu toowela ooli yehti, Ghutue aha koodinti nanaghinta-iih; taichi tyege inditiah, kechutintih natatihe ihe. ");
INSERT INTO bea_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Intyizon kwaka ootatyichoo, yachidesha ma kwa otsi yaghi yakaoozutti tyetachatlihi kwa tahkine atine, Netue tehtsut: Yehoo gha mehchintahcha otehchi Metihi? ");
INSERT INTO bea_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kwete Jesus sa ootitsukoo, toowela yehti ayi kakaoozutti tane tyetachatlihi kwa, Atu ooniooya, aha koodinti zon. ");
INSERT INTO bea_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kahchu atuline hateh gha sehla oolino yekehtooyi, Peter zon, kahchu James, John chu mekye James. ");
INSERT INTO bea_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kahchu khooniyalon kakaoozutti kwa, kahchu wa-i oontlon tsi oochataahoo, yaghi chu atsukki kahchu ohtye atsukki. ");
INSERT INTO bea_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kootoo kwiya toowela ooli yehti, Yehoo gha oontlonchi ootahah aoontye, kahchu ahtsu-ko-oyu? ataze atu tehtsut, ahwole satyih. ");
INSERT INTO bea_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hatyeh oontlonchi kiyuhaghatakluch. Ahwole ehtyezon aitye hayateha, otsighadesha yatgha chu you chu ata, kahchu ayi yehkyatechii, koohchu kwinaghacha ata tyelasatyinti. ");
INSERT INTO bea_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yila inchutlon ata, kahchu toowela yehtilon, Talitha cumi; ayi chati, Ata, niiya, nesii. ");
INSERT INTO bea_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kahchu kwete ata niiya, kahchu ghayahl; atai keneti onketi matgha mayaskehe. Ohtye o-ochi khaooghalilon aghawochule kehe. ");
INSERT INTO bea_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ohtye atuline tataoonti; kahchu atya kehe oolita ooli machuhchut. ");
INSERT INTO bea_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","KAHCHU ieti otsi achudesha, kahchu yuhchidesha ghochati matike; yaotatichine chu yekehdesha. ");
INSERT INTO bea_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kahchu Menejitti Dzine khoonioonizutooh tye tyetachatlihi kwa taneghaotatyech natlone kootitsakooh khawoalli, ghatih Tyecha otsi niyatilontye? Kahchu ye o-ochi mehoochayu tidi machioo, koole yaghi oochu ekyeotatichi ayilai tila ihe? ");
INSERT INTO bea_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Atu ayila tachin atali, Mary chue mekye James, Joses chu, Juda dm, Simon chu? kahchu mehtghezze chode mekyechatich? Kalichu atu oochu yatsiintighadesa. ");
INSERT INTO bea_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kahchu Jesus toowela yehti, Tane chi otine tune atu mooh oontue iyu aoontye mehe meachatachai, atunezon tatike hwa yule iyu aoontye, kahchu atai hahte menachine, kahchu atai hahte ghochatih makwa. ");
INSERT INTO bea_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kahchu ayiti atu kooye keoahchlon mehmawochuli kewotiche, tahkine ghatyeh katehtichlon yatitine, kahchu nayaghihtalon. ");
INSERT INTO bea_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kahchu kawolilon atu aha yutieh. Ahwole atghe tane tanenatih akehe klodeshalon, taneghaotatyech. ");
INSERT INTO bea_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kahchu keneti onketi matgha tyechi yehti, eonetye tsi yeteha onkyetatatye; kahchu yehnatsutti yayila yatanatsutti naghaghatai metselihi; ");
INSERT INTO bea_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kahchu aychti atuli yatoolai kyatehchu, tghes zon; atu etsunzis, atu chu otles tyes ali, atu chu sooniya kooghele tasulla: ");
INSERT INTO bea_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hoontyegho kyetlhi ahoo zon tatyez; kahchu atu onketi kestue taooya. ");
INSERT INTO bea_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kahchu toowela yehti, oolitah nito kwa kwighaachatetah, ayiti ahli achutahaz ti otsi. ");
INSERT INTO bea_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kahchu atu ninaghatile ati, naghatitsukki ata chu, aisai iiti otsi achutaach ate, naghakye waghat otles ihe kooyeh ooghahtichi. Kwa hli anaghaisii, Otehchi aghatane Sodom yu Gomorrha yu oochu awohtyesi ohtye tane tsiochatihi dzine intyizon ayi tike. ");
INSERT INTO bea_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kahchu achughatestyetl, kahchu tane taghatih ketselihi ooghachatutii gha, ");
INSERT INTO bea_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kahchu natlon metselihi ghaghateha, kahchu kles ihe yakiyehkluk yatitiine, kahchu nayaghinta; ");
INSERT INTO bea_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kahchu metihi tyiyi Herod otitsuk mewoyu; (atgheze tike okehe midizi khoochatiihe;) kahchu toowe ehti, John matukeghinkliti atai tustye otsi niiya, kahchu ayiwo mehe ohtye keochatichi eotatya aoontye. ");
INSERT INTO bea_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Achune ghati, Elias atai, kahchu achune ghati atane tai atahwotine, ehlatine eontye atane tai atahwotine. ");
INSERT INTO bea_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ootitsukchi Herod, toowe ehti, John ayi matsi hlihyitl ii: tsitike nesta tustyi otsi. ");
INSERT INTO bea_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Atai Herod ghochati ochiyateha, John chu niyatinti, kahchu tane kwechayihti tayaghesklu Herodias ihe, mekye Philip tsiyue ihe: atai inkah hlakootsila. ");
INSERT INTO bea_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Atai John ayehtii Herod, Atu wotezi nai awohi nekye tsiyue. ");
INSERT INTO bea_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ayeoo Herodias tike ochehtune yesoohail akhai; ahwole atu hawootli iyu maaoontye: ");
INSERT INTO bea_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Atai Herod John enejitieh, atayetioo tyeswe ghata, kahchu maghata oochu tane elieh teze, kahchu yama intityesha; kahchu yatitsukchi oontlon kehe keoachlon, kahchu kyenawolesilon ayiteh otitsuk ate. ");
INSERT INTO bea_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kootoo sookah nitsutooh dzinee khonioonizutooh Herod niyi dzinee khonioonizutooh hatleke eghohtai gha oola tametihi gha, simakunnis metihi tyiyi chu, kahchu haladi kha kakaoozuni Galilee; ");
INSERT INTO bea_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kooh kootoo Herodias matue kwiya tahtitla, kahchu yakeneli Herod chu, ayi yakasatai chu, metihi tyiyi toowe ehti ayi atyedi, Soodinkyet ooli sachinioonunisitassi, atuli necho matuhsesi. ");
INSERT INTO bea_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kwete oochu ayehti, Atghaze ooli assyesi oochu gho soodinkyet ate, tghatichi ooli assi naslelasi. ");
INSERT INTO bea_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kahchu hadesha totsi anna. Ye ooduskyet aoontye totsi ehtilon? Tsiyua so toowe ehti, John matukeghinkliti tsi. ");
INSERT INTO bea_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iteteh kwete metihi tyiyi tsidesha, kahchu atakyet, kooh koosti atezon sahoalli tsa ihkye John matukeghinkliti tsi. ");
INSERT INTO bea_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kahchu ohtye metihi tyiyi atu kenelilon; hoontye ooli oochu ati ihe, kahchu aghatane ihe kookasata, atu yaza ootihyul. ");
INSERT INTO bea_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kwete chu metihi tyiyi otsideha teze, kahchu matsi naghahal yehtilon: kahchu otsidesha tane kwechayehti yetsi hlihyitl. ");
INSERT INTO bea_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kahchu yetsi nanioo tsakyeh, kahchu atyedi ghioo: ooh ayi atyedi to ghioo. ");
INSERT INTO bea_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kootoo yaotatichne oghatitsuk chi, yachihatestyetl kahchu yazeche nighatihtyi, kahchu natine kwati naghanihtyi. ");
INSERT INTO bea_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kahchu wochichatehane aghanetye intataghati Jesus aliiti otsihatestyetl, atghazi kitatati ooli, keooaachii, kahchu ooli tanegha ootatyechine. ");
INSERT INTO bea_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kahchu toowehchu yehti, Tyetahtyel naghai tyinta oolite yaghi kemwehchi, kahchu oontsutli natahyih: kootoo natlon yuhchighatestyetl kahchu yiteghatestyetl, atulita ahwosits kuzza ooli. ");
INSERT INTO bea_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kahchu naoonai ela tu chok ehkyeatachi ehkyeghaghityetl. ");
INSERT INTO bea_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kahchu tane kooya-ih achughatestyetlooh, kahchu natlone atakooyehti, kahchu tane natihti otsi atghe otsi ooghatehsut nito kwa otyiyi aghoo anetye oogha-i, kahchu tane tse nighanintyetl, aghanetye kiyunintyetl. ");
INSERT INTO bea_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kahchu Jesus hadesha natlone tane gha-ih, ohtye matsun tatihti kyehe indityesa, uspai etyieh uspai ghaghatane tane atu ayehi: kahchu tye yaghotatich natlon ooli. ");
INSERT INTO bea_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kootoo ayi dzinelon kwakoole tontyeto kloeh ooli, yaotatichne yachitestyetl, toowe yehtilon eh, Kemwehchi oolilon chodeh, kahchu kwa oonchadeh dzine kloeh ooli: ");
INSERT INTO bea_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Achuyadeha tike okehe otsighatatyel, kahchu nito kwa ootlonchi, kahchu ataheghatutlihi gha otles tyes: atuli ghatsitsi aghahi ihe. ");
INSERT INTO bea_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ateyatetlalon hoole toowehchu yehti ihe, Naghanilon kiyioohtai kooyanahli. Kahchu toowe kiyehti, Yaghe otsi tawotyeli ataghawothhi ila sooniya onkye keoneti ketyi sachunai ehtye otles tyesta, yaghine ghaoohchuti? ");
INSERT INTO bea_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Toowela ooli nayetilon, Taitya otles tyes ahiwo? oonkawahya. Kahchu ataghowatichi, toowela ghati, Hlahcheti, hluge chu onketi. ");
INSERT INTO bea_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kooh yehtilon eonetye tsi tahtsi kloke tanepyeds tgha. ");
INSERT INTO bea_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kahchu ghatye gheskyih inchake, keoneti ketyi tatehtsi inchinatatye, taghane chu hlahcheti ketyi inchinatatye tatehtsi. ");
INSERT INTO bea_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kahchu hlahcheti otles tyes niyatila hluge onketi chu, koohtike ookahtgha yatsi kahchu merci yehti, kahchu otles tyes yataghiyits, kahchu yaotatichne ghila yaniyulel gha; hluge onketi chu anetye tghaestich. ");
INSERT INTO bea_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aghanetye eghaghintalon, oochu tataghanastolon. ");
INSERT INTO bea_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kahchu keneti onketi matgha kloke asklu ghaisis tadesmanoo mechaghintai ihe, hluge ihe chu. ");
INSERT INTO bea_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kahchu yeghaghintaiine otles tyes oolitah hlahcheti keoneti keoneti ketyi sihlon enetyi sihlon tezoo. ");
INSERT INTO bea_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ieti tye kwete anetye ihe yutilon yaotatichne tachin elahkyeootyeli kha, kahchu taityechi otsighatuteligha haladih Bethsaida, achutehaton tane. ");
INSERT INTO bea_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kahchu kootoo achuteha, atai chu yitaityesha khis tsi yaootootyech. ");
INSERT INTO bea_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kahkachi aoocha tsi, tachin ela tatiche tsi tu chok taghalilooh, atane nunkuchi sahti ali. ");
INSERT INTO bea_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kahchu yai ohtye keotichoo atowazu; intsita oolieh: oolitah hatlindo aoocha soo tane wohniyalon, tu chok khai niyalon, kahchu yaooyeassilon. ");
INSERT INTO bea_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kiyainchi tu khai niya, kooh kooghati tane atsinde ali lontye kiyutih, kahchu ohtye oonighanityetllon: ");
INSERT INTO bea_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Aghanetye kiyai, kahchu atu oochu indighatyesalon. Kwete inchi ooghatatyech, kahchu toowela yehti, Ohtye soonahtye: suni asli aoontye; atu ooneghahtyel. ");
INSERT INTO bea_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kahchu inkhadesha elahkye atine; kahchu intsi adezut: kahchu ohtye khawoghali, kahchu o-ochi khawoghali. ");
INSERT INTO bea_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Atu ayi indi ghati ihe ayi o-ochi keochaachi kehchi otles tyes: aghatane koodzye natsuttieh. ");
INSERT INTO bea_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kootoo naghateskyi tsi, koonaghaghintyetl tike Gennesaret, kahchu tghaghiyetl. ");
INSERT INTO bea_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tghaghihyetl tsi ela ehkye tsi, kwete atakiyeti, ");
INSERT INTO bea_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kahchu kyeton ghatich aonetye ieti otusinkha, kahchu kyekyeyehtich ayi tyelisatyii tatihi, ali iteh oohatitsukooh. ");
INSERT INTO bea_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kahchu kwiyah assitih nito kwa chisinchi, nito kwa otyiyi koole, tike koole, nikiyityih ayi yatitine atghunni tiche koole, kahchu kichiniooghanunisit kikatutihi gha ghatye makestue maihe aghoo kiyuhchuti gha; yuhchutassihne anetye yaghitalon. ");
INSERT INTO bea_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","KAHCHU anetye machichatyesha Phariseene, tahkine adesklesne chu, ha Jerusalem tsi ghatilhne. ");
INSERT INTO bea_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kootoo kiyainchi tahkine yaotatichne aghatsitsoo otlestyes atu ka tila tyeghintyekoo, ayi tsati, kila aghoo atu tyetsaghintyek, tahkine atu tyeswe kooghatilon. ");
INSERT INTO bea_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aghatane Phariseene, Jewne chu atghe, oontlon chi taghila tyenaghatichoo zon aoontye, atu aghatsits athli, kooghatghoonoo yaootyi hatseto koola otehchi meetiootyeha. ");
INSERT INTO bea_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kahchu naghatichta ataghe tsi, atu natsun nootootihul ate, atu awoontsitsassi. Kahchu ooli natlon ooli nikitilaine o-otghooni, tsa nootoochatuhul kahchu mihe tu tsato chu, tanihkluchi satsoone tataoochayihi takehchestai chu. ");
INSERT INTO bea_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kahchu Phariseene chu yatiklesne chu, Taotya kiyehti, Yehoo gha mawotintichne atu nakyehchi indi gha tyes aoontye tane haladi otichne tane, ahwole otles tyes eghaghinta atu tahila tyeghaghintyekoo? ");
INSERT INTO bea_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ateyatetla, kahchu toowe yehti, Oochu naghai nasetyilon Esaias naghani oontlon nahtahoo, takehnichatinkles akehe, Ayi tane oochu assaghati taaza ihe, ooh koodzye tontye saooh. ");
INSERT INTO bea_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ghatye ahwole kooyaootastech tanegha ooghatatyechoo tane mihe chioochatihi. ");
INSERT INTO bea_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tyinta saoo Nagha Tgha otiche, ooahtghoon tane yaghita kehe, nootghochadehulli mehtutsato tsa chu: kahchu ooli natlon ayi etye keoghaach. ");
INSERT INTO bea_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kahchu toowe yehti, Oochu Nagha Tgha zake kyenaghali, maghahtai yu aoontye nagha onti. ");
INSERT INTO bea_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Atane Moses kooehtii, Ohtye natgha chu noo chu tao-oncha; kooh hatyehlon ooline tatgha tsi to yu ketseliooh otih ate, chazuhelassi: ");
INSERT INTO bea_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ahwole naghai atahti aoontye hoontyeoo ooli tatgha koole to koole, Corban ayi, ayi tsati, kachiahi, yaghi ooli nakeoostich iyu aoontye; kao-ontsutti. ");
INSERT INTO bea_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kahchu atu otehchi machi nioonunahsit ooli yaaootli tatgha koole to koole; ");
INSERT INTO bea_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naghai hahte tsioone Nagha Tgha zake awahtla atuli kyewoti nagha oonti ihe, kanaooii: kahchu ayi etye natlon ooli keoaahch. ");
INSERT INTO bea_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kootoo chu aitye tane kawoti tsi, toowola yehti, Anahtye soozahtsoo naghani kahchu atahtsuk: ");
INSERT INTO bea_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Atuli ayi tane matsun khitsi tatyezut ayi mazi ti achi chahtayuleassi: ahwole yetsi hayatehai ayi ali tane chahte ayihihchi. ");
INSERT INTO bea_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ooline matsakhe oolitane iiti ootootsukissi, inkai ootootsuk. ");
INSERT INTO bea_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kootoo tane oochu tyesha nito kwa, kwenaghacha yaotatichne taoontya yehtilon hleoontye akyehchi oochatihi. ");
INSERT INTO bea_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kahchu toowe yehti, Kooka naghatsi toontooe aoontye? Atu kyenahtihela, ahtghazai ooli tsehtsi otsi kwetsutti tane, atu chahte ayili eyontye; ");
INSERT INTO bea_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Atu madzye tsi ihe ahakootyeh, ahwole mapat tsi, kahchu hatsat oochu sookah nininkyieh aitye etsun? ");
INSERT INTO bea_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kahchu toowe ehti, ayi tane tsun tsi hadehtsutti, ayila tsahte ayihihchoonte tane. ");
INSERT INTO bea_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Koodzye ta otsi tane, ine tsi tatyestek ootye indi metselihi, soochachai chu, nakhochityeli chu, tlahchazaghai chu, ");
INSERT INTO bea_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Atsunne achuneih chu, machachintyi chu, inditselihi chu, oochachiti chu, naoona-i indyetselihi chu, atai metselihi chu, atacho chunehliti chu, achachatachai chu, tsaoochayaghi chu. ");
INSERT INTO bea_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Anetye ooli metselihi kwetsut tane tsun tsi, ahwole tane tsahte ayila. ");
INSERT INTO bea_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ayiti otsi niiya, kahchu tghanatyesha Tyre yu Sidon yu, kahchu nito kwa ootanaghacha, kahchu koonoo atuline atawo-oti kootilon: ahwole atu nana-i iyu aoontyelon. ");
INSERT INTO bea_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ehlaiti tsege matue ooli ayehii atsinde metselihi, ootitsuklon, kahchu yuhchideshalon kahchu makye keh nadsutlon: ");
INSERT INTO bea_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yaghi tsege Greek tane, Syrophenician ine tsi ihe otsi tazelh; kahchu yachinioonunisit hayatoohai gha atsinde metselihi matue zi ta otsi. ");
INSERT INTO bea_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ahwole Jesus toowe yehti, Inkai hatse tsito tatanooto; atu oochu tsito taghaotlese kooyehwawachutalli, koohchu kli tsi tsatulihi. ");
INSERT INTO bea_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kahchu ateyatetla kahchu toowela yehti, Ehye, aghaghintaihi: hoontye ooli takyeh yechihtati yue natunahtyeli kli tghaoohtsi. ");
INSERT INTO bea_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kahchu toowe yehti, Tidi sa ihe oodinta; atsinde metselihi natue tsun tsi hadesha. ");
INSERT INTO bea_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kooh niya tsi takwa, yihtyi atsinde metselihi hadesha tsi, koohchu matue takyeh ustyi keh tyelasatyi. ");
INSERT INTO bea_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kooh kahchu yitaityesha Tyre yu Sidon yu otsi, otsidesha tu chok tsi Galilee, taghaniya Decapolis. ");
INSERT INTO bea_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kahchu kiyananioo hligi majih oontooehu, atu chu oochu ootatichoo; kahchu yachinioonunisit kooya katootihi gha. ");
INSERT INTO bea_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kootoo otsi yatehti tane natlonti, kahchu yaji ta katihtich, kahchu ghizek, yetsoode chu katehtich; ");
INSERT INTO bea_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kahchu yatsi ookahta, otyesta, kahchu toowe yehti, Ephphatha, ayi, Tahaootsitti. ");
INSERT INTO bea_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Itetyeh kwete maji ta hatachil, kahchu matsoode klule tihatuk, kahchu oochu otatich acha. ");
INSERT INTO bea_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oochu atuline ataawoti yehtilon: ahwole otaihchi atuline satsih ataawotihi, otaihchi ohtye koohootyeh; ");
INSERT INTO bea_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kahchu o-ochi kao-oli toowe yehtie, Atghaze ooli tsiwohzon keoahchlon: oochu majioontoowene anayitla oochu ootootsuki gha, kahchu saintakline oochu ootootyechi gha. ");
INSERT INTO bea_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","AYI dzine tane o-ochi natlone, kahchu atuli aghahi kiyutsitsi, Jesus yaotatichne tyechi yehti, kahchu toowe yehti, ");
INSERT INTO bea_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Satyaghisunni tane natlone, kooh kwa taiti dzinee sihaghahtyih, atuli chu aghahi ghatsitsi ooli. ");
INSERT INTO bea_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Achu kootyehaitye tagha kwa tsi yaghatipatooh, woianh oohatootsitassi, natlone tontye tsi otsighatelyu. ");
INSERT INTO bea_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kahchu yaotatichne atetyataih, Tyechi otsi gha tayanooto tine tane otlestyes ihe chode kemweh? ");
INSERT INTO bea_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kahchu Taitya otles tyes ahi yehtilon? kahchu toowe ghati, Taiuchi. ");
INSERT INTO bea_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tane tsi tsiwohzon tahtsi tike wozon: ayi ninayatila taiuchi otles tyes, kahchu merci ehti, kahchu yataghiyits, kahchu yaotatichne ghila oochu yaniyuleli; kwa kiyaniyila ine tane gha. ");
INSERT INTO bea_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kahchu akiyehii tahke hluge yaintsutle: kahchu merci ehtilon, kooh ehtii ine gha nichuleli. ");
INSERT INTO bea_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kahchu eghaghintalon oochu tataghanastolon: kahchu nachatanatyetl neghatila mechacheliih, taiuchi kloke ghaisis tghatatyesmanooh. ");
INSERT INTO bea_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kahchu ine eghaghinta, oolita tiko keoneti keoneti ketyi enetyi silon: kahchu achudehalon. ");
INSERT INTO bea_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kwete ela kyiya yaotatichne chu, kahchu yuhchidesha chisinchi Dalmanutha. ");
INSERT INTO bea_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kahchu Phariseene yuhchihatestyetla, kwete kichi sooghatayehch, kiyinkhanata yakachi otsi ehtoole taoontya kiyehti. ");
INSERT INTO bea_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kahchu ohtye hoontatachehlon matsinde otsi, toowe ehtie, Yehoo gha ine chi hlioolate kiyinkhanata ehtoole, kwa hli anaghaisii, atuli ehtoole naghachualassi tine maghestyekne. ");
INSERT INTO bea_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kahchu yechudesha, kwete elahkyiya taityechi otsi kahchu yitaityesha. ");
INSERT INTO bea_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mawotintichne iine kiyutoonaghatihlon otlestyes kitoolai, kahchu atuli aghahii elahkye ehlaiti zon otehchi otles tyes aghahilon. ");
INSERT INTO bea_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kahchu yechiwoteh. Tyeke khaghahta mehotles chihutli Phariseene, kahchu mehotles chihutli Herod natunne. ");
INSERT INTO bea_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kahchu inchioohwatatyech, kooh atuli otles tyes assii ihe. ");
INSERT INTO bea_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus atawotihchi, toowe ehti, Yehoo gha inchiootahtyech aoontye atu otles tyes ahi? atu ka atawahtihala, atahtsuk koole? kooka naghadzye natatsutooh sahoohwaoontye? ");
INSERT INTO bea_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Naghatai chu ooli, atu ookanahtghaala? naghaji chu ooli, atu atahtsukila? atu chu kyejetahtila? ");
INSERT INTO bea_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kooya tseghila tsi hlahcheti otles tyes hlahcho ootatye keoneti keoneti ketyi enetyi, tanetyi kloke ghaisis tadesmanooh nachatanatyetl nita la? Toowe yehti, Keneti onketi matgha. ");
INSERT INTO bea_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kahchu taiuchi aline kootghasitich tikooh keoneti keoneti ketyi enetyi, tanetyi kloke ghaisis tadesmanooh nitalala nachatanatyetli? Toowe yehti, Taiuchi. ");
INSERT INTO bea_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Toowehchu yehti, Yehoo gha atu atahtsak aoontye? ");
INSERT INTO bea_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kahchu yuhchityesha Bethsaida tsi; kahchu kiyananihtyi teze mataituehi, kahchu kichiniooghanunisit yakatutihi. ");
INSERT INTO bea_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kwa yila inchut ayi teze mataituehi, kahchu nito kwa tsi achuyetehti; kahchu yatai keghizek tsi, kahchu yakahtehtichoo, taoontya yehti ooli ghiila. ");
INSERT INTO bea_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kwa yachi tahyatii, kahchu ehti, Tane ghussi tachin etotyeni. ");
INSERT INTO bea_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kahchu yatai katehtich, kahchu yitige ookanahta yehti: kootoo oochu oontyei, kahchu aitye tane oochu ya-iine. ");
INSERT INTO bea_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kahchu yakwa tsi yeteha, toowe yehti ihe, Atu otsitaooya nito kwa, atuline chu tataoonti nito kwa. ");
INSERT INTO bea_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus hadesha, yaotatichne chu nito kwa tsi Caesarea Philippi; otsighatelu, Taootya yaotatichne tsi ehtilon kooh yehtiihe, Mea ali saghatya tane? ");
INSERT INTO bea_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kahchu toowela ghati, John tanetukeghinkliti tane ali: ahwole tahkine Elias ghati; kahchu achune atanetaihchi atawotine tane. ");
INSERT INTO bea_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kahchu toowe yehti, Ahwole mea ne ahlaoontye? Kahchu Peter ateyatetla kahchu toowela yehti, Nuni ayi Christ. ");
INSERT INTO bea_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kwa yatati atuli tsi hohohoontye atuneoo. ");
INSERT INTO bea_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kahchu tyi yaotatich, teze chue atghazi ooli kawotoohunne, kahchu yenaooli hoola ale, taneghaotatichi metihi chok yu, adesklesne chu, kahchu tsazughelyu, taiti dzinee kaohtzut ate kahchu tsitike naootezi. ");
INSERT INTO bea_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kahchu ehtii ayi zake tanenichi. Kahchu Peter nayanaun, kahchu tyi chuhootatyech. ");
INSERT INTO bea_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ahwole natanyesha tsi yaotatichne chu kanehtgha, Peter chuatatichlon, toowe ehti ihe, Satuchi otsidiya nuni atsinde metselihi: atu indi natih Nagha Tgha tsi tatyesuttih, yaghi zon ooli tane tsi tatyesuttih. ");
INSERT INTO bea_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kootoo tane tsi tyechi ehti yaotatichne chu toowe yehti, Ooline sakehtayeh ati, inkai oochit atu tuti ninayatooalli matsookhatayaghi, kahchu nakehtuyesi. ");
INSERT INTO bea_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ayih sye nayaghoohtalon kyehghata kehe, tghayatualassi; ayi tayadesooatai kyehghata kehe suni tsi kahchu otich oochu chu, ayi nayahoohtezi. ");
INSERT INTO bea_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yechiha yatsi ewoyuesiha tane, tike okehe ootanatsut ateoo, tatsinde tghayaghatyeshai ate? ");
INSERT INTO bea_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ooli sitah tyesooite taghatai tah? ");
INSERT INTO bea_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ooline siooyale tane zake chu chode soochaghachatai chu kyidyetseli chu tanegha; ayilon atane tane chue yaooyaooli, kootoo yuhchininiye ate kochi soochunetyi Matgha keotichne oochune chu. ");
INSERT INTO bea_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","KAHCHU toowe yehti, Kwa hli anaghaisii tahkine chode natehyane atu koozetse nio-olyezi, naooghatyitsi ooli ate Nagha Tgha kyeyi khoonao-ozit ate mehnatsutsutti yu. ");
INSERT INTO bea_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Edzetaiti dzine kloe Jesus Peter chu, James chu, John chu hlyekeghatechlon, kwa hlilon otsighatyesha khis tsi ohtye nataghisatti sahte ooghatyi: kahchu yakaitghaityeh achu meotati. ");
INSERT INTO bea_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kahchu makestue mesaniti takulli kye yas etye; atuline chode tike hahtye takulli awolene ooli. ");
INSERT INTO bea_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kahchu klohnaaghityetl Elias chu Moses chu: kahchu inchiooghatatyech Jesus chu. ");
INSERT INTO bea_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kahchu Peter otyesta, toowehchu yehti Jesus tsi, Metihi, chode itli gha oochu: inkai taodatyedi kwa aootlihi; ehlaiti nuni gha, ehlaiti Moses gha, ehlaiti Elias gha. ");
INSERT INTO bea_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Atu ti kehe atu ataotihi ihe; ohtye oonighanintyetl ihe. ");
INSERT INTO bea_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Koos inchi ghililon: kahchu sa ooghatitsuklon yatsi, toowe otieh, Tai la se Chue menusli: Soozehtso. ");
INSERT INTO bea_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Intyizon, aoonetye ookaghanehtha, atuline otehchi kiya-i, Jesus zon kooyehkatech. ");
INSERT INTO bea_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Khis chi chyesta ghatestyetlyu, yanaootatich atuline tataeonti ooli ohwehtyi, teze Chue niiya ate zon mazetse otsi. ");
INSERT INTO bea_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ayi zake kaghaghatalon, ayi yea tane zetse achatya oontye toon ghlaghatati. ");
INSERT INTO bea_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kahchu yehoo gha kiyehti, atesklesne yehoo gha koohatya oontya Elias hatse naoojezi? ");
INSERT INTO bea_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kahchu ateyatetlalon, yatatio yu, Kwa hli Elias hatse niya, atghe chu ooli sookah nioonila; kahchu takehnichatinkles akehe teze Chue ihe, natlon ooli kaootoohanu, kahchu menachule. ");
INSERT INTO bea_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ahwole suni anaghaisii aoontye, Elias kwa hli nooja, akooghati sikooh kooyekechatihtihch, takehnichatinkles akehe atanewoh. ");
INSERT INTO bea_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kahchu yaotatichne wohniya tsi, tane natlone yehkyatich chu yailon, adesklesne chu, taoontya tookooyetilon. ");
INSERT INTO bea_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kwete atghe kiya-ichi, atghe kaooghalilon, kahchu kichiodehsut yilaghinchutlon. ");
INSERT INTO bea_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kahchu adesklesne tsi, Taoontya nayeti? ");
INSERT INTO bea_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ehlaiti chu tane natlodi otsi ateyatetla toowechu yehti, Metihi nananihtyi sachue ayehi atsinde saititakli; ");
INSERT INTO bea_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kahchu oolita yihchut assiti koohoontye yayaghinchil: maza tsi oohwoos ooli chu, maghoo natazutsun chu, toontyiyazighai chu: kahchu taoontya kooyesi mawotintichne ghakitoohai gha; kwa hli kooyandatla. ");
INSERT INTO bea_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ateyatetlalon ahwole toowe ehti ihe, Naghai naghaje toontooe assine, taisa tsi otsi naghai aoostya aoontye, taisa tsi otsia naghatagha ooslya aoontye? Sananaha. ");
INSERT INTO bea_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kahchu kiyananiooh: ya-inchi kwete atsinde kooghoontye yayaghinchil; kahchu tike nadsut, kahchu yatatatyech maza tsi wohoos hailyi. ");
INSERT INTO bea_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Taoontya yatgha tsi ehti taisa toh otsi kooh hoontyontya? Toowe yehti tsito ali toh otsi kooh hoontye. ");
INSERT INTO bea_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oontlon chu tsichataintyi tyenayehtyech ahoo yu, chahteayuliassi: ahwole oolita aotunatlihlon ate, ahoohchunaya, kahchu ahachinootyeh. ");
INSERT INTO bea_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus toowe yehti, Aha koodinti ate, atghazi ooli nakeotoonezi ayi aha kooti. ");
INSERT INTO bea_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kahchu kwete ayi tsito tatgha tsi otyesta, toowehchu ehti manatu ooli, Naghaghintai, kwa hwe a koosti; oochinootyeh atu a koodestihi. ");
INSERT INTO bea_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus wa-ichi tane yuhchiinhlaghatelyu, atsinde metselihi tsighotye, toowe yehtie, Nuni naza oontooehi najih oontooe ahoo yu atsinde nali, ohtye anesii, yuhchihadiya matsun tsi, atu chu mazi kahchu taooya. ");
INSERT INTO bea_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kahchu atsinde otyesta, kwete chu yayaghinchil, kahchu yatsun tsi ghotyesha: kahchu tane zetse etyelon; ayiwola natlone, Tehtsut ghatya aoontye. ");
INSERT INTO bea_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ahwole Jesus yila inchut, kahchu tahyatihtyih; kahchu tsitike nesta. ");
INSERT INTO bea_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kootoo kooyachi nito kwa, yaotatichne sahti wahtila yehtilon, Yehoo gha naghai atu nanitun oontye? ");
INSERT INTO bea_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kahchu toowe yehti, Haoontyedi atu ghatyeh ooli ihe ghachatayach, neaghasuchuli zon atu atsutsits ihe chu. ");
INSERT INTO bea_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ieti otsi achughatestyetl, Galilee chu kyechoghatestyetl; koohchu kootilon atuline atawo-otihi. ");
INSERT INTO bea_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Atai yaotatich ihe yaotatichne, toowehchu yehti, Teze Chue tsataghinsut tane tgha, kahchu kizoohelassi; kahchu tsazehai ate, kahchu tsitike nawataizi taiti dzinee. ");
INSERT INTO bea_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ahwole atu ooghatitsukoo ayi zake, kahchu taoontya kiyutekhai ooianh kyeghanejit. ");
INSERT INTO bea_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kahchu yuhchidesha Capernaum: nito kwa oota ati otye taoontya yehtilon, Yea khama ootahtyechii atghunni otichi? ");
INSERT INTO bea_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aghoo atu yachutyehlon: aghatai hahte atghunni otichi hoonchati inchi sooghatatyechlon, mea otehchi chatinchai kha. ");
INSERT INTO bea_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kachu nesta, keneti onketi matgha tyechi yehti, kahchu toowe yehti, Ooline haladi tooshai ate, ayi zon hli haistlachi ayuhezi, kahchu tane gha aoonetye gha keo-otechassi. ");
INSERT INTO bea_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kahchu tsito niyatihtyi, kahchu tane kuzze nayenihti: kahchu yakoone yinchut tsi toowe yehti, ");
INSERT INTO bea_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Mea so niyatuhtyeloo ehlaiti ayi etye tsito sindizi kehchi, suni nisatintyi: mea so nisatuhtyeloo, atu suni nisatintyi, ahwole ayi yuhchisatyehai. ");
INSERT INTO bea_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kahchu John ateyatetlalon, toowe ehtie, Meti, ghityii ehlaiti atsinde metselihi hayateha nindizi ihe, atu chu naghaketayeh: kahchu nanitun, atu naghaketayeh ihe. ");
INSERT INTO bea_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus toowe ehti koole, Atu nanaghahun, atuline keoosahch akehe keo-oahchassi sindizi ihe, kwete ketseli hakehe sachuohooteissi. ");
INSERT INTO bea_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kahchu ayi atu chahte anahilai naghachinati. ");
INSERT INTO bea_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mea so chu naghaooalu ehlaiti tsa taismanni tu woton tsindizi ihe, Christ ezon manatunne aghli, kwa hli anaghaisii, atu tayatooalassi machitikechalihi. ");
INSERT INTO bea_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kahchu ooline chahteayile assine ehlaiti tidi natsutli aha sooti, otehchi ootaizi atunewoh mehnachahtune kazze tsye ma koos echaghesklu ate, tyechunnityeh ate tu chok ticha tsi. ");
INSERT INTO bea_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kahchu nila chahtontye ate, hlyenihul: otaihchi oochu nuni gha kweghoya tsaghatati achaghilihi ihe, nila onketi aghoo kochi otsitiya iyu aoontye khoon metselihi tsi, khoon atu nanatsaisti: ");
INSERT INTO bea_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nootya atu taikyehti, khoon chu atu nanatsaisti. ");
INSERT INTO bea_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kahchu nakye chahtontye ate, hlyenihul: otaihchi oochu nuni gha kweghoya tsaghatati achaghilihi ihe, nakye onketi aghoo ghotsinachatutyeissi khoon metselihi tsi, khoon atu nanatsaisti: ");
INSERT INTO bea_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Noota atu taikyehti, khoon chu atu nanatsaisti. ");
INSERT INTO bea_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kahchu natai nihe atu oochu ookaitghai ate, hanehchul: otaihchi nawotaizi Nagha Tgha tike tsi oowooeissi natai ehlaiti ate, natai onketi aghoo ate otsinachatuhtyelassi khoon metselihi tsi: ");
INSERT INTO bea_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nootya atu taikyehti, khoon chu atu nanatsaisti. ");
INSERT INTO bea_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aitye tane sootakun natghachulelassi khoon ihe, tsichatullihi assi chu sootakun ihe matghaachulehesi. ");
INSERT INTO bea_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sootakun oochu: ahwole sootakun natuetah sootakun matghachilihi, tyeha kyehea sootakun matgha awahhliha? Sootakun kyatihch, kahchu oochu eotine klahtyi. ");
INSERT INTO bea_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","KAHCHU iiti otsi niiya, kahchu yuhchiklodesha Judea ti otaihchi Jordan natyechi: kahchu tane yinkhatyesha; kahchu tane ootanaun akehe kooh otye keeoach ahli taneghaotatyechoo. ");
INSERT INTO bea_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kahchu Phariseene yechitestyetl kahchu taoontya yehti, Oochu la teze tatsiyue yechanaolohu aotezi? kikaotyehunooh. ");
INSERT INTO bea_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kahchu ateyatetlalon toowehchu yehtilon Tyeha kehe anaghehtya Moses? ");
INSERT INTO bea_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kahchu toowe ghati, Moses hatyeh kha syeklah takehnichatinklessi o-ochatihtyehi adusklesse, kahchu oonchatoohtyellu. ");
INSERT INTO bea_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kahchu Jesus ateyatetlakahchu toowe yehti, Naghadzye natsut akehe ayi ihe naghatsi achateskleslon tidi sa. ");
INSERT INTO bea_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ahwole hatseto otsi tike ooli toh Nagha Tgha teze oola tsege chu. ");
INSERT INTO bea_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ayi otsi teze tatgha echeli to chu kahchu tatsiyue kah awoti; ");
INSERT INTO bea_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kahchu kooh chu onkeghatatye kootsun ehlatootyesi: atu otaihchi onkyeghatutyesi ahwole kootsun ehlatootyesi. ");
INSERT INTO bea_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Oo ayi Nagha Tgha tsayaghehtichii, atuline inchake niyulel. ");
INSERT INTO bea_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kahchu nito kwa oota yaotatichne taoontya yehti kwaka inhligi tsi. ");
INSERT INTO bea_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kahchu toowe yehti, Ooline assine tatsiyue odehtyetine achune chu makahtueh akoochaile ate, soocha keoach. ");
INSERT INTO bea_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsege chu tatsiyue odehtye, kahchu makahtueh achilai ate, soocha keoach. ");
INSERT INTO bea_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kahchu kiyananihtyi tsito yechihai, yekatootihi; yaotatichne yachuootatyech ayi naghanihtyisi ihe. ");
INSERT INTO bea_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ahwole Jesus wa-ichi, ohtye atu minihtike ooghilelon, kahchu toowe yehti, Ghateh kooyasahlah tsito yechihai sachaghatutyeli, kahchu atu nanahahun: ayi ihe nao-oaizi Nagha Tgha kyeyih tsi. ");
INSERT INTO bea_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kwa hli anaghaisii. Ooline atu niyatiooti Nagha Tgha kyeyih yechinekehchi atu Nagha Tgha kahchi koowoyezi. ");
INSERT INTO bea_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kahchu yakoone ihe niyatintyih, kahchu yakatihtich, kahchu oochu yachi indityesa. ");
INSERT INTO bea_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kahchu yitai tyesha atghunni kehchi, ehlaityi yuhchidesha ghatlelhu, kahchu yachinachustatalih, kahchu taoontya yehti toowe, Oochu Tanechiotyihi, tawoshlaitea ahtaze wostazonha? ");
INSERT INTO bea_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kahchu Jesus toowe yehti, Yehoo gha oochu indityesa sindilon ha? atuline oochu oontye ehlaiti zon, ayi Tikeaootli. ");
INSERT INTO bea_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sa tsiwohzon atanati, Atu soocha aoonta, Atu chu tane zaoohel, Atu chu anaooih, Atu chu ketselihoo tsiwotahoontich neotinoo, Atu chu tane nawoah, Ohtye taghooncha natgna chu noo chu. ");
INSERT INTO bea_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kahchu ateyatetlalon toowehchu yehti, Taneghaotatich, atghe tidi kama indityeaiih yeshihto otsi. ");
INSERT INTO bea_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kahchu Jesus yakaihtgha, yuntyeh, kahchu toowe yehti, Ehlaiti ooli nainchi tehtsut: ootinta, anehisi anetye mataghaneli, tyetaisanaine chu ghatanale, kooh ohtye natatootlosi ya tehchi: kahchu yuhchidiya, kahchu ninaootiah ayi sookatiya-i, kahchu sakehtiya. ");
INSERT INTO bea_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kahchu atu oochu indityesalon ayi sa tachi, kahchu yitaityeshalon atu keneli ihe: atane ohtye ooli natlon ayehilon. ");
INSERT INTO bea_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kahchu Jesus klokanatgha, toowehchu yehti yaotatichne, Tewotye atatlate ayine matatintlone kwewootyelassi Nagha Tgha nataghe tsi! ");
INSERT INTO bea_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kahchu yaotatichne yazake kaooghulli. Ahwole Jesus ateyatetla kahchu toowehchu yehti, Tsitohkaine, tahtye indatlaooh ayi kiyasooli mehmehetatintlon kwewootyelu Nagha Tgha mataghe tsi! ");
INSERT INTO bea_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ayi kyeotunni ghatai kwewotyizoo apetsiche kaookoodi, o-ochi matatintlon ehlaiti teze kwewoya Nagha Tgha nataghe tsi. ");
INSERT INTO bea_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kahchu o-ochi ghaooghali, toowe hlaghatati ihe, Mea mechua aghatoota? ");
INSERT INTO bea_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kahchu Jesus yakaitgha toowe yehti, Tane la atu kookechi nioontsit, Nagha Tgha la atu kooh hoontye: aha atane Nagha Tgha atghezi ooli mahechi nioontsut. ");
INSERT INTO bea_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kahchu Peter toowe tyi ehti, Nea anetye kyecho tasityetl, kahchu naghakyehtasityetliih. ");
INSERT INTO bea_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kahchu Jesus ateyatetla toowehchu yehti, Kwa hli anaghaisii, atuline ooli kyeghachelihine nito kwa, mekye koole, mehtghizze koole, matgha koole, ma koole, matsiyue koole, maskyege koole, matsatle koole, suni ihe, kahchu otich oochu ihe, ");
INSERT INTO bea_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ahwole otsinitooalassi keonetyi ketyi otehche enetyi too, nito kwane, mekye chu, mehtghizze chu, matgha chu, ma chu, maskyege chu, makyeyih chu, kahchu tsookatayaghi chu; kahchu achu tike tsi ghonioonizut ate kwihzon ehchaghatai. ");
INSERT INTO bea_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ahwole natlone haladi atine haistlachi awotyeissi; kahchu haistlachi atine haladi awotyeissi. ");
INSERT INTO bea_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kahchu atghunni aghatii Jerusalem otsi ghatestyetlu; kahchu Jesus yaghatyesha: kahchu kawoghuli; kahchu kiyahsellu oonighanityetlon. Kahchu niyatila keneti onketi matgha kahchu yatatati yesoo yuhniyi ihe, ");
INSERT INTO bea_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Toowe ehti ihe, Nea Jerusalem otsitatyetl; kahchu tane Chue niyatoohtyelassi taneghaotatich tyiyine, adesklesne chu; inkai mazetse ooli kiyehtlon, kahchu kiyaniyutyelessi achunene; ");
INSERT INTO bea_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kahchu kiyachaochesi, kahchu kikatootoozassi, kahchu kikyehoozekassi, kahchu kizoohelassi: taiti dzinee awooche ate tsitike nawootyeissi. ");
INSERT INTO bea_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kahchu James chu John chu, Zebidee chue, yachidesha toowe yehtie, Taneghaotatyechi, kooh koosti aghaawoti akootiti sikooh. ");
INSERT INTO bea_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kahchu toowe yehti, Yea sachi nioonunassit naghachanasti? ");
INSERT INTO bea_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kahchu toowe kiyehti, Aghaniah sookah ookyetih, ehlaiti mehoonati, hligi oosklaghazihtye, nachatinchai kehe. ");
INSERT INTO bea_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ahwole Jesus toowe yehtii, Atu atawahti ooli ootahkyeti: atu mihe tuwahto la ayi tsa mehtughastoii? kahchu tunaghakechuhkliti ayi mehtanekhaitsikliti ayi ihe nehsakaichihkliti? ");
INSERT INTO bea_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Toowe kiyehti, Atu ahandatla. Kahchu Jesus toowe yehti, Kwa hli tuwahtoissi tsaeh ieti otsi tughastode; kahchu ayi mehtukhaitsihkliti mihe tusakechihklitii ihe ayi ihe mihe naghakyechuhklitassi: ");
INSERT INTO bea_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ahwole wostyi chisinchi chu tayaghetichu oosklaghazintye atu si senatunne eli kaooali; ahwole kooyachulelassi ayine kooya so-ochesunne, ");
INSERT INTO bea_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kahchu kenetyine aghatitsuk chi ohtye atu yatsi kyehanelilon James chu John chu. ");
INSERT INTO bea_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ahwole Jesus tyechi yehtilon toowehchu yehti, Atawahti ayi kechanehtya kehe kikaootsutti ayi achune kooyakeolech; kahchu kootaityiye kooyaghatah. ");
INSERT INTO bea_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ahwole naghai atu kooh akehe naghahtyeissi: Ahwole ayi koonoochu sachatoohcha kooti, naghani ayi nagha keo-otichassi: ");
INSERT INTO bea_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kahchu ooline assine naghani ihe haladi miindichatoesi o-ochi chatoohchai gha, tane glia keo-otichassi achanetye gha. ");
INSERT INTO bea_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ayi aghoo teze Chue atu makeochatichi ihe yuhchideya, ahwole tane gha keo-otichassi, kahchu khaooallu yeghataisi natlone yatachi ootane. ");
INSERT INTO bea_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kahchu nighanintyetl Jericho: kahchu Jericho otsi hatayaooh yaotatichne chu tane natlone chu, mataituehi Bartimaeus, chue Timaeus, tinkuzze satah tyechihi ihe. ");
INSERT INTO bea_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Atitsuk chi ayi Jesus Nazareth chihtatyezutti, ohtye tyi otyesta, kahchu toowe yehti, Jesus nai chue David, soonchoonaya. ");
INSERT INTO bea_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kahchu natlone yatati atu awotihi gha: hoontye ooli otaihchi ohtye otyesta, David chue, soonchoonaya. ");
INSERT INTO bea_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kahchu Jesus hlininiya, kahchu kwehakehe ehti. Kahchu tyechi kiyehti ayi teze mataituehi, toowe kiyehti ihe, Kyeneneli, niiya; tyechi nehti. ");
INSERT INTO bea_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kahchu ooyadehchus yiatehtakadi, niiya, kahchu Jesus tsidyesha. ");
INSERT INTO bea_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kahchu Jesus otyesta toowehchu yehti, Ye sachinioonunisita anusleha? Ayi mataituehi teze toowe ehti, Aghaghintai, setai saanaoontlihi. ");
INSERT INTO bea_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus toowe yehti, Taihchi ootinta; na-ihe naghinta. Iitetyeh matai naootli, kahchu Jesus kyehtesha atghunni. ");
INSERT INTO bea_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kahchu hwa aghatyi Jerusalem, Bethphage chu Bethany chu chisinchi, khis kuchi Olives aghatyi, yitaityeha onketyene yaotatichne, ");
INSERT INTO bea_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kahchu toowe ehti, Taihchi otsitahtyel yito kwa oontlo chi naghanataihchi: kahchu kweghaachatyeh soosooklya aghahtyelassi taghaklu, atu makai achatyi; tahwahut, kahchu yuhchinaghahtyel: ");
INSERT INTO bea_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kahchu ooline toowe naghai tyete, Yehoo gha koohghahtya oontye? kooh taghahti, Metihi tiye hehti; kwete cho otsi nayaduesi. ");
INSERT INTO bea_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kahchu yitaighatestyetl, kahchu soosooklya kiyintyi taghaklu tusklahooka atghunni yaghintyidi; kahchu tahkiyainghut. ");
INSERT INTO bea_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kahchu tahkiae iiti naihyani toowe kiyehti, Yehoo gha kooh hahtya oontye taghautti soosooklya? ");
INSERT INTO bea_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kooh kiyehti koohotye ayi Jesus akooyehtii: kwa kootayinchut. ");
INSERT INTO bea_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kahchu soosooklya Jesus gha naghunihtyi, kahchu kiyeatetahkatti keghihla; kahchu yakaisata. ");
INSERT INTO bea_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kahchu natlone kiyeatetahkatti atghunni tsiyaghestla: kahchu achune naghaghihul tatsi tachin tsi, kahchu ghatyeh atghunni ghatunihla. ");
INSERT INTO bea_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kahchu ayine haladi atine, kahchu ayine tanekeghatailhne, oghatyesta, toowe ghatieh, Hosanna; Moohchuootaya ayi yuhchideshai yindizi ihe Naghaghatai: ");
INSERT INTO bea_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Koonoochu moohchuootaya manataghe nagha tgha David, yuhchideshai tindizi ihe Naghaghatai: Hosanna ayi zon o-ochi yataihchi miindiotehah. ");
INSERT INTO bea_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kahchu Jesus kwiya Jerusalem, o-ochi tyetachatlihi kwa chu: kahchu kootoo anetye ooli ookaghanehtghachi, kahcu kahkachi aoocha koohnioonizutooh, hadesha Bethany tsi keneti onketi matgha chu. ");
INSERT INTO bea_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kahchu naodike tsi, ooatastyetl Bethany tsi tapat: ");
INSERT INTO bea_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kahchu chiche chok chine toontyetsi ya-i maton ooli, yuhchidesha intyizon ooli ion ate: yuhniya tsi aton zon yilah; atu ka chiche nichatilesti kho nioonizut ihe. ");
INSERT INTO bea_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kahchu Jesus otyesta toowehchu yehti, Atulire otsitsassi chiche nai ihe too otsi nioonizutti otsi. Kahchu yaotatichne oohatitsalon. ");
INSERT INTO bea_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kahchu nighanintyetl Jerusalem otsi: kahchu Jesus kwiya tyetachatlihi kwa otyiyi, kahchu hayadesla ayine atagholane kahchu ataghatotane tyetachatlihi kwa otyiyi wota, kahchu yechonayadehklit yakeehtai ayine sooniya klaghayihne, kahchu yestahi chu ayine oyetli tagholane; ");
INSERT INTO bea_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kahchu atu hatyeh yasehlai iyu maaoontye ooline yatooai oolita tatawochulihi tyetachatlihi kwa otyiyi oota. ");
INSERT INTO bea_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kahchu yaotatich, toowe yehti ihe, Koo atu kooh akehe nichatinklessi la, Sa kwa anetye tane tyetachatlihi kwa wowohyih? Ahwole kooh awahtla anoosine take. ");
INSERT INTO bea_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kooh adesklesne chu taneghaotatichne tyiyine metihi chu oohatitsuk, kahchu oonkhaghanatgha tyeha kehe chahteakiyule gha: yeghanejit ihe, aitye tane khaooghulli ihe yachihootehe. ");
INSERT INTO bea_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kootoo kahkachi ooli tsi, hadesha nitokwa wotyih tsi. ");
INSERT INTO bea_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kahchu hatlindo aoocha, taihchi ghataihlu chiche chine maghaye otsi ya-ikoonoo kiya-ih. ");
INSERT INTO bea_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ayi Peter kyejetitihyu toowe yehti, Taneghaotatyechi, makintgha ayi chiche chine atu tyeswe adintii kwa sakoon. ");
INSERT INTO bea_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kahchu Jesus otyesta, toowehchu yehti, Nagha Tgha aha oodinti. ");
INSERT INTO bea_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Atai kwa hli anaghaisi, ooline ti khis atyetane, Achu ninintsit kahchu otsinachatoohtyeli tu chok tsi; kahchu atu tawahkootye ate tadzye ihe, ahwole ihe kootilon ate ayi ooli ehtii sakyehchi niwotsitti; awohiisi atghazi ooli tyekootesi. ");
INSERT INTO bea_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ayi ihe anaghaisii, Ooli si nioonunisitassi, aghaswehlye ate, ihe kootahti nitaghahali, koohzon naghahaisi. ");
INSERT INTO bea_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kahchu natahya otye aghaswehli intyizon ooline oolakehe chahte meititaai ate: Nagha Tgha naghai chu ya tehchi ati naghaoochatoohulassi nagha metselihi. ");
INSERT INTO bea_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ahwole atu ootalai ate, atu naghani chu Nagha Tgha yatehchi ati naghaoodohulassi nagha metselihi. ");
INSERT INTO bea_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kahchu yuhchighatestyetl Jerusalem tsi: intyizon ghayahlhu tyetachatlihi kwa otyiyi oota, yinkhadesha taneghaotatich metihi tyiyi, kahchu adesklesne, kahchu haladi meindi chatehaneh, ");
INSERT INTO bea_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kahchu toowe yehti, Ye makaoonatsut ayiwoh keoonaahch aoontye? kahchu mea nayiwa tidi kakaoodzutti keoonaahchi tidi ooli? ");
INSERT INTO bea_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kahchu Jesus ateyatetla toowehchu yehti, Suni chu ehlawotatye taoontya naghosyeassi, kahchu satatahti ate, naghatatuhsi ye kakaoodzutti kooh akehe kewohahch aoontye tidi ooli. ");
INSERT INTO bea_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Matukeghihliti John yataihehi otsi la tatyesut oontye, tane tsi koole? kootatinti. ");
INSERT INTO bea_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kahchu inchiooghatatyech, toowe ghati ihe, Koohtitye ate Yataihchi otsi; kooh tootyezi, Yehoo gha tawah tahtyaoontye? ");
INSERT INTO bea_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ahwole koohtitye ate, Tane tsi; tane eghanejit: ayiwo aitye tane koohkiyehti John, yaghi kwa hli tanetaghatahchne ali. ");
INSERT INTO bea_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kahchu ooghatyesta kahehu Jesus tsi toowe kiyehti, Atu koowoti. Kahchu Jesus otatihch toowehchu yehti Suni chu atu naghatatuhsesi naghakaoodzutti ayi ihe keoonaahch tidi ooli. ");
INSERT INTO bea_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","KWA tyi yaotatich yiheaghasule. Ehlaiti yaghi tane oonehye chiche chok chine ochunehyehti, kahchu anetye ootaisuggi oola lon, kahchu hayaghinkyetlon ayeti chiche tu taaoohklitigha, kahchu nayaghintsih khaghatai kwa, kahchu yaniyiooh oonehyene tane, kwa tontyetsidesha. ");
INSERT INTO bea_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kootoo koonioonizutooh otsiyateha ayi ehlaiti yakeotiche yinkhadoya natlone tezoo, yayual assilon chiche natlone tezoo chiche chine oochunihyehi tsi. ");
INSERT INTO bea_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kahchu nighatintyi, kahchu kikutatooz, kahchu tahzoh achukihteha. ");
INSERT INTO bea_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kahchu yachideha achune woaine; kahchu ine tsihadehyitl, kahchu tsinakoozehai yetsi ihe, kahchu achukideha maooya ooli. ");
INSERT INTO bea_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kahchu achune otsideha; kahchu ayi hazehai; kahchu achune natlone, tahkine chu kikutatooz, tahkine chu kizehai. ");
INSERT INTO bea_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kwaka ehlaiti machue ayehi, o-ochi mandayadetlahoo, ayi chu haistlachi yachiyadeha toowe ehti ihe, Kiya indi nootghahassi sechue. ");
INSERT INTO bea_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ahwole ayine oonehyene tane toowe hlaghatati, Tunela katsila kakaoozutassi; kwa hoote zaoogheli, kwa naghani kakao-odzutassi. ");
INSERT INTO bea_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kahchu nighatintyi, kahchu kizehai kahchu khakitihtyi chiche chine ochenihyehti iite otsi. ");
INSERT INTO bea_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yea aaoti ayi kakaoodzutti chiche chine ihe ochanahyehi? yuhchinatlone chahtawoleissi oonehycne tezoo, kahchu achune chiche chine ihe ochanahyehi ghaooalassi. ");
INSERT INTO bea_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Koo kahchu atu makeh ootaghatechila tidi aduskles; ayi tsye kiyenali? ayine nito kwa aootline ayi hatse oohniya sookewostidi: ");
INSERT INTO bea_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tila Aghakaoodzutti makyeoahchi, kahchu ohtye kawochulih naghataitgha? ");
INSERT INTO bea_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kooh chu oonkhaghanatgha kiyuhchutigha, ahwole tane eghauejitlon: aghatane atawo-otihi ihe ako-oyehti ihe ayi meaghasoochali: kahchu kiyechutestyetllon, taichi ghanintyetl yu. ");
INSERT INTO bea_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kahchu kichiteha tahkine Phariseene chu Herodiana chu, kiyukluhchi gha yazake. ");
INSERT INTO bea_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kootoo nighanintyetl tsi, toowe kiyehti, Taneghaotatich atawotihi hlodinti, atu chu ooline inaoohoontyiassi: atu chu kyinditaniha tane oontya kehe, ahwole taneghaodintich Nagha Tgha oontya kehe matlontideh: Tsiwohzon la machulelu mehtikechilehe sooniya Caesar, intooe ate chu? ");
INSERT INTO bea_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaooyeli la, atu kaooyeli koole? ahwole atai atawonatioo meaneahe, toowe yehti, Yehoo gha sakaootahun aoontye? sananahah sooniya satsoone, wosyekhai. ");
INSERT INTO bea_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kwa nakiyiooh. Kahchu toowe yehti, Mea achintye sikooh kahchu takehnichatinklesi mindizi? Kahchu toowe kiyehti, Caesar tsi. ");
INSERT INTO bea_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kahchu Jesus ateyatetla toowehchu yehti, Caesar ghanahah ayi ooli ayahi Caesar, Nagha Tgha chu ooli ayahi Nagha Tgha. Kwa Kiyaoolih. ");
INSERT INTO bea_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kootoo kooyinkhachatestyetl ine Sadducee yaghine nachaghintai oontooe ghatine; kahchu taoontya kiyehti toowe ghati ihe, ");
INSERT INTO bea_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Taneghaotatyehchi, Moses aghaadusklesiih, Ooline mekye tehtsut, ate, matsiyue chu yechodyesha ate, kahchu tsito atu yechodyesha ate, mekye matsiyue niyatahtyeloo, yaskyege yayanuhi tsito mekye. ");
INSERT INTO bea_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oowhilihi taiuchine hlyehligi ghili: kwa ayi hatse tsege nitintyi, tehtsutooh atu tsito yechodyesha. ");
INSERT INTO bea_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kooh chu haladi tachi tsege ninayatihtyi kahchu tehtsut atai chu atu tsito yechodyesha: haladi tachi ayi chu kwaka hlyeih. ");
INSERT INTO bea_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kahchu taiuchi aline aghahiii, kahchu atu tsito yechoghatatyel: hli haistlahchi ayi tsege tehtsutii. ");
INSERT INTO bea_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hooghaghintyetl tsi, tsitike ghaiskye tsi ooli ate mea soo ate yakahoota tyiooh? taiuchi ghili aghanetye kookahsatalon. ");
INSERT INTO bea_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kahchu Jesus ateyatetla toowehchu yehti, Atu kha yaghayala, atu itawahtihi ihe, aduskles tyiyi, Tikeaootli koole manatsutti? ");
INSERT INTO bea_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kootoo tsitike ghaiskye ate koozetse otsi atu inkah tueakoochila koole atu chu hlakoochilalon; ahwole keotihchi tyiyi yeghinhtyelon yataihchi ati. ");
INSERT INTO bea_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ahwole tehtsut ine, tsitike nawokyesi: atu makyeh ootaghatyechtah ooli la Moses adusklese, tyeha yehti kat tsaghehtonti Tikeaootli yechiintechii, Suni Tikeaootli asli aoontye Abraham tgha asli, kahchu Tikeaootli asli aoontye Isaac tgha asli, kahchu Tikeaootli asli aoontye Jacob tgha asli? ");
INSERT INTO bea_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oochu natooene atu yeta odeha ahwole yaghitane gha: ayi ihe o-ochi kayaghatsut. ");
INSERT INTO bea_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kahchu ehlaiti adesklesi yahchidyesha, kahchu atitsuklon ihe inchiotatyech otye, kahchu atawotihoo tsiwohzon ateyatetlalon, taoontya yehtilon, Tyeya ootaihchi hatse tsiwotsatyehli? ");
INSERT INTO bea_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kahchu Jesus toowe hakehe ateyatetla, Hatseto tsiwotsatyehli anetye asikooh titih Nea oozintso, Israel; Naghaghatai Nagha Tgha atane zon Naghaghatai aoontye: ");
INSERT INTO bea_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kahchu maoontye Nagha Tgha Naghaghatai atghe nedzye ihe, kahchu atghe matsinde ihe, kahchu atghe nindi ihe, kahchu atghe nanatsutti ihe: ayila hatsetoh tsiwotsatyehli. ");
INSERT INTO bea_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oo ayi onkye kwa hlye oontye, toowe hakehe, Mataghoonti nehtanoone natsun matintya kehe. Oontooe tsiwotsatyehli ootaihchi miindichatoohai tizon. ");
INSERT INTO bea_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kahchu adesklesne toowe yehti. Kwa hli Taneghaotatyechi, kooh tintiih hlonchati: ehlaiti zon Tikeaootli ali; atu achune atune zon: ");
INSERT INTO bea_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kahchu machutye atghe khadzye ihe, kahchu atghe atsatitsuk ihe, kahchu atghe khatsinde ihe, kahchu atghe mehnatsutsut ihe, kahchu yuatutih yetanoone atwati yakehe, ootaihchi kyeindi ooteha ayi aghoo atghe tsichatihuli chu inghade keochaachi chu. ");
INSERT INTO bea_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus wa-inchi ooyu tahwohzon, toowe yehti, Atu tontye tsi anatih Nagha Tgha nataghe otsi. Atu ayi keh taoontya atu nichatitah ooli. ");
INSERT INTO bea_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kahchu Jesus otyesta toowehchu yehti taneghaotatyechoo sahtgha tyetachatlihi kwa tyiyi oota, Yehoo gha adesklesne kooghatya oontye Christ David machue? ");
INSERT INTO bea_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ayi ihe David atane koochati kooehtii Atsinde Oochu ihe, Kakaoodzutti kooyehtii Sakaoodzutti, Nuni sinta noohtichintye atehzonih aiseakooyasle ate tsintanine. ");
INSERT INTO bea_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David atai hoochati nai Kakaoonadzutti yehti; tyechi otsi gha machue yilontye? Tyetaisanaine kyehanelilon oochu kititsalon. ");
INSERT INTO bea_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kahchu toowe yehti machiootehe, Matsagha ghahta adesklesne, tane ayine kwaghintyene koo kestue yaintyesne, kahchu kwaghintye kyila chihchiche inchiatahachulihti. ");
INSERT INTO bea_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kahchu asta otyihti tyetachatlihi kwa, kahchu o-ochi nataghisatooh asta kwehluchayihti: ");
INSERT INTO bea_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chahte akiyila ya kwa waatyihi, kahchu tane ghanaahooh oontyes oohatatyech: ayi ti otsinighatooalassi ohtye otaihchi ketselihoo keochaahchi. ");
INSERT INTO bea_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus chu sata sooniya ninchatilesti oghade, kahchu tane ya-ih iotsi sooniya otsiyatelyihoo kweotsi nichatilihi sooniya; natlone chu tatintlone natlon kwechihatehul. ");
INSERT INTO bea_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yuhchidesha ehlaiti tsege tiesunni waatyihi ali, kahchu kwehchiyatehyitl o-ochi yaintsutli onketya sooniya satsoone toolya ehlaiti sooniya satsoone enetya eyontyi. ");
INSERT INTO bea_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kahchu yaotatichne tyechi yehti, toowehchu yehti, Kwa hli anaghaisii, tai tiesunnioo waatyihi naghataihchi ohtye kwechiyatestla, anahtye naghai ooia kwechitala sooniya nichatilesti: ");
INSERT INTO bea_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ayi ihe aghanetye kwehchighadestla kootatintlon otsi; ahwole atai yindatli otsi kwehchiyatehyitl anetye ayehesi, anetye ooli yighataisi. ");
INSERT INTO bea_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","HOONTATAHOOH tyetachatlihi kwa otyiyi tih otsi, ehlaiti yaotatichi toowe yehti, Taneghaotintichi, nea ti tsye naih atotye, kahchu nito kwa atotye chode ooli! ");
INSERT INTO bea_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kahchu Jesus otyesta, toowehchu yehti, Onaila tidih kwa tyiyi tonli? atu ehlaiti woo meachu chatuyesi tsye tasaoo nachatihulassi. ");
INSERT INTO bea_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kahchu sata klataihchi khis ke Olives ooghade tyetachatlihi kwa tyiyi, Peter chu James chu John chu Andrew chu taoontya kiyehtilon sahti aghati zahtgha, ");
INSERT INTO bea_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Aghatatinti, taisatsi ooli khoonioozit aoontye? kahchu ate taootyaoontye kootoo anetye ooli ooghade nininkye ate? ");
INSERT INTO bea_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kwa Jesus atoyatetla toowehchu tyi ehti, Tyeke atuline naghanooah: ");
INSERT INTO bea_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Natlone chu yuhchighatutyelassi sindizi kehchi, toowe ghatuti ihe, Suni Christ; natlone chu ghanooahassi. ");
INSERT INTO bea_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kahchu atahtsuk ate natsapahi kahchu natsapahi eoyu ate, atu nagha khazatawahtyel: ayi etye ooli kehchi nio-otsitassi; ahwole halohchi atuka koohnao-ozitassi. ");
INSERT INTO bea_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ayi ihe ehlaitidi tane ghataghitodeh kiyinkha ghatapah achu tanane, kahchu tane tike inchi niihach: kahchu eonetye tsi tike ootooloone tsi, kahchu wo-olyesi to khasihai tsookachatayahi chu: ayila tatyeski ochati kyeatsunatsitti. ");
INSERT INTO bea_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Awole achukhahahta naghai: naghaghatoochitassi tsiwotsatyelchi; kahchu tyetachatlihi kwa oota naghatghatsutyesassi: kahchu nanaghachulelassi haladi tsiwotyihi metihi o-ochi metihi tyiyi chu suni ihe, ayi ihe kooyeh ooghahtichoo. ");
INSERT INTO bea_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kahchu otich oochu ihe hatse kooyehoochutichassi tike okehe atghe tanane tsi. ");
INSERT INTO bea_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ahwole otsinaghachataistle ate, kahchu naghachataitsut ate, atu ahunataihchi kindiwahtsit atawahtyakehe sootasun koole ataghahkyakehe: ahwole ooli si naghachualassi ayi sakehchiaghali ayi otahtich: atu naghani otahtyech ahwole Atsinde Oochu. ");
INSERT INTO bea_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mekye taza ihe yatutsitassi azeche tsi mekye, kahchu atgha khachue; kahchu tsihone koonahchine niwotyelassi, kahchu nakiyuteissi tsazuheli gha. ");
INSERT INTO bea_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kahchu naghai tane naghachatuh Ikeassi sindizi ihe: ahwole ayi ayuhi haistlahchi otsi, ayi nachaoohtaisi. ");
INSERT INTO bea_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ahwole wa-itah ayi metselihi chahtehnitsutsiti tsi kamaotatyehchi Daniel atanataihchi atawatihi nachaghintsitti ayiti o-otooassi lon, (ayi aghasule inkai ootootsukki,) inkai ayine Judaea aline khis tsi ghatoowhezi: ");
INSERT INTO bea_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kahchu ayi tahtaghatsi nito kwa atu noocha nito kwa otsi, koole atu ayite kwewoya oolitah nitooaluh makwa otsi: ");
INSERT INTO bea_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kahchu yaghi achunihyehti oota ati atu tahnatoocha yehatyetakhati niyatooallu. ");
INSERT INTO bea_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ahwole atu oochu awohtyeissi ayine koozita tsito tehtsine, yaghine chu tsito yehtochne ayi dzinee! ");
INSERT INTO bea_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kahchu aghasuahlih nahuthataklihi atu yaske ooli. ");
INSERT INTO bea_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ayi ihe dzinee oolezi tsookachatayahi, ayi etye natooehi zon ooliih toh otsi hatseto tike ooli toh otsi Nagha Tgha ayilaii, kwa hlilon too otsi, atu koole o-otoowesi. ");
INSERT INTO bea_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kahchu atu Tikeaootli dzinee nakhasse oolai ate, atuline ootaizilon: ahwole matghachihchine tsi, yatgha-ihchilon, natya oolalon ayi dzenee. ");
INSERT INTO bea_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kahchu ooline toowe naghahtye ate, Nea, taila Christ; koole nea, yaghitih atih; atu a Kootaghahti: ");
INSERT INTO bea_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ayi ihe atu tyeswe Christ kahchu atu tyeswe ghaghatane niwootyelassi, kooh chu kiyuesi ehtole kahchu kawochuli, aghanooahi gha, awowootli iyu aoontye ate, matghachihchine. ");
INSERT INTO bea_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hoontyeoo khama-inditahsit naghani: nea, naghatasiih atghazi ooli ootagha. ");
INSERT INTO bea_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ahwole ayi dzinee, kaohtzut ate ayila tsookaehatayahi, sa ihewohelassi hatleke iza chu atu kaooalassi maootaghe, ");
INSERT INTO bea_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kahchu yataihchi sun ooli nakyelassi, menatsutsutti yataihchi ta ooli yatooloonassi. ");
INSERT INTO bea_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kwa ayiti kiyueissi teze Chue yuhchidesha khoos tgha o-ochi mehnatsutsutti chu tsatinchai chu. ");
INSERT INTO bea_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kwa iiti otsiyateha yakeotihehi tyiyi, kwa chu nachaghanoolelassi yatghachihchine tyeotatyechi otsi ninchi, o-ochi tike wolonhchi otsi kwa hlilon o-ochi yataihchi lonhchi. ");
INSERT INTO bea_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kwa hoote ookaatawahti mihe achati chiche chine tsi; kootoo kwaka matatse natsutletonh, kahchu ato nehyehta, atawahtihoo hwaza atoleh ooli: ");
INSERT INTO bea_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kooh otye naghani chu, wa-ichi tidi ooli koohnininkye ate, atawahti kwa hwa ooli, tusklah koole. ");
INSERT INTO bea_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kwa hli anaghaisii, taine yahlaniyune tanane atu koolonh oolesi, aise atghe ooli tidi achahi. ");
INSERT INTO bea_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yataihchi chu tike chu o-otooesi; ahwole sezake atu woloh oolesi. ");
INSERT INTO bea_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ahwole ayi dzinee kahchu ayi sakehchiahali atuline atawoti, ama, atu keotihchne tyiyi yatehchi atine aghoone khachue aghoo, khatgha zon. ");
INSERT INTO bea_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tyeke naghai, ootanahi kahchu aghasuahli: ayi ihe atu atawahti kooh nawizut ate. ");
INSERT INTO bea_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tezoo Chue ali ihe tezoo yetye tontyetsi tatyeh ihe, tanito kwa kyechotyesha, kahchu yatsiwosta yakeotichne, kahchu anetye tezoo keotihch akehe, kahchu ayehtii tusklah khaghatai ootanoo gha. ");
INSERT INTO bea_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ayi ihe ootanahi: atu atawahtihi aoontye kootoo nito kwa khaghatai naoochati, kahkachi koole, hatleke tatichi koole, tihchok otyesta zahtgha koole, hatlindo koole: ");
INSERT INTO bea_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Intyizon nooja ate, atu nahoohtyeloo satyechu. ");
INSERT INTO bea_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kahchu ayi anaghaisii anetye kooyesi, Oonahi. ");
INSERT INTO bea_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Onkyeti dzinee oolesta ooli kwehlachayihi passover achati, kahchu otles atu chehyutli: kahchu taneghaotatyechi tyiyine adusklesne chu oonkhaghanatgha oolakehe naoonai nighatuhtyeli gha, kahchu kizuhelyu. ");
INSERT INTO bea_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ahwole toowe ghati, Atu kwehlachayihi dzinee eli, atu tane inchiniootyelu. ");
INSERT INTO bea_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kahchu ali Bethany tih ma kwa oota Simon chusache ayahi, intyizon sata atsitsoo yuhchidesha tsege ayahi khluk tsye khaisis spikenard otsi o-ochi matahi natlon; kwa yataghataghiooh tsye khaisis yitii, kahchu yatsi kachi nayadinklit. ");
INSERT INTO bea_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kahchu tahkine atu keghaneli kooyindi ihe, kahchu toowe ghati, Yehoo gha tidi ghatsatyestka tidi khluk? ");
INSERT INTO bea_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ayi ihe ataghachulekhai ootaihchi tghakooh keoneti ketyi sooniya satsoone ihe, kahchu tyetaisanaini ghachulelakhai Kwa atu tyeswa akiyehti. ");
INSERT INTO bea_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kahchu Jesus toowe yehti, Atu machuwahti; yehoo gha machisootahtyihch? ootaihchi oochu saatyiinh. ");
INSERT INTO bea_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ayi ihe inkaa eahline tyita-isanaini, kahchueoonetye akootahti o-ochi akooyaghaklehesi: ahwole suni atu inkaa naghaasli. ");
INSERT INTO bea_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Koo hatiih machitelonh otsi: ootagha yuhchidesha yuhthlukke gha oochu nisachutyel gha. ");
INSERT INTO bea_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kwa hli anaghaisii, ooli tsi otsi tidi otich oochu moohwochatih ate tike okehe, tidi chu atii moohwochutyehesi menachutihi gha. ");
INSERT INTO bea_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kwa Judas Iscariot, ehlaiti keneti onketi matgha ihe, yinkhadesha taneghaotatyech tyiyi metihe, ooli oochadehyitli kyehodewoosh, ");
INSERT INTO bea_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oohaditsuk chi, ohtye kyehanelilon, kahchu ootagha tsi akiyehtilon sooniya yaooleli. Oonkhanatghalon tyehakehe sookah nio-otsitigha chahte autigha. ");
INSERT INTO bea_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kahchu hatseto dzinee otles atu chihyutli, kwa ooghazehai passover, yaotatichne toowe yehti, Tyecha koodinti nataghasootaoozani ate oonsitsi passover? ");
INSERT INTO bea_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kwa onkye tane yaotatichne yitai tyeha, toowehchu yehti, otsitahtyel nitc kwa otyiyi tsi, kwa matiti tagahazasi ehlaiti teze yaalu ehlaiti mehtukachatayehi taismanooh tu ihe: makehtahaz. ");
INSERT INTO bea_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kahchu kwiyesitti, toowe ahti nito kwa kakaoodzutti, Wondi achune kwa ayiti o-ositsti passover mawotastihchne chu? ");
INSERT INTO bea_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kahchu wahih naghotyesi ooncha tyinta ooli chelohchi soowachisunooh: Naghani gha iehti soowatahsun. ");
INSERT INTO bea_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kahchu yaotatichne yitaighatestyetl yuhchi chu ghatatyetl nito kwa otyiyi tah, kahchu woghiooh akooyehtiii: kahchu yatagha sooghihsun passover. ");
INSERT INTO bea_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kahchu kahkachi yuhchinooja keneti onketi matgha chu. ");
INSERT INTO bea_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ghadehtsi zahtgha kahchu eghinta, Jesus toowe ehti, Kwa hli anaghaisii, ehlaiti naghai chodeh sakaehtane chahte asooti. ");
INSERT INTO bea_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kwa tyi atu keghaneli, toowe chu tyi ghati ehlaityekooh, Suni la? kahchu hligi toowe ehti, Suni la? ");
INSERT INTO bea_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kwa ateyatetla toowehchu yehti, Ehlaiti kenetye onketi matgha ihe, yaghi tila ihe setyi tsa ihkye. ");
INSERT INTO bea_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tane Chue otsidesha, takehnichatinkles akehe otye: ahwole atu oochu oontye yaghi teze tane Chue mihe atahachahi! otaihchi o-otaizilon yaghi teze ihe atu niniya tah ooli ate. ");
INSERT INTO bea_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kahchu aghatsitsoo zahtgha, Jesus otles tyes nidiooh, kahchu merci ehti, kahchu tahke yataghiyits, kahchu yayiooh, toowehchu yehti, Nitahah, mehtah: tila sazi alonte. ");
INSERT INTO bea_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kahchu nidiooh mehtusato, kwa kayioo merci, yayiooh: kwa aghanetye ayite otsi tughatolon. ");
INSERT INTO bea_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ahwole toowe yehtiii, Tila sa tulle alontye aduskles koonde ihe, oontlo chi otsi tyechihkliti. ");
INSERT INTO bea_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kwa hli anaghaisii, atu otaihchi wostoissi machiche chiche tu chine tsi, kwa hlilon yaghi dzinee kwa kootyinusto Nagha Tgha nataghe. ");
INSERT INTO bea_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ehlaiti hyin eghachinooh khis Olives tsighatestyetl. ");
INSERT INTO bea_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kahchu Jesus toowe yehti, Anahtye naghai atu oochu inditaghaaisi suni ihe too hatleke: takenichatinkles akehe, Ooshalasi aspai ghaghatai haslai ite eonetye tsi natihassi aspai. ");
INSERT INTO bea_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ahwole tsitike netai ate, naghaghatuhshezi Galilee tsi. ");
INSERT INTO bea_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ahwole Peter toowe ehti, Inkai ahwole aghanetye atu keyaneli ate, hoontye koole suni intue. ");
INSERT INTO bea_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kahchu Jesus toowe ehti, Kwa hli anesi, tidi dzinee, tidi hatleke te, atu ka onkye otyesta tyeh tihchok, tghakooh oohchit soota-ghoontyesi. ");
INSERT INTO bea_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ahwole otaihchi otatich hloduhsi kootieh, Ahwole nakah tanesut ate ooh, atu ihlawotatehoo oohchit noodustyeisi. Kwakooye otye aghatane chu ghatiih. ");
INSERT INTO bea_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kwa koohnaghintyetl Gethsemane woyetih: kahchu toowe yehti yaotatichne, Nea aghasushlito sakyeh. ");
INSERT INTO bea_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kahchu yehtestyetl Peter chu James chu John chu, kahchu o-ochi inditatunne, kahchu matsun tah oonkhail acha; ");
INSERT INTO bea_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kahchu toowe yehti, Setsinde o-ochi atu oochu atyetatih azetse tsi: chode ahthli naghai, kachchu ootanahi. ");
INSERT INTO bea_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oontsutle wotaihai otsidesha-ih, kahchu tike wozohtih nwatsutooh kooyekehchi tyetaooklihassi sye makehchi nio-otsilon, ayi sakehchi ahalai yao-otsitooh. ");
INSERT INTO bea_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kahchu toowe ehti, Abba, Tyeih, atghazi ooli tahnootsut nuni; tidi mehtutsato saoone naniah: hoontye ooli atu suni koosti, ahwole nuni koodinti. ");
INSERT INTO bea_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kwa yahchidesha, nayintyi satyi, kwa toowe yehti Peter tsi, Simon sintyi la? atu ooniila ehlaiti meoochanehoo? ");
INSERT INTO bea_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oonahi kahchu aghasuhli, atu otsitawohazu inkaoochatauntih. Atsinde kwa hili ootagha, ahwole khazi chintyeh. ");
INSERT INTO bea_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kwa yitai tyesha, kahchu oghasulih, kahchu kwaka ayi zake ihe ootatich. ");
INSERT INTO bea_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kwa oondehsha tsi, yintyi satyi kahchu, (kootai ya-inkhai ihe,) kahchu atu ataooati atyekitooklih akehe. ");
INSERT INTO bea_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kwa tghakooh yuhchidesha, kahchu toowe yehti, Kwa hwe satyih, kahchu niwotahah mehnatahyihi: kwakoole, meoochanehoo koohnaooizut; nea, tezoo Chue mataghachila taghila tsi metselineh. ");
INSERT INTO bea_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Niahtyel, yitai tawotyeli; nea, yaghi atu oochu asehti kwa hwa atih. ");
INSERT INTO bea_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kwa kwete, kwaka ootayehchoo, yuhchidesha Judas, ehlaiti keneti onketi matgha ihe, kahchu yihtestyetlooh tane natlone simakanis pyese chu mekachatayitli chu, taneghaotatyehchi metihi tyiyi ihe, adesklesne chu hoola atityine ihe. ");
INSERT INTO bea_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ooh yaghi atu oochu ayehtii yayiooiih mehyachanitsiyi, toowe ehtieh, Ootayatasihchassine wohtsiewohzyesi, ayila ayi; nintahtyeh, kahchu yitai tahtyeh tyekeh. ");
INSERT INTO bea_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Itetyeh nooja ate, tsiwohzon yatsi anaatahlu, toowehchu ehti, Metihi, metihi; kwa yunchighachi. ");
INSERT INTO bea_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kwa kiyinchut, kahchu nighadintyi. ");
INSERT INTO bea_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ooh hligi ayiti naghatehyane tapyese natyese ghayaghachut, kahchu nayatehul yakeotihchi taneghaotatyehchi metihi tyiyi, kahchu yatsakhe tyeghihyitl. ");
INSERT INTO bea_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kwa Jesus ateyatetla, toowehchu yehti, Ihla unoosi khataachila pyese intyesi yu mekachatayitli yu tala nisataghahtyelu? ");
INSERT INTO bea_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naghaikyastaichii dzinee eonetye tyetachatlihi kwa oota taneghaodintihchoo, atu chu nisatahtyiih: ahwole aduskles tyiyi tikewokyeli. ");
INSERT INTO bea_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kahchu aghanetye kiyechodestyetl, kahchu taghoghadehsut. ");
INSERT INTO bea_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwa ehlaiti uskye yakehtehtla, atetakhatooh chatachi takulli intyedi ati; kwa uskyegoone kiyinchut: ");
INSERT INTO bea_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kwa kyechodyesha ayi chatachi takulli, kahchu tghihklah intyedi. ");
INSERT INTO bea_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kwa Jesus otsighatehtyi o-ochi taneghaotatihchi metihi tyiyi atindi: kwa ayiti atghe yeghati taneghaotatyehchi metihi tyiyi hoolaatitine chu, adusklesne chu. ");
INSERT INTO bea_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kahchu Peter tontyetsi otsi yakehtehklalon, koole taneghaotatyehchi metihi kwa tsi: kwa yakasatah keotichne, na-itziluh khoon tsi. ");
INSERT INTO bea_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kahchu taneghaotatihchne metihi tyiyi atghe chu tsiwatilhne oohatakyet otsi ayi ihe atu oochu akiyuti Jesus kizuheli; ahwole atu oontsutli ohwiooh. ");
INSERT INTO bea_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ayi ihe natlone ketseli hakehe athlaghatati, ahwole atu hleoontye taghasoocha ootihe. ");
INSERT INTO bea_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ooh tahkine nighintyetl, kahchu atu tyeswe akiyehti, toowe ghati ihe, ");
INSERT INTO bea_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Tasitsukiih atyakehe, Chahtehaooslyeasi tidi tyetachatlihi kwa tyiyi atsila kila ihe, kahchu taiti dzinee aoocha ate achu nao-osiasi atu kila ihe. ");
INSERT INTO bea_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ahwole aghatane chu koosoochawotihi atu hleoontye. ");
INSERT INTO bea_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kwa o-ochi taneghaotatyechi metihi tyiyi ookaze nazut, Jesus tsi taoontya yehti toowe ehti ihe, Atu atyetunatla la? ye ihea ayi chahte anaghatya oontye? ");
INSERT INTO bea_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ahwole atu wotih, atula kehe chu atih. Kahchu o-ochi taneghaotayehchi metihi tyiyi taoontya yehti, kahchu toowe yehti, Nuni la ayi Christ, ma, Chue Moohchuootaya? ");
INSERT INTO bea_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kwa Jesus toowe ehti, Suni ayi: kahchu wahyesi tezoo Chue satah noohtichintye mehnatsutsutti, kahchu yahchityesha khoos yataihchi. ");
INSERT INTO bea_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kahchu taneghaotatyehchi metihi tyiyi tanatunne yaghinchil, kahchu toowe ehti, Ye ootaihchi a soochawochatihi khasootiti aoontye? ");
INSERT INTO bea_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ootahtsukiih mehe atachochihliti: naghani ta kootahtya? Kwa aghanetye kooye hlaghatati tsazuheli gha. ");
INSERT INTO bea_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kwa tahkine tyekookeghizek, kahchu yani aghataghighat, kahchu nakiteghul, kahchu toowe kiyehti ihe, atanataihchi woka atawonati: Kwa keotihchne nakiteghul taghila tyiyi ihe. ");
INSERT INTO bea_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kwa Peter yiyue nito kwa otyiyi ti ati, yuniya ehlaiti taneghaotatyehchi metihi tyiyi yawoai tsege: ");
INSERT INTO bea_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kwa ya-i tsi Peter naitziluh, yakaitghah, toowehchu ehti, Kahchu nuni chu mehtintyetliih Jesus Nazareth otsi tatyezutti. ");
INSERT INTO bea_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ahwole atu a kooti, toowe ehti ihe, Atu atawosti, kahchu atu atasuk atintya kehe. Kwa hadesha tyinta weswatih otsi; kwa tihchok tayidze otyesta. ");
INSERT INTO bea_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kwa keotihche tsege kahchu ya-ih, kahchu toowe tyiyehti ayine ieti nehyane, Taila ehlaiti ayine tsi. ");
INSERT INTO bea_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kwa kahchu atu koo ooli ehtilon. Kahchu kluhtai ayine ayite nazati, toowehchu ghati Peter, Nuni nooklya ehlaiti aghatane tsi, ayi ihe Galilaean nali, kahchu kooh nakasse atih. ");
INSERT INTO bea_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ahwole ketseliooh wotyihi zon ohtye ootatyehch, toowe akehe, Atu atesti tai teze mamawotahtyehchi. ");
INSERT INTO bea_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kwa onkye tihchok tayidze otyesta. Kwa Peter kyechetehti yaghi sa Jesus ayehtiii, Atu ka ootihoo tihchok tayidze onkye tghakooh oochit sootahoontyezi. Kwa hlilon ayiti indi ootinta, nachaihchahli. ");
INSERT INTO bea_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwa kwete hatlindo aooclia taneghaotatyehchi metihi tyiyino aglianctye ehlakehe tsiwohzon tsiwowatilh hoolya atitine chu adeskilesne chu hlito aonetyo gha tsiwoghatsihi ihe ayi chu, kwa Jesus tahkiyagheskluli, kahchu achukcdehtyi, kwa kikalmihtyj, Pilate. ");
INSERT INTO bea_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kahchu Pilato taoontya yehti, Nunila o-ochi koometihi tyiyi nalila Jewne gha? Kahchu ateyatetla toowohcliu yehti, Kooh tintya oontye. ");
INSERT INTO bea_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kahchu taneghaotatyehchi metihi tyiyine chahte akiyehti ooU nation ihe: ahwole atulakehe atyeta-i. ");
INSERT INTO bea_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kwa Pilate kahchu taoontya yehti, toowe ehtie, Atu lakehe atyetanatla la? nea taitya ooli ihe chahte anaghahti. ");
INSERT INTO bea_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ahwole Jesus zon atu la kehe aye ih kwaka; kwa Pilate kawoolih, ");
INSERT INTO bea_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ooh ayi kwelachayihi ehlaiti yezookeh ninkho kvyechehtyesne, ooli assine nioonunisit assine. ");
INSERT INTO bea_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ayiti hligi aliih Barabbas ooyeih, ihkahtah chaghcsklu ayi yekatichii kwa akiyila indiootaunne, kootoo tane zehai ihe indiootatunne ayiti. ");
INSERT INTO bea_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kwa natlone ohtye oghatyesta tyi yatsi niooghanunisit kooh hakiyulihi gha kooli zon hakooyilai ihe. ");
INSERT INTO bea_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ahwole Pilate ateyatetla, toowc ehti ihe, Kooh kootahti la naghachitulisitisi Jewne o-ochi koometihi tyiyi? ");
INSERT INTO bea_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Atawahtihi ihe taneghaotatyehchi metihi tyiyine yatagliintsutti ihe mihe incho-otsa-i. ");
INSERT INTO bea_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ahwole taneghaotatyehchi metihi tyiyine kichinagbayyh tanene, otaihai koochitootsittih Barabbas. ");
INSERT INTO bea_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kooh kahehu Pilate ateyatetla toowehchu yehti, Takootahtya oslihasi kooh yachi o-ochi koometihi tyiyi Jewnu woyi? ");
INSERT INTO bea_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kahchu toowe hakehe oghatesta, Klaniaitih ninihtyeh. ");
INSERT INTO bea_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kahchu Pilate toowe ehti, Ye tahtye ketselihoo atyuntye? Kahchu ootailichi o-ochi oghatesta, Klaniaitih ninihtyeh. ");
INSERT INTO bea_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kwa Pilate tane gha kasootati chatupisha gha, yakahninooh Barabbas assi, kahchu Jesus taghinchut, yakhataghitoos, klaniai nichuhtyelu, ");
INSERT INTO bea_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kwa simakanisne otsighatelityi tsiwatyehli kwa, Praetorium wotsatiti; kwa tyechi kiyehti ihlakehe atghe simakanisne. ");
INSERT INTO bea_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kwa natunne taghaghintyi aghapai tatulli ihe, kahchu kiyesklu o-ochi metihi tyiyi chahte hoos chok chine ihe, kwa ita tsi gha ghiooh, ");
INSERT INTO bea_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kahchu tyi yila ooghatthoon toowe, Yea mehsuchanetyi, o-ochi kookaoonazut Jewne. ");
INSERT INTO bea_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kahchu nakidehul yetsi chokhaiye chok ihe, kahchu kikighizek, kwa yatsitaghatsunne ootooghanehzil yatsi nachusghataklihl ");
INSERT INTO bea_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kahchu kiyachatyetl atghe tatulli nighadinchus, kwa yanatunne taghintyetl, kahchu ghooghatehtyi klaniai tih. ");
INSERT INTO bea_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kwa kitahnaghutsut ehlaiti Simon Cyrenian ali, ayi kwo noojai, tane natihti otsi Jiadesha, kootgha Alexander chu Rufus chu tahchiyatyilyu klaniai. ");
INSERT INTO bea_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kwa nakiyintyi Golgotha tsi, ayi tsati, Atsitsunne ooli te. ");
INSERT INTO bea_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kwa kiyayiooh tyewootoo chiche chok tu mathuchunihklito myrrh: ahwole atu niyadiooh. ");
INSERT INTO bea_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kwa klaniai nikiyinti tsi yanatunne atatghahaistla kikaootehunni ihe, ye anetye teze nitioolola. ");
INSERT INTO bea_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kahchu oolitah tghakooh mehooachanehoo awatazoo dzinee ooli klaniadi nikiyinti tsi. ");
INSERT INTO bea_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kwa achatyesklesi ayiti otsi chahteachatei takehnichanikuchiih ookeh. O-OCHI KOO METIHI TYIYI JEWNE. ");
INSERT INTO bea_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kahchu onkyetine chu klaniadi nighanihtye unoosine; ehlaiti noohtechintye, ooh hligi chu oosklaghazihtye. ");
INSERT INTO bea_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Achudesklessi tyiyi tikenikyih, kooh woti, Kahcliu metseline kah kachanehtyeh. ");
INSERT INTO bea_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ooh ayine kweghatilhne ayiti oontlochi kiye sootatyihch, tagliatsi ghaghado, toowehchu ghati ihe, Gha, nuni chahta wonatla tyctachatlihi kwa tyiyi, kahchu aoonatla taiti dzinee, ");
INSERT INTO bea_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aghatinta, kahchu yulichinootinta klauiai tsi. ");
INSERT INTO bea_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aghatane chu o-ochi taneghaotatyech metihi tyiyine ontlonchi akiyehti ihe toowe hlaghatati ihe adesklesne chu, Nayaghehta achune chu; atai koochati atu aghatatah. ");
INSERT INTO bea_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Oonka Christ o-ochi koometihi tyiyi Israel kwa hoote klaniai tsi noodoojai, wowoti khai kahchu a kootahti. Oo ayi yakah klaniadi yakah atii yataUhlon. ");
INSERT INTO bea_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kwa inchitakooh klodesha sa kehchi ehalai koonaooizutooh, hatleke aoochaii tike okehe kwa hHlon kalaketi klodesha sa kehchi ehaiai. ");
INSERT INTO bea_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kwa kalaketye sa kehchi ahalai klodesha, Jesus otyesta takaseneodi, toowe ehti ihe, Eloi, eloi, lama sabachthani? ayi tsati ihe Saghintai, Saghintai, yehoo gha sechanila aoontye. ");
INSERT INTO bea_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ooh tahkine ieti nehyane, ooghatitsuk tsi, toowe ghati, Nea, Ehas kawotih. ");
INSERT INTO bea_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kahchu ehlaiti otsidehta, kahchu tsifo yeatatih atihih tayatohman sootakan chiche tu ihe, kahchu nayiooh klokhayetgha, kahchu yayiooh tuwoto gha, toowe ehti ihe, Atu kinditaghaha; oonka oohwoti Elias nayaghintyi kha. ");
INSERT INTO bea_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kahchu Jesus otyesta ohtye ati, kahchu matsinde kwa yecheli. ");
INSERT INTO bea_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kwa ayi hlichatinkatii tyetachatlihi kwa otyiyi intyizon tghahkyehchi wotye cheghinchil yataihchi ctis yiyue otsi. ");
INSERT INTO bea_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kwa kootoo ayi simakunis metihi, ooghade nazutih. wa-i kooakehe otyesta, kahchu yatsinde yechelihooh, toowe ehti, tyewotye tune teze Nagha Tgha Chue ghilelon. ");
INSERT INTO bea_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ayiti oohwiliiih tsegene ehu tontyctsi otsi ookhaghanehtgha: atai chu iiti atiih Mary Magdalene, Mary chu ma James ooia etanoohlihi kahchu Joses, Salome chu; ");
INSERT INTO bea_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","(Aghatane chu, Galilee atichi, kikehtyeshaii, kahchu ooli kooyaalih ine;) achune chu natlone tsegoo yuhchi kooyehkyatehch ine Jerusalem tsi. ");
INSERT INTO bea_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kahkachi aoocha tsi, ayi ihe intyizon dzmee tsi watsehlu ayi dzinee Manejitti dzinee tsi ooh, ");
INSERT INTO bea_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph Arimathaea otsi tazehlu, tsatincha tsiwatilh, atune chu ootakah ali Nagha Tgha nataghe, yuhchidesha, kahchu tadzye natsutih seooh Pilate kahkwiya, kahchu Jesus zi ootakyet. ");
INSERT INTO bea_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kwa Pilate khawooli kwa tehtsalo ate: kwa simakanis metihi tyechi yehti, tauontya yehti tontyeto ghaite chu tehtsutiih. ");
INSERT INTO bea_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kwaatawatih tsi simakanis metihi yatati, tazi ghiooh Joseph. ");
INSERT INTO bea_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kwa ataghoola tsatache oochu takulle, kahcliu nooyaghintyi, kaliclm ayi tsatache ii ihe yehtoonehtich, kahchu niyanihtyi natine kwa oota tsyekas tayaghintyi, kahchu tsye otsiyehail toosklahchi natine kwa. ");
INSERT INTO bea_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kwa Mary Magdalene kahchu Mary Joses ma oohwa-ih nichanihtyinti. ");
INSERT INTO bea_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kwa Menejitti Dzinee kawohtzut tsi, Mary Magdalene, kahchu Mary James ma kahchu Salome, ataghaghila yu natunetgha tsehklutti, kwa yuhchighatatyel ate yu ihe kiyuhklukooh. ");
INSERT INTO bea_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kwri o-ochi hatse hatlindo ooli hatse dzinee, koohnioonizuiooh natine kwa otsighatestyetl sa niiya tsi. ");
INSERT INTO bea_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kwa toowe hlaghatati, Mea tsye yughaii aoontye natine kwa tustla otsi? ");
INSERT INTO bea_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kwa koo ookahanehtghachi, oogha-ih tsye achuhchi nichunihailo: o-ochi ghinchai ihe. ");
INSERT INTO bea_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kwa kwegliaghintyetlooh native kwa oota, kiya-ih ehlaiti uskye noohtichintye chisinchi sata, tasata natyesooh makestue takulooh: kwa oonighanintyetl. ");
INSERT INTO bea_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kwa toowe yehti, Atu oonighahtyel: Minkhanatgha Jesus Nazareth otsi tatyezutti, klaniai nichanihtyiii: tsitike ghinta-ih; atu chode ali; nea nighamhtyintiii. ");
INSERT INTO bea_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ahwole ootahtab, yaotatichne tatahtih Peter chu naghaghadesha Galilee tsi: ayiti wahiiissi, naghatatyakehe. ");
INSERT INTO bea_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kwa kwete khooghatastyetl, kahelm natine kwa otsi tsmtestyetl; yaghatilonlon ihe kahchu khaooghali ihe: kahchu atuline atula kehe akiyeliti; oonighanintyetlon ihe. ");
INSERT INTO bea_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kootoo Jesus niiyaii kwete hatse dzine tsiwatselhu, hatse yuhniya Mary Magdalene, ayi taiuchi atsmde metselihi yazi otsi hayateha-ii. ");
INSERT INTO bea_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kwa yatatilon ayine yehkyatehchiine, tsukye atu yaghita zahtgha kahchu ghutsakooh ");
INSERT INTO bea_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ooh ahatane, ooghatitsuk tsi ghata, kahchu ya-ilon atu a kooghati. ");
INSERT INTO bea_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ayi keh yuhniya achu akelie ouketye agha tane Ihe, ghataihlu zahtgha, achu tike tsi otsighataihlu. ");
INSERT INTO bea_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kwa kitati achune: kahchu ama kiyehti ayine. ");
INSERT INTO bea_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Atyechi yuhniya keneti ehlaiti matgha aline ghiskye eghehta ootye, kwa yachiotatyech majih oontooei kha kahchu yadzye natsutti kha atu a kiyuti ihe ayi yakehtghaii tsitike nesta. ");
INSERT INTO bea_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kwa toowe yehti, Otsitahtyel tike okehe matatahti obicn oociiu anetye tane. ");
INSERT INTO bea_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ayi a kootyeti kahchu tumakechaghinkliti nachawohtyezi; ahwole yaghi atu a kootyeti cliahta chuleesi. ");
INSERT INTO bea_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kahchu tidi yachanahai yakeh ootoohsitassi ayine a kootine; Sindizi ihe kehchi ghakitoolelassi atsinde metselihi; oogliatootyehchassi atsoodi koondi ihe; ");
INSERT INTO bea_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nootuze nighatoohtyelassi; oolita tughato ate chu azetse ahi, atu kootoohtihassi; kikatootiassi yatitihne, kwa oochu nakiyaooliteissi. ");
INSERT INTO bea_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kwa Naghaghatai sakyedesutooh, yatai otsi nichatihtyi, kahchu sata-ih Nagha Tgha noohtichintye. ");
INSERT INTO bea_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ahwole achughatestyetl, tike okehe tane chiwoghatihi ihe, Naghaghatai kahkeooghatihchoo, kahchu sa natsut oola kaootsooli chu intghaninkhi. Amen. ");
ALTER TABLE bea_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
