﻿USE sofia;
DROP TABLE IF EXISTS sofia.bdv_vpl;
CREATE TABLE bdv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bdv_vpl WRITE;
INSERT INTO bdv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଇ ଲେକା ଅଃଉଁଲି ଜିସୁ କ୍ରିସ୍ଟର୍‌ ହୁର୍ବାର୍‌ କୁଳ୍‌ବଃଉଁସ୍‌ମଃନାର୍‌ ନାଉଁମଃନ୍ । ସେ ଦାଉଦ୍‌ ବଃଉଁସାର୍‌ ରିଲା, ଆର୍‌ ସେ ଅବ୍ରାହାମାର୍‌ କୁଳ୍‌ବଃଉଁସାର୍‌ ଲେକାହଃତାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମାର୍‌ ହୟ୍‌ସି ଇସାକ୍‌; ଇସାକାର୍‌ ହୟ୍‌ସି ଜାକୁବ; ଜାକୁବର୍‌ ହୟ୍‌ସି ଜିଉଦା ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସିମଃନ୍‌କେ ଜଃଲମ୍‌ ଦିଲା, ");
INSERT INTO bdv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ପେରସ୍‌ ଆର୍‌ ଜେରହର୍‌ ଉବାସି ଜିଉଦା ଆର୍‌ ଆୟ୍‌ସି ତାମର୍‌; ପେରସାର୍‌ ହୟ୍‌ସି ହିସ୍ରଣ୍; ହିସ୍ରଣାର୍‌ ହୟ୍‌ସି ଆରାମ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଆରାମାର୍‌ ହୟ୍‌ସି ଅମିନାଦବ୍‌, ଅମିନାଦବାର୍‌ ହୟ୍‌ସି ନହସନ୍, ନହସନାର୍‌ ହୟ୍‌ସି ସଲମନ୍, ");
INSERT INTO bdv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲ୍‌ମନାର୍‌ ହୟ୍‌ସିର୍‌ ନାଉଁ ବୟାଜ, ବୟାଜାର୍‌ ଆୟ୍‌ସିର୍‌ ନାଉଁ ରାହାବ, ବୟାଜାର୍‌ ହୟ୍‌ସିର୍‌ ନାଉଁ ଅବେଦ, ଅବେଦର୍‌ ଆୟ୍‌ସିର୍‌ ନାଉଁ ରୁତ୍‌, ଅବେଦର୍‌ ହୟ୍‌ସି ଜିସି । ");
INSERT INTO bdv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଜିସିର୍‌ ହୟ୍‌ସି ଦାଉଦ୍‌ ରଃଜା, ଦାଉଦାର୍‌ ହୟ୍‌ସି ସଲ୍‌ମନ୍, ସଲ୍‌ମନାର୍‌ ଆୟ୍‌ସି ଆଗେ ଉରିୟର୍‌ ଡକୁର୍ସି ରିଲି, ");
INSERT INTO bdv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସଲ୍‌ମନାର୍‌ ହୟ୍‌ସି ରିହବିୟାମ୍‌, ରିହବିୟାମାର୍‌ ହୟ୍‌ସି ଅବିୟ, ");
INSERT INTO bdv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅବିୟର୍‌ ହୟ୍‌ସି ଆସା, ଆସାର୍‌ ହୟ୍‌ସି ଜିହସାପଟ୍‌, ଜିହସାପଟାର୍‌ ହୟ୍‌ସି ଜରାମ, ଜରାମାର୍‌ ହୟ୍‌ସି ଉଜିୟ, ");
INSERT INTO bdv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟର୍‌ ହୟ୍‌ସି ଜତାମ୍‌, ଜତାମାର୍‌ ହୟ୍‌ସି ଆହାସ୍‌, ଆହାସାର୍‌ ହୟ୍‌ସି ହିଜକିଅ, ");
INSERT INTO bdv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିଅ ମନସିକେ ଜଃଲମ୍‌ ଦିଲା ମନସି ଆମନ୍‌କେ ଜଃଲମ୍‌ ଦିଲା ଆମନ୍‌ ଜସିଅକେ ଜଃଲମ୍‌ ଦିଲା, ");
INSERT INTO bdv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଆମନାର୍‌ ହୟ୍‌ସି ଜସିଅ, ଜସିୟର୍‌ ହୟ୍‌ସି ଜିକନିୟ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସିମଃନ୍; ଇସ୍ରାଇଲ୍‌ମଃନ୍‌କେ ବାବିଲନ୍ ଦେସେ ବାନ୍ଦି ନେତାବଃଳ୍‌ ଜିକନିୟ ଜଃଲମ୍‌ ଅୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲନ୍ ଦେସେ ଇସ୍ରାଏଲ୍‌ମଃନ୍‌କେ ବାନ୍ଦି ନିଆ ଅୟ୍‌ଲା ହଃଚେ ଜିକନିୟର୍‌ ହୟ୍‌ସି ସଲ୍‌ଟିଏଲ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲା । ସଲ୍‌ଟିଏଲାର୍‌ ହୟ୍‌ସି ଜିରୁବାବେଲ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲାର୍‌ ହୟ୍‌ସି ଅବିହୁଦ୍‌, ଅବିହୁଦାର୍‌ ହୟ୍‌ସି ଏଲିୟାକିମ୍‌, ଏଲିଆକିମାର୍‌ ହୟ୍‌ସି ଆସର୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଆସର୍‌ ତାର୍‌ ହୟ୍‌ସି ସାଦକ୍‌, ସାଦକାର୍‌ ହୟ୍‌ସି ଆକିମ୍‌, ଆକିମାର୍‌ ହୟ୍‌ସି ଏଲିହୁଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ବାବିଲନ୍ ବଃନ୍‌ବାସ୍‌ ଅୟ୍‌ଲା ହଃଚେ ଜିସୁର୍‌ ଜଃଲମ୍‌ ହଃତେକ୍‌, ଇସଃବୁ ହୁର୍ବାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ବିସୟେ ଲେକା ଜାୟ୍‌ ଆଚେ, ଜେହାକିନ୍‌, ସଲ୍‌ଟେଲ୍‌, ଜେରୁବାବେଲ୍‌, ଏଲିହୁଦ୍‌, ଏଲିଆକିମ୍‌ ଆଜର୍‌, ଜାଦକ୍‌, ଆକିମ୍‌, ଏଲିଉଦ୍‌, ଏଲିଆଜର୍‌, ମତାନ୍‌, ଜାକୁବ, ଆର୍‌ ଜସେପ୍, ଜେକି ଜିସୁ ଜାକେକି ମଃସିଆ ବଃଲ୍‌ତି ତାର୍‌ ଆୟ୍‌ସି ମିୟମ୍‌କେ ବିବା ଅୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ମତାନାର୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌, ଜାବୁବର୍‌ ହୟ୍‌ସି ଜସେପ୍, ଇ ଜସେପ୍ ମରିୟମ୍‌କେ ବିବା ଅୟ୍‌ରିଲା, ଇ ମରିୟମାର୍‌ ହେଟେ ହୁଣି ଜିସୁ ଜଃଲମ୍‌ ଅୟ୍‌ଲା, ଲକ୍‌ମଃନ୍ ତାକ୍‌ କ୍ରିସ୍ଟ ଆର୍‌ ମଃସିଆ ବଃଲି କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇବାନ୍ୟା ଅବ୍ରାହାମାର୍‌ ତଃୟ୍‌ହୁଣି ଦାଉଦ୍‌ ହଃତେକ୍‌ ଚଃଉଦ କୁଳ୍‌ବଃଉଁସ୍‌, ଆର୍‌ ଦାଉଦାର୍‌ ତଃୟ୍‌ହୁଣି ବାବିଲନ୍ ବାନ୍ଦାୟ୍‌ଅୟ୍‌ ଜାତାହଃତେକ୍‌ ଚଃଉଦ କୁଳ୍‌ବଃଉଁସ୍‌, ଆରେକ୍‌ ବାବିଲନ୍ ବାନ୍ଦାୟ୍‌ଅୟ୍‌ ଗଃଲା ତଃୟ୍‌ହୁଣି କ୍ରିସ୍ଟର୍‌ ଜଃଲମ୍‌ ହଃତେକ୍‌ ଚଃଉଦ କୁଳ୍‌ବଃଉଁସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଜିସୁ କ୍ରିସ୍ଟର୍‌ ଜଃଲମ୍‌ ଇବାନ୍ୟା ଅୟ୍‌ଲି । ତାର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌କେ ଜସେପ୍ ସଃଙ୍ଗ୍ ବିବା ଅଃଉଁକେ ମାଗ୍‌ଣି ହଃଚେ, ସେମଃନ୍ ବିବା ନଃଉତା ଆଗ୍‌ତୁ ପବିତ୍ର ଆତ୍ମା ତଃୟ୍‌ହୁଣି ସେ ଆଙ୍ଗେ ଅୟ୍‌ଆଚେ ବଃଲି ଜାଣାହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ମରିୟମାର୍‌ ଡକ୍ରାସି ଜସେପ୍ ଦଃର୍ମି ଲକ୍‌ ରିଲା, ତଃବାର୍‌ଗିନେ ସେ ମରିୟମ୍‌କ୍ ସଃବୁଲକାର୍‌ ମୁଏଁ ଲାଜ୍‌ କଃରାଉଁକ୍‌ ମଃନ୍ ନଃକେଲା, ଆର୍‌ ସେ ଲୁକ୍‌ଣେ ତାକ୍‌ ଚାଡୁକ୍‌ ମଃନ୍‌କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ମଃତର୍‌ ସେ ଇରି ମଃନେ ହାଚ୍‌ଲା ହଃଚେ, ଦଃକା, ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ତାକ୍‌ ଚଃହ୍ନେ ଦଃକାୟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଦାଉଦ୍‌ ବଃଉଁସାର୍‌ ଜସେପ୍ ! ମରିୟମ୍‌କେ ବିବା ଅଃଉଁକେ ଡିର୍ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ଆଙ୍ଗେ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ସେ ଗଟେକ୍‌ ହିଲା ଜଃଲମ୍‌ କଃରେଦ୍‌, ଆର୍‌ ତୁମି ତାର୍‌ ନାଉଁ ଜିସୁ ସଃଙ୍ଗାଉଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ତାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ସେମଃନାର୍‌ ହାହେ ହୁଣି ମୁକ୍ଳାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ବାବ୍‌ବାଦିର୍‌ ତଃୟ୍‌ହୁଣି ଇସ୍ୱରାର୍‌ ଇ ଜୁୟ୍‌ କଃତା ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ଇ ସଃବୁ ଗଃଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ସେ ବାବ୍‌ବାଣି ଅଃଉଁଲି, “ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳି ଟକି ଆଙ୍ଗେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ସେ ଗଟେକ୍‌ ହିଲା ଜଃଲମ୍‌ କଃରେଦ୍‌, ଆର୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ନାଉଁ ଇମାନୁଏଲ୍‌ ବଃଲି ସଃଙ୍ଗାଉତି ।” ଇ ନାଉଁଆର୍‌ ଅଃର୍ତ୍‌, ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଇସ୍ୱର୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଇତାର୍‌ହଃଚେ ଜସେପ୍ ନିଦେହୁଣି ଉଟ୍‌ଲା ଆର୍‌ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ ତାକ୍‌ ଜୁୟ୍‌ରଃକମ୍‌ କୟ୍‌ରିଲା, ସେବାନ୍ୟା କଃଲା ଆର୍‌ ମରିୟମ୍‌କେ ବିବା ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମଃତର୍‌ ମରିୟମ୍‌ ତାର୍‌ ହିଲା ଜଃଲମ୍‌ ନଃକେର୍ତା ହଃତେକ୍‌ ଜସେପ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ସୟ୍‌ନଃକେଲା, ଆର୍‌ ସେ ହିଲା ଜଃଲମ୍‌ ଅୟ୍‌ଲାକ୍‌, ଜସେପ୍ ସେ ହିଲାର୍‌ ନାଉଁ ଜିସୁ ବଃଲି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରଦ୍‌ ରଃଜା ରାଇଜ୍‌ କଃର୍ତାବଃଳ୍‌ ଜିଉଦା ରାଜିର୍‌ ବେତ୍‌ଲିହିମ୍‌ ଗଃଳେ ଜିସୁ ଜଃଲମ୍‌ ଅୟ୍‌ଲା ହଃଚେ, ଦଃକା, ହୁର୍ବ ଦେସାର୍‌ କଃତିଗଟ୍‌ ହଃଣ୍ଡିତ୍‌ମଃନ୍ ଜିରୁସାଲମ୍‌ ଆୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ଆର୍‌ ହଃଚାର୍ଲାୟ୍‌, “ଜୁୟ୍‌ ହିଲା ଜିଉଦିମଃନାର୍‌ ରଃଜା ଅଃଉଁକେ ଜଃଲମ୍‌ ଅୟ୍‌ଆଚେ, ସେ କୁୟ୍‌ତି ଆଚେ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ହୁର୍ବ୍‌ ଦେସାର୍‌ ଅଃଗାସେ ତାର୍‌ ତାରା ଦଃକି ତାକ୍‌ ଜୁଆର୍‌ କଃରୁକେ ଆସିଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ଇରି ସୁଣି ହେରଦ୍‌ ରଃଜା ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଜିରୁସାଲମାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ କାବା ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ସେତାକ୍‌ ହେରଦ୍‌ ରଃଜା ଲକ୍‌ମଃନାର୍‌ ସଃବୁ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ହଃଣ୍ଡିତ୍‌ ମଃନ୍‌କେ କୁଦି ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମଃସିଆ ଜେ କି କ୍ରିସ୍ଟ, ସେ କୁୟ୍‌ତି ଜଃଲମ୍‌ ଅୟ୍‌ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ସେମଃନ୍ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ଜିଉଦା ରାଜିର୍‌ ବେତ୍‌ଲିହିମ୍‌,” କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ କଃତା ଗଟେକ୍‌ ବାବ୍‌ବାଦି ଲେକିଆଚେ- ");
INSERT INTO bdv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ଏଗା ଜିଉଦା ରାଜିର୍‌ ବେତ୍‌ଲିହିମ୍‌, ତୁୟ୍‌ ଜିଉଦା ରାଜିର୍‌ ବଃଡ୍ ଗଃଳ୍‌ମଃନାର୍‌ ବିତ୍ରେ କୁୟ୍‌ ଗୁଣେ ହେଁ ସାନ୍ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମାର୍‌ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଚାଲାଉଁକ୍‌, ଗଟେକ୍‌ ଚାଲାଉତା ଲକ୍‌ ତର୍‌ ତଃୟ୍‌ହୁଣି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଇରି ସୁଣି ହେରଦ୍‌ ହୁର୍ବ ଦେସାର୍‌ ସେ ହଃଣ୍ଡିତ୍‌ମଃନ୍‌କେ ଲୁକ୍‌ଣେ କୁଦି, ସେ ତାରା କଃଡେବଃଳ୍‌ ଡିସ୍‌ଲି, ଇରି ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ନିକ କଃରି ବୁଜ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ତାର୍‌ହଃଚେ ହେରଦ୍‌ ରଃଜା ସେମଃନ୍‌କେ ବେତ୍‌ଲିହିମ୍‌ ହଃଟାୟ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାୟ୍‌ ସେ ହିଲାକ୍‌ ନିକକଃରି ଲଳା ଆର୍‌ ତାକ୍‌ ବେଟ୍‌ ହାୟ୍‌ଲା ଦାହ୍ରେ ମକ୍‌ ଜାଣାଉଆ, ଜଃନ୍‌କଃରି ମୁଁୟ୍‌ ହେଁ ଜାୟ୍‌ ତାକ୍‌ ଜୁଆର୍‌ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ହଃଣ୍ଡିତ୍‌ମଃନ୍ ରଃଜାର୍‌ କଃତା ସୁଣି ସେତିହୁଣି ଗଃଳାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ହୁର୍ବ୍‌ ଦେସେ ଜୁୟ୍‌ ତାରା ଦଃକି ରିଲାୟ୍‌, ସେ ତାରା ସେମଃନାର୍‌ ଆଗେ ଆଗେ ଜାୟ୍‌, ଜୁୟ୍‌ ଗଃରେ ହିଲା ରିଲା ସେ ଗଃର୍‌ ଉହ୍ରେ ଜାୟ୍‌ ତେବଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ସେମଃନ୍ ସେ ତାରାକେ ଦଃକି ବଃଡେ ସଃର୍ଦା ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ଆର୍‌ ଗଃର୍‌ ବିତ୍ରେ ହୁରି ସେ ହିଲାକ୍‌ ତାର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ସଃଙ୍ଗ୍ ଦଃକ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକ୍‌ ହାଦେ ଡୁଳି ଜୁଆର୍‌ କଃଲାୟ୍‌, ଆରେକ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ହେଳି ଉଗାଳି ସନା, ବୁତେକ୍‌ ମଲାର୍‌ ଦୁହ୍‌ଣି ଆର୍‌ ବାସ୍ନା ଚିକଣ୍‌ ସେ ହିଲାକ୍‌ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଇତାର୍‌ହଃଚେ ହେରଦ୍‌ ରଃଜାର୍‌ ଲଃଗେ ବାଉଳି ନଃଜଃଉଁକେ ଇସ୍ୱର୍‌ ସେମଃନ୍‌କେ ଚଃହ୍ନେ ଆଡର୍‌ ଦିଲାକ୍‌, ସେମଃନ୍ ବିନ୍ ବାଟ ଅୟ୍‌ ନିଜାର୍‌ ଦେସେ ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ହଃଣ୍ଡିତ୍‌ମଃନ୍ ଗଃଲା ହଃଚେ, ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଜସେପ୍‌କେ ଚଃହ୍ନେ ଦଃକାୟ୍‌ଅୟ୍‌ କୟ୍‌ଲା, “ଉଟ୍‌, ହିଲାକ୍‌ ଆର୍‌ ତାର୍‌ ଆୟ୍‌ସିକ୍‌ ଦଃରି ମିସର୍‌ ଦେସେ ହଃଳାଉ, ଆରେକ୍‌ ଅଃମି ନଃକଉତା ହଃତେକ୍‌ ସେତି ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହେରଦ୍‌ ରଃଜା ହିଲାକ୍‌ ମଃର୍ନେ ମାରୁକ୍‌ ଲଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ସେତାକ୍‌ ଜସେପ୍ ଉଟି ହିଲାକ୍‌ ଆର୍‌ ମରିୟମ୍‌କ୍ ଦଃରି ସେ ରାତି ମିସର୍‌ ଦେସେ ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ଆର୍‌ ହେରଦ୍‌ ମଃର୍ତା ହଃତେକ୍‌ ସେତି ରିଲାୟ୍‌, ଜଃନ୍‌କଃରି ବାବ୍‌ବାଦି କୟ୍‌ରିଲା ମାପ୍ରୁର୍‌ ଇ କଃତା ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, “ମିସର୍‌ ଦେସେ ହୁଣି ମୁଁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ହଅକେ କୁଦି ଆଣ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ଇତାର୍‌ହଃଚେ ହୁର୍ବ୍‌ ଦେସେ ହୁଣି ଆସିରିଲା ହଃଣ୍ଡିତ୍‌ମଃନ୍ ତାକ୍‌ ଜଃଟିକଃରି ଗଃଳାୟ୍‌ ବଃଲି ହେରଦ୍‌ ଜାଣୁ ହାରି ବଃଡେ ରିସା ଅୟ୍‌ଲା, ଆର୍‌ ହଃଣ୍ଡିତ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜୁୟ୍‌ ବେଳାୟ୍‌ ତାରା ଉଦିରିଲି ସେରି ନିକକଃରି ବୁଜିରିଲା, ସେ ହଃର୍କାରେ ଦୁୟ୍‌ ବଃର୍ସ୍‌ ଆର୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ସାନ୍ ବଃର୍ସାର୍‌ ଜଃତେକ୍‌ ଅଃଣ୍ଡ୍ରା ହିଲାମଃନ୍ ବେତ୍‌ଲିହିମ୍‌ ଆର୍‌ ତାର୍‌ ଲଃଗାଲଃଗିର୍‌ ଗଃଳେ ରିଲାୟ୍‌, ସଃଇନ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌ ସେ ସଃବ୍‌କେ ମଃର୍ନେ ମାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ସଃଡେବଃଳ୍‌ ଜିରିମିୟ ବାବ୍‌ବାଦିର୍‌ ଇ କଃତା ହୁରୁଣ୍ ଅୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ଗଃଳେହୁଣି ଗଟେକ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ ସୁଣୁକ୍‌ ଅୟ୍‌ଲି, ସେରି ଏତାୟ୍‌ ଏତାୟ୍‌ କାନ୍ଦ୍‌ତାର୍‌ । ରାହେଲ୍‌ ତାର୍‌ ହିଲାମଃନାର୍‌ ଗିନେ କାନ୍ଦୁଲି; ହିଲାମଃନ୍ ଆର୍‌ ନାୟ୍‌ନି ବଃଲି, ସେ ତାର୍‌ ଦୁକ୍‌ ହାସ୍ରାଉତା କଃତା ନଃମାନ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରଦ୍‌ ମଃଲା ହଃଚେ, ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଜସେପ୍‌କେ ମିସରେ ଚଃହ୍ନେ ଦଃକାୟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ଉଟ୍‌, ହିଲାକ୍‌ ଆର୍‌ ତାର୍‌ ଆୟ୍‌ସିକ୍‌ ଦଃରି ଇସ୍ରାଏଲ୍‌ ଦେସେ ବାଉଳି ଜାହା । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ହିଲାକ୍‌ ଜିବନ୍‌ ନେଉଁକେ ମଃନ୍‌ କଃର୍ତି ରିଲାୟ୍‌, ସେମଃନ୍ ମଃଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ସେତାକ୍‌ ଜସେପ୍ ଉଟି ଜିସୁ ହିଲାକ୍‌ ଆର୍‌ ତାର୍‌ ଆୟ୍‌ସିକ୍‌ ଦଃରି ଇସ୍ରାଏଲ୍‌ ଦେସେ ବାଉଳି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମଃତର୍‌ ହେରଦ୍‌ ମଃଲା ହଃଚେ ତାର୍‌ ହୟ୍‌ସି ଆର୍କିଲାୟ ଜିଉଦା ରାଇଜାର୍‌ ରଃଜା ଅୟ୍‌ଆଚେ ବଃଲି ସୁଣି ଜସେପ୍ ସେତି ଜଃଉଁକେ ଡିର୍‌ଲା, ମଃତର୍‌ ଚଃହ୍ନେ ଆଡର୍‌ ହାୟ୍‌ ଗାଲିଲି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ମଃତର୍‌ ଇସ୍ୱର୍‌ ତାକ୍‌ ଚଃହ୍ନେ କୟ୍‌ଲାକ୍‌, ସେ ଗାଲିଲି ରାଇଜ୍‌ ହାକ୍‌ ହଃଳାୟ୍‌ଲା । ଆର୍‌ ନାଜରିତ୍‌ ନାଉଁଆର୍‌ ଗଃଳେ ଜାୟ୍‌ ବାସା କଃଲାୟ୍‌ । ଜଃନ୍‌କଃରି ବାବ୍‌ବାଦିମଃନାର୍‌ ଇ ବଃଚନ୍ ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, “ସେ ନାଜରିତିୟ ବଃଲି ଡାକେ ହୁଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ସଃଡେବଃଳ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ଜିଉଦା ଦେସାର୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଆସି ପର୍ଚାର୍‌ କଃରୁକେ ଆରୁମ୍‌ କଃଲା, ");
INSERT INTO bdv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ତୁମାର୍‌ ହାହ୍‌ଚାଡା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଚଃମେ ଅୟ୍‌ଲିନି ।” ");
INSERT INTO bdv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ଜିସାୟ୍‌ ବାବ୍‌ବାଦି ଜାର୍‌ କଃତା କୟ୍‌ରିଲା, ଇରି ସେ ମାନାୟ୍‌, “ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉତିରିଲା ଗଟ୍‌ ଲକାର୍‌ ଟଣ୍ଡ୍, ‘ମାପ୍ରୁର୍‌ ଗିନେ ବାଟ୍‌ ତିଆର୍‌ କଃରା; ତାର୍‌ ବାଟ୍‌ ସଃଳ୍‌କ୍‌ କଃରା ।’” ");
INSERT INTO bdv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଜହନ୍‌ ଉଟ୍‌ ରମେ ବୁଣ୍‌ଲା ବଃସ୍ତର୍‌ ହିନ୍ଦ୍‌ତି ରିଲା ଆର୍‌ ତାର୍‌ ଅଃଟାୟ୍‌ ଚାମାର୍‌ ଅଃଟାବାନ୍ଦୁଣ୍‌ ବାନ୍ଦ୍‌ତି ରିଲା । ଆରେକ୍‌ ସେ ଜିଟ୍‌କା ଆର୍‌ ବଃନାର୍‌ ମଃଉଁ କାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ସଃଡେବଃଳ୍‌ ଜିରୁସାଲମ୍‌ ଗଃଳାର୍‌ ଆର୍‌ ଜିଉଦା ରାଜିର୍‌, ଆରେକ୍‌ ଜର୍ଦନ୍‌ ଗାଡ୍ ଚଃମେ ରିଲା ସଃବୁ ଲକ୍‌ମଃନ୍ ଜହନ୍‌ ଲଃଗେ ଆସୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଆର୍‌ ସେମଃନ୍‌ ନିଜେ ନିଜେ କଃରିରିଲା ହାହ୍‌ ଆର୍‌ ଦସ୍‌ ସଃବୁ ମାନ୍‌ଲାୟ୍‌, ଆର୍‌ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ଜର୍ଦନ୍ ଗାଡେ ବାପ୍ତିସମ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ମଃତର୍‌ ପାରୁସି ଆର୍‌ ସାଦୁକିମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ବାପ୍ତିସମ୍‌ ନେଉଁକେ ଆସ୍ତାର୍‌ ଦଃକି ଜହନ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ନାଗ୍ ସାହ୍‌ ଆର୍‌ ତାର୍‌ ବଃଉଁସ୍‌ମଃନ୍, ଇସ୍ୱର୍‌ ତୁମିକେ ଜୁୟ୍‌ ଡଃଣ୍ଡ୍‌ ଦେଉଁକେ ଜଃଉଁଲା, ସେତିହୁଣି ବଚୁ ହାରାସ୍‌ ବଃଲି କେ ତୁମିକେ କୟ୍‌ଲା ? ");
INSERT INTO bdv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଜଦି ତୁମିମଃନ୍ ସଃତ୍‌କଃରି ହାହେ ହୁଣି ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆଚାସ୍‌, ତଃବେ ନିକ କାମ୍‌ କଃରି ଦଃକାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ମଃନେ ବାବା ନାୟ୍‌ ଜେ, ଅବ୍ରାହାମ୍‌ ତ ଅଃମାର୍‌ ଉବା ବଃଲି କୟ୍‌ଲେକ୍‌, ତୁମିମଃନ୍ ଡଃଣ୍ଡ୍‌ ତଃୟ୍‌ହୁଣି ମୁକ୍‌ଳୁ ହାରାସ୍‌ । ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଇସ୍ୱର୍‌ ଇ ଟେଳାମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ହେଁ ଅବ୍ରାହାମାର୍‌ ଗିନେ ହିଲାମଃନ୍‌ ଉବ୍‌ଜାଉଁ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଆର୍‌ ଅଃବେ ହେଁ ଗଃଚ୍‌ମଃନାର୍‌ ବୁନ୍ଦେ କୁରାଡି ଲାଗି ଆଚେ; ବଃଲେକ୍‌ ଜୁୟ୍‌ ଗଃଚେ ନିକ ହଃଳ୍‌ ନଃହେଳେ, ସେ ଗଃଚ୍‌କେ କାଟିକଃରି ଜୟେ ହଃକା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ମୁଁୟ୍‌ ସିନା ତୁମିକେ ହାହେ ହୁଣି ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆଚାସ୍‌ ବଃଲି ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁଲେ, ମଃତର୍‌ ମର୍‌ ହଃଚେ ଜେ ଆସୁଲା, ସେ ମର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବଃଡ୍‌, ତାର୍‌ ହାଦାର୍‌ ହାଣ୍ଡାୟ୍‌ ବଃଉଁକେ ମୁଁୟ୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌; ସେ ତୁମିମଃନ୍‌କେ ପବିତ୍ର ଆତ୍ମା ଆର୍‌ ଜୟେ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଅଃହ୍‌ଣାର୍‌ କଟାର୍‌ ହଃର୍ଚାଳ୍‌ କଃରୁକେ ଆର୍‌ ସଃବୁ ନିକ ଗଅଁକେ ରୁଣ୍ଡାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃଦ୍ୟାୟ୍‌ ସଃଙ୍ଗାଉଁକ୍‌ ତାର୍‌ ଆତେ କୁଲା ଆଚେ, ମଃତର୍‌ ସଃବୁ ହଃଲମଃନ୍‌କେ ନଃଲିବ୍‌ତା ଜୟେ ହଡାୟ୍‌ ହଃକାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ସଃଡେବଃଳ୍‌ ଜିସୁ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ନେଉଁକେ ଗାଲିଲି ହୁଣି ଜର୍ଦନ୍ ଗାଡେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମଃତର୍‌ ଜହନ୍‌ ମଃନାକଃରି ଜିସୁକେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ସିନା ତର୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ହାଉତା କଃତା, ଆର୍‌ ତୁୟ୍‌ ମର୍‌ ତଃୟ୍‌ ଆସି ଆଚ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଅଃବେ ମର୍‌ କଃତାୟ୍‌ ରାଜି ଅଃଉ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମି ଇବାନ୍ୟା ସଃବୁ ଦଃର୍ମ୍‌କାମ୍‌ କଃରି ଇସ୍ୱରାର୍‌ ଇଚା ହୁରୁଣ୍ କଃର୍ତାର୍‌ ଲଳାଆଚେ ।” ତଃବେ ଜହନ୍‌ ତାକ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁକେ ରାଜି ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ବାପ୍ତିସମ୍‌ ନଃୟ୍‌ ହାଣାୟ୍‌ ହୁଣି ବାରାୟ୍‌ଲା, ଆର୍‌ ସଃର୍ଗ୍‌ ଉଗାଳି ଅୟ୍‌ଲି, ଆରେକ୍‌ ସେ ଇସ୍ୱରାର୍‌ ଆତ୍ମାକ୍‌ ହାଣ୍ଡ୍‌କା ହର୍‌ ଅୟ୍‌ ତାର୍‌ ଉହ୍ରେ ଉତ୍ରି ଆସ୍ତାର୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଆର୍‌ ସଃଡେବଃଳ୍‌ ସଃର୍ଗେ ହୁଣି ଗଟେକ୍‌ କଃତା ସୁଣା ଅୟ୍‌ଲି, “ଏ ଅଃମାର୍‌ ଲାଡାର୍‌ ହଅ, ଆର୍‌ ତଃୟ୍‌ ଅଃମି ବଃଡେ ସଃନ୍‌ମତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଇତାର୍‌ହଃଚେ ସୟ୍‌ତାନ୍ ତଃୟ୍‌ହୁଣି ପରିକ୍ୟା କଃରାୟ୍‌ ଅଃଉଁକେ ପବିତ୍ର ଆତ୍ମା ଜିସୁକେ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ କାଡାୟ୍‌ ନିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଆରେକ୍‌ ଜିସୁ ଚାଳିସ୍‌ ଦିନ୍ ଆର୍‌ ଚାଳିସ୍‌ ରାତି ଉହାସ୍‌ ରିଲା ହଃଚେ, ତାକ୍‌ ବେସି ବୁକ୍‌ ଲାଗ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ସଃଡେବଃଳ୍‌ ସୟ୍‌ତାନ୍ ତାର୍‌ ଲଃଗେ ଆସି କୟ୍‌ଲି, “ତୁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତଃବେ ଇ ଟେଳାମଃନ୍‌କେ ରୁଟି ଅଃଉଁକେ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମଃତର୍‌ ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ଦଃର୍ମ୍‌ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ମାନାୟ୍‌ ଅଃବ୍‌କା ରୁଟି କାୟ୍‌ କଃରି ଜିବନ୍‌ ନଃରେୟ୍‌, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଟଣ୍ଡେ ହୁଣି ବାରାୟ୍‌ଲା ହଃତି ବଃଚନେ ବାଚେଦ୍‌, ଜୁୟ୍‌ରି ଜିବନ୍‌ ଗିନେ ଲଳା ।’” ");
INSERT INTO bdv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଇତାର୍‌ହଃଚେ ସୟ୍‌ତାନ୍ ଜିସୁକେ ପବିତ୍ର ଗଃଳ୍‌ ଜିରୁସାଲମେ ନଃୟ୍‌ ମନ୍ଦିର୍‌ ଟିହେ ଟିଆ କଃରାୟ୍‌ ତାକ୍‌ କୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ତୁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତଃବେ ଇତି ହୁଣି ତଃଳେ ଡଃଗାଉ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ- ‘ସେ ଅଃହ୍‌ଣାର୍‌ ଦୁତ୍‌ମଃନ୍‌କେ ତକେ ବଚାଉଁକେ ଆଡର୍‌ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଦ୍‌; ସେମଃନ୍ ତକ୍‌ ଆତେ ଟେକି ଦଃର୍ତି, ତଃବେ ତର୍‌ ହାଦ୍‌ ହେଁ ଟେଳାୟ୍‌ ନଃହାୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ସାସ୍ତରେ ଆରେକ୍‌ ଲେକା ଆଚେ, ‘ତୁୟ୍‌ ନିଜାର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ପରିକ୍ୟା କଃର୍‌ ନାୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ଆରେକ୍‌ ସୟ୍‌ତାନ୍ ଜିସୁକେ ଗଟେକ୍‌ ଉଚ୍ ହଃର୍ବାତ୍‌ ଟିହେ ନିଲି ଆର୍‌ ଜଃଗତାର୍‌ ସଃବୁ ରାଇଜ୍‌ ଆର୍‌ ସେ ରାଇଜାର୍‌ ସଃବୁ ଦଃନ୍‌ ଦଃକାୟ୍‌ କୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ତୁୟ୍‌ ଜଦି ମକ୍‌ ମୁଣ୍ଡିଆ ମାରି ଜୁଆର୍‌ କଃର୍ସି, ତଃବେ ଇ ସଃବୁ ମୁୟ୍‌ ତକ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ତଃବେ ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ଦୁର୍‌ ଅଃଉ, ସୟ୍‌ତାନ୍‌ ! ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ତୁୟ୍‌ ତର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ଜୁଆର୍‌ କଃର୍‌ ଆର୍‌ ତାର୍‌ ହଃକା ସେବା କଃର୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ତାର୍‌ହଃଚେ ସୟ୍‌ତାନ୍‌ ଜିସୁକେ ଚାଡି ହଃଳାୟ୍‌ଲି; ଆର୍‌ ଦୁତ୍‌ମଃନ୍ ଆସି ତାର୍‌ ସେବା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଜଃଡେବଃଳ୍‌ ଜହନ୍‌କେ ବାନ୍ଦି ଜଃଇଲେ ହୁରାୟ୍‌ଲାୟ୍‌ ବଃଲି ଜିସୁ ସୁଣ୍‌ଲା, ସେ ଗାଲିଲିକେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ଆର୍‌ ସେ ନାଜରିତ୍‌ ତଃୟ୍‌ ନଃରେୟ୍‌ ସୁବ୍‌ଲନ୍ ଆର୍‌ ନପ୍ତାଲି ହଲିୟେ ରିଲା ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡିର୍‌ କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଜାୟ୍‌ ବାସା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଜଃନ୍‌କଃରି ଜିସାୟ୍‌ ବାବ୍‌ବାଦି ଲେକ୍‌ଲା ଇ କଃତା ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ସୁବ୍‌ଲନ୍ ଦେସ୍‌ ଆର୍‌ ନପ୍ତାଲି ଦେସ୍‌, ସଃମ୍‌ନ୍ଦ୍ ଚଃମାର୍‌ ଆର୍‌ ଜର୍ଦନ୍ ଗାଡାର୍‌ ସେହାଟି ରିଲା ଅଜିଉଦିମଃନାର୍‌ ଗାଲିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଅଃନ୍ଦାରେ ବାସା କଃର୍ତା ଲକ୍‌ମଃନ୍ ଗଟେକ୍‌ ବଃଡ୍ ଉଜାଳ୍‌ ଦଃକ୍‌ତି, ଆର୍‌ ମଃର୍ନାର୍‌ ଚାୟ୍‌ ଦେସେ ରେତା ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ, ସେ ଉଜାଳ୍‌ ଉଦେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ସଃଡେବଃଳ୍‌ ହୁଣି ଜିସୁ ପର୍ଚାର୍‌ କଃରୁକେ ଆରୁମ୍‌ କଃରି କଃଉଁକେ ଦଃର୍ଲା, “ତୁମାର୍‌ ହାହ୍‌ ଚାଡା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଚଃମେ ଅୟ୍‌ଲିନି ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡିବାଟ୍‌ ବୁଲ୍‌ତିରିଲା ବଃଳ୍‌ ସିମନ୍, ଜାକେ ପିତର୍‌ ବଃଲି କଃଉତି, ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅ, ଇ ଦୁୟ୍‌ ବାୟ୍‌କ୍‌ ସଃମ୍‌ନ୍ଦେ ବୟ୍‌ଜାଲ୍‌ ହଃକାଉତାର୍‌ ଦଃକ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ମାଚୁଆ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ସଃଙ୍ଗ୍ ଆସା, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନଃର୍‌ମଃନ୍‌କେ ମାପ୍ରୁର୍‌ ଲଃଗେ ଆଣୁକେ ସିକାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ସେଦାହ୍ରେ ସେମଃନ୍ ତାକାର୍‌ ଜାଲ୍‌ ଚାଡ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଆରେକ୍‌ ଜିସୁ ସେତିହୁଣି କଃଣ୍ଡେକ୍‌ ଆଗେ ଜାୟ୍‌ ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବ ଆର୍‌ ଜହନ୍‌ ନାଉଁଆର୍‌ ଆରେକ୍‌ ଦୁୟ୍‌ ବାୟ୍‌କ୍‌ ତାକାର୍‌ ଉବାସି ଜେବଦି ସଃଙ୍ଗ୍ ଡଙ୍ଗାୟ୍‌ ଜାଲ୍‌ ହଃଜାଳ୍‌ତି ରିଲାର୍‌ ଦଃକି ସେମଃନ୍‌କେ କୁଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଆର୍‌ ସେମଃନ୍ ସେଦାହ୍ରେ ଡଙ୍ଗା ଆର୍‌ ତାକାର୍‌ ଉବାସିକ୍‌ ଚାଡି ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେମଃନ୍ ସିକ୍ୟା ଦଃୟ୍‌ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲା ଆର୍‌ ସଃବୁ ରଃକମାର୍‌ ରଗିକ୍‌ ଉଜ୍‌ କଃରିକଃରି ଗାଲିଲିର୍‌ ସଃବୁ ହାକ୍‌ ବୁଲୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ଆର୍‌ ଜିସୁର୍‌ କଃତା ସିରିଆ ଦେସାର୍‌ ସଃବୁ ହାକ୍‌ ଉର୍ଜି ଅୟ୍‌ଲି, ଆରେକ୍‌ ଲକ୍‌ମଃନ୍ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌କେ, କୁନ୍ଦେଲ୍‌ ରଗି, ଏକ୍‌ଅଃଙ୍ଗି ରଗି, ଇବାନ୍ୟା ଗାଦେକ୍‌ ରଃକମାର୍‌ ରଗେ ମଃଳୁ ହଃଳିରିଲା ଲକ୍‌ ଆର୍‌ ଦୁକାୟ୍‌ ହଃଳିରିଲା ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ଜିସୁର୍‌ ଲଃଗେ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଆରେକ୍‌ ଗାଲିଲିର୍‌, ଦେକାପଲି ବଃସ୍ତି, ଜିରୁସାଲମ୍‌, ଜିଉଦା ରାଇଜ୍‌ ଆର୍‌ ଜର୍ଦନ୍ ଗାଡ୍ ସେହାଟିର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ଗଟେକ୍‌ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଗଃଲା, ଆର୍‌ ସେତି ବଃସ୍‌ଲା; ତାର୍‌ହଃଚେ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ତାର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ଆତ୍ମା ଉହ୍ରେ ବଃର୍ସା କଃର୍ତି, ସେମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ସେମଃନ୍‌କାର ! ");
INSERT INTO bdv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","କାନ୍ଦ୍‌ତା ଲକ୍‌ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; ସେମଃନ୍ ଦୁକ୍‌ ବଃଳ୍‌ ସାସ୍‌ ହାଉଁ ହାର୍ତି ! ");
INSERT INTO bdv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ମାୟଃନ୍‌କାରି ଲକ୍‌ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ବୁୟ୍‌ଁ ଦେଉଁକେ ସଃୟ୍‌ତ୍‌ କଃରି ଆଚେ, ସେରି ସେମଃନ୍ ହାଉତି ! ");
INSERT INTO bdv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଇସ୍ୱରାର୍‌ ଇଚା ଦଃର୍ମ୍‌କାମ୍‌ କଃରୁକେ ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ମଃନ୍, ସେମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ସେମଃନାର୍‌ ମଃନ୍ ସଃର୍ଦା କଃରାୟ୍‌ଦ୍‌ ! ");
INSERT INTO bdv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ବିନ୍ ଲକ୍‌କେ ଦଃୟା ଦଃକାଉତା ଲକ୍‌ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଦଃୟା ହାଉତି ! ");
INSERT INTO bdv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ମଃନ୍‌ବିତ୍ରେ ଜେ ନିର୍ମୁଳ୍‌ ସେମଃନ୍ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଇସ୍ୱର୍‌କେ ଦଃକ୍‌ତି ! ");
INSERT INTO bdv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ସୁସ୍ତାକାରି ଲକ୍‌ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ବଃଲି ଡାକେ ହୁଟ୍‌ତି ! ");
INSERT INTO bdv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଇସ୍ୱରାର୍‌ ଇଚାୟ୍‌ ଦଃର୍ମ୍‌କାମ୍‌ କଃରି ତାଡ୍‌ନା ହାଉତା ଲକ୍‌ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ସେମଃନାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ଲକ୍‌ମଃନ୍ ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍‌କେ ମର୍‌ ଗିନେ ଲିନ୍ଦା ଆର୍‌ ତାଡ୍‌ନା କଃର୍ତି, ଆରେକ୍‌ ମିଚେ ତୁମାର୍‌ ବିରଦେ ସଃବୁ ରଃକମାର୍‌ କଃରାବ୍‌ କଃତା କଃଉତି, ତଃବେ ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ତୁମିମଃନ୍ ଅଃନାୟ୍‌ ସଃର୍ଦା କଃରା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ହୁରେ ତୁମାର୍‌ ଗିନେ ଗାଦେକ୍‌ ପୁରିସ୍କାର୍‌ ଆଚେ; ସେବାନ୍ୟା ତ ତୁମାର୍‌ ହୁର୍ବାର୍‌ ବାବ୍‌ବାଦିମଃନ୍‌କେ ତାଡ୍‌ନା କଃରି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ତୁମିମଃନ୍ ହୁର୍ତିବିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ନଣ୍ ହର୍‌, ମଃତର୍‌ ନଣ୍ ଜଦି ତାର୍‌ ସୁଆଦ୍‌ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ସେରି କଃନ୍‌କଃରି ହେଁ ନଣାର୍‌ ଗୁଣ୍‌ କଃରି ହାରି ନୟ୍‌ । ସେରି ଆର୍‌ କୁୟ୍‌ କାମେ ହେଁ ନଃଲାଗେ, ସେରି ହଃଦାୟ୍‌ ହଃବ୍ଳାୟ୍‌କଃରି ଲକ୍‌ମଃନ୍ ତାକ୍‌ ମାଡ୍‌ତା ଜୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ତୁମିମଃନ୍ ଜଃଗତାର୍‌ ଉଜାଳ୍‌ ହର୍‌ । ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ତିଆର୍‌ ଅୟ୍‌ଲା ଗଃଳ୍‌ ଲୁକି ରେଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଆର୍‌ ଲକ୍‌ମଃନ୍ କୁପି ଲାଗାୟ୍‌ ମାଣ୍ ତଃଳେ ନଃସେଙ୍ଗାଉତି, ମଃତର୍‌ ଦିହ୍‌ରୁକା ଉହ୍ରେ ସଃଙ୍ଗାଉତି, ସେତାକ୍‌ ସେରି ଗଃରେ ରିଲା ସଃବୁ ଲକ୍‌କେ ଉଜାଳ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ସେନ୍‌କାର୍‌ ତୁମିମଃନାର୍‌ ଉଜାଳ୍‌ ଲକ୍‌ମଃନାର୍‌ ଆଗେ ଡିସ, ଜଃନ୍‌କଃରି ସେମଃନ୍ ତୁମିମଃନାର୍‌ ସଃତ୍‌କାମ୍‌ ଦଃକି ତୁମିମଃନାର୍‌ ସଃର୍ଗ୍‌ ଉହ୍ରେ ରିଲା ଉବାଦିର୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ମୁଁୟ୍‌ ଜେ ମସାର୍‌ ବିଦି କି ବାବ୍‌ବାଦିମଃନାର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ନଃସ୍ଟ୍‌ କଃରୁକେ ଆସିଆଚି ବଃଲି ବାବା ନାୟ୍‌; ନଃସ୍ଟ୍‌ କଃରୁକେ ନଃଆସି ମଃତର୍‌ ହୁରୁଣ୍ କଃରୁକେ ଆସିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସଃର୍ଗ୍‌ ଆର୍‌ ହୁର୍ତିବି ରେତା ହଃତେକ୍‌, ମସାର୍‌ ବିଦିର୍‌ ଗଟେକ୍‌ ମଃତ୍ରା କି ଗଟେକ୍‌ ଟପା ନଃସ୍ଟ୍‌ ନୟ୍‌, ସଃବୁ କଃତା ହୁର୍ନ୍‌ ନଃଉତା ହଃତେକ୍‌ ଇରି ନଃଗେଟେ । ");
INSERT INTO bdv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଇ ସଃବୁ ସାନ୍ ସାନ୍ ଆଦେସ୍‌ମଃନାର୍‌ ବିତ୍ରେ କୁୟ୍‌ ଗଟେକ୍‌ ଆଦେସ୍‌ ନଃମାନେ ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ ହେଁ ସେବାନ୍ୟା ସିକ୍ୟା ଦଃୟଃଦ୍‌, ସେ ସଃର୍ଗ୍‌ ରାଇଜେ ସାନ୍ ବଃଲାୟ୍‌ ଅୟ୍‌ଦ୍‌; ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ସେ ସଃବୁ ମାନେଦ୍‌ ଆର୍‌ ସିକ୍ୟା ଦଃୟଃଦ୍‌, ସେ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ତଃୟ୍‌ଁ ବଃଡ୍ ବଃଲାୟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜଃବେ ହଃତେକ୍‌ ତୁମିମଃନାର୍‌ କାମ୍‌ ଇସ୍ୱରାର୍‌ ଇଚା ହଃର୍କାରେ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁ ଆର୍‌ ପାରୁସି ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବିସ୍ୱାସ୍‌ ଅୟ୍‌ନଃରିଲେକ୍‌, ତଃବେ ତୁମିମଃନ୍ ସଃର୍ଗ୍‌ ରାଇଜେ ଜଃଉଁ ନଃହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ତୁମିମଃନ୍ ସୁଣି ଆଚାସ୍‌ ଜେ, ହୁର୍ବ୍‌ କାଳେ ଲକ୍‌ମଃନ୍‌କେ କଃଉଆ ଅୟ୍‌ଆଚେ, ‘ନଃର୍‌ ମାରା ନାୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ନଃର୍‌ ମାରେଦ୍‌, ସେ ବିଚାର୍‌ କଃର୍ତା ଟାଣେ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ ଉହ୍ରେ ରିସା ଅୟ୍‌ଦ୍‌, ସେ ବିଚାର୍‌ କଃର୍ତା ଟାଣେ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌ । ଆରେକ୍‌ ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌କ୍‌ ନିର୍ବୁଦିଆ ବଃଲି କୟ୍‌ଦ୍‌, ସେ ବେରାଣେ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌; ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ଲଳାକ୍‌ ନୟ୍‌ଲାର୍‌ ବଃଲି କୟ୍‌ଦ୍‌, ସେ ଜୟ୍‌ ଲାଗ୍‌ତା ନଃର୍କେ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଇତାକ୍‌, ଇସ୍ୱରାର୍‌ ଗିନେ ବେଦି ଲଃଗେ ତୁମି ତୁମାର୍‌ ଦାନ୍‌ ଆଣ୍‌ତି ରିଲା ବଃଳ୍‌ ତୁମାର୍‌ ବିରଦେ ତୁମାର୍‌ ବାୟ୍‌ଦିର୍‌ କାୟ୍‌ କଃତା ଆଚେ ବଃଲି ସେତି ତୁମିକେ ଏତୁହଃଳେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ତଃବେ ସେତିର୍‌ ବେଦି ତଃଳେ ତୁମାର୍‌ ଦାନ୍‌ ସଃଙ୍ଗାୟ୍‌ ବାଉଳି ଜାହା, ଆଗ୍‌ତୁ ନିଜାର୍‌ ବାୟ୍‌ ସଃଙ୍ଗ୍ ମିସା, ଆର୍‌ ତାର୍‌ହଃଚେ ତୁମାର୍‌ ଦାନ୍‌ ବେଦି ଉହ୍ରେ ଆଣି ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ତୁମାର୍‌ ବିରଦି ସଃଙ୍ଗ୍ ବାଟେ ରିଲାବଃଳ୍‌ ବେଗି ତାର୍‌ ସଃଙ୍ଗ୍ ମିସାବିଳା ବାବ୍‌ ଦଃକାଉଆ, ନୟ୍‌ଲେକ୍‌ ବିରଦି ତୁମିକେ ବିଚାର୍‌ କଃର୍ତା ଲକାର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟଃଦ୍‌, ଆରେକ୍‌ ବିଚାର୍‌କଃରୁ ତୁମିକେ ଜାଗୁଆଳି ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌, ଆର୍‌ ତୁମି ଜଃଇଲେ ହୁରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମି ସଃରା ସଃରି ଗଟେକ୍‌ କାସୁ ହେଁ ନଃସୁଜ୍‌ତା ହଃତେକ୍‌ ସେ ଜଃଗାୟ୍‌ ହୁଣି କଃନ୍‌କଃରି ହେଁ ମୁକ୍‌ଳି ଆସୁ ନଃହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ତୁମିମଃନ୍ ସୁଣି ଆଚାସ୍‌, ଲେକାଆଚେ, ‘ଦାରିକାମ୍‌ କଃରା ନାୟ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ଲକ୍‌ ଜୁୟ୍‌ ମାୟ୍‌ଜିକେ କଃରାବ୍‌ ଆକାୟ୍‌ ଦଃକେଦ୍‌, ସେ ତାର୍‌ ସଃଙ୍ଗ୍ ମଃନ୍‌ ବିତ୍ରେ ଦାରିକାମ୍‌ କଃରି ସଃର୍ଲାନି । ");
INSERT INTO bdv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଆର୍‌ ତୁମିକେ ଜଃଡେବଃଳ୍‌ କାତା ଆକି ହାହ୍‌ କଃରାୟ୍‌ଦ୍‌, ତଃବେ ସେରି କାଡି ହଃବ୍ଳାଉଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ସଃବୁ ଗଃଗାଳ୍‌ ନଃର୍କେ ନଃସ୍ଟ୍‌ ଅଃଉତା ବାଟା ଗଟେକ୍‌ ଆକି ନଃସ୍ଟ୍‌ ଅଃଉତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ । ");
INSERT INTO bdv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଆରେକ୍‌ ତୁମିକେ ଜଃଡେବଃଳ୍‌ କାତା ଆତ୍‌ ହାହ୍‌ କାମ୍‌ କଃରାୟ୍‌ଦ୍‌, ତଃବେ ସେରି କାଟି ହଃବ୍ଳାଉଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ସଃବୁ ଗଃଗାଳ୍‌ ନଃର୍କେ ହଃଳ୍‌ତା ବାଟା ଗଟେକ୍‌ ଆତ୍‌ ନଃସ୍ଟ୍‌ ଅଃଉତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ଆରେକ୍‌ ଲେକା ଆଚେ, ‘ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜିକେ ଚାଡେଦ୍‌, ସେ ତାକ୍‌ ଚାଡ୍‌ହଃତାର୍‌ ଲେକି ଦେଉଅ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜିକେ ଦାରିକାମାର୍‌ ଦଃସ୍‌ ଚାଡି ବିନ୍ କାମାର୍‌ ଗିନେ ଚାଡେଦ୍‌, ତଃବେ ସେ ତାକ୍‌ ଦାରିଆଣି କଃରାୟ୍‌ଦ୍‌, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ସେ ଚାଡ୍‌ଲା ମାୟ୍‌ଜିକେ ସଃଙ୍ଗାୟ୍‌ଦ୍‌, ସେ ହେଁ ଦାରିକାମ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ଆରେକ୍‌ ତୁମିମଃନ୍ ସୁଣି ଆଚାସ୍‌ ଜେ, ହୁର୍ବ୍‌ କାଳେ ଲକ୍‌ମଃନ୍‌କେ କଃଉଆ ଜାୟ୍‌ରିଲି, ‘ତୁମି ମିଚ୍ ହଃର୍ମାଣ୍‌ କଃରାନାୟ୍‌, ମଃତର୍‌ ଅଃହ୍‌ଣାର୍‌ ହଃର୍ମାଣ୍‌ ସଃବୁ ମାପ୍ରୁର୍‌ ଗିନେ ହୁରୁଣ୍ କଃରା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସଃୟ୍‌ତ୍‌ କଃର୍ତାବଃଳ୍‌ କଃବେ ହେଁ ହଃର୍ମାଣ୍‌ କଃରା ନାୟ୍‌; ସଃର୍ଗାର୍‌ ହଃର୍ମାଣ୍‌ କଃରା ନାୟ୍‌, ବଃଲେକ୍‌ ସେରି ଇସ୍ୱରାର୍‌ ସିଙ୍ଗାସଣ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","କି ହୁର୍ତିବିର୍‌ ହଃର୍ମାଣ୍‌ କଃରା ନାୟ୍‌, ବଃଲେକ୍‌ ସେରି ଇସ୍ୱରାର୍‌ ହାଦ୍‌ ସଃଙ୍ଗାଉତା ଟାଣ୍; ଜିରୁସାଲମାର୍‌ ହଃର୍ମାଣ୍‌ କଃରା ନାୟ୍‌, ବଃଲେକ୍‌ ସେରି ମଃହାରଃଜାର୍‌ ଗଃଳ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ଆରେକ୍‌ ଅଃହ୍‌ଣାର୍‌ ମୁଣ୍ଡାର୍‌ ହଃର୍ମାଣ୍‌ କଃରା ନାୟ୍‌, ବଃଲେକ୍‌ ସେତିର୍‌ ଗଟେକ୍‌ ବାଳ୍‌ ହେଁ ଦବ୍‌ କି କଃଳ୍ୟା କଃରୁକେ ତୁମାର୍‌ ସଃକ୍ତି ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ତୁମିମଃନ୍‌ ‘ହେଁ’ ଅଲେ ‘ହେଁ’ ବଃଲା, ‘ନାୟ୍‌’ ଅଲେ ‘ନାୟ୍‌’ ବଃଲା, ଇତିହୁଣି ଜାୟ୍‌ରି ଅଃଦିକ୍‌, ସେରି ଦୁସ୍ଟ୍‌ ଆତ୍ମା ତଃୟ୍‌ହୁଣି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ତୁମିମଃନ୍ ସୁଣି ଆଚାସ୍‌, ଲେକା ଆଚେ, ‘ଆକିର୍‌ ବାଦୁଲେ ଆକି ଆର୍‌ ଦାତାର୍‌ ବାଦୁଲେ ଦାତ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, କେ ତୁମାର୍‌ ଦୁସ୍ଟ୍‌ କଃଲେକ୍‌ ତାର୍‌ ବାଦ୍‌ଲା ନିଆନାଁୟ୍‌, ମଃତର୍‌ ଜେ ତୁମାର୍‌ କାତା ଗାଲେ ଚାହୁଳ୍‌ ମାରେଦ୍‌, ତାକ୍‌ ଡେବ୍ରି ଗାଲ୍‌ ହେଁ ଦଃକାୟ୍‌ ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଆର୍‌ କେ ଜଦି ତୁମାର୍‌ ଆଙ୍ଗି ନେଉଁକେ ମଃନ୍‌କଃରି ବିଚାର୍‌ କଃର୍ତା ଟାଣେ ନଃୟ୍‌ଦ୍‌, ତଃବେ ତାକ୍‌ ତୁମାର୍‌ ହଃଚ୍ୟା ହେଁ ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଆର୍‌ ଜଦି ଗଟେକ୍‌ ସଃଇନ୍ ତାର୍‌ ବଜ୍‌ ବଳାୟ୍‌ କସେକ୍‌ ଜୁଉ ବଃଲି ବଃଳ୍‌ମାଡ୍ କଃଲେକ୍‌, ତୁମି ତାର୍‌ ସଃଙ୍ଗ୍ ଦୁୟ୍‌ କସ୍‌ ଜାହା । ");
INSERT INTO bdv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","କେ ଜଦି ତୁମିକେ କାୟ୍‌ରି ମାଗେଦ୍‌, ତାକ୍‌ ଦିଆସ୍‌; ଆର୍‌ କେ ଜଦି ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି ରିଣ୍ ନେଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ତାକ୍‌ ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ତୁମିମଃନ୍ ସୁଣି ଆଚାସ୍‌, ଲେକା ଆଚେ, ‘ତୁମାର୍‌ ନିଜାର୍‌ ଲକ୍‌କେ ଲାଡ୍‌ କଃରା ଆର୍‌ ତୁମାର୍‌ ସଃତ୍ରୁକେ ଲାଡ୍‌ କଃରା ନାୟ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ତୁମିମଃନାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ ଲାଡ୍‌ କଃରା, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ କଃସ୍ଟ୍‌ ଦେତି, ସେମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃରା, ");
INSERT INTO bdv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦିର୍‌ ହୟ୍‌ସି ଅଃଉଆସ୍‌; ସେ ତ ମିଚ୍ ଆର୍‌ ସଃତ୍‌ ଲକାର୍‌ ଉହ୍ରେ ଅଃହ୍‌ଣାର୍‌ ବେଳ୍‌ ଉଦାଉଁଲା, ଆରେକ୍‌ ଦଃର୍ମି ଆର୍‌ ଅଃଦଃର୍ମି ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ବଃର୍ସା ମାରାଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ଲାଡ୍‌ କଃର୍ତି, ସେମଃନ୍‌କେ ହଃକା ଲାଡ୍‌ କଃଲେକ୍‌ ତୁମାର୍‌ କାୟ୍‌ ପୁରିସ୍କାର୍‌ ? ରିବ୍‌ନିମଃନ୍ ହେଁ ତ ସେବାନ୍ୟା କଃରୁଲାୟ୍‌ ! ");
INSERT INTO bdv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଆର୍‌ ତୁମିମଃନ୍ ଜଦି ନିଜାର୍‌ ନିଜାର୍‌ ବାୟ୍‌କ୍‌ ହଃକା ଜୁଆର୍‌ କଃରାସ୍‌, ତଃବେ ତୁମି ଅଃଦିକ୍‌ କାୟ୍‌ରି କଃରୁଲାସ୍‌ ? ଅଜିଉଦିମଃନ୍‌ ହେଁ ତ ସେବାନ୍ୟା କଃରୁଲାୟ୍‌ ! ");
INSERT INTO bdv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ବଃଲେକ୍‌, ତୁମିମଃନାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଜଃନ୍‌କାର୍‌ ସିଦ୍‌, ତୁମିମଃନ୍ ହେଁ ସେବାନ୍ୟା ସିଦ୍‌ ଅଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ଲକ୍‌ମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅଃଉଁକେ ଇଚା କଃରି ସେମଃନାର୍‌ ମୁଏଁ ଇସ୍ୱରାର୍‌ ଇଚା ବିରଦେ କଃରାନାୟ୍‌; ଇତାକ୍‌ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ସେବାନ୍ୟା କଃଲେକ୍‌ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ତଃୟ୍‌ହୁଣି ତୁମି କାୟ୍‌ ହେଁ ପୁରିସ୍କାର୍‌ ହାଉଁ ନଃହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ଇତାକ୍‌ ଦାନ୍‌ କଃର୍ତାବଃଳ୍‌ ହେଟ୍‌କପଟ୍ୟାମଃନାର୍‌ ହର୍‌ ଅଃହ୍‌ଣାର୍‌ ମୁଏଁ ତୁରି ହୁକା ନାୟ୍‌; ସେମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ହାଉଁକ୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଆର୍‌ ସାୟ୍‌ ମଃଜାୟ୍‌ ସେବାନ୍ୟା କଃର୍ତି । ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣା କଃଲା କାମାର୍‌ ପୁରିସ୍କାର୍‌ ହାୟ୍‌ଲାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମଃତର୍‌ ତୁମିମଃନ୍ ଦାନ୍‌ କଃର୍ତାବଃଳ୍‌ ତୁମାର୍‌ କାତା ଆତ୍‌ କାୟ୍‌ କଃରୁଲି, ସେରି ଡେବ୍ରି ଆତ୍‌ ନଃଜାଣ, ");
INSERT INTO bdv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ଜଃନ୍‌କଃରି ତୁମାର୍‌ ଇ ଦାନ୍‌ ଲୁକ୍‌ଣେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ତୁମାର୍‌ ଉବାଦି ଜେ ଲୁକ୍‌ଣେ ଦଃକେଦ୍‌, ସେ ତୁମିକେ ହଃଳ୍‌ ଦଃୟଃଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ପାର୍ତନା କଃର୍ତାବଃଳ୍‌ ହେଟ୍‌କପଟ୍ୟାମଃନାର୍‌ ହର୍‌ ଅଃଉଆ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଲକ୍‌କେ ଦଃକାୟ୍‌ ଅଃଉଁକେ ପାର୍ତ୍‌ନା ଗଃରେ ଆର୍‌ ସାୟ୍‌ ମୁଣ୍ଡେମଃନ୍ ଟିଆଅୟ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ମଃନ୍ କଃର୍ତି; ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣା କଃଲା କାମାର୍‌ ସଃର୍ନେ ପୁରିସ୍କାର୍‌ ହାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ମଃତର୍‌ ତୁମି ପାର୍ତ୍‌ନା କଃର୍ତାବଃଳ୍‌ ତୁମାର୍‌ ଗଃର୍‌ ବିତ୍ରେ ଜାହା ଆରେକ୍‌ ଦୁଆର୍‌ ଡାହିକଃରି ଲୁକ୍‌ଣେ ତୁମାର୍‌ ଉବାଦି ଚଃମେ ପାର୍ତ୍‌ନା କଃରା; ଆର୍‌ ତୁମାର୍‌ ସଃବୁ ଦଃକ୍‌ତା ସଃର୍ଗାର୍‌ ଉବାଦି, ଜେ କି ନଃଡିସ୍ତେ ଆଚେ, ସେ ସେରି ଦଃକି ତୁମିକେ ପୁରିସ୍କାର୍‌ ଦଃୟଃଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ଆରେକ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତାବଃଳ୍‌ ଇସ୍ୱର୍‌କେ ଅଜିଉଦି ଲକାର୍‌ ହର୍‌ ଚୁଚାହଲ୍ୟା କଃତାମଃନ୍‌ କୟ୍‌ ତର୍‌କେ ତର୍‌ ପାର୍ତ୍‌ନା କଃରାନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ବୁତେକ୍‌ କଃତା କୟ୍‌ ପାର୍ତ୍‌ନା କଃଲେକ୍‌ ଇସ୍ୱର୍‌ ସେମଃନାର୍‌ କଃତା ସୁଣେଦ୍‌ ବଃଲି ମଃନେ ବାବ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଇତାର୍‌ ଗିନେ ସେମଃନାର୍‌ ହର୍‌ ଅଃଉଆ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ କାୟ୍‌ରି ଲଳା, ସେରି ମାଗ୍‌ତା ଆଗ୍‌ତୁ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଇସ୍ୱର୍‌ ସେରି ଜାଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ତଃବାର୍‌ଗିନେ ତୁମିମଃନ୍ ଇବାନ୍ୟା ବଃଲି ପାର୍ତ୍‌ନା କଃରା- ‘ଏ ଅଃମାର୍‌ ସଃର୍ଗାର୍‌ ଉବା, ତର୍‌ ନାଉଁ ପବିତ୍ର ବଃଲି ମାନ୍‌ତି ଅଃଉଅ; ");
INSERT INTO bdv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ତର୍‌ ରାଇଜ୍‌ ଆସ, ଜଃନ୍‌କଃରି ସଃର୍ଗେ ସେନ୍‌କଃରି ହୁର୍ତିବି ତଃୟ୍‌ ତର୍‌ ଇଚା ହୁରୁଣ୍ ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଆଜି ଅଃମିମଃନ୍‌କ୍‌ ଲଳା ରିଲା କାଦି ଦେ । ");
INSERT INTO bdv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ଅଃମିମଃନ୍‌ ଜଃନ୍‌କଃରି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଦସିମଃନ୍‌କେ କେମା କଃରୁଲୁ, ସେନ୍‌କଃରି ଅଃମାର୍‌ ସଃବୁ ହାହ୍‌ କେମା କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ପରିକ୍ୟାୟ୍‌ ଅଃମିମଃନ୍‌କ୍‌ ଆଣ୍‌ନାୟ୍‌, ମଃତର୍‌ ସୟ୍‌ତାନ୍ ଜେ ଦୁସ୍ଟ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃମିକ୍‌ ରଃକ୍ୟା କଃର୍‌ । ଜଃନ୍ ରାଇଜ୍‌, ସଃକ୍ତି ଆର୍‌ ଜଃଜ୍‌ମାନ୍ ଜୁଗେ ଜୁଗେ ତର୍‌ ଅଃଉଅ, ଆମେନ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ତୁମି ଜଦି ଲକ୍‌ମଃନାର୍‌ ସଃବୁ ଦଃସ୍‌ କେମା କଃରାସ୍‌, ତଃବେ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ତୁମିକେ ହେଁ କେମା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମଃତର୍‌ ତୁମି ଜଦି ଲକ୍‌ମଃନ୍‌କେ କେମା ନଃକେରାସ୍‌, ତଃବେ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ହେଁ ତୁମାର୍‌ ଦଃସ୍‌ ସଃବୁ କେମା ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଉହାସ୍‌ କଃର୍ତାବଃଳ୍‌ ହେଟ୍‌କପଟ୍ୟାମଃନାର୍‌ ହର୍‌ ମୁଉଁ ସୁକାୟ୍‌ ରିଆନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଉହାସ୍‌ କଃରୁଲାୟ୍‌ ବଃଲି ଲକ୍‌ମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅଃଉଁକେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମୁଉଁ ସୁକାୟ୍‌ ରେତି; ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣା କଃଲା କାମାର୍‌ ପୁରିସ୍କାର୍‌ ହାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମଃତର୍‌ ତୁମି ଉହାସ୍‌ କଃର୍ତାବଃଳ୍‌ ମୁଉଁ ଦଃଉଆ ଆର୍‌ ମୁଣ୍ଡେ ଚିକଣ୍‌ ଲାଗାଉଆ, ");
INSERT INTO bdv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଜଃନ୍‌କଃରି ତୁମି ଉହାସ୍‌ କଃରୁଲାସ୍‌ ବଃଲି ଲକ୍‌ମଃନ୍ ନଃଜାଣତ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ନଃଡିସ୍ତାର୍‌ ଉବାଦିର୍‌ ମୁଏଁ ଜାଣାହଃଳା; ଆର୍‌ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଜେ କି ନଃଡିସ୍ତେ ଆଚେ, ସେ ତୁମିକେ ହଃଳ୍‌ ଦଃୟଃଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ଜୁୟ୍‌ ଲଃଗେ ଅଳ୍‌ମା କି କିଲୁଆ ନଃସ୍ଟ୍‌ କଃରେଦ୍‌, ଆରେକ୍‌ ଚର୍‌ମଃନ୍ ସିନ୍ଦ୍‌ମାରି ଚରି ନେତି, ଇବାନ୍ୟା ହୁର୍ତିବି ଲଃଗେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗିନେ ଦଃନ୍ ଅଃର୍ଜା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମଃତର୍‌ ଜୁୟ୍‌ ଲଃଗେ ଅଳ୍‌ମା କି କିଲୁଆ ନଃସ୍ଟ୍‌ ନଃକେରେ ଆର୍‌ ଚର୍‌ମଃନ୍ ସିନ୍ଦ୍‌ମାରି ଚରି ନଃନେତି, ଇବାନ୍ୟା ସଃର୍ଗେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗିନେ ଦଃନ୍ ଅଃର୍ଜା । ");
INSERT INTO bdv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ତି ତୁମାର୍‌ ଦଃନ୍‌, ସେତି ତୁମାର୍‌ ମଃନ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ଆକି ଗଃଗାଳାର୍‌ କୁପି । ଇତାର୍‌ ଗିନେ ତୁମାର୍‌ ଆକି ଜଦି ନିକ ରଃୟ୍‌ଦ୍‌, ତଃବେ ତୁମାର୍‌ ସଃବୁ ଗଃଗାଳ୍‌ ଉଜାଳ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମଃତର୍‌ ତୁମାର୍‌ ଆକି ଜଃଡେବଃଳ୍‌ ନିକ ନଃରେୟ୍‌, ତଃବେ ତୁମାର୍‌ ସଃବୁ ଗଃଗାଳ୍‌ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଦ୍‌ । ବଃଲେକ୍‌ ତୁମାର୍‌ ମଃନାର୍‌ ଉଜାଳ୍‌ ଜଦି ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଦ୍‌, ତଃବେ ସେ ଅଃନ୍ଦାର୍‌ କଃଡେ ବୟଃଙ୍କାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“କୁୟ୍‌ ମାନାୟ୍‌ ହେଁ ଜଳେକ୍‌ ସାଉକାରାର୍‌ ସେବା କଃରୁ ନାହାରେ; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଗଟ୍‌ଲକ୍‌କେ ଲାଡ୍‌ କଃରେଦ୍‌ ଆର୍‌ ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌କେ ଲାଡ୍‌ ନଃକେରେ, ନୟ୍‌ଲେକ୍‌ ଗଟ୍‌ଲକାର୍‌ କଃତା ମାନେଦ୍‌ ଆର୍‌ ଆରେକ୍‌ ଗଟ୍‌ଲକାର୍‌ କଃତା ନଃମାନେ । ତୁମିମଃନ୍ ଇସ୍ୱର୍‌ ଆର୍‌ ଦଃନ୍, ଦୁୟ୍‌ ଲକାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଅଃଉଁ ନାହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କାଉଁଲେ, କାୟ୍‌ରି କାଉଁନ୍ଦ୍‌ ଆର୍‌ କାୟ୍‌ରି ହିଉଁନ୍ଦ୍‌, ଇବାନ୍ୟା ତୁମାର୍‌ ଜିବନାର୍‌ ଗିନେ, କି କାୟ୍‌ରି ହିନ୍ଦୁନ୍‌, ଇବାନ୍ୟା ତୁମାର୍‌ ଗଃଗାଳାର୍‌ ଗିନେ ହେଁ ଚିତା କଃରାନାୟ୍‌ । କାଦି ତଃୟ୍‌ହୁଣି ଜିବନ୍ ଆର୍‌ ବଃସ୍ତର୍‌ ତଃୟ୍‌ହୁଣି ଗଃଗାଳ୍‌ କାୟ୍‌ ବଃଡ୍ ନାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ଅଃଗାସାର୍‌ ଚେଳେମଃନ୍‌କେ ଦଃକା, ସେମଃନ୍ ନଃବୁଣ୍‌ତି କି ନଃକାଟ୍‌ତି, ଆରେକ୍‌ ହାଲେ ନଃସେଙ୍ଗାଉତି, ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ସେମଃନ୍‌କେ କାଦି ଦେଉଁଲା । ତୁମିମଃନ୍ କାୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ନାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଆରେକ୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ କେ ଚିତା କଃରି କଃରି ଅଃହ୍‌ଣାର୍‌ ଆୟ୍‌ଁସ୍‌ କଃଣ୍ଡେକ୍‌ ବାଡାଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ଆର୍‌ ବଃସ୍ତର୍‌ ଗିନେ କାୟ୍‌ତାକ୍‌ ଚିତା କଃରୁଲାସ୍‌ ? ବଃନାର୍‌ ହୁଲ୍‌ମଃନାର୍‌ କଃତା ବାବି ଦଃକା, ସେରିମଃନ୍ କଃନ୍‌କଃରି ବାଡ୍‌ତି; ସେରିସଃବୁ କଃବାଳ୍‌ ନଃକେର୍ତି, କି ସୁତା କାଟି ସେମଃନାର୍‌ ଗିନେ ବଃସ୍ତର୍‌ ନଃବୁଣ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ରଃଜା ସଲ୍‌ମନ୍ ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଦଃନ୍‌ ରଃୟ୍‌କଃରି ହେଁ, ଇ ହୁଲ୍‌ମଃନାର୍‌ ହର୍‌ ଗଟେକ୍‌ ସୁନ୍ଦୁର୍‌ ବଃସ୍ତର୍‌ କଃବେ ହିନ୍ଦି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ମଃତର୍‌ ହଃଦାର୍‌ ଜୁୟ୍‌ ଜାଳ୍‌ ଆଜି ଆଚେ, ଆର୍‌ କାଲି ଚୁଲି ବିତ୍ରେ ହଃକା ଅୟ୍‌ଦ୍‌, ତାକ୍‌ ଜଃଡେବଃଳ୍‌ ଇସ୍ୱର୍‌ ଇବାନ୍ୟା ବେସ୍‌ ଦେଉଁଲା, ତଃବେ ଏ ଅଃଳକ୍‌ ବିସ୍ୱାସିମଃନ୍, ସେ କାୟ୍‌ ତୁମିମଃନ୍‌କେ ଅଃଦିକ୍‌ ସଃତ୍‌କଃରି ବଃସ୍ତର୍‌ ନଃଦେୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ଇତାର୍‌ ଗିନେ କାୟ୍‌ରି କାହାସ୍‌ ? କାୟ୍‌ରି ହିଉଆସ୍‌ ? କି କାୟ୍‌ରି ହିନ୍ଦାସ୍‌ ? ଇବାନ୍ୟା ବଃଲି ଚିତା କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଜିଉଦିମଃନ୍‌ ଇସ୍ୱର୍‌କେ ନଃଜାଣ୍‌ତି, ସେମଃନ୍ ଇସଃବୁ ବିସୟ୍‌ ଲଳି ବୁଲ୍‌ତି । ଆର୍‌ ଇ ସଃବୁ ବିସୟ୍‌ ଜେ ତୁମିମଃନାର୍‌ ଲଳା, ସେରି ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଜାଣୁଲା । ");
INSERT INTO bdv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମଃତର୍‌ ତୁମିମଃନ୍ ହଃର୍ତୁ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଆର୍‌ ସେ ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ଇଚା କଃରୁଲା ସେତାକ୍‌ ଦିଆନ୍‌ କଃରା, ତଃବେ ସେ ତୁମିକେ ଇସଃବୁ ହେଁ ଦଃୟଃଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ବଃଲେକ୍‌ କାଲିର୍‌ ଗିନେ ଚିତା କଃରାନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ କାଲି ନିଜେ ନିଜାର୍‌ ଗିନେ ଚିତା କଃରାସ୍‌ । ଆଜିର୍‌ କଃସ୍ଟ୍‌ ଆଜିର୍‌ ଗିନେ ସଃରି ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ବିଚାରେ ନଃହେଳାସ୍‌, ଇତାର୍‌ ଗିନେ ବିନ୍ ଲକାର୍‌ ବିଚାର୍‌ କଃରାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ବିଚାରେ ବିଚାର୍‌ କଃରାସ୍‌, ସେ ବିଚାରେ ତୁମିମଃନ୍‌କେ ହେଁ ବିଚାର୍‌ କଃରା ଅୟ୍‌ଦ୍‌; ଆରେକ୍‌ ଜୁୟ୍‌ ନାହେଁ ନାହି ଦିଆସ୍‌, ସେ ନାହେଁ ତୁମିମଃନ୍‌କେ ହେଁ ନାହି ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ଆର୍‌ କାୟ୍‌ତାକ୍‌ ତୁମାର୍‌ ବାୟ୍‌ର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ କୁଟା ଦଃକୁଲାସ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ନିଜାର୍‌ ଆକାୟ୍‌ ଜୁୟ୍‌ ବଃଡ୍ ଆକିକୁଟା ଆଚେ, ସେରି କାୟ୍‌ତାକ୍‌ ବାବି ନଃଦେକୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ବଃଲେକ୍‌ ତୁମି କଃନ୍‌କଃରି ନିଜାର୍‌ ବାୟ୍‌କ୍‌ କଃଉଁ ହାରାସ୍‌, ‘ଆଉ ତର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ ଆକିକୁଟା ବାର୍‌କଃରି ଦଃୟ୍‌ନ୍ଦ୍,’ ଆର୍‌ ଦଃକା, ତୁମାର୍‌ ଆକାୟ୍‌ ବଃଡ୍ ଆକିକୁଟା ଆଚେ ! ");
INSERT INTO bdv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ରେ, ହେଟ୍‌କପଟ୍ୟାମଃନ୍‌, ଆଗ୍‌ତୁ ନିଜାର୍‌ ଆକାୟ୍‌ ରିଲା ବଃଡ୍ ଆକିକୁଟା ବାର୍‌ କଃରି ହଃକାଉଆ, ତାର୍‌ହଃଚେ ନିଜାର୍‌ ବାୟ୍‌ର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ ଆକିକୁଟା ବାର୍‌ କଃରୁକ୍‌ ନିକକଃରି ଦଃକୁ ହାର୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ଜାୟ୍‌ରି ପବିତ୍ର ସେରି କୁକୁର୍‌ମଃନ୍‌କେ ଦିଆସ୍‌ ନାୟ୍‌, କଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସେମଃନ୍ ଲେଉଟିକଃରି ତୁମିକେ ଚାବ୍‌ତି । କି ତୁମାର୍‌ ମୁକ୍ତା ଗୁସ୍ରାମଃନାର୍‌ ମୁଏଁ ହଃକାଉଆ ନାୟ୍‌, କଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସେମଃନ୍ ସେ ସଃବୁ ସେମଃନାର୍‌ ହାଦେ ରଃମ୍‌ନ୍ଦି ହଃକାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ମାଗା, ତଃବେ ତୁମିମଃନ୍‌କେ ଦିଆ ଅୟ୍‌ଦ୍‌; ଲଳା, ତଃବେ ତୁମିମଃନ୍ ମିଳାଉଆସ୍‌; କଃହାଟେ ମାରା, ତଃବେ ତୁମାର୍‌ ଗିନେ କଃହାଟ୍‌ ଉଗାଳା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ବଃଲେକ୍‌, ଜୁୟ୍‌ ଲକ୍‌ ମାଗେଦ୍‌, ସେ ହାୟ୍‌ଦ୍‌; ଜେ ଲଳେଦ୍‌, ସେ ମିଳାୟ୍‌ଦ୍‌; ଆର୍‌ ଜେ କଃହାଟେ ମାରେଦ୍‌, ତାର୍‌ ଗିନେ କଃହାଟ୍‌ ଉଗାଳି ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ଆର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଇବାନ୍ୟା କୁୟ୍‌ ଉବା ଆଚେ, ଜେ ଅଃହ୍‌ଣାର୍‌ ହୟ୍‌ସି ରୁଟି ମାଗ୍‌ଲେକ୍‌ ତାକ୍‌ ଟେଳା ଦଃୟଃଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ଆରେକ୍‌ ମାଚ୍ ମାଗ୍‌ଲେକ୍‌ ତୁମି ତାକ୍‌ ସାହ୍‌ ଦଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ତୁମିମଃନ୍ କଃରାବ୍‌ ଅୟ୍‌ଲେକ୍‌ ହେଁ, ତୁମି ଜଃଡେବଃଳ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହିଲାମଃନ୍‌କେ ନିକ ନିକ ଦାନ୍‌ ଦେଉଁ ଜାଣାସ୍‌, ତଃବେ ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ତାର୍‌ ଲଃଗେ ମାଗ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ କଃତେକ୍‌ ଅଃଦିକ୍‌ ନିକ ବଃଲ୍‌ରିମଃନ୍ ନଃଦେୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ବଃଲେକ୍‌ ଲକ୍‌ମଃନ୍ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଜଃନ୍‌କା ବେବାର୍‌ କଃରତ୍‌ ବଃଲି ମଃନ୍ କଃରୁଲାସ୍‌, ତୁମିମଃନ୍ ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେବାନ୍ୟା ବେବାର୍‌ କଃରା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇରି ହଃକା ମସାର୍‌ ବିଦି ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ ସିକ୍ୟାର୍‌ ସଃତ୍‌ ଅଃର୍ତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ସାକୁଳ୍‌ ଦୁଆର୍‌ ଅୟ୍‌ ବିତ୍ରେ ହୁରା; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନାସ୍‌ କଃରୁକେ ନେତା ନଃର୍କାର୍‌ ଦୁଆର୍‌ ଅଃସାର୍‌ ଆର୍‌ ବାଟ ବଃଡ୍, ଆରେକ୍‌ ସେ ଦୁଆର୍‌ ଦଃୟ୍‌ ହୁର୍ତା ଲକ୍‌ ଗାଦେକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ଆର୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ବାଟ୍‌କେ ନେତା ଦୁଆର୍‌ ସାକୁଳ୍‌ ଆର୍‌ ବାଟ କଃସ୍ଟ୍‌, ଆରେକ୍‌ ସେରି ବେଟ୍‌ ହାଉତା ଲକ୍‌ ଉଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ବାମାଉତା ମିଚ୍ ବାବ୍‌ବାଦିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ; ସେମଃନ୍ ମେଣ୍ଡା ବେସ୍‌ ଦଃରି ତୁମାର୍‌ ଚଃମେ ଆସ୍ତି, ମଃତର୍‌ ସେମଃନ୍ ମଃନ୍ ବିତ୍ରେ ଗଟେକ୍‌ ଗଟେକ୍‌ ଗଃଦବାଗ୍ ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ସେମଃନାର୍‌ କାମ୍‌ ଦଃକି ତୁମି ସେମଃନ୍‌କେ ଚିନୁ ହାରାସ୍‌ । କାଟାବୁଟାୟ୍‌ ଅଙ୍ଗୁର୍‌ ଜୁବ୍‌ଳା ନଃହେଳେ କି କାଟାକଳି ଗଃଚେହୁଣି ଡୁମ୍ବୁର୍‌ ହଃଳ୍‌ ନଃହେଳେ । ");
INSERT INTO bdv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ସେବାନ୍ୟା ସଃବୁ ନିକ ଗଃଚେ ନିକ ହଃଳ୍‌ ହଃଳେଦ୍‌, ମଃତର୍‌ କଃରାବ୍‌ ଗଃଚେ କଃରାବ୍‌ ହଃଳ୍‌ ହଃଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ନିକ ଗଃଚେ କଃରାବ୍‌ ହଃଳ୍‌ ନଃହେଳେ, କି କଃରାବ୍‌ ଗଃଚେ ନିକ ହଃଳ୍‌ ନଃହେଳେ । ");
INSERT INTO bdv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଜୁୟ୍‌ ଗଃଚେ ନିକ ହଃଳ୍‌ ନଃହେଳେ, ସେ ଗଃଚ୍‌କେ କାଟି ଜୟେ ହଃକା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ବଃଲେକ୍‌ ସେରଃକମ୍‌ ବାମାଉତା ବାବ୍‌ବାଦିମଃନାର୍‌ କାମ୍‌ ଦଃକି ସେମଃନ୍‌କେ ତୁମି ଚିନୁ ହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମକ୍‌ ‘ମାପ୍ରୁ, ମାପ୍ରୁ’ ବଃଲି କଃଉତି, ସେମଃନ୍ ବିତ୍ରେ ସଃବୁଲକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜେ ଜଃଉଁ ନଃହାର୍‌ତି, ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ଇଚା ହୁରୁଣ୍ କଃର୍ତି, ସେମଃନ୍ ହଃକା ସଃର୍ଗ୍‌ ରାଇଜେ ଜଃଉଁକେ ହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ସେ ଇସ୍ୱରାର୍‌ ବିଚାର୍‌ ଦିନ୍ ଗାଦେକ୍‌ ଲକ୍‌ ମକ୍‌ କଃଉତି, ‘ଏ ମାପ୍ରୁ, ଏ ମାପ୍ରୁ, ଅଃମିମଃନ୍‌ କାୟ୍‌ ତର୍‌ ନାଉଁଏ ଇସ୍ୱରାର୍‌ ବାବ୍‌ବାଣି କୟ୍‌ନଃରିଲୁ ? ଆରେକ୍‌ ତର୍‌ ନାଉଁଏ କାୟ୍‌ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାୟ୍‌ ନଃରିଲୁ ? ଆର୍‌ ତର୍‌ ନାଉଁଏ କାୟ୍‌ ଅଃମିମଃନ୍‌ ଗାଦେକ୍‌ କାବାଅଃଉତା କାମ୍‌ କଃରି ନଃରିଲୁ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ସଃଡେବଃଳ୍‌ ମୁଁୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ନ୍ଦ୍, ‘ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନଃଜାଣି । ଏ ଅଃଦଃର୍ମିମଃନ୍‌, ମର୍‌ ଲଃଗେହୁଣି ଦୁର୍‌ ଅଃଉଆ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ତଃବେ ଜୁୟ୍‌ଲକ୍‌ ମର୍‌ ଇ ସଃବୁ କଃତା ସୁଣେଦ୍‌ ଆର୍‌ ମାନେଦ୍‌, ସେ ଟେଳା ଉହ୍ରେ ଗଃର୍‌ ବାନ୍ଦ୍‌ଲା ବୁଦିଆ ଲକ୍‌ ହର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ବଃର୍ସା ଅୟ୍‌ଲି, ହୁର୍‌ ଆୟ୍‌ଲି, ବାଉବଃତାସ୍‌ ଆୟ୍‌ଲି ଆର୍‌ ସେ ଗଃର୍‌କେ ଦଃକା ମାର୍‌ଲି । ମଃତର୍‌ ସେ ଗଃର୍‌ ନଃବେସୁଳ୍‌ଲି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେରି ଚଃଚ୍ରା ଉହ୍ରେ କୁନାଦି ଅୟ୍‌ରିଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ମର୍‌ ଇ ସଃବୁ କଃତା ସୁଣି ନଃମାନେ, ସେ ବାଲି ଉହ୍ରେ ଗଃର୍‌ ବାନ୍ଦ୍‌ଲା ନିର୍ବୁଦିଆ ଲକ୍‌ ହର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ବଃଡ୍ ବଃର୍ସା ଅୟ୍‌ଲି, ହୁର୍‌ ଆୟ୍‌ଲି, ବାଉବଃତାସ୍‌ ଆୟ୍‌ଲି ଆର୍‌ ସେ ଗଃର୍‌କେ ଦଃକ୍ୟା ମାର୍‌ଲି, ଆର୍‌ ସେ ଗଃର୍‌ ବାଙ୍ଗି ଅଦ୍ରିଗଃଲି । ଆରେକ୍‌ ତାର୍‌ ଦଃସା ବଃଡେ ବୟ୍‌ଙ୍କାର୍‌ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଜିସୁ ଇ ସଃବୁ କଃତା କୟ୍‌ ସଃର୍ଲା ହଃଚେ, ଲକ୍‌ମଃନ୍ ତାର୍‌ ସିକ୍ୟା ସୁଣି କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ସେମଃନାର୍‌ ଗୁରୁମଃନାର୍‌ ହର୍‌ ସିକ୍ୟା ନଃଦେୟ୍‌, ଅଃଦିକାର୍‌ ହାୟ୍‌ଲା ଲକାର୍‌ ହର୍‌ ସେମଃନ୍‌କେ ସିକ୍ୟା ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ ହଃର୍ବାତେ ହୁଣି ଉତ୍ରି ଆୟ୍‌ଲାକ୍‌, ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଆର୍‌ ଗଟେକ୍‌ ବଃଡ୍‌ ରଗି ତାର୍‌ ତଃୟ୍‌ ଆସି ଜୁଆର୍‌ କଃରି କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ତୁୟ୍‌ ଜଦି ମଃନ୍ କଃଲେକ୍‌ ମକ୍‌ ଉଜ୍‌ କଃରୁ ହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ସେତାକ୍‌ ଜିସୁ ଆତ୍‌ ଲାମାୟ୍‌ ତାକ୍‌ ଚୁୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ମଃନ୍‌ କଃରୁଲେ, ତୁୟ୍‌ ଉଜ୍‌ ଅଃଉ ।” ସେଦାହ୍ରେ ତାର୍‌ ବଃଡ୍‌ ରଗେହୁଣି ଉଜ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଆର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଦୁକ୍‌, ଇ କଃତା କାକେ କଃଉନାୟ୍‌, ମଃତର୍‌, ଜାଜକ୍‌ ଲଃଗେ ଦଃକାୟ୍‌ ଅଃଉ, ଆରେକ୍‌ ମସା ଜୁୟ୍‌ ବେଟି ଦେଉଁକେ ଆଦେସ୍‌ ଦିଲା ଆଚେ, ସେରି ସେମଃନାର୍‌ ଚଃମେ ତୁୟ୍‌ ଉଜ୍‌ ଅୟ୍‌ ଆଚ୍‌ସି ବଃଲି ସାକି ଦେଉଁକେ ଦାନ୍‌ ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଆୟ୍‌ଲାକ୍‌, ଗଟେକ୍‌ ସଏ ସଃଇନାର୍‌ ଅଃଦିକାରି ତାର୍‌ ଚଃମେ ଆସି ଗଃଉଆରି କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଏ ମାପ୍ରୁ, ମର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଏକ୍‌ଅଃଙ୍ଗି ରଗେ ହଃଳିକଃରି ବଃଡେ କଃସ୍ଟ୍‌ ହାୟ୍‌ ଗଃରେ ଟାଟାୟ୍‌ ସଇଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ଜାୟ୍‌ ତାକ୍‌ ଉଜ୍‌ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ମଃତର୍‌ ସେ ମୁଳିକା ସଃଇନ୍ ଉତୁର୍‌ ଦିଲା, “ମାପ୍ରୁ, ତୁୟ୍‌ ଜେ ମର୍‌ ଗଃରେ ହାଦ୍‌ ହଃକାଉସି ମୁଁୟ୍‌ ଅଃନ୍‌କା ଜୟ୍‌ଗ୍‌ ନାୟ୍‌, ମଃତର୍‌ ତୁୟ୍‌ ହଃଦେକ୍‌ କଃଉ, ମର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଉଜ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ବଃଲେକ୍‌ ମୁଁୟ୍‌ ମର୍‌ ଉହ୍ରାର୍‌ ଅଃଦିକାରି ତଃଳେ ରେତା ଲକ୍‌ ଅୟ୍‌ଲେକ୍‌ ହେଁ ମର୍‌ ତଃଳେ ସଃଇନ୍‌ମଃନ୍ ଆଚ୍‌ତି; ମୁଁୟ୍‌ ଗଟ୍‌ ଲକ୍‌କେ, ‘ଜାଆ !’ ବଃଲେକ୍‌ ସେ ଜାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌କେ, ‘ଆଉ !’ ବଃଲେକ୍‌ ସେ ଆସେଦ୍‌; ଆର୍‌ ମର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌, ଇରି କଃର୍‌ ! ବଃଲେକ୍‌ ସେ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଇରି ସୁଣି କାବା ଅୟ୍‌ ହଃଚ୍ ବାଟ ଆସ୍ତା ଲକ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ଅଃଡେକ୍‌ ବଃଡ୍ ବିସ୍ୱାସ୍‌ ନଃହାୟ୍‌ଁ । ");
INSERT INTO bdv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଗାଦେକ୍‌ ଲକ୍‌ ଉଦ୍‌ତି ଆର୍‌ ବୁଡ୍‌ତି ବାଟ୍‌ହୁଣି ଆସି ଅବ୍ରାହାମ୍‌, ଇସାକ୍‌ ଆର୍‌ ଜାକୁବକ୍‌ ସଃଙ୍ଗ୍ ସଃର୍ଗ୍‌ ରାଇଜେ ବଜି କାଉଁକେ ବଃସ୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସେ ରାଇଜେ ରେତା କଃତା, ସେମଃନ୍‌କେ ହଃଦାୟ୍‌ ଅଃନ୍ଦାରେ ହଃକାଅୟଃଦ୍‌, ସେତି କାନ୍ଦ୍‌ତି ଆର୍‌ ଦାତ୍‌ ଚାବି ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଆର୍‌ ଜିସୁ ସଃଇନ୍ ଅଃଦିକାରିକ୍‌ କୟ୍‌ଲା, “ଜାଆ, ତୁୟ୍‌ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରି ଆଚ୍‌ସି, ତର୍‌ ଉହ୍ରେ ସେନ୍ ଅଃଉଅ ।” ସେଦାହ୍ରେ ସେ ଦଃଙ୍ଗ୍‌ଳା ଉଜ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ହଃଚେ ଜିସୁ ପିତର୍‌ ଗଃରେ ଆସି, ପିତରାର୍‌ ସଃତୁର୍ସି ଜଃରାର୍‌ ଗିନେ ଟାଟାୟ୍‌ ସଇରିଲାର୍‌ ଦଃକ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ସେତାକ୍‌ ଜିସୁ ତାର୍‌ ଆତେ ଚୁୟ୍‌ଲାକ୍‌ ତାର୍‌ ଜଃର୍‌ ଚାଡ୍‌ଲି, ଆର୍‌ ସେ ଉଟି ତାର୍‌ ସେବା କଃରୁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ଲକ୍‌ମଃନ୍ ଗାଦାଗଟ୍‌ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଜିସୁର୍‌ ହାକ୍‌ ଆଣ୍‌ଲାୟ୍‌, ସେତାକ୍‌ ସେ ଗଟେକ୍‌ କଃତାୟ୍‌ ସେମଃନାର୍‌ ବୁତ୍‌ ଚାଡାୟ୍‌ଲା, ଆର୍‌ ସଃବୁ ମଃଳୁହଃଳ୍‌ଲା ଲକ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଇରଃକମ୍‌ ସେ ଜିସାୟ୍‌ ବାବ୍‌ବାଦି କୟ୍‌ରିଲା କଃତା ହୁରୁଣ୍ କଃଲା, “ସେ ନିଜେ ଅଃମିମଃନାର୍‌ ନିଗାଳ୍‌ ସଃବୁ ନିଲା ଆର୍‌ ବ୍ୟାଦି ସଃବୁ ବୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚାରିହାକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ତାର୍‌ ଚେଲାମଃନ୍‌କେ ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟିକ୍‌ ଜଃଉଁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ଆରେକ୍‌ ଗଟେକ୍‌ ସାସ୍ତ୍ରି ତାର୍‌ ଚଃମେ ଆସି କୟ୍‌ଲା, “ଏ ଗୁରୁ, ତୁୟ୍‌ ଜୁୟ୍‌ତି ଗଃଲେକ୍‌ ହେଁ, ମୁଁୟ୍‌ ତର୍‌ ହଃଚେ ହଃଚେ ଆସିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ସେତାକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “କଲ୍ୟାର୍‌ ହାର୍‌ ଆଚେ, ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନାର୍‌ ବାସା ଆଚେ, ମଃତର୍‌ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ମୁଣ୍ଡ୍ ଗୁଞ୍ଜୁକେ ଟାଣ୍ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଆରେକ୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଆରେକ୍‌ ଏକ୍ଲା କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ହଃର୍ତୁ ଜାୟ୍‌ ମର୍‌ ଉବାକ୍‌ ବେଟି ହଃକାଉଁକ୍‌ ମକ୍‌ ଚାଡି ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ, ମଃଲା ଲକ୍‌କେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମଃଲା ଲକ୍‌ମଃନ୍‌କେ ବେଟି ହଃକାଉଁକ୍‌ ଚାଡି ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଜିସୁ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ଲାକେ, ତାର୍‌ ଚେଲାମଃନ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଜଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଆର୍‌ ତଃତ୍‌କାଣ୍‌ ସଃମ୍‌ନ୍ଦେ ଅଃପର୍‌ବଳ୍‌ ବାଉବଃତାସ୍‌ ଅୟ୍‌ଲି, ଆର୍‌ ଉଲାଳେ ଡଙ୍ଗା ବୁଡୁକ୍‌ ଦଃର୍ଲି, ମଃତର୍‌ ଜିସୁ ସୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆସି ତାକ୍‌ ଉଟାୟ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌, “ଏ ମାପ୍ରୁ, ବଚାଉ, ନୟ୍‌ଲେକ୍‌ ଅଃମି ବୁଡି ମଃରୁନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ଅଃଳକ୍‌ ବିସ୍ୱାସିମଃନ୍, ତୁମିମଃନ୍ କାୟ୍‌କଃରୁକ୍‌ ଅଃତେକ୍‌ ଡିରୁଲାସ୍‌ ?” ସଃଡେବଃଳ୍‌ ଜିସୁ ଉଟି ସଃମଃନ୍ଦ୍ ଆର୍‌ ବାଉକେ ତିର୍‌ ଅଃଉଁକେ ଆଡର୍‌ ଦିଲା, ଆର୍‌ ସଃବୁ ତିର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ କଃନ୍‌କା ଲକ୍‌, ବାଉ ଆର୍‌ ସଃମ୍‌ନ୍ଦ୍ ହେଁ ତାର୍‌ କଃତା ମାନୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ହଃଚେ ସେହାଟି ଗଦରିୟମଃନାର୍‌ ହଲିକେ ଜିସୁ ହଚ୍‌ଲାକ୍‌, ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଦୁୟ୍‌ ଲକ୍‌ ମଃସୁଣ୍‌ କାଲେ ହୁଣି ବାରାୟ୍‌ ତାକେ ବେଟ୍‌ ଅୟଃଲାୟ୍‌ । ସେମଃନ୍ ଅଃନାୟ୍‌ ସଃକ୍ତି ରିଲାୟ୍‌ ଜେ, ସେ ବାଟ୍‌ ଦଃୟ୍‌ କେହେଁ ଜାଆ ଆସ୍‌ କଃରୁ ନଃହାର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ଆର୍‌ ସେଦାହ୍ରେ ସେମଃନ୍ ବେଲ୍‌କି ଅୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଏ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତର୍‌ ସଃଙ୍ଗ୍ ଅଃମାର୍‌ କାୟ୍‌ରି ଆଚେ ? ବେଳା ନଃଉତ୍‌ ତୁୟ୍‌ କି ଅଃମିମଃନ୍‌କେ ଡଃଣ୍ଡ୍‌ ଦେଉଁକେ ଇତି ଆୟ୍‌ଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆର୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକେ ଗଟ୍‌ ଗୁସ୍ରା ମଃନ୍ଦା ଚଃର୍ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ସେତାକ୍‌ ବୁତ୍‌ମଃନ୍ ଜିସୁକେ ଗଃଉଆରି କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତୁୟ୍‌ ଜଦି ଅଃମିମଃନ୍‌କ୍‌ ଚାଡାଉସି, ତଃବେ ଗୁସ୍ରା ମଃନ୍ଦାର୍‌ ବିତ୍ରେ ହଃଟାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜାହା ।” ସେତାକ୍‌ ସେମଃନ୍ ବାରାୟ୍‌ ଗୁସ୍ରାମଃନାର୍‌ ବିତ୍ରେ ହୁର୍ଲାୟ୍‌, ଆର୍‌ ଗୁସ୍ରା ମଃନ୍ଦା ସଃବୁ ରସେ ଦଃବ୍‌ଳି ଜାୟ୍‌ ସଃମଃନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ହୁଣି ଆସି ସଃମଃନ୍ଦ୍ ବିତ୍ରେ ଅଦ୍ରି ବୁଡି ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ଆରେକ୍‌ ଚଃରାଉତା ଲକ୍‌ମଃନ୍ ହଃଳାୟ୍‌ ଗଃଳାୟ୍‌ ଆର୍‌ ଗଃଳ୍‌ ବିତ୍ରେ ଜାୟ୍‌ ସଃବୁ କଃତା ଆର୍‌ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌କେ ଜାୟ୍‌ ଜାୟ୍‌ରି ଗଃଟିରିଲି ସେରିମଃନ୍ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଆର୍‌ ଗଃଳ୍‌ ବିତ୍ରାର୍‌ ସଃବୁ ଲକ୍‌ ଜିସୁକେ ବେଟ୍‌ ଅଃଉଁକେ ବାରାୟ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ତାକ୍‌ ଦଃକି ସେମଃନାର୍‌ ସଃନ୍ଦାୟ୍‌ ହୁଣି ବାରାୟ୍‌ ଜଃଉଁକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ଡଙ୍ଗାୟ୍‌ ବଃଗି ସଃମଃନ୍ଦ୍ ଲିଙ୍ଗି ନିଜାର୍‌ ଗଃଳେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆର୍‌ ଲକ୍‌ମଃନ୍ ମଃଳୁହଃଳ୍‌ଲା ଗଟେକ୍‌ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ କଃଟ୍‌ ତଃୟ୍‌ ବୟ୍‌କଃରି ତାର୍‌ ଚଃମେ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ସେମଃନାର୍‌ ବିସ୍ୱାସ୍‌ ଦଃକି ସେ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ କୟ୍‌ଲା, “ହଅରେ, ସାସ୍‌ ଦଃର୍‌, ତର୍‌ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଆର୍‌ ହଃଣ୍ଡିତ୍‌ମଃନାର୍‌ ବିତ୍ରେ କେ କେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉତି ରିଲାୟ୍‌, “ଇ ଲକ୍‌ ଇସ୍ୱର୍‌ ଲିନ୍ଦା କଃରୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ଜିସୁ ସେମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରାର୍‌ ବାବ୍‌ନା ଜାଣି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ମଃନ୍‌ ବିତ୍ରେ କାୟ୍‌କଃରୁକ୍‌ କଃରାବ୍‌ ଚିତା କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ବଃଲେକ୍‌ କାୟ୍‌ରି ଉହାସ୍‌ ? ‘ତର୍‌ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଲି,’ ବଃଲି କଃଉତାର୍‌, କି, ‘ଉଟ୍‌, ଇଣ୍ଡ୍,’ ବଃଲି କଃଉତାର୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମଃତର୍‌ ହୁର୍ତିଏ ହାହ୍‌ କେମା କଃରୁକେ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଜେ ଅଃଦିକାର୍‌ ଆଚେ;” ଇରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ଜାଣୁ ହାରାସ୍‌, ଇତାର୍‌ ଗିନେ ଜିସୁ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ କୟ୍‌ଲା, “ଉଟ୍‌, ତର୍‌ କଃଟ୍‌ ଦଃରି ନିଜାର୍‌ ଗଃରେ ଜାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ସେତାକ୍‌ ସେ ରଗି ଉଟି ତାର୍‌ ଗଃରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ସେରି ଦଃକି ଲକ୍‌ମଃନ୍ ଡିରି ଗଃଳାୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ ଇସ୍ୱର୍‌ ମାନାୟ୍‌ମଃନ୍‌କେ ଇରଃକମ୍‌ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ଆଚେ, ତାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ସେତିହୁଣି ଜଃଉଁ ଜଃଉଁ ମାତିଉ ନାଉଁଆର୍‌ ଗଟ୍‌ ମାନାୟ୍‌କେ ସିସ୍ଟୁ ବାନ୍ଦ୍‌ତା ଟାଣେ ବଃସି ରିଲାର୍‌ ଦଃକି ତାକେ କୟ୍‌ଲା, “ମର୍‌ ସଃଙ୍ଗ୍ ଆଉ ।” ସେତାକ୍‌ ସେ ଉଟି ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଆର୍‌ ଜିସୁ ମାତିଉର୍‌ ଗଃର୍‌ ବିତ୍ରେ କାଉଁକେ ବଃସ୍‌ଲା ବଃଳ୍‌, ଗାଦେକ୍‌ ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନ୍‌ ଆସି ତାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ପାରୁସିମଃନ୍ ସେରି ଦଃକି ତାର୍‌ ଚେଲାମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତୁମିମଃନାର୍‌ ଗୁରୁ କାୟ୍‌କଃରୁକ୍‌ ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଁଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ମଃତର୍‌ ଜିସୁ ସେରି ସୁଣି କୟ୍‌ଲା, “ଉଜ୍‌ ଲକାର୍‌ ଗିନେ ବୟ୍‌ଦ୍‌କାରି ଲଳା ନାୟ୍‌, ମଃତର୍‌ ମଃଳୁ ହଃଳ୍‌ଲା ଲକାର୍‌ ଗିନେ ଲଳା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘ଅଃମି ହୁଜା ମଃନ୍ ନଃକେରୁ, ମଃତର୍‌ ଦଃୟା ମଃନ୍ କଃରୁନ୍ଦ୍‌,’ ଇ କଃତାର୍‌ ଅଃର୍ତ୍‌ ତୁମିମଃନ୍ ଜାୟ୍‌ ସିକା, ବଃଲେକ୍‌ ମୁଁୟ୍‌ ଦଃର୍ମିମଃନ୍‌କେ କୁଦୁକେ ନାସି, ମଃତର୍‌ ହାହିମଃନ୍‌କେ କୁଦୁକେ ଆସି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ସଃଡେବଃଳ୍‌ ଜହନାର୍‌ ଚେଲାମଃନ୍ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ଜିସୁର୍‌ ତଃୟ୍‌ ଆସି କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ଉହାସ୍‌ କଃରୁଲୁ, ମଃତର୍‌ ତର୍‌ ଚେଲାମଃନ୍ କାୟ୍‌ତାକ୍‌ ଉହାସ୍‌ ନଃକେର୍ତି ?” ");
INSERT INTO bdv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବଃର ଜଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ବଃର ଗଚ୍ୟାମଃନାର୍‌ ସଃଙ୍ଗ୍ ବିବାଗଃରେ ରଃୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ସେମଃନ୍ କାୟ୍‌ ଦୁକ୍‌ କଃର୍ତି, ମଃତର୍‌ ବେଳା ଆସେଦ୍‌ ଜଃଡେବଃଳ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ବଃରକେ କାଡି ନିଆ ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଉହାସ୍‌ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“କେହେଁ ନଃଉଆଁ ହଃଚ୍ୟାର୍‌ ହାଟ୍‌ଳି କଃଣ୍ଡେକ୍‌ ଚିରି ହଃର୍ନା ହଃଚ୍ୟାୟ୍‌ ନଃଡେସାୟ୍‌, ବଃଲେକ୍‌ ସେ ହାଟ୍‌ଳି ହଃଚ୍ୟାର୍‌ ବଃଡ୍ କଃଣ୍ଡ୍ ଚିଡାୟ୍‌ ନଃୟ୍‌ଦ୍‌ ଆର୍‌ ଆରେକ୍‌ ଅଃଦିକ୍‌ ବଃଡ୍ କାଣା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଆର୍‌ ଲକ୍‌ମଃନ୍ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହଃର୍ନା ଚାମ୍‌ ମଣାୟ୍‌ ନଃସେଙ୍ଗାଉତି, ସଃଙ୍ଗାୟ୍‌ଲେକ୍‌ ଚାମ୍‌ ମଣା ହାଟେଦ୍‌ । ଆର୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହର୍ଚ୍ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଚାମ୍‌ ମଣା ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌; ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ନଃଉଆଁ ଚାମ୍‌ ମଣାୟ୍‌ ସଃଙ୍ଗାଉତି ଆର୍‌ ଚାମ୍‌ ମଣା ଆର୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହେଁ ନଃସ୍ଟ୍‌ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ସେମଃନ୍‌କେ ଇ କଃତାମଃନ୍‌ କଃଉତା ବଃଳ୍‌, ଗଟ୍‌ ଜିଉଦି ମୁଳିକା ଜିସୁର୍‌ ଚଃମେ ଆସି ଜୁଆର୍‌ କଃରି କୟ୍‌ଲା, “ମର୍‌ ଜିି ଅଃବେ ସେ ମଃଲି, ମଃତର୍‌ ତୁୟ୍‌ ଆସି ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲେକ୍‌ ସେ ବଚେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ସେତାକ୍‌ ଜିସୁ ଉଟି ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଆର୍‌ ବାର ବଃର୍ସ୍‌ ହଃତେକ୍‌ ଗଃଗାଳ୍‌ଜାତା ରଗ୍ ଅୟ୍‌ରିଲା ଗଟ୍‌ ମାୟ୍‌ଜି ଜିସୁର୍‌ ହଃଚ୍‌ବାଟ୍ୟା ଆସି ତାର୍‌ ହଃଚ୍ୟାର୍‌ ଆଚଳ୍‌ ଚୁୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ବଃଲେକ୍‌ ସେ ମଃନେ ମଃନେ କଃଉତି ରିଲି, “ତାର୍‌ ହଃଚ୍ୟାର୍‌ ଆଚଳ୍‌ ଚୁୟ୍‌ଲେକ୍‌ ମୁଁୟ୍‌ ଉଜ୍‌ ଅୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ମଃତର୍‌ ଜିସୁ ହଃଚ୍‌ବାଟ୍‌ ଉଲ୍‌ଟି କଃରି ତାକ୍‌ ଦଃକି କୟ୍‌ଲା, “ଏ ନୁନି, ସାସ୍‌ ଦଃର୍‌, ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ନିକ କଃଲି ।” ତଃତ୍‌କାଣ୍ ସେ ମାୟ୍‌ଜି ଉଜ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ହଃଚେ ଜିସୁ ସେ ଜିଉଦି ମୁଳିକାର୍‌ ଗଃରେ ଆସି ସୁର୍ଲି ହୁକ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ଆଉଲି କାନ୍ଦ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ ଦଃକି କୟ୍‌ଲା, “ହଃଦାୟ୍‌ ବାରାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଇ ଟକି ନଃମେରେ, ମଃତର୍‌ ସଇ ଆଚେ ।” ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ଗେଙ୍ଗ୍ରାୟ୍‌କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ହଃଦାୟ୍‌ ବାରାୟ୍‌ଲାକେ ସେ ବିତ୍ରେ ଜାୟ୍‌ ସେ ଟକିର୍‌ ଆତେ ଦଃରି ଉଟାୟ୍‌ଲାକ୍‌, ସେ ଉଟ୍‌ଲି ଆର୍‌ ଟିଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଆରେକ୍‌ ଇ କଃତା ଦେସ୍‌ ଜାକ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ସେତିହୁଣି ଜାତା ବଃଳ୍‌ ଜଳେକ୍‌ କାଣା ହଃଚେ ହଃଚେ ଜାୟ୍‌ ଆଉଲି ଅୟ୍‌ କାଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଏ ଦାଉଦାର୍‌ ହୟ୍‌ସି ! ଅଃମିମଃନ୍‌କେ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଆରେକ୍‌ ସେ ଗଃରେ ହୁର୍ଲାକେ ସେ କାଣା ମାନାୟ୍‌ମଃନ୍ ତାର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ଜେ ଇରି କଃରୁ ହାରିନ୍ଦ୍ ସେରି କାୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲାସ୍‌ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ହେଁ ମାପ୍ରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ସେତାକ୍‌ ଜିସୁ ସେମଃନାର୍‌ ଆକାୟ୍‌ ଚୁୟ୍‌କଃରି କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ବିସ୍ୱାସ୍‌ ହଃର୍କାରେ ତୁମିମଃନ୍‌କେ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ତଃବେ ସେମଃନାର୍‌ ଆକି ଡିସ୍‌ଲି । ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଜଃଗ୍ରାତ୍‌ କଃରାୟ୍‌ କୟ୍‌ଲା, “ଇ କଃତା, କେ ଜଃନ୍‌କଃରି ନଃଜାଣତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମଃତର୍‌ ସେମଃନ୍ ବାରାୟ୍‌ ଜାୟ୍‌ ସେ ଦେସ୍‌ ଜାକେ ତାର୍‌ କଃତା କୟ୍‌ ବୁଲ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ସେମଃନ୍ ବାରାୟ୍‌ ଜାତିରିଲା ବଃଳ୍‌, ଲକ୍‌ମଃନ୍ ଗୁଲା ବୁତ୍‌ ଡଃସିରିଲା ଲକ୍‌କେ ଜିସୁର୍‌ ଚଃମେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଆରେକ୍‌ ବୁତ୍‌ ଚାଡାୟ୍‌ଲାକ୍‌ ସେ ଗୁଲା କଃତା ଅଃଉଁକେ ଦଃର୍ଲା । ସେତାକ୍‌ ଲକ୍‌ମଃନ୍‌ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ଇରଃକମ୍‌ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ତାର୍‌ ଅଃମି କଃବେ ହେଁ ନଃଦେକୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମଃତର୍‌ ପାରୁସିମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, “ସେ ବୁତ୍‌ମଃନାର୍‌ ମୁଳିକାକ୍‌ ଦଃରି ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଇତାର୍‌ହଃଚେ ଜିସୁ ସଃବୁ ଗଃଳେ, ଆରେକ୍‌ ଗାଉଁମଃନ୍‌କେ ବୁଲୁକ୍‌ ଦଃର୍ଲା । ଆର୍‌ ସେମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ସିକ୍ୟାଦଃୟ୍‌ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରି ସଃବୁ ରଃକମାର୍‌ ରଗ୍ ଆର୍‌ ସଃବୁ ରଃକମାର୍‌ ମଃଳୁହଃଳ୍‌ଲାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ଜିସୁ ସେମଃନାର୍‌ ଗିନେ ଦଃୟା ଦଃକାୟ୍‌ଲା, ବଃଲେକ୍‌ ସେମଃନ୍ ଗଃଉଳିଆ ନୟ୍‌ଲା ମେଣ୍ଡାମଃନ୍ ସଃହା ନୟ୍‌ଲା ହର୍‌ କଃସ୍ଟ୍‌ ହାୟ୍‌ ଏଣେ ତେଣେ ଜଃତ୍‌କଃତ୍‌ ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ସଃଡେବଃଳ୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ତାସ୍‌ ସିନା ଜଃବର୍‌, ହାୟ୍‌ଟି କଃର୍ତା ଲକ୍‌ ଉଣା । ");
INSERT INTO bdv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ଇତାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ତାସ୍‌ ହଃଦାୟ୍‌ ହାୟ୍‌ଟି କଃର୍ତା ଲକ୍‌କେ ହଃଟାଉଁକେ, ତାସ୍‌ହଃଦାର୍‌ ସାଉକାର୍‌କେ ଗଃଉଆରି କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ଚଃମେ କୁଦି ସେମଃନ୍‌କେ ବିଟାଳ୍‌ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁକେ ସେମଃନାର୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦିଲା; ଆର୍‌ ସଃବୁ ରଃକମାର୍‌ ରଗ୍ ଆର୍‌ ଦୁକା ଉଜ୍‌ କଃରୁକେ ଅଃଦିକାର୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ସେ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ନାଉଁ ଅଃଉଁଲି, ହଃର୍ତୁ ସିମନ୍, ଜାକେ ପିତର୍‌ ବଃଲି କଃଉତି ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅ; ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଜହନ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ୍, ବାର୍ତଲମି; ତମା ଆର୍‌ ମାତିଉ ରିବ୍‌ନି; ଆଲ୍‌ପିଅର୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌; ଆର୍‌ ତଦିୟ; ");
INSERT INTO bdv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିଣାନିୟ ସିମନ୍, ଜେ କି ଇସ୍ରାଏଲ୍‌ମଃନ୍‌କେ ମୁକ୍‌ଳାଉଁକେ ମଃନ୍ କଃର୍ତିରିଲା, ଆର୍‌ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା, ଜେ ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଲା, “ଅଜିଉଦିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଟାଣେ ଜାହାନାୟ୍‌, ସମିରଣିୟମଃନାର୍‌ କୁୟ୍‌ ଗଃଳେ ହୁରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମଃତର୍‌ ଇସ୍ରାଏଲ୍‌ ବଃଉଁସାର୍‌ ଆଜ୍‌ଲା ମେଣ୍ଡାହର୍‌ ଲକ୍‌ମଃନାର୍‌ ହାକ୍‌ ଜାହା । ");
INSERT INTO bdv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଆର୍‌ ଜଃଉଁ ଜଃଉଁ, ‘ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଚଃମେ ଅୟ୍‌ଲିନି !’ ବଃଲି ପର୍ଚାର୍‌ କଃରା ! ");
INSERT INTO bdv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ମଃଳୁହଃଳ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃରା, ମଃଲା ଲକ୍‌କେ ଉଟାଉଆ, ବଃଡ୍‌ ରଗିମଃନ୍‌କେ ଉଜ୍‌ କଃରା, ବୁତ୍‌ମଃନ୍‌କେ ବାର୍‌କଃରା ତୁମିମଃନ୍ ତଃନେ ହାୟ୍‌ ଆଚାସ୍‌, ତଃନେ ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ତୁମିମଃନ୍‌ ବେସ୍‌ଣି ଲଃଗେ ଟଃକା, ସନା, କି ରୁହା ନିଆନାଁୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଆର୍‌ ଜାତାବଃଳ୍‌ ମଣା କି ଜଳେକ୍‌ ଆଙ୍ଗି କି ହାଣ୍ଡାୟ୍‌ କି ଡାଙ୍ଗ୍ ନିଆନାଁୟ୍‌ । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହାୟ୍‌ଟି କଃର୍ତାଲକ୍‌ ତାର୍‌ ଜାୟ୍‌ରି ହାଉତା କଃତା, ସେରି ସେ ହାଉଁକ୍‌ ଜୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଆର୍‌ ତୁମିମଃନ୍ କୁୟ୍‌ ଗାଉଁଏ କି ଗଃଳେ ହୁରାସ୍‌, ସେତି କେ ତୁମିକେ ଗଃରେ କୁଦି ଦଃରୁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ସେରି ଆନ୍‌ମାନ୍‌ କଃରା, ଆରେକ୍‌ ନଃବାଉଳ୍‌ତା ହଃତେକ୍‌ ସେତି ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଜଃଡେବଃଳ୍‌ ଗଟ୍‌ ଗଃରେ ହୁରାସ୍‌, ସେତି ରେତା ଲକ୍‌ମଃନ୍‌କେ କଃଉଆ, ‘ତୁମିମଃନାର୍‌ ସୁସ୍ତା ଅଃଉଅ !’ ");
INSERT INTO bdv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଜଦି ସେ ଗଃରାର୍‌ ମାନାୟ୍‌ ତୁମିକେ ରେଉଁକ୍‌ ଦଃୟଃଦ୍‌, ସେ ସୁସ୍ତା ତାର୍‌ ଉହ୍ରେ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜଦି ସେ ତାର୍‌ ଗଃରେ ରେଉଁକ୍‌ ନଃଦେରେ, ତଃବେ ସେ ସୁସ୍ତା ତୁମାର୍‌ ଉହ୍ରେ ଲେଉଟି ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଜୁୟ୍‌ ଲକ୍‌ ତୁମିମଃନ୍‌କେ ଗଃଳେ କି ଗଃରେ ନଃକୁଦେ ଆର୍‌ ତୁମାର୍‌ କଃତା ନଃସୁଣେ, ତଃବେ ସେତିହୁଣି ବାରାୟ୍‌ ଜାତା ବଃଳ୍‌ ତୁମି ତାକ୍‌ ଚାଡ୍‌ଲାସ୍‌ ବଃଲି ଚିନ୍ ହର୍‌ ତୁମାର୍‌ ହାଦାର୍‌ ଦୁଳି ହାହଳି ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ବିଚାର୍‌ ଦିନ୍ ଇମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ସଦମ୍‌ ଆର୍‌ ଗମ୍‌ରା ଗଃଳାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଇସ୍ୱର୍‌ ଅଃଦିକ୍‌ ଦଃୟା କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ଦଃକା ବାଗ୍‌ମଃନାର୍‌ ମଃନ୍ଦାୟ୍‌ ମେଣ୍ଡାମଃନାର୍‌ ହର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ହଃଟାଉଁଲେ; ସାହ୍‌ ହର୍‌ ବୁଦିଆ ଆର୍‌ ହାଣ୍ଡ୍‌କା ହର୍‌ ନିର୍ମାୟା ଅଃଉଆ । ");
INSERT INTO bdv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ମଃତର୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଗ୍ରାତ୍‌ ଅଃଉଆ, ବଃଲେକ୍‌ ବେରାଣ୍ ମେଣ୍ଡାୟ୍‌ ହଃଚାଦି କଃରୁକେ ସଃହ୍ରି ଦେତି ଆର୍‌ ସେମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ସାଟ୍‍ଣି ସଃଙ୍ଗ୍ ମାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଆର୍‌ ତୁମିମଃନ୍‌କେ ମର୍‌ ଗିନେ ସଃର୍କାର୍‌ ଅଃଦିକାରି ଆର୍‌ ରଃଜାମଃନାର୍‌ ହାକ୍‌ ନେତି, ସେରି ସେମଃନାର୍‌ ଆର୍‌ ଅଜିଉଦି ଲକାର୍‌ ତଃୟ୍‌ ସାକି ହର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ତୁମିକେ ସଃହ୍ରି ଦେତି ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ କଃନ୍‌କଃରି କାୟ୍‌ କଃତା କଃଉଆସ୍‌; ସେତାର୍‌ ଗିନେ ଚିତା କଃରାନାୟ୍‌, ବଃଲେକ୍‌ କାୟ୍‌ରି କଃଉଆସ୍‌ ସେରି ସେଦାହ୍ରେ ତୁମିମଃନ୍‌କେ ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ କଃଉତା ଲକ୍‌ ନାୟ୍‌; ମଃତର୍‌ ତୁମାର୍‌ ଉବାଦିର୍‌ ପବିତ୍ର ଆତ୍ମା ତୁମାର୍‌ ମଃନ୍ ବିତ୍ରେ ରଃୟ୍‌ କଃତା କୟ୍‌ଦ୍‌, ସେ ହଃକା କଃତା କଃଉତା ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ବାୟ୍‌ ବାୟ୍‌କ୍‌, ଉବାସି ହୟ୍‌ସିକେ, ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ସଃହ୍ରି ଦେତି, ଆରେକ୍‌ ହିଲାମଃନ୍ ଉବାସି ଆୟ୍‌ସି ବିରଦେ ଉଟ୍‌ତି ଆର୍‌ ସେମଃନ୍‌କେ ମଃର୍ନେ ମାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ଆର୍‌ ମର୍‌ ନାଉଁ ଗିନେ ତୁମିମଃନ୍ ସଃବୁଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବିରଦ୍‌ କଃର୍ତି, ମଃତର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ସେସ୍‌ ହଃତେକ୍‌ ବିସ୍ୱାସେ ତିର୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌, ସେ ହାହେ ହୁଣି ମୁକ୍ଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ମଃତର୍‌ ସେମଃନ୍ ତୁମିକେ ଗଟ୍‌ ଗଃଳେ କଃସ୍ଟ୍‌ ଦେତି, ସଃଡେବଃଳ୍‌ ଆରେକ୍‌ ଗଟ୍‌ ଗଃଳେ ହଃଳାୟ୍‌ ଜାହା, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଇସ୍ରାଏଲ୍‌ ଦେସାର୍‌ ସଃବୁ ଗଃଳେ ବୁଲି ନଃସେରାଉତା ଆଗ୍‌ତୁ ନଃରାର୍‌ ହୟ୍‌ସି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଚେଲା ଗୁରୁ ତଃୟ୍‌ହୁଣି ଆର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ସାଉକାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଚେଲା ଅଃହ୍‌ଣାର୍‌ ଗୁରୁ ଆର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଅଃହ୍‌ଣାର୍‌ ସାଉକାର୍‌ ହର୍‌ ଅୟ୍‌ଲେକ୍‌ ସେମଃନାର୍‌ ଗିନେ ସଃତେକ୍‌ ସଃରି । ସେମଃନ୍ ଜଃଡେବଃଳ୍‌ ଗଃରାର୍‌ ମୁଳିକାକ୍‌ ବାଲ୍‌ଜିବୁଲ୍‌ ବଃଲି କଃଉଁଲାୟ୍‌, ତଃବେ ତାକାର୍‌ ଗଃରାର୍‌ କୁଟୁମ୍‌କେ ଅଃଦିକ୍‌ କଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ବଃଲେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଡିରା ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାୟ୍‌ରି ଜାଣା ନଃହେଳେ ଅଃନ୍‌କାର୍‌ ଡାହିଅୟ୍‌ ଲୁକି ରିଲାର୍‌ କାୟ୍‌ରି ନାୟ୍‌, ଆର୍‌ ଜାୟ୍‌ରି ଜାଣା ନଃହେଳେ ଅଃନ୍‌କାର୍‌ କାୟ୍‌ରି ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜାୟ୍‌ରି ଅଃନ୍ଦାରେ କଃଉଁଲେ ସେରି ଉଜାଳେ କଃଉଆ, ଆରେକ୍‌ ଜାୟ୍‌ରି ତୁମିମଃନ୍ ଲୁକ୍‌ଣେ ସୁଣାସ୍‌ ସେରି ଗଃରାର୍‌ ଚାନି ଉହ୍ରେ ହୁଣି ପର୍ଚାର୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମାର୍‌ ଗଃଗାଳ୍‌କେ ନଃସ୍ଟ୍‌ କଃର୍ତି ମଃତର୍‌ ତୁମାର୍‌ ଜିବନ୍‌ ନଃସ୍ଟ୍‌ କଃରୁ ନଃହାର୍‌ତି, ସେମଃନ୍‌କେ ଡିରି ଜାହାନାୟ୍‌, ମଃତର୍‌ ଜେ ତୁମାର୍‌ ଗଃଗାଳ୍‌ ଆର୍‌ ଆତ୍ମାକେ ନଃର୍କେ ନଃସ୍ଟ୍‌ କଃରୁ ହାରେ, ତାକ୍‌ ହଃକା ଡିରା । ");
INSERT INTO bdv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଜଳେକ୍‌ ଜଃଟ୍ୟାଚେଳେ କାୟ୍‌ ଗଟେକ୍‌ କାସୁ ଡାବୁୟ୍‌ ବିକା ନଃଉତି ? ଆର୍‌ ତୁମିମଃନାର୍‌ ଉବାଦିର୍‌ ଆଦେସ୍‌ ନୟ୍‌ଲେକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ହେଁ ବୁଏଁ ନଦ୍ରେ । ");
INSERT INTO bdv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ମଃତର୍‌ ଇସ୍ୱର୍‌ ତୁମାର୍‌ ମୁଣ୍ଡାର୍‌ ସଃର୍ନେ ବାଳ୍‌ ଗଃଣି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଇତାକ୍‌ ଡିରି ଜାହାନାୟ୍‌, ତୁମିମଃନ୍ ଗାଦେକ୍‌ ଜଃଟ୍ୟା ଚେଳେ ହୁଣି ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ମକ୍‌ ଜାଣି ବଃଲି କୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ହେଁ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ତଃୟ୍‌ ତାକ୍‌ ଜାଣି ବଃଲି କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି କୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ହେଁ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ତଃୟ୍‌ ତାକ୍‌ ନଃଜାଣି ବଃଲି କୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ମୁଁୟ୍‌ ହୁର୍ତିବିଏ ସୁସ୍ତା ଦେଉଁକେ ଆସି ଆଚି ବଃଲି ମଃନେ ବାବା ନାୟ୍‌; ସୁସ୍ତା ଦେଉଁକେ ନାସି, ମଃତର୍‌ କଃଣ୍ଡା ଦେଉଁକେ ଆସି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଉବାସି ସଃଙ୍ଗ୍ ହୟ୍‌ସି ଆର୍‌ ଆୟ୍‌ସି ସଃଙ୍ଗ୍ ଜିସିର୍‌ ଆର୍‌ ସଃତୁର୍ସି ସଃଙ୍ଗ୍ ବୁଆର୍ସିର୍‌ ବିରଦି କଃରୁକେ ଆସିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଆର୍‌ ମାନାୟ୍‌ର୍‌ ଅଃହ୍‌ଣାର୍‌ କୁଟୁମାର୍‌ ଲକ୍‌ ହଃକା ତାର୍‌ ସଃତ୍ରୁ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଜୁୟ୍‌ ଲକ୍‌ ମକ୍‌ ଚାଡି ନିଜାର୍‌ ଆୟ୍‌ସି କି ଉବାସିକ୍‌ ଅଃଦିକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ସେ ମର୍‌ ଚେଲା ଅଃଉଁକେ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌; ଜୁୟ୍‌ ଲକ୍‌ ମକ୍‌ ଚାଡି ନିଜାର୍‌ ଜିସି ହୟ୍‌ସିମଃନ୍‌କେ ଅଃଦିକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ସେ ମର୍‌ ଚେଲା ଅଃଉଁକେ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଆର୍‌ ଜେ ଅଃହ୍‌ଣାର୍‌ କ୍ରୁସ୍‌ ଦଃରି ମର୍‌ ହଃଚେ ହଃଚେ ନାସେ, ସେ ମର୍‌ ଚେଲା ଅଃଉଁକେ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଜେ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ବାଚାୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌; ଆର୍‌ ଜେ ମର୍‌ ଗିନେ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ବାଚାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଜେ ତୁମିମଃନ୍‌କେ ଆଗଳି ଦଃରେଦ୍‌ ସେ ମକ୍‌ ଆଗଳି ଦଃରେଦ୍‌; ଆର୍‌ ଜେ ମକ୍‌ ଆଗଳି ଦଃରେଦ୍‌, ସେ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବାକ୍‌ ଆଗଳି ଦଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଜେ ବାବ୍‌ବାଦିକେ ବାବ୍‌ବାଦି ବଃଲି ଆଗଳି ଦଃରେଦ୍‌, ସେ ବାବ୍‌ବାଦିର୍‌ ପୁରିସ୍କାର୍‌ ହାୟ୍‌ଦ୍‌, ଆର୍‌ ଜେ ଦଃର୍ମ୍‌ ଲକ୍‌କେ, ଦଃର୍ମି ଲକ୍‌ ବଃଲି ଆଗଳି ଦଃରେଦ୍‌, ସେ ଦଃର୍ମ୍‌ ଲକାର୍‌ ନାଉଁଏ ପୁରିସ୍କାର୍‌ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଇ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଲକ୍‌କେ ମର୍‌ ଚେଲା ବଃଲି ଗିନେକ୍‌ କାକର୍‌ ହାଣି କାଉଁକେ ଦଃୟଃଦ୍‌, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସେ କଃନ୍‌କଃରି ହେଁ ଅଃହ୍‌ଣାର୍‌ ପୁରିସ୍କାର୍‌ ଆରାୟ୍‌ ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ବଃତାୟ୍‌ ସଃର୍ଲା ହଃଚେ, ଗାଲିଲିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗଃଳେମଃନ୍ ସିକ୍ୟା ଦେଉଁକେ ଆର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ସେଟାଣେ ହୁଣି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ସଃଡେବଃଳ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ଜଃଇଲ୍‌ ଗଃରେ ରିଲା । ଆର୍‌ କ୍ରିସ୍ଟ ଜୁୟ୍‌ ସଃବୁ କାମ୍‌ କଃର୍ତିରିଲା ସେ ସଃବୁର୍‌ କବୁର୍‌ ହାୟ୍‌, ସେ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ତାର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ସେମଃନ୍ ଜାୟ୍‌ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଜୁୟ୍‌ ଲକ୍‌ ଆସେଦ୍‌ ବଃଲି ଜହନ୍‌ କୟ୍‌ରିଲା, ତୁୟ୍‌ କାୟ୍‌ ସେ ମାନାୟ୍‌ ? କି, ଅଃମିମଃନ୍‌ ଆରେକ୍‌ ବିନ୍ କାକେ ଜାଗୁନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ବାଉଳି ଜାହା ଆର୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣୁଲାସ୍‌ ଆର୍‌ ଦଃକୁଲାସ୍‌ ସେରି ସଃବୁ ଜହନ୍‌କେ ଜାଣାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାଣାମଃନ୍ ଦଃକୁ ହାରୁଲାୟ୍‌, ଚଟାମଃନ୍ ଇଣ୍ଡୁ ହାରୁଲାୟ୍‌, ବଃଡ୍‌ ରଗି ଉଜ୍‌ ଅଃଉଁଲାୟ୍‌, ବଃୟ୍‌ରାମଃନ୍ ସୁଣୁ ହାରୁଲାୟ୍‌, ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟୁଲାୟ୍‌ ଆର୍‌ ଦୁକିଦିନାରି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ହେଁ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରା ଅଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଆର୍‌ ଜେ ମକ୍‌ ଅବିସ୍ୱାସ୍‌ ନଃକେରି, ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ତାର୍‌ ବାୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଜହନାର୍‌ ଚେଲାମଃନ୍ ବାଉଳି ଜାତାବଃଳ୍‌ ଜିସୁ ଜହନାର୍‌ କଃତା ଲକ୍‌ମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “ତୁମି କାୟ୍‌ରି ଦଃକୁକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଜାୟ୍‌ ରିଲାସ୍‌, କାୟ୍‌ ବାଉୟେ ଜଲ୍‌ତା ସୁର୍ଲିନଃଳା ? ");
INSERT INTO bdv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ସେରି ନୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ରି ଦଃକୁକେ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାସ୍‌ ? କାୟ୍‌ ମଃସ୍‌ଣି ବଃସ୍ତର୍‌ ହିନ୍ଦି ରିଲା ମାନାୟ୍‌କେ ? ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମଃସ୍‌ଣି ବଃସ୍ତର୍‌ ହିନ୍ଦ୍‌ତି ସେମଃନ୍ ରଃଜାର୍‌ ନଃଉରେ ରେତି । ");
INSERT INTO bdv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ସେରି ନୟ୍‌ଲେକ୍‌ କାୟ୍‌କଃରୁକ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାସ୍‌ ? କାୟ୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦିକେ ଦଃକୁକେ ? ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ବାବ୍‌ବାଦି ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବଃଡ୍ ଲକ୍‌କେ ଦଃକ୍‌ଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଜୁୟ୍‌ ଜହନାର୍‌ କଃତା ସାସ୍ତରେ ଲେକାଆଚେ, ‘ଇସ୍ୱର୍‌ କୟ୍‌ଲା, ମୁଁୟ୍‌ ମର୍‌ କବୁର୍‌ କାରିଆକ୍‌ ତର୍‌ ଆଗ୍‌ତୁ ହଃଟାଉଁଲେ, ସେ ଆଗ୍‌ତୁ ଜାୟ୍‌ ତର୍‌ ଗିନେ ବାଟ ତିଆର୍‌ କଃରେଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମାୟ୍‌ଜି ହେଟେହୁଣି ଜଃଲମ୍‌ ଅୟ୍‌ଲା ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ କେ ନାୟ୍‌ । ମଃତର୍‌ ଜେ ସଃର୍ଗ୍‌ ରାଇଜେ ସଃବ୍‌କେ ସାନ୍, ସେ ଜହନାର୍‌ ତଃୟ୍‌ହୁଣି ହେଁ ବଃଡ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଆର୍‌ ବାପ୍ତିସମ୍‌ ଦେଉ ଜହନ୍‌ ତାର୍‌ କଃତା ପର୍ଚାର୍‌ କଃଲା ବଃଳ୍‌ହୁଣି ଆଜି ହଃତେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଉହ୍ରେ ବଃଳ୍‌ମାଡ୍ ଅଃଉଁଲି, ଆରେକ୍‌ ଅଃଦିକାର୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍ ଜଃବର୍‌ ବଃଳ୍‌ବପୁ ସଃଙ୍ଗ୍ ଅଃଦିକାର୍‌ କଃରୁକେ ମଃନ୍ କଃରୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ବଃଲେକ୍‌ ସଃବୁ ବାବ୍‌ବାଦିମଃନ୍ ଆର୍‌ ମସାର୍‌ ବିଦି ଆର୍‌ ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ ଜହନ୍‌ ହଃତେକ୍‌ ବାବ୍‌ବାଣି କୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଆର୍‌ ତୁମିମଃନ୍ ଜଦି ମାନୁକ୍‌ ମଃନ୍ କଃରୁଲାସ୍‌, ତଃବେ ଜୁୟ୍‌ ଏଲିୟ ଆସୁକ୍‌ ଆଚେ, ଏ ହଃକା ସେ ମାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ମଃତର୍‌ ମୁଁୟ୍‌ କାର୍‌ ସଃଙ୍ଗ୍ ଆଜିକାଲିର୍‌ ମାନାୟ୍‌ର୍‌ ତୁଳ୍‌ନା କଃରିନ୍ଦ୍‌ ? ଜୁୟ୍‌ ହିଲାମଃନ୍‌ ଆଟ୍‌ ବଃଜାରେ ବଃସି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କୁଦି କଃଉତି, ");
INSERT INTO bdv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ଅଃମିମଃନ୍‌ ତୁମାର୍‌ ଚଃମେ ସୁର୍ଲି ହୁକ୍‌ଲୁ, ତୁମିମଃନ୍ ନଃନାଚ୍‌ଲାସ୍‌, ଅଃମିମଃନ୍‌ ଦୁକେ ଦୁକ୍‌ ଗିତ୍‌ କୟ୍‌ଲୁ, ତୁମିମଃନ୍ ନଃକାନ୍ଦ୍‌ଲାସ୍‌, ଇ ଜୁଗାର୍‌ ଲକ୍‌ମଃନ୍‌, ସେ ହିଲାମଃନାର୍‌ ହର୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜହନ୍‌ ଆସି ଉହାସ୍‌ କଃଲା, ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ନଃକାୟ୍‌ଲା, ଆର୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, ‘ତାକେ ବୁତ୍‌ ଦଃରି ଆଚେ !’ ");
INSERT INTO bdv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ନଃରାର୍‌ ହୟ୍‌ସି ଆୟ୍‌ଲା ଆର୍‌ କାଉଆ ହିଉଆ ଆୟ୍‌ଲା, ଆର୍‌ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, ‘ଦଃକା, ଏ ଗଟେକ୍‌ କାଉରାହେଟା ଆର୍‌ ମଃଦୁଆ, ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗୁଆଳି !’ ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଗ୍ୟାନ୍ ଅଃହ୍‌ଣାର୍‌ କାମ୍‌ ତଃୟ୍‌ ସଃତ୍‌ ବଃଲି ଜାଣାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଗଃଳେ ଜିସୁର୍‌ ଗାଦେକ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ କଃରା ଅୟ୍‌ରିଲି, ସେ ଗଃଳ୍‌ମଃନ୍‌କେ ଜିସୁ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ହାହ୍‌ ଚାଡି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ଚି, ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ କରାଜିନ୍, ଚି, ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ବେତ୍‌ସାଇଦା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଜୁୟ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ କଃରା ଅୟ୍‌ଆଚେ, ସେରିମଃନ୍ ସଃବୁ ସର୍‌ ଆର୍‌ ସିଦନ୍‌ ତଃୟ୍‌ଁ କଃରା ଅୟ୍‌ରିଲେକ୍‌, ସେମଃନ୍ କଃଡେବଃଳ୍‌ ହୁଣି ବାସ୍ତା ହିନ୍ଦି ଚାରେ ବଃସି ହାହ୍‌ ଚାଡି ରିଲାୟ୍‌ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ଅୟ୍‌ଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଇସ୍ୱର୍‌ ବିଚାର୍‌ କଃର୍ତା ଦିନ୍ ସର୍‌ ଆର୍‌ ସିଦନ୍‌ ତଃୟ୍‌ର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଅଃଦିକ୍‌ ଦଃୟା ଦଃକାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଏ କପୁର୍ନାହୁମ୍‌ ତଃୟ୍‌ର୍‌ ଲକ୍‌ମଃନ୍, ତୁମି କାୟ୍‌ ନିଜେ ସଃର୍ଗେ ହଃତେକ୍‌ ଉଟୁକ୍‌ ମଃନ୍ କଃରୁଲାସ୍‌ ? ତୁମିକେ ନଃର୍କେ ହଃକା ଅୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ତଃୟ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ କଃରା ଅୟ୍‌ଆଚେ, ସେରି ସଃବୁ ଜଦି ସଦମ୍‌ ତଃୟ୍‌ କଃରା ଅୟ୍‌ରିଲେକ୍‌, ସେରି ଆଜି ହଃତେକ୍‌ ରିଲିହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇସ୍ୱର୍‌ ବିଚାର୍‌ କଃର୍ତା ଦିନ୍ ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି ସଦମ୍‌ ଦେସାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଅଃଦିକ୍‌ ଦଃୟା ଦଃକାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ସଃଡେବଃଳ୍‌ ଜିସୁ ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଏ ଉବା, ସଃର୍ଗ୍‌ ଆର୍‌ ହୁର୍ତିବିର୍‌ ମାପ୍ରୁ, ତୁୟ୍‌ ବୁଦି ଆର୍‌ ଗ୍ୟାନ୍ ରିଲା ଲକ୍‌ମଃନ୍‌କେ ଇ ସଃବୁ କଃତା ଲୁକାୟ୍‌କଃରି ବୁଦି ନୟ୍‌ଲା ଲକ୍‌କେ ଜାଣାୟ୍‌ଲିସ୍‌, ସେତାର୍‌ ଗିନେ ତକେ ଜୁଆର୍‌ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ଅୟ୍‌ ଉବା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇରି ତର୍‌ ଆକାୟ୍‌ ମଃନ୍ ସଃର୍ଦାର୍‌ କଃତା ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ମର୍‌ ଉବାର୍‌ ଅଃଦିକାରେ ରିଲା ସଃବୁ ଅଃଦିକାର୍‌ ମକ୍‌ ଦିଆ ଅୟ୍‌ଆଚେ, ଆର୍‌ ହୟ୍‌ସିକେ କେ ନଃଜାଣ୍‌ତି, ମଃତର୍‌ ଉବାସି ହଃକା ଜାଣିଆଚେ, ଆରେକ୍‌ ଉବାକ୍‌ କେ ନଃଜାଣ୍‌ତି, ମଃତର୍‌ ହଅ ହଃକା ଜାଣିଆଚେ, ଆର୍‌ ହଅ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ଉବାକ୍‌ ଜାଣାଉଁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ସେମଃନ୍ ହଃକା ଜାଣ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ ତାକ୍‌ଲା ଆର୍‌ ବଜ୍‌ ବୟ୍‌ଲା ଲକ୍‌ମଃନ୍, ମର୍‌ ତଃୟ୍‌ ଆସା, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ବିସାଉଁକ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ମର୍‌ ଜିଅଡି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କଃନ୍ଦେ ବଃଉଆ, ଆର୍‌ ମର୍‌ ତଃୟ୍‌ହୁଣି ସିକା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ନିଜେ ଦିର୍‌ ଆର୍‌ ମଃନ୍‌ ସୁଦାର୍‌ ଅୟ୍‌ ଆଚି, ସେତାକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ତଃୟ୍‌ ଜିବନ୍‌ ବିତ୍ରେ ବିସାଉଁ ହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଆରେକ୍‌ ମୁଁୟ୍‌ ଜୁୟ୍‌ ଜିଅଡି ଦଃୟ୍‌ନ୍ଦ୍ ସେରି ବଃଉଁକେ ନିକ ଆର୍‌ ଉହାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ସଃଡେବଃଳ୍‌ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ତାସ୍‌ ହଃଦାବାଟ୍‌ ଅୟ୍‌ ଗଃଳାୟ୍‌, ସଃଡେବଃଳ୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ବୁକାର୍‌ ଗିନେ ଗଅଁ କେଡ୍ ଚିଡାୟ୍‌ କାଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ମଃତର୍‌ ସେରି ଦଃକି ପାରୁସିମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଦଃକ୍‌, ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜାୟ୍‌ରି କଃର୍ତା ବିଦି ନାୟ୍‌, ସେରି ତର୍‌ ଚେଲାମଃନ୍ କଃରୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦାଉଦ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍ ବୁକାର୍‌ ଗିନେ କାୟ୍‌ କଃରି ରିଲାୟ୍‌, ସେରି କାୟ୍‌ ତୁମିମଃନ୍ ନଃହଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ସେମଃନ୍ କଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଗଃରେ ହୁରି ଜୁୟ୍‌ ରୁଟି ମାପ୍ରୁର୍‌ ତଃୟ୍‌ ଦିଆ ଅୟ୍‌ରିଲି, ମସାର୍‌ ବିଦି ହଃର୍କାରେ ସେ ରୁଟି ଜାଜକ୍‌ମଃନ୍‌କେ ଚାଡି ବିନ୍ ଲକ୍‌ମଃନାର୍‌ କାଉଁକେ କାର୍‌ ଅଃଦିକାର୍‌ ନଃରିଲି, ସେରି କାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ଆର୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜାଜକ୍‌ମଃନ୍ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି ବିସାଉଁଣି ଦିନାର୍‌ ବିଟାଳ୍‌ କଃଲେକ୍‌ ହେଁ ଦସି ବଃଲାୟ୍‌ ନଃଉତି, ମସାର୍‌ ବିଦି ସାସ୍ତରେ ଇରି କାୟ୍‌ ତୁମିମଃନ୍ ନଃହଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିକେ କଃଉଁଲେ, ଇତି ମନ୍ଦିର୍‌ ତଃୟ୍‌ହୁଣି ଗଟେକ୍‌ ବଃଡ୍ ଲକ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ଅଃମି ହୁଜା ମଃନ୍ ନଃକେରୁ, ମଃତର୍‌ ଦଃୟା ମଃନ୍ କଃରୁନ୍ଦ୍‌ ।’ ଇ କଃତାର୍‌ ବାବ୍‌ ତୁମି ଜାଣି ରିଲେକ୍‌, ଇ ଦଃସ୍‌ ନୟ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଦସି ନଃକେଲାସ୍‌ ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ନିଜେ ବିସାଉଁଣି ବାରାର୍‌ ମାପ୍ରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ସେଟାଣେ ହୁଣି ଜାୟ୍‌ ସେମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃର୍‌ ବିତ୍ରେ ହୁର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ସେତି ଗଟ୍‌ ଲକ୍‌ ରିଲା, ତାର୍‌ ଗଟେକ୍‌ ଆତ୍‌ ସୁକିଜାୟ୍‌ରିଲି । ଆରେକ୍‌ ଜିସୁର୍‌ ବିରଦେ ଦଃସ୍‌ ଦଃରୁକ୍‌ କଃତେକ୍‌ ଲକ୍‌ ଜାଗି ରିଲାୟ୍‌, ସେତାର୍‌ ଗିନେ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଉଜ୍‌ କଃର୍ତାର୍‌ କାୟ୍‌ ମସାର୍‌ ବିଦି ବିରଦ୍‌ ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଦି ତୁମିମଃନାର୍‌ ବିତ୍ରେ କାର୍‌ ଗଟେକ୍‌ ମେଣ୍ଡା ବିସାଉଁଣିବାର୍‌ ଦିନ୍ କାଲ୍‌ ବିତ୍ରେ ଅଦ୍ରେଦ୍‌, ତଃବେ ତାକ୍‌ କାୟ୍‌ ଉଟାୟ୍‌ ନାଣାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ତଃବେ ମେଣ୍ଡା ତଃୟ୍‌ହୁଣି ମାନାୟ୍‌ କଃତେକ୍‌ ବଃଡ୍, ମସାର୍‌ ବିଦି ହଃର୍କାରେ “ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ବିନ୍ ଲକେ ଉହ୍‌କାର୍‌ କଃର୍ତା ବିଦି ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ତାର୍‌ହଃଚେ ଜିସୁ ସେମାନାୟ୍‌କେ କୟ୍‌ଲା, “ତର୍‌ ଆତ୍‌ ଲାମାଉ ।” ସେ ଆତ୍‌ ଲାମାୟ୍‌ଲାକେ ତାର୍‌ ବିନ୍ ଆତ୍‌ ହର୍‌ ଆରେକ୍‌ ନିକ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ସେତାର୍‌ଗିନେ ପାରୁସିମଃନ୍ ବାରାୟ୍‌ ଜାୟ୍‌ କଃନ୍‌କଃରି ତାକେ ମଃର୍ନେ ମାରୁଆଁ ବଃଲି କୁଟ୍‌ ହାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ଜିସୁ ତାକ୍‌ ମାରୁକ୍‌ କୁଟ୍‌ ହାଚୁଲାୟ୍‌ ବଃଲି ଜାଣି ସେତି ହୁଣି ଅଃଲ୍‌ଗା ଅୟ୍‌ ବାରାୟ୍‌ ଗଃଲା । ଆରେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌, ଆର୍‌ ସେ ସଃବୁ ରଗିମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଆର୍‌ ତାର୍‌ କଃତା କାକେ ନଃକଃଉଁକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ବାବ୍‌ବାଦି ଜିସାୟ୍‌ର୍‌ ତଃୟ୍‌ହୁଣି ଇସ୍ୱର୍‌ ଜୁୟ୍‌ କଃତା କୟ୍‌ରିଲା ସେରି ହୁରୁଣ୍ ଅଃଉଁକେ ସେ ଇରି କଃଲା; ");
INSERT INTO bdv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଅଃମାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା, ଜାକେ ଅଃମି ବାଚି ଆଚୁ, ସେ ଅଃମାର୍‌ ଆତ୍ମାର୍‌ ବଃଡେ ଲାଡାର୍‌, ତାର୍‌ ଉହ୍ରେ ଅଃମାର୍‌ ବଃଡେ ସଃନ୍‌ମତ୍‌; ମର୍‌ ଜିବନ୍‌ ତାର୍‌ ଉହ୍ରେ ଆସେଦ୍‌, ଆର୍‌ ସେ ଅଜିଉଦି ସଃବୁ ଦେସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ମର୍‌ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ପର୍ଚାର୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ସେ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ନଃକେରେ କି ରାଟୁ ନଃକେରେ, କି ସାୟ୍‌ ମଃଜାୟ୍‌ ଟିଆ ନୟ୍‌, ଆର୍‌ ବଃଡ୍ ଟଣ୍ଡ୍‌କଃରି ପର୍ଚାର୍‌ ନଃକେରେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ସେ ସୁର୍ଲିଡାଙ୍ଗ୍ ନଃବାଙ୍ଗେ ଆର୍‌ ସେ ଦୁଆଁ ଅଃଉତା ସଃଳିତା ନଃଲିବାୟ୍‌ । ସେ ସଃହା ନୟ୍‌ଲା ଆର୍‌ ନିଗାଳ୍‌ ଲକ୍‌ମଃନାର୍‌ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ନଃଉତା ହଃତେକ୍‌, ତାର୍‌ କାମେ ହୁଣି ତୁନ୍‌ ନଃହାଳେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଆର୍‌ ତାର୍‌ ନାଉଁଏ ଅଜିଉଦି ସଃବୁ ଲକ୍‌ମଃନ୍ ଆସା କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ସଃଡେବଃଳ୍‌ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ କାଣା ଆର୍‌ ଗୁଲା ମାନାୟ୍‌କେ ଜିସୁର୍‌ ହାକ୍‌ ଆଣ୍‌ଲାୟ୍‌; ଆର୍‌ ଜିସୁ ତାକ୍‌ ଉଜ୍‌ କଃଲା, ତଃତ୍‌କାଣ୍ ସେ କଃତା କଃଉ ହାର୍ଲା ଆର୍‌ ଦଃକୁ ହାର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ସେରି ଦଃକି ସଃବୁ ଲକ୍‌ମଃନ୍‌ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ କାୟ୍‌ ସେ ଦାଉଦାର୍‌ ହୟ୍‌ସି ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ମଃତର୍‌ ପାରୁସିମଃନ୍‌ ସେରି ସୁଣି କୟ୍‌ଲାୟ୍‌, “ଇ ଲକ୍‌ ବୁତ୍‌ମଃନାର୍‌ ମୁଳିକା ବାଲ୍‌ଜିବୁଲ୍‌ ତଃୟ୍‌ହୁଣି ସଃକ୍ତି ହାୟ୍‌ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ମଃନାର୍‌ କଃତା ଜାଣି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ ରାଇଜ୍‌ ବାଗ୍ ବାଗ୍ ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟେଦ୍‌, ସେରି ନଃସ୍ଟ୍‌ ଅୟ୍‌ ଜାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଜୁୟ୍‌ ଗଃଳ୍‌ କି ଗଃର୍‌ ବାଗ୍ ବାଗ୍ ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟେଦ୍‌, ସେରି ତିର୍‌ ଅୟ୍‌ ରେଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆର୍‌ ସୟ୍‌ତାନ୍ ଜଦି ସୟ୍‌ତାନ୍‌କେ ଚାଡାୟ୍‌ଦ୍‌, ତଃବେ ସେ ବାଗ୍ ବାଗ୍ ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟ୍‌ଲିନି; ତଃବେ ସୟ୍‌ତାନାର୍‌ ରାଇଜ୍‌ କଃନ୍‌କଃରି ତିର୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ମୁଁୟ୍‌ ଜଦି ବାଲ୍‌ଜିବୁଲାର୍‌ ସଃକ୍ତିଏ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲେ, ତଃବେ ତୁମିମଃନାର୍‌ ଚେଲାମଃନ୍ କାର୍‌ ବଃଳେ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉତି, ତୁମାର୍‌ ଚେଲାମଃନାର୍‌ ଇ କାମାର୍‌ ଗିନେ ତୁମାର୍‌ ବିଚାର୍‌ ମିଚ୍ ବଃଲି ଜାଣା ହଃଳୁଲି । ");
INSERT INTO bdv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ମଃତର୍‌ ମୁଁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ଆତ୍ମାର୍‌ ବଃଳେ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲେ, ତଃବେ ତ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଆସି ହଚ୍‌ଲିବେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ଆରେକ୍‌ କେ ବଃଳ୍‌ବପୁ ଲକ୍‌କେ ନଃବାନ୍ଦ୍‌ଲେକ୍‌, କଃନ୍‌କଃରି ତାର୍‌ ଗଃରେ ହୁରିକଃରି ତାର୍‌ ଆସ୍ତିବାଡି ଜୁରି ନେଉଁ ହାରେ ? ତାକ୍‌ ହଃର୍ତୁ ବାନ୍ଦ୍‌ଲେକ୍‌ ସିନା ତାର୍‌ ଗଃର୍‌ ଜୁରି ନେଉଁ ହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଜେ ମର୍‌ ସଃଙ୍ଗାର୍‌ ନାୟ୍‌, ସେ ମର୍‌ ବିରଦି, ଆରେକ୍‌ ଜେ ମର୍‌ ସଃଙ୍ଗ୍ ନଃରୁଣ୍ଡାୟ୍‌, ସେ ଜଃତ୍‌କଃତ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ତଃବେ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ମାନାୟ୍‌ମଃନାର୍‌ ସଃର୍ନେ ହାହ୍‌ ଆର୍‌ ଲିନ୍ଦା କଃତା କେମା କଃରା ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ପବିତ୍ର ଆତ୍ମାର୍‌ ବିରଦେ ଲିନ୍ଦା କଃତା କୟ୍‌ଲେକ୍‌ କେମା କଃରାନୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଆର୍‌ ଜେ ନଃରାର୍‌ ହୟ୍‌ସି ବିରଦେ କଃତା କୟ୍‌ଦ୍‌ ତାକ୍‌ କେମା ଦିଆ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜେ ପବିତ୍ର ଆତ୍ମା ବିରଦେ କଃତା କୟ୍‌ଦ୍‌, ତାକ୍‌ ଇ ଜୁଗେ କି ସେ ଜୁଗେ କେମା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ଗଃଚ୍‌କେ ନିକ କଃଉଆ ଆର୍‌ ତାର୍‌ ହଃଳ୍‌କେ ନିକ କଃଉଆ, ନୟ୍‌ଲେକ୍‌ ଗଃଚ୍‌କେ କଃରା ବଃଲା ଆର୍‌ ତାର୍‌ ହଃଳ୍‌କେ ହେଁ କଃରାବ୍‌ ବଃଲା । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହଃଳ୍‌କେ ଦଃକି ଗଃଚ୍ ଚିନା ହଃଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ରେ ନାଗ୍ ସାହ୍‌ ଆର୍‌ ତାର୍‌ ବଃଉଁସ୍‌ମଃନ୍, ତୁମିମଃନ୍ ଦୁସ୍ଟ୍‌ ଅୟ୍‌କଃରି କଃନ୍‌କଃରି ସଃତ୍‌ କଃତା କଃଉ ହାରାସ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ଜାୟ୍‌ରି ରଃୟ୍‌ଦ୍‌, ସେରି ଟଣ୍ଡ୍ କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ସଃତ୍‌ ମାନାୟ୍‌ ନିଜାର୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ରିଲା ନିକରି ବାର୍‌ କଃରେଦ୍‌; ଆର୍‌ ବାନ୍ୟା ଲକ୍‌ ଗଃର୍ବେ ହୁଣି ବାନ୍ୟାରି ବାର୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ମୁଁୟ୍‌ ତୁମିକେ କଃଉଁଲେ, ଲକ୍‌ମଃନ୍ ଜଃତେକ୍‌ ଅଃଳ୍‌ସିଆ ଲାବ୍‌ ନୟ୍‌ଲା କଃତା କଃଉତି, ବିଚାର୍‌ ଦିନ୍ ସେମଃନ୍ ସେତିର୍‌ ଉତୁର୍‌ ଦେତି । ");
INSERT INTO bdv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ଇତାକ୍‌ ତୁମାର୍‌ ଟଣ୍ଡାର୍‌ କଃତାକ୍‌ ଦଃରି ତୁମି ନିର୍ଦସି, ଆର୍‌ ତୁମାର୍‌ କଃତାକ୍‌ ଦଃରି ତୁମି ଦସି ବଃଲି ଜାଣା ହଃଳାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ସଃଡେବଃଳ୍‌ ସାସ୍ତ୍ରି ଆର୍‌ ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ କଃତି ଲକ୍‌ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ତର୍‌ ତଃୟ୍‌ହୁଣି ଗଟେକ୍‌ କାବା ଅଃଉତା ଚିନ୍ ଦଃକୁକେ ମଃନ୍ କଃରୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦୁସ୍ଟ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌କେ ବିସ୍ୱାସ୍‌ ନଃକେର୍ତା ଲକ୍‌ମଃନ୍ ଚିନ୍ ଲଳ୍‌ତି,” ମଃତର୍‌ ବାବ୍‌ବାଦି ଜୁନସାର୍‌ ଚିନ୍ ଚାଡି କାୟ୍‌ ଚିନ୍ ହେଁ ସେମଃନ୍‌କେ ଦିଆ ନୟେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁନସ୍‌ ଜଃନ୍‌କଃରି ତିନି ଦିନ୍ ଆର୍‌ ତିନି ରାତି ବଃଡ୍‌ ମାଚାର୍‌ ହେଟ୍‌ ବିତ୍ରେ ରିଲା, ସେନ୍‌କଃରି ନଃରାର୍‌ ହୟ୍‌ସି ତିନି ଦିନ୍ ତିନି ରାତି ମାଟି ବିତ୍ରେ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ଜୁୟ୍‌ ଦିନ୍ ଇସ୍ୱର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିଚାର୍‌ କଃରେଦ୍‌, ନିନିବିର୍‌ ଲକ୍‌ମଃନ୍ ତୁମାର୍‌ ବିରଦେ ଲିନ୍ଦା କଃରୁକେ ଉଟ୍‌ତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଜୁନସ୍‌ ପର୍ଚାର୍‌ କଃଲାକ୍‌ ହାହ୍‌ ଚାଡି ରିଲାୟ୍‌, ଆର୍‌ ଦଃକା, ଇତି ଜୁନସାର୍‌ ତଃୟ୍‌ହୁଣି ଗଟେକ୍‌ ବଃଡ୍ ଲକ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ଆର୍‌ ବିଚାର୍‌ ଦିନ୍ ସିବା ଦେସାର୍‌ ରାଣି ବିଚାରେ ଇ କାଳାର୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଉଟି ସେମଃନ୍‌କେ ଦସି କଃରେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ସଲ୍‌ମନାର୍‌ ଗ୍ୟାନାର୍‌ କଃତା ସୁଣୁକ୍‌ ହୁର୍ତିବି ସଃର୍ଲା କନେହୁଣି ଆସିରିଲି, ଆର୍‌ ଦଃକା, ଇତି ସଲ୍‌ମନାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ କଃତା ଇତି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ବିଟାଳ୍‌ ଆତ୍ମା ଗଟ୍‌ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଗଃଲା ହଃଚେ, ହାଣି ନୟ୍‌ଲା ଜଃଗା ସଃବୁ ବୁଲିକଃରି ବିସାଉଁକ୍‌ ଟାଣ୍ ଲଳେଦ୍‌, ଆର୍‌ ସେରି ମିଳାଉଁକ୍‌ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ସଃଡେବଃଳ୍‌ ସେ କୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ଜୁୟ୍‌ ଗଃରେହୁଣି ବାରାୟ୍‌ ଆସିରିଲେ, ମର୍‌ ସେ ଗଃରେ ଲେଉଟି ଜାୟ୍‌ନ୍ଦ୍ । ଆରେକ୍‌ ସେଗଃରେ ଆସି ସେରି ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ସୁନ୍ଦୁର୍‌ ଅୟ୍‌ରିଲାର୍‌ ଦଃକେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ସଃଡେବଃଳ୍‌ ସେ ଜାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ସାତ୍‌ଗଟ୍‌ ଦୁସ୍ଟ୍‌ ଆତ୍ମା ସଃଙ୍ଗେ ଦଃରି ଆସେଦ୍‌, ଆରେକ୍‌ ସେମଃନ୍ ସେ ଗଃରେ ହୁରି ସେତି ବାସା କଃର୍ତି; ଆର୍‌ ସେଲକାର୍‌ ହଃର୍ତୁ ଦଃସା ତଃୟ୍‌ହୁଣି ସେସ୍‌ ଦଃସା ଅଃଦିକ୍‌ କଃରାବ୍‌ ଅୟ୍‌ଦ୍‌, ଇ କାଳାର୍‌ ଦୁସ୍ଟ୍‌ ମାନାୟ୍‌ମଃନ୍ ଇରଃକମ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ଇ କଃତା କଃଉତା ବଃଳ୍‌, ତାର୍‌ ଆୟ୍‌ସି ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସିମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ଟଣ୍ଡ୍ ଅଃଉଁକେ ମଃନ୍‌କଃରି ହଃଦାୟ୍‌ ଟିଆ ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ସେତାକ୍‌ ଗଟ୍‌ଲକ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଦଃକ୍‌, ତର୍‌ ଆୟ୍‌ଦି ଆର୍‌ ବାୟ୍‌ଦିମଃନ୍ ତର୍‌ ସଃଙ୍ଗ୍ ଟଣ୍ଡ୍ ଅଃଉଁକେ ହଃଦାୟ୍‌ ଟିଆ ଅୟ୍‌ ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “କେ ମର୍‌ ଆୟା, ଆର୍‌ କୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ବାୟ୍‌ମଃନ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ସେ ଚେଲାମଃନାର୍‌ ବାଟ ଆତ୍‌ ଦଃକାୟ୍‌ କୟ୍‌ଲା, “ଏଦେ ଦଃକା, ଇ ଲକ୍‌ମଃନ୍‌ ମର୍‌ ଆୟା ଆର୍‌ ମର୍‌ ବାୟ୍‌ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ବଃଲେକ୍‌ ଜୁୟ୍‌ଲକ୍‌ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ଇଚା ହୁରୁଣ୍‌ କଃରେଦ୍‌, ସେ ମର୍‌ ବାୟ୍‌, ବେଣି ଆର୍‌ ଆୟା ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଜିସୁ ସେଦିନ୍ ଗଃରେହୁଣି ବାରାୟ୍‌ ଜାୟ୍‌ ସଃମଃନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ଗଃଲା ଆର୍‌ ସେତି ସିକ୍ୟା ଦେଉଁକେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ସେତାକ୍‌ ତାର୍‌ ଚଃମେ ଗାଦେକ୍‌ ଲକ୍‌ ଆସି ରୁଣ୍ଡ୍‌ଲାକ୍‌, ସେ ଜାୟ୍‌ ଗଟେକ୍‌ ଡଙ୍ଗାୟ୍‌ ବଃସ୍‌ଲା, ଆର୍‌ ଲକ୍‌ମଃନ୍ କଃଣ୍ଡାୟ୍‌ ଟିଆଅୟ୍‌ ତାର୍‌ ସିକ୍ୟା ସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ତାର୍‌ହଃଚେ ସେ କଃତେକ୍‌ କଃତାମଃନ୍‌ କୟ୍‌ ସେମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “ଦଃକା, ବୁଣ୍‌ତା ଗଟେକ୍‌ ମାନାୟ୍‌ ବିଆନ୍‌ ବୁଣୁକ୍‌ ବାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ବିଆନ୍ ବୁଣୁ ବୁଣୁ କଃତେକ୍‌ ବିଆନ୍ ବାଟେ ଅଦୁର୍ଲି, ଆର୍‌ ଚେଳେମଃନ୍ ଆସି ସେରିସଃବୁ ବେଟି କାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଆରେକ୍‌ କଃତେକ୍‌ ବିଆନ୍ ଅଃଳକ୍‌ ମାଟି ରିଲା ଚଃଚ୍ରା ବୁୟେଁ ଅଦୁର୍ଲି ଆର୍‌ ବୁତେକ୍‌ ମାଟି ନଃରିଲାକ୍‌ ବେଗି ଗଃଜା ଅୟ୍‌ଲି; ");
INSERT INTO bdv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମଃତର୍‌ ବେଳ୍‌ ଉଦ୍‌ଲାକ୍‌ ସେରିମଃନ୍ କଃରାକେ ହଡି କମ୍‌ଜି ଗଃଲି, ଆର୍‌ ତାର୍‌ ଚେର୍‌ ନଃରିଲାକ୍‌ ସୁକି ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଆର୍‌ କଃତେକ୍‌ ବିଆନ୍‌ କାଟା ବୁଟା ବିତ୍ରେ ଅଦୁର୍ଲି, ଆର୍‌ କାଟାବୁଟାମଃନ୍ ବାଡିକଃରି ସେସଃବୁକେ ଚାହି ହଃକାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମଃତର୍‌ ବିନ୍ କଃତେକ୍‌ ବିଆନ୍ ନିକ ମାଟାୟ୍‌ ଅଦୁର୍ଲି ଆର୍‌ ହଃଳ୍‌ ହଃଳ୍‌ଲି, କଃତେକ୍‌ ସଏ ଗୁଣ୍, କଃତେକ୍‌ ସାଟେ ଗୁଣ୍, ଆରେକ୍‌ କଃତେକ୍‌ ତିରିସ୍‌ ଗୁଣ୍ ଅଃଦିକ୍‌ ହଃଳ୍‌ ହଃଳ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜିସୁ ତାର୍‌ କଃତା ସଃରାୟ୍‌କଃରି କୟ୍‌ଲା, “ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଇତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆସି ହଃଚାର୍ଲାୟ୍‌, “ତୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ କାୟ୍‌ତାକ୍‌ କଃତାମଃନ୍‌ କୟ୍‌ ବୁଜାଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ବିତ୍ରି କଃତା ଜାଣୁକେ ତୁମିମଃନ୍‌କେ ବୁଦି ଦିଆଅୟ୍‌ ଆଚେ, ମଃତର୍‌ ସେମଃନ୍‌କେ ଦିଆ ନହୟେ । ");
INSERT INTO bdv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ତଃବେ ଜାର୍‌ ଆଚେ ତାକ୍‌ ଦିଆ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ତାର୍‌ ବୁତେକ୍‌ ଅୟ୍‌ଦ୍‌; ମଃତର୍‌ ଜାର୍‌ ନାୟ୍‌, ତାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌ରି ଆଚେ, ସେସଃବୁ ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ସେମଃନ୍ ଦଃକି ଦଃକି ନଃଦେକ୍‌ତି ଆର୍‌ ସୁଣୁ ସୁଣୁ ନଃସୁଣ୍‌ତି କି ନଃବୁଜ୍‌ତି; ଇତାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ମୁଁୟ୍‌ କଃତାମଃନ୍‌ କୟ୍‌ ବୁଜାଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଆର୍‌ ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ଇ ବାବ୍‌ବାଣି ସେମଃନାର୍‌ ଗିନେ ହୁରୁଣ୍ ଅୟ୍‌ଲି- ‘ଇ ଲକ୍‌ମଃନ୍ ସୁଣୁ ସୁଣୁ ସୁଣ୍‌ତି, ମଃତର୍‌ କଃନ୍‌କଃରି ହେଁ ବୁଜୁ ନଃହାର୍‌ତି; ଆରେକ୍‌ ଦଃକୁ ଦଃକୁ ଦଃକ୍‌ତି, ମଃତର୍‌ କଃନ୍‌କଃରି ହେଁ ଜାଣୁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ଲକ୍‌ମଃନାର୍‌ ମଃନ୍‌ ଅଃଟୁଆ ଅୟ୍‌ଲି, ସେମଃନ୍ କାନେ ବଃଡେ କଃସ୍ଟେ ସୁଣ୍‌ଲାୟ୍‌, ଆର୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଆକି ଲୁମ୍‌ଲାୟ୍‌ । ଜଃନ୍‌କଃରି ସେମଃନ୍ ଆକାୟ୍‌ ନଃଦେକ୍‌ତି, ଆର୍‌ କାନେ ନଃସୁଣ୍‌ତି, ଆର୍‌ ମଃନେ ନଃବୁଜ୍‌ତି, ଆର୍‌ ବାଉଳି ନାସ୍ତି, ଆର୍‌ ଅଃମି ସେମଃନ୍‌କେ ଉଜ୍‌ ନଃକେରୁ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ମଃତର୍‌ ବାୟ୍‌ଗ୍‌ ତୁମିମଃନାର୍‌ ଆକି, ଜଃନ୍ ସେରି ଦଃକେଦ୍‌, ବାୟ୍‌ଗ୍‌ ତୁମିମଃନାର୍‌ କାନ୍‌, ଜଃନ୍ ସେରି ସୁଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ଦଃକୁଲାସ୍‌, ସେରି ସଃବୁ କଃତେକ୍‌ ବାବ୍‌ବାଦି ଆର୍‌ ଦଃର୍ମି ଲକ୍‌ମଃନ୍ ଦଃକୁକେ ମଃନ୍ କଃଲାୟ୍‌, ମଃତର୍‌ ଦଃକୁକେ ନଃହାୟ୍‌ଲାୟ୍‌; ଆରେକ୍‌ ତୁମିମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣୁଲାସ୍‌, ସେରି ସଃବୁ ସେମଃନ୍ ସୁଣୁକ୍‌ ମଃନ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ନଃସୁଣ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ତଃବେ ତୁମିମଃନ୍ ବିଆନ୍ ବୁଣ୍‌ତା ଲକାର୍‌ କଃତାର୍‌ ବାବ୍‌ ସୁଣା, ");
INSERT INTO bdv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଜେ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ବଃଚନ୍ ସୁଣି ସେରି ନଃବୁଜେ, ସେ ବାଟ ଲଃଗେ ଅଦ୍ରି ରିଲା ବିଆନ୍ ହର୍‌, ସୟ୍‌ତାନ୍ ଆସି ତାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଜାୟ୍‌ରି ବୁଣା ଜାୟ୍‌ରିଲି, ଦୁସ୍ଟ୍‌ ସେରି ଚରି ନଃୟ୍‌ଦ୍‌ । ବାଟ ଲଃଗେ ଅଦ୍ରି ରିଲା ବିଆନାର୍‌ ବାବ୍‌ ଅଃଉଁଲି ଇରି । ");
INSERT INTO bdv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଜେ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ସୁଣ୍‌ଲା ଦାହ୍ରେ ସଃର୍ଦାୟ୍‌ ସେରି ମଃନେ ଦଃରେଦ୍‌, ସେ ଚଃଚ୍ରା ବୁୟେଁ ଅଦ୍ରି ରିଲା ବିଆନ୍ ହର୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ମଃତର୍‌ ସେମଃନାର୍‌ ଚେର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ନଃରିଲାକ୍‌, ସେମଃନ୍ ବୁତେକ୍‌ ଗଃଳି ଦଃରି ରେଉଁ ନଃହାର୍‌ତି, ହଃଚେ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ଗିନେ କାୟ୍‌ ଜଃଞ୍ଜାଳ୍‌ କି ଦୁକ୍‌ କଃସ୍ଟ୍‌ ଆୟ୍‌ଲେକ୍‌, ସେମଃନ୍ ସେଦାହ୍ରେ ସେରି ଚାଡିଦେତି । ");
INSERT INTO bdv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଜେ ବଃଚନ୍ ସୁଣେଦ୍‌, ମଃତର୍‌ ଜଃଗତାର୍‌ ଚିତା ଆର୍‌ ଦଃନାର୍‌ ଲଃବ୍‌ ତାକ୍‌ ଚାହି ହଃକାୟ୍‌ଦ୍‌, ସେ ଆର୍‌ ହଃଳ୍‌ ହଃଳୁ ନାହାରେ, ସେରି କାଟା ବୁଟାୟ୍‌ ଅଦ୍ରି ରିଲା ବିଆନ୍ ହର୍‌, ସେମଃନ୍ କାୟ୍‌ ହେଁ ତାସ୍‌ ନଃହାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ମଃତର୍‌ ଜେ ବଃଚନ୍ ସୁଣି ବୁଜେଦ୍‌, ସେ ନିକ ମାଟାୟ୍‌ ଅଦ୍ରି ରିଲା ବିଆନ୍ ହର୍‌, ସେମଃନ୍ ନିକ ତାସ୍‌ ଲାବ୍‌ କଃର୍ତି, କେ ସଏ ଗୁଣ୍ ଅଃଦିକ୍‌ ହାଉତି, କେ ସାଟେ ଗୁଣ୍ ଅଃଦିକ୍‌ ହାଉତି, ହିଁ ତିରିସ୍‌ ଗୁଣ୍ ଅଃଦିକ୍‌ ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ କଃତା କୟ୍‌ ସେମଃନ୍‌କେ ବୁଜାୟ୍‌ଲା, “ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଅଃନ୍‌କାର୍‌ ଗଟ୍‌ ମାନାୟ୍‌ହର୍‌, ସେ ଅଃହ୍‌ଣାର୍‌ ହଃଦାୟ୍‌ ନିକ ବିଆନ୍ ବୁଣି ରିଲା, ");
INSERT INTO bdv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ସୟ୍‌ରିଲା ବଃଳ୍‌, ତାର୍‌ ସଃତ୍ରୁ ଆସି ସେ ଗଅଁ ବିଆନ୍ ବିତ୍ରେ କଃଦଟଳା ମୁଞ୍ଜି ବୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ତାର୍‌ହଃଚେ ଜଃଡେବଃଳ୍‌ ମୁଞ୍ଜି ଗଃଜା ଅୟ୍‌ ହଃତାର୍‌ ବାରାୟ୍‌ ହଃଳ୍‌ ହଃଳୁକ୍‌ ଦଃର୍ଲି, ସଃଡେବଃଳ୍‌ କଃଦଟଳା ହେଁ ଡିସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ସେତାକ୍‌ ଗଃରାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ ଆସି ସାଉକାର୍‌କେ କୟ୍‌ଲାୟ୍‌, ‘ଏ ସାଉକାର୍‌, ତୁୟ୍‌ କାୟ୍‌ ତର୍‌ ହଃଦାୟ୍‌ ନିକ ବିଆନ୍ ବୁଣି ନଃରିଲିସ୍‌ ? ତଃବେ କୁୟ୍‌ତିର୍‌ କଃଦଟଳା ରଃନ୍ ଉଟ୍‌ଲି ?’ ");
INSERT INTO bdv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ‘କୁୟ୍‌ ଅଲେ ସଃତ୍ରୁ ଇରି କଃରିଆଚେ ।’ ଆରେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, ‘ଅଃମିମଃନ୍‌ ଜାୟ୍‌ ସେରି ଜିକି ହଃବ୍ଳାଉନ୍ଦ୍ ବଃଲି କାୟ୍‌ ତର୍‌ ମଃନ୍ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ମଃତର୍‌ ସାଉକାର୍‌ କୟ୍‌ଲା, ‘ନାୟ୍‌, ତୁମିମଃନ୍ କଃଦଟଳା ଜିକ୍‌ତା ବଃଳ୍‌ କେଜାଣ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଅଁ ହେଁ ଜିକି ହଃବ୍ଳାଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ସେତାକ୍‌ ତାସ୍‌ କାଟ୍‌ତା ହଃତେକ୍‌ କଃଦଟଳାକ୍‌ ହେଁ ବାଡୁକେ ଦିଆସ୍‌, ହଃଚେ କାଟ୍‌ତା ବଃଳ୍‌ କାଟ୍‌ତା ଲକ୍‌କେ କୟ୍‌ଦ୍‌, ତୁମିମଃନ୍ ହଃର୍ତୁ କଃଦଟଳା ସଃବୁ ଗଟେ ଟାଣେ କଃରି ଜୟେ ହଡାଉଁକ୍‌ ହଃଣ୍ଡା ବାନ୍ଦା, ଆର୍‌ ଗଅଁ ସଃବୁ ମର୍‌ ଗଃଦ୍ୟାୟ୍‌ ସଃଙ୍ଗାଉଆ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ଆରେକ୍‌ ଗଟେକ୍‌ କଃତା କୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଅଃନ୍‌କାର୍‌ ଗଟେକ୍‌ ସଃର୍ସୁ ମୁଞ୍ଜି ହର୍‌, ଜୁୟ୍‌ରି ନଃୟ୍‌ ଗଟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବାଳେ ବୁଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ସଃର୍ସୁ ମୁଞ୍ଜି ସଃବ୍‌କେ ସାନ୍ ବିଆନ୍, ମଃତର୍‌ ସେରି ବାଡ୍‌ଲେକ୍‌, ସଃବୁ ସାଗ୍ ଗଃଚ୍ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ଅୟ୍‌ ଇବାନ୍ୟା ବାଡେଦ୍‌ ଜେ, ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନ୍ ଆସି ତାର୍‌ ଡାଳ୍‌ବିତ୍ରେ ଗୁଡା ଗାଲି ବାସା କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜିସୁ ସେମଃନ୍‌କେ ଆରେକ୍‌ ଗଟ୍‌ କଃତା କୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସଃର୍ଗ୍‌ ରାଇଜ୍‌ କମିର୍‌ ହର୍‌, ଗଟେକ୍‌ ମାୟ୍‌ଜି ସେରି ନଃୟ୍‌କଃରି ମାଣେକ୍‌ ଗମ୍‌ଗୁଣ୍ଡ୍‌ ସଃଙ୍ଗ୍ ମିସାୟ୍‌ କଃରି ଚଃଟ୍‌କ୍‌ଲି, ଆର୍‌ ହଃଚେ ସେ ସଃବୁ କମିର୍‌ ହର୍‌ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁ କଃତାମଃନ୍‌ କୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେତିରିଲା, ଅଃନ୍‌କଃରି କଃତାମଃନ୍‌ ନଃକୟ୍‌କଃରି କାୟ୍‌ ସିକ୍ୟା ହେଁ ନଃଦେତି ରିଲା, ");
INSERT INTO bdv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଇତାର୍‌ ଗିନେ ବାବ୍‌ବାଦିମଃନାର୍‌ ଇ ବାବ୍‌ବାଣି ହୁରୁଣ୍ ଅୟ୍‌ଲି, “ଅଃମି କଃତାମଃନ୍‌ କୟ୍‌ ସିକ୍ୟା ଦେଉଁନ୍ଦ୍; ଜଃଗତ୍‌ ଉବ୍‌ଜାଣ୍‌ ଅଃଉତା ଆଗ୍‌ତୁର୍‌ ଲୁକିରିଲା କଃତାସଃବୁ କଃଉନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ହଃଚେ ଜିସୁ ସେ ଲକ୍‌ମଃନ୍‌କେ ଚାଡି ଗଃରେ ହୁର୍ଲା, ତାର୍‌ହଃଚେ ତାର୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ଆସି ହଃଚାର୍ଲାୟ୍‌, “ବାଳାର୍‌ କଃଦଟଳା କଃତାର୍‌ ବାବ୍‌ ନିକକଃରି ବୁଜାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ କୟ୍‌ଲା, “ନିକ ବିଆନ୍ ଜେ ବୁଣେଦ୍‌, ସେ ନଃରାର୍‌ ହୟ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ତାସ୍‌ ହଃଦା ଅଃଉଁଲି ଜଃଗତ୍‌, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସଃର୍ଗ୍‌ ରାଇଜେ ବାସା କଃର୍ତି, ସେମଃନ୍ ନିକ ବିଆନ୍, କଃଦଟଳା ରଃନ୍ ହାହ୍‌ ଆତ୍ମାର୍‌ ଲକ୍‌ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଜୁୟ୍‌ ସଃତ୍ରୁ ସେରି ବୁଣ୍‌ଲି, ସେ ସୟ୍‌ତାନ୍, କାଟାବେଟା ବେଳା ଅୟ୍‌ଲି ଜୁଗ୍ ସେସ୍‌ ଦିନ୍, ଆର୍‌ କାଟ୍‌ତା ଲକ୍‌ସଃବୁ ସଃର୍ଗ୍‌ ଦୁତ୍‌ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ବଃଲେକ୍‌ କଃଦଟଳା ଜଃନ୍‌କଃରି ଗଟେ ଟାଣେ ଗାଦା କଃରି ଜୟେ ହଡାଉଁକ୍‌ ଅୟ୍‌ଦ୍‌, ଜୁଗ୍ ସେସ୍‌ ଦିନ୍‌ ସେରକମ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ନଃରାର୍‌ ହୟ୍‌ସି ଅଃହ୍‌ଣାର୍‌ ଦୁତ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌ଦ୍‌ ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ରାଇଜାର୍‌ ସଃବୁ ବାଦା ଅଃଉତା ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ଅଃଦଃର୍ମି ଲକ୍‌ମଃନ୍‌କେ ରୁଣ୍ଡାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଆର୍‌ ସେମଃନ୍‌କେ ଜୟ୍‌କୁଣ୍ଡେ ହଃବ୍ଳାଉତି, ସେ ବିତ୍ରେ କାନ୍ଦ୍‌ତାର୍‌ ଆର୍‌ ଦାତାର୍‌ କିଳିମିଳି ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ସଃଡେବଃଳ୍‌ ଇସ୍ୱରାର୍‌ ଦଃର୍ମି ଲକ୍‌ମଃନ୍ ସେମଃନାର୍‌ ସଃର୍ଗାର୍‌ ଉବାସିର୍‌ ରାଇଜେ ବେଳ୍‌ ହର୍‌ ଜିକ୍‌ଜିକା ଡିସ୍ତି । ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଗଟ୍‌ ହଃଦାୟ୍‌ ଲୁକ୍‌ଣେ ରିଲା ଦଃନ୍ ହର୍‌ । ଗଟ୍‌ ମାନାୟ୍‌ ସେରି ଦଃକି ସେ କଃତାକ୍‌ ଲୁକାୟ୍‌ଲା, ଆର୍‌ ସଃର୍ଦା ଅୟ୍‌ ଜାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ବିକିକଃରି ସେ ହଃଦାକେ ଗେନ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ଆରେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇବାନ୍ୟା ଗଟେକ୍‌ ନିକ ନିକ ମୁକ୍ତା ଲଳ୍‌ତିରିଲା ବେବାରି ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ଗଟେକ୍‌ ବଃଡେ ମଲାର୍‌ ମୁକ୍ତା ଦଃକି ସେ ଜାୟ୍‌ ତାର୍‌ ଗଃରେ ରିଲାର୍‌ ସଃବୁ ବିକିକଃରି ସେ ମୁକ୍ତାକେ ଗେନ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ଆରେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ସଃମ୍‌ନ୍ଦେ ହଃକାୟ୍‌ଲା ସଃବୁ ରଃକମାର୍‌ ମାଚ୍ ରୁଣ୍ଡାଉତା ଗଟେକ୍‌ ମାଚ୍‌ଜାଲ୍‌ ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ସେରି ବଃର୍ତି ଅୟ୍‌ଲାକ୍‌ ଲକ୍‌ମଃନ୍ କଃଣ୍ଡାୟ୍‌ ଜିକି ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ବଃସି ନିକନିକରି ଡଙ୍ଗାୟ୍‌ ଗଟେଟାଣେ କଃଲାୟ୍‌, ମଃତର୍‌ ବାନ୍ୟାରିମଃନ୍ ହଃଦାୟ୍‌ ହଃବ୍ଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗ୍ ସେସ୍‌ ଦିନ୍‌ ସେରଃକମ୍‌ ଅୟ୍‌ଦ୍‌, ଦୁତ୍‌ମଃନ୍ ବାରାୟ୍‌ ଆସି ଦଃର୍ମିମଃନାର୍‌ ବିତ୍ରେ ଦୁସ୍ଟ୍‌ମଃନ୍‌କେ ବିନେ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ଆରେକ୍‌ ସେମଃନ୍‌କେ ବଃଟିର୍‌ ଜୟ୍‌କୁଣ୍ଡେ ହଃକାଉତି, ସେତି ସେମଃନ୍ କାନ୍ଦି କାନ୍ଦି ଦାତ୍‌ ଚାବି ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ ଇ ସଃବୁ କଃତା ବୁଜ୍‌ଲାସ୍‌ ?” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ହେଁ ମାପ୍ରୁ, ବୁଜ୍‌ଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ଜୁୟ୍‌ ଗଃରାର୍‌ ମୁଳିକା ଅଃହ୍‌ଣାର୍‌ ଗଃଦିଆ ବିତ୍ରାର୍‌ ରିଲା ନଃଉଆଁ ଆର୍‌ ହଃର୍ନା ତାସ୍‌ ବାର୍‌ କଃରେଦ୍‌, ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ଚେଲା ଅୟ୍‌ଲା ସଃବୁ ଦର୍ମ୍‌ ଗୁରୁ ତାର୍‌ ହର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜିସୁ ଇ ସଃବୁ କଃତାମଃନ୍‌ କୟ୍‌ଲା ହଃଚେ, ସେଟାଣେ ହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆର୍‌ ସେ ନିଜାର୍‌ ଦାଦିବାବୁର୍‌ ଗଃଳେ ଆସି ଲକ୍‌ମଃନ୍‌କେ ସେମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଇ ରଃକମ୍‌ ସିକ୍ୟା ଦିଲା ଜେ, ସେମଃନ୍ କାବା ଅୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଇଲକାର୍‌ ଇ ରଃକମ୍‌ ବୁଦି ଆର୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ କୁୟ୍‌ତି ହୁଣି ଆୟ୍‌ଲି ? ");
INSERT INTO bdv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଇ ମାନାୟ୍‌ କି ସେ ବାଡାୟ୍‌ର୍‌ ହୟ୍‌ସି ନୟ୍‌ ? ଇତାର୍‌ ଆୟ୍‌ସି କାୟ୍‌ ମରିୟମ୍‌ ନୟ୍‌ ? ଆର୍‌ ଇତାର୍‌ ବାୟ୍‌ସିମଃନାର୍‌ ନାଉଁ କାୟ୍‌ ଜାକୁବକ୍‌, ଜସେପ୍, ସିମନ୍ ଆର୍‌ ଜିଉଦା ନୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ଆର୍‌ ଇତାର୍‌ ବେଣିମଃନ୍‌ କାୟ୍‌ ସଃବୁ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ନଃରେଉଁଲାୟ୍‌ ? ତଃବେ ସେ ଇ ସଃବୁ ଗ୍ୟାନ୍ ଆର୍‌ ସଃକ୍ତି କୁୟ୍‌ତି ହୁଣି ହାୟ୍‌ଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଆର୍‌ ସେମଃନ୍ ତାକେ ନଃମାନ୍‌ଲାୟ୍‌ । ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବାବ୍‌ବାଦି ନିଜାର୍‌ ଦାଦିବାବୁ ଗଃଳେ ଆର୍‌ ନିଜାର୍‌ ଗଃର୍‌କୁଟୁମ୍‌କେ ଚାଡି ବିନ୍ ସଃବୁ ଟାଣେ ମାନ୍‌ତି ହାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଆର୍‌ ଜିସୁ ସେ ଲକ୍‌ମଃନାର୍‌ ଅବିସ୍ୱାସ୍‌ ଗିନେ ସେତି ବୁତେକ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ସଃଡେବଃଳ୍‌ ଚଃକର୍‌ବତି ହେରଦ୍‌ ଜିସୁର୍‌ କଃତା ସୁଣି, ତାର୍‌ ଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“ଇ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ତାର୍‌ ଦଃଙ୍ଗ୍‌ଳା, ସେ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜିବନ୍ ହାୟ୍‌ ଉଟିଆଚେ, ସେତାର୍‌ ଗିନେ ଇ ସଃବୁ ସଃକ୍ତି ତାର୍‌ ତଃୟ୍‌ କାମ୍‌ କଃରୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ବଃଲେକ୍‌ ହେରଦ୍‌ ନିଜାର୍‌ ବାୟ୍‌ସି ପିଲିପାର୍‌ ଡକୁର୍ସି ହେରଦିଆର୍‌ ଗିନେ ଜହନ୍‌କେ ଦଃର୍ଲା ଆର୍‌ ବାନ୍ଦି ଜଃଇଲ୍‌ ଗଃରେ ହୁରାୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜହନ୍‌ ତାକ୍‌ କଃଉତି ରିଲା, “ହେରଦିଆକେ ସଃଙ୍ଗାଉତାର୍‌ ତର୍‌ ବିଦି ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆର୍‌ ହେରଦ୍‌ ଜହନ୍‌କେ ମଃର୍ନେ ମାରୁକ୍‌ ମଃନ୍ କଃର୍ତି ରିଲେକ୍‌ ହେଁ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍ତିରିଲା ଆର୍‌ ମାରୁ ନଃଚ୍‌ତିରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଜହନ୍‌କେ ବାବ୍‌ବାଦି ବଃଲି ମାନ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ମଃତର୍‌ ହେରଦାର୍‌ ଜଃଲମ୍‌ ଦିନ୍ ଆୟ୍‌ଲାକ୍‌, ହେରଦିଆର୍‌ ଜିସି ଗତିଆମଃନାର୍‌ ମୁଏଁ ନାଚି କଃରି ହେରଦ୍‌କେ ସଃର୍ଦା କଃରାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ସେତାକ୍‌ ହେରଦ୍‌ ହଃର୍ମାଣ୍‌ କଃରି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ସଃୟ୍‌ତ୍‌ କଃରି କଃଉଁଲେ, ତୁୟ୍‌ ଜୁୟ୍‌ରି ମାଗ୍‌ଲେକ୍‌ ମୁଁୟ୍‌ ତକେ ସେରି ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ଆର୍‌ ସେ ଟକିକେ ତାର୍‌ ଆୟ୍‌ସି ସିକାୟ୍‌ଲାକ୍‌, ସେ କୟ୍‌ଲି, “ବାପ୍ତିସମ୍‌ ଦେତା ଜହନାର୍‌ ମୁଣ୍ଡ୍ ମକେ ଅଃବେ ଇତି ଗଟ୍‌ ତାଳି ତଃୟ୍‌ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଇରି ସୁଣି ରଃଜା ବଃଡେ ଦୁକ୍‌ କଃଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ତାର୍‌ ସଃଙ୍ଗ୍ ବଜିୟେ ବଃସି ରିଲା ଲକ୍‌ମଃନାର୍‌ ମୁଏଁ ହଃର୍ମାଣ୍‌ କଃରି ରିଲାର୍‌ ଗିନେ, ସେରି ଦେଉଁକେ ଆଦେସ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ସେତାକ୍‌ ଜାଗୁଆଳିକେ ହଃଟାୟ୍‌ ଜଃଇଲ୍‌ ଗଃରେ ଜହନ୍‌କେ ମୁଣ୍ଡ୍ କାଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ଆର୍‌ ତାର୍‌ ମୁଣ୍ଡ୍ ଗଟ୍‌ ତାଳାୟ୍‌ ଆଣାୟ୍‌ ସେ ଟକିକେ ଦିଲାୟ୍‌, ଆରେକ୍‌ ସେ ଟକି ସେରି ଦଃରି ଆୟ୍‌ସି ହାକ୍‌ ନିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ତାର୍‌ହଃଚେ ଜହନାର୍‌ ଚେଲାମଃନ୍ ଆସି ଜହନାର୍‌ ମଃଲାମଃଳ୍‌ ନଃୟ୍‌ ମଃସୁଣ୍‌ କାଲେ ତହ୍‌ଲାୟ୍‌ ଆର୍‌ ଜାୟ୍‌ ଜିସୁକେ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଜିସୁ ସେରି ସୁଣି ସେ ଟାଣ୍ ଚାଡି ଡଙ୍ଗାୟ୍‌ ଚଃଗି ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ଗଃଲା । ଆର୍‌ ଲକ୍‌ମଃନ୍ ଇରି ସୁଣି ଗଃଳ୍‌ ବିତ୍ରେହୁଣି ଆସି ଇଣ୍ଡି ଇଣ୍ଡି ତାର୍‌ ଚଃମେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଆର୍‌ ଜିସୁ ଡଙ୍ଗାୟ୍‌ହୁଣି ବାରାୟ୍‌ ଅଲେକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ସେମଃନ୍‌କେ ଦଃୟା ଦଃକାୟ୍‌ଲା ଆର୍‌ ସେମଃନାର୍‌ ରଗିମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ବେଳ୍‌ ଅୟ୍‌ଲାକ୍‌ ଚେଲାମଃନ୍ ତାର୍‌ ଲଃଗେ ଆସି କୟ୍‌ଲାୟ୍‌, “ଇରି ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣ୍, ଆରେକ୍‌ ଉତୁର୍‌ ବେଳା ଅୟ୍‌ଲିନି; ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ଗାଉଁଏମଃନ୍‌ ଜାୟ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଗିନେ କାଦି ଗେନୁକ୍‌ ସେମଃନ୍‌କେ ଚାଡି ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସେମଃନ୍ ଜଃଉଁକେ ଲଳା ନାୟ୍‌, ତୁମିମଃନ୍ ସେମଃନ୍‌କେ କାଳାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ତଃୟ୍‌ ଅଃକାୟ୍‌ ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜୁଳେକ୍‌ ମାଚ୍ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ କୟ୍‌ଲା, “ସେରିମଃନ୍ ମର୍‌ ହାକ୍‌ ଆଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଆରେକ୍‌, ସେ ଲକ୍‌ମଃନ୍‌କେ ରଃନ୍ ଉହ୍ରେ ବଃସୁକେ କୟ୍‌ଲା, ଆର୍‌ ଜିସୁ ସେ ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜଳେକ୍‌ ମାଚ୍‌କେ ଆତେ ଦଃରି ସଃର୍ଗ୍‌ ବାଟ୍ୟା ଦଃକି ଆସିର୍ବାଦ୍‌ କଃରି ରୁଟିମଃନ୍ ବାଙ୍ଗାୟ୍‌ ଚେଲାମଃନ୍‌କେ ଦିଲା, ଆର୍‌ ଚେଲାମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ସଃବୁ ଲକ୍‌ମଃନ୍ ହେଟ୍‌ ହୁର୍ନେ କାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଚେଲାମଃନ୍ ଉବୁର୍ଲାର୍‌ କୁଦ୍ରି ରୁଟି ବେଟି ବାର ଡଃଲା ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ସେତି କାୟ୍‌ଲା ଲକ୍‌, ମାୟ୍‌ଜି ଆର୍‌ ସାନ୍ ହିଲାମଃନ୍‌କେ ଚାଡିକଃରି ହାକାହାକି ହାଁଚ୍ ଅଃଜାର୍‌ ଅଃଣ୍ଡ୍ରାଲକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ସେଦାହ୍ରେ ଜିସୁ ଚେଲାମଃନ୍‌କେ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ତାର୍‌ ଆଗ୍‌ତୁ ସଃମ୍‌ନ୍ଦ୍ ସେହାଟି ଜଃଉଁକେ କୟ୍‌ଲା, ଆରେକ୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ସେଲ ଚାଡି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ଲକ୍‌ମଃନ୍‌କେ ସେଲ ଚାଡି ଦିଲା ହଃଚେ, ସେ ପାର୍ତ୍‌ନା କଃରୁକେ ଅଃଲ୍‌ଗା ଅୟ୍‌କଃରି ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଗଃଲା, ଆର୍‌ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ହେଁ ସେତି ଏକ୍ଲା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ମଃତର୍‌ ଡଙ୍ଗା ସଃଡେବଃଳ୍‌ କଃଣ୍ଡାୟ୍‌ ହୁଣି ଅଃନାୟ୍‌ ଦୁରି ରିଲି, ଆର୍‌ ଜଃବର୍‌ ବାଉର୍‌ ଗିନେ ଉଲାଳ୍‌କେ ସେରି ଏଣେ ତେଣେ ଅଃଉତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ମଃତର୍‌ ରାତି ଚାର୍‌ଟା ବଃଳ୍‌ ସେ ସଃମଃନ୍ଦ୍ ଉହ୍ରେ ଇଣ୍ଡି ଇଣ୍ଡି ଚେଲାମଃନାର୍‌ ଚଃମେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ ସଃମ୍‌ନ୍ଦ୍ ଉହ୍ରେ ଇଣ୍ଡ୍‌ତାର୍‌ ଦଃକି ଡିରିକଃରି କୟ୍‌ଲାୟ୍‌, “ଇରି ତ ଡୁମା !” ଆର୍‌ ସେମଃନ୍ ଡିରାର୍‌ ଗିନେ ବେଲ୍‌କି ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ମଃତର୍‌ ଜିସୁ ସେଦାହ୍ରେ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଟଣ୍ଡ୍‌ଅୟ୍‌ କୟ୍‌ଲା, “ସାସ୍‌ ଦଃରା, ଇରି ତ ମୁଁୟ୍‌, ଡିରି ଜାହାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ସେତାକ୍‌ ପିତର୍‌ ଉତୁର୍‌ ଦିଲା, “ଏ ମାପ୍ରୁ, ଜଃବେ ତୁୟ୍‌, ତଃବେ ହାଣି ଉହ୍ରେ ତର୍‌ ଲଃଗେ ଜଃଉଁକେ ମକ୍‌ ଆଦେସ୍‌ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଆଉ ।” ସେତାକ୍‌ ପିତର୍‌ ଡଙ୍ଗାୟ୍‌ହୁଣି ଉତ୍ରି ହାଣି ଉହ୍ରେ ଇଣ୍ଡି ଇଣ୍ଡି ଜିସୁର୍‌ ଚଃମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମଃତର୍‌ ସେ ବାଉକେ ଦଃକି ଡିର୍‌ଲା ଆର୍‌ ହାଣାୟ୍‌ ବୁଡୁକ୍‌ ଦଃର୍ଲା ଆର୍‌ ବେଲ୍‌କି ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ମକେ ବଚାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଜିସୁ ସେଦାହ୍ରେ ଆତ୍‌ ଲାମାୟ୍‌ ତାକେ ଦଃରି କୟ୍‌ଲା, “ଏ ଅଃଳକ୍‌ ବିସ୍ୱାସି, କାୟ୍‌ତାକ୍‌ ମକ୍‌ ସଃତ୍‌ ନଃକେଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଆର୍‌ ସେମଃନ୍ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ଲାକେ ବାଉ ତିର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ସେତାକ୍‌ ଡଙ୍ଗାୟ୍‌ ରିଲା ଚେଲାମଃନ୍ ଜିସୁକେ ଜୁଆର୍‌ କଃରି କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ନିଜ୍‌କଃରି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ସେମଃନ୍ ସଃମ୍‌ନ୍ଦ୍ ଲିଙ୍ଗି ଗିନେସ୍‌ରଃତ୍‌ କଃଣ୍ଡାୟ୍‌ ହଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆର୍‌ ସେତିର୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଚିନୁ ହାରି ସେତିର୍‌ ଚାରିବାଟ୍ୟା କବୁର୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ସଃବୁ ରଗିମଃନ୍‌କେ ତାର୍‌ ଟାଣେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଆର୍‌ ରଗ୍ୟାମଃନ୍ ଜଃନ୍‌କଃରି ଜିସୁର୍‌ ଗଃଗାଳାର୍‌ ହଃଚ୍ୟା ଆଚଳ୍‌ ଚିଉତି, ସେତାର୍‌ଗିନେ ଲକ୍‌ମଃନ୍ ହାଦେ ହଃଳି ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ଆରେକ୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ଚୁୟ୍‌ଲାୟ୍‌ ସେମଃନ୍ ଉଜ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ସଃଡେବଃଳ୍‌ ଜିରୁସାଲମେ ହୁଣି ପାରୁସି ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଜିସୁର୍‌ ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ତର୍‌ ଚେଲାମଃନ୍ କାୟ୍‌ତାକ୍‌ ଅଃମାର୍‌ ପାରାଚିନ୍‌ମଃନ୍‌ ଦିଲା ରିତିବିଦି କଃରି ଆସୁଲାର୍‌ ନଃମାନୁଲାୟ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ କାତାବଃଳ୍‌ ଅଃମାର୍‌ ରିତିବିଦି ହଃର୍କାରେ ଆତ୍‌ ନଃଦଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ହେଁ ତୁମାର୍‌ ଦାଦିବାବୁ ଦିଲାର୍‌ ବିଦି କଃରି ଆସୁଲାର୍‌ ଗିନେ କାୟ୍‌ତାକ୍‌ ଇସ୍ୱରାର୍‌ ଆଦେସ୍‌ ନଃମାନୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଇସ୍ୱର୍‌ ତ କୟ୍‌ଲା ଆଚେ, ‘ଆୟା ଉବାକ୍‌ ମାନା, ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ଉବା କି ଆୟାକ୍‌ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ଦ୍‌, ସେ ନିଜ୍‌କଃରି ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ମଃତର୍‌ ତୁମିମଃନ୍ କଃଉଁଲାସ୍‌, ଜୁୟ୍‌ଲକ୍‌ ଉବାକ୍‌ କି ଆୟାକ୍‌ କୟ୍‌ଦ୍‌, ‘ମର୍‌ ତଃୟ୍‌ହୁଣି ଜାର୍‌ ଗିନେ ତୁମାର୍‌ ଉହ୍‌କାର୍‌ ଅୟ୍‌ଲି ହୁଣି, ସେରି ମାପ୍ରୁକ୍‌ ଦାନ୍‌ କଃରିଆଚି,’ ");
INSERT INTO bdv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ସେ ଅଃହ୍‌ଣାର୍‌ ଉବା ଆୟାକ୍‌ ସଃତ୍‌କଃରି ନଃମାନେ, ଇହର୍‌ ତୁମିମଃନ୍ କଃରି ଆସୁଲାର୍‌ ରିତିବିଦି ଗିନେ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ହଲ୍ୟା କଃରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ରେ ହେଟ୍‌କପଟ୍ୟାମଃନ୍, ଜିସାୟ୍‌ ବାବ୍‌ବାଦି ତୁମିମଃନାର୍‌ ଗିନେ ଟିକ୍‌ ବାବ୍‌ବାଣି କୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘ଇ ଜାତି ମୁଏଁ ମକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତି, ମଃତର୍‌ ସେମଃନାର୍‌ ମଃନ୍‌ ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ସେମଃନ୍ ମାନାୟ୍‌ମଃନାର୍‌ ରିତିବିଦିକ୍‌ ଦଃର୍ମ୍‌ ସିକ୍ୟା କଃତା ବଃଲି ସିକ୍ୟା ଦେତି, ଆର୍‌ ହଲ୍ୟା ମର୍‌ ସେବା କଃର୍ତି ।’” ");
INSERT INTO bdv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ଆରେକ୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ଚଃମେ କୁଦି କୟ୍‌ଲା, “ସୁଣା ଆର୍‌ ବୁଜା ! ");
INSERT INTO bdv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଟଣ୍ଡ୍ ବାଟ୍ୟା ଜାୟ୍‌ରି ବିତ୍ରେ ଜାୟ୍‌ଦ୍‌, ସେରି ମାନାୟ୍‌କେ ବିଟାଳ୍‌ ନଃକେରେ, ମଃତର୍‌ ଟଣ୍ଡ୍ ବାଟ୍ୟା ଜାୟ୍‌ରି ବାରାୟ୍‌ଦ୍‌, ସେରି ହଃକା ମାନାୟ୍‌କେ ବିଟାଳ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ସଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ପାରୁସିମଃନ୍ ଇ କଃତା ସୁଣିକଃରି ଲାଜ୍‌ ହାୟ୍‌ଲାୟ୍‌ ଆଚ୍‌ତି, ସେରି କାୟ୍‌ ଜାଣୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ସଃର୍ଗାର୍‌ ଉବା ଜୁୟ୍‌ସଃବୁ ଗଃଚ୍ ନଃରୟ୍‌, ସେରିମଃନ୍ ସଃବୁ ଉଟ୍‌କା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“ସେମଃନ୍‌କେ ଚାଡା, ସେମଃନ୍ କାଣାମଃନ୍‌କେ ବାଟ ଦଃକାଉତା କାଣାମଃନ୍, ଜଃଡେବଃଳ୍‌ ଗଟ୍‌ କାଣା ଆରେକ୍‌ ଗଟ୍‌ କାଣାକେ ବାଟ କାଡାୟ୍‌ଦ୍‌, ତଃବେ ଦୁୟ୍‌ ଲକ୍‌ ହେଁ କାଲେ ଅଦୁର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ଇତାକ୍‌ ପିତର୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଇ କଃତାର୍‌ ବାବ୍‌ ଅଃମିକ୍‌ ବୁଜାୟ୍‌ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ହେଁ କାୟ୍‌ ଅଃବେ ହଃତେକ୍‌ ନଃବୁଜାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଜାୟ୍‌ରି ସଃବୁ ଟଣ୍ଡ୍ ବାଟ୍ୟା ହୁରେଦ୍‌, ସେରି ହେଟ୍‌ ବିତ୍ରେ ଜାୟ୍‌ଦ୍‌ ଆର୍‌ ହଃଦାୟ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ଦ୍‌, ଇରି କାୟ୍‌ ନଃବୁଜୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ମଃତର୍‌ ଟଣ୍ଡ୍ ବାଟ୍ୟା ଜାୟ୍‌ରି ସଃବୁ ବାରାୟ୍‌ଦ୍‌, ସେରି ଗଃର୍ବ୍‌ ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ଦ୍‌, ଆର୍‌ ସେରି ହଃକା ମାନାୟ୍‌କେ ବିଟାଳ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ବଃଲେକ୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ହୁଣି କଃରାବ୍‌ ବାବ୍‌ନା, ନଃର୍‌ଅଃତ୍ୟା, ଦାରି କଃର୍ତାର୍‌, ଦାରି ମାୟ୍‌ଜି ଟାଣେ ଜାତାର୍‌, ଚର୍‌ କାମ୍‌, ମିଚ୍ ସାକି ଆର୍‌ ଲିନ୍ଦା କଃର୍ତାର୍‌ ବାରାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଇ ସଃବୁ ବିସୟ୍‌ ମାନାୟ୍‌କେ ବିଟାଳ୍‌ କଃରେଦ୍‌, ମଃତର୍‌ ରିତିବିଦି ହଃର୍କାରେ ନଃଦଉତା ଆତେ କାତାର୍‌ ମାନାୟ୍‌କେ ବିଟାଳ୍‌ ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ସେ ଜଃଗାୟ୍‌ହୁଣି ବାରାୟ୍‌ ସର୍‌ ଆର୍‌ ସିଦନ୍‌ ହଲି ବାଟ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆର୍‌ ସେତି ବାସା କଃର୍ତି ରିଲା ଗଟେକ୍‌ କିଣାନ୍ ଦେସାର୍‌ ମାୟ୍‌ଜି ଆୟ୍‌ଲି ଆର୍‌ ଆଉଲି ଅୟ୍‌ କାଉଁକେ ଦଃର୍ଲି, “ଏ ମାପ୍ରୁ, ଦାଉଦାର୍‌ ହୟ୍‌ସି, ମକେ ଦଃୟାକଃର୍‌, ମର୍‌ ଜିଇକେ ବୁତ୍‌ ଡଃସିଆଚେ, ଆର୍‌ ସେ ବଃଡେ କଃସ୍ଟ୍‌ ହାଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ ହଃଦେକ୍‌ ହେଁ ନଃକୟ୍‌ଲା । ସେତାକ୍‌ ଚେଲାମଃନ୍ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ ଗଃଉଆରି କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଆକ୍‌ ଇତିହୁଣି ଚାଡି ଦେସ୍‌, ସେ ଜଃଉଅ, ବଃଲେକ୍‌ ଇ ମାୟ୍‌ଜି ଅଃମାର୍‌ ହଃଚେ ହଃଚେ ଆଉଲି ଅଃଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ଇସ୍ରାଏଲ୍‌ ବଃଉଁସାର୍‌ ଆଜ୍‌ଲା ମେଣ୍ଡାମଃନ୍‌କେ ଚାଡି କାର୍‌ ଗିନେ ହେଁ ନାସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ମଃତର୍‌ ସେ ମାୟ୍‌ଜି ଆୟ୍‌ଲି ଆର୍‌ ମୁଣ୍ଡିଆ ମାରି ଜୁଆର୍‌କଃରି କଃଉଁକେ ଦଃର୍ଲି, “ଏ ମାପ୍ରୁ, ମର୍‌ ଉହ୍‌କାର୍‌ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ହିଲାମଃନାର୍‌ କାତା କାଦିକ୍‌ କୁକୁର୍‌ମଃନାର୍‌ ଚଃମେ ହଃକାଉତାର୍‌ ନିକ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ମଃତର୍‌ ମାୟ୍‌ଜି କୟ୍‌ଲି, “ଅୟ୍‌ ମାପ୍ରୁ, ବଃଲେକ୍‌ କୁକୁର୍‌ମଃନ୍ ଅଃହ୍‌ଣାର୍‌ ସାଉକାରାର୍‌ ଟେବୁଲ୍‌ ଉହ୍ରେ ହୁଣି ଅଦୁର୍ଲା ଲିତା ସଃକ୍ଳିମଃନ୍‌ ବେଟି କାତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ସେତାକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଆୟା, ତର୍‌ ବଃଡେ ବିସ୍ୱାସ୍‌, ତର୍‌ ଜଃନ୍‌କାର୍‌ ମଃନ୍ ତଃନ୍‌କାର୍‌ ଅଃଉଅ ।” ଆର୍‌ ସେଦାହ୍ରେ ତାର୍‌ ଜିସି ଉଜ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜିସୁ ସେ ଜଃଗା ଚାଡି ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ ଚଃମେ ଆୟ୍‌ଲା । ଆର୍‌ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଜାୟ୍‌ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ଆରେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ଚଟା, କଃଲା, କାଣା, ଗୁଲା, ବଃଇରା ଆର୍‌ ବିନ୍‌ବିନ୍‌ ରଗ୍ୟାମଃନ୍‌କେ ସଃଙ୍ଗେ ଦଃରି ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍‌କେ ଜିସୁର୍‌ ହାଦ୍‌ ତଃଳେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌; ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଇ ରଃକମ୍‌ ଗୁଲାମଃନ୍ କଃତା କଃଉଁଲାୟ୍‌, କଲାମଃନ୍ ଉଜ୍‌ ଅଃଉଁଲାୟ୍‌, ଚଟାମଃନ୍ ଇଣ୍ଡୁଲାୟ୍‌ ଆର୍‌ କାଣାମଃନ୍ ଦଃକୁଲାୟ୍‌, ଇରି ଦଃକି ଲକ୍‌ମଃନ୍ କାବା ଅୟଃଲାୟ୍‌; ଆର୍‌ ଇସ୍ରାଏଲାର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଆର୍‌, ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଚଃମେ କୁଦି କୟ୍‌ଲା, “ଇ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ମର୍‌ ଜିବନେ ଦଃୟା ଆସୁଲି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇମଃନ୍‌ ତିନିଦିନ୍ ଅୟ୍‌ଲି ମର୍‌ ସଃଙ୍ଗେ ଆଚ୍‌ତି ଆର୍‌ ଇମଃନାର୍‌ ଟାଣେ କାୟ୍‌ରି ହେଁ କାଉଁକେ ନାୟ୍‌; କଃଡେବଃଳ୍‌ ବାଟେ ଜାତା ବଃଳ୍‌ ସେମଃନାର୍‌ ଜିବନ୍ ଉଡି ଜାୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ବୁକାର୍‌ ହେଟେ ଚାଡି ଦେଉଁକେ ମର୍‌ ମଃନ୍ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ଚେଲାମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଆଦାର୍‌ ହୁର୍ନେ କାଳାଉଁକେ ଅଃମିମଃନ୍‌ ଇ ଗାଉଁଗୁଡା କି ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣେ କୁୟ୍‌ତି ହୁଣି ଅଃତେକ୍‌ ରୁଟି ମିଳାଉଁନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମାର୍‌ ଟାଣେ କଃତିଗଟ୍‌ ରୁଟି ଆଚେ ।” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସାତ୍‌ଗଟ୍‌ ରୁଟି ଆର୍‌ କଃତିଗଟ୍‌ ସାନ୍‌ ମାଚ୍ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ ବୁୟେଁ ବଃସୁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଆର୍‌ ଜିସୁ ସେ ସାତ୍‌ଗଟ୍‌ ରୁଟି ଆର୍‌ ମାଚ୍‌କେ ଦଃରି ଇସ୍ୱର୍‌କେ ଦନ୍ୟବାଦ୍‌ ଦିଲା ଆର୍‌ ଚେଲାମଃନ୍‌କେ ଦିଲା; ଆର୍‌ ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ସଃବୁ ଲକ୍‌ମଃନ୍ ହେଟ୍‌ ହୁର୍ନେ କାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଚେଲାମଃନ୍ ଉବୁର୍ଲାର୍‌ ବାଙ୍ଗ୍‌ଲା ରୁଟି ବେଟି ସାତ୍‌ ଡଃଲା ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","କାତା ଲକ୍‌ମଃନ୍ ମାୟ୍‌ଜି ଆର୍‌ ସାନ୍ ହିଲାମଃନ୍‌କେ ଚାଡି ଚାରି ଆଜାର୍‌ ଅଃଣ୍ଡ୍ରାଲକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଇତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ସେଲ ଚାଡି ଦିଲା ଆର୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ମଗ୍‌ଦାନ୍ ସଃନ୍ଦି ଲଃଗେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ପାରୁସି ଆର୍‌ ସାଦୁକିମଃନ୍ ଜିସୁକ୍‌ ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ତାର୍‌ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ସେମଃନ୍ ତାକ୍‌ ଇସ୍ୱର୍‌ ବାଚ୍‌ଲା ଆଚେ ବଃଲି ସାକି ଦେଉଁକେ ସେ ଅଃଗାସ୍‌ ଉହ୍ରେ ଗଟେକ୍‌ କାବା ଅଃଉତା ଚିନ୍ କଃରି ଦଃକାଅ ବଃଲି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବେଳ୍‌ ବୁଡ୍‌ତା ବଃଳ୍‌ ତୁମିମଃନ୍ କଃଉତି ରିଆସ୍‌, ‘ନିକ ହାଗ୍ ଅୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃଗାସ୍‌ ବଃନି ହର୍‌ ରଃଙ୍ଗ୍ ଅୟ୍‌ଆଚେ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆର୍‌ ସଃକାଳ୍ୟା ବଃଳ୍‌ କଃଉଆସ୍‌, ‘ଆଜି ବାଉହାଣି ଅୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃଗାସ୍‌ ବଃନି ହର୍‌ ରଃଙ୍ଗ୍ ଆର୍‌ ବାଦୁଳ୍ୟା ଅୟ୍‌ଆଚେ ।’ ତୁମିମଃନ୍ ଅଃଗାସାର୍‌ ରଃକମ୍‌ ଦଃକି ଅଃନ୍‌ ଅୟ୍‌ଦ୍‌ ବଃଲି ଆନ୍‌ମାନ୍‌ ହାରୁଲାସ୍‌, ମଃତର୍‌ ଅଃବେ ଗଃଟ୍‌ତା କାଳାର୍‌ ଚିନ୍ ଦଃକି କାୟ୍‌ତାକ୍‌ ବୁଜୁ ନଃହାରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଦୁସ୍ଟ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌କେ ବିସ୍ୱାସ୍‌ ନଃକେର୍ତା ଲକ୍‌ମଃନ୍ ଚିନ୍ ଲଳ୍‌ତି, ମଃତର୍‌ ଜୁନସାର୍‌ ଚିନ୍ ଚାଡି ଆର୍‌ କାୟ୍‌ ଚିନ୍ ହେଁ ସେମଃନ୍‌କେ ଦିଆ ନୟ୍‌ ।” ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ ଚାଡି ବିନ୍ ଟାଣେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଚେଲାମଃନ୍ ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟି ହଚ୍‌ଲାୟ୍‌, ମଃତର୍‌ ରୁଟି ନେଉଁକେ ହାସୁର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ପାରୁସି ଆର୍‌ ସାଦୁକିମଃନାର୍‌ କମିର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ସେତାକ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଅଃମି ରୁଟି ଆଣୁକେ ହାସୁର୍‌ଲାକେ ସେ ଇରି କଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ମଃତର୍‌ ଜିସୁ ସେରି ଜାଣି କୟ୍‌ଲା, “ଏ ଅଃଳକ୍‌ ବିସ୍ୱାସିମଃନ୍, ତୁମାର୍‌ ତଃୟ୍‌ ରୁଟି ନାୟ୍‌ ବଃଲି କାୟ୍‌ତାକ୍‌ ତୁମାର୍‌ ତୁମାର୍‌ ବିତ୍ରେ କଃତା ଅଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ତୁମିମଃନ୍ କାୟ୍‌ ଅଃବେ ହଃତେକ୍‌ ବୁଜୁ ନଃହାରୁଲାସ୍‌ ? ସେ ହାଁଚ୍ ଅଃଜାର୍‌ ଲକ୍‌ ହାଁଚ୍‌ଗଟ୍‌ ରୁଟି କାୟ୍‌ଲା ହଃଚେ, ଉବୁର୍ଲା ବାଙ୍ଗ୍‌ଲାରିମଃନ୍ କଃତି ଡଃଲା ବେଟ୍‌ଲାସ୍‌ ? ଇରି କାୟ୍‌ ତୁମାର୍‌ ଏତୁ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆରେକ୍‌ ଚାରି ଅଃଜାର୍‌ ଲକ୍‌ ସାତ୍‌ଗଟ୍‌ ରୁଟି କାୟ୍‌ ସଃର୍ଲା ହଃଚେ ଉବୁର୍ଲା ବାଙ୍ଗ୍‌ଲା ରୁଟିମଃନ୍ କଃତି ଡଃଲା ବେଟ୍‌ଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ରୁଟି କଃତା କୟ୍‌ନଃରିଲେ, ଇରି କଃନ୍‌କଃରି ବୁଜୁ ନଃହାରୁଲାସ୍‌ ? ମଃତର୍‌ ମୁଁୟ୍‌ ପାରୁସି ଆର୍‌ ସାଦୁକିମଃନାର୍‌ କମିର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ରିଆ ବଃଲି କୟ୍‌ରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଜିସୁ ରୁଟାୟ୍‌ ମିସାଉତା କମିର୍‌ କଃତା କୟ୍‌ ନଃରିଲା, ମଃତର୍‌ ପାରୁସି ଆର୍‌ ସାଦୁକିମଃନାର୍‌ ସିକ୍ୟା ତଃୟ୍‌ହୁଣି ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ ରେଉଁକେ ସେମଃନ୍‌କେ କୟ୍‌ରିଲା, ସେରି ସେମଃନ୍ ସଃଡେବଃଳ୍‌ ବୁଜ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ତାର୍‌ହଃଚେ ଜିସୁ କାଇସରିଆ ପିଲିପି ଗଃଳେ ଆସି ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ହଃଚାର୍ଲା, “ନଃରାର୍‌ ହୟ୍‌ସି କେ ବଃଲି ଲକ୍‌ମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ଇତାକ୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “କେ କେ କଃଉଁଲାୟ୍‌, ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌, କେ କେ ଏଲିୟ, ଆରେକ୍‌ କେ କେ ଜିରିମିୟ ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମଃତର୍‌ ମୁଁୟ୍‌ କେ ବଃଲି ତୁମିମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମନ୍ ପିତର୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ କ୍ରିସ୍ଟ, ଜିବନ୍ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ତାର୍‌ହଃଚେ ଜିସୁ କୟ୍‌ଲା, “ଏ ଜୁନସାର୍‌ ହୟ୍‌ସି ସିମନ୍ ତର୍‌ ବାୟ୍‌ଗ୍‌, ବଃନି ଆର୍‌ ମାସ୍‌ ବଃଲେକ୍‌ ମାନାୟ୍‌ ତକେ ଇରି କଃଉଁକେ ନଃକୟ୍‌କଃରି, ମଃତର୍‌ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବା ନିଜେ ଇରି ତର୍‌ ମୁଏଁ କୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଆର୍‌ ମୁଁୟ୍‌ ହେଁ ତକେ କଃଉଁଲେ, ତୁୟ୍‌ ପିତର୍‌, ବଃଲେକ୍‌ ଟେଳା, ମଃତର୍‌ ଇ ଟେଳା ଉହ୍ରେ ମୁଁୟ୍‌ ମର୍‌ ମଣ୍ଡ୍‌ଳି ତିଆର୍‌ କଃରିନ୍ଦ୍‌, ଆର୍‌ ନଃର୍କାର୍‌ ବଃଳ୍‌ ତାକେ ଆରାଉଁକ୍‌ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ମୁଁୟ୍‌ ତକେ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ କୁଚିକାଡା ଦଃୟ୍‌ନ୍ଦ୍, ତୁୟ୍‌ ହୁର୍ତିବିଏ ଜାୟ୍‌ରି ବଃନ୍ଦ୍‌ କଃର୍ସି ସଃର୍ଗେ ହେଁ ସେରି ବଃନ୍ଦ୍‌ ରଃୟ୍‌ଦ୍‌, ଆରେକ୍‌ ହୁର୍ତିୟେ ଜାୟ୍‌ରି ମେଲା କଃର୍ସି ସଃର୍ଗେ ହେଁ ସେରି ମେଲା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ସଃଡେବଃଳ୍‌ ସେ ଜେ କ୍ରିସ୍ଟ ହଃକା ମଃସିଆ, ଇ କଃତା କାକେ ହେଁ ନଃକଉଁକ୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ସଃଡେବଃଳ୍‌ ହୁଣି ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “ମକ୍‌ ଜଃନ୍‌କଃରି ହେଁ ଜିରୁସାଲମ୍‌ ଜଃଉଁକେ ଅୟ୍‌ଦ୍‌ । ଆର୍‌ ପାରାଚିନ୍, ବଃଡ୍ ଜାଜକ୍‌, ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଆତେ ବଃଡେ ଦୁକ୍‌ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ନ୍ଦ୍ । ଆର୍‌ ମଃରିନ୍ଦ୍ ଆରେକ୍‌ ତିନିଦିନାର୍‌ ହଃଚେ ମଃର୍ନେହୁଣି ଉଟୁକ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ସେତାକ୍‌ ପିତର୍‌ ଜିସୁକେ ଗଟ୍‌ ହାକ୍‌ କୁଦିନିଲା ଆର୍‌ ଦଃକା ଦଃୟ୍‌ କଃଉଁକେ ଦଃର୍ଲା, “ଏ ମାପ୍ରୁ, ଇସ୍ୱର୍‌ ତକେ ଦଃୟା କଃର, ଇରିମଃନ୍‌ ତକେ କଃବେ ହେଁ ନଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ମଃତର୍‌ ଜିସୁ ଉଲ୍‌ଟି ଦଃକି ପିତର୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ଚଃମେହୁଣି ଦୁର୍‌ ଅଃଉ ସୟ୍‌ତାନ୍‌, ତୁୟ୍‌ ମର୍‌ ବାଦାହର୍‌ ମଃଜାୟ୍‌ କାୟ୍‌ତାକ୍‌ ଅଃଉଁଲିସ୍‌, ବଃଲେକ୍‌ ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ନଃବାବି ମାନାୟ୍‌ର୍‌ କଃତା ବାବୁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ସଃଡେବଃଳ୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “କେ ମର୍‌ ହଃଚେ ହଃଚେ ଆସୁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ଅଃହ୍‌ଣାର୍‌ ଇଚାକ୍‌ ଚାଡ୍, ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ କ୍ରୁସ୍‌ ବୟ୍‌କଃରି ମର୍‌ ହଃଚେ ହଃଚେ ଆସ । ");
INSERT INTO bdv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ବଃଲେକ୍‌ କୁୟ୍‌ ମାନାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ବଚାଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ମଃତର୍‌ କୁୟ୍‌ ମାନାୟ୍‌ ମର୍‌ ଗିନେ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ରଃକ୍ୟା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଆର୍‌ ଜଦି କେ ଜଃଗତାର୍‌ ସଃବୁ ଲାବ୍‌କଃରି ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ତାର୍‌ କାୟ୍‌ ଲାବ୍‌ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଲେଉଟି ହାଉତା ହାୟ୍‌ ସେ କାୟ୍‌ରି ଦେଉଁ ହାରେ ? ");
INSERT INTO bdv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ଆରେକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଅଃହ୍‌ଣାର୍‌ ଉବାସିର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଅଃହ୍‌ଣାର୍‌ ଦୁତ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଆସେଦ୍‌ ଆର୍‌ ସଃଡେବଃଳ୍‌ ସେ ହଃତି ଲକ୍‌ମଃନ୍‌କେ ତାର୍‌ କାମ୍‌ ହଃର୍କାରେ ହଃଳ୍‌ ଦଃୟଃଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ନଃରାର୍‌ ହୟ୍‌ସି ଅଃହ୍‌ଣାର୍‌ ରାଇଜେ ଆସ୍ତାର୍‌ ନଃଦେକ୍‌ତା ହଃତେକ୍‌, ଇତି ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ କଃନ୍‌କଃରି ହେଁ ନଃମେର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଚଅ ଦିନାର୍‌ ହଃଚେ ଜିସୁ, ପିତର୍‌, ଜାକୁବକ୍‌ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଜହନ୍‌କେ ସଃଙ୍ଗେ ଦଃରି ଅଃଲ୍‌ଗା ଅୟ୍‌ ଗଟେକ୍‌ ଉଚ୍ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ନିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ସେତି ସେମଃନାର୍‌ ମୁଏଁ ଜିସୁ ବିନ୍ ରୁହ୍‌ ଅୟ୍‌ଲା, ତାର୍‌ ମୁଁ ବେଳ୍‌ ହର୍‌ ଉଜାଳ୍‌ ଆର୍‌ ତାର୍‌ ବଃସ୍ତର୍‌ ବେଳ୍‌ ଉଜାଳ୍‌ ହର୍‌ ଚିଟ୍‌ ଦବ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ଆରେକ୍‌ ମସା ଆର୍‌ ଏଲିୟ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା କଃଉତାର୍‌ ଚେଲାମଃନ୍‌କେ ଡିସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ସେତାକ୍‌ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ଅଃମିମଃନ୍‌ ଇଟାଣେ ଆଚୁ ଇରି ଅଃନାୟ୍‌ ନିକ, ତର୍‌ ମଃନ୍ ଅୟ୍‌ଲେକ୍‌ ମୁଁୟ୍‌ ଇତି ତିନିଗଟ୍‌ କୁଳିଆ କଃରିନ୍ଦ୍‌, ତର୍‌ ଗିନେ ଗଟେକ୍‌, ମସାର୍‌ ଗିନେ ଗଟେକ୍‌ ଆର୍‌ ଏଲିୟର୍‌ ଗିନେ ଗଟେକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତର୍‌ ଇ କଃତା କଃଉ କଃଉ କଃଣ୍ଡେକ୍‌ ଉଜାଳ୍‌ ମେଗ୍ ସେମଃନ୍‌କେ ଡାହ୍‌ଲି, ଆର୍‌ ସେ ମେଗେ ହୁଣି ଇ କଃତା କଃଉଆ ଅୟ୍‌ଲି, “ଇରି ଅଃମାର୍‌ ଲାଡାର୍‌ ହଅ, ଆର୍‌ ଉହ୍ରେ ଅଃମାର୍‌ ବଃଡେ ସଃନ୍‌ମତ୍‌, ଆର୍‌ କଃତା ସୁଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ଇରି ସୁଣି ଚେଲାମଃନ୍ ବେସି ଡିର୍‌ଲାୟ୍‌ ଆର୍‌ ମୁଁ ତଃଳେ କଃରି ବୁୟେଁ ଡୁଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ତାର୍‌ହଃଚେ ଜିସୁ ଆସି ସେମଃନ୍‌କେ ଚୁୟ୍‌କଃରି କୟ୍‌ଲା, “ଉଟା, ଡିରି ଜାହାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଆର୍‌ ସେମଃନ୍ ଉହ୍ରେ ଦଃକି ଜିସୁକେ ଚାଡି ଆରେକ୍‌ କାକେ ହେଁ ନଃଦେକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ସେମଃନ୍ ଡଙ୍ଗ୍ରେ ହୁଣି ଉତୁର୍ତା ବଃଳ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଆଦେସ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲା, “ନଃରାର୍‌ ହୟ୍‌ସି ମଃର୍ନେ ହୁଣି ଉଟି ନଃକେର୍ତା ହଃତେକ୍‌, ତୁମି ଇ ଦଃକ୍‌ଲା କଃତା କାକେ ହେଁ କଃଉଆ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଚେଲାମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ କାୟ୍‌ତାକ୍‌ କଃଉଁଲାୟ୍‌ ହଃର୍ତୁ ଏଲିୟ ଆସେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ କୟ୍‌ଲା, “ଏଲିୟ ଆସିକଃରି ସଃବୁ କଃତା ଆରେକ୍‌ ଟିକ୍‌ଟାକ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଏଲିୟ ଆସି ସଃର୍ଲାନି, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ନଃଚିନିକଃରି ଜାୟ୍‌ରି ମଃନ୍ ସେରି ତାକେ କଃରି ଆଚ୍‌ତି । ସେରଃକମ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ସେମଃନାର୍‌ ଆତେ ଦୁକ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ଜଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଜିସୁ ବାପ୍ତିସମ୍‌ ଦେଉ ଜହନ୍‌ ବିସୟେ କୟ୍‌ଲା ବଃଲି ଜିସୁର୍‌ ଚେଲାମଃନ୍ ସଃଡେବଃଳ୍‌ ବୁଜ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ସେତି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆସି ମାଣ୍ଡିକୁଟା ଟେସି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ଏ ମାପ୍ରୁ, ମର୍‌ ହଅକେ ଦଃୟା କଃର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ କୁନ୍ଦେଲ୍‌ମଃରି ବଃଡେ କଃସ୍ଟ୍‌ ହାଉଁଲା, ସେ କଃବେ କଃବେ ଜୟେ, କଃବେ କଃବେ ହାଣାୟ୍‌ କୁନ୍ଦେଲ୍‌ ମଃରୁଲା । ");
INSERT INTO bdv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ମୁଁୟ୍‌ ତର୍‌ ଚେଲାମଃନାର୍‌ ଟାଣେ ଆଣି ରିଲେ, ମଃତର୍‌ ସେମଃନ୍ ତାକ୍‌ ଉଜ୍‌ କଃରୁକେ ନଃହାୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ କୟ୍‌ଲା, “ଏରେ ଅବିସ୍ୱାସି ଆର୍‌ ବିନ୍ ବାଟେ ଜାତା ଲକ୍‌ମଃନ୍, କଃତି କାଳ୍‌ ହଃତେକ୍‌ ମୁଁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ନ୍ଦ୍ ? ଆର୍‌ କଃତେକ୍‌ କାଳ୍‌ ତୁମାର୍‌ ବେବାର୍‌ ସଃମ୍ବାଳିନ୍ଦ୍ ? ତାକ୍‌ ଇତି ମର୍‌ ଚଃମେ ଆଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ଜିସୁ ବୁତ୍‌କେ ଗଟ୍‌ ଦଃକା ଦିଲାକ୍‌, ବୁତ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ଗଃଲି, ଆର୍‌ ସେ ହିଲା ସେଦାହ୍ରେ ଉଜ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ଇତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଟାଣେ ଲୁକ୍‌ଣେ ଆସି ହଃଚାର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ କାୟ୍‌ତାକ୍‌ ସେ ବୁତ୍‌ ଚାଡାଉଁ ନଃହାର୍ଲୁ ?” ");
INSERT INTO bdv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ଅଃଳକ୍‌ ବିସ୍ୱାସ୍‌ ଗିନେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଜଦି ଗଟେକ୍‌ ସଃର୍ସୁ ମୁଞ୍ଜି ହର୍‌ ତୁମାର୍‌ ବିସ୍ୱାସ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ଇ ଡଙ୍ଗୁର୍‌କେ, ‘ଇତିହୁଣି ସେତି ଗୁଚି ଜାଆ,’ ବଃଲି କୟ୍‌ଲେକ୍‌, ଗୁଚି ଜାୟ୍‌ଦ୍‌; ଆର୍‌ ବିସ୍ୱାସାର୍‌ ବଃଳେ କାୟ୍‌ରି ହେଁ ନଃହାର୍ତାର୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ମଃତର୍‌ ପାର୍ତ୍‌ନା ଆର୍‌ ଉହାସ୍‌ ଚାଡି ବିନ୍ କାୟ୍‌ ଉପାୟେ ଇ ରଃକମ୍‌ ବୁତ୍‌ ବାରାୟ୍‌ ନଃଜାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ଗାଲିଲିୟେ ଗଟ୍‌ଟାଣେ ରୁଣ୍ଡ୍‌ଲାବଃଳ୍‌, ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନଃରାର୍‌ ହୟ୍‌ସି ନଃର୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅଃଉଁକେ ଜଃଉଁଲା, ");
INSERT INTO bdv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ସେମଃନ୍ ତାକେ ମଃର୍ନେ ମାର୍ତି, ଆର୍‌ ତିନିଦିନାର୍‌ ହଃଚେ ସେ ଆରେକ୍‌ ଉଟେଦ୍‌ ।” ଇତାକ୍‌ ଚେଲାମଃନ୍ ବଃଡେ ଦୁକ୍‌ ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ କପୁର୍ନାହୁମ୍‌ ଆୟ୍‌ଲା ହଃଚେ, ମନ୍ଦିର୍‌ ସିସ୍ଟୁ ନେତା ଲକ୍‌ ପିତର୍‌ ଚଃମେ ଆସି ହଃଚାର୍ଲା, “ତୁମାର୍‌ ଗୁରୁ କାୟ୍‌ ମନ୍ଦିରାର୍‌ ସିସ୍ଟୁ ନଃଦେୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର୍‌ କୟ୍‌ଲା, “ହେଁ, ଦଃୟ୍‌ଦ୍‌ ।” ପିତର୍‌ ଗଃରେ ଆୟ୍‌ଲା ହଃଚେ, ଜିସୁ ଆଗ୍‌ତୁ ତାକ୍‌ କୟ୍‌ଲା, “ସିମନ୍‌ ତୁୟ୍‌ କାୟ୍‌ରି ବାବୁଲିସ୍‌ ? ହୁର୍ତିବିର୍‌ ରଃଜାମଃନ୍ କାର୍‌ ତଃୟ୍‌ହୁଣି ସିସ୍ଟୁ କି ରଃଜାର୍‌ ବାଗ୍ ନେତି ? ନିଜାର୍‌ ଦେସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କି, ବିନ୍ ଦେସାର୍‌ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ?” ");
INSERT INTO bdv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍‌ କୟ୍‌ଲା, “ବିନ୍ ଦେସାର୍‌ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ।” ତଃବେ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତଃବେ ତ ନିଜାର୍‌ ଦେସାର୍‌ ଲକ୍‌ମଃନ୍ ଚାଡ୍ ହାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମଃତର୍‌ ଅଃମିମଃନ୍‌ ସେମଃନାର୍‌ ବାଦା ନଃଦେଉଁଆ, ଇତାର୍‌ ଗିନେ ସଃମ୍‌ନ୍ଦେ ଜାଆ ଆର୍‌ ବଃଳ୍‌ସି ହଃକାଉ, ଆର୍‌ ହଃର୍ତୁ ଜୁୟ୍‌ ମାଚ୍ ଲାଗେଦ୍‌, ତାକେ ଦଃରି ତାର୍‌ ଟଣ୍ଡ୍ ମେଲା କଃଲେକ୍‌ ଗଟେକ୍‌ ରୁହା ଅଦ୍‌ଲି ହାଉସି, ସେରି ଆଣି ମର୍‌ ଗିନେ ଆର୍‌ ତୁମାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ସିସ୍ଟୁ ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ସଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ହାକ୍‌ ଆସି ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ସଃର୍ଗ୍‌ ରାଇଜେ କେ ସଃବ୍‌କେ ବଃଡ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ଗଟେକ୍‌ ସାନ୍ ହିଲାକ୍‌ ଚଃମେ କୁଦି ସେମଃନାର୍‌ ମଃଜାୟ୍‌ ଟିଆ କଃରାୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ଲେଉଟି ସାନ୍ ହିଲା ହର୍‌ ନୟ୍‌ଲେକ୍‌, କଃବେ ହେଁ ସଃର୍ଗ୍‌ ରାଇଜେ ଜଃଉଁ ନଃହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","କୁୟ୍‌ ମାନାୟ୍‌ ଇ ସାନ୍ ହିଲା ହର୍‌ ଅଃହ୍‌ଣାକ୍‌ ସାନ୍ କଃରେଦ୍‌, ସେ ସଃର୍ଗ୍‌ ରାଇଜେ ସଃବ୍‌କେ ବଃଡ୍ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଆର୍‌ କୁୟ୍‌ ମାନାୟ୍‌ ମର୍‌ ନାଉଁଏ ଇ ହର୍‌ ଗଟେକ୍‌ ସାନ୍ ହିଲାକେ ଆଗଳି ଦଃରେଦ୍‌, ସେ ମକେ ଆଗଳି ଦଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ମଃତର୍‌ ଜୁୟ୍‌ଲକ୍‌ ମକ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତା ଇ ସାନ୍ ହିଲାମଃନାର୍‌ ବିତ୍ରାର୍‌ ଏକ୍ଲାକେ ବାଦା ଦଃୟଃଦ୍‌, ତାର୍‌ ଗଃଳାୟ୍‌ ଗଟେକ୍‌ ବଃଡ୍ ଜଃତା ଟେଳା ଅଳାୟ୍‌ ସଃମ୍‌ନ୍ଦେ ହଃକାୟ୍‌ଲେକ୍‌ ତାର୍‌ ଗିନେ ନିକ ଅୟ୍‌ଲି ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ଚି ! ଲକ୍‌ମଃନାର୍‌ ବିସ୍ୱାସେ ବାଦା ଦେତାର୍‌ ଗିନେ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜଃଗତ୍‌, ବାଦା ତ ବାୟ୍‌ଦ୍‌ରେ ଗଃଟେଦ୍‌, ମଃତର୍‌ ଚି ! ଜୁୟ୍‌ ଲକାର୍‌ ଗିନେ ଲକ୍‌ମଃନାର୍‌ ବିସ୍ୱାସେ ବାଦା ଅୟ୍‌ଦ୍‌ ସେ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଜଦି ତୁମାର୍‌ ଆତ୍‌ କି ହାଦାର୍‌ ଗିନେ ତୁମି ହାହ୍‌ କଃରୁଲାସ୍‌, ତଃବେ ସେରି କାଟି ହଃକାଉଆ; ଦୁୟ୍‌ ଆତ୍‌ ଆର୍‌ ଦୁୟ୍‌ ହାଦ୍‌ ଦଃରି କଃବେ ନଃଲିବ୍‌ତା ଜୟ୍‌ ତଃୟ୍‌ ହଃଳ୍‌ତା ବାଦୁଲେ, କଃଲା କି ଚଟା ଅୟ୍‌ ଅଃମ୍ବର୍‌ ଜିବନେ ହୁର୍ତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ । ");
INSERT INTO bdv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଜଦି ତୁମାର୍‌ ଗଟେକ୍‌ ଆକିର୍‌ ଗିନେ ତୁମି ହାହ୍‌ କଃରୁଲାସ୍‌, ତଃବେ ତାକ୍‌ କାଡି ହଃବ୍ଳାଉଆ; ଦୁୟ୍‌ ଆକି ଦଃରି ନଃର୍କେ ସଃର୍ଜ୍‌ଲା ଜୟେ ହଃଳ୍‌ତା ବାଟା, ଗଟେକ୍‌ ଆକି ଦଃରି ଅଃମ୍ବର୍‌ ଜିବନେ ହୁର୍ତାର୍‌ ନିକ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ଜଃଗ୍ରାତ୍‌, ଇ ସାନ୍ ହିଲାମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲାକେ ହେଁ ଇନ୍‌ମାନ୍ କଃରାନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସଃର୍ଗେ ସେମଃନାର୍‌ ଦୁତ୍‌ମଃନ୍ ସଃବୁ ବଃଳ୍‌ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ମୁଉଁ ଦଃକୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାୟ୍‌ରି ଆଜ୍‌ଲି ଆଚେ, ସେରି ଲଳି ବଚାଉଁକେ ନଃରାର୍‌ ହୟ୍‌ସି ଆସି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ତୁମିମଃନ୍ କାୟ୍‌ରି ମଃନେ କଃରୁଲାସ୍‌ ? କୁୟ୍‌ ଲକାର୍‌ ହାଁଚ୍ କଳି ମେଣ୍ଡା ରେତି, ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଆଜେଦ୍‌, ତଃବେ କାୟ୍‌ ଗଟେକ୍‌ ଉଣା ହାଁଚ୍ କଳି ମେଣ୍ଡାକେ ଡଙ୍ଗ୍ରେ ଚାଡି ସେ ଜାୟ୍‌ ସେ ଆଜ୍‌ଲା ମେଣ୍ଡାକେ ନଃଲଳେ ? ");
INSERT INTO bdv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଜଃଡେବଃଳ୍‌ ତାକ୍‌ ମିଳାୟ୍‌ଦ୍‌, ତଃବେ ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଗଟେକ୍‌ ଉଣା ହାଁଚ୍ କଳି ମେଣ୍ଡା ଆଜି ନଃରିଲାୟ୍‌, ସେମଃନାର୍‌ ବାଟା ଆଜିରିଲା ଗଟେକ୍‌ ମେଣ୍ଡାର୍‌ ଗିନେ ସେ ଅଃଦିକ୍‌ ସଃର୍ଦା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ସେବାନ୍ୟା ଇ ସାନ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌, ଇରି ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ମଃନ୍ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ଜଃଡେବଃଳ୍‌ ତୁମାର୍‌ ବାୟ୍‌ ତୁମାର୍‌ ବିରଦେ ହାହ୍‌ କଃରେଦ୍‌, ତଃବେ ତୁମାର୍‌ ଦୁୟ୍‌ ଲକାର୍‌ ବିତ୍ରେ ତାକେ ତାର୍‌ ଦସ୍‌ ଦଃକାଉଆ । ଜଦି ସେ ତୁମାର୍‌ କଃତା ସୁଣେଦ୍‌, ତଃବେ ତୁମି ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌କ୍‌ ହାୟ୍‌ଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ମଃତର୍‌ ସେ ଜଦି ତୁମାର୍‌ କଃତା ନଃସୁଣେ, ତଃବେ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ନୟ୍‌ଲେକ୍‌ ଦୁୟ୍‌ ଲକ୍‌କେ ନଃୟ୍‌ ତାର୍‌ ଲଃଗେ ଜାହା । ଜଃନ୍‌କଃରି ଅଃମାର୍‌ ସାସ୍ତର୍‌ ହଃର୍କାରେ ‘ଦୁୟ୍‌ କି ତିନି ସାକିର୍‌ ମୁଏଁ ସଃବୁ କଃତା ତିର୍‌ ଅୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ସେ ଜଦି ସେମଃନାର୍‌ କଃତା ହେଁ ନଃମାନେ, ତଃବେ ମଣ୍ଡ୍‌ଳିକେ କଃଉଆ ଆର୍‌ ଜଦି ସେ ମଣ୍ଡ୍‌ଳିର୍‌ କଃତା ହେଁ ନଃମାନେ, ତଃବେ ସେ ତୁମାର୍‌ ଆକାୟ୍‌ ଅଜିଉଦି ଆର୍‌ ରିବ୍‌ନି ହର୍‌ ଅଃଉଅ, ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ମିଳାମିସା କଃରାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ହୁର୍ତିବିଏ ଜାୟ୍‌ରି ସଃବୁ ବଃନ୍ଦ୍‌ କଃରାସ୍‌, ସଃର୍ଗେ ସେରି ସଃବୁ ବଃନ୍ଦ୍‌ କଃରା ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସଃଙ୍ଗ୍‌ସାରେ ଜାୟ୍‌ରି ସଃବୁ ଉଗାଳାସ୍‌, ସଃର୍ଗେ ହେଁ ସେରି ସଃବୁ ଉଗାଳା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ଆର୍‌ ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃତା କଃଉଁଲେ, ହୁର୍ତିବିଏ ତୁମାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ ଲକ୍‌ ଜୁୟ୍‌ ବିସୟ୍‌ ହେଁ ଗଟେକ୍‌ ମଃନେ ଜାୟ୍‌ରି ହେଁ ମାଗାସ୍‌, ମର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ଆତେ ସେ ଅଃଦିକାର୍‌ ଆଚେ, ସେରି ତୁମାର୍‌ ଗିନେ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଟାଣେ ଦୁୟ୍‌ କି ତିନିଲକ୍‌ ମର୍‌ ନାଉଁଏ ଗଟେତଃୟ୍‌ଁ ରୁଣ୍ଡ୍‌ତି, ସେ ଟାଣେ ମୁଁୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ସଃଡେବଃଳ୍‌ ପିତର୍‌ ଜିସୁର୍‌ ଚଃମେ ଆସି ହଃଚାର୍ଲା, “ଏ ମାପ୍ରୁ, କଃତିତର୍‌ ମର୍‌ ବାୟ୍‌ ମର୍‌ ବିରଦେ ହାହ୍‌ କଃଲେକ୍‌ ତାର୍‌ ଦଃସ୍‌ କେମା କଃରିନ୍ଦ୍‌ ? କାୟ୍‌ ସାତ୍‌ ତର୍‌ ହଃତେକ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁମିକେ ସାତ୍‌ ତର୍‌ ହଃତେକ୍‌ ନଃକୟ୍‌ଁ, ମଃତର୍‌ ସତୁରି ଗୁଣ୍ ସାତ୍‌ ତର୍‌ ହଃତେକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇହର୍‌ । ଗଟେକ୍‌ ରଃଜା ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଇସାବ୍‌ କଃରୁକେ ମଃନ୍ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ରିଣ୍‌ଦେଉ ଇସାବ୍‌ କଃରୁକେ ଆରୁମ୍‌ କଃଲାକ୍‌, ଲାକେ ଟଃକା ରିଣ୍ ନଃୟ୍‌ରିଲା ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳାକେ ରିଣ୍‌ଦେଉ ଚଃମେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ମଃତର୍‌ ରିଣ୍ ସୁଜୁକ୍‌ ତାର୍‌ କାୟ୍‌ରି ହେଁ ନଃରିଲାକ୍‌ ତାର୍‌ ସାଉକାର୍‌ ତାକ୍‌, ତାର୍‌ ଡକୁର୍ସିକେ, ତାର୍‌ ହିଲା ଆର୍‌ ତାର୍‌ ଜାୟ୍‌ରି ରିଲାର୍‌ ସଃବୁ ବିକିକଃରି ରିଣ୍ ସୁଜୁକ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ସେତାକ୍‌ ସେ ରିଣିଆ ଗତିଦଃଙ୍ଗ୍‌ଳା ସାଉକାରାର୍‌ ଗଡେ ଡୁଳି ଜୁଆର୍‌ କଃରି କାଉଁକେ ଦଃର୍ଲା, ‘ସାଉକାର୍‌ ତୁୟ୍‌ ମକେ ଦଃର୍ମ୍‌ କଃରି ଜାଗ୍, ମୁଁୟ୍‌ ତର୍‌ ସଃବୁ ରିଣ୍ ସୁଜିନ୍ଦ୍ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ତାର୍‌ହଃଚେ ତାର୍‌ ସାଉକାର୍‌ ତାର୍‌ ବିସ୍ୱାସ୍‌ ଦଃକି ରିଣିଆ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଦଃୟା କଃଲା, ଆର୍‌ ତାର୍‌ ରିଣ୍ ହେଁ କେମା କଃଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ମଃତର୍‌ ସେ ରିଣିଆ ଗତିଦଃଙ୍ଗ୍‌ଳା ମାନାୟ୍‌ ସେତିହୁଣି ବାରାୟ୍‌ ଗଃଲା ଆର୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ପଚାସ୍‌ ଟଃକା ରିଣ୍ ନଃୟ୍‌ରିଲା ଗଟେକ୍‌ ସଃଙ୍ଗାର୍‌ ଦଃଙ୍ଗ୍‌ଳାକେ ଦଃକ୍‌ଲା ଆର୍‌ ତାକ୍‌ ଦଃରି ତାର୍‌ ଟଟି ହିଚି କଃଉଁକେ ଦଃର୍ଲା, ‘ତୁୟ୍‌ ଜଃତେକ୍‌ ରିଣ୍ ନିଲିସ୍‌ ଆଚ୍‌ସି ସୁଜ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ସେତାକ୍‌ ତାର୍‌ ସଃଙ୍ଗାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ତାର୍‌ ହାଦେ ଡୁଳି କାକୁଲ୍‌ତି ଅୟ୍‌ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲା, ‘ମକେ ଅଃଳକ୍‌ ଦଃର୍ମ୍‌ କଃରି ଜାଗ୍, ମୁଁୟ୍‌ ସଃବୁ ରିଣ୍ ସୁଜିନ୍ଦ୍ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ମଃତର୍‌ ସେ ରାଜି ନୟ୍‌ଲା, ଆର୍‌ ରିଣ୍ ନଃସୁଜ୍‌ତା ହଃତେକ୍‌ ତାକ୍‌ ଜଃଇଲେ ହୁରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ସେତାକ୍‌ ତାର୍‌ ସଃଙ୍ଗାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ ଇ ଗଃଟ୍‍ଣା ଦଃକି ବଃଡେ ଦୁକ୍‌ କଃଲାୟ୍‌, ଆର୍‌ ତାକାର୍‌ ସାଉକାର୍‌କେ ଇ ସଃବୁ ଗଃଟ୍‍ଣା ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ସେତାର୍‌ ଗିନେ ତାର୍‌ ସାଉକାର୍‌ ତାକ୍‌ ଚଃମେ କୁଦିକଃରି କୟ୍‌ଲା, ‘ଏ ହଃଟ୍‌କାର୍‌ ରିଣିଆ ଗତିଦଃଙ୍ଗ୍‌ଳା, ତୁୟ୍‌ ମକ୍‌ ଗଃଉଆରି କଃଲାକ୍‌ ମୁଁୟ୍‌ ତର୍‌ ସଃବୁ ରିଣ୍ କେମା କଃଲେ । ");
INSERT INTO bdv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ମୁଁୟ୍‌ ଜଃନ୍‌କଃରି ତକେ ଦଃୟା କଃଲେ, ସଃନ୍‌କଃରି ହେଁ ଅଃହ୍‌ଣାର୍‌ ସଃଙ୍ଗାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଦଃର୍ମ୍‌ କଃର୍ତାର୍‌ ତର୍‌ କାମ୍‌ ନଃରିଲି କି ?’ ");
INSERT INTO bdv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଆର୍‌ ତାର୍‌ ସାଉକାର୍‌ ରିସା ଅୟ୍‌ ସଃବୁ ରିଣ୍ ନଃଚୁଟ୍‌ତା ହଃତେକ୍‌ ତାକ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ଜଃଇଲେ ହୁରାଉତା ଲକାର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ କଃତା କୟ୍‌ସଃରାୟ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ହଃତି ଲକ୍‌ ଜଦି ମଃନ୍‌ ବିତ୍ରେହୁଣି ସଃର୍ଦା ମଃନେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ମଃନ୍‌କେ କେମା ନଃକେରାସ୍‌, ତଃବେ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବା ହେଁ ତୁମିମଃନ୍‌କେ ସେନ୍‌କଃରି କେମା ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଇସଃବୁ କଃତା କୟ୍‌ ସଃର୍ଲା ହଃଚେ, ଗାଲିଲି ତଃୟ୍‌ହୁଣି ଲେଉଟି ଜର୍ଦନ୍ ଗାଡାର୍‌ ସେହାଟି ରେତା ଜିଉଦା ରାଇଜ୍‌ ହାକ୍‌ ହଚ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ଆରେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌, ଆର୍‌ ସେତି ସେ ରଗିମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ସଃଡେବଃଳ୍‌ ପାରୁସିମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକ୍‌ କଃଟ୍‌ହାଳ୍‌ କଃରି ହଃଚାର୍ଲାୟ୍‌, “କାୟ୍‌ତାର୍‌ ଗିନେ ହେଁ ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜିକେ ମସାର୍‌ ବିଦି ହଃର୍କାରେ କାୟ୍‌ ଚାଡୁକ୍‌ ଅୟ୍‌ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ରି ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ନଃହଳାସ୍‌ ? ରାଜି ଉବ୍‌ଜାୟ୍‌ଲା ମାପ୍ରୁ ଆଗେହୁଣି ସେମଃନ୍‌କେ ଅଃଣ୍ଡ୍ରା ଆର୍‌ ଟକି କଃରି ତିଆର୍‌ କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଆର୍‌ କୟ୍‌ଲା, ‘ଇତାର୍‌ ଗିନେ ମାନାୟ୍‌ ଆୟାଉବାକ୍‌ ଚାଡେଦ୍‌ ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜି ଟାଣେ ମଃନ୍ ଦଃୟଃଦ୍‌ ଆର୍‌ ଦୁୟ୍‌ ଲକ୍‌ ଗଟେକ୍‌ ଅଃଉତି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଇତାକ୍‌ ସେମଃନ୍ ଆର୍‌ ବିନ୍ ନଃଉତି, ମଃତର୍‌ ଗଟେକ୍‌ ଅଃଉତି; ବଃଲେକ୍‌ ଜାୟ୍‌ରି ଇସ୍ୱର୍‌ ମିସାୟ୍‌ ଆଚେ, ମାନାୟ୍‌ ସେରି ଅଃଲ୍‌ଗା ଅଃଲ୍‌ଗା ନଃକେର ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୁସିମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ମସା କାୟ୍‌ତାକ୍‌ ଚାଡ୍‌ହଃତାର୍‌ ଲେକି ଦଃୟ୍‌ ମାୟ୍‌ଜିକେ ଚାଡୁକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମସା ତୁମିମଃନାର୍‌ ଅଃଟୁଆ ମଃନ୍ ଦଃକିକଃରି ତୁମିମଃନାର୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜିକେ ଚାଡୁକ୍‌ କୟ୍‌ଲା, ମଃତର୍‌ ଆଗ୍‌ତୁ ହୁଣି ସେନ୍‌କାର୍‌ ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ମାୟ୍‌ଜିକେ, ଦାରି ଦଃସ୍‌ ଚାଡି ବିନ୍ କଃତାର୍‌ ଗିନେ ଚାଡ୍ ହଃତାର୍‌ ଦଃୟଃଦ୍‌ ଆର୍‌ ଆରେକ୍‌ ଗଟେକ୍‌ ମାୟ୍‌ଜିକେ ସଃଙ୍ଗାୟ୍‌ଦ୍‌ ସେ ଦାରିକାମ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଚେଲାମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ମାୟ୍‌ଜି ସଃଙ୍ଗ୍ ଅଃଣ୍ଡ୍ରାର୍‌ ଜଦି ଇରଃକମ୍‌ ବିସୟ୍‌ ଆଚେ, ତଃବେ ବିବା କଃଉତାର୍‌ ନିକ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସଃବୁ ଲକ୍‌ ଇ କଃତା ମାନୁ ନଃହାର୍‌ତି, ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସଃକ୍ତି ଦିଆ ଅୟ୍‌ଆଚେ, ସେମଃନ୍ ହଃକା କଃରୁ ହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ କେ କେ ଆୟ୍‌ସିର୍‌ ହେଟେହୁଣି ବେଜୁ ଅୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ ଆଚ୍‌ତି, ଆର୍‌ କେ କେ ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବେଜୁ କଃରାଜାୟ୍‌ ଆଚ୍‌ତି, ଆରେକ୍‌ କେ କେ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଗିନେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାକ୍‌ ବେଜୁ କଃରି ଆଚ୍‌ତି । ଜୁୟ୍‌ ଲକ୍‌ ଇରି କଃରୁ ହାରେ, ସେ କଃର ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ଜିସୁ ଜଃନ୍‌କଃରି ସାନ୍ ହିଲାମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ପାର୍ତ୍‌ନା କଃରେଦ୍‌, ଇତାର୍‌ ଗିନେ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଚଃମେ ସାନ୍ ସାନ୍ ହିଲାମଃନ୍‌କେ ଆଣ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଚେଲାମଃନ୍ ଆଣ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ ଦଃକାଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ସାନ୍ ହିଲାମଃନ୍‌କେ ଚାଡି ଦିଆସ୍‌, ସେମଃନ୍‌କେ ମର୍‌ ଚଃମେ ଆସୁକ୍‌ ମଃନା କଃରା ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇରଃକମ୍‌ ଲକ୍‌ମଃନାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଆର୍‌ ଜିସୁ ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ଆସିର୍ବାଦ୍‌ କଃରି ସେତିହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଆର୍‌ ଗଟ୍‌ ମାଜନ୍ ଦଃଙ୍ଗ୍‌ଳା ଜିସୁର୍‌ ଚଃମେ ଆସି ହଃଚାର୍ଲା, “ଏ ସଃତ୍‌ ଗୁରୁ, ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ହାଉଁକ୍‌ ମୁଁୟ୍‌ କାୟ୍‌ ନିକ କାମ୍‌ କଃରିନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ନିକ ବିସୟେ ମକ୍‌ କାୟ୍‌ତାକ୍‌ ହଃଚାରୁଲି ? ଇସ୍ୱର୍‌ ହଃକା ସଃତ୍‌, ମଃତର୍‌ ତୁୟ୍‌ ଜଦି ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ହାଉଁକେ ମଃନ୍ କଃରୁଲିସ୍‌, ତଃବେ ଇସ୍ୱରାର୍‌ ବିଦି ସଃବୁ ମାନ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ସେ ଜିସୁକେ ହଃଚାର୍ଲା, “କାୟ୍‌ କାୟ୍‌ ରଃକମ୍‌ ବଲ୍‌ ?” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଇରିମଃନ୍‌, ‘ନଃର୍‌ ମାରା ନାୟ୍‌, ଦାରିକାମ୍‌ କଃରା ନାୟ୍‌, ଚରି କଃରାନାୟ୍‌, ମିଚ୍ ସାକି ଦିଆସ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଆୟା ଉବାକ୍‌ ମାନ୍‌ତି କଃରା, ଆରେକ୍‌ ତୁମାର୍‌ ହାକିହଃଳ୍‌ସାକେ ଅଃହ୍‌ଣାକ୍‌ ଲାଡ୍‌ କଃଲା ହର୍‌ ଲାଡ୍‌ କଃରା ।’” ");
INSERT INTO bdv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ସେ ବେଣ୍ଡ୍ୟା ମାନାୟ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଇରିମଃନ୍‌ ମୁଁୟ୍‌ ସଃବୁ କଃରି ଆସୁଲେ, ମର୍‌ ଆର୍‌ କାୟ୍‌ରି କଃରୁକେ ବାକି ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜଦି ତୁୟ୍‌ ହୁରୁଣ୍ ଅଃଉଁକେ ମଃନ୍ କଃରୁଲିସ୍‌, ତଃବେ ଜାୟ୍‌କଃରି ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ଦଃନ୍ ବିକିକଃରି କାୟ୍‌ରି ନୟ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଦାନ୍‌ କଃରି ଦେସ୍‌, ଆର୍‌ ତୁୟ୍‌ ସଃର୍ଗେ ଦଃନ୍ ହାଉସି; ତାର୍‌ହଃଚେ, ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ମଃତର୍‌ ଇ କଃତା ସେ ବେଣ୍ଡ୍ୟା ସୁଣ୍‌ଲା, ଆର୍‌ ମଃନ୍ ଦୁକ୍‌କଃରି ବାରାୟ୍‌ ଗଃଲା, ବଃଲେକ୍‌ ତାର୍‌ ଜଃବର୍‌ ଦଃନ୍ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ସେତାକ୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମାଜନ୍ ଲକ୍‌ କଃଡେ କଃସ୍ଟେ ସଃର୍ଗ୍‌ ରାଇଜେ ଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଗଟ୍‌ ମାଜନ୍‌ ଲକ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜାତା ବାଟା, ସୁତ୍‌ଲିର୍‌ କାଣାବାଟ୍‌ ଅୟ୍‌ ଉଟ୍‌ ଚିଙ୍ଗୁଳ୍‌ତାର୍‌ ଉସାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଚେଲାମଃନ୍ ଇରି ସୁଣ୍‌ଲାୟ୍‌ ଆର୍‌ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତଃବେ କେ ହାହେହୁଣି ନିଜ୍‌କେ ବଚାଉ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ସେମଃନ୍‌କେ ଦଃକି କୟ୍‌ଲା, “ଇରି ମାନାୟ୍‌ କଃରୁ ନଃହାରେ ମଃତର୍‌ ଇସ୍ୱର୍‌ ସଃବୁ କଃରୁହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଦଃକ୍‌, ଅଃମିମଃନ୍‌ ସଃବୁ ଚାଡିକଃରି ତର୍‌ ହଃଚେ ହଃଚେ ଆସି ଆଚୁ, ଅଃମିମଃନ୍‌ ତଃବେ କାୟ୍‌ରି ହାଉନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃରି କଃଉଁଲେ, ନଃଉଆଁ ଜୁଗ୍ ଆୟ୍‌ଲେକ୍‌ ଜଃଡେବଃଳ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଅଃହ୍‌ଣାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସିଙ୍ଗାସଣ୍‌ ତଃୟ୍‌ଁ ବଃସେଦ୍‌, ସଃଡେବଃଳ୍‌ ମର୍‌ ହଃଚେ ହଃଚେ ଆସି ଆଚାସ୍‌, ତୁମିମଃନ୍ ହେଁ ବାରଗଟ୍‌ ସିଙ୍ଗାସଣେ ବଃସିକଃରି ଇସ୍ରାଏଲାର୍‌ ବାର ବଃଉଁସ୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ନାଉଁ ଗିନେ ଗଃର୍‌, ବାୟ୍‌, ବେଣି, ଉବା, ଆୟା, ହିଲା, କି ବୁୟ୍‌ଁ ଚାଡେଦ୍‌ ସେ ସଏ ଗୁଣ୍ ଅଃଦିକ୍‌ ଆସିର୍ବାଦ୍‌, ଆର୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ମଃତର୍‌ ହଃର୍ତୁ ରିଲା କଃତେକ୍‌ ଲକ୍‌ ହଃଚେ ଅଃଉତି ଆର୍‌ ହଃଚେ ରିଲା କଃତେକ୍‌ ଲକ୍‌ ହଃର୍ତୁ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇବାନ୍ୟା ଗଟେକ୍‌ ସାଉକାର୍‌ ହର୍‌, ସଃକାଳ୍‌ ଅୟ୍‌ଲା ଦାହ୍ରେ ତାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ ବୁତି ଲାଗାଉଁକେ ଲକ୍‌ମଃନ୍‌କେ ଲଳୁକ୍‌ ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ସେ ବୁତିକଃରୁ ଲକ୍‌ମଃନ୍‌କେ ଦିନେକେ ଗଟେକ୍‌ ରୁହା ଟଃକା ବୁତି ଦେଉଁକେ ଚିଡାୟ୍‌କଃରି ଅଙ୍ଗୁର୍‌ ବାଳେ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ଆରେକ୍‌ ନଅଃ ଗଃଟା ବେଳାୟ୍‌ ସେ ବାରାୟ୍‌ ଗଃଲା ଆର୍‌ ବଃଜାରେ ବିନ୍ ଲକ୍‌ମଃନ୍ ହାୟ୍‌ଟି ନୟ୍‌ଲାକ୍‌ ଅଃଳ୍‌ସିଆ ଅୟ୍‌ ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକ୍‌ଲା ଆର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘ତୁମିମଃନ୍ ହେଁ ମର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ ଜାହା, ଆର୍‌ ତୁମିକେ ଜାୟ୍‌ରି ଦେତାର୍‌ ଟିକ୍‌ ସଃତେକ୍‌ ତୁମିକେ ଦଃୟ୍‌ନ୍ଦ୍ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ଆର୍‌ ସେମଃନ୍ ଗଃଲାୟ୍‌ । ତାର୍‌ହଃଚେ ସେ ବାର ଗଃଟା ଆର୍‌ ତିନିଗଃଟା ବେଳାୟ୍‌ ବାରାୟ୍‌ ଗଃଲା ଆର୍‌ ସେହର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଅଙ୍ଗୁର୍‌ ବାଳେ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ଆରେକ୍‌ ହାଁଚ୍ ଗଃଟା ବେଳାୟ୍‌ ବାରାୟ୍‌ ଗଃଲା ଆର୍‌ କଃତି ଲକ୍‌କେ ଅଃଳ୍‌ସିଆ ଅୟ୍‌ ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକି ହଃଚାର୍ଲା, ‘ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ହାୟ୍‌ଟି ନଃକେରି ବେଳ୍‌ ବୁଡାଉଁଲାସ୍‌ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, ‘ବଃଲେକ୍‌ ଅଃମିକ୍‌ କେ ବୁତି ନଃଲାଗାଉତି ।’” ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍‌ ହେଁ ମର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ ଜାହା ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ହଃଚେ ବେଳ୍‌ ବୁଡ୍‌ତା ବଃଳ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସାଉକାର୍‌ ତାର୍‌ ଗୁମୁସ୍ତାକ୍‌ କୟ୍‌ଲା, ‘ବୁତି କଃଲା ଲକ୍‌ମଃନ୍‌କେ କୁଦି ହଃଚେ ଆୟ୍‌ଲା ଲକ୍‌ମଃନ୍ ତଃୟ୍‌ହୁଣି ଆରୁମ୍‌ କଃରି ହଃର୍ତୁର୍‌ ଲକ୍‌ମଃନ୍‌କେ ବୁତି ଡାବୁ ଦେସ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ହାଁଚ୍ ଗଃଟା ବଃଳ୍‌ ଆସି ବୁତି କଃରି ରିଲାୟ୍‌, ସେମଃନ୍ ଗଟେକ୍‌ ଲେକା ରୁହା ଟଃକା ବୁତି ଡାବୁ ହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଆରେକ୍‌ ହଃର୍ତୁମ୍‍ହୁଣି ବୁତି କଃଲା ଲକ୍‌ ଅଃଦିକ୍‌ ହାଉନ୍ଦ୍ ବଃଲି ମଃନେ ବାବ୍‌ତି ରିଲାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ହେଁ ଗଟେକ୍‌ ଲେକା ରୁହା ଟଃକା ହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ମଃତର୍‌ ସେରି ହାୟ୍‌ ସାଉକାର୍‌କେ ରିସା ଅୟ୍‌ ଉଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ଇ ହଃଚାର୍‌ ଲକ୍‌ମଃନ୍ ଗଟେକ୍‌ ଗଃଟା ମଃତର୍‌ ହାୟ୍‌ଟି କଃଲାୟ୍‌, ଆରେକ୍‌ ଅଃମିମଃନ୍‌ ଦିନ୍ ସଃରା କଃରାୟ୍‌ ହାୟ୍‌ଟି କଃଲୁ, ମଃତର୍‌ ତୁୟ୍‌ ସେମଃନ୍‌କେ ଅଃମାର୍‌ ସଃମାନ୍ କଃଲିସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଲକ୍‌କେ ସାଉକାର୍‌ କୟ୍‌ଲା, ‘ବାୟ୍‌, ତକେ ମୁଁୟ୍‌ ଅଃନ୍ୟାୟ୍‌ ନଃକେରି, ତୁୟ୍‌ କାୟ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ଗଟେକ୍‌ ଲେକା ରୁହା ଟଃକାର୍‌ ଗିନେ ରାଜି ଅୟ୍‌ନଃରିଲିସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ଜାୟ୍‌ରି ହାୟ୍‌ ଆଚ୍‌ସି, ସେରି ଦଃରି ବାରାୟ୍‌ ଜାଆ, ମଃତର୍‌ ଇ ହଃଚାର୍‌ ଗଟ୍‌ ଗଃଟା ହାୟ୍‌ଟି କଃଲା ଲକ୍‌କେ ହେଁ ତର୍‌ ହର୍‌ ଦେଉଁକେ ମର୍‌ ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ଅଃହ୍‌ଣାର୍‌ ଦଃନ୍‌କେ ନିଜାର୍‌ ମଃନ୍ ଇଚାୟ୍‌ ଦେଉଁକେ କାୟ୍‌ ମର୍‌ ଅଃଦିକାର୍‌ ନାୟ୍‌ ? କି ମୁଁୟ୍‌ ସଃତ୍‌ କାମ୍‌ କଃଲାକ୍‌ ଡାରା ଅଃଉଁଲାସ୍‌ ?’” ");
INSERT INTO bdv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ସେରଃକମ୍‌ ହଃଚେ ରିଲା ଲକ୍‌ ହଃର୍ତୁ ଅଃଉତି ଆର୍‌ ହଃର୍ତୁ ରିଲା ଲକ୍‌ ହଃଚେ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଜିରୁସାଲମ୍‌ ଜଃଉଁକେ ବାରାଉତା ବଃଳ୍‌ ବାର ଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଅଃଲ୍‌ଗା କଃରି ବାଟେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ଦଃକା, ଅଃମିମଃନ୍‌ ଜିରୁସାଲମେ ଜଃଉଁଲୁ, ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଆତେ ନଃରାର୍‌ ହୟ୍‌ସି ସଃହ୍ରି ଅୟ୍‌ଦ୍‌ । ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡାର୍‌ ଦସି କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ଆର୍‌ ଟାହ୍ରା କଃରୁକେ, ସାଟ୍‍ଣି ମାରୁକ୍‌ ଆର୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଅଃତ୍ୟା କଃରୁକେ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଦେତି; ଆର୍‌ ତିନିଦିନାର୍‌ ହଃଚେ ସେ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ସଃଡେବଃଳ୍‌ ଜେବଦିର୍‌ ଡକୁର୍ସି ଅଃହ୍‌ଣାର୍‌ ହୟ୍‌ସିମଃନ୍‌କେ ଦଃରି ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲି ଆର୍‌ ଜୁଆର୍‌ କଃରି ଦଃୟା କଃରୁକେ କୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ତାକ୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ରି ମଃନ୍ କଃରୁଲିସ୍‌ ?” ସେ ଜିସୁକେ କୟ୍‌ଲି, “ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ରାଇଜେ ରଃଜା ଅୟ୍‌ ଆୟ୍‌ଲେକ୍‌, ମର୍‌ ଇ ଜଳେକ୍‌ ହଅର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ତର୍‌ କାତା ବାଟ୍ୟା ଆରେକ୍‌ ଗଟେକ୍‌ ତର୍‌ ଡେବ୍ରି ବାଟ୍ୟା ବଃସୁକେ ଅଃଦିକାର୍‌ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ମଃତର୍‌ ଜିସୁ ଜେବଦିର୍‌ ଜୁଳେକ୍‌ ହୟ୍‌ସିକ୍‌ କୟ୍‌ଲା, “ତୁମି କାୟ୍‌ରି ମାଗୁଲାସ୍‌ ସେରି ଜାଣୁ ନଃହାରୁଲାସ୍‌ । ମୁଁୟ୍‌ ଜୁୟ୍‌ ଦୁକାର୍‌ କପାୟ୍‌ ସୁରୁକ୍‌ ଜଃଉଁଲେ, ସେତି କାୟ୍‌ ତୁମି ସୁରୁକ୍‌ ହାରାସ୍‌ ?” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ହାରୁନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ମର୍‌ ଦୁକାର୍‌ କପାୟ୍‌ ସୁରୁକ୍‌ ହାରାସ୍‌ ସଃତ୍‌, ମଃତର୍‌ ମର୍‌ କାତା ବାଟ୍ୟା ଆର୍‌ ଡେବ୍ରି ବାଟ୍ୟା କାକେ ବଃସୁକେ ଦେତାର୍‌ ମର୍‌ ଅଃଦିକାର୍‌ ନାୟ୍‌ । ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ମର୍‌ ଉବା ଟାଣ୍ ବାଚି ଆଚେ, ସେମଃନ୍ ହଃକା ବଃସ୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଜଃଡେବଃଳ୍‌ ବିନ୍ ଦଃସ୍‌ଗଟ୍‌ ଚେଲା ଇରି ସୁଣି ସେ ଦୁୟ୍‌ ବାୟ୍‌ର୍‌ ଉହ୍ରେ ରିସା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦି କୟ୍‌ଲା, “ଇ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ରଃଜାମଃନ୍ ବିନ୍ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃର୍ତି ଆର୍‌ ବଃଡ୍ ବଃଡ୍ ଲକ୍‌ମଃନ୍ ସେମଃନାର୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃକାଉତି, ଇରି ତୁମି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ତୁମାର୍‌ ବିତ୍ରେ ସେନ୍‌କାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଜେ ବଃଡ୍ ଅଃଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ବିନ୍ ଲକାର୍‌ ସେବାକାରି ହର୍‌ ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଆରେକ୍‌ ଆର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଜେ ସଃବ୍‌କେ ବଃଡ୍ ଅଃଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳା ହର୍‌ ସଃବ୍‌କାର୍‌ ସେବା କଃର । ");
INSERT INTO bdv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଜଃନ୍‌କଃରି ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ସେବା ହାଉଁକ୍‌ ନାସେ, ମଃତର୍‌ ସେବା କଃରୁକେ ଆର୍‌ ଗାଦେକ୍‌ ଲକାର୍‌ ଗିନେ ମୁକ୍ଳାଉତା ମଲ୍‌ ହର୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଦେଉଁକେ ଆସି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଜିରିହ ଗଃଳେହୁଣି ବାରାୟ୍‌ ଗଃଲା ବଃଳ୍‌, ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଆର୍‌ ବାଟ୍‌ ଲଃଗେ ବଃସିରିଲା ଜଳେକ୍‌ କାଣା ଜିସୁ ସେବାଟ୍‌ ଅୟ୍‌ ଜଃଉଁଲା ବଃଲି ସୁଣ୍‌ଲାୟ୍‌ ଆର୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ମାପ୍ରୁ, ଦାଉଦାର୍‌ ହୟ୍‌ସି, ଅଃମିକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ତୁନ୍‌ହାଳୁକେ ଦଃକା ଦିଲାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ଆରେକ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ମାପ୍ରୁ, ଦାଉଦାର୍‌ ହୟ୍‌ସି, ଅଃମିକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ତାର୍‌ହଃଚେ ଜିସୁ ଟିଆ ଅୟ୍‌ ସେମଃନ୍‌କେ କୁଦି ହଃଚାର୍ଲା, “ମୁଁୟ୍‌ ତୁମାର୍‌ ଗିନେ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ବଃଲି ତୁମି ମଃନ୍ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ମାପ୍ରୁ, ଜଃନ୍‌କଃରି ଅଃମାର୍‌ ଆକି ଉଗାଳି ଅଃଉଅ ଆର୍‌ ଅଃମି ଦଃକୁ ହାରୁନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଆର୍‌ ଜିସୁ ଦଃୟା କଃରୁକେ ମଃନ୍ କଃଲା, ଆର୍‌ ସେମଃନାର୍‌ ଆକି ଚୁୟ୍‌ଲା, ତଃବେ ସେଦାହ୍ରେ ସେମଃନ୍ ଦଃକୁକେ ହାର୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଇଣ୍ଡୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜଃଡେବଃଳ୍‌ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଜିରୁସାଲମ୍‌ ଲଃଗାର୍‌ ଜିତ୍‌ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ରିଲା ବେତ୍‌ପାଗି ଗାଉଁଏ ହଚ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜିସୁ ଜଳେକ୍‌ ଚେଲାକେ ଇ କଃତା କୟ୍‌ ହଃଟାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ତୁମାର୍‌ ମୁଆଁର୍‌ ସେ ଗାଉଁଏ ଜାହା, ଆର୍‌ ସେତି ହଚ୍‌ଲେକ୍‌, ସେତି ବାନ୍ଦ୍‌ଲାର୍‌ ଗଟେକ୍‌ ମାୟ୍‌ ଗଃଦ ଆର୍‌ ତାର୍‌ ଗଟେକ୍‌ ହିଲାଗଃଦକ୍‌ ଦଃକାସ୍‌; ସେମଃନ୍‌କେ ମେଲି ମର୍‌ ହାକ୍‌ ଆଣା । ");
INSERT INTO bdv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଆର୍‌ କେ ତୁମିକେ କାୟ୍‌ରି କୟ୍‌ଦ୍‌, ତଃବେ କଃଉଆ, ‘ଇମଃନାର୍‌ ତଃୟ୍‌ ମାପ୍ରୁର୍‌ ଲଳା ଆଚେ ।’ ସେଦାହ୍ରେ ସେ ସେମଃନ୍‌କେ ହଃଟାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ବାବ୍‌ବାଦିର୍‌ କଃତାମଃନ୍‌ ହୁରୁଣ୍ ଅଃଉଁକେ ଇରି ଅୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିଅନାର୍‌ ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌କେ କଃଉଆ, ‘ଦଃକ୍‌ ତର୍‌ ରଃଜା ତର୍‌ ଚଃମେ ଆସୁଲା ! ସେ ବଃଡେ ଦିରାର୍‌ ଆର୍‌ ହିଲାଗଃଦ ଉହ୍ରେ ବଃସି ଆଚେ, ଆର୍‌ ଗଃଦ ହିଲା ଉହ୍ରେ ଚଃଗି ଆସୁଲା ।’” ");
INSERT INTO bdv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ କଃତା ମାନି ସେନ୍ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ତାର୍‌ହଃଚେ ମାୟ୍‌ ଗଃଦ ଆର୍‌ ହିଲାଗଃଦକ୍‌ ଜିସୁର୍‌ ହାକ୍‌ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ ଉହ୍ରେ ବଃସ୍ତର୍‌ମଃନ୍ ଅଚାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ତାର୍‌ ଉହ୍ରେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଆରେକ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ବାଟେ ଅଚାୟ୍‌ଲାୟ୍‌ ଆର୍‌ କଃତେକ୍‌ କଃଜୁରି ଗଃଚାର୍‌ ଡାଳ୍‌ ମାରି ଆଣି ବାଟେ ଅଚାଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଆର୍‌ ଜିସୁର୍‌ ଆଗେ ଆର୍‌ ହଃଚେ ଜାତା ଲକ୍‌ମଃନ୍ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ହସାନ୍ନା, ଦାଉଦାର୍‌ ହୟ୍‌ସି, ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜେ ଆସୁଲା, ତାର୍‌ ଆସିର୍ବାଦ୍‌ ଅଃଉଅ, ସଃବ୍‌କେ ଉହ୍ରାର୍‌ ମାପ୍ରୁର୍‌ ଜଃଜ୍‌ମାନ୍ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଆରେକ୍‌ ଜିସୁ ଜିରୁସାଲମେ ଗଃଲାକେ ଜିରୁସାଲମ୍‌ ଗଃଳ୍‌ଜାକ “ଏ କେ ?” ବଃଲି ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଏ ଗାଲିଲି ରାଇଜାର୍‌ ନାଜରିତ୍‌ ଗାଉଁଆର୍‌ ବାବ୍‌ବାଦି ଜିସୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ତାର୍‌ହଃଚେ ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗଃଲା, ଆର୍‌ ସେତି ବିକାବାଞ୍ଜା କଃର୍ତା ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ବାର୍‌କଃଲା । ଆର୍‌ ଡାବୁ ବାଦ୍‌ଲାଉତା ବେବାରିମଃନାର୍‌ ଟେବୁଲ୍‌ ଆର୍‌ ହାଣ୍ଡ୍‌କା ବେବାରିମଃନାର୍‌ ବଃସ୍ତା କୁର୍ଚିମଃନ୍ ଉଲ୍‌ଟାୟ୍‌ ହଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ଅଃମାର୍‌ ଗଃର୍‌ ଇସ୍ୱରାର୍‌ ପାର୍ତ୍‌ନାଗଃର୍‌ ବଃଲି ଡାକେ ହୁଟେଦ୍‌,’ ମଃତର୍‌ ତୁମିମଃନ୍ ତାକ୍‌ କଃଙ୍ଗାର୍‌ମଃନ୍ ଲୁକ୍‌ତା ହାର୍‌ କଃରୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଆରେକ୍‌ କାଣା ଆର୍‌ ମେଟା ଲକ୍‌ମଃନ୍ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଜିସୁର୍‌ ତଃୟ୍‌ ଆୟ୍‌ଲାକ୍‌, ସେ ସେମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ମଃତର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ମଃନ୍‌ ତାର୍‌ କାବା ଅଃଉତା କାମ୍‌ ସଃବୁ ଆର୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ, “ଦାଉଦାର୍‌ ହୟ୍‌ସିର୍‌ ଜୟ୍‌ ଅଃଉଅ,” ବଃଲି ଉଲ୍‌ଗାଟ୍‌ ଅଃଉତା ହିଲାମଃନ୍‌କେ ଦଃକି ରିସା ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଇମଃନ୍‌ କାୟ୍‌ ବଃଲି କଃଉଁଲାୟ୍‌, ସେରି କାୟ୍‌ ତୁୟ୍‌ ସୁଣୁଲିସ୍‌ ?” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ହେଁ ସୁଣୁଲେ । ତୁମିମଃନ୍ କାୟ୍‌ ଇ କଃତା କଃବେହେଁ ଦଃର୍ମ୍‌ ସାସ୍ତରେ ହଳି ନଃକେରାସ୍‌, ‘ତୁମି ସାନ୍ ହିଲା ଆର୍‌ ଦୁଦ୍‌ କାତା ହିଲାମଃନ୍‌କେ ଟିକ୍‌ ବାବେ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ସିକାୟ୍‌ ଆଚାସ୍‌ ?’” ");
INSERT INTO bdv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଚାଡି ଜିରୁସାଲମେ ହୁଣି ବାରାୟ୍‌ ବେତାନିଆକେ ଗଃଲା ଆର୍‌ ସେ ରାତି ସେତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ଆର୍‌କ ଦିନ୍ ସଃକାଳ୍ୟା ଜିସୁ ଜିରୁସାଲମ୍‌ ଗଃଳେ ବାଉଳ୍‌ତା ବଃଳ୍‌ ତାକ୍‌ ବୁକ୍‌ ଲାଗ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ଆର୍‌ ବାଟ୍‌ ହାଳାୟ୍‌ ଗଟେକ୍‌ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ ଦଃକି ତାର୍‌ ଚଃମେ ଗଃଲା, ସେ ଗଃଚେ ହଃତାର୍‌ ଚାଡି କାୟ୍‌ରି ହେଁ ନଃହାୟ୍‌ଲାକେ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ କୟ୍‌ଲା, “ସଃବୁ ଦିନ୍‌ ହେଁ ତର୍‌ ତଃୟ୍‌ ହଃଳ୍‌ ନଃଦେର ।” ସେତାର୍‌ଗିନେ ସେଦାହ୍ରେ ସେ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ ସୁକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ଚେଲାମଃନ୍ ସେରି ଦଃକି କାବା ଅୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ କଃନ୍‌କଃରି ସେଦାହ୍ରେ ସୁକ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଜଦି ତୁମାର୍‌ ବିସ୍ୱାସ୍‌ ଆଚେ, ଆର୍‌ ତୁମିମଃନ୍ ଅବିସ୍ୱାସ୍‌ ନଃକେରାସ୍‌, ତଃବେ ଇ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ ଜଃନ୍‌କାର୍‌ ଅୟ୍‌ଆଚେ, ଅଃତେକ୍‌ ହଃକା କଃରାସ୍‌ ସେରି ନାୟ୍‌, ମଃତର୍‌ ଜଦି ଇ ଡଙ୍ଗୁର୍‌କେ ହେଁ ‘ଉଟ୍‌କି ଅୟ୍‌ ସଃମ୍‌ନ୍ଦେ ଜାୟ୍‌ ଅଦୁର୍‌’ ବଃଲି କଃଉଆସ୍‌, ତଃବେ ସେରଃକମ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ଆରେକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ପାର୍ତ୍‌ନା କଃରାସ୍‌ ଆର୍‌ ଜାୟ୍‌ରି ମାଗାସ୍‌ ସେରି ସଃବୁ ହାଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ତାର୍‌ହଃଚେ ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି ସିକ୍ୟା ଦେତାବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ତାର୍‌ ଚଃମେ ଆସି ହଃଚାର୍ଲାୟ୍‌, “ତୁୟ୍‌ କୁୟ୍‌ ଅଃଦିକାର୍‌ ଦଃରି ଇସଃବୁ କଃରୁଲିସ୍‌, ଆର୍‌ ତକେ କେ ଇ ଅଃଦିକାର୍‌ ଦିଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ହେଁ ତୁମିମଃନ୍‌କେ ଗଟେକ୍‌ କଃତା ହଃଚାରିନ୍ଦ୍, ଜଦି ତୁମିମଃନ୍ ମକେ ସେରି କଃଉଆସ୍‌, ତଃବେ ମୁଁୟ୍‌ କୁୟ୍‌ ଅଃଦିକାରେ ଇ ସଃବୁ କଃରୁଲେ ସେରି କୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଜହନ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଅଃଦିକାର୍‌ କାର୍‌ ତଃୟ୍‌ହୁଣି ହାୟ୍‌ରିଲା ? ସଃର୍ଗେ ହୁଣି କି ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ?” ସେତାକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟଃଲାୟ୍‌, ଆର୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଜଦି ସଃର୍ଗେ ହୁଣି ବଃଲି କଃଉନ୍ଦ୍, ତଃବେ ସେ ଅଃମିକ୍‌ କୟ୍‌ଦ୍‌, ‘ତଃବେ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଜହନ୍‌କେ ବିସ୍ୱାସ୍‌ ନଃକେଲାସ୍‌ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ଜଦି ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବଃଲି କଃଉନ୍ଦ୍, ତଃବେ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ଜହନ୍‌କେ ବାବ୍‌ବାଦି ବଃଲି ମାନୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଅଃମି ନଃଜାଣୁ ।” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ମୁଁୟ୍‌ କୁୟ୍‌ ଅଃଦିକାରେ ଇ ସଃବୁ କଃରୁଲେ, ସେରି ମୁଁୟ୍‌ ହେଁ ତୁମିକେ ନଃକୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ମଃତର୍‌ ତୁମିମଃନ୍ ଇ କଃତାକ୍‌ କାୟ୍‌ରି ବାବୁଲାସ୍‌ ? ଗଟେକ୍‌ ଲକାର୍‌ ଜଳେକ୍‌ ହୟ୍‌ସି ରିଲାୟ୍‌, ସେ ବଃଡ୍ ହୟ୍‌ସି ହାକ୍‌ ଆସି କୟ୍‌ଲା, ‘ବାୟ୍‌ ଜାଆ, ଆଜି ଅଙ୍ଗୁର୍‌ ବାଳେ ହାୟ୍‌ଟି କଃର୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ବଃଡ୍ ହୟ୍‌ସି କୟ୍‌ଲା, ‘ମର୍‌ ମଃନ୍ ନାୟ୍‌,’ ମଃତର୍‌ ହଃଚେ ମଃନ୍ ବାଦ୍‌ଲାୟ୍‌ କଃରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଆର୍‌ ସାନ୍ ହୟ୍‌ସିର୍‌ ହାକ୍‌ ଆସି କୟ୍‌ଲା, ‘ବାୟ୍‌, ଜାଆ ଅଙ୍ଗୁର୍‌ ବାଳେ ହାୟ୍‌ଟି କଃର୍‌,’ ସେ କୟ୍‌ଲା, ‘ମାପ୍ରୁ ଜଃଉଁଲେ,’ ମଃତର୍‌ ସେ ନଃଗେଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଇ ଦୁୟ୍‌ଲକାର୍‌ ବିତ୍ରେ କେ ଉବାସିର୍‌ କଃତା ମାନ୍‌ଲା ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ବଃଡ୍ ହୟ୍‌ସି ।” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ରିବ୍‌ନି ଆର୍‌ ବେସୁଆମଃନ୍ ତୁମାର୍‌ ଆଗ୍‌ତୁ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜାତି । ");
INSERT INTO bdv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜହନ୍‌ ତୁମାର୍‌ ହାକ୍‌ ଦଃର୍ମାର୍‌ ବାଟ୍‌ ଅୟ୍‌ ଆୟ୍‌ଲା ଆର୍‌ ତୁମିମଃନ୍ ତାକ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେଲାସ୍‌, ମଃତର୍‌ ରିବ୍‌ନି ଆର୍‌ ବେସୁଆମଃନ୍ ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଇଚା ବିସ୍ୱାସ୍‌ କଃରୁ ହାରାସ୍‌, ଇତାର୍‌ ଗିନେ ସେରି ଦଃକି ହେଁ ମଃନ୍ ନଃବାଦ୍‌ଲାୟ୍‌ଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଜିସୁ କୟ୍‌ଲା, “ଆରେକ୍‌ ଗଟ୍‌ କଃତା ସୁଣା, ଗଟେକ୍‌ ସାଉକାର୍‌ ରିଲା, ସେ ଗଟେକ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ କଃରି ଚାରି ବେଳ୍‌ତ୍ ବାଳ୍‌ ବୁଣ୍‌ଲା ଆର୍‌ ମଃଜାୟ୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହିଳ୍‌ତା ଗଃଣା ବଃସାଇଲା, ଆର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ ଜାଗ୍‌ତା ମାଚା ବାନ୍ଦ୍‌ଲା । ଆରେକ୍‌ ତାସିମଃନ୍‌କେ ସେ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ ବାଗେ ଦିଲା ଆର୍‌ ବିଦେସ୍‌ ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ତାର୍‌ହଃଚେ ହଃଳ୍‌ କଳ୍‌ତା ବେଳା ଅୟ୍‌ଲାକ୍‌, ସେ ତାର୍‌ ବାଗ୍ ହାଉଁକ୍‌ ବାଗ୍ ତାସିମଃନାର୍‌ ହାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ମଃତର୍‌ ବାଗ୍ ତାସିମଃନ୍ ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ଗଟେକ୍‌କେ ଦଃରିକଃରି ମାଡ୍ ମାର୍ଲାୟ୍‌, ଆରେକ୍‌ ଗଟେକ୍‌କେ ମଃର୍ନେ ମାର୍ଲାୟ୍‌, ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଟେଳା ସୁତି ମାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଆରେକ୍‌ ସେ ହଃର୍ତୁ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ହଃଟାୟ୍‌ଲା, ଆରେକ୍‌ ବାଗ୍ ତାସିମଃନ୍ ସେମଃନ୍‌କେ ହେଁ ସେନ୍‌କାର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘ମଃତର୍‌ ମର୍‌ ହଅକେ ସେମଃନ୍ ମାନ୍‌ତି କଃର୍ତି,’ ଇରି କୟ୍‌ ହଃଚେ ଅଃହ୍‌ଣାର୍‌ ହୟ୍‌ସିକେ ସେମଃନାର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ମଃତର୍‌ ସେ ବାଗ୍ ତାସିମଃନ୍ ହୟ୍‌ସିକ୍‌ ଦଃକି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟଃଲାୟ୍‌, ‘ଏ ତ ସାଉକାରାର୍‌ ହୟ୍‌ସି, ଆସା ଆକ୍‌ ମଃର୍ନେ ମାରି, ଇତାର୍‌ ଅଃଦିକାର୍‌ ଅଃମାର୍‌ ଆତେ ନେଉଁଆ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ତାର୍‌ହଃଚେ ତାକ୍‌ ଦଃରି ଅଙ୍ଗୁର୍‌ ବାଳେହୁଣି ହଃଦାୟ୍‌ ହଃକାୟ୍‌ ମଃର୍ନେ ମାର୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁ ହଃଚାର୍ଲା, “ତଃବେ ଜଃଡେବଃଳ୍‌ ସେ ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସାଉକାର୍‌ ଆସେଦ୍‌ ସଃଡେବଃଳ୍‌ ସେ ବାଗ୍ ତାସିମଃନ୍‌କେ କାୟ୍‌ କଃରେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ସାଉକାର୍‌ ସେ ଦୁସ୍ଟ୍‌ମଃନ୍‌କେ ବଃଡେ ଆର୍ଲାକଃରି ମଃରାୟ୍‌ଦ୍‌, ଆର୍‌ ଜୁୟ୍‌ ବାଗ୍ ତାସିମଃନ୍ ଟିକ୍‌ ବେଳାୟ୍‌ ତାର୍‌ ବାଗାର୍‌ ହଃଳ୍‌ ଦେତି, ସେମଃନ୍‌କେ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ ବାଗ୍‌ତାସ୍‌ କଃରୁକେ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ କଃବେ ହେଁ ଦଃର୍ମ୍‌ ସାସ୍ତରେ ଇ କଃତା ନଃହଳାସ୍‌ ? ‘ଗଃର୍‌ ବାନ୍ଦ୍‌ତା ଲକ୍‌ମଃନ୍ ଜୁୟ୍‌ ଟେଳାକେ ଦୁର୍‌କଃଲାୟ୍‌, ସେରି କନାର୍‌ ମୁଳ୍‌ ଟେଳା ଅୟ୍‌ଲି । ମାପ୍ରୁର୍‌ ତଃୟ୍‌ହୁଣି ଇରି ଅୟ୍‌ଲି, ଆର୍‌ ସେରି ଅଃମାର୍‌ ଗିନେ କାବା ଅଃଉତା କଃତା ।’” ");
INSERT INTO bdv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି କାଡି ନିଆ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ଇଚା ହୁରୁଣ୍ କଃର୍ତି, ସେମଃନ୍‌କେ ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଆର୍‌ ଜେ ଇ ଟେଳା ଉହ୍ରେ ଅଦ୍ରେଦ୍‌ ସେ ହୁଟିକଃରି କଃଣ୍ଡ୍‌ କଃଣ୍ଡ୍‌ ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଇ ଟେଳା ଜାର୍‌ ଉହ୍ରେ ଅଦ୍ରେଦ୍‌ ତାକ୍‌ ସେରି ଗୁଣ୍ଡ୍‌ଗୁଣ୍ଡା କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ତାର୍‌ ଇ ସଃବୁ କଃତାମଃନ୍‌ ସୁଣ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ଜେ ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ କୟ୍‌ଲା ବଃଲି ବୁଜ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ତାକ୍‌ ଦଃରୁକ୍‌ ଉପାୟ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍‌ଲାୟ୍‌, ବଃଲେକ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ବାବ୍‌ବାଦି ବଃଲି ମାନ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ଆରେକ୍‌ କଃତାମଃନ୍‌ କୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦିଲା, ");
INSERT INTO bdv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇବାନ୍ୟା । ଗଟେକ୍‌ ରଃଜା ତାର୍‌ ହୟ୍‌ସିର୍‌ ବିବାବଜି କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଆର୍‌ ସେ ବଜି ତଃୟ୍‌ ଆସ୍ତା ଲକ୍‌ମଃନ୍‌କେ କୁଦୁକେ ସେ ରଃଜା ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ହଃଟାୟ୍‌ଲା, ମଃତର୍‌ ସେ ଲକ୍‌ମଃନ୍ ଆସୁକ୍‌ ମଃନ୍ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ସେ ଆରେକ୍‌ ବିନ୍ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ଇ କଃତା କୟ୍‌କଃରି ହଃଟାୟ୍‌ଲା, ‘ବଜିକେ ଆସ୍ତା ଲକ୍‌ମଃନ୍‌କେ କଃଉଆ, ଦଃକା ଅଃମି ବଜି ରାନ୍ଦି ସଃର୍ଲୁନି, ଅଃମାର୍‌ ଦୁମାଦୁମା ଚେଳି ଆର୍‌ ମେଣ୍ଡାମଃନ୍ ମାର୍‌ଲୁ ଆଚୁ । ସଃବୁ ତିଆର୍‌ ଅୟ୍‌ଲି ଆଚେ ତୁମିମଃନ୍ ବିବା ବଜିକେ ଆସା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ମଃତର୍‌ ସେ ବଜିକେ ଆସ୍ତା ଲକ୍‌ମଃନ୍ ରଃଜାର୍‌ କଃତାକ୍‌ ଅମାନ୍ୟା କଃରି କେ ତ ଅଃହ୍‌ଣାର୍‌ ତାସ୍‌ ହଃଦାୟ୍‌ ଆର୍‌ କେ ତ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବେବାର୍‌କେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ବାକି ଲକ୍‌ମଃନ୍ ରଃଜାର୍‌ ଗତି ଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କେ ଦଃରିକଃରି ଆର୍ଲା କଃଲାୟ୍‌ ଆର୍‌ ମଃର୍ନେ ହେଁ ମାର୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ମଃତର୍‌ ରଃଜା ଇ କଃତା ସୁଣି ଜଃବର୍‌ ରିସା ଅୟ୍‌ଲା ଆର୍‌ ସେ ତାର୍‌ ସଃଇନ୍ ମଃନ୍‌କେ ହଃଟାୟ୍‌ କଃରି ସେ ହଃତ୍ୟାକାରିମଃନ୍‌କେ ମଃର୍ନେ ମାରାୟ୍‌ଲା, ଆର୍‌ ସେମଃନାର୍‌ ଗଃଳ୍‌କେ ବଃସମ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତାର୍‌ହଃଚେ ରଃଜା ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ କୟ୍‌ଲା, ‘ବିବା ବଜି ତ ରାନ୍ଦା ଅୟ୍‌ଲି ଆଚେ, ମଃତର୍‌ ମୁଁୟ୍‌ କୁଦି ରିଲା ଲକ୍‌ମଃନ୍ ବଜି କାଉଁକେ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଅଃବେ ତୁମିମଃନ୍ ଗଃଳାର୍‌ ସଃବୁ ବଃଡ୍ ବଃଡ୍ ସାଉଳିମଃନ୍‌କେ ଜାହା ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକାସ୍‌, ସେ ସଃବୁ ଲକ୍‌କେ କୁଦି ଆଣା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ସେତାକ୍‌ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ ସେ ବଃଡ୍ ବଃଡ୍ ସାଉଳିମଃନ୍‌କେ ଗଃଲାୟ୍‌ ଆର୍‌ ସେତି ସଃତ୍‌ ଆର୍‌ ଜଃତେକ୍‌ ଦୁସ୍ଟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକ୍‌ଲାୟ୍‌, ସେ ସଃବ୍‌କେ ରୁଣ୍ଡାୟ୍‌ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ସେସଃବୁ ଲକ୍‌ମଃନ୍ ବିବା ବଃଙ୍ଗ୍‌ଲାୟ୍‌ ବଃର୍ତି ଅୟଃଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ମଃତର୍‌ ରଃଜା ବିବା ବଜିୟେ କୁଦ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଦଃକୁକେ ବିତ୍ରେ ଆସି ସେ ସେତି ବିବା ବଃସ୍ତର୍‌ ହିନ୍ଦିନଃରିଲା ଗଟେକ୍‌ ମାନାୟ୍‌କେ ଦଃକି କଃରି ତାକ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘ଏ ବାୟ୍‌, ତୁୟ୍‌ ବିବା ହଃଚ୍ୟା ନଃହିନ୍ଦି କଃନ୍‌କଃରି ଇ ଟାଣେ ଆସି ଆଚ୍‌ସି ?’ ମଃତର୍‌ ସେମାନାୟ୍‌ କାୟ୍‌ବଃଲି ହେଁ ଉତୁର୍‌ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ସେତାକ୍‌ ରଃଜା ତାର୍‌ ସେବାକାରି ମଃନ୍‌କେ କୟ୍‌ଲା, ‘ଇ ମାନାୟ୍‌ର୍‌ ଆତେ ଗଡେ ବାନ୍ଦି ଆକ୍‌ ହଃଦାର୍‌ ଅଃନ୍ଦାରେ ହଃକାଉଆ, ତଃବେ ସେ ସେତି କାନ୍ଦି କାନ୍ଦି ଦାତ୍‌ ଚାବି ଅୟ୍‌ଦ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଜିସୁ କୟ୍‌ ସଃରାୟ୍‌ ଇରି କୟ୍‌ଲା, “ବଃଲେକ୍‌ କୁଦ୍‌ଲା ଲକ୍‌ ଗାଦେକ୍‌, ମଃତର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ ଉଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ସଃଡେବଃଳ୍‌ ପାରୁସିମଃନ୍ ସେତିହୁଣି ବାରାୟ୍‌ ଜାୟ୍‌ ଜିସୁକେ କଃତା ହଃଚାରି କଃରି ହାନ୍ଦେ ହଃକାଉଁକ୍‌ ସେମଃନ୍ କୁଟ୍‌ ହାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ତଃବେ ସେମଃନ୍ ତାକାର୍‌ ଚେଲାମଃନ୍‌କେ ହେରଦିୟ ଦଃଳାର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜିସୁର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଜାୟ୍‌ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମି ଜାଣୁଲୁ, ତୁୟ୍‌ ସଃତ୍‌ ଆର୍‌ ସଃତ୍‌ ବାବେ ଇସ୍ୱରାର୍‌ ଇସାବେ ସିକ୍ୟା ଦେଉଁଲିସ୍‌, ଆରେକ୍‌ ତୁୟ୍‌ କାକେ ହେଁ ନଃଡିରୁଲିସ୍‌ ବଃଲେକ୍‌ ତୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ମୁକ୍‌ମେଟ୍‌ ନଃଦେକ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ତଃବେ ଅଃମିକ୍‌ କଃଉ, ରମ୍‌ ଦେସାର୍‌ ରଃଜା କାଇସର୍‌କେ ଅଃମି ସିସ୍ଟୁ ଦେତାର୍‌ ବିଦି କି ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ କୁଟ୍‌ ଜାଣି କୟ୍‌ଲା, “ରେ ହେଟ୍‌କପଟ୍ୟାମଃନ୍, କାୟ୍‌ତାକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ଉପାୟ୍‌ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ସେ ସିସ୍ଟୁ ଦେତା ଡାବୁ ମକ୍‌ ଦଃକାଉଆ ।” ତଃବେ ସେମଃନ୍ ଗଟ୍‌ କାସୁ ତାକ୍‌ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ଇ ମୁର୍ତି ଆର୍‌ ନାଉଁ କାର୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ରମ୍‌ ରାଜିର୍‌ ରଃଜା କାଇସରାର୍‌ ।” ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ଜୁୟ୍‌ରି କାଇସରାର୍‌, ସେରି କାଇସର୍‌କେ ଦିଆସ୍‌; ଆର୍‌ ଜୁୟ୍‌ରି ଇସ୍ୱରାର୍‌ ସେରି ଇସ୍ୱର୍‌କେ ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ସେମଃନ୍ ଇ କଃତା ସୁଣି କାବା ଅୟଃଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ ଚାଡି ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ସେ ଦିନ୍ ସାଦୁକିମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ମଃଲା ଲକ୍‌ମଃନ୍ ଆରେକ୍‌ ଉଟ୍‌ତି ବଃଲି ନଃମାନ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ମସା କୟ୍‌ଆଚେ ଜେ, କେ ଜଦି ବିବା ଅୟ୍‌ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃରେଦ୍‌, ତଃବେ ତାର୍‌ ବାୟ୍‌ସି, ମଃରୁ ବାୟ୍‌ସିର୍‌ ଡକୁର୍ସିକେ ବିବା ଅୟ୍‌ ସେ ତାର୍‌ ବାୟ୍‌ସିର୍‌ ଗିନେ ହିଲା ଜଃଲମ୍‌ କଃରେଦ୍‌ ଆର୍‌ ସେ ହିଲା ସେ ମଃଲା ବାୟ୍‌ସିର୍‌ ବଃଉଁସ୍‌ ବାଡାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ତଃବେ ଦଃକ୍‌, ଅଃମାର୍‌ ବିତ୍ରେ ସାତ୍‌ ବାୟ୍‌ ରିଲାୟ୍‌, ହଃର୍ତୁ ବାୟ୍‌ ବିବା ଅୟ୍‌ ମଃଲା, ଆର୍‌ ହିଲାଟକି ନଃରିଲାକ୍‌ ତାର୍‌ ଡକୁର୍ସିକେ ତାର୍‌ ହିଟିର୍‌ ବାୟ୍‌ସି ସଃଙ୍ଗାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ତାର୍‌ ହିଟିର୍‌ ବାୟ୍‌ସି ଆରେକ୍‌ ତାର୍‌ ହିଟିର୍‌ ବାୟ୍‌ସି, ଇ ରଃକମ୍‌ ସାତ୍‌ ବାୟ୍‌ ଜାକ ହେଁ ସେ ଟକିକେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ହିଲାଟକି ନଃଉତ୍‌ ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ହଃଚେ ସେ ମାୟ୍‌ଜି ହେଁ ମଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ତଃବେ ହଃଚେ ଜଃଡେବଃଳ୍‌ ମଃଲାଲକ୍‌ମଃନ୍ ଉଟ୍‌ତି ଆଚେ ସଃଡେବଃଳ୍‌ ସେ ମାୟ୍‌ଜି ସାତ୍‌ ବାୟ୍‌ ବିତ୍ରାର୍‌ କାର୍‌ ଡକୁର୍ସି ଅୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ସେ ସାତ୍‌ ବାୟ୍‌ ହେଁ ତ ତାକ୍‌ ସଃଙ୍ଗାୟ୍‌ ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ସଃକ୍ତି ହେଁ ନଃଜାଣି ବୁଲ୍‌କି ଜଃଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ବଃଲେକ୍‌ ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟ୍‌ତି ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ବିବା ନଃକେର୍ତି କି ବିବା ନଃଉତି । ମଃତର୍‌ ସେମଃନ୍ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନାର୍‌ ହର୍‌ ଅୟ୍‌ ରେତି । ");
INSERT INTO bdv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟ୍‌ତାର୍‌ କଃତା ଇସ୍ୱର୍‌ ଜୁୟ୍‌ରି ତୁମିମଃନ୍‌କେ କୟ୍‌ଲା ଆଚେ, ସେରି କି କଃବେ ତୁମିମଃନ୍ ନଃହଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ଅଃମି ଅବ୍ରାହାମାର୍‌ ଇସ୍ୱର୍‌, ଇସାକାର୍‌ ଇସ୍ୱର୍‌ ଆର୍‌ ଜାକୁବର୍‌ ଇସ୍ୱର୍‌ ।’ ସେ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ଇସ୍ୱର୍‌ ନୟ୍‌, ମଃତର୍‌ ବଚ୍‌ଲା ଲକାର୍‌ ଇସ୍ୱର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଜିସୁର୍‌ ଇ ସିକ୍ୟା ସୁଣିକଃରି ଲକ୍‌ମଃନ୍ ବଃଡେ କାବା ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଜିସୁ ସାଦୁକିମଃନ୍‌କେ ତୁନ୍‌ ହାଳାୟ୍‌ଲା ଆଚେ ବଃଲି ସୁଣି ପାରୁସିମଃନ୍ ଗଟେତଃୟ୍‌ଁ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ବିଦି ସିକାଉ ଜିସୁକେ ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ହଃଚାର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଏ ଗୁରୁ, ମସାର୍‌ ବିଦି ବିତ୍ରେ କୁୟ୍‌ ଆଦେସ୍‌ ବଃଡ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ମଃନ୍‌, ସଃବୁ ଜିବନ୍‌, ସଃବୁ ମଃନ୍ ଦଃୟ୍‌ ମାପ୍ରୁ ଅଃହ୍‌ଣାର୍‌ ଇସ୍ୱର୍‌କେ ଲାଡ୍‌ କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଇରି ଅଃଉଁଲି ସଃବ୍‌କେ ବଃଡ୍ ଆର୍‌ ହଃର୍ତୁ ଆଦେସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ତାର୍‌ ହଃଚାର୍‌ ବଲ୍‌ ହେଁ ଇ ବଲ୍‌ ହର୍‌, ‘ତୁମି ଅଃହ୍‌ଣାର୍‌ ହାକିହଃଳ୍‌ସାକେ ଅଃହ୍‌ଣାକ୍‌ ଲାଡ୍‌ କଃଲା ହର୍‌ ଲାଡ୍‌ କଃରା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଇ ଜଳେକ୍‌ ଆଦେସ୍‌ ଉହ୍ରେ ମସାର୍‌ ସଃର୍ନେ ବିଦି ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ସିକ୍ୟା ବଃର୍ସା କଃରୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ପାରୁସିମଃନ୍ ଗଟେଟାଣେ ରୁଣ୍ଡି ରିଲାବଃଳ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କ୍ରିସ୍ଟ ବଃଲେକ୍‌ ମସିଅକ୍‌ କେ ବଃଲି ତୁମିମଃନ୍ କାୟ୍‌ରି ବାବୁଲାସ୍‌, ସେ କାର୍‌ ହୟ୍‌ସି ?” ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଦାଉଦାର୍‌ ହୟ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ଦାଉଦ୍‌ ମସିଆକ୍‌ ‘ମର୍‌ ମାପ୍ରୁ’ ବଃଲି କାୟ୍‌ତାକ୍‌ କୟ୍‌ଆଚେ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଆତ୍ମା ତଃୟ୍‌ହୁଣି ସେ ଇରି ଲେକିଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ମାପ୍ରୁ ମର୍‌ ମାପ୍ରୁକ୍‌ କୟ୍‌ଲା, ମୁୟ୍‌ ଜଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ତୁମାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ, ତୁମାର୍‌ ହାଦ୍‌ ତଃଳେ ନଃକେରି ଆଚୁ, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ମର୍‌ କାତାକୁଚି ବାଟ୍‌ ବଃସିରେ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ଜଦି ଦାଉଦ୍‌ ମସିଆକ୍‌ ‘ମର୍‌ ମାପ୍ରୁ’ ବଃଲି କୟ୍‌ଆଚେ, ତଃବେ କ୍ରିସ୍ଟ କଃନ୍‌କଃରି ଦାଉଦାର୍‌ ହୟ୍‌ସି ଅଃଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ତଃବେ ଜିସୁକେ କେହେଁ ହଃଦେକ୍‌ କଃଉଁକେ ନଃହାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେଦିନ୍ ହୁଣି କେହେଁ ତାକ୍‌ କାୟ୍‌ କଃତା ହେଁ ହଃଚାରୁକ୍‌ ସାସ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ସଃଡେବଃଳ୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍ ମସାର୍‌ କୁର୍ଚି ଉହ୍ରେ ବଃସି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ତଃବେ ସେମଃନ୍ ଜୁୟ୍‌ରି ସଃବୁ କଃରୁକେ କଃଉଁଲାୟ୍‌, ସେ ସଃବୁ ମାନା ଆର୍‌ କଃରା, ମଃତର୍‌ ସେମଃନାର୍‌ କାମ୍‌ ହର୍‌ ତୁମିମଃନ୍ କଃରାନାୟ୍‌, ବଃଲେକ୍‌ ସେମଃନ୍ ଜାୟ୍‌ରି ସିକାଉତି ସେରି ନଃକେର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ସେମଃନ୍ ସିକ୍ୟା ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ହିଟି ଉହ୍ରେ ଜଃବର୍‌ ବଜ୍‌ ହର୍‌ ଲାଦିଦେତି, ମଃତର୍‌ ନିଜେ ଆଙ୍ଗଟି ସଃଙ୍ଗ୍ ହେଁ ସେରି ଟେକି ଦେଉଁକେ ମଃନ୍ ନଃକେର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଦଃକାଉଁକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସଃବୁ କଃର୍ତା କାମ୍‌ କଃର୍ତି, ସେମଃନ୍ ସାସ୍ତର୍‌ ବଃଚନ୍ ଲେକାହାଟା କଃହାଳେ ଆର୍‌ ଡେଣାୟ୍‌ ବାନ୍ଦି ଅଃଉତି, ଆର୍‌ ଦଃକା, ସେମଃନ୍ ହିନ୍ଦିରେତା ବଃସ୍ତରାର୍‌ ଆଚଳ୍‌ ସଃବୁ ଅଃନାୟ୍‌ ଡେଙ୍ଗ୍, ");
INSERT INTO bdv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଆର୍‌ ବଜିଲଃଗେ ବଃଡ୍ ଟାଣେ ବଃସୁକେ ଆର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ବଃଡ୍ କୁର୍ଚି ଉହ୍ରେ ବଃସୁକେ ମଃନ୍ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ଆର୍‌ ସେମଃନ୍ ଆଟେ ବଃଜାରେ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜୁଆର୍‌ ହାଉଁକେ, ଆର୍‌ ଲକ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ‘ଏ ଗୁରୁ’ ବଃଲି କଃଉଅତ୍‌ ବଃଲି ମଃନ୍ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମଃତର୍‌ ତୁମିମଃନ୍ ‘ଗୁରୁ’ ବଃଲାୟ୍‌ ଅଃଉଆ ନାୟ୍‌, ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ଗୁରୁ ଅଃକାୟ୍‌ ଗଟେକ୍‌, ଆରେକ୍‌ ତୁମିମଃନ୍ ସଃବୁ ବାୟ୍‌ ବାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଆର୍‌ ତୁମିମଃନ୍ ଇ ହୁର୍ତିବିଏ କାକେ ହେଁ ‘ଉବା’ ବଃଲି କଃଉଆ ନାୟ୍‌, ବଃଲେକ୍‌ ତୁମାର୍‌ ଉବାଦି ଗଟେକ୍‌ ସେ, ସେ ସଃର୍ଗେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଆର୍‌ ତୁମିମଃନ୍ ‘ମୁଳିକା’ ବଃଲି କଃଉଆୟ୍‌ ଅଃଉଆ ନାୟ୍‌, ବଃଲେକ୍‌ ତୁମାର୍‌ ମୁଳିକା ଗଟେକ୍‌, ସେ କ୍ରିସ୍ଟ । ");
INSERT INTO bdv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଲକ୍‌ ବଃଡ୍, ସେ ତୁମାର୍‌ ସେବାକାରି ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାକ୍‌ ବଃଡ୍ ବଃଲି ଦଃକାୟ୍‌ ଅୟ୍‌ଦ୍‌, ତାକ୍‌ ସାନ୍ କଃରା ଅୟ୍‌ଦ୍‌, ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାକ୍‌ ସାନ୍ କଃରେଦ୍‌, ତାକ୍‌ ବଃଡ୍ କଃରା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ମଃତର୍‌ ଏ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ସଃର୍ଗ୍‌ ରାଇଜେ ଜାତା ବାଟ୍‌କେ ବଃନ୍ଦ୍‌ କଃରୁଲାସ୍‌; ତୁମିମଃନ୍ ତ ନିଜେ ସଃର୍ଗ୍‌ ରାଇଜେ ନଃଜଃଉଁଲାସ୍‌ ଆରେକ୍‌ ସଃର୍ଗେ ଜାତା ଲକ୍‌ମଃନ୍‌କେ ହେଁ ଜଃଉଁକେ ନଃଦେଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଏ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟିଆ ସାସ୍ତ୍ରି ଆର୍‌ ପାରୁସିମଃନ୍, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ହଲ୍ୟାୟ୍‌ ଡେଙ୍ଗ୍ ପାର୍ତ୍‌ନା କଃରାସ୍‌, ଆର୍‌ ରାଣ୍ଡି ମାୟ୍‌ଜିମଃନାର୍‌ ଗଃର୍‌ସଃବୁ ଜୁରି ନେଉଁଲାସ୍‌, ଇତାର୍‌ ଗିନେ ତୁମିମଃନ୍ ବଃଡେ ଡଃଣ୍ଡ୍‌ ହାଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ଏ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଗଟେକ୍‌ ଲକ୍‌କେ ତୁମାର୍‌ ଦଃର୍ମେ ମିସାଉଁକେ ସଃବୁ ସଃମ୍‌ନ୍ଦ୍ ଆର୍‌ ସେହାଟିର୍‌ ଦେସ୍‌ ବୁଲ୍‌ତିରିଆସ୍‌, ଆରେକ୍‌ ଜଃଡେବଃଳ୍‌ ସେ ତୁମାର୍‌ ଦଃର୍ମେ ମିସେଦ୍‌, ସଃଡେବଃଳ୍‌ ତାକ୍‌ ତୁମିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଦୁୟ୍‌ ଗୁଣ୍ ନଃର୍କେ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ଜୟ୍‌ଗ୍‌ କଃରାଉଁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ଏ ବଃଡେ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ଜେ, ତୁମି କାଣା ଲକ୍‌କେ ବାଟ ଦଃକାଉତା କାଣାମଃନ୍, ତୁମିମଃନ୍ କଃଉତି ରିଆସ୍‌, ‘କେ ମନ୍ଦିର୍‌ ହଃର୍ମାଣ୍‌ କଃଲେକ୍‌ କାୟ୍‌ ନୟ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ମନ୍ଦିରେ ରିଲା ସନାକେ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌, ତଃବେ ସେ ହଃର୍ମାଣ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଲାଗେଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଏ ନିର୍ବୁଦିଆ ଆର୍‌ କାଣାମଃନ୍ ସନା, କି ସେ ସନାକେ ପବିତ୍ର କଃରି ଆଚେ ଜୁୟ୍‌ ମନ୍ଦିର୍‌, ଇ ଜଳେକ୍‌ ବିତ୍ରେ କୁୟ୍‌ରି ବଃଡ୍ ? ");
INSERT INTO bdv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଆରେକ୍‌ ତୁମିମଃନ୍ କଃଉତି ରିଆସ୍‌, ‘ଜଦି କେ ହୁଜା ବେଦିର୍‌ ହଃର୍ମାଣ୍‌ କଃଲେକ୍‌ ସେରି କାୟ୍‌ରି ନାୟ୍‌, ମଃତର୍‌ ଜେ ହୁଜା ବେଦି ଉହ୍ରେ ରିଲା ବେଟିର୍‌ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌, ତଃବେ ସେ ହଃର୍ମାଣ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଲାଗେଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ଏ କାଣାମଃନ୍ ହୁଜା କି ସେ ହୁଜାକେ ପବିତ୍ର କଃରେଦ୍‌ ଜୁୟ୍‌ ବେଦି ଇ ଜୁଳେକ୍‌ ବିତ୍ରେ କୁୟ୍‌ରି ବଃଡ୍ ? ");
INSERT INTO bdv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ତଃବେ ଜୁୟ୍‌ ଲକ୍‌ ହୁଜା ବେଦିର୍‌ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌, ସେ ତ ହୁଜା ବେଦି ଆର୍‌ ବେଦି ଉହ୍ରେ ରିଲା ବେଟିକ୍‌ ହେଁ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଆର୍‌ ଜେ ମନ୍ଦିରାର୍‌ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌, ସେ ମନ୍ଦିର୍‌ ଆର୍‌ ସେତି ବାସାକଃର୍ତା ଇସ୍ୱରାର୍‌ ନାଉଁଏ ହେଁ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ଆରେକ୍‌ ଜେ ସଃର୍ଗାର୍‌ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌, ସେ ଇସ୍ୱରାର୍‌ ସିଙ୍ଗାସଣ୍‌ ଆର୍‌ ସେତି ବଃସିରିଲା ଇସ୍ୱରାର୍‌ ହଃର୍ମାଣ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ଏ, ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ପଦିନା, ହାନ୍‌ମରି ଆର୍‌ ଜିରାର୍‌ ଦଃସ୍‌ ବାଗାର୍‌ ଗଟେକ୍‌ ବାଗ୍ ଇସ୍ୱର୍‌କେ ଦେଉଁଲାସ୍‌, ଆର୍‌ ମସାର୍‌ ବିଦିର୍‌ ବଃଡ୍ ବଲ୍‌ ସଃବୁ, ବଃଲେକ୍‌ ନ୍ୟାୟ୍‌ବିଚାର୍‌, ବିସ୍ୱାସ୍‌ ଦଃୟା କଃର୍ତାର୍‌ ଆର୍‌ ମାନ୍‌ତାର୍‌, ଇ ସଃବୁ ତୁମିମଃନ୍ ଚାଡି ଆଚାସ୍‌; ମଃତର୍‌ ମସାର୍‌ ବିଦିର୍‌ ହଃର୍ତୁ କଃତା ସଃବୁ ନଃଚାଡି, ଇ କଃତା ଆଗେ ମାନ୍‌ତା ଲଳା । ");
INSERT INTO bdv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଏ କାଣାମଃନ୍‌କେ ବାଟ ଦଃକାଉତା ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍ ମଚିକ୍‌ ଚାନୁଲାସ୍‌, ମଃତର୍‌ ଉଟ୍‌କେ ଗିଳୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଏ, ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଗିନାର୍‌ ଆର୍‌ ତାଳିର୍‌ ହଃଦା ବାଟ୍ୟା ଦଃଉଁଲାସ୍‌ ଆର୍‌ ନିର୍ମୁଳ୍‌ କଃରୁଲାସ୍‌, ମଃତର୍‌ ବିତୁର୍‌ ବାଟ୍ୟା ସେରିମଃନ୍ ଜୁରିଆକାମ୍‌ ଆର୍‌ ମଃନାର୍‌ କଃରାବ୍‌ ଚିତାମଃନ୍ ବଃର୍ତି ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ରେ କାଣା ପାରୁସିମଃନ୍ ଆଗ୍‌ତୁ ଗିନାର୍‌ ଆର୍‌ ତାଳିର୍‌ ବିତ୍ରାର୍‌ ଦଃଉଆ, ତଃବେ ହଃଦା ବାଟ୍ୟା ହେଁ ନିର୍ମୁଳ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ଏ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଚିଟ୍‌ଦବ୍‌ ଡିସ୍ତା ମଃସୁଣ୍‌ ହର୍‌, ବଃଲେକ୍‌ ସେରି ହଃଦାୟ୍‌ ସୁନ୍ଦୁର୍‌ ଡିସେଦ୍‌, ମଃତର୍‌ ବିତ୍ରେ ମଃଲା ଲକାର୍‌ ଆଡ୍ ଆର୍‌ ସଃବୁ ରଃକମାର୍‌ ବିଟାଳ୍‌ ବଃର୍ତି ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ସେରଃକମ୍‌ ତୁମିମଃନ୍ ହେଁ ହଃଦାୟ୍‌ ସଃବୁ ଲକାର୍‌ ଆକାୟ୍‌ ଦଃର୍ମି ଲକ୍‌ ବଃଲି ଦଃକାୟ୍‌ ଅଃଉଁଲାସ୍‌, ମଃତର୍‌ ବିତ୍ରେ ହେଟ୍‌କପଟ୍‌ ଆର୍‌ ଅଃଦଃର୍ମି କାମ୍‌ ବଃର୍ତି ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ଏ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ହେଟ୍‌କପଟ୍ୟା ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ବାବ୍‌ବାଦିମଃନାର୍‌ ମଃସୁଣ୍‌ ତିଆର୍‌ କଃରୁଲାସ୍‌ ଆର୍‌ ଦଃର୍ମି ଲକ୍‌ମଃନ୍‌କେ ଏତାଉଁକେ ମଃସୁଣ୍‌କେ ସୁନ୍ଦୁର୍‌ କଃରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ଆର୍‌ କଃଉଁଲାସ୍‌, ‘ଅଃମିମଃନ୍‌ ଜଦି ଅଃମାର୍‌ ହୁର୍ବାର୍‌ ଦାଦିବାବୁ ବଃଳାର୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲେକ୍‌, ଅଃମିମଃନ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ବାବ୍‌ବାଦିମଃନ୍‌କେ ଅଃତ୍ୟା କଃରୁକେ ନଃମିସ୍‌ଲୁ ହୁଣି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଇତାକ୍‌ ତୁମିମଃନ୍ ଜେ ବାବ୍‌ବାଦିମଃନ୍‌କେ ଅଃତ୍ୟାକାରିମଃନାର୍‌ କୁଳ୍‌ ବଃଉଁସ୍‌ ଅଃଉଁଲାସ୍‌, ସେ କଃତା ତୁମିମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କଃତାୟ୍‌ ସାକି ଦେଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ତଃବେ ତୁମି ଆଗେ ଜାହା, ତୁମାର୍‌ ହୁର୍ବ୍‌ କାଳାର୍‌ ଦାଦିବାବୁମଃନ୍ ଜୁୟ୍‌ କାମ୍‌ ଆରୁମ୍‌ କଃରି ରିଲାୟ୍‌, ସେରି ହୁରୁଣ୍ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଏ ସାହ୍‌, ଏ ନାଗ୍‌ସାହାର୍‌ ବଃଉଁସ୍‌ମଃନ୍ ! ତୁମିମଃନ୍ ନଃର୍କ୍ ବିଚାର୍‌ ଦଃଣ୍ଡେହୁଣି କଃନ୍‌କଃରି ମୁକ୍ଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଇତାକ୍‌ ଦଃକା, ମୁଁୟ୍‌ ତୁମାର୍‌ ହାକ୍‌ ବାବ୍‌ବାଦି, ଗ୍ୟାନି ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଲକ୍‌କେ ହଃଟାଉଁଲେ; ତୁମିମଃନ୍ ସେମଃନାର୍‌ ବିତ୍ରାର୍‌ କାକେ କାକେ ମଃର୍ନେ ମାରାସ୍‌ ଆର୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଅଃତ୍ୟା କଃରାସ୍‌, ଆର୍‌ କାକ୍‌କାକ୍‌ ତୁମାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ସାଟ୍‍ଣି ସଃଙ୍ଗ୍ ମାରାସ୍‌ ଆର୍‌ ଗଃଳେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଆର୍ଲା କଃରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଜୁୟ୍‌ ଦଃର୍ମି ହେବଲ୍‌କେ ଅଃତ୍ୟା ତଃୟ୍‌ହୁଣି ଆରୁମ୍‌ କଃରି, ଜୁୟ୍‌ ବେରିକାର୍‌ ହୟ୍‌ସି ଜିକରିଅକେ ତୁମିମଃନ୍ ମନ୍ଦିର୍‌ ତଃୟ୍‌ର୍‌ ପବିତ୍ର ବେଦି ଟାଣେ ଆର୍‌ ହୁଜାବେଦିର୍‌ ମଃଜାୟ୍‌ ମାର୍ଲାସ୍‌, ତାର୍‌ ଅଃତ୍ୟା ହଃତେକ୍‌ ହୁର୍ତିବିଏ ଜଃତେକ୍‌ ସଃବୁ ଦଃର୍ମ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଅଃତ୍ୟା ଅୟ୍‌ଆଚେ, ସେ ସଃବୁ ଡଃଣ୍ଡ୍‌ ତୁମାର୍‌ ଉହ୍ରେ ହଃଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ଅଃତ୍ୟା କଃରି ରିଲାକ୍‌ ଇ କାଳାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ଇ ସଃବୁ ଡଃଣ୍ଡ୍‌ ହଃଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ଏ ଜିରୁସାଲମ୍‌, ବାବ୍‌ବାଦିମଃନ୍‌କେ ଅଃତ୍ୟାକାରିଣି ଜିରୁସାଲମ୍‌, ଆର୍‌ ମାପ୍ରୁ ତର୍‌ ତଃୟ୍‌ ହଃଟାୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍‌କେ ଟେଳା ଚେଚି ମଃର୍ନେ ମାରି ରିଲା ଜିରୁସାଲମ୍‌, ମାୟ୍‌କୁକ୍‍ଡ଼ା ଜଃନ୍‌କଃରି ତାର୍‌ ହିଲାମଃନ୍‌କେ ତାର୍‌ ଡେଣା ତଃଳେ ରୁଣ୍ଡାୟ୍‌ଦ୍‌, ସେରଃକମ୍‌ ମୁଁୟ୍‌ କଃତେକ୍‌ ତର୍‌ ହିଲାମଃନ୍‌କେ ରୁଣ୍ଡାଉଁକ୍‌ ମଃନ୍ କଃଲେ, ମଃତର୍‌ ତୁମିମଃନ୍ ମଃନ୍ ନଃକେଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ଦଃକା ତୁମାର୍‌ ମନ୍ଦିର୍‌ ତୁମାର୍‌ ଆତେ ଚାଡି ଦିଆ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ‘ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜେ ଆସୁଲା ତାର୍‌ ଆସିର୍ବାଦ୍‌,’ ତୁମିମଃନ୍ ଇ କଃତା ନଃକଉତା ହଃତେକ୍‌ ଆଜିହୁଣି ମକ୍‌ କଃବେ ହେଁ ଦଃକୁ ନଃହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେହୁଣି ବାରାୟ୍‌ ଜାତିରିଲା ବଃଳ୍‌, ତାର୍‌ ଚେଲାମଃନ୍ ମନ୍ଦିରାର୍‌ ମେଳ୍‌ଗଃର୍‌ମଃନ୍‌ ଦଃକାଉଁକ୍‌ ତାର୍‌ ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ରି ଇସଃବୁ ନଃଦେକୁଲାସ୍‌ ? ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ଗଟେ ଟେଳା ଆରେକ୍‌ ଗଟେକ୍‌ ଟେଳା ଉହ୍ରେ ନଃରେୟ୍‌, ସଃବୁ ହେଁ ବୁୟେଁକୁଳାୟ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ତାର୍‌ହଃଚେ ଜିସୁ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ବଃସ୍‌ଲାକେ ଚେଲାମଃନ୍ ତାର୍‌ ଲଃଗେ ଲୁକ୍‌ଣେ ଆସି ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌କେ କଃଉ, ଇ ସଃବୁ ଗଃଟ୍‍ଣା କଃବେ ଗଃଟେଦ୍‌ ? ଆର୍‌ ତର୍‌ ଆସ୍ତାର୍‌ ଆର୍‌ ଜୁଗ୍ ସେସ୍‌ ଅଃଉତା ଚିନ୍ କାୟ୍‌ରି ସେରି ଅଃମିକ୍‌ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ଜଃନ୍‌କଃରି କେ ହେଁ ତୁମିକେ ନଃବୁଲ୍‌କାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ବଃଲେକ୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ନାଉଁଏ ଆସି ‘ମୁଁୟ୍‌ କ୍ରିସ୍ଟ ବଃଲେକ୍‌ ମଃସିଆ !’ ବଃଲି କୟ୍‌କଃରି ଗାଦି ଲକ୍‌ମଃନ୍‌କେ ବୁଲ୍‌କାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ତୁମିମଃନ୍ ଜୁଜ୍‌ ଅଃଉତା କଃତା ସୁଣାସ୍‌ ଆର୍‌ ଜୁଜ୍‌ ଅଃଉତିରିଲାର୍‌ କବୁର୍‌ ସୁଣାସ୍‌, ମଃତର୍‌ ଜଃଗ୍ରାତ୍‌, ଡିରା ନାୟ୍‌, ବଃଲେକ୍‌ ଇ ସଃବୁ ବାୟ୍‌ଦ୍‌ରେ ଗଃଟେଦ୍‌, ମଃତର୍‌ ସଃଡେବଃଳ୍‌ ଜୁଗ୍ ନଃବୁଡେ । ");
INSERT INTO bdv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦେସ୍‌ ବିରଦେ ଦେସ୍‌, ଲକ୍‌ ବିରଦେ ଲକ୍‌ ଉଟ୍‌ତି, ଆରେକ୍‌ ଟାଣେ ଟାଣେ କଃତାର୍‌ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ଦଃର୍ତି ଲଃଦ୍‌ବଃଦେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମଃତର୍‌ ଇ ସଃବୁ ଗଃଟ୍‍ଣା ମାୟ୍‌ଜିର୍‌ ହିଲା ଜଃଲମ୍‌ କଃର୍ତା ଆଗ୍‌ତୁ ଆରୁମ୍‌ ଦୁକା ହର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ମଃତର୍‌ ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ କଃସ୍ଟ୍‌ବଗ୍ କଃରୁକେ ସଃହ୍ରି ଦେତି, ଆର୍‌ ସେମଃନ୍ ତୁମିକେ ମଃର୍ନେ ମାର୍ତି, ଆର୍‌ ମର୍‌ ନାଉଁଏ ବିସ୍ୱାସ୍‌ କଃର୍ତା ଗିନେ ସଃବୁ ଜାତିର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ଗିଣ୍ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ସଃଡେବଃଳ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ବାଦା ହାଉତି ଆର୍‌ ମାପ୍ରୁ ବିସ୍ୱାସ୍‌ ଚାଡି ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ ଦଃରାୟ୍‌ଦେତି ଆର୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ ଗିଣ୍ କଃରାକଃରି ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆର୍‌ ସଃଡେବଃଳ୍‌ ବୁତେକ୍‌ ବାମାଉତା ବାବ୍‌ବାଦିମଃନ୍ ବାରାୟ୍‌କଃରି ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ବୁଲ୍‌କାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ସଃଡେବଃଳ୍‌ ଅଃଦଃର୍ମ୍‌ କାମ୍‌ ଜଃବର୍‌ ଅୟ୍‌ଦ୍‌, ଇତାକ୍‌ ଇସ୍ୱରାର୍‌ ଗିନେ ଗାଦେକ୍‌ ଲକାର୍‌ ଲାଡ୍‌ ଉଣା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମଃତର୍‌ ଜେ ସେସ୍‌ ହଃତେକ୍‌ ସାସ୍‌ ଦଃରି ରଃୟ୍‌ଦ୍‌, ସେ ନିଜ୍‌କେ ବଚାଉ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଆର୍‌ ସଃବୁ ବାସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ସାକି ଦେଉଁକେ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ଇ ନିକ କବୁର୍‌ ହୁର୍ତି ସଃରା ପର୍ଚାର୍‌ କଃରା ଅୟ୍‌ଦ୍‌, ତାର୍‌ହଃଚେ ଜୁଗ୍ ସେସ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ଇତାକ୍‌ ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଦାନିଏଲ୍‌ ବାବ୍‌ବାଦି କୟ୍‌ଲା, ସେ ନାସ୍‌କାରି ଗିଣ୍ ଆସ୍ତିକ୍‌ ମନ୍ଦିରାର୍‌ ପବିତ୍ର ଟାଣେ ରେତାର୍‌ ଦଃକାସ୍‌ ।” ହଳ୍‌ତା ଲକ୍‌ ଇରି ବୁଜତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିଉଦା ରାଜାୟ୍‌ ରେତି ସେମଃନ୍ ଡଙ୍ଗ୍ରେ ହଃଳାୟ୍‌ ଜଃଉଅତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଚାନି ଉହ୍ରେ ରେତି ସେମଃନ୍ ନିଜାର୍‌ ଗଃର୍‌ ବିତ୍ରାର୍‌ ଆସ୍ତିବାଡି ନେଉଁକେ ଉତ୍ରି ନାସତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଆର୍‌ ସଃଡେବଃଳ୍‌ ଜେ ତାସ୍‌ ହଃଦାୟ୍‌ ରଃୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ହଃଚ୍ୟା ଆଣୁକେ ଗଃରେ ବାଉଳି ଜଃଉଅ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ମାୟ୍‌ଜିମଃନ୍ ଆଙ୍ଗେ ରେତି ଆର୍‌ ଦୁଦ୍‌ କାଳାଉତିରେତି, ସେମଃନ୍ ଜଃବର୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ମଃତର୍‌ ତୁମାର୍‌ ହଃଳାଉତାର୍‌ ଜଃନ୍‌କଃରି ସିତ୍‌ ବଃଳ୍‌ କି ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ନଃଉଅ, ଇତାକ୍‌ ଇସ୍ୱର୍‌କେ ପାର୍ତ୍‌ନା କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ଇ ରଃକମ୍‌ ଜଃବର୍‌ ଡଃଣ୍ଡ୍‌ ଗଃଟେଦ୍‌ ଜେ, ଜଃଗତାର୍‌ ଆରୁମେ ହୁଣି ଆଜି ହଃତେକ୍‌ ନଃଗେଟେ, ଆର୍‌ କଃବେ ହେଁ ନଃଗେଟେ । ");
INSERT INTO bdv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ମଃତର୍‌ ଇସ୍ୱର୍‌ ସେ କଃସ୍ଟାର୍‌ ଦିନ୍ ଉଣା କଃରି ନଃରିଲେକ୍‌ କେହେଁ ମୁକ୍ତି ହାଉଁକେ ନଃହାର୍ଲାୟ୍‌ ହୁଣି । ମଃତର୍‌ ଇସ୍ୱର୍‌ ବାଚ୍‌ଲାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ସେ ଦିନ୍‌କେ ଉଣା କଃରାଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ଆର୍‌ ସଃଡେବଃଳ୍‌ କେ ତୁମିମଃନ୍‌କେ ‘କ୍ରିସ୍ଟ ଇତି ଆଚେ,’ କି, ସେତିଆଚେ,' ବଃଲି କୟ୍‌ଲେକ୍‌, ତୁମି ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ବାମାଉତା କ୍ରିସ୍ଟ ଆର୍‌ ବାମାଉତା ବାବ୍‌ବାଦିମଃନ୍ ଉଟି ବଃଡ୍ ବଃଡ୍ ଚିନ୍ ଆର୍‌ କାବା ଅଃଉତା କାମ୍‌ମଃନ୍‌ ଦଃକାଉତି, ଜଦି ଅଃଉଁ ହାରେ ଇସ୍ୱର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ହେଁ ବୁଲ୍‌କାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ଦଃକା, ମୁଁୟ୍‌ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ତା ଆଗ୍‌ତୁ ତୁମିମଃନ୍‌କେ ସଃବୁ ଜାଣାୟ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ତଃବେ ଦଃକା, ଲକ୍‌ମଃନ୍ ତୁମିକେ ମାପ୍ରୁ ବଃଟାୟ୍‌ ଆଚେ ବଃଲି କଃଉତି, ତଃବେ ବାରାୟ୍‌ ଜାହା ନାୟ୍‌, ଦଃକା ସେ ବିତୁର୍‌ ଗଃରେ ଲୁକି ଆଚେ ବଃଲି କଃଉତି, ତଃବେ ତାକାର୍‌ କଃତା ବିସ୍ୱାସ୍‌ କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ବଃଲେକ୍‌ ବିଜ୍‌ଲି ଜଃନ୍‌କଃରି ହୁର୍ବ୍‌ ଦିଗେ ମଃଲ୍‌କାୟ୍‌ ବେଳ୍‌ ବୁଡ୍‌ତି ଦିଗ୍ ହଃତେକ୍‌ ଉଜାଳ୍‌ ଦଃକାଜାୟ୍‌ଦ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ସଃନ୍‌କଃରି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ବଃଲେକ୍‌ ଜୁୟ୍‌ଟାଣେ ମଃଲା ଗଃଗାଳ୍‌ ରଃୟ୍‌ଦ୍‌, ସେଟାଣେ ରାବଣ୍‌ମଃନ୍‌ ହେଁ ଗଟେତଃୟ୍‌ ରୁଣ୍ଡ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ମଃତର୍‌ ସେ ଦିନାର୍‌ ଡଃଣ୍ଡ୍‌ ହଃଚେ, ସେଦାହ୍ରେ ବେଳ୍‌ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ଜଃନ୍ ଉଜାଳ୍‌ ନଃଦେୟ୍‌, ତାରାମଃନ୍ ସଃର୍ଗେ ହୁଣି ଅଦୁର୍ତି ଆର୍‌ ଅଃଗାସାର୍‌ ସଃବୁ ସଃକ୍ତିମଃନ୍ ଏଣେ ତେଣେ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ସଃଡେବଃଳ୍‌ ଅଃଗାସ୍‌ ଉହ୍ରେ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଚିନ୍‌ମଃନ୍‌ ଡିସେଦ୍‌ ଆର୍‌ ସଃଡେବଃଳ୍‌ ହୁର୍ତିବିର୍‌ ସଃବୁ ବାସାର୍‌ ଲକ୍‌ମଃନ୍ କାନ୍ଦ୍‌ତି ଆର୍‌ ନଃରାର୍‌ ହୟ୍‌ସିକେ ସଃକ୍ତି ଆର୍‌ ବଃଡେ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଅଃଗାସାର୍‌ ମେଗେ ଆସ୍ତାର୍‌ ଦଃକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ଆର୍‌ ତୁରି ହୁକି ଅଃହ୍‌ଣାର୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌ଦ୍‌ ଆର୍‌ ଦୁତ୍‌ମଃନ୍ ହୁର୍ତିବିର୍‌ ଗଟ୍‌ କନେହୁଣି ଆରେକ୍‌ ଗଟ୍‌ କଃନ୍‌ ହଃତେକ୍‌ ଚାରିହଃକାର୍‌ ତାର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ରୁଣ୍ଡାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ଡୁମ୍ବୁର୍‌ ଗଃଚାର୍‌ ଗଟେକ୍‌ କଃତା ସିକା, ଜଃଡେବଃଳ୍‌ ତାର୍‌ କଃନ୍ଦାୟ୍‌ କଃଉଁଣା ହଃତାର୍‌ ଦଃରେଦ୍‌ ଆର୍‌ ଡାଳ୍‌ ହଃତାର୍‌ ଅୟ୍‌ ବାଡି ଆସେଦ୍‌, ସଃଡେବଃଳ୍‌ ତୁମି କଃରା ଦିନ୍ ଆସୁଲି ବଃଲି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ସେରଃକମ୍‌ ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଇସଃବୁ ଗଃଟ୍‍ଣା ଦଃକ୍‌ଲେକ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ଦୁଆର୍‌ ଚଃମେ ବଃଲି ଜାଣା । ");
INSERT INTO bdv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ସଃବୁ କଃତା ନଃଗଟ୍‌ତା ହଃତେକ୍‌ ଅଃବେ ଇ କାଳାର୍‌ ଲକ୍‌ମଃନ୍ କଃନ୍‌କଃରି ହେଁ ନଃମେର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ଅଃଗାସ୍‌ ଆର୍‌ ହୁର୍ତିବି ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ମର୍‌ କଃତା କଃବେ ନଃସ୍ଟ୍‌ ନୟେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ମଃତର୍‌ ସେ କଃବେ ଆସେଦ୍‌, ସେ ଦିନ୍ ଆର୍‌ ବେଳା କେ ନଃଜାଣ୍‌ତି, ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନ୍ କି ହୟ୍‌ସି ହେଁ ନଃଜାଣେ, ମଃତର୍‌ ସଃର୍ଗାର୍‌ ଉବା ହଃକା ଏକ୍ଲା ଜାଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଆର୍‌ ନହର୍‌ ବଃଳ୍‌ ଜୁୟ୍‌ରଃକମ୍‌ ଗଃଟିରିଲି ନଃରାର୍‌ ହୟ୍‌ସି ଆସ୍ତା ବଃଳ୍‌ହେଁ ସେରଃକମ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ହାଣି ମାରି ହୁର୍ତି ବୁଡ୍‌ତା ଆଗ୍‌ତୁ ନହ ଜାଜେ ହୁର୍ତା ଦିନ୍ ହଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି କାଉଆ ହିଉଆ ଆର୍‌ ବିବା କଃରୁକ୍‌ ଆର୍‌ ବିବା ଦେଉଁକେ ମାତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ହୁର୍‌ ହାଣି ଆସି ସଃବୁଲକେ ବଳାୟ୍‌ ନଃନେତା ହଃତେକ୍‌ ଜଃନ୍‌କଃରି କାୟ୍‌ରି ଅୟ୍‌ଦ୍‌, ସେରି କେ ଜାଣି ନଃରିଲାୟ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ଆସ୍ତା ବଃଳ୍‌ ହେଁ ସେରଃକମ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ସଃଡେବଃଳ୍‌ ଦୁୟ୍‌ ଲକ୍‌ ତାସ୍‌ ହଃଦାୟ୍‌ ରେତି, ଗଟେକ୍‌ ଲକ୍‌କେ ନିଆ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଚାଡି ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ଜଳେକ୍‌ ମାୟ୍‌ଜିମଃନ୍ ଜଃତାୟ୍‌ ରୁଚ୍‌ତି ରେତି, ଏକ୍ଲାକେ ନିଆ ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଏକ୍ଲାକେ ଚାଡି ଦିଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ଇତାର୍‌ ଗିନେ ତୁମିମଃନ୍ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ବଃଲେକ୍‌ ତୁମାର୍‌ ମାପ୍ରୁ କୁୟ୍‌ ଦିନ୍ ଆସେଦ୍‌ ସେରି ତୁମିମଃନ୍ ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ମଃତର୍‌ ତୁମିମଃନ୍ ଇରି ଜାଣିରିଆ ଜେ, କୁୟ୍‌ ବେଳାୟ୍‌ ଚର୍‌ ଆସେଦ୍‌ ଇରି ଗଃରାର୍‌ ମୁଳିକା ଜାଣି ରିଲେକ୍‌, ସେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଲା ହୁଣି ଆର୍‌ ଗଃରେ ସିନ୍ଦ୍ ମାରୁକ୍‌ ନଃଦିଲା ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ତଃବାର୍‌ଗିନେ ତୁମିମଃନ୍ ହେଁ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ ବଃଲେକ୍‌ ଜୁୟ୍‌ ବେଳାୟ୍‌ ତୁମିମଃନ୍ ମଃନେ ବାବି ନଃରିଆସ୍‌ ସେ ବେଳାୟ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ତଃବେ ସାଉକାର୍‌ ତାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଟିକ୍‌ ବେଳାୟ୍‌ ହଃଳିବାତ୍ୟା ଦେଉଁକେ ଜାକେ ସେମଃନାର୍‌ ଉହ୍ରେ ବାଚ୍‌ଲା ଆଚେ, ଇବାନ୍ୟା ସଃତ୍‌ ଆର୍‌ ବୁଦିର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା କେ ? ");
INSERT INTO bdv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ସାଉକାର୍‌ ଆସି ତାର୍‌ ଜୁୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ସେରଃକମ୍‌ କାମ୍‌ କଃର୍ତି ରିଲାର୍‌ ଦଃକେଦ୍‌, ତଃବେ ସେ ଦଃଙ୍ଗ୍‌ଳାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସାଉକାର୍‌ ସେ ଦଃଙ୍ଗ୍‌ଳାକେ ତାର୍‌ ସଃବୁ ସଃମ୍ପତି ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମଃତର୍‌ ଜଦି ସେ ଦୁସ୍ଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ମର୍‌ ସାଉକାର୍‌ ଆସ୍ତାର୍‌ ବିଲମ୍‌ କଃରେଦ୍‌ ବଃଲି ମଃନ୍‌ ବିତ୍ରେ କୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଅଃହ୍‌ଣାର୍‌ ସଃଙ୍ଗାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ମାଡ୍ ମାରୁକ୍‌ ଦଃରେଦ୍‌ ଆର୍‌ ମଃଦୁଆ ମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଆ ହିଉଆ କଃରେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ଜୁୟ୍‌ ଦିନ୍ ସେ ଜାଗି ନଃରେୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ ବେଳା ଗତିଦଃଙ୍ଗ୍‌ଳା ଜାଣି ନଃରେୟ୍‌, ସେ ଦିନ୍ ଆର୍‌ ସେ ବେଳାୟ୍‌ ତାର୍‌ ସାଉକାର୍‌ ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଆରେକ୍‌ ସାଉକାର୍‌ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ କଃଣ୍ଡ୍ କଃଣ୍ଡ୍ କଃରି କାଟି ହେଟ୍‌କପଟ୍ୟା ମଃନାର୍‌ ସଃଙ୍ଗ୍ ବାଗ୍ ବାଟା ଟିକ୍‌ କଃରେଦ୍‌; ସେତି ସେ କାନ୍ଦି କାନ୍ଦି ଦାତ୍‌ ଚାବି ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ସଃଡେବଃଳ୍‌ ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଦଃସ୍‌ଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳି ହର୍‌ ଅୟ୍‌ଦ୍‌; ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କୁପି ଦଃରି ବଃରକେ ବେଟୁକ୍‌ ବାରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ସେମଃନାର୍‌ ବିତ୍ରେ ହାଁଚ୍ ଗଟ୍‌ ନିର୍ବୁଦିଆଣି ରିଲାୟ୍‌ ଆର୍‌ ହାଁଚ୍ ଗଟ୍‌ ବୁଦିଆଣି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ସେ ନିର୍ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କୁପି ଦଃରି ଗଃଳାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ବିନେ ଅଃଦିକ୍‌ ଚିକଣ୍‌ ଦଃରି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ମଃତର୍‌ ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କୁପି ସଃଙ୍ଗ୍ ବିନେ ଅଃଦିକ୍‌ ଚିକଣ୍‌ ଦଃରି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବଃର ଆସୁକ୍‌ ବେଳ୍‌ କଃଲା ଗିନେ ସଃବୁ ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ଗୁନି ଗୁନି ସଇଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ମଃତର୍‌ ମଃଜାରାତି ବଃଳ୍‌, ‘ଏଦେ ଦଃକା, ବଃର ଆୟ୍‌ଲାନି, ଆସା ବେଟୁକ୍‌ ଜୁଆଁ,’ ବଃଲି ଲକ୍‌ମଃନ୍ ଉଲ୍‌ଗାଟ୍‌ ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ସଃଡେବଃଳ୍‌ ସେ ଦଃସ୍‌ଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ଉଟି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କୁପି ହଃଜାଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ତାର୍‌ହଃଚେ ସେ ନିର୍ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ସେ ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌, ‘ତୁମାର୍‌ ଚିକଣ୍‌ ଅଃମିକ୍‌ କଃଣ୍ଡେକ୍‌ ଦିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମାର୍‌ କୁପିସଃବୁ ଲିବି ଜଃଉଁଲି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ମଃତର୍‌ ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, ‘ନାୟ୍‌, ନାୟ୍‌, ନାୟ୍‌, ତୁମାର୍‌ ଅଃମାର୍‌ ଗିନେ ଚିକଣ୍‌ ନଃକେଟେ । ଦୁକାଣେ ଜାୟ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଗିନେ ଚିକଣ୍‌ ଗେନି ଆଣା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ମଃତର୍‌ ସେମଃନ୍ ଚିକଣ୍‌ ଗେନୁକ୍‌ ଜାତାବଃଳ୍‌ ବଃର ଆୟ୍‌ଲା, ଆର୍‌ ଜୁୟ୍‌ ହାଁଚ୍ ଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ତିଆର୍‌ ଅୟ୍‌ରିଲାୟ୍‌, ସେମଃନ୍ ବଃର ସଃଙ୍ଗ୍ ବିବା ଗଃରେ ହୁର୍ଲାୟ୍‌, ଆର୍‌ ଦୁଆର୍‌ ଡାହାଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ତାର୍‌ହଃଚେ ସେ ହାଁଚ୍‌ଗଟ୍‌ ନିର୍ବୁଦିଆଣି ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌ ହେଁ ଆସି କୟ୍‌ଲାୟ୍‌, ‘ଏ ମାପ୍ରୁ, ଏ ମାପ୍ରୁ, ଅଃମାର୍‌ ଗିନେ କଃହାଟ୍‌ ଉଗାଳା ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ମଃତର୍‌ ବଃର ସେମଃନ୍‌କେ କୟ୍‌ଲା, ‘ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନଃଜାଣି ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଇ କଃତା କୟ୍‌ ସଃରାୟ୍‌ ଜିସୁ କୟ୍‌ଲା, “ତଃବେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ନଃରାର୍‌ ହୟ୍‌ସି ଆସ୍ତାର୍‌ ସେଦିନ୍ କି ସେବେଳା ନଃଜାଣାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ଗଟ୍‌ ଦିନ୍ ଗଟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ କୁଦିକଃରି ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଦଃନ୍‌ବିତ୍‌ ତାକାର୍‌ ଆତେ ସଃର୍ହି ଦିଲା, ଆର୍‌ ବିଦେସ୍‌ ଜଃଉଁକେ ବାରାୟ୍‌ଲା, ସଃର୍ଗ୍‌ ରାଇଜ୍‌ ଇହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ସେ ଗଟ୍‌ ଲକ୍‌କେ ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଆର୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଆର୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଗଟେକ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା, ଇରଃକମ୍‌ ସେମଃନ୍‌କେ ସେମଃନାର୍‌ ହାର୍ତା ସଃକାତ୍‌ ଦଃକି ଦଃୟ୍‌କଃରି, ସେ ବିଦେସ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ଜୁୟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ରିଲା, ସେ ସଃଙ୍ଗେ ସଃଙ୍ଗେ ସେରି ବେବାର୍‌ କଃରି ଆରେକ୍‌ ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଲାବ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ସେରଃକମ୍‌ ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ରିଲା, ସେ ହେଁ ଆରେକ୍‌ ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଲାବ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମଃତର୍‌ ଜୁୟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ଗଟେକ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ ରିଲା, ସେ ଜାୟ୍‌ ଗଟ୍‌ କାଲ୍‌ କଃଣି ଅଃହ୍‌ଣାର୍‌ ସାଉକାରାର୍‌ ସେ ଟଃକାକ୍‌ ତହିକଃରି ମାଟାୟ୍‌ ଲୁକାୟ୍‌ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ବୁତେକ୍‌ ଦିନାର୍‌ ହଃଚେ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ସାଉକାର୍‌ ବାଉଳି ଆସି ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ତଃହ୍‌ଣା ଦଃୟ୍‌ରିଲା ଟଃକାର୍‌ ଇସାବ୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ଜୁୟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ରିଲା, ସେ ଆରେକ୍‌ ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଆଣି କୟ୍‌ଲା, ‘ସାଉକାର୍‌ ତୁୟ୍‌ ମକ୍‌ ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଦଃୟରିଲିସ୍‌, ଦଃକ୍‌, ଅଃବେ ମୁଁୟ୍‌ ଆରେକ୍‌ ହାଁଚ୍ ଅଃଜାର୍‌ ରୁହା ଟଃକା ବେବାର୍‌ କଃରି ଲାବ୍‌ କଃରି ଆଚି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ତାର୍‌ ସାଉକାର୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ବଃଡେ ସଃତ୍‌, ଆର୍‌ ସଃତ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା, ତୁୟ୍‌ ଅଃଳକ୍‌ କଃତାୟ୍‌ ମାୟଃନ୍‌କାରି ଅୟ୍‌ଲିସ୍‌, ମୁଁୟ୍‌ ତକେ ବୁତେକ୍‌ ବିସୟେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ନ୍ଦ୍, ତୁୟ୍‌ ତର୍‌ ସାଉକାର୍‌ ସଃଙ୍ଗ୍ ମିସି ସଃର୍ଦା କଃର୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ତାର୍‌ହଃଚେ ଜୁୟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ରିଲା ସେ ହେଁ ଆସି କୟ୍‌ଲା, ‘ସାଉକାର୍‌ ତୁୟ୍‌ ମକ୍‌ ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଦଃୟରିଲିସ୍‌, ଦଃକ୍‌ ମୁଁୟ୍‌ ଆରେକ୍‌ ଦୁୟ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ଲାବ୍‌ କଃରି ଆଚି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ତାର୍‌ ସାଉକାର୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ବଃଡେ ସଃତ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା, ତୁୟ୍‌ ଅଃଳକ୍‌ କଃତାୟ୍‌ ମାୟଃନ୍‌କାରି ଅୟ୍‌ଲିସ୍‌, ତକେ ବୁତେକ୍‌ କଃତା ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ନ୍ଦ୍ । ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ସାଉକାର୍‌ ସଃଙ୍ଗ୍ ମିସି ସଃର୍ଦା କଃର୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ତାର୍‌ହଃଚେ ଜୁୟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ଗଟେକ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ହାୟ୍‌ରିଲା ସେ ହେଁ ଆସି କୟ୍‌ଲା, ‘ସାଉକାର୍‌ ଦଃକ୍‌, ତୁୟ୍‌ ବଃଡେ ଅଃଟୁଆ ମଃନାର୍‌ ଲକ୍‌ । ତୁୟ୍‌ ଜୁୟ୍‌ତି ବୁଣି ନଃରେସି ସେତି କାଟ୍‌ସି ଆର୍‌ ଜୁୟ୍‌ତି ତୁୟ୍‌ ଉଡାଳି ନଃରେସି ସେତି ରୁଣ୍ଡାଉସି, ଇରି ମୁଁୟ୍‌ ଜାଣିରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତକେ ଡିରିକଃରି ତର୍‌ ଟଃକାକ୍‌ ମାଟିତଃଳେ ତହି ଲୁକାୟ୍‌ ସଃଙ୍ଗାୟ୍‌ ରିଲେ, ଦଃକ୍‌ ତୁୟ୍‌ ନିଜାର୍‌ ଟଃକା ହାୟ୍‌ଲିସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ମଃତର୍‌ ତାର୍‌ ସାଉକାର୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ଏରେ ଦୁସ୍ଟ୍‌ ଆର୍‌ ଅଃଳ୍‌ସିଆ ଗତିଦଃଙ୍ଗ୍‌ଳା, ମୁଁୟ୍‌ ଜୁୟ୍‌ତି ବୁଣି ନଃରେୟ୍‌ ସେତି କାଟିନ୍ଦ୍, ଆର୍‌ ଜୁୟ୍‌ତି ତାସ୍‌ ଉଡାଳି ନଃକେରି ସେତି ରୁଣ୍ଡାୟ୍‌ନ୍ଦ୍, ଇରି କାୟ୍‌ ତୁୟ୍‌ ଜାଣିରିଲିସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ତଃବେ ତୁୟ୍‌ କଃଣ୍‌ତର୍‌ ଲାଗାୟ୍‌ ରିଲେକ୍‌, ମୁଁୟ୍‌ ଆସି କଃଣ୍‌ତର୍‌ ସଃଙ୍ଗ୍ ମର୍‌ ଟଃକା ହାୟ୍‌ଲେହୁଣି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଆରେକ୍‌ ସାଉକାର୍‌ କୟ୍‌ଲା, ‘ଇ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଇ ଟଃକା ନଃୟ୍‌ ଜାର୍‌ ଦଃସ୍‌ ଅଃଜାର୍‌ ଟଃକା ଆଚେ, ତାକ୍‌ ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକାର୍‌ ଆଚେ ତାକ୍‌ ଦିଆ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ତାର୍‌ ଜଃବର୍‌ ଅୟ୍‌ଦ୍‌ । ମଃତର୍‌ ଜାର୍‌ ନାୟ୍‌, ତାର୍‌ ହାକ୍‌ ଜାୟ୍‌ରି ଆଚେ, ସେରି ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଆର୍‌ ତୁମିମଃନ୍ ଇ ଅଃଳ୍‌ସିଆ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ହଃଦାୟ୍‌ ଅଃନ୍ଦାରେ ହଃକାଉଆ, ସେତି ସେ କାନ୍ଦି କାନ୍ଦି ଦାତ୍‌ ଚାବି ଅୟ୍‌ଦ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ଜଃଡେବଃଳ୍‌ ସଃବୁ ସଃର୍ଗ୍‌ଦୁତ୍‌ ସଃଙ୍ଗ୍ ରଃଜା ଅୟ୍‌ ଜଃଜ୍‌ମାନ୍ ସଃଙ୍ଗ୍ ନଃରାର୍‌ ହୟ୍‌ସି ଆସେଦ୍‌, ସଃଡେବଃଳ୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସିଙ୍ଗାସଣ୍‌ ଉହ୍ରେ ବଃସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଆରେକ୍‌ ତାର୍‌ ମୁଏଁ ସଃବୁ ବାସାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଗଟେତଃୟ୍‌ଁ କଃରା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ସେମଃନ୍‌କେ ଦୁୟ୍‌ ଦଃଳ୍‌ କଃରି ବାଗ୍ କଃରେଦ୍‌, ଜଃନ୍‌କଃରି ଗଃଉଳିଆ ଚେଳିକ୍‌ ଆର୍‌ ମେଣ୍ଡାକେ ଅଃଲ୍‌ଗା କଃରି, ");
INSERT INTO bdv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ମେଣ୍ଡାମଃନ୍‌କେ ତାର୍‌ କାତା ବାଟ୍ୟା ଆର୍‌ ଚେଳିମଃନ୍‌କେ ତାର୍‌ ଡେବ୍ରି ବାଟ୍ୟା ଟିଆ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତାର୍‌ହଃଚେ ରଃଜା ତାର୍‌ କାତା ବାଟ୍ୟାର୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଦ୍‌, ‘ଆସା, ମର୍‌ ଉବାର୍‌ ଆସିର୍ବାଦ୍‌ ହାୟ୍‌ଲା ଲକ୍‌ମଃନ୍ । ତୁମାର୍‌ ଗିନେ ଜଃଗତାର୍‌ ଆରୁମେ ଜୁୟ୍‌ ରାଇଜ୍‌ ତିଆର୍‌ ଅୟ୍‌ଆଚେ, ଆସା ସେ ରାଇଜାର୍‌ ଅଃଦିକାରି ଅଃଉଆ । ");
INSERT INTO bdv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ବଃଲେକ୍‌ ମୁଁୟ୍‌ ବୁକେ ରିଲେ, ତୁମିମଃନ୍ ମକ୍‌ କାଉଁକେ ଦିଲାସ୍‌; ଆର୍‌ ମୁଁୟ୍‌ ସସେ ରିଲେ, ତୁମିମଃନ୍ ମକ୍‌ ହାଣି ସକୁକ୍‌ ଦିଲାସ୍‌; ମୁଁୟ୍‌ ହଃର୍‌ବାସି ରିଲେ, ମକ୍‌ ରେଉଁକ୍‌ ତୁମାର୍‌ ଗଃରେ ଟାଣ୍ ଦିଲାସ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ମୁଁୟ୍‌ ନଃଗ୍‌ଳା ରିଲେ, ତୁମିମଃନ୍ ମକ୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ଲାସ୍‌; ମଃଳୁହଃଳି ରିଲାବଃଳ୍‌ ମର୍‌ ଜଃତୁନ୍ କଃଲାସ୍‌; ମୁଁୟ୍‌ ଜଃଇଲ୍‌ବିତ୍ରେ ରିଲେ ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁକେ ଆସି ରିଲାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ତଃବେ ଦଃର୍ମି ଲକ୍‌ମଃନ୍ ତାକ୍‌ କଃଉତି, ‘ଏ ମାପ୍ରୁ ଅଃମି କଃବେ ତକେ ବୁକେ ରିଲାର୍‌ ଦଃକି କାଉଁକେ ଦଃୟ୍‌ରିଲୁ ? ଆର୍‌ ସସେ ରିଲାର୍‌ ଦଃକି ହାଣି ସକୁକ୍‌ ଦଃୟ୍‌ରିଲୁ ? ");
INSERT INTO bdv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଆର୍‌ କଃବେ ତକେ ହଃର୍‌ବାସି ରିଲାର୍‌ ଦଃକି, ଅଃମାର୍‌ ଗଃରେ ଟାଣ୍ ଦିଲୁ ? ଆର୍‌ ତକେ ନଃଗ୍‌ଳା ଦଃକି ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ଲୁ ? ");
INSERT INTO bdv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଆର୍‌ କଃବେ ତୁୟ୍‌ ମଃଳୁହଃଳି ରିଲାବଃଳ୍‌ ଆର୍‌ ଜଃଇଲେ ରିଲା ବଃଳ୍‌ ଅଃମି ତର୍‌ ଲଃଗେ ଆସିରିଲୁ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ସଃଡେବଃଳ୍‌ ରଃଜା ସେମଃନ୍‌କେ କୟ୍‌ଦ୍‌, ‘ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ମର୍‌ ଇ ଇନସ୍ତା ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ନିଗାଳ୍‌ ଲକ୍‌କେ ଇସଃବୁ କଃରି ରିଲାସ୍‌ ବଃଲି ସେରି ସଃବୁ ତୁମିମଃନ୍ ମକେ କଃରିଆଚାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ତାର୍‌ହଃଚେ ରଃଜା ତାର୍‌ ଡେବ୍ରି ବାଟ୍ୟାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ହେଁ କୟ୍‌ଦ୍‌, ‘ଏ ଇସ୍ୱରାର୍‌ ସାୟ୍‌ପ୍‌ ହାୟ୍‌ଲା ଲକ୍‌ମଃନ୍ ମର୍‌ ମୁୟେଁହୁଣି ଦୁର୍‌ ଅଃଉଆ ! ଆର୍‌ ସୟ୍‌ତାନ୍ ଆର୍‌ ତାର୍‌ ଦୁତ୍‌ ମଃନାର୍‌ ଗିନେ ସଃବୁ ଦିନାର୍‌ ହାଁୟ୍‌ ଜୁୟ୍‌ ଜୟ୍‌ ତିଆର୍‌ ଅୟ୍‌ଆଚେ ସେତି ଜଃହା । ");
INSERT INTO bdv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ବଃଲେକ୍‌ ମୁଁୟ୍‌ ବୁକେ ରିଲେ ତୁମିମଃନ୍ ମକ୍‌ କାଉଁକେ ନଃଦିଲାସ୍‌; ସସେ ରିଲେ, ମକେ ହାଣି ସକୁକ୍‌ ନଃଦିଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ମୁଁୟ୍‌ ହଃର୍‌ବାସି ରିଲେ, ମକ୍‌ ତୁମିମଃନ୍ ଟାଣ୍ ନଃଦିଲାସ୍‌; ମୁଁୟ୍‌ ନଃଗ୍‌ଳା ରିଲେ, ମକ୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦୁକେ ନଃଦିଲାସ୍‌; ମୁଁୟ୍‌ ମଃଳୁହଃଳି ରିଲେ ଆର୍‌ ଜଃଇଲେ ରିଲେ, ମକ୍‌ ଦଃକୁକେ ନାୟ୍‌ଲାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ତଃବେ ସେମଃନ୍ ହେଁ କଃଉତି, ‘ଏ ମାପ୍ରୁ, କଃବେ ଅଃମିମଃନ୍‌ ତକେ ବୁକେ ରିଲାର୍‌ କି ସସେ ରିଲାର୍‌, ଆର୍‌ ହଃର୍‌ବାସି ରିଲାର୍‌ କି ନଃଗ୍‌ଳା ରିଲାର୍‌, ଆର୍‌ ମଃଳୁହଃଳି ରିଲାର୍‌ କି ଜଃଇଲେ ରିଲାର୍‌ ଦଃକି ତର୍‌ ସେବା ନଃକେଲୁ ?’ ");
INSERT INTO bdv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ତଃବେ ରଃଜା ସେମଃନ୍‌କେ କୟ୍‌ଦ୍‌, ‘ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ଇନସ୍ତା ଲକାର୍‌ ବିତ୍ରାର୍‌ ଗଟେକ୍‌ ନିଗାଳ୍‌ ଲକ୍‌କେ ହେଁ ଇ ସଃବୁ କଃରି ନଃରିଲାର୍‌ଗିନେ ତୁମିମଃନ୍ ମକ୍‌ ନଃକେଲାସ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଆର୍‌ ଇ ଲକ୍‌ମଃନ୍ ସଃବୁ ଦିନାର୍‌ ଗିନେ ଡଃଣ୍ଡ୍‌ ବଃଗ୍‌ତି, ମଃତର୍‌ ଦଃର୍ମି ଲକ୍‌ମଃନ୍ ସଃବୁ ଦିନାର୍‌ ଗିନେ ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ଅଃଦିକାରି କଃରୁକେ ଜାତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଜିସୁ ଇ ସଃବୁ କଃତା କୟ୍‌ଲା ହଃଚେ, ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଅଃଉଁକେ ଅଃବେ ଦୁୟ୍‌ ଦିନ୍ ଆଚେ, ଇରି ତୁମିମଃନ୍ ଜାଣାସ୍‌ । ଆରେକ୍‌ ସଃଡେବଃଳ୍‌ କ୍ରୁସ୍‌ କାଟେ ମଃରୁକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ସଃହ୍ରି ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଲକ୍‌ମଃନାର୍‌ ପାରାଚିନ୍‌ମଃନ୍ କୟାପା ନାଉଁଆର୍‌ ମୁଳ୍‌ ଜାଜକାର୍‌ କୁଆଳେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଆର୍‌ ସେମଃନ୍ ଜିସୁକେ କେ ନଃଜାଣ୍‌ଲା ହର୍‌ ଦଃରି ମାରୁକ୍‌ କୁଟ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମଃତର୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ହଃର୍ବ୍‌ ବଃଳ୍‌ ନୟ୍‌, କେଜାଣ୍ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ମାଡ୍‌ଗଳ୍‌ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଜିସୁ ବେତାନିଆର୍‌ ବଃଡ୍‌ ରଗେ ହୁଣି ଉଜ୍‌ ଅୟ୍‌ରିଲା ସିମନ୍‌ ଗଃରେ ରିଲାବଃଳ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ଗଟ୍‌ ମାୟ୍‌ଜି ଆଲାବାସ୍ଟେର୍‌ ନାଉଁଆର୍‌ ଟେଳାୟ୍‌ ତିଆର୍‌ ଅୟ୍‌ଲା କଣ୍ଡାୟ୍‌ ବେସି ମଲାର୍‌ ବାସ୍ନା ଚିକଣ୍‌ ଦଃରି ଜିସୁର୍‌ ହାକ୍‌ ଆୟ୍‌ଲି, ଆର୍‌ ଜିସୁ କାଉଁକେ ବଃସି ରିଲାବଃଳ୍‌ ତାର୍‌ ମୁଣ୍ଡେ ଡାଳୁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ଚେଲାମଃନ୍ ଇ ସଃବୁ ଦଃକି ରିସା ଅୟ୍‌ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃତେକ୍‌ ଚିକଣ୍‌ କାୟ୍‌ତାକ୍‌ ହର୍ଚ୍ ଅଃଉଁଲି ? ");
INSERT INTO bdv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଇ ଚିକଣ୍‌ ତ ବୁତେକ୍‌ ମଲେ ବିକିକଃରି ସେ ଡାବୁ ନୟ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଦିଲେକ୍‌ ଅୟ୍‌ଲି ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଜିସୁ ଚେଲାମଃନାର୍‌ କଃତା ସୁଣି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ ତୁମିମଃନ୍ ଇ ମାୟ୍‌ଜିଟକିକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲାସ୍‌ ? ସେ ତ ମର୍‌ ଗିନେ ଗଟେକ୍‌ ବଃଡେ ନିକ ଆର୍‌ ସୁନ୍ଦୁର୍‌ କାମ୍‌ କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ଗଃରିବ୍‌ ଲକ୍‌ମଃନ୍ ତ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗେ ଆଚ୍‌ତି, ମଃତର୍‌ ମୁଁୟ୍‌ ସଃବୁ ବଃଳ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ନଃରେୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ମଃତର୍‌ ସେ ମର୍‌ ଗଃଗାଳ୍‌ ଉହ୍ରେ ବାସ୍ନା ଚିକଣ୍‌ ଡାଳି ମକ୍‌ ତହ୍‌ତା ଦିନାର୍‌ ଗିନେ ତିଆର୍‌ କଃଲା ହର୍‌ ଇରି କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଗୁଳା ଜଃଗତାର୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ ଅୟ୍‌ଦ୍‌, ସେ ଟାଣେ ଇ ମାୟ୍‌ଜିଟକିକ୍‌ ମଃନେ ହଃକାଉତା ଗିନେ ସେ କଃରି ରିଲା ଇ କାମାର୍‌ କଃତା ହେଁ କଃଉଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ସଃଡେବଃଳ୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ନାଉଁଆର୍‌ ଗଟ୍‌ ଚେଲା ଜାଜକ୍‌ ହାକ୍‌ ଜାୟ୍‌କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ମକ୍‌ କାୟ୍‌ରି ଦିଆସ୍‌ କଃଉଆ, ମୁଁୟ୍‌ ଜିସୁକେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ?” ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ତିରିସ୍‌ ଗଟ୍‌ ରୁହା ଟଃକା ଗଃଣିକଃରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ସଃଡେବଃଳ୍‌ ହୁଣି ଜିଉଦା ଜିସୁକେ ସେମଃନାର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦେଉଁକେ ବାଟ ଲଳୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","କମିର୍‌ ନୟ୍‌ଲା ରୁଟି ହଃର୍ବାର୍‌ ହଃର୍ତୁମ୍‌ ଦିନ୍ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆସିକଃରି ହଃଚାର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ କୁୟ୍‌ଟାଣେ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି ତିଆର୍‌ କଃରୁନ୍ଦ୍‌ ବଃଲି ତୁୟ୍‌ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଃଳ୍‌ ବିତ୍ରେ ହଃଲ୍‌ନା ଲକାର୍‌ ହାକ୍‌ ଜାୟ୍‌, ତାକ୍‌ କଃଉଆ, ଗୁରୁ କଃଉଁଲା, ‘ମର୍‌ ବେଳା ଚଃମେ ଅୟ୍‌ଲିନି, ମୁଁୟ୍‌ ମର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ତର୍‌ ଗଃରେ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ କାଉଁନ୍ଦ୍ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଜିସୁ କୟ୍‌ଲା ହର୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି ତିଆର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ହଃଚେ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ଜିସୁ ତାର୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ସେମଃନ୍ କାତି ରିଲାବଃଳ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକ୍‌ ମକ୍‌ ସଃତ୍ରୁମଃନାର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଇ କଃତା ସୁଣି ଚେଲାମଃନ୍ ବଃଡେ ଦୁକ୍‌ କଃଲାୟ୍‌, ଆର୍‌ ସଃବୁ ଚେଲା ଜିସୁକେ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ମାପ୍ରୁ ମୁଁୟ୍‌ କି ସେ ଲକ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ କୟ୍‌ଲା, “ଜେ ମର୍‌ ସଃଙ୍ଗ୍ କପାୟ୍‌ ଆତ୍‌ ବୁଡାୟ୍‌ଦ୍‌, ସେ ମକ୍‌ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ କଃତା ସାସ୍ତରେ ଜଃନ୍‌କଃରି ଲେକା ଅୟ୍‌ଆଚେ, ସେରଃକମ୍‌ ସେ ମଃରୁକ୍‌ ଜଃଉଁଲା ସଃତ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲକାର୍‌ ଆତେହୁଣି ନଃରାର୍‌ ହୟ୍‌ସି ସଃତ୍ରୁର୍‌ ଆତେ ଦଃରାୟ୍‌ ଅଃଉଁଲା, ଚି ସେ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌, ସେଲକାର୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ନଃରିଲେକ୍‌ ନିକ ଅୟ୍‌ଲି ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ଇତାକ୍‌ ଜୁୟ୍‌ ଜିଉଦା ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରିଦିଲା, ସେ ହଃଚାର୍ଲା, “ଗୁରୁ, ସେ ଲକ୍‌ କି ମୁଁୟ୍‌ ?” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ହେଁ ତୁୟ୍‌ କୟ୍‌ ଆଚ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଆର୍‌ ସେମଃନ୍ କାତି ରିଲାବଃଳ୍‌ ଜିସୁ ରୁଟି ଦଃରି ଇସ୍ୱର୍‌କେ ଦନ୍ୟବାଦ୍‌ ଦିଲା ଆର୍‌ ସେରି ଆସିର୍ବାଦ୍‌ କଃରି ଚେଲାମଃନ୍‌କେ ଦଃୟ୍‌ କୟ୍‌ଲା, “ନିଆ କାହା, ଇରି ମର୍‌ ଗଃଗାଳ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ହଃଚେ ସେ ଗଟେକ୍‌ କପାୟ୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଦଃରି ଇସ୍ୱର୍‌କେ ଦନ୍ୟବାଦ୍‌ ଦିଲା ଆର୍‌ ଚେଲାମଃନ୍‌କେ ଦଃୟ୍‌ କୟ୍‌ଲା, “ଇରି ସଃବୁଲକ୍‌ ଡୁକା, ");
INSERT INTO bdv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଇରି ମର୍‌ ବଃନି, ଲକ୍‌ମଃନାର୍‌ ହାହ୍‌ କେମା ଗିନେ ମୁଁୟ୍‌ ମର୍‌ ଜୁୟ୍‌ ବଃନି ଡାଳି ଦେଉଁକେ ଜଃଉଁଲେ, ଜୁୟ୍‌ରି ଇସ୍ୱରାର୍‌ ନଃଉଆଁ ବିଦିର୍‌ ଗଟ୍‌ ଚିନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ ଦିନ୍ ମୁଁୟ୍‌ ମର୍‌ ଉବାର୍‌ ରାଇଜେ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ନଃଉଆକଃରି ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଡୁକିନ୍ଦ୍, ସେଦିନ୍ ହଃତେକ୍‌ ଆଜିହୁଣି ମୁଁୟ୍‌ ଇରି କଃବେହେଁ ନଃକାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଆରେକ୍‌ ସେମଃନ୍ ଦନ୍ୟବାଦ୍‌ ଗିତ୍‌ କୟ୍‌ଲା ହଃଚେ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ସଃଡେବଃଳ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଆଜି ରାତି ତୁମିମଃନ୍ ସଃବୁ ଲକ୍‌ ମକ୍‌ ଚାଡି ହଃଳାଉଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ଅଃମି ମେଣ୍ଡା ଗଃଉଳିଆକ୍‌ ମାରୁଆଁ ଆର୍‌ ମଃନ୍ଦାର୍‌ ମେଣ୍ଡାମଃନ୍ ଜଃତ୍‌କଃତ୍‌ ଅଃଉତି ।’ ");
INSERT INTO bdv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ମଃତର୍‌ ମୁଁୟ୍‌ ମଃରିକଃରି ଆରେକ୍‌ ଉଟ୍‌ଲା ହଃଚେ, ତୁମାର୍‌ ଆଗେ ଗାଲିଲିକେ ଜାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ମଃତର୍‌ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଅୟ୍‌ଲେକ୍‌ ହେଁ ସଃବୁଲକ୍‌ ତକେ ଚାଡି ହଃଳାଉତି, ମଃତର୍‌ ମୁଁୟ୍‌ କଃବେ ହେଁ ଚାଡି ନଃଜାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ପିତର୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତକେ ସଃତ୍‌ କଃଉଁଲେ, ଆଜି ରାତି କୁକ୍‌ଳା ନଃବାସ୍ତା ଆଗ୍‌ତୁ ତୁୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି ତିନିତର୍‌ କଃଉସି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଜଦି ମକ୍‌ ତର୍‌ ସଃଙ୍ଗ୍ ମଃରୁକ୍‌ ହଃଳେଦ୍‌ ତଃବେ ହେଁ ମୁଁୟ୍‌ ତକେ ନଃଜାଣି ବଃଲି କଃବେ ହେଁ କଃଉନଃଚି ।” ଆର୍‌ ସଃବୁ ଚେଲାମଃନ୍ ହେଁ ସେରଃକମ୍‌ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ଇତାର୍‌ହଃଚେ ଜିସୁ ତାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗେତ୍‌ସିମନି ନାଉଁଆର୍‌ ବାଳେ ଗଃଲାୟ୍‌, ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ସେତି ଜାୟ୍‌ ମୁଁୟ୍‌ ପାର୍ତ୍‌ନା କଃରି ଆସ୍ତା ହଃତେକ୍‌ ତୁମିମଃନ୍ ଇତି ବଃସିରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଜିସୁ ପିତର୍‌ ଆର୍‌ ଜେବଦିର୍‌ ଜୁଳେକ୍‌ ହୟ୍‌ସିକ୍‌ ସଃଙ୍ଗେ ନିଲା, ଆର୍‌ ସେ ମଃନ୍ ବିତ୍ରେ ବଃୟା ବିକଳ୍‌ ଅଃଉଁକେ ଦଃର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ହଃରାଣ୍ ମଃର୍ତା ହର୍‌ ଉକ୍‌ଳି ଜଃଉଁଲି, ତୁମିମଃନ୍ ଇତି ରଃୟ୍‌ ଜାଗିରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଆରେକ୍‌ ଜିସୁ ଅଃଳକ୍‌ ଦୁରି ଆଗେ ଜାୟ୍‌କଃରି ମାଣ୍ଡିକୁଟା ଦଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଏ ମର୍‌ ଉବା, ଜଦି ତର୍‌ ଇଚା, ତଃବେ ଇ ଦୁକ୍‌ କଃସ୍ଟାର୍‌ କପା ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌ ଅଃଉଅ, ମଃତର୍‌ ଇରି ମର୍‌ ଇଚା ନାୟ୍‌, ତର୍‌ ଇଚା ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ଆର୍‌ ସେ ଚେଲାମଃନାର୍‌ ହାକ୍‌ ଆସି ସେମଃନ୍‌କେ ସଇରିଲାର୍‌ ଦଃକ୍‌ଲା, ଆର୍‌ ସେ ପିତର୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ଚଃନେକ୍‌ ହେଁ ଜାଗୁ ନାହାର୍ଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ତୁମିମଃନ୍ ହାନ୍ଦାୟ୍‌ ଜଃନ୍‌କଃରି ନଃହେଳାସ୍‌, ଇତାର୍‌ ଗିନେ ଜାଗି ରଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରା; ତୁମାର୍‌ ଆତ୍ମାର୍‌ ଇଚା ସଃତ୍‌, ମଃତର୍‌ ଗଃଗାଳ୍‌ ଦୁର୍ବୁଳ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଆରେକ୍‌ ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଜାୟ୍‌ ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଏ ମର୍‌ ଉବା, ନଃଡୁକ୍‌ଲେକ୍‌ ଦୁକ୍‌ କଃସ୍ଟାର୍‌ କପା ଜଦି ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌ ଅଃଉଁ ନାହାରେ, ତଃବେ ତର୍‌ ଇଚା ହୁରୁଣ୍ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ତାର୍‌ହଃଚେ ଜିସୁ ବାଉଳି ଆସି ଆରେକ୍‌ ଚେଲାମଃନ୍‌କେ ସଇରିଲାର୍‌ ଦଃକ୍‌ଲା, ବଃଲେକ୍‌ ସେମଃନାର୍‌ ଆକି ନିଦେ ଡାହି ଅଃଉତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ସେତାକ୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ ଚାଡି ଆରେକ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ଗଃଲା, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ସେରଃକମ୍‌ କଃତା କୟ୍‌କଃରି ତିନିଜରା ପାର୍ତ୍‌ନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତାର୍‌ହଃଚେ ସେ ଚେଲାମଃନାର୍‌ ଲଃଗେ ବାଉଳି ଆସିକଃରି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଚଃନେକ୍‌ ହର୍‌ ସଇକଃରି ବିସାଉଆ, ଦଃକା ସେ ବେଳ୍‌ ଚଃମେ ହଚ୍‌ଲିନି । ଆରେକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ହାହିମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅଃଉଁକେ ଜଃଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ଉଟା, ଅଃମିମଃନ୍‌ ଜୁଆଁ, ହଦେ ଦଃକା ! ଜେ ମକ୍‌ ସଃତ୍ରୁର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେ ମର୍‌ ଲଃଗେ ଆସି କେଟ୍‌ଲାବେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁ ଇ କଃତା କଃଉତି ରିଲାବଃଳ୍‌, ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ନାଉଁଆର୍‌ ଗଟ୍‌ ଚେଲା ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଟ୍‌ମଃନ୍ଦା ଲକ୍‌ କଃଣ୍ଡା ଆର୍‌ ଟେଙ୍ଗା ଦଃରିକଃରି ଆୟ୍‌ଲାୟ୍‌, ସେମଃନ୍‌କେ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଲକ୍‌ମଃନାର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ହଃଟାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ଆର୍‌ ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦେତା ଜିଉଦା ଜିସୁ କୁୟ୍‌ରି ବଃଲି ସେମଃନ୍‌କେ ଚିନାଉତା ଗିନେ ଇ ଚିନ୍ ଦଃୟ୍‌ କୟ୍‌ରିଲା, “ମୁଁୟ୍‌ ଜାକେ ଚୁମିନ୍ଦ୍ ସେ ହଃକା ଜିସୁ, ତାକ୍‌ ତୁମିମଃନ୍ ଦଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଆର୍‌ ଜିଉଦା ସେଦାହ୍ରେ ଜିସୁର୍‌ ଲଃଗେ ଆସି “ଏ ଗୁରୁ ଜୁଆର୍‌” ଇରି କୟ୍‌ ତାକ୍‌ ଚୁମ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ବାୟ୍‌, ତୁୟ୍‌ ଜୁୟ୍‌ କାମ୍‌ କଃରୁକେ ଆସି ଆଚ୍‌ସି, ସେରି ବେଗି କଃର୍‌ ।” ତାର୍‌ହଃଚେ ଜିଉଦା ସଃଙ୍ଗ୍ ଆସିରିଲା ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃରି ବାନ୍ଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଜିସୁର୍‌ ସଃଙ୍ଗେ ରିଲା ଗଟେକ୍‌ ଚେଲା ତାର୍‌ କଃଣ୍ଡା ବେଟିକଃରି ମୁଳ୍‌ ଜାଜକାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାର୍‌ କାନ୍‌ କାଟି ହଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତର୍‌ କଃଣ୍ଡାକ୍‌ କାପ୍ ବିତ୍ରେ ସଃଙ୍ଗାଉ, ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ କଃଣ୍ଡା ଦଃର୍ତି, ସେମଃନ୍ କଃଣ୍ଡା ସଃଙ୍ଗ୍ ହଃକା ନାସ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ଆରେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ରି ମଃନେ ବାବୁଲାସ୍‌, ମୁଁୟ୍‌ ଜଦି ମର୍‌ ଉହ୍‌କାର୍‌ ଗିନେ ମର୍‌ ଉବାକ୍‌ ଗଃଉଆରି କଃଲେକ୍‌ ସେ ଅଃବେ ସଃଙ୍ଗେ ସଃଙ୍ଗେ ମର୍‌ ଗିନେ ବାରଗଟ୍‌ ନିଜାର୍‌ ଦଃଳ୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌କେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ତଃବେ ଇରଃକମ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଗଃଟେଦ୍‌ ବଃଲି ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ଁ ଜାୟ୍‌ରି ଲେକା ଆଚେ, ସେରି କଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ସଃଡେବଃଳ୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଟେକ୍‌ କଃଙ୍ଗାର୍‌ ବିରଦେ ବାରାୟ୍‌ଲାହର୍‌ କଃଣ୍ଡା ଆର୍‌ ଟେଙ୍ଗା ଦଃରି ତୁମିମଃନ୍ କାୟ୍‌ରି ମକ୍‌ ଦଃରୁକ୍‌ ଆୟ୍‌ଲାସ୍‌ ? ସଃବୁ ଦିନ୍ ମୁଁୟ୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ବଃସି ସିକ୍ୟା ଦେତିରିଲେ, ମଃତର୍‌ ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ନଃଦେର୍‌ଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ମଃତର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌ ସେତାକ୍‌ ଇସଃବୁ ଅୟ୍‌ଆଚେ ।” ସଃଡେବଃଳ୍‌ ସବୁ ଚେଲାମଃନ୍ ଜିସୁକେ ଚାଡି ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ କୟାପା ମୁଳ୍‌ ଜାଜକ୍‌ ଗଃରେ ନିଲାୟ୍‌ । ସେତି ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ରୁଣ୍ଡି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍‌ କଃଣ୍ଡେକ୍‌ ଦୁରିରଃୟ୍‌ ମୁଳ୍‌ ଜାଜକାର୍‌ କୁଆଳ୍‌ ହଃତେକ୍‌ ଜିସୁର୍‌ ହଃଚେହଃଚେ ଗଃଲା । ଜିସୁକେ ସେମଃନ୍ କଃନ୍‌କଃର୍ତି ସେରି ଦଃକୁକେ ସେ ବିତ୍ରେ ଜାୟ୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ସଃଙ୍ଗ୍ ବଃସିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌ ଆର୍‌ ସଃବୁ ବଃଡ୍‌କୁଟୁମେ ବଃସିରିଲା ଜିଉଦି ଲକ୍‌ମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ ତାର୍‌ ବିରଦେ ମିଚ୍ ସାକିମଃନ୍‌କେ ଲଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ଗାଦେକ୍‌ ଲକ୍‌ ଜିସୁର୍‌ ବିରଦେ ମିଚ୍ ସାକିମଃନ୍ ବାରାୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ କାୟ୍‌ରି ନଃହାୟ୍‌ଲାୟ୍‌ । ମଃତର୍‌ ସଃରାସଃରି ବଃଳ୍‌ ଦୁୟ୍‌ଲକ୍‌ ବାରାୟ୍‌ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ଇ ମାନାୟ୍‌ କୟ୍‌ଆଚେ, ‘ମୁଁୟ୍‌ ଇସ୍ୱରାର୍‌ ମନ୍ଦିର୍‌କେ ବାଙ୍ଗିକଃରି ସେରି ତିନିଦିନାର୍‌ ବିତ୍ରେ ଆରେକ୍‌ ବାନ୍ଦୁ ହାରିନ୍ଦ୍ ।’” ");
INSERT INTO bdv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ମୁଳ୍‌ ଜାଜକ୍‌ ଟିଆ ଅୟ୍‌କଃରି ଜିସୁକେ କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ତାକ୍‌ କାୟ୍‌ରି ନଃକଉଁଲିସ୍‌ ? ତର୍‌ ବିରଦେ ଇମଃନ୍‌ ଜୁୟ୍‌ ସାକି ଦେଉଁଲାୟ୍‌, ଇରି କାୟ୍‌ରି ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମଃତର୍‌ ଜିସୁ ତୁନ୍‌ହାଳି ରିଲା; ସେତାକ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତକେ ଜିବନ୍‌ ରିଲା ଇସ୍ୱରାର୍‌ ନାଉଁଏ ହଃର୍ମାଣ୍‌ କଃରି ହଃଚାରୁଲେ, ମକ୍‌ କଃଉ, ତୁୟ୍‌ କି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି କ୍ରିସ୍ଟ ବଃଲେକ୍‌ ମସିଆ ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ତ କୟ୍‌ଲିସ୍‌, ଆରେକ୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଆଜିହୁଣି ତୁମିମଃନ୍ ନଃରାର୍‌ ହୟ୍‌ସିକ୍‌ ସଃବ୍‌କେ ଉଟ୍ୟା ସଃକାତ୍‌ ଇସ୍ୱରାର୍‌ କାତା ବାଟ୍ୟା ବଃସି ରିଲାର୍‌ ଆର୍‌ ଅଃଗାସ୍‌ ଉହ୍ରେ ଆସ୍ତାର୍‌ ଦଃକାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ସେତାକ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ଚିରି କୟ୍‌ଲା, “ଇମାନାୟ୍‌ ଇସ୍ୱରାର୍‌ ଲିନ୍ଦା କଃଲା, ଅଃମାର୍‌ ଆର୍‌ ସାକି କାୟ୍‌ତାକ୍‌ ଲଳା ? ଦଃକା ତୁମିମଃନ୍ ଅଃବେ ହେଁ ଇସ୍ୱର୍‌କେ ଲିନ୍ଦା କଃଲାର୍‌ ସୁଣ୍‌ଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ତଃବେ ତୁମିମଃନ୍ କାୟ୍‌ରି ବଃଲୁଲାସ୍‌ ।” ସେତାକ୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସେ ଦସି, ସେ ମଃର୍ନ୍‌ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ମୁୟେ ଲାଳ୍‌ ତୁକ୍‌ଲାୟ୍‌, ଆର୍‌ ତାକେ ବିଦା ମାର୍‌ଲାୟ୍‌; ଆର୍‌ କେ କେ ଜିସୁକେ ଚାହୁଳ୍‌ ମାରି କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଏ କ୍ରିସ୍ଟ, ତୁୟ୍‌ ଜଦି ବାବ୍‌ବାଣି କଃଉତା ଲକ୍‌, ତଃବେ ଅଃମିକ୍‌ କଃଉ, କେ ତକେ ମାର୍ଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ଇବିତ୍ରେ ପିତର୍‌ ହଃଦାର୍‌ କୁଆଳେ ବଃସିରିଲା, ଆର୍‌ ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳି ଆସି ତାକ୍‌ କୟ୍‌ଲି, “ତୁୟ୍‌ ହେଁ ଗାଲିଲିର୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ରିଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମଃତର୍‌ ପିତର୍‌ ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ମୁଏଁ ନାୟ୍‌ ବଃଲି କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ରି କଃଉଁଲିସ୍‌, ସେରି ମୁଁୟ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଆରେକ୍‌ ପିତର୍‌ ହଃଦାର୍‌ ଦୁଆର୍‌ ଲଃଗେ ବାରାୟ୍‌ ଗଃଲାକେ, ଆରେକ୍‌ ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳି ତାକ୍‌ ଦଃକିକଃରି ସେତି ରିଲା ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲି, “ଇ ମାନାୟ୍‌ ନାଜରିତ୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ନାୟ୍‌ ବଃଲି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ହଃର୍ମାଣ୍‌ କଃରି କଃଉଁଲେ, ସେମାନାୟ୍‌କେ ମୁଁୟ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଚଃନେକ୍‌ ହଃଚେ ସେତି ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ପିତର୍‌ ଚଃମେ ଆସି ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ହେଁ ବାୟ୍‌ଦ୍‌ରେ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌, ବଃଲେକ୍‌ ତର୍‌ କଃତା କଃଉତାର୍‌ ଜାଣା ହଃଳୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ସେତାକ୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ହଃର୍ମାଣ୍‌ କଃରି ସଃତ୍‌ କଃଉଁଲେ, ସେନ୍ ନୟ୍‌ଲେକ୍‌ ଇସ୍ୱର୍‌ ମକ୍‌ ଡଃଣ୍ଡ୍‌ ଦେଉଅ । ମୁଁୟ୍‌ ସେମାନାୟ୍‌କେ ନଃଜାଣି ।” ସେଦାହ୍ରେ କୁକ୍‌ଳା ବାସ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଆର୍‌ ସଃଡେବଃଳ୍‌ ପିତର୍‌କେ ଜିସୁ କୟ୍‌ରିଲା କଃତା ମଃନେ ହଃଳ୍‌ଲି, ଜିସୁ କୟ୍‌ରିଲା, “କୁକ୍‌ଳା ନଃବାସ୍ତା ଆଗ୍‌ତୁ ତୁୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି ତିନିତର୍‌ କଃଉସି ।” ପିତର୍‌ ହଃଦାୟ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ ବଃଡେ ଦୁକ୍‌ ଅୟ୍‌ କାନ୍ଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ସଃକାଳ୍‌ ଅୟ୍‌ଲାକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ ତାର୍‌ ବିରଦେ ଗୁସ୍ଟୁ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ସେମଃନ୍ ଜିସୁକେ ସିକ୍ଳି ସଃଙ୍ଗ୍ ବାନ୍ଦି ରମିୟ ସାସନ୍‌କଃର୍ତା ପିଲାତ ନାଉଁଆର୍‌ ଗର୍ନର୍‌ ଆତେ ସଃହ୍ରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ସଃଡେବଃଳ୍‌ ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା ଜିଉଦା, ଜିସୁ ମଃର୍ନ୍‌ ଦଃଣ୍ଡ୍‌ ହାୟ୍‌ ଆଚେ, ଇରି ଦଃକିକଃରି ସେ ନିଜାର୍‌ ବୁଲ୍‌ କାମ୍‌କେ ଏତାୟ୍‌ ଦୁକ୍‌କଃରି ମଃନ୍‌ବାଦ୍‌ଲାୟ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ଲଃଗେ ସେ ତିରିସ୍‌ ଗଟ୍‌ ରୁହା ଟଃକା ବାଉଳାୟ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ମୁଁୟ୍‌ ଗଟେକ୍‌ ନିର୍ଦସି ଲକ୍‌କେ ମଃର୍ନ୍‌ ଦଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ସଃହ୍ରି ଦଃୟ୍‌ ହାହ୍‌ କଃରିଆଚି ।” ମଃତର୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସେ କଃତାୟ୍‌ ଅଃମାର୍‌ କାୟ୍‌ରି ଆଚେ ? ସେ କଃତା ତୁୟ୍‌ ବୁଜ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ସେତାକ୍‌ ଜିଉଦା ରୁହା ଟଃକା ସଃବୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହଃବ୍ଳାୟ୍‌କଃରି ହଃଳାୟ୍‌ଲା, ତାର୍‌ହଃଚେ ସେ ଜାୟ୍‌ ନିଜେ ଉଚ୍‌କି ଅୟ୍‌ ମଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମଃତର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌ ସେ ରୁହା ଟଃକା ନଃୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଇ ଟଃକା ମନ୍ଦିରାର୍‌ ଟଃକା ସଃଙ୍ଗ୍ ଗଟେ ଟାଣେ ମିସାୟ୍‌ ବଃଣ୍ଡାର୍‌ ବିତ୍ରେ ସଃଙ୍ଗାଉତା ବିଦି ନୟ୍‌, ବଃଲେକ୍‌ ଇରି ଗଟ୍‌ ଲକାର୍‌ ବଃନିର୍‌ ମଲ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ସେମଃନ୍ ଇ ଟଃକାକ୍‌ କାୟ୍‌ କଃରୁଆଁ ବଃଲି କଃତା ଅୟ୍‌କଃରି ବିନ୍‌ଦେସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ମଃସୁଣ୍‌ ଗିନେ ଗଟ୍‌ କୁମ୍ବାର୍‌ ଲକାର୍‌ ବୁୟ୍‌ଁ ସେ ଟଃକା ଦଃୟ୍‌ ଗେନ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ସେତାର୍‌ଗିନେ ଆଜି ହଃତେକ୍‌ ସେ ହଃଦାକେ “ବଃନି ହଃଦା” ବଃଲି କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଇରଃକମ୍‌ ଜିରିମିୟ ବାବ୍‌ବାଦି କୟ୍‌ରିଲା ବାବ୍‌ବାଣି ହୁରା ଅୟ୍‌ଲି, “ଜାୟ୍‌ରି ତିରିସ୍‌ ଟଃକାୟ୍‌ ବିକୁକ୍‌ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍ ତିର୍‌ କଃରି ରିଲାୟ୍‌, ସେ ତିରିସ୍‌ ଟଃକା ସେମଃନ୍ ନଃୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ସେ କୁମ୍ବାର୍‌ ଲକାର୍‌ ହଃଦା ଗେନ୍‌ଲାୟ୍‌ । ଇରି କଃରୁକେ ମକ୍‌ ଇସ୍ୱର୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁକେ ରମିୟ ଗର୍ନରାର୍‌ ପିଲାତର୍‌ ଚଃମେ ଟିଆ କଃଲାୟ୍‌, ଆର୍‌ ଗର୍ନରାର୍‌ ପିଲାତ ଜିସୁକେ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଜିଉଦିମଃନାର୍‌ ରଃଜା ?” ଜିସୁ କୟ୍‌ଲା, “ହେଁ, ତୁୟ୍‌ କଃଉଁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ମଃତର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ଜିସୁର୍‌ ବିରଦେ ଦଃସ୍‌ ଦଃକାୟ୍‌ କୟ୍‌ଲାକ୍‌, ଜିସୁ କାୟ୍‌ରି ହେଁ ନଃକୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ସେତାକ୍‌ ପିଲାତ ଜିସୁକେ କୟ୍‌ଲା, “ଇମଃନ୍‌ ତର୍‌ ବିରଦେ କଃତେକ୍‌ ସାକି ଦେଉଁଲାୟ୍‌, ସେ ସଃବୁ ତୁୟ୍‌ କାୟ୍‌ ନଃସୁଣୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମଃତର୍‌ ଜିସୁ କଃତା ହଃଦେକ୍‌ ହେଁ କାୟ୍‌ରି ନଃକୟ୍‌ଲା, ତଃବେ ପିଲାତ ବଃଡେ କାବା ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ସଃବୁ ବଃର୍ସ୍‌ ନିସ୍ତାର୍‌ ହଃର୍ବ୍‌ ବଃଳ୍‌ ଲକ୍‌ମଃନାର୍‌ ଇଚାୟ୍‌ ଗଟେକ୍‌ କଃୟ୍‌ଦିକେ ସେମଃନାର୍‌ ଗିନେ ଚାଡି ଦେତାର୍‌ ରମିୟ ସଃର୍କାରାର୍‌ ଗର୍ନରାର୍‌ ରିତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ସଃଡେବଃଳ୍‌ ସେମଃନାର୍‌ ବାରବା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ବଃଡ୍ କୟ୍‌ଦି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ତଃବେ ସେମଃନ୍ ଗଟ୍‌ତଃୟ୍‌ ରୁଣ୍ଡ୍‌ଲାବଃଳ୍‌ ପିଲାତ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମୁଁୟ୍‌ ତୁମାର୍‌ ଗିନେ କାକେ ଚାଡି ଦଃୟ୍‌ନ୍ଦ୍ ବଃଲି ତୁମିମଃନ୍ ଇଚା କଃରୁଲାସ୍‌ ? ବାରବାକେ କି ଜାକେ କ୍ରିସ୍ଟ ବଃଲି କଃଉତି, ସେ ଜିସୁକେ ?” ");
INSERT INTO bdv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିଉଦି ନେତାମଃନ୍ ଜେ ଡାରା ଅୟ୍‌କଃରି ଜିସୁକେ ସଃହ୍ରି ଦଃୟ୍‌ରିଲାୟ୍‌, ସେରି ପିଲାତ ଜାଣି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ଆର୍‌ ପିଲାତ ବିଚାର୍‌ କଃର୍ତା ଟାଣେ ବଃସିରିଲାବଃଳ୍‌ ତାର୍‌ ଡକୁର୍ସି ତାର୍‌ ଚଃମେ କବୁର୍‌ ହଃଟାୟ୍‌ଲି, “ସେ ଦଃର୍ମି ଲକାର୍‌ କଃତାୟ୍‌ ତୁୟ୍‌ ମୁଳ୍‌କେ ଆତ୍‌ ଦେସ୍‌ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ଆଜି ଚଃହ୍ନେ ବଃଡେ କଃସ୍ଟ୍‌ ହାୟ୍‌ ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ମଃତର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ବାରବାକେ ଚାଡୁକ୍‌ ଆର୍‌ ଜିସୁକେ ଅଃତ୍ୟା କଃରୁକେ ଲକ୍‌ମଃନ୍‌କେ କଃଉଁକେ ବୁଜାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ମଃତର୍‌ ପିଲାତ ଆରେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ହଃଚାର୍ଲା, “ଅଃମି ଇ ଦୁୟ୍‌ ଲକାର୍‌ ବିତ୍ରେ ତୁମାର୍‌ ଗିନେ କାକେ ଚାଡି ଦେଉଁନ୍ଦ୍ ବଃଲି ତୁମିମଃନାର୍‌ ମଃନ୍ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ବାରବାକେ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତଃବେ ଜାକେ କ୍ରିସ୍ଟ ବଃଲି କଃଉତି, ସେ ଜିସୁକେ ମୁଁୟ୍‌ କାୟ୍‌ କଃରିନ୍ଦ୍‌ ?” ସେମଃନ୍ ସଃବୁଲକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ସେତାକ୍‌ ସେ ହଃଚାର୍ଲା, “କାୟ୍‌ତାକ୍‌, ସେ କାୟ୍‌ ଦଃସ୍‌ କଃରିଆଚେ ?” ମଃତର୍‌ ସେମଃନ୍ ବଃଡେ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଇତାକ୍‌ ପିଲାତ ଜଃଡେବଃଳ୍‌ ଦଃକ୍‌ଲା ଜେ, ସେ କାୟ୍‌ କଃରୁକେ ନଃହାରୁଲା, ବଃଲେକ୍‌ ଆରେକ୍‌ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଅଃଉଁଲି । ସଃଡେବଃଳ୍‌ ସେ ହାଣି ନଃୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ମୁଏଁ ଆତ୍‌ ଦୟ୍‌କଃରି କୟ୍‌ଲା, “ଇ ଲକାର୍‌ ଅଃତ୍ୟାୟ୍‌ ମୁଁୟ୍‌ ନିର୍ଦସ୍‌ ! ତୁମିମଃନ୍ ସେରି ବୁଜା ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ଇତାକ୍‌ ସଃବୁଲକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଜିସୁର୍‌ ଅଃତ୍ୟାର୍‌ ଦଃସ୍‌ ଅଃମାର୍‌ ଆର୍‌ ଅଃମାର୍‌ ହିଲାମଃନାର୍‌ ଉହ୍ରେ ହଃଳ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ସେତାକ୍‌ ପିଲାତ ସେମଃନାର୍‌ ଗିନେ ବାରବାକେ ଚାଡି ଦିଲା, ମଃତର୍‌ ଜିସୁକେ ସାଟ୍‍ଣି ସଃଙ୍ଗ୍ ମାରାୟ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଁକ୍‌ ସଃଇନ୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ତାର୍‌ହଃଚେ ପିଲାତର୍‌ ସଃଇନ୍‌ମଃନ୍ ଜିସୁକେ ପିଲାତର୍‌ କୁଆଳ୍‌ ବିତ୍ରେ ନଃୟ୍‌ ସଃବୁ ସଃଇନ୍‌ ଦଃଳ୍‌କେ ଜିସୁର୍‌ ଚଃମେ ରୁଣ୍ଡାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଆରେକ୍‌ ସଃଇନ୍‌ମଃନ୍ ଜିସୁର୍‌ ବଃସ୍ତର୍‌ କାଡି ତାକ୍‌ ଜାମ୍‌କଳି ହର୍‌ ଡିସ୍ତା ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଆର୍‌ ସେମଃନ୍ ଗଟ୍‌ କାଟାର୍‌ ମୁକୁଟ୍‌ ହାଜିକଃରି ଜିସୁର୍‌ ମୁଣ୍ଡେ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ କାତା ଆତେ ଗଟ୍‌ ସୁର୍ଲିଡାଙ୍ଗ୍ ଦଃରାୟ୍‌କଃରି ତାର୍‌ ମୁଏଁ ମାଣ୍ଡିକୁଟା ଟେସ୍‌ଲାୟ୍‌, ଆର୍‌ ଗେଙ୍ଗ୍ରାୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଏ ଜିଉଦିମଃନାର୍‌ ରଃଜା, ଜୁଆର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ଉହ୍ରେ ଲାଳ୍‌ ତୁକ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ଜୁୟ୍‌ ଡାଙ୍ଗ୍ ତାକ୍‌ ଦଃରାୟ୍‌ ରିଲାୟ୍‌, ସେ ଡାଙ୍ଗ୍ ସଃଙ୍ଗ୍ ତାର୍‌ ମୁଣ୍ଡେ ମାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଆରେକ୍‌ ସେମଃନ୍ ଜିସୁକେ ଗେଙ୍ଗ୍ରାୟ୍‌ଲା ହଃଚେ, ସେ ରଃଜାର୍‌ ବଃସ୍ତର୍‌ କାଡି ତାର୍‌ ନିଜାର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଁକ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ସେମଃନ୍ ଜିରୁସାଲମ୍‌ ଗଃଳେହୁଣି ବାରାୟ୍‌ ଜାତାବଃଳ୍‌ କୁରିଣିୟ ଗଃଳାର୍‌ ସିମନ୍‌ ନାଉଁଆର୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଦଃକ୍‌ଲାୟ୍‌, ଆର୍‌ ସଃଇନ୍‌ମଃନ୍ ଜିସୁର୍‌ କ୍ରୁସ୍‌ ବଃଉଁକେ ତାକ୍‌ ବଃଳ୍‌ମତ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଆର୍‌ ସେମଃନ୍ ଗଲ୍‌ଗତା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜଃଗାୟ୍‌, ବଃଲେକ୍‌, ଜାକେ “ମୁଣ୍ଡ୍ କିହ୍ରି ହର୍‌ ଜଃଗା” ବଃଲି କଃଉତି, ସେତି ହଚି, ");
INSERT INTO bdv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ସେତି ସେମଃନ୍ ଜିସୁକେ ହିତା ମିସିରିଲା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କାଉଁକେ ଦିଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ସେରି ଚାକିକଃରି କାଉଁକେ ମଃନ୍ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଜଃଗାୟ୍‌ ତାର୍‌ ବଃସ୍ତର୍‌କେ କେଳିବାଚି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିତ୍ରେ ବାଟା କଃରି ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ଆରେକ୍‌ ସେତି ରଃୟ୍‌ ତାକ୍‌ ଜାଗ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ମୁଣ୍ଡ୍ ଉହ୍ରାର୍‌ କ୍ରୁସ୍‌ କାଟେ ଇ ଦଃସାର୍‌ କଃତା ଲେକି ଲାଗାୟ୍‌ଲାୟ୍‌, “ଏ ଜିଉଦିମଃନାର୍‌ ରଃଜା, ଜିସୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ସଃଡେବଃଳ୍‌ ଜୁଳେକ୍‌ କଃଙ୍ଗାର୍‌ମଃନ୍‌କେ ହେଁ ଜିସୁର୍‌ କାତା ବାଟ ଗଟ୍‌ ଲକ୍‌କେ ଆର୍‌ ଡେବ୍ରି ବାଟ ଗଟ୍‌ ଲକ୍‌କେ ତାର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆର୍‌ ସେ ବାଟ ଜାତିରିଲା ଲକ୍‌ମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମୁଣ୍ଡ୍ ଜଲାୟ୍‌ ଜିସୁର୍‌ ଲିନ୍ଦା କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ରେ ମନ୍ଦିର୍‌ ବାଙ୍ଗୁ ଆର୍‌ ତିନିଦିନ୍ ବିତ୍ରେ ସେତାକ୍‌ ତିଆର୍‌ କଃରୁ, ତୁୟ୍‌ ଜଦି ସଃତ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତଃବେ ନିଜ୍‌କେ ବଚାଉ ଆର୍‌ କ୍ରୁସ୍‌ କାଟେହୁଣି ଉତ୍ରି ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌ ହେଁ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସିକଃରି ସେବାନ୍ୟା କୟ୍‌କଃରି ଜିସୁକେ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ସେ ବିନ୍ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ରଃକ୍ୟାକଃଲା, ମଃତର୍‌ ଅଃବେ ଅଃହ୍‌ଣାକ୍‌ ବଚାଉଁକେ ନଃହାରୁଲା, ସେ ତ ଇସ୍ରାଏଲାର୍‌ ରଃଜା ସେ ଇ ଦାହ୍ରେ କ୍ରୁସ୍‌ ଉହ୍ରେ ହୁଣି ଉତ୍ରି ଆସ, ତଃବେ ଅଃମିମଃନ୍‌ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଆଁ । ");
INSERT INTO bdv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ସେ ନିଜ୍‌କେ ଇସ୍ୱର୍‌ ହୟ୍‌ସି ବଃଲି ଇସ୍ୱର୍‌ ଉହ୍ରେ ଆସ୍ର କଃରିଆଚେ, ତଃବେ ଦଃକୁଆଁ ଇସ୍ୱର୍‌ ତାକ୍‌ ଅଃବେ ରଃକ୍ୟା କଃରୁକେ ମଃନ୍ କଃରୁଲା କି ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଆରେକ୍‌ ଜୁୟ୍‌ କଃଙ୍ଗାର୍‌ମଃନ୍‌କେ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସେ ଚଃଗା ଜାୟ୍‌ ରିଲି, ସେମଃନ୍ ହେଁ ଜିସୁକେ ସେବାନ୍ୟା ଗେଙ୍ଗ୍ରାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ହଃଚେ ବାର ଗଃଟାହୁଣି ତିନି ଗଃଟା ହଃତେକ୍‌ ଦେସ୍‌ଜାକ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ଆର୍‌ ହାକାହାକି ତିନି ଗଃଟାବଃଳ୍‌ ଜିସୁ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, “ଏଲି, ଏଲି, ଲାମା ସାବକ୍‌ତାନି ?” ବଃଲେକ୍‌, “ଏ ମର୍‌ ଇସ୍ୱର୍‌, ଏ ମର୍‌ ଇସ୍ୱର୍‌, ତୁୟ୍‌ ମକ୍‌ କାୟ୍‌ତାକ୍‌ ଚାଡ୍‌ଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଇରି ସୁଣି ସେତି ଟିଆ ଅୟ୍‌ରିଲା କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଇ ଲକ୍‌ ଏଲିୟକେ କୁଦୁଲା !” ");
INSERT INTO bdv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ସେଦାହ୍ରେ ସେମଃନାର୍‌ ବିତ୍ରାର୍‌ ଗଟ୍‌ ଲକ୍‌ ଦଃବ୍‌ଳି ଜାୟ୍‌କଃରି, ଗଟେକ୍‌ ସ୍ପଞ୍ଜ୍ ଆଣି ତାକ୍‌ ହିତା ଅଙ୍ଗୁର୍‌ ରଃସେ ବୁଡାୟ୍‌କଃରି, ସେତାକ୍‌ ଡାଙ୍ଗ୍ ଟିହେ ବାନ୍ଦିକଃରି ଜିସୁକେ କାଉଁକେ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ମଃତର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ରିଆ, ଏଲିୟ ତାକ୍‌ ବଚାଉଁକେ ଆସୁଲା କି ନାୟ୍‌ ଦଃକୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ମଃତର୍‌ ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଆଉଲି ଅୟ୍‌ ଆତ୍ମା ଚାଡ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଆରେକ୍‌ ଦଃକା ମନ୍ଦିର୍‌କେ ଦୁୟ୍‌ ବାଗ୍ କଃର୍ତା ମଃଜାୟ୍‌ ଅଳାୟ୍‌ରିଲା ପର୍ଦା ଉହ୍ରେ ହୁଣି ତଃଳ୍‌ ହଃତେକ୍‌ ଚିରି ଅୟ୍‌ ଦୁୟ୍‌ ହଳା ଅୟ୍‌ଲି, ଆର୍‌ ବୁୟ୍‌ଁ ଲଃଦ୍‌ବଃଦ୍‌ଲି ଆର୍‌ ଡଙ୍ଗ୍ରାର୍‌ ଟେଳାମଃନ୍ ହୁଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆରେକ୍‌ ମଃସୁଣ୍‌ କାଲ୍‌ମଃନ୍ ମେଲା ଅୟ୍‌ଲି, ଆର୍‌ ଗାଦେକ୍‌ ମଃଲା ଇସ୍ୱରାର୍‌ ପବିତ୍ର ଲକ୍‌ମଃନ୍‌ ଉଟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଆରେକ୍‌ ସେମଃନ୍ ମଃରି ଉଟି ମଃସୁଣ୍‌ କାଲେ ହୁଣି ବାରାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ମଃରି ଉଟ୍‌ଲା ହଃଚେ, ସେମଃନ୍ ପବିତ୍ର ଜିରୁସାଲମ୍‌ ଗଃଳେ ଗଃଲାୟ୍‌ ଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ହାଁଚ୍ କଳି ସଃଇନ୍‌ମଃନାର୍‌ ମୁଳିକା ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଜାଗି ରିଲାୟ୍‌, ସେମଃନ୍ ଦଃର୍ତି ଲଃଦ୍‌ବଃଦ୍‌ଲାର୍‌ ଗଃଟ୍‍ଣା ଦଃକି ବଃଡେ ଡିରିକଃରି କୟ୍‌ଲାୟ୍‌, “ସଃତ୍‌କଃରି, ଏ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଆରେକ୍‌ କଃତେକ୍‌ ମାୟ୍‌ଜିମଃନ୍ ସେ ଜଃଗାୟ୍‌ ରଃୟ୍‌ ଦୁରିକ୍‌ହୁଣି ଇ ସଃବୁ ଦଃକ୍‌ତି ରିଲାୟ୍‌; ସେମଃନ୍ ଜିସୁକେ ସେବା କଃରି କଃରି ଗାଲିଲି ତଃୟ୍‌ହୁଣି ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ଆସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ସେମଃନାର୍‌ ବିତ୍ରେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବକ୍‌ ଆର୍‌ ଜସେପାର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ଆର୍‌ ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌ ଆର୍‌ ଜହନାର୍‌ ଆୟ୍‌ସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ବେଳ୍‌ ବୁଡି ଆସ୍ତାବଃଳ୍‌ ଜସେପ୍ ନାଉଁଆର୍‌ ହାରାମାତିଆର୍‌ ଗଟ୍‌ ମାଜନ୍ ଲକ୍‌ ଆୟ୍‌ଲା; ସେ ହେଁ ଜିସୁର୍‌ ଗଟେକ୍‌ ଚେଲା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ସେ ପିଲାତର୍‌ ହାକ୍‌ ଜାୟ୍‌କଃରି ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ମାଗ୍‌ଲା, ତଃବେ ପିଲାତ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ଦେଉଁକେ ଆଦେସ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଜସେପ୍ ଜିସୁର୍‌ ଗଃଗାଳ୍‌କେ ନିଲା ଆର୍‌ ନିର୍ମୁଳ୍‌ ନଃଉଆଁ ହଃଚ୍ୟା ଗୁଳ୍ୟାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ଜସେପ୍ ଅଃହ୍‌ଣାର୍‌ ଗିନେ ଜୁୟ୍‌ ନଃଉଆଁ ମଃସୁଣ୍‌ ଡଙ୍ଗ୍ରେ କଃଣିରିଲା, ସେ ବିତ୍ରେ ଜିସୁର୍‌ ମଃଳ୍‌କେ ସଃଙ୍ଗାୟ୍‌ ମଃସୁଣ୍‌ କାଲାର୍‌ ଦୁଆର୍‌ ବାଟେ ଗଟ୍‌ ବଃଡ୍ ଟେଳା ଡାହିକଃରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆର୍‌ ବିନ୍ ମରିୟମ୍‌ ସେଟାଣେ ମଃସୁଣ୍‌ ଚଃମେ ବଃସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତାର୍‌ ଆର୍‌କ ଦିନ୍, ବଃଲେକ୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ପିଲାତର୍‌ ଚଃମେ ରୁଣ୍ଡିକଃରି କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ଏ ଆଜ୍ଞା, ଅଃମିମଃନ୍‌କ୍‌ ଏତୁ ହଃଳୁଲି, ସେ ମିଚୁଆ ଜିବନ୍‌ ରିଲା ବଃଳ୍‌ କୟ୍‌ରିଲା, ‘ତିନିଦିନାର୍‌ ହଃଚେ ମୁଁୟ୍‌ ଆରେକ୍‌ ଉଟିନ୍ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ସେତାର୍‌ଗିନେ ତିନିଦିନ୍ ହଃତେକ୍‌ ମଃସୁଣ୍‌ ଜାଗୁକେ ଆଦେସ୍‌ ଦେ, ନୟ୍‌ଲେକ୍‌ କେଜାଣ୍ ତାର୍‌ ଚେଲାମଃନ୍ ଆସି ତାର୍‌ ମଃଳ୍‌କେ ଚରିନଃୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ କଃଉତି, ‘ସେ ଜିବନ୍ ହାୟ୍‌କଃରି ଉଟ୍‌ଲା ଆଚେ;’ ସେନ୍‌କାର୍‌ ଅୟ୍‌ଲେକ୍‌ ହଃର୍ତୁର୍‌ ମିଚ୍ ତଃୟ୍‌ହୁଣି ହଃଚାର୍‌ ମିଚ୍ ଅଃଦିକ୍‌ କଃରାବ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଟ୍‌ଦଃଳ୍‌ ଜାଗୁଆଳିମଃନ୍‌କେ ନିଆ ଆର୍‌ ଜଃତେକ୍‌ ହାରୁଲାସ୍‌ ସଃତେକ୍‌ ମଃସୁଣ୍‌କେ ଜାଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ତଃବେ ସେମଃନ୍ ଜାୟ୍‌ ସେ ମଃସ୍‌ଣେ ଡାହ୍‌ଲା ଟେଳାୟ୍‌ ମୁଦ୍ରାମାର୍‌ଲାୟ୍‌, ଆର୍‌ ଜାଗୁଆଳିମଃନ୍‌କେ ଜିସୁର୍‌ ମଃସୁଣ୍‌ ଜାଗ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ବିସାଉଁଣିବାର୍‌ ସଃର୍ଲା ହଃଚେ, ରଃୟ୍‌ବାର୍‌ ବର୍‌ ସଃକାଳ୍ୟା ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆର୍‌ ବିନ୍ ମରିୟମ୍‌ ମଃସୁଣ୍‌ ଦଃକୁକେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଆର୍‌ ସଃଡେବଃଳ୍‌ ଦଃର୍ତି ଲଃଦ୍‌ବଃଦ୍‌ଲି, ଆର୍‌ ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ସଃର୍ଗେହୁଣି ଉତ୍ରି ଆସି ମଃସୁଣ୍‌ ବାଟେ ଡାହିରିଲା ଟେଳା ଗୁଚାୟ୍‌ ତାର୍‌ ଉହ୍ରେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ସେ ଦୁତାର୍‌ ରୁହ୍‌ ବିଜ୍‌ଲି ହର୍‌ ଆର୍‌ ତାର୍‌ ହିନ୍ଦିରିଲା ବଃସ୍ତର୍‌ କଃରାଟେଳା ହର୍‌ ଚିଟ୍‌ ଦବ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଆରେକ୍‌ ଜାଗ୍‌ତା ଲକ୍‌ମଃନ୍ ଦୁତ୍‌କେ ଡିରିକଃରି ତଃର୍‌ତଃରି ମଃଲା ଲକାର୍‌ ହର୍‌ ଅୟଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ମଃତର୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌ ସେ ମାୟ୍‌ଜିମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଡିରା ନାୟ୍‌, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଜେ କ୍ରୁସ୍‌ ଉହ୍ରେ ମଃଲା ଜିସୁକେ ଲଳୁଲାସ୍‌, ମୁଁୟ୍‌ ସେରି ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ସେ ଇତି ନାୟ୍‌, ମଃତର୍‌ ସେ ଜଃନ୍‌କଃରି କୟ୍‌ରିଲା, ତଃନ୍‌କଃରି ସେ ଉଟି ଆଚେ, ଆସା ଜୁୟ୍‌ତି ତାର୍‌ ମଃଲା ଗଃଗାଳ୍‌ ସଃଙ୍ଗା ଜାୟ୍‌ରିଲି, ସେ ଟାଣ୍ ଦଃକା । ");
INSERT INTO bdv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ବେଗି ଜାୟ୍‌ ତୁମିମଃନ୍ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କଃଉଆ, ‘ଜିସୁ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେହୁଣି ଉଟି ଆଚେ, ଆରେକ୍‌ ଦଃକା ସେ ତୁମାର୍‌ ଆଗ୍‌ତୁ ଗାଲିଲି ରାଜିଏ ଜଃଉଁଲା, ସେତି ତାକ୍‌ ତୁମିମଃନ୍ ଦଃକାସ୍‌ !’ ଦଃକା ମୁଁୟ୍‌ ତୁମିକେ ଜାୟ୍‌ରି କୟ୍‌ଲେ, ସେରି ହାସ୍ରା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଇ କଃତା ସୁଣି ସେ ମାୟ୍‌ଜିମଃନ୍ ବେସି ଡିର୍ଲାୟ୍‌, ଆର୍‌ ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ ମଃସୁଣ୍‌ କାଲେ ହୁଣି ଦାପେ ଜାୟ୍‌କଃରି ଜିସୁର୍‌ ଚେଲାମଃନ୍‌କେ କଃବୁର୍‌ ଦେଉଁକେ ଦଃବୁଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଆର୍‌ ଜିସୁ ସେଦାହ୍ରେ ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌କଃରି କୟ୍‌ଲା, “ତୁମାର୍‌ ସୁସ୍ତା ଅଃଉଅ ।” ତଃବେ ସେମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆସି ତାର୍‌ ହାଦ୍‌ ଦଃରି ତାକ୍‌ ଜୁଆର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଡିରା ନାୟ୍‌, ତୁମିମଃନ୍ ଜାହା ଆର୍‌ ମର୍‌ ବାୟ୍‌ମଃନ୍‌କେ କଃଉଆ ସେମଃନ୍ ଗାଲିଲି ଜଃଉଅତ୍‌; ସେମଃନ୍ ମକ୍‌ ସେତି ଦଃକ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ସେ ମାୟ୍‌ଜିମଃନ୍ ଜିସୁର୍‌ ଚେଲାମଃନ୍‌କେ କବୁର୍‌ କଃଉଁକେ ଜାତା ବଃଳ୍‌, ମଃସୁଣ୍‌ ଜାଗ୍‌ତା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ସଃଇନ୍‌ମଃନ୍ ଜିରୁସାଲମ୍‌ ଗଃଳେ ଜାୟ୍‌ ସେ ସଃବୁ ଗଃଟ୍‍ଣାର୍‌ କଃତାମଃନ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌କେ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ଜାଜକ୍‌ମଃନ୍ ପାରାଚିନ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସିକଃରି ଗୁସ୍ଟୁ କଃଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ସଃଇନ୍‌ମଃନ୍‌କେ ବୁତେକ୍‌ ଟଃକା ଦଃୟ୍‌ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ତୁମିମଃନ୍ କଃଉଆ ଅଃମିମଃନ୍‌ ସଃବୁ ନିଦୟ୍‌ ରିଲାବଃଳ୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ରାତି ଆସିକଃରି ଜିସୁର୍‌ ମଃଲା ମଃଳ୍‌କେ ଚରିକଃରି ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଆର୍‌ ଜଦି ଇ କଃତା ଗର୍ନର୍‌ ସୁଣେଦ୍‌, ତଃବେ ଅଃମିମଃନ୍‌ ତାକ୍‌ ବୁଜାୟ୍‌ କଃଉନ୍ଦ୍ ଜେ, ତୁମିମଃନାର୍‌ କାୟ୍‌ ଦଃସ୍‌ ନାୟ୍‌, ତୁମିମଃନ୍ ଚିତା କଃରାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ସେତାକ୍‌ ସଃଇନ୍‌ମଃନ୍ ଟଃକା ନଃୟ୍‌, ସେମଃନ୍‌କେ ଜଃନ୍‌କଃରି କଃଉଆ ଅୟ୍‌ରିଲି ସେନ୍ କଃଲାୟ୍‌ । ଇତାକ୍‌ ଇ କଃତା ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଉର୍ଜିଅୟ୍‌ ଆଜି ହଃତେକ୍‌ ହେଁ ସେ କଃତା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଜିସୁର୍‌ ଏଗାର୍‌ଗଟ୍‌ ଚେଲା ଗାଲିଲି ଜାୟ୍‌, ଜିସୁ ଜୁୟ୍‌ ଡଙ୍ଗ୍ରେ ଜଃଉଁକେ କୟ୍‌ରିଲା, ସେ ଡଙ୍ଗ୍ରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଆର୍‌ ସେମଃନ୍ ସେତି ଜିସୁକେ ଦଃକି ଜୁଆର୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ କେ କେ ସଃତ୍‌ ନଃକେଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଆରେକ୍‌ ଜିସୁ ସେମଃନାର୍‌ ଚଃମେ ଆସି କଃତା ଅୟ୍‌ କୟ୍‌ଲା, “ସଃର୍ଗ୍‌ ଆର୍‌ ହୁର୍ତିବିର୍‌ ସଃବୁ ଅଃଦିକାର୍‌ ମକେ ଦିଆ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ତଃବେ ତୁମିମଃନ୍ ଜାୟ୍‌ ସଃବୁ ବାସାର୍‌ ରିଲା ଲକ୍‌ମଃନ୍‌କେ ଉବା, ହଅ ଆର୍‌ ପବିତ୍ର ଆତ୍ମାର୍‌ ନାଉଁଏ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌, ସେମଃନ୍‌କେ ଚେଲା କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜୁୟ୍‌ ଜୁୟ୍‌ ଆଡର୍‌ ଦଃୟ୍‌ ଆଚି ସେରି ସଃବୁ ମାନୁକ୍‌ ସିକାଉଆ, ଆରେକ୍‌ ମଃନେ ରଃକା ଜୁଗ୍ ସେସ୍‌ ଅଃଉତା ହଃତେକ୍‌ ସଃବୁବଃଳ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନାର୍‌ ସଃଙ୍ଗେ ସଃଙ୍ଗେ ଆଚି ।”");
INSERT INTO bdv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଇରି ଅଃଉଁଲି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ଜିସୁ କ୍ରିସ୍ଟର୍‌ ନିକ କବୁର୍‌ ଆରୁମ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଜଃନ୍‌କଃରି ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତରେ ଲେକାଆଚେ, “ଇସ୍ୱର୍‌ ମାପ୍ରୁ କୟ୍‌ଲା, ‘ସୁଣା ମୁୟ୍‌ ମର୍‌ କବୁର୍‌ କାରିଆକ୍‌ ତର୍‌ ଆଗ୍‌ତୁ ହଃଟାଉଁନ୍ଦ୍, ସେ ତର୍‌ ଗିନେ ବାଟ ତିଆର୍‌ କଃରେଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ଗଟ୍‌ ମାନାୟ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ହୁଣି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉଁଲା, ‘ମାପ୍ରୁର୍‌ ଗିନେ ବାଟ୍‌ ତିଆର୍‌ କଃରା; ଆର୍‌ ରଃଜାର୍‌ ଗିନେ ବାଟ୍‌ ସଃଳ୍‌କ୍‌ କଃରା ।’” ");
INSERT INTO bdv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଆୟ୍‌ଲା ଆର୍‌ ପର୍ଚାର୍‌ କଃରି କୟ୍‌ଲା, “ହାହେ ହୁଣି ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆସା ଆର୍‌ ବାପ୍ତିସମ୍‌ ନିଆ, ଇସ୍ୱର୍‌ ତୁମାର୍‌ ହାହ୍‌ କେମା କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଜିଉଦା ରାଜିର୍‌ ଆର୍‌ ଜିରୁସାଲମ୍‌ ଗଃଳାର୍‌ ଆରେକ୍‌ ଜର୍ଦନ୍‌ ଗାଡ୍ ଚଃମେ ରିଲା ସଃବୁ ଲକ୍‌ମଃନ୍ ଜହନ୍‌ ଲଃଗେ ଆସୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍‌ ନିଜେ ନିଜେ କଃରିରିଲା ହାହ୍‌ ଆର୍‌ ଦସ୍‌ ସଃବୁ ମାନ୍‌ଲାୟ୍‌, ଆର୍‌ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ଜର୍ଦନ୍ ଗାଡେ ବାପ୍ତିସମ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଜହନ୍‌ ଉଟ୍‌ ରମେ ବୁଣ୍‌ଲା ବଃସ୍ତର୍‌ ହିନ୍ଦ୍‌ତି ରିଲା ଆର୍‌ ଚାମାର୍‌ ଅଃଟାବାନ୍ଦୁଣ୍‌ ବାନ୍ଦ୍‌ତି ରିଲା, ସେ ଜିଟ୍‌କା ଆର୍‌ ବଃନାର୍‌ ମଃଉଁ କାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ସେ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା, “ମର୍‌ ହଃଚେ ଜେ ଆସୁଲା ସେ ମର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବଃଡ୍‌, ମୁଁୟ୍‌ ତାର୍‌ ହାଦାର୍‌ ହାଣ୍ଡାୟ୍‌ର୍‌ ବାନ୍ଦୁଣ୍ ଇଟାଉତା ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦିଲେ, ମଃତର୍‌ ସେ ତୁମିମଃନ୍‌କେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ସଃଡେବଃଳ୍‌ ଜିସୁ ଗାଲିଲି ରାଜିର୍‌ ନାଜରିତ୍‌ ଗାଉଁଏ ହୁଣି ଆୟ୍‌ଲା ଆର୍‌, ଜର୍ଦନ୍ ଗାଡେ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଜିସୁ ବାପ୍ତିସମ୍‌ ନଃୟ୍‌ ହାଣାୟ୍‌ ହୁଣି ବାରାୟ୍‌ଲା, ଆର୍‌ ସଃର୍ଗ୍‌ ଉଗାଳି ଅୟ୍‌ଲି ଆର୍‌ ପବିତ୍ର ଆତ୍ମା ହାଣ୍ଡ୍‌କା ହର୍‌ ଅୟ୍‌ ତାର୍‌ ଉହ୍ରେ ଉତ୍ରି ଆସ୍ତାର୍‌ ସେ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଆର୍‌ ସଃଡେବଃଳ୍‌ ସଃର୍ଗେ ହୁଣି ଗଟେକ୍‌ କଃତା ସୁଣା ଅୟ୍‌ଲି, “ତୁୟ୍‌ ଅଃମାର୍‌ ଲାଡାର୍‌ ହଅ, ତର୍‌ ତଃୟ୍‌ ଅଃମାର୍‌ ବଃଡେ ସଃନ୍‌ମତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ତଃତ୍‌କାଣ୍ ପବିତ୍ର ଆତ୍ମା ଜିସୁକେ ଗଟେକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ନିଲି, ");
INSERT INTO bdv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଜିସୁ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଚାଲିସ୍‌ ଦିନ୍‌ ହଃତେକ୍‌ ରିଲା, ଆର୍‌ ସେତି ଜିସୁକେ ସୟ୍‌ତାନ୍‌ ପରିକ୍ୟା କଃଲି । ସେ ବଃନାର୍‌ ଜଃତୁମଃନାର୍‌ ସଃଙ୍ଗ୍ ରେତିରିଲା ଆର୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌ମଃନ୍ ତାର୍‌ ସେବା କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଜହନ୍‌କେ ବାନ୍ଦି ଜଃଇଲେ ହୁରାୟ୍‌ଲା ହଃଚେ, ଜିସୁ ଗାଲିଲିକେ ଆୟ୍‌ଲା ଆର୍‌ ଇସ୍ୱରାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ଜିସୁ ପର୍ଚାର୍‌ କଃରି କଃଉଁକେ ଦଃର୍ଲା, “ଟିକ୍‌ ବେଳା ଆୟ୍‌ଲି ଆଚେ, ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଲଃଗେ ଅୟ୍‌ଲିନି ! ତୁମାର୍‌ ହାହ୍‌ ଚାଡା ଆର୍‌ ନିକ କବୁର୍‌କେ ବିସ୍ୱାସ୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡିବାଟ୍‌ ଜାତିରିଲା ବଃଳ୍‌, ସେ ସିମନ୍ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅକ୍‌ ମାଚ୍ ଦଃରୁକେ ସଃମ୍‌ନ୍ଦେ ବୟ୍‌ଜାଲ୍‌ ହଃକାଉତି ରିଲାର୍‌ ଦଃକ୍‌ଲା । ବଃଲେକ୍‌ ସେମଃନ୍ ମାଚୁଆ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ଆସା, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନଃର୍‌ମଃନ୍‌କେ ମାପ୍ରୁର୍‌ ଲଃଗେ ଆଣୁକେ ସିକାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ସେଦାହ୍ରେ ସେମଃନ୍ ତାକାର୍‌ ଜାଲ୍‌ ଚାଡ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଜିସୁ କଃଣ୍ଡେକ୍‌ ଦୁରିକ୍‌ ଗଃଲା ହଃଚେ, ସେ ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଜହନ୍‌କେ ଦଃକ୍‌ଲା । ସେମଃନ୍ ଡଙ୍ଗାୟ୍‌ ଜାଲ୍‌ ହଃଜାଳ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ସେଦାହ୍ରେ ଜିସୁ ସେମଃନ୍‌କେ କୁଦ୍‌ଲା, ଆର୍‌ ସେମଃନ୍ ତାକାର୍‌ ଉବାସି ଜେବଦିକ୍‌ ବୁତ୍ୟାର୍‌ ଲକାର୍‌ ସଃଙ୍ଗ୍ ଡଙ୍ଗାୟ୍‌ ଚାଡ୍‌ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ଚେଲାମଃନ୍ କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଗଃଳାୟ୍‌, ଆର୍‌ ଜିସୁ ଜିଉଦିମଃନାର୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ତାକାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ହୁର୍ଲା ଆର୍‌ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଜିସୁର୍‌ ସିକ୍ୟା ସୁଣିକଃରି ସେତିର୍‌ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ଦଃର୍ମ୍‌ ଗୁରୁମଃନାର୍‌ ହର୍‌ ସିକ୍ୟା ନଃଦେୟ୍‌ କଃରି ଅଃଦିକାର୍‌ ହାୟ୍‌ଲା ଲକାର୍‌ ହର୍‌ ସିକ୍ୟା ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ସଃଡେବଃଳ୍‌ ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ବିଟାଳ୍‌ ଆତ୍ମା ଡସି ରିଲା ଲକ୍‌ ରିଲା, ସେ ଆଉଲି ଅୟ୍‌କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ ନାଜରିତ୍‌ ବଃସ୍ତିର୍‌ ଜିସୁ ତୁୟ୍‌ ଅଃମାର୍‌ ତଃୟ୍‌ ହୁଣି କାୟ୍‌ରି ମଃନ୍‌କଃରୁଲିସ୍‌ ? ତୁୟ୍‌ କାୟ୍‌ ଅଃମିକ୍‌ ନାସ୍‌ କଃରୁକେ ଆସି ଆଚ୍‌ସି ? ତୁୟ୍‌ କେ ମୁଁୟ୍‌ ଜାଣି ଆଚି, ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ପବିତ୍ର ମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ତାକ୍‌ ଦଃକା ଦଃୟ୍‌କଃରି କୟ୍‌ଲା, “ତୁନ୍‌ହାଳ୍‌, ଆର୍‌ ଇମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଜାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ତାର୍‌ହଃଚେ ସେ ବୁତ୍‌ ସେମାନାୟ୍‌କେ ମଳିକଃରି ତଃଳେ ଅଦ୍ରାୟ୍‌ଲି ଆର୍‌ ଆଉଲି ଅୟ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ବିଟାଳ୍‌ ଆତ୍ମା ବାରାୟ୍‌ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଇରି ଦଃକିକଃରି ସେତିର୍‌ ଲକ୍‌ମଃନ୍ ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇରି କାୟ୍‌ରି ? ଇରି ତ ଅଃଦିକାର୍‌ ହାୟ୍‌ଲା ନଃଉଆଁ ସିକ୍ୟା ଦେଉଁଲା ଆର୍‌ ସେ ବୁତ୍‌ମଃନ୍‌କେ ହେଁ ଆଦେସ୍‌ ଦେଉଁଲା, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ବଲ୍‌ ମାନୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ତାର୍‌ହଃଚେ ଜିସୁର୍‌ କଃତା ଗାଲିଲି ରାଜିର୍‌ ଚାରିହାକ୍‌ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ହୁଣି ବାରାୟ୍‌ ଜାକୁବକ୍‌ ଆର୍‌ ଜହନ୍‌ ସଃଙ୍ଗ୍ ମିସି ସଃଳ୍‌କେ ସିମନ୍ ଆର୍‌ ଆନ୍ଦ୍ରିଅର୍‌ ଗଃରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ସେ ଗଃରେ ସିମନାର୍‌ ସଃତୁର୍ସି ଜଃରାର୍‌ ଗିନେ ଟାଟାୟ୍‌ ଡୁଳି ରିଲି, ସେତାର୍‌ଗିନେ ଚେଲାମଃନ୍ ସିମନାର୍‌ ସଃତୁର୍ସି ଜଃରୁଲି ବଃଲି ଜିସୁକେ ସେଦାହ୍ରେ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଜିସୁ ତାର୍‌ ଲଃଗେ ଗଃଲା ଆର୍‌ ତାର୍‌ ଆତେ ଦଃରି ତାକ୍‌ ଉଟାୟ୍‌ଲା, ସେଦାହ୍ରେ ତାର୍‌ ଜଃର୍‌ ଚାଡ୍‌ଲି ଆର୍‌ ସେ ସେମଃନ୍‌କେ କାଉଁକେ ହିଉଁକ୍‌ ଦଃୟ୍‌କଃରି, ତାକାର୍‌ ସେବା କଃରୁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ବେଳ୍‌ ବୁଡି ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌, ଲକ୍‌ମଃନ୍ ଜଃର୍‌ଦୁକାର୍‌ ଆର୍‌ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ଜିସୁର୍‌ ଲଃଗେ ଆଣୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ସେ ଗଃଳାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ଜିସୁ ରିଲା ଗଃରାର୍‌ ଦୁଆର୍‌ ଚଃମେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ସଃଡେବଃଳ୍‌ ଜିସୁ ବିନ୍‌ବିନ୍‌ ଜଃର୍‌ ଦୁକାୟ୍‌ ହଃଳିରିଲା ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ଜିସୁ ବୁତ୍‌ ଡଃସିରିଲା ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ହେଁ ଉଜ୍‌ କଃଲା, ଜିସୁ କେ ବଃଲି ଦୁତ୍‌ମଃନ୍ ଚିନ୍‌ତି ରିଲାୟ୍‌ ସେତାର୍‌ଗିନେ ଜିସୁ ସେ ବୁତ୍‌ମଃନ୍‌କେ କାୟ୍‌ରି ହେଁ କଃଉଁକେ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ତାର୍‌ ଆର୍‌କ ଦିନାର୍‌ ଉଟ୍‌ଲା ସଃକାଳ୍‌ ଜିସୁ ଅଃନ୍ଦାର୍‌ ଅଃନ୍ଦାର୍‌ ଉଟି, ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ଗଃଲା ଆର୍‌ ସେତି ପାର୍ତ୍‌ନା କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ସଃଡେବଃଳ୍‌ ସିମନ୍ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍ ତାକ୍‌ ଲଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ଜିସୁକେ ବେଟ୍‌ ହାୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସଃବୁ ଲକ୍‌ମଃନ୍ ତକେ ଲଳୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃମିମଃନ୍‌ ଇ ଚଃମାର୍‌ ବିନ୍‌ବିନ୍‌ ଗାଉଁଏମଃନ୍‌ ଜୁଆଁ, ଜଃନ୍‌କଃରି ସେ ଗାଉଁଏ ହେଁ ମୁଁୟ୍‌ ସିକ୍ୟା ଦେଉଁ ହାରି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ଇତାର୍‌ ଗିନେ ଆସି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ତାର୍‌ହଃଚେ ସେ ଗାଲିଲି ଗଃଳାର୍‌ ସଃବୁହାକ୍‌ ବୁଲ୍‌ଲା ଆର୍‌ ପାର୍ତ୍‌ନା ଗଃରେମଃନ୍ ସିକ୍ୟା ଦିଲା ଆର୍‌ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ଗଟେକ୍‌ ବଃଡ୍‌ ରଗି ଆୟ୍‌ଲା, ଆର୍‌ ଜିସୁର୍‌ ମୁଏଁ ମାଣ୍ଡିକୁଟା ଟେସି ହାଦେଡୁଳି ଗଃଉଆରି କଃରି କୟ୍‌ଲା, “ତୁୟ୍‌ ମଃନ୍ କଃଲେକ୍‌ ମକ୍‌ ଉଜ୍‌ କଃରୁ ହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଜିସୁ ତାର୍‌ ଉହ୍ରେ ଦଃୟା ଦଃକାୟ୍‌ଲା ଆର୍‌ ଆତ୍‌ ଲାମାୟ୍‌ ତାକ୍‌ ଚୁୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ମଃନ୍‌ କଃରୁଲେ ତୁୟ୍‌ ଉଜ୍‌ ଅଃଉ !” ");
INSERT INTO bdv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ଆର୍‌ ସେଦାହ୍ରେ ସେମାନାୟ୍‌ର୍‌ ବଃଡ୍‌ ରଗ୍ ଚାଡ୍‌ଲି, ଆର୍‌ ସେ ଉଜ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଜିସୁ ସେମାନାୟ୍‌କେ ଜଃଉଁକେ କୟ୍‌ଲା, ମଃତର୍‌ ତାକ୍‌ ଜଃଗ୍ରାତ୍‌ କଃରାୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ମୁଁୟ୍‌ ତର୍‌ ଗିନେ ଜାୟ୍‌ରି କଃଲେ, ସେ କଃତା କାକେ ହେଁ କଃଉନାୟ୍‌, ମଃତର୍‌ ଜାଆ ଆର୍‌ ଜାଜକ୍‌କେ ଦଃକାଉ, ଆର୍‌ ତକେ ନିର୍ମୁଳ୍‌ କଃରା ଅୟ୍‌ଆଚେ ବଃଲି ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ସାକି ଦେଉଁକେ, ମସାର୍‌ ବିଦି ହଃର୍କାରେ ଦାନ୍‌ ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ମଃତର୍‌ ସେମାନାୟ୍‌ ବାରାୟ୍‌ ଗଃଲା ଆର୍‌ ସେକଃତା ସଃବୁ ହାକ୍‌ କଃଉଁକେ ଦଃର୍ଲା, ସେ ଇବାନ୍ୟା ପର୍ଚାର୍‌ କଃଲା ଜେ, ଜିସୁ କୁୟ୍‌ ଗଃଳେ ହେଁ ଦଃକ୍‌ଣେ ଜଃଉଁକେ ନଃହାର୍‌ଲା; ମଃତର୍‌ ସେ ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣେ ରେଉଁକ୍‌ ଦଃର୍ଲା, ମଃତର୍‌ ଚାରିହାକାର୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଟାଣେ ଆସୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","କଃତି ଦିନାର୍‌ ହଃଚେ ଜିସୁ କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ସେ ଜୁୟ୍‌ ଗଃଳେ ରେତି ରିଲା ସେ ଗଃରେ ବାଉଳି ଆୟ୍‌ଲା, ଆର୍‌ ଜିସୁ ଗଃରେ ଆଚେ ବଃଲି କବୁର୍‌ ଚାରିହାକ୍‌ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ସେତି ଗାଦି ଲକ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌, ବାଟ ଦୁଆର୍‌ ମୁଣ୍ଡାୟ୍‌ ହେଁ ଟାଣ୍ ନଃରିଲି, ଜିସୁ ସେମଃନ୍‌କେ ଇସ୍ୱରାର୍‌ କଃତା କଃଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ସଃଡେବଃଳ୍‌ ଗଟ୍‌ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକେ ଚାରିଲକ୍‌ ବୟ୍‌କଃରି ଜିସୁର୍‌ ଲଃଗେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ଟେଲାକୁର୍ଚା ଲକ୍‌ ମଃନ୍ଦାର୍‌ ଗିନେ ଜିସୁର୍‌ ଚଃମେ ଆଣୁ ନଃହାର୍‌ଲାକ୍‌ ଜିସୁ ଜୁୟ୍‌ତି ଟିଅୟ୍‌ ରିଲା, ସେ ସଃଳ୍‌କେ ଚାନି କାଣାକଃରି ରଗି ମାନାୟ୍‌ ସୟ୍‌ରିଲା ଟାଟି ତଃୟ୍‌ ଉତ୍ରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜିସୁ ସେ ଲକ୍‌ମଃନାର୍‌ ବିସ୍ୱାସ୍‌ ଦଃକି ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ କୟ୍‌ଲା, “ଏ ହିଲା ତର୍‌ ହାହ୍‌ ସଃବୁ କେମା କଃରା ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","କଃତେକ୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ମଃନ୍‌ ବଃସିକଃରି ସେମଃନାର୍‌ ବିତ୍ରେ ମଃନେ ବାବ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଇମାନାୟ୍‌ କାୟ୍‌ତାକ୍‌ ଇବାନ୍ୟା କଃଉଁଲା ? ସେ ଇସ୍ୱରାର୍‌ ଲିନ୍ଦା କଃରୁଲା ! ମାପ୍ରୁକ୍‌ ଚାଡି କେହେଁ ହାହ୍‌ କେମା କଃରୁ ନଃହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଜିସୁ ସେମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରାର୍‌ ବାବ୍‌ନା ଆତ୍ମା ତଃୟ୍‌ ଜାଣୁ ହାରି, ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମି କାୟ୍‌ତାକ୍‌ ଇରଃକମ୍‌ ମଃନେ ବାବୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","କାୟ୍‌ରି ଉହାସ୍‌ ? ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌, ‘ତର୍‌ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଲି,’ ବଃଲି କଃଉତାର୍‌, କି, ‘ଉଟ୍‌, ତର୍‌ ସୟ୍‌ରିଲା କଃଟ୍‌ ଦଃରିକଃରି ଜାଆ,’ ବଃଲି କଃଉତାର୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ମଃତର୍‌ ହୁର୍ତିବି ଉହ୍ରେ ହାହ୍‌ କେମା କଃର୍ତା ଅଃଦିକାର୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଜେ ମୁଁୟ୍‌, ମର୍‌ ଅଃଦିକାର୍‌ ଆଚେ, ଇରି ଜଃନ୍‌କଃରି ତୁମି ଜାଣୁ ହାରାସ୍‌ ।” ଇତାକ୍‌ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ ଜିସୁ ଇ କଃତା କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ, ଉଟ୍‌ ତର୍‌ କଃଟ୍‌ ବୟ୍‌ ଗଃରେ ଜାଆ !” ");
INSERT INTO bdv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ଜିସୁ କୟ୍‌ଲା ଦାହ୍ରେ କଃଟ୍‌ ବୟ୍‌ ସଃବୁ ଲକାର୍‌ ମୁୟେ ସେମାନାୟ୍‌ ବାରାୟ୍‌ ଗଃଲା । ଇରି ସବୁ ଲକ୍‌ମଃନ୍ ଦଃକି କାବା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ ଗାୟ୍‌ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମି କଃବେହେଁ ଅଃନ୍‌କାର୍‌ ଦଃକି ନଃରିଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଜିସୁ ଆରେକ୍‌ ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ କଣ୍ଡି ବାଟ ବାରାୟ୍‌ ଗଃଲା, ଆର୍‌ ଅଲେକାର୍‌ ଲକ୍‌ ତାର୍‌ ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଜିସୁ ଜଃଉଁ ଜଃଉଁ ଆଲ୍‌ପିଅର୍‌ ହଇସି ଲେବିକେ ତାର୍‌ ରିବ୍‌ନି ବଃଙ୍ଗ୍‌ଲାୟ୍‌ ବଃସିରିଲାର୍‌ ଦଃକ୍‌ଲା । ଆର୍‌ ତାକେ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ଆଉ ।” ସେ ଜିସୁର୍‌ କଃତା ସୁଣ୍‌ଲା ଦାହ୍ରେ ଉଟି ତାର୍‌ ହଃଚେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ହଃଚେ ଜିସୁ ଲେବି ବଃଉଁସାର୍‌ ଗଃରେ କାଉଁକେ ବଃସ୍‌ଲା ବଃଳ୍‌ ଗାଦେକ୍‌ ରିବ୍‌ନି, ହାହି ଆର୍‌ ଚେଲାମଃନ୍ ହେଁ ସଃଙ୍ଗେ ବଃସ୍‌ଲାୟ୍‌ । ସେମଃନ୍ ଗାଦା ଲକ୍‌ ରିଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗେ ବୁଲ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଜିସୁ ହାହି ଆର୍‌ ରିବ୍‌ନି ମଃନାର୍‌ ସଃଙ୍ଗେ ବଃସି କାତାର୍‌ ଦଃକି ପାରୁସି ଦଃଳାର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଜିସୁ ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗେ କାୟ୍‌ତାକ୍‌ କାଉଁଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଜିସୁ ସେମଃନାର୍‌ କଃଉତାର୍‌ ସୁଣି କୟ୍‌ଲା, “ଜୁୟ୍‌ ମାନାୟ୍‌ ଉଜ୍‌ ଅୟ୍‌ଆଚେ ତାର୍‌ ଗିନେ ବୟ୍‌ଦ୍‌କାରି ଲଳା ନାୟ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ମଃଳୁ ହଃଳି ଆଚେ ତାର୍‌ ଗିନେ ଲଳା । ମୁୟ୍‌ଁ ଦଃର୍ମି ଲକ୍‌ମଃନ୍‌କେ କୁଦୁକ୍‌ ନାସି, ମଃତର୍‌ ହାହିମଃନାର୍‌ ଗିନେ ଆସି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଜହନାର୍‌ ଚେଲାମଃନ୍ ଆର୍‌ ପାରୁସିମଃନ୍ ଉହାସ୍‌ କଃର୍ତି ରିଲାୟ୍‌, ସେତାର୍‌ ଗିନେ କଃତେକ୍‌ ଲକମଃନ୍ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଜହନାର୍‌ ଚେଲାମଃନ୍ ଆର୍‌ ପାରୁସିମଃନ୍ ଉହାସ୍‌ କଃରୁଲାୟ୍‌, ମଃତର୍‌ ତର୍‌ ଚେଲାମଃନ୍ କାୟ୍‌ତାକ୍‌ ଉହାସ୍‌ ନଃକେରୁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବଃରଗଚ୍ୟାମଃନ୍ ବଃରସଃଙ୍ଗ୍ ବିବା ଗଃରେ ରେତା ବଃଳ୍‌ ସେମଃନ୍ କାୟ୍‌ତାକ୍‌ ଉହାସ୍‌ କଃର୍ତି ? ବଃର ଜଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗେ ରଃୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ସେମଃନ୍ ଉହାସ୍‌ କଃରୁକେ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମଃତର୍‌ ବେଳା ଆସେଦ୍‌, ଜଃଡେବଃଳ୍‌ ବଃର ଦଃଙ୍ଗ୍‌ଳାକେ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କାଡି ନିଆ ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଉହାସ୍‌ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“କେହେଁ ନଃଉଆଁ ହଃଚ୍ୟାର୍‌ ହାଟ୍‌ଳି କଃଣ୍ଡେକ୍‌ ଚିରି ହଃର୍ନା ହଃଚ୍ୟାୟ୍‌ ମିସାୟ୍‌ ନଃତୁନ୍ତି, ତୁନ୍‌ଲେକ୍‌ ନଃଉଁଆରି ହଃର୍ନା ତାକ୍‌ ଅଃଦିକ୍‌ ଚିରେଦ୍‌, ଆର୍‌ ଅଃଦିକ୍‌ ହାଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ସେବାନ୍ୟା କେହେଁ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହଃର୍ନା ଚାମ୍‌ ମଣାୟ୍‌ ନଃସେଙ୍ଗାଉତି, ସଃଙ୍ଗାୟ୍‌ଲେକ୍‌ ସେରି ମଣାକେ ହାଟାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଆର୍‌ ଚାମ୍‌ମଣା ମିସ୍‌ଣେ ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌ । ମଃତର୍‌ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ନଃଉଆଁ ଚାମ୍‌ମଣାୟ୍‌ ସଃଙ୍ଗାୟ୍‌ବାର୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ତାସ୍‌ ହଃଦା ବାଟ୍‌ଅୟ୍‌ ଜାତିରିଲାୟ୍‌ । ଜଃଉଁ ଜଃଉଁ ତାର୍‌ ଚେଲାମଃନ୍ ତାସ୍‌ କେଡ୍ ଚିଡାଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ସେତାର୍‌ ଗିନେ ପାରୁସିମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଦଃକ୍‌ ତର୍‌ ଚେଲାମଃନ୍ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜୁୟ୍‌ରି କଃର୍ତା ବିଦି ନାୟ୍‌ କାୟ୍‌ତାକ୍‌ ସେରିମଃନ୍ କଃରୁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାଦି ଲଳାରିଲା ବଃଳ୍‌ ଦାଉଦ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍ ବୁକେ ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଦାଉଦ୍‌ କାୟ୍‌ କଃରିରିଲା, ସେରି କାୟ୍‌ ତୁମିମଃନ୍ କଃବେହେଁ ନଃହଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିଆତର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ବଃଳ୍‌ ଦାଉଦ୍‌ କଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଗଃରେ ହୁରି, ଜୁୟ୍‌ ମାପ୍ରୁର୍‌ ରୁଟି ଜାଜକ୍‌ମଃନ୍‌କେ ଚାଡି କେହେଁ କାତା ବିଦି ନାୟ୍‌, ମଃତର୍‌ ଦାଉଦ୍‌ ସେରି କାୟ୍‌ଲା ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌କେ ଦଃୟ୍‌ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବିସାଉଁଣିବାର୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ଗିନେ ଅୟ୍‌ଆଚେ, ମଃତର୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ଗିନେ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ସେତାର୍‌ ଗିନେ ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ବିସାଉଁଣିବାର୍‌ ମାପ୍ରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଗଃଲା । ସେତି ଗଟେକ୍‌ ମାନାୟ୍‌ ରିଲା, ତାର୍‌ ଆତ୍‌ ସୁକି ଜାୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଆର୍‌ ସେ କେଜାଣ୍ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଉଜ୍‌ କଃରେଦ୍‌ କି ନାୟ୍‌ ବଃଲି କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଦଃକ୍‌ତି ରିଲାୟ୍‌; ଜଃନ୍‌କଃରି ସେ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ଦଃସ୍‌ ଦଃରୁ ହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଜିସୁ ଆତ୍‌ ସୁକି ରିଲା ମାନାୟ୍‌କେ କୟ୍‌ଲା, “ଆଉ ମଃଜାୟ୍‌ ଟିଆ ଅଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ବିସାଉଁଣିବାର୍‌ ଦିନ୍ କାୟ୍‌ କଃର୍ତା ବିଦି ? ବଃଲ୍‌ କାମ୍‌ କଃର୍ତାର୍‌ କି କଃରାବ୍‌ କଃର୍ତାର୍‌ ? ଗଟ୍‌ ଲକାର୍‌ ଜିବନ୍ ବଚାଉତାର୍‌, କି ଗଟ୍‌ ଲକାର୍‌ ଜିବନ୍ ନଃସ୍ଟ୍‌ କଃର୍ତାର୍‌ ?” ମଃତର୍‌ ସେ ଲକ୍‌ମଃନ୍ ତୁନ୍‌ହଃଳି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଜିସୁ ସେମାନାୟ୍‌ର୍‌ ଅଃଟୁଆ ମଃନ୍ ଦଃକି ମଃନ୍‌ ଦୁକ୍‌ କଃରି ଚାରିହାକ୍‌ ଦଃକ୍‌ଲା, ଆର୍‌ ସେମାନାୟ୍‌କେ କୟ୍‌ଲା, “ତର୍‌ ଆତ୍‌ ଲାମାଉ ।” ସେ ଲକ୍‌ ଜିସୁର୍‌ ହାକ୍‌ ତାର୍‌ ଆତ୍‌ ଲାମାୟ୍‌ଲା ଆର୍‌ ସେଦାହ୍ରେ ତାର୍‌ ଆତ୍‌ ନିକ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ତାର୍‌ହଃଚେ ପାରୁସିମଃନ୍ ସେତିହୁଣି ବାରାୟ୍‌ ଗଃଲାୟ୍‌, ଆର୍‌ ସେଦାହ୍ରେ ସେମଃନ୍ ହେରଦିୟ ଦଃଳାର୍‌ କଃତିଲକାର୍‌ ସଃଙ୍ଗ୍ ମିସ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ ମଃର୍ନେ ମାରୁଆଁ ବଃଲି କୁଟ୍‌ ହାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜିସୁ ତାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସି ଗାଲିଲି ସଃମ୍‌ନ୍ଦେ ଗଃଲା । ଆର୍‌ ଗାଲିଲି ରାଜିର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ତାକାର୍‌ ହଃଚେ ଗଃଳାୟ୍‌, ଆର୍‌ ଜିଉଦାର୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଜିରୁସାଲମ୍‌, ଇଦମ୍‌ ଆର୍‌ ଜର୍ଦନ୍ ଗାଡାର୍‌ ସେହାଟିର୍‌ ସର୍‌ ଆର୍‌ ସିଦନାର୍‌ ଚାରିହାକାର୍‌ ଅଲେକାର୍‌ ଲକ୍‌ ତାର୍‌ ସଃବୁ କାମ୍‌ କଃଲାର୍‌ ସୁଣି ତାର୍‌ ଟାଣେ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ସଃଡେବଃଳ୍‌ ଅଲେକାର୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଉହ୍ରେ ଜଃନ୍‌କଃରି ମାଡାଚଃଗା ନଃକେର୍ତି, ସେତାର୍‌ଗିନେ ଗଟେକ୍‌ ସାନ୍ ଡଙ୍ଗା ଲଳୁକ୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ଗାଦି ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃରିରିଲା, ସେତାକ୍‌ ସେତି ରିଲା ରଗ୍‌ଦୁକା ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଚିଉନ୍ଦ୍ ବଃଲି ମାଡାଚଃଗା ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଆର୍‌ ସେତି ରିଲା କଃତି ଲକ୍‌କେ ବିଟାଳ୍‌ବୁତ୍‌ ଡଃସିରିଲି, ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେ ବିଟାଳ୍‌ବୁତ୍‌ ଡଃସିରିଲା ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃକ୍‌ତି ରିଲାୟ୍‌, ସେମଃନ୍ ଜିସୁର୍‌ ମୁଏଁ ତଃଳେ ଡୁଳି ଆଉଲି ଅୟ୍‌କଃରି କଃଉତି ରିଲାୟ୍‌, “ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ସେତାକ୍‌ ଜିସୁ ତାର୍‌ କଃତା କାକେ ହେଁ ନଃକଃଉଁକ୍‌ ବିଟାଳ୍‌ ବୁତ୍‌ମଃନ୍‌କେ ଅଃଟୁଆ କଃରି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ତାର୍‌ହଃଚେ ଜିସୁ ଗଟେକ୍‌ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଗଃଲା, ଆର୍‌ ସେ ଜାକେ ମଃନ୍‌କଃଲା ତାକ୍‌ ତାର୍‌ ଚଃମେ କୁଦ୍‌ଲା, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଜିସୁ ସେମଃନାର୍‌ ବିତ୍ରେ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ବାଚ୍‌ଲା, ଆର୍‌ ସେମଃନ୍‌କେ ପେରିତ ବଃଲି ନାଉଁ ଦିଲା, ଆର୍‌ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ମର୍‌ ସଃଙ୍ଗ୍ ରିଆସ୍‌ ଆର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ହଃଟାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ବୁତ୍‌ ଚାଡାଉଁକେ ଅଃଦିକାର୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ତାର୍‌ହଃଚେ ଜିସୁ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ବାଚ୍‌ଲା, ସିମନାର୍‌ ନାଉଁ ପିତର୍‌ ବଃଲି ଦିଲା, ");
INSERT INTO bdv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଜହନ୍‌କେ ବିନେରିଗସ୍‌, ବଃଲେକ୍‌ “ଗଃର୍ଜ୍‌ତା ମେଗାର୍‌ ହୟ୍‌ସି” ବଃଲି ନାଉଁ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିଅ, ପିଲିପ୍, ବାର୍ତଲମି, ମାତିଉ, ତମା, ଆଲ୍‌ପିଅର୍‌ ହୟ୍‌ସି ଜାକୁବ, ତଦିୟ, କିଣାନିୟ ସିମନ୍, ଜୁୟ୍‌ ମାନାୟ୍‌ କି ଇସ୍ରାଏଲାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ରମିୟ ସଃର୍କାର୍‌ ତଃୟ୍‌ହୁଣି ମୁକ୍‌ଳାଉଁକେ ମଃନ୍ କଃର୍ତିରିଲା । ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ସେ ଏକ୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଆର୍‌ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା, ଜେ କି ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ତାର୍‌ହଃଚେ ଜିସୁ ଗଃରେ ଆୟ୍‌ଲା; ଆର୍‌ ସେତି ଗାଦା ଲକ୍‌ମଃନ୍ ରୁଣ୍ଡିରିଲାୟ୍‌, ତଃବାର୍‌ଗିନେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ କାଉଁକେ ହେଁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଜଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ଗଃରାର୍‌ ଲକ୍‌ ଇ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଜିସୁକେ ବାଉଳାୟ୍‌ ଆଣୁକେ ଗଃଳାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌, “ଜିସୁର୍‌ ମୁଣ୍ଡ୍ ବଃୟା ଅୟ୍‌ଲି,” ବଃଲି ଲକ୍‌ମଃନ୍ କଃଉଆକଇ ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଜିରୁସାଲମେ ହୁଣି ଆୟ୍‌ଲା ପାରୁସିମଃନ୍‌ କଃଉତି ରିଲାୟ୍‌, “ଜିସୁକେ ବୁତ୍‌ମଃନାର୍‌ ରଃଜା ବାଲ୍‌ଜିବୁଲ୍‌ ବୁତ୍‌ ଡଃସିଆଚେ, ତାର୍‌ ବଃଳେ ସେ ଲକ୍‌କେ ଡଃସିରିଲା ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ସେତାର୍‌ଗିନେ ଜିସୁ ସେମଃନ୍‌କେ ଲଃଗେ କୁଦ୍‌ଲା ଆର୍‌ ସେମଃନ୍‌କେ ଗଟେକ୍‌ କଃତା କୟ୍‌ ବୁଜାୟ୍‌ଲା, “ସୟ୍‌ତାନ୍ କଃନ୍‌କଃରି ସୟ୍‌ତାନ୍‌କେ ଚାଡାୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ଗଟେକ୍‌ ରାଇଜ୍‌ ଦୁୟ୍‌ ବାଗ୍ ଅୟ୍‌ ନିଜାର୍‌ ବିରଦେ ଉଟ୍‌ଲେକ୍‌ ସେ ରାଇଜ୍‌ କଃବେ ହେଁ ତିର୍‌ ଅୟ୍‌ ରେଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଜଃବେ କୁୟ୍‌ ଗଃରାର୍‌ ଲକ୍‌ମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିତ୍ରେ ବାଗ୍ ବାଗ୍ ଅଃଉତି, ତଃବେ ସେ ଗଃର୍‌ ତିର୍‌ ଅୟ୍‌ ରେଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ସେରଃକମ୍‌ ସୟ୍‌ତାନ୍‌ ଜଃଡେବଃଳ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟେଦ୍‌, ତାର୍‌ ରାଇଜ୍‌ ତିର୍‌ ଅୟ୍‌ ରେଉଁ ନାହାରେ, ମଃତର୍‌ ସେ ନାସ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ଆରେକ୍‌ କେ ବଃଳ୍‌ବପୁ ଲକ୍‌କେ ନଃବାନ୍ଦ୍‌ଲେକ୍‌, କଃନ୍‌କଃରି ତାର୍‌ ଗଃରେ ହୁରିକଃରି ତାର୍‌ ଆସ୍ତିବାଡି ଚରି ନେଉଁ ହାରେ ? ତାକ୍‌ ହଃର୍ତୁ ବାନ୍ଦ୍‌ଲେକ୍‌ ସିନା ତାର୍‌ ଗଃର୍‌ ଚରି ନେଉଁ ହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଲକ୍‌ମଃନ୍ ଜଃତେକ୍‌ ହାହ୍‌ ଆର୍‌ ଲିନ୍ଦାକଃରି ଆଚ୍‌ତି, ସେ ସଃବୁ କେମା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମାପ୍ରୁର୍‌ ବିରଦେ କଃତା କଃଉତି, ସେ ଲକ୍‌କେ କେମା କଃରା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ମଃତର୍‌ ଜେ ପବିତ୍ର ଆତ୍ମା ବିରଦେ ଲିନ୍ଦା କଃତା କୟ୍‌ଦ୍‌, ତାକ୍‌ ସଃବୁ ଦିନାର୍‌ ହାୟ୍‌ଁ କେମା ନାୟ୍‌ । ମଃତର୍‌ ସେ ସଃବୁ ଦିନ୍‌ ହାହି ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ଜିସୁ ଇବାନ୍ୟା କାୟ୍‌ତାକ୍‌ କୟ୍‌ଲା ବଃଲେକ୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତ୍ରିମଃନ୍ ଜିସୁକେ ବୁତ୍‌ ଦଃରି ଆଚେ ବଃଲି କଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ସଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ଆର୍‌ ବାୟ୍‌ସିମଃନ୍ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ହଃଦାୟ୍‌ ଟିଆଅୟ୍‌ ଜିସୁକେ କୁଦୁକେ କବୁର୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଜଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ଚାରିହାକ୍‌ ଲକ୍‌ମଃନ୍ ରୁଣ୍ଡିକଃରି ବଃସିରିଲାୟ୍‌, ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତର୍‌ ଆୟ୍‌ଦି, ବାୟ୍‌ଦି ଆର୍‌ ବେଣିମଃନ୍‌ ହଃଦାୟ୍‌ରଃୟ୍‌ ତକେ ଲଳୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜିସୁ ସେ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “କେ ମର୍‌ ଆୟା, ଆର୍‌ କେ ମର୍‌ ବାୟ୍‌ମଃନ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଜିସୁ ସେତି ବଃସିରିଲା ଚାରିବେଳ୍‌ତାର୍‌ ଲକ୍‌କେ ଦଃକିକଃରି ସେ କୟ୍‌ଲା, “ଦଃକା ! ଇ ଲକ୍‌ମଃନ୍ ମର୍‌ ଆୟା ଆର୍‌ ବାୟ୍‌ମଃନ୍, ");
INSERT INTO bdv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଜୁୟ୍‌ଲକ୍‌ ଇସ୍ୱରାର୍‌ ଇଚା ହୁରୁଣ୍‌ କଃରେଦ୍‌ ସେ ଲକ୍‌ ମର୍‌ ବାୟ୍‌, ବେଣି ଆର୍‌ ଆୟା ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁ ଆରେକ୍‌ ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ହୁଣି ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା, ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ଆସି ତାର୍‌ ଚାରିହାକ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ ଲାଗି ଜିସୁ ସଃମ୍‌ନ୍ଦେ ରିଲା ଗଟେକ୍‌ ଡଙ୍ଗାୟ୍‌ ଜାୟ୍‌ ବଃସ୍‌ଲା, ଆର୍‌ ଲକ୍‌ମଃନ୍ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ସଃଡେବଃଳ୍‌ ଜିସୁ କଃତା କୟ୍‌କଃରି ସେମଃନ୍‌କେ ଗାଦେକ୍‌ କଃତା କଃଉଁକେ ଦଃର୍ଲା, ଆର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ସୁଣା ଗଟେକ୍‌ ମାନାୟ୍‌ ତାର୍‌ ହଃଦାୟ୍‌ ବିଆନ୍ ବୁଣୁକ୍‌ ବାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ସେ ବିଆନ୍ ବୁଣ୍‌ତା ବଃଳ୍‌, କଃତେକ୍‌ ବିଆନ୍ ବାଟ ଲଃଗେ ଅଦୁର୍ଲି, ଆର୍‌ ଚେଳେମଃନ୍ ଆସି ସେ ସଃବୁ କାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଆର୍‌ କଃତେକ୍‌ ବିଆନ୍ ଅଃଳକ୍‌ ମାଟିରିଲା ଟେଳା ବୁୟେଁ ଅଦୁର୍ଲି, ଆର୍‌ ଅଃଳକ୍‌ ମାଟି ରିଲି ଲାଗି ବେଗି ଗଃଜା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମଃତର୍‌ ବେଳ୍‌ ଉଦି କଃରା କଃଲାକ୍‌ ଗଃଜା ସଃବୁ ହଡିଗଃଲି, ଚେର୍‌ ସଃବୁ ମାଟି ବିତ୍ରେ ଜାୟ୍‌ ନଃରିଲାକ୍‌ ଗଃଜାମଃନ୍ ସୁକିଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","କଃତେକ୍‌ ବିଆନ୍‌ କାଟା ବୁଟା ବିତ୍ରେ ଅଦୁର୍ଲି, ଆର୍‌ କାଟା ବୁଟାମଃନ୍‌ ବାଡ୍‌ଲି ଆର୍‌ ସେ ଗଃଜାମଃନ୍‌କେ ଚାହ୍‌ଲି, ତଃବାର୍‌ଗିନେ ସେ ଗଃଚେ ହଃଳ୍‌ ନଃଦେର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ମଃତର୍‌ ବିନ୍ କଃତେକ୍‌ ବିଆନ୍ ନିକ ବୁୟେଁ ଅଦୁର୍ଲି, ଆର୍‌ ସେରି ଗଃଜା ଅୟ୍‌ ବାଡିକଃରି ହଃଳ୍‌ ହଃଳ୍‌ଲି, କଃତେକ୍‌ ତିରିସ୍‌ ଗୁଣ୍, କଃତେକ୍‌ ସାଟେ ଗୁଣ୍ ଆର୍‌ ସଏ ଗୁଣ୍ ହଃଳ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଜିସୁ କୟ୍‌ଲା, “ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜଃଡେବଃଳ୍‌ ଜିସୁ ଏକ୍ଲା ରିଲା, ବାରଗଟ୍‌ ଚେଲା ଆର୍‌ ତାକାର୍‌ ସଃଙ୍ଗ୍ ରିଲା ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଗଃଉଆରି କଃଲାୟ୍‌, “ତୁୟ୍‌ କାୟ୍‌ତାକ୍‌ କଃତା କୟ୍‌ ସିକ୍ୟା ଦେଉଁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍‌କେ ଇସ୍ୱରାର୍‌ ରାଇଜାର୍‌ ବିତ୍ରିକଃତା ବୁଜୁକେ ସଃକ୍ତି ଦିଆ ଅୟ୍‌ଆଚେ, ମଃତର୍‌ ବିନ୍‌ ଲକ୍‌ମଃନ୍‌କେ କଃତାକୟ୍‌ ସିକ୍ୟା ଦେଉଁକ୍‌ ଅଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଜଃନ୍‌କଃରି, ସେମଃନ୍ ଦଃକି ଦଃକି, ଜାଣୁ ନଃହାର୍‌ତି; ଆର୍‌ ସୁଣି ସୁଣି, ବୁଜୁ ନଃହାର୍‌ତି । ଜଦି ସେମଃନ୍ ଜାଣ୍‌ତି ଆର୍‌ ବୁଜ୍‌ତି ଆର୍‌ କଃଡେବଃଳ୍‌ ମାପ୍ରୁ ହାକ୍‌ ବାଉଳି ଆସ୍ତି, ଆର୍‌ କେମା ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ କଃତା ତୁମିମଃନ୍ କାୟ୍‌ ବୁଜୁକ୍‌ ନଃହାରୁଲାସ୍‌ ? ତଃବେ ବିନ୍ କଃତା କଃନ୍‌କଃରି ବୁଜାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ବୁଣୁ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ବୁଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","କଃତେକ୍‌ ଲକ୍‌ ବାଟ ଲଃଗାର୍‌ ବୁୟ୍‌ଁ ହର୍‌, ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ସୁଣ୍‌ତି, ମଃତର୍‌ ସୁଣ୍‌ଲା ଦାହ୍ରେ ସୟ୍‌ତାନ୍‌ ଆସି ସେମଃନ୍ ସୁଣିରିଲା ବଃଚନ୍‌କେ ଚରି ନଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","କଃତେକ୍‌ ଲକ୍‌ ଚଃଚ୍ରା ଉହ୍ରେ ଅଃଳକ୍‌ ମାଟି ରିଲା ବୁୟ୍‌ଁ ହର୍‌, ସେମଃନ୍ ବଃଚନ୍ ସୁଣ୍‌ଲା ଦାହ୍ରେ, ସଃର୍ଦାଅୟ୍‌ ମଃନେ ଦଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ମଃତର୍‌ ସେମଃନାର୍‌ ଚେର୍‌ ମାଟି ବିତ୍ରେ ଜାୟ୍‌ନଃରିଲା ଗିନେ, ସେ ଲକ୍‌ମଃନ୍ ଚଃନେକ୍‌ ମଃତର୍‌ ତିର୍‌ ଅୟ୍‌ ରେତି, ଆର୍‌ ଜଃଡେବଃଳ୍‌ ମାପ୍ରୁର୍‌ ବଃଚନାର୍‌ ଗିନେ ଦୁକ୍‌କଃସ୍ଟ୍‌ କି ତାଡ୍‌ନା ଆୟ୍‌ଲେକ୍‌, ସେଦାହ୍ରେ ବିସ୍ୱାସ୍‌ ଚାଡ୍‌ତି, ସେମଃନ୍‌ ବୁଣା ଅୟ୍‌ରିଲା ଚଃଚ୍ରା ବୁୟ୍‌ଁ ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଆର୍‌ କଃତେକ୍‌ ଲକ୍‌ କାଟାବୁଟା ବିତ୍ରେ ବୁଣ୍‌ଲା ବିଆନ୍‌ ହର୍‌ ବଃଚନ୍ ସୁଣ୍‌ତି, ଆର୍‌ ଜଃଗତାର୍‌ ଚିତା, ଦଃନାର୍‌ ଲଃବ୍‌ ଆର୍‌ ବିନ୍ ସବୁ ରଃକମାର୍‌ ଲାଳ୍‌ସା ସେମଃନ୍‌କେ ଚାହି ହଃକାୟ୍‌ଦ୍‌ ଆର୍‌ ସେମଃନ୍ ହଃଳ୍‌ ହଃଳୁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ଜିବନେ ଦଃନ୍ଦି, ଜଃଗତାର୍‌ ମଲ୍‌ନୟ୍‌ଲା ଦଃନ୍ ଆର୍‌ ବିନ୍‌ ଜିନିସାର୍‌ ଇଚା ଆସେଦ୍‌ ଆର୍‌ ଚାହେଦ୍‌ ସେତାକ୍‌ ସେରି ହଃଳ୍‌ ନଃଦେରେ । ");
INSERT INTO bdv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମାପ୍ରୁର୍‌ ବଃଚନ୍ ସୁଣି ସେରି ମଃନେ ଦଃର୍ତି ଆର୍‌ ତିରିସ୍‌ ଗୁଣ୍, ସାଟେ ଗୁଣ୍ ଆର୍‌ ସଏ ଗୁଣ୍ ହଃଳ୍‌ ହଃଳ୍‌ତି, ସେମଃନ୍ ବୁଣା ଅୟ୍‌ରିଲା ନିକ ବୁୟ୍‌ଁ ହର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କୁୟ୍‌ ଲକ୍‌ କାୟ୍‌ କୁପି ଲାଗାୟ୍‌, ମାଣ୍ ତଃଳେ କି କଃଟ୍‌ ତଃଳେ ସଃଙ୍ଗାଉଁକେ ଆଣେଦ୍‌ ? ମଃତର୍‌ ଲକ୍‌ମଃନ୍‌ କୁପି ଲାଗାୟ୍‌ ରୁକା ଉହ୍ରେ ସଃଙ୍ଗାଉଁକେ କାୟ୍‌ ନାଣ୍‌ତି ? ");
INSERT INTO bdv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାଣା ନଃହେଳ୍‌ତାର୍‌ କାୟ୍‌ରି ହେଁ ଲୁକ୍‌ଣେ ନାୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ରି ଲୁକି ଆଚେ, ସେରି ହଃଦାୟ୍‌ ବାରାଉଁକ୍‌ ଲୁକି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଜଦି ତୁମାର୍‌ କାନ୍‌ ଆଚେ, ତଃବେ ସୁଣା !” ");
INSERT INTO bdv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମି ଜାୟ୍‌ରି ସୁଣୁଲାସ୍‌ ସେ କଃତାକ୍‌ ଜଃଗ୍ରାତ୍‌, ତୁମିମଃନ୍ ଜୁୟ୍‌ ନାହେଁ ନାହାସ୍‌, ସେ ନାହେଁ ତୁମିମଃନ୍‌କେ ନାହି ଦିଆ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ତୁମିମଃନ୍‌କେ ଅଃଦିକ୍‌ ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାର୍‌ ଆଚେ, ତାକ୍‌ ଦିଆ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜାର୍‌ ନାୟ୍‌ ତାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌ରି ଆଚେ, ସେରି ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଆରେକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଇରଃକମ୍‌ । ଜଃନ୍‌କଃରି ଗଟ୍‌ଲକ୍‌ ତାର୍‌ ବୁୟେଁ ବିଆନ୍ ବୁଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଆରେକ୍‌ ସେଲକ୍‌ ରାତିବଃଳ୍‌ ସୟ୍‌ଦ୍‌, ଆର୍‌ ଦିନ୍ ବଃଳ୍‌ ଉଟେଦ୍‌; ଆର୍‌ ବିଆନ୍ କଃନ୍‌କଃରି ଆକରି ବାଡେଦ୍‌ ଇରି ସେମାନାୟ୍‌ ନଃଜାଣେ । ");
INSERT INTO bdv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ବୁୟ୍‌ଁ ନିଜେ ହଃଳ୍‌ ହଃଳାୟ୍‌ଦ୍‌, ହଃର୍ତୁ ହଃତାର୍‌, ତାର୍‌ହଃଚେ କେଡ୍, ଆର୍‌ କେଡ୍ ବଃର୍ତି ଗଅଁ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ମଃତର୍‌ ସଃର୍ନେ କେଡ୍ ହାକ୍‌ଲେକ୍‌ କାଟ୍‌ତା ବେଳା ଅୟ୍‌ଲି ବଃଲି ସେ ଲକ୍‌ ଇଳା ସଃଙ୍ଗ୍ କାଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ କାର୍‌ ସଃଙ୍ଗ୍ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ତୁଳ୍‌ନା କଃରିନ୍ଦ୍‌ ? ଆରେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କୁୟ୍‌ କଃତା କୟ୍‌ ସେରି ବୁଜାୟ୍‌ନ୍ଦ୍ ? ");
INSERT INTO bdv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଗଟେକ୍‌ ସାନ୍ ସଃର୍ସୁ ମୁଞ୍ଜି ହର୍‌; ମାଟାୟ୍‌ ବୁଣ୍‌ତା ବଃଳ୍‌ ଇରି ହୁର୍ତିବିର୍‌ ସଃବୁ ମୁଞ୍ଜି ତଃୟ୍‌ହୁଣି ସାନ୍ । ");
INSERT INTO bdv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମଃତର୍‌ ବୁଣ୍‌ଲା ହଃଚେ ଇରି ବାଡିକଃରି ସଃବୁସାଗ୍ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ତାର୍‌ ଇରଃକମ୍‌ ବଃଡ୍‌ବଃଡ୍ ଡାଳ୍‌ ଅୟ୍‌ଦ୍‌ ଜେ, ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନ୍ ତାର୍‌ ଚାୟ୍‌ ଲଃଗେ ଗୁଡା କଃରୁକେ ହାର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଜିସୁ ଇରଃକମ୍‌ କଃତେକ୍‌ କଃତା କୟ୍‌ ସେମଃନାର୍‌ ବୁଜୁ ହାର୍ତା ହଃତେକ୍‌ ସେମଃନ୍‌କେ ସିକ୍ୟା ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଜିସୁ କଃତା ନଃକୟ୍‌କଃରି କାୟ୍‌ ସିକ୍ୟା ହେଁ ନଃଦେତି ରିଲା, ମଃତର୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ସଃବୁ କଃତା ଲୁକ୍‌ଣେ ବୁଜାଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ସେଦିନ୍ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌, ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଆସା ଅଃମି ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟି ଜୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ତଃବେ ଚେଲାମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ସେତି ଚାଡି ଜୁୟ୍‌ ଡଙ୍ଗାୟ୍‌ ଜିସୁ ବଃସିରିଲା, ଚେଲାମଃନ୍ ହେଁ ଜାୟ୍‌ ସେତି ବଃସ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁକେ ତାର୍‌ ସଃଙ୍ଗ୍ ନିଲାୟ୍‌ । ଆରେକ୍‌ ସେତି ବିନ୍ ବିନ୍ ଡଙ୍ଗା ହେଁ ତାକାର୍‌ ସଃଙ୍ଗ୍ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ତାର୍‌ହଃଚେ ତଃତ୍‌କାଣ୍‌ ସଃମ୍‌ନ୍ଦେ ଅଃପର୍‌ବଳ୍‌ ବାଉବଃତାସ୍‌ ଅୟ୍‌ଲି, ଆର୍‌ ସଃମ୍‌ନ୍ଦେ ଉଲାଳ୍‌ ଉଟି ଡଙ୍ଗା ବଃର୍ତି ହାଣି ଅଃଉଁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ସଃଡେବଃଳ୍‌ ଜିସୁ ଡଙ୍ଗାର୍‌ ହଃଚ୍‌ବାଟ୍‌ ମୁଚ୍‌ଳା ଉହ୍ରେ ମୁଣ୍ଡ୍ ଲାଦି ସୟ୍‌ରିଲା; ଆର୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ ଉଟାୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ମଃଲୁ, ଅଃମାର୍‌ ଗିନେ ତର୍‌ କାୟ୍‌ ଚିତା ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଜିସୁ ଉଟିକଃରି ବାଉହାଣିକେ ଦଃକା ଦଃୟ୍‌ ସଃମ୍‌ନ୍ଦ୍‌କେ କୟ୍‌ଲା, “ତୁନ୍‌ହାଳ୍‌, ଚୁପ୍ଅଃଉ ।” ସେତାକ୍‌ ବାଉ ତେବ୍‌ଲି ଆର୍‌ ସଃବୁ ତିର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ତାର୍‌ହଃଚେ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଅଃତେକ୍‌ ଡିରୁଲାସ୍‌, ଅଃବେ ହଃତେକ୍‌ କାୟ୍‌ ତୁମାର୍‌ ବିସ୍ୱାସ୍‌ ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ସେତାକ୍‌ ସେମଃନ୍ ଅଃପର୍‌ବଳ୍‌ ଡିରିକଃରି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଏ ତଃବେ କେ ଜେ, ବାଉ ଆର୍‌ ସଃମ୍‌ନ୍ଦ୍ ହେଁ ଆର୍‌ କଃତା ମାନୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ ସେହାଟି ରିଲା ଗରାସିୟମଃନାର୍‌ ଦେସେ ହଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ଡଙ୍ଗାୟ୍‌ହୁଣି ଉତୁର୍ଲା ଦାହ୍ରେ ଗଟେକ୍‌ ବିଟାଳ୍‌ ବୁତ୍‌ ଦଃର୍ଲା ଲକ୍‌ ମଃସ୍‌ଣେ ହୁଣି ବାରାୟ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ସେ ଲକ୍‌ ମଃସ୍‌ଣେ ରେତିରିଲା, ତାକ୍‌ କେ ହେଁ ସିକ୍ଳି ସଃଙ୍ଗ୍ ବାନ୍ଦି ସଃଙ୍ଗାଉଁକ୍‌ ନଃହାର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","କଃତିତର୍‌ ତାକ୍‌ ସିକ୍ଳି ସଃଙ୍ଗ୍ ଆତେ ଗଡେ ବାନ୍ଦ୍‌ତି ରିଲାୟ୍‌, ମଃତର୍‌ ସେ ସିକ୍ଳିକେ ଚିଡାୟ୍‌ ଗଃର୍ଣ୍ଡା ଗଃର୍ଣ୍ଡା କଃରି ହଃକାଉତି ରିଲା, ତାକ୍‌ ବାନ୍ଦିକଃରି ଆୟ୍‌ତ୍‌ କଃରୁକେ କାର୍‌ ସଃକ୍ତି ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ସେ ଦିନ୍‌ରାତି ସଃବୁବଃଳ୍‌ ମଃସ୍‌ଣେ ଆର୍‌ ଡଙ୍ଗ୍ରେ ବୁଲି ବୁଲି ବେଲ୍‌କି ଅଃଉତି ରିଲା, ଆର୍‌ ନିଜାର୍‌ ଗିନେ ନିଜେ ଟେଳାୟ୍‌ ଚେଚି ଅୟ୍‌ ଗାଉ କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ସେ ମାନାୟ୍‌ ଜିସୁକେ ଦୁରିକ୍‌ ହୁଣି ଦଃକ୍‌ଲା ଆର୍‌ ଦଃବ୍‌ଳି ଆୟ୍‌ଲା ଆର୍‌ ଜିସୁକେ ଜୁଆର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆର୍‌ ସେ ଆଉଲି ଅୟ୍‌କଃରି କୟ୍‌ଲା, “ଏ ସଃବ୍‌କେ ବଃଡ୍ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ଜିସୁ, ମର୍‌ତଃୟ୍‌ ତର୍‌ କାୟ୍‌ରି ଆଚେ ? ମୁଁୟ୍‌ ତକେ ଇସ୍ୱରାର୍‌ ନାଉଁଏ ଗଃଉଆରି କଃରୁଲେ, ମକ୍‌ ଡଃଣ୍ଡ୍‌ ଦେନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ତାକ୍‌ କଃଉଁକେ ଜାତିରିଲା, “ଏ ବିଟାଳ୍‌ ବୁତ୍‌ ଇ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଜାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଜିସୁ ତାକ୍‌ ହଃଚାର୍ଲା, “ତର୍‌ ନାଉଁ କାୟ୍‌ ନାଉଁ ?” ସେ କୟ୍‌ଲା, “ମର୍‌ ନାଉଁ ବାହିନି, ବଃଲେକ୍‌ ଅଃମି ଗାଦେକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଆର୍‌ ସେ କାନିକଃର୍ମ୍‌ ଅୟ୍‌ ଗଃଉଆରି କଃରି କଃଉଁକ୍‌ ଦଃର୍ଲା, “ଇତିହୁଣି ସଃନ୍ଦି ଜିଣ୍‌ତେ ଦୁରିକ୍‌ ଅଃମିକ୍‌ ହଃଟାଉ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ସେତିର୍‌ ଡଙ୍ଗୁର୍‌ କଃଳ୍‌କାୟ୍‌ ଗଟ୍‌ ଗୁସ୍ରା ମଃନ୍ଦା ଚଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ସେ ବିଟାଳ୍‌ ଦୁତ୍‌ମଃନ୍ ଜିସୁକେ କାନିକଃର୍ମ୍‌ ଅୟ୍‌ ଗଃଉଆରି କଃଲାୟ୍‌, “ହୟ୍‌ ଗୁସ୍ରାମଃନାର୍‌ ବିତ୍ରେ ହୁରୁକ୍‌ ଅଃମିକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ହଃଟାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁ ସେମଃନ୍‌କେ ଜଃଉଁକେ ଆଦେସ୍‌ ଦିଲାକ୍‌, ବିଟାଳ୍‌ ଦୁତ୍‌ମଃନ୍ ସେ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେତି ରିଲା ଗୁସ୍ରାମଃନାର୍‌ ବିତ୍ରେ ହୁର୍ଲାୟ୍‌, ଆର୍‌ ସେ ଗୁସ୍ରା ମଃନ୍ଦା ଦଃବ୍‌ଳି ଜାୟ୍‌ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ହୁଣି ଅଦ୍ରି ବୁଡି ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ତାର୍‌ହଃଚେ ଗୁସ୍ରା ଚଃରାଉତା ଲକ୍‌ମଃନ୍‌ ହଃଳାୟ୍‌ ଜାୟ୍‌ ସଃବୁ ଗଃଳେ ଆର୍‌ ଗାଉଁଏ ଜିସୁ କଃରିରିଲା ଗଃଟ୍‍ଣା ସଃବୁ କୟ୍‌ଲାୟ୍‌, ତଃବାର୍‌ଗିନେ ଲକ୍‌ମଃନ୍ କାୟ୍‌ରି ଅୟ୍‌ଆଚେ ବଃଲି ଦଃକୁକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଆର୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ହଃର୍ତୁ ଜୁୟ୍‌ ଲକ୍‌କେ ବିଟାଳ୍‌ ବୁତ୍‌ ଡଃସିରିଲି, ସେମାନାୟ୍‌ ନିକ ଅୟ୍‌କଃରି ହଃଚ୍ୟା ହିନ୍ଦି ସୁସ୍ତାମଃନେ ବଃସିରିଲାର୍‌ ଦଃକିକଃରି ସେମଃନ୍ ଡିରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌କେ ନିକ କଃଲାର୍‌ ଆର୍‌ ଗୁସ୍ରାମଃନ୍‌ ବୁଡି ମଃଲାର୍‌ ଦଃକି ରିଲାୟ୍‌, ସେମଃନ୍ ନଃଜାଣ୍‌ତା ଲକ୍‌କେ ସଃବୁ କଃତା କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଲକ୍‌ମଃନ୍ ଇ କଃତା ସୁଣିକଃରି, ଜିସୁକେ ତାକାର୍‌ ସଃନ୍ଦି ଚାଡି ଜାଆ ବଃଲି ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଜିସୁ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ତିରିଲା ବଃଳ୍‌, ଜୁୟ୍‌ ମାନାୟ୍‌କେ ବୁତ୍‌ ଡଃସିରିଲି, ସେମାନାୟ୍‌ ଜିସୁକେ “ମୁଁୟ୍‌ ହେଁ ତର୍‌ ସଃଙ୍ଗ୍ ଆସିନ୍ଦ୍‌,” ବଃଲି ତର୍‌କେ ତର୍‌ କାନିକଃର୍ମ୍‌ ଅୟ୍‌ ଗଃଉଆରି କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମଃତର୍‌ ଜିସୁ ସେମାନାୟ୍‌କେ ତାର୍‌ ସଃଙ୍ଗ୍ ଜଃଉଁକେ ମଃନାକଃରି ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ତର୍‌ ଗଃରେ, ତର୍‌ ଲକ୍‌ମଃନାର୍‌ ଟାଣେ ବାଉଳି ଜାଆ, ଆର୍‌ ମାପ୍ରୁ ତର୍‌ ଗିନେ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃରି ଆଚେ, ଆର୍‌ ତକେ ଦଃୟା କଃରି ଆଚେ, ସେ କଃତା ସେମଃନ୍‌କେ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ସେମାନାୟ୍‌ ଜିସୁର୍‌ କଃତାମାନି ସେତିହୁଣି ଗଃଲା, ଆର୍‌ ଜିସୁ ତାକ୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃରିରିଲା, ସେ କଃତା ଦେକାପଲି, ବଃଲେକ୍‌ ଦଃସ୍‌ଗଟ୍‌ ଗାଉଁଆର୍‌ ସଃବୁ ହାକ୍‌ ପର୍ଚାର୍‌ କଃରି ବୁଲ୍‌ଲା; ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଇ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ସେମଃନ୍ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଡଙ୍ଗାୟ୍‌ ବଃସି ଇହାଟି ବାଉଳି ଆୟ୍‌ଲା । ସେଲଃଗେ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ଦା ରୁଣ୍ଡ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ସେ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ସଃଡେବଃଳ୍‌ ଗଟେକ୍‌ ଜାଇରସ୍‌ ନାଉଁଆର୍‌ ଲକ୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକା ସେ ଲଃଗେ ଆୟ୍‌ଲା, ଆର୍‌ ଜିସୁକେ ଦଃକିକଃରି ତାର୍‌ ହାଦେ ଡୁଳି ଜୁଆର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ଆର୍‌ ବଃଡେ କାନିକଃର୍ମ୍‌ ଅୟ୍‌ ଗଃଉଆରି କଃଲା, “ମର୍‌ ବାର ବଃର୍ସାର୍‌ ସାନ୍ ଜିଇ ମଃର୍ତା ଉହ୍ରେ ଆଚେ, ସେ ଜଃନ୍‌କଃରି ମଃର୍ନ୍‌ ତଃୟ୍‌ହୁଣି ବଚେଦ୍‌, ଇତାର୍‌ ଗିନେ ତୁୟ୍‌ ଆଉ ଆର୍‌ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଜିସୁ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଃଲା, ଆର୍‌ ସେତି ରିଲା ଲକ୍‌ମଃନ୍ଦା ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ଉହ୍ରେ ମାଡାଚଃଗା ଅଃଉତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ସଃଡେବଃଳ୍‌ ବାର ବଃର୍ସ୍‌ ହଃତେକ୍‌ ଗଃଗାଳ୍‌ଜାତା ରଗେ ହଃଳ୍‌ଲା ଗଟେକ୍‌ ମାୟ୍‌ଜିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ସେ ରଗ୍ ଚାଡାୟ୍‌ ଅଃଉଁକେ କଃତେକ୍‌ ବୟ୍‌ଦ୍‌କାରି ହାକ୍‌ ଜାୟ୍‌କଃରି ସଃବୁଦଃନ୍‌ ସଃରାୟ୍‌ରିଲି, ମଃତର୍‌ ନିକ ଅଃଉତା ବାଦୁଲେ ଆରେକ୍‌ ଅଃଦିକ୍‌ ରଗି ଅୟ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ସେ ମାୟ୍‌ଜି ଜିସୁର୍‌ କଃତା ସୁଣ୍‌ଲି, ଆର୍‌ ସେ ଲକ୍‌ମଃନ୍ଦା ବିତ୍ରେ ଜିସୁର୍‌ ହଃଚ୍‌ବାଟ୍ୟା ଆସି ଜିସୁର୍‌ ହଃଚ୍ୟା ଆଚଳ୍‌ ଚୁୟ୍‌ଲି । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ବାବ୍‌ତି ରିଲି, ");
INSERT INTO bdv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ଜିସୁର୍‌ ହଃଚ୍ୟାର୍‌ ଆଚଳ୍‌ ଚୁୟ୍‌ଲେକ୍‌ ମୁଁୟ୍‌ ଉଜ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ସେ ଜିସୁର୍‌ ହଃଚ୍ୟା ଆଚଳ୍‌ ଚୁୟ୍‌ଲା ଦାହ୍ରେ ସେ ଗଃଗାଳ୍‌ ଜାତା ରଗେ ହୁଣି ଉଜ୍‌ ଅୟ୍‌ଲେ ବଃଲି ତାର୍‌ ଗଃଗାଳେ ଜାଣ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ସେଦାହ୍ରେ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ହୁଣି ସଃକ୍ତି ବାରାୟ୍‌ଲାର୍‌ ମଃନ୍ ବିତ୍ରେ ଜାଣ୍‌ଲା ଆର୍‌ ଲକ୍‌ ମଃନ୍ଦା ହାକ୍‌ ଲେଉଟି କଃରି କୟ୍‌ଲା, “କେ ମର୍‌ ବଃସ୍ତରାର୍‌ ଆଚଳ୍‌ ଚୁୟ୍‌ଲା ?” ");
INSERT INTO bdv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ତାର୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ତ ଦଃକୁଲିସ୍‌ ଲକ୍‌ମଃନ୍ କଃନ୍‌କଃରି ତର୍‌ ଉହ୍ରେ ମାଡା ଚଃଗା ଅଃଉଁଲାୟ୍‌, ଆର୍‌ ତୁୟ୍‌ କଃଉଁଲିସ୍‌, ‘କେ ମକ୍‌ ଚୁୟ୍‌ଲା ?’” ");
INSERT INTO bdv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ଜେ ତାକ୍‌ ଚୁୟ୍‌ରିଲି ତାକ୍‌ ଦଃକିନ୍ଦ୍ ବଃଲି ଜିସୁ ଚାରିହାକ୍‌ ଦଃକୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ସେତାକ୍‌ ସେ ମାୟ୍‌ଜି ଅଃହ୍‌ଣାର୍‌ ଉହ୍ରେ ଜୁୟ୍‌ ଗଃଟ୍‍ଣା ଗଃଟି ଆଚେ ବଃଲି ଜାଣ୍‌ଲି ଆର୍‌ ଡିରାର୍‌ ମାଡେ ତଃର୍‌ତଃରି କଃରି ଆୟ୍‌ଲି, ଆର୍‌ ଜିସୁର୍‌ ହାଦ୍‌ ତଃଳେ ଡୁଳି ସଃବୁ ସଃତ୍‌ କଃତା ତାକ୍‌ କୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ମର୍‌ ଜିଇ ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ଉଜ୍‌ କଃରିଆଚେ, ସୁସ୍ତାୟ୍‌ ଜାଆ ଆର୍‌ ତର୍‌ ରଗେ ହୁଣି ଉଜ୍‌ ଅୟ୍‌ରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଜିସୁ ଇ କଃତା କଃଉତା ବଃଳ୍‌, ସେ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକା ଜାଇରସାର୍‌ ଗଃରେହୁଣି କଃତି ଲକ୍‌ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ତର୍‌ ଜିଦି ମଃଲିନି, ଗୁରୁକ୍‌ ଆର୍‌ କାୟ୍‌ତାକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ କଃତା ସୁଣ୍‌ଲା ନଃସୁଣ୍‌ଲା ହର୍‌ ଅୟ୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକାକେ କୟ୍‌ଲା, “ଡିରା ନାୟ୍‌, ମଃତର୍‌ ବିସ୍ୱାସ୍‌ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ତାର୍‌ହଃଚେ ଜିସୁ ପିତର୍‌, ଜାକୁବ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଜହନ୍‌କେ ଚାଡି କାକେ ହେଁ ତାର୍‌ ସଃଙ୍ଗ୍ ନଃନିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ଆର୍‌ ସେମଃନ୍ ମୁଳିକା ଜାଇରସାର୍‌ ଗଃରେ ହଚ୍‌ଲାୟ୍‌, ସେତି ଜିସୁ ଲକ୍‌ମଃନ୍ କାଲାହୁଲି ଆର୍‌ କାନ୍ଦାବାଳା ଅଃଉତି ରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଜିସୁ ବିତ୍ରେ ଗଃଲା ଆର୍‌ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ କାଲାହୁଲି ଆର୍‌ କାନ୍ଦାବାଳା ଅଃଉଁଲାସ୍‌ । ଇ ଟକି ନଃମେରେ, ମଃତର୍‌ ସଇଆଚେ ।” ଇ କଃତା ସୁଣି ଲକ୍‌ମଃନ୍ ଟାହ୍ରା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ମଃତର୍‌ ଜିସୁ ସଃବ୍‌କେ ହଃଦାୟ୍‌ ବାର୍‌କଃରି, ସେ ହିଲାର୍‌ ଉବାସି, ଆୟ୍‌ସି ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେ ଟକିହିଲା ଜୁୟ୍‌ତି ସୟ୍‌ରିଲି, ସେତି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ତାର୍‌ହଃଚେ ଜିସୁ ସେ ଟକିହିଲାର୍‌ ଆତେ ଦଃରି ତାକ୍‌ କୟ୍‌ଲା, “ଟଲିତାକୁମ୍‌ !” ବଃଲେକ୍‌, “ଏ ନୁନି, ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ, ଉଟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ସେଦାହ୍ରେ ସେ ଟକିହିଲା ଉଟ୍‌ଲି ଆର୍‌ ଚାଲାବୁଲା କଃରୁକେ ଦଃର୍ଲି, ବଃଲେକ୍‌ ତାକ୍‌ ବାର ବଃର୍ସ୍‌ ଅୟ୍‌ରିଲି । ଇରି ଦଃକି କଃରି ସେମଃନ୍ କାବା ଅୟ୍‌ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ମଃତର୍‌ କେ ହେଁ ଜଃନ୍‌କଃରି ଇ କଃତା ନଃଜାଣତ୍‌, ଇତାର୍‌ ଗିନେ ଜିସୁ ସେମଃନ୍‌କେ କାକେହେଁ କଃଉଆ ନାୟ୍‌ ବଃଲି କୟ୍‌ଲା, ଆର୍‌ ସେ କୟ୍‌ଲା, “ଇ ଟକି ହିଲାକ୍‌ କାୟ୍‌ରି ଅଲେ କାଉଁକେ ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁ ସେ ଟାଣ୍ ଚାଡି ଅଃହ୍‌ଣାର୍‌ ଗାଉଁ ନାଜରିତେ ଗଃଲା ଆର୍‌ ଚେଲାମଃନ୍ ତାର୍‌ ହଃଚେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଆୟ୍‌ଲାକ୍‌ ସେ ପାର୍ତ୍‌ନା ଗଃରେ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା, କଃତେକ୍‌ ଲକ୍‌ ତାର୍‌ କଃତା ସୁଣି କାବାଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇମାନାୟ୍‌ର୍‌ ଇ ବୁଦି କୁୟ୍‌ତିହୁଣି ଆୟ୍‌ଲି ? ଆରେକ୍‌ ଇ ବୁଦି କୁୟ୍‌ତିହୁଣି ହାୟ୍‌ଲା ଆଚେ ? ଆର୍‌ ଜୁୟ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ ତାର୍‌ ଆତେ ଅଃଉଁଲି, ଇରିମଃନ୍‌ କାୟ୍‌ରି ? ");
INSERT INTO bdv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଇ ମାନାୟ୍‌ କାୟ୍‌ ସେ ବାଡାୟ୍‌ ନୟ୍‌ ? ଏ କାୟ୍‌ ମରିୟମାର୍‌ ହୟ୍‌ସି ଆର୍‌ ଜାକୁବକ୍‌, ଜସି, ଜିଉଦା ଆର୍‌ ସିମନାର୍‌ ବାୟ୍‌ସି ନୟ୍‌ ? ଆର୍‌ ଇତାର୍‌ ବେଣିମଃନ୍‌ କାୟ୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଇତି ନଃରେଉଁଲାୟ୍‌ ?” ଇରି କୟ୍‌ ସେମଃନ୍ ଜିସୁକେ ମାନ୍‌ତି ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନିଜାର୍‌ ଗାଉଁଏ, ନିଜାର୍‌ କୁଟୁମ୍‌ ଆର୍‌ ନିଜାର୍‌ ଗଃରାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଚାଡି ବାବ୍‌ବାଦି ସଃବୁ ତଃୟ୍‌ ମାନ୍‌ତି ହାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ସେଟାଣେ ଜିସୁ କଃତିଗଟ୍‌ ରଗି ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ସେମଃନ୍‌କେ ଉଜ୍‌ କଃର୍ତାର୍‌ ଚାଡି, ସେତି ଆର୍‌ କାୟ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଆର୍‌ ସେମଃନାର୍‌ ଅବିସ୍ୱାସ୍‌ ଦଃକି ଜିସୁ କାବା ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ଜିସୁ ଚାରି ଦିଗେ ଗାଉଁ ଗାଉଁ ବୁଲି ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା । ଇତାର୍‌ହଃଚେ ଜିସୁ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଗଟେ ଟାଣେ କୁଦ୍‌ଲା ଆର୍‌ ସେମଃନ୍‌କେ ଦୁୟ୍‌ଦୁୟ୍‌ ଲକେ ହଃଟାଉଁକେ ଦଃର୍ଲା, ଆର୍‌ ସେମଃନ୍‌କେ ବିଟାଳ୍‌ ବୁତ୍‌ମଃନାର୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ସେମଃନ୍ ଜାତାବଃଳ୍‌ ଗଟ୍‌ ଡାଙ୍ଗ୍‌କେ ଚାଡି ରୁଟି, କି ମଣା, କି ଅଃଟା ବାନ୍ଦୁଣ୍‌ ଜାଲିଆ ବିତ୍ରେ ଡାବୁ ନଃନେଉଁକେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ମଃତର୍‌ ସେମଃନ୍‌କେ ହାଣ୍ଡାୟ୍‌ ହିନ୍ଦୁକେ କୟ୍‌ଲା, ଆର୍‌ ହିନ୍ଦିରିଲା ଆଙ୍ଗି ଚାଡି, ବିନ୍ ଆଙ୍ଗି ନିଆନାଁୟ୍‌ ବଃଲି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜୁୟ୍‌ ଗଃରେ ହୁରାସ୍‌, ବାଉଳ୍‌ତା ହଃତେକ୍‌ ସେ ଗଃରେ ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ମଃତର୍‌ ଜୁୟ୍‌ ଗାଉଁଆର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ନଃଦେର୍ତି, କି ତୁମାର୍‌ କଃତା ନଃସୁଣ୍‌ତି, ସେତିହୁଣି ବାଉଳ୍‌ତା ବଃଳ୍‌, ସେମଃନାର୍‌ ସାକି ଅଃଉଁକେ ତୁମାର୍‌ ହାଦାର୍‌ ଦୁଳି ହାହଳି ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ସେତାର୍‌ଗିନେ ଚେଲାମଃନ୍ ବାରାୟ୍‌ ଜାୟ୍‌ ଦଃସ୍‌ ହାହ୍‌ ଚାଡି ଜିବନ୍‌ ବାଦ୍‌ଲାଉଁକ୍‌ ପର୍ଚାର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଆର୍‌ ଗାଦି ଲକ୍‌ମଃନ୍‌କେ ବୁତ୍‌ ଚାଡାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଗାଦି ରଗିମଃନ୍‌କେ ଚିକଣ୍‌ ଲାଗାୟ୍‌ ଉଜ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଜିସୁର୍‌ ନାଉଁ ସଃବୁହାକ୍‌ ଡାକ୍‌ ହୁଟ୍‌ଲି ଲାଗି ହେରଦ୍‌ ରଃଜା ତାର୍‌ କଃତା ସୁଣ୍‌ଲା ଆର୍‌ ଲକ୍‌ କଃଉତି ରିଲାୟ୍‌, “ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ମଃଲା ଲକାର୍‌ ବିତ୍ରେହୁଣି ଉଟି ଆଚେ, ସେତାକ୍‌ ଇସଃବୁ କାବା ଅଃଉତା କାମ୍‌ କଃରୁକେ ସେ ସଃକ୍ତି ହାୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ମଃତର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍ କଃଉତି ରିଲାୟ୍‌, “ଏ ଏଲିୟ, ଆରେକ୍‌ କଃତି ଲକ୍‌ କଃଉତି ରିଲାୟ୍‌, ହୁର୍ବାର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରେ ଏହେଁ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ମଃତର୍‌ ହେରଦ୍‌ ଇରି ସୁଣି କୟ୍‌ଲା, “ଜୁୟ୍‌ ଜହନ୍‌କ୍‌ ମୁଣ୍ଡ୍‌ ମୁଁୟ୍‌ କାଟିରିଲେ, ସେ ଆରେକ୍‌ ଉଟିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ହେରଦ୍‌ ନିଜାର୍‌ ବାୟ୍‌ସି ପିଲିପାର୍‌ ଡକୁର୍ସି ହେରଦିଆକେ ସଃଙ୍ଗାଇ ରିଲା, ସେତାର୍‌ଗିନେ ହେରଦିଆକେ ସଃର୍ଦା କଃରାଉଁକ୍‌ ନିଜେ ଲକ୍‌ ହଃଟାୟ୍‌ ଜହନ୍‌କେ ଦଃରି ଆଣି ବାନ୍ଦି ଜଃଇଲ୍‌ ବିତ୍ରେ ହୁରାୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ହେରଦ୍‌କେ କଃଉତିରିଲା, “ନିଜାର୍‌ ବାୟ୍‌ଦିର୍‌ ଡକୁର୍ସିକେ ସଃଙ୍ଗାଉତାର୍‌ ତର୍‌ ବିଦିନାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ସେତାର୍‌ଗିନେ ହେରଦିଆ ରିସା ଅୟ୍‌ ଜହନ୍‌କେ ମଃର୍ନେ ମାରୁକ୍‌ ମଃନ୍‌ କଃର୍ତିରିଲି, ମଃତର୍‌ ଜହନ୍‌କେ ମାରୁ ନଃହାର୍‌ତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହେରଦ୍‌ ଜହନ୍‌କେ ଗଟ୍‌ ଦଃର୍ମି ଆର୍‌ ପବିତ୍ର ମାନାୟ୍‌ ବଃଲି ଜାଣି ଡିରି ରିଲା ଆର୍‌ ମାରୁ ନଃଚ୍‌ତି ରିଲା । ଆର୍‌ ଜହନାର୍‌ କଃତା ସୁଣି ରିସା ଅୟ୍‌ଲେକ୍‌ ହେଁ, ତାର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ତାର୍‌ହଃଚେ ହେରଦିଆକେ ଗଟ୍‌ ବାଟ ମିଳ୍‌ଲି, ସେଦିନ୍‌ ହେରଦାର୍‌ ଜଃଲମ୍‌ ଦିନ୍, ମଃତ୍ରିମଃନାର୍‌ ଗିନେ, ହାଁଚ୍ କଳି ସଃଇନ୍ ଉହ୍ରେ ବଃଡ୍ ସଃଇନ୍‌ମଃନାର୍‌ ଗିନେ ଆର୍‌ ଗାଲିଲିର୍‌ ବଃଡ୍ ବଃଡ୍ ଲକାର୍‌ ଗିନେ ରାତ୍ୟା ଗଟେକ୍‌ ବଃଡ୍ ବଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ଆର୍‌ ହେରଦିଆର୍‌ ନିଜାର୍‌ ଜିସି ବିତ୍ରେ ଆସି ନାଚ୍‌ଲି, ଆର୍‌ ହେରଦ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ବଜିୟେ ବଃସିରିଲା ଲକ୍‌ମଃନ୍‌କେ ସଃର୍ଦା କଃରାୟ୍‌ଲି । ସେତାର୍‌ଗିନେ ହେରଦ୍‌ ରଃଜା, ଜିସିକେ କୁଦି କୟ୍‌ଲା, “ଜାୟ୍‌ରି ମଃନ୍ କଃରୁଲିସ୍‌, ସେରି ମାଗ୍, ମୁଁୟ୍‌ ତକେ ସେରି ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ରଃଜା ଜିସିକେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ହଃର୍ମାଣ୍‌ କଃରି କଃଉଁଲେ, ତୁୟ୍‌ ଜାୟ୍‌ରି ମାଗ୍‌ଲେକ୍‌, ଆର୍‌ ରାଇଜାର୍‌ ଆଦ୍‌ବାଗ୍ ମାଗ୍‌ଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ ସେରି ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ସେତାକ୍‌ ସେ ଜିସି ବାରାୟ୍‌ ଜାୟ୍‌ ତାର୍‌ ଆୟ୍‌ସିକ୍‌ ହଃଚାର୍ଲି, “ମୁୟ୍‌ଁ କାୟ୍‌ରି ମାଗିନ୍ଦ୍‌ ?” ତଃବେ ତାର୍‌ ଆୟ୍‌ସି ତାକ୍‌ କୟ୍‌ଲି, “ବାପ୍ତିସମ୍‌ ଦେତା ଜହନାର୍‌ ମୁଣ୍ଡ୍ ମାଗ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ସୁଣ୍‌ଲା ଦାହ୍ରେ ଜିସି ରଃଜାର୍‌ ହାକ୍‌ ବାଉଳି ଆୟ୍‌ଲି ଆର୍‌ ଇରି କୟ୍‌ ମାଗ୍‌ଲି, “ମର୍‌ ମଃନ୍, ତୁୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉ ଜହନାର୍‌ ମୁଣ୍ଡ୍‌ ଗଟ୍‌ ତାଳି ତଃୟ୍‌ ମକ୍‌ ଇ ଦାହ୍ରେ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ସେତାର୍‌ଗିନେ ରଃଜା ବଃଡେ ଦୁକ୍‌ କଃଲା, ମଃତର୍‌ ରଃଜା ଅଃହ୍‌ଣାର୍‌ ହଃର୍ମାଣ୍‌ ଆର୍‌ କାଉଁକେ ବଃସିରିଲା ଲକାର୍‌ ଗିନେ ନାୟ୍‌ ବଃଲି କଃଉଁକେ ନଃହାର୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ସେତାର୍‌ଗିନେ ରଃଜା ସେଦାହ୍ରେ ଗଟ୍‌ ସଃଇନ୍‌ ହଃଟାୟ୍‌ ଜହନାର୍‌ ମୁଣ୍ଡ୍‌କାଟି ଆଣୁକେ କୟ୍‌ଲା । ତାର୍‌ହଃଚେ ସଃଇନ୍‌ ଜଃଇଲ୍‌ ଗଃରେ ଜାୟ୍‌ ତାର୍‌ ମୁଣ୍ଡ୍‌କାଟି ଆଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଆର୍‌ ସେରି ଗଟ୍‌ ତାଳି ତଃୟ୍‌ ଜିସିକେ ଦିଲା, ଆର୍‌ ଜିସି ସେରି ନଃୟ୍‌ ତାର୍‌ ଆୟ୍‌ସିକ୍‌ ଦିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଜହନାର୍‌ ଚେଲାମଃନ୍ କବୁର୍‌ ହାୟ୍‌ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜହନାର୍‌ ମଃଲାମଃଳ୍‌ ନଃୟ୍‌ ମଃସୁଣ୍‌ କାଲେ ତହ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ତାର୍‌ହଃଚେ ପେରିତ୍‌ମଃନ୍‌ ଜିସୁର୍‌ ଲଃଗେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ଜାୟ୍‌ରି ଜାୟ୍‌ରି କଃରି ରିଲାୟ୍‌ ଆର୍‌ ତୁୟ୍‌ ଜୁୟ୍‌ରି ସିକ୍ୟା ଦଃୟ୍‌ରିଲାୟ୍‌ ସେରିମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଗାଦେକ୍‌ ଲକ୍‌ ଜାଆଆସ୍‌ ଅଃଉତିରିଲାୟ୍‌ ଲାଗି, ସେମଃନ୍ କାଉଁକେ ହେଁ ନଃହାର୍‌ତି ରିଲାୟ୍‌ । ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃମିମଃନ୍‌ ଅଃଲ୍‌ଗା ଅୟ୍‌ ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ଜୁଆଁ, ଆର୍‌ ସେତି ଚଃନେକ୍‌ ବିସାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତାର୍‌ହଃଚେ ସେମଃନ୍ ସେ ଟାଣ୍ ଚାଡି ଡଙ୍ଗାୟ୍‌ ବଃସି ଗଟ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ବାରାୟ୍‌ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ମଃତର୍‌ କଃତିଲକ୍‌ ସେମଃନ୍‌କେ ବାରାୟ୍‌ ଜାତାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ ଆର୍‌ ଚିନ୍‌ଲାୟ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ସଃବୁ ଗଃଳେହୁଣି ହାଦେ ଇଣ୍ଡିଜାୟ୍‌ ସେତି ଅଃକା ସଃଙ୍ଗ୍ ଦଃବ୍‌ଳିଜାୟ୍‌ ସେମଃନାର୍‌ ଆଗାଳି ହଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁ ଡଙ୍ଗାୟ୍‌ ହୁଣି ଉତ୍ରି ଅଲେକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ସେ ଲକାର୍‌ ଗିନେ ମଃନ୍ ବିତ୍ରେ ଦଃୟା ଆୟ୍‌ଲି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଗଃଉଳିଆ ନୟ୍‌ଲା ମେଣ୍ଡା ହର୍‌ ରିଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍‌କେ ଅଃନେକ୍‌ କଃତା ସିକ୍ୟା ଦେଉଁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ବେସି ବେଳ୍‌ ଆୟ୍‌ଲାକ୍‌ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ଆସି ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇଟାଣ୍‌ ତ ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣ୍ ଆର୍‌ ବେସି ବେଳ୍‌ ଅୟ୍‌ଲିବେ; ");
INSERT INTO bdv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି ଚାରିହାକ୍‌ ଗାଉଁଗୁଡାୟ୍‌ ଜାୟ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଗିନେ କାଉଁକେ କାଦି ଗେନ୍‌ତି । ଇତାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ସେଲ ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ସେମଃନ୍‌କେ କାଳାଉଆ ।” ସେତାକ୍‌ ଚେଲାମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ଜାୟ୍‌ ହାଁଚ୍‌କଳି ଟଃକାର୍‌ ରୁଟି ଗେନିଆଣି କାୟ୍‌ ସେମଃନ୍‌କେ କାଳାଉଁକ୍‌ ହାରୁନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମାର୍‌ହାକ୍‌ କଃତିଗଟ୍‌ ରୁଟି ଆଚେ ଜାୟ୍‌ ଦଃକା ।” ଚେଲାମଃନ୍ ଦଃକିଆସି କୟ୍‌ଲାୟ୍‌, “ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜଳେକ୍‌ ମାଚ୍ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ସେତି ଜଃନ୍‌କଃରି ଦଃଳ୍‌ ଦଃଳ୍‌ ଅୟ୍‌ କଃଉଁଳା ରଃନ୍ ଉହ୍ରେ ଲକ୍‌ମଃନ୍‌କେ ବଃସାଉଁକ୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ସଃବୁ ହାଁଚ୍‌କଳି ଆର୍‌ ଦୁୟ୍‌କଳି ଦଃସ୍‌ ଲେକା ଅୟ୍‌ ବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ତାର୍‌ହଃଚେ ଜିସୁ ସେ ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଜଳେକ୍‌ ମାଚ୍ ଦଃରି ସଃର୍ଗ୍‌ ବାଟ୍ୟା ଦଃକି ଇସ୍ୱର୍‌କେ ପାର୍ତ୍‌ନା କଃଲା ଆର୍‌ ରୁଟିମଃନ୍‌ ଆସିର୍ବାଦ୍‌ କଃରି ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦେଉଁକେ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, ଆର୍‌ ସେ ଜଳେକ୍‌ ମାଚ୍‍କ୍ ସେ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦେଉଁକେ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ସେତିର୍‌ ସଃବୁଲକ୍‌ ହେଟ୍‌ ହୁର୍ନେ କାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ସଃବୁଲକ୍‌ କାୟ୍‌ ସଃର୍ଲା ହଃଚେ, ଚେଲାମଃନ୍ ଉବୁର୍ଲାର୍‌ ବାଙ୍ଗ୍‌ଲା ରୁଟି ଆର୍‌ ମାଚ୍ ରୁଣ୍ଡାୟ୍‌ ବାରଡଃଲା ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ଜଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ରୁଟି କାୟ୍‌ରିଲାୟ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଅଃବ୍‌କା ଅଃଣ୍ଡ୍ରାହିଲା ହଃକା ହାଁଚ୍ ଅଃଜାର୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ତଃତ୍‌କାଣ୍ ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ସଃମ୍‌ନ୍ଦ୍ ସେହାଟିର୍‌ ବେତ୍‌ସାଇଦାକେ ଆଗ୍‌ତୁ ହଃଟାୟ୍‌ଲା, ଆର୍‌ ତାର୍‌ହଃଚେ ଲକ୍‌ମଃନ୍‌କେ ହେଁ ଗଃରେ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ସେଲଚାଡି ଦଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ସଃଞ୍ଜ୍ ଅୟ୍‌ଲା ହଃଚେ, ଡଙ୍ଗା ମଃଜି ସଃମ୍‌ନ୍ଦେ ରିଲାବଃଳ୍‌ ଜିସୁ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡିଏ ଏକ୍ଲା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଚେଲାମଃନ୍ ଡଙ୍ଗା ଗାଟୁକେ କଃସ୍ଟ୍‌ ହାଉତାର୍‌ ଜିସୁ ଦଃକ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାକାର୍‌ ଆଗ୍‌ବାଟ୍ୟା ବାଉ ଅଃଉତି ରିଲି, ଉଜାଳ୍‌ ଅଃଉତାବଃଳ୍‌ ଚାର୍‌ଟା ବଃଳ୍‌ ଜିସୁ ସଃମ୍‌ନ୍ଦ୍ ଉହ୍ରେ ଇଣ୍ଡି ଇଣ୍ଡି ତାକାର୍‌ ଚଃମେ ଆୟ୍‌ଲା, ଆର୍‌ ସେମଃନ୍‌କେ ଜିଣ୍‌ତେ ହାକ୍‌ମାରି ଜଃଉଁକେ ମଃନ୍‌ କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ମଃତର୍‌ ସେମଃନ୍ ତାକ୍‌ ସଃମ୍‌ନ୍ଦ୍ ଉହ୍ରେ ଇଣ୍ଡ୍‌ତାର୍‌ ଦଃକି ଡୁମା ବଃଲି ବେଲ୍‌କି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃବୁଲକ୍‌ ତାକ୍‌ ଦଃକି ଡିରି ଗଃଲାୟ୍‌ । ମଃତର୍‌ ଜିସୁ ତଃତ୍‌କାଣ୍ ତାକାର୍‌ ସଃଙ୍ଗ୍ କଃତାଅୟ୍‌ କୟ୍‌ଲା, “ଡିରା ନାୟ୍‌ ସାସ୍‌ ଦଃରା, ଇରି ତ ମୁଁୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଆରେକ୍‌ ସେ ସେମଃନାର୍‌ ଲଃଗେ ଜାୟ୍‌ ଡଙ୍ଗାୟ୍‌ ବଃସ୍‌ଲା, ଆର୍‌ ବାଉ ବଃନ୍ଦ୍‌ ଅୟ୍‌ଲି, ସେତାର୍‌ଗିନେ ଚେଲାମଃନ୍ ମଃନେ ମଃନେ ଅଃପର୍‌ବଳ୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ହାଁଚ୍ ଆଜାର୍‌ ଲକ୍‌ମଃନ୍‌କେ କାଦି କାଳାୟ୍‌ଲାର୍‌ ବୁଦି ସେମଃନ୍‌କେ ଅୟ୍‌ନଃରିଲି, ଆର୍‌ ତାକାର୍‌ ମଃନ୍‌ ଅଃଟୁଆ ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ସେମଃନ୍ ସଃମ୍‌ନ୍ଦ୍ ଲିଙ୍ଗି ଗିନେସ୍‌ରଃତ୍‌ କଃଣ୍ଡାୟ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେତି ସେମଃନ୍ ଡଙ୍ଗା ବାନ୍ଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଆର୍‌ ସେମଃନ୍ ଡଙ୍ଗାୟ୍‌ହୁଣି ଉତୁର୍ଲା ଦାହ୍ରେ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଚିନ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ସେଦାହ୍ରେ ଲକ୍‌ମଃନ୍ ଲଃଗାର୍‌ ଗାଉଁମଃନ୍‌କେ ଦଃବ୍‌ଳି ଜାୟ୍‌, ଜୁୟ୍‌ ଜୁୟ୍‌ ଟାଣେ ଜିସୁ ଆଚେ ବଃଲି ସୁଣ୍‌ଲାୟ୍‌, ସେ ଟାଣେ ମଃଳୁହଃଳ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଟାଟି ତଃୟ୍‌ଁ ବୟ୍‌ଆଣୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଆର୍‌ ଜିସୁ ଜୁୟ୍‌ ଜୁୟ୍‌, ଗଃଳେ ଆର୍‌ ଗାଉଁଏ ଗୁଡାୟ୍‌ ଗଃଲା, ଲକ୍‌ମଃନ୍ ସେ ସଃବୁଟାଣେ ଜୁୟ୍‌ ମାନାୟ୍‌ମଃନ୍‌ ମଃଳୁ ହଃଳି ରିଲାୟ୍‌, ସେମଃନ୍‌କେ ଲକ୍‌ମଃନ୍ ଆଟ୍‌ ବଃଜାରେ ନଃୟ୍‌ ସଳାୟ୍‌ ସେମଃନ୍ ଜଃନ୍‌କଃରି ଜିସୁର୍‌ ହଃଚ୍ୟାର୍‌ ଆଚଳ୍‌ ଚିଉତି, ସେତାକ୍‌ ତାକ୍‌ ଗଃଉଆରି କଃଲାୟ୍‌ ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ଚୁୟ୍‌ଲାୟ୍‌ ସେମଃନ୍ ଉଜ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ତାର୍‌ହଃଚେ ପାରୁସିମଃନ୍ ଆର୍‌ ଜିରୁସାଲମେ ହୁଣି ଆସିରିଲା କଃତେକ୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଜିସୁର୍‌ ଚଃମେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ କଃତିଗଟ୍‌ ଚେଲାକେ ଜିଉଦିମଃନାର୍‌ ରିତିବିଦି ହଃର୍କାରେ ଆତ୍‌ ନଃଦଉତ୍‌ ମେଳି ଆତେ କାତିରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିମଃନ୍ ଆର୍‌ ଜିଉଦିମଃନ୍ ହୁର୍ବ୍‌ କାଳାର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ରିତିବିଦି ମାନିକଃରି ନିକକଃରି ଆତ୍‌ ନଃଦୟ୍‌ଲେକ୍‌ କାୟ୍‌ରି ହେଁ କାତି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ଆଟେ ବଃଜାରେ ହୁଣି ଗଃରେ ଆସ୍ତି ରିଲାୟ୍‌, ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗଃଗାଳ୍‌ ଦଃଉତି ରିଲାୟ୍‌, ନଃଦଃଉତା ହଃତେକ୍‌ କାଦି ନଃକାତି ରିଲାୟ୍‌; ଆର୍‌ ଗିନା, ମୁତା ଆର୍‌ କଃସ୍‌ଆଣ୍ଡିର୍‌ ହାଣାୟ୍‌ ବୁଡାଉତାର୍‌ ଆର୍‌ କାୟ୍‌କାୟ୍‌ରି ଗାଦେକ୍‌ ରିତିବିଦି ମାନୁକେ ସେମଃନ୍ ଆଦେସ୍‌ ହାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ଇତାର୍‌ ଗିନେ ପାରୁସି ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ତର୍‌ ଚେଲାମଃନ୍‌କେ ହୁର୍ବ୍‌ କାଳାର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ରିତିବିଦି ହଃର୍କାରେ କାୟ୍‌ତାକ୍‌ ଚାଲାଚାଲ୍‌ତି ନଃକେରି ଆତ୍‌ ନଃଦଃୟ୍‌ ମେଳି ଆତେ କାଉଁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ରେ ହେଟ୍‌କପଟ୍ୟାମଃନ୍‌, ଜିସାୟ୍‌ ବାବ୍‌ବାଣିଏ ତୁମାର୍‌ ଗିନେ ସଃତ୍‌ କଃତା କୟ୍‌ଲା ଆଚେ, ଜଃନ୍‌କଃରି ଲେକା ଆଚେ- ଇସ୍ୱର୍‌ କଃଉଁଲା, ‘ଇ ଜାତି ମୁଏଁ ମକ୍‌ ମାନ୍‌ତି କଃର୍ତି, ମଃତର୍‌ ସେମଃନାର୍‌ ମଃନ୍ ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ଆର୍‌ ସେମଃନ୍ ମାନାୟ୍‌ମଃନାର୍‌ ରିତିବିଦିକ୍‌ ମାପ୍ରୁର୍‌ ବଃଲି ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେତି, ଆର୍‌ ହଲ୍ୟା ହଲ୍ୟା ଇ ଲକ୍‌ମଃନ୍ ମର୍‌ ସେବା କଃର୍ତି ।’” ");
INSERT INTO bdv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ତୁମିମଃନ୍ ଇସ୍ୱର୍‌ ଦିଲା ବିଦି ଚାଡି ନଃର୍‌ମଃନାର୍‌ ରିତିବିଦିକ୍‌ ଦଃରି ଆଚାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମାନି ଆସ୍ତାର୍‌ ରିତିବିଦି ଗିନେ, ଇସ୍ୱରାର୍‌ ବିଦିକେ ଚାଡୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମସା କୟ୍‌ଲା ଆଚେ, ‘ନିଜାର୍‌ ଆୟା ଉବାକ୍‌ ମାନ୍‌ତି କଃରା,’ ଆର୍‌, ‘ଜୁୟ୍‌ ଲକ୍‌ ଆୟା ଉବାକ୍‌ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେ ବାୟ୍‌ଦ୍‌ରେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମଃତର୍‌ ତୁମିମଃନ୍ ସିକ୍ୟା ଦେଉଁଲାସ୍‌, କେ ଜଦି ଉବା କି ଆୟାକ୍‌ କୟ୍‌ଦ୍‌, ‘ମର୍‌ ତଃୟ୍‌ହୁଣି ତୁମି ଜାୟ୍‌ ଉହ୍‌କାର୍‌ ହାଉତାର୍‌ ଆଚେ, ସେରି ମୁଁୟ୍‌ କର୍ବାନ୍ କଃରି ଆଚି ।’ ବଃଲେକ୍‌ ଇସ୍ୱର୍‌କେ ଦାନ୍‌ କଃରିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ତଃବେ ତୁମି ଇବାନ୍ୟା ଲକ୍‌ମଃନ୍‌କେ ତାକାର୍‌ ଆୟ୍‌ସି ଉବାସିର୍‌ ଗିନେ କାୟ୍‌ରି ହେଁ କଃରୁକେ ନଃଦେଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଇବାନ୍ୟା ତୁମିମଃନ୍ ତୁମାର୍‌ କଃରି ଆସ୍ତା ରିତିବିଦି ଗିନେ ଇସ୍ୱର୍‌ ଦିଲା ରିତିବିଦିକ୍‌ ନଃମାନୁଲାସ୍‌, ଆର୍‌ କଃତେକ୍‌ କଃତେକ୍‌ କାମ୍‌ କଃରୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍ଦାକେ ଲଃଗେ କୁଦି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ସଃବୁଲକ୍‌ ମର୍‌ କଃତା ସୁଣା ଆର୍‌ ବୁଜା; ");
INSERT INTO bdv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ଇବାନ୍ୟା କୁୟ୍‌ କଃତା ନାୟ୍‌ ଜୁୟ୍‌ରି ହଃଦାୟ୍‌ ହୁଣି ଆସି ଲକାର୍‌ ବିତ୍ରେ ହୁରି ତାକ୍‌ ବିଟାଳ୍‌ କଃରେଦ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ରି ଲକାର୍‌ ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ଦ୍‌, ସେ ସଃବୁ ତାକ୍‌ ବିଟାଳ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଜଦି ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ, ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଗଃର୍‌ ବିତ୍ରେ ଆୟ୍‌ଲା ହଃଚେ, ତାର୍‌ ଚେଲାମଃନ୍ ତାକ୍‌ ଇ କଃତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ବଃଲି ହଃଚାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍‌କେ ହେଁ କାୟ୍‌ ସେମଃନାର୍‌ ହର୍‌ ବୁଦି ନାୟ୍‌ ? ଜାୟ୍‌ରି ସଃବୁ ହଃଦାୟ୍‌ହୁଣି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ହୁରେଦ୍‌, ସେରି ତାକ୍‌ ବିଟାଳ୍‌ କଃରୁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେରି ତାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ନଃହୁରି ହେଟ୍‌ ବିତ୍ରେ ହୁରେଦ୍‌, ଆର୍‌ ହଃଦାୟ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ଦ୍‌, ଇରି କାୟ୍‌ ନଃବୁଜୁଲାସ୍‌ ?” ଇବାନ୍ୟା ଜିସୁ ସଃବୁ କାଦି ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ବଃଲି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜାୟ୍‌ରି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ହଃଦାୟ୍‌ ବାରାୟ୍‌ଦ୍‌, ସେରି ତାକ୍‌ ବିଟାଳ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଲକାର୍‌ ବିତ୍ରେ ହୁଣି ବଃଲେକ୍‌ ଲକ୍‌ମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ହୁଣି କଃରାବ୍‌ ଚିତା, ଚର୍‌ କଃରୁକେ, ଦାରି କଃରୁକେ, ନଃର୍‌ଅଃତ୍ୟା, ");
INSERT INTO bdv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ବେସୁଆ, ଲଃବ୍‌ କାମ୍‌, ମିଚ୍ କଃଉତାର୍‌, ଅଃଳ୍‌ସିଆ, ଅଃକାର୍‌ ଅଃଉତାର୍‌, ଲକାର୍‌ ବିରଦେ ଲିନ୍ଦାକଃତା କଃଉତାର୍‌, ଗଃର୍ବ୍‌ ଦଃକାୟ୍‌ ଅଃଉତାର୍‌, ବକୁଆ ବୁଦି । ");
INSERT INTO bdv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଇରିମଃନ୍‌ ସଃବୁ ଲକାର୍‌ ମଃନ୍ ବିତ୍ରେ ହୁଣି ହଃଦାୟ୍‌ ବାରାଉଁଲି ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ ବିଟାଳ୍‌ କଃରୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଇତାର୍‌ହଃଚେ ଜିସୁ ସେ ଜଃଗାୟ୍‌ହୁଣି ଉଟି ସର୍‌ ସଃନ୍ଦିକେ ଗଃଲା ଆର୍‌ ତାକ୍‌ କେ ହେଁ ନଃଜାଣତ୍‌ ବଃଲି ଇଚା କଃରି ଗଟେକ୍‌ ଗଃରେ ହୁର୍ଲା, ମଃତର୍‌ ସେ ଲୁକ୍‌ଣେ ରେଉଁ ନଃହାର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ସଃଡେବଃଳ୍‌ ଜିସୁର୍‌ କଃତା ସୁଣି ସେଦାହ୍ରେ ଗଟେକ୍‌ ମାୟ୍‌ଜି ଜାର୍‌ ଜିସିକେ ବୁତ୍‌ ଡଃସିରିଲି, ସେ ସଃଙ୍ଗେ ସଃଙ୍ଗେ ଜିସୁର୍‌ ଲଃଗେ ଆୟ୍‌ଲି ଆର୍‌ ତାର୍‌ ଗଡେ ଡୁଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ସେ ମାୟ୍‌ଜି ସର୍‌ ହଲିର୍‌ ସୁରପଇନିକିଆ ଜାତିର୍‌ ଗ୍ରିକ୍‌ମାୟ୍‌ଜି ରିଲି, ଆର୍‌ ସେ ଜିସୁକେ ଗଃଉଆରି କଃରି ମର୍‌ ଜିଇର୍‌ ଲଃଗେହୁଣି ବୁତ୍‌ ଚାଡାଉ ବଃଲି କଃଉତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଆଗ୍‌ତୁ ହିଲାମଃନ୍‌କେ ହେଟ୍‌ ହୁର୍ନେ କାଉଁକେ ଦିଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହିଲାମଃନାର୍‌ କାତା କାଦି କୁକୁର୍‌ମଃନାର୍‌ ଚଃମେ ହିଙ୍ଗ୍‌ତାର୍‌ ନିକ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ମଃତର୍‌ ସେ ମାୟ୍‌ଜି ଉତୁର୍‌ ଦିଲି, “ହେଁ ମାପ୍ରୁ, ମଃତର୍‌ କୁକୁର୍‌ମଃନ୍ ହେଁ ଟେବୁଲ୍‌ ତଃଳେ ଅଦ୍ରି ରିଲା ହିଲାମଃନାର୍‌ ଲିତା ସଃକ୍ଳିମଃନ୍‌ ବେଟି କାତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତର୍‌ ଇ କଃତାର୍‌ ଗିନେ, ତୁୟ୍‌ ଗଃରେ ବାଉଳି ଜାଆ, ତର୍‌ ଜିଦିର୍‌ ଲଃଗେହୁଣି ବୁତ୍‌ ବାରାୟ୍‌ ଗଃଲିବେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ସେ ମାୟ୍‌ଜି ଗଃରେ ଜାୟ୍‌ ତାର୍‌ ଜିସି ଟାଟାୟ୍‌ ସଇରିଲାର୍‌ ଆର୍‌ ବୁତ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାର୍‌ ଦଃକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଆରେକ୍‌ ଜିସୁ ସର୍‌ ସଃନ୍ଦିହୁଣି ସିଦନ୍‌ ଆର୍‌ ଦେକାପଲି ସଃନ୍ଦି ଅୟ୍‌କଃରି ଗାଲିଲି ସଃମ୍‌ନ୍ଦ୍ ଚଃମେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ସେତି ଲକ୍‌ମଃନ୍ ଗୁଲା ଆର୍‌ ବଃୟ୍‌ରା ଲକ୍‌କେ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାଉ ବଃଲି ଜିସୁକେ ଗଃଉଆରି କଃରି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ସେମାନାୟ୍‌କେ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଲ୍‌ଗା କଃରି ଏକ୍ଲାକେ କୁଦି ନଃୟ୍‌ ତାର୍‌ କାନେ ଜଳେକ୍‌ ଆଙ୍ଗଟି ହୁରାୟ୍‌ଲା ଆର୍‌ ଲାଳ୍‌ ତୁକି ତାର୍‌ ଜିବେ ଚୁୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ତାର୍‌ହଃଚେ ଜିସୁ ସଃର୍ଗ୍‌ ବାଟ୍‌ ଦଃକି ବଃଡ୍ ହୁଣ୍ଡାଣ୍ ହୁଣ୍ଡିକଃରି ସେମାନାୟ୍‌କେ କୟ୍‌ଲା, “ଇପ୍‌ପତ ।” ବଃଲେକ୍‌, “ଇଟିଜା ।” ");
INSERT INTO bdv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ସେଦାହ୍ରେ ସେମାନାୟ୍‌ର୍‌ କାନ୍‌ ଉଗାଳି ଅୟ୍‌ଲି ଆର୍‌ ତାର୍‌ ଜିବାର୍‌ ବାନ୍ଦୁଣ୍ ଇଟ୍‌ଲି ଲାଗି ସେ ନିକ କଃରି କଃତା ଅଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ତାର୍‌ହଃଚେ ଜିସୁ କାକେ ହେଁ ଇ କଃତା କଃଉଆ ନାୟ୍‌ ବଃଲି ସେମଃନ୍‌କେ ନିକ କଃରି କୟ୍‌ଲା; ମଃତର୍‌ ଜଃତେକ୍‌ କଃଉଁକେ ମଃନା କଃଲେକ୍‌ ହେଁ ସେମଃନ୍ ଅଃଦିକ୍‌ ସଃବୁହାକ୍‌ ପର୍ଚାର୍‌ କଃରି ବୁଲ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଇ କଃତା ଲକ୍‌ମଃନ୍ ସୁଣି କାବା ଅୟ୍‌ଗଃଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ସେ ସଃବୁ କାମ୍‌ ନିକକଃରି କଃଲା ଆଚେ, ଆର୍‌ ବଃୟ୍‌ରା ଲକ୍‌କେ ସୁଣ୍‌ତା ସଃକ୍ତି ଆର୍‌ ଗୁଲା ଲକ୍‌କେ କଃଉତା ସଃକ୍ତି ଦେଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ସଃଡେବଃଳ୍‌ ଆରେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ଜିସୁର୍‌ ଚଃମେ ଆସି ରୁଣ୍ଡ୍‌ଲାୟ୍‌, ସେମଃନାର୍‌ ହାକ୍‌ କାଉଁକେ କାୟ୍‌ରି ହେଁ ନଃରିଲି । ଆର୍‌ ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ଇ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ମକ୍‌ ବଃଡେ ଦଃୟା ଅଃଉଁଲି । ଇ ଲକ୍‌ମଃନ୍ ତିନି ଦିନ୍ ଅୟ୍‌ଲିନି ମର୍‌ ସଃଙ୍ଗ୍ ଆଚ୍‌ତି, ଅଃବେ ସେମଃନାର୍‌ ହାକ୍‌ କାଉଁକେ କାୟ୍‌ରି ହେଁ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଜଦି ମୁଁୟ୍‌ ସେମଃନ୍‌କେ ବୁକେ ଗଃରେ ହଃଟାୟ୍‌ନ୍ଦ୍, ତଃବେ ଜାତାବାଟେ ସେମଃନ୍ ମୁର୍ଚା ଅୟ୍‌ଜାତି, ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ବଃଡେ ଦୁରିକ୍‌ ହୁଣି ଆସି ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ତାର୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଇତି ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣେ କୁୟ୍‌ତି ହୁଣି ରୁଟି ଆଣି ଏମଃନ୍‌କେ ହେଟ୍‌ହୁର୍ନେ କାଉଁକେ ଦେଉଁନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁ ଚେଲାମଃନ୍‌କେ ହଃଚାର୍ଲା, “କଃତିଗଟ୍‌ ରୁଟି ତୁମାର୍‌ ହାକ୍‌ ଆଚେ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସାତ୍‌ଗଟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ମାଟାୟ୍‌ ବଃସୁକେ କୟ୍‌ଲା, ଆରେକ୍‌ ଜିସୁ ସେ ସାତ୍‌ଗଟ୍‌ ରୁଟିକେ ଆତେ ଦଃରି ଇସ୍ୱର୍‌କେ ପାର୍ତ୍‌ନାକଃରି ରୁଟିସଃବୁ କଃଣ୍ଡ୍ କଃଣ୍ଡ୍ କଃରି ଲକ୍‌ମଃନ୍‌କେ ବାଟି ଦିଆସ୍‌ ବଃଲି ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଦିଲା; ଚେଲାମଃନ୍ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ସେରି ବାଟାକଃରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ଚେଲାମଃନାର୍‌ ହାକ୍‌ କଃତିଗଟ୍‌ ସାନ୍‌ ମାଚ୍ ହେଁ ରିିଲି; ସେ ମାଚ୍‌କେ ହେଁ ଦଃରି ଜିସୁ ଆସିର୍ବାଦ୍‌ କଃରି ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦେଉଁକେ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ସଃବୁ ଲକ୍‌ମଃନ୍ ହେଟ୍‌ ହୁର୍ନେ କାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଚେଲାମଃନ୍ ଉବୁର୍ଲାର୍‌ ବାଙ୍ଗ୍‌ଲା ରୁଟି ବେଟି ସାତ୍‌ ଡଃଲା ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","କାୟ୍‌ଲା ଲକ୍‌ମଃନ୍ ହାକାହାକି ଚାରି ଆଜାର୍‌ ଲକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ ସେଲଦିଲା, ଆର୍‌ ସେଦାହ୍ରେ ଜିସୁ ତାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ଦଲ୍‌ମନୁତା ହଲିକେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ତାର୍‌ହଃଚେ ପାରୁସିମଃନ୍ ଆସି ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କଃତା ଦଃରାଦଃରି ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ଜିସୁକେ ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ମଃନ୍‌କଃରି, ଅଃଗାସ୍‌ ଉହ୍ରେ ଗଟେକ୍‌ ଚିନ୍ ମାଗ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ସେତାକ୍‌ ଜିସୁ ଆତ୍ମାୟ୍‌ ବାବି ବଃଡ୍‌ହୁଣ୍ଡାଣ୍ ଚାଡି କୟ୍‌ଲା, “ଅଃବାର୍‌ ଲକ୍‌ମଃନ୍ କାୟ୍‌ତାକ୍‌ ଚିନ୍ ଲଳୁଲାୟ୍‌ ? ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଅଃବାର୍‌ ଲକ୍‌ମଃନ୍‌କେ କାୟ୍‌ ଚିନ୍ ହେଁ ଦିଆ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ତାର୍‌ହଃଚେ ଜିସୁ ପାରୁସିମଃନ୍‌କେ ଚାଡିକଃରି ଆରେକ୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ସଃମ୍‌ନ୍ଦ୍ ସେହାଟି କଃଣ୍ଡାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ସଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ରୁଟି ନେଉଁକେ ହାସୁର୍ଲାୟ୍‌; ଡଙ୍ଗାୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ଅଃକାୟ୍‌ ଗଟେକ୍‌ ମଃତର୍‌ ରୁଟି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଜିସୁ ସେମଃନ୍‌କେ ଚେତାୟ୍‌ ଦଃୟ୍‌କଃରି କୟ୍‌ଲା, “ପାରୁସିମଃନାର୍‌ ଆର୍‌ ହେରଦାର୍‌ କମିର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ସେତାକ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଅଃମାର୍‌ ହାକ୍‌ ରୁଟି ନୟ୍‌ ବଃଲି ଜିସୁ ଇ କଃତା କୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ସେମଃନ୍ କାୟ୍‌ରି କଃତାବାର୍ତା ଅଃଉଁଲାୟ୍‌ ସେରି ଜିସୁ ମଃନ୍‌ବିତ୍ରେ ଜାଣିକଃରି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ତଃୟ୍‌ ରୁଟି ନାୟ୍‌ ବଃଲି ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ କଃତାବାର୍ତା କଃରୁଲାସ୍‌ ? ତୁମିମଃନ୍ କାୟ୍‌ ଅଃବେ ହଃତେକ୍‌ ଜାଣୁ ନଃହାରୁଲାସ୍‌ ? ତୁମିମଃନ୍ କଃଡେକ୍‌ ନିର୍ବୁଦିଆ ? ");
INSERT INTO bdv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ଆକି ରେଉଁ ରେଉଁ କାୟ୍‌ ତୁମିମଃନ୍ ଦଃକୁକ୍‌ ନଃହାରୁଲାସ୍‌ ? ତୁମିମଃନ୍‌କେ କାନ୍‌ ରେଉଁ ରେଉଁ କାୟ୍‌ ସୁଣୁକ୍‌ ନଃହାରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ମୁୟ୍‌ଁ ଜଃଡେବଃଳ୍‌ ହାଁଚ୍ ଆଜାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ବାଙ୍ଗି କାଳାୟ୍‌ ରିଲେ, ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ କଃତି ଡଃଲା ହୁରାକଃରି ଉବୁର୍ଲାର୍‌ ବାଙ୍ଗ୍‌ଲା ରୁଟି ବେଟିରିଲାସ୍‌ ? ସେରି କାୟ୍‌ ଏତୁ ନାୟ୍‌ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ବାର ଡଃଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଜିସୁ କୟ୍‌ଲା, “ଆର୍‌ ସେ ଚାରିଅଃଜାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ମୁଁୟ୍‌ ଜଃଡେବଃଳ୍‌ ସାତ୍‌ଗଟ୍‌ ରୁଟି ବାଙ୍ଗିକଃରି ଦଃୟ୍‌ରିଲେ, ସଃଡେବଃଳ୍‌ କଃତି ଡଃଲା ଉବୁର୍ଲା ବାଙ୍ଗ୍‌ଲା ରୁଟି ବେଟି ରିଲାସ୍‌ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସାତ୍‌ ଡଃଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ରି ଅଃବେ ହଃତେକ୍‌ ବୁଜୁ ନଃହାରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ତାର୍‌ହଃଚେ ସେମଃନ୍ ବେତ୍‌ସାଇଦା ଆୟ୍‌ଲାୟ୍‌ । ସେତି କଃତେକ୍‌ ଲକ୍‌ ଗଟ୍‌ କାଣାକେ ଜିସୁର୍‌ ଲଃଗେ ଆଣି, ତାକ୍‌ ଚିଉଁକ୍‌ ଜିସୁକେ କାନିକଃର୍ମ୍‌ ଅୟ୍‌ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଜିସୁ ସେ କାଣାର୍‌ ଆତେ ଦଃରି ଗାଉଁଏ ହୁଣି ତାକ୍‌ ବାର୍‌କଃରି ନିଲା, ଆର୍‌ ତାର୍‌ ଆକାୟ୍‌ ଲାଳ୍‌ ଲାଗାୟ୍‌ଲା, ଆର୍‌ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ କଃରି ତାକ୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ରି ଦଃକୁ ହାରୁଲିସ୍‌ କି ?” ");
INSERT INTO bdv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ସେ ଦଃକି କୟ୍‌ଲା, “ହେଁ ମୁଁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକୁଲେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ଗଃଚ୍ ହର୍‌ କାୟ୍‌ରି ଅଲେ ଇଣ୍ଡ୍‌ତାର୍‌ ଦଃକୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ତାର୍‌ହଃଚେ ଜିସୁ ଆରେକ୍‌ ସେ କାଣାର୍‌ ଆକାୟ୍‌ ଚୁୟ୍‌ଲା, ତଃବେ ସେ ନିକକଃରି ଦଃକ୍‌ଲା, ଆର୍‌ ସେ କାଣା ନିକ ଅୟ୍‌ ସଃବୁ ବିସୟ୍‌କେ ନିକକଃରି ଦଃକୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ତାର୍‌ହଃଚେ ଜିସୁ ତାକ୍‌ ନିଜାର୍‌ ଗଃରେ ହଃଟାୟ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲା, “ଇ ଗାଉଁ ବିତୁର୍‌କେ ହେଁ ତୁୟ୍‌ ମୁଳ୍‌କେ ଜାନାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଇତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ କାଇସରିଆ ପିଲିପି ହଲିର୍‌ ଗାଉଁମଃନ୍‌କେ ଗଃଲାୟ୍‌, ଜାତାବାଟେ ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମୁୟ୍‌ଁ କେ ବଃଲି ଲକ୍‌ମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ସେମଃନ୍ ତାକ୍‌ ଉତୁର୍‌ ଦିଲାୟ୍‌, “କଃତିଲକ୍‌ କଃଉଁଲାୟ୍‌, ତୁୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌; ଆର୍‌ କଃତିଲକ୍‌ କଃଉଁଲାୟ୍‌, ତୁୟ୍‌ ଏଲିୟ; ମଃତର୍‌ ବିନ୍ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ କଃଉଁଲାୟ୍‌, ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରାର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମଃତର୍‌ ମୁଁୟ୍‌ କେ ବଃଲି ତୁମିମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାସ୍‌ ?” ପିତର୍‌ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, ତୁୟ୍‌ ଇସ୍ୱର୍‌ ବାଚ୍‌ଲା ହାହେ ହୁଣି ମୁକ୍ଳାଉତା କ୍ରିସ୍ଟ । ");
INSERT INTO bdv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ ଚେତାୟ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲା “ମୁଁୟ୍‌ କେ ବଃଲି ତୁମିମଃନ୍ କାକେ ହେଁ କାୟ୍‌ରି କଃଉଆ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଜିସୁ ଚେଲାମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକ୍‌ ଆରୁମ୍‌ କଃଲା, “ନଃରାର୍‌ ହୟ୍‌ସିକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଦୁକ୍‌ କଃସ୍ଟ୍‌ ହାୟ୍‌ଦ୍‌, ଆର୍‌ ପାରାଚିନ୍, ବଃଡ୍ ଜାଜକ୍‌ ମଃନ୍‌, ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ଦୁର୍‌ କଃର୍ତି ଆର୍‌ ମଃର୍ନେ ମାର୍‌ତି, ଆରେକ୍‌ ସେ ତିନି ଦିନାର୍‌ ହଃଚେ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଜିସୁ ଇ ସଃବୁ କଃତା ଚେଲାମଃନ୍‌କେ ହୁଟାୟ୍‌କଃରି କୟ୍‌ଲା, ମଃତର୍‌ ପିତର୍‌ ଜିସୁକେ ଗଟ୍‌ହାକ୍‌ ବିନେ କୁଦି ନଃୟ୍‌ ଦଃକା ଦିଲା, “ଇବାନ୍ୟା ତକେ କଃବେ ହେଁ ନଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ମଃତର୍‌ ଜିସୁ ଉଲ୍‌ଟି କଃରି ନିଜାର୍‌ ଚେଲାମଃନ୍‌କେ ଦଃକି ପିତର୍‌କେ ଦଃକା ଦଃୟ୍‌ କୟ୍‌ଲା, “ମର୍‌ ମୁଏଁ ହୁଣି ଦୁର୍‌ ଅଃଉ ସୟ୍‌ତାନ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ବିସୟ୍‌ ନଃବାବି, ଲକ୍‌ମଃନାର୍‌ ବିସୟ୍‌ ବାବୁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ତାର୍‌ହଃଚେ ଜିସୁ ତାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଲକ୍‌ମଃନ୍‌କେ ତାର୍‌ ଲଃଗେ କୁଦି କୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ହଃଚେ ଆସୁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଚାଡି ଅଃହ୍‌ଣାର୍‌ କ୍ରୁସ୍‌ ବୟ୍‌କଃରି ମର୍‌ ହଃଚେ ଆସ । ");
INSERT INTO bdv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ନିଜାର୍‌ ଜିବନ୍ ବଚାଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ଜିବନ୍ ହାରାୟ୍‌ଦ୍‌; ମଃତର୍‌ ଜୁୟ୍‌ଲକ୍‌ ମର୍‌ ଗିନେ ଆର୍‌ ମର୍‌ ନିକ କବୁର୍‌ ଗିନେ ନିଜାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍‌କେ ସଃବୁ ଦିନ୍ ଗିନେ ରଃକ୍ୟା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଜଦି ଗଟ୍‌ଲକ୍‌ ଜଃଗତାର୍‌ ସଃବୁ ଲାବ୍‌କଃରି ନିଜାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ତାର୍‌ କାୟ୍‌ ଲାବ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଆର୍‌ ମାନାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ବାଦୁଲେ କାୟ୍‌ରି ଦେଉଁ ହାରେ ? ");
INSERT INTO bdv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଜଦି କୁୟ୍‌ଲକ୍‌ ଇ କାଳାର୍‌ ହାହିମଃନାର୍‌ ଆର୍‌ ଦୁସ୍ଟ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ମର୍‌ ଆର୍‌ ମର୍‌ ବଃଚନ୍ ଗିନେ ଲାଜ୍‌ ଅୟ୍‌ଦ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ଜଃଡେବଃଳ୍‌ ପବିତ୍ର ଦୁତ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଅଃହ୍‌ଣାର୍‌ ଉବାସିର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଆସେଦ୍‌, ସଃଡେବଃଳ୍‌ ସେ ହେଁ ତାର୍‌ ବିସୟେ ଲାଜ୍‌ ହାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଜିସୁ ସେମଃନ୍‌କେ ଆରେକ୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌କେ ସଃକ୍ତି ସଃଙ୍ଗ୍ ନାସ୍ତା ହଃତେକ୍‌ ଇତି ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ କଃନ୍‌କଃରି ହେଁ ନଃମେର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଚଅ ଦିନ୍ ଗଃଲା ହଃଚେ, ଜିସୁ ପିତର୍‌, ଜାକୁବକ୍‌ ଆର୍‌ ଜହନ୍‌କେ ସଃଙ୍ଗେ ଦଃରି ଗଟେକ୍‌ ବଃଡ୍ ଉଚ୍ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ କୁଦି ନିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଆର୍‌ ତାକାର୍‌ ମୁଏଁ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଗଃଗାଳାର୍‌ ରୁହ୍‌ ବାଦ୍‌ଲାୟ୍‌ଲା, ତାର୍‌ ବଃସ୍ତର୍‌ ଇବାନ୍ୟା ଉଜାଳ୍‌ ଆର୍‌ ଚିଟ୍‌ ଦବ୍‌ ଅୟ୍‌ଲି, ହୁର୍ତିବିର୍‌ କୁୟ୍‌ ଦବା ହେଁ ସେବାନ୍ୟା କଃରି ଆକାଳୁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ସଃଡେବଃଳ୍‌ ମସା ଆର୍‌ ଏଲିୟ ସଃଙ୍ଗ୍ ଜିସୁ କଃତାବାର୍ତା ଅଃଉତି ରିଲାର୍‌ ସେମଃନ୍ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ତାର୍‌ହଃଚେ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ଇଟାଣେ ଆଚୁ ଇରି ବଃଲ୍‌ କଃତା; ଅଃମିମଃନ୍‌ ତିନିଗଟ୍‌ କୁଳିଆ ବାନ୍ଦୁନ୍ଦ୍, ଗଟେକ୍‌ ତର୍‌ ଗିନେ, ଗଟେକ୍‌ ମସାର୍‌ ଗିନେ ଆରେକ୍‌ ଗଟେକ୍‌ ଏଲିୟର୍‌ ଗିନେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ପିତର୍‌ ଜିସୁକେ କାୟ୍‌ କଃତା କୟ୍‌ନ୍ଦ୍ ବଃଲି ଜାଣି ନଃରିଲା, ଆର୍‌ ସଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ବେସି ଡିରି ଜାୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଆରେକ୍‌ ସଃଡେବଃଳ୍‌ କଃଣ୍ଡେକ୍‌ ମେଗ୍ ଆୟ୍‌ଲି ଆର୍‌ ତାକାର୍‌ ଉହ୍ରେ ଡାହି ଅୟ୍‌ଲି, ଆର୍‌ ସେ ମେଗ୍ ବିତ୍ରେହୁଣି ଗଟେକ୍‌ ସଃବଦ୍‌ ସୁଣ୍‌ଲାୟ୍‌, “ଇରି ମର୍‌ ଲାଡାର୍‌ ହଅ, ତାର୍‌ କଃତା ସୁଣା ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଚାରିହାକ୍‌ ଦଃକ୍‌ଲାୟ୍‌, ମଃତର୍‌ ତାକାର୍‌ ସଃଙ୍ଗ୍ ଜିସୁକେ ଚାଡି କାକେ ହେଁ ନଃଦେକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ସେମଃନ୍ ଡଙ୍ଗ୍ରେହୁଣି ଉତ୍ରି ଆସ୍ତାବଃଳ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ନିକ କଃରି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜୁୟ୍‌ରି ସଃବୁ ଦଃକି ଆଚାସ୍‌, ସେରି ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ନଃରାର୍‌ ହୟ୍‌ସି ନୁଟ୍‌ତା ହଃତେକ୍‌ ଇ କଃତା କାକେ ହେଁ କଃଉଆ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା କଃତାକ୍‌ ଦଃରି ସେମଃନ୍ କଃତାବାର୍ତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ମଃରିକଃରି ଆରେକ୍‌ ଉଟ୍‌ତାର୍‌ କାୟ୍‌ରି ?” ");
INSERT INTO bdv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଏଲିୟ ନିଜ୍‌କଃରି ହଃର୍ତୁ ଆସେଦ୍‌ ବଃଲି ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ଇ କଃତା କାୟ୍‌ତାକ୍‌ କଃଉଁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏଲିୟ ଆସିକଃରି ସଃବୁ କଃତା ଟିକ୍‌ଟାକ୍‌ କଃର୍ତା କଃତା ସଃତ୍‌, ତଃବେ ନଃରାର୍‌ ହୟ୍‌ସି ସଃବୁ ଦୁକ୍‌ କଃସ୍ଟ୍‌ ହାୟ୍‌ଦ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ଲିନ୍ଦା କଃର୍ତି ବଃଲି କାୟ୍‌ତାକ୍‌ ତାର୍‌ କଃତା ଲେକା ଅୟ୍‌ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଏଲିୟ ବାବ୍‌ବାଦି ଆସି ସଃର୍ଲାନି, ଆର୍‌ ତାର୍‌ କଃତା ଜାୟ୍‌ରି ସାସ୍ତରେ ଲେକା ଆଚେ, ସେବାନ୍ୟା ଲକ୍‌ମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ଜାୟ୍‌ରି ମଃନ୍ କଃଲାୟ୍‌ ସେରି କଃଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଇତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ବିନ୍ ଚେଲାମଃନ୍ ତାର୍‌ ଚେଲାମଃନାର୍‌ ଚଃମେ ଆସି ଦଃକ୍‌ଲାୟ୍‌ ଜେ, ତାକାର୍‌ ଚାରିବେଳ୍‌ତ୍ ଲକ୍‌ମଃନ୍ ରୁଣ୍ଡି ଆଚ୍‌ତି ଆର୍‌ କଃତିଗଟ୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ତାକାର୍‌ ସଃଙ୍ଗ୍ କଃତା ଦଃରାଦଃରି ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ଆର୍‌ ସଃଡେବଃଳ୍‌ ସେ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃକ୍‌ଲା ଦାହ୍ରେ କାବା ଅୟ୍‌ଗଃଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ ଲଃଗେ ଦଃବ୍‌ଳି ଆସି ତାକ୍‌ ଜୁଆର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ହଃଚାର୍ଲା, “କାୟ୍‌ତାର୍‌ ଗିନେ ତୁମିମଃନ୍ ସେ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତାୟ୍‌ ଦଃରାଦଃରି ଅଃଉତି ରିଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ସେ ଲକ୍‌ ମଃନ୍ଦାର୍‌ ବିତ୍ରେହୁଣି ଗଟେକ୍‌ ମାନାୟ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ମର୍‌ ହଅକେ ଗୁଲା ବୁତ୍‌ ଦଃରିଆଚେ, ଆର୍‌ ସେ ଟଣ୍ଡ୍ ଅଃଉଁକେ ନଃହାରୁଲା ଲାଗି ମୁଁୟ୍‌ ତାକ୍‌ ତର୍‌ ଲଃଗେ ଆଣି ରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ତାକ୍‌ ଜୁୟ୍‌ତି ବୁତ୍‌ ଦଃରେଦ୍‌, ତାକ୍‌ ତଃଳେ ଅଦ୍ରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ଆର୍‌ ତାର୍‌ ଟଣ୍ଡେହୁଣି ହେହୁଲ୍‌ ବାର୍‌ କଃରେଦ୍‌ ଆର୍‌ ସେ ଦାତ୍‌ କିଟ୍‌କିଟ୍‌ କଃରେଦ୍‌, ସେ ସୁକି ଜଃଉଁଲା । ସେ ବୁତ୍‌ ଚାଡାଉଁକେ ମୁଁୟ୍‌ ତର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲେ, ମଃତର୍‌ ସେମଃନ୍ ଚାଡାଉଁ ନାହାର୍ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ଅବିସ୍ୱାସି ଜାତି, ମୁଁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ କଃତେକ୍‌ ଦିନ୍ ରଃୟ୍‌ନ୍ଦ୍, ମୁଁୟ୍‌ ତୁମାର୍‌ କାମ୍‌ ଦଃକି କଃତେକ୍‌ କାଳ୍‌ ସଃମ୍ବାଳିନ୍ଦ୍; ସେ ହିଲାକ୍‌ ମର୍‌ ଲଃଗେ ଆଣା !” ");
INSERT INTO bdv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ସେ ହିଲାକ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆଣ୍‌ଲାୟ୍‌ । ତାକ୍‌ ଡଃସିରିଲା ବୁତ୍‌ ଜିସୁକେ ଦଃକିକଃରି ସେ ହିଲାକ୍‌ ବୟ୍‌ଙ୍କାର୍‌ ବାବେ ମଳିକଃରି ମାଟାୟ୍‌ ଅଦ୍ରାୟ୍‌ଲି ଆର୍‌ ତାର୍‌ ମୁଏଁ ହେହୁଲ୍‌ ତୁମା ବାର୍‌କଃରି ସେ ହିଲା ଡୁଳ୍‌ଗୁଣ୍ଡୁଳ୍‌ ଅଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ଜିସୁ ସେ ହିଲାର୍‌ ଉବାସିକ୍‌ ହଃଚାର୍ଲା, “ଇ ହିଲାକ୍‌ କଃବେ ହୁଣି ଇବାନ୍ୟା ଅଃଉଁଲି ?” ଉବାସି କୟ୍‌ଲା, “ହିଲାବଃଳ୍‌ ହୁଣି; ");
INSERT INTO bdv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ଇ ବୁତ୍‌ ହିଲାକ୍‌ ମଃରାଉଁକେ କଃତିତର୍‌ ଜୟ୍‌ ଲଃଗେ ଆର୍‌ କଃତିତର୍‌ ହାଣି ଲଃଗେ ଅଦ୍ରାୟ୍‌ ଆଚେ, ମଃତର୍‌ ତୁୟ୍‌ ଜଦି ବଃଲ୍‌ କଃରୁ ହାର୍ସି, ତଃବେ ଅଃମାର୍‌ ଉହ୍ରେ ଦଃର୍ମ୍‌ କଃର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “କାୟ୍‌ରି କଃଉଁଲିସ୍‌ ? ଜଦି କଃରୁ ହାର୍ସି ! ବିସ୍ୱାସ୍‌ କଃର୍ତା ଲକାର୍‌ ଗିନେ ସଃବୁ ଅଃଉଁ ହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ସେ ହିଲାର୍‌ ଉବାସି ସେଦାହ୍ରେ ଟଣ୍ଡ୍ ହୁଟାୟ୍‌କଃରି କୟ୍‌ଲା, “ହେଁ, ମୁଁୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲେ, ମକ୍‌ ବିସ୍ୱାସ୍‌ ତଃୟ୍‌ ବାଡୁକେ ଉହ୍‌କାର୍‌ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ଜିସୁ ହାକ୍‌ ଲକ୍‌ମଃନ୍ ଦଃବ୍‌ଳି ଆସ୍ତିରିଲାର୍‌ ଦଃକି, ଜିସୁ ସେ ବିଟାଳ୍‌ ଆତ୍ମାକେ ଦଃମ୍‌କାୟ୍‌କଃରି କୟ୍‌ଲା, “ଏ ଗୁଲା ଆର୍‌ ବଃୟ୍‌ରା ବୁତ୍‌, ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ, ଇ ହିଲାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଜାଆ, ଆର୍‌ କଃବେ ହେଁ ଇ ହିଲାର୍‌ ବିତ୍ରେ ହୁର୍ନାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ତାର୍‌ହଃଚେ ସେ ବୁତ୍‌ କିର୍‌କିରି କଃରି ସେହିଲାକ୍‌ ଜଃବର୍‌କଃରି ମଳିହଃକାୟ୍‌ ତାର୍‌ ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ଗଃଲି, ଆର୍‌ ସେ ହିଲା ମଃଲା ହର୍‌ ଅୟ୍‌ଲା ଲାଗି ଲକ୍‌ମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ସେ ତ ମଃରିଗଃଲା !” ");
INSERT INTO bdv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ ଆତେ ଦଃରି ଉଟାୟ୍‌ଲା, ଆର୍‌ ସେ ହିଲା ଉଟିକଃରି ଟିଆ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଜିସୁ ଜଃଡେବଃଳ୍‌ ଗଃରେ ଆୟ୍‌ଲା, ତାର୍‌ ଚେଲାମଃନ୍ ଲୁକ୍‌ଣେ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “କାୟ୍‌ତାର୍‌ ଗିନେ ଅଃମି ତାକ୍‌ ଚାଡାଉଁ ନଃହାର୍ଲୁ ?” ");
INSERT INTO bdv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ଇବାନ୍ୟା ବୁତ୍‌ମଃନ୍‌କେ ପାର୍ତ୍‌ନାୟ୍‌ ଚାଡି ଆରେକ୍‌ କୁୟ୍‌ତି ହେଁ ଚାଡାଉଁକ୍‌ ହାରି ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ସେଟାଣ୍ ଚାଡି ଗାଲିଲି ବାଟ ଅୟ୍‌ ଗଃଳାୟ୍‌ । ସେ ରେତା ଜଃଗାୟ୍‌ କେ ହେଁ ନଃଜାଣତ୍‌ ବଃଲି ଜିସୁ ମଃନ୍ କଃର୍ତିରିଲା, ");
INSERT INTO bdv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ ସିକ୍ୟା ଦେତିରିଲା, “ନଃରାର୍‌ ହୟ୍‌ସି ନଃର୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେମଃନ୍ ତାକ୍‌ ମଃର୍ନେ ମାର୍ତି, ଆର୍‌ ସେ ମଃରି ତିନିଦିନ୍ ଅୟ୍‌ଲା ହଃଚେ, ଆରେକ୍‌ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ମଃତର୍‌ ସେମଃନ୍ ଇ କଃତା ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁକେ ହଃଚାରୁକ୍‌ ଡିର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ଚେଲାମଃନ୍ କପୁର୍ନାହୁମ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଜିସୁ ଗଃରେ ହଚି ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ ବାଟେ ରିଲାବଃଳ୍‌ କାୟ୍‌ବଃଲି କଃତାବାର୍ତା ଅଃଉତି ରିଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମଃତର୍‌ ସେମଃନ୍ ତୁନ୍‌ହାଳି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ବାଟେ ରିଲାବଃଳ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କେ ବଃଡ୍ ବଃଲି କଃତାବାର୍ତା ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଜିସୁ ବଃସ୍‌ଲା ଆର୍‌ ତାର୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ କୁଦିକଃରି କୟ୍‌ଲା, “ଜୁୟ୍‌ ମାନାୟ୍‌ ସଃବ୍‌କେ ବଃଡ୍ ଅଃଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ମାନାୟ୍‌ ସଃବ୍‌କେ ସାନ୍ ଅଃଉଅ ଆର୍‌ ସଃବ୍‌କାର୍‌ ସେବାକାରି ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ତାର୍‌ହଃଚେ ଜିସୁ ଗଟେକ୍‌ ସାନ୍‌ ହିଲାକ୍‌ ଦଃରିକଃରି ସଃବୁ ଲକାର୍‌ ମଃଜାୟ୍‌ ଟିଆକଃଲା ଆର୍‌ ସେ ହିଲାକ୍‌ କଳେ ଦଃରି ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ନାଉଁଏ ଇବାନ୍ୟା ସାନ୍ ହିଲାକ୍‌ ଦଃରେଦ୍‌, ସେମାନାୟ୍‌ ମକ୍‌ ଦଃରେଦ୍‌, ଜୁୟ୍‌ ମାନାୟ୍‌ ମକ୍‌ ଦଃରେଦ୍‌ ସେ ମାନାୟ୍‌ ମକ୍‌ ନଃଦେରେ, ମଃତର୍‌ ସେ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବାକ୍‌ ଦଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜହନ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଗଟ୍‌ଲକ୍‌ ତର୍‌ ନାଉଁଏ ବୁତ୍‌ ଚାଡାଉତାର୍‌ ଦଃକ୍‌ଲୁ, ଆର୍‌ ସେ ଅଃମାର୍‌ ଦଃଳାର୍‌ ଲକ୍‌ ନଃରିଲା ଲାଗି ଅଃମି ତାକ୍‌ ମଃନା କଃଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ତାକ୍‌ ମଃନା କଃରା ନାୟ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇବାନ୍ୟା କୁୟ୍‌ ମାନାୟ୍‌ ନାୟ୍‌, ଜେ କି ମର୍‌ ନାଉଁ ଦଃରି କାବା ଅଃଉତା କାମ୍‌ କଃରେଦ୍‌ ଆର୍‌ ସେଦାହ୍ରେ ମକ୍‌ ଲିନ୍ଦା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌, ଜୁୟ୍‌ ଲକ୍‌ ଅଃମାର୍‌ ବିରଦେ ନାୟ୍‌, ସେ ଅଃମାର୍‌ ଦଃଳାର୍‌ ଲକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ତୁମିମଃନ୍‌କେ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ଲକ୍‌ ବଃଲି ମର୍‌ ନାଉଁଏ ଗଟେକ୍‌ ଗିନା ହାଣି କାଉଁକେ ଦଃୟ୍‌ଦ୍‌ ସେ ଲକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ତାର୍‌ ପୁରିସ୍କାର୍‌ କଃବେ ଆରାୟ୍‌ ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଜିସୁ ଆରେକ୍‌ କଃଉଁକେ ଦଃର୍ଲା, “ଆର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ମର୍‌ ଲଃଗେ ବିସ୍ୱାସ୍‌ କଃର୍ତା ଲକ୍‌କେ ବାଦା ଦଃୟ୍‌ଦ୍‌ ସେମାନାୟ୍‌କେ ଗଃଳାୟ୍‌ ଗଟେକ୍‌ ବଃଡ୍ ମଃଗ୍‌ନି ଜଃତା ଟେଳା ବାନ୍ଦିକଃରି ତାକ୍‌ ସଃମ୍‌ନ୍ଦେ ହଃକାୟ୍‌ଲେକ୍‌ ବଃଲ୍‌ ଅୟ୍‌ଲି ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଆର୍‌ ତୁମାର୍‌ ଗଟେକ୍‌ ଆତାର୍‌ ଗିନେ ତୁମି ହାହ୍‌ କାମ୍‌ କଃରୁଲାସ୍‌, ତଃବେ ତୁମି ସେ ଆତ୍‌କେ କାଟି ହଃବ୍ଳାଉଆ; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଳେକ୍‌ ଆତ୍‌ ରଃୟ୍‌କଃରି ନଃର୍କେ, ବଃଲେକ୍‌ କଃବେ ନଃଲିବ୍‌ତା ଜୟେ ହଃଳ୍‌ତା ବାଦୁଲେ, ଗଟେକ୍‌ ଆତ୍‌ ରଃୟ୍‌କଃରି ଜିବନେ ଜାତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ । ");
INSERT INTO bdv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃର୍କେ ଜୁୟ୍‌ କିଳାମଃନ୍ ଆଚ୍‌ତି, ସେ କିଳାମଃନ୍ କଃବେ ନଃମେର୍ତି, ଆର୍‌ ଜୁୟ୍‌ ଜୟ୍‌ ଲାଗ୍‌ତି ରଃୟ୍‌ଦ୍‌, ସେ ଜୟ୍‌ କଃବେ ନଃଲିବେ । ");
INSERT INTO bdv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଆର୍‌ ତୁମାର୍‌ ଗଟେକ୍‌ ଗଡାର୍‌ ଗିନେ ହାହ୍‌ କାମ୍‌ କଃରୁଲାସ୍‌, ତଃବେ ତୁମି ସେ ଗଡ୍‌କେ କାଟି ହଃବ୍ଳାଉଆ; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଳେକ୍‌ ଗଡ୍ ଦଃରିକଃରି ନଃର୍କେ ଜାତା ବାଟା, ଗଟେକ୍‌ ଗଡ୍ ଦଃରିକଃରି ଜିବନେ ଜାତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ । ");
INSERT INTO bdv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃର୍କେ ଜୁୟ୍‌ କିଳାମଃନ୍ ଆଚ୍‌ତି, ସେ କିଳାମଃନ୍ କଃବେ ନଃମେର୍ତି, ଆର୍‌ ଜୁୟ୍‌ ଜୟ୍‌ ଲାଗ୍‌ତି ରଃୟ୍‌ଦ୍‌, ସେ ଜୟ୍‌ କଃବେ ନଃଲିବେ । ");
INSERT INTO bdv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଆର୍‌ ତୁମାର୍‌ ଆକି ଜଦି ହାହ୍‌ କଃରାଉଁଲି ତଃବେ ସେରି କାଡି ହଃକାଉଆ ଜଳେକ୍‌ ଆକି ରଃୟ୍‌ ନଃର୍କେ ଜାତା ବାଦୁଲେ ଗଟେକ୍‌ ଆକି ନଃୟ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜାତାର୍‌ ନିକ । ");
INSERT INTO bdv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃର୍କେ ଜୁୟ୍‌ କିଳାମଃନ୍ ଆଚ୍‌ତି, ସେ କିଳାମଃନ୍ କଃବେ ନଃମେର୍ତି, ଆର୍‌ ଜୁୟ୍‌ ଜୟ୍‌ ଲାଗ୍‌ତି ରଃୟ୍‌ଦ୍‌, ସେ ଜୟ୍‌ କଃବେ ନଃଲିବେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ନଣ୍ ସଃଙ୍ଗ୍ ଜଃନ୍‌କଃରି ହୁଜା ଦେତାର୍‌ ନିର୍ମୁଳ୍‌ ଅୟ୍‌ଦ୍‌, ହଃତି ଲକ୍‌ ସେବାନ୍ୟା ଜୟ୍‌ ସଃଙ୍ଗ୍ ନିର୍ମୁଳ୍‌ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ନଣ୍ ବଃଡେ ନିକ, ମଃତର୍‌ ନଣ୍ ଜଦି ଅଃଲଣା ଅୟ୍‌ଦ୍‌, ତଃବେ ତାକ୍‌ କଃନ୍‌କଃରି ଆରେକ୍‌ ସୁଆଦ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ?” “ତୁମିମଃନ୍ ନଣ୍ ହର୍‌ ନିକ ଗୁଣ୍ ଦଃରି ରିଆ, ଆର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ମିସିବିଳିକଃରି ସୁସ୍ତାୟ୍‌ ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଜିସୁ ସେ ଟାଣ୍ ଚାଡି ଜିଉଦା ସଃନ୍ଦାୟ୍‌ ଆର୍‌ ଜର୍ଦନ୍ ଗାଡ୍ ସେହାଟି ଆୟ୍‌ଲା, ଆର୍‌ ଅଲେକାର୍‌ ଲକ୍‌ ତାର୍‌ ଚଃମେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌, ସଃବୁ ବଃଳାର୍‌ ହର୍‌ ଜିସୁ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଇବିତ୍ରେ କଃତିଗଟ୍‌ ପାରୁସିମଃନ୍ ଜିସୁକେ ହଃଚାରି ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ଆସି କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ କଃଉ, ଗଟ୍‌ ଅଃଣ୍ଡ୍ରା ତାର୍‌ ଡକୁର୍ସିକେ ଚାଡ୍‌ତାର୍‌ କାୟ୍‌ ବିଦି ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମସା କାୟ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଚାଡ୍‌ହଃତାର୍‌ ଲେକି ଦଃୟ୍‌ ମାୟ୍‌ଜି ଚାଡୁକ୍‌ ମସା ବିଦି ଦିଲାଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ଅଃଟୁଆ ମଃନ୍ ଦଃକି ମସା ତୁମାର୍‌ ଗିନେ ଇ ସଃବୁ ଆଦେସ୍‌ ଲେକି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ମଃତର୍‌ ହୁର୍ତିବିର୍‌ ଉବ୍‌ଜାଣାର୍‌ ତଃୟ୍‌ହୁଣି ଇସ୍ୱର୍‌ ସେମଃନ୍‌କେ ଅଃଣ୍ଡ୍ରା ଆର୍‌ ଟକିକଃରି ହାଜ୍‌ଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ଇତାର୍‌ ଗିନେ ଗଟ୍‌ ମାନାୟ୍‌ ଆୟ୍‌ସି ଉବାସିକ୍‌ ଚାଡି ଦୁୟ୍‌ଲକ୍‌ ଗଟେକ୍‌ ଗଃଗାଳ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ଇତାକ୍‌ ସେମଃନ୍ ଆର୍‌ ଜଳେକ୍‌ ଗଃଗାଳ୍‌ ନୟ୍‌, ମଃତର୍‌ ଗଟେକ୍‌ ଗଃଗାଳ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଇସ୍ୱର୍‌ ଜାୟ୍‌ରି ମିସାୟ୍‌ ଆଚେ, ମାନାୟ୍‌ ସେରି ବିନ୍‌ବିନ୍‌ ନଃକେର ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଗଃରେ ଗଃଲା ହଃଚେ ଚେଲାମଃନ୍ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଆର୍‌ ବାବ୍‌ ହଃଚାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ମାନାୟ୍‌ ତାର୍‌ ନିଜାର୍‌ ଡକୁର୍ସିକେ ଚାଡି ଗଟ୍‌ ବିନ୍‌ ମାୟ୍‌ଜିକେ ସଃଙ୍ଗାୟ୍‌ଦ୍‌, ତଃବେ ତାର୍‌ ଡକୁର୍ସିର୍‌ ବିରଦେ ଦାରି କାମ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଆର୍‌ ଜଦି ଗଟ୍‌ ଲକାର୍‌ ଡକୁର୍ସି, ନିଜାର୍‌ ଅଃଣ୍ଡ୍ରାକେ ଚାଡି ବିନ୍ ଅଃଣ୍ଡ୍ରାକେ ଗଃର୍‌ କଃରେଦ୍‌ ତଃବେ ସେ ଦାରିକାମ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଜିସୁ ଜଃନ୍‌କଃରି ସାନ୍‌ସାନ୍‌ ହିଲାମଃନ୍‌କେ ଚୁୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ଲକ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ଜିସୁର୍‌ ତଃୟ୍‌ ଆଣୁକେ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଦଃକାଦେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଜିସୁ ସେରି ଦଃକି ରିସା ଅୟ୍‌, ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ସାନ୍ ହିଲାମଃନ୍‌କେ ମର୍‌ ଲଃଗେ ଆସୁକ୍‌ ଆଗଟା ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଇବାନ୍ୟା ଲକ୍‌ମଃନାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ଇସ୍ୱର୍‌ ରାଇଜ୍‌କେ ଇ ସାନ୍ ହିଲା ହର୍‌ ନଃଦେର୍‌ଲେକ୍‌, ସେ କଃନ୍‌କଃରି ହେଁ ଇସ୍ୱରାର୍‌ ରାଇଜେ ହୁରୁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ତାର୍‌ହଃଚେ ଜିସୁ ସାନ୍ ସାନ୍ ହିଲାମଃନ୍‌କେ କଳେଦଃରି ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ଆସିର୍ବାଦ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ବାରାୟ୍‌ ଜଃଉଁକେ ବାଟ୍‌ ଦର୍ଲାବଃଳ୍‌, ଗଟ୍‌ ମାନାୟ୍‌ ଦଃବ୍‌ଳି ଦଃବ୍‌ଳି ଆସି ତାର୍‌ ମୁଏଁ ମାଣ୍ଡିକୁଟା ଟେସି ହଃଚାର୍ଲା, “ଏ ସଃତ୍‌ ଗୁରୁ, ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉଁକ୍‌ ମୁଁୟ୍‌ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ତୁୟ୍‌ ମକ୍‌ କାୟ୍‌ତାକ୍‌ ସଃତ୍‌ ବଃଲି କଃଉଁଲିସ୍‌ ? ଇସ୍ୱର୍‌କେ ଚାଡିକଃରି କେହେଁ ସଃତ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ତୁୟ୍‌ ମାପ୍ରୁର୍‌ ବିଦି ଜାଣି ଆଚ୍‌ସି, ‘ନଃର୍‌ ଅଃତ୍ୟା କଃରାନାୟ୍‌, ଦାରିକାମ୍‌ କଃରାନାୟ୍‌, ଚର୍‌ କାମ୍‌ କଃରାନାୟ୍‌, ମିଚ୍‌ସାକି ଦିଆସ୍‌ ନାୟ୍‌, ଟକା ନାୟ୍‌, ନିଜାର୍‌ ଆୟା ଉବାକ୍‌ ମାନ୍‌ତି କଃରା ।’” ");
INSERT INTO bdv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ଜିସୁକେ ସେମାନାୟ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ମୁଁୟ୍‌ ତ ହିଲାବଃଳ୍‌ହୁଣି ଇସଃବୁ ଆଦେସ୍‌ ମାନି ଆସୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ତାକ୍‌ ମୁଏଁ ଦଃକି ଲାଡ୍‌ କଃଲା ଆର୍‌ କୟ୍‌ଲା, “ତର୍‌ ଅଃବେ ହେଁ ଗଟ୍‌ ବିସୟ୍‌ ଉଣାଆଚେ, ତୁୟ୍‌ ଜାଆ, ତର୍‌ ନିଜାର୍‌ ଜାୟ୍‌ରି ଆଚେ, ସେରିମଃନ୍‌ ବିକିକଃରି ଗଃରିବ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦେସ୍‌, ଆର୍‌ ତୁୟ୍‌ ସଃର୍ଗେ ଦଃନ୍ ହାଉସି; ଆର୍‌ ମର୍‌ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଜଃଡେବଃଳ୍‌ ସେମାନାୟ୍‌ ଇରି ସୁଣ୍‌ଲା, ତାର୍‌ ମୁଉଁ ସୁକିଗଃଲି ଆର୍‌ ସେ ମଃନ୍ଦୁକ୍‌ ଅୟ୍‌ ବାରାୟ୍‌ଗଃଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମାନାୟ୍‌ର୍‌ ଅଲେକାର୍‌ ଦଃନ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ସେତାକ୍‌ ଜିସୁ ଚାରିହାକ୍‌ ଦଃକି ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ଲକାର୍‌ ଦଃନ୍ ଆଚେ, ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜଃଉଁକେ ବଃଡେ ହାବଳ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଜିସୁର୍‌ କଃତାସୁଣି ଚେଲାମଃନ୍ ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌ । ମଃତର୍‌ ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ କୟ୍‌ଲା, “ହିଲାମଃନ୍‌ ସୁଣା, ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜଃଉଁକେ ବଃଡେ ହାବଳ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଇସ୍ୱରାର୍‌ ରାଇଜେ ଗଟ୍‌ ମାଜନ୍‌ ଲକ୍‌ ଜାତା ବାଟା, ସୁତ୍‌ଲିର୍‌ କାଣାବାଟ୍‌ ଅୟ୍‌ ଉଟ୍‌ ଚିଙ୍ଗୁଳ୍‌ତାର୍‌ ଉହାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ଚେଲାମଃନ୍ ଆରେକ୍‌ ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଇବାନ୍ୟା ଅଲେ କୁୟ୍‌ ମାନାୟ୍‌ ମୁକ୍ତି ହାଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ଚେଲାମଃନ୍‌କେ ଦଃକି କୟ୍‌ଲା, “ଇରି ମାନାୟ୍‌ର୍‌ ଗିନେ ହାବଳ୍‌, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଗିନେ ନୟ୍‌ । ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ସଃବୁ ଉସାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଦଃକ୍‌ ତର୍‌ ଚେଲା ଅଃଉଁକେ ଅଃମିମଃନ୍‌ ସଃବୁ ଚାଡି ତର୍‌ ହଃଚେ ଆୟ୍‌ଲୁ ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା “ମୁଁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, କୁୟ୍‌ ମାନାୟ୍‌ ମର୍‌ ଗିନେ ଆର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃର୍ତା ଗିନେ ଗଃର୍‌, ବାୟ୍‌, ବେଣି କି ଆୟା ଉବା, ହିଲାମଃନ୍‌ କି ବୁୟ୍‌ଁ ଚାଡି ଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଆର୍‌ ଇ ହୁରେ ତାଡ୍‌ନା ସଃଙ୍ଗ୍ ସଏ ଗୁଣ୍ ଗଃର୍‌, ବାୟ୍‌, ବେଣି, ଆୟା, ହିଲାମଃନ୍‌ ଆର୍‌ ବୁୟ୍‌ଁବାଳା, ଆରେକ୍‌ ସେ ଜୁଗେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ନାହାୟ୍‌, ଅଃନ୍‌କା ଲକ୍‌ କେ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ମଃତର୍‌ ହଃର୍ତୁ ରିଲା ଗାଦେକ୍‌ ଲକ୍‌ ହଃଚେ ଅଃଉତି, ଆର୍‌ ହଃଚେ ରିଲା ଗାଦେକ୍‌ ଲକ୍‌ ହଃର୍ତୁ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଚେଲାମଃନ୍ ଜିରୁସାଲମେ ଜାତିରିଲାବଃଳ୍‌, ବାଟେ ରିଲାୟ୍‌ ଆର୍‌ ଜିସୁ ସେମଃନାର୍‌ ଆଗେ ଆଗେ ଜାତିରିଲା, ସେମଃନ୍ କାବା ଅଃଉତି ରିଲାୟ୍‌, ଆର୍‌ ହଃଚେ ଜାତା ଲକ୍‌ମଃନ୍ ହେଁ ଡିରି ଜାୟ୍‌ ରିଲାୟ୍‌ । ଇତାକ୍‌ ସେ ଆରେକ୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଅଃଲ୍‌ଗା କଃରି, ତାକ୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ଗଃଟୁକ୍‌ ଜଃଉଁଲି, ସେରି ସଃବୁ ସେମଃନ୍‌କେ ଜାଣାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସୁଣା, ଅଃମିମଃନ୍‌ ଜିରୁସାଲମେ ଜଃଉଁଲୁ, ନଃରାର୍‌ ହୟ୍‌ସି, ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅୟ୍‌ଦ୍‌ । ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ଦସିକଃରି ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌, ଅଜିଉଦି ଲକାର୍‌ ଆତେ ସଃହ୍ରି ଦେତି । ସେମଃନ୍ ତାକ୍‌ ବିଚାର୍‌ କଃର୍ତି ଆର୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ଦେତି । ");
INSERT INTO bdv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ଆରେକ୍‌ ସେ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ଟାହ୍ରା କଃର୍ତି, ତାର୍‌ ଉହ୍ରେ ଲାଳ୍‌ ତୁକ୍‌ତି, କର୍ଡା ସଃଙ୍ଗ୍ ମାର୍ତି ଆର୍‌ ମଃର୍ନେ ମାର୍ତି, ଆର୍‌ ସେ ତିନିଦିନାର୍‌ ହଃଚେ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଜେବଦିର୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌ ଆର୍‌ ଜହନ୍‌ ଜିସୁ ହାକ୍‌ ଆସି କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ତକେ ଜାୟ୍‌ରି ମାଗୁନ୍ଦ୍, ସେରି ଅଃମାର୍‌ ଗିନେ କଃର୍‌ ବଃଲି ଅଃମାର୍‌ ଇଚା ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ସେତାର୍‌ଗିନେ ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମୁଁୟ୍‌ ତୁମାର୍‌ ଗିନେ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ବଃଲି ମଃନ୍ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ସେମଃନ୍ ଜିସୁକେ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ଜଃଡେବଃଳ୍‌ ତୁୟ୍‌ ତର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଗାଦି ଉହ୍ରେ ବଃସ୍‌ଲେକ୍‌, ଅଃମିକ୍‌ ଏକ୍ଲାକେ କାତାବାଟ୍ୟା, ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌କେ ଡେବ୍ରିବାଟ୍ୟା ବଃସୁକେ ଇ ବର୍‌ ଦେଏ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ରି ମାଗୁଲାସ୍‌, ସେରି ନଃଜାଣୁଲାସ୍‌ । ମୁଁୟ୍‌ ଜୁୟ୍‌ ଦୁକ୍‌ ବଗାର୍‌ କପାୟ୍‌ ଡୁକୁଲେ, ତୁମି କାୟ୍‌ ସେ କପାୟ୍‌ ଡୁକୁକ୍‌ ହାରାସ୍‌ ? ମୁଁୟ୍‌ ଜୁୟ୍‌ ମଃର୍ନାର୍‌ ବାପ୍ତିସମ୍‌ ନେଉଁଲେ ସେ ବାପ୍ତିସମ୍‌ ତୁମି କାୟ୍‌ ନେଉଁ ହାରାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ହାରୁ ।” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ଜୁୟ୍‌ କପାୟ୍‌ ଡୁକୁଲେ, ତୁମିମଃନ୍ ସେ କପାୟ୍‌ ଡୁକୁକ୍‌ ହାରାସ୍‌ ଆର୍‌ ମୁଁୟ୍‌ ଜୁୟ୍‌ ବାପ୍ତିସମ୍‌ ହାଉଁଲେ, ତୁମିମଃନ୍ ସେତି ବାପ୍ତିସମ୍‌ ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମଃତର୍‌ ମର୍‌ କାତାବାଟ୍ୟା କି ଡେବ୍ରିବାଟ୍ୟା ବଃସୁକେ ଦେତାର୍‌ ମର୍‌ ଅଃଦିକାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ମର୍‌ ଉବା ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ସେ ଟାଣ୍ ବାଚ୍‌ଲା ଆଚେ, ସେମଃନ୍ ସେତି ବଃସ୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଜଃଡେବଃଳ୍‌ ତାର୍‌ ଦଃସ୍‌ଗଟ୍‌ ଚେଲାମଃନ୍ ଇରି ସୁଣ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଜାକୁବ ଆର୍‌ ଜହନ୍‌ ଉହ୍ରେ ରିସା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ସେତାକ୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦି କୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃର୍ତା ଲକ୍‌ ଅଃଉତି, ସେମଃନ୍ ଅଜିଉଦିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃକାଉତି, ଆର୍‌ ସେମଃନାର୍‌ ବଃଡ୍ ଲକ୍‌ମଃନ୍ ଅଜିଉଦିର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ତାକାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃର୍ତା ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃକାଉତି, ଇରି ତୁମିମଃନ୍ ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ସେନ୍‌କାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ କେ ବଃଡ୍ ଅଃଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ତୁମିମଃନାର୍‌ ସେବାକାରି ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଆର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଜେ ସଃବ୍‌କେ ବଃଡ୍ ଅଃଉଁକେ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳା ହର୍‌ ସଃବ୍‌କାର୍‌ ସେବା କଃର । ");
INSERT INTO bdv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ସେବା ହାଉଁକ୍‌ ନାସେ, ମଃତର୍‌ ସେବା କଃରୁକେ ଆର୍‌ ଗାଦେକ୍‌ ଲକାର୍‌ ଗିନେ ମୁକ୍ଳାଉତା ମଲ୍‌ ହର୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଦେଉଁକେ ଆସି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିରିହ ହଚ୍‌ଲାୟ୍‌ ଆର୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ଆର୍‌ ଅଲେକାର୍‌ ଲକ୍‌ ମିସି ଜିରିହହୁଣି ବାଉଳ୍‌ତାବଃଳ୍‌ ଟିମାୟର୍‌ ହୟ୍‌ସି ବାର୍ଟିମୟ ନାଉଁଆର୍‌ କାଣା ବିକାରି ବାଟ ହାଳାୟ୍‌ ବଃସିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ସେ ଜଃଡେବଃଳ୍‌ ନାଜରିତ୍‌ ବଃସ୍ତିର୍‌ ଜିସୁ ବଃଲି ଇରି ସୁଣି ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଦାଉଦାର୍‌ ହୟ୍‌ସି, ମକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ତୁନ୍‌ହାଳୁକେ ଦଃକାଦେଉଁକେ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ସେ ଆରେକ୍‌ ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଦାଉଦାର୍‌ ହୟ୍‌ସି, ମକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ସେତାକ୍‌ ଜିସୁ ତେବ୍‌ଲା ଆର୍‌ କୟ୍‌ଲା, “ତାକ୍‌ ଇତି କୁଦା ।” ସେମଃନ୍ ସେକାଣାକେ କୁଦି କୟ୍‌ଲାୟ୍‌, “ସାସ୍‌ ଦଃର୍‌, ଉଟ୍‌ ଜିସୁ ତକେ କୁଦୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ସେ ତାର୍‌ ହୁଙ୍ଗୁର୍ଲା ହଃଚ୍ୟା ଉର୍ଲି ହଃକାୟ୍‌ ସେଦାହ୍ରେ ଉଟିକଃରି ଜିସୁର୍‌ ତଃୟ୍‌ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତର୍‌ ଗିନେ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ବଃଲି ମଃନ୍ କଃରୁଲିସ୍‌ ?” ସେ କାଣା ମାନାୟ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ମୁଁୟ୍‌ ଜଃନ୍‌କଃରି ଦଃକୁହାରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ କୟ୍‌ଲା, “ଜାଆ, ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ଉଜ୍‌ କଃଲି ।” ତଃତ୍‌କାଣ୍ ସେ କାଣା ମାନାୟ୍‌ ଦଃକୁ ହାର୍ଲା ଆର୍‌ ବାଟେବାଟେ ଜିସୁର୍‌ ହଃଚେ ଜଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ଜିରୁସାଲମାର୍‌ ଲଃଗେ ଆର୍‌ ଜିତ୍‌ ଡଙ୍ଗୁର୍‌ ହାକାର୍‌ ବେତ୍‌ପାଗି ଆର୍‌ ବେତାନିଆ ଚଃମେ ହଚ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜିସୁ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଜଳେକ୍‌ ଚେଲାକେ ଇ କଃତା କୟ୍‌ ହଃଟାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ତୁମାର୍‌ ମୁଉଁ ଚଃମେ ରିଲା ଗାଉଁଏ ଜାହା ଆର୍‌ ସେ ଗାଉଁଏ ହୁରୁହୁରୁ ତୁମି ତାର୍‌ ଉହ୍ରେ କେହେଁ କଃବେ ନଃବେସ୍‌ଲା ଅଃନ୍‌କା ଗଟେକ୍‌ ହିଲାଗଃଦକ୍‌ ବାନ୍ଦିରିଲାର୍‌ ଦଃକାସ୍‌, ତୁମି ତାକ୍‌ ମେଲିକଃରି ମର୍‌ ଲଃଗେ ଆଣା । ");
INSERT INTO bdv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଜଃଡେବଃଳ୍‌ କେ ତୁମିମଃନ୍‌କେ କାୟ୍‌ତାକ୍‌ ଇ ଗଃଦ ହିଲାକ୍‌ ମେଲି ନେଉଁଲାସ୍‌ ବଃଲି ହଃଚାରେଦ୍‌; ତଃବେ ତୁମି ତାକେ କଃଉଆସ୍‌, ଇରି ଅଃମାର୍‌ ମାପ୍ରୁର୍‌ ଗିନେ ଲଳା ଆଚେ ଆର୍‌ ସେମାନାୟ୍‌ ତୁମିମଃନ୍‌କେ ଚାଡି ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ସେ ଜଳେକ୍‌ ଚେଲାମଃନ୍ ଗାଉଁଏ ବଃସ୍ତିଏ ଆର୍‌ ସେମଃନ୍ ଗାଉଁଆର୍‌ ଗଟ୍‌ ଗଃରାର୍‌ ଦୁଆର୍‌ ଚଃମେ ହଃଦାର୍‌ ସଃକ୍ଳାୟ୍‌ ଗଟେକ୍‌ ହିଲାଗଃଦକ୍‌ ବାନ୍ଦି ରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ମେଲ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ସଃଡେବଃଳ୍‌ ସେ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ହଃଚାର୍ଲାୟ୍‌, “ଇ ହିଲାଗଃଦକ୍‌ ମେଲି କାୟ୍‌ କଃରୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜିସୁ ଜଃନ୍‌କଃରି ଚେଲାମଃନ୍‌କେ କୟ୍‌ରିଲା, ସେମଃନ୍ ସେ ଲକ୍‌ମଃନ୍‌କେ ସେନ୍ ବଃଲି କୟ୍‌ଲାୟ୍‌; ତାର୍‌ହଃଚେ ସେ ଲକ୍‌ମଃନ୍ ଚେଲାମଃନ୍‌କେ ଗଃଦ ହିଲାକ୍‌ ମେଲି ନେଉଁକେ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ସେମଃନ୍ ଗଃଦ ହିଲାକ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆଣି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ହିଲାଗଃଦର୍‌ ହିଟି ଉହ୍ରେ ଅଚାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ତାର୍‌ ଉହ୍ରେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ଆରେକ୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ଜାତା ବାଟେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ଅଚାୟ୍‌ଲାୟ୍‌, ଆର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଗଃଚାର୍‌ ଡାଳ୍‌ କାଟି ଆଣି ବାଟେ ଅଚାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ଆଗ୍‌ବାଟ୍ୟା ଆର୍‌ ହଃଚ୍ ବାଟ୍ୟା ଇଣ୍ଡି ଜାତି ରିଲାୟ୍‌, ସେମଃନ୍ ବଃଡ୍ ଟଣ୍ଡ୍ ଅୟ୍‌ କଃଉତି ରିଲାୟ୍‌, “ହସାନ୍ନା, ବଃଲେକ୍‌ ଜୟ୍‌ ଅଃଉଅ, ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜେ ଆସୁଲା, ତାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ଅଃମାର୍‌ ଦାଦିବାବୁ ଦାଉଦାର୍‌ ଆସ୍ତା ରାଇଜାର୍‌ ବାୟ୍‌ଗ୍‌, ସଃବ୍‌କେ ଉହ୍ରାର୍‌ ହସାନ୍ନା, ବଃଲେକ୍‌ ଜୟ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଜିସୁ ଜିରୁସାଲମେ ଆୟ୍‌ଲା ଆର୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି ଚାରିହାକ୍‌ ଦଃକି ବୁଲ୍‌ଲା ଆର୍‌ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ତାର୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସି ବେତାନିଆ ଗାଉଁଏ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଆର୍‌ ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ବେତାନିଆ ଗାଉଁଏ ହୁଣି ଜିରୁସାଲମେ ବାରାୟ୍‌ ଆସ୍ତାବଃଳ୍‌ ଜିସୁକ୍‌ ବୁକ୍‌ ଲାଗ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ସଃଡେବଃଳ୍‌ ସେ ଦୁରିକ୍‌ ହୁଣି ଗଟେକ୍‌ ହଃତାର୍‌ ରିଲା ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ ଦଃକ୍‌ଲା । ଜିସୁ ସେ ଗଃଚ୍ ଲଃଗେ ଡୁମ୍ବୁର୍‌ ହଃଳ୍‌ ମିଳେଦ୍‌ ବଃଲି ଆସା ଅୟ୍‌କଃରି ଗଃଲା; ମଃତର୍‌ ସେ ଗଃଚେ ଅଃବ୍‌କା ହଃତାର୍‌ ଚାଡି କାୟ୍‌ରି ହେଁ ନଃହାୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ଡୁମ୍ବୁର୍‌ ହଃଳ୍‌ତା ଦିନ୍ ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ସେତାକ୍‌ ଜିସୁ ସେ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ କୟ୍‌ଲା, “ଆର୍‌ କଃବେ ହେଁ କେ ତର୍‌ ତଃୟ୍‌ହୁଣି ହଃଳ୍‌ ନଃକାଅ ।” ତାର୍‌ ଚେଲାମଃନ୍ ଇ କଃତା ସୁଣ୍‌ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିରୁସାଲମ୍‌ ମନ୍ଦିରେ ଗଃଳାୟ୍‌ ଆର୍‌ ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି ସେତି ଗେନା ବିକା କଃର୍ତା ସେତିର୍‌ ବେବାରିମଃନ୍‌କେ ବାର୍‌କଃରି କଃଦୁକ୍‌ ଦଃର୍ଲା, ଆର୍‌ ଡାବୁ ବେବାରିମଃନାର୍‌ ଟେବୁଲ୍‌ କୁର୍ଚି ଆର୍‌ ହାରୁଆ ବିକ୍‌ତା ଲକାର୍‌ କୁର୍ଚିମଃନ୍ ଉଲ୍‌ଟାୟ୍‌ ହଃକାୟ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଆର୍‌ ସେ ମନ୍ଦିର୍‌ ବିତ୍ରାର୍‌ କୁଆଳ୍‌ ବାଟ କାକେ ହେଁ କାୟ୍‌ରି ହେଁ ଦଃରି ନେଉଁକେ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦଃୟ୍‌ କୟ୍‌ଲା, “ଇରି କାୟ୍‌ ଲେକା ନାୟ୍‌, ‘ଅଃମାର୍‌ ଗଃର୍‌ ସଃବୁ ଜାତିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଇସ୍ୱରାର୍‌ ପାର୍ତ୍‌ନାଗଃର୍‌ ବଃଲି ଡାକେ ହୁଟେଦ୍‌ ।’ ମଃତର୍‌ ତୁମିମଃନ୍ ଇ ଗଃର୍‌କେ କଃଙ୍ଗାର୍‌ମଃନାର୍‌ ଲୁକ୍‌ତା ହାର୍‌ କଃରି ଆଚାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍ ଜଃଡେବଃଳ୍‌ ଇ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ ଉପାୟ୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ସିକ୍ୟା ସୁଣି କାବା ଅଃଉତିରିଲାର୍‌ ଗିନେ ସେମଃନ୍ ଜିସୁକେ ଡିରି ଜାୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ସେ ଦିନ୍ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ଜିସୁ ଆର୍‌ ଚେଲାମଃନ୍ ଜିରୁସାଲମେ ହୁଣି ବାରାୟ୍‌ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ତାର୍‌ ଆର୍‌କ ଦିନାର୍‌ ସଃକାଳ୍ୟା ସେମଃନ୍ ଜାତି ରିଲାବଃଳ୍‌, ସେ ବାଟେ ରିଲା ଜୁୟ୍‌ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ ଜିସୁ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ରିଲା, ସେ ଗଃଚ୍‌କେ ବୁନ୍ଦେହୁଣି ସୁକି ଜାୟ୍‌ରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ପିତର୍‌ ତାର୍‌ ହଃଚାର୍‌ ଦିନାର୍‌ କଃତା ଏତାୟ୍‌ କଃରି କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଦଃକ୍‌, ଇ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ ତୁୟ୍‌ ଜଃନ୍‌କଃରି ସାୟ୍‌ପ୍‌ ଦଃୟରିଲିସ୍‌, ତଃନ୍‌କଃରି ସେ ଗଃଚ୍ ସୁକି ଜଃଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଇସ୍ୱର୍‌ ଲଃଗେ ବିସ୍ୱାସ୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ଗଟେକ୍‌ ଡଙ୍ଗୁର୍‌କେ ଉଟ୍‌କି ଅୟ୍‌ ଜାଆ ଆର୍‌ ସଃମ୍‌ନ୍ଦେ ଅଦୁର୍‌ ବଃଲି କୟ୍‌ଦ୍‌, ଆର୍‌ ସେ ନିଜାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଅବିସ୍ୱାସ୍‌ ନଃକେରି, ଜୁୟ୍‌ରି ଅୟ୍‌ଦ୍‌ ବଃଲି ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ତାର୍‌ ଗିନେ ନିଜ୍‌କଃରି ସେରଃକମ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ତୁମି ପାର୍ତ୍‌ନା କଃରି ଜାୟ୍‌ ଜାୟ୍‌ରି ମାଗାସ୍‌, ସେରି ହାୟ୍‌ଆଚୁ ବଃଲି ବିସ୍ୱାସ୍‌ କଃରା, ତଃବେ ତୁମିମଃନ୍‌କେ ସେରି ସଃବୁ ମିଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଜଃଡେବଃଳ୍‌ ତୁମି ପାର୍ତ୍‌ନା କଃରୁକେ ଟିଆ ଅଃଉଆସ୍‌, ତଃବେ ସଃଡେବଃଳ୍‌ ତୁମାର୍‌ ବିରଦେ କାର୍‌ ଦଃସ୍‌ ରଃୟ୍‌ଦ୍‌ ବଃଲେକ୍‌ ତୁମି ତାକ୍‌ କେମା ଦିଆସ୍‌, ତଃବେ ତୁମାର୍‌ ଉବାଦି ଜେ ସଃର୍ଗେ ଆଚେ, ସେ ହେଁ ତୁମିମଃନ୍‌କେ କେମା ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ଜଃଡେବଃଳ୍‌ ତୁମି କାକେ ହେଁ କେମା ନଃଦିଆସ୍‌, ତଃବେ ତୁମାର୍‌ ସଃର୍ଗେ ରିଲା ଉବାଦି ହେଁ ତୁମାର୍‌ ହାହ୍‌ କେମା ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ସେମଃନ୍ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଜିରୁସାଲମ୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜଃଡେବଃଳ୍‌ ଜିସୁ ସେ ମନ୍ଦିର୍‌ ଲଃଗେ ବୁଲ୍‌ତି ରିଲା, ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍, ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ତାର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ଆର୍‌ ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଇ ସଃବୁ କାମ୍‌ ତୁୟ୍‌ କୁୟ୍‌ ଅଃଦିକାର୍‌ ବଃଳେ କଃରୁଲିସ୍‌, ଆର୍‌ ଇ କାମ୍‌ କଃର୍ତା ଗିନେ ତକେ କେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଗଟେକ୍‌ କଃତା ହଃଚାରିନ୍ଦ୍, ଜଃଡେବଃଳ୍‌ ତୁମି ମର୍‌ କଃତାର୍‌ ଉତୁର୍‌ ଦିଆସ୍‌; ତଃବେ ମୁଁୟ୍‌ କୁୟ୍‌ ଅଃଦିକାରେ ଇ ସଃବୁ କାମ୍‌ କଃରୁଲେ, ସେ କଃତା କୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜହନ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଅଃଦିକାର୍‌ କୁୟ୍‌ତି ହୁଣି ହାୟ୍‌ରିଲା ? ସଃର୍ଗେ ହୁଣି କି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ? ସେରି ମକ୍‌ କଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଜଦି ଅଃମି ସଃର୍ଗେହୁଣି ବଃଲି କଃଉନ୍ଦ୍, ତଃବେ ତୁମି କାୟ୍‌ତାକ୍‌ ଜହନ୍‌ କୟ୍‌ଲା କଃତାକ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେଲାସ୍‌ ବଃଲି କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ତଃବେ ଅଃମି ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବଃଲି କଃଉଆ କି ?” କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍ତି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃବୁ ଲକ୍‌ ଜହନ୍‌କେ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ବଃଲି ମାନ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ସେତାର୍‌ଗିନେ ସେମଃନ୍ ଜିସୁକେ ଉତୁର୍‌ ଦଃୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମି ନଃଜାଣୁ ।” ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ମୁଁୟ୍‌ ହେଁ କୁୟ୍‌ ଅଃଦିକାର୍‌ ବଃଳେ ଇ ସଃବୁ କାମ୍‌ କଃରୁଲେ, ସେରି ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ନଃକୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ କଃତା କୟ୍‌ ସିକ୍ୟା ଦେଉଁକ୍‌ ଦଃର୍ଲା, “ଗଟେକ୍‌ ଲକ୍‌ ଗଟ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ କଃରି ତାର୍‌ ଚାରିବେଳ୍‌ତ୍ ବାଳ୍‌ ବୁଣ୍‌ଲା, ଆରେକ୍‌ ଅଙ୍ଗୁର୍‌ ହଃଳ୍‌ ହିଳୁକ୍‌ ଗଟେକ୍‌ କୁଣ୍ଡ୍‌ ତିଆର୍‌ କଃଲା । ଆର୍‌ ଜାଗ୍‌ତା ମାଚା ହେଁ ବାନ୍ଦ୍‌ଲା; ତାର୍‌ହଃଚେ ସେ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌କେ ତାସିମଃନ୍‌କେ ବାଗେ ଦଃୟ୍‌ ବିଦେସ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ଜଃଡେବଃଳ୍‌ ଅଙ୍ଗୁର୍‌ ହଃଳ୍‌ କଳ୍‌ତା ବେଳା ଆୟ୍‌ଲି, ତାସିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ନିଜାର୍‌ ବାଗ୍ ହାଉଁକେ ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଟିକ୍‌ ବେଳାୟ୍‌ ସେମଃନାର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ମଃତର୍‌ ତାସିମଃନ୍‌ ସେ ଦଃଙ୍ଗ୍‌ଳାକେ ଦଃରି ମାଡ୍ ମାର୍ଲାୟ୍‌ ଆର୍‌ ଚୁଚା ଆତେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ତାର୍‌ହଃଚେ ସେ ସାଉକାର୍‌ ଆରେକ୍‌ ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ସେମଃନାର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା; ସେମଃନ୍ ତାର୍‌ ହେଁ ମୁଣ୍ଡ୍‌ ହୁଟାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକ୍‌ ଇନସ୍ତା କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ସେ ଆରେକ୍‌ ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳାକେ ହଃଟାୟ୍‌ଲା; ସେମଃନ୍ ତାକ୍‌ ମଃର୍ନେ ମାର୍‌ଲାୟ୍‌ । ତାର୍‌ହଃଚେ ସେ ସାଉକାର୍‌ ବୁତେକ୍‌ ଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କେ ହଃଟାୟ୍‌ଲା; ତାସିମଃନ୍‌ ଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ବିତ୍ରେ କଃତିଲକେ ମାଡ୍ ମାର୍ଲାୟ୍‌ ଆର୍‌ କଃତି ଲକ୍‌ମଃନ୍‌କେ ମଃର୍ନେ ମାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ସେ ସାଉକାର୍‌ ହାକ୍‌ ଅଃବେ ଗଟେକ୍‌ ଲକ୍‌ ମଃତର୍‌ ବାକି ରିଲା, ସେ ତାର୍‌ ଲାଡାର୍‌ ହୟ୍‌ସି । ମର୍‌ ନିଜାର୍‌ ହଅକେ ସେମଃନ୍ ମାନ୍‌ତି କଃର୍ତି, ବଃଲି ସେ ସଃରାସଃରି ବଃଳ୍‌ ନିଜାର୍‌ ହୟ୍‌ସିକ୍‌ ସେମଃନାର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ମଃତର୍‌ ସେ ତାସିମଃନ୍‌ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, ‘ଏ ଅଃଉଁଲା ସାଉକାରାର୍‌ ହୟ୍‌ସି । ଆସା ଅଃମି ଆକ୍‌ ମଃର୍ନେ ମାରୁଆଁ, ତଃବେ ସଃବୁ ଅଃଦିକାର୍‌ ଅଃମାର୍‌ ଅୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ତଃବେ ସେମଃନ୍ ସାଉକାରାର୍‌ ହୟ୍‌ସିକେ ଦଃରି ମଃର୍ନେ ମାର୍‌ଲାୟ୍‌ ଆର୍‌ ତାକ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ ହୁଣି ହଃଦାୟ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଜିସୁ ହଃଚାର୍ଲା, “ତଃବେ ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସାଉକାର୍‌ କାୟ୍‌ରି କଃରେଦ୍‌ ? ସେ ଆସି ସେ ଲକ୍‌ମଃନ୍‌କେ ମଃର୍ନେ ମାରେଦ୍‌, ଆରେକ୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ ସେ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌କେ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ତୁମିମଃନ୍ କାୟ୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ଁ ଇ କଃତା ନଃହଳାସ୍‌ ? ‘ଗଃର୍‌ ବାନ୍ଦ୍‌ତା ଲକ୍‌ମଃନ୍ ଜୁୟ୍‌ ଟେଳାକେ ଲଳା ନାୟ୍‌ ବଃଲି ଦୁର୍‌କଃଲାୟ୍‌, ମଃତର୍‌ ସେ ଟେଳା କନାର୍‌ ମୁଳ୍‌ କୁନାଦି ଟେଳା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ମାପ୍ରୁ ନିଜେ ଇରି କଃଲା, ଆର୍‌ ଇରି ଅଃମାର୍‌ ହାଁୟ୍‌ ଗିନେ କାବା ଅଃଉତା କଃତା ।’” ");
INSERT INTO bdv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଇତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ଦଃରୁକ୍‌ ମଃନ୍ ହାଚ୍‌ଲାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍‌ଲାୟ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ କଃତା ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ କଃରି କୟ୍‌ରିଲା ବଃଲି ସେମଃନ୍ ବୁଜ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ଚାଡିକଃରି ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ହଃଚେ ଜିସୁର୍‌ କଃତାର୍‌ ଦଃସ୍‌ ଦଃରୁକ୍‌ ଜିଉଦି ନେତାମଃନ୍, ପାରୁସି ଆର୍‌ ହେରଦିୟ ଦଃଳାର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଜିସୁର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ସେମଃନ୍ ଆସି ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଗୁରୁ ଅଃମି ଜାଣୁଲୁ ଜେ, ତୁୟ୍‌ ସଃତ୍‌ ଆର୍‌ କାକେହେଁ ନଃଡିର୍‌ସି; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ମୁକ୍‌ମେଟ୍‌ ନଃଦେକ୍‌ସି, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଇସାବେ ସିକ୍ୟା ଦେସି । କାଇସର୍‌କେ ସିସ୍ଟୁ ଦେତା ବିଦି କି ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ହେଟ୍‌କପଟ୍‌ ଜାଣି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ ମକ୍‌ କଃଟ୍‌ହାଳ୍‌ ବୁଜୁଲାସ୍‌ ? ଗଟେକ୍‌ ରୁହା ଅଦ୍‌ଲି ମର୍‌ ହାକ୍‌ ଆଣା, ମୁୟ୍‌ଁ ସେରି ଦଃକିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ସେମଃନ୍ ଗଟେକ୍‌ ରୁହା ଅଦ୍‌ଲି ତାକ୍‌ ଦିଲାୟ୍‌, ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ଇ ମୁର୍ତି ଆର୍‌ ନାଉଁ କାର୍‌ ?” ସେମଃନ୍ ଜିସୁକେ ଉତୁର୍‌ ଦିଲାୟ୍‌, “କାଇସରାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ରି କାଇସରାର୍‌, ସେରି କାଇସର୍‌କେ ଦିଆସ୍‌, ଆର୍‌ ଜୁୟ୍‌ରି ଇସ୍ୱରାର୍‌, ସେରି ଇସ୍ୱର୍‌କେ ଦିଆସ୍‌ ।” ସେମଃନ୍ ଜିସୁର୍‌ କଃତା ସୁଣି କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଇତାର୍‌ହଃଚେ ମଃରି ଉଟ୍‌ତାର୍‌ ନଃମାନ୍‌ତା ସାଦୁକିମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ଆସି ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ ଗୁୁରୁ, ମସା ଅଃମାର୍‌ ଗିନେ ଲେକିଆଚେ, ଜଦି ଗଟ୍‌ ଲକାର୍‌ ବାୟ୍‌ ମଃରେଦ୍‌, ଆର୍‌ ତାର୍‌ ଡକୁର୍ସି ବାଚି ରଃୟ୍‌ଦ୍‌ ଆର୍‌ ତାର୍‌ ହିଲାମଃନ୍‌ ନଃରେତି, ତଃବେ ତାର୍‌ ବାୟ୍‌ ତାର୍‌ ଡକୁର୍ସିକେ ବିବା ଅୟ୍‌କଃରି ତାର୍‌ ବାୟ୍‌ସିର୍‌ ଗିନେ ବଃଉଁସ୍‌ ବାଡାଉଁ ହାରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ଗଟ୍‌ ଗଃରେ ସାତ୍‌ ବାୟ୍‌ ରିଲାୟ୍‌; ସଃବ୍‌କେ ବଃଡ୍ ବାୟ୍‌ସି ବିବା ଅୟ୍‌ଲା ଆର୍‌ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲା; ");
INSERT INTO bdv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ତାର୍‌ହଃଚେ ତାର୍‌ ହିଟିର୍‌ ବାୟ୍‌ସି ସେ ଟକିକେ ବିବା ଅୟ୍‌ଲା, ସେ ହେଁ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲା; ଆର୍‌ ତାର୍‌ ହିଟିର୍‌ ବାୟ୍‌ସି ହେଁ ସେ ଟକିକେ ବିବାଅୟ୍‌ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ସାତ୍‌ ବାୟ୍‌ ଜାକ ସେରଃକମ୍‌ ସେ ଟକିକେ ବିବା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲାୟ୍‌; ସଃବ୍‌କାର୍‌ ହଃଚେ ସେ ମାୟ୍‌ଜି ଟକି ହେଁ ମଃଲି । ");
INSERT INTO bdv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ଜୁୟ୍‌ଦିନ୍‌ ସଃବୁ ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟ୍‌ତାବଃଳ୍‌ ସେମଃନ୍ ଉଟ୍‌ତି, ସଃଡେବଃଳ୍‌ ସେ ମାୟ୍‌ଜି ସେ ସାତ୍‌ ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରାର୍‌ କାର୍‌ ଡକୁର୍ସି ଅୟ୍‌ଦ୍‌ ? ସାତ୍‌ ବାୟ୍‌ ଜାକ ତାକ୍‌ ବିବା ଅୟ୍‌ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଆରେକ୍‌ ଇସ୍ୱରାର୍‌ ସଃକ୍ତିକେ ହେଁ ନଃଜାଣ୍‌ତାର୍‌ କାୟ୍‌ ତୁମାର୍‌ ଉଲୁର୍‌ କଃତା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟ୍‌ଲା ହଃଚେ ସେମଃନ୍ ବିବା ନଃକେର୍ତି କି ବିବା ନଃଉତି, ସେମଃନ୍ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନାର୍‌ ହର୍‌ ରେତି । ");
INSERT INTO bdv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ମଃତର୍‌ ମଃଲା ଲକ୍‌ମଃନ୍ ଜେ ଉଟ୍‌ତି, ସେ କଃତା କି ତୁମିମଃନ୍ ମସାର୍‌ ସାସ୍ତରେ ସେ ବୁଟାୟ୍‌ ଜୟ୍‌ଲାଗ୍‌ତା କଃତା ନଃହଳାସ୍‌ ? ଇସ୍ୱର୍‌ କଃନ୍‌କଃରି ମସାକ୍‌ କୟ୍‌ଲା, ‘ମୁଁୟ୍‌ ଅବ୍ରାହାମାର୍‌ ଇସ୍ୱର୍‌, ଇସାକାର୍‌ ଇସ୍ୱର୍‌ ଆର୍‌ ଜାକୁବାର୍‌ ଇସ୍ୱର୍‌ ?’ ");
INSERT INTO bdv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ସେ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ଇସ୍ୱର୍‌ ନୟ୍‌ଁ, ମଃତର୍‌ ସେ ଜିବନ୍‌ ଲକ୍‌ମଃନାର୍‌ ଇସ୍ୱର୍‌ । ତୁମିମଃନ୍ ବଃଡେ ଉଲୁ ଅଃଉଁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ସଃଡେବଃଳ୍‌ ଗଟ୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଜିସୁର୍‌ ଲଃଗେ ଆସି ସେମଃନାର୍‌ କଃତା ଦଃରାଦଃରି ସୁଣ୍‌ଲା, ଆର୍‌ ଜିସୁ ଜେ ସାଦୁକିମଃନ୍‌କେ ଟିକ୍‌ ଉତୁର୍‌ ଦିଲା ଆଚେ ବଃଲି ଜାଣି ସେ ଜିସୁକେ ହଃଚାର୍ଲା, “ସଃବୁ ଆଦେସ୍‌ ବିତ୍ରେ କୁୟ୍‌ ଆଦେସ୍‌ ବଃଡ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ସଃବ୍‌କେ ବଃଡ୍ ବଲ୍‌ ଅଃଉଁଲି, ‘ଏ ଇସ୍ରାଏଲ୍‌ ସୁଣ୍ ! ମାପ୍ରୁ ଅଃମାର୍‌ ଇସ୍ୱର୍‌ ଗଟେକ୍‌ ହଃକା ମାପ୍ରୁ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଆର୍‌ ତୁମିମଃନ୍ ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ମଃନ୍‌, ସଃବୁ ଜିବନ୍‌, ସଃବୁ ମଃନ୍‌ ଆର୍‌ ସବୁ ସଃକ୍ତି ଦଃୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ଲାଡ୍‌ କଃରା ।’ ");
INSERT INTO bdv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଆରେକ୍‌ ଗଟେକ୍‌ ବଲ୍‌ ଅଃଉଁଲି, ‘ତୁମିମଃନ୍ ନିଜ୍‌କେ ଜଃତେକ୍‌ ଲାଡ୍‌ କଃରୁଲାସ୍‌, ବିନ୍ ଲକେ ହେଁ ସେରଃକମ୍‌ ଲାଡ୍‌କଃରା । ଇ ଜୁଳେକ୍‌ ବିଦି ଚାଡି ଆରେକ୍‌ ବିନ୍ ବଃଡ୍ ବିଦି କୁୟ୍‌ରି ନାୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଇ କଃତା ସୁଣି ସେ ଦଃର୍ମ୍‌ ସାସ୍ତ୍ରି ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ସେରି ସଃତ୍‌, ସେ ଜେ ଗଟେକ୍‌ ଆର୍‌ ତାକ୍‌ ଚାଡି କେହେଁ ନାୟ୍‌, ଇ କଃତା ତୁୟ୍‌ ସଃତ୍‌ କୟ୍‌ଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଆର୍‌ ସଃବୁ ଗଃର୍ବ୍‌, ସଃବୁ ବୁଦି ଆର୍‌ ସଃବୁ ସଃକ୍ତି ଦଃୟ୍‌ ଇସ୍ୱର୍‌କେ ଲାଡ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ହଃଳ୍‌ସା ଲକ୍‌ମଃନ୍‌କେ ନିଜ୍‌କେ ଲାଡ୍‌ କଃଲାହର୍‌ ଲାଡ୍‌ କଃର୍ତାର୍‌ ସଃବୁ ହୁଜାବିଦି ତଃୟ୍‌ହୁଣି ଇ ଜୁଳେକ୍‌ ବଲ୍‌ ଅଃଦିକ୍‌ ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ସେ ଲକ୍‌ ବୁଦିର୍‌ ସଃଙ୍ଗ୍ ଉତୁର୍‌ ଦଃୟ୍‌ଆଚେ ବଃଲି ଜାଣି, ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ନାୟ୍‌ ।” ଇତାର୍‌ହଃଚେ କେ ହେଁ ଜିସୁକେ ଆରେକ୍‌ କାୟ୍‌ କଃତା ହେଁ ହଃଚାରୁକ୍‌ ସାସ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଜିସୁ ମନ୍ଦିର୍‌ ଗଃରେ ସିକ୍ୟା ଦେତାବଃଳ୍‌ ଲକ୍‌ମଃନ୍‌କେ ହଃଚାର୍ଲା, “କ୍ରିସ୍ଟ ଜେ ଦାଉଦାର୍‌ ହୟ୍‌ସି ବଃଲି ଇରି ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ କଃନ୍‌କଃରି କଃଉଁଲାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ଦାଉଦ୍‌ ନିଜେ ପବିତ୍ର ଆତ୍ମାର୍‌ ସଃକ୍ତି ତଃୟ୍‌ କୟ୍‌ରିଲା, ମାପ୍ରୁ ମର୍‌ ମାପ୍ରୁକେ କୟ୍‌ଲା, ମୁଁୟ୍‌ ଜଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ତୁମାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ ତର୍‌ ହାଦ୍‌ ତଃଳେ ନଃକେରି ଆଚୁ, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ତୁୟ୍‌ ମର୍‌ କାତା ବାଟ୍ୟା ବଃସିରେ । ");
INSERT INTO bdv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ନିଜେ ଦାଉଦ୍‌ କ୍ରିସ୍ଟକେ ମାପ୍ରୁ ବଃଲି କୟ୍‌ଲା, ତଃବେ ସେ କଃନ୍‌କଃରି ଦାଉଦାର୍‌ ହୟ୍‌ସି ?” ସଃବୁ ଲକ୍‌ମଃନ୍ ସଃର୍ଦା ଅୟ୍‌ ଜିସୁର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ଜିସୁ କୟ୍‌ଲା, “ଦଃର୍ମ୍‌ ଗୁରୁମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ସେମଃନ୍ ଡେଙ୍ଗ୍ ବଃସ୍ତର୍‌ ହଃଜି କଃରି ଏଣେ ତେଣେ ବୁଲୁକ୍‌ ମଃନ୍ କଃର୍ତି, ଆର୍‌ ଆଟ୍‌ ବଃଜାରେ ମାନ୍‌ତି ଆଟ୍‌ ବଃଜାରେ ଜୁଆର୍‌ ହାଉଁକ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ପାର୍ତ୍‌ନା ଗଃରେ ଉଚ୍ ଟାଣେ ବଃସୁକେ ମଃନ୍ କଃର୍ତି । ବଜି ଟାଣେ ହେଁ ସେମଃନ୍ ବଃଡ୍ ଜଃଗା ହାଉଁକ୍‌ ମଃନ୍ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ସେମଃନ୍ ରାଣ୍ଡି ମାୟ୍‌ଜିମଃନାର୍‌ ଗଃର୍‌ ଦୁଆର୍‌ ସଃବୁ ଅଃଦିକାର୍‌ କଃରି ନେତି ଆର୍‌ ବଃଲ୍‌ ଦଃକାୟ୍‌ ଅଃଉଁକେ ସେମଃନ୍ ଡେଙ୍ଗ୍ ପାର୍ତ୍‌ନା କଃର୍ତି । ସେମଃନ୍ ଜଃବର୍‌ ବିଚାର୍‌ ତଃୟ୍‌ଁ ଡଃଣ୍ଡ୍‌ ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଜିସୁ ମନ୍ଦିରାର୍‌ ଦାନ୍‌ ହଃକାଉତା ଦାନ୍‌ହେଳି ଲଃଗେ ବଃସି ଲକ୍‌ମଃନ୍ କଃନ୍‌କଃରି ସେତି ଦାନ୍‌ ଦେଉଁଲାୟ୍‌, ସେରି ଦଃକ୍‌ତିରିଲା । ସଃଡେବଃଳ୍‌ କଃତେକ୍‌ ମାଜନ୍‌ ଲକ୍‌ମଃନ୍ ବୁତେକ୍‌ ଦାନ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ତାର୍‌ହଃଚେ ଗଟେକ୍‌ ଗଃରିବ୍‌ ରାଣ୍ଡି ମାୟ୍‌ଜି ଆସି, ଜଳେକ୍‌ ସାନ୍‌ ତାମ୍ବାକାସୁ ସେତି ଦାନ୍‌ ହଃକାୟ୍‌ଲି, ସେ ତାମ୍ବାକାସୁର୍‌ ମଲ୍‌ ଗଟେ ଟଃକା ତଃୟ୍‌ ହୁଣି ହେଁ ଉଣା । ");
INSERT INTO bdv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଲଃଗେ କୁଦି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ବଃଣ୍ଡାରେ ଦାନ୍‌ ହଃକାଉତା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଇ କାୟ୍‌ରି ନୟ୍‌ଲା ରାଣ୍ଡିମାୟ୍‌ଜି ସଃବୁ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଦାନ୍‌ହେଳି ତଃୟ୍‌ ହଃକାୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ବୁତେକ୍‌ ଦଃନ୍ ତଃୟ୍‌ହୁଣି ଅଃଳକ୍‌ ଅଃଳକ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଇ କାୟ୍‌ରି ନୟ୍‌ଲା ରାଣ୍ଡି ମାୟ୍‌ଜି ତାର୍‌ ଅକେଟ୍‌ ବଃଳ୍‌ ହେଁ ନିଜାର୍‌ ଜିବନ୍ ବଚାଉଁକେ ତାର୍‌ ହାକ୍‌ ଜାୟ୍‌ରି ରିଲି ସେରିସଃବୁ ହଃକାୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜିସୁ ଜିରୁସାଲମେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ ଜାତିରିଲା ବଃଳ୍‌ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେହୁଣି ଗଟେକ୍‌ ଚେଲା କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଦଃକ୍‌ କଃନ୍‌କା ଟେଳାମଃନ୍ ଆର୍‌ କଃନ୍‌କା ମେଳ୍‌ଗଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଇ ବଃଡ୍‌ ମେଳ୍‌ଗଃର୍‌ ଦଃକୁଲିସ୍‌ ? ମଃତର୍‌ ଇ ଗଟେକ୍‌ ଟେଳା ଆରେକ୍‌ ଗଟେକ୍‌ ଟେଳା ଉହ୍ରେ ନଃରେୟ୍‌, ସଃବୁ ହେଁ ମାଟାୟ୍‌ ମିସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଜିସୁ ମନ୍ଦିର୍‌ ମୁଆଟି ବାଟାର୍‌ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ବଃସିରିଲା ବଃଳ୍‌, ପିତର୍‌, ଜାକୁବ, ଜହନ୍‌ ଆର୍‌ ଆନ୍ଦ୍ରିଅ ଲୁକ୍‌ଣେ ଆସି ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“କଃବେ ଇ ଗଃଟ୍‍ଣା ଗଃଟେଦ୍‌, ଆରେକ୍‌ ଇ ଗଃଟ୍‍ଣା ଗଃଟୁଲି ବଃଲି ଅଃମି କଃନ୍‌କଃରି ଜାଣୁନ୍ଦ୍, ଆର୍‌ ସେ ବଃଳାର୍‌ ଚିନ୍ କାୟ୍‌ରି ଅଃମିକ୍‌ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “କେ ତୁମିମଃନ୍‌କେ ଜଃନ୍‌କଃରି ନଃଜେଟ୍‌ତି, ସେତାର୍‌ଗିନେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ନାଉଁଏ ଆସ୍ତି ଆର୍‌ ‘ମୁଁୟ୍‌ କ୍ରିସ୍ଟ’ ବଃଲି କଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଜଃଟ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଜୁଜାର୍‌ କଃତା ସୁଣ୍‌ଲେକ୍‌ ଆର୍‌ ଜୁଜ୍‌ ଲାଗ୍‌ତାର୍‌ ସୁଣ୍‌ଲେକ୍‌ ଡିରା ନାୟ୍‌; ଇବାନ୍ୟା ଗଃଟ୍‍ଣାମଃନ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଗଃଟେଦ୍‌, ମଃତର୍‌ ଇରି ଜୁଗ୍ ବୁଡ୍‌ତା କାଳ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଲକ୍‌ ବିରଦେ ଲକ୍‌ ଜୁଜ୍‌ ଲାଗ୍‌ତି, ରାଇଜ୍‌ ବିରଦେ ରାଇଜ୍‌ ଉଟେଦ୍‌ ଆର୍‌ ଟାଣେ ଟାଣେ ଦଃର୍ତି ଲଃଦ୍‌ବଃଦେଦ୍‌, ଦୁର୍ବିକ୍ୟା ଅୟ୍‌ଦ୍‌; ମଃତର୍‌ ଇସଃବୁ ହିଲା ଜଃଲମ୍‌ କଃର୍ତା ମାୟ୍‌ଜିଟକିର୍‌ ଆରୁମ୍‌ ଦୁକା ହର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ମଃତର୍‌ ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ବିସୟେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ; ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍‌କେ ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ସଃହ୍ରି ଦେତି, ଆର୍‌ ତୁମିମଃନ୍‌କେ ପାର୍ତ୍‌ନା ଗଃରେ ନଃୟ୍‌ ମାଡ୍ ମାର୍ତି, ଆରେକ୍‌ ମର୍‌ ଗିନେ ସଃର୍କାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଆର୍‌ ରଃଜାମଃନାର୍‌ ତଃୟ୍‌ ସେମଃନାର୍‌ ଗିନେ ସାକି ଅଃଉଁକେ ଟିଆ ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ମଃତର୍‌ ଜୁଗ୍ ବୁଡ୍‌ତା ଆଗ୍‌ତୁ ବାୟ୍‌ଦ୍‌ରେ ସଃବୁ ଜାତିର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ଇତାକ୍‌ ଲକ୍‌ମଃନ୍ ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍‌କେ ବିଚାର୍‌ କଃରୁକେ ବାନ୍ଦି ନେତି, ସଃଡେବଃଳ୍‌ ତୁମି କାୟ୍‌ରି କଃଉନ୍ଦ୍ ବଃଲି ଆଗ୍‌ତୁ ଚିତା କଃରାନାୟ୍‌; ମଃତର୍‌ ତୁମିମଃନ୍‌କେ ସଃଡେବଃଳ୍‌ କାୟ୍‌ରି କଃଉଁକେ ଦିଆ ଅୟ୍‌ଦ୍‌, ସେରି କଃଉଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ କଃତା କଃଉତା ଲକ୍‌ ନୟ୍‌, ମଃତର୍‌ ପବିତ୍ର ଆତ୍ମା କଃତା କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ଲକ୍‌ମଃନ୍ ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ ବାୟ୍‌କ୍‌, ଉବାସି ହୟ୍‌ସିକେ, ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ସଃହ୍ରି ଦେତି, ଆରେକ୍‌ ହିଲାମଃନ୍ ଉବାସି ଆୟ୍‌ସି ବିରଦେ ଉଟ୍‌ତି ଆର୍‌ ସେମଃନ୍‌କେ ମଃର୍ନେ ମାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ଆର୍‌ ମର୍‌ ନାଉଁ ଗିନେ ତୁମିମଃନ୍ ସଃବୁଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଗିଣ୍‌କଃରାୟ୍‌ ଅଃଉଆସ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ସେସ୍‌ ହଃତେକ୍‌ ବିସ୍ୱାସେ ତିର୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌, ସେ ହାହେ ହୁଣି ନିଜ୍‌କେ ବଚାଉ ହାରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ସେ ନାସ୍‌କାରି ଗିଣ୍‌ ଆସ୍ତିକ୍‌ ଜୁୟ୍‌ ଜଃଗା ଲଃଗେ ରେତା ବିଦି ନାୟ୍‌, ସେ ଜଃଗା ଲଃଗେ ରେତାର୍‌ ଦଃକାସ୍‌ । ହଳ୍‌ତା ଲକ୍‌ ଆର୍‌ ଅଃର୍ତ୍‌ ବୁଜତ୍‌ । ସଃଡେବଃଳ୍‌ ଜିଉଦା ରାଇଜ୍‌ ଲଃଗେ ରେତା ଲକ୍‌ମଃନ୍ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ହଃଳାୟ୍‌ ଜଃଉଅତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଆର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ଗଃରାର୍‌ ଚାନି ଉହ୍ରେ ରଃୟ୍‌ଦ୍‌, ସେ ତଃଳେ ଉତ୍ରନାୟ୍‌ଁ ଆର୍‌ କାୟ୍‌ରି ନେଉଁକେ ଗଃର୍‌ ବିତ୍ରେ ଜଃଉଅ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଆର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ତାସ୍‌ ହଃଦାୟ୍‌ ରଃୟ୍‌ଦ୍‌, ସେମାନାୟ୍‌ ତାର୍‌ ହଃଚ୍ୟା ନେଉଁକେ ଗଃରେ ଲେଉଟି ଆସ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ମଃତର୍‌ ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ମାୟ୍‌ଜିମଃନ୍ ଆଙ୍ଗେ ରେତି ଆର୍‌ ହିଲାର୍ନି ଅୟ୍‌ ହିଲାକ୍‌ ଦୁଦ୍‌ କାଳାଉତି ରେତି, ସେମଃନାର୍‌ ଗିନେ ବଃଡେ କଃସ୍ଟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ଇ ଗଃଟ୍‍ଣାମଃନ୍‌ ଜଃନ୍‌କଃରି କି ସିତ୍‌ ମାସେ ନଃଗେଟେ ଇତାର୍‌ ଗିନେ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ଇବାନ୍ୟା ଦୁକ୍‌ କଃସ୍ଟ୍‌ ଆସେଦ୍‌ ଜେ, ଇସ୍ୱର୍‌ ରାଇଜ୍‌ ଉବ୍‌ଜାୟ୍‌ଲା ଦିନ୍‌ହୁଣି ଆଜି ହଃତେକ୍‌ ସେବାନ୍ୟା କଃବେ ହେଁ ଅୟ୍‌ନଃରିଲି ଆର୍‌ କଃବେ ହେଁ ନଃଗେଟେ । ");
INSERT INTO bdv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଆର୍‌ ଇସ୍ୱର୍‌ ସେ ଦିନ୍‌କେ ଉଣା କଃରି ନଃରିଲେକ୍‌, ତଃବେ କେହେଁ ମୁକ୍ତି ହାଉଁ ନଃହାର୍‌ଲା ହୁଣି; ମଃତର୍‌ ଇସ୍ୱର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ବାଚି ଆଚେ, ସେ ବାଚ୍‌ଲା ଲକ୍‌ମଃନାର୍‌ ଗିନେ ସେଦିନ୍‌ମଃନ୍ ଉଣା କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ଆର୍‌ ଜଃଡେବଃଳ୍‌ କେ ତୁମିମଃନ୍‌କେ ‘କ୍ରିସ୍ଟ ଇତି ଆଚେ,’ କି, ‘ସେତିଆଚେ,’ ବଃଲି କୟ୍‌ଲେକ୍‌, ତୁମି ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ସଃଡେବଃଳ୍‌ ମିଚ୍ କ୍ରିସ୍ଟ ଆର୍‌ ମିଚ୍ ବାବ୍‌ବାଦିମଃନ୍ ବାରାଉତି, ଆର୍‌ ସେମଃନ୍ କଃତେକ୍‌ କଃତେକ୍‌ ଚିନ୍ ଦଃକାୟ୍‌କଃରି କଃତେକ୍‌ କଃତେକ୍‌ କାବା ଅଃଉତା କାମ୍‌ମଃନ୍‌ କଃର୍ତି; ଦଃର୍କାର୍‌ ଅୟ୍‌ଲେକ୍‌ ଇସ୍ୱର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ହେଁ ବୁଲ୍‌କାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ମଃତର୍‌ ତୁମି ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ଦଃକା ମୁଁୟ୍‌ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ତା ଆଗ୍‌ତୁ ତୁମିମଃନ୍‌କେ ସଃବୁ କଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ମଃତର୍‌ ସେ ସଃବୁ କଃସ୍ଟ୍‌ ହଃଚେ, ବେଳ୍‌ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜଃନ୍ ଉଜାଳ୍‌ ନଃଦେୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ଆରେକ୍‌ ସଃର୍ଗାର୍‌ ତାରାମଃନ୍ ତଃଳେ ଅଦ୍ରୁକ୍‌ ଦଃର୍ତି ଆର୍‌ ଅଃଗାସାର୍‌ ସଃକ୍ତିମଃନ୍ ଜଃତ୍‌କଃତ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ସଃଡେବଃଳ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ବଃଡେ ବଃଳ୍‌ ସଃକାତ୍‌ ଆର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ମେଗ୍ ଉହ୍ରେ ହୁଣି ଉତ୍ରି ଆସ୍ତାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ଦଃକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ସଃଡେବଃଳ୍‌ ସେ ଦୁତ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌କଃରି ହୁର୍ତିବିର୍‌ ସେସ୍‌ ସଃନ୍ଦିହୁଣି ଅଃଗାସାର୍‌ ସେସ୍‌ ସଃନ୍ଦି ହଃତେକ୍‌ ଚାରି ଦିଗାର୍‌ ଅଃହ୍‌ଣା ବାଚ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ରୁଣ୍ଡାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ଡୁମ୍ବୁର୍‌ ଗଃଚାର୍‌ ଗଟେକ୍‌ କଃତା ସିକା, ଜଃଡେବଃଳ୍‌ ତାର୍‌ କଃନ୍ଦାୟ୍‌ କଃଉଁଣା ହଃତାର୍‌ ଦଃରେଦ୍‌ ଆର୍‌ ଡାଳ୍‌ ହଃତାର୍‌ ଅୟ୍‌ ବାଡି ଆସେଦ୍‌, ସଃଡେବଃଳ୍‌ ତୁମି କଃରା ଦିନ୍ ଆସୁଲି ବଃଲି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ସେବାନ୍ୟା ଜଃଡେବଃଳ୍‌ ଇ ସଃବୁ ଗଃଟ୍‍ଣାମଃନ୍‌ ଗଃଟ୍‌ତାର୍‌ ଦଃକାସ୍‌, ସଃଡେବଃଳ୍‌ ତୁମି ସେ ଦିନ୍ ଦୁଆର୍‌ ଲଃଗେ ଅୟ୍‌ଲି ବଃଲି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ସଃବୁ ଗଃଟ୍‍ଣା ନଃଗଟ୍‌ତା ହଃତେକ୍‌ ଇ ଜୁଗାର୍‌ ଲକ୍‌ମଃନ୍ କଃବେ ହେଁ ନାସ୍‌ ନଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ଅଃଗାସ୍‌ ଆର୍‌ ହୁର୍ତିବି ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ମର୍‌ କଃତା କଃବେ ନଃସ୍ଟ୍‌ ନୟେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ମଃତର୍‌ ସେ ଦିନ୍ କି ବେଳା କଃବେ ଆସେଦ୍‌ ସେରି କେ ହେଁ ନଃଜାଣ୍‌ତି; ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନ୍ କି ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ନଃଜାଣେ, ମଃତର୍‌ ମର୍‌ ସଃର୍ଗାର୍‌ ଉବା ଏକ୍ଲା ହଃକା ଜାଣି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ତୁମିମଃନ୍ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ ଆର୍‌ ଜାଗିରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଦିନ୍ ଆର୍‌ ସେ ବେଳା କଃବେ ଆସେଦ୍‌ ସେରି ତୁମିମଃନ୍ ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ସେରି ଇବାନ୍ୟା, ଜଃନ୍‌କଃରି ଗଟେକ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃର୍‌ଦୁଆର୍‌ ଚାଡିକଃରି ବିନ୍ ଦେସେ ବାସାକଃରି ଆଚେ, ଆର୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ଗଃରାର୍‌ ଅଃଦିକାର୍‌ ଦଃୟ୍‌, ହଃତି ଲକାର୍‌ କାମ୍‌ ହଃତି ଲକ୍‌କେ ଦଃୟ୍‌ଆଚେ, ଆର୍‌ ଦୁଆର୍‌ ଜାଗ୍‌ତା ଲକ୍‌କେ ହେଁ ନିକକଃରି ଜାଗି ରେଉଁକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","କଃଡେବଃଳ୍‌ ସିନା ସେ ଗଃରାର୍‌ ସାଉକାର୍‌ ଲୁକ୍‌ଣେ ଆସେଦ୍‌ ଆର୍‌ ତୁମିମଃନ୍‌କେ ସଇରିଲାର୍‌ ଦଃକେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଇତାର୍‌ ଗିନେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ସଃଞ୍ଜ୍ ବେଳାୟ୍‌, କି ମଃଜାରାତି, କି କୁକ୍‌ଳା ବାସ୍ତା ବେଳାୟ୍‌ କି ସଃକାଳ୍ୟା, କଃଡେବଃଳ୍‌ କି ଆସେଦ୍‌ ସେରି ତୁମିମଃନ୍ ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜାୟ୍‌ରି କଃଉଁଲେ, ସେରି ସଃବ୍‌କେ କଃଉଁଲେ, ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ନିସ୍ତାର୍‌ ହଃର୍ବ୍‌ ଆର୍‌ କମିର୍‌ ନଃମିସ୍‌ଲା ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଅଃଉଁକେ ଦୁୟ୍‌ ଦିନ୍ ରିଲି, ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌, ଜିଉଦି ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍ ଜିସୁକେ କଃନ୍‌କଃରି କୁଟ୍‌କଃରି ମଃର୍ନେ ମାର୍ତି, ସେତାକ୍‌ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ହଃର୍ବ୍‌ ଦିନ୍ ଜିସୁକେ ବାନ୍ଦୁ ନଃହାରୁ, ସେବାନ୍ୟା କଃଲେକ୍‌ ଲକ୍‌ମଃନ୍ ରିସାଅୟ୍‌ ଉରାଟୁ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ବେତାନିଆ ଗାଉଁଆର୍‌ ବଃଡ୍‌ ରଗି ସିମନାର୍‌ ଗଃରେ ଜିସୁ କାଉଁକେ ବଃସି ରିଲାବଃଳ୍‌, ଗଟ୍‌ ମାୟ୍‌ଜି ତାର୍‌ ଟାଣେ ଆୟ୍‌ଲି, ସେ ଗଟ୍‌ କଣ୍ଡି ବଃର୍ତି ବଃଡେ ମଲାର୍‌ ବାସ୍ନା ଚିକଣ୍‌ ଆଣ୍‌ଲି, ଆର୍‌ ସେ ଚିକଣ୍‌ ନିର୍ମୁଳ୍‌ ଜଟାମାଂସି ଗଃଚାର୍‌ ରଃସେ ତିଆର୍‌ ଅୟ୍‌ରିଲି । ସେ ମାୟ୍‌ଜି କଃଣ୍ଡିର୍‌ ମୁଉଁ ବାଙ୍ଗିକଃରି ସଃର୍ତେ ଚିକଣ୍‌ ଜିସୁର୍‌ ମୁଣ୍ଡେ ଡାଳୁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ସେରି ଦଃକି ସେତିରିଲା ଲକ୍‌ମଃନ୍ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଇ ବାସ୍ନା ଚିକଣ୍‌ କାୟ୍‌ତାକ୍‌ ହର୍ଚ୍ କଃରୁଲି ? ");
INSERT INTO bdv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଇ ବାସ୍ନା ଚିକଣାର୍‌ ମଲ୍‌ ଗଟ୍‌ ଲକାର୍‌ ବଃର୍ସେକାର୍‌ କାମାଉଣି ସଃଙ୍ଗ୍ ସଃମାନ୍ । ଇରି ବିକ୍‌ଲା ଡାବୁ ନଃୟ୍‌ ବୁକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦେଉଁକେ ଅୟ୍‌ଲି ହୁଣି !” ଇବାନ୍ୟା ବଃଲି ସେମଃନ୍ ତାକ୍‌ ଲିନ୍ଦା କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ଜିସୁ କୟ୍‌ଲା, “ସେ ମାୟ୍‌ଜିକେ ଚାଡା; କାୟ୍‌ତାକ୍‌ ତାକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲାସ୍‌ ? ସେ ମର୍‌ ଗିନେ ନିକ କାମ୍‌ କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗଃରିବ୍‌ ଲକ୍‌ମଃନ୍ ତ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ଚଃମେ ଆଚ୍‌ତି, ତୁମି ଜଃଡେବଃଳ୍‌ ମଃନ୍ କଃରାସ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନାର୍‌ ଉହ୍‌କାର୍‌ କଃରୁ ହାରାସ୍‌ । ମଃତର୍‌ ମୁଁୟ୍‌ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗେ ନଃରେୟ୍‌ଁ । ");
INSERT INTO bdv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଇ ମାୟ୍‌ଜି ମର୍‌ ଗିନେ ତାର୍‌ ହାରୁସଃକ୍ତି ହଃତେକ୍‌ କଃଲି ଆଚେ, ସେ ତହ୍‌ତା ଗିନେ ମର୍‌ ମଃଲା ଗଃଗାଳ୍‌କେ ଆଗ୍‌ତୁ ଚିକଣ୍‌ ହାଦାୟ୍‌ ଦିଲି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଗୁଳା ଜଃଗତାର୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ ଅୟ୍‌ଦ୍‌, ସେ ଟାଣେ ଇ ମାୟ୍‌ଜିଟକିକ୍‌ ମଃନେ ହଃକାଉତା ଗିନେ ସେ କଃରି ରିଲା ଇ କାମାର୍‌ କଃତା ହେଁ କଃଉଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ସେତାକ୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ନାଉଁଆର୍‌ ଗଟ୍‌ ଚେଲା ବଃଡ୍ ଜାଜକ୍‌ମଃନାର୍‌ ଆତେ ଜିସୁକେ ସଃହ୍ରି ଦେଉଁକେ ସେମଃନାର୍‌ ଚଃମେ ଗଃଲା ");
INSERT INTO bdv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ବଃଡ୍ ଜାଜକ୍‌ ଜିଉଦାର୍‌ ଇବାନ୍ୟା କଃତା ସୁଣି ସଃର୍ଦା ଅୟ୍‌ଲା । ଜିସୁକେ ଦଃରାୟ୍‌ ଦିଲେକ୍‌ ଜିଉଦାକେ ଡାବୁ ଦେଉଁନ୍ଦ୍ ବଃଲି ସଃୟ୍‌ତ୍‌ କଃଲାୟ୍‌, ସେତାକ୍‌ ଜିଉଦା ଜିସୁକେ ବଃଡ୍ ଜାଜକ୍‌ମଃନାର୍‌ ଆତେ କଃନ୍‌କଃରି ଦଃରାୟ୍‌ ଦେଉଁ ହାରେ ଇ ଉପାୟ୍‌ ଲଳୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ତାର୍‌ହଃଚେ କମିର୍‌ ନୟ୍‌ଲା ରୁଟି କାତା ହଃର୍ବାର୍‌ ହଃର୍ତୁଦିନ୍, ଜୁୟ୍‌ଦିନ୍‌ ନିସ୍ତାର୍‌ ହଃର୍ବାର୍‌ ହୁଜାମେଣ୍ଡା ଦିଆ ଅୟ୍‌ଦ୍‌, ସେଦିନ୍ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ଆସି ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ କୁୟ୍‌ଟାଣେ ତର୍‌ଗିନେ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କଃରୁନ୍ଦ୍‌ ବଃଲି ତୁୟ୍‌ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ତାର୍‌ହଃଚେ ଜିସୁ ଜଳେକ୍‌ ଚେଲାକେ ଗଃଳ୍‌ ବିତ୍ରେ ହଃଟାୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଃଳ୍‌ ବିତ୍ରେ ଜାହା, ଆର୍‌ ହାଣିଡକା ବୟ୍‌ ଜାତା ଗଟ୍‌ଲକ୍‌ ତୁମିମଃନ୍‌କେ ବେଟ୍‌ ଅୟ୍‌ଦ୍‌, ତୁମି ତାର୍‌ ହଃଚେହଃଚେ ଜାହା । ");
INSERT INTO bdv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ସେ ଜୁୟ୍‌ ଗଃରେ ହୁରେଦ୍‌, ତୁମି ଜାୟ୍‌ ସେ ଗଃରାର୍‌ ମୁଳିକାକ୍‌ କଃଉଆ, ‘ଅଃମାର୍‌ ଗୁରୁ ହଃଚାରୁଲା, ମୁଁୟ୍‌ ଆର୍‌ ମର୍‌ ଚେଲାମଃନ୍ କୁୟ୍‌ ବଃକ୍ରାୟ୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କଃର୍ତାର୍‌ ଆଚେ ସେ ବଃକ୍ରା କୁୟ୍‌ତି ଆଚେ ?’ ");
INSERT INTO bdv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ସେ ଗଃରାର୍‌ ମୁଳିକା ତୁମିକେ ସୁନ୍ଦୁର୍‌କଃରି ସଃଜାୟ୍‌ଲାର୍‌ ଟିକ୍‌ଟାକ୍‌ ଅୟ୍‌ଲାର୍‌ ଉହ୍ରାର୍‌ ଗଟ୍‌ ବଃଡ୍ ବଃକ୍ରା ଦଃକାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେତି ଅଃମାର୍‌ ଗିନେ ବଜି ତିଆର୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ଗଃଳ୍‌ ବିତ୍ରେ ଗଃଳାୟ୍‌, ଆର୍‌ ଜିସୁ ଜଃନ୍‌କଃରି କୟ୍‌ରିଲା ସେତି ସେବାନ୍ୟା ଦଃକି ଚେଲାମଃନ୍ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଦିନାର୍‌ ବଜି ତିଆର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ଜିସୁ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଦଃରି ସେତି ଜାୟ୍‌ ହଚ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ସେମଃନ୍ ମିସ୍‌ଣେ ବଃସି କାତାବଃଳ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ତୁମାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ମାନାୟ୍‌ ମକ୍‌ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ କି ମର୍‌ ସଃଙ୍ଗ୍ ବଃସି କାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଚେଲାମଃନ୍ ମଃନ୍ଦୁକ୍‌ କଃରି ଏକ୍ଲା ଏକ୍ଲା ତାକ୍‌ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ସେ କାୟ୍‌ ମୁଁୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମି ବାର ଲକାର୍‌ ବିତ୍ରେ ଏକ୍ଲା, ଜେ କି ମର୍‌ ସଃଙ୍ଗ୍ କପାୟ୍‌ ଆତ୍‌ ବୁଡାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ କଃତା ଜଃନ୍‌କଃରି ସାସ୍ତରେ ଲେକା ଆଚେ, ସଃନ୍‌କଃରି ସେ ମଃରୁକ୍‌ ଜଃଉଁଲା ସଃତ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲକାର୍‌ ଆତେହୁଣି ନଃରାର୍‌ ହୟ୍‌ସି ସଃହ୍ରି ଅଃଉଁଲା, ସେ ଅଃପର୍‌ବଳ୍‌ ଡଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌, ସେମାନାୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ନଃରିଲେକ୍‌ ତାର୍‌ ଗିନେ ବଃଲ୍‌ ଅୟ୍‌ଲି ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ସଃବୁଲକ୍‌ ବଃସି କାତାବଃଳ୍‌ ଜିସୁ ରୁଟି ଦଃରି ଆସିର୍ବାଦ୍‌ କଃଲା ଆର୍‌ ସେରି ବାଙ୍ଗାୟ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲା, “ନିଆ, ଇରି ମର୍‌ ଗଃଗାଳ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଆର୍‌ କପାୟ୍‌ ରିଲା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଦଃରି ସେତାର୍‌ ଗିନେ ହେଁ ପାର୍ତ୍‌ନା କଃଲା ଆର୍‌ ସେମଃନ୍‌କେ ଦିଲା, ଆର୍‌ ସେମଃନ୍ ସେତିର୍‌ ଡୁକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ ବିଦିର୍‌ ବଃନି ସଃବୁ ଲକାର୍‌ ଗିନେ ଦେଉଁଲେ, ଇରି ମର୍‌ ସେ ବଃନି । ");
INSERT INTO bdv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମୁଁୟ୍‌ ଜୁୟ୍‌ଦିନ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜେ ନଃଉଆଁ କଃରି ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଡୁକିନ୍ଦ୍, ସେଦିନ୍ ହଃତେକ୍‌ ଇରି ଆର୍‌ କଃବେ ହେଁ ନଃଡୁକି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଆରେକ୍‌ ସେମଃନ୍ ଦନ୍ୟବାଦ୍‌ ଗିତ୍‌ କୟ୍‌ଲା ହଃଚେ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ମକ୍‌ ଚାଡି ହଃଳାଉଆସ୍‌, ଇରି ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଆଚେ, ‘ମୁଁୟ୍‌ ଗଃଉଳିଆକେ ମଃର୍ନେ ମାରିନ୍ଦ୍, ଆର୍‌ ମେଣ୍ଡାମଃନ୍ ଏଣେ ତେଣେ ହଃଳାଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ମଃତର୍‌ ମୁଁୟ୍‌ ମଃରିକଃରି ଆରେକ୍‌ ଉଟ୍‌ଲା ହଃଚେ, ତୁମାର୍‌ ଆଗେ ଗାଲିଲିକେ ଜାୟ୍‌ନ୍ଦ୍ ।’” ");
INSERT INTO bdv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ମଃତର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ସଃବୁ ଚେଲାମଃନ୍ ଚାଡି ଗଃଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ କଃବେ ଚାଡି ନଃଜାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତକେ ସଃତ୍‌ କଃଉଁଲେ, ଆଜି ଇ ରାତି କୁକ୍‌ଳା ଦୁୟ୍‌ତର୍‌ ବାସ୍ତା ହଃର୍ତୁ ତୁୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି ତିନିତର୍‌ କଃଉସି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ମଃତର୍‌ ପିତର୍‌ ଇ କଃତା ସୁଣି ଅଃଟୁଆ କଃରି କୟ୍‌ଲା, “ମକ୍‌ ତର୍‌ ସଃଙ୍ଗ୍ ମଃରୁକ୍‌ ଅୟ୍‌ଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ ତକେ ନଃଜାଣି ବଃଲି କଃବେ ନଃକୟ୍‌ଁ ।” ସଃବୁ ଚେଲାମଃନ୍ ହେଁ ସେବାନ୍ୟା କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗେତ୍‌ସିମନି ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଟାଣେ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତା ହଃତେକ୍‌ ଇତି ବଃସି ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଆରେକ୍‌ ଜିସୁ ତାର୍‌ ସଃଙ୍ଗ୍ ପିତର୍‌, ଜାକୁବକ୍‌ ଆର୍‌ ଜହନ୍‌କେ ନିଲା, ଆର୍‌ ଅଃପର୍‌ବଳ୍‌ କାବା ଅୟ୍‌ଲା ଆର୍‌ ବଃଡେ ଆର୍ଲା ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ହଃରାଣ୍ ମଃର୍ତା ହର୍‌ ଉକ୍‌ଳି ଜଃଉଁଲି, ତୁମିମଃନ୍ ଇତି ରଃୟ୍‌ ଜାଗିରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜିସୁ ସେମଃନ୍ ଚାଡି କଃଣ୍ଡେକ୍‌ ଦୁରିକ୍‌ ଜାୟ୍‌ ବୁୟେଁ ମାଣ୍ଡି କୁଟା ଟେସି ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଜଦି ଅଃଉଁ ହାରେ, ତଃବେ ଇ ବେଳା ମର୍‌ ତଃୟ୍‌ହୁଣି ଗୁଚି ଜଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଆରେକ୍‌ ସେ କୟ୍‌ଲା, “ଏ ମର୍‌ ଉବା, ତର୍‌ ଆତେ ସଃବୁ ଅଃଉଁ ହାରେ, ଇ କଃସ୍ଟାର୍‌ ଡୁକ୍‌ତା କପା ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌କଃର୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ମର୍‌ ଇଚା ନୟ୍‌, ତର୍‌ ଇଚା ହୁରୁଣ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଆରେକ୍‌ ତାର୍‌ହଃଚେ ଜିସୁ ବାଉଳି ଆୟ୍‌ଲା ଆର୍‌ ତିନିଗଟ୍‌ ଚେଲା ନିଦଉତି ରିଲାର୍‌ ଦଃକିକଃରି ସିମନ୍‌କେ କୟ୍‌ଲା, “ପିତର୍‌ ତୁୟ୍‌ କାୟ୍‌ ସୟ୍‌ଆଚ୍‌ସି ? ଚଃନେକ୍‌ହେଁ କାୟ୍‌ ଚେତା ରେଉଁ ନାହାର୍ଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ହାନ୍ଦାୟ୍‌ ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ନଃହେଳାସ୍‌, ସେତାର୍‌ଗିନେ ଜାଗିରଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରା । ଆତ୍ମାର୍‌ ଇଚା ସଃତ୍‌, ମଃତର୍‌ ଗଃଗାଳ୍‌ ଦୁର୍ବୁଳ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଜାୟ୍‌ ଆଗାର୍‌ ହର୍‌ କୟ୍‌ ପାର୍ତ୍‌ନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ତାର୍‌ହଃଚେ ଆରେକ୍‌ ବାଉଳି ଆସି ଚେଲାମଃନ୍‌କେ ସଇରିଲାର୍‌ ଦଃକ୍‌ଲା; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନାର୍‌ ଆକି ଡାହି ଅଃଉତି ରିଲି, ଆର୍‌ ସେମଃନ୍ କାୟ୍‌ରି ଉତୁର୍‌ ଦେଉଁନ୍ଦ୍ ବଃଲି ଜାଣି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଇ ସଃଙ୍ଗ୍ ତିନିତର୍‌ ଜିସୁ ବାଉଳି ଆସି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଚଃନେକ୍‌ ସଇକଃରି ବିସାଉଆ; ବୁତେକ୍‌ ବେଳ୍‌ ଅୟ୍‌ଲି; ନଃରାର୍‌ ହୟ୍‌ସି ହାହିମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅଃଉତା ବେଳା ଅୟ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ଉଟା, ଅଃମିମଃନ୍‌ ଜୁଆଁ, ହଦେ ଦଃକା ! ଜେ ମକ୍‌ ସଃତ୍ରୁର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେ ମର୍‌ ଲଃଗେ ଆସି କେଟ୍‌ଲାବେ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଆର୍‌ ସେଦାହ୍ରେ ସେ କଃତା ଅଃଉତାବଃଳ୍‌ ବାରଗଟ୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଜିଉଦା ନାଉଁଆର୍‌ ଚେଲା ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ବଃଡ୍ ଜାଜକ୍‌, ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଲକ୍‌ମଃନ୍ କଃଣ୍ଡା ଆର୍‌ ଟେଙ୍ଗା ଦଃରି ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଜିସୁକେ ସଃତ୍ରୁ ଆତେ ଦଃରାୟ୍‌ ଦେତା ଜିଉଦା ସେମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ରିଲା, “ମୁଁୟ୍‌ ଜାକେ ଚୁମିନ୍ଦ୍ ସେ ହଃକା ଜିସୁ ତାକ୍‌ ଜଃତୁନେ ଦଃରି ନିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଇତାକ୍‌ ଜିଉଦା ହଚୁହଚୁ ଜିସୁର୍‌ ଲଃଗେ ଗଃଲା ଆର୍‌ “ଏ ଗୁରୁ !” ବଃଲି ଚୁମ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ଜିସୁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ବାନ୍ଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ମଃତର୍‌ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ମାନାୟ୍‌ କଃଣ୍ଡା ବାର୍‌କଃରି ମୁଳ୍‌ ଜାଜକାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାର୍‌ କାନ୍‌ କାଟି ହଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଚର୍‌ମଃନାର୍‌ ବିରଦେ ବାରାୟ୍‌ଲା ହର୍‌ କଃଣ୍ଡା ଆର୍‌ ଟେଙ୍ଗା ଦଃରି କାୟ୍‌ ମକ୍‌ ଦଃରୁକ୍‌ ଆୟ୍‌ଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ମୁଁୟ୍‌ ଦିନେକେ ମନ୍ଦିର୍‌ ଗଃରେ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ସିକ୍ୟା ଦେତି ରିଲେ, ମଃତର୍‌ ତୁମି ମକ୍‌ ଦଃରୁ ନଃଚ୍‌ଲାସ୍‌, ମଃତର୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ଁ ଲେକା ଅୟ୍‌ଲା କଃତା ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ସେତାକ୍‌ ଇରି ଅଃଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ତାର୍‌ହଃଚେ ସଃବୁ ଚେଲାମଃନ୍ ଜିସୁକେ ଚାଡି ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମଃତର୍‌ ଗଟ୍‌ ବେଣ୍ଡ୍ୟା ମାନାୟ୍‌ ଡୁମ୍‌ଣ୍ଡା ଗଃଗାଳେ ଗଟ୍‌ ହଃଚ୍ୟା ହୁଙ୍ଗ୍ରି ଜିସୁର୍‌ ହଃଚେହଃଚେ ଜାତାର୍‌ ଦଃକି, ସେମଃନ୍ ସେ ବେଣ୍ଡ୍ୟା ମାନାୟ୍‌କେ ଦଃରୁକ୍‌ ମୁଣ୍ଡ୍ୟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ମଃତର୍‌ ସେ ତାର୍‌ ହାତୁଳ୍‌ ହଃଚ୍ୟା ହିଙ୍ଗିକଃରି ଡୁମ୍‌ଣ୍ଡା ଗଃଗାଳେ ହଃଳାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିସୁକେ ମୁଳ୍‌ ଜାଜକ୍‌ ଲଃଗେ ନିଲାୟ୍‌, ଆରେକ୍‌ ବଃଡ୍ ଜାଜକ୍‌, ପାରାଚିନ୍‌ମଃନ୍ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଆସି ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର୍‌ ଦୁରିକ୍‌ ରଃୟ୍‌ ତାକାର୍‌ ହଃଚେହଃଚେ ଜାୟ୍‌ ମୁଳ୍‌ ଜାଜକାର୍‌ କୁଆଳେ ହୁରି ଜାଗୁଆଳିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜୟ୍‌ ଚେକୁକ୍‌ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଜିଉଦି ବଃଡ୍ କୁଟୁମାର୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ ତାର୍‌ ବିରଦେ ସାକି ଲଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ହାଉଁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ତାର୍‌ ବିରଦେ ମିଚ୍ ସାକି ଦିଲେକ୍‌ ହେଁ କାର୍‌ କଃତା କାକେ ନଃମିସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ତାର୍‌ହଃଚେ କଃତିଲକ୍‌ ଟିଆଅୟ୍‌ ତାର୍‌ ବିରଦେ ସାକି ଦେଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ଅଃମି ଇ କଃତା ତାର୍‌ ଟଣ୍ଡେହୁଣି କଃଉତାର୍‌ ସୁଣିଆଚୁ, ‘ମୁଁୟ୍‌ ମାନାୟ୍‌ ଆତେ ବାନ୍ଦ୍‌ଲା ମନ୍ଦିର୍‌କେ ବଃସ୍ଳାୟ୍‌କଃରି, ତିନିଦିନ୍ ବିତ୍ରେ ଆରେକ୍‌ ଗଟେକ୍‌ ମାନାୟ୍‌ର୍‌ ଆତ୍‌ ତିଆର୍‌ ନଃକେର୍ତା ମନ୍ଦିର୍‌ ତିଆର୍‌ କଃରିନ୍ଦ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ମଃତର୍‌ ଇ କଃତା ହେଁ ସାକି ଲଃଗେ ନଃମିସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ସେତାର୍‌ଗିନେ ମୁଳ୍‌ ଜାଜକ୍‌ ଉଟି ମଃଜାୟ୍‌ ଟିଆ ଅୟ୍‌ ଜିସୁକେ ହଃଚାର୍ଲା, “ତର୍‌ ବିରଦେ ଲକ୍‌ମଃନ୍ ଜୁୟ୍‌ ସାକି ଦେଉଁଲାୟ୍‌, ତାର୍‌ କାୟ୍‌ ଉତୁର୍‌ ନଃଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମଃତର୍‌ ଜିସୁ ତୁନ୍‌ହାଳି ରିଲା, କାୟ୍‌ହେଁ ଉତୁର୍‌ ନଃଦିଲା ମୁଳ୍‌ ଜାଜକ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଉହ୍‌କାର୍‌ କାରି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି କ୍ରିସ୍ଟ ?” ");
INSERT INTO bdv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ହିଁ ମୁଁୟ୍‌ ସେ, ଆର୍‌ ତୁମିମଃନ୍ ମୁଁୟ୍‌ ଜେ ନଃରାର୍‌ ହୟ୍‌ସି, ସଃବ୍‌କେ ବଃଡ୍ ସଃକ୍ତିମାନାର୍‌ କାତାବାଟ୍ୟା ବଃସ୍ତାର୍‌ ଆର୍‌ ଅଃଗାସ୍‌ ମେଗ୍‌ମାଳେ ଆସ୍ତାର୍‌ ଦଃକାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ମୁଳ୍‌ ଜାଜକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆଙ୍ଗି ଚିରି କୟ୍‌ଲା, “ଅଃମିକ୍‌ ଆରେକ୍‌ ଅଃଦିକ୍‌ ସାକିର୍‌ କାୟ୍‌ ଲଳା ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ତୁମିମଃନ୍ ଇସ୍ୱର୍‌କେ ଲିନ୍ଦା କଃର୍ତାର୍‌ ସୁଣ୍‌ଲାସ୍‌, ତୁମାର୍‌ ମଃନେ କାୟ୍‌ ବିଚାର୍‌ କଃରୁଲାସ୍‌ ?” ସେତାକ୍‌ ସେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଅ ବଃଲି ସଃବୁଲକ୍‌ ଦସି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଆରେକ୍‌ କେ କେ ଜିସୁର୍‌ ଉହ୍ରେ ତୁକୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ମୁୟେ ତୁଆଲ୍‌ ବାନ୍ଦ୍‌ଲାୟ୍‌ ଆର୍‌ ବିଦା ମାରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତୁୟ୍‌ ତ ଗଟେକ୍‌ ବାବ୍‌ବାଦି, ତକ୍‌ କେ ମାର୍ଲା କଃଉ ? ଇବାନ୍ୟା କୟ୍‌ ଜାଗୁଆଳିମଃନ୍ ଚାହୁଳ୍‌ ମାରିମାରି ତାକ୍‌ ଦଃରି ନିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ସଃଡେବଃଳ୍‌ କୁଆଳେ ପିତର୍‌ ରିଲାବଃଳ୍‌, ମୁଳ୍‌ ଜାଜକାର୍‌ ଦଃଙ୍ଗ୍‌ଳି ପିତର୍‌କେ ଜୟ୍‌ ଚେକ୍‌ତାର୍‌ ଦଃକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଆର୍‌ ପିତର୍‌କେ ନିକ କଃରି ଦଃକି କୟ୍‌ଲି, “ତୁୟ୍‌ ହେଁ ନାଜରିତ୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ରିଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ମଃତର୍‌ ପିତର୍‌ ନାୟ୍‌ ବଃଲି କାୟ୍‌ଲା, “ତାକ୍‌ ମୁଁୟ୍‌ ନଃଜାଣି ଆର୍‌ ତୁୟ୍‌ କାୟ୍‌ ବଃଲି କଃଉଁଲିସ୍‌ ମୁଁୟ୍‌ ନଃବୁଜୁଲେ ।” ଇରି କୟ୍‌ ସେ ହଃଦା ବାଟ ବାରାୟ୍‌ ଗଃଲା । ଆର୍‌ ସଃଡେବଃଳ୍‌ ହଃକା କୁକ୍‌ଳା ଡାକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆରେକ୍‌ ସେ ଦଃଙ୍ଗ୍‌ଳି ତାକ୍‌ ଦଃକି ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍‌କେ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ କଃଉଁକେ ଦଃର୍ଲି, “ଇ ଲକ୍‌ ହେଁ ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ମଃତର୍‌ ପିତର୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ନାୟ୍‌ ବଃଲି କଃଉଁକେ ଦଃର୍ଲା । ଚଃନେକ୍‌ ରିଲାହଃଚେ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ତାର୍‌ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ପିତର୍‌କେ କୟ୍‌ଲାୟ୍‌, “ବାୟ୍‌ଦ୍‌ରେ ତୁୟ୍‌ ହେଁ ସେ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ତ ଗାଲିଲିର୍‌ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ମଃତର୍‌ ସେ ନିଜ୍‌କେ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ ଆର୍‌ ହଃର୍ମାଣ୍‌ କଃଉଁକେ ଦଃର୍ଲା, “ତୁମିମଃନ୍ ଜୁୟ୍‌ ମାନାୟ୍‌ର୍‌ କଃତା କଃଉଁଲାସ୍‌ ତାକ୍‌ ମୁଁୟ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ସେଦାହ୍ରେ ଦୁୟ୍‌ତର୍‌ କୁକ୍‌ଳା ବାସ୍‌ଲି, ସଃଡେବଃଳ୍‌, “ଦୁୟ୍‌ତର୍‌ କୁକ୍‌ଳା ବାସ୍ତା ଆଗ୍‌ତୁ ତୁୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି ତିନିତର୍‌ କଃଉସି,” ଇ କଃତା ଜିସୁ ପିତର୍‌କେ କୟ୍‌ରିଲା, ସେ କଃତା ତାକ୍‌ ଏତୁହଃଳ୍‌ଲି, ଆର୍‌ ସେ କଃତା ଏତାୟ୍‌ କାନ୍ଦୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ସଃକାଳ୍‌ ଅୟ୍‌ଲା ଦାହ୍ରେ ବେରାଣ୍‌ମଃଣ୍ଡାର୍‌ ପାରାଚିନ୍‌ମଃନ୍, ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ବେରାଣ୍ କଃରି ଜିସୁକ୍‌ ବାନ୍ଦିନଃୟ୍‌ ପିଲାତର୍‌ ଆତେ ସଃହ୍ରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ ଜିସୁକେ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଜିଉଦିମଃନାର୍‌ ରଃଜା ?” ଜିସୁ ତାକେ ଉତୁର୍‌ ଦିଲା, “ତୁୟ୍‌ ତ ନିଜେ କୟ୍‌ଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଜିସୁର୍‌ ବିରଦେ ଗାଦେକ୍‌ ଦଃସ୍‌ ଲାଦୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ପିଲାତ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଉତୁର୍‌ ହେଁ ନଃଦେଉଁଲିସ୍‌, ଦଃକ୍‌ ସେ ଲକ୍‌ମଃନ୍ ତର୍‌ ବିରଦେ କଃତେକ୍‌ ଦଃସାର୍‌ କଃତା କଃଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ମଃତର୍‌ ଜିସୁ କାୟ୍‌ବଃଲିହେଁ ଉତୁର୍‌ ନଃଦିଲା ଲାଗି ପିଲାତ କାବା ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ମଃତର୍‌ ସଃବୁ ନିସ୍ତାର୍‌ ହଃର୍ବବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ଜୁୟ୍‌ କଃୟ୍‌ଦିକେ ମାଗ୍‌ତି ରିଲାୟ୍‌ ସେ କଃୟ୍‌ଦିକେ ସେମଃନ୍‌କାର ଗିନେ ପିଲାତ ଚାଡି ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସଃର୍କାର୍‌ ବିରଦେ ଉଟି ଉରାଟୁ କଃରି ନଃର୍‌ ଅଃତ୍ୟା ହେଁ କଃର୍ତି ରିଲାୟ୍‌, ସେମଃନ୍‌କେ ଜଃଇଲେ ହୁରାଉତି ରିଲାୟ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ ବାରବା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ସେତାକ୍‌ ପିଲାତର୍‌ ଲଃଗେ ଲକ୍‌ମଃନ୍ ଜାୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ବିଦି ହଃର୍କାରେ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ପିଲାତ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ ଜିଉଦିମଃନାର୍‌ ରଃଜାକ୍‌ ତୁମାର୍‌ ଗିନେ ଚାଡିନ୍ଦ୍ ବଃଲି ତୁମି କାୟ୍‌ ମଃନ୍ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଡାରା ଅୟ୍‌କଃରି ଜିସୁକେ ତାର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ ଆଚ୍‌ତି ବଃଲି ପିଲାତ ଜାଣିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମଃତର୍‌ ପିଲାତ ଜଃନ୍‌କଃରି ସେମଃନାର୍‌ ଗିନେ ବାରବାକେ ଚାଡେଦ୍‌ ସେତାର୍‌ ଗିନେ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ସିକାଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ମଃତର୍‌ ପିଲାତ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଲକ୍‌ମଃନ୍ଦାକେ କୟ୍‌ଲା, “ତଃବେ ତୁମିମଃନ୍ ଜାକେ ଜିଉଦିମଃନାର୍‌ ରଃଜା ବଃଲି କଃଉଁଲାସ୍‌ ତାକ୍‌ ମୁଁୟ୍‌ କାୟ୍‌କଃରିନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଲକ୍‌ମଃନ୍ଦାମଃନ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ପିଲାତ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “କାୟ୍‌ତାକ୍‌ ! ସେ କାୟ୍‌ ଦଃସ୍‌ କଃରିଆଚେ ?” ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ଅଃଦିକ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକେ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ତଃବାର୍‌ ଗିନେ ପିଲାତ ଲକ୍‌ମଃନ୍ଦାକେ ସଃର୍ଦା କଃରୁକେ ମଃନ୍‌କଃରି ତାକାର୍‌ ଗିନେ ବାରବାକେ ଚାଡି ଦିଲା; ଆର୍‌ ଜିସୁକେ କର୍ଡା ସଃଙ୍ଗ୍ ମାରାୟ୍‌କଃରି କ୍ରୁସ୍‌ କାଟେ ଚଃଗାଉଁକ୍‌ ସେମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସେତାକ୍‌ ସଃଇନ୍‌ମଃନ୍ ଜିସୁକେ ପିଲାତର୍‌ କୁଆଳ୍‌ ବିତ୍ରେ ନିଲାୟ୍‌ ଆର୍‌ ସଃବୁ ସଃଇନ୍ ଦଃଳ୍‌କେ କୁଦିକଃରି ରୁଣ୍ଡାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ସେମଃନ୍ ଜିସୁକେ ବେଜା ରଃଙ୍ଗାର୍‌ ମଃସିଣ୍‌ ବଃସ୍ତର୍‌ ଆର୍‌ କାଟାର୍‌ ମୁକୁଟ୍‌ ତିଆର୍‌କଃରି ମୁଣ୍ଡେ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିସୁକେ “ଜିଉଦିମଃନାର୍‌ ରଃଜା ଜୁଆର୍‌ ।” ଇବାନ୍ୟା ବଃଲି କୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଟାହ୍ରା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ଆରେକ୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ମୁଣ୍ଡେ ଡାଙ୍ଗ୍ ସଃଙ୍ଗ୍ ମାର୍ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ମୁଏଁ ତୁକ୍‌ତି ରିଲାୟ୍‌; ଆର୍‌ ମାଣ୍ଡିକୁଟା ଟେସି ଜୁଆର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ସେମଃନ୍ ତାକ୍‌ ଇବାନ୍ୟା କଃରି କିଜ୍ୟାୟ୍‌ଲା ହଃଚେ ସେ ବେଜା ରଃଙ୍ଗାର୍‌ ବଃସ୍ତର୍‌ ଇଟାୟ୍‌କଃରି ତାର୍‌ ନିଜାର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌; ତାର୍‌ହଃଚେ ଜିସୁକେ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାୟ୍‌ ମାରୁକ୍‌ ହଃଦାୟ୍‌ ବାର୍‌କଃରି ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ସଃଡେବଃଳ୍‌ ଆଲେକ୍‌ଜେଣ୍ଡାର୍‌ ଆର୍‌ ରୁପର୍‌ ଉବାସି ସିମନ୍ ନାଉଁଆର୍‌ ଗଟେକ୍‌ କୁରିଣିୟ ଲକ୍‌ ତାକାର୍‌ ଗାଉଁଏ ହୁଣି ଆୟ୍‌ଲା ଆର୍‌ ସେବାଟ୍‌ ହାକ୍‌ମାରି ଜାତିରିଲାବଃଳ୍‌ ତାକ୍‌ ଜିସୁର୍‌ କ୍ରୁସ୍‌ କାଟ୍‌ ବୟ୍‌ ନେଉଁକେ ବଃଳ୍‌ମତ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ସେମଃନ୍ ଜିସୁକେ “ଗଲ୍‌ଗତା,” ବଃଲେକ୍‌, “କଃହାଳ୍‌” ନାଉଁଆର୍‌ ଡଙ୍ଗ୍ରେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଆର୍‌ ସେମଃନ୍ ଗଃନ୍ଦ୍‌ ରଃସ୍‌ ମିସ୍‌ଲା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଜିସୁକେ କାଉଁକେ ଦିଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ସେରି କାଉଁକେ ନଃଚ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଜିସୁକେ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାୟ୍‌ଲାୟ୍‌; ଆର୍‌ ଜିସୁର୍‌ ବଃସ୍ତର୍‌ କେ କାୟ୍‌ରି ହାଉତି ବଃଲି କେଳି ବାଚିକଃରି ତାର୍‌ ବଃସ୍ତର୍‌ସଃବୁ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିତ୍ରେ ବାଟାକଃରି ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ଜିସୁକେ ଦିନ୍ ନଅଗାଟା ବଃଳ୍‌ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଆର୍‌ ତାକାର୍‌ ଲିନ୍ଦା ହଃଟାୟ୍‌ “ଏ ଜିଉଦିମଃନାର୍‌ ରଃଜା” ବଃଲି ଜିସୁର୍‌ ମୁଣ୍ଡ୍ ଉହ୍ରାର୍‌ କାଟେ ମାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଆରେକ୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କାତାବାଟ୍ୟା ଏକ୍ଲାକେ ଆର୍‌ ଡେବ୍ରିବାଟ୍ୟା ଏକ୍ଲାକେ ଇବାନ୍ୟା କଃରି ଜଳେକ୍‌ କଃଙ୍ଗାର୍‌କେ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ସେତାକ୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତରେ ଲେକା ଅୟ୍‌ରିଲା ଇ କଃତା ସଃତ୍‌ ଅୟ୍‌ଲି, ସେତି ଲେକା ଆଚେ, ସେ ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଃଣ୍‌ତି ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଆର୍‌ ସେବାଟ୍‌ ଦଃୟ୍‌ ଜାତା ଆସ୍ତା ଲକ୍‌ମଃନ୍ ନିଜାର୍‌ ମୁଣ୍ଡ୍ ଜଲାୟ୍‌ ଜଲାୟ୍‌ ଜିସୁର୍‌ ବିରଦେ ଲିନ୍ଦା କଃତା କଃଉତି ରିଲାୟ୍‌, “ଏ ହୁଣି ମନ୍ଦିର୍‌ ବଃସ୍ଳାୟ୍‌କଃରି ତିନିଦିନ୍ ବିତ୍ରେ ତିଆର୍‌ କଃରୁ । ");
INSERT INTO bdv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ଅଃବେ କ୍ରୁସ୍‌ କାଟେହୁଣି ଉତ୍ରି ଆଉ ଆର୍‌ ନିଜ୍‌କେ ବଚାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ସେବାନ୍ୟା ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ହେଁ ଦଃର୍ମ୍‌ ଗୁରୁମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସିକଃରି ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌, “ସେ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ ବାଚାୟ୍‌ଲା, ମଃତର୍‌ ସେ ଅଃବେ ନିଜ୍‌କେ ବଚାଉଁ ନଃହାରୁଲା ! ");
INSERT INTO bdv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ତୁୟ୍‌ ଜଦି ସଃତ୍‌କଃରି ଇସ୍ରାଏଲ୍‌ ରଃଜା କ୍ରିସ୍ଟ, ଅଃବେ କ୍ରୁସ୍‌ କାଟେହୁଣି ଉତ୍ରି ଆଉ, ତଃବେ ଅଃମି ତକେ ସଃତ୍‌ କଃରୁନ୍ଦ୍‌ ।” ଆର୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସ୍‌ କାଟେ ଚଃଗାୟ୍‌ଲା ଦୁୟ୍‌ ଲକ୍‌ ହେଁ ସେବାନ୍ୟା କଃରି ଜିସୁକେ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ସେଦିନ୍‌ ମଃୟ୍‌ଦାନ୍‌ ମୁଣ୍ଡେବଃଳ୍‌ହୁଣି ତିନି ଗଃଟାହଃତେକ୍‌ ଦେସ୍‌ଜାକ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ତିନି ଗଃଟା ବଃଳ୍‌ ଜିସୁ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା “ଏଲହି, ଏଲହି, ଲାମା ସାବାକ୍‌ତାନି । ବଃଲେକ୍‌, ଏ ମର୍‌ ଇସ୍ୱର୍‌, ଏ ମର୍‌ ଇସ୍ୱର୍‌, ମକେ କାୟ୍‌ କଃରୁକେ ହାକ୍ରେହଃକାୟ୍‌ ଆଚ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ତାର୍‌ ଇ କଃତା ସୁଣି କଃତିଲକ୍‌ କୟ୍‌ଲାୟ୍‌, “ସୁଣା ସେ ଏଲିୟକେ କୁଦୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ଦଃବ୍‌ଳିଜାୟ୍‌ କଃଣ୍ଡେକ୍‌ ସ୍ପଞ୍ଜ୍‌କେ ହିତା ରସେ ବାଡାୟ୍‌ ଗଟେକ୍‌ ବେତ୍‌ ଡାଙ୍ଗ୍ ଟିହେ ବାନ୍ଦି ସେରି ଜିସୁର୍‌ ଅଟି ଲଗେ ଟେକି ଦଃୟ୍‌ କୟ୍‌ଲା, “ରିଆ ଦଃକୁଆଁ, ତାକେ କ୍ରୁସେହୁଣି ଉତ୍ରାୟ୍‌ ଆଣୁକେ ଏଲିୟ ଆସୁଲାକି ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ଜିସୁ ସେଦାହ୍ରେ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ ଜିବନ୍ ଚାଡ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ମନ୍ଦିର୍‌ ବିତ୍ରାର୍‌ ଜଲ୍‌ତିରିଲା ପର୍ଦା ଉହ୍ରେ ହୁଣି ତଃଳେ ହଃତେକ୍‌ ଦୁୟ୍‌କଃଣ୍ଡ୍‌ ଅୟ୍‌ ଚିରି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ଗଟ୍‌ ଇଜାର୍‌ ମଃନାର୍‌ ମୁଳିକା ଜିସୁର୍‌ କ୍ରୁସ୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ ଜିସୁ କଃନ୍‌କଃରି ଜିବନ୍ ଚାଡ୍‌ଲା ସେରି ଦଃକ୍‌ତି ରିଲା । ସେ କୟ୍‌ଲା, “ଇ ମାନାୟ୍‌ ସଃତ୍‌କଃରି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","କଃତିଗଟ୍‌ ମାୟ୍‌ଜିମଃନ୍‌ ଦୁରି ଟିଆ ଅୟ୍‌ ଦଃକ୍‌ତି ରିଲାୟ୍‌ । ସେମଃନାର୍‌ ବିତ୍ରେ ରିଲି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ସାନ୍ ଜାକୁବ ଆର୍‌ ଜସିର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ଆର୍‌ ସଲମି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଜିସୁ ଗାଲିଲିଏ ରେତା ବଃଳ୍‌ ସେମଃନ୍ ତାର୍‌ ସେବାକାରି ଅୟ୍‌ ଉହ୍‌କାର୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ତାର୍‌ ସଃଙ୍ଗ୍ ଜିରୁସାଲମ୍‌କେ ଆସିରିଲା ଗାଦେକ୍‌ ମାୟ୍‌ଜି ଲକ୍‌ମଃନ୍ ହେଁ ସେତି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ବିସାଉଁଣି ଦିନ୍‌ ଆଗ୍‌ତୁ ଆରାମାତିଆର୍‌ ଜସେପ୍ ଆସି ହଚ୍‌ଲା । ସେ ବଃଡ୍‌ ପଞ୍ଚାୟ୍‌ତାର୍‌ ବଃଡେ ମାୟ୍‌ନାର୍‌ ଲକ୍‌ରିଲା ଆର୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌କେ ଜାଗ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ସେଦିନ୍‌ ସଃବୁ ଜଃଗ୍ରାତ୍‌ ଅଃଉତା ବିନ୍ ବଃଲେକ୍‌ ବିସାଉଁଣି ଦିନାର୍‌ ଆଗାର୍‌ ଦିନ୍ । ହାରାମାତିଆର୍‌ ଜସେପ୍ ନଃଡିରି କଃରି ପିଲାତ ହାକ୍‌ ଜାୟ୍‌ ଜିସୁର୍‌ ମଃଲା ଗଃଗାଳ୍‌ ନେଉଁକେ ମାଗ୍‌ଲା ଜେକି ସେ ନିଜେ ହେଁ ଇସ୍ୱରାର୍‌ ସଃର୍ଗ୍‌ ରାଇଜାର୍‌ ଆସା କଃରିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ଜିସୁ ସଃଡେବଃଳ୍‌ ମଃରି ଗଃଲାର୍‌ ସୁଣିକଃରି ପିଲାତ କାବାଅୟ୍‌ଲା । ଦାୟ୍‌ତେ ରିଲା ନିଜାର୍‌ ମୁଳିକାକେ କୁଦି ଜିସୁ ମଃରି ବୁତ୍‌ ଗଃଳି ଅୟ୍‌ଲିବେକି ବଃଲି ହଃଚାର୍ଲା ");
INSERT INTO bdv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ତାର୍‌ ତଃୟ୍‌ ହୁଣି ଇ କଃତା ନିଜ୍‌କଃରି ସୁଣି ପିଲାତ ଜିସୁର୍‌ ଗଃଗାଳକେ ନେଉଁକେ ଜସେପ୍ କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଜସେପ୍ ଜିସୁର୍‌ ଗଃଗାଳ୍‌କେ କ୍ରୁସେହୁଣି ଉତ୍ରାୟ୍‌ କଃଣ୍ଡେକ୍‌ ହଃଚ୍ୟା ଆଣି ଜିସୁର୍‌ ଗଃଗାଳେ ଗୁଳ୍ୟାୟ୍‌ଲା ଆର୍‌ ଡଙ୍ଗୁରେ କଃଣିରିଲା ଗଟ୍‌ ମଃସୁଣ୍‌ କାଲେ ନଃୟ୍‌ ସଃଙ୍ଗାୟ୍‌ଲା ଆର୍‌ ମଃସୁଣ୍‌ ବାଟାର୍‌ ଦୁଆର୍‌ ବାଟେ ବଃଡ୍‌ ଚଃଚ୍ରା ଡାହି କାଲ୍‌ ବଃନ୍ଦ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆର୍‌ ଜସିର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ସେତି ରଃୟ୍‌ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ କେଣେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌ ବଃଲି ଦଃକ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ବିସାଉଁଣିବାର୍‌ ସଃର୍ଲା ହଃଚେ, ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ଆର୍‌ ସଲମି ଜିସୁର୍‌ ଗଃଗାଳେ ଲାଗାଉଁକେ ବାସ୍ନା ଚିକଣ୍‌ ଗେନ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ରୟ୍‌ବାର୍‌ ଦିନ୍ ବର୍‌ ସଃକାଳ୍ୟା ସେମଃନ୍ ମଃସ୍‌ଣେ ଗଃଳାୟ୍‌, ସଃଡେବଃଳ୍‌ ବେଳ୍‌ ଉଦିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ସେମଃନ୍ ଜାତାବଃଳ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉତିରିଲାୟ୍‌, “ମଃସୁଣ୍‌ କାଲାର୍‌ ଦୁଆର୍‌ ବାଟେ ଡାହିରିଲା ଟେଳା ଅଃମାର୍‌ ଗିନେ କେ ଗୁଚାୟ୍‌ ଦେତି ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେରି ବଃଡେ ବଃଡ୍ ଟେଳା ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ମଃତର୍‌ ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଦଃକ୍‌ଲାୟ୍‌ ଜେ, ମଃସୁଣ୍ ଦୁଆଁରେ ଡାହିରିଲା ସେ ବଃଡ୍ ଟେଳା ବିନେ ଗୁଚି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ସେତାର୍‌ଗିନେ ସେମଃନ୍ ମଃସୁଣ୍ ବିତ୍ରେ ଗଃଲାୟ୍‌, ସେତି ସେମଃନ୍ ଗଟେକ୍‌ ଦବ୍‌ଳା ବଃସ୍ତର୍‌ ହିନ୍ଦିରିଲା ଗଟେକ୍‌ ବେଣ୍ଡ୍ୟାକ୍‌ ମଃସୁଣ୍‌ ବିତ୍ରେ କାତାବାଟ୍ୟା ବଃସିରିଲାର୍‌ ଦଃକି ସେମଃନ୍ ବେସି କାବାଅୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ସେତାକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଡିରା ନାୟ୍‌, ତୁମିମଃନ୍ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାୟ୍‌ ମାରିରିଲା ନାଜରିତ୍‌ ଜିସୁକେ ଲଳୁଲାସ୍‌; ସେ ଉଟି ଆଚେ, ସେ ଇତି ନାୟ୍‌; ଦଃକା, ଇ ଜଃଗାୟ୍‌ ସେମଃନ୍ ତାକ୍‌ ସଃଙ୍ଗାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ଅଃବେ ତୁମିମଃନ୍ ଜାୟ୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ଆର୍‌ ପିତର୍‌କେ ଇ କଃତା କଃଉଆ, ‘ତୁମାର୍‌ ଆଗେ ଆଗେ ଜିସୁ ଗାଲିଲିକେ ଜଃଉଁଲା; ଜିସୁ ତୁମିମଃନ୍‌କେ ଜୁୟ୍‌ ରଃକମ୍‌ କୟ୍‌ରିଲା, ସେରଃକମ୍‌ ତୁମିମଃନ୍ ସେତି ତାକ୍‌ ଦଃକାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ସେତାକ୍‌ ମାୟ୍‌ଜିମଃନ୍‌ ମଃସୁଣ୍‌ ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ ଗଃଲାୟ୍‌, ବଃଲେକ୍‌ ସେମଃନ୍ ଡିରି ଜାୟ୍‌ରିଲାୟ୍‌, ଆର୍‌ କାବା ଅୟ୍‌ରିଲାୟ୍‌, ସେମଃନ୍ ବଃଡେ ଡିର୍‌ଲାୟ୍‌, ସେତାର୍‌ଗିନେ ସେମଃନ୍ ପିତର୍‌କେ ଚାଡି କାକେ ହେଁ କାୟ୍‌ରି ନଃକୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ରୟ୍‌ବାର୍‌ ଦିନ୍ ବର୍‌ ସଃକାଳ୍ୟା ଜିସୁ ଉଟିକଃରି ଜାର୍‌ ତଃୟ୍‌ହୁଣି ସାତ୍‌ଗଟ୍‌ ବୁତ୍‌ ଚାଡାୟ୍‌ରିଲା, ସେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌କେ ଆଗ୍‌ତୁ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ସେ ଜାୟ୍‌କଃରି ଜିସୁର୍‌ ଚେଲାମଃନ୍‌କ୍‌ ଇ କବୁର୍‌ କୟ୍‌ଲି; ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଦୁକେ ରଃୟ୍‌ ରଦନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ମରିୟମ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲି, “ଜିସୁ ବଚ୍‌ଲା ଆଚେ; ଆର୍‌ ଜିସୁ ମକ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଆଚେ ।” ମଃତର୍‌ ଇ କଃତା ସୁଣି ସେମଃନ୍ ସଃତ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଇ ସଃବୁ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ଲା ହଃଚେ, ଚେଲାମଃନାର୍‌ ବିତ୍ରାର୍‌ ଦୁୟ୍‌ଲକ୍‌ ଗଟେକ୍‌ ଗାଉଁ ଜାତିରିଲା ବଃଳ୍‌, ଜିସୁ ବିନ୍ ରୁହ୍‌ ଅୟ୍‌ ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ସେମଃନ୍ ବାଉଳି ଆସି ବିନ୍ ଚେଲାମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ଲାୟ୍‌; ମଃତର୍‌ ସେମଃନାର୍‌ କଃତାକ୍‌ ହେଁ ସେମଃନ୍ ସଃତ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ଇତାର୍‌ହଃଚେ ଜଃଡେବଃଳ୍‌ ଏଗାର୍‌ଗଟ୍‌ ଚେଲାମଃନ୍ କାତି ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍‌କେ ଜିସୁ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା, ଜିସୁ ସେମଃନ୍‌କେ ସେମଃନାର୍‌ ଅବିସ୍ୱାସ୍‌ ଆର୍‌ ଅଃଟୁଆ ମଃନାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ଉଳ୍‌ଲା । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁ ଉଟିରିଲାର୍‌ ଦଃକିରିଲାୟ୍‌, ସେମଃନାର୍‌ କଃତା ଇ ଚେଲାମଃନ୍ ସଃତ୍‌ କଃରି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜଃଗତାର୍‌ ଚାରିହାକ୍‌ ଜାୟ୍‌, ସଃବୁ ଜାତିର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଇ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଜୁୟ୍‌ଲକ୍‌ ସଃତ୍‌ କଃରି ବାପ୍ତିସମ୍‌ ନଃୟ୍‌ଦ୍‌, ସେ ହାହେହୁଣି ମୁକ୍ତି ହାୟ୍‌ଦ୍‌; ମଃତର୍‌ ଜୁୟ୍‌ଲକ୍‌ ଅବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ ଦସି ଆର୍‌ ଦଃଣ୍ଡ୍‌ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ସଃତ୍‌ ବିସ୍ୱାସିମଃନାର୍‌ ଇ ସଃବୁ ଚିନ୍ ଅୟ୍‌ଦ୍‌, ସେମଃନ୍ ମର୍‌ ନାଉଁଏ ବୁତ୍‌ ଚାଡାଉତି ଆର୍‌ ନଃଉଆଁ ନଃଉଆଁ ବାସାୟ୍‌ କଃତା କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ସେମଃନ୍ ଆତେ ସାହ୍‌ ଦଃର୍ତି, ଆର୍‌ ବିସ୍‌ ମିସ୍‌ଲାର୍‌ କାୟ୍‌ରି କାୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନାର୍‌ କାୟ୍‌ ହେଁ ନୟ୍‌; ସେମଃନ୍ ଜଃର୍‌ ଦୁକାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲେକ୍‌, ସେମଃନ୍ ନିକ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଇ ସଃବୁ କଃତା ସେମଃନ୍‌କେ କୟ୍‌ଲା ହଃଚେ, ଜିସୁ ମାପ୍ରୁକ୍‌ ସଃର୍ଗେ ନିଆ ଅୟ୍‌ଲି, ସେ ଜାୟ୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁର୍‌ କାତାବାଟ୍ୟା ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ହୁର୍ତିବିର୍‌ ସଃବୁ ହାକ୍‌ ଜାୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲାୟ୍‌, ଆର୍‌ ଜିସୁ ମାପ୍ରୁ ନିଜେ ସେମଃନାର୍‌ ସଃଙ୍ଗେ ରଃୟ୍‌, ସେମଃନାର୍‌ ପର୍ଚାର୍‌ ସଃତ୍‌ ବଃଲି ଲକ୍‌ମଃନ୍‌କେ ଦଃକାଉଁକ୍‌, ସେମଃନ୍‌କେ କାବା ଅଃଉତା ଚିନ୍ କଃରୁକେ ସଃକ୍ତି ଦିଲା ।");
INSERT INTO bdv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଏ ତିଅପିଲସ୍‌, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଅଃମାର୍‌ ବିତ୍ରେ ଗଃଟିଜାୟ୍‌ରିଲା ଗଃଟ୍‍ଣା ମଃନାର୍‌ କଃତେକ୍‌ କଃତାମଃନ୍‌ ଟିକ୍‌କଃରି ଲେକୁକ୍‌ ମଃନ୍ କଃଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ସେରି ନିଜାର୍‌ ଆକାୟ୍‌ ଦଃକି ରିଲାର୍‌ ଜାଗୁଆଳି ଆର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍ ଅଃମିମଃନ୍‌କ୍‌ ଜାଣାୟ୍‌ଲା ହଃର୍କାରେ, ");
INSERT INTO bdv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଏ ମାୟ୍‌ନାର୍‌ ତିଅପିଲ ମୁଳେ ହୁଣି ସଃବୁ କଃତା ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି ମିସାୟ୍‌ ଆଗେହୁଣି ଅୟ୍‌ ଆସ୍ତା କଃତାମଃନ୍‌ ତର୍‌ ଗିନେ ଲେକୁକ୍‌ ମୁଁୟ୍‌ ହେଁ ଟିକ୍‌ ବଃଲି ମଃନେ ବାବ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଜଃନ୍‌କଃରି ଜୁୟ୍‌ ଜୁୟ୍‌ ସଃବୁ କଃତା ସିକି ଆଚ୍‌ସି ସେ ସଃବୁ କଃତାକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଜାଣୁ ହାର୍ସି । ");
INSERT INTO bdv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ହେରଦ୍‌ ଜିଉଦା ଦେସାର୍‌ ରଃଜା ରିଲା ବଃଳ୍‌ ଅବିୟ ଜାଜକ୍‌ ଦଃଳାର୍‌ ଜିକରିଅ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜାଜକ୍‌ ରିଲା; ତାର୍‌ ଡକୁର୍ସିର୍‌ ନାଉଁ ଏଲିସାବେତ୍‌, ସେ ହାରଣ୍‌ ଜାଜକ୍‌ ବଃଉଁସାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ସେମଃନ୍ ଦୁୟ୍‌ ଲକ୍‌ ହେଁ ଇସ୍ୱରାର୍‌ ସଃବୁ ନିୟମ୍‌ ଆର୍‌ ବିଦି ମାନ୍‌ତି ରିଲାୟ୍‌ ଆର୍‌ ମାପ୍ରୁର୍‌ ଆକାୟ୍‌ ଦଃର୍ମି ଲକ୍‌ ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମଃତର୍‌ ସେମଃନାର୍‌ ହିଲାମଃନ୍‌ ନଃରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଏଲିସାବେତ୍‌ ବାଞ୍ଜି ରିଲି, ଆରେକ୍‌ ସେ ଦୁୟ୍‌ ଲକ୍‌ ବୁଡାବୁଡି ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଜିକରିଅ ଅଃହ୍‌ଣାର୍‌ ଦଃଳାର୍‌ ହାଳୁ ହଃର୍କାରେ ଇସ୍ୱରାର୍‌ ମନ୍ଦିର୍‌ ଲଃଗେ ଜାୟ୍‌ ଜାଜକ୍‌ କାମ୍‌ କଃର୍ତି ରିଲା ବଃଳ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଜାଜକ୍‌ କାମାର୍‌ ବିଦି ହଃର୍କାରେ କେଳି ବାଚିକଃରି ତାକ୍‌ ମାପ୍ରୁର୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି କଃରି ଦୁହ୍‌ଣି ହଡାଉଁକ୍‌ ହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆର୍‌ ସେ ଦୁହ୍‌ଣି ହଡାଉତା ବଃଳ୍‌ ସଃର୍ନେ ଲକ୍‌ମଃନ୍ଦା ହଃଦାୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ସଃଡେବଃଳ୍‌ ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଦୁହ୍‌ଣି ହଡାଉତା ବେଦିର୍‌ କାତା ବାଟ୍ୟା ଆସି ଟିଆ ଅୟ୍‌ ତାକ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିଅ ତାକ୍‌ ଦଃକି, କାବା ଅୟ୍‌ଲା ଆର୍‌ ଡିରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମଃତର୍‌ ଦୁତ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଜିକରିଅ, ଡିର୍‌ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତର୍‌ ପାର୍ତନା ଇସ୍ୱର୍‌ ସୁଣି ଆଚେ, ଆର୍‌ ତର୍‌ ଡକୁର୍ଦି ଏଲିସାବେତ୍‌ ତର୍‌ ଗିନେ ଗଟେକ୍‌ ହିଲା ଜଃଲମ୍‌ କଃରେଦ୍‌, ଆର୍‌ ତୁୟ୍‌ ତାର୍‌ ନାଉଁ ଜହନ୍‌ ସଃଙ୍ଗାଉସି । ");
INSERT INTO bdv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ତାର୍‌ ଗିନେ ତୁମିମଃନ୍ ବଃଡେ ସଃର୍ଦା କଃରାସ୍‌, ଆର୍‌ ବିନ୍ ସଃବୁ ଲକ୍‌ମଃନ୍ ହେଁ ତାର୍‌ ଜଃଲମେ ସଃର୍ଦା କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଜଃନ୍‌କଃରି ସେ ମାପ୍ରୁର୍‌ ଲଃଗେ ଗଟେକ୍‌ ବଃଡ୍ ଲକ୍‌ ଅୟ୍‌ଦ୍‌, ସେ କଃବେ ହେଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କି ଲଃନ୍ଦାମଃଦ୍‌ ନଃକାୟ୍‌, ଆର୍‌ ସେ ଆୟ୍‌ସିର୍‌ ହେଟେ ହୁଣି ହେଁ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆର୍‌ ସେ ଇସ୍ରାଏଲ୍‌ ଜାତିର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସେମଃନାର୍‌ ସଃର୍ଗାର୍‌ ମାପ୍ରୁ ଇସ୍ୱରାର୍‌ ହାକ୍‌ ଲେଉଟାୟ୍‌ ଆଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ଉବାସି ଆୟ୍‌ସିମଃନାର୍‌ ମଃନ୍‌, ହିଲାମଃନାର୍‌ ଗିନେ ଆର୍‌ ଅମାନ୍ୟାମଃନ୍‌କେ ଦଃର୍ମି ଲକ୍‌ମଃନାର୍‌ ଗ୍ୟାନ୍ ସଃଙ୍ଗ୍ ମାନୁକ୍‌ ଲେଉଟାଉଁକ୍‌ ଆର୍‌ ମାପ୍ରୁର୍‌ ଗିନେ ଲକ୍‌ମଃନ୍‌କେ ତିଆର୍‌ କଃରୁକେ ଏଲିୟର୍‌ ଆତ୍ମା ଆର୍‌ ସଃକାତ୍‌ ସଃଙ୍ଗ୍ ତାର୍‌ ଆଗେ ଇଣ୍ଡେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଇତାର୍‌ ଗିନେ ଜିକରିଅ ଦୁତ୍‌କେ ହଃଚାର୍ଲା, “ଇରି ଗଃଟେଦ୍‌ ବଃଲି ମୁଁୟ୍‌ କଃନ୍‌କଃରି ଜାଣିନ୍ଦ୍ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତ ବୁଡା ଅୟ୍‌ଲେବେ ଆର୍‌ ମର୍‌ ବୁଡିର୍‌ ବଃୟ୍‌ସ୍‌ ହେଁ ଅଃଦିକ୍‌ ଅୟ୍‌ଲିନି ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ଦୁତ୍‌ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ମୁଁୟ୍‌ ଗାବ୍ରିଏଲ୍‌, ମୁଁୟ୍‌ ଇସ୍ୱରାର୍‌ ଲଃଗେ ଟିଅଉତା ଦୁତ୍‌, ଆର୍‌ ତକେ ଇ କଃତା କଃଉଁକେ ଆର୍‌ ଇ ସଃର୍ଦାର୍‌ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ମାପ୍ରୁ ମକ୍‌ ହଟାୟ୍‌ଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ଦଃକ୍‌ ଇସଃବୁ ନଃଗଟ୍‌ତା ଦିନ୍ ହଃତେକ୍‌ ତୁୟ୍‌ ଗୁଲା ଅୟ୍‌ କଃତା କଃଉ ନଃହାର୍‌ସି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ଜୁୟ୍‌ ସଃବୁ କଃତା ଟିକ୍‌ ବେଳାୟ୍‌ ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇସଃବୁ କଃତାକ୍‌ ତୁୟ୍‌ ସଃତ୍‌ ନଃକେଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଇ ବିତ୍ରେ ଲକ୍‌ମଃନ୍ ଜିକରିଅକେ ହଃଦାୟ୍‌ ଜାଗିରିଲାୟ୍‌, ଆର୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ସେ ବୁତେକ୍‌ଗଃଳି ରିଲାଲାଗି ସେମଃନ୍ କାବା ଅଃଉତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ମଃତର୍‌ ସେ ବାରାୟ୍‌ ଆସି ସେମଃନ୍‌କେ ଟଣ୍ଡ୍ ଅଃଉଁକେ ନଃହାର୍‌ଲା, ଇତାକ୍‌ ସେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଦଃର୍ସନ୍‌ ହାଇଆଚେ ବଃଲି ସେମଃନ୍ ଜାଣ୍‌ଲାୟ୍‌ ଆର୍‌ ସେ ସେମଃନ୍‌କେ ଆତ୍‌ସଃଗ୍ୟା କଃରୁକେ ଦଃର୍ଲା, ଆର୍‌ ଗୁଲା ଅୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ତାର୍‌ହଃଚେ ତାର୍‌ ସେବା କଃର୍ତା ହାଳୁ ଦିନ୍ ସଃବୁ ସଃର୍ଲାକ୍‌, ସେ ନିଜାର୍‌ ଗଃରେ ବାଉଳି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","କଃତି ଦିନ୍ ଗଃଲା ହଃଚେ ତାର୍‌ ଡକୁର୍ସି ଏଲିସାବେତ୍‌ ଆଙ୍ଗେ ଅୟ୍‌ଲି, ଆର୍‌ ସେ ହାଁଚ୍ ମାସ୍‌ ହଃତେକ୍‌ ସେ କଃତା କାକେ ହେଁ ନଃକୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ଆର୍‌ ମଃନେ ମଃନେ କୟ୍‌ଲି, “ଲକ୍‌ମଃନାର୍‌ ଲିନ୍ଦା ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌ କଃରୁକେ ମାପ୍ରୁ ମର୍‌ ଉହ୍ରେ ଦଃୟା କଃରି ମକ୍‌ ଇରଃକମ୍‌ କଃଲା ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିସାବେତ୍‌ ଆଙ୍ଗେ ଅୟ୍‌ ଚଅ ମାସ୍‌ ଅୟ୍‌ଲା ହଃଚେ, ଗାବ୍ରିଏଲ୍‌ ଦୁତ୍‌ ଇସ୍ୱର୍‌ ଲଃଗେହୁଣି ଗାଲିଲି ରାଜିର୍‌ ନାଜରିତ୍‌ ନାଉଁଆର୍‌ ଗଃଳେ ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳି ଟକିର୍‌ ଚଃମେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ସେ ଦଃଙ୍ଗ୍‌ଳି ଟକିକେ ଦାଉଦ୍‌ ବଃଉଁସାର୍‌ ଜସେପ୍ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ମାନାୟ୍‌ ସଃଙ୍ଗ୍ ବିବା ଅଃଉଁକେ ମାଗ୍‌ଣି କଃରି ରିଲାୟ୍‌, ସେ ଦଃଙ୍ଗ୍‌ଳି ଟକିର୍‌ ନାଉଁ ମରିୟମ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ସେ ଦୁତ୍‌ ଗଃରେ ହୁରି ତାର୍‌ ଲଃଗେ ଆସି କୟ୍‌ଲା, “ଏ ଦଃୟାର୍‌ ଜୟ୍‌ଗ୍‌ ଟକି, ତର୍‌ ସୁସ୍ତା ଅଃଉଅ, ମାପ୍ରୁ ତର୍‌ ସଃଙ୍ଗ୍ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମଃତର୍‌ ମରିୟମ୍‌ ଇ କଃତାକ୍‌ ସୁଣି ଜଃବର୍‌ କାବା ଅୟ୍‌ଲି ଆର୍‌ ଇ କଃତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ବଃଲି ମଃନେ ମଃନେ ବାବୁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ସେତାର୍‌ ଗିନେ ଦୁତ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ମରିୟମ୍‌, ଡିର୍‌ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ତକେ ଦଃୟା କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଆର୍‌ ଦଃକ୍‌, ତୁୟ୍‌ ଆଙ୍ଗେ ଅୟ୍‌କଃରି ଗଟେକ୍‌ ହିଲା ଜଃଲମ୍‌ କଃର୍ସି, ଆର୍‌ ତାର୍‌ ନାଉଁ ଜିସୁ ବଃଲି ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ସେ ସଃବ୍‌କେ ଉଟ୍ୟା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ସେ ସଃବ୍‌କେ ବଃଡ୍ ମାପ୍ରୁର୍‌ ହୟ୍‌ସି ବଃଲି ଡାକେ ହୁଟେଦ୍‌; ଆର୍‌ ଇସ୍ୱର୍‌ ତାକ୍‌ ତାର୍‌ ଦାଦିବାବୁ ଦାଉଦାର୍‌ ହର୍‌ ସିଙ୍ଗାସଣ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ସେ ଜାକୁବକ୍‌ ବଃଉଁସ୍‌ ଉହ୍ରେ ଜୁଗେଜୁଗେ ରାଜ୍‌ କଃରେଦ୍‌, ଆର୍‌ ତାର୍‌ ରାଇଜ୍‌ କଃବେ ସେସ୍‌ ନହୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ମଃତର୍‌ ମରିୟମ୍‌ ଦୁତ୍‌କେ କୟ୍‌ଲି, “ଇରି କଃନ୍‌କଃରି ଅୟ୍‌ଦ୍‌ ? ମୁଁୟ୍‌ ତ କୁୟ୍‌ ଅଃଣ୍ଡ୍ରାକେ ହେଁ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୁତ୍‌ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ପବିତ୍ର ଆତ୍ମା ତର୍‌ ଉହ୍ରେ ଉତ୍ରେଦ୍‌ ଆର୍‌ ସଃବ୍‌କେ ଉଟ୍ୟା ଇସ୍ୱର୍‌ ସଃକ୍ତି ତକେ ଦଃରେଦ୍‌, ଆର୍‌ ସେତାର୍‌ଗିନେ ଜୁୟ୍‌ ହିଲା ଜଃଲମ୍‌ ଅୟ୍‌ଦ୍‌, ସେ ପବିତ୍ର ଆର୍‌ ସେ ମାପ୍ରୁର୍‌ ହୟ୍‌ସି ବଃଲାୟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆରେକ୍‌ ଦଃକ୍‌, ତର୍‌ ନିଜାର୍‌ ଲକ୍‌ ଏଲିସାବେତ୍‌ ହେଁ ବୁଡି ବଃଇଁସେ ଗଟେକ୍‌ ହିଲାକ୍‌ ହେଟେ ଦଃରିଆଚେ । ଜେ ବାଞ୍ଜି ବଃଲି ଡାକେ ହୁଟିରିଲି, ତାକ୍‌ ଅଃବେ ଆଙ୍ଗେ ଅୟ୍‌କଃରି ଚଅ ମାସ୍‌ ଅୟ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱରାର୍‌ କୟ୍‌ଲା ଟଣ୍ଡାର୍‌ କଃତା କଃବେ ହେଁ ନଃହିଟେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ଆର୍‌ ମରିୟମ୍‌ କୟ୍‌ଲି, “ଦଃକ୍‌, ମୁଁୟ୍‌ ତ ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳି; ତୁୟ୍‌ କୟ୍‌ଲା କଃତା ହର୍‌ ମର୍‌ ଜିବନେ ଗଃଟ ।” ତାର୍‌ହଃଚେ ଦୁତ୍‌ ତାର୍‌ ଚଃମେହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ସଃଡେବଃଳ୍‌ ମରିୟମ୍‌ ଉଟିକଃରି ଡଙ୍ଗୁର୍‌ ହଲି ତଃୟ୍‌ ରିଲା ଜିଉଦା ରାଜିର୍‌ ଗଟେକ୍‌ ଗଃଳେ ସେଦାହ୍ରେ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଆରେକ୍‌ ଜିକରିଅର୍‌ ଗଃର୍‌ ବିତ୍ରେ ହୁରି ଏଲିସାବେତ୍‌କେ ଜୁଆର୍‌ କଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଆର୍‌ ଏଲିସାବେତ୍‌ ମରିୟମାର୍‌ ଜୁଆର୍‌ ସୁଣ୍‌ଲା ଦାହ୍ରେ ଏଲିସାବେତାର୍‌ ହେଟେ ରିଲା ହିଲା ନାଚୁକ୍‌ ଦଃର୍ଲା, ଆର୍‌ ଏଲିସାବେତ୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ଜଃବର୍‌ ଟଣ୍ଡ୍ ଅୟ୍‌ କୟ୍‌ଲି, “ସଃବୁ ମାୟ୍‌ଜିମଃନାର୍‌ ବିତ୍ରେ ତର୍‌ ବାୟ୍‌ଗ୍‌, ଆର୍‌ ବାୟ୍‌ଗ୍‌ ତର୍‌ ଗଃର୍ବାର୍‌ ହଃଳ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ଆର୍‌ ମର୍‌ ମାପ୍ରୁର୍‌ ଆୟ୍‌ସି ମକ୍‌ ଦଃକୁକ୍‌ ଆସେଦ୍‌, ମର୍‌ ଅଃଡେକ୍‌ ନିକ ବାୟ୍‌ଗ୍‌ କୁୟ୍‌ତି ହୁଣି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦଃକ୍‌, ତର୍‌ କଃତା ସୁଣ୍‌ଲା ଦାହ୍ରେ ମର୍‌ ହେଟେ ରିଲା ହିଲା ନାଚି ଉଟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଜେ ବିସ୍ୱାସ୍‌ କଃଲି, ତାର୍‌ ବାୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁର୍‌ ତଃୟ୍‌ହୁଣି ତାକ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ରି କଃଉଆ ଅୟ୍‌ଆଚେ, ସେ ସଃବୁ କଃତା ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଆର୍‌ ମରିୟମ୍‌ କୟ୍‌ଲି, “ମର୍‌ ହଃରାଣ୍ ମାପ୍ରୁର୍‌ ଦନ୍ୟବାଦ୍‌ କଃରୁଲି; ");
INSERT INTO bdv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆରେକ୍‌ ମର୍‌ ଆତ୍ମା ମର୍‌ ମୁକ୍ଳାଉତା ଇସ୍ୱର୍‌ ମାପ୍ରୁର୍‌ ଲଃଗେ ଅଃନାୟ୍‌ ସଃର୍ଦା କଃରୁଲି, ");
INSERT INTO bdv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁ ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳିର୍‌ ଗଃରିବ୍‌ଅଃବୁସ୍ତା ଦଃକିଆଚେ, ଆର୍‌ ଦଃକ୍‌, ଅଃବେହୁଣି ଜୁଗ୍ ଜୁଗ୍ ହଃତେକ୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ମର୍‌ ବାୟ୍‌ଗ୍‌ ବଃଲି କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃନାୟ୍‌ ବଃଡ୍ ସଃକାତିଆ ମାପ୍ରୁ, ସେ ମର୍‌ ଗିନେ ଅଃନାୟ୍‌ ବଃଡ୍ କାମ୍‌ କଃରି ଆଚେ । ତାର୍‌ ନାଉଁ ପବିତ୍ର; ");
INSERT INTO bdv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଆର୍‌ ତାକ୍‌ ମାନ୍‌ତି କଃର୍ତା ଲକ୍‌ମଃନାର୍‌ ଗିନେ ତାର୍‌ ଦଃୟା ଜୁଗେ ଜୁଗେ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ସେ ଅଃହ୍‌ଣାର୍‌ ଡେଣାର୍‌ ବଃଳ୍‌ସଃକାତ୍‌ ଦଃକାୟ୍‌ଆଚେ, ଆର୍‌ ଆକାରିମଃନ୍‌କେ ସେମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରାର୍‌ ବାବ୍‌ନାକେ ଜଃତ୍‌କଃତ୍‌ କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ସେ ବଃଳ୍‌ସଃକାତ୍‌ ରିଲା ରଃଜାମଃନ୍‌କେ ସିଙ୍ଗାସଣ୍‌ ତଃୟ୍‌ହୁଣି ଉତ୍ରାୟ୍‌ ଆଚେ, ଆର୍‌ ଇନସ୍ତା ଲକ୍‌ମଃନ୍‌କେ ବଃଡ୍ କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ସେ ବୁକେ ରିଲା ଲକ୍‌କେ ନିକ ନିକ କାଦି ହେଟ୍‌ ହୁର୍ନେ କାଳାୟ୍‌ ଆଚେ; ଆର୍‌ ମାଜନ୍ ଲକ୍‌ମଃନ୍‌କେ ଚୁଚା ଆତେ ହଃଟାୟ୍‌ଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ଅଃମାର୍‌ ହୁର୍ବାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃରିରିଲା ସଃୟ୍‌ତ୍‌ ହୁରୁଣ୍ କଃରି ତାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଇସ୍ରାଏଲ୍‌କେ ଉହ୍‌କାର୍‌ କଃରୁକେ ଆସିଆଚେ; ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଆର୍‌ ଦଃର୍ମି ଅବ୍ରାହାମ୍‌ ଆର୍‌ ତାର୍‌ ହୟ୍‌ସି ମଃନାର୍‌ ଗିନେ, ");
INSERT INTO bdv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ସେ ଜୁଗେଜୁଗେ ଅବ୍ରାହାମ୍‌ ଆର୍‌ ତାର୍‌ ସଃବୁ ବଂସାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃୟା କଃରୁକେ ହାସ୍ରି ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଆର୍‌ ମରିୟମ୍‌ ହାକାହାକି ତିନି ମାସ୍‌ ହଃତେକ୍‌ ଏଲିସାବେତ୍‌ ସଃଙ୍ଗ୍ ରିଲି ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ବାଉଳି ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ତାର୍‌ହଃଚେ ଏଲିସାବେତ୍‌ ହିଲା ଜଃଲମ୍‌ କଃର୍ତା ବେଳା ଆୟ୍‌ଲାକ୍‌, ସେ ଗଟେକ୍‌ ହିଲା ଜଃଲମ୍‌ କଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆର୍‌ ମାପ୍ରୁ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତେକ୍‌ ବଃଡ୍ ଦଃର୍ମ୍‌ କଃରିଆଚେ, ଇ କଃତା ସୁଣି ତାର୍‌ ହାକି ହଃଳ୍‌ସା ଲକ୍‌ ଆର୍‌ ତାର୍‌ ନିଜାର୍‌ ଲକ୍‌ମଃନ୍ ସଃର୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଜଃଡେବଃଳ୍‌ ହିଲା ଜଃଲମ୍‌ ଅୟ୍‌କଃରି ଆଟ୍‌ଦିନ୍ ଅୟ୍‌ଲି, ତାକାର୍‌ ରିତିବିଦି ହଃର୍କାରେ ସେ ହିଲାକ୍‌ ସୁନତ୍‌ କଃରୁକେ ନିଲାୟ୍‌, ଆର୍‌ ତାର୍‌ ଉବାସିର୍‌ ନାଉଁ ହଃର୍କାରେ ତାର୍‌ ନାଉଁ ଜିକରିଅ ବଃଲି ସଃଙ୍ଗାଉଁକ୍‌ ମଃନ୍ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମଃତର୍‌ ତାର୍‌ ଆୟ୍‌ସି ଉତୁର୍‌ ଦିଲି, “ନାୟ୍‌, ତାର୍‌ ନାଉଁ ଜହନ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତୁମାର୍‌ ନିଜାର୍‌ ବଃଉଁସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଇବାନ୍ୟା ନାଉଁ ତ କାର୍‌ ହେଁ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ତାର୍‌ହଃଚେ କାୟ୍‌ ନାଉଁ ଦିଆଅୟ୍‌ଦ୍‌ ବଃଲି ତାର୍‌ ଉବାସି ମଃନ୍‌କଃରୁଲା, ସେରି ସେମଃନ୍ ତାର୍‌ ଉବାସିକ୍‌ ଆତ୍‌ସଃଗ୍ୟା କଃରି ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ସେତାର୍‌ ଗିନେ ଜିକରିଅ ଗଟେକ୍‌ ଲେକଃତା ହାଟା ମାଗ୍‌ଲା, ଆର୍‌ “ତାର୍‌ ନାଉଁ ଜହନ୍‌,” ବଃଲି ଲେକ୍‌ଲା । ଇତାର୍‌ ଗିନେ ସଃବୁଲକ୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ଆର୍‌ ସେଦାହ୍ରେ ତାର୍‌ ଟଣ୍ଡ୍ ହୁଟ୍‌ଲି ଆର୍‌ ଜିବ୍‌ ଇଟ୍‌ଲି ଲାଗି ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ କଃତା ଅଃଉଁକେ ଦଃର୍ଲା ଆର୍‌ ଇସ୍ୱରାର୍‌ ଗୁଣ୍ କଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ତାର୍‌ ହାକିହଃଳ୍‌ସାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ଡିରି ଗଃଲାୟ୍‌, ଆର୍‌ ଇସଃବୁ କଃତା ଜିଉଦା ଦେସାର୍‌ ଡଙ୍ଗୁର୍‌ ହଲିର୍‌ ସଃବୁ ଗଃଳେ ଆର୍‌ ଗାଉଁଏମଃନ୍‌ ଲକ୍‌ମଃନ୍ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଆରେକ୍‌ ସୁଣ୍‌ଲା ସଃବୁ ଲକ୍‌ମଃନ୍ ସେସଃବୁ ନିଜାର୍‌ ନିଜାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଦଃରି କୟ୍‌ଲାୟ୍‌, “ଇ ହିଲା ତଃବେ କାୟ୍‌ରି ଅୟ୍‌ଦ୍‌ ?” କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁର୍‌ ଆତ୍‌ ତାର୍‌ ଉହ୍ରେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆର୍‌ ଜହନାର୍‌ ଉବାସି ଜିକରିଅ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ଇ ବାବ୍‌ବାଣି କୟ୍‌ଲା- ");
INSERT INTO bdv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଦନ୍ୟ ମାପ୍ରୁ, ଇସ୍ରାଏଲାର୍‌ ଇସ୍ୱର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ତାକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃୟା କଃରି ମୁକ୍ତିଦେଉଁକେ ଆସିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ସେ ଅଃମିମଃନାର୍‌ ମୁକ୍ତିକାରି ସେ ନିଜାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଦାଉଦ୍‌ ବଃଉଁସାର୍‌, ଗଟେକ୍‌ ବପୁକାରି ମୁକ୍ଳାଉତା ଲକ୍‌କେ ଅଃମିମଃନ୍‌କ୍‌ ଦିଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ଆଗେହୁର୍ବେ ହୁଣି ମାପ୍ରୁ ତାର୍‌ ପବିତ୍ର ବାବ୍‌ବାଦିମଃନାର୍‌ ଟଣ୍ଡେ ଜାୟ୍‌ ବଃଲି କୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ସେବାନ୍ୟା ଅଃମାର୍‌ ସଃତ୍ରୁମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଆର୍‌ ଅଃମିକ୍‌ ଇନସ୍ତା କଃର୍ତା ସଃବୁଲକାର୍‌ ଆତେ ହୁଣି ଅଃମିକ୍‌ ମୁକ୍ତି କଃରିଆଚେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଜଃନ୍‌କଃରି ସେ ଅଃମାର୍‌ ହୁର୍ବାର୍‌ ନିର୍ମୁଳ୍‌ ଦାଦିବାବୁମଃନ୍‌କେ ଦଃୟା ଦଃକାୟ୍‌ଦ୍‌, ଆର୍‌ ସେମଃନାର୍‌ ପବିତ୍ର ବିଦି ଏତାଉଁକେ, ");
INSERT INTO bdv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ଆର୍‌ ଅଃମାର୍‌ ଉବା ଅବ୍ରାହାମାର୍‌ ଲଃଗେ ଜୁୟ୍‌ ହଃର୍ମାଣ୍‌ କଃରି ରିଲା, ଅଃହ୍‌ଣାର୍‌ ସେ ପବିତ୍ର ବିଦି ଏତାୟ୍‌ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଆରେକ୍‌ ଜଃନ୍‌କଃରି ଅଃମି ସଃତ୍ରୁମଃନାର୍‌ ଆତେ ହୁଣି ଅଃମିକ୍‌ ରଃକ୍ୟା ହାୟ୍‌, ନଃଡିର୍‌ତେ ଜୁଗ୍‌ଜୁଗ୍ ହଃତେକ୍‌ ତାର୍‌ ସେବା କଃରୁନ୍ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ଜିବନ୍‌ କାଳେ ଅଃମିମଃନ୍‌ ପବିତ୍ର ଆର୍‌ ଦଃର୍ମେ ଜିବନ୍‌ କାଟୁଆଁ ଇରି ଇସ୍ୱରାର୍‌ ଇଚା ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ଆର୍‌ ଏ ମର୍‌ ହିଲା, ତୁୟ୍‌ ସଃବ୍‌କେ ଉଟ୍ୟା ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ବଃଲି ଡାକେ ହୁଟ୍‌ସି, ତୁୟ୍‌ ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଆଗ୍‌ତୁର୍‌ କବୁର୍‌କାରିଆ ହର୍‌, ତାର୍‌ ଗିନେ ତାର୍‌ ବାଟ ତିଆର୍‌ କଃର୍ସି । ");
INSERT INTO bdv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃନ୍ଦାରେ ଆର୍‌ ମଃରୁକ୍‌ ବଃସିରିଲା ଲକ୍‌କେ ହାହେ ହୁଣି ମୁକ୍ତି ଦେଉଁକେ, ");
INSERT INTO bdv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଆରେକ୍‌ ଅଃମାର୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁ ଦଃୟାକାରି ଆର୍‌ କଃଉଁଣା ମଃନାର୍‌, ସେ ଅଃମାର୍‌ ଗିନେ ମୁକୁଳ୍‌ତା ସଃକ୍ତି ଉଦାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ସେ ଲାଡାର୍‌ ଦଃୟା ଗିନେ ଇସ୍ୱରାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ସେମଃନାର୍‌ ହାହ୍‌ କେମା ସଃଙ୍ଗ୍ ମୁକୁଳ୍‌ତା ସୁସ୍ତାର୍‌ ଗିଆନ୍‌ ଦେଉଁକେ, ତୁୟ୍‌ ତାକାର୍‌ ବାଟ ତିଆର୍‌ କଃରୁକେ ତାକାର୍‌ ଆଗେ ଇଣ୍ଡ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଆରେକ୍‌ ସେ ହିଲା ଗଃଗାଳ୍‌ ଆର୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ବାଡୁକେ ଦଃର୍ଲା, ଆର୍‌ ସେ ଇସ୍ରାଏଲ୍‌ ମଃନାର୍‌ ଲଃଗେ ଦଃକାୟ୍‌ ନଃଉତା ହଃତେକ୍‌ ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ରେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ସଃଡେବଃଳ୍‌ ରମିୟ ଦେସ୍‌ ବିତ୍ରାର୍‌ ଚଃକର୍‌ବତି ଅଗସ୍ଟ କାଇସର୍‌ ତଃୟ୍‌ହୁଣି ଦେସାର୍‌ ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ନାଉଁ ଲେକାଉଁକ୍‌ ଆଦେସ୍‌ ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସୁରିଆର୍‌ ଗର୍ନର୍‌ କୁରିଣିୟର୍‌ ବଃଳ୍‌ ହଃର୍ତୁମ୍‌ ତର୍‌ ଇ ଲକ୍‌ ଗଃଣ୍‌ତି ଆରୁମ୍‌ ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ସେତାର୍‌ ଗିନେ ସଃବୁ ଲକ୍‌ମଃନ୍ ନାଉଁ ଲେକାଉଁକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗଃଳେ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ସେତାର୍‌ ଗିନେ ଜସେପ୍ ହେଁ ନାଉଁ ଲେକାଉଁକ୍‌ ମରିୟମ୍‌ ସଃଙ୍ଗ୍ ଗାଲିଲି ରାଜିର୍‌ ନାଜରିତ୍‌ ଗଃଳେହୁଣି ଜିଉଦା ରାଜିର୍‌ ବେତ୍‌ଲିହିମ୍‌ ନାଉଁଆର୍‌ ଦାଉଦାର୍‌ ଗଃଳେ ଗଃଳାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଦାଉଦାର୍‌ ବଃଉଁସାର୍‌ ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ତାର୍‌ ସଃଙ୍ଗ୍ ମରିୟମ୍‌କ୍ ବିବା ଅଃଉଁକେ ମାଗ୍‌ଣି ଅୟ୍‌ରିଲି ଆର୍‌ ମରିୟମ୍‌ ଆଙ୍ଗେ ରିଲି । ସେତାର୍‌ ଗିନେ ସେ ମରିୟମ୍‌ ସଃଙ୍ଗ୍ ନାଉଁ ଲେକାଉଁକ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ସେମଃନ୍ ବେତ୍‌ଲିହିମ୍‌ ଗଃଳେ ରିଲା ବଃଳ୍‌ ମରିୟମାର୍‌ ହିଲା ଜଃଲମ୍‌ ଅଃଉତା ବେଳ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଆରେକ୍‌ ମରିୟମ୍‌ ହଃର୍ତୁ ହିଲା ଜଃଲମ୍‌ କଃଲି ଆର୍‌ ତାକ୍‌ ହଃଚ୍ୟାୟ୍‌ ଗୁଳ୍ୟାୟ୍‌ ଗାଇ ସାଳାର୍‌ ଡଙ୍ଗାୟ୍‌ ସଳାୟ୍‌ଲାୟ୍‌ । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବାସାଗଃରେ ସେମଃନାର୍‌ ଗିନେ ଟାଣ୍ ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ସେ ବେତ୍‌ଲିହିମ୍‌ ହଲିଲଃଗେ କଃତିଗଟ୍‌ ମେଣ୍ଡା ଗଃଉଳିଆମଃନ୍‌ ହଃଦାୟ୍‌ ରଃୟ୍‌ ରାତିଆ ସେମଃନାର୍‌ ମେଣ୍ଡାମଃନ୍ଦାକେ ଜାଗ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ସେମଃନାର୍‌ ଲଃଗେ ଆୟ୍‌ଲା, ଆରେକ୍‌ ମାପ୍ରୁର୍‌ ଜଃଜ୍‌ମାନାର୍‌ ଉଜାଳ୍‌ ସେମଃନାର୍‌ ଚାରିବେଳ୍‌ତ୍ ଅୟ୍‌ଲି, ଆର୍‌ ସେମଃନ୍ ଅଃନାୟ୍‌ ଡିରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ସେତାକ୍‌ ଦୁତ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଡିରି ଜାହାନାୟ୍‌; ଦଃକା, ମୁଁୟ୍‌ ସଃବୁଲକାର୍‌ ବଃଡେ ସଃର୍ଦାର୍‌ ନିକ କବୁର୍‌ ତୁମିମଃନ୍‌କେ ପର୍ଚାର୍‌ କଃରୁଲେ, ");
INSERT INTO bdv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଆଜି ଦାଉଦାର୍‌ ଗଃଳେ ତୁମାର୍‌ ଗିନେ ରଃକ୍ୟାକାରି ଲକ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲା ଆଚେ, ସେ କ୍ରିସ୍ଟ ମାପ୍ରୁ । ");
INSERT INTO bdv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆର୍‌ ତୁମାର୍‌ ଗିନେ ଇରି ଚିନ୍ ହର୍‌ ଅୟ୍‌ଦ୍‌, ତୁମିମଃନ୍ ଗଟେକ୍‌ ହିଲାକ୍‌ ହଚ୍ୟାୟ୍‌ ଗୁଳ୍ୟାୟ୍‌ କଃରି ଗାଇ ଡଙ୍ଗାୟ୍‌ ସଇରିଲାର୍‌ ଦଃକାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଆରେକ୍‌ ଉଲୁସ୍ତେ ସେ ଦୁତାର୍‌ ସଃଙ୍ଗ୍ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନ୍ଦା ଆସିକଃରି ଇସ୍ୱରାର୍‌ ନାଉଁଏ ସଃର୍ଦାର୍‌ ଗିତ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ସଃର୍ଗ୍‌ ଉହ୍ରାର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ ଅଃଉଅ, ଆରେକ୍‌ ହୁର୍ତିବି ବିତ୍ରେ ତାର୍‌ ସଃନ୍‌ମତ୍‌ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ସୁସ୍ତା ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁତ୍‌ମଃନ୍ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ସଃର୍ଗେ ବାଉଳି ଗଃଲା ହଃଚେ, ମେଣ୍ଡା ଗଃଉଳିଆମଃନ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଆସା, ଅଃମିମଃନ୍‌ ବେତ୍‌ଲିହିମ୍‌ ହଃତେକ୍‌ ଜାୟ୍‌କଃରି ମାପ୍ରୁ ଅଃମିମଃନ୍‌କ୍‌ ଇ ଜୁୟ୍‌ ଗଃଟ୍‍ଣା ଜାଣାୟ୍‌ଲା, ସେରି ଦଃକୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଆର୍‌ ହଃଚେ ସେମଃନ୍ ବେଗି ଜାୟ୍‌ ଲଳିକଃରି ମରିୟମ୍‌ ଆର୍‌ ଜସେପ୍, ଆରେକ୍‌ ଗାଇଡଙ୍ଗାୟ୍‌ ହିଲାକ୍‌ ସଇରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ସେମଃନ୍ ତାକ୍‌ ଦଃକିକଃରି ସେ ହିଲାର୍‌ କଃତା ଦୁତ୍‌ ଜାୟ୍‌ବଃଲି କୟ୍‌ରିଲା, ସେ ସଃବୁ ହୁଟାୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ଆରେକ୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ମେଣ୍ଡା ଗଃଉଳିଆମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ସେ ସଃବୁ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ସେସଃବୁ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ମଃତର୍‌ ମରିୟମ୍‌ ଇ ସଃବୁ କଃତା ମଃନ୍‌ ବିତ୍ରେ ଦଃରି ବାବୁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଆର୍‌ ମେଣ୍ଡା ଗଃଉଳିଆମଃନ୍‌କେ ଦୁତ୍‌ ଜଃନ୍‌କଃରି କୟ୍‌ରିଲା, ସେବାନ୍ୟା ସେମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣିରିଲାୟ୍‌ ଆର୍‌ ଦଃକିରିଲାୟ୍‌, ସେ ସଃବୁର୍‌ ଗିନେ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ ଆର୍‌ ଗୁଣାର୍‌ ଗିତ୍‌ କୟ୍‌ କୟ୍‌ କଃରି ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆଟ୍‌ଦିନ୍ ଅୟ୍‌ଲା ହଃଚେ, ମସାର୍‌ ରିତିବିଦି ହଃର୍କାରେ ହିଲାକ୍‌ ସୁନତ୍‌ କଃରୁକେ ମନ୍ଦିରେ ନଃୟ୍‌, ସେ ହିଲାର୍‌ ନାଉଁ ଜିସୁ ଦିଲାୟ୍‌; ମରିୟମ୍‌ ଆଙ୍ଗେ ନଃଉତ୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌ ସେମଃନ୍‌କେ ଇ ନାଉଁ ସଃଙ୍ଗାଉଁକ୍‌ କୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ହଃଚେ ଜଃଡେବଃଳ୍‌ ମସାର୍‌ ବିଦିବିଦାନ୍ ହଃର୍କାରେ ସେମଃନାର୍‌ ନିର୍ମୁଳ୍‌ ଅଃଉତା ଦିନ୍ ଆୟ୍‌ଲି, ତଃବେ ସେମଃନ୍ ହିଲାକ୍‌ ମାପ୍ରୁତଃୟ୍‌ ସଃହ୍ରି ଦେଉଁକେ ଜିରୁସାଲମ୍‌ ମନ୍ଦିରେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ଜଃନ୍‌କଃରି ମାପ୍ରୁର୍‌ ବିଦିବିଦାନ୍ ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଲା ହଃର୍କାରେ, ସଃଡେବଃଳ୍‌, “ସଃବୁ ହଃର୍ତୁମ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲା ଅଃଣ୍ଡ୍ରାହିଲା ମାପ୍ରୁର୍‌ ନାଉଁଏ ପବିତ୍ର ବଃଲି ଗଃଣ୍‌ତି ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଆରେକ୍‌, ସେମଃନ୍ ତାକ୍‌ ମାପ୍ରୁକ୍‌ ଦେତା ହାୟ୍‌ ଆର୍‌ ମାପ୍ରୁର୍‌ ବିଦିବିଦାନ୍ ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଲା ଲେକା ହଃର୍କାରେ ଜଳେକ୍‌ ହାଣ୍ଡ୍‌କା, ନୟ୍‌ଲେକ୍‌ ଜଳେକ୍‌ ହାରୁଆ ହୁଜା ଦେଉଁକ୍‌ ତାକ୍‌ ଜିରୁସାଲମେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଆର୍‌ ଦଃକା, ଜିରୁସାଲମେ ସିମିଅନ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଦଃର୍ମି ଆର୍‌ ମାପ୍ରୁର୍‌ ଦିଆନ୍‌ କାରିଆ ରିଲା; ସେ ଇସ୍ରାଏଲ୍‌କେ ମୁକ୍ଳାଉତା ଲକ୍‌ କଃବେ ଆସେଦ୍‌ ବଃଲି ଜାଗି ରିଲା, ଆରେକ୍‌ ପବିତ୍ର ଆତ୍ମା ତାର୍‌ ସଃଙ୍ଗ୍‌ରଃୟ୍‌ ସାସ୍‌ ଦେତିରିଲି ରିଲି, ");
INSERT INTO bdv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ଆର୍‌, ମାପ୍ରୁ କ୍ରିସ୍ଟକେ ନଃଦେକ୍‌ତା ହଃତେକ୍‌ ତାର୍‌ ମଃର୍ନ୍‌ ନୟ୍‌, ଇ କଃତା ପବିତ୍ର ଆତ୍ମା ତାକ୍‌ ଜାଣାୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ସେ ପବିତ୍ର ଆତ୍ମା କାଡାୟ୍‌ ଆଣ୍‌ଲାକ୍‌ ମନ୍ଦିରେ ଆୟ୍‌ଲା, ଆରେକ୍‌ ଜିସୁ ହିଲାର୍‌ ଆୟ୍‌ସି ଉବାସି ଜଃଡେବଃଳ୍‌ ତାକାର୍‌ ବିଦିବିଦାନ୍ ହଃର୍କାରେ କାମ୍‌ କଃରୁକେ ଜିସୁକେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଆଣ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ସଃଡେବଃଳ୍‌ ସିମିଅନ୍ ହିଲାକ୍‌ କଳେ ଦଃରି ଇସ୍ୱରାର୍‌ ଗୁଣ୍ ଗିତ୍‌ କୟ୍‌ କଃରି କୟ୍‌ଲା- ");
INSERT INTO bdv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ମାପ୍ରୁ, ଅଃବେ ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ କଃତା ହଃର୍କାରେ, ତର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ସୁସ୍ତାୟ୍‌ ଜଃଉଁକେ ଦେଉଁଲିସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ଆକି ତର୍‌ ମୁକ୍ତି ଦଃକିଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଜୁୟ୍‌ରି ତୁୟ୍‌ ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ମୁଏଁ ତିଆର୍‌ କଃରି ଆଚ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଆର୍‌, ଅଜିଉଦିମଃନ୍‌କେ ସଃତ୍‌ ଜାଣାଉତା ଉଜାଳ୍‌ ଆରେକ୍‌ ତର୍‌ ଲକ୍‌ ଇସ୍ରାଏଲାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରିଆଚ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ସାନ୍ ହିଲାର୍‌ ବିସୟେ କଃଉଆ ଅୟ୍‌ରିଲାର୍‌ ସଃବୁ କଃତା ସୁଣି, ତାର୍‌ ଆୟ୍‌ସି ଉବାସି କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଆର୍‌ ସିମିଅନ୍‌ ସେମଃନ୍‌କେ ଆସିର୍ବାଦ୍‌ କଃରି ଜିସୁର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌କେ କୟ୍‌ଲା, “ଇ ହିଲା ଇସ୍ରାଏଲାର୍‌ ବେସି ଲକାର୍‌ ନଃସ୍ଟ୍‌ ଆର୍‌ ରଃକ୍ୟା କଃରୁକେ ଆଚେ ସେ ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ ହୁଣି ଚିନ୍‌ ଅୟ୍‌ଦ୍‌ ଅଃନେକ୍‌ ଲକ୍‌ ତାର୍‌ ବିରଦେ ଉଟ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ସେତାକ୍‌ ଇ ହିଲା କଃତେକ୍‌ ଲକାର୍‌ ବୁଡ୍‌ତାର୍‌ ଆର୍‌ ଉଟ୍‌ତାର୍‌, ଆର୍‌ ଜାର୍‌ ବିରଦେ କଃତା କଃଉଆ ଅୟ୍‌ଦ୍‌, ଇବାନ୍ୟା ଗଟେକ୍‌ ଚିନ୍ ହର୍‌ ଅଃଉଁକେ ବାଚା ଅୟ୍‌ଆଚେ; ଆରେକ୍‌ ତର୍‌ ଜିବନ୍‌ ବିତ୍ରେ ହେଁ କଃଣ୍ଡା ବୁସି ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଆର୍‌ ହାନା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦିଣି ରିଲି; ସେ ଆସେର୍‌ ବଃଉଁସାର୍‌ ପିନୁଏଲାର୍‌ ଜିସି । ତାର୍‌ ବୁତେକ୍‌ ବଃର୍ସ୍‌ ଅୟ୍‌ରିଲି; ସେ ବାଳତ୍‌ ଦଃଙ୍ଗ୍‌ଳି ରିଲା ହଃଚେ ବିବା ଅୟ୍‌କଃରି ସାତ୍‌ ବଃର୍ସ୍‌ ତାର୍‌ ଡକ୍ରାସି ସଃଙ୍ଗ୍ ରିଲି ଆର୍‌ ଡକ୍ରାସି ମଃଲାକ୍‌ ରାଣ୍ଡି ଅୟ୍‌ରିଲି, ତାକ୍‌ ଚାରିକଳି ଚାରି ବଃର୍ସ୍‌ ଜିବନ୍‌ କାଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ସେ ସଃବୁବଃଳ୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ରେତିରିଲି, ଆର୍‌ ଦିନ୍‌ରାତି ଉହାସ୍‌ ଆର୍‌ ପାର୍ତନା ସଃଙ୍ଗ୍ ମାପ୍ରୁର୍‌ ସେବା କଃର୍ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ହିଲା ଜିସୁକେ ମନ୍ଦିରେ ଟେକି ଦିଲା ହଃଚେ, ହାନା ସେତି ହଚି ଇସ୍ୱର୍‌କେ ଦନ୍ୟବାଦ୍‌ ଦିଲି ଆର୍‌ ଜିରୁସାଲମାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ମୁକ୍ତି ଦଃୟ୍‌ଦ୍‌ ବଃଲି ଜୁୟ୍‌ମଃନ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ଜାଗି ରିଲାୟ୍‌ ସେ ସଃବ୍‌କେ ଜିସୁର୍‌ କଃତା ଜାଣାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ହଃଚେ ଜସେପ୍ ଆର୍‌ ମରିୟମ୍‌ ମାପ୍ରୁର୍‌ ବିଦିବିଦାନ୍ ହଃର୍କାରେ ସଃବୁ କାମ୍‌ ସଃରାୟ୍‌କଃରି ସେମଃନ୍ ନିଜାର୍‌ ଗାଲିଲିର୍‌ ନାଜରିତ୍‌ ଗଃଳେ ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆର୍‌ ସେ ହିଲା ବାଡୁକେ ଦଃର୍ଲା ଆର୍‌ ବୁଦି ଗ୍ୟାନେ ହୁର୍ନ୍‌ ଅଃଉଁ ଅଃଉଁ ବଃଳ୍‌ସଃକାତ୍‌ ଅୟ୍‌ଲା, ଆର୍‌ ଇସ୍ୱରାର୍‌ ଦଃୟା ତାର୍‌ ଉହ୍ରେ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ହଃତିବଃର୍ସ୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ମାନୁକ୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ଉବାସି ଜିରୁସାଲମେ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜଃଡେବଃଳ୍‌ ଜିସୁକେ ବାର ବଃର୍ସ୍‌ ଅୟ୍‌ଲି, ରିତିବିଦି ହଃର୍କାରେ ସେମଃନ୍ ହଃର୍ବ୍‌ ମାନୁକ୍‌ ଜିରୁସାଲମେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ତାକାର୍‌ ହଃର୍ବ୍‌ ମାନ୍‌ତା ଦିନ୍ ସଃର୍ଲାକ୍‌, ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ବାଉଳି ଆସ୍ତି ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜିସୁ ହିଲା ଜିରୁସାଲମେ ତେବ୍‌ଲା, ଇ କଃତା ତାର୍‌ ଆୟ୍‌ସି ଉବାସି ଜାଣି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ସଃଙ୍ଗାର୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆଚେ ବଃଲି ମଃନେ ବାବି, ସେମଃନ୍ ଗଟେକ୍‌ ଦିନାର୍‌ ବାଟ ଗଃଲା ହଃଚେ, ସେମଃନ୍ ତାକାର୍‌ ନିଜାର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଜିସୁକେ ଲଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଆରେକ୍‌ ଜିସୁକେ ନଃମିଳାୟ୍‌, ଲଳି ଲଳି ଜିରୁସାଲମେ ଲେଉଟି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ତିନି ଦିନାର୍‌ ହଃଚେ ସେମଃନ୍ ଜିସୁକେ ମନ୍ଦିରେ ବେଟ୍‌ ହାୟ୍‌ଲାୟ୍‌, ସେ ହଃଣ୍ଡିତ୍‌ ମଃନାର୍‌ ସଃଙ୍ଗ୍ ବଃସି କଃରି ସେମଃନାର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲା ଆର୍‌ ସେମଃନ୍‌କେ କଃତେକ୍‌ କଃତା ହଃଚାର୍ତି ରିଲା, ");
INSERT INTO bdv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ତାର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲାୟ୍‌, ସେ ସଃବୁ ଲକ୍‌ମଃନ୍ ତାର୍‌ ବୁଦିକ୍‌ ଆର୍‌ ସେ ଦେତିରିଲା ଉତୁର୍‌କେ ସୁଣି କାବା ଅୟ୍‌ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଜଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ଉବାସି ତାକ୍‌ ଦଃକ୍‌ଲାୟ୍‌, ସେମଃନ୍ କାବା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ ଆୟ୍‌ସି ତାକ୍‌ କୟ୍‌ଲି, “ଏ ହିଲା, କାୟ୍‌ତାକ୍‌ ତୁୟ୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଇବାନ୍ୟା କଃଲିସ୍‌ ? ଦଃକ୍‌, ତର୍‌ ଉବାଦି ଆର୍‌ ମୁଁୟ୍‌ କଃତେକ୍‌ କାକୁଲ୍‌ତି ଅୟ୍‌ ତକେ ଲଳୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ଲଳ୍‌ତି ରିଲାସ୍‌ ? ମର୍‌ ଉବାର୍‌ ଗଃରେ ରେତାର୍‌ ମର୍‌ ବିଦି, ଇ କଃତା କାୟ୍‌ ତୁମି ଜାଣି ନଃରିଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମଃତର୍‌ ସେ ସେମଃନ୍‌କେ ଜୁୟ୍‌ କଃତା କୟ୍‌ଲା, ସେରି ସେମଃନ୍ ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ହଃଚେ ଜିସୁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସି ନାଜରିତ୍‌ ବାଉଳି ଆୟ୍‌ଲା ଆର୍‌ ସେମଃନାର୍‌ କଃତା ମାନିକଃରି ରିଲା, ଆରେକ୍‌, ତାର୍‌ ଆୟ୍‌ସି ଇ ସଃବୁ କଃତା ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି ତାର୍‌ ମଃନ୍‌ବିତ୍ରେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଆର୍‌ ଜିସୁ ଗ୍ୟାନେ ଆର୍‌ ଗଃଗାଳେ, ଆରେକ୍‌ ଇସ୍ୱରାର୍‌ ଆର୍‌ ନଃର୍‌ମଃନାର୍‌ ଦଃୟାୟ୍‌ ବାଡୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିଆ କାଇସର୍‌ ବଃଲେକ୍‌ ଚଃକର୍‌ବତିର୍‌ ରାଜ୍‌ କଃର୍ତା ବଃଳାର୍‌ ହଃନ୍ଦ୍ର ବଃର୍ସ୍‌ ବଃଳ୍‌, ଜଃଡେବଃଳ୍‌ ପନ୍ତିଅ ପିଲାତ ଜିଉଦାର୍‌ ଗର୍ନର୍‌ ରିଲା ଆର୍‌ ହେରଦ୍‌ ଗାଲିଲି ରାଜିର୍‌ ତଃଳ୍ୟା ରଃଜା ରିଲା, ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ପିଲିପ୍ ଇତୁରିଆ ଆର୍‌ ତ୍ରାକନିତି ରାଜିର୍‌, ଆରେକ୍‌ ଲୁସାନିଆ ଅବିଲିନି ଗଃଳାର୍‌ ତଃଳ୍ୟା ରଃଜା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ଆର୍‌ ହାନାନ୍ ଆର୍‌ କୟାପା ମୁଳ୍‌ ଜାଜକ୍‌ ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ବଃଟାୟ୍‌ ଜିକରିଅର୍‌ ହୟ୍‌ସି ଜହନ୍‌ ଲଃଗେ ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ସେତାର୍‌ ଗିନେ ସେ ଜହନ୍‌ ଜର୍ଦନ୍ ଗାଡ୍ ଲଃଗାର୍‌ ସଃବୁହାକ୍‌ ଜାୟ୍‌କଃରି, “ହାହ୍‌ କେମା ଗିନେ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ବାପ୍ତିସମ୍‌ ନିଲେକ୍‌ ମାପ୍ରୁ ହାହ୍‌ କେମା କଃରେଦ୍‌,” ବଃଲି ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଜଃନ୍‌କଃରି ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଆଚେ; “ଗଟ୍‌ ଲକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌କଃରି କଃଉଁଲା, ମାପ୍ରୁର୍‌ ଗିନେ ବାଟ୍‌ ତିଆର୍‌ କଃରା, ତାର୍‌ ଜାତାର୍‌ ଗିନେ ଗଟେକ୍‌ ସଃଳ୍‌କ୍‌ ବାଟ୍‌ ତିଆର୍‌ କଃରା; ");
INSERT INTO bdv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ସଃବୁ କାଲ୍‌ ବୁୟ୍‌ଁ ତହା ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସଃବୁ ହଃର୍ବାତ୍‌ ଆର୍‌ ଡଙ୍ଗୁର୍‌ମଃନ୍‌ ସଃମାନ୍‌ କଃରା ଅୟ୍‌ଦ୍‌, ବାଙ୍ଗ୍‌ଟା ବାଟ୍‌ମଃନ୍‌ ସଃବୁ ସଃଳ୍‌କ୍‌ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଟେଲ୍‌ କାଲ୍‌ ରିଲା ବୁଇଁମଃନ୍‌ ବାଟ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଆରେକ୍‌ ସଃବୁ ମାନାୟ୍‌ ଜାତି ଇସ୍ୱରାର୍‌ ମୁକ୍ତି ଦଃକ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ତଃବେ, ତାର୍‌ ଲଃଗେ ବାପ୍ତିସମ୍‌ ନେଉଁକେ ବାରାୟ୍‌ ଆସ୍ତି ରିଲା ଲକ୍‌ମଃନ୍ଦାକେ ଦଃକି ଜହନ୍‌ କୟ୍‌ଲା, “ଏ ନାଗ୍ ସାହ୍‌ ଆର୍‌ ତାର୍‌ ବଃଉଁସ୍‌ମଃନ୍, ଇସ୍ୱର୍‌ ତୁମିକେ ଜୁୟ୍‌ ଡଃଣ୍ଡ୍‌ ଦେଉଁକେ ଜଃଉଁଲା, ସେତିହୁଣି ମୁକ୍‌ଳୁ ହାରାସ୍‌ ବଃଲି କେ ତୁମିକେ କୟ୍‌ଲା ? ");
INSERT INTO bdv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ଜଦି ତୁମିମଃନ୍ ସଃତ୍‌କଃରି ହାହେ ହୁଣି ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆଚାସ୍‌, ତଃବେ ନିକ କାମ୍‌ କଃରି ଦଃକାଉଆ । ଅବ୍ରାହାମ୍‌ ତ ଅଃମାର୍‌ ଉବା ବଃଲି ମଃନେ ମଃନେ ହେଁ କଃଉଆ ନାୟ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଇସ୍ୱର୍‌ ଇ ଟେଳାମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ହେଁ ଅବ୍ରାହାମାର୍‌ ଗିନେ ହିଲାମଃନ୍‌ ଉବ୍‌ଜାଉଁ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଆର୍‌ ଅଃବେ ହେଁ ଗଃଚ୍‌ମଃନାର୍‌ ବୁନ୍ଦେ କୁରାଡି ଲାଗି ଆଚେ; ବଃଲେକ୍‌ ଜୁୟ୍‌ ଗଃଚେ ନିକ ହଃଳ୍‌ ନଃହେଳେ, ସେ ଗଃଚ୍‌କେ କାଟିକଃରି ଜୟେ ହଃକା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଇତାର୍‌ଗିନେ ଲକ୍‌ମଃନ୍ଦାମଃନ୍‌ ତାକ୍‌ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ଅଃମିମଃନ୍‌ କାୟ୍‌ କଃରୁନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଜହନ୍‌ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ଜାର୍‌ ଲଃଗେ ଜଳେକ୍‌ ଆଙ୍ଗି ଆଚେ, ସେ ଜାକେ ନାୟ୍‌, ତାକ୍‌ ଗଟେକ୍‌ ଦେଅ; ଆର୍‌ ଜାର୍‌ ଲଃଗେ କାଉଁକେ କାଦି ଆଚେ, ସେ ହେଁ ସେବାନ୍ୟା କଃର ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ଆର୍‌ କଃତେକ୍‌ ରିବ୍‌ନିମଃନ୍‌ ହେଁ ବାପ୍ତିସମ୍‌ ନେଉଁକ୍‌ ଆସି ଜହନ୍‌କେ ହଃଚାର୍ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ କାୟ୍‌ କଃରୁନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ଆରେକ୍‌, ଜହନ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ଗିନେ ଜଃତେକ୍‌ ନେତା ନିୟମ୍‌ ଆଚେ ସଃତେକ୍‌ ହଃକା ନିଆ, ତାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଆଦାୟ୍‌ କଃରି ନିଆନାଁୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","କଃତେକ୍‌ ଇଜାର୍‌ମଃନ୍ ହେଁ ଆସି ତାକ୍‌ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ଆର୍‌ ଅଃମିମଃନ୍‌ କାୟ୍‌ କଃରୁନ୍ଦ୍‌ ?” ଜହନ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବଃଳ୍‌ମାଡେ କାର୍‌ ଦଃନ୍ ଚାଡାୟ୍‌ ନିଆନାଁୟ୍‌ କି କାକେ ସୁନେସୁନେ ଦସି କଃରାନାୟ୍‌ । ତୁମିକେ ଜଃତେକ୍‌ ବଃର୍ତାନ୍‌ ମିଳୁଲି ସେତି ମଃନ୍ ସଃର୍ଦାକଃରି ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ କ୍ରିସ୍ଟ ଆସ୍ତାର୍‌ ଜାଗିରିଲାର୍‌ ଗିନେ ଆର୍‌ ଜହନ୍‌ କେଜାଣ୍ କ୍ରିସ୍ଟ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ବଃଲି ସେମଃନ୍ ମଃନ୍‌ ବିତ୍ରେ ବାବ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ତଃବାର୍‌ ଗିନେ ଜହନ୍‌ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ମୁଁୟ୍‌ ସିନା ତୁମିମଃନ୍‌କେ ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁଲେ, ମଃତର୍‌ ମର୍‌ ତଃୟ୍‌ହୁଣି ଜେ ଅଃଦିକ୍‌ ସଃକ୍ତିମାନ୍‌, ସେ ଆସୁଲା, ତାର୍‌ ହାଣ୍ଡାୟ୍‌ର୍‌ ବାନ୍ଦୁଣ୍ ଇଟାଉଁକ୍‌ ମୁଁୟ୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌; ସେ ତୁମିମଃନ୍‌କେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ଆର୍‌ ଜୟେ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ଅଃହ୍‌ଣାର୍‌ କଟାର୍‌ ହଃର୍ଚାଳ୍‌ କଃରୁକେ ଆର୍‌ ସଃବୁ ନିକ ଗଅଁକେ ରୁଣ୍ଡାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃଦ୍ୟାୟ୍‌ ସଃଙ୍ଗାଉଁକ୍‌ ତାର୍‌ ଆତେ କୁଲା ଆଚେ, ମଃତର୍‌ ସଃବୁ ହଃଲମଃନ୍‌କେ ନଃଲିବ୍‌ତା ଜୟେ ହଡାୟ୍‌ ହଃକାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ସେ ଇବାନ୍ୟା ଗାଦେକ୍‌ ସିକ୍ୟା ଦିଲା, ଆର୍‌ ବିନ୍ ବିନ୍ ରଃକମାର୍‌ ମଃନ୍ ସଃର୍ଦାର୍‌ କଃତା କୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲା । ଆର୍‌ ମଃନ୍‌ ବାଦ୍‌ଲାଉଁକ୍‌ ସେମଃନ୍‌କେ ଗଃଉଆରି କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମଃତର୍‌ ତଃଳ୍ୟା ରଃଜା ହେରଦ୍‌ ନିଜାର୍‌ ବାୟ୍‌ସିର୍‌ ଡକୁର୍ସି ହେରଦିଆକେ ସଃଙ୍ଗାୟ୍‌ରିଲା କଃତା ଆର୍‌ ତାର୍‌ କଃଲା ସଃବୁ କଃରାବ୍‌ କଃତାର୍‌ ଗିନେ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ଲିନ୍ଦା କଃରାୟ୍‌ ଅୟ୍‌ଲାକ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ତଃଳ୍ୟା ରଃଜା ହେରଦ୍‌ ଜହନ୍‌କେ ଜଃଇଲ୍‌ ଗଃରେ ହୁରାୟ୍‌କଃରି ନିଜାର୍‌ ସଃର୍ନେ କଃରାବ୍‌ କାମ୍‌ ସଃଙ୍ଗ୍ ଇରି ହେଁ ଗଟେକ୍‌ ମିସାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ସଃବୁ ଲକ୍‌ମଃନ୍ ବାପ୍ତିସମ୍‌ ନିଲା ହଃଚେ, ଜିସୁ ହେଁ ବାପ୍ତିସମ୍‌ ନିଲା । ଆର୍‌ ଜିସୁ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲା ବଃଳ୍‌ ସଃର୍ଗ୍‌ ଉଗାଳି ଅୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆରେକ୍‌ ପବିତ୍ର ଆତ୍ମା ହାଣ୍ଡ୍‌କା ହର୍‌ ଗଃଗାଳ୍‌ ଦଃରି ଜିସୁର୍‌ ଉହ୍ରେ ଉତ୍ରି ଆସି ବଃସ୍‌ଲି; ଆର୍‌ ସଃର୍ଗେ ହୁଣି ଗଟେକ୍‌ କଃତା ସୁଣା ଅୟ୍‌ଲି, “ତୁୟ୍‌ ଅଃମାର୍‌ ଲାଡାର୍‌ ହଅ, ତର୍‌ ତଃୟ୍‌ ଅଃମାର୍‌ ବଃଡେ ସଃନ୍‌ମତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ ପର୍ଚାର୍‌ କାମ୍‌ ଆରୁମ୍‌ କଃଲା ବଃଳ୍‌ ତାକ୍‌ ହାକାହାକି ତିରିସ୍‌ ବଃର୍ସ୍‌ ଅୟ୍‌ରିଲି; ଲକ୍‌ମଃନାର୍‌ ବାବ୍‌ନା ଇସାବେ ଜିସୁ ଜସେପାର୍‌ ହୟ୍‌ସି; ଜସେପ୍ ଏଲିର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମତାତର୍‌ ହୟ୍‌ସି, ମତାତ ଲେବିର୍‌ ହୟ୍‌ସି, ଲେବି ମଲ୍‌କିର୍‌ ହୟ୍‌ସି, ମଲ୍‌କି ଜନୟର୍‌ ହୟ୍‌ସି, ଜନୟ ଜସେପାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜସେପ୍ ମତିତ୍ୟାର୍‌ ହୟ୍‌ସି, ମତିତ୍ୟା ଆମସାର୍‌ ହୟ୍‌ସି, ଆମସ୍‌ ନାହୁମାର୍‌ ହୟ୍‌ସି, ନାହୁମ ହେସଲିର୍‌ ହୟ୍‌ସି, ହେସଲି ନଗୟାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମହତାର୍‌ ହୟ୍‌ସି, ମହତ ମତିତ୍ୟାର୍‌ ହୟ୍‌ସି, ମତିତ୍ୟା ସିମଇର୍‌ ହୟ୍‌ସି, ସିମଇ ଜସେକାର୍‌ ହୟ୍‌ସି, ଜସେକ ଜଦାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜଦା ଜହନାର୍‌ ହୟ୍‌ସି, ଜହନ୍‌ ରେସାର୍‌ ହୟ୍‌ସି, ରେସା ଜିରୁବାବେଲାର୍‌ ହୟ୍‌ସି, ଜିରୁବାବେଲ୍‌ ସଲ୍‌ଟିୟେଲାର୍‌ ହୟ୍‌ସି, ସଲ୍‌ଟିୟେଲ୍‌ ନେରିର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲକିର୍‌ ହୟ୍‌ସି, ମଲକି ଅଦିର୍‌ ହୟ୍‌ସି, ଅଦି କସାମାର୍‌ ହୟ୍‌ସି, କସାମ ଏଲ୍‌ମଦାନାର୍‌ ହୟ୍‌ସି, ଏଲ୍‌ମଦାନ ଏରର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର ଜିହସୁୟର୍‌ ହୟ୍‌ସି, ଜିହସୁୟ ଏଲିଆଜରାର୍‌ ହୟ୍‌ସି, ଏଲିଆଜର୍‌ ଜରିମର୍‌ ହୟ୍‌ସି, ଜରିମ ମତାତର୍‌ ହୟ୍‌ସି, ମତାତ ଲେବିର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବି ସିମିଅନାର୍‌ ହୟ୍‌ସି, ସିମିଅନ୍ ଜିଉଦାର୍‌ ହୟ୍‌ସି, ଜିଉଦା ଜସେପାର୍‌ ହୟ୍‌ସି, ଜସେପ୍ ଜନାମାର୍‌ ହୟ୍‌ସି, ଜନାମ ଏଲିଆକିମାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିଆକିମ୍‌ ମଲାହର୍‌ ହୟ୍‌ସି, ମଲାହ ମନାର୍‌ ହୟ୍‌ସି, ମନା ମତତାର୍‌ ହୟ୍‌ସି, ମତତା ନାତନାର୍‌ ହୟ୍‌ସି, ନାତନ୍‌ ଦାଉଦାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍‌ ଜିସିର୍‌ ହୟ୍‌ସି, ଜିସି ଅବେଦର୍‌ ହୟ୍‌ସି, ଅବେଦ ବୟଜାର୍‌ ହୟ୍‌ସି, ବୟଜ ସେଲହର୍‌ ହୟ୍‌ସି, ସେଲହ ନହସନାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହସନ୍ ଅମିନାଦବାର୍‌ ହୟ୍‌ସି, ଅମିନାଦବ୍‌ ଅଦ୍ମିନାର୍‌ ହୟ୍‌ସି, ଅଦ୍ମିନ୍ ଅର୍ନିର୍‌ ହୟ୍‌ସି, ଅଃର୍ନି ହିସ୍ରଣାର୍‌ ହୟ୍‌ସି, ହେସ୍ରଣ ପେରସାର୍‌ ହୟ୍‌ସି, ପେରସ୍‌ ଜିଉଦାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିଉଦା ଜାକୁବର୍‌ ହୟ୍‌ସି, ଜାକୁବ ଇସାକାର୍‌ ହୟ୍‌ସି, ଇସାକ୍‌ ଅବ୍ରାହାମାର୍‌ ହୟ୍‌ସି, ଅବ୍ରାହାମ୍‌ ତେରହର୍‌ ହୟ୍‌ସି, ତେରହ ନାହରାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହର ସରୁଗାର୍‌ ହୟ୍‌ସି, ସରୁଗ ରଗୁର୍‌ ହୟ୍‌ସି, ରଗୁ ପେଲଗାର୍‌ ହୟ୍‌ସି, ପେଲଗ ଏବରାର୍‌ ହୟ୍‌ସି, ଏବର୍‌ ସେଲହାର୍‌ ହୟ୍‌ସି, ");
INSERT INTO bdv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲହ କେନାନାର୍‌ ହୟ୍‌ସି, କେନାନ୍ ଅରପକଦାର୍‌ ହୟ୍‌ସି, ଅରପକଦା ସେମର୍‌ ହୟ୍‌ସି, ସେମ ନହର୍‌ ହୟ୍‌ସି, ନହର୍‌ ଉବାସି ଲେମକ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକ ମତୁସେଲହାର୍‌ ହୟ୍‌ସି, ମତୁସେଲହ ହନକାର୍‌ ହୟ୍‌ସି, ହନକ ଜେରଦାର୍‌ ହୟ୍‌ସି, ଜେରଦ ମହଲେଲାର୍‌ ହୟ୍‌ସି, ମହଲେଲ୍‌ କେନାନାର୍‌ ହୟ୍‌ସି ");
INSERT INTO bdv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ୍ ଏନସାର୍‌ ହୟ୍‌ସି, ଏନସ ସେତର୍‌ ହୟ୍‌ସି, ସେତ ଆଦମାର୍‌ ହୟ୍‌ସି, ଆଦମ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ଜର୍ଦନ୍ ଗାଡେ ହୁଣି ବାଉଳ୍‌ଲା, ଆର୍‌ ଚାଲିସ୍‌ ଦିନ୍‌ ହଃତେକ୍‌ ପବିତ୍ର ଆତ୍ମା ତାକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ କାଡାୟ୍‌ ନିଲି, ସେତି ଜିସୁକ୍‌ ସୟ୍‌ତାନ୍ ପରିକ୍ୟା କଃର୍ତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ସୟ୍‌ତାନ୍‌ ପରିକ୍ୟା କଃଲା ଦିନ୍‌ମଃନ୍‌ ଜିସୁ କାୟ୍‌ରି ହେଁ ନଃକାୟ୍‌ଲା ଆର୍‌ ସେ ସଃବୁ ଦିନ୍ ସଃର୍ଲାକ୍‌ ଜିସୁକେ ବେସି ବୁକ୍‌ ଲାଗ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ସଃଡେବଃଳ୍‌ ସୟ୍‌ତାନ୍ ତାକ୍‌ କୟ୍‌ଲି, “ତୁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତଃବେ ଇ ଟେଳାମଃନ୍‌କେ ରୁଟି ଅଃଉଁକେ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁ ସୟ୍‌ତାନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ଦଃର୍ମ୍‌ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ମାନାୟ୍‌ ଅଃବ୍‌କା ରୁଟି କାୟ୍‌ କଃରି ଜିବନ୍‌ ନଃରେୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ତାର୍‌ହଃଚେ ସୟ୍‌ତାନ୍ ଜିସୁକେ ଗଟେକ୍‌ ଉଚ୍ ଟାଣେ ନଃୟ୍‌କଃରି, ଚଃନେକ୍‌ ବିତ୍ରେ ଜଃଗତାର୍‌ ସଃବୁ ରାଇଜ୍‌କେ ଦଃକାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆରେକ୍‌, ସୟ୍‌ତାନ୍ ଜିସୁକେ କୟ୍‌ଲି, “ମୁଁୟ୍‌ ତକେ ଇ ସଃବୁର୍‌ ଅଃଦିକାର୍‌ ଆର୍‌ ଇ ସଃବୁ ଦଃନ୍‌ବିତ୍‌ ଦଃୟ୍‌ନ୍ଦ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ସଃବୁ ମକ୍‌ ସଃହ୍ରି ଦିଆ ଅୟ୍‌ଆଚେ, ଆର୍‌ ମୁଁୟ୍‌ ଜାକେ ମଃନ୍‌କଃଲେକ୍‌ ତାକ୍‌ ଦେଉଁହାରି । ");
INSERT INTO bdv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ସେତାକ୍‌ ତୁୟ୍‌ ଜଦି ମକ୍‌ ମୁଣ୍ଡିଆ ମାରି ଜୁଆର୍‌ କଃର୍ସି, ତଃବେ ଇ ସଃବୁ ମୁୟ୍‌ ତକ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଆଚେ, ‘ତୁୟ୍‌ ତର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ଜୁଆର୍‌ କଃର୍‌ ଆର୍‌ ତାର୍‌ ହଃକା ସେବା କଃର୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଆରେକ୍‌ ସୟ୍‌ତାନ୍ ଜିସୁକେ ଜିରୁସାଲମେ ନଃୟ୍‌ କଃରି ମନ୍ଦିର୍‌ ଟିହେ ଟିଆ କଃରାୟ୍‌ ତାକ୍‌ କୟ୍‌ଲି, “ତୁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତଃବେ ଇତି ହୁଣି ତଃଳେ ଡଃଗାଉ । ");
INSERT INTO bdv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ, ତକେ ବଚାଉଁକେ ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ଦୁତ୍‌ମଃନ୍‌କେ ଆଦେସ୍‌ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଆରେକ୍‌ ଇରି ହେଁ ଲେକା ଆଚେ, କଃଡେବଃଳ୍‌ ସିନା ତର୍‌ ହାଦ୍‌ ଟେଳାୟ୍‌ ହାୟ୍‌ଦ୍‌, ଇତାର୍‌ଗିନେ ସେମଃନ୍ ତକ୍‌ ଆତେ ଟେକି ଦଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ଆରେକ୍‌ ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ତୁୟ୍‌ ନିଜାର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ପରିକ୍ୟା କଃର୍‌ ନାୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ଜିସୁକେ, ସୟ୍‌ତାନ୍ ଇ ସଃବୁ ରଃକମାର୍‌ କଃଟ୍‌ହାଳ୍‌ ବୁଜି ସଃର୍ଲା ହଃଚେ ଅଃଳକ୍‌ କାଳ୍‌ ହଃତେକ୍‌ ତାକ୍‌ ଚାଡିକଃରି ହଃଳାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଆର୍‌ ହଃଚେ ଜିସୁ ଆତ୍ମାର୍‌ ସଃକାତ୍‌ ସଃଙ୍ଗ୍ ଗାଲିଲି ବାଉଳି ଗଃଲା, ଆର୍‌ ଚାରିହାକ୍‌ ତାର୍‌ କଃତା ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଆରେକ୍‌ ଜିସୁ ସେତିର୍‌ ଲକ୍‌ମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେମଃନ୍‌ ସିକ୍ୟା ଦଃୟ୍‌ ସଃବ୍‌କାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍‌ ହାଉଁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ତାର୍‌ହଃଚେ ଜିସୁ ଜୁୟ୍‌ ନାଜରିତେ ବାଡିରିଲା, ସେ ଟାଣେ ଗଃଲା ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ରିତିବିଦି ହଃର୍କାରେ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ଜାୟ୍‌ ହୁର୍ଲା, ଆର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ହାଟ୍‌କଃରୁକେ ଟିଆ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ସଃଡେବଃଳ୍‌ ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ପୁସ୍ତକ୍‌ ତାକ୍‌ ଦିଆଅୟ୍‌ଲି, ଆର୍‌ ଜିସୁ ସେ ପୁସ୍ତକ୍‌କେ ମେଲାକଃରି, ଜୁୟ୍‌ ଲଃଗେ ଇ କଃତା ଲେକା ଅୟ୍‌ଆଚେ, ସେରି ମିଳାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ମାପ୍ରୁର୍‌ ଆତ୍ମା ମର୍‌ ଉହ୍ରେ ଆଚେ, ଜଃନ୍‌କଃରି, ଦୁକି ଦିନାରିମଃନାର୍‌ ତଃୟ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ସେ ମକ୍‌ ଅବିସେକ୍‌ କଃରି ଆଚେ, ଜଃଇଲେ ରିଲା ଲକ୍‌ମଃନ୍‌କେ ମୁକ୍‌ଳାଉଁକେ ଆର୍‌ କାଣାମଃନାର୍‌ ତଃୟ୍‌ ଆକି ଦଃକ୍‌ତାର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ, ଆରେକ୍‌ ଅଃତ୍ୟାଚାର୍‌ ହାଉତା ଲକ୍‌ମଃନ୍‌କେ ମୁକ୍‌ଳାଉଁକେ, ");
INSERT INTO bdv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଆର୍‌ ମାପ୍ରୁ ତାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଉହ୍‌କାର୍‌ କଃର୍ତା ବଃର୍ସ୍‌ ଆସିଆଚେ, ଇ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ ସେ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ତାର୍‌ହଃଚେ ସେ ପୁସ୍ତକ୍‌କେ ବଃନ୍ଦ୍‌କଃରି ସେତିର୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ଜାଗୁଆଳି ଲକେ ଦଃୟ୍‌କଃରି ବଃସ୍‌ଲା । ଆର୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ଆକି ତାର୍‌ ଉହ୍ରେ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “ଆଜି ଦଃର୍ମ୍‌ ସାସ୍ତରାର୍‌ ଇ କଃତା ତୁମିମଃନାର୍‌ ସୁଣ୍‌ତା ହଃର୍କାରେ ହୁରୁଣ୍ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଆର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ତାର୍‌ କଃତାକ୍‌ ସଃତ୍‌ ବଃଲି ସାକି ଦେଉଁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ଟଣ୍ଡେ ହୁଣି ବାରାୟ୍‌ଲା ଦଃୟାୟ୍‌ ଉହ୍‌କାର୍‌ କଃର୍ତା କଃତାର୍‌ ଗିନେ କାବା ଅୟ୍‌ଗଃଲାୟ୍‌; ଆରେକ୍‌, ସେମଃନ୍ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଏ କାୟ୍‌ ଜସେପାର୍‌ ହୟ୍‌ସି ନୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ସେତାକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜାୟ୍‌ରି କଃତାୟ୍‌ ଆଚେ, ‘ତୁମିମଃନ୍ ବାୟ୍‌ଦ୍‌ରେ ମକ୍‌ ସେ କଃତା କଃଉଆସ୍‌, ଏ ବୟ୍‌ଦ୍‌କାରି ତୁୟ୍‌ ନିଜେ ଅଃହ୍‌ଣାକ୍‌ ଉଜ୍‌ କଃର୍‌ ।’ ଆରେକ୍‌ ହେଁ କଃଉଆସ୍‌, ‘କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଜାୟ୍‌ ଜାୟ୍‌ରି ଗଃଟି ଆଚେ ବଃଲି ଅଃମିମଃନ୍‌ ସୁଣି ଆଚୁ, ସେ ସଃବୁ ଇ ଲଃଗେ ଇତି ନିଜାର୍‌ ଜଃଲମ୍‌ ଗଃଳେ ହେଁ କଃର୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ଆରେକ୍‌ ସେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, କୁୟ୍‌ ବାବ୍‌ବାଦି ହେଁ ନିଜାର୍‌ ଦାଦିବାବୁର୍‌ ଗଃଳେ ମାନ୍‌ତି ନଃହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଏଲିୟର୍‌ ବଃଳ୍‌ ଜଃଡେବଃଳ୍‌ ତିନି ବଃର୍ସ୍‌ ଚଅ ମାସ୍‌ ହଃତେକ୍‌ ଅଃଗାସ୍‌ ବଃନ୍ଦ୍‌ ଅୟ୍‌ଲାକ୍‌ ସଃବୁ ଦେସ୍‌ଜାକ କଃତାର୍‌ ଅୟ୍‌ରିଲି, ସଃଡେବଃଳ୍‌ ଇସ୍ରାଏଲ୍‌ ଦେସେ ଗାଦେକ୍‌ ରାଣ୍ଡିମଃନ୍‌ ରିଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ଅୟ୍‌ଲେକ୍‌ ହେଁ ମାପ୍ରୁ ଏଲିୟକେ ସେମଃନାର୍‌ ବିତ୍ରେ କାର୍‌ ଲଃଗେ ହେଁ ନଃହେଟାୟ୍‌ କଃରି ସିଦନ୍ ଦେସାର୍‌ ସାରିପତାର୍‌ ଗଟେକ୍‌ ରାଣ୍ଡି ମାୟ୍‌ଜି ହାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଆରେକ୍‌ ବାବ୍‌ବାଦି ଇଲିସାୟର୍‌ ବଃଳ୍‌ ଇସ୍ରାଏଲ୍‌ ଦେସେ କଃତେକ୍‌ ବଃଡ୍‌ ରଗିମଃନ୍‌ ରିଲାୟ୍‌; ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନାର୍‌ ବିତ୍ରେ କେ ହେଁ ଉଜ୍‌ କଃରା ଅୟ୍‌ନଃରିଲାୟ୍‌, ମଃତର୍‌ ଅଃବ୍‌କା ସୁରିଆ ଦେସାର୍‌ ନାମାନ୍ ଉଜ୍‌ କଃରା ଅୟ୍‌ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ପାର୍ତ୍‌ନା ଗଃରେ ଇ ସଃବୁ କଃତା ସୁଣୁ ସୁଣୁ ସଃବୁ ଲକ୍‌ ରିସା ଅୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ଆରେକ୍‌ ସେମଃନ୍ ଉଟି ତାକାର୍‌ ଗଃଳେ ହୁଣି ଜିସୁକେ ବାର କଃଲାୟ୍‌ ଆର୍‌ ସେମଃନାର୍‌ ଗଃଳ୍‌ ଜୁୟ୍‌ ହଃର୍ବାତ୍‌ ଉହ୍ରେ ରିଲି, ସେ ହଃର୍ବାତ୍‌ ଉହ୍ରେ ହୁଣି ତଃଳେ ହେଲାଉଁକ୍‌ ତାକ୍‌ ସେତି ନିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମଃତର୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍ଦା ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ସେ କପୁର୍ନାହୁମ୍‌ ନାଉଁଆର୍‌ ଗାଲିଲିର୍‌ ଗଟେକ୍‌ ଗଃଳେ ଆୟ୍‌ଲା, ଆରେକ୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ସିକ୍ୟା ସୁଣି କାବା ଅୟ୍‌ ଗଃଳାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ କଃତା ଅଃଦିକାର୍‌ କଃତା ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଗଟ୍‌ ଦିନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ଗଟେକ୍‌ ବିଟାଳ୍‌ ବୁତ୍‌ ଦଃରିରିଲା ଲକ୍‌ ରିଲା; ସେ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଏ ନାଜରିତ୍‌ ଜିସୁ, ତର୍‌ ଅଃମାର୍‌ କାୟ୍‌ରି ଆଚେ ? ତୁୟ୍‌ କାୟ୍‌ ଅଃମିମଃନ୍‌କ୍‌ ନାସ୍‌ କଃରୁକେ ଆୟ୍‌ଲିସ୍‌ ? ତୁୟ୍‌ କେ, ସେରି ମୁଁୟ୍‌ ଜାଣି; ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ସେ ପବିତ୍ର ମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁ ତାକ୍‌ ଦଃମ୍‌କାୟ୍‌ କଃରି କୟ୍‌ଲା, “ତୁନ୍‌ହାଳ୍‌, ଇ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଜାଆ ।” ତାର୍‌ହଃଚେ ସେ ବୁତ୍‌ ତାକ୍‌ ମଃଜି ଟାଣେ ଅଦ୍ରାୟ୍‌ ଦଃୟ୍‌ ତାର୍‌ କାୟ୍‌ ନଃସ୍ଟ୍‌ ନଃକେରି ତାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଆର୍‌ ହଃଚେ ସଃବୁ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌କଃରି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଇରି କଃନ୍‌କା କଃତା ? ସେ ଅଃଦିକାର୍‌ ଆର୍‌ ସଃକ୍ତିର୍‌ ସଃଙ୍ଗ୍ ବିଟାଳ୍‌ ଆତ୍ମାମଃନ୍‌କେ ଆଦେସ୍‌ ଦିଲେକ୍‌, ସେମଃନ୍ ବାରାୟ୍‌ ଜଃଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ତାର୍‌ହଃଚେ ତାର୍‌ ସଃବୁ କଃତା ଚାରିବାଟାର୍‌ ସଃବୁ ହାକ୍‌ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ତାର୍‌ହଃଚେ ଜିସୁ ପାର୍ତ୍‌ନା ଗଃରେହୁଣି ଉଟି ସିମନାର୍‌ ଗଃରେ ଗଃଲା । ସିମନାର୍‌ ସଃତୁର୍ସି ଜଃବର୍‌ ଜଃର୍ତିରିଲି, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ବିସୟେ ଜିସୁକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ସେତାର୍‌ ହଃଚେ ଜିସୁ ତାର୍‌ ଲଃଗେ ଟିଆ ଅୟ୍‌ ଜଃର୍‌କେ ଦଃମ୍‌କାୟ୍‌ଲା, ଆର୍‌ ତାର୍‌ ଜଃର୍‌ ଚାଡ୍‌ଲି, ଆରେକ୍‌ ସେ ସେଦାହ୍ରେ ଉଟିକଃରି ସେମଃନାର୍‌ ସେବା କଃରୁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ବେଳ୍‌ ବୁଡ୍‌ତା ବଃଳ୍‌, ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଲଃଗେ ବିନ୍ ବିନ୍ ରଃକମାର୍‌ ରଗ୍‌ଦୁକାୟ୍‌ ହଃଳ୍‌ଲା ଲକ୍‌ମଃନ୍ ରିଲାୟ୍‌, ସେ ସଃବ୍‌କେ ଜିସୁର୍‌ ଲଃଗେ ଆଣ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁ ସଃବୁ ଲକାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଆରେକ୍‌ ବୁତ୍‌ମଃନ୍‌ ହେଁ ଆଉଲି ଅୟ୍‌କଃରି, “ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି,” ବଃଲି କୟ୍‌ ଗାଦେକ୍‌ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଗଃଲାୟ୍‌ । ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ମଦାରେଉଁକେ କୟ୍‌ଲା ଆର୍‌ କଃତା କଃଉଁକେ ନଃଦିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ କ୍ରିସ୍ଟ ବଃଲି ସେମଃନ୍ ଜାଣିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ସଃକାଳ୍‌ ଅୟ୍‌ଲାକ୍‌, ଜିସୁ ଗଃଳେହୁଣି ବାରାୟ୍‌ ଜାୟ୍‌ ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ଗଃଲା; ଆର୍‌ ଲକ୍‌ମଃନ୍ଦା ତାକ୍‌ ଲଳି ଲଳି ତାର୍‌ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ସେ ସେମଃନାର୍‌ ଲଃଗେହୁଣି ଚାଡି ନଃଜାୟ୍‌ଁ, ସେତାର୍‌ଗିନେ ତାକ୍‌ ତେବାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବିନ୍ ବିନ୍ ଗଃଳେମଃନ୍ ହେଁ ମକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ମାପ୍ରୁର୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ହଃଳେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇତାର୍‌ ଗିନେ ମାପ୍ରୁ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଆରେକ୍‌ ସେ ଜିଉଦା ଦେସାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେମଃନ୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଗଟ୍‌ ଦିନ୍ ଜିସୁ ଗିନେସ୍‌ରଃତ୍‌ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ଟିଆ ଅୟ୍‌ରିଲା, ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ଦାମଃନ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଇସ୍ୱରାର୍‌ କଃତା ସୁଣୁକ୍‌ ତାର୍‌ ଉହ୍ରେ ମାଡାମାଡି ଅଃଉତି ରିଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଆର୍‌ ସେ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ଜଳେକ୍‌ ଡଙ୍ଗା ରିଲାର୍‌ ଦଃକ୍‌ଲା; ମାଚୁଆମଃନ୍‌ ସେତିହୁଣି ଉତ୍ରି ଜାଲ୍‌ ଦଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ସେତିର୍‌ ଡଙ୍ଗାମଃନାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଡଙ୍ଗା ସିମନାର୍‌ ରିଲି, ସେତି ଜିସୁ ଚଃଗ୍‌ଲା ଆର୍‌ କଃଣ୍ଡାୟ୍‌ ହୁଣି କଃଣ୍ଡେକ୍‌ ଦୁରିକ୍‌ ଜଃଉଁକେ ଗଃଉଆରି କଃଲାୟ୍‌; ଆର୍‌ ସେ ଡଙ୍ଗାୟ୍‌ହୁଣି ଲକ୍‌ମଃନ୍ଦାମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଜିସୁ କଃତା ସଃରାୟ୍‌କଃରି ସିମନ୍‌କ୍‌ କୟ୍‌ଲା, “ଡେଙ୍ଗ୍ ହାଣି ଲଃଗେ ଜାୟ୍‌ ମାଚ୍ ଦଃରୁକ୍‌ ତୁମାର୍‌ ଜାଲ୍‌ ହଃକାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ଆର୍‌ ହଃଚେ ସିମନ୍ ଉତୁର୍‌ ଦିଲା, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ରାତିସଃରା କଃସ୍ଟ୍‌କଃରି କାୟ୍‌ରି ହେଁ ନଃଦେରୁ; ମଃତର୍‌ ତର୍‌ କଃତା ମାନି କଃରି ମୁଁୟ୍‌ ଜାଲ୍‌ ହଃକାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଆର୍‌ ସେମଃନ୍ ଜାଲ୍‌ ହଃକାୟ୍‌କଃରି ଗାଦେକ୍‌ ମାଚ୍ ଦଃର୍ଲାୟ୍‌, ଆରେକ୍‌ ସେମଃନାର୍‌ ଜାଲ୍‌ ଚିଡୁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ସେତାର୍‌ଗିନେ ସେମଃନାର୍‌ ଜୁୟ୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ ବିନ୍ ଡଙ୍ଗାୟ୍‌ ରିଲାୟ୍‌, ସେମଃନ୍ ଜଃନ୍‌କଃରି ଆସିକଃରି ଉହ୍‌କାର୍‌ କଃର୍ତି, ସେତାର୍‌ ଗିନେ ସେମଃନ୍ ସେମଃନ୍‌କେ ଆତ୍‌ ମାରି କୁଦ୍‌ଲାୟ୍‌ । ତଃବେ ସେମଃନ୍ ଆସି ଜଳେକ୍‌ ଡଙ୍ଗା ଇବାନ୍ୟା ମାଚ୍ ବଃର୍ତି କଃଲାକ୍‌ ତାକାର୍‌ ଡଙ୍ଗାମଃନ୍‌ ବୁଡୁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ମଃତର୍‌ ସିମନ୍ ପିତର୍‌ ଇ ସଃବୁ ଦଃକି ଜିସୁର୍‌ ହାଦ୍‌ ତଃଳେ ହଃଳି କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ଜାଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ଗଟେକ୍‌ ହାହି ମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଅଃତେକ୍‌ ମାଚ୍ ଦଃରି ରିଲାୟ୍‌ ଜେ, ସେରି ଦଃକି ସିମନ୍ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆରେକ୍‌ ଜେବଦିର୍‌ ଜଳେକ୍‌ ହୟ୍‌ସି ଜାକୁବକ୍‌ ଆର୍‌ ଜହନ୍‌, ଜୁୟ୍‌ମଃନ୍‌ କି ସିମନାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌, ସେମଃନ୍ ହେଁ ସେରଃକମ୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ଆରେକ୍‌ ଜିସୁ ସିମନ୍‌କେ କୟ୍‌ଲା, “ଡିର୍ନାୟ୍‌, ଆଜିହୁଣି ତୁୟ୍‌ ମାନାୟ୍‌ମଃନ୍‌କେ ଦଃର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ସେତାର୍‌ ହଃଚେ ସେମଃନ୍ ଡଙ୍ଗାମଃନ୍‌ କଃଣ୍ଡାୟ୍‌ ଆଣି ସଃବୁ ଚାଡି କଃରି ଜିସୁର୍‌ ହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ଗଟ୍‌ତର୍‌ ଜିସୁ ଗଟ୍‌ ଗଃଳେ ରିଲା ବଃଳ୍‌, ଦଃକା, ସେତି ଗଟେକ୍‌ ବଃଡ୍‌ ରଗି ରିଲା; ସେ ଜିସୁକେ ଦଃକି ମୁଣ୍ଡିଆ ମାରିକଃରି କାନିକଃର୍ମ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ତୁୟ୍‌ ଜଦି ମଃନ୍‌ କଃର୍ସି, ତଃବେ ମକ୍‌ ଉଜ୍‌ କଃରୁ ହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ସେତାର୍‌ ଗିନେ ଜିସୁ ଆତ୍‌ ଲାମାୟ୍‌ ତାକ୍‌ ଚୁୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁଁୟ୍‌ ମଃନ୍‌ କଃରୁଲେ, ତୁୟ୍‌ ଉଜ୍‌ ଅଃଉ ।” ସେଦାହ୍ରେ ବଃଡ୍‌ ରଗ୍ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଆର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “କାକେ ହେଁ କଃଉ ନାୟ୍‌, ମଃତର୍‌ ସଃଳ୍‌କେ ଜାଜକ୍‌ ଲଃଗେ ଜାଆ, ଆର୍‌ ସେ ତକେ ପରିକ୍ୟା କଃରି ଦଃକ, ତାର୍‌ହଃଚେ ତୁୟ୍‌ ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ଆଚ୍‌ସି ବଃଲି ବିନ୍ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ସାକି ଦେଉଁକ୍‌ ମସାର୍‌ ବିଦି ହଃର୍କାରେ ଦାନ୍‌ ଦେସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ମଃତର୍‌ ଜିସୁର୍‌ କଃତା ଆରେକ୍‌ ଅଃଦିକ୍‌ ଉର୍ଜି ଅୟ୍‌ଲି, ଆରେକ୍‌ ଅଲେକାର୍‌ ଲକ୍‌ ତାର୍‌ ସିକ୍ୟା ସୁଣୁକ୍‌ ଆର୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ରଗେ ହୁଣି ଉଜ୍‌ ଅଃଉଁକେ ତାର୍‌ ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମଃତର୍‌ ସେ ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ସିଣିନ୍ଦ୍ ଜଃଗାୟ୍‌ମଃନ୍‌ ରଃୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଗଟ୍‌ଦିନ୍‌ ଜିସୁ ସିକ୍ୟା ଦେତିରିଲା, ଆର୍‌ ଗାଲିଲିର୍‌ ସଃବୁ ଗାଉଁ, ଆରେକ୍‌ ଜିଉଦା ରାଜି ଆର୍‌ ଜିରୁସାଲମେ ହୁଣି ଆସିରିଲା ପାରୁସି ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ଲଃଗେ ବଃସି ରିଲାୟ୍‌ । ଆର୍‌ ଜିସୁ ଜଃନ୍‌କଃରି ରଗ୍ ଉଜ୍‌ କଃରେଦ୍‌, ଇତାର୍‌ ଗିନେ ମାପ୍ରୁର୍‌ ସଃକ୍ତି ସେତି ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଆରେକ୍‌ ଦଃକା, କଃତେକ୍‌ ଲକ୍‌ ଗଟେକ୍‌ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକେ କଃଟେ ବୟ୍‌ଆଣି ତାକ୍‌ ବିତ୍ରେ ନେଉଁକେ ଆର୍‌ ଜିସୁର୍‌ ମୁଏଁ ସଃଙ୍ଗାଉଁକ୍‌ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ମଃତର୍‌ ଲକ୍‌ ମଃନ୍ଦାର୍‌ ଗିନେ ତାକ୍‌ ବିତ୍ରେ ନେଉଁକେ ବାଟ ନଃମିଳ୍‌ଲାକ୍‌ ସେମଃନ୍ ଗଃରାର୍‌ ଚାନି ଉହ୍ରେ ଜାୟ୍‌, ଚାନି କାଣା କଃରି କଃଟ୍‌ ସଃଙ୍ଗ୍ ତାକ୍‌ ମଃଜାୟ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଉତ୍ରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ଜିସୁ ସେମଃନାର୍‌ ବିସ୍ୱାସ୍‌ ଦଃକି କୟ୍‌ଲା, “ଏ ବାୟ୍‌, ତର୍‌ ହାହ୍‌ ସଃବୁ କେମା କଃରାଅୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ସେତାର୍‌ ଗିନେ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ବିତ୍ରେ କଃତାବାର୍ତା ଅୟ୍‌ ଇବାନ୍ୟା ବଃଲି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇ ମାନାୟ୍‌ ତ ଇସ୍ୱରାର୍‌ ଲିନ୍ଦା କଃରୁଲା, ଇ ମାନାୟ୍‌ କେ ? ଅଃବ୍‌କା ମାପ୍ରୁକ୍‌ ଚାଡି ଆର୍‌ କେ ହାହ୍‌ କେମା କଃରୁହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ କଃତାବାର୍ତା ବୁଜିକଃରି ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ମଃନ୍‌ ବିତ୍ରେ କାୟ୍‌ରି କଃତାବାର୍ତା ଅଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","କାୟ୍‌ରି ଉପାସ୍‌ ? ତର୍‌ ହାହ୍‌ ସଃବୁ କେମା କଃରା ଅୟ୍‌ଲି ବଃଲି କଃଉତାର୍‌, କି ଉଟ୍‌ ଇଣ୍ଡି ଜାଆ ବଃଲି କଃଉତାର୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ମଃତର୍‌ ହୁର୍ତିବିଏ ହାହ୍‌ କେମା କଃରୁକେ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଜେ ଅଃଦିକାର୍‌ ଆଚେ,” ଇରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ଜାଣୁ ହାରାସ୍‌, ଇତାର୍‌ ଗିନେ ଜିସୁ ଏକ୍‌ଅଃଙ୍ଗି ରଗିକ୍‌ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ, ଉଟ୍‌ ଆର୍‌ ନିଜାର୍‌ କଃଟ୍‌ ଦଃରି ନିଜାର୍‌ ଗଃରେ ଜାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ସେତାର୍‌ ହଃଚେ ସେ ସେଦାହ୍ରେ ସେମଃନାର୍‌ ମୁଏଁ ଉଟି, ଜୁୟ୍‌ କଃଟ୍‌ ଉହ୍ରେ ସେ ସୟ୍‌ରିଲା, ସେରି ଦଃରି ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ଗାୟ୍‌କଃରି ନିଜାର୍‌ ଗଃରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ସେତାର୍‌ ଗିନେ ସଃବୁଲକ୍‌ କାବା ଅୟ୍‌ ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ବେସି ଡିରିକଃରି କୟ୍‌ଲାୟ୍‌, “ଆଜି ଅଃମିମଃନ୍‌ କଃଡେକ୍‌ କାବା ଅଃଉତା କାମ୍‌ ଦଃକ୍‌ଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଆର୍‌ ହଃଚେ ଜିସୁ ବାରାୟ୍‌ ଜାୟ୍‌ ଲେବି ନାଉଁଆର୍‌ ଗଟେକ୍‌ ରିବ୍‌ନି ବଃଙ୍ଗ୍‌ଲାୟ୍‌ ସିସ୍ଟୁ ମାଗ୍‌ତା ଟାଣେ ବଃସିରିଲାର୍‌ ଦଃକି ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ସେତାକ୍‌ ଲେବି ସଃବୁ ଚାଡିକଃରି ଉଟ୍‌ଲା ଆର୍‌ ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଜଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଆରେକ୍‌ ଲେବି ନିଜାର୍‌ ଗଃରେ ଜିସୁର୍‌ ଗିନେ ଗଟେକ୍‌ ବଃଡ୍ ବଜି କଃଲା, ଆର୍‌ ଗାଦେକ୍‌ ରିବ୍‌ନି ଆର୍‌ ବିନ୍ ବିନ୍ ଲକ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ବଜି କାଉଁକେ ବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ସେତାର୍‌ ଗିନେ ପାରୁସିମଃନ୍ ଆର୍‌ ସେମଃନାର୍‌ ଦଃଳାର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଜିସୁର୍‌ ଚେଲାମଃନାର୍‌ ବିରଦେ କଃତା କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଆହିଉଆ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ନିକ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ବୟ୍‌ଦ୍‌କାରି ଲଳା ନାୟ୍‌, ମଃତର୍‌ ରଗିମଃନାର୍‌ ଗିନେ ଲଳା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ମୁଁୟ୍‌ ଦଃର୍ମି ଲକ୍‌ମଃନ୍‌କେ କୁଦୁକେ ନାସି, ମଃତର୍‌ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆସ୍ତା ହାହିମଃନ୍‌କେ କୁଦୁକେ ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","କଃତେକ୍‌ ଲକ୍‌ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଜହନ୍‌ ଆର୍‌ ଚେଲାମଃନ୍ ତର୍‌କେ ତର୍‌ ଉହାସ୍‌ ଆର୍‌ ପାର୍ତନା କଃର୍ତି, ପାରୁସିମଃନାର୍‌ ଚେଲାମଃନ୍ ହେଁ ସେବାନ୍ୟା କଃର୍ତି, ମଃତର୍‌ ତର୍‌ ଚେଲାମଃନ୍ କାଉଆ ହିଉଆ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବଃର ଗଚ୍ୟାମଃନାର୍‌ ସଃଙ୍ଗ୍ ବଃର ବିବା ଗଃରେ ରେତା ବଃଳ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ ସେମଃନ୍‌କେ ଉହାସ୍‌ କଃରାଉଁ ହାରାସ୍‌ ? କଃବେ ହେଁ ନାୟ୍‌ ! ");
INSERT INTO bdv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମଃତର୍‌ ବେଳ୍‌ ଆସେଦ୍‌, ଜଃଡେବଃଳ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ବଃରକେ ଅଃଲ୍‌ଗା କଃରା ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଉହାସ୍‌ କଃର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଗଟେକ୍‌ କଃତାନି କୟ୍‌ଲା, “କେହେଁ ନଃଉଆଁ ହଃଚ୍ୟାର୍‌ ହାଟ୍‌ଳି କଃଣ୍ଡେକ୍‌ ଚିରି ହଃର୍ନା ହଃଚ୍ୟାୟ୍‌ ନଃମିସାୟ୍‌; ମିସାୟ୍‌ଲେକ୍‌ ସେ ନଃଉଆଁ ହାଟ୍‌ଳି ହଃର୍ନା ହାଟ୍‌ଳିକ୍‌ ଅଃଦିକ୍‌ ଚିରେଦ୍‌, ଆରେକ୍‌ ନଃଉଆଁ ହଃଚ୍ୟାର୍‌ କଃଣ୍ଡେକ୍‌ ହାଟ୍‌ଳି ହେଁ ହଃର୍ନା ସଃଙ୍ଗ୍ ନଃମିସେ । ");
INSERT INTO bdv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଆର୍‌ କେହେଁ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହଃର୍ନା ଚାମ୍‌ ମଣାୟ୍‌ ନଃସେଙ୍ଗାୟ୍‌; ସଃଙ୍ଗାୟ୍‌ଲେକ୍‌ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଚାମ୍‌ ମଣାକେ ହଃଟାୟ୍‌ ଗଃସ୍ରି ଜାୟ୍‌ଦ୍‌, ଆର୍‌ ଚାମ୍‌ମଣା ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ମଃତର୍‌ ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ନଃଉଆଁ ଚାମ୍‌ ମଣାୟ୍‌ ସଃଙ୍ଗାଉଁ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆର୍‌, କେ ହେଁ ହଃର୍ନା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କାୟ୍‌କଃରି ନଃଉଆଁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କାଉଁକେ ମଃନ୍ ନଃକେରେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ କୟ୍‌ଦ୍‌, ହଃର୍ନାରି ତ ବେସି ନିକ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ଗଟେକ୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜିସୁ ଗଅଁ ହଃଦା ବାଟ ଅୟ୍‌କଃରି ଜାତିରିଲା ବଃଳ୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗଅଁ କେଡ୍ ଚିଡାୟ୍‌ ତାକାର୍‌ ଆତେ ରଃମ୍‌ନ୍ଦି କାତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ମଃତର୍‌ ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ କଃତିଲକ୍‌ କୟ୍‌ଲାୟ୍‌, “ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଜାୟ୍‌ରି କଃର୍ତାର୍‌ ସାସ୍ତରାର୍‌ ବିଦି ନାୟ୍‌, ସେରି ତୁମି କାୟ୍‌ତାକ୍‌ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ଦାଉଦ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ ବୁକେ ରିଲା ବଃଳ୍‌ ସେ କାୟ୍‌ କଃରିରିଲା, ସେରି କାୟ୍‌ ତୁମିମଃନ୍ କଃବେ ହେଁ ନଃହଳାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ସେ କଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଗଃରେ ହୁରିକଃରି, ଜୁୟ୍‌ ରୁଟି ମାପ୍ରୁର୍‌ ଲଃଗେ ଦିଆ ଅଃଉତି ରିଲି ସେରି ଜାଜକ୍‌ମଃନ୍‌କେ ଚାଡି କେହେଁ କାତା ବିଦି ନଃରିଲି, ସେରି ନଃୟ୍‌କଃରି କାୟ୍‌ରିଲା ଆର୍‌ ନିଜାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌କେ ହେଁ ଦଃୟ୍‌ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନଃରାର୍‌ ହୟ୍‌ସି ବିସାଉଁଣିବାର୍‌ ଦିନାର୍‌ ମାପ୍ରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଜିସୁ ଆରେକ୍‌ ଗଟେକ୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ହୁରି ସିକ୍ୟା ଦେତିରିଲା; ସେତି ଗଟେକ୍‌ ଲକ୍‌ ରିଲା, ତାର୍‌ କାତା ଆତ୍‌ ସୁକିଜାୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆର୍‌ କେଜାଣ୍ ଜିସୁ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଉଜ୍‌ କଃରେଦ୍‌ କି ବଃଲି କଃତେକ୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍ ଦଃକ୍‌ତି ରିଲାୟ୍‌, ଜଃନ୍‌କଃରି ସେମଃନ୍ ତାର୍‌ ବିରଦେ ଦଃସ୍‌ ଦଃର୍‌ତାର୍‌ ବାଟ୍‌ ହାଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ମଃନ୍ ବିତ୍ରାର୍‌ କଃତା ଜାଣୁ ହାରି, ଜୁୟ୍‌ ଲକାର୍‌ ଆତ୍‌ ସୁକିଜାୟ୍‌ରିଲି, ତାକ୍‌ କୟ୍‌ଲା, “ଉଟ୍‌ ମଃଜାୟ୍‌ ଟିଆ ଅଃଉ ।” ଆର୍‌ ସେ ଉଟି ଟିଆ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ହଃଚାରୁଲେ, ବିସାଉଁଣିବାର୍‌ ଦିନ୍ କାୟ୍‌ କଃର୍ତା ବିଦି ? ନିକ କଃର୍ତାର୍‌ କି କଃରାବ୍‌ କଃର୍ତାର୍‌ ? ଜିବନ୍‌ ବଚାଉତାର୍‌ କି ନାସ୍‌ କଃର୍ତାର୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଆର୍‌ ସେ ଚାରିହାକ୍‌ ସଃବ୍‌କେ ଦଃକିକଃରି ତାକ୍‌ କୟ୍‌ଲା, “ତର୍‌ ଆତ୍‌ ଲାମାଉ ।” ତଃବାର୍‌ ଗିନେ ସେ ଆତ୍‌ ଲାମାୟ୍‌ଲା, ଆରେକ୍‌ ତାର୍‌ ଆତ୍‌ ନିକ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମଃତର୍‌ ସେମଃନ୍ ବଃଡେ ରିସା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁର୍‌ ବିରଦେ କାୟ୍‌ କଃରୁଆଁ ବଃଲି ନିଜାର୍‌ ନିଜାର୍‌ ବିତ୍ରେ କଃତାବାର୍ତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ସଃଡେବଃଳ୍‌ ଗଟ୍‌ଦିନ୍‌ ଜିସୁ ପାର୍ତ୍‌ନା କଃରୁକେ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଜାୟ୍‌କଃରି ରାତିସଃରା ଇସ୍ୱରାର୍‌ ଲଃଗେ ପାର୍ତନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ସଃକାଳ୍‌ ହାୟ୍‌ଲା ଦାହ୍ରେ ସେ ନିଜାର୍‌ ଚେଲାମଃନ୍‌କେ ଚଃମେ କୁଦି ସେମଃନାର୍‌ ବିତ୍ରେ ବାର ଲକ୍‌କେ ବାଚ୍‌ଲା, ଆର୍‌ ସେମଃନ୍‌କେ ପେରିତ ବଃଲି ନାଉଁ ଦିଲା; ");
INSERT INTO bdv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ସେମଃନ୍ ଅୟ୍‌ଲାୟ୍‌, ସିମନ୍, ଜାକେ ସେ ପିତର୍‌ ବଃଲି ନାଉଁ ଦିଲା, ଆର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅ, ଜାକୁବ ଆର୍‌ ଜହନ୍‌, ପିଲିପ୍ ଆର୍‌ ବାର୍ତଲମି, ");
INSERT INTO bdv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ଆର୍‌ ତମା, ଆଲ୍‌ପିଅର୍‌ ହୟ୍‌ସି ଜାକୁବ ଆର୍‌ ସିମନ୍ ଜାକେ ତିକ୍‌ତିକା ବଃଲି କଃଉତି, ");
INSERT INTO bdv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବର୍‌ ହୟ୍‌ସି ଜିଉଦା ଆର୍‌ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା, ଜେ କି ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଆର୍‌ ଜିସୁ ଡଙ୍ଗ୍ରେ ହୁଣି ପେରିତ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଉତ୍ରି ଆୟ୍‌ଲା । ଆରେକ୍‌ ତାର୍‌ ଗାଦେକ୍‌ ଚେଲା ମଃନାର୍‌ ସଃଙ୍ଗ୍ ସଃର୍ସି ବୁୟେଁ ଟିଆ ଅୟ୍‌ଲା, ଆରେକ୍‌ ସଃବୁ ଜିଉଦା ରାଜି, ଜିରୁସାଲମ୍‌, ଆର୍‌ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ରିଲା ସର୍‌ ଆର୍‌ ସିଦନ୍‌ ଗଃଳେହୁଣି ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ଆସି ରୁଣ୍ଡ୍‌ଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ସେମଃନ୍ ଜିସୁର୍‌ କଃତା ସୁଣୁକ୍‌ ଆର୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ରଗେ ହୁଣି ଉଜ୍‌ ଅଃଉଁକେ ଆସି ରିଲାୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ମଃନ୍‌ ବିଟାଳ୍‌ ଆତ୍ମାମଃନାର୍‌ ଗିନେ କଃସ୍ଟ୍‌ ହାଉତିରିଲାୟ୍‌, ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଉଜ୍‌ କଃଲା; ");
INSERT INTO bdv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ଆରେକ୍‌ ଲକ୍‌ମଃନ୍ଦା ଜିସୁକେ ଚିଉଁକ୍‌ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ସଃକ୍ତି ବାରାୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃର୍ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ସଃଡେବଃଳ୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ଦଃକିକଃରି କୟ୍‌ଲା, “ଦୁକିଦିନାରି ଜେ ତୁମିମଃନ୍, ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ତୁମିମଃନ୍‌କାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ଅଃବେ ବୁକେ ଆଚାସ୍‌ ଜେ ତୁମିମଃନ୍, ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ଆଦାର୍‌ ହୁରେଦ୍‌ । ଅଃବେ କାନ୍ଦୁଲାସ୍‌ ଜେ ତୁମିମଃନ୍, ତୁମାର୍‌ ବାୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ନିଚଳାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଗିନେ ଲକ୍‌ମଃନ୍ ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍‌କେ ଗିଣ୍ କଃର୍ତି, ଜାତିବାର୍‌ତି, ଆରେକ୍‌ ଲିନ୍ଦା କଃର୍ତି, ଆର୍‌ ତୁମାର୍‌ ନାଉଁକେ କଃରାବ୍‌ ବଃଲି ମାନ୍‌ତି ନଃକେର୍ତି, ତଃବେ ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ସେ ଦିନ୍ ସଃର୍ଦା ଅୟ୍‌ ନାଚା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦଃକା, ସଃର୍ଗେ ତୁମାର୍‌ ଗିନେ ଗାଦି ପୁରିସ୍କାର୍‌ ଆଚେ; ଆର୍‌, ସେବାନ୍ୟା ତ ସେମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍ ବାବ୍‌ବାଦିମଃନ୍‌କେ କଃର୍ତି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ମଃତର୍‌ ଚି, ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ମାଜନ୍ ଲକ୍‌ ତୁମିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସୁକ୍‌ ବଗ୍ କଃରିଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଚି, ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ଜେ ତୁମିମଃନ୍ ଅଃବେ ଆଦାର୍‌ ହୁର୍ଲା ଲକ୍‌ମଃନ୍ ଜେ ତୁମିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ବୁକେ ମଃରାସ୍‌ । ଚି, ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ଜେ ତୁମିମଃନ୍ ଅଃବେ ନିଚଳୁଲାସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ମଃନ୍ଦୁକ୍‌ କଃରାସ୍‌ ଆର୍‌ କାନ୍ଦାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ଜଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନାର୍‌ ଗୁଣ୍ କଃଉତି, ସଃଡେବଃଳ୍‌ ଚି, ତୁମିମଃନ୍ ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌; ସେବାନ୍ୟା ତ ସେମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍ ମିଚ୍ ବାବ୍‌ବାଦିମଃନ୍‌କେ କଃର୍ତି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ମଃତର୍‌ ସୁଣୁଲାସ୍‌ ଜେ ତୁମିମଃନ୍, ତୁମିମଃନ୍‌କେ ମୁଁୟ୍‌ କଃଉଁଲେ, ତୁମାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ ଲାଡ୍‌ କଃରା; ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍‌କେ ଗିଣ୍ କଃର୍ତି, ସେମଃନାର୍‌ ବଃଲ୍‌ ଚିତା କଃରା; ");
INSERT INTO bdv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ସାୟ୍‌ପ୍‌ ଦେତି, ସେମଃନ୍‌କେ ଆସିର୍ବାଦ୍‌ କଃରା; ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ହିନ୍‌ମାନ୍ କଃର୍ତି, ସେମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃରା । ");
INSERT INTO bdv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଜେ ତୁମିକେ ଗଟେକ୍‌ ଗାଲେ ଚାହୁଳ୍‌ ମାରେଦ୍‌, ତାର୍‌ ଗିନେ ଆରେକ୍‌ ଗଟେକ୍‌ ଗାଲ୍‌ ହେଁ ଦଃକାୟ୍‌ ଦିଆସ୍‌; ଆର୍‌ ଜେ ତୁମାର୍‌ ହଃଚ୍ୟା ନଃୟ୍‌ଦ୍‌, ତାକ୍‌ ତୁମାର୍‌ ଆଙ୍ଗି ହେଁ ନେଉଁକେ ମଃନା କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଜୁୟ୍‌ ଲକ୍‌ ତୁମିକେ ମାଗେଦ୍‌, ତାକ୍‌ ଦିଆସ୍‌; ଆର୍‌ ଜେ ତୁମାର୍‌ ଦଃନ୍‌ବିତ୍‌ ନଃୟ୍‌ ଜାୟ୍‌ଦ୍‌, ତାର୍‌ ତଃୟ୍‌ହୁଣି ସେରି ଆରେକ୍‌ ମାଗା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ଲକ୍‌ମଃନ୍ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଜଃନ୍‌କା ବେବାର୍‌ କଃରତ୍‌ ବଃଲି ମଃନ୍ କଃରୁଲାସ୍‌, ତୁମିମଃନ୍ ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେବାନ୍ୟା ବେବାର୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍‌କେ ଲାଡ୍‌ କଃର୍ତି, ସେମଃନ୍‌କେ ହଃକା ଲାଡ୍‌ କଃଲେକ୍‌, ତୁମି କାୟ୍‌ ଦଃର୍ମ୍‌ ହାଉଆସ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହାହିମଃନ୍‌ ହେଁ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଲାଡ୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍‌କେ ଲାଡ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ତୁମାର୍‌ ବଃଲ୍‌ କଃର୍ତି, ଜଦି ତୁମିମଃନ୍ ସେମଃନାର୍‌ ହଃକା ନିକ କଃରାସ୍‌, ତଃବେ ତୁମିମଃନ୍ କାୟ୍‌ ଆସିର୍ବାଦ୍‌ ହାଉଆସ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହାହିମଃନ୍‌ ହେଁ ସେବାନ୍ୟା କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଆରେକ୍‌, ଜୁୟ୍‌ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ତୁମାର୍‌ ହାଉତା ଆସା ରଃୟ୍‌ଦ୍‌, ସେମଃନ୍‌କେ ହଃକା ରିଣ୍ ଦିଲେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ ଦଃୟା ହାଉଆସ୍‌ ? ହାହିମଃନ୍‌ ହେଁ ସଃମାନ୍ ଇସାବେ କଃଣ୍‌ତର୍‌ ହାଉଁକ୍‌ ହାହିମଃନ୍‌କେ ରିଣ୍ ଦେତି । ");
INSERT INTO bdv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମଃତର୍‌ ତୁମାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ ଲାଡ୍‌ କଃରା ଆର୍‌ ସେମଃନାର୍‌ ନିକ କଃରା, ଆରେକ୍‌ କଃଣ୍‌ତର୍‌ ହାଉଁକ୍‌ ଆସା ନଃକେରି ରିଣ୍ ଦିଆସ୍‌; ସେବାନ୍ୟା କଃଲେକ୍‌ ତୁମିମଃନ୍‌କାର୍‌ ପୁରିସ୍କାର୍‌ ବୁତେକ୍‌ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ତୁମିମଃନ୍ ସଃବ୍‌କେ ଉଟ୍ୟା ମାପ୍ରୁର୍‌ ହୟ୍‌ସି ଅଃଉଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦନ୍ୟବାଦ୍‌ ନଃଦେତା ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ଦୁସ୍ଟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଇସ୍ୱର୍‌ ଦଃୟା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ତୁମାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଜଃନ୍ କଃରି ଦଃୟାକାରି, ତୁମିମଃନ୍ ହେଁ ସେବାନ୍ୟା ଦଃର୍ମି ଅଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ଆରେକ୍‌, ବିନ୍ ଲକାର୍‌ ବିଚାର୍‌ କଃରାନାୟ୍‌, ତଃବେ ଇସ୍ୱର୍‌ ତୁମିକେ ବିଚାର୍‌ ନଃକେରେ; ଦସି କଃରା ନାୟ୍‌, ତଃବେ ମାପ୍ରୁ ହେଁ ତୁମିକେ ଦସି ନଃକେରେ । କେମା କଃରା, ତଃବେ ତୁମିକେ ହେଁ ଇସ୍ୱର୍‌ କେମା କଃରେଦ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଦାନ୍‌ ଦିଆସ୍‌, ତଃବେ ଇସ୍ୱର୍‌ ତୁମିକେ ହେଁ ଦାନ୍‌ ଦଃୟ୍‌ଦ୍‌ ଲକ୍‌ମଃନ୍ ମାଣ୍‌କ୍ ହୁରାକଃରି ତାକ୍‌ ଚାହି ଜଲାୟ୍‌ ଉଚ୍‌ଳାୟ୍‌କଃରି ତୁମିମଃନାର୍‌ ଆଚଳେ ଦେତି; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ମାଣେ ନାହି ଦିଆସ୍‌, ସେ ମାଣେ ତୁମିମଃନ୍ ଆରେକ୍‌ ହାଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଜିସୁ ସେମଃନ୍‌କେ ଗଟେକ୍‌ କଃତା ହେଁ କୟ୍‌ଲା, “ଗଟେକ୍‌ କାଣା ଆରେକ୍‌ ଗଟେକ୍‌ କାଣାକେ ବାଟ୍‌ କାଡାଉଁକେ ହାରେ ? ସେମଃନ୍ କାୟ୍‌ ଦୁୟ୍‌ ଲକ୍‌ ହେଁ କାଲେ ନଦୁର୍ତି ? ");
INSERT INTO bdv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁ ତଃୟ୍‌ହୁଣି ଚେଲା ବଃଡ୍ ନାୟ୍‌; ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ଚେଲା ଗୁରୁ ତଃୟ୍‌ହୁଣି ସଃବୁ ସିକେଦ୍‌ ତଃବେ ସେ ହେଁ ଗୁରୁର୍‌ ସଃମାନ୍ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ଆର୍‌, କାୟ୍‌ତାକ୍‌ ତୁମାର୍‌ ନିଜାର୍‌ ବାୟ୍‌ର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ କୁଟା ଦଃକୁଲାସ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ନିଜାର୍‌ ଆକାୟ୍‌ ଜୁୟ୍‌ ବଃଡ୍ ଆକିକୁଟା ଆଚେ, ସେରି କାୟ୍‌ତାକ୍‌ ବାବି ନଃଦେକୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ତୁମି ନିଜାର୍‌ ଆକାୟ୍‌ ରିଲା ବଃଡ୍ ଆକିକୁଟା ନଃଦେକି କଃନ୍‌କଃରି ନିଜାର୍‌ ବାୟ୍‌କ୍‌ କଃଉଁ ହାରାସ୍‌, ବାୟ୍‌, ଆଉ, ତର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ ଆକିକୁଟା ବାର୍‌ କଃରି ଦଃୟ୍‌ନ୍ଦ୍ ? ରେ, ହେଟ୍‌କପଟ୍ୟାମଃନ୍‌, ଆଗ୍‌ତୁ ନିଜାର୍‌ ଆକାୟ୍‌ ରିଲା ବଃଡ୍ ଆକିକୁଟା ବାର୍‌ କଃରି ହଃକାଉଆ, ତାର୍‌ହଃଚେ ନିଜାର୍‌ ବାୟ୍‌ ମଃନାର୍‌ ଆକାୟ୍‌ ରିଲା ସାନ୍ ଆକିକୁଟା ବାର୍‌ କଃରୁକ୍‌ ନିକ କଃରି ଦଃକୁ ହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ବଃଲ୍‌ ଗଃଚେ କଃରାବ୍‌ ହଃଳ୍‌ ନଃହେଳେ, କଃରାବ୍‌ ଗଃଚେ ବଃଲ୍‌ ହଃଳ୍‌ ନଃହେଳେ । ");
INSERT INTO bdv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃବୁ ଗଃଚ୍‌କେ ତାର୍‌ ହଃଳ୍‌ ଦଃକି ଚିନୁକ୍‌ ଅୟ୍‌ଦ୍‌, କାଟା ଗଃଚେ ହୁଣି ଲକ୍‌ମଃନ୍ ଡୁମ୍ବୁର୍‌ ହଃଳ୍‌ ନଃକଳ୍‌ତି, କି କାଟାବୁଟା ଲଃଗେହୁଣି ଅଙ୍ଗୁର୍‌ ହଃଳ୍‌ ନଃକଳ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ଗଟେକ୍‌ ସଃତ୍‌ ଲକ୍‌ ତାର୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ରିଲା ନିକ କଃତା ସଃବୁ ବାର୍‌ କଃରେଦ୍‌, ଗଟେକ୍‌ କଃରାବ୍‌ ଲକ୍‌ ତାର୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ରିଲା କଃରାବ୍‌ କଃତା ସଃବୁ ବାର୍‌ କଃରେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗଃର୍ବ୍‌ ବିତ୍ରେ ରିଲା ସଃବୁ କଃତା ଟଣ୍ଡ୍ ବାଟ ହଃଦାୟ୍‌ ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ଆର୍‌, ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ମକ୍‌ ମାପ୍ରୁ, ମାପ୍ରୁ ବଃଲି କଃଉଁଲାସ୍‌, ମଃତର୍‌ କାୟ୍‌ତାକ୍‌ ମର୍‌ କଃତା ନଃମାନୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ଲଃଗେ ଆସି ମର୍‌ କଃତା ସୁଣି ସେ ସଃବୁ ମାନେଦ୍‌, ସେ କାର୍‌ ସଃମାନ୍, ସେରି ମୁଁୟ୍‌ ତୁମିକେ କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ସେ ଇବାନ୍ୟା ଗଟେକ୍‌ ଗଃର୍‌ ବାନ୍ଦ୍‌ତା ଲକ୍‌ ହର୍‌, ଜେ ଡେଙ୍ଗ୍ କଃରି କାଲ୍‌ କଃଣି ଟେଳାକୁନାଦି ହଃକାୟ୍‌ରିଲା, ହୁର୍‌ ଆୟ୍‌ଲି ଆର୍‌ ସେ ଗଃର୍‌କେ ଦଃକା ମାର୍‌ଲି, ମଃତର୍‌ ସେ ଗଃର୍‌କେ ଡୁଳାଉଁକ୍‌ ନାହାର୍ଲି, ବଃଲେକ୍‌ ସେରି ନିକ କଃରି ବାନ୍ଦା ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମଃତର୍‌ ଜେ ସୁଣି ନଃମାନେ, ସେ କୁନାଦି ନଃମାରି ମାଟିଉହ୍ରେ ଗଃର୍‌ ବାନ୍ଦିରିଲା ଲକ୍‌ ହର୍‌; ବାଉବଃତାସ୍‌ ଆୟ୍‌ଲି ଆର୍‌ ସେ ଗଃର୍‌କେ ଜଃବର୍‌କଃରି ଦଃକ୍ୟା ମାର୍‌ଲି, ସେଦାହ୍ରେ ସେ ଗଃର୍‌ ବାଙ୍ଗି ଗଃଲି ଆର୍‌ ତାର୍‌ ଦଃସା ବୟ୍‌ଙ୍କାର୍‌ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁର୍‌ କଃତା ଲକ୍‌ମଃନ୍ ସୁଣ୍‌ତି ରିଲାବଃଳ୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ କଃତା କୟ୍‌ ସଃରାୟ୍‌କଃରି କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ସଃଡେବଃଳ୍‌ ଗଟେକ୍‌ ସଏ ସଃଇନାର୍‌ ଉହ୍ରେ ବଃଡ୍ ସଃଇନାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ମଃଳୁ ହଃଳି ରିଲା । ସେ ତାକ୍‌ ବଃଡେ ଲାଡ୍‌ କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ସେ ଜିସୁର୍‌ ବିସୟେ କବୁର୍‌ ହାୟ୍‌ ସେ ଜଃନ୍‌କଃରି ଆସି ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାର୍‌ ଜିବନ୍ ଉଜ୍‌ କଃରେଦ୍‌, ଆର୍‌ ଗିନେ ତାର୍‌ ହାକ୍‌ ଜିଉଦିମଃନାର୍‌ କଃତେକ୍‌ ପାରାଚିନ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌ ଗଃଉଆରି କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ସେମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ହଚି ତାକ୍‌ ବଃଡେ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲାୟ୍‌, “ତୁୟ୍‌ ତାର୍‌ ଗିନେ ଇରି କଃର୍ସି, ସେ ସେତାର୍‌ ଜୟ୍‌ଗ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଅଃମାର୍‌ ଜିଉଦି ଲକ୍‌ମଃନ୍‌କେ ଲାଡ୍‌ କଃରୁଲା ଆର୍‌ ସେ ନିଜେ ଅଃମାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା ଗଃର୍‌ ବାନ୍ଦି ଦଃୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ସେତାକ୍‌ ଜିସୁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଃଲା, ସେ ଗଃରାର୍‌ ଅଃଳକ୍‌ ଲଃଗେ ହଚ୍‌ଲାକ୍‌, ସଃଇନ୍ ମଃନାର୍‌ ବଃଡ୍ ସଃଇନ୍ ତାର୍‌ ଅଃହ୍‌ଣାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ହଃଟାୟ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ମାପ୍ରୁ କଃସ୍ଟ୍‌ କଃର୍‌ ନାୟ୍‌ ନି, ବଃଲେକ୍‌ ତୁୟ୍‌ ଜେ ମର୍‌ ଗଃରେ ହାଦ୍‌ ହଃକାଉସି ମୁଁୟ୍‌ ଅଃନ୍‌କା ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଇତାକ୍‌ ମୁଁୟ୍‌ ତର୍‌ ଲଃଗେ ଜଃଉଁକେ ଜୟ୍‌ଗ୍‌ ବଃଲି ମଃନେ ନଃବାବ୍‌ଲେ, ମଃତର୍‌ ହଃଦେକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ କଃଉ, ମର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଉଜ୍‌ ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ମର୍‌ ଉହ୍ରାର୍‌ ଅଃଦିକାରି ତଃଳେ ରେତା ଲକ୍‌ ଅୟ୍‌ଲେକ୍‌ ହେଁ ମର୍‌ ତଃଳେ ସଃଇନ୍‌ମଃନ୍ ଆଚ୍‌ତି; ମୁଁୟ୍‌ ଗଟ୍‌ ଲକ୍‌କେ, ‘ଜାଆ !’ ବଃଲେକ୍‌ ସେ ଜାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌କେ, ‘ଆଉ !’ ବଃଲେକ୍‌ ସେ ଆସେଦ୍‌; ଆର୍‌ ମର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌, ଇରି କଃର୍‌ ! ବଃଲେକ୍‌ ସେ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ଇ ସଃବୁ କଃତା ସୁଣି ବଃଡେ କାବା ଅୟ୍‌ଲା, ଆର୍‌ ଲେଉଟି ଦଃକି ତାର୍‌ ହଃଚେ ଆସ୍ତା ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ହେଁ ଅଃଡେକ୍‌ ବଃଡ୍ ବିସ୍ୱାସ୍‌ ନଃହାୟ୍‌ଁ । ");
INSERT INTO bdv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଆର୍‌ ହଃଟାୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ଗଃରେ ବାଉଳି ଆସି ସେ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଉଜ୍‌ ଅୟ୍‌ଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଆର୍‌ ହଃଚେ ଜିସୁ ନାଇନ ନାଉଁଆର୍‌ ଗଃଳେ ଗଃଲା ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଜିସୁ ଗଃଳ୍‌ ଦୁଆର୍‌ ଚଃମେ ହଚ୍‌ଲାକ୍‌, ଦଃକା ଲକ୍‌ମଃନ୍ ଗଟେକ୍‌ ମଃଲା ଲକ୍‌କେ ସେ ଗଃଳେ ହୁଣି ହଃଦାୟ୍‌ ବୟ୍‌ ଆଣ୍‌ତି ରିଲାୟ୍‌, ସେ ଆୟ୍‌ସିର୍‌ ଗଟେକ୍‌ ବଃଲି ହୟ୍‌ସି ରିଲା, ଆରେକ୍‌ ସେ ମାଇଜି ରାଣ୍ଡି, ଆର୍‌ ସେ ଗଃଳାର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ତାକ୍‌ ଦଃକି ମାପ୍ରୁ ତାକ୍‌ ଦଃୟା କଃରୁକେ ମଃନ୍ କଃରି କୟ୍‌ଲା, “କାନ୍ଦ୍‌ ନାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଆର୍‌ ସେ ଚଃମେ ଜାୟ୍‌ ମଃଳାଡଃଣ୍ଡିଆକେ ଚୁୟ୍‌ଲା, ଆରେକ୍‌ ମଃଳ୍‌ ବୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ଟିଆ ଅୟ୍‌ଲାକ୍‌, ଜିସୁ କୟ୍‌ଲା, “ଏ ବେଣ୍ଡ୍ୟା, ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ ଉଟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ସେତାକ୍‌ ମଃଲା ଲକ୍‌ ଉଟି ବଃସ୍‌ଲା, ଆର୍‌ କଃତା କଃଉଁକେ ଦଃର୍ଲା, ଆରେକ୍‌ ଜିସୁ ତାକେ ତାର୍‌ ଆୟ୍‌ସିର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଇତାକ୍‌ ସଃର୍ନେ ଲକ୍‌ମଃନ୍ ଡିରି ଗଃଳାୟ୍‌, ଆର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରି କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ବଃଡ୍ ବାବ୍‌ବାଦି ବାରାୟ୍‌ ଆଚେ, ଆର୍‌ ମାପ୍ରୁ ଅଃହ୍‌ଣାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ମୁକ୍‌ଳାଉଁକେ ଆସି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଆରେକ୍‌ ଜିସୁର୍‌ କଃତା ସଃବୁ ଜିଉଦା ଦେସ୍‌ ଆର୍‌ ଚାରି ଦିଗାର୍‌ ସଃବୁ ହଲି ବାଟ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ଆରେକ୍‌ ଜହନାର୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଇ ସଃବୁକଃତା ତାକ୍‌ ଜାୟ୍‌ ଜହନ୍‌କେ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ସେତାକ୍‌ ଜହନ୍‌ ଅଃହ୍‌ଣାର୍‌ ଚେଲା ମଃନାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ ଲକ୍‌କେ ଚଃମେ କୁଦି ମାପ୍ରୁ ହାକ୍‌ ଇରି କୟ୍‌ ହଃଟାୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ ଆସେଦ୍‌ ବଃଲି ଜହନ୍‌ କୟ୍‌ରିଲା, ତୁୟ୍‌ କାୟ୍‌ ସେ ମାନାୟ୍‌ ? କି, ଅଃମିମଃନ୍‌ ଆରେକ୍‌ ବିନ୍ କାକେ ଜାଗୁନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ସେ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ହଚି କୟ୍‌ଲାୟ୍‌, “ବାପ୍ତିସମ୍‌ ଦେଉ ଜହନ୍‌ ଅଃମିକ୍‌ ତର୍‌ ଚଃମେ ଇରି କଃଉଁକେ ହଃଟାୟ୍‌ଲା ଆଚେ, ଜାର୍‌ ଆସୁକ୍‌ ଆଚେ ସେ ଲକ୍‌ କାୟ୍‌ ତୁୟ୍‌ କି ଅଃମିମଃନ୍‌ ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଜାଗୁନ୍ଦ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ସଃଡେବଃଳ୍‌ ଜିସୁ ଗାଦେକ୍‌ ଲକ୍‌କେ କେମା କଃରି ରଗ୍, ଦୁକାସୁକା, ଆରେକ୍‌ ବୁତ୍‌ଡୁମା ତଃୟ୍‌ହୁଣି ଉଜ୍‌ କଃଲା, ଆରେକ୍‌ ଗାଦେକ୍‌ କାଣାକେ ଆକି ଦଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଆର୍‌ ସେ ଜହନାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ବାଉଳି ଜାହା ଆର୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣୁଲାସ୍‌ ଆର୍‌ ଦଃକୁଲାସ୍‌ ସେରି ସଃବୁ ଜହନ୍‌କେ ଜାଣାଉଆ, କାଣାମଃନ୍ ଦଃକୁ ହାରୁଲାୟ୍‌, ଚଟାମଃନ୍ ଇଣ୍ଡୁ ହାରୁଲାୟ୍‌, ବଃଡ୍‌ ରଗେ ହଃଳ୍‌ଲା ଲକ୍‌ମଃନ୍‌ ଉଜ୍‌ ଅଃଉଁଲାୟ୍‌, ବଃୟ୍‌ରାମଃନ୍ ସୁଣୁ ହାରୁଲାୟ୍‌, ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟୁଲାୟ୍‌ ଆର୍‌ ଦୁକିଦିନାରି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ହେଁ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରା ଅଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଆର୍‌ ଜେ ମକ୍‌ ଅବିସ୍ୱାସ୍‌ ନଃକେରି, ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ତାର୍‌ ବାୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜହନାର୍‌ ଚେଲାମଃନ୍ ଗଃଲା ହଃଚେ ଜିସୁ ଜହନ୍‌ ବିସୟେ କଃତା କଃଉଁକେ ଦଃର୍ଲା, “ତୁମି କାୟ୍‌ରି ଦଃକୁକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଜାୟ୍‌ ରିଲାସ୍‌, କାୟ୍‌ ବାଉୟେ ଜଲ୍‌ତା ସୁର୍ଲିନଃଳା ବୁଟାକ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ସେରି ନୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ରି ଦଃକୁକେ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାସ୍‌ ? କାୟ୍‌ ମଃସ୍‌ଣି ବଃସ୍ତର୍‌ ହିନ୍ଦି ରିଲା ମାନାୟ୍‌କେ ? ଦଃକା ଜୁୟ୍‌ମଃନ୍‌ ବୁତେକ୍‌ ମଲାର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦି ସୁକେ ରେତି, ସେମଃନ୍ ରଃଜାର୍‌ ନଃଉଁରେ ରେତି । ");
INSERT INTO bdv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ମକ୍‌ କଃଉଆ, ସେରି ନୟ୍‌ଲେକ୍‌ କାୟ୍‌ରି ଦଃକୁକ୍‌ ଜାୟ୍‌ରିଲାସ୍‌, କାୟ୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦିକେ ? ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ବାବ୍‌ବାଦି ତଃୟ୍‌ହୁଣି ସଃବ୍‌କେ ବଃଡ୍ ଲକ୍‌କେ, ");
INSERT INTO bdv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଜାର୍‌ ବିସୟେ ଦଃର୍ମ୍‌ ସାସ୍ତରେ ଲେକାଆଚେ, ‘ମାପ୍ରୁ କୟ୍‌ଲା, ଦଃକା ଅଃମାର୍‌ କବୁର୍‌କାରିଆ ତୁମାର୍‌ ଆଗ୍‌ତୁ ହଃଟାଉଁଲୁ, ସେ ତୁମାର୍‌ ଚଃମେ ତୁମାର୍‌ ବାଟ ହାଜେଦ୍‌, ଇରି ସେମାନାୟ୍‌ ଜହନ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମାୟ୍‌ଜି ହେଟେହୁଣି ଜଃଲମ୍‌ ଅୟ୍‌ଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ କେ ନାୟ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ମାପ୍ରୁର୍‌ ରାଇଜେ ଜେ ସାନ୍, ସେ ତାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସଃବୁ କଃତା ସୁଣ୍‌ତି ରିଲାୟ୍‌, ସେମଃନ୍, ମୁଳ୍‌କଃରି ରିବ୍‌ନିମଃନ୍‌, ଇସ୍ୱରାର୍‌ ବିଦି ହୁରୁଣ୍‌ କଃରି ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ନଃୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ମଃତର୍‌ ପାରୁସି ଆର୍‌ ବିଦି ସିକାଉମଃନ୍‌ ସେମଃନାର୍‌ ଜିବନାର୍‌ ଗିନେ ଇସ୍ୱରାର୍‌ ଇଚାକ୍‌ ଅମାନ୍ୟା କଃରି ଜହନାର୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ନଃୟ୍‌ ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ତଃବେ ମୁଁୟ୍‌ କାର୍‌ ସଃଙ୍ଗ୍ ଅଃବାର୍‌ ଜୁଗାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ତୁଳ୍‌ନା କଃରିନ୍ଦ୍‌, ଆରେକ୍‌ ସେମଃନ୍ କାର୍‌ ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଜୁୟ୍‌ ହିଲାମଃନ୍‌ ଆଟ୍‌ ବଃଜାରେ ବଃସି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କୁଦି କଃଉତି, ଅଃମିମଃନ୍‌ ତୁମାର୍‌ ଚଃମେ ସୁର୍ଲି ହୁକ୍‌ଲୁ, ତୁମିମଃନ୍ ନଃନାଚ୍‌ଲାସ୍‌, ଅଃମିମଃନ୍‌ ଦୁକେ ଦୁକ୍‌ ଗିତ୍‌ କୟ୍‌ଲୁ, ତୁମିମଃନ୍ ନଃକାନ୍ଦ୍‌ଲାସ୍‌, ସେମଃନ୍, ସେ ହିଲାମଃନାର୍‌ ହର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉ ଜହନ୍‌ ଆୟ୍‌ଲା ଆର୍‌ ରୁଟି ନଃକାଇଲା କି ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ହେଁ ନଃକାୟ୍‌ଲା ଆର୍‌ ତୁମିମଃନ୍ କୟ୍‌ଲାସ୍‌ ସେ ବୁତ୍‌ ଦଃରାୟ୍‌ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ନଃରାର୍‌ ହୟ୍‌ସି ଆୟ୍‌ଲା ଆର୍‌ କାଉଆ ହିଉଆ କଃରୁଲା ଆର୍‌ ତୁମିମଃନ୍ କଃଉଁଲାସ୍‌ ଦଃକା, ଇମାନାୟ୍‌ କାଉରାହେଟା ଆର୍‌ ମଃଦୁଆ, ରିବ୍‌ନି ଆର୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗୁଆଳି । ");
INSERT INTO bdv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ଗ୍ୟାନ୍ ସିକ୍‌ତି ସେମଃନାର୍‌ ଜିବନେ ତାର୍‌ ସଃତ୍‌ ହଃର୍‌ମାଣ ମିଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଆର୍‌ ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ତାର୍‌ ସଃଙ୍ଗ୍ ବଃସି କାଉଁକେ ଗଃଉଆରି କଃଲା, ସେତାକ୍‌ ଜିସୁ ପାରୁସି ଗଃରେ ଜାୟ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆର୍‌ ଦଃକା, ସେ ଗଃଳେ ଗଟେକ୍‌ ହାହି ମାଇଜିଟକି ରିଲି, ଜିସୁ ସେ ପାରୁସିର୍‌ ଗଃରେ କାଉଁକେ ବଃସି ରିଲା, ଇରି ଜାଣିକଃରି ସେ ଗଟେକ୍‌ କଣ୍ଡାୟ୍‌ ବାସ୍ନା ଚିକଣ୍ ଦଃରି ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ଆର୍‌ ଜିସୁର୍‌ ହଃଚ୍‌ବାଟ୍‌ ଆସି ତାର୍‌ ହାଦ୍‌ ଚଃମେ ଟିଅୟ୍‌, କାନ୍ଦି କାନ୍ଦି ତାର୍‌ ଆସୁହାଣାୟ୍‌ ହାଦ୍‌ ବିଜାୟ୍‌ଲି ଆର୍‌ ତାର୍‌ ମୁଣ୍ଡାର୍‌ ବାଳ୍‌ ସଃଙ୍ଗ୍ ହୁଚୁକ୍‌ ଦଃର୍ଲି, ଆର୍‌ ତାର୍‌ ହାଦ୍‌ ଚୁମି ଚୁମି ବାସ୍ନା ଚିକଣ୍‌ ହାଦ୍‌ଳାଉଁକ୍‌ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ସେରି ଦଃକି ଜୁୟ୍‌ ପାରୁସି ତାକେ କାଉଁକେ କୁଦି ରିଲା, ସେ ମଃନେ ମଃନେ କୟ୍‌ଲା, “ଏ ଜଦି ବାବ୍‌ବାଦି ଅୟ୍‌ରିଲେକ୍‌ ତାକ୍‌ ଜେ ଚିଉଁଲି ତଃବେ ସେ କେ ଆର୍‌ କଃନ୍‌କା ମାଇଜିଟକି, ବଃଲେକ୍‌ ସେ ହାହି ମାଇଜି ବଃଲି ଇରି ଜାଣୁ ହାର୍ଲା ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ସିମନ୍, ତକ୍‌ ମର୍‌ ହଃଦେକ୍‌ କଃଉତାର୍‌ ଆଚେ ।” ସିମନ୍ କୟ୍‌ଲା, “ମାପ୍ରୁ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ଗଟେକ୍‌ ମାଜନାର୍‌ ଜଳେକ୍‌ ରିଣିଆ ରିଲାୟ୍‌, ଗଟେକ୍‌ ହାଁଚ୍ ସଅ ଟଃକା ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌ ଦୁୟ୍‌ କଳି ଦଃସ୍‌ଟଃକା ରିଣ୍ କଃରି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ରିଣ୍ ସୁଜୁକ୍‌ କାୟ୍‌ରି ହେଁ ନଃରିଲାକ୍‌ ସାଉକାର୍‌ ସେ ଦୁୟ୍‌ ଲକେ କେମା କଃରି ରିଣ୍ ଚାଡି ଦିଲା, ଇତାକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କେ ତାକ୍‌ ଅଃଦିକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମନ୍ କୟ୍‌ଲା, “ମର୍‌ ବାବ୍‌ନାୟ୍‌ ସେ ଜାକେ କେମା କଃରି ଅଃଦିକ୍‌ ରିଣ୍ ଚାଡ୍‌ଲା ସେ ।” ଜିସୁ ସିମନ୍‌କ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଟିକ୍‌ ବିଚାର୍‌ କଃଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆର୍‌ ସେ ମାୟ୍‌ଜିଟକିକ୍‌ ଦଃକି ସିମନ୍‌କ୍‌ କୟ୍‌ଲା, “ଇ ମାୟ୍‌ଜିକେ କାୟ୍‌ ଦଃକୁଲିସ୍‌ ? ମୁଁୟ୍‌ ତର୍‌ ଗଃରେ ଆୟ୍‌ଲେ, ତୁୟ୍‌ ମର୍‌ ହାଦାର୍‌ ଗିନେ ହାଣି ନଃଦିଲିସ୍‌, ମଃତର୍‌ ଇ ମାୟ୍‌ଜି ଅଃହ୍‌ଣାର୍‌ ଆସୁ ହାଣାୟ୍‌ ମର୍‌ ହାଦ୍‌ ବିଜାୟ୍‌ଲି, ଆର୍‌ ତାର୍‌ ମୁଣ୍ଡାର୍‌ ବାଳେ ହୁଚ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ତୁୟ୍‌ ମକ୍‌ ନଃଚୁମ୍‌ଲିସ୍‌, ମଃତର୍‌ ମୁଁୟ୍‌ ତର୍‌ ଗଃର୍‌ ବିତ୍ରେ ଆୟ୍‌ଲାବଃଳ୍‌ ହୁଣି ଏ ମର୍‌ ହାଦ୍‌ ଚୁମୁକେ ବଃନ୍ଦ୍‌ ନଃକେରେ । ");
INSERT INTO bdv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ତୁୟ୍‌ ମର୍‌ ମୁଣ୍ଡେ ଚିକଣ୍‌ ଲାଗାୟ୍‌ ନଃକେଲିସ୍‌, ମଃତର୍‌ ଏ ମର୍‌ ହାଦେ ବାସ୍ନାଚିକଣ୍ ହାଦ୍‌ଳାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଇତାକ୍‌ ମୁଁୟ୍‌ ତକେ କଃଉଁଲେ, ଆର୍‌ ବୁତେକ୍‌ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଲି, ବଃଲେକ୍‌ ସେ ମକ୍‌ ବୁତେକ୍‌ ଲାଡ୍‌ କଃଲି, ମଃତର୍‌ ଜାକେ ଅଃଳକ୍‌ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଦ୍‌, ସେ ଅଃଳକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଆର୍‌ ସେ ମାୟ୍‌ଜିକେ ଜିସୁ କୟ୍‌ଲା, “ତର୍‌ ସଃର୍ନେ ହାହ୍‌ କେମା କଃରା ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ସେତାକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସି ରିଲା ଲକ୍‌ମଃନ୍ ମଃନେ ମଃନେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ହାହ୍‌ହେଁ ହେଁ କେମା କଃରୁଲା, ଏ ତଃବେ କେ ?” ");
INSERT INTO bdv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ମଃତର୍‌ ଜିସୁ ସେ ମାୟ୍‌ଜିକେ କୟ୍‌ଲା, “ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ବଚାୟ୍‌ ଆଚେ, ସୁସ୍ତାୟ୍‌ ଜା ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଆର୍‌ ଅଃଳକ୍‌ ବେଳ୍‌ ହଃଚେ, ଜିସୁ ଗଃଳେ ଗଃଳେ ଆର୍‌ ଗାଉଁ ଗାଉଁ ବୁଲି ମାପ୍ରୁର୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ଆର୍‌ ବାର ଗଟ୍‌ ଚେଲା ତାର୍‌ ସଃଙ୍ଗେ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଆର୍‌ ଜୁୟ୍‌ ମାୟ୍‌ଜିମଃନ୍‌ ବୁତ୍‌ଆତ୍ମା, ଆର୍‌ ରଗେ ହୁଣି ଉଜ୍‌ କଃରାୟ୍‌ ଅୟ୍‌ରିଲାୟ୍‌, ସେମଃନ୍ ହେଁ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌, ମରିୟମ୍‌ ଜାକେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ବଃଲି କଃଉତି, ଜାର୍‌ ତଃୟ୍‌ହୁଣି ସାତ୍‌ ବୁତ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରଦାର୍‌ ଗୁମୁସ୍ତା କୁଜାର୍‌ ଡକୁର୍ସି, ଜହନା, ସସନା, ଆରେକ୍‌ କଃତେକ୍‌ ମାୟ୍‌ଜିମଃନ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଦଃନ୍ ବିତ୍‌ ଦଃୟ୍‌, ଜିସୁର୍‌ ଆର୍‌ ଚେଲାମଃନାର୍‌ ସେବା କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଗାଦେକ୍‌ ଲକ୍‌ ରୁଣ୍ଡ୍‌ଲାକ୍‌, ଆର୍‌ ଗଃଳ୍‌ମଃନ୍‌ ତଃୟ୍‌ହୁଣି ଲକ୍‌ମଃନ୍ ତାର୍‌ ତଃୟ୍‌ ଆୟ୍‌ଲାକ୍‌, ଜିସୁ ଇ କଃତା କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ଗଟେକ୍‌ ବିଆନ୍ ବୁଣ୍‌ତା ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିଆନ୍ ଦଃରି ବୁଣୁକ୍‌ ବାରାୟ୍‌ଲା, ସେ ବୁଣ୍‌ତା ବଃଳ୍‌ କଃତେକ୍‌ ବିଆନ୍ ବାଟେ ଅଦୁର୍ଲି ଆର୍‌ ହାଦ୍‌ ତଃଳେ ମାଡାଚଃଗା ଅୟ୍‌ଲି, ଆରେକ୍‌ ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନ୍ ସେରିସଃବୁ କାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଆରେକ୍‌ କଃତେକ୍‌ ଚଃଚ୍ରା ଉହ୍ରାର୍‌ ବୁୟେଁ ଅଦୁର୍ଲି, ଆରେକ୍‌ ଗଃଜା ଅୟ୍‌ ରଃସ୍‌ ନଃହାୟ୍‌ଲାକେ ସୁକି ଗଃଲି, ");
INSERT INTO bdv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଆର୍‌ କଃତେକ୍‌ ବିଆନ୍‌ କାଟା ବୁଟା ବିତ୍ରେ ଅଦୁର୍ଲି, ଆରେକ୍‌ କାଟା ଗଃଚ୍‌ମଃନ୍‌ ବାଡି ସେ ସଃବ୍‌କେ ଡାହି ହଃକାୟ୍‌ଲି; ");
INSERT INTO bdv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ବିନ୍ କଃତେକ୍‌ ନିକ ବୁୟେଁ ଅଦୁର୍ଲି, ଆର୍‌ ବାଡି ସଏ ଗୁଣ୍ ହଃଳ୍‌ ହଃଳ୍‌ଲି ।” ଜିସୁ ଇରି କୟ୍‌ କୟ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, “ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଜିସୁର୍‌ ଚେଲାମଃନ୍ ଇ କଃତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ବଃଲି ହଃଚାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମାପ୍ରୁ ରାଇଜାର୍‌ ବୁଜୁ ନଃହାର୍ତା କଃତା ଜାଣୁକେ ତୁମିମଃନ୍‌କେ ଗ୍ୟାନ୍ ଦିଆ ଅୟ୍‌ଆଚେ, ମଃତର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ କଃତା କୟ୍‌ ବୁଜାଉଁକେ ଅୟ୍‌ଦ୍‌, ଜଃନ୍‌କଃରି ସେମଃନ୍ ଦଃକୁ ଦଃକୁ ନଃଦେକ୍‌ତି ଆର୍‌ ସୁଣୁ ସୁଣୁ ନଃବୁଜ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ବିଆନ୍ ବୁଣୁର୍‌ ବାବ୍‌ ଅୟ୍‌ଲି, ବିଆନ୍ ଇସ୍ୱରାର୍‌ କଃତା ");
INSERT INTO bdv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଆର୍‌ ବାଟ ଲଃଗେ ରିଲା ବିଆନ୍ ଇବାନ୍ୟା ଲକ୍‌କେ ବୁଜାୟ୍‌ଦ୍‌, ଜୁୟ୍‌ମଃନ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣ୍‌ତି, ତାର୍‌ହଃଚେ ସୟ୍‌ତାନ୍ ଆସି, ସେମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌କଃରି ହାହେହୁଣି ମୁକ୍ତି ହାୟ୍‌ ବଚୁ ନଃହାର୍‌ତି, ଇତାକ୍‌ ସୟ୍‌ତାନ୍ ଆସେଦ୍‌ ଆର୍‌ ସେମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ହୁଣି ଇସ୍ୱରାର୍‌ କଃତା ଚରି ନଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ଆର୍‌ ଚଃଚ୍ରା ବୁୟାଁୟ୍‌ ବିଆନ୍ ଇବାନ୍ୟା ଲକ୍‌କେ ବୁଜାୟ୍‌ଦ୍‌, ଜୁୟ୍‌ମଃନ୍‌ ବଃଚନ୍ ସୁଣି ବଃଡେ ସଃର୍ଦାୟ୍‌ ମଃନେ ଦଃର୍ତି, ମଃତର୍‌ ସେମଃନାର୍‌ ଚେର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ନଃରିଲାକ୍‌, ସେମଃନ୍ ଚଃନେକାର୍‌ ଗିନେ ଇସ୍ୱରାର୍‌ କଃତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତି ଆର୍‌ ପରିକ୍ୟା ବଃଳ୍‌ ଦଃର୍ମ୍‌ ଚାଡ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଆର୍‌ କାଟା ଗଃଚ୍ ବିତ୍ରେ ଅଦ୍ରି ରିଲା ବିଆନ୍ ଇବାନ୍ୟା ଲକ୍‌କେ ବୁଜାୟ୍‌ଦ୍‌, ଜୁୟ୍‌ମଃନ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣ୍‌ତି, ମଃତର୍‌ ସଂସାର୍‌ ଚିତା, ଦଃନ୍ ଆର୍‌ ସୁକ୍‌ ଲଳି ସଃବୁ ଦିନାର୍‌ ଜିବନ୍ କାଟୁ କାଟୁ ତଃଳେ ଚାହି ଅୟ୍‌ଜାତି, ଆର୍‌ ହଃଳ୍‌ ଦଃରୁନାହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ଆର୍‌ ନିକ ବୁୟେଁ ଅଦ୍ରି ରିଲା ବିଆନ୍ ଇବାନ୍ୟା ଲକ୍‌କେ ବୁଜାୟ୍‌ଦ୍‌, ଜୁୟ୍‌ମଃନ୍‌ ନିକକଃରି ଆର୍‌ ନିର୍ମାୟା ମଃନେ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣି ଗଃର୍ବ୍‌ବିତ୍ରେ ଦଃର୍ତି ଆର୍‌ ସଃମ୍ବାଳି ରଃୟ୍‌ ହଃଳ୍‌ ହଃଳ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“କେହେଁ କୁପି ଲାଗାୟ୍‌ ମାଣ୍ ତଃଳେ ଡାହି ନଃସେଙ୍ଗାୟ୍‌ ଆର୍‌ କଃଟ୍‌ ତଃଳେ ନଃସେଙ୍ଗାୟ୍‌, ମଃତର୍‌ ଦିହ୍‌ରୁକା ଉହ୍ରେ ସଃଙ୍ଗାୟ୍‌ଦ୍‌, ଜଃନ୍‌କଃରି ବିତ୍ରେ ହୁର୍ତା ଲକ୍‌ମଃନ୍ ଉଜାଳ୍‌ ଦଃକ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାୟ୍‌ରି ହଃଦାୟ୍‌ ନଃଡିସେ ଇବାନ୍ୟା ଲୁକ୍‌ଲାର୍‌ କାୟ୍‌ରି ହେଁ ନାୟ୍‌, ଆର୍‌ ଜାୟ୍‌ରି ଜାଣା ଜାୟ୍‌ ହଃଦାୟ୍‌ ଜାଣା ନଃହୟ୍‌, ଇବାନ୍ୟା ଲୁକ୍‌ଲାର୍‌ କାୟ୍‌ରି ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ବଃଲେକ୍‌ କଃନ୍‌କଃରି ସୁଣୁଲାସ୍‌ ସେତାକ୍‌ ଜଃଗ୍ରାତ୍‌, ବଃଲେକ୍‌ ଜାର୍‌ ଆଚେ ତାକ୍‌ ଦିଆ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ଜାର୍‌ ନାୟ୍‌ ସେ ଜାୟ୍‌ରି ନିଜାର୍‌ ଆଚେ ବଃଲି ମଃନେକଃରେଦ୍‌, ସେରି ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁର୍‌ ଆୟ୍‌ସି ଆର୍‌ ବାୟ୍‌ସିମଃନ୍ ତାର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ଦା ଗିନେ ତାକେ ବେଟ୍‌ ଅଃଉଁ ନଃହାର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","କେ ଅଲେ ଜିସୁକେ ଇ କବୁର୍‌ ଦିଲାୟ୍‌, “ତର୍‌ ଆୟ୍‌ଦି ଆର୍‌ ବାୟ୍‌ଦିମଃନ୍ ତର୍‌ ସଃଙ୍ଗ୍ ବେଟ୍‌ ଅଃଉଁକେ ମଃନ୍‌ କଃରି ହଃଦାୟ୍‌ ଟିଆ ଅୟ୍‌ ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ମଃନ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣ୍‌ତି ଆର୍‌ ମାନ୍‌ତି ସେମଃନ୍ ମର୍‌ ଆୟା ଆର୍‌ ବାୟ୍‌ମଃନ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ସଃଡେବଃଳ୍‌ ଗଟ୍‌ଦିନ୍‌ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗଟେକ୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଆସା ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟି ଜୁଆଁ,” ସେତାକ୍‌ ସେମଃନ୍ ଡଙ୍ଗା ମେଲ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ମଃତର୍‌ ସେମଃନ୍ ଡଙ୍ଗା ଗାଟି ଜାତା ବଃଳ୍‌ ଜିସୁ ସୟ୍‌ ରିଲା, ସଃଡେବଃଳ୍‌ ସଃମନ୍ଦେ ବାଉହାଣି ଆୟ୍‌ଲି ଆର୍‌ ସେମଃନାର୍‌ ଡଙ୍ଗାୟ୍‌ ହାଣି ହୁରୁକ୍‌ ଦଃର୍ଲି ଆର୍‌ ସେମଃନ୍ ବଃଡେ ଜଃଞ୍ଜାଳେ ହଃଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକେ ଉଟାୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ମଃଲୁ,” ଇତାକ୍‌ ସେ ଉଟି ବାଉ ଆର୍‌ ଉଲାଳ୍‌କେ ଦଃମ୍‌କାୟ୍‌ଲା, ଆର୍‌ ସେ ସଃବୁ ତୁନ୍‌ହାଳ୍‌ଲି ଆର୍‌ ତିର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଆରେକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ବିସ୍ୱାସ୍‌ କଃୟ୍‌ ?” ମଃତର୍‌ ସେମଃନ୍ ଡିରି ଜାୟ୍‌ କାବା ଅୟ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତଃବେ ଏ କେ ଜେ ସେ ବାଉହାଣିକେ ହେଁ ଆଦେସ୍‌ ଦିଲେକ୍‌ ସେମଃନ୍ ତାର୍‌ ବଲ୍‌ ମାନୁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ତାର୍‌ହଃଚେ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗାଲିଲି ମୁଁଆଟିର୍‌ ଗରାସିୟମଃନାର୍‌ ହଲି ତଃୟ୍‌ ହଚ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଜିସୁ ଡଙ୍ଗାୟ୍‌ ହୁଣି ବାରାୟ୍‌ କଃଣ୍ଡାୟ୍‌ ଉତୁର୍ଲାକ୍‌, ସେ ଗଃଳାର୍‌ ଗଟେକ୍‌ ବୁତ୍‌ ଡଃସିରିଲା ଲକ୍‌ ତାକ୍‌ ବେଟ୍‌ ଅୟ୍‌ଲା, ସେ କଃତେକ୍‌ କାଳ୍‌ ହଃତେକ୍‌ ହଃଚ୍ୟା ନଃହିନ୍ଦି ଗଃରେ ନଃରେୟ୍‌ ମଃସ୍‌ଣେ ରେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ସେ ଜିସୁକେ ଦଃକି କିର୍‌କିରି କଃରି ତାର୍‌ ଗଡ୍ ତଃଳେ ଡୁଳି ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, “ଏ ସଃବ୍‌କେ ଉହ୍ରାର୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ଜିସୁ, ତର୍‌ ସଃଙ୍ଗ୍ ମର୍‌ କାୟ୍‌ରି ଆଚେ ? ମୁଁୟ୍‌ ତକେ ଗଃଉଆରି କଃରୁଲେ ମକେ ଡଃଣ୍ଡ୍‌ ଦେନାୟ୍‌,” ");
INSERT INTO bdv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ବିଟାଳ୍‌ ବୁତ୍‌ ଆତ୍ମାକେ ସେମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଜଃଉଁକେ ଆଦେସ୍‌ ଦେଉଁକ୍‌ ଜାତିରିଲା, ସେ ବୁତ୍‌ ଆତ୍ମା କଃତେକ୍‌ ତର୍‌ ତାକ୍‌ ଡଃସି ରିଲି, ଆରେକ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ସିକ୍ଳି ସଃଙ୍ଗ୍ ବାନ୍ଦି ରେତିରିଲାୟ୍‌, ମଃତର୍‌ ସେ ବାନ୍ଦୁଣ୍ ସଃବୁ ଚିଡାୟ୍‌ କଃରି ବୁତ୍‌ ତାକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ନେତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ତାକ୍‌ ହଃଚାର୍ଲା, “ତର୍‌ ନାଉଁ କାୟ୍‌ରି ?” ସେ କୟ୍‌ଲା, “ବାହିନି, ବଃଲେକ୍‌ ବୁତେକ୍‌,” ତାକ୍‌ ବୁତେକ୍‌ ବୁତ୍‌ ତାର୍‌ ବିତ୍ରେ ହୁରି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆରେକ୍‌ ଜିସୁ ଜଃନ୍‌କଃରି ସେମଃନ୍‌କେ ହଃତାଳେ ଜଃଉଁକେ ଆଦେସ୍‌ ନଃଦେୟ୍‌, ଇତାକ୍‌ ସେମଃନ୍‌ ଜିସୁକେ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ସେତି ଡଙ୍ଗୁର୍‌ କଃଳ୍‌କାୟ୍‌ ଗଟେକ୍‌ ଗୁସ୍ରା ମଃନ୍ଦା ଚଃର୍ତି ରିଲାୟ୍‌, ଆରେକ୍‌ ସେ ଜଃନ୍‌କଃରି ସେମଃନ୍‌କେ ସେ ଗୁସ୍ରାମଃନାର୍‌ ବିତ୍ରେ ହୁରୁକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ଦ୍‌ ଇତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁ ସେମଃନ୍‌କେ ଆଦେସ୍‌ ଦିଲାକ୍‌, ବୁତ୍‌ମଃନ୍‌ ସେ ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବାର୍‌ ଅୟ୍‌ ଗୁସ୍ରାମଃନାର୍‌ ବିତ୍ରେ ହୁର୍ଲାୟ୍‌, ସେତାକ୍‌ ସେ ଗୁସ୍ରା ମଃନ୍ଦା ସଃଙ୍ଗେ ସଃଙ୍ଗେ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ହୁଣି ଦଃବ୍‌ଳି ଜାୟ୍‌ ସଃମ୍‌ନ୍ଦେ ଅଦ୍ରି ବୁଡି ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ଗୁସ୍ରା ଚଃରାଉତା ଲକ୍‌ମଃନ୍ ସେ ଗଃଟ୍‍ଣା ଦଃକି ହଃଳାୟ୍‌ ଜାୟ୍‌ ଗଃଳେ ଆର୍‌ ଗାଉଁଏମଃନ୍‌ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ସେ ଗଃଟ୍‍ଣା ଦଃକୁକ୍‌ ବାରାୟ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବୁତ୍‌ମଃନ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ରିଲାୟ୍‌, ତାକେ ହଃଚ୍ୟା ହିନ୍ଦି ନିକ ମଃନେ ଜିସୁର୍‌ ହାଦ୍‌ ତଃଳେ ବଃସି ରିଲାର୍‌ ଦଃକି ଡିରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଦଃକିରିଲାୟ୍‌ ସେମଃନ୍ ସେ ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌ କଃନ୍‌କଃରି ଉଜ୍‌ ଅୟ୍‌ଲା, ସେରି ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ସେତାକ୍‌ ଗରାସିୟ୍‌ ମଃନାର୍‌ ହଲିର୍‌ ଚାରିବାଟ୍‌ ରିଲା ସଃବୁ ଲକ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଉଁକେ ଜିସୁକେ ଗଃଉଆରି କଃଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ବଃଡେ ଡିରି ଜାୟ୍‌ ରିଲାୟ୍‌, ଆର୍‌ ସେ ଗଟେକ୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ବାଉଳିଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ବୁତ୍‌ମଃନ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ ରିଲାୟ୍‌ ସେ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ରେଉଁକ୍‌ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ମଃତର୍‌ ସେ ତାକେ ହଃଟାୟ୍‌ କଃରି କୟ୍‌ଲା, “ତୁୟ୍‌ ଗଃରେ ବାଉଳି ଜା, ଆର୍‌ ଇସ୍ୱର୍‌ ତର୍‌ ଗିନେ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃରିଆଚେ ସେରିମଃନ୍ ପର୍ଚାର୍‌ କଃର୍‌,” ସେତାକ୍‌ ସେ ଗଃଲା ଆର୍‌ ଜିସୁ ତାର୍‌ଗିନେ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃରିରିଲା ଗଃଳ୍‌ଜାକ କଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଜଃଡେବଃଳ୍‌ ଜିସୁ ସଃମ୍‌ନ୍ଦାର୍‌ ଇହାଟି ଆୟ୍‌ଲା, ଲକ୍‌ମଃନ୍ ତାକ୍‌ ସଃର୍ଦାମଃନେ ବେଟ୍‌ ଅୟ୍‌ଲାୟ୍‌, ବଃଲେକ୍‌ ସଃବୁ ଲକ୍‌ ତାକ୍‌ ଜାଗି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆର୍‌ ଦଃକା ଜାଇରସ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆୟ୍‌ଲା, ସେ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକା ଲକ୍‌ ରିଲା, ସେ ଜିସୁର୍‌ ଗଡ୍ ତଃଳେ ଡୁଳି, ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ଜଃଉଁକେ ଗଃଉଆରି କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ବଃଲେକ୍‌ ତାର୍‌ ବାର ବଃର୍ସାର୍‌ ଗଟେକ୍‌ ବଃଲି ଜିସି ରିଲି, ଆର୍‌ ସେ ମଃରୁକ୍‌ କଃଣ୍ଡେକ୍‌ ରିଲି, ମଃତର୍‌ ଜିସୁ ଜାତାବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଉହ୍ରେ ମାଡାଚଃଗା ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ସଃଡେବଃଳ୍‌ ବାର ବଃର୍ସ୍‌ ହଃତେକ୍‌ ଗଃଗାଳ୍‌ଜାତା ରଗ୍ ଦଃରି ଜିବନ୍‌ କାଟ୍‌ତାର୍‌ ଗଟେକ୍‌ ମାୟ୍‌ଜି ଜେ କି ନିଜାର୍‌ ଦଃନ୍‌ବିତ୍‌ ସଃରାୟ୍‌କଃରି ହେଁ କାର୍‌ ତଃୟ୍‌ହୁଣି ଉଜ୍‌ ଅଃଉଁ ନାହାର୍ତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ସେ ହଃଚ୍‌ବାଟ୍ୟା ଆସି ଜିସୁର୍‌ ହଃଚ୍ୟାର୍‌ ଆଚଳ୍‌ ଚୁୟ୍‌ଲି, ସେଦାହ୍ରେ ତାର୍‌ ଗଃଗାଳାର୍‌ ଗଃଗାଳ୍‌ ଜାତାର୍‌ ତେବଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “କେ ମକ୍‌ ଚୁୟ୍‌ଲା ?” ମଃତର୍‌ ସଃବୁ ଲକ୍‌ ନାୟ୍‌ ବଃଲ୍‌ଲାକ୍‌, ପିତର୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଲକ୍‌ମଃନ୍ ଟେଲା ଟେଲି ଅୟ୍‌ ତର୍‌ଉହ୍ରେ ମାଡା ଚଃଗା ଅଃଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “କେ ଅଲେ ମକ୍‌ ଚୁୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ତଃୟ୍‌ହୁଣି ସଃକ୍ତି ବାର୍‌ଲି ବଃଲି ମୁଁୟ୍‌ ଜାଣ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ସଃଡେବଃଳ୍‌ ସେ ମାୟ୍‌ଜି ଦଃକ୍‌ଲି ଜେ, ସେ ଲୁକି ରେଉଁ ନଃହାର୍‌ଲି, ସଃଡେବଃଳ୍‌ ସେ ତଃର୍‌ତଃରି ଜିସୁର୍‌ ଗଡ୍ ତଃଳେ ଡୁଳ୍‌ଲି ଆର୍‌ କାୟ୍‌ତାକ୍‌ ତାକ୍‌ ଚୁୟ୍‌ଲି ଆରେକ୍‌ କଃନ୍‌କଃରି ସେଦାହ୍ରେ ଉଜ୍‌ ଅୟ୍‌ଲି ସେରିସଃବୁ ଲକ୍‌ମଃନାର୍‌ ମୁୟେଁ କୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ସେତାକ୍‌ ଜିସୁ ତାକେ କୟ୍‌ଲା, “ଜିଇ, ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ଉଜ୍‌ କଃଲି ଆଚେ, ସୁସ୍ତା ଅୟ୍‌ ଜାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଜିସୁ ଇ କଃତା କଃଉତା ବଃଳ୍‌, ପାର୍ତ୍‌ନାଗଃରାର୍‌ ମୁଳିକାର୍‌ ଗଃରେହୁଣି ଗଟ୍‌ ଲକ୍‌ ଆସି ତାକେ କୟ୍‌ଲା, “ତର୍‌ ଜିଦି ମଃଲିନି, ଗୁରୁକ୍‌ ଆରେକ୍‌ କଃସ୍ଟ୍‌ ଦେସ୍‌ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ମଃତର୍‌ ଜିସୁ ଇରି ସୁଣି ଜାଇରସ୍‌କେ କୟ୍‌ଲା, “ଡିରା ନାୟ୍‌, ମଃତର୍‌ ବିସ୍ୱାସ୍‌ କଃର୍‌ ଆର୍‌ ସେ ବଚେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଆର୍‌ ଜିସୁ ଗଃରେ ଆସି, ପିତର୍‌, ଜହନ୍‌ ଆର୍‌ ଜାକୁବକ୍‌ ଆରେକ୍‌ ହିଲାର୍‌ ଉବାସି ଆୟ୍‌ସିକ୍‌ ଚାଡି, କାକେ ହେଁ ସଃଙ୍ଗେ ଜଃଉଁକେ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମଃତର୍‌ ସଃବୁ ଲକ୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକାର୍‌ ଜିସି ମଃଲାକ୍‌ ଉରେ ମାରିଅୟ୍‌ କାନ୍ଦ୍‌ତି ରିଲାୟ୍‌, ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “କାନ୍ଦା ନାୟ୍‌, ସେ ନଃମେରେ ମଃତର୍‌ ସଇ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ମଃତର୍‌ ସେ ମଃରି ଆଚେ ବଃଲି ଜାଣିରିଲାକ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଗେଙ୍ଗ୍ରାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମଃତର୍‌ ଜିସୁ ଟକିର୍‌ ଆତେ ଦଃରି କୟ୍‌ଲା, “ଏ ନୁନି ହିଲା ଉଟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ସେତାକ୍‌ ତାର୍‌ ଆତ୍ମା ବାଉଳି ଆୟ୍‌ଲି ଆର୍‌ ସେ ସେଦାହ୍ରେ ଉଟ୍‌ଲି, ଆରେକ୍‌ ଜିସୁ ତାକ୍‌ କାୟ୍‌ରି କଃଣ୍ଡେକ୍‌ କାଉଁକେ ଦେଉଁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଇତାକ୍‌ ତାର୍‌ ଉବାସି ଆୟ୍‌ସି କାବା ଅୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ସେ ଗଃଟ୍‍ଣାର୍‌ କଃତା କାକେ ହେଁ କଃଉଆ ନାୟ୍‌ ବଃଲି ସେମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଇ ବିତ୍ରେ ଜିସୁ ବାର ଗଟ୍‌ ଚେଲାକେ କୁଦି ଗଟ୍‌ ଟାଣେ ରୁଣ୍ଡାୟ୍‌ଲା, ଆର୍‌ ସେମଃନ୍‌କେ ସଃବୁ ବୁତ୍‌ ଚାଡାଉଁକେ ଆରେକ୍‌ ରଗ୍ ଉଜ୍‌ କଃରୁକେ ସଃକ୍ତି ଆର୍‌ ଅଃଦିକାର୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ସେ ସେମଃନ୍‌କେ ମାପ୍ରୁର୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଆର୍‌ ରଗିମଃନ୍‌କେ ନିକ କଃରୁକେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଆର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାତା ବଃଳ୍‌ ଡାଙ୍ଗ୍, ମଣା, ରୁଟି କି ଟଃକା, କାୟ୍‌ରି ହେଁ ନିଆ ନାୟ୍‌, ଆରେକ୍‌ ଜଳେକ୍‌ ଆଙ୍ଗି ହେଁ ସଃଙ୍ଗେ ଦଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଆର୍‌ ଜୁୟ୍‌ ଗଃରେ ଜାହାସ୍‌, ସେତିହୁଣି ନଃବାଉଳ୍‌ତା ହଃତେକ୍‌ ସେତି ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ତୁମିମଃନ୍‌କେ ନଃଦେର୍‌ତି, ସେ ଗଃଳେ ହୁଣି ବାରାୟ୍‌ ଜାତା ବଃଳ୍‌, ସେମଃନାର୍‌ ବିରଦେ ସାକି ଦେଉଁକେ ତୁମାର୍‌ ହାଦାର୍‌ ଦୁଳି ହାହଳି ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ସେତାକ୍‌ ସେମଃନ୍ ସେତିହୁଣି ଗଃଲାୟ୍‌ ଆର୍‌ ସଃବୁ ହାକ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ ଆର୍‌ ରଗିମଃନ୍‌କେ ଉଜ୍‌ କଃରୁ କଃରୁ ଗାଉଁ ଗାଉଁ ବୁଲୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଜଃଡେବଃଳ୍‌ ତଃଳ୍ୟାରଃଜା ହେରଦ୍‌ ଇସଃବୁ ଗଃଟ୍‍ଣା କଃତା ସୁଣି ବେସି କାବା ଅୟ୍‌ଲା, ଆର୍‌ ତାର୍‌ ବୁଦି ବାଣା ଅୟ୍‌ଲି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ମଃର୍ନେ ହୁଣି ଉଟି ଆଚେ ବଃଲି କେ କେ କଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆରେକ୍‌ କେ କେ ଏଲିୟ ଦଃକାୟ୍‌ ଅୟ୍‌ଆଚେ ଆର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍ ଆଗ୍ ହୁର୍ବାର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ମଃର୍ନେହୁଣି ଉଟି ଆଚେ ବଃଲି କଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ମଃତର୍‌ ହେରଦ୍‌ ରଃଜା କୟ୍‌ଲା, “ଜହନ୍‌କେ ମୁଣ୍ଡ୍ ତ ମୁଁୟ୍‌ କାଟି ଆଚି, ମଃତର୍‌ ଜାର୍‌ ବିସୟେ ମୁଁୟ୍‌ ଅଃନ୍‌କାର୍‌ ସୁଣୁଲେ ଏ ତଃବେ କେ ?” ଆର୍‌ ସେ ତାକ୍‌ ଦଃକୁକ୍‌ ମଃନ୍‌ କଃର୍ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ତାର୍‌ହଃଚେ ହଃଟାୟ୍‌ଲା ଚେଲାମଃନ୍ ବାଉଳି ଆସି, ଜାୟ୍‌ରି ଜାୟ୍‌ରି କଃରି ରିଲାୟ୍‌ ସେରି ସଃବୁ ଜିସୁକେ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍‌କେ ସଃଙ୍ଗେ ଦଃରି ଅଃଲ୍‌ଗା ଅୟ୍‌ ବେତ୍‌ସାଇଦା ନାଉଁଆର୍‌ ଗଃଳେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ସେରି ଜାଣି ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌, ଜିସୁ ମଃନ୍‌ବିଚାରି ସେମଃନ୍‌କେ କୁଦ୍‌ଲା, ଆର୍‌ ମାପ୍ରୁ ରାଇଜାର୍‌ କଃତା ସେମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ରଗେ ହୁଣି ଉଜ୍‌ ଅଃଉତାର୍‌ ଲଳା ରିଲି ସେମଃନ୍‌କେ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଇ ବିତ୍ରେ ବେଳ୍‌ ଆଡ୍ ମାରୁକ୍‌ ଦଃର୍ଲି, ସେତାକ୍‌ ବାର ଚେଲାମଃନ୍ ଆସି ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି ଚାରିହଃକାର୍‌ ଗାଉଁ ଆର୍‌ ହାଳା ମଃନ୍‌କେ ଜାୟ୍‌ ରେଉଁକେ ଟାଣ୍ ଆର୍‌ କାଦି ହାଉଁ ହାର୍‌ତି, ସେତାକ୍‌ ସେମଃନ୍‌କେ ସେଲ ଦେସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ଇତି ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣେ ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ସେମଃନ୍‌କେ କାଦି କାଳାଉଆ ।” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ଚଃମେ ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜଳେକ୍‌ ମାଚ୍ ହୁଣି ଅଃଦିକ୍‌ ନାୟ୍‌, ସେରି ନୟ୍‌ଲେକ୍‌ ଅଃମିମଃନ୍‌ କାୟ୍‌ ଜାୟ୍‌ ଇ ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ଗିନେ କାଦି ଗେନୁଆଁ ?” ");
INSERT INTO bdv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ମାୟ୍‌ଜି ଆର୍‌ ହିଲାଟକିକେ ଚାଡି ଅଃବ୍‌କା ଅଃଣ୍ଡ୍ରାମଃନ୍‌ ହାକାହାକି ହାଁଚ୍ ଆଜାର୍‌ ରିଲାୟ୍‌, ଆର୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଦୁୟ୍‌କଳି ଦଃସ୍‌ ଲେକା ଦଃଳ୍‌ ଦଃଳ୍‌ କଃରି ଲକ୍‌ମଃନ୍‌କେ ବଃସାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ସେତାକ୍‌ ସେମଃନ୍ ସେନ୍ କଃରି ବଃସାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଆରେକ୍‌ ସେ ହାଁଚ୍‌ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜଳେକ୍‌ ମାଚ୍‌କେ ଦଃରି ସଃର୍ଗ୍‌ ହାକ୍‌ ଦଃକି ସେରି ଆସିର୍ବାଦ୍‌ କଃଲା ଆରେକ୍‌ ବାଙ୍ଗି ଲକ୍‌ମଃନ୍‌କେ ଦେଉଁକେ ଚେଲାମଃନ୍‌କେ ଦେଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ସେତାକ୍‌ ସଃବୁ ଲକ୍‌ ଆଦାର୍‌ ହୁର୍ନେ କାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକାର୍‌ ତଃୟ୍‌ ଉବ୍ରି ରିଲାର୍‌ ଚେଲାମଃନ୍ ବାର ଡଃଲା ବାଙ୍ଗ୍‌ଲା ରୁଟିମଃନ୍‌ ବେଟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ଗଟ୍‌ତର୍‌ ଜିସୁ ଲକ୍‌ବାକ୍‌ ନୟ୍‌ଲା ଟାଣେ ପାର୍ତ୍‌ନା କଃର୍ତା ବଃଳ୍‌, ଚେଲାମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌ ଆର୍‌ ସେ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମୁଁୟ୍‌ କେ ବଃଲି ଲକ୍‌ମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଇତାକ୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌, ମଃତର୍‌ କେ କେ କଃଉତି ଏଲିୟ ଆର୍‌ କେ କେ କଃଉତି ଆଗ୍ ହୁର୍ବାର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ମଃର୍ନେ ହୁଣି ଉଟି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମଃତର୍‌ ମୁଁୟ୍‌ କେ ବଃଲି ତୁମିମଃନ୍ କାୟ୍‌ରି କଃଉଁଲାସ୍‌,” ପିତର୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ କ୍ରିସ୍ଟ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ସେତାକ୍‌ ଜିସୁ ଇ କଃତା କାକେ ହେଁ ନଃକଉଁକ୍‌ ଅଃଟୁଆ କଃରି ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ଆରେକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନଃରାର୍‌ ହୟ୍‌ସିକେ ଜଃନ୍‌କଃରି ହେଁ ବଃଡେ ଦୁକ୍‌ ବୟ୍‌ଗ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ପାରାଚିନ୍, ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ତାକେ ଦୁର୍‌ କଃର୍ତି, ଆର୍‌ ମଃର୍ନେ ମାର୍‌ତି ଆର୍‌ ତିନି ଦିନାର୍‌ ତଃଳେ ଉଟୁକ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ସଃଡେବଃଳ୍‌ ସେ ସଃବ୍‌କେ କୟ୍‌ଲା, “କେ ଜଦି ମର୍‌ ହଃଚେ ଆସୁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ଅଃହ୍‌ଣାକ୍‌ ଚାଡ ଆର୍‌ ହଃତି ଦିନ୍ ଅଃହ୍‌ଣାର୍‌ କ୍ରୁସ୍‌ ବୟ୍‌କଃରି ମର୍‌ ହଃଚେ ହଃଚେ ଆସ । ");
INSERT INTO bdv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ରଃକ୍ୟାକଃରୁକେ ମଃନ୍‌କଃରେଦ୍‌, ସେ ସେରି ଆରାୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ଗିନେ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ବଚାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଆର୍‌ ମାନାୟ ଜଃଡେବଃଳ୍‌ ଜଃଗତାର୍‌ ସଃବୁ ହାୟ୍‌ ଅଃହ୍‌ଣାକ୍‌ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ତାର୍‌ କାୟ୍‌ ଲାବ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ସେତାକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ବଃଚନ୍ ଗିନେ ଲାଜ୍‌ ଅୟ୍‌ଦ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ଜଃଡେବଃଳ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆର୍‌ ଉବାସିର୍‌ ଆରେକ୍‌ ପବିତ୍ର ଦୁତ୍‌ ମଃନାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଆସେଦ୍‌, ସଃଡେବଃଳ୍‌ ସେ ହେଁ ତାର୍‌ ବିସୟେ ଲାଜ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମଃତର୍‌ ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ନଃଦେକ୍‌ତା ହଃତେକ୍‌ ଇତି ଟିଆ ଅୟ୍‌ ରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ନଃମେର୍ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଇ ସଃବୁ ଗଃଟ୍‍ଣାର୍‌ ଆଟ୍‌ଦିନ୍ ହଃଚେ ଜିସୁ ପିତର୍‌, ଜହନ୍‌, ଆର୍‌ ଜାକୁବକେ ସଃଙ୍ଗେ ଦଃରି ପାର୍ତ୍‌ନା କଃରୁକେ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଆରେକ୍‌ ସେ ପାର୍ତ୍‌ନା କଃର୍ତା ବଃଳ୍‌ ତାର୍‌ ମୁଆଁର୍‌ ରୁହ୍‌ ବାଦୁଲ୍‌ଲି ଆର୍‌ ତାର୍‌ ବଃସ୍ତର୍‌ ଚିଟ୍‌ଦବ୍‌ ଆର୍‌ ବଃଡେ ଉଜାଳ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଆର୍‌ ଦଃକା, ତଃତ୍‌କାଣ୍, ମସା ଆର୍‌ ଏଲିୟ ଇ ଦୁୟ୍‌ ଲକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ସେମଃନ୍ ସଃର୍ଗାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଦଃକାୟ୍‌ ଅଃଉତି ରିଲାୟ୍‌, ଜିସୁ ଜିରୁସାଲମେ ଜଃଉଁକେ ଜୁୟ୍‌ ମଃନ୍‌ କଃର୍ତି ରିଲା ବିସୟ୍‌କ୍‌ ଦଃରି କଃତାବାର୍ତା ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ସଃଡେବଃଳ୍‌ ପିତର୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ ବର୍‌ ନିଦେ ସଇ ରିଲାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ନିଦେହୁଣି ଚେତା ଅୟ୍‌ଲାକ୍‌, ଜିସୁର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଟିଆ ଅୟ୍‌ରିଲା ଦୁୟ୍‌ ଲକ୍‌କେ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଆରେକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ତଃୟ୍‌ହୁଣି ଆସ୍ତା ବଃଳ୍‌ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ଇତି ଆଚୁ ଇରି ନିକ ଅଃମିମଃନ୍‌ ତିନିଗଟ୍‌ କୁଳିଆ ତିଆର୍‌ କଃରୁନ୍ଦ୍‌ ତର୍‌ ଗିନେ ଗଟେକ୍‌ ମସାର୍‌ ଗିନେ ଗଟେକ୍‌ ଆର୍‌ ଏଲିୟର୍‌ ଗିନେ ଗଟେକ୍‌,” ମଃତର୍‌ ପିତର୍‌ କାୟ୍‌ରି କଃଉଁଲା, ସେରି ଜାଣୁ ନଃହାର୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତର୍‌ ଇରି କଃଉଁ କଃଉଁ କଃଣ୍ଡେକ୍‌ ମେଗ୍ ଆସି ସେମଃନ୍‌କେ ଡାହ୍‌ଲି ଆର୍‌ ସେମଃନ୍ ମେଗେ ହୁର୍ତା ବଃଳ୍‌ ଡିର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଆରେକ୍‌ ସେ ମେଗେ ହୁଣି ଇ କଃତା ସୁଣା ଅୟ୍‌ଲି, “ଇରି ମର୍‌ ହଅ, ମୁୟ୍‌ଁ ବାଚ୍‌ଲାର୍‌, ଆର୍‌ କଃତା ସୁଣା ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଇ କଃତା ସୁଣ୍‌ଲା ହଃଚେ ଜିସୁ ଏକ୍ଲା ଡିସ୍‌ଲା, ଆର୍‌ ସେମଃନ୍ ତୁନ୍‌ ହାଳ୍‌ଲାୟ୍‌ ଆର୍‌ ଜାୟ୍‌ରି ଜାୟ୍‌ରି ଦଃକି ରିଲାୟ୍‌, ସେତିର୍‌ କାୟ୍‌ କଃତା ସଃଡେବଃଳ୍‌ କାକେ ହେଁ ନଃକୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଜିସୁ ଆର୍‌ ତାର୍‌ ତିନିଗଟ୍‌ ଚେଲାମଃନ୍ ଡଙ୍ଗ୍ରେ ହୁଣି ଉତୁର୍ଲାକ୍‌ ବୁତେକ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ବେଟ୍‌ ଅୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆର୍‌ ଦଃକା, ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌ ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ ମୁଁୟ୍‌ ତକେ ଗଃଉଆରି କଃରୁଲେ ମର୍‌ ହିଲାକ୍‌ ଦଃର୍ମ୍‌ କଃର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ମର୍‌ ଗଟେକ୍‌ ବଃଲି ହିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଦଃକ୍‌ ତାକ୍‌ ଗଟେକ୍‌ ବୁତ୍‌ ଦଃରେଦ୍‌ ଆର୍‌ ସେ ତଃତ୍‌କାଣ୍ ଆଉଲି ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେ ତାକ୍‌ ଅଃନ୍‌କା ଆଳାଡାଳା କଃରେଦ୍‌ ମୁଏଁ ହୁଣି ହେହୁଲ୍‌ ବାରାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେ ତାକେ ବାନା କାବ୍‌ରା କଃରି ବଃଡେ କଃସ୍ଟେ ବାରାୟ୍‌ ଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ତାକ୍‌ ଚାଡାଉଁକେ ତର୍‌ ଚେଲାମଃନ୍‌କେ ଗଃଉଆରି କଃଲେ, ମଃତର୍‌ ସେମଃନ୍ ନଃହାର୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ କୟ୍‌ଲା, “ରେ ଅବିସ୍ୱାସି ବିନ୍ ବାଟ୍‌ ଜାତା ବଃଉଁସ୍‌ କଃତେକ୍‌ କାଳ୍‌ ମୁଁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ତୁମିମଃନାର୍‌ ଇବାନ୍ୟା କଃତା ସଃମ୍ବାଳିନ୍ଦ୍‌, ତର୍‌ ହଅକେ ଇତି ଆଣ୍,” ");
INSERT INTO bdv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ସେ ଆସ୍ତା ବଃଳ୍‌ ବୁତ୍‌ ତାକ୍‌ ତଃଳେ ଅଦ୍ରାୟ୍‌ ବଃଡେ ଆଳାଡାଳା କଃଲି, ମଃତର୍‌ ଜିସୁ ବିଟାଳ୍‌ ବୁତ୍‌କେ ଦଃମ୍‌କାୟ୍‌ଲା ଆର୍‌ ବାର୍‌ କଃଲା ଆର୍‌ ହିଲାକ୍‌ ଉଜ୍‌ କଃରି ତାର୍‌ ଉବାସିର୍‌ ଆତେ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ସେତାକ୍‌ ସଃବୁଲକ୍‌ ଇସ୍ୱରାର୍‌ ବଃଡେ ସଃକ୍ତି ଦଃକି କାବା ଅୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ତାର୍‌ କଃଲା ସଃବୁ କାମ୍‌ ଗିନେ ସଃବୁ ଲକ୍‌ କାବା ଅଃଉତାବଃଳ୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ଚେଲା ମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ଇ ସଃବୁ କଃତା ତୁମିମଃନାର୍‌ କାନେ ହୁରାଉଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ମାନାୟ୍‌ମଃନାର୍‌ ଆତେ ସଃର୍ହି ଅଃଉଁକେ ଜଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମଃତର୍‌ ଚେଲାମଃନ୍ ସେକଃତା ବୁଜୁ ନଃହାର୍‌ଲାୟ୍‌, ଆର୍‌ ସେରି ସେମଃନାର୍‌ ତଃୟ୍‌ ଲୁକ୍‌ଣେ ରିଲି, ଜଃନ୍‌କଃରି ସେମଃନ୍‌ ବୁଜୁକ୍‌ ନଃହାର୍ତି, ଆରେକ୍‌ ସେମଃନ୍ ସେ କଃତା ତାକ୍‌ ହଃଚାରୁକ୍‌ ଡିର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ସେମଃନାର୍‌ ବିତ୍ରେ କେ ବଃଡ୍ ସେ କଃତାକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ ଦଃରାଦଃରି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ଦଃରାଦଃରି ଅଃଉତାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଜାଣି ଗଟେକ୍‌ ସାନ୍ ହିଲାକ୍‌ ଦଃରି ଅଃହ୍‌ଣାର୍‌ ଚଃମେ ଟିଆ କଃରାୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ନାଉଁଏ ଇ ସାନ୍ ହିଲାକ୍‌ ଆଗଳେଦ୍‌ ସେ ମକେ ଆଗଳେଦ୍‌ ଆର୍‌ ଜେ ମକେ ଆଗଳେଦ୍‌ ସେ ମର୍‌ ହଃଟାୟ୍‌ଲା ଉବାକ୍‌ ଆଗଳେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ସଃବ୍‌କାର୍‌ ବିତ୍ରେ ଜେ ସଃବେକ୍‌ ସାନ୍ ସେ ସଃବ୍‌କେ ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ସେତାକ୍‌ ଜହନ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ତର୍‌ ନାଉଁଏ ବୁତ୍‌ ଚାଡାଉତାର୍‌ ଦଃକ୍‌ଲୁ ଆର୍‌ ସେ ଅଃମାର୍‌ ଦଃଳେ ନଃରିଲାକ୍‌ ଅଃମି ତାକେ ମଃନା କଃଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ମଃନା କଃରା ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜେ ତୁମାର୍‌ ବିରଦି ନାୟ୍‌ ସେ ତୁମାର୍‌ ଦଃଳାର୍‌ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ହଃଚେ ଜଃଡେବଃଳ୍‌ ଜିସୁର୍‌ ସଃର୍ଗେ ଜାତାର୍‌ ବେଳା ହୁରୁଣ୍ ଅୟ୍‌ ଆସ୍ତି ରିଲି, ସଃଡେବଃଳ୍‌ ସେ ଜିରୁସାଲମ୍‌ ଜଃଉଁକେ ମଃନ୍‌କେ ଅଃଟୁଆ କଃରି, ");
INSERT INTO bdv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ଅଃହ୍‌ଣାର୍‌ ଆଗ୍‌ତୁ ଲକ୍‌ ହଃଟାୟ୍‌ଲା, ସେମଃନ୍ ଜାୟ୍‌ ତାର୍‌ ଗିନେ ସଃବୁ ଟିକ୍‌ କଃରୁକେ ସମିରଣିୟ ମଃନାର୍‌ ଗଟେକ୍‌ ଗାଉଁଏ ହୁର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମଃତର୍‌ ସେ ଜିରୁସାଲମ୍‌ ଜଃଉଁକେ ମଃନ୍‌ କଃରି ଆଚେ ବଃଲି ଜାଣି ତାକେ ମାନ୍‌ତି ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଇରି ଦଃକି ଜାକୁବ ଆର୍‌ ଜହନ୍‌ ସେ ଦୁୟ୍‌ ଚେଲା କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଏଲିୟ ହେଁ ଜଃନ୍ କଃରି ରିଲା ସେନ୍ କଃର୍‌, ଅଃଗାସ୍‌ ଉହ୍ରେ ହୁଣି ଜୟ୍‌ ଅଦ୍ରି ସେମଃନ୍‌କେ ନାସ୍‌ କଃର, ଇରି ଅଃମିମଃନ୍‌ କଃଉନ୍ଦ୍ ବଃଲି କାୟ୍‌ ତର୍‌ ମଃନ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମଃତର୍‌ ସେ ଲେଉଟି କଃରି ସେମଃନ୍‌କେ ରିସା ଅୟ୍‌ଲା ଆର୍‌ ଦଃକା ଦିଲା ଆର୍‌ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କଃନ୍‌କା ଆତ୍ମାର୍‌ ଲକ୍‌ ଇରି ନଃଜାଣୁଲାସ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ମାନାୟ୍‌ମଃନାର୍‌ ହଃରାଣ୍‌ ନାସ୍‌ କଃରୁକେ ନାସେ ମଃତର୍‌ ବଚାଉଁକେ ଆସି ଆଚେ” ");
INSERT INTO bdv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ତାର୍‌ହଃଚେ ସେମଃନ୍ ଆରେକ୍‌ ଗଟ୍‌ ବିନ୍ ଗାଉଁ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ସେମଃନ୍ ବାଟେ ଜାତା ବଃଳ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ତୁୟ୍‌ ଜୁୟ୍‌ତି ଗଃଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ ତର୍‌ ହଃଚେ ହଃଚେ ଆସିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “କଲ୍ୟାର୍‌ ହାର୍‌ ଆଚେ, ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନାର୍‌ ବାସା ଆଚେ, ମଃତର୍‌ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ମୁଣ୍ଡ୍ ଗୁଞ୍ଜୁକେ ଟାଣ୍ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ତାର୍‌ହଃଚେ ସେ ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ ।” ମଃତର୍‌ ସେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ହଃର୍ତୁ ଜାୟ୍‌ ମର୍‌ ଉବାକ୍‌ ବେଟି ହଃକାଉଁକ୍‌ ମକ୍‌ ଚାଡି ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମଃତର୍‌ ସେ ତାକେ କୟ୍‌ଲା, “ମଃଲା ଲକ୍‌ମଃନ୍‌କେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମଃଲା ଲକ୍‌କେ ବେଟି ହଃକାଉଁକ୍‌ ଚାଡି ଦେସ୍‌, ମଃତର୍‌ ତୁୟ୍‌ ଜା ଆର୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ କଃତା ପର୍ଚାର୍‌ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌ ହେଁ କୟ୍‌ଲା, “ମାପ୍ରୁ ତର୍‌ ହଃଚେ ହଃଚେ ଆସିନ୍ଦ୍‌ ମଃତର୍‌ ହଃର୍ତୁ ମର୍‌ ଗଃରାର୍‌ ଲକ୍‌ମଃନ୍ ତଃୟ୍‌ହୁଣି ସେଲ ମାଗି ଆସୁକ୍‌ ଚାଡି ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜେ ନାଗୁରେ ଆତ୍‌ ଚାହି କଃରି ହଃଚ୍‌ବାଟ୍‌ ଦଃକେଦ୍‌, ସେ ମାପ୍ରୁର୍‌ ରାଇଜାର୍‌ ଜୟ୍‌ଗ୍‌ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ଆର୍‌ ହଃଚେ ମାପ୍ରୁ ଆର୍‌ ତିନି କଳି ଦଃସ୍‌ ଲକ୍‌କେ ବାଚ୍‌ଲା ଆର୍‌ ଜୁୟ୍‌ ଗଃଳେ ଆର୍‌ ଟାଣେ ସେ ଜଃଉଁକେ ମଃନ୍‌ କଃରି ରିଲା ସେ ଟାଣ୍ ମଃନ୍‌କେ ଦୁୟ୍‌ ଦୁୟ୍‌ ଲକ୍‌ କଃରି ସେମଃନ୍‌କେ ତାର୍‌ ଆଗ୍‌ତୁ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଆରେକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତାସ୍‌ ସିନା ଜଃବର୍‌, ହାୟ୍‌ଟି କଃର୍ତା ଲକ୍‌ ଉଣା । ଇତାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ତାସ୍‌ ହଃଦାୟ୍‌ ହାୟ୍‌ଟି କଃର୍ତା ଲକ୍‌କେ ହଃଟାଉଁକେ, ତାସ୍‌ହଃଦାର୍‌ ସାଉକାର୍‌କେ ଗଃଉଆରି କଃରା । ");
INSERT INTO bdv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ତୁମିମଃନ୍ ଜାହା ! ଦଃକା ବାଗ୍‌ମଃନାର୍‌ ମଃନ୍ଦାୟ୍‌ ମେଣ୍ଡାମଃନାର୍‌ ହର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ହଃଟାଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ମଣା, ଡାବୁ ଦଃରୁକ୍‌ ଜାଲିଆ ମଣା ଆର୍‌ ହାଣ୍ଡାୟ୍‌ ନିଆଁନାୟ୍‌, ଆର୍‌ ବାଟେ କାକେ ଜୁଆର୍‌ କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆର୍‌ ଜୁୟ୍‌ ଗଃରେ ତୁମିମଃନ୍ ହୁରାସ୍‌, ହଃର୍ତୁ କଃଉଆ ଇ ଗଃରେ ସୁସ୍ତା ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଆର୍‌ ସେ ଗଃରେ ଜଦି ସୁସ୍ତାର୍‌ ଜୟ୍‌ଗ୍‌ ଲକ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ତୁମିମଃନାର୍‌ ସୁସ୍ତା ତାର୍‌ ଉହ୍ରେ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌, ଜଦି ନଃରେୟ୍‌ ତଃବେ ସେ ସୁସ୍ତା ତୁମାର୍‌ ଉହ୍ରେ ଲେଉଟି ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଆରେକ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌ରି ରଃୟ୍‌ଦ୍‌, ସେରି କାୟ୍‌ କଃରି ସେ ଗଃରେ ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହାୟ୍‌ଟି କଃର୍ତାଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ବୁତି ହାଉତାର୍‌ ଜୟ୍‌ଗ୍‌, ଗଃର୍‌କେ ଗଃର୍‌ ଜାହା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଆରେକ୍‌ ଜୁୟ୍‌ ଗଃଳେ ତୁମିମଃନ୍ ହୁରାସ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍‌କେ ଦଃର୍ତି, ସେତି ତୁମିମଃନ୍‌କେ ଜାୟ୍‌ରି ଦିଆ ଅୟ୍‌ଦ୍‌ ସେରି କାହା । ");
INSERT INTO bdv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ସେତି ରିଲା ଜଃର୍‌ଦୁକା ଲକ୍‌ମଃନ୍‌କେ ଉଜ୍‌ କଃରା ଆର୍‌ ସେମଃନ୍‌କେ କଃଉଆ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ତୁମାର୍‌ ଚଃମେ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମଃତର୍‌ ଜୁୟ୍‌ ଗଃଳେ ତୁମି ହୁରାସ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍‌କେ ନଃଦେର୍ତି, ସେତିର୍‌ ସଃକ୍ଳାୟ୍‌ମଃନ୍‌ ବାରାୟ୍‌ ଜାୟ୍‌ କଃଉଆ, ");
INSERT INTO bdv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ତୁମିମଃନାର୍‌ ଗଃଳାର୍‌ ଜୁୟ୍‌ ଦୁଳି ଅଃମାର୍‌ ହାଦେ ଡଃସି ଆଚେ, ସେରି ହେଁ ତୁମାର୍‌ ଗିନେ ହାହଳି ଦେଉଁଲୁ, ଅୟ୍‌ଲେକ୍‌ ହେଁ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଜେ ଚଃମେ ଅୟ୍‌ଲି, ଇରି ଜାଣି ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେ ବିଚାର୍‌ କଃର୍ତା ଦିନ୍ ସେ ଗଃଳାର୍‌ ଡଃଣ୍ଡ୍‌ ତଃୟ୍‌ହୁଣି ସଦମ୍‌ ହାୟ୍‌ଲା ଦଃଣ୍ଡ୍‌ ଉଣା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ଚି ! ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ କରାଜିନ୍ ତର୍‌ ଦଃସା କି ବୟଃଙ୍କାର୍‌ ଅୟ୍‌ଦ୍‌, ଚି ! ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ବେତ୍‌ସାଇଦା ତର୍‌ ଦଃସା ହେଁ କି ବୟଃଙ୍କାର୍‌ ଅୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ତଃୟ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌ କଃରା ଅୟ୍‌ଆଚେ, ସେ ସଃବୁ ଜଦି ସର୍‌ ଆର୍‌ ସିଦନେ କଃରା ଅୟ୍‌ରିଲେକ୍‌, ସେମଃନ୍ କଃତେକ୍‌ କାଳ୍‌ ଆଗ୍‌ତୁ ବାସ୍ତା ହିନ୍ଦି ଚାରେ ବଃସି ମଃନ୍ ବାଦ୍‌ଲାୟ୍‌ ହାହ୍‌ ଚାଡି ରିଲାୟ୍‌ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଅୟ୍‌ଲେକ୍‌ ହେଁ ବିଚାର୍‌ କଃର୍ତା ଦିନ୍, ତୁମିମଃନାର୍‌ ଦଃସା ତଃୟ୍‌ହୁଣି ସର୍‌ ଆର୍‌ ସିଦନାର୍‌ ଦଃସା ଉଣା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆର୍‌ ରେ କପୁର୍ନାହୁମ୍‌ ଜୁୟ୍‌ କାୟ୍‌ ସଃର୍ଗ୍‌ ହଃତେକ୍‌ ଉଟ୍‌ସି ? ନଃର୍କ୍ ହଃତେକ୍‌ ତକେ ତଃଳେ ହଃକା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁ ଆରେକ୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଜେ ତୁମାର୍‌ କଃତା ସୁଣେଦ୍‌, ସେ ମର୍‌ କଃତା ସୁଣେଦ୍‌, ଆର୍‌ ଜେ ତୁମିକେ ମାନ୍‌ତି ନଃକେରେ, ସେ ମକେ ମାନ୍‌ତି ନଃକେରେ, ଆର୍‌ ଜେ ମକେ ମାନ୍‌ତି ନଃକେରେ, ସେ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବାକ୍‌ ହେଁ ମାନ୍‌ତି ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଇତାର୍‌ହଃଚେ ସେ ତିନି କଳି ଦଃସ୍‌ଲକ୍‌ ବାଉଳି ଆସି ସଃର୍ଦା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ବୁତ୍‌ମଃନ୍‌ ହେଁ ତର୍‌ ନାଉଁଏ ଅଃମିମଃନାର୍‌ ଆଦେସ୍‌ ମାନ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ବିଜ୍‌ଲି ହର୍‌ ସଃର୍ଗେ ହୁଣି ସୟ୍‌ତାନ୍‌କେ ଅଦୁର୍ତାର୍‌ ମୁଁୟ୍‌ ଦଃକ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ଦଃକା ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସାହ୍‌ ଆର୍‌ ମିଚକାକ୍‌ଳା ଉହ୍ରେ ଇଣ୍ଡୁକ୍‌ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଆଚି, ଆରେକ୍‌ ସଃତ୍ରୁର୍‌ ସଃବୁ ସଃକ୍ତି ଉହ୍ରେ ହେଁ ତୁମିକେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ ଆଚି, ଆର୍‌ କାୟ୍‌ରି ହେଁ ତୁମିମଃନାର୍‌ ନଃସ୍ଟ୍‌ କଃରୁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ଅୟ୍‌ଲେକ୍‌ ହେଁ ବୁତ୍‌ମଃନ୍‌ ଜେ ତୁମାର୍‌ ତଃଳେ ଆଚ୍‌ତି, ଇତାକ୍‌ ସଃର୍ଦା ଅଃଉଆ ନାୟ୍‌, ମଃତର୍‌ ତୁମିମଃନାର୍‌ ନାଉଁ ଜେ ସଃର୍ଗେ ଲେକା ଅୟ୍‌ଆଚେ, ଇତାକ୍‌ ସଃର୍ଦା ଅଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ସଃଡେବଃଳ୍‌ ଜିସୁ ପବିତ୍ର ଆତ୍ମାର୍‌ ସଃକ୍ତିୟେ ସଃର୍ଦା ଅୟ୍‌ କୟ୍‌ଲା, “ଉବା, ସଃର୍ଗ୍‌ ଆର୍‌ ହୁର୍ତିବିର୍‌ ମାପ୍ରୁ, ତୁୟ୍‌ ଗ୍ୟାନି ଆର୍‌ ବୁଦିଗିଆନ୍‌ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ଇ ସଃବୁ କଃତା ଲୁକାୟ୍‌ କଃରି ସାନ୍ ହିଲାମଃନାର୍‌ ଟାଣେ ଜାଣାୟ୍‌ଲିସ୍‌, ଇତାର୍‌ ଗିନେ ତର୍‌ ଗୁଣ୍ କଃଉଁଲେ । ହିଁ ଉବା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇରି ହଃକା ତର୍‌ ଆକାୟ୍‌ ବଃଡ୍ ସଃର୍ଦାର୍‌ କଃତା ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ମର୍‌ ଉବାର୍‌ ଅଃଦିକାରେ ରିଲା ସଃବୁ ଅଃଦିକାର୍‌ ମକ୍‌ ଦିଆ ଅୟ୍‌ଆଚେ, ଆର୍‌ ହୟ୍‌ସିକେ କେ ନଃଜାଣ୍‌ତି, ମଃତର୍‌ ଉବାସି ହଃକା ଜାଣିଆଚେ, ଆରେକ୍‌ ଉବାକ୍‌ କେ ନଃଜାଣ୍‌ତି, ମଃତର୍‌ ହଅ ହଃକା ଜାଣିଆଚେ, ଆର୍‌ ହଅ ଜୁୟ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଉବାକ୍‌ ଜାଣାଉଁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ସେମଃନ୍ ହଃକା ଜାଣ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଆରେକ୍‌ ଜିସୁ ନିଜାର୍‌ ଚେଲାମଃନାର୍‌ ହାକ୍‌ ଲେଉଟିକଃରି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଇ ସଃବୁ ଦଃକିଆଚାସ୍‌ ବଃଲି ତୁମିମଃନାର୍‌ କଃତେକ୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ତୁମିମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ଦଃକୁଲାସ୍‌, ସେରି ସଃବୁ କଃତେକ୍‌ ବାବ୍‌ବାଦି ଆର୍‌ ରଃଜା ଦଃକୁକ୍‌ ମଃନ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ନଃଦେକ୍‌ଲାୟ୍‌; ଆରେକ୍‌ ତୁମିମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣୁଲାସ୍‌, ସେରି ସଃବୁ ସେମଃନ୍ ସୁଣୁକ୍‌ ମଃନ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ନଃସୁଣ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆର୍‌ ଦଃକା ଗଟେକ୍‌ ବିଦି ସିକାଉ ଉଟି ଆସି ଜିସୁକେ କଃଟାଳ୍‌ ବୁଜୁକ୍‌ ହଃଚାର୍ଲା, “ଏ ଗୁରୁ, ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉଁକ୍‌ ମୁଁୟ୍‌ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଦଃର୍ମ୍‌ ବିଦିଏ କାୟ୍‌ରି ଲେକା ଆଚେ ? ତୁୟ୍‌ କଃନ୍‌କଃରି ହାଟ୍‌ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ସେ କୟ୍‌ଲା, “ତୁମି ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ଗଃର୍ବ୍‌, ସଃର୍ନେ ହଃରାଣ୍, ସଃର୍ନେ ସଃକ୍ତି ଆର୍‌ ସଃର୍ନେ ମଃନ୍ ଦଃୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌କେ ଲାଡ୍‌ କଃରା, ଆର୍‌ ନିଜ୍‌କେ ଲାଡ୍‌ କଃଲା ହର୍‌ ହାକିହଃଳ୍‌ସାକେ ଲାଡ୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ସେତାକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ସଃତ୍‌ କଃତା କୟ୍‌ଲିସ୍‌, ତଃବେ ଇରି କଃର୍‌ ସେନ୍ ଅୟ୍‌ଲେକ୍‌ ତୁୟ୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମଃତର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁ ଅଃହ୍‌ଣାକ୍‌ ଦଃର୍ମି ବଃଲି ଦଃକାୟ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃରି, ଜିସୁକେ ହଃଚାର୍ଲା, “ତଃବେ ମର୍‌ ହାକିହଃଳ୍‌ସା କେ ?” ");
INSERT INTO bdv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ସେକଃତାକେ ଦଃରି କୟ୍‌ଲା, “ଗଟେ ଲକ୍‌ ଜିରୁସାଲମେ ହୁଣି ଜିରିହକେ ଜାତା ବଃଳ୍‌ କଃଙ୍ଗାର୍‌ମଃନାର୍‌ ହାବ୍ଳେ ହଃଳ୍‌ଲା, ତାର୍‌ ହଃଚ୍ୟା ହାଟା ଚାଡାୟ୍‌ ନିଲାୟ୍‌ ଆର୍‌ ମାଡ୍ ମାର୍‌ଲାୟ୍‌ ଆର୍‌ ମଃରାଜିଉଆ କଃରି ଚାଡି ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଇ ଗଃଟ୍‍ଣାହଃଚେ ଗଟେକ୍‌ ଜାଜକ୍‌ ସେ ବାଟେ ଜାତି ରିଲା, ଆର୍‌ ସେ ତାକ୍‌ ଦଃକି ବିନ୍ ବାଟ୍‌ ହିଟିକଃରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ସେବାନ୍ୟା ଗଟେକ୍‌ ଲେବିୟ, ବଃଲେକ୍‌ ପାରାଚିନ୍ ହେଁ ସେଟାଣେ ଆସି ତାକେ ଦଃକି ବିନ୍ ବାଟ ଅୟ୍‌କଃରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମଃତର୍‌ ଗଟେକ୍‌ ସମିରଣିୟ ଲକ୍‌ ତାର୍‌ ଚଃମେ ଆସି ତାକ୍‌ ଦଃକି ଦଃୟା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆର୍‌ ତାର୍‌ ଚଃମେ ଜାୟ୍‌ ତାର୍‌ ଗାଉ ତଃୟ୍‌ଁ ଚିକଣ୍‌ ଆର୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଡାଳି ସେ ସଃବୁ ହାଟ୍‌ଳି ସଃଙ୍ଗ୍ ବାନ୍ଦ୍‌ଲା ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃଦ ଉହ୍ରେ ବଃସାୟ୍‌ ବାଟ ଲଃଗାର୍‌ ଗଟେକ୍‌ ବିସାଉତା ଗଃରେ ନିଲା, ଆର୍‌ ତାର୍‌ ସେବା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଜଳେକ୍‌ ରୁହା ଟଃକା ବାର୍‌କଃରି ଦଃର୍ମ୍‌ସାଳାର୍‌ ମୁଳିକାକେ ଦଃୟ୍‌କଃରି କୟ୍‌ଲା, ଇଲକାର୍‌ ସେବା ଜଃତୁନ୍ କଃର୍‌, ଜାୟ୍‌ରି ଅଃଦିକ୍‌ ଅୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ବାଉଳି ଆୟ୍‌ଲା ବଃଳ୍‌ ସଃବୁ ଦଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଇ ତିନି ଲକ୍‌ ବିତ୍ରେ କେ କଃଙ୍ଗାର୍‌ମଃନାର୍‌ ହାବୁଳେ ହଃଳି ରିଲା ଲକାର୍‌ ହାକିହଃଳ୍‌ସା ବଃଲି ମଃନେ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ଦଃର୍ମ୍‌ ଗୁରୁ ଉତୁର୍‌ ଦିଲା, “ଜେ ତାକ୍‌ ଦଃୟା କଃଲା ସେ,” ଜିସୁ ତାକେ କୟ୍‌ଲା, “ଜାଆ ଆର୍‌ ତୁୟ୍‌ ହେଁ ସେନ୍ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଗଟେକ୍‌ ଗାଉଁଏ ହୁର୍ଲାୟ୍‌, ଆର୍‌ ମାର୍ତା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ମାୟ୍‌ଜି ତାର୍‌ ଗଃରେ କୁଦି ନିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରିୟମ୍‌ ନାଉଁଆର୍‌ ତାର୍‌ ବେଣି ରିଲି, ସେ ଜିସୁ ମାପ୍ରୁର୍‌ ହାଦ୍‌ ତଃଳେ ବଃସି ତାର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମଃତର୍‌ ମାର୍ତା ରାନ୍ଦାଗାଟା କଃର୍ତା କାମେ ଲାଗି ରିଲି, ଇତାକ୍‌ ସେ ଜିସୁର୍‌ ଚଃମେ ଆସି କୟ୍‌ଲି, “ଏ ମାପ୍ରୁ, ମର୍‌ ବେଣି ମକ୍‌ ଗଟ୍‌ଲକ୍‌କେ ଗଃରାର୍‌ ରାନ୍ଦା ଗଃଟା କାମ୍‌ କଃରୁକେ ଦଃକାୟ୍‌ ଦଃୟ୍‌ ଆଚେ, ସେବାଟ୍‌ କାୟ୍‌ ତର୍‌ ମଃନ୍‌ ନାୟ୍‌ ? ତଃବେ ମକେ ଉହ୍‌କାର୍‌ କଃରୁକେ ତାକ୍‌ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମଃତର୍‌ ମାପ୍ରୁ ଉତୁର୍‌ ଦିଲା, “ମାର୍ତା, ମାର୍ତା, ତୁୟ୍‌ ବୁତେକ୍‌ ବିସୟ୍‌ ଚିତା କଃରୁଲିସ୍‌ ଆର୍‌ ଜଃଞ୍ଜାଳ୍‌ ଅଃଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମଃତର୍‌ ଅଃଳକ୍‌ କଃତିଗଟ୍‌, ମଃତର୍‌ ଗଟେକ୍‌ ହଃକା ଲଳା; ମରିୟମ୍‌ ତ ମର୍‌ କଃତା ସୁଣ୍‌ଲି ଆର୍‌ ନିକ ବାଗ୍ ବାଚ୍‌ଲା ଆଚେ ଆର୍‌ ସେରି ତାର୍‌ ତଃୟ୍‌ହୁଣି ଚାଡାୟ୍‌ ନେଉଁ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ଗଟ୍‌ତର୍‌ ଜିସୁ କୁୟ୍‌ ଗଟ୍‌ ଟାଣେ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲା, ସେ ପାର୍ତ୍‌ନା ସଃରାୟ୍‌ଲାକ୍‌, ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକ୍‌ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ଜଃନ୍‌କଃରି ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ ପାର୍ତ୍‌ନା କଃରୁକେ ସିକାୟ୍‌ଲା, ସେନ୍‌କଃରି ଅଃମିମଃନ୍‌କ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ସିକାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଇତାକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ପାର୍ତ୍‌ନା କଃରାସ୍‌, ସଃଡେବଃଳ୍‌ କଃଉଆ, ଏ ଅଃମାର୍‌ ଉବା, ତର୍‌ ନାଉଁ ପବିତ୍ର ବଃଲି ମାନ୍‌ତି ଅଃଉଅ, ତର୍‌ ରାଇଜ୍‌ ଆସ । ");
INSERT INTO bdv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ହଃତି ଦିନ୍ ଅଃମାର୍‌ ଲଳା ରିଲା କାଦି ଦେ । ");
INSERT INTO bdv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ଅଃମାର୍‌ ହାହ୍‌ ସଃର୍ନେ କେମା କଃର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ହେଁ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଦସିମଃନ୍‌କେ କେମା କଃରୁଲୁ, ପରିକ୍ୟାୟ୍‌ ଅଃମିମଃନ୍‌କ୍‌ ଆଣ୍‌ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଆର୍‌ ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍‌କାର୍‌ କାର୍‌ ଅଃନ୍‌କାର୍‌ ମିତ୍ର ଆଚେ କି, ଜାର୍‌ ଚଃମେ ମଃଜାରାତି ସେ ଜାୟ୍‌ କୟ୍‌ଦ୍‌, ଏ ମାପ୍ରୁସାଦ୍‌ ମକେ ତିନିଗଟ୍‌ ରୁଟି ଉଦାର୍‌ ଦେ, ");
INSERT INTO bdv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ଗଟେକ୍‌ ମିତ୍ର ଗତ୍‌ ଆସି ଆଚେ, ତାକ୍‌ କାଉଁକେ ଦେଉଁକେ ମର୍‌ ଟାଣେ କାୟ୍‌ରି ହେଁ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆର୍‌ ସେ ଗଃର୍‌ ବିତ୍ରେହୁଣି ଅଃନ୍‌କଃରି କୟ୍‌ଦ୍‌ ମକେ କଃସ୍ଟ୍‌ ଦେନାୟ୍‌, ଦୁଆର୍‌ ଡାହ୍‌ଲୁବେ, ଆର୍‌ ମର୍‌ ହିଲାମଃନ୍ ମର୍‌ ସଃଙ୍ଗ୍ ସଇ ଆଚ୍‌ତି, ମୁଁୟ୍‌ ଉଟି ତକେ ଦେଉଁକେ ନାହାରି । ");
INSERT INTO bdv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେ ତାର୍‌ ମିତ୍ର ଅୟ୍‌ରିଲାକ୍‌ ହେଁ ଉଟି ନଃଦେୟ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ଲାଜ୍‌ ନଃୟ୍‌କଃରି ତର୍‌କେ ତର୍‌ ମାଗ୍‌ତି ରିଲାକ୍‌, ସେ ଉଟି ତାର୍‌ ଜଃତେକ୍‌ ଲଳା ସଃତେକ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ମୁଁୟ୍‌ ହେଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ମାଗା ତୁମିମଃନ୍‌କେ ଦିଆ ଅୟ୍‌ଦ୍‌, ଲଳା ମିଳାଉଆସ୍‌, କଃହାଟେ ମାରା ତୁମିମଃନାର୍‌ ଗିନେ ମେଲା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜେ ମାଗେଦ୍‌ ସେ ହାୟ୍‌ଦ୍‌, ଜେ ଲଳେଦ୍‌ ସେ ମିଳାୟ୍‌ଦ୍‌, ଆର୍‌ ଜେ କଃହାଟେ ମାରେଦ୍‌ ତାର୍‌ ଗିନେ କଃହାଟ୍‌ ଉଗାଳି ଦିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଆର୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ଅଃନ୍‌କାର୍‌ ଉବାସି କେ ଆଚେ, ଜାକେ ତାର୍‌ ହୟ୍‌ସି ମାଚ୍ ମାଗ୍‌ଲେକ୍‌ ସେ ତାକେ ମାଚ୍ ବାଦୁଲେ ସାହ୍‌ ଦଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଆର୍‌ ଡିମ୍‌ ମାଗ୍‌ଲେକ୍‌, ତାକ୍‌ କାୟ୍‌ ମିଚକାକ୍‌ଳା ଦଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ଇତାକ୍‌ ତୁମିମଃନ୍ କଃରାବ୍‌ ଅୟ୍‌ଲେକ୍‌ ହେଁ, ଜଃବେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହିଲାମଃନ୍‌କେ ନିକ ନିକ ଦାନ୍‌ ଦେଉଁକେ ଜାଣାସ୍‌, ତଃବେ ଜୁୟ୍‌ ଉବା ସଃର୍ଗେହୁଣି ଦାନ୍‌ କଃରେଦ୍‌, ସେ ତାର୍‌ ଚଃମେ ମାଗ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ କଃତେକ୍‌ ଅଃଦିକ୍‌ ପବିତ୍ର ଆତ୍ମା ନଃଦେୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ଗଟ୍‌ତର୍‌ ଜିସୁ ଗଟେକ୍‌ ବୁତ୍‌ ଚାଡାଉତି ରିଲା, ସେରି ଗୁଲା ବୁତ୍‌; ବୁତ୍‌ ବାରାୟ୍‌ ଗଃଲା ହଃଚେ ଗୁଲା ଲକ୍‌ କଃତା କୟ୍‌ଲା, ସେତାକ୍‌ ଲକ୍‌ମଃନ୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କେ କେ କୟ୍‌ଲାୟ୍‌, “ଜିସୁ ଦୁତ୍‌ମଃନାର୍‌ ମୁଳିକା ବାଲ୍‌ଜିବୁଲ୍‌କେ ଦଃରି ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ବିନ୍ ଲକ୍‌ମଃନ୍ ତାକେ ହାନ୍ଦାୟ୍‌ ହଃକାଉଁକ୍‌ ମଃନ୍‌ କଃର୍ତି ରିଲାୟ୍‌, ଇତାର୍‌ ଗିନେ ଇସ୍ୱର୍‌ ଜେ ତାର୍‌ ସଃଙ୍ଗେ ଆଚେ, ଇତିର୍‌ ଚିନ୍ ହଃର୍କାରେ ଅଃଗାସ୍‌ ଉହ୍ରେ ଗଟେକ୍‌ ଚିନ୍ ଦଃକାଉଁକ୍‌ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ମଃନାର୍‌ କଃତା ଜାଣି କୟ୍‌ଲା, “ଜୁୟ୍‌ ରାଇଜ୍‌ ହେଁ ବାଗ୍ ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟ୍‌ଲେକ୍‌, ସେ ନାସ୍‌ ଅୟ୍‌ ଜାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଗଟେକ୍‌ ଗଃର୍‌ ଦୁୟ୍‌ ବାଗ୍ ଅୟ୍‌ଲେକ୍‌ ସେରି ନାସ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆର୍‌ ସୟ୍‌ତାନ୍‌ ହେଁ ଜଦି ବାଗ୍ ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଉଟ୍‌ଲିନି, ସେନ୍ ଅୟ୍‌ଲେକ୍‌ ତାର୍‌ ରାଇଜ୍‌ କଃନ୍‌କଃରି ତିର୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ? ମୁଁୟ୍‌ ବାଲ୍‌ଜିବୁଲ୍‌କେ ଦଃରି ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲେ ବଃଲି ତୁମିମଃନ୍ ତ କଃଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ମଃତର୍‌ ମୁଁୟ୍‌ ଜଃବେ ବାଲ୍‌ଜିବୁଲ୍‌କେ ଦଃରି ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲେ, ତଃବେ ତୁମାର୍‌ ହୟ୍‌ଦିମଃନ୍‌ କାକେ ଦଃରି ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲାୟ୍‌ ? ଇତାକ୍‌ ସେମଃନ୍ ହଃକା ତୁମାର୍‌ ବିଚାର୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ମଃତର୍‌ ମୁଁୟ୍‌ ଜଦି ଇସ୍ୱରାର୍‌ ସଃକ୍ତିୟେ ବୁତ୍‌ମଃନ୍‌କେ ଚାଡାଉଁଲେ, ଇରି ଜାଣାହଃଳୁଲି ଜେ, ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ତୁମାର୍‌ ଚଃମେ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ସଃକ୍ତିମାନ୍‌ ଲକ୍‌ ଜୁୟ୍‌ ହଃତେକ୍‌ ଅଃତ୍ୟାର୍‌ ସଃଙ୍ଗ୍ ଅଃହ୍‌ଣାର୍‌ ଗଃର୍‌ ବାଚାୟ୍‌ଦ୍‌, ସେ ହଃତେକ୍‌ ତାର୍‌ ଦଃନ୍ ବିତ୍‌ ତିର୍‌ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବଃଳ୍‌ଉଆ ଲକ୍‌ ତାକେ ମାଡି ବଃସେଦ୍‌ ଆର୍‌ ଜିଣେଦ୍‌ ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଅଃତ୍ୟାର୍‌ ଉହ୍ରେ ତାର୍‌ ଆସ୍ର ରିଲି, ସେରି ସଃବୁ ସେ ଜିକି ନଃୟ୍‌ଦ୍‌, ଆର୍‌ ତାର୍‌ ଦଃନ୍‌ବିତ୍‌ ହେଁ ଚରି ନଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ଜେ ମର୍‌ ସଃଙ୍ଗାର୍‌ ନାୟ୍‌, ସେ ମର୍‌ ବିରଦି, ଆରେକ୍‌ ଜେ ମର୍‌ ସଃଙ୍ଗ୍ ନଃରୁଣ୍ଡାୟ୍‌, ସେ ଜଃତ୍‌କଃତ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ବିଟାଳ୍‌ ଆତ୍ମା ଗଟ୍‌ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ବାରାୟ୍‌ ଗଃଲା ହଃଚେ, ହାଣି ନୟ୍‌ଲା ଜଃଗା ସଃବୁ ବୁଲିକଃରି ବିସାଉଁକ୍‌ ଟାଣ୍ ଲଳେଦ୍‌, ଆର୍‌ ସେରି ନଃମିଳ୍‌ଲେକ୍‌, ସେ କୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ଜୁୟ୍‌ ଗଃରେହୁଣି ବାରାୟ୍‌ ଆସିରିଲେ, ମର୍‌ ସେ ଗଃରେ ଲେଉଟି ଜାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆରେକ୍‌ ସେଗଃରେ ଆସି ସେରି ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ସୁନ୍ଦୁର୍‌ ଅୟ୍‌ରିଲାର୍‌ ଦଃକେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ସଃଡେବଃଳ୍‌ ସେ ଜାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଦୁସ୍ଟ୍‌ ଆରେକ୍‌ ସାତ୍‌ ଗଟ୍‌ ଆତ୍ମା ସଃଙ୍ଗେ ଦଃରି ଆସେଦ୍‌ ଆର୍‌ ସେମଃନ୍ ଆସି ସେତି ବାସା କଃର୍ତି ଆର୍‌ ସେଲକାର୍‌ ହଃର୍ତୁର୍‌ ଦଃସା ତଃୟ୍‌ହୁଣି ସେସ୍‌ ଦଃସା ଅଃଦିକ୍‌ କଃରାବ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ସେ ଇସଃବୁ କଃତା କଃଉତା ବଃଳ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ମାୟ୍‌ଜି ଆଉଲି ଅୟ୍‌ଲି ଆର୍‌ କୟ୍‌ଲି, “ବାୟ୍‌ଗ୍‌ ସେ ଗଃର୍ବ୍‌, ଜୁୟ୍‌ରି ତକେ ଦଃର୍ଲି, ଆର୍‌ ସେ ଦୁଦ୍‌, ଜୁୟ୍‌ତି ହୁଣି ତୁୟ୍‌ କାୟ୍‌ଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ନାୟ୍‌, ଜୁୟ୍‌ମଃନ୍‌ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ସୁଣ୍‌ତି ଆର୍‌ ମାନ୍‌ତି ସେମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ଲକ୍‌ମଃନ୍ ମଃନ୍ଦା ମଃନ୍ଦା ଅୟ୍‌ ରୁଣ୍ଡ୍‌ଲାବଃଳ୍‌, ଜିସୁ କଃଉଁକେ ଦଃର୍ଲା, “ଇ ଅଃବାର୍‌ ଲକ୍‌ ଦୁସ୍ଟ୍‌ । ଇମଃନ୍‌ ଚିନ୍ ଲଳ୍‌ତି, ମଃତର୍‌ ଜୁନସାର୍‌ ଚିନ୍ ଚାଡି ବିନ୍ କାୟ୍‌ ଚିନ୍ ସେମଃନ୍‌କେ ଦିଆ ନୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁନସ୍‌ ଜଃନ୍‌କଃରି ନିନିବିର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଚିନ୍ ହର୍‌ ଅୟ୍‌ଲା, ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ସେବାନ୍ୟା, ଇ କାଳାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଚିନ୍ ହର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ସିବା ଦେସାର୍‌ ରାଣି ବିଚାରେ ଇ କାଳାର୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଉଟି ସେମଃନ୍‌କେ ଦସି କଃରେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ସଲ୍‌ମନାର୍‌ ଗ୍ୟାନାର୍‌ କଃତା ସୁଣୁକ୍‌ ହୁର୍ତିବି ସଃର୍ଲା କନେହୁଣି ଆସିରିଲି, ଆର୍‌ ଦଃକା, ଇତି ସଲ୍‌ମନାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ କଃତା ଇତି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନିବିର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିଚାର୍‌ କଃର୍ତା ଦିନ୍ ଇ କାଳାର୍‌ ଲକ୍‌ମଃନ୍ ସଃଙ୍ଗ୍ ଟିଅୟ୍‌, ଏମଃନ୍‌କେ ଦସି କଃର୍ତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଜୁନସାର୍‌ ପର୍ଚାର୍‌ ସୁଣି ହାହ୍‌ ଚାଡିରିଲାୟ୍‌ । ଆର୍‌ ଦଃକା, ଜୁନସାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ କଃତା ଇତି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“କେ ହେଁ କୁପି ଲାଗାୟ୍‌ ଲୁକାୟ୍‌କଃରି କି ମାଣ୍ ତଃଳେ ନଃସେଙ୍ଗାୟ୍‌, ମଃତର୍‌ ରୁକା ଉହ୍ରେ ସଃଙ୍ଗାୟ୍‌ଦ୍‌, ଜଃନ୍‌କଃରି ଗଃର୍‌ ବିତ୍ରେ ହୁର୍ତା ଲକ୍‌ମଃନ୍ ଉଜାଳ୍‌ ଦଃକୁକ୍‌ ହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ତୁମାର୍‌ ଆକି ଗଃଗାଳାର୍‌ କୁପି, ଜଃଡେବଃଳ୍‌ ତୁମାର୍‌ ଆକି ନିକ ରଃୟ୍‌ଦ୍‌ ସଃଡେବଃଳ୍‌ ତୁମାର୍‌ ସଃର୍ନେ ଗଃଗାଳ୍‌ ହେଁ ଉଜାଳ୍‌ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ସେରି ମେଳି ରଃୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ଗଃଗାଳ୍‌ ହେଁ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ତଃବେ ଜଃଗ୍ରାତ୍‌, ଜଃନ୍‌କଃରି ତୁମାର୍‌ ମଃନାର୍‌ ଉଜାଳ୍‌ ଅଃନ୍ଦାର୍‌ ନୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଇତାକ୍‌ ତୁମାର୍‌ ସଃର୍ନେ ଗଃଗାଳ୍‌ ଜଦି ଉଜାଳ୍‌ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ସେତିର୍‌ କୁୟ୍‌ ବାଗ୍ ହେଁ ଅଃନ୍ଦାର୍‌ ନଃରେୟ୍‌, ତଃବେ କୁପି ଜଃନ୍ ଉଜାଳ୍‌ ଅୟ୍‌ ତୁମିକେ ଉଜାଳ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେନ୍‌କଃରି ତୁମାର୍‌ ସଃର୍ନେ ଗଃଗାଳ୍‌ ଉଜାଳ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ କଃତା କଃଉତି ରିଲା ବଃଳ୍‌, ଗଟେକ୍‌ ପାରୁସି ତାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃରେ କାଉଁକେ ଗଃଉଆରି କଃଲା, ଆର୍‌ ସେ ଗଃରେ ହୁରି କଃରି କାଉଁକେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମଃତର୍‌ ଜିସୁ କାତା ଆଗ୍‌ତୁ ଆତ୍‌ ଦଃୟ୍‌ ନଃରିଲା, ଇରି ଦଃକି ସେ ପାରୁସି କାବା ଅୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ସେତାକ୍‌ ମାପ୍ରୁ ତାକେ କୟ୍‌ଲା, “ତୁମି ପାରୁସିମଃନ୍ ସିନା ଗିନା ଆର୍‌ ତାଳିର୍‌ ହଃଦା ବାଟ୍ୟା ନିର୍ମୁଳ୍‌ କଃରାସ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଲଃବ୍‌ ଆର୍‌ ଦୁସ୍ଟ୍‌ କାମ୍‌ ସଃବୁ ବଃର୍ତି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ନିର୍ବୁଦିଆମଃନ୍‌, ଜେ ହଃଦା ବାଟ୍ୟା ତିଆର୍‌ କଃଲା ସେ ହେଁ କାୟ୍‌ ବିତୁର୍‌ ବାଟ୍ୟା ତିଆର୍‌ ନଃକେଲା ? ");
INSERT INTO bdv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ତୁମିମଃନ୍ ଜାୟ୍‌ରି ଲଃବ୍‌କଃରି ଅଃର୍ଜି ଆଚାସ୍‌ ସେରି ଗଃରିବ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦାନ୍‌ କଃରା, ତଃବେ ସଃତ୍‌ କଃରି ହୁରା କଃରି ନିର୍ମୁଳ୍‌ ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ମଃତର୍‌ ଚି ! ଡଃଣ୍ଡ୍‌ ହାଉତାର୍‌ ଜୟ୍‌ଗ୍‌ ପାରୁସିମଃନ୍, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ପଦିନା, ଆରୁଦ, ଆର୍‌ ସଃବୁ ରଃକମାର୍‌ ସାଗାର୍‌ ଦଃସ୍‌ ବାଗେ ହୁଣି ବାଗେକ୍‌ ଦେଉଁଲାସ୍‌, ଆର୍‌ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ଲାଡ୍‌କେ ନଃଦେକୁଲାସ୍‌, ମଃତର୍‌ ଇ ସଃର୍ନେ ମାନ୍‌ତାର୍‌ ଆର୍‌ ବିନ୍ ସଃବୁ ଚାଡ୍‌ତାର୍‌ ନିକ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଚି ! ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ପାରୁସିମଃନ୍ କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ବଃଡ୍ କୁର୍ଚି ଆର୍‌ ଆଟେ ବଃଜାରେ ଜୁଆର୍‌ ହାଉଁକ୍‌ ବଃଲ୍‌ ହାଉଆସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଚି ! ତୁମିମଃନ୍ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଲୁକ୍‌ଲା ମଃସୁଣ୍‌ କାଲ୍‌ ହର୍‌ ତାର୍‌ ଉହ୍ରେ ଜାତା ଆସ୍ତା ଲକ୍‌ମଃନ୍ ସେରି ମଃସୁଣ୍‌ କାଲ୍‌ ବଃଲି ଜାଣୁ ନଃହାର୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ବିଦି ସିକାଉ ମଃନ୍‌କାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ଇରି କୟ୍‌କଃରି ଅଃମିମଃନ୍‌କ୍‌ ହେଁ ଲାଜ୍‌ କଃରାଉଁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜିସୁ କୟ୍‌ଲା, “ଚି ! ବିଦି ସିକାଉ ଲକ୍‌ମଃନ୍‌ ତ ତୁମିମଃନ୍‌, ତୁମିମଃନ୍ ହେଁ ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ନଃହାର୍ତା ବଜ୍‌ ଲାଦୁଲାସ୍‌, ଆର୍‌ ନିଜେ ଗଟେକ୍‌ ଆଙ୍ଗଟାୟ୍‌ ହେଁ ଟେକି ଉହ୍‌କାର୍‌ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଚି ! ତୁମିମଃନ୍ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ମଃସୁଣ୍‌ ବାନ୍ଦୁଲାସ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍‌କାର୍‌ ଦାଦିବାବୁମଃନ୍ ସେମଃନ୍‌କେ ମାରି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ କାମାର୍‌ ତୁମିମଃନ୍ ସାକି ଆଚାସ୍‌ ଆର୍‌ ସେରି ମାନୁଲାସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ସିନା ସେମଃନ୍‌କେ ମାରି ରିଲାୟ୍‌, ଆରେକ୍‌ ତୁମିମଃନ୍ ସେମଃନାର୍‌ ମଃସୁଣ୍ ବାନ୍ଦୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ସେତାକ୍‌ ଇସ୍ୱର୍‌ ହେଁ ଅଃହ୍‌ଣାର୍‌ ଗ୍ୟାନେ କୟ୍‌ଆଚେ ଅଃମି ସେମଃନାର୍‌ ତଃୟ୍‌ ବାବ୍‌ବାଦି ଆର୍‌ ପେରିତ୍‌ମଃନ୍‌କେ ହଃଟାଉଁନ୍ଦ୍ । ସେମଃନାର୍‌ ବିତ୍ରେ କାକେ କାକେ ମାର୍ତି ଆର୍‌ କାକେ କାକେ ଆର୍ଲା କଃର୍ତି, ");
INSERT INTO bdv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଇ ଜୁଗାର୍‌ ଲକ୍‌ମଃନ୍ ହୁର୍ତି ଉବୁଜ୍‌ଲା ତଃୟ୍‌ହୁଣି ସଃବୁ ବାବ୍‌ବାଦିମଃନାର୍‌ ଅଃତ୍ୟା କଃଲାର୍‌ ଗିନେ ଡଃଣ୍ଡ୍‌ ହାଉତି ଜଃନ୍‌କଃରି ହେବଲାର୍‌ ବଃନି ବାର୍‌ଲା ତଃୟ୍‌ହୁଣି ଜୁୟ୍‌ ଜିକରିଅର୍‌ ହୁଜା ବେଦି ଆର୍‌ ମନ୍ଦିରାର୍‌ ପବିତ୍ର ଟାଣେ ମାଡ୍ କାୟ୍‌ ମଃଲାୟ୍‌, ତାକାର୍‌ ବାରାୟ୍‌ଲା ବଃନି ହଃତେକ୍‌ ଜଃଗତାର୍‌ ହାହେ ହଃଳ୍‌ଲି, ଜଃତେକ୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ବଃନି ବାରାୟ୍‌ ଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେବଲ୍‌କେ ଅଃତ୍ୟା ତଃୟ୍‌ ହୁଣି ଆରୁମ୍‌ କଃରି ଜିକରିଅର୍‌ ହଃତେକ୍‌ ଜାକେ କି ପବିତ୍ର ବେଦି ଆର୍‌ ପବିତ୍ର ଟାଣେ ଅଃତ୍ୟା କଃରାଜାୟ୍‌ ରିଲି । ହେଁ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ ଇ ଜୁଗାର୍‌ ଲକ୍‌ମଃନ୍‌ ସେ ସଃବୁଲକାର୍‌ ହାୟ୍‌ଁ ଦଃଣ୍ଡ୍‌ ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ଚି ! ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୟ୍‌ଗ୍‌, ବିଦି ସିକାଉମଃନ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଗ୍ୟାନାର୍‌ କୁଚିକାଡା ନିଜେ ଚର୍‌ଲାସ୍‌, ତୁମିମଃନ୍ ନିଜେ ନଃହୁର୍ଲାସ୍‌ ଆର୍‌ ହୁର୍ତା ଲକ୍‌ମଃନ୍‌କେ ହୁରୁକ୍‌ ନଃଦିଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆରେକ୍‌ ସେ ସେତି ହୁଣି ବାରାୟ୍‌ ଗଃଲା ହଃଚେ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍ ଅଃନାୟ୍‌ ଡାରା ଅୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ଜିସୁର୍‌ କଃତା ବୁଲ୍‌ ଦଃରୁକ୍‌ ହାନ୍ଦା ଅଡି, ତାକ୍‌ କଃତେକ୍‌ କଃତା ହଃଚାରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଇ ବିତ୍ରେ ଗାଦା ଲକ୍‌ମଃନ୍ ରୁଣ୍ଡି ତାକାର୍‌ ତାକାର୍‌ ଉହ୍ରେ ମାଡା ଚଃଗା ଅଃଉତି ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା, “ପାରୁସିମଃନାର୍‌ କମିର୍‌ ହର୍‌ ହେଟ୍‌କପଟ୍‌ ବିସୟେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ମଃତର୍‌ ଜାୟ୍‌ରି ନଃଡିସେ ଇରଃକମ୍‌ ଡାହି ଅୟ୍‌ଲାର୍‌ କାୟ୍‌ରି ନାୟ୍‌, ଆର୍‌ ଜାୟ୍‌ରି ଜାଣା ନଃହେଳେ ଇରଃକମ୍‌ ଲୁକ୍‌ଲାର୍‌ କାୟ୍‌ରି ନାୟ୍‌ଁ, ");
INSERT INTO bdv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ଅଃନ୍ଦାରେ କୟ୍‌ ଆଚାସ୍‌ ସେରି ସଃବୁ ସୁଣା ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଜାୟ୍‌ରି କାହାଟ୍‌ ଡାହ୍‌ଲା ବିତୁର୍‌ ବଃକ୍ରାୟ୍‌ ଲୁକ୍‌ଣେ କୟ୍‌ ଆଚାସ୍‌ ସେରି ଚାନି ଉହ୍ରେ ପର୍ଚାର୍‌ କଃରା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ମଃତର୍‌ ମର୍‌ ସଃଙ୍ଗୁଆଳି ଜେ ତୁମିମଃନ୍, ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ତୁମାର୍‌ ଗଃଗାଳ୍‌କେ ମଃର୍ନେ ମାରେଦ୍‌, ମଃତର୍‌ ତାର୍‌ହଃଚେ ଆର୍‌ କାୟ୍‌ରି କଃରୁ ନାହାରେ, ସେମଃନ୍‌କେ ଡିରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମଃତର୍‌ କାକେ ଡିରାସ୍‌, ସେରି ମୁଁୟ୍‌ ତୁମିକେ ଜାଣାୟ୍‌ଦ୍‌, ମଃର୍ନେ ମାର୍ଲା ହଃଚେ ନଃର୍କେ ହଃକାଉଁକେ ଜୁୟ୍‌ ଇସ୍ୱରାର୍‌ ଅଃଦିକାର୍‌ ଆଚେ ତାକ୍‌ ଡିରିକଃରି ରିଆ । ହେଁ ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ ତାକ୍‌ ଡିରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ହାଁଚ୍‌ଗଟ୍‌ ଜଃଟ୍ୟା ଚେଳେ କାୟ୍‌ ଜଳେକ୍‌ କାସୁ ଡାବୁୟ୍‌ ବିକା ନଃଉତି ? ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ହେଁ ଇସ୍ୱର୍‌ ନଃହାସ୍ରେ । ");
INSERT INTO bdv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ମଃତର୍‌ ତୁମିମଃନାର୍‌ ମୁଣ୍ଡାର୍‌ ସଃର୍ନେ ବାଳ୍‌ ହେଁ ଗଃଣା ଅୟ୍‌ଆଚେ । ଡିରା ନାୟ୍‌ ତୁମିମଃନ୍ ଗାଦେକ୍‌ ଗଃର୍‌ ଜଃଟ୍ୟା ଚେଳେ ହୁଣି ଅଃଦିକ୍‌ ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଆର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ମାନାୟ୍‌ ଲକାର୍‌ ମୁଏଁ ମକ୍‌ କ୍ରିସ୍ଟ ବଃଲି କୟ୍‌ଦ୍‌, ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ ମଃନାର୍‌ ମୁଏଁ ତାକେ ଜାଣି ଆଚି ବଃଲି କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମଃତର୍‌ ଜୁୟ୍‌ମାନାୟ୍‌ ଲକାର୍‌ ମୁଏଁ ମକ୍‌ ନଃଜାଣି ବଃଲେଦ୍‌, ମୁଁୟ୍‌ ହେଁ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ମଃନାର୍‌ ମୁଏଁ ତାକ୍‌ ନଃଜାଣି ବଃଲିନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ଆର୍‌ ଜୁୟ୍‌ମାନାୟ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ବିରଦେ କଃତା କୟ୍‌ଦ୍‌ ତାକ୍‌ କେମା ଦିଆ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ପବିତ୍ର ଆତ୍ମା ବିରଦେ ଲିନ୍ଦା କଃତା କୟ୍‌ଦ୍‌ ତାକେ କେମା ଦିଆ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ତୁମିମଃନ୍‌କେ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ବଃଡ୍ ଲକ୍‌ ଆର୍‌ ଅଃଦିକାରି ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ଆଣ୍‌ତି, ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ଅଃହ୍‌ଣାର୍‌ ଗିନେ କଃନ୍‌କଃରି ଆର୍‌ କାୟ୍‌ ଉତୁର୍‌ ଦିଆସ୍‌ ଆର୍‌ କାୟ୍‌ରି କଃଉଆସ୍‌ ସେତାକ୍‌ ଚିତା କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ କାୟ୍‌ରି କଃଉଁକେ ଅୟ୍‌ଦ୍‌ ସେରି ପବିତ୍ର ଆତ୍ମା ସଃଡେବଃଳ୍‌ ତୁମିକେ ସିକାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକ୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ମର୍‌ ବାୟ୍‌କ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ଦାଦି ଅଃର୍ଜ୍‌ଲା ଦଃନ୍ ବାଟା କଃରୁକେ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ବାୟ୍‌, କେ ମକେ ତୁମିମଃନାର୍‌ ଉହ୍ରେ ବିଚାର୍‌ କଃରୁକେ ଆର୍‌ ବାଟା କଃରୁକେ ଅଃଦିକାର୍‌ ଦିଲାଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆରେକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃଗ୍ରାତ୍‌ ସଃବୁ ରଃକମ୍‌ ଲଃବ୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗଟ୍‌ ଲକାର୍‌ ଜିବନ୍ ତାର୍‌ ଦଃନ୍ ବିତ୍‌ ଉହ୍ରେ ବଃର୍ସା ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ଲା, “ଗଟେକ୍‌ ମାଜନ୍ ଲକାର୍‌ ହଃଦାୟ୍‌ ବୁତେକ୍‌ ତାସ୍‌ ଅୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ସେତାକ୍‌ ସେ ମଃନେ ମଃନେ ଚିତା କଃରି କୟ୍‌ଲା, ‘କାୟ୍‌ କଃରିନ୍ଦ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାସ୍‌ ରୁଣ୍ଡାୟ୍‌ କଃରି ସଃଙ୍ଗାଉଁକେ ଟାଣ୍ ନାୟ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଆରେକ୍‌ ସେ କୟ୍‌ଲା, ‘ଇରି କଃରିନ୍ଦ୍‌, ମର୍‌ ଗଃଦ୍ୟା ସଃବୁ ବଃସ୍ଳାୟ୍‌ନ୍ଦ୍ ଆର୍‌ ବଃଡ୍ ବଃଡ୍ କଃରି ବାନ୍ଦିନ୍ଦ୍‌ ଆର୍‌ ସେତି ମର୍‌ ଗଅଁ ସଃବୁ ସଃଙ୍ଗାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆର୍‌ ମୁୟ୍‌ଁ ମର୍‌ ହଃରାଣ୍‌କେ କୟ୍‌ଦ୍‌, ରେ ହଃରାଣ୍, ବୁତେକ୍‌ ବଃର୍ସାର୍‌ ହାଁୟ୍‌ ତର୍‌ ଜଃବର୍‌ କାଦିକଣ୍ଡା ଆଚେ, ବିସାଉ, କାଆ, ଆର୍‌ ସଃର୍ଦାକଃର୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମଃତର୍‌ ଇସ୍ୱର୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ରେ ନିର୍ବୁଦିଆ ଆଜି ରାତି ତର୍‌ ହଃରାଣ୍‌ ତର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌, ସେତାକ୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ରୁଣ୍ଡାୟ୍‌ ଆଚ୍‌ସି, ସେରି ସଃବୁ କାର୍‌ ଅୟ୍‌ଦ୍‌ ?’” ");
INSERT INTO bdv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“ଜେ ଅଃହ୍‌ଣାର୍‌ ଗିନେ ଦଃନ୍ ଅଃର୍ଜେଦ୍‌, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଆକାୟ୍‌ ସେ ମାଜନ୍ ନାୟ୍‌, ତାକେ ଅଃନ୍‌କାର୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, କାୟ୍‌ରି କାଉଁନ୍ଦ୍‌ ଇରି କୟ୍‌ କଃରି, ତୁମିମଃନାର୍‌ ଜିବନ୍ ଗିନେ ଆରେକ୍‌ କାୟ୍‌ରି ହିନ୍ଦୁନ୍ଦ୍‌, ଇରି କୟ୍‌ କଃରି ତୁମିମଃନାର୍‌ ଗଃଗାଳ୍‌ ଗିନେ ହେଁ ଚିତା କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ କାଦି ତଃୟ୍‌ହୁଣି ଜିବନ୍ ଆର୍‌ ବଃସ୍ତର୍‌ ତଃୟ୍‌ହୁଣି ଗଃଗାଳ୍‌ ବଃଡ୍ । ");
INSERT INTO bdv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ଚେଳେମଃନାର୍‌ କଃତା ବାବି ଦଃକା, ସେମଃନ୍ ନଃବୁଣ୍‌ତି କି ନଃକାଟ୍‌ତି, ଆରେକ୍‌ ସେମଃନାର୍‌ ତାସ୍‌ ଗଃଦ୍ୟା ଗଃର୍‌ ନାୟ୍‌, ଆର୍‌ ଇସ୍ୱର୍‌ ସେମଃନ୍‌କେ କାଦି ଦେଉଁଲା, ତୁମିମଃନ୍ ଚେଳେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କଃତେକ୍‌ ଅଃଦିକ୍‌ ବଃଡ୍, ");
INSERT INTO bdv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଆରେକ୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ କେ ଚିତା କଃରି କଃରି ଅଃହ୍‌ଣାର୍‌ ଆୟ୍‌ଁସ୍‌ କଃଣ୍ଡେକ୍‌ ବାଡାଉଁ ହାରେ ? ");
INSERT INTO bdv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ବଃଲେକ୍‌ ତୁମିମଃନ୍ ସଃବ୍‌କେ ଗଟେକ୍‌ ସାନ୍ କାମ୍‌ ହେଁ କଃରୁ ନଃହାରାସ୍‌, ତଃବେ ବିନ୍ ସଃବୁ ବିସୟ୍‌ ଚିତା କାୟ୍‌ତାକ୍‌ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ବଃନ୍‌ ହୁଲ୍‌ମଃନାର୍‌ କଃତା ବାବି ଦଃକା, ସେରିମଃନ୍ କଃନ୍‌କଃରି ସୁତା ନଃକାଟ୍‌ତି କି ସେମଃନାର୍‌ ଗିନେ ବଃସ୍ତର୍‌ ନଃବୁଣ୍‌ତି, ଅୟ୍‌ଲେକ୍‌ ହେଁ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସଲ୍‌ମନ୍ ରଃଜା ହେଁ ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ଦଃନ୍‌ ରଃୟ୍‌କଃରି, ଗଟେକ୍‌ ହୁଲ୍‌ ହର୍‌ ହେଁ ସୁନ୍ଦୁର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ମଃତର୍‌ ଜୁୟ୍‌ ରଃନ୍ ଆଜି ହଃଦାୟ୍‌ ଆଚେ ଆର୍‌ କାଲି ଚୁଲି ବିତ୍ରେ ହଃକା ଅୟ୍‌ଦ୍‌, ତାକ୍‌ ଜଦି ଇସ୍ୱର୍‌ ଅଃନ୍‌କାର୍‌ ବେସ୍‌ ଦେଉଁଲା, ତଃବେ ଏ ଅଃଳକ୍‌ ବିସ୍ୱାସିମଃନ୍ ସେ ତୁମିକେ କଃତେକ୍‌ ଅଃଦିକ୍‌ ନଃଦେୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ଆରେକ୍‌ କାୟ୍‌ରି କାହାସ୍‌ ଆର୍‌ କାୟ୍‌ରି ହିଉଆସ୍‌, ସେରିମଃନ୍‌ ଲଳି ବୁଲା ନାୟ୍‌ ଆର୍‌ ଚିତା ହେଁ କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଃଗତାର୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନ୍ ଇରିମଃନ୍‌ ଲଳି ବୁଲ୍‌ତି, ମଃତର୍‌ ଇ ସଃବୁ ବିସୟ୍‌ ଜେ ତୁମିମଃନାର୍‌ ଲଳା ଆଚେ ସେରି ତୁମିମଃନାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦି ଜାଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମଃତର୍‌ ତୁମିମଃନ୍ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଲଳା, ଆର୍‌ ଇ ସଃବୁ ବିସୟ୍‌ ତୁମିମଃନ୍‌କେ ଦିଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ଏ ସାନ୍ ଦଃଳ୍‌, ଡିରା ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍‌କେ ତାର୍‌ ରାଇଜ୍‌ ଦେଉଁକେ ତୁମିମଃନାର୍‌ ସଃର୍ଗାର୍‌ ଉବାଦିର୍‌ ବଃଡେ ସଃର୍ଦା । ");
INSERT INTO bdv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ତୁମିମଃନାର୍‌ ଜାୟ୍‌ରି ଆଚେ ସେରି ବିକିକଃରି କଃରି ଗଃରିବ୍‌ମଃନ୍‌କେ ଦାନ୍‌ କଃରା, ଜାୟ୍‌ରି ନଃସ୍ଟ୍‌ ନଃହୟ୍‌ ଅଃନ୍‌କାର୍‌ ମଣା ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗିନେ ତିଆର୍‌ କଃରା, କୁୟ୍‌ତି ଚର୍‌ ଚଃମେ ନାସେ ଆର୍‌ ଅଳ୍‌ମା ନଃସ୍ଟ୍‌ ନଃକେରେ ଅଃନ୍‌କାର୍‌ ସଃର୍ଗେ ନଃସ୍ଟ୍‌ ନଃଉତା ଦଃନ୍ ଅଃର୍ଜା; ");
INSERT INTO bdv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ତି ତୁମାର୍‌ ଦଃନ୍‌, ସେତି ତୁମାର୍‌ ମଃନ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ତୁମିମଃନ୍‌ ଅଃଟାବିଳା ବାନ୍ଦି ଅୟ୍‌ରିଆ, ଆର୍‌ କୁପି କଃଚ୍‌ତି ରେଅ, ");
INSERT INTO bdv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଆର୍‌ ମାପ୍ରୁ ବିବା ବଜି ତଃୟ୍‌ହୁଣି ବାଉଳି ଆସି କଃହାଟେ ମାର୍ଲା ଦାହ୍ରେ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଗିନେ ତଃତ୍‌କାଣ୍ କଃହାଟ୍‌ ଉଗାଳୁକ୍‌ ଜାଗି ରେତି, ତୁମିମଃନ୍ ସେମଃନାର୍‌ ହର୍‌ ଅୟ୍‌ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ମାପ୍ରୁ ଆସି ଜୁୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଜଃଗ୍ରାତ୍‌ ରିଲାର୍‌ ଦଃକେଦ୍‌, ସେମଃନାର୍‌ ବାୟ୍‌ଗ୍‌, ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସେ ଅଃହ୍‌ଣାର୍‌ ଅଃଟା ବାନ୍ଦି କଃରି ସେମଃନ୍‌କେ କାଉଁକେ ବଃସାୟ୍‌, ଚଃମେ ଜାୟ୍‌ ସେବା କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆର୍‌ ସେ ଜଦି ମଃଜାରାତି କି କୁକ୍‌ଳାବାସେ ହେଁ ଆସି ସେମଃନ୍‌କେ ସେନ୍‌କାର୍‌ ଦଃକେଦ୍‌, ତଃବେ ସେ ଦଃଙ୍ଗ୍‌ଳା ମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମଃତର୍‌ ଇରି ଜାଣିରିଆ କୁୟ୍‌ ବେଳାୟ୍‌ ଚର୍‌ ଆସେଦ୍‌ ଇରି ଗଃରାର୍‌ ସାଉକାର୍‌ ଜାଣି ରିଲେକ୍‌, ତାର୍‌ ଗଃରେ ସିନ୍ଦ୍ ମାରୁକ୍‌ ନଃଦିଲା ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ତୁମିମଃନ୍ ହେଁ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ବେଳାୟ୍‌ ତୁମିମଃନ୍ ମଃନେ କଃରି ନଃରିଆସ୍‌ ସେ ବେଳାୟ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ସେତାକ୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ ତୁୟ୍‌ ଅଃମିମଃନ୍‌କ୍‌ ହଃକା ଇ କଃତା କଃଉଁଲିସ୍‌, କି ସଃବୁ ଲକ୍‌କେ କଃଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ଜିସୁ ମାପ୍ରୁ ଉତୁର୍‌ ଦିଲା, “ଇତାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃରାର୍‌ ଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କେ ସଃମାନ୍ ବେଳାୟ୍‌ ଟିକ୍‌ ଅୟ୍‌ରିଲା ହଃଳିବାତ୍ୟା ଦେଉଁକେ ସାଉକାର୍‌ ଜାକେ ସେମଃନାର୍‌ ଉହ୍ରେ ବାଚେଦ୍‌, ଇବାନ୍ୟା ସଃତ୍‌ ବୁଦିକାରି ଗୁମୁସ୍ତା କେ ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ସାଉକାର୍‌ ଆସି ତାର୍‌ ଜୁୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ସେରଃକମ୍‌ କାମ୍‌ କଃର୍ତି ରିଲାର୍‌ ଦଃକେଦ୍‌, ତଃବେ ସେ ଦଃଙ୍ଗ୍‌ଳାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ସାଉକାର୍‌ ସେ ଦଃଙ୍ଗ୍‌ଳାକେ ତାର୍‌ ସଃବୁ ସଃମ୍ପତି ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ମଃତର୍‌ ଜଦି ସେ ଗୁମୁସ୍ତା ମର୍‌ ସାଉକାର୍‌ ଆସ୍ତାର୍‌ ବିଲମ୍‌ ଆଚେ ବଃଲି ମଃନେ ମଃନେ କୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଦଃଙ୍ଗ୍‌ଳିମଃନ୍‌କେ ମାରୁକ୍‌ ଆର୍‌ କାଉଆ ହିଉଆ କଃରି ମାତୁକ୍‌ ମୁଳ୍ୟାୟ୍‌ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳା ଜୁୟ୍‌ ଦିନ୍ ଜାଗି ନଃରେୟ୍‌ ଆର୍‌ ଜୁୟ୍‌ ବେଳା ସେ ଜାଣି ନଃରେୟ୍‌, ସେଦିନ୍ ଆର୍‌ ସେ ବେଳାୟ୍‌ ତାର୍‌ ସାଉକାର୍‌ ଆସେଦ୍‌, ସାଉକାର୍‌ ତାକ୍‌ ଜଃବର୍‌ ଡଃଣ୍ଡ୍‌ ଦଃୟ୍‌, ହଟ୍‌କାର୍‌ ଲକାର୍‌ ସଃଙ୍ଗ୍ ତାର୍‌ ବାଗ୍ ସଃମାନ୍ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ଆର୍‌ ଜୁୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଅଃହ୍‌ଣାର୍‌ ସାଉକାରାର୍‌ ମଃନ୍ ଜାଣି ତିଆର୍‌ ଅୟ୍‌ ନଃରେୟ୍‌, କି ତାର୍‌ ମଃନ୍‌କେ ଗଃଲା ହର୍‌ କାମ୍‌ କଃରି ନଃରେୟ୍‌, ସେ ଜଃବର୍‌ ମାଡ୍‌କାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମଃତର୍‌ ଜେ ନଃଜାଣି ମାଡ୍‌ କାତା ହାୟ୍‌ଟି କଃରି ରଃୟ୍‌ଦ୍‌ ସେ ଅଃଳକ୍‌ ମାଡ୍ କାୟ୍‌ଦ୍‌, ଜାକେ ବୁତେକ୍‌ ଦିଆ ଅୟ୍‌ଆଚେ ତାର୍‌ ତଃୟ୍‌ହୁଣି ବୁତେକ୍‌ ମାଗା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଲକ୍‌ମଃନ୍ ଜାକେ ବୁତେକ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ତି ତାର୍‌ ତଃୟ୍‌ହୁଣି ବୁତେକ୍‌ ମାଗ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ମୁଁୟ୍‌ ହୁର୍ତିବିଏ ଜୟ୍‌ ଲାଗାଉଁକେ ଆସି ଆଚି, ସେରି ଜଦି ଲାଗ୍‌ଲିନି, ତଃବେ ମର୍‌ ଆର୍‌ କାୟ୍‌ ମଃନ୍ ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମଃତର୍‌ ମକ୍‌ ଗଟେକ୍‌ ବାପ୍ତିସମେ ବାପ୍ତିସମ୍‌ ନେଉଁକେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ସେରି ନଃଉତା ହଃତେକ୍‌ ମୁଁୟ୍‌ କଃନ୍‌କଃରି କଃସ୍ଟ୍‌ ହାଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ମୁଁୟ୍‌ ହୁର୍ତିବିଏ ସୁସ୍ତା ଦେଉଁକେ ଆସି ଆଚି ବଃଲି କାୟ୍‌ ତୁମିମଃନ୍ ମଃନେ କଃରୁଲାସ୍‌ ? ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ନାୟ୍‌, ମଃତର୍‌ ବେଗଳ୍‌ କଃରୁକେ ଆସିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଆଜି ହଃତେକ୍‌ ଗଟେ ଗଃରେ ହାଁଚ୍ ଲକ୍‌ ରିଲେକ୍‌ ଦୁୟ୍‌ଲକ୍‌ ବିରଦେ ତିନିଲକ୍‌, ଆର୍‌ ତିନିଲକ୍‌ ବିରଦେ ଦୁୟ୍‌ଲକ୍‌ ବିନ୍ ବିନ୍ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ହୟ୍‌ସି ବିରଦେ ଉବାସି, ଉବାସିର୍‌ ବିରଦେ ହୟ୍‌ସି, ଜିସି ବିରଦେ ଆୟ୍‌ସି, ଆୟ୍‌ସି ବିରଦେ ଜିସି, ବୁଆରି ବିରଦେ ସଃତୁର୍ସି, ସଃତୁର୍ସି ବିରଦେ ବୁଆର୍ସି ବିନ୍ ବିନ୍ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଆରେକ୍‌ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ହେଁ କୟ୍‌ଲା, “ବୁଡ୍‌ତି ଦିଗ୍ ବାଟ୍ୟା ମେଗ୍ ଉଟ୍‌ତାର୍‌ ଦଃକ୍‌ଲେକ୍‌, ସେଦାହ୍ରେ ତୁମିମଃନ୍ କଃଉଆସ୍‌, ବଃର୍ସା ମାରେଦ୍‌ ଆର୍‌ ସେବାନ୍ୟା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଆରେକ୍‌ ଦଃକିଣ୍ ଦିଗ୍ ବାଟ୍ୟା ବାଉ ଅଃଉତାର୍‌ ଦଃକ୍‌ଲେକ୍‌, ତୁମିମଃନ୍ କଃଉଆସ୍‌, ବଃଡେ କଃରା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ସେବାନ୍ୟା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ରେ ହେଟ୍‌କପଟ୍ୟା, ତୁମିମଃନ୍ ହୁର୍ତିବି ଆର୍‌ ଅଃଗାସ୍‌ ଉହ୍ରେ ଚିନ୍ ସଃବୁ ଦଃକି ବୁଜୁ ହାରୁଲାସ୍‌, ମଃତର୍‌ ଇ କାଳାର୍‌ ଚିନ୍ ସଃବୁ କଃନ୍‌କଃରି ବୁଜୁ ନଃହାରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ଆର୍‌ ତୁମିମଃନ୍ ନିଜେ ନିଜେ କାୟ୍‌ତାକ୍‌ ଟିକ୍‌ ବିଚାର୍‌ ନଃକେରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ବିରଦି ସଃଙ୍ଗ୍ ବିଚାର୍‌ କଃର୍ତା ଅଃଦିକାରି ଚଃମେ ଜାତା ବଃଳ୍‌, ବାଟେ ତାର୍‌ ତଃୟ୍‌ହୁଣି ମୁକ୍ତ୍ ଅଃଉଁକେ ରାଜିରାମା ଅଃଉଆ, ଚଃନେମଃନେ ସେ ତୁମିକେ ସେ ବିଚାର୍‌ କଃର୍ତା ଅଃଦିକାରି ହାକ୍‌ ଜିକି ନଃୟ୍‌ଦ୍‌, ଆରେକ୍‌ ବିଚାର୍‌ କଃର୍ତା ଅଃଦିକାରି ତୁମିକେ ସଃଇନ୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌ ଆର୍‌ ସଃଇନ୍‌ମଃନ୍‌ ତୁମିକେ ଜଃଇଲେ ହୁରାଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ମୁଁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମି ସଃରା ସଃରି ଗଟେକ୍‌ କାସୁ ହେଁ ନଃସୁଜ୍‌ତା ହଃତେକ୍‌ ସେ ଜଃଗାୟ୍‌ ହୁଣି କଃନ୍‌କଃରି ହେଁ ମୁକ୍‌ଳି ଆସୁ ନଃହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ସଃଡେବଃଳ୍‌ ସେତି ରିଲା କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ଆସି, ପିଲାତ ଜୁୟ୍‌ ଗାଲିଲିୟମଃନାର୍‌ ବଃନି ସେମଃନାର୍‌ ହୁଜା ସଃଙ୍ଗ୍ ମିସାୟ୍‌ ରିଲା, ସେମଃନାର୍‌ କଃତା ଜିସୁକେ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇସଃବୁ ଗଃଟ୍‌ଲାକ୍‌ ଇ ଗାଲିଲିୟ୍‌ମଃନ୍‌ ବିନ୍ ସଃବୁ ଗାଲିଲିୟମଃନାର୍‌ ତଃୟହୁଣି ଅଃଦିକ୍‌ ହାହି ବଃଲି କି ତୁମିମଃନ୍ ମଃନେ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ନାୟ୍‌ ସେମଃନ୍ ସେନ୍‌କାର୍‌ ନଃରିଲାୟ୍‌, ମଃତର୍‌ ହାହେହୁଣି ମଃନ୍‌ ନଃବାଦ୍‌ଲାୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ସଃବୁଲକ୍‌ ସେରଃକମ୍‌ ନାସ୍‌ ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ସିଲହ ତଃୟ୍‌ ସେ ଜୁୟ୍‌ ଅଃଟ୍ର ଲକାର୍‌ ଉହ୍ରେ ଜାଗ୍‌ତା ଗଃର୍‌ ଚଃହ୍‌ଳାୟ୍‌ ସେମଃନାର୍‌ ଜିବନ୍ ନିଲି, ସେମଃନାର୍‌ ବିସୟେ ତୁମି କାୟ୍‌ରି ବାବୁଲାସ୍‌ ? ସେମଃନ୍ ସଃବୁ ଜିରୁସାଲମାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ହାହି ବଃଲି ତୁମିମଃନ୍ ମଃନେ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ମୁଁୟ୍‌ ମଃତର୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ହାହେହୁଣି ମଃନ୍‌ ନଃବାଦ୍‌ଲାୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ହେଁ ସେବାନ୍ୟା ନଃସ୍ଟ୍‌ ଅଃଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆରେକ୍‌ ଜିସୁ ଇ କଃତା ହେଁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଟ୍‌ ଲକାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ ଗଟ୍‌ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ ଲାଗାୟ୍‌ରିଲା । ସାଉକାର୍‌ ଆସିକଃରି ଡୁମ୍ବୁର୍‌ ଗଃଚେ ହଃଳ୍‌ ଲଳ୍‌ଲା, ମଃତର୍‌ ସେ ହାଉଁ ନଃହାର୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ସେତାର୍‌ଗିନେ ସେମାନାୟ୍‌ ତାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଳେ କାମ୍‌ କଃର୍ତା ମାନାୟ୍‌କେ କୟ୍‌ଲା, ‘ଦଃକ୍‌ ତିନି ବଃର୍ସ୍‌ ଅୟ୍‌ଲିବେ ମୁୟ୍‌ଁ ଆସି ଇ ଡୁମ୍ବୁର୍‌ ଗଃଚେ ହଃଳ୍‌ ଲଳୁଲେ, ମଃତର୍‌ ହାଉଁ ନଃହାରୁଲେ; ଇ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍‌କେ ମାରିହଃକାଉ, ଇରି କାୟ୍‌ତାକ୍‌ ବୁୟ୍‌ଁକ୍‌ ନଃସ୍ଟ୍‌ କଃରୁଲି ?’ ");
INSERT INTO bdv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମଃତର୍‌ ସେ ସାଉକାର୍‌କେ କୟ୍‌ଲା, ‘ସାଉକାର୍‌, ଆକ୍‌ ଇ ବଃର୍ସ୍‌ ହେଁ ଚାଡିଦେସ୍‌, ମୁଁୟ୍‌ ଇ ଗଃଚାର୍‌ ଚାରି ହାକ୍‌ କଃଣିକଃରି କାତ୍‌ ଦଃୟ୍‌ନ୍ଦ୍, ");
INSERT INTO bdv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ଆର୍‌ ଜଦି ଇ ଗଃଚେ ହଃଳ୍‌ ହଃଳ୍‌ଲେକ୍‌ ବଃଲ୍‌ କଃତା, ମଃତର୍‌ ଜଦି ହଃଳ୍‌ ନଃହେଳେ ତଃବେ ତୁୟ୍‌ ଇ ଗଃଚ୍‌କେ ମାରିହଃକାଉ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ଗଟ୍‌ତର୍‌ ଜିସୁ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଗଟେକ୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ସିକ୍ୟା ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଆର୍‌ ଦଃକା ସେତି ଗଟେକ୍‌ ଦୁସ୍ଟ୍‌ ଆତ୍ମା ଡଃସିରିଲା ମାୟ୍‌ଜି ରିଲି, ସେ ଅଃଟ୍ର ବଃର୍ସ୍‌ ହଃତେକ୍‌ କୁବ୍‌ଳି ଅୟ୍‌ରିଲି, ସେ ସଃଳ୍‌କେ ଅୟ୍‌ ଟିଆ ଅଃଉଁକେ ନଃହାର୍‌ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ତାକ୍‌ ଦଃକି ଲଃଗେ କୁଦି କୟ୍‌ଲା, “ଏ ଆୟା, ତୁୟ୍‌ ନିକ ଅୟ୍‌ଲିସ୍‌ !” ");
INSERT INTO bdv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଆର୍‌ ଜିସୁ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲା, ଆର୍‌ ସେଦାହ୍ରେ ସେ ସଃଳ୍‌କ୍‌ ଅୟ୍‌ ଟିଆ ଅୟ୍‌ଲି, ଆର୍‌ ସେ ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ଗାଉଁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ମଃତର୍‌ ଜିସୁ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଉଜ୍‌ କଃଲାକ୍‌ ପାର୍ତ୍‌ନାଗଃରାର୍‌ ମୁଳିକା ରିସା ଅୟ୍‌କଃରି ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “କାମ୍‌ କଃରୁକେ ଚଅ ଦିନ୍ ଆଚେ, ତଃବେ ସେସଃବୁ ଦିନ୍ ଆସିକଃରି ନିକ ଅଃଉଆ, ମଃତର୍‌ ବିସାଉଣିବାରେ ନିକ ଅଃଉଁକେ ଆସା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ମଃତର୍‌ ମାପ୍ରୁ ତାକେ କୟ୍‌ଲା, “ରେ ହେଟ୍‌କପଟ୍ୟା, ତୁମିମଃନ୍ ସଃବୁଲକ୍‌ କାୟ୍‌ରି ବିସାଉଁଣି ଦିନ୍ ତୁମାର୍‌ ବଃଇଲ୍‌ କି ଗଃଦ ସାଳେହୁଣି ମେଲି ନଃୟ୍‌ କାୟ୍‌ ହାଣି ନଃକାଳାଉଆସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ତଃବେ ଦଃକା ଅଃଟ୍ର ବଃର୍ସ୍‌ ହଃତେକ୍‌ ସୟ୍‌ତାନ୍‌ ତଃୟ୍‌ହୁଣି କୁବ୍‌ଳି ଅୟ୍‌ରିଲି ଅବ୍ରାହାମାର୍‌ ବଃଉଁସାର୍‌ ଇ ମାୟ୍‌ଜିଟକି କାୟ୍‌ ବିସାଉଁଣିବାରେ ନିଜାର୍‌ ବାନ୍ଦୁଣ୍‌ ତଃୟ୍‌ହୁଣି ମୁକୁଳ୍‌ତାର୍‌ ଦଃର୍‌କାର୍‌ ନଃରିଲି ?” ");
INSERT INTO bdv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଆର୍‌ ଜିସୁ ଇ କଃତାସଃବୁ କୟ୍‌ଲାକ୍‌, ତାର୍‌ ବିରଦିସଃବୁ ଲାଜ୍‌ ହାୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ଦା ସେ କଃରିରିଲା ସଃବୁ କାବା କାମ୍‌ ଗିନେ ସଃର୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ କାର୍‌ ହର୍‌ ? ଆରେକ୍‌ କାର୍‌ ସଃଙ୍ଗ୍ ମୁଁୟ୍‌ ତାର୍‌ ତୁଳ୍‌ନା କଃରିନ୍ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ସେରି ଇବାନ୍ୟା ଗଟେକ୍‌ ସଃର୍ସୁ ମୁଞ୍ଜି ହର୍‌, ଜୁୟ୍‌ରି ନଃୟ୍‌ ଗଟ୍‌ଲକ୍‌ ତାର୍‌ ବାଳେ ବୁଣ୍‌ଲା, ଆର୍‌ ସେରି ବାଡି କଃରି ଗଃଚ୍ ଅୟ୍‌ଲି, ଆର୍‌ ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ଚେଳେମଃନ୍ ଆସି ତାର୍‌ ଡାଳ୍‌ବିତ୍ରେ ଗୁଡା ଗାଲ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌କେ ମୁଁୟ୍‌ କାର୍‌ ସଃଙ୍ଗ୍ ତୁଳ୍‌ନା କଃରିନ୍ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ସେରି ଗଟେକ୍‌ କମିର୍‌ ହର୍‌, ଗଟେକ୍‌ ମାୟ୍‌ଜି ସେରି ନଃୟ୍‌କଃରି ମାଣେକ୍‌ ଗମ୍‌ଗୁଣ୍ଡ୍‌ ସଃଙ୍ଗ୍ ମିସାୟ୍‌ କଃରି ଚଃଟ୍‌କ୍‌ଲି, ଆର୍‌ ତାର୍‌ହଃଚେ ସେ ସଃବୁ କମିର୍‌ ହର୍‌ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଜିସୁ ଜିରୁସାଲମେ ଜାତିରିଲା ବଃଳ୍‌ ସେ ଗଃଳେ ଗଃଳେ ଆର୍‌ ଗାଉଁଏ ଗାଉଁଏ ବୁଲି କଃରି ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଗଟ୍‌ ଲକ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ମାପ୍ରୁ, ହାହେହୁଣି ମୁକ୍ତି ହାଉତା ଲକ୍‌ମଃନ୍ କାୟ୍‌ ଅଃଳକ୍‌ ?” ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ସାକୁଳ୍‌ ଦୁଆର୍‌ ଦଃୟ୍‌ ଜଃଉଁକେ ହାରୁ ସଃକାତ୍‌ ଉପାୟ୍‌ କଃରା, ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ମାପ୍ରୁର୍‌ ରାଇଜେ ଜଃଉଁକେ ହାରୁ ସଃକାତ୍‌ ଉପାୟ୍‌ କଃର୍ତି, ମଃତର୍‌ ଜଃଉଁକେ ନାହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଗଃରାର୍‌ ମୁଳିକା ଉଟି ଦୁଆର୍‌ ଡାହ୍‌ଲା ହଃଚେ, ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ହଃଦାୟ୍‌ ଟିଆ ଅୟ୍‌ରିଆସ୍‌ ଆର୍‌ ଏ ମାପ୍ରୁ ଅଃମାର୍‌ ଗିନେ କାହାଟ୍‌ ଉଗାଳ୍‌, ଇରି କୟ୍‌ କଃହାଟେ ମାରୁକେ ଦଃରାସ୍‌, ସଃଡେବଃଳ୍‌ ସେ ତୁମିକେ କୟ୍‌ଦ୍‌, ତୁମିମଃନ୍ କୁୟ୍‌ତିର୍‌ ଲକ୍‌, ସେରି ମୁୟ୍‌ଁ ନଃଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ କଃଉଁକେ ଦଃରାସ୍‌ ଅଃମିମଃନ୍‌ ତର୍‌ ସଃଙ୍ଗ୍ ଗଟେ ଟାଣେ କାୟ୍‌ଲୁ ଆଚୁ, ଆର୍‌ ତୁୟ୍‌ ଅଃମାର୍‌ ଡଃଣ୍ଡେ ବାଟେ ସିକ୍ୟା ଦଃୟ୍‌ରିଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ମଃତର୍‌ ସେ ତୁମିକେ କୟ୍‌ଦ୍‌, ତୁମିମଃନ୍ କୁୟ୍‌ତିର୍‌ ଲକ୍‌ ସେରି ମୁଁୟ୍‌ ନଃଜାଣି, ରେ ଅଃଦଃର୍ମିମଃନ୍‌ ସଃବୁ ମର୍‌ ମୁଏଁହୁଣି ଦୁର୍‌ ଅଃଉଆ । ");
INSERT INTO bdv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ଅବ୍ରାହାମ୍‌, ଇସାକ୍‌, ଜାକୁବକ୍‌ ଆର୍‌ ବିନ୍ ସଃବୁ ବାବ୍‌ବାଦିମଃନ୍‌କେ ଇସ୍ୱରାର୍‌ ରାଇଜେ ରିଲାର୍‌ ଦଃକାସ୍‌ ଆର୍‌ ନିଜ୍‌ ନିଜ୍‌କେ ହଃଦାୟ୍‌ ହଃକାଉତାର୍‌ ଦଃକାସ୍‌, ସଃଡେବଃଳ୍‌ ସେତି ତୁମିମଃନ୍ କାନ୍ଦାସ୍‌ ଆର୍‌ ଦାତ୍‌ ଚାବି ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଆରେକ୍‌ ଉଦ୍‌ତି ଆର୍‌ ବୁଡ୍‌ତି, ଉତୁର୍‌ ଆର୍‌ ଦଃକିଣ୍‌ବାଟ୍ୟାର୍‌ ଲକ୍‌ମଃନ୍ ଆସି ମାପ୍ରୁର୍‌ ରାଇଜେ କାଉଁକେ ବଃସ୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆର୍‌ ଦଃକା, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଅଃବେ ହଃଚେ ଆଚ୍‌ତି ସେମଃନ୍ ଆଗାଳି ଅଃଉତି ଆର୍‌ ଆଗାଳି ରିଲା ଲକ୍‌ମଃନ୍ ହଃଚେ ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ସଃଡେବଃଳ୍‌ କଃତେକ୍‌ ପାରୁସିମଃନ୍ ଆସି ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ଇ ଟାଣ୍ ଚାଡିକଃରି ବାରାୟ୍‌ଜାଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହେରଦ୍‌ ତକେ ମଃର୍ଣ୍ଣେ ମାରୁକ୍‌ ମଃନ୍ କଃରୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାୟ୍‌ ସେ କଲ୍ୟାକ୍‌ କଃଉଆ, ଦଃକା ମୁଁୟ୍‌ ଆଜି ଆର୍‌ କାଲି ବୁତ୍‌ ଚାଡାଉଁଲେ ଆର୍‌ ରଗିମଃନ୍‌କେ ନିକା କଃରୁଲେ, ଆର୍‌ ତିନି ଦିନ୍‌କେ ମର୍‌ କାମ୍‌ ହୁରା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ଜଃନ୍‌ଅଃଅ, ଆଜି, କାଲି ଆର୍‌ ହଃରିଦିନ୍‌ ମକ୍‌ ଜଃଉଁକେ ହଃଳେଦ୍‌, ବଃଲେକ୍‌ ଜିରୁସାଲମ୍‌ ଗଃଳାର୍‌ ହଃଦାୟ୍‌ ବାବ୍‌ବାଦି ମଃର୍ତା କଃତା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ଏ ଜିରୁସାଲମ୍‌, ଏ ଜିରୁସାଲମ୍‌, ବାବ୍‌ବାଦିମଃନ୍‌କେ ମଃର୍ଣ୍ଣେ ମାରି ରିଲା ଜିରୁସାଲମ୍‌ ଆର୍‌ ମାପ୍ରୁ ହଃଟାୟ୍‌ ରିଲା ଲକ୍‌ମଃନ୍‌କେ ଟେଳା ଚେଚି ମଃର୍ଣ୍ଣେ ମାରି ରିଲା ଜିରୁସାଲମ୍‌, ମାୟ୍‌କୁକ୍‍ଡ଼ା ଜଃନ୍‌କଃରି ଡେଣା ତଃଳେ ତାର୍‌ ହିଲାମଃନ୍‌କେ ରୁଣ୍ଡାୟ୍‌ଦ୍‌, ସେବାନ୍ୟା ମୁଁୟ୍‌ କଃତେକ୍‌ ତର୍‌, ତର୍‌ ହିଲାମଃନ୍‌କେ ଗଟେ ଟାଣେ କଃରୁକେ ମଃନ୍ କଃଲେ, ମଃତର୍‌ ତୁମିମଃନ୍ ମଃନ୍‌ ନଃକେଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ଦଃକା, ତୁମାର୍‌ ଗଃର୍‌ ତୁମିମଃନାର୍‌ ଆତେ ଚାଡିଦିଆ ଅଃଉଁଲି; ଆର୍‌ ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ‘ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜେ ଆସୁଲା, ସେ ବାୟ୍‌ଗ୍‌, ତୁମିମଃନ୍ ଜୁୟ୍‌ ଦିନ୍ ଇ କଃତା କଃଉଆସ୍‌, ସେଦିନ୍ ନାଆସ୍ତା ହଃତେକ୍‌ ମକ୍‌ ତୁମିମଃନ୍ ଆରେକ୍‌ ନଃଦେକାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ଗଟ୍‌ତର୍‌ ଜିସୁ ବିସାଉଁଣିବାର୍‌ ଦିନ୍, ପାରୁସିମଃନାର୍‌ ଗଟେକ୍‌ ମୁଳିକାର୍‌ ଗଃରେ ବଜି କାଉଁକେ ଗଃଲା, ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃକି ଲାଗ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ଆର୍‌ ଦଃକା, ସେତି ଜିସୁର୍‌ ମୁଏଁ ହୁଲା ବେମାରେ ହଃଳି ରିଲା ଗଟେକ୍‌ ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ଜିସୁ ପାରୁସି ଆର୍‌ ଦଃର୍ମ୍‌ସାସ୍ତ୍ରିମଃନ୍‌କେ ହଃଚାର୍ଲା “ବିସାଉଁଣିବାରେ ରଗିକ୍‌ ଉଜ୍‌ କଃରୁକେ ବିଦି ଆଚେ କି ନାୟ୍‌ ?” ମଃତର୍‌ ସେମଃନ୍ ଚିମ୍‌ରା ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଆରେକ୍‌ ଜିସୁ ତାକ୍‌ ଚୁୟ୍‌କଃରି ଉଜ୍‌ କଃଲା, ଆର୍‌ ତାର୍‌ ଗଃରେ ହଃଟାୟ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ବିତ୍ରେ କେ ନିଜାର୍‌ ହିଲା କି ବଃଇଲ୍‌ କୁଇଁକାଲେ ଅଦୁର୍ଲେକ୍‌ କାୟ୍‌ରି ତାକେ ବିସାଉଁଣିବାରେ ତଃତ୍‌କାଣ୍ ଉଟାଉଁ ନଃଚାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଆର୍‌ ସେମଃନ୍ ଜିସୁକେ ଇସଃବୁ କଃତାର୍‌ ଉତୁର୍‌ ଦେଉଁ ନଃହାର୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଆରେକ୍‌ ବଜି କାଉଁକେ ଆୟ୍‌ଲା ଲକ୍‌ମଃନ୍ କଃନ୍‌କଃରି ନିଜାର୍‌ ଗିନେ ବଃଡ୍ ଟାଣ୍ ବାଚ୍‌ତି ରିଲାୟ୍‌, ଇରି ଦଃକିକଃରି ଜିସୁ ସେମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଜଃବେ ତୁମିକେ କୁୟ୍‌ ଲକ୍‌ ତାର୍‌ ବିବା ବଜିକେ କୁଦେଦ୍‌, ତଃବେ ସଃଡେବଃଳ୍‌ ତୁମି ସେତି ଜାୟ୍‌ ବଃଡ୍ ଲକ୍‌ ବଃସ୍ତା ଟାଣେ ବଃସା ନାୟ୍‌, କଃଡେବଃଳ୍‌ ସିନା ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ମାନ୍‌ତି ହାଉତା ଲକ୍‌କେ ସେ କୁଦି ରଃୟ୍‌ଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଆର୍‌ ଜେ ତୁମିକେ ଆର୍‌ ସେ ମାନ୍‌ତି ହାଉତା ଲକ୍‌କେ କୁଦି ରଃୟ୍‌ଦ୍‌, ସେ ଆସିକଃରି ତୁମିକେ କୟ୍‌ଦ୍‌, ତୁୟ୍‌ ସେତିହୁଣି ଉଟ୍‌ ଇ ବଃଡ୍ ଲକେ ଟାଣ୍ ଦେସ୍‌; ସଃଡେବଃଳ୍‌ ତୁମି ଲାଜ୍‌ ହାୟ୍‌, ତଃଳେ ଜାୟ୍‌ ବଃସାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ତୁମି ବିବା ବଜିକେ ଜାହାସ୍‌, ସଃଡେବଃଳ୍‌ ତୁମି ଜାୟ୍‌ ତଃଳେ ବଃସା, ଜଃନ୍‌କଃରିକି ତୁମିକେ କୁଦ୍‌ଲା ମାନାୟ୍‌ ଆସିକଃରି ତୁମିକେ ଦଃକି କୟ୍‌ଦ୍‌, ଏ ବାୟ୍‌, ଇ ବଃଡ୍ ଟାଣେ ଆସିକଃରି ବଃସ୍‌; ସଃଡେବଃଳ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ବଜିଗଃରେ ବଃସି ରିଲା ସଃବୁ ଲକାର୍‌ ମୁଏଁ ତୁମି ଜଃଜ୍‌ମାନ୍ ହାଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ନିଜ୍‌କେ ବଃଡ୍ ବଃଲି ଦଃକାୟ୍‌ ଅୟ୍‌ଦ୍‌, ତାକ୍‌ ସାନ୍ କଃରା ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଜେ ନିଜ୍‌କେ ସାନ୍ କଃରେଦ୍‌, ତାକ୍‌ ବଃଡ୍ କଃରା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଜିସୁ ତାକ୍‌ କାଉଁକେ କୁଦିରିଲା ମାନାୟ୍‌କେ କୟ୍‌ଲା, “ଦିନ୍‌ବଃଳ୍‌ କି ରାତିବଃଳ୍‌ ବଜି ଦିଲେକ୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃଙ୍ଗ୍ କି ବାୟ୍‌, କି ନିଜାର୍‌ଲକେ କି ହାକିହଃଳ୍‌ସାର୍‌ ମାଜନ୍‌ମଃନ୍‌କେ କୁଦା ନାୟ୍‌, ବଃଲେକ୍‌ ସେମଃନ୍ ହେଁ ଗଟ୍‌ ଦିନ୍ ତୁମିକେ ବଜି କାଉଁକେ କୁଦ୍‌ତି; ଆର୍‌ ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ବାଦ୍‌ଲା ହାଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ମଃତର୍‌ ତୁମି ବଜି ଦିଲେକ୍‌, ଇନସ୍ତାମଃନ୍‌କେ, କଲାମଃନ୍‌କେ, ଚଟାମଃନ୍‌କେ ଆର୍‌ କାଣାମଃନ୍‌କେ କୁଦା; ");
INSERT INTO bdv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ତଃବେ ତୁମି ମଃନ୍‌କାର୍‌ ବାୟ୍‌ଗ୍‌ ଅୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ତୁମିକେ ଲେଉଟାୟ୍‌ ଦେଉଁକେ ସେମଃନାର୍‌ ହାକ୍‌ କାୟ୍‌ରି ନାୟ୍‌ ଆର୍‌ ଜଃଡେବଃଳ୍‌ ଦଃର୍ମିଲକ୍‌ମଃନ୍ ଆରେକ୍‌ ଜିବନ୍ ହାୟ୍‌କଃରି ଉଟ୍‌ତି, ସଃଡେବଃଳ୍‌ ଇସ୍ୱର୍‌ ତୁମିକେ ଲେଉଟାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସିରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଲକ୍‌ ଇସଃବୁ କଃତା ସୁଣି, ଜିସୁକେ କୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ ମାପ୍ରୁର୍‌ ରାଇଜେ ବଜି କାଉଁକେ ବଃସେଦ୍‌ ତାର୍‌ ବାୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଗଟ୍‌ ଲକ୍‌ ଗଟ୍‌ତର୍‌ ରାତିବଃଳ୍ୟା ବଃଡ୍‌ବଜି ଦେଉଁକେ ମଃନ୍‌କଃରି ଗାଦେକ୍‌ ଲକେ କୁଦ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ବଜି ଦେତା ବେଳା ଅୟ୍‌ଲି, ସଃଡେବଃଳ୍‌ ସେ ବଜି କାଉଁକେ ଆସିରିଲା ଲକ୍‌ମଃନ୍‌କେ ବଜି କାଉଁକେ ଆସା ବଃଲି କୁଦୁକେ ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ମଃତର୍‌ ସେ କୁଦା ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ଅଃକାମାଡେ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ‘ଅଃମିମଃନ୍‌ ଆସୁ ନଃହାରୁ,’ ହଃର୍ତୁର୍‌ ମାନାୟ୍‌ କୟ୍‌ଲା, ‘ମୁଁୟ୍‌ ଅଃବେ ବେଡା କଃଣ୍ଡେକ୍‌ ଗେନ୍‌ଲେ ଆଚି, ମକ୍‌ ସେରି ଦଃକୁକ୍‌ ହଃଳେଦ୍‌; ସେତାର୍‌ଗିନେ ମୁଁୟ୍‌ ଆସୁ ନଃହାରି, ମକ୍‌ କେମା କଃର୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଆରେକ୍‌ ଏକ୍ଲା ଗଃଉଆରି କଃଲା, ମୁଁୟ୍‌ ହାଁଚ୍ ଅଃଳ୍‌ ବଃଇଲ୍‌ ଗେନିଆଚି, ଆର୍‌ ମୁୟ୍‌ଁ ଅଃବେ ସେମଃନ୍‌କେ ସିକ୍‌ଲାର୍‌ କି ନଃସିକ୍‌ଲାର୍‌ ଜାଣୁକେ ଜଃଉଁଲେ; ସେତାର୍‌ଗିନେ ମୁଁୟ୍‌ ଆସୁ ନଃହାରି, ମୁଁୟ୍‌ କେମା ହାୟ୍‌ ଆଚି ବଃଲି ମଃନେ କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ବିନ୍ ମାନାୟ୍‌ କୟ୍‌ଲା, ମୁଁୟ୍‌ ନଃଉଆଁ କଃରି ବିବା ଅୟ୍‌ ଆଚି, ସେତାର୍‌ଗିନେ ମୁଁୟ୍‌ ଆସୁ ନଃହାରି ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ତଃବେ ସେ ଦଃଙ୍ଗ୍‌ଳା ବାଉଳି ଆସିକଃରି ତାର୍‌ ସାଉକାର୍‌ କେ ସେସଃବୁ କଃତା ଜାଣାୟ୍‌ଲା । ସେତାକ୍‌ ସାଉକାର୍‌ ବଃଡେ ରିସା ଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ବେଗି ଜାୟ୍‌କଃରି ଗଃଳାର୍‌ ଡଃଣ୍ଡ୍‌ ଆର୍‌ କଲିବିଲି ଜାୟ୍‌ ଗଃରିବ୍‌, କଃଲା, କାଣା ଆର୍‌ ଚଟାମଃନ୍‌କେ ଇତି କୁଦିଆଣ୍ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ହଃଚେ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳା କୟ୍‌ଲା, ଏ ସାଉକାର୍‌ ତର୍‌ ବଲ୍‌ ହଃର୍କାରେ କଃରାଜାୟ୍‌ ଆଚେ; ଅୟ୍‌ଲେକ୍‌ ହେଁ ଆରେକ୍‌ ଗାଦା ଲକାର୍‌ ଗିନେ ଟାଣ୍ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ତଃବେ ସାଉକାର୍‌ ସେ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ କୟ୍‌ଲା, ‘ରଃଜାର୍‌ ରଃସ୍ତାବାଟେ ଆର୍‌ ସାଉଳିମଃନ୍‌କେ ଜାୟ୍‌, ମର୍‌ ଗଃର୍‌ ଜଃନ୍‌କଃରି ବଃର୍ତି ଅୟ୍‌ଦ୍‌, ସେତାକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଆସୁକ୍‌ କଃଉ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ମୁୟ୍‌ଁ ତୁମିକେ କଃଉଁଲେ, ସେ କୁଦାୟ୍‌ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍‌କାର୍‌ ବିତ୍ରେ କେହେଁ ମର୍‌ ବଜିର୍‌ ସୁଆଦ୍‌ ଚାକୁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଗଟ୍‌ତର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ଦା ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ଜାତି ରିଲାୟ୍‌, ଜିସୁ ସେମଃନ୍‌କେ ଦଃକି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ଜଦି କେ ମର୍‌ ହାକ୍‌ ଆସିକଃରି ଅଃହ୍‌ଣାର୍‌ ଉବାକ୍‌, ଆୟାକ୍‌, ଡକୁର୍ସିକେ, ହିଲାମଃନ୍‌କ୍‌, ବାୟ୍‌କ୍‌ ଆର୍‌ ବେଣିମଃନ୍‌କେ; ଆର୍‌ ତାର୍‌ ନିଜାର୍‌ ଜିବନ୍‌କେ ହେଁ ମର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ତଃବେ ସେ ମର୍‌ ଚେଲା ଅଃଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ କ୍ରୁସ୍‌ ବୟ୍‌ କଃରି ମର୍‌ ହଃଚେ ନିଣ୍ଡେ, ସେ ମର୍‌ ଚେଲା ଅଃଉଁ ନଃହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“ତୁମାର୍‌ ବିତ୍ରେ କେ ଜାଗୁଆଳି ଗଃର୍‌ ବାନ୍ଦ୍‌ତା ଗିନେ ଇଚା କଃରି, ସେରି ବାନ୍ଦି ସଃରାଉଁକ୍‌, ତାର୍‌ ହାକ୍‌ ଡାବୁ ଆଚେ କି ନାୟ୍‌, ଇରି ଆଗ୍‌ତୁ ବଃସିକଃରି କଃତେକ୍‌ ସଃରେଦ୍‌, ସେରି କାୟ୍‌ ଇସାବ୍‌ ନଃକେରେ ? ");
INSERT INTO bdv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ଜଦି ସେ କୁନାଦି କଃଣି ଗଃର୍‌ବାନ୍ଦି ସଃରାଉଁକ୍‌ ନାହାର୍ଲା, ତଃବେ ଜଃତେକ୍‌ ଲକ୍‌ ସେରି ଦଃକ୍‌ତି, ସଃବୁଲକ୍‌ ତାକ୍‌ ଲାଜ୍‌ କଃରାୟ୍‌ କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଦଃକା ଇ ମାନାୟ୍‌ ଗଃର୍‌ ବାନ୍ଦୁକେ ଆରୁମ୍‌ କଃଲା, ମଃତର୍‌ ସଃରାଉଁକ୍‌ ନଃହାର୍ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“ଜଦି ଗଟ୍‌ ରଃଜା ବିନ୍ ଗଟେକ୍‌ ରଃଜା ସଃଙ୍ଗ୍ ଜୁଜ୍‌ କଃରୁକେ ଜାତିରିଲା ବଃଳ୍‌, କଳେ ଅଃଜାର୍‌ ସଃଇନ୍‌ ଦଃରି ତାର୍‌ ବିରଦେ ଜୁଜ୍‌ କଃରୁକେ ଆସ୍ତି ରିଲା ରଃଜାର୍‌ ସଃଙ୍ଗ୍ ଦଃସ୍‌ ଅଃଜାର୍‌ ସଃଇନ୍‌ ଦଃରିକଃରି ଜୁଜ୍‌ କଃରୁକେ ହାରେଦ୍‌ କି ନାୟ୍‌, ସେରି ଆଗ୍‌ତୁ ବଃସିକଃରି କାୟ୍‌ ବିଚାର୍‌ ନଃକେରେ ? ");
INSERT INTO bdv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଜଦି ସେ ତାର୍‌ ସଃଙ୍ଗ୍ ଜୁଜ୍‌ କଃରୁକେ ନଃହାରେ, ତଃବେ ସେ ବିନ୍ ରଃଜା ଦୁରିକ୍‌ ରିଲା ବଃଳ୍‌ କବୁର୍‌କାରିଆକେ ହଃଟାୟ୍‌ ବୁଜାମାନା ଅଃଉଁକେ ଗଃଉଆରି କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ସେରଃକମ୍‌, ତୁମାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଲକ୍‌ ନିଜାର୍‌ ସଃର୍ନେ ନଃଚାଡ୍‌ଲେକ୍‌, ସେ ମର୍‌ ଚେଲା ଅଃଉଁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ନଣ୍ ତ ସୁଆଦ୍‌; ମଃତର୍‌ ନଣ୍ ଜଦି ତାର୍‌ ସୁଆଦ୍‌ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ସେରି କାୟ୍‌ କଃରୁ ଅୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ସେରି ବୁୟ୍‌ଁ କି କାତ୍‌ ଗାଦାୟ୍‌ ହେଁ ଜୟ୍‌ଗ୍‌ ନୟ୍‌, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ସେରି ଉର୍କୁଳାୟ୍‌ ହଃକାଉତି । ଜାର୍‌ ସୁଣୁକ୍‌ କାନ୍‌ ଆଚେ ସେ ସୁଣ ।” ");
INSERT INTO bdv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ଗଟ୍‌ଦିନ୍‌ ରିବ୍‌ନି ଆର୍‌ ହାହି ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ କଃତା ସୁଣୁକ୍‌ ତାର୍‌ ହାକ୍‌ ଆସ୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ସେତାକ୍‌ ପାରୁସିମଃନ୍ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଇରି ଦଃକି କଃରି ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ଲିନ୍ଦା କଃରି କୟ୍‌ଲାୟ୍‌, “ଇ ଲକ୍‌ ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସୁଲା ଆର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଁଲା !” ");
INSERT INTO bdv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଇ କଃତା କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ତୁମାର୍‌ ବିତ୍ରେ ଇରଃକମ୍‌ କୁୟ୍‌ ଲକ୍‌ ଆଚେ ଜେ, ତାର୍‌ ଜଦି ହାଁଚ୍‌କଳି ମେଣ୍ଡା ରେତି, ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଆଜେଦ୍‌, ତଃବେ ସେ ଲକ୍‌ ଗଟେକ୍‌ଉଣା ହାଁଚ୍‌କଳି ମେଣ୍ଡାକ୍‌ ହଃଦାୟ୍‌ ଚାଡିକଃରି, ସେ ଆଜିରିଲା ମେଣ୍ଡାକ୍‌ ମିଳାଉତା ହଃତେକ୍‌ ତାକେ କାୟ୍‌ ନଃଲଳେ ? ");
INSERT INTO bdv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଜଃଡେବଃଳ୍‌ ସେ ଲକ୍‌ ଆଜିରିଲା ମେଣ୍ଡାକ୍‌ ମିଳାୟ୍‌ଦ୍‌ ସେ ବଃଡେ ସଃର୍ଦାଅୟ୍‌, ତାକ୍‌ କଃନ୍ଦେ ବୟ୍‌ କଃରି ତାର୍‌ ଗଃରେ ଆଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଆରେକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଲକ୍‌ବାକ୍‌କେ ଆର୍‌ ହାକିହଃଳ୍‌ସାକେ କୁଦି ସେମଃନ୍‌କେ କୟ୍‌ଦ୍‌, ‘ଆସା ତୁମିମଃନ୍ ମର୍‌ ସଃଙ୍ଗ୍ ସଃର୍ଦା କଃରା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଆଜିରିଲା ମେଣ୍ଡାକେ ମିଳାୟ୍‌ଲେ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ମୁଁୟ୍‌ ତୁମିକେ କଃଉଁଲେ, ସେରଃକମ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆସ୍ତାକ୍‌ ମଃନ୍‌ ନାୟ୍‌, ଇବାନ୍ୟା ଗଟେକ୍‌ଉଣା ହାଁଚ୍‌କଳି ଦଃର୍ମି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି, ଜେ ହାହ୍‌ ଚାଡେଦ୍‌, ଇରଃକମ୍‌ ଗଟେକ୍‌ ହାହି ଲକାର୍‌ ଗିନେ ସଃର୍ଗେ ଅଃଦିକ୍‌ ସଃର୍ଦା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ତଃବେ ଇରଃକମ୍‌ କୁୟ୍‌ ମାୟ୍‌ଜି ଆଚେ ଜେ, ତାର୍‌ ଜଦି ଦଃସ୍‌ଗଟ୍‌ ରୁହା ଟଃକା ରଃୟ୍‌ଦ୍‌, ଆର୍‌ ସେତିର୍‌ ଗଟେକ୍‌ ଆଜେଦ୍‌, ତଃବେ ସେ କୁପି ଲାଗାୟ୍‌ କଃରି ଗଃର୍‌ ରୁଣ୍ଡାୟ୍‌ ସେରି ମିଳାଉତା ହଃତେକ୍‌ କାୟ୍‌ ଜଃତୁନେ ନଃଲଳେ ? ");
INSERT INTO bdv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଆରେକ୍‌ ଆଜିରିଲା ସେ ଟଃକା ମିଳାୟ୍‌ଲେକ୍‌ ସେ ତାର୍‌ ସଃଙ୍ଗ୍‌ମଃନ୍‌କେ ଆର୍‌ ହାକିହଃଳ୍‌ସାକେ କୁଦିକଃରି କୟ୍‌ଦ୍‌, ମର୍‌ ସଃଙ୍ଗ୍ ସଃର୍ଦା କଃରା, ବଃଲେକ୍‌ ମର୍‌ ଜୁୟ୍‌ ଟଃକା ଆଜିରିଲି ସେରି ମିଳାୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେରଃକମ୍‌ ଜେ ହାହ୍‌ଚାଡେଦ୍‌, ଇରଃକମ୍‌ ଗଟେକ୍‌ ହାହିର୍‌ ଗିନେ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ମଃନାର୍‌ ଚଃମେ ସଃର୍ଦା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ଗଟ୍‌ ଲକାର୍‌ ଜୁଳେକ୍‌ ହୟ୍‌ସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ସାନ୍‌ ହୟ୍‌ସି ଉବାସିକ୍‌ କୟ୍‌ଲା, ‘ଉବା, ମର୍‌ ବାଗାର୍‌ ଦଃନ୍‌ବିତ୍‌ ଅଃବେ ମକ୍‌ ଦେ ।’ ତଃବେ ତାର୍‌ ଉବାସି ତାର୍‌ ଦଃନ୍‌ବିତ୍‌କେ ସଃର୍ନେ ଦୁୟ୍‌ ବାୟ୍‌କ୍‌ ବାଟାକଃରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଅଃଳକ୍‌ ଦିନ୍ ଗଃଲାହଃଚେ ସାନ୍ ହୟ୍‌ସି ତାର୍‌ ବାଗାର୍‌ ଦଃନ୍‌ବିତ୍‌କେ ଗଟେତଃୟ୍‌ କଃରି ଦୁର୍‌ ଦେସେ ଗଃଲା, ଆର୍‌ ସେତି ଜାୟ୍‌ ହଲ୍ୟାହଲ୍ୟା ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍‌ କାଟି ସଃର୍ନେ ଦଃନ୍‌ବିତ୍‌ ବୁଡାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ମଃତର୍‌ ସଃବୁ ଦଃନ୍ ବୁଡାୟ୍‌ଲା ହଃଚେ, ସେ ଦେସେ କଃତାର୍‌ ଅୟ୍‌ଲାକ୍‌, ତାର୍‌ ଅକେଟ୍‌ ଅଃଉଁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ସେତାର୍‌ଗିନେ ସେ ଜାୟ୍‌ ସେ ଦେସାର୍‌ ଗଟେ ଲକାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌ ଗତି କଃଟ୍‌ଲା ଆର୍‌ ସେ ଲକ୍‌ ତାକ୍‌ ଗୁସ୍ରା ଚଃରାଉଁକେ ତାର୍‌ ହଃଦାୟ୍‌ ହଃଟାୟ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଆରେକ୍‌ ଗୁସ୍ରାମଃନ୍‌ ଜୁୟ୍‌ ଚେମି କାତି ରିଲାୟ୍‌, ସେ କାଦି କାୟ୍‌କଃରି ସେ ତାର୍‌ ହେଟ୍‌ ହୁରାଉଁକେ ମଃନ୍‌ କଃର୍ତିରିଲା, ମଃତର୍‌ କେ ତାକ୍‌ କାୟ୍‌ରି ହେଁ ନଃଦେତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ମଃତର୍‌ ସେ ଚେତ୍‌ନା ହାୟ୍‌ କୟ୍‌ଲା, ‘ମର୍‌ ଉବାର୍‌ ଗଃରେ କଃବାଳିମଃନାର୍‌ କାଦି ଅଃଗ୍‌ଳି ଜଃଉଁଲି, ମଃତର୍‌ ମୁୟ୍‌ଁ ଇତି ରଃୟ୍‌ କଃରି ବୁକେ ମଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ଅଃବେ ମୁୟ୍‌ଁ ଉଟି ମର୍‌ ଉବାର୍‌ ହାକ୍‌ ଜାୟ୍‌ନ୍ଦ୍ ଆର୍‌ ତାକ୍‌ କୟ୍‌ଦ୍‌, ଉବା, ସଃର୍ଗାର୍‌ ମାପ୍ରୁର୍‌ ବିରଦେ ଆର୍‌ ତର୍‌ ବିରଦେ ମୁଁୟ୍‌ ହାହ୍‌ କଃଲେ ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ଆଜିହୁଣି ମୁୟ୍‌ଁ ତର୍‌ ହୟ୍‌ଦି ବଃଲାୟ୍‌ ଅଃଉଁକେ ମର୍‌ ଆରେକ୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌, ମଃତର୍‌ ଅଃବେ ମକ୍‌ ତର୍‌ ଗଟେକ୍‌ ଗତିକଃବାଳି ହର୍‌ କଃରି ଦଃର୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ସେ ଉଟି ତାର୍‌ ଉବାସିର୍‌ ହାକ୍‌ ଗଃଲା, ମଃତର୍‌ ସେ ଦୁରିକ୍‌ ରିଲା ବଃଳ୍‌ ତାର୍‌ ଉବାସି ତାକ୍‌ ଦଃକି ଦଃୟା ଦଃକାୟ୍‌ଲା, ଆର୍‌ ଦଃବ୍‌ଳିଜାୟ୍‌ ତାକେ ହଃଟଳି କଃରି ଲଃବଦେ ଚୁମ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ହୟ୍‌ସି ତାକ୍‌ କୟ୍‌ଲା, ‘ଉବା, ସଃର୍ଗାର୍‌ ମାପ୍ରୁର୍‌ ବିରଦେ ଆର୍‌ ତର୍‌ ବିରଦେ ମୁୟ୍‌ଁ ହାହ୍‌ କଃରିଆଚି, ଅଃବେ ଆର୍‌ ତର୍‌ ହଅ ବଃଲି କଃଉଆୟ୍‌ ଅଃଉତାର୍‌ ମୁଁୟ୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମଃତର୍‌ ଉବାସି ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ କୟ୍‌ଲା, ସଃବ୍‌କେ ନିକ ବଃସ୍ତର୍‌ ବେଗି ଆଣି ଆକ୍‌ ହିନ୍ଦାଉଆ, ତାର୍‌ ଆତେ ହାଜେର୍‌ ଆର୍‌ ତାର୍‌ ହାଦେ ହାଣ୍ଡାୟ୍‌ ହିନ୍ଦାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଆରେକ୍‌ ଗଟେକ୍‌ ଦୁମା ମେଣ୍ଡା ମାରା; ଆସା ଅଃମିମଃନ୍‌ ବଜି କଃରି ସଃର୍ଦା କଃରୁଆଁ । ");
INSERT INTO bdv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ବଃଲେକ୍‌ ମର୍‌ ଇ ହଅ ମଃରି ଜାୟ୍‌ରିଲା ଆରେକ୍‌ ବାଚ୍‌ଲା; ଆଜିରିଲା, ଆରେକ୍‌ ମିଳ୍‌ଲା । ତଃବେ ସେମଃନ୍ ସଃର୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ସଃଡେବଃଳ୍‌ ତାର୍‌ ବଃଡ୍ ହୟ୍‌ସି ହଃଦାୟ୍‌ ରିଲା । ସେ ଜଃଡେବଃଳ୍‌ ଆସି ଗଃର୍‌ ଚଃମେ ହଚ୍‌ଲା, ସଃଡେବଃଳ୍‌ ବାଜା ବାଜ୍‌ତାର୍‌ ଆର୍‌ ନାଚ୍‌ତାର୍‌ ଆଉଲି ସୁଣିକଃରି, ");
INSERT INTO bdv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ସେ ଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକେ କୁଦିକଃରି ଇସଃବୁ କାୟ୍‌ରି ଅଃଉଁଲି ବଃଲି ତାକ୍‌ ହଃଚାର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ସେ ଦଃଙ୍ଗ୍‌ଳା ତାକ୍‌ କୟ୍‌ଲା, ତର୍‌ ବାୟ୍‌ଦି ଗଃରେ ବାଉଳି ଆସିଆଚେ, ଆର୍‌ ତର୍‌ ଉବାଦି ତାକ୍‌ ନିକ ଗଃଗାଳେ ହାୟ୍‌ଲାକ୍‌ ଦୁମା ମେଣ୍ଡା ମାରିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“ସେତାର୍‌ଗିନେ ସେ ରିସା ଅୟ୍‌କଃରି ଗଃରେ ଜଃଉଁକେ ମଃନ୍‌ ନଃକେଲା; ମଃତର୍‌ ତାର୍‌ ଉବାସି ଆସିକଃରି ତାକ୍‌ କଃତେକ୍‌ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମଃତର୍‌ ସେ ଉବାସିକ୍‌ କୟ୍‌ଲା, ଦଃକ୍‌, ଅଃତେକ୍‌ ବଃର୍ସ୍‌ ଅୟ୍‌ଲି ମୁୟ୍‌ଁ ତର୍‌ ଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ହର୍‌ କଃରି ସେବା କଃରିଆସୁଲେ, ଆର୍‌ କଃବେ ହେଁ ମୁୟ୍‌ଁ ତର୍‌ ଆଦେସ୍‌ ଅମାନ୍ୟା ନଃକେରି, ଅୟ୍‌ଲେକ୍‌ ହେଁ ମର୍‌ ସଃଙ୍ଗ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସିକଃରି ବଜି କଃରୁକେ ତୁୟ୍‌ ମକ୍‌ କଃବେ ମେଣ୍ଡାହିଲା ହେଁ ନଃଦେସି; ");
INSERT INTO bdv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମଃତର୍‌ ତର୍‌ ଇ ଜୁୟ୍‌ ହୟ୍‌ଦି ଦାରିୟାଣିମଃନାର୍‌ ସଃଙ୍ଗ୍ ତର୍‌ ଦଃନ୍‌ବିତ୍‌ ବୁଡାୟ୍‌ଲା ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେ ବାଉଳି ଆୟ୍‌ଲା, ସଃଡେବଃଳ୍‌ ତୁୟ୍‌ ତାର୍‌ ଗିନେ ଗଟ୍‌ ଦୁମା ମେଣ୍ଡା ମାର୍‌ଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ତଃବେ ତାର୍‌ ଉବାସି ତାକେ କୟ୍‌ଲା, ହଅରେ ତୁୟ୍‌ ତ ସଃବୁବଃଳ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ଆଚ୍‌ସି, ଆର୍‌ ଜୁୟ୍‌ସଃବୁ ମର୍‌ ସେରି ସଃବୁ ତର୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ମଃତର୍‌ ଇ ଜୁୟ୍‌ ତର୍‌ ବାୟ୍‌ଦି ମଃରି ଜାୟ୍‌ରିଲା ଆରେକ୍‌ ବଚ୍‌ଲା, ଆଜିରିଲା ଆରେକ୍‌ ମିଳ୍‌ଲା, ସେତାର୍‌ ଗିନେ ବଜି ଆର୍‌ ସଃର୍ଦା କଃର୍ତାର୍‌ ରିଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଗଟେକ୍‌ ମାଜନ୍ ଲକ୍‌ ରିଲା; ତାର୍‌ ଗଟେକ୍‌ ଗୁମୁସ୍ତା ରିଲା, ସେ ଗୁମୁସ୍ତା ତାର୍‌ ଦଃନ୍‌ବିତ୍‌କେ ନଃସ୍ଟ୍‌ କଃରୁଲା ବଃଲି ସୁଣି, ତାକ୍‌ କୁଦି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","‘ମୁଁୟ୍‌ ତର୍‌ ବିସୟେ ଇରି କାୟ୍‌ କଃତା ସୁଣୁଲେ ? ତର୍‌ ଇ ଗୁମୁସ୍ତା କାମାର୍‌ ଇସାବ୍‌ ଦେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଅଃବେ ଗୁମୁସ୍ତା ଅୟ୍‌ ରେଉଁ ନଃହାର୍‌ସି ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ତଃବେ ସେ ଗୁମୁସ୍ତା ମଃନେ ମଃନେ ବାବ୍‌ଲା, ‘ତଃବେ ମୁଁୟ୍‌ କାୟ୍‌ କଃରିନ୍ଦ୍‌ ? ମର୍‌ ସାଉକାର୍‌ ତ ମର୍‌ ତଃୟ୍‌ହୁଣି ଗୁମୁସ୍ତା ହଃଦ୍‌ ଚାଡାୟ୍‌ ନେଉଁଲା । ମାଟି ମାରୁକ୍‌ ମର୍‌ ସଃକ୍ତି ନାୟ୍‌, ଆର୍‌ ବିକ୍‌ ମାଗୁକ୍‌ ହେଁ ମକ୍‌ ଲାଜ୍‌ ଲାଗୁଲି । ");
INSERT INTO bdv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ମୁଁୟ୍‌ ଗୁମୁସ୍ତା ହଃଦେ ହୁଣି ବାର ଅୟ୍‌ଲା ହଃଚେ ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି ମକ୍‌ ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗଃରେ କୁଦି ମାୟ୍‌ନ୍‌ କଃର୍ତି, ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ କାୟ୍‌ କଃରିନ୍ଦ୍‌ ସେରି ବୁଜ୍‌ଲେବେ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ତଃବେ ସେ ଗୁମୁସ୍ତା ତାର୍‌ ସାଉକାରାର୍‌ ସଃବୁ ରିଣ୍ୟାମଃନ୍‌କେ ତାର୍‌ ଲଃଗେ କୁଦ୍‌ଲା, ଆର୍‌ ହଃର୍ତୁର୍‌ ଲକ୍‌କେ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ମର୍‌ ସାଉକାର୍‌ ତଃୟ୍‌ହୁଣି କଃତେକ୍‌ ରିଣ୍ ନଃୟ୍‌ ଆଚ୍‌ସି ?’ ସେ କୟ୍‌ଲା, ‘ହାଁଚ୍‌କଳି ପାଉଁନ୍ ଚିକଣ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ତଃବେ ସେ ଗୁମୁସ୍ତା ତାକ୍‌ କୟ୍‌ଲା, ‘ଅଃବେ ତୁୟ୍‌ କାତାୟ୍‌ ବେଗି ପଚାସ୍‌ ପାଉଁନ୍ ଚିକଣ୍‌ ବଃଲି ଲେକ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ତାର୍‌ହଃଚେ ସେ ଆରେକ୍‌ ଏକ୍ଲାକେ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ମର୍‌ ସାଉକାରାର୍‌ ତଃୟ୍‌ହୁଣି କଃତେକ୍‌ ରିଣ୍ ନଃୟ୍‌ ଆଚ୍‌ସି ?’ ସେ କୟ୍‌ଲା, ‘ହାଁଚ୍‌କଳି ବାସ୍ତା ଗଅଁ ।’ ସେ ଗୁମୁସ୍ତା ତାକ୍‌ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ଅଃବେ ଇ କାତାୟ୍‌ ଚାରିକଳି ବାସ୍ତା ଗଅଁ ବଃଲି ଲେକ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ସେ ଅଃନ୍ୟାୟ୍‌କାରି ଗୁମୁସ୍ତା ବୁଦିର୍‌ ସଃଙ୍ଗ୍ କାମ୍‌ କଃରି ରିଲାକ୍‌, ତାର୍‌ ସାଉକାର୍‌ ତାର୍‌ ଗୁଣ୍ କୟ୍‌ଲା; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ଜଃଗତାର୍‌ ଲକ୍‌ମଃନ୍ ସେମଃନାର୍‌ ନିଜାର୍‌ ଜାତି ଗିନେ ଉଜାଳାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ବୁଦିକାରି ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“ମୁଁୟ୍‌ ହେଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଦୁସ୍ଟ୍‌ ଜଃଗତାର୍‌ ଦଃନେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗିନେ ସଃଙ୍ଗ୍ ଲାବ୍‌ କଃରା, ଜଃନ୍‌କଃରି ସେରି ସଃର୍ଲେକ୍‌ ତୁମିମଃନ୍‌କେ ସଃବୁ ଦିନାର୍‌ ଗଃର୍‌ ବିତ୍ରେ ଦଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଜୁୟ୍‌ ଲକ୍‌ ସାନ୍ କାମେ ସଃତ୍‌ ଅୟ୍‌ଦ୍‌ ତଃବେ ସେ ବଃଡ୍ କାମେ ହେଁ ହଟ୍‌କାର୍‌ ନୟ୍‌, ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ସାନ୍ କାମେ ଅଃଦଃର୍ମି ତଃବେ ସେ ବଃଡ୍ କାମେ ହେଁ ହଃଟ୍‌କାର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ତଃବେ ଜଦି ତୁମିମଃନ୍ ଜଃଗତାର୍‌ ଦଃନେ ଅଃଦଃର୍ମି ଅଃଉଁଲାସ୍‌, ତଃବେ କେ ତୁମିକେ ସଃତ୍‌ କଃରି ସଃତ୍ୟା ଦଃନ୍ ତୁମାର୍‌ ଆତେ ଦଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ଆର୍‌ ଜଦି ତୁମିମଃନ୍ ହଃରାର୍‌ ଦଃନେ ସଃତ୍‌ ନଃକେରୁଲାସ୍‌, ତଃବେ କେ ତୁମିକେ ତୁମାର୍‌ ନିଜାର୍‌ ଦଃନ୍ ଦେତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳା ଅଃକାବଃଳ୍‌ ଜଳେକ୍‌ ସାଉକାରାର୍‌ ସେବା କଃରୁ ନାହାରେ; ବଃଲେକ୍‌ ସେ ଏକ୍ଲାକେ ଲାଡ୍‌ ନଃକେରେ ଆର୍‌ ଏକ୍ଲାକେ ଲାଡ୍‌ କଃରେଦ୍‌, ନୟ୍‌ଲେକ୍‌ ଏକ୍ଲାର୍‌ କଃତା ମାନେଦ୍‌ ଆର୍‌ ବିନ୍ ଏକ୍ଲାର୍‌ କଃତା ନଃମାନେ । ସେରଃକମ୍‌ ତୁମିମଃନ୍ ଇସ୍ୱରାର୍‌ ଆର୍‌ ଦଃନାର୍‌ ଅଃକାବଃଳ୍‌ ଦୁୟ୍‌ ଲକାର୍‌ ଗତି ଦଃଙ୍ଗ୍‌ଳା ଅଃଉଁ ନାହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଇସଃବୁ କଃତା ସୁଣି ଦଃନ୍‌ଲଃବି ପାରୁସିମଃନ୍ ଜିସୁକେ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ସେତାର୍‌ଗିନେ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ଆକାୟ୍‌ ଦଃର୍ମି ବଃଲି ଦଃକାୟ୍‌ଅଃଉତି, ତୁମିମଃନ୍ ସେନ୍‌କାର୍‌ ଲକ୍‌, ମଃତର୍‌ ଇସ୍ୱର୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରାର୍‌ କଃତା ଜାଣେଦ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାୟ୍‌ରି ମାନାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ବଃଡ୍ ସେରି ମାପ୍ରୁର୍‌ ଆକାୟ୍‌ ବାନ୍ୟା ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ମସାର୍‌ ବିଦିବିଦାନ୍ ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ଲେକା ଜହନ୍‌ ଆସ୍ତା ହଃତେକ୍‌ ଚଲି ଆସ୍ତି ରିଲି; ତାର୍‌ ହଃଚେ ହୁଣି, ଇସ୍ୱରାର୍‌ ରାଇଜାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ ଅୟ୍‌ ଆସୁଲି, ଆର୍‌ ହଃତି ଲକ୍‌ମଃନ୍ ବଃଳ୍‌ସଃକାତ୍‌ ସଃଙ୍ଗ୍ ଇସ୍ୱରାର୍‌ ରାଇଜେ ହୁରୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ମଃତର୍‌ ବିଦିର୍‌ ଗଟେକ୍‌ ଟପା ବୁଡ୍‌ତା ବାଟା ଅଃଗାସ୍‌ ଆର୍‌ ହୁର୍ତିବି ବୁଡ୍‌ତାର୍‌ ଉସାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଡକୁର୍ସିକେ ଚାଡିକଃରି ବିନ୍‌ରି ବିବା ଅୟ୍‌ଦ୍‌ ସେ ଦାରିକାମ୍‌ କଃରେଦ୍‌; ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ସେ ଚାଡେଳି ମାୟ୍‌ଜିକେ ବିବା ଅୟ୍‌ଦ୍‌ ସେ ହେଁ ଦାରି କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ଗଟେକ୍‌ ମାଜନ୍ ଲକ୍‌ ରିଲା, ସେ ବେସିମଲାର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦି, ସଃବୁଦିନ୍ ବଃଲ୍‌ କାଦି କାୟ୍‌କଃରି ବଃଡେ ସଃର୍ଦାୟ୍‌ ରେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ମଃତର୍‌ ତାର୍‌ ଦୁଆର୍‌ ମୁଏଁ ଲାଜାର୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ବିକାରି ରେତିରିଲା, ତାର୍‌ ଗଃଗାଳ୍‌ଜାକ ଗାଉ ବଃର୍‌ତି ଅୟ୍‌ରିଲି; ");
INSERT INTO bdv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଲାଜାର୍‌ ସେ ମାଜନ୍ ଲକାର୍‌ ଟେବୁଲ୍‌ ତଃୟ୍‌ହୁଣି ଅଦୁର୍ଲା ଲିତାସଃକ୍‌ଳି କାୟ୍‌ ହେଟ୍‌ ହୁରାୟ୍‌ ବଃଲି ଆସା କଃର୍ତିରିଲା । ଆର୍‌ କୁକୁର୍‌ମଃନ୍ ଆସି ତାର୍‌ ଗାଉକ୍‌ ଚାଟ୍‌ତି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“ମଃତର୍‌ ଦିନ୍‌ ଆୟ୍‌ଲି ସେ ବିକାରି ଲାଜାର୍‌ ମଃରିଗଃଲା ଆର୍‌ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ ଆସି ତାକ୍‌ ଅବ୍ରାହାମାର୍‌ କଳେ ନଃୟ୍‌ ବଃସାୟ୍‌ଲାୟ୍‌; ହଃଚେ ସେ ମାଜନ୍ ଲକ୍‌ ହେଁ ମଃରିଗଃଲା ଆର୍‌ ତାକ୍‌ ତହାଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆର୍‌ ସେ ନଃର୍କ୍‌କୁଣ୍ଡେ ହଃଳି ବିସ୍‌ଜଃଳାକେ କିଲିବିଲି ଅୟ୍‌ ଉହ୍ରେ ଦଃକି ଦୁରିକ୍‌ ଅବ୍ରାହାମ୍‌ ଆର୍‌ ତାର୍‌ କଳେ ଲାଜାର୍‌କେ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ସେ କୟ୍‌ଲା, ‘ହିଁ ଉବା ଅବ୍ରାହାମ୍‌ ମକ୍‌ ଦଃୟା କଃରି ଲାଜାର୍‌କେ ଅଃଳକ୍‌ ମର୍‌ ହାକ୍‌ ହଃଟାଉ, ଜଃନ୍‌କଃରି ସେ ହାଣାୟ୍‌ ତାର୍‌ ଆଙ୍ଗଟିର୍‌ ଟିହ୍‌ ବୁଡାୟ୍‌ କଃରି ମର୍‌ ଜିବ୍‌କେ କାକର୍‌ କଃରେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ଇ ଜୟେ କଃଲ୍‌ବଃଲ୍‌ ଅଃଉଁଲେ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“ମଃତର୍‌ ଅବ୍ରାହାମ୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ହିଲାରେ ତୁୟ୍‌ ଜେ ବାଚିରିଲା ବଃଳ୍‌ ତର୍‌ ଜିବନେ ସଃବୁ ବଃଲ୍‌ରି ହାୟ୍‌ଲିସ୍‌ ଆର୍‌ ଲାଜାର୍‌ ସେରଃକମ୍‌ କଃରାବ୍‌ ବିସୟ୍‌ ସଃବୁ ହାୟ୍‌ଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସାସ୍‌ ଦଃର୍‌ଲା ଇରି ମଃନେ ଏତାଉ; ମଃତର୍‌ ଅଃବେ ଲାଜାର୍‌ ଇ ଜଃଗାୟ୍‌ ସୁକ୍‌ ହାଉଁଲା, ଆର୍‌ ତୁୟ୍‌ ସେ ଜୟେ କିଲିବିଲି ଅଃଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ସେରି ଚାଡି ତୁମାର୍‌ ଅଃମାର୍‌ ବିତ୍ରେ ବଃଡେ ଦୁର୍‌ ଆଚେ, ଜଃନ୍‌କଃରି ଜୁୟ୍‌ମଃନ୍‌ ଇ ଟାଣେହୁଣି ତୁମିମଃନାର୍‌ ହାକ୍‌ ଜଃଉଁକେ ମଃନ୍ କଃର୍ତି, ସେମଃନ୍ ଜଃଉଁ ନଃହାର୍‌ତି ଆରେକ୍‌ ସେ ଟାଣେହୁଣି କେ ଅଃମାର୍‌ ହାକ୍‌ ଲିଙ୍ଗି କଃରି ଆସୁ ନାହାର୍‌ତି ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ସେତାକ୍‌ ସେ ମାଜନ୍ କୟ୍‌ଲା, ‘ଏ ଉବା ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ଁ ତକ୍‌ ଗଃଉଆରି କଃରି କଃଉଁଲେ ଲାଜାର୍‌କେ ମର୍‌ ଉବାର୍‌ ଗଃରେ ହଃଟାଉ । ");
INSERT INTO bdv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ହାଁଚ୍ ବାୟ୍‌ ଆଚ୍‌ତି ସେମଃନ୍ ହେଁ ଜଃନ୍ କଃରି ଇ ବିସ୍‌ଜଃଳା ଟାଣେ ନାସ୍ତି, ସେତାର୍‌ଗିନେ ସେ ସେମଃନାର୍‌ ହାକ୍‌ ସାକି ଦଃୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ମଃତର୍‌ ଅବ୍ରାହାମ୍‌ କୟ୍‌ଲା, ‘ତୁମାର୍‌ ବାୟ୍‌ମଃନାର୍‌ ହାକ୍‌ ମସା ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ ଆଚେ, ସେମଃନ୍ ସେମଃନାର୍‌ କଃତା ସୁଣତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ସେତାର୍‌ଗିନେ ସେ କୟ୍‌ଲା, ନାୟ୍‌ ଉବା ଅବ୍ରାହାମ୍‌, ସଃତେକ୍‌ ସଃରି ନୟ୍‌, ମଃତର୍‌ ଜଦି ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଗଟ୍‌ଲକ୍‌ ସେମଃନାର୍‌ ହାକ୍‌ ଜାୟ୍‌ଦ୍‌, ତଃବେ ସେମଃନ୍ ସଃତ୍‌ କଃରି ହାହ୍‌ ଚାଡ୍‌ତି ।’ ");
INSERT INTO bdv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ମଃତର୍‌ ଅବ୍ରାହାମ୍‌ ତାକ୍‌ କୟ୍‌ଲା, ‘ଜଦି ସେମଃନ୍ ମସା ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ କଃତା ନଃସୁଣ୍‌ତି, ତଃବେ ମଃଲା ଲକାର୍‌ ବିତ୍ରାର୍‌ ଗଟ୍‌ଲକ୍‌ ଉଟିଜାୟ୍‌ ବୁଜାୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନ୍ ତାର୍‌ କଃତା ନଃଦେର୍ତି ।’” ");
INSERT INTO bdv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁ ତାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ବାଦା ଜେ ନାସେ, ଇରି କୟ୍‌ନୟ୍‌, ଜେ ପରିକ୍ୟାୟ୍‌ ହଃଳେଦ୍‌ ସେ ହାହେ ହଃଳେଦ୍‌, ମଃତର୍‌ ଜାର୍‌ ତଃୟ୍‌ହୁଣି ଇରି ଗଃଟେଦ୍‌, ଚି ! ସେ ଦଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଇ ନିର୍ମାୟା ଲକାର୍‌ ବିତ୍ରାର୍‌ ଗଟ୍‌ଲକେ ହାହ୍‌ କଃରାୟ୍‌ଦ୍‌, ତାର୍‌ ଗଃଳାୟ୍‌ ଗଟେକ୍‌ ଜଃତାଟେଳା ବାନ୍ଦିକଃରି ସଃମ୍‌ନ୍ଦେ ହଃକାୟ୍‌ ରିଲେକ୍‌ ତାର୍‌ ଗିନେ ନିକ ଅୟ୍‌ତାକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ତଃବେ ତୁମିମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କାମେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ଜଦି ତୁମାର୍‌ ବାୟ୍‌ ହାହ୍‌ କଃରେଦ୍‌, ତଃବେ ତାକ୍‌ ଦଃକା ଦିଆସ୍‌; ଆର୍‌ ସେ ଜଦି ହାହ୍‌ଚାଡେଦ୍‌, ତଃବେ ତାକ୍‌ କେମା ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଆରେକ୍‌, ଜଦି ସେ ଗଟେଦିନ୍‌ ବିତ୍ରେ ସାତ୍‌ ତର୍‌ ତୁମାର୍‌ ବିରଦେ ହାହ୍‌ କଃରେଦ୍‌ ଆର୍‌ ସାତ୍‌ ତର୍‌ ତୁମାର୍‌ ହାକ୍‌ ଲେଉଟି ଆସି କୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ହାହ୍‌ ଚାଡୁଲେ ବଃଲି କୟ୍‌ଦ୍‌, ତଃବେ ନିଚୟ୍‌ ତାକ୍‌ କେମା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ପେରିତ୍‌ମଃନ୍‌ ମାପ୍ରୁକେ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ବିସ୍ୱାସ୍‌ ବାଡାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ମାପ୍ରୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଦି ଗଟ୍‌ ସଃର୍ସୁ ମୁଞ୍ଜି ହର୍‌ ତୁମାର୍‌ ବିସ୍ୱାସ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ଇ ଚିତ୍‌କଳି ଗଃଚ୍‌କେ ତୁୟ୍‌ ଚେର୍‌ ସଃଙ୍ଗ୍ ଉଟ୍‌କି ଅୟ୍‌କଃରି ସଃମ୍‌ନ୍ଦେ ଜାୟ୍‌ ରୟ୍‌ ଅଃଉଅ ବଃଲି କୟ୍‌ଲେକ୍‌ ସେରି ତୁମାର୍‌ କଃତା ମାନେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଇରଃକମ୍‌ ଲକ୍‌ କେ ଆଚେ, ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା କଃସି କଃରି ଆୟ୍‌ଲା ଦାହ୍ରେ କି ଗାଇମଃନ୍ଦା ଚଃରାୟ୍‌ କଃରି ଆୟ୍‌ଲା ଦାହ୍ରେ ସେ ତାକେ କୟ୍‌ଦ୍‌, ଇ ଦାହ୍ରେ ଆସିକଃରି କାଉଁକେ ବଃସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ମଃତର୍‌ ସେ ତାକ୍‌ କାୟ୍‌ ଇରଃକମ୍‌ ନଃକୟ୍‌କଃରି, ମର୍‌ ଗିନେ କାଉଁକେ ବାଟା କଃର୍‌, ଆର୍‌ ମୁୟ୍‌ଁ କାତା ହଃତେକ୍‌ ମର୍‌ ସେବା କଃର୍‌ ତାର୍‌ ହଃଚେ ତୁୟ୍‌ କାଦି କାସି । ");
INSERT INTO bdv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ସେ ଗତିଦଃଙ୍ଗ୍‌ଳା ତାର୍‌ କଃତାମାନି ତାର୍‌ ସେବା କଃରେଦ୍‌, ତଃବେ ହେଁ ସେ କାୟ୍‌ ତାକ୍‌ ବଃଲ୍‌ ବଃଲି କୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ସେ ରଃକମ୍‌ ତୁମିମଃନ୍ ହେଁ କଃତାମାନି ସଃବୁ କାମ୍‌ କଃଲା ହଃଚେ କଃଉଆ, ‘ଅଃମିମଃନ୍‌ ଜୟ୍‌ଗ୍‌ ନୟ୍‌ଲା ଗତିଦଃଙ୍ଗ୍‌ଳା, ଜାୟ୍‌ରି କଃର୍ତା କଃତା ସେରି ହଃକା ବାୟ୍‌ଦ୍‌ରେ କଃରିଆଚୁ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ଜିରୁସାଲମେ ଜାତିରିଲା ବଃଳ୍‌ ସମିରଣ୍‌ ଆର୍‌ ଗାଲିଲି ବାଟ୍‌ ଅୟ୍‌ ଜାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଆର୍‌, ସେ କୁୟ୍‌ ଗଟେକ୍‌ ଗାଉଁଏ ହୁର୍‌ଲାକେ, ସେତି ଦଃସ୍‌ଗଟ୍‌ ବଃଡ୍‌ ରଗିମଃନ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ବେଟ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ସେମଃନ୍ ଦୁରିକ୍‌ ଟିଅୟ୍‌ ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ଜିସୁ ! ଗୁରୁ ! ଅଃମିକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଦଃକି କଃରି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାୟ୍‌ ନିଜ୍‌ ନିଜ୍‌କେ ଜାଜକ୍‌ମଃନ୍‌କେ ଦଃକାଉଆ ।” ଆର୍‌ ସେମଃନ୍ ଜଃଉଁ ଜଃଉଁ ବାଟେ ଉଜ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଲକ୍‌ ମୁୟ୍‌ଁ ନିକଅୟ୍‌ ଆଚି ବଃଲି ଜାଣି କଃରି ବଃଡ୍ ଟଣ୍ଡେ ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ଗାୟ୍‌ କଃରି ଜିସୁର୍‌ ଲଃଗେ ବାଉଳି ଆସି, ");
INSERT INTO bdv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ସେ ଜିସୁର୍‌ ଗଃଳ୍‌ ତଃଳେ ଡୁଳି ତାର୍‌ ଗୁଣ୍ କଃଉଁକେ ଦଃର୍ଲା, ସେ ଗଟେକ୍‌ ସମିରଣିୟ ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ସେତାର୍‌ଗିନେ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଦଃସ୍‌ଲକ୍‌ କାୟ୍‌ରି ଉଜ୍‌ ନଃଉତି ? ତଃବେ ଆରେକ୍‌ ନଅଲକ୍‌ କଃୟ୍‌ଗଃଲାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃଉଁକେ ଇ ଅଜିଉଦି ଲକ୍‌କେ ଚାଡି କଃରି କାୟ୍‌ରି ଆରେକ୍‌ କେହେଁ ବାଉଳି ନାୟ୍‌ଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଉଟିକଃରି ଜା ତର୍‌ ବିସ୍ୱାସ୍‌ ତକ୍‌ ଉଜ୍‌ କଃରିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ମାପ୍ରୁର୍‌ ରାଜି କଃବେ ଆସେଦ୍‌ ବଃଲି ପାରୁସିମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଦଃକ୍‌ଣେ ନାସେ; ");
INSERT INTO bdv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଆର୍‌ ଦଃକା ଇସ୍ୱରାର୍‌ ରାଇଜେ ଇତି ଆଚେ କି ସେତି ଆଚେ ବଃଲି ଲକ୍‌ମଃନ୍ ନଃକଉତି; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁର୍‌ ରାଇଜେ ତୁମାର୍‌ ବିତ୍ରେ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ମଃତର୍‌ ସେ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଇବାନ୍ୟା ବେଳା ଆସେଦ୍‌ ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଦିନ୍‌ମଃନାର୍‌ ବିତ୍ରାର୍‌ ଗଟେକ୍‌ ଦିନ୍ ଦଃକୁକ୍‌ ମଃନ୍‌ କଃରାସ୍‌ ମଃତର୍‌ ନଃଦେକାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ଦଃକା, ସେତି, ଦଃକା, ଇତି ବଃଲି ଲକ୍‌ମଃନ୍ ତୁମିକେ କଃଉତି, ମଃତର୍‌ ତୁମିମଃନ୍ ସେମଃନାର୍‌ ହଃଚେ ଜାହା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବିଜ୍‌ଲି ମାରି ଜଃନ୍‌କଃରି ଅଃଗାସ୍‌ ଉହ୍ରେ ଗଟେକ୍‌ ହାକ୍‌ହୁଣି ଆରେକ୍‌ ଗଟେକ୍‌ ହାକ୍‌ ହଃତେକ୍‌ ଉଜାଳ୍‌ ଦଃୟ୍‌ଦ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଆସ୍ତା ଦିନ୍ ସେବାନ୍ୟା ଦଃକାୟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ମଃତର୍‌ ଆଗ୍‌ତୁ ତାକେ ବାୟ୍‌ଦ୍‌ରେ ବଃଡେ ଦୁକ୍‌ ବୟ୍‌ଗ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ଇ କାଳାର୍‌ ଲକ୍‌ମଃନ୍ ଦୁର୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଆର୍‌, ନହର୍‌ ବଃଳ୍‌ ଜଃନ୍‌କଃରି ଗଃଟିରିଲି, ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ବଃଳ୍‌ ହେଁ ସେନ୍‌କାର୍‌ ଗଃଟେଦ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ଜାଜେ ନହ ହୁର୍ତା ହଃତେକ୍‌ ଲକ୍‌ମଃନ୍ କାତାର୍‌ ହିଉତାର୍‌ ଆର୍‌ ବିବା କଃରୁକ୍‌ ଆର୍‌ ବିବା ଦେଉଁକ୍‌ ମାତି ରିଲାୟ୍‌, ଆରେକ୍‌ ହୁର୍‌ହାଣି ଆସି ରାଜିବୁଡାୟ୍‌ ସଃବ୍‌କେ ନାସ୍‌ କଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲତର୍‌ ବଃଳ୍‌ ହେଁ ସେରଃକମ୍‌ ଗଃଟିରିଲି, ଲକ୍‌ମଃନ୍ କାତାର୍‌ ହିଉତାର୍‌, ବିକାବାଞ୍ଜା, ଗଃଚ୍‌ଲାଗାଉତାର୍‌ ଆର୍‌ ଗଃର୍‌ବାନ୍ଦୁକେ ଲାଗି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ମଃତର୍‌ ଲତ ସଦମ୍‌ ଗଃଳେହୁଣି ବାରାୟ୍‌ ଗଃଲାଦିନ୍‌ ଅଃଗାସ୍‌ ଉହ୍ରେ ହୁଣି ଜୟ୍‌ ଆର୍‌ ଗନ୍ଦକ୍‌ ବଃର୍ସା ଅୟ୍‌ ସଃବ୍‌କେ ନାସ୍‌ କଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ନଃରାର୍‌ ହୟ୍‌ସି ଆସ୍ତା ଦିନ୍‌ ହେଁ ସେରଃକମ୍‌ ଗଃଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ସେଦିନ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଚାନି ଉହ୍ରେ ରଃୟ୍‌ଦ୍‌ ସେ ଗଃର୍‌ ବିତ୍ରେ ରିଲା ତାର୍‌ ଆସ୍ତିବାଡି ନେଉଁକେ ଉତ୍ରି ନାଆସ; ସେବାନ୍ୟା ଜୁୟ୍‌ ଲକ୍‌ ହଃଦାୟ୍‌ ରଃୟ୍‌ଦ୍‌, ସେ ଗଃରେ ବାଉଳି ଜଃଉଅ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲତର୍‌ ଡକୁର୍ସିର୍‌ କଃତା ଏତାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଜୁୟ୍‌ଲକ୍‌ ତାର୍‌ ଜିବନ୍ ବଚାଉଁକେ ଉପାୟ୍‌ କଃରେଦ୍‌, ସେ ଆରାୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ଲକ୍‌ ମର୍‌ ନାଉଁଏ ନିଜାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ତଃବେ ସେ ତାର୍‌ ଜିବନ୍ ବାଚାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେ ରାତି ଦୁୟ୍‌ ଲକ୍‌ ଗଟେ ଟାଟିଏ ସୟ୍‌ରେତି, ଗଟ୍‌ଲକ୍‌କେ ଦିଆଅୟ୍‌ଦ୍‌ ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌କେ ଚାଡା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ଜଳେକ୍‌ ମାଇଜି ଗଟ୍‌ତଃୟ୍‌ ରୁଚ୍‌ତି ରେତି ଗଟ୍‌ଲକେ ଦିଆଅୟ୍‌ଦ୍‌ ଆର୍‌ ଗଟ୍‌ଲକେ ଚାଡା ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ଦୁୟ୍‌ଲକ୍‌ କାମ୍‍ହଃଦାୟ୍‌ ରେତି, ଏକ୍ଲାକେ ଦିଆଅୟ୍‌ଦ୍‌ ଆର୍‌ ଗଟ୍‌ଲକ୍‌କେ ଚାଡା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ତଃବେ ଚେଲାମଃନ୍ ହଃଚାର୍ଲାୟ୍‌, “ଏ ମାପ୍ରୁ ଇ ଗଃଟ୍‍ଣା କୁୟ୍‌ତି ଗଃଟେଦ୍‌ ?” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ଟାଣେ ମଃଲା ଗଃଗାଳ୍‌ ରଃୟ୍‌ଦ୍‌, ସେଟାଣେ ରାବଣ୍‌ମଃନ୍‌ ହେଁ ଗଟେତଃୟ୍‌ ରୁଣ୍ଡ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ବାଙ୍ଗି ନଃହେଳି ସଃବୁବଃଳ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତାର୍‌ ଜେ ଲଳା, ଇ କଃତା ଜିସୁ ସେମଃନ୍‌କେ ଗଟ୍‌ କଃତା କୟ୍‌ ବୁଜାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ଗଟ୍‌ ଗଃଳେ ଗଟ୍‌ ବିଚାର୍‌କଃରୁ ରିଲା, ସେ ଇସ୍ୱର୍‌କେ ନଃଡିର୍‌ତି ରିଲା କି ଲକ୍‌ମଃନ୍‌କେ ହେଁ ନଃମାନ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ସେ ଗଃଳେ ଗଟେକ୍‌ ରାଣ୍ଡି ରିଲି, ସେ ରାଣ୍ଡି ତର୍‌କେ ତର୍‌ ତାର୍‌ ହାକ୍‌ ଜାୟ୍‌କଃରି କଃଉତିରିଲି, ମର୍‌ ସଃତ୍ରୁର୍‌ ଅନ୍ୟାୟ୍‌ର୍‌ ବିଚାର୍‌ କଃରି ମକେ ନ୍ୟାୟ୍‌ ଦେ । ");
INSERT INTO bdv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଆର୍‌ ସେ ବିଚାର୍‌କଃରୁ ମାନାୟ୍‌ ସେ ରାଣ୍ଡିକେ ଉହ୍‌କାର୍‌ କଃରୁକେ ରାଜି ଅଃଉଁକେ ନଃଚ୍‌ତିରିଲା; ମଃତର୍‌ ହଃଚେ ସେ ମଃନେ ମଃନେ କୟ୍‌ଲା, ‘ଜଦି ମୁଁୟ୍‌ ଇସ୍ୱର୍‌କେ ନଃଡିରୁଲେ କି ନଃର୍‌ମଃନ୍‌କେ ମାନ୍‌ତି ନଃକେରୁଲେ, ");
INSERT INTO bdv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଅୟ୍‌ଲେକ୍‌ ହେଁ ଇ ରାଣ୍ଡି ମକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲି ଇତାର୍‌ ଗିନେ ମୁଁୟ୍‌ ତାର୍‌ ସଃତ୍ରୁର୍‌ ବିଚାର୍‌ କଃରି ତାକ୍‌ ନ୍ୟାୟ୍‌ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ନ୍ଦ୍; ନୟ୍‌ଲେକ୍‌ ସେ ସଃବୁବଃଳ୍‌ ଆସି ମକ୍‌ ବିସାଉଁକ୍‌ ନଃଦେୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ସେତାକ୍‌ ମାପ୍ରୁ କୟ୍‌ଲା, “ଇ ଅଃନ୍ୟାୟ୍‌ ବିଚାର୍‌କଃରୁ କାୟ୍‌ରି କଃଉଁଲା ସେରି ସୁଣା । ");
INSERT INTO bdv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ତଃବେ ଇସ୍ୱରାର୍‌ ଜୁୟ୍‌ ବାଚ୍‌ଲାର୍‌ ଲକ୍‌ମଃନ୍ ଦିନ୍‌ରାତି ତାର୍‌ ତଃୟ୍‌ହୁଣି ଉହ୍‌କାର୍‌ ହାଉଁକେ ତାକେ କୁଦ୍‌ତିରେତି, ତଃବେ ସେ କି ସେମଃନ୍‌କେ କଃଲା ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ନଃକେରେ ? ");
INSERT INTO bdv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେ ବେଗି ସେମଃନ୍‌କେ ଅୟ୍‌ରିଲାର୍‌ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ କଃରେଦ୍‌, ମଃତର୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଆସି ହୁର୍ତିବିଏ କାୟ୍‌ରି ବିସ୍ୱାସ୍‌ ଦଃକେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ନିଜ୍‌ ନିଜ୍‌କେ ଦଃର୍ମିଲକ୍‌ ବଃଲି ଦଃକାୟ୍‌ ଅୟ୍‌ ଆସ୍ର କଃରି ସଃବ୍‌କେ ହିନ୍‌ମାନ୍ କଃର୍ତିରିଲା କଃତି ଲକ୍‌ମଃନ୍‌କେ ଜିସୁ ଇ କଃତା ହେଁ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ଦୁୟ୍‌ ଲକ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ମନ୍ଦିରେ ଗଃଲାୟ୍‌, ଗଟେକ୍‌ ପାରୁସି ଆର୍‌ ଗଟ୍‌ଲକ୍‌ ରିବ୍‌ନି ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“ପାରୁସି ଟିଆଅୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଚଃମେ ଇ ରଃକମ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ଦଃର୍‌ଲା, ଏ ଇସ୍ୱର୍‌ ମୁଁୟ୍‌ ତର୍‌ ଦଃର୍ମ୍‌ଗୁଣ୍ କଃତା କଃଉଁଲେ ଜେ, ମୁଁୟ୍‌ ବିନ୍ ସଃବୁ ଲକାର୍‌ ହର୍‌ ଅଃଦଃର୍ମି, ହଃଟ୍‌କାର୍‌, ଦାରିକାମ୍‌ କଃର୍ତା ଲକ୍‌ କି ଇ ରିବ୍‌ନି ହର୍‌ ହେଁ ନାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ମୁଁୟ୍‌ ଆଟ୍‌ଦିନ୍‌କେ ଦୁୟ୍‌ ତର୍‌ ଉହାସ୍‌ କଃରୁଲେ, ଆର୍‌ ମୁଁୟ୍‌ ମର୍‌ ସଃବୁ ଆଉଣିର୍‌ ଦଃସ୍‌ବାଗାର୍‌ ବାଗେକ୍‌ ଦେଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“ମଃତର୍‌ ରିବ୍‌ନି ଦୁରିକ୍‌ ଟିଆ ଅୟ୍‌ ସଃର୍ଗ୍‌ହାକ୍‌ ଦଃକୁକ୍‌ ହେଁ ସାସ୍‌ ନଃକେଲା, ମଃତର୍‌ ତାର୍‌ ବୁକେ ମାରିଅୟ୍‌ କଃଉଁକେ ଦଃର୍‌ଲା, ଏ ଇସ୍ୱର୍‌, ମୁଁୟ୍‌ ହାହି ମକ୍‌ ଦଃୟା କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ପାରୁସି ନଃୟ୍‌ ମଃତର୍‌ ରିବ୍‌ନି ମାପ୍ରୁର୍‌ ଆକାୟ୍‌ ଦଃର୍ମି ଗଃଣାଅୟ୍‌ଲା ଲକ୍‌ ବଃଲି ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ଗଃଲା; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ଲକ୍‌ ଅଃହ୍‌ଣାକ୍‌ ବଃଡ୍ ବଃଲି ଦଃକାୟ୍‌ ଅୟ୍‌ଦ୍‌, ତାକ୍‌ ମାପ୍ରୁ ସାନ୍ କଃରେଦ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ଲକ୍‌ ନିଜ୍‌କେ ସାନ୍ କଃରେଦ୍‌, ତାକ୍‌ ମାପ୍ରୁ ବଃଡ୍ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁ ଜଃନ୍‌କଃରି ସାନ୍ ସାନ୍ ହିଲାମଃନ୍‌କେ ଚୁୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ତାକାର୍‌ ହିଲାମଃନ୍‌କେ ଜିସୁର୍‌ ଲଃଗେ ଆଣୁକେ ଦଃର୍ଲାୟ୍‌; ମଃତର୍‌ ଚେଲାମଃନ୍ ସେରି ଦଃକି ହିଲାମଃନ୍‌କେ ଆଣା ନାୟ୍‌ ବଃଲି ଲକ୍‌ମଃନ୍‌କେ ଦଃକା ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦିକଃରି କୟ୍‌ଲା, “ସାନ୍ ହିଲାମଃନ୍‌କେ ମର୍‌ ହାକ୍‌ ଆସୁକ୍‌ ଦିଆସ୍‌ ଆର୍‌ ସେମଃନ୍‌କେ ମଃନା କଃରା ନାୟ୍‌; ବଃଲେକ୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ଇ ରଃକମ୍‌ ହିଲାମଃନାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ଲକ୍‌ ସାନ୍‌ହିଲା ହର୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌କେ ନଃଦେରେ, ତଃବେ ସେ କଃବେ ହେଁ ସେତି ହୁରୁକ୍‌ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଗଟ୍‌ ଜିହୁଦିମଃନାର୍‌ ମୁଳିକା ଜିସୁକେ ହଃଚାର୍ଲା, “ଏ ସଃତ୍‌ ଗୁରୁ, ଅଃମ୍ବର୍‌ ଜିବନାର୍‌ ଅଃଦିକାରି ଅଃଉଁକେ ମୁଁୟ୍‌ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ସେତାକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ମକ୍‌ ସଃତ୍‌ ବଃଲି କାୟ୍‌ତାକ୍‌ କଃଉଁଲିସ୍‌ ? ଏକ୍ଲାକେ ଚାଡି, ବଃଲେକ୍‌, ଇସ୍ୱର୍‌କେ ଚାଡି ସଃତ୍‌ କେ ହେଁ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ମାପ୍ରୁର୍‌ ବିଦି ସଃବୁ ତ ତକେ ଜାଣା, ଦାରି କଃରା ନାୟ୍‌, ନଃର୍‌ ଅଃତ୍ୟା କଃରା ନାୟ୍‌, ଚର୍‌ କଃରା ନାୟ୍‌, ଲକାର୍‌ ବିରଦେ ମିଚ୍ ସାକି ଦିଆସ୍‌ ନାୟ୍‌, ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଆୟାଉବାକ୍‌ ଆର୍ଦ୍‌ନା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ସେମାନାୟ୍‌ କୟ୍‌ଲା, “ଇସଃବୁ ମୁଁୟ୍‌ ବେଣ୍ଡ୍ୟାବଃଳ୍‌ହୁଣି ମାନି କଃରି ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଇରି ସୁଣି ତାକ୍‌ କୟ୍‌ଲା, “ତର୍‌ ଆରେକ୍‌ ଗଟେକ୍‌ କାମ୍‌ କଃରୁକେ ବାକି ଆଚେ; ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ଦଃନ୍‌ବିତ୍‌ ବିକିକଃରି ଗଃରିବ୍‌ମଃନ୍‌କେ ବାଟିଦେସ୍‌ ଆର୍‌ ତୁୟ୍‌ ସଃର୍ଗେ ଦଃନ୍ ହାଉସି; ଆରେକ୍‌ ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ମଃତର୍‌ ସେ ଇସଃବୁ କଃତା ସୁଣିକଃରି ବଃଡେ ଦୁକ୍‌ ଅୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ବଃଡେ ମାଜନ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ସେତାକ୍‌ ସେ ଦୁକ୍‌ ଅୟ୍‌ଲାର୍‌ ଦଃକି ଜିସୁ କୟ୍‌ଲା, “ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଦଃନ୍ ଆଚେ ସେମଃନ୍ କଃଡେ କଃସ୍ଟେ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜାତି । ");
INSERT INTO bdv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗଟ୍‌ ମାଜନ୍‌ ଲକ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜାତା ବାଟା, ସୁତ୍‌ଲିର୍‌ କାଣାବାଟ୍‌ ଅୟ୍‌ ଉଟ୍‌ ଚିଙ୍ଗୁଳ୍‌ତାର୍‌ ଉସାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସଃବୁ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତଃବେ କେ ମୁକ୍ତି ଅଃଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ଜାୟ୍‌ରି ମାନାୟ୍‌ମଃନାର୍‌ ଆତେ ନାୟ୍‌, ସେରି ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ସେତାକ୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ଦୁକ୍‌, ଅଃମିମଃନ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସଃର୍ନେ ଦଃନ୍‌ବିତ୍‌ ଚାଡିକଃରି ତର୍‌ ହଃଚେ ହଃଚେ ଆୟ୍‌ଲୁ ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃରି କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଗିନେ ଗଃର୍‌ କି ଡକୁର୍ସିକେ, ବାୟ୍‌ କି ଉବାଆୟା କି ହିଲାଟକି ଚାଡି ଆଚ୍‌ତି, ");
INSERT INTO bdv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଇ ହୁରେ ବୁତେକ୍‌ଗୁଣ୍ ଆର୍‌ ସେ ଜୁଗେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ନଃହାୟ୍‌, ଇବାନ୍ୟା ଲକ୍‌ କେହେଁ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ତାର୍‌ହଃଚେ ଜିସୁ ବାରଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଅଃଲ୍‌ଗା କଃରି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା ଅଃମିମଃନ୍‌ ଜିରୁସାଲମେ ଜଃଉଁଲୁ, ଆର୍‌ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ କଃତା ବାବ୍‌ବାଦିମଃନ୍ ଜୁୟ୍‌ ସଃବୁ ବିସୟ୍‌ ଲେକି ଆଚ୍‌ତି, ସେରିସଃବୁ ହୁର୍ନ୍‌ ଅୟ୍‌ଦ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଅଜିଉଦିମଃନାର୍‌ ଆତେ ସଃହ୍ରି ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେମଃନ୍ ତାକ୍‌ ଟାହ୍ରା କଃର୍ତି, ତାକ୍‌ ଇନସ୍ତା କଃରି ତାର୍‌ ଉହ୍ରେ ଲାଳ୍‌ ତୁକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ତାକେ ସାଟ୍‍ଣି ସଃଙ୍ଗ୍ ମାଡ୍‌ମାରି ମଃର୍ନେ ମାର୍ତି; ମଃତର୍‌ ସେ ତିନି ଦିନାର୍‌ ତଃଳେ ଜିବନ୍ ହାୟ୍‌ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ମଃତର୍‌ ଚେଲାମଃନ୍ ଇସଃବୁ କଃତା ମୁଳ୍‌କେ ବୁଜୁ ନଃହାର୍‌ଲାୟ୍‌; ଇ କଃତା ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଲୁକ୍‌ଣେ ରିଲି, ଆର୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃଉଆ ଅଃଉତି ରିଲି, ସେସଃବୁ ସେମଃନ୍ ବୁଜୁ ନଃହାର୍‌ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁ ଜିରିହର୍‌ ଲଃଗେ ଅଃଉତି ରିଲା ବଃଳ୍‌ ଗଟେକ୍‌ କାଣା ମାନାୟ୍‌ ବାଟ୍‌ଲଃଗେ ବଃସିକଃରି ବିକ୍‌ ମାଗ୍‌ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ସେ କାଣା ଲକ୍‌ମଃନ୍ଦା ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ ଜାତାର୍‌ ସୁଣିକଃରି, “କଃତା କାୟ୍‌ରି ?” ବଃଲି ହଃଚାରୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ଲକ୍‌ମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ନାଜରିତ୍‌ ଜିସୁ ଇ ବାଟ୍‌ ଅୟ୍‌ ଜଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ସେତାକ୍‌ କାଣା ବଃଡ୍ ଟଣ୍ଡେ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଦାଉଦାର୍‌ ହୟ୍‌ସି ଜିସୁ ମକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ମଃତର୍‌ ଆଗାଳି ଜାତିରିଲା ଲକ୍‌ମଃନ୍ ତାକ୍‌ ତୁନ୍‌ ହାଳୁକ୍‌ ଦଃକା ଦେଉଁକେ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ସେ ଆରେକ୍‌ ଅଃଦିକ୍‌ ବଃଡ୍ ଟଣ୍ଡେ କଃଉଁକେ ଦଃର୍ଲା “ଏ ଦାଉଦାର୍‌ ହୟ୍‌ସି, ମକ୍‌ ଦଃୟା କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ସେତାକ୍‌ ଜିସୁ ସେତି ତେବିକଃରି ତାକେ ମର୍‌ ହାକ୍‌ ଆଣା ବଃଲି କୟ୍‌ଲା; ଆରେକ୍‌ ସେ ଚଃମେ ହଚ୍‌ଲାକ୍‌, ଜିସୁ ତାକ୍‌ ହଃଚାର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ମୁଁୟ୍‌ ତର୍‌ ଗିନେ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌ ବଃଲି ତୁୟ୍‌ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ସେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ ମୁଁୟ୍‌ ଜଃନ୍‌କଃରିକି ଆରେକ୍‌ ଦଃକୁକ୍‌ ହାରିନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତଃବେ ଦଃକ୍‌ ! ତର୍‌ ବିସ୍ୱାସ୍‌ ତକେ ଉଜ୍‌ କଃରିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ସେଦାହ୍ରେ ସେ ଆକି ହାୟ୍‌ ଇସ୍ୱରାର୍‌ ଗୁଣ୍ କଃତା କୟ୍‌ କୟ୍‌ କଃରି ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଜଃଉଁକେ ଦଃର୍ଲା ଆର୍‌ ସଃବୁଲକ୍‌ ସେରି ଦଃକିକଃରି ମାପ୍ରୁର୍‌ ଗୁଣ୍‌ଗିତ୍‌ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ହଃଚେ ଜିସୁ ଜିରିହ ଜାୟ୍‌ ସେବାଟ୍ୟା ଅୟ୍‌ ଜାତିରିଲା, ");
INSERT INTO bdv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଆର୍‌ ଦଃକା, ଜକିୟ ନାଉଁଆର୍‌ ଗଟ୍‌ ମାନାୟ୍‌ ରିଲା, ସେ ଗଟ୍‌ ମୁଳିକା ରିବ୍‌ନି ଆର୍‌ ମାଜନ୍ ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ କେ ବଃଲି ସେରି ଦଃକୁକ୍‌ ସେ ଉପାୟ୍‌ କଃର୍ତିରିଲା, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ଦା ବିତ୍ରେ ଦଃକୁ ନଃହାର୍‌ତିରିଲା, ବଃଲେକ୍‌ ସେ ବୁଟ୍‌କା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ସେତାକ୍‌ ସେ ଲକ୍‌ମଃନାର୍‌ ଆଗେ ଦଃବ୍‌ଳି ଜାୟ୍‌ ଜିସୁକେ ଦଃକୁକ୍‌ ଗଟ୍‌ ଡୁମ୍ବୁର୍‌ ଗଃଚେ ଚଃଗ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ବାଟ ଅୟ୍‌ ଜିସୁ ଜାତାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ସେତି ଆସି ଉହ୍ରେ ଦଃକି ତାକେ କୟ୍‌ଲା, “ଜକିୟ, ବେଗି ଉତ୍ରି ଆଉ ଆଜି ମକ୍‌ ବାୟ୍‌ଦ୍‌ରେ ତର୍‌ ଗଃରେ ରେଉଁକ୍‌ ହଃଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ସେତାକ୍‌ ସେ ସେଦାହ୍ରେ ଉତ୍ରି ଆସି ସଃର୍ଦାୟ୍‌ ତାକ୍‌ ଗଃରେ କୁଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ସେରି ଦଃକି ସଃବୁଲକ୍‌ ଲିନ୍ଦା କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ସେ ଗଟ୍‌ ହାହି ଗଃରେ ରେଉଁକ୍‌ ଜଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ମଃତର୍‌ ଜକିୟ ଉଟିକଃରି ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ଦଃକ୍‌, ମର୍‌ ଆଦ୍‌ବାଗ୍ ଦଃନ୍ ମୁଁୟ୍‌ ନୟ୍‌ଲା ଲକ୍‌କେ ଦେଉଁଲେ, ଆର୍‌ ଜଦି ବଃଳ୍‌ମାଡେ କାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ଆଣି ରଃୟ୍‌ନ୍ଦ୍, ତଃବେ ଚାରି ଗୁଣ୍ ବାଉଳାୟ୍‌ ଦେଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ସେତାକ୍‌ ଜିସୁ ତାର୍‌ କଃତା କୟ୍‌ଲା, “ଆଜି ଇ ଗଃରେ ମୁକ୍ତି ହଚିଆଚେ, ସେତାକ୍‌ ଏ ହେଁ ଗଟେକ୍‌ ଅବ୍ରାହାମାର୍‌ ହିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ରି ଆଜି ଆଚେ, ସେରି ଲଳି ବଚାଉଁକେ ନଃରାର୍‌ ହୟ୍‌ସି ଆସିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ଲକ୍‌ମଃନ୍ ଇ କଃତାମଃନ୍‌ ସୁଣ୍‌ତା ବଃଳ୍‌ ସେ ଆରେକ୍‌ ଗଟ୍‌ କଃତା କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଜିରୁସାଲମ୍‌ ଚଃମେ ଅୟ୍‌ରିଲା ଆର୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ବେଗି ଆସେଦ୍‌ ବଃଲି ସେମଃନ୍ ବାବ୍‌ତିରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ଗଟେକ୍‌ ବଃଡ୍ ଲକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗିନେ ରଃଜାହଃଦ୍‌ ହାୟ୍‌ କଃରି ବାଉଳି ଆସୁକ୍‌ ଦୁରି ଦେସ୍‌କେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ସେ ଅଃହ୍‌ଣାର୍‌ ଦଃସ୍‌ଗଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ କୁଦିକଃରି ସେମଃନ୍‌କେ ହଃତି ଲକ୍‌କେ ଗଟେକ୍‌ ଲେକା ସନାଅଦ୍ଲି ଦଃୟ୍‌ କୟ୍‌ଲା, ‘ମୁଁୟ୍‌ ଆସ୍ତା ହଃତେକ୍‌ ବେବାର୍‌ କଃରା ।’ ");
INSERT INTO bdv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମଃତର୍‌ ତାର୍‌ ଦେସାର୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ଗିଣ୍ କଃର୍ତି ରିଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ହଃଚେ କବୁର୍‌କାରିଆକେ ହଃଟାୟ୍‌ କୟ୍‌ଲାୟ୍‌, ‘ଇ ମାନାୟ୍‌ ଅଃମାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃରେଦ୍‌, ଇରି ଅଃମାର୍‌ ମଃନ୍ ନାୟ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ହଃଚେ ସେ ରାଇଜ୍‌ କଃର୍ତା ରଃଜାହଃଦ୍‌ ହାୟ୍‌ ବାଉଳି ଆସି ଜୁୟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କ୍‌ ଦଃନ୍ ଦଃୟ୍‌ରିଲା ସେମଃନାର୍‌ ବିତ୍ରେ ବେବାର୍‌ କଃରି କେ କଃତେକ୍‌ ଲାବ୍‌ କଃଲା ଆଚେ, ସେରି ଜାଣୁକେ ସେମଃନ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦି ଆଣୁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ସେତାକ୍‌ ହଃର୍ତୁର୍‌ ମାନାୟ୍‌ ଆସି କୟ୍‌ଲା, ‘ମାପ୍ରୁ, ତୁଇ ଦିଲା ସନାଅଦ୍ଲି ନଃୟ୍‌ ଆରେକ୍‌ ଦଃସ୍‌ଗଟ୍‌ ସନା ଅଦ୍‌ଲି ଲାବ୍‌ କଃଲେ ଆଚି ।’ ");
INSERT INTO bdv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ସେ ତାକେ କୟ୍‌ଲା, ‘ନିକ କଃତା, ତୁୟ୍‌ ସଃତ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା, ତୁୟ୍‌ କଃଡେକ୍‌ ସାନ୍‌ କଃତାୟ୍‌ ବିସ୍ୱାସ୍‌ ସଃଙ୍ଗ୍ କାମ୍‌ କଃରି ଆଚ୍‌ସି ବଃଲି ଦଃସ୍‌ ଗଟ୍‌ ଗଃଳ୍‌ ଉହ୍ରେ ଅଃଦିକାରି ଅଃଉ ।’ ");
INSERT INTO bdv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ତାର୍‌ ହଃଚାର୍‌ ଆରେକ୍‌ ଗଟ୍‌ ମାନାୟ୍‌ ଆସି କୟ୍‌ଲା, ‘ସାଉକାର୍‌ ତର୍‌ ଗଟେକ୍‌ ଟଃକାୟ୍‌ ଆରେକ୍‌ ହାଁଚ୍‌ଗଟ୍‌ ସନାଅଦ୍ଲି ଲାବ୍‌ କଃଲେ ଆଚି ।’ ");
INSERT INTO bdv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ସେ ତାକେ ହେଁ କୟ୍‌ଲା, ‘ତୁୟ୍‌ ହେଁ ହାଁଚ୍ ଗଟ୍‌ ଗଃଳ୍‌ ଉହ୍ରେ ଅଃଦିକାର୍‌ ଅଃଉ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“ସଃରାସଃରି ମାନାୟ୍‌ ଆସି କୟ୍‌ଲା, ସାଉକାର୍‌, ଦଃକ୍‌ ଇରି ତର୍‌ ସନାଅଦ୍ଲି, ମୁଁୟ୍‌ ଇରି ତୁଆଲ୍‌ ଗଃଟାୟ୍‌ ବାନ୍ଦି ସଃଙ୍ଗାୟ୍‌ରିଲେ; ");
INSERT INTO bdv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ବଃଲେକ୍‌ ମୁଁୟ୍‌ ତକେ ଡିର୍‌ଲେ କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଗଟେକ୍‌ କଃଟି ମାନାୟ୍‌, ଜୁୟ୍‌ରି ସଃଙ୍ଗାୟ୍‌ ନଃରେସି ସେରି ଟେକି ନେସି, ଆରେକ୍‌ ଜାୟ୍‌ରି ବୁଣି ନଃରେସି ସେରି କାଟି ନେସି । ");
INSERT INTO bdv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ସେ ତାକେ କୟ୍‌ଲା, ‘ଏରେ ଦୁସ୍ଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା, ତର୍‌ କୟ୍‌ଲା କଃତାୟ୍‌ ତର୍‌ ବିଚାର୍‌ କଃରିନ୍ଦ୍‌, ମୁୟ୍‌ଁ ଗଟେକ୍‌ କଃଟି ମାନାୟ୍‌, ଜୁୟ୍‌ରି ସଃଙ୍ଗାୟ୍‌ ନଃରେୟ୍‌ଁ, ସେରି ଟେକି ନଃୟ୍‌ନ୍ଦ୍, ଆର୍‌ ଜୁୟ୍‌ରି ବୁଣି ନଃରେୟ୍‌ଁ ସେରି କାଟିନ୍ଦ୍, ଇରି ଜାଣିରିଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ତଃନ୍‌ଅଲେ ବେଙ୍କେ ମର୍‌ ଟଃକା କାୟ୍‌କଃରୁକ୍‌ ସଃଙ୍ଗାୟ୍‌ ନଃରିଲିସ୍‌ ? ତଃବେ ମୁଁୟ୍‌ ଆସି କଃଣ୍‌ତର୍‌ ସଃଙ୍ଗ୍ ହାୟ୍‌ଲେହୁଣି ।’” ");
INSERT INTO bdv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ଆରେକ୍‌ ସେ ଲଃଗେ ଟିଅୟ୍‌ ରିଲା ଲକ୍‌ମଃନ୍‌କେ ରଃଜା କୟ୍‌ଲା, ଆର୍‌ ତଃୟ୍‌ହୁଣି ଇ ଦଃନ୍ ନଃୟ୍‌ ଜାୟ୍‌ ଜାର୍‌ ତଃୟ୍‌ ଦଃସ୍‌ଗଟ୍‌ ସନାଅଦ୍ଲି ଆଚେ ତାକେ ଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ସେତାକ୍‌ ସେମଃନ୍ ତାକେ କୟ୍‌ଲାୟ୍‌, ମାପ୍ରୁ, ତାର୍‌ ତ ଦଃସ୍‌ ଗଟ୍‌ ସନାଅଦ୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ମୁଁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକାର୍‌ ଆଚେ ତାକେ ଦିଆଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜାର୍‌ ନାୟ୍‌ ତାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌ରି ଆଚେ, ସେରି ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ନିଆ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମଃତର୍‌ ମର୍‌ ଇ ଜୁୟ୍‌ ସଃତ୍ରୁମଃନ୍‌ ମୁଁୟ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃର ବଃଲି ମଃନ୍‌ ନଃକେର୍‌ତି ରିଲାୟ୍‌, ସେମଃନ୍‌କେ ଇତି ଆଣି ମର୍‌ ମୁଏଁ ଅଃତ୍ୟା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଇ ସଃବୁ କଃତା କୟ୍‌ ସଃର୍ଲା ହଃଚେ, ଜିସୁ ଚେଲାମଃନାର୍‌ ଆଗେ ଆଗେ ବାରାୟ୍‌ ଜିରୁସାଲମ୍‌ ବାଟ ଜଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେ ଜିତ୍‌ହଃର୍ବାତ୍‌ ଲଃଗାର୍‌ ବେତ୍‌ପାଗି ଆର୍‌ ବେତାନିଆ ଲଃଗେ ହଚ୍‌ଲାକେ, ସଃଡେବଃଳ୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ ଲକ୍‌କେ ଇ କଃତା କୟ୍‌ ହଃଟାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ତୁମାର୍‌ ମୁଉଁ ସାମ୍‌ନାୟ୍‌ ରିଲା ହୟ୍‌ ଗାଉଁଏ ଜାହା; ସେତି ହୁର୍ତାବଃଳ୍‌ ଜାର୍‌ ଉହ୍ରେ କେ ହେଁ କଃବେ ବଃସି ନଃରେୟ୍‌, ଅଃନ୍‌କାର୍‌ ଗଟ୍‌ ହିଲାଗଃଦକେ ବାନ୍ଦା ଅୟ୍‌ରିଲାର୍‌ ଦଃକାସ୍‌; ତାକେ ମେଲି ଆଣା । ");
INSERT INTO bdv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଆର୍‌ ଜଃବେ କେ ତୁମିମଃନ୍‌କେ କାୟ୍‌କଃରୁକ୍‌ ମେଲୁଲାସ୍‌ ବଃଲି ହଃଚାର୍ଲା, ଆକ୍‌ ମାପ୍ରୁର୍‌ ଲଳା ଆଚେ ସେତାର୍‌ ଗିନେ ବଃଲି କଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ସେତାକ୍‌, ହଃଟାୟ୍‌ଲା ଚେଲାମଃନ୍ ଜାୟ୍‌କଃରି, ସେ ସେମଃନ୍‌କେ ଜଃନ୍‌କଃରି କୟ୍‌ରିଲା ସେରଃକମ୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଆର୍‌, ସେମଃନ୍ ଗଃଦହିଲାକେ ମେଲ୍‌ତା ବଃଳ୍‌ ତାର୍‌ ସାଉକାର୍‌ମଃନ୍ ସେମଃନ୍‌କେ ହଃଚାର୍ଲାୟ୍‌, “କାୟ୍‌କଃରୁକ୍‌ ହିଲାଗଃଦକେ ମେଲୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଆକ୍‌ ମାପ୍ରୁର୍‌ ଲଳା ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ଆର୍‌ ସେମଃନ୍ ହିଲାଗଃଦକେ ଜିସୁର୍‌ ହାକ୍‌ ଆଣି ତାର୍‌ ଉହ୍ରେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ଅଚାୟ୍‌ ଜିସୁକେ ବଃସାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆର୍‌ ସେ ଜାତାବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ବାଟେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ଅଚାୟ୍‌ ଦେଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଆରେକ୍‌, ଜିସୁ ଜଃଡେବଃଳ୍‌ ଜିତ୍‌ ଡଙ୍ଗ୍ରାର୍‌ କଃଳ୍‌କି ଲଃଗେ ଅୟ୍‌ଲା, ସଃଡେବଃଳ୍‌ ସଃର୍ନେ ଚେଲାମଃନ୍ଦା ଦଃକିରିଲା ସଃବୁ ସଃକ୍ତିର୍‌ କାମାର୍‌ ଗିନେ ସଃର୍ଦା ଅୟ୍‌ ଆଉଲି ଅୟ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଗୁଣ୍ କଃଉ କଃଉ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜୁୟ୍‌ ରଃଜା ଆସୁଲା, ତାର୍‌ ବଃଡ୍‌ ବାୟ୍‌ଗ୍‌, ସଃର୍ଗାର୍‌ ସୁସ୍ତା ଆର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ସେତାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତିଗଟ୍‌ ପାରୁସି ତାକେ ଦଃକା ଦିଲାୟ୍‌, “ଏ ଗୁରୁ, ତର୍‌ ଚେଲାମଃନ୍‌କେ ଚିମ୍‌ରା ଅଃଉଁକେ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଜିସୁ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତୁମିକେ କଃଉଁଲେ, ଏମଃନ୍‌ ଚିମ୍‌ରା ଅୟ୍‌ଲେକ୍‌ ଟେଳାମଃନ୍ ଆଉଲି ଅଃଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ଜିସୁ ଜିରୁସାଲମେ ଆୟ୍‌ଲା, ସଃଡେବଃଳ୍‌ ଗଃଳ୍‌କେ ଦଃକି ତାର୍‌ ଗିନେ କାନ୍ଦି କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ତୁୟ୍‌, ହିଁ, ତୁୟ୍‌ ଜଦି ଆଜି ସୁସ୍ତାର୍‌ କଃତାମଃନ୍‌ ଜାଣ୍‌ଲିସ୍‌ହୁଣି ! ମଃତର୍‌ ଅଃବେ ତର୍‌ ଆକାୟ୍‌ ଲୁକ୍‌ଣେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ବେଳା ଆସୁଲି, ଜଃଡେବଃଳ୍‌ ତର୍‌ ସଃତ୍ରୁମଃନ୍‌ ତର୍‌ ଚାରି ବେଳ୍‌ତ୍ ରୁଣ୍ଡିକଃରି ତକେ ବେଳ୍‌ତି, ଆରେକ୍‌ ତର୍‌ ସଃବୁ ଦୁଆର୍‌ ବଃନ୍ଦ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ଆରେକ୍‌ ତକେ ଆର୍‌ ତର୍‌ ବିତ୍ରେ ରିଲା ସଃବୁ ତର୍‌ ହିଲାମଃନ୍‌କେ ମାଟାୟ୍‌ ମିସାଉତି, ଆର୍‌ ତର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଟେଳା ଆରେକ୍‌ ଗଟେକ୍‌ ଟେଳା ଉହ୍ରେ ରେଉଁକ୍‌ ନଃଦେତି, ଇବାନ୍ୟା ବେଳ୍‌ ତର୍‌ ଉହ୍ରେ ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଆର୍‌ ସେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହୁରି ବିକାବାଞ୍ଜା କଃର୍ତା ଲକ୍‌ମଃନ୍‌କେ ଇରି କୟ୍‌ ବାର୍‌ କଃରୁକେ ଦଃର୍ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“ସାସ୍ତରେ ଲେକା ଆଚେ, ଇସ୍ୱର୍‌ କଃଉଁଲା, ‘ଅଃମାର୍‌ ଗଃର୍‌ ଇସ୍ୱରାର୍‌ ପାର୍ତ୍‌ନାଗଃର୍‌ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍ ତାକେ କଃଙ୍ଗାର୍‌ମଃନାର୍‌ ଲୁକ୍‌ତା ହାର୍‌ କଃରିଆଚାସ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ଆର୍‌ ଜିସୁ ଦିନେକେ ମନ୍ଦିରେ ସିକ୍ୟା ଦେତିରିଲା, ମଃତର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍‌ ଲକ୍‌ମଃନାର୍‌ ନେତାମଃନ୍ ତାକ୍‌ ନାସ୍‌ କଃରୁକେ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ଏକ୍‌ ମଃନେ ତାର୍‌ ସିକ୍ୟା ସୁଣ୍‌ତିରିଲାୟ୍‌, ସେତାକ୍‌ ସେମଃନ୍ କାୟ୍‌ରି କଃରୁନ୍ଦ୍‌ ବଃଲି ତିର୍‌ କଃରୁ ନଃହାର୍‌ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଗଟ୍‌ଦିନ୍‌ ଜିସୁ ଜଃଡେବଃଳ୍‌ ମନ୍ଦିରେ ସିକ୍ୟା ଦେତିରିଲା ଆର୍‌, ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃର୍ତିରିଲା, ସଃଡେବଃଳ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆସି ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ତୁୟ୍‌ ଇରିମଃନ୍‌ କୁୟ୍‌ ଅଃଦିକାରେ କଃରୁଲିସ୍‌ ଆର୍‌ ଜେ ତକେ ଇ ଅଃଦିକାର୍‌ ଦିଲା, ସେ କେ, ଅଃମିକ୍‌ କଃଉ ?” ");
INSERT INTO bdv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ଁ ହେଁ ତୁମିକେ ଗଟେକ୍‌ କଃତା ହଃଚାରିନ୍ଦ୍‌, ମକେ କଃଉଆ, ");
INSERT INTO bdv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଅଃଦିକାର୍‌ ସଃର୍ଗେ ହୁଣି କି ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଅୟ୍‌ଲି ?” ");
INSERT INTO bdv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ସେତାକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଜଦି ସଃର୍ଗେ ହୁଣି ବଃଲି କଃଉନ୍ଦ୍, ତଃବେ ସେ କୟ୍‌ଦ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଜହନ୍‌କେ ବିସ୍ୱାସ୍‌ ନଃକେଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ମଃତର୍‌ ଜଦି ମାନାୟ୍‌ ତଃୟ୍‌ହୁଣି ବଃଲି କଃଉନ୍ଦ୍, ତଃବେ ଲକ୍‌ମଃନ୍ ଅଃମିକ୍‌ ଟେଳା ସୁତ୍ରି ମାରି ହଃକାଉତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜହନ୍‌ ତ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ବଃଲି ଲକ୍‌ମଃନ୍ ବେସି ବିସ୍ୱାସ୍‌ କଃର୍ତି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଇତାର୍‌ ଗିନେ ସେରି କୁୟ୍‌ତିହୁଣି ଅୟ୍‌ଲି, ଇରି ନଃଜାଣୁ ବଃଲି ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ମୁୟ୍‌ଁ କୁୟ୍‌ ଅଃଦିକାରେ ଇସଃବୁ କଃରୁଲେ, ସେରି ହେଁ ତୁମିମଃନ୍‌କେ ନଃକୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ତାର୍‌ହଃଚେ ଜିସୁ ଲକ୍‌ମଃନ୍‌କେ ଇ କଃତା କଃଉଁକେ ଦଃର୍ଲା । “ଗଟ୍‌ ମାନାୟ୍‌ ଗଟ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ କଃରି ସେରି ବାଗ୍ ତାସିମଃନ୍‌କେ ବାଗେ ଦଃୟ୍‌ ବୁତେକ୍‌ ଦିନାର୍‌ ଗିନେ ବିଦେସେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଆରେକ୍‌ ସେ ତାସିମଃନ୍‌ ଜଃନ୍‌କଃରି ତାକେ ବାଳାର୍‌ ଅଙ୍ଗୁର୍‌ ହଃଳାର୍‌ ବାଗ୍ ଦେତି, ଇତାକ୍‌ ସେ ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ଟିକ୍‌ ବେଳାୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ହଃଟାୟ୍‌ଲା, ମଃତର୍‌ ସେ ତାସିମଃନ୍‌ ତାକ୍‌ ମାଡ୍ ମାରି ଚୁଚା ଆତେ ହଃଟାୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ସେ ଆରେକ୍‌ ଗଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ହେଁ ହଃଟାୟ୍‌ଲା; ମଃତର୍‌ ସେମଃନ୍ ତାକେ ହେଁ ମାଡ୍‌ ମାରି ଲାଜ୍‌ କଃରାୟ୍‌ ଆର୍‌ ଚୁଚା ଆତେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ତାର୍‌ହଃଚେ ସେ ଦୁୟ୍‌ ଲକ୍‌କେ ହଃଟାୟ୍‌ଲା ହଃଚେ, ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ହଃଟାୟ୍‌ଲା, ମଃତର୍‌ ସେମଃନ୍ ତାକେ ହେଁ ବାନାକାବ୍‌ରା କଃରି ହଃଦାୟ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ସେତାକ୍‌ ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସାଉକାର୍‌ କୟ୍‌ଲା ମୁୟ୍‌ଁ କାୟ୍‌ କଃରିନ୍ଦ୍‌ ? ମର୍‌ ଲାଡାର୍‌ ହଅକେ ହଃଟାୟ୍‌ନ୍ଦ୍, କେଜାଣ୍ ସେମଃନ୍ ତାକେ ମାୟ୍‌ନ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମଃତର୍‌ ତାସିମଃନ୍‌ ତାକ୍‌ ଦଃକି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ଏ ତ ସାଉକାରାର୍‌ ହୟ୍‌ସି, ଆକ୍‌ ମଃର୍ନେ ମାରୁଆଁ, ତଃବେ ସଃବୁ ଦଃନ୍‌ବିତ୍‌ ଅଃମାର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ମଃର୍ନେ ମାରି ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସେହାଟି ହଃକାୟ୍‌ଲାୟ୍‌ । ତଃନ୍‌ଅଲେ ଅଙ୍ଗୁର୍‌ ବାଳାର୍‌ ସାଉକାର୍‌ ସେମଃନ୍‌କେ କଃନ୍‌କଃରେଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ସେ ଆସି ଇ ତାସିମଃନ୍‌କେ ନାସ୍‌ କଃରେଦ୍‌ ଆର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ ଅଙ୍ଗୁର୍‌ ବାଳ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ଇରି ସୁଣି ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ସେରି ନଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ମଃତର୍‌ ସେମଃନ୍‌କେ ଆକି ନିକକଃରି ସଃଳ୍‌କେ ଦଃକି କୟ୍‌ଲା, “ତଃବେ ଇ ଜୁୟ୍‌ କଃତା ଲେକାଆଚେ, ତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି, ଗଃର୍‌ ବାନ୍ଦୁମଃନ୍‌ ଜୁୟ୍‌ ଟେଳାକେ ମଃନ୍‌ ନଃକେଲାୟ୍‌, ସେରି କନାର୍‌ ମୁଳ୍‌ ଟେଳା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଜେ ସେ ଟେଳା ଉହ୍ରେ ଅଦ୍ରେଦ୍‌, ସେ କଃଣ୍ଡ୍‌ କଃଣ୍ଡ୍‌ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ସେ ଟେଳା ଜାର୍‌ ଉହ୍ରେ ଅଦ୍ରେଦ୍‌ ତାକ୍‌ ସେରି ଗୁଣ୍ଡ୍‌ଗୁଣ୍ଡା କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ଇତାକ୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ମଃନ୍ ସେଦାହ୍ରେ ତାକେ ଦଃରୁକେ ମଃନ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍‌ଲାୟ୍‌, ବଃଲେକ୍‌ ସେ କଃତା ସେମଃନ୍‌କେ ଦଃକିକଃରି ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା ବଃଲି ସେମଃନ୍ ବୁଜ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ସଃର୍‌କାରି ଅଃଦିକାରିମଃନାର୍‌ ଆତେ ଆର୍‌ ରାଇଜ୍‌କଃର୍ତା ଲକାର୍‌ ଅଃଦିକାର୍‌ ତଃଳେ ସଃର୍ହି ଦେଉଁକେ ସୁବିଦା ଲଳି ତାର୍‌ କଃତାୟ୍‌ ଦଃସ୍‌ ଦଃରୁକ୍‌ ଚାଲାକି ବାବେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାକ୍‌ ଦଃର୍ମି ଲକ୍‌ ବଃଲି ଦଃକାୟ୍‌ ଅଃଉତା ଚର୍‌ମଃନ୍‌କେ ଲାଚ୍ ଦଃୟ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ସେ ଚର୍‌ମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଏ ଗୁରୁ, ଅଃମିମଃନ୍‌ ଜାଣିଆଚୁ ତୁୟ୍‌ ସଃତ୍‌ କଃତା କଃଉଁଲିସ୍‌ ଆର୍‌ ସିକ୍ୟା ଦେଉଁଲିସ୍‌ ଆର୍‌ କାର୍‌ ମୁକ୍‌ମେଟ୍‌ ନଃଦେକ୍‌ସି, ମଃତର୍‌ ସଃତ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଇସାବେ ସିକ୍ୟା ଦେଉଁଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ଅଃମିମଃନ୍‌କ୍‌ କଃଉ, କାଇସର୍‌କେ ସିସ୍ଟୁ ଦେତା ଅଃମାର୍‌ ବିଦି ଆଚେ କି ନୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ଚାଲାକିକେ ଜାଣି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମକ୍‌ ଗଟ୍‌ ଅଦ୍‌ଲି ଦଃକାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ମକେ ଗଟେକ୍‌ ଟଃକା ଦଃକାଉ । ଇତି କାର୍‌ ମୁର୍ତି ଆର୍‌ ନାଉଁ ଆଚେ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “କାଇସର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତଃବେ ଜୁୟ୍‌ରି କାଇସରାର୍‌ ସେରି କାଇସର୍‌କେ ଦିଆସ୍‌; ଆର୍‌ ଜୁୟ୍‌ରି ଇସ୍ୱରାର୍‌ ସେରି ଇସ୍ୱର୍‌କେ ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଇତାକ୍‌ ସେମଃନ୍ ଲକାର୍‌ ଆଗେ ତାର୍‌ କଃତାର୍‌ ଦଃସ୍‌ ଦଃରୁକ୍‌ ହାରି ନାହାର୍ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ କଃତାୟ୍‌ କାବା ଅୟ୍‌ ମଦା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ତାର୍‌ହଃଚେ ମଃଲା ଲକ୍‌ ଉଟ୍‌ତାର୍‌ ସଃତ୍‌ ନଃକେର୍ତା କଃତିଗଟ୍‌ ସାଦୁକିମଃନ୍‌ ଜିସୁର୍‌ ହାକ୍‌ ଆସି ହଃଚାର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଏ ଗୁରୁ, ମସା ଅଃମାର୍‌ ଗିନେ ଲେକ୍‌ଲାଆଚେ ଜେ, ଜଦି ଗଟ୍‌ ଲକାର୍‌ ବାୟ୍‌ସିର୍‌ ଡକୁର୍ସି ରେଉଁ ରେଉଁ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃରେଦ୍‌, ତଃନ୍‌ଅଲେ ତାର୍‌ ବାୟ୍‌ସି ତାର୍‌ ଡକୁର୍ସିକେ ସଃଙ୍ଗାୟ୍‌ କଃରି ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ସିର୍‌ ବଃଉଁସ୍‌ ବାଡାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ଗଟ୍‌ତର୍‌ ସାତ୍‌ ବାୟ୍‌ ରିଲାୟ୍‌, ବଃଡ୍‌ ବାୟ୍‌ସି ଗଟ୍‌ ମାୟ୍‌ଜିକେ ବିବା ଅୟ୍‌ଲା ଆର୍‌ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ଦୁୟ୍‌ ବାୟ୍‌ର୍‌ ହଃଚେ ଆରେକ୍‌ ଗଟ୍‌ ବାୟ୍‌ସି ହେଁ ତାକ୍‌ ସଃଙ୍ଗାୟ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ସେରଃକମ୍‌ ସାତ୍‌ ବାୟ୍‌ ଜାକ ହିଲାମଃନ୍‌ ନଃଉତ୍‌ ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ସଃରାସଃରି ସେ ମାୟ୍‌ଜି ହେଁ ମଃଲି । ");
INSERT INTO bdv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ତଃବେ ମଃଲାଲକ୍‌ମଃନ୍‌ ଉଟ୍‌ତାବଃଳ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ସେ କାର୍‌ ଡକୁର୍ସି ଅୟ୍‌ଦ୍‌ ? ସାତ୍‌ ବାୟ୍‌ ଜାକ ତ ତାକେ ସଃଙ୍ଗାୟ୍‌ ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ ଜଃଗତାର୍‌ ଲକ୍‌ମଃନ୍ ବିବା କଃର୍ତି ଆର୍‌ ବିବା ଦେତି । ");
INSERT INTO bdv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମଃତର୍‌ ଜୁୟ୍‌ମଃନ୍‌ ସେ ଜଃଗତାର୍‌ ଗିନେ ଉଟ୍‌ତାର୍‌ ଜୟ୍‌ଗ୍‌ ଅଃଉତି, ସେମଃନ୍ ବିବା ନଃକେର୍ତି କି ବିବା ନଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଆରେକ୍‌, ସେମଃନ୍ ମଃରୁ ନଃହାର୍ତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଦୁତ୍‌ ମଃନ୍‌କାର୍‌ ହର୍‌ ରେତି, ଆର୍‌ ମଃରି ଉଟ୍‌ଲା ହିଲାମଃନ୍‌ ଅୟ୍‌ରିଲାକ୍‌ ଇସ୍ୱରାର୍‌ ହିଲାମଃନ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମଃତର୍‌ ମଃଲାଲକ୍‌ମଃନ୍‌ ଜେ ଉଟ୍‌ତି, ଇରି ମସା ହେଁ ଗଟ୍‌ ବୁଟାର୍‌ ଗଃଟ୍‍ଣାୟ୍‌, ମାପ୍ରୁକେ ଅବ୍ରାହାମାର୍‌ ଇସ୍ୱର୍‌, ଇସାକାର୍‌ ଇସ୍ୱର୍‌, ଜାକୁବାର୍‌ ଇସ୍ୱର୍‌ ବଃଲି କୟ୍‌ ଜାଣାୟ୍‌ଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ସେତ ମଃଲା ଲକାର୍‌ ଇସ୍ୱର୍‌ ନଃୟ୍‌, ମଃତର୍‌ ଜିବନ୍‌ ଲକାର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌, ସଃବୁ ଲକ୍‌ ତାର୍‌ ଲଃଗେ ଜିବନ୍ ରିଲା ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ସେତି କଃତେକ୍‌ ସାସ୍ତର୍‌ ଜାଣତା ଲକ୍‌ମଃନ୍ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ଏ ଗୁରୁ, ତୁୟ୍‌ ଟିକ୍‌ କୟ୍‌ଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ସେତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ କାୟ୍‌ କଃତା ହଃଚାରୁକ୍‌ ଆର୍‌ ସାସ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “କ୍ରିସ୍ଟ ଜେ ଦାଉଦାର୍‌ ହୟ୍‌ସି ବଃଲି ଲକ୍‌ମଃନ୍ କଃନ୍‌କଃରି କଃଉଁଲାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ବଃଲେକ୍‌ ନିଜେ ଦାଉଦ୍‌ ଗିତ୍‌ସହିତା ଲେକାହଃତାର୍‌ ତଃୟ୍‌ଁ କୟ୍‌ଆଚେ, ମାପ୍ରୁ ମର୍‌ ମାପ୍ରୁକ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ମୁୟ୍‌ଁ ଜଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ତୁମାର୍‌ ସଃତ୍ରୁମଃନ୍‌କେ ତୁମାର୍‌ ହାଦ୍‌ସଃଙ୍ଗାଉତା ଟାଣେ ଆଣିନାଚୁ, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ମର୍‌ କାତାବାଟ୍ୟା ବଃସିରେ । ");
INSERT INTO bdv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ତଃବେ, ଦାଉଦ୍‌ ତାକେ ମାପ୍ରୁବଃଲି କଃଉଁଲା, ତଃବେ ସେ କଃନ୍‌କଃରି ତାର୍‌ ହୟ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ହଃଚେ ସେ ସଃବୁ ଲକାର୍‌ ମୁଏଁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ଦଃର୍ମ୍‌ ଗୁରୁମଃନାର୍‌ ତଃୟ୍‌ ଜଃଗ୍ରାତ୍‌, ସେମଃନ୍ ଡେଙ୍ଗ୍ ବଃସ୍ତର୍‌ ହିନ୍ଦି ବୁଲୁକ୍‌, ଆର୍‌ ଆଟେ ବଃଜାରେ ଜୁଆର୍‌ ହାଉଁକେ, ପାର୍ତ୍‌ନା ଗଃରେ ବଃଡ୍ କୁର୍ଚି ଆର୍‌ ବଜିତଃୟ୍‌ ବଃଡ୍ ଟାଣେ ବଃସୁକେ ମଃନ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ସେମଃନ୍ ରାଣ୍ଡିମଃନାର୍‌ ଗଃର୍‌ଗୁଡା ସଃବୁ ଅଃଦିକାର୍‌ କଃର୍ତି ଆର୍‌ ଚାଲାକି କଃରି ବେସି ଗଃଳି ପାର୍ତ୍‌ନା କଃର୍ତି; ସେମଃନ୍ ଜଃବର୍‌ ବିଚାର୍‌ ତଃୟ୍‌ଁ ଡଃଣ୍ଡ୍‌ ହାଉତି ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଇତାର୍‌ହଃଚେ ଜିସୁ ଚାରିହାକ୍‌ ଆକିହ୍‌କାୟ୍‌, ମାଜନ୍‌ ଲକମଃନ୍‌ ଦାନ୍‌ହେଳି ତଃୟ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଦାନ୍‌ ଦେତାର୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଆର୍‌, ଜିସୁ ଗଟ୍‌ ଗଃରିବ୍‌ ରାଣ୍ଡି ଜଳେକ୍‌ ସାନ୍‌ ତାମ୍ବାକାସୁ ହଃକାଉତାର୍‌ ଦଃକ୍‌ଲା ");
INSERT INTO bdv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ନିଜ୍‌କଃରି କଃଉଁଲେ, “ଇ ଗଃରିବ୍‌ ରାଣ୍ଡି ସଃବ୍‌କେ ଅଃଦିକ୍‌ ଦିଲିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ସଃବୁ ଲକ୍‌ ବଃଣ୍ଡାରେ ନିଜାର୍‌ ନିଜାର୍‌ ଉବୁର୍ଲା ଦଃନ୍ ଅଃଳକ୍‌ ଅଃଳକ୍‌ ହଃକାୟଲାୟ୍‌, ମଃତର୍‌ ଏ ନିଜାର୍‌ ଅକେଟ୍‌ ବଃଳ୍‌ ନିଜାର୍‌ ଜିବନ୍ ବଚାଉଁକେ ଜଃତେକ୍‌ ରିଲି, ସେ ସଃବୁ ଦାନ୍‌କଃଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ଆର୍‌ କଃତେକ୍‌ ଚେଲାମଃନ୍ ମନ୍ଦିରାର୍‌ ବିସୟେ କଃତାବାର୍ତା ଅଃଉତି ରିଲାୟ୍‌ । ସେମଃନ୍ କଃଉତି ରିଲାୟ୍‌, ସେତି ତିଆର୍‌ ଅୟ୍‌ରିଲା ସୁନ୍ଦୁର୍‌ ଟେଳା, ଆର୍‌ ଇସ୍ୱର୍‌କେ ଦାନ୍‌ ଦଃୟ୍‌ରିଲା, ଜିନିସ୍‌ସଃବୁ ସଃଙ୍ଗ୍ ମନ୍ଦିର୍‌ ବଃଡେ ସୁନ୍ଦୁର୍‌ ଡିସୁଲି । ");
INSERT INTO bdv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଇରି ଜାୟ୍‌ରି ସଃବୁ ଦଃକୁଲାସ୍‌, ବେଳା ଆସେଦ୍‌ ଜଃଡେବଃଳ୍‌ ଗଟେକ୍‌ ଟେଳା ଆରେକ୍‌ ଗଟେକ୍‌ ଟେଳା ଉହ୍ରେ ନଃରେୟ୍‌, ସଃର୍ନେ ମାଟାୟ୍‌ ମିସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ଏ ଗୁରୁ, ତଃବେ ଇସଃବୁ କଃବେ ଗଃଟେଦ୍‌ ? ଆରେକ୍‌ ଜୁୟ୍‌ ବେଳାୟ୍‌ ଇ ସଃବୁ ଗଃଟ୍‍ଣା ଲଃଗେ ଅୟ୍‌ଦ୍‌ ସଃଡେବଃଳାର୍‌ ଚିନ୍ କାୟ୍‌ରି ?” ");
INSERT INTO bdv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ଜଃଗ୍ରାତ୍‌ ରିଆ, ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଉଲୁ ନଃଉଁଆସ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ନାଉଁଏ ଆସି ମୁୟ୍‌ଁ ସେ ଆର୍‌ ବେଳ୍‌ ହଚ୍‌ଲିନି ବଃଲି କଃଉତି; ସେମଃନାର୍‌ ହଃଚେ ଜାହାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଜୁଜ୍‌ ଆର୍‌ ଗଣ୍ଡ୍‌ଗଳ୍‌ ଅଃଉତାର୍‌ ସୁଣାସ୍‌, ସଃଡେବଃଳ୍‌ ଡିରା ନାୟ୍‌; କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇରିମଃନ୍‌ ହଃର୍ତୁ ଗଃଟେଦ୍‌, ମଃତର୍‌ ତଃତ୍‌କାଣ୍ ଜୁଗ୍ ସେସ୍‌ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ତାର୍‌ହଃଚେ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଲକ୍‌ ବିରଦେ ଲକ୍‌ ଆର୍‌ ରାଇଜ୍‌ ବିରଦେ ରାଇଜ୍‌ ଉଟ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ଆର୍‌ ବଃଡ୍‌ବଃଡ୍ ବୁଇଁକମ୍ପ୍, ଆର୍‌ ଟାଣେ ଟାଣେ ମଃର୍ଡି ଦଃରେଦ୍‌ ଆର୍‌ କଃତାର୍‌ ଅୟ୍‌ଦ୍‌, ଆର୍‌ ଅଃଗାସ୍‌ ଉହ୍ରେ ବୟଃଙ୍କାର୍‌ ଗଃଟ୍‍ଣାମଃନ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ବଃଡେ ବଃଡେ ଚିନ୍‌ମଃନ୍‌ ଡିସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ମଃତର୍‌ ଇସଃବୁ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ତା ହୁର୍ବେ ଲକ୍‌ମଃନ୍ ତୁମିକେ ଦଃର୍ତି ଆର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଆର୍‌ ଜଃଇଲେ ସଃର୍ହି ଦଃୟ୍‌ ଆର୍ଲା କଃର୍ତି ମର୍‌ ନାଉଁଏ ତୁମିକେ ରଃଜା ଆର୍‌ ସଃର୍କାର୍‌ ଅଃଦିକାରିମଃନାର୍‌ ତଃୟ୍‌ ଟିଆ ଅଃଉଁକେ ହଃଳେଦ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ଇରି ମର୍‌ ବିସୟେ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ ସାକି ଦେଉଁକେ ତୁମିମଃନ୍‌କେ ବାଟ ମିଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ବଃଲେକ୍‌ ନିଜାର୍‌ ବିସୟେ କାୟ୍‌ ଉତୁର୍‌ ଦିଆସ୍‌ ସେତାକ୍‌ ଆଗ୍‌ତୁ ଚିତା ନଃକେରୁକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ତିର୍‌ କଃରା; ");
INSERT INTO bdv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ଅଃନ୍‌କାର୍‌ କଃତା ଆର୍‌ ଗ୍ୟାନ୍ ଦଃୟ୍‌ନ୍ଦ୍ ଜେ, ତୁମିମଃନାର୍‌ ସଃର୍ନେ ବିରଦି ଲକ୍‌ ସେତାର୍‌ ବିରଦ୍‌ କି ଜଃବାଉ ଦେଉଁକ୍‌ ନଃହାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ମଃତର୍‌ ତୁମିମଃନ୍‌କେ ଉବାଦି ଆୟ୍‌ଦି, ବାୟ୍‌, ନିଜାର୍‌ ଲକ୍‌ମଃନ୍ ହେଁ ସଃର୍ହି ଦେତି, ଆରେକ୍‌ ତୁମାର୍‌ ବିତ୍ରେ ସଃଙ୍ଗ୍ ମଃନ୍‌ହେଁ କାକେ କାକେ ମଃର୍ନେ ମାର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ଆରେକ୍‌ ମର୍‌ ନାଉଁଆର୍‌ ଗିନେ ତୁମିମଃନ୍‌କେ ସଃବୁଲକ୍‌ ଗିଣ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମଃତର୍‌ ତୁମାର୍‌ ମୁଣ୍ଡାର୍‌ ବାଳ୍‌ ହେଁ ନଃସ୍ଟ୍‌ ନୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ତୁମିମଃନ୍ ଅଃଟୁଆ ଅୟ୍‌ରିଲେକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହଃରାଣ୍ ରଃକ୍ୟା କଃରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଜିରୁସାଲମ୍‌କେ ସଃଇନ୍‌ ଦଃଳ୍‌ ମଃନ୍‌ ବେଳି ଅୟ୍‌ଲାର୍‌ ଦଃକାସ୍‌ ସଃଡେବଃଳ୍‌ ସେରି ବଃସମ୍‌ ଅଃଉତାର୍‌ ଲଃଗେ ଅୟ୍‌ଲି ବଃଲି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିଉଦା ରାଇଜେ ରେତି, ସେମଃନ୍ ଡଙ୍ଗୁର୍‌ ଉହ୍ରେ ହଃଳାୟ୍‌ ଜଃଅତ୍‌, ଜୁୟ୍‌ଲକ୍‌ ଗଃଳ୍‌ ବିତ୍ରେ ରେତି, ନିଚୟ୍‌ ସେମଃନ୍ ବାରାୟ୍‌ ଜଃଅତ୍‌, ଆର୍‌ ଜୁୟ୍‌ଲକ୍‌ ଗାଉଁଏ ରେତି, ସେମଃନ୍ ଗଃଳ୍‌ ବିତ୍ରେ ନଃଜଃଅତ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଲେକ୍‌ଲା କଃତା ସଃବୁ ହୁରୁଣ୍ ଅଃଉଁକେ ସେରି ଟିକ୍‌ ଡଃଣ୍ଡାର୍‌ ବେଳା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଟକିମଃନ୍‌ ଆଙ୍ଗେ ରେତି ଆର୍‌ ଜୁୟ୍‌ ଟକିମଃନାର୍‌ ଦୁଦ୍‌ କଃତା ସାନ୍ ହିଲା ରେତି, ସେମଃନ୍ ବଃଡେ ଦୁକ୍‌ ହାଉତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହୁର୍ତିବିଏ ବଃଡ୍ ବିପ୍‌ତି ଆର୍‌ ଇ ଜାତିକେ ଡଃଣ୍ଡ୍‌ ଗଃଟେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଆର୍‌ ସେମଃନ୍ କଃଣ୍ଡା ଲଃଗେ ହୁଜାଇ ଅଃଉତି ଆର୍‌ ବାନ୍ଦାୟ୍‌ ଅୟ୍‌ ସଃବୁ ଅଜିଉଦି ବିତ୍ରେ ନିଆ ଅଃଉତି, ଆରେକ୍‌ ବିନ୍ ଜାତିମଃନାର୍‌ କାଳ୍‌ ହୁରୁଣ୍ ନଃଉତା ହଃତେକ୍‌ ଜିରୁସାଲମ୍‌ ସେମଃନାର୍‌ ହାଦ୍‌ତଃଳେ ରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ଆରେକ୍‌ ବେଳ୍‌, ଜଃନ୍ ତାରାମଃନାର୍‌ ତଃୟ୍‌ ଚିନ୍ ଦଃକାଜାୟ୍‌ଦ୍‌ ଆର୍‌ ହୁର୍ତିବିଜାକ ଲକ୍‌ ମଃନାର୍‌ ବିତ୍ରେ ବିପ୍‌ତି ଗଃଟେଦ୍‌; ସଃମ୍‌ନ୍ଦ୍ ଆର୍‌ ଉଲାଳାର୍‌ ଗଃର୍ଜାଣେ ସେମଃନାର୍‌ ବୁଦି ବାଣା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଆରେକ୍‌ ହୁର୍ତିବି ଉହ୍ରେ ଆସ୍ତି ରିଲା ଗଃଟ୍‍ଣା ମଃନ୍‌ ଡିରିକଃରି ଲକ୍‌ମଃନ୍ ମୁର୍ଚା ହର୍‌ ଅଃଉତି, ବଃଲେକ୍‌ ଅଃଗାସ୍‌ ଉହ୍ରାର୍‌ ସଃକ୍ତିମଃନ୍‌ ଜଃତ୍‌କଃତ୍‌ ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ନଃରାର୍‌ ହୟ୍‌ସିକେ ବଃଡେ ସଃକ୍ତି ଆର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ମେଗେ ଆସ୍ତାର୍‌ ଦଃକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ମଃତର୍‌ ଇ ସଃବୁ ଗଃଟ୍‍ଣା ଆରୁମ୍‌ ଅୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ମୁଣ୍ଡ୍ ଟେକି ଉହ୍ରେ ଦଃକା, ବଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ମୁକୁଳ୍‌ତାର୍‌ ଚଃମେ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଆର୍‌, ସେ ସେମଃନ୍‌କେ ଗଟ୍‌ କଃତା କୟ୍‌ କୟ୍‌ଲା, “ଡୁମ୍ବୁର୍‌ ଆର୍‌ ସଃବୁ ଗଃଚ୍‌ମଃନାର୍‌ କଃତା ବାବି ଦଃକା; ");
INSERT INTO bdv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଜଃଡେବଃଳ୍‌ ସେ ଡାଳ୍‌ ହଃତାର୍‌ମଃନ୍‌ କଃଉଁଣା ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ସେରି ଦଃକି, କଃରା ବିନ୍ ଲଃଗେ ଅୟ୍‌ଲି ବଃଲି ନିଜେ ନିଜେ ଜାଣୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ସେନ୍‌କଃରି ତୁମିମଃନ୍ ହେଁ ଇସଃବୁ ଗଃଟ୍‍ଣା ଦଃକ୍‌ଲେକ୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ଲଃଗେ ଅୟ୍‌ଲି ବଃଲି ଜାଣା ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ମୁୟ୍‌ଁ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଇ ସଃବୁ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ତା ହଃତେକ୍‌ ଅଃବାର୍‌ ଲକ୍‌ମଃନାର୍‌ ବଃଉଁସ୍‌ ନଃବୁଡେ । ");
INSERT INTO bdv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ଅଃଗାସ୍‌ ଆର୍‌ ହୁର୍ତିବି ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌, ମଃତର୍‌ ମର୍‌ କଃତା କଃବେ ନଃସ୍ଟ୍‌ ନଃହୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ବିସୟେ ଜଃଗ୍ରାତ୍‌ ଅୟ୍‌ରିଆ, ଚଃନେମଃନେ ତୁମାର୍‌ ମଃନ୍‌ ମାତୁଆଳି ଆର୍‌ ମଃଦ୍‌ କାଉଁକେ ଆରେକ୍‌ ଜିବ୍‌କାର୍‌ ଗିନେ ଚିତାୟ୍‌ ବୁଡି ରେତା ବଃଳ୍‌ ସେ ଦିନ୍ ଲୁକ୍‌ଣେ ତୁମାର୍‌ ଉହ୍ରେ ଆସେଦ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେରି ହାନ୍ଦା ହର୍‌ ସଃରା ହୁର୍ତିବି ସଃବୁଲକାର୍‌ ଉହ୍ରେ ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ମଃତର୍‌ ଜଃନ୍‌କଃରି ଇ ସଃବୁ ଆଗ୍‌ତୁ ଗଃଟ୍‍ଣା ତଃୟ୍‌ହୁଣି ବଚୁକେ ଆର୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ଚଃମେ ଟିଆ ଅଃଉଁକେ ହାରାସ୍‌ ଇତାକ୍‌ ସଃବୁ ବଃଳ୍‌ ଗଃଉଆରି କଃରି ଜାଗି ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜିସୁ ହଃତିଦିନ୍‌ ମନ୍ଦିରେ ସିକ୍ୟା ଦେତିରିଲା ଆର୍‌ ସଃବୁ ରାତି ବାରାୟ୍‌ ଜାୟ୍‌ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ରେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ଆର୍‌ ସଃବୁ ଲକ୍‌ ମନ୍ଦିରେ ତାର୍‌ ସିକ୍ୟା ସୁଣୁକ୍‌ ହଃତି ସଃକାଳ୍ୟା ତାର୍‌ ତଃୟ୍‌ ଆସ୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ନାଉଁଆର୍‌ କମିର୍‌ ନଃମିସ୍‌ଲା ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଚଃମେ ଅୟ୍‌ ଆସ୍ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ କଃନ୍‌କଃରି ଜିସୁକେ କେ ନଃଜାଣ୍‌ଲା ହର୍‌ ନାସ୍‌ କଃରୁହାର୍ତି, ସେତାର୍‌ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଡିର୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ସଃଡେବଃଳ୍‌ ବାରଗଟ୍‌ ଚେଲା ବିତ୍ରେ ରିଲା ଇସ୍କାରିଅତ୍‌ ନାଉଁଆର୍‌ ଜିଉଦାର୍‌ ମଃନ୍‌ବିତ୍ରେ ସୟ୍‌ତାନ୍‌ ହୁର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ସେତାକ୍‌, ସେ ଜାୟ୍‌, କଃନ୍‌କଃରି କଃରି ଜିସୁକେ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ସଃଇନ୍‌ମଃନାର୍‌ ମୁଳିକାମଃନାର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ସେରି ତାକାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ସେତାକ୍‌ ସେମଃନ୍ ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକେ ଡାବୁ ଦେଉଁକେ ଚିଡାହଡା କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଆର୍‌ ଜିହୁଦା ରାଜି ଅୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଲୁକ୍‌ଣେ ତାକେ ସେମଃନାର୍‌ ଆତେ ସଃର୍ହି ଦେଉଁକ୍‌ ବାଟ ଲଳ୍‌ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ତାର୍‌ହଃଚେ ଜୁୟ୍‌ଦିନ୍‌ ମୁକ୍ଳାଉଣି ହଃର୍ବାର୍‌, ହୁଜାମେଣ୍ଡା ଦେଉଁକ୍‌ ହଃଳେଦ୍‌, ସେ କମିର୍‌ ନଃମିସାଉତା ରୁଟିର୍‌ ହଃର୍ବ୍‌ ହଚ୍‌ଲି; ");
INSERT INTO bdv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଆର୍‌, ଜିସୁ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ ଇରି କୟ୍‌ କଃରି ହଃଟାୟ୍‌ଲା, “ଅଃମିମଃନ୍‌ ଜଃନ୍‌କଃରି କାଉଁ ହାରୁନ୍ଦ୍‌, ଇତାକ୍‌ ତୁମିମଃନ୍ ଜାୟ୍‌ ଅଃମାର୍‌ ଗିନେ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ସେତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ କୁୟ୍‌ ଟାଣେ ଇରି ଟିକ୍‌ କଃରୁନ୍ଦ୍‌ ବଃଲି ତୁୟ୍‌ ମଃନ୍‌ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା ତୁମିମଃନ୍ ଗଃଳ୍‌ ବିତ୍ରେ ହୁରୁହୁରୁ, ଡକାୟ୍‌ ହାଣି ବୟ୍‌ନେତା ଗଟ୍‌ ମାନାୟ୍‌କେ ତୁମିମଃନ୍ ବେଟ୍‌ ହାଉଆସ୍‌, ସେ ଜୁୟ୍‌ ଗଃରେ ହୁରେଦ୍‌, ତାର୍‌ ହଃଚେହଃଚେ ସେ ଗଃରେ ଜାୟ୍‌ ଗଃରାର୍‌ ମୁଳିକାକେ କଃଉଆ, ");
INSERT INTO bdv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଅଃମାର୍‌ ଗୁରୁ ତକେ ହଃଚାରି ଆସୁକ୍‌ ମକେ ହଃଟାୟ୍‌ ଆଚେ, ମୁୟ୍‌ଁ ମର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ କୁୟ୍‌ତି ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କଃରିନ୍ଦ୍‌ ବଃଲି କଃଉଁଲା, କୁୟ୍‌ ବଃକ୍ରାୟ୍‌ କଃରୁନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ସେତି ସେ ତୁମିକେ ଉହ୍ରାର୍‌ ଗଟେକ୍‌ ସୁନ୍ଦୁର୍‌ ବଃଡ୍ ବଃକ୍ରା ଦଃକାୟ୍‌ ଦଃୟ୍‌ଦ୍‌; ସେତି ଟିକ୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ସେତାକ୍‌ ସେମଃନ୍ ଜାୟ୍‌, ଜିସୁ ଜଃନ୍‌କଃରି ସେମଃନ୍‌କେ କୟ୍‌ ରିଲା ସେନ୍‌କାର୍‌ ଦଃକି ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି ଟିକ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ଆରେକ୍‌, ବେଳା ଅୟ୍‌ଲାକ୍‌ ଜିସୁ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ପେରିତ୍‌ମଃନ୍‌ କାଉଁକେ ବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ଦୁକ୍‌ ହାଉତା ହୁର୍ବେ ମୁୟ୍‌ଁ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଇ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କାଉଁକେ ମଃନ୍‌କଃଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌, ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ମାପ୍ରୁର୍‌ ରାଇଜେ ଆର୍‌ ସଃବୁ ବାବ୍‌ ଜାଣା ନଃହେଳ୍‌ତା ହଃତେକ୍‌ କଃବେହେଁ ଇରି କାଉଁନଃଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଆର୍‌ ଜିସୁ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କପାୟ୍‌ ଦଃରି ମାପ୍ରୁକେ ଜୁଆର୍‌ କଃରି ଦଃୟ୍‌ କୟ୍‌ଲା, “ଇରି ନିଆ ନିଜାର୍‌ ନିଜାର୍‌ ବିତ୍ରେ ବାଟା କଃରା, ");
INSERT INTO bdv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ମାପ୍ରୁର୍‌ ରାଇଜ୍‌ ନାସ୍ତା ହଃତେକ୍‌ ମୁୟ୍‌ଁ ଆଜିହୁଣି ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଆରେକ୍‌ କାଉଁନଃଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଆର୍‌, ଜିସୁ ରୁଟିକ୍‌ ଦଃରି ମାପ୍ରୁକେ ଜୁଆର୍‌ କଃରି, ସେରି ବାଙ୍ଗାୟ୍‌ ସେମଃନ୍‌କେ ଦଃୟ୍‌ କଃରି କୟ୍‌ଲା, “ତୁମାର୍‌ ଗିନେ ଦିଆଅୟ୍‌ଲା ମର୍‌ ଗଃଗାଳ୍‌ ଇରି; ମକେ ଏତାଉଁକେ ଇରି କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ସେରଃକମ୍‌ ରୁଟି କାୟ୍‌ଲା ହଃଚେ କପାୟ୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଦଃରି କୟ୍‌ଲା, “ତୁମାର୍‌ ଗିନେ ଦିଆଅୟ୍‌ଲା ମର୍‌ ବଃନି, ଇରି ସେ ତୁମାର୍‌ ଗିନେ ମର୍‌ ବଃନି ତଃୟ୍‌ ଟିକ୍‌ କଃଲା ନଃଉଆଁ ବିଦି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ମଃତର୍‌ ଦଃକା ଜେ ମକେ ସଃତ୍ରୁ ଆତେ ସଃର୍ହି ଦେଉଁଲା, ତାର୍‌ ଆତ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ଟେବୁଲ୍‌ ଉହ୍ରେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମାପ୍ରୁ ଜଃନ୍‌କଃରି ଟିକ୍‌ କଃରିଆଚେ, ନଃରାର୍‌ ହୟ୍‌ସି ସେନ୍‌କଃରି ମଃରୁକ୍‌ ଜଃଉଁଲା ସଃତ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ସଃହ୍ରି ଦେଉଁଲା, ଚି, ସେ ଡଃଣ୍ଡାର୍‌ ଜୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ସେତାକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କେ ଇରି କଃରୁକେ ଜଃଉଁଲା, ସେ କଃତାକ୍‌ ଦଃରି ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଆରେକ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ କେ ବଃଡ୍, ସେ କଃତାକ୍‌ ଦଃରାଦଃରି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଜିଉଦିମଃନାର୍‌ ରଃଜାମଃନ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ରାଜ୍‌ କଃର୍ତି, ଆରେକ୍‌ ସେମଃନ୍ ସେମଃନାର୍‌ ଦେସାର୍‌ ନିଜ୍‌ଲକ୍‌ ବଃଲି ଡାକେ ହୁଟ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମଃତର୍‌ ତୁମିମଃନ୍ ତାକାର୍‌ ହର୍‌ ଅଃଉଆ ନାୟ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଜେ ବଃଡ୍ ସେ ସାନ୍ ହର୍‌ ଅଃଉଅ, ଆର୍‌ ଜେ ମୁଳିକା ସେ ସେବାକାରି ହର୍‌ ଅଃଉଅ । ");
INSERT INTO bdv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ତଃବେ କେ, ବଃଡ୍ ? ଜେ କାଉଁକେ ବଃସେଦ୍‌, କି, ଜେ ସେବା କଃରେଦ୍‌ ? ଜେ କାଉଁକେ ବଃସେଦ୍‌, ସେ କି ବଃଡ୍ ନାୟ୍‌ ? ମଃତର୍‌ ମୁୟ୍‌ଁ ତୁମାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ହର୍‌ ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ମଃତର୍‌ ତୁମିମଃନ୍ ମର୍‌ ସଃବୁ ପରିକ୍ୟାୟ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ଆସୁଲାସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ଇତାକ୍‌ ମର୍‌ ଉବା ଜଃନ୍‌କଃରି ମର୍‌ ଗିନେ ରାଇଜ୍‌ ବାଚ୍‌ଲା ଆଚେ, ମୁୟ୍‌ଁ ହେଁ ସେରଃକମ୍‌ ତୁମାର୍‌ ଗିନେ ବାଚିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଜଃନ୍‌କଃରି ମର୍‌ ରାଇଜେ ମର୍‌ ସଃଙ୍ଗ୍ କାଉଆ ହିଉଆ କଃରାସ୍‌ ଆର୍‌ ସିଙ୍ଗାସଣ୍‌ ଉହ୍ରେ ବଃସି ଇସ୍ରାଏଲାର୍‌ ବାର ବଃଉଁସ୍‌କେ ରାଜ୍‌ କଃରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ସିମନ୍‌, ସିମନ୍, ଦଃକ୍‌ ଗଅଁକେ ଚାଲାଣାୟ୍‌ ଚାଲାଉତା ହର୍‌ ସୟ୍‌ତାନ୍‌ ତୁମିମଃନ୍‌କେ ଚାଲାଉଁକ୍‌ ଅଃଦିକାର୍‌ ହାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ମଃତର୍‌ ତର୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତାର୍‌ ଜଃନ୍‌କଃରି ଉଣା ନାୟ୍‌, ସେତାକ୍‌ ମୁୟ୍‌ଁ ତର୍‌ ଗିନେ ଗଃଉଆରି କଃରୁଲେ । ଆର୍‌ ତୁୟ୍‌ ଆରେକ୍‌ ବାଉଳିଆସି ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ମଃନ୍‌କେ ତିର୍‌କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମଃତର୍‌ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ ମୁୟ୍‌ଁ ତର୍‌ ସଃଙ୍ଗ୍ ଜଃଇଲ୍‌ ଜଃଉଁକେ ଆର୍‌ ମଃରୁକ୍‌ ହେଁ ରାଜି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ମଃତର୍‌ ଜିସୁ କୟ୍‌ଲା, “ଏ ପିତର୍‌, ମୁୟ୍‌ଁ ତକେ କଃଉଁଲେ, ଆଜି ରାତି କୁକ୍‌ଳା ନଃବାସ୍ତେ ତୁୟ୍‌ ମକ୍‌ ନଃଜାଣି ବଃଲି ତିନିତର୍‌ କଃଉସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଆର୍‌, ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍‌କେ ଜାଲିଆ, ମଣା, ଆର୍‌ ହାଣ୍ଡାୟ୍‌ ନଃନେଇଁ ଜଃଉଁକେ ହଃଟାୟ୍‌ରିଲେ, ସଃଡେବଃଳ୍‌ ତୁମାର୍‌ କି କାୟ୍‌ରି ଉଣା ଅୟ୍‌ଲି ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଜିସୁ ସେମଃନ୍‌କେ ଆରେକ୍‌ କୟ୍‌ଲା, “ମଃତର୍‌ ଅଃବେ, ଜାର୍‌ ଜାଲିଆ ମଣା ଆଚେ, ସେ ସେରି ନେଉଅ, ସେବାନ୍ୟା ମଣାହେଁ ନେଉଅ, ଆର୍‌ ଜାର୍‌ ନୟ୍‌, ସେ ଅଃହ୍‌ଣାର୍‌ ଆଙ୍ଗି କଃଣ୍ଡେକ୍‌ ବିକିକଃରି କଃରି କଃଣ୍ଡା ଗେନ । ");
INSERT INTO bdv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ସେ ବିଦିନୟ୍‌ଲା ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଣିତା ଅୟ୍‌ଲା ଇ ଜୁୟ୍‌ କଃତା ଲେକା ଅୟ୍‌ଆଚେ, ସେରି ମର୍‌ ତଃୟ୍‌ ହୁରୁଣ୍ ଅଃଉତା ଲଳା ଆଚେ; ଇତାକ୍‌ ମର୍‌ କଃତା ହୁରୁଣ୍ ଅଃଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ସେତାକ୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଦଃକ୍‌ ଇତି ଜଳେକ୍‌ କଃଣ୍ଡା ଆଚେ ।” ଆର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସଃତେକ୍‌ ସଃରି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଜିସୁ ଗଃଳେହୁଣି ବାରାୟ୍‌, ହଃତିଦିନାର୍‌ ହର୍‌ ବାରାୟ୍‌ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ଗଃଲା ଆର୍‌ ଚେଲାମଃନ୍ ହେଁ ତାର୍‌ ହଃଚେହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ସେଟାଣେ ହଚି ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃନ୍ କଃରି ହାନ୍ଦାୟ୍‌ ନଃହେଳାସ୍‌, ସେତାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଆର୍‌ ସେ ସେମଃନ୍‌କେ ଚାଡି କଃଣ୍ଡେକ୍‌ ଦୁରିକ୍‌ ଜାୟ୍‌ ମାଣ୍ଡିକୁଟା ଟେସି, ଇ ପାର୍ତ୍‌ନା କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ଉବା ଜଦି ତର୍‌ ମଃନ୍‌ ଅୟ୍‌ଦ୍‌ ତଃବେ ଇ ଦୁକ୍‌ ରଃକମାର୍‌ କପା ମର୍‌ ତଃୟ୍‌ହୁଣି ଦୁର୍‌କଃର୍‌; ଅୟ୍‌ଲେକ୍‌ ହେଁ ମର୍‌ ମଃନ୍‌ ନାୟ୍‌, ମଃତର୍‌ ତର୍‌ ଇଚା ହୁରୁଣ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ଆର୍‌, ଗଟ୍‌ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ ତାକେ ସଃକ୍ତି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଆରେକ୍‌, ସେ ଦୁକେ ବାଙ୍ଗିହଃଳି ଏକ୍‌ମଃନେ ପାର୍ତ୍‌ନା କଃରୁକେ ଦଃର୍ଲା ଆର୍‌ ତାର୍‌ ଜଃଳ୍‌ ବଃନିତିହ୍‌ଳା ହର୍‌ ବୁୟେଁ ତିହ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଆର୍‌ ସେ ପାର୍ତ୍‌ନା କଃରି ସଃରାୟ୍‌ ଉଟି ଚେଲାମଃନାର୍‌ ହାକ୍‌ ଆସି ସେମଃନ୍‌କେ ଦୁକାର୍‌ଗିନେ ନିଦଉତାର୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌ତାକ୍‌ ସଃଉଁଲାସ୍‌ ? ଜଃନ୍‌କଃରି ହାନ୍ଦାୟ୍‌ ନଃହେଳାସ୍‌ ଇତାର୍‌ ଗିନେ ଉଟି ପାର୍ତ୍‌ନା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଜିସୁ କଃତା କଃଉତାବଃଳ୍‌, ଦଃକା ଲକ୍‌ମଃନ୍ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ବାରଗଟ୍‌ ଚେଲା ବିତ୍ରେ ଜିଉଦା ନାଉଁଆର୍‌ ଏକ୍ଲା ସେମଃନାର୍‌ ଆଗେ ଆଗେ ଆସି ଜିସୁକେ ଚୁମୁକେ ତାର୍‌ ଚଃମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ମଃତର୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଜିଉଦା, ଚୁମି କଃରି ନଃରାର୍‌ ହୟ୍‌ସିକେ କାୟ୍‌ ସଃତ୍ରୁ ଆତେ ସଃର୍ହି ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ସେତାକ୍‌ କାୟ୍‌ରି ଅୟ୍‌ଦ୍‌ ସେରି ଦଃକି ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ ଅଃମିମଃନ୍‌ କାୟ୍‌ କଃଣ୍ଡା ସଃଙ୍ଗ୍ ମାରୁଆଁ ?” ");
INSERT INTO bdv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ଆର୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ମୁଳ୍‌ ଜାଜକାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ମାରି କଃରି ତାର୍‌ କାତା ବାଟ୍ୟାର୍‌ କାନ୍‌ କାଟି ହଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ମଃତର୍‌ ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ଅଃତେକ୍‌ ସଃରି;” ଆର୍‌ ସେ ଲକାର୍‌ କାନ୍‌ ଚୁଇ, ତାକ୍‌ ଉଜ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଆର୍‌ ଜିସୁ ତାର୍‌ ବିରଦେ ଆସିରିଲା ମୁଳ୍‌ ଜାଜକ୍‌, ମନ୍ଦିର୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ମୁଳ୍‌ ସଃଇନ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ଚର୍‌ ବିରଦେ ବାରୟ୍‌ଲା ହର୍‌ କଃଣ୍ଡା ଆର୍‌ ଟେଙ୍ଗା ଦଃରି ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଦଃରୁକେ ଆୟ୍‌ଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ମୁୟ୍‌ଁ ଦିନେକେ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ମନ୍ଦିରେ ରିଲେ, ମଃତର୍‌ ତୁମିମଃନ୍ ସଃଡେବଃଳ୍‌ ମକ୍‌ ଦଃରୁ ନଃଚ୍‌ଲାସ୍‌, ମଃତର୍‌ ଇରି ତୁମାର୍‌ ବେଳା, ଅଃନ୍ଦାରାର୍‌ ଅଃଦିକାର୍‌ ଇରି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ହଃଚେ ସେମଃନ୍ ଜିସୁକେ ଦଃରିନଃୟ୍‌ ମୁଳ୍‌ ଜାଜକାର୍‌ ଗଃରେ ଆଣ୍‌ଲାୟ୍‌; ମଃତର୍‌ ପିତର୍‌ ଦୁରିକେ ରଃୟ୍‌ କଃରି ହଃଚେ ହଃଚେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ଆର୍‌ ସେମଃନ୍ କୁଆଳେ ଜୟ୍‌ ଲାଗାୟ୍‌ ଗଟେଟାଣେ ବଃସ୍‌ଲାକେ, ପିତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ବଃସିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ଗଟ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳି ତାକେ ଜୟ୍‌ ଲଃଗେ ବଃସିରିଲାର୍‌ ଦଃକି ତାକ୍‌ ସଃଳ୍‌କେ ମୁଏଁ ଦଃକି କୟ୍‌ଲି, “ଇ ଲକ୍‌ ହେଁ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମଃତର୍‌ ପିତର୍‌ ନାୟ୍‌ ବଃଲି କୟ୍‌ଲା, “ଏ ଆୟା, ମୁୟ୍‌ଁ ତାକ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଚଃନେକ୍‌ ଗଃଲାହଃଚେ ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌ ତାକ୍‌ ଦଃକି କୟ୍‌ଲା, “ତୁୟ୍‌ ହେଁ ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ।” ମଃତର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ନାୟ୍‌ ବାୟ୍‌, ମୁଁୟ୍‌ ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ଗଟ୍‌ ଗଃଟା ହଃଚେ ଆରେଗଟ୍‌ ମାନାୟ୍‌ ନିଜ୍‌କଃରି କାଉଁକେ ଦଃର୍ଲା, “ଇମାନାୟ୍‌ ହେଁ ସଃତ୍‌କଃରି ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେତ ଗାଲିଲିର୍‌ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ମଃତର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ବାୟ୍‌ ଜୁୟ୍‌ରି କଃଉଁଲିସ୍‌, ମକ୍‌ ସେରି ଜାଣାନାୟ୍‌ !” ତଃତ୍‌କାଣ୍ ସେ ଇ କଃତା କଃଉଁକଃଉଁ କୁକ୍‌ଳା ବାସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ଆର୍‌, ଜିସୁ ହଃଚ୍‌ବାଟ୍‌ ଉଲ୍‌ଟି କଃରି ପିତର୍‌କେ ସଃଳ୍‌କେ ଦଃକ୍‌ଲା; ଇତାର୍‌ହଃଚେ, “ଆଜି କୁକ୍‌ଳା ବାସ୍ତା ଆଗ୍‌ତୁ ତୁୟ୍‌ ମକେ ତିନିତର୍‌ ନଃଜାଣିବଃଲି କଃଉସି,” ଇ ଜୁୟ୍‌ କଃତା ମାପ୍ରୁ ପିତର୍‌କେ କୟ୍‌ରିଲା, ");
INSERT INTO bdv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ସେରି ତାର୍‌ ମଃନେ ହଃଳ୍‌ଲି, ଆର୍‌ ସେ ହଃଦାୟ୍‌ ବାରାୟ୍‌ ଜଃବର୍‌ ରଦନ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଦଃରି ଜାଗି ରିଲାୟ୍‌, ସେମଃନ୍ ତାକ୍‌ ମାରିମାରି ଗେଙ୍ଗ୍ରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଆର୍‌, ତାକେ ମୁୟେ ତୁଆଲ୍‌ ବାନ୍ଦି ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ତୁୟ୍‌ ତ ବାବ୍‌ବାଣି କଃଉତା ଲକ୍‌, କଃଉ ତକେ କେ ମାର୍‌ଲା ?” ");
INSERT INTO bdv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆରେକ୍‌ ସେମଃନ୍ ଜିସୁକେ ଗାଦେକ୍‌ କଃତା କୟ୍‌ ତାକ୍‌ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ତାର୍‌ହଃଚେ ସଃକାଳ୍‌ ହାୟ୍‌ଲା ଦାହ୍ରେ ଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବେରାଣାର୍‌ ପାରାଚିନ୍ ଆର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ରୁଣ୍ଡି କଃରି ଅଃହ୍‌ଣାମଃନାର୍‌ ବେରାଣ୍‌ମୁଣ୍ଡାୟ୍‌ ନଃୟ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌, “ଜଦି ତୁୟ୍‌ କ୍ରିସ୍ଟ ଅଃମିମଃନ୍‌କ୍‌ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ମଃତର୍‌ କ୍ରିସ୍ଟ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ଜଦି ତୁମିମଃନ୍‌କେ କୟ୍‌ଦ୍‌, ତୁମିମଃନ୍ ସଃତ୍‌ ନଃକେରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ତଃବେ, ମୁୟ୍‌ଁ ଜଦି ହଃଚାରିନ୍ଦ୍‌, ତୁମିମଃନ୍ ଉତୁର୍‌ ନଃଦିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ମଃତର୍‌ ଅଃବେହୁଣି, ନଃରାର୍‌ ହୟ୍‌ସି ବଃଡ୍ ସଃକ୍ତିମାନ୍ ଇସ୍ୱରାର୍‌ କାତାବାଟ୍ୟା ବଃସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ସେତାକ୍‌ ସେମଃନ୍ ସଃବୁଲକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ତୁୟ୍‌ କି ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ?” ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ଁ ସେ ବଃଲି ତୁମି କଃଉଁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ତଃବେ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ସାକିର୍‌ ଦଃର୍‌କାର୍‌ ନାୟ୍‌, ଅଃମିମଃନ୍‌ ତ ନିଜେ ନିଜେ ତାର୍‌ ନିଜାର୍‌ ଟଣ୍ଡେ ହୁଣି ଇରି ସୁଣ୍‌ଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ଆର୍‌ ହଃଚେ ବେରାଣାର୍‌ ସଃବୁଲକ୍‌ ଉଟି ଜିସୁକେ ପିଲାତ ହାକ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଆର୍‌, ସେମଃନ୍ ତାର୍‌ ବିରଦେ, କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ଦଃକ୍‌ଲୁ, ଇ ଲକ୍‌ ଅଃମାର୍‌ ଜାତିକେ ରଃଜାର୍‌ ବିରଦି କଃରାଉଁଲା ଆର୍‌ କାଇସର୍‌କେ ସିସ୍ଟୁ ନଃଦେଉଁକେ କଃଉଁଲା, ଆର୍‌ ନିଜ୍‌କେ କ୍ରିସ୍ଟ ରଃଜାବଃଲି କଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ସେତାକ୍‌ ପିଲାତ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କି ଜିଉଦିମଃନାର୍‌ ରଃଜା ?” ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ତୁୟ୍‌ କଃଉଁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ସେତାକ୍‌ ପିଲାତ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ଇମାନାୟ୍‌ର୍‌ ତଃୟ୍‌ କାୟ୍‌ ଦଃସ୍‌ ହେଁ ନଃହାଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମଃତର୍‌ ସେମଃନ୍ ଆରେକ୍‌ ଜଃବର୍‌ କଃରି କାଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇ ଲକ୍‌ ସଃବୁ ଜିଉଦା ଦେସେ ସିକ୍ୟା ଦଃୟ୍‌କଃରି ଗାଲିଲି ହୁଣି ଆରୁମ୍‌ କଃରି ଇ ଜଃଗା ହଃତେକ୍‌ ହେଁ ଲକ୍‌ମଃନ୍‌କେ ମାତାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ମଃତର୍‌ ପିଲାତ ଇରି ସୁଣି କଃରି ହଃଚାର୍ଲା, “ଇମାନାୟ୍‌ ଗାଲିଲିର୍‌ କି ?” ");
INSERT INTO bdv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ସେ ତ ହେରଦାର୍‌ ରାଜିର୍‌ ଲକ୍‌ ତାର୍‌ ଅଃଦିକାରେ ବଃଲି ଜାଣି କଃରି, ସେ ଜିସୁକେ ହେରଦ୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲା, ବଃଲେକ୍‌ ସେ ହେଁ ସେନ୍‌କାବଃଳ୍‌ ଜିରୁସାଲମେ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରଦ୍‌ ଜିସୁକେ ଦଃକି କଃରି ଅଃନାୟ୍‌ ସଃର୍ଦାଅୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଜିସୁର୍‌ କଃତା ସୁଣିରିଲାକ୍‌ ଆର୍‌ ବୁତ୍‌ଦିନ୍‌ ହୁଣି ତାକ୍‌ ଦଃକୁକ୍‌ ମଃନ୍‌ କଃର୍ତିରିଲା ଆର୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ହେଁ କାବା ଅଃଉତା ଚିନ୍ ଦଃକୁକ୍‌ ଆସା କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ଇତାକ୍‌ ହେରଦ୍‌ କଃତେକ୍‌ କଃତା ଜିସୁକେ ହଃଚାର୍ଲା, ମଃତର୍‌ ଜିସୁ ତାକେ କାୟ୍‌ ଉତୁର୍‌ ହେଁ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଟିଆ ଅୟ୍‌କଃରି ତାର୍‌ ବିରଦେ ଅଃପର୍‌ବଳ୍‌ ଦଃସ୍‌ ଲାଦୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ସେତାକ୍‌ ହେରଦ୍‌ ଆର୍‌ ତାର୍‌ ସଃଇନ୍‌ମଃନ୍‌ ଜିସୁକେ ଲିନ୍ଦାକଃରି ଗେଙ୍ଗ୍ରାୟ୍‌ଲାୟ୍‌, ତାର୍‌ହଃଚେ ସେମଃନ୍ ତାକ୍‌ ରଃଜା ବଃସ୍ତର୍‌ ହିନ୍ଦାୟ୍‌ ପିଲାତ ହାକ୍‌ ଆରେକ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ସେଦିନ୍‌ ହେରଦ୍‌ ଆର୍‌ ପିଲାତ ସଃଙ୍ଗ୍ ଅୟ୍‌ଲାୟ୍‌ ହୁର୍ବେ ସେମଃନାର୍‌ ବିତ୍ରେ ସଃତ୍ରୁ ବାବ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ଇତାର୍‌ ହଃଚେ ପିଲାତ ରଃଜା, ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍‌କେ, ବଃଡ୍ ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ କୁଦି ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ଇମାନାୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ବିରଦ୍‌ କଃରାଉଁଲା ବଃଲି ତୁମିମଃନ୍ ଆକ୍‌ ମର୍‌ହାକ୍‌ ଆଣ୍‌ଲାସ୍‌; ଆର୍‌ ଦଃକା ଅଃମି ତୁମିମଃନାର୍‌ ଚଃମେ ଆକ୍‌ ହଃଚାର୍‌ଲେକ୍‌ ତାର୍‌ ବିରଦେ ତୁମିମଃନ୍ ଜୁୟ୍‌ ସଃବୁ ଦଃସ୍‌ ଦେଉଁଲାସ୍‌, ସେନ୍‌କାର୍‌ କାୟ୍‌ ଦଃସ୍‌ ଇତାର୍‌ ଲଃଗେ ହାଉଁ ନଃହାର୍ଲେ । ");
INSERT INTO bdv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ହେରଦ୍‌ ହେଁ କାୟ୍‌ ଦଃସ୍‌ ନଃହାୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ତାକ୍‌ ଅଃମାର୍‌ ଚଃମେ ଆରେକ୍‌ ହଃଟାୟ୍‌ଲା; ଆର୍‌ ଦଃକା ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତା କାୟ୍‌ କାମ୍‌ ନଃକେରେ; ");
INSERT INTO bdv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ସେତାକ୍‌ ମୁଁୟ୍‌ ଆକ୍‌ ଡଃଣ୍ଡ୍‌ ଦଃୟ୍‌ ଚାଡି ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ହଃତି ମୁକ୍ଳାଉଣି ହଃର୍ବେ ସେମଃନାର୍‌ ଗିନେ ତାକ୍‌ ଗଟ୍‌ କଃୟ୍‌ଦିକେ ମୁକ୍‌ଳାଉତାର୍‌ ଅଃଉତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ମଃତର୍‌ ସେମଃନ୍ ସଃବୁଲକ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଆକ୍‌ ମଃର୍ନେ ମାରା, ଅଃମାର୍‌ ଗିନେ ବାରବାକେ ଚାଡା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ସେ ବାରବା ଗଃଳ୍‌ ବିତ୍ରେ ଅୟ୍‌ରିଲା ଗଣ୍ଡ୍‌ଗଳାର୍‌ ଗିନେ ଆର୍‌ ନଃର୍‌ ଅଃତ୍ୟା ଗିନେ ଜଃଇଲେ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ମଃତର୍‌ ପିଲାତ ଜିସୁକେ ମୁକ୍‌ଳାଉଁକେ ମଃନ୍‌ କଃରି ସେମଃନ୍‌କେ ଆରେକ୍‌ ବୁଜାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ମଃତର୍‌ ସେମଃନ୍ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ, କ୍ରୁସେ ଚଃଗାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ମଃତର୍‌ ପିଲାତ ଇତାର୍‌ ସଃଙ୍ଗ୍ ତିନିତର୍‌ କୟ୍‌ଲା, “କାୟ୍‌କଃରୁକ୍‌, ସେ କାୟ୍‌ ଦଃସ୍‌ କଃଲା ଆଚେ ? ମୁୟ୍‌ଁ ତାର୍‌ ତଃୟ୍‌ ମଃର୍ନ୍‌ଡଃଣ୍ଡ୍‌ ହାଉତା କାୟ୍‌ ଦଃସ୍‌ ହେଁ ନଃହାଉଁଲେ; ଅଃମି ତାକେ ଡଃଣ୍ଡ୍‌ ଦଃୟ୍‌ କଃରି ଚାଡୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମଃତର୍‌ ତାକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ ବଃଲି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ ବଃଡ୍‌ଟଣ୍ଡ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନାର୍‌ କୟ୍‌ଲା କଃତା ହଃର୍କାରେ ହୁରୁଣ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ଆର୍‌ ସେମଃନାର୍‌ କଃତା ହଃର୍କାରେ କଃରା ଜଃଉଅ ବଃଲି ପିଲାତ ତିର୍‌ କଃରି ଆଦେସ୍‌ ଦିଲା; ");
INSERT INTO bdv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ମଃତର୍‌ ଗଣ୍ଡ୍‌ଗଳ୍‌ ଆର୍‌ ନଃର୍‌ ଅଃତ୍ୟା ଗିନେ ଜଃଇଲେ ରିଲା ଜୁୟ୍‌ ଲକାର୍‌ ଗିନେ ସେମଃନ୍ କଃଉତି ରିଲାୟ୍‌, ତାକ୍‌ ସେ ଚାଡି ଦିଲା, ଆର୍‌ ଜିସୁକେ ସେ ସେମଃନାର୍‌ ଇଚା ହଃର୍କାରେ କଃରୁକେ ସଃହ୍ରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ସେମଃନ୍ ଜିସୁକେ ନେତାବଃଳ୍‌ ଗଟ୍‌ ସାନ୍‌ ଗାଉଁଏହୁଣି ଗଃଳ୍‌ହାକ୍‌ ଆସ୍ତି ରିଲା ସିମନ୍ ନାଉଁଆର୍‌ ଗଟେକ୍‌ କୁରିଣିୟ ଲକ୍‌କେ ଦଃରି ଜିସୁର୍‌ ହଃଚେହଃଚେ କ୍ରୁସ୍‌ ବୟ୍‌ ଜଃଉଁକେ ତାର୍‌ କଃନ୍ଦେ ସେ କ୍ରୁସ୍‌ ଲାଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ଆରେକ୍‌ ଲକ୍‌ମଃନାର୍‌ ଆର୍‌ ତାର୍‌ ଗିନେ ବୁକେ ମାରି ଅୟ୍‌ କାନ୍ଦ୍‌ତା ମାୟ୍‌ଜିମଃନାର୍‌ ଗାଦେକ୍‌ ମଃନ୍ଦା ଜିସୁର୍‌ ହଃଚେ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମଃତର୍‌ ଜିସୁ, ସେମଃନାର୍‌ ବାଟ୍ୟା ଉଲ୍‌ଟି ଦଃକି କୟ୍‌ଲା, “ଏ ଜିରୁସାଲମାର୍‌ ଆୟାମଃନ୍‌, ମର୍‌ ଗିନେ କାନ୍ଦା ନାୟ୍‌ଁ, ମଃତର୍‌ ନିଜାର୍‌ ଗିନେ ଆର୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ହିଲାମଃନାର୍‌ ଗିନେ କାନ୍ଦା । ");
INSERT INTO bdv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦଃକା, ଜୁୟ୍‌ମଃନ୍‌ ବାଞ୍ଜି, ଆରେକ୍‌ ଜୁୟ୍‌ମଃନ୍‌ କଃବେ ହେଁ ଆଙ୍ଗେ ଅଃଉଁକେ ନାୟ୍‌ ଆର୍‌ ହିଲାକ୍‌ ଦୁଦ୍‌ ନଃକାଳାଉତି, ସେମଃନ୍‌କେ ଲକ୍‌ମଃନ୍ ଜଃଡେବଃଳ୍‌ ବାୟ୍‌ଗ୍‌, ବାୟ୍‌ଗ୍‌ ବଃଲି କଃଉତି ଇବାନ୍ୟା ବେଳା ଆସୁଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ଡଙ୍ଗୁର୍‌ମଃନ୍‌କେ କଃଉତି, ଅଃମାର୍‌ ଉହ୍ରେ ଅଦୁର୍‌, ହଃର୍ବାତ୍‌ମଃନ୍‌କେ କଃଉତି ଅଃମିମଃନ୍‌କ୍‌ ଲୁକାଉ । ");
INSERT INTO bdv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଲକ୍‌ମଃନ୍ ଜଦି କଃଚା ଦାରୁକ୍‌ ଅଃନ୍‌ କଃରୁଲାୟ୍‌, ତଃବେ ସୁକ୍‌ଲା ଦାରୁକ୍‌ କଃନ୍‌କଃରି ନଃକେର୍‌ତି ?” ");
INSERT INTO bdv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଆରେକ୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତା ଜୁଳେକ୍‌ ଚର୍‌ମଃନ୍‌କେ ହେଁ ତାର୍‌ ସଃଙ୍ଗ୍ ନେତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଆର୍‌ ସେମଃନ୍ “କଃହାଳ୍‌” ନାଉଁଆର୍‌ ଜଃଗାୟ୍‌ ହଚି ସେତି ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାୟ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ଚର୍‌ମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲାକେ ଜିସୁର୍‌ କାତାବାଟ୍ୟା ଆରେକ୍‌ ଏକ୍ଲାକେ ଡେବ୍ରିବାଟ୍ୟା କ୍ରୁସ୍‌କାଟେ ଚଃଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ସଃଡେବଃଳ୍‌ ଜିସୁ କୟ୍‌ଲା, “ଉବା, ଇ ଲକ୍‌ମଃନ୍‌କାର୍‌ ହାହ୍‌ କେମା କଃର୍‌, ବଃଲେକ୍‌ ଇ ଲକ୍‌ମଃନ୍ କାୟ୍‌ କଃରୁଲାୟ୍‌ ସେରି ଜାଣୁ ନଃହାରୁଲାୟ୍‌ ।” ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ବଃସ୍ତର୍‌ ବାଟା କଃରୁକେ କେଳିବାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ଆରେକ୍‌ ମୁଳିକାମଃନ୍‌ ଟିଅୟ୍‌ କଃରି ଦଃକ୍‌ତି ରିଲାୟ୍‌, ଆର୍‌ ବଃଡ୍ ଲକ୍‌ମଃନ୍ ହେଁ ତାକ୍‌ ଗେଙ୍ଗ୍ରାୟ୍‌କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ସେ ବିନ୍ ଲକ୍‌କେ ବାଚାୟ୍‌ଲା; ସେ ଜଦି ଇସ୍ୱର୍‌ ବାଚ୍‌ଲା କ୍ରିସ୍ଟ ତଃବେ ନିଜ୍‌କେ ବଚାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ତାର୍‌ହଃଚେ ସଃଇନ୍‌ମଃନ୍‌ ହେଁ ଆସି ତାକ୍‌ ହିତା ରଃସ୍‌ ଦଃୟ୍‌ ଗେଙ୍ଗ୍ରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ତୁୟ୍‌ ଜଦି ଜିଉଦିମଃନାର୍‌ ରଃଜା ନିଜ୍‌କେ ବଚାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଆର୍‌ ତାର୍‌ ମୁଣ୍ଡ୍ ଉହ୍ରାର୍‌ କାଟେ ଇରି ଲେକା ଅୟ୍‌ରିଲି, “ଏ ଜିଉଦିମଃନାର୍‌ ରଃଜା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ଆର୍‌, କ୍ରୁସ୍‌ଉହ୍ରେ ରିଲା ଚର୍‌ମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ଲିନ୍ଦା କଃରି କଃଉଁକେ ଦଃର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ କ୍ରିସ୍ଟ ନୟ୍‌ ? ତୁୟ୍‌ ନିଜ୍‌କେ ଆର୍‌ ଅଃମିକ୍‌ ବଚାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମଃତର୍‌ ବିନ୍ ଚର୍‌ ତାକେ ଦଃକାଦଃୟ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ହେଁ ସଃମାନ୍ ବିଚାର୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁଲିସ୍‌, ଇସ୍ୱର୍‌କେ କାୟ୍‌ ତର୍‌ ଡିର୍‌ ହେଁ ନାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଆର୍‌ ଅଃମିମଃନ୍‌ ସିନା ନ୍ୟାୟ୍‌ ହଃର୍କାରେ ଡଃଣ୍ଡ୍‌ ହାଉଁଲୁ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଦଃସାର୍‌ ହାୟ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁଲୁ, ମଃତର୍‌ ଇ ମାନାୟ୍‌ କାୟ୍‌ ଦଃସ୍‌ ହେଁ ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଆର୍‌ ସେ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ଜିସୁ, ତୁୟ୍‌ ନିଜାର୍‌ ରାଇଜେ ଗଃଲେକ୍‌ ମକେ ଏତାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ସେତାକ୍‌ ଜିସୁ ତାକେ କୟ୍‌ଲା, “ମୁଁୟ୍‌ ତକେ ସଃତ୍‌ କଃଉଁଲେ, ଆଜି ତୁୟ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ସଃର୍ଗ୍‌ ରାଜାୟ୍‌ ହଚ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ସଃଡେବଃଳ୍‌ ମୁଣ୍ଡେବେଳ୍‌ ଅୟ୍‌ରିଲି, ଆର୍‌ ବେଳ୍‌ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଲାକ୍‌, ତିନିଗଃଟା ହଃତେକ୍‌ ଦେସ୍‌ଜାକ ଅଃନ୍ଦାର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଆର୍‌, ମନ୍ଦିର୍‌ ବିତ୍ରାର୍‌ ପବିତ୍ର ଟାଣ୍ ଆର୍‌ ବଃଡ୍‌ ପବିତ୍ର ଟାଣକ୍‌ ଦୁୟ୍‌ ବାଗ୍ କଃର୍ତା ହଃଚ୍ୟା ପର୍ଦା ମଃଜାୟ୍‌ ହୁଣି ଦୁୟ୍‌ ହଳା ଅୟ୍‌ ଚିରି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଆର୍‌ ଜିସୁ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୁଦ୍‌ଲା, “ଏ ଉବା, ତର୍‌ ଆତେ ମୁଁୟ୍‌ ମର୍‌ ଆତ୍ମା ସଃର୍ହି ଦେଉଁଲେ, ଇରି କୟ୍‌କଃରି ଜିବନ୍ ଚାଡ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ହାଁଚ୍ କଳି ସଃଇନ୍‌ମଃନାର୍‌ ଉହ୍ରେ ବଃଡ୍ ସଃଇନ୍‌ ଇ ଗଃଟ୍‍ଣା ଦଃକି, ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରି କୟ୍‌ଲା, “ଇମାନାୟ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଗଟ୍‌ ଦଃର୍ମି ଲକ୍‌ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଆର୍‌, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଦଃକୁକ୍‌ ରୁଣ୍ଡିରିଲାୟ୍‌, ସେମଃନ୍ ସେରିଦଃକି ବୁକେ ମାରି ଅୟ୍‌ ଅୟ୍‌ ଗଃରେ ବାଉଳି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ମଃତର୍‌ ଜିସୁର୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍ ଆର୍‌ ଗାଲିଲିହୁଣି ଗଟେତଃୟ୍‌ ମିସି ତାର୍‌ ହଃଚେହଃଚେ ଆସିରିଲା ଟକିମଃନ୍‌ ଦୁରିକ୍‌ ଟିଆ ଅୟ୍‌ ଇସଃବୁ ଦଃକ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଆର୍‌ ଦଃକା ଜିଉଦିମଃନାର୍‌ ହାରାମାତିଆ ଗଃଳାର୍‌ ଜସେପ୍ ନାଉଁଆର୍‌ ଗଟେ ମାନାୟ୍‌ ବେରାଣ୍‌ମୁଣ୍ଡାର୍‌ ଲକ୍‌ ରିଲା, ସେ ଗଟେକ୍‌ ସଃତ୍‌ ଆର୍‌ ଦଃର୍ମି ଲକ୍‌ ରିଲା; ");
INSERT INTO bdv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ସେ ଜିଉଦିମଃନାର୍‌ ହଃନ୍ଦି ଆର୍‌ କୁଟ୍‌ କଃତାୟ୍‌ ରାଜି ଅୟ୍‌ନଃରିଲା ଆର୍‌ ମାପ୍ରୁର୍‌ ରାଇଜ୍‌କେ ଜାଗ୍‌ତିରିଲା ହାରାମାତିଆ । ");
INSERT INTO bdv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ସେ ପିଲାତ ହାକ୍‌ ଜାୟ୍‌ ଜିସୁର୍‌ ମଃଲା ଗଃଗାଳ୍‌କେ ମାଗ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଆର୍‌ ସେରି ଉତ୍ରାୟ୍‌ ଆଣି, ମଃସ୍‌ଣି ହଃଚ୍ୟା ଗୁଳ୍ୟାୟ୍‌ ଜୁୟ୍‌ତିକି କଃବେ କାକେ ହେଁ ସେତି ସଃଙ୍ଗାୟ୍‌ ନଃରିଲାୟ୍‌, ଅଃନ୍‌କା ଡଙ୍ଗ୍ରେ କଃଣିରିଲା ମଃସୁଣ୍‌ କାଲେ ତାକେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ସେଦିନ୍‌ ତିଆର୍‌ ଅଃଉତା ଦିନ୍ ରିଲି ଆର୍‌ ବିସାଉଁଣିବାର୍‌ ଆରୁମ୍‌ ଅଃଉତି ରିଲି । ଆର୍‌ ସେମଃନ୍ ବିସାଉଣିଦିନ୍‌ ବିସାୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେରି ଦଃର୍ମ୍‌ସାସ୍ତରେ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଇତାର୍‌ହଃଚେ ଗାଲିଲି ହୁଣି ତାର୍‌ସଃଙ୍ଗ୍ ଆସିରିଲା ମାୟ୍‌ଜି ଟକିମଃନ୍‌ ହଃଚେହଃଚେ ଜାୟ୍‌ ମଃସୁଣ୍‌ କାଲ୍‌ ଆର୍‌ କଃନ୍‌କଃରି ତାର୍‌ ଗଃଗାଳ୍‌ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌ ସେରି ଦଃକ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ଆରେକ୍‌ ସେମଃନ୍ ବାଉଳି ଜାୟ୍‌ ବାସ୍ନା ଗୁଣ୍ଡ୍ ଆର୍‌ ଚିକଣ୍‌ମଃନ୍‌ ତିଆର୍‌ କଃଲାୟ୍‌ । ଆର୍‌ ବିସାଉଁଣିବାରେ ସେମଃନ୍ ବିଦି ହଃର୍କାରେ ବିସାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ଆର୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ସେମଃନ୍ ବିଦି ହଃର୍କାରେ ବିସାୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ସାତ୍‌ ଦିନାର୍‌ ହଃର୍ତୁମ୍‌ ଦିନ୍ ବର୍‌ ସଃକାଳ୍ୟା ସେମଃନ୍ ସେମଃନାର୍‌ ତିଆର୍‌ କଃଲାର୍‌ ବାସ୍ନା ଚିକଣ୍‌ ଦଃରି ମଃସ୍‌ଣେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଆରେକ୍‌ ସେତି ସେମଃନ୍ ମଃସୁଣ୍‌ କାଲେ ଡାହ୍‌ଲା ଟେଳା ବିନେ ଗୁଚାଇରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ମଃତର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ଜିସୁ ମାପ୍ରୁର୍‌ ଗଃଗାଳ୍‌ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ସେତାର୍‌ଗିନେ ସେମଃନାର୍‌ ବୁଦି ବାଣା ଅଃଉତି ରିଲି, ଆର୍‌ ଅଃନ୍‌କା ବେଳାୟ୍‌ ଦଃକା, ଉଜାଳ୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦ୍‌ଲା ଦୁୟ୍‌ ଲକ୍‌ ସେମଃନାର୍‌ ଲଃଗେ ହଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ସେତାକ୍‌ ସେମଃନ୍ ଡିରି କଃରି ମୁଁ ତଃଳେ ଅଦ୍ରାୟ୍‌ ରିଲାକ୍‌, ସେମଃନ୍ ସେ ମାୟ୍‌ଜିମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌, “ମଃଲା ଲକାର୍‌ ବିତ୍ରେ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଜିବନ୍ ଲକେ ଲଳୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଜିସୁ ଇତି ନାୟ୍‌, ମଃତର୍‌ ସେ ଉଟି ଆଚେ । ସେ ଗାଲିଲି ରିଲାବଃଳ୍‌ ତୁମିମଃନ୍‌କେ କୟ୍‌ରିଲା ସେରି ଏତାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ନଃରାର୍‌ ହୟ୍‌ସି ବାୟ୍‌ଦ୍‌ରେ ହାହିମଃନାର୍‌ ଆତେ ସଃହ୍ରିଅୟ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ମଃରେଦ୍‌ ଆର୍‌ ତିନିଦିନାର୍‌ ହଃଚେ ମଃର୍ନେହୁଣି ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ସେତାକ୍‌ ସେମଃନ୍ ସେ କଃତା ଏତାୟ୍‌ଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଆର୍‌ ମଃସୁଣ୍‌ କାଲେ ହୁଣି ବାରାୟ୍‌ ଜାୟ୍‌ ଏଗାର୍‌ଗଟ୍‌ ଚେଲା ଆର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ ଇ କଃତା ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଏମଃନ୍‌ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଆର୍‌ ଜହନା, ଆର୍‌ ଜାକୁବାର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌, ଆର୍‌ ସଃଙ୍ଗେ ରିଲା ବିନ୍ ମାଇଜିମଃନ୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଇସଃବୁ କଃତା ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମଃତର୍‌ ସେମଃନାର୍‌ ଇ ସଃବୁ କଃତା ମିଚ୍ ହର୍‌ ଲାଗ୍‌ଲି ଆର୍‌ ସେମଃନ୍ ସେମଃନ୍‌କେ ସଃତ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ମଃତର୍‌ ପିତର୍‌ ଉଟି ମଃସୁଣ୍‌ କାଲେ ଦଃବ୍‌ଳି ଗଃଲା ଆର୍‌ ଲଃହ୍‌ଟି କଃରି ଦଃକି ଅଃକାୟ୍‌ ମଃସ୍‌ଣି ହଃଚ୍ୟା ସଃବୁ ଦଃକ୍‌ଲା, ଆର୍‌ ସେ ଇ ଗଃଟ୍‍ଣା ବିସୟେ କାବା ଅୟ୍‌ ତାର୍‌ ଗଃରେ ବାଉଳି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ଆର୍‌, ଦଃକା ସେଦିନ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ଲକ୍‌ ଜିରୁସାଲମେ ହୁଣି ହଃକାହାକି ଚାରି କସ୍‌ ଦୁରି ଇମାୟୁ ନାଉଁଆର୍‌ ଗାଉଁଏ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଇ ସଃବୁ ଗଃଟ୍‍ଣାର୍‌ କଃତା ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ସେମଃନ୍ କଃଉଆକଇ ଆର୍‌ କଃତା ଦଃରାଦଃରି ଅଃଉତାବଃଳ୍‌ ଜିସୁ ସେମଃନାର୍‌ ଲଃଗେ ହଚି ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ସଃଙ୍ଗ୍ ଜଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ମଃତର୍‌ ସେମଃନାର୍‌ ଆକି ଅଃନ୍‌କାର୍‌ ମୁଦି ଅୟ୍‌ରିଲି ଜେ, ସେମଃନ୍ ଜିସୁକେ ଚିନୁ ନାହାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଇଣ୍ଡି ଇଣ୍ଡି ଜୁୟ୍‌ ସଃବୁ କଃତା ତୁମାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅଃଉଁଲାସ୍‌ ସେରି ସଃବୁ କାୟ୍‌ରି ?” ସେତାକ୍‌ ସେମଃନ୍ ଦୁକାର୍‌ ଗିନେ ମୁଁ ସୁକାୟ୍‌ ଟିଆଅୟ୍‌ରିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଆର୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ କ୍ଲେୟପା ନାଉଁରା ଏକ୍ଲା ତାକେ ଉତୁର୍‌ ଦିଲା, “ଜିରୁସାଲମେ ରେତା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ତୁୟ୍‌ କାୟ୍‌ ଏକ୍ଲା, ସେ ଟାଣାର୍‌ ଇ କଃତି ଦିନାର୍‌ ଗଃଟ୍‍ଣା ନଃଜାଣ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “କାୟ୍‌ କାୟ୍‌ ଗଃଟ୍‍ଣା ?” ସେମଃନ୍ ତାକେ କୟ୍‌ଲାୟ୍‌, “ନାଜରିତ୍‌ ଜିସୁର୍‌ କଃତା; ସେ ଇସ୍ୱର୍‌ ଆର୍‌ ସଃବୁଲକାର୍‌ ଆକାୟ୍‌, କାମେ ଆର୍‌ କଃତାୟ୍‌ ହେଁ ସେ ଗଟ୍‌ ବପୁକାରି ବାବ୍‌ବାଦି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଆର୍‌, ଅଃମାର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ମୁଳିକାମଃନ୍‌ କଃନ୍‌କଃରି ମଃର୍ନ୍‌ ବିଚାର୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ସଃହ୍ରିକଃରି ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ମଃର୍ନେ ମାର୍‌ଲାୟ୍‌ ସେ ସଃବୁ କଃତା । ");
INSERT INTO bdv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ମଃତର୍‌ ଜେ ଇସ୍ରାଏଲ୍‌କେ ରଃକ୍ୟା କଃରେଦ୍‌, ସେ ଜେ ଇମାନାୟ୍‌ ସେରି ଅଃମିମଃନ୍‌ ଆସା କଃରି ରିଲୁ; ମଃତର୍‌ ସେରି ଚାଡି ଇରିମଃନ୍‌ ଗଃଟି ତିନି ଦିନ୍‌ ଅୟ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଆରେକ୍‌ କଃତିଗଟ୍‌ ଟକିହିଲାମଃନ୍‌ ଅଃମିକ୍‌ କାବା କଃରିଆଚ୍‌ତି; ସେମଃନ୍ ଉଟ୍‌ଲାସଃକାଳ୍‌ ମଃସୁଣ୍‌ ହଃଦାୟ୍‌ ଜାୟ୍‌ ରିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ଆର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ନଃହାୟ୍‌ ଆସି କୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଦୁତ୍‌ମଃନ୍‌କେ ଦଃକ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌ ସେ ଜିବନ୍‌ ହାୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଆର୍‌ କଃତିଗଟ୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌ ମଃସୁଣ୍‌ ବିତ୍ରେ ଜାୟ୍‌ ମାୟ୍‌ଜି ଟକିମଃନ୍‌ ଜଃନ୍‌କଃରି କୟ୍‌ରିଲାୟ୍‌, ସେବାନ୍ୟା ଦଃକ୍‌ଲାୟ୍‌, ମଃତର୍‌ ତାକ୍‌ ନଃଦେକ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ନିର୍ବୁଦିଆମଃନ୍‌ ଆର୍‌ ବାବ୍‌ବାଦିମଃନ୍ କୟ୍‌ଲା କଃତାୟ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେର୍ତା ସିତୁଳ୍‌ ମଃନ୍‌ ଲକ୍‌ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଇ ସଃବୁ ଦୁକ୍‌କଃସ୍ଟ ହାୟ୍‌ ନିଜାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ସଃଙ୍ଗ୍ ଜାତାର୍‌ କାୟ୍‌ କ୍ରିସ୍ଟର୍‌ ଦଃର୍‌କାର୍‌ ନଃରିଲି ?” ");
INSERT INTO bdv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ସେତି ସେ ମସା ଆର୍‌ ସଃର୍ନେ ବାବ୍‌ବାଦିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଆରୁମ୍‌ କଃରି ସଃବୁ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଅଃହ୍‌ଣାର୍‌ ସଃବୁ କଃତାର୍‌ ବାବ୍‌ ସେ ସେମଃନ୍‌କେ ବୁଜାୟ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଆର୍‌ ସେମଃନ୍ ଜୁୟ୍‌ ଗାଉଁଏ ଜାତିରିଲାୟ୍‌, ସେ ଗାଉଁ ଲଃଗାଲଃଗି ଅୟ୍‌ଲାକ୍‌, ଜିସୁ ଆରେକ୍‌ ଆଗ୍‌ହାକ୍‌ ଗଃଲାହର୍‌ ଅୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମଃତର୍‌ ସେମଃନ୍ ତାକ୍‌ ତେବାୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ସଃଙ୍ଗେ ରେବେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃଞ୍ଜ୍ ଅୟ୍‌ ଆସୁଲି ଆର୍‌ ବେଳ୍‌ ବୁଡ୍‌ଲିନି ।” ସେତାକ୍‌ ଜିସୁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରେଉଁକେ ଗଃର୍‌ବିତ୍ରେ ହୁର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଆର୍‌, ଜିସୁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସ୍‌ଲାବଃଳ୍‌ ସେ ରୁଟି ଦଃରି ଆସିର୍ବାଦ୍‌ କଃଲା ଆର୍‌ ସେରି ବାଙ୍ଗାୟ୍‌ ସେମଃନ୍‌କେ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ସେତାକ୍‌ ସେମଃନାର୍‌ ଆକି ଉଗାଳି ଅୟ୍‌ଲି ଆର୍‌ ସେମଃନ୍ ତାକ୍‌ ଚିନ୍‌ଲାୟ୍‌ । ଆର୍‌ ତାର୍‌ହଃଚେ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ତାକାର୍‌ ଆକାୟ୍‌ ମଃୟାଁ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ସେତାକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କୟ୍‌ଲାୟ୍‌, “ଜଃଡେବଃଳ୍‌ ବାଟେ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା ଅଃଉତି ରିଲା ଅଃମିମଃନ୍‌କ୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ବୁଜାଉତି ରିଲା, ସଃଡେବଃଳ୍‌ କାୟ୍‌ ଅଃମାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଉକୁଳ୍‌ତି ନଃରିଲି ?” ");
INSERT INTO bdv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ଆର୍‌ ତଃତ୍‌କାଣ୍ ସେମଃନ୍ ଉଟି ଜିରୁସାଲମେ ବାଉଳି ଜାୟ୍‌ ରୁଣ୍ଡିରିଲା ଏଗାର୍‌ଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ଆର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍‌କେ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ସେମଃନ୍ କଃଉତି ରିଲାୟ୍‌, “ମାପ୍ରୁ ବାୟ୍‌ଦ୍‌ରେ ଉଟିଆଚେ ଆର୍‌ ସିମନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ଆରେକ୍‌, ସେମଃନ୍ ଜାତା ବାଟେ ସଃବୁ ଗଃଟି ରିଲାର୍‌ ଆର୍‌ ରୁଟି ବାଙ୍ଗାୟ୍‌ ଦିଲାର୍‌ କଃନ୍‌କଃରି ସେ ମଃନ୍‌କେ ଚିନାୟ୍‌ ଅୟ୍‌ଲା, ସେରିମଃନ୍‌ ହେଁ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ମଃତର୍‌ ସେମଃନ୍ ଇ ସଃବୁ କଃତା କଃଉତା ବଃଳ୍‌ ଜିସୁ ମାପ୍ରୁ ନିଜେ ସେମଃନାର୍‌ ମଃଜାୟ୍‌ ଟିଆଅୟ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ସୁସ୍ତା ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମଃତର୍‌ ସେମଃନ୍ ଦଃକିକଃରି କାବା ଅୟ୍‌ ଡିର୍‌ଲାୟ୍‌ ଆର୍‌ ଗଟେକ୍‌ ବୁତ୍‌ଆତ୍ମା ଦଃକୁଲୁ ବଃଲି ମଃନେ ବାବ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାୟ୍‌କଃରୁକ୍‌ ଜଃଜ୍‌କି ଜଃଉଁଲାସ୍‌ ? ଆର୍‌ ତୁମାର୍‌ ମଃନ୍‌ବିତ୍ରେ କାୟ୍‌ତାକ୍‌ ସଃତ୍‌ ନଃକେରି କଃତାବାର୍ତା ଅଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଇରି ତ ନିଜେ ମୁଁୟ୍‌ ମାନାୟ୍‌, ମର୍‌ ଆତ୍‌ ଆର୍‌ ହାଦ୍‌ ଦଃକା, ମକ୍‌ ଚୁୟ୍‌କଃରି ଦଃକା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ଜଃନ୍‌କାର୍‌ ମାସ୍‌ ଆର୍‌ ଆଡ୍ ତୁମିମଃନ୍ ଦଃକୁଲାସ୍‌ ବୁତ୍‌ଆତ୍ମା ମଃନାର୍‌ ସେନ୍‌କାର୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଆର୍‌ ସେ ଇରି କୟ୍‌, ସେମଃନ୍‌କେ ନିଜାର୍‌ ଆତ୍‌ ଆର୍‌ ହାଦ୍‌ ଦଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ସେମଃନ୍ ସଃତ୍‌ ନଃକେଲାୟ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ କାବା ଅୟ୍‌ ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌; ତଃବେ ଜିସୁ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମାର୍‌ ଲଃଗେ କାୟ୍‌ରି କାତାର୍‌ ଆଚେ କି ?” ");
INSERT INTO bdv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ସେତାକ୍‌ ସେମଃନ୍ କଃଣ୍ଡେକ୍‌ ବାଜ୍‌ଲା ମାଚ୍ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଆର୍‌, ଜିସୁ ସେରି ନଃୟ୍‌ ସେମଃନାର୍‌ ମୁଏଁ କାୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମସାର୍‌ ବିଦିଲଃଗେ ଆର୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ଆର୍‌ ଗିତ୍‌ସହିତା ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଲଃଗେ ମର୍‌ କଃତା ଲେକାଅୟ୍‌ ଆଚେ, ସେରିମଃନ୍‌ ବାୟ୍‌ଦ୍‌ରେ ହୁର୍ନ୍‌ ଅୟ୍‌ଦ୍‌, ମୁଁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରିଲାବଃଳ୍‌ ତୁମିମଃନ୍‌କେ ଇ ସଃବୁ କଃତା କୟ୍‌ରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଜଃନ୍‌କଃରି ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ବୁଜୁ ହାର୍ତି ସେତାର୍‌ଗିନେ ଜିସୁ ସେମଃନାର୍‌ ବୁଦିର୍‌ ଦୁଆର୍‌ ଉଗାଳ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଆର୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃନ୍‌କଃରି ଲେକା ଆଚେ କ୍ରିସ୍ଟ ଦୁକ୍‌ ବୟଃଗ୍ କଃରେଦ୍‌ ଆର୍‌ ତିନିଦିନ୍‌କେ ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଉଟେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆରେକ୍‌ ଜିରୁସାଲମେ ହୁଣି ଆରୁମ୍‌ କଃରି ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ତାର୍‌ ନାଉଁଏ ହାହ୍‌ କେମା ହାଉଁକେ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆସ୍ତା କଃତା ପର୍ଚାର୍‌ କଃରାଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ତୁମିମଃନ୍ ଇସଃବୁ କଃତାର୍‌ ସାକି ଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଆରେକ୍‌ ଦଃକା, ମର୍‌ ଉବା, ଜୁୟ୍‌ରି ଜଃବାଉ ଦଃୟ୍‌ଆଚେ ସେରି ମୁଁୟ୍‌ ତୁମିମଃନାର୍‌ ଚଃମେ ହଃଟାୟ୍‌ନ୍ଦ୍, ମଃତର୍‌ ଉହ୍ରେ ହୁଣି ସଃକ୍ତି ନଃହାଉତା ହଃତେକ୍‌ ତୁମିମଃନ୍ ଇ ଗଃଳେ ରିଆ ।” ");
INSERT INTO bdv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତାର୍‌ହଃଚେ ଜିସୁ ସେମଃନ୍‌କେ ବେତାନିଆ ଜାତା ବାଟ ହଃତେକ୍‌ ନଃୟ୍‌ କଃରି, ନିଜାର୍‌ ଆତ୍‌ ଟେକି ସେମଃନ୍‌କେ ଆସିର୍ବାଦ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଆରେକ୍‌ ଆସିର୍ବାଦ୍‌ କଃରି କଃରି ତାକାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଲ୍‌ଗା ଅୟ୍‌ ସଃର୍ଗେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ସେତି ସେମଃନ୍ ତାକ୍‌ ଜୁଆର୍‌ କଃରି ବଃଡେ ସଃର୍ଦାଅୟ୍‌ ଜିରୁସାଲମେ ବାଉଳି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ଆରେକ୍‌ ସଃବୁବଃଳ୍‌ ମନ୍ଦିରେ ରଃୟ୍‌ ଇସ୍ୱରାର୍‌ ଗୁଣ୍‌ମଃନ୍‌ କୟ୍‌ ସଃର୍ଦା କଃରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ।");
INSERT INTO bdv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଆରୁମେ ବାକ୍ୟ ରିଲି, ବାକ୍ୟ ଇସ୍ୱର୍‌ ସଃଙ୍ଗ୍ ରିଲା, ସେ ବାକ୍ୟ ହଃକା ଇସ୍ୱର୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ସେ ଆରୁମେ ଇସ୍ୱର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ଆରେକ୍‌ ସେ ବାକ୍ୟର୍‌ ବଃଳେ ଇସ୍ୱର୍‌ ସଃବୁ ଉବ୍‌ଜାଣ୍‌ କଃଲା, ତାର୍‌ ବିନା କାୟ୍‌ରି ହେଁ ଉବ୍‌ଜାଣ୍‌ ନଃହୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ସେ ବାକ୍ୟ ଜିବନାର୍‌ ମୁଳ୍‌ ରିଲି ଆର୍‌ ସେଜିବନ୍‌ ମାନାୟ୍‌ ଜାତିର୍‌ ଉଜାଳ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ଆର୍‌ ସେ ଉଜାଳ୍‌ ଅଃନ୍ଦାର୍‌ ବିତ୍ରେ ସଃବୁ ବଃଳ୍‌ ଜଃଲ୍‌କି ଆସୁଲି, ଆର୍‌ ଅଃନ୍ଦାର୍‌ ତାକ୍‌ ନଃଦେର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ହଃଟାୟ୍‌ଲା ଗଟ୍‌ଲକ୍‌ ଆୟ୍‌ଲା, ତାର୍‌ ନାଉଁ ଜହନ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ସେ ଜଃନ୍‌କଃରି ଉଜାଳାର୍‌ କଃତା କୟ୍‌ଦ୍‌, ଆରେକ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ସଃବୁଲକ୍‌ ସଃତ୍‌ କଃର୍ତି, ଇତାକ୍‌ ସେ ସାକି ଦେଉଁକ୍‌ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ସେ ନିଜେ ସେ ଉଜାଳ୍‌ ନଃରିଲା, ମଃତର୍‌ ସେ ଉଜାଳାର୍‌ କଃତା ସାକି ଦେଉଁକେ ଆସିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଜୁୟ୍‌ ସଃତ୍‌ ଉଜାଳ୍‌ ଜଃଗତେ ଆସି ସଃବୁ ଜାତିକ୍‌ ଉଜାଳ୍‌ କଃରେଦ୍‌, ସେରିହଃକା ସଃତ୍ୟା ଉଜାଳ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ସେ ଜଃଗତେ ରିଲା, ଆର୍‌ ସେ ହୁର୍ତି ତାର୍‌ ତଃୟ୍‌ହୁଣି ଉବ୍‌ଜାଣ୍‌ ଅୟ୍‌ଲି, ଅୟ୍‌ଲେକ୍‌ ହେଁ ଜଃଗତ୍‌ ତାକ୍‌ ଚିନୁ ନାହାର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ସେ ଅଃହ୍‌ଣାର୍‌ ରାଜିଏ ଆୟ୍‌ଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ତାର୍‌ ନିଜାର୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ନଃଦେର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମଃତର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ତାକ୍‌ ଦଃର୍ଲାୟ୍‌, ବଃଲେକ୍‌ ତାର୍‌ ନାଉଁଏ ସଃତ୍‌ କଃଲାୟ୍‌ ସେମଃନ୍‌କେ ସେ ଇସ୍ୱରାର୍‌ ହିଲା ଅଃଉଁକେ ଅଃଦିକାର୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ସେମଃନ୍ ବଃନିତଃୟ୍‌, ଗଃଗାଳାର୍‌ ଇଚାୟ୍‌ କି ମାନାୟ୍‌ର୍‌ ଇଚାୟ୍‌ ଜଃଲମ୍‌ ନଃଉତି, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଇଚାୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆର୍‌ ସେ ବଃଚନ୍ ନଃର୍‌ ମାନାୟ୍‌ ଅୟ୍‌ଲା, ଆର୍‌ ଦଃୟା ଆର୍‌ ସଃତ୍‌ ସଃଙ୍ଗ୍ ହୁରୁଣ୍ ଅୟ୍‌ ଅଃମାର୍‌ ବିତ୍ରେ ବାସା କଃଲା; ଆର୍‌ ଉବାର୍‌ ତଃୟ୍‌ହୁଣି ଆୟ୍‌ଲା ଗଟେକ୍‌ ବଃଲି ହୟ୍‌ସିର୍‌ ଜଃଜ୍‌ମାନ୍‌ ହାୟ୍‌ରିଲା ହର୍‌ ତାର୍‌ ଜଃଜ୍‌ମାନ୍ ଦଃକ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଜହନ୍‌ ସାକି ଅୟ୍‌ ସେମାନାୟ୍‌ର୍‌ କଃତା ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, “ଜେ ମର୍‌ ହଃଚେ ଆସୁଲା, ସେ ମର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍, ବଃଲେକ୍‌ ମୁୟ୍‌ ଜଃର୍ନ୍‌ ନଃଉତ୍‌ ସେ ରିଲା, ଜାର୍‌ କଃତା ମୁୟ୍‌ କୟ୍‌ ରିଲେ, ସେ ଇମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ତାର୍‌ ଦଃୟାର୍‌ ହୁର୍ନାର୍‌ ଗିନେ ଅଃମିମଃନ୍‌ ଆସିର୍ବାଦ୍‌ ହାୟ୍‌ଆଚୁ ହେଁ ଆସିର୍ବାଦ୍‌ ଉହ୍ରେ ଆସିର୍ବାଦ୍‌ ହାୟ୍‌ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ମସାର୍‌ ଦଃୟ୍‌କଃରି ବିଦି ଦିଲା, ମଃତର୍‌ ଦଃୟା ଆର୍‌ ସଃତ୍‌ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ଆସିର୍ବାଦ୍‌ ତଃୟ୍‌ହୁଣି ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","କେହେଁ କଃବେ ଇସ୍ୱର୍‌କେ ନଃଦେକେ, ମଃତର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲା ତାର୍‌ ଗଟେକ୍‌ ବଃଲି ନିଜାର୍‌ ହୟ୍‌ସି ତାକ୍‌ ଜାଣାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","“ତୁୟ୍‌ କେ ?” ଇରି ଜହନ୍‌କେ ହଃଚାରୁକେ ଜିଉଦିମଃନ୍ ଜଃଡେବଃଳ୍‌ ଜିରୁସାଲମେ ହୁଣି ଜାଜକ୍‌ ଆର୍‌ ଲେବିମଃନ୍‌କେ ତାର୍‌ ଲଃଗେ ହଃଟାୟ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜହନ୍‌ ଇ ସାକି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଜହନ୍‌ ହୁଟାୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁୟ୍‌ କ୍ରିସ୍ଟ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ତୁୟ୍‌ କାୟ୍‌ ଏଲିୟ ?” ସେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଏଲିୟ ନାୟ୍‌ ।” “ତୁୟ୍‌ କାୟ୍‌ ସେ ବାବ୍‌ବାଦି ?” ସେ କୟ୍‌ଲା, “ମୁୟ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମିକ୍‌ ହଃଟାୟ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ଜଃନ୍‌କଃରି ଉତୁର୍‌ ଦେଉଁହାରୁ, ଇତାର୍‌ ଗିନେ ତୁୟ୍‌ କେ ? ତୁୟ୍‌ ନିଜାର୍‌ କଃତା କାୟ୍‌ରି କଃଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜିସାୟ୍‌ ବାବ୍‌ବାଦି ଜଃନ୍‌କଃରି କୟ୍‌ରିଲା ଜହନ୍‌ ସେରଃକମ୍‌ କୟ୍‌ଲା- “ମୁୟ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଆଉଲି ଅୟ୍‌ କଃଉତା ଗଟ୍‌ ଲକାର୍‌ ଟଣ୍ଡ୍, ମାପ୍ରୁର୍‌ ବାଟ୍‌ ସଃଳ୍‌କ୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଆର୍‌ ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ ହଃଟାୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ସେମଃନ୍ ଜହନ୍‌କେ ହଃଚାର୍ଲାୟ୍‌, “ତୁୟ୍‌ ଜଦି କ୍ରିସ୍ଟ ନାୟ୍‌ କି ଏଲିୟ ନାୟ୍‌ କି ବାବ୍‌ବାଦି ନାୟ୍‌, ତଃବେ କାୟ୍‌ତାକ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜହନ୍‌ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁଲେ, ମଃତର୍‌ ଜାକେ ତୁମିମଃନ୍ ନଃଜାଣାସ୍‌, ସେ ତୁମାର୍‌ ବିତ୍ରେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ସେ ମର୍‌ ହଃଚେ ଆସୁଲା, ମୁୟ୍‌ ତାର୍‌ ହାଣ୍ଡାୟ୍‌ର୍‌ ବାନ୍ଦୁଣ୍ ଇଟାଉତା ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଜର୍ଦନ୍ ଗାଡାର୍‌ ସେହାଟି ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ଜହନ୍‌ ବାପ୍ତିସମ୍‌ ଦେତିରିଲା ସେ ବେତ୍‌ନିଆ ଗାଉଁଏ ଇସଃବୁ ଗଃଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଜିସୁକ୍‌ ତାର୍‌ ଆସ୍ତାର୍‌ ଦଃକି ଜହନ୍‌ କୟ୍‌ଲା, “ଏଦେ ଦଃକା ଇସ୍ୱରାର୍‌ ମେଣ୍ଡା ବଦା, ଜେ ଜଃଗତାର୍‌ ହାହାର୍‌ ବଜ୍‌ ବୟ୍‌ ନଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଜେ ମର୍‌ ହଃଚେ ଆସୁଲା, ସେ ମର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍, ବଃଲେକ୍‌ ସେ ମର୍‌ ଜଃଲମ୍‌ ହୁର୍ବେ ରିଲା, ଜାର୍‌ କଃତା କୟ୍‌ରିଲେ ସେ ଇମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ମୁୟ୍‌ ହେଁ ତାକ୍‌ ଚିନି ନଃରିଲେ, ମଃତର୍‌ ତାକ୍‌ ଜଃନ୍‌କଃରି ଇସ୍ରାଏଲ୍‌ମଃନ୍‌ ଜାଣ୍‌ତି, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁକ୍‌ ଆସିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଜହନ୍‌ ସାକି ଦଃୟ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ଗଟ୍‌ ଆତ୍ମାକେ ହାଣ୍ଡ୍‌କା ହର୍‌ ସଃର୍ଗେ ହୁଣି ଉତ୍ରି ଆସ୍ତାର୍‌, ଆର୍‌ ସେ ତାର୍‌ ଉହ୍ରେ ବଃସ୍ତାର୍‌ ଦଃକ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ମୁୟ୍‌ ହେଁ ତାକେ ଜାଣି ନଃରିଲେ ମଃତର୍‌ ମାପ୍ରୁ ମକେ ହାଣାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦେଉଁକ୍‌ ହଃଟାୟ୍‌ଲା, ସେ କୟ୍‌ରିଲା, ‘ତୁୟ୍‌ ଗଟ୍‌ ମାନାୟ୍‌ର୍‌ ଉହ୍ରେ ଆତ୍ମା ଆସି ବଃସ୍ତାର୍‌ ଦଃକ୍‌ସି, ସେ ହଃକା ସେ ଲକ୍‌ ଜେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌ଦ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ମୁୟ୍‌ ସେରି ଦଃକିଆଚି ଆର୍‌ ସେ ହଃକା ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ବଃଲି ସାକି ଦେଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଆରେକ୍‌ ଜହନ୍‌ ସଃଙ୍ଗ୍ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ଲକ୍‌ ଟିଅୟ୍‌ ରିଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ସଃଡେବଃଳ୍‌ ଜିସୁ ଇଣ୍ଡି ଜାତାର୍‌ ଦଃକି, ଜହନ୍‌ କୟ୍‌ଲା, “ଏଦେ ଦଃକା ଇସ୍ୱରାର୍‌ ମେଣ୍ଡା ବଦା ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ସେ ଜଳେକ୍‌ ଚେଲା ତାର୍‌ କଃଉତାର୍‌ ସୁଣି ଜିସୁର୍‌ ହଃଚେହଃଚେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ଉଲ୍‌ଟି ସେମଃନ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଆସ୍ତାର୍‌ ଦଃକି ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ରି ଲଳୁଲାସ୍‌ ?” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ରାବ୍‌ବି, ବଃଲେକ୍‌, ଗୁରୁ, ତୁୟ୍‌ କୁୟ୍‌ତି ରେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଆସା ଦଃକାସ୍‌ ।” ସେତାକ୍‌ ସେମଃନ୍ ଜାୟ୍‌ ତାର୍‌ ରେତା ଟାଣ୍ ଦଃକଃଲାୟ୍‌, ଆରେକ୍‌ ସେଦିନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌; ସଃଡେବଃଳ୍‌ ସଃକାଳ୍ୟା ଦଃସ୍‌ଗଃଟା ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଜୁୟ୍‌ ଦୁୟ୍‌ ଲକ୍‌ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି କଃତା ସୁଣି ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଜାୟ୍‌ ରିଲାୟ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲା ପିତର୍‌ ସିମନାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଆନ୍ଦ୍ରିଅ ହଃର୍ତୁମ୍‌ ନିଜାର୍‌ ବାୟ୍‌ସି ସିମନ୍‌କ୍‌ ବେଟ୍‌ହାୟ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ଅଃମି ମସିଅକ୍‌, ବଃଲେକ୍‌ କ୍ରିସ୍ଟକେ ଦଃକିଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ତାର୍‌ହଃଚେ ସେ ସିମନ୍‌କ୍‌ ଜିସୁ ହାକ୍‌ ଆଣ୍‌ଲା । ଜିସୁ ତାକ୍‌ ନିକକଃରି ଦଃକ୍‌ଲା ଆର୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଜହନାର୍‌ ହୟ୍‌ସି ସିମନ୍, ତୁୟ୍‌ କେପା ବଃଲେକ୍‌ ପିତର୍‌ ବଃଲି ଡାକେ ହୁଟ୍‌ସି, ଇତାର୍‌ ଅଃର୍ତ୍‌ ଟେଳା ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଜିସୁ ଗାଲିଲି ଜଃଉଁକେ ମଃନ୍ କଃଲା, ସେ ପିଲିପ୍‌କେ ଦଃକ୍‌ଲା ଆର୍‌ ତାକେ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ୍ ବେତ୍‌ସାଇଦା ଗାଉଁଆର୍‌ ଲକ୍‌ ରିଲା, ସେରି ଆନ୍ଦ୍ରିଅ ଆର୍‌ ପିତର୍‌ ରେତା ଗଃଳ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍ ନିତନିଏଲ୍‌କେ ବେଟ୍‌ ଅୟ୍‌ ତାକେ କୟ୍‌ଲା, “ଜାର୍‌ କଃତା ମସା ବିଦିଲଃଗେ ଲେକିଆଚେ, ଆରେକ୍‌ ବାବ୍‌ବାଦିମଃନ୍ ହେଁ ଲେକି ଆଚ୍‌ତି, ଅଃମିମଃନ୍‌ ତାକ୍‌ ଦଃକି ଆଚୁ, ତାର୍‌ ଉବାସି ଜସେପ୍ ନାଜରିତ୍‌ ଗାଉଁଆର୍‌ ଜିସୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିଏଲ୍‌ ତାକ୍‌ ହଃଚାର୍ଲା, “ନାଜରିତ୍‌ ହୁଣି କାୟ୍‌ ସଃତ୍‌ କଃତା ବାରାଉଁ ହାରେ ?” ପିଲିପ୍ ତାକ୍‌ କୟ୍‌ଲା, “ଆଉ ଆର୍‌ ଦଃକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିତନିଏଲ୍‌କେ ଅଃହ୍‌ଣାର୍‌ ଚଃମେ ଆସ୍ତାର୍‌ ଦଃକି, ସେ ତାର୍‌ କଃତା କୟ୍‌ଲା, “ଏଦେ ଦଃକା ନିଜ୍‌କଃରି ଏ ଗଟେକ୍‌ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌, ଆର୍‌ ତଃୟ୍‌ ମିଚ୍‌ମଃୟା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିଏଲ୍‌ ଜିସୁକେ ହଃଚାର୍ଲା, “ତୁୟ୍‌ ମକ୍‌ କଃନ୍‌କଃରି ଜାଣ୍‌ଲିସ୍‌ ?” ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ପିଲିପ୍ ତକ୍‌ କୁଦ୍‌ତା ଆଗ୍‌ତୁ ତୁୟ୍‌ ଜଃଡେବଃଳ୍‌ ଡୁମ୍ବୁର୍‌ ଗଚ୍‌ତଳେ ଟିଅୟ୍‌ ରିଲିସ୍‌, ସଃଡେବଃଳ୍‌ ମୁୟ୍‌ ତକ୍‌ ଦଃକିରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନିଏଲ୍‌ ଉତୁର୍‌ ଦିଲା, “ଏ ରାବ୍‌ବି, ବଃଲେକ୍‌ ଏ ଗୁରୁ, ତୁୟ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି, ତୁୟ୍‌ ଇସ୍ରାଏଲ୍‌କେ ଚାଲାଉତା ରଃଜା ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ ତକେ ଡୁମ୍ବୁର୍‌ ଗଃଚ୍ ତଃଳେ ଦଃକି ରିଲେ ବଃଲି କୟ୍‌ଲାକ୍‌ କି ତୁୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲିସ୍‌ ? ତୁୟ୍‌ ଇତାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ବଃଡ୍ ବିସୟ୍‌ ଦଃକ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଆରେକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ସଃର୍ଗ୍‌ ଉଗାଳି ଅଃଉତାର୍‌ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ମଃନ୍‌କେ ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଚଃମେ ଉହ୍ରେ ଜାତାର୍‌ ଆର୍‌ ଉତ୍ରି ଆସ୍ତାର୍‌ ଦଃକାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ଦୁୟ୍‌ଦିନାର୍‌ ହଃଚେ ଗାଲିଲିର୍‌ କାନା ନାଉଁଆର୍‌ ଗଃଳେ ଗଟେକ୍‌ ବିବା ଅୟ୍‌ଲି । ଆର୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ସେତି ରିଲି; ");
INSERT INTO bdv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁକେ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍‌କେ ହେଁ ବିବାତଃୟ୍‌ କୁଦି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ସଃର୍ଲାକ୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ଜିସୁକେ କୟ୍‌ଲି, “ସେମଃନାର୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ସେତାକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏଗା ଆୟା, ମକ୍‌ କାୟ୍‌ରି କଃରୁକେ ଅୟ୍‌ଦ୍‌ ? ଅଃବେ ହଃତେକ୍‌ ମର୍‌ ବେଳା ନାସେତା ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଜିସୁର୍‌ ଆୟ୍‌ସି ସେବାକାରିମଃନ୍‌କେ କୟ୍‌ଲି, “ଜିସୁ ତୁମିମଃନ୍‌କେ ଜାୟ୍‌ବଃଲି କୟ୍‌ଦ୍‌, ସେରି କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଆର୍‌ ସେଲଃଗେ ଜିଉଦିମଃନାର୍‌ ନିର୍ମୁଳ୍‌ ଅଃଉତା ବିଦି ହଃର୍କାରେ ହଃତି ଗୁନାୟ୍‌ ହାଁଚ୍‌କଳି ମୁତା ହାଣି ଦଃର୍‌ତାର୍‌ ଚଅଗଟ୍‌ ଟେଳାୟ୍‌ ତିଆର୍‌ ଅୟ୍‌ଲା ବଃଡ୍ ବଃଡ୍ ହାଣି ଗୁନା ରିଲି । ଗଟେକ୍‌ ଗଟେକ୍‌ ହାଣି ଗୁନାୟ୍‌ ହାଁଚ୍‌କଳି ମୁତା ହାଣି ଦଃର୍ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ ଗୁନାୟ୍‌ମଃନ୍ ହାଣି ବଃର୍ତି କଃରା ।” ସେତାକ୍‌ ସେମଃନ୍ ହଃତିତଃୟ୍‌ ଗଃଳା ହଃତେକ୍‌ ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃବେ ଇତିର୍‌ ହାଣି ଡୁବି ନଃୟ୍‌କଃରି ବଜିର୍‌ ବଃଣ୍ଡାର୍‌ ଗଃରିଆକ୍‌ ଦିଆସ୍‌ ।” ସେତାକ୍‌ ସେମଃନ୍ ତାର୍‌ ଲଃଗେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବଃଣ୍ଡାର୍‌ ଗଃରିଆ ସେ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଅୟ୍‌ରିଲା ହାଣିକ୍‌ ଚାକିକଃରି ସେରି କୁୟ୍‌ତିହୁଣି ଆୟ୍‌ଲି, ସେରି ଜାଣୁ ନଃହାର୍‌ଲା, ମଃତର୍‌ ଜୁୟ୍‌ମଃନ୍‌ ବଃଣ୍ଡାର୍‌ଗଃରିଆକ୍‌ ହାଣି ଡୁବି ଦିଲାୟ୍‌ ସେମଃନ୍ ଜାଣି ରିଲାୟ୍‌, ସେତାର୍‌ ଗିନେ ସେ ବଃରକ୍‌ କୁଦିକଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ସଃବୁଲକ୍‌ ହଃର୍ତୁମ୍‌ ନିକ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ଦେତି, ଆର୍‌ ଲକ୍‌ମଃନ୍ କାୟ୍‌କଃରି ମାତ୍‌ଲା ହଃଚେ ବଃର୍ନ୍‌ରି ଦେତି; ମଃତର୍‌ ତୁମି ଅଃବେ ହଃତେକ୍‌ ନିକ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ସଃଙ୍ଗାୟ୍‌ ଆଚାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁ ଇବାନ୍ୟା ହଃର୍ତୁମେ ଗାଲିଲିର୍‌ କାନା ଗଃଳେ କାବା ଅଃଉତା ଚିନ୍ ଆରୁମ୍‌ କଃରି ଅଃହ୍‌ଣାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଦଃକାୟ୍‌ଲା, ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ତାର୍‌ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଇତାର୍‌ ହଃଚେ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଆୟ୍‌ସି, ବାୟ୍‌ମଃନ୍ ଆର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଗଃଲାୟ୍‌; ଆରେକ୍‌ ସେମଃନ୍ ସେତି କଃତି ଦିନ୍ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ସଃଡେବଃଳ୍‌ ଜିଉଦିମଃନାର୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଚଃମେ ଅୟ୍‌ ଆସିରିଲି, ଆର୍‌ ଜିସୁ ଜିରୁସାଲମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ଆରେକ୍‌, ଜିସୁ ମନ୍ଦିରେ ଗାୟ୍‌, ମେଣ୍ଡା, ହାଣ୍ଡ୍‌କା ବେବାରିମଃନ୍‌କେ ଆର୍‌ ଡାବୁ ବାଦ୍‌ଲାଉମଃନ୍‌ କେ ବଃସି ରିଲାର୍‌ ଦଃକ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ସେତାକ୍‌ ସେ ଡର୍‌ଲଃଗେ ସାଟ୍‍ଣି ତିଆର୍‌ କଃରି ଗାୟ୍‌, ମେଣ୍ଡା ମଃନ୍‌କେ ମନ୍ଦିରେ ହୁଣି ବାର୍‌ କଃରି ଦିଲା । ଡାବୁ ବାଦ୍‌ଲାଉମଃନାର୍‌ ସଃବୁ ଟେବୁଲ୍‌ମଃନ୍‌କେ ଉଲ୍‌ଟାୟ୍‌ ଦଃୟ୍‌ ଟଃକା ବିଚ୍ରି ହଃକାୟ୍‌ଲା ");
INSERT INTO bdv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ଆର୍‌ ଜିସୁ ହାରୁଆ ବେବାରିମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ ସଃବୁକ୍‌ ଇତି ହୁଣି ଦଃରି ଜାହା, ମର୍‌ ଉବାର୍‌ ଗଃର୍‌କେ ବେବାର୍‌ ଗଃର୍‌ କଃରା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“ଏ ପବିତ୍ର ଇସ୍ୱର୍‌, ତର୍‌ ଗଃରାର୍‌ ଗିନେ ଗଃର୍ବେ ଜୟ୍‌ ଲାଗ୍‌ଲା ହର୍‌ ମକ୍‌ ଚିତା ମାଡି ବଃସେଦ୍‌ ।” ଇରି ଦଃର୍ମ୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ ବଃଲି ତାର୍‌ ଚେଲାମଃନ୍‌କେ ମଃନେ ହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ସେତାକ୍‌ ଜିଉଦିମଃନାର୍‌ ମୁଳିକାମଃନ୍ ଜିସୁ ହାକ୍‌ ବାଉଳି ଆସି ଇରି ହଃଚାର୍ଲାୟ୍‌, ତୁୟ୍‌ ଇସଃବୁ କାମ୍‌ କଃରୁକେ “ଅଃଦିକାର୍‌ ହାୟ୍‌ ଆଚ୍‌ସି, ବଃଲି ଅଃମିମଃନ୍‌ କଃନ୍‌କଃରି ଜାଣୁନ୍ଦ୍‌ ଅଃମିମଃନ୍‌କ୍‌ କାୟ୍‌ ଚିନ୍ ଦଃକାଉଁହାର୍ସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ସେମଃନ୍‌କେ ଉତୁର୍‌ ଦିଲା, “ତୁମିମଃନ୍ ଇ ମନ୍ଦିର୍‌କେ ନଃସ୍ଟ୍‌ କଃଲେକ୍‌, ତିନ୍ ଦିନ୍‌ ବିତ୍ରେ ମୁୟ୍‌ ସେରି ଆରେକ୍‌ ତିଆର୍‌ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ସେତାକ୍‌ ଜିଉଦିମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଇ ମନ୍ଦିର୍‌ ତିଆର୍‌ କଃରୁକେ ଦୁୟ୍‌କଳି ଚଅ ବଃର୍ସ୍‌ ଲାଗି ଆଚେ; ଆର୍‌ ତୁୟ୍‌ କାୟ୍‌ରି ସେରି ତିନିଦିନ୍ ବିତ୍ରେ ତିଆର୍‌ କଃର୍ସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ମଃତର୍‌ ଜିସୁ ତାର୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃଗାଳ୍‌ ମନ୍ଦିର୍‌କେ ଦଃକାୟ୍‌ ଇ କଃତା କୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଜିସୁ ମଃରି ଉଟ୍‌ଲା ହଃଚେ ତାର୍‌ ଚେଲାମଃନ୍ ମଃନେ ଏତାୟ୍‌ଲାୟ୍‌ ଜେ ସେ ଇରି କୟ୍‌ ରିଲା; ଆରେକ୍‌, ସେମଃନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଆର୍‌ ଜିସୁର୍‌ କୟ୍‌ଲା କଃତାକ୍‌ ସଃତ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଃଳ୍‌ ଜିସୁ ଜିରୁସାଲମେ ରିଲାବଃଳ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ସେ କଃଲା କାବା ଅଃଉତା ଚିନ୍ ଦଃକି ତାକେ ସେମଃନ୍ ତାର୍‌ ନାଉଁଏ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ ସଃତ୍‌ ନଃକେରି ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃହ୍‌ଣାକ୍‌ ଅଃଲ୍‌ଗା କଃରିରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ସେ ସଃବ୍‌କେ ନିକ କଃରି ଜାଣିରିଲା, ");
INSERT INTO bdv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ଆରେକ୍‌, କୁୟ୍‌ ମାନାୟ୍‌ ଜେ ନଃରାର୍‌ ହୟ୍‌ସି ବିସୟେ ସାକି ଦଃୟ୍‌ଦ୍‌, ଇରି ଜିସୁର୍‌ ଲଳା ନଃରିଲି, ବଃଲେକ ନଃର୍‌ମଃନାର୍‌ ମଃନେ କାୟ୍‌ରି ଆଚେ, ସେରି ସେ ନିଜେ ଜାଣୁହାର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ ନିକଦିମ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜିଉଦିମଃନାର୍‌ ମୁଳିକା ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ସେ ରାତିବଃଳ୍‌ ଜିସୁର୍‌ ଲଃଗେ ଆସି ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଗୁରୁ, ତୁୟ୍‌ ଜେ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆୟ୍‌ଲା ଗୁରୁ, ଇରି ଅଃମିମଃନ୍‌ ଜାଣିଆଚୁ, ବଃଲେକ୍‌ ତୁୟ୍‌ ଇରି ଜୁୟ୍‌ ସଃବୁ କାବା ଅଃଉତା ଚିନ୍ କଃରୁଲିସ୍‌, ଇସ୍ୱର୍‌ ସଃଙ୍ଗ୍ ନଃରିଲେକ୍‌ ସେସଃବୁ କେହେଁ କଃରୁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ସଃତ୍‌କଃରି ମୁୟ୍‌ ତକ୍‌ କଃଉଁଲେ, ଆରେକ୍‌ ଜଃଲମ୍‌ ନୟ୍‌ଲେକ୍‌ କେହେଁ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ଦଃକୁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମ ଜିସୁକେ ହଃଚାର୍ଲା, “ବୁଡା ଅୟ୍‌ଲେକ୍‌ ମାନାୟ୍‌ କଃନ୍‌କଃରି ଆରେକ୍‌ ତରେକ୍‌ ଜଃଲମ୍‌ ଅଃଉଁ ହାରେ ? ସେ କାୟ୍‌ରି ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ତାର୍‌ ଆୟ୍‌ସିର୍‌ ହେଟେ ହୁରି ଜଃଲମ୍‌ ଅଃଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ କୟ୍‌ଲା, “ସଃତ୍‌ କଃରି ମୁୟ୍‌ ତକ୍‌ କଃଉଁଲେ, ହାଣି ଆର୍‌ ଆତ୍ମାୟ୍‌ ଆରେକ୍‌ ତରେକ୍‌ ଜଃଲମ୍‌ ନୟ୍‌ଲେକ୍‌ କେହେଁ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜଃଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଗଃଗାଳେ ହୁଣି ଜାୟ୍‌ରି ଜଃଲମ୍‌ ସେରି ଗଃଗାଳ୍‌ ଆରେକ୍‌, ଆତ୍ମା ତଃୟ୍‌ହୁଣି ଜାୟ୍‌ରି ଜଃଲମ୍‌, ସେରି ଆତ୍ମା । ");
INSERT INTO bdv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ତୁମି ସଃବ୍‌କେ ବାୟ୍‌ଦ୍‌ରେ ଆରେକ୍‌ ତରେକ୍‌ ଜଃଲମ୍‌ ଅଃଉଁକେ ହଃଳେଦ୍‌ ବଃଲି ମୁୟ୍‌ ଜୁୟ୍‌ରି କଃଉଁଲେ, ଇତାର୍‌ ଗିନେ କାବା ଅଃଉଅ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ବାଉ ଜୁୟ୍‌ ଦିଗେ ମଃନ୍‌କଃରେଦ୍‌, ସେ ଦିଗେ ଜାୟ୍‌ଦ୍‌ ଆର୍‌ ତୁମିମଃନ୍ ତାର୍‌ ସଃବ୍‌ଦ୍‌ ସୁଣାସ୍‌, ମଃତର୍‌ ସେରି କୁୟ୍‌ତିହୁଣି ଆସେଦ୍‌ ଆର୍‌ କୁୟ୍‌ତି ଜାୟ୍‌ଦ୍‌, ସେରି ନଃଜାଣାସ୍‌; ଆତ୍ମାୟ୍‌ ହୁଣି ଜଃଲମ୍‌ ଅୟ୍‌ଲା ହଃତି ଲକାର୍‌ କଃତା ସେନ୍‌କାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମ ଜିସୁକେ କୟ୍‌ଲା, “ଇରିମଃନ୍‌ କଃନ୍‌କଃରି ଅଃଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ଇସ୍ରାଏଲ୍‌ମଃନାର୍‌ ଗଟେକ୍‌ ଗୁରୁ ଅୟ୍‌କଃରି ହେଁ ଇ ସଃବୁ କାୟ୍‌ରି ନଃବୁଜୁଲିସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ମୁୟ୍‌ ସଃତ୍‌କଃରି କଃଉଁଲେ- ଅଃମି ଜୁୟ୍‌ରି ଜାଣିଆଚୁ ସେରି କଃଉଁଲୁ ଆର୍‌ ଜୁୟ୍‌ରି ଦଃକିଆଚୁ ସେରି ସାକି ଦେଉଁଲୁ ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମି ସଃତ୍‌ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ମୁୟ୍‌ ତୁମିକେ ଜଃଗତାର୍‌ କଃତା କୟ୍‌ଲେକ୍‌ ତୁମି ସଃତ୍‌ ନଃକେରୁଲାସ୍‌, ଜଃଡେବଃଳ୍‌ ମୁୟ୍‌ ସଃର୍ଗ୍‌ହୁରାର୍‌ କଃତା କୟ୍‌ଲେକ୍‌ ତୁମି ମକେ କଃନ୍‌କଃରି ସଃତ୍‌ କଃରାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଜୁୟ୍‌ ନଃରାର୍‌ ହୟ୍‌ସି ସଃର୍ଗେହୁଣି ଉତୁର୍ଲା, ତାର୍‌ ବିନା ଆର୍‌ କେ ସଃର୍ଗେ ନଃଜାୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ମସା ଜଃନ୍‌କଃରି ସୁକ୍‌ଲାବଃଟାୟ୍‌ ହିତୁଳାର୍‌ ସାହ୍‌ ଲାଟି ଟିହେ କଃରି ଉହ୍ରେ ଉଟାୟ୍‌ରିଲା, ସେନ୍‌କଃରି ନଃରାର୍‌ ହୟ୍‌ସି ହେଁ ଉହ୍ରେ ଉଟା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଜଃନ୍‌କଃରି ଜେହେଁ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ଜଃଗତ୍‌କେ ଅଃତେକ୍‌ ଲାଡ୍‌ କଃଲା ଜେ ସେ ଅଃହ୍‌ଣାର୍‌ ଗଟେକ୍‌ ବଃଲି ହୟ୍‌ସିକ୍‌ ଦାନ୍‌ ଦିଲା, ଜଃନ୍‌କଃରି ଜେହେଁ ତାକେ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ସେ ନଃସ୍ଟ୍‌ ନୟ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଇସ୍ୱର୍‌ ନିଜାର୍‌ ହୟ୍‌ସିକ୍‌ ଜଃଗତ୍‌କେ ବିଚାର୍‌ କଃରୁକେ ନାୟ୍‌, ମଃତର୍‌ ଜଃଗତ୍‌କେ ଜଃନ୍‌କଃରି ବଚାଉଁକେ ଅୟ୍‌ଦ୍‌ ସେତାର୍‌ଗିନେ ହଃଟାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଜୁୟ୍‌ ଲକ୍‌ ହୟ୍‌ସିର୍‌ ତାଣେ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ତାର୍‌ ବିଚାର୍‌ ନାୟ୍‌; ମଃତର୍‌ ଜେ ବିସ୍ୱାସ୍‌ ନଃକେରେ ତାର୍‌ ବିଚାର୍‌ ଅୟ୍‌ ସଃର୍ଲିନି, ବଃଲେକ୍‌ ସେ ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ବଃଲି ହୟ୍‌ସିର୍‌ ନାଉଁଏ ବିସ୍ୱାସ୍‌ ନଃକେରେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆର୍‌, ସେ ବିଚାର୍‌ ଇରି, ଜଃଗତାର୍‌ ଉଜାଳ୍‌ ତଃରାସି ଆଚେ, ଆର୍‌ ଲକ୍‌ମଃନ୍ ଉଲାଳ୍‌କେ ନଃଚିକଃରି ଅଃନ୍ଦାର୍‌କେ ଲାଡ୍‌ କଃଲାୟ୍‌, ବଃଲେକ୍‌ ସେମଃନ୍‌କାର କାମ୍‌ ସଃବୁ ମଃନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ କଃରାବ୍‌ କାମ୍‌ କଃରେଦ୍‌, ଉଜାଳ୍‌କେ ଗିଣ୍ କଃରେଦ୍‌, ବଃଲେକ୍‌ ତାର୍‌ କଃରାବ୍‌ କାମ୍‌ମଃନ୍‌ ହଃଦାୟ୍‌ ହଃଳ୍‌ତା ଡିର୍‌କେ ଉଜାଳେ ଆସୁନଃଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ଜାର୍‌ କାମ୍‌ ସଃତ୍‌, ସେ ଉଜାଳେ ଆସୁକ୍‌ ମଃନ୍ କଃରେଦ୍‌, ଜଃନ୍‌କଃରି ତାର୍‌ କାମ୍‌ ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ହୁଣି ଅୟ୍‌ଲି ବଃଲି ଜାଣା ହଃଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ଇତାର୍‌ହଃଚେ, ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ଜିଉଦା ଦେସେ ଗଃଲାୟ୍‌, ଆର୍‌ ସେଟାଣେ ସେମଃନ୍‌କାର ସଃଙ୍ଗ୍ ରଃୟକଃରି ବାପ୍ତିସମ୍‌ ଦେଉଁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଜହନ୍‌ ହେଁ ସାଲିମ୍‌ ଚଃମାର୍‌ ଆନନେ ବାପ୍ତିସମ୍‌ ଦେତିରିଲା, କାୟ୍‌କଃରୁକ୍‌ ବଃଲେକ୍‌ ସେତି ବୁତେକ୍‌ ହାଣି ରିଲି, ଆର୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ତଃୟ୍‌ ଆସ୍ତି ରିଲାୟ୍‌ ଆର୍‌ ବାପ୍ତିସମ୍‌ ନେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଜହନ୍‌ ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ଜଃଇଲେ ଜାୟ୍‌ ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ନିର୍ମୁଳ୍‌ ଅଃଉତା କଃତାର୍‌ ଗିନେ, ଜହନ୍‌ ତଃୟ୍‌ଁ ହୁଣି ଆୟ୍‌ଲା କଃତିଗଟ୍‌ ଚେଲାମଃନ୍ ଗଟ୍‌ ଜିଉଦି ସଃଙ୍ଗ୍ ଦଃରାଦଃରି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଜହନାର୍‌ ଚେଲାମଃନ୍ ଜହନ୍‌ ହାକ୍‌ ଜାୟ୍‌ ତାକେ ସାକିଦି ଲାୟ୍‌, “ଗୁରୁ, ଏତାଉ ଜର୍ଦନ୍ ଗାଡାର୍‌ ଉଦ୍ୟାନ୍‌ବାଟ୍‌ ଜୁୟ୍‌ ମାନାୟ୍‌ ତର୍‌ ସଃଙ୍ଗ୍ ରେତିରିଲା, ଜାର୍‌ କଃତା ତୁୟ୍‌ କଃଉତି ରିଲିସ୍‌, ସେ ଅଃବେ ବାପ୍ତିସମ୍‌ ଦେଉଁଲା, ଆର୍‌ ସଃବୁ ଲକ୍‌ ତାର୍‌ ହାକ୍‌ ଜଃଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜହନ୍‌ କୟ୍‌ଲା, ସଃର୍ଗେ ହୁଣି ଇସ୍ୱର୍‌ ନଃଦିଲେକ୍‌ କୁୟ୍‌ ଲକ୍‌ କାୟ୍‌ରିହେଁ ହାଉଁନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“ମୁୟ୍‌ କ୍ରିସ୍ଟ ନାୟ୍‌, ତାର୍‌ ଆଗାଳି ହଟାୟ୍‌ଲାର୍‌ ଆସିଆଚି, ମୁୟ୍‌ ଇରି କୟ୍‌ରିଲେ । ତୁମିମଃନ୍ ନିଜେ ସେ ସାକି । ");
INSERT INTO bdv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଜୁୟ୍‌ ଲକ୍‌ କଃନ୍ୟା ଆଣେଦ୍‌, ସେ ବଃର, ମଃତର୍‌ ବଃରର୍‌ ସଃଙ୍ଗ୍ ଅଃହ୍‌ଣାର୍‌ ଲକ୍‌ ଟିଆ ଅୟ୍‌ କଃତା ସୁଣେଦ୍‌, ସେ ବଃରର୍‌ ଗିନେ ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ଦ୍‌ । ବଃଲେକ୍‌ ମର୍‌ ଇ ସଃର୍ଦା ହୁର୍ନ୍‌ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ସେ ବାୟ୍‌ଦ୍‌ରେ ବାଡୁକେ ହଃଳେଦ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ବୁଡୁକ୍‌ ହଃଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଜେ ସଃର୍ଗେହୁଣି ଆସେଦ୍‌ ସେ ସଃବ୍‌କେ ବଃଡ୍ । ଜେ ହୁର୍ତିବିଏ ହୁଣି ଜାତ୍‌ ଅୟ୍‌ଆଚେ ସେ ଜଃଗତାର୍‌, ଆର୍‌ ସେ ଜଃଗତାର୍‌ କଃତା କୟ୍‌ଦ୍‌ ମଃତର୍‌ ଜେ ସଃର୍ଗେହୁଣି ଆସେଦ୍‌ ସେ ସଃବ୍‌କାର୍‌ ଉହ୍ରେ ବଃଡ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ସେ ଜାୟ୍‌ରି ଦଃକିଆଚେ ଆର୍‌ ସୁଣି ଆଚେ ସେରି ସାକି ଦଃୟ୍‌ଦ୍‌, ମଃତର୍‌ ତାର୍‌ କଃତା କେହେଁ ତାର୍‌ ସାକି ଦିଲାର୍‌ ସଃତ୍‌ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ମଃତର୍‌ ଜେ ତାର୍‌ ସାକି ଦିଲାର୍‌ ଦଃରିଆଚେ ଇସ୍ୱର୍‌ ଜେ ସଃତ୍‌ ବଃଲି ସେ ମୁଦ୍ରା ମାରାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଜାକେ ଇସ୍ୱର୍‌ ହଃଟାୟ୍‌ ଆଚେ ସେ ଇସ୍ୱରାର୍‌ କଃତା କୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ସେ ଇସ୍ୱର୍‌ ତାକେ ହୁର୍ନ୍‌କଃରି ତାର୍‌ ଆତ୍ମା ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଉବାସି ହୟ୍‌ସିକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ଆର୍‌ ସଃବୁ ବିସୟ୍‌ ତାର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଜେ ହୟ୍‌ସିର୍‌ ଟାଣେ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌; ଜେ ହୟ୍‌ସିକ୍‌ ମାୟ୍‌ନ୍‌ ନଃକେରେ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉଁ ନାହାରେ, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ରିସା ତଃଳେ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ପାରୁସିମଃନ୍ ସୁଣ୍‌ଲାୟ୍‌ ଜେ ଜିସୁ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଚେଲା କଃରୁଲା ଆର୍‌ ସେମଃନ୍‌କେ ବାପ୍ତିସମ୍‌ ଦେଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ସଃତ୍‌କଃରି ଜିସୁ କାକେହେଁ ବାପ୍ତିସମ୍‌ ଦେତିନଃରିଲା; ତାର୍‌ ଚେଲାମଃନ୍ ଦେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ତାର୍‌ କଃତା ପାରୁସିମଃନ୍ ସୁଣି ଆଚ୍‌ତି ବଃଲି ଜଃଡେବଃଳ୍‌ ଜିସୁ ସୁଣ୍‌ଲା, ସଃଡେବଃଳ୍‌ ସେ ଜିଉଦା ରାଇଜ୍‌ ଚାଡି ଆରେକ୍‌ ଗାଲିଲି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ମଃତର୍‌ ଜାତା ବାଟେ ତାକ୍‌ ସମିରଣ ବାଟ୍‌ ଅୟ୍‌ ଜଃଉଁକେ ହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ତଃବେ ଜିସୁ ଜାୟ୍‌ ଜାକୁବକ୍‌ ତାର୍‌ ହୟ୍‌ସି ଜସେପ୍ ଜୁୟ୍‌ ବୁୟ୍‌ଁ କଃଣ୍ଡେକ୍‌ ଦଃୟ୍‌ରିଲା, ତାର୍‌ ଚଃମାର୍‌ ସୁକାର୍‌ ନାଉଁଆର୍‌ ସମିରଣାର୍‌ ଗଟେକ୍‌ ଗଃଳେ ହଚ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ସେଟାଣେ ଜାକୁବର୍‌ କୁଇଁକାଲ୍‌ ରିଲି, ଜିସୁ ବାଟ୍‌ ଇଣ୍ଡି ଇଣ୍ଡି ତାକି ରିଲାକ୍‌, ସେ କୁଇଁକାଲ୍‌ ଚଃମେ ବଃସ୍‌ଲା । ସଃଡେବଃଳ୍‌ ମୁଣ୍ଡେବେଳା ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଜିସୁ ସେ କୁଇଁକାଲ୍‌ ଚଃମେ ବଃସି ରିଲାବଃଳ୍‌ ଗଟେକ୍‌ ସମିରଣିୟା ମାୟ୍‌ଜି ହାଣି ନେଉଁକ୍‌ ସେ କୁଇଁକାଲେ ଆୟ୍‌ଲି । ଜିସୁ ତାକେ କୟ୍‌ଲା, “ମକ୍‌ ହାଣି ଗୁଳିକ୍‌ କାଉଁକେ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ସଃଡେବଃଳ୍‌ ତାର୍‌ ଚେଲାମଃନ୍ କାଦି ଗେନି ଆଣୁକେ ଗଃଳ୍‌ବିତ୍ରେ ଜାୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ସେତାକ୍‌ ସମିରଣିୟା ମାୟ୍‌ଜି ଜିସୁକେ କୟ୍‌ଲି, “ତୁୟ୍‌ ଗଟେକ୍‌ ଜିଉଦି ଲକ୍‌ ଆର୍‌ ମୁୟ୍‌ ଗଟେକ୍‌ ସମିରଣିୟା, ତଃବେ କଃନ୍‌କଃରି ମର୍‌ ଆତାର୍‌ ହାଣି କାଉଁକେ ମାଗୁଲିସ୍‌ ? ବଃଲେକ୍‌ ସମିରଣିୟା ମଃନାର୍‌ସଃଙ୍ଗ୍ ଜିଉଦିମଃନାର୍‌ ଚାଲାଚାଲ୍‌ତି ନଃରିଲି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ କୟ୍‌ଲା, “ଇସ୍ୱର୍‌ ଦିଲା ଦାନ୍‌ ଆର୍‌ ‘ମକ୍‌ କାଉଁକେ ଦେ,’ ବଃଲି ଜେ ତକ୍‌ କଃଉଁଲା, ସେ କେ, ଇରି ଜାଣିରିଲେକ୍‌, ଆର୍‌ ତୁୟ୍‌ ତାକ୍‌ ମାଗ୍‌ଲେକ୍‌ ସେ ତକ୍‌ ଜିବନ୍ ଦେତା ହାଣି ଦିଲାହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ସେ ମାଇଜି ତାକ୍‌ କୟ୍‌ଲି, “ଏ ମାପ୍ରୁ, ହାଣି କାଡୁକ୍‌ ତର୍‌ହାକ୍‌ ବାଲ୍‌ଟି ନାୟ୍‌, ଆରେକ୍‌ କୁଇଁକାଲ୍‌ ତ ଡେଙ୍ଗ୍ । ତୁୟ୍‌ କୁୟ୍‌ତିହୁଣି ଜିବନ୍ ଦେତା ହାଣି ହାଉସି ? ");
INSERT INTO bdv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ଅଃମାର୍‌ ଦାଦିବାବୁ ଜାକୁବ ଇ କୁଇଁକାଲ୍‌ କଃଣି ଦଃୟ୍‌ରିଲା; ସେ ଆର୍‌ ତାର୍‌ ହୟ୍‌ସିମଃନ୍ ଆର୍‌ ଗାୟ୍‌ଗରୁ ଇତିର୍‌ ହାଣି କାତି ରିଲାୟ୍‌ । ତୁୟ୍‌ କାୟ୍‌ ଜାକୁବର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ସେ ମାୟ୍‌ଜିକେ କୟ୍‌ଲା, “ଇ କୁଇଁକାଲାର୍‌ ହାଣି ଜେ କାୟ୍‌ଦ୍‌ ତାକ୍‌ ଆରେକ୍‌ ସସ୍‌ ଲାଗେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ମୁୟ୍‌ ଜୁୟ୍‌ ହାଣି ଦଃୟ୍‌ନ୍ଦ୍, ସେରି ଜୁୟ୍‌ ଲକ୍‌ କାୟ୍‌ଦ୍‌ ତାକ୍‌ କଃବେ ହେଁ ସସ୍‌ ନୟ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ତାକ୍‌ ଜୁୟ୍‌ ହାଣି ଦଃୟ୍‌ନ୍ଦ୍, ସେରି ଅଃମ୍ବର୍‌ ଜିବନ୍ ଦେତା ହାଜ୍ରା ହାଣି ହର୍‌ ତାର୍‌ ତାଣେ ଉଚୁଳ୍‌ତି ରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ସେ ମାୟ୍‌ଜି କୟ୍‌ଲି, “ଏ ମାପ୍ରୁ, ମକ୍‌ ସେ ହାଣି ଦେ, ଜଃନ୍‌କଃରି ମକ୍‌ କଃବେ ସସ୍‌ ନଃଲାଗେ, ଆରେକ୍‌ ହାଣି କାଡୁକ୍‌ ଅଃତେକ୍‌ ବାଟ୍‌ ଆସୁକ୍‌ ନଃହେଳେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁ ତାକେ କୟ୍‌ଲା, “ଜା, ଆର୍‌ ତର୍‌ ଡକ୍ରାଦିକ୍‌ ଇତି କୁଦି ଆଣ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ସେ ମାୟ୍‌ଜି କୟ୍‌ଲି, “ମର୍‌ ଅଃଣ୍ଡ୍ରା ନାୟ୍‌ ।” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ଅଃଣ୍ଡ୍ରା ନାୟ୍‌, ଇ କଃତା ସଃତ୍‌ କୟ୍‌ଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ବଃଲେକ୍‌ ତର୍‌ ହାଁଚ୍ ଗଟ୍‌ ଅଃଣ୍ଡ୍ରା ରିଲାୟ୍‌, ଆର୍‌ ଅଃବେ ତୁୟ୍‌ ଜାର୍‌ ସଃଙ୍ଗ୍ ଆଚ୍‌ସି ସେ ହେଁ ତର୍‌ ଡକ୍ରାଦି ନାୟ୍‌ । ଇରି ସଃତ୍‌ କୟ୍‌ଆଚ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ମାୟ୍‌ଜି ଜିସୁକେ କୟ୍‌ଲି, “ଏ ମାପ୍ରୁ, ତୁୟ୍‌ ଜେ ଗଟେକ୍‌ ବାବ୍‌ବାଦି, ଇରି ମୁୟ୍‌ ଦଃକୁ ହାରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ଇ ଡଙ୍ଗ୍ରେ ଇସ୍ୱର୍‌କେ ସେବା କଃଲାୟ୍‌, ମଃତର୍‌ ତୁମି ଜିହୁଦିମଃନ୍ କଃଉଁଲାସ୍‌ ଇସ୍ୱର୍‌କେ ହୁଜା କଃର୍ତା ଟିକ୍‌ ଜଃଗା ଅଃଉଁଲି ଜିରୁସାଲମ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଆୟା, ମର୍‌ କଃତା ସଃତ୍‌କଃର୍‌, ଗଟ୍‌ ଦିନ୍ ଆସେଦ୍‌, ଲକ୍‌ମଃନ୍ ଉବାକ୍‌ ଇ ଡଙ୍ଗ୍ରେ କି ଜିରୁସାଲମେ ସେବା ନଃକେର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ତୁମି ସମିରଣିୟ ମଃନ୍ ସଃତ୍‌କଃରି କାକେ ସେବା କଃରୁଲାସ୍‌ ନଃଜାଣୁଲାସ୍‌; ମଃତର୍‌ ଅଃମି ଜିଉଦିମଃନ୍ କାକେ ସେବା କଃରୁଲୁ ଜାଣୁଲୁ, ବଃଲେକ୍‌ ମୁକ୍ତି କଃର୍ତାର୍‌ ଜିଉଦିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ମଃତର୍‌ ଜୁୟ୍‌ ଦିନ୍ ସଃତ୍‌ ସେବାକଃର୍ତା ଲକ୍‌ମଃନ୍ ଆତ୍ମାୟ୍‌ ଆର୍‌ ସଃତ୍ୟା କଃରି ଉବାର୍‌ ହୁଜା କଃର୍ତି, ସେନ୍‌କାର୍‌ ଦିନ୍ ଆସୁଲି, ଆରେକ୍‌, ଅଃବେ ହେଁ ଆୟ୍‌ଲିନି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଉବା ଅଃନ୍‌କାର୍‌ ହୁଜାକଃର୍ତା ଲକ୍‌ମଃନ୍‌କେ ମଃନ୍ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଇସ୍ୱର୍‌ ଆତ୍ମା । ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ସେବା କଃର୍ତି, ସେମଃନ୍ ସଃତ୍‌ ଆର୍‌ ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ହୁଜା କଃର୍ତା ବିଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ସେ ମାୟ୍‌ଜି ଜିସୁକେ କୟ୍‌ଲି, “ମୁୟ୍‌ ଜାଣି, ମସିଅ ଜାକେ କ୍ରିସ୍ଟ ବଃଲି କଃଉତି, ସେ ଆସେଦ୍‌, ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେ ଆସେଦ୍‌, ସେ ଅଃମିକ୍‌ ସଃବୁ କଃତା କୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତର୍‌ ସଃଙ୍ଗ୍ କଃତା ଅଃଉଁଲେ ଜେ ମୁୟ୍‌, ମୁୟ୍‌ ହଃକା ସେମାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଅଃନ୍‌କାବଃଳ୍‌ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ବାଉଳି ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜିସୁ ଗଟ୍‌ ମାୟ୍‌ଜି ସଃଙ୍ଗ୍ ଗଟିକଃର୍ତାର୍‌ ଦଃକି ସେମଃନ୍ ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ କେହେଁ ସେ ମାୟ୍‌ଜିକେ, “ତର୍‌ କାୟ୍‌ରି ଲଳା ବଃଲି ନଃକୟ୍‌ଲାୟ୍‌, କି କାୟ୍‌କଃରୁକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତା ଅଃଉଁଲିସ୍‌, ବଃଲି” ଜିସୁକେ ହେଁ ହଃଚାରୁକ୍‌ ସାସ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ସେତାର୍‌ହଃଚେ ସେ ମାୟ୍‌ଜି ତାର୍‌ ହାଣି ଡକା ସେତି ଚାଡିକଃରି ଗଃଳ୍‌ ବିତ୍ରେ ଜାୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ଆସା, ଗଟ୍‌ ଲକ୍‌କେ ଦଃକାସ୍‌, ମୁୟ୍‌ ଜାୟ୍‌ଜାୟ୍‌ରି କଃରିଆଚି ସେରି ସଃବୁ ସେ ମକେ କୟ୍‌ଲା; ସେ କେଜାଣ୍ କ୍ରିସ୍ଟ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ କାୟ୍‌କି ?” ");
INSERT INTO bdv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ଗଃଳେହୁଣି ବାରାୟ୍‌ ଜିସୁର୍‌ ହାକ୍‌ ଜଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ସଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ ଗଃଉଆରି କଃରି କୟ୍‌ଲାୟ୍‌, ଏ ଗୁରୁ କାଦି କାଆ । ");
INSERT INTO bdv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ମଃତର୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜୁୟ୍‌ କାଦିର୍‌ କଃତା ନଃଜାଣାସ୍‌, କାଉଁକେ ଇବାନ୍ୟା କାଦି ମର୍‌ ତଃୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ସେତାକ୍‌ ଚେଲାମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “କେ ଅଲେ ତାକ୍‌ କାଦି ଆଣି ଦଃୟ୍‌ ରଃୟ୍‌ଦ୍‌ କାୟ୍‌କି ?” ");
INSERT INTO bdv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବା ଦଃୟ୍‌ରିଲା କାମ୍‌ ହୁରୁଣ୍ କଃର୍ତାର୍‌ ହଃକା ଅୟ୍‌ଲି ମର୍‌ କାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତାସ୍‌ କାଟୁକ୍‌ ଆରେକ୍‌ ଚାରି ମାସ୍‌ ଆଚେ, ଇରି କାୟ୍‌ ତୁମିମଃନ୍ ନଃକଉଁଲାସ୍‌ ? ମଃତର୍‌ ମୁୟ୍‌ ତୁମିକେ କଃଉଁଲେ, ନିକ କଃରି ତାସ୍‌ ହଃଦାୟ୍‌ମଃନ୍ ଅଃବେ ଦଃକା, ସେ ସଃବୁ କାଟୁକ୍‌ ହାକି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ଅଃବେ ହଃତେକ୍‌ ବୁତିଆର୍‌କେ ବୁତି ଦିଆ ଅଃଉଁଲି, ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ଗିନେ ତାସ୍‌ ରୁଣ୍ଡାଉଁଲା; ତଃବେ ବିଆନ୍ ବୁଣୁ ଆର୍‌ ତାସ୍‌ କାଟୁ, ଇ ଦୁୟ୍‌ଲକ୍‌ ସଃର୍ଦା କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଇ କଃତା ସଃତ୍ୟା, ଏକ୍ଲା ବୁଣେଦ୍‌ ଆରେକ୍‌ ଏକ୍ଲା କାଟେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ଜୁୟ୍‌ ହଃଦାୟ୍‌ ତୁମି କାମ୍‌ କଃରି ନଃରିଲାସ୍‌, ସେତି ତାସ୍‌ କାଟୁକ୍‌ ମୁୟ୍‌ ତୁମିକେ ହଃଟାୟ୍‌ ଆଚି; ବିନ୍‌ ଲକ୍‌ ସେତି କଃସ୍ଟ୍‌ କଃଲାୟ୍‌ ଆଚ୍‌ତି, ମଃତର୍‌ ତୁମି ଲାବ୍‌ ହାଉଁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ମୁୟ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ରି କଃରିଆଚି ସେରି ସଃବୁ ସେ ମକ୍‌ କୟ୍‌ଲା ବଃଲି ଜୁୟ୍‌ ମାୟ୍‌ଜି କୟ୍‌ରିଲି, ତାର୍‌ ସାକିର୍‌ ଗିନେ ସେ ଗଃଳାର୍‌ ସମିରଣିୟା ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ସେତାକ୍‌ ସମିରଣିୟମଃନ୍ ତାର୍‌ ଚଃମ୍‌ ଆସି, ସେମଃନ୍ ତାକେ ସେତି ସେମଃନ୍‌କାର ସଃଙ୍ଗ୍ ରେଉଁକେ ଗଃଉଆରି କଃଲାୟ୍‌, ତଃବେ ଜିସୁ ସେତି ଦୁୟ୍‌ଦିନ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଆର୍‌ ଜିସୁର୍‌ କଃତା ସୁଣି ଆରେକ୍‌ ଜଃବର୍‌ ଲକ୍‌ମଃନ୍ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଆର୍‌ ସେମଃନ୍ ସେ ମାୟ୍‌ଜିକେ କୟ୍‌ଲାୟ୍‌, “ତର୍‌ କଃତାର୍‌ ଗିନେ ଅଃମି ବିସ୍ୱାସ୍‌ ନଃକେରୁ, ମଃତର୍‌ ଜିସୁର୍‌ କଃତା ଅଃମିମଃନ୍‌ ନିଜେ ସୁଣି, ସେ ଜେ ନିଜ୍‌କଃରି ସଃତ୍‌ କଃରି ଜଃଗତାର୍‌ ରଃକ୍ୟାକଃର୍ତା ଲକ୍‌ ଇରି ଅଃମାର୍‌ ବିସ୍ୱାସ୍‌ ଅୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ଜିସୁ ସେତି ଦୁୟ୍‌ଦିନ୍ ରଃୟ୍‌କଃରି, ସେତି ହୁଣି ବାରାୟ୍‌ ଗାଲିଲି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଗଟ୍‌ ବାବ୍‌ବାଦି ନିଜାର୍‌ ଦେସେ ମାନ୍‌ତି ନଃହାୟ୍‌ ବଃଲି ଜିସୁ ନିଜେ ସାକିଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଆରେକ୍‌ ଜଃଡେବଃଳ୍‌ ଜିସୁ ଗାଲିଲି ହଚ୍‌ଲା, ଲକ୍‌ମଃନ୍ ଜିସୁକେ ହଃଟଳି ନିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁକ୍ତି ହଃର୍ବ୍‌ ବଃଳ୍‌ ଜିସୁ ଜିରୁସାଲମେ କଃରିରିଲା କାମ୍‌ ସଃବୁ ସେମଃନ୍ ଦଃକି ରିଲାୟ୍‌ । ବଃଲେକ୍‌ ସେମଃନ୍ ସେ ହଃର୍ବେ ଜାୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ତାର୍‌ ହଃଚେ ଗାଲିଲିର୍‌ କାନା ଗାଉଁଏ ବାଉଳ୍‌ଲା, ସେତି ସେ ହାଣିକ୍‌ ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ କଃରିରିଲା । ସେତି ଗଟ୍‌ ରାଜ୍‌ ଗୁମୁସ୍ତା ରିଲା ଆର୍‌ ତାର୍‌ ହୟ୍‌ସି କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ମଃଳୁ ହଃଳି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ସଃଡେବଃଳ୍‌ ସେ ରାଜ୍‌ ଗୁମୁସ୍ତା ଜିସୁ ଜିଉଦା ତଃୟ୍‌ହୁଣି ଗାଲିଲି ଆୟ୍‌ଲା ଆଚେ ବଃଲି ସୁଣି, ସେ ଜିସୁର୍‌ ଚଃମେ ଆୟ୍‌ଲା ଆର୍‌ କପୁର୍ନାହୁମ୍‌ ଜାୟ୍‌ ତାର୍‌ ହୟ୍‌ସିକ୍‌ ଉଜ୍‌ କଃରୁକେ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲା, ବଃଲେକ୍‌ ତାର୍‌ ହୟ୍‌ସି ମଃରୁକ୍‌ କଃଣ୍ଡେକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ସେତାକ୍‌ ଜିସୁ ତାକେ କୟ୍‌ଲା, “ଚିନ୍ ଆର୍‌ କାବା ଅଃଉତା କାମ୍‌ମଃନ୍‌ ନଃଦେକ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ କଃବେ ହେଁ ସଃତ୍‌ ନଃକେରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ରାଜ୍‌ ଗୁମୁସ୍ତା ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ମର୍‌ ହିଲା ମଃର୍ତା ଆଗ୍‌ତୁ ମର୍‌ ସଃଙ୍ଗ୍ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ତାକେ କୟ୍‌ଲା, “ଜା, ତର୍‌ ହୟ୍‌ଦି ବଚ୍‌ଲାବେ ।” ଜିସୁ ସେ ଲକେ ଜୁୟ୍‌ କଃତା କୟ୍‌ଲା, ସେ କଃତା ସଃତ୍‌କଃରି ସେତି ହୁଣି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ଆର୍‌ ସେ ଜଃଉଁଜଃଉଁ ତାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ ବାଟେ ବେଟ୍‌ଅୟ୍‌ ତର୍‌ ହିଲା ବଚ୍‌ଲାବେ ବଃଲି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ସେତାକ୍‌ ରାଜ୍‌ ଗୁମୁସ୍ତା ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “କଃଡେବଃଳ୍‌ ହିଲା ଉଜ୍‌ ଅୟ୍‌ଲା ।” ସେତାକ୍‌, ତାର୍‌ ଦଃଙ୍ଗ୍‌ଳାମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଗଃଲା କାଲି ସାତ୍‌ ଗଃଟା ବେଳାୟ୍‌ ତାର୍‌ ଜଃର୍‌ ଚାଡ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଇତାକ୍‌ ଉବାସି ବୁଜ୍‌ଲା ଜେ, ଜିସୁ ଜୁୟ୍‌ ବେଳାୟ୍‌ ତର୍‌ ହୟ୍‌ଦି ବଚ୍‌ଲାବେ ବଃଲି ତାକ୍‌ କୟ୍‌ରିଲା, ଟିକ୍‌ ସଃଡେବଃଳ୍‌ ଇ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ଲି । ଆର୍‌ ସେ ନିଜେ ଆର୍‌ ତାର୍‌ ସଃବୁ ଗଃର୍‌ କୁଟୁମ୍‌ ଜିସୁକେ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିସୁ ଜିଉଦା ତଃୟ୍‌ହୁଣି ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଗାଲିଲିକେ ଆୟ୍‌ଲା ହଃଚେ, ସେ ଇତାର୍‌ ସଃଙ୍ଗ୍ ଦୁୟ୍‌ତର୍‌ ଅୟ୍‌ଲି କାବା ଅଃଉତା ଚିନ୍ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ଇତାର୍‌ ହଃଚେ ଜିଉଦିମଃନାର୍‌ ଗଟ୍‌ ହଃର୍ବ ଆୟ୍‌ଲି, ଆର୍‌ ଜିସୁ ଜିରୁସାଲମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲମାର୍‌ ମେଣ୍ଡା ଦୁଆର୍‌ ଲଃଗେ ସେତି ଗଟ୍‌ ହାଣିବଃନ୍ଦ୍ ଆଚେ । ଏବ୍ରି ବାସାୟ୍‌ ତାକ୍‌ ବେତ୍‌ସଃୟ୍‌ଦା ବଃଲି କଃଉତି, ତାର୍‌ ହାଁଚ୍‌ଗଟ୍‌ ହିଣ୍ଡା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ସେ ହିଣ୍ଡା ଉହ୍ରେ ଗାଦେକ୍‌ ରଗେ ହଃଳ୍‌ଲା ଲକ୍‌ମଃନ୍, କାଣା, ଚଟା, ଗଃଗାଳ୍‌ ସୁକ୍‌ଲା ଲକ୍‌ମଃନ୍ ରେତିରିଲାୟ୍‌ । ସେମଃନ୍ ହାଣି ଜୁଲୁକ୍‌ତାର୍‌ ଜାଗି ରେତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ବଃଲେକ୍‌ କଃଡେକଃଡେ ବଃଳ୍‌ ମାପ୍ରୁର୍‌ ଦୁତ୍‌ ହାଣିବଃନ୍ଦେ ଉତ୍ରି ହାଣି ଜୁଲ୍‌କାଉତି ରିଲା, ଆର୍‌ ହାଣି ଜୁଲୁକ୍‌ଲା ହଃଚେ ଜେ ଆଗ୍‌ତୁ ସେତି ବୁଡ୍‌ତି ରିଲା, ସେ ଜୁୟ୍‌ ରଗେ ହଃଳି ରିଲେକ୍‌ ହେଁ ଉଜ୍‌ ଅଃଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ସେତି ଦୁୟ୍‌କଳି ଅଃଟ୍ର ବଃର୍ସ୍‌ ଦଃରି ଗଟେକ୍‌ ମଃଳୁ ହଃଳ୍‌ଲା ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁ ତାକେ ସେତି ରିଲାର୍‌ ଦଃକି, ବୁତେକ୍‌ ବଃର୍ସ୍‌ ହୁଣି ରଗେ ହଃଳି ଆଚେ ବଃଲି ଜାଣି ତାକ୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଉଜ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ସେ ରଗି ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ହାଣି ଦଃମ୍‌କ୍‌ଲା ବଃଳ୍‌ ମକ୍‌ ବଃନ୍ଦ୍‌ ବିତ୍ରେ ଟେକି ନେଉଁକ୍‌ ମର୍‌ କେ ହେଁ ନାୟ୍‌; ଆର୍‌ ମୁୟ୍‌ ଜଃଉଁ ଜଃଉଁ ବିନ୍ ଲକ୍‌ ମର୍‌ ଆଗ୍‌ତୁ ହାଣାୟ୍‌ ଜାୟ୍‌ ବୁଡୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଉଟ୍‌, ତର୍‌ ଟାଟି ଦଃରି ଇଣ୍ଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ସେଦାହ୍ରେ ସେ ରଗି ଉଜ୍‌ ଅୟ୍‌ଲା ଆର୍‌ ତାର୍‌ କଃଟ୍‌ ଦଃରି ଇଣ୍ଡୁକ୍‌ ଦଃର୍ଲା । ସେଦିନ୍ ବିସାଉଁଣି ବାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ସେତାକ୍‌ ଜିଉଦି ମୁଳିକାମଃନ୍ ଉଜ୍‌ ଅୟ୍‌ରିଲା ଲକେ କାଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଆଜି ବିସାଉଁଣିବାର୍‌, ତର୍‌ ଟାଟି ଉଟାୟ୍‌ ନେତାର୍‌ ବିଦି ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ମଃତର୍‌ ସେ କୟ୍‌ଲା, “ଜେ ମକ୍‌ ଉଜ୍‌ କଃଲା, ସେ ମକ୍‌ ଟାଟି ଦଃରି ଇଣ୍ଡି ଜାଆ ବଃଲି କୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତର୍‌ ଟାଟି ଦଃରି ଇଣ୍ଡି ଜାଆ ବଃଲି ଜେ କୟ୍‌ଲା, ସେ ମାନାୟ୍‌ କେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ମଃତର୍‌ ସେ କେ, ସେ ଉଜ୍‌ ଅୟ୍‌ଲା ମାନାୟ୍‌ ଜାଣି ନଃରିଲା, ବଃଲେକ୍‌ ସେତି ଅଲେକାର୍‌ ଲକ୍‌ ରିଲାକ୍‌, ଜିସୁ, ନଃଜାଣ୍‌ଲା ହର୍‌ ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ଇତାର୍‌ ହଃଚେ, ଜିସୁ ତାକେ ମନ୍ଦିରେ ବେଟ୍‌ ହାୟ୍‌ଲା ଆର୍‌ କୟ୍‌ଲା, “ଦଃକ୍‌, ଅଃବେ ତୁୟ୍‌ ଉଜ୍‌ ଅୟ୍‌ ଆଚ୍‌ସି; ହାହ୍‌ କଃର୍‌ ନାୟ୍‌, ଜଃନ୍‌କଃରି ତର୍‌ ଉହ୍ରେ ଅଃଦିକ୍‌ ଡଃଣ୍ଡ୍‌ ନଃହେଳେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ସେ ଲକ୍‌ ଜାୟ୍‌କଃରି, ଜେ ତାକ୍‌ ଉଜ୍‌ କଃରିରିଲା, ସେ ଜିସୁ ବଃଲି ଜିଉଦି ମୁଳିକାମଃନ୍‌କେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ତଃବେ ଜିସୁ ବିସାଉଁଣିବାର୍‌ ବିନ୍ ଉଜ୍‌ କଃର୍ତା କାମ୍‌ କଃରି ରିଲାକ୍‌, ଜିଉଦି ମୁଳିକାମଃନ୍ ତାକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ଉବା ସଃବୁବଃଳ୍‌ କାମ୍‌ କଃରୁଲା, ଆର୍‌ ମୁୟ୍‌ ହେଁ କଃରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଇ କଃତା ସୁଣି ଜିଉଦି ଲକ୍‌ମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ କୁଟ୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌; ବଃଲେକ୍‌ ଜିସୁ ବିସାଉଁଣି ବାରାର୍‌ ବିଦି ମାନ୍‌ତି ନଃରିଲା, ସେରି ହଃକା ନାୟ୍‌, ମଃତର୍‌ ଜିସୁ ଇସ୍ୱର୍‌କେ ନିଜାର୍‌ ଉବା ବଃଲି କୟ୍‌ ନିଜ୍‌କେ ଇସ୍ୱର୍‌ ସଃଙ୍ଗ୍ ସଃମାନ୍ କଃର୍ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ହୟ୍‌ସି ନିଜାର୍‌ କାୟ୍‌ରି କଃରୁ ନାହାରେ; ସେ ତାର୍‌ ଉବାସି ଜାୟ୍‌ରି କଃର୍ତାର୍‌ ଦଃକେଦ୍‌, ହୟ୍‌ସି ହେଁ ସେରି କଃରେଦ୍‌ । ଉବାସି ଜାୟ୍‌ରି କଃରେଦ୍‌, ହୟ୍‌ସି ହେଁ ସେରି କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ବଃଲେକ୍‌ ଉବାସି ହୟ୍‌ସିକ୍‌ ଲାଡ୍‌ କଃରୁଲା, ଆରେକ୍‌ ସେ ନିଜେ ଜାୟ୍‌ଜାୟ୍‌ରି କଃରେଦ୍‌ ସେରିମଃନ୍ ତାକେ ଦଃକାୟ୍‌ଦ୍‌, ଆର୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି କାବା ଅଃଉଆସ୍‌, ଇତାର୍‌ ଗିନେ ସେ ତାକେ ଇତାର୍‌ ତଃୟ୍‌ହୁଣି ଆରେକ୍‌ ବଃଡ୍ ବଃଡ୍ କାମ୍‌ ଦଃକାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଜଃନ୍‌କଃରି ଉବା ମଃଲା ଲକେ ଉଟାୟ୍‌ ସେମଃନ୍‌କେ ଜିବନ୍ କଃରେଦ୍‌, ସେରଃକମ୍‌ ହୟ୍‌ସି ହେଁ ଜାକେ ମଃନ୍ କଃରେଦ୍‌ ତାକ୍‌ ଜିବନ୍ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆର୍‌ ଉବାସି ହେଁ କାର୍‌ ବିଚାର୍‌ ନଃକେରେ, ମଃତର୍‌ ସଃବୁ ଲକ୍‌ ଜଃନ୍‌କଃରି ଉବାକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁଲାୟ୍‌, ସେରଃକମ୍‌ ହୟ୍‌ସିକ୍‌ ହେଁ ମାନ୍‌ତି କଃର୍ତି, ସେତାର୍‌ ଗିନେ ହୟ୍‌ସିକ୍‌ ସଃବୁ ରଃକମାର୍‌ ବିଚାର୍‌ କଃର୍ତା ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ଉବା ଜଃନ୍‌କଃରି ମାନ୍‌ତି ହାଉଁଲା, ହୟ୍‌ସି ହେଁ ସେନ୍‌କାର୍‌ ସଃବ୍‌କାର୍‌ ତଃୟ୍‌ହୁଣି ମାନ୍‌ତି ହାୟ୍‌ଦ୍‌; ଜେ ହୟ୍‌ସିକ୍‌ ମାୟ୍‌ନ୍‌ ନଃକେରେ, ସେ ତାକ୍‌ ହଃଟାୟ୍‌ରିଲା ଉବାସିକ୍‌ ହେଁ ମାନ୍‌ତି ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜେ ମର୍‌ କଃତା ସୁଣି ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌, ଆର୍‌ ସେ ବିଚାର୍‌ ଦଃଣ୍ଡେ ନଃହେଳି, ମଃର୍ନ୍‌କେ ଜିଣିକଃରି ଜିବନେ ଜାୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜଃଡେବଃଳ୍‌ ମଃଲା ଲକ୍‌ମଃନ୍ ଇସ୍ୱରାର୍‌ ହୟସିର୍‌ ଟଣ୍ଡ୍ ସୁଣ୍‌ତି, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସୁଣ୍‌ତି ସେମଃନ୍ ଜିବନ୍ ହାଉତି, ଅଃନ୍‌କା ବେଳା ଆସୁଲି ଆର୍‌ ସେ ବେଳା ଅଃବେ ହେଁ ଆୟ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ବଃଲେକ୍‌ ଉବା ଜଃନ୍‌କଃରି ନିଜେ ଜିବନ୍, ସେରଃକମ୍‌ ହୟ୍‌ସିକ୍‌ ହେଁ ନିଜେ ଜିବନାର୍‌ ମୁଳ୍‌ ଅଃଉଁକେ ଦଃୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଆର୍‌ ସେ ନଃରାର୍‌ ହୟ୍‌ସି ଅୟ୍‌ଲାକ୍‌, ଇସ୍ୱର୍‌ ତାକ୍‌ ବିଚାର୍‌ କଃରୁକେ ଅଃଦିକାର୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଇତାର୍‌ ଗିନେ କାବା ଅଃଉଆ ନାୟ୍‌, ବେଳା ଆସୁଲି ଜଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମଃସୁଣ୍‌ ବିତ୍ରେ ମଃରିଆଚ୍‌ତି, ସେମଃନ୍ ତାର୍‌ ଟଣ୍ଡ୍ ସୁଣ୍‌ତି, ");
INSERT INTO bdv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସଃତ୍‌ କାମ୍‌ କଃରିଆଚ୍‌ତି, ସେମଃନ୍ ଆରେକ୍‌ ଜିବନ୍ ହାୟ୍‌ ମଃସ୍‌ଣେ ହୁଣି ଉଟ୍‌ତି ଆର୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉତି ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଦୁସ୍ଟ୍‌କାମ୍‌ କଃରି ଆଚ୍‌ତି, ସେମଃନ୍ ହେଁ ଆରେକ୍‌ ଉଟ୍‌ତି ଆର୍‌ ଡଃଣ୍ଡ୍‌ ବଗ୍ କଃରୁକେ ବିଚାର୍‌ ହାଉତି, ଅଃନ୍‌କା ବେଳା ଆସୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ମୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ହେଁ କଃରୁ ନାହାରି, ମୁୟ୍‌ ଜଃନ୍‌କଃରି ସୁଣିନ୍ଦ୍ ସେନ୍‌କଃରି ବିଚାର୍‌ କଃରିନ୍ଦ୍‌, ଆର୍‌ ମର୍‌ ବିଚାର୍‌ ଟିକ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ଇଚା ହୁରୁଣ୍ କଃରୁକେ କାମ୍‌ ନଃକେରି, ମଃତର୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବାର୍‌ ଇଚା ହୁରୁଣ୍ କଃରୁକେ କାମ୍‌ କଃରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ଜଦି ମୁୟ୍‌ ମର୍‌ ନିଜାର୍‌ ବିସୟେ ନିଜେ କଃତା କୟ୍‌ଦ୍‌, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ମର୍‌ ସାକି ଦିଲାର୍‌ ସଃତ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ମର୍‌ ବାଟ୍‌ ଅୟ୍‌ ଜେ କଃତା କଃଉଁଲା ସେ ଆରେଗଟ୍‌ ଲକ୍‌; ଆରେକ୍‌ ମର୍‌ ବିସୟେ ସେ ଜାୟ୍‌ରି ସାକି ଦେଉଁଲା, ସେ କଃତା ସଃତ୍‌, ସେରି ମୁୟ୍‌ ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ତୁମିମଃନ୍ ଜହନ୍‌ ହାକ୍‌ ଲକ୍‌ ହଃଟାୟ୍‌ ରିଲାସ୍‌, ଆର୍‌ ସେ ସଃତ୍‌ ହାକ୍‌ ଅୟ୍‌ କଃତା ସାକି ଦଃୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ମୁୟ୍‌ ଲକାର୍‌ କଃତା ନଃଦେରି, ମଃତର୍‌ ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ହାହେହୁଣି ମୁକ୍ତି ହାଉଁ ହାରାସ୍‌ ସେତାକ୍‌ ଇରିମଃନ୍‌ ସାକି ଦେଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜହନ୍‌ ଗଟ୍‌ କଃଚ୍‌ତିରିଲା ଉଜାଳ୍‌ ଦେତା କୁପି ହର୍‌ ରିଲା, ଆର୍‌ ତୁମିମଃନ୍ ଅଃଳକ୍‌ ଦିନ୍ ହଃତେକ୍‌ ସେ ଉଜାଳେ ଉଜାଳ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃର୍ତି ରିଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ମଃତର୍‌ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ମର୍‌ ଗଟେକ୍‌ ବଃଡ୍ ସାକି ଆଚେ, ବଃଲେକ୍‌ ମର୍‌ ଉବା ଜୁୟ୍‌ କାମ୍‌ ସଃରାଉଁକେ ଦିଲାଆଚେ, ସେ ସଃବୁ ମୁୟ୍‌ କଃରୁଲେ, ଉବା ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ ବଃଲି ସେସଃବୁ ମର୍‌ ବିସୟେ କଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଆର୍‌ ଜୁୟ୍‌ ଉବା ମକ୍‌ ହଃଟାୟ୍‌ଲା, ସେ ମର୍‌ ବିସୟେ ସାକି ଦେଉଁଲା । ତୁମିମଃନ୍ କଃବେ ହେଁ ତାର୍‌ ଟଣ୍ଡ୍ ନଃସୁଣାସ୍‌ କି ତାର୍‌ ମୁଉଁ ନଃଦେକାସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଆର୍‌ ତାର୍‌ କଃତା ତୁମାର୍‌ ମଃନ୍ ବିତ୍ରେ ଟାଣ୍ ନଃହାୟ୍‌, ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ଜାକେ ହଃଟାୟ୍‌ଲା, ତାକେ ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ତୁମିମଃନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଲଳୁଲାସ୍‌, ବଃଲେକ୍‌ ସେତିହୁଣି ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଉନ୍ଦ୍ ବଃଲି ବାବୁଲାସ୍‌; ଆର୍‌, ସେ ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ ମର୍‌ ବିସୟେ ସାକି ଦେଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ମଃତର୍‌ ତୁମିମଃନ୍ ଜିବନ୍ ହାଉଁକ୍‌ ମର୍‌ ଲଃଗେ ଆସୁକ୍‌ ମଃନ୍ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ମୁୟ୍‌ ମାନାୟ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ହାଉଁକ୍‌ ମଃନ୍ ନଃକେରି, ");
INSERT INTO bdv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମଃତର୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜାଣିଆଚି, ତୁମିମଃନ୍ କଃନ୍‌କା ଲକ୍‌, ଆର୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍ ବିତ୍ରେ ଇସ୍ୱରାର୍‌ ଗିନେ ଲାଡ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ମୁୟ୍‌ ମର୍‌ ଉବାର୍‌ ନାଉଁଏ ଆୟ୍‌ଲେ ଆଚି, ଆର୍‌ ତୁମିମଃନ୍ ତ ମକେ ନଃଦେରୁଲାସ୍‌; ମଃତର୍‌ ବିନ୍ ଲକ୍‌ ଜଦି ନିଜାର୍‌ ନାଉଁଏ ଆସେଦ୍‌, ତଃବେ ତୁମିମଃନ୍ ତାକ୍‌ ଦଃରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ତୁମିମଃନ୍ ମକ୍‌ କଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରାସ୍‌ ? ତୁମିମଃନ୍ ତ ତୁମାର୍‌ ତୁମାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ହାଉଁଲାସ୍‌, ମଃତର୍‌ ଗଟେକ୍‌ ବଃଲି ଇସ୍ୱରାର୍‌ ଜୁୟ୍‌ ଜଃଜ୍‌ମାନ୍ ଆଚେ ସେରି ହାଉଁକ୍‌ ମଃନ୍ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ମୁୟ୍‌ ଜେ ଉବାର୍‌ ଲଃଗେ ତୁମାର୍‌ ବିରଦେ କଃତା କୟ୍‌ନ୍ଦ୍, ଇରି ବାବା ନାୟ୍‌; ଜୁୟ୍‌ ମସାକ୍‌ ତୁମିମଃନ୍ ଆସା କଃରି ଆଚାସ୍‌, ସେ ତୁମାର୍‌ ବିରଦେ କଃତା କଃଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଜଦି ମସାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ରିଲେକ୍‌ ମକ୍‌ ହେଁ ବିସ୍ୱାସ୍‌ କଃଲାସ୍‌ ହୁଣି, ବଃଲେକ୍‌, ସେ ମର୍‌ ବିସୟେ ଲେକିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ମଃତର୍‌ ତୁମିମଃନ୍ ଜଦି ମସା ଲେକ୍‌ଲା ଲେକା ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌, ତଃବେ କଃନ୍‌କଃରି ମୁୟ୍‌ କୟ୍‌ଲା କଃତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ଇତାର୍‌ ହଃଚେ ଜିସୁ ଗାଲିଲି ସଃମ୍‌ନ୍ଦାର୍‌ ବଃଲେକ୍‌ ତିବିରିଆ ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଆର୍‌ ରଗିମଃନ୍‌କେ ଜୁୟ୍‌ ଜୁୟ୍‌ କାବା ଅଃଉତା ଚିନ୍ କଃର୍ତିରିଲା, ସେରିସଃବୁ ଦଃକି ବୁତେକ୍‌ ଲକ୍‌ ତାର୍‌ ହଃଚେ ହଃଚେ ଜଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ସେତାକ୍‌ ଜିସୁ ହଃର୍ବାତ୍‌ ଉହ୍ରେ ଜାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେତି ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ସଃଡେବଃଳ୍‌ ଜିଉଦିମଃନାର୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଚଃମେ ଅୟ୍‌ ଆସ୍ତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ତାର୍‌ ଲଃଗେ ଅଲେକାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଆସ୍ତାର୍‌ ଦଃକି ଜିସୁ ପିଲିପ୍‌କେ ହଃଚାର୍ଲା, “ଅଃତେକ୍‌ ଲକ୍‌ମଃନାର୍‌ କାଉଁକେ କୁୟ୍‌ତି ହୁଣି କାଦି ଗେନୁଆଁ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ମଃତର୍‌ ପିଲିପକେ କଃଟ୍‌ହାଳ୍‌ ବୁଜୁକ୍‌ ଜିସୁ ଇ କଃତା କୟ୍‌ରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ କାୟ୍‌ କଃରୁକେ ଜାତିରିଲା ସେ ନିଜେ ଜାଣି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍ ଜିସୁକେ କୟ୍‌ଲା, “ଇ ସଃବୁ ଲକାର୍‌ ଗିନେ କଃଣ୍ଡେକ୍‌ କଃଣ୍ଡେକ୍‌ ଦେଉଁକ୍‌ ହାଁଚ୍‌କଳି ରୁହା ଟଃକାର୍‌ ରୁଟି ହେଁ ନଃକେଟେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଜିସୁର୍‌ ଆରେକ୍‌ ଗଟ୍‌ ଚେଲା ସିମନ୍ ପିତର୍‌ ତାର୍‌ ବାୟ୍‌ସି ଆନ୍ଦ୍ରିଅ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ଇତି ଗଟେକ୍‌ ହିଲାଆଚେ, ତାର୍‌ ଲଃଗେ ଜଃବ ତଃୟ୍‌ ତିଆର୍‌ ଅୟ୍‌ରିଲା ହାଁଚ୍ ଗଟ୍‌ ରୁଟି ଆର୍‌ ଜଳେକ୍‌ ବାଜ୍‌ଲା ମାଚ୍ ଆଚେ, ମଃତର୍‌ ଅଃତେକ୍‌ ଲକାର୍‌ ଗିନେ କାୟ୍‌ ଅୟ୍‌ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଲକ୍‌ମଃନ୍‌କେ ବଃସାଉଆ ।” ସେତି ଜଃବର୍‌ ରଃନ୍ ରିଲି, ସେ ରଃନ୍ ଉହ୍ରେ ସଃବୁଲକ୍‌ ବଃସ୍‌ଲାୟ୍‌; ସେତି ଅଃଣ୍ଡ୍ରାହିଲା ହଃକା ହାକାହାକି ହାଁଚ୍ ଆଜାର୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ସେତାକ୍‌ ଜିସୁ ସେ ରୁଟି ଦଃରି ଇସ୍ୱର୍‌କେ ପାର୍ତ୍‌ନା କଃରି ସେତି ବଃସି ରିଲା ଲକ୍‌ମଃନ୍‌କେ ବାଟାକଃରି ଦିଲା । ସେନ୍‌କଃରି ଜଳେକ୍‌ ମାଚ୍‌କେ ହେଁ ବାଟାକଃରି ଦିଲା, ସେମଃନ୍ ଜଃତେକ୍‌ ମଃନ୍‌କଃଲାୟ୍‌ ସଃତେକ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ଆର୍‌ ସେମଃନାର୍‌ ଆଦାର୍‌ ହୁର୍ଲାକ୍‌ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃନ୍‌କଃରି କାୟ୍‌ରି ନଃସ୍ଟ୍‌ ନୟେ, ଇତାର୍‌ ଗିନେ ବାଙ୍ଗ୍‌ଲା କୁଦ୍ରି ଜାୟ୍‌ରି ଉବ୍ରି ଆଚେ ସେରି ବେଟା ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଲକ୍‌ମଃନ୍ ଜଃବ ତଃୟ୍‌ ତିଆର୍‌ ଅୟ୍‌ଲା ହାଁଚ୍ ଗଟ୍‌ ରୁଟି କାୟ୍‌ ଉବୁର୍ଲାର୍‌ ବେଟି ବାର ଡଃଲା ବଃର୍ତି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ସେତାକ୍‌ ସେତି ରିଲା ଲକ୍‌ମଃନ୍ ଜିସୁ କଃଲାର୍‌ କାବା ଅଃଉତା ଚିନ୍ ଦଃକି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଜୁୟ୍‌ ବାବ୍‌ବାଦି ଜଃଗତାର୍‌ ଆସ୍ତାର୍‌ ରିଲି, ଏ ବାୟ୍‌ଦ୍‌ରେ ସେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଇତାକ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁକେ ବଃଳ୍‌ମାଡ୍‌କଃରି ଦଃରି ନଃୟ୍‌ ରଃଜା କଃରୁକେ ଉପାୟ୍‌ କଃରୁଲାୟ୍‌ ବଃଲି ଜାଣି, ଜିସୁ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଲ୍‌ଗା ଅୟ୍‌ ଏକ୍ଲା ହଃର୍ବାତ୍‌ ଉହ୍ରେ ଆରେକ୍‌ ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ସେଦିନ୍ ସଃଞ୍ଜ୍ ଅୟ୍‌ଲାକ୍‌ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ସଃମଃନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ଗଃଳାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ଆର୍‌ ଡଙ୍ଗାୟ୍‌ ବଃସି ସଃମଃନ୍ଦ୍ ସେହାଟି ରିଲା କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଜଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ସଃଡେବଃଳ୍‌ ରାତି ଅୟ୍‌ ଆସ୍ତି ରିଲି, ଜିସୁ ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ସେମଃନାର୍‌ ଲଃଗେ ଆସି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ସଃଡେବଃଳ୍‌ ଅଃପର୍‌ବଳ୍‌ ବାଉ ଆୟ୍‌ଲାକ୍‌ ହାଣାୟ୍‌ ଉଲାଳ୍‌ ଉଟ୍‌ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଇତାର୍‌ ହଃଚେ ଚେଲାମଃନ୍ ହାକାହାକି ଦୁୟ୍‌ ତିନି କସ୍‌ ଡଙ୍ଗା ଗାଟି ଗଃଲା ହଃଚେ ଜିସୁ ସଃମଃନ୍ଦ୍ ଉହ୍ରେ ଇଣ୍ଡି ଇଣ୍ଡି ଡଙ୍ଗା ଚଃମେ ଆସ୍ତିରିଲାର୍‌ ଦଃକି ଜଃବର୍‌ ଡିର୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇରି ତ ମୁୟ୍‌, ଡିରି ଜାହାନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ଜିସୁକେ ଡଙ୍ଗା ବିତ୍ରେ ନେଉଁକ୍‌ ମଃନ୍ କଃଲାୟ୍‌, ଆରେକ୍‌ ସେମଃନ୍ ଜୁୟ୍‌ ଟାଣେ ଜାତିରିଲାୟ୍‌ ଡଙ୍ଗା ତଃତ୍‌କାଣ୍ ସେଟାଣେ କଃଣ୍ଡିଏ ହଚ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ସେଟାଣେ ଗଟେକ୍‌ ଡଙ୍ଗା ଚାଡି ବିନ୍ କୁୟ୍‌ ଡଙ୍ଗା ହେଁ ନଃରିଲି, ଆର୍‌ ସେତି ଜେ ଜିସୁ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜାୟ୍‌ନଃରିଲା, ଇରି ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ଆର୍‌କ ବିନ୍ ସଃମଃନ୍ଦ୍ ସେହାଟି ଟିଅୟ୍‌ ରିଲାୟ୍‌ ସେମଃନ୍ ଦଃକି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ଜୁୟ୍‌ତି ମାପ୍ରୁ ଜିସୁ ପାର୍ତ୍‌ନା କଃରି ଲକ୍‌ମଃନ୍‌କେ ରୁଟି କାଉଁକେ ଦଃୟ୍‌ରିଲା, ସେ ଜଃଗା ଲଃଗେ ତିବିରିଆ ତଃୟ୍‌ହୁଣି ଆରେକ୍‌ କଃତିଗଟ୍‌ ଡଙ୍ଗା ଆସି ହଚ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ମଃତର୍‌ ଜିସୁ କି ତାର୍‌ ଚେଲାମଃନ୍ ସେତି ନଃରିଲାୟ୍‌, ଇରି ଦଃକି ଲକ୍‌ମଃନ୍ ଜିସୁକେ ଲଳି ଲଳି ଡଙ୍ଗାୟ୍‌ ଚଃଗି କପୁର୍ନାହୁମ୍‌ ଗଃଳେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଆର୍‌ ସଃମ୍‌ନ୍ଦାର୍‌ ସେହାଟି ଜିସୁକେ ଦଃକି ଲକ୍‌ମଃନ୍ ହଃଚାର୍ଲାୟ୍‌, “ଏ ଗୁରୁ, ତୁୟ୍‌ କଃଡେବଃଳ୍‌ ଆସି ଇତି ହଚ୍‌ଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମର୍‌ କାବା ଅଃଉତା ଚିନ୍ ଦଃକି, ମକେ ଲଳୁକ୍‌ ନାସାସ୍‌ । ମଃତର୍‌ ରୁଟି କାୟ୍‌ ଆଦାର୍‌ ହୁର୍ଲାକ୍‌ ମକେ ଲଳୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଜୁୟ୍‌ କାଦି ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌ ତାର୍‌ ଗିନେ କଃସ୍ଟ୍‌ କଃରା ନାୟ୍‌ । ମଃତର୍‌ ଜୁୟ୍‌ କାଦି ନଃସ୍ଟ୍‌ ନୟ୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍ ଦଃୟ୍‌ଦ୍‌, ସେତାର୍‌ ଗିନେ କଃସ୍ଟ୍‌ କଃରା; ଇ କାଦି ନଃରାର୍‌ ହୟ୍‌ସି ତୁମିମଃନ୍‌କେ ଦଃୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ଉବା ସେତାର୍‌ ଗିନେ ତାକ୍‌ ମୁଦ୍ରା ଦଃୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ଇସ୍ୱର୍‌ ଜୁୟ୍‌ରି ମଃନ୍ କଃରୁଲା ସେରି ଅଃମି କଃରୁକେ ଅଃମିକ୍‌ କାୟ୍‌ରି କଃରୁକେ ହଃଳେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜାକେ ଇସ୍ୱର୍‌ ହଃଟାୟ୍‌ ଆଚେ, ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲେକ୍‌ ତୁମିମଃନ୍ ସେରି କଃରୁ ହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ସେତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ତକେ ଅଃମି ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରୁନ୍ଦ୍‌ ସେତାର୍‌ ଗିନେ ଅଃମିକ୍‌ କାୟ୍‌ କାବା ଅଃଉତା ଚିନ୍ ଦଃକାଉଁ ହାର୍ସି ? କଃଉ କାୟ୍‌ କଃରୁ ହାର୍ସି ? ");
INSERT INTO bdv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ଟଃଙ୍ଗ୍ରାବଃଟାୟ୍‌ ମାନା କାୟ୍‌ଲାୟ୍‌, ଅଃମାର୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ସେ ଇ କାଦି ସଃର୍ଗେ ହୁଣି ଦିଲା ।’” ");
INSERT INTO bdv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ଜାୟ୍‌ରି ମସା ତୁମିମଃନ୍‌କେ ଦଃୟ୍‌ରିଲା, ସେରି ସଃର୍ଗେ ହୁଣି ଆୟ୍‌ଲା କାଦି ନାୟ୍‌; ମଃତର୍‌ ମର୍‌ ଉବା ତୁମିମଃନ୍‌କେ ସଃର୍ଗେ ହୁଣି ସଃତ୍ୟା କାଦି ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଜେ ସଃର୍ଗେ ହୁଣି ଉତ୍ରି ଆସି ଜଃଗତାର୍‌ ଜିବନ୍ ଦଃୟ୍‌ଦ୍‌, ସେ ଅଃଉଁଲା ସେ ଇସ୍ୱର୍‌ ଦେତା କାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଅଃମିକ୍‌ ସଃବୁବଃଳ୍‌ ଇ କାଦି ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସେ ଜିବନ୍ ଦେତା କାଦି, ଜେ ମର୍‌ ତଃୟ୍‌ ଆସେଦ୍‌, ତାକ୍‌ କଃବେ ହେଁ ବୁକ୍‌ ନୟ୍‌ । ଜେ ମକେ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ତାକ୍‌ କଃବେ ହେଁ ସସ୍‌ ନୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ତୁମିମଃନ୍ ମକେ ଦଃକି ହେଁ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ମର୍‌ ଉବା ମକେ ଦଃୟ୍‌ ଆଚେ, ସେମଃନ୍ ମର୍‌ ଲଃଗେ ଆସ୍ତି; ଆର୍‌ ଜେ ମର୍‌ ଲଃଗେ ଆସେଦ୍‌ ମୁୟ୍‌ କଃବେ ହେଁ ତାକ୍‌ ବାର୍‌କଃରି ନଃଦେୟ୍‌ଁ । ");
INSERT INTO bdv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ ମର୍‌ ଇଚା ହୁରୁଣ୍ କଃରୁକେ ନାୟ୍‌, ମଃତର୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଇସ୍ୱରାର୍‌ ଇଚା ହୁରୁଣ୍ କଃରୁକେ ମୁୟ୍‌ ସଃର୍ଗେ ହୁଣି ଆସି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଆର୍‌ ଜେ ମକେ ହଃଟାୟ୍‌ ଆଚେ ସେ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ମକ୍‌ ଦିଲା ଆଚେ, ସେମଃନାର୍‌ ବିତ୍ରେ ମୁୟ୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ହେଁ ଆରାୟ୍‌ ନଃକେରି, ମଃତର୍‌ ସେସ୍‌ ଦିନ୍ ସେ ସଃବ୍‌କେ ଆରେକ୍‌ ଉଟାୟ୍‌ନ୍ଦ୍, ଇରି ତାର୍‌ ଇଚା । ");
INSERT INTO bdv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଉବା ମଃନ୍ କଃରୁଲା, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ହୟ୍‌ସିକ୍‌ ଦଃକି ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତି, ସେମଃନ୍ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାଅତ୍‌ । ଇତାକ୍‌ ସେସ୍‌ ଦିନ୍ ମୁୟ୍‌ ସେ ସଃବ୍‌କେ ଆରେକ୍‌ ଉଟାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ଜିସୁ ନିଜ୍‌କେ ସଃର୍ଗେ ହୁଣି ଆୟ୍‌ଲା କାଦି ବଃଲି କୟ୍‌ଲାକ୍‌, ଜିଉଦିମଃନ୍ ଇ କଃତାକ୍‌ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଆର୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଇ ମାନାୟ୍‌ ତ ଜିସୁ ତାର୍‌ ଉବାସି କାୟ୍‌ ଜସେପ୍ ନୟ୍‌ ? ତାର୍‌ ଆୟ୍‌ସି ଉବାସିକ୍‌ ଅଃମି ଜାଣୁ, ତଃବେ ସେ ସଃର୍ଗେ ହୁଣି ଆସି ଆଚି ବଃଲି କଃନ୍‌କଃରି କଃଉଁଲା ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇ ସଃବୁ ଗାଣେଞ୍ଜ୍ କଃତା ଚାଡା ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ଜୁୟ୍‌ ଉବା ମକେ ହଃଟାୟ୍‌ ଆଚେ, ସେ ମର୍‌ ହାକ୍‌ ଜିକି କଃରି ନାଣ୍‌ଲେକ୍‌, କେହେଁ ମର୍‌ ଲଃଗେ ଆସୁ ନାହାରେ; ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଆସ୍ତି ସେମଃନ୍‌କେ ମୁୟ୍‌ ସେସ୍‌ ଦିନ୍ ଆରେକ୍‌ ଉଟାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବାବ୍‌ବାଦିମଃନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତରେ ଲେକି ଆଚ୍‌ତି, “ଇସ୍ୱର୍‌ ତଃୟ୍‌ ହଃକା ସଃବୁ ଲକ୍‌ ସିକ୍ୟା ହାଉତି ।” ଜୁୟ୍‌ ଲକ୍‌ ଉବାର୍‌ କଃତା ସୁଣି ତାର୍‌ ତଃୟ୍‌ହୁଣି ସିକ୍ୟା ହାୟ୍‌ଦ୍‌, ସେ ମର୍‌ ତଃୟ୍‌ ଆସେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଇତାର୍‌ ଅଃର୍ତ୍‌ ନାୟ୍‌ ଜେ, ବିନ୍ ଲକ୍‌ କେ ଉବାକ୍‌ ଦଃକି ଆଚେ, ସେରି ନାୟ୍‌, ଜେ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ଆଚେ ସେ ହଃକା ତାକେ ଦଃକିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ମୁୟ୍‌ ଜିବନ୍ ଦେତା କାଦି । ");
INSERT INTO bdv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ତୁମାର୍‌ ଦାଦିବାବୁମଃନ୍ ଟଃଙ୍ଗ୍ରାବଃଟାୟ୍‌ ମାନା କାୟ୍‌ଲାୟ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନ୍ ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ମଃତର୍‌ ଜୁୟ୍‌ କାଦି ସଃର୍ଗେ ହୁଣି ଆସେଦ୍‌, ତାକ୍‌ ଜେ କାୟ୍‌ଦ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ମୁୟ୍‌ ସଃର୍ଗେ ହୁଣି ଆୟ୍‌ଲା ସେ ଜିବନ୍ ଦେତା କାଦି । ଇ କାଦି ଜେ କାୟ୍‌ଦ୍‌ ସେ ସଃବୁ ଦିନ୍‌ ହାୟ୍‌ଁ ଜିବନ୍ ହାୟ୍‌ଦ୍‌ । ମୁୟ୍‌ ଜୁୟ୍‌ କାଦି ଦଃୟ୍‌ନ୍ଦ୍ ସେରି ମର୍‌ ଗଃଗାଳ୍‌ । ଜଃଗତ୍‌କେ ବଚାଉଁକ୍‌ ମୁୟ୍‌ ସେରି ଦଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ସେତାକ୍‌ ଇରି ସୁଣି ଜିଉଦିମଃନ୍ ରିସା ଅୟ୍‌ ଉରାଟୁ ଅୟ୍‌ କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇମାନାୟ୍‌ ତାର୍‌ ଗଃଗାଳ୍‌ କଃନ୍‌କଃରି ଅଃମିକ୍‌ କାଉଁକେ ଦଃୟ୍‌ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ନଃରାର୍‌ ହୟ୍‌ସିର୍‌ ଗଃଗାଳ୍‌ ନଃକାୟ୍‌ଲେକ୍‌ ଆର୍‌ ତାର୍‌ ବଃନି ନଃସୁର୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ଜିବନ୍ ହାଉଁ ନାହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ମାସ୍‌ କାୟ୍‌ଦ୍‌ ଆର୍‌ ମର୍‌ ବଃନି ସୁରେଦ୍‌ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ହାୟ୍‌ଦ୍‌ ଆର୍‌ ମୁୟ୍‌ ସେସ୍‌ ଦିନ୍ ତାକେ ଆରେକ୍‌ ଉଟାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ମାସ୍‌ ସଃତ୍‌ କାଦି ଆର୍‌ ମର୍‌ ବଃନି ସଃତ୍‌ ସୁର୍‌ତାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ମାସ୍‌ କାୟ୍‌ଦ୍‌ ଆର୍‌ ମର୍‌ ବଃନି ସୁରେଦ୍‌, ସେ ମର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ଦ୍‌ ଆର୍‌ ମୁୟ୍‌ ହେଁ ତାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜିବନାର୍‌ ଉବା ମକେ ହଃଟାୟ୍‌ ଆଚେ, ଆର୍‌ ତାର୍‌ ଗିନେ ମୁୟ୍‌ ହେଁ ଜିବନ୍ ଆଚି, ସେବାନ୍ୟା ଜେ ମର୍‌ ମାସ୍‌ କାୟ୍‌ଦ୍‌, ମର୍‌ ଗିନେ ସେ ହେଁ ଜିବନ୍ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଜୁୟ୍‌ କାଦି ସଃର୍ଗେ ହୁଣି ଆସି ଆଚେ, ସେରି ଇ କାଦି । ତୁମାର୍‌ ଦାଦିବାବୁମଃନ୍ ଜଃନ୍‌କଃରି ସେ କାଦି କାୟ୍‌କଃରି ମଃଲାୟ୍‌, ଇରି ସେନ୍‌କାର୍‌ ନାୟ୍‌; ଜେ ଇ କାଦି କାୟ୍‌ଦ୍‌, ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ହାୟ୍‌ ବାଚି ରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁ କପୁର୍ନାହୁମ୍‌ ଗଃଳାର୍‌ ଗଟେକ୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ସିକ୍ୟା ଦେତାବଃଳ୍‌ ଇରି ସଃବୁ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ତଃବେ ଜିସୁର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଇ ସଃବୁ କଃତା ସୁଣି କୟ୍‌ଲାୟ୍‌, “ଇରି ବାନ୍ୟା କଃତା, କେ ଇରି ସଃବୁ ସୁଣୁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ମଃତର୍‌ ଜିସୁ, ତାର୍‌ ଚେଲାମଃନ୍ ଜେ ସେ କଃତାକ୍‌ ଗାଣେଞ୍ଜ୍ କଃଉଁଲାୟ୍‌, ସେରି ମଃନେ ଜାଣୁ ହାରି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇରି କାୟ୍‌ ତୁମିମଃନାର୍‌ ବାଦା ଅଃଉଁଲି ? ");
INSERT INTO bdv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ତଃବେ ନଃରାର୍‌ ହୟ୍‌ସି ଜୁୟ୍‌ତି ହୁଣି ଆସି ଆଚେ, ସେଟାଣେ ଲେଉଟି ଜାତାର୍‌ ଦଃକ୍‌ଲେକ୍‌, କାୟ୍‌ କଃରାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ଇସ୍ୱରାର୍‌ ଆତ୍ମା ହଃକା ଜିବନ୍ ଦେଉଁ ହାରେ । ନଃରାର୍‌ ଗଃଗାଳ୍‌ ତଃୟ୍‌ର୍‌ ସଃକ୍ତି କାୟ୍‌ରି ହେଁ କଃରୁ ନାହାରେ । ଇସ୍ୱରାର୍‌ ସେ ଜିବନ୍ ଦେତା ଆତ୍ମାକେ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଜାଣୁ ହାରାସ୍‌, ସେତାର୍‌ ଗିନେ ମୁୟ୍‌ ଇ ସଃବୁ କଃତା କୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମିମଃନାର୍‌ ବିତ୍ରେ କେ କେ ସଃତ୍‌ ନଃକେରୁଲାୟ୍‌ ।” କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁକେ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସଃତ୍‌ ନଃକେର୍ତି ଆର୍‌ ତାକେ ସଃତ୍ରୁ ଆତେ କେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌, ସେରି ସେ ଆଗ୍‌ତୁ ହୁଣି ଜାଣି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ କଃଉଁଲେ, ଉବା ନଃହେଟାୟ୍‌ଲେକ୍‌, କେ ମର୍‌ ତଃୟ୍‌ ଆସୁ ନାହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଇ କଃତା ସୁଣି ସଃଡେବଃଳ୍‌ ହୁଣି ଜିସୁର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଜଃଉଁକେ ମଃନ୍ ନଃକେରି ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ସେତାକ୍‌ ଇରି ଦଃକି ଜିସୁ ତାର୍‌ ବାର ଗଟ୍‌ ଚେଲାମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ ହେଁ କି ମକେ ଚାଡି ଜଃଉଁକେ ମଃନ୍ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମନ୍ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ମାପ୍ରୁ, ଅଃମି ଆର୍‌ କାର୍‌ ଲଃଗେ ଜଃଉଁନ୍ଦ୍ ? ତର୍‌ ତଃୟ୍‌ ତ ଅଃମ୍ବର୍‌ ଜିବନାର୍‌ କଃତାଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ତୁୟ୍‌ ତ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆୟ୍‌ଲା ପବିତ୍ର ମାନାୟ୍‌, ଇ କଃତା ଅଃମି ଅଃବେ ସଃତ୍‌କଃରି ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ କାୟ୍‌ ତୁମିକେ ବାର ଲକ୍‌କେ ବାଚ୍‌ଲାର୍‌ ନାୟ୍‌ ? ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌ ସୟ୍‌ତାନ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଜିସୁ ଇସ୍କାରିଅତ୍‌ ସିମନାର୍‌ ହୟ୍‌ସି ଜିଉଦାକେ ଦଃକିକଃରି ଇ କଃତା କୟ୍‌ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବାର ଗଟ୍‌ ଚେଲା ବିତ୍ରେ ଗଟେକ୍‌ ଚେଲା ଅୟ୍‌କଃରି ହେଁ ଜିଉଦା ଜିସୁକେ ସଃତ୍ରୁ ଆତେ ଦଃରାୟ୍‌ ଦେଉଁକ୍‌ ଜାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ଇତାର୍‌ ହଃଚେ ଜିସୁ ଗାଲିଲି ତଃୟ୍‌ ବୁଲୁକ୍‌ ଦଃର୍ଲା; ସେ ଆର୍‌ ଜିଉଦା ଦେସେ ବୁଲୁକ୍‌ ମଃନ୍ ନଃକେଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେତିର୍‌ ଜିଉଦି ବଃଡ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ମଃର୍ନେ ମାରୁକ୍‌ ମଃନ୍ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଜିଉଦିମଃନାର୍‌ “କୁଳ୍ୟାୟ୍‌ ବାସା ଅଃଉତା” ହଃର୍ବ୍‌ ଦିନ୍ ଚଃମେ ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ସେତାକ୍‌ ଜିସୁର୍‌ ବାୟ୍‌ମଃନ୍‌ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇ ଜଃଗା ଚାଡି ଜିଉଦା ଦେସେ ଜାଆ, ତୁୟ୍‌ କଃର୍ତା କାମ୍‌ ସଃବୁ ସେତି ତର୍‌ ଲଃଗେ ଆସ୍ତା ଚେଲାମଃନ୍‌ ଦଃକତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ବଃଲେକ୍‌ କେ ନିଜ୍‌କେ ଜାଣାୟ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃଲେକ୍‌, ସେ ଅଃହ୍‌ଣାର୍‌ କାମ୍‌ ଲୁକାୟ୍‌କଃରି ନଃକେରେ, ତୁୟ୍‌ ଜଃଡେବଃଳ୍‌ ଇ ସଃବୁ କାମ୍‌ କଃରୁଲିସ୍‌, ତଃବେ ଜଃଗତାର୍‌ ସଃବୁ ତକେ ଜାଣତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ବଃଲେକ୍‌ ତାର୍‌ ବାୟ୍‌ମଃନ୍ ହେଁ ତାକେ ବିସ୍ୱାସ୍‌ ନଃକେର୍ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ବେଳା ଅଃବେ ହଃତେକ୍‌ ଆସି ନଃକେରେତା, ମଃତର୍‌ ତୁମିମଃନାର୍‌ ଗିନେ ସଃବୁ ବେଳା ଟିକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଃଗତ୍‌ ତୁମିକେ ଗିଣ୍ ନଃକେରେ । ମଃତର୍‌ ଜଃଗତ୍‌ ମକ୍‌ ଗିଣ୍ କଃରେଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ କାମ୍‌ ସଃବୁ କଃରାବ୍‌ ବଃଲି ମୁୟ୍‌ ସାକି ଦଃୟ୍‌ ଆସୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ତୁମିମଃନ୍ ଇ ହଃର୍ବ୍‌କେ ଜାହା, ମୁୟ୍‌ ଜଃଉଁ ନାହାରି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମର୍‌ ବେଳା ଅଃବେ ହଃତେକ୍‌ ଆସି ନଃକେରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଇ ସଃବୁ କଃତା କୟ୍‌ ଜିସୁ ଗାଲିଲିୟେ ରଃୟ୍‌ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ମଃତର୍‌ ଜିସୁର୍‌ ବାୟ୍‌ସିମଃନ୍ ହଃର୍ବ୍‌କେ ଗଃଲା ହଃଚେ, ଜିସୁ ହେଁ ଗଃଲା । ଜାଣ୍‌ତେ ନାୟ୍‌ ମଃତର୍‌ ଗଟ୍‌ ରଃକମ୍‌ ଲୁକ୍‌ଣେ । ");
INSERT INTO bdv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଇତାକ୍‌ ଜିଉଦିମଃନ୍ ହଃର୍ବ୍‌ ବଃଳ୍‌ ଜିସୁକେ ଲଳୁ ଲଳୁ ହଃଚାର୍ଲାୟ୍‌, “ସେ କଃୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ଆର୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ବିସୟେ କୁସୁର୍‌କାସାର୍‌ ଅୟ୍‌ କଃତାବାର୍ତା ଅଃଉତି ରିଲାୟ୍‌ । କେ କେ କୟ୍‌ଲାୟ୍‌, “ସେ ଗଟେକ୍‌ ସଃତ୍‌ ଲକ୍‌,” ଆର୍‌ କେ କେ କୟ୍‌ଲାୟ୍‌, “ନାୟ୍‌, ସେ ଲକ୍‌ମଃନ୍‌କେ ବୁଲ୍‌ ବାଟ୍‌କେ ନେଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ମଃତର୍‌ ଜିଉଦି ବଃଡ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଡିରିକଃରି କେ ହେଁ ଜିସୁର୍‌ ବିସୟେ ଆକେଡାକେ କଃତାବାର୍ତା ନଃକେର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ମଃତର୍‌ ହଃର୍ବ୍‌ ଆଦ୍‌ବାଗ୍ ସଃର୍ଲା ହଃଚେ ଜିସୁ ମନ୍ଦିରେ ଜାୟ୍‌ ସିକ୍ୟା ଦେଉଁକ୍‌ ଆରୁମ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଇତାକ୍‌ ଜିଉଦି ବଃଡ୍‌ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ କୁୟ୍‌ତି ହେଁ ସିକ୍ୟା ନାହାୟ୍‌, ଅଃତେକ୍‌ କଃତା ଜାଣ୍‌ଲା କଃନ୍‌କଃରି ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ସିକ୍ୟା ମର୍‌ ନିଜାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ହୁଣି ଆୟ୍‌ଲା ସିକ୍ୟା ଦେଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଜେ ଜଦି ଇସ୍ୱରାର୍‌ ଇଚା ହୁରୁଣ୍ କଃରୁକେ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ମର୍‌ ସିକ୍ୟା ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆସିଆଚେ, କି ମୁୟ୍‌ ମର୍‌ ନିଜାର୍‌ ଅଃଦିକାରେ କଃଉଁଲେ, ସେରି ସେ ଜାଣୁ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଜେ ନିଜାର୍‌ ଅଃଦିକାରେ କଃତା କୟ୍‌ଦ୍‌, ସେ ନିଜାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ମଃନ୍ କଃରେଦ୍‌, ମଃତର୍‌ ଜେ ଅଃହ୍‌ଣାକ୍‌ ହଃଟାୟ୍‌ଲା ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ମଃନ୍ କଃରେଦ୍‌, ସେ ସଃତ୍‌ ଆର୍‌ ତାର୍‌ ତଃୟ୍‌ କାୟ୍‌ ଦୁସ୍ଟ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମସା କାୟ୍‌ ତୁମିମଃନ୍‌କେ ବିଦି ନଃଦେୟ୍‌ ? ମଃତର୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ କେ ହେଁ ସେ ବିଦି ନଃମାନାସ୍‌ । ତୁମିମଃନ୍ ମକେ ମାରୁକ୍‌ କାୟ୍‌ତାକ୍‌ ମଃନ୍ ହାଚୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ଲକ୍‌ମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତକ୍‌ ବୁତ୍‌ ଦଃରି ଆଚେ, ତକ୍‌ କେ ମାରୁକ୍‌ ମଃନ୍ କଃରୁଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଗଟେକ୍‌ ବଃଡ୍ କାମ୍‌ କଃଲେ, ଆର୍‌ ତୁମିମଃନ୍ ସଃବୁ ସେରି ଦଃକି କାବା ଅୟ୍‌ ଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ତୁମାର୍‌ ହୟ୍‌ଦିମଃନ୍‌କ୍‌ ସୁନତ୍‌ କଃରୁକେ ମସା ଆଦେସ୍‌ ଦିଲା ଆଚେ; ଇରି ମସାର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ଆଚେ ସେରି ନାୟ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ଦାଦିବାବୁ ତଃୟ୍‌ହୁଣି ଆସି ଆଚେ ଆର୍‌ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ହେଁ ହିଲାମଃନ୍‌କେ ସୁନତ୍‌ କଃରୁଲାସ୍‌ । ଆର୍‌ ସେତାକ୍‌ ବିସାଉଁଣିବାର୍‌ ବିଦି ନଃମାନୁଲାସ୍‌, ଇରି ମଃନେ ନଃହେକାଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଜଦି ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଗଟେକ୍‌ ହିଲାକ୍‌ ସୁନତ୍‌ କଃଲେକ୍‌ ମସାର୍‌ ବିଦି ଅମାନ୍ୟା କଃରା ନଃଉଁଲି, ତଃବେ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ମୁୟ୍‌ ଗଟେକ୍‌ ଲକାର୍‌ ସଃବୁ ଗଃଗାଳ୍‌କେ ଉଜ୍‌ କଃଲେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ମକ୍‌ ରିସା ଅଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ହଃଦାର୍‌ କଃତାକ୍‌ ଦଃକି ବିଚାର୍‌ କଃରା ନାୟ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ରି ଟିକ୍‌ ସେରି ବିଚାର୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଇତାକ୍‌ ଜିରୁସାଲମ୍‌ ତୟ୍‌ଁ କଃତେକ୍‌ ଲକ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଜୁୟ୍‌ ମାନାୟ୍‌କେ ମାରୁକ୍‌ ଜିଉଦି ବଃଡ୍‌ ଲକ୍‌ମଃନ୍ ମଃନ୍ କଃରୁଲାୟ୍‌, ଏ କାୟ୍‌ ସେ ନାୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଆର୍‌ ଦଃକା ସେ ସଃବୁ ଲକାର୍‌ ଆଗେ ଅଃତେକ୍‌ କଃତା କଃଉଁଲା, ମଃତର୍‌ ତାକେ ହଃଦେକ୍‌ କେ ହେଁ କାୟ୍‌ରି ନଃକଉଁଲାୟ୍‌ । ଏ କ୍ରିସ୍ଟ ବଃଲି ଜିଉଦି ମୁଳିକା ଲକ୍‌ମଃନ୍ କାୟ୍‌ ନିଜ୍‌କଃରି ଜାଣ୍‌ଲାୟ୍‌ନି ? ");
INSERT INTO bdv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଜଃଡେବଃଳ୍‌ କ୍ରିସ୍ଟ ଆସେଦ୍‌, ସେ କୁୟ୍‌ତି ହୁଣି ଆୟ୍‌ଲା କେ ଜାଣୁ ନଃହାର୍‌ତି, ମଃତର୍‌ ଇ ମାନାୟ୍‌ କୁୟ୍‌ତି ହୁଣି ଆୟ୍‌ଲା ଅଃମିମଃନ୍‌ ଜାଣୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ସେତାକ୍‌ ଜିସୁ ମନ୍ଦିରେ ସିକ୍ୟା ଦେତା ବଃଳ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁୟ୍‌ କେ ଆର୍‌ କୁୟ୍‌ତି ହୁଣି ଆସି ଆଚି, ତୁମିମଃନ୍ କାୟ୍‌ ଜାଣିଆଚାସ୍‌ ? ମୁୟ୍‌ ନିଜ୍‌ ନିଜ୍‌କେ ନାସି । ମକେ ଜେ ହଃଟାୟ୍‌ ଆଚେ, ସେ ସଃତ୍ୟା, ତୁମିମଃନ୍ ତାକ୍‌ ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ମଃତର୍‌ ମୁୟ୍‌ ତାକ୍‌ ଜାଣି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମକ୍‌ ସେ ହଃଟାୟ୍‌ ଆଚେ, ମୁୟ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ସେତାକ୍‌ ସେମଃନ୍ ଇରି ସୁଣି ତାକେ ଦଃରୁକ୍‌ ମଃନ୍ କଃଲାୟ୍‌, ମଃତର୍‌ ତାର୍‌ ଟିକ୍‌ ବେଳା ଆସି ନଃରିଲାକ୍‌, କେ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ଦେଉଁକ୍‌ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମଃତର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌, “ଏ ଜୁୟ୍‌ ସଃବୁ କାବା ଅଃଉତା ଚିନ୍ କଃରି ଆଚେ, କ୍ରିସ୍ଟ ଆୟ୍‌ଲେକ୍‌ ଇମାନାୟ୍‌ର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ଅଃଦିକ୍‌ କାବା ଅଃଉତା କାମ୍‌ କଃରେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଜିସୁର୍‌ ବିସୟେ ଲକ୍‌ମଃନ୍ ଇରଃକମ୍‌ କଃତା ବାର୍ତା ଅଃଉତାର୍‌ ପାରୁସିମଃନ୍ ସୁଣ୍‌ଲାୟ୍‌, ସେତାକ୍‌ ପାରୁସିମଃନ୍ ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଜିସୁକେ ବାନ୍ଦୁକେ ଜାଗୁଆଳିମଃନ୍‌କେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆର୍‌ ଅଃଳକ୍‌ ବେଳା ରଃୟ୍‌ନ୍ଦ୍, ତାର୍‌ହଃଚେ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ ବାଉଳି ଜାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ତୁମିମଃନ୍ ମକେ ଲଳାସ୍‌, ମଃତର୍‌ ନଃହାଉଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ତି ରଃୟ୍‌ନ୍ଦ୍ ତୁମିମଃନ୍ ସେତି ଜଃଉଁ ନାହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଇତାକ୍‌ ଜିଉଦି ମୁଳିକାମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଏ କୁୟ୍‌ତି ଜାୟ୍‌ଦ୍‌ ଜେ ଅଃମି ତାକେ ଲଳୁ ନଃହାରୁ ? ଜୁୟ୍‌ ଗ୍ରିକ୍‌ ଗଃଳେ ଚିନ୍‌ବିନ୍ ଅୟ୍‌ରିଲା ଜିଉଦି ମଃନାର୍‌ ତଃୟ୍‌ ଜାୟ୍‌କଃରି କାୟ୍‌ ଗ୍ରିକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦଃୟ୍‌ଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ତୁମିମଃନ୍ ମକେ ଲଳାସ୍‌, ମଃତର୍‌ ହାଉଁ ନାହାରାସ୍‌ ଆର୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ତି ରଃୟ୍‌ନ୍ଦ୍ ତୁମିମଃନ୍ ସେତି ଜଃଉଁ ନାହାରାସ୍‌ । ସେ ଇ ଜୁୟ୍‌ କଃତା କୟ୍‌ଲା, ସେତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ହଃର୍ବାର୍‌ ସେସ୍‌ ଦିନ୍, ବଃଲେକ୍‌ ବଃଡ୍ ଦିନ୍ ଜିସୁ ଟିଆ ଅୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌କଃରି କୟ୍‌ଲା, “ଜେ ସସେ ଆଚେ ସେ ମର୍‌ ଲଃଗେ ଆସ ଆର୍‌ ସୁର । ");
INSERT INTO bdv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଆର୍‌ ଜେ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଲେକା ହଃର୍କାରେ, ଜେ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ ତାର୍‌ ଗଃର୍ବେ ହୁଣି ଜିବନ୍ ଦେତା ହାଜ୍ରା ହାଣି ଉଚ୍‌ଳି ଜାତିରଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁ ପବିତ୍ର ଆତ୍ମାର୍‌ କଃତାକ୍‌ ଦଃରି ଇରି କୟ୍‌ଲା, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତି, ସେମଃନ୍ ହଃଚେ ଇ ପବିତ୍ର ଆତ୍ମା ହାଉତି, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ଜିସୁ ଜଃଜ୍‌ମାନ୍ ଅୟ୍‌ନଃରିଲା, ସେତାକ୍‌ ପବିତ୍ର ଆତ୍ମା ହାୟ୍‌ ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଜଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ଜିସୁର୍‌ ଇ କାତା ସୁଣ୍‌ଲାୟ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ବାୟ୍‌ଦ୍‌ରେ ସେ ବାବ୍‌ବାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ବିନ୍ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଏ କ୍ରିସ୍ଟ ।” ମଃତର୍‌ କେକେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “କ୍ରିସ୍ଟ କାୟ୍‌ ଗାଲିଲି ତଃୟ୍‌ହୁଣି ଆସେଦ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ସାସ୍ତର୍‌ ତଃୟ୍‌ଁ ଲେକା ଆଚେ, ‘କ୍ରିସ୍ଟ ଜେ ଦାଉଦ୍‌ ବଃଉଁସେହୁଣି ଆର୍‌ ଦାଉଦ୍‌ ଜୁୟ୍‌ତି ରିଲା, ସେ ବେତ୍‌ଲିହିମ୍‌ ଗାଉଁଏ ହୁଣି ଆସେଦ୍‌ ।’” ");
INSERT INTO bdv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ସେତାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଜିସୁର୍‌ ଗିନେ ଲକ୍‌ମଃନାର୍‌ କଃତା ବିନ୍‌ବିନ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଜିସୁକେ ଦଃରି ନେଉଁକ୍‌ ମଃନ୍ କଃର୍ତି ରିଲାୟ୍‌, ମଃତର୍‌ କେ ହେଁ ଜିସୁର୍‌ ଉହ୍ରେ ଆତ୍‌ ଦେଉଁ ନାହାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଇ ବିତ୍ରେ ଜାଗୁଆଳି ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନାର୍‌ ଲଃଗେ ବାଉଳି ଆୟ୍‌ଲାକ୍‌, ସେମଃନ୍‌କେ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ହଃଚାର୍ଲାୟ୍‌, “ଜିସୁକେ କାୟ୍‌ତାକ୍‌ ଦଃରି ନାଣ୍‌ଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ଜାଗୁଆଳିମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇମାନାୟ୍‌ ଜଃନ୍‌କା କଃତା କଃଉଁଲା, ତାର୍‌ ହର୍‌ କୁୟ୍‌ ମାନାୟ୍‌ କଃବେ ସେନ୍‌କାର୍‌ କଃତା ନଃକୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ସେତାକ୍‌ ପାରୁସିମଃନ୍ ସେମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌, “ତୁମିମଃନ୍ ହେଁ କାୟ୍‌ ବୁଲ୍‌କି ଆଚାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ପାରୁସି କି ଅଃମାର୍‌ ମୁଳିକାମଃନାର୍‌ ବିତ୍ରେ କେ କାୟ୍‌ ଗଟ୍‌ ଲକ୍‌ ହେଁ ଜିସୁକେ ବିସ୍ୱାସ୍‌ କଃରି ଆଚ୍‌ତି ? ");
INSERT INTO bdv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ମଃତର୍‌ ଇ ଲକ୍‌ମଃନ୍ ମସାର୍‌ ବିଦି ନଃଜାଣ୍‌ତି, ସେତାର୍‌ ଗିନେ ଇମଃନ୍‌ ସଃବୁ ସାୟ୍‌ପ୍‌ ହାୟ୍‌ଲା ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ସଃଡେବଃଳ୍‌ ନିକଦିମ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ପାରୁସି ସେତି ରିଲା, ସେ ଆଗ୍‌ତୁ ଗଟ୍‌ତର୍‌ ଜିସୁକେ ଦଃକୁକ୍‌ ହାୟ୍‌ରିଲା । ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ଅଃମି ମସାର୍‌ ବିଦି ହଃର୍କାରେ ଗଟ୍‌ ଲକ୍‌କେ ଦସି କଃର୍ତା ଆଗ୍‌ତୁ ତାର୍‌ କଃତା ବିଚାର୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ଆର୍‌ ସେ କାୟ୍‌ରି କଃରି ଆଚେ ସେରି ଦଃକୁକ୍‌ ହଃଳେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ଜିଉଦିମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ହେଁ କାୟ୍‌ ଗଟେକ୍‌ ଗାଲିଲିର୍‌ ଲକ୍‌ ? ବଃଲ୍‌କଃରି ସାସ୍ତର୍‌ ହଳ୍‌, ତଃବେ ଗାଲିଲି ତଃୟ୍‌ହୁଣି କୁୟ୍‌ ବାବ୍‌ବାଦି ହେଁ ଜଃଲମ୍‌ ଅଃଉଁ ନାହାରେ, ଇ କଃତା ତୁୟ୍‌ ଜାଣୁ ହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ଆର୍‌ ସେମଃନ୍ ସଃବୁଲକ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ତାର୍‌ହଃଚେ ଜିସୁ ଜିତ୍‌ ଡଙ୍ଗ୍ରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ସଃକାଳ୍ୟା ଜିସୁ ମନ୍ଦିର୍‌କେ ବାଉଳି ଆୟ୍‌ଲା, ଆର୍‌ ସେତି ସଃବୁ ଲକ୍‌ମଃନ୍ ରୁଣ୍ଡ୍‌ଲାକ୍‌, ସେ ବଃସି ସେମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକ୍‌ ମୁଳ୍ୟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ଆର୍‌ ଦଃର୍ମ୍‌ଗୁରୁ ଆର୍‌ ପାରୁସିମଃନ୍ ଦାରି କାମେ ଦଃରା ହଃଳ୍‌ଲା ଗଟେକ୍‌ ମାୟ୍‌ଜିକେ ଦଃରି ଆଣ୍‌ଲାୟ୍‌ ଆର୍‌ ସଃବୁ ଲକାର୍‌ ମଃଜାୟ୍‌ ଟିଆ କଃରି ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଏ ଗୁରୁ, ଇ ମାୟ୍‌ଜି ଦାରିକାମ୍‌ କଃର୍ତା ବଃଳ୍‌ ଦଃରା ହଃଳି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଅଃନ୍‌କା ମାୟ୍‌ଜିମଃନ୍‌କେ ଟେଳା ସୁତ୍ରି ମାରୁକ୍‌ ମସା ଅଃମିକ୍‌ ବିଦି ତଃୟ୍‌ ଆଡର୍‌ ଦଃୟ୍‌ଆଚେ । ତଃବେ ତୁୟ୍‌ ଇ ବିସୟେ କାୟ୍‌ ବଃଲୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ସେମଃନ୍ ଜିସୁକେ ହାନ୍ଦେ ହଃକାୟ୍‌ ଦଃସ୍‌ ଲାଦୁକ୍‌ ଇ କଃତା ହଃଚାରି ରିଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ମୁଆଁର୍‌ ହାଣି ଆଦ୍‌କଃରି ଆଙ୍ଗଟି ସଃଙ୍ଗ୍ ବୁୟେଁ ଲେକୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ସେମଃନ୍ ଜିସୁକେ ଆରେକ୍‌ ହଃଚାର୍ଲାକ୍‌, ଜିସୁ ମୁଣ୍ଡ୍ ଟେକି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ବିତ୍ରେ ଜେ କଃବେ କାୟ୍‌ ହାହ୍‌ ନଃକେରେ, ସେ ଆସି ତାକ୍‌ ହଃର୍ତୁ ଟେଳା ମାର ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଇରି କୟ୍‌ ଜିସୁ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ମୁଆଁର୍‌ ହାଣି ଆଦ୍‌କଃରି ବୁୟେଁ ଲେକୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଜିସୁର୍‌ କଃତା ସୁଣି ସେମଃନ୍ ବଃଡ୍ ତଃୟ୍‌ହୁଣି ଆରୁମ୍‌ କଃରି ସାନ୍ ହଃତେକ୍‌ ଗଟେକ୍‌ ହଃଚେ ଗଟେକ୍‌ କଃରି ସଃବୁ ହଃଳାୟ୍‌ଲାୟ୍‌ । ଆରେକ୍‌ ଜିସୁ ଆର୍‌ ସେ ମାୟ୍‌ଜି ହଃକା ସେତି ଟିଆ ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଆରେକ୍‌ ଜିସୁ ମୁଣ୍ଡ୍ ଟେକି ମାୟ୍‌ଜିକେ ହଃଚାର୍ଲା, “ସେମଃନ୍ କଃୟ୍‌ ? ତକ୍‌ ଦସି କଃରି ଡଃଣ୍ଡ୍‌ ଦେଉଁକ୍‌ କାୟ୍‌ ଗଟେକ୍‌ ଲକ୍‌ହେଁ ନଃରିଲାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ସେ କୟ୍‌ଲି, “ନାୟ୍‌ ମାପ୍ରୁ, କେ ହେଁ ନାୟ୍‌ ।” ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ମୁୟ୍‌ ହେଁ ତକ୍‌ ଦସି ବଃଲି ନଃକୟ୍‌ଁ । ଜାଆ, ମଃତର୍‌ ଆରେକ୍‌ ହାହ୍‌ କଃର୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ଆରେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଜଃଗତାର୍‌ ଉଜାଳ୍‌, ଜେ ମର୍‌ ହଃଚେ ହଃଚେ ଆସେଦ୍‌, ସେ ଜିବନାର୍‌ ଉଜାଳ୍‌ ହାୟ୍‌ଦ୍‌, ଆର୍‌ ସେ କଃବେ ହେଁ ଅଃନ୍ଦାରେ ନିଣ୍ଡେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ସେତାକ୍‌ ପାରୁସିମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃବେ ତୁୟ୍‌ ନିଜେ ନିଜାର୍‌ ବିସୟେ ସାକି ଦେଉଁଲିସ୍‌, ସେତାକ୍‌ ତର୍‌ ସାକି ସଃତ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନାୟ୍‌, ମୁୟ୍‌ ନିଜାର୍‌ ଗିନେ ସାକି ଦିଲେକ୍‌ ହେଁ, ମୁୟ୍‌ ଜାୟ୍‌ରି କଃଉଁଲେ ସେରି ସଃତ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ କୁୟ୍‌ତି ହୁଣି ଆସି ଆଚି ଆର୍‌ କୁୟ୍‌ତି ଜଃଉଁଲେ, ସେରି ମୁୟ୍‌ ଜାଣି ଆଚି, ମଃତର୍‌ ମୁୟ୍‌ କୁୟ୍‌ତି ହୁଣି ଆସି ଆଚି ଆର୍‌ କୁୟ୍‌ତି ଜଃଉଁଲେ, ତୁମି ସେରି ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ତୁମିମଃନ୍ ମାନାୟ୍‌ ଇସାବେ ବିଚାର୍‌ କଃରାସ୍‌, ମଃତର୍‌ ମୁୟ୍‌ କାର୍‌ ବିଚାର୍‌ ନଃକେରି । ");
INSERT INTO bdv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ମଃତର୍‌ ମୁୟ୍‌ ଜଦି ବିଚାର୍‌ କଃରିନ୍ଦ୍‌, ତଃବେ ହେଁ ମର୍‌ ବିଚାର୍‌ ସଃତ୍ୟା, ବଃଲେକ୍‌ ମୁୟ୍‌ ଏକ୍ଲା ଇ କାମ୍‌ ନଃକେରି, ମଃତର୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବା ମର୍‌ ସଃଙ୍ଗ୍ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ତୁମାର୍‌ ବିଦି ସାସ୍ତରେ ଲେକା ଆଚେ, ‘ଦୁୟ୍‌ ଲକାର୍‌ ସାକି ସଃମାନ୍ ଅୟ୍‌ଲେକ୍‌, ସେମଃନ୍ ଜାୟ୍‌ରି କଃଉଁଲାୟ୍‌ ସେରି ସଃତ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ମୁୟ୍‌ ନିଜାର୍‌ ଗିନେ ସାକି ଦେଉଁଲେ, ଆର୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବା ହେଁ ମର୍‌ ଗିନେ ସାକି ଦେଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ସେତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ତର୍‌ ଉବାଦି କଃୟ୍‌ ?” ଜିସୁ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ମକ୍‌ କି ମର୍‌ ଉବାକ୍‌ ନଃଜାଣାସ୍‌, ମକେ ଜାଣ୍‌ଲେକ୍‌ ମର୍‌ ଉବାକ୍‌ ଜାଣ୍‌ଲାସ୍‌ ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ସିକ୍ୟା ଦେତାବଃଳ୍‌ ବଃଣ୍ଡାର୍‌ ବଃକ୍ରା ଚଃମେ ଇ ସଃବୁ କଃତା କୟ୍‌ ସିକ୍ୟା ଦେତିରିଲା, ମଃତର୍‌ ଜିସୁର୍‌ ବେଳ୍‌ ଆସି ନଃରିଲାକ୍‌ କେ ତାକ୍‌ ବାନ୍ଦୁକେ ନଃହାର୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁ ଆରେକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଜଃଉଁଲେ, ଆର୍‌ ତୁମିମଃନ୍ ମକ୍‌ ଲଳାସ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ହାହେ ମଃରାସ୍‌ । ମୁୟ୍‌ ଜୁୟ୍‌ତି ଜଃଉଁଲେ, ସେତି ତୁମିମଃନ୍ ଜଃଉଁ ନାହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ସେତାକ୍‌ ଜିଉଦି ବଃଡ୍ ଲକ୍‌ମଃନ୍ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ସେ କଃଉଁଲା, ‘ସେ ଜୁୟ୍‌ତି ଜାୟ୍‌ଦ୍‌, ସେତି ଅଃମିମଃନ୍‌ ଜଃଉଁ ନଃହାରୁ,’ ସେ କାୟ୍‌ ଉଚ୍‌କି ଅୟ୍‌ ମଃରୁକ୍‌ ଜଃଉଁଲା ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଇ ଜଃଗତେ ହୁଣି ଜାତ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ସଃର୍ଗେ ହୁଣି ଆୟ୍‌ଲେ ଆଚି । ତୁମିମଃନ୍ ଇ ଜଃଗତାର୍‌, ମଃତର୍‌ ମୁୟ୍‌ ଇ ଜଃଗତାର୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ସେତାକ୍‌ ମୁୟ୍‌ କଃଉଁଲେ, ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ହାହେ ମଃରାସ୍‌ । ମୁୟ୍‌ ଇରି ତୁମିକେ କୟ୍‌ଲେ, ବଃଲେକ୍‌ ମୁୟ୍‌ ଜେ, ମୁୟ୍‌ ସେ ମାନାୟ୍‌, ଇରି ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ ନଃକେଲେକ୍‌, ନିଜାର୍‌ ନିଜାର୍‌ ହାହେ ମଃରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତୁୟ୍‌ କେ ?” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ସେ କଃତା ମୁୟ୍‌ ଆରୁମେ ହୁଣି କୟ୍‌ ଆସୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ତୁମିମଃନାର୍‌ କଃତା କଃଉଁକେ ଆର୍‌ ତୁମିମଃନ୍‌କେ ବିଚାର୍‌ କଃରୁକେ ମର୍‌ ଗାଦେକ୍‌ କଃତା ଆଚେ । ମଃତର୍‌ ମକେ ଜେ ହଃଟାୟ୍‌ଲା ଆଚେ, ସେ ସଃତ୍‌, ତାର୍‌ ତଃୟ୍‌ହୁଣି ଜାୟ୍‌ରି ସୁଣି ଆଚି, ସେରି ଜଃଗତ୍‌କେ ଜାଣାଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଜିସୁ ତାର୍‌ ଉବାସିର୍‌ କଃତା କଃଉଁଲା, ଇରି ସେମଃନ୍ ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ନଃରାର୍‌ ହୟ୍‌ସିକ୍‌ ଉହ୍ରେ ଉଟା ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ମୁୟ୍‌ ଜେ, ମୁୟ୍‌ ସେ ମାନାୟ୍‌; ଆର୍‌ ମୁୟ୍‌ ନିଜାର୍‌ ଅଃଦିକାରେ କାୟ୍‌ରି ହେଁ ନଃକେରି, ମଃତର୍‌ ଉବା ମକ୍‌ ଜଃନ୍‌କଃରି ସିକ୍ୟା ଦଃୟ୍‌ଆଚେ, ସେନ୍‌କଃରି ଇସଃବୁ କଃତା ଜେ କଃଉଁଲେ, ଇରି ତୁମିମଃନ୍ ବୁଜୁ ହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଜେ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ, ସେ ମର୍‌ ସଃଙ୍ଗ୍ ଆଚେ, ସେ ମକ୍‌ ଏକ୍ଲାକେ କଃବେ ନଃଚାଡେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ ଜାୟ୍‌ରି ମଃନ୍, ମୁୟ୍‌ ସେରି କଃରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁର୍‌ ଇ କଃତା ସଃବୁ ସୁଣି ଗାଦେକ୍‌ ଲକ୍‌ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ବଃଲେକ୍‌ ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତା ଜିଉଦିମଃନ୍‌କେ ଜିସୁ କୟ୍‌ଲା, “ଜଦି ମର୍‌ କଃତା ମାନି ତିର୍‌ ଅୟ୍‌ରିଆସ୍‌, ତଃବେ ତୁମି ନିଜ୍‌କଃରି ମର୍‌ ଚେଲା ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ତୁମିମଃନ୍ ସଃତ୍‌ ଜାଣାସ୍‌, ଆର୍‌ ସେ ସଃତ୍‌ ତୁମିମଃନ୍‌କେ ମୁକ୍ଳାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଜିଉଦିମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଅଃମି ଅବ୍ରାହାମାର୍‌ ବଃଉଁସ୍‌, ଅଃମି କଃବେ କାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଅୟ୍‌ ସେବା ନଃକେରୁ, ତଃବେ ତୁମିମଃନ୍ ମୁକ୍ଳାସ୍‌ ବଃଲି କଃନ୍‌କଃରି କଃଉଁଲିସ୍‌ ? ଇ କଃତାର୍‌ ଅଃର୍ତ୍‌ କାୟ୍‌ରି ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ହାହ୍‌ କଃର୍ତି, ସେ ହାହାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା । ");
INSERT INTO bdv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଗତିଦଃଙ୍ଗ୍‌ଳା ସଃବୁବଃଳ୍‌ ଗଃର୍‌ କୁଟୁମାର୍‌ ଲକ୍‌ ଅୟ୍‌ ନଃରେୟ୍‌, ମଃତର୍‌ ହଅ ସଃବୁ ଦିନ୍‌ ଗଃରାର୍‌ ଲକ୍‌ ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ବଃଲେକ୍‌ ହଅ ଜଦି ତୁମିମଃନ୍‌କେ ମୁକ୍ଳାୟ୍‌ଦ୍‌, ତଃବେ ତୁମିମଃନ୍ ନିଜ୍‌କଃରି ମୁକ୍ଳାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ତୁମିମଃନ୍ ଅବ୍ରାହାମାର୍‌ ବଃଉଁସ୍‌ ଇରି ମୁୟ୍‌ ଜାଣି ଆଚି । ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମିମଃନ୍ ମକେ ମାରୁକ୍‌ ମଃନ୍ ହାଚୁଲାସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ସିକ୍ୟା ସୁଣି ମାନୁକ୍‌ ମଃନ୍ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ମର୍‌ ଉବାର୍‌ ଟାଣେ ଜାୟ୍‌ ଜାୟ୍‌ରି ଦଃକି ଆଚି, ସେରି ସଃବୁ କଃଉଁଲେ । ମଃତର୍‌ ତୁମାର୍‌ ଉବାଦି କୟ୍‌ଲା ହର୍‌ ତୁମିମଃନ୍ କାମ୍‌ କଃରୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମାର୍‌ ଉବା ଅବ୍ରାହାମ୍‌ ।” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜଦି ନିଜ୍‌କଃରି ଅବ୍ରାହାମାର୍‌ ହୟ୍‌ସି ଅୟ୍‌ରିଲାସ୍‌ ହୁଣି, ତଃବେ ଅବ୍ରାହାମ୍‌ କଃଲା କାମ୍‌ ସଃବୁ କଃଲାସ୍‌ ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ସୁଣ୍‌ଲା ସଃତ୍‌କେ ଚାଡି, ମୁୟ୍‌ ଆରେକ୍‌ କାୟ୍‌ରି ନଃକୟ୍‌ଁ, ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁମିମଃନ୍ ମକେ ମଃର୍ନେ ମାରୁକ୍‌ ଚେସ୍ଟା କଃରୁଲାସ୍‌, ଅବ୍ରାହାମ୍‌ ଇବାନ୍ୟା କାମ୍‌ କଃରି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ତୁମିମଃନ୍ ତୁମାର୍‌ ଉବାଦିର୍‌ କାମ୍‌ କଃରୁଲାସ୍‌ ।” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ଦାରି ମାୟ୍‌ଜିର୍‌ ହିଲା ନାୟ୍‌; ଇସ୍ୱର୍‌ ହଃକା ଅଃମାର୍‌ ଉବା, ଆର୍‌ ଅଃମିମଃନ୍‌ ସଃତ୍‌କଃରି ତାର୍‌ ହଅ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଇସ୍ୱର୍‌ ଜଦି ନିଜ୍‌କଃରି ତୁମାର୍‌ ଉବାଦି ଅୟ୍‌ରିଲେକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ଲାଡ୍‌ କଃଲାସ୍‌ ହୁଣି, ବଃଲେକ୍‌ ମୁୟ୍‌ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ଅଃବେ ଇତି ଆଚି, ମୁୟ୍‌ ମର୍‌ ଅଃଦିକାରେ ନାସି, ମଃତର୍‌ ଇସ୍ୱର୍‌ ମକେ ହଃଟାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ମୁୟ୍‌ ଜାୟ୍‌ରି କଃଉଁଲେ, ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ବୁଜୁ ନଃହାରୁଲାସ୍‌ ? କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ସିକ୍ୟା ସୁଣି ସଃମ୍ବାଳୁ ନଃହାରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ତୁମାର୍‌ ଉବାଦି ସୟ୍‌ତାନ୍‌, ତାର୍‌ ଇଚା ହଃର୍କାରେ ତାର୍‌ କାମ୍‌ କଃରୁକେ ତୁମାର୍‌ ମଃନ୍; ରାଜି ଉବୁଜ୍‌ଲା ଦିନ୍ ହୁଣି ସେ ନଃର୍‌ ମାରୁ ରିଲା, ଆର୍‌ ସେ କଃବେ ସଃତ୍‌ ବାଟ୍ୟା ନଃରେୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ ତଃୟ୍‌ ସଃତ୍‌ ନାୟ୍‌, ଜଃଡେବଃଳ୍‌ ସେ ମିଚ୍ କୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ସେ ନିଜାର୍‌ ତଃୟ୍‌ହୁଣି କୟ୍‌ଦ୍‌ । କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ମିଚ୍ ଆର୍‌ ସେ ସଃବୁ ମିଚୁଆମଃନାର୍‌ ଉବାସି । ");
INSERT INTO bdv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ମଃତର୍‌ ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲାକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ମୁୟ୍‌ ହାହି ବଃଲି ତୁମାର୍‌ ବିତ୍ରେ କେ ମକ୍‌ ହଃର୍ମାଣ୍‌ ଦେଉଁ ହାରେ ? ମୁୟ୍‌ ଜଦି ସଃତ୍‌ କୟ୍‌ଦ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ମକ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଜେ ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଲମ୍‌, ସେ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣେଦ୍‌, ତୁମିମଃନ୍ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଲମ୍‌ ନଃଉଁଆସ୍‌, ସେତାକ୍‌ ମର୍‌ କଃତା ନଃସୁଣୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜିଉଦିମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ଗଟେକ୍‌ ସମିରଣିୟ, ଆର୍‌ ତକ୍‌ ଜେ ବୁତ୍‌ ଡଃସି ଆଚେ, ଇରି କାୟ୍‌ ଅଃମିମଃନ୍‌ ଟିକ୍‌ ନଃକଉଁଲୁ ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନାୟ୍‌, ମକ୍‌ ବୁତ୍‌ ନଃଡେସେ, ମଃତର୍‌ ମୁୟ୍‌ ମର୍‌ ଉବାକ୍‌ ମାନ୍‌ତି କଃରୁଲେ, ମଃତର୍‌ ତୁମିମଃନ୍ ମକ୍‌ ନଃମାନୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ମଃତର୍‌ ମୁୟ୍‌ ନିଜେ ନିଜ୍‌କେ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ମଃନ୍ ନଃକେରି, ମଃତର୍‌ ଇ କଃତା ମର୍‌ ଗିନେ ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌ ମଃନ୍ କଃରୁଲା, ଆର୍‌ ସେ ମର୍‌ ହାକ୍‌ ଅୟ୍‌ ବିଚାର୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ଜେ ମର୍‌ ସିକ୍ୟା ମାନେଦ୍‌, ସେ କଃବେ ହେଁ ମଃର୍ନ୍‌ ନଃଦେକେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଜିଉଦିମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃବେ ଅଃମିମଃନ୍‌ ଟିକ୍‌ ଜାଣ୍‌ଲୁ ଜେ, ସଃତ୍‌କଃରି ତକ୍‌ ବୁତ୍‌ ଡଃସି ଆଚେ । ଅବ୍ରାହାମ୍‌ ଆର୍‌ ବାବ୍‌ବାଦିମଃନ୍ ସଃବୁ ମଃଲାୟ୍‌ ଆର୍‌ ତୁୟ୍‌ କଃଉଁଲିସ୍‌, ଜେ ତର୍‌ ସିକ୍ୟା ମାନେଦ୍‌ ସେ କଃବେ ହେଁ ମଃର୍ନାର୍‌ ଗଃନ୍ଦ୍ ନାହାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ତୁୟ୍‌ କାୟ୍‌ ଅଃମାର୍‌ ଉବା ଅବ୍ରାହାମ୍‌ ହୁଣି ବଃଡ୍ ? ସେ ତ ମଃରି ଆଚେ, ବାବ୍‌ବାଦିମଃନ୍ ହେଁ ମଃଲାୟ୍‌ ଆଚ୍‌ତି, ତୁୟ୍‌ ନିଜ୍‌କେ କାୟ୍‌ ବଃଲି ମଃନେ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଜଦି ନିଜ୍‌କେ ଜଃଜ୍‌ମାନ୍ କଃରୁଲେ, ତଃବେ ମର୍‌ ଜଃଜ୍‌ମାନାର୍‌ କାୟ୍‌ ମଲ୍‌ ନାୟ୍‌, ଜେ ମର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁଲା, ସେ ମର୍‌ ଉବା, ଜାକେ ତୁମିମଃନ୍ ତୁମାର୍‌ ଇସ୍ୱର୍‌ ବଃଲି କଃଉଁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ତୁମିମଃନ୍ କଃବେ ତାକ୍‌ ନଃଜାଣାସ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ତାକ୍‌ ଜାଣି, ତାକ୍‌ ମୁୟ୍‌ ନଃଜାଣି ବଃଲି ଜଦି କୟ୍‌ଦ୍‌, ତଃବେ ତୁମାର୍‌ ହର୍‌ ମୁୟ୍‌ ହେଁ ଗଟେକ୍‌ ମିଚୁଆ ଅୟ୍‌ନ୍ଦ୍ । ମଃତର୍‌ ମୁୟ୍‌ ନିଜ୍‌କଃରି ତାକ୍‌ ଜାଣି ଆର୍‌ ତାର୍‌ କଃତା ମାନୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ତୁମିମଃନାର୍‌ ଉବାଦି ଅବ୍ରାହାମ୍‌ ମର୍‌ ଆସ୍ତା ଦିନ୍ ଦଃକିନ୍ଦ୍ ବଃଲି ଆସା କଃରି ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ରିଲା । ସଃତ୍‌କଃରି ସେ ମକ୍‌ ଦଃକି ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ସେତାକ୍‌ ଜିଉଦିମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ତକ୍‌ ତ ଦୁୟ୍‌କଳି ଦଃସ୍‌ ବଃର୍ସ୍‌ ହେଁ ନାୟ୍‌, ତୁୟ୍‌ କାୟ୍‌ ଅବ୍ରାହାମ୍‌କେ ଦଃକି ଆଚ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ଅବ୍ରାହାମାର୍‌ ଜଃଲମ୍‌ ହୁର୍ବେ ମୁୟ୍‌ ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ସେତାକ୍‌ ଇରି ସୁଣି ସେମଃନ୍ ଜିସୁକେ ମାରୁକ୍‌ ଟେଳା ବେଟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ସଃବୁ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ହିଟ୍‌କିକଃରି ମନ୍ଦିରେ ହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଗଟ୍‌ ଦିନ୍ ଜିସୁ ଜାତାବଃଳ୍‌ ବାଟେ ଗଟେକ୍‌ ଜଃଲମ୍‌ କାଣାକେ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ଚେଲାମଃନ୍ ଜିସୁକେ ହଃଚାର୍ଲାୟ୍‌, “ଏ ଗୁରୁ, କାର୍‌ ହାହ୍‌ ଗିନେ ଇ ଲକ୍‌ କାଣା ଅୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲା, ତାର୍‌ ନିଜାର୍‌ କି ତାର୍‌ ଆୟ୍‌ସି ଉବାସିର୍‌ ହାହାର୍‌ ଗିନେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ କୟ୍‌ଲା, “ଏ କି ତାର୍‌ ଉବାସି ଆୟ୍‌ସି ହାହ୍‌ ନଃକେର୍ତି, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ସଃକ୍ତି ଜଃନ୍‌କଃରି ଆର୍‌ ତଃୟ୍‌ ଜାଣା ହଃଳେଦ୍‌, ଇତାର୍‌ ଗିନେ ସେ କାଣା ଅୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନ୍ ବଃଳାର୍‌ ଉଜାଳ୍‌ ରେଉଁ ରେଉଁ ମର୍‌ ହଃଟାୟ୍‌ଲା ଉବାର୍‌ କାମ୍‌ ଅଃମିକ୍‌ କଃରୁକେ ହଃଳେଦ୍‌ । ରାତି ଆସୁଲି, ସଃଡେବଃଳ୍‌ କେ କାମ୍‌ କଃରୁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଇ ଜଃଗତେ ରେତା ହଃତେକ୍‌ ମୁୟ୍‌ ଜଃଗତାର୍‌ ଉଜାଳ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଇରି କୟ୍‌ଲା ହଃଚେ, ଜିସୁ ମାଟାୟ୍‌ ଲାଳ୍‌ ତୁକି ସେ ଲାଳେ କଃଣ୍ଡେକ୍‌ କାଦ କଃଲା ଆର୍‌ ସେରି ନଃୟ୍‌ ସେ କାଣାର୍‌ ଦୁୟ୍‌ ଅଃକାୟ୍‌ ଲାଗାୟ୍‌ ତାକ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ଜାଆ, ସିଲଅ ବଃନ୍ଦେ ମୁଉଁ ଦଃୟ୍‌ ଆଉ ।” ସିଲଅ ବଃଲେକ୍‌ ପେରିତ । ସେ ଲକ୍‌ ଜାୟ୍‌ ମୁଉଁ ଦୟ୍‌ଲା ଆର୍‌ ସେ ଦଃକୁକ୍‌ ହାର୍ଲା ଆର୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ସେତାକ୍‌ ହାକି ହଃଳ୍‌ସା ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ବିକ୍‌ ମାଗ୍‌ତାର୍‌ ଦଃକି ରିଲାୟ୍‌, ସେମଃନ୍ ହଃଚାର୍ଲାୟ୍‌, “ଇ ଲକ୍‌ କାୟ୍‌ ବଃସି ବିକ୍‌ ମାଗ୍‌ତି ନଃରିଲା ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","କେ କେ କୟ୍‌ଲାୟ୍‌, “ଏ ତ ସେ,” ଆର୍‌ କେ କେ କୟ୍‌ଲାୟ୍‌, “ନାୟ୍‌, ସେ ନାୟ୍‌, ମଃତର୍‌ ତାର୍‌ ହର୍‌ ଡିସୁଲା ।” ମଃତର୍‌ ସେ ଲକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ହଃକା ସେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତଃବେ ତୁୟ୍‌ କଃନ୍‌କଃରି ଦଃକୁ ହାରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ସେ କୟ୍‌ଲା, “ଜାକେ ଜିସୁ ବଃଲି କଃଉତି ସେ ଲକ୍‌ ମାଟାୟ୍‌ କାଦ ଚଃଟ୍‌କି ମର୍‌ ଜୁଳେକ୍‌ ଅଃକାୟ୍‌ ଲାଗାୟ୍‌ଲା, ଆର୍‌ ମକ୍‌ କୟ୍‌ଲା, ସିଲହକେ ଜାୟ୍‌ ମୁଉଁ ଦୟ୍‌ଅଃଉ; ସେତାକ୍‌ ମୁୟ୍‌ ଗଃଲେ ଆର୍‌ ମୁଉଁ ଦଃୟ୍‌ ଅୟ୍‌ଲେ, ଆର୍‌ ଆକି ଦଃକୁକ୍‌ ହାର୍ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ସେ କଃୟ୍‌ ?” ସେ ଲକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଆକି ଦଃକୁ ହାର୍ଲା ସେ ଜଃଲମ୍‌ କାଣାକେ ଲକ୍‌ମଃନ୍ ପାରୁସିମଃନାର୍‌ ଲଃଗେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ଜୁୟ୍‌ ଦିନ୍ କାଦ ଲାଗାୟ୍‌ ତାର୍‌ ଆକି ଦଃକାୟ୍‌ ରିଲା, ସେ ଦିନ୍ ବିସାଉଁଣିବାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ତଃବେ ପାରୁସିମଃନ୍ ଆରେକ୍‌ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “କଃନ୍‌କଃରି ସେ ଆକି ଦଃକୁକ୍‌ ହାର୍ଲା,” ସେତାକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ଆକି ଉହ୍ରେ ସେ କଃଣ୍ଡେକ୍‌ କାଦ ଲାଗାୟ୍‌ଲା, ମୁୟ୍‌ ଜାୟ୍‌ ଦଃୟ୍‌ ଆୟ୍‌ଲେ, ଆର୍‌ ମୁୟ୍‌ ଅଃବେ ଆକି ଦଃକୁ ହାରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ସେତାକ୍‌ ପାରୁସିମଃନାର୍‌ ବିତ୍ରେ କେ କେ କୟ୍‌ଲାୟ୍‌, “ଜେ ଇ ଚିନ୍ କଃରି ଆଚେ, ସେ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ନାସେ, ବଃଲେକ୍‌ ସେ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ମେଣ୍ଡୁଲା ।” ଆର୍‌ କେ କେ କୟ୍‌ଲାୟ୍‌, “ଗଟେକ୍‌ ହାହି ଲକ୍‌ କଃନ୍‌କଃରି ଇରଃକମ୍‌ କାବା ଅଃଉତା କାମ୍‌ କଃରୁହାରେ ?” ଇ କଃତାର୍‌ ଗିନେ ତାକାର୍‌ ବିତ୍ରେ କଃତା ବିନ୍‌ବିନ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ସେତାକ୍‌ ପାରୁସିମଃନ୍ ଆରେକ୍‌ ସେ ଲକ୍‌କେ ହଃଚାର୍ଲାୟ୍‌, “ଜେ ତକ୍‌ ଆକି ଦଃକାୟ୍‌ଲା ତାର୍‌ ବିସୟେ ତୁୟ୍‌ କାୟ୍‌ ବଃଲି କଃଉଁଲିସ୍‌ ?” ସେ ଲକ୍‌ କୟ୍‌ଲା, “ସେ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ମଃତର୍‌ ସେ ଜେ ଜଃଲମେ ହୁଣି କାଣା ରିଲା ଆର୍‌ ଆକି ଦଃକୁକ୍‌ ହାର୍ଲା ଇ କଃତା ତାର୍‌ ଉବାସି ଆୟ୍‌ସିକ୍‌ କୁଦି ନଃହେଚାର୍ତା ହଃତେକ୍‌ ଜିଉଦି ବଃଡ୍ ଲକ୍‌ମଃନ୍ ଇରି ସଃତ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ସେତାକ୍‌ ସେମଃନ୍ ତାର୍‌ ଆୟ୍‌ସି ଉବାସିକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତୁମାର୍‌ ଜୁୟ୍‌ ହଅ କାଣା ଅୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ ରିଲା ବଃଲୁଲାସ୍‌, ଏ କାୟ୍‌ ତୁମାର୍‌ ସେ ହଅ ? ତଃବେ ସେ ଅଃବେ କଃନ୍‌କଃରି ଦଃକୁ ହାରୁଲା ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ସେତାକ୍‌ ତାର୍‌ ଉବାସି ଆୟ୍‌ସି କୟ୍‌ଲାୟ୍‌, “ହେଁ, ଅଃମିମଃନ୍‌ ଜାଣୁ, ସେ ଅଃମାର୍‌ ହଅ, ସେ କାଣା ଅୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମଃତର୍‌ ସେ କଃନ୍‌କଃରି ଅଃବେ ଦଃକୁ ହାରୁଲା ଆର୍‌ କେ ତାକ୍‌ ଆକି ଦଃକାୟ୍‌ଲା, ସେରି ଅଃମି ନଃଜାଣୁ, ତାକ୍‌ ହଃଚାରା, ସେ ତ ବେଣ୍ଡ୍ୟା ଅୟ୍‌ଲା ଆଚେ, ଆର୍‌ ତାର୍‌ କଃତା ସେ ନିଜେ କଃଉ ହାରେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ସେଲକାର୍‌ ଉବାସି ଆୟ୍‌ସି ଜିଉଦି ବଃଡ୍ ଲକ୍‌ମଃନ୍‌କେ ଡିରି କଃରି ଇସଃବୁ କଃତା କୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଦି କେ ଜିସୁକେ କ୍ରିସ୍ଟ ବଃଲି ମାନେଦ୍‌, ତଃବେ ତାକେ ଦଃଳେ ହୁଣି ବାର୍‌ କଃରା ଅୟ୍‌ଦ୍‌; ଇରି ଜିଉଦିମଃନ୍ ଆଗେ ଟିକ୍‌ କଃରି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ସେତାକ୍‌ ତାର୍‌ ଉବାସି ଆୟ୍‌ସି କୟ୍‌ଲାୟ୍‌, “ତାର୍‌ ବଃୟ୍‌ସ୍‌ ଅୟ୍‌ଆଚେ ତାକ୍‌ ହଃଚାରା ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ସେତାକ୍‌ ସେମଃନ୍ ସେ ଜଃଲମ୍‌ କାଣାକେ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ କୁଦି କୟ୍‌ଲାୟ୍‌, “ଇସ୍ୱର୍‌କେ ଜଃଜ୍‌ମାନ୍‌ କଃରୁଲିସ୍‌ ତାର୍‌ ଚଃମେ ସଃୟ୍‌ତ୍‌ କଃରି କଃଉ, ଅଃମି ଜାଣୁ ଜୁୟ୍‌ ଲକ୍‌ ତକ୍‌ ଆକି ଦଃକାୟ୍‌ଲା ସେ ଗଟେକ୍‌ ହାହି ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ସେ ଲକ୍‌ କୟ୍‌ଲା, “ସେ ହାହି କି ନାୟ୍‌ ମୁୟ୍‌ ନଃଜାଣି, ଗଟେକ୍‌ କଃତା ହଃକା ଜାଣି, ମୁୟ୍‌ କାଣା ରିଲେ ଅଃବେ ଦଃକୁ ହାରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତକ୍‌ ସେ କାୟ୍‌ କଃଲା, କଃନ୍‌କଃରି ସେ ତର୍‌ ଆକି ମେଲା କଃଲା ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ସେଲକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ କୟ୍‌ ସଃର୍ଲେନି, ମଃତର୍‌ ତୁମିମଃନ୍ ସେ କଃତା ସୁଣୁକ୍‌ ମଃନ୍ ନଃକେଲାସ୍‌, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ସୁଣୁକ୍‌ କାୟ୍‌ତାକ୍‌ ମଃନ୍ କଃରୁଲାସ୍‌ ? ତୁମି ହେଁ କାୟ୍‌ ତାର୍‌ ଚେଲା ଅଃଉଁକେ ମଃନ୍ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ସାୟ୍‌ପ୍‌ ଦଃୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ସିନା ତାର୍‌ ଚେଲା, ଅଃମି ମସାର୍‌ ଚେଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ଅଃମି ଜାଣିଆଚୁ ଇସ୍ୱର୍‌ ମସାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା କଃରି ରିଲା, ମଃତର୍‌ ସେ ଲକ୍‌ କୁୟ୍‌ତି ହୁଣି ଆସି ଆଚେ, ସେରି ହେଁ ଅଃମି ନଃଜାଣୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ସେ ମାନାୟ୍‌ କୟ୍‌ଲା, “ଇରି ବଃଡେ କାବା ଅଃଉତା କାତା, ସେ ମକ୍‌ ଆକି ଦଃକାୟ୍‌ଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ କୁୟ୍‌ତି ହୁଣି ଆସି ଆଚେ ତୁମିମଃନ୍ ଇରି ନଃଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ଅଃମି ଜାଣୁ ଇସ୍ୱର୍‌ ହାହିମଃନାର୍‌ କଃତା ନଃସୁଣେ, ମଃତର୍‌ ଜଦି କେ ଇସ୍ୱର୍‌କେ ସେବା କଃରେଦ୍‌ ଆର୍‌ ତାର୍‌ ଇଚା ସାଦୁନ୍‌ କଃରେଦ୍‌, ତାର୍‌ କଃତା ହଃକା ଇସ୍ୱର୍‌ ସୁଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଜଃଗତାର୍‌ ଉବ୍‌ଜାଣ୍‌ ଅୟ୍‌ଲା ହୁର୍ବେ ହୁଣି କଃବେ ହେଁ ଜଃଲମ୍‌ କାଣାକେ ଆକି ଦଃକାୟ୍‌ଲାର୍‌ ସୁଣା ଜାୟ୍‌ ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଏ ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ନଃରିଲେକ୍‌, ସେ କଃବେ ଇ କାମ୍‌ କଃରୁ ନାହାର୍ଲା ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ତ ହୁରା ହାହେ ଜଃଲମ୍‌ ଅୟ୍‌ ହାହେ ବାଡି ଆଚ୍‌ସି, ଆର୍‌ ତୁୟ୍‌ ଅଃମିକ୍‌ ସିକ୍ୟା ଦେଉଁଲିସ୍‌ ?” ଇରି କୟ୍‌ ସେମଃନ୍ ତାକ୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ହୁଣି ବାର କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଜିଉଦି ବଃଡ୍ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ହୁଣି ବାର କଃରି ଆଚ୍‌ତି, ଜିସୁ ଇରି ସୁଣି ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ସେ ଲକ୍‌କେ ବେଟ୍‌ ହାୟ୍‌ ତାକ୍‌ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ନଃରାର୍‌ ହୟ୍‌ସିକ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ସେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ସେ କେ ମକ୍‌ କଃଉ, ଜଃନ୍‌କଃରି ମୁୟ୍‌ ତାକ୍‌ ବିସ୍ୱାସ୍‌ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ ତାକ୍‌ ଦଃକି ଆଚ୍‌ସି, ତର୍‌ ସଃଙ୍ଗ୍ ଅଃବେ ଜେ କଃତା କଃଉଁଲା, ସେ ହଃକା ସେ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ସେତାକ୍‌ ସେ କୟ୍‌ଲା, “ମାପ୍ରୁ ମୁୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲେ ।” ଆର୍‌ ସେ ଇରି କୟ୍‌ ଜିସୁର୍‌ ହାଦେ ଡୁଳି ଜୁଆର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଆରେକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ନଃଦେକ୍‌ତା ଲକ୍‌ ଜଃନ୍‌କଃରି ଦଃକ୍‌ତି ଆର୍‌ ଦଃକ୍‌ତା ଲକ୍‌ ଜଃନ୍‌କଃରି କାଣା ଅଃଉତି, ମାନାୟ୍‌ ମଃନାର୍‌ ଇ ବିଚାର୍‌ ଗିନେ ମୁୟ୍‌ ଜଃଗତ୍‌କେ ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ସେତି ରିଲା କଃତେକ୍‌ ପାରୁସିମଃନ୍ ଇ କଃତା ସୁଣି ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମି ହେଁ କାୟ୍‌ କାଣା ?” ");
INSERT INTO bdv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “କାଣା ଅୟ୍‌ରିଲେକ୍‌ ତୁମିମଃନ୍ ହାହି ନୟ୍‌ଲାସ୍‌ ହୁଣି । ମଃତର୍‌ ଦଃକୁ ହାରୁଲାସ୍‌ ବଃଲି କଃଉଁଲାସ୍‌, ସେତାକ୍‌ ତୁମିମଃନ୍ ଅଃଦିକ୍‌ ଦସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜିସୁ କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ଜୁୟ୍‌ ଲକ୍‌ ଦୁଆର୍‌ ବାଟ୍‌ ଅୟ୍‌ ମେଣ୍ଡା ସାଳେ ନଃହୁରି, ବିନ୍ ବାଟ୍‌ କଃତି ଡଃଗାୟ୍‌ ହୁରେଦ୍‌, ସେ ଚର୍‌ ଆର୍‌ କଃଙ୍ଗାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ମଃତର୍‌ ଜେ ଦୁଆର୍‌ ବାଟ୍‌ ଅୟ୍‌ ହୁରେଦ୍‌, ସେ ମେଣ୍ଡା ମଃନ୍ଦାର୍‌ ଗଃଉଳିଆ । ");
INSERT INTO bdv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଜାଗୁଆଳି ତାର୍‌ ଗିନେ ଦୁଆର୍‌ ଉଗାଳି ଦଃୟ୍‌ଦ୍‌, ଆର୍‌ ସେ ନିଜାର୍‌ ମେଣ୍ଡାମଃନ୍‌କେ ନାଉଁ ଦଃରି କୁଦ୍‌ଲେକ୍‌ ସେମଃନ୍ ତାର୍‌ କଃତା ସୁଣ୍‌ତି, ଆର୍‌ ସେ ମେଣ୍ଡାମଃନ୍‌କେ ହଃଦାୟ୍‌ ବାଟ୍‌ କାଡାୟ୍‌ ନଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ମେଣ୍ଡାମଃନ୍‌କେ ହଃଦାୟ୍‌ ଆଣ୍‌ତା ବଃଳ୍‌ ଆଗେ ଆଗେ ଗଃଉଳିଆ ଇଣ୍ଡେଦ୍‌ ଆର୍‌ ମେଣ୍ଡାମଃନ୍ ତାର୍‌ ହଃଚେ ହଃଚେ ଇଣ୍ଡ୍‌ତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ତାର୍‌ କୁଦ୍‌ତାର୍‌ ଚିନ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମେଣ୍ଡାମଃନ୍ ନଃଚିନ୍‌ଲା ଲକାର୍‌ ହଃଚେ ହଃଚେ କଃବେ ହେଁ ନଃଜାତି, ମଃତର୍‌ ତାର୍‌ ଚଃମେହୁଣି ହଃଳାୟ୍‌ ଜାତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ତାର୍‌ ଟଣ୍ଡ୍ ନଃଚିନ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ସେମଃନ୍‌କେ କଃତାୟ୍‌ କୟ୍‌ ଇରି କୟ୍‌ରିଲା, ମଃତର୍‌ ଲକ୍‌ମଃନ୍ ସେସଃବୁ କାୟ୍‌ରି ବଃଲି ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ସେତାକ୍‌ ଜିସୁ ଆରେକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ମୁୟ୍‌ ମେଣ୍ଡାମଃନାର୍‌ ଦୁଆର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ଆଗ୍‌ତୁ ଆସି ଆଚ୍‌ତି ସେମଃନ୍ ସଃବୁ ଚର୍‌ ଆର୍‌ ଜୁରିୟା, ମଃତର୍‌ ମେଣ୍ଡାମଃନ୍ ସେମଃନାର୍‌ କଃତା ନଃସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ମୁୟ୍‌ ଅଃଉଁଲେ ଦୁଆର୍‌, ଜେ ମର୍‌ ବାଟ୍‌ ଅୟ୍‌ ହୁରେଦ୍‌ ସେ ମୁକ୍ତି ହାୟ୍‌ଦ୍‌; ଆରେକ୍‌ ବିତ୍ରେ ଆସେଦ୍‌ ଆର୍‌ ହଃଦାୟ୍‌ ଜାୟ୍‌ ଚାରା ହାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଚର୍‌ ଚରୁକ୍‌, ମାରୁକ୍‌ ଆର୍‌ ନାସ୍‌ କଃରୁକେ ଆସେଦ୍‌; ସେମଃନ୍ ଜଃନ୍‌କଃରି ଜିବନ୍ ହାଉତି ଆର୍‌ ଜଃବର୍‌ କଃରି ହାଉତି, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ମୁୟ୍‌ ନିକ ମେଣ୍ଡା ଗଃଉଳିଆ, ମେଣ୍ଡାମଃନାର୍‌ ଗିନେ ମର୍‌ ଜିବନ୍ ଦଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଜେ ମେଣ୍ଡା ଗଃଉଳିଆ ନାୟ୍‌, ସେ ବୁତ୍ୟାର୍‌ ଗିନେ ବୁତି ହାଉଁକେ ମେଣ୍ଡା ଚଃରାୟ୍‌ଦ୍‌, ସେତାକ୍‌ ମେଣ୍ଡାମଃନ୍ ଜାର୍‌ ନିଜାର୍‌ ନାୟ୍‌, ସେ ବାଗ୍ ଆୟ୍‌ଲେକ୍‌ ମେଣ୍ଡାମଃନ୍‌କେ ଚାଡି ହଃଳାୟ୍‌ଦ୍‌ ଆର୍‌ ବାଗ୍ ସେମଃନ୍‌କେ ଦଃରି କାୟ୍‌ଦ୍‌, ଆର୍‌ ମେଣ୍ଡାମଃନ୍‌କେ ଜଃତ୍‌କଃତ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ବୁତ୍ୟାର୍‌ ଲାଗି ବଃର୍ତାନ୍‌ ହାଉଁକ୍‌ ମେଣ୍ଡା ଚଃରାୟ୍‌ଦ୍‌, ତଃବେ ସେ ମେଣ୍ଡାମଃନାର୍‌ ଗିନେ ଚିତା ନଃକେରେ । ");
INSERT INTO bdv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ମୁୟ୍‌ ନିକ ମେଣ୍ଡା ଗଃଉଳିଆ, ଉବା ଜଃନ୍‌କଃରି ମକ୍‌ ଜାଣିଆଚେ ଆର୍‌ ମୁୟ୍‌ ଉବାକ୍‌ ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ମୁୟ୍‌ ସେନ୍‌କଃରି ମର୍‌ ମେଣ୍ଡାମଃନ୍‌କେ ଜାଣି ଆର୍‌ ସେମଃନ୍ ହେଁ ମକ୍‌ ଜାଣ୍‌ତି । ଆର୍‌ ମୁୟ୍‌ ସେମଃନାର୍‌ ଗିନେ ଜିବନ୍ ଦେଉଁକ୍‌ ରାଜି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଜୁୟ୍‌ ମେଣ୍ଡାମଃନ୍ ଇ ସାଳେ ହୁଣି ନୟ୍‌, ମର୍‌ ଇବାନ୍ୟା ଆରେକ୍‌ ବିନ୍ ମେଣ୍ଡାମଃନ୍ ଆଚ୍‌ତି, ସେମଃନ୍‌କେ ହେଁ ମକ୍‌ ଆଣୁକେ ଅୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେମଃନ୍ ମର୍‌ ଟଣ୍ଡ୍ ସୁଣ୍‌ତି, ତଃବେ ଗଟେକ୍‌ ମଃନ୍ଦା ଆର୍‌ ଗଟେକ୍‌ ଗଃଉଳିଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ମୁୟ୍‌ ମର୍‌ ଜିବନ୍ ଦେଉଁକ୍‌ ମଃନ୍ କଃରୁଲେ, ତଃବେ ଉବା ମକ୍‌ ଲାଡ୍‌ କଃରୁଲା, ଆର୍‌ ମୁୟ୍‌ ମର୍‌ ଜିବନ୍ ଆରେକ୍‌ ହାଉଁକ୍‌ ସେରି ଦଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ମର୍‌ ଜିବନ୍‌କେ କେ ମର୍‌ ତଃୟ୍‌ହୁଣି ନେଉଁକ୍‌ ନାହାରେ । ମଃତର୍‌ ମୁୟ୍‌ ନିଜେ ମଃନ୍‌କଃରି ମର୍‌ ଜିବନ୍ ଦଃୟ୍‌ନ୍ଦ୍ । ନିଜାର୍‌ ଜିବନ୍ ଦେଉଁକ୍‌ ଆର୍‌ ତାକ୍‌ ବାଉଳାୟ୍‌ ଆଣୁକେ ମର୍‌ ଅଃଦିକାର୍‌ ଆଚେ, ଇରି କଃରୁକେ ମର୍‌ ଉବା ମକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଜିସୁର୍‌ ଇ କଃତାର୍‌ ଗିନେ ଆରେକ୍‌ ଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତା ବିନ୍‌ବିନ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ ବୁତ୍‌ ଡଃସି ଆଚେ, ସେ ଗଟେକ୍‌ ବଃୟା ! ତାର୍‌ କଃତା କାୟ୍‌ତାକ୍‌ ସୁଣୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ବିନ୍ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ବୁତ୍‌ ଡଃସ୍‌ଲାର୍‌ ଲକ୍‌ ଅଃନ୍‌କା କଃତା ନଃକୟ୍‌ଲା ହୁଣି, ଆରେକ୍‌ ବୁତ୍‌ କାୟ୍‌ କାଣାକେ ଆକି ଦଃକାଉଁ ହାରେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ସଃଡେବଃଳ୍‌ ସିତ୍‌ ମାସ୍‌, ଆର୍‌ ଜିରୁସାଲମ୍‌ ମନ୍ଦିରେ ହୁର୍ତା ହଃର୍ବ୍‌ ଅଃଉତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଆର୍‌ ଜିସୁ ମନ୍ଦିରେ ସଲ୍‌ମନ୍ ହିଣ୍ଡା ଉହ୍ରେ ବୁଲ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ସେତି ଜିଉଦିମଃନ୍ ଜିସୁକେ ଚାରିହାକ୍‌ ବେଳି ହଃଚାର୍ଲାୟ୍‌, “ଆର୍‌ କଃତି ଦିନ୍ ଅଃମିମଃନ୍‌କ୍‌ ଲୁକାୟ୍‌ ରେସି ? ଜଦି ତୁୟ୍‌ ହଃରାଣ୍ କ୍ରିସ୍ଟ, ତଃବେ ସଃତ୍‌ କଃରି ଅଃମିକ୍‌ କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଆଗେ କୟ୍‌ ସଃର୍ଲେନି, ମଃତର୍‌ ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌ । ଉବା ତଃୟ୍‌ହୁଣି ଅଃଦିକାର୍‌ ହାୟ୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ ସଃବୁ କାମ୍‌ କଃରୁଲେ, ସେରି ମର୍‌ ନାଉଁଏ ସାକି ଦେଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମଃତର୍‌ ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ ନଃକେରୁଲାସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମି ମର୍‌ ମେଣ୍ଡା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ମର୍‌ ମଃନ୍ଦାର୍‌ ମେଣ୍ଡାମଃନ୍ ମର୍‌ ଟଣ୍ଡ୍ ସୁଣ୍‌ତି, ଆର୍‌ ମୁୟ୍‌ ସେମଃନ୍‌କେ ଜାଣି ଆର୍‌ ସେମଃନ୍ ମର୍‌ ହଃଚେ ହଃଚେ ଆସ୍ତି । ");
INSERT INTO bdv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଆରେକ୍‌ ମୁୟ୍‌ ସେମଃନ୍‌କେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ଦଃୟ୍‌ନ୍ଦ୍, ଆର୍‌ ସେମଃନ୍ କଃବେ ନଃସ୍ଟ୍‌ ନଃଉତି । ଆର୍‌ ସେମଃନ୍‌କେ ମର୍‌ ତଃୟ୍‌ହୁଣି କେ ଚାଡାୟ୍‌ ନେଉଁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ମର୍‌ ଉବା ମକ୍‌ ଜାୟ୍‌ରି ଦଃୟ୍‌ଆଚେ, ସେରି ସଃବୁ ତଃୟ୍‌ହୁଣି ବଃଡେ ମଲ୍‌, ଆର୍‌ ଉବାର୍‌ ଆତେ ହୁଣି କେ ସେରି ଚାଡାୟ୍‌ ନେଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଉବା ଆର୍‌ ମୁୟ୍‌ ଏକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଇ କଃତା ସୁଣି ଜିଉଦିମଃନ୍ ଜିସୁକେ ମାରୁକ୍‌ ଆରେକ୍‌ ଟେଳା ବେଟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଉବାର୍‌ ବଲେ ମୁୟ୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ନିକ କାମ୍‌ କଃରିଆଚି, ତାର୍‌ ବିତ୍ରେ କୁୟ୍‌ ନିକ କାମାର୍‌ ଗିନେ ମକେ ମାରୁକ୍‌ ଟେଳା ବେଟି ଆଚାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଜିଉଦିମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ତର୍‌ ନିକ କାମାର୍‌ ଗିନେ ନାୟ୍‌ ମଃତର୍‌ ଇସ୍ୱର୍‌ ଲିନ୍ଦାର୍‌ ଗିନେ, ତୁୟ୍‌ ଗଟ୍‌ ସାନ୍ ଲକ୍‌, ମଃତର୍‌ ନିଜ୍‌କେ ଇସ୍ୱର୍‌ ସଃମାନ୍ କଃରୁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମାର୍‌ ବିଦିତଃୟ୍‌ ଲେକା ଆଚେ, ଇସ୍ୱର୍‌ କଃଉଁଲା, ‘ତୁମିମଃନ୍ ଇସ୍ୱର୍‌ମଃନ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଲଃଗେ ଇସ୍ୱରାର୍‌ ବଃଚନ୍ ଆୟ୍‌ଲି, ସେମଃନ୍‌କେ ଇତି ଇସ୍ୱର୍‌ମଃନ୍‌ ବଃଲି କୟ୍‌ଲା । ଆର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ କଃତା କାଟାଜ୍‌ଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ତଃନ୍‌ଅଲେ ଜାକେ ଇସ୍ୱର୍‌ ପବିତ୍ର କଃରି ଜଃଗତ୍‌କେ ହଃଟାୟ୍‌ ଆଚେ, ତାକେ ତୁମିମଃନ୍, ‘ମୁୟ୍‌ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି,’ ଇରି ମୁୟ୍‌ କୟ୍‌ଲାକ୍‌, ତୁୟ୍‌ ଇସ୍ୱର୍‌ ଲିନ୍ଦା କଃରୁଲିସ୍‌ ବଃଲି କଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଜଦି ମୁୟ୍‌ ମର୍‌ ଉବାର୍‌ ଇଚା ହଃର୍କାରେ କାମ୍‌ ନଃକେରୁଲେ, ତଃବେ ମକ୍‌ ବିସ୍ୱାସ୍‌ କଃରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ମଃତର୍‌ ଜଦି ମୁୟ୍‌ ତାର୍‌ ଇଚା ହଃର୍କାରେ କାମ୍‌ କଃରୁଲେ, ତଃବେ ମକ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେଲେକ୍‌ ହେଁ ଉବା ଜେ ମର୍‌ ତଃୟ୍‌ ଆଚେ ଆର୍‌ ମୁୟ୍‌ ଉବା ତଃୟ୍‌ ଆଚି, ଇରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ଜାଣାସ୍‌ ଆର୍‌ ବୁଜାସ୍‌ ଇତାର୍‌ ଗିନେ ମର୍‌ କାମ୍‌ ସଃବୁକ୍‌ ବିସ୍ୱାସ୍‌ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ସେତାକ୍‌ ସେମଃନ୍ ତାକ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଦଃରୁକ୍‌ ଚେସ୍ଟା କଃଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କଃସ୍ରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଇତାର୍‌ ହଃଚେ ଜିସୁ ଆରେକ୍‌ ଜର୍ଦନ୍ ଗାଡାର୍‌ ସେହାଟି ଗଃଲା, ଆର୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ଜହନ୍‌ ହଃର୍ତୁ ଜୁୟ୍‌ଟାଣେ ବାପ୍ତିସମ୍‌ ଦେତିରିଲା ସେତି ଜାୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଆର୍‌ ତାର୍‌ ଲଃଗେ ଗାଦେକ୍‌ ଲକ୍‌ ଆୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଜହନ୍‌ ନିଜେ କାବା ଅଃଉତା ଚିନ୍ କଃରି ନଃରିଲା, ମଃତର୍‌ ଇ ଲକାର୍‌ କଃତା ଜାୟ୍‌ରି କୟ୍‌ରିଲା ସେସଃବୁ ସଃତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆର୍‌ ସେତି ଜିସୁକେ ଗାଦେକ୍‌ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତାନିଆ ଗାଉଁଆର୍‌ ଲାଜାର୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ମଃଳୁ ହଃଳି ରିଲା; ମରିୟମ୍‌ ଆର୍‌ ତାର୍‌ ବେଣ୍‌ସି ମାର୍ତା ସେ ଗାଉଁଏ ରେତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଜୁୟ୍‌ ମାୟ୍‌ଜି ଜିସୁ ମାପ୍ରୁର୍‌ ହାଦେ ବାସ୍ନା ଚିକଣ୍‌ ଡାଳି ନିଜାର୍‌ ମୁଣ୍ଡାର୍‌ ବାଳେ ଜିସୁର୍‌ ହାଦ୍‌ ହୁଚ୍‌ଲି, ଇରି ସେ ମରିୟମ୍‌; ତାର୍‌ ବାୟ୍‌ସି ଲାଜାର୍‌ ମଃଳୁ ହଃଳି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ତଃବେ ସେ ଦୁୟ୍‌ ବେଣି ଜିସୁର୍‌ ହାକ୍‌ କବୁର୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ ଦଃକ୍‌ ଜାକେ ତୁୟ୍‌ ଲାଡ୍‌ କଃରୁଲିସ୍‌, ସେ ମଃଳୁ ହଃଳି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ମଃତର୍‌ ଜିସୁ ଇରି ସୁଣିକଃରି କୟ୍‌ଲା, “ଇ ଜଃର୍‌ ମଃରୁକ୍‌ ନୟ୍‌, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନାର୍‌ ଗିନେ, ସେତାର୍‌ଗିନେ ଜଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ ଅଃଉତା ସଃଙ୍ଗ୍ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ହେଁ ଜଃଜ୍‌ମାନ୍ ହାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ ମାର୍ତା ଆର୍‌ ତାର୍‌ ବେଣ୍‌ସି, ମରିୟମ୍‌ ଆର୍‌ ଲାଜାର୍‌କେ ଲାଡ୍‌ କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ତଃବେ ଲାଜାର୍‌ ମଃଳୁ ହଃଳି ଆଚେ ବଃଲି ଜିସୁ ସୁଣ୍‌ଲାକ୍‌ ହେଁ, ସେ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ରିଲା, ସେତି ଆରେକ୍‌ ଦୁୟ୍‌ ବିନ୍ ରଃୟ୍‌ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ଦୁୟ୍‌ ଦିନାର୍‌ ହଃଚେ ଜିସୁ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃମିମଃନ୍‌ ଜିଉଦାକେ ବାଉଳି ଜୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ଚେଲାମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ଏ ଗୁରୁ, ଜିଉଦିମଃନ୍ କଃତିଦିନ୍‌ ତଃଳେ ତକ୍‌ ଟେଳା ସୁତ୍ରି ମାରୁକ୍‌ ଚେସ୍ଟା କଃର୍ତି ରିଲାୟ୍‌, ସେତି କାୟ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ବାଉଳି ଜଃଉଁକେ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦିନ୍ କାୟ୍‌ ବାର ଗଃଟା ନାୟ୍‌ ? ଜେ ଦିନ୍ ବଃଳ୍‌ ବାଟ୍‌ ଇଣ୍ଡେଦ୍‌ ସେ ଜଟ୍ୟାୟ୍‌ ନୟ୍‌, ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ଉଜାଳ୍‌ ଜଃଗତ୍‌କେ ଦେତି ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମଃତର୍‌ ରାତି ବଃଳ୍‌ ଇଣ୍ଡ୍‌ଲେକ୍‌ ସେ ଜଟ୍ୟାୟ୍‌ଅୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ତାର୍‌ ତଃୟ୍‌ ଉଜାଳ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଜିସୁ ଇସଃବୁ କଃତା କୟ୍‌ଲା ହଃଚେ, ଚେଲାମଃନ୍‌କେ ଆରେକ୍‌ କୟ୍‌ଲା, “ଅଃମାର୍‌ ସଃଙ୍ଗ୍‌ବାୟ୍‌ ଲାଜାର୍‌ ନିଦୟ୍‌ଲା ଆଚେ, ମଃତର୍‌ ମୁୟ୍‌ ତାକ୍‌ ନିଦେ ହୁଣି ଉଟାଉତା ହାଁୟ୍‌ ଜଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ସେତାକ୍‌ ଚେଲାମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଜଦି ସେ ନିଦୟ୍‌ଲା ଆଚେ, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସେ ଉଜ୍‌ ଅୟ୍‌ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜିସୁ ଲାଜାରାର୍‌ ମଃର୍ନ୍‌ କଃତା କୟ୍‌ରିଲା, ମଃତର୍‌ ସେ ନିଦେ ସୟ୍‌ରିଲା କଃତା କୟ୍‌ଲା ବଃଲି ସେମଃନ୍ ମଃନେ ବାବ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ତଃବେ, ଜିସୁ ସଃଡେବଃଳ୍‌ ନିକ କଃରି ବୁଜାୟ୍‌ କୟ୍‌ଲା, “ଲାଜାର୍‌ ମଃରି ଆଚେ; ");
INSERT INTO bdv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଆର୍‌ ମୁୟ୍‌ ଜେ ସେ ଜଃଗାୟ୍‌ ନଃରିଲେ, ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ କଃରାସ୍‌, ଇତାର୍‌ ଗିନେ ତୁମାର୍‌ ଗିନେ ସଃର୍ଦା କଃରୁଲେ; ଜୁଆଁ, ଅଃମିମଃନ୍‌ ତାର୍‌ ଲଃଗେ ଜୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ସେତାକ୍‌ ତମା, ଜାକେ ଲକ୍‌ମଃନ୍ ଦିଦୁମ୍‌ ବଃଲେକ୍‌ ଜଃଉଁଣା ବଃଲି କଃଉତି । ସେ ନିଜାର୍‌ ସଃଙ୍ଗାର୍‌ ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁଆଁ ଅଃମିମଃନ୍‌ ହେଁ ଜାୟ୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ମଃରୁଆଁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ବେତନିଆୟ୍‌ ହଚି ସୁଣ୍‌ଲା ଜେ, ଲାଜାର୍‌କେ ମଃସୁଣ୍‌ କାଲେ ତହିକଃରି ଚାରି ଦିନ୍ ଅୟ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତାନିଆ ଜିରୁସାଲମ୍‌ ଲଃଗେ ରିଲି, ହାକାହାକି ଗଟ୍‌ କସ୍‌ ଦୁରି; ");
INSERT INTO bdv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଆରେକ୍‌ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରାର୍‌ କଃତେକ୍‌ ଲକ୍‌ ମାର୍ତା ଆର୍‌ ମରିୟମ୍‌କେ ସେମଃନାର୍‌ ବାୟ୍‌ର୍‌ ବିସୟେ ଦୁକ୍‌ହାସ୍ରାଉଁକ୍‌ ସେମଃନାର୍‌ ଲଃଗେ ଆସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ସେତାକ୍‌ ଜିସୁ ଆସି ଆଚେ ବଃଲି ଜଃଡେବଃଳ୍‌ ମାର୍ତା ସୁଣ୍‌ଲି, ସଃଡେବଃଳ୍‌ ସେ ଜିସୁକେ ବେଟୁକ୍‌ ଗଃଲି, ମଃତର୍‌ ମରିୟମ୍‌ ଗଃରେ ବଃସିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତା ଜିସୁକେ କୟ୍‌ଲି, “ମାପ୍ରୁ, ତୁୟ୍‌ ଇତି ରିଲେକ୍‌, ମର୍‌ ବାୟ୍‌ ନଃମେର୍ଲା ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମଃତର୍‌ ଅଃବେ ହେଁ ତୁୟ୍‌ ଇସ୍ୱର୍‌କେ ଜାୟ୍‌ରି ମାଗ୍‌ସି, ଇସ୍ୱର୍‌ ଜେ ସେରି ତକ୍‌ ଦଃୟ୍‌ଦ୍‌, ଇରି ମୁୟ୍‌ ଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ମାର୍ତାକ୍‌ କୟ୍‌ଲା, “ତୁମାର୍‌ ବାୟ୍‌ ଆରେକ୍‌ ଉଟେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ତା ଜିସୁକେ କୟ୍‌ଲି, “ସେ ଜେ ସେସ୍‌ ଦିନ୍ ମଃରି ଉଟ୍‌ତାବଃଳ୍‌ ସେ ଉଟେଦ୍‌, ଇରି ମୁୟ୍‌ ଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ମଃରି ଉଟ୍‌ତାର୍‌ ଆର୍‌ ଜିବନ୍, ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ ଜଦି ମଃରେଦ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ବାଚେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆରେକ୍‌ ଜେ ବଚେଦ୍‌ ଆର୍‌ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ କଃବେ ହେଁ ନଃମେରେ, ଇରି କାୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ସେ ଜିସୁକେ କୟ୍‌ଲି, “ଏ ମାପ୍ରୁ, ମୁୟ୍‌ ସେରି ବିସ୍ୱାସ୍‌ କଃରୁଲେ, ତୁୟ୍‌ ଜେ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ସେ କ୍ରିସ୍ଟ, ଜେ ଜଃଗତ୍‌କେ ଆସ୍ତାର୍‌ ରିଲି ଇରି ମର୍‌ ବିସ୍ୱାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଇରି କୟ୍‌ଲା ହଃଚେ, ମାର୍ତା ବାଉଳି ଜାୟ୍‌ ତାର୍‌ ବେଣ୍‌ସି ମରିୟମ୍‌କେ ଏକ୍ଲାକେ କୁଦି କୟ୍‌ଲି, “ଗୁରୁ ଆୟ୍‌ଲବେ, ଆର୍‌ ତକ୍‌ କୁଦୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ମରିୟମ୍‌ ଇ କଃତା ସୁଣିକଃରି ଦାପେ ଉଟି ଜିସୁର୍‌ ଲଃଗେ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଜିସୁ ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ଗାଉଁ ବିତ୍ରେ ଆସି ନଃରିଲା, ମଃତର୍‌ ମାର୍ତା ତାକେ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ବେଟ୍‌ ଅୟ୍‌ରିଲି, ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌, ଜିସୁ ସେ ଜଃଗାୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ତଃବେ ଜୁୟ୍‌ ଜିଉଦିମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଃରେ ରଃୟ୍‌ ତାକ୍‌ ଦୁକ୍‌ ହାସ୍ରାଉତି ରିଲାୟ୍‌, ସେମଃନ୍ ମରିୟମ୍‌କେ ଉଟିଜାତାର୍‌ ଦଃକିକଃରି ସେ ମଃସ୍‌ଣେ କାନ୍ଦୁକ୍‌ ଜଃଉଁଲି ବଃଲି ବାବି ତାର୍‌ ହଃଚେ ହଃଚେ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଜିସୁ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ରିଲା, ମରିୟମ୍‌ ସେଲଃଗେ ହଚ୍‌ଲା ଦାହ୍ରେ, ସେ ଜିସୁର୍‌ ଗଡ୍ ତଃଳେ ଡୁଳି କୟ୍‌ଲି, “ମାପ୍ରୁ, ତୁୟ୍‌ ଇତି ରିଲେକ୍‌ ମର୍‌ ବାୟ୍‌ ନଃମେର୍ଲା ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ମରିୟମ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଆସିରିଲା ଜିଉଦି ଲକମଃନ୍‌କେ କାନ୍ଦ୍‌ତି ରିଲାର୍‌ ଦଃକିକଃରି ଜିସୁ ଆତ୍ମାୟ୍‌ ବଃଡେ ଦୁକ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ଜିସୁ ହଃଚାର୍ଲା, “କୁୟ୍‌ତି ତାକ୍‌ ସଃଙ୍ଗାୟ୍‌ ଆଚାସ୍‌ ?” ସେମଃନ୍ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଆଉ ଦଃକ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ କାନ୍ଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ସେତାକ୍‌ ଜିଉଦିମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଦଃକା, ସେ ତାକ୍‌ କଃତେକ୍‌ ଲାଡ୍‌ କଃର୍ତିରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କେ କେ କୟ୍‌ଲାୟ୍‌, “ଇମାନାୟ୍‌ କାୟ୍‌ ସେ କାଣାର୍‌ ଆକି ଦଃକାୟ୍‌ ନଃରିଲା ? ସେ ମଃନ୍ କଃଲେକ୍‌ କାୟ୍‌ ଲାଜାର୍‌କେ ମଃର୍ନେ ହୁଣି ବଚାଉଁକ୍‌ ନାହାର୍ଲା ହୁଣି ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ସେତାକ୍‌ ଜିସୁ ଆରେକ୍‌ ଦୁକ୍‌ ଅୟ୍‌ ମଃସ୍‌ଣେ ଗଃଲା; ସେ ମଃସୁଣ୍ ଗଟେକ୍‌ ହାର୍‌ ରିଲି, ସେ ବିତ୍ରେ ଲାଜାର୍‌କେ ସଃଙ୍ଗାୟ୍‌ ବାଟ୍‌ ମୁୟେ ଗଟ୍‌ ବଃଡ୍ ଟେଳା ଡାହି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ମଃଲା ଲକାର୍‌ ବେଣ୍‌ସିକେ କୟ୍‌ଲା, “ଇ ଟେଳାକେ ଗୁଚାଉଆ ।” ମାର୍ତା କୟ୍‌ଲି, “ମାପ୍ରୁ, ସେ ଗଃନ୍ଦ୍‌ତି ରଃୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ସେ ମଃରିକଃରି ଚାରି ଦିନ୍ ଅୟ୍‌ଲିନି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜଦି ତୁୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ସି, ତଃବେ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍‌ କାମ୍‌ ଦଃକ୍‌ସି ବଃଲି ମୁୟ୍‌ କାୟ୍‌ ତକ୍‌ କୟ୍‌ ନଃରିଲେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ସେତାକ୍‌ ସେମଃନ୍ ଟେଳା ଗୁଚାୟ୍‌ଲାୟ୍‌ । ଆର୍‌ ଜିସୁ ସଃର୍ଗ୍‌ ହାକ୍‌ ଦଃକି କଃରି ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଉବା, ତୁୟ୍‌ ମର୍‌ ପାର୍ତ୍‌ନା ସୁଣୁଲିସ୍‌ ବଃଲି ମୁୟ୍‌ ତକ୍‌ ଜୁଆର୍‌ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ତୁୟ୍‌ ସଃବୁବଃଳ୍‌ ମର୍‌ ପାର୍ତ୍‌ନା ସୁଣୁଲିସ୍‌, ଇରି ମୁୟ୍‌ ଜାଣି; ମଃତର୍‌ ଇ ଜୁୟ୍‌ ଲକମଃନ୍ଦା ମର୍‌ ଚାରିବେଳ୍‌ତ୍ ଟିଆ ଅୟ୍‌ ଆଚ୍‌ତି, ତୁୟ୍‌ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚ୍‌ସି ବଃଲି ସେମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃର୍ତି, ଇତାର୍‌ ଗିନେ ସେମଃନାର୍‌ ଗିନେ ମୁୟ୍‌ ଇରି କଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଜିସୁ ଇରି କୟ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, “ଲାଜାର୍‌, ବାରାୟ୍‌ ଆଉ !” ");
INSERT INTO bdv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ସେଦାହ୍ରେ ମଃଲା ଲାଜାର୍‌ ବାରାୟ୍‌ ଆୟ୍‌ଲା, ତାର୍‌ ଆତେ ଆର୍‌ ଗଡେ ଦବ୍‌ ତୁଆଲ୍‌ ବାନ୍ଦା ଅୟ୍‌ରିଲି, ଆରେକ୍‌ ତାର୍‌ ମୁୟେ କଃଣ୍ଡେକ୍‌ କଃଦି ଡାହି ରିଲାୟ୍‌, ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତାର୍‌ ବାନ୍ଦୁଣ୍ ଇଟାୟ୍‌ ଇଣ୍ଡୁକ୍‌ ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ତଃବେ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌, ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମରିୟମ୍‌ ହାକ୍‌ ଆସି ରିଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ କାମ୍‌ ଦଃକିରିଲାୟ୍‌, ସେମଃନ୍ ତାର୍‌ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ଆରେକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରାର୍‌ କେ କେ ପାରୁସିମଃନାର୍‌ ହାକ୍‌ ଜାୟ୍‌, ଜିସୁ ଜୁୟ୍‌ ଜୁୟ୍‌ରି କଃରିରିଲା, ସେରି ସଃବୁ ସେମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଇରି ସୁଣି ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ବଃଡ୍ ବେରାଣ୍ କୁଦାୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ କାୟ୍‌ରି କଃରୁଆଁ ? ଇ ଲକ୍‌ ତ ଗାଦେକ୍‌ କାବା ଅଃଉତା ଚିନ୍ କଃରୁଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଜଦି ଅଃମିମଃନ୍‌ ତାକ୍‌ ଇରଃକମ୍‌ ଚାଡି ଦେଉଁଆ, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସଃବୁଲକ୍‌ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତି, ଆରେକ୍‌ ରମିୟମଃନ୍ ଆସି ଅଃମାର୍‌ ମନ୍ଦିର୍‌ ଆର୍‌ ଜାତିକ୍‌ ନଃସ୍ଟ୍‌ କଃରି ଦେତି ।” ");
INSERT INTO bdv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରାର୍‌ ଏକ୍ଲା ବଃଲେକ୍‌ କୟାପା ନାଉଁଆର୍‌ ସେ ବଃର୍ସାର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କଃଡେକ୍‌ ଉଲୁ, ");
INSERT INTO bdv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ସଃବୁ ଲକ୍‌ ନଃସ୍ଟ୍‌ ନୟ୍‌କଃରି, ସଃବୁ ଲକାର୍‌ ଗିନେ ଏକ୍ଲା ଜେ ମଃର୍ତାର୍‌ ତୁମାର୍‌ ଗିନେ ନିକ, ଇରି ହେଁ ତୁମିମଃନ୍ ବୁଜୁ ନଃହାରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପା ନିଜାର୍‌ ତଃୟ୍‌ହୁଣି ଇରି ନଃକୟ୍‌, ମଃତର୍‌ ସେ ବଃର୍ସାର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ଅୟ୍‌ରିଲାକ୍‌, ସେ ଜିସୁକେ ଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଗିନେ ମଃରୁକେ ଜଃଉଁଲା ବଃଲି ବାବ୍‌ବାଣି କଃଉତିରିଲା, ");
INSERT INTO bdv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଆର୍‌ ଅଃକାୟ୍‌ ସେ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ନାୟ୍‌, ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ଚିନ୍‌ବିନ୍ ଅୟ୍‌ରିଲା ହିଲାମଃନ୍‌କେ ହେଁ ରୁଣ୍ଡାୟ୍‌କଃରି ଗଟେକ୍‌ କଃରୁକେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ଜଃଉଁଲା, ଇତାର୍‌ ଗିନେ ଇ ବାବ୍‌ବାଣି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ସେତାକ୍‌ ସେ ଦିନ୍ ହୁଣି ଜିଉଦି ନେତାମଃନ୍ ଜିସୁକେ ମଃର୍ନେ ମାରୁକ୍‌ କୁଟ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ତଃବେ, ଜିସୁ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଆରେକ୍‌ ଦଃକ୍‌ଣେ ଚାଲା ବୁଲା ନଃକେଲା, ମଃତର୍‌ ଜିସୁ ସେ ଜଃଗାୟ୍‌ ହୁଣି ବାରାୟ୍‌ ଜାୟ୍‌ ଟଃଙ୍ଗ୍ରା ବଃଟା ଲଃଗେ ରିଲା ଜଃଗାର୍‌ ଏପ୍ରିଅମ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଗଃଳେ ଗଃଲା, ଆରେକ୍‌ ସେ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ସଃଡେବଃଳ୍‌ ଜିଉଦିମଃନାର୍‌ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଲଃଗେ ଆସ୍ତିରିଲି, ଆରେକ୍‌ ଗାଉଁଏମଃନ୍‌ ହୁଣି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାକ୍‌ ନିର୍ମୁଳ୍‌ କଃରୁକେ ମୁକ୍ତି ହଃର୍ବ୍‌ ଆଗ୍‌ତୁ ଜିରୁସାଲମେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ସେତାକ୍‌ ସେମଃନ୍ ଜିସୁକେ ଲଳୁ ଲଳୁ ମନ୍ଦିରେ ଟିଅୟ୍‌ ରିଲା ବଃଳ୍‌ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ତୁମିମଃନ୍ କାୟ୍‌ରି ମଃନେ କଃରୁଲାସ୍‌ ? ସେ କାୟ୍‌ ହଃର୍ବ୍‌କେ ନାସେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନ୍ ଜିସୁକେ ଦଃରୁକ୍‌, ଜିସୁ କୁୟ୍‌ତି ଆଚେ, ଇରି ଜଦି କେ ଜାଣିଆଚେ, ତଃବେ ସେରି ସେମଃନ୍‌କେ ଜାଣାଉଁକ୍‌ ଆଦେସ୍‌ କଃରି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଇ ବିତ୍ରେ ଜିସୁ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଅଃଉତା ଚଅ ଦିନ୍ ଆଗ୍‌ତୁ ବେତାନିଆ ଗଃଳେ ଗଃଲା; ସେତି ଲାଜାରାର୍‌ ଗଃର୍‌ ରିଲି, ଜୁୟ୍‌ ମଃରିରିଲା ଲାଜାର୍‌କେ ଜିସୁ ଉଟାୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ସେତି ସେମଃନ୍ ଜିସୁର୍‌ ଗିନେ ଗଟେକ୍‌ ରାତି ବଜି କଃଲାୟ୍‌; ସେ ବଜିଲଃଗେ ମାର୍ତା ସେବା କଃର୍ତିରିଲି, ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସ୍‌ଲାୟ୍‌ ଲାଜାର୍‌ ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ସଃଡେବଃଳ୍‌ ମରିୟମ୍‌ ଆଦ୍‌ ଲିଟର୍‌ ବୁତେକ୍‌ ମଲାର୍‌ ସୁଦ୍‌ ଜଟାମାଂସି ଚିକଣ୍‌ ଆଣି, ଜିସୁର୍‌ ହାଦେ ସେରି ଡାଳି ନିଜାର୍‌ ମୁଣ୍ଡାର୍‌ ବାଳେ ଜିସୁର୍‌ ହାଦ୍‌ ହୁଚ୍‌ଲି, ଆର୍‌ ଚିକଣାର୍‌ ବାସ୍ନାୟ୍‌ ଗଃର୍‌ ଗଃମ୍‌କି ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ମଃତର୍‌ ଜିସୁର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରାର୍‌ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ନାଉଁଆର୍‌ ଜୁୟ୍‌ ଚେଲା ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦେଉଁକ୍‌ ଜାତିରିଲା, ସେ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଇ ବାସ୍ନାଚିକଣ୍‌ ସାତ୍‌କଳି ଦଃସ୍‌ ଟଃକାୟ୍‌ ବିକାଜାୟ୍‌ ଗଃରିବ୍‌ମଃନ୍‌କେ କାୟ୍‌ତାକ୍‌ ଦିଆ ନଃଗେଲି ?” ");
INSERT INTO bdv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ସେ ଜେ ଗଃରିବ୍‌ମଃନାର୍‌ ଗିନେ ଚିତା କଃର୍ତିରିଲା ବଃଲି ଇରି କୟ୍‌ଲା, ସେରି ନାୟ୍‌, ମଃତର୍‌ ସେ ଗଟେକ୍‌ ଚର୍‌ ରିଲା, ଆରେକ୍‌ ତାର୍‌ ଲଃଗେ ଡାବୁ ହେଳି ରିଲାକ୍‌ ସେତି ଜାୟ୍‌ ଜାୟ୍‌ରି ସଃଙ୍ଗା ଜାତିରିଲି, ସେରି ସେ ଚରି କଃରି ନଃୟ୍‌ ଜାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ତାକ୍‌ ଚାଡି ଦିଆସ୍‌, ଜଃନ୍‌କଃରି ମକ୍‌ ତହ୍‌ତା ଦିନ୍ ଗିନେ ସେ ଇରି ସଃଙ୍ଗାଉଁକ୍‌ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଗଃରିବ୍‌ମଃନ୍ ତ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ଚଃମେ ଆଚ୍‌ତି, ମଃତର୍‌ ମୁୟ୍‌ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ଚଃମେ ନଃରେୟ୍‌ଁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଇ ବିତ୍ରେ ଗାଦେକ୍‌ ଜିଉଦି ଲକ୍‌ ଜିସୁ ବେତ୍‌ନିଆ ଲଃଗେ ଆଚେ ବଃଲି ଜାଣୁ ହାରି, ଅଃକାୟ୍‌ ଜିସୁର୍‌ ଗିନେ ନାୟ୍‌, ମଃତର୍‌ ଜୁୟ୍‌ ଲାଜାର୍‌କେ ସେ ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଉଟିରିଲା, ତାକ୍‌ ଦଃକୁକ୍‌ ହେଁ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ସେତାକ୍‌ ଲାଜାର୍‌କେ ହେଁ ମଃର୍ନେ ମାରୁକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ କୁଟ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ବଃଲେକ୍‌ ଲାଜାର୍‌ ଗିନେ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରାର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ନଃମାନ୍‌ତିରିଲାୟ୍‌, ଆର୍‌ ଜାୟ୍‌ ଜିସୁର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ମୁକ୍ତି ହଃର୍ବ୍‌କେ ଆସିରିଲା ଗାଦେକ୍‌ ଲକ୍‌ ଜିସୁ ଜିରୁସାଲମେ ଆସୁଲା ବଃଲି ସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ସେତାକ୍‌ ସେମଃନ୍ କଃଜ୍ରି ଡାଳ୍‌ ଦଃରି ଜିସୁକେ ଦଃକୁକ୍‌ ବାରାୟ୍‌ ଗଃଳାୟ୍‌, ଆର୍‌ ବଃଡ୍ ଟଣ୍ଡେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ହସାନ୍ନା । ମାପ୍ରୁର୍‌ ନାଉଁଏ ଜେ ଆସୁଲା, ତାର୍‌ ବାୟ୍‌ଗ୍‌; ଇସ୍ରାଏଲ୍‌କେ ଚାଲାଉତା ରଃଜାକ୍‌ ଇସ୍ୱର୍‌ ଆସିର୍ବାଦ୍‌ କଃର ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଆରେକ୍‌ ଜିସୁ ଗଟେକ୍‌ ଗଃଦ ଉହ୍ରେ ବଃସି ଆସ୍ତି ରିଲା । ଜଃନ୍‌କଃରି ଦଃର୍ମ୍‌ସାସ୍ତରେ ଲେକା ଆଚେ- ");
INSERT INTO bdv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ଏ ସିଅନାର୍‌ ଦଃଙ୍ଗ୍‌ଳିମଃନ୍, ଡିରା ନାୟ୍‌; ଦଃକା ତୁମାର୍‌ ରଃଜା ଆସୁଲା, ସେ ହିଲାଗଃଦ ଉହ୍ରେ ଚଃଗିକଃରି ଆସୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ତାର୍‌ ଚେଲାମଃନ୍ ହଃର୍ତୁମ୍‌ ଇ ସଃବୁ ବିସୟ୍‌ ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଜିସୁ ଜଃଜ୍‌ମାନ୍ ହାୟ୍‌ଲା ହଃଚେ ଇ ସଃବୁ ବିସୟ୍‌ ଜେ ତାର୍‌ ବିସୟେ ସାସ୍ତରେ ଲେକା ଅୟ୍‌ଆଚେ, ଆରେକ୍‌ ତାର୍‌ ଗିନେ ସେମଃନ୍ ଜେ ଇ ସଃବୁ କଃରିଆଚ୍‌ତି, ସେରି ସେମଃନାର୍‌ ମଃନେ ଏତୁ ହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଆରେକ୍‌ ଜିସୁ ଲାଜାର୍‌କେ ମଃସ୍‌ଣେ ହୁଣି କୁଦି ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଉଟାଉତା ବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ଦା ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌, ସେମଃନ୍ ଇସଃବୁ କଃତା ସାକି ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ସେତାର୍‌ଗିନେ ଲକ୍‌ମଃନ୍ଦା ଜିସୁକେ ମିସୁକ୍‌ ଜାୟ୍‌ ରିଲାୟ୍‌, ବଃଲେକ୍‌ ସେ ଇ କାବା ଅଃଉତା ଚିନ୍ କଃରି ଆଚେ ବଃଲି ସେମଃନ୍ ସୁଣି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ସେତାକ୍‌ ପାରୁସିମଃନ୍ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଦଃକ୍‌ଲାସ୍‌ ତ, ଅଃମିମଃନାର୍‌ ସଃବୁ କାମ୍‌ ଉଲ୍‌ଟା ଅଃଉଁଲି, ଦଃକା ଜଃଗତ୍‌ଜାକ ତାର୍‌ ହଃଚେ ଜଃଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ହଃର୍ବ୍‌ ବଃଳ୍‌ ସେବା କଃରୁକ୍‌ ଜିରୁସାଲମେ ଆସ୍ତି ରିଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଗ୍ରିକ୍‌ ଲକ୍‌ମଃନ୍ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ସେମଃନ୍ ଗାଲିଲିର୍‌ ବେତ୍‌ସାଇଦା ଗାଉଁଆର୍‌ ଲକ୍‌ ରିଲାୟ୍‌, ସେମଃନ୍ ପିଲିପ୍ ଲଃଗେ ଆସି ତାକ୍‌ ଗଃଉଆରି କଃରି କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ, ଜିସୁକେ ଦଃକୁକ୍‌ ଅଃମାର୍‌ ଇଚା ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ୍ ଜାୟ୍‌କଃରି ଆନ୍ଦ୍ରିଅକେ କୟ୍‌ଲା, ଆରେକ୍‌ ଆନ୍ଦ୍ରିଅ ଆର୍‌ ପିଲିପ୍ ଜାୟ୍‌ ଜିସୁକେ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ନଃରାର୍‌ ହୟ୍‌ସି ଜଃଜ୍‌ମାନ୍ ହାଉଁକ୍‌ ବେଳା ହଚ୍‌ଲିନି । ");
INSERT INTO bdv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ମୁୟ୍‌ ତୁମିକେ ସଃତ୍‌କଃରି କଃଉଁଲେ, ଗଅଁ ମୁଞ୍ଜି ଜଦି ମାଟାୟ୍‌ ଅଦ୍ରି ନଃମେରେ, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସେରି ଗଟେକ୍‌ ହଃକା ରଃୟ୍‌ଦ୍‌, ମଃତର୍‌ ଜଦି ମଃରେଦ୍‌ ତଃବେ ବୁତେକ୍‌ ହଃଳ୍‌ ହଃଳେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଜେ ନିଜାର୍‌ ଜିବନ୍‌କେ ଲାଡ୍‌ କଃରେଦ୍‌, ସେ ତାର୍‌ ଜିବନ୍ ଆରାୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଜେ ନିଜାର୍‌ ଜିବନ୍‌କେ ଇ ଜଃଗତେ ଗିଣ୍ କଃରେଦ୍‌ ସେ ସେରି ଅଃମ୍ବର୍‌ ଜିବନ୍ ଗିନେ ବାଚାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","କେ ଜଃବେ ସେବାକାରି ସେବା କଃରୁକେ ମଃନ୍ କଃରେଦ୍‌, ତଃବେ ସେ ମର୍‌ ହଃଚେ ଆସ; ଆରେକ୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ତି ରଃୟ୍‌ନ୍ଦ୍ ମର୍‌ ସେବା କଃରୁ ହେଁ ସେତି ରଃୟ୍‌ଦ୍‌, କେ ଜଃବେ ମର୍‌ ସେବା କଃରେଦ୍‌, ତଃବେ ଉବା ତାକ୍‌ ମାନ୍‌ତି ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ଅଃବେ ମୁୟ୍‌ ବଃଡେ ଦଃନ୍ଦାୟ୍‌ ଆଚି, ମୁୟ୍‌ କାୟ୍‌ ବଃଲିନ୍ଦ୍‌ ? ଉବା ଇ ବିପ୍‌ତି ତଃୟ୍‌ହୁଣି ବଚାଉ ବଃଲିନ୍ଦ୍‌ କି ? ସେତାର୍‌ ଗିନେ ତ ଆସି ଆଚି । ଦୁକ୍‌ ବଗ୍‌ତା ବେଳାମଃନ୍‌ ସଃମ୍ବାଳୁକ୍‌ ତ ମୁୟ୍‌ ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ଉବା ଅଃହ୍‌ଣାର୍‌ ନାଉଁକ୍‌ ଜଃଜ୍‌ମାନ୍‌ କଃର୍‌ । ସଃଡେବଃଳ୍‌ ସଃର୍ଗେହୁଣି ଇ କଃତା ସୁଣା ଗଃଲି, “ମୁୟ୍‌ଁ ତାକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରିଆଚି ଆର୍‌ ଆରେକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ସେତାକ୍‌ ସେଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ ଇରି ସୁଣି ମେଗ୍ ଗଃର୍ଜାଣ୍ ଅୟ୍‌ଲି ବଃଲି କୟ୍‌ଲାୟ୍‌; ବିନ୍ ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଗଟ୍‌ ଦୁତ୍‌ ତାକ୍‌ ଟଣ୍ଡ୍ ଅୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ମଃତର୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମର୍‌ ଗିନେ ଇ କଃତା ସୁଣା ନୟ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ଗିନେ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ଅଃବେ ଇ ଜଃଗତାର୍‌ ବିଚାର୍‌ କେଟି ଆଚେ; ଅଃବେ ଇ ଜଃଗତାର୍‌ ମୁଳିକାକେ ହଃଦାୟ୍‌ ହଃକାଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆର୍‌ ମକ୍‌ ଜଃଡେବଃଳ୍‌ ହୁର୍ତିବି ହୁଣି ଉହ୍ରେ ଉଟା ଅୟ୍‌ଦ୍‌, ସଃଡେବଃଳ୍‌ ସଃବ୍‌କେ ନିଜାର୍‌ ହାକ୍‌ ନଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ଜିସୁ କୁୟ୍‌ରଃକମ୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ବଗ୍ କଃରୁକେ ଜାତିରିଲା, ସେରି ଜାଣାଉଁକ୍‌ ଇରି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ଦା ତାକ୍‌ ଉତୁର୍‌ ଦିଲାୟ୍‌, କ୍ରିସ୍ଟ ସଃବୁ ଅଃମ୍ବର୍‌ ରଃୟ୍‌ଦ୍‌ ବଃଲି ଅଃମିମଃନ୍‌ ବିଦି ସାସ୍ତରେ ହୁଣି ଜାଣି ଆଚୁ, ତଃବେ ନଃରାର୍‌ ହୟ୍‌ସି ବାୟ୍‌ଦ୍‌ରେ ଉହ୍ରେ ଉଟା ଅୟ୍‌ଦ୍‌ ବଃଲି ତୁୟ୍‌ କଃନ୍‌କଃରି କଃଉଁଲିସ୍‌ ? ଇ ନଃରାର୍‌ ହୟ୍‌ସି କେ ? ");
INSERT INTO bdv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ଆରେକ୍‌ ଅଃଳକ୍‌ ବେଳା ମଃତର୍‌ ଉଜାଳ୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଆଚେ, ଅଃନ୍ଦାର୍‌ ଜଃନ୍‌କଃରି ତୁମିମଃନ୍‌କେ ଡାହି ନଃକେରେ, ଇତାର୍‌ ଗିନେ ତୁମାର୍‌ ଲଃଗେ ଉଜାଳ୍‌ ରେଉଁ ରେଉଁ ଜଃଗ୍ରାତ୍‌ ଅଃଉଆ; ଜେ ଅଃନ୍ଦାରେ ଚାଲାଚାଲ୍‌ତି କଃରେଦ୍‌, ସେ କେଣେ ଜଃଉଁଲା ସେରି ନଃଜାଣେ । ");
INSERT INTO bdv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଉଜାଳାର୍‌ ହିଲା ଅଃଉଆସ୍‌, ସେତାର୍‌ ଗିନେ ଉଜାଳ୍‌ ତୁମାର୍‌ ଲଃଗେ ରେଉଁ ରେଉଁ ଉଲାଳ୍‌କେ ବିସ୍ୱାସ୍‌ କଃରା । ଜିସୁ ଇସଃବୁ କଃତା କୟ୍‌ଲା ହଃଚେ, ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଗଃଲା ଆର୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଲୁକିକଃରି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଜିସୁ ସେମଃନାର୍‌ ମୁୟେ ଅଃତେକ୍‌ କାବା ଅଃଉତା ଚିନ୍ କଃରିରିଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନ୍ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଜଃନ୍‌କଃରି ବାବ୍‌ବାଦି ଜିସାୟ୍‌ ଲେକ୍‌ଲା ଇ ବଃଚନ୍ ହୁରା ଅୟ୍‌ଦ୍‌, ଏ ମାପ୍ରୁ, କେ ଅଃମାର୍‌ କବୁର୍‌କେ ବିସ୍ୱାସ୍‌ କଃରି ଆଚେ ? ଆର୍‌ ମାପ୍ରୁର୍‌ ସଃକ୍ତି କାର୍‌ ତଃୟ୍‌ ଜାଣା ଅୟ୍‌ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ବିସ୍ୱାସ୍‌ କଃରୁ ନାହାର୍ତି ରିଲାୟ୍‌, ବଃଲେକ୍‌ ଜିସାୟ୍‌ ଆରେକ୍‌ କୟ୍‌ଆଚେ- ");
INSERT INTO bdv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ସେ ସେମଃନାର୍‌ ଆକି ଅଃନ୍ଦ୍ କଃଲା ଆଚେ ଆର୍‌ ସେମଃନାର୍‌ ମଃନ୍‌ ଅଃଟୁଆ କଃରିଆଚେ, ଜଃନ୍‌କଃରି ସେମଃନ୍ ଦଃକୁ ନଃହାର୍‌ତି ଆର୍‌ ସେମଃନାର୍‌ ମଃନେ ନଃବୁଜ୍‌ତି, ଆରେକ୍‌ ବାଉଳିନାସ୍ତି, ଆରେକ୍‌ ଅଃମି ସେମଃନ୍‌କେ ଉଜ୍‌ ନଃକେରୁ । ");
INSERT INTO bdv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିସାୟ୍‌ ଇ ସଃବୁ କୟ୍‌ଲା, ବଃଲେକ୍‌ ସେ ଜିସୁର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଦଃକ୍‌ଲା ଆର୍‌ ତାର୍‌ ବିସୟେ କଃତା କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଅୟ୍‌ଲେକ୍‌ ହେଁ ଜିଉଦି ମୁଳିକାମଃନାର୍‌ ବିତ୍ରାର୍‌ ହେଁ ବୁତେକ୍‌ ଲକ୍‌ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌, ମଃତର୍‌ ଚଃନେମଃନେ ସେମଃନ୍ ଦଃଳେ ହୁଣି ବାର୍‌ତି, ଇତାର୍‌ ଗିନେ ପାରୁସିମଃନାର୍‌ ଗିନେ ସେରି କଃଉଁକେ ନଃଚ୍‌ତିରିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ବଃଲେକ୍‌ ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ହାଉତା ବାଟା, ନଃର୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ବଃଲ୍‌ ହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, ଜେ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ ମର୍‌ ତଃୟ୍‌ ହଃକା ବିସ୍ୱାସ୍‌ ନଃକେରେ, ମଃତର୍‌ ମକ୍‌ ଜେ ହଃଟାୟ୍‌ ଆଚେ ତାର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଆରେକ୍‌ ଜେ ମକ୍‌ ଦଃକି ଆଚେ ସେ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଲକ୍‌କେ ହେଁ ଦଃକି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଜୁୟ୍‌ ଲକ୍‌ ମର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ସେ ଜଃନ୍‌କଃରି ଅଃନ୍ଦାରେ ବାସା ନଃକେରେ, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ଜଃଗତ୍‌କେ ଉଜାଳ୍‌ ଅୟ୍‌ ଆସି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","କେ ଜଦି ମର୍‌ କଃତା ସୁଣି ନଃମାନେ, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ ତାର୍‌ ବିଚାର୍‌ ନଃକେରି; ବଃଲେକ୍‌ ମୁୟ୍‌ ଜଃଗତାର୍‌ ବିଚାର୍‌ କଃରୁକେ ନାସି, ମଃତର୍‌ ଜଃଗତ୍‌କେ ମୁକ୍ତି ଦେଉଁକେ ଆସିଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଜେ ମକ୍‌ ନଃଦେରେ ଆର୍‌ ମର୍‌ କଃତା ନଃସୁଣେ, ତାର୍‌ ବିଚାର୍‌ କଃର୍ତା ଲକ୍‌ ଆଚେ; ମୁୟ୍‌ ଜୁୟ୍‌ କଃତା କୟ୍‌ ଆଚି, ସେରି ସେସ୍‌ ଦିନ୍ ତାର୍‌ ବିଚାର୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ କଃତା ସଃତ୍‌, ବଃଲେକ୍‌ ମୁୟ୍‌ ନିଜାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ନଃକୟ୍‌ଁ, ମଃତର୍‌ ମୁୟ୍‌ କାୟ୍‌ରି କୟ୍‌ନ୍ଦ୍ ଆର୍‌ କାୟ୍‌ରି ଜାଣାୟ୍‌ନ୍ଦ୍ ସେରି ମକ୍‌ ହଃଟାୟ୍‌ଲା ଉବା ମକ୍‌ ଆଦେସ୍‌ ଦଃୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଆର୍‌ ତାର୍‌ ବଲ୍‌ ଜେ ଅଃମ୍ବର୍‌ ଜିବନ୍, ଇରି ମୁୟ୍‌ ଜାଣି, ତଃବେ ମୁୟ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ କଃତା କୟ୍‌ନ୍ଦ୍, ଉବା ମକ୍‌ ଜଃନ୍‌କଃରି ଆଦେସ୍‌ ଦଃୟ୍‌ଆଚେ ସେନ୍‌କଃରି କୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଅଃଉତା ଆଗ୍‌ତୁ ଜିସୁ ଇ ଜଃଗତେ ହୁଣି ଉବାସିର୍‌ ହାକ୍‌ ତାର୍‌ ଜାତା ବେଳା ହଚିଆଚେ ବଃଲି ଜାଣି ଜଃଗତେ ରିଲା ନିଜାର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସେ ଲାଡ୍‌ କଃରି ଆସ୍ତି ରିଲା, ସେମଃନ୍‌କେ ତାର୍‌ ଜିବନାର୍‌ ସଃରାସଃରି ଲାଡ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ଆରେକ୍‌ ରାତି ବଜି ବଃଳ୍‌ ଜଃଡେବଃଳ୍‌ ସିମନାର୍‌ ହୟ୍‌ସି ଇସ୍କାରିଅତ୍‌ ଜିଉଦାର୍‌ ମଃନ୍‌ ବିତ୍ରେ ଜିସୁକେ ସଃତ୍ରୁ ଆତେ ଦଃରାୟ୍‌ ଦେଉଁକ୍‌ ସୟ୍‌ତାନ୍ ଉସ୍‌କାୟ୍‌ ରିଲି, ");
INSERT INTO bdv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ସଃଡେବଃଳ୍‌ ଉବା ଜେ ତାର୍‌ ଆତେ ସଃବୁ ଅଃଦିକାର୍‌ ସଃହ୍ରି ଦଃୟ୍‌ ଆଚେ ଆର୍‌ ସେ ଜେ ଇସ୍ୱରାର୍‌ ଲଃଗେହୁଣି ଆସି ଆଚେ, ଆରେକ୍‌ ଇସ୍ୱରାର୍‌ ହାକ୍‌ ବାଉଳି ଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ତଃବେ ଜିସୁ କାତା ବାଟାୟ୍‌ ହୁଣି ଉଟି ନିଜାର୍‌ ଉହ୍ରେ ହିନ୍ଦିରିଲା ବଃସ୍ତର୍‌ କାଡି ଦଃୟ୍‌ ଗଟେକ୍‌ ତୁଆଲ୍‌ ସଃଙ୍ଗ୍ ନିଜାର୍‌ ଅଃଟାୟ୍‌ ବାନ୍ଦ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ତାର୍‌ହଃଚେ ଜିସୁ ତାବ୍‌ଲାୟ୍‌ ହାଣି ଡାଳ୍‌ଲା, ଆରେକ୍‌ ଚେଲାମଃନାର୍‌ ହାଦ୍‌ ଦଃୟ୍‌ ଦଃୟ୍‌ ନିଜାର୍‌ ଅଃଟାୟ୍‌ ବାନ୍ଦି ରିଲା ତୁଆଲ୍‌ ସଃଙ୍ଗ୍ ହୁଚୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଜଃଡେବଃଳ୍‌ ଜିସୁ ସିମନ୍ ପିତର୍‌ ହାକ୍‌ ଆୟ୍‌ଲା; ପିତର୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ମାପ୍ରୁ ତୁୟ୍‌ କାୟ୍‌ କଃରୁକ୍‌ ମର୍‌ ଗଡ୍ ଦଃୟ୍‌ ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ ଜାୟ୍‌ରି କଃରୁଲେ ସେରି ତୁମି ଅଃବେ ନଃଜାଣୁଲାସ୍‌, ମଃତର୍‌ ହଃଚେ ବୁଜାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍‌ ମଃନାକଃରି ଜିସୁକେ କୟ୍‌ଲା, “ତୁୟ୍‌ କଃବେ ହେଁ ମର୍‌ ଗଡ୍ ଦଃୟ୍‌ ଦେନାୟ୍‌ ।” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜଦି ମୁୟ୍‌ ତର୍‌ ହାଦ୍‌ ଦଃୟ୍‌ ନଃଦେୟ୍‌ଁ, ତଃବେ ତୁୟ୍‌ ମର୍‌ ଚେଲା ଅଃଉଁ ନାହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମନ୍ ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ମାପ୍ରୁ, ତଃନ୍‌ଅଲେ ମର୍‌ ହାଦ୍‌ ନାୟ୍‌, ମଃତର୍‌ ମର୍‌ ଆତ୍‌ ଆର୍‌ ମୁଣ୍ଡ୍ ହେଁ ଦଃୟ୍‌ ଦେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜେ ଗଃଦାୟ୍‌ ଆଚେ ତାର୍‌ ଗଡ୍ ଦଃଉତା ଦଃର୍‌କାର୍‌ ଆର୍‌ କାୟ୍‌ରି କଃରୁକେ ଲଳା ନାୟ୍‌, ସେ ଲକ୍‌ ସଃତ୍‌କଃରି ନିର୍ମୁଳ୍‌, ତୁମିମଃନ୍ ସଃବୁ ଲକ୍‌ ନିର୍ମୁଳ୍‌ ଆଚାସ୍‌, ମଃତର୍‌ ଏକ୍ଲା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜେ ତାକ୍‌ ସଃତ୍ରୁ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌ ସେ ତାକ୍‌ ଜାଣିରିଲା; ସେତାର୍‌ଗିନେ ସେ କୟ୍‌ଲା, “ଏକ୍ଲାକେ ଚାଡି ତୁମିମଃନ୍ ସଃବୁଲକ୍‌ ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ଆଚାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ତାର୍‌ହଃଚେ ଜିସୁ ଚେଲାମଃନାର୍‌ ହାଦ୍‌ ଦୟ୍‌ଦଃୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦି ଅଃହ୍‌ଣାର୍‌ ଜଃଗାୟ୍‌ ବଃସ୍‌ଲା ହଃଚେ ସେ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ମୁୟ୍‌ ତୁମାର୍‌ ଗିନେ କାୟ୍‌ରି କଃରି ଆଚି, ସେରି କାୟ୍‌ ତୁମିମଃନ୍ ବୁଜୁ ହାର୍ଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ତୁମିମଃନ୍ ମକ୍‌ ଗୁରୁ ଆର୍‌ ମାପ୍ରୁ ବଃଲି କଃଉଁଲାସ୍‌, ଇରି ଟିକ୍‌ କଃତା, ବଃଲେକ୍‌ ମୁୟ୍‌ ତ ସେ । ");
INSERT INTO bdv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ତଃବେ ତୁମାର୍‌ ଗୁରୁ ଆର୍‌ ମାପ୍ରୁ ଅୟ୍‌ ମୁୟ୍‌ ଜଦି ତୁମାର୍‌ ହାଦ୍‌ ଦୟ୍‌ଦିଲେ ଆଚି, ତଃବେ ତୁମିମଃନ୍ ହେଁ ସେବାନ୍ୟା ତୁମାର୍‌ ବିତ୍ରେ ହେଁ ବାୟ୍‌ଦ୍‌ରେ ଦଃଉଆଦଇ ଅଃଉଆ । ");
INSERT INTO bdv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ତୁମିମଃନ୍‌କେ ମୁୟ୍‌ ଜଃନ୍‌କାର୍‌ କଃରିଆଚି, ତୁମିମଃନ୍ ହେଁ ଜେ ସେରଃକମ୍‌ କଃରା ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଗଟେକ୍‌ ନିକ କାମ୍‌ କଃରି ଦଃକାୟ୍‌ ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଅଃହ୍‌ଣାର୍‌ ସାଉକାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ନାୟ୍‌, କି ଗଟେକ୍‌ କବୁର୍‌କାରିଆ ଅଃହ୍‌ଣାର୍‌ କବୁର୍‌ହଃଟାଉ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଜଦି ତୁମିମଃନ୍ ଇ ସଃବୁ ଜାଣାସ୍‌, ତଃବେ ସେବାନ୍ୟା କଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ମୁୟ୍‌ ତୁମିମଃନାର୍‌ କଃତା ନଃକୟ୍‌ଁ, ମୁୟ୍‌ କଃନ୍‌କା ଲକ୍‌ମଃନ୍‌କେ ବାଚ୍‌ଲାର୍‌, ସେରି ମୁୟ୍‌ ଜାଣି; ମଃତର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଇ ବଃଚନ୍ ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ସେତାର୍‌ଗିନେ ଇବାନ୍ୟା ଗଃଟୁଲି, ଜେ ମର୍‌ ଅଃର୍ନ୍‌ କାୟ୍‌ଲା, ସେ ମର୍‌ ବିରଦେ ଲାତ୍‌ ଟେକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ସେରି ଗଃଟ୍‌ତା ବଃଳ୍‌ ମୁୟ୍‌ ସେ ବଃଲି ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରାସ୍‌, ଇତାର୍‌ ଗିନେ ସେରି ଗଃଟ୍‌ତା ହୁର୍ବେ ମୁୟ୍‌ ଅଃବେ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ମୁୟ୍‌ ତୁମିକେ ସଃତ୍‌ କଃଉଁଲେ, ଜେ ମୁୟ୍‌ ହଃଟାୟ୍‌ ରିଲା ଗଟେକ୍‌ ଲକେ ଗଃରେ କୁଦି ଦଃରେଦ୍‌, ସେ ମକ୍‌ ସେବାନ୍ୟା ଦଃରେଦ୍‌, ଆର୍‌ ଜେ ମକ୍‌ ଦଃରେଦ୍‌, ମକ୍‌ ଜେ ହଃଟାୟ୍‌ ଆଚେ ସେ ଇସ୍ୱର୍‌କେ ହେଁ ସେ ଦଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁ ଇସଃବୁ ସାକି ଦିଲା ହଃଚେ ଆତ୍ମାୟ୍‌ ଦୁକ୍‌ କଃଲା, ଆର୍‌ ହୁଟାୟ୍‌କଃରି କୟ୍‌ଲା, “ମୁୟ୍‌ ସଃତ୍‌ କଃଉଁଲେ, ତୁମାର୍‌ ବିତ୍ରାର୍‌ ଏକ୍ଲା ମକ୍‌ ସଃତ୍ରୁର୍‌ ଆତେ ଦଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଜିସୁ କାକେ ଦଃକାୟ୍‌ ଇ କଃତା କୟ୍‌ଲା, ବୁଜୁ ନଃହାରି ଚେଲାମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ମୁୟେ ଦଃକା ଦଃକି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଜିସୁର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରାର୍‌ ଏକ୍ଲା ଜାକେ ଜିସୁ ଲାଡ୍‌ କଃର୍ତିରିଲା, ସେ ଜିସୁର୍‌ କାତାବାଟ୍ୟା ବଃସି କାତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ସିମନ୍ ପିତର୍‌ ତାକ୍‌ ଆତ୍‌ସଃଗ୍ୟା କଃରି କୟ୍‌ଲା, “ସେ କାର୍‌ କଃତା କଃଉଁଲା, ତାକ୍‌ ହଃଚାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ସେ ଚେଲା ଆରେକ୍‌ ଅଃଳକ୍‌ ଜିସୁର୍‌ ବୁକେ ଡେରାୟ୍‌ ଅୟ୍‌ ତାକ୍‌ ହଃଚାର୍ଲା, “ମାପ୍ରୁ ସେ କେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ସେତାକ୍‌ ଜିସୁ କୟ୍‌ଲା, “ଇ ରୁଟି କପାୟ୍‌ ବୁଡାୟ୍‌ ଜାକେ ମୁୟ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ସେ ସେମାନାୟ୍‌ ।” ଇରି କୟ୍‌କଃରି ଜିସୁ କଃଣ୍ଡେକ୍‌ ରୁଟିକ୍‌ କପାୟ୍‌ ବୁଡାୟ୍‌କଃରି ସିମନାର୍‌ ହୟ୍‌ସି ଇସ୍କାରିଅତ୍‌ ଜିଉଦାକେ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଜିଉଦା ରୁଟିକ୍‌ କାୟ୍‌ଲା ଦାହ୍ରେ ସୟ୍‌ତାନ୍‌ ତାର୍‌ ଗଃର୍ବେ ହୁର୍ଲି । ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜୁୟ୍‌ରି କଃରୁକେ ଜଃଉଁଲିସ୍‌ ସେରି ବେଗି କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ମଃତର୍‌ ଜିସୁ କାୟ୍‌ତାକ୍‌ ତାକ୍‌ ଇ କଃତା କୟ୍‌ଲା, କାଉଁକେ ବଃସିରିଲା ଲକ୍‌ମଃନ୍ କେହେଁ ବୁଜୁକ୍‌ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ବଃଲେକ୍‌ ଜିଉଦାର୍‌ ଲଃଗେ ଡାବୁ ହେଳି ରିଲାକ୍‌ ହଃର୍ବାର୍‌ ଗିନେ ଜାୟ୍‌ ଜାୟ୍‌ରି ଲଳା, ସେରି ଗେନୁକ୍‌ ନୟ୍‌ଲେକ୍‌ ଗଃରିବ୍‌ମଃନ୍‌କେ ଅଃଳକ୍‌ ଦାନ୍‌ ଦେଉଁକ୍‌ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା ବଃଲି କେ କେ ମଃନେ ବାବ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ତାର୍‌ହଃଚେ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ରୁଟି କାୟ୍‌ଲା, ଆର୍‌ ସେଦାହ୍ରେ ବାରାୟ୍‌ ଗଃଲା, ସଃଡେବଃଳ୍‌ ରାତି ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଜିଉଦା ବାରାୟ୍‌ ଗଃଲା ହଃଚେ ଜିସୁ କୟ୍‌ଲା, “ଅଃବେ ନଃରାର୍‌ ହୟ୍‌ସି ଜଃଜ୍‌ମାନ୍ ଅୟ୍‌ଲା ଆର୍‌ ତାର୍‌ତଃୟ୍‌ ଇସ୍ୱର୍‌ ହେଁ ଜଃଜ୍‌ମାନ୍ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଜଦି ଇସ୍ୱର୍‌ ତାର୍‌ତଃୟ୍‌ ଜଃଜ୍‌ମାନ୍ ଅୟ୍‌ଲା, ତଃବେ ଇସ୍ୱର୍‌ ହେଁ ତାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରେଦ୍‌, ଆରେକ୍‌ ଦାପେ ତାକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ହିଲାମଃନ୍ ମୁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ ବୁତେକ୍‌ ବେଳା ନଃରେୟ୍‌ଁ । ତୁମିମଃନ୍ ମକ୍‌ ଲଳାସ୍‌; ଆରେକ୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ ଟାଣେ ଜଃଉଁଲେ, ତୁମିମଃନ୍ ସେ ଜଃଗାୟ୍‌ ଜଃଉଁ ନଃହାରାସ୍‌, ଇରି ମୁୟ୍‌ ଜଃନ୍‌କଃରି ଜିଉଦି ଅଃଦିକାରିମଃନ୍‌କେ କୟ୍‌ରିଲେ, ସେରଃକମ୍‌ ଅଃବେ ତୁମିମଃନ୍‌କେ ହେଁ କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ତୁମିମଃନ୍ ତୁମାର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଲାଡ୍‌ କଃରା, ଇ ନଃଉଆଁ ବିଦି ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଦେଉଁଲେ, ମୁୟ୍‌ ଜଃନ୍‌କଃରି ତୁମିମଃନ୍‌କେ ଲାଡ୍‌ କଃରିଆଚି, ତୁମିମଃନ୍ ହେଁ ସେନ୍‌କଃରି ତୁମାର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଲାଡ୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଜଦି ତୁମାର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଲାଡ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ତୁମିମଃନ୍ ଜେ ମର୍‌ ଚେଲା ଇରି ସଃବୁ ଲକ୍‌ମଃନ୍ ଜାଣ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମନ୍ ପିତର୍‌ ଜିସୁକେ ହଃଚାର୍ଲା, “ମାପ୍ରୁ, ତୁୟ୍‌ କୁୟ୍‌ତି ଜଃଉଁଲିସ୍‌ ?” ଜିସୁ କୟ୍‌ଲା, “ମୁୟ୍‌ କୁୟ୍‌ ଟାଣେ ଜଃଉଁଲେ, ତୁମିମଃନ୍ ଅଃବେ ମର୍‌ ହଃଚେ ହଃଚେ ସେତି ଜଃଉଁ ନଃହାରାସ୍‌, ମଃତର୍‌ ହଃଚେ ଜାହାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର୍‌ ଜିସୁକେ କୟ୍‌ଲା, “ମାପ୍ରୁ ମୁୟ୍‌ ଅଃବେ କାୟ୍‌କଃରୁକ୍‌ ତର୍‌ ହଃଚେ ହଃଚେ ଜଃଉଁ ନଃହାରି ? ମୁୟ୍‌ ତର୍‌ ଗିନେ ନିଜାର୍‌ ଜିବନ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ ମର୍‌ ଗିନେ ନିଜାର୍‌ ଜିବନ୍‌ ଦେସି ? ମୁୟ୍‌ ତକ୍‌ ସଃତ୍‌ କଃଉଁଲେ ଆଜି ରାତି କୁକ୍‌ଳା ନଃବାସ୍ତେ ତୁୟ୍‌ ମକ୍‌ ତିନିତର୍‌ ନଃଜାଣି ବଃଲି କଃଉସି ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଜିସୁ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ମଃନ୍‌ ନଃଡିର, ତୁମିମଃନ୍ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରା, ଆର୍‌ ମର୍‌ ତଃୟ୍‌ହେଁ ବିସ୍ୱାସ୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ମର୍‌ ଉବାର୍‌ ଗଃରେ ଗାଦେକ୍‌ ବାସା କଃର୍ତା ଟାଣ୍ ଆଚେ; ସେରି ସଃତ୍‌ ଅୟ୍‌ନଃରିଲେକ୍‌, ମୁୟ୍‌ ତୁମିକେ ଇ କଃତା ନଃକୟ୍‌ଲେ ହୁଣି, ମୁୟ୍‌ ତୁମାର୍‌ ଗିନେ ଟାଣ୍ ଟିକ୍‌ କଃରୁକେ ଜଃଉଁଲେ; ");
INSERT INTO bdv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଆର୍‌, ମୁୟ୍‌ ଜାୟ୍‌କଃରି ତୁମାର୍‌ ଗିନେ ଟାଣ୍ ଟିକ୍‌ କଃଲେକ୍‌ ଆରେକ୍‌ ଆସିନ୍ଦ୍‌, ଆର୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ ଟାଣେ ରଃୟ୍‌ନ୍ଦ୍ ତୁମିମଃନ୍ ହେଁ ଜଃନ୍‌କଃରି ସେ ଟାଣେ ରିଆସ୍‌, ସେତାର୍‌ଗିନେ ତୁମିକେ ନିଜାର୍‌ ତଃୟ୍‌ ନଃୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ଆରେକ୍‌ ମୁୟ୍‌ ଜୁୟ୍‌ ଟାଣେ ଜଃଉଁଲେ, ସେତିର୍‌ ବାଟ୍‌ ତୁମିମଃନ୍ ଜାଣାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତମା ଜିସୁକେ ହଃଚାର୍ଲା, “ମାପ୍ରୁ, ତୁୟ୍‌ କୁୟ୍‌ ଟାଣେ ଜଃଉଁଲିସ୍‌, ସେରି ଅଃମିମଃନ୍‌ ନଃଜାଣୁ; ସେତି ଜାତାର୍‌ ବାଟ୍‌ କଃନ୍‌କଃରି ଜାଣୁନ୍ଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ବାଟ୍‌, ସଃତ୍‌ ଆର୍‌ ଜିବନ୍, ମର୍‌ ଦଃୟ୍‌ ନଃଗେଲେକ୍‌ କେ ହେଁ ଉବାର୍‌ ହାକ୍‌ ଜଃଉଁ ନାହାରେ । ");
INSERT INTO bdv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ମକ୍‌ ଜାଣ୍‌ଲେକ୍‌, ମର୍‌ ଉବାକ୍‌ ହେଁ ଜାଣାସ୍‌; ଅଃବେହୁଣି ତୁମିମଃନ୍ ତାକ୍‌ ଜାଣିଆଚାସ୍‌ ଆର୍‌ ତାକ୍‌ ଦଃକିଆଚାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍ ଜିସୁକେ କୟ୍‌ଲା, “ମାପ୍ରୁ ଅଃମିମଃନ୍‌କ୍‌ ଉବାକ୍‌ ଦଃକାଉ, ସଃତେକ୍‌ ଅଃମାର୍‌ ଗିନେ ସଃରି ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ପିଲିପ୍, ଅଃତେକ୍‌ କାଳ୍‌ ଦଃରି ମୁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଆଚି, ଆର୍‌ ଆଜି ହଃତେକ୍‌ ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଚିନୁ ନଃହାର୍‌ଲିସ୍‌ ? ଜେ ମକ୍‌ ଦଃକି ଆଚେ ସେ ମର୍‌ ଉବାକ୍‌ ଦଃକି ଆଚେ; ଅଃମିମଃନ୍‌କ୍‌ ଉବାକ୍‌ ଦଃକାଉ ବଃଲି ତୁୟ୍‌ କଃନ୍‌କଃରି କଃଉଁଲିସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ମୁୟ୍‌ ଜେ ଉବାର୍‌ ସଃଙ୍ଗ୍ ଆଚି ଆର୍‌ ଉବା ମର୍‌ ସଃଙ୍ଗ୍ ଆଚେ, ଇ କଃତା କାୟ୍‌ରି ବିସ୍ୱାସ୍‌ କଃରୁ ନଃହାରୁଲିସ୍‌ ? ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜୁୟ୍‌ କଃତା କଃଉଁଲେ, ସେରି ସଃବୁ ମର୍‌ ନିଜାର୍‌ ସିକ୍ୟା ନାୟ୍‌, ମଃତର୍‌ ଉବା ମର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ ଅଃହ୍‌ଣାର୍‌ କାମ୍‌ କଃରୁଲା । ");
INSERT INTO bdv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ମୁୟ୍‌ ଜେ ଉବାର୍‌ ସଃଙ୍ଗ୍ ଆଚି ଆର୍‌ ଉବା ଜେ ମର୍‌ ତଃୟ୍‌ ଆଚେ, ମର୍‌ ଇ କଃତା ବିସ୍ୱାସ୍‌ କଃରା, ନୟ୍‌ଲେକ୍‌, ମର୍‌ କାମ୍‌ ଦଃକି ବିସ୍ୱାସ୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ମୁୟ୍‌ ତୁମିକେ ସଃତ୍‌କଃରି କଃଉଁଲେ, ମର୍‌ତଃୟ୍‌ ଜେ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌, ମୁୟ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ କାମ୍‌ କଃରୁଲେ, ସେ ହେଁ ସେରିସଃବୁ କଃରେଦ୍‌, ଆରେକ୍‌ ସେସଃବୁ ତଃୟ୍‌ହୁଣି ହେଁ ଅଃଦିକ୍‌ ବଃଡ୍ କାମ୍‌ କଃରେଦ୍‌, ବଃଲେକ୍‌ ମୁୟ୍‌ ଉବାର୍‌ ହାକ୍‌ ଜଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଆରେକ୍‌ ଉବା ଜଃନ୍‌କଃରି ହୟ୍‌ସିର୍‌ ଗିନେ ଜଃଜ୍‌ମାନ୍ ହାୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ ଜାୟ୍‌ରି ହେଁ ମାଗାସ୍‌ ସେରି ମୁୟ୍‌ କଃରିନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଜଦି ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ ଜାୟ୍‌ରିହେଁ ମାଗାସ୍‌, ମୁୟ୍‌ ସେରି ତୁମିକେ ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ଜଦି ତୁମିମଃନ୍ ମକ୍‌ ଲାଡ୍‌ କଃରାସ୍‌ ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ମର୍‌ ଆଦେସ୍‌ ସଃବୁ ମାନାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ଆରେକ୍‌ ମୁୟ୍‌ ଉବାକ୍‌ ଗଃଉଆରି କଃରିନ୍ଦ୍‌ ଆର୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ସଃବୁ ଦିନ୍‌ ରେଉଁକେ ସେ ତୁମିକେ ଆରେକ୍‌ ଗଟ୍‌ ଉହ୍‌କାର୍‌ କାରିକେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ବଃଲେକ୍‌ ସେ ସଃତ୍‌ ଆତ୍ମା ଦଃୟ୍‌ଦ୍‌ । ଜଃଗତ୍‌ ତାକ୍‌ ଦଃରୁକ୍‌ ନାହାରେ, ବଃଲେକ୍‌ ଜଃଗତ୍‌ ତାକ୍‌ ନଃଦେକେ କି ନଃଜାଣେ; ମଃତର୍‌ ତୁମିମଃନ୍ ତାକ୍‌ ଜାଣିଆଚାସ୍‌, ବଃଲେକ୍‌ ସେ ତୁମିମଃନାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ଦ୍‌, ଆରେକ୍‌ ସେ ତୁମାର୍‌ ମଃନ୍ ବିତ୍ରେ ରଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ମୁୟ୍‌ ଗଃଲା ହଃଚେ, ତୁମିମଃନ୍‌କେ ଟୁରାହିଲା କଃରି ଚାଡି ନଃଜାୟ୍‌ଁ, ମୁୟ୍‌ ତୁମାର୍‌ ହାକ୍‌ ବାଉଳି ଆସିନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଅଃଳକ୍‌ ମଃତର୍‌ ବେଳ୍‌ ଆଚେ, ଜଃଗତ୍‌ ମକ୍‌ ଆରେକ୍‌ ଦଃକୁ ନାହାରେ; ମଃତର୍‌ ତୁମିମଃନ୍ ମକ୍‌ ଦଃକାସ୍‌, ବଃଲେକ୍‌ ମୁୟ୍‌ ଜିବନ୍, ଆର୍‌ ତୁମିମଃନ୍ ହେଁ ଜିବନ୍ ରିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ମୁୟ୍‌ ଜେ ମର୍‌ ଉବାର୍‌ ତଃୟ୍‌, ଆରେକ୍‌ ତୁମିମଃନ୍ ମର୍‌ତଃୟ୍‌ ଆର୍‌ ମୁୟ୍‌ ତୁମାର୍‌ ତଃୟ୍‌ ଆଚି । ଇରି ସେଦିନ୍ ଆୟ୍‌ଲେକ୍‌, ତୁମିମଃନ୍ ଜାଣାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଜେ ମର୍‌ ଆଦେସ୍‌ ସଃବୁ ହାୟ୍‌ କଃରି ମାନେଦ୍‌ ସେ ତ ମକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌ ଆରେକ୍‌ ଜେ ମକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ମର୍‌ ଉବା ତାକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ଆର୍‌ ମୁୟ୍‌ ତାକ୍‌ ଲାଡ୍‌ କଃରିନ୍ଦ୍‌ ଆର୍‌ ତାର୍‌ ତଃୟ୍‌ ମୁୟ୍‌ ନିଜେ ଦଃକାୟ୍‌ ଅୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଜିଉଦା, ଜେ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ନାୟ୍‌, ସେ ଜିସୁକେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ଇରି କଃନ୍‌କଃରି ଅୟ୍‌ଦ୍‌ ? ତୁୟ୍‌ ଜଃଗତ୍‌କେ ନିଜ୍‌କେ ନଃଦେକାୟ୍‌, ଅଃମାର୍‌ ତଃୟ୍‌ କଃନ୍‌କଃରି ଅଃହ୍‌ଣାକ୍‌ ଜାଣାଉଁସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଜଦି କେ ମକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ସେ ମର୍‌ କଃତା ମାନେଦ୍‌, ଆରେକ୍‌ ମର୍‌ ଉବା ତାକ୍‌ ଲାଡ୍‌ କଃରେଦ୍‌, ଆରେକ୍‌ ଉବା ଆର୍‌ ମୁୟ୍‌ ଆସି ତାର୍‌ତଃୟ୍‌ ବାସା କଃରୁନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଜେ ମକ୍‌ ଲାଡ୍‌ ନଃକେରେ, ସେ ମର୍‌ ବଃଚନ୍ ନଃମାନେ । ଆର୍‌ ଜୁୟ୍‌ କଃତା ତୁମିମଃନ୍ ସୁଣୁଲାସ୍‌, ସେରି ମର୍‌ ନିଜାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ମକେ ଜେ ହଃଟାୟ୍‌ ଆଚେ ସେ ଉବାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ମୁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରେଉଁ ରେଉଁ ତୁମିମଃନ୍‌କେ ଇସଃବୁ କଃତା କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ମଃତର୍‌ ସେ ଉହ୍‌କାର୍‌କାରି, ବଃଲେକ୍‌ ଜୁୟ୍‌ ପବିତ୍ର ଆତ୍ମାକେ ଉବା ମର୍‌ ନାଉଁଏ ହଃଟାୟ୍‌ଦ୍‌, ସେ ତୁମିମଃନ୍‌କେ ସଃବୁ ବିସୟେ ସିକ୍ୟା ଦଃୟ୍‌ଦ୍‌ ଆର୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜାୟ୍‌ ଜାୟ୍‌ରି କୟ୍‌ ଆଚି, ସେରିସଃବୁ ତୁମିମଃନ୍‌କେ ଏତୁ କଃରାୟ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସୁସ୍ତା ଦଃୟ୍‌ କଃରି ଜଃଉଁଲେ, ମର୍‌ ନିଜାର୍‌ ସୁସ୍ତା ତୁମିମଃନ୍‌କେ ଦେଉଁଲେ, ଜଃଗତ୍‌ ଜଃନ୍‌କଃରି ଦଃୟ୍‌ଦ୍‌, ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସେନ୍‌କଃରି ଦାନ୍‌ ନଃକେରି । ତୁମିମଃନ୍ ମଃନ୍‌ ବିତ୍ରେ ଚିତା କଃରା ନାୟ୍‌ କି ଡିରା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ମୁୟ୍‌ ଜେ ଜଃଉଁଲେ ଆର୍‌ ତୁମାର୍‌ ହାକ୍‌ ଆରେକ୍‌ ବାଉଳି ଆସିନ୍ଦ୍‌, ମର୍‌ ଇ କଃତା ତ ସୁଣିଆଚାସ୍‌ । ଜଦି ତୁମିମଃନ୍ ମକ୍‌ ଲାଡ୍‌ କଃର୍ତି ରିଲେକ୍‌ ମୁୟ୍‌ ମର୍‌ ଉବାର୍‌ ହାକ୍‌ ଜଃଉଁଲେ ବଃଲି ସଃର୍ଦା ଅୟ୍‌ଲାସ୍‌ ହୁଣି, ବଃଲେକ୍‌ ଉବା ମର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଆରେକ୍‌ ସେରି ଗଃଟ୍‌ତା ବଃଳ୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରାସ୍‌, ଇତାର୍‌ ଗିନେ ସେରି ଗଃଟ୍‌ତା ଆଗ୍‌ତୁ ମୁୟ୍‌ ଅଃବେ ତୁମିମଃନ୍‌କେ କୟ୍‌ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ମୁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ ବୁତେକ୍‌ ଗଃଳି କଃତାବାର୍ତା କଃରୁ ନଃହାରି, ବଃଲେକ୍‌ ଜଃଗତାର୍‌ ଅଃଦିକାରି ଆସୁଲା; ଆର୍‌ ମର୍‌ ଉହ୍ରେ ତାର୍‌ କାୟ୍‌ରିହେଁ ଅଃଦିକାର୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ମଃତର୍‌ ଉବା ମକ୍‌ ଜଃନ୍‌କଃରି ଆଡର୍‌ ଦଃୟ୍‌ ଆଚେ, ସେରଃକମ୍‌ ମୁୟ୍‌ କାମ୍‌ କଃରିନ୍ଦ୍‌, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ ମର୍‌ ଉବାକ୍‌ ଲାଡ୍‌ କଃରୁଲେ ବଃଲି ଜଃଗତ୍‌ ଜାଣେଦ୍‌ । ଉଟା, ଅଃମିମଃନ୍‌ ଇତିହୁଣି ଜୁଆଁ । ");
INSERT INTO bdv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ମୁୟ୍‌ ସଃତ୍ୟା ଅଙ୍ଗୁର୍‌ ମାଳ୍‌, ଆରେକ୍‌ ମର୍‌ ଉବା ତାସି । ");
INSERT INTO bdv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ମର୍‌ ତଃୟ୍‌ ରିଲା ଜୁୟ୍‌ କଃନ୍ଦା ହଃଳ୍‌ ନଃହେଳେ, ତାକ୍‌ ସେ କାଟି ହଃକାୟ୍‌ଦ୍‌; ଆର୍‌ ଜୁୟ୍‌ କଃନ୍ଦା ହଃଳ୍‌ ହଃଳେଦ୍‌, ସେରି ଅଃଦିକ୍‌ ହଃଳ୍‌ ହଃଳୁକ୍‌ ତାକ୍‌ ହଃର୍ଚାଳ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜୁୟ୍‌ କଃତା କୟ୍‌ଆଚି, ସେତାର୍‌ଗିନେ ତୁମିମଃନ୍ ନିର୍ମୁଳ୍‌ ଅୟ୍‌ ସଃରିଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ମର୍‌ ତଃୟ୍‌ ରିଆ, ତଃବେ ମୁୟ୍‌ ତୁମାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ନ୍ଦ୍ । କଃନ୍ଦା ଜଃନ୍‌କଃରି ଅଙ୍ଗୁର୍‌ ମାଳେ ନଃରିଲେକ୍‌ ନିଜେ ହଃଳ୍‌ ହଃଳୁ ନାହାରେ, ସେହର୍‌ ତୁମିମଃନ୍ ହେଁ ମର୍‌ ତଃୟ୍‌ ନଃରିଲେକ୍‌ ହଃଳ୍‌ ହଃଳୁ ନଃହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ମୁୟ୍‌ ଅଙ୍ଗୁର୍‌ ମାଳ୍‌, ଆର୍‌ ତୁମିମଃନ୍ କଃନ୍ଦା, ଜେ ମର୍‌ତଃୟ୍‌ ରଃୟ୍‌ଦ୍‌ ଆର୍‌ ମୁୟ୍‌ ଜାର୍‌ତଃୟ୍‌ ରଃୟ୍‌ନ୍ଦ୍, ସେ ଜଃବର୍‌ ହଃଳ୍‌ ହଃଳେଦ୍‌; ବଃଲେକ୍‌ ମୁୟ୍‌ ନୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ରି କଃରୁ ନଃହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","କେ ଜଃବେ ମର୍‌ତଃୟ୍‌ ନଃରେୟ୍‌, ତଃବେ ତାକ୍‌ ଗଟେକ୍‌ କାଟ୍‌ଲା କଃନ୍ଦା ହର୍‌ ହଃଦାୟ୍‌ ହଃକାଅୟ୍‌ଦ୍‌ ଆର୍‌ ସେରି ସୁକିଜାୟ୍‌ଦ୍‌; ଇରଃକମ୍‌ କଃନ୍ଦାମଃନ୍‌କ୍‌ ଲକ୍‌ମଃନ୍ ଗଟ୍‌ଟାଣେ ରୁଣ୍ଡାୟ୍‌ କଃରି ଜୟେ ହଃକାଉତି ଆର୍‌ ସେରିମଃନ୍ ହଡିଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଜଦି ତୁମିମଃନ୍ ମର୍‌ତଃୟ୍‌ ରିଆସ୍‌, ଆର୍‌ ମର୍‌ କଃତା ତୁମାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ତୁମିମଃନ୍ ଜାୟ୍‌ରି ମଃନ୍‌କଃରି ମାଗାସ୍‌, ସେରି ହାଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ତୁମିମଃନ୍ ଜଃବର୍‌ ହଃଳ୍‌ ହଃଳ୍‌ଲେକ୍‌ ମର୍‌ ଉବା ଜଃଜ୍‌ମାନ୍ ହାୟ୍‌ଦ୍‌, ଆର୍‌ ତୁମିମଃନ୍ ମର୍‌ ନିଜାର୍‌ ଚେଲା ଅଃଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଉବା ଜୁୟ୍‌ରଃକମ୍‌ ମକ୍‌ ଲାଡ୍‌ କଃଲା ଆଚେ, ମୁୟ୍‌ ହେଁ ସେରଃକମ୍‌ ତୁମିମଃନ୍‌କେ ଲାଡ୍‌ କଃରିଆଚି; ମର୍‌ ଲାଡେ ତିର୍‌ ଅୟ୍‌ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ମୁୟ୍‌ ଜଃନ୍‌କଃରି ମର୍‌ ଉବାର୍‌ ଆଦେସ୍‌ ମାନି କଃରି ତାର୍‌ ଲାଡେ ତିର୍‌ ଅୟ୍‌ ଆଚି, ତୁମିମଃନ୍ ସେରଃକମ୍‌ ଜଃବେ ମର୍‌ ଆଦେସ୍‌ ମାନାସ୍‌ ତଃବେ ମର୍‌ ଲାଡେ ତିର୍‌ ଅୟ୍‌ରିଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ମର୍‌ ସଃର୍ଦା ଜଃନ୍‌କଃରି ତୁମାର୍‌ ଲଃଗେ ରଃୟ୍‌ଦ୍‌, ଆର୍‌ ତୁମିମଃନାର୍‌ ସଃର୍ଦା ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ଇ ସଃବୁ କୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ମୁୟ୍‌ ଜଃନ୍‌କଃରି ତୁମିମଃନ୍‌କେ ଲାଡ୍‌ କଃରିଆଚି, ତୁମିମଃନ୍ ହେଁ ସେନ୍‌କଃରି ତୁମାର୍‌ ତୁମାର୍‌ ବିତ୍ରେ ଲାଡ୍‌ କଃରା, ଇରି ମର୍‌ ଆଦେସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ଅଃହ୍‌ଣାର୍‌ ନିଜାର୍‌ ଲକାର୍‌ ଗିନେ ନିଜାର୍‌ ଜିବନ୍ ଦେତାର୍‌ ଚାଡି କାର୍‌ ଆରେକ୍‌ ଅଃଦିକ୍‌ ବଃଡ୍ ଲାଡ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜୁୟ୍‌ ଆଡର୍‌ ଦେଉଁଲେ, ସେରି ଜଦି ମାନାସ୍‌, ତଃବେ ତୁମିମଃନ୍ ମର୍‌ ନିଜାର୍‌ ଲକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଆରେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ବଃଲି ନଃକୟ୍‌ଁ, ବଃଲେକ୍‌ ସାଉକାର୍‌ କାୟ୍‌ରି କଃରୁଲା, ଦଃଙ୍ଗ୍‌ଳା ସେରି ନଃଜାଣେ, ମଃତର୍‌ ମୁୟ୍‌ ତୁମିକେ ନିଜାର୍‌ ସଃଙ୍ଗ୍ ବଃଲି କୟ୍‌ଆଚି, ବଃଲେକ୍‌ ମୁୟ୍‌ ମର୍‌ ଉବାର୍‌ ତଃୟ୍‌ହୁଣି ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣିଆଚି, ସେରି ସଃବୁ ତୁମିମଃନ୍‌କେ ଜାଣାୟ୍‌ ଦିଲେଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ତୁମିମଃନ୍ ମକ୍‌ ବାଚ୍‌ଲାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ବାଚି ଆଚି, ଆର୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଅଃଦିକ୍‌ ହଃଳ୍‌ ହଃଳୁକ୍‌ ହାରାସ୍‌ ଆର୍‌ ତୁମାର୍‌ ହଃଳ୍‌ ସଃବୁ ଦିନ୍ ରଃୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ, ତୁମିମଃନ୍‌କେ କାମେ ଲାଗାୟ୍‌ ଆଚି । ସେତାକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ ଉବାକ୍‌ ଜାୟ୍‌ରି ହେଁ ମାଗାସ୍‌, ସେ ସେରି ତୁମିକେ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ଗଟ୍‌ ଲକ୍‌ ଆରେକ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଲାଡ୍‌ କଃରାସ୍‌, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଇସଃବୁ ଆଡର୍‌ ଦେଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ଜଦି ଜଃଗତ୍‌ ତୁମିମଃନ୍‌କେ ବିରଦ୍‌ କଃରେଦ୍‌, ତଃବେ ତୁମିମଃନ୍‌କେ ବିରଦ୍‌ କଃର୍ତା ଆଗ୍‌ତୁ, ସେରି ଜେ ମକ୍‌ ଗିଣ୍ କଃରି ଆଚେ, ଇରି ଜାଣା । ");
INSERT INTO bdv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଜଦି ତୁମିମଃନ୍ ଜଃଗତାର୍‌ ଅୟ୍‌ରିଲେକ୍‌, ଜଃଗତ୍‌ ତୁମିମଃନ୍‌କେ ନିଜାର୍‌ ଲକ୍‌ ବଃଲି ଲାଡ୍‌ କଃଲିହୁଣି, ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃଗତାର୍‌ ନାୟ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଜଃଗତ୍‌ ବିତ୍ରେହୁଣି ବାଚି ଆଚି, ଇତାର୍‌ ଗିନେ ଜଃଗତ୍‌ ତୁମିକେ ବିରଦ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ଗତିଦଃଙ୍ଗ୍‌ଳା ସାଉକାର୍‌ ତଃୟ୍‌ହୁଣି ବଃଡ୍ ନାୟ୍‌, ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଇ ଜୁୟ୍‌ କଃତା କୟ୍‌ରିଲେ, ସେରି ଏତୁ କଃରା । ଜଦି ସେମଃନ୍ ମକ୍‌ ତାଡ୍‌ନା କଃରିଆଚ୍‌ତି, ତଃବେ ତୁମିମଃନ୍‌କେ ହେଁ ତାଡ୍‌ନା କଃର୍ତି; ଜଦି ସେମଃନ୍ ମର୍‌ କଃତା ମାନି ଆଚ୍‌ତି, ତଃବେ ତୁମିମଃନାର୍‌ କଃତାକ୍‌ ହେଁ ମାନ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ମଃତର୍‌ ସେମଃନ୍ ମକ୍‌ ହଃଟାୟ୍‌ଲା ଲକ୍‌କେ ଜାଣି ନଃରିଲାକ୍‌, ମର୍‌ ନାଉଁ ଗିନେ ତୁମିକେ ଇସଃବୁ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଜଦି ମୁୟ୍‌ ଆସି ସେମଃନ୍‌କେ କୟ୍‌ ନଃରିଲେକ୍‌, ସେମଃନାର୍‌ ହାହ୍‌ ନିଲାହୁଣି; ମଃତର୍‌ ଅଃବେ ସେମଃନାର୍‌ ହାହ୍‌ ବିସୟେ ସେମଃନ୍ କାୟ୍‌ ହେଁ ବାଟ୍‌ ଦଃକାଉଁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଜେ ମକ୍‌ ବିରଦ୍‌ କଃରେଦ୍‌, ସେ ମର୍‌ ଉବାକ୍‌ ହେଁ ବିରଦ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଜୁୟ୍‌ କାମ୍‌ସଃବୁ ଆରେକ୍‌ କେ ହେଁ ନଃକେର୍ତି, ମୁୟ୍‌ ଜଦି ସେରିସଃବୁ ସେମଃନାର୍‌ ବିତ୍ରେ କଃରି ନଃରିଲେକ୍‌, ସେମଃନାର୍‌ ହାହ୍‌ ନିଲାହୁଣି; ମଃତର୍‌ ଅଃବେ ସେମଃନ୍ ଦଃକିଆଚ୍‌ତି, ଆରେକ୍‌ ମକ୍‌ ଆର୍‌ ମର୍‌ ଉବାକ୍‌ ଗିଣ୍ କଃରି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମଃତର୍‌ ସେମଃନ୍ ତିନିହଲ୍ୟାୟ୍‌ ମକ୍‌ ବିରଦ୍‌ କଃଲାୟ୍‌, ସେମଃନାର୍‌ ବିଦିଲଃଗେ ଲେକାଅୟ୍‌ଲା ଇ ବଃଚନ୍ ଜଃନ୍‌କଃରି ହୁରା ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ଇବାନ୍ୟା ଗଃଟୁଲି । ");
INSERT INTO bdv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ଉବାର୍‌ ଲଃଗେହୁଣି ମୁୟ୍‌ ତୁମାର୍‌ ହାକ୍‌ ଜୁୟ୍‌ ଉହ୍‌କାର୍‌ କାରିକେ ହଃଟାୟ୍‌ନ୍ଦ୍, ସେ ଉବାର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ପବିତ୍ର ଆତ୍ମାର୍‌ ବିସୟେ ସଃତ୍‌ ସାକି ଦଃୟ୍‌ଦ୍‌ । ଆର୍‌ ମର୍‌ ବିସୟେ ହେଁ ସାକି ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆର୍‌ ତୁମିମଃନ୍ ହେଁ ସାକି, ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଆରୁମେ ହୁଣି ମର୍‌ ସଃଙ୍ଗ୍ ଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ନିଜାର୍‌ ବିସ୍ୱାସ୍‌ ଦଃରି ରିଆସ୍‌, ସେତାର୍‌ ଗିନେ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଇସଃବୁ କଃତା କୟ୍‌ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ସେମଃନ୍ ତୁମିମଃନ୍‌କେ ଦଃଳେ ହୁଣି ବାର୍‌ତି ଆର୍‌ ଇବାନ୍ୟା ଦିନ୍ ଆସୁଲି, ଜଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନ୍ ତୁମିକେ ମଃର୍ନେ ମାର୍ତି ଆର୍‌ ଇସ୍ୱର୍‌ ଲଃଗେ ସେବା କଃରୁଲୁ ବଃଲି ମଃନେ ବାବ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ଆର୍‌ ଲକ୍‌ମଃନ୍ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ଇସଃବୁ କଃର୍ତି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ମକ୍‌ କି ମର୍‌ ଉବାକ୍‌ ନଃଜାଣ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ମଃତର୍‌ ଇସଃବୁ ଗଃଟ୍‌ତା ଦିନ୍ ଆୟ୍‌ଲେକ୍‌, ମୁୟ୍‌ ଜେ ତୁମିମଃନ୍‌କେ କୟ୍‌ରିଲେ, ଇରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ମଃନେ ଏତାଉଆସ୍‌, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ଇସଃବୁ କଃତା ତୁମିମଃନ୍‌କେ କଃଉଁଲେ । ମୁୟ୍‌ ତୁମାର୍‌ ସଃଙ୍ଗ୍ ରିଲେଲାଗି, ଆରୁମେ ହୁଣି ଇ କଃତା କୟ୍‌ ନଃରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ଅଃବେ ମୁୟ୍‌ ମକ୍‌ ହଃଟାୟ୍‌ ରିଲା ଲକାର୍‌ ତଃୟ୍‌ ବାଉଳି ଜଃଉଁଲେ । ଅୟ୍‌ଲେକ୍‌ ହେଁ ତୁୟ୍‌ କେଣେ ଜଃଉଁଲିସ୍‌ ବଃଲି ତୁମାର୍‌ ବିତ୍ରେ କେହେଁ ମକ୍‌ ଗଃଉଆରି ନଃକେରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ଅଃବେ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଇସଃବୁ କଃତା କୟ୍‌ଲେ ବଃଲି ତୁମିମଃନ୍ ମଃନ୍‌ ବିତ୍ରେ ବଃଡେ ଦୁକ୍‌ କଃରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମଃତର୍‌ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ମୁୟ୍‌ ଗଃଲେକ୍‌ ତୁମିମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ ଅୟ୍‌ଦ୍‌, ବଃଲେକ୍‌ ମୁୟ୍‌ ନଃଗେଲେକ୍‌, ସେ ଉହ୍‌କାର୍‌ କଃର୍ତା ଆତ୍ମା ତୁମାର୍‌ ଲଃଗେ ନାସେ, ମଃତର୍‌ ମୁୟ୍‌ ଗଃଲେକ୍‌ ଉବା ତାକ୍‌ ତୁମାର୍‌ ଲଃଗେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ସେ ଆସି ହାହ୍‌, ଦଃର୍ମ୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ବିସୟେ ଜଃଗତାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ସଃତ୍‌ ବୁଦି ଦଃୟ୍‌ଦ୍‌ ଇରି ଇସ୍ୱରାର୍‌ ଇଚା । ");
INSERT INTO bdv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ହାହ୍‌ ବିସୟେ ସେମଃନ୍ ଦସି, ବଃଲେକ୍‌ ସେମଃନ୍ ମର୍‌ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ ନଃକେଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଦଃର୍ମି ବିସୟେ ସେମଃନ୍ ଦସି, ବଃଲେକ୍‌ ମୁୟ୍‌ ଉବାର୍‌ ହାକ୍‌ ଜଃଉଁଲେ, ଇରି ଉବା ଇସ୍ୱରାର୍‌ ଇଚା ଆର୍‌ ତୁମିମଃନ୍ ମକ୍‌ ନଃଦେକାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ନ୍ୟାୟ୍‌ ବିସୟେ ସେମଃନ୍ ଦସି, ବଃଲେକ୍‌ ଇ ଜଃଗତାର୍‌ ଅଃଦିକାରିକ୍‌ ବିଚାର୍‌ କଃରା ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଆରେକ୍‌ ଗାଦେକ୍‌ କଃତା କଃଉତାର୍‌ ଆଚେ, ମଃତର୍‌ ତୁମିମଃନ୍ ଅଃବେ ସେସଃବୁ ସୁଣି ସଃମ୍ବାଳୁ ନଃହାରାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମଃତର୍‌ ସେ, ବଃଲେକ୍‌ ସଃତ୍‌ ଆତ୍ମା ଆୟ୍‌ଲେକ୍‌, ସେ ବାଟ୍‌ ଦଃକାୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃବୁ ସଃତ୍‌ ବିତ୍ରେ ନଃୟ୍‌ଦ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଅଃହ୍‌ଣାର୍‌ ତଃୟ୍‌ହୁଣି କଃତା ନଃକୟ୍‌ଁ, ମଃତର୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ସୁଣେଦ୍‌ ସେରି ସଃବୁ କୟ୍‌ଦ୍‌, ଆରେକ୍‌ ଜାୟ୍‌ରି ଆଗେ ଗଃଟୁକ୍‌ ଆଚେ ସେରି କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ସେ ମକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରେଦ୍‌, ବଃଲେକ୍‌ ସେ ମୁୟ୍‌ କୟ୍‌ଲା ସଃବୁକଃତା ତୁମିମଃନ୍‌କେ ଜାଣାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଜାୟ୍‌ ଜାୟ୍‌ରି ଉବାର୍‌, ସେରିସଃବୁ ମର୍‌, ଇତାର୍‌ଗିନେ ମୁୟ୍‌ କୟ୍‌ଲେ, ପବିତ୍ର ଆତ୍ମା ମର୍‌ ତଃୟ୍‌ହୁଣି ସଃବୁ କଃତା ନଃୟ୍‌ ସେ ତୁମିମଃନ୍‌କେ ଜାଣାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ଅଃଳକ୍‌ ବେଳା ମଃତର୍‌ ଆଚେ, ତୁମିମଃନ୍ ମକ୍‌ ଆରେକ୍‌ ଦଃକୁ ନଃହାରାସ୍‌, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଅଃଳକ୍‌ ବେଳ୍‌ ଗଃଲା ହଃଚେ ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁ ହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ତଃବେ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ କଃତିଲକ୍‌ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଅଃଳକ୍‌ ବେଳା ଆଚେ, ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁ ନାହାରାସ୍‌, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଅଃଳକ୍‌ ବେଳା ଗଃଲା ହଃଚେ ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁ ହାରାସ୍‌ ଆର୍‌ ମୁୟ୍‌ ଉବାର୍‌ ଲଃଗେ ଜଃଉଁଲେ, ଇ ଜୁୟ୍‌ କଃତା ସେ ଅଃମିମଃନ୍‌କ୍‌ କଃଉଁଲା, ଇତାର୍‌ ଅଃର୍ତ୍‌ କାୟ୍‌ରି ? ");
INSERT INTO bdv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ଅଃଳକ୍‌ ବେଳ୍‌ ବଃଲି ଏ କାୟ୍‌ରି କଃଉଁଲା ? ସେ କାୟ୍‌ରି କଃଉଁଲା ଅଃମିମଃନ୍‌ ବୁଜୁ ନଃହାରୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ଚେଲାମଃନ୍ ତାକ୍‌ ଗଃଉଆରି କଃରୁକେ ମଃନ୍ କଃରୁଲାୟ୍‌ ବଃଲି ଜାଣୁ ହାରି, ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଅଃଳକ୍‌ ବେଳା ଆଚେ, ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁ ନାହାରାସ୍‌, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଅଃଳକ୍‌ ବେଳ୍‌ ଗଃଲା ହଃଚେ ତୁମିମଃନ୍ ମକ୍‌ ଦଃକୁ ହାରାସ୍‌, ମୁୟ୍‌ ଇ ଜୁୟ୍‌ କଃତା କୟ୍‌ଲେ, ସେ କଃତାକ୍‌ ଦଃରି ତୁମିମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ବିତ୍ରେ କାୟ୍‌ବଃଲି କଃଉଆକଇ ଅଃଉଁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ସଃତ୍‌କଃରି ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ, ତୁମିମଃନ୍ ଦୁକ୍‌ କଃରାସ୍‌ ଆର୍‌ ଏତାୟ୍‌ ଏତାୟ୍‌ କାନ୍ଦାସ୍‌, ମଃତର୍‌ ଜଃଗତ୍‌ ସଃର୍ଦା କଃରେଦ୍‌; ତୁମିମଃନ୍ ଦୁକ୍‌ ଅଃଉଆସ୍‌, ମଃତର୍‌ ତୁମାର୍‌ ଦୁକ୍‌ ସଃର୍ଦାୟ୍‌ ହାସ୍‌ଲେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ହିଲା ଜଃଲମ୍‌ କଃର୍ତା ବେଳା ଆୟ୍‌ଲେକ୍‌ ମାୟ୍‌ଜି ଦୁକ୍‌ ହାୟ୍‌ଦ୍‌, ମଃତର୍‌ ସେ ହିଲା ଜଃଲମ୍‌ କଃଲା ହଃଚେ ଜଃଗତ୍‌କେ ଗଟେକ୍‌ ନଃର୍‌ ହିଲା ଜଃଲମ୍‌ କଃଲା, ଇ ସଃର୍ଦା ଗିନେ ତାର୍‌ ଦୁକ୍‌କଃସ୍ଟ୍‌ ହାସ୍ରିଜାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ସେବାନ୍ୟା ତୁମିମଃନ୍ ଅଃବେ ଦୁକ୍‌ ହାଉଁଲାସ୍‌, ମଃତର୍‌ ମୁୟ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ତୁମିମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌ନ୍ଦ୍, ଆର୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍‌ ସଃର୍ଦା ଅୟ୍‌ଦ୍‌ ଆର୍‌ କେହେଁ ତୁମାର୍‌ ଲଃଗେହୁଣି ତୁମିମଃନାର୍‌ ସେ ସଃର୍ଦା ଚାଡାୟ୍‌ ନଃନେୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ସେଦିନ୍ ଆୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ କାୟ୍‌ରି ହେଁ ଗଃଉଆରି କଃରୁକେ ନଃହେଳେ, ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ସଃତ୍‌ କଃଉଁଲେ, ଜଦି ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ ଉବାକ୍‌ ଜାୟ୍‌ରି ମାଗାସ୍‌, ସେ ତୁମିମଃନ୍‌କେ ସେରି ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ଅଃବେ ହଃତେକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ କାୟ୍‌ରି ନଃମାଗାସ୍‌; ଅଃବେହୁଣି ମାଗା, ତୁମିମଃନାର୍‌ ସଃର୍ଦା ଜଃନ୍‌କଃରି ହୁର୍ନ୍‌ ଅୟ୍‌ଦ୍‌, ସେତାର୍‌ଗିନେ ତୁମିମଃନ୍ ସେରି ହାଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ କଃତାନି କୟ୍‌କଃରି କଃଉଁଲେ, ବେଳ୍‌ ଆସୁଲି, ଜଃଡେବଃଳ୍‌ ମୁୟ୍‌ ଆରେକ୍‌ କଃତାନି କୟ୍‌କଃରି ତୁମିମଃନ୍‌କେ ନଃକୟ୍‌ଁ, ମଃତର୍‌ ଉବାର୍‌ ବିସୟେ ନିକକଃରି ବୁଜ୍‌ଲାହର୍‌ ତୁମିମଃନ୍‌କେ ଜାଣାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ସେଦିନ୍ ଆୟ୍‌ଲେକ୍‌, ତୁମିମଃନ୍ ମର୍‌ ନାଉଁଏ ଉବାକ୍‌ ମାଗାସ୍‌; ସଃଡେବଃଳ୍‌ ମୁୟ୍‌ ତୁମାର୍‌ ଗିନେ ଉବାକ୍‌ ଗଃଉଆରି କଃରୁକେ ନଃହେଳେ, ");
INSERT INTO bdv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ବଃଲେକ୍‌ ଉବା ନିଜେ ତୁମିମଃନ୍‌କେ ଲାଡ୍‌ କଃରୁଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ମକ୍‌ ଲାଡ୍‌ କଃରୁଲାସ୍‌ ଆର୍‌ ମୁୟ୍‌ ଜେ ଇସ୍ୱର୍‌ ଲଃଗେ ହୁଣି ଆସିଆଚି, ସେରି ତୁମିମଃନ୍ ବିସ୍ୱାସ୍‌ କଃରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ସଃତ୍‌କଃରି ମୁୟ୍‌ ଉବାର୍‌ ଲଃଗେ ହୁଣି ଜଃଗତେ ଆସିଆଚି; ଆର୍‌ ଅଃବେ ମୁୟ୍‌ ଜଃଗତ୍‌ ଚାଡି ଉବାର୍‌ ଲଃଗେ ବାଉଳି ଜାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଇ କଃତା ସୁଣି ତାର୍‌ ଚେଲାମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଦଃକ୍‌, ଅଃବେ ତୁୟ୍‌ ବୁଜ୍‌ଲା ହର୍‌କଃରି କଃଉଁଲିସ୍‌ ଆର୍‌ କଃତାନି ଆରେକ୍‌ ନଃକଉଁଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଅଃବେ ଅଃମିମଃନ୍‌ ଜାଣ୍‌ଲୁ ଜେ ତୁୟ୍‌ ସଃବୁ ବିସୟ୍‌ ଜାଣି ଆଚ୍‌ସି, ଆରେକ୍‌ ତୁୟ୍‌ କାକେ ଗଃଉଆରି କଃର୍ତା ଲଳା ନାୟ୍‌; ଇସ୍ୱର୍‌ ଲଃଗେ ହୁଣି ତୁୟ୍‌ ଆସି ଆଚ୍‌ସି ବଃଲି ଅଃମିମଃନ୍‌ ଇତାର୍‌ ଗିନେ ସଃତ୍‌ କଃରୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ ଅଃବେ ସଃତ୍‌ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ଦଃକା, ବେଳା ଆସୁଲି, ହେଁ, ଆୟ୍‌ଲିନି, ଜଃଡେବଃଳ୍‌ ତୁମିମଃନ୍ ଚିନ୍‌ବିନ୍ ଅୟ୍‌ ସଃବୁ ଲକ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ଗଃରେ ହଃଳାୟ୍‌ ଜାହାସ୍‌, ଆର୍‌ ମକ୍‌ ଏକ୍ଲା କଃରି ଚାଡାସ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ମୁୟ୍‌ ଏକ୍ଲା ନାୟ୍‌, ବଃଲେକ୍‌ ଉବା ମର୍‌ ସଃଙ୍ଗ୍ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ମର୍‌ ଲଃଗେ ରଃୟ୍‌ ସୁସ୍ତା ହାଉଆସ୍‌, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ ଇ ସଃବୁ କଃତା କଃଉଁଲେ । ଜଃଗତେ ତୁମାର୍‌ ଗିନେ ଦୁକ୍‌ କଃସ୍ଟ୍‌ ଆଚେ, ମଃତର୍‌ ସାସ୍‌ ଦଃରା, ମୁୟ୍‌ ଜଃଗତ୍‌କେ ଜିଣି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁ ଇ ସଃବୁ କଃତା କୟ୍‌ ସଃରାୟ୍‌ ସଃର୍ଗ୍‌ ବାଟ୍ୟା ଦଃକିକଃରି କୟ୍‌ଲା, “ଉବା, ମର୍‌ ବେଳା ହଚ୍‌ଲିନି, ତର୍‌ ହୟ୍‌ଦିକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍‌, ଜଃନ୍‌କଃରି ହୟ୍‌ଦି ହେଁ ତକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରେଦ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ତୁୟ୍‌ ତାକ୍‌ ସଃବୁ ମାନାୟ୍‌ ଜାତି ଉହ୍ରେ ଅଃଦିକାର୍‌ ଦଃୟ୍‌ଆଚ୍‌ସି । ଜଃନ୍‌କଃରି ତୁୟ୍‌ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ତାର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ ଆଚ୍‌ସି, ସେମଃନ୍‌କେ ସେ ଅଃମ୍ବର୍‌ ଜିବନ୍ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଆର୍‌, ଗଟେକ୍‌ ବଃଲି ସଃତ୍ୟା ଇସ୍ୱର୍‌ ଜେ ତୁୟ୍‌, ତକ୍‌ ଆର୍‌ ତୁୟ୍‌ ହଃଟାୟ୍‌ଲା ଜିସୁ କ୍ରିସ୍ଟକେ ଜାଣ୍‌ତାର୍‌ ହଃକା ଅଃମ୍ବର୍‌ ଜିବନ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ କାମ୍‌ କଃରୁକେ ଦଃୟ୍‌ଆଚ୍‌ସି, ସେରି ମୁୟ୍‌ ସଃରାୟ୍‌ କଃରି ହୁର୍ତିବିଏ ତକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଏ ଉବା, ଜଃଗତାର୍‌ ଉବ୍‌ଜାଣ୍‌ ହୁର୍ବେ ତର୍‌ ସଃଙ୍ଗ୍ ମର୍‌ ଜୁୟ୍‌ ଜଃଜ୍‌ମାନ୍‌ ରିଲି, ଅଃବେ ତର୍‌ ମୁୟେ ତୁୟ୍‌ ମକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ତୁୟ୍‌ ମକ୍‌ ଜଃଗତାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସଃର୍ହି ଦଃୟରିଲିସ୍‌, ମୁୟ୍‌ ସେମଃନାର୍‌ ଲଃଗେ ତର୍‌ ନାଉଁ ଜାଣାୟ୍‌ଲେ ଆଚି; ସେମଃନ୍ ତର୍‌ ରିଲାୟ୍‌, ଆର୍‌ ତୁୟ୍‌ ସେମଃନ୍‌କେ ମକ୍‌ ସଃର୍ହି ଦିଲିସ୍‌, ଆର୍‌ ସେମଃନ୍ ତର୍‌ କଃତା ମାନ୍‌ଲାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ରି ସଃର୍ହି ଦଃୟ୍‌ ଆଚ୍‌ସି, ସେ ସଃବୁ ଜେ ତର୍‌ ତଃୟ୍‌ହୁଣି ଆସି ଆଚେ, ଇରି ସେମଃନ୍ ଅଃବେ ବୁଜି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ ସଃବୁ କଃତା ସଃର୍ହି ଦିଲିସ୍‌, ମୁୟ୍‌ ସେମଃନ୍‌କେ ସେସଃବୁ ସଃର୍ହି ଦିଲେ ଆଚି, ଆର୍‌ ସେମଃନ୍ ଦଃରି ଆଚ୍‌ତି, ଆରେକ୍‌ ମୁୟ୍‌ ଜେ ତର୍‌ ଲଃଗେହୁଣି ଆସି ଆଚି, ଆର୍‌ ତୁୟ୍‌ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚ୍‌ସି ବଃଲି ନିଜ୍‌କଃରି ଜାଣ୍‌ଲାୟ୍‌ ଆର୍‌ ବିସ୍ୱାସ୍‌ କଃରୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ମୁୟ୍‌ ସେମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃରୁଲେ; ଜଃଗତାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା ନଃକେରି, ମଃତର୍‌ ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ସି, ସେମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃରୁଲେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ତର୍‌; ");
INSERT INTO bdv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଜୁୟ୍‌ ଜୁୟ୍‌ରି ମର୍‌, ସେ ସଃବୁ ତର୍‌, ଆରେକ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ରି ତର୍‌, ସେ ସଃବୁ ମର୍‌; ଆର୍‌ ମୁୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଜଃଜ୍‌ମାନ୍ ହାୟ୍‌ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ମୁୟ୍‌ ଆରେକ୍‌ ଇ ଜଃଗତେ ନଃରେୟ୍‌ଁ, ମଃତର୍‌ ଇମଃନ୍‌ ଜଃଗତେ ରେଉଁଲାୟ୍‌; ଆରେକ୍‌, ମୁୟ୍‌ ତର୍‌ ଲଃଗେ ଜଃଉଁଲେ । ପବିତ୍ର ଉବା, ତୁୟ୍‌ ମକ୍‌ ଦିଲା ନାଉଁଆର୍‌ ସଃକ୍ତିୟେ ସେମଃନ୍‌କେ ବଚାଉ; ଜଃନ୍‌କଃରି ଅଃମିମଃନ୍‌ ଗଟେକ୍‌, ସେମଃନ୍ ସେବାନ୍ୟା ଗଟେକ୍‌ ଅଃଉଁକେ ଉହ୍‌କାର୍‌ କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରେତି ରିଲାବଃଳ୍‌ ମୁୟ୍‌ ସେମଃନ୍‌କେ ତର୍‌ ନାଉଁଆର୍‌ ସଃକ୍ତିୟେ ବାଚାୟ୍‌ ଆସିଆଚି, ଜୁୟ୍‌ ନାଉଁ ତୁୟ୍‌ ମକ୍‌ ଦଃୟ୍‌ଆଚ୍‌ସି; ଆର୍‌ ମୁୟ୍‌ ସେମଃନ୍‌କେ ଜଃଗ୍ରାତ୍‌ କଃରି ବାଚାୟ୍‌ ଆଚି ଆର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ବଃଚନ୍ ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ଜୁୟ୍‌ ଲକ୍‌ ନଃସ୍ଟ୍‌ ଅଃଉଁକେ ରିଲି ସେ ହଃକା ନଃସ୍ଟ୍‌ ଅୟ୍‌ଲା ଆଚେ ଆର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ହେଁ ନଃସ୍ଟ୍‌ ନଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ଆର୍‌ ଅଃବେ ମୁୟ୍‌ ତର୍‌ ଲଃଗେ ଆସୁଲେ, ଆର୍‌ ସେମଃନାର୍‌ ମଃନ୍ ବିତ୍ରେ ମର୍‌ ସଃର୍ଦା ଜଃନ୍‌କଃରି ହୁରା ଅୟ୍‌ଦ୍‌, ସେତାର୍‌ ଗିନେ ଜଃଗତେ ରେଉଁ ରେଉଁ ମୁୟ୍‌ ଇ ସଃବୁ କଃତା କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ମୁୟ୍‌ ସେମଃନ୍‌କେ ତର୍‌ ବଃଚନ୍ ଦଃୟ୍‌ ଆଚି, ଆର୍‌ ଜଃଗତ୍‌ ସେମଃନ୍‌କେ ବିରଦ୍‌ କଃରିଆଚେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ ଜଃନ୍‌କଃରି ଇ ଜଃଗତାର୍‌ ଲକ୍‌ ନାୟ୍‌, ସେମଃନ୍ ହେଁ ସେବାନ୍ୟା ଇ ଜଃଗତାର୍‌ ଲକ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ତୁୟ୍‌ ସେମଃନ୍‌କେ ଜଃଗତେ ହୁଣି ନେ ବଃଲି ମୁୟ୍‌ ପାର୍ତ୍‌ନା ନଃକେରି, ମଃତର୍‌ ସେମଃନ୍‌କେ ଦୁସ୍ଟ୍‌ ଲକାର୍‌ ଆତେ ହୁଣି ବଚାଉ ବଃଲି ପାର୍ତ୍‌ନା କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ମୁୟ୍‌ ଜଃନ୍‌କଃରି ଇ ଜଃଗତାର୍‌ ଲକ୍‌ ନାୟ୍‌, ସେମଃନ୍ ହେଁ ସେବାନ୍ୟା ଇ ଜଃଗତାର୍‌ ଲକ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ସଃତ୍‌ ସଃଙ୍ଗ୍ ସେମଃନ୍‌କେ ପବିତ୍ର କଃର୍‌, ତର୍‌ ବଃଚନ୍ ତ ସଃତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ତୁୟ୍‌ ମକ୍‌ ଜଃନ୍‌କଃରି ଜଃଗତେ ହଃଟାୟ୍‌ ଆଚ୍‌ସି, ମୁୟ୍‌ ହେଁ ସେମଃନ୍‌କେ ସେବାନ୍ୟା ଜଃଗତେ ହଃଟାୟ୍‌ ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଆର୍‌ ସେମଃନ୍ ହେଁ ଜଃନ୍‌କଃରି ସଃତ୍‌ ସଃଙ୍ଗ୍ ପବିତ୍ର ଅଃଉତି, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ସେମଃନାର୍‌ ଗିନେ ନିଜ୍‌କେ ପବିତ୍ର କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ମୁୟ୍‌ ଅଃବ୍‌କା ଇମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା ନଃକେରି, ମଃତର୍‌ ଇମଃନାର୍‌ ବଃଚନ୍ ସଃଙ୍ଗ୍ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ମର୍‌ ଲଃଗେ ବିସ୍ୱାସ୍‌ କଃର୍ତି, ସେମଃନାର୍‌ ଗିନେ ହେଁ ପାର୍ତ୍‌ନା କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ଜଃନ୍‌କଃରି ସେମଃନ୍ ସଃବୁ ଲକ୍‌ ଗଟେକ୍‌ ଅଃଉତି ଇରି ମର୍‌ ପାର୍ତ୍‌ନା; ଏ ଉବା, ତୁୟ୍‌ ଜଃନ୍‌କଃରି ମର୍‌ ଲଃଗେ ଆଚ୍‌ସି ଆର୍‌ ମୁୟ୍‌ ତର୍‌ ଲଃଗେ ଆଚି, ସେମଃନ୍ ହେଁ ସେବାନ୍ୟା ଅଃମାର୍‌ ଲଃଗେ ରେଅତ୍‌, ଜଃନ୍‌କଃରି ତୁୟ୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲିସ୍‌ ବଃଲି ଜଃଗତ୍‌ ବିସ୍ୱାସ୍‌ କଃରେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଆର୍‌, ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ ଜଃଜ୍‌ମାନ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ସି, ମୁୟ୍‌ ସେମଃନ୍‌କେ ସେରି ଦଃୟ୍‌ ଆଚି, ଜଃନ୍‌କଃରି ତୁୟ୍‌ ଆର୍‌ ମୁୟ୍‌ ଗଟେକ୍‌, ସେମଃନ୍ ସେବାନ୍ୟା ଗଟେକ୍‌ ଅଃଉତି; ");
INSERT INTO bdv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ମୁୟ୍‌ ସେମଃନାର୍‌ ଲଃଗେ, ଆର୍‌ ତୁୟ୍‌ ମର୍‌ ଲଃଗେ, ଜଃନ୍‌କଃରି ସେମଃନ୍ ମିସି ଗଟେକ୍‌ ଅଃଉତି, ତଃବେ ଜଃଗତ୍‌ ବୁଜେଦ୍‌ ଜେ ତୁୟ୍‌ ମକ୍‌ ହଃଟାୟ୍‌ଲିସ୍‌, ଆରେକ୍‌ ମକ୍‌ ଜଃନ୍‌କାର୍‌ ଲାଡ୍‌ କଃଲିସ୍‌, ସେମଃନ୍‌କେ ସେବାନ୍ୟା ଲାଡ୍‌ କଃରୁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଏ ଉବା, ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ସି, ମୁୟ୍‌ ଜୁୟ୍‌ ଲଃଗେ ରଃୟ୍‌ନ୍ଦ୍, ସେମଃନ୍ ହେଁ ସେତି ଜଃନ୍‌କଃରି ମର୍‌ ସଃଙ୍ଗ୍ ରେତି ଆର୍‌ ଜଃଗତାର୍‌ ଉବ୍‌ଜାଣ୍‌ ହୁର୍ବେ ତୁୟ୍‌ ମକ୍‌ ଲାଡ୍‌ କଃରି ରିଲାକ୍‌ ମକ୍‌ ଜୁୟ୍‌ ଜଃଜ୍‌ମାନ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ସି, ମର୍‌ ସେ ଜଃଜ୍‌ମାନ୍ ସେମଃନ୍ ଜଃନ୍‌କଃରି ଦଃକ୍‌ତି, ଇରି ମର୍‌ ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଦଃର୍ମି ଉବା, ଜଃଗତ୍‌ ତକ୍‌ ନଃଜାଣେ, ମଃତର୍‌ ମୁୟ୍‌ ତକ୍‌ ଜାଣି ଆଚି; ଆର୍‌, ତୁୟ୍‌ ଜେ ମକ୍‌ ହଃଟାୟ୍‌ଲିସ୍‌, ସେରି ଇମଃନ୍‌ ଜାଣି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଆରେକ୍‌, ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ ଲାଡ୍‌ କଃଲିସ୍‌, ସେରି ଜଃନ୍‌କଃରି ସେମଃନାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ଦ୍‌ ଆର୍‌ ମୁୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ରଃୟ୍‌ନ୍ଦ୍, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ସେମଃନ୍‌କେ ତର୍‌ ନାଉଁ ଜାଣାୟ୍‌ ଆଚି ଆର୍‌ ସଃବୁବଃଳ୍‌ ଜାଣାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜିସୁ ଇସଃବୁ ପାର୍ତ୍‌ନା ସଃରାୟ୍‌କଃରି ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ କିଦ୍ରଣ୍ ନାଉଁଆର୍‌ ଦରାଣ୍ ସେହାଟିକ୍‌ ବାରାୟ୍‌ ଗଃଳାୟ୍‌ । ସେତି ଗଟେକ୍‌ ବାଳ୍‌ ରିଲି, ଆର୍‌ ଜିସୁ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ସେଲଃଗେ ହୁର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଜୁୟ୍‌ ଜିଉଦା ଜିସୁକେ ସଃତ୍ରୁ ଆତେ ସଃହ୍ରି ଦିଲା, ସେ ହେଁ ସେ ଟାଣ୍ ଜାଣିରିଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ଗାଦେକ୍‌ ତର୍‌ ଅଃହ୍‌ଣାର୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେଟାଣେ ଜାୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ସେତାକ୍‌, ଜାଗୁଆଳି ସଃଇନ୍ ଦଃଳ୍‌ ଆରେକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରୁସିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ହାୟ୍‌ଲା ସଃଇନ୍‌ମଃନ୍‌କେ ଦଃରି ଲାତର୍‌ ଆର୍‌ କଃଣ୍ଡାମଃନ୍ ଦଃରି ସେ ଲଃଗେ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ସେତାକ୍‌ ଜିସୁ, ତାର୍‌ ସଃଙ୍ଗ୍ ଜାୟ୍‌ ଜାୟ୍‌ରି ଗଃଟୁକ୍‌ ଜଃଉଁଲି, ସେସଃବୁ ଜାଣି ଆଗ୍‌ତୁ ଜାୟ୍‌ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ କାକେ ଲଳୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ସେମଃନ୍ ତାକ୍‌ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ନାଜରିତ୍‌ ଜିସୁକେ ।” ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସେ ଲକ୍‌ ।” ଜୁୟ୍‌ ଜିଉଦା ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ଦିଲା, ସେ ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଟିଆ ଅୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜିସୁ ଜଃଡେବଃଳ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ସେ ଲକ୍‌,” ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ହଃଚେ ଗୁଚି ଜାୟ୍‌ ବୁୟେଁ ହଃବ୍ଳାୟ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ସେତାକ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ହଃଚାର୍ଲା, “ତୁମିମଃନ୍ କାକେ ଲଳୁଲାସ୍‌ ?” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ନାଜରିତ୍‌ ଜିସୁକେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ ଜେ ସେ ଲକ୍‌, ଇରି ତ ମୁୟ୍‌ ତୁମିମଃନ୍‌କେ କୟ୍‌ଲେ । ଇତାର୍‌ ଗିନେ ଜଦି ତୁମିମଃନ୍ ମକ୍‌ ଲଳୁଲାସ୍‌, ତଃବେ ମର୍‌ ଏମଃନ୍‌କେ ଜଃଉଁକେ ଚାଡି ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଜିସୁ ଇରି କୟ୍‌ଲା, ଜଃନ୍‌କଃରି ସେ କୟ୍‌ଲା ଇ ବଃଚନ୍ ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, “ତୁୟ୍‌ ମକ୍‌ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ଦଃୟ୍‌ ଆଚ୍‌ସି, ସେମଃନାର୍‌ ବିତ୍ରେ ମୁୟ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ହେଁ ଆରାୟ୍‌ ନଃକେରି ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମନ୍ ପିତର୍‌ ଲଃଗେ ଗଟେକ୍‌ କଃଣ୍ଡା ରିଲାକ୍‌ ସେ ସେରି ବାର କଃରି ମୁଳ୍‌ ଜାଜକାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାକ୍‌ ମାର୍ଲା ଆର୍‌ ତାର୍‌ କାତା ବାଟାର୍‌ କାନ୍‌ କାଟ୍‌ଲା; ସେ ଦଃଙ୍ଗ୍‌ଳାର୍‌ ନାଉଁ ମାଲ୍‌କ । ");
INSERT INTO bdv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ସେତାକ୍‌ ଜିସୁ ପିତର୍‌କେ କୟ୍‌ଲା, “ତର୍‌ କଃଣ୍ଡାକ୍‌ କାପ୍ ବିତ୍ରେ ସଃଙ୍ଗାଉ; ଉବା ମକ୍‌ ଜୁୟ୍‌ ଦୁକ୍‌ କଃସ୍ଟାର୍‌ କପା ଦଃୟ୍‌ ଆଚେ, ମୁୟ୍‌ କାୟ୍‌ ସେତିର୍‌ ନଃସୁରି ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଇତାର୍‌ ହଃଚେ ସଃଇନ୍ ଦଃଳ୍‌, ସଃଇନ୍ ଅଃଦିକାରି ଆରେକ୍‌ ଜିଉଦିମଃନାର୍‌ ଜାଗୁଆଳିମଃନ୍ ଜିସୁକେ ଦଃରି ବାନ୍ଦ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଆର୍‌ ତାକ୍‌ ବାନ୍ଦି ହଃର୍ତୁମ୍‌ ହାନାନର୍‌ ଲଃଗେ ନିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ, ସେ ବଃର୍ସାର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ କୟାପା ରିଲା ତାର୍‌ ସଃତ୍ରାସି । ");
INSERT INTO bdv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ସଃବୁ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଗଟ୍‌ ଲକ୍‌ ମଃର୍ତାର୍‌ ବଃଲ୍‌ କବୁର୍‌ ବଃଲି ଜିଉଦିମଃନ୍‌କେ ଜେ କୟ୍‌ରିଲା, ଇ ମାନାୟ୍‌ ସେ କୟାପା । ");
INSERT INTO bdv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମନ୍ ପିତର୍‌ ଆର୍‌ ଆରେକ୍‌ ଗଟେକ୍‌ ଚେଲା ଜିସୁର୍‌ ହଃଚେ ହଃଚେ ଜାତିରିଲାୟ୍‌ । ସେ ଚେଲା ମୁଳ୍‌ ଜାଜକାର୍‌ ଚିନାଜାଣା ଲକ୍‌ ରିଲା ତଃବେ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ମୁଳ୍‌ ଜାଜକାର୍‌ କୁଆଳେ ହୁର୍ଲା; ");
INSERT INTO bdv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ମଃତର୍‌ ପିତର୍‌ ହଃଦାର୍‌ କୁଆଳାର୍‌ ଦୁଆର୍‌ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା । ସଃଡେବଃଳ୍‌ ସେ ଜୁୟ୍‌ ବିନ୍ ଚେଲା ମୁଳ୍‌ ଜାଜକାର୍‌ ଚିନାଜାଣା ରିଲା, ସେ ହଃଦାୟ୍‌ ଜାୟ୍‌ ଦୁଆର୍‌ ଜାଗୁଆଳିକେ କୟ୍‌ ପିତର୍‌କେ ବିତ୍ରେ ଆଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ସେତାକ୍‌ ସେ ଦୁଆର୍‌ ଜାଗ୍‌ତା ଦଃଙ୍ଗ୍‌ଳି ପିତର୍‌କେ କୟ୍‌ଲି, “ତୁୟ୍‌ ହେଁ କାୟ୍‌ ଇ ଲକାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌ ନାୟ୍‌ ?” ପିତର୍‌ କୟ୍‌ଲା, “ନାୟ୍‌ ମୁୟ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ସିତାର୍‌ ଗିନେ ଗତିଦଃଙ୍ଗ୍‌ଳା ଆର୍‌ ଜାଗୁଆଳିମଃନ୍ ଜୟ୍‌ ଲାଗାୟ୍‌ ସେତି ଟିଆ ଅୟ୍‌ ଜୟ୍‌ ଚେକ୍‌ତି ରିଲାୟ୍‌; ପିତର୍‌ ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଟିଆ ଅୟ୍‌ ଜୟ୍‌ ଚେକ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ଇ ବିତ୍ରେ ମୁଳ୍‌ ଜାଜକ୍‌ ଜିସୁକେ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିସୟେ ଆର୍‌ ତାର୍‌ ସିକ୍ୟା ବିସୟେ ହଃଚାର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ ଜଃଗତେ ହୁଟାୟ୍‌ କଃରି କଃତା କୟ୍‌ଆଚି, ଜୁୟ୍‌ ଲଃଗେ ସଃବୁ ଜିଉଦି ଲକ୍‌ମଃନ୍ ଗଟେତଃୟ୍‌ଁ ରୁଣ୍ଡ୍‌ତି, ଇବାନ୍ୟା ପାର୍ତ୍‌ନା ଗଃରେ ଆର୍‌ ମନ୍ଦିରେ ମୁୟ୍‌ ସଃବୁ ବଃଳ୍‌ ସିକ୍ୟା ଦଃୟ୍‌ଆଚି; ମୁୟ୍‌ ଲୁକ୍‌ଣେ କାୟ୍‌ରି ହେଁ ନଃକୟ୍‌ଁ । ");
INSERT INTO bdv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ମକ୍‌ କାୟ୍‌ତାକ୍‌ ଗଃଉଆରି କଃରୁଲିସ୍‌ ? ମୁୟ୍‌ ସେମଃନ୍‌କେ କାୟ୍‌ରି କୟ୍‌ଆଚି, ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସୁଣି ଆଚ୍‌ତି, ସେମଃନ୍‌କେ ହଃଚାର୍‌; ଦଃକ୍‌, ମୁୟ୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି କୟ୍‌ଆଚି, ସେମଃନ୍ ସେସଃବୁ ଜାଣି ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଇରି କୟ୍‌ଲାକ୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ବିତ୍ରେ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲା ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ଚାହୁଳ୍‌ ମାରି କୟ୍‌ଲା, “ତୁୟ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌କେ ଇବାନ୍ୟା ଉତୁର୍‌ ଦେଉଁକ୍‌ କଃନ୍‌କଃରି ସାସ୍‌ କଃଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ଜଦି ମୁୟ୍‌ କଃରାବ୍‌ କୟ୍‌ଲେ, ତଃବେ କଃରାବ୍‌ କୟ୍‌ଲାର୍‌ ସଃବାର୍‌ ମୁୟେ ସାକି ଦେସ୍‌; ମଃତର୍‌ ଜଦି ମୁୟ୍‌ ବଃଲ୍‌ କୟ୍‌ଲେ, ତଃବେ କାୟ୍‌ତାକ୍‌ ମକ୍‌ ମାରୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ସେତାକ୍‌ ହାନାନ୍ ଜିସୁକେ ବାନ୍ଦ୍‌ଲା ସଃଙ୍ଗ୍ ମୁଳ୍‌ ଜାଜକ୍‌ କୟାପାର୍‌ ଲଃଗେ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ଇ ବିତ୍ରେ ସିମନ୍ ପିତର୍‌ ଟିଆ ଅୟ୍‌ ଜୟ୍‌ ଚେକ୍‌ତି ରିଲା । ସେତାକ୍‌ ସେତି ରିଲା ବିନ୍ ଲକ୍‌ମଃନ୍ ତାକ୍‌ ହଃଚାର୍ଲାୟ୍‌, “ତୁୟ୍‌ ହେଁ କାୟ୍‌ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌ ନାୟ୍‌ ?” ମଃତର୍‌ ପିତର୍‌ ନଃମାନିକଃରି କୟ୍‌ଲା, “ନାୟ୍‌ ମୁୟ୍‌ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ମୁଳ୍‌ ଜାଜକାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ଲକ୍‌, ବଃଲେକ୍‌ ପିତର୍‌ ଜାର୍‌ କାନ୍‌ କାଟିରିଲା, ତାର୍‌ ଗଟେକ୍‌ ନିଜାର୍‌ ଲକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ କାୟ୍‌ ତକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଗେତ୍‌ସିମନି ବାଳେ ଦଃକିନଃରିଲେ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ସେତାକ୍‌ ପିତର୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ନଃମାନିକଃରି କୟ୍‌ଲା, “ନାୟ୍‌ ମୁୟ୍‌ ନାୟ୍‌ ।” ଆର୍‌ ସେଦାହ୍ରେ ଗାଞ୍ଜା କୁକ୍‌ଳା ବାସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ତାର୍‌ ଆର୍‌କ ଦିନ୍ ବର୍‌ ସଃକାଳ୍ୟା ଜିସୁକେ କୟାପା ତଃୟ୍‌ହୁଣି ପିଲାତ ରଃଜାର୍‌ କୁଆଳ୍‌ ବିତ୍ରେ ନିଲାୟ୍‌ । ଜିଉଦି ଅଃଦିକାରିମଃନ୍‌ ଜଃନ୍‌କଃରି ବିଟାଳ୍‌ ନଃୟ୍‌କଃରି ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ବଜି କାଉଁକେ ହାର୍ତି, ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ନଃଉର୍‌ ବିତ୍ରେ ହୁରୁ ନଃଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ସେତାକ୍‌ ପିଲାତ ସେମଃନାର୍‌ ଲଃଗେ ବାରାୟ୍‌ ଆସି ହଃଚାର୍ଲା, “ଇ ଲକ୍‌ ବିରଦେ ତୁମିମଃନ୍ କାୟ୍‌ ଦଃସାର୍‌ କଃତା ଆଣୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ସେମଃନ୍ ତାକ୍‌ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ଇ ଲକ୍‌ ଜଦି ଦଃସ୍‌ କଃରି ନଃରିଲେକ୍‌, ଅଃମିମଃନ୍‌ ତାକ୍‌ ତର୍‌ ଆତେ ସଃହ୍ରି ନଃଦିଲୁ ହୁଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ସେତାକ୍‌ ପିଲାତ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଇ ଲକ୍‌କେ ଦଃରିଜାୟ୍‌ ତୁମିମଃନାର୍‌ ବିଦି ହଃର୍କାରେ ଇତାର୍‌ ବିଚାର୍‌ କଃରା ।” ଜିଉଦିମଃନ୍‌ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “କାକେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ଦେତାର୍‌ ଅଃମିମଃନାର୍‌ ଅଃଦିକାର୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜିସୁ କୁୟ୍‌ ରଃକମାର୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ବଗୁକ୍‌ ଜଃଉଁଲା, ଇ ବିସୟେ ଜିସୁ ଜାୟ୍‌ରି କୟ୍‌ରିଲା, ସେରି ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ଇରି କୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ତଃବେ ପିଲାତ କୁଆଳ୍‌ ବିତ୍ରେ ବାଉଳି ଜାୟ୍‌, ଜିସୁକେ କୁଦି ହଃଚାର୍ଲା, “ତୁୟ୍‌ କାୟ୍‌ ଜିଉଦିମଃନାର୍‌ ରଃଜା ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ଦିଲା, “ତୁୟ୍‌ କାୟ୍‌ ନିଜାର୍‌ ଇରି କଃଉଁଲିସ୍‌, କି ବିନ୍ ଲକ୍‌ମଃନ୍ ମର୍‌ ବିସୟେ ତକ୍‌ ଇରି କୟ୍‌ ଆଚ୍‌ତି ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ ଉତୁର୍‌ ଦିଲା, “ମୁୟ୍‌ କାୟ୍‌ ଗଟେକ୍‌ ଜିଉଦି ? ତର୍‌ ନିଜାର୍‌ ଲକ୍‌ ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ତକ୍‌ ମର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ ଆଚ୍‌ତି; ତୁୟ୍‌ କାୟ୍‌ କଃରି ଆଚ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ମର୍‌ ରାଇଜ୍‌ ଇ ଜଃଗତାର୍‌ ବିସୟେ ନାୟ୍‌, ଜଦି ମର୍‌ ରାଇଜ୍‌ ଜଃଗତାର୍‌ ବିସୟେ ଅୟ୍‌ରିଲେକ୍‌, ତଃବେ ମୁୟ୍‌ ଜିଉଦି ଅଃଦିକାରିମଃନାର୍‌ ଆତେ ସଃହ୍ରି ନୟ୍‌ଲେ ହୁଣି, ସେତାର୍‌ ଗିନେ ମର୍‌ ଜାଗୁଆଳି ଲକ୍‌ମଃନ୍ ଜୁଜ୍‌ କଃଲାୟ୍‌ ହୁଣି; ମଃତର୍‌ ମର୍‌ ରାଇଜ୍‌ ସଃତ୍‌କଃରି ସେ ବିସୟେ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ସେତାକ୍‌ ପିଲାତ ଜିସୁକେ ହଃଚାର୍ଲା, “ତଃବେ ତୁୟ୍‌ କାୟ୍‌ ଗଟେକ୍‌ ରଃଜା ?” ଜିସୁ ଉତୁର୍‌ ଦିଲା, “ତୁୟ୍‌ ତ କଃଉଁଲିସ୍‌, ମୁୟ୍‌ ଗଟେକ୍‌ ରଃଜା । ମୁୟ୍‌ ଜଃନ୍‌କଃରି ସଃତ୍‌ ବାଟ୍ୟା ଅୟ୍‌ ସାକି ଦଃୟ୍‌ନ୍ଦ୍, ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ ଜଃଲମ୍‌ ଅୟ୍‌ ଆଚି ଆର୍‌ ଜଃଗତେ ଆସିଆଚି । ଜୁୟ୍‌ ଲକ୍‌ ସଃତାର୍‌ ହୟ୍‌ସି, ସେ ମର୍‌ କଃତା ସୁଣେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ ଜିସୁକେ କୟ୍‌ଲା, “ସଃତ୍‌ କାୟ୍‌ରି ?” ତାର୍‌ହଃଚେ ପିଲାତ ଆରେକ୍‌ ଜିଉଦିମଃନାର୍‌ ଲଃଗେ ହଃଦାୟ୍‌ ଜାୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ଇତାର୍‌ ଲଃଗେ କାୟ୍‌ ହେଁ ଦଃସ୍‌ ନଃହାଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ମଃତର୍‌ ମୁୟ୍‌ ଜେ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ଦିନ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ମୁକ୍ଳାୟ୍‌ ଦଃୟ୍‌ନ୍ଦ୍, ଇରି ତୁମିମଃନାର୍‌ ରିତିବିଦି ଆଚେ; ବଃଲେକ୍‌ ଜିଉଦିମଃନାର୍‌ ରଃଜାକ୍‌ ମୁୟ୍‌ ତୁମାର୍‌ ଗିନେ ମୁକ୍ଳାୟ୍‌ନ୍ଦ୍ ବଃଲି କାୟ୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍ ?” ");
INSERT INTO bdv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ସେତାକ୍‌ ସେମଃନ୍ ଆରେକ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ନାୟ୍‌, ଇ ଲକ୍‌କେ ନାୟ୍‌, ମଃତର୍‌ ବାରବାକେ ମୁକ୍ଳାଉ ।” ଇ ବାରବା ଗଟେକ୍‌ ଚର୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ତାର୍‌ହଃଚେ ପିଲାତ ଜିସୁକେ ନଃୟ୍‌କଃରି କର୍ଡା ମାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ଆରେକ୍‌ ସଃଇନ୍‌ମଃନ୍ କାଟାର୍‌ ମୁକୁଟ୍‌ ତିଆର୍‌ କଃରି ଜିସୁକେ ମୁଣ୍ଡେ ହିନ୍ଦାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାକ୍‌ ଆଙ୍ଗି ହିନ୍ଦାୟ୍‌ଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ଲଃଗେ ଆସି କୟ୍‌ଲାୟ୍‌, “ଏ ଜିଉଦିମଃନାର୍‌ ରଃଜା ଜୁଆର୍‌;” ଆରେକ୍‌ ସେମଃନ୍ ତାକ୍‌ ଚାହୁଳ୍‌ ମାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ହଃଦାୟ୍‌ ବାରାୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା, ମୁୟ୍‌ ତାକ୍‌ ତୁମିମଃନାର୍‌ ଲଃଗେ ବାର କଃରି ଆଣୁଲେ । ଇରି ତୁମିମଃନ୍ ନିଜେ ଜାଣାସ୍‌ ଜେ, ତାକ୍‌ ଦସି କଃରୁକେ ମୁୟ୍‌ ତାର୍‌ ଲଃଗେ କାୟ୍‌ ହେଁ ଦଃସ୍‌ ନଃହାଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ସେତାକ୍‌ ଜିସୁ ସେ ବେଜା ରଃଙ୍ଗାର୍‌ ଆଙ୍ଗି ଆର୍‌ କାଟାର୍‌ ମୁକୁଟ୍‌ ହିନ୍ଦି ହଃଦାୟ୍‌ ଆୟ୍‌ଲା । ପିଲାତ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା, ଇରି ସେ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ସେତାକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ମନ୍ଦିର୍‌ ଜାଗୁଆଳିମଃନ୍ ଜିସୁକେ ଦଃକି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ, କ୍ରୁସେ ଚଃଗାଉଆ ।” ପିଲାତ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ତାକ୍‌ ନଃୟ୍‌ କ୍ରୁସେ ଚଃଗାଉଆ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ଦେଉଁକ୍‌ ତାର୍‌ ଲଃଗେ କାୟ୍‌ ହେଁ ଦଃସ୍‌ ନଃହାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜିଉଦିମଃନ୍ ତାକ୍‌ ଉତୁର୍‌ ଦିଲାୟ୍‌, “ଅଃମିମଃନାର୍‌ ଗଟେକ୍‌ ବିଦି ଆଚେ ଆର୍‌ ସେ ବିଦି ହଃର୍କାରେ ସେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ବାୟ୍‌ଦ୍‌ରେ ହାଉତା ଜୟ୍‌ଗ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ନିଜ୍‌କେ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ବଃଲି କଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ସେତାକ୍‌ ପିଲାତ ଇ କଃତା ସୁଣି ଅଃଦିକ୍‌ ଡିରି ଗଃଲା; ");
INSERT INTO bdv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ଆରେକ୍‌, ସେ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ କୁଆଳ୍‌ ବିତ୍ରେ ବାଉଳି ଜାୟ୍‌ ଜିସୁକେ ହଃଚାର୍ଲା, “ତୁୟ୍‌ କୁୟ୍‌ତିହୁଣି ଆସି ଆଚ୍‌ସି ?” ମଃତର୍‌ ଜିସୁ ତାକ୍‌ ଉତୁର୍‌ ନଃଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ସେତାକ୍‌ ପିଲାତ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ସଃଙ୍ଗ୍ କଃତା ନଃଉସି ? ତୁୟ୍‌ ଜାଣ୍, ତକ୍‌ ମୁକ୍‌ଳାଉଁକେ ମର୍‌ ଅଃଦିକାର୍‌ ଆଚେ ଆର୍‌ ତକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଁକ୍‌ ହେଁ ମର୍‌ ଅଃଦିକାର୍‌ ଆଚେ, ଇରି କାୟ୍‌ ତୁୟ୍‌ ନଃଜାଣ୍‌ସି ?” ");
INSERT INTO bdv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ କୟ୍‌ଲା, “ଜଦି ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ତକ୍‌ ଅଃଦିକାର୍‌ ଦିଆଅୟ୍‌ ନଃରିଲେକ୍‌, ସେବାନ୍ୟା ଅୟ୍‌ଲେକ୍‌ ମର୍‌ ବିରଦେ ତର୍‌ କାୟ୍‌ରି ହେଁ ଅଃଦିକାର୍‌ ନଃରିଲିହୁଣି; ତଃବେ ଜେ ମକ୍‌ ତର୍‌ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଆଚେ, ତାର୍‌ ହାହ୍‌ ଅଃନାୟ୍‌ ବଃଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ସେତାକ୍‌ ପିଲାତ ତାକ୍‌ ମୁକ୍‌ଳାଉଁକେ ଚେସ୍ଟା କଃଲା, ମଃତର୍‌ ଜିଉଦିମଃନ୍ ଆଉଲି ଅୟ୍‌କଃରି କୟ୍‌ଲାୟ୍‌, “ଜଦି ତୁୟ୍‌ ଇ ଲକ୍‌କେ ମୁକ୍ଳାଉସି, ତଃବେ ତୁୟ୍‌ କାଇସର୍‌ ସଃଙ୍ଗ୍ ନାୟ୍‌; ଜୁୟ୍‌ ଲକ୍‌ ଅଃହ୍‌ଣାକ୍‌ ରଃଜା ବଃଲି କୟ୍‌ଦ୍‌, ସେ କାୟ୍‌ସରାର୍‌ ବିରଦେ କଃତା କୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ତଃବେ, ପିଲାତ ଇ ସଃବୁ କଃତା ସୁଣି ଜିସୁକେ ବାର୍‌କଃରି ଆଣି ଟେଳା ବାଦ୍‌ହୁର୍‌, ଜାକେ ଏବ୍ରି ବାସାୟ୍‌ “ଗବ୍‌ବତା” ବଃଲି କଃଉତି, ସେ ବିଚାର୍‌ କଃର୍ତା ଟାଣେ ବଃସ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ସେ ଦିନ୍ ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ତିଆର୍‌ ଅଃଉତା ଦିନ୍ ରିଲି, ଆର୍‌ ସଃଡେବଃଳ୍‌ ସଃକାଳ୍‌ ଚଅ ଗଃଟା ଅୟ୍‌ରିଲି । ଆରେକ୍‌, ପିଲାତ ଜିଉଦିମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା, ତୁମିମଃନାର୍‌ ରଃଜା ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ସେତାକ୍‌ ସେମଃନ୍ ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ତାକ୍‌ ମଃର୍ନେ ମାରା, ମଃର୍ନେ ମାରା, କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାଉଆ ।” ପିଲାତ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ କାୟ୍‌ ତୁମିମଃନାର୍‌ ରଃଜାକ୍‌ କ୍ରୁସେ ଚଃଗାୟ୍‌ନ୍ଦ୍ ?” ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ କୟ୍‌ଲା, “କାଇସର୍‌କେ ଚାଡି ଅଃମାର୍‌ ଆରେକ୍‌ କେ ରଃଜା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ସେତାକ୍‌ ଜିସୁକେ ଜଃନ୍‌କଃରି କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗା ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ, ପିଲାତ ତାକ୍‌ ସେମଃନାର୍‌ ଇଚା ହଃର୍କାରେ ସଃହ୍ରି ଦିଲା, ତଃବେ ସେମଃନ୍ ଜିସୁକେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ହଃଚେ ସେମଃନ୍ ଜିସୁକେ ଦଃରି ଗଃଲାୟ୍‌, ଆର୍‌ ଜିସୁ ନିଜେ କ୍ରୁସ୍‌ ବୟ୍‌ କଃହାଳ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଟାଣେ ବାରାୟ୍‌ ଗଃଲା । ଜାକେ ଏବ୍ରି ବାସାୟ୍‌ ଗଲ୍‌ଗତା ବଃଲି କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ସେତି ସେମଃନ୍ ତାକ୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ ଦୁୟ୍‌ ଲକ୍‌କେ ଚଃଗାୟ୍‌ଲାୟ୍‌, ଦୁୟ୍‌ ହାକ୍‌ ଦୁୟ୍‌ ଲକ୍‌କେ ଆର୍‌ ମଃଜାୟ୍‌ ଜିସୁକେ । ");
INSERT INTO bdv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଆର୍‌ ପିଲାତ ଗଟେକ୍‌ ଲେକା ଲେକି କଃରି ଜିସୁର୍‌ କ୍ରୁସ୍‌ ଉହ୍ରେ ଲାଗାୟ୍‌ଲା । ସେତି ଲେକା ଅୟ୍‌ରିଲି, “ନାଜରିତ୍‌ ଜିସୁ, ଜିଉଦିମଃନାର୍‌ ରଃଜା ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଇ ଲେକା ହଳ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଟାଣେ ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗା ଅୟ୍‌ରିଲି, ସେରି ଗଃଳାର୍‌ ଲଃଗେ ରିଲି; ଆରେକ୍‌ ସେ ଲେକା ଏବ୍ରି, ଲାଟିନ୍ ଆର୍‌ ଗ୍ରିକ୍‌ ବାସାୟ୍‌ ଲେକା ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ତଃବେ ଜିଉଦିମଃନାର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ପିଲାତକେ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ ‘ଜିଉଦିମଃନାର୍‌ ରଃଜା’ ବଃଲି ନଃଲେକି, ‘ମୁୟ୍‌ ଜିଉଦିମଃନାର୍‌ ରଃଜା ବଃଲି ନିଜ୍‌କେ କଃଉତିରିଲା,’ ଇବାନ୍ୟା ଲେକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତ କୟ୍‌ଲା, “ମୁୟ୍‌ ଜାୟ୍‌ରି ଲେକିଆଚି, ସେରି ଲେକିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ସଃଇନ୍‌ମଃନ୍ ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗାୟ୍‌ଲା ହଃଚେ ଚାରି ଗଟ୍‌ ସଃଇନ୍ ତାର୍‌ ବଃସ୍ତର୍‌ ଚାରି ବାଗ୍ କଃରି ବାଟାକଃରି ନିଲାୟ୍‌, ହଃତି ସଃଇନ୍‌ମଃନାର୍‌ ଗିନେ ଗଟେକ୍‌ ଗଟେକ୍‌ ବାଗ୍, ଆର୍‌ ସେମଃନ୍ ତାର୍‌ ଆଙ୍ଗିକ୍‌ ହେଁ ନିଲାୟ୍‌ । ମଃତର୍‌ ତାର୍‌ ଉହ୍ରେ ହିନ୍ଦ୍‌ଲା ଆଙ୍ଗି ସିଲାୟ୍‌ ନାୟ୍‌ ଉହ୍ରେ ହୁଣି ତଃଳେ ହଃତେକ୍‌ ସଃବୁ ବୁଣା ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ତଃବେ ସଃଇନ୍‌ମଃନ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରେ କଃଉଆକଇ ଅୟ୍‌ଲାୟ୍‌, “ଇତାକ୍‌ ଚିରୁ ନଃଚୁଆଁ, ମଃତର୍‌ ଇରି କାର୍‌ ଅୟ୍‌ଦ୍‌, ସେତାର୍‌ ଗିନେ କେଳି ବାଚୁଆଁ ।” ଜଃନ୍‌କଃରି ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଇ ବଃଚନ୍ ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, “ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିତ୍ରେ ମର୍‌ ବଃସ୍ତର୍‌ ବାଟା କଃଲାୟ୍‌, ଆରେକ୍‌ ମର୍‌ ଆଙ୍ଗିର୍‌ ଗିନେ କେଳି ବାଚ୍‌ଲାୟ୍‌ ।” ତଃବେ ସଃଇନ୍‌ମଃନ୍ ଇସଃବୁ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ମଃତର୍‌ ଜିସୁ କ୍ରୁସ୍‌ ଲଃଗେ ତାର୍‌ ଆୟ୍‌ସି, ତାର୍‌ ଆୟ୍‌ସିର୍‌ ବେଣ୍‌ସି, କ୍ଲପାର୍‌ ଡକୁର୍ସି ମରିୟମ୍‌ ଆର୍‌ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଟିଆ ଅୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ତାର୍‌ ଆୟ୍‌ସି ଆର୍‌ ଜୁୟ୍‌ ଚେଲାମଃନ୍‌କେ ଲାଡ୍‌ କଃର୍ତିରିଲା, ସେମଃନ୍‌କେ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକି ଆୟ୍‌ସିକ୍‌ କୟ୍‌ଲା, “ଏ ଆୟା, ଦଃକ୍‌, ତର୍‌ ହୟ୍‌ଦି ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ସେଦାହ୍ରେ ସେ ଚେଲାକେ କୟ୍‌ଲା, “ଦଃକା, ତର୍‌ ଆୟ୍‌ଦି !” ଆର୍‌ ସେଦାହ୍ରେ ହୁଣି ସେ ଚେଲା ଜିସୁର୍‌ ଆୟ୍‌ସିକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ନିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଇତାର୍‌ ହଃଚେ ଜିସୁ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ବଃଚନ୍ ଜଃନ୍‌କଃରି ହୁରୁଣ୍ ଅୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ସଃବୁ ବିସୟ୍‌ ଅଃବେ ସଃରିଆଚେ ବଃଲି ଜାଣି କୟ୍‌ଲା, “ମକ୍‌ ସସ୍‌ ଲାଗୁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ସେତି ହିତା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ବଃର୍ତି ଅୟ୍‌ରିଲା ଗଟେକ୍‌ ଡକା ରିଲି; ତଃବେ ସେମଃନ୍ ସେତି କଃଣ୍ଡେକ୍‌ ସ୍ପଞ୍ଜ୍ ବୁଡାୟ୍‌ ସେରି ହାଟ୍‌ଳି ସଃଙ୍ଗ୍ ଗଟେକ୍‌ ଡେଙ୍ଗ୍ ଡାଙ୍ଗେ ଗୁଳିଆୟ୍‌ ତାର୍‌ ଟଣ୍ଡ୍ ଲଃଗେ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ସେତାକ୍‌ ଜିସୁ ସେ ହିତା ଅଙ୍ଗୁର୍‌ ରଃସ୍‌ ସୁରି କୟ୍‌ଲା, “ସେସ୍‌ ଅୟ୍‌ଲି ।” ଆର୍‌ ସେ ମୁଣ୍ଡ୍ ଲଃସାୟ୍‌ କଃରି ଆତ୍ମା ଚାଡ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ସେ ଦିନ୍ ହଃର୍ବାର୍‌ ଗିନେ ତିଆର୍‌ ହଃଳ୍‌ତା ଦିନ୍ ରିଲାକ୍‌, ଗଃଗାଳ୍‌ମଃନ୍‌ ଜଃନ୍‌କଃରି ବିସାଉଁଣି ବାରେ କ୍ରୁସ୍‌ ଉହ୍ରେ ନଃରେୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ରିଲି, ସେତାକ୍‌ ସେମଃନାର୍‌ ଗଡ୍ ବାଙ୍ଗା ଜଃଉଅ ଆର୍‌ ସେମଃନ୍‌କେ କ୍ରୁସ୍‌ କାଟେ ହୁଣି ଉତ୍ରାୟ୍‌ ଆଣୁକେ ଜିଉଦି ଅଃଦିକାରିମଃନ୍‌ ପିଲାତକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ତଃବେ ସଃଇନ୍‌ମଃନ୍ ଜାୟ୍‌ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସ୍‌କାଟେ ଚଃଗା ଅୟ୍‌ରିଲା ବିନ୍ ଦୁୟ୍‌ ଲକାର୍‌ ଗଡ୍ ବାଙ୍ଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମଃତର୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ଲଃଗେ ଆସି ସେ ମଃରି ଗଃଲାବେ ବଃଲି ଦଃକି ତାର୍‌ ଗଡ୍ ବାଙ୍ଗାଉଁ ନଃଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ତଃବେ ସଃଇନ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟ୍‌ ଲକ୍‌ ବାଲା ସଃଙ୍ଗ୍ ଜିସୁର୍‌ କୁଚାୟ୍‌ ବୁସ୍‌ଲା, ଆର୍‌ ସେଦାହ୍ରେ ବଃନି ଆର୍‌ ହାଣି ବାରାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଜେ ଦଃକି ଆଚେ, ସେ ସାକି ଦଃୟ୍‌ଆଚେ, ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ହେଁ ବିସ୍ୱାସ୍‌ କଃରାସ୍‌; ଆରେକ୍‌ ତାର୍‌ ସାକି ସଃତ୍ୟା, ଆର୍‌ ସେ ଜେ ସଃତ୍‌ କଃଉଁଲା, ଇରି ସେ ଜାଣେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଇ ବଃଚନ୍ ହୁରୁଣ୍ ଅଃଉଁକେ ଇସଃବୁ ବିସୟ୍‌ ଗଃଟ୍‌ଲି, “ତାର୍‌ କଃଣ୍ଡେକ୍‌ ଆଡ୍ ହେଁ ନଃବାଙ୍ଗେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ ଆରେକ୍‌ ଗଟେକ୍‌ ବଃଚନ୍ ଲେକା ଅୟ୍‌ଆଚେ, “ସେମଃନ୍ ଜାକେ ବାଲା ସଃଙ୍ଗ୍ ବୁସ୍‌ଲାୟ୍‌, ତାକ୍‌ ଦଃକ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଇ ସଃବୁ ଗଃଟ୍‌ଲା ହଃଚେ, ଜୁୟ୍‌ ହାରାମାତିଆର୍‌ ଜସେପ୍ ଜିସୁର୍‌ ଗଟେକ୍‌ ଚେଲା ରିଲା, ମଃତର୍‌ ଜିଉଦି ଅଃଦିକାରିମଃନ୍‌କେ ଡିରିକଃରି ଜାଣାୟ୍‌ ନଃଉତିରିଲା, ସେ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ନେଉଁକ୍‌ ପିଲାତକେ ଗଃଉଆରି କଃଲା । ସେତାକ୍‌ ପିଲାତ ନେ ବଃଲି କୟ୍‌ଲା । ତଃବେ ସେ ଆସି ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ନିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଜୁୟ୍‌ ନିକଦିମ ହଃର୍ତୁମ୍‌ ରାତି ବଃଳ୍ୟା ଜିସୁର୍‌ ଲଃଗେ ଆସିରିଲା, ସେ ହେଁ ହଃକାହାକି ପଚାସ୍‌ ସେର୍‌ ବାସ୍ନା ଚିକଣ୍‌ ମିସ୍‌ଲା ଦୁହ୍‌ଣି ଦଃରି ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ସେମଃନ୍ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ନଃୟ୍‌ ଜିଉଦିମଃନାର୍‌ ମଃସ୍‌ଣେ ତହ୍‌ତା ରିତି ହଃର୍କାରେ ସେରି ବାସ୍ନା ଚିକଣ୍‌ ହାଦ୍‌ଳାୟ୍‌ ତାକ୍‌ ଦବ୍‌ ମଃସ୍‌ଣି ହଃଚ୍ୟା ଗୁଳ୍ୟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜୁୟ୍‌ ଟାଣେ ଜିସୁକେ କ୍ରୁସ୍‌ ଉହ୍ରେ ଚଃଗା ହାୟ୍‌ରିଲି, ସେ ଟାଣେ ଗଟେକ୍‌ ବାଳ୍‌ ରିଲି, ଆର୍‌ ସେ ବାଳେ ଗଟେକ୍‌ ନଃଉଆଁ ମଃସୁଣ୍‌ ରିଲି, ସେତି କଃବେ କାକେ ହେଁ ସଃଙ୍ଗାୟ୍‌ ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଆର୍‌ ଜିଉଦିମଃନାର୍‌ ତିଆର୍‌ ହଃଳ୍‌ତା ଦିନ୍ ରିଲାକ୍‌ ସେ ଟାଣେ ସେମଃନ୍ ଜିସୁକେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ମଃସୁଣ୍‌ ଲଃଗେ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ରୟ୍‌ବାର୍‌ ଦିନ୍ ବର୍‌ ସଃକାଳ୍ୟା ଅଃନ୍ଦାର୍‌ ରେଉଁ ରେଉଁ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ମଃସୁଣ୍‌ ଲଃଗେ ଜାୟ୍‌ ସେଲଃଗେ ଡାହିରିଲା ଟେଳା ଗୁଚିରିଲାର୍‌ ଦଃକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ତଃବେ ସେ ଦଃବ୍‌ଳି ଜାୟ୍‌ ସିମନ୍ ପିତର୍‌ ଆର୍‌ ଜିସୁ ଜାକେ ଲାଡ୍‌ କଃର୍ତିରିଲା, ସେ ବିନ୍ ଚେଲାର୍‌ ଲଃଗେ ଆୟ୍‌ଲି, ଆର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲି, “ସେମଃନ୍ ମାପ୍ରୁକ୍‌ ମଃସୁଣ୍‌ କାଲେ ହୁଣି ନଃୟ୍‌ ଗଃଲାୟ୍‌ ଆଚ୍‌ତି, ଆରେକ୍‌ ତାକ୍‌ କୁୟ୍‌ ଟାଣେ ସଃଙ୍ଗାୟ୍‌ ଆଚ୍‌ତି, ସେରି ଅଃମିମଃନ୍‌ ନଃଜାଣୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ସେତାକ୍‌ ପିତର୍‌ ଆର୍‌ ସେ ବିନ୍ ଚେଲା ମଃସୁଣ୍‌ ଲଃଗେ ଜଃଉଁକେ ବାରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ସେମଃନ୍ ଦୁୟ୍‌ଲକ୍‌ ଅଃକାବଃଳ୍‌ ଦଃବ୍‌ଳୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ସେ ବିନ୍ ଚେଲା ପିତର୍‌କେ ହଃଚେ ଚାଡି ଆଗ୍‌ତୁ ମଃସୁଣ୍‌ ଲଃଗେ ହଚ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଆର୍‌ ଲଃହ୍‌ଟିକଃରି ବିତ୍ରେ ଦଃକି ଜିସୁକେ ଜୁୟ୍‌ ମଃସ୍‌ଣି ହଃଚ୍ୟା ଗୁଳ୍ୟାୟ୍‌ ରିଲାୟ୍‌ ସେରି ସଃବୁ ଅଦ୍ରି ରିଲାର୍‌ ଦଃକ୍‌ଲା, ମଃତର୍‌ ସେ ବିତ୍ରେ ନଃହୁର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ହଃଚେ ସିମନ୍ ପିତର୍‌ ହେଁ ତାର୍‌ ହଃଚେ ହଃଚେ ଆସି ହଚ୍‌ଲା ଆର୍‌ ମଃସୁଣ୍‌ ବିତ୍ରେ ହୁରି ଦଃକ୍‌ଲା ଜେ, ସେ ମଃସ୍‌ଣି ହଃଚ୍ୟାମଃନ୍ ଅଦ୍ରିଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆରେକ୍‌ ତାର୍‌ ମୁଣ୍ଡେ ଜୁୟ୍‌ ତୁଆଲ୍‌ ବାନ୍ଦା ଅୟ୍‌ରିଲି, ସେରି ସେ ମଃସ୍‌ଣି ହଃଚ୍ୟା ସଃଙ୍ଗ୍ ନଃରେୟ୍‌ ବିନେ ଗଟେକ୍‌ ଜଃଗାୟ୍‌ ଗୁଳ୍ୟାୟ୍‌ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ସଃଡେବଃଳ୍‌ ଜୁୟ୍‌ ବିନ୍ ଚେଲା ଆଗ୍‌ତୁ ମଃସୁଣ୍‌ ଲଃଗେ ଆସିରିଲା, ସେ ହେଁ ବିତ୍ରେ ହୁରି ଦଃକ୍‌ଲା ଆର୍‌ ବିସ୍ୱାସ୍‌ କଃଲା; ");
INSERT INTO bdv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ମଃତର୍‌ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେହୁଣି ଜିସୁକେ ଜେ ଜିବନ୍ ହାୟ୍‌ ଉଟୁକ୍‌ ଅୟ୍‌ଦ୍‌, ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ର୍‌ ଇ ବଃଚନ୍ ସେମଃନ୍ ସଃଡେବଃଳ୍‌ ହଃତେକ୍‌ ବୁଜି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ତାର୍‌ହଃଚେ ଚେଲାମଃନ୍ ସେମଃନାର୍‌ ଗଃରେ ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମଃତର୍‌ ମରିୟମ୍‌ କାନ୍ଦି କାନ୍ଦି ହଃଦାୟ୍‌ ମଃସୁଣ୍ ଲଃଗେ ଟିଆ ଅୟ୍‌ରିଲି; ଆରେକ୍‌ କାନ୍ଦି କାନ୍ଦି ସେ ଲଃହ୍‌ଟିକଃରି ମଃସୁଣ୍‌ ବିତ୍ରେ ଦଃକ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଆର୍‌ ଜିସୁର୍‌ ଗଃଗାଳ୍‌ ଜୁୟ୍‌ ଜଃଗାୟ୍‌ ସଃଙ୍ଗା ଅୟ୍‌ରିଲି, ସେତିର୍‌ ମୁଣ୍ଡ୍ ଲଃଗେ ଗଟ୍‌ଲକ୍‌ ଆର୍‌ ହାଦ୍‌ ଲଃଗେ ଆରେକ୍‌ ଗଟ୍‌ଲକ୍‌, ଇବାନ୍ୟା ଦୁୟ୍‌ ଲକ୍‌ ଦବ୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦିରିଲା ଦୁତ୍‌କେ ବଃସି ରିଲାର୍‌ ଦଃକ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଏ ଆୟା, କାୟ୍‌ତାକ୍‌ କାନ୍ଦୁଲିସ୍‌ ?” ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲି, “କୁୟ୍‌ ଲକ୍‌ କି ମର୍‌ ମାପ୍ରୁକ୍‌ ନିଲାୟ୍‌ ଆଚ୍‌ତି, ଆର୍‌ ତାକ୍‌ କୁୟ୍‌ ଟାଣେ ସଃଙ୍ଗାୟ୍‌ ଆଚ୍‌ତି, ସେରି ମୁୟ୍‌ ନଃଜାଣି ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ସେ ଇରି କୟ୍‌ ହଃଚ୍‌ବାଟ୍ୟା ଲେଉଟିକଃରି ଜିସୁକେ ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକ୍‌ଲି, ମଃତର୍‌ ସେ ଜେ ଜିସୁ ସେରି ଜାଣୁ ନାହାର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ଏ ଆୟା, କାୟ୍‌ତାକ୍‌ କାନ୍ଦୁଲିସ୍‌ ? କାକେ ଲଳୁଲିସ୍‌ ?” ସେ ତାକ୍‌ ବାଳାର୍‌ ଜାଗୁଆଳି ବଃଲି ବାବି କୟ୍‌ଲି, “ମାପ୍ରୁ, ତୁୟ୍‌ ଜଦି ତାକ୍‌ ନଃୟ୍‌ ଆଚ୍‌ସି, ତଃବେ ତାକ୍‌ କୁୟ୍‌ ଟାଣେ ସଃଙ୍ଗାୟ୍‌ ଆଚ୍‌ସି, ମକ୍‌ କଃଉ, ଆର୍‌ ମୁୟ୍‌ ତାକ୍‌ ନଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମରିୟମ୍‌ ।” ସେ ଲେଉଟିକଃରି ଏବ୍ରି ବାସାୟ୍‌ କୟ୍‌ଲି, “ରାବ୍‌ବୁନି !” ବଃଲେକ୍‌, “ଏ ଗୁରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମକ୍‌ ଦଃରି ରିଆ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ ଅଃବେ ହଃତେକ୍‌ ଉବାର୍‌ ଲଃଗେ ନଃଜାୟ୍‌ଁତା; ମଃତର୍‌ ମର୍‌ ବାୟ୍‌ମଃନାର୍‌ ଲଃଗେ ଜାୟ୍‌ ସେମଃନ୍‌କେ କଃଉ, ମୁୟ୍‌ ମର୍‌ ଉବା ଆର୍‌ ସେମଃନାର୍‌ ଉବାସି, ମର୍‌ ଇସ୍ୱର୍‌ ଆର୍‌ ସେମଃନାର୍‌ ଇସ୍ୱରାର୍‌ ଲଃଗେ ଜଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଜାୟ୍‌, ମୁୟ୍‌ ମାପ୍ରୁକ୍‌ ଦଃକି ଆଚି, ଆର୍‌ ସେ ମକ୍‌ ଇସଃବୁ କୟ୍‌ଆଚେ ବଃଲି ଚେଲାମଃନ୍‌କେ କୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ସେଦିନ୍, ବଃଲେକ୍‌, ରୟ୍‌ବାର୍‌ ଦିନ୍ ସଃଞ୍ଜ୍‌ବେଳ୍ୟା ଜଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ଜୁୟ୍‌ ଗଃରେ ରିଲାୟ୍‌, ସେତିର୍‌ ଜିଉଦି ଅଃଦିକାରିମଃନ୍‌କେ ଡିରିକଃରି ଦୁଆର୍‌ ଡାହି ଅୟ୍‌ ରେତିରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଜିସୁ ଆସି ମଃଜି ଟାଣେ ଟିଆ ଅୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ସୁସ୍ତା ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଆରେକ୍‌, ଇରି କୟ୍‌ ସେ ସେମଃନ୍‌କେ ଅଃହ୍‌ଣାର୍‌ ଆତ୍‌ ଆର୍‌ କୁଚି ଦଃକାୟ୍‌ଲା । ସେତାକ୍‌ ଚେଲାମଃନ୍ ମାପ୍ରୁକ୍‌ ଦଃକି ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ସେମଃନ୍‌କେ ଆରେକ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ସୁସ୍ତା ଅଃଉଅ; ଉବା ଜଃନ୍‌କଃରି ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ, ମୁୟ୍‌ ହେଁ ସେବାନ୍ୟା ତୁମିମଃନ୍‌କେ ହଃଟାଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ସେ ଇରି କୟ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ହୁଣ୍ଡାଣ୍ ଚାଡି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ପବିତ୍ର ଆତ୍ମାକେ ହାଉଆ । ");
INSERT INTO bdv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ତୁମିମଃନ୍ ଜଦି କାର୍‌ ହାହ୍‌ କେମା କଃରାସ୍‌, ତାର୍‌ ହାହ୍‌ କେମା ଅୟ୍‌ଦ୍‌; ଆରେକ୍‌, ଜଦି କାର୍‌ ହାହ୍‌ କେମା ନଃକେରାସ୍‌, ତାର୍‌ ହାହ୍‌ କେମା ନୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ମଃତର୍‌ ଜିସୁ ଜଃଡେବଃଳ୍‌ ଆସିରିଲା, ସଃଡେବଃଳ୍‌ ବାର ଲକାର୍‌ ବିତ୍ରେ ତମା ନାଉଁଆର୍‌ ଗଟ୍‌ଲକ୍‌, ଜାକେ ଦିଦୁମ୍‌ ବଃଲି କଃଉତି, ସେ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ତଃବେ ବିନ୍ ଚେଲାମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ମାପ୍ରୁକ୍‌ ଦଃକି ଆଚୁ ।” ମଃତର୍‌ ତମା ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତାର୍‌ ଆତେ କୁଟି ମାର୍ଲା ଚିନ୍ ସଃବୁ ନଃଦେକ୍‌ଲେକ୍‌, ଆର୍‌ ସେ ସଃବୁ ଜଃଗା ଲଃଗେ ମର୍‌ ଆଙ୍ଗଟି ସଃଙ୍ଗ୍ ନଃଚୁୟ୍‌ଲେକ୍‌ ଆର୍‌ ତାର୍‌ କୁଚାୟ୍‌ ମର୍‌ ଆତ୍‌ ନଃଚୁୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ କଃବେ ହେଁ ବିସ୍ୱାସ୍‌ ନଃକେରି ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆଟ୍‌ ବିନ୍ ହଃଚେ ଜିସୁର୍‌ ଚେଲାମଃନ୍ ଆରେକ୍‌ ଗଃର୍‌ ବିତ୍ରେ ରିଲାୟ୍‌ ଆର୍‌ ତମା ହେଁ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ଆର୍‌ ଦୁଆର୍‌ ସଃବୁ ଡାହି ଅୟ୍‌ରିଲାବଃଳ୍‌ ଜିସୁ ଆସି ମଃଜାୟ୍‌ ଟିଆ ଅୟ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନାର୍‌ ସୁସ୍ତା ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ହଃଚେ ସେ ତମାକ୍‌ କୟ୍‌ଲା, “ଇହାକ୍‌ ତର୍‌ ଆଙ୍ଗଟି ଆଣି ମର୍‌ ଆତ୍‌ ଦଃକ୍‌ ଆର୍‌ ଆତ୍‌ ଲାମାୟ୍‌ ମର୍‌ କୁଚାୟ୍‌ ଚିଉ; ଅବିସ୍ୱାସି ନୟ୍‌କଃରି ସଃତ୍‌କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତମା ଜିସୁକେ କୟ୍‌ଲା, “ମର୍‌ ମାପ୍ରୁ, ମର୍‌ ଇସ୍ୱର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଦଃକ୍‌ଲାକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲିସ୍‌ ? ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ନଃଦେକି ବିସ୍ୱାସ୍‌ କଃରି ଆଚ୍‌ତି, ସେମଃନାର୍‌ ବାୟ୍‌ଗ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁ ଚେଲାମଃନାର୍‌ ମୁୟେ ଇବାନ୍ୟା ଗାଦେକ୍‌ ବିନ୍ ବିନ୍ ରଃକମାର୍‌ କାବା ଅଃଉତା ଚିନ୍ କଃଲା, ସେସଃବୁ ଇ ପୁସ୍ତକ୍‌ ଲଃଗେ ଲେକା ନୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମଃତର୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରାସ୍‌ ଜେ, ଜିସୁ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି କ୍ରିସ୍ଟ, ଆରେକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ତାର୍‌ ନାଉଁଏ ଜିବନ୍ ହାଉଆସ୍‌, ଇତାର୍‌ ଗିନେ ଇ ସଃବୁ ଲେକା ଜାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ଇତାର୍‌ ହଃଚେ ଜିସୁ ତିବିରିଆ ସଃମଃନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ଚେଲାମଃନ୍‌କେ ଆରେକ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ସେ ଇରଃକମ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ସିମନ୍ ପିତର୍‌, ତମା, ଜାକେ ଦିଦୁମ୍‌ ବଃଲି କଃଉତି, ଗାଲିଲିର୍‌ କାନା ଗାଉଁଆର୍‌ ନିତନିଏଲ୍‌, ଜେବଦିର୍‌ ହୟ୍‌ସିମଃନ୍ ଆର୍‌ ତାର୍‌ ଚେଲାମଃନାର୍‌ ବିତ୍ରେ ଦୁୟ୍‌ଲକ୍‌ ଗଟେତଃୟ୍‌ଁ ରୁଣ୍ଡି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମନ୍ ପିତର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ମୁୟ୍‌ ମାଚ୍ ଦଃରୁକ୍‌ ଜଃଉଁଲେ ।” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ଅଃମିମଃନ୍‌ ହେଁ ତର୍‌ ସଃଙ୍ଗ୍ ଜଃଉଁନ୍ଦ୍ ।” ସେମଃନ୍ ବାରାୟ୍‌ ଜାୟ୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ଲାୟ୍‌, ଆର୍‌ ସେ ରାତି କାୟ୍‌ରି ହେଁ ଦଃରୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ମଃତର୍‌ ସଃକାଳ୍‌ ଅୟ୍‌ଲା ହଃଚେ ଜିସୁ କଃଣ୍ଡାୟ୍‌ ଟିଆ ଅୟ୍‌ଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ଜିସୁ ବଃଲି ଚେଲାମଃନ୍ ଜାଣୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ହିଲାମଃନ୍ ତୁମାର୍‌ ଲଃଗେ କାୟ୍‌ରି ମାଚ୍ କାଉଁକେ ଆଚେ ?” ସେମଃନ୍ ତାକ୍‌ କୟ୍‌ଲାୟ୍‌, “ନାୟ୍‌, କାୟ୍‌ରି ହେଁ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଡଙ୍ଗାର୍‌ କାତା ବାଟ୍ୟା ଜାଲ୍‌ ହଃକାଉଆ, ଆର୍‌ ତୁମିମଃନ୍ ହାଉଆସ୍‌ ।” ସେତାକ୍‌ ସେମଃନ୍ ଜାଲ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଜାଲେ ଅଃତେକ୍‌ ମାଚ୍ ଲାଗ୍‌ଲାୟ୍‌ ଜେ, ସେମଃନ୍ ଜାଲ୍‌ ଜିକୁକ୍‌ ସଃକ୍ତି ନଃକେଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ସେତାକ୍‌ ଜିସୁ ଜୁୟ୍‌ ଚେଲାକେ ଲାଡ୍‌ କଃର୍ତିରିଲା, ସେ ଜହନ୍‌ ପିତର୍‌କେ କୟ୍‌ଲା, “ଏ ତ ମାପ୍ରୁ ।” ସିମନ୍ ପିତର୍‌ ଏ ତ ମାପ୍ରୁ ବଃଲି ସୁଣି ଡୁମ୍‌ଣ୍ଡା ଅୟ୍‌ରିଲାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆଙ୍ଗି ହିନ୍ଦି ସଃମ୍‌ନ୍ଦେ ଡଃଗାୟ୍‌ଲା; ");
INSERT INTO bdv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ମଃତର୍‌ ବିନ୍ ଚେଲାମଃନ୍ ମାଚ୍ ବଃର୍ତି ଅୟ୍‌ରିଲା ଜାଲ୍‌ ଜିକି ଜିକି ଡଙ୍ଗାକ୍‌ କଃଣ୍ଡିଏ ଆଣ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ କଃଣ୍ଡାୟ୍‌ ହୁଣି ଅଃଦିକ୍‌ ଦୁରିକ୍‌ ନଃରିଲାୟ୍‌, ଅଃକାୟ୍‌ ହଃକାହାକି ଦଃସ୍‌ କଳି ଆତ୍‌ ଦୁରିକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ସେମଃନ୍ କଃଣ୍ଡିଏ ଉତ୍ରି ସେତି ଇଙ୍ଗ୍ରାଜୟ୍‌ ଉହ୍ରେ ମାଚ୍ ଆର୍‌ ରୁଟି ସଃଙ୍ଗାୟ୍‌ ରିଲାର୍‌ ଦଃକଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଅଃବେ ଜୁୟ୍‌ ମାଚ୍ ଦଃରି ଆଚାସ୍‌, ସେତିର୍‌ କଃତିଗଟ୍‌ ଆଣା ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସିମନ୍ ପିତର୍‌ ଜାୟ୍‌ ସାତ୍‌କଳି ତେର ଗଟ୍‌ ବଃଡ୍ ବଃଡ୍ ମାଚ୍ ବଃର୍ତି ଅୟ୍‌ରିଲା ଜାଲ୍‌ କଃଣ୍ଡିଏ ଜିକି ଆଣ୍‌ଲା; ଆର୍‌ ଅଃତେକ୍‌ ମାଚ୍ ରିଲାକ୍‌ ହେଁ ଜାଲ୍‌ ନଃଚିଡ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ସେମଃନ୍‌କେ କୁଦିକଃରି କୟ୍‌ଲା, “ଆସି କାହା ।” ଚେଲାମଃନାର୍‌ ବିତ୍ରେ କେ ହେଁ ତୁୟ୍‌ କେ ବଃଲି ତାକ୍‌ ହଃଚାରୁକ୍‌ ସାସ୍‌ ନଃକେର୍ତି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ଜେ ମାପ୍ରୁ ଇରି ସେମଃନ୍ ଜାଣି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ଆସି ରୁଟି ନଃୟ୍‌ ସେମଃନ୍‌କେ ଦିଲା, ଆର୍‌ ସେବାନ୍ୟା ମାଚ୍ ହେଁ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ମଃଲା ଲକାର୍‌ ବିତ୍ରେ ଉଟ୍‌ଲା ହଃଚେ ଜିସୁ ଚେଲାମଃନ୍‌କେ ଆର୍‌ ସଃଙ୍ଗ୍ ତିନିତର୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ସେମଃନ୍ କାୟ୍‌ଲା ହଃଚେ ଜିସୁ ସିମନ୍ ପିତର୍‌କେ ହଃଚାର୍ଲା, “ଏ ଜହନାର୍‌ ହୟ୍‌ସି ସିମନ୍, ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଇମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକ୍‌ ଲାଡ୍‌ କଃରୁଲିସ୍‌ ?” ସେ ତାକ୍‌ କୟ୍‌ଲା, “ହେଁ ମାପ୍ରୁ, ମୁୟ୍‌ ଜେ ତକ୍‌ ଲାଡ୍‌ କଃରୁଲେ, ସେରି ତୁୟ୍‌ ଜାଣି ଆଚ୍‌ସି ।” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ମେଣ୍ଡା ହିଲାମଃନ୍‌କେ ଚଃରାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜିସୁ ଆରେକ୍‌ ଇତାର୍‌ ସଃଙ୍ଗ୍ ଦୁୟ୍‌ତର୍‌ ତାକ୍‌ ହଃଚାର୍ଲା, “ଏ ଜହନାର୍‌ ହୟ୍‌ସି ସିମନ୍, ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଲାଡ୍‌ କଃରୁଲିସ୍‌ ?” ସିମନ୍ ତାକ୍‌ କୟ୍‌ଲା, “ହେଁ ମାପ୍ରୁ, ମୁୟ୍‌ ଜେ ତକ୍‌ ଲାଡ୍‌ କଃରୁଲେ, ସେରି ତୁୟ୍‌ ଜାଣି ଆଚ୍‌ସି ।” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ମେଣ୍ଡାମଃନାର୍‌ ଜଃତୁନ୍ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ଇତାର୍‌ ସଃଙ୍ଗ୍ ତିନିତର୍‌ ତାକ୍‌ ହଃଚାର୍ଲା, “ଏ ଜହନାର୍‌ ହୟ୍‌ସି ସିମନ୍, ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଲାଡ୍‌ କଃରୁଲିସ୍‌ ?” ତୁୟ୍‌ କାୟ୍‌ ମକ୍‌ ଲାଡ୍‌ କଃରୁଲିସ୍‌ ? ଇରି କୟ୍‌ ସେ ତିନିତର୍‌ ପିତର୍‌କେ ହଃଚାର୍ଲାକ୍‌ ପିତର୍‌ ଦୁକ୍‌ ଅୟ୍‌ ତାକ୍‌ କୟ୍‌ଲା, “ମାପ୍ରୁ, ତୁୟ୍‌ ସଃବୁ କଃତା ଜାଣି ଆଚ୍‌ସି; ମୁୟ୍‌ ଜେ ତକ୍‌ ଲାଡ୍‌ କଃରୁଲେ, ସେରି ତୁୟ୍‌ ଜାଣି ଆଚ୍‌ସି ।” ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ମେଣ୍ଡାମଃନ୍‌କେ ଚଃରାଉ । ");
INSERT INTO bdv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ସଃତ୍‌କଃରି ମୁୟ୍‌ ତକ୍‌ କଃଉଁଲେ, ବେଣ୍ଡ୍ୟା ରିଲାବଃଳ୍‌ ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଅଃଟା ବାନ୍ଦି ଅୟ୍‌ ଜୁୟ୍‌ ହାକ୍‌ ମଃନ୍, ସେ ହାକ୍‌ ବୁଲ୍‌ତି ରିଲିସ୍‌, ମଃତର୍‌ ବୁଡା ଅୟ୍‌ଲେକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆତ୍‌ ଲାମାଉସି ଆର୍‌ ବିନ୍ ଲକ୍‌ ତର୍‌ ଅଃଟାକ୍‌ ବାନ୍ଦି ଜୁୟ୍‌ ହାକ୍‌ ତର୍‌ ମଃନ୍ ନଃରେୟ୍‌, ସେ ହାକ୍‌ ତକ୍‌ ନଃୟ୍‌ ଜାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପିତର୍‌ କଃନ୍‌କଃରି ମଃର୍ନ୍‌ ବଗ୍ କଃରି ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରେଦ୍‌, ସେ କଃତାକ୍‌ ଦଃରି ଜିସୁ ଇରି କୟ୍‌ଲା । ଇରି କୟ୍‌ଲା ହଃଚେ ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମର୍‌ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଜିସୁ ଜୁୟ୍‌ ଚେଲାକେ ଲାଡ୍‌ କଃର୍ତିରିଲା ଆର୍‌ ଜେ ରାତ୍ୟା କାତାବଃଳ୍‌ ତାର୍‌ ବୁକେ ଡେରାୟ୍‌ ଅୟ୍‌, ମାପ୍ରୁ, ତକ୍‌ କେ ସଃତ୍ରୁ ଆତେ ସଃହ୍ରି ଦଃୟ୍‌ଦ୍‌ ବଃଲି ହଃଚାରିରିଲା, ସେ ଚେଲାକେ ପିତର୍‌ ଉଲ୍‌ଟି କଃରି ହଃଚେ ଆସ୍ତିରିଲାର୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍‌ ତାକ୍‌ ଦଃକି ଜିସୁକେ ହଃଚାର୍ଲା, “ମାପ୍ରୁ, ଇମାନାୟ୍‌ର୍‌ ବିସୟେ ତୁୟ୍‌ କାୟ୍‌ରି କଃଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ତାକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଆସ୍ତା ଦିନ୍ ହଃତେକ୍‌ ସେ ରେଉଅ ବଃଲି ମୁୟ୍‌ ଜଦି ମଃନ୍ କଃରିନ୍ଦ୍‌, ତଃବେ ତର୍‌ କାୟ୍‌ରି ଆଚେ ? ତୁୟ୍‌ ମର୍‌ ହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ସେତାକ୍‌ ସେ ଚେଲା ଜେ ନଃମେରେ, ଇ କଃତା ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଉର୍ଜି ଅୟ୍‌ଲି, ମଃତର୍‌ ସେ ନଃମେରେ ବଃଲି ଜିସୁ ତାକ୍‌ କୟ୍‌ନଃରିଲା, ମଃତର୍‌ ମୁୟ୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଆସ୍ତା ଦିନ୍ ହଃତେକ୍‌ ସେ ରେଉଅ ବଃଲି ଜଦି ମୁୟ୍‌ ମଃନ୍ କଃରିନ୍ଦ୍‌, ତଃବେ ତର୍‌ କାୟ୍‌ରି ଆଚେ ବଃଲି କୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଜେ ଇସଃବୁ କଃତା ସାକି ଦେଉଁଲା ଆର୍‌ ଇସଃବୁ ଲେକି ଆଚେ, ଇରି ସେ ଚେଲା; ଆର୍‌ ତାର୍‌ ସାକି ଜେ ସଃତ୍‌, ସେରି ଅଃମିମଃନ୍‌ ଜାଣୁ । ");
INSERT INTO bdv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଆରେକ୍‌, ଜିସୁ ଗାଦେକ୍‌ ଗାଦେକ୍‌ କାମ୍‌ ହେଁ କଃରିରିଲା; ସେସଃବୁ ଜଦି ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି ଲେକା ଅୟ୍‌ରିଲେକ୍‌, ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ଅଃତେକ୍‌ ପୁସ୍ତକ୍‌ ଲେକା ଅୟ୍‌ଲି ହୁଣି ଜେ, ମର୍‌ ବାବ୍‌ନାୟ୍‌ ଜଃଗତ୍‌ଜାକ ହେଁ ସେସଃବୁ ସଃଙ୍ଗାଉଁକ୍‌ ଟାଣ୍ ନୟ୍‌ଲି ହୁଣି ।");
INSERT INTO bdv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଏ ଲାଡାର୍‌ ତିଅପିଲ, ଜିସୁ ସେ କାମ୍‌ ଆରୁମ୍‌ କଃରି ଜୁୟ୍‌ରି କଃଲା ଆର୍‌ ସିକାୟ୍‌ଲା ସେରି ମର୍‌ ଇ ହଃର୍ତୁ ପୁସ୍ତକେ ଲେକୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ସେ ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ପେରିତ୍‌ ବାବେ ବାଚିରିଲା ସେମଃନ୍‌କେ ସଃର୍ଗେ ଜାତା ଆଗ୍‌ତୁ ଜାତା ହଃତେକ୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ସଃକ୍ତିଦଃୟ୍‌ ସଃର୍ଗେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଜିସୁ ଅଃହ୍‌ଣାକ୍‌ ଦୁକ୍‌ବଗ୍ ହଃଚେ ହେଁ ଗାଦେକ୍‌ ସଃତ୍‌ କାମ୍‌ ଦଃକାୟ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ଅଃହ୍‌ଣାକ୍‌ ସେ ନିଜେ ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ବଃଲି ଦଃକାୟ୍‌ଲା । ଆରେକ୍‌ ଦୁୟ୍‌କଳି ଦିନ୍ ହଃତେକ୍‌ ଗାଦାତର୍‌ ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜାର୍‌ କଃତା କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ଗଟ୍‌ତର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କାଉଁକେ ବଃସ୍‌ଲା ବଃଳ୍‌ ଜିସୁ ସେମଃନ୍‌କେ ଇ ବଲ୍‌ ଦିଲା, “ତୁମିମଃନ୍ ଜିରୁସାଲମେ ହୁଣି କେଣେ ଜାହା ନାୟ୍‌, ମଃତର୍‌ ସଃର୍ଗାର୍‌ ଉବାର୍‌ ସଃୟ୍‌ତ୍‌ କଃତା ମର୍‌ ତଃୟ୍‌ହୁଣି ଜାୟ୍‌ରି ସୁଣି ଆଚାସ୍‌, ସେରି ଜାଗିରିଆ । ");
INSERT INTO bdv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜହନ୍‌ ହାଣିୟେ ବାପ୍ତିସମ୍‌ ଦିଲା ସଃତ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍ କଃତି ଦିନ୍ ହଃଚେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ବାପ୍ତିସମ୍‌ ଅଃଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ସେତାକ୍‌ ପେରିତ୍‌ମଃନ୍‌ ଗଟ୍‌ତଃୟ୍‌ ରୁଣ୍ଡି ଜିସୁକେ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ଏ ମାପ୍ରୁ, ତୁୟ୍‌ କାୟ୍‌ ଅଃବେ ହଃକା ଇସ୍ରାଏଲ୍‌ ଆତେ ରାଇଜ୍‌ ବାଉଳାୟ୍‌ ଦେଉଁଲିସ୍‌ କି ?” ");
INSERT INTO bdv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଜୁୟ୍‌ ସଃବୁ କାଳ୍‌ ଆର୍‌ ସଃମୟ୍‌ ସଃର୍ଗାର୍‌ ଉବା ଅଃହ୍‌ଣା ଅଃଦିକାରେ ସଃଙ୍ଗାୟ୍‌ ଆଚେ, ସେରି ତୁମିମଃନାର୍‌ ଜାଣ୍‌ତା କଃତା ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମଃତର୍‌ ପବିତ୍ର ଆତ୍ମା ତୁମାର୍‌ ଉହ୍ରେ ଆୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ସଃକାତ୍‌ ହାଉଆସ୍‌ ଆର୍‌ ଜିରୁସାଲମ, ସଃବୁ ଜିଉଦା ରାଜି ଆର୍‌ ସମିରଣ୍, ଆରେକ୍‌ ହୁର୍ତିବିର୍‌ ସେସ୍‌ ସଃନ୍ଦି ହଃତେକ୍‌ ହେଁ ମର୍‌ ସାକି ଅଃଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ସେ ଇ ସଃବୁ କଃତା କୟ୍‌ଲା ହଃଚେ, ସେମଃନ୍ ଦଃକୁଦଃକୁ କଃଣ୍ଡେକ୍‌ ମେଗ୍ ଆସି ଜିସୁକେ ଉହ୍ରେ ନଃୟ୍‌ଗଃଲି ଆର୍‌ ସେମଃନ୍ ତାକେ ଦଃକୁ ନାହାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଜିସୁ ଜଃଉଁଜଃଉଁ ଚେଲାମଃନ୍ ଅଃଗାସ୍‌କେ ଦଃକୁଲାୟ୍‌, ଅଃନ୍‌କା ବେଳାୟ୍‌ ଦବ୍‌ ବଃସ୍ତର୍‌ ହିନ୍ଦ୍‌ଲା ଦୁୟ୍‌ ଲକ୍‌ ସେମଃନାର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଆରେକ୍‌ ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଏ ଗାଲିଲିର୍‌ ଲକ୍‌ କାୟ୍‌ତାକ୍‌ ତୁମିମଃନ୍ ଅଃଗାସ୍‌କେ ଦଃକି ଟିଆ ଅୟ୍‌ ଆଚାସ୍‌ ? ଇ ଜୁୟ୍‌ ଜିସୁ ତୁମାର୍‌ ଚଃମେ ହୁଣି ସଃର୍ଗେ ନିଆ ଅୟ୍‌ଲା ତାକେ ତୁମିମଃନ୍ ଜୁୟ୍‌ ରଃକମ୍‌ ସଃର୍ଗେ ଜାତାର୍‌ ଦଃକ୍‌ଲାସ୍‌, ସେ ସେରଃକମ୍‌ ସଃର୍ଗେହୁଣି ବାଉଳି ଆସେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ଇତାର୍‌ ହଃଚେ ସେମଃନ୍ ଜିତ୍‌ଡଙ୍ଗ୍ରେ ହୁଣି ଜିରୁସାଲମ୍‌କେ ବାଉଳି ଆୟ୍‌ଲାୟ୍‌, ସେ ଡଙ୍ଗୁର୍‌ ଜିରୁସାଲମ୍‌ ଚଃମେ ଗଟେକ୍‌ ଅଳିର୍‌ ବାଟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ସେମଃନ୍, ବଃଲେକ୍‌, ପିତର୍‌, ଜହନ୍‌, ଜାକୁବ, ଆନ୍ଦ୍ରିଅ, ପିଲିପ୍, ତମା, ବାର୍ତଲମି, ମାତିଉ, ଆଲ୍‌ପିଅସାର୍‌ ହୟ୍‌ସି ଜାକୁବ, ଉଦ୍‌ଜଗି ସିମନ୍ ଜେ ଇସ୍ରାଏଲ୍‌ ମଃନ୍‌କେ ମୁକ୍ଳାଉଁକ୍‌ ମଃନ୍‌କଃର୍ତିରିଲା, ଆର୍‌ ଜାକୁବର୍‌ ହୟ୍‌ସି ଜିଉଦା ଜିରୁସାଲମ୍‌ ଗଃଳେ ଗଃଳାୟ୍‌ । ଆର୍‌ ଜୁୟ୍‌ ଉହ୍ରାର୍‌ ବଃକ୍ରାୟ୍‌ ସେମଃନ୍ ରେତି ରିଲାୟ୍‌ ସେତି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ସେମଃନ୍ ସଃବୁ ମାୟ୍‌ଜିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆର୍‌ ଜିସୁର୍‌ ଆୟ୍‌ସି ମରିୟମ୍‌ ଆର୍‌ ତାର୍‌ ବାୟ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଟେକ୍‌ ଟାଣେ ଗଟେକ୍‌ମଃନେ ପାର୍ତ୍‌ନା କଃରୁକେ ସଃବୁଲଃକ୍‌ ରୁଣ୍ଡ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","କଃତିଦିନାର୍‌ ହଃଚେ ହାକାହାକି ଚଅକଳି ବିସ୍ୱାସି ବାୟ୍‌ବେଣି ମଃନାର୍‌ ଲକ୍‌ ଦଃଳ୍‌ ବିତ୍ରେ ପିତର୍‌ ଟିଆଅୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ବାୟ୍‌ବେଣିମଃନ୍, ଜୁୟ୍‌ ଇସ୍କାରିଅତ୍‌ ଜିଉଦା ଜିସୁକ୍‌ ଦଃର୍ତା ଲକ୍‌ମଃନ୍‌କେ ବାଟ୍‌ ଦଃକାୟ୍‌ରିଲା, ତାର୍‌ କଃତାକ୍‌ ପବିତ୍ର ଆତ୍ମା ଦାଉଦାର୍‌ ଟଣ୍ଡେ ଜାୟ୍‌ରି କୟ୍‌ରିଲି ସେ ସାସ୍ତର୍‌ କଃତା ହୁରୁଣ୍ ଅଃଉଁକେ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିଉଦା ଅଃମାର୍‌ ଦଃଳ୍‌ ବିତ୍ରେ ଏକ୍ଲା ବଃଲି ଗଃଣ୍‌ତି ଅଃଉତି ରିଲା, ଆର୍‌ ଇ ସେବା ହଃଦେ ସେ ହେଁ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଇ ଜିଉଦା ଜିସୁକେ ଦଃରାୟ୍‌ ଜୁୟ୍‌ ଅଃଦଃର୍ମାର୍‌ ଟଃକା ହାୟ୍‌ରିଲା, ସେ ଟଃକାୟ୍‌ କଃଣ୍ଡେକ୍‌ ବୁୟ୍‌ଁ ଗେନା ଜାୟ୍‌ ରିଲି, ଆରେକ୍‌ ସେ ସେତି ଟିଆଟିଆ ହଃବ୍‌ଳାୟ୍‌ ଅୟ୍‌ଲା, ତାର୍‌ ହେଟ୍‌ ହୁଟ୍‌ଲି, ଆର୍‌ ଅଃତ୍‌ନିହଟା ବାରାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଆର୍‌ ଜିରୁସାଲମ୍‌ ଗଃଳେ ବାସାକଃର୍ତା ସବୁ ଲକ୍‌ମଃନ୍ ଜାଣ୍‌ଲାୟ୍‌ ଆର୍‌ ସେ ହଃଦା, ତାକାର୍‌ ବାସାୟ୍‌ “ହକଲ୍‌ଦମା” ବଃଲେକ୍‌ ବଃନିର୍‌ ହଃଦା ବଃଲି ଡାକ୍‌ ହୁଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ଆର୍‌ ଗିତସଂଗିତା ପୁସ୍ତକେ ଇରି ଲେକା ଆଚେ,” “ତାର୍‌ ଗଃର୍‌ ସୁନା ଅଃଉଅ, ସେତି କେ ବାସା ନଃକେରତ୍‌, ଆରେକ୍‌ ହେଁ ଲେକା ଆଚେ ତାର୍‌ କାମ୍‌ ବିନ୍‌ଲକ୍‌ ହାଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ସେତାକ୍‌ ମାପ୍ରୁ ଜିସୁର୍‌ ମଃରି ଉଟ୍‌ଲାର୍‌ ସାକି ଅଃଉଁକେ ଆରେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ମିସ୍ତା ଲଳା । ଜହନ୍‌ ବାପ୍ତିସମ୍‌ ଦେତା ବଃଳ୍‌ ହୁଣି ଆରୁମ୍‌ କଃରି ଅଃମାର୍‌ ତଃୟ୍‌ହୁଣି ଉହ୍ରେ ସଃର୍ଗେ ଗଃଲା ଦିନ୍‌ହୁଣି ଜଃତେକ୍‌ ଦିନ୍ ମାପ୍ରୁ ଜିସୁ ଅଃମାର୍‌ ବିତ୍ରେ ଜାଆ ଆସ୍‌ କଃର୍ତିରିଲା, ");
INSERT INTO bdv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜିସୁ ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲା ଦିନ୍‌ହୁଣି ସଃର୍ଗେ ଜାତା ହଃତେକ୍‌ ସଃବୁବଃଳ୍‌ ମାପ୍ରୁ ଜିସୁ ଅଃମିମଃନାର୍‌ ସଃଙ୍ଗ ବୁଲାଚାଲା ଅଃଉତାବଃଳ୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଅଃମାର୍‌ ଦଃଳେ ରିଲାୟ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ଏକ୍ଲାକେ ଉଟ୍‌ତା ଦଃର୍କାର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ସେତାକ୍‌ ସେମଃନ୍ ଦୁୟ୍‌ ଲକ୍‌କେ, ବଃଲେକ୍‌ ଜସେପ୍ ଜାକେ ବଃର୍ସବା ବଃଲି କଃଉତି ଆର୍‌ ଜାର୍‌ ଆରେକ୍‌ ଗଟ୍‌ ନାଉଁ ଜୁସ୍ତ ଆର୍‌ ମତିୟକେ ଦୁୟ୍‌ ଲକାର୍‌ ନାଉ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ଆର୍‌ ଇ ପାର୍ତ୍‌ନା କଃଲାୟ୍‌, “ଏ ମାପ୍ରୁ ତୁୟ୍‌ ସଃବୁ ଲକାର୍‌ ଚିତା ଜାଣୁଲିସ୍‌, ଇ ଦୁୟ୍‌ ଲକାର୍‌ ବିତ୍ରେ କାକେ ତୁୟ୍‌ ବାଚି ଆଚ୍‌ସି, ଅଃମିକ୍‌ ଜାଣାଉ; ଜିଉଦା ମଃଲାକ୍‌ ତାର୍‌ ସେବା ଆର୍‌ ପେରିତ୍‌ ହଃଦ୍‌ ବୁଡି ଆଚେ, ");
INSERT INTO bdv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଇ ଲକ୍‌ ଜିଉଦାର୍‌ ଟାଣେ ପେରିତ୍‌ ଚେଲା କାମ୍‌ କଃରେଦ୍‌, ସେବା ହଃଦ୍‌ ହାଉଁକ୍‌ ଇ ଦୁୟ୍‌ ଲକାର୍‌ ବିତ୍ରେ ତୁମି କାକେ ବାଚି ଆଚାସି, ତାକେ ଦଃକାଉ ।” ");
INSERT INTO bdv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତାର୍‌ ହଃଚେ ସେମଃନ୍ ସେ ଦୁୟ୍‌ ଲକାର୍‌ ଗିନେ କେଳି ବାଚ୍‌ଲାୟ୍‌, ଆର୍‌ ମତିୟର୍‌ ନାଉଁଏ କେଳି ହୁଟ୍‌ଲି, ସେତାକ୍‌ ସେ ଏଗାର୍‌ ପେରିତ୍‌ ସଃଙ୍ଗ୍ ଗଃଣା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ଜଃଡ୍‌ବଃଳ୍‌ ପେଣ୍ଟିକସ୍ଟ୍‌ ହଃର୍ବାର୍‌ ଦିନ୍ ଚଃମେ ଅୟ୍‌ଲି ସଃବୁ କ୍ରିସ୍ଟ ବିସ୍ୱାସିମଃନ୍ ଗଟ୍‌ ଟାଣେ ରୁଣ୍ଡି ରିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଆର୍‌ ଗୁରାଗାଲିର୍‌ ସଃବଦ୍‌ ହର୍‌ ଗଟେକ୍‌ ସଃବଦ୍‌ ତଃତ୍‌କାଣ୍ ଅଃଗାସେ ହୁଣି ଆୟ୍‌ଲି ଆର୍‌ ଜୁୟ୍‌ ଗଃରେ ସେମଃନ୍ ବଃସି ରିଲାୟ୍‌ ସେ ଗଃରାର୍‌ ଚାରିହାକ୍‌ ମାଡିଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ଆର୍‌ ଜୟ୍‌ ହର୍‌ ଜିବ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ଦଃକାୟ୍‌ ଅୟ୍‌ଲି, ଆର୍‌ ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକେ ସେମଃନାର୍‌ ସଃବ୍‌କାର୍‌ ଉହ୍ରେ ଉତୁର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ସେତାକ୍‌ ସଃବୁ ଲକ୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ଆତ୍ମା ସେମ୍‌ନଃକେ ଜଃନ୍‌କଃରି କଃଉଁକେ ଦିଲି, ସେନ୍‌କଃରି ସେମଃନ୍ ବିନ୍ ବିନ୍ ବାସାୟ୍‌ କଃତା କାଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଅଃଡେବଃଳ୍‌ ଅଃଗାସ୍‌ ତଃଳେ ରିଲା ହୁର୍ତିବିର୍‌ ବିନ୍‌ବିନ୍‌ ଦେସେହୁଣି ଆସିରିଲା ଜିଉଦିମଃନ୍ ଜିରୁସାଲମେ ସେବାକାରି ସେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଆର୍‌ ସେ ଗଃର୍ଞ୍ଜାଣ୍ ଅୟ୍‌ଲାକ୍‌ ଗାଦାଲକ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ ଆର୍‌ କ୍ରିସ୍ଟବିସ୍ୱାସି ମଃନ୍ ନିଜାର୍‌ ନିଜାର୍‌ ବାସାୟ୍‌ କଃଉତାର୍‌ ସୁଣି ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ଆରେକ୍‌ ସେମଃନ୍ ବଃଡେ କାବା ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌, “ଇ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ କଃତା କଃଉଁଲାୟ୍‌ ସେମଃନ୍ କାୟ୍‌ ଗାଲିଲିର୍‌ ନଃଉତି ? ");
INSERT INTO bdv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ତଃବେ ଅଃମିମଃନ୍‌ କଃନ୍‌କଃରି ହଃତି ଲକ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ବାସାୟ୍‌ କଃତା କଃଉତାର୍‌ ସୁଣ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ପାର୍ତିୟ, ମାଦିୟ ଆର୍‌ ଏଲାମିୟ, ଆରେକ୍‌ ମେସପଟାମିଆ, ଜିଉଦା ଆର୍‌ କାପାଦକିଆ, ପନ୍ତ ଆର୍‌ ଆସିଆ, ");
INSERT INTO bdv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପ୍ରୁଗିଆ ଆର୍‌ ପପୁଲିଆ, ମିସର୍‌ ଆର୍‌ କୁରିଣି ଚଃମାର୍‌ ଲିବିଆ ହଲିର୍‌ ଆର୍‌ ରମ୍‌ ହୁଣି ଆୟ୍‌ଲା ଜିଉଦି ଆର୍‌ ଜିଉଦି ଦଃର୍ମେ ମିସିକଃରି ଆସିରିଲା ଲକ୍‌ମଃନ୍, ");
INSERT INTO bdv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଆରେକ୍‌ କ୍ରିତିଅ ଆର୍ ଆରବ୍‌ ଦେସାର୍‌ ଜିଉଦି ଲକ୍‌ମଃନ୍ ଜେ ଅଃମିମଃନ୍‌, ଅଃମିମଃନାର୍‌ ଦଃର୍ମ୍‌ ଦାରାୟ୍‌ ଅଃମାର୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ବାସାୟ୍‌ ଇସ୍ୱରାର୍‌ ମହାନ୍‌ କଃତା କଃଉତାର୍‌ ସୁଣ୍‌ଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଆର୍‌ ସଃବୁ କାବା ଆର୍‌ ବୁଦି ବାଣା ଅୟ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମଃତର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍ ବିସ୍ୱାସି ମଃନ୍‌କେ ଟାହ୍ରାକଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇମଃନ୍‌ ମଃଦ୍‌ କାୟ୍‌ ମାତି ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ମଃତର୍‌ ପିତର୍‌ ଏଗାର୍‌ଗଟ୍‌ ସଃଙ୍ଗ୍ ଟିଆଅୟ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍‌କଃରି ସେମଃନାର୍‌ ଚଃମେ କଃତା କଃଉଁକ୍‌ ଦଃର୍ଲା, “ଆର୍‌ ଏ ଜିଉଦି ଲକ୍‌ମଃନ୍ ଆର୍‌ ଜିରୁସାଲମାର୍‌ ସଃବୁ ଲକ୍‌ ତୁମିମଃନ୍ ଇରି ସୁଣା ଆର୍‌ ମର୍‌ କଃତାର୍‌ ଅଃର୍ତ୍‌ ବୁଜାୟ୍‌ କଃଉଁଲେ ଜାଣା । ");
INSERT INTO bdv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ମଃନେ ବାବୁଲାସ୍‌ ଇମଃନ୍‌ ସେମଃନାର୍‌ ହର୍‌ ମାତୁଆଳି ନାୟ୍‌, ବଃଲେକ୍‌ ଅଃବେ ସଃକାଳ୍‌ ନଅଃ ଗଃଟା ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ମଃତର୍‌ ଜୟେଲ୍‌ ବାବ୍‌ବାଦି ଜାୟ୍‌ରି କୟ୍‌ଆଚେ, ଇରି ସେ ଗଃଟ୍‍ଣା ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ଇସ୍ୱର୍‌ କୟ୍‌ଆଚେ ସେସ୍‌ କାଳେ ଅଃନ୍‌କାର୍‌ ଇରି ମୁୟ୍‌ଁ କଃରିନ୍ଦ୍‌ । ମୁୟ୍‌ଁ ସଃବୁ ଲକାର୍‌ ଉହ୍ରେ ନିଜାର୍‌ ଆତ୍ମା ବଃର୍ସାଇନ୍ଦ୍ ସେତାକ୍‌ ମର୍‌ କବୁର୍‌ କଃଉତି ହୟ୍‌ଦି ଜିଦିମଃନ୍ ବାବ୍‌ବାଣି କଃଉତି; ଆର୍‌ ତୁମିମଃନାର୍‌ ବେଣ୍ଡ୍ୟାମଃନ୍ ନିକ କଃତାମଃନ୍‌ ଦଃକ୍‌ତି, ଆରେକ୍‌ ତୁମାର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ଚଃହୁନ୍‌ ଦଃକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ହେଁ ସେ କାଳେ ମୁୟ୍‌ଁ ମର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନାର୍‌ ଉହ୍ରେ ମର୍‌ ଆତ୍ମା ହଃଟାୟ୍‌ନ୍ଦ୍, ସେତାକ୍‌ ସେମଃନ୍ ବାବ୍‌ବାଣି କଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ମୁୟ୍‌ଁ ଅଃଗାସ୍‌ ଉହ୍ରେ କାବା ଅଃଉତା କାମ୍‌ ଆରେକ୍‌ ଅଃଗାସ୍‌ ତଃଳାର୍‌ ହୁର୍ତିବି ତଃୟ୍‌ ବିନ୍ ବିନ୍ ଚିନ୍‌, ବଃନି, ଜୟ୍‌, ଆର୍‌ କଃଳିଆ ଦୁଆଁ ଦଃକାୟ୍‌ନ୍ଦ୍ । ");
INSERT INTO bdv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ମାପ୍ରୁର୍‌ ବଃଡ୍ ଆର୍‌ ଜଃଜ୍‌ମାନାର୍‌ ଦିନ୍ ଆସ୍ତା ଆଗ୍‌ତୁ ବେଳ୍‌ ଅଃନ୍ଦାର୍‌, ଆର୍‌ ଜଃନ୍ ବଃନି ହର୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆର୍‌ ଅଃନ୍‌କାର୍‌ ଗଃଟେଦ୍‌ ଜେ, ଜଃଡେବଃଳ୍‌ ମାପ୍ରୁର୍‌ ନାଉଁଏ ପାର୍ତ୍‌ନା କଃରେଦ୍‌, ସେ ମୁକ୍ତି ହାୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ଏ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍ ଇ ସଃବୁ କଃତା ସୁଣା ନାଜରିତାର୍‌ ଜିସୁ କଃତେକ୍‌ ସଃକ୍ତିର୍‌ କାମ୍‌, କାବା ଅଃଉତା କାମ୍‌, ଆର୍‌ ଚିନ୍ ଦଃକାୟ୍‌ ତୁମିମଃନାର୍‌ ଚଃମେ ଇସ୍ୱରାର୍‌ ହଃଟାୟ୍‌ଲା ଲକ୍‌ ବଃଲି ଚିନାୟ୍‌ଅୟ୍‌ ଆଚେ, ତାର୍‌ ତଃୟ୍‌ ଇସ୍ୱର୍‌ ଜେ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ଇତି ସଃବୁ କାମ୍‌ କଃରିଆଚେ, ଇରି ତୁମିମଃନ୍ ନିଜେ ନିଜେ ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଇସ୍ୱର୍‌ ତାର୍‌ ଜଃଜ୍‌ନା ହଃର୍କାରେ ଜିସୁକେ ତୁମାର୍‌ ଆତେ ସଃହ୍ରି ଦେଉଁକେ ତିର୍‌ କଃରିରିଲା । ଆରେକ୍‌ ତୁମି ତାକେ ବିଦିନୟ୍‌ଲା ହାହିମଃନାର୍‌ ସଃଙ୍ଗ୍ କ୍ରୁସେ ଚଗାୟ୍‌ ମାର୍‌ଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମଃତର୍‌ ଇସ୍ୱର୍‌ ମଃର୍ନ୍‌ ବାନ୍ଦୁଣ୍ ଇଟାୟ୍‌ ତାକେ ଉଟାୟ୍‌ ଆଚେ, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ମଃରି କଃରି ସଃବୁଦିନ୍ ରେତା ହାବଳ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ୍‌ ତାର୍‌ କଃତା କୟ୍‌ଆଚେ, ‘ମୁୟ୍‌ଁ ସଃବୁବଃଳ୍‌ ମର୍‌ ମୁଏଁ ମାପ୍ରୁକ୍‌ ଦଃକି ଆଚି, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ନଃଡିରି, ସେତାକ୍‌ ସେ ମର୍‌ କାତା ବାଟ୍ୟା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ସେତାକ୍‌ ମର୍‌ ମଃନ୍ ସଃର୍ଦା, ଆର୍‌ ମର୍‌ ଜିବନ୍ ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ଲି, ଆର୍‌ ମର୍‌ ମଃର୍‌ତା ଗଃଗାଳ୍‌ ହେଁ ଇସ୍ୱରାର୍‌ ବଃର୍ସାୟ୍‌ ବାଚେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ମର୍‌ ହଃରାଣ୍‌କେ ହଃତାଳେ ନଃଚାଡ୍‌ସି, ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଦଃର୍ମି ଲକ୍‌କେ ମଃସୁଣ୍‌ କାଲେ ନଃସ୍ଟ୍‌ ଅଃଉଁକେ ନଃଦେସି । ");
INSERT INTO bdv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ତୁୟ୍‌ ମର୍‌ ଜିବନାର୍‌ ବାଟ୍‌ ଦଃକାୟ୍‌ ଆଚ୍‌ସି, ତୁୟ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ରିଲେକ୍‌ ମକ୍‌ ସଃର୍ଦାୟ୍‌ ହୁର୍ନ୍‌ କଃର୍ସି ।’ ");
INSERT INTO bdv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ଏ ଇସ୍ରାଏଲାର୍‌ ବାୟ୍‌ବେଣିମଃନ୍, ଦାଦିବାବୁର୍‌ ମୁଳ୍‌ ବଃଉଁସ୍‌ ଦାଉଦାର୍‌ କଃତା ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ଟଣ୍ଡ୍ ମେଲାକଃରି କଃଉତା ଅଃଦିକାର୍‌ ଜେ, ସେ ମଃଲା ଆର୍‌ ମଃସ୍‌ଣେ ତାକେ ତହ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ ମଃସୁଣ୍ ଆଜି ହଃତେକ୍‌ ଅଃମାର୍‌ ତଃୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ବାବ୍‌ବାଦି ଅୟ୍‌ରିଲାକ୍‌ ଆର୍‌ ତାର୍‌ ବଃଉଁସାର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଇସ୍ୱର୍‌ ତାର୍‌ ସିଙ୍ଗାସଣେ ବଃସାଉଁକ୍‌ ତାର୍‌ ଚଃମେ ହଃର୍ମାଣ୍‌ କଃରି ସଃୟ୍‌ତ୍‌ କଃରିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଇସ୍ୱର୍‌ ଆସୁଲା ଦିନେ କାୟ୍‌ରି କଃରୁକେ ଜଃଉଁଲା, ଦାଉଦ୍‌ ସେରି ଜାଣୁହାରି କ୍ରିସ୍ଟ ଉଟ୍‌ତା କଃତା କୟ୍‌ ଆଚେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେ ହଃତାଳେ ଚାଡା ନୟ୍‌ଲା; ଆର୍‌ ତାର୍‌ ଗଃଗାଳ୍‌ ନଃସ୍ଟ୍‌ ନୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଇ ଜିସୁକେ ଇସ୍ୱର୍‌ ଉଟାୟ୍‌ ଆଚେ, ସେ କଃତା ଅଃମି ସଃବୁ ଜାଣୁ । ");
INSERT INTO bdv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଜିସୁ, ତାର୍‌ ଉବାସି ଇସ୍ୱର୍‌ କାତା ବାଟ୍ୟା ସେ ଉଟାୟ୍‌ ଇସ୍ୱରାର୍‌ କାତା ଆତ୍‌ ତଃୟ୍‌ହୁଣି ଉଚ୍ ଆର୍‌ ଉବାର୍‌ ତଃୟ୍‌ହୁଣି ସଃୟ୍‌ତାର୍‌ ପବିତ୍ର ଆତ୍ମା ହାୟ୍‌କଃରି ଜାୟ୍‌ରି ତୁମିମଃନ୍ ଦଃକୁଲାସ୍‌ ଆର୍‌ ସୁଣୁଲାସ୍‌, ସେରି ସେ ଅଃମାର୍‌ ଉହ୍ରେ ଡାଳି ଦଃୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦାଉଦ୍‌ ସଃର୍ଗେ ଜାୟ୍‌ ନଃରିଲା, ମଃତର୍‌ ସେ ନିଜେ କୟ୍‌ଆଚେ, “ମାପ୍ରୁ ମର୍‌ ମାପ୍ରୁକ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ମୁୟ୍‌ଁ ଜୁୟ୍‌ ହଃତେକ୍‌ ତୁମାର୍‌ ସଃତ୍ରୁମ୍‌ନଃକେ ତୁମାର୍‌ ହାଦ୍‌ ତଃଳେ ନଃକେରି, ସେ ହଃତେକ୍‌ ମର୍‌ କାତା ବାଟ୍ୟା ବଃସିରେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ବଃଲେକ୍‌ ସଃର୍ନେ ଇସ୍ରାଏଲ୍‌ ବଃଉଁସ୍‌ ବାୟ୍‌ଦ୍‌ରେ ଜାଣତ୍‌ ଜୁୟ୍‌ ଜିସୁକେ ତୁମିମଃନ୍ କ୍ରୁସେ ମାର୍‌ଲାସ୍‌ ତାକେ ଇସ୍ୱର୍‌ ମାପ୍ରୁ ଆର୍‌ କ୍ରିସ୍ଟ ଜଳେକ୍‌ ହଃଦେ ବଃସାୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଇ କଃତା ସୁଣି ସେମଃନାର୍‌ ମଃନ୍ ବାଙ୍ଗିଗଃଲି ଆରେକ୍‌ ସେମଃନ୍ ପିତର୍‌ ଆର୍‌ କବୁର୍‌କାରିଆ ମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌, “ବାୟ୍‌ମଃନ୍ ଆମିମଃନ୍ କାୟ୍‌ କଃରୁଆଁ ?” ");
INSERT INTO bdv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ସେତାକ୍‌ ପିତର୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ମଃନ୍ ବାଦ୍ଲାଉଆ ଆର୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହାହ୍‌ କେମା ଗିନେ ହଃତି ଲକ୍‌ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ନାଉଁଏ ବାପ୍ତିସମ୍‌ ହାଉଆ, ସେନ୍‌ଅୟ୍‌ଲେକ୍‌ ତୁମିମଃନ୍ ପବିତ୍ର ଆତ୍ମାର୍‌ ଦାନ୍‌ ହାଉଆସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ସଃୟ୍‌ତ୍‌ ତୁମାର୍‌ ଗିନେ ଅୟ୍‌ଆଚେ, ତୁମିମଃନାର୍‌ ହିଲାମଃନାର୍‌ ଗିନେ ଆରେକ୍‌ ଦୁରେ ରେତା ଜଃତେକ୍‌ ଲକ୍‌କେ ମାପ୍ରୁ ଅଃମାର୍‌ ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ଚଃମେ କୁଦେଦ୍‌, ସେ ସଃବ୍‌କାର୍‌ ଗିନେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଆରେକ୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ କଃତେକ୍‌ କଃତାୟ୍‌ ପିତର୍‌ ସାକି ଦେଉଁକ୍‌ ଦଃର୍ଲା ଆର୍‌ ସେମଃନ୍‌କେ ଗଃଉଆରି କଃରି କୟ୍‌ଲା, “ଇ ହେଟ୍‌କୁଟ୍ୟା ବଃଉଁସ୍‌ ତଃୟ୍‌ହୁଣି ତୁମିମଃନ୍ ମୁକ୍ଳା ।” ");
INSERT INTO bdv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ସେତାକ୍‌ ଜୁୟ୍‌ମଃନ୍‌ ପିତରାର୍‌ କଃତା ମଃନେ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌, ସେମଃନ୍ ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେ ଦିନ୍ ହାକାହାକି ତିନି ଅଃଜାର୍‌ ଲକ୍‌ ବିସ୍ୱାସି ଦଃଳେ ମିସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ସେମଃନ୍ ପେରିତ୍‌ମଃନାର୍‌ ସିକ୍ୟାୟ୍‌, ସଃଙ୍ଗେ ରେତାର୍‌, ରୁଟି ବାଙ୍ଗ୍‌ତା ତଃୟ୍‌, ପାର୍ତ୍‌ନା କଃର୍ତା ତଃୟ୍‌ ମଃନ୍‌ହଃରାଣ୍ ଦଃୟ୍‌ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ଆର୍‌ ଲକ୍‌ମଃନ୍ କାବା ଅୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ପେରିତ୍‌ମଃନ୍‌ ଗାଦେକ୍‌ କାବା ଅଃଉତା କାମ୍‌ ଆର୍‌ ଚିନ୍‌ମଃନ୍‌ ଦଃକାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ ସେମଃନ୍ ସଃବୁ ଗଟେକ୍‌ ଟାଣେ ରୁଣ୍ଡି ସଃବୁ ରଃକମାର୍‌ ଦଃନ୍‌ବିତ୍‌ ସଃବାର୍‌ ବଃଲି ବାବ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଆରେକ୍‌ ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସଃବୁ ରଃକମାର୍‌ ଦଃନ୍‌ସଃପତି ବିକିକଃରି ଜାର୍‌ ଜଃତେକ୍‌ ଲଳା ସଃବ୍‌କେ ବାଟାକଃରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଆର୍‌ ସେମଃନ୍ ଏକ୍‌ ମଃନ୍ ଅୟ୍‌ ସଃବୁ ବିନ୍ ମନ୍ଦିରେ ରୁଣ୍ଡିରେତି ରିଲାୟ୍‌ ଆର୍‌ ଗଃରେ ଗଃରେ ରୁଟି ବାଙ୍ଗି କଃରି ସଃର୍ଦାୟ୍‌ ଆର୍‌ ସୁସାର୍‌ ମଃନେ କାଉଆ ହିଉଆ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଆର୍‌ ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ଦଃୟାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତି ରିଲାୟ୍‌ ଆର୍‌ ସଃବୁ ଲକାର୍‌ ଗଃର୍‌ ମଃନ୍‌କେ ଜାତି ରିଲାୟ୍‌, ଆରେକ୍‌ ମାପ୍ରୁ ହାହେ ହୁଣି ମୁକ୍ତି ହାୟ୍‌ଲା ଲକ୍‌ମଃନ୍‌କେ ହଃତିଦିନ୍ ସେମଃନାର୍‌ ଦଃଳେ ମିସାଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ଗଟ୍‌ ଦିନ୍ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ପାର୍ତ୍‌ନା ବେଳାୟ୍‌ ଉହୁର୍‌ଅଳି ତିନି ଗଃଟାବଃଳ୍‌ ମନ୍ଦିରେ ଜାତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଅଃନ୍‌କାବଃଳ୍‌ ଜଃଲମେହୁଣି ହୁଣି ଗଟେକ୍‌ ଚଟାଲକେ ମନ୍ଦିର୍‌ ଦୁଆର୍‌ ଚମେ ବୟ୍‌ ନଃୟ୍‌ ବଃସାଉତି ରିଲାୟ୍‌; ମନ୍ଦିରେ ଜାତିରିଲା ଲକ୍‌ମଃନ୍‌କେ ବିକ୍‌ମାକୁକ୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ହଃତି ଦିନ୍ ମନ୍ଦିରାର୍‌ ସୁନ୍ଦୁର୍‌ ନାଉଁଆର୍‌ ଦୁଆରେ ବଃସାଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ସେ ଚଟା, ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଜାତାର୍‌ ଦଃକି ବିକ୍‌ମାକୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ତାକେ ନିକ୍‌କଃରି ଦଃକ୍‌ଲାୟ୍‌, ଆର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ଅଃମାର୍‌ ବାଟ ଦଃକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ସେତାକ୍‌ ସେ ଚଟା ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କାୟ୍‌ରି ହାଉଁକ୍‌ ଆସା କଃରି ସେମଃନାର୍‌ ହାକ୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମଃତର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ରୁହା କି ସନା ମର୍‌ ତଃୟ୍‌ ନାୟ୍‌, ମଃତର୍‌ ମର୍‌ ଜାୟ୍‌ରି ଆଚେ ସେରି ମୁୟ୍‌ଁ ତକ୍‌ ଦେଉଁଲେ, ନାଜରିତାର୍‌ ଜିସୁର୍‌ କ୍ରିସ୍ଟର୍‌ ନାଉଁଏ ଇଣ୍ଡ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଆରେକ୍‌ ସେ ତାର୍‌ କାତା ଆତ୍‌ ଦଃରି ଉଟାୟ୍‌ଲା, ତଃତ୍‌କାଣ୍ ତାର୍‌ ହାଦ୍‌ ଆର୍‌ ଗଡାର୍‌ ଗଃଟି ସଃବୁ ବଃଳ୍‌ ହାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ଆରେକ୍‌ କୁତ୍‌ମାଡି ଟିଆ ଅୟ୍‌ଲା, ଆରେକ୍‌ ଇଣ୍ଡୁକ୍‌ ଦଃର୍ଲା, ଆର୍‌ ସେ ଇଣ୍ଡୁଇଣ୍ଡୁ ଆର୍‌ କୁତ୍‌ମାରୁମାରୁ, ଆରେକ୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକଃରୁ ସେମଃନାର୍‌ ସଃଙ୍ଗେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ସେତିରିଲା ଲକ୍‌ମଃନ୍ ତାକେ ଇଣ୍ଡ୍‌ତାର୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ମନ୍ଦିରାର୍‌ ସୁନ୍ଦୁର୍‌ ନାଉଁଆର୍‌ ଦୁଆର୍‌ ଚଃମେ ବଃସି ବିକ୍‌ ମାଗ୍‌ତିରିଲା, ଏ ସେ ଲକ୍‌ ବଃଲି ସେମଃନ୍ ଚିନ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ତାକେ ଜାୟ୍‌ଜାୟ୍‌ରି ଗଃଟିରିଲି ସେରି ଦଃକି ସେମଃନ୍ ବଃଡେ ଡିର୍‌ଲାୟ୍‌, ଆର୍‌ କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ସେ ଚଟାକେ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ସଃଙ୍ଗ୍ ସଲ୍‌ମନାର୍‌ ହିଣ୍ଡାୟ୍‌ ରିଲାର୍‌ ଦଃକି ସଃବୁ ଲକ୍‌ ବଃଡେ କାବା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ଦଃବ୍‌ଳି ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍‌ ସେରି ଦଃକି ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, ଏ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍ କାୟ୍‌ତାକ୍‌ ଇ ଚଟାର୍‌ ଗିନେ କାବା ଅଃଉଁଲାସ୍‌, ଅଃମିମଃନ୍‌ ଜଃନ୍‌କଃରି ନିଜାର୍‌ ସଃକ୍ତି କି ଇସ୍ୱର୍‌ ବିସ୍ୱାସ୍‌ ବଃଳେ ଆକ୍‌ ଇଣ୍ଡୁକ୍‌ ଦଃୟ୍‌ ଆଚୁ, ସେରି ବାବି କାୟ୍‌ତାକ୍‌ ଅଃମିକ୍‌ ଦଃକିଲାଗୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ୍‌, ଇସାକ୍‌ ଆର୍‌ ଜାକୁବର୍‌ ଇସ୍ୱର୍‌, ଅଃମାର୍‌ ଦାଦିବାବୁର୍‌ ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଜିସୁକେ ଜଃଜ୍‌ମାନ୍ କଃରି ଆଚେ, ସେ ଜିସୁକେ ତୁମିମଃନ୍ ସଃତ୍ରୁଆତେ ସଃହ୍ରି ଦିଲାସ୍‌ ଜଃଡେବଃଳ୍‌ ପିଲାତ୍‌ ତାକେ ମୁକ୍ଳାଉଁକ୍‌ ତିର୍‌ କଃର୍ତିରିଲା ସଃଡେବଃଳ୍‌ ତାକେ ତୁମିମଃନ୍ ପିଲାତର୍‌ ଚଃମେ ମୁକ୍ଳାଉଁକ୍‌ ନଃଦିଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ତୁମିମଃନ୍ ସେ ପବିତ୍ର ଆର୍‌ ଦଃର୍ମିଲକ୍‌କେ ଚାଡ୍‌ଲାକ୍‌ ଆର୍‌ ଗଟେକ୍‌ ନଃର୍‌ ଅଃତ୍ୟାକାରିକେ ଜଃନ୍‌କଃରି ତୁମାର୍‌ ଗିନେ ଚାଡୁକ୍‌ ଇତି ପିଲାତ୍‌କେ ଗଃଉଆରି କଃଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ମଃତର୍‌ ଜିବନାର୍‌ ବାଟ୍‌ ଦଃକାଉତା ଲକେ ତୁମିମଃନ୍ ମାର୍‌ଲାସ୍‌, ତାକେ ଇସ୍ୱର୍‌ ମଃଲା ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଉଟାୟ୍‌ଲା ଆଚେ, ଅଃମିମଃନ୍‌ ସେତିର୍‌ ସାକି । ");
INSERT INTO bdv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଆର୍‌ ଜିସୁର୍‌ ନାଉଁଏ ବିସ୍ୱାସ୍‌ କଃଲାକ୍‌ ଇ ଜୁୟ୍‌ ଲକ୍‌କେ ତୁମିମଃନ୍ ଦଃକୁଲାସ୍‌ ଆର୍‌ ଜାଣି ଆଚାସ୍‌, ଆକ୍‌ ତାର୍‌ ନାଉଁ ବଃଳ୍‌ ଦଃୟ୍‌ଆଚେ; ହେଁ ତାର୍‌ ବିସ୍ୱାସ୍‌ ହଃକା ତୁମାର୍‌ ସଃବ୍‌କାର୍‌ ଚଃମେ ଆକ୍‌ ଉଜ୍‌ କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଆର୍‌ ଏ ଇସ୍ରାଏଲିୟ ବାୟ୍‌ବେଣିମଃନ୍ ତୁମିମଃନ୍ ଆର୍‌ ତୁମାର୍‌ ମୁଳିକାମଃନ୍ ଜିସୁକେ ଜାୟ୍‌ରି କଃଲାସ୍‌ ସେରି ନଃଜାଣିକଃରି ଇରି କଃରି ଆଚାସ୍‌, ଇରି ମୁୟ୍‌ଁ ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ମଃତର୍‌ ଇସ୍ୱର୍‌ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ଦୁକ୍‌ ବଗ୍ କଃତା ସଃବୁ ବାବ୍‌ବାଦିର୍‌ ମୁଏଁ ଜାୟ୍‌ଜାୟ୍‌ରି ହୁର୍ବେ ପର୍ଚାର୍‌ କଃରିରିଲା ସେ ସଃବୁ ଅଃନ୍‌କଃରି ହୁରୁଣ୍ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ବଃଲେକ୍‌ ତୁମିମଃନ୍ ଜଃନ୍‌କଃରି ତୁମିମଃନାର୍‌ ହାହ୍‌ କେମା ହାଉଁହାରାସ୍‌, ଇତାର୍‌ ଗିନେ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ବାଉଳି ଆସା । ");
INSERT INTO bdv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ମାପ୍ରୁର୍‌ ତଃୟ୍‌ହୁଣି ସୁସ୍ତାର୍‌ ବେଳା ଆସେଦ୍‌ ଆରେକ୍‌ ତୁମାର୍‌ ଗିନେ ହୁର୍ବେ ଟିକ୍‌ କଃଲା ହଃର୍କାରେ କ୍ରିସ୍ଟ ବଃଲେକ୍‌ ଜିସୁକେ ସେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ସଃବୁ ବିସୟ୍‌ର୍‌ ନଃଉଆଁ କଃର୍ତାର୍‌ ଜୁୟ୍‌ ବେଳାର୍‌ କଃତା ହୁର୍ବ୍‌କାଳେ ହୁଣି ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ପବିତ୍ର ବାବ୍‌ବାଦିମଃନାର୍‌ ମୁଏଁ କୟ୍‌ଆଚେ, ସେ ବେଳା ଆସ୍ତା ହଃତେକ୍‌ ଜିସୁକେ ସଃର୍ଗେ ରେଉଁକ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ଇ ବିସୟେ ମସା କୟ୍‌ ରିଲା ମାପ୍ରୁ ଇସ୍ୱର୍‌ ତୁମିମଃନାର୍‌ ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ତୁମାର୍‌ ଗିନେ ମର୍‌ ହର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦିକେ ହଃଟାୟ୍‌ଦ୍‌, ଜୁୟ୍‌ ଜୁୟ୍‌ କଃତା ସେ ତୁମିମଃନ୍‌କେ କୟ୍‌ଦ୍‌ ସେ ସଃବୁକଃତା ତୁମିମଃନ୍ ତାର୍‌ କଃତା ସୁଣୁକ୍‌ ହଃଳେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ମଃତର୍‌ ଅଃନ୍‌କାର୍‌ ଗଃଟେଦ୍‌ ଜେ ବାବ୍‌ବାଦିର୍‌ କଃତା ନଃସୁଣେ ସେ ଇସ୍ୱରାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ତାକେ ଅଃଲ୍‌ଗା କଃରି ନଃସ୍ଟ୍‌ କଃରାଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଜାୟ୍‌ରି ଅଃବେ ଗଃଟୁଲି ସାମୁଏଲ୍‌ ବାବ୍‌ବାଦି ଆର୍‌ ତାର୍‌ ହଃଚାର୍‌ ବଃଳ୍‌ହୁଣି ଜଃତେକ୍‌ ବାବ୍‌ବାଦି କଃତା କୟ୍‌ ଆଚ୍‌ତି ସେମଃନ୍ ସଃବୁ ହେଁ ଇ କାଳାର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ବାବ୍‌ବାଦି ମଃନାର୍‌ ତୁମିମଃନ୍ ସେ ବାବ୍‌ବାଦିର୍‌ ହିଲାମଃନ୍‌ ଆର୍‌ ତୁମାର୍‌ ବଃଉଁସ୍‌ ତଃୟ୍‌ହୁଣି ହୁର୍ତିବିର୍‌ ସଃବୁ ବାସାର୍‌ ଲକ୍‌ ଆସିର୍ବାଦ୍‌ ହାଉତି, ଇ କଃତା ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌କେ କୟ୍‌ରିଲା, ଆର୍‌ ତୁମିମଃନାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜୁୟ୍‌ ବିଦି କଃରି ରିଲା ତୁମିମଃନ୍ ସେ ନିୟମାର୍‌ ହିଲା ଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ସେତାର୍‌ ଗିନେ ଇସ୍ୱର୍‌ ତାର୍‌ ଦଃଙ୍ଗ୍‌ଳାକେ ବାଚିଆଚେ, ଜଃନ୍‌କଃରି ସେ ତୁମାର୍‌ ହଃତି ଲକ୍‌କେ ନିଜାର୍‌ ନିଜାର୍‌ ଦୁସ୍ଟ୍‌ ତଃୟ୍‌ହୁଣି ବାଉଳାୟ୍‌ ଆସିର୍ବାଦ୍‌ କଃରେଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ କଃତା କଃଉତାବଃଳ୍‌ ଜାଜକ୍‌ମଃନ୍ ମନ୍ଦିରାର୍‌ ହାଁଞ୍ଚ୍‌କଳି ସଃଇନ୍ ଉହ୍ରେ ବଃଡ୍ ସଃୟ୍‌ନ୍‌ ଆର୍‌ ସାଦୁକିମଃନ୍ ସେମଃନାର୍‌ ଚଃମେ ହଚ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ସେମଃନ୍ ରିସା ଅୟ୍‌ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ପେରିତ୍‌ମଃନ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେତି ରିଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ କଃତାକ୍‌ ଦଃରି ମଃଲା ଲକ୍‌ମଃନ୍ ଉଟ୍‌ତି ବଃଲି ପର୍ଚାର୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ଆର୍‌ ସେମଃନ୍ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ ଦଃରି ଆରେକ୍‌ ଗଟ୍‌ ଦିନ୍ ହଃତେକ୍‌ ଜଃଇଲେ ହୁରାୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃଡେବଃଳ୍‌ ସଃଞ୍ଜ୍ ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମଃତର୍‌ ସେମଃନାର୍‌ ସିକ୍ୟା ସୁଣିରିଲା ଗାଦେକ୍‌ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ ଆର୍‌ ଅଃଣ୍ଡ୍ରାଲକ୍‌ ହାଁଚ୍ ଅଃଜାର୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ତାର୍‌ ହଃଚାର୍‌ ଦିନ୍ ଜିଉଦିମଃନାର୍‌ ମୁଳିକା, ପାରାଚିନ୍ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନ୍ ଜିରୁସାଲମେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ସେତି ମୁଳ୍‌ ଜାଜକ୍‌ ହାନାନ୍, କୟାପା, ଜହନ୍‌, ଆଲେକ୍‌ଜେଣ୍ଡାର୍‌, ଆରେକ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ବଃଉଁସାର୍‌ ସଃବୁ ଲକ୍‌କେ ବେଟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ସେମଃନ୍ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ମଃଜାୟ୍‌ ଟିଆ କଃରାୟ୍‌ ହଃଚାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ତୁମି ଇରି କଃନ୍‌କଃରି କଃରୁଲାସ୍‌ ? କାର୍‌ ସଃକ୍ତିୟେ ଆର୍‌ କାର୍‌ ନାଉଁଏ ତୁମିମଃନ୍ ଇରି କଃରିଆଚାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ସେତାକ୍‌ ପିତର୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ଲକ୍‌ମଃନାର୍‌ ମୁଳିକା ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଜଦି ଆଜି ଅଃମିକ୍‌ ଇ ଚଟାକେ କଃରିରିଲା ନିକ କାମାର୍‌ ଗିନେ ହଃଚାର୍‌ଲାସ୍‌, ଆର୍‌ ସେ ଲକ୍‌ କଃନ୍‌କଃରି ଉଜ୍‌ ଅୟ୍‌ଆଚେ ବଃଲି ଜାଣୁକେ ମଃନ୍‌କଃରୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ତଃନ୍‌ଅଲେ ତୁମିମଃନ୍ ଆର୍‌ ସଃର୍ନେ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ ଜାଣତ୍‌ ଜୁୟ୍‌ ନାଜରିତାର୍‌ ଜିସୁ କ୍ରିସ୍ଟକେ ତୁମିମଃନ୍ କ୍ରୁସେ ମାରି ରିଲାସ୍‌, ତାକେ ଇସ୍ୱର୍‌ ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ଉଟାୟ୍‌ ଆଚେ, ତାର୍‌ ନାଉଁଏ ହେଁ ତାର୍‌ ତଃୟ୍‌ହୁଣି ଇ ଲକ୍‌ ଉଜ୍‌ ଅୟ୍‌ ତୁମିମଃନାର୍‌ ମୁଏଁ ଟିଆ ଅୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଇ ଜିସୁର୍‌ ବିସୟେ ସାସ୍ତରେ ଲେକା ଆଚେ, ଗଃର୍‌ ବାନ୍ଦୁମଃନ୍‌ ଜୁୟ୍‌ ଟେଳାକେ ମଃନ୍ ନଃକେଲାୟ୍‌, ମଃତର୍‌ ସେରି କନାର୍‌ ମୁଳ୍‌ ଟେଳା ଅୟ୍‌ଲି, ଇରି ସେ ଟେଳା । ");
INSERT INTO bdv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ତାକେ ଚାଡି କାର୍‌ ତଃୟ୍‌ ମୁକ୍ତି ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜାର୍‌ତଃୟ୍‌ ଆମିମଃନ୍‌କେ ମୁକ୍‌ଳୁକ୍‌ ଅୟ୍‌ଦ୍‌, ଅଃଗାସ୍‌ ତଃଳେ, ମାନାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ କାୟ୍‌ ନାଉଁ ଦିଆ ନୟେ । ");
INSERT INTO bdv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ସେମଃନ୍ ପିତର୍‌ ଆର୍‌ ଜହନାର୍‌ ସାସ୍‌ ଦଃକି ଆର୍‌ ସେମଃନ୍ ଜେ ସିକିତ୍‌ ନୟ୍‌ଲା ଲକ୍‌ ଆର୍‌ ଗ୍ୟାନ୍ ନୟ୍‌ଲା ଲକ୍‌, ଇରି ଜାଣି କାବା ଅୟ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ସେମଃନ୍ ଜିସୁର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌ ବଃଲି ସେମଃନ୍‌କେ ଚିନ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ଆର୍‌ ସେ ଉଜ୍‌ ଅୟ୍‌ଲା ଲକ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକି ତାକାର୍‌ ବିରଦେ କାୟ୍‌ରି କଃଉଁକେ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ତାର୍‌ହଃଚେ ସେମଃନ୍‌କେ ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ହୁଣି ବାରାୟ୍‌ ଜଃଉଁକେ କୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍ ତାକାର୍‌ ବିତ୍ରେ କଃତା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ଇ ଲକ୍‌ମଃନ୍‌କେ କାୟ୍‌କଃରୁଆଁ ?” କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଇମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଗଟେକ୍‌ ବଃଡ୍ କାବା ଅଃଉତା ଚିନ୍‌ମଃନ୍‌ ଅୟ୍‌ଆଚେ, “ଇରି ଜିରୁସାଲମାର୍‌ ସଃବୁ ଲକ୍‌ ଜାଣି ଆଚ୍‌ତି, ଅଃମିମଃନ୍‌ ସେରି ନାୟ୍‌ ବଃଲୁନାହାରୁ । ");
INSERT INTO bdv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମଃତର୍‌ ଇ କଃତାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ଟାଣେ ଅଃଦିକ୍‌ ଉର୍ଜି ନଃଉଅ, ଇତାର୍‌ ଗିନେ ଜିସୁର୍‌ ନାଉଁଏ କାକେ ହେଁ ନଃକଉଁକେ ସେମଃନ୍‌କେ ଜଃଗ୍ରାତ୍‌ କଃରାୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ହଃଚେ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ ଆରେକ୍‌ ବିତ୍ରେ କୁଦି ଜିସୁର୍‌ ନାଉଁଏ ମୁଳ୍‌କେ କଃତା ନଃକଉଁକେ ଆର୍‌ ସିକ୍ୟା ନଃଦେଉଁକେ ନିକକଃରି ଆଦେସ୍‌ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମଃତର୍‌ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲାୟ୍‌, “ଇସ୍ୱରାର୍‌ କଃତା ସୁଣ୍‌ତା ବାଦୁଲେ ତୁମିମଃନାର୍‌ କଃତା ସୁଣ୍‌ତାର୍‌ ମାପ୍ରୁର୍‌ ଆକାୟ୍‌ ଟିକ୍‌ କି ନାୟ୍‌, ସେରି ତୁମିମଃନ୍ ବିଚାର୍‌ କଃରି ଦଃକା । ");
INSERT INTO bdv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ଜାୟ୍‌ଜାୟ୍‌ରି ଦଃକିଆଚୁ ଆର୍‌ ସୁଣି ଆଚୁ, ସେରି ସଃବୁ ନଃକୟ୍‌କଃରି ରେଉଁନାହାରୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ସେତାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ସେମଃନ୍‌କେ ଡଃଣ୍ଡ୍‌ ଦେଉଁକ୍‌ କାୟ୍‌ ଉପାୟ୍‌ ନଃହାୟ୍‌ ସେମଃନ୍‌କେ ଚାଡି ଦିଲାୟ୍‌, ବଃଲେକ୍‌ ଜାୟ୍‌ରି ଗଃଟ୍‌ଲି ସେତାର୍‌ ଗିନେ ଲକ୍‌ ସଃବୁ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଜୁୟ୍‌ ଲକାର୍‌ ତଃୟ୍‌ ସେ ଉଜ୍‌ ଅୟ୍‌ଲା କାବା ଅଃଉତା ଚିନ୍‌ମଃନ୍‌ କଃରାଜାୟ୍‌ ରିଲି, ତାକେ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହୁଣି ଅଃଦିକ୍‌ ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ଜଃଇଲେ ହୁଣି ମୁକୁଳ୍‌ଲା ହଃଚେ, ତାକାର୍‌ ଦଃଳେ ଗଃଲାୟ୍‌ ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ଜାୟ୍‌ ଜାୟ୍‌ରି କୟ୍‌ରିଲାୟ୍‌, ସେରି ସଃବୁ ଜାଣାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିସ୍ୱାସି ମଃନ୍ ସେରି ସୁଣି ଏକ୍‌ମଃନେ ଇସ୍ୱର୍‌କେ ଆଉଲି ଅୟ୍‌ ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲାୟ୍‌, “ଏ ମାପ୍ରୁ ତୁୟ୍‌ ଅଃଗାସ୍‌, ହୁର୍ତିବି, ସଃମ୍‌ନ୍ଦ୍ ଆର୍‌ ସେ ବିତ୍ରେ ଆଚ୍‌ତା ସଃବୁ ବିସୟ୍‌କେ ଉବ୍‌ଜାୟ୍‌ ଆଚ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ତୁୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ଅଃମାର୍‌ ଉବା ଦାଉଦାର୍‌ ମୁଏଁ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ଇ କଃତା କୟ୍‌ଆଚ୍‌ସି ।” “ଅଜିଉଦିମଃନ୍‌ କାୟ୍‌ତାକ୍‌ ରିସା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଲକ୍‌ମଃନ୍ ସୁନେ ସୁନେ କୁଟ୍‌କଃଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ମାପ୍ରୁର୍‌ ବିରଦେ ଆର୍‌ ତାର୍‌ ବାଚ୍‌ଲା ଲକାର୍‌ ଆର୍‌ ମଃସିଆ ବିରଦେ ହୁର୍ତିବିର୍‌ ରଃଜାମଃନ୍ ଟିଆ ଅୟ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ସାସନ୍‌ କଃରୁମଃନ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁମାର୍‌ ଜୁୟ୍‌ ପବିତ୍ର ଦଃଙ୍ଗ୍‌ଳା ଜିସୁକେ ଅବିସେକ୍‌ କଃଲିସ୍‌ ସଃତ୍‌କଃରି ତାର୍‌ ବିରଦେ ହେରଦ୍‌ ରଃଜା ଆର୍‌ ପନ୍ତିଅପିଲାତ୍‌ ଜୁଳେକ୍‌ ଅଜିଉଦିମଃନ୍‌ ଆର୍‌ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଇ ଗଃଳେ, ");
INSERT INTO bdv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ତୁମାର୍‌ ସଃକ୍ତି ଆର୍‌ ତୁମାର୍‌ ଇଚା ହଃର୍କାରେ ଜୁଣ୍ ସଃବୁକଃତା ଗଃଟେଦ୍‌ ବଃଲି ହୁର୍ବେ ତିରକ୍‌ରା ଅୟ୍‌ରିଲି ସେରି କଃରୁକେ ଗଟେକ୍‌ତଃୟ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ଆର୍‌ ଅଃବେ ଏ ମାପ୍ରୁ ସେମଃନାର୍‌ ଉଳ୍‌ତାର୍‌ ଆର୍‌ ଗଃର୍ଞ୍ଜାଣ୍‌କେ ଦଃକ୍‌ ଆରେକ୍‌ ତର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌ ହୁରା ହୁସ୍ଟିସଃଙ୍ଗ୍ ତର୍‌ କଃତା କଃଉଁକେ ସାସ୍‌ ଦେ । ");
INSERT INTO bdv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ତର୍‌ ପବିତ୍ର ଦଃଙ୍ଗ୍‌ଳା ଜିସୁର୍‌ ନାଉଁଏ ଉଜ୍‌ କଃରୁକେ ଆର୍‌ ଚିନ୍ ଆର୍‌ କାବା ଅଃଉତା କାମ୍‌ମଃନ୍‌ କଃରୁକେ ତର୍‌ ଆତ୍‌ ମେଲାକଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ସେମଃନ୍ ପାର୍ତ୍‌ନା କଃଲା ହଃଚେ ଜୁୟ୍‌ତି ରୁଣ୍ଡି ରିଲାୟ୍‌ ସେଟାଣ୍ ଲଃଦ୍‌ବଃଦି ଗଃଲି, ଆରେକ୍‌ ସଃବୁଲକ୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ଅୟ୍‌ ବଃଡେ ସାସେ ଇସ୍ୱରାର୍‌ କଃତା କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ବିସ୍ୱାସ୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍ ଗଟେକ୍‌ ମଃନ୍ ଆର୍‌ ଗଟେକ୍‌ ହଃରାଣ୍ ଅୟ୍‌ ରେତିରିଲାୟ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ କେ ହେଁ ଅଃହ୍‌ଣାର୍‌ ଦଃନ୍‌କେ ନିଜାର୍‌ ବଃଲି କୟ୍‌ ନଃକେର୍ତି ରିଲାୟ୍‌, ମଃତର୍‌ ସେମଃନାର୍‌ ସଃବୁ ଦଃନାର୍‌ ସଃମାନ୍ ବାଗ୍ ହାଉତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ପେରିତ୍‌ମଃନ୍‌ ବଃଡେ ସଃକ୍ତିର୍‌ ସଃଙ୍ଗ୍ ଜିସୁର୍‌ ଉଟ୍‌ଲା ବିସୟେ ସାକି ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ସଃବ୍‌କାର୍‌ ଉହ୍ରେ ଇସ୍ୱରାର୍‌ ବଃଡେ ଦଃୟା ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ବଃଲେକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କାର୍‌ କାୟ୍‌ରି ଅକେଟ୍‌ ନଃରିଲି, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜଃତେକ୍‌ ଲକାର୍‌ ବୁୟ୍‌ଁ ଆର୍‌ ଗଃର୍‌ ରିଲି ସେମଃନ୍ ସେରି ବିକି ସଃର୍ନେ ଟଃକା ଆଣ୍‌ତି ରିଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ଆର୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଦେତି ରିଲାୟ୍‌ ଆର୍‌ ହଃତି ଲକ୍‌କେ ତାର୍‌ ଲଳା ହଃର୍କାରେ ବାଟା କଃରାଅଉତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ଆରେକ୍‌ ଜସେପ୍ ଲେବି ବଃଉଁସେ ଜଃଲମ୍‌ ଗଟେକ୍‌ ସାଇପ୍ରସ୍‌ ନାଉଁଆର୍‌ ଟାଣ୍ ଲକ୍‌ ଜାକେ ପେରିତ୍‌ମଃନ୍‌ ବର୍ନବା ବଃଲି ଆରେକ୍‌ ଗଟ୍‌ ନାଉଁ ସଃଙ୍ଗାୟ୍‌ ରିଲାୟ୍‌, ବଃଲେକ୍‌ “ଗଟ୍‌ଲକ୍‌ ଜେକି ସାସ୍‌ ଦଃୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ତାର୍‌ କଃଣ୍ଡେକ୍‌ ବୁୟ୍‌ଁ ରିଲି ସେ ବୁଇଁକେ ବିକିକଃରି ସଃବୁ ଟଃକା ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଆଣି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନିଅ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ମାୟ୍‌ଜି ସପିରାର୍‌ ସଃଙ୍ଗ୍ କଃତାଅୟ୍‌ କଃଣ୍ଡେକ୍‌ ବୁୟ୍‌ଁ ବିକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମଃତର୍‌ ହନନିଅ ତାର୍‌ ମାୟ୍‌ଜି ସଃଙ୍ଗ୍ କଃତାଅୟ୍‌, ବିକ୍‌ଲା ଟଃକାର୍‌ କଃତେକ୍‌ ଲୁକାୟ୍‌ ବାକି ଟଃକା ଆଣି ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ସେତାକ୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ଏ ହନନିଅ ପବିତ୍ର ଆତ୍ମା ଚଃମେ ମିଚ୍ କଃଉଁକେ ଆର୍‌ ବୁୟ୍‌ଁ ବିକ୍‌ଲା ଟଃକାର୍‌ କଃତେକ୍‌ ଲୁକାୟ୍‌ ସଃଙ୍ଗାଉଁକ୍‌ ସୟ୍‌ତାନ୍‌ ତର୍‌ ମଃନ୍‌କେ କାୟ୍‌ତାକ୍‌ ଅଃଦିକାର୍‌ କଃରି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ନଃବିକ୍‌ତା ହୁର୍ବେ ସେରି କାୟ୍‌ ତର୍‌ ନିଜାର୍‌ ଅୟ୍‌ନଃରିଲି ? ଆର୍‌ ବିକ୍‌ଲା ହଃଚେ ସେତିର୍‌ ଟଃକା କାୟ୍‌ ତୁମାର୍‌ ଅଃଦିକାରେ ନଃରିଲି ? ତଃବେ ତୁୟ୍‌ କାୟ୍‌ତାକ୍‌ ଇ ହର୍‌ ମଃନେ ବାବ୍‌ଲିସ୍‌ ? ତୁୟ୍‌ ମାନାୟ୍‌ର୍‌ ଚଃମେ ମିଚ୍ କୟ୍‌ଲିସ୍‌, ସେରି ନାୟ୍‌ ମଃତର୍‌ ଇସ୍ୱର୍‌ ଚଃମେ ମିଚ୍ କୟ୍‌ଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ଇ ସଃବୁ କଃତା ସୁଣ୍‌ଲା ଦାହ୍ରେ ହନନିଅ କଚାଳି ଅୟ୍‌ ତଃଳେ ଅଦ୍ରି ମଃଲା । ସେତାକ୍‌ ସେମଃନ୍ ଇ କଃତା ଜଃତେକ୍‌ ଲକ୍‌ ସୁଣ୍‌ଲାୟ୍‌ ସଃବୁ ଲକ୍‌ ବଃଡେ ଡିର୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଆର୍‌ ବେଣ୍ଡ୍ୟା ହିଲାମଃନ୍ ଆସି ତାକେ ହଃଚ୍ୟା ଗୁଳ୍ୟାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ତାକେ ହଃଦାୟ୍‌ ବୟ୍‌ ନଃୟ୍‌ ମଃସ୍‌ଣେ ତହ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ହାକାହାକି ତିନି ଗଃଟା ହଃଚେ ତାର୍‌ ଡକୁର୍ସି ଆୟ୍‌ଲି, ମଃତର୍‌ କାୟ୍‌ରି ଅୟ୍‌ଆଚେ ସେରି ଜାଣି ନଃରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର୍‌ ତାକେ ହଃଚାର୍ଲା, “କଃଉ ତ, ତୁମିମଃନ୍ କାୟ୍‌ ଅଃତେକ୍‌ ଟଃକାୟ୍‌ ଇ ବୁୟ୍‌ଁ ବିକି ରିଲାସ୍‌ ?” ସେ କୟ୍‌ଲି, “ସଃତେକ୍‌ ସେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ସେତାକ୍‌ ପିତର୍‌ ତାକେ କୟ୍‌ଲା, “ମାପ୍ରୁର୍‌ ଆତ୍ମାକେ କଃଟ୍‌ହାଳ୍‌ ବୁଜୁକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଗଟିକଃତା ଅୟ୍‌ଲାସ୍‌, ଦଃକ୍‌ ସେମଃନ୍ ତର୍‌ ଡକ୍ରାଦିକ୍‌ ମଃସ୍‌ଣେ ତହି ଆଚ୍‌ତି, ସେମଃନ୍ ଦୁଆର୍‌ଲଃଗେ ହଃଚ୍‌ଲାୟ୍‌ବେ । ଆର୍‌ ସେମଃନ୍ ତକ୍‌ ହେଁ ହଃଦାୟ୍‌ ବୟ୍‌ ନେତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ତଃତ୍‌କାଣ୍ ସେ ପିତରାର୍‌ ହାଦ୍‌ ତଳେ ଅଦୁର୍ଲି ଆର୍‌ ମଃଲି, ଆର୍‌ ବେଣ୍ଡ୍ୟାହିଲାମଃନ୍ ଗଃର୍‌ ବିତ୍ରେ ହୁରି ତାକେ ମଃଲାର୍‌ ଦଃକି ହଃଦାୟ୍‌ ବୟ୍‌ ନିଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ଡକ୍ରାସିର୍‌ ଚଃମେ ତହ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ସେତାକ୍‌ ସଃବୁ ମଣ୍ଡ୍‌ଳି ଆର୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ଇ ସଃବୁ କାବାଅଃଉତା କାମ୍‌ ଆର୍‌ ସଃକ୍ତି ଜାଣ୍‌ଲାୟ୍‌, ସେମଃନ୍ ସଃବୁ ବଃଡେ ଡିରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପେରିତ୍‌ମଃନାର୍‌ ଆତେ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଚିନ୍ ଆର୍‌ କାବାଅଉତା କାମ୍‌ କଃରାଗଃଲି, ଆର୍‌ ସଃବୁ ବିସ୍ୱାସି ଦଃଳ୍‌ ସଲ୍‌ମନାର୍‌ ମଣ୍ଡପେ ଗଟେତଃୟ୍‌ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ମଃତର୍‌ ବିନ୍ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କେ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେତି ଜଃଉଁକେ ସାସ୍‌ ନଃକେଲାୟ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେମଃନାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ମଃତର୍‌ ଆରେକ୍‌ ଅଃଦିକ୍‌ ଅଃଣ୍ଡ୍ରା ଆର୍‌ ମାୟ୍‌ଜିମଃନ୍‌ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌କଃରି ମାପ୍ରୁର୍‌ ବିସ୍ୱାସି ଦଃଳେ ମିସୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ଅଃନ୍‌କାର୍‌ ଅୟ୍‌ଲି ଜେ ପିତର୍‌ ଆସ୍ତା ବଃଳ୍‌ ତାର୍‌ ତଃୟ୍‌ ଜଃନ୍‌କଃରି ରଗିମଃନାର୍‌ ବିତ୍ରେ କାର୍‌ କାର୍‌ ଉହ୍ରେ ତାର୍‌ ସାୟ୍‌ ହଃଳେଦ୍‌ ଇତାର୍‌ ଗିନେ ଲକ୍‌ମଃନ୍ ରଗିମ୍‌ନଃକେ ହଃଦାୟ୍‌ ବୟ୍‌ ଆଣି ଟାଟାୟ୍‌ ଆର୍‌ କଃଟେ ସଳାଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲମାର୍‌ ଚାରିହାକାର୍‌ ଗଃଳେ ହୁଣି ଲକ୍‌ମଃନ୍ ରଗି ମଃନ୍‌କେ ଆର୍‌ ବିଟାଳ୍‌ ଆତ୍ମା ଦଃର୍ଲା ଲକ୍‌ମଃନ୍ ଗଟ୍‌ତଃୟ୍‌ ରୁଣ୍ଡ୍‌ତି ରିଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ଉଜ୍‌ ଅଃଉତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ହଃଚେ ମୁଳ୍‌ ଜାଜକ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍, ବଃଲେକ୍‌ ସାଦୁକି ଦଃଳ୍‌, ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଅଃକାର୍‌ ଅୟ୍‌ ଜଃବର୍‌ ରିସା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଆର୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ବାନ୍ଦି ନଃୟ୍‌ ଜଃଇଲେ ହୁରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମଃତର୍‌ ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ରାତି ବଃଳ୍‌ ଜଃଇଲାର୍‌ ଦୁଆର୍‌ ସଃବୁ ମେଲା କଃଲା, ଆର୍‌ ସେମ୍‌ନଃକେ ହଃଦାୟ୍‌ ବାର୍‌କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ଜାହା ଆର୍‌ ମନ୍ଦିରେ ଟିଆ ଅୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଇ ନଃଉଆଁ ଜିବନାର୍‌ କଃତା କଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ସେମଃନ୍ କଃତା ମାନି ସେମଃନ୍ ସଃକାଳ୍ୟା ମନ୍ଦିର୍‌ ବିତ୍ରେ ଜାୟ୍‌, ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ଇ ବିତ୍ରେ ମୁଳ୍‌ ଜାଜକ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍ ଆସି ଜିଉଦିମଃନାର୍‌ ବେରାଣେ ଆର୍‌ ଇସ୍ରାଏଲ୍‌ମଃନାର୍‌ ପାରାଚିନ୍ ମଃନ୍‌କେ କୁଦି ଗଟ୍‌ ଟାଣେ ରୁଣ୍ଡ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଜଃଇଲେ ଆଣୁକେ ଲକ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମଃତର୍‌ ଜାଗୁଆଳିମଃନ୍ ଜଃଇଲେ ସେମଃନ୍‌କେ ନଃମିଳାୟ୍‌ ବାଉଳି ଆସି ଜିଉଦି ବେରାଣେ କୟ୍‌ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ଅଃମିମଃନ୍‌ ଦଃକ୍‌ଲୁ ଜଃଇଲ୍‌ ଗଃର୍‌ ନିକକଃରି ଡାହି ଅୟ୍‌ଆଚେ, ଆର୍‌ ଦୁଆର୍‌ମଃନ୍‌କେ ଜାଗୁଆଳିମଃନ୍ ଟିଆ ଅୟ୍‌ ଆଚ୍‌ତି, ମଃତର୍‌ ଦୁଆର୍‌ ମେଲା କଃଲାକ୍‌ ବିତ୍ରେ ଅଃମିମଃନ୍‌ କାକେ ହେଁ ନଃହାୟ୍‌ଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଇ ସଃବୁ କଃତା ସୁଣି ମନ୍ଦିରାର୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ଅଃଦିକାରି ଆର୍‌ ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ପେରିତ୍‌ମଃନ୍‌କ୍‌ କାୟ୍‌ରି ଅୟ୍‌ଆଚେ ବଃଲି ତାକାର୍‌ ବୁଦି ବାଣା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଅଃଡେବଃଳ୍‌ ଗଟ୍‌ ଲକ୍‌ ଆସି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଦଃକା ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ତୁମିମଃନ୍ ଜଃଇଲେ ହୁରାୟ୍‌ ରିଲାସ୍‌, ସେମଃନ୍ ମନ୍ଦିରେ ଟିଆ ଅୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ସିକ୍ୟା ଦେଉଁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ସଃଡେବଃଳ୍‌ ମନ୍ଦିର୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ମୁଳ୍‌ ସଃୟ୍‌ନ୍‌ ତାର୍‌ ଜାଗୁଆଳିମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜାୟ୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଆରେକ୍‌ ଆଣ୍‌ଲାୟ୍‌, ମଃତର୍‌ ବଃଳ୍‌ମାଡ୍‌କଃରି ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃଉଁ ହାରେ ଲକ୍‌ମଃନ୍ ତାକାର୍‌ ଉହ୍ରେ ଟେଳା ମାର୍ତି, ସେତାକ୍‌ ଡିର୍ତି ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ସେମଃନ୍ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଆଣି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ଟିଆ କଃଲାୟ୍‌, ସେତାକ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଆମିମଃନ୍ ତୁମିମଃନ୍‌କେ ଜିସୁର୍‌ ନାଉଁଏ ସିକ୍ୟା ଦେଉଁକ୍‌ କଃତେକ୍‌ ମଃନା କଃରି ରିଲୁ, ମଃତର୍‌ ଦଃକା ତୁମିମଃନ୍ କାୟ୍‌ କଃରିଆଚାସ୍‌, ତୁମିମଃନ୍ ତୁମାର୍‌ ସିକ୍ୟା ଜିରୁସାଲମାର୍‌ ଚାରିହାକ୍‌ ଉର୍ଜି କଃଲାସ୍‌, ଆର୍‌ ସେ ଲକାର୍‌ ମଃର୍ନ୍‌ ଦଃସ୍‌ ଅଃମାର୍‌ ଉହ୍ରେ ଲାଦୁକ୍‌ ମଃନ୍‌କଃରୁଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ମଃତର୍‌ ପିତର୍‌ ଆର୍‌ ବିନ୍ ପେରିତ୍‌ମଃନ୍‌ କୟ୍‌ଲାୟ୍‌, ଅଃମି ବାୟ୍‌ଦ୍‌ରେ ମାନାୟ୍‌ମଃନାର୍‌ କଃତା ନଃମାନୁ, ଇସ୍ୱରାର୍‌ କଃତା ମାନୁନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଜୁୟ୍‌ ଜିସୁକ୍‌ ତୁମିମଃନ୍ କ୍ରୁସେ ମଃର୍ନେ ମାର୍ଲାସ୍‌, ଅଃମାର୍‌ ଦାଦିବାବୁର୍‌ ଇସ୍ୱର୍‌ ତାକେ ମଃର୍ନେ ହୁଣି ଉଟାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଆରେକ୍‌ ସେ ଜଃନ୍‌କଃରି ଇସ୍ରାଏଲ୍‌କେ ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ଆର୍‌ ହାହ୍‌ କେମା ଦଃୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ କାତା ଆତେ ତାକେ ଅଃଦିକାରି ଆର୍‌ ମୁକ୍ଳାଉତା ଲକ୍‌କଃରି ବଃଡ୍ କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଆର୍‌ ଆମିମଃନ୍ ଇ ସଃବୁ ବିସୟାର୍‌ ସାକି, ଆର୍‌ ଜୁୟ୍‌ ପବିତ୍ର ଆତ୍ମାକେ ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ କଃତା ମାନ୍‌ତା ଲକ୍‌ମଃନ୍‌କେ ଦଃୟ୍‌ଆଚେ, ସେ ହେଁ ସାକି । ");
INSERT INTO bdv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ଇ କଃତା ଜିଉଦି ବେରାଣାର୍‌ ଲକ୍‌ମଃନ୍ ସୁଣି ରିସା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍‌କେ ମଃର୍ନେ ମାରୁକ୍‌ କୁଟ୍‌ ହାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମଃତର୍‌ ଗମଲିଏଲ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ପାରୁସି, ସେ ଗଟେକ୍‌ ମସାର୍‌ ସାସ୍ତରାର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁ ଆର୍‌ ସଃବ୍‌କାର୍‌ ମାନ୍‌ତି ହାଉତା ଲକ୍‌, ସେ ବେରାଣେ ଟିଆଅୟ୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ହଃଦାୟ୍‌ ବାର୍‌କଃରୁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଆର୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍ କାୟ୍‌ରି କଃରୁକେ ମଃନ୍‌ କଃରୁଲାସ୍‌ ସେ କଃତାୟ୍‌ ଜାଗ୍ରତ୍‌ ଅଃଉଆ । ");
INSERT INTO bdv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇତାର୍‌ ହୁର୍ବେ ତିଉଦା ଅଃହ୍‌ଣାକ୍‌ ଗଟେକ୍‌ ବଃଡ୍‌ ଲକ୍‌ ବଃଲି କୟ୍‌ଲା, ଆର୍‌ ହାକାହାକି ଚାଲିସ୍‌ ଲକ୍‌ ତାର୍‌ ଦଃଳେ ରିଲାୟ୍‌, ମଃତର୍‌ ତାକେ ମାରା ଅୟ୍‌ଲି ଆର୍‌ ସେ ଚାଲିସ୍‌ ଲକ୍‌ ଜଃତ୍‌କଃତ୍‌ ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ତାର୍‌ କାମ୍‌ ହୁରୁଣ୍ ନୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତାର୍‌ହଃଚେ, ଲକ୍‌ଗଃଣ୍‌ତି କଃର୍ତା ବଃଳ୍‌ ଗାଲିଲିର୍‌ ଜିଉଦା ଲକ୍‌ମଃନ୍‌କେ ତାର୍‌ ଦଃଳେ ନିଲା, ଆର୍‌ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ କଃରାୟ୍‌ଲା । ତାକେ ହେଁ ମାରା ଅୟ୍‌ଲି । ଜଃତେକ୍‌ ଲକ୍‌ ତାର୍‌ ଦଃଳେ ରିଲାୟ୍‌ ସେମଃନ୍ ହେଁ ଜଃତ୍‌କଃତ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଅଃବେ ତୁମିମଃନ୍‌କେ କଃଉଁଲେ ଇ ପେରିତ୍‌ମଃନ୍‌କ୍‌ କାୟ୍‌ ନଃକେରି ଚାଡିଦିଆସ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ଜଃଜ୍‌ନା ଆର୍‌ କାମ୍‌ ଜଦି ମାନାୟ୍‌ ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌ ତଃବେ ସେରି ନଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମଃତର୍‌ ଜଦି ସେରି ଇସ୍ୱର୍‌ ତଃୟ୍‌ହୁଣି ଅୟ୍‌ ରଃୟ୍‌ଦ୍‌, ତଃବେ ସେମଃନ୍‌କେ କାୟ୍‌ରି କଃରୁକେ ନଃହାରାସ୍‌, କେଜାଣ୍ ଇସ୍ୱର୍‌ ବିରଦେ ଜୁଜ୍‌ କଃରୁଲାସ୍‌ ବଃଲି ଜାଣା ହଃଳେଦ୍‌ । ଜିଉଦି ବେରାଣାର୍‌ ଲକ୍‌ମଃନ୍ ଗମଲିଆର୍‌ କଃତା ମାନ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ସେମଃନ୍ ପେରିତ୍‌ମଃନ୍‌କ୍‌ କୁଦି କର୍ଡା ସଃଙ୍ଗ୍ ମାଡ୍ ମାର୍ଲାୟ୍‌ ଆର୍‌ ଜିସୁର୍‌ ନାଉଁଏ କଃତା ନଃକଉଁକ୍‌ କୟ୍‌କଃରି ଚାଡି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ସେତାକ୍‌ ଜିସୁର୍‌ ନାଉଁ ଗିନେ ଲିନ୍ଦା ହାଉଁକ୍‌ ଜୟ୍‌ଗ୍‌ ବଃଲି ଗଃଣା ଅୟ୍‌ଲାୟ୍‌, ସେତାକ୍‌ ସେମଃନ୍ ସଃର୍ଦା କଃରିକଃରି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ହୁଣି ବାରାୟ୍‌ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆର୍‌ ସେମଃନ୍ ହଃତି ଦିନ୍ ମନ୍ଦିରେ ଆର୍‌ ଗଃରେ ସିକ୍ୟା ଦେଉଁକ୍‌ ଆର୍‌ ଜିସୁ ଜେ କ୍ରିସ୍ଟ, ବଃଲେକ୍‌ ମୁକ୍ଳାଉତା ଲକ୍‌, ଇ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଜଃଡେବଃଳ୍‌ ଚେଲାମଃନ୍ ବୁତେକ୍‌ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ ସଃଡେବଃଳ୍‌ ଗ୍ରିକ୍‌ କଃଉତା ଜିଉଦିମଃନ୍ ଏବ୍ରି ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃଉଆକଇ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହଃତି ଦିନାର୍‌ କାଦି ବାଟା କଃର୍ତାବଃଳ୍‌ ସେମଃନାର୍‌ ରାଣ୍ଡିମଃନ୍‌କେ ନଃଦେଉଁଲାୟ୍‌ ବଃଲି ଗ୍ରିକ୍‌ ବାସା କଃଉତିରିଲା ଜିଉଦିମଃନ୍ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ସେତାକ୍‌ ବାରଗଟ୍‌ ଚେଲା ଦଃଳାର୍‌ ସଃବୁ ବିସ୍ୱାସି ମଃନ୍‌କେ କୁଦିକଃରି କୟ୍‌ଲାୟ୍‌ “ଇସ୍ୱରାର୍‌ କଃତା ପର୍ଚାର୍‌ ନଃକେରି କାଦି ବାଟା କଃର୍ତା ସେବାୟ୍‌ ଲାଗି ରେତାର୍‌ ନିକ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ବଃଲେକ୍‌ ଏ ବାୟ୍‌ବେଣିମଃନ୍, ଜୁୟ୍‌ମଃନ୍‌କ୍‌ ଆମିମଃନ୍ ଇ କାମ୍‌ କଃରାଉଁ ହାରୁ ଅଃନ୍‌କାର୍‌ ଡାକ୍‌ହୁଟା ଆର୍‌ ପବିତ୍ର ଆତ୍ମା ଆର୍‌ ଗ୍ୟାନେ ହୁରୁଣ୍ ସାତ୍‌ ଲକ୍‌କେ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ବାଚି ତିର୍‌ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ମଃତର୍‌ ଅଃମିମଃନ୍‌ ପାର୍ତ୍‌ନାୟ୍‌ ଆର୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ କଃର୍ତା ସେବା କାମେ ମଃନ୍‌ ଦଃୟ୍‌ ଲାଗିରେଉଁନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଇ କଃତା ସଃବ୍‌କାର୍‌ ମଃନ୍‌କେଗଃଲି ଆର୍‌ ସେମଃନ୍ ବିସ୍ୱାସ୍‌ ଆର୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ସ୍ତିପାନ୍‌ ନାଉଁଆର୍‌ ଲକ୍‌କେ ଆର୍‌ ପିଲିପ୍, ପର୍କର୍‌, ନିକାନର୍‌, ତିମନ୍, ପାର୍‌ମନା ଆର୍‌ ଆନ୍ତିଅକିଆର୍‌ ହୁର୍ବେ ଜିଉଦି ଦଃର୍ମ୍‌ ଦାରାୟ୍‌ ମିସିରିଲା ଅଜିଉଦି ନିକଲାୟ୍‌କେ ବାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ଆର୍‌ ପେରିତ୍‌ ମଃନାର୍‌ ମୁଏଁ ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ପାର୍ତ୍‌ନା କଃରି ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ ଆସିର୍ବାଦ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଇତାର୍‌ ହଃଚେ ଇସ୍ୱରାର୍‌ କଃତା ଅଃଦିକ୍‌ ପର୍ଚାର୍‌ ଅଃଉଁକେ ଦଃର୍ଲି, ଆର୍‌ ଜିରୁସାଲମେ ଜିସୁର୍‌ ଚେଲା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ଜାଜକ୍‌ ମଃନ୍‌ହେଁ ବିସ୍ୱାସ୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ସ୍ତିପାନ୍‌ ମାପ୍ରୁର୍‌ ଦଃୟାର୍‌ ସଃକ୍ତିୟେ ହୁର୍ନ୍‌ଅୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ବଃଡେ ବଃଡେ କାବା ଅଃଉତା କାମ୍‌ ସାଦୁନ୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମଃତର୍‌ ଲିବର୍ତିନ୍, କୁରିଣିୟ୍‌ ଆର୍‌ ଆଲେକ୍‌ଜେଣ୍ଡ୍ରିଆ ମଃନାର୍‌ ଗଃଳେମଃନ୍ ବାସା କଃର୍ତା ନାଉଁଏ ଡାକ୍‌ହୁଟା ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ କଃତେକ୍‌ ଲକ୍‌ ଆରେକ୍‌ କିଲିକିଆ ଆର୍‌ ଆସିଆର୍‌ କଃତେକ୍‌ ଲକ୍‌ ସ୍ତିପାନ୍‌ ସଃଙ୍ଗ୍ କଃତା କାଟାକାଟି ଅଃଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମଃତର୍‌ ସେ ଜୁୟ୍‌ ଆତ୍ମାର୍‌ ସଃକ୍ତିୟେ କଃତା କଃଉତି ରିଲା ସେମଃନ୍ ତାର୍‌ ବିରଦେ ଆରେକ୍‌ କଃଉଁ ନଃହାର୍ତିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଉସ୍‌କାୟ୍‌ଲାୟ୍‌ ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ଆମିମଃନ୍ ଇ ଲକ୍‌ ମସାର୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ବିରଦେ ଲିନ୍ଦା କଃତା କଃଉତାର୍‌ ସୁଣିଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଲକ୍‌ମଃନ୍‌କେ ଆର୍‌ ପାରାଚିନ୍ ଆର୍‌ ଦଃର୍ମ୍‌ ଗୁରୁମଃନକେ ରିସା କଃରାୟ୍‌ ତାକେ ବଃଳ୍‌ମାଡ୍ କଃରି ଦଃରି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ଆର୍‌ ମିଚ୍ ସାକିମଃନ୍‌କେ ଟିଆ କଃରାୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଇ ଲକ୍‌” ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌ ଇ ପବିତ୍ର ମନ୍ଦିର୍‌ ଆର୍‌ ମସାର୍‌ ବିଦି ବିରଦେ କଃତା କୟ୍‌ବୁଲୁଲା, ");
INSERT INTO bdv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ନାଜରିତାର୍‌ ସେ ଜିସୁ ଇ ମନ୍ଦିର୍‌ ବଃସମ୍‌ କଃରେଦ୍‌, ଆର୍‌ ଅଃମିକ୍‌ ଜୁୟ୍‌ ଜୁୟ୍‌ ମସା ରିତିବିଦି ଦଃୟ୍‌ ଆଚେ, ସେରି ସଃବୁ ବାଦ୍‌ଲାୟ୍‌ଦ୍‌ ବଃଲି ସେ କଃଉତାର୍‌ “ଅଃମିମଃନ୍‌ ସୁଣି ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ସଃଡେବଃଳ୍‌ ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ବଃସି ରିଲା ସଃବୁ ଲକ୍‌ ତାକେ ନିକକଃରି ଦଃକ୍‌ଲାୟ୍‌, ତାର୍‌ ମୁଁ ଦୁତାର୍‌ ମୁଁ ହର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ସେତାକ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ସ୍ତିପାନ୍‌କେ ହଃଚାର୍ଲା “ତର୍‌ବିରଦେ ଇରି କାୟ୍‌ ସଃତ୍‌ କି ?” ");
INSERT INTO bdv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସେ କୟ୍‌ଲା, ଏ ବାୟ୍‌ ଆର୍‌ ଉବାମଃନ୍‌ ସୁଣା, ଅଃମାର୍‌ ଉବା ଅବ୍ରାହାମ୍‌ ହାରଣ୍‌ ତଃୟ୍‌ଁ ବାସାକ୍‌ର୍ତା ଦାଦା ସଃଡେବଃଳ୍‌ ସେ ମେସପଟାମିଆ ରିଲା, ସଃଡେବଃଳ୍‌ ଜଃଜ୍‌ମାନ୍‌ ଇସ୍ୱର୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଆର୍‌ ତାକେ କୟ୍‌ଲା ତୁୟ୍‌ ତର୍‌ ଦେସେ ହୁଣି ଅଃହ୍‌ଣାର୍‌ ନିଜାର୍‌ ଲକ୍‌ତଃୟ୍‌ ହୁଣି ବାରାୟ୍‌ ଆଉ ଆରେକ୍‌ ଅଃମି ତକ୍‌ ଜୁୟ୍‌ ଦେସ୍‌ ଦଃକାଉଁନ୍ଦ୍ ସେ ଦେସେ ଜାଆ । ");
INSERT INTO bdv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ସେତାକ୍‌ ତାର୍‌ କଲଦିଅ ଦେସେ ହୁଣି ବାରାୟ୍‌ ସେ ହାରଣ୍‌ ତଃୟ୍‌ଁ ବାସା କଃଲା, ହଃଚେ ଅବ୍ରାହାମ୍‌ ଉବାସି ମଃଲାକେ ସେତି ହୁଣି ତୁମିମଃନ୍ ଅଃବେ ଜୁୟ୍‌ ଦେସେ ବାସା କଃରିଆଚାସ୍‌ ଇସ୍ୱର୍‌ ତାକେ ଇ ଦେସେ ଆଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଆର୍‌ ସେ ତାକେ ସେତି କାୟ୍‌ ଅଃଦିକାର୍‌ ନଃଦିଲା, ଗଟେକ୍‌ ହାଦାର୍‌ ବୁୟ୍‌ଁ ହେଁ ନଃଦିଲା, ଆରେକ୍‌ ସଃଡେବଃଳ୍‌ ତାର୍‌ ହଅ ନଃରିଲାକ୍‌ ହେଁ ସେ ତାକେ ଆର୍‌ ତାର୍‌ ଆଗାଳିର୍‌ ବଃଉଁସ୍‌କେ ସେରି ଅଃଦିକାର୍‌ କଃରୁକେ ଦଃୟ୍‌ନ୍ଦ୍ ବଃଲି ସଃୟ୍‌ତ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌କେ କୟ୍‌ଲା, ତୁମାର୍‌ ବଃଉଁସ୍‌ ବିନ୍ ଦେସେ ବାସା କଃରାସ୍‌ ଆର୍‌ ସେତିର୍‌ ଲକ୍‌ ତାକେ ଚାରିସ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା କଃରି ସେମଃନ୍‌କେ ଡଃଣ୍ଡ୍‌ ଦେତି । ");
INSERT INTO bdv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ଆରେକ୍‌ ଇସ୍ୱର୍‌ କୟ୍‌ଲା ସେମଃନ୍ ଜୁୟ୍‌ ବାସାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳା ଅଃଉତି ଅଃମି ତାର୍‌ ବିଚାର୍‌ କଃରୁନ୍ଦ୍‌, ତାର୍‌ହଃଚେ ସେମଃନ୍ ବାରାୟ୍‌ ଆସି ଇ ଟାଣେ ଅଃମାର୍‌ ସେବା କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ଆର୍‌ ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌କେ ସୁନତି ବିଦି ଦିଲା, ଆରେକ୍‌ ସେନ୍‌କାର୍‌ ଅବ୍ରାହାମ୍‌, ଇସାକ୍‌କେ ଜଃଲମ୍‌ ଦଃୟ୍‌ ଆଟ୍‌ଦିନ୍ ଅୟ୍‌ଲାକ୍‌ ସୁନତ୍‌ କଃଲା, ଜିସହାକ୍‌ ଜାକୁବକେ ଆର୍‌ ଜାକୁବକ୍‌ ବାରଗଟ୍‌ ହିଲା ବଃଲେକ୍‌ ବାର କୁଳ୍‌ବଃଉଁସ୍‌କେ ଜଃଲମ୍‌ ଦଃୟ୍‌ ସୁନତ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବର୍‌ ହୟ୍‌ସିମଃନ୍ ତାର୍‌ ବାୟ୍‌ସି ଜସେପ୍‌କେ ଅଃକାର୍‌ ଅୟ୍‌ ତାକେ ମିସର୍‌ ଦେସେ ଗତିଦଃଙ୍ଗ୍‌ଳା କଃରି ବିକ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଇସ୍ୱର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଆର୍‌ ତାର୍‌ ସଃବୁ କଃସ୍ଟେ ତାକେ ମୁକ୍ଳାୟ୍‌ ମିସରାର୍‌ ରଃଜା ପାରର୍‌ ମୁଏଁ ତାକେ ଦଃୟା ଆର୍‌ ଗ୍ୟାନ୍ ଦିଲା, ସେତାକ୍‌ ପାର ରଃଜା ତାକେ ମିସର୍‌ ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଗଃରାର୍‌ ଗୁମୁସ୍ତା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ହଃଚେ ସଃବୁ ମିସର୍‌ ଆର୍‌ କିଣାନ୍ ଦେସେ କଃତାର୍‌ ଅୟ୍‌ଲି ଆରେକ୍‌ ବଃଡ୍ କଃସ୍ଟ୍‌ ଅୟ୍‌ଲି ଆର୍‌ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ କାଦି ହାଉଁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମଃତର୍‌ ମିସର୍‌ ଦେସେ କାଦି ଆଚେ ବଃଲି ସୁଣି ଜାକୁବ ତାର୍‌ ହୟ୍‌ସି ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍‌କେ ସେତି ହଃର୍ତୁ ତର୍‌ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ଆରେକ୍‌ ହଃଚାର୍‌ତର୍‌ ଜସେପ୍ ଅଃହ୍‌ଣାର୍‌ ବାୟ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଚିନାୟ୍‌ ଅୟ୍‌ଲା ଆର୍‌ ପାର ରଃଜା ଜସେପାର୍‌ କୁଟୁମ୍‌କେ ଜାଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ସେତାକ୍‌ ଜସେପ୍ ଅଃହ୍‌ଣାର୍‌ ଉବାସି ଜାକୁବକେ ଆର୍‌ ତିନିକଳିହଃନ୍ଦ୍ର ତାକାର୍‌ କୁଟୁମ୍‌ ସଃବ୍‌କେ ମିସର୍‌ ଦେସେ କୁଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ସେତାକ୍‌ ଜାକୁବ ମିସର୍‌ ଦେସେ ଗଃଲା ସେତି ଜାକୁବ ଆର୍‌ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ମଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଆର୍‌ ସେମଃନାର୍‌ ମଃଲା ଗଃଗାଳ୍‌କେ ସିକିମ୍‌କେ ନିଆଗଃଲି, ଆର୍‌ ଅବ୍ରାହାମ୍‌ ସେତି ହମର୍‌ ଲକ୍‌ମଃନ୍ ତଃୟ୍‌ହୁଣି ଜୁୟ୍‌ ମଃସୁଣ୍‌ହଃଦା ରୁହା ଟଃକା ଦଃୟ୍‌ ଗେନିରିଲା ସେମଃନ୍‌କେ ସେତି ତହ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ମଃତର୍‌ ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌କେ ଜୁୟ୍‌ ସଃୟ୍‌ତ୍‌ କଃରିରିଲା ସେ ସଃୟ୍‌ତ୍‌ ହୁରୁଣ୍ ଅଃଉତା ବେଳା ଅୟ୍‌ଲାକ୍‌ ଲକ୍‌ମଃନ୍ ମିସର୍‌ ଦେସେ ବଂସ୍‌ ବାଡି ଗାଦେକ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ସଃରାସଃରି ମିସର୍‌ ଦେସେ ଆରେକ୍‌ ଗଟ୍‌ ରଃଜା ଅୟ୍‌ଲା, ସେ ଜସେପ୍ ଜାଣି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ସେ ପାର ରଃଜା ଅଃମିମଃନାର୍‌ ଜାତିକ୍‌ ନିଚ୍ ଦଃକ୍‌ଲା ଆରେକ୍‌ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହିଲାମଃନ୍‌କେ ମଃର୍ନେ ମାରି ହଃଦାୟ୍‌ ହଃକାଉଁକ୍‌ ସେମଃନ୍‌କେ କଃସ୍ଟ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ସଃଡେବଃଳ୍‌ ମସା ଜଃଲମ୍‌ ଅୟ୍‌ଲା ସେ ଇସ୍ୱରାର୍‌ ଆକାୟ୍‌ ବଃଡେ ସୁନ୍ଦୁର୍‌ ରିଲା ଆର୍‌ ତିନିମାସ୍‌ ହଃତେକ୍‌ ଅଃହ୍‌ଣାର୍‌ ଉବାସି ଗଃରେ ବାଡ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ହଃଚେ ଜଃଡେବଃଳ୍‌ ହଃଦାୟ୍‌ ହଃଳ୍‌ଲା ସଃଡେବଃଳ୍‌ ପାରର୍‌ ଜିସି ତାକେ ବେଟିଆଣ୍‌ଲି ଆର୍‌ ତାର୍‌ ନିଜାର୍‌ ହୟ୍‌ସି ହର୍‌ ବାଡାୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ଆର୍‌ ମସା ମିସରାର୍‌ ସଃବୁ ଗିଆନେ ସିକିତ୍‌ ଅୟ୍‌ଲା, ଆର୍‌ କଃତାୟ୍‌ ଆର୍‌ କାମେ ବଃଡେ ଡାକ୍‌ହୁଟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ମସାକ୍‌ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଲାକ୍‌ ଅଃହ୍‌ଣାର୍‌ ତାର୍‌ ନିଜାର୍‌ ଇସ୍ରାଏଲ୍‌ ବାୟ୍‌ ମଃନ୍‌କେ ଜାଣୁକେ ତାର୍‌ ମଃନ୍ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ସଃଡେବଃଳ୍‌ ଗଟ୍‌ ଲକ୍‌କେ ଅଃନ୍ୟାୟ୍‌ କଃର୍ତାର୍‌ ଦଃକି ସେ ତାର୍‌ ବାଟ୍‌ ଆୟ୍‌ଲା ଆର୍‌ ସେ ମିସରାର୍‌ ଲକ୍‌କେ ମଃର୍ନେ ମାର୍ଲା ଆର୍‌ ନ୍ୟାୟ୍‌ ହାଉତା ଲକ୍‌କେ ଉହ୍‌କାର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ତାର୍‌ ଆତେ ଇସ୍ୱର୍‌ ତାର୍‌ ବାୟ୍‌ମଃନ୍‌କେ ମୁକ୍ଳାଉଁଲା ଇତି ଲକ୍‌ମଃନ୍ ଜାଣ୍‌ଲାୟ୍‌ ବଃଲି ମସା ମଃନେମଃନେ ବାବ୍‌ତି ରିଲା, ମଃତର୍‌ ତାର୍‌ ବାୟ୍‌ମଃନ୍ ବୁଜୁ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ଆର୍‌କ ଦିନ୍ ସେମଃନ୍ ମାଡଗଳ୍‌ ଅଃଉତାର୍‌ ଦଃକି ସେମଃନ୍‌କେ ସୁସ୍ତାୟ୍‌ ମିସାଉଁକେ ମସା କୟ୍‌ଲା, ତୁମିମଃନ୍ ଇସ୍ରାଏଲ୍‌ ବାୟ୍‌ ବାୟ୍‌ ଅୟ୍‌ ହେଁ କାୟ୍‌ତାକ୍‌ ଅଃନ୍ୟାୟ୍‌ କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ମଃତର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଅଃନ୍ୟାୟ୍‌ କଃର୍ତିରିଲା ସେ ମସାକ୍‌ ହେଲାୟ୍‌ କୟ୍‌ଲା, କେ ତକ୍‌ ଅଃମାର୍‌ ଉହ୍ରେ ବିଚାର୍‌ କଃରୁକେ ଅଃଦିକାରି ହଃଦ୍‌ ଦଃୟ୍‌ଆଚେ ? ");
INSERT INTO bdv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ତୁୟ୍‌ କାଲି ଜଃନ୍‌କଃରି ସେ ମିସରାର୍‌ ଲକ୍‌କେ ମଃର୍ନେ ମାର୍ଲିସ୍‌ ସେନ୍ କାୟ୍‌ ମକ୍‌ ମାରୁକ୍‌ ମଃନ୍ କଃରୁଲିସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ଇ କଃତା ସୁଣି ମସା ହଃଳାୟ୍‌ ଜାୟ୍‌ ମିଦିୟନ୍ ଦେସେ ବାସା କଃଲା, ସେତି ତାର୍‌ ଜଳେକ୍‌ ହୟ୍‌ସି ଜଃଲମ୍‌ ଅୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ହଃଚେ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଲାକ୍‌ ସିନୟ୍‌ ହଃର୍ବାତ୍‌ ତଃୟ୍‌ ଗଟେକ୍‌ ଜୟ୍‌ଲାଗତା ବୁଟାୟ୍‌ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ ତାକେ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମସା ସେରି ଦଃକି କାବା ଅୟ୍‌ଲା ଆର୍‌ ନିକକଃରି ଦଃକୁକ୍‌ ଚଃମେ ଜାତା ବଃଳ୍‌ ମାପ୍ରୁର୍‌ ଇ କଃତା ସୁଣାଗ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ଅଃମି ତୁମାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌, ଇସାକ୍‌ ଆର୍‌ ଜାକୁବର୍‌ ଇସ୍ୱର୍‌, ସେତାକ୍‌ ମସା ଦଃଲ୍‌କିଗଃଲା ଆର୍‌ ନିକକଃରି ଦଃକୁକ୍‌ ସାସ୍‌ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ତାର୍‌ହଃଚେ ମାପ୍ରୁ ତାକେ କୟ୍‌ଲା ତର୍‌ ହାଦେ ହୁଣି ହାଣ୍ଡାୟ୍‌ କୁସ୍ଳାଉ କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ତୁୟ୍‌ ଜୁୟ୍‌ ଟାଣେ ଟିଅୟ୍‌ ଆଚ୍‌ସି ସେରି ପବିତ୍ର ମାଟି । ");
INSERT INTO bdv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସର୍‌ ଦେସେ ଅଃମାର୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଆଚ୍‌ତି ସେମଃନାର୍‌ କଃସ୍ଟ୍‌ ଦଃକି ଆଚି ଆର୍‌ ସେମଃନାର୍‌ କାନ୍ଦ୍‌ତାର୍‌ ସୁଣିଆଚି ଆରେକ୍‌ ସେମଃନ୍‌କେ ମୁକ୍ଳାଉଁକ୍‌ ଉତ୍ରି ଆସି ଆଚି ଆର୍‌ ଅଃବେ ଅଃମି ତକ୍‌ ‘ମିସର୍‌ ଦେସେ ହଃଟାୟ୍‌ନ୍ଦ୍ ।’” ");
INSERT INTO bdv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“କେ ତକ୍‌ ରାଜ୍‌ କଃରୁକେ ଆର୍‌ ବିଚାର୍‌ କଃରୁକେ ମୁଳିକା ହଃଦ୍‌ ଦିଲା ବଃଲି ଜୁୟ୍‌ ମସାକ୍‌ ସେମଃନ୍ ମଃନ୍ ନଃକେଲାୟ୍‌ ତାକେ ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ ବୁଟାୟ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ରିଲା, ତୁୟ୍‌ ତାର୍‌ ଉହ୍‌କାର୍‌ କଃରୁକେ ମୁକ୍ଳାଉତା ଲକ୍‌ କଃରି ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ଲକ୍‌ମଃନ୍‌କେ ମିସର୍‌ ଦେସ୍‌, ସୁପ୍‌ସାଗଃର୍‌ ଆର୍‌ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ କାବା ଅଃଉତା କାମ୍‌ ଆର୍‌ ଚିନ୍‌ମଃନ୍‌ ଦଃକାୟ୍‌ ସେମଃନ୍‌କେ ବାର୍‌କଃରି ଆଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ଇ ମସା ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, ଇସ୍ୱର୍‌ ତୁମିମଃନାର୍‌ ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ତୁମାର୍‌ ଗିନେ ମର୍‌ ହର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦିକେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଇ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ମଣ୍ଡ୍‌ଳି ବିତ୍ରେ ରଃୟ୍‌ ସିନୟ୍‌ ହଃର୍ବାତେ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତା କଃର୍ତିରିଲା, ଦୁତାର୍‌ ଆର୍‌ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ବିତ୍ରେ ମଃଜାୟ୍‌ ଅୟ୍‌ରିଲା, ସେ ତୁମିମଃନ୍‌କେ ଦେଉଁକ୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍‌ ହାୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ଅଃମିମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍ ତାର୍‌ କଃତା ମାନୁକ୍‌ ମଃନ୍ ନଃକେରି, ତାକେ ଚାଡ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ମିସର୍‌କେ ବାଉଳି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଆର୍‌ ହାରଣ୍‌କେ କୟ୍‌ଲାୟ୍‌ ଅଃମାର୍‌ ଆଗେ ଆଗେ ଜଃଉଁକେ ଅଃମାର୍‌ ଗିନେ ଦେବ୍‌ତାମଃନ୍‌କେ ତିଆର୍‌ କଃର୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇ ଜୁୟ୍‌ ମସା ଆମିମଃନ୍‌କେ ମିସର୍‌ ଦେସେ ହୁଣି ବାର୍‌କଃରି ଆଣ୍‌ଲା ତାର୍‌ କାୟ୍‌ରି ଆଚେ ଅଃମି ନଃଜାଣୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଆର୍‌ ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ଗଟେକ୍‌ ବାଚିମୁର୍ତି ହାଜ୍‌ଲାୟ୍‌, ଆର୍‌ ସେ ମୁର୍ତିକେ ହୁଜା ଦଃୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆତେ ତିଆର୍‌ କଃଲା ଆସ୍ତିକ୍‌ ମାନି ବଜିକଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ମଃତର୍‌ ଇସ୍ୱରାର୍‌ ତଃୟ୍‌ହୁଣି ଇସ୍ୱରାର୍‌ ସେବା କଃରୁକେ ଚାଡିକଃରି ସେମଃନ୍ ଅଃଗାସାର୍‌ ହୁଜା କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ଜଃନ୍‌କଃରି ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ- “ଏ ଇସ୍ରାଏଲ୍‌ ବଃଉଁସ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ତୁମିମଃନ୍ କାୟ୍‌ ଅଃମାର୍‌ ଗିନେ ମେଣ୍ଡା ହୁଜା ଆର୍‌ ହସୁହୁଜା ଦଃୟ୍‌ନଃରିଲାସ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","‘ତଃବେ ତୁମିମଃନ୍ ସେବା କଃରୁକେ ଜୁୟ୍‌ ହୁତ୍‌ଳା ସଃବୁ ତିଆର୍‌ କଃରି ରିଲାସ୍‌, ସେ ମାଲେକ୍‌ ଦେବ୍‌ତାର୍‌ ତୁମ୍ବ୍ ଆର୍‌ ରମ୍ପା ଦେବ୍‌ତାର୍‌ ତାରାକେ ତୁମିମଃନ୍ ବୟ୍‌ଲାସ୍‌ । ଇତାକ୍‌ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ବାନ୍ଦିକଃରି ବାବିଲନ୍ ତଃୟ୍‌ର୍‌ ସେହାଟି ହଃଟାୟ୍‌ନ୍ଦ୍ ।’” ");
INSERT INTO bdv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ତୁମି ଜୁୟ୍‌ ନିକ କଃତା ଦଃକାୟ୍‌ ଆଚାସ୍‌ ସେନ୍‌କାର୍‌ ସାକ୍ୟତୁମ ତିଆର୍‌ କଃରା ବଃଲି ମସାକ୍‌ ଜେ କୟ୍‌ରିଲା ତାର୍‌ କଃତାୟ୍‌ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ସାକ୍ୟତୁମ୍ବ୍ ତିଆର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ହଃଚେ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନ୍ ସେମଃନାର୍‌ ଦାଦିବାବୁ ତଃୟ୍‌ହୁଣି ହାୟ୍‌ରିଲା ସେ ସାକ୍ୟତୁମ୍ବ୍ କେ ଜିହସୟ୍‌ ସଃଙ୍ଗ୍ ବୟ୍‌ନଃୟ୍‌ ଆଗେ ଆଗେ ଗଃଳାୟ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌ ବାର୍‌କଃଲା ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଦେସ୍‌ ଅଃଦିକାର୍‌ କଃଲାୟ୍‌, ସେରି ଦାଉଦାର୍‌ ଦିନ୍ ହଃତେକ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ସେ ଇସ୍ୱରାର୍‌ ଆକାୟ୍‌ ଦଃୟା ଦଃକାୟ୍‌ ଅୟ୍‌ରିଲା ଆର୍‌ ଜାକୁବର୍‌ ଇସ୍ୱରାର୍‌ ଗିନେ ଗଟେକ୍‌ କୁଳ୍ୟା ଗଃର୍‌ ବାନ୍ଦୁକେ ପାର୍ତ୍‌ନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ମଃତର୍‌ ସଲ୍‌ମନ୍ ତାର୍‌ ଗିନେ ଗଟେକ୍‌ ମନ୍ଦିର୍‌ ବାନ୍ଦ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ଅୟ୍‌ଲେକ୍‌ ହେଁ ବାବ୍‌ବାଦି କୟ୍‌ଆଚେ, ‘ସଃର୍ଗାର୍‌ ଇସ୍ୱର୍‌ ସେ ଲକ୍‌ମଃନାର୍‌ ବାନ୍ଦ୍‌ଲା ମନ୍ଦିରେ ବାସା ନଃକେରେ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ମାପ୍ରୁ କୟ୍‌ଆଚେ, ‘ଜଃନ୍‌କଃରି ସଃର୍ଗ୍‌ ଅଃମାର୍‌ ସିଙ୍ଗାସଣ୍‌ ହୁର୍ତିବି ଅଃମାର୍‌ ହାଦ୍‌ ସଃଙ୍ଗାଉତା ଟାଣ୍ । ତୁମିମଃନ୍ ଅଃମାର୍‌ ଗିନେ କଃନ୍‌କା ଗଃର୍‌ ବାନ୍ଦାସ୍‌ ? କି ଅଃମାର୍‌ ବିସାଉତା ଟାଣ୍ କଃୟ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ଅଃମାର୍‌ ଆତ୍‌ କାୟ୍‌ ଇରି ସଃବୁ ଉବ୍‌ଜାୟ୍‌ ନଃକେରେ ?’” ");
INSERT INTO bdv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିପାନ୍‌ କୟ୍‌ଲା, “ଏ ସୁନତ୍‌ ନୟ୍‌ଲା ଅମାନ୍ୟା ମଃନ୍ ଲକ୍‌ମଃନ୍, ତୁମିମଃନ୍ ବଃୟ୍‌ରା ଲକ୍‌, ସଃବୁବଃଳ୍‌ ପବିତ୍ର ଆତ୍ମାର୍‌ ବିରଦ୍‌ କଃରୁଲାସ୍‌, ତୁମିମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍ ଜଃନ୍‌କାର୍‌ ତୁମିମଃନ୍ ହେଁ ସେନ୍‌କାର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ବାବ୍‌ବାଦିମଃନାର୍‌ ବିତ୍ରେ କାକେ ତୁମିମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍ କାକେ କଃସ୍ଟ୍‌ ଦଃୟ୍‌ ନଃରିଲାୟ୍‌ କି ? ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସେ ଦଃର୍ମି ଲକାର୍‌ ଆସ୍ତା କଃତା ହୁର୍ବେ ଜାଣାୟ୍‌ ରିଲା ସେମଃନ୍‌କେ ସେମଃନ୍ ମଃର୍ନେ ମାର୍‌ଲାୟ୍‌, ଅଃବେ ତୁମିମଃନ୍ ଜିସୁକେ ସଃତ୍ରୁର୍‌ ଆତେ ସଃହ୍ରି ମଃର୍ନେ ମାରି ଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ତୁମିମଃନ୍ ସଃର୍ଗାର୍‌ ଦୁତ୍‌ମଃନ୍ ତଃୟ୍‌ହୁଣି ଦିଲା ଇସ୍ୱରାର୍‌ ବିଦିବିଦାନ୍ ହାୟ୍‌ ଆଚାସ୍‌, ମଃତର୍‌ ମାନି ନଃକେଲାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ଇ ସଃବୁ କଃତା ସୁଣି ବେରାଣେ ବଃସ୍‌ଲା ଲକ୍‌ମଃନ୍ ମଃନେମଃନେ ବାଦା ହାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସ୍ତିପାନ୍‌କେ ରିସାଅୟ୍‌ ଦାତ୍‌ଚାବୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମଃତର୍‌ ସେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ସଃର୍ଗ୍‌ ହାକ୍‌ ନିକକଃରି ଅଃନ୍ୟାୟ୍‌ ଦଃକ୍‌ଲା ଆର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଆର୍‌ ଜିସୁକେ ଇସ୍ୱରାର୍‌ କାତା ବାଟ୍ୟା ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ଦଃକା ମୁୟ୍‌ଁ ସଃର୍ଗ୍‌ ମେଲା ଅଃଉତାର୍‌ ଆର୍‌ ନଃରାର୍‌ ହୟ୍‌ସିକ୍‌ ଇସ୍ୱରାର୍‌ କାତା ବାଟ୍ୟା ଟିଆ ଅୟ୍‌ରିଲାର୍‌ ଦଃକୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ମଃତର୍‌ ସେମଃନ୍ ମୁଁ ଟାଣ୍‌କଃରି ବଃଡ୍‌ ଟଣ୍ଡ୍‌କଃରି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ କାନ୍‌ ମୁଦି ଅୟ୍‌ଲାୟ୍‌ ସେମଃନ୍ ଅଃକା ସଃଙ୍ଗ୍ ଦବ୍ଳି ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ତାର ଉହ୍ରେ ମାଡିବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଆରେକ୍‌ ସେମଃନ୍ ତାକେ ଗଃଳେ ହୁଣି ବାର୍‌କଃରି ନଃୟ୍‌ ଟେଳାସୁତ୍ରି ମାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ସାକିମଃନ୍ ସାଉଲ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ବେଣ୍ଡ୍ୟାର୍‌ ହାଦ୍‌ ତଃଳେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ସଃଙ୍ଗାୟ୍‌ ଲାୟ୍‌ ");
INSERT INTO bdv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ସ୍ତିପାନ୍‌କେ ଟେଳା ସୁତ୍ରି ମାର୍ତି ରିଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ସ୍ତିପାନ୍‌ ପାର୍ତ୍‌ନା କଃରି କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ ଜିସୁ ମର୍‌ ଆତ୍ମା ନେ” ");
INSERT INTO bdv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଆରେକ୍‌ ସେ ମାଣ୍ଡିକୁଟା ଟେସି ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି ଆଉଲି ଅୟ୍‌ କୟ୍‌ଲା, ଏ ମାପ୍ରୁ, ଇ ହାହ୍‌ ଇମଃନାର୍‌ ବିରଦେ ଗଃଣ୍‌ନା କଃର୍‌ ନାୟ୍‌ । ସେ ଇରି କୟ୍‌ ହଃରାଣ୍ ଚାଡ୍‌ଲା । ସାଉଲ୍‌ ସ୍ତିପାନାର୍‌ ମଃର୍ନ୍‌ ଦଃକୁକ୍‌ ମଃନ୍‌ କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ସାଉଲ୍‌ ସ୍ତିପାନାର୍‌ ଜିବନ୍‌ ନାସ୍‌ କଃରୁକେ ମଃନ୍‌ରିଲି, ସେଦିନ୍ ହୁଣି ଜିରୁସାଲମାର୍‌ ମଣ୍ଡ୍‌ଳିକେ ବଃଡେ କଃସ୍ଟ୍‌ ଆୟ୍‌ଲି, ସେତାକ୍‌ ପେରିତ୍‌ମଃନ୍‌କ୍‌ ଚାଡି ବିନ ଚେଲାସଃବୁ ଜିଉଦାରାଜି ଆର୍‌ ସମିରଣ୍ ହଲିବାଟ୍‌ ଚାରିହାକ୍‌ ବିଚ୍ରି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଅୟ୍‌ଲେକ୍‌ ହେଁ କଃତିଲକ୍‌ ସ୍ତିପାନ୍‌କେ ତହ୍‌ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ଗିନେ କାନ୍ଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମଃତର୍‌ ସାଉଲ୍‌ ଗଃରେ ଗଃରେ ହୁରି ଅଃଣ୍ଡ୍ରା ଆର୍‌ ମାୟ୍‌ଜି ମଃନ୍‌କେ ଜିକି ଆଣି ଜଃଇଲେ ହୁରାୟ୍‌ଲା, ଆର୍‌ ମଣ୍ଡ୍‌ଳିକେ ନଃସ୍ଟ୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ସେତାକ୍‌ ଜୁୟ୍‌ମଃନ୍‌ ଜଃତ୍‌କଃତ୍‌ ଅୟ୍‌ରିଲାୟ୍‌ ସେମଃନ୍ ଚାରିହାକ୍‌ ବୁଲିବୁଲି ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଆରେକ୍‌ ପିଲିପ୍ ସମିରଣକେ ଜାୟ୍‌ ବଃଡ୍ ବଃଡ୍ ଗଃଳାର୍‌ ଲକ୍‌ମଃନ୍‌କେ କ୍ରିସ୍ଟର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଆର୍‌ ଲକ୍‌ମଃନ୍ ପିଲିପାର୍‌ କଃତା ସୁଣି ଆର୍‌ ସେ କଃଲା କାବା ଅଃଉତା କାମ୍‌ ଦଃକି ଗଟେମଃନେ ତାର୍‌ କଃତାକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବିଟାଳ୍‌ ଆତ୍ମାମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି କିର୍‌କିରି କଃରି ବାରାୟ୍‌ ଆସୁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆରେକ୍‌ ଗାଦେକ୍‌ ଏକ୍‌ଅଃଙ୍ଗି ଆର୍‌ ଚଟାମଃନ୍ ଉଜ୍‌ ଅଃଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ସେତାକ୍‌ ସେ ଗଃଳେ ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ମଃତର୍‌ ସିମନ୍ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଇତାର୍‌ ହୁର୍ବେ ଗୁରୁ ଗୁଣିଆକଃରି ନିଜ୍‌କେ ଗଟେକ୍‌ ବଃଡ୍ ଲକ୍‌ବଃଲି କୟ୍‌ ସମିରଣ୍‌ ତଃୟ୍‌ର୍‌ ଲକ୍‌ମଃନ୍‌କେ କାବା କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଇସ୍ୱରାର୍‌ ସଃକ୍ତିକ୍‌ ଜୁୟ୍‌ ବଃଡ୍ ବଃଲି କଃଉଆ ଅୟ୍‌ଦ୍‌ ସିମନ୍‌କେ ଏ ସେ ବଃଲି ତାକେ ମାନ୍‌ତି କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ବୁତ୍‌ଦିନ୍ ହୁଣି ତାର୍‌ ଗୁରୁଗୁଣିଆ କାମ୍‌ କଃରି ସେମଃନ୍‌କେ କାବା କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମଃତର୍‌ ପିଲିପ୍ ଇସ୍ୱରାର୍‌ ରାଇଜାର୍‌ ଆର୍‌ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ନାଉଁଏ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲାକ୍‌ ସେମଃନ୍ ଜଃଡେବଃଳ୍‌ ସଃତ୍‌ କଃଲାୟ୍‌ ସଃଡେବଃଳ୍‌ ହୁଣି ଅଃଣ୍ଡ୍ରା ଆର୍‌ ମାୟ୍‌ଜିମଃନ୍ ବାପ୍ତିସମ୍‌ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଆର୍‌ ସିମନ୍ ନିଜେ ହେଁ ବିସ୍ୱାସ୍‌ କଃରି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲା ଆର୍‌ ପିଲିପାର୍‌ ସଃଙ୍ଗ୍ ରିଲା ଆର୍‌ କଃତେକ୍‌ କଃତେକ୍‌ ଚିନ୍ ଆର୍‌ ବଃଡ୍‌ବଃଡ୍ ସଃକ୍ତିର୍‌ କାମ୍‌ ଦଃକି କାବା ଅଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମିରଣ୍‌ ତଃୟ୍‌ର୍‌ ଲକ୍‌ମଃନ୍ ଜେ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣିକଃରି ମାନି ଆଚ୍‌ତି, ଇରି ଜଃଡେବଃଳ୍‌ ଜିରୁସାଲମେ ରିଲା ପେରିତ୍‌ମଃନ୍‌ ସୁଣ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ ସେମଃନାର୍‌ ତଃୟ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ସେମଃନ୍ ଜାୟ୍‌ ଜଃନ୍‌କଃରି ପବିତ୍ର ଆତ୍ମା ହାଉତି ଇତାକ୍‌ ସେମଃନାର୍‌ ଗିନେ ପାର୍ତ୍‌ନା କଃଲାୟ୍‌; ");
INSERT INTO bdv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କାର୍‌ ଉହ୍ରେ ହେଁ ପବିତ୍ର ଆତ୍ମା ଉତ୍ରି ନଃରିଲି, ମଃତର୍‌ ସେମଃନ୍ ମାପ୍ରୁ ଜିସୁର୍‌ ନାଉଁଏ ବାପ୍ତିସମ୍‌ ହାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲାକ୍‌ ସେମଃନ୍ ପବିତ୍ର ଆତ୍ମା ହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ପେରିତ୍‌ମଃନାର୍‌ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲାକ୍‌ ଆତ୍ମା ଦିଆ ଅଃଉଁଲି ଇରି ଦଃକି ସିମନ୍ ସେମ୍‌ନଃକେ ଟଃକା ଜାଚି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ମକ୍‌ ହେଁ ଇ ଅଃଦିକାର୍‌ ଦିଆ, ମୁୟ୍‌ଁ ଜୁୟ୍‌ ଲକାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଦ୍‌ ସେ ପବିତ୍ର ଆତ୍ମା ହାଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମଃତର୍‌ ପିତର୍‌ ତାକେ କୟ୍‌ଲା, “ତର୍‌ ଟଃକା ତର୍‌ ସଃଙ୍ଗ୍ ନଃସ୍ଟ୍‌ ଅଃଉଅ, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଇସ୍ୱରାର୍‌ ଦାନ୍‌କେ ଗେନୁକ୍‌ ବାବଃଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଇ କଃତାୟ୍‌ ତର୍‌ ବାଗ୍ ନାୟ୍‌, କି ଅଃଦିକାର୍‌ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଇସ୍ୱରାର୍‌ ଚଃମେ ତର୍‌ ମଃନାର୍‌ ବାବ୍‌ନା ନିକ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ତଃବେ ତର୍‌ ଦୁସ୍ଟ୍‌ ଚାଡି ମଃନ୍‌ ବାଦ୍‌ଲାୟ୍‌ ମାପ୍ରୁର୍‌ ତଃୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍‌, କେଜାଣ୍ ତର୍‌ ମଃନାର୍‌ ବାବ୍‌ନା କେମା ଅଃଉଁ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ତୁୟ୍‌ ଡାରା କଃତାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ହାହ୍‌ ବାନ୍ଦୁଣେ ବାନ୍ଦାୟ୍‌ ଅୟ୍‌ ଆଚ୍‌ସି ବଃଲି ମୁୟ୍‌ଁ ଜାଣୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ସେତାକ୍‌ ସିମନ୍ ପିତର୍‌ ଆର୍‌ ଜହନ୍‌କେ କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାୟ୍‌ଜାୟ୍‌ରି କଃଉଁଲାସ୍‌ ସେତିର୍‌ କାୟ୍‌ କଃତା ହେଁ ମକ୍‌ ନଃଉଅ, ଇତାକ୍‌ ତୁମିମଃନ୍ ମର୍‌ ଗିନେ ମାପ୍ରୁ ତଃୟ୍‌ ପାର୍ତ୍‌ନା କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ଅଃନ୍‌କଃରି ସେମଃନ୍ ଜିସୁର୍‌ ସାକି ଦେଉଁକେ ଆର୍‌ ମାପ୍ରୁର୍‌ କଃତା କୟ୍‌ ସମିରଣିୟର୍‌ ଗାଉଁମଃନ୍‌କେ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରି ପିତର୍‌ ଆର୍‌ ଜହନ୍‌ ଜିରୁସାଲମ୍‌ ବାଉଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ହଃଚେ ଇସ୍ୱରାର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ପିଲିପକେ କୟ୍‌ଲା, “ଉଟ୍‌, କାତା ଦିଗେ ଜୁୟ୍‌ ବାଟ୍‌ ଜିରୁସାଲମ୍‌ ହୁଣି ଗାଜା ହାକ୍‌ ଜାୟ୍‌ଆଚେ ସେ ବାଟେ ଜାଆ” ଆଜିକାଲି ଲକ୍‌ ସେ ବାଟ୍‌ ଅୟ୍‌ ନଃଜାତି । ");
INSERT INTO bdv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ସେତାକ୍‌ ପିଲିପ୍ ଉଟିଗଃଲା, ଆର୍‌ ଦଃକ୍‌ଲା, ଇତିଅପିଆର୍‌ ଦେସାର୍‌ କାଣ୍ଡାକି ନାଉଁଆର୍‌ ରାଣିର୍‌ ତଃଳାର୍‌ ବଃଡ୍‌ହଃଦ୍‌ ହାୟ୍‌ଲା ଇତିଅପିଆର୍‌ ବେଜୁ, ଜେ ରାଣିର୍‌ ସଃବୁଦଃନ୍ ବଃଣ୍ଡାରାର୍‌ ଅଃଦିକାରି ରିଲା, ସେ ସେବା କଃରୁକେ ଜିରୁସାଲମ୍‌ ଆସିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ସେ ବାଉଳି ଜଃଉଁଜଃଉଁ, ଅଃହ୍‌ଣାର୍‌ ରଃତ୍‌ ଉହ୍ରେ ବଃସି ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତର୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ ହଳ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ସଃଡେବଃଳ୍‌ ପବିତ୍ର ଆତ୍ମା ପିଲିପକେ କୟ୍‌ଲି, “ଚଃମେ ଜାୟ୍‌ ରଃତ୍‌ ଚାଲାଉ ସଃଙ୍ଗ୍ ଜାଆ” ");
INSERT INTO bdv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ସେତାକ୍‌ ପିଲିପ୍ ଦଃବ୍‌ଳି ଜାୟ୍‌ ସେ ଜିସାୟ୍‌ ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତର୍‌ ହଃଳ୍‌ତାର୍‌ ସୁଣି ହଃଚାର୍ଲା, “ତୁୟ୍‌ ଜାୟ୍‌ରି ହଳୁଲିସ୍‌, ସେରି କାୟ୍‌ ବୁଜୁଲିସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ବେଜୁ କୟ୍‌ଲା “କେ ମକ୍‌ ବୁଜାୟ୍‌ ନଃଦିଲେକ୍‌ ମୁୟ୍‌ଁ କଃନ୍‌କଃରି ବୁଜୁ ହାରିନ୍ଦ୍ ?” ଆର୍‌ ସେ ରଃତ୍‌ ଉହ୍ରେ ଚଃଗି ଆସି ଅଃହ୍‌ଣାର୍‌ ଚଃମେ ବଃସୁକ୍‌ ଗଃଉଆରି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ସାସ୍ତରାର୍‌ ଜୁୟ୍‌ରି ସେ ହଳ୍‌ତିରିଲା ସେରି ଇରି- “ସେ ମେଣ୍ଡା ହର୍‌ ହୁଜା କଃରୁକେ ନେତା ମେଣ୍ଡା ହର୍‌ ଚିମ୍‌ରା ଅୟ୍‌ରିଲା, ଆରେକ୍‌ ଗଃଡ୍‌ରା ମେଣ୍ଡାର୍‌ ରମ୍‌ କାଟ୍‌ତା ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଜଃନ୍‌କଃରି ତୁନ୍‌ହଃଳି ରଃୟ୍‌ଦ୍‌, ସେନ୍‌କାର୍‌ ସେ ଟଣ୍ଡ୍ ହୁଟାୟ୍‌ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ସେ ଦୁକ୍‌ ସଃମ୍ବାଳ୍‌ଲାକ୍‌ ତାର୍‌ ଡଃଣ୍ଡ୍‌ ଉଣା ନୟ୍‌ଲି । ତାର୍‌ ବଃଉଁସ୍‌ କେ କଃଉ ହାରେ ? କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ତାର୍‌ ଜିବନ୍ ହୁର୍ତିବି ତଃୟ୍‌ ହୁଣି ନିଆ ଅୟ୍‌ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ଗୁମୁସ୍ତାବେଜୁ ପିଲିପକେ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ତକ୍‌ ଗଃଉଆରି କଃରୁଲେ, ବାବ୍‌ବାଦି କାର୍‌ କଃତା କଃଉଁଲା, ତାର୍‌ କଃତା କି ଆର୍‌ କାର୍‌ କଃତା ?” ");
INSERT INTO bdv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ସେତାକ୍‌ ପିଲିପ୍ ଟଣ୍ଡ୍ ହୁଟାୟ୍‌ ସାସ୍ତରାର୍‌ ଇ କଃତାୟ୍‌ ହୁଣି ମୁଳ୍ୟାୟ୍‌ ତାର୍‌ ତଃୟ୍‌ ଜିସୁର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଆର୍‌ ସେମଃନ୍ ବାଟେ ଜଃଉଁଜଃଉଁ, କୁଣ୍ ଗଟେକ୍‌ ହାଣିନାଳେ ହଚ୍‌ଲାୟ୍‌, ସେତାକ୍‌ ବେଜୁ କୟ୍‌ଲା, “ଇତି ତ ହାଣି ଆଚେ, ମର୍‌ ବାପ୍ତିସମ୍‌ ହାଉଁକ୍‌ କାୟ୍‌ ବାଦା ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ପିଲିପ୍ କୟ୍‌ଲା ତୁୟ୍‌ ସଃବୁ ମଃନ୍ ହଃରାଣ୍ ସଃଙ୍ଗ୍ ଜଦି ବିସ୍ୱାସ୍‌ କଃର୍ସି ତଃବେ ଅଃଉଁ ହାରେ । ସେତାକ୍‌ ବେଜୁ କୟ୍‌ଲା ଜିସୁ କ୍ରିସ୍ଟ ଜେ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ଇରି ମୁୟ୍‌ଁ ବିସ୍ୱାସ୍‌ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ଆରେକ୍‌ ବେଜୁ ରଃତ୍‌ ତେବାଉଁକେ କୟ୍‌ଲା । ତଃବେ ପିଲିପ୍ ଆର୍‌ ବେଜୁ ହାଣି ବିତ୍ରେ ଉତୁର୍ଲାୟ୍‌ ଆର୍‌ ପିଲିପ୍ ତାକେ ବାପ୍ତିସମ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ସେମଃନ୍ ହାଣି ବିତ୍ରେ ହୁଣି ବାରାୟ୍‌ ଆୟ୍‌ଲାକ୍‌ ମାପ୍ରୁ ଆତ୍ମା ପିଲିପକେ କେଣେ ଦଃରିଗଃଲି ଆରେକ୍‌ ବେଜୁ ଆର୍‌ ପିଲିପକେ ଦଃକୁ ନଃହାର୍‌ଲା, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ସଃର୍ଦା ଅୟ୍‌କଃରି ତାର୍‌ ବାଟେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ମଃତର୍‌ ପିଲିପ୍ ଅସ୍‌ଦତ୍‌ ତଃୟ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା; ଆର୍‌ ସେ ଜଃଉଁଜଃଉଁ ଗଃଳେମଃନ୍ ଜିସୁର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରି କାଇସରିଆ ତଃୟ୍‌ ହଚ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ମଃତର୍‌ ସାଉଲ୍‌ ଅଃବେ ହଃତେକ୍‌ ହେଁ ମାପ୍ରୁର୍‌ ଚେଲାମଃନାର୍‌ ବିରଦେ ଡିରାୟ୍‌ ଆର୍‌ ମଃର୍ନେ ମାର୍ତା କଃତା କୟ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ଚଃମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଆରେକ୍‌ କ୍ରିସ୍ଟ ବିସ୍ୱାସି ଜୁୟ୍‌ ଅଃଣ୍ଡ୍ରା ଆର୍‌ ମାୟ୍‌ଜିକେ ଦଃକ୍‌ଲେକ୍‌, ସେମଃନ୍‌କେ ଜଃନ୍‌କଃରି ବାନ୍ଦି ଜିରୁସାଲମେ ଆଣୁ ହାରେ, ଇତାର୍‌ ଗିନେ ଦମେସକାର୍‌ ସଃବୁ ପାର୍ତ୍‌ନା ଗଃରେ ତାର୍‌ତଃୟ୍‌ ହୁଣି ଲେକାହଃତାର୍‌ ମାଗ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ହଃଚେ ସେ ଜଃଉଁଜଃଉଁ ଦମେସକ୍‌ ଚଃମେ ଆୟ୍‌ଲାକ୍‌ ସେଦାହ୍ରେ ଗଟେକ୍‌ ଅଃଗାସାର୍‌ ଉଜାଳ୍‌ ତାର୍‌ ଚାରିହାକ୍‌ ଜଃଲ୍‌କିଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ସେତାକ୍‌ ସେ ବୁୟ୍‌ଁ ତଃଳେ ଅଦ୍ରି ଇ କଃତା ସୁଣ୍‌ଲା, “ଏ ସାଉଲ୍‌ କାୟ୍‌ତାକ୍‌ ଅଃମିକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ସେ କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ, ତୁୟ୍‌ କେ ?” ସେ କଃତା ଆରେକ୍‌ ସୁଣାଗଃଲି, ଜାକେ ତୁୟ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ମୁଁୟ୍‌ ସେ ଜିସୁ । ");
INSERT INTO bdv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“ମଃତର୍‌ ଉଟ୍‌ ଆର୍‌ ଗଃଳ୍‌ ବିତ୍ରେ ଜାଆ, ଆର୍‌ ତକ୍‌ କାୟ୍‌ରି କଃରୁକେ ଅୟ୍‌ଦ୍‌ ସେରି କଃଉଆ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ସାଉଲ୍‌ ସଃଙ୍ଗ୍ ଜାତିରିଲାୟ୍‌ ସେମଃନ୍ ସେ ଗଃର୍ଜାଣ୍ ସୁଣି କାକେ ହେଁ ନଃଦେକି କାବା ଅୟ୍‌ ଟିଆ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଆରେକ୍‌ ସାଉଲ୍‌ ବୁୟେଁ ହୁଣି ଉଟି ଜଃଡେବଃଳ୍‌ ଅଃହ୍‌ଣାର୍‌ ଆକି ମେଲାକଃଲା ସଃଡେବଃଳ୍‌ ସେ କାୟ୍‌ରି ଦଃକି ନଃହାର୍‌ଲା, ଇତାକ୍‌ ତାକେ ଆତେ ଦଃରି ଦମେସକ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ଆର୍‌ ସେ ତିନି ଦିନ୍ ହଃତେକ୍‌ କାଣା ଅୟ୍‌ରିଲା, ଆର୍‌ କାୟ୍‌ରି ନଃକାୟ୍‌ଲା କି ନଃସୁର୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦମେସକ୍‌ ତଃୟ୍‌ ହନନିଅ ନାଉଁଆର୍‌ ଗଟେକ୍‌ କ୍ରିସ୍ଟ ଚେଲା ରିଲା । ମାପ୍ରୁ ତାକେ ଦଃକାୟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, “ହନନିଅ ଏ ମାପ୍ରୁ, କଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ସେତାକ୍‌ ମାପ୍ରୁ ତାକେ କୟ୍‌ଲା, “ଉଟ୍‌ ଆର୍‌ ସଃଳ୍‌କ୍‌ ନାଉଁଆର୍‌ ବାଟେ ଜାୟ୍‌ ଜିଉଦାର୍‌ ଗଃରେ ତାର୍ସୁସ୍‌ ଗଃଳାର୍‌ ସାଉଲ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକେ କଜ୍‌, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ପାର୍ତ୍‌ନା କଃରୁଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ଆର୍‌ ସେ ଜଃନ୍‌କଃରି ଦଃକୁକ୍‌ ହାରେ ଇତାର୍‌ ଗିନେ ହନନିଅ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆସି ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାଉଁଲା ବଃଲି ସେ ଦଃର୍ସନ୍‌ ଦଃକିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ମଃତର୍‌ ହନନିଅ କୟ୍‌ଲା, “ମାପ୍ରୁ, ଜିରୁସାଲମେ ତୁମାର୍‌ ଦଃର୍ମି ମଃନ୍‌କେ ଇ ଲକ୍‌ କଃତେକ୍‌ କଃସ୍ଟ୍‌ ଦଃୟ୍‌ଆଚେ, ସେରି ମୁୟ୍‌ଁ କଃତେକ୍‌ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ଇ ଲକାର୍‌ କଃତା ସୁଣି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଆର୍‌ ଇ ଟାଣେ ଜଃତେକ୍‌ ଲକ୍‌ ତୁମାର୍‌ ନାଉଁଏ ପାର୍ତ୍‌ନା କଃର୍ତି ସେମଃନ୍‌କେ ବାନ୍ଦୁକେ ସେ ବଃଡ୍ ଜାଜକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକାର୍‌ ହାୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ମଃତର୍‌ ମାପ୍ରୁ ତାକେ କୟ୍‌ଲା, “ଜାଆ, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ଅଜିଉଦି, ରଃଜା ଆର୍‌ ଇସ୍ରାଏଲାର୍‌ ଲକ୍‌ମଃନାର୍‌ ମୁଏଁ ଅଃମାର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଅଃମି ତାକେ ବାଚି ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ବଃଲେକ୍‌ ମର୍‌ ନାଉଁଆର୍‌ ଗିନେ ତାକେ କଃତେକ୍‌ ଦୁକ୍‌ ହାଉଁକ୍‌ ଅୟ୍‌ଦ୍‌ ସେରି ମୁଁୟ୍‌ ତାକେ ଜାଣାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ସେତାକ୍‌ ହନନିଅ ଜାୟ୍‌କଃରି ସେ ଗଃର୍‌ବିତ୍ରେ ହୁର୍ଲା । ଆରେକ୍‌ ତାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌କଃରି କୟ୍‌ଲା, “ସାଉଲ୍‌ ବାୟ୍‌, ମାପ୍ରୁ ବଃଲେକ୍‌ ଜୁୟ୍‌ ଜିସୁ, ଆସ୍ତାବଃଳ୍‌ ବାଟେ ତକେ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା, ତୁୟ୍‌ ଜଃନ୍‌କଃରି ଦଃକୁ ହାର୍ସି ଆର୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅଃଉସି, ଇତାକ୍‌ ସେ ମକ୍‌ ହଃଟାୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ସେ ଦାହ୍ରେ ତାର୍‌ ଆକାୟ୍‌ ହୁଣି ମାଚ୍‌ହଃକଳ୍‌ ହର୍‌ କାୟ୍‌ରି ଗଟେକ୍‌ ଅଦୁର୍ଲି ଆର୍‌ ସେ ଦକୁକ୍‌ ହାର୍ଲା । ଆରେକ୍‌ ସେ ଉଟି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଆର୍‌ ସାଉଲ କାଦି କାୟ୍‌ ବଃଳ୍‌ ହାୟ୍‌ଲା । ଦମେସକ୍‌ ତଃୟ୍‌ ସାଉଲାର୍‌ ପର୍ଚାର୍‌ ହଃଚେ ସେ ଦମେସକେ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତିଦିନ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଆରେକ୍‌ ଜିସୁ ଇସ୍ୱରାର୍‌ ହୟ୍‌ସି ବଃଲି ତଃତ୍‌କାଣ୍ ସେ ପାର୍ତ୍‌ନା ଗଃରେମଃନ୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଆର୍‌ ଜୁୟ୍‌ମଃନ୍‌ ତାର୍‌ କଃତା ସୁଣ୍‌ଲାୟ୍‌ ସେମଃନ୍ ସଃବୁ ଲକ୍‌ କାବା ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । “ଜିସୁ ନାଉଁ ଦଃରି ପାର୍ତ୍‌ନା କଃର୍ତା ଲକ୍‌ମଃନ୍‌କେ ଜିରୁସାଲମେ କଃସ୍ଟ୍‌ ଦେତିରିଲା ଆର୍‌ ଜଃନ୍‌କଃରି ସେମଃନ୍‌କେ ବାନ୍ଦି ବଃଡ୍ ଜାଜକ୍‌ ମଃନାର୍‌ ହାକ୍‌ ନେଉଁ ହାରେ ସେତାକ୍‌ ଦମେସକ୍‌ ଆସି ରିଲା, ଏକି ସେ ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମଃତର୍‌ ସାଉଲ୍‌ ଅଃଦିକ୍‌ ସଃକ୍ତି ଅୟ୍‌ ଉଟ୍‌ଲା ଆରେକ୍‌ ଏ ଜେ କ୍ରିସ୍ଟ୍‌ ବଃଲେକ୍‌ ମସିଅ ଇରି ନିକକଃରି ବୁଜାୟ୍‌ଲା, ଇତାକ୍‌ ଦମେସକ୍‌ ତଃୟ୍‌ର୍‌ ଜିଉଦିମଃନ୍ ଆରେକ୍‌ କାୟ୍‌ରି କଃଉଁକେ ନଃହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ବୁତେକ୍‌ ବିନ୍ ଗଃଲା ହଃଚେ ଜିଉଦିମଃନ୍ ସାଉଲ୍‌କେ ମଃର୍ନେ ମାରୁକ୍‌ ମିସିକଃରି କୁଟ୍‌ ହାଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ମଃତର୍‌ ସାଉଲ୍‌ ସେମଃନାର୍‌ କୁଟ୍‌ ହାଚ୍‌ତାର୍‌ ସୁଣ୍‌ଲା । ଆର୍‌ ସେମଃନ୍ ଜଃନ୍‌କଃରି ତାକେ ମାର୍ତି, ଇତାର୍‌ ଗିନେ ଦିନ୍ ରାତି ଗଃଳାର୍‌ ସଃବୁ ଦୁଆରେ ଜାଗିରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମଃତର୍‌ ତାର୍‌ ଚେଲାମଃନ୍ ରାତିବଃଳ୍‌ ତାକେ ଗଟେକ୍‌ ଡଃଲାୟ୍‌ ବଃସାୟ୍‌ କୁଆଳେ ହୁଣି ତଃଳେ ଉତ୍ରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ତାର୍‌ହଃଚେ ସାଉଲ୍‌ ଜିରୁସାଲମ୍‌କେ ଜାୟ୍‌ ଚେଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସୁକ୍‌ ମଃନ୍‌ହାଚ୍‌ତି ରିଲା, ମଃତର୍‌ ସେ ଜେ ଗଟେକ୍‌ ଚେଲା ଇରି ସଃତ୍‌ ନଃକେରି ସଃବୁଲକ୍‌ ତାକେ ଡିର୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ମଃତର୍‌ ବର୍ନବା ତାକେ ସଃଙ୍ଗେ ଦଃରି ପେରିତ୍‌ ମଃନାର୍‌ ଚଃମେ ଆଣ୍‌ଲା, ଆରେକ୍‌ ତାର୍‌ ବାଟେ ଜଃନ୍‌କଃରି ମାପ୍ରୁ ତାକେ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା, ଆର୍‌ ମାପ୍ରୁ ତାକେ କଃତା କୟ୍‌ଲା, ଆର୍‌ କଃନ୍‌କଃରି ସେ ଦମେସକ୍‌ ତଃୟ୍‌ ବଃଡେ ସାସେ ଜିସୁର୍‌ ନାଉଁଏ ପର୍ଚାର୍‌ କଃର୍ତିରିଲା, ଇ ସଃବୁ ସେମଃନାର୍‌ ଟାଣେ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଆର୍‌ ସାଉଲ ପେରିତ୍‌ ମଃନାର୍‌ ସଃଙ୍ଗେ ରିଲା ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜିରୁସାଲମେ ବୁଲାବୁଲିକଃରି, ମାପ୍ରୁର୍‌ ନାଉଁଏ ବଃଡେ ସାସେ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଇ ସଃବୁ ସେ ଗ୍ରିକ୍‌ ବାସାର୍‌ ଜିଉଦିମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା ଆର୍‌ କଃତାୟ୍‌ ଦଃରାଦଃରି ଅଃଉତି ରିଲା, ମଃତର୍‌ ସେମଃନ୍ ତାକେ ମଃର୍ନେ ମାରୁକ୍‌ ଉପାୟ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ସେରି ଜାଣୁ ହାରି ବିସ୍ୱାସି ବାୟ୍‌ମଃନ୍ ସାଉଲ୍‌କେ କାଇସରିଆକେ ନିଲାୟ୍‌ ଆର୍‌ ତାର୍ସୁସ୍‌କେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଅଃନ୍‌କଃରି ସଃବୁ ଜିଉଦା ରାଜି, ଗାଲିଲି ଆର୍‌ ସମିରଣ୍ ମଣ୍ଡ୍‌ଳି ନିକ ରଃୟ୍‌ ମାପ୍ରୁକ୍‌ ଡିରିକଃରି ଚାଲାଚାଲ୍‌ତି ଅୟ୍‌ ସୁସ୍ତା ହାଉତି ରିଲାୟ୍‌, ଆରେକ୍‌ ପବିତ୍ର ଆତ୍ମାର୍‌ ଉହ୍‌କାର୍‌ ସଃଙ୍ଗ୍ ବାଡୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ଇ ବିତ୍ରେ ପିତର୍‌ ସଃବୁ ହଲି ବୁଲି ବୁଲି ଲୁଦ୍‌ ଗଃଳାର୍‌ ଇସ୍ୱରାର୍‌ ବିସ୍ୱାସିମଃନାର୍‌ ଚଃମେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ସେତି ସେ ଏନିୟ ନାଉଁଆର୍‌ ଲକ୍‌କେ ବେଟ୍‌ହାୟ୍‌ଲା, ସେ ଆଟ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ମଃଳୁହଃଳି ଟାଟାୟ୍‌ ହୁଣି ଉଟୁ ନଃହାର୍‌ତି ରିଲା, ତାକେ ଏକ୍‌ଅଃଙ୍ଗି ରଗ୍ ଅୟ୍‌ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର୍‌ ତାକେ କୟ୍‌ଲା, “ଏନିୟ ଜିସୁ କ୍ରିସ୍ଟ୍‌ ତକ୍‌ ଉଜ୍‌ କଃରୁକେ ମଃନ୍‌କଃରୁଲା, ଉଟ୍‌ ଆର୍‌ ତର୍‌ ଟାଟି ଉଟାଉ” ସେତାକ୍‌ ସେ ତଃତ୍‌କାଣ୍ ଉଟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଆର୍‌ ଲୁଦ୍‌ ଆର୍‌ ସାରଣାଇ ବାସାକଃର୍ତାର୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ଦଃକି ମାପ୍ରୁର୍‌ ହାକ୍‌ ବାଉଳି ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜାପ ତଃୟ୍‌ ତାବିତା ନାଉଁଆର୍‌ ବିସ୍ୱାସି ମାୟ୍‌ଜି ରିଲି, ଗ୍ରିକ୍‌ ବାସାୟ୍‌ ନାଉ ଦର୍କା, ବଃଲେକ୍‌ “ଗଟ୍‌ କଟ୍ରା ।” ସେ ଗଃରିବ୍‌ମଃନ୍‌କେ ଉହ୍‌କାର୍‌ ଆର୍‌ ଗଃରିବ୍‌ ମଃନ୍‌କେ ଦାନ୍‌ କଃର୍ତିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ସଃଡେବଃଳ୍‌ ସେ ରଗେ ହଃଳି ମଃଲି; ସେତାକ୍‌ ସେମଃନ୍ ତାକେ ହାଣି ଗଃଦ୍‌ଳାୟ୍‌ ଗଟେକ୍‌ ଉହ୍ରାର୍‌ ବଃକ୍ରାୟ୍‌ ସଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଆରେକ୍‌ ଲୁଦ୍‌ ଜାପର୍‌ ଚଃମେ ରିଲି; ଚେଲାମଃନ୍ ପିତର୍‌ ସେତି ଆଚେ ବଃଲି ଦୁୟ୍‌ ଲକ୍‌କେ ତାର୍‌ ତଃୟ୍‌ ହଃଟାୟ୍‌ ଗଃଉଆରି କଃଲାୟ୍‌, “ଅଃମାର୍‌ ତଃୟ୍‌ ବେଗିଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ଇତାକ୍‌ ପିତର୍‌ ଉଟି ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଃଲା, ସେ ଆୟ୍‌ଲାକ୍‌ ସେମଃନ୍ ତାକେ ଉହ୍ରାର୍‌ ବଃକ୍ରାୟ୍‌ ନିଲାୟ୍‌, ଆର୍‌ ରାଣ୍ଡିମଃନ୍ ତାର୍‌ ଚାରିବେଳ୍‌ତ୍ ବେଳି କାନ୍ଦି କାନ୍ଦି କୟ୍‌ଲାୟ୍‌, ଦର୍କା ତାକାର୍‌ ସଃଙ୍ଗ୍ ରିଲାବଃଳ୍‌ ଜୁୟ୍‌ ସଃବୁ ହିନ୍ଦ୍‌ତା ହଃଚ୍ୟା ସଃବୁ ତିଆର୍‌ କଃରିରିଲି, ସେରି ସଃବୁ ଦଃକାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ମଃତର୍‌ ପିତର୍‌ ବଃକ୍ରାୟ୍‌ ହୁଣି ସଃବ୍‌କେ ବାର୍‌କଃରି ମାଣ୍ଡିକୁଟା ଟେସି ପାର୍ତ୍‌ନା କଃଲା ଆରେକ୍‌ ମଃଳାର୍‌ ଗଃଗାଳ୍‌ ମୁଁ ବୁଲାୟ୍‌ କୟ୍‌ଲା, “ତାବିତା, ଉଟ୍‌” ସେତାକ୍‌ ସେ ଆକି ଉଗାଳି ପିତର୍‌କେ ଦଃକ୍‌ଲି ଆର୍‌ ଉଟି ବଃସ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ଆରେକ୍‌ ସେ ଆତେ ଦଃରି ତାକେ ଉଟାୟ୍‌ଲା । ସଃବୁ ବିସ୍ୱାସି ଆର୍‌ ରାଣ୍ଡିମଃନ୍‌କେ କୁଦି ଦଃର୍କାକେ ଜିବନ୍ ହାୟ୍‌ଲାର୍‌ ଦଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଇ କଃତା ଜାପର୍‌ ଚାରିହାକ୍‌ ଜାଣାହଃଳ୍‌ଲି ଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ମାପ୍ରୁକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ଆରେକ୍‌ ପିତର୍‌ ବୁତେକେ ଦିନ୍ ହଃତେ ଜାପ ତଃୟ୍‌ ସିମନ୍ ନାଉଁଆର୍‌ ଚାମ୍‌ରା ଗଃରେ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିଆ ଗଃଳେ କର୍ନିଲିୟ ନାଉଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ରିଲା “ସେ ଇତାଲିକ୍‌ ନାଉଁଆର୍‌ ରମିୟ୍‌ ସଃଇନ୍ ଦଃଳାର୍‌ ଗଟେକ୍‌ ହାଁଞ୍ଚ୍‌କଳି ସଃଇନାର୍‌ ଅଃଦିକାରି ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ସେ ଗଟେକ୍‌ ଦଃର୍ମି ଲକ୍‌ ଆର୍‌ ତାର୍‌ ଗଃର୍‌କୁଟୁମ୍‌ ସଃବୁ ଇସ୍ୱର୍‌କେ ମାନ୍‌ତି ରିଲାୟ୍‌, ସେ ଦିଉଦି ଗଃରିବ୍‌ମଃନ୍‌କେ ଉହ୍‌କାର୍‌ କଃର୍ତିରିଲା ଆର୍‌ ସଃବୁବଃଳ୍‌ ମାପ୍ରୁକ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଗଟ୍‌ ଦିନ୍ ଉହୁର୍‌ଅଳି ହାକାହାକି ତିନି ଗଃଟା ବଃଳ୍‌ ସେ ଦୁତ୍‌କେ ଦଃର୍ସନେ ନିକକଃରି ଦଃକ୍‌ଲା, ଜଃନ୍‌କଃରି ଇସ୍ୱରାର୍‌ ଦୁତ୍‌ ତାର୍‌ ଚଃମେ ଆସି କୟ୍‌ଲା, “ଏ କର୍ନିଲିୟ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ସେତାକ୍‌ ତାକେ ନିକକଃରି ଦଃକି, ଡିରିକଃରି କୟ୍‌ଲା, “ଏ ମାପ୍ରୁ କାୟ୍‌ରି ?” ସେ ତାକେ କୟ୍‌ଲା, “ଇସ୍ୱର୍‌ ତର୍‌ ପାର୍ତ୍‌ନା ଆର୍‌ ତର୍‌ ଦାନ୍‌ ଦେତା ତଃୟ୍‌ ସଃର୍ଦା ଅୟ୍‌ଆଚେ ଆର୍‌ ଉତୁର୍‌ ଦେଉଁକେ ଇଚା କଃରିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ଅଃବେ ଜାପ ତଃୟ୍‌ ଲକ୍‌ ହଃଟାୟ୍‌ ସିମନ୍‌କେ କୁଦି ଆଣାଉ ତାର୍‌ ଆରେକ୍‌ ଗଟ୍‌ ନାଉଁ ଅଃଉଁଲି ପିତର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ସେ ସିମନ୍ ନାଉଁଆର୍‌ ଚାମ୍‌ରାର୍‌ ଗଃରେ ଆଚେ, ତାର୍‌ ଗଃର୍‌ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଇରି କୟ୍‌ ଦୁତ୍‌ ଗଃଲା ହଃଚେ କର୍ନିଲିୟ ତାର୍‌ ଗଃରାର୍‌ ଦଃଙ୍ଗ୍‌ଳା ବିତ୍ରେ ଦୁୟ୍‌ଲକେ ଆର୍‌ ତାର୍‌ ସଃଇନ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗଟେକ୍‌ ଦଃର୍ମି ସଃଇନ୍‌କେ କୁଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଆର୍‌ ସେମଃନ୍‌କେ ସଃବୁ କଃତା କୟ୍‌ ଜାପକେ ହଃଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ଆର୍‌କ ଦିନ୍ ସେମଃନ୍ ଜଃଉଁ ଜଃଉଁ ଜଃଡେବଃଳ୍‌ ସେ ଗଃଳାର୍‌ ଚଃମେ ଅୟ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ପିତର୍‌ ଦିନ୍ ବାରଗଃଟା ବଃଳ୍‌ ପାର୍ତ୍‌ନା କଃରୁକେ ଚାନି ଉହ୍ରେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଆର୍‌ ସେ ବୁକ୍‌ ଅୟ୍‌ଲା, ଆର୍‌ କାଉଁକେ ମଃନ୍‌ କଃଲା ମଃତର୍‌ ସେମଃନ୍ କାଦି ରାନ୍ଦ୍‌ତା ବଃଳ୍‌ ସେ ଗଟେକ୍‌ ଦଃର୍ସନ୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ସେ ଦଃକ୍‌ଲା ଜେ, ଅଃଗାସ୍‌ ଉଗାଳି ଅୟ୍‌ଆଚେ ଆର୍‌ ଗଟେକ୍‌ ବଃଡ୍ ହଃଚ୍ୟା ଚାରିକନେ ଦଃରା ଅୟ୍‌ ହୁର୍ତିବି ଉହ୍ରେ ଗଃସ୍ରାୟ୍‌ ଦିଆ ଅଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ସେତି ହୁର୍ତିବିର୍‌ ସଃବୁ ହଃର୍କାର୍‌ ଚାରି ହଃଦୁମାର୍‌ ବଃନାର୍‌ ଜଃତୁମଃନ୍‌, ବୁୟେଁ ରାଙ୍ଗ୍‌ତା ଜିବ୍‌ ଜଃତୁମଃନ୍‌ ଆର୍‌ ଅଃଗାସାର୍‌ ଚେଳେମଃନ୍ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆର୍‌ ତାକେ ଇ କଃତା କଃଉଆ ଅୟ୍‌ଲି, “ଏ ପିତର୍‌ ଉଟ୍‌ ମାର୍‌ ଆର୍‌ କାଆ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମଃତର୍‌ ପିତର୍‌ କୟ୍‌ଲା, “ନାୟ୍‌ ମାପ୍ରୁ, ମୁୟ୍‌ଁ କଃବେ ହେଁ ଅପବିତ୍ର ଆର୍‌ ବିଟାଳ୍‌ କାଦି ନଃକାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ତାକେ ଇ କଃତା ସୁଣା ଅୟ୍‌ଲି, “ଇସ୍ୱର୍‌ ଜାୟ୍‌ରି ନିର୍ମୁଳ୍‌ କଃରି ଆଚେ, ସେତାକ୍‌ ବିଟାଳ୍‌ ବଃଲି କଃଉନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଅଃନ୍‌କଃରି ତିନିତର୍‌ ଅୟ୍‌ଲା ହଃଚେ, ଆର୍‌ ହଃଚ୍ୟା ତଃତ୍‌କାଣ୍ ଅଃଗାସେ ଉଟାୟ୍‌ ନିଆ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର୍‌ ଜାୟ୍‌ରି ଦଃର୍ସନେ ଦଃକ୍‌ଲା ସେତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି ଏତାୟ୍‌ ଏତାୟ୍‌ ସେ କାବା ଅୟ୍‌ଲା । ଅଃନ୍‌କାବଃଳ୍‌ କର୍ନିଲିୟ ହଃଟାୟ୍‌ଲା ଲକ୍‌ମଃନ୍ ସିମନାର୍‌ ଗଃର୍‌ ଲଳ୍‌ଲାୟ୍‌ ଆର୍‌ ତାର୍‌ ଦୁଆର୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ସିମନ୍‌ ପିତର୍‌ “ସେ ଗଃରେ ଆଚେ କି ନାୟ୍‌ ବଃଲି, କୁଦିକଃରି ହଃଚାର୍ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର୍‌ ଦଃର୍ସନ୍‌ ଦଃକ୍‌ଲା କଃତା ବାବ୍‌ତାବଃଳ୍‌ ଆତ୍ମା ତାକେ କୟ୍‌ଲି, “ସୁଣ୍‌, ତଃଳେ ତିନି ଲକ୍‌ ତକେ ଲଳୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ଉଟ୍‌ ତଃଳେ ଜାଆ ଆର୍‌ କାୟ୍‌ରି ଅଃହ୍ରାତ୍‌ ନଃବାବି ତାକାର୍‌ ସଃଙ୍ଗ୍ ଜାଆ କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ସେମଃନ୍‌କେ ହଃଟାୟ୍‌ ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ସେତାକ୍‌ ପିତର୍‌ ସେ ଲକ୍‌ମଃନାର୍‌ ହାକ୍‌ ଉତ୍ରି ଆସି କୟ୍‌ଲା, “ତୁମିମଃନ୍ ଜାକେ ଲଳୁଲାସ୍‌ ସେ ମୁୟ୍‌ଁ । ତୁମିମଃନ୍ କାୟ୍‌ତାକ୍‌ ଆସି ଆଚାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, କର୍ନିଲିୟ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ହାଁଞ୍ଚ୍‌କଳି ସଃଇନାର୍‌ ଅଃଦିକାରି, ସେ ଗଟେକ୍‌ ଦଃର୍ମି ଲକ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌କେ ମାନ୍‌ତା ଲକ୍‌ ଆର୍‌ ସଃବୁ ଜିଉଦିମଃନାର୍‌ ତଃୟ୍‌ ଜାଣାସୁଣା ଲକ୍‌ । “ସେ ତାର୍‌ ଗଃରେ ତକ୍‌ କୁଦି ହଃଟାୟ୍‌ ଆଚେ ।” ଆର୍‌ ତର୍‌ କଃତା ସୁଣୁକ୍‌ “ପବିତ୍ର ଦୁତ୍‌ ତାକେ ଦଃର୍ସନ୍‌ ଦଃୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ସେତାକ୍‌ ସେମଃନ୍‌କେ ଗଟ୍‌ ରାତି ରେଉଁକେ ଗଃର୍‌ ବିତ୍ରେ କୁଦ୍‌ଲା, ତାର୍‌ ଆର୍‌କ ଦିନ୍ ଉଟି ତାକାର୍‌ ସଃଙ୍ଗ୍ ଗଃଲା, ଆରେକ୍‌ ଜାପର୍‌ ବିସ୍ୱାସି ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଆରେକ୍‌ ଗଟ୍‌ ଦିନ୍ ସେମଃନ୍ କାଇସରିଆ ହଚ୍‌ଲାୟ୍‌, ଜୁୟ୍‌ତି କର୍ନିଲିୟ ତାର୍‌ ନିଜାର୍‌ ଲକ୍‌ମଃନ୍‌କେ କୁଦି ସେମଃନ୍‌କେ ଜାଗ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର୍‌ ହଚ୍‌ଲାକ୍‌ କର୍ନିଲିୟ ତାକେ ବେଟ୍‌ ଅୟ୍‌ ଗଡ୍‌ତଃଳେ ଡୁଳି ଜୁଆର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ମଃତର୍‌ ପିତର୍‌ ତାକେ ଉଟାୟ୍‌ କୟ୍‌ଲା, “ଟିଆ ଅଃଉ” ମୁୟ୍‌ଁ ହେଁ ଗଟେକ୍‌ ମାନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ସେତାକ୍‌ ସେ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତା ଅଃଉଁ ଅଃଉଁ ଗଃର୍‌ ବିତ୍ରେ ଗଃଲା, ଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ରୁଣ୍ଡି ରିଲାର୍‌ ଦଃକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଆରେକ୍‌ ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସ୍ତାର୍‌ କି ତାର୍‌ ଚଃମେ ଜାତାର୍‌ ଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବିଦି ନାୟ୍‌, ସେରି “ତୁମିମଃନ୍ ଜାଣାସ୍‌, ଅୟ୍‌ଲେକ୍‌ ହେଁ କୁୟ୍‌ ଲକ୍‌କେ ହାହି କି ବିଟାଳ୍‌ ବଃଲି ନଃକଃଉଁକ୍‌ ଇସ୍ୱର୍‌ ମକ୍‌ ଦଃର୍ସନ୍‌ ଦଃକାୟ୍‌କଃରି କୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ସେତାକ୍‌ ତୁମି କୁଦ୍‌ଲାଦାହ୍ରେ ମୁୟ୍‌ଁ ନାୟ୍‌ ନଃବେଲି ତୁମାର୍‌ ଗଃରେ ଆୟ୍‌ଲେ । ଇତାକ୍‌ ମୁୟ୍‌ଁ ହଃଚାରୁଲେ କି କାୟ୍‌ତାକ୍‌ ମକ୍‌ କୁଦି ଆଚାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ନିଲିୟ କୟ୍‌ଲା, “ତିନ୍‌ ବିନ୍ ହୁର୍ବେ ଟିକ୍‌ ଇ ବେଳାୟ୍‌ ମର୍‌ ଗଃରେ ତିନିଗଃଟା ବେଳାୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲେ ଆର୍‌ ଗଟ୍‌ ଦଃବ୍‌ଳା ବଃସ୍ତର୍‌ ହିନ୍ଦିରିଲା ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘କର୍ନିଲିୟ, ତର୍‌ ପାର୍ତ୍‌ନା ଇସ୍ୱର୍‌ ସୁଣି ଆଚେ ଆରେକ୍‌ ତର୍‌ ଦାନ୍‌ ସଃବୁ ଇସ୍ୱର୍‌ ଏତୁ କଃରି ଆଚେ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ତଃବେ ଜାପକେ ଲକ୍‌ ହଃଟାୟ୍‌ ସିମନ୍ ପିତର୍‌କେ କୁଦି ଆଣ୍, ସେ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ସିମନ୍ ଚାମ୍‌ରାର୍‌ ଗଃରେ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ଁ ସଃଙ୍ଗେ ସଃଙ୍ଗେ ତର୍‌ ତଃୟ୍‌ ଲକ୍‌ ହଃଟାୟ୍‌ଲେ ଆର୍‌ ତୁୟ୍‌ ଆସି ଆଚ୍‌ସି, ନିକ କଃରି ଆଚ୍‌ସି । ତଃବେ ମାପ୍ରୁ ତକ୍‌ ଜାୟ୍‌ରି ସଃବୁ କୟ୍‌ଆଚେ ସେରି ସୁଣୁକ୍‌ ଅଃମିମଃନ୍‌ ଇସ୍ୱରାର୍‌ ଚଃମେ ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ସେତାକ୍‌ ପିତର୍‌ ଟଣ୍ଡ୍ ହୁଟାୟ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ଅଃବେ ସଃତ୍‌ ବୁଜୁ ହାରୁଲେ ଜେ, ଇସ୍ୱର୍‌ ସଃବ୍‌କେ ସଃମାନ୍‌ ବାବେ ଦଃକୁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ମଃତର୍‌ ହଃତି ଲକ୍‌ ଜେ ତାକେ ମାନେଦ୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ କାମ୍‌ କଃରେଦ୍‌ ମାପ୍ରୁ ତାକେ ନିଜାର୍‌ କଃରେଦ୍‌, ଇରି ମୁୟ୍‌ଁ ସଃତ୍‌ କଃରି ବୁଜୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ତୁମଃନ୍‌ ଜାଣି ଆଚାସ୍‌ ଜେ, ଇସ୍ୱର୍‌ ଇସ୍ରାଏଲ୍‌ମଃନାର୍‌ ହାକ୍‌ ଜୁୟ୍‌ ସେ ନିକ କବୁର୍‌ ହଃଟାୟ୍‌ ରିଲାର୍‌ ସେରି ହଃକା ଜିସୁ ପର୍ଚାର୍‌ କଃରି ରିଲାର୍‌ ସୁସ୍ତାର୍‌ କବୁର୍‌, ଇ ଜିସୁ କ୍ରିସ୍ଟ ସଃବ୍‌କାର୍‌ ମାପ୍ରୁ । ");
INSERT INTO bdv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଜହନ୍‌ ପର୍ଚାର୍‌ କଃଲା ବାପ୍ତିସମ୍‌ ଗାଲିଲି ତଃୟ୍‌ହୁଣି ମୁଳ୍ୟାୟ୍‌ କଃରି ସଃବୁ ଜିଉଦା ରାଜାୟ୍‌ କାୟ୍‌ରି ଗଃଟ୍‌ଲି ସେତିର୍‌ କଃତା ତୁମିମଃନ୍ ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ବଃଲେକ୍‌ ନାଜରିତାର୍‌ ଜିସୁର୍‌ କଃତା, କଃନ୍‌କଃରି ଇସ୍ୱର୍‌ ତାକେ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ଅବିସେକ୍‌ କଃଲା ଆର୍‌ ସଃକ୍ତି ଦଃୟ୍‌ରିଲା ଆର୍‌ ସେ ନିକ କାମ୍‌ କଃଲା, ଆର୍‌ ସୟ୍‌ତାନ୍‌ ଆତେ ହୁଣି ରଗି ମଃନ୍‌କେ ଉଜ୍‌ କଃରି ସଃବୁ ହାକ୍‌ ବୁଲ୍‌ଲା, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଇସ୍ୱର୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଆରେକ୍‌ ସେ ଜିଉଦିମଃନାର୍‌ ଦେସେ ଆର୍‌ ଜିରୁସାଲମେ ଜାୟ୍‌ ଜାୟ୍‌ରି କଃଲା ଅଃମିମଃନ୍‌ ସେ ସଃବୁର୍‌ ସାକି । ତାକେ ସେମଃନ୍ କ୍ରୁସେ ଜଃଗାୟ୍‌ ମାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ତାକେ ଇସ୍ୱର୍‌ ତିନିଦିନାର୍‌ ହଃଚେ ମଃଲା ତଃୟ୍‌ହୁଣି ଉଟାୟ୍‌ଲା ଆର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଦଃକାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ସେ ସଃବ୍‌କେ ଦଃକାୟ୍‌ ନଃୟ୍‌ଲା, ମଃତର୍‌ ଇସ୍ୱର୍‌ ହୁର୍ବେ ଟିକ୍‌ କଃଲା ସାକି ଜେ ଅଃମିମଃନ୍‌, ଅଃମିମଃନ୍‌କ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ଲା, ସେ ମଃଲା ଲକ୍‌ ତଃୟ୍‌ହୁଣି ଉଟ୍‌ଲା ହଃଚେ ଅଃମିମଃନ୍‌ ତାର୍‌ସଃଙ୍ଗ୍ କାଉଆ ହିଉଆ କଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଆର୍‌ ଲକ୍‌ମଃନ୍ ତଃୟ୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଆରେକ୍‌ ମଃଲା ଆର୍‌ ଜିବନ୍ ଲକ୍‌ମଃନ୍‌କେ ବିଚାର୍‌ କଃର୍ତା ଗିନେ ଇସ୍ୱର୍‌ ତାକେ ବାଚିଆଚେ ବଃଲି ସାକି ଦେଉଁକ୍‌ ସେ ଅଃମିମଃନ୍‌କ୍‌ ବାଚି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ତାର୍‌ ବିସୟେ ଇ କଃତା କୟ୍‌ଲା ଜୁୟ୍‌ ଲକ୍‌ ତାକେ ସଃତ୍‌ କଃରେଦ୍‌ ସେ ତାର୍‌ ନାଉଁଏ ହାହ୍‌ କେମା ହାୟ୍‌ଦ୍‌ ଇରି ସଃବୁ ବାବ୍‌ବାଦି ମଃନ୍ କୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର୍‌ ଇ ସଃବୁ କଃତା କଃଉତା ବଃଳ୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ସୁଣ୍‌ତି ରିଲାୟ୍‌ ସେ ସଃବୁଲକାର୍‌ ଉହ୍ରେ ପବିତ୍ର ଆତ୍ମା ଉତୁର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ସୁନତ୍‌ ହାୟ୍‌ଲା ପିତର୍‌ ସଃଙ୍ଗ୍ ଆୟ୍‌ଲା ଜିଉଦି ବିସ୍ୱାସିମଃନ୍ ସଃବୁଲକ୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ହେଁ ପବିତ୍ର ଆତ୍ମା ଆସ୍ତାର୍‌ ଦଃକି କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିଉଦି ବିସ୍ୱାସିମଃନ୍ ସେମଃନ୍‌କେ ବିନ୍ ବିନ୍ ବାସାୟ୍‌ କଃତା ଅଃଉତାର୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃର୍ତାର୍‌ ସୁଣ୍‌ଲାୟ୍‌ ସଃଡେବଃଳ୍‌ ପିତର୍‌ କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ଇ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ଅଃମାର୍‌ ହର୍‌ ପବିତ୍ର ଆତ୍ମା ହାୟ୍‌ ଆଚ୍‌ତି ଇମଃନ୍‌ ଜଃନ୍‌କଃରି ବାପ୍ତିସମ୍‌ ନଃହାଉତି ସେତାକ୍‌ କେ କାୟ୍‌ ହାଣି ନାୟ୍‌ ବଃଲେଦ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଆରେକ୍‌ ସେମଃନ୍‌କେ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ନାଉଁଏ ବାପ୍ତିସମ୍‌ ଦେଉଁକ୍‌ ଆଦେସ୍‌ ଦିଲା, ହଃଚେ ସେମଃନ୍ କଃତି ଦିନ୍ ସେତି ରେଉଁକ୍‌ ତାକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଅଜିଉଦିମଃନ୍‌ ହେଁ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ଇରି ପେରିତ୍‌ମଃନ୍‌ ଆର୍‌ ଜିଉଦା ରାଜିୟେ ରିଲା ବିସ୍ୱାସି ବାୟ୍‌ମଃନ୍‌ ହେଁ ସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ପିତର୍‌ ଜିରୁସାଲମେ ଆୟ୍‌ଲା, ସଃଡେବଃଳ୍‌ ସୁନତ୍‌ ଚେଲାମଃନ୍ ତାକ୍‌ ବିରଦ୍‌କଃରି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ତୁୟ୍‌ ଅସୁନତ୍‌ ଲକ୍‌ମଃନାର୍‌ ଗଃର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କାୟ୍‌ଆଚ୍‌ସି” ");
INSERT INTO bdv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ମଃତର୍‌ ପିତର୍‌ ଇ କଃତାକ୍‌ ଆରୁମେ ହୁଣି ସେସ୍‌ ହଃତେକ୍‌ ବୁଜାୟ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ମୁୟ୍‌ଁ ଜାପ ଗଃଳେ ପାର୍ତ୍‌ନା କଃର୍ତିରିଲେ ଆରେକ୍‌ ଦଃର୍ସନେ ଇରି ଦଃକ୍‌ଲେ, ଗଟେକ୍‌ ବଃଡ୍ ହଃଚ୍ୟା ତାର୍‌ ଚାରି କନେ ଦଃରାଅୟ୍‌ ଅଃଗାସେ ହୁଣି ତଃଳେ ଉତ୍ରି ଆସୁଲି । ");
INSERT INTO bdv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ଆର୍‌ ସେରି ମର୍‌ ହଃତେକ୍‌ ଆୟ୍‌ଲି, ମୁୟ୍‌ଁ ତାକେ ଦଃକି ବାବୁକ୍‌ ଦଃର୍ଲେ ସେତି ହୁର୍ତିବିର୍‌ ଚାରି ଗଡିଆ ଜଃତୁ, ବୁୟେଁ ରାଙ୍ଗ୍‌ତା ଜିବ୍‌ ଆର୍‌ ଅଃଗାସାର୍‌ ଚେଳେମଃନ୍ ରିଲାର୍‌ ଦଃକ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ଆରେକ୍‌ ମକ୍‌ କଃଉଆ ଅଃଉତା ଗଟେକ୍‌ କଃତା ସୁଣ୍‌ଲେ, ଏ ପିତର୍‌ ‘ଉଟ୍‌ ମାରିକଃରି କାଆ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମଃତର୍‌ ମୁୟ୍‌ଁ କୟ୍‌ଲେ, ‘ନାୟ୍‌ ମାପ୍ରୁ, ମୁୟ୍‌ଁ ପବିତ୍ର ନୟ୍‌ଲାର୍‌ କି ବିଟାଳ୍‌ରି କାୟ୍‌ରି କଃବେ ହେଁ ନଃକାୟ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ମଃତର୍‌ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ସଃର୍ଗେ ହୁଣି ଗଟେକ୍‌ କଃତା ସୁଣାଗଃଲି, ମାପ୍ରୁ ଜାୟ୍‌ରି ପବିତ୍ର କଃରି ଆଚେ ତାକେ ବିଟାଳ୍‌ ବଃଲି ନଃକ୍‌ଉ । ");
INSERT INTO bdv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ଅଃନ୍‌କଃରି ତିନିତର୍‌ ଆୟ୍‌ଲି, ହଃଚେ ସଃର୍ଗେ ନିଆ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଆରେକ୍‌ ଦଃକା ସେଦାହ୍ରେ ତିନିଲକ୍‌ ଅଃମି ଜୁୟ୍‌ ଗଃରେ ରିଲୁ, ସେତି ଦୁଆରେ ଟିଆ ଅୟ୍‌ରିଲାୟ୍‌ । ସେମଃନ୍ କାଇସରିଆ ହୁଣି ହଃଟାୟ୍‌ ରିଲାକ୍‌ ଆସି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଆରେକ୍‌ କାୟ୍‌ରି ଅଃହ୍ରାତ୍‌ ନଃବାବି ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜଃଉଁକେ ପବିତ୍ର ଆତ୍ମା ମକ୍‌ କୟ୍‌ଲି, ଆର୍‌ ଚଅ ଲକ୍‌ ବାୟ୍‌ମଃନ୍‌ ହେଁ ମର୍‌ ସଃଙ୍ଗ୍ ଗଃଲାୟ୍‌, ଆର୍‌ ଆମିମଃନ୍ କର୍ନିଲିୟର୍‌ ଗଃର୍‌ ବିତ୍ରେ ଗଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ସେ କଃନ୍‌କଃରି ଗଟେକ୍‌ ସଃର୍ଗ୍‌ ଦୁତ୍‌କେ ଦଃର୍ସନେ ଦଃକିରିଲା ସେରି ଆମିମଃନ୍‌କେ କୟ୍‌ଲା, ସେ ଦୁତ୍‌ ତାର୍‌ ଗଃରେ ଟିଅୟ୍‌ ତାକେ କୟ୍‌ଲା, ଜାପକେ ଲକ୍‌ ହଃଟାୟ୍‌ ପିତର୍‌ ବଃଲେକ୍‌ ସିମନ୍‌କେ କୁଦାୟ୍‌ ଆଣ୍ । ");
INSERT INTO bdv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ସେ ଆସି ଜୁୟ୍‌ ସଃବୁ କଃତାୟ୍‌ ତୁୟ୍‌ ଆର୍‌ ଗଃର୍‌କୁଟୁମ୍‌ ସଃବୁ ହାହେ ହୁଣି ମୁକ୍ଳାସ୍‌ ସେ ତୁମିକେ କୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ହଃଚେ ମୁୟ୍‌ଁ କଃତା କଃଉଁକ୍‌ ମୁଳ୍ୟାଉତା ବଃଳ୍‌ ପବିତ୍ର ଆତ୍ମା ହଃର୍ତୁ ଅଃମାର୍‌ ଉହ୍ରେ ଆୟ୍‌ଲା ହର୍‌, ସେମଃନାର୍‌ ଉହ୍ରେ ହେଁ ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ସଃଡେବଃଳ୍‌ ମାପ୍ରୁର୍‌ ଇ କଃତା ମକ୍‌ ଏତୁ ହଃଳ୍‌ଲି, ‘ଜହନ୍‌ ହାଣିୟେ ବାପ୍ତିସମ୍‌ ଦିଲା ସଃତ୍‌, ମଃତର୍‌ ତୁମିମଃନ୍ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ବାପ୍ତିସମ୍‌ ଅଃଉଆସ୍‌ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ତଃବେ ଆମିମଃନ୍ ମାପ୍ରୁ ଜିସୁ କ୍ରିସ୍ଟ୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତା ବଃଳ୍‌ ଇସ୍ୱର୍‌ ଜଃନ୍‌କଃରି ଆମିମଃନ୍‌କେ ଦାନ୍‌ ଦଃୟ୍‌ରିଲା, ସେନ୍‌କଃରି ସେମଃନ୍‌କେ ହେଁ ସଃମାନ୍ ଦାନ୍‌ ଦିଲା, ତଃବେ ମୁୟ୍‌ଁ କଃନ୍‌କଃରି ଇସ୍ୱର୍‌କେ ବିରଦ୍‌ କଃଲେ ହୁଣି ?” ");
INSERT INTO bdv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଇ ସଃବୁ କଃତା ସୁଣ୍‌ଲାକ୍‌ ସେମଃନ୍ ତୁନ୍‌ହାଳ୍‌ଲାୟ୍‌, ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରି କୟ୍‌ଲାୟ୍‌, ତଃବେ “ଇସ୍ୱର୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନ୍ ହେଁ ଜିବନ୍ ହାଉଁକ୍‌ ମଃନ୍ ବାଦ୍‌ଲାଉଁକ୍‌ ଦାନ୍‌ ଦଃୟ୍‌ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ଇ ବିତ୍ରେ ସ୍ତିପାନାର୍‌ ଗିନେ ଗଃଟି ରିଲା କଃସ୍ଟ୍‌ ଗିନେ ଜୁୟ୍‌ମଃନ୍‌ ଏଣେ ତେଣେ ଅୟ୍‌ରିଲାୟ୍‌, ସେମଃନ୍ ପଇନିକିଆ ସାଇପ୍ରସ୍‌ ଆର୍‌ ଆନ୍ତିଅକିଆ ହଃତେକ୍‌ ବୁଲି ବୁଲି ଜିଉଦିମଃନ୍‌କେ ଚାଡି କାର୍‌ ତଃୟ୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ ନଃକେର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ମଃତର୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ସାଇପ୍ରସ୍‌ ଆର୍‌ କୁରିଣିୟର୍‌ ଲକ୍‌ ଆନ୍ତିଅକିଆକ୍‌ ଆସି ଗ୍ରିକ୍‌ମଃନ୍‌କେ ହେଁ ମାପ୍ରୁ ଜିସୁର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ଆର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ମାପ୍ରୁର୍‌ ଆତ୍‌ ରିଲି, ଆରେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ମାପ୍ରୁ ହାକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ସେମଃନାର୍‌ କଃତା ଜିରୁସାଲମ୍‌ ମଣ୍ଡ୍‌ଳି ତଃୟ୍‌ ସୁଣା ଅୟ୍‌ଲି, ସେତାକ୍‌ ସେମଃନ୍ ଆନ୍ତିଅକିଆର୍‌ ହଃତେକ୍‌ ବର୍ନବାକ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ବର୍ନବା ସେତି ହଚି ଇସ୍ୱରାର୍‌ ଦଃୟା ଦଃକି ସଃର୍ଦା ଅୟ୍‌ଲା, ଆର୍‌ ସେମଃନ୍ ମଃନ୍ ହଃରାଣ୍ ଦଃୟ୍‌ ଏକ୍‌ ଅୟ୍‌ ମାପ୍ରୁର୍‌ ତଃୟ୍‌ ରେତି ଇତାର୍‌ ଗିନେ ସଃବ୍‌କେ ଗଃଉଆରି ସାସ୍‌ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ବର୍ନବା ଗଟେକ୍‌ ନିକ ଲକ୍‌ ପବିତ୍ର ଆତ୍ମାର୍‌ ଆର୍‌ ବିସ୍ୱାସେ ହୁର୍ନ୍‌ ରିଲା ଅଃନ୍‌କଃରି ଗାଦେକ୍‌ ଲକ୍‌ ମାପ୍ରୁର୍‌ ତଃୟ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ହଃଚେ ସେ ସାଉଲ୍‌କେ ଲଳୁକ୍‌ ତାର୍ସୁସ୍‌କେ ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆରେକ୍‌ ସେ ତାକେ ମିଳାୟ୍‌ ଆନ୍ତିଅକିଆକ୍‌ ନିଲା । ସେତି ସେମଃନ୍ ଗଟେକ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ମଣ୍ଡ୍‌ଳିର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ମଃନ୍‌କେ ସିକ୍ୟା ଦିଲାୟ୍‌, ଆରେକ୍‌ ଆନ୍ତିଅକିଆର୍‌ ଚେଲାମଃନ୍ ହଃର୍ତୁ କ୍ରିସ୍ଟାନ୍ ବଃଲି ଡାକ୍‌ ହୁଟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ସଃଡେବଃଳ୍‌ କଃତେକ୍‌ ବାବ୍‌ବାଦି ଜିରୁସାଲମେ ହୁଣି ଆନ୍ତିଅକିଆକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ସେମଃନାର୍‌ ବିତ୍ରେ ଆଗାବ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ହୁର୍ତିଏ ବଃଡେ କଃତାର୍‌ ଅୟ୍‌ଦ୍‌ ବଃଲି ଆତ୍ମା ତଃୟ୍‌ ଜାଣାୟ୍‌ଲା, ସେରି କ୍ଲାଉଦିଆ ରମରାଜିର୍‌ ଚକର୍‌ ବତି ରିଲାବଃଳ୍‌ ଗଃଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ସେତାକ୍‌ ଚେଲାମଃନ୍ ହଃତିଲକ୍‌ ତାକାର୍‌ ହାରୁସଃକାତ୍‌ ଜିଉଦା ରାଜିର୍‌ ବାୟ୍‌ମଃନ୍‌କେ ଉହ୍‌କାର୍‌ କଃରୁକେ ତିର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଆର୍‌ ସେମଃନ୍ ହେଁ ସେନ୍‌କଃରି ବର୍ନବା ଆର୍‌ ସାଉଲ୍‌ ଆତେ ପାରାଚିନ୍‌ମଃନ୍‌କେ ଡାବୁ ହଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ସଃଡେବଃଳ୍‌ ହେରଦ୍‌ ରଃଜା ମଣ୍ଡ୍‌ଳିର୍‌ କଃତେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ କଃସ୍ଟ୍‌ ଦେଉଁକ୍‌ ଆରୁମ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ସେ ଜହନାର୍‌ ବାୟ୍‌ସି ଜାକୁବକେ କଃଣ୍ଡା ସଃଙ୍ଗ୍ ଅଃତ୍ୟା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଇତାକ୍‌ ଜିଉଦିମଃନ୍ ସଃର୍ଦା ଅଃଉତାର୍‌ ଦଃକି ସେ ପିତର୍‌କେ ବାନ୍ଦ୍‌ଲାୟ୍‌ । ସଃଡେବଃଳ୍‌ କମିର୍‌ ନଃମିସାୟ୍‌ଲା ହିଟାର୍‌ ହଃର୍ବ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ହଃଚେ ସେ ତାକେ ଦଃରି ଜଃଇଲେ ହୁରୟ୍‌ଲା, ମୁକ୍ଳାଉଁଣି ହଃର୍ବ୍‌ ସଃର୍ଲେକ୍‌ ତାକେ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ବାର୍‌କଃରି ଆଣୁକେ ଟିକ୍‌ କଃଲା ଆର୍‌ ହଃତି ଦଃଳେ ଚାରିଲକ୍‌ ଲେକା ରେତା ଚାରିଗଟ୍‌ ସଃଇନ୍ ଦଃଳ୍‌ ତାକେ ଜାଗାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ତଃବେ ପିତର୍‌ ଜଃଇଲେ ରିଲା, ମଃତର୍‌ ତାର୍‌ ଗିନେ ମଣ୍ଡ୍‌ଳି ଏକ୍‌ମଃନେ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ପାର୍ତ୍‌ନା କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ହଃଚେ ହେରଦ୍‌ ଜୁୟ୍‌ଦିନ୍‌ ପିତର୍‌କେ ବାର୍‌କଃରି ଆଣ୍‌ତାର୍‌ ରିଲି, ସେ ଆଗାର୍‌ ରାତି ସିକ୍ଳାୟ୍‌ ବାନ୍ଦା ଅୟ୍‌ ଜଳେକ୍‌ ସଃୟ୍‌ନ୍‌ ମଃଜାୟ୍‌ ସୟ୍‌ରିଲା, ଆର୍‌ ସଃଇନ୍‌ମଃନ୍ ଦୁଆର୍‌ ମୁଏଁ ଜାଗ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଆର୍‌ ଦଃକା ମାପ୍ରୁର୍‌ ଦୁତ୍‌ ହଚ୍‌ଲା ଆର୍‌ ଜଃଇଲ୍‌ ଗଃର୍‌ ଉଜାଳ୍‌ ଅୟ୍‌ଲି ଆର୍‌ ସେ ପିତର୍‌କେ କୁଚାୟ୍‌ମାରି ତାକେ ନିଦ୍‌ ବାଙ୍ଗାୟ୍‌ କୟ୍‌ଲା, “ବେଗି ଉଟ୍‌” ସଃଡେବଃଳ୍‌ ତାର୍‌ ଆତେ ହୁଣି ସିକ୍ଳି କୁସୁଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ଆରେକ୍‌ ଦୁତ୍‌ ତାକେ କୟ୍‌ଲା, “ଅଃଟାବିଳା ବାନ୍ଦ୍ ଆର୍‌ ହାଣ୍ଡାୟ୍‌ ହିନ୍ଦ୍ ।” ପିତର୍‌ ସେନ୍ କଃଲା ଆର୍‌ ତାକେ କୟ୍‌ଲା, ଆର୍‌ “ଗଃଗାଳେ ହଃଚ୍ୟା ହୁଙ୍ଗ୍ରି ମର୍‌ ହଃଚେହଃଚେ ଆଉ ।” ");
INSERT INTO bdv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ସେ ବାରାୟ୍‌ ତାର୍‌ ହଃଚେହଃଚେ ଗଃଲା, ମଃତର୍‌ ଦୁତ୍‌ ଜାୟ୍‌ରି କଃଲା, ପିତର୍‌ ସେରି ଜେ ସଃତ୍‌ ବଃଲି ଜାଣି ଇସଃବୁ ଚଃହ୍ନେ ଦଃକୁଲେ ବଃଲି ବାବ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଜଃଡେବଃଳ୍‌ ହଃର୍ତୁ ଆର୍‌ ହଃଚାର୍‌ ଜାଗ୍‌ତା ଦଃଳ୍‌ ଲିଙ୍ଗିକଃରି ଜୁୟ୍‌ ଲଃଉଆର୍‌ ଦୁଆର୍‌ ବାଟ୍‌ ଅୟ୍‌ ଗଃଳେ ଜଃଉଁକେ ଅୟ୍‌ଦ୍‌ ସେ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌, ସେ ଦୁଆର୍‌ ମଃନ୍‌କେ ମଃନ୍ ସେମଃନାର୍‌ ଗିନେ ଉଗାଳି ଅୟ୍‌ଲି ଆର୍‌ ସେମଃନ୍ ବାରୟ୍‌ ଜାୟ୍‌ ଡଃଣ୍ଡାର୍‌ ସଃରାସଃରି ମୁଣ୍ଡ୍ ହଃତେକ୍‌ ଗଃଲାୟ୍‌, ସେଦାହ୍ରେ ସେ ଦୁତ୍‌ ପିତର୍‌କେ ଚାଡି ବାଣାଅୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ସଃଡେବଃଳ୍‌ ପିତର୍‌ ଚେତ୍‌ନା ଅୟ୍‌ କୟ୍‌ଲା ମାପ୍ରୁ ଅଃହ୍‌ଣାର୍‌ ଦୁତ୍‌ ହଃଟାୟ୍‌ ହେରଦ୍‌ ଆତେ ହୁଣି ଆର୍‌ ଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମକ୍‌ ମୁକ୍ଳାୟ୍‌ ଆଚେ, “ଇତି ମୁୟ୍‌ଁ ଅଃବେ ନିଜ୍‌କଃରି ଜାଣ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ସେ ଇ କଃତା ବାବି ମାର୍କ ବଃଲେକ୍‌ ଜହନାର୍‌ ଆୟ୍‌ସି ମରିୟମାର୍‌ ଗଃରେ ଆୟ୍‌ଲା, ସେତି ଗାଦେକ୍‌ ଲକ୍‌ ରୁଣ୍ଡି ପାର୍ତ୍‌ନା କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ସେ ହଃଦାର୍‌ ଦୁଆର୍‌ ମାର୍ଲାକ୍‌ ରଦା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳି କେ ବଃଲି ହଃଚାରୁକ୍‌ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ସେ ପିତରାର୍‌ ଟଣ୍ଡ୍ ସୁଣି ସଃର୍ଦା ଅୟ୍‌ ଦୁଆର୍‌ ଉଗାଳି ନଃକେରି ବିତ୍ରେ ଦଃବ୍‌ଳି ଗଃଲି ଆର୍‌ ଦୁଆରେ ପିତର୍‌ ଟିଆ ଅୟ୍‌ଆଚେ ବଃଲି କୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ସେମଃନ୍ ତାକେ କୟ୍‌ଲାୟ୍‌ “ତୁୟ୍‌ ବଃୟା ଅୟ୍‌ଲିସ୍‌” ମଃତର୍‌ ସେ ସଃତ୍‌ ବଃଲି କଃଉଁକେ ଦଃର୍ଲି, ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଇରି ପିତରାର୍‌ ଦୁତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ମଃତର୍‌ ପିତର୍‌ ଦୁଆରେ ତର୍‌କେତର୍‌ ମାର୍ତି ରିଲା, ଆରେକ୍‌ ସେମଃନ୍ ଦୁଆର୍‌ ଉଗାଳି ତାକେ ଦଃକି କାବା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ମଃତର୍‌ ସେମଃନ୍‌କେ ତୁନ୍ ହାଳୁକ୍‌ ଆତ୍‌ ସଃଗ୍ୟାକଃରି କୟ୍‌ଲା ଆର୍‌ ମାପ୍ରୁ କଃନ୍‌କଃରି ତାକେ ଜଃଇଲେ ହୁଣି ବାର୍‌କଃରି ଆଣ୍‌ଲା ସେରି ସେମଃନଃକେ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କୟ୍‌ଲା, ଆରେକ୍‌ “ସେ କୟ୍‌ଲା ଇସଃବୁ କଃତା ଜାକୁବକ୍‌ ଆର୍‌ ବାୟ୍‌ମଃନ୍‌କେ ଜାଣାଉ” ଆର୍‌ ସେ ସେତି ହୁଣି ବିନେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ସଃକାଳ୍‌ ଅୟ୍‌ଲାକ୍‌ ପିତର୍‌ କେଣେ ଗଃଲା ବଃଲି ସଃଇନ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଉର୍ଜି ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ଆର୍‌ ହେରଦ୍‌ ତାକେ ଲଳୁ ନାହାର୍ଲାକ୍‌ ଜାଗ୍‌ତା ସଃଇନ୍‌ମଃନ୍‌କେ ହଃଚାର୍ଲା ହଃଚେ ସେମଃନ୍‌କେ ମଃର୍ନେ ମାରୁକ୍‌ କୟ୍‌ଲା । ହଃଚେ ଜିଉଦା ରାଜାୟ୍‌ ହୁଣି କାଇସରିଆ ଜାୟ୍‌ ସେତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ସଃଡେବଃଳ୍‌ ହେରଦ୍‌ ସର୍‌ ଆର୍‌ ସିଦନ୍ ଲକାର୍‌ ଉହ୍ରେ ବଃଡେ ରିସା ଅୟ୍‌ରିଲା, ଆର୍‌ ସେମଃନ୍ ଗଟେକ୍‌ ଦଃଳ୍‌ଅୟ୍‌ ତାର୍‌ ଚଃମେ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ରଃଜାର୍‌ ସଃଉତା ଗଃରାର୍‌ ଗୁମୁସ୍ତା ବ୍ଲାସ୍ତକେ ଅଃହ୍‌ଣାର୍‌ କଃତାକ୍‌ ସୁସ୍ତା ଅଃଉଁକେ ଗଃଉଆରି କଃଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ରଃଜାର୍‌ ଦେସେ ହୁଣି ସେମଃନାର୍‌ ଦେସେ କାଦିକଣ୍ଡା ଜାତି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ଇତାକ୍‌ ଗଟେକ୍‌ ଟିକ୍‌ ଅୟ୍‌ଲା ବିନ୍ ହେରଦ୍‌ ରଃଜା ବଃସ୍ତର୍‌ ହିନ୍ଦି ସିଙ୍ଗାସଣେ ବଃସି ସେମଃନାର୍‌ ମୁଏଁ ଗଟେକ୍‌ କଃତା ଉଦେସ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କାଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଇରି ଦେବ୍‌ତାର୍‌ ଟଣ୍ଡ୍, ମାନାୟ୍‌ର୍‌ ଟଣ୍ଡ୍ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ତଃତ୍‌କାଣ୍ ମାପ୍ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ତାକେ ମାର୍ଲା, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ଇସ୍ୱର୍‌କେ ଜଃଜ୍‌ମାନ୍ ନଃକେଲା ଆର୍‌ ସେ ହକ୍‌ ଦଃରାୟ୍‌ ଅୟ୍‌ ମଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ମଃତର୍‌ ଇସ୍ୱରାର୍‌ କଃତା ଅଃଦିକ୍‌ ଉର୍ଜିଅୟ୍‌ ଚାରିହାକ୍‌ ବାଟି ଅଃଉଁକେ ଦଃର୍ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ହଃଚେ ବର୍ନବା ଆର୍‌ ସାଉଲ୍‌ ଅଃହ୍‌ଣାମଃନାର୍‌ ସେବା କାମ୍‌ ସଃରାୟ୍‌ ମାର୍କ ବଃଲେକ୍‌ ଜହନ୍‌କେ ସଃଙ୍ଗେ ଦଃରି ଜିରୁସାଲମ୍‌ ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ସଃଡେବଃଳ୍‌ ଆନ୍ତିଅକିଆର୍‌ ମଣ୍ଡ୍‌ଳି ତଃୟ୍‌ ବର୍ନବା, ସିମିୟନ୍ ଜାକେ ନିଗର୍‌ ବଃଲି କଃଉତି, କୁରିଣିୟର୍‌ ଲୁକିଅର୍‌ ତଃଳିଆ ରଃଜା ହେରଦ୍‌ ତାକେ ବାଡାୟ୍‌ ରିଲା ମନହେମ୍‌ ଆର୍‌ ସାଉଲ୍‌ ଅଃନ୍‌କଃରି ବାବ୍‌ବାଦି ଆର୍‌ ସିକାଉତା ଲକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ସେମଃନ୍ ମାପ୍ରୁର୍‌ ସେବା ଆର୍‌ ଉହାସ୍‌ କଃର୍ତାବଃଳ୍‌ ପବିତ୍ର ଆତ୍ମା କୟ୍‌ଲି, ଜୁୟ୍‌ କାମାର୍‌ ଗିନେ ଅଃମି ବର୍ନବା ଆର୍‌ ସାଉଲ୍‌କେ କୁଦି ଆଚୁ ସେତାକ୍‌ ସେମଃନ୍‌କେ ବିନେ କଃରା । ");
INSERT INTO bdv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ସେତାକ୍‌ ସେମଃନ୍ ଉହାସ୍‌ ଆର୍‌ ପାର୍ତ୍‌ନା କଃଲା ହଃଚେ, ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍‌କେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ଇ ହଃର୍କାରେ ବର୍ନବା ଆର୍‌ ସାଉଲ୍‌ ପବିତ୍ର ଆତ୍ମା ହଃଟାୟ୍‌ଲାକେ ସେଲୁକିଆକ୍‌ ଗଃଲାୟ୍‌, ସେତି ହୁଣି ହାଣି ଜାଜେ ଚଃଗି ସାଇପ୍ରସ୍‌ ହାକ୍‌ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ସେମଃନ୍ ସାଲମି ତଃୟ୍‌ ହଚ୍‌ଲା ହଃଚେ ଜିଉଦିମଃନାର୍‌ ସଃବୁ ପାର୍ତ୍‌ନା ଗଃରେ ଇସ୍ୱରାର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ଜହନ୍‌ ମାର୍କ ହେଁ ସେମଃନ୍‌କେ ଉହ୍‌କାର୍‌ କଃରୁକେ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଆରେକ୍‌ ସେମଃନ୍ ଚାରିହାକ୍‌ ଟାପୁମଃନ୍‌କେ ବୁଲି ବୁଲି ପାପସ୍‌କେ ଆସି ଗଟେକ୍‌ ବମ୍‌ଳାଉତା ବାବ୍‌ବାଦିକେ ଦଃକ୍‌ଲାୟ୍‌, ସେ ଗଟେକ୍‌ ଜିଉଦି ଆର୍‌ ତାର୍‌ ନାଉଁ ବାର୍‌ଜିସୁ । ");
INSERT INTO bdv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ସେ ରଃଜା ବାଚ୍‌ଲା ଗୁମୁସ୍ତା ସେର୍ଗିଅ ପାଉଲାର୍‌ ସଃଙ୍ଗୁଆଳି ରିଲା, ସେ ରଃଜା ବାଚ୍‌ଲା ଗୁମୁସ୍ତା ଲକ୍‌ ଗଟେକ୍‌ ବୁଦିମାନ୍ ଲକ୍‌ ରିଲା, ସେ ଇସ୍ୱରାର୍‌ କଃତା ସୁଣୁକ୍‌ ମଃନ୍ କଃରି ବର୍ନବା ଆର୍‌ ସାଉଲ୍‌କେ ତାର୍‌ ଚଃମେ କୁଦାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମଃତର୍‌ ସେ ଗୁଣିଆ ଏଲିମା, ଇରି ତାର୍‌ ଗ୍ରିକ୍‌ ନାଉଁ, ସେ ରଃଜାର୍‌ ବାଚ୍‌ଲା ଅଃଦିକାରି ଜଃନ୍‌କଃରି କି କ୍ରିସ୍ଟକେ ବିସ୍ୱାସ୍‌ ନଃକେରେ ସେତାର୍‌ଗିନେ ସେମଃନ୍‌କେ ବାଦା ଦେଉଁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମଃତର୍‌ ସାଉଲ୍‌ ଜାକେ ପାଉଲ୍‌ ବଃଲି ହେଁ କଃଉତି, ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ତାକେ ଗଃଡିୟା ଗଃଡିୟା ଦଃକି କଃରି କୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ଏ ସୟ୍‌ତାନାର୍‌ ହୟ୍‌ସି ତୁୟ୍‌ ସଃବୁ ହଃର୍କାର୍‌ ହେଟ୍‌କୁଟ୍ୟା ଆର୍‌ ଟକୁଆ ଆର୍‌ ସଃବୁ ହଃର୍କାର୍‌ ଦଃର୍ମାର୍‌ ସଃତ୍ରୁ, ତୁୟ୍‌ ସଃବୁବଃଳ୍‌ ମାପ୍ରୁର୍‌ ସଃତ୍‌କେ ମିଚ୍ କଃରୁକେ ଚେସ୍ଟା କଃରୁଲିସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଆର୍‌ ଅଃବେ ଦଃକ୍‌ ମାପ୍ରୁର୍‌ ଆତ୍‌ ତର୍‌ ଉହ୍ରେ ଆଚେ, ତୁୟ୍‌ କାଣା ଅୟ୍‌ କଃତି ଗଃଟା ହଃତେକ୍‌ ବେଳ୍‌କେ ଦଃକୁ ନଃହାର୍‌ସି । ସେଦାହ୍ରେ ଦୁୟେଁରି ଆର୍‌ ଅଃନ୍ଦାର୍‌ ତାକେ ଡାହ୍‌ଲି” ସେତାକ୍‌ ତାକେ ଆତ୍‌ ଦଃରି କାଡାଉଁକ୍‌ ସେ ଏଣେ ତେଣେ ଆଣ୍ଡଳି ଲକ୍‌କେ ଲଳୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ସେ ରଃଜା ବାଚ୍‌ଲା ଗୁମୁସ୍ତା ଇ ଗଃଟ୍‍ଣା ଦଃକି ମାପ୍ରୁର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃଲା ବଃଲେକ୍‌ ସେ ମାପ୍ରୁର୍‌ କଃତା ସୁଣି କାବା ଅୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ହଃଚେ ପାଉଲ୍‌ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳିମଃନ୍ ପାପସ୍‌ ଟାଣେ ହୁଣି ହାଣି ଜାଜେ ପପୁଲିଆର୍‌ ପର୍ଗିକେ ଆୟ୍‌ଲାୟ୍‌, ମଃତର୍‌ ଜହନ୍‌ ମାର୍କ ସେମଃନ୍‌କେ ଚାଡିକଃରି ଜିରୁସାଲମ୍‌ ବାଉଳି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ସେମଃନ୍ ପର୍ଗି ହୁଣି ଜାୟ୍‌କଃରି ପିସିଦିଆର୍‌ ଆନ୍ତିଅକିଆ ହଚ୍‌ଲାୟ୍‌ ଆର୍‌ ବିସାଉଁଣିବାର୍‌ ବିନ୍ ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଜାୟ୍‌ ବଃସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ଆରେକ୍‌ ମସାର୍‌ ସାସ୍ତର୍‌ ଆର୍‌ ବାବ୍‌ବାଦିର୍‌ ସାସ୍ତର୍‌ ହଳ୍‌ଲା ହଃଚେ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକାମଃନ୍ ସେମଃନାର୍‌ ହାକ୍‌ ଇରି କୟ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ “ବାୟ୍‌ମଃନ୍ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଜଦି ତୁମିମଃନାର୍‌ କାୟ୍‌ ସିକ୍ୟା ଦେତାର୍‌ କଃତା ଆଚେ ତଃବେ କଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ସେତାକ୍‌ ପାଉଲ୍‌ ଟିଆ ଅୟ୍‌ ଆତ୍‌ସଃଗ୍ୟା କଃରି କଃଉଁକେ ଦଃର୍ଲା ଏ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍ ଆର୍‌ ଇସ୍ୱର୍‌କେ ମାନ୍‌ତା ଲକ୍‌ମଃନ୍ ମର୍‌ କଃତା ସୁଣା, ");
INSERT INTO bdv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇସ୍ରାଏଲ୍‌ ଜାତିର୍‌ ଇସ୍ୱର୍‌ ଅଃମିମଃନାର୍‌ ଦାଦିବାବୁମଃନ୍‌କେ ବାଚ୍‌ଲା ଆର୍‌ ସେମଃନ୍ ମିସର୍‌ ଦେସେ ବାସା କଃର୍ତି ରିଲାୟ୍‌ ସଃଡେବଃଳ୍‌ ସେମ୍‌ନଃକେ ଉହ୍ରେ ଉଟାୟ୍‌ଲା ଆରେକ୍‌ ତାର୍‌ ବଃଳ୍‌ ସଃକାତ୍‌ ଆତେ ସେତି ହୁଣି ସେମ୍‌ନଃକେ ବାର୍‌କଃରି ଆଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ହଃଚେ ଚାଳିସ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ସେମଃନାର୍‌ ଗେଞ୍ଜ୍‌ଣା ସମ୍ୱାଳ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଆରେକ୍‌ କିଣାନ୍ ଦେସାର୍‌ ସାତ୍‌ଗଟ୍‌ ବଃଉଁସାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ନାସ୍‌ କଃରି, ");
INSERT INTO bdv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ହାକାହାକି ଚାରିସଅ ଦୁୟକଳିଦଃସ୍‌ ବଃର୍ସ୍‌ ବିତ୍ରେ ଇସଃବୁ ଗଃଟ୍‍ଣା ଗଃଟ୍‌ଲି । “ଇତାର୍‌ ହଃଚେ ବାବ୍‌ବାଦି ସାମୁଏଲ୍‌ ହଃତେକ୍‌ ବିଚାର୍‌କ୍‌ର୍ତା ଲକ୍‌ମଃନ୍‌କେ ବାଚ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ତାର୍‌ ହଃଚେ ସେମଃନ୍ ଗଟେକ୍‌ ରଃଜା ହାଉଁକେ ପାର୍ତ୍‌ନା କଃଲାୟ୍‌, ଆର୍‌ ଇସ୍ୱର୍‌ ଦୁୟ୍‌କଳି ବଃର୍ସ୍‌ ହଃତେକ୍‌ ବିନ୍ୟାମିନ୍‌ ବଃଉଁସାର୍‌ କିସାର୍‌ ହୟ୍‌ସି ସାଉଲ୍‌କେ ସେମଃନ୍‌କେ ରଃଜା କଃରି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ହଃଚେ ଇସ୍ୱର୍‌ ତାକେ ରଃଜା ହଃଦ୍‌ କାଡିକଃରି ସେମଃନାର୍‌ ରଃଜା ଅଃଉଁକେ ଦାଉଦ୍‌କେ ବାଚ୍‌ଲା ସେ ହେଁ ତାର୍‌ କଃତା ସାକି ଅୟ୍‌ କୟ୍‌ଲା ଅଃମି ଜିସିର୍‌ ଦାଉଦ୍‌କେ ମିଳାୟ୍‌ ଆଚୁ ସେ ଅଃମାର୍‌ ମଃନ୍ କଃଲା ଲକ୍‌, ସେ ସଃବୁ କଃତାୟ୍‌ ଅଃମାର୍‌ ଇଚା ମାନେଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ତାର୍‌ ବଃଉଁସ୍‌ ହୁଣି ଇସ୍ୱରାର୍‌ ସଃୟ୍‌ତ୍‌ ହଃର୍କାରେ ଇସ୍ରାଏଲାର୍‌ ଗିନେ ଗଟେକ୍‌ ମୁକ୍ଳାଉତା ଲକ୍‌ ବଃଲେକ୍‌ ଜିସୁକେ ହଃଟାୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ତାର୍‌ କାମ୍‌ ଆରୁମ୍‌ କଃର୍ତା ହୁର୍ବେ ଜହନ୍‌ ସଃବୁ ଇସ୍ରାଏଲ୍‌ ଲକାର୍‌ ଚଃମେ ହଃର୍ତୁ ମଃନ୍ ବାଦ୍‌ଲାଉତା ବାପ୍ତିସମ୍‌ ପର୍ଚାର୍‌ କଃରି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଆର୍‌ ଜହନ୍‌ ଅଃହ୍‌ଣାର୍‌ ଟିକ୍‌ କଃଲା କାମ୍‌ ସଃରାଉଁ ସଃରାଉଁ ଲକ୍‌ମଃନ୍‌କେ କୟ୍‌ଲା, ମୁୟ୍‌ଁ ଜେ ବଃଲି ତୁମିମଃନ୍ ମଃନେ ବାବୁଲାସ୍‌ ମୁୟ୍‌ଁ ସେ ନାୟ୍‌, ମଃତର୍‌ ଦଃକା ମର୍‌ ହଃଚେ ଗଟେକ୍‌ ଲକ୍‌ ଆସୁଲା, ତାର୍‌ ହାଦାର୍‌ ହାଣ୍ଡାୟ୍‌ କୁସ୍ଳାଉଁକେ ମୁୟ୍‌ଁ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ଏ ବାୟ୍‌ମଃନ୍‌ ଅବ୍ରାହାମ୍‌ ବଃଉଁସାର୍‌ ହିଲାମଃନ୍ ଆର୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ଇସ୍ୱର୍‌ କେ ମାନ୍‌ତା ଅଜିଉଦିମଃନ୍‌ ଅଃମାର୍‌ ଚଃମେ ଇ ମୁକ୍ଳାଉତା କଃତା କୟ୍‌ ହଃଟାୟ୍‌ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିରୁସାଲମାର୍‌ ଲକ୍‌ମଃନ୍ ଆରେକ୍‌ ସେମଃନାର୍‌ ମୁଳିକାମଃନ୍ ଜିସୁକେ ମୁକ୍ତିକାରି ବଃଲି ନଃଜାଣି ଆରେକ୍‌ ହଃତି ବିସାଉଁଣିବାର୍‌ଦିନ୍ ହଳ୍‌ତା ବାବ୍‌ବାଦିମଃନାର୍‌ କଃତା ସଃବ୍‌କେ ନଃଜାଣିକଃରି ତାକେ ଦସି ବାବେ ବିଚାର୍‌ କଃରି ସଃବୁ ହୁରୁଣ୍ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଆର୍‌ ମଃର୍ନ୍‌ ଦଃଣ୍ଡାର୍‌ କାୟ୍‌ ଦଃସ୍‌ ନଃହାୟ୍‌ଲେକ୍‌ ହେଁ ତାକେ ମାରୁକ୍‌ ପିଲାତକେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଆରେକ୍‌ ତାର୍‌ ବିସୟେ ଦଃର୍ମ୍‌ସାସ୍ତରେ ଜୁୟ୍‌ ସଃବୁ ଲେକା ଆଚେ ସେମଃନ୍ ସେ ସଃବୁ ହୁର୍ନ୍‌ କଃଲା ହଃଚେ ତାକେ କ୍ରୁସେ ହୁଣି ଉତ୍ରାୟ୍‌ ଆଣି ମଃସ୍‌ଣେ ସଃଙ୍ଗାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମଃତର୍‌ ଇସ୍ୱର୍‌ ତାକେ ମଃଲା ତଃୟ୍‌ ହୁଣି ଉଟାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଆରେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ସଃଙ୍ଗ୍ ଗାଲିଲି ହୁଣି ଜିରୁସାଲମ୍‌ ଆସି ରିଲାୟ୍‌ ସେମଃନ୍ ବୁତେକ୍‌ ଦିନ୍ ହଃତେକ୍‌ ତାକେ ଦଃକ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ସାକି । ");
INSERT INTO bdv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଆର୍‌ ଦାଦିବାବୁ ମଃନାର୍‌ ଚଃମେ କଃଲା ସଃୟ୍‌ତ୍‌ ଆମିମଃନ୍ ତୁମିମଃନଃକେ ଇ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଇସ୍ୱର୍‌ ଜିସୁକେ ଉଟାୟ୍‌ କଃରି ସେମଃନାର୍‌ ହିଲା ଜେ ଆମିମଃନ୍ ଅଃମାର୍‌ ଗିନେ ସେ ସଃୟ୍‌ତ୍‌ ହୁରୁଣ୍ କଃରିଆଚେ, ଜଃନ୍‌କଃରି ଗିତ୍‌ସଙ୍ଗିତା ଦୁୟ୍‌ ଲଃଗେ ଲେକା ଆଚେ- “ତୁୟ୍‌ ଅଃମାର୍‌ ହଅ; ଆଜି ମୁୟ୍‌ଁ ତର୍‌ ଉବାଦି ଅୟ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ସେ ଜେ ମଃଲା ଲକ୍‌ ତଃୟ୍‌ହୁଣି ଉଟାୟ୍‌ ଆଚେ ଆରେକ୍‌ ସେ ଜେ, ଆର୍‌ ନଃସ୍ଟ୍‌ ଜଃଗାୟ୍‌ ନଃଲେଉଟେ ଇ କଃତା ଇ ହଃର୍କାରେ କୟ୍‌ଆଚେ- “ମୁୟ୍‌ଁ ଦାଉଦାର୍‌ ଚଃମେ ସଃୟ୍‌ତ୍‌ କଃଲା ପବିତ୍ର, ଆର୍‌ ତିର୍‌ ରେତା ଆସିର୍ବାଦାର୍‌ ଜୟ୍‌ଗ୍‌ ଦଃୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଆରେକ୍‌ ହେଁ ସାସ୍ତରାର୍‌ ଗଟେକ୍‌ ତଃୟ୍‌ ଲେକାଆଚେ- “ତୁୟ୍‌ ତକ୍‌ ମାନ୍‌ତା ଲକ୍‌କେ ମଃସ୍‌ଣେ ନଃସ୍ଟ୍‌ ଅଃଉଁକେ ନଃଦେସି ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ୍‌ ତ ଅଃହ୍‌ଣାର୍‌ କାଳାର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଇସ୍ୱରାର୍‌ ଇଚା ହଃର୍କାରେ ସେବା କାମ୍‌ କଃଲା ହଃଚେ ମଃରି ଗଃଲା ଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଦାଦିବାବୁ ମଃନାର୍‌ ଚଃମେ ତହ୍‌ଲାକ୍‌ ତାର୍‌ ଗଃଗାଳ୍‌ ନଃସ୍ଟ୍‌ ଅୟ୍‌ଲି, ");
INSERT INTO bdv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମଃତର୍‌ ଜାକେ ଇସ୍ୱର୍‌ ମଃର୍ନେହୁଣି ଉଟାୟ୍‌ଲା ଆଚେ ସେ ନଃସ୍ଟ୍‌ ନଃୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ତଃବେ ଏ ବାୟ୍‌ମଃନ୍‌ ସୁଣା, ତୁମିମଃନ୍ ଇରି ଜାଣି ରିଆ ଜେ, ଇ ଲକାର୍‌ ତଃୟ୍‌ହୁଣି ତୁମାର୍‌ ଚଃମେ ହାହ୍‌ କେମାର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରାଅୟ୍‌ଆଚେ ମସାର୍‌ ବିଦି ତଃୟ୍‌ ସଃବୁ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲେକ୍‌ ଉଦାର୍‌ ହାଉତି । ");
INSERT INTO bdv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ଆରେକ୍‌ ମସାର୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ହୁଣି ଜୁୟ୍‌ ସଃବୁ ବିସୟ୍‌ ତୁମିମଃନ୍ ଉଦାର୍‌ ହାୟ୍‌ ଦଃର୍ମି ଗଃଣା ନୟ୍‌ଲାସ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍ତା ହଃତିଲକ୍‌ ତାର୍‌ ତଃୟ୍‌ହୁଣି ସେସଃବୁ କଃତାୟ୍‌ ହୁଣି ମୁକ୍‌ଳି ଦଃର୍ମି ଗଃଣା ଅଃଉତି । ");
INSERT INTO bdv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ସେତାକ୍‌ ଜାଗ୍ରତ୍‌, କଃଡେବଃଳ୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ ସାସ୍ତରେ ଜାୟ୍‌ରି କଃଉଆ ଅୟ୍‌ଆଚେ ସେରି ଜଃନ୍‌କଃରି ତୁମିମଃନ୍‌କେ ନଃଗଟେ । ");
INSERT INTO bdv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ଏ ଅମାନ୍ୟାର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍ କାବା ଅୟ୍‌ ମଃରା, ଇତାକ୍‌ ମୁୟ୍‌ଁ ତୁମିମଃନାର୍‌ ବେଳାୟ୍‌ ଗଟେକ୍‌ କାମ୍‌ କଃରୁଲେ, ଜଦି ସେ କେ ସେ କାମ୍‌ ତୁମାର୍‌ ଚଃମେ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କାୟ୍‌ରି କୟ୍‌ଦ୍‌, ତଃବେ ତୁମିମଃନ୍ କଃନ୍‌କଃରି ହେଁ “ସେରି ସଃତ୍‌ କଃରା ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ପାର୍ତ୍‌ନା ଗଃରେହୁଣି ବାରୟ୍‌ ଜାତାବଃଳ୍‌ ଜଃନ୍‌କଃରି ଆରେକ୍‌ ଗଟ୍‌ ବିସାଉଁଣିବାର୍‌ଦିନ୍ ସେ ସଃବୁ କଃତା ସେମଃନ୍‌କେ କଃଉଆ ଅୟ୍‌ଦ୍‌ ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ଗଃଉଆରି କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ପାର୍ତ୍‌ନା ସଃର୍ଲା ହଃଚେ ଜିଉଦି ଆର୍‌ ଜିଉଦି ଦଃର୍ମ୍‌ ଦାରାୟ୍‌ ମିସ୍‌ଲା ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବାର୍‌ ହଃଚେହଃଚେ ଗଃଲାୟ୍‌, ପେରିତ୍‌ମଃନ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତାବାର୍ତା କଃରି ଇସ୍ୱରାର୍‌ ଦଃୟାୟ୍‌ ତିର୍‌ ଅୟ୍‌ ରେଉଁକ୍‌ ବୁଜାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ଆରେକ୍‌ ଗଟେକ୍‌ ବିସାଉଁଣି ବିନ୍ ଗଃଳାର୍‌ ସଃବୁଲକ୍‌ ଇସ୍ୱର୍‌ କଃତା ସୁଣୁକ୍‌ ଗଟେତଃୟ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ମଃତର୍‌ ଜିଉଦିମଃନ୍ ଲକ୍‌ମଃନ୍‌କେ ଦଃକି ଡାରାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ଲିନ୍ଦା କଃରି ପାଉଲାର୍‌ କଃତାକ୍‌ ଜଃବର୍‌ ବିରଦ୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ସେତାକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ସାସ୍‌ ଦଃରି କୟ୍‌ଲାୟ୍‌ ହଃର୍ତୁ ତୁମିମଃନାର୍‌ ତଃୟ୍‌ ଇସ୍ୱରାର୍‌ କଃତା କଃଉତା ଲଳାରିଲି, ମଃତର୍‌ ତୁମିମଃନ୍ ସେରି ନଃସୁଣ୍‌ଲାସ୍‌, ଅଃହ୍‌ଣା ଆହ୍‌ଣାକେ ଅଃମ୍ବର୍‌ ଜିବନାର୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ ବଃଲି ବିଚାର୍‌ କଃଲାକ୍‌, ଦଃକା ଅଃମି ତୁମିମଃନ୍‌କେ ଚାଡି ଅଜିଉଦିମଃନାର୍‌ ତଃୟ୍‌ ଜଃଉଁଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ମାପ୍ରୁ ଆମିମଃନ୍‌କେ ଇ ଆଦେସ୍‌ ଦଃୟ୍‌ଆଚେ “ଆମିମଃନ୍ ଇ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଉଜାଳ୍‌ ହର୍‌ ତୁମିମଃନ୍‌କେ ବାଚି ଆଚୁ ।” ଜଃନ୍‌କଃରି ତୁମି ହୁର୍ତିବିର୍‌ ସେସ୍‌ ହଃତେକ୍‌ ମୁକ୍ଳାଉତା “ଲକ୍‌ ହର୍‌ ଅଃଉଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଅଜିଉଦିମଃନ୍‌ ଇରି ସୁଣି ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଇସ୍ୱରାର୍‌ କଃତାକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ଆରେକ୍‌ ଜଃତେକ୍‌ ଲକ୍‌ ଅଃମ୍ବର୍‌ ଜିବନ୍ ଗିନେ ବାଚ୍‌ଲାର୍‌ ଅୟ୍‌ରିଲା, ସେମଃନ୍ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଆର୍‌ ସଃବୁ ହଲିତଃୟ୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ମଃତର୍‌ ଜିଉଦି ଅଃଦିକାରି ଅଜିଉଦି ଡାକ୍‌ ହୁଟା ମାୟ୍‌ଜିମଃନ୍‌କେ ଆର୍‌ ଗଃଳାର୍‌ ବଃଡ୍‍ଜାଜକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଜିଉଦିମଃନ୍ ସଃର୍ଜାୟ୍‌ଲାୟ୍‌ । ଆରେକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବାକ୍‌ ତାଳ୍‌ନା କଃରି ଅଃହ୍‌ଣାର୍‌ ସଃନ୍ଦି ତଃୟ୍‌ ହୁଣି ସେମଃନ୍‌କେ ବାର୍‌କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ସେତାକ୍‌ ପେରିତ୍‌ମଃନ୍‌ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ହାଦାର୍‌ ଦୁଳି ସେମଃନାର୍‌ ବିରଦେ ହାହଳି ଇକନିଆକେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆର୍‌ ଆନ୍ତିୟକିଆୟ୍‌ ଚେଲାମଃନ୍ ସଃର୍ଦାଅୟ୍‌ ପବିତ୍ର ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିଆୟ୍‌ ହେଁ ସେନ୍‌କାର୍‌ ଗଃଟ୍‌ଲି, ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଜାୟ୍‌କଃରି ଇ କଃତା କୟ୍‌ଲାୟ୍‌ ଜେ, ଜିଉଦି ଆର୍‌ ଅଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମଃତର୍‌ ଜୁୟ୍‌ ଜିଉଦିମଃନ୍ ବିସ୍ୱାସ୍‌ ନଃକେଲାୟ୍‌ ସେମଃନ୍ ବିନ୍ ଅଜିଉଦି ଲକ୍‌ମଃନ୍‌କେ ସିର୍ଜାୟ୍‌ ବିସ୍ୱାସି ବାୟ୍‌ମଃନାର୍‌ ବିରଦେ ବିରଦ୍‌ ବାବ୍‌ ଜାତ୍‌କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ସେତି ବୁତେକ୍‌ ବିନ୍ ହଃତେକ୍‌ ରଃୟ୍‌ ମାପ୍ରୁର୍‌ ଉହ୍ରେ ବଃର୍ସା କଃରି, ସାସ୍‌ ଦଃରି ପର୍ଚାର୍‌ କଃଲାୟ୍‌, ଆର୍‌ ଇସ୍ୱର୍‌ ସେମଃନାର୍‌ ଆତେ ହୁଣି ଚିନ୍ ଆର୍‌ କାବା ଅଃଉତା କାମ୍‌ କଃରି ଅଃହ୍‌ଣାର୍‌ ଦଃୟାର୍‌ କଃତାକ୍‌ ସାକି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ମଃତର୍‌ ଗଃଳାର୍‌ ଲକ୍‌ମଃନ୍ ଦୁୟ୍‌ ବାଗ୍ ଅୟ୍‌ଲାୟ୍‌, ଗଟ୍‌ ଦଃଳେ ଜିଉଦିମଃନାର୍‌ ହାକ୍‌, ଆରେକ୍‌ ଗଟ୍‌ ଦଃଳ୍‌ ପେରିତ୍‌ ମଃନାର୍‌ ହାକ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ତାର୍‌ହଃଚେ ଅଜିଉଦି ଲକ୍‌ମଃନ୍ ଆର୍‌ ଜିଉଦିମଃନ୍, ସେମଃନାର୍‌ ମୁଳିକାମଃନାର୍‌ ସଃଙ୍ଗ୍ ସେମଃନ୍‌କେ କଃସ୍ଟ୍‌ ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ଟେଳା ସଃତ୍ରୁକ୍‌ ତିର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ସେରି ଜାଣୁ ହାରି ଲୁକାନିଆର୍‌ ଲୁସ୍ତ୍ରା ଆର୍‌ ଦର୍ବି ଗଃଳେ ଆର୍‌ ଚାରି ହଃକାର୍‌ ହଲିକ୍‌ ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆର୍‌ ସେତି ସେମଃନ୍ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରାୟ୍‌ ଗଟେକ୍‌ ଚଟା ଲକ୍‌ ରିଲା ତାର୍‌ ହାଦ୍‌ ଦୁର୍ବୁଳ୍‌ ରିଲି ସେ ଜଃଲମେ ହୁଣି ଚଟା ଆର୍‌ ସେ କଃବେ ଇଣ୍ଡି ନଃରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ସେ ଲକ୍‌ ପାଉଲାର୍‌ ପର୍ଚାର୍‌ ସୁଣ୍‌ତି ରିଲା, ପାଉଲ୍‌ ତାକେ ଦଃକି ଆର୍‌ ଉଜ୍‌ ଅଃଉଁକେ ତାର୍‌ ବିସ୍ୱାସ୍‌ ରିଲାର୍‌ ଦଃକି, ");
INSERT INTO bdv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ପାଉଲ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା “ତର୍‌ ହାଦେ କୁତ୍‌ମାଡି ସିଦା ଟିଆ ଅଃଉ !” ସେତାକ୍‌ ସେ କୁତ୍‌ ମାଡି ଇଣ୍ଡୁକ୍‌ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ପାଉଲ୍‌ ଜାୟ୍‌ରି କଃରିଆଚେ ଲକ୍‌ମଃନ୍ ସେରି ଦଃକି ଲୁକାନିଆ ବାସାୟ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ “ଦେବ୍‌ତାମଃନ୍ ମାନାୟ୍‌ ବେସେ ଅଃମାର୍‌ ତଃୟ୍‌ ଉତ୍ରି ଆସି ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ସେମଃନ୍ ବର୍ନବାକ୍‌ ବ୍ରୁହସ୍ପତି, ବଃଲେକ୍‌ ବଃଡ୍ ଦେବ୍‌ତା ବଃଲି କୟ୍‌ଲାୟ୍‌, ଆର୍‌ ପାଉଲ୍‌ ବେସି କଃତା କଃଉତିରିଲା ଲକ୍‌ ରିଲା, ତାକେ ବୁଦ, ବଃଲେକ୍‌ କଃତା କଃଉତା ଦେବ୍‌ତା ହେର୍‌ମାସ୍‌ ବଃଲି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଗଃଳ୍‌ ଚଃମେ ରିଲା ବଃଡ୍‌ ଦେବ୍‌ତା ମନ୍ଦିରାର୍‌ ହୁଜେରି କଃତିଗଟ୍‌ ଗଃଚ୍ ଆର୍‌ ହୁଲ୍‌ମାଳ୍‌ ଗଃଳାର୍‌ ଦୁଆରେ ଆଣି ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ପେରିତ୍‌ମଃନାର୍‌ ଚଃମେ ହୁଜା ଦେଉଁକ୍‌ ମଃନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ମଃତର୍‌ ପେରିତ୍‌ମଃନ୍‌ ବଃଲେକ୍‌ ବର୍ନବା ଆର୍‌ ପାଉଲ୍‌ ଇରି ସୁଣି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ଚିରି ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ଦଃବ୍‌ଳି ଜାୟ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଏ ବାୟ୍‌ମଃନ୍, ଇରି ସଃବୁ କାୟ୍‌ତାକ୍‌ କଃରୁଲାସ୍‌ ? ଅଃମିମଃନ୍‌ ହେଁ ତୁମିମଃନାର୍‌ ହଃର୍‌ ନଃର୍‌ସେ, ଅଃମି ତୁମିମଃନାର୍‌ ଚଃମେ ଇ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁଲୁ, ଜଃନ୍‌କଃରି ତୁମିମଃନ୍ ଇ ସଃବୁ ମିଚ୍ ଦେବ୍‌ତା ତଃୟ ହୁଣି ଦୁର୍‌ ଅୟ୍‌ ଜିବନ୍ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ବାଉଳା । ସେ ଅଃଗାସ୍‌ମଃଣ୍ଡ୍‌ଳ୍‌, ହୁର୍ତିବି, ସଃମ୍‌ନ୍ଦ୍ ଆର୍‌ ସେତି ରିଲାର୍‌ ସଃବୁ ଉବ୍‌ଜାୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ସେ ହୁର୍ବାର୍‌ ମାନାୟ୍‌ ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅୟ୍‌ ଆସ୍ତାର୍‌ ସଃବୁ ଲକ୍‌ମଃନ୍‌କେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବାଟେ ଇଣ୍ଡୁକ୍‌ ଚାଡି ଦଃୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ଆହ୍‌ଣାକେ ଲୁକାୟ୍‌ନଃକେରି ନିକକାମ୍‌ କଃରି ସେ ନିକକଃରି ଆଚେ, ଆର୍‌ ଅଃଗାସେ ହୁଣି ବଃର୍ସା ଆର୍‌ ତାସ୍‌ ଆର୍‌ କାଦି ଦଃୟ୍‌ ସଃର୍ଦାୟ୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍‌ ହୁରୁଣ୍ କଃରିଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଇ ସଃବୁ କଃତା କୟ୍‌ ସେମଃନ୍ ବଃଡେ କଃସ୍ଟେ ସେମଃନାର୍‌ ଗିନେ ହୁଜା କଃର୍ତାତଃୟ୍‌ ହୁଣି ବଃନ୍ଦ୍‌କଃରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ମଃତର୍‌ ପିସିଦିଆର୍‌ ଆନ୍ତିଅକିଆ ଆର୍‌ ଇକନିଆୟ୍‌ ହୁଣି ସେତି ଜିଉଦିମଃନ୍ ଆସି ଲକ୍‌ମଃନ୍‌କେ ଉସ୍‌କାୟ୍‌ ଦିଲାୟ୍‌ ଆରେକ୍‌ ପାଉଲ୍‌କେ ଟେଳା ମାରି, ସେ ମଃରି ଆଚେ ବଃଲି ମଃନେ ବାବିକଃରି ହଃଦାୟ୍‌ ଅଃର୍ଗଡି ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମଃତର୍‌ ଚେଲାମଃନ୍ ତାକେ ବେଳି ଟିଆ ଅୟ୍‌ଲାକ୍‌ ସେ ଉଟି ଗଃଳ୍‌ ବିତ୍ରେ ବାଉଳି ଗଃଲା, ଆର୍‌କ ଦିନ୍ ସେ ବର୍ନବା ସଃଙ୍ଗ୍ ଦର୍ବିକେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ସେମଃନ୍ ଦର୍ବି ଗଃଳେ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃଲାୟ୍‌ ଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଚେଲା କଃଲା ହଃଚେ, ଲୁସ୍ତ୍ରା, ଇକନିଆ ଆର୍‌ ଆନ୍ତିଅକିଆକ୍‌ ବାଉଳି ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଆରେକ୍‌ ସେ ଟାଣେ ଚେଲାମଃନାର୍‌ ମଃନ୍‌କେ ତିର୍‌ କଃଲାୟ୍‌ ଆର୍‌ ବିସ୍ୱାସେ ତିର୍‌ ଅୟ୍‌ ରେଉଁକ୍‌ ସେମଃନ୍‌କେ ଗଃଉଆରି କଃରି ବଃର୍ସା କଃରାୟ୍‌ଲାୟ୍‌, “ବଃଡେ ଦୁକ୍‌କଃସ୍ଟ୍‌ ଅୟ୍‌ ଅଃମିକ୍‌ ଇସ୍ୱରାର୍‌ ରାଇଜେ ଜଃଉଁକେ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ଆର୍‌ ସେମଃନ୍ ସେମଃନାର୍‌ ଗିନେ ହଃତି ମଣ୍ଡ୍‌ଳି ତଃୟ୍‌ ପାରାଚିନ୍ ବାଚି ଉହାସ୍‌ ସଃଙ୍ଗ୍ ପାର୍ତ୍‌ନା କଃଲାୟ୍‌ ଆର୍‌ ଜୁୟ୍‌ ମାପ୍ରୁ ତଃୟ୍‌ ସେମଃନ୍ ବିସ୍ୱାସ୍‌ କଃର୍ତି ରିଲାୟ୍‌ ତାର୍‌ ଆତେ ସେମଃନ୍‌କେ ସଃହ୍ରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ହଃଚେ ସେମଃନ୍ ପିସିଦିଆ ବାଟ୍‌ ଦଃୟ୍‌, ପପୁଲିଆ ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆର୍‌ ପର୍ଗି ତଃୟ୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରି ଆତାଲିଆ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ସେତି ହୁଣି ହାଣି ଜାଜେ ସେମଃନ୍ ଆନ୍ତିଅକିଆକ୍‌ ବାଉଳି ଆୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ଜୁୟ୍‌ କାମ୍‌ କଃର୍ତି ରିଲାୟ୍‌ ସେରି କଃରୁକେ ଇସ୍ୱରାର୍‌ ଦଃୟାୟ୍‌ ସଃହ୍ରିଅୟ୍‌ ସେଟାଣେ ହୁଣି ବାରାୟ୍‌ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ସେମଃନ୍ ଆନ୍ତିଅକିଆ ହଚି, ମଣ୍ଡ୍‌ଳିର୍‌ ଲକ୍‌ମଃନ୍‌କେ ଗଟ୍‌ତଃୟ୍‌ ରୁଣ୍ଡାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗେ ରଃୟ୍‌ ଜୁୟ୍‌ ସଃବୁ କାମ୍‌ କଃରି ରିଲା ଆର୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନ୍‌କେ ବିସ୍ୱାସାର୍‌ ଦୁଆର୍‌ ଉଗାଳି ଦଃୟ୍‌ରିଲାୟ୍‌ ସେ ସଃବୁ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆର୍‌ ସେମଃନ୍ ବିସ୍ୱାସିମଃନାର୍‌ ସଃଙ୍ଗ୍ ବୁତେକ୍‌ ବିନ୍ ହଃତେକ୍‌ ସେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଇ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ଜିଉଦା ରାଜାୟ୍‌ ହୁଣି ଆସି ବିସ୍ୱାସିମଃନ୍‌କେ ଇ ସିକ୍ୟା ଦେଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌, “ମସାର୍‌ ବିଦି ହଃର୍କାରେ ତୁମିମଃନାର୍‌ ସୁନତ୍‌ ନୟ୍‌ଲେକ୍‌ ହାହେ ହୁଣି ମୁକ୍ଳୁକ୍‌ ନାହାରାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଇତାକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତା କାଟାକାଟି ଅୟ୍‌ଲାକ୍‌ ବାୟ୍‌ମଃନ୍ ପାଉଲ୍‌, ବର୍ନବା ଆର୍‌ ତାକାର୍‌ ବିତ୍ରେ ଆର୍‌ କଃତିଲକ୍‌ ଇ କଃତାକ୍‌ ଦଃରି ଜିରୁସାଲମାର୍‌ ପେରିତ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଜଃଉଅ ବଃଲି ତିର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ତଃବେ ମଣ୍ଡ୍‌ଳିର୍‌ ଲକ୍‌ମଃନ୍ ସେମଃନ୍‌କେ ବାଟ୍‌ ହଃତେକ୍‌ ନଃୟ୍‌ ଚାଡି ଦିଲା ହଃଚେ, ସେମଃନ୍ ପଇନିକିଆ ଆର୍‌ ସମିରଣ ବାଟ୍‌ ଅୟ୍‌ ଜଃଉଁ ଜଃଉଁ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ମଃନ୍ ବାଦ୍‌ଲାଉତାର୍‌ କଃତା କୟ୍‌କଃରି ସଃବୁ ବାୟ୍‌ମଃନାର୍‌ ବଃଡେ ସଃର୍ଦା କଃରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ହଃଚେ ସେମଃନ୍ ଜିରୁସାଲମେ ହଚି, ମଣ୍ଡ୍‌ଳି ଆର୍‌ ପେରିତ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ହଚି ମାନ୍‌ତି ହାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଇସ୍ୱର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରଃୟ୍‌ ଜୁୟ୍‌ ସଃବୁ କାମ୍‌ କଃରି ରିଲା ସେରି ସଃବୁ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମଃତର୍‌ ପାରୁସି ଦଃଳାର୍‌ କଃତି ଲକ୍‌ ଜିଉଦି ବିସ୍ୱାସି ମଃନ୍‌ କୟ୍‌ଲାୟ୍‌ “ଅଜିଉଦି ଚେଲାମଃନ୍ ସୁନତ୍‌ ଅୟ୍‌ ମସାର୍‌ ବିଦି ମାନ୍‌ତା ଲଳା ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ହଃଚେ ଇ ବିସୟେ କଃତାବାର୍ତା କଃରୁକେ ପେରିତ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ରୁଣ୍ଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","କଃତେକ୍‌ କଃତାବାର୍ତା ଅୟ୍‌ଲା ହଃଚେ ପିତର୍‌ ଉଟି ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ବାୟ୍‌ବେଣିମଃନ୍ ତୁମିମଃନ୍ ଜାଣାସ୍‌ ଜେ, ମର୍‌ ଟଣ୍ଡେହୁଣି ଅଜିଉଦି ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି ନିକ କବୁର୍‌ ସୁଣି ବିସ୍ୱାସ୍‌ କଃର୍ତି, ଇତାକ୍‌ ବୁତେକ୍‌ ଦିନ୍ ତଃଳେ ଇସ୍ୱର୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ମକ୍‌ ବାଚିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ସଃବ୍‌କାର୍‌ ମଃନାର୍‌ କଃତା ଜାଣ୍‌ତା ଇସ୍ୱର୍‌ ଅଃମିମଃନ୍‌କ୍‌ ଜଃନ୍‌କଃରି ପବିତ୍ର ଆତ୍ମା ଦଃୟ୍‌ଆଚେ, ସେମଃନ୍‌କେ ହେଁ ସେନ୍‌କଃରି ଦଃୟ୍‌ ସେମଃନ୍‌କେ କୁଦିଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଆର୍‌ ସେ ଅଃମିମଃନାର୍‌ ଆର୍‌ ସେମଃନାର୍‌ ମଃନ୍‌ ବିତ୍ରେ କାୟ୍‌ ଅଃହ୍ରାତ୍‌ ନଃବାବି କଃରି ବିସ୍ୱାସ୍‌ ଗିନେ ସେମଃନାର୍‌ ହାହ୍‌ କେମା କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଇତାକ୍‌ ଜୁୟ୍‌ ଜିଅଡି ଅଃମାର୍‌ ଦାଦିବାବୁ ଆର୍‌ ଅଃମିମଃନ୍‌ ବଃଉଁକ୍‌ ନଃହାର୍‌ଲୁ, ସେ ଜିଅଡି ଚେଲାମଃନାର୍‌ କଃନ୍ଦେ ଲାଦିଦଃୟ୍‌ କାୟ୍‌ତାକ୍‌ ତୁମିମଃନ୍ ଇସ୍ୱର୍‌କେ ପରିକ୍ୟା କଃରୁଲାସ୍‌ ? ");
INSERT INTO bdv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ନୟ୍‌ ଇରି ଟିକ୍‌ ନାୟ୍‌ ମଃତର୍‌ ସେମଃନ୍ ଜଃନ୍‌କଃରି ବିସ୍ୱାସ୍‌ କଃରି ହାହେ ହୁଣି ମୁକ୍‌ଳି ଆଚ୍‌ତି, ଅଃମିମଃନ୍‌ ହେଁ ସେନ୍‌କାର୍‌ ମାପ୍ରୁ ଜିସୁର୍‌ ଦଃୟାୟ୍‌ ହାହେ ହୁଣି ମୁକ୍ତି ହାଉଁନ୍ଦ୍‌ ବଃଲି ବିସ୍ୱାସ୍‌ କଃରିଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ସେତାକ୍‌ ସଃର୍ନେ ଲକ୍‌ ତୁନ୍‌ ହାଳ୍‌ଲାୟ୍‌ ଆର୍‌ ବର୍ନବା ଆର୍‌ ପାଉଲ୍‌ ତଃୟ୍‌ହୁଣି ଅଜିଉଦି ଲକ୍‌ ବିତ୍ରେ ଇସ୍ୱର୍‌ ଜୁୟ୍‌ ସଃବୁ ଚିନ୍ ଆର୍‌ କାବା ଅଃଉତା କାମ୍‌ କଃରି ରିଲାୟ୍‌, ସେମଃନ୍ ତଃୟ୍‌ହୁଣି ସେତିର୍‌ ସଃବୁ କଃତା ସୁଣୁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ସେମଃନାର୍‌ କଃତା ସଃର୍ଲାହଃଚେ ଜାକୁବ ଟିଆ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ବାୟ୍‌ବେଣିମଃନ୍‌ ମର୍‌ କଃତା ସୁଣା ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ନାଉଁ ଗିନେ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌କେ ମାନୁକ୍‌ କଃନ୍‌କଃରି ସେମଃନ୍‌କେ ଦଃୟା କଃରିରିଲା, ସେରିମଃନ୍ ସିମନ୍ କୟ୍‌ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ଆରେକ୍‌ ବାବ୍‌ବାଦିମଃନାର୍‌ କଃତା ଇତାର୍‌ ସଃଙ୍ଗ୍ ମିସୁଲି, ଜଃନ୍‌କଃରି ସାସ୍ତରେ ଲେକାଆଚେ- ");
INSERT INTO bdv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ମାପ୍ରୁ କୟ୍‌ଲା, ଇତାର୍‌ ହଃଚେ ମୁୟ୍‌ଁ ବାଉଳି ଆସିନ୍ଦ୍‌, ଆର୍‌ ଦାଉଦାର୍‌ ବଃସୁଳ୍‌ଲା ଗଃର୍‌ ଆରେକ୍‌ ବାନ୍ଦିନ୍ଦ୍‌ । ଆରେକ୍‌ ତାର୍‌ ବଃସମ୍‌ ଟାଣ୍ ସଃବୁ ଆରେକ୍‌ ବାନ୍ଦି ସେରି ଆରେକ୍‌ ଟିଆ କଃରିନ୍ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ଜଃନ୍‌କଃରି ଉବୁର୍ଲା ଲକ୍‌ ଆର୍‌ ଜୁୟ୍‌ ସଃବୁ ଅଜିଉଦି ଲକ୍‌ ମର୍‌ ନାଉଁଏ ଡାକ୍‌ ହୁଟାଅୟ୍‌ ସେମଃନ୍ ମାପ୍ରୁକ୍‌ ଲଳ୍‌ତି । ସଃବୁ ସାଦୁନ୍‌ କଃର୍ତା ମାପ୍ରୁ ଇରି କଃଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ମାପ୍ରୁ ଇ କଃତା କଃଉଁଲା, ଜେ ହୁର୍ବ୍‌କାଳେ ହୁଣି ଇ କଃତା ଜାଣାୟ୍‌ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ତଃବେ ମର୍‌ ବିଚାର୍‌ ଇରି ଅଜିଉଦି ଲକ୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ମଃନ୍ ଇସ୍ୱର୍‌ ହାକ୍‌ ବାଉଳ୍‌ତି ସେମଃନ୍‌କେ ଅଃମିମଃନ୍‌ ବଜ୍‌ ବଳାଉଁ ନଃଚୁଆଁ । ");
INSERT INTO bdv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ମଃତର୍‌ ମୁର୍ତି ବିସୟାର୍‌ ବିଟାଳ୍‌, ଦାରି, ଟଟି ହିଚି ମଃରାୟ୍‌ଲାର୍‌ ଜଃତୁ ଆର୍‌ ବଃନି ହୁଣି ଅଃଲ୍‌ଗା ରେଉଁକ୍‌ ଅଃମି ସେମଃନ୍‌କେ ଚିଟି ଲେକୁଆଁ । ");
INSERT INTO bdv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ହୁର୍ବ୍‌ କାଳେହୁଣି ହଃତି ଗଃଳେ ମସାର୍‌ ପର୍ଚାର୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍ ଆଚ୍‌ତି; ହଃତି ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ପାର୍ତ୍‌ନା ଗଃରେ ତାର୍‌ ବିଦି ହାଟ୍‌ କଃରାଅଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ତାର୍‌ହଃଚେ ପେରିତ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ସଃବୁ ମଣ୍ଡ୍‌ଳି ସଃଙ୍ଗ୍ ତାକାର୍‌ ତାକାର୍‌ ବିତ୍ରାର୍‌ ଲକ୍‌, ବଃଲେକ୍‌ ବାୟ୍‌ମଃନାର୍‌ ବିତ୍ରେ ମୁଳିକା ବର୍ସବା ନାଉଁଏ ଡାକ୍‌ହୁଟା ଜିଉଦା ଆର୍‌ ସିଲାକ୍‌ ବାଚି କଃରି ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ସଃଙ୍ଗ୍ ଆନ୍ତିଅକିଆକ୍‌ ହଃଟାଉଁକ୍‌ ତିର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ଆର୍‌ ସେମଃନ୍ ସେମଃନାର୍‌ ଆତେ ଇ ଚିଟି ଲେକି ହଃଟାୟ୍‌ଲାୟ୍‌, “ଆନ୍ତିଅକିଆ, ସୁରିଆ ଆର୍‌ କିଲିକିଆର୍‌ ଅଜିଉଦି ବାୟ୍‌ବେଣିମଃନ୍‌କେ ପେରିତ୍‌ ଆର୍‌ ପାରାଚିନ୍ ବାୟ୍‌ମଃନାର୍‌ ଜୁଆର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ଅଃମିମଃନ୍‌ ସୁଣି ଆଚୁ ଜେ, ଅଃମିମଃନ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ କାୟ୍‌ ବଲ୍‌ ନଃଦେଉଁ ଅଃମାର୍‌ ବିତ୍ରାର୍‌ ଅଃନ୍‌କାର୍‌ କଃତେକ୍‌ ଲକ୍‌ କଃତାୟ୍‌ ତୁମିମଃନାର୍‌ ମଃନ୍‌କେ ବିଗଃଳାୟ୍‌ କଃରି କାବା କଃରାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଆର୍‌ ଅଃମିମଃନ୍‌ ଲକମଃନ୍ ଅୟ୍‌ ଗଟେ ଟାଣେ କଃରି ହଃଟାଉଁକେ ବାଚି ଆଚୁ ସେମଃନ୍ ଲାଡାର୍‌ ବର୍ନବା ଆର୍‌ ପାଉଲ୍‌ ସଃଙ୍ଗ ଜାତି, ");
INSERT INTO bdv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଏ ବାୟ୍‌ମଃନ୍‌ ମାପ୍ରୁ ଜିସୁ କ୍ରିସ୍ଟର୍‌ ସେବାୟ୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିବନ୍ ବିବ୍‌ତି ତଃୟ୍‌ ହଃକାୟ୍‌ ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ଇତାକ୍‌ ଅଃମିମଃନ୍‌ ଜିଉଦା ଆର୍‌ ସିଲାକେ ହଃଟାଉଁଲୁ ଇମଃନ୍‌ ହେଁ ତାକାର୍‌ ମୁଏଁ ତୁମିମଃନ୍‌କେ ସେସଃବୁ କଃତା ଜାଣାଉତି । ");
INSERT INTO bdv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","କଃତେକ୍‌ ଲଳାରି ବିଦିଚାଡି ତୁମିମଃନାର୍‌ ଉହ୍ରେ ଆରେକ୍‌ କାୟ୍‌ହେଁ ବଜ୍‌ ନଃଦେଉଁକେ ଅଃମି ପବିତ୍ର ଆତ୍ମା ତଃୟ୍‌ ହୁଣି ଆଦେସ୍‌ ହାୟ୍‌ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ସେ କଃତିଗଟ୍‌ ନିୟମ୍‌ ଅୟ୍‌ଲି ମୁର୍ତି ହୁଜାକାଦି କାହା ନାୟ୍‌ ବଃନି କାହା ନାୟ୍‌ ଆର୍‌ ଗଃଳା ନଃକାଟି ମାରିରିଲା ହସୁ ମାସ୍‌ କାହା ନାୟ୍‌, ଦାରି କାମ୍‌ ଚାଡି ଦିଆସ୍‌ ଇସଃବୁ କାମ୍‌ ନଃକେରୁକେ ଜଃଗ୍ରାତ୍‌ ରିଲେକ୍‌ ଉହ୍‌କାର୍‌ ଅୟ୍‌ଦ୍‌ । ଅଃମାର୍‌ ଜୁଆର୍‌ ହାଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ସେମଃନ୍‌କେ ମେଲାଣି ଦିଲାକ୍‌ ଆନ୍ତିଅକିଆକ୍‌ ଆୟ୍‌ଲାୟ୍‌ । ଆର୍‌ ବିସ୍ୱାସି ମଃନ୍‌କେ ରୁଣ୍ଡାୟ୍‌ ଚିଟି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ସେମଃନ୍ ସେରି ହଳି, ସୁସ୍ତା ଅୟ୍‌ ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଆରେକ୍‌ ଜିଉଦା ଆର୍‌ ସିଲା ନିଜେ ନିଜେ ହେଁ ବାବ୍‌ବାଦି ରିଲାକେ ବୁତେକ୍‌ ଗଃଳି କଃତା କୟ୍‌ ସେ କଃତାକ୍‌ ବୁଜାୟ୍‌ ବାୟ୍‌ମଃନ୍‌କେ ହେଁ ତିର୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆର୍‌ ସେତି ସେମଃନ୍ କଃତି ଦିନ୍ ରିଲା ହଃଚେ ସେମଃନ୍‌କେ ହଃଟାୟ୍‌ ରିଲା ଲକ୍‌ମଃନ୍ ହାକ୍‌ ବାଉଳି ଜଃଉଁକେ ବିସ୍ୱାସି ବାୟ୍‌ମଃନ୍‌ ସୁସ୍ତାୟ୍‌ ମେଲାଣି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମଃତର୍‌ ସିଲା ସେତି ରେଉଁକ୍‌ ମଃନ୍‌ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ଆରେକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ଆନ୍ତିଅକିଆୟ୍‌ ରଃୟ୍‌ ଗାଦେକ୍‌ ଲକାର୍‌ ସଃଙ୍ଗ୍ ମିସି ମାପ୍ରୁର୍‌ କଃତା ସିକ୍ୟା ଦିଲାୟ୍‌ ଆର୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","କଃତି ଦିନ୍ ହଃଚେ ପାଉଲ୍‌ ବର୍ନବାକ୍‌ କୟ୍‌ଲା, “ଆଉ ଆମିମଃନ୍ ଜୁୟ୍‌ ଗଃଳେ ମଃନ୍ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରି ଆଚୁ ସେ ସଃବୁ ଗଃଳ୍‌କେ ବାଉଳି ଜାୟ୍‌ ବାୟ୍‌ମଃନ୍ କଃନ୍‌କାର୍‌ ଆଚ୍‌ତି ସେରି ଦଃକୁକ୍‌ ଜୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ଜହନ୍‌ ମାର୍କକେ ହେଁ ସଃଙ୍ଗେ ନେଉଁକ୍‌ ବର୍ନବାର୍‌ ମଃନ୍ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମଃତର୍‌ ସେ ସେମ୍‌ନଃକେ ଚାଡି ପପୁଲିଆ ହୁଣି ଆସିରିଲା ଆର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ପର୍ଚାର୍‌ କାମ୍‌କେ ଜାୟ୍‌ ନଃରିଲା, ତାକେ ସଃଙ୍ଗେ ନେଉଁକ୍‌ ପାଉଲ୍‌ ଟିକ୍‌ ନାୟ୍‌ ବଃଲି ବାବ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ସେତାକ୍‌ ପାଉଲ୍‌ ଆର୍‌ ବର୍ନବା ବଃଡେ ଉଳାଉଳି ଅୟ୍‌ଲାକ୍‌ ସେମଃନ୍ ତାକାର୍‌ ବିତ୍ରେ ଅଃଲ୍‌ଗା ଅୟ୍‌ଲାୟ୍‌; ବର୍ନବା ଜଃନ୍‌ମାର୍କ ମାର୍କକେ ସଃଙ୍ଗେ ନଃୟ୍‌ ହାଣିଜାଜେ ସାଇପ୍ରସ୍‌ ହାକ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମଃତର୍‌ ପାଉଲ୍‌ ସିଲାକ୍‌ ବାଚିକଃରି ବାୟ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମାପ୍ରୁର୍‌ ଦଃୟାୟ୍‌ ସଃହ୍ରିଅୟ୍‌ ବାଉଳି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ଆର୍‌ ସେ ସୁରିଆର୍‌ କିଲିକିଆ ବାଟ୍‌ ଅୟ୍‌ ଜଃଉଁଜଃଉଁ ମଣ୍ଡ୍‌ଳିମଃନ୍‌କେ ସୁସ୍ତିର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ହଃଚେ ପାଉଲ୍‌ ଦର୍ବି ଆର୍‌ ଲୁସ୍ତ୍ରା ହେଁ ଆୟ୍‌ଲା ଆର୍‌ ସେଟାଣେ ତିମତି ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଚେଲା ରିଲା, ସେ ଗଟେକ୍‌ ବିସ୍ୱାସି ଜିଉଦି ମାୟ୍‌ଜିର୍‌ ହୟ୍‌ସି, ମଃତର୍‌ ତାର୍‌ ଉବାସି ଗ୍ରିକ୍‌ ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ଆର୍‌ ଇକନିଆୟ୍‌ ରେତା ବାୟ୍‌ବେଣି ତିମତିକେ ନିକଲକ୍‌ ବଃଲି ସାକି ହାୟ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ତାକେ ସଃଙ୍ଗେ ନେଉଁକ୍‌ ପାଉଲ୍‌ ମଃନ୍‌କଃଲା ଆର୍‌ ସେ ସଃବୁ ହଲିୟେ ରିଲା ଜିଉଦିମଃନାର୍‌ ଗିନେ ତାକେ ନଃୟ୍‌ ସୁନତି କଃଲା । କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ତାର୍‌ ଉବାସି ଗଟେକ୍‌ ଗ୍ରିକ୍‌ ଲକ୍‌ ବଃଲି ସଃବୁ ଜାଣି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ଆରେକ୍‌ ସେମଃନ୍ ବିନ୍‌ବିନ୍‌ ଗଃଳ୍‌ମଃନ୍‌କେ ଜଃଉଁଜଃଉଁ ଜିରୁସାଲମାର୍‌ ପେରିତ୍‌ମଃନାର୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ଟିକ୍‌ କଃରି ତିର୍‌ କଃଲା ବଲ୍‌ ମାନୁକ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ସଃହ୍ରିଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ଅଃନ୍‌କଃରି ମଣ୍ଡ୍‌ଳିମଃନ୍ ବିସ୍ୱାସେ ତିର୍‌ ଅୟ୍‌ ଦିନ୍ ଦିନ୍‌କେ ବୁତେକ୍‌ ଅଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ସେତାକ୍‌ ସେମଃନ୍ ଆସିଆ ତଃୟ୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ ପବିତ୍ର ଆତ୍ମା ମଃନ୍‌ ନଃକେଲାକ୍‌ ପ୍ରୁଗିଆ ଆର୍‌ ଗାଲାତି ବାଟ୍‌ ଅୟ୍‌ଗଃଲାୟ୍‌ ");
INSERT INTO bdv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ଆର୍‌ ସେମଃନ୍ ମୁସିଆ ତଃୟ୍‌ ହଚି ବିତୁନିଆ ଜଃଉଁକେ ମଃନ୍ କଃଲାୟ୍‌, ମଃତର୍‌ ଜିସୁର୍‌ ଆତ୍ମା ସେମଃନ୍‌କେ ଜଃଉଁକେ ନଃଦିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ସେତାକ୍‌ ସେମଃନ୍ ମୁସିଆ ବାଟଅୟ୍‌ ତ୍ରୟା ହଚ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଆର୍‌ ରାତିବଃଳ୍‌ ପାଉଲ୍‌ ଗଟେକ୍‌ ଦଃର୍ସନ୍‌ ଦଃକ୍‌ଲା, ମାକିଦନିଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଟିଆଅୟ୍‌ ତାକେ ଗଃଉଆରିକଃରି କଃଉଁଲା । “ମାକିଦନିଆ ତଃୟ୍‌ହୁଣି ଅଃମାର୍‌ ତଃୟ୍‌ ଆସି ଅଃମାର୍‌ ଉହ୍‌କାର୍‌ କଃର୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ସେ ଦଃର୍ସନ୍‌ ଦଃକ୍‌ଲା ହଃଚେ ଆମିମଃନ୍ ତଃତ୍‌କାଣ୍ ମାକିଦନିଆକେ ଜଃଉଁକେ ତିଆର୍‌ ଅୟ୍‌ଲୁ କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନାର୍‌ ଚଃମେ ସେମଃନାର୍‌ ତଃୟ୍‌ ନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃରୁକେ ଇସ୍ୱର୍‌ ଆମିମଃନ୍‌କେ କୁଦି ଆଚେ ବଃଲି ଆମିମଃନ୍ ବୁଜ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ସେତାକ୍‌ ତ୍ରୟା ତଃୟ୍‌ହୁଣି ହାଣି ଜାଜେ ଅଃମିମଃନ୍‌ ସାମତ୍ରାକିକେ ଆର୍‌ ଆର୍‌କ ବିନ୍ ନିଆପଲିକେ ହଚ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ସେତି ହୁଣି ପିଲିପକେ ଗଃଲୁ, ଇରି ମାକିଦନିଆ ଜିଲାର୍‌ ଗଟେକ୍‌ ବଃଡ୍ ଗଃଳ୍‌ ଆର୍‌ ରମ୍‌ ଦେସାର୍‌ ଲକ୍‌ମଃନ୍ ଆସି ବାସା କଃର୍ତା ଗଟେକ୍‌ ଟାଣ୍, ସେ ଗଃଳେ ଆମିମଃନ୍ ବୁତେକ୍‌ ଦିନ୍ ରିଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ଗଃଳ୍‌ ଦୁଆରେ ହୁଣି ବାରାୟ୍‌ ଗାଡ୍‌କଃଣ୍ଡାୟ୍‌ ଗଃଲୁ, ସେତି ପାର୍ତ୍‌ନା କଃର୍ତା ଟାଣ୍ ଆଚେ ବଃଲି ଆମିମଃନ୍ ମଃନେ ବାବ୍‌ତି ରିଲୁ ଆର୍‌ ଅଃମିମଃନ୍‌ ବଃସି ରୁଣ୍ଡିରିଲା ମାୟ୍‌ଜିମଃନ୍‌କେ କଃତା ଅଃଉଁକେ ଦଃର୍ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ଆରେକ୍‌ ତୁୟତିରା ଗଃଳାର୍‌ କଃଚା ହଃତ୍ରିଆ ବଃସ୍ତର୍‌ ବିକ୍‌ତା ଲୁଦିଆ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ମାୟ୍‌ଜି ସେ ଇସ୍ୱର୍‌କେ ମାନ୍‌ତି ରିଲି, ସେ ଅଃମାର୍‌ କଃତା ସୁଣ୍‌ତି ରିଲି । ସେ ଜଃନ୍‌କଃରି ପାଉଲାର୍‌ କୟ୍‌ଲା କଃତାମଃନ୍‌ ଦିଆନ୍‌ ଦେତିରିଲି ଇତାର୍‌ ଗିନେ ମାପ୍ରୁ ତାର୍‌ ମଃନ୍ ଉଗାଳ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଆରେକ୍‌ ସେ ଆର୍‌ ତାର୍‌ ଗଃର୍‌କୁଟୁମ୍‌ ବାପ୍ତିସମ୍‌ ନିଲା ହଃଚେ, ସେମଃନଃକେ ଗଃଉଆରି କଃରି କୟ୍‌ଲି, ତୁମିମଃନ୍ ଜଦି ମକ୍‌ ମାପ୍ରୁର୍‌ ବିସ୍ୱାସି ଲକ୍‌ ବଃଲି ବିଚାର୍‌ କଃରୁଲାସ୍‌, “ତଃବେ ମର୍‌ ଗଃରେ ଆସି ରିଆ ବଃଲି ସେ ଆମିମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲି ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଗଟ୍‌ଦିନ୍‌ ଆମିମଃନ୍ ପାର୍ତ୍‌ନା ଟାଣେ ଜଃଉଁଜଃଉଁ ସୟ୍‌ତାନ୍‌ ସଃକ୍ତି ରିଲା ଗଟେକ୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳି ଆମିମଃନ୍‌କେ ବେଟ୍‌ ଅୟ୍‌ଲି । ସେ ଲକ୍‌ମଃନାର୍‌ ହାଞ୍ଜି ଦଃକ୍‌ତି ରିଲି । ସେତାକ୍‌ ତାର୍‌ ସାଉକାରାର୍‌ ବଃଡେ ଲାବ୍‌ ହାଉତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ସେ ପାଉଲ୍‌ ଆର୍‌ ଅଃମାର୍‌ ହଃଚେ ହଃଚେ ଆସି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉଁକେ ଦଃର୍ଲି “ଇ ଲକଃମଃନ୍ ସଃବ୍‌କେ ବଃଡ୍ ଇସ୍ୱରାର୍‌ ଗତିଦଃଙ୍ଗ୍‌ଳାମଃନ୍‌, ସେମଃନ୍ ତୁମିମଃନ୍‌କେ ମୁକ୍ଳାଉତା ବାଟ୍‌ ଦଃକାଉଁଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ସେ ବୁତେକ୍‌ ଦିନ୍ ହଃତେକ୍‌ ଇରି କଃଲି, ମଃତର୍‌ ପାଉଲ୍‌ ରିସା ଅୟ୍‌ ଉଲ୍‌ଟି ଦଃକି ସେ ଆତ୍ମାକେ କୟ୍‌ଲା, “ଜିସୁ କ୍ରିସ୍ଟର୍‌ ନାଉଁଏ କଃଉଁଲେ, ତାର୍‌ ତଃୟ୍‌ହୁଣି ବାରୟ୍‌ଜାଆ ।” ଇତାକ୍‌ ସେଦାହ୍ରେ ବାରାୟ୍‌ ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ମଃତର୍‌ ତାର୍‌ ସାଉକାର୍‌ମଃନ୍ ତାକାର୍‌ ଲାବାର୍‌ ବଃର୍ସା ଗଃଲି ବଃଲି ପାଉଲ୍‌ ଆର୍‌ ସିଲାକ୍‌ ଦଃରି ଗଃଳାର୍‌ ବଃଜାରାର୍‌ ମଃଜିଟାଣେ ସେମଃନ୍‌କେ ସଃର୍କାରି ଅଃଦିକାରିମଃନାର୍‌ ଚଃମେ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ଆର୍‌ ସେମଃନ୍ ସେମଃନ୍‌କେ ରମିୟ ବିଚାର୍‌ କଃର୍ତା ଲକାର୍‌ ତଃୟ୍‌ ଆଣି କୟ୍‌ଲାୟ୍‌, “ଇ ଲକ୍‌ମଃନ୍ ଜିଉଦି, ଇମଃନ୍‌ ଅଃମାର୍‌ ଗଃଳେ ଗଲ୍‌ମାଲ୍‌ କଃରୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ଅଃମାର୍‌ ରମିୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଜୁୟ୍‌ ସଃବୁ ତିରିବିଦି ମାନ୍‌ତାର୍‌ ବିଦି ନାୟ୍‌ ସେରି ଇମଃନ୍‌ ସିକାଉଁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ସେତାକ୍‌ ଲକ୍‌ମଃନ୍ ହେଁ ସେମଃନାର୍‌ ବିରଦେ ଉଟ୍‌ଲାୟ୍‌ । ଆରେକ୍‌ ବିଚାର୍‌ କଃର୍ତା ଲକ୍‌ମଃନ୍ ସେମଃନାର୍‌ ବଃସ୍ତର୍‌ କାଡି ସେମଃନ୍‌କେ ବେତ୍‌ଡାଙ୍ଗ୍ ସଃଙ୍ଗ୍ ମାରୁକ୍‌ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ସେମଃନ୍ ସେମଃନ୍‌କେ ଜଃବର୍‌ ମାର୍ଲାୟ୍‌, ଆର୍‌ ଜଃଇଲ୍‌ ଗଃରେ ହୁରାୟ୍‌ କଃରି ଜଃଇଲାର୍‌ ଅଃଦିକାରିକ୍‌ ସେମଃନ୍‌କେ ଜାଗ୍ରତେ ଜାଗିରେଉଁକେ କୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ସେ ଅଃନ୍‌କାର୍‌ ଆଦେସ୍‌ ହାୟ୍‌ ସେମଃନ୍‌କେ ଜଃୟ୍‌ଲ୍‌ ଜାଗ୍ଉଆଳି ବିତୁର୍‌ ଜଃଇଲେ ହୁରାୟ୍‌ ସେମଃନାର୍‌ ଗଡେ ବଃଡ୍‌ କଟ୍‌ଲା ବାନ୍ଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ମଃତର୍‌ ମଃଜାରାତି ପାଉଲ୍‌ ଆର୍‌ ସିଲା ଇସ୍ୱର୍‌ ତଃୟ୍‌ ପାର୍ତ୍‌ନା ଆର୍‌ ପ୍ରସଂସାର୍‌ ଗିତ୍‌ କଃଉତି ରିଲାୟ୍‌, ଆର୍‌ ବିନ୍ କଃୟ୍‌ଦିମଃନ୍ ସୁଣ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ସଃଡେବଃଳ୍‌ ତଃତ୍‌କାଣ୍ ଦଃର୍ତି ଲଃଦ୍‌ବଃଦ୍‌ଲି ଆର୍‌ ଜଃଇଲ୍‌ ଗଃରାର୍‌ କୁନାଦି ଦଃଲ୍‌କି ଜଃଉଁକେ ଆରୁମ୍‌ ଅୟ୍‌ଲି ଆର୍‌ ତଃତ୍‌କାଣ୍ ସଃବୁ ଦୁଆର୍‌ ଉଗାଳି ଅୟ୍‌ଲି ଆର୍‌ ହଃତି ଲକାର୍‌ ଆତ୍‌ଦଃଣ୍ଡା ଇଟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ଇତାକ୍‌ ଜୁୟ୍‌ ଜଃଇଲ୍‌ ଅଃଦିକାରି ନିଦେ ହୁଣି ଉଟି ଜଃଇଲାର୍‌ ଦୁଆର୍‌ ଉଗାଳି ଅୟ୍‌ଲାର୍‌ ଦଃକି କଃୟ୍‌ଦିମଃନ୍ ହଃଳାୟ୍‌ ଜାୟ୍‌ ଆଚ୍‌ତି ବଃଲି ମଃନେ ବାବି କଃଣ୍ଡା ବାର୍‌କଃରି ନିଜେ ମାରିଅଃଉଁକେ ଜାତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମଃତର୍‌ ପାଉଲ୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲା, “ତର୍‌ ନିଜାର୍‌ କାୟ୍‌ରି କଃର୍‌ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ସଃବୁ ଇତି ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ଜଃୟ୍‌ଲ୍‌ ଜାଗୁ ଅଳା ଆଣୁକେ କୟ୍‌ ଡଃଗାୟ୍‌ ଡିର୍‌କେ ତଃର୍‌ତଃରି ପାଉଲ୍‌ ଆର୍‌ ସିଲାର୍‌ ଚଃମେ ହଃଳାୟ୍‌ ଆସି ହାଦ୍‌ ତଃଳେ ଡୁଳ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ଆର୍‌ ସେମଃନ୍‌କେ ହଃଦାୟ୍‌ ଆଣି କୟ୍‌ଲା, “ମାପ୍ରୁ, ହାହେ ହୁଣି ମୁକ୍ଳୁକ୍‌ ମକ୍‌ କାୟ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ମାପ୍ରୁ ଜିସୁ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃର୍‌ ତଃନ୍‌ଅୟ୍‌ଲେକ୍‌ ତୁମି ଗଃରାର୍‌ ସଃବୁ ଲକ୍‌ ହାହେ ହୁଣି ମୁକ୍ଳାସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ହଃଚେ ସେମଃନ୍ ତାକେ ଆର୍‌ ତାର୍‌ ଗଃରେ ରିଲା ସଃବ୍‌କେ ମାପ୍ରୁର୍‌ କଃତା କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ଆର୍‌ ଜଃୟ୍‌ଲ୍‌ ଜାଗୁ ସେମଃନ୍‌କେ ରାତି ବଃଳ୍‌ ନଃୟ୍‌ ସେମଃନାର୍‌ ମାଡ୍ କାୟ୍‌ଲା ଗାଉ ସଃବୁ ହାଣାୟ୍‌ ଦୟ୍‌ଦିଲା, ଆରେକ୍‌ ସେ ଆର୍‌ ତାର୍‌ ଗଃର୍‌ କୁଟୁମ୍‌ ସେଦାହ୍ରେ ବାପ୍ତିସମ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ତାର୍‌ହଃଚେ ସେ ଅଃହ୍‌ଣାର୍‌ ଗଃରେ ନଃୟ୍‌ କାଉଁକେ ଦିଲା ଆର୍‌ ସଃବୁ ଗଃର୍‌ କୁଟୁମ୍‌ ସଃଙ୍ଗ୍ ଇସ୍ୱର୍‌କେ ବିସ୍ୱାସ୍‌ କଃରି ବଃଡେ ସଃର୍ଦା ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ସଃକାଳ୍‌ ଅୟ୍‌ଲାକ୍‌ ବିଚାର୍‌ କଃର୍ତା ରମିୟ ଅଃଦିକାରି ସଃଇନ୍‌ମଃନ୍‌କେ ଇରି କୟ୍‌ ହଃଟାୟ୍‌ଲାୟ୍‌ “ସେ ଲକ୍‌ମଃନ୍‌କେ ଚାଡି ଦିଆସ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ସେତାକ୍‌ ଜଃଇଲ୍‌ ଅଃଦିକାରି ପାଉଲ୍‌କେ ଇ କଃତା ଜାଣାୟ୍‌ଲା, “ତୁମିମଃନ୍‌କେ ଚାଡି ଦେଉଁକେ ବିଚାର୍‌ କଃର୍ତା ଅଃଦିକାରିମଃନ୍‌ ହଃଟାୟ୍‌ ଆଚ୍‌ତି, ଇତାକ୍‌ ବାରୟ୍‌ ଆସି ସୁସ୍ତାୟ୍‌ ଜାହା ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ମଃତର୍‌ ପାଉଲ୍‌ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ରମିୟ୍‌ ଲକ୍‌ ଜେ ଅଃମିମଃନ୍‌ ଅଃମାର୍‌ ବିଚାର୍‌ ନଃକେରି ସେମଃନ୍ ସଃବ୍‌କାର୍‌ ମୁଏଁ ଅଃମିକ୍‌ ମାଡ୍ ମାର୍ଲା ହଃଚେ ଜଃଇଲେ ହୁରାୟ୍‌ ଆଚ୍‌ତି ଆର୍‌ ଅଃବେ କି ଲୁକ୍‌ଣେ କି ଆମିମଃନ୍‌କେ ଚାଡି ଦେଉଁଲାୟ୍‌ ? ସେରି ନାୟ୍‌ ମଃତର୍‌ ସେମଃନ୍ ନିଜେ ଆସି ଆମିମଃନ୍‌କେ ବାର୍‌କଃରତ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ସେତାକ୍‌ ସଃଇନ୍ ମଃନ୍ ବିଚାର୍‌ କଃର୍ତା ମୁଳିକାମଃନ୍‌କେ ଇ ସଃବୁ କଃତା ଜାଣାୟ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ସେମଃନ୍ ଜେ ରମିୟ ଲକ୍‌ ଇରି ସୁଣି ଡିରି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ଆର୍‌ ସେମଃନ୍ ଆସି ସେମଃନ୍‌କେ ଗଃଉଆରି କଃଲାୟ୍‌, ଆର୍‌ ସେମଃନ୍‌କେ ବାର୍‌କଃରି ଆଣି ଗଃଳେ ହୁଣି ବାରାୟ୍‌ ଜଃଉଁକେ ସେମଃନ୍‌କେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ସେତାକ୍‌ ପାଉଲ ଆର୍‌ ସିଲା ଜଃଇଲେ ହୁଣି ବାର୍‌ଅୟ୍‌ ଜାୟ୍‌ ଲୁଦିଆର୍‌ ଗଃରେ ଗଃଲାୟ୍‌ । ଆର୍‌ ବାୟ୍‌ ମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସି ସେମଃନ୍‌କେ ବଃର୍ସା କଃତା କୟ୍‌ଲା ହଃଚେ ସେତି ହୁଣି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ହଃଚେ ସେମଃନ୍ ଆପିପଲି ଆର୍‌ ଆପଲନିଆ ବାଟ୍‌ ଅୟ୍‌ ତେସଲନିକିକେ ଆୟ୍‌ଲାୟ୍‌, ସେତି ଜିଉଦିମଃନାର୍‌ ଗଟେକ୍‌ ପାର୍ତ୍‌ନା ଗଃର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ଆର୍‌ ପାଉଲ୍‌ ତାର୍‌ ରିତି ହଃର୍କାରେ ସେମଃନାର୍‌ ଚଃମେ ଗଃଲା, ଆରେକ୍‌ ତିନି ବିସାଉଁଣିବାର୍‌ ହଃତେକ୍‌ ସାସ୍ତରାର୍‌ କଃତା ସେମଃନ୍‌କେ ବୁଜାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦଃର୍ମ୍‌ସାସ୍ତର୍‌ କୟ୍‌କଃରି ବୁଜାୟ୍‌ଲା “ଜେ ମସିହର୍‌” ଦୁକ୍‌ବୟ୍‌ଗ୍‌ ଆର୍‌ ମଃର୍ନ୍‌ ବୟଃଗ୍ କଃରି ମଃଲା ଲକ୍‌ତଃୟ୍‌ହୁଣି ଉଟ୍‌ତାର୍‌ ଲଳା ରିଲି ଆର୍‌ ସେ ଜୁୟ୍‌ ଜିସୁକେ ସେମଃନାର୍‌ ତଃୟ୍‌ ପର୍ଚାର୍‌ କଃରୁଲା ସେ ଜେ କ୍ରିସ୍ଟ ଇ କଃତା ଟିକ୍‌ କଃରି ବୁଜାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ସେତାକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃତି ଲକ୍‌ ବିସ୍ୱାସ୍‌ କଃରି ପାଉଲ୍‌ ଆର୍‌ ସିଲାର୍‌ ସଃଙ୍ଗ୍ ମିସ୍‌ଲାୟ୍‌ ଆର୍‌ ଜିଉଦି ଦଃର୍ମ୍‌ କଃର୍ତା ଗ୍ରିକ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ଆର୍‌ କଃତିଗଟ୍‌ ମାୟନ୍ ହାଉତା ମାୟ୍‌ଜିମଃନ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ମିସ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ମଃତର୍‌ ଜିଉଦିମଃନ୍ ଡାରା ଅୟ୍‌ କଃତେକ୍‌ ବଃଜାରାର୍‌ କଃତିଗଟ୍‌ ଦୁସ୍ଟଲକ୍‌ମଃନକେ ସଃଙ୍ଗେ ଆଣି ଲକ୍‌ମଃନକେ ଗଟେଟାଣେ କଃରି ଗଃଳେ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଲାଗାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଜାସନାର୍‌ ଗଃରେ ହୁରି ସେମଃନ୍‌କେ ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ବାର୍‌କଃରି ଆଣୁକେ ଉପାୟ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ମଃତର୍‌ ସେମଃନ୍‌କେ ନଃହାୟ୍‌, ସେମଃନ୍ ଜାସନ୍‌ ଆର୍‌ କଃତିଲକ୍‌ ବିସ୍ୱାସି ବାୟ୍‌ମଃନ୍‌କେ ଗଃଳାର୍‌ ସଃର୍କାରି ଅଃଦିକାରିମଃନାର୍‌ ତଃୟ୍‌ ଜିକି ଆଣି ରାଟୁକଃରି କୟ୍‌ଲାୟ୍‌, “ଇ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍ ହୁର୍ତିବିକ୍‌ ଉଲ୍‌ଟାହାଲ୍‌ଟା କଃଲାୟ୍‌ନି ସେମଃନ୍ ଇତି ହେଁ ଆସି ଆଚ୍‌ତି, ");
INSERT INTO bdv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ସେମଃନ୍‌କେ ଜାସନ୍‌ ତାର୍‌ ଗଃରେ କୁଦି ଆଚେ । ଜିସୁ ନାଉଁଏ ଆରେକ୍‌ ଗଟ୍‌ ରଃଜା” ଆଚେ ବଃଲି କୟ୍‌ ଇମଃନ୍‌ ରମ୍‌ ଦେସାର୍‌ କାଇସର୍‌ ବିରଦ୍‌ କଃରୁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ସେମଃନାର୍‌ ଇ କଃତା ସୁଣି ଲକ୍‌ମଃନ୍ ଆର୍‌ ରମ୍‌ ସଃର୍କାର୍‌ ଅଃଦିକାରିମଃନ୍‌ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ହଃଚେ ସେମଃନ୍ ଜାସନ୍ ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳି ମଃନ୍‌କେ ଜରିମନା ନଃୟ୍‌ ଜାମିନେ ଚାଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ଆରେକ୍‌ ବାୟ୍‌ମଃନ୍ ପାଉଲ୍‌ ଆର୍‌ ସିଲାକ୍‌ ରାତିବଃଳ୍‌ ବରିଆକେ ହଃଟାୟ୍‌ଲାୟ୍‌ । ସେମଃନ୍ ସେତି ହଚି ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତେସଲନିକି ତଃୟ୍‌ ରେତା ଜିଉଦିମଃନ୍‌ ହୁଣି ଇମଃନ୍‌ କଲାମଃନାର୍‌ ରିଲାୟ୍‌, ଇମଃନ୍‌ ବଃଡେ ସଃର୍ଦାୟ୍‌ ମାପ୍ରୁର୍‌ କଃତା ସୁଣ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ଇ ସଃବୁ ସଃତ୍‌ କି ନାୟ୍‌ ଜାଣୁକେ ହଃତିଦିନ୍ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ହଳ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ସେତାକ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଆର୍‌ ଗ୍ରିକ୍‌ମାୟ୍‌ଜିମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ମାଜନ୍‌ ମାୟ୍‌ଜି ଆର୍‌ ଅଃଣ୍ଡ୍ରାମଃନ୍‌ ହେଁ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ ତେସଲନିକିର୍‌ ଜିଉଦିମଃନ୍ ଜାଣ୍‌ଲାୟ୍‌ ଜେ, ଇସ୍ୱରାର୍‌ କଃତା ପାଉଲ୍‌ ବରିଆୟ୍‌ ହେଁ ପର୍ଚାର୍‌ କଃଲା, ସଃଡେବଃଳ୍‌ ସେମଃନ୍ ସେତି ଆସି ଲକ୍‌ମଃନ୍‌କେ ଜାଣାୟ୍‌ଲାୟ୍‌ ଆର୍‌ ଡିରାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ସେତାକ୍‌ ବାୟ୍‌ମଃନ୍ ବେଗି ପାଉଲ୍‌କେ ସଃମ୍‌ନ୍ଦ୍ ବାଟ୍‌ ଜଃଉଁକେ ହଃଟାୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସିଲା ଆର୍‌ ତିମତି ସେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ମଃତର୍‌ ଜୁୟମଃନ୍ ପାଉଲ୍‌କେ ସଃଙ୍ଗେ ନିଲାୟ୍‌, ସେମଃନ୍ ତାକେ ଏତେନ୍‌ସ୍‌ ହଃତେକ୍‌ ବାଉଳାୟ୍‌ ଆଣ୍‌ଲାୟ୍‌ ଆର୍‌ ସିଲା ଆର୍‌ ତିମତି ଜଃନ୍‌କଃରି ବେଗି ତାର୍‌ତଃୟ୍‌ ଆସ୍ତି, ପାଉଲାର୍‌ ଇ ଆଦେସ୍‌ ସୁଣି ଆୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଏତେନ୍‌ସ୍‌ ତଃୟ୍‌ ପାଉଲ୍‌, ସିଲା ଆର୍‌ ତିମତିର୍‌ ଆସ୍ତାର୍‌ ଜାଣି ରେତା ବଃଳ୍‌ ସେ ଗଃଳେ ହୁରି ମୁର୍ତି ଗାଦା ରିଲାର୍‌ ଦଃକି ପାଉଲ୍‌ ଆତ୍ମାୟ୍‌ ଦୁକ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ସେତାକ୍‌ ସେ ପାର୍ତ୍‌ନା ଗଃରେ ଜିଉଦି ଆର୍‌ ଇସ୍ୱର୍‌କେ ସେବା କଃର୍ତା ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆର୍‌ ଡେଳା ବାଟେ ହଃତିଦିନ୍ ଜୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ସଃଙ୍ଗ୍ ବେଟ୍‌ ଅଃଉତି ରିଲା ସେମଃନ୍‌କେ ସେମଃନାର୍‌ ବିସୟେ କଃତା କଃଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ସେତି ଏପିକୁର ଆର୍‌ ସ୍ତଇକାର୍‌ କଃତିଗଟ୍‌ ଗୁରୁମଃନ୍‌ ହେଁ ତାର୍‌ସଃଙ୍ଗ୍ କଃତା କାଟାକାଟି ଅଃଉତିରିଲାୟ୍‌ ଆର୍‌ କେକେ କୟ୍‌ଲାୟ୍‌ “ଏ ବୁତେକ୍‌ କଃତା କଃଉ କାୟ୍‌ରି କଃଉଁକେ ମଃନ୍‌କଃରୁଲା ?” ଆର୍‌ କେକେ କୟ୍‌ଲାୟ୍‌, “ସେ ବିଦେସି ଦେବ୍‌ତା ମଃନାର୍‌ ପର୍ଚାର୍‌ କଃରୁଲା ବଃଲି ଜାଣାହଃଳୁଲି ।” କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ପାଉଲ୍‌ ଜିସୁ ମଃରି ଉଟ୍‌ଲା କଃତା ପର୍ଚାର୍‌ କଃର୍ତିରିଲା ବଃଲି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ହଃଚେ ସେମଃନ୍ ପାଉଲ୍‌କେ ଜିଉଦି ବେରାଣେ ଆରପାଗ୍ ତଃୟ୍‌ ନିଲାୟ୍‌, ଆର୍‌ କୟ୍‌ଲାୟ୍‌, “ଇ ଜୁୟ୍‌ ନଃଉଆଁ ସିକ୍ୟା ତୁୟ୍‌ ଦେଉଁଲିସ୍‌, ସେରି କାୟ୍‌ରି ବଃଲି ଅଃମି ଜାଣୁ ହାରୁ କି ? ");
INSERT INTO bdv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ତୁୟ୍‌ ଅଃମିମଃନ୍‌କ୍‌ କଃତେକ୍‌ କାବା ଅଃଉତା କଃତା ସୁଣାଉଁଲିସ୍‌, ତଃବେ ଇ ସଃବୁ କଃତାର୍‌ ବାବ୍‌ କାୟ୍‌ରି, ଅଃମି ଜାଣୁକେ ମଃନ୍‌କଃରୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଏତିନିର୍‌ ଲକ୍‌ମଃନ୍ ଆର୍‌ ସେତି ରେତା ବିଦେସି ଲକ୍‌ମଃନ୍ ନଃଉଆଁ କଃଉତାର୍‌ ଆର୍‌ ସୁଣ୍‌ତାର୍‌ ଚାଡି କୁୟ୍‌ କାମେ ହେଁ ସଃମୟ୍‌ ନଃସ୍ଟ୍‌ ନଃକେର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ଇତାକ୍‌ ପାଉଲ୍‌ ଆରପାଗାର୍‌ ବେରାଣ୍ ମଃଜାୟ୍‌ ଟିଆ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଏତିନିର୍‌ ଲକ୍‌ମଃନ୍ ତୁମିମଃନ୍ ସଃବୁ କଃତାୟ୍‌ ବଃଡେ ଦଃର୍ମ୍‌ ବିସ୍ୱାସି ଇରି ମୁୟ୍‌ଁ ଦଃକୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ତୁମାର୍‌ ଗଃଳ୍‌କେ ଅୟ୍‌ ବୁଲ୍‌ତାବଃଳ୍‌ ତୁମିମଃନାର୍‌ ହୁଜାକଃର୍ତା ଟାଣ୍ ସଃବୁ ଦଃକୁ ଦଃକୁ ଗଟେକ୍‌ ବେଦିହିଣ୍ଡା ଦଃକ୍‌ଲେ ଜାର୍‌ ଉହ୍ରେ ଇ କଃତା ଲେକା ଅୟ୍‌ରିଲି, “ନଃଜାଣ୍‌ତା ଦେବ୍‌ତାର୍‌ ଗିନେ ।” ତଃବେ ତୁମିମଃନ୍ ଜାକେ ନଃଜାଣି ହୁଜା କଃରୁଲାସ୍‌, ମୁୟ୍‌ଁ ତାର୍‌ବିସୟେ ତୁମିମଃନାର୍‌ ତଃୟ୍‌ ପର୍ଚାର୍‌ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଜୁୟ୍‌ ଇସ୍ୱର୍‌ ଜଃଗତ୍‌ ଆର୍‌ ସେତିର୍‌ ସଃବୁ ବିସୟ୍‌ ତିଆର୍‌ କଃରି ଆଚେ, ସେ ସଃର୍ଗ୍‌ ଆର୍‌ ହୁର୍ତିବିର୍‌ ମାପ୍ରୁ ଅୟ୍‌ରିଲାକ୍‌ ମାନାୟ୍‌ ଆତେ ତିଆର୍‌ ଅୟ୍‌ଲା ମନ୍ଦିର୍‌ମଃନ୍‌କେ ବାସା ନଃକେରେ । ");
INSERT INTO bdv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ଆରେକ୍‌ ତାର୍‌ କାୟ୍‌ ଉଣା ନଃରିଲାକ୍‌ ମାନାୟ୍‌ ଆତେ ହୁଣି ଦିଲା ହୁଜା ସେ ଲଳା ନଃକେରେ, ସେ ନିଜେ ସଃବ୍‌କେ ଜିବନାର୍‌ ହୁଣ୍ଡାଣ୍ ଆର୍‌ ସଃର୍ନେ ଲଳାରିଲା ବିସୟ୍‌ ଦଃୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ଆର୍‌ ସେ ହୁର୍ତିବିର୍‌ ସଃବୁ ହାକ୍‌ ବାସା କଃରୁକେ ଗଟେକ୍‌ ଲକ୍‌ ତଃୟ୍‌ହୁଣି ସଃବୁ ଲକ୍‌କେ ତିଆର୍‌ କଃରି ଆଚେ, ସେ ସଃବ୍‌କାର୍‌ ଟିକ୍‌ କାଳ୍‌ ଆର୍‌ ବାସା କଃର୍ତାର୍‌ ଦିନ୍ ତିର୍‌ କଃରି ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ସେମଃନ୍ ଜଃନ୍‌କଃରି ଇସ୍ୱର୍‌କେ ଲଳିକଃରି ତାକେ ହାଉଁ ହାର୍ତି, ଅୟ୍‌ଲେକ୍‌ ହେଁ ସେ ଅଃମାର୍‌ କାର୍‌ ତଃୟ୍‌ହୁଣି ଦୁରିକ୍‌ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାର୍‌ ତଃୟ୍‌ ଅଃମାର୍‌, ଜିବନ୍‌ ରେତାର୍‌, ଜାତାର୍‌ ଆର୍‌ ଅବୁସ୍ତା ଜଃନ୍‌କାର୍‌ ତୁମିମଃନାର୍‌ ଗିତ୍‌ଲେକୁ ମଃନାର୍‌ବିତ୍ରେ କେକେ କୟ୍‌ ଆଚ୍‌ତି, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ହେଁ ତାର୍‌ ହିଲା ମଃନ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ତଃବେ ଆମିମଃନ୍ ଇସ୍ୱରାର୍‌ ହିଲା ଅୟ୍‌ରିଲାକ୍‌ ଇସ୍ୱର୍‌ ହର୍‌ ମାନାୟ୍‌ ଗଃଳ୍‌ଲା ଆର୍‌ ବାବ୍‌ନା ହଃର୍କାରେ ଗେନି ରିଲାର୍‌ ସନା କି ରୁହା କି ଟେଳା ହର୍‌ ମଃନେ କଃରା ନାୟ୍‌ ");
INSERT INTO bdv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ଇସ୍ୱର୍‌ ସେ ଗ୍ୟାନ୍ ନୟ୍‌ଲା କାଳ୍‌କେ ଚାଡି ଆଚେ ସଃତ୍‌, ମଃତର୍‌ ସେ ଅଃବେ ସଃବୁ ମାନାୟ୍‌କେ ମଃନ୍‌ ବାଦ୍‌ଲାଉଁକ୍‌ ଜାଣାଉଁଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଦିନ୍ ସେ ଅଃହ୍‌ଣାର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ ହୁଣି ଦଃର୍ମେ ଜଃଗତାର୍‌ ବିଚାର୍‌ କଃରେଦ୍‌, ଅଃନ୍‌କାର୍‌ ଗଟେକ୍‌ ଦିନ୍ ତିର୍‌ କଃରି ଆଚେ ଆର୍‌ ତାକେ ମଃଲା ଲକାର୍‌ ତଃୟ୍‌ ହୁଣି ଉଟାୟ୍‌ ଇ କଃତାକ୍‌ ସଃବ୍‌କାର୍‌ ଦଃୟ୍‌ ହଃର୍ମାଣ୍‌ ଦଃୟ୍‌ ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ମଃର୍ନେ ହୁଣି ଉଟ୍‌ତା କଃତା ସୁଣି କେକେ ଟାହ୍ରା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ କେକେ କୟ୍‌ଲାୟ୍‌, “ଆମିମଃନ୍ ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ଇ କଃତା ସୁଣୁକ୍‌ ମଃନ୍‌କଃରୁଲୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଇରି କୟ୍‌ ପାଉଲ୍‌ ବେରାଣେ ହୁଣି ବାରାୟ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ମଃତର୍‌ କେ କେ ତାର୍‌ ବାଟ୍ୟା ଅୟ୍‌ ତାକେ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌, ସେମଃନାର୍‌ ବିତ୍ରେ ବେରାଣାର୍‌ ସେ ଗଟ୍‌ ମେମର୍‌ ରିଲା ଦିଅନୁସିଅ ଦାମାରି ନାଉଁଆର୍‌ ଗଟେକ୍‌ ମାୟ୍‌ଜି ଆର୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆରେକ୍‌ କଃତି ଲକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଇ ସଃବୁ ଗଃଟ୍‍ଣା ହଃଚେ ସେ ଆତିନି ହୁଣି କରନ୍ତିକେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଆର୍‌ ସେ ଆକିଲା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜିଉଦିଲକେ ବେଟ୍‌ ଅୟ୍‌ଲା, ପନ୍ତ ତାର୍‌ ଜଃଲମ୍‌ ମାଟି ଅଃଳକ୍‌ ଦିନ୍ ଅୟ୍‌ଲି ତାର୍‌ ଡକୁର୍ସି ପ୍ରିସ୍କିଲା ଇତାଲିଆ ହୁଣି ଆସି ରିଲି, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ କ୍ଲାଉଦିଆ ସଃବୁ ଜିଉଦିମଃନ୍‌କେ ରମ୍‌ ହୁଣି ବାରାୟ୍‌ ଜଃଉଁକେ ବଲ୍‌ ଦଃୟ୍‌ ରିଲା । ପାଉଲ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ବେଟ୍‌ ଅଃଉଁକେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ଆର୍‌ ସେମଃନ୍ ସଃଙ୍ଗ୍ ରିଲା, ଆର୍‌ କାମ୍‌ କଃରୁକେ ଦଃର୍ଲା, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେମଃନ୍ ତୁମ୍‌ ବୁଣ୍‌ତା ଲକ୍‌ ରିଲାୟ୍‌ ଏହେଁ ଇ ବେବାରେ ଜିଉତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଆରେକ୍‌ ହଃତି ବିସାଉଁଣିବାର୍‌ ଦିନ୍ ସେ ପାର୍ତ୍‌ନା ଗଃରେ ଆଲ୍‌ଚଃନା କଃରି ଜିଉଦି ଆର୍‌ ଗ୍ରିକ୍‌ ମଃନାର୍‌ ବିସ୍ୱାସ୍‌ କଃରାଉଁକ୍‌ ମଃନ୍ ହାଚ୍‌ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ସଃଡେବଃଳ୍‌ ସିଲା ଆର୍‌ ତିମତି ମାକିଦନିଆୟ୍‌ ହୁଣି ଆୟ୍‌ଲାୟ୍‌ ସଃଡେବଃଳ୍‌ ପାଉଲ୍‌ ମାପ୍ରୁର୍‌ କଃତା ପର୍ଚାର୍‌ କଃରୁକେ ଲାଗିହଃଳିରିଲା, ଆର୍‌ ଜିସୁ ଜେ କ୍ରିସ୍ଟ ବଃଲେକ୍‌ ମସିଅ ଇରି ଜିଉଦି ମଃନ୍‌କେ ସାକି ଦେତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ମଃତର୍‌ ସେମଃନ୍ ବିରଦ୍‌ ଆର୍‌ ଲିନ୍ଦା କଃଲାୟ୍‌, ସେ ଅଃହ୍‌ଣାର୍‌ ହଃଚ୍ୟା ହାହଳି ସେମଃନ୍‌କେ କୟ୍‌ଲା, ତୁମିମଃନାର୍‌ ବଃନି ତୁମାର୍‌ ମୁଣ୍ଡେ ହଃଳ, ମୁୟ୍‌ଁ ନିର୍ଦସ୍‌, ଅଃବେହୁଣି ମୁୟ୍‌ଁ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଜାଇନ୍ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ସେତାକ୍‌ ସେ ଟାଣ୍ ହୁଣି ତିତସ୍‌ ଜୁସ୍ତ ନାଉଁଆର୍‌ ଇସ୍ୱର୍‌ ବିସ୍ୱାସି ଗଃରେ ଗଃଲା, ସେତି ପାର୍ତ୍‌ନା କଃରୁକେ ଲାଗିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ମଃତର୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକା କ୍ରିସ୍ପ ଆର୍‌ ଗଃର୍‌କୁଟୁମ୍‌ ମାପ୍ରୁକ୍‌ ବିସ୍ୱାସ୍‌ କଃଲାୟ୍‌, ଆର୍‌ କରନ୍ତି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ସିକ୍ୟା ସୁଣି ବିସ୍ୱାସ୍‌ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ ଆର୍‌ ବାପ୍ତିସମ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଆରେକ୍‌ ମାପ୍ରୁ ରାତିବଃଳ୍‌ ଦଃକାୟ୍‌ଅୟ୍‌ ପାଉଲ୍‌କେ କୟ୍‌ଲା, “ଡିର୍‌ ନାୟ୍‌, ତୁନ୍ ନଃହାଳି ପର୍ଚାର୍‌ କଃରୁକେ ବନ୍ଦ୍ ନଃକେର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମି ତର୍‌ ସଃଙ୍ଗ୍ ଆଚୁ କୁୟ୍‌ ଲକ୍‌ ତକ୍‌ କାୟ୍‌ କଃରୁକେ ନାହାରେ, ବଃଲେକ୍‌ ଅଃମାର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ଇ ଗଃଳେ ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଆରେକ୍‌ ସେ ସେମଃନାର୍‌ ତଃୟ୍‌ ଇସ୍ୱରାର୍‌ କଃତା ସିକ୍ୟା ଦଃୟ୍‌ ବଃର୍ସେକ୍‌ ଚଅ ମାସ୍‌ ସେତି ବାସ୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ମଃତର୍‌ ଗାଲିଅନ୍ ଆକାୟା ରମିୟ ରାଇଜ୍‌ କଃର୍ତା ବଃଳ୍‌ ଜିଉଦିମଃନ୍ ଜେ ପାଉଲ୍‌ ବିରଦେ ଉଟି ତାକେ ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ବିଚାର୍‌ କଃରୁକେ ଆଣି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ଇ ଲକ୍‌ ମସାର୍‌ ବିଦିର୍‌ ବିରଦାର୍‌ ଇସ୍ୱର୍‌କେ ସେବା କଃରୁକେ ଲକ୍‌ମଃନ୍‌କେ ବୁଲ୍‌କାଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ମଃତର୍‌ ପାଉଲ୍‌ ଟଣ୍ଡ୍ ହୁଟାୟ୍‌ କଃତା କଃଉଁକ୍‌ ଦଃର୍ଲା ବଃଳ୍‌, ଗାଲିଅନ୍ ଜିଉଦିମଃନ୍‌କେ କୟ୍‌ଲା, “ଏ ଜିଉଦିମଃନ୍ କାୟ୍‌ ଅଃନ୍ୟାୟ୍‌ ଅୟ୍‌ରିଲେକ୍‌ ସଃମ୍ବାଳିକଃରି ତୁମିମଃନାର୍‌ କଃତା ସୁଣୁକ୍‌ ଟିକ୍‌ ଅୟ୍‌ଲି ହୁଣି । ");
INSERT INTO bdv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମଃତର୍‌ ଇ ସଃବୁ ଅଃବ୍‌କା କଃତା, ନାଉଁ ଆର୍‌ ଅଃର୍ତ୍‌ ତୁମିମଃନାର୍‌ ମସାର୍‌ ବିଦିର୍‌ କଃତା ଲାଗି, ତୁମିମଃନ୍ ବୁଜା, ମୁୟ୍‌ଁ ଇ ସଃବୁ କଃତା ବିଚାର୍‌ ନଃକେରି ।” ");
INSERT INTO bdv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଇରି କୟ୍‌ ସେମଃନ୍‌କେ ବେରାଣେ ହୁଣି ବାର୍‌କଃରି କଃଦ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ସେତାକ୍‌ ସଃବୁ ଲକ୍‌ ପାର୍ତ୍‌ନା ଗଃରାର୍‌ ମୁଳିକା ସସ୍ତନାକେ ଦଃରି ବେରାଣ୍‌ ମୁୟେ ମାଡ୍ ମାରୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ଗାଲିଅନ୍ ସେ ସଃବୁ କଃତାକ୍‌ ନଃମାନ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ୍‌ ବୁତେକ୍‌ ଦିନ୍ ଦଃରି କରନ୍ତିଏ ବିସ୍ୱାସି ବାୟ୍‌ବେଣିମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲା । ତାର୍‌ ହଃଚେ ସେଲଃଗେ ରିଲା ସିକିରାକେ ଗଃଲା, ହୁର୍ବାର୍‌ ତାର୍‌ ଗଟେକ୍‌ ମାନ୍‌ସିକ୍‌ କଃରିରିଲା ହଃର୍କାରେ କେଙ୍କେରିଆ ତଃୟ୍‌ଁ ସେ ତାର୍‌ ମୁଣ୍ଡ୍‌ କୁରାୟ୍‌ଲା । ତାର୍‌ହଃଚେ ପ୍ରିସ୍କିଲା ଆର୍‌ ଆକିଲା ସଃଙ୍ଗ୍ ହାଣି ଜାଜେ ସିରିଆ ଜଃଉଁକେ ବାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ହଃଚେ ସେମଃନ୍ ଏପିସିଏ ହଚ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ସେଟାଣେ ସେମଃନ୍‌କେ ଚାଡି ନିଜେ ପାର୍ତ୍‌ନା ଗଃର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ଜିଉଦିମଃନ୍‌କାର୍‌ ସଃଙ୍ଗ୍ ଆଲ୍‌ଚଃନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ଆରେକ୍‌ ସେମଃନ୍ ତାକେ ଅଃଦିକ୍‌ ଦିନ୍ ରେଉଁକ୍‌ ଗଃଉଆରି କଃଲାୟ୍‌, ମଃତର୍‌ ସେ ମଃନ୍ ନଃକେଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ମଃତର୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମେଲାଣି ନଃୟ୍‌ କୟ୍‌ଲା, “ଇସ୍ୱରାର୍‌ ଇଚା ଅୟ୍‌ଲେକ୍‌, ଆରେକ୍‌ ଗଟ୍‌ତର୍‌ ତୁମାର୍‌ ତଃୟ୍‌ ବାଉଳି ଆସିନ୍ଦ୍‌ ।” ଆରେକ୍‌ ସେ ଏପିସିଏ ହୁଣି ହାଣି ଜାଜେ ଚଃଗି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","କାଇସରିଆ ହଃଚି ସେ ଜାଜେ ହୁଣି ଉତୁର୍ଲା ଆର୍‌ ଜାୟ୍‌ ବିସ୍ୱାସିମଃନ୍‌କେ ଜୁଆର୍‌ କଃରି ଆନ୍ତିଅକିଆକ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ସେଟାଣେ କଃତି ଦିନ୍ ରିଲା ହଃଚେ ସେ ସେତି ହୁଣି ଗଃଲା, ଆର୍‌ ଗାଲାତି ହଲି ଆର୍‌ ପ୍ରୁଗିଆ ବାଟ୍‌ ଜଃଉଁଜଃଉଁ ଚେଲାମଃନ୍‌କେ ସାସ୍‌ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଇ ବିତ୍ରେ ଆପଲ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜିଉଦି ଏପିସିଏ ଆୟ୍‌ଲା, ତାର୍‌ ଜଃଲମ୍‌ ମାଟି ଆଲେକ୍‌ଜେଣ୍ଡ୍ରିଆ, ନିକ କଃଉଁ ହାର୍ତାର୍‌ ଆର୍‌ ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ଜାଣ୍‌ଲା ଲକ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଇ ମାନାୟ୍‌ ମାପ୍ରୁର୍‌ ବାଟ୍‌ ବିସୟେ ସିକ୍ୟା ହାୟ୍‌ରିଲା, ଆରେକ୍‌ ଆତ୍ମାୟ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ ଜିସୁର୍‌ କଃତା ନିକ କଃରି ସିକ୍ୟା ଦେତିରିଲା ମଃତର୍‌ ସେ ଅଃବ୍‌କା ଜହନାର୍‌ ବାପ୍ତିସମ୍‌ କଃତା ଜାଣିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ସେ ପାର୍ତ୍‌ନା ଗଃରେ ସାସ୍‌ ଦଃରି ସିକ୍ୟା ଦେଉଁକ୍‌ଦଃର୍ଲା । ମଃତର୍‌ ପ୍ରିସ୍କିଲା ଆର୍‌ ଆକିଲା ତାର୍‌ କଃତା ସୁଣି ତାକାର୍‌ ସଃଙ୍ଗ୍ ନୟ୍‌ ଅଃଦିକ୍‌ ନିକ କଃରି ଇସ୍ୱରାର୍‌ ବାଟ୍‌ କଃତା ସେମଃନ୍ ବୁଜାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ସେ ଆକାୟା ଦେସ୍‌କେ ଜଃଉଁକେ ମଃନ୍‌କଃଲାକ୍‌ ବାୟ୍‌ମଃନ୍ ତାକେ ବଃର୍ସା ଦଃୟ୍‌ ତାକେ ଆଗଳି ଦଃରୁକ୍‌ ଚେଲାମଃନ୍‌କେ ଚିଟି ଲେକ୍‌ଲାୟ୍‌ । ସେ ସେତି ହଚି ଜୁୟ୍‌ମଃନ୍‌ ସଃତ୍‌କଃରି ରିଲାୟ୍‌, ଇସ୍ୱର୍‌ ଦଃୟା ତଃୟ୍‌ ସେମଃନାର୍‌ କଃତେକ୍‌ ଉହ୍‌କାର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜିସୁ ଜେ କ୍ରିସ୍ଟ, ଇରି ଦଃର୍ମ୍‌ ସାସ୍ତର୍‌ ତଃୟ୍‌ହୁଣି ବୁଜାୟ୍‌ ସେ ଡାକେହାକେ ସଃକ୍ତିର୍‌ ସଃଙ୍ଗ୍ ଜିଉଦିମଃନାର୍‌ କଃତାକ୍‌ କାଟ୍‌ତିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପଲ୍‌ କରନ୍ତି ତଃୟ୍‌ ରେତାବଃଳ୍‌, ପାଉଲ୍‌ ଦେସାର୍‌ ହୁର୍ବ୍‌ ହଲିବାଟ୍‌ ଆସିକଃରି ଏପିସିଏ ଆସି ହଚ୍‌ଲା । ସେତି ସେ କଃତି ଗଟ୍‌ ଚେଲାକେ ବେଟ୍‌ ଅୟ୍‌ଲା, ");
INSERT INTO bdv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ସେ ସେମଃନ୍‌କେ ହଃଚାର୍ଲା, “ବିସ୍ୱାସ୍‌ କଃର୍ତା ବଃଳ୍‌ କାୟ୍‌ ତୁମିମଃନ୍ ପବିତ୍ର ଆତ୍ମା ହାୟ୍‌ରିଲାସ୍‌ ?” ସେମଃନ୍ ତାକେ କୟ୍‌ଲାୟ୍‌, ନାୟ୍‌, “ପବିତ୍ର ଆତ୍ମା ଜେ ଆଚେ ବଃଲି ସେରି ଅଃମି କଃବେ ହେଁ ନଃସୁଣୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ସେତାକ୍‌, ସେ ହଃଚାର୍ଲା ତଃବେ ତୁମିମଃନ୍ କାୟ୍‌ତି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଲାସ୍‌ ? ସେମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ଜହନ୍‌ ତଃୟ୍‌ହୁଣି ବାପ୍ତିସମ୍‌ ହାୟ୍‌ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ସେତାକ୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, “ଜହନ୍‌ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍‌କେ ମଃନ୍ ବାଦ୍‌ଲାଉତା ବାପ୍ତିସମେ ବାପ୍ତିସମ୍‌ ଦଃୟ୍‌, ତାର୍‌ହଃଚେ ଜେ ଆସେଦ୍‌ ତାର୍‌ ତଃୟ୍‌ ବଃଲେକ୍‌ ଜିସୁର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃରୁକେ ଅୟ୍‌ଦ୍‌ ବଃଲି ଲକ୍‌ମଃନ୍‌କେ କଃଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ସେମଃନ୍ ଇରି ସୁଣି ମାପ୍ରୁ ଜିସୁର୍‌ ନାଉଁଏ ବାପ୍ତିସମ୍‌ ନିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ଆର୍‌ ପାଉଲ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ଆତ୍‌ ସଃଙ୍ଗାୟ୍‌ଲାକ୍‌ ପବିତ୍ର ଆତ୍ମା ଆୟ୍‌ଲି, ଆରେକ୍‌ ସେମଃନ୍ ବିନ ବିନ୍ ବାସାୟ୍‌ କଃତା କଃଉଁକେ ଆର୍‌ ଇସ୍ୱରାର୍‌ କବୁର୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ସେମଃନ୍ ସଃବୁ ହାକାହାକି ବାର ଗଟ୍‌ ଅଃଣ୍ଡ୍ରାଲକ୍‌ ରିଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ହଃଚେ ସେ ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃର୍‌ ବିତ୍ରେ ଜାୟ୍‌ ତିନି ମାସ୍‌ ହଃତେକ୍‌ ସାସ୍‌ ଦଃରି ଇସ୍ୱରାର୍‌ ରାଇଜାର୍‌ କଃତା ପର୍ଚାର୍‌ କଃଲା ଆର୍‌ ବିସ୍ୱାସେ ବାଡୁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମଃତର୍‌ ଜଃଡେବଃଳ୍‌ କଃତେକ୍‌ ଲକ୍‌ ଅଃଟୁଆ ଆର୍‌ ଅମାନ୍ୟାର୍‌ ଅୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ସେ କଃତାକ୍‌ ଲିନ୍ଦା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ସଃଡେବଃଳ୍‌ ପାଉଲ୍‌ ସେମଃନ୍‌କେ ଚାଡି ଚେଲାମଃନ୍‌କେ ଅଃଲ୍‌ଗା କଃଲା ଆର୍‌ ହଃତି ଦିନ୍ ତୁରାନର୍‌ ଇସ୍କୁଲେ ଆଲ୍‌ଚଃନା କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଦୁୟ୍‌ ବଃର୍ସ୍‌ ହଃତେକ୍‌ ଅଃନ୍‌କାର୍‌ ଅୟ୍‌ଲି, ସେତାକ୍‌ ଆସିଆର୍‌ ଜିଉଦି ଆର୍‌ ଅଜିଉଦି ମାପ୍ରୁର୍‌ କଃତା ସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ଆରେକ୍‌ ଇସ୍ୱର୍‌ ପାଉଲ୍‌ ଆତେହୁଣି କାବା ଅଃଉତା ସକ୍ତିର୍‌ କାମ୍‌ କଃର୍ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଅଃନ୍‌କାର୍‌ କି ପାଉଲ୍‌ ବାଉର୍‌ତା ରୁମାଲ୍‌ ଆର୍‌ ବଃସ୍ତର୍‌ ରଗିମଃନାର୍‌ ତଃୟ୍‌ ଆଣ୍‌ଲେକ୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ ହୁଣି ରଗ୍ ଚାଡି ଜାତି ରିଲି, ଆର୍‌ ଦୁସ୍ଟ୍‌ ଆତ୍ମାମଃନ୍ ବାରୟ୍‌ ଜାତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ମଃତର୍‌ ବାର୍‌ବୁଲା ଜିଉଦି ବୁତ୍‌ ଚାଡାଉମଃନାର୍‌ ବିତ୍ରେ କଃତେକ୍‌ ଲକ୍‌ ହେଁ ଦୁସ୍ଟ୍‌ ଆତ୍ମା ଦଃରିରିଲା “ଲକ୍‌ମଃନାର୍‌ ଉହ୍ରେ ମାପ୍ରୁ ଜିସୁର୍‌ ନାଉଁ କୟ୍‌କଃରି ଜୁୟ୍‌ ଜିସୁକେ ପାଉଲ୍‌ ପର୍ଚାର୍‌ କଃରୁଲା ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ତାର୍‌ ନାଉଁଏ ଆଦେସ୍‌ ଦେଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ଆରେକ୍‌ ସ୍କେବା ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଜିଉଦି ବଃଡ୍ ଜାଜକାର୍‌ ସାତ୍‌ ଗଟ୍‌ ହୟ୍‌ସି ଅଃନ୍‌କଃରି କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ମଃତର୍‌ ଦୁସ୍ଟ୍‌ ଆତ୍ମା ସେମଃନ୍‌କେ କୟ୍‌ଲି, “ମୁୟ୍‌ଁ ଜିସୁକେ ଜାଣି, ଆର୍‌ ପାଉଲ୍‌କେ ଚିନି ଆଚି, ମଃତର୍‌ ତୁମିମଃନ୍ କେ ?” ");
INSERT INTO bdv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ସଃଡେବଃଳ୍‌ ଦୁସ୍ଟ୍‌ ଆତ୍ମା ଡଃସିରିଲା ଲକ୍‌ ସେମଃନାର୍‌ ଉହ୍ରେ ଡଃଗାୟ୍‌ ସେ ଦୁୟ୍‌ ଲକ୍‌କେ ଅଃନ୍‌କା ମାଡ୍ ମାର୍ଲା ଜେ, ସେମଃନ୍ ନଃଗ୍‌ଳା ଆର୍‌ କଃଣ୍ଡିଆକାବ୍ରା ଅୟ୍‌ ସେ ଗଃରେ ହୁଣି ବାରୟ୍‌ ହଃଳାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଇ କଃତା ଏପିସିଏ ଜିଉଦି ଆର୍‌ ଅଜିଉଦି ସଃବୁ ଲକ୍‌ ଜାଣ୍‌ଲାୟ୍‌, ଆର୍‌ ସେତାକ୍‌ ସଃବୁ ଲକ୍‌ ଡିର୍‌ଲାୟ୍‌ ଆର୍‌ ମାପ୍ରୁ ଜିସୁର୍‌ ନାଉଁକ୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ଆରେକ୍‌ ବିସ୍ୱାସିମଃନାର୍‌ ବିତ୍ରେ ଗାଦେକ୍‌ ଲକ୍‌ ଆସି ଅଃହ୍‌ଣାର୍‌ ଅଃହ୍‌ଣାର୍‌ ହାହ୍‌ କାମ୍‌ ମାନ୍‌ଲାୟ୍‌ ଆର୍‌ ଜାଣାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଆର୍‌ ଗୁଣିଆ କାମ୍‌ କଃର୍ତା ଗାଦେକ୍‌ ଲକ୍‌ ନିଜାର୍‌ ନିଜାର୍‌ ପୁସ୍ତକ୍‌ ଆଣି ରୁଣ୍ଡାୟ୍‌ ସଃବ୍‌କାର୍‌ ମୁଏଁ ହଡାୟ୍‌ ହଃକାୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ସେ ସଃବୁର୍‌ ମଲ୍‌ ଇସାବ୍‌ କଃରି ଦୁୟ୍‌କଳି ଦଃସ୍‌ ଅଃଜାର୍‌ ରୁହା ଟଃକା ବଃଲି କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଅଃନ୍‌କଃରି ମାପ୍ରୁର୍‌ କଃତା ସଃକ୍ତିଏ ବାଡୁକେ ଦଃର୍ଲି, ଆର୍‌ ଅଃଦିକ୍‌ ସଃକାତ୍‌ ଅଃଉଁକେ ଦଃର୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଇ ସଃବୁ କଃତା ସଃର୍ଲା ହଃଚେ ପାଉଲ୍‌ ମାକିଦନିଆ ଆର୍‌ ଆକାୟା ବାଟ୍‌ ଅୟ୍‌ ଜିରୁସାଲମ୍‌କେ ଜଃଉଁକେ ଆତ୍ମାୟ୍‌ ମଃନ୍‌ କଃରି କୟ୍‌ଲା, “ସେତି ଗଃଲା ହଃଚେ ମକେ ବାୟ୍‌ଦ୍‌ରେ ରମ୍‌କେ ହେଁ ଜଃଉଁକେ ଅୟ୍‌ଦ୍‌” ");
INSERT INTO bdv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଆରେକ୍‌ ଜୁୟ୍‌ମଃନ୍‌ ତାର୍‌ ଜଃତୁନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ ସେମଃନାର୍‌ ବିତ୍ରେ ତିମତି ଆର୍‌ ଏରାସ୍ଟ, ଇ ଦୁୟ୍‌ ଲକ୍‌କେ ମାକିଦନିଆକେ ହଃଟାୟ୍‌ କଃରି ସେ ଅଃଳକ୍‌ ଦିନ୍‌ ହଃତେକ୍‌ ଆସିଆ ତଃୟ୍‌ ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ସଃଡେବଃଳ୍‌ ମାପ୍ରୁ ଦଃକାୟ୍‌ ରିଲା ବାଟାର୍‌ ଗିନେ ଏପିସି ଗଃଳେ ବଃଡେ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଦିମାତ୍ରିୟ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ରୁହା ମୁର୍ତି ହାଜୁ ଆର୍ତେମିର୍‌ ରୁହା ମନ୍ଦିର୍‌ ବାନ୍ଦ୍‌ତି ରିଲା ଆର୍‌ ମେସ୍ତୁରି ମଃନ୍‌କାର୍‌ ବୁତେକ୍‌ ଲାବ୍‌ କଃରାଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ସେ ସେମଃନ୍‌କେ ଆର୍‌ ସେ ବେବାର୍‌କଃରୁ ମେସ୍ତୁରିମଃନ୍‌କେ କୁଦି କୟ୍‌ଲା, “ଆଗ୍ୟାମଃନ୍‌ ଇ ବେବାରାର୍‌ ଗିନେ ଅଃମି ଲାବ୍‌ ହାଉଁଲୁ, ଇରି ତୁମିମଃନ୍ ସଃବୁ ଜାଣିଆଚାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଆର୍‌ ଆତେ ହାଜ୍‌ଲା ଦେବ୍‌ତାମଃନ୍ ଇସ୍ୱର୍‌ ନାୟ୍‌ ବଃଲି କୟ୍‌ ପାଉଲ୍‌ ଅଃବ୍‌କା ଏପିସିଏ ନାୟ୍‌ ମଃତର୍‌ ସଃବୁ ଆସିଆର୍‌ ଗାଦେକ୍‌ ଲକ୍‌ମଃନ୍‌କେ ବୁଲ୍‌କାଉଁଲା, ଇରି ତୁମିମଃନ୍ ଦଃକୁଲାସ୍‌ ଆର୍‌ ସୁଣୁଲାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଇତାକ୍‌ ଜେ, ଅଃମାର୍‌ ବେବାରେ ବାଦା ଅଃଉତାର୍‌ ଦଃକା ଜଃଉଁଲି, ସେରି ନାୟ୍‌ ମଃତର୍‌ ଜୁୟ୍‌ ମହାଦେବି ଆର୍ତେମିକ୍‌ ସଃବୁ ଆସିଆ ଆର୍‌ ଜଃଗତ୍‌ ସଃରା ହୁଜା କଃରୁଲାୟ୍‌ ସେ ମନ୍ଦିରାର୍‌ ହେଁ ଜଃଜ୍‌ମାନାର୍‌ ଲିନ୍ଦା ଅଃଉଁଲି ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଇ କଃତା ସୁଣି ସେମଃନ୍ ବେସି ରିସା ଅୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, “ଏପିସି ମଃନାର୍‌ ଆର୍ତେମି ବଃଡ୍‌ଦେବିର୍‌ ଜୟ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଇତାକ୍‌ ସଃବୁ ଗଃଳ୍‌ ଜାକ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଅୟ୍‌ଲି, ଆର୍‌ ସେମଃନ୍ ପାଉଲାର୍‌ ସଃଙ୍ଗାର୍‌ ମାକିଦନିଆର୍‌ ଗାୟ ଆର୍‌ ଆରିସ୍ତାର୍କକେ ଦଃରି ଜୁଜ୍‌ବଃଟାକ୍‌ ଦଃବୁଳ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ଇତାକ୍‌ ପାଉଲ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଜଃଉଁକେ ମଃନ୍‌କଃଲା, ମଃତର୍‌ ଚେଲାମଃନ୍ ତାକେ ଜଃଉଁକେ ନଃଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଆର୍‌ ଆସିଆର୍‌ ବଃଡ୍ ସଃର୍କାରି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ହେଁ କଃତି ଲକ୍‌ ତାକାର୍‌ ନିଜାର୍‌ ଲକ୍‌ ରିଲାକ୍‌ ଲକ୍‌ ହଃଟାୟ୍‌ ଜୁଜ୍‌ବଃଟାୟ୍‌ ନଃଜ୍‌ଉଁକେ ପାଉଲ୍‌କେ ଗଃଉଆରି କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ସଃଡେବଃଳ୍‌ କେ କେ ଇ କଃତା, କେ କେ ସେ କଃତା କୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅଃଉତି ରିଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ବେରାଣ୍ ମେଣ୍ଡା ଜଃବର୍‌ ଉରାଟୁ ଅୟ୍‌ଲି । ଆର୍‌ ସେମଃନ୍ ଜେ କାୟ୍‌ତାକ୍‌ ରୁଣ୍ଡି ଆଚ୍‌ତି ସେରି ଅଃନେକ୍‌ ଲକ୍‌ ଜାଣି ନଃରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ଆର୍‌ ଜିଉଦିମଃନ୍ ଆଲେକ୍‌ଜେଣ୍ଡାର୍‌କେ ଆଗ୍‌ତୁ ବାର୍‌କଃରି ଆଣୁକେ ଲକ୍‌ମଃନ୍‌କେ ତାକେ ଜୁଜାୟ୍‌ଲାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେତି ଆଲେକ୍‌ଜେଣ୍ଡାର୍‌ ଆତେ ସଃଗ୍ୟା କଃରି ଲକ୍‌ମଃନାର୍‌ ଚଃମେ ବିସ୍ୱାସିମଃନାର୍‌ ବାଟ୍ୟା ଅୟ୍‌ ବୁଜାଉଁକେ ମଃନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମଃତର୍‌ ସେ ଗଟେକ୍‌ ଜିଉଦି ବଃଲି ସେମଃନ୍ ଜାଣ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ସଃବୁ ଲକ୍‌ ଦୁୟ୍‌ ଗଃଟା ହଃତେକ୍‌ ଉରାଟୁ କଃରୁକେ ଦଃର୍ଲାୟ୍‌, “ଏପିସିମଃନାର୍‌ ଆର୍ତେମି ବଃଡ୍‌ଦେବିର୍‌ ଜଃୟ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ତାର୍‌ ହଃଚେ ଗଃଳାର୍‌ ବେବର୍ତା ଲକ୍‌ମଃନ୍‌କେ ଚିମ୍‌ରା କଃରାୟ୍‌ କୟ୍‌ଲା ଏ ଏପିସିର୍‌ ଲକ୍‌ମଃନ୍ ଏପିସି ଗଃଳ୍‌ ବଃଡ୍‌ଦେବି ଆର୍ତେମି ଆର୍‌ ଅଃଗାସେ ହୁଣି ଅଦୁର୍ଲା ମୁର୍ତିର୍‌ ମନ୍ଦିର୍‌ ଦଃକାସୁଣା କଃରୁ ଇରି ସଃବୁଲକେ ଜାଣା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ତଃବେ ଇ ସଃବୁ କଃତା କେ ନାୟ୍‌ ବଃଲେଦ୍‌, ଇତାକ୍‌ ତୁମିମଃନ୍ ସୁସ୍ତା ଅଃଉତାର୍‌ ଆର୍‌ କାୟ୍‌ରି ନଃବାବି କାୟ୍‌ କାମ୍‌ କଃର୍ତାର୍‌ ନିକ ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଜୁୟ୍‌ ଲକ୍‌ମଃନ୍‌କେ ତୁମି ଦଃରି ଆଣି ଆଚାସ୍‌ ଇ ମଃନ୍ ତ ମନ୍ଦିରାର୍‌ କାୟ୍‌ରି ଚରି ନଃକେର୍‌ତି କି ଅଃମାର୍‌ ଦେବିର୍‌ ଲିନ୍ଦା ନଃକେର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଇତାକ୍‌ ଜଦି କାର୍‌ ବିରଦେ ଦିମାତ୍ରିୟ୍‌ର ଆର୍‌ ତାର୍‌ ସଃଙ୍ଗୁଆଳି ମେସ୍ତୁରିମଃନାର୍‌ କାୟ୍‌ କଃତା ଆଚେ ତଃବେ ବିଚାର୍‌ କଃର୍ତା ବେରାଣ୍ ମଃଣ୍ଡା ମେଲା ଆଚେ, ଆର୍‌ ସାସନ୍‌ କଃରୁମଃନ୍‌ ଆଚ୍‌ତି; ସେମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିରଦେ ଦଃସ୍‌ ଆଣତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ମଃତର୍‌ ଜଦି ତୁମିମଃନାର୍‌ ଆର୍‌ କାୟ୍‌ରି କଃଉତାର୍‌ ଆଚେ ତଃବେ କୁଟୁମ୍‌ ବେରାଣେ ତାର୍‌ ବିଦି ହଃର୍କାରେ ବୁଜାମଃଣା ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସଃତ୍‌କଃରି ଆଜିର୍‌ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଗିନେ ଅଃମାର୍‌ ବିତ୍ରେ କାୟ୍‌ କଃତା ଅଃଉଁକେ ଆଚେ ଅଃମିମଃନ୍‌ ଇ ଗଣ୍ଡ୍‌ଗଳାର୍‌ କାୟ୍‌ କଃତା କଃଉ ନଃହାରୁ । ");
INSERT INTO bdv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଇରି କୟ୍‌ ସେ କୁଟୁମାର୍‌ ସଃବ୍‌କେ ମେଲାଣି ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ସେ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ସଃର୍ଲା ହଃଚେ, ପାଉଲ୍‌ ଚେଲାମଃନ୍‌କେ କୁଦି ସେମଃନ୍‌କେ ବଃର୍‌ସା ଦିଲା ଆର୍‌ ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମେଲାଣି ମାଗି ମାକିଦନିଆକେ ଜଃଉଁକେ ବାରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ସେ ସଃବୁ ହଲିବାଟ୍‌ ଗଃଲାବଃଳ୍‌ ସେ ଚେଲାମଃନ୍‌କେ ବଃର୍‌ସା ଦିଲା ହଃଚେ ଆକାୟାକେ ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ସେତି ତିନି ମାସ୍‌ ରଃୟ୍‌, ଜଃଡେବଃଳ୍‌ ଜାଜେ ଚଃଗି ସୁରିଆକ୍‌ ଜଃଉଁକେ ମଃନ୍ କଃଲା, ସଃଡେବଃଳ୍‌ ଜିଉଦିମଃନ୍ ତାର୍‌ ବିରଦେ କୁଟ୍‌ କଃଲାକ୍‌ ସେ ମାକିଦନିଆ ବାଟ୍‌ ଅୟ୍‌ ବାଉଳୁକ୍‌ ମଃନ୍‌କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ଆର୍‌ ପୁରର୍‌ ହୟ୍‌ସି ବେରିଆର୍‌ ସପାତ୍ର, ତେସଲନିକି ମଃନାର୍‌ ବିତ୍ରେ ଆରିସ୍ତାର୍କ୍ ଆର୍‌ ସେକୁନ୍ଦ୍, ଦର୍ବିର୍‌ ଗାୟ, ତିମତି ଆର୍‌ ଆସିଆର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ତୁକିକ୍‌ ଆର୍‌ ତ୍ରପିମ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଇମଃନ୍‌ ସଃବୁ ଆଗ୍‌ତୁ ଜାୟ୍‌ ତ୍ରୟା ତଃୟ୍‌ ଅଃମିମଃନ୍‌କେ ଜାଗ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ଆର୍‌ କମିର୍‌ ନୟ୍‌ଲା ରୁଟିର୍‌ ହଃର୍ବ୍‌ ହଃଚେ ଅଃମିମଃନ୍‌ ଜାଜେ ଚଃଗି ପିଲିପି ଗଃଳେ ହୁଣି ଗଃଲୁ ଆରେକ୍‌ ହାଁଚ୍‌ଦିନ୍‌ ଅୟ୍‌ଲି ତ୍ରୟା ତଃୟ୍‌ ସେମଃନାର୍‌ ଟାଣେ ଆୟ୍‌ଲୁ; ସେତି ଅଃମିମଃନ୍‌ ସାତ୍‌ ଦିନ୍ ରିଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ସାତ୍‌ ରୟ୍‌ବାର୍‌ ଦିନ୍ ସଃଞ୍ଜ୍‌ବେଳାୟ୍‌ ଜଃଡେବଃଳ୍‌ ଅଃମିମଃନ୍‌ କାଉଁକ୍‌ ଏକ୍‌ ଅୟ୍‌ରିଲୁ, ସଃଡେବଃଳ୍‌ ପାଉଲ୍‌ ଆର୍‌କ ଦିନ୍ ଜଃଉଁକେ ମଃନ୍‌କଃର୍ତିରିଲା, ମଃଜା ରାତି ହଃତେକ୍‌ ପର୍ଚାର୍‌ କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଜୁୟ୍‌ ଉହ୍ରାର୍‌ ବଃକ୍ରାୟ୍‌ ଅଃମିମଃନ୍‌ ରୁଣ୍ଡିରିଲୁ ଗାଦାଗଟ୍‌ କୁପି ଲାଗିରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଆର୍‌ ଇଉତୁକ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଦଃଙ୍ଗ୍‌ଳା ଜର୍‌କା ଉହ୍ରେ ବଃସିରିଲା, ତାକେ ବଃଡେ ନିଦ୍‌ ଅଃଉତି ରିଲି, ପାଉଲ୍‌ ପର୍ଚାର୍‌ ଡେଙ୍ଗ୍ କଃଲାକ୍‌ ସେ ନିଦାର୍‌ ଗିନେ ତିନିତାଲାୟ୍‌ ହୁଣି ତଃଳେ ଅଦୁର୍ଲା ଆର୍‌ ତାକେ ଉଟାୟ୍‌ଲାକ୍‌, ସେ ମଃଲା ବଃଲି ଜାଣାହଃଳ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ସେତାକ୍‌ ପାଉଲ୍‌ ତଃଳେ ଉତ୍ରି ତାକେ ହଃଟଳିକଃରି ତାକେ ଚୁମିକଃରି କୟ୍‌ଲା, “ଚିନ୍ତାକଃରାନାୟ୍‌” କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ “ସେ ଜିବନ୍ ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ହଃଚେ ସେ ଉହ୍ରେ ଜାୟ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରୁଟି ବାଙ୍ଗି କାୟ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ସଃକାଳ୍‌ ଅଃଉତା ହଃତେକ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ବୁତେକ୍‌ କଃତାବାର୍ତା କଃରି ପାଉଲ୍‌ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଆର୍‌ ସେମଃନ୍ ସେ ହିଲାକ୍‌ ଜିବନ୍ ରିଲାକ୍‌ ତାକାର୍‌ ସଃଙ୍ଗ୍ ଗଃରେ ନିଲାୟ୍‌ ଆର୍‌ ସଃର୍ଦା ହାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ମଃତର୍‌ ଅଃମିମଃନ୍‌ ଆଗ୍‌ତୁ ଡଙ୍ଗାୟ୍‌ ଚଃଗି ଆସସ୍‌କେ ଜଃଉଁକେ ଦଃର୍ଲୁ, ସେତି ହୁଣି ଅଃମିମଃନ୍‌ ପାଉଲ୍‌କେ ନେଉଁକ୍‌ ମଃନ୍‌ କଃରି ରିଲୁ କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ନିଜେ ଇଣ୍ଡି ଇଣ୍ଡି ଜଃଉଁକେ ତିର୍‌ କଃରିରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ସଃଡେବଃଳ୍‌ ସେ ଆମିମଃନ୍‌କେ ଆସସ୍‌ ତଃୟ୍‌ ବେଟ୍‌ ଅୟ୍‌ଲା, ଅଃମିମଃନ୍‌ ତାକେ ଜାଜେ ମିତୁଲିନିକ୍‌ ଗଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଆର୍‌ ସେତି ହୁଣି ଜାଜ୍‌ ସଃଙ୍ଗ୍ ଅଃମିମଃନ୍‌ ଆର୍‌କ ଦିନ୍ କିଅସ୍‌ ଚଃମେ ଆୟ୍‌ଲୁ, ତାର୍‌ ଆର୍‌କ ଦିନ୍ ସାମ ତଃୟ୍‌ ଜାଜ୍‌ ତେବାୟ୍‌ଲୁ ଆର୍‌ ତାର୍‌ ଆର୍‌କ ଦିନ୍ ମିଲିତ ତଃୟ୍‌ ହଚ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଆସିଆ ତଃୟ୍‌ ପାଉଲ୍‌କେ ରେଉଁକ୍‌ ନଃହେଳେ ଇତାକ୍‌ ସେ ଏପିସିଏ ଚାଡି ଜଃଉଁକେ ମଃନେ ତିର୍‌ କଃରିରିଲା, ସେତାକ୍‌ ସେ ପେଣ୍ଟିକସ୍ଟ୍‌ ଦିନ୍ ଜିରୁସାଲମେ ହଚୁକ୍‌ ମଃନ୍ କଃର୍ତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ମିଲିତ ତଃୟ୍‌ହୁଣି ପାଉଲ ଏପିସିଏ ଲକ୍‌ ହଃଟାୟ୍‌ ମଣ୍ଡ୍‌ଳିର୍‌ ପାରାଚିନ୍‌ମଃନ୍‌କେ ଅଃହ୍‌ଣାର୍‌ ଚଃମେ କୁଦାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ସେମଃନ୍ ତାର୍‌ ଚଃମେ ହଚ୍‌ଲାକ୍‌, ସେ ସେମଃନ୍‌କେ କୟ୍‌ଲା, “ଆସିଆ ଆୟ୍‌ଲା ହଃର୍ତୁ ଦିନ୍ ହୁଣି ମୁୟ୍‌ଁ ସଃବୁବଃଳ୍‌ ତୁମାର୍‌ ବିତ୍ରେ କଃନ୍‌କଃରି ଦିନ୍ ବିତାୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ମଃନେ ମଃନେ ଆସୁ ଗଃସ୍ରାୟ୍‌ ଜିଉଦିମଃନାର୍‌ ହେଟ୍‌କୁଟାର୍‌ ଗିନେ ମକ୍‌ ଜଃନ୍‌କାର୍‌ କଃଟ୍‌ହାଳ୍‌ ଗଃଟ୍‌ତି ରିଲି ସେ ସଃବୁ ବିତ୍ରେ କଃନ୍‌କଃରି ମାପ୍ରୁର୍‌ ସେବାକାମ୍‌ କଃର୍ତି ରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","କଃନ୍‌କଃରି କାୟ୍‌ ନିକ କଃତା ତୁମାର୍‌ ତାଣେ ଜାଣାଉଁକେ ଆର୍‌ ତୁମିମଃନ୍‌କେ, ଉହ୍‌କାର୍‌ ଅୟ୍‌ଦ୍‌ ସେରି ଗଃରେଗଃରେ କଃଉଁକେ ଲୁକାୟ୍‌ ନଃରିଲେ ");
INSERT INTO bdv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ସେମଃନ୍ ହାହେହୁଣି ଇସ୍ୱରାର୍‌ ହାକ୍‌ ମଃନ୍ ବାଦ୍‌ଲାୟ୍‌ ଅଃମିମଃନାର୍‌ ଜିସୁକେ ସଃତ୍‌ କଃରୁକେ ଜିଉଦି ଆର୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନ୍‌କେ ହେଁ ଅଃକାହର୍‌ ସାକି ଦେତିରିଲେ । ସେରି ତୁମି ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ଅଃବେ ଦଃକା ମୁୟ୍‌ଁ ଆତ୍ମାର୍‌ ବଃଳେ ଜିରୁସାଲମ୍‌କେ ଜଃଉଁଲେ, ସେତି ମକ୍‌ କାୟ୍‌ କାୟ୍‌ରି ଅୟ୍‌ଦ୍‌ ସେରି ମୁୟ୍‌ଁ ନଃଜାଣି । ମଃତର୍‌ ଅଃତେକ୍‌ ଜାଣି, ");
INSERT INTO bdv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ମର୍‌ ଗିନେ ବାନ୍ଦୁଣ୍‌ ଆର୍‌ କଃସ୍ଟ୍‌ ଆଚେ, ଇରି ପବିତ୍ର ଆତ୍ମା ମକ୍‌ ସଃବୁ ଗଃଳେ ସାକି ଦେଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମଃତର୍‌ ଜଃନ୍‌କଃରି ମର୍‌ ଟିକ୍‌ ଅୟ୍‌ଲା ବାଟେ ସଃରାସଃରି ହତେକ୍‌ ଦଃବ୍‌ଳୁକ୍‌ ହାରିନ୍ଦ୍ ଆର୍‌ ଇସ୍ୱରାର୍‌ ଦଃୟାର୍‌ ତଃୟ୍‌ ନିକ କବୁର୍‌ ଗିନେ ସାକି ଅଃଉଁକେ ଜୁୟ୍‌ ପର୍ଚାର୍‌ କଃର୍ତା କାମ୍‌ ମାପ୍ରୁ ଜିସୁ ତଃୟ୍‌ ହୁଣି ହାୟ୍‌ ଆଚି, ସେରି ହୁର୍ନ୍‌ କଃରୁକେ ହାରି ଇତାକ୍‌ ମୁୟ୍‌ଁ ଅଃହ୍‌ଣାର୍‌ ହଃର୍‌ ଜିବନ୍‌କେ ଲାଡ୍‌ ନଃକେରି ସେରି ସାନ୍ ବଃଲି ବାବୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ଆରେକ୍‌ ଅଃବେ ଦଃକା ତୁମିମଃନାର୍‌ ବିତ୍ରେ ଇସ୍ୱରାର୍‌ ରାଇଜ୍‌ ପର୍ଚାର୍‌ କଃରି ବୁଲ୍‌ଲେ ଅଃନ୍‌କାର୍‌ ଜେ ତୁମିମଃନ୍ କଃବେ ଆର୍‌ ମକେ ଦଃକୁ ନଃହାରାସ୍‌ ବଃଲି ମୁୟ୍‌ଁ ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ସେତାକ୍‌ ମୁୟ୍‌ଁ ସଃବ୍‌କାର୍‌ ବଃନି ତଃୟ୍‌ହୁଣି ମର୍‌ ଦାୟ୍‌ତ୍‌ ନାୟ୍‌ ଇରି ମୁୟ୍‌ଁ ଆଜି ତୁମିମଃନ୍‌କେ କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଇସ୍ୱରାର୍‌ ସଃବୁ ଇଚା ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ଜାଣାଉଁକେ ଲାଜ୍‌ ଅୟ୍‌ନଃରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ତୁମିମଃନ୍ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବିସୟେ ଆର୍‌ ଜୁୟ୍‌ ମଣ୍ଡ୍‌ଳି ଇସ୍ୱର୍‌ ଅଃହ୍‌ଣାର୍‌ ନିଜାର୍‌ ବଃନି ଦଃୟ୍‌ ଗେନି ଆଚେ ତାର୍‌ ସେ ମଣ୍ଡ୍‌ଳିକେ ହାଳି ପବିତ୍ର ଆତ୍ମା ଜୁୟ୍‌ ସଃବୁ ମଃନ୍ଦା ବିତ୍ରେ ତୁମିମଃନ୍‌କେ ମୁଳିକା ହର୍‌ ବାଚି ଆଚେ, ସେମଃନାର୍‌ ବିସୟେ ଜଃଗ୍ରତ୍‌ ଅୟ୍‌ରିଆ । ");
INSERT INTO bdv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ମର୍‌ ଗଃଲା ହଃଚେ ବାଗ୍‌ମଃନ୍ ତୁମାର୍‌ ବିତ୍ରେ ହୁରି ମଃନ୍ଦାକେ ଦଃୟା ନଃକେରି ଜଃତ୍‌କଃତ୍‌ କଃର୍ତି । ");
INSERT INTO bdv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଆରେକ୍‌ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ହେଁ ଲକ୍‌ମଃନ୍ ଚେଲାମଃନ୍‌କେ ଅଃହ୍‌ଣାର୍‌ ହଃଚେ ଜିକି ନେଉଁକ୍‌ ଉଲ୍‌ଟା କଃତାମଃନ୍‌ କଃଉତି, ଇରି ମୁୟ୍‌ଁ ଜାଣି । ");
INSERT INTO bdv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ତଃବେ ତୁମିମଃନ୍ ଜାଗି ରିଆ ଆର୍‌ ମୁୟ୍‌ଁ ତିନିବଃର୍ସ୍‌ ହଃତେକ୍‌ ଦିନ୍ ରାତି ଆସୁ ଗଃସ୍ରାୟ୍‌ ହଃତି ଲକ୍‌କେ ଚେତ୍‌ନା ଦେଉଁକେ ବଃନ୍ଦ୍‌ କଃରିନଃରିଲେ, ଇରି ଏତୁ କଃରା ।” ");
INSERT INTO bdv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ଅଃବେ ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ଇସ୍ୱରାର୍‌ ଟାଣେ ଆର୍‌ ତାର୍‌ ଦଃୟାର୍‌ କଃତା ତଃୟ୍‌ ଦେଉଁଲେ ସେ ତୁମିମଃନ୍ ସଃବ୍‌କେ ଦଃର୍ମି ଆର୍‌ ନିର୍ମୁଳ୍‌ ଲକ୍‌ ଅଃଉଁକେ କଃରୁ ହାରେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ମୁୟ୍‌ଁ କାର୍‌ ରୁହା କି ସନା କି ବଃସ୍ତର୍‌ ଲଃବ୍‌ କଃରି ନଃରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ମର୍‌ ଇ ଜଳେକ୍‌ ଆତେ ମର୍‌ ଆର୍‌ ମର୍‌ ସଃଙ୍ଗୁଆଳି ମଃନାର୍‌ ଅକେଟ୍‌ ହୁରୁଣ୍ କଃରୁକେ କାମ୍‌ କଃରି ଆସୁଲେ, ଇତି ତୁମିମଃନ୍ ନିଜେନିଜେ ଜାଣାସ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ଅଃନ୍‌କଃରି ହାୟ୍‌ଟି କଃରି ନିଗାଳ୍‌ ଲକ୍‌ମଃନ୍‌କେ ଉହ୍‌କାର୍‌ କଃର୍ତାର୍‌ ଆରେକ୍‌ ହାଉତା ବାଦୁଲେ ଦାନ୍‌କଃର୍ତାର୍‌ ନିକ ବଃଲିନ୍ଦ୍‌, ମାପ୍ରୁ ଜିସୁ ନିଜେ ଇ ଜୁୟ୍‌ କଃତା କୟ୍‌ଆଚେ ସେରି ଏତାଉତାର୍‌ ତୁମିମଃନାର୍‌ କଃତା । ଇସାବ୍‌ କଃତା ମୁୟ୍‌ଁ ତୁମିମଃନ୍‌କେ ମର୍‌ କାମ୍‌ ତଃୟ୍‌ ଦଃକାୟ୍‌ ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଇ ସଃବୁ କଃତା କୟ୍‌ଲା ହଃଚେ, ମାଣ୍ଡିକୁଟା ଦଃୟ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ପାର୍ତ୍‌ନା କଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ଆର୍‌ ସେମଃନ୍ ସଃବୁଲକ୍‌ କାନ୍ଦିକାନ୍ଦି ପାଉଲ୍‌କେ ହଃଟଳି ଚୁମୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ଆରେକ୍‌ ସେମଃନ୍ ତାର୍‌ ମୁଁ ଆର୍‌ ଦଃକୁ ନଃହାର୍‌ତି ବଃଲି ସେ ଜୁୟ୍‌ କଃତା କୟ୍‌ରିଲା ସେତାର୍‌ଗିନେ ମଃନଦୁକ୍‌ କଃଲା ହଃଚେ ସେମଃନ୍ ତାକେ ଡଙ୍ଗା ହଃତେକ୍‌ ହଚାଉଁକ୍‌ ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମେଲାଣି ହାୟ୍‌ ଅଃମିମଃନ୍‌ ଗଟେକ୍‌ ଜାଜେ ଚଃଗି ସଃଳ୍‌କ୍‌ ବାଟେ କସ୍‌କେ ଆୟ୍‌ଲୁ, ଆର୍‌କ ଦିନ୍ ରଦାକେ, ଆରେକ୍‌ ସେତି ହୁଣି ପାତାରାକେ ଆୟ୍‌ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ସେତି ପଇନିକିଆ ଜାତା ଗଟେକ୍‌ ଡଙ୍ଗା ମିଳାୟ୍‌ ସେତି ଚଃଗି ଗଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ହଃଚେ ସାଇପ୍ରସ୍‌ ଦଃକାଗଃଲାକେ ସେରି ଡେବ୍ରି ବାଟ୍‌ ଚାଡି ଅଃମିମଃନ୍‌ ସିରିଆକେ ଜାୟ୍‌କଃରି ସର୍‌ ତଃୟ୍‌ ହଚ୍‌ଲୁ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ସେତି ଡଙ୍ଗାୟ୍‌ ହୁଣି ଆସ୍ତିବାଡି ଉତ୍ରାଉତାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ସେତି ବିସ୍ୱାସିମଃନ୍‌କେ ଲଳି ସେମଃନ୍‌କେ ବେଟ୍‌ହାୟ୍‌ ସେତି ସାତ୍‌ଦିନ୍ ରିଲୁ, ଆରେକ୍‌ ପାଉଲ୍‌ ଜଃନ୍‌କଃରି ଜିରୁସାଲମେ ନଃହଚେ, ଇତାର୍‌ ଗିନେ ସେମଃନ୍ ଆତ୍ମା ତଃୟ୍‌ ତାକେ କୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ସାତ୍‌ ଦିନ୍ ରିଲା ହଃଚେ ଅଃମିମଃନ୍‌ ବାଉଳି ବାଟ୍‌ଦଃର୍ଲୁ, ଆରେକ୍‌ ସେମଃନ୍ ସଃବୁ ମାୟ୍‌ଜି ଆର୍‌ ହିଲାମଃନାର୍‌ ସଃଙ୍ଗ୍ ଗଃଳାର୍‌ ହଃଦା ହଃତେକ୍‌ ଅଃମିମଃନ୍‌କ୍‌ ଚାଡୁକ୍‌ ଆୟ୍‌ଲାୟ୍‌, ଆର୍‌ ସଃମ୍‌ନ୍ଦ୍ କଃଣ୍ଡାୟ୍‌ ମାଣ୍ଡିକୁଟା ଟେସି ଅଃମିମଃନ୍‌ ପାର୍ତ୍‌ନା କଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ଆର୍‌ ଅଃମାର୍‌ ବିତ୍ରେ ମେଲାଣି ଦିଲୁ, ହଃଚେ ଅଃମିମଃନ୍‌ ଡଙ୍ଗାୟ୍‌ ଚଃଗ୍‌ଲୁ ଆର୍‌ ସେମଃନ୍ ଗଃର୍‌କେ ବାଉଳି ଗଃଳାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ଅଃମିମଃନ୍‌ ସର୍‌ ଗଃଳେ ହୁଣି ଜାଜେ ପତଲ୍‌ମାୟ୍‌ ତଃୟ୍‌ ହଚ୍‌ଲୁ, ଆର୍‌ ବାୟ୍‌ମଃନ୍‌କେ ଜୁଆର୍‌ କଃଲୁ ଆର୍‌ ଗଟେକ୍‌ ଦିନ୍ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ରିଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ଆର୍‌କ ଦିନ୍ ଅଃମିମଃନ୍‌ କାଇସରିଆକେ ଗଃଲୁ ଆର୍‌ ସାତ୍‌ ଲକାର୍‌ ବିତ୍ରେ ଜିରୁସାଲମେ ରିଲାନିକ କବୁର୍‌ ପର୍ଚାର୍‌ କଃର୍ତା ପିଲିପ୍ ଗଃରେ ଜାୟ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ ରିଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ତାର୍‌ ଚାରିଗଟ୍‌ ଦଃଙ୍ଗ୍‌ଳି ଟକି ରିଲାୟ୍‌, ସେମଃନ୍ ଇସ୍ୱରାର୍‌ ବାବ୍‌ବାଣି କଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ସେଟାଣେ ଅଃମିମଃନ୍‌ ବୁତେକ୍‌ ଦିନ୍ ରିଲା ହଃଚେ ଆଗାବ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ବାବ୍‌ବାଦି ଜିଉଦା ରାଜି ହୁଣି ଆୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ସେ ଅଃମାର୍‌ ଚଃମେ ଆସି ପାଉଲାର୍‌ ଅଃଟା ବାନ୍ଦୁଣ୍‌ ନେୟ୍‌କଃରି ଅଃହ୍‌ଣାର୍‌ ଆତ୍‌ଗଡ୍‌ ବାନ୍ଦି କଃରି କୟ୍‌ଲା, “ପବିତ୍ର ଆତ୍ମା ମକ୍‌ ଇରି କଃଉଁଲି, ‘ଇ ଅଃଟାବିଳା ବାନ୍ଦ୍‌ଲା ଲକ୍‌କେ’ ଜିରୁସାଲମାର୍‌ ଲକ୍‌ ଜିଉଦିମଃନ୍ ଅଃନ୍‌କଃରି ବାନ୍ଦି ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ଆତେ ସଃହ୍ରିଦେତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଇ ସଃବୁ କଃତା ସୁଣି ଜିରୁସାଲମ୍‌କେ ନଃଜ୍‌ଉଁକେ ଅଃମି ଆର୍‌ ସେଟାଣାର୍‌ ଲକ୍‌ମଃନ୍ ତାକେ ଗଃଉଆରି କଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ସେତାକ୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, “ତୁମିମଃନ୍ କାୟ୍‌ କଃରୁଲାସ୍‌ କାନ୍ଦିକଃରି ମର୍‌ ଗଃର୍ବ୍‌ ହଡାୟ୍‌ଲା ହର୍‌ କଃରୁଲାସ୍‌ ? କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ମାପ୍ରୁ ଜିସୁର୍‌ ନାଉଁ ଗିନେ ଜିରୁସାଲମେ ବାନ୍ଦାୟ୍‌ ଅଃଉଁକେ ରାଜି, ସଃତେକ୍‌ ନାୟ୍‌, ମଃତର୍‌ ମଃରୁକ୍‌ ହେଁ ରାଜି ଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ସେ ନଃମାନ୍‌ଲାକ୍‌ ଅଃମିମଃନ୍‌ ତୁନ୍‌ହଃଳ୍‌ଲୁ ଆର୍‌ କୟ୍‌ଲୁ, “ମାପ୍ରୁର୍‌ ଇଚା ହୁର୍ନ୍‌ ଅଃଉଅ ।” ");
INSERT INTO bdv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଅଃଳକ୍‌ ଦିନ୍ ସେତି ରିଲା ହଃଚେ ଅଃମିମଃନ୍‌ ଆସ୍ତିବାଡି ଦଃରି ଜିରୁସାଲମ୍‌କେ ଗଃଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ଆରେକ୍‌ କାଇସରିଆ ହୁଣି କଃତିଗଟ୍‌ ଚେଲା ହେଁ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଆୟ୍‌ଲାୟ୍‌, ସେମଃନ୍ ସାଇପ୍ରସ୍‌ ମାନାସନ୍ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ହଃର୍ତୁର୍‌ ଚେଲାକେ ସଃଙ୍ଗେ ଆଣ୍‌ଲା, ତାର୍‌ ଗଃରେ ଅଃମିମଃନାର୍‌ ରେଉଁକ୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଅଃମିମଃନ୍‌ ଜିରୁସାଲମେ ହଚ୍‌ଲାକ୍‌ ବିସ୍ୱାସି ବାୟ୍‌ମଃନ୍ ଅଃମିମଃନ୍‌କ୍‌ ସଃର୍ଦାୟ୍‌ କୁଦ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ଆର୍‌କ ଦିନ୍ ପାଉଲ୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଜାକୁବର୍‌ ଗଃରେ ଗଃଲା; ଆର୍‌ ସଃବୁ ପାରାଚିନ୍‌ମଃନ୍ ସେତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲ୍‌ ସେମଃନ୍‌କେ ଜୁଆର୍‌ କଃଲା ହଃଚେ, ଇସ୍ୱର୍‌ ତାର୍‌ ସେବା କାମାର୍‌ ଗିନେ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ ଜୁୟ୍‌ ଜୁୟ୍‌ କାମ୍‌ କଃରି ରିଲା ସେ ସଃବୁ ଗଟେକ୍‌ ଗଟେକ୍‌ କଃରି ସେମଃନାର୍‌ ତଃୟ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ସେମଃନ୍ ସେରି ସୁଣି ଇସ୍ୱରାର୍‌ ଜଃଜ୍‌ମାନ୍ କଃରୁକେ ଦଃର୍ଲାୟ୍‌ । ଆରେକ୍‌ ତାକେ କୟ୍‌ଲାୟ୍‌, “ଏ ବାୟ୍‌ ପାଉଲ୍‌ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ ଜେ କଃତି ଅଃଜାର୍‌ ବିସ୍ୱାସି ଆଚ୍‌ତି, ଇରି ତୁୟ୍‌ ଦଃକୁଲିସ୍‌, ସଃବୁ ଲକ୍‌ ମସାର୍‌ ବିଦିକେ ମାନୁକେ ଦଃରିବଃସ୍ତାର୍‌ମଃନ୍ । ");
INSERT INTO bdv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଆରେକ୍‌ ଅଜିଉଦି ମଃନ୍‌କାର୍‌ ଦେସେ ବାସା କଃର୍ତା ସଃବୁ ଜିଉଦି ମଃନ୍‌କେ ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ସାନ୍ ହିଲାମଃନ୍‌କେ ସୁନତ୍‌ ନଃକେରୁକ୍‌ ଆର୍‌ ମସାର୍‌ ବିଦି ହଃର୍କାରେ ନଃଚାଲୁକେ ସେମଃନ୍‌କେ ସିକ୍ୟା ଦଃୟ୍‌ଆଚ୍‌ସି ଇ କଃତା ସେମଃନ୍ ସୁଣି ଆଚ୍‌ତି ।” ");
INSERT INTO bdv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ତୁୟ୍‌ ଆସି ଆଚ୍‌ସି ବଃଲି ସେମଃନ୍ ବାୟ୍‌ଦ୍‌ରେ ସୁଣ୍‌ତି ତବେ କଃନ୍‌ କଃରୁଆଁ ? ");
INSERT INTO bdv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ଇତାକ୍‌ ଅଃମିମଃନ୍‌ ତୁମିକେ ଜାୟ୍‌ରି କଃଉଁଲୁ ସେରି କଃର୍‌, ଅଃମାର୍‌ ଚଃମେ ଚାରି ଲକ୍‌ ଆଚ୍‌ତି ସେମଃନ୍ ଗଟେକ୍‌ ବ୍ରତ କଃରି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ସେମଃନ୍‌କେ ନଃୟ୍‌କଃରି ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ନିଜ୍‌କେ ସୁଦ୍‌ କଃର୍‌, ଆର୍‌ ସେମଃନାର୍‌ ମୁଣ୍ଡ୍‌କୁରାୟ୍‌ଲା କଃର୍ଚ୍ ଦେସ୍‌, ତଃନ୍‌ ଅୟ୍‌ଲେକ୍‌ ତର୍‌ କଃତାୟ୍‌ ସେମଃନ୍ ଜୁୟ୍‌ ସଃବୁ କଃତା ସୁଣି ଆଚ୍‌ତି ସେତି କାୟ୍‌ ସଃତ୍‌ ନାୟ୍‌, ଆର୍‌ ତୁୟ୍‌ ହେଁ ନିଜେ ମସାର୍‌ ବିଦି ହାଳୁଲିସ୍‌, ଇରି ସଃବୁ ଜାଣ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ମଃତର୍‌ ଜୁୟ୍‌ ଅଜିଉଦି ଲକ୍‌ମଃନ୍ ବିସ୍ୱାସି ଅୟ୍‌ ଆଚ୍‌ତି, ସେମଃନାର୍‌ କଃତାକ୍‌ ମୁର୍ତି ଚଃମାର୍‌ ହୁଜାକାଦି, ବଃନି, ଟଟି ହିଚ୍‌ଲା ଜଃତୁର୍‌ ମାସ୍‌ ଆର୍‌ ଦାରି କାମ୍‌ ହୁଣି ଅଃହ୍‌ଣା ଆହ୍‌ଣାକେ ଅଃଲ୍‌ଗା କଃର୍ତାର୍‌ ଜେ ନିକ ଇରି ଅଃମିମଃନ୍‌ ବିଚାର୍‌ କଃରି ଲେକି ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ସେତାକ୍‌ ପାଉଲ୍‌ ସେ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଆର୍‌କ ଦିନ୍ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ନିଜ୍‌କେ ନିର୍ମୁଲ୍‌ କଃରି ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗଃଲା, ଆରେକ୍‌ ସେମଃନାର୍‌ ହଃତି ଲକାର୍‌ ଗିନେ ଦାନ୍‌ ଦେଉଁକେ ନିର୍ମୁଳ୍‌ କାମେ କଃତି ଦିନ୍ ଲାଗେଦ୍‌ ସେରି ଜାଣାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ସେ ସାତ୍‌ ଦିନ୍ ସଃର୍ଲାକ୍‌ ଆସିଆର୍‌ ଜିଉଦିମଃନ୍ ମନ୍ଦିରେ ପାଉଲ୍‌କେ ଦଃକି ଲକ୍‌ମଃନ୍‌କେ ସିର୍ଜାୟ୍‌ଲାୟ୍‌, ଆରେକ୍‌ ତାକେ ଦଃରି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉଁକେ ଦଃର୍ଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ଏ ଇସ୍ରାଏଲ୍‌ ଲକ୍‌ମଃନ୍” ସେମଃନ୍ ବେଲ୍‌କି ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌ “ଜୁୟ୍‌ ଲକ୍‌ ସଃବୁ ଟାଣେ ଅଃମିମଃନାର୍‌ ବାସାର୍‌ ଲକ୍‌ ମସାର୍‌ ବିଦି ଆର୍‌ ଇ ଟାଣ୍ ବିରଦେ ସଃବ୍‌କେ ସିକ୍ୟା ଦେତି ରିଲା ସେ ଇ ଲକ୍‌, ଆର୍‌ ହେଁ ସେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଅଜିଉଦିମଃନ୍‌କେ ହେଁ ଆଣି ଇ ପବିତ୍ର ଟାଣ୍‌କେ ବିଟାଳ୍‌ କଃରି ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ହୁର୍ବେ ଗଃଳ୍‌ ବିତ୍ରେ ଏପିସିର୍‌ ତ୍ରପିମ୍‌କେ ପାଉଲ୍‌ ସଃଙ୍ଗେ ଦଃକି ରିଲାୟ୍‌ ଆର୍‌ ସେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଆଣେଦ୍‌ ବଃଲି ବାବ୍‌ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଇତାକ୍‌ ଗଃଳାର୍‌ ସଃବୁ ହାକ୍‌ ଉରାଟୁ ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ଉର୍ଜି ଅୟ୍‌ଲି ଲକ୍‌ମଃନ୍ ଗଟେକ୍‌ ତଃୟ୍‌ ଦଃବୁଳ୍‌ଲାୟ୍‌ ଆରେକ୍‌ ସେମଃନ୍ ପାଉଲ୍‌କେ ଦଃରି ମନ୍ଦିରାର୍‌ ହଃଦାୟ୍‌ ଜିକି ଆଣ୍‌ଲାୟ୍‌, ଆର୍‌ ସେ ଦାହ୍ରେ ଦୁଆର୍‌ ସଃବୁ ଡାହ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ଆରେକ୍‌ ସେମଃନ୍ ତାକେ ମାରି ହଃକାଉଁକ୍‌ ଉପାୟ୍‌ କଃଲାକ୍‌ ସଃବୁ ଜିରୁସାଲମେ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ ଅୟ୍‌ଆଚେ ବଃଲି ସଃଇନ୍ ଦଃଳାର୍‌ ସଃଇନ୍‌ ଅଃଦିକାରି ଟାଣେ କଃବୁର୍‌ ଆୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ଇତାକ୍‌ ସେଦାହ୍ରେ ସଃଇନ୍ ଆର୍‌ ହାଁଚ୍ କଳି ସଃଇନ୍ ଉହ୍ରାର୍‌ ଅଃଦିକାରିକ୍‌ ଦଃରି ସେମଃନାର୍‌ ତଃୟ୍‌ ଦଃବୁଳ୍‌ଲା, ସେମଃନ୍ ସଃଇନ୍‌ ଅଃଦିକାରିକ୍‌, ଆର୍‌ ସଃଇନ୍‌ମଃନ୍‌କେ ଦଃକି ପାଉଲ୍‌କେ ମାରୁକେ ବଃନ୍ଦ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ସଃଡେବଃଳ୍‌ ସଃଇନ୍‌ ଅଃଦିକାରି ଚଃମେ ଆସି ତାକେ ଦଃରି ଜଳେକ୍‌ ସିକ୍ଳାୟ୍‌ ବାନ୍ଦୁକେ କୟ୍‌ଲା, ଆର୍‌ ହଃଚାର୍ଲାୟ୍‌, “ଇ ଲକ୍‌ କେ ? ଆର୍‌ କାୟ୍‌ କଃରିଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ସେତାକ୍‌ ଲକ୍‌ମଃନାର୍‌ ବିତ୍ରେ କେକେ ଇ କଃତା ଆର୍‌ କଃତେକ୍‌ ସେ କଃତା କୟ୍‌ ଉରାଟୁ କଃରୁକେ ଦଃର୍ଲାୟ୍‌, ଆର୍‌ ସେ ଉରାଟୁର୍‌ ମୁଳ୍‌ ନିଜ୍‌କଃରି ଜାଣୁ ନଃହାର୍ଲାକ୍‌ ତାକେ ସଇନ୍‌ମଃନାର୍‌ ରେତା ଟାଣେ ନେଉଁକ୍‌ ଆଦେସ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ଜଃଡେବଃଳ୍‌ ତାକେ ହାଉଜ୍‌ ଉହ୍ରେ ଆଣ୍‌ଲାୟ୍‌, ସଃଡେବଃଳ୍‌ ଲକ୍‌ମଃନାର୍‌ ରିସାକ୍‌ ଦଃକି ସଇନ୍‌ମଃନ୍‌ ତାକେ ବୟ୍‌ ନେଉଁକ୍‌ ହଃଳ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଗାଦେକ୍‌ ଲକ୍‌ ହଃଚେ ଜଃଉଁ ଜଃଉଁ ତାକେ “ମଃର୍ନେ ମାରା” ବଃଲି ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କଃଉତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ସେମଃନ୍ ପାଉଲ୍‌କେ ଗଃଳ୍‌ ବିତ୍ରେ ନେଉଁକ୍‌ ଦଃର୍ଲା ବଃଳ୍‌ ସେ ସଃଇନ୍‌ ଅଃଦିକାରିକ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ତକ୍‌ କାୟ୍‌ରି କୟ୍‌ନ୍ଦ୍ କି ?” “ସେ ତାକ୍‌ କୟ୍‌ଲା, ତୁୟ୍‌ କାୟ୍‌ ଗ୍ରିକ୍‌ ଜାଣ୍‌ସି ? ");
INSERT INTO bdv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ତଃବେ ଇତାର୍‌ ହୁର୍ବେ ଜୁୟ୍‌ ମିସରାର୍‌ କଃଙ୍ଗାର୍‌ ଜେ ଚାରି ଆଜାର୍‌ ଲକ୍‌ମଃନ୍‌କେ ସୁକ୍‌ଲା ବଃଟାୟ୍‌ ନଃୟ୍‌ରିଲା ତୁୟ୍‌ କି ସେଲକ୍‌ ନାୟ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ସେତାକ୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ଗଟେକ୍‌ ଜିଉଦି” ତାର୍ସୁସ୍‌ ଗଃଳାର୍‌ ଲକ୍‌ କିଲିକିଆର୍‌ ଗଟେକ୍‌ ବଃଡ୍‌ ଜାଣାସୁଣା ଗଃଳାର୍‌ ଲକ୍‌ । ଇ ଲକ୍‌ମଃନ୍‌କେ କଃତା କଃଉଁକେ ଆଦେସ୍‌ ଦେ ବଃଲି ତକେ ଗଃଉଆରି କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ମୁଳିକା ମାନାୟ୍‌ କାଉଁକେ ଦିଲାକ୍‌ ପାଉଲ୍‌ ହାଉଜେ ଟିଆ ଅୟ୍‌ ସେମଃନ୍‌କେ ଆତ୍‌ସଃଗ୍ୟା କଃଲା, ଆର୍‌ ସଃବୁ ଲକ୍‌ ତୁନ୍‌ହଃଳ୍‌ଲାକ୍‌ ସେ ଏବ୍ରି ବାସାୟ୍‌ ସେମଃନ୍‌କେ କଃଉଁକେ ଦଃର୍ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ଏ ବାୟ୍‌ ଆର୍‌ ଉବାମଃନ୍‌, ମୁୟ୍‌ଁ ଅଃବେ ତୁମିମଃନାର୍‌ ଚଃମେ ଜୁୟ୍‌ ମର୍‌ ନିଜାର୍‌ କଃତା କଃଉଁଲେ ସୁଣା ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ପାଉଲ ସେମଃନାର୍‌ ଚଃମେ ଏବ୍ରି ବାସାୟ୍‌ କଃତା କଃଉଁଲା ବଃଲି ସୁଣି ସେମଃନ୍ ଅଃଦିକ୍‌ ତୁନ୍‌ହଃଳ୍‌ଲାକ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ସେତାକ୍‌ ସେ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ଗଟେକ୍‌ ଜିଉଦି, କିଲିକିଆର୍‌ ତାର୍ସୁସ୍‌ ଗଃଳେ ମର୍‌ ଜଃଲମ୍‌, ମଃତର୍‌ ମୁୟ୍‌ଁ ଇ ଗଃଳେ ବାଡି ଆଚି ଅଃମିମଃନାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ବିଦି ବିଦାନ୍‌ ହଃର୍କାରେ ଗମଲିଏଲାର୍‌ ଚେଲା ରିଲେ, ସଃର୍ଦାୟ୍‌ ତୁମିମଃନ୍ ସଃବୁ ଆଜି ଜଃନ୍‌କଃରି ବିସ୍ୱାସି ଆଚାସ୍‌ ଇସ୍ୱରାର୍‌ ଗିନେ ମୁୟ୍‌ଁ ହେଁ ସେନ୍ ଦଃରିବଃସି ବିସ୍ୱାସି ଅୟ୍‌ ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ମୁୟ୍‌ଁ ମାପ୍ରୁ ବାଟ୍‌ ଜାତା ଅଃଣ୍ଡ୍ରା ଆର୍‌ ମାୟ୍‌ଜିମଃନ୍‌କେ ବାନ୍ଦି ଜଃଇଲେ ହୁରାୟ୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ଦେତି ରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ମର୍‌ ଇ କଃତା ସଃତ୍‌, ମୁଳ୍‌ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍ ସଃବୁ ଲକ୍‌ ମର୍‌ ସାକି, ସେମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ମୁୟ୍‌ଁ ବାୟ୍‌ ମଃନାର୍‌ ଚଃମେ ଚିଟି ହାୟ୍‌ ଦମେସକ୍‌ ରେତା ଲକ୍‌ମଃନ୍ ଜଃନ୍‌କଃରି ଡଃଣ୍ଡ୍‌ ହାଉତି ଇତାକ୍‌ ସେମଃନ୍‌କେ ହେଁ ସିକ୍‌ଳାୟ୍‌ ବାନ୍ଦି ଜିରୁସାଲମାର୍‌ ବେରାଣେ ଆଣୁକେ ସେଟାଣେ ଜାୟ୍‌ରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ମଃତର୍‌ ମୁୟ୍‌ଁ ଜଃଉଁଜଃଉଁ ଦମେସକ୍‌ ଚଃମେ ଆୟ୍‌ଲାକ୍‌ ମଃୟ୍‌ଦାନ୍ ବଃଳ୍‌ ତଃତ୍‌କାଣ୍ ମର୍‌ ଚାରି ବେଳ୍‌ତ୍ ଅଃଗାସେ ହୁଣି ବଃଡେ ଉଜାଳ୍‌ ଜଃଲ୍‌କି ଗଃଲି । ");
INSERT INTO bdv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ସେତାକ୍‌ ମୁୟ୍‌ଁ ବୁୟେଁ ଅଦୁର୍ଲେ ଆର୍‌ ମର୍‌ ଗିନେ ଇ କଃତା ସୁଣା ଗଃଲି, “ସାଉଲ୍‌, ସାଉଲ୍‌, କାୟ୍‌ତାକ୍‌ ମକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“ମୁୟ୍‌ଁ ହଃଚାର୍ଲେ, ମାପ୍ରୁ ତୁୟ୍‌ କେ ? ସେତାକ୍‌ ସେ ମକ୍‌ କୟ୍‌ଲା, ତୁୟ୍‌ ଜୁୟ୍‌ ନାଜରିତାର୍‌ ଜିସୁକେ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌, ମୁୟ୍‌ଁ ସେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ଜୁୟ୍‌ମଃନ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ରିଲାୟ୍‌ ସେମଃନ୍ ସେ ଉଜାଳ୍‌ ଦଃକ୍‌ଲାୟ୍‌ ସଃତ୍‌, ମଃତର୍‌ ଜେ ମକ୍‌ କଃତା କୟ୍‌ଲା, ତାର୍‌ ଟଣ୍ଡ୍ ନଃସୁଣ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ସେତାକ୍‌ ମୁୟ୍‌ଁ ହଃଚାର୍ଲେ, ମାପ୍ରୁ ମୁୟ୍‌ଁ କାୟ୍‌ରି କଃରିନ୍ଦ୍‌, ସେତାକ୍‌ ମାପ୍ରୁ କୟ୍‌ଲା, “ଉଟ୍‌ ଦମେସକ୍‌ ଜାଆ, ଆର୍‌ ସଃବୁ ଇସ୍ୱରାର୍‌ କାମ୍‌ କଃରୁକେ ତର୍‌ ଗିନେ ଟିକ୍‌ କଃରା ଅୟ୍‌ଆଚେ ସେ ସଃବୁ ତକ୍‌ ସେତି କଃଉଆ ଅୟ୍‌ଦ୍‌ ");
INSERT INTO bdv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ସେ ଉଜାଳାର୍‌ ଜଃଜ୍‌ମାନ୍‌ ଗିନେ ମୁୟ୍‌ଁ ଦଃକୁ ନଃହାର୍ଲାକ୍‌ ମର୍‌ ସଃଙ୍ଗ୍ ରେତା ଲକ୍‌ମଃନାର୍‌ ମକେ ଆତେ ଦଃରି ଦମେସକ୍‌କେ ଆଣ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ସେତି ରିଲା ସଃବୁ ଜିଉଦିମଃନାର୍‌ ଚଃମେ ଡାକ୍‌ ହୁଟା ହନନିଅ ନାଉଁଆର୍‌ ବିଦି ହଃର୍କାରେ ଗଟେକ୍‌ ମାପ୍ରୁର୍‌ ହୁଜା କଃର୍ତା ଲକ୍‌, ସେତିରିଲା ଜିଉଦି ଲକ୍‌ ମଃନ୍‌ ତାକେ ମାୟ୍‌ନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ସେ ମର୍‌ ଚଃମେ ଆସି ଟିଆଅୟ୍‌ ମକ୍‌ କୟ୍‌ଲା, ସାଉଲ୍‌ ବାୟ୍‌ ଆକି ଦଃକ୍‌, ସେଦାହ୍ରେ ମୁୟ୍‌ଁ ତାକେ ଦଃକ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ଆରେକ୍‌ ସେ କୟ୍‌ଲା, ‘ଅଃମିମଃନାର୍‌ ଦାଦିବାବୁର୍‌ ଇସ୍ୱର୍‌ ତାର୍‌ ମଃନ୍ ଜାଣୁକେ ଆର୍‌ ସେ ଦଃର୍ମି ଲକ୍‌କେ ଦଃକୁକ୍‌ ଆରେକ୍‌ ତାର୍‌ ମୁଆଁର୍‌ କଃତା ସୁଣୁକ୍‌ ତକ୍‌ ବାଚି ଆଚେ ।’ ");
INSERT INTO bdv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ଦଃକି ଆଚ୍‌ସି ଆର୍‌ ସୁଣି ଆଚ୍‌ସି, ସେ ସଃବୁ କଃତା ସଃବୁ ଲକମଃନାର୍‌ ତଃୟ୍‌ ତାର୍‌ ସାକି ଅଃଉସି । ");
INSERT INTO bdv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଆର୍‌ ଅଃବେ ତୁୟ୍‌ କାୟ୍‌ତାକ୍‌ ବେଳା କଃରୁଲିସ୍‌, ଉଟ୍‌ ବାପ୍ତିସମ୍‌ ହାଉ, ଆରେକ୍‌ ତାର୍‌ ନାଉଁଏ ପାର୍ତ୍‌ନା କଃରି ନିଜାର୍‌ ହାହ୍‌ ସଃବୁ ଦଃଉ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ଇତାର୍‌ ହଃଚେ ମୁୟ୍‌ଁ ଜିରୁସାଲମ୍‌କେ ବାଉଳି ଆସି, ମନ୍ଦିରେ ପାର୍ତ୍‌ନା କଃର୍ତା ବଃଳ୍‌ ଦଃର୍ସନ୍‌ ଦଃକ୍‌ଲେ, ");
INSERT INTO bdv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ସେ ଦଃର୍ସନେ ମୁୟ୍‌ ମାପ୍ରୁକେ ଦଃକ୍‌ଲେ, ସେ ମକ୍‌ କୟ୍‌ଲା, ବେଳ୍‌ ନଃକେରି ‘ବେଗି ଜିରୁସାଲମ୍‌କେ ଜାଆ’ କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେମଃନ୍ ଅଃମାର୍‌ ବିସୟେ ତର୍‌ ସାକି ନଃମାନ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ସେତାକ୍‌ ମୁୟ୍‌ଁ କୟ୍‌ଲେ, ‘ମାପ୍ରୁ ମୁୟ୍‌ଁ ଜେ ତର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସି ମଃନ୍‌କେ ପାର୍ତ୍‌ନା ଗଃରେ ଦଃରି ଜଃଇଲେ ହୁରାଉତି ରିଲେ, ଇରି ସେମଃନ୍ ନିଜେ ଜାଣି ଆଚ୍‌ତି ।’ ");
INSERT INTO bdv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ତୁମାର୍‌ ସାକି ସ୍ତିପାନ୍ ମାଡ୍ କାତି ରିଲା, ସଃଡେବଃଳ୍‌ ମୁୟ୍‌ଁ ହେଁ ସେ ଚଃମେ ଟିଆ ଅୟ୍‌ ସେରି ରାଜି ଅୟ୍‌ରିଲେ, ଆର୍‌ ଅଃତ୍ୟା କଃର୍ତା ଲକ୍‌ମଃନାର୍‌ ବଃସ୍ତର୍‌ ଜାଗ୍‌ତି ରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ସେତାକ୍‌ ପର୍ବୁ ମକ୍‌ କୟ୍‌ଲା, ‘ଜାଆ,’ କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ଦୁର୍‌କେ ଅଜିଉଦି ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ହଃଟାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ପାଉଲ୍‌ ଇ କଃତା କଃଉତା ହଃତେକ୍‌ ଲକ୍‌ମଃନ୍ ସୁଣ୍‌ତିରିଲାୟ୍‌ ଆର୍‌ ବଃଡ୍ ଟଣ୍ଡ୍ କଃରି କୟ୍‌ଲାୟ୍‌, “ଅଃନ୍‌କା ଲକ୍‌କେ ହୁର୍ତିବି ହୁଣି ଦୁର୍‌ କଃରା, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସେ ଜିବନ୍‌ ରେତାର୍‌ ନିକ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ଆର୍‌ ଜଃଡେବଃଳ୍‌ ସେମଃନ୍ ଉରାଟୁ କଃରି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାର୍‌ ବଃସ୍ତର୍‌ ହିଙ୍ଗି ଅଃଗାସେ ଦୁଳି ହଃକାଉଁକ୍‌ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ସଃଡେବଃଳ୍‌ ସଃଇନ୍‌ ଅଃଦିକାରି ତାକେ ଗଃଳ୍‌ ବିତ୍ରେ ନେଉଁକ୍‌ କୟ୍‌ଲା, ଆରେକ୍‌ ଲକ୍‌ମଃନ୍ ତାର୍‌ ବିରଦେ କାୟ୍‌ତାକ୍‌ ଅଃନ୍‌କାର୍‌ ଉରାଟୁ କଃରୁଲାୟ୍‌ ସେରି ଜାଣୁକ୍‌ କୁଆଳ୍‌ ବିତ୍ରେ ନଃୟ୍‌ ସାଟ୍‍ଣି ମାରାୟ୍‌ ତାର୍‌ କଃଟ୍‌ହାଳ୍‌ ବୁଜୁକ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ସେମଃନ୍ ତାକେ କର୍ଡା ମାରୁକ୍‌ ବାନ୍ଦ୍‌ଲା ହଃଚେ, ପାଉଲ୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ରିଲା ହାଁଚ୍ କଳି ସଃୟ୍‌ନ୍‌ ଉହ୍ରାର୍‌ ମୁଳିକା ସଃଇନ୍‌କେ କୟ୍‌ଲା, “ଗଟେକ୍‌ ରମିୟ ଲକାର୍‌ ବିଚାର୍‌ ନଃକେରି ତାକେ ସାଟ୍‍ଣି ସଃଙ୍ଗ୍ ମାର୍ତାର୍‌ ତୁମାର୍‌ ତଃୟ୍‌ କାୟ୍‌ ବିଦି ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ସେ ସଃଇନ୍‌ ଅଃଦିକାରି ଇରି ସୁଣି ସଃଇନ୍‌ ଅଃଦିକାରି ଚଃମେ ଜାୟ୍‌ ଇ କଃତା କୟ୍‌ଲା, “ତୁୟ୍‌ କାୟ୍‌ରି କଃରୁକେ ଜଃଉଁଲିସ୍‌ ? ଇ ଲକ୍‌ ତ ଗଟେକ୍‌ ରମିୟ ଲକ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ସେତାକ୍‌ ସେ ସଃଇନ୍‌ ଅଃଦିକାରି ଆସି ତାକେ ହଃଚାର୍ଲା, “ମକ୍‌ କଃଉ, ତୁୟ୍‌ କାୟ୍‌ ଗଟେକ୍‌ ରମିୟ ?” ସେ କୟ୍‌ଲା, “ହେଁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ସଃଇନ୍‌ ଅଃଦିକାରି କୟ୍‌ଲା, “ବୁତେକ୍‌ ଟଃକା ଦଃୟ୍‌ ମୁୟ୍‌ଁ ଇ ରମିୟ ଲକ୍‌ ଅୟ୍‌ ଆଚି ।” ମଃତର୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, ମୁୟ୍‌ଁ ଜଃଲମେ ହୁଣି ରମିୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ତଃବେ ଜୁୟ୍‌ମଃନ୍‌ ତାକେ କଃଟ୍‌ହାଳ୍‌ ବୁଜୁକ୍‌ ମଃନ୍‌ କଃର୍ତି ରିଲାୟ୍‌ ସେମଃନ୍ ତଃତ୍‌କାଣ୍ ସେତି ହୁଣି ତୁନ୍‌ହାଳ୍‌ଲାୟ୍‌ ଆର୍‌ ଗଟେକ୍‌ ଅଃଜାର୍‌ ସଃଇନାର୍‌ ମୁଳିକା ହେଁ ସେ ଗଟେକ୍‌ ରମିୟ, ଇରି ଜାଣ୍‌ଲାକ୍‌ ପାଉଲ୍‌କ୍ ବାନ୍ଦ୍‌ଲାର୍‌ ଗିନେ ଡିରି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ମଃତର୍‌ ସେ କାୟ୍‌ତାକ୍‌ ଜିଉଦିମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଦସି କଃରି ଆଚ୍‌ତି, ସେରି ନିଜ୍‌କଃରି ଜାଣୁକେ ସେ ଆର୍‌କ ଦିନ୍ ତାର୍‌ ବାନ୍ଦ୍‌ଲାର୍‌ ଇଟାୟ୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ସଃବୁଲକ୍‌ ଜିଉଦିମଃନାର୍‌ ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ସଃଙ୍ଗେ ଆସୁକ୍‌ କୟ୍‌ଲା, ଆର୍‌ ପାଉଲ୍‌କେ ନଃୟ୍‌ ସେମଃନାର୍‌ ଚଃମେ ଟିଆ କଃରାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ଆର୍‌ ପାଉଲ୍‌ ଜିଉଦି ବେରାଣ୍ ମଃଣ୍ଡାକ୍‌ ନିକ କଃରି ଦଃକି କୟ୍‌ଲା, “ଏ ଇସ୍ରାଏଲିୟ ବାୟ୍‌ମଃନ୍, ମୁୟ୍‌ଁ ଆଜି ହଃତେକ୍‌ ନିକ ମଃନେ ଇସ୍ୱରାର୍‌ ଚଃମେ ଚାଲ୍‌ଚାଲ୍‌ତି କଃରି ଆସିଆଚି ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ସେତାକ୍‌ ମୁଳ୍‌ ଜାଜକ୍‌ ହନନିଅ ପାଉଲ୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ ମଃନ୍‌କେ ତାର୍‌ ମୁଏଁ ଚାହୁଳ୍‌ ମାରୁକ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ସଃଡେବଃଳ୍‌ ପାଉଲ୍‌ ତାକେ କୟ୍‌ଲା, “ଏ ଚୁନ୍‌ ମାର୍‌ଲା ଦଃବ୍‌ଳା କୁଡ୍‌, ଇସ୍ୱର୍‌ ତକ୍‌ ମାରେଦ୍‌, ତୁୟ୍‌ ଅଃକାବଃଳ୍‌ ବିଦି ହଃର୍କାରେ ମର୍‌ ବିଚାର୍‌ ନଃକେରି, ବିଦି ବିରଦେ ମକ୍‌ ମାରୁକ୍‌ କଃଉଁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ସେତାକ୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ରିଲା ଲକ୍‌ମଃନ୍ କୟ୍‌ଲାୟ୍‌, “ତୁୟ୍‌ କି ଇସ୍ୱରାର୍‌ ମୁଳ୍‌ ଜାଜକ୍‌କେ ଲିନ୍ଦା କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ଆରେକ୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, “ଏ ଇସ୍ରାଏଲିୟ ବାୟ୍‌ମଃନ୍‌ ସେ ମୁଳ୍‌ ଜାଜକ୍‌ ବଃଲି ମୁୟ୍‌ଁ ଜାଣି ନଃରିଲେ, କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସାସ୍ତରେ ଲେକା ଆଚେ, ତୁମି ଅଃହ୍‌ଣାର୍‌ ମୁଳିକାକ୍‌ ମଃନ୍ଦ୍‌ କଃତା କଃଉଆ ନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ମଃତର୍‌ ପାଉଲ୍‌ ଗଟେକ୍‌ ବାଗ୍ ସାଦୁକି ଆର୍‌ ଗଟେକ୍‌ ବାଗ୍ ପାରୁସି ବଃଲି ଜାଣି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ଉଲ୍‌ଗାଟ୍‌ ଅୟ୍‌ କୟ୍‌ଲା, “ଏ ଇସ୍ରାଏଲିୟ ବାୟ୍‌ମଃନ୍ ମୁୟ୍‌ଁ ଗଟେକ୍‌ ପାରୁସି ଆର୍‌ ପାରୁସିର୍‌ ହୟ୍‌ସି, ଆରେକ୍‌ ଇ ବଃର୍ସା, ବଃଲେକ୍‌ ମଃଲା ଲକ୍‌ ମଃନାର୍‌ ଉଟ୍‌ତା ବିସୟେ ମୁୟ୍‌ଁ ବିଚାର୍‌ ଅଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ସେ ଇ କଃତା କୟ୍‌ଲାକ୍‌ ପାରୁସି ଆର୍‌ ସାଦୁକି ମଃନାର୍‌ ବିତ୍ରେ ଦଃରାମ୍‌ସ୍କା ଅୟ୍‌ଲାୟ୍‌, ଆର୍‌ ବେରାଣ୍ ମଃଣ୍ଡା ଦଃଳ୍‌ ବାଗ୍ ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ ସାଦୁକିମଃନ୍ ମଃଲେକ୍‌ ଉଟ୍‌ତାର୍‌ ନାୟ୍‌ କି ଦୁତ୍‌ ଆର୍‌ ଆତ୍ମା ନାୟ୍‌ ବଃଲି କଃଉତି, ମଃତର୍‌ ପାରୁସିମଃନ୍ ଇ ତିନିଗଟ୍‌ ହେଁ ମାନ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ଇତାକ୍‌ ବଃଡେ ଉରାଟୁ ଅୟ୍‌ଲି ଆର୍‌ ପାରୁସିମଃନାର୍‌ ଦଃଳାର୍‌ କଃତେକ୍‌ ଦଃର୍ମ୍‌ଗୁରୁମଃନ୍‌ ଉଟି କଃତା ଦଃରା ଦଃରି ଅୟ୍‌ କୟ୍‌ଲାୟ୍‌ “ଅଃମିମଃନ୍‌ ଇ ଲକ୍‌ତଃୟ୍‌ କାୟ୍‌ ଦଃସ୍‌ ନଃଦେକୁ, କେ ଜାଣ୍ କୁୟ୍‌ ଆତ୍ମା କି ଦୁତ୍‌ ତାର୍‌ ସଃଙ୍ଗ୍ କଃତା କଃଉଁଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ଅଃନ୍‌କାର୍‌ ବଃଡେ ଉରାଟୁ ଅୟ୍‌ଲାକ୍‌ କଃଡେବଃଳ୍‌ ପାଉଲ୍‌କେ କଃଣ୍ଡ୍ କଃଣ୍ଡ୍ କଃରି ମାର୍ତି, ଇ ଡିରାର୍‌ ଗିନେ ସଃଇନ୍‌ ଅଃଦିକାରି ସେମଃନାର୍‌ ବିତ୍ରେ ବଃଳ୍‌ ମାଡେ ଗଃଳ୍‌ ବିତ୍ରେ ଆଣୁକେ ସଃଇନ୍‌ମଃନ୍‌କେ ଆଦେସ୍‌ ଦିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ସେ ରାତି ମାପ୍ରୁ ତାର୍‌ ଚଃମେ ଟିଆ ଅୟ୍‌ କୟ୍‌ଲା, “ଡିର୍‌ ନାୟ୍‌ ସାସ୍‌ ଦଃର୍‌ କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଜଃନ୍‌କଃରି ଜିରୁସାଲମେ ଅଃମାର୍‌ ସାକି ଦିଲିସ୍‌, ସେନ୍‌କଃରି ତକ୍‌ ରମ୍‌ ତଃୟ୍‌ ହେଁ ସାକି ଦେଉଁକ୍‌ ଅୟ୍‌ଦ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଆର୍‌କ ଦିନ୍ ସଃକାଳ୍‌ ଅୟ୍‌ଲାକ୍‌ ଜିଉଦିମଃନ୍ ମଃନ୍ଦା ଅୟ୍‌ ପାଉଲ୍‌କେ ନଃମାର୍ତା ହଃତେକ୍‌ ଅଃର୍ନ୍‌ ଆଣି ଚୁୟ୍‌ଲେକ୍‌ ସାୟ୍‌ପ୍‌ ହାଉଁନ୍ଦ୍ ବଃଲି ଅଃହ୍‌ଣା ଅଃହ୍‌ଣାକ୍‌ ସଃୟ୍‌ତ୍‌ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ଇ କୁଟ୍‌ କଃଲା ଲକ୍‌ମଃନ୍ ଦୁୟ୍‌ କଳି ଲକ୍‌ ହୁଣି ଅଃଦିକ୍‌ ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ସେମଃନ୍ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନାର୍‌ ହାକ୍‌ ଆସି କୟ୍‌ଲାୟ୍‌ “ଅଃମିମଃନ୍‌ ପାଉଲ୍‌କେ ମଃର୍ନେ ନଃମାର୍ତା ହଃତେକ୍‌ କାୟ୍‌ରି କାୟ୍‌ଲେକ୍‌ ସାୟ୍‌ପ୍‌ ହାଉଁନ୍ଦ୍ ବଃଲି ନିଜେ ନିଜେ ସଃୟ୍‌ତ୍‌ କଃରି ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ତଃବେ ତୁମିମଃନ୍ ଅଃଦିକ୍‌ ନିକ କଃରି ତାର୍‌ ବିଚାର୍‌ କଃରୁକେ ମଃନ୍ କଃରୁଲୁ ବଃଲି ଜଃଟି କଃରି ତାକେ ତୁମିମଃନାର୍‌ ଚଃମେ ଆଣୁକେ ଅଃବେ ବେରାଣ୍ ମୁଣ୍ଡାର୍‌ ଲକେ ଆର୍‌ ସଃଇନ୍‌ ଅଃଦିକାରିକ୍‌ ଗଃଉଆରି କଃରା । ସେ ବେରାଣେ ଆସ୍ତା ହୁର୍ବେ ଅଃମିମଃନ୍‌ ତାକେ ମାରୁକ୍‌ ଜାଗି ଆଚୁ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ମଃତର୍‌ ପାଉଲାର୍‌ ବେଣ୍‌ସିର୍‌ ହୟ୍‌ସି ସେମଃନାର୍‌ ଜାଗି ରିଲାର୍‌ କଃତା ସୁଣି ଆସି, ଗଃଳ୍‌ ବିତ୍ରେ ହୁରି ପାଉଲ୍‌କେ ଜାଣାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ସେତାକ୍‌ ପାଉଲ୍‌ ଗଟେକ୍‌ ହାଁଚ୍ କଳି ମୁଳିକା ସଃଇନ୍‌କେ କୁଦି କୟ୍‌ଲା, “ଇ ବେଣ୍ଡ୍ୟାକ୍‌ ଏକ୍‌ ଅଃଜାର୍‌ ସଃଇନାର୍‌ ମୁଳିକାର୍‌ ଚଃମେ ନେ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାକେ ଜାଣାଉଁକ୍‌ ଆର୍‌ କାୟ୍‌ କଃତା ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ସେତାକ୍‌ ତାକେ ସଃଇନାର୍‌ ଅଃଦିକାରି ମୁଳିକା ଚଃମେ ନଃୟ୍‌ କୟ୍‌ଲା, “କଃୟ୍‌ଦି ପାଉଲ୍‌ ତାର୍‌ ଚଃମେ ମକ୍‌ କୁଦି ତର୍‌ ଚଃମେ ଇ ବେଣ୍ଡ୍ୟାକେ ଆଣୁକେ ଗଃଉଆରି କଃଲା, ତୁୟ୍‌ କଃଉ ଆର୍‌ କାୟ୍‌ କଃତା ଆଚେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ସଃଇନାର୍‌ ଅଃଦିକାରି ସେ ବେଣ୍ଡ୍ୟାର୍‌ ଆତ୍‌ ଦଃରି ଗଟେକ୍‌ ସିଣିନ୍ଦ୍ ଟାଣେ ନଃୟ୍‌ ତାକେ ହଃଚାର୍ଲା, “ମକ୍‌ ଜାଣାଉ ତର୍‌ କାୟ୍‌ରି କଃଉତାର୍‌ ଆଚେ ?” ");
INSERT INTO bdv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ସେ କୟ୍‌ଲା, ପାଉଲାର୍‌ କଃତାକ୍‌ ଅଃଦିକ୍‌ ନିକ କଃରି ବିଚାର୍‌ କଃରୁକେ, ହେଟ୍‌କପଟିଆ ଜିଉଦିମଃନ୍ ତାକେ କାଲି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ଆଣୁକେ ତକ୍‌ ଗଃଉଆରି କଃରୁକେ ଟିକ୍‌ କଃରି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ଇତାକ୍‌ ସେମଃନାର୍‌ କଃତାୟ୍‌ ରାଜି ଅଃଉଅ ନାୟ୍‌, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତାକେ ମଃର୍ନେ ନଃମାର୍ତା ହଃତେକ୍‌ ଅଃର୍ନ୍‌ ହାଣି ଚୁୟ୍‌ଲେକ୍‌ ସାୟ୍‌ପ୍‌ ହାଉଁନ୍ଦ୍ ବଃଲି ନିଜେ ନିଜେ ସଃୟ୍‌ତ୍‌ କଃରି ଦୁୟ୍‌ କଳି ଲକ୍‌ ହୁଣି ଅଃଦିକ୍‌ ତାକେ ଜାଗି ଆଚ୍‌ତି । ଆର୍‌ ଅଃବେ ସେମଃନ୍ ତର୍‌ ତଃୟ୍‌ହୁଣି ଆଦେସ୍‌ ହାଉଁକ୍‌ ଜାଗି ଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ସେତାକ୍‌ ସଃଇନ୍‌ ଅଃଦିକାରି ସେ ବେଣ୍ଡ୍ୟାକ୍‌ ହଃଟାୟ୍‌ ଦଃୟ୍‌ ତାକେ କୟ୍‌ଲା, “ତୁୟ୍‌ ଜୁୟ୍‌ କଃତା ମକ୍‌ କୟ୍‌ଲିସ୍‌, ଇତି କାକେ ହେଁ କଃଉନାୟ୍‌ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ସଃୟ୍‌ନ୍‌ ଅଃଦିକାରି ତାର୍‌ ଜଳେକ୍‌ ଅଃଦିକାରିକ୍‌ କୁଦି କୟ୍‌ଲା “କାଇସରିଆ ହାକ୍‌ ଜଃଉଁକେ ଦୁୟ୍‌ସ ସଃଇନ୍‌ ମଃନ୍‌କେ ଜାଗ୍ରତ୍‌ କଃର୍‌, ଦୁୟ୍‌କଳି ଗଃଳା ଚଃଗୁ ଆର୍‌ ଦୁୟ୍‌ସ ବାଲା ଦଃରୁ ମଃନ୍‌କେ ଆର୍‌ ଆଜି ରାତି ନଅ ଗଃଟା ବଃଳ୍‌ ବାରାଉଁକେ ଟିକ୍‌ କଃର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ଆରେକ୍‌ ସେମଃନ୍ ଜଃନ୍‌କଃରି ପାଉଲ୍‌କେ ବଃସାୟ୍‌ ରଃଜାର୍‌ ଗୁମୁସ୍ତା ପେଲିକ୍‌ସ୍ ତଃୟ୍‌ ଜଃତୁନେ ନେତି, ଇତାକ୍‌ ସଃବୁ କଃରୁକେ ଆଦେସ୍‌ ଦିଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ଆର୍‌ ମୁଳିକା ଅଃନ୍‌କାର୍‌ ଗଟେକ୍‌ ଚିଟି ଲେକ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ମାୟ୍‌ନ୍‌ କାରି ଗନର୍‌ ପେଲିକ୍‌ସ୍‌କେ କ୍ଲାଉଦିଅ, ଲୁସିଆକେ ଜୁଆର୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଜିଉଦିମଃନ୍ ଇ ଲକ୍‌କେ ଦଃରି ମାରୁକ୍‌ ଜାତା ବଃଳ୍‌ ମୁୟ୍‌ଁ ସଃଇନ୍ ମଃନାର୍‌ ସଃଙ୍ଗ୍ ଜାୟ୍‌ ସେ ଗଟେକ୍‌ ରମିୟ ବଃଲି ଜାଣି ଆକ୍‌ ବାଚାୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","କାୟ୍‌ତାର୍‌ ଗିନେ ସେମଃନ୍ ଆକ୍‌ ଦଃସ୍‌ ଦଃରୁଲାୟ୍‌ ସେରି ଜାଣୁକେ ମଃନ୍‌କଃରି ମୁୟ୍‌ଁ ଆକ୍‌ ସେମଃନାର୍‌ ବେରାଣେ ନିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ କି ବାନ୍ଦୁଣ୍‌ ଜୟ୍‌ଗ୍‌ କାୟ୍‌ କଃତା ଆର୍‌ ବିରଦେ ଦଃସ୍‌ କଃରା ନଃଜାୟ୍‌ଁ ସେମଃନାର୍‌ ବିଦିର୍‌ କଃତା ଦଃସ୍‌ କଃରା ଅଃଉଁଲି ବଃଲି ମୁୟ୍‌ଁ ବୁଜ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ଇ ଲକ୍‌ ବିରଦେ କୁଟ୍‌ କଃରା ଅୟ୍‌ଆଚେ ବଃଲି ମକ୍‌ କୟ୍‌ଲାକ୍‌ ମୁୟ୍‌ଁ ଆକ୍‌ ଦାପେ ତର୍‌ ହାକ୍‌ ହଃଟାୟ୍‌ଲେ, ଆର୍‌ ଦଃସ୍‌ ଦଃରୁ ମଃନ୍‌କେ ହେଁ ଆର୍‌ ବିରଦେ ସାକି ଦେଉଁକ୍‌ କୟ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ସେତାକ୍‌ ସଃଇନ୍‌ମଃନ୍ ଆଦେସ୍‌ ହାୟ୍‌ଲା ହଃର୍କାରେ ପାଉଲ୍‌କେ ଦଃରି ରାତି ବଃଳ୍‌ ଆନ୍ତିପାତ୍ରିକେ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ଆର୍‌କ ଦିନ୍ ସଃଇନ୍‌ମଃନ୍‌ ଗଃଳା ଚଃଗୁମଃନ୍‌କେ ତାର୍‌ ସଃଙ୍ଗ୍ ଜଃଉଁକେ ଚାଡ୍‌ଲାୟ୍‌ ଆର୍‌ ଗଃଳେ ବାଉଳି ଗଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ହଃଚେ ଗଳାଚଃଗୁମଃନ୍ କାଇସରିଆକେ ଆସି ସାସନ୍‌କଃର୍ତାକେ ଚିଟି ଦିଲାୟ୍‌ ଆର୍‌ ପାଉଲ୍‌କେ ହେଁ ତାର୍‌ ଆତେ ସଃହ୍ରି ଦିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ସେ ଚିଟି ହଳ୍‌ଲା ହଃଚେ ସେ କୁୟ୍‌ ରାଇଜାର୍‌ ଲକ୍‌ ବଃଲି ହଃଚାର୍ଲା, ଆରେକ୍‌ ସେ ଜେ କିଲିକିଆର୍‌ ଲକ୍‌ ଇରି ଜାଣ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ଆର୍‌ ସେ କୟ୍‌ଲା, “ତର୍‌ ଦଃସ୍‌ ଦଃରୁମଃନ୍ ଆୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ ତର୍‌ କଃତା ସୁଣିନ୍ଦ୍‌” ଆର୍‌ ସେ ହେରଦାର୍‌ କୁଆଳ୍‌ ତଃୟ୍‌ଁ ତାକେଜଃୟ୍‌ଲେ ଡାହୁକେ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ହାଁଚ୍ ଦିନ୍ ହଃଚେ ହନନିଅ ମୁଳ୍‌ ଜାଜକ୍‌ ପାରାଚିନ୍ ମଃନ୍ ଆର୍‌ ତର୍ତୁଲ୍‌ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ଅକିଲ୍‌ ସଃଙ୍ଗ୍ କାଇସରିଆ ଆୟ୍‌ଲାୟ୍‌ ଆର୍‌ ସେମଃନ୍ ପାଉଲାର୍‌ ବିରଦେ ରଃଜାର୍‌ ତଃୟ୍‌ ଦଃସ୍‌ ଆଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ପାଉଲ୍‌କେ କୁଦ୍‌ଲାକ୍‌ ତର୍ତୁଲ୍‌ ତାକେ ଦସ୍‌ଦଃରି କଃଉଁକେ ଦଃର୍ଲା, “ଏ ପେଲିକ୍‌ସ୍ ତର୍‌ ସାସନ୍‌ ତଃୟ୍‌ ହୁଣି ଅଃମିମଃନ୍‌ ଜେ ସୁସ୍ତାୟ୍‌ ଆଚୁ ଆରେକ୍‌ ତର୍‌ ରାଜ୍‌ କଃର୍ତା ବଃଳ୍‌ ଇ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଅଃମାର୍‌ ଦଃଳେ ନିକ ଉହ୍‌କାର୍‌ ମଃନ୍ ଅଃଉଁଲି । ");
INSERT INTO bdv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ଇରି ଅଃମି ସଃବୁ ବଃଳ୍‌ ଆର୍‌ ସଃବୁ ଟାଣେ ହୁରାହୁରି ମାଇନ୍‌ କଃରି ମାନୁଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ମଃତର୍‌ ମୁୟ୍‌ଁ ଜଃନ୍‌କଃରି ତକ୍‌ ଅଃଦିକ୍‌ ବେଳ୍‌ ହଃତେକ୍‌ କଃଉଁକେ ମଃନ୍ ନଃକେରି, ଇତାର୍‌ ଗିନେ ଅଃଳକ୍‌ କଃତା କଃଉଁଲେ, ଦଃର୍ମ୍‌କଃରି ସୁଣୁକ୍‌ ଗଃଉଆରି କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ଅଃମିମଃନ୍‌ ଇ ଲକ୍‌କେ ବଃଡେ କୁର୍ଲିଆ ବଃଲି ଜାଣୁଲୁ, ଜଃଗତାର୍‌ ସଃବୁ ଟାଣେ ସଃବୁ ଜିଉଦିମଃନାର୍‌ ବିତ୍ରେ କୁର୍ଲିଆର୍‌ ବଂସାର୍‌ ଲକ୍‌ ଆର୍‌ ନାଜରିତ୍‌ ଦଃଳାର୍‌ ଗଟେକ୍‌ ବଃଡ୍ ମୁଳିକା ବଃଲି ଜାଣି ଆଚୁ । ");
INSERT INTO bdv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ଆରେକ୍‌ ହେଁ ଏ ମନ୍ଦିର୍‌ ବିଟାଳ୍‌ କଃରୁକେ ମୁଳ୍ୟାଉତି ରିଲା, ମଃତର୍‌ ଅଃମିମଃନ୍‌ ଆକ୍‌ ଦଃର୍ଲୁ । ");
INSERT INTO bdv_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ମଃତର୍‌ ସଃଇନାର୍‌ ମୁଳିକା ଲୁସିଆ ଆସି ବଃଳ୍‌ମାଡ୍ କଃରି ଅଃମାର୍‌ ତଃୟ୍‌ହୁଣି ଚାଡାୟ୍‌ ନିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଆର୍‌ ଇତାର୍‌ ଦଃସ୍‌ ଦଃରୁ ମଃନ୍‌କେ ତର୍‌ ମୁଏଁ ଟିଆ ଅଃଉଁକେ କୟ୍‌ଲା, ଇ ସଃବୁ ବିସୟେ ଅଃମିମଃନ୍‌ ଇତାର୍‌ ବିରଦେ ଦଃସ୍‌ ଦଃରୁଲୁ, ତୁୟ୍‌ ନିଜେ ଆକ୍‌ ହଃଚାର୍‌ଲେକ୍‌ ସେ ସଃବୁ ଜାଣୁ ହାର୍ସି ।” ");
INSERT INTO bdv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ଜିଉଦିମଃନ୍ ହେଁ ଇ ଦସ୍‌ ଦେତାର୍‌ ସଃତ୍‌ ବଃଲି କଃଉଁଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ସେତାକ୍‌ ଗନର୍‌ କଃତା କଃଉଁକେ ପାଉଲ୍‌କେ ଆତ୍‌ସଃଗ୍ୟା କଃଲାକ୍‌, ସେ କୟ୍‌ଲା, ତୁୟ୍‌ ବୁତେକ୍‌ ବଃର୍ସ୍‌ ଅୟ୍‌ଲି ଇ ଜାତିର୍‌ ଲକ୍‌ମଃନାର୍‌ ବିଚାର୍‌ କଃରୁଲିସ୍‌ ବଃଲି ମୁୟ୍‌ଁ ଜାଣି ଆଚି, ସେତାକ୍‌ ମୁୟ୍‌ଁ ସାସ୍‌ ଦଃରି ମର୍‌ କଃତା କଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ବାରଦିନ୍‌ ହୁଣି ଅଃଦିକ୍‌ ନାୟ୍‌ ମୁୟ୍‌ଁ ସେବା କଃରୁକେ ଜିରୁସାଲମ୍‌ ମନ୍ଦିରେ ଜାୟ୍‌ରିଲେ, ଇରି ତୁୟ୍‌ ହଃଚାରି ଜାଣୁ ହାର୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ଆର୍‌ ଇମଃନ୍‌ ମନ୍ଦିରେ କି ପାର୍ତ୍‌ନା ଗଃରେ କି ଗଃଳେ ମକେ କାର୍‌ ସଃଙ୍ଗ୍ ଗଃଣ୍ଡ୍‌ଗଳ୍‌ କଃର୍ତାର୍‌ କି ଲକ୍‌ମଃନ୍‌କେ ଉସ୍‌କାଉତାର୍‌ ନଃଦେକ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ଆରେକ୍‌ ଅଃବେ ଇମଃନ୍‌ ମର୍‌ ବିରଦେ ଜୁୟ୍‌ସଃବୁ ଦଃସ୍‌ ଦଃରି ଆଚ୍‌ତି ଇ ସଃବୁ ବିସୟେ ତର୍‌ ତଃୟ୍‌ କାୟ୍‌ ସାକି ଦେଉଁ ନଃହାର୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ମଃତର୍‌ ଇମଃନ୍‌ ଜାକେ ଗଟେକ୍‌ ମିଚ୍ ଦସି ବଃଲି କଃଉଁଲାୟ୍‌ ମୁୟ୍‌ଁ ସେ ଦଃର୍ମ୍‌ ହଃର୍କାରେ ଅଃମାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ଇସ୍ୱରାର୍‌ ହୁଜା କଃରୁଲେ, ଜାୟ୍‌ ଜାୟ୍‌ରି ବିଦି ହଃର୍କାରେ ଆର୍‌ ଜାୟ୍‌ ଜାୟ୍‌ରି ବାବ୍‌ବାଦି ସାସ୍ତରେ ଲେକା ଆଚେ, ସେରି ସଃବୁ ମୁୟ୍‌ଁ ବିସ୍ୱାସ୍‌ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ଆରେକ୍‌ ଦଃର୍ମି ଆର୍‌ ହାହିମଃନ୍ ଉଟ୍‌ତି ବଃଲି ଜାୟ୍‌ରି ଇମଃନ୍‌ ନିଜେ ଜାଣୁଲାୟ୍‌, ମୁୟ୍‌ଁ ହେଁ ଇସ୍ୱର୍‌ ତଃୟ୍‌ ସେନ୍‌କାର୍‌ ବଃର୍ସା କଃରି ଆଚି ବଃଲି ତର୍‌ ତଃୟ୍‌ ମାନୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ଁ ହେଁ ସଃବୁ ବଃଳ୍‌ ଇସ୍ୱର୍‌ ଆର୍‌ ମାନାୟ୍‌ ତଃୟ୍‌ ନିର୍ଦସି ମଃନେ ରେଉଁକ୍‌ ଜଃତୁନ୍ କଃରୁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ବୁତେକ୍‌ ବଃର୍ସ୍‌ କାଳ୍‌ ମୁୟ୍‌ଁ ଜିରୁସାଲମ୍‌ ହୁଣି ଦୁରିକ୍‌ ରିଲା ହଃଚେ ମର୍‌ ନିଜାର୍‌ ଲକ୍‌ମଃନାର୍‌ ଗିନେ ଦାନ୍‌ ଦେଉଁକ୍‌ ଆର୍‌ ହୁଜା କଃରୁକେ ଜିରୁସାଲମେ ଜାୟ୍‌ରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ସଃଡେବଃଳ୍‌ ଇମଃନ୍‌ ମକ୍‌ ମନ୍ଦିରେ ସୁଚି ଅୟ୍‌ରିଲାର୍‌ ଦଃକ୍‌ଲାୟ୍‌ । ମୁୟ୍‌ଁ କୁୟ୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ କି କୁୟ୍‌ କୁର୍ଲିଆ ମଃନାର୍‌ ତଃୟ୍‌ ମିସି ନଃରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ମଃତର୍‌ ଆସିଆର୍‌ କଃତେକ୍‌ ଜିଉଦିମଃନ୍ ରିଲାୟ୍‌ । ଜଦି ସେମଃନାର୍‌ ମର୍‌ ବିରଦେ କାୟ୍‌ କଃତା ରିଲେକ୍‌ ତଃବେ ତର୍‌ ଚଃମେ ସେମଃନ୍ ଆସି କାୟ୍‌ ଦଃସ୍‌ ରିଲେକ୍‌ ଜାଣାଉତାର୍‌ ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ଆରେକ୍‌ ମୁୟ୍‌ଁ ଜଦି ଅଃନ୍ୟାୟ୍‌ କଃରିଆଚି ବେରାଣେ ଟିଆ ଅୟ୍‌ ଆଚି ସେରି ଜିଉଦି ଲକ୍‌ମଃନ୍ କଃଉଅତ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ସେ ଗଟେକ୍‌ କଃତା ଚାଡି ବେରାଣ୍ ମଃଣ୍ଡାୟ୍‌ ଟିଆ ଅୟ୍‌ଲା ବଃଳ୍‌ ମୁୟ୍‌ଁ ଅଃଟୁଆ ବାବେ କୟ୍‌ରିଲେ, ମଲାଲକ୍‌ମଃନ୍‌ ଉଟ୍‌ତି ବଃଲି ମୁୟ୍‌ଁ ବିସ୍ୱାସ୍‌ କଃରୁଲାକ୍‌ ଆଜି ତୁମିମଃନାର୍‌ ତଃୟ୍‌ ବିଚାର୍‌ କଃରାୟ୍‌ ଅଃଉଁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ମଃତର୍‌ ପେଲିକ୍‌ସ୍ ସେ ବାଟ୍‌ ବିସୟେ କଃତେକ୍‌ ଜାଣି ରିଲାକ୍‌ ବିଚାର୍‌ ବଃନ୍ଦ୍‌ କଃରି କଃଉଁକେ “ଗଟେକ୍‌ ଆଜାର୍‌ ସଃଇନାର୍‌ ମୁଳ୍‌ ସଃଇନ୍ ଲୁସିଆ ଆୟ୍‌ଲେକ୍‌ ମୁୟ୍‌ଁ ତର୍‌ କଃତା ଚିଡାଇନ୍ଦ୍ ବଃଲି କୟ୍‌ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ଆରେକ୍‌ ସେ ସଃଇନ୍‌ ଅଃଦିକାରିକ୍‌ ତାର୍‌ କାୟ୍‌ ନିଜାର୍‌ ଲକ୍‌ ତାର୍‌ ଜଃତୁନ୍ କଃରୁକେ ନାୟ୍‌ ନଃବେଲୁକ୍‌ ଆର୍‌ ତାକେ କଃୟ୍‌ଦି ହର୍‌ ବଚାଉଁକ୍‌ ଆର୍‌ ନିକ କଃରି ଦଃକୁକ୍‌ କୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","କଃତିଦିନ୍‌ ହଃଚେ ପେଲିକ୍‌ସ୍ ଦ୍ରୁସିଲା ନାଉଁଆର୍‌ ଅଃହ୍‌ଣାର୍‌ ଜିଉଦି ମାୟ୍‌ଜି ସଃଙ୍ଗ୍ ଆସି ପାଉଲ୍‌କେ କୁଦାୟ୍‌ କ୍ରିସ୍ଟ ଜିସୁର୍‌ ତଃୟ୍‌ ବିସ୍ୱାସ୍‌ କଃତା ତାର୍‌ ତଃୟ୍‌ ହୁଣି ସୁଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ମଃତର୍‌ ସେ ଦଃର୍ମି ଆର୍‌ ନିଜ୍‌କେ ମାପ୍ରୁ ତଃୟ୍‌ ସଃହ୍ରି ଅୟ୍‌ କଃରାବ୍‌ କାମ୍‌ ଚାଡ୍‌ତାର୍‌, ବିସ୍ୱାସେ ତିର୍‌ ଅୟ୍‌ରେତାର୍‌ ଆର୍‌ ଆସୁଲା ମାପ୍ରୁର୍‌ ବିଚାର୍‌ କଃର୍ତାର୍‌ କଃଉତା ବଃଳ୍‌ ପେଲିକ୍‌ସ୍ ଡିରି ଜାୟ୍‌ କୟ୍‌ଲା, “ଅଃବେ ତୁୟ୍‌ ଜାଆ, ସୁବିଦା ଅୟ୍‌ଲେକ୍‌ ଆରେକ୍‌ ତକ୍‌ କୁଦାୟ୍‌ନ୍ଦ୍ ।” ");
INSERT INTO bdv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ଆରେକ୍‌ ହେଁ ପାଉଲ୍‌ ତାକେ ଟଃକା ଦଃୟ୍‌ଦ୍‌ ବଃଲି ପେଲିକ୍‌ସ୍ ଆସା କଃରି ତର୍‌କେ ତର୍‌ ତାକେ କୁଦି ତାର୍‌ ସଃଙ୍ଗ୍ କଃତା ଅଃଉତି ରିଲା । ");
INSERT INTO bdv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ମଃତର୍‌ ଦୁୟ୍‌ ବଃର୍ସ୍‌ ହୁର୍ନ୍‌ ଅୟ୍‌ଲା ହଃଚେ ପର୍କିୟ ପେସ୍ଟ ପେଲିକ୍‌ସ୍ ହଃଦେ ବଃସ୍‌ଲା, ଆର୍‌ ପେଲିକ୍‌ସ୍ ଜିଉଦିମଃନାର୍‌ ମଃନ୍‌କେ ଜଃଉଁକେ ମଃନ୍‌କଃରି ପାଉଲ୍‌କେ କଃୟ୍‌ଦି କଃରି ଚାଡି ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ସେତାକ୍‌ ପେସ୍ଟ ଅଃଦିକାରି ହଃଦ୍‌ ହାୟ୍‌ ତିନିଦିନ୍ ହଃଚେ କାଇସରିଆ ହୁଣି ଜିରୁସାଲମେ ଗଃଲା । ");
INSERT INTO bdv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ଆର୍‌ ସେତି ବଃଡ୍ ଜାଜକ୍‌ମଃନ୍ ଆର୍‌ ଜିଉଦିମଃନ୍ ତାର୍‌ ତଃୟ୍‌ ଆରେକ୍‌ ପାଉଲ୍‌ ବିରଦେ ଗଃଉଆରି କଃଲାୟ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ଆର୍‌ ସେ ଜଃନ୍‌କଃରି “ପାଉଲ୍‌କେ ଜିରୁସାଲମେ କୁଦାୟ୍‌ ହଃଟାୟ୍‌ଦ୍‌, ଇତାର୍‌ ଗିନେ ତାକେ ଗଃଉଆରି କଃଲାୟ୍‌; ଆର୍‌ ସେମଃନ୍ ବାଟେ ମାରୁକ୍‌ ଜାଗୁକେ ଦଃର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ସେତାକ୍‌ ପେସ୍ଟ କୟ୍‌ଲା, ପାଉଲ୍‌ କାଇସରିଆ ତଃୟ୍‌ କଃୟ୍‌ଦି ଅୟ୍‌ଆଚେ, ଆର୍‌ ମୁୟ୍‌ଁ ହେଁ ବେଗି ସେତି ଜଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ତଃବେ ତୁମିମଃନାର୍‌ ବିତ୍ରେ ମୁଳିକାମଃନ୍ ମଃର୍‌ ସଃଙ୍ଗ୍ କାଇସରିଆ ଆସା ସେତି ଜାୟ୍‌ ପାଉଲାର୍‌ ବିରଦେ କାୟ୍‌ ଦଃସ୍‌ ରିଲେକ୍‌ ସେତି କଃଉଆ ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ହଃଚେ ପେସ୍ଟ୍‌ ସେମଃନାର୍‌ ସଃଙ୍ଗ୍ ଆଟ୍‌ ଦଃସ୍‌ ଦିନ୍ ହୁଣି ଅଃଦିକ୍‌ ନଃରଃୟ୍‌ କାଇସରିଆକେ ବାଉଳି ଗଃଲା ଆର୍‌ ଆର୍‌କ ଦିନ୍ ବେରାଣେ ବଃସି ବିଚାର୍‌ କଃରୁକେ ପାଉଲ୍‌କେ ଆଣାୟ୍‌ଲା । ");
INSERT INTO bdv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ପାଉଲ୍‌ ଆୟ୍‌ଲାକ୍‌ ଜିରୁସାଲମାର୍‌ ଜିଉଦିମଃନ୍ ଆସି ତାର୍‌ ଚାରିବେଳ୍‌ତ୍ ଟିଆ ଅୟ୍‌ ତାର୍‌ ବିରଦେ ଅଃଦିକ୍‌ ଦସ୍‌ ଲାଦୁକ୍‌ ଦଃର୍ଲାୟ୍‌, ମଃତର୍‌ ସେରି ସଃବୁ ସେମଃନ୍ ସାକି ଦେଉଁକ୍‌ ନଃହାର୍ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ସେତାକ୍‌ ପାଉଲ୍‌ ତାର୍‌ ନିଜାର୍‌ ସାକି ଦଃୟ୍‌ କୟ୍‌ଲା, “ଜିଉଦିମଃନାର୍‌ ବିଦି ବିରଦେ କି ମନ୍ଦିର୍‌ ବିରଦେ କି କାଇସରାର୍‌ ବିରଦେ ମୁୟ୍‌ଁ କାୟ୍‌ ଦଃସ୍‌ ନଃକେରି ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ମଃତର ପେସ୍ଟ ଜିଉଦିମଃନ୍‌କେ ବଃଲ୍‌ ବଃଲାୟ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃରି ପାଉଲ୍‌କେ ଗଃଉଆରି କଃଲା, “ତୁୟ୍‌ କାୟ୍‌ ଜିରୁସାଲମ୍‌କେ ଜାୟ୍‌ ସେତି ଅଃମାର୍‌ ଚଃମେ ବିଚାର୍‌ କଃରାୟ୍‌ ଅଃଉଁକେ ମଃନ୍ କଃରୁଲିସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ମଃତର୍‌ ପାଉଲ୍‌ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ କାଇସରାର୍‌ ବେରାଣ୍‌ ମେଣ୍ଡା ଚଃମେ ଟିଆ ଅୟ୍‌ ଆଚି, ସେଟାଣେ ମର୍‌ ବିଚାର୍‌ ଅଃଉଅ, ମୁୟ୍‌ଁ ଜିଉଦିମଃନାର୍‌ ଗିନେ କାୟ୍‌ ଅଃନ୍ୟାୟ୍‌ ନଃକେରି, ତୁୟ୍‌ ହେଁ ସେରି ନିକ କଃରି ଜାଣି ଆଚ୍‌ସି । ");
INSERT INTO bdv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ତଃବେ ଜଦି ମୁୟ୍‌ଁ ଅଃନ୍ୟାୟ୍‌ କଃରି ରଃୟ୍‌ନ୍ଦ୍, ଆର୍‌ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତା କାମ୍‌ କଃରି ରଃୟ୍‌ନ୍ଦ୍, ତଃବେ ମଃର୍ନ୍‌ ଡଃଣ୍ଡ୍‌ ହାଉଁକ୍‌ ନାୟ୍‌ ନଃବେଲି, ମଃତର୍‌ ମର୍‌ ବିରଦେ ଜାୟ୍‌ରି ସଃବୁ କଃଉଁଲାୟ୍‌, ଇ ସଃବୁ ବିତ୍ରେ ଜଦି ହଃଦେକ୍‌ ସଃତ୍‌ ନାୟ୍‌, ତଃବେ କେହେଁ ସେମଃନାର୍‌ ଆତେ ଚାଡୁକ୍‌ ନାହାରେ, ମୁୟ୍‌ଁ କାଇସର୍‌ ମୁଏଁ ବିଚାର୍‌ କଃରାୟ୍‌ ଅଃଉଁକେ ଗଃଉଆରି କଃରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ସେତାକ୍‌ ପେସ୍ଟ ମଃତ୍ରିମଃନାର୍‌ ସଃଙ୍ଗ୍ କଃତା ଅୟ୍‌ କୟ୍‌ଲା, “ତୁୟ୍‌ କାଇସର୍‌ ଚଃମେ ବିଚାର୍‌ ଅଃଉଁକେ ଗଃଉଆରି କଃରି ଆଚ୍‌ସି, ତୁୟ୍‌ କାଇସର୍‌ ଚଃମେ ଜାସି ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","କଃତି ଦିନ୍ ଗଃଲା ହଃଚେ ରଃଜା ଆଗ୍ରିପା ଆର୍‌ ବର୍ନକି କାଇସରିଆକେ ଆସି ପେସ୍ଟକେ ବେଟ୍‌ ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ସେମଃନ୍ ବୁତେକ୍‌ ଦିନ୍ ସେତି ରିଲାକ୍‌ ରଃଜାର୍‌ ଚଃମେ ପେସ୍ଟ ପାଉଲାର୍‌ କଃତା ଜାଣାୟ୍‌ କୟ୍‌ଲା, “ପେଲିକ୍‌ସ୍ ଗଟେକ୍‌ ଲକ୍‌କେ କଃୟ୍‌ଦି କଃରି ଚାଡି ଗଃଲା ଆଚେ । ");
INSERT INTO bdv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ମୁୟ୍‌ଁ ଜିରୁସାଲମେ ରିଲା ବଃଳ୍‌ ଜିଉଦିମଃନାର୍‌ ବଃଡ୍ ଜାଜକ୍‌ ଆର୍‌ ପାରାଚିନ୍‌ମଃନ୍ ମର୍‌ ତଃୟ୍‌ କୟ୍‌ କଃରି ତାର୍‌ ବିରଦେ ଡଃଣ୍ଡ୍‌ ଦେଉଁକ୍‌ ଗଃଉଆରି କଃର୍ତି ରିଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ମୁକାମୁକି ସେମଃନ୍‌କେ କୟ୍‌ଲେ, ତୁମି ଆର୍‌ ପାଉଲ୍‌ ମୁଁଆମୁୟ୍‌ଁ ନଃଉତା ହଃତେକ୍‌ ଆର୍‌ ଜୁୟ୍‌ ଲକ୍‌ ଜାକେ ଦଃସ୍‌ ଲାଦେଦ୍‌ ସେଲକ୍‌ ତାର୍‌ ନିଜାର୍‌ ସାକି ଦେଉଁକ୍‌ ସୁବିଦା ନଃହାଉତା ହଃତେକ୍‌ ତାକେ ଦସି କଃର୍ତା ଅଃମାର୍‌ ରମିୟମଃନାର୍‌ ବିଦି ନାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ଇତାକ୍‌ ସେମଃନ୍ ମର୍‌ ସଃଙ୍ଗ୍ ଇଟାଣେ ଆୟ୍‌ଲାକ୍‌ ମୁୟ୍‌ଁ ବେଳ୍‌ ନଃକେରି ସଃଙ୍ଗେ ସଃଙ୍ଗେ ଆର୍‌କ ଦିନ୍ ବେରାଣେ ବଃସି ସେ ଲକ୍‌କେ ଆଣୁକେ କୟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ଦଃସ୍‌ ଦଃରୁମଃନ୍ ଟିଆ ଅୟ୍‌ ମୁୟ୍‌ଁ ଜଃନ୍‌କାର୍‌ ଦଃସାର୍‌ କଃତା ଜାଗ୍‌ତି ରିଲେ, ସେନ୍‌କାର୍‌ କାୟ୍‌ ଦଃସ୍‌ ତାର୍‌ ଗିନେ ନାଣ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ମଃତର୍‌ ସେମଃନାର୍‌ ତାକାର୍‌ ଦଃର୍ମ୍‌ ଆରେକ୍‌ ଜିରୁସାଲମେ ଜିସୁ ନାଉଁଆର୍‌ ଗଟେକ୍‌ ମଃଲା ଲକ୍‌ ଜାକେ ପାଉଲ୍‌ ଜିବନ୍ ଆଚେ ବଃଲି କଃଉତି ରିଲା ସେ ସଃବୁ କଃତା ତାର୍‌ ବିରଦେ ସେମଃନାର୍‌ ବିତ୍ରେ କଃତା ଦଃରାଦଃରି ଅୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ଇସଃବୁ କଃତା ଆରେକ୍‌ ନିକ କଃରି ଜାଣୁକେ କାୟ୍‌କଃରୁକ୍‌ ଅୟ୍‌ଦ୍‌ ତିର୍‌ କଃରୁ ନଃହାର୍ଲେ, ଆର୍‌ ପାଉଲ୍‌ ଜିରୁସାଲମ୍‌ ଜାୟ୍‌ ଇ କଃତାକ୍‌ ବିଚାର୍‌ କଃରାୟ୍‌ ଅଃଉଁକେ ଇଚା କି ନାୟ୍‌ ବଃଲି ହଃଚାର୍ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ମଃତର୍‌ ପାଉଲ୍‌ କାଇସର୍‌ ଚଃମେ ବିଚାର୍‌ ହାଉଁକେ ଗଃଉଆରି କଃଲା, ତଃବେ ମୁୟ୍‌ଁ କାଇସର୍‌ ହାକ୍‌ ନଃହେଟାଉତା ହଃତେକ୍‌ ବାନ୍ଦି ରେଉଁକ୍‌ କୟ୍‌ଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ସେତାକ୍‌ ଆଗ୍ରିପା ପେସ୍ଟକେ କୟ୍‌ଲା, “ମୁୟ୍‌ଁ ନିଜେ ସେଲକାର୍‌ କଃତା ସୁଣୁକ୍‌ ମଃନ୍ କଃରୁଲେ ।” “ସେ କୟ୍‌ଲା କାଲି ତୁୟ୍‌ ତାର୍‌ କଃତା ସୁଣ୍‌ସି ।” ");
INSERT INTO bdv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ତଃବେ ଆର୍‌କ ଦିନ୍ ଆଗ୍ରିପା ଆର୍‌ ବର୍ନକି ବଃଡେ ଦଃଳ୍‌ବଃଳ୍‌ ସଃଙ୍ଗ୍ ଆସି ବଃଡ୍‌ ବଃଡ୍‌ ହାଁଚ୍ କଳି ସଃଇନ୍ ମଃନାର୍‌ ଉହ୍ରେ ବଃଡ୍‌ସଃଇନ୍ ଆର୍‌ ଗଃଳାର୍‌ ମୁଳିକା ସଃଙ୍ଗ୍ ବିଚାର୍‌ କଃରୁକେ ବଃଙ୍ଗ୍‌ଲାୟ୍‌ ହୁରି ବଃସ୍‌ଲାକେ, ପେସ୍ଟର୍‌ କଃତା ହଃର୍କାରେ ପାଉଲ୍‌କେ ଆଣା ଅୟ୍‌ଲି । ");
INSERT INTO bdv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ସେତାକ୍‌ ପେସ୍ଟ କୟ୍‌ଲା, “ଏ ମଃହାରଃଜା ଆଗ୍ରିପା ଆର୍‌ ଅଃମାର୍‌ ସଃଙ୍ଗ୍ ଇଟାଣେ ରେତା ବଃଡ୍‌ ମାନାୟ୍‌ମଃନ୍ ତୁମିମଃନ୍ ଇ ଲକ୍‌କେ ଦଃକୁଲାସ୍‌, ଆର୍‌ ବିରଦେ ଜିରୁସାଲମେ ଆର୍‌ ଇଟାଣେ ହେଁ ଜିଉଦି ଲକ୍‌ମଃନ୍ ଅଃମାର୍‌ ତଃୟ୍‌ ଗଃଉଆରି କଃରି ଆଚ୍‌ତି ତାର୍‌ ଆର୍‌ ଜିବନ୍‌ ରେତାର୍‌ ଜୟ୍‌ଗ୍‌ ନାୟ୍‌ ବଃଲି ସଃବୁଲକ୍‌ ଉରାଟୁ କଃଲାୟ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ମଃତର୍‌ ଇ ଲକ୍‌ ମଃର୍ନ୍‌ ଦଃଣ୍ଡାର୍‌ କାୟ୍‌ କାମ୍‌ ନଃକେରେ ବଃଲି ମୁୟ୍‌ଁ ବୁଜ୍‌ଲେ, ଆର୍‌ ହଃଚେ ନିଜେ ଚଃକର୍‌ବତିର୍‌ ଚଃମେ ବିଚାର୍‌ କଃରା ଅଃଉଁକେ ଗଃଉଆରି କଃଲାକ୍‌ ମୁୟ୍‌ଁ ତାକେ ସେତି ହଃଟାଉଁକ୍‌ ତିର୍‌ କଃଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ମଃତର୍‌ ମାପ୍ରୁ ହାକ୍‌ ଲେକୁକ୍‌ ମର୍‌ କାୟ୍‌ କଃତା ନାୟ୍‌, ଇତାର୍‌ ଗିନେ ବିଚାର୍‌ କଃରି ମୁୟ୍‌ଁ ଜଃନ୍‌କଃରି କାୟ୍‌ରି ଲେକୁକ୍‌ ହାଉଁ ହାରି ଇତାକ୍‌ ତାକେ ଏ ରଃଜା ଆଗ୍ରିପା ତର୍‌ ତଃୟ୍‌ ଆଣି ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","କାୟ୍‌ତାକ୍‌ ବଃଲେକ୍‌ କଃୟ୍‌ଦିକେ ହଃଟାଉତା ବଃଳ୍‌ ତାର୍‌ ବିରଦେ ରିଲା ଦଃସ୍‌ ମଃନ୍ ନଃଦେକାୟ୍‌ଲେକ୍‌ ନିକ ନାୟ୍‌ ବଃଲି ମୁୟ୍‌ଁ ଜାଣୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ସେତାକ୍‌ ଆଗ୍ରିପା ପାଉଲ୍‌କେ କୟ୍‌ଲା, “ତକ୍‌ ନିଜାର୍‌ ବିସୟେ କଃଉଁକେ ସୁବିଦା ଦିଆ ଅୟ୍‌ଲି, ସଃଡେବଃଳ୍‌ ପାଉଲ୍‌ ଆତ୍‌ ସାଗ୍ୟାକଃରି ସେ ନିଜାର୍‌ କଃତା କଃଉଁକେ ଦଃର୍ଲା ।” ");
INSERT INTO bdv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ଏ ମଃହାରଃଜା ଆଗ୍ରିପା ଜିଉଦିମଃନ୍‌ ମର୍‌ ବିରଦେ ଜୁୟ୍‌ ସଃବୁ ମିଚ୍ ଦସ୍‌ମଃନ୍ କଃଉଁଲାୟ୍‌, ସେତାକ୍‌ ମୁୟ୍‌ଁ ଜେ ତର୍‌ ତଃୟ୍‌ ମର୍‌ ନିଜାର୍‌ ସାକି ଦେଉଁକ୍‌ ସୁବିଦା ହାୟ୍‌ ଆଚି ଇତାର୍‌ ଗିନେ ମୁୟ୍‌ଁ ନିଜ୍‌କେ ବାୟ୍‌ଗ୍‌ ମଃନେକଃରୁଲେ, ");
INSERT INTO bdv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ତୁୟ୍‌ ଜିଉଦିମଃନାର୍‌ ସଃବୁ ରିତିବିଦି ଆର୍‌ କଃତା ସଃବୁ ନିକକଃରି ଜାଣ୍‌ସି, ଇତାକ୍‌ ମଃନ୍‌ ଦଃୟ୍‌ ମର୍‌ କଃତା ସୁଣୁକ୍‌ ତକେ ଗଃଉଆରି କଃରୁଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ହିଲାବଃଳ୍‌ ହୁଣି ନିଜାର୍‌ ଲକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ଆର୍‌ ଜିରୁସାଲମେ ମର୍‌ ଜିବନ୍ କାଟ୍‌ତାର୍‌ ଜିଉଦିମଃନ୍‌ ସଃବୁ ଜାଣିଆଚ୍‌ତି । ");
INSERT INTO bdv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ସେମଃନ୍ ହଃର୍ତୁ ହୁଣି ମକ୍‌ ଜାଣି ଆଚ୍‌ତି, ଜଦି ମଃନ୍‌କଃର୍ତି ତଃବେ ସାକି ଦେଉଁକେ ହାର୍ତି ଜେ ମୁୟ୍‌ଁ ଅଃମାର୍‌ ଦଃର୍ମାର୍‌ ସଃବ୍‌କେ ଜିଣ୍‌ତେ କଃସ୍ଟ୍‌ ମାନିକଃରି ସେ ହଃର୍କାରେ ମୁୟ୍‌ଁ ପାରୁସି ଅୟ୍‌ ଜିବନ୍ କାଟ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ଅଃମିମଃନାର୍‌ ଦାଦିବାବୁମଃନାର୍‌ ଟାଣେ ଇସ୍ୱର୍‌ ଜୁୟ୍‌ ସଃୟ୍‌ତ୍‌ କଃରିରିଲା ସେ ସଃୟ୍‌ତାର୍‌ ସଃତ୍‌କଃରି ମୁୟ୍‌ଁ ବିଚାର୍‌ ହାଉଁକେ ମୁୟ୍‌ଁ ଟିଆ ଅୟ୍‌ ଆଚି । ");
INSERT INTO bdv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ଅଃମାର୍‌ ବାର ଗସ୍ଟି ସଃୟ୍‌ତାର୍‌ ହଃଳ୍‌ ହାଉଁକେ ଆସା ବଃର୍ସା କଃରି ଦିନ୍ ରାତି ଏକ୍‌ମଃନେ ଇସ୍ୱରାର୍‌ ହୁଜା କଃରୁଲାୟ୍‌, ଏ ମଃହାରଃଜା ସେ ସଃୟ୍‌ତାର୍‌ ଗିନେ ମୁୟ୍‌ଁ ଜିଉଦିମଃନାର୍‌ ତଃୟ୍‌ ବିଚାର୍‌ କଃରାୟ୍‌ ଅଃଉଁଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ଇସ୍ୱର୍‌ ଜେ ମଃଲା ଲକ୍‌କେ ଉଟାୟ୍‌ଦ୍‌ ଇରି କାୟ୍‌ତାକ୍‌ ତୁମାର୍‌ ବିଚାରେ ମିଚ୍ ବଃଲି ମଃନେ ବାବୁଲାସ୍‌ ?” ");
INSERT INTO bdv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ନାଜରିତାର୍‌ ଜିସୁର୍‌ ନାଉଁଏ ମର୍‌ ଗାଦେକ୍‌ କାମ୍‌ ତାର୍‌ ନାଉଁ ବିରଦେ କଃରୁକେ ଆଚେ, ଇରି ମୁୟ୍‌ଁ ନିଜେ ମଃନେ ବାବ୍‌ତିରିଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ଆର୍‌ ଜିରୁସାଲମେ ମୁୟ୍‌ଁ ଇତି ହେଁ କୟ୍‌ରିଲେ ବଃଡ୍‌ ଜାଜକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ ହୁଣି ଅଃଦିକାର୍‌ ହାୟ୍‌ ଇସ୍ୱରାର୍‌ ବିସ୍ୱାସିମଃନ୍‌କେ ଜଃଇଲେ ହୁରାୟ୍‌ ରିଲେ ଆର୍‌ ସେମଃନାର୍‌ ମଃର୍ନ୍‌ ଦଃଣ୍ଡ୍‌ ବଃଳ୍‌ ମୁୟ୍‌ଁ ସେମଃନାର୍‌ ଡଃଣ୍ଡ୍‌ ହାଉତା ଲକାର୍‌ ବିରଦେ ମର୍‌ ରାଜି ରିଲି । ");
INSERT INTO bdv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ଆର୍‌ ଜିଉଦିମଃନାର୍‌ ପାର୍ତ୍‌ନା ଗଃରେ ତର୍‌କେ ତର୍‌ ସେମଃନ୍‌କେ ଡଃଣ୍ଡ୍‌ ଦଃୟ୍‌ ସେମଃନ୍‌କେ ଜିସୁର୍‌ ଲିନ୍ଦା କଃରି ତାକେ ଚାଡୁକ୍‌ ବଃଳ୍‌ମାଡ୍ କଃର୍ତିରିଲେ ଆରେକ୍‌ ସେମଃନାର୍‌ ବିରଦେ ରିସା ଅୟ୍‌ ବିନ୍ ଦେସାର୍‌ ଗଃଳ୍‌ମଃନ୍‌କେ ହେଁ ଜାୟ୍‌ ସେମଃନ୍‌କେ କଃସ୍ଟ୍‌ ଦେତିରିଲେ ।” ");
INSERT INTO bdv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ଇ କାମ୍‌ କଃରୁକେ ବଃଡ୍ ଜାଜକ୍‌ମଃନାର୍‌ ତଃୟ୍‌ହୁଣି ଅଃଦିକାର୍‌ ଲେକା ଦଃରି ଦମେସକ୍‌ ଜାତା ବଃଳ୍‌, ");
INSERT INTO bdv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ଏ ମଃହାରଃଜା, ମଃୟ୍‌ଦାନ୍ ବଃଳ୍‌ ବାଟେ ଅଃଗାସେ ହୁଣି ବେଳ୍‌ ତଃୟ୍‌ହୁଣି ବଃଳେ ଉଜାଳ୍‌ ମର୍‌ ସଃଙ୍ଗେ ରିଲା ଲକ୍‌ମଃନାର୍‌ ଚାରି ବେଳ୍‌ତ୍ ଉଜାଳ୍‌ ଅଃଉତାର୍‌ ଦଃକ୍‌ଲେ । ");
INSERT INTO bdv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ଅଃମିମଃନ୍‌ ସଃବୁ ବୁୟେଁ ଅଦୁର୍ଲାକ୍‌ ମୁୟ୍‌ଁ ଏବ୍ରି ବାସାୟ୍‌ ମର୍‌ ଗିନେ ଇ କଃତା କଃଉଆ ଅୟ୍‌ଲି, ସାଉଲ୍‌, କାୟ୍‌ତାକ୍‌ ମକ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ତିତିର୍‌ ହିଲେ ବଃୟ୍‌ଲ୍‌ ଲାତ୍‌ ମାର୍‌ଲେକ୍‌ ବଃୟ୍‌ଲ୍‌କେ ଜଃନ୍‌କଃରି କଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌, ତକ୍‌ ହେଁ ସେନ୍ କଃସ୍ଟ୍‌ ଅୟ୍‌ଦ୍‌ । ");
INSERT INTO bdv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ସେତାକ୍‌ ମୁୟ୍‌ ହଃଚାର୍ଲେ, ‘ମାପ୍ରୁ ତୁୟ୍‌ କେ ?’ ସେତାକ୍‌ ମାପ୍ରୁ କୟ୍‌ଲା, ‘ଜୁୟ୍‌ ଜିସୁକେ ତୁୟ୍‌ କଃସ୍ଟ୍‌ ଦେଉଁଲିସ୍‌ ମୁୟ୍‌ଁ ସେ,’ ");
INSERT INTO bdv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ମଃତର୍‌ ଉଟ୍‌ କୁତ୍‌ମାଡି ଟିଆ ଅଃଉ, କାୟ୍‌ତାକ୍‌ବଃଲେକ୍‌ ମୁୟ୍‌ଁ ତକ୍‌ ମର୍‌ କାମ୍‌ କଃରୁକେ ଆର୍‌ ତୁୟ୍‌ ମର୍‌ ଜାୟ୍‌ଜାୟ୍‌ରି ଦଃକି ଆଚ୍‌ସି ଆରେକ୍‌ ଦଃକ୍‌ସି, ସେସଃବୁ କଃତାର୍‌ ବିନ୍ ଲକ୍‌ମଃନ୍‌କେ କଃଉଁକେ ତକ୍‌ ଦଃକାୟ୍‌ ଅୟ୍‌ ଆଚି । ");
I