﻿USE sofia;
DROP TABLE IF EXISTS sofia.bds_vpl;
CREATE TABLE bds_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bds_vpl WRITE;
INSERT INTO bds_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hiĩ na hiislaslaw gu umaiĩ gu afamaraa gosi Yeesu Kristu gwa laqwaloo da Dawdi haa da Aburahaamu dahha. ");
INSERT INTO bds_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburahaamu naa laqwali Isaaka, Isaaka naa laqwali Yakoobo, Yakoobo naa laqwali Yuuda haa hhiee kosi, ");
INSERT INTO bds_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda naa laqwali Pereesi haa Seera, iyoo dooina naa Tamaari. Pereesi naa laqwali Khesirooni, Khesirooni naa laqwali Araamu. ");
INSERT INTO bds_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamu naa laqwali Aminadaabu, Aminadaabu naa laqwali Nakhasooni, Nakhasooni naa laqwali Salimooni. ");
INSERT INTO bds_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimooni naa laqwali Boaasi daqa hadee dosii Rahaabu, Boaasi naa laqwali Obeedi daqa hadee dosii Ruuti, Obeedi naa laqwali Yeese. ");
INSERT INTO bds_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yeese naa laqwali mutemi Dawdi. Dawdi naa laqwali Solomooni daqa hadetiraa da Uriiyago. ");
INSERT INTO bds_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomooni naa laqwali Rehoboaamu, Rehoboaamu naa laqwali Abiiya, Abiiya naa laqwali Aasa. ");
INSERT INTO bds_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa naa laqwali Yehosafaati, Yehosafaati naa laqwali Yoraamu, Yoraamu naa laqwali Usiiya. ");
INSERT INTO bds_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiiya naa laqwali Yotaamu, Yotaamu naa laqwali Akhaasi, Akhaasi naa laqwali Hesekiyaa. ");
INSERT INTO bds_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiyaa naa laqwali Manaase, Manaase naa laqwali Amooni, Amooni naa laqwali Yosiiya. ");
INSERT INTO bds_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiiya naa laqwali Yekoniyaa haa hhiee kosi, qatlay hida gu hhapee da Yuuda digaa ilii looyisi yaamu gu Babiloonige. ");
INSERT INTO bds_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Qariqaaqari digaa ilii looyisi yade Babiloonige, Yekoniyaa ginaa ilii laqwali Seyalitiyeeli, Seyalitiyeeli naa laqwali Serubabeeli, ");
INSERT INTO bds_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeeli naa laqwali Abihuudi, Abihuudi naa laqwali Eliyakiimu, Eliyakiimu naa laqwali Asooro, ");
INSERT INTO bds_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asooro naa laqwali Sadooki, Sadooki naa laqwali Akiimu, Akiimu naa laqwali Elihuudi, ");
INSERT INTO bds_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihuudi naa laqwali Eleasaari, Eleasaari naa laqwali Mataani, Mataani naa laqwali Yakoobo, ");
INSERT INTO bds_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoobo naa laqwali Yoseefu, hhawata gu Mariyaa, daa laqwalidi Yeesu, doó eteedine Kristu. ");
INSERT INTO bds_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Inkoo, yaa wanta laqwaloo mibi haa cigahha tlaatleesa da laqwaloo da Aburahaamugo da mutemi Dawdi naqatloo. Kara, yaa wanta laqwaloo mibi haa cigahha tlaatleesa da laqwaloo da mutemi Dawdigo qatlay gu looyisa da Wayahuudi naqatloo Babiloonige. Kara, yaa wanta laqwaloo mibi haa cigahha tlaatleesa da qatlay Wayahuudi digaa ilii looyisi Babiloonige qatlaykaꞌa naqatloo gu Kristu. ");
INSERT INTO bds_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hiĩ na catimisu gu hiidawaraa da Yeesu Kristu. Mariyaa iyoo dosi dagaa hiidaamisi ha Yoseefu. Inkoo, inay hingaa ilii kahhiye khabiibiru, Mariyaa tay kahhada kikitoꞌoo, gi slaydi guraꞌa hari ⁄uuru gu Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoseefu, hhawata gosi, sa gimba yaa heedi gu kooma ibinaa daa tafaꞌadi, giyaa slaiyaaba muriidisa pandaa da hidage. Teesaaqay, yaa piimuudi mawaraa hadee dosi hari hhaaboo. ");
INSERT INTO bds_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Qatlay giyaa ilii ilahudeedemisiye gimbakee, yuꞌudiyaa malayika gu Taataa Iliitleemu gi iliica⁄i Yoseefu tletaage. Malayika gi kaay tuba, “Yoseefu nanku Dawdi, hhanti tlaꞌamuta khaboo Mariyaa, sa gimba guraꞌa gi konte, ginti slaydi hari ⁄uuru gu Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ina maa hiidaada naw, ugu hagurimaa ayida uma na Yeesu, sa gimba ina namaa ilabuꞌuna hida kosi tlakwaroo dooinaa.” ");
INSERT INTO bds_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gimbaki goõ yaatii ca⁄i, dama hiigaasi gimba daa kaay ha tletimiisay gu Iliitleemu Isaaya tuba, ");
INSERT INTO bds_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yuꞌudiyaa! Kikitoꞌoo slayda guraꞌa. Kara, ina laqwalida naw, inay guriayay uma na Imanueeli.” Maꞌaana da umakee na “Iliitleemu wana sliimaa haa dandiray.” ");
INSERT INTO bds_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Qatlay Yoseefu giyaa iliitlay guꞌudeego, gi yondiidi idoo sugwaa ilii ilakaay gooay ha Malayika gu Taataa Iliitleemu. Ina higi khabimi Mariyaa, girigi tosaa waaudi aya gosii. ");
INSERT INTO bds_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Teesaaqay see, ina giraa guiiba, Mariyaa yaati amoolaa hiidaadi naw. Yoseefu gurigi ayi uma gosi na Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeesu dugwaa yaamu gu Beteleheemuge laqwali gu hhapee da Yudaayage waaree, qatlay Heroode giyaa ilii mutemi. Yuꞌudiyaa! Qariqaaqari dugwaa ilii laqwali, hida gwaa somimee gimba gu tica⁄eerii yadaa ilacindoo gu rawaago, yaa khayri Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Inay gi maasiri hida tuba, “Kaano nakee, diĩ laqwali mutemi gu Wayahuudi? Dandiray haani arini tica⁄u gosi, ilacindoo gu rawaago, haani khayni magu hhaꞌaleesani pandaa dosii.” ");
INSERT INTO bds_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Qatlay mutemi Heroode giyaa ilii akhasi gimbaki, yaa khoslongoruusi hari khisla sliimaa haa hida goõ gu Yerusaleemu. ");
INSERT INTO bds_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ina gii kurunkuri hhapalooee da deni haa maarimamaa da sariyaa da diini da Wayahuudi, gigi maasi tuba, “Kristu dugu kaale hiiday?” ");
INSERT INTO bds_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Inay gugi ilaki⁄isiri tuba, “Dugumaa yaamu gu Beteleheemuge hiiday gu hhapee da Yudaayage waaree. Maꞌaana tletimiisay Miika ginaa ilii handikimi gimbaki tuba, ");
INSERT INTO bds_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘De Beteleheemu da hhapee da Yuudage waara, igi giti coko⁄iiba coko⁄o see tla⁄aã gu yaamu gu denige gu hhapee da Yuuda. Maꞌaana daqa doogaa maa hiica⁄i giyaadimiisay, gumaa deꞌema hida koi gu Israeeli.’ ” ");
INSERT INTO bds_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Teꞌesii, Heroode giyaa ilii akhasi gimbakee, ina gigi eteedi hari siiri hida hhakira gwaa somimee gimba gu tica⁄eerii, ma mai naraꞌa daqa dooinaa, qatlay loi tica⁄u giyaa iliica⁄i. ");
INSERT INTO bds_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Da hheꞌesi, gigi ya⁄abi Beteleheemuge, gi kaay tuba, “Taa⁄amida la dabiiduu kayday hari maguuma gimba gu nakee. Goo iliislaydee, sinaraa khaydee gimbakee, ana see slime magu hhaꞌaleesa kay.” ");
INSERT INTO bds_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Qariqaaqari giyaa ilii itatiisiri mutemi, hida hhakee gi waaudiri. Yuꞌudiyaa, tica⁄ukee giyaa aniri ilacindoo gu rawaage gi giyaadi pandaa dooinay, gi tosaa qadida kay rawaa gu daqatiray, daa iliiwane naw. ");
INSERT INTO bds_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Qatlay giyaa ilii aniri tica⁄ukee, gi hhaꞌaluumidiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Inay giyaa ilii guniri waꞌay gu marakeesii, yaa aniri nakee sliimaa haa iyoo dosi Mariyaa, gi keebeeimidiri haa gii gupu⁄umisiri sagaiĩ koina daqa nakeesii. Da hheꞌesi, gi gweediniri curuqeeraa koina, sugugi hadisiri sahaabu, ubaanii haa manemaane. ");
INSERT INTO bds_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iliitleemu giyaa ilakaay inay tletaage tuba, hhanti ki⁄iyay daqa mutemi Heroodege. Teesaaqay, gi ki⁄iri yaamu koinay hari amoo waka. ");
INSERT INTO bds_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Qariqaaqari, hida hhakee gwaa somimee gimba gu tica⁄eerii giyaa ilii waaudiri, malayika gu Taataa Iliitleemu yaa iliica⁄i Yoseefu tletaage, sugugi kaay tuba, “Tlayii! Oyii naw sliimaa haa iyoo dosi, lakida hhapee da Misirige. Ibiida taysi qatlaykaꞌa naqatloo sugumaa ilii kaawe, sa gimba mutemi Heroode gu slai dabiidu nakee, magu gaasi.” ");
INSERT INTO bds_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Teesaaqay, Yoseefu gii tlay, gii oyi naw sliimaa haa iyoo dosi, gi waaudiri hari amasi yade Misirige. ");
INSERT INTO bds_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Inay gi ibiidiri taysi gwaaꞌaraa da mutemi Heroode naqatloo. Gimbakee yaa teesaaqay hiica⁄i dama hiigaasi gimba daa kaay haa Taataa Iliitleemu hari amoo da tletimiisay tuba, “Nankoy hagwaa eteedi, ina yaagi waaudi Misirigo.” ");
INSERT INTO bds_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Qatlay Heroode giyaa ilii baraslayi tuba, hida hhakee gwaa somimee gimba gu tica⁄eerii guntii coriri, yaa slahhaai hari khisla. Ina gi ilafahhi sirikaarii dosi yaamu gu Beteleheemuge haa tongagu goõ gu ilaciyaa, ma cu⁄uduũ kayri yaꞌay goõ gu hhawatee gu koomee koraraa cada haa hhaã gu biraa kosii waaree. Ina yaa teesaaqay laqi, ilakhuukhuꞌusa da qatlaykira tica⁄u giyaa iliica⁄i, giyaa ilii mai daqa hida gwaa somimee gimba gu tica⁄eerii. ");
INSERT INTO bds_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Daganaa ilii buꞌudi gimbaki, daa kaay hari amoo da tletimiisay Yeremiyaa tuba, ");
INSERT INTO bds_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Afoo dagaa akhasi yade yaamu gu Raamage, ⁄aa⁄imu haa gaiidimoo gu didiru. Raheeli tay tosaa ⁄aa⁄ada sa yaꞌay kosi, yaa ⁄imbidiiba dagama tlaatlaqasi, sa gimba gonkoinaa hiĩ kaka⁄iri.” ");
INSERT INTO bds_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Qariqaaqari Heroode giyaa ilii hhami, malayika gu Taataa Iliitleemu yaa iliica⁄i Yoseefu tletaage yade Misirige. ");
INSERT INTO bds_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Malayikakee sugugi kaay tuba, “Tlayii! Oyii naw sliimaa haa iyoo dosi, ki⁄a hhapee da Israeelige, maꞌaana hhakira gwaa slaee gaasaraa nakee, hiĩ kaka⁄iri.” ");
INSERT INTO bds_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Teesaaqay, Yoseefu gii tlay, gii oyi naw sliimaa haa iyoo dosi, gi ki⁄i hhapee da Israeelige. ");
INSERT INTO bds_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Teesaaqay see, Yoseefu giyaa ilii akhasi tuba, Arikelaayo yaa tawaalimi hhapee da Yudaaya daqa da Heroode taataa gosi, yaa tlaꞌamuudi hadakawa yade. Ina dugugi ilakaay tletaage ha malayika, gi waaudi bara da hhapee da Galilaayage. ");
INSERT INTO bds_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ina yade gi ibinaa kay tongoo daa eteediidine Nasareeti. Teesaaqay, tletirukira dugwaa hiigaasi daa kaay hari amoo da tletimiisee tuba, “Dugumaati eteedi Nasareetimoo.” ");
INSERT INTO bds_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Balalu hhakeesii Yohaana Hiinunqudimiisay yaa hiica⁄i kongoqomee da Yudaayage, tay tosaa kakaana tuba, ");
INSERT INTO bds_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Fookidaaruu tlakwaroogo daqa Iliitleemuge, maꞌaana Tawaaloo da rawaa gu raw yaani daadaausidi.” ");
INSERT INTO bds_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohaanaki na hikira daa kakaakane ha tletimiisay Isaaya, giyaa ilii kaay tuba, “Afoo da didiri wanta da heedi kakaakanta kongoqomeege tuba, ‘Tafaꞌasa amoo sa Looimoo gu Goõ, la tafaꞌasiday amamu kosi cuti!’ ” ");
INSERT INTO bds_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohaana Hiinunqudimiisay yaati daamaamisi qayru daa boo⁄imisi hari quubu gu fala da gamiyaa. Kara, khiriĩ gosii coo⁄ay gu fala ginaa khiidiidina. ⁄agoo dosi yaa ingagimoo haa dinu gu kweera. ");
INSERT INTO bds_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Da hheꞌesi, hida wa⁄a gwaa ilii hadakayri ina Yerusaleemugo, Yudaaya sliimaago haa hhapapu gongo gu kenga gu duudu gu Yoridaanige waaree. ");
INSERT INTO bds_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inay giyaa ilii kakaaniri tlakwaroo dooina, Yohaana gigii nunqudimisi duudu gu Yoridaanige. ");
INSERT INTO bds_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Inkoo, Yohaana giyaa ilii arimi Farisaayoo wa⁄a haa Sadukaayoo, yaa ilii khakhayay ina, magi hiinunqudimisi, sigaa kaay tuba, “De, laqwaloti da deesasee pahha! Ha miyaa nangwaani ilii⁄oo⁄i, ma hii⁄ipidiri qupidaa gu Iliitleemu, gwaa khocee? ");
INSERT INTO bds_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Inkoo, laqama ⁄aamu gu laqama hiifookida dooguna tlakwaroogo daqa Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kara, hhanti ilahudeesiday haraa hiiboo⁄odiri kaawa tuba, ‘Taataa goori na Aburahaamu!’ Gu lou, sangu kaay Iliitleemu hiidahhasi hiitlaysa yaꞌay sa Aburahaamu daqa tle⁄eẽ hhankaa. ");
INSERT INTO bds_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Inkoo see, kiraara dagaã hheꞌesi, daganii qaasi kibeeri gu khaige! Khai sliimaa gooba boo⁄araa ⁄aamu gu hhou, digi tlaaqi haa digii kwakwahhi aslaage!” ");
INSERT INTO bds_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yohaana gi ilakoomi gimba tuba, “Gu lou, ana hanguri maꞌay kilesi hiinunqudimisa, ma laqantiri handii fookitiri daqa Iliitleemuge tlakwaroo doogunaa. Inkoo, ina gwaa khoca aluũ koaa, kona ⁄uuru hari khisla koyi see ba⁄i. Ana haraa hiiboo⁄iiba hiiowa see ye⁄eetoo kosi! Ina hiinunqudimisi unkuray hari Muuna gu Iliitleemu haa hari aslaa. ");
INSERT INTO bds_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ina hiĩ ooyi daba gosii kiyaaray gu heeleꞌemisu, hiĩ tlaatleesi ficinay biraa gosi, ma hiikurunkuri ganoo kuugiya dosii da didirige. Teesaaqay see, muuꞌu gumaa da⁄i hari aslaa doóba hhama!” ");
INSERT INTO bds_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Qatlaykeesii Yeesu see yaagi khay daqa Yohaanage yadaa hhapee da Galilaayago, ma dugu hiinunqudisi ha Yohaana duudu gu Yoridaanige. ");
INSERT INTO bds_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohaana gwaa koisi tlaatlahhasa kakaana tuba, “Ana na slaꞌa, ugu hanii nunqudiside. Haã soꞌoyi khaydi daqa dooii?” ");
INSERT INTO bds_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Teꞌesii, Yeesu gugi ilaki⁄isi ina tuba, “⁄imbi teesaaqay laqaraa inkoo, sa gimba dandiraatii boo⁄i hiigaasa gimba sliimaa da slaiye Iliitleemu.” Yohaana gi ⁄imbi. ");
INSERT INTO bds_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Qatlay Yeesu dugwaa ilii hheꞌesi hiinunqudisa ha Yohaana, ina yaagii ca⁄i maꞌaygo. Cirakiray, raw gi tlaaꞌadi, Yeesu gi arimi Muuna gu Iliitleemu yaa hii⁄eeti ubee, tlabiya pahha, gii ibiidi daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kara afoo yaagii ca⁄adi rawaa gu rawgo tuba, “Hiĩ ti Nankoy ga slae, ina hinoó muunaboo⁄eesi hari khisla.” ");
INSERT INTO bds_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Qatlay Yeesu dugwaa ilii hheꞌesi hiinunqudisa, teꞌesaa dugurigi giyaadi ha Muuna gu Iliitleemu kongoqomeege, ma dugu koimisu kay ha Biriisimoo. ");
INSERT INTO bds_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ina gi may ⁄agoo balalu mibeeri cigahha tleemaa haa amasi, asunkuilee gi arimi qori. ");
INSERT INTO bds_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Biriisimoo yaagi ilii khay Yeesu, gi kaay sa ina tuba, “Bere ugu ti Nanku Iliitleemu, ilafahhe tle⁄eẽ hhanki, ma mukaatee tleehhidiri.” ");
INSERT INTO bds_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeesu gi ilaki⁄isi sa ina tuba, “Daa handikimi, Handikaa da Iliitleemuge tuba, ‘Heedi yoó ibiidiyaaba hari ⁄agoo kilesi, ti ibiidi hari kila gimba goõ giyoó kaaye Iliitleemu.’ ” ");
INSERT INTO bds_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Da hheꞌesi, Biriisimoo gi leehhisi Yeesu Yerusaleemu naqatloo, yaamu daa tlintiꞌisi sa Iliitleemu. Taysi gugi qadidisi ina tlankoo gu tleeduge gu mara gu didiru gu Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","gi kaay sa ina tuba, “Bere ugu ti Nanku Iliitleemu, hanguu kwahhade hhapeege. Daa handikimi tuba, ‘Iliitleemu ilafahhi malayika dosi, magu ga⁄ayri. Inay gu tloꞌosiyay dabaiĩ koinay, ma maydi ilatlaꞌasa yaaee doogu tlaa⁄age.’ ” ");
INSERT INTO bds_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu gi ilaki⁄isi sa ina tuba, “Teesaaqay laqaaba. Yuꞌudiyaa daa handikimi tuba, ‘Taataa Iliitleemu, Iliitleemu googu, hagu hhanti koisida.’ ” ");
INSERT INTO bds_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Da hheꞌesi, Biriisimoo gi leehhisi Yeesu cina da oõ gu tleedu naqatloo, gi laqami sa ina tawaaloo goõ da hhapapu goõ haa hhoinay gu hindaqaruumaa dooina. ");
INSERT INTO bds_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ina gi kaay sa Yeesu tuba, “Ana sugu qaw idadu hhanki gonkoinaa, bere ugu keebeeꞌeta pandaa dooii haa hanigi daareesida.” ");
INSERT INTO bds_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeesu gugi ilaki⁄isi tuba, “Sataanimoo, waaudi tiaa! Maꞌaana daa handikimi taqay, ‘Ugu daareesi Taataa Iliitleemu, Iliitleemu googu, haa sugu yondite ina lenkosi kilesi.’ ” ");
INSERT INTO bds_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Da hheꞌesi, Biriisimoo gugi mamay teꞌesii. Yuꞌudiyaa! Malayika yaagi khayri, haa gi tlaatleesiri iliiaꞌaw ina. ");
INSERT INTO bds_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yeesu giyaa ilii akhasi tuba, Yohaana Hiinunqudimiisay duguũ khiidimi jeerage, yaa ki⁄i hhapee da Galilaayage. ");
INSERT INTO bds_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ina gi waaudi Nasareetigo, gi ibinaa kay tongoo da Kaperinauumuge, daa kenga gu tlawa da didiri waara da Galilaaya, digimi gu yaamu gu Sabuloonige haa gu Nafutaali. ");
INSERT INTO bds_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yeesu yaa yondiidi gimbaki sliimaa, dama hiigaasi gimbakira, daa kaay ha tletimiisay gu Iliitleemu Isaaya tuba, ");
INSERT INTO bds_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Hhapee da Sabulooni haa da Nafutaali, amoo daa yade khuꞌusidi tlawa da didiri, hari tlo⁄osaa gu duudu gu Yoridaani gu hhapee da Galilaayage waara, da hida gu hhapapu wakinay, ");
INSERT INTO bds_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","hida goó ibiidee hhanteege, hiĩ aniri cencee da didiri. Kara, hida goó ibiidee hhapee da mahhatu gu gwaaꞌaraage, Iliitleemu haraani khay cencee tla⁄aã gooinay.” ");
INSERT INTO bds_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tlaatleesoo da qatlaykeesaa Yeesu yaa tlaatleesi kakaaru tuba, “Fookidaaruu daqa Iliitleemuge tlakwaroo doogunaa, sa gimba Tawaaloo da rawaa gu raw yaani daadaausidi.” ");
INSERT INTO bds_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Letu waka, Yeesu giyaa ilii khookhociicine hari kenga gu tlawa da didiri da Galilaaya, yaa arimi hhiee cada, Simooni daa eteediidine hari uma waku Peetiro haa Andareyaa hhia gosi. Inay yaa hiitaareeꞌeeꞌenay tlawage makumbaa dooina dari ooyiru samaakii, sa gimba inay hiĩ naa yondu gooina. ");
INSERT INTO bds_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu gi kaay sa inay tuba, “Hawundaa hani sirakontee ana. Ana hangu sirakoomiisee doyi tleehhidisa da hiinaadu hida, mani sirakoniri ana.” ");
INSERT INTO bds_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Cirakiray lenge gi mayri makumbabuu koina teꞌesii, gi sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yeesu giyaa ilii khoci coko⁄o pandaage hari kenga gu tlawa, gi arimi hhiee wakinay cada, Yakoobo haa Yohaana, yaꞌay gu Sebedaayo. Inay haa taataa gooina yaa waꞌay gu masuwaa dooinay wanay, yaa boo⁄ii⁄imisiyay makumbabuu koina guri ooyiru gu samaakii. Yeesu gigi eteedi. ");
INSERT INTO bds_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cirakiray lenge, inay gi tooinaa mayri taataa gooina Sebedaayo masuwateesii, gi tooinaa sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu yaa ilakhookhocimi tongagu wa⁄a yade hhapee da Galilaayage, tay tosaa caacaahhamisi sinagoogaguu koinay haa gi kakaami Gimba gu Hhou gu Tawaaloo da rawaa gu raw. Kara, gi hhoeemisi ga⁄ay haa amaaiya paslaapasloo tla⁄aã gu hidage. ");
INSERT INTO bds_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gimba gu Yeesu gii qoomi daqeemoo sliimaa gu hhapee da Siiriyage. Hida yaagi leehhimisiri daqa dosii ga⁄iidee goõ, daa ilahufimaamidiye ha amaaiya paslaapasloo ha hiiguubimisu, haa hhaã daa ilii khaabaaꞌamidi ha gieeri, gu koomee kwinkwiisii haa gwaa tingara⁄uumidee. Ina gigi hhoeesi. ");
INSERT INTO bds_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Raqoo gu deni gu hida gugi sirakoniri yadaa hhapee da Galilaayago haa Dekapooligo, yaamu gu Yerusaleemugo, hhapee da Yudaayago haa tlo⁄osaa guri bara da ilacindoo gu rawaa gu duudu gu Yoridaanigo. ");
INSERT INTO bds_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeesu giyaa ilii arimi raqoo gu hida, yaa ilakhiinaaꞌadi onke, gi ibiidi hhapeege. Sirakoomiisee dosi gwaagi ilii khayri. ");
INSERT INTO bds_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ina gigi tlaatleesi caacaahhamisu inay. ");
INSERT INTO bds_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Digaa ⁄aafi ha Iliitleemu inay gu kwaeeli muunainge, sa gimba Tawaaloo da rawaa gu raw ti tooina. ");
INSERT INTO bds_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Digaa ⁄aafi ha Iliitleemu inay goó gaiidee, sa gimba digimaa tlaatlaqasi ha ina. ");
INSERT INTO bds_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Digaa ⁄aafi ha Iliitleemu inay goó ibiidee aslaaꞌamee, sa gimba himaa aalinayi hhapee daa hiifadidi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Digaa ⁄aafi ha Iliitleemu hhakaꞌa gu koomee qori haa wakhaa muunaiĩ koinay, gu ibiidee ibidinaa daa tafaꞌadi pandaa da Iliitleemuge, sa gimba Iliitleemu higimaa ankhisi inay. ");
INSERT INTO bds_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Digaa ⁄aafi ha Iliitleemu inay gu koomee ⁄awaariru, sa gimba inay see sigimaa laqana ⁄awaariru ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Digaa ⁄aafi ha Iliitleemu inay gu koomee muunaiĩ gu ⁄abakwi, sa gimba inay himaa arinayi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Digaa ⁄aafi ha Iliitleemu inay goó ilagaamisee fa⁄ayaa sa ibinaa da qasaw, sa gimba inay digimaati eteedi yaꞌay gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Digaa ⁄aafi ha Iliitleemu inay doó labaꞌasiye, sa ibinaa dooina daa tafaꞌadi pandaa da Iliitleemuge, sa gimba Tawaaloo da rawaa gu raw ti tooina. ");
INSERT INTO bds_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dangwaa ⁄aafi unkuray ha Iliitleemu qatlay dangumaa ilii wahaahane ha hida, haa dangumaa ilii labaꞌasiye unkuray, haa dangumaa iliitlohhidi ha inay gimba paslaapasloo gu afaꞌafuuma sa ana. ");
INSERT INTO bds_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Unkuray lamaati hhaꞌaluumitay haa gi seehhuusiday, sa gimba Iliitleemu sangu ilakhuukhuuꞌumisi ⁄aliya rawaa gu rawge. Okookoiĩ koina see, yaa mati teesaaqay labaꞌaaꞌamisiyay tletimiisee da Iliitleemu, gwaa giyaadee ibinaa khoorotii. ");
INSERT INTO bds_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Unkuray ti cakhasaa da khooroti. Inkoo, bere cakhasaa hiĩ hhamisidi cuuꞌu gosi, miyaa nii dahhasi ki⁄isaraa cuuꞌukira kosi? Dati kara hhoiiba coko⁄o see, dagati kwahhi segenge, daga tosaa kala⁄ana ha hida. ");
INSERT INTO bds_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Unkuray ti cencee da khooroti. Yaamu doó tleehhiye rawaa gu onke digoó hiidahhasiyaaba yakwa. ");
INSERT INTO bds_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hhaku heedi goó ooyisa caaꞌasiya, da hheꞌesi gigi ilakhupisi hari ⁄alu. Caaꞌasiyatee dagoóti qaasi garangaasiyage, ma hiicencuudisidi sa hida goõ gu waaree waꞌay gu marage. ");
INSERT INTO bds_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nama teesaaqay leẽ, cencee dooguna hiicencuudiside pandaa da hidage, ma hiidahhasiri arimaa yondu googuna gu hhou, haa ma daareesiri Taataa googuna gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Hhanti ilahudeesiday tuba, ana hanti khay khoorooge sa tlakweesa da sariyaa da Musaa baku caacaahhamisu gu tletimiisee. Ana hanti khayiiba sa tlakweesa dosi, hanti khay sa hiigaasa dosi. ");
INSERT INTO bds_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gu lou, sangu kaay raw haa khooroo maati amoolaa hiihhacooiyay, sariyaa da Iliitleemuge hhaka caqariya lensee da coko⁄oniinii ma daqa da coko⁄oniinii damaa hhama, gimba sliimaa maati gesaa buꞌudi. ");
INSERT INTO bds_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inkoo, heedi gumaa sia ilakaawa lensee da coko⁄i ilakaawa gonge, haa gi caacaahhamisi hida wakinay, yondiidiye teesaaqay, hikee maa heedi gu coko⁄u lou tleehhidi Tawaaloo da rawaa gu rawge. Teesaaqay see, hikee gumaa oowa ilakaawatee haa gi caacaahhamisi hida wakinay, hikee heedi gu didiru tleehhidi Tawaaloo da rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ana sanguu kaay unkuray ambee, ibinaa dooguna daa tafaꞌadi bere daba hiicata haaki da Farisaayoo haa maarimamaa da sariyaa, etaa hiiguntaaiiba Tawaaloo da rawaa gu rawge.” ");
INSERT INTO bds_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yeesu gi ilakoomi gimba tuba, “Haa akhasidiri, idoo hida gu wakaꞌalee digaa ilii caacaahhamisi tuba, ‘Hhanti gaasida heedi! Slime, heedi gu gaasa haraa hiiboo⁄i hukuruu.’ ");
INSERT INTO bds_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Teesaaqay see, sangu kaawa ambee, heedi gumaa gupida sa hhia gosi, hikee hirimaa hiiboo⁄i hukumuu. Kara, heedi gumaa waama hhia gosi, dugu sitaakina balasaa da didirige. Slime heedi gumaa kaawa sa hhia gosi tuba, ‘Ye bawdiisayi,’ haraa hiiboo⁄i hukumuu aslaa doóba hhamaraa da Jehanaamu. ");
INSERT INTO bds_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Inkoo, bere haysida sadaaka doogu sa Iliitleemu masabaahuge, haa teꞌesii gii slayda tuba, hhia googu kona naanaqamoo haa ugu, ");
INSERT INTO bds_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","may sadaaka doogu teꞌesii pandaa da masabaahuge. Taa⁄a geesaa hangu wariiakhasidee haa hhia googu, laaꞌasu ki⁄ida sa hadisaraa da sadaaka doogu sa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bere duguũ sitaakimi ha heedi waku, hangu wariiakhasidee haa ina cira ga ilii kahhadee dawaraa balasaage. Bere malee, angamalee heedikee gu leehhisi pandaa da hakiimuuge. Kara, hakiimuu gu taatahhi daqa sirikaarimooge, ina gugii lu⁄i jeerage. ");
INSERT INTO bds_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gu lou, ugu sugu kaay ambee, etaa hiica⁄adaaba jeerago, ti geesaa hheꞌesida bueemaa goboriya da hiifaakoo! ");
INSERT INTO bds_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Unkuray haa akhasidiri, idoo daa ilii caacaahhamisi hida gu wakaꞌalee tuba, ‘Hhanti slipalauta.’ ");
INSERT INTO bds_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Inkoo, ana sangu kaawa unkuray ambee, heedi goó yuꞌuda hadee gigi slahhaai, hiĩ hheꞌesi guꞌudee haa ina muuna gosii. ");
INSERT INTO bds_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gu lou, bere ila doogu da ⁄uya ⁄isinta ugu, ma tlakweesidi, tu⁄aka laga kwahhada segenge. Ti ba⁄ay ugu hhamisaraa daqa leẽ da slaqwa doogu, slaqwa doogu goõ dagama may hiislakharaa aslaa doobage hhamaraa da Jehanaamu. ");
INSERT INTO bds_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kara, bere daba googu gu ⁄uya ⁄isina ugu, ma tlakweesidi, kereꞌesaku lugu kwahhada segenge. Ti ba⁄ay ugu hhamisaraa daqa leẽ da slaqwa doogu, slaqwa doogu goõ dagama may hiislakharaa aslaa doobage hhamaraa da Jehanaamu. ");
INSERT INTO bds_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Slime haa akhasidiri, idoo hida gu wakaꞌalee giyaa ilii caacaahhamisiri tuba, ‘Hhawata gu mawa hadee dosi, kwanda saga kereꞌesiye tarakaa.’ ");
INSERT INTO bds_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Inkoo, ana sangu kaawa unkuray ambee, hhawata gu kereꞌesa tarakaa sa hadee dosi, bere sati gimba gu slipalauuma gooba, hikee ⁄isina hadee dosi, ma slipalauutoꞌoo tleehhiti. Kara, hhawata gu khabima hadetee saa kereꞌesi tarakaa, hikee see hiti yondiidi slipalauuma. ");
INSERT INTO bds_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Unkuray haã akhasidiri hida gu wakaꞌalee idoo digaa ilii caacaahhamisi tuba, ‘Hhanti seelinta gimba gu afaꞌafuuma, ti gaasii seeliru googu daqa Looimoo gu Gonge.’ ");
INSERT INTO bds_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Inkoo, ana sangu kaawa unkuray ambee, etaa hhanti seelintay coko⁄o see. Hhanti seelintay ma hari uma gu raw see, sa gimba ti kitiĩ gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kara, hhanti seelinta hari uma gu khooroti, sa gimba ti daqa dosi da iliiqaasa yeꞌeeroo. Slime, hhanti seelinta hari uma gu Yerusaleemu, sa gimba yaamu hhanki guti Iliitleemu, ina gu Mutemi gu didiru. ");
INSERT INTO bds_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kara, hhanti seelintay hari sagaiĩ kokuna loi, sa gimba hiidahhasidaaba hiifooka ma quubiya lensee, ma ⁄abaakwaydi baku ma boo⁄aydi. ");
INSERT INTO bds_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bere kaada, ‘Ee’ ti ‘Ee’ tleehhite. Kara, bere kaada, ‘Suti’ ti ‘Suti’ tleehhite. Gimba sliimaa doó kaaye hiicataraa da hikee, yoó daqa Biriisimoo dahhi. ");
INSERT INTO bds_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Unkuray haã akhasidiri idoo diĩ kaay tuba, ‘Bere heedi hiĩ gaasi ila, ina see dugu afagaasiye ila, haa bere hiĩ muumu⁄i ⁄aatlimoo, ina see dugu afamuumu⁄iye ⁄aatlimoo.’ ");
INSERT INTO bds_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Inkoo, ana sangu kaawa ambee, hagu hhanti kanisida heedi gu tlaku. Bere heedi slokhosi ugu tlooma da ⁄uyage, suguu fookide tlooma da cadii see. ");
INSERT INTO bds_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bere heedi slai sitaakiru ugu haa slai hiiowa kanchoo doogu, slime sugu mayde kooti doogu see. ");
INSERT INTO bds_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bere heedi ⁄uureesi ugu khocu haa ina kilomiita leẽ, khoce haa ina kilomiita cada. ");
INSERT INTO bds_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kara, hida goó firiirimee sigi qaydee, qonsa see hhantii fookida sa heedi gu slaꞌa idoo gimaa ki⁄isiye.” ");
INSERT INTO bds_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yeesu gi ilakoomi gimba tuba, “Unkuray haã akhasidiri, idoo diĩ ilii kaay tuba, ‘Slae hida danaee koku,’ haa wake fa⁄ayaa doogu. ");
INSERT INTO bds_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Inkoo, ana sangu kaawa ambee, slaꞌa fa⁄ayaa dooguna haa firiirima sa hhakee goó labaꞌasee unkuray. ");
INSERT INTO bds_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Teesaaqay laqa, ma yaꞌay gu Taataa googuna tleehhitiri gu rawaa gu rawge waaraa. Ina yoó hiicencuudisi letu dosi sa hida goó yondiidee tlakwaroo haa goó yondiidee hhoinay. Kara, haroó khay tlubay sa hida gu koome ibinaa daa tafaꞌadi haa hida gooba ibinatee. ");
INSERT INTO bds_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bere hagiti slaꞌaday hida hhakaꞌa kilesi goó slaee unkuray, da hheꞌesi hoó ⁄aliya mala slayday daqa Iliitleemugo? Hhaka! Karaanimaiĩ goó hiikurunkurimee see koodi, yoó teesaaqay yondiidiyay! ");
INSERT INTO bds_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kara, bere ti cehheemisiday kilesi hhiee kokuna, yondu mala gunoó yonditay hiicataraa da wakinay? Hida goóba ⁄imba see Iliitleemu yoómati teesaaqay laqiyay! ");
INSERT INTO bds_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Inkoo, hida gwaa buꞌudee tleehhida, idoo Taataa googuna gooay Iliitleemu gu rawaa gu rawge waara giyaa ilii buꞌudi.” ");
INSERT INTO bds_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yeesu gi ilakoomi gimba tuba, “Khuꞌuma hhanti yonditay gimba googuna gwaa tafau pandaa da hidage, ma danguma arimi ha hida. Bere teesaaqay laqaday, hamaa slaydaaiiba ⁄aliya daqa Taataa googunaa gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Inkoo, goó ilii hadimisidee sa kwaeeli, hhanti kakantay. Hhanti yonditay peereehhiisee gooay goó kakaamee yondu gooina sinagoogaguuge haa amamuge, ma digi daareesi ha hida. Gu lou, sangu kaay, inay yaa hheꞌesiri yaa slayri ⁄aliyoo koina khoorotii. ");
INSERT INTO bds_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Teꞌesii, qatlay goó ilii hadimisidee sa kwaeeli, ti hadimisa hari siiri heedi lensee hhanti caahhi idoo gaã yonditiri. ");
INSERT INTO bds_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hari amoti, hadimisukee ti siiri tleehhite. Taataa gu rawaa gu rawge waara goó arima yondu goó yonditee hari siiri, sangumaa qay ⁄aliya. ");
INSERT INTO bds_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kara, qatlay goó ilii firiirintee Iliitleemu, hhanti peereehhiisee pahha tleehhitay. Inay yoó slaiyay qadimidu haa firoo sinagoogaguuge haa kenga gu balabalaage, ma digi arimi ha hida. Gu lou, sangu kaay, inay hiĩ hheꞌesiri hiĩ slayri ⁄aliyoo koina. ");
INSERT INTO bds_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Inkoo, goó ilii firinte Iliitleemu, dayii sagay gu marage haa khiidimi afamaraa. Da hheꞌesi, firimi Taataa googu doóba arimaa. Ina, Taataa goó arima yondu goó yondite hari siiri, dugumaa bui ugu. ");
INSERT INTO bds_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kara, qatlay goó ilii firiirinte Iliitleemu, hhanti maahhamintay hida hhakaꞌa pahha gu hhapapu wakinay gu hhidimee Iliitleemu. Inay yoóti ilahudeesiyay tuba, digi akhasi ha Iliitleemu, sa gimba gu gimba gooina gu wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Inkoo, hhanti inay pahha tleehhitay, sa gimba Taataa googuna khui idadu ga slaꞌadee, unkuray kahhaday see firoo! ");
INSERT INTO bds_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Inkoo, qatlay ga ilii firiirintee taqay firima, ‘Taataa goori goó rawaa gu rawge waara, uma googu dugu muriidiye, ");
INSERT INTO bds_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tawaaloo doogu yaa khayde daqa doorii, slaꞌamuu koku digii gaasiye, tiꞌii khoorotii giyoó iliiwane gooay taysi rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Letuti sandi hadiside ⁄agoo doori. ");
INSERT INTO bds_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Handi ilamooyinte tlakwaroo doori, dandiray gooay goó ilii ilamooyine, hhakira goõ goó dakumisee daqa doorii. ");
INSERT INTO bds_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kara, handi hhanti hiilu⁄uda koimisuge, handiti ilabuꞌunte daqa Biriisimoogo.’ ");
INSERT INTO bds_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bere ilamooyintay hida qatlay giyoó ilii dakusiyee daqa doogunay, Taataa googuna gu rawaa gu raw slime ilamooyina tlakwaroo dooguna. ");
INSERT INTO bds_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bere hanguba ilamooyiru hida qatlay giyoó ilii dakusiyee daqa doogunay, Taataa googuna see ilamooyinaaba unkuray tlakwaroo dooguna. ");
INSERT INTO bds_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Qatlay goó ilii maydee ⁄agoo, hhanti laqantay li⁄eemoo da peereehhiisee gooay. Inay pandadu koina giyoóti laqanay hida hhakaꞌa pahha gu gaimaamidee, digima arimi ha hida tuba, hiĩ mayri ⁄agoo. Gu lou, sangu kaay, inay yaa hheꞌesiri yaa slayri ⁄aliyoo koina. ");
INSERT INTO bds_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Teesaaqay see, qatlay goó ilii maydee ⁄agoo, sagaiĩ kokuna ligi maakhaday du⁄iya haa pandadu kokuna ligii slironqomisiday balalu sliimaa gooay. ");
INSERT INTO bds_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Teesaaqay laqa, hida ma mayri caahha tuba, unkuray haã maydiri ⁄agoo. Gimbakee duguti caahhiye ha Taataa goori kilesi, Iliitleemu goó daqa da siirige waara. Ina yoóti arina yondu goõ goó yondiidane hari siiri, hangumaa bui unkuray. ");
INSERT INTO bds_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hhanti qaasiday sa unkuray kitangeeriyage idadu gu kaari khoorotii daqa da iliiwane sekeley haa kuutu doó tlakweesa, haa fiisiisee gi cihhida mara haa gi fiisiyay. ");
INSERT INTO bds_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Qaasa sa unkuray rawaa gu rawge idadu gu kaari, daqa doóba iliidawa sekeley haa kuutu gii dahhasiyay tlakweemisu, slime fiisiisee yoó cihhiyaaiiba haa gi fiisiyay. ");
INSERT INTO bds_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sa gimba daqa da iliiwane hindaqaruumaa dooguna, slime na daqa damaa iliiwane muunaiĩ kokuna. ");
INSERT INTO bds_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ilaa ti caaꞌasiya da slaqwa pahha. Bere ilaa koku guti hhoi, slaqwa doogu gonkosaa ti hacida cencee. ");
INSERT INTO bds_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Inkoo, bere ilaa koku gu tlakwi, slaqwa doogu sliimaa ti hacida hhantee. Kara, bere cencee da daqa dooguu waara ti hhantee, gu lou hatee ti hhantee da didiri loi!” ");
INSERT INTO bds_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yeesu gi ilakoomi gimba tuba, “Wanaaba yondimiisay goó hiidahhasa yondiida yondu sa looee cada. Sa gimba, ina himaa waki looimoo leẽ haa himaa slai gu caduu, baku hingimaa ooyina haa looimoo leẽ haa himaa qooqiidi gu caduu. Unkuray hiidahhasidaaiiba yondiidaraa sa Iliitleemu sliimaa haa khooslay qatlaykeesii lenge. ");
INSERT INTO bds_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Inkoo, sangu kaawa hhanti khoslongoruusiday sa ibinaa doogunay tuba, ha mala ⁄agintay baku ha mala kitahhantay. Kara hhanti khoslongoruusiday sa slaqoo kokuna tuba, ha mala daamisiday. Ibinaa dati kaariibaslii ba⁄ay da ⁄agoo? Kara slaqwa dati kaariibaslii ba⁄ay da qayroo? ");
INSERT INTO bds_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilahudeesa gimba gu cira⁄oo. Inay yoó daamisiyaaiiba pisagaroo ma buꞌuruu see, ma kuugiyoo gu deni see konaaiiba. Teesaaqay see, Taataa goori gu rawaa gu raw giyoó tosaa ⁄agimisi inay. Inkoo, unkuray hanguti kaariibaslii hari khisla ba⁄ay da cira⁄oo? ");
INSERT INTO bds_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Slime miyaa tla⁄aã googunay sa khoslongora gu didiri gu hiidahhasa hiiroogisa ibinaa dosi mati saa leẽ see? ");
INSERT INTO bds_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ha soꞌoyi toodaritay sa qayroo? Hhanti teesaaqay laqaday! Ilahudeesa humbalaalay, idoo giyoó ilii dinaraaraye. Yoó yondiidiyaaba yondu haa yoó boo⁄imisiyaaba qayroo. ");
INSERT INTO bds_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Teesaaqay see, sangu kaay unkuray ambee, mutemi Solomooni see wanqamee dosi goõ, qayroo kosi gwaa hhoiiba hari khisla da humbalaalaykee gooay! ");
INSERT INTO bds_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Inkoo, Iliitleemu yoó teesaaqay tlemi sluufa gu kweera, humbalaalaykee giyoómati waari see letuti haa heetlaalee dugu tosaa hiikwahhi aslaage. Gu lou, caba Iliitleemu hangu ila⁄utlidimisi unkuray hari khisla? Ye hida gu koomee ⁄imbaraa narabu! ");
INSERT INTO bds_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Inkoo, hhanti toodaritay gi kaaday tuba, ‘Mala ⁄agina?’ ‘Mala kitahhana baku mala daamisana?’ ");
INSERT INTO bds_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hida gu hhidimee Iliitleemu noó dabiidiyay idadu hhakee goõ. Kara, Taataa googuna gu rawaa gu raw khui tuba, idadu hhakee hagi slaꞌaday! ");
INSERT INTO bds_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Inkoo, dabiida geesaai Tawaaloo da Iliitleemu haa ibinaa dosi daa tafaꞌadi, ina sanguu roogisi idadu hhakee goõ. ");
INSERT INTO bds_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Teesaaqay, hhanti toodaritay sa gimba gu heetlaalee, heetlaalee hingoo hiitoodarita ina lenkosi. Kila baloo konta ilahufidu gosi gu buꞌudisa balotee.” ");
INSERT INTO bds_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yeesu gi ilakoomi gimba tuba, “Hhanti hukuukuntay hida wakinay, unkuray see dangu ba⁄atii hukuna ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Iliitleemu himaa hukuna unkuray harima amotee leẽ garoó hukunte hida wakinay. Kara, ina hangumaati hukuna unkuray nama pimokaꞌa pahha goó ilakhuꞌudee sa hida wakinay, unkuray see nama hikee, sangunimaa ilakhui ha Iliitleemu! ");
INSERT INTO bds_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ha soꞌoyi khuꞌuuꞌunta pencerehhemiya da waara ila da hhia googuu, ugu gi mayda arimaa bangasiya ila dooguu? ");
INSERT INTO bds_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ha malee hiidahhasida kaawaraa sa hhia googu tuba, ‘Hhia goy, may sugu baci pencerehhemiya da ila dooguu waara,’ tay ugu loi gi mayda arimaa bangasiya ila dooguu? ");
INSERT INTO bds_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ye peereehhiisay! Bace geesaa bangasiya da didiri da ila dooguu waara, teꞌesii ganoo ilii arinta naraꞌa bacaraa pencerehhemiyatee da ila da hhia googuu waara. ");
INSERT INTO bds_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Hhanti hadimisiday idadu daa tlintiꞌisi sa Iliitleemu sa hida gu koomee tlakwaroo, hhaã gu gwehheeri pahha. Kara, hhantii kwakwahhaday idadu gu kaari sa hida hhakee gu biinoo slaqamisee, gigi tooinaa kalakala⁄anay, dangugi ilii fookidi haa dangugi feehhimisi. ");
INSERT INTO bds_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ana sangu kaawa ambee, ‘Unkuray firiirima Iliitleemu, sangu qay ha ina, dabiida ha slayday, guutuumisa sangu afiiooyina afamaraa.’ ");
INSERT INTO bds_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ina goó firiirima, sugoó qay. Kara ina goó dabiida, yoó slay. Slime ina goó guutuusa afamaraage, sugoó afiiooyina. ");
INSERT INTO bds_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gu lou, wanaa taataa lensee tla⁄aã googunay, hiĩ bere nankosi guũ firimi mukaatee, ina sugugi hadisi tlaa⁄u? ");
INSERT INTO bds_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Baku bere nankosi guũ firimi samaakimoo, ina sugugi hadisi deesu? ");
INSERT INTO bds_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Inkoo, gimati unkuray ti hida gu koomee tlakwaroo, ha khuꞌuday hadimisu sa yaꞌay kokuna sawaadii da hhoi. Teesaaqay, Taataa googuna goó rawaa gu rawge waara, ilakona hari khisla hadimisu idadu gu hhoi sa hida hhakee goó firiirime ina. ");
INSERT INTO bds_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yondiida sa hida wakinay, nama amotee gooay unkuray goó iliislaꞌadee, inay ma yondiidiri sa unkuray. Haã na maꞌaana da sariyaa da Musaa haa da caacaahhamisu gu tletimiisee. ");
INSERT INTO bds_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Maguumida gonkokunaa hiiguumaraa, Tawaaloo da Iliitleemuge hari kaꞌafu gu hiidigidaaku. Sa gimba kaꞌafu gu hiitlaakhu ti amoo da hiislaahhislaahi, haroóti giyata hida hhamisaraage. Kara, hida goó hiiguumee hari amotee ti wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaꞌafu gwii digidaaku haa amoo daa karahhadi hiroó giyaadiyay hida ibinaa da slafimaage. Hida goó baraslawee amotee ti coko⁄o kilesi.” ");
INSERT INTO bds_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yeesu gi ilakoomi gimba tuba, “Hangu ga⁄iidee haa tletimiisee da afaꞌafuumaa. Inay goó khakhawee daqa doogunay, tay digigi arina hari khooroo bee⁄u pahha, kaslenkwaa inay hari waꞌay ti takuraaꞌa da dihhi. ");
INSERT INTO bds_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hagiti caahhaday hari yondu gooina giyoó yondiidiye ti hida mala slaqamisiyay. Hida yoó wee⁄iyaaii ⁄aamu gu sabiibu leqeewaage? Kara ⁄aamu gu ⁄anca see dugoó wee⁄iyaa foqoorayge? ");
INSERT INTO bds_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Teesaaqay, khaimoo gu hhou yoóti ⁄aamuudi ⁄aamu gu hhou, nama teesaaqay leẽ, khaimoo gu tlaku yoóti ⁄aamuudi ⁄aamu gu tlaku. ");
INSERT INTO bds_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hhaku khaimoo gu hhou goó ⁄aamuuda ⁄aamu gu tlaku, nama teesaaqay hhaku khaimoo gu tlaku goó ⁄aamuuda ⁄aamu gu hhou. ");
INSERT INTO bds_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila khaimoo goóba boo⁄araa ⁄aamu gu hhou, dugoóti tlatlafi haa dugugii kwahhi aslaage. ");
INSERT INTO bds_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Teesaaqay, hida hagiti caahhaday hari yondu gooina. ");
INSERT INTO bds_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ti hida goõ goóba goó eteedimee ana, ‘Looimoo gu Goõ, Looimoo gu Goõ,’ hiigunay Tawaaloo da Iliitleemuge. Ti hhakaꞌa kilesi goó yondiidee, idoo doó iliislaiye ha Taataa goy goó rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Balotee gimaa ilii daade, hida wa⁄a sinimaa kaayay ana tuba, ‘Looimoo gu Goõ, Looimoo gu Goõ, handaabaslii kakaaru tletiru googu hari uma googuu? Kara, hari uma googu handaabaslii hiica⁄amisu gieeri, haa gi yondiidani yondu gu denu goó bakaꞌasa hida?’ ");
INSERT INTO bds_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Teꞌesii, ana maa ilaki⁄isi inay pandataa tuba, ‘Etaa, ana hangu hhidima unkuray. Waauda tiaa daqa dooaa, unkuray goó kanimisee sariyaa!’ ” ");
INSERT INTO bds_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Qariqaaqari Yeesu gi kaay tuba, “Inkoo, heedi goó akhamisa gimba gooi haa gigi yondiidi, hikee ti heedikaꞌa pahha gu kooma waaway, gwaa tleehhu mara gosi rawaa gu hhafidage. ");
INSERT INTO bds_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Qatlay tlubay giyoó ilii tlubiye, duududaa haraagi khayay ilawa⁄iya, haa ilafahhiya da dihhi gi fahhanta, gi tlupita marakee hari ⁄uuru. Teesaaqay see, ilawa⁄iyatee yaa hiidahhasidiiba rinqirinqisa marakee, sa gimba musingi gosi dugwaa tleehhi naraꞌa rawaa gu hhafidage. ");
INSERT INTO bds_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Heedi goó akhamisa gimba gooi, haa gi may yondiida gimbakee koi, ti heedikaꞌa pahha gwaa bawdu gwaa tleehhu mara seehhinayge. ");
INSERT INTO bds_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tlubay gi tlubi, duududaa haaragi khayay ilawa⁄iya, ilafahhiya da dihhi gi fahhanti, marakee dugugi tlupi ha ilawa⁄iya, gi tosaa cira huui khupu!” ");
INSERT INTO bds_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Qatlay Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee, raqoo gu hida digaa bakaꞌasi hari khisla ha caacaahhamisu gosi. ");
INSERT INTO bds_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sa gimba ina giyaati caacaahhamisiiba inay maarimamaa dooina pahha da sariyaa, ina giyaati caacaahhamisi heedi gu kooma pahha ⁄uuru gu tawaaloo. ");
INSERT INTO bds_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeesu giyaa ilii⁄eeti onko, raqoo gu deni gu hida gwaa sirakoniri ina. ");
INSERT INTO bds_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yuꞌudiyaa! Teꞌesii yaagi khay heedi gu kooma ga⁄ay gu buubaa, gi keebeeꞌedi pandaa dosii, gi tlaatlaqasi Yeesu tuba, “Looimoo gu Goõ, hhooa, bere slaꞌada, haniidahhasida ilabuusla.” ");
INSERT INTO bds_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu gi tafaꞌasi daba gosi, gugi tosaa nangusi heedikee, gi kaay tuba, “Ee, Ana slaꞌa teesaaqay laqa, ugu ma dugu ilabuusli!” Cirakiray lenge ga⁄aykee kosi dugugi ilabuusli sumuku! ");
INSERT INTO bds_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Da hheꞌesi, Yeesu gugi afakaayi heedikee tuba, “Hhanti kaada sa heedi lensee gimbaki. Inkootuutuu taa⁄a hangu laqante daqa hhapalooay gu Iliitleemuge, la haysa kayda sadaaka sa ilabuuslatee toku, idoo daa ilii ilafahhi gooay sariyaa da Musaage. Hatee noo ilatlawa doogu daqa hidage tuba, duguũ ilabuusli.” ");
INSERT INTO bds_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Qatlay Yeesu giyaa ilii day Kaperinauumuge, sirikaarimoo waku gu didiru gu Ruumi, gwaa ilii hadakay ina, gugu tlaatlaqasi tuba, ");
INSERT INTO bds_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Looimoo gu Goõ, tongimoo goy hiĩ qaati ayage, hiĩ tingara⁄uudi. Kara, ti kona labaꞌasu hari khisla.” ");
INSERT INTO bds_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu gi kaay sa sirikaarimokee tuba, “Ana haa khaw, hagu hhoeesa ina.” ");
INSERT INTO bds_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Teꞌesii sirikaarimokee gugi ilaki⁄isi tuba, “Looimoo gu Goõ, ugu ti heedi gu didiru, ana haraa hiiboo⁄iiba kwahhasuusa ugu mara gooii. Inkoo, ugu ti kaay gimba kilesi, tongimoo gooi hhoay! ");
INSERT INTO bds_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maꞌaana, ana see, ti kooma hida gu rawaa koii waaree ⁄uuru gu tawaalooge. Slime kooma sirikaarii waka da biraa gu tawaaloo dooii waaree. Qatlay goó ilii kaawe sa leẽ ambee, ‘Taa⁄a!’ Ina yoóti hadakay. Kara goó ilii kaawe sa waku ambee, ‘Khoca!’ Yoóti khay. Slime goó ilii kaawe sa tongimoo goy ambee, ‘Yondiidi gimbaki!’ Yoóti yondiidi.” ");
INSERT INTO bds_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Qatlay Yeesu giyaa ilii akhasi gimbaki, yaati bakai hari khisla. Ina gi kaay sa hida hhakee gwaa sirakomaamidee ina tuba, “Etaa, hhapee sliimaa see da Israeeli ha kahha arimaa heedi gu kooma ⁄imba da didiri da hiĩ gooay! ");
INSERT INTO bds_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kara, sangu kaawa unkuray pandataa ambee, hida wa⁄a himaa khayay bara da ilacindoo gu rawaago haa ilacindoo gu biraago. Inay himaa ibiidiyay meesaage sa losona gu didiru sliimaa haa Aburahaamu, Isaaka haa Yakoobo Tawaaloo da rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Teesaaqay see, hida hhakaꞌa guraa hiiboo⁄ee ibinaa Tawaalooge, Iliitleemu gimaa kwahhi khoorooge, hhanteege. Taysi inay himaati ⁄aa⁄iyay haa himaati tluꞌunay ⁄atloo.” ");
INSERT INTO bds_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Da hheꞌesi, Yeesu gi kaay sa sirikaarimokee gu didiru tuba, “Taa⁄a ayage, gimbakira guũ ⁄imbidi teesaaqay tleehhidiye daqa dooguu.” Nama qatlaykeesii lenge tongimokee gi hhoay. ");
INSERT INTO bds_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeesu giyaa ilii day mara gu Peetiroge, teꞌesii yaa arimi kumboꞌoo da Peetiro hiĩ qati buburuuge, mama⁄ada hari khisla. ");
INSERT INTO bds_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Teꞌesii Yeesu gigi ilii hadakay, gi nangusi daba gosi, ga⁄aykee kosi gii caaquudi. Ina ginaa iliitlaydi, gi tosaa yonditi sa inay. ");
INSERT INTO bds_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Qatlay letu giyaa ilii huhaahuꞌude, Yeesu suguraagi khay hida wa⁄a daa ilii khaabaaꞌamidi ha gieeri, giyaagi leehhisiri daqa Yeesuge. Ina gi ilii⁄oo⁄imi gieeri hhakee hari gimba gosi, gi hhoeesi ga⁄iidee goõ. ");
INSERT INTO bds_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yeesu yaa teesaaqay laqi, dama hiigaasi gimbakira daa kaay ha tletimiisay Isaaya tuba, “Ina loi yaa hiioy amaaiya doori, haa haraa waaudi ga⁄ay goori.” ");
INSERT INTO bds_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Qatlay Yeesu giyaa ilii arimi raqa da hida daa niini⁄iti ina hindii roogiti hari khisla, ina gi ilafahhi sirakoomiisee dosi, ma tlo⁄osiri hari bara da cadii da tlawa da didiri da Galilaaya. ");
INSERT INTO bds_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Da hheꞌesi, giyaa ilii kahhiyee waauda, maarimuu leẽ gu sariyaa, gi ilii hadakay Yeesu, gi kaay sa ina tuba, “Maarimuu, ana hagu sirakooma ugu daqeemoo sliimaa ga kayde!” ");
INSERT INTO bds_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu gi kaay sa ina tuba, “Mondadee konay maraoo gu ilii ibinaa, cira⁄oo konta cuuraiĩ. Nanku Heedi konaaba ma daqa da ilii qaatisa see saga gosi.” ");
INSERT INTO bds_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sirakoomiisay waku gi kaay sa Yeesu tuba, “Ye, Looimoo gu Goõ, hani geemayde gesaa, maa qaasi taataa gooi.” ");
INSERT INTO bds_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu gi kaay sa ina tuba, “Ugu hanisirakonte, may hhakee goó sisiee ana, muunainge ti tuueenaa pahha, ma qamidiri tuueenaa deneꞌee koina.” ");
INSERT INTO bds_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Da hheꞌesi, Yeesu yaa hiiday masuwaage sliimaa haa sirakoomiisee dosi, gi waaudiri haa ina. ");
INSERT INTO bds_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yuꞌudiyaa! Teꞌesii tlawage daagii ca⁄i ilafahhiya da didiri hari khisla, masuwatee yaati naahhadi aloo hiihhanta tlawage. Teesaaqay see, Yeesu yaati qaati alunge. ");
INSERT INTO bds_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sirakoomiisee dosi gugi ilii hadakayri ina haa gugii leehhisiri. Inay gi maahhiri, kakaanay tuba, “Looimoo gu Goõ, tlayii handi ilabuꞌunte! Dandiray slaꞌana kaka⁄u!” ");
INSERT INTO bds_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeesu gi kaay sa inay tuba, “Siĩ soꞌoyi tlaꞌamuumutiri teesaaqay? Inkoo naqatloo kahhadaaii, ti kontay ⁄imbaraa narabu daqa dooii!” Da hheꞌesi, Yeesu gi qadidi, gi tosaa ilii⁄oo⁄i ilafahhiyatee da dihhi haa gondadee hhakee gu deni. Cirakiray lenge ilafahhiyatee gi kaanahhasidi sumuku. ");
INSERT INTO bds_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Teꞌesii inay gi bakairi hari khisla, hingigi tlaatleesiri maamisu inay haa inay tuba, “Yuꞌudaa! Hiĩ kara ti miyaa? Gunti ilii⁄oo⁄u ilafahhiya haa gondadee gu tlawa da didiri see, gugi akhasiri ina.” ");
INSERT INTO bds_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeesu gi day hhapee da Wagadaraage, daraa bara da cadii waara da tlawa da didiri da Galilaaya. Teꞌesii hingigi slaslay haa hida cada daa ilii khaabaaꞌamidi gieeri, yaagii ca⁄iri maraoo daa iliiqamidi tuueenaa. Hida hhakee gwaa dihhi hari khisla, hhaku heedi lensee gwaa hiidahhasu hiicata hari amotee. ");
INSERT INTO bds_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yuꞌudiyaa! Inay yaati maahhiri hari afoo da didiri, kakaanay tuba, “Ye, Nanku Iliitleemu, mala kona haa ugu? Inkoo, hagu tlaatlaqasana, handi hhanti labaꞌasida da ilii kahhiye buꞌuda qatlay daa hiileehhi ha Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Inkoo, raqa da didiri da biinoo yaa wanta, daa deꞌeeꞌene teꞌesii seesegeẽ daqa dooinaa. ");
INSERT INTO bds_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gieeri hhakee gi tlaatlaqasiri Yeesu tuba, “Hhooa, bere handi gusinta, handi ilafahhade, ma iliiguuma kayni biinotaꞌa.” ");
INSERT INTO bds_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ina gi kaay sa inay tuba, “Waauda!” Gieeri hhakee yaagii ca⁄iri daqa hida hhakeesaa, gii guuma kayri daqa biinotiray. Raqatee da biinoo, gii gweegwe⁄eti hari ⁄uuru ilagweegwe⁄eda da dihhigo, gii gunti tlawa da didirige, gi tosaa kaka⁄adi goõ. ");
INSERT INTO bds_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Deꞌemiisetee da raqa da biinoo giyaa ilii anti gimbakee gwaa hiica⁄u, gi lakiti tongoo dooinay. Inay gi kaawa kayri sa hida gimbaki goõ, hikee loi gwaa hiica⁄u daqa hida hhakeesii gu cada daa ilii khaabaaꞌadi gieeri. ");
INSERT INTO bds_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yuꞌudiyaa! Hida hhakee gu tongoo yaagii ca⁄iri hingigi slaslayri haa Yeesu. Qatlay inay giyaa ilii aniri gi tlaatlaqasiri Yeesu, ma waaudi hhapee dooinaa! ");
INSERT INTO bds_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Da hheꞌesi, Yeesu yaa hiiday masuwaage, gi tlo⁄osi hari bara da cadii da tlawa da didiri da Galilaaya, gi dayri yaamu kosii gu Kaperinauumu giyaa ilii ibimaamidiye. ");
INSERT INTO bds_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yuꞌudiyaa! Hida haraagi khayri daqa Yeesuge heedi gwaa slaqwa tingara⁄uudu, tay duguũ qaatisi rawaa gu falage. Yeesu giyaa ilii arimi hida hhakee konay ⁄imbaraa da didiru daqa dosii, gi tosaa kaay sa heedikee gwaa tingara⁄uudu tuba, “Ye nankoy, hanguu ⁄atliside! Tlakwaroo doogu sliimaa dagaã ilamooyimi!” ");
INSERT INTO bds_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Qatlay maarimamaa angaamaka da sariyaa giyaa ilii akhasiri Yeesu hiĩ kaay teesaaqay, gi tlaatleesiri ilahudaa inay kilakoina tuba, “Heediki hiĩ belendeqesi Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeesu yaa caahhi ilahudaa koina, gi kaay sa inay tuba, “Sa soꞌoyi ilahudeedemisiday gimba gu tlaku muunaiĩ kokunay? ");
INSERT INTO bds_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gimba haloo na slaahhi hari khisla, kaawaraa tuba, ‘Tlakwaroo doogu sliimaa dagaa ilamooyimi,’ baku kaawaraa tuba, ‘Tlayii, la waauta?’ ");
INSERT INTO bds_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Inkoo, ana slaꞌa unkuray, ma caahhadiri tuba, Nanku Heedi kona ⁄uuru gu tawaaloo guri ilamooyiru tlakwaroo da hida tiꞌii khoorotii!” Teꞌesii Yeesu gi kaay sa heedikira gwaa tingara⁄uudu tuba, “Suguũ kaay, tlayii, oyii buburuu googu, la waauta ayage!” ");
INSERT INTO bds_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Da hheꞌesi, heedikee gi qadidi ge⁄e pandaa da hida sliimaage, gi watli ayage. ");
INSERT INTO bds_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hida sliimaa giyaa ilii aniri teesaaqay, yaa bakairi haa yaa tlaꞌamuudiri hari khisla! Inay gi hhaꞌaleesiri Iliitleemu gwaa hadisu hiidahhasa da teesaaqay slanqasa daqa hidage. ");
INSERT INTO bds_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeesu yaa waaudi teꞌesaa, amooge gi arimi karaanii gwaa hiikurunkuriirima koodi oofisi dosii, uma gosi na Mataayo, hiĩ ibiidi teꞌesii. Yeesu gi kaay sa ina tuba, “Hanisirakonte!” Mataayo gii tlay, gugi tosaa sirakoomi. ");
INSERT INTO bds_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Da hheꞌesi, Mataayo yaa kwahhasuusi Yeesu aya gosii. Inkoo, qatlay giyaa ilii ⁄agiigine ⁄agoo, karaanimaiĩ wa⁄a gwaa hiikurunkuriirimee koodi haa hida wakinay gu koomee tlakwaroo yaa khayri teꞌesii. Gonkoinaa yaa ⁄agiiginay ⁄agoo sliimaa haa Yeesu haa sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisaayoo giyaa ilii aniri Yeesu ⁄agina haa hida hhakee, gi maasiri sirakoomiisee dosi tuba, “Maarimuu googuna sa soꞌoyi ⁄agiiginay sliimaa haa karaanimaiĩ goó hiikurunkurimee koodi haa hida hhakee gu koomee tlakwaroo?” ");
INSERT INTO bds_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesu giyaa ilii akhasi gimbakee, gi ilaki⁄isi inay tuba, “Hida gu koomee slaqoo gu hhoi yoó slaiyaaiiba dareesimoo, hhakaꞌa gu koomee ga⁄ay noó slaiyay. ");
INSERT INTO bds_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Inkoo, taa⁄amida hangu caacaahhamisidee maꞌaana da Handikaa da Iliitleemu doó kaawa tuba, ‘Ana ⁄awaariru guni slaꞌa, sadaaka doogunaaba da da⁄araa.’ Inkoo, ana hanti khayiiba sa eteeda hida hhakaꞌa gungoó hiiarimee tuba, ibinaa dooina yaa tafaꞌadi, hanti khay sa eteediru gu hida hhakaꞌa gu koomee tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Da hheꞌesi, sirakoomiisee da Yohaana Hiinunqudimiisay yaagi khayri daqa Yeesuge, gugi maasiri tuba, “Dandiray haa raqa da Farisaayoo hoóti mayna ⁄agoo haa kitahhu, goó firiirine Iliitleemu. Sirakoomiisee doogu soó soꞌoyi mayay teesaaqay laqaraa?” ");
INSERT INTO bds_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu gi ilaki⁄isi inay tuba, “Dahaa gu heedi guũ khabimu, malee hiidahhasiyay gaiida qatlay heedi guũ khabimu tosaa wana haa inay? Inkoo, balalu maa dayay, teꞌesii heedi gwaa khabimu dugurimaa waaudi daqa dooinaa. Teꞌesii inay maa asu mayay ⁄agoo haa kitahhu see.” ");
INSERT INTO bds_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yeesu gi ilakoomi gimba tuba, “Hhaku heedi lensee goó hiidaqa qayru gwaa faaku hari dahhamu gu ⁄abu. Bere teesaaqay laqi, qayrukira gwaa faaku kwanda gi feehhidiye daqateesaa dingii daqige, kara qayrukee feehhidi hari khisla ba⁄ay da wakaꞌalee see. ");
INSERT INTO bds_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nama teesaaqay leẽ, hhaku heedi lensee goó hiieesa difaay da ⁄abi waꞌay gu curuqu daa boo⁄imisi hari fala da segi da iliiqaasa difaaytee. Bere teesaaqay laqi, difaaytee da ⁄abi, qatlay giyoo ilii mahhaaꞌade, kwanda gii feehhimiside faloo hhakee gonkoinaa. Kara difaaytee goõ tuutuquta haã faloo hhakee see slime yooti tlakwaakwayay. Difaay da ⁄abi dagoó waꞌay gu faloo gu ⁄abige hiieesi, hari amotee difaay haa curuqeerii hhakee gu faloo, yoóti ba⁄anay.” ");
INSERT INTO bds_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeesu giyaa ilii cocaacoiye gimbakee, yuꞌudiyaa, yaagi khay giyaadimiisay waku, gi keebeeidi pandaa dosii. Giyaadimiisaykee gugi tlaatlaqasi ina tuba, “Taataa, sagameeriya doyi hiĩ hhanti inkootuutuu. Inkoo, hhooa poo, laga iliiqaasa kayda daba googu, ina ma slafidi.” ");
INSERT INTO bds_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gii tlayri gi sirakoniri giyaadimiisaykee. ");
INSERT INTO bds_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yuꞌudiyaa! Hadee waka yaagii ta⁄ati teꞌesii, daa ilahufimaamidiye ha ga⁄ay gwii caca⁄uu ceedee slaqwa dosaa koraraa mibi haa cada. Ina yaagi sirakonti Yeesu aluũ kosaa, gi nangusidi somborokimoo gu qayru gosi. ");
INSERT INTO bds_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ina yaa teesaaqay laqadi, sa gimba yaati ilahudeesidi muuna gosii tuba, “Bere hati nangusa kilesi somborokimoo gu qayru gosi, hhoaw sumuku.” ");
INSERT INTO bds_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Teꞌesii Yeesu giyaa ilii fookidi, gigi arimi haa gi kaay sa ina tuba, “De hotoyi, hangi muuna hii⁄atliside! Igi ⁄imba doogi daqa dooii nigiĩ hhoeesi.” Nama qatlaykeesii lenge, hadetee gi hhoaydi. ");
INSERT INTO bds_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Qatlay Yeesu giyaa ilii day mara gu giyaadimiisaykeesii, yaa arimi gaiidiisee daa hiifahhaahhama tureeree da ⁄aa⁄iya haa hida wakinay gaiidiyay hari afoo da didiri. ");
INSERT INTO bds_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ina gi kaay sa inay tuba, “Waauda tiaa! Sagameeriyati hiĩ gwaꞌatiiba, hinti qati kilesi.” Inay gugi qasayri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Teꞌesii raqa da hida dagaa iliica⁄asi, Yeesu gii day sagayge, gi ooyi daba gu sagameeriyatee, ina gi tosaa hiitlaydi. ");
INSERT INTO bds_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gimbaki gii qoomi hhapetee sliimaa. ");
INSERT INTO bds_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeesu giyaa ilii waaudi teꞌesaa, hida cada gwaa ilaa hhamaahhamee gwaa sirakoniri, tay tooinaa maahhaminay tuba, “Nanku Dawdi, sandi ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Qatlay Yeesu giyaa ilii day waꞌay gu marage hida hhakee gwaa ilaa hhamaahhamee gwaa sirakoniri ina waꞌayge. Yeesu gigi maasi inay tuba, “⁄imbidaaii tuba, hanguu dahhasa hhoeesa?” Inay gugi ilaki⁄isiri ina tuba, “Ee Looimoo gu Goõ.” ");
INSERT INTO bds_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Da hheꞌesi, Yeesu gi nangumisi ilaa koina haa gi kaay tuba, “Da teesaaqay tleehhidiye daqa doogunay, idoo gaã ilii ⁄imbidiri gooay.” ");
INSERT INTO bds_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ilaa koina digigi tlaaꞌasi. Yeesu gigi ilakaay hari dihhay tuba, “Hhanti kaaday sa heedi lensee gimbaki.” ");
INSERT INTO bds_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Teesaaqay see, inay giyaa ilii waaudiri teꞌesaa, yaatii qoomeesa kayri gimba gosi hhapeteesii sliimaa. ");
INSERT INTO bds_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hida hhakee giyaa ilii waauuꞌumidiyee, hida wakinay hiraagi khayri daqa Yeesuge heedi gwaa afana⁄adu, sa gimba dugwaa ilii khaabaaꞌadi ha gieeri. ");
INSERT INTO bds_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Qatlay Yeesu giyaa iliica⁄asi gieerikee, heedikee gwaa afana⁄adu kara gi tlaatleesi cocoꞌomoo. Raqatee da hida yaa bakaꞌadi haa gi kaayri tuba, “Gimba da hiĩ gooay dugu kahhi arimaa Israeelige.” ");
INSERT INTO bds_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farisaayoo gi kaadi tuba, “Ina, hintii ca⁄aa⁄amisi gieeri hari ⁄uuru gu Belisebuuli, hiĩ gu didiru ba⁄ay da gieeri goõ!” ");
INSERT INTO bds_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Da hheꞌesi, Yeesu yaa ilakhookhocimi yaamu haa tongagu goõ tay tosaa caacaahhamisi sinagoogaguuge. Kara ina gi kakaami Gimba gu Hhou gu Tawaaloo da Iliitleemu haa gi hhoeemisi ga⁄ay haa amaaiya paslaapasloo. ");
INSERT INTO bds_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yeesu giyaa ilii arimi raqa da hida, gi ⁄awaarimi sa inay, sa gimba giyaa arimi inay ti bee⁄ukaꞌa pahha goóba deꞌemiisay, daa labaꞌasi haa goóba slawaraa iliiawaraa. ");
INSERT INTO bds_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Da hheꞌesi, gi kaay sa sirakoomiisee dosi tuba, “Baruũ gu buꞌuru ti wa⁄a, yondimiisee ti coko⁄o. ");
INSERT INTO bds_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Inkoo, firima Looay gu qaymoo, ma ya⁄abi yondimiisee waka qaymoo dosii.” ");
INSERT INTO bds_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Letu waka, Yeesu gi ⁄oo⁄i sirakoomiisee dosi mibi haa cada daqa lenge, sigigi qay ⁄uuru gu tawaaloo sarii ca⁄amisuu gieeri daqa hidago haa sari hhoeemisu ga⁄ay haa amaaiya goõ. ");
INSERT INTO bds_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Umaiĩ gu ya⁄abimiisetee gu mibi haa cada giyaa hiileehhi na nahhaã: Simooni (hiĩ daraa ayi uma gu caduu na Peetiro), Andareyaa hhia gosi gu Peetiro, Yakoobo haa Yohaana yaꞌay gu Sebedaayo, ");
INSERT INTO bds_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiipo, Batolimaayo, Toomaasi, Mataayo karaanimoo gu koodi, Yakoobo nanku Alifaayo, Tadaayo, ");
INSERT INTO bds_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simooni gu raqa da Seloote, haa Yuuda Isikariyooti. Qariqaaqari hiĩ naa hiifookidi Yeesu gugi taatahhi dabaiĩ gu fa⁄ayaage. ");
INSERT INTO bds_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ya⁄abimiisetee da mibi haa cada, Yeesu giyaa ya⁄abi, sigigi ilakaay gimbaki tuba, “Hhanti hada kayday daqa hida gu hhapapu wakinayge ma hiiguuma see hhantii guntay yaamu lensee gu hida gu Samariyaage. ");
INSERT INTO bds_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Inkoo, unkuray ti ilii hadakawuu kilesi hida gu Israeeli gwaa hhamee bee⁄ukaꞌa pahha goóba deꞌemiisay. ");
INSERT INTO bds_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Qatlay ga ilii hada kaydee, kakaama taqay tuba, ‘Tawaaloo da rawaa gu raw yaani daadaausidi.’ ");
INSERT INTO bds_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hhoeemisa ga⁄iidee, hida gwaa kaka⁄ee slafisakina, hida gu koomee buubaa ilabuuslakini haa ca⁄amisaw gieeri. Unkuray ⁄uuruki sliimaa gwaati slaydiri hari ihiĩꞌi, slime unkuray see haymisa hari ihiĩꞌi. ");
INSERT INTO bds_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hhanti hubitay curuqeerii kokunay peesay, sahaabu, feesa ma ⁄aray see. ");
INSERT INTO bds_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kara, hhanti hubitay curuquu hhiyuuma doogunay ma kanchoo da cadii, ma ye⁄eetoo, ma hhadaa see. Yondimiisay haraatii boo⁄i slawaraa ⁄agoo dosi. ");
INSERT INTO bds_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Qatlay goo ilii guntee yaamuge baku tongoo wakay, dabiida heedi guraa hiiboo⁄u kwahhasuusa unkuray, laa teꞌesii lenge ibitay, maati amoo waautay yaamu hhakeesaa. ");
INSERT INTO bds_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mara dangoó ilii kwahhasuusiye, la cehheemisiday hida goó teꞌesii ibiidee. ");
INSERT INTO bds_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bere, hida gu marakee haraa hiiboo⁄iri kwahhasuusa unkuray, firima Iliitleemu ma sigi qay qasaw inay. Bere kwahhasuusiyaaiiba unkuray, dangwaa ilii ki⁄i ha qasawkee. ");
INSERT INTO bds_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bere heedi lensee himaa kwahhasuusiyaaba, ma itatiisa see hhaka gimba googuna, qatlay gamaa ilii waautee teꞌesaa, lamaati gaagahhaday ceceiya da yeꞌeeroo kokuna. ");
INSERT INTO bds_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gu lou, sangu kaay unkuray ambee, baloteesii da hukumuu, Iliitleemu maa ⁄agitina hari khisla hida gu yaamu hhakee ba⁄ay da ⁄agitiru gu yaamu gu Sodomaa haa Gomoora see!” ");
INSERT INTO bds_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yeesu gi ilakoomi gimba tuba, “Itatiisa! Unkuray hanguti ya⁄aba bee⁄u pahha tla⁄aã gu takuraaꞌage. Inkoo, slaw waaway deesu pahha, haa ibiida aslaaꞌamee tlaba pahha! ");
INSERT INTO bds_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kara, hangu ga⁄aydee naraꞌa haa hida, sa gimba inay hangumaa ooyinayi, hangumaa leehhimisiyay pandaa da balasasuu koinay, kara hangumaa difiyay sinagoogaguu koinay. ");
INSERT INTO bds_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Unkuray dangumaa leehhimisi pandaa da magafanage haa watemige, sa gimba gooi, mani ilatlaydiri ana daqa dooinay haa pandaa da hida gu hhapapu wakinayge. ");
INSERT INTO bds_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Qatlay gimaa ilii leehhisiyee unkuray balasasuu koinay, hamaa hhanti tlaꞌamutay gimba mala gunimaa kaawa kayday baku idoo gamaa ilii kaadee pandaa da hida hhakeesii. Qatlaykeesii sangumaa qay gimba gamaa gimbuusidee. ");
INSERT INTO bds_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Unkuray gooba namaa gimbuusiday, ti Muuna gu Taataa googuna Iliitleemu, namaa gimbuusi waꞌay kokunay. ");
INSERT INTO bds_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hhia maa hiifookidi hhia gosi loi daqa fa⁄ayaa dosii, ma dugu gaasi. Ayi maa hiifookidi nankosi, ma dugu gaasi. Kara, yaꞌay see maa siꞌiyay ayiĩ koina haã amu koina see, girimaati amoo dayay cu⁄udunge. ");
INSERT INTO bds_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hida sliimaa himaa wakiyay unkuray, sa gimba gu uma goy. Inkoo hhakaꞌa gumaa hiikaasee naraꞌa balalu sliimaa hiifaakoo naqatloo, hhakee diginimaa ilabuꞌuna ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hida gimaa ilii labaꞌasiyee unkuray yaamu wakay, lamaati lakitay yaamu wakinayge. Gu lou, sangu kaay, hamaa hiifaakisidaaiiba hhiyuuma dooguna yaamu sliimaa gu Israeelige, Nanku Heedi gi ilii kahhiye khaymuu. ");
INSERT INTO bds_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Heedi goó somima yoó hiicatiyaaba maarimuu gosi ma yondimiisay see yoó hiicatiyaaba looimoo gosi. ");
INSERT INTO bds_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bere heedi goó somima hindii gaasi somaa, hiidahhasi maarimuu gosi pahha tleehhida. Kara, nama teesaaqay yondimiisay see looimoo gosi tleehhidi. Bere hiĩ eteediri looimoo gu mara uma na Belisebuuli, eteediyay hida gu marakee, slime umaiĩ gu tlakwi hari khisla!” ");
INSERT INTO bds_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yeesu gi ilakoomi gimba tuba, “Inkoo, hhanti tlaꞌamutay hida goó slaee ilaqaꞌadu unkuray, hhaku gimba lensee daa yakwi, damaa maye hiitlaaꞌasa ha Iliitleemu. Kara hhaku gimba daa yakwi damaa maye caahha. ");
INSERT INTO bds_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Inkoo, gimba sliimaa sangu cocaacoe unkuray hhanteege, unkuray kakaamakuna cenceege. Kara gimba sliimaa goó akhamisidee dugu saasahhamidi, kakaamakuna hari afoo da didiri pembebu gu maraaigo. ");
INSERT INTO bds_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hhanti tlaꞌamutay hida goó cu⁄ee slaqoo kilesi, hiidahhasiyaaiiba cu⁄uduũ muunaiĩ. Unkuray tlaꞌamuuda ina gu hiidahhasa hhamisaraa slaqwa haa muuna aslaa doóba hhamaraa Jehanaamuge. ");
INSERT INTO bds_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Cira⁄oo cada da digidakwi, dagoóti naadinaabaslii hari goboree leẽ kilesi? Teesaaqay see, hhaka lensee doó gwaaꞌa, bere Taataa goori Iliitleemu guba ⁄imbaraa. ");
INSERT INTO bds_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kara, quubu gu sagaiĩ kokuna see dugwaa faadi. ");
INSERT INTO bds_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Inkoo, hhanti tlaꞌamutay! Unkuray hanguti kaari ba⁄ay da cira⁄oo wa⁄a see! ");
INSERT INTO bds_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Heedi goó ⁄imba ana pandaa da hidage, ana see gu ⁄imba pandaa da Taataa gooii, Iliitleemu gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Inkoo, heedi gumaa tlanka ana pandaa da hidage, ana see gumaati tlanka pandaa da Taataa gooii Iliitleemu gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Unkuray hhanti ilatahhaday tuba, ana hanti khay sa leehhisa da qasaw khoorotii. Teesaaqay gooba! Ti qasaw gooba, ti qwatla. ");
INSERT INTO bds_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ana haranti khay deehhoo tla⁄aã gu naw haa taataa gosi, hotu haa iyoo dosi, slime hadee da naw haa kumboꞌoo. ");
INSERT INTO bds_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kara, fa⁄ayaa da heedi, maati hida hhakaꞌa gu aya gosi loi. ");
INSERT INTO bds_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Heedi gu slaꞌa taataa gosi baku iyoo dosi ba⁄ay da slaꞌaraa ana, hiraa hiiboo⁄iiba sirakoomiisay goy tleehhida. Kara, heedi gu slaꞌa nankosi baku hotosi ba⁄ay da ana, hiraa hiiboo⁄iiba sirakoomiisay goy tleehhida. ");
INSERT INTO bds_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kara, heedi goóba hiiowaraa musalaaba gosi haa naagi sirakona ana, hikee haraa hiiboo⁄iiba sirakoomiisay goy tleehhida. ");
INSERT INTO bds_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gu lou, heedikaꞌa gu slaꞌa ilabuꞌuru ibinaa dosi higimaa hhamisi. Heedikaꞌa gu hhamisa ibinaa dosi sa ana, higimaa slay ibinaa dosi. ");
INSERT INTO bds_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Heedikaꞌa goó kwahhasuusa unkuray, ana ginoó kwahhasuusi. Kara hikee goó kwahhasuusa ana, ina yoó kwahhasuusi Iliitleemu, gwaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Slime heedi goó kwahhasuusa tletimiisay, sa gimba tletimiisay gimba gu Iliitleemu ginoó kakaana, slime ina himaa slay daqa Iliitleemugo ⁄aliya da tletimiisay. Kara, heedi goó kwahhasuusa heedi gu kooma ibinaa daa tafaꞌadi, sa gimba kona ibinaa daa tafaꞌadi, slime ina himaa slay daqa Iliitleemugo ⁄aliya da heedikee pahha gu kooma ibinaa daa tafaꞌadi. ");
INSERT INTO bds_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sangu kaay, heedi gumaa hadisa gimati qulu⁄uu gu maꞌay sa leẽ gu hida hhanki doóba muriida tla⁄aã gu sirakoomiisee dooii, sa gimba ti sirakoomiisay goy, gu lou, heedikee dakusiyaaba slawa ⁄aliya dosi daqa Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeesu giyaa ilii hheꞌesi cocoꞌomoo ilakaawatee daqa sirakoomiisee dosi da mibi haa cada, yaa waaudi teꞌesaa, gi caacaahhamisu kay haa gi kakaaru kay yaamu wakinay gu hhapeteesii. ");
INSERT INTO bds_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohaana Hiinunqudimiisay giyaa ilii jeerage wane, yaa akhasi gimbakee daa yondimaamidiye ha Kristu. Teesaaqay, ina gi ya⁄abi sirakoomiisee dosi daqa Kristuge, ");
INSERT INTO bds_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","magu maasiri ina tuba, “Ugu na inaa Masiiya gwaa khakhaakhawa baku waku guni baqadana?” ");
INSERT INTO bds_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu gi ilaki⁄isi inay tuba, “Taa⁄amida ki⁄a, la kaaday sa Yohaana gimba ga akhaakhamisidee haa ga ariirintee. ");
INSERT INTO bds_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hida gwaa ilaa hhamaahhamee khuꞌuuꞌunay, gwaa yeꞌeeroo tlakwaakwawee khociicinay, gu koomee buubaa digi ilabuslaaslidi, qapanimaiĩ akhaakhamisiyayi, gwaa kaka⁄ee digi slafimaamisi haa kwaeeli sigi kakaakana Gimba gu Hhou. ");
INSERT INTO bds_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kara dugwaa ⁄aafi ha Iliitleemu heedikaꞌa goóba mawaraa ⁄imbaraa ana.” ");
INSERT INTO bds_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Qariqaaqari sirakoomiisee da Yohaana giyaa ilii waaudiri, Yeesu gi tlaatleesi cocoꞌomoo daqa raqa da hidage gimba gu Yohaana. Ina gi kaay tuba, “Ilahudeesa, unkuray gaa ilii hada kaydiri kongoqomeege, ma antiri Yohaana, haa mala slaꞌaday arimaa? Ti cikwahhagoo doó rinqirinqimisiye ha caaqwa? ");
INSERT INTO bds_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bere teesaaqay gooba, haã mala arimaa kaydiri? Heedi gwaa daamisugoo qayroo gu hhoii? Teesaaqay gooba, hida goó daamisee qayroo daa kirigi hari peesay wa⁄a, inay yoóti ibiidiyay maraai gu watemige! ");
INSERT INTO bds_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Inkoo, haã mala arimaa kaydiri? Tletimiisay goo? Gu lou! Unkuray sangu kaawa ambee, Yohaana guti didiru ba⁄ay da tletimiisay see. ");
INSERT INTO bds_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Heediki na hikira daa handikimi Handikaa da Iliitleemuge tuba, ‘Yuꞌudiyaa, ana ya⁄aba ya⁄abimiisay goy, ina sugu giyaadi, ma hiinaꞌa kay amoo sa ugu.’ ");
INSERT INTO bds_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gu lou, ana sangu kaawa unkuray ambee, ‘Tla⁄aã gu hida sliimaage daa laqwali hhaku gu didiru da Yohaana Hiinunqudimiisay gooay. Teesaaqay see, heedikaꞌa doó faadiye gu coko⁄o loi Tawaaloo da rawaa gu rawge guti didiru ba⁄ay da Yohaana.’ ");
INSERT INTO bds_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tlaatleesi qatlaykaꞌaa gu Yohaana Hiinunqudimiisay giyaa ilii kakaami letuti naqatloo, Tawaaloo da rawaa gu raw dagoóti ilii tlaꞌadi hari khisla. Kara, hida gu koomee ⁄uuru yoóti koimisiyay hii⁄utlaraa tawaalotee hari ⁄uuru. ");
INSERT INTO bds_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Caacaahhamisu goõ gu tletimiisee haa sariyaa da Musaa dagaa kakaami qatlaykaꞌa naqatloo gu Yohaana. ");
INSERT INTO bds_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bere unkuray slaꞌaday ⁄imba gimbaki, Yohaana na Eliyaa pahha hiĩ khawaraa dosi daa tletimi. ");
INSERT INTO bds_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ina gu kooma eaa, akhasiye naraꞌa gimbaki! ");
INSERT INTO bds_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Laqwaloti da inkoo, hanguri idoo mala gooay ilaꞌaaꞌaatisa? Inay ti daaqay hhakaꞌa pahha goó ibiidee sokooniige, tay tooinaa eteedinay danaee koina tuba, ");
INSERT INTO bds_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Sangwaa hiifahhani firimbii, haa seehhusidiriiba! Sangwaa raaꞌani raaꞌamee da gaiidimoo, haa ⁄aa⁄adiriiba!’ ");
INSERT INTO bds_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohaana Hiinunqudimiisay yaa khay, yaa ⁄agiiginaaba mukaate ma kitahhu see difaay. Teesaaqay see, inay gi kaayri tuba, ‘Dugwaa ilii khaabaaꞌadi ha gieeri.’ ");
INSERT INTO bds_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nanku Heedi yaani khay, ina ⁄agiigina haa kitahhaahhana, inay gi kaayri tuba, ‘Yuꞌudiyaa, hheehhiisayki haa oonimiisay, danaꞌa gu karaanimaiĩ goó hiikurunkurimee koodi haa gu hida gu koomee tlakwaroo!’ Teesaaqay see, waaway gu Iliitleemu duguũ ilatahhi tuba, guti lou hari amoo da yondu gosi.” ");
INSERT INTO bds_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Da hheꞌesi, Yeesu gi tlaatleesi ilii⁄oo⁄a yaamu hhakee, giyaa ilii yondiidi yondu wa⁄a gu denu gwaa bakaꞌasu hida. Yaa teesaaqay laqi, sa gimba yaamu hhakee yaa hiifookidiriiba daqa Iliitleemuge tlakwaroo dooinaa. ");
INSERT INTO bds_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ina gi kaay tuba, “Hoo antayi, unkuray hida gu yaamu gu Korasiini haa hida gu yaamu gu Betisayda! Yondu gu denu daa yondiidi gwaa bakaꞌasu hida, bere dugwaati aloo yondiida yaamu gu Tiiroge haa Sidooni, hida gu yaamu hhakee yaa aloo hiifookidiyay daqa Iliitleemuge tlakwaroo dooinaa gu segi. Inay yaa aloo teesaaqay laqiyay, tay hiĩ tooinaa daamisiri guniyayuu haa gi ibiidiyay ⁄urage. ");
INSERT INTO bds_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Inkoo, sangu kaawa unkuray ambee, baloo Iliitleemu gimaa ilii hukune khooroo, unkuray ⁄agitiru googuna gumaa dihhu ba⁄ay da hikee see gu hida gu Tiiro haa Sidooni. ");
INSERT INTO bds_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ye, hida gu Kaperinauumu, goo ilatahhadee, dangutii tlaysiyaa raw naqatloo? Teesaaqay gooba! Unkuray dangutii ⁄eetisi khonsleebaa naqatloo. Sa gimba bere yondu gu denu gwaa bakaꞌasu hida, daa yondiidi daqa doogunay dugunaa aloo yondiidi yade Sodomaage, yaamu gu Sodomaa yaa aloo wanay letuti naqatloo. ");
INSERT INTO bds_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Teesaaqay see, sangu kaay unkuray tuba, baloo Iliitleemu gimaa ilii hukune khooroo, unkuray ⁄agitiru googuna gumaa dihhu ba⁄ay da hida gu Sodomaa!” ");
INSERT INTO bds_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nama qatlaykeesii lenge, Yeesu gi kaay tuba, “Ye, Taataa hagu hhaꞌaleesa, ugu Looimoo gu raw haa khooroo! Gimbaki gwaa yakwidi sa hida gu koomee waaway haa gwaa somimee, gugii tlaaꞌasidi sa hida gu digidakwi. ");
INSERT INTO bds_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Naraꞌa, Taataa, sa gimba ugu dugwaa teesaaqay muunaboo⁄eesi. ");
INSERT INTO bds_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Taataa gooi siniĩ taatahhi idadu sliimaa. Hhaku heedi goó khua Naw naraꞌa, Taataa gosi kilesi nugoó khui. Kara, Taataa see hhaku heedi gu khua naraꞌa, Naw kilesi nugoó khui haa hida hhakaꞌa Naw giyoo iliislaiye hiitlaaꞌasa. ");
INSERT INTO bds_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Khocaa daqa dooii unkuray gonkokunaa goó toodoriidee haa daa ilii ciilooidi yondu gu hiiloou, ana sangu hadisa hiifiifisa. ");
INSERT INTO bds_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Unkuray ⁄imba yondu sangoó hiitleke⁄ese ana, hangu caacaahhamisidee daqa dooaa. Maꞌaana ana hoóti aslaaꞌamee ibiida haa kooma murumuꞌuuma muunage. Inkoo, unkuray slayday hiifiifisa muunaiĩ kokunay. ");
INSERT INTO bds_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yondu gooi goó hiitiiꞌidee gutii loouuba, kara gutii slaahhuslaahhu.” ");
INSERT INTO bds_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Letu waka baloo da Sabaato, Yeesu haa sirakoomiisee dosi yaa hiicatiri hari tla⁄aã gu qaymamuu gu ganoo. Qatlaykee sirakoomiisee dosi yaa qoriimidiri gi tlaatleesidi kereꞌemisu sagaiĩ gu ganoo, gi tooinaa ⁄aginay. ");
INSERT INTO bds_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Inkoo, Farisaayoo gwaa waaree teꞌesii giyaa ilii aniri gimbakee, gi kaayri sa Yeesu, tuba, “Yuꞌudiyaa, sirakoomiisee doogu soꞌoyi yondimaamita yondu daa kitlakuusi sariyaage baloo da Sabaatoge!” ");
INSERT INTO bds_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Teꞌesii Yeesu gi ilaki⁄isi sa inay tuba, “Haa somintiriibaslii gimba gu Iliitleemuge, idoo Dawdi giyaa laqi ina haa hida kosi qatlay giyaa ilii qoriimidiri? ");
INSERT INTO bds_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ina yaa hiiday mara gu Iliitleemuge, ina haa hida kosi gi ⁄aginiri mukaate daa qaasi pandaa da Iliitleemu. Mukaatetee dagaa kitlakuusi ⁄agoo heedi lensee, ti hhapalooee kilesi naa ⁄agiiginay. ");
INSERT INTO bds_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Baku haa somintiriiba kitaabuu gu sariyaa da Musaage tuba, kila baloo da Sabaato hhapalooee goó yondiidee mara gu didiruge gu Iliitleemu, yoóti slasla⁄uudiisiyay baloo da Sabaato. Teesaaqay see, digoó faadiyaabaslii tuba, konay dakoo? ");
INSERT INTO bds_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inkoo, unkuray sangu kaawa ambee, tiꞌii wana heedi leẽ gu didiru ba⁄ay da mara gu didiru see gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bere haati aloo caahhaday maꞌaana da Handikati da Iliitleemu doó kaawa tuba, ‘Ana ⁄awaariru guni slaꞌa, sadaaka doogunaaba da da⁄araa,’ unkuray haa aloo ilawaasidaaiiba hida hhanki gooba dakoo. ");
INSERT INTO bds_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Inkoo, Nanku Heedi, na Looimoo gu baloo da Sabaato.” ");
INSERT INTO bds_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Da hheꞌesi, Yeesu yaa waaudi teꞌesaa, gii guuma kay sinagoogige. ");
INSERT INTO bds_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Teꞌesii yaa wana heedi waku daba gosi gwaa tingara⁄uudu. Farisaayoo yaati khuꞌuuꞌunay Yeesu naraꞌa, ma slayri amoo dari sitaakiru. Inay gugi maasiri Yeesu tuba, “Ti kitlakuubaslii sariyaage hhoeꞌesa heedi baloo da Sabaatoilee?” ");
INSERT INTO bds_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeesu gigi ilaki⁄isi inay tuba, “Inkoo, bere leẽ tla⁄aã googunay bee⁄imoo gosi hingii huui bondage, gii ca⁄asiyaabaslii ciraai gimati baloo da Sabaato? ");
INSERT INTO bds_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Guti lou, heedi guti kaaru hari khisla ba⁄ay da bee⁄imoo! Inkoo, ti kitlakuu sariyaage yondu hhoinay baloo da Sabaatoilee.” ");
INSERT INTO bds_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Da hheꞌesi, gi kaay sa heedikee tuba, “Tafaꞌasi daba googu!” Heedikee gi tosaa tafaꞌasi daba gosi, cirakiray lenge dugugi hhoeesi sumuku gi hikira gu caduu pahha tleehhidi. ");
INSERT INTO bds_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Teꞌesaa Farisaayoo gii ca⁄iri sinagoogiteesaa, higi tlaatleesa kayri idara inay haa inay, idoo gi ilii gaasiyee Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeesu giyaa ilii caahhi Farisaayoo idoo giyaa ilakhuukhuꞌuuꞌumisiyee, gi waaudi daqateesaa. Hida wa⁄a gugi sirakoniri, ina gi hhoeemisi ga⁄iidee goõ. ");
INSERT INTO bds_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Teꞌesii Yeesu gigi ilii⁄oo⁄i inay, ma mayri kaawaraa sa hida ina na miyaa. ");
INSERT INTO bds_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Gimbaki yaa teesaaqay hiica⁄i, dama hiigaasi gimbakira daa kaay hari amoo da tletimiisay Isaaya tuba, ");
INSERT INTO bds_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yuꞌudiyaa! Hiĩ na yondimiisay goy gwaa hiileehhi. Ina ga slae, haa dinaa muunaboo⁄eesi hari khisla ha ina. Ana sugu hadisa ina Muuna goy, ina ma kakaami haaki dooi daqa hida gu hhapapu sliimaa. ");
INSERT INTO bds_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ina naanaqiyaaba haa hida, ma maahharaa see, gimati afoo dosi see daga akhasiyaaba balabalaage. ");
INSERT INTO bds_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yondimiisay goy qeetisiyaaba cikwahhiya daa tlupi pahha. Kara, ina hhamisiyaaba mumbaalakaꞌa goó eehha, hida maati amoolaa caahhiyay tuba, ina yoóti yondiidi gimba gu haaki. ");
INSERT INTO bds_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kara, hida gu hhapapu sliimaa himaati iliipaꞌanay ina.” ");
INSERT INTO bds_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Da hheꞌesi hida haraagi khayri daqa Yeesuge heedi daa ilii khaabaaꞌadi gieeri, haa yaa ilahhami haa afana⁄adi. Yeesu gugi hhoeesi, ina gii dahhasi cocoꞌomoo haa khuꞌuduũ. ");
INSERT INTO bds_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Raqa goõ da hida yaati bakaꞌadi, hingigi maamisiri inay haa inay tuba, “Angamalee, hiĩ ti na Nanku Dawdi.” ");
INSERT INTO bds_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Teꞌesii, Farisaayoo giyaa ilii akhasiri gimbakee, gi kaayri tuba, “Ina, gieeri giyoótii ca⁄amisi hari ⁄uuru gu Belisebuuli, hiĩ gu didiri sa gieeri goõ!” ");
INSERT INTO bds_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Inkoo, Yeesu yaa caahhi ilahudaa koina, gi kaay sa inay tuba, “Bere hida gu hhapee leẽ hingii deehhiniri raqoo haa raqoo, haa gi qwaqwatlinay inay haa inay, hhapee dooina gi hhamisiyay. Kara, bere hida gu yaamu leẽ baku hida gu mara leẽ hingii deehhiihhiniri raqoo haa raqoo, ⁄uuru gu hida hhakee see hiikaaiyaaba, tii faaki goõ. ");
INSERT INTO bds_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nama amotee leẽ, bere Sataanimoo gusina Sataanimoo, ina loi hingii deehhimi, tawaaloo dosi malee qadita? ");
INSERT INTO bds_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bere guti lou, ana hoótii ca⁄amisa gieeri harii dahhasa da Belisebuuli, hida kokuna haroó hiidahhasa da miyaa hiica⁄amisiyay gieeri? Teesaaqay, inay loi himaa hukunay unkuray. ");
INSERT INTO bds_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Inkoo, bere ana gieeri giyoótii ca⁄amisa hari ⁄uuru gu Muuna gu Iliitleemu, gimbaki ti laqaaqana tuba, unkuray dangwaani ilii khay ha Tawaaloo da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kara, bere heedi slai cihharaa mara gu heedi gu kooma ⁄uuru, magu afafiisi khooslay gosi, kwanda hiti gesaa khiidina heedikee gu kooma ⁄uuru. Teꞌesii gi asu fiisi idadu sliimaa gi kone. ");
INSERT INTO bds_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Heedi gu hhaku hari bara dooi, hikee hinoóti kanimisi. Kara heedi goóba hiikurunkura hida daqa dooii, yoóti pasidimisi. ");
INSERT INTO bds_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Inkoo, sangu kaawa unkuray ambee, hida digi ilamooyina ha Iliitleemu tlakwaroo dooina goõ, haã gimba gooina see gonkosaa gu belendeqesa Iliitleemu. Hiĩ gumaa belendeqesa Muuna gu Iliitleemu, tlakwarotee tosi dagamaa ilamooyinaaba coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kara, heedi gu kaawa gimba goó kanimisa Nanku Heedi, Iliitleemu gi ilamooyina ina. Inkoo, heedi gu belendeqesa Muuna gu Iliitleemu, ina dugu ilamooyinaaba coko⁄o seei ha Iliitleemu, ibinaa da inkooge ma ibinaa daa khocage. ");
INSERT INTO bds_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ilatahha, khaimoo gu hhou yoóti ⁄aamuudi ⁄aamu gu hhou. Nama teesaaqay, khaimoo gu tlaku, yoóti ⁄aamuudi ⁄aamu gu tlaku. Khaimoo dugoóti baraslayi hari ⁄aamu gosi. ");
INSERT INTO bds_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ye, unkuray laqwaloo da deesasee gu koomee qada! Ha malee hiidahhasiday kawaa gimba gu hhou, tay unkuray hoóti yonditay tlakwaroo? Sa gimba heedi, yoóti gimbuusi gimbakaꞌa gwaa hacu muuna gosii. ");
INSERT INTO bds_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nama teesaaqay, heedi gu hhou hari ibinaa dosi yoótii ca⁄asi gimba gu hhou muuna gosaa. Slime heedi gu tlaku hari ibinaa dosi yoótii ca⁄asi gimba gu tlaku muuna gosaa. ");
INSERT INTO bds_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Gu lou, ana sangu kaay, baloo da hukumuuge, Iliitleemu maa hukuna hida sa gimba sliimaa gu tlaku giyaa gimbuusiri. ");
INSERT INTO bds_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maꞌaana hari gimba googu dugumaa faadi konta haaki ha Iliitleemu, haa hari gimba googu dugumaa hukuna.” ");
INSERT INTO bds_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Da hheꞌesi, Farisaayoo wakinay haa maarimamaa da sariyaa, gi kaayri sa Yeesu tuba, “Maarimuu slaꞌana sandima laqanti gimba leẽ gu kaaru gwaa daqa doogu dahha.” ");
INSERT INTO bds_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ina gigi ilaki⁄isi inay tuba, “Laqwaloo da hida gu tlakwi haa gwaa slipalauumidee, inay ti slaiyay, sigima laqami gimba gu kaaru. Inkoo, inay sigi laqanaaba gimba lensee gu kaaru, sigi hikira kilesi laqana gu tletimiisay Yoona. ");
INSERT INTO bds_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoona goóay yaa ibiidi balalu tami waꞌay gu guraꞌa gu samaakimoo gu didiru tleemaa haa amasi. Nama teesaaqay leẽ, Nanku Heedi himaa ibiidi waꞌay gu ayisa daa hiikhuri maraiyage balalu tami tleemaa haa amasi. ");
INSERT INTO bds_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Slime balotee da hukumuu hida gu Ninaawi, maa qadidiyay sliimaa haa hida gu laqwaloti, gi kaayay tuba, hida gu laqwaloti digi ilawaasiye. Sa gimba hida hhanki gu Ninaawi, qatlay sigaa ilii kaay gimba gu Iliitleemu ha Yoona, gii fookidiri daqa Iliitleemuge tlakwaroo dooinaa! Inkoo, tiꞌii wana heedi gu didiru ba⁄ay da Yoona see! ");
INSERT INTO bds_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nama teesaaqay leẽ, baloteesii malikiyaa da hhapee da Seeba, maa qadita tay kakanta tuba, laqwaloti da inkoo, daga ilawaamisi ha Iliitleemu sa dakoo dooina. Sa gimba malikiyatee, yaa hhiyuti yadaa hhapee da segeẽ loaa, ma itatiisidi waaway gu Solomooni. Inkoo, tiꞌii wana heedi gu didiru ba⁄ay da Solomooni see, teesaaqay see unkuray goó itatiisidaaiiba! ");
INSERT INTO bds_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Qatlay gieeri dugoó ilii ca⁄asiye daqa heedigo, yoóti niini⁄imidi hhapee da kaaruuge, dabiidi daqa da ilii fiifisa. Ina yoó slayaaba daqa, ");
INSERT INTO bds_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","teꞌesii yoóti kaay tuba, ‘Inkoo, ha ki⁄a marakiray kooii, gaa ilii ibimaamide.’ Qatlay giyoó iliiki⁄iye teꞌesii, yoóti slay mara gosi konaaba idoo lensee, duguũ fiici haa duguũ tlemi naraꞌa. ");
INSERT INTO bds_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Da hheꞌesi, gieeri yoóti waaudi haa hiraagi khay gieeri wakinay fanqu gu tlakwi hari khisla ba⁄ay da ina see. Gieeri hhakee goõ gugi iliigunay heedikee haa gi ibiidiyay daqa dosii. Teesaaqay, heedikee ibinaa dosi yoóti tlakwaakwayda hari khisla ba⁄ay da hatira da tlaatleesoo see. Daganimaa ilii wana daqa laqwalotii da tlakwi.” ");
INSERT INTO bds_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Qatlay Yeesu giyaa ilii kahhiye cocoꞌomooge haa raqatee da hida, iyoo dosi haa hhiee kosi yaagi khayri, gi qadimidiri khoorooge, slaiyay cocoꞌomoo haa ina. ");
INSERT INTO bds_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Heedi waku gi kaay sa ina tuba, “Yuꞌudiyaa, iyoo doogu haa hhiee koku khoorooge wanay hiĩ qadimidiri, slaiyay cocoꞌomoo haa ugu.” ");
INSERT INTO bds_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeesu gi ilaki⁄isi heedikira tuba, “Hoó malee ilahudeesiday, iyoo dooi na miyaa, haa hhiee koi niĩ miyaa?” ");
INSERT INTO bds_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Teꞌesii, gii laqasi daba gosi yade khuꞌusa daqa sirakoomiisee dosii, haa gi kaay tuba, “Yuꞌudiyaa, hhaã na amu koi haa hhiee koi! ");
INSERT INTO bds_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kila heedi goó iliikooma yondiida slaꞌamuu gu Taataa gooi gu rawaa gu raw, hikee na hhia gooi, hhioo dooi haa iyoo dooi.” ");
INSERT INTO bds_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nama balotee leẽ, Yeesu gii ca⁄i waꞌay gu marago, gi tosaa ibinaa kay kenga gu tlawa da didirige da Galilaaya. ");
INSERT INTO bds_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Raqa da didiri loi da hida yaagii kurunkuriti daqa dosii, gi ilii raagiti ina. Sa gimbakee Yeesu gii dawa kay masuwaa wakayge, gi ibiidi teꞌesii. Raqatee da hida gi qaditi kenga gu tlawage. ");
INSERT INTO bds_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Da hheꞌesi, ina gi kakaami gimba wa⁄a hari ilaꞌaaꞌaatimisu tuba, “Itatiisa! Dooslimiisay waku yaa wana gi waaudi qaymoo dosii sa wincalaakharu kawa pisagaroo dosi. ");
INSERT INTO bds_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Qatlay giyaa ilii wincalaakhaakhane, pisagaroo waka gi huhuꞌudi amooge, cira⁄oo yaagi khaydi, gi tosaa noꞌonti goõ. ");
INSERT INTO bds_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pisagaroo waka gi huhuꞌudi gurumaasiyage, daqa daa iliiwane tipa coko⁄o kilesi. Pisagarotee yaagi cira tiꞌiti teꞌesii, sa gimba daqatee yaa kontaaba tipa wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Inkoo, tleemaa da dihhi giyaa iliida⁄adi, barukee gwaa tiꞌidu gi tosaa moomooi, kara gi tosaa sluhhi, sa gimba kibeeri yaa konaaiiba daqa da iliimuta naraꞌa. ");
INSERT INTO bds_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pisagaroo waka gi huhuꞌudi tla⁄aã gu slanslawriige. Qatlay giyaa ilii tiꞌiti, slanslawrikee gi cira dinaraaray, gi ilaslaabi barukee. ");
INSERT INTO bds_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kara, pisagaroo waka gi huhuꞌudi hhapee da hhoige dii looi. Pisagarotee gi tiꞌiti, gi dinaraaraydi naraꞌa, goo⁄u waku gi laqwali waa mibeeri mibi, waku waa mibeeri lahhoꞌo, haa waku waa mibeeri tami. ");
INSERT INTO bds_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ina gu kooma eaa, akhasiye naraꞌa gimbaki.” ");
INSERT INTO bds_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Da hheꞌesi, sirakoomiisee dosi gugi maasiri ina tuba, “Ha soꞌoyi caacaahhaahhamisida hida hari amoo da ilaꞌaaꞌaatimisu?” ");
INSERT INTO bds_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ina gigi ilaki⁄isi inay tuba, “Unkuray dangwaa pihhi caahharaa siiri da Tawaaloo da rawaa gu raw. Inay digaa pihhiiba. ");
INSERT INTO bds_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Heedi gu kooma gimba gu Iliitleemu, ina sugumaa hiiroogisi hari khisla haa maa kona wa⁄a. Hikaꞌa goóba caahha gimbakee, gimati koomi see caahharatee da coko⁄o, dugoóti afii⁄utli daqa dosaa. ");
INSERT INTO bds_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Haã na idoo sa giimaamise haa inay hari ilaꞌaaꞌaatimisu, sa gimba giyoómati khuꞌuniri see, yoó anaaiiba. Kara, giyoómati akhamisiyayi see, yoó akhasiyaaiiba, ma caahharaa see. ");
INSERT INTO bds_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Daqa dooinay gimbakira gu Iliitleemu giyaa kaay hari amoo da tletimiisay Isaaya dugungii gaasi tuba, ‘Gu lou, akhamisu maa akhamisidayi, gimati teesaaqay see, etaa hamaa caahhadaaiiba. Kara, khuꞌuru maa khuꞌuntay, gimati teesaaqay see, etaa hamaa antaaiiba. ");
INSERT INTO bds_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Muunaiĩ gu hida hhanki yaa karaarahhiri. Kara, eaa koina giyaa tuntukiri, haa yaa guumuuꞌudisiri ilaa koina. Bere teesaaqay gooba, yaa aloo arinayi hari ilaa koina, yaa akhasiyayi hari eaa koina, haa yaa caahhiyay hari waaway gooina, haa hinigi iliifookidiyay ana Iliitleemu, ana giyaa aloo hhoeesa.’ ");
INSERT INTO bds_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Inkoo, Iliitleemu hangwaa ⁄aafi unkuray, sa gimba ilaa kokuna yoó arinayi haa eaa kokuna yoó akhamisiyayi. ");
INSERT INTO bds_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gu lou, sangu kaay tletimiisee wa⁄a haa hida wa⁄a gu koomee ibinaa daa tafaꞌadi, yaa konay kwayru gu arimaa gimbakee ga ariirintee, inay giyaa aniriiba. Slime yaa konay kwayru gu akhamisu gimbaki ga akhaakhamiside unkuray, inay giyaa akhasiriiba.” ");
INSERT INTO bds_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Inkoo, Yeesu gi kaay sa inay tuba, “Itatiisa! Maꞌaana da ilaꞌaaꞌaatisatee da dooslimiisay na nahaã. ");
INSERT INTO bds_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Qatlay heedi giyoó ilii akhasiye gimba gu Iliitleemu, gi may caahha, Sataanimoo yoóti cira khay haa gi tosaa hiica⁄asi gimbakira muunaiĩ koinaa. Heedi da hiĩ gooay, dugoóti ilaꞌaaꞌaatisi haa pisagaroo daa huhuꞌudi amooge. ");
INSERT INTO bds_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pisagarotee daa huhuꞌudi gurimaasiya da kooma hhafida hari waꞌay kosi, ti heedikaꞌa pahha goó akhamisa gimba gu Iliitleemu haa gugi cira ooyi hari hhaꞌaloo. ");
INSERT INTO bds_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Teesaaqay see, ina giyoóti ⁄imbi qatlay coko⁄o kilesi, maꞌaana ina ti barukaꞌa pahha kibeeri kosi goóba muta waꞌayge. Qatlay dugoó ilii khaye ilahufidu baku labaꞌasu sa gimbakee, ina yoóti cira may ⁄imbaraa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kara, pisagarotira daa huhuꞌudi slanslawriige, ti ilaꞌaaꞌaatisa da heedikaꞌa pahha, goó akhamisa gimba gu Iliitleemu, qariqaaqari dugoóti ilaslaabi ha toodora da khooroti, haa hiicoridu gu hindaqaruumaa. Sa gimbakee gimba gu Iliitleemu yoó slayaaba ⁄aamu. ");
INSERT INTO bds_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Inkoo, pisagarotaꞌa daa huhuꞌudi hhapee da hhoige dii looi, ti heedikaꞌa pahha goó akhamisa gimba gu Iliitleemu haa gugi caahhi naraꞌa. Ina na heedikaꞌa goó slawa ⁄aamu waa mibeeri mibi, waa mibeeri lahhoꞌo, baku waa mibeeri tami.” ");
INSERT INTO bds_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu gi kara kaay ilaꞌaaꞌaatisa waka tuba, “Tawaaloo da rawaa gu raw dagoóti hiidahhasi ilaꞌaaꞌaatisa haa heedi gwaa daamisu pisagaroo da hhoi pahha qaymoo dosii. ");
INSERT INTO bds_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Inkoo, letu waka hari amasi, qatlay hida giyaa ilii qaaqaatiri, fa⁄ayaa gosi yaagi khay, gi daamisi efenferee tla⁄aã gu qaymoo da ganooge, gi tosaa waaudi. ");
INSERT INTO bds_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Qatlay ganoo giyaa ilii tiꞌidi haa gi dinaraaray, giyaa ilii tlaatleesi laqwaloo, da hheꞌesi slime daay ca⁄i efenferee. ");
INSERT INTO bds_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tongee da looaykee gu qaymoo gi hadakayri daqa looay gooinay, sugugi kaayri ina tuba, ‘Looimoo goori, ugu haati daamisidi pisagaroo da hhoi kilesi qaymoo dooguu. Inkoo, efenferee yaani kaalaa hiica⁄adi?’ ");
INSERT INTO bds_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ina gigi ilaki⁄isi inay tuba, ‘Ti fa⁄ayaa niĩ teesaaqay laqi.’ Da hheꞌesi, tongetee tosi gugi maasiri ina tuba, ‘Inkoo, ugu slaꞌadaa dandiray maga tu⁄uru kayni?’ ");
INSERT INTO bds_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kara, looimoo gooina gigi ilaki⁄isi inay tuba, ‘Hhanti tu⁄uru kayday, hoo ba⁄atii tu⁄untay ganoo sliimaa haa efenferee. ");
INSERT INTO bds_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Maw ganoo haa efenferee, ma dinaraarayri sliimaa qatlay gu buꞌuru naqatloo. Qatlaykeesii hida gumaa buꞌumee sigimaa kaawa ambee, tu⁄uma gesaa efenferee, khiidima kana upaiĩ haa upaiĩ, maga da⁄ani. Da hheꞌesi, ganoo laga hiikurunkuriday, laga qaasa kayday kuugiya dooii da didirige.’ ");
INSERT INTO bds_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tawaaloo da rawaa gu raw pisagariya da haradaali pahha slanqasi, daa hiioy ha heedi waku, gigi daasaraa kay qaymoo dosii. ");
INSERT INTO bds_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pisagariyati dati coko⁄i hari khisla tla⁄aã gu pisagaroo sliimaage. Teesaaqay see, bere dagaã daamisi gi tiꞌita, gu lou yoóti diirayda hari khisla ba⁄ay da baruũ goõ see. Kara, yoóti diiray gi khaimoo gu didiru tleehhita, cira⁄oo yoóti amoolaa khayda gi tleehheda cuuraiĩ koina daqa elemu kosii. ");
INSERT INTO bds_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tawaaloo da rawaa gu raw hamiira pahha slanqasi, daa hiioy ha hadee waka, gigii roogidi sliimaa haa debabuu tami gu gubaraa gu ganoo, da hheꞌesi gubarakee goõ gi tosaa sluufi.” ");
INSERT INTO bds_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeesu yaati kakaami sa raqoo gu hida gimbakee sliimaa hari ilaꞌaaꞌaatimisu. Ina yaa kakaamiiba gimba lensee sa inay, gi may amotee da ilaꞌaaꞌaatisa haa idoo waka. ");
INSERT INTO bds_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gimbakee dugwaa hiigaasi daa kaay ha tletimiisay Isaaya tuba, “Hati kakaama sa inay hari amoo da ilaꞌaaꞌaatimisu, sigitii ca⁄asa gimba, daa yakwi yadaa loaa tlehhinay gu khoorotaa.” ");
INSERT INTO bds_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Da hheꞌesi, Yeesu yaa aareesi raqatee da hida, gi tosaa hiiday waꞌay gu marage. Sirakoomiisee dosi gugi ilii hadakayri ina, sugugi kaayri tuba, “Sandi ilakeeside maꞌaana da ilaꞌaaꞌaatisatira da efenferee da qaymooge waara.” ");
INSERT INTO bds_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeesu gigi ilaki⁄isi inay tuba, “Dooslimiisay gwaa daamisu pisagaroo da hhoi ti Nanku Heedi. ");
INSERT INTO bds_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Qaymoo ti khooroti. Pisagaroo da hhoi ti hida hhakaꞌa doó tawaaline ha Iliitleemu. Efenferee ti hida hhakaꞌa doó tawaaline ha Biriisimokira. ");
INSERT INTO bds_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Fa⁄ayaa gwaa daamisu efenferetee ti Biriisimoo. Buꞌuruu ti hiifaakoo da khooroo, hida goó buꞌumee ti malayika. ");
INSERT INTO bds_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Inkoo, idoo doó ilii tu⁄une gooay efenferee haa dagagi da⁄i aslaage, slime daganimaa ilii wana qatlay gu hiifaakoo da khooroo. ");
INSERT INTO bds_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nanku Heedi himaa ya⁄abi malayika dosi, maa hiikurunkuriri Tawaaloo da Iliitleemugo idadu sliimaa, goó ⁄isimee hida wakinay, ma hiihuuiri tlakwarooge haa hida goõ goó kanimisee sariyaa. ");
INSERT INTO bds_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Inay himaa tooinaa hiikwahhiyay hida hhakee waꞌay gu tanuuri da aslaage. Teꞌesii, himaati ⁄aa⁄iyay haa himaati tluꞌunay ⁄atloo. ");
INSERT INTO bds_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Da hheꞌesi, hhakee gu koomee ibinaa daa tafaꞌadi, himaati wanqiyay letu pahha daqa tawaaloo da Taataa gooinay. Heedi gu kooma eaa, akhasiye naraꞌa gimbaki. ");
INSERT INTO bds_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tawaaloo da rawaa gu raw ti idoo da kaari pahha daa yakwi qaymooge. Idotee dagaa ilii slay ha heedi waku, ina see giyaa kara yakwi. Ina hhaꞌaloo dosii gi naadiru kay khooslay gosi goõ giyaa kone, gi tosaa kirigi qaymotee. ");
INSERT INTO bds_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kara, Tawaaloo da rawaa gu raw ti heedi goó kirigima haa goó naadima slanqasi, hiĩ goó dabiida tlaa⁄u gu kaaru loi. ");
INSERT INTO bds_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Qatlay giyaa ilii slay tlaa⁄u leẽ gu kaaru hari khisla, yaa waaudi gi naadiru kay khooslay gosi goõ giyaa kone, gi kirigi tlaa⁄ukee gu kaaru. ");
INSERT INTO bds_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kara, Tawaaloo da rawaa gu raw ti makumbaa da samaakii pahha, daa hiikwahhi waꞌay gu tlawa da didirige, gi ooyinti samaakii paslaapasloo. ");
INSERT INTO bds_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Qatlay makumbatee giyaa ilii hacidi samaakii, hida goó ooyimee samaakii, gigi tooinaa duukhiri kenga gu tlawateesii. Da hheꞌesi gi tooinaa ibiidiri sa hiilehhidu gu samaakii gu hhou. Samaakikee gu hhou gi tooinaa gii slaslakhiri waꞌay gu kapapuu koinay, haa gi kwakwahhiri samaakii gu tlaku. ");
INSERT INTO bds_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Teesaaqay daganimaa ilii wana hiifaakoo da khooroo. Malayika maa khayda, maa paslisiyay hida gu koomee ibinaa da tlakwi haa gu koomee ibinaa daa tafaꞌadi. ");
INSERT INTO bds_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Da hheꞌesi, malayikatee maa hiikwahhada hida gu koomee ibinaa da tlakwi waꞌay gu tanuuru da aslaage. Teꞌesii, inay himaati ⁄aa⁄iyay haa himaati tluꞌunay ⁄atloo.” ");
INSERT INTO bds_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Teꞌesii Yeesu gi maasi sirakoomiisee dosi tuba, “Unkuray gimbakee sliimaa guũ caahhadirii?” Inay gugi ilaki⁄isiri tuba, “Ee guũ caahhani.” ");
INSERT INTO bds_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Da hheꞌesi gi kaay daqa dooinay tuba, “Inkoo, maarimuu gu sariyaa goó oowa gimba gu Tawaaloo da rawaa gu raw ti looay gu mara pahha, goó hiica⁄asa kitangeeriya dosaa idadu gu kaari gu ⁄abi haa gu segi.” ");
INSERT INTO bds_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeesu giyaa ilii hheꞌesi kakaaru ilaꞌaaꞌaatimisukee, yaa waaudi teꞌesaa yaamu hhakeesaa, ");
INSERT INTO bds_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yaa ki⁄i Nasareetige, tongoo giyaa ilii diray. Teꞌesii yaa tlaatleesi caacaahhamisu hida sinagoogi dooinay. Hida wa⁄a gwaa akhasee ina yaati bakairi, hingigi maamisiri inay haa inay tuba, “Heediki yaani kaalaa slay waawayki haa yonduki gu denu goó bakaꞌasa hida taqay dee? ");
INSERT INTO bds_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hiĩ caba ti nanku dakwidiisaykira? Iyoo dosi caba daganoó eteedina Mariyaa? Hhiee kosi caba niĩ Yakoobo, Yoseefu, Simooni haa Yuuda? ");
INSERT INTO bds_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kara, hhiee kosi gu tigay caba yoó sliimaa ibiidiyay tiꞌii haa dandiray? Inkoo, gimbaki sliimaa giyaani kalaa slay?” ");
INSERT INTO bds_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Teꞌesii gi slahhaahhaairi hari khisla sa ina, gugi siꞌiri. Yeesu gi kaay sa inay tuba, “Tletimiisay yoóti dakusiyaaba muree daqeemoo sliimaa gi kaye, muretee giyoó slayaaba yaamu kosii haa mara gosii!” ");
INSERT INTO bds_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yeesu yaa yondiidiiba yondu wa⁄a gu denu gwaa bakaꞌasu hida Nasareetige, sa gimba inay gwaa ⁄imbiriiba ina. ");
INSERT INTO bds_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Qatlaykeesii Heroode Antipaasi, mutemi gu hhapee da Galilaaya, yaa akhasi gimba gu Yeesu, giyaa yondimaamidiye. ");
INSERT INTO bds_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Heroode gi kaay sa yondimiisee dosi tuba, “Hiĩ ti Yohaana Hiinunqudimiisay, yaani slafi yaagii ca⁄i ayisago! Sagani kona ⁄uuru guri yondiida yondu gu denu goó bakaꞌasa hida.” ");
INSERT INTO bds_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ansailee, Heroode yaa khabimi Heroodiiya, hadee da Filiipo hhia gosi loi. Yohaana yaa ilii⁄oo⁄i ina gi kaay tuba, “Ti naraꞌaaba sariyaa da Iliitleemuge ugu ibinaa haa hadetee!” Teesaaqay, Heroode yaa ya⁄abi sirikaarii dosi, ma dugwaa ooyi Yohaana, ma dugu khiidimi jeerage. ");
INSERT INTO bds_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroode giyaamati slai see gaasa Yohaana, ina yaa tlaꞌamuudi hida, sa gimba inay gwaa ilahudeesiri tuba, Yohaana ti tletimiisay. ");
INSERT INTO bds_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Qatlay gu baloo da losona gu hiislawaraa da hiidawaraa da Heroode, hotosi da Heroodiiya yaa seehhuusidi pandaa da Heroodege haa dahaa kosii. Seehha dosi yaa muunaboo⁄eesidi hari khisla Heroode, ");
INSERT INTO bds_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yaati amoolaa hiifadidi hari seeliru daqa dosii tuba, saga haysi idoo lensee gi slaꞌade firoo daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hari amoo da hiifaafahha ha iyoo dosi, sagameeriyatee gi kaadi sa Heroode tuba, “Sini hadiside tiꞌii saga gu Yohaana Hiinunqudimiisay siniyaage.” ");
INSERT INTO bds_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ina mutemi yaa slahhaai hari khisla. Teesaaqay see, sa gimba gu seelirukira giyaa seelimi pandaa da dahaa kosii, yaa ilafahhi, ma saga hadisi idoo giyaa firinti. ");
INSERT INTO bds_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Heroode gi tosaa ya⁄abi sirikaarimoo waku jeerage, gi isa kereꞌesa kay saga gu Yohaana Hiinunqudimiisay. ");
INSERT INTO bds_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Saga gosi duguraagi tosaa khay siniyaage, dugugi tosaa hadisi sa sagameeriyatee. Da hheꞌesi, ina gugi tosaa leehhisidi sa iyoo dosi. ");
INSERT INTO bds_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sirakoomiisee da Yohaana Hiinunqudimiisay giyaa ilii akhasiri gimbakee, yaagi khayri jeerage gi tooinaa hiioyiri slaqwa dosi, gigi qaasiri. Da hheꞌesi, gi kaawa kayri gimbakee sa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Qatlay Yeesu giyaa ilii akhasi tuba, Yohaana Hiinunqudimiisay duguũ gaasi, gi tosaa hiiday masuwaage, gi waaudi daqa daaba hida. Raqoo gu hida gi akhasiri daqa giyaa khuꞌusi, gugi sirakoniri hari yeꞌeeroo teꞌesaa yaamu koinaa. ");
INSERT INTO bds_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Qatlay Yeesu giyaa ilii day, gii ⁄eeti kenga gu tlawateesii. Yeesu gi arimi raqa da didiri da hida, gi ⁄awaarimi sa inay. Teꞌesii gi hhoeemisi ga⁄iidee dooina. ");
INSERT INTO bds_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Inkoo, daa iliikhwayauudi, sirakoomiisee dosi gi hadakayri daqa Yeesuge, sugugi kaayri tuba, “Tiꞌii ti hatlige wana haa letu see slaꞌada hiihuua. Aareesi hida hhanki, ma waaudiri tongagu gu ilaciyaa, ma sangii kiriga kayri ⁄agoo.” ");
INSERT INTO bds_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Teꞌesii, Yeesu gigi ilaki⁄isi inay tuba, “Ti kwanda gooba gi waaudiyee, unkuray sigi qaydeei ⁄agoo!” ");
INSERT INTO bds_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Inay gugi ilaki⁄isiri ina tuba, “Dandiray mukaatee kooani haa samaakii cada kilesi guni kona.” ");
INSERT INTO bds_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeesu sigigi kaay inay tuba, “Sinaa hiioodee tiꞌii.” ");
INSERT INTO bds_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ina gi ilafahhi raqatee da hida, ma ibiti hhapeege daqa daa iliiwane sluufaa. Da hheꞌesi, Yeesu gii oyi mukaatetira da kooani haa samaakikira gu cada, gi ganaꞌasi ilaa kosi rawaa gu rawge, gi daareesi Iliitleemu sa ⁄agotee. Ina gigi fandakumisi mukaatetee haa samaakikira, gi haymisi sa sirakoomiisee dosi, inay ma hadimisiri sa raqatee da hida. ");
INSERT INTO bds_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hida hhakee goõ yaa ⁄aginiri, gi akhaakhaniri naraꞌa. Qatlay giyaa ilii hheꞌesiri ⁄agoo, sirakoomiisee da Yeesu yaagii kurunkuriri ⁄agotira daa meti, gi hacimisiri kapapuu mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hhawatee gwaa ⁄agimee ⁄agotee, faadoo dooina yaa elefu kooani, tigay haa daaqay digaa ilafaadiiba. ");
INSERT INTO bds_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cirakiray lenge, Yeesu gi kaay sa sirakoomiisee dosi, ma hiiguniri masuwaage, ma giyaadiri sa ina hari bara da cadii da tlawa da didiri da Galilaaya. Qatlaykee Yeesu yaa aareeremisi raqatee da hida. ");
INSERT INTO bds_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Qariqaaqari giyaa ilii hheꞌesi aareemisu gu hida hhakee, ina gi tosaa ilakhiinaaꞌadi onke ina lenkosi, ma firoo kay Iliitleemu taysi. Qatlay daa ilii hhayahhayuudi, ina yaa teꞌesii wana ina lenkosi. ");
INSERT INTO bds_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qatlaykeesii masuwatee yaa daadi segenge tla⁄aã gu tlawage. Masuwatee dagaati tlupaapidi ha gondadee gu deni, sa gimba caaqwa da dihhi yaa wanta daa kaniinimisa pandaa dooinaa. ");
INSERT INTO bds_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Qatlay gu taaboo⁄a⁄aa daa aloo iliislaiye pisaraa, Yeesu gi hadakay daqa dooinay, gi khoci hari rawaa gu maꞌay gu tlawatee da didiri. ");
INSERT INTO bds_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sirakoomiisee dosi gwaa ilii aniri, ina yaa khoci hari rawaa gu maꞌay, yaa tlaꞌamuudiri hari khisla, gi kaayri tuba, “Hiĩ ti iliitleemimoo!” Inay gi cunqusiri hari amaaoo. ");
INSERT INTO bds_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Teꞌesii cirakiray lenge Yeesu gi kaay daqa dooinay tuba, “Karahhasa muunaiĩ kokuna, hari hhantii tlaꞌaday, ti ana!” ");
INSERT INTO bds_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peetiro gugi ilaki⁄isi ina tuba, “Looimoo gu Goõ, bere ti ugu gu lou, sini kaade, maa khay daqa dooguu, hari amoo da khocu rawaa gu maꞌayge.” ");
INSERT INTO bds_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu gi kaay sa ina tuba, “Khoca.” Da hheꞌesi, Peetiro yaagii ⁄eeti waꞌay gu masuwaago, gi tlaatleesi khocu hari rawaa gu maꞌay, gi ilii hadakay Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Inkoo, Peetiro giyaa ilii arimi caaqwatira da dihhi, dugugi ilii guumi ha amaaoo, gi tlaatleesi hiihhama waꞌay gu maꞌayge. Teꞌesii ina gi maahhi tuba, “Looimoo gu Goõ, hani ilabuꞌunte.” ");
INSERT INTO bds_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Cirakiray lenge, Yeesu gi tafaꞌasi daba gosi, gugi ooyi haa sugugi kaay tuba, “Ye ugu gu kooma ⁄imbaraa coko⁄u! Siĩ soꞌoyi maydi ⁄imbaraa?” ");
INSERT INTO bds_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Da hheꞌesi, Yeesu haa Peetiro giyaa ilii guniri masuwaa dooinay, caaqwatira gi tosaa kaanahhasidi. ");
INSERT INTO bds_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sirakoomiisetee waka daa waꞌay gu masuwaage waara, gii gupu⁄umisiri pandadu koina pandaa da Yeesuge, tay tooinaa kakaanay tuba, “Gu lou, ugu ti Nanku Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Qatlay Yeesu haa sirakoomiisee dosi giyaa ilii hheꞌesiri tlo⁄osa tlawa da didiri, gi dayri hhapee da Genesareetige. ");
INSERT INTO bds_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hida gu hhapetee giyaa ilii baraslayiri tuba, hiĩ mati Yeesu, gi leehhisiri ya⁄aboo daqa hida gu daqeemoo sliimaa gwaa ilaciyaa waaree haa daqatee. Teꞌesii hida yaagi geregediniri daqa Yeesuge ga⁄iidee goõ. ");
INSERT INTO bds_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Inay gugi tlaatlaqasiri, ga⁄iidee ma nangumisiri ma somborokimoo gu qayru gosi kilesi see. Kara, hida goõ gwaa nangumisee ina yaa hhoaaꞌayri. ");
INSERT INTO bds_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Da hheꞌesi, maarimamaa waka da sariyaa haa Farisaayoo yaa khayri yadaa yaamu gu Yerusaleemugo, inay gi ilii hadakayri Yeesu, gugi maasiri tuba, ");
INSERT INTO bds_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sirakoomiisee doogu soó soꞌoyi mayay ilakooma caacaahhamisu gu ou gu okookoiĩ koti? Sa gimba inay yoó hhunciyaaiiba dabaiĩ koina gesaa sa ⁄agoo!” ");
INSERT INTO bds_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeesu gigi ilaki⁄isi inay tuba, “Unkuray see, hoó soꞌoyi iliiqaasidaaiiba ilakaawa da Iliitleemu, sa gimba gu caacaahhamisu gu ou googuna? ");
INSERT INTO bds_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iliitleemu yaa kaay tuba, ‘Muriidi taataa googu haa iyoo doogu.’ Kara, gi kaay tuba, ‘Hiĩ goó wahaahama taataa gosi gimati iyoo dosi dugu gaasiye.’ ");
INSERT INTO bds_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Teesaaqay see, unkuray hoó caacaahhamisiday tuba, bere heedi hiĩ kaay sa taataa gosi gimati iyoo dosi see tuba, ‘Idadu koi goõ giyaa iliipaꞌantiri slawaraa daqa dooaa, giyaa hheꞌesi giyaa hadisi sa Iliitleemu.’ ");
INSERT INTO bds_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Teꞌesii ina haraa hiiboo⁄iiba kara muriida taataa gosi haa iyoo dosi. Taqay unkuray hoóti qooqitay gimba gu Iliitleemu sa caacaahhamisu gu ou googuna. ");
INSERT INTO bds_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ye, unkuray peereehhiisee! Gimbakira daa tletimi sa unkuray ha Isaaya tletimiisay gu Iliitleemu guti lou tuba, ");
INSERT INTO bds_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hida hhanki hinoóti muriidiyay hari gimba gu afaiĩ koina kilesi, tay muunaiĩ koina tooinaa segenge loi wanay haa ana. ");
INSERT INTO bds_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Inay hinoóti daareesiyay ana Iliitleemu diitiray, yoóti caacaahhamisiyay hida, ma ooyiri ilakaawa dooina ubee, sariyaa da Iliitleemu pahha.’ ” ");
INSERT INTO bds_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Da hheꞌesi, Yeesu gi eteedi raqatee da hida, gi kaay sa inay tuba, “Hani itatiisidee naraꞌa, kara gimbaki lugu ooday naraꞌa. ");
INSERT INTO bds_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hhaka idoo lensee doó hiidawa hari afa doó ⁄isima slasla⁄iima daqa heedige pandaa da Iliitleemuge. Gu lou, ti idotaꞌa kilesi doó hiica⁄a afago, noó ⁄isinta slasla⁄iima.” ");
INSERT INTO bds_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Da hheꞌesi, sirakoomiisee dosi yaagi khaydi sugugi kaayri ina tuba, “Ugu khuꞌudaa tuba, Farisaayoo giĩ ilii akhasiri gimba googu, digiĩ slahhaaꞌasi?” ");
INSERT INTO bds_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeesu gigi ilaki⁄isi inay tuba, “Baruũ daa daamisiiba ha Taataa goy gu rawaa gu rawge waara, dugumaa tu⁄una.” ");
INSERT INTO bds_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yeesu slime gi kaay sa inay tuba, “Mawakini, inay ti giyaadimiisaykaꞌa pahha gwaa ilahhamu, hiidahhasiyaaba giyaadaraa sa danaꞌa gosi gwaa ilahhamu. Gu lou, gonkoinaa hiihuhuiyay bondage.” ");
INSERT INTO bds_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peetiro gi kaay sa Yeesu tuba, “Sandi ilakeeside ilaꞌaaꞌaatisatee gaã kaadi.” ");
INSERT INTO bds_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kara, Yeesu gi ilaki⁄isi sirakoomiisee dosi tuba, “Inkoo, unkuray see slime kahhadaaii caahha? ");
INSERT INTO bds_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Unkuray kahhadaaii caahha tuba, ⁄agoo doó ⁄agine heedi yoóti guraꞌa gosi kilesi kayda, qariqaaqari yaagi kara tosii hiica⁄ada slaqwa dosaa? ");
INSERT INTO bds_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Teesaaqay see, gimba sliimaa goó hiica⁄a afa gu heedigo, yoó waꞌay gu muuna dahhi, hikee naroó khay slasla⁄iima daqa dosii pandaa da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Waꞌay gu muunago daganoó ilii dahhi ilahudaa gu tlakwi, cu⁄uduũ, slipalauumaa, slahhaahhaau gu tlaku, fiisa, ilatlatlaw gu afaꞌafuuma haa wahaaharu. ");
INSERT INTO bds_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gimbakee naroó khay slasla⁄iima daqa heedige. Inkoo, ⁄agiru ⁄agoo kahhada hhuncidaa see dabaiĩ, haroó khaydaaba slasla⁄iima daqa heedige pandaa da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gi tooinaa waaudiri teꞌesaa, gi yade khuꞌusiri bara da yaamu gu Tiiro haa Sidooni. ");
INSERT INTO bds_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yuꞌudiyaa, teꞌesii yaa wanta hadee waka Kanaanitoꞌoo, daa ibimaamida ilaciyaa haa yaamu hhakee, yaagi khaydi daqa Yeesuge. Ina gi maahhadi, kakanta tuba, “Ye Looimoo gu Goõ, Nanku Dawdi, sini ⁄awaarinte! Hotoyi dagaã ilii khaabaaꞌadi gieeri haa gi ilahufimaamidi hari khisla.” ");
INSERT INTO bds_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Teesaaqay see, Yeesu giyaa ilaki⁄isiiba gimba lensee hadetee. Da hheꞌesi, sirakoomiisee dosi gugi ilii hadakayri haa gugi tlaatlaqasiri ina tuba, “Kaay sa hadetee, ma waauti, maꞌaana hindi ilahufimaamita dandiray alunkotaa hari maahhoo dosi.” ");
INSERT INTO bds_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu gi ilaki⁄isi tuba, “Ana dinanti ya⁄abi kilesi daqa Waisraeeli gwaa hhamee bee⁄u pahha.” ");
INSERT INTO bds_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Inkoo, hadetee yaagi khaydi haa gi tosaa keebeeiti pandaa dosii, gi kaadi sa ina tuba, “Ye, Looimoo gu Goõ, hani iliiayde!” ");
INSERT INTO bds_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu gigi ilaki⁄isi ina tuba, “Ti naraꞌaaba hiiowaraa ⁄agoo da daaqay, dagagi tosaa hiikwahhi sa gwehheeri.” ");
INSERT INTO bds_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Teꞌesii hadetee gi ilaki⁄isidi tuba, “Taataa, guti lou! Gimati teesaaqay see, gwehheeri see yoó ⁄aginay ⁄agotaꞌa da daaqay, doó huhua rawaa gu meesaago.” ");
INSERT INTO bds_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Da hheꞌesi, Yeesu gi ilaki⁄isi tuba, “Iyoo igi ⁄imba doogi dati didiri! Inkoo, sigi teesaaqay laqiye gaã ilii firinti gooay.” Qatlaykeesii lenge, sagameeriyatira tosi tosaa hhoaydi. ");
INSERT INTO bds_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeesu gi waaudi teꞌesaa, gii cati hari kenga gu tlawa da didiri da Galilaaya, gi ilakhiinaaꞌadi onke, gi tosaa ibiidi taysi. ");
INSERT INTO bds_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Raqoo gu deni gu hida gwaagi ilii khayri, tay yaa tooinaa leehhimisiyay sa ina hida gwaa tlakwaakwawee, ilahhamaahhamee, qapanimaiĩ, gwaa afaiĩ na⁄amidee haa wakinay wa⁄a. Inay gigi tooinaa qaasiri pandaa da Yeesuge, ina gigi tosaa hhoeesi. ");
INSERT INTO bds_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Raqoo hhakee gu hida gi bakairi hari khisla, qatlay giyaa ilii aniri hida gwaa afaiĩ na⁄amidee cocoiyay, gwaa tlakwaakwawee hiĩ hhoaaꞌayri, gwaa yeꞌeeroo tlakwaakwawee khociyay haa gwaa ilahhamaahhamee khuꞌunay. Kara, inay gi daareesiri Iliitleemu gu Israeeli. ");
INSERT INTO bds_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Da hheꞌesi, Yeesu gi ⁄oo⁄i sirakoomiisee dosi, sigigi kaay inay tuba, “Ana haã ⁄awaarimi sa hida hhanki, sa gimba giĩ ibiidiri tiꞌii sliimaa haa ana balalu tami, kara konaaiiba idoo lensee diĩ meti da ⁄agoo. Bere inay giyoo aareesa, ma watliri hari qori, yoo slaqaaqanay amooge.” ");
INSERT INTO bds_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sirakoomiisee dosi gi ilaki⁄isiri sa ina tuba, “Inkoo, tiꞌii hatlikii ⁄agoo haga kaalaa slayna da buꞌudisa hida hhanki guti wa⁄a taqaaqay dee?” ");
INSERT INTO bds_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Teꞌesii Yeesu gigi maasi inay taai, “Unkuray mukaatee maka gana kontay?” Inay gi ilaki⁄isiri sa ina taai, “Mukaatee fanqu haa samaakii gu digidiidaku coko⁄o.” ");
INSERT INTO bds_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Da hheꞌesi, Yeesu gi kaay sa raqatee, ma ibiti hhapeege. ");
INSERT INTO bds_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Qatlay giyaa ilii ibiidiri, ina gi tosii hiioy mukaatetira da fanqu haa samaakikira, gi kaay ⁄iisoo daqa Iliitleemuge. Ina, gigi tosaa fandakumisi cokoocoko⁄o, gigi tosaa hadimisi sa sirakoomiisee dosi, inay gi hadimisiri sa hida ma ⁄aginiri. ");
INSERT INTO bds_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hida hhakee goõ yaa ⁄aginiri, yaati amoolaa akhaakhaniri naraꞌa. Qatlay giyaa ilii hheꞌesiri ⁄agoo, sirakoomiisee da Yeesu yaagii kurunkuriri ⁄agotira daa meti, gi hacimisiri kapapuu fanqu. ");
INSERT INTO bds_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hhawatee gwaa ⁄agimee ⁄agotee, faadoo dooina yaa elefu cigahha taqaaqay, tigay haa daaqay digaa ilafaadiiba. ");
INSERT INTO bds_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Qariqaaqari, Yeesu gi aareesi raqatee da hida, gii dadayri haa sirakoomiisee dosi masuwaage, gi waaudiri daqa wakay doó eteedine na Magadaanii. ");
INSERT INTO bds_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Da hheꞌesi, Farisaayoo haa Sadukaayoo yaa khayri daqa Yeesuge, tay konay piimaa da koisa ina. Inay gugi firiniri, ma sigi laqami gimba gu bakaꞌasa gwaa rawaa gu raw dahha. ");
INSERT INTO bds_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ina gigi ilaki⁄isi inay tuba, “Qatlay doó ilii daye khwayaiĩ, unkuray hoó kaaday tuba, ‘Heetlaalee caaqwa doo hhoi, sa gimba raw hiĩ daa⁄adeesi.’ ");
INSERT INTO bds_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kara, qatlay gu heetlawaa hoóti kaaday tuba, ‘Letuti doo wana tlubay gu ilafahhiya, sa gimba raw hiĩ daa⁄adeesi, kara tlonga hiĩ slaabinti.’ Gu lou, unkuray khuꞌuday naraꞌa, idoo da ilii caahha hhankuda da raw. Teesaaqay see, unkuray hiidahhasidaaiiba baraslawa hhankuda da gimba gu bakaꞌasa gu diqimi hhanki. ");
INSERT INTO bds_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Laqwaloo da hida gu tlakwi haa gwaa slipalauumidee, inay ti slaiyay, sigima laqami gimba gu kaaru. Inkoo, inay sigi laqanaaba gimba lensee gu kaaru, hikira kilesi gu tletimiisay Yoona sigini laqana.” Da hheꞌesi, Yeesu gigi may inay teꞌesii, gi tosaa waaudi. ");
INSERT INTO bds_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Qatlay sirakoomiisee da Yeesu giyaa ilii tlo⁄osiri kenga gu caduu gu tlawa da didiri, gi baraslayiri tuba, digaani afahhami hubida mukaatee. ");
INSERT INTO bds_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu sigigi kaay inay tuba, “Hangu ga⁄aydee haa mahhaaꞌamee da hamiira pahha da Farisaayoo haa da Sadukaayoo.” ");
INSERT INTO bds_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Teꞌesii, sirakoomiisee dosi gi tlaatleesidi idara inay haa inay, kakaanay tuba, “Ina teesaaqay giimaamisi, ti sa gimba haani hubidaniiba mukaatee.” ");
INSERT INTO bds_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesu yaa caahhi ilahudaa koina, sigigi kaay tuba, “Ye unkuray hida gu koomee ⁄imbaraa coko⁄o! Hangu soꞌoyi ilaki⁄ii⁄imisiday unkuray haa unkuray tuba, handi kontaaiiba mukaatee? ");
INSERT INTO bds_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Inkoo, unkuray hati kahhadaaii caahha? Unkuray hoó hiislaydaaiibaslii mukaatetira kooani daa ⁄agimisidi hida elefu kooani? Qariqaaqari giyaa ilii hheꞌesiri ⁄agoo, unkuray haa hiikurunkuridiri kapapuu maka gu meetu gu mukaatee? ");
INSERT INTO bds_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kara, hoó hiislaydaaiibaslii mukaatetira fanqu daa ⁄agimisidi hida elefu cigahha? Qariqaaqari giyaa ilii hheꞌesiri ⁄agoo, unkuray haa hiikurunkuridiri kapapuu maka gu meetu gu mukaatee? ");
INSERT INTO bds_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Unkuray hariĩ malee slanqatiri caahha tuba, ana hati giimaamisaaba haa unkuray gimba gu mukaatee? Diliqa haa hangu ga⁄aydee haa mahhaaꞌamee da Farisaayoo haa da Sadukaayoo.” ");
INSERT INTO bds_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Teꞌesii, sirakoomiisee dosi gi caahhiri tuba, Yeesu hiti giimaamisiyaaba mahhaaꞌamee dari boo⁄imisu mukaatee, ti diliqa haa caacaahhamisu gu hiicoridu gu Farisaayoo haa gu Sadukaayoo. ");
INSERT INTO bds_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Qatlay Yeesu giyaa ilii day yaamu gu Kaysaariya Filiipige, gi maasi sirakoomiisee dosi tuba, “Hida hinoóti kaayay tuba, ana Nanku Heedi na miyaa?” ");
INSERT INTO bds_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inay gugi ilaki⁄isiri tuba, “Hida wakinay yoóti kakaanay tuba, ugu ti Yohaana Hiinunqudimiisay, wakinay yoóti kakaanay tuba, ugu ti Eliyaa. Kara wakinay yoóti kakaanay tuba, ugu ti Yeremiyaa tletimiisay gu Iliitleemu baku waku tla⁄aã gu tletimiisee da segi da Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu gi maasi inay tuba, “Hari unkuray hanoóti ilahudeesiday ana na miyaa?” ");
INSERT INTO bds_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simooni Peetiro gugi ilaki⁄isi gi kaay tuba, “Ugu na Kristu, Nanku Iliitleemu gu slafa.” ");
INSERT INTO bds_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Da hheꞌesi, Yeesu gi kaay sa ina tuba, “Duguũ ⁄aafi ugu, Simooni nanku Yoona, sa gimba gimbaki duguntii tlaaꞌasiiba daqa dooguu ha heedi, duguntii tlaaꞌasi daqa dooguu ha Taataa goy goó rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ana sugu kaawa ambee ugu na Peetiro, kara rawaa gu hhafidakii ha tleehha kanisaa doyi, gimati ⁄uuru gu khonsleebaa gii dahhasiyaaba kaba⁄araa. ");
INSERT INTO bds_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ana sugu hadisa ugu fungoo gu Tawaaloo da rawaa gu raw. Idoo ga khiidinte tiꞌii khoorooge, hatee Iliitleemu gi khiidina rawaa gu rawge. Kara idoo ga afiiooyinte tiꞌii khoorooge, hatee Iliitleemu gi afiiooyina rawaa gu rawge.” ");
INSERT INTO bds_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Da hheꞌesi, Yeesu gi tlaatlahhasi sirakoomiisee dosi, hhanti kaayay sa heedi lensee tuba, ina na Kristu. ");
INSERT INTO bds_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tlaatleesoo da qatlaykeesaa, Yeesu yaa tlaatleesi kakaaru sa sirakoomiisee dosi pandataa tuba, ina kwanda gi hadakaye Yerusaleemuge. Slime yade dugu labaꞌasi hari khisla ha gaduũ gu Yahuudi, haa hhapalooee da deni haa maarimamaa da sariyaa. Ina kwanda dugu gaasiye, kara baloo da tamiige gi tosaa slafi yaagii ca⁄i ayisago. ");
INSERT INTO bds_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Teꞌesii, Peetiro harigi waaudi Yeesu afayige, gugi tlaatleesi ilii⁄oo⁄a, kakaana tuba, “Looimoo gu Goõ, Iliitleemu hiitlintiꞌisiye gimbakee segenge! Gimbakee etaa hiica⁄iyaaba daqa dooguu!” ");
INSERT INTO bds_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Teꞌesii, Yeesu gii fookidi daqa Peetiroge, sugugi kaay tuba, “Taa⁄a aluũ koii Sataanimoo! Ugu haniti koiiꞌimisida ana da Sataanimoo gooay, sa gimba ilahudaa koku hari bara da Iliitleemu wanaaiiba, ti ilahudaa gu hida kilesi.” ");
INSERT INTO bds_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Bere heedi slai sirakooma ana, kwanda gi hiifookidiye gimba gosi giyoó slaiye sirakomamidu, haa geregediye musalaaba gosi, gi asu sirakona ana. ");
INSERT INTO bds_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Heedi gu slaꞌa ilabuꞌuru ibinaa dosi, hikee ibinaa dosi higimaa hhamisi. Heedikaꞌa gu hhamisa ibinaa dosi sa ana, hikee ibinaa dosi gimaa ilabuꞌuna. ");
INSERT INTO bds_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Heedi faydaa mala slay, gimati slay hindaqaruumaa goõ da khooroti, tay gi tosaa hhamisi ibinaa dosi da koraraa goóba hiifaakoo? Kara heedi mala hadisi, ma slay ibinaa dosi da koraraa haa koraraa goóba hiifaakoo? ");
INSERT INTO bds_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nanku Heedi yaa khay sliimaa haa malayika dosi, hari wanqamee da didiri sugwaa hadisi ha Taataa gosi. Teꞌesii, ina maa asu bui kila heedi hari qoomay gu yondu gosi. ");
INSERT INTO bds_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gu lou, ana sangu kaay ambee, wanay hida wakinay tla⁄aã googunay, guũ qadimidee tiꞌii, maa kaka⁄iyaaiiba, maati gesaa arinayi Nanku Heedi, yaa khoci hari ⁄uuru gu tawaaloo dosi.” ");
INSERT INTO bds_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Qariqaaqari balalu lahhoꞌo giyaa iliicatiri, Yeesu hirigi waaudi Peetiro, Yakoobo haa hhia gosi Yohaana, girigi ilakhiinaaꞌadi cina da oõ gu tleeduge, daqa da inay kilakoina. ");
INSERT INTO bds_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yade, Yeesu kalay gosi gii fookidi pandaa dooinay. Pandaa dosi gi wanqadi letu pahha, haa qayroo kosi gi ⁄abaakwayri poy cencee pahha. ");
INSERT INTO bds_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yuꞌudaa, Musaa haa Eliyaa tletimiisetira da wakaꞌalee da Iliitleemu, yaagii ca⁄iri pandaa dooinay, haa cocoiyay haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Teꞌesii, Peetiro gi kaay sa Yeesu tuba, “Looimoo gu Goõ, daraay boo⁄i khisla dandiray ibinaa tiꞌii. Bere ugu ha slaꞌada, ana ha tleehha cuuraiĩ tami tiꞌii, leẽ sa ugu, leẽ sa Musaa haa leẽ sa Eliyaa.” ");
INSERT INTO bds_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peetiro giyaa ilii kahhiye cocoi gimbakee, cirakiray tlongiya da ⁄abaakwi gi ilaslaabidi inay gonkoinaa. Da hheꞌesi, afoo da Iliitleemu yaagii ca⁄adi tlongiyateesaa kakanta tuba, “Hiĩ na Nankoy ga slae, gunoó muunaboo⁄eesa, akhamisakuna ina.” ");
INSERT INTO bds_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Qatlay sirakoomiisetee giyaa ilii akhasiri afotee, yaa tlaꞌamuudiri hari khisla, gi khuupuꞌumidiri hhapeege. ");
INSERT INTO bds_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Da hheꞌesi, Yeesu gigi iliisati inay haa gigi nangumisi, sigigi kaay tuba, “Qadimida, hhanti tlaꞌamutay.” ");
INSERT INTO bds_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inay giyaa iliiwaratlaysiri ilaa koina, yaa aniriiba heedi waku, ti Yeesu kilesi gunaa aniri. ");
INSERT INTO bds_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Qatlay Yeesu haa sirakoomiisee dosi giyaa ilii⁄eemaamidiyee okeesaa, Yeesu gi ilakaay inay tuba, “Hhanti kaaday sa heedi lensee gimbaki gaã antiri, qatlaykaꞌa naqatloo Nanku Heedi dugumaa iliislafisiye yaagii ca⁄i ayisago.” ");
INSERT INTO bds_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Da hheꞌesi, sirakoomiisee dosi gugi maasiri ina tuba, “Maarimamaa da sariyaa yoó soꞌoyi kakaanta tuba, kwanda Eliyaa giyaa gesaa khaye?” ");
INSERT INTO bds_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou, Eliyaa kwanda giyaa gesaa khaye, ma hii⁄abeesi gimba goõ. ");
INSERT INTO bds_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Inkoo, ana sangu kaawa unkuray ambee, Eliyaa yaa hheꞌesi yaa khay, inay gwaa baraslayiriiba ina, kara gugi laqiri idoo giyaa iliislaiyee gooay inay. Harima amotee leẽ, slime, Nanku Heedi see, kwanda dugu labaꞌasiye dabaiĩ koinay.” ");
INSERT INTO bds_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Teꞌesii, sirakoomiisee gi caahhiri tuba, ina hinti giimaamisi sa inay gimba gu Yohaana Hiinunqudimiisay. ");
INSERT INTO bds_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yeesu haa sirakoomiisee dosi gi dayri daqa raqa da hidage. Teꞌesii, heedi leẽ yaagi khay daqa Yeesuge, gi keebeeidi pandaa dosii. ");
INSERT INTO bds_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Heedikee gi kaay tuba, “Looimoo gu Goõ, ⁄awaarimi sa nankoy, sa gimba ina kona kwinkwiisii, haa dugoó labaꞌasi khisla ha kwinkwiisitee. Kara, waa wa⁄a ina yoóyi huhui aslaage haa waꞌay gu maꞌayge. ");
INSERT INTO bds_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ana hagwaani leehhisi daqa sirakoomiisee dooguu, magu hhoeesiri, inay gungii dahhasiriiba hhoeesa.” ");
INSERT INTO bds_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Da hheꞌesi, Yeesu gigi ilaki⁄isi inay tuba, “Eki, de laqwaloti doóba ⁄imba Iliitleemu, haa daa hhamaahhanti! Ana hati ibiida haa unkuray malaalee naqatloo? Hangutii kaasa malaalee naqatloo? Aare satisaayuu qaraimokee tiꞌii daqa dooii.” ");
INSERT INTO bds_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Teꞌesii, Yeesu gi ilii⁄oo⁄i gieerimokee. Cirakiray, gieerimokee yaagii ca⁄i daqa qaraimoogo. Qaraimokee dugugi hhoeesi qatlaykeesii loi loii. ");
INSERT INTO bds_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Da hheꞌesi, sirakoomiisee gi ilii hadakayri Yeesu, giyaa iliiwanee inay kilakoina, gugi maasiri tuba, “Dandiray hariĩ soꞌoyi slanqadani hiica⁄asa gieeri?” ");
INSERT INTO bds_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeesu gigi ilaki⁄isi inay tuba, “Hangii dahhasidiriiba, sa gimba ⁄imba dooguna daqa Iliitleemuge dati coko⁄i. Gu lou, ana sangu kaay unkuray, bere ha kontay ⁄imba daqa Iliitleemuge, gimati coko⁄oniinii see pisagariya da haradaali pahha, hiidahhasiday kaawa sa oki ubee, ‘Waaudi tiaa, taa⁄a yade,’ gi tosaa waaudi. Gu lou, wantaaba idoo unkuray gari slanqatee hiidahhasa.” ");
INSERT INTO bds_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Qatlay Yeesu haa sirakoomiisee dosi giyaa iliiwanee sliimaa Galilaayage, Yeesu yaa kaay sa inay tuba, “Nanku Heedi dugu taatahhi dabaiĩ gu fa⁄ayaa dosii. ");
INSERT INTO bds_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Inay gu gaasiyay, baloo da tamiige Iliitleemu gwaa slafisi ayisago.” Sirakoomiisee dosi giyaa ilii akhasiri gimba gu gwaaꞌaraa dosi, gi li⁄iri hari khisla. ");
INSERT INTO bds_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gi dayri tongoo da Kaperinauumuge. Yade, karaanimaiĩ gu koodi da mara gu didiru gu Iliitleemu, yaagi khayri daqa Peetiroge haa gugi maasiri tuba, “Maarimuu googuna yoó buiyaa koodi da mara gu didiru gu Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peetiro gigi ilaki⁄isi inay tuba, “Ee yoó buꞌudi.” Qatlay Peetiro giyaa ilii day waꞌay gu marage, kahhi see kaawa gimba, Yeesu gi giyaadi maasa ina tuba, “Simooni, ana hagu maasa ugu gimbaki. Qatlay watemi da khooroo giyoó ilii kurunkurinee koodi, inay yoótii kurunkurinaaii koodi daqa yaꞌay koinaa, baku ti daqa hida wakinaygo?” ");
INSERT INTO bds_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peetiro gugi ilaki⁄isi tuba, “Inay yoó daqa hida wakinaygo hiikurunkurinay koodi.” Yeesu gi kaay sa ina tuba, “Bere teesaaqay, yaꞌay koina digaa ilamooyimi, buꞌuduu koodi. ");
INSERT INTO bds_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maraki gu didiru ti koyi. Teesaaqay see, slaꞌanaaba magi muuna tlakweesani, hida hhanki gwaani khawee sa hiiowaraa koodi daqa dooraa. Inkoo, taa⁄a tlawage, la hiikwahhakayda qolondoo googu guri ooyiru samaakii. Samaakimoo gu pandaa doo ooyiye, hikee lugunooyi ooda. Qatlay goo iliitlaaꞌaside afa gosi, hoo slayda peesay gu buꞌudisa buaraa da koodi doyi haa toogu, ooyi peesaykee, la buakayda kooditee.” ");
INSERT INTO bds_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Qatlaykeesii, sirakoomiisee yaa ilii hadakayri Yeesu, gugi maasiri tuba, “Miyaa na didiri sa goõ Tawaaloo da rawaa gu rawge?” ");
INSERT INTO bds_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Teꞌesii, Yeesu gi eteedi khwaylimoo leẽ, haa gugi qadidisi tluntlubaa dosii tla⁄aã gu sirakoomiisee dosii. ");
INSERT INTO bds_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Da hheꞌesi, ina gi kaay sa inay tuba, “Gu lou sangu kaay unkuray, bere hanguba hiifookida haa gi daaqay gu digidakwi tleehhitay, etaa hiiguntaaiiba Tawaaloo da rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Teesaaqay, heedi goó laqama murumuꞌuuma da khwaylimoki gooay gu coko⁄u, hikee na didiri sa goõ Tawaaloo da rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kara, heedi gu kwahhasuusa khwaylimoo gu coko⁄u da hinkaa gooay hari uma goy, hikee ana guniĩ kwahhasuusi. ");
INSERT INTO bds_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bere heedi ⁄isina leẽ gu hhaã gu kahhee hii⁄atla ⁄imbage ana gi yondiidi tlakwaroo, heedikee hiti ba⁄ay duguti ilii kufi tlaa⁄a da didiri da saadiruu isa dosii. Da hheꞌesi dugugii slakhi slagwiya da tlawa da didirige. ");
INSERT INTO bds_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hoo antayi hida gu khooroo, sa gimba gu koimisu goó ⁄isima, hida ma yondiidiri tlakwaroo! Koimisukee kwanda gi wane balalu sliimaa. Teesaaqay see, laoo dosi heedikaꞌa goó ⁄isima koimisukee maay ca⁄i. ");
INSERT INTO bds_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Inkoo, bere daba googu baku yaaee doogu ⁄isinay ugu ma yonditi tlakwaroo, kereꞌesaku haa kwahhaku segenge. Ba⁄ay ugu hiidawaraa slafimaa gu koraraa haa koraraa goóba hiifaakoo, tay ha konta daba leẽ baku yaaee leẽ. Ti naraꞌaaba ugu duguma hiikwahhi aslaa da koraraa haa koraraa goóba hiifaakoo, tay ha konta dabaiĩ cada haa yeꞌeeroo cada. ");
INSERT INTO bds_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kara, bere ila doogu ⁄isinta ugu ma yonditi tlakwaroo, tu⁄aka, kwahhaka segenge. Ba⁄ay ugu hiidawaraa slafimaa gu koraraa haa koraraa goóba hiifaakoo, tay ha konta ila leẽ. Naraꞌaaba ugu duguma hiikwahhi aslaa da koraraa haa koraraa goóba hiifaakoo, tay ha konta ilaa cada. ");
INSERT INTO bds_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Unkuray hangu ga⁄aydee, hhanti qooqitay leẽ gu hhaã gu digidakwi. Gu lou, sangu kaay unkuray ambee, malayika dooina yade rawge, balalu sliimaa yoó ariirinayi pandaa da Taataa gooii gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Inkoo ilahudeesa, heedi leẽ kona bee⁄u miyaa leẽ. Bere ina hiĩ hhamisi leẽ tla⁄aã gooinaa, ina hiti malee laqi? Ina hiti may hhakee gu mibeeri gweleti haa gweleti daqa gi iliiwanee onke, gi waaudi sa dabiidu gu hikira gu leẽ guũ hhamu. ");
INSERT INTO bds_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gu lou, sangu kaay unkuray ambee, bere gwaani slay bee⁄imokee, ina hhaꞌaluudi hari khisla. Ina hhaꞌaluudi hari khisla sa bee⁄imokee, ba⁄ay da hhakira wakinay mibeeri gweleti haa gweleti gubasli hhamaraa. ");
INSERT INTO bds_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Harima amotee leẽ, Taataa googuna gu rawaa gu rawge waara, yoó slaiyaaba leẽ gu hhaã gu digidakwi, ma hhami. ");
INSERT INTO bds_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bere hhia googu goó ⁄imba, hiidakusi daqa dooguu, taa⁄a sugu kaade dakoo dosi, ga iliiwantee unkuray kilakokuna. Bere ina gu akhasi ugu, teꞌesii ina hiĩ hhia googu tleehhidi kara. ");
INSERT INTO bds_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bere ina siꞌi akhasa ugu, taa⁄a kara daqa dosii, oyii heedi leẽ baku hida cada sliimaa haa ugu, dama waari masaydii cada baku tami sa maꞌaraa da gimbakee. ");
INSERT INTO bds_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bere ina hiĩ siꞌi akhasa hida hhakee, taa⁄a kaay gimbakee kanisaage. Da hheꞌesi, bere ina hiĩ siꞌi akhasa kanisaa, faadaku ina ti heedikaꞌa pahha goóba ⁄imba Iliitleemu, baku ti karaanimoo gu koodi pahha. ");
INSERT INTO bds_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gu lou, ana sangu kaay unkuray ambee, idoo ga khiidinte tiꞌii khoorooge, hatee Iliitleemu gi khiidina rawaa gu rawge. Kara idoo ga afiiooyinte tiꞌii khoorooge, hatee Iliitleemu gi afiiooyina rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kara, gu lou sangu kaay unkuray ambee, bere hida cada tla⁄aã googunay tiꞌii khoorooge, hangi ila⁄imbitay firoo idoo waka, Taataa goy goó rawaa gu rawge waara, sangu yondiidi unkuray, idotee ga firintee. ");
INSERT INTO bds_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sa gimba, bere hida cada baku tami, hingii kurunkuridiri hari uma goy, ana waara teꞌesii sliimaa haa inay.” ");
INSERT INTO bds_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Da hheꞌesi, Peetiro gi ilii hadakay Yeesu, gugi maasi tuba, “Looimoo gu Goõ, hhia goy dakumisi waa maka daqa dooii, ana gugi ilakooma ilamooyiru ina? Haguti ilamooyimaa waa fanqu see?” ");
INSERT INTO bds_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu gugi ilaki⁄isi tuba, “Ana sugu kaawaaba ambee ilamooyimi ina waa fanqu kilesi. Ana suguti kaawa ambee, ugu ilamooyimi danaꞌa googu, qatlay goõ gu ibinaa doogu faadoo see hhaka. ");
INSERT INTO bds_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sa gimbakee, Tawaaloo da rawaa gu raw hingaati slaaslaqasidi haa mutemi waku, gwaa slaꞌa hiigaasa faadoo da iinanu gu yondimiisee dosi, giyaa konee. ");
INSERT INTO bds_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Qatlay mutemi giyaa ilii tlaatleesi laala⁄amisu faadoo dosi, yondimiisay leẽ, gwaa kooma inaa da talanta elefu mibi, duguraagi khay pandaa dosii. ");
INSERT INTO bds_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yondimiisaykee yaa konaaba peesay guri buaraa iinatee da mutemi. Sa gimbakee, mutemi gi ilafahhi hida kosi tuba, heedikee dugu naadine, ina, hadee dosi, yaꞌay kosi haa idadu goõ gi kone, iinatee dagama bui. ");
INSERT INTO bds_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Teꞌesii, yondimiisaykee gi keebeeidi pandaa da mutemige, gi kaay tuba, ‘Ana hanguũ firimi siniqayde baloo, ana sugu bua goõ.’ ");
INSERT INTO bds_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Teꞌesii, mutemi gi ⁄awaarimi sa yondimiisaykee, gugi ilamooyimi iinaa dosi goõ, gugi geemay, ma waaudi. ");
INSERT INTO bds_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yondimiisaykee giyaa ilii waaudi teꞌesaa pandaa da mutemigo, hingigi slaslayri haa yondimiisay danaꞌa gosi, gwaa kooma iinaa dosi da peesay dinaari miyaa leẽ. Teꞌesii, ina gugi ooyi haa gugi tlaatleesi ququpiru gwa⁄abage, tay sugu kakaana tuba, ‘Sini buꞌude iinaa dooi.’ ");
INSERT INTO bds_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Teꞌesii, yondimiisaykee danaꞌa gosi gi keebeeidi pandaa dosii, gugi firimi, kakaana tuba, ‘Ana hanguũ firimi siniqayde baloo ana sugu bua goõ.’ ");
INSERT INTO bds_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Teesaaqay see, ina gi waaudi, gugi khiidimi ina jeerage, gimaa ilii hheꞌesiye naqatloo buaraa iinatee. ");
INSERT INTO bds_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yondimiisee waka da mutemi, giyaa ilii aniri gimbakee, yaa slahhaahhaairi hari khisla. Da hheꞌesi, inay gi hadakayri daqa mutemi, sugugi kaayri gimba goõ gungii ca⁄u. ");
INSERT INTO bds_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Teꞌesii, mutemi gi eteedi yondimiisaykira, daa ilamooyimi iinaa dosi. Ina gi kaay sa yondimiisaykee tuba, ‘Ugu ti yondimiisay gu tlaku hari khisla. Qatlay ugu haniĩ ilii firinti ana magu ilamooyimi iinaa doogu, ana hagugi ilamooyimi goõ. ");
INSERT INTO bds_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Inkoo ugu, haã soꞌoyi maydi ⁄awaariru sa yondimiisay danaꞌa googu, idoo suguũ ilii ⁄awaarimi gooay ugu?’ ");
INSERT INTO bds_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Teꞌesii mutemi gi slahhaai hari khisla sa yondimiisaykee. Cirakiray lenge ina gugii lu⁄i yondimiisaykee dabaiĩ gu sirikaarimoo gu jeerage, duguma labaꞌasi, qatlaykaꞌa naqatloo gimaa iliibuiye iinaa dosi goõ. ");
INSERT INTO bds_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Teesaaqay, Taataa goy goó rawaa gu rawge waara, ginimaa ilii laqi kila heedi tla⁄aã googunay, bere guba ilamooyiru hari muuna gosi hhia gosi.” ");
INSERT INTO bds_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Qatlay Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee, yaa waaudi hhapee da Galilaayago, gi hadakay bara da hhapee da Yudaayage, hari tlo⁄osaa gu duudu gu Yoridaani. ");
INSERT INTO bds_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yade raqoo gu deni gu hida gugi sirakoniri, ina gi hhoeemisi hida gwaa mama⁄ee tla⁄aã gooinay. ");
INSERT INTO bds_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Da hheꞌesi, Farisaayoo wakinay yaagi khayri daqa Yeesuge, magu koisiri hatliru, gugi maasiri ina hari cirihhimaa tuba, “Ga ilatahhade, ti naraꞌaa hhawata mawaraa hadee dosi, sati idoo lensee?” ");
INSERT INTO bds_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu gigi ilaki⁄isi inay tuba, “Unkuray haa somintiriibaslii Handikaa da Iliitleemuge tuba, ina gwaa tleehhu inay yadaa tlaatleesoogo, ‘giyaati tleehhi hhawata haa hadee’? ");
INSERT INTO bds_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kara gi kaay tuba, ‘Sa gimbakee, hhawata may taataa haa iyoo dosi, hingigi ilagaasi haa hadee dosi. Teꞌesii inay cada koinaa gi slaqwa leẽ tleehhidiyay.’ ");
INSERT INTO bds_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Inkoo, inay hiti hida cadaaba kara, inay hiti slaqwa leẽ. Teesaaqay, hhakee daa ilagaasi ha Iliitleemu, heedi lensee gi hhantii deehhi.” ");
INSERT INTO bds_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Da hheꞌesi, Farisaayoo gi maasiri Yeesu tuba, “Musaa yaa soꞌoyi ilafahhi tuba, bere hhawata slai mawa hadee dosi saga kereꞌesiye tarakaa, gigi tosaa may?” ");
INSERT INTO bds_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu gi kaay sa inay tuba, “Musaa yaa hiigeemay mamawu gu tigay kokuna, sa gimba gu karahhamuu gu muunaiĩ hhakee kokuna. Gimbakee yaa taqay gooba tlaatleesoogo, qatlay Iliitleemu giyaa ilii tleehhi hhawata haa hadee. ");
INSERT INTO bds_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gu lou, ana sangu kaay unkuray ambee, hhawata gu kereꞌesa tarakaa sa hadee dosi, bere sa gimba gu slipalauuma gooba, haa gi khabina hadee waka, hikee hiti yondiidi slipalauuma.” ");
INSERT INTO bds_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sirakoomiisee dosi sugugi kaayri tuba, “Bere gimba tla⁄aã gu hhawata haa hadee dosi teesaaqay wana, ti ba⁄ay da mawaraa khaboo sumuku.” ");
INSERT INTO bds_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu gi kaay kara sa inay tuba, “Hida goõ gooba gu hiidahhasee ⁄imbaraa caacaahhamisuki, ti hhakaꞌa kilesi, Iliitleemu giyaa pihhi caahharaa. ");
INSERT INTO bds_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ana sanguti kaawa taqay, sa gimba hida wakinay ti matowaasi, sa gimba digaa teesaaqay laqwali. Wakinay digaati teesaaqay laqi ha hida. Kara, wakinay yaati mayri khaboo sa Tawaaloo da Iliitleemu. Heedi gu hiidahhasa oowaraa caacaahhamisuki, gu tosaa ooyiye.” ");
INSERT INTO bds_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Da hheꞌesi, hida yaagi leehhisiri yaꞌay koina daqa Yeesuge. Inay yaa teesaaqay laqiri, ina ma iliiqamidi dabaiĩ daaqay hhakee, haa sigima firimi iliitleemu, magi ⁄aafi inay. Teesaaqay see, sirakoomiisee dosi gigi ilii ⁄oo⁄iri hida hhakee, gwaani leehhisee yaꞌay koina. ");
INSERT INTO bds_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeesu gi kaay sa sirakoomiisee dosi tuba, “Daaqay gu digidakwi maw yaa khayee daqa dooii, hagi hhanti tlaatlahhasiday. Sa gimba, Tawaaloo da Iliitleemu dati hida da hhakee gooay.” ");
INSERT INTO bds_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yeesu gi iliiqamidi dabaiĩ kosi daaqay hhakee. Ina giyaa ilii hheꞌesi gi waaudi daqateesaa. ");
INSERT INTO bds_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Inkoo, heedi leẽ yaagi khay daqa Yeesuge, gugi maasi tuba, “Maarimuu, ti gimba mala gu hhou ga yondiide, ma slay slafimaa gu koraraa haa koraraa goóba hiifaakoo?” ");
INSERT INTO bds_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu gi ilaki⁄isi heedikee tuba, “Hani soꞌoyi maamisida ana gimba mala na hhoi? Wana leẽ kilesi gu hhou. Bere slaꞌada slawaraa ibinaa da koraraa haa koraraa goóba hiifaakoo, iliikoomii ilakaawa dosi.” ");
INSERT INTO bds_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Heedikee gi maasi Yeesu tuba, “Ti ilakaawa haloo?” Yeesu gugi ilaki⁄isi ina tuba, “Hhanti gaasida, hhanti slipalauta, hhanti fiisida, hhanti ilatlatlayda afaꞌafuuma, ");
INSERT INTO bds_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","muriidi taataa googu haa iyoo doogu, haa ‘slae hida danaee koku, idoo hangu iliislaꞌade gooay ugu lenkoogu.’ ” ");
INSERT INTO bds_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Qaraimokee gi ilaki⁄isi Yeesu tuba, “Ilakaawatee goõ hagaa iliikoomi yadaa daaquumaa dooaa. Inkoo ti idoo mala kara ganiĩ afariislaꞌadisi?” ");
INSERT INTO bds_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu sugugi kaay ina tuba, “Bere slaꞌada buꞌudaraa pandaa da Iliitleemuge, taa⁄a naadimi idadu goõ ga konte, goo hheꞌeside la qaqayda peesaykee goo slayde sa kwaeeli, hari amotee ugu maa asu slayda hindaqaruumaa da loi yade rawaa gu rawge. Goo ilii hheꞌeside teesaaqay laqaraa, laa asu khayda, ma sirakoomiisay goy tleehhiti.” ");
INSERT INTO bds_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Qaraimokee giyaa ilii akhasi gimbakee gu Yeesu, gi waaudi hari li⁄eemoo, sa gimba ina yaa hindaqaru hari khisla. ");
INSERT INTO bds_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Gu lou, sangu kaay unkuray ambee, ti maana hari khisla, hindaqaru hidawaraa Tawaaloo da rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gu lou, ti slahharuũ hari khisla, gamiyaa hiicataraa hari pooa da singanoo, ba⁄ay hindaqaru hiidawaraa Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sirakoomiisee dosi giyaa ilii akhasiri gimbakee, yaati bakairi hari khisla, gugi maasiri ina tuba, “Bere daa karahhi teesaaqay, inkoo ti miyaa na hiidahhasi ba⁄aru?” ");
INSERT INTO bds_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu gi yuꞌudi daqa dooinay, gi kaay tuba, “Hari bara da hida gimbaki dugwii dahhasiyaaba, daqa Iliitleemuge gimba goõ dugwii dahhasi.” ");
INSERT INTO bds_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Teꞌesii, Peetiro gugi ilaki⁄isi, gi kaay tuba, “Yuꞌudiyaa, dandiray haani mayni idadu sliimaa gaa kone, hagugi sirakoni ugu. Da hheꞌesi, dandiray ha mala slayna?” ");
INSERT INTO bds_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu gi kaay sa inay tuba, “Gu lou, sangu kaay unkuray ambee khooroo da ⁄abige dama khawa, haa Nanku Heedi maa ibiidi kitiĩ gu wanqamee dosii gu tawaalooge. Qatlaykee, unkuray see sirakoomiisee doyi, hamaa ibitay kiteeri mibi haa cadage gu tawaaloo, hagi hukuntay motoliya mibi haa cada da Israeeli. ");
INSERT INTO bds_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kara, kila heedi gwaani maw maraai kosi baku hhia gosi, hhioo dosi, taataa gosi, iyoo dosi, yaꞌay kosi haa baku qaymamu kosi. Bere teesaaqay laqiyay, sa sirakooma ana, hhakee maa ooyay daqa Iliitleemugo waa mibeeri mibi, da gimba goõ gu inkoo giyaani mayri. Slime, Iliitleemu maa hadisi sa inay, aalimee da slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hida wa⁄a gungoó arimee pandaage wanay inkoo, teꞌesii himaati hida gu hiifaakoo tleehhidiyay, kara hida gu hiifaakooge waara, himaati gu pandaa tleehhidiyay.” ");
INSERT INTO bds_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yeesu gi ilakoomi gimba tuba, “Tawaaloo da rawaa gu raw hingiti slaaslaaqasi ha heedi gu kooma qaymoo da sabiibu. Heedikee yaay ca⁄i tumpaatumpu gi sokoonii kay, sa dabiidu kawa hida gu yondiidee yondu qaymoo dosii. ");
INSERT INTO bds_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ina hingigi ila⁄imbidiri haa inay, buaraa inay musaalaa gu balalu sliimaa, kila heedi dinaari leẽ balooge. Da hheꞌesi, gigi leehhisi inay qaymoo dosii da sabiibuge. ");
INSERT INTO bds_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Qatlay daa ilii day saa tami da heetlawaa, ina gi waaudi kara sokooniige. Teꞌesii, gi slay hida wakinay hiĩ qadimidiri konaaiiba yondu. ");
INSERT INTO bds_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ina sigigi kaay tuba, ‘Unkuray see, taa⁄amida yondiida yondu qaymoo dooii da sabiibuge, ana hangoo bua haaki dooguna.’ Da hheꞌesi, inay gi waaudiri qaymooge. ");
INSERT INTO bds_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ina gi waaudi kara gi laqi teesaaqay, qatlay daa ilii day saa lahhoꞌo haa saa dagati. ");
INSERT INTO bds_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kara, daa ilii day saa mibi haa leẽ da khwayaiĩ, ina gi hadakay kara sokooniige. Teꞌesii, gi slay hida wakinay hiĩ qadimidiri konaaiiba yondu see. Ina gigi maasi inay tuba, ‘Haã soꞌoyi qadimitiri tiꞌii tleemaage tlupu, yondu see hanguba?’ ");
INSERT INTO bds_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Inay gugi ilaki⁄isiri ina tuba, ‘Ti sa gimba wanaaba heedi sandii qawu yondu.’ Ina sigigi kaay inay tuba, ‘Unkuray see, taa⁄amida yondiida yondu qaymoo dooii da sabiibuge.’ ");
INSERT INTO bds_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Qatlay daa ilii day khwayaiĩ, looimoo gu qaymoo gi eteedi hikira gwaa wariiqadiidimida yondimiisee dosi, sugugi kaay tuba, ‘Eteedi yondimiisee goõ, sigi buꞌude bueemaa koina. Tlaatleesi hari hhakira gwaani khawee gu hiifaakoo, haa gii gaasida sa hhakira gwaani khawee gu tlaatleesoo.’ ");
INSERT INTO bds_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hida hhakira gwaa tlaatleesee yondu saa mibi haa leẽ da khwayaiĩ, yaagi khayri, kila heedi tla⁄aã gooinay dugugi bui dinaari leẽ. ");
INSERT INTO bds_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Teesaaqay, hhakira gwaa tlaatleesee yondu hari tumpaatumpu giyaa ilii khayri, gi ilahudeesiri tuba, inay digi bui peesay hiicataraa da hhakira gu hiifaakoo. Teesaaqay see, kila heedi tla⁄aã gooinay dugugi bui dinaari leẽ. ");
INSERT INTO bds_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hida hhakee giyaa ilii hheꞌesiri oowaraa peesay gooina, gi tlaatleesiri iliiquru⁄umoo looimokee gu qaymoo. ");
INSERT INTO bds_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Inay gi kaayri tuba, ‘Hida hhanki gwaani khawee alungo, hinti yondiidiri qoomay gu saa leẽ kilesi. Teesaaqay see, ugu hagiĩ buꞌudi, bueemaa leẽ haa dandiray guũ yondiidee yondu gwaa karahhu, kara dandii da⁄ami ha tleemaa tlupu!’ ");
INSERT INTO bds_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Teꞌesii, looimoo gu qaymoo gi ilaki⁄isi sa leẽ tla⁄aã gooinay tuba, ‘Danaꞌa goy, ana hanguũ afii⁄itiiba ugu idoo lensee. Ugu hangii ila⁄imbitiibaslii haa ana tuba, ha yondita yondu hari dinaari leẽ baloo goõ? ");
INSERT INTO bds_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oyii bueemaa koku, la waauta. Ana niĩ arimi naraꞌa buaraa, heediki guũ tlaatleesu yondu hiifaakooge bueemaa leẽ, haa ugu gwaani giyaadu khawaraa. ");
INSERT INTO bds_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ana ha koomaabaslii haaki da yondu idoo ga slae hari khooslay goy? Ugu siĩ soꞌoyi anti qunceeraa, qatlay ana gaã ilii laqami cabuuma sa hida hhanki? ");
INSERT INTO bds_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Teesaaqay, hida gungoó arimee hiifaakooge wanay inkoo, himaati hida gu pandaa tleehhidiyay, kara hida gu pandaa, himaati hida gu hiifaakoo tleehhidiyay.’ ” ");
INSERT INTO bds_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeesu giyaa ilii ilakhiinaaꞌadi Yerusaleemu kawa, hiraa waaudi afayige sirakoomiisee dosi mibi haa cada, sigigi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yuꞌudaa, inkoo Yerusaleemu kakaakayna. Yade, Nanku Heedi dugu taatahhi dabaiĩ gu hhapalooee da denige haa maarimamaa da sariyaa. Teꞌesii, inay gu hukunay duguma gaasi. ");
INSERT INTO bds_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Da hheꞌesi, inay gu taatahhiyay sa hida gu hhapapu wakinay, magu yaqaayiniri, magu difiri hari jeleedimaiĩ haa gugii tluhhumisiyay musalaabage. Da hheꞌesi, baloo da tamiige Iliitleemu gwaa slafisi.” ");
INSERT INTO bds_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Da hheꞌesi, hadee da Sebedaayo yaagi khaydi daqa Yeesuge, sliimaa haa yaꞌay kosi cada, Yakoobo haa Yohaana. Ina gi keebeꞌeti pandaa dosii, gi firinti Yeesu ma saga laqi gimba leẽ. ");
INSERT INTO bds_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu gigi maasi hadetee tuba, “Idoo mala gana slaꞌaday?” Hadetee gi kaadi tuba, “⁄imbi yaꞌay hhanki koi gu cada ibiidiyee sliimaa haa ugu tawaaloo dooguu, leẽ hari bara doogu da ⁄uya, kara leẽ hari bara doogu da basa.” ");
INSERT INTO bds_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu gi ilaki⁄isi, kakaana tuba, “Unkuray hhidintay idoo ga firiirintee. Gu lou, unkuray hiidahhasidaaii kitahhu hari qulu⁄ukee koi gu labaꞌasu gari kitahhe ana?” Inay gugi ilaki⁄isiri tuba, “Hiidahhasana.” ");
INSERT INTO bds_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu sigigi kaay tuba, “Gu lou, hamaa kitahhaday qulu⁄uu goy guri labaꞌasu. Gimati teesaaqay see, ana koomaaba ⁄uuru gu kaawaraa miyaa namaa ibiidi hari daba goy gu ⁄uya baku hari daba goy gu basa. Deqeemoo hhakee ti gu hida hhakira daay leehhi ha Taataa goy.” ");
INSERT INTO bds_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Inkoo, qatlay sirakoomiisee waka mibi giyaa ilii akhasiri firoo da iyoo diĩ Yakoobo haa Yohaana, yaa slahhaahhaairi sa hhakee gu cada. ");
INSERT INTO bds_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Da hheꞌesi, Yeesu gi eteedi sirakoomiisee dosi goõ daqa lenge, sigigi kaay tuba, “Unkuray ha khuꞌuday tuba, watemi da hhapapu yoóti tawaalinay hida koina hari ⁄uuru. Kara, hhakaꞌa gu koomee kofiyaa tawaalooge, yoóti ⁄uureemisiyay hida gu biraa koinay waaree. ");
INSERT INTO bds_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Inkoo, tla⁄aã googunay hamaa hhanti yonditay gimba da hikee gooay. Bere heedi waku tla⁄aã googunay slai heedi gu didiru tleehhida, kwanda gi tongimoo googuna tleehhidiye. ");
INSERT INTO bds_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kara, bere heedi slai gu pandaa tleehhida tla⁄aã googunay, kwanda gi tongimoo googuna tleehhidiye. ");
INSERT INTO bds_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Namati teesaaqay, ana see Nanku Heedi haati khayiiba tiꞌii khoorotii, sinima yondiidi ha hida. Ana hanti khay, ma yondiidi sa inay, haa ma hadisi ibinaa doyi, teesaaqay ma bui sa ilabuꞌuruu gu hida wa⁄a.” ");
INSERT INTO bds_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeesu haa sirakoomiisee dosi giyaa ilii waauuꞌumidiyee Yeerikogo, raqa da didiri da hida gugi sirakonti ina. ");
INSERT INTO bds_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Teꞌesii, hida cada gwaa ilaa hhamaahhamee, yaa ibiidiri kenga gu amooge. Qatlay giyaa ilii akhasiri tuba, Yeesu naa hiicacaacati hari teꞌesa, inay gi maahhiri, gi kaayri tuba, “Looimoo gu Goõ, Nanku Dawdi, sandi ⁄awaarinte.” ");
INSERT INTO bds_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Teꞌesii, raqatee da hida gigi ilii⁄oo⁄odi, ma qabiri diĩ. Teesaaqay see, inay gi asu ilakoniri maahhoo, tay kakaanay tuba, “Looimoo gu Goõ, Nanku Dawdi, sandi ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeesu gi qadidi, gigi eteedi haa gigi maasi inay tuba, “Ha mala slaꞌaday ana ma sangu laqi?” ");
INSERT INTO bds_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Inay gugi ilaki⁄isiri, kakaanay tuba, “Looimoo gu Goõ, dandiray ha firiirina ilaa koti digi tlaaꞌasiye.” ");
INSERT INTO bds_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeesu sigigi ⁄awaarimi, yaagi khay gi nangumisi ilaa koina, cirakiray gii dahhasiri arimaa, da hheꞌesi inay gugi sirakoniri. ");
INSERT INTO bds_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeesu haa sirakoomiisee dosi giyaa ilii daadaauusiri yaamu gu Yerusaleemuge, gi dayri tongoo da Betifaage, daa ilaciyaa waara haa oõ gu Miseyituuni. Teꞌesii, Yeesu gi ya⁄abi sirakoomiisee dosi cada, ");
INSERT INTO bds_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sigigi kaay tuba, “Taa⁄amida tongotiray naqatloo da pandaa doogunay waara. Qatlay goo ilii daadee tongoteesii, cirakiray hoo slayday daqutoꞌoo haa nanku daqutoꞌoo digiĩ kufi. Unkuray gweedankina, ligiraa khayday tiꞌii daqa dooii. ");
INSERT INTO bds_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bere unkuray dangoo maasi ha heedi gimba waku, sugu kaadee ubee, ‘Looimoo gu Goõ gi slai,’ doo hheꞌesiye heedikee dangoo geemay ciraai.” ");
INSERT INTO bds_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gimbaki yaay ca⁄i taqaaqay, ma dabuꞌudi gimbakira daa tletimi ha Isaaya tletimiisay gu Iliitleemu tuba, ");
INSERT INTO bds_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kaawa sa hida gu yaamu gu Sayuuni ubee, ‘Yuꞌudaa mutemi googuna yaa khoci daqa doogunay! Ina ti murumuꞌuusay yaanii day rawaa gu daqwayge, yaani ilii day nanku daqway, nanku daqutoꞌoo.’ ” ");
INSERT INTO bds_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Da hheꞌesi, sirakoomiisetira da cada gi waaudiri, inay gi laqiri idoo sigaani ilii kaay ha Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inay suguraagi khayri daqutoꞌotira haa daqumokira. Teꞌesii, inay gi hhafiifiniri qayroo koina dandaiĩ gu daqwaai hhakeesii, da hheꞌesi Yeesu gi ibiidi rawaa gu qayroo hhakeesii. ");
INSERT INTO bds_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Raqa da didiri da hida gi hhafiifiniri qayroo koina amooge, wakinay yaagi qeetimisiri elemu gu khai, haa gigi hhafahhafiri amooge, ma laqaniri muree daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Raqatira da hida daa giyati pandaa dosii haa hatira daa aluũ kosaa waara, gonkoinaa gi maahhiri tay kakaanay tuba, “Nanku Dawdi, dugu hhaꞌaleesiye! Duguũ ⁄aafi ina gwaa khawa hari uma gu Taataa Iliitleemu! Iliitleemu dugu hhaꞌaleesiye rawaa gu rawge.” ");
INSERT INTO bds_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeesu giyaa ilii day Yerusaleemuge, hida goõ gu yaamu hhakee hiraatii tlairi, hingigi maamisiri inay haa inay tuba, “Hiĩ ti miyaa?” ");
INSERT INTO bds_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Raqatee da hida daa waara sliimaa haa Yeesu, gi ilaki⁄isidi inay tuba, “Hiĩ ti Yeesu. Ina ti tletimiisaykira gwaa yaamu gu Nasareeti da Galilaaya dahha.” ");
INSERT INTO bds_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Da hheꞌesi, Yeesu gii day efeenaa da mara gu didiruge gu Iliitleemu. Teꞌesii, gi tlaatleesi gusiisiru hida goõ gwaa naadiidimee haa gwaa kirigiigimee idadu sa hadimisu sadaaka. Slime gi slaslakhi meesasuu gu hida gwaa alaalaamee peesay, haa kiteeri gu hida gwaa naadiidimee kundee. ");
INSERT INTO bds_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ina gi kaay sa inay tuba, “Daa handikimi Handikaa da Iliitleemuge tuba, ‘Mara goy duguti eteedina mara gu ilii firoo.’ Inkoo unkuray gwaatii fookidiri ‘maraiya da fiisiisee.’ ” ");
INSERT INTO bds_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hida gwaa ilahhamaahhamee haa sletuusee gi ilii hadakayri Yeesu mara gu didiruge gu Iliitleemu. Ina gigi hhoeemisi inay. ");
INSERT INTO bds_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Teꞌesii, hhapalooee da deni haa maarimamaa da sariyaa da diini, yaa aniri gimba gu bakaꞌasa Yeesu giyaa yondiidi. Kara, yaa akhasiri daaqay maahhaminay mara gu didiruge gu Iliitleemu, kakaanay tuba, “Nanku Dawdi, dugu hhaꞌaleesiye.” Sa gimbakee, inay gi slahhaahhaairi. ");
INSERT INTO bds_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Inay gi maasiri Yeesu tuba, “Ugu akhaakhamisidaabaslii daaqay hhakee idoó gi oiiꞌinee?” Yeesu gigi ilaki⁄isi inay tuba, “Ha akhaakhamisa. Unkuray haa somintiriibaslii Handikaa da Iliitleemuge? Daa kaadi tuba, ‘Hari afaiĩ gu daaqay gu digidakwi, haa hhakaꞌa gu ruꞌumee, ha slayda daareesa da loi.’ ” ");
INSERT INTO bds_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Da hheꞌesi, Yeesu gigi may hida hhakee, gii ca⁄i yaamu gu Yerusaleemugo, gi waaudi tongoo da Betaniyaage, gi gui yade. ");
INSERT INTO bds_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Qatlay gu heetlawaa, Yeesu giyaa ilii kikaaki⁄iye Yerusaleemuge, yaa arimi qori. ");
INSERT INTO bds_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ina giyaa ilii khociicine, yaa arimi ⁄ancimoo kenga gu amooge, gugi ilii hadakay ciyoomoo gosii. Teesaaqay see, yaa slayba ⁄aamu, ti loo⁄oo kilesi ginaa slay. Teꞌesii, Yeesu gi ilawaasi ⁄ancimokee, kakaana tuba, “Etaa hamaa ⁄aamutaaba ⁄aamu.” Qatlaykeesii loi loii ⁄ancimokee gi kay sumuku. ");
INSERT INTO bds_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sirakoomiisee dosi giyaa ilii aniri gimbaki gungii ca⁄u daqa ⁄ancimooge, inay gi bakairi, kakaanay tuba, “⁄ancimoki hiĩ malee kay ciraai taqay?” ");
INSERT INTO bds_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou, ana sangu kaawa unkuray ambee, bere ha ⁄imbiday Iliitleemu, qiigiꞌimoo see hhaku, ha yonditay ti hiĩ kilesiiba gu ⁄ancimoo. Gu lou, hiidahhasiday kaawa sa oki ubee, ‘Waaudi tiaa, taa⁄a hanguu kwahhade tlawa da didirige,’ gimbakee hiilaqadi teesaaqay. ");
INSERT INTO bds_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kara, gimba sliimaa ga firintee firoo doogunay, Iliitleemu sangu hadisi, bere ha ⁄imbiday ina.” ");
INSERT INTO bds_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeesu yaay day kara mara gu didiruge gu Iliitleemu. Qatlay giyaa ilii caacaahhaahhamisiye, hhapalooee da deni haa gaduũ gu Yahuudi yaagi khayri daqa dosii, gugi maasiri tuba, “Gimbaki haguri ⁄uuru gu tawaaloo mala yondimaamita, kara ha miyaa suguũ hadisi hiidahhasatee?” ");
INSERT INTO bds_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu gigi ilaki⁄isi inay tuba, “Ana see hangu maasa unkuray gimba leẽ. Bere sinoo kaaday, ana see sangoo kaawa, ti hari ⁄uuru gu miyaa yondimaamida gimbaki. ");
INSERT INTO bds_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Inkoo sini kaadee, hiinunqudimisu gu Yohaana, yaa kaadahhi? Yaa rawaa gu raw dahhi, baku yaa daqa hida dahhi?” Inay gi tlaatleesiri gimba inay haa inay tuba, “Bere dandiray hoo kaawana tuba, hiinunqudimisu gu Yohaana yaa rawaa gu raw dahhi daqa Iliitleemugo, ina hindoo maasi tuba, ‘Asu unkuray magwaa ⁄imbidiriiba?’ ");
INSERT INTO bds_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kara, bere hoo kaawana tuba, hiidahhasa dosi yaa daqa hida dahhada, haã tlaꞌamuudani raqati da hida hhanki. Maꞌaana, hida goõ yoó ⁄imbiyay tuba, Yohaana ti tletimiisay.” ");
INSERT INTO bds_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Teesaaqay, inay gi ilaki⁄isiri Yeesu tuba, “Dandiray ha hhidina.” Teꞌesii, Yeesu sigigi kaay tuba, “Ana see sangu kaawaaba, ti hari ⁄uuru gu tawaaloo mala yondimaamida gimbaki.” ");
INSERT INTO bds_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu gi ilakoomi gimba tuba, “Unkuray ha malee ilatahhaday gimbaki? Heedi waku yaa kona yaꞌay cada gu hhawatee. Ina gi hadakay daqa nankosii gu badiisuge, sugugi kaay tuba, ‘Nankoy, letuti taa⁄a yondiidi yondu qaymoo da sabiibuge.’ ");
INSERT INTO bds_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nakee gi ilaki⁄isi tuba, ‘Hadakawaaba.’ Teesaaqay see, qariqaaqari gii fooki ilahudaa kosi, gi yondu kay yondukira qaymooge. ");
INSERT INTO bds_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Da hheꞌesi, taatakee kosi gi hadakay daqa nankosii gu coko⁄uge, sugugi kaay idoo giĩ ilii kaay sa hikira gu didiru. Nakee gi ilaki⁄isi tuba, ‘Ee taataa, ha hadakaw.’ Teesaaqay see, nakee yaa hadakayba qaymooge.” ");
INSERT INTO bds_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Da hheꞌesi, Yeesu gi maasi inay tuba, “Ti naw haloo tla⁄aã gu hhankii gu cadage guũ yondiidu, idoo diĩ iliislaiye gooay ha taataa gosi?” Inay gugi ilaki⁄isiri tuba, “Hikira gu badiisu.” Teꞌesii, Yeesu sigigi kaay inay tuba, “Gu lou, sangu kaay unkuray ambee, karaanimaiĩ gu koodi haa slipalauusee, giyaadiyay hiiguma pandaa doogunay, Tawaaloo da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohaana Hiinunqudimiisay yaa khay daqa doogunay, sangugi laqami amoo daa tafaꞌadi, unkuray hagwaa ⁄imbidiriiba ina. Teesaaqay see, karaanimaiĩ gu koodi haa slipalauusee, yaa ⁄imbiri ya⁄aboo dosi. Unkuray gaamati antiri see gimbakee goõ, haa kwahhadiriiba tlakwaroo dooguna, haa gugi ⁄imbidiri ina.” ");
INSERT INTO bds_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeesu gi ilakoomi gimba tuba, “Itatiisa sangu kaay ilaꞌaaꞌaatisa waka. Heedi gu kooma qaymoo, yaa daamisi sabiibu qaymoo dosii. Ina gii khangaꞌasi qwaama qaymoo goõ, gi fooli bonda hhafidage sa iliitinqiru ⁄aamu gu sabiibu, haa gi tleehhi tlankoo sa ga⁄aw gu qaymootee. Da hheꞌesi, qaymotee gigi dubisi sa dooslimiisee wakinay, ina gi hhiyuudi hhapee wakayge da segenge. ");
INSERT INTO bds_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Qatlay gu we⁄inay gu sabiibu giyaa ilii day, ina yaa ya⁄abi tongee dosi daqa dooslimiisetiray, ma sugwaay oyiri bara da ⁄aamu gosi, bueemaa gu dubisaraa pahha. ");
INSERT INTO bds_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Teesaaqay see, tongetee dagagi ooyimi ha dooslimiisetira, leẽ gugi difiri, waku gugi gaasiri, kara waku gugi cakhadiniri hari tle⁄eẽ. ");
INSERT INTO bds_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Looimoo gu qaymoo gi ya⁄abi kara tongee wakinay wa⁄a, ba⁄ay da hhakira see gu pandaa. Teesaaqay see, dooslimiisetira gigi laqiri hhakee see, idoo giyaa laqiri gooay hhakira gu pandaa. ");
INSERT INTO bds_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Asunkuilee, gi ya⁄abi nankosi loi daqa dooinay, gi kaay tuba, ‘Inkoo, inay muriidiyay nankoy.’ ");
INSERT INTO bds_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dooslimiisetira giyaa ilii aniri nakee yaa khoci, gi gimbuusiri inay haa inay tuba, ‘Hiĩ na aalimiisayi gu qaymoti. Inkoo, hagu gaasanee, ma hiiowani aalimee dosi.’ ");
INSERT INTO bds_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Teesaaqay ina giyaa ilii day, inay gugi ooyiri, gugi duukhiri kenga gu qaymoo da sabiibuge, haa gugi gaasiri. ");
INSERT INTO bds_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Inkoo, looimoo gu qaymoo da sabiibu gimaa ilii khaye, dooslimiisetee gimaati malee laqi?” ");
INSERT INTO bds_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Inay gugi ilaki⁄isiri tuba, “Ina gimaati hhamisi sumuku hida hhakee gu tlakwi. Da hheꞌesi, qaymotee da sabiibu gigi dubisi kara sa dooslimiisee waka, gumaa hadisee bara da ⁄aamu gosi, qatlay gu buꞌuuꞌuruge.” ");
INSERT INTO bds_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Da hheꞌesi, Yeesu sigigi kaay inay tuba, “Unkuray kahhadaaii somaa Handikaa da Iliitleemu? ‘Tlaa⁄ukira giyaa siꞌiri tlehhidiisee, hikee hiĩ tlaa⁄u gu didiru tleehhidi gu musingi. Gimbaki yaa daqa Taataa Iliitleemu dahhi, kara guti hhou khisla daqa doorii.’ ");
INSERT INTO bds_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Teesaaqay, ana sangu kaawa unkuray ambee, Iliitleemu surukusi Tawaaloo dosi daqa doogunaa, haa gigi hadisi sa hida gu hhapapu wakinay, gu laqwalee ⁄aamu sa ina. ");
INSERT INTO bds_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Heedi gwii huua rawaa gu tlaa⁄ukii, hitii kereꞌemidi pencerehhemay haa pencerehhemay. Kara, heedi da iliihuuiye ha tlaa⁄uki, dugutii saadisi sumuku.” ");
INSERT INTO bds_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hhapalooee da deni haa Farisaayoo giyaa ilii akhasiri ilaꞌaaꞌaatimisukee gu Yeesu, yaa baraslayiri tuba, Yeesu inay giniĩ giimaamisi. ");
INSERT INTO bds_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Inay, gi dabiidiri amoo dari oowaraa ina. Inay yaa tlaꞌamuudiri raqatee da hida, sa gimba yaa aniri tuba, raqatee yaa anti Yeesu ti tletimiisay. ");
INSERT INTO bds_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu gi ilakoomi caacaahhamisu kara inay hari amoo da ilaꞌaaꞌaatimisu tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tawaaloo da rawaa gu raw hingaati slaaslaaqasidi haa mutemi waku, gwaa ⁄isimu sa nankosi losona gu khaboo. ");
INSERT INTO bds_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Qatlay gu losona giyaa ilii buꞌudi, ina gi ya⁄abi tongee dosi, ma eteediru kayri hida daa kwahhasuusi losonage. Teesaaqay see, hida hhakira daa kwahhasuusi, gi siꞌiri khawaraa losonage. ");
INSERT INTO bds_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ina gi kara ya⁄abi tongee wakinay, gi kaay sa inay tuba, ‘Taa⁄amida kawaa sa hida hhakira gaã kwahhasuusi ubee, “Yuꞌudaa! Losona guũ hheꞌesi guũ ilakhuukhuꞌusi. Ana haã hheꞌesi haã gaasi karaama doyi haa yakway gwaa wahhaahhaadee sa unkuray. Kara, gimba sliimaa duguũ hheꞌesi, kwahhasaa losonage.” ’ ");
INSERT INTO bds_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Teesaaqay see, hhakira daa kwahhasuusi, yaa iliiqaasiriiba hadakawa losonage. Inay gi tooinaa waaumidiri amamu koinayge, leẽ qaymoo dosii, waku yondu gosii. ");
INSERT INTO bds_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wakinay gwaa meetee, gi ooyiniri tongetee, gigi labaꞌasiri haa gigi cu⁄iri goõ. ");
INSERT INTO bds_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Teꞌesii, mutemi gi slahhaai hari khisla sa gimbakee. Ina gi ya⁄abi sirikaarii dosi, gi cu⁄iri cu⁄udiisetee, diĩ cu⁄udi tongee dosi, haa gi hhamisiri yaamu koina. ");
INSERT INTO bds_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Da hheꞌesi, gi kaay sa tongee dosi tuba, ‘Losona gu khaboo hiĩ hheꞌesi hiĩ buꞌudi. Teesaaqay see, hhakira gaã kwahhasuusi, haringii boo⁄iriiba khawaraa losonage. ");
INSERT INTO bds_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Inkoo, taa⁄amida amamu cadiyoo gu yaamuge, kwahhasuusaa hida goõ goo slaydee, yaa khayee losona gu khabooge.’ ");
INSERT INTO bds_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Teesaaqay, tongetee gi waaudiri amamu cadiyoo gu yaamuge. Inay yaagii kurunkuriri haa hiraagi khayri losonage, hida goõ giyaa slaslayri, hida gu hhoi haa hida gu tlakwi. Waauu gu losona gu khaboo gi tosaa haci dahaa wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mutemi giyaa ilii day waauuge sa arimaa dahha kosi, gi arimi teꞌesii, heedi leẽ gwaaba daasa qayriya da khaboo. ");
INSERT INTO bds_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mutemi gi maasi heedikee tuba, ‘Danaꞌa goy, ugu haani malee gii daadi tiꞌii waauuge, tay haguba daasa qayroo gu khaboo?’ Heedikee yaa konaaba gimba lensee gu ilaki⁄isa. ");
INSERT INTO bds_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Da hheꞌesi, mutemi gi kaay sa tongee dosi tuba, ‘Khiidimakuna dabaiĩ kosi haa yeꞌeeroo kosi, lugu kwahhakayday khoorooge yade hhanteege. Taysi daganimaa ilii wana ⁄aa⁄imu haa tluꞌuru gu ⁄atloo, sa slahhaaꞌamee da labaꞌasu.’ ");
INSERT INTO bds_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Maꞌaana, hida doó eteedine ha Iliitleemu ti wa⁄a. Teesaaqay see, hida doóyii lehhidiye ti coko⁄o.” ");
INSERT INTO bds_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Da hheꞌesi, Farisaayoo gii kurunkuridiri haa gi gimbuusiri inay haa inay, idoo gi ilii hatlinee Yeesu hari gimba gosi. ");
INSERT INTO bds_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Inay gi ya⁄abiri daqa dosii sirakoomiisee dooina, sliimaa haa raqa daa iliiaꞌaaꞌawa mutemi Heroode tawaaloo dosiige. Inay gi kaayri sa Yeesu tuba, “Maarimuu, dandiray ha khuana tuba, ugu ti heedi gu lou. Ugu hoóti caacaahhamisida gimba gu Iliitleemu hari amoo da loi, hoó tlaꞌamutaaba heedi lensee, sa gimba hoó hiilehhitaaba hida. ");
INSERT INTO bds_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Inkoo sandi kaade dandiray, ugu ha malee ilahudeedemisida gimbaki? Ti naraꞌaa buꞌuduu koodi sa Kaysaari, baku ti naraꞌaaba?” ");
INSERT INTO bds_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Teꞌesii, Yeesu yaa caahhi piimaa dooina da tlakwi, sigigi kaay inay tuba, “Unkuray ye peereehhiisee! Sa soꞌoyi slaꞌaday hatliru ana? ");
INSERT INTO bds_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Inkoo, Sini laqantee goboriya goó hadisidee sa buaraa koodi.” Teꞌesii, inay yaagii oyiri goboriyatee haa gigi hadisiri sa ina. ");
INSERT INTO bds_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeesu gigi maasi inay tuba, “Kalay haa uma gu miyaa na wana goboriyatii?” ");
INSERT INTO bds_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Inay gugi ilaki⁄isiri ina tuba, “Gu Kaysaari.” Teꞌesii, Yeesu sigigi kaay tuba, “Inkoo, idadu gu Kaysaari hadisa sa Kaysaari, idadu gu Iliitleemu hadisa sa Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Qatlay hida hhakee giyaa ilii akhasiri ilaki⁄isatee da Yeesu, yaati bakairi. Inay gugi mayri ina, gi tooinaa waaudiri. ");
INSERT INTO bds_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Baloteesii loi loii, Sadukaayoo hida goó kaawee tuba, wantaaba slafaraa da hida gwaa kaka⁄ee, wakinay tla⁄aã gooinaa, gi hadakayri daqa Yeesuge haa gugi maasiri kakaanay tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maarimuu, Musaa hindaa caacaahhamisi tuba, bere heedi gwaa khabimu hiĩ hhami, guba slawa yaꞌay, hhia gosi kwanda gi aaline kwaꞌalitoꞌotee, ma laqwali yaꞌay sa hhia gosi. ");
INSERT INTO bds_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Inkoo, daqa doorii yaa wanay hhiee fanqu. Hhia gooina gu badiisu yaa khabimi hadee, qariqaaqari gi hhami, guba slawaraa see yaꞌay haa hadetee. Haa sa gimba yaa slayiiba yaꞌay haa hadetee, gi may sa hhia gosi gu coko⁄u hadetee. ");
INSERT INTO bds_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gimbakee gii ca⁄i teesaaqay daqa hhia gu cadage, daqa hhia gu tamige, haa gi ilakoomi teesaaqay daqa hhiee hhakiray goõ fanqu. Inay goõ gi hhamaahhaniri, guba slaslaw see yaꞌay. ");
INSERT INTO bds_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Asunkuilee hadetee see gi hhanti. ");
INSERT INTO bds_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Inkoo sandi kaade, baloo hida gwaa kaka⁄ee gimaa iliislafisiye yaagii ca⁄iyay ayisasugo, hadetee maa hadee da miyaa tla⁄aã gu hhiee hhakiray fanquge? Sa gimba inay gonkoinaa giyaa khabiibiniri hadetee.” ");
INSERT INTO bds_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu gigi ilaki⁄isi inay tuba, “Unkuray haã dakusidiri ilahudaa teesaaqay, sa gimba hhidintay Handikaa da Iliitleemu, kara ha hhidintay ⁄uuru gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Qatlay hida gwaa kaka⁄ee gimaa iliislafiyee yaagii ca⁄iyay ayisasugo, maa khabiibinaaiiba haa digimaa khabiibinaaba. Qatlaykeesii inay maati ibiidiyay malayika da Iliitleemu pahha rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kara gimba gu slafimaa gu hida gwaa kaka⁄ee, unkuray kahhadaaii somaa gimba sangwaa kaay Iliitleemu? Sangwaa kaay tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ana na Iliitleemu gu Aburahaamu, Iliitleemu gu Isaaka haa Iliitleemu gu Yakoobo.’ Ina ti Iliitleemu gu hida gwaa kaka⁄ee gooba. Ina, ti Iliitleemu gu hida gu slafee.” ");
INSERT INTO bds_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Raqatira da hida giyaa ilii akhasidi gimbakee, digaa bakaꞌasi hari khisla ha caacaahhamisu gosi. ");
INSERT INTO bds_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Qatlay Farisaayoo giyaa ilii akhasiri tuba, Yeesu hiĩ qabiqabisi Sadukaayoo hari ilaki⁄isa dosi, inay gii kurunkuridiri sliimaa daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Leẽ tla⁄aã gooinay yaa maarimuu gu sariyaa da diini da Yahuudi, ina gi maasi Yeesu hari hatliru tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maarimuu, ilakaawa haloo na didiri sariyaage hiicataraa da goõ?” ");
INSERT INTO bds_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu gugi ilaki⁄isi ina tuba, “ ‘Slae Taataa Iliitleemu, Iliitleemu googu, hari ilahudaa koku goõ, hari slafimaa koku goõ, hari waaway googu goõ.’ ");
INSERT INTO bds_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Haã na ilakaawa da didiri haa da kaari ba⁄ay ilakaawa goõ. ");
INSERT INTO bds_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ilakaawa da cadii dingaa slaaslaaqasidi haa hatee na nahaã tuba, ‘Slae hida danaee koku, idoo hangu iliislaꞌade gooay ugu lenkoogu.’ ");
INSERT INTO bds_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sariyaa da Musaa, haa caacaahhamisu gu tletimiisee da Iliitleemu, yoó daqa ilakaawati da cada dahhi.” ");
INSERT INTO bds_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Qatlay Farisaayoo giyaa ilii kurunkuridiri sliimaa, Yeesu gigi maasi inay tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Unkuray hoó malee ilahudeemisiday tuba, Kristu na miyaa? Kara ina ti Nanku miyaa?” Inay gugi ilaki⁄isiri tuba, “Ina ti Nanku Dawdi.” ");
INSERT INTO bds_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeesu gi kaay sa inay tuba, “Inkoo, hiti malaaꞌay tuba, hari ⁄uuru gu Muuna gu Iliitleemu, Dawdi gu eteedina ina ‘Looimoo gu Goõ,’ kara, kakaana tuba, ");
INSERT INTO bds_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Taataa Iliitleemu, yaa kaay sa Looimoo goy gu Goõ tuba, ‘Ibiidi hari bara doyi da ⁄uya, qatlaykaꞌa naqatloo gamaa ilii qaase fa⁄ayaa doogu, biraa gu yeꞌeeroo kokuu.’ ");
INSERT INTO bds_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Inkoo, bere Dawdi, Masiiya gwaati eteediidina, ‘Looimoo gu Goõ.’ Inkoo Masiiya malee kara nankosi tleehhidi?” ");
INSERT INTO bds_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Teꞌesii, wanaaba heedi gwaay dahhasu ilaki⁄isa Yeesu gimba lensee. Tlaatleesoo da baloteesaa, wanaaba heedi lensee gwaa koisu kara maasa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Qariqaaqari, Yeesu gi kaay sa raqatee da hida, sliimaa haa sirakoomiisee dosi tuba, ");
INSERT INTO bds_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Maarimamaa da sariyaa haa Farisaayoo konay hiidahhasa da caacaahhamisu hida sariyaa da Musaa. ");
INSERT INTO bds_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Inkoo, unkuray muriidakina inay haa yondiida gimba goõ dangoo ilafahhadiye. Teesaaqay see, hhanti sirakontay yondu gooina, sa gimba inay yoó yondiidiyaaiiba, gimba giyoó kakaanee. ");
INSERT INTO bds_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Inay yoóti ⁄uureemisiyay hida, ma yondiidiri gimba gwaa karaarahhu haa gwii lou. Teesaaqay see, inay loi yoó koisiyaaiiba yondu, gimba gumati coko⁄u see, sa iliiawaraa inay yondukee gwii loou. ");
INSERT INTO bds_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inay yoóti yondiidiyay gimba goõ, digima arimi ha hida. Inay yoótii kufiminay pandaduge haa dabainge idadu daa boo⁄imisi hari faloo hiriisaaee pahha, gwaa koomee waꞌay koinay daqeemoo gu handikaa da sariyaa. Kara, yoóti tledeemisiyay sansabiloo gu qayroo koina. ");
INSERT INTO bds_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Qatlay gu losonage, yoó slaiyay ibinaa kiteeri doó ilii ibiidiye dahaa gu muree, haa sinagoogige yoóti slaiyay ibinaa kiteeri gu pandaage. ");
INSERT INTO bds_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Slime, inay yoóti slaiyay digima cehheemisi ha hida hari muree sokooniige, haa digigi eteedina ‘Maarimamaa.’ ");
INSERT INTO bds_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Inkoo, unkuray dangu hhanti eteedina, ‘Maarimamaa,’ sa gimba, Maarimuu googuna ti leẽ kilesi, unkuray goõ ti hhiee. ");
INSERT INTO bds_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Slime, unkuray hhanti eteedintay heedi lensee, ‘Taataa,’ tiꞌii khoorooge, sa gimba, Taataa googuna ti leẽ kilesi, ina gu rawaa gu rawge waara. ");
INSERT INTO bds_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kara, unkuray dangu hhanti eteedina ‘Giyaadimiisee,’ sa gimba Giyaadimiisay googuna ti leẽ kilesi, na Kristu. ");
INSERT INTO bds_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Heedi gu didiru ba⁄ay da unkuray goõ tla⁄aã googunay, ina kwanda gi yondimiisay googuna tleehhidiye. ");
INSERT INTO bds_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Heedi gungoó hiitlaysa ina lenkosi, hikee dugu hii⁄eetisi ha Iliitleemu. Kara hikaꞌa gungoó hii⁄eetisa, hikee dugu hiitlaysi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hoo antayi, unkuray maarimamaa da sariyaa haa Farisaayoo, unkuray peereehhiisee! Unkuray ha pingiigintay sa hida afamaraa gurii guuma Tawaaloo da rawaa gu rawge, tay unkuray loi see, hiiguntaaiiba tawaaloteesii. Kara, ha tlahhaahhamisiday hhakee, gu slaee hiiguuma teꞌesii. ");
INSERT INTO bds_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hoo antayi, maarimamaa da sariyaa haa Farisaayoo, unkuray peereehhiisee! Unkuray hoóti hhiyumitay hhiyuuma da tleedi tlo⁄osaa gu tlawa da didiri, haa hhapee da kaarunge, ma laalaagidiri ma heedi lensee, ma sirakoomiisay gu diini dooguna tleehhidi. Qariqaaqari hagoó iliislaydee, unkuray hagoóti ⁄isintay ina, marii boo⁄i ⁄agitiru waa cada aslaa da Jehanaamuge, ba⁄ay da unkuray see. ");
INSERT INTO bds_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hoo antayi, unkuray giyaadimiisee daa ilahhamaahhanti! Unkuray hoóti kaaday tuba, ‘Heedi gu seelima hari uma gu mara gu didiru gu Iliitleemu, seelirukee ti idoo gooba. Teesaaqay see, heedi gu seelima hari idadu gu sahaabu gu waꞌay gu mara gu didiruge waaree, ina kwanda gi yondiidiye idoo giĩ seelimi.’ ");
INSERT INTO bds_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unkuray gwaa ilahhamaahhamee haa gwaa bawmidee! Ti idoo mala na kaari hari khisla? Ti sahaabu, baku ti mara gu didiru gu Iliitleemu, goó ⁄isima sahaabute dagama faadi dagaa tlintiꞌisi sa Iliitleemu? ");
INSERT INTO bds_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kara hoó kaaday tuba, ‘Heedi gu seelima hari masabaahu ti idoo gooba. Teesaaqay see, heedi gu seelima hari sadaaka diĩ qaasi rawaa gu masabaahuge sa Iliitleemu, hikee kwanda gii gaasiye seeliru gosi.’ ");
INSERT INTO bds_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Unkuray gwaa ilahhamaahhamee! Ti idoo mala na kaari? Ti sadaaka, baku ti masabaahu doó ⁄isima sadaakatee dagama tlintiꞌisi sa Iliitleemu? ");
INSERT INTO bds_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Teesaaqay, heedi gu seelima hari masabaahu, yoóti seelina hari masabaahutee haa idadu goõ, diĩ qaasi rawaa gu masabaahuge. ");
INSERT INTO bds_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kara, heedi gu seelima hari mara gu didiru gu Iliitleemu, ina hiti seelina hari marakee gu didiru, haa Iliitleemu, ina goó ibiida marakeesii. ");
INSERT INTO bds_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kara, ina goó seelima hari rawaa gu raw, yoóti seelina hari kitiĩ gu tawaaloo gu rawaa gu rawge waara, haa hari uma gu Iliitleemu goó ibiida rawaa gu kitikeesii. ");
INSERT INTO bds_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hoo antayi, unkuray maarimamaa da sariyaa haa Farisaayoo, haa peereehhiisee! Unkuray hoó maguumitay hadimisu leẽ da mibi da munanaa, binsaarii haa jiira, tay hoó iliiqaasidaaiiba gimba gu kaaru gu sariyaa da Iliitleemu, taqay da haaki gooay, ⁄awaariru haa ⁄imbaraa. Hiĩ na gimba gu kaaru gaã aloo yonditee, da hheꞌesi dangugi may afahhama yondiida hikee see waku gu digidaku. ");
INSERT INTO bds_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unkuray giyaadimiisee gwaa ilahhamaahhamee! Unkuray hoóti maguumitay biraacanqamisu ineerimoo maꞌay kokunaa gu kitahhugo, tay hagi gwi⁄imintay gamiyaa. ");
INSERT INTO bds_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hoo antayi, maarimamaa da sariyaa haa Farisaayoo, unkuray, peereehhiisee! Unkuray hoótii hhunciday qulu⁄uu haa saanii hari khooroo kilesi. Teesaaqay see, waꞌay gu muunaiĩ kokunay daati haci idadu gu afii⁄utlidu haa hheehha. ");
INSERT INTO bds_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ye Farisaaymoo gwaa ilahhamu! Gesaa hhuncii qulu⁄uu haa saanii hari waꞌay, hari danda see yoo asu ilabuꞌudiyay. ");
INSERT INTO bds_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hoo antayi, unkuray maarimamaa da sariyaa haa Farisaayoo, haa peereehhiisee! Unkuray hangwati slaaslaaqasidiri haa ayisasu daa maakhi hari cakalaa, doó arine gu hhoi hari khooroo kilesi. Teesaaqay see, waꞌayge daati haci fararu gu hida gwaa kaka⁄ee haa slasla⁄iima wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Namati teesaaqay, unkuray hari khooroo pandaa da hidage, dangoóti arina kontay ibinaa daa tafaꞌadi. Teesaaqay see, waꞌay gu muunaiĩ kokunay unkuray haati hacidiri peereehhii haa tlakwaroo wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hoo antayi, unkuray maarimamaa da sariyaa haa Farisaayoo, haa unkuray peereehhiisee! Unkuray hoóti tlehhitay ayisasu gu tletimiisee da wakaꞌalee da Iliitleemu haa hoóti tlemiday ayisasu gu hida gu koomee ibinaa daa tafaꞌadi. ");
INSERT INTO bds_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kara, hoó kaaday tuba, ‘Bere haati aloo ibiidana balalu hhakiray gu ayiĩ kotii, hangaa ilagaasanaaba haa inay, cu⁄uduũ gu tletimiisee da Iliitleemu.’ ");
INSERT INTO bds_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Inkoo, hari kaawaraa teesaaqay, unkuray hanti ilatlaydiri tuba, unkuray ti laqwaloo da hida hhakira, gwaa cu⁄ee tletimiisee da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inkoo, aarimida gaasaw yondukira gu tlaku giyaa tlaatleesiri ayiĩ kokuna! ");
INSERT INTO bds_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Unkuray ti deesasee, kara ti laqwaloo da deesasee, gu koomee qada gu dihhu! Unkuray hii⁄ipidaaiiba hukumuu gu aslaa da Jehanaamu doóba hhamaraa. ");
INSERT INTO bds_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa gimbaki, yuꞌudaa ana haa ya⁄aba daqa doogunay tletimiisee, hida gu koomee waaway haa maarimamaa. Wakinay tla⁄aã gooinay, unkuray hagimaa cu⁄uday, wakinay hagimaa hiitluhhumisiday, wakinay hagimaa difiday hari hhadoo sinagoogaguu kokunay, haa gigi gusisintay yaamu haa yaamu. ");
INSERT INTO bds_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Teesaaqay, ceedee da hida goõ gu koomee ibinaa daa tafaꞌadi, daa tuutuquti maa daqa doogunay wante. Haa teesaaqay laqadiri tlaatleesoo da ceedee da Abeeligo, gwaa kooma ibinaa daa tafaꞌadi, ceedee da Sakariyaa naqatloo nanku Barakiyaa, gaa gaasidiri mara gu didiruge gu Iliitleemu, tla⁄antla⁄a gu daqa daa tlintiꞌisige haa masabaahu. ");
INSERT INTO bds_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gu lou, sangu kaay unkuray ambee, hukumuu gu gimbaki goõ gu tlaku giyaa yondiidiri yaati khay daqa laqwalotii. ");
INSERT INTO bds_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","De Yerusaleemu, Yerusaleemu, doó cu⁄a tletimiisee da Iliitleemu, haa gi cakhadinta hari tle⁄eẽ, hhakira daa ya⁄abi daqa doogii! Kara ti waa maka ana haa slaꞌa hiikurunkura yaꞌay koki, konkiya gooay idoo giyoó ilii kurunkuride concaa dosi biraa gu hhababeeraa kosii. Teesaaqay see, unkuray haa siꞌidiri. ");
INSERT INTO bds_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yuꞌudaa! Yaamu kokuna digiĩ may makeebauumaage. ");
INSERT INTO bds_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gu lou, sangu kaay, ana hanimaa antaaiiba kara, qatlaykaꞌa naqatloo gamaa ilii kaadee tuba, ‘Dugwaa ⁄aafi hikee gwaa khawa hari uma gu Looimoo gu Goõ.’ ” ");
INSERT INTO bds_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Inkoo, Yeesu giyaa iliica⁄i efeenaa da mara gu didirugo gu Iliitleemu, sirakoomiisee dosi gugi ilii hadakayri, ma sugu laqaniri tlehhinay gu marakee gu didiru. ");
INSERT INTO bds_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Teꞌesii, ina sigigi kaay inay tuba, “Maraki goõ haguũ antirii? Gu lou sangu kaay, maa wantaaba tlaa⁄a lensee damaa meeta rawaa gu tlaa⁄a wakay, tle⁄eẽ goõ digimaati muumu⁄una.” ");
INSERT INTO bds_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Qatlay Yeesu giyaa ilii ibiidi oõ gu Miseyituunige, sirakoomiisee dosi yaagi khayri daqa dosii inay kilakoina, haa gugi maasiri tuba, “Sandi kaade, gimbaki maa malaalee hiica⁄i? Kara mala namaa laqanta khawaraa doogu, haa hiifaakoo da qatlay?” ");
INSERT INTO bds_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu sigigi ilaki⁄isi inay tuba, “Hangu ga⁄aydee, heedi lensee hhanti hiicori unkuray. ");
INSERT INTO bds_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sa gimba, hida wa⁄a yaa khakhayay hari uma goy, tay kakaanay tuba, ‘Ana na Kristu,’ kara inay maa hiicoridiyay hida wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Qatlaykeesii maa akhamisidayi gau haa sahhasahhay gu gau, unkuray harimaa hhantii tlaꞌaday. Gimbakee kwanda gii ca⁄iye gesaa, baloo da hiifaakoo loi kahhada. ");
INSERT INTO bds_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hhapee leẽ maa qwaatlida haa hhapee waka, tawaaloo leẽ maa qwaatlida haa tawaaloo waka. Kara, damaa wana qori haa kintleemoo daqeemoo paslaapasloo. ");
INSERT INTO bds_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gimbaki sliimaa ti tlaatleesoo kilesi, ti tlaatleesoo gu ba⁄adaa gu hadee da slaꞌa hiidawa. ");
INSERT INTO bds_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Qatlaykeesii, hida gu hhapapu goõ hangumaa ooyinayi, danguma leehhisi labaꞌasuge haa maa cu⁄iyay unkuray. Kara inay hangumaa wakiyay, sa gimba gu uma goy. ");
INSERT INTO bds_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hida wa⁄a maa mayay ⁄imbaraa dooina gi konee daqa dooii, hingimaa hiifookimidiyay inay haa inay haa hingimaa wakaawakiyay. ");
INSERT INTO bds_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kara, tletimiisee wa⁄a da afaꞌafuuma maay caca⁄ada, haa maa hiicoridiyay hida wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tlakwaroo maay roogita, sa gimbakee slaꞌamuu gu hida wa⁄a maa caaquumidi. ");
INSERT INTO bds_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Teesaaqay see, heedi gumaa hiikaasa ⁄imbaraage hiifaakoo naqatloo, hikee dugunimaa ilabuꞌuna ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gimbaki gu Hhou gu Tawaaloo da Iliitleemu, dugu kakaana khooroo gonge, ilatlawa pahha sa hida gu hhapapu goõ. Teꞌesii, hiifaakoo da khooroo maa asu khayda. ");
INSERT INTO bds_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Teesaaqay, hamaa antayi slahhaaꞌasa da slasla⁄iima, hiĩ sihhiti daqa daa tlintiꞌisige. Gimbaki dugwaa gimbuusi ha tletimiisay Danieeli. Heedi gu somima gimbaki caahhiye maꞌaana dosi. ");
INSERT INTO bds_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Qatlay gamaa ilii antee teesaaqay, kwanda hida goó hhapee da Yudaayage ibiidee, maati cira lakidiyee omeerige, ma ba⁄aniri. ");
INSERT INTO bds_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Baloteesii, heedi damaa slaye rawaa gu pembeege, hhantii hii⁄eeti sa hiiowaraa idadu kosi waꞌay gu marago. ");
INSERT INTO bds_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kara, heedi damaa slaye qaymooge, maa hhanti ki⁄i ayage sa hiiowaraa jurungii dosi. ");
INSERT INTO bds_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gu lou, hamaa antayi balalu hhakee gumaa tlakwi hari khisla daqa tigay gumaa koomee hubay haa hhakaꞌa gumaa ruꞌumisee daa⁄a⁄ee! ");
INSERT INTO bds_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Inkoo, firima Iliitleemu lakidimoo googuna, maa hhantii ca⁄i qatlay gu madenge, baku baloo da Sabaatoge. ");
INSERT INTO bds_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Qatlaykee damaa wana labaꞌasu gu didiru. Labaꞌasu da hikee gooay kahhi hiica⁄a yadaa tlaatleesoo da khooroogo haa letuti naqatloo, slime etaa maa hiica⁄iyaaba da hikee gooay. ");
INSERT INTO bds_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bere Iliitleemu yaa aloo ilakereꞌesiyaaba balalu hhakee gu labaꞌasu, wanaaba heedi lensee, gwaa aloo ba⁄ama. Inkoo, sa hida kosi giyaa hiileehhi, Iliitleemu ilakereꞌesi balalu hhakee. ");
INSERT INTO bds_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Qatlaykeesii, bere maa akhasidayi hida kakaanay sa unkuray tuba, ‘Yuꞌudaa! Kristu wana tiꞌii!’ Kara wakinay bee, ‘Wana yade!’ Hamaa hhanti ⁄imbiday, hikee ti gimba gu afaꞌafuuma kilesi. ");
INSERT INTO bds_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gu lou, qatlaykeesii, damaa hiica⁄i hida wakinay hingumaa hiiduubee tuba, inay na Kristu. Kara, damaa hiica⁄i tletimiisee da afaꞌafuuma see. Afaꞌafuusetee maa laqaaqanay gimba gu denu gu afaꞌafuuma haa gimba gu bakaꞌasa hida, ma koisiri hiicoriduu hida daa hiileehhi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yuꞌudaa, ana sanguũ kaay unkuray gimbaki sliimaa, qatlay gi ilii kahhiye hiica⁄araa. ");
INSERT INTO bds_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Teesaaqay, bere hida wakinay kaayiyay sa unkuray tuba, ‘Yuꞌudaa, Kristu wana yade kongoqomeege,’ unkuray hhanti hada kayday yade. Slime bere kaayay tuba, ‘Yuꞌudaa, wana sagayge,’ unkuray hhanti ⁄imbiday. ");
INSERT INTO bds_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nanku Heedi khawaraa dosi, maa mankaraaiya pahha taqay, idoo giyoó ilii mankaꞌaside ilacindoo gu rawaago, ilacindoo gu biraa naqatloo. ");
INSERT INTO bds_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Namati teesaaqay, daqa da iliiwane sayni, teꞌesii gwadiisu ginoó ilii kurunkuridi. ");
INSERT INTO bds_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Qariqaaqari damaa iliicatiye balalu hhakira gu labaꞌasu, ‘Letu dagamaay bo⁄eesi. Slehheẽ maay da⁄iyaaba, tica⁄eerii maay huhuiyay rawgo, ⁄uuru gu idadu gu rawge waaree, dugumaa rinqirinqisi.’ ");
INSERT INTO bds_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Da hheꞌesi, laqaru gu Nanku Heedi dugumaa arina rawaa gu rawge. Teꞌesii, hida gu hhapapu goõ khoorooge maa gaiidiyay. Inay gumaa arinayi Nanku Heedi, yaa hii⁄eeti hari tlonga rawaa gu rawgo, hari ⁄uuru haa wanqamee da hhoinay gu didiru. ");
INSERT INTO bds_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Afoo da didiri da paranda dagamaa hiifahhi rawaa gu rawge. Teꞌesii, ina maa ya⁄abi malayika dosi, inay maa hiikurunkuriyay hida kosi giyaa hiileehhi, bareemoo cigahhago gu khooroo goõ. ");
INSERT INTO bds_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Inkoo, hari amoo da ⁄ancimoo hangu caacaahhamisidee ilaꞌaaꞌaatisateesaa. Qatlay elemu kosi giyoó iliinaana⁄iyee haa loo⁄oo dosi yaagi kucufida, teꞌesii unkuray hoó caahhaday tuba, qatlay gu madeẽ yaani daadaauusi. ");
INSERT INTO bds_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Namati teesaaqay, qatlay unkuray gamaa ilii antee gimbaki goõ sanguũ kaay hiicaca⁄i, caahha tuba, Nanku Heedi yaani daadaauusi ki⁄araa, ilaciyaa gu afamaraage wana. ");
INSERT INTO bds_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gu lou, sangu kaay unkuray ambee, laqwaloti da inkoo hiicatidaaba, qatlaykaꞌa naqatloo gimbaki goõ gimaa iliica⁄iye. ");
INSERT INTO bds_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Raw haa hhapee maa hiihhancooiyay. Teesaaqay see, gimba goy maa hiihhancooiyaaba coko⁄o see.” ");
INSERT INTO bds_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yeesu gi ilakoomi gimba tuba, “Hhaku heedi lensee gu khua baloo haa qatlay gu hiifaakoo, malayika see rawaa gu rawge hhidinay, Nanku Iliitleemu see hhidina. Balotee Taataa kilesi naga khui. ");
INSERT INTO bds_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Idoo daa iliiwane gooay balalu hhakira gu Nuuhu, teesaaqay daganimaa ilii wana, qatlay Nanku Heedi gimaa iliiki⁄iye khoorooge. ");
INSERT INTO bds_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Balalu hhakira qatlay ilawa⁄iya giyaa ilii kahhade khawa, hida yaa ⁄agiiginay haa yaa kitahhaahhanay, yaa khabiibinay haa digaa khabiibina, balotira naqatloo, Nuuhu giyaa ilii day waꞌay gu safiinage. ");
INSERT INTO bds_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hida hhakee yaa baraslayiriiba ti idoo mala naay ca⁄ada, balotira naqatloo ilawa⁄iya giyaa ilii khaydi, digigi takoobi goõ. Teesaaqay daganimaa ilii wana, qatlay Nanku Heedi gimaa ilii khaye. ");
INSERT INTO bds_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Qatlaykeesii, hida cada maa qaymooge wanay, leẽ dugumaay oyi, leẽ dugumaa may. ");
INSERT INTO bds_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tigay cada maa saadiidinay sliimaa, leẽ dagamaay oyi, leẽ dagamaa may. ");
INSERT INTO bds_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Inkoo diliqa, sa gimba ha hhidintay ti baloo haloo, Looimoo googuna giyaa iliiki⁄iye. ");
INSERT INTO bds_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Unkuray caahha naraꞌa gimbaki. Bere looimoo gu mara hiti caahhi qatlay daa ilii khaye fiisiisay, hiisee⁄iyaaba mara gosi duguma cihhi ha fiisiisee. ");
INSERT INTO bds_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Teesaaqay, unkuray see hangu ilakhuukhuꞌusidee naraꞌa, sa gimba, Nanku Heedi himaati khay, qatlay unkuray hangoóba iliipaꞌaru.” ");
INSERT INTO bds_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeesu gi ilakoomi gimba tuba, “Ti miyaa na tongimoo daa ⁄imbi haa gu kooma waaway, daa qaasi ha looimoo gosi, ma wariiqadimidi tongee dosi wakinay, haa sigima hadimisi ⁄agoo hari qatlay daa qaasige? ");
INSERT INTO bds_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dugwaa ⁄aafi tongimokaꞌa, looimoo gosi gimaa iliiki⁄iye hhiyuumago, gugi slay ina yondiidi, yondukira sugwaa taatahhi. ");
INSERT INTO bds_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gu lou, ana sangu kaawa unkuray ambee, looimoo gosi gu qaasi tongimokee, ma wariiqadimidi khooslay gosi goõ. ");
INSERT INTO bds_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Inkoo, ilatahha tongimokee gu tlaku, ina ilahudeesi muuna gosii tuba, ‘Looimoo goy yaanii kaai ki⁄araa.’ ");
INSERT INTO bds_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Da hheꞌesi ina tlaatleesi difoo tongee deneꞌee kosi, tay ⁄agina haa kitahhana sliimaa haa oonimiisee. ");
INSERT INTO bds_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Looimoo gu tongimokee yaati khay, baloo gubasli iliipaꞌaru haa qatlay gi hhidine tongimokee. ");
INSERT INTO bds_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Teꞌesii, looimokee gutii kerekereꞌemisi tongimokee bareemoo haa bareemoo, haa gugi qaasi raqa lenge sliimaa haa peereehhiisee. Taysi daganimaa ilii wana ⁄aa⁄imu haa tluꞌuru gu ⁄atloo, sa slahhaaꞌamee da labaꞌasu.” ");
INSERT INTO bds_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yeesu gi ilakoomi gimba tuba, “Qatlaykeesii Looimoo gu Goõ gimaa iliiki⁄iye, Tawaaloo da rawaa gu raw, hingimaati slaaslaaqasi haa sagameeru mibi pahha, gwaay owee caaꞌasoo dooina, gi waaudiri sa amoodabaawa looimoo gu khaboo. ");
INSERT INTO bds_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sagameeru kooani tla⁄aã gooinay yaa bawmidiri, kooani yaa konay waaway. ");
INSERT INTO bds_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hhakira gwaa bawmidee qatlay giyaa ilii oyiri caaꞌasoo dooina, inay yaay oyiriiba du⁄iya waka da hiiroogisa. ");
INSERT INTO bds_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hhakira gwaa koomee waaway, inay yaay oyiri caaꞌasoo dooina sliimaa haa khooslay gu du⁄iya waka. ");
INSERT INTO bds_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Inkoo, looimoo gu khaboo giyaa ilii kaai khawaraa, sagameerukee goõ gi tlaatleesiri gufimisu, haa gi tooinaa guiri. ");
INSERT INTO bds_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Qatlay gu amasidiira, maahhoo dagagi akhasi kakanta tuba, ‘Yuꞌudaa! Looimoo gu khaboo yaa khoci! Ca⁄aaruu, taa⁄amida amoo dabaawakuna.’ ");
INSERT INTO bds_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Da hheꞌesi, sagameerukira goõ mibi gii tlayri guꞌudeego, gi ilakhuukhuꞌusiri caaꞌasoo dooina. ");
INSERT INTO bds_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hhakira gwaa bawmidee gi kaayri sa hhakira gu koomee waaway tuba, ‘Sandi qaydee du⁄iya dooguna coko⁄o, sa gimba caaꞌasoo doori hiĩ tlaatleesiri hhamaahharu.’ ");
INSERT INTO bds_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Teꞌesii, hhakira gu koomee waaway gi ilaki⁄isiri inay tuba, ‘Suti, du⁄iyati buꞌudisidaaba dandiray haa unkuray. Taa⁄amida daqa hida goó naadimee du⁄iya, sangwaay kirigidee.’ ");
INSERT INTO bds_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Inkoo, hhakira gwaa bawmidee giyaa ilii waaudiri sa kiriga kawa da du⁄iya, looimoo gu khaboo yaagi khay. Teꞌesii, sagameerukira gu kooani gungaa ilakhuukhuꞌusu, gii guniri sliimaa haa ina losona gu khabooge, da hheꞌesi afamaraa dugugi khiidimi. ");
INSERT INTO bds_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Qariqaaqari, sagameerukira wakinay inay see yaagi khayri, gi eteediri tuba, ‘Looimoo, looimoo, sandi afiiooyinte afamaraa!’ ");
INSERT INTO bds_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Teꞌesii, looimoo gu khaboo gigi ilaki⁄isi inay tuba, ‘Gu lou sangu kaay ambee, ana hangu hhidima unkuray!’ ");
INSERT INTO bds_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Inkoo diliqa, sa gimba ha hhidintay baloo gimati qatlay see, Nanku Heedi gimaa iliiki⁄iye.” ");
INSERT INTO bds_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yeesu gi ilakoomi gimba tuba, “Tawaaloo da rawaa gu raw maa ilaꞌaaꞌaatisa da heedi waku pahha, gwaa slaꞌa hhiyuuda yaamu gu segenge. Ina yaa eteedi tongee dosi, haa sigigi taatahhi khooslay gosi, magu haraa iliikoniri. ");
INSERT INTO bds_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ina gi taatahhi sa tongimoo leẽ talanta kooani, sa waku sugugi taatahhi talanta cada, kara waku sugugi taatahhi talanta leẽ. Da hheꞌesi, ina gi tosaa waaudi hhiyuuma dosiige. ");
INSERT INTO bds_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hikira saa taatahhi talanta kooani, cirakiray lenge gi waaudi haa gi kirigirukay, gi slay faydaa talanta waka kooani. ");
INSERT INTO bds_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Namati teesaaqay, hikira see saa taatahhi talanta cada, ina see gi slay faydaa talanta waka cada. ");
INSERT INTO bds_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Teesaaqay see, tongimokira saa taatahhi talanta leẽ, ina yaa waaudi, gi fooli bonda hhapeege, haa gi tipi teꞌesii peesaykira gu looimoo gosi. ");
INSERT INTO bds_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Qariqaaqari daa ilii cati balalu wa⁄a, looimoo gu tongetee yaagi ki⁄i hhiyuuma dosaa. Ina gi maasi tongee dosi, idoo giyaa laqiri hari peesay gosi sigaa taataahhi. ");
INSERT INTO bds_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tongimokira gwaa oowu talanta kooani yaagi khay, haa gi kaay tuba, ‘Looimoo goy, ugu sinaa taatahhadi ana talanta kooani. Inkoo, yuꞌudiyaa haa slay faydaa talanta waka kooani.’ ");
INSERT INTO bds_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Looimoo gosi gi kaay tuba, ‘Naraꞌa, ugu ti tongimoo gu hhou haa daa ⁄imbi. Ugu haã laqanti ⁄imbaraa gimba gu digidakuge, ana hagu qaasa ma wariiqadimiti idadu wa⁄a. Inkoo, khoca hhaꞌaluudi sliimaa haa ana, looimoo googu.’ ");
INSERT INTO bds_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tongimokira saa taatahhi talanta cada, ina see yaagi khay, gi kaay tuba, ‘Looimoo goy, ugu sinaa taatahhadi talanta cada, ana haani slay faydaa talanta waka cada.’ ");
INSERT INTO bds_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Looimoo gosi gi kaay tuba, ‘Naraꞌa, ugu ti tongimoo gu hhou haa daa ⁄imbi. Ugu haã laqanti ⁄imba gimba gu digidakuge, ana hagu qaasa ma wariiqadimiti idadu wa⁄a. Inkoo, khoca hhaꞌaluudi sliimaa haa ana, looimoo googu.’ ");
INSERT INTO bds_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Da hheꞌesi, tongimokira saa taatahhi talanta leẽ yaagi khay, gi kaay tuba, ‘Looimoo goy, ana haa caahhi ugu ti heedi gwaa karahhu, goó buꞌuma daqa gwaabage ilii daamisu, haa goóyi kurunkurima daqa goobago ilii pasidisa pisagaroo. ");
INSERT INTO bds_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Teesaaqay ana haa tlaꞌamuudi, talanta doogu hagagi tipakay hhapeege. Inkoo, yuꞌudiyaa khooslay googu nahiĩ.’ ");
INSERT INTO bds_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Looimoo gosi gugi ilaki⁄isi ina tuba, ‘Ugu ti tongimoo gu tlaku haa naa⁄amiisay! Ugu ha khuꞌuda tuba, ana hoóti buꞌuma daqa hanaabage ilii daamisu pisagaroo, haa hoótii kurunkura baruũ daqa hanaabago ilii heeleꞌemisu! ");
INSERT INTO bds_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Teesaaqay, ugu kwanda gaa aloo qaaside peesay goy benkige. Qatlayki gaani ilii ki⁄e, hangii owu peesay goy sliimaa haa faydaa dosi.’ ");
INSERT INTO bds_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Looimoo gosi gi ilafahhi tuba, ‘Afii⁄utlakunayi talantatee da leẽ gi kone, hadisakana sa tongimokaꞌa gu kooma talanta mibi. ");
INSERT INTO bds_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Heedi gu kooma gimba gu Iliitleemu, ina sugumaa hiiroogisi hari khisla, haa maa kona wa⁄a. Kara hikaꞌa goóba caahha gimbakee, gimati koomi see caahhatee da coko⁄o, dagoóti afii⁄utli daqa dosaa. ");
INSERT INTO bds_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Inkoo, tongimokee gubasli faydaa, kwahhakunay khoorooge hhantee da didirige. Taysi daganimaa ilii wana ⁄aa⁄imu haa tluꞌuru gu ⁄atloo, sa slahhaaꞌamee da labaꞌasu.’ ” ");
INSERT INTO bds_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yeesu gi ilakoomi gimba tuba, “Kara, qatlay Nanku Heedi gimaa iliiki⁄iye hari wanqamee dosi, sliimaa haa malayika goõ, ina ginimaa ilii ibiidi rawaa gu kitiĩ gu tawaalooge gu wanqamee dosii. ");
INSERT INTO bds_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hida gu hhapapu goõ digimaay kurunkuri pandaa dosii. Teꞌesii ina gimaa amaslina, deꞌemiisay gooay idoo giyoó iliiamasline bee⁄u haa aaraa. ");
INSERT INTO bds_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ina maa qaasi bee⁄u hari bara da daba gosi gu ⁄uya, aaraa hari daba gosi gu basa. ");
INSERT INTO bds_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Da hheꞌesi, mutemi maa kaay sa hhakira gu bara dosi da ⁄uya tuba, ‘Khocaa unkuray daa ⁄aafi ha Taataa gooi! Aalima tawaaloo daa ilakhuukhuꞌusi ha ina, yadaa daa ilii tleehhi khooroo. ");
INSERT INTO bds_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maꞌaana, haa kooma qori, sinigi qaydiri ⁄agoo, haa kooma wakhaa, sinigi qaydiri maꞌay gu kitahhu, ana yaa dahaa, hanigi kwahhasuusidiri. ");
INSERT INTO bds_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kara, haa koomaaba qayroo, unkuray sinigi hadisidiri qayroo, haa mama⁄a, hanaagii yuꞌumidukaydiri, haa khiidimooge waara, hanaagi ilakhookhocuu kaydiri.’ ");
INSERT INTO bds_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Da hheꞌesi, hida hhakee gu koomee ibinaa daa tafaꞌadi, gumaa ilaki⁄isiyay ina tuba, ‘Looimoo gu Goõ, gwaa malaalee arini ugu konta qori, sugugi hadisani ⁄agoo, haa konta wakhaa, sugugi hadisani maꞌay gu kitahhu? ");
INSERT INTO bds_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gwaa malaalee arini ugu ti dahaa, hagugi kwahhasuusani, haraa slaꞌay wanta, sugugi hadisani qayru? ");
INSERT INTO bds_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kara, gwaa malaalee arini mama⁄ada, baku haa khiidimooge wanta, hagwaagii yuꞌumidu kayni?’ ");
INSERT INTO bds_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Teꞌesii, mutemi maa ilaki⁄isi inay tuba, ‘Gu lou, sangu kaay unkuray ambee, idoo gaa ilii yonditiri sa leẽ gu hhiee hhanki koi gu kaariiba, gimbakee ana sugunaa yonditiri.’ ");
INSERT INTO bds_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Da hheꞌesi, ina maa kaay sa hhakira guri bara da daba gosi gu basa tuba, ‘Waauda tiaa daqa dooaa unkuray daa ilawaasi! Taa⁄amida aslaa doóba hhamage, daa ilakhuukhuꞌusi ha Iliitleemu sa Biriisimoo haa malayika dosi. ");
INSERT INTO bds_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maꞌaana ana haa kooma qori, sinaa qaydiriiba ⁄agoo, haa kooma wakhaa, sinaa qaydiriiba maꞌay gu kitahhu. ");
INSERT INTO bds_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kara, ana yaa dahaa, hanaa kwahhasuusidiriiba, haraa slaꞌay waara, sinaa qaydiriiba qayru, haa mama⁄a gaa ilii khiidimooge waare, unkuray hanaay yuꞌudakaydiriiba.’ ");
INSERT INTO bds_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Teꞌesii, inay maa ilaki⁄isiyay ina tuba, ‘Looimoo gu Goõ, hagwaa malaalee arini haã qoriti, haa konta wakhaa, ugu yaa dahaa, haa kontaaba qayroo, haa mama⁄ada, haa khiidimooge wanta, dandiray hagugi mayni iliiawa?’ ");
INSERT INTO bds_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Da hheꞌesi, mutemi sigimaa ilaki⁄isi inay tuba, ‘Gu lou, sangu kaay, idoo gaa ilii maydiri iliiawaraa, leẽ gu hhiee hhanki koi gu kaariiba, haati siꞌidiri iliiawaraa ana.’ ");
INSERT INTO bds_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Da hheꞌesi, hida hhanki gu koomee ibinaa da tlakwi maay gunay ⁄agitiru gu koraraa haa koraraa goóba hiifaakoo. Hhakira gu koomee ibinaa daa tafaꞌadi, maay gunay slafimaa gu koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Qatlay Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee goõ, gi kaay sa sirakoomiisee dosi tuba, ");
INSERT INTO bds_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Unkuray ha khuꞌuday tuba, balalu cada giyoo hiicatiyee yoo losona gu Pasaaka. Nanku Heedi dugu tlanki haa dugwii tluhhumisi musalaabage.” ");
INSERT INTO bds_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Qatlaykee hhapalooee da deni haa gaduũ gu Yahuudi, yaay kurunkuridiri mara gu hhapalooay gu didiruge, uma gosi na Kayaafa. ");
INSERT INTO bds_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Inay gi ilakhuukhuꞌusiri, idoo gi ilii ooyiyee Yeesu hari hhaaboo, magu gaasiri. ");
INSERT INTO bds_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gi kaayri tuba, “Hhanti yondiidana gimbaki qatlay gu losonage, hida yoo ba⁄atii ⁄isinay khoslongora.” ");
INSERT INTO bds_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeesu yaa tongoo da Betaniyaage wana, mara gu Simoonige, gwaa kooma wakaꞌalee ga⁄ay gu buubaa. ");
INSERT INTO bds_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Teꞌesii hadee waka yaagi khaydi daqa dosii, yaa konta khoosliya da hhoi da alabaasita, daa kooma du⁄iya da tafu gu hhou haa da beyii dihhi. Hadetee gii tuutuqudi du⁄iyatee saga gu Yeesuge, Yeesu giyaa ilii ibiidi meesaage sa ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sirakoomiisee dosi giyaa ilii aniri gimbakee, gi slahhaahhaairi, kakaanay tuba, “Yuꞌudaa hadeti idoo giĩ ilii hhamisidi diitiray du⁄iyati. ");
INSERT INTO bds_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Du⁄iyati danganti aloo hiidahhasi naadiru hari peesay wa⁄a, peesaykee dugugi hadimisi sa iliiawaraa kwaeeli.” ");
INSERT INTO bds_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Teꞌesii, Yeesu yaa caahhi ilahudaa koina, sigigi kaay inay tuba, “Maw ilahufidu hadeti! Ina hinti yonditi yondu gu hhou sa ana. ");
INSERT INTO bds_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yuꞌudaa, balalu sliimaa kwaeeli yoó sliimaa wanay haa unkuray. Teesaaqay see, ana waaraaba sliimaa haa unkuray balalu sliimaa. ");
INSERT INTO bds_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hadeti hintii tuutuqudi du⁄iyati daa tafu cuuꞌudi slaqwa dooii, mani ilakhuukhuꞌusidi sa qaasaraa doyi. ");
INSERT INTO bds_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gu lou, sangu kaay unkuray ambee, qatlay Gimba gu Hhou gu Iliitleemu dugumaa ilii kakaane sa hida daqeemoo sliimaa tiꞌii khoorotii, slime yonduki giĩ yonditi hadeti, dugumaa kakaana sa hiislaslaw gosi.” ");
INSERT INTO bds_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Da hheꞌesi, leẽ gu sirakoomiisee mibi haa cada da Yeesu, daa eteediidine Yuuda Isikariyooti, gi hadakay daqa hhapalooee da denige, ");
INSERT INTO bds_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","haa sigigi kaay tuba, “Bere ana hiilu⁄a Yeesu dabaiĩ kokunay, unkuray sini mala hadisiday?” Teesaaqay inay sugugi faadiri goboree mibeeri tami da feesa, sugugi hadisiri. ");
INSERT INTO bds_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tlaatleesa da qatlaykeesaa, Yuuda gi tlaatleesi dabiidi mucu gu hhou gu hiinawaraa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Inkoo, baloo da tlaatleesoo da losona gu mukaatee doóba iliiqaasa hamiira yaa daadi. Sirakoomiisee gi ilii hadakayri Yeesu, gugi maasiri tuba, “Kaale slaꞌada ma sugu ilakhuukhuꞌusa kayni daqa da ilii ⁄agoo Pasaaka?” ");
INSERT INTO bds_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeesu sigigi kaay inay tuba, “Taa⁄amida yaamuge daqa heedi wakuu haa sugu kaadee ubee, ‘Maarimuu yaani kaay tuba, qatlay goy yaani day, mara googuu ⁄agima Pasaaka sliimaa haa sirakoomiisee doyi.’ ” ");
INSERT INTO bds_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Da hheꞌesi, sirakoomiisee gi laqiri, idoo Yeesu sigaani ilii kaay gooay, inay gi ilakhuukhuꞌusiri losona gu Pasaaka. ");
INSERT INTO bds_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Qatlay daa ilii day khwayaiĩ, Yeesu yaa ibiidi sa ⁄agoo sliimaa ha sirakoomiisee dosi mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Inay giyaa ilii ⁄agiiginee, Yeesu sigigi kaay tuba, “Gu lou, sangu kaay unkuray ambee, leẽ tla⁄aã googunay hiniĩ fookidi ana.” ");
INSERT INTO bds_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sirakoomiisee dosi gi li⁄iri hari khisla sa gimbakee, inay gugi tlaatleesiri maamisu tuba, “Looimoo gu Goõ, ti ana goo nugu hiifookida?” ");
INSERT INTO bds_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeesu gigi ilaki⁄isi inay tuba, “Hiĩ gungii tika⁄u mukaatimoo gosi lagabayge sliimaa haa ana, hikee noo ana hiifookidi. ");
INSERT INTO bds_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gu lou, Nanku Heedi gwaai, idoo daa ilii handikimi gooay Handikaa da Iliitleemuge. Inkoo, yoo ana heedikaꞌa gu hiifookida Nanku Heedi! Yaati ba⁄ay daqa heedikeesii, bere dugwaati aloo may laqwaloo.” ");
INSERT INTO bds_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Da hheꞌesi, Yuuda, hikira gu hiifookida Yeesu, gi maasi tuba, “Maarimuu, ti anagoo?” Yeesu gugi ilaki⁄isi ina tuba, “Ugu loi niĩ kaadi teesaaqay.” ");
INSERT INTO bds_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Qatlay giyaa ilii ⁄agiiginee, Yeesu yaa hiioy mukaatimoo, gi kaay ⁄iisoo daqa Iliitleemuge, gugi fendehhemisi, haa gi tosaa hadisi sa sirakoomiisee dosi. Ina gi kaay tuba, “Owaa ⁄agima, haã na slaqwa doyi.” ");
INSERT INTO bds_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Da hheꞌesi, gii oyi qulu⁄uu gu difaay, gi kaay ⁄iisoo daqa Iliitleemuge, gi tosaa hadisi sa inay tuba, “Kitahhama gonkokunaa hari qulu⁄uki. ");
INSERT INTO bds_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Haã na ceedee doyi da laqama ila⁄imbidu gu ⁄abu, da tuutuquda sa hida wa⁄a, digima ilamooyimi tlakwaroo dooina. ");
INSERT INTO bds_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ana sangu kaay unkuray ambee, qatlaykaa gu inkoogo ha kitahhaaba kara difaay, balotaꞌa naqatloo gamaa iliikitahhe da ⁄abi, sliimaa haa unkuray Tawaaloo da Taataa gooii.” ");
INSERT INTO bds_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Giyaa ilii hheꞌesiri raaꞌamu, raaꞌamee da daareesa Iliitleemu, Yeesu haa sirakoomiisee dosi gi waaudiri oõ gu Miseyituunige. ");
INSERT INTO bds_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Qatlay giyaa ilii dayri onke, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Hari amasi hhanki gu letuti, unkuray gonkokunaa hanoo lakitay ana. Gimbaki dugwaa handikimi Handikaa da Iliitleemuge tuba, ‘Ana hamaa sagadahha deꞌemiisay, teꞌesii bee⁄u goõ gu raqa maati pasidi.’ ");
INSERT INTO bds_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Teesaaqay see, qariqaaqari ana goo iliislafe haagii ca⁄a ayisago, hoo giyaada yade hhapee da Galilaayage.” ");
INSERT INTO bds_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peetiro gi ilaki⁄isi Yeesu tuba, “Bere wakinay goõ goo lakidiyay, etaa ana hagu lakidaaba ugu.” ");
INSERT INTO bds_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu gi kaay sa Peetiro tuba, “Gu lou, sugu kaay ugu, hari amasi hhanki gu letuti, konkaku giyoo ilii kahhiye ceearaa, ugu hanoo tlankida waa tami.” ");
INSERT INTO bds_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peetiro gi kaay tuba, “Bere gwaaꞌaraa goosee, ana kwanda ga gwaae sliimaa haa ugu, etaa ana hagu tlankaaba ugu coko⁄o seei.” Sirakoomiisee goõ gi kaayri namati teesaaqay. ");
INSERT INTO bds_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Da hheꞌesi, Yeesu gi hadakay sliimaa haa sirakoomiisee dosi daqa doó eteedine Getesemaani. Teꞌesii, Yeesu gi kaay sa inay tuba, “Ibiida tiꞌii, ana ha hadakaw yaqay ma firoo kay Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ina gii oyi Peetiro sliimaa haa yaꞌay hhakira cada gu Sebedaayo haa girigi waaudi. Yade ina gi tlaatleesi li⁄eemoo haa bahhangara. ");
INSERT INTO bds_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Ana ha kooma li⁄eemoo da didiri muuna gooii, daadaauusa da gwaaꞌaraa see. Inkoo ibiida tiꞌii, guula sliimaa haa ana.” ");
INSERT INTO bds_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ina gi waaudi pandaage coko⁄o, hingirigi kwahhi gii gupu⁄usi pandaa dosi hhapeege, gi firimi, “Ye Taataa goy, bere diidahhasi, sini surukuside qulu⁄uki gu labaꞌasu daqa dooaa. Teesaaqay see, hhanti yondita idoo ga iliislae ana, yondiidi idoo ga iliislaꞌade ugu.” ");
INSERT INTO bds_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yeesu gi ki⁄i daqa sirakoomiisetiray, gigi slay inay hiĩ guiri. Ina gi maasi Peetiro tuba, “Unkuray hangii dahhasidiriibaslii guulimee, gimati saa leẽ see? ");
INSERT INTO bds_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hhanti guꞌuday, firima Iliitleemu, ha ba⁄atii gii huuꞌuday koimisuge. Gu lou, muunaiĩ kokuna slaiyay kaba⁄a koimisu, teesaaqay see, slaqoo kokuna ti nanqweree⁄iyay.” ");
INSERT INTO bds_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ina gi hadakay kara waa da cada sa firoo, kakaana tuba, “Ye Taataa goy, bere ⁄atlarimoki gu labaꞌasu hiidahhasi hiicata haniba geregeda, gimbaki buꞌudiye idoo ga iliislaꞌade gooay ugu.” ");
INSERT INTO bds_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ina gi ki⁄i kara, gigi slay inay hiĩ guiri, sa gimba ilaa koina yaa haciri guꞌudee. ");
INSERT INTO bds_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeesu gigi may inay teꞌesii, gi waaudi kara waa da tami firooge, gi firimi namati gimbakira gooay gu pandaa. ");
INSERT INTO bds_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Da hheꞌesi, ina gi ki⁄i kara daqa sirakoomiisee dosii, sigigi kaay tuba, “Unkuray hati kahhadaaii haã guꞌudiri, haa hangii fiifisidiri? Yuꞌudaa qatlay yaani day, Nanku Heedi dugu hiilu⁄i dabaiĩ gu hida gu tlakwige. ");
INSERT INTO bds_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tlawaw, paaree na waaudani! Yuꞌudaa, hikira guni hiifookida, yaa khoci!” ");
INSERT INTO bds_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Qatlay Yeesu giyaa ilii kahhiye gimbage, Yuuda, leẽ gu sirakoomiisee dosi mibi haa cada yaagi khay. Sliimaa haa ina yaa wanta raqa da didiri da hida, gwaa koomee pangaaee haa hhadimeerii. Hida hhakee digaati ya⁄abi ha hhapalooee da deni haa gaduũ gu Yahuudi. ");
INSERT INTO bds_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Qatlaykee, Yuuda gu hiifookida Yeesu, yaa hheꞌesi yaa laqami sa hida hhakee kakaana tuba, “Hikee goo humbaꞌade na ina, oowakuna.” ");
INSERT INTO bds_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cirakiray, Yuuda yaati tafai daqa Yeesuge, haa gugi cehheemisi tuba, “Maarimuu, hagu hhouu!” Gugi tosaa humbaꞌadi. ");
INSERT INTO bds_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu gugi ilaki⁄isi ina tuba, “Danaꞌa goy, yondiidi idoo gaani yondu kaydi tiꞌii.” Teꞌesii, hida hhakee gii satiri, gi ooyiri Yeesu, haa gugi khiidiniri. ");
INSERT INTO bds_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yuꞌudiyaa, leẽ gu hhakira gwaa sliimaa waaree haa Yeesu, giyaa ilii arimi teesaaqay, yaagi slootisi pangaa gosi, haa gii maahhasi yondimiisay gu hhapalooay gu didiru, gugi afakereꞌesi eea dosi. ");
INSERT INTO bds_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeesu gi kaay sa ina tuba, “Ki⁄isii pangaa googu looboo dosii, sa gimba heedi goó cu⁄a hari pangaa, ina see dugooti gaasi hari pangaa. ");
INSERT INTO bds_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ugu ga ilatahhade, ana hiidahhasaabaslii firoo Taataa goy, ina sinaraagi khay ciraai raqoo gu deni mibi haa cada gu malayika? ");
INSERT INTO bds_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Inkoo, bere ha laqa teesaaqay, yoo malee buꞌuta Handikaa da Iliitleemu, doó kaawa tuba, gimbakee kwanda gii ca⁄iye teesaaqay?” ");
INSERT INTO bds_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Qatlaykee loi, Yeesu gi kaay sa raqatee da hida tuba, “Unkuray hanti khaydiri hari pangaaee haa hhadimeerii, sa oowaraa ana, ana ti kanimiisay gu sariyaa pahha? Balalu sliimaa ana haa waara mara gu didiruge gu Iliitleemu, haa caacaahhaahhamisa hida, unkuray hanaa oodiriiba. ");
INSERT INTO bds_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Inkoo, gimbaki goõ hingii laqadi taqay, dama buꞌudi gimba daa handikimi ha tletimiisee da Iliitleemu.” Da hheꞌesi, sirakoomiisee dosi goõ gugi mayri ina, gi tooinaa lakidiri. ");
INSERT INTO bds_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Da hheꞌesi, hida hhakee gwaa oowee Yeesu, gugi leehhisiri daqa Kayaafage, hhapalooay gu didiru. Teꞌesii, maarimamaa da sariyaa da diini haa gaduũ gu Yahuudi yaay kurunkuridiri sliimaa. ");
INSERT INTO bds_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peetiro yaa sirakoomi Yeesu alungo efeenaa da hhapalooay gu didiru naqatloo. Ina gii day waꞌay gu efeenaage, gi ibiidi sliimaa haa hida gwaa ga⁄aa⁄awee, ma arimi gimba gwii ca⁄a daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Inkoo, hhapalooee da deni haa gaduũ goõ gu balasaa da didiri, gi dabiidiri ilatlawa da afaꞌafuuma daqa Yeesuge, ma slayri amoo dari gaasaraa ina. ");
INSERT INTO bds_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Teesaaqay see, inay yaa slayriiba ma dakoo lensee, hingamatii ca⁄amisiri see masaydii wa⁄a gu afaꞌafuuma. Hiigaasooge hida cada hingaagii ca⁄asiri, ");
INSERT INTO bds_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","gi kaayri tuba, “Heediki yaa kaay tuba, ‘Ana hiidahhasa ilacataraa maraki gu didiru gu Iliitleemu, haa gugi tleehha kara hari balalu tami kilesi.’ ” ");
INSERT INTO bds_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Da hheꞌesi, hhapalooay gu didiru gi qadidi, gi maasi Yeesu tuba, “Ugu ha ilaki⁄isidaabaslii gimbakee? Hida hhanki mala ilakesaasidiyay daqa dooguu?” ");
INSERT INTO bds_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Teesaaqay see, Yeesu yaati qabi diĩ. Hhapalooay gu didiru gi kaay sa ina tuba, “Seelimi hari uma gu Iliitleemu gu slafa, sandi kaade bere ugu na Kristu, Nanku Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu gi ilaki⁄isi tuba, “Ugu niĩ kaadi teesaaqay. Inkoo, sangu kaay unkuray goõ ambee, qariqaaqari, Nanku Heedi hagu antayi, hiĩ ibiidi hari daba gu ⁄uya gu Iliitleemu gu kooma ⁄uuru goõ. Kara, hagumaa antayi ina yaa hii⁄eeti hari tlonga yadaa rawaa gu rawgo.” ");
INSERT INTO bds_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Teꞌesii, hhapalooay gu didiru gi feehhimisi kooti dosi, gi kaay tuba, “Hiĩ belendeqesi Iliitleemu! Ti masaydii mala kara ga slaꞌane? Yuꞌudaa unkuray loi haã akhasidiri ina, idoo giĩ ilii belendeqesi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Inkoo, unkuray gimbaki haguũ malee ilatahhadiri?” Inay gugi ilaki⁄isiri tuba, “Hikee haraay boo⁄i gwaaꞌaraa!” ");
INSERT INTO bds_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Da hheꞌesi, gugi ilii cubuquniri pandaage, gugi tlupidiri hari kondaaee. Wakinay gugi difiri koofii, ");
INSERT INTO bds_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tay tooinaa kakaanay tuba, “Ye Kristu, aare tletimi, ti miyaa nugungii maahhasi?” ");
INSERT INTO bds_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Qatlaykeesii, Peetiro yaa ibiidi khoorooge efeenaa da mara gu hhapalooay gu didiruge. Teꞌesii, yondimiisoꞌoo waka gugi ilii hadakaydi, haa sugugi kaadi tuba, “Ugu see haã sliimaa wanta haa Yeesu gu Galilaaya.” ");
INSERT INTO bds_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peetiro gi tlanki gimbakee pandaa da hida goõ gwaa waaree teꞌesii tuba, “Ana hhidima gimbakee gaa giimaamiside.” ");
INSERT INTO bds_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Da hheꞌesi, Peetiro yaay ca⁄i khoorooge, hari afamaraa gu efeenaa, yondimiisoꞌoo waka gugi anti, haa gi kaadi sa hida hhakira gwaa teꞌesii waaree tuba, “Heediki see hiĩ sliimaa wana haa Yeesu gu Nasareeti.” ");
INSERT INTO bds_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peetiro gi tlanki, kara hari seeliru kakaana tuba, “Heediki ana haguti hhidima!” ");
INSERT INTO bds_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Qariqaaqari coko⁄o, hida hhakee gwaa waaree teꞌesii, gi iliisatiri Peetiro, sugugi kaayri tuba, “Gu lou, ugu see ti leẽ tla⁄aã gooinay, sa gimba cocoꞌomoo googu see ti kooina pahha.” ");
INSERT INTO bds_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Teꞌesii, Peetiro hingigi tlaatleesi ilawaamisu haa gi seelimi kakaana tuba, “Heediki haguti hhidima!” Cirakiray, konkaku gi ceei. ");
INSERT INTO bds_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Teꞌesii, Peetiro giislay gimbakira sugwaani kaay ha Yeesu tuba, “Konkaku giyoo ilii kahhiye ceea, ugu hanoo tlankida ana waa tami.” Peetiro gii ca⁄i khoorooge, gi ⁄aa⁄i hari slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Qatlay daa iliipisi hari tumpaatumpu, hhapalooee da deni goõ haa gaduũ gu Yahuudi, hingigi ila⁄imbidiri sliimaa, ma gaasiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Inay gi khiidiniri Yeesu, gugi leehhisiri haa gugi taatahhiri sa Pilaatu, gwaa gafana gu Ruumi gu hhapee da Yudaaya. ");
INSERT INTO bds_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Inkoo, Yuuda gwaa hiifookidu Yeesu, giyaa ilii arimi tuba, Yeesu duguũ hukumi gwaaꞌaraa, dugugi iliihaci wagaree. Ina gi ki⁄isi goboretira da mibeeri tami da feesa, sa hhapalooee da deni haa gaduũ gu Yahuudi. ");
INSERT INTO bds_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ina sigigi kaay inay tuba, “Ana haã yondiidi tlakwaroo, sa gimba handii fookidi heedi guba dakoo.” Teꞌesii, inay gugi ilaki⁄isiri tuba, “Gimbakee hindi mala ilii slai dandiray? Hikee ti gimba googu ugu loi.” ");
INSERT INTO bds_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuuda gi kwahhi peesaykee mara gu didiruge gu Iliitleemu, gi waaudi, hingigi cabay. ");
INSERT INTO bds_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hhapalooee da deni gii oyiri peesaykee, gi kaayri tuba, “Ti naraꞌaaba sariyaa dooriige qaasa peesayki sliimaa haa hikee gu mara gu didiru gu Iliitleemu, sa gimba peesayki hiĩ bui ceedee da heedi.” ");
INSERT INTO bds_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Inay gi gimbuusiri, gi kereꞌesiri gimbakee, gi kirigiri hari peesaykee qaymoo daa eteediidine hatli gu yondimiisay gu khooslay gu tipa, ma daqa da iliiqamiduu gu dahaa tleehhiti. ");
INSERT INTO bds_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sa gimbakee, qaymotee saganaa eteedi, qaymoo da ceedee letuti naqatloo. ");
INSERT INTO bds_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ginaa ilii buꞌudi gimbakira daa tletimi ha tletimiisay Yeremiyaa tuba, “Inay yaay oyiri goboree mibeeri tami da feesa, qoomay gu kiriga, hida gu Israeeli hingaa ila⁄imbidiri bueemaa sa ina. ");
INSERT INTO bds_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hari peesaykee, gi kirigiri qaymoo da heedi waku goó tlehhida khooslay gu tipa. Taqay na idoo Iliitleemu giyaa ilii ilakaay ana ma yondiidi.” ");
INSERT INTO bds_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Inkoo, Yeesu dugugi leehhesi pandaa da Pilaatuge, ina gugi maasi tuba, “Ugu na inaa mutemi gu Wayahuudi?” Yeesu gugi ilaki⁄isi tuba, “Ugu niĩ teesaaqay kaadi!” ");
INSERT INTO bds_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hhapalooee da deni haa gaduũ gu Yahuudi gwaa ilii sitaakiniri, ina yaa ilaki⁄isiiba gimba lensee. ");
INSERT INTO bds_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Da hheꞌesi, Pilaatu gi kara maasi Yeesu tuba, “Ugu haã akhasidiibaslii sitaakatee wa⁄a, inay gi ilatlatlaatlayee daqa dooguu?” ");
INSERT INTO bds_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Teesaaqay see, Yeesu yaa ilaki⁄isiiba sitaakaa lensee. Teꞌesii, gafana hiraay tlai hari khisla, sa qabaratee da Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Inkoo, qatlay gu losona gu Pasaakage, gafana yaa kona ou gu afiiooyiru khiidimoogo heedi leẽ sa Yahuudi giyaa slaiyee. ");
INSERT INTO bds_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Qatlaykeesii, yaa wana heedi leẽ daa khiidimi, gwaa uma hiica⁄u khisla, uma gosi na Baraaba. ");
INSERT INTO bds_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Teesaaqay, hida giyaa ilii kurunkuridiri mara gu Pilaatuge, ina gigi maasi inay tuba, “Ha miyaa slaꞌaday, ana haguni afiiooyima khiidimoogo? Baraaba haguni afiiooyimaa baku Yeesu doó eteedine Kristu?” ");
INSERT INTO bds_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilaatu yaa teesaaqay kaay, sa gimba ina yaa caahhi tuba, hhapalooetee da deni guranti khayri Yeesu daqa dosii, sa tloomu gu giyaadimiisee da Yahuudi. ");
INSERT INTO bds_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Qatlay Pilaatu giyaa ilii ibiidi kitiĩ gu hukumuuge, hadee dosi sugwaagi ya⁄abidi ya⁄aboo tuba, “Ugu hhanti konta gimba lensee haa heedikee, heedikee gu kooma ibinaa daa tafaꞌadi. Letuti hari amasi diniĩ ilahufidi hari khisla tletaage sa ina.” ");
INSERT INTO bds_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Qatlaykeesii, hhapalooee da deni haa gaduũ gu Wayahuudi yaa hiifaafahhiri raqatee da hida tuba, firinee Pilaatu, Baraaba dugu afiiooyine khiidimoogo, Yeesu dugu gaasiye. ");
INSERT INTO bds_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Da hheꞌesi, Pilaatu gigi maasi kara inay tuba, “Haloo guni slaꞌaday sanguni geemaw, tla⁄aã gu hida hhankii gu cadage?” Inay gugi ilaki⁄isiri tuba, “Sandi geemayde Baraaba.” ");
INSERT INTO bds_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu gigi maasi inay kara tuba, “Inkoo, Yeesu doó eteedine Kristu, haguti malee laqa?” Inay goõ gi ilaki⁄isiri tuba, “Dugwii tluhhumisiye musalaabage!” ");
INSERT INTO bds_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilaatu gigi maasi kara inay tuba, “Sa soꞌoyi? Ti tlakwaroo mala ina giĩ yondiidi?” Inay goõ gi ilakoniri maahhoo hari ⁄uuru, kakaanay tuba, “Dugwii tluhhumisiye musalaabage!” ");
INSERT INTO bds_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilaatu yaa baraslayi tuba, wantaaba idoo gii dahhasiye laqaraa, ti maahhoo kilesi nii roogiigimita. Teesaaqay ina yaay oyi maꞌay haa gi hhunci dabaiĩ kosi pandaa dooinay, sigigi kaay tuba, “Ana koomaaba dakoo haa ceedee da heediki. Gimbaki daqa doogunay wane unkuray loi.” ");
INSERT INTO bds_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hida goõ gi ilaki⁄isiri tuba, “Ceedee dosi daqa doorii wante haa daqa yaꞌay kotii!” ");
INSERT INTO bds_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Teꞌesii, Pilaatu sigigii ca⁄asi Baraaba khiidimoogo, gi ilafahhi sirikaarii ma difiri Yeesu hari jeleedimaiĩ, gugi taatahhi dabaiĩ koinay, magu hiitluhhumisiri musalaabage. ");
INSERT INTO bds_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Da hheꞌesi, sirikaarii da gafana gi leehhisiri Yeesu, mara gu Pilaatuge, daa eteediidine na Praytooriyo. Teꞌesii sirikaarii deneꞌee koina goõ yaagii kurunkuridiri haa gi niini⁄idiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inay gugi afababaciniri qayroo kosi haa sugugi daasiri jurungii da daa⁄adi. ");
INSERT INTO bds_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Da hheꞌesi, gi boo⁄imisiri hhamaa gu leqeewaa, sugugi daasiri saga gosii. Kara, sugugii qaasiri hhadaa daba gosii gu ⁄uyage, haa gi keebeeimidiri pandaa dosii, gugi belendeqemisiri tay kakaanay tuba, “Mutemi gu Wayahuudi hagu hhouu!” ");
INSERT INTO bds_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sirikaaritee gi ilii cubuquniri Yeesu cubuqari, gii oyiri hhadatira gugi difiri sagage. ");
INSERT INTO bds_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Qatlay gwaa ilii hheꞌesiri belendeqemisu ina, gugi afabaciri jurungitira da daa⁄adi, sugugi daamisiri kara qayroo kosi. Da hheꞌesi gugi leehhisiri, magwii tluhhumisu kayri musalaabage. ");
INSERT INTO bds_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Qatlay sirikaarii giyaa ilii leehhiihhimisiyee Yeesu, hingigi slaslayri haa heedi waku uma gosi na Simooni, yaamulooay gu yaamu gu Kireene. Teꞌesii inay gugi ⁄uureesiri heedikee, ma geregedi musalaaba gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Inay gi dayri daqa doó eteedine na Goligoota, maꞌaana da umakee na, “Faraa da Saga.” ");
INSERT INTO bds_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Teꞌesii, sirikaarimoo leẽ gi hadisi sa Yeesu difaay daay roogi haa kwacankha, ma kitahhi. Teesaaqay see, ina giyaa ilii koisi, gigi siꞌi kitahhu. ");
INSERT INTO bds_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Qatlay sirikaarii giyaa ilii hheꞌesiri hiitluhhumisu Yeesu musalaabage, hingigi deehhiniri qayroo kosi, hari amoo darii slakharaa kuura. ");
INSERT INTO bds_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Da hheꞌesi, inay gi ibiidiri teꞌesii haa gugi ga⁄ayri ina. ");
INSERT INTO bds_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Rawaa gu saga gosii musalaabage, gii tluhhusiri bangasiya, daa ilii handikimi sitaakaa dosi tuba, “HIĨ NA YEESU, MUTEMI GU WAYAHUUDI.” ");
INSERT INTO bds_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Qatlaykee, slime fiisiisee cada digaay tluhhumisi sliimaa haa Yeesu, leẽ hari bara dosi da ⁄uya, waku hari bara dosi da basa. ");
INSERT INTO bds_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hida gwaay cacaacatee hari teꞌesa, gwaa wahaahaniri haa yaa naqudidimisiyay sagaiĩ koina, tay kakaanay tuba, ");
INSERT INTO bds_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ugu gu ilacata mara gu didiru gu Iliitleemu, haa gugi tleehheda kara hari balalu tami, inkoo, hangu ilabuꞌunte ugu lenkoogu! Bere gu lou, ugu na Nanku Iliitleemu ⁄eetaayuu inkoo musalaabago.” ");
INSERT INTO bds_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kara harima amotee leẽ, hhapalooee da deni, maarimamaa da sariyaa da diini haa gaduũ gu Yahuudi, gugi belendeqemisiri, kakaanay tuba, ");
INSERT INTO bds_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ina yaa ilabuꞌuuꞌumi hida wa⁄a, inkoo hingirinti slanqadii ilabuꞌuru ina loi? Tuba ina na mutemi gu Waisraeeli! Inkoo yaay ⁄eetiye musalaabago, dandiray see hagu ⁄imbana. ");
INSERT INTO bds_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ina yoó iliipaꞌana Iliitleemu, haa yaa kaay tuba, ‘Ina na Nanku Iliitleemu.’ Inkoo Iliitleemu gu ilabuꞌune, bere Iliitleemu dugoó muunaboo⁄eesi ha ina.” ");
INSERT INTO bds_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Slime, fiisiisetira see daay tluhhumisi sliimaa haa ina, gugi wahaahaniri harima amotee leẽ. ");
INSERT INTO bds_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Inkoo, letu giyaa ilii daadi tana⁄iyage, hhantee yaa ilaslaabidi hhapee goõ, saa gweleti naqatloo da khwayaiĩ. ");
INSERT INTO bds_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Daa ilii daadaauusi saa gweleti da khwayaiĩ, Yeesu gii ⁄aa⁄isi hari afoo da didiri, kakaana tuba, “Elooyi, Elooyi, lama sabakhitaani?” Maꞌaana dosi, “Iliitleemu goy, Iliitleemu goy, haniĩ soꞌoyi maydi?” ");
INSERT INTO bds_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hida wakinay gwaa qadimidee ciyoomoo haa ina, giyaa ilii akhasiri gimbaki, gi kaayri tuba, “Eteediidina Eliyaa, tletimiisaykira gu wakaꞌalee.” ");
INSERT INTO bds_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cirakiray heedi leẽ tla⁄aã gooinaa gi tu⁄udi, gii oyi dahhamu, gugi khiidimi cina da hhadaage, gigii tulu⁄i waꞌay gu difaay da mahhaaꞌadige, gigi taatahhi rawaage sa Yeesu, maay cunqi. ");
INSERT INTO bds_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hida wakinay gi kaayri tuba, “Inkoo may arine bere Eliyaa yaa khay, magu ilabuꞌumi ina.” ");
INSERT INTO bds_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Da hheꞌesi, Yeesu gii ⁄aa⁄isi kara hari afoo da didiri, gi dafidi dandaꞌaaliya, gi afiimayi. ");
INSERT INTO bds_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Qatlaykeesii loi loii, pasiyaa da mara gu didiru gu Iliitleemu, gii feehhiti bareemoo cada, rawaago biraa naqatloo. Hhapee gi rinqirinqiti, haa tle⁄eẽ gu deni gii feehhimidiri. ");
INSERT INTO bds_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ayisasu gi tlaaꞌamidiri, slaqoo gu hida wa⁄a gu Iliitleemu digaagi slafisi. ");
INSERT INTO bds_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hida hhakee yaagi slafiri ayisasugo, haa qariqaaqari Yeesu giyaa ilii slafi, inay gii guniri yaamu daa tlintiꞌisige gu Yerusaleemu. Yade inay gi iliicaca⁄iri hida wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sirikaarimoo gu didiru haa hhakee gwaa ga⁄aa⁄awee Yeesu sliimaa haa ina, giyaa ilii aniri kintla haa gimba goõ gungii ca⁄u, gi tlaꞌamuudiri hari khisla. Inay gi kaayri tuba, “Gu lou, heediki yaa Nanku Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Teꞌesii, yaa wanay tigay wa⁄a, gwaa sirakoomee Yeesu Galilaayago, haa gwaa iliiaꞌaaꞌawee ina. Inay yaati khuꞌuuꞌunay segengo gimbaki goõ gwaay ca⁄u. ");
INSERT INTO bds_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tla⁄aã gooinay yaa wanay Mariyaa Magidaleena Mariyaa iyoo dooina Yakoobo haa Yoseefu, haa hadee da Sebedaayo iyoo dooina Yakoobo haa Yohaana. ");
INSERT INTO bds_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Inkoo, daa ilii day khwayaiĩ, heedi leẽ hindaqaru yaagi khay, yaamulooay gu yaamu gu Arimataaya, uma gosi na Yoseefu. Slime ina see yaa sirakoomiisay gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ina gi hadakay daqa Pilaatuge, gi firimi suguma hadisi tuuꞌuna da Yeesu, magi qaasa kay. Pilaatu gi ilafahhi, Yoseefu suguma hadisi tuuꞌunatee. ");
INSERT INTO bds_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yoseefu gii oyi tuuꞌunatee da Yeesu, gigi khiidimi hari qayru gu ⁄abaaku gu hhou. ");
INSERT INTO bds_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ina gigi qaasa kay ayisa dosii da ⁄abige, giyaa fooli hhafidage. Da hheꞌesi, gii gwangwaraai tlaa⁄a da didiri loi, gi ilakhupisi afa gu ayisa, gi tosaa waaudi. ");
INSERT INTO bds_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Qatlaykee, Mariyaa Magidaleena haa Mariyaatira da cadii, yaa ibiidiri pandaa da ayisage. ");
INSERT INTO bds_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Inkoo, daa ilii cati baloo da Ilakhuukhuꞌumisu, heetlaalee dosii naa baloo da Sabaato. Hhapalooee da deni haa Farisaayoo, gi ilii hadakayri Pilaatu. ");
INSERT INTO bds_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Inay sugugi kaayri tuba, “Looimoo, dandiray hangii slayni gimba leẽ, hiicorimiisaykira yaa kaay, giyaa ilii kahhiye slafi tuba, ‘Baloo da tamiige haa slafa.’ ");
INSERT INTO bds_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Teesaaqay, ilafahhe ayisa dagama ga⁄ay baloo da tamii naqatloo. Teesaaqay laqe, sirakoomiisee dosi goo ba⁄atii fiisiyay tuuꞌuna dosi, haa gi kaayay sa hida tuba, yaani slafi. Bere gimbaki yooyi ca⁄i, afaꞌafuumati da hiifaakoo damaa tlakwi hari khisla, ba⁄ay hatira see da pandaa.” ");
INSERT INTO bds_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaatu sigigi kaay inay tuba, “Unkuray owaw sirikaarii. Taa⁄amida ayisage haa gagi ga⁄ayday hari ⁄uuru googuna goõ.” ");
INSERT INTO bds_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Teesaaqay, inay gi waaudiri, gi ga⁄ayri ayisatee naraꞌa haa gigi iliiqaasiri muhuuri tlaa⁄atee da didiri, haa gi qaasiri sirikaarii da ga⁄aw. ");
INSERT INTO bds_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Inkoo, baloo da Sabaato giyaa ilii catidi, daa iliipisi baloo da pandaa da kuiya, Mariyaa Magidaleena haa Mariyaa da cadii yaa waaudiri, gii yuꞌudakayri ayisa da Yeesu. ");
INSERT INTO bds_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yuꞌudaa, daagii ca⁄i kintla gu didiru, sa gimba malayika gu Taataa Iliitleemu yaay ⁄eeti yadaa rawaa gu rawgo, gi gwangwaraai tlaa⁄atira ayisago haa gigi ilii ibiidi. ");
INSERT INTO bds_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malayikakee, kalay gosi yaa hiimankaꞌasa da mankaraaiya pahha, kara qayroo kosi gwaa ⁄abaakwi poy. ");
INSERT INTO bds_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Teꞌesii sirikaarii daa ga⁄aa⁄awa ayisatira, gi dakhadakhiri sa tlaꞌamee da didiri, hinti kaka⁄iri pahha. ");
INSERT INTO bds_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Teꞌesii, malayikakee gi kaay sa tigay hhakee tuba, “Hhanti tlaꞌamutay! Ana haã caahhi tuba, unkuray Yeesu haguni damaamitay, dingii tluhhumisi musalaabage. ");
INSERT INTO bds_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ina wanaaba tiꞌii! Hiĩ slafi, idoo giyaa ilii kaay gooay. Khocaa arima daqa duguũ ilii qaasi. ");
INSERT INTO bds_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Inkoo, taa⁄amida ciraai, kaawa sa sirakoomiisee dosi ubee, ‘Yeesu yaani slafi ayisago. Yuꞌudaa, ina sangu giyaadi Galilaayage, yade hagu arintayi ina. Inkoo, ana sanguũ kaay unkuray.’ ” ");
INSERT INTO bds_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Teesaaqay, tigay hhakee gi waaudiri ciraai ayisago, konay amaaoo haa hhaꞌaloo da didiri. Inay gi taa⁄amidiri, gi kaawa kayri sa sirakoomiisee dosi gimbakee. ");
INSERT INTO bds_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cirakiray, Yeesu hingigi slaslayri haa tigay hhakee haa gigi cehheemisi. Tigay hhakee gugi iliisatiri, gi ooyiri yeꞌeeroo kosi, gugi hhaꞌaleesiri. ");
INSERT INTO bds_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Hhanti tlaꞌamutay! Taa⁄amida kaawa sa hhiee koi hadakayee Galilaayage, yade gini iliiarinay ana.” ");
INSERT INTO bds_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Qatlay tigay hhakira giyaa ilii waauuꞌumidiyee, sirikaarii waka tla⁄aã gu hhakiraa gwaa ga⁄aa⁄awee ayisa, gi waaudiri yaamuge. Inay gi ilakeesiri sa hhapalooee da deni, gimba goõ gungii ca⁄u. ");
INSERT INTO bds_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hhapalooee da deni hingigi slaslayri haa gaduũ gu Yahuudi, haa hingigi ilagimbuusiri gimba gu afaꞌafuuma. Inay gi hadisiri peesay wa⁄a sa sirikaaritee, ");
INSERT INTO bds_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sigigi kaayri tuba, “Unkuray kwanda ga kaadee sa hida tuba, ‘Sirakoomiisee dosi yaani khayri hari qatlay gu amasi, haa gi fiisiri tuuꞌuna dosi, dandiray gaã iliiguani.’ ");
INSERT INTO bds_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bere gafana yoo akhasi gimbaki, dandiray sugoo ilatlayna naraꞌa, unkuray hhanti tlaꞌamutay.” ");
INSERT INTO bds_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Teesaaqay, sirikaaritee gi ooyiri peesaykee, haa gi laqiri, idoo sigiĩ ilii ilakaay gooay. Gimbaki hingii qoomi daqa Wayahuudige letuti naqatloo. ");
INSERT INTO bds_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Da hheꞌesi, sirakoomiisetira da mibi haa leẽ gi hadakayri Galilaayage, okiray Yeesu sigaa ilii kaay hadakawa. ");
INSERT INTO bds_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yade onke inay gi aniri Yeesu, gugi hhaꞌaleesiri. Teesaaqay see, wakinay tla⁄aã gooinay yaa konay qiigiꞌimoo. ");
INSERT INTO bds_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Teꞌesii, Yeesu yaagi khay daqa dooinay, sigigi kaay tuba, “Siniĩ hadisi ⁄uuru goõ gu tawaaloo, rawaa gu rawge haa khoorooge. ");
INSERT INTO bds_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Teesaaqay, taa⁄amida ⁄isima hida gu hhapapu goõ, ma sirakoomiisee doyi tleehhidiri, hagigii nunqudimisiday hari uma gu Taataa, haa gu Naw haa gu Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kara caacaahhamisakina iliikoomaraa gimba goõ hangwaa ilakaay unkuray. Gu lou, ana sliimaa waara haa unkuray balalu sliimaa, hiifaakoo da khooroo naqatloo.”");
INSERT INTO bds_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Haã na tlaatleesoo da Gimba gu Hhou gu Yeesu Kristu, Nanku Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Idoo daa ilii handikimi gooay kitaabuu gu tletimiisay gu Iliitleemu Isaaya tuba, “Yuꞌudiyaa, ha ya⁄aba ya⁄abimiisay goy, ina sugu giyaadi, ma boo⁄imisu kay amoo sa ugu. ");
INSERT INTO bds_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Afoo da heedi kakaakanta kongoqomeege tuba, ‘Boo⁄imisi amoo sa Looimoo gu Goõ, tafaꞌasi amoo dosi cuti!’ ” ");
INSERT INTO bds_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Asunkuilee ya⁄abimiisaykee yaagi khay, uma gosi naa Yohaana Hiinunqudimiisay. Ina yaati daamaamisi qayru daa boo⁄imisi hari quubu gu fala da gamiyaa. Kara, khiriĩ gosii coo⁄ay gu fala ginaa khiidiidina. ⁄agoo dosi yaa ingagimoo haa dinu gu kweera. Yohaana yaa kakaakana gimba gu hiinunqudimisu gu hiifookida tlakwaroogo daqa Iliitleemuge, Iliitleemu ma ilamooyimi tlakwaroo dooina. Teꞌesii gigii nunqudimisi sa laqaruu gu hiifookidaratee daqa Iliitleemuge. Hida wa⁄a yadaa hhapee da Yudaayago haa yaamu gu Yerusaleemugo gi hadakayri daqa dosii kongoqomeege, magu itatiisiri. Teꞌesii qatlay giyaa ilii akhasiri gimbakee kosi, gi kakaaniri tlakwaroo dooina, Yohaana gigii nunqudimisi duudu gu Yoridaanige. ");
INSERT INTO bds_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kara Yohaana yaati kakaakana tuba, “Wana heedi waku, yaa hiikaaiyaaba khaymuu aluũ koaa, ina na kona ⁄uuru hari khisla kooi see ba⁄i, ana hiicondoa see hiidahhasaaba sa gweedaraa da dincaaraa da ye⁄eetoo kosi. ");
INSERT INTO bds_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ana hangu hiinunqudiidimisa maꞌay kilesii. Ina hiinunqudimisi unkuray hari Muuna gu Iliitleemu haa hari aslaa.” ");
INSERT INTO bds_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Qatlaykeesii Yeesu see yaagi khay daqa Yohaanage, yadaa tongoo da Nasareetigo daa hhapee da Galilaayage waara, dugugii nunqudisi ha Yohaana duudu gu Yoridaanige. ");
INSERT INTO bds_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Inkoo, qatlay Yeesu giyaa ilii cacaaca⁄iye maꞌaygo, gi arimi, kaslenkwaa, raw hiĩ tlaaꞌadi, Muuna gu Iliitleemu yaa hii⁄eeti daqa dosii, ubee, tlabiya pahha naa hii⁄eta. ");
INSERT INTO bds_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kara afoo yaagii ca⁄adi rawaa gu rawgo tuba, “Ugu na Nankoy ga slae, ugu hanoó muunaboo⁄eesida hari khisla.” ");
INSERT INTO bds_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Qatlay Yeesu dugwaa ilii hheꞌesi hiinunqudisa, cirakiray lenge dugurigi waaudi ha Muuna gu Iliitleemu kongoqomeege. ");
INSERT INTO bds_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yeesu yaa ibiidi yade kongoqomeege balalu mibeeri cigahha, hiigaasooge dugugi koimisi ha Sataanimoo. Yade ina yaa tla⁄aã gu makay gu kweerage ibimaamidi, dugwaa iliiaꞌaaꞌay ha malayika da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Qariqaaqari, Yohaana dugwaa ilii ilapingimi jeerage ha Heroode, Yeesu gi ki⁄i hhapee da Galilaayage, gi tlaatleesi kakaaru Gimba gu Hhou gu Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kakaana tuba, “Qatlay hiĩ buꞌudi, Tawaaloo da Iliitleemu yaani daadaausidi. Inkoo, fookidaaruu tlakwaroo doogunaa daqa Iliitleemuge, ⁄imba Gimbaki gu Hhou.” ");
INSERT INTO bds_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Letu waka, qatlay Yeesu giyaa ilii khookhociicine hari kenga gu tlawa da didiri da Galilaaya, gi arimi Simooni haa nankooina Andareyaa, idoo giyaa ilii taareeꞌeeꞌenee tlawage makumbaa dooina dari ooyiru samaakii, sa gimba inay hiĩ naa yondu gooina. ");
INSERT INTO bds_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeesu gi kaay sa inay tuba, “Hawundaa hani sirakonteei ana. Ana hangu sirakoomiisee doyi tleehhidisa da caacaahhamisu hida, mani sirakoniri ana.” ");
INSERT INTO bds_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cirakiray lenge gi mayri makumbabuu koina teꞌesii, gi sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yeesu giyaa ilii khoci coko⁄o pandaage hari kenga gu tlawa, gi arimi Yakoobo haa Yohaana, yaꞌay gu Sebedaayo. Inay haa taataa gooina yaa waꞌay gu masuwaa dooinay wanay, yaa boo⁄ii⁄imisiyay makumbabuu koina guri ooyiru gu samaakii. ");
INSERT INTO bds_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cirakiray lenge Yeesu gi eteedi inay, gi tooinaa mayri taataa gooina Sebedaayo masuwateesii sliimaa haa hida giyaa kakaami sa iliiawaraa, gi tooinaa sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Da hheꞌesi teꞌesaa, Yeesu haa sirakoomiisee dosi gi waaudiri yade tongoo da Kaperinauumuge. Qatlay daa ilii day baloo da Sabaato, Yeesu gii dawa kay sinagoogi da tongoteesii, gi tlaatleesi caacaahhamisu gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hida goõ gwaa teꞌesii waaree yaati bakairi hari khisla sa caacaahhamisu gosi, sa gimba ina giyaati caacaahhamisiiba inay maarimamaa dooina pahha da sariyaa, ina giyaati caacaahhamisi heedi gu kooma pahha ⁄uuru gu tawaaloo. ");
INSERT INTO bds_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Qatlaykeesii lenge heedi waku yaa wana sinagoogiteesii daa ilii khaabaaꞌadi gieeri, gi maahhi, ");
INSERT INTO bds_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","tuba, “Ye Yeesu gu Nasareeti, ha mala slaꞌada haa dandiray? Hanti khaydii sa hhamisaraa dandiray? Ugu, haguti khuana! Ugu ti ina daa tlintiꞌisi gwaa daqa Iliitleemu dahha.” ");
INSERT INTO bds_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Teꞌesii Yeesu gi ilii⁄oo⁄i gieeri, gi kaay tuba, “Qabe diĩ! Inkootuutuu ca⁄ii daqa heedikaa!” ");
INSERT INTO bds_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Da hheꞌesi, gieeri hhakee hiraagi khayri kwinkwiisii hari ⁄uuru daqa heedikeesii, tay maahhaminay hari afoo da didiri, yaagii ca⁄iri daqa dosaa. ");
INSERT INTO bds_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Teꞌesii hida goõ sinagoogiteesii hiraa hiitlairi hari khisla loi, hingigi tlaatleesiri maamisu inay haa inay tuba, “Hiĩ ti gimba mala? Ti caacaahhamisu gu ⁄abuu? Heediki kona ⁄uuru gu ilii⁄oo⁄a gieeri gu tlakwi, inay gugi akhasiyayi ina.” ");
INSERT INTO bds_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Teesaaqay gimba gu Yeesu, gii qoomi ciraai hhapee sliimaa da Galilaayage. ");
INSERT INTO bds_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeesu haa sirakoomiisee dosi giyaa ilii ca⁄iri sinagoogigo, gi dayri mara guũ Simoonige haa Andareyaa, sliimaa haa Yakoobo haa Yohaana. ");
INSERT INTO bds_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Teꞌesii kumboꞌoo da Simooni yaa wanta, yaa qati buburuuge, yaa mama⁄ada hari khisla. Cirakiray lenge Yeesu sugugi kaay gimbakee gu kumboꞌoo da Simooni. ");
INSERT INTO bds_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Teꞌesaa gi hadakay daqa giyaa iliiwante, gi ooyi daba gosi, gigii tlaysi aslaaꞌamee, ma qaditi. Cirakiray lenge ga⁄aykee kosi gii caaquudi, gi yonditi sa inay. ");
INSERT INTO bds_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Qatlay letu giyaa ilii huhaahuꞌude, hida yaagi tlaatleesiri leehhimisu daqa Yeesuge ga⁄iidee dooina haa hida wa⁄a daa ilii khaabaaꞌamidi ha gieeri. ");
INSERT INTO bds_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gu lou, hida goõ gu tongotee yaa hiikurunkuridiri efeenaa da marakeesii daa iliiwane Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Teꞌesii Yeesu gi hhoeemisi hida wa⁄a gwaa koomee ga⁄ay paslaapasloo, kara gii ca⁄amisi gieeri wa⁄a. Teꞌesii yaa qayiiba mucu sa gieeri, ma cocoiri, sa gimba inay giyaa khuiyay ina na miyaa. ");
INSERT INTO bds_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Heetlaalee dosii, daati kahhi taaboo⁄u, Yeesu gi waaudi daqa daa hiicaaqutige daaba hida, ma firimi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Qariqaaqari Simooni haa deneꞌee kosi gi caahhiri tuba, Yeesu hhaku, gugi dabiiduu kayri. ");
INSERT INTO bds_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Qatlay gwaa ilii slayri ina, sugugi kaayri tuba, “Hida goõ guti dabimaamidiyay ugu!” ");
INSERT INTO bds_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Teꞌesii Yeesu gi ilaki⁄isi inay tuba, “Kwanda ga waaudane tiaa, ma tongagu wakinay khuꞌusani gu ilaciyaage waaree, yade see kakaaru kayna gimba gu Iliitleemu, sa gimba, ana saani gimbakee khay.” ");
INSERT INTO bds_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Da hheꞌesi, gi waaudi, gi ilakhookhocimi tongagu wa⁄a yade hhapee da Galilaayage. Yeesu gi kakaami gimba gu Iliitleemu teꞌesii sinagoogaguu koinay, kara gii ca⁄amisi gieeri daqa hida wa⁄ago. ");
INSERT INTO bds_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Inkoo, tongoo wakay daraa hiicati Yeesu, yaa wana heedi waku gwaa kooma ga⁄ay gu buubaa. Qatlay giyaa ilii arimi Yeesu, gi hadakay daqa dosii, gi keebeeidi pandaa dosii, gi firimi tuba, “Taataa, ana khua, bere ha slaꞌada, haniidahhasida ilabuusla.” ");
INSERT INTO bds_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeesu gi ⁄awaarimi hari khisla sa heedikee, gi tafaꞌasi daba gosi, gugi nangusi, sugugi kaay tuba, “Ee, ana slaꞌa teesaaqay laqa, ugu duguma ilabuusli inkootuutuu.” ");
INSERT INTO bds_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cirakiray lenge ga⁄aykee dugugi hhoeesi, ina gi hhoay haa gi ilabuꞌudi sumuku! ");
INSERT INTO bds_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Teꞌesii Yeesu gugi aareesi heedikee, gugi hiigadimi, ");
INSERT INTO bds_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","tuba, “Inkoo akhasi, hhanti kaada sa heedi lensee, idoo duguũ ilii hhoeesi. Inkootuutuu taa⁄a hangu laqante daqa hhapalooay gu Iliitleemuge, la hadisa kayda sadaaka sa ilabuuslatee toku, idoo daa ilii ilafahhi gooay sariyaa da Musaage. Hatee noo ilatlawa doogu sa inay tuba, duguũ ilabuusli.” ");
INSERT INTO bds_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Teꞌesaa, heedikee gi teesaaqay laqi, gi waaudi, gi amoo dosi ooyi. Ina yaa yakwiiba gimbakee, gi tlaatleesi kakaaru sa hida daqeemoo goõ gimba gungii ca⁄u daqa dosii. Inkoo sa daqatee Yeesu yaa kara hiidahhasiiba dawaraa tongoo ma lenge seei pandataa guti khuiyay. Daqeemoo gwaaba hida ginaa ilii ibimaamidi, kara taysi see hida yaagi ilaqinciri khakhaw daqa dosii daqeemoo gongo. ");
INSERT INTO bds_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Qariqaaqari, balalu angaamaka taqaaqay, Yeesu gi ki⁄i kara tongoo da Kaperinauumuge, hida gi akhasiri tuba, Yeesu yaani khay, ayage wana. ");
INSERT INTO bds_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Teꞌesii hida wa⁄a yaagii kurunkuridiri, gii guniri waꞌay gu marakeesii giyaa iliiwane, daqa lensee hhaka daati meti daaba hida, ma afamaraage see hari khooroo daqa yaa metiiba. Yeesu gi tlaatleesi kakaaru gimba gu Iliitleemu sa inay. ");
INSERT INTO bds_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Qatlay Yeesu giyaa ilii kakaakane teꞌesii, hida wakinay yaagi leehhisiri heedi waku gwaa tingara⁄uudu, duguma hhoeesi ha Yeesu. Heedikee ha hida cigahha nugwaa geregediri hari fala. ");
INSERT INTO bds_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Inkoo, hida hhakee digiraa slanqadi hari dawaraa heedikee marage daqa Yeesuge, sa gimba gu raqatira da hida daa qiqincidi teꞌesii. Da hheꞌesi, gii dadayri rawaa gu pembeege, gi cihhiri mucu daqatiray loii daa iliiwane Yeesu, gii ⁄eetisiri heedikee gwaa tingara⁄uudu, tay hiĩ qaati falage. ");
INSERT INTO bds_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Qatlay Yeesu giyaa ilii arimi ⁄imba da didiri da hida hhakee, gi kaay sa heedikee gwaa tingara⁄uudu tuba, “Nankoy, tlakwaroo doogu sliimaa dagaã ilamooyimi!” ");
INSERT INTO bds_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Inkoo, maarimamaa angaamaka da sariyaa da Iliitleemu yaa wanta, yaa ibiti teꞌesii. Qatlay giyaa ilii akhasiri Yeesu hiĩ kaay teesaaqay, gi tlaatleesiri ilahudaa muunaiĩ koinay tuba, ");
INSERT INTO bds_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Heediki siĩ soꞌoyi taqay kaay? Ina hinti belendeqesi Iliitleemu! Hhaku lensee gu kooma ⁄uuru gu ilamooyiru tlakwaroo, Iliitleemu kilesi na kona!” ");
INSERT INTO bds_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Cirakiray lenge Yeesu muuna gosii gi caahhi idoo giyaa ilahudeedemisiyeei muunaiĩ koinay, gi kaay sa inay tuba, “Sa soꞌoyi ilahudeedemisiday teesaaqay muunaiĩ kokunay? ");
INSERT INTO bds_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gimba haloo na slaahhi hari khisla, kaawaraa sa heediki gwaa tingara⁄uudu tuba, ‘Tlakwaroo doogu sliimaa dagaã ilamooyimi,’ baku kaawaraa tuba, ‘Tlayii, oyii fala doogu, la waauta?’ ");
INSERT INTO bds_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Inkoo, ana slaꞌa unkuray, ma caahhadiri tuba, Nanku Heedi kona ⁄uuru gu ilamooyiru tlakwaroo da hida tiꞌii khoorotii!” Teꞌesii gii fookidi daqa heedikiray gwaa tingara⁄uudu, gi kaay sa ina tuba, ");
INSERT INTO bds_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Suguũ kaay, tlayii, oyii fala doogu, la waauta ayage!” ");
INSERT INTO bds_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cirakiray lenge, heedikee gi qadidi ge⁄e, gii oyi fala dosi, yaagii ca⁄i khoorooge pandaa da hida sliimaage. Qatlay giyaa ilii aniri teesaaqay, hida sliimaa yaati bakairi hari khisla, gi hhaꞌaleesiri Iliitleemu tuba, “Yeraa, etaa hakahhana arimaa gimba da hinkaa gooay gwaanii ca⁄u!” ");
INSERT INTO bds_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Da hheꞌesi, Yeesu gi kara hadakay kenga gu tlawa da didirige da Galilaaya. Teꞌesii raqatee goõ da hida yaagi sirakonti ina, ina gigi tlaatleesi caacaahhamisu gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Qariqaaqari, Yeesu giyaa ilii cati hari oofisi daa ilii buaaidiye koodi, gi arimi Laawi nanku Alifaayo, hiĩ ibiidi teꞌesii. Yeesu gi kaay sa ina tuba, “Hawunda hanisirakonte, ma leẽ gu sirakoomiisee doyi tleehhiti!” Da hheꞌesi, Laawi gii tlay, gi mamay yondukee kosi gu koodi, gi sirakoomi Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Laawi gi kwahhasuusi Yeesu haa sirakoomiisee dosi aya gosii sa ⁄agoo. Inkoo, qatlay giyaa ilii ⁄agiigineei, karaanimaiĩ gwaa hiikurunkuriirimee koodi sliimaa haa hida gwaa koomee tlakwaroo yaa ⁄agiiginay sliimaa haa Yeesu haa sirakoomiisee dosi. Teꞌesii yaa wanay hida wa⁄a gwaa sirakoomee ina. ");
INSERT INTO bds_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Maarimamaa wakinay da sariyaa gu raqa da Farisaayoo, giyaa ilii aniri Yeesu ⁄agina haa hida gu koomee tlakwaroo, gi maasiri sirakoomiisee dosi tuba, “Yeesu sa soꞌoyi ⁄agiigina haa karaanimaiĩ haa hida hhakee gu koomee tlakwaroo?” ");
INSERT INTO bds_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeesu giyaa ilii akhasi gimbakee koina giyaa cocaacoiyeei, gi kaay sa inay tuba, “Hida gu koomee slaqoo gu hhoi yoó slaiyaaiiba dareesimoo, hhakaꞌa gu koomee ga⁄ay noó slaiyay. Inkoo, ana hanti khayiiba sa eteeda hida hhakaꞌa gungoó hiiarimee tuba, ibinaa dooina yaa tafaꞌadi, hanti khay sa eteediru gu hida hhakaꞌa gu koomee tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sirakoomiisee da Yohaana haa raqa da Farisaayoo yoó mamayay ⁄agoo haã kitahhuu. Sa gimbakee hida wakinay yaagi khayri daqa Yeesuge, gi maasiri tuba, “Sirakoomiisee da Yohaana haa sirakoomiisee da raqa da Farisaayoo yoó mamayay ⁄agoo haa kitahhu. Inkoo, sirakoomiisee doogu yoó soꞌoyi mayay teesaaqay laqaraa?” ");
INSERT INTO bds_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu gi ilaki⁄isi sa inay tuba, “Dahaa gu heedi guũ khabimu, malee mayay ⁄agoo haa kitahhuu qatlay heedi guũ khabimu, sliimaa wana haa inay? Bere heedi guũ khabimu wana haa inay, hiidahhasiyaaiiba mawaraa da ⁄agoo haa kitahhuu. ");
INSERT INTO bds_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Inkoo, balalu gimaa dayee, teꞌesii heedi gwaa khabimu dugurimaa ilii waaudiye daqa dooinaa, qatlaykeesii maa asu mayay ⁄agoo haa kitahhuu. ");
INSERT INTO bds_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hhaku heedi lensee goó hiidaqa qayru gwaa faaku hari dahhamu gu ⁄abu. Bere teesaaqay laqi, qayrukira gwaa faaku, kwanda gi feehhidiye, gi asu feehhimidi ba⁄ay da pandaa see. ");
INSERT INTO bds_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nama teesaaqay leẽ, hhaku heedi lensee goó hiieesa difaay da ⁄abi waꞌay gu curuquu gu fala da segige gu iliiqaasa difaay. Bere teesaaqay laqi, difaaytee da ⁄abi, kwanda gii feehhimiside faloo hhakee gonkoinaa. Teesaaqay difaaytee goõ haã faloo hhakee see slime yooti tlakwaakwayay. Difaay da ⁄abi kwanda dagoó waꞌay gu curuqeerii gu faloo gu ⁄abige hiieesi.” ");
INSERT INTO bds_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Letu waka baloo da Sabaato, Yeesu haa sirakoomiisee dosi yaa hiicatiri hari tla⁄aã gu qaymamuu gu ganoo. Qatlaykee sirakoomiisee dosi gi tlaatleesidi kereꞌemisu sagaiĩ gu ganoo, gi tooinaa ⁄aginiri. ");
INSERT INTO bds_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Da hheꞌesi Farisaayoo wakinay gwaa waaree teꞌesii gi kaayri sa Yeesu tuba, “Yuꞌudiyaa, sirakoomiisee doogu soꞌoyi yondimaamita yondu daa kitlakuusi sariyaage baloo da Sabaatoge?” ");
INSERT INTO bds_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Teꞌesii Yeesu gi ilaki⁄isi inay tuba, “Haati somintiriibaslii gimba gu Iliitleemuge, idoo Dawdi giyaa ilii laqi qatlay giyaa ilii qoriimidiri ina haa hida kosi? ");
INSERT INTO bds_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ha khuꞌudaaiibaslii, idoo okookoo goori Dawdi giyaa ilii day mara gu didiru gu Iliitleemuge, qatlay Abiyataari giyaa ilii hhapalooay gu didiru gu Iliitleemu, gi ⁄agimi mukaatee daa hadimaamisiye sa Iliitleemu, daa kitlakuusi ⁄agoo ha heedi lensee, hhapalooee kilesi naa ⁄agiiginay. Kara Dawdi gi qaqay mukaatetee sa hida kosi see!” ");
INSERT INTO bds_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Teꞌesii Yeesu gi kara kaay sa Farisaayoo tuba, “Baloo da Sabaato dagaati qaasi ha Iliitleemu sa iliiawaraa hida, ma hiifiifisiri yondu gooinaa, hida digaati qaasiiba sa balotee. ");
INSERT INTO bds_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Inkoo, Nanku Heedi na Looimoo gu baloo da Sabaato.” ");
INSERT INTO bds_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Letu waka Yeesu kara gii day sinagoogige, gi arimi heedi waku yaa wana teꞌesii, daba gosi gwaa tingara⁄uudu. ");
INSERT INTO bds_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Inkoo, letutee yaati baloo da Sabaato, Farisaayoo wakinay yaa wanay, yaati khuꞌuuꞌunay Yeesu naraꞌa, ma aniri, bere higi hhoeesi heedikee baloo da Sabaatoge, magi leehhisiri Yeesu pandaa da balasaage. ");
INSERT INTO bds_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Da hheꞌesi Yeesu gi caahhi idoo giyaa ilahudeedemisiyeei, gi kaay sa heedikee gwaa daba tingara⁄uudu tuba, “Khoca tiꞌii, qadidi pandaa da hida sliimaage, ma dugu arimi.” ");
INSERT INTO bds_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Teꞌesii Yeesu gi maasi Farisaayotee tuba, “Pandaa da sariyaage gimba haloo na naraꞌa laqaruu baloo da Sabaatoge, ti yondu hhoinay baku ti yondu tlakwaroo? Kara haloo na hhoinay baloteesii, ti ilabuꞌuruu heedi waku gwaaꞌaraago baku ti gaasaraa da heedikee?” Teꞌesii yaati qabiri diĩ. ");
INSERT INTO bds_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Da hheꞌesi, Yeesu gigi yuꞌudi gonkoinaa hari qupidaa, gi slahhaai hari khisla, sa gimba gu muunaiĩ hhakee koina gwaa karaarahhee. Teꞌesii gi kaay sa heedikee gwaa daba tingara⁄uudu tuba, “Tafaꞌasi daba googu!” Heedikee gi tafaꞌasi daba gosi, cirakiray lenge daba gosi dugugi hhoeesi sumuku. ");
INSERT INTO bds_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Teꞌesaa Farisaayoo gii ca⁄iri sinagoogiteesaa, higi cira idara kayri sliimaa haa hida gwaa iliiaꞌaaꞌawee mutemi Heroode, idoo gi ilii gaasiyee Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gi waaudiri teꞌesaa kenga gu tlawage, teꞌesii digaagi sirakoomi ha raqa da didiri da hida yadaa hhapee da Galilaayago. Inkoo hida wa⁄a hari khisla yaati akhasiri gimbakira gu didiru daa yondimaamidiye ha ina, yaagi asu khayri daqa Yeesuge daqeemoo sliimaago. Wakinay yaa hhapee da Yudaaya dahhiyay haa yaamu gu Yerusaleemugo, wakinay yadaa hhapee da Idumeeyago haa hhapee daraa tlo⁄osaa guri bara da rawaa gu duudu gu Yoridaani waara. Kara wakinay yaamu gu Tiirogo haa Sidoonigo, raqatee da hida hhakee daa didiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeesu gi kaay sa sirakoomiisee dosi, ma hiisatisiri masuwaa waka ciyoomooge sa ina, ina ma tlaatlahhasi raqatee da hida gu hhanti iliiraagita. ");
INSERT INTO bds_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ina yaa teesaaqay kaay, sa gimba yaa hhoeemisi hida wa⁄a letutee, teesaaqay hida goõ gwaa koomee ga⁄ay yaa konay kwayru gu cihharaa raqatee, ma dayri daqa dosii, magu nangumisiri, inay see ma hhoaaꞌayri. ");
INSERT INTO bds_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Qatlaykee sliimaa hida hhakira daa ilii khaabaaꞌamidi ha gieeri, giyaa ilii aniri Yeesu, yaati huhuiri hhapeege pandaa dosii, gi tlaatleesiri maahhoo hari ⁄uuru tuba, “Gu lou, ugu ti Nanku Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Teꞌesii Yeesu gigi ilii⁄oo⁄i gieeri hhakee goõ, ma mayri kaawa sa hida, ina na miyaa. ");
INSERT INTO bds_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Da hheꞌesi, Yeesu gi ilakhiinaaꞌadi rawaa gu onke, gi eteedi hida hhakira giyaa ina slaiye, ma sirakoomiisee dosi tleehhidiri, yaagi khayri daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Teꞌesii Yeesu gii leehhi hida hhakee gu mibi haa cada, slime giyaa eteedi na ya⁄abimiisee, mangu sirakomamidiri haa ina, haa magi ya⁄abi ma kakaaru kayri gimba gu Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kara ma sigi qay ⁄uuru gu hiica⁄amisu gu gieeri daqa hidago. ");
INSERT INTO bds_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Umaiĩ gu hida hhakee gu mibi haa cada giyaa hiileehhi na nahhaã, Simooni (hiĩ daraa ayi ha Yeesu uma gu caduu na Peetiro), ");
INSERT INTO bds_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakoobo haa Yohaana, yaꞌay gu Sebedaayo (hhaã daraa ayi ha Yeesu uma gu deneꞌee na Boaneeri, maꞌaana dosi na “Yaꞌay gu Kukukhumoo,”) ");
INSERT INTO bds_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andareyaa, Filiipo, Batolimaayo, Mataayo, Toomaasi, Yakoobo nanku Alifaayo, Tadaayo, Simooni gu raqa da Seloote, ");
INSERT INTO bds_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","haa Yuuda Isikariyooti. Qariqaaqari hiĩ naa hiifookidi Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Da hheꞌesi Yeesu haa sirakoomiisee dosi gi ki⁄iri ayage. Kara raqa da hida yaagii kurunkuriti daqa dosii, yaa slayriiba ma mucu gu ⁄agoo see. ");
INSERT INTO bds_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Qatlay hiidayuuma dosi giyaa ilii akhasidi gimbakee, yaagi tooinaa waaudiri tongoo dooinaa, maguri waaudiri ayage, sa gimba yaati ilahudeesiri tuba, “Hiĩ bi⁄iidi sa yondu gu didiru!” ");
INSERT INTO bds_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Teꞌesii maarimamaa waka da sariyaa, hhaã gwaa yaamu gu Yerusaleemu dahhee, yaati kakaakaanay sa hida tuba, “Yeesu dugwaati ilii khaabaaꞌadi ha Belisebuuli.” Kara yaati kakaakanay tuba, “Ina haroó ⁄uuru gu Sataanimoo, hiĩ gu didiru sa gieeri goõ, hiica⁄amisi gieeri daqa hidago.” ");
INSERT INTO bds_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Da hheꞌesi, Yeesu gi eteedi inay daqa dosii, gi kaay sa inay hari amoo da ilaꞌaaꞌaatisa tuba, “Sataanimoo malee hii dahhasi hiica⁄asa gieeri kosi daqa hidago? ");
INSERT INTO bds_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bere hida gu hhapee leẽ qwaqwatlinay inay haa inay, ⁄uuru gu hida gu hhapetee hindii faaki. ");
INSERT INTO bds_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kara bere hida gu mara leẽ hingii deehhiihhiniri raqoo haa raqoo, gi asu qwaatliyay inay haa inay, ⁄uuru gu hida gu marakee see hiikaasiyaaba. ");
INSERT INTO bds_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nama amotee leẽ, bere tawaaloo gu Sataanimoo qwaqwatlina ina lenkosi haa hingigi deehhiihhina, ina hiidahhasiyaaba qadida, haa hiifaakoo da ⁄uuru gosi yaani daadi. ");
INSERT INTO bds_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Inkoo teesaaqay gooba! Gu lou, bere heedi waku slai cihharaa mara gu heedi gu kooma ⁄uuru, magu afafiisi khooslay gosi goõ, kwanda hiti gesaa khiidina heedikee gu kooma ⁄uuru. Teꞌesii gi asu hiidahhasi afafiisa idadu sliimaa gi kone. ");
INSERT INTO bds_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Guti lou, hida digi ilamooyina ha Iliitleemu tlakwaroo dooina goõ, haã gimba gooina see gonkosaa gu pende⁄esa da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Inkoo, hiĩ gumaa belendeqesa Muuna gu Iliitleemu, tlakwarotee tosi dagamaa ilamooyinaaba coko⁄o seei ha Iliitleemu koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeesu yaa teesaaqay kaay, sa gimba maarimamatee yaa kakaakanay tuba, “Ina dugwaa iliikhaabaꞌadi ha Belisebuuli, ayi gu gieeri goõ!” ");
INSERT INTO bds_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Asunkuilee, iyoo dosi Yeesu haa hhiee kosi yaagi khayri. Gonkoinaa gi qadimidiri khoorooge, gi ya⁄abiri heedi waku waꞌay gu marage, magu eteeda kay Yeesu, maa hiica⁄i khoorooge. ");
INSERT INTO bds_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Inkoo, teꞌesii waꞌay gu marage raqa da didiri da hida yaa wanta daa ibiti, daa niini⁄iti Yeesu, hida hhakee gi kaayri sa ina tuba, “Yuꞌudiyaa, iyoo doogu haa hhiee koku see khoorooge wanay, dugu dabimaamidi.” ");
INSERT INTO bds_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Teꞌesii ina gi ilaki⁄isi sa inay tuba, “Iyoo dooi haa hhiee koi niĩ miyaa?” ");
INSERT INTO bds_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Da hheꞌesi, Yeesu gi yuꞌudi daqa hida hhakeesii gwaa ibiidee teꞌesii gugi niini⁄idiri, gi kaay tuba, “Hhaã guũ ibiidee tiꞌii na amu koi haa hhiee koi, ");
INSERT INTO bds_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","sa gimba heedi goó yondiida idoo da slaiye Iliitleemu, hikee na hhia gooi, hhioo dooi haa iyoo dooi.” ");
INSERT INTO bds_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Qariqaaqari, Yeesu gi kara tlaatleesi caacaahhamisu hida yade kenga gu tlawa da didirige da Galilaaya. Inkoo, raqa da didiri loi da hida yaagii kurunkuriti daqa dosii, gi ilii raagiti ina bareemoo sliimaa. Sa gimbakee Yeesu gii dawa kay masuwaa wakayge, gi ibiidi teꞌesii, miyaa cocoi sa inay teꞌesaa tlawago. Raqatee da hida gi meti kenga gu tlawage. ");
INSERT INTO bds_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yeesu gi caacaahhamisi inay gimba wa⁄a hari amoo dari ilaꞌaaꞌaatimisu. Caacaahhamisukeesii kosii, gi kaay sa inay tuba, ");
INSERT INTO bds_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Itatiisa sangu kaay! Heedi waku yaa waaudi qaymoo dosii sa wincalaakharu kawa pisagaroo dosi da ganoo. ");
INSERT INTO bds_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Qatlay giyaa ilii wincalaakhaakhane, pisagaroo waka gi huhuꞌudi amooge, cira⁄oo yaagi khaydi, pisagarotee dagagi noꞌomi goõ. ");
INSERT INTO bds_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pisagaroo waka gi huhuꞌudi gurumaasiyage, daqa daa iliiwane tipa coko⁄o kilesi, yaagi cira tiꞌiti teꞌesii, sa gimba daqatee yaa kontaaba tipa wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Inkoo, tleemaa da dihhi giyaa iliida⁄adi, barukee gwaa tiꞌidu gi moomooi, gi sluhhi, sa gimba kibeeri yaa konaaiiba daqa da iliimuta naraꞌa. ");
INSERT INTO bds_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pisagaroo waka gi huhuꞌudi slanslawriige. Qatlay giyaa ilii tiꞌiti, slanslawrikee gi cira dinaraaray, gi ilaslaabi barukee, da hheꞌesi gi kay, laqwaloo see guba. ");
INSERT INTO bds_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kara pisagaroo waka gi huhuꞌudi hhapee da hhoige dii looi, gi tiꞌiti, gi dinaraaraydi naraꞌa, gi laqwalidi baruũ wa⁄a gwaa hamaadu, goo⁄u waku gi laqwali ilaa mibeeri tami, waku mibeeri lahhoꞌo, kara waku mibeeri mibi.” ");
INSERT INTO bds_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Da hheꞌesi Yeesu gii faakisi gimbakee kosi, gi kaay sa inay tuba, “Ina gu kooma eaa, akhasiye naraꞌa gimbaki.” ");
INSERT INTO bds_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Qatlay Yeesu giyaa ilii sliimaa wane haa sirakoomiisee dosi da mibi haa cada, kara hida wakinay see yaa wanay, gwaa sirakoomee ina, inay gi maasiri ina sa gimbakee kosi gu ilaꞌaaꞌaatimisu, ma sigi kaay maꞌaana dosi. ");
INSERT INTO bds_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yeesu gi kaay sa inay tuba, “Wakaꞌalee siiri da Tawaaloo da Iliitleemu dagaati yakwi. Inkoo dagaanii tlaaꞌasi daqa doogunay. Hhakee goóba ⁄imba gimba gu Iliitleemu, inay sigiroó amoo da ilaꞌaaꞌaatimisu kakaana, ");
INSERT INTO bds_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","idoo daa ilii handikimi gooay Handikaa da Iliitleemuge tuba, ‘Giyoómati khuꞌuniri see, yoó anaiiba, kara giyoómati akhamisiyayi see, yoó caahhiyaaiiba! Teesaaqay hiifookidiyaaiiba daqa Iliitleemuge tlakwaroo dooinaa, haa digigi ilamooyina ha Iliitleemu.’ ” ");
INSERT INTO bds_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Da hheꞌesi Yeesu gi kara kaay sa inay tuba, “Hanguubaslii caahha ilaꞌaaꞌaatisatee da dooslimiisay? Inkoo, bere teesaaqay, ha malee caahhaday, bere sangu cocoa gimba waku wa⁄a hari amoo da ilaꞌaaꞌaatimisu? ");
INSERT INTO bds_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Heedi gwaa daamisu pisagaroo ti heedi goó kakaama gimba gu Iliitleemu sa hida. ");
INSERT INTO bds_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inkoo, hida wakinay yoó ooyiyayi gimbakee, ubee pisagarotira pahha daa huhuꞌudi amooge. Qatlay giyoo ilii akhasiyeei gimba gu Iliitleemu, Sataanimoo yoóti cira khay, gii ca⁄asi gimbakira gu hhou diĩ cocoi sa inay. ");
INSERT INTO bds_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nama teesaaqay, hida wakinay yoóti ooyiyayi gimba gu Iliitleemu, ubee pisagarotira pahha daa huhuꞌudi gurimaasiya da kooma hhafida hari waꞌay kosi. Qatlay giyoo ilii akhamisiyee gimba gu Iliitleemu, cirakiray goóti ooyiyayi hari hhaꞌaloo. ");
INSERT INTO bds_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Inkoo, sa gimba inay, ubee ti barukaꞌa pahha gooba kibeeri, yoó hiikaasiyaaiiba. Qatlay digoó ilii khaye ilahufidu baku labaꞌasu sa gimbakee, inay yoóti cira mayay ⁄imbaraa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kara hida wakinay yoóti ooyiyayi gimba gu Iliitleemu, ubee pisagarotira pahha daa huhuꞌudi slanslawriige. Inay ti ilaꞌaaꞌatisa da hida hhakaꞌa pahha, goó akhamisa gimba gu Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","digigi asu ilaslaabi ha toodara gu khooroti, haa hiicoridu gu slawaraa hindaqaruumaa haa slahhaahhaau gu idadu wakinay see. Sa gimbakee digoóti afahhana gimba gu Iliitleemu, gi mayay slawa ⁄aamu. ");
INSERT INTO bds_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Karaai hiifaakooge hida wakinay yoóti ooyiyayi gimba gu Iliitleemu, ubee, pisagarotaꞌa daa huhuꞌudi hhapee da hhoige dii looi. Inay ti hida goó akhamisa gimbakee gu hhou, giyoóti ⁄imbiyay, gi slayay ⁄aamu wa⁄a, wakinay yoóti slayay ⁄aamu wa⁄a hari khisla, kara wakinay ⁄aamu wa⁄a hari khisla loi.” ");
INSERT INTO bds_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Da hheꞌesi Yeesu gi kara kaay sa inay tuba, “Bere caaꞌasiya dagaã da⁄i, dagaraagi khay waauuge, dagoóti ilakhupisiyaaba hari kiyaaray. Kara dagoóti qaasiyaaba hari sira da buburuu. Caaꞌasiyatee dagoóti qaasiyaabaslii bi⁄inaage? ");
INSERT INTO bds_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nama teesaaqay leẽ, hhaku gimba lensee daa yakwi, damaaba hiitlaaꞌasa cenceege ha Iliitleemu, kara wanaaba gimba lensee gu siiri damaaba hiitlaaꞌasa cenceege. ");
INSERT INTO bds_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bere heedi kona eaa, hini akhasiye naraꞌa, ma caahhi idoo ga cocaacoe.” ");
INSERT INTO bds_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Teꞌesii gi kara kaay sa inay tuba, “Itatiisa naraꞌa gimba ga akhamisideei, sa gimba pimokaꞌa goó ilakhuꞌudee sa hida wakinay, unkuray see nama hikee, sangunimaa ilakhui ha Iliitleemu! Kara unkuray sangumaa hiiroogisi hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gu lou, hikaꞌa gu kooma gimba gu Iliitleemu, ina sugumaa hiiroogisi hari khisla. Kara hikaꞌa goóba caahha gimbakee, gimati koomi see caahharatee da coko⁄o, dagoóti afii⁄utli daqa dosaa.” ");
INSERT INTO bds_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeesu gi ilakoomi gimba sa raqatira da hida tuba, “Kara ilaꞌaaꞌaatisa waka da Tawaaloo da Iliitleemu na nahaã: Dooslimiisay waku yaa daamisi pisagaroo qaymoo dosii. ");
INSERT INTO bds_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Teꞌesii balalu sliimaa yoóti yondiidi yondu gosi waku hari tleemaa, hari amasi yoóti qaati, qatlaykee sliimaa pisagaroo dosi giyoó iliitiꞌite, haa giyoó ilii dinaraarayde see, ina ti hhidina sumuku, idoo giyoó ilii ca⁄ade. ");
INSERT INTO bds_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pisagaroo yoóti tiꞌita ina lenkosi hhapeego, gi dinaraarayda, baruũ gi laqwali, asunkuilee gi hamaadi. ");
INSERT INTO bds_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Qatlay barukee giyoo ilii hheꞌesiye hamanaa, dooslimiisaykee gi tlaatleesi buꞌuruu barukee kosi, sa gimba qatlay gu buꞌuuꞌuru yaani day.” ");
INSERT INTO bds_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeesu gi kara kaay sa inay tuba, “Tawaaloo da Iliitleemu hagari idoo mala gooay ilaꞌaaꞌaatisana? Itatiisa naraꞌa gimbaki gu ilaꞌaaꞌaatimisu! ");
INSERT INTO bds_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tawaaloo da Iliitleemu ti pisagariya da haradaali pahha, da digiidakwi loi tla⁄aã gu pisagaroo sliimaage doó daamisiye. ");
INSERT INTO bds_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Teꞌesii bere dagaã daasi, gi tiꞌita, gu lou yoóti diirayda, gi khaimoo gu didiru loi tleehhidi tla⁄aã gu khai sliimaage doó daamisiye. Elemu kosi goó tledi hari khisla, cira⁄oo yoóti amoo hiidahhasida tleehhinay cuuraiĩ koina teꞌesii, mahhatu gosii.” ");
INSERT INTO bds_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nama amotee loi gooay, Yeesu hari ilaꞌaaꞌaatimisu wa⁄a gu teesaaqay slaqamisa, yaa kakaami gimba gu Iliitleemu sa hida, idoo giyaa ilii dahhasiri caahharaa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yeesu yaa kakaamiiba gimba lensee daqa dooinay, gi may amotee da ilaꞌaaꞌaatisa haa idoo waka. Qatlay Yeesu giyaa ilii sliimaa wane haa sirakoomiisee dosi kilesi, yaa ilakeesi sa inay maꞌaana da ilaꞌaaꞌaatimisukee sliimaa. ");
INSERT INTO bds_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Letutee leẽ hari khwayaiĩ, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Paaree tlo⁄osanee hari bara da cadii da tlawa.” ");
INSERT INTO bds_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Da hheꞌesi, sirakoomiisee dosi gi aareesidi raqatee da hida daa teꞌesii waara, gii guniri masuwateesii daa ilii ibiidi Yeesu, gi tooinaa waaudiri sliimaa haa ina. Masuwawuu wakinay see yaa wanay, gwaa sliimaa waaudeei haa inay. ");
INSERT INTO bds_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Inkoo, teꞌesii tlawage daagii ca⁄i ilafahhiya da didiri hari khisla, gondadee gu maꞌay gi tlaatleesiri tlupidu masuwatee hari ⁄uuru tluntlubaage, masuwatee dagaa iliihaci maꞌay, daati naahhi aloo hiihhanta tlawage. ");
INSERT INTO bds_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeesu yaa teꞌesii wana waꞌay gu masuwateesii alunge, yaa qaati, saga gosi giyaa hiiqaasi tlakwaꞌamooge. Teꞌesii sirakoomiisetee tosi gugii leehhisiri, gi kaayri sa ina hari afoo da didiri tuba, “Maarimuu, tlayii! Hoo iliiqaasidaabaslii gi anta tuba, dandiray slaꞌana kaka⁄u?” ");
INSERT INTO bds_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Da hheꞌesi ina yaagii tlay, gi ilii⁄oo⁄i ilafahhiyatee, gi kaay sa gondadee hhakee tuba, “Kaanahhasa diĩ, tlakhada!” Cirakiray lenge ilafahhiyatira gi qabidi sumuku, tlawa gi tlakhati diĩ haã gondadee hhakira see gu deni gi qabiri. ");
INSERT INTO bds_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yeesu gi kaay sa sirakoomiisetee tosi tuba, “Siĩ soꞌoyi tlaꞌamuumutiri teesaaqay? Unkuray inkoo naqatloo ha kahhadaaii, hakontaaiiba ⁄imba daqa dooii?” ");
INSERT INTO bds_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Teꞌesii inay digaa iliihaci tlaꞌamee da didiri loi, hingigi tlaatleesiri maamisu inay haa inay tuba, “Yuꞌudaa, hiĩ kara ti miyaa? Gunti ilii⁄oo⁄u ilafahhiya haã gondadee gu maꞌay see, gi akhasiri ina.” ");
INSERT INTO bds_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Da hheꞌesi, Yeesu haa sirakoomiisee dosi da mibi haa cada gi dayri hari bara da cadii da tlawa da didiri da Galilaaya, yade hhapee da Wageraasige. ");
INSERT INTO bds_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Qatlay Yeesu giyaa ilii cacaaca⁄iye waꞌay gu masuwateesaa tooinaa, heedi waku gwaa kooma gieeri yaagii ca⁄i maraoo daa ilii qamaamidiye tuueenaa, yaagi tu⁄udi, mangu slaslayri haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Heedikee yaa ayisasu hhakeesii ibimaamidi, yaa darabi hari khisla, hida giraa slanqadiri sumuku khiidiidiru, girimati hari nyololoo see. ");
INSERT INTO bds_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gu lou, dugwaati nikiikina khiidiidiru dabainge haã yeꞌeerooge see hari nyololoo, teꞌesii ina giyaati nikiikina kereꞌemisu nyololotee. Heedi lensee hhaku gwaa kooma ⁄uuru guri kaba⁄araa ina. ");
INSERT INTO bds_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Balalu sliimaa, qatlay gu tleemaa haã gu amasi see yaati maahhaahhamina yade ayisasuge haa omeerige, kara slaqwa dosi giyaati qutlaatlidi hari tle⁄eẽ. ");
INSERT INTO bds_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Qatlay heedikee giyaa ilii arimi Yeesu yade segenge, gi tu⁄udi, mangi slaslayri haa Yeesu, gi day daqa dosii, gi tosii keebeeidi pandaa dosii, ");
INSERT INTO bds_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","gi maahhi hari afoo da didiri tuba, “Ye Yeesu, Nanku Iliitleemu gu Rawaa gu Idadu Sliimaage Waara, hani hhanti labaꞌasida ana! Inkoo sini seelinte pandaa da Iliitleemuge tuba, hani mayda, hani ⁄agitintaaba!” ");
INSERT INTO bds_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yaa teesaaqay kaayri, sa gimba Yeesu yaa hheꞌesi sigaa kaay tuba, “Gieeri, ca⁄ii tiaa daqa heedikaa!” ");
INSERT INTO bds_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Da hheꞌesi, Yeesu gugi maasi tuba, “Uma googu na miyaa?” Gi ilaki⁄isi tuba, “Uma goy na ‘Legioni,’ sa gimba dandiray ti raqa da didiri loi.” ");
INSERT INTO bds_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Teꞌesii gieeri hhakee gi tlaatleesiri hiitlahhasu Yeesu hari khisla, magi may hiica⁄asa hhapeteesaa. ");
INSERT INTO bds_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Inkoo raqa da didiri da biinoo yaa wanta, daa deꞌeeꞌene teꞌesii ciyoomooge slaaburaa gu onke. ");
INSERT INTO bds_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Da hheꞌesi gieeri hhakee gi tlaatlaqasiri Yeesu tuba, “Hhooa handi ilafahhade, ma iliiguuma kayni biinotaꞌa.” ");
INSERT INTO bds_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeesu gigi ilafahhi. Cirakiray lenge gieeri hhakee yaagii ca⁄iri daqa heedikeesaa, gi iliiguuma kayri biinotee. Da hheꞌesi raqatee da biinoo, gonkosaa daa elefu cada taqaaqay, gii gweegwe⁄eti hari ⁄uuru ilagweegwe⁄eda da dihhigo, gii gunti tlawage, gi kaka⁄adi goõ. ");
INSERT INTO bds_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Qatlay deꞌemiisee da biinoo giyaa ilii anti teesaaqay, gi lakiti tongagu koinay, ma kaawa kayri sa hida koina gimbakee gungii ca⁄u. Da hheꞌesi, hida hhakee goõ yaagi feꞌediri, ma aniri gimbakee gwaa hiica⁄u. ");
INSERT INTO bds_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Qatlay giyaa ilii dayri daqateesii daa iliiwane Yeesu, gi aniri heedikira daa ilii khaabaaꞌadi ha gieeri wa⁄a, hiĩ ibiidi teꞌesii diĩ, hiĩ daamisi qayroo, kara kona waaway gu hhou. Qatlay giyaa ilii aniri teesaaqay, gi tlaꞌamuumuudiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Teꞌesii, hhakee gwaa arimee gimbakee, idoo giyaa ilii ca⁄i, gi ilakeesiri sa inay gimbakee goõ gu heedikee gwaa kooma gieeri haã gu raqatee see da biinoo. ");
INSERT INTO bds_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Teesaaqay hida hhakee gi tlaatleesiri tlaatlaqamisu Yeesu ma waaudi hhapee dooinaa! ");
INSERT INTO bds_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Qatlay Yeesu giyaa ilii dadaadaye waꞌay gu masuwateesii tooinay, heedikira daa ilii khaabaaꞌadi gieeri wa⁄a, gi tlaatlaqasi Yeesu, ma waaudiri sliimaa haa ina daqa gi kaye. ");
INSERT INTO bds_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Teꞌesii Yeesu gi siꞌi, sugugi kaay tuba, “Taa⁄a ki⁄e ayage, daqa hida gu mara googuu haa daqa hiidayuuma dooguu, sigi kaawa kayde gimbaki gu didiru diĩ yondiidi ha Taataa Iliitleemu daqa dooguu, haa idoo suguũ ilii ⁄awaarimi.” ");
INSERT INTO bds_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Da hheꞌesi, heedikira gi waaudi, gii cati hari tongagu goõ gu hhapee da Dekapooli, gi tlaatleesi kakaaru sa hida gimbakee gu didiru daa yondiidi ha Yeesu daqa dosii. Hida goõ gwaa akhasee gimbakee, yaati bakairi hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Da hheꞌesi Yeesu haa sirakoomiisee dosi da mibi haa cada gi kara tlo⁄osiri tlawa da didiri da Galilaaya, gi dayri baratirayi giyaa dahhiyeei wakaꞌalee, gii ca⁄iri masuwateesaa tooinaa. Qatlay Yeesu giyaa ilii teꞌesii wane kenga gu tlawage, dugugi kara iliiraagidi ha raqa da hida wa⁄a hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Teꞌesii heedi waku, uma gosi naa Yayiroo, yaagi khay. Ina naa giyaadimiisay gu didiru gu sinagoogi. Qatlay giyaa ilii arimi Yeesu yaani day teꞌesii, gi keebeeidi pandaa dosii, ");
INSERT INTO bds_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","higigi tlaatlaqasi tuba, “Taataa, hotoyi da coko⁄i mama⁄ada hari khisla, slaꞌada gwaaꞌaraa see. Hhooa poo, laga iliiqaasa kayda dabaiĩ koku, ma hiicaaquti haa ma maydi gwaaꞌaraa.” ");
INSERT INTO bds_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Da hheꞌesi Yeesu gi ⁄imbi, gi tooinaa waaudiri sliimaa haa Yayiroo mara gosii. Qatlay giyaa ilii khociicinee, raqa da hida wa⁄a gi sirakonti Yeesu, gugi iliiraagidiri. ");
INSERT INTO bds_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Inkoo raqateꞌesii yaa wanta hadee waka, daa ilahufimaamidiye ha ga⁄ay gu hiicaca⁄uu ceedee slaqwa dosaa koraraa mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hadetee dagaa ilahufidi hari khisla, dagaa umaasiisimi ha qwasleeri haa dareesimaiĩ wa⁄a, khooslay gosi goõ yaatii faaki daqa dooinay, hhoꞌowaraa see suti. Slaqwa dosi gi asu tlakwaydi hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hadetee yaa akhasidi gimba daa yondimaamidiye ha Yeesu. Inkoo Yeesu giyaa ilii cati hari teꞌesa, aluũ kosaa hadetee gugi sirakonti ina, gi cihhidi raqatee da hida, gi nangusidi somborokimoo gu qayru gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yaa teesaaqay laqadi, sa gimba yaa kaadi muuna gosii tuba, “Bere hati nangusa kilesi, gimati somborokimoo gu qayru gosi, gu lou, ana hiicaaquuda.” ");
INSERT INTO bds_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Teꞌesii, qatlay giyaa ilii nangusidi kilesi somborokimokee gu qayru gu Yeesu, cirakiray lenge ceedetira, daa hiicacaaca⁄a slaqwa dosaa, gi tosii kereꞌeti, hingigi anti hiĩ hhoaydi sumuku. ");
INSERT INTO bds_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Qatlaykeesii lenge Yeesu gi caahhi tuba, ⁄uuru waku gu hhoeesa hindii ca⁄i daqa dosaa. Da hheꞌesi gii fookidi bareemoo sliimaa raqateesii daa niini⁄iti ina, higigi maasi tuba, “Miyaa niĩ nangusi qayru gooi?” ");
INSERT INTO bds_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sirakoomiisee dosi gi ilaki⁄isiri ina tuba, “Siĩ soꞌoyi maasidi, ubee, ‘Miyaa niĩ nangusi ana?’ Kara tiꞌii ugu hanti anti hida ti wa⁄a, duguũ iliiraagidi?” ");
INSERT INTO bds_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Teꞌesii Yeesu gi ilakoomi khuꞌuduũ bareemoo sliimaa, ma arimi miyaa niĩ nangusi ina. ");
INSERT INTO bds_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Da hheꞌesi, hadetira yaagii satidi, gi keebeeiti pandaa dosii. Ina yaa tlaꞌamuti, tay dakhadakhada, sa gimba yaa caahhadi idoo dingii ca⁄adi daqa dosii. Sugugi kaadi gimba goõ gungii ca⁄u daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Teꞌesii Yeesu gi kaay sa ina tuba, “De hotoyi, igi ⁄imba doogi daqa dooii nigiĩ hhoeesi, sa gimba haã ⁄imbidi ⁄uuru gu Iliitleemu. Taa⁄a ki⁄e hari qasaw, ga⁄ay googi haã hhoaydi sumuku.” ");
INSERT INTO bds_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Qatlay Yeesu giyaa ilii kahhiye cocoꞌomooge haa hadetee, hida wakinay yaagi khayri yadaa mara gu Yayiroogo, gi kaayri sa Yayiroo tuba, “Hotoogu hhaka, hiĩ hhanti! Ba⁄ay inkoo maarimuu hagu hhanti labaꞌasana, handii kaaꞌani.” ");
INSERT INTO bds_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Teꞌesii Yeesu yaa iliiqaasiiba gimbakee daa kaay haa hida hhakee, gi kaay sa Yayiroo tuba, “Hhanti tlaꞌamuta, ugu ⁄uuru gu Iliitleemu kilesi na ⁄imbi.” ");
INSERT INTO bds_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeesu yaa kara ⁄imbiiba heedi lensee, mangu sirakomamidiri haa ina. Higii leehhi Peetiro, Yakoobo haa Yohaana nankooina haa Yakoobo kilesi, ma waaudiri haa ina haa Yayiroo. ");
INSERT INTO bds_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Qatlay giyaa ilii dayri aya gu Yayirooge, Yeesu gi akhasi ⁄aa⁄imuu gu gwaaꞌaraa haa gaiidimoo gu didiru hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yeesu gii day waꞌay gu marage, gi kaay sa inay tuba, “Siĩ soꞌoyi maahhadiri taqay, kara tay toogunaa ⁄aa⁄aday? Khwaylati hiĩ gwaꞌatiiba, hinti qati kilesi!” ");
INSERT INTO bds_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Qatlay giyaa ilii akhasiri teesaaqay, hida hhakee gi qasayri Yeesu, sa gimba inay yaa caahhiri tuba, khwaylatee hiĩ hhanti. Teꞌesii Yeesu higii ca⁄asi khoorooge hida hhakee goõ. Da hheꞌesi, gi ⁄oo⁄i taataa haa iyoo da khwaylatee sliimaa haa sirakoomiisee dosi tami gwaa waaree haa ina, gonkoinaa gii guniri sagayge, daqa giyaa iliiwante. ");
INSERT INTO bds_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Da hheꞌesi, Yeesu higigi ooyi khwaylatee hari daba gosi, gi kaay sa ina tuba, “Talitha koum!” ");
INSERT INTO bds_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cirakiray lenge khwaylatee gi tosii hiitlaydi, gi qaditi, gi tlaatleesidi khocu teꞌesii. (Yaa konta koraraa mibi haa cada). Qatlay giyaa ilii aniri hiĩ slafidi, yaati bakairi hari khisla loi. ");
INSERT INTO bds_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Teꞌesii Yeesu gii gadimi hari khisla hida gwaa teꞌesii waaree tuba, hhanti kaawa kayay sa heedi lensee gimbakee. Kara sigigi kaay tuba, “Khwaylatee saga qaydee ⁄agoo, ma ⁄aginti.” ");
INSERT INTO bds_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Inkoo Yeesu gi waaudi teꞌesaa yaamu hhakeesaa, gi ki⁄i Nasareetige tongoo dosii giyaa ilii diiray. Sirakoomiisee dosi da mibi haa cada yaa sliimaa hadakayri haa ina. ");
INSERT INTO bds_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Qatlay daa ilii day baloo da Sabaato, Yeesu gi tlaatleesi caacaahhamisu gimba gu Iliitleemu teꞌesii sinagoogige. Hida wa⁄a gwaa akhasee ina yaati bakairi hari khisla, hingigi maamisiri inay haa inay tuba, “Heediki yaani kaalaa slay gimbaki guti didiru taqay dee? Hiĩ yaa kaalaa slay waawayki, kara yaani kaalaa slay ⁄uuruki guri yondu haa guri laqaru gimba gu denu gu bakaꞌasa hida da kahhiye arimaa? ");
INSERT INTO bds_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hiĩ caba ti dakwidiisaykira, nanku Mariyaa, nankooina haani Yakoobo, Yoose, Yuuda haa Simooni? Kara hhiee kosi gu tigay caba yoó sliimaa ibiidiyay tiꞌii haa dandiray?” Teꞌesii gi slahhaahhaairi hari khisla sa ina, gugi siꞌiri. ");
INSERT INTO bds_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Tletimiisay yoó dakusiyaaba muree daqeemoo sliimaa gi kaye, muretee giyoó slayaaba yaamu kosii, daqa hiidayuuma dosii haa mara gosii.” ");
INSERT INTO bds_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Yeesu yaati bakai, sa gimba hida gu tongoo dosi gwaa ⁄imbiriiba ina kona hiidahhasa da yondiida yondu gu denu goó bakaꞌasa hida. Sa gimbakee ina yaa laqamiiba gimba lensee gu bakaꞌasa teꞌesii, yaati iliiqamidi kilesi dabaiĩ ga⁄iidee angaamaka haa gigi hhoeemisi. ");
INSERT INTO bds_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Da hheꞌesi, Yeesu gi waaudi, gi ilakhookhocimi tongoo haa tongoo, gi caacaahhamisi hida gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Letu waka, Yeesu gi ⁄oo⁄i sirakoomiisetira tosi mibi haa cada, magi ya⁄abi inay cada cada haa sigigi qay ⁄uuru sarii ca⁄amisu gieeri daqa hidago. ");
INSERT INTO bds_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Qatlay giyaa ilii kahhiyee waauda, gigi ilakaay inay tuba, “Hhanti hubitay idoo lensee, ti hhadaa kilesi na hubida. Hhanti hubitay mukaatimoo, curuquu, ma peesay see hhiyuumateesii. ");
INSERT INTO bds_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Unkuray daamisi ye⁄eetoo kilesi, hhanti hubitay kooti da cadii. ");
INSERT INTO bds_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kara sigigi kaay tuba, mara dangoo ilii kwahhasuusiye, teꞌesii kilesii ibiida, qatlaykaꞌa naqatloo gamaa ilii waautee yaamu hhakeesaa. ");
INSERT INTO bds_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bere daqa wakay dangoo kwahhasuusiyaaba, ma itatiisa see unkuray, waauda teꞌesaa. Qatlay goo ilii waautee teꞌesaa, gaagahha ceceiya yeꞌeeroo kokunaa, gimbakee yooti ilatlawa tleehhita daqa dooinay.” ");
INSERT INTO bds_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Da hheꞌesi, sirakoomiisetee gi waaudiri, gi kakaaniri gimba gu Iliitleemu tuba, hida yaa hiifookidiyee daqa Iliitleemuge tlakwaroo dooina. ");
INSERT INTO bds_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sirakoomiisetee higii ca⁄amisiri gieeri wa⁄a, gwaa ilii khaabaaꞌamidee hida, gi makhadiri ga⁄iidee wa⁄a hari du⁄iya haa gigi hhoeesiri. ");
INSERT INTO bds_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Inkoo Heroode, mutemi gu hhapee da Galilaaya, gi akhasi gimbakee goõ, sa gimba hida daqeemoo sliimaa yaa cocaacoiyay gimba gu Yeesu. Hida wakinay yaa kakaakaanay tuba, “Yohaana Hiinunqudimiisay yaani slafi ayisago! Sagani kona ⁄uuru guri yondiida gimba gu denu gu bakaꞌasa.” ");
INSERT INTO bds_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wakinay gi kaayri tuba, “Hikee ti Eliyaa, tletimiisaykira gu wakaꞌalee gu Iliitleemu naani ki⁄i!” Kara hida wakinay gi kaayri tuba, “Hiĩ ti tletimiisay gu Iliitleemu ubee, tletimiisee wakinay pahha gu wakaꞌalee.” ");
INSERT INTO bds_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Qatlay Heroode giyaa ilii akhasi gimbakee daa cocaacoiye ha hida, gi kaay tuba, “Hikee ti Yohaana Hiinunqudimiisay, gaa isa kereꞌesi, naanii ca⁄i ayisago!” ");
INSERT INTO bds_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wakaꞌalee, Heroode yaati ilafahhi sirikaarii dosi, Yohaana hiinuqudimiisay dugwaa ooyiye haa dugu khiidine jeerage. Ina yaati teesaaqay laqi, sa gimba gu Heroodiiya, hadee da Filiipo hhia gosi, giyaa khabimi. ");
INSERT INTO bds_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sa gimba, Yohaana yaa kaay sa Heroode tuba, “Ti naraꞌaaba ugu khaboo hadee da hhia googu.” ");
INSERT INTO bds_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sa gimbakee Heroodiiya gi slahhaꞌadi haa gi wakidi Yohaana, gwaati amoolaa slaꞌada gaasa. Teesaaqay see, yaa hiidahhasidiiba, sa gimba Heroode yaa slaiyaaba gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heroode yaa gwaa⁄i Yohaana, sa gimba yaa khui tuba, Yohaana yaati heedi gu kooma ibinaa daa tafaꞌadi pandaa da Iliitleemuge haa daa tlintiꞌisi, teesaaqay gugi ga⁄ay. Kara, Heroode dugwaa muuna tlakweesi giyaa ilii itatiitimisiye gimbakee gu Yohaana. Teesaaqay see, ina gwaa tosaa slai itatiimisu. ");
INSERT INTO bds_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Inkoo, Mutemi Heroode yaa ⁄isimi losona gu didiru, gu hiislawaraa baloo da hiidawaraa dosi. Ina gi kakaami sa hida kosi gu deni, sirikaarii dosi da deni haa giyaadimiisee da hhapee da Galilaaya. Teꞌesii Heroodiiya gi slaydi amoo dari gaasa Yohaana. ");
INSERT INTO bds_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Da hheꞌesi, hotosi da Heroodiiya yaagii daadi, gi tlaatleesidi seehha pandaa da Heroodege haa dahaa kosii gwaa ibiidee sliimaa haa ina. Heroode gi kaay sa sagameeriyatee tuba, “Firimi idoo ga igi slaꞌade, ana sigi hadisa.” ");
INSERT INTO bds_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kara Heroode gii fadidi hari seeliru daqa dosii tuba, “Gu lou, sigi hadisa idoo ga slaꞌade firoo daqa dooii, gamati slaꞌadi see, ma sigii deehhi tawaaloo doyi, ana sigi hadisa.” ");
INSERT INTO bds_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Da hheꞌesi, sagameeriyatee gii ca⁄adi khoorooge, gi maasa kaydi iyoo dosi tuba, “Iyoo, idoo mala gooay gana firima daqa mutemi Heroodego?” Iyoo dosi gi ilaki⁄isidi tuba, “Taa⁄a sugu kaade, ubee, sigi hadisiye saga gu Yohaana Hiinunqudimiisay.” ");
INSERT INTO bds_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sagameeriyatee gi ki⁄idi cira daqa mutemige, sugugi kaadi tuba, “Ana slaꞌa sini hadiside inkootuutuu tiꞌii siniyaage saga gu Yohaana Hiinunqudimiisay.” ");
INSERT INTO bds_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mutemi giyaa ilii akhasi gimbakee, yaa li⁄i hari khisla. Inkoo, sa gimba giyaa seelimi pandaa da dahaa kosii, yaa slaiyaaba maga afasiꞌi idoo giyaa firinti. ");
INSERT INTO bds_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cirakiray lenge mutemi gi ya⁄abi leẽ gu sirikaarii dosi doó ga⁄awa, maa kereꞌesi saga gu Yohaana haa guraa khaye daqa dosii. Sirikaarimokee gi waaudi jeerage haa gi kereꞌesi saga gu Yohaana hari pangaa. ");
INSERT INTO bds_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Teꞌesaa yaagi ki⁄i, gi geregedi saga gosi siniyaage, gi tosii hadisi sa sagameeriyatee. Da hheꞌesi girigi tosaa waauti, gi haysa kaydi sa iyoo dosi. ");
INSERT INTO bds_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Qatlay sirakoomiisee da Yohaana giyaa ilii akhasidi gimbakee gwaa hiica⁄u, gi hadakayri daqa Heroodege, sigimaa hadisi slaqwa da Yohaana, magi qaasaraa kayri aysage. ");
INSERT INTO bds_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Qariqaaqari ya⁄abimiisee da Yeesu yaagi ki⁄iri hhiyuuma dooinaa, gi kaayri sa Yeesu gimba goõ giyaani yondiidiri haã idoo giyaani ilii caacaahhamisiri hida. ");
INSERT INTO bds_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Da hheꞌesi, qatlay giyaa ilii teꞌesii wane sliimaa, hida wa⁄a yaa khakhaakhayay haa yaa waauuꞌumidiya. Teesaaqay Yeesu haa sirakoomiisee dosi yaa slayriiba ma mucu gu ⁄agoo see. Teꞌesii Yeesu gi kaay sa inay taai, “Paaree daqa wakay dayii caaqutige daba hida, ma hiifiifisa kayni coko⁄o.” ");
INSERT INTO bds_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Teesaaqay, gii guniri masuwaage inay kilakoina, gi waaudiri daqa dayii caaqutige, daaba ilii ibimaamidu hida. ");
INSERT INTO bds_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Teesaaqay see, hida wa⁄a gigi ariniri inay waaudiyay, gi caahhiri daqa giyaa kakaakayeei. Da hheꞌesi hida gu tongagu goõ gii slehheesiri, gi tlaatleesiri tu⁄udimoo yade khuꞌusa daqatiray, inay gi giyaadiri dawaraa. ");
INSERT INTO bds_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yeesu giyaa ilii ⁄eeti masuwaago, gi arimi raqa da didiri da hida. Ina gi ⁄awaarimi sa raqatee, sa gimba inay yaati raqataꞌa pahha da bee⁄u dabasli deꞌemiisay. Teꞌesii, ina gi tlaatleesi caacaahhamisu hida gimba wa⁄a gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sirakoomiisee dosi giyaa ilii aniri letu hiĩ paragidi, gi hadakayri daqa dosii, sugugi kaayri tuba, “Yuꞌudiyaa, daqati tiꞌii ga iliiwane ti hatli, inkoo letu see slaꞌada hiihuua. ");
INSERT INTO bds_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aareesi hida, ma waaudiri maraai gu qaymamuge waaree haa tongagu gu ilaciyaa waaree, ma sangii kiriga kayri ⁄agoo.” ");
INSERT INTO bds_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Teꞌesii, Yeesu gigi ilaki⁄isi inay tuba, “Unkuray sigi qaydeei ⁄agoo, ma ⁄aginiri!” Inay gi kaayri sa ina tuba, “Ugu slaꞌadaa dandiray ma kiriga kayni mukaatee gu dinaari miyaa cada, ma hadisani sa hida hhanki goõ ma ⁄aginiri?” ");
INSERT INTO bds_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu gi maasi inay tuba, “Inkoo unkuray mukaatee maka gana kontay? Taa⁄amida yuꞌudaw.” Qatlay giyaa ilii aniri, yaagi ki⁄iri, sugugi kaayri tuba, “Wana mukaatee kooani haa samaakii cada.” ");
INSERT INTO bds_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeesu gi kaay sa sirakoomiisee dosi, ma ibiidisiri hida raqoo haa raqoo sluufaa gu naa⁄age. ");
INSERT INTO bds_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hida gi ibiidiri raqoo gu hida mibeeri mibimibi, kara wakinay raqoo gu hida mibeeri koakoani. ");
INSERT INTO bds_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Da hheꞌesi, Yeesu gii oyi mukaatetira da kooani haa samaakikira gu cada, gi ganaꞌasi ilaa kosi rawge, gi kaay ⁄iisoo sa Iliitleemu sa ⁄agotee. Teꞌesii ina gi fandakumisi mukaatetee cokoocoko⁄o, gigi hadimisi sa sirakoomiisee dosi, ma hadimisiri sa hida hhakee guũ ibiidee raqooge, ma ⁄aginiri. Kara Yeesu gi deehhimi samaakikee see gu cada sa hida hhakee goõ, ma ⁄aginiri. ");
INSERT INTO bds_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hida hhakee goõ gi ⁄aginiri mukaatee haa samaakii, gi akhaakhaniri. ");
INSERT INTO bds_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Da hheꞌesi, sirakoomiisee dosi yaagii kurunkuriri fandakumay gwaa meetu gu mukaatee haa samaakii, gi hacimisiri kapapuu mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hida gwaa ⁄agimee ⁄agotee yaati wa⁄a, hhawatee kilesi faadoo dooina yaa elefu kooani. ");
INSERT INTO bds_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Qatlay giyaa ilii hheꞌesiri ⁄agotee, cirakiray lenge Yeesu gi kaay sa sirakoomiisee dosi, ma hiiguniri masuwaage, ma giyaadiri hari bara da cadii da tlawa da Galilaaya tongoo da Betisaydaage. Qatlay ina gi ilii aareemisiye raqatee da hida. ");
INSERT INTO bds_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yeesu giyaa ilii hheꞌesi aareesa hida hhakee, ina gi ilakhiinaaꞌadi onke, ma firoo kay Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Qatlay daa ilii amasuudi, masuwatee daa iliiwane sirakoomiisee da Yeesu, yaati asu daadi tla⁄aã gu tlawage. Qatlaykee, Yeesu yaa ina lenkosi wana hari kenga waku gu tlawa. ");
INSERT INTO bds_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yeesu gi arimi segengo sirakoomiisee dosi, idoo giyaa ilii aniri maana da madinay gu masuwatee, sa gimba caaqwa da dihhi yaa kaniinimisida inay pandaago. Qatlay daa ilii daadaauusi pisaraa, Yeesu gi ilii hadakay sirakoomiisee dosi, khoci hari rawaa gu maꞌay gu tlawatee, giti aloo hiicati pahha. ");
INSERT INTO bds_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Inay gwaa ilii aniri Yeesu yaa khoci hari rawaa gu maꞌay, gi ilahudeesiri inay beela, yaati iliitleemumoo, gi cunqusiri. ");
INSERT INTO bds_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Inay gonkoinaa gwaa ilii aniri ina, yaa tlaꞌamuudiri hari khisla. Teꞌesii cirakiray lenge Yeesu gi kaay sa inay tuba, “Karahhasa muunaiĩ, ti ana, hhanti tlaꞌamutay!” ");
INSERT INTO bds_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Da hheꞌesi, gii day masuwateesii giyaa iliiwanee, caaqwatira gi kaanahhasidi. Gonkoinaa yaati bakaakairi hari khisla, ");
INSERT INTO bds_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","inay yaa kahhiyay caahha gimba gu bakaꞌasa gu Yeesu gu hacisa mukaatetira, sa gimba muunaiĩ koina yaa karaarahhiri. ");
INSERT INTO bds_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yeesu haa sirakoomiisee dosi giyaa ilii tlo⁄osiri tlawa, gi dayri hhapee da Genesareetige, gi qadidisiri masuwaa kenga gu tlawage. ");
INSERT INTO bds_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Qatlay giyaa ilii ⁄ee⁄eetiri kilesi masuwaago, hida gwaa waaree teꞌesii gi cira caahhiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Da hheꞌesi, inay gi cira hiislehheesiri, gi niini⁄idiri hhapetee goõ, gi kakaaniri sa hida tuba, Yeesu yaani khay. Hida giyaa ilii akhasiri, gi geregediniri ga⁄iidee hari faloo, gi sirakomamidiri daqeemoo sliimaa giyaa ilii akhasiri tuba, ina yade wana. ");
INSERT INTO bds_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Daqeemoo goõ Yeesu giyaa ilii hadakakay, tongaguge, yaamuge baku qaymamuge, hida yaa leehhimisiri ga⁄iidee dooina daqa doó ilii kurunkurimidiye hida, gi tlaatlaqasiri Yeesu, ⁄imbiye ga⁄iidee dooina, ma nangumisiri ma somborokimoo gu qayru gosi kilesi see. Ga⁄iidee goõ gwaa nangumisee somborokimokee yaati hhoaaꞌayri. ");
INSERT INTO bds_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Letu waka, Farisaayoo haa maarimamaa angaamaka da sariyaa, yaa khayri yadaa yaamu gu Yerusaleemugo, inay goõ gii kurunkuridiri pandaa da Yeesuge. ");
INSERT INTO bds_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inay yaa aniri sirakoomiisee waka da Yeesu, yaa ⁄agiiginay ⁄agoo hhuncidaa see guba dabaiĩ, gimbakee yaa slasla⁄iima caacaahhamisu gu ou gooinay. ");
INSERT INTO bds_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Inkoo, Farisaayoo haa Wayahuudi goõ, bere guba hhuncidaa dabaiĩ tluhhiya naqatloo ⁄aginaaiiba ⁄agoo. Inay yoóti iliikonay caacaahhamisu gu ou gu okookoiĩ koina. ");
INSERT INTO bds_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kara bere yaa sokoonii dahhiyay ⁄aginaaiiba, hiti gesaa hhunciyay dabaiĩ koina naraꞌa, gi asu ⁄aginay. Kara konay ou waku wa⁄a giyoó iliikonee, da hiihhuncidu gooay kikombaae, sibeedoo haa ⁄alalee. ");
INSERT INTO bds_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Da hheꞌesi, Farisaayotee haa maarimamaa da sariyaa gi maasiri Yeesu tuba, “Sirakoomiisee doogu yoó soꞌoyi iliikonaaiiba ou gaa oowani daqa okookoiĩ kotaa, inay hiti ⁄agiiginay hhuncidaa see guba dabaiĩ?” ");
INSERT INTO bds_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeesu gigi ilaki⁄isi inay tuba, “Tletimiisay Isaaya yaa gimbuusi gimba gu lou, giyaa iliitletimi daqa doogunay unkuray peereehhiisee, idoo daa ilii handikimi gooay Handikaa da Iliitleemuge tuba, ‘Hida hhanki hinoóti muriidiyay hari gimba gu afaiĩ koina kilesi, teesaaqay see, muunaiĩ koina segenge loi wanay haa ana. ");
INSERT INTO bds_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Inay hinoóti daareesiyay ana Iliitleemu diitiray, inay yoóti caacaahhamisiyay hida, ma ooyiri ilakaawa da hida.’ ");
INSERT INTO bds_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gu lou, unkuray ilakaawa da Iliitleemu ganaa maydiri oowa, hoóti ooday caacaahhamisu gu ou gu hida.” ");
INSERT INTO bds_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Da hheꞌesi, Yeesu sigigi kaay inay tuba, “Unkuray khuꞌuday hii⁄ipa hari cirihhimaa ilakaawa da Iliitleemu, ma oodiri caacaahhamisu gu ou googuna! ");
INSERT INTO bds_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yuꞌudaa, Musaa tletimiisay gu Iliitleemu yaa kaay tuba, ‘Muriidi taataa googu haa iyoo doogu!’ Kara ilakaay tuba, ‘Heedi goó wahaahama taataa gosi baku iyoo dosi dugu gaasiye!’ ");
INSERT INTO bds_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Teesaaqay see, unkuray hoó kaaday tuba, bere heedi kaay sa taataa gosi baku sa iyoo dosi tuba, ‘Idadu kosi giĩ aloo qaye sa taataa gosi haa iyoo dosi ti Koribaani’ (maꞌaana dosi, idadu hhakee giĩ hadisi sadaaka daa tlintiꞌisi sa Iliitleemu), ");
INSERT INTO bds_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","hari caacaahhamisukee ina iliiayaaba kara taataa gosi baku iyoo dosi. ");
INSERT INTO bds_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Teesaaqay haganoó ilii qooqitay gimba gu Iliitleemu, sa iliikomamidu caacaahhamisu gu ou googuna gaa qaasidiri. Kara unkuray hoó yonditay gimba wa⁄a gu taqay slanqasa.” ");
INSERT INTO bds_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Da hheꞌesi, Yeesu gi kara eteedi raqatee da hida, sigigi kaay inay tuba, “Hani itatiisidee naraꞌa, kara kila heedi tla⁄aã googunay caahhiye naraꞌa gimbaki. ");
INSERT INTO bds_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hhaka idoo lensee doó hiidawa hari afa slaqwa da heedige hiraagi khayda slasla⁄iima. Teesaaqay see, idoo doó hiica⁄a afa gu heedigo, hatee noó ⁄isinta slasla⁄iima daqa heedige.” ");
INSERT INTO bds_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Qatlay Yeesu giyaa ilii may raqatee da hida, gii day mara wakuuge. Teꞌesii, sirakoomiisee dosi gugi maasiri amoo da ilaꞌaaꞌaatisatee. ");
INSERT INTO bds_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ina gi ilaki⁄isi inay tuba, “Unkuray kahhadaaii caahha tuba, idoo doó hiidawa hari afa gu heedi haroó khaydaaba slasla⁄iima? ");
INSERT INTO bds_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yuꞌudaa ⁄agoo doó ⁄agine heedi yoó hiidaadaaba muuna gosii, yoóti guraꞌa gosi kilesi kayda, qariqaaqari gii ca⁄ada slaqwa dosaa amootlahhayge!” Hari kaawaratee teesaaqay, Yeesu yaati laqami tuba, ⁄agoo goõ hiraatii boo⁄odi ⁄agooge. ");
INSERT INTO bds_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yeesu gi ilakoomi gimba tuba, “Gimba goó hiica⁄a waꞌay gu muuna gu heedigo, hikee naroó khay slasla⁄iima daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa gimba waꞌay gu muuna gu heedigo daganoó iliica⁄i ilahudaa gu tlakwi, slipalauuma, fiisa, cu⁄uduũ, ");
INSERT INTO bds_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","slahhaahhaau gu tlaku, hhitaa, tlakwaroo da muuna, afaꞌafuumaa, fitlaaloota, tloomu, wahaaharu, darabimaa haa bawma. ");
INSERT INTO bds_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tlakwaroti sliimaa goõ yoó waꞌay gu muuna gu heedi dahhada, naroó khayda slasla⁄iima daqa dosii.” ");
INSERT INTO bds_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gi waaudiri teꞌesaa, gi yada khuꞌusiri yaamu gu Tiiroge. Yade ina gii day mara gu heedi wakuu, ina yaa slaiyaaba heedi lensee ma caahhi tuba, ina wana teꞌesii. Teesaaqay see, hingaa hiidahhasiiba yakwaraa, hida ma mayri caahha. ");
INSERT INTO bds_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yade yaa wanta hadee waka, hotosi daa iliikhaabaꞌadi gieeri. Hadetee yaa Yunaanitoꞌoo, daa laqwali yaamu gu Foyiniikege gu hhapee da Siiriya. Ina yaa akhasidi gimba gu Yeesu, yaagi khaydi haa gi keebeꞌeti yeꞌeeroo kosii, gi tlaatlaqasidi Yeesu, ma hiica⁄asi gieeri hhakee daqa hotosaa. ");
INSERT INTO bds_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeesu sagagi kaay tuba, “May gesaa yaꞌay ma akhaakhaniri, sa gimba ti naraꞌaaba hiiowaraa ⁄agoo da daaqay, haa dagagii kwahhi sa gwehheeri.” ");
INSERT INTO bds_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hadetee gi ilaki⁄isidi Yeesu tuba, “Looimoo, guti lou! Teesaaqay see, gwehheeri see guroó biraa da meesaa waaree, yoó ⁄aginay ⁄agotaꞌa da yaꞌay, doó huhua rawaa gu meesaago.” ");
INSERT INTO bds_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu sagagi kaay tuba, “Sa gimba gu ilaki⁄isa doogi, taa⁄a ki⁄e ayage, gieeri hhakira hindii ca⁄iri daqa hotoogaa.” ");
INSERT INTO bds_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Da hheꞌesi, hadetee gi waauti aya gosii, gi slaydi hotosi, hiĩ qati buburuuge hhoinay, gieeri hhakira hindii ca⁄iri. ");
INSERT INTO bds_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Da hheꞌesi, Yeesu gi waaudi haa sirakoomiisee dosi teꞌesaa yaamu gu Tiirogo, gii cati hari yaamu gu Sidooni, gi yada khuꞌusi bara da tlawa da didiri da Galilaayage, gi dayri hhapee da Dekapoolige. ");
INSERT INTO bds_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Teꞌesii hida wakinay hiraagi khayri daqa Yeesuge, heedi gwaa qapana kara yaa afana⁄adi. Inay gi tlaatlaqasiri Yeesu, mayii qaasi dabaiĩ kosi daqa heedikeesii, magu hhoeesi. ");
INSERT INTO bds_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Da hheꞌesi, Yeesu girigi suruki heedikee kengage daqa raqateesaa, gii lu⁄i dicoo kosi waꞌay gu eaa gu heedikeesii, gii cubuqi, gi nangusi cufaraã gu heedikee hari cubuqari hhakee. ");
INSERT INTO bds_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yeesu gi yuꞌudi rawaa gu rawge, gi kaay tuba, “Ufay!” Teꞌesii gi kaay sa heedikee tuba, “Efaata!” (maꞌaana dosi na “Pooidiyee!”). ");
INSERT INTO bds_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cirakiray lenge eaa kosi gi pooidiri haã cufaraã gosi see dugugi hhoeesi, gi tlaatleesi cocoꞌomoo naraꞌa. ");
INSERT INTO bds_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Da hheꞌesi, Yeesu gii gadimi hida gwaa teꞌesii waaree, hhanti kaawa kayay gimbakee sa heedi lensee. Teesaaqay see, idoo giyaa ilii tlaatlahhasi, hida ginaa ilii ilaqinciri kakaaru gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hida goõ yaati bakairi hari khisla, gi kaayri tuba, “Hiĩ yondiidi gimba sliimaa naraꞌa hari khisla! Hiĩ hhoeesi qapanimaiĩ, ma akhamisiri, kara hida gwaa afana⁄amidee, ma cocoiri.” ");
INSERT INTO bds_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Qatlaykeesii raqa da didiri da hida yaa hiikurunkuriti daqa Yeesuge, yaa kontaaba idoo lensee da ⁄agoo. Da hheꞌesi, Yeesu gi ⁄oo⁄i sirakoomiisee dosi, gi kaay sa inay tuba, ");
INSERT INTO bds_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ana haã ⁄awaarimi sa hida hhanki, sa gimba hiĩ ibiidiri tiꞌii sliimaa haa ana balalu tami, kara konaaiiba idoo lensee diĩ meti da ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bere inay giyoo aareesa, ma watliri hari qori, yoo slaqaaqanay amooge, sa gimba wakinay yaa segeẽ dahhiyay.” ");
INSERT INTO bds_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Da hheꞌesi, sirakoomiisee dosi gi ilaki⁄isidi ina tuba, “Inkoo tiꞌii hatlikii ⁄agoo haga kaalaa slayna da buꞌudisa hida hhanki guti wa⁄a taqaaqay dee?” ");
INSERT INTO bds_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Teꞌesii, Yeesu gigi maasi inay tuba, “Unkuray mukaatee maka gana kontay?” Inay gi ilaki⁄isiri ina taai, “Mukaatee fanqu kilesi.” ");
INSERT INTO bds_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Da hheꞌesi, Yeesu gi kaay sa raqatee, ma ibiti hhapeege. Qatlay giyaa ilii ibiidiri, ina gii oyi mukaatetira da fanqu, gi kaay ⁄iisoo daqa Iliitleemuge, sa mukaatetee, gigi fandakumisi cokoocoko⁄o, gi hadisi sa sirakoomiisee dosi, inay ma hadimisiri sa hida. Teꞌesii inay gi yondiidiri teesaaqay, hida ma ⁄aginiri. ");
INSERT INTO bds_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sirakoomiisee dosi slime yaa konay samaakii angaamaka gu digiidaku daa khwereꞌesi. Yeesu gi hhaꞌaleesi Iliitleemu sa samaakikee see, gi asu kara kaay sa sirakoomiisee dosi, ma hadimisiri samaakikee sa hida. ");
INSERT INTO bds_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hida hhakee goõ yaa ⁄aginiri, yaati amoolaa akhaakhaniri naraꞌa. Qatlay giyaa ilii hheꞌesiri ⁄agoo, sirakoomiisee dosi yaagii kurunkuriri ⁄agotira daa meti, gi hacimisiri kapapuu fanqu. ");
INSERT INTO bds_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hida gwaa teꞌesii waaree, gwaa ⁄agimee ⁄agotee, yaa hida elefu cigahha taqaaqay. Qatlay giyaa ilii hheꞌesiri ⁄agoo, Yeesu gi aareesi inay. ");
INSERT INTO bds_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Da hheꞌesi, ina haa sirakoomiisee dosi gii dadayri masuwatiray tooinay, gi waaudiri, gi tlo⁄osiri tlawa da didiri da Galilaaya, gi dayri yaamu gu Dalimanuutage. ");
INSERT INTO bds_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Qatlay Farisaayoo giyaa ilii akhasiri tuba, Yeesu yaani khay, yaagi khayri daqa dosii, gugi koisiri hatliru hari amoo da maamisu hari cirihhimaa, gi kaayri sa ina tuba, “Inkoo aare sandi laqante gimba gu bakaꞌasa gwaa rawaa gu raw dahha, ma arini, bere gu lou, ugu ha Iliitleemu nugwaa ya⁄abi.” ");
INSERT INTO bds_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeesu yaa li⁄i muuna gosii gi kaay tuba, “Laqwaloti sa soꞌoyi slaꞌaday gimba gu bakaꞌasa? Gu lou, sangu kaay, laqwaloti saga laqanaaba gimba lensee gu bakaꞌasa.” ");
INSERT INTO bds_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Da hheꞌesi, Yeesu gi may Farisaayoo hhakee teꞌesii, gii day waꞌay gu masuwaage, gi tlo⁄osiri hari bara da cadii da tlawa da didiri da Galilaaya. ");
INSERT INTO bds_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Inkoo sirakoomiisee dosi digaagi afahhami hubida mukaatee, mukaatimoo leẽ kilesi ginaa konay teꞌesii waꞌay gu masuwateesii. ");
INSERT INTO bds_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Qatlay giyaa ilii tlo⁄oo⁄omisiyee tlawa, Yeesu gi ilii⁄oo⁄i inay tuba, “Hangu ga⁄aydee haa hamiira da Farisaayoo haa da Heroode.” ");
INSERT INTO bds_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Teꞌesii, sirakoomiisee dosi gi tlaatleesidi idara inay haa inay tuba, “Yeesu hinti kaay taqay, sa gimba haani konaaba mukaatee.” ");
INSERT INTO bds_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Teꞌesii, Yeesu yaa caahhi idoo hingaa ilii maamaamisiyeei, gi kaay sa inay tuba, “Hangu soꞌoyi ilaki⁄ii⁄imisiday unkuray haa unkuray tuba, handi kontaaiiba mukaatee? Inkoo, unkuray hati kahhadaaii caahha? Muunaiĩ kokuna saa soꞌoyi karaarahhiri teesaaqay dee? ");
INSERT INTO bds_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Haã antiriibaslii yondu goy hari ilaa kokuna, kara haã akhasidiriibaslii caacaahhamisu goy hari eaa kokuna? Unkuray hoó hiislaydaaiibaslii? ");
INSERT INTO bds_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Qatlaykira gaa ilii fandakumisi mukaatetira kooani daa ⁄agimisidi hida elefu kooani, qatlay unkuray gaa ilii kurunkuridiri ⁄agoo daa meti, haa slaydiri kapapuu maka gwaa hacaahacee ⁄agotee?” Inay gi ilaki⁄isiri sa ina taai, “Kapapuu mibi haa cada.” ");
INSERT INTO bds_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Da hheꞌesi, gi kara maasi inay tuba, “Kara qatlaykira ana gaa ilii fandakumisi mukaatetira da fanqu sa hida elefu cigahha, kapapuu maka gwaa hacaahacee ⁄agoo daa meti gaa slaydiri?” Inay gi ilaki⁄isiri sa ina taai, “Kapapuu fanqu.” ");
INSERT INTO bds_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Teꞌesii, Yeesu gi maasi inay tuba, “Inkoo ha soꞌoyi kahhaday caahha?” ");
INSERT INTO bds_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yeesu haa sirakoomiisee dosi gi dayri yade tongoo da Betisaydaage. Teꞌesii hida wakinay haraagi khayri heedi waku gwaa ilahhamu daqa Yeesuge. Inay gi tlaatlaqasiri Yeesu, ma hhoeesi heedikee. ");
INSERT INTO bds_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Teꞌesaa, Yeesu gugi ooyi dabage heedikee gwaa ilahhamu, gurigii ca⁄i kenga gu tongoteesii. Da hheꞌesi, yade Yeesu gugi iliicubuqi ilaage, gi tuntuki ilaa gu heedikee hari dabaiĩ kosi. Da hheꞌesi, Yeesu gugi maasi tuba, “Handii dahhasidii arimaa ma idoo lensee?” ");
INSERT INTO bds_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Heedikee gi yuꞌudi, gi kaay tuba, “Ee, haã arimi hida ubee, khai pahha na khookhociicinay.” ");
INSERT INTO bds_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Da hheꞌesi, Yeesu gi kara tuntuki ilaa gu heedikee hari dabaiĩ kosi. Teꞌesii ilaa kosi digigi hhoeesi, ⁄uuru gosi guri khuꞌuduũ dugwaagii ki⁄isi, gi arimi idadu goõ naraꞌa loi. ");
INSERT INTO bds_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Teꞌesaa, Yeesu gi aareesi heedikee, ma ki⁄i ayigosii, gi kaay sa ina tuba, “Inkoo, qatlay ga ilii ki⁄ide ayigooguu, hhantii catida hari tongotee da Betisayda.” ");
INSERT INTO bds_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Da hheꞌesi, Yeesu haa sirakoomiisee dosi gi waaudiri teꞌesaa, gi yade khuꞌusiri tongagu hhakiray gwaa ilaciyaa gu yaamu gu Kaysaariya Filiipige waaree. Qatlay giyaa ilii amooge wanee, Yeesu gi maasi sirakoomiisee dosi tuba, “Hida hinoóti kaayay tuba, ana na miyaa?” ");
INSERT INTO bds_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Inay gi ilaki⁄isiri ina tuba, “Hida wakinay yoóti kakaanay tuba, ugu na Yohaana Hiinunqudimiisay, naanii ca⁄i ayisago, wakinay yoóti kakaanay tuba, ugu na Eliyaa. Kara wakinay yoóti kakaanay tuba, ugu na tletimiisay waku gu wakaꞌalee gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Da hheꞌesi, Yeesu gigi maasi tuba, “Hari unkuray, hanoóti kaaday tuba, ana na miyaa?” Peetiro gi ilaki⁄isi Yeesu tuba, “Ugu na Kristu.” ");
INSERT INTO bds_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Teꞌesii, Yeesu gigi ilii⁄oo⁄i inay tuba, “Hhanti kaaday gimbakee sa heedi lensee!” ");
INSERT INTO bds_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Da hheꞌesi, Yeesu gi tlaatleesi caacaahhamisu sirakoomiisee dosi tuba, kwanda Nanku Heedi, dugu labaꞌasiye hari khisla haa dugu siꞌi ha gaduũ gu Yahuudi, hhapalooee da deni haa maarimamaa da sariyaa. Ina kwanda dugu gaasiye, kara qariqaaqari, baloo da tamiige yaa slafi yaagii ca⁄i ayisago. ");
INSERT INTO bds_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeesu sigaati kaay gimbakee goõ, yakwaraa see guba. Teꞌesii Peetiro harigi waaudi Yeesu afayige, gugi tlaatleesi ilii⁄oo⁄a ina sa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Teꞌesii, Yeesu gii fookidi, gi yuꞌudi daqa sirakoomiisee dosii, gi ilii⁄oo⁄i Peetiro tuba, “Ki⁄e aluũ koii Sataanimoo! Ugu ilahudaa koku guti Iliitleemu gooba, ti ilahudaa gu hida kilesi.” ");
INSERT INTO bds_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Da hheꞌesi, Yeesu gi eteedi raqatira da hida, maa hiisatidi ciyoomoo gosii, sliimaa haa sirakoomiisee dosi, gi kaay tuba, “Heedi gu slaꞌa sirakooma ana, kwanda hingi tlankiye ina lenkosi, da hheꞌesi geregediye musalaaba gosi, hini asu sirakone. ");
INSERT INTO bds_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa gimba, heedi gu slaꞌa ilabuꞌuru ibinaa dosi, higi hhamisi. Kara heedi gu hhamisa ibinaa dosi sa ana haã sa Gimba gu Hhou, hikee maa ilabuꞌuna ibinaa dosi. ");
INSERT INTO bds_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inkoo, heedi hhoinay mala slay, gimati slay hindaqaruumaa goõ da khooroti, tay gi hhamisi ibinaa dosi da koraraa haa koraraa goóba hiifaakoo? ");
INSERT INTO bds_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kara, heedi mala hadisi, ma slay ibinaa dosi da koraraa haa koraraa goóba hiifaakoo? ");
INSERT INTO bds_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Heedi goó ariirima ilamuree sa ana, haa gimba gooi pandaa da laqwalotii da slipalauumage haa da kooma tlakwaroo, Nanku Heedi, sugumaa arina ilamuree, gimaa ilii khaye hari wanqamee da Taataa gosi sliimaa haa malayika daa tlintiꞌisi.” ");
INSERT INTO bds_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Teꞌesii, Yeesu gi kaay sa raqatee da hida tuba, “Gu lou, hida wakinay tla⁄aã googunay, guũ qadimidee tiꞌii, maa kaka⁄iyaaiiba, maati gesaa arinayi Tawaaloo da Iliitleemu, daa khoca hari ⁄uuru gosi gu didiru.” ");
INSERT INTO bds_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Qariqaaqari, balalu lahhoꞌo giyaa iliicatiri, Yeesu hirigi waaudi Peetiro, Yakoobo haa Yohaana, girigi waaudi rawaa gu oõ gu tleeduge daqa da inay kilakoina. Yade, Yeesu gii fookidi kalay gosi pandaa dooinay. ");
INSERT INTO bds_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Qayroo kosi gi ⁄abaakwayri poy, gi tlaatleesiri wanqamee ti amoo celeceleiyay. Heedi lensee hhaku tiꞌii khoorotii gu hiidahhasa boo⁄imisuu gu qayru gu ⁄abaaku gu teesaaqay slanqasa. ");
INSERT INTO bds_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Da hheꞌesi, teꞌesii Eliyaa haa Musaa tletimiisetira da wakaꞌalee da Iliitleemu yaanii ca⁄iri pandaa dooinay, gi tlaatleesiri cocoꞌomoo haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Qatlay Peetiro giyaa ilii arimi teesaaqay, gi kaay sa Yeesu tuba, “Maarimuu, ti hhoinay dandiray ibinaa tiꞌii sliimaa haa unkuray. Handi ila⁄imbide dandiray ma tleehhana cuuraiĩ tami, leẽ sa ugu, gu caduu sa Musaa, kara gu tamii sa Eliyaa.” ");
INSERT INTO bds_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peetiro yaa teesaaqay kaay, sa gimba ina haa deneꞌee hhakira kosi gu cada digaa ooyi amaaoo hari khisla, ina yaa caahhiiba gimba mala gina kaay. ");
INSERT INTO bds_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Da hheꞌesi, daagii ca⁄i tlongiya, gonkoinaa digigi ilaslaabi ha tlongiyatee, afoo da Iliitleemu yaagii ca⁄adi tlongiyateesaa kakanta tuba, “Hiĩ na Nankoy gu leẽ ga slae. Akhamisakuna ina!” ");
INSERT INTO bds_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cirakiray lenge Musaa haa Eliyaa gii hhancooiri, giyaa kara aniriiba. Sirakoomiisetee da Yeesu giyaa ilii yuꞌudiri bareemoo sliimaa, Yeesu kilesi gunaati aniri, niĩ meeti haa inay. ");
INSERT INTO bds_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Qatlay giyaa ilii⁄eemaamidiyee okeesaa, Yeesu gigi ilakaay inay tuba, hhanti kaayiyay sa heedi lensee gimbakee giĩ aniri, baqamidiyeei ina Nanku Heedi maati gesaa slafi yaagii ca⁄i ayisago. ");
INSERT INTO bds_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inay gi qaasiri gimbakee muunaiĩ koinay, giyaa kaayriiba sa heedi lensee, hingigi maamisiri inay tuba, “Slafaraa ayisago, maꞌaana dosi na mala?” ");
INSERT INTO bds_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Inay gi maasiri Yeesu tuba, “Inkoo maarimamaa da sariyaa yoó soꞌoyi kakaanta tuba, kwanda Eliyaa giyaa gesaa khaye?” ");
INSERT INTO bds_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeesu gi ilaki⁄isi inay tuba, “Gu lou, Eliyaa kwanda giyaa gesaa khaye, ma hii⁄abeesi gimba sliimaa naraꞌa. Teesaaqay see, daa soꞌoyi handikimi Handikaa da Iliitleemuge tuba, Nanku Heedi kwanda gi slaye ilahufiduu wa⁄a gu tlaku, kara dugumaati siꞌi ha hida? ");
INSERT INTO bds_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Inkoo ana sangu kaay, gu lou, Eliyaa yaa hheꞌesi yaa khay, kara hida yaa laqiri gimba gu tlaku daqa dosii, giyaa iliislaiyee gooay inay, idoo daa ilii handikimi gooay, gimba gosi Handikaa da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Qatlay Yeesu haa sirakoomiisetee tosi giyaa ilii dayri daqa daa iliiwane sirakoomiisetira wakinay, gi aniri deneꞌee koina digiĩ iliiraagidi ha raqa da didiri da hida. Kara maarimamaa da sariyaa hingaa ilaki⁄ii⁄imisiyay haa inay. ");
INSERT INTO bds_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cirakiray raqatee goõ da hida giyaa ilii aniri Yeesu, yaati bakairi hari khisla, gi cira tu⁄umidiri daqa dosii, mangu cehheemisiri. ");
INSERT INTO bds_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Da hheꞌesi, Yeesu gi maasi sirakoomiisee dosi tuba, “Hangu mala ilaki⁄ii⁄imisiday haa hida hhanki?” ");
INSERT INTO bds_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Teꞌesii, heedi leẽ raqateesaa gi ilaki⁄isi ina tuba, “Maarimuu, yuꞌudiyaa, ana haraani khay nankoy, magu hhoeesidi, sa gimba dugwaa ilii khaabaaꞌadi ha gieeri, gugi afana⁄adisiri, gi may cocoꞌomoo. ");
INSERT INTO bds_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Balalu sliimaa bere duguũ ilii khaabaaꞌadi ha gieeri hhakee, dugoóti ilii cakhadi hhapeege, dugoóti iliica⁄i ha sluubariya afa gosii, tay tluꞌuna ⁄atloo kosi, slaqwa dosi yoóti karaarahhada. Ana haã firimi sirakoomiisee doogu da tiꞌii waara, ma hiica⁄asiri gieeri hhakee, teesaaqay see hingii dahhasiriiba.” ");
INSERT INTO bds_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Qatlay Yeesu giyaa ilii akhasi teesaaqay, gigi ilaki⁄isi inay tuba, “De laqwaloti doóba ⁄imba! Hati ibiida haa unkuray malaalee naqatloo? Hangutii kaasa malaalee naqatloo? Qaraimokee hindaakuna tiꞌii daqa dooii!” ");
INSERT INTO bds_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Da hheꞌesi gwaagii satisiri daqa Yeesuge. Teꞌesii, qatlay gieeri giyaa ilii aniri Yeesu, cirakiray lenge hiraagii ca⁄iri qwinqwiisii daqa khwaylimokeesii, gi huui hhapeege pukhu, gi gwangwaraaꞌamidi, dugwaagi iliica⁄i ha sluubariya afage. ");
INSERT INTO bds_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Teꞌesii Yeesu gi maasi taataa gu khwaylimokee tuba, “Inkoo ilahufiduki gu tlaku gu nankoogu yaa malaalee tlaatleesi?” Taataa gosi gi ilaki⁄isi tuba, “Yaa daaqauumaa dosaa tlaatleesi. ");
INSERT INTO bds_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kara gieeri hhakee yaati nikiikinay hiislaslakhuu nankoy aslaage haa maꞌayge see, magu gaasiri ina. Inkoo, ye taataa, bere ugu hiidahhasida iliiawaraa ina, hhooa sandi slahhaaꞌade, handi iliiayde.” ");
INSERT INTO bds_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Da hheꞌesi Yeesu gi kaay sa ina tuba, “Siĩ soꞌoyi kaadi tuba, bere hiidahhasa iliiawaraa? Gimba sliimaa dugoó hiidahhasi ha heedi goó ⁄imba Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Cirakiray lenge teꞌesii taataa gu khwaylimokee gi kaay tuba, “Ana kooma ⁄imba daqa Iliitleemuge! Inkoo hani iliiayde, ⁄imba tooii da hhaka.” ");
INSERT INTO bds_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Inkoo, qatlay Yeesu giyaa ilii arimi hida wa⁄a yaa hiislehheesiri hiikurunkurida daqateesii giyaa iliiwane, gi ilii⁄oo⁄i gieeri hhakee tuba, “Unkuray gieeri goóba cocoꞌomoo haa gu qapana, hanguu kaay, ca⁄aw daqa qaraimokaa, hagumaa hhanti ilii ki⁄iday!” ");
INSERT INTO bds_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Teꞌesii gieeri hhakee gi maahhiri, hiraagi kara hiica⁄iri qwinqwiisii hari ⁄uuru, gi asu hiica⁄iri daqa qaraimokeesaa! Da hheꞌesi qatlay giyaa ilii qaati teꞌesii hhapeege, hida gwaa teꞌesii waaree gi tlaatleesiri kaawa tuba, “Ayii, yuꞌudaa, hiĩ gwaai,” sa gimba kalay gu qaraimokee ubee, yaati tuuꞌuna pahha! ");
INSERT INTO bds_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Teꞌesii Yeesu gi ooyi daba gosi, gugii tlaysi, qaraimokee gi tosii qadidi, dugwaa hhoeesi sumuku. ");
INSERT INTO bds_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Qariqaaqari Yeesu haa sirakoomiisee dosi gii guniri waꞌay gu mara wakuuge. Teꞌesii, qatlay giyaa ilii inay kilakoina wanee, gi maasiri Yeesu tuba, “Dandiray hariĩ soꞌoyi slanqadani hiica⁄asa gieeri?” ");
INSERT INTO bds_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeesu gi ilaki⁄isi sa inay taai, “Gieeri gu taqay slanqasee, hiica⁄asaraa dooina yaati karahhadi, haroó amoo da firoo da Iliitleemu kilesi hiica⁄iyay.” ");
INSERT INTO bds_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Da hheꞌesi Yeesu haa sirakoomiisee dosi gi waaudiri teꞌesaa, yaa hiicatiri hari hhapee da Galilaaya. Yeesu yaa slaiyaaba heedi lensee ma caahhi daqa giyaa iliiwanee, ");
INSERT INTO bds_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sa gimba yaa caacaahhaahhamisi sirakoomiisee dosi taysi, yaa kakaakana sa inay tuba, “Nanku Heedi dugu taatahhi dabaiĩ gu fa⁄ayaa dosii. Inay gu gaasiyay, baloo da tamiige Iliitleemu giyaa slafisi yaagii ca⁄i ayisago.” ");
INSERT INTO bds_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Inkoo sirakoomiisetee tosi haraa slanqati caahha, idoo daa giimaamisiye ha Yeesu, kara giyaa ilamuriidiri maasaraa ina, ma sigi kaay maꞌaana da gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Asunkuilee Yeesu haa sirakoomiisee dosi gi dayri tongoo da Kaperinauumuge. Teꞌesii, qatlay giyaa ilii guniri mara giyaa ilii ibimaamidiyeei, Yeesu gi maasi inay tuba, “Hanguũ mala ilaki⁄ii⁄imisiday unkuray haa unkuray yade amooge?” ");
INSERT INTO bds_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Teꞌesii gonkoinaa gi qabiri diĩ, ilaki⁄isa see yaa koisiriiba, sa gimba qatlay giyaa ilii khociicinee yade amooge, hingaati ilaki⁄ii⁄imisiyay inay haa inay tuba, miyaa na didiri tla⁄aã gooinay. ");
INSERT INTO bds_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Da hheꞌesi Yeesu gi ibiidi, gi eteedi sirakoomiisee dosi goõ da mibi haa cada, gi tosaa kaay sa inay tuba, “Bere heedi waku slai heedi gu pandaa tleehhida, kwanda gi heedi gu hiifaakoo tleehhidiye haa tongimoo gu hida goõ tleehhidiye.” ");
INSERT INTO bds_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Da hheꞌesi Yeesu yaagii satisi khwaylimoo waku gu coko⁄u, higigi qadidisi tluntlubaa dosii tla⁄aã gooinay, gugi tosaa hiinapa⁄asi khwaylimokee daqa dosii, sigigi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Gu lou, heedikaꞌa goó kwahhasuusa daaqay gu digiidakwi hari uma goy, ana ginoó kwahhasuusi. Kara heedi goó kwahhasuusa ana, Taataa goy gunoó kwahhasuusi, hikee gunaa ya⁄abu ana tiꞌii.” ");
INSERT INTO bds_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Da hheꞌesi Yohaana gi kaay sa Yeesu tuba, “Maarimuu, dandiray haa arini heedi waku gwaa hiica⁄aa⁄amisi gieeri daqa hidago hari ⁄uuru gu uma googu, hagi koisani tlaatlahhasa ina, sa gimba yoó sliimaa wanaaba haa dandiray.” ");
INSERT INTO bds_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Teꞌesii Yeesu gi kaay sa inay tuba, “Hagu hhanti tlaatlahhasiday ina, sa gimba hhaku heedi lensee gu yondiida gimba gu denu gu bakaꞌasa hida hari uma gooi, gumaa cira hiidahhasa cocoꞌomoo gimba gu tlaku daqa dooii. ");
INSERT INTO bds_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hhanti tlaatlahhamisiday hida da ina gooay, sa gimba hhakee goóba kanimisu dandiray, hari bara doori wanay. ");
INSERT INTO bds_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sangu kaay, heedi gumaa iliiawa unkuray, sa gimba unkuray ti hida koi, ma hari qawaraa da maꞌay gu coko⁄o seei gu kitahhuu, gu lou, heedikee dakusiyaaba slawa ⁄aliya dosi daqa Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kara sangu kaay, bere heedi ⁄isina leẽ gu hhaã gu kahhee hii⁄atla ⁄imbage ina gi yondiidi tlakwaroo, heedikee hiti ba⁄ay duguti ilii kufi tlaa⁄a da didiri da saadiruu isa dosii. Da hheꞌesi, dugugi tosaa hiislakhi slagwiya da tlawa da didirige. ");
INSERT INTO bds_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Gu lou, bere daba googu ⁄isina ugu ma yonditi tlakwaroo, kereꞌesaku. Ti ba⁄ay ugu hiidawaraa ibinaa da koraraa haa koraraa goóba hiifaakoo hari daba leẽ, tay gi toogwaa meta hari dabaiĩ cada, gi asu hiidaada Jehanaamuge, daqa doóba iliihhama aslaa. ");
INSERT INTO bds_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kara bere yaaee doogu yoó ⁄isinta ugu ma yonditi tlakwaroo, kereꞌesaka, sa gimba ba⁄ay ugu hiidawaraa ibinaa da koraraa haa koraraa goóba hiifaakoo hari yaaee leẽ, tay gi toogwaa meta hari yeꞌeeroo cada, dugugi asu hiikwahhi Jehanaamuge, daqa doóba iliihhama aslaa. ");
INSERT INTO bds_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kara bere ila doogu ⁄isinta ugu ma yonditi tlakwaroo, tu⁄aka. Ti ba⁄ay ugu hiidawaraa Tawaaloo da Iliitleemuge hari ila leẽ, tay gi toogwaa meta hari ilaa cada, duguma hiikwahhi Jehanaamuge, ");
INSERT INTO bds_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","daqateesii doóba iliikaka⁄uu funjaa, kara doóba iliihhama aslaa koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hida sliimaa digimaa cakhasi hari aslaa. ");
INSERT INTO bds_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cakhasaa dati hhoi. Inkoo bere hiĩ hhamisidi cuuꞌu gosi, miyaa nii dahhasi ki⁄isaraa cuuꞌukira kosi? Slaw hhoinaykee gu cakhasaa muunaiĩ kokunay, kara ibiida hhoinay haa hida.” ");
INSERT INTO bds_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Da hheꞌesi Yeesu haa sirakoomiisee dosi gi waaudiri teꞌesaa Kaperinauumugo, gi hadakayri bara da hhapee da Yudaayage, hari tlo⁄osaa gu duudu gu Yoridaani. Yeesu dugwaagi kara ilii kurunkuridi ha raqoo gu hida, gigi kara tosaa caacaahhamisi, idoo daa iliiwane gooay ou gosi. ");
INSERT INTO bds_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Teꞌesii Farisaayoo wakinay yaagi khayri daqa Yeesuge, magu koisiri hatliru, hari amoo da maasaraa tuba, “Ga ilatahhade, ti naraꞌaa hhawata mawaraa hadee dosi?” ");
INSERT INTO bds_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Teꞌesii Yeesu gi maasi inay tuba, “Unkuray dangwaa mala ilakaay ha Musaa, gana yonditay?” ");
INSERT INTO bds_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Inay gi ilaki⁄isiri sa Yeesu tuba, “Musaa yaa ⁄imbi, bere hhawata slai mawaraa hadee dosi, saga kereꞌesiye tarakaa, gigi tosaa may.” ");
INSERT INTO bds_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Da hheꞌesi Yeesu gi kaay sa inay tuba, “Musaa yaa handikimi sariyatee sa okookoiĩ kokuna haã sa unkuray see, sa gimba gu karahhamuu gu muunaiĩ hhakee kokuna. ");
INSERT INTO bds_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Inkoo yadaa tlaatleesoogo, qatlay Iliitleemu giyaa ilii tleehhi khooroti, ‘giyaati tleehhi hhawata haa hadee.’ ");
INSERT INTO bds_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Sa gimbakee, hhawata may taataa haa iyoo dosi, hingigi ilagaasi haa hadee dosi. ");
INSERT INTO bds_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Teꞌesii inay cada koinaa gi slaqwa leẽ tleehhidiyay.’ Inkoo, inay hiti hida cadaaba kara, inay hiti slaqwa leẽ. ");
INSERT INTO bds_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Teesaaqay, hhakee daa ilagaasi ha Iliitleemu, heedi lensee gi hhantii deehhi.” ");
INSERT INTO bds_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Qariqaaqari, qatlay Yeesu haa sirakoomiisee dosi giyaa ilii kara waꞌay gu marage wanee, inay gi maasiri Yeesu, ma sigi kaay kara gimbakee gu mamawuu gu tigay. ");
INSERT INTO bds_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Teꞌesii gi kaay sa inay tuba, “Hhawata gu kereꞌesa tarakaa sa hadee dosi, kara gi khabina hadee waka, gimba gu slipalauuma ginoo yondiidi. ");
INSERT INTO bds_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kara harima amotee leẽ hadetaꞌa see damaa mawa hhawata gosi, dagagi khabina ha hhawata waku, ina see gimba gu slipalauuma ginoo yondita, ti tlakwaroo pandaa da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kara letu waka hida yaagi leehhisiri yaꞌay koina daqa Yeesuge, magi iliiqamidi dabaiĩ kosi, magi ⁄aafi. Teꞌesii sirakoomiisee dosi gi ilii ⁄oo⁄iri hida hhakee sa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Qatlay Yeesu giyaa ilii arimi idoo sirakoomiisee dosi giyaa ilii tlahhaahhamisiyee inay, dugugi slahhaaꞌasi, gi tosaa kaay sa inay taai, “Daaqay gu digidakwi maw yaa khayee daqa dooii, hagi hhanti tlaatlahhasiday. Sa gimba Tawaaloo da Iliitleemu dati hida da hhakee gooay. ");
INSERT INTO bds_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gu lou, sangu kaay unkuray, heedi goóba oowaraa Tawaaloo da Iliitleemu daaqay pahha, etaa hikee hiidayaaba tawaaloteesii.” ");
INSERT INTO bds_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Da hheꞌesi Yeesu gi tatlidi daaqay hhakee lelee lelee, higigi tosaa iliiqamidi dabaiĩ kosi sagaiĩ koinay, gigi ⁄aafi. ");
INSERT INTO bds_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Da hheꞌesi, qatlay Yeesu haa sirakoomiisee dosi giyaa ilii tlaatleesiri waaudimoo teꞌesaa, heedi waku yaagi tu⁄udi daqa Yeesuge, gi keebeeidi pandaa dosii, gugi asu maasi tuba, “Maarimuu gu muuna hhou, hati malee laqa, ma aalimi slafimaa gu koraraa haa koraraa goóba hiifaakoo?” ");
INSERT INTO bds_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Teꞌesii Yeesu gi kaay sa ina tuba, “Hani soꞌoyi eteedinta ana gu muuna hhou? Wanaaba heedi lensee gu muuna hhou, ti Iliitleemu kilesi. ");
INSERT INTO bds_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Inkoo, ugu ha khuꞌuda ilakaawa da Iliitleemu tuba, ‘Hhanti gaasida, hhanti slipalauta, hhanti fiisida, hhanti ilatlatlayda afaꞌafuuma, hhantii corita, muriidi taataa googu haa iyoo doogu.’ ” ");
INSERT INTO bds_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Teꞌesii heedikee gi ilaki⁄isi Yeesu tuba, “Maarimuu, ilakaawatee goõ hagaa iliikoomi yadaa daaquumaa dooaa.” ");
INSERT INTO bds_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Da hheꞌesi Yeesu gi yuꞌudi daqa dosii, gi tosaa kaay sa ina hari muuna gu slaꞌamuu taai, “Idoo leẽ kilesi gana kahhada laqaraa, taa⁄a naadimi idadu goõ ga konte, goo hheꞌeside la qaqayda peesaykee goo slayde sa kwaeeli, hari amotee ugu maa asu slayda hindaqaruumaa da loi yade rawaa gu rawge. Goo ilii hheꞌeside teesaaqay laqaraa, laa asu khayda, ma sirakoomiisay goy tleehhiti.” ");
INSERT INTO bds_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Qatlay heedikee giyaa ilii akhasi teesaaqay, gi waaudi hari li⁄eemoo, sa gimba ina yaa hindaqaru hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Teꞌesii da hheꞌesi Yeesu gi yuꞌudi bareemoo sliimaage, gi asu kaay sa sirakoomiisee dosi tuba, “Yuꞌudiyaa idoo daa ilii karahhi, hindaqeeri hiiguuma Tawaaloo da Iliitleemuge!” ");
INSERT INTO bds_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sirakoomiisee da Yeesu haraay tlaꞌadi hari khisla sa gimbakee kosi. Inkoo Yeesu gi kara kaay sa inay tuba, “Yaꞌay koi, yuꞌudiyaa idoo daa ilii karahhi, hindaqeeri hiiguuma Tawaaloo da Iliitleemuge! ");
INSERT INTO bds_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gu lou, ti slahharuũ hari khisla, gamiyaa hiicataraa hari pooa da singanoo, ba⁄ay hindaqaru hiidawaraa Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Da hheꞌesi sirakoomiisee dosi Yeesu yaati bakairi hari khisla loi, hingigi asu maamisiri inay haa inay tuba, “Bere gimbakee guti lou, miyaa dugunimaa hiidahhasi ilabuꞌuru ⁄agitirugo?” ");
INSERT INTO bds_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu gi yuꞌudi daqa dooinay, gi kaay tuba, “Hari bara da hida, gimbaki gii dahhasiyaaiiba, daqa Iliitleemuge teesaaqay gooba. Daqa Iliitleemuge gimba goõ dugwii dahhasi.” ");
INSERT INTO bds_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Da hheꞌesi Peetiro gi kaay sa Yeesu tuba, “Yuꞌudiyaa, dandiray haani mayni idadu sliimaa gaa kone, hagugi sirakoni ugu.” ");
INSERT INTO bds_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeesu gi ilaki⁄isi sa inay tuba, “Gu lou, sangu kaay, hhaku heedi lensee gwaani maw mara gosi baku hhia gosi, hhioo dosi, taataa gosi, iyoo dosi, yaꞌay kosi, haa baku qaymamu kosi. Bere teesaaqay laqiyay sa sirakooma ana haã sa Gimba gu Hhou gu Iliitleemu see, ");
INSERT INTO bds_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gu lou, qatlaykii gu inkooge hhakee maa slayay ⁄aamu waa mibeeri mibi, maraai, hhiee gu hhawatee haa gu tigay see, yaꞌay haa qaymamu. Idadu hhanki goõ giti slayay hari labaꞌasu qatlay gwaa khoca, sigimaa qay slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hida wa⁄a gungoó arimee pandaage wanay inkoo, teꞌesii himaati hida gu hiifaakoo tleehhidiyay, kara hida gu hiifaakooge waara, himaati gu pandaa tleehhidiyay.” ");
INSERT INTO bds_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Inkoo Yeesu haa sirakoomiisee dosi yaa kara amooge wanay, gi yade khuꞌusiri yaamu gu Yerusaleemuge. Yeesu yaa giyaadi coko⁄o pandaa dooinay, sirakoomiisee dosi yaa bakaꞌadi, kara hida wakinay see gwaa sirakomaamidiyeei inay yaa tlaꞌamuumuudiri. Da hheꞌesi Yeesu hirigi kara waaudi afayige sirakoomiisee dosi da mibi haa cada. Teꞌesii sigigi tlaatleesi kaawa inay, gimba gu tlaku gu hiica⁄akawa daqa dosii yade Yerusaleemuge, ");
INSERT INTO bds_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","gi kaay sa inay tuba, “Yuꞌudaa, inkoo Yerusaleemu kakaakayna. Yade, Nanku Heedi dugu taatahhi dabaiĩ gu hhapalooee da denige haa maarimamaa da sariyaa. Teꞌesii, inay gu hukunay duguma gaasi. Da hheꞌesi, inay gu taatahhiyay sa hida gu hhapapu wakinay. ");
INSERT INTO bds_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hida hhakee hinoo belendeqesiyay, noo ilii cubuqunay ana, hinoo difiyay hari jeleedimaiĩ na tooinaa gaasiyay ana. Teꞌesii baloo da tamiige maa tooaa slafa haagii ca⁄a ayisago.” ");
INSERT INTO bds_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Da hheꞌesi Yakoobo haa Yohaana, yaꞌay gu Sebedaayo, gii satiri daqa Yeesuge, sugugi kaayri tuba, “Maarimuu, ha slaꞌana, ugu ma sandi qaydi idoo haga slaꞌane firoo daqa doogaa.” ");
INSERT INTO bds_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Teꞌesii Yeesu gi maasi inay taai, “Idoo mala gana slaꞌaday, ana ma sangu qay unkuray?” ");
INSERT INTO bds_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gi ilaki⁄isiri Yeesu tuba, “⁄imbi dandiray ma ibiidani sliimaa haa ugu, leẽ hari bara doogu da ⁄uya, kara waku hari bara da basa wanqamee dooguu.” ");
INSERT INTO bds_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Teꞌesii Yeesu gi kaay sa inay taai, “Unkuray hhidintay idoo ga firiirintee! Gu lou, unkuray hiidahhasidaaii kitahhu hari qulu⁄ukee koi gu labaꞌasu gari kitahhe ana? Gu lou, hiidahhasidaaii danguma hiinunqudimisi harii nunqudimisukee gu ilahufidu goy gu didiru?” ");
INSERT INTO bds_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Da hheꞌesi inay gugi ilaki⁄isiri tuba, “Hiidahhasana!” Teꞌesii Yeesu gi kaay tuba, “Gu lou, hamaa kitahhaday qulu⁄uu goy guri labaꞌasu, kara dangumaa hiinunqudimisi harii nunqudimisukee gu dihhu. ");
INSERT INTO bds_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gimati teesaaqay see, ana koomaaba ⁄uuru gu kaawaraa miyaa namaa ibiidi hari daba goy gu ⁄uya baku hari daba goy gu basa. Daqeemoo hhakee ti wanay sa hida hhakaꞌa kilesi, daa ilakhuukhuꞌusi ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Inkoo qatlay sirakoomiisee waka mibi giyaa ilii akhasiri firoo da iyoo diĩ Yakoobo haa Yohaana daqa Yeesuge, yaa slahhaahhaairi hari khisla sa inay. ");
INSERT INTO bds_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Da hheꞌesi Yeesu gi eteedi sirakoomiisee dosi goõ daqa lenge, sigigi kaay tuba, “Unkuray ha khuꞌuday tuba, hida hhakaꞌa da khuiye khoorotii watemi da hhapapu wakinay pahha, yoóti tawaalinay hida koina hari ⁄uuru. Kara, hhakaꞌa gu koomee kofiyaa tawaalooge, yoóti ⁄uureemisiyay hida gu biraa koinay waaree. ");
INSERT INTO bds_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Inkoo tla⁄aã googunay hamaa hhanti teesaaqay laqaday. Bere heedi waku tla⁄aã googunay slai heedi gu didiru tleehhida, kwanda gi tongimoo googuna tleehhidiye. ");
INSERT INTO bds_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kara, bere heedi slai gu pandaa tleehhida tla⁄aã googunay, kwanda gi tongimoo gu yondimiisee goõ tleehhidiye. ");
INSERT INTO bds_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Namati amotee leẽ, ana see Nanku Heedi haati khayiiba tiꞌii khoorotii, sinima yondiidi ha hida. Ana hanti khay, ma yondiidi sa inay, haa ma hadisi ibinaa doyi, teesaaqay ma bui sa ilabuꞌuruu gu hida wa⁄a.” ");
INSERT INTO bds_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Da hheꞌesi Yeesu haa sirakoomiisee dosi gi dayri yaamu gu Yeerikoge. Qariqaaqari, qatlay giyaa ilii waauuꞌumidiyeei teꞌesaa, digaa kara sirakoomi ha raqa da didiri loi da hida. Inkoo yaa wana heedi waku gwaa ilahhamu, uma gosi naa Baritimaayo, nanku Timaayo, yaa ibiidi teꞌesii kenga gu amooge sa firoo da peesay daqa hidago. ");
INSERT INTO bds_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Qatlay Baritimaayo giyaa ilii akhasi tuba, ti Yeesu gu tongoo da Nasareeti nii cacaacati hari amotee, gi tlaatleesi maahhamiru tuba, “Ye Yeesu, Nanku Dawdi, sini ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hida wa⁄a gi tlaatleesiri ilii⁄oo⁄a Baritimaayo tuba, qabe diĩ! Teesaaqay see, ina gi asu ilakoomi maahhamee hari khisla tuba, “Nanku Dawdi, sini ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Da hheꞌesi Yeesu gi qadidi, gi kaay sa hida kosi tuba, “Eteedakuna!” Teꞌesii inay gugi eteeda kayri heedikee gwaa ilahhamu, inay gi kaayri sa ina taai, “Hiiye, karahhasi muuna, qadidi, dugu eteediidina ha Yeesu!” ");
INSERT INTO bds_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Teꞌesii Baritimaayo gi tosii hiilihhi qayru gosi, gugi tosaa may teꞌesii kenga gu amooge, gi cira qadidi, gi tosaa hadakay daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Da hheꞌesi Yeesu gugi maasi ina tuba, “Ugu mala slaꞌada, ana ma sugu laqi?” Baritimaayo gi ilaki⁄isi tuba, “Maarimuu, ana hati slaꞌa ma arimi kara.” ");
INSERT INTO bds_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeesu gi kaay sa ina tuba, “Taa⁄a waaudi ayage, ⁄imba doogu hiĩ hhoeesidi ugu.” Nama qatlaykeesii lenge Baritimaayo gi karaai slay ⁄uuru guri khuꞌuduũ, gi tosaa sirakoomi Yeesu amooge. ");
INSERT INTO bds_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Inkoo Yeesu haa sirakoomiisee dosi giyaa ilii daadaauusiri yaamu gu Yerusaleemuge, gi dayri tongoo da Betaniyaa haa Betifaage, gwaa ilaciyaa waaree haa slaaburaa gu oõ gu Miseyituunige. Teꞌesaa, Yeesu gi ya⁄abi sirakoomiisee dosi cada, ");
INSERT INTO bds_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","gi kaay sa inay tuba, “Taa⁄amida tongotiray naqatloo da pandaa doogunay waara. Qatlay goo ilii daadee tongoteesii, cirakiray hoo slayday daqumoo duguũ kufi teꞌesii, daqumokee da kahhiye iliidawa ha heedi lensee. Lugwaa gwetay, luguraa khayday tiꞌii daqa dooii. ");
INSERT INTO bds_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bere unkuray dangoo maasi ha heedi tuba, ‘Yeraa, daqumokee hagu soꞌoyi gweediidintay?’ Unkuray sugu kaadee ubee, ‘Looimoo gu Goõ gu slai, dugwaa ki⁄isi tiꞌii ciraai.’ ” ");
INSERT INTO bds_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Da hheꞌesi sirakoomiisetee tosi da cada gi toosaa waauti, gi daadi tongotiray, gi anti daqumoo naykaꞌa, duguũ kufi afamaraa wakuuge, kenga gu amooge. Qatlay gwaa ilii gweediidineei, ");
INSERT INTO bds_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","hida wakinay gwaa ciyoomoo gooinay waaree gi maasiri tuba, “Yeraa, hati malee lalaalaqaday, daqumokee goo gwetee haguri kaakayday?” ");
INSERT INTO bds_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Inay gi ilaki⁄isiri, idoo sigaani ilii kaay gooay ha Yeesu. Teꞌesii hida hhakee gi tooinaa ⁄imbiri, inay mari waaudiri daqumokee. ");
INSERT INTO bds_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inay guraagi khayri daqumokee daqa Yeesuge, gi hhafiifiniri qayroo koina danda gu daqumokeesii. Da hheꞌesi Yeesu gii day, gi tosaa ibiidi danda gu daqumokeesii. ");
INSERT INTO bds_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hida wa⁄a gi hhafiifiniri qayroo koina amoteesii daraa hiicati Yeesu sa laqaruu gu muree daqa dosii, haa wakinay gi hhafiifiniri loo⁄oo da khai giyaa qeetimisiri qaymamuugo. ");
INSERT INTO bds_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Teꞌesii hida hhakee gwaa giyaadee pandaa dosii, haa hhakee see gwaa aluũ kosaa waaree, gonkoinaa gi maahhiri kakaanay tuba, “Dugu hhaꞌaleesiye Taataa Iliitleemu! Kara dugu ⁄aafiye hikee gwaa khawa hari uma gosi! ");
INSERT INTO bds_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dugu ⁄aafiye tawaalokee see gwaa khoca, tawaalokee gu okookoo goori Dawdi! Dugu hhaꞌaleesiye Taataa Iliitleemu goó rawaa gu rawge waara!” ");
INSERT INTO bds_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Da hheꞌesi, qatlay Yeesu giyaa ilii day Yerusaleemuge, yaati fucuqusi mara gu didiru gu Iliitleemuge. Teꞌesii ina gi niini⁄idi bareemoo sliimaa efeenaage, ma arimi hida idoo giyaa yondimaamidiyee teꞌesii. Inkoo sa gimba yaa khwayaiĩ, ina haa sirakoomiisee dosi da mibi haa cada gi tooinaa waaudiri tongoo da Betaniyaage, ma guꞌudee kayri yade. ");
INSERT INTO bds_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Heetlaalee dosii, Yeesu qatlay giyaa ilii waaudi tongoo da Betaniyaago, yaa arimi qori. ");
INSERT INTO bds_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Inkoo yade amooge Yeesu yaa arimi ⁄ancimoo waku seesegengo, gwaa ilanihhu loo⁄oo, gi tosaa hadakay, ma arimi legeesaa slay ⁄aamu teꞌesii, na ⁄agimi. Qatlay giyaa ilii day ⁄ancimokeesii loo⁄oo kilesi ginaati slay, sa gimba qatlaykee yaa qatlay gu boo⁄imee da ⁄anca gooba. ");
INSERT INTO bds_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Da hheꞌesi Yeesu gi ilawaasi ⁄ancimokee tuba, “Gu lou, khaimoki maa kara boo⁄iyaaba ⁄aamu coko⁄o seei, wanaaba heedi lenseei gumaa kara ⁄agima ⁄aamu gu khaimoki!” Gimbaki giyaa gimbuusi dugwaa akhasi ha sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Qatlay giyaa ilii dayri Yerusaleemuge, Yeesu gii day efeenaa da mara gu didiruge gu Iliitleemu. Teꞌesii, gi tlaatleesi gusiisiru hida goõ gwaa naadiidimee haa gwaa kirigiigimee idadu sa hadimisu sadaaka. Slime gi slaslakhi meesasuu gu hida gwaa alaalaamee peesay, haa kiteeri gu hida gwaa naadiidimee kundee. ");
INSERT INTO bds_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Teꞌesii yaa kara ⁄imbiiba heedi lenseei naa kara leehhisi khooslay gu kiriga teꞌesii efeenaa da mara gu didiru gu Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Da hheꞌesi gigi tlaatleesi caacaahhamisu inay, gi kaay tuba, “Daa handikimiibaslii Handikaa da Iliitleemuge tuba, ‘Mara goy duguti eteedina mara gu ilii firoo sa hida gu hhapapu sliimaa’? Inkoo unkuray maraki gwaatii fookidiri ‘maraiya da fiisiisee.’ ” ");
INSERT INTO bds_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qatlay hhapalooee da deni haa maarimamaa da sariyaa da diini giyaa ilii akhasiri gimbakee goõ gu Yeesu, inay yaa slahhaahhaairi hari khisla, gi tlaatleesiri dabiidu amoo, magu gaasiri ina. Inkoo inay yaa tlaꞌamuudiri Yeesu, sa gimba hida sliimaa yaa hhaꞌaluumidiri hari khisla sa caacaahhamisu gosi goõ. ");
INSERT INTO bds_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Da hheꞌesi letutee hari khwayaiĩ Yeesu haa sirakoomiisee dosi gi kara waaudiri Yerusaleemugo. ");
INSERT INTO bds_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Heetlaalee dosii hari heetlawaa, Yeesu haa sirakoomiisee dosi qatlay giyaa iliicatiri hari ⁄ancimokira daa ilawaasi ha Yeesu, yaa ariniri, kaslenkwaa, hiĩ kay goõ haã kibeeri kosi see. ");
INSERT INTO bds_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Teꞌesii Peetiro yaay slay gimbakira gu Yeesu, qatlay ina saa ilawaasi ⁄ancimokee, gi kaay sa ina tuba, “Maarimuu, yuꞌudiyaa, ⁄ancimokira gaa ilawaasidi hinti kay sumuku!” ");
INSERT INTO bds_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Da hheꞌesi Yeesu gi kaay sa sirakoomiisee dosi tuba, “⁄imba Iliitleemu! ");
INSERT INTO bds_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gu lou, sangu kaay, heedikaꞌa gu kooma ⁄imba daqa Iliitleemuge, bere kaay sa oki tuba, ‘Ye oki, waaudi tiaa, taa⁄a hanguu kwahhade tlawa da didirige,’ kara bere ⁄imbi muuna gosii tuba, gimbakee sliimaa giĩ firimi yaa hiica⁄i, gu lou, sugu hadisi. ");
INSERT INTO bds_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa gimbakee sangu kaay ambee, gimba sliimaa ga firintee daqa Iliitleemuge, bere hamaa ⁄imbiday muunaiĩ kokunay tuba, sanguũ hadisi ha ina, gu lou, hiti kooguna tleehhidi. ");
INSERT INTO bds_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Inkoo sangu kaay unkuray gonkokunaa ambee, qatlay ga ilii firooge wantee, bere wana heedi gwaa dakusu daqa dooguu, la gesaa ilamooyinta tlakwarotee tosi sliimaa. Teesaaqay Taataa googu gu rawaa gu raw, ina slime ilamooyina tlakwaroo doogu sliimaa ga konte pandaa dosii.” ");
INSERT INTO bds_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Da hheꞌesi Yeesu haa sirakoomiisee dosi gi kara dayri Yerusaleemuge. Teꞌesii, qatlay Yeesu giyaa ilii khookhociicine efeenaa da mara gu didiru gu Iliitleemuge, hhapalooee da deni, maarimamaa da sariyaa haa gaduũ gu yaamu see yaagi khayri daqa dosii, ");
INSERT INTO bds_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","gugi maasiri tuba, “Gesaa ugu gimbaki haguri ⁄uuru gu tawaaloo da miyaa yondimaamita? Kara miyaa suguũ hadisi ugu ⁄uurukee?” ");
INSERT INTO bds_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Teꞌesii Yeesu gi ilaki⁄isi sa inay tuba, “Inkoo ana see hangu maasa unkuray gimba leẽ. Aarimida sini gesaa ilaki⁄isideei, ana see sangoo asu kaawa, ti hari ⁄uuru gu miyaa yondimaamida gimbaki. ");
INSERT INTO bds_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Inkoo, maasaraa doyi na nahaã, ⁄uurukee gu Yohaana gurii nunqudimisu gu hida, yaa kaadahhi? Yaa daqa Iliitleemu dahhi, baku yaa daqa hida dahhi? Aarimida sini kaadee!” ");
INSERT INTO bds_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Teꞌesii gi idaruusiri gimbakee inay haa inay tuba, “Bere dandiray hoo kaawana tuba, hiinunqudimisu gu Yohaana yaa rawaa gu raw dahhi daqa Iliitleemugo, ina hindoo maasi tuba, ‘Asu unkuray magwaa ⁄imbidiriiba?’ ");
INSERT INTO bds_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kara bere hoo kaawana tuba, ‘Yaa daqa hida dahhi,’ yuꞌudaa, hiidahhasanaaba ilaki⁄isa teesaaqay see!” Inkoo, hida hhakee gu deni yaa teesaaqay ilahudeesiri, sa gimba yaa tlaꞌamuudiri sa hida. Hida sliimaa yaa khuiyay tuba, gu lou, Yohaana yaa tletimiisay gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Teesaaqay, inay gi ilaki⁄isiri Yeesu tuba, “Dandiray ha hhidina.” Da hheꞌesi, Yeesu sigigi kaay tuba, “Ana see sangu kaawaaba, ti hari ⁄uuru gu tawaaloo mala yondimaamida gimbaki.” ");
INSERT INTO bds_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Da hheꞌesi Yeesu gi tlaatleesi gimba sa hida hhakee gu deni gu Yahuudi hari ilaꞌaaꞌaatimisu tuba, “Yaa wana heedi waku yaa daamisi sabiibu qaymoo dosii. Ina gii khangaꞌasi qwaama qaymoo goõ, gi fooli bonda hhafidage sa iliitinqiru ⁄aamu gu sabiibu, haa gi tleehhi tlankoo sa ga⁄aw gu qaymootee. Da hheꞌesi, qaymotee gigi dubisi sa dooslimiisee wakinay, ina gi hhiyuudi hhapee wakayge da segenge. ");
INSERT INTO bds_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Qatlay gu we⁄inay gu sabiibu giyaa ilii day, ina yaa ya⁄abi tongimoo gosi daqa dooslimiisetiray, ma sugwaa hiioyi daqa dooinaa bara da ⁄aamu gosi. ");
INSERT INTO bds_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Qatlay yondimiisaykee giyaa ilii day yade, inay gwaa tooinaa ooyiri, gugi difiri hari khisla, gugi tooinaa gusiniri, ina gi tosaa ki⁄i ayage hari dabaiĩ kilesi, idoo lensee hhaka giyaati hubidi. ");
INSERT INTO bds_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Teesaaqay, looimoo gu qaymotee gi ya⁄abi tongimoo waku daqa dooinay. Heedikee dugwaa saga dadahhi ha hida hhakee, gugi muriidisiri hari khisla loi. ");
INSERT INTO bds_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Looimoo gu qaymotee gi kara ya⁄abi yondimiisay waku, hikee gwaati gaasiri sumuku. Da hheꞌesi gi kara ya⁄abimi yondimiisee wakinay wa⁄a, wakinay giyaati difiri, wakinay giyaati cu⁄iri sumuku. ");
INSERT INTO bds_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Inkoo yaa meeti heedi leẽ kilesi gu ya⁄aba, hikee yaa nankosi gu leẽ giyaa slaiye hari khisla. Asunkuilee, gugi tosaa ya⁄abi daqa dooinay, gi kaay tuba, ‘Inkoo, inay gu muriidiyay nankoy.’ ");
INSERT INTO bds_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Qatlay nankosi giyaa ilii day teꞌesii, dooslimiisetira gi gimbuusiri inay haa inay tuba, ‘Yeraa, hiĩ na asu aalimiisayi gu qaymoti. Inkoo, hagu gaasanee, aalimeeti ma toori tleehhiti!’ ");
INSERT INTO bds_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Teesaaqay inay gugi ooyiri, gugi tooinaa gaasiri, tuuꞌuna dosi gi tooinaa kwahha kayri kenga gu qaymoteesii da sabiibuge. ");
INSERT INTO bds_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Inkoo ga ilatahhadee looimoo gu qaymotee, dooslimiisetee giti malee laqi? Gu lou, ina yooti khay sa hhamisa da dooslimiisetee, doo hheꞌesiye qaymotee giyoo tosaa kara dubisi sa wakinay. ");
INSERT INTO bds_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Unkuray haa somintiriibaslii gimbaki Handikaa da Iliitleemuge? Teꞌesii daa kaay tuba, ‘Tlaa⁄ukira daa siꞌi tlehhidiisee, hikee hiĩ tlaa⁄u gu didiru tleehhidi gu musingi. ");
INSERT INTO bds_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gimbaki yaa daqa Taataa Iliitleemu dahhi, kara ina nugwaa yondiidi, daqa doorii guti hhou khisla.’ ” ");
INSERT INTO bds_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hida hhakee gu deni gu Yahuudi qatlay giyaa ilii akhasiri teesaaqay, yaa caahhiri tuba, gimbakee diĩ gimbuusi ha Yeesu, inay diginiĩ ilaꞌaaꞌaatisi haa dooslimiisetira, kara haa tlehhidiisetira. Teꞌesii yaa slahhaahhaairi hari khisla, gi dabiidiri amoo da oowaraa Yeesu. Inkoo inay gwaa tlaꞌamuudiri oowaraa dosi sa raqatee da hida daa teꞌesii waara, gugi mayri, gi tooinaa waaudiri teꞌesaa. ");
INSERT INTO bds_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Qariqaaqari hida hhakee gu deni yaagi ya⁄abiri Farisaayoo wakinay haa hida hhakee see gwaa iliiaꞌaaꞌawee mutemi Heroode, magu maasiri Yeesu hari cirihhimaa, magu koisiri hatliru gimba gosii. ");
INSERT INTO bds_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Qatlay giyaa ilii dayri daqa dosii, gi kaayri tuba, “Ye Maarimuu, ha khuana, ugu na heedi goó gimbuusa gimba gu lou, sa gimba hoó tlaꞌamutaaba hida, kara hoó gwaa⁄adaaba kofiyaa da heedi lenseei. Ha khuana ugu hoó caacaahhamisida hida gimba gu Iliitleemu hari amoo da loi. Inkoo, aare sandi kaade, hiti naraꞌaa buꞌuduu koodi sa Kaysaari, baku hiti naraꞌaaba? Ugu bee mala, hati buanaa kooditee, baku hati mayna buꞌuduu?” ");
INSERT INTO bds_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Cirakiray lenge Yeesu yaa caahhi tuba, hida hhakee gwaati slaiyay hatliru hari cirihhimaa, gi kaay sa inay tuba, “Unkuray hani soꞌoyi slaꞌaday hatliru ana? Inkoo aarimida sinaa hiioodee goboriya leẽ, maga arimi.” ");
INSERT INTO bds_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Teꞌesii inay yaagii oyiri goboriyatee, gigi hadisiri sa ina. Yeesu gigi maasi inay tuba, “Kalay haa uma gu miyaa na wana goboriyatii?” Inay gugi ilaki⁄isiri tuba, “Kalay haa uma gu Kaysaari na wana goboriyateesii.” ");
INSERT INTO bds_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Da hheꞌesi Yeesu gi kaay sa inay tuba, “Haã kaadiri naraꞌa! Inkoo idadu gu Kaysaari hadisa sa Kaysaari, kara idadu gu Iliitleemu hadisa sa Iliitleemu.” Teꞌesii inay yaati bakairi hari khisla sa ilaki⁄isatee tosi. ");
INSERT INTO bds_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Da hheꞌesi Sadukaayoo, goó ⁄imbee tuba, hida gwaa kaka⁄ee maa slafiyaiiba yaagii ca⁄iyay ayisago, yaagi khayri daqa Yeesuge, inay see gugi maasiri ina tuba, ");
INSERT INTO bds_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ye Maarimuu, Musaa yaa handikimi ilakaawage tuba, bere heedi hhia gosi hiĩ hhami, hiĩ may hadee dosi kontaaba yaꞌay, heedikee kwanda gi aaline kwaꞌalitoꞌotee, ma laqwali yaꞌay sa hhia gosi. ");
INSERT INTO bds_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inkoo yaa wanay yaꞌay fanqu gu hhawatee gu mara leẽ. Hhia gooina gu badiisu gi khabimi, qariqaaqari gi tosii hhami, guba slawaraa yaꞌay. ");
INSERT INTO bds_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hhia gu caduu gi aalimi hadetee da nankooina, hikee see gi tosii hhami, ina see yaa slayiiba yaꞌay haa hadetee. Hhia gu tamiisee gi aalimi hadetee, gi hhami, ina see yaa slayiiba yaꞌay haa hadetee. ");
INSERT INTO bds_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Asunkuilee hhiee hhakee gu fanqu, gonkoinaa yaati kaka⁄iri, hhaku lenseei gwaa slaw yaꞌay haa hadetee. Yade pandaage hadetee see gi tosii hhanti. ");
INSERT INTO bds_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Inkoo aare sandi kaade, baloo hida gwaa kaka⁄ee gimaa iliislafisiye yaagii ca⁄iyay ayisasugo, hadeti damaa miyaa tla⁄aã gu hhiee hhakeesii gu fanqu. Sa gimba inay gonkoinaa giyaa khabiibiniri hadetee?” ");
INSERT INTO bds_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Da hheꞌesi Yeesu gi ilaki⁄isi sa inay tuba, “Unkuray haã dakusidiri, sa gimba hhidintay Handikaa da Iliitleemu, kara ha hhidintay ⁄uuru gu Iliitleemu see idoo giyoó iliiwane! ");
INSERT INTO bds_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yuꞌudaa, qatlay hida gwaa kaka⁄ee gimaa iliislafiyee yaagii ca⁄iyay ayisasugo, maa khabiibinaaiiba haa digimaa khabiibinaaba. Qatlaykeesii inay maati ibiidiyay malayika da Iliitleemu pahha raw gu rawge. ");
INSERT INTO bds_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kara ha caahhana Handikaa da Iliitleemugo tuba, hida gwaa kaka⁄ee, gu lou, maa slafiyay yaagii ca⁄iyay ayisasugo. Unkuray haa somintiriibaslii kitaabuu gu Musaage, yaqay saa arimi rukutiya daa ooyiiyima aslaa, ci⁄a see daba? Teꞌesii Iliitleemu yaa kaay sa Musaa tuba, ‘Ana na Iliitleemu gu Aburahaamu, Iliitleemu gu Isaaka, haa Iliitleemu gu Yakoobo.’ ");
INSERT INTO bds_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ina ti Iliitleemu gu hida gwaa kaka⁄ee gooba. Ina, ti Iliitleemu gu hida gu slafee. Unkuray hoó dakumisiday hari khisla soó kaadee ubee, hida gwaa kaka⁄ee maa slafiyaaiiba!” ");
INSERT INTO bds_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inkoo teꞌesii maarimuu waku gu sariyaa yaa wana ciyoomooge, gi akhasi inay, idoo giyaa ilii idaruurumisiyee. Qatlay giyaa ilii akhasi Yeesu, idoo giyaa ilii ilaki⁄isi naraꞌa sa hida hhakee, ina see gi tosaa maasi Yeesu tuba, “Daqa ilakaawatiray da wa⁄a da Iliitleemuge, ilakaawa haloo nayii looi hari khisla?” ");
INSERT INTO bds_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Teꞌesii Yeesu gi ilaki⁄isi tuba, “Ilakaawa dayii looi, da kooma ⁄uuru na nahaã tuba, ‘Ye hida gu Israeeli, itatiisa, Taataa Iliitleemu ti Iliitleemu goori, ina leẽ kilesi na Looimoo goori.’ ");
INSERT INTO bds_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Inkoo balalu sliimaa ‘Slae Taataa Iliitleemu, Iliitleemu googu, hari ilahudaa koku goõ, hari slafimaa koku goõ, hari waaway googu goõ haa ⁄uuru googu goõ.’ ");
INSERT INTO bds_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ilakaawa da cadii dayii looi na nahaã tuba, ‘Slae hida danaee koku, idoo hangu iliislaꞌade gooay ugu lenkoogu.’ Wantaaba ilakaawa waka dayii looi, da kooma ⁄uuru da hantaa gooay da cada.” ");
INSERT INTO bds_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Teꞌesii maarimukee gu sariyaa da diini gi kaay sa Yeesu tuba, “Maarimuu, naraꞌa loi! Ugu haã boo⁄isidi kaawaraa tuba, Iliitleemu ti leẽ kilesi, kara wanaaba gu caduu. ");
INSERT INTO bds_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kara gu lou, slae Taataa Iliitleemu hari ilahudaa koku goõ, hari slafimaa koku goõ, hari ⁄uuru googu goõ, kara slaꞌamuu hida, idoo heedi hingoó iliislaiye gooay, hhakee na idadu gu hhoi hari khisla ba⁄ay da hadisaraa sadaaka da hhamisaraa aslaage, slime haa hadisaraa sadaaka goõ sa Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Qatlay Yeesu giyaa ilii akhasi heedikee guũ ilaki⁄isi ina hari waaway, gi kaay sa ina tuba, “Gu lou, ugu haã daadaauusidi slawaraa Tawaaloo da Iliitleemu muuna googuu.” Teꞌesaa hhaku heedi lensee gwaa kara koisu maasaraa Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Qariqaaqari, qatlay Yeesu giyaa ilii caacaahhaahhamisiye hida efeenaa da mara gu didiru gu Iliitleemuge, yaa maasi inay tuba, “Inkoo maarimamatee da sariyaa da diini yoó soꞌoyi kaayay tuba, Kristu ti Nanku Dawdi, mutemikira gu wakaꞌalee? ");
INSERT INTO bds_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ha khuꞌuday tuba, Dawdi nama inakee leẽ yaa gimbuusi hari ⁄uuru gu Muuna gu Iliitleemu tuba, Taataa Iliitleemu yaa kaay sa Looimoo goy gu Goõ tuba, ‘Ibiidi hari bara doyi da ⁄uya, qatlaykaꞌa naqatloo gamaa ilii qaase fa⁄ayaa doogu, biraa gu yeꞌeeroo kokuu.’ ");
INSERT INTO bds_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Teesaaqay ha arintayi tuba, bere Dawdi loi, Masiiya gwaati eteediidina, ‘Looimoo gu Goõ.’ Inkoo Masiiya malee kara nankosi tleehhidi?” Raqatee da didiri da hida yaa hhaꞌaluumidiri sa itatiimisu gu gimba gosi. ");
INSERT INTO bds_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Qatlay Yeesu giyaa ilii ilakoomi caacaahhamisu, yaa kaay sa inay tuba, “Hangu ga⁄aydee haa maarimamaa da sariyaa da diini. Inay yoóti slaiyay khokhocu, tay hiĩ daamisiri jurungaguu gu tledi haa digima cehheemisi ha hida hari muree sokooniige. ");
INSERT INTO bds_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kara sinagoogige yoóti slaiyay ibinaa kiteeri gu pandaage, haa qatlay gu losonage, yoó slaiyay ibinaa kiteeri doó ilii ibiidiye dahaa gu muree. ");
INSERT INTO bds_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kara nama inay hhakee leẽ yoó afii⁄utlidiyayi idadu haã maraai see, tigay hhakee daa afakaka⁄i hhawatee. Kara yoóti firiirinay Iliitleemu hari firoo da tleedi, mangu laqaniri pandaa da hidage tuba, guti hhoi. Gu lou, hida gu teesaaqay slaqamisee digimaa ⁄agitina ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Da hheꞌesi Yeesu gi tosaa ibinaa kay ilaciyaa haa daqa daa ilii qaasi sandikoo waka da sadaaka, gi khuꞌumi raqa da hida, idoo giyaa ilii slaslaaslakhiyeei peesay waꞌay gu sandikoteesii. Hindaqeeri wa⁄a yaay slaslakhiri peesay upa. ");
INSERT INTO bds_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Inkoo teꞌesii yaagi khaydi mogombitoꞌoo waka kwaꞌalitoꞌoo, ina yaa hiislakhadi goboree cada kilesi, goboretee qoomay gosi gwaa coko⁄u loi. ");
INSERT INTO bds_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Qatlay Yeesu giyaa ilii arimi teesaaqay, gi eteedi sirakoomiisee dosi, sigigi kaay tuba, “Yeraa, gu lou, sangu kaay unkuray, kwaꞌalitoꞌoti hingii slakhadi hari khisla sandikoo da sadaakage ba⁄ay da hida goõ. ");
INSERT INTO bds_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hida hhanki goõ hinti hadisiri sadaaka hindaqaruumaa dooinaa. Inkoo kwaꞌalitoꞌoti hari kwaꞌaluumaa dosi hinti hadisidi idadu goõ, giyaa konte sari ibinaa dosi.” ");
INSERT INTO bds_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Inkoo, Yeesu giyaa iliica⁄i efeenaa da mara gu didirugo gu Iliitleemu, sirakoomiisay leẽ tla⁄aã gu sirakoomiisee dosaa gi kaay sa ina tuba, “Ye Maarimuu, yuꞌudiyaa! Maraai hhanki idoo gu ilii hhoi, kara tle⁄eẽ hhanki gu kuuta idoo gu ilii deni loi!” ");
INSERT INTO bds_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Teꞌesii Yeesu gi ilaki⁄isi sa ina tuba, “Hiiye! Maraai hhanki goõ gu deni hagiĩ antii? Gu lou sangu kaay, maa wantaaba tlaa⁄a lensee damaa meeta rawaa gu tlaa⁄a wakay, tle⁄eẽ goõ digimaati muumu⁄una.” ");
INSERT INTO bds_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Qariqaaqari Yeesu yaa ibiidi yade rawaa gu oõ gu Miseyituunige. Teꞌesaa gi arimi naraꞌa mara gu didiru gu Iliitleemu yade Yerusaleemuge. Qatlay giyaa ilii ibiidi teꞌesii, Yeesu dugwaa maasi aslaaꞌamee ha Peetiro, Yakoobo, Yohaana haa Andareyaa taai, ");
INSERT INTO bds_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Inkoo aare sandi kaade, gimbaki maa malaalee hiica⁄i? Kara, ti laqaru mala gumaa laqama tuba, gimbaki yaani daadaauusi hiica⁄araa?” ");
INSERT INTO bds_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Teꞌesii Yeesu gi kaay sa inay tuba, “Hangu ga⁄aydee, heedi lensee hhanti hiicori unkuray, ");
INSERT INTO bds_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","sa gimba, hida wa⁄a yaa khakhayay hari uma goy, tay kakaanay tuba, ‘Ana na Kristu,’ kara inay maa hiicoridiyay hida wa⁄a hari afaꞌafuumatee tooina. ");
INSERT INTO bds_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Karaai, qatlay gamaa ilii akhasideei gimba gu gau haa sahhasahhay gu gau, unkuray harimaa hhantii tlaꞌaday. Gimbakee kwanda gii ca⁄iye gesaa, baloo da hiifaakoo loi kahhada. ");
INSERT INTO bds_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gu lou, Hhapee leẽ maa qwaatlida haa hhapee waka, tawaaloo leẽ maa qwaatlida haa tawaaloo waka. Kara, damaa wana qori haa kintleemoo daqeemoo paslaapasloo. Gimbaki sliimaa ti tlaatleesoo kilesi, ti tlaatleesoo gu ba⁄adaa gu hadee da slaꞌa hiidawa. ");
INSERT INTO bds_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Inkoo unkuray hanguti ga⁄aydeei naraꞌa! Dangumaa ooyina ha hida, dangumaa leehhimisi balasasuu gu gaduũ gu sinagoogaguu koinay, kara sinagoogaguuge dangumaa difi. Kara, sa gimba gaã ⁄imbidiri ana muunaiĩ kokunay, dangumaa leehhimisi pandaa da magafanage haa watemige, sa gimba gooi, mani ilatlaydiri ana daqa dooinay. ");
INSERT INTO bds_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gimbakee gu Hhou kwanda dugu gesaa kakaane sa hida gu hhapapu goõ, teꞌesii balotee loi da hiifaakoo maa asu khayda. ");
INSERT INTO bds_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Qatlay dangumaa ilii ooyine, ma dangu leehhimisi balasasuu koinay, hamaa hhanti tlaꞌamutay gimba mala gunimaa kaawa kayday pandaa da hida hhakeesii. Qatlaykeesii lamaati gimbuusiday gimbakira kilesi, sangumaa hadisiye ha Iliitleemu. Unkuray gooba namaa gimbuusiday, ti Muuna gu Iliitleemu, namaa gimbuusi waꞌay kokunay. ");
INSERT INTO bds_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hhia maa hiifookidi hhia gosi loi daqa fa⁄ayaa dosii, ma dugu gaasi. Ayi maa hiifookidi nankosi, ma dugu gaasi. Kara, yaꞌay see maa siꞌiyay ayiĩ koina haã amu koina see, girimaati amoo dayay cu⁄udunge. ");
INSERT INTO bds_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Unkuray dangumaa waki ha hida sliimaa, sa gimba gu uma goy. Teesaaqay see, heedi gumaa hiikaasa ⁄imbaraage hiifaakoo naqatloo, hikee dugunimaa ilabuꞌuna ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Da hheꞌesi Yeesu gi kara kaay tuba, “Qatlay gamaa ilii antee idotira da kooma slasla⁄iima, da wakiye ha Iliitleemu hiĩ sihhiti daqa daa tlintiꞌisige, hhakaꞌa gumaa somimee gimbaki gu caahhiyee! Bere hamaa antayi teesaaqay, kwanda hida goó hhapee da Yudaayage ibiidee, maati cira lakidiyee omeerige, ma ba⁄aniri. ");
INSERT INTO bds_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Baloteesii, heedi gumaa khoorooge waara, maa hhantii day waꞌay gu marage, ma hiioy khooslay gosi sari lakidimoo. ");
INSERT INTO bds_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kara heedi damaa slaye qaymooge, maa hhanti ki⁄i ayage sa hiiowaraa jurungii dosi. ");
INSERT INTO bds_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gu lou, hamaa antayi balalu hhakee gumaa tlakwi hari khisla daqa tigay gumaa koomee hubay haa hhakaꞌa gumaa ruꞌumisee daa⁄a⁄ee! ");
INSERT INTO bds_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Inkoo firima Iliitleemu, gimbakee maa hhantii ca⁄i qatlay gu madenge, ");
INSERT INTO bds_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa gimba balalu hhakee damaa wana labaꞌasu gu didiru loi. Labaꞌasu da hikee gooay kahhi hiica⁄a yadaa tlaatleesoo daa ilii tleehhi khooroti ha Iliitleemu haa letuti naqatloo, kara etaa maa hiica⁄iyaaba da hikee gooay. ");
INSERT INTO bds_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gu lou, bere Iliitleemu yaa aloo ilakereꞌesiyaaba balalu hhakee gu labaꞌasu, heedi lensee hhaku gwaa aloo ba⁄ama. Inkoo sa gimba gu hida hhakee giyaa ina hiileehhi, inay see ma hida kosi tleehhidiri, ina maati ilakereꞌesi balalu gu labaꞌasukee. ");
INSERT INTO bds_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Qatlaykeesii, bere maa akhasidayi hida kakaanay sa unkuray tuba, ‘Yuꞌudaa, Kristu wana tiꞌii!’ kara wakinay bee, ‘Wana yade!’ hamaa hhanti ⁄imbiday, hikee ti gimba gu afaꞌafuuma kilesi. ");
INSERT INTO bds_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gu lou, qatlaykeesii damaa hiica⁄i afaꞌafuusee wakinay gumaa kaawee tuba, inay na Kristu, haa damaa hiica⁄i tletimiisee da afaꞌafuuma see. Inay gonkoinaa maati laqaaqanay gimba gu bakaꞌasa hida, ma koisiri hiicoriduu hida daa hiileehhi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ye hida koi, hangu ga⁄aydeei naraꞌa! Ana sanguũ kaay gimbaki sliimaa, qatlay gi ilii kahhiye hiica⁄araa.” ");
INSERT INTO bds_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yeesu gi ilakoomi gimba tuba, “Balalu hhakeesii, qariqaaqari damaa iliicatiye labaꞌasukee, ‘Letu dagamaay bo⁄eesi. Slehheẽ maay da⁄iyaaba, ");
INSERT INTO bds_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tica⁄eerii maay huhuiyay rawgo, ⁄uuru gu idadu gu rawge waaree, dugumaa rinqirinqisi.’ ");
INSERT INTO bds_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Teꞌesii hida goõ gumaa arinayi Nanku Heedi, yaa hii⁄eeti hari tlonga yadaa rawaa gu rawgo, haa hari ⁄uuru goõ haa wanqamee da hhoinay gu didiru. ");
INSERT INTO bds_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ina himaa ya⁄abi malayika da Iliitleemu, maa hiikurunkuriri hida kosi giyaa hiileehhi bareemoo cigahhago gu khooroo goõ, yadaa daqeemoo daa qatlisi hhapee haa raw. ");
INSERT INTO bds_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Inkoo, hari amoo da ⁄ancimoo hangu caacaahhamisidee ilaꞌaaꞌaatisateesaa. Qatlay elemu kosi giyoó iliinaana⁄iyee haa loo⁄oo dosi yaagi kucufida, teꞌesii unkuray hoó caahhaday tuba, qatlay gu madeẽ yaani daadaauusi. ");
INSERT INTO bds_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Namati teesaaqay, qatlay unkuray gamaa ilii antee gimbaki goõ sanguũ kaay hiicaca⁄i, caahha tuba, Nanku Heedi yaani daadaauusi ki⁄araa, ilaciyaa gu afamaraage wana. ");
INSERT INTO bds_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gu lou, sangu kaay unkuray ambee, laqwaloti da inkoo hiicatidaaba, qatlaykaꞌa naqatloo gimbaki goõ gimaa iliica⁄iye. ");
INSERT INTO bds_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Raw haa hhapee maa hiihhancooiyay. Teesaaqay see, gimba goy maa hiihhancooiyaaba coko⁄o see.” ");
INSERT INTO bds_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yeesu gi ilakoomi gimba tuba, “Hhaku heedi lensee gu khua baloo da hiica⁄araa da gimbakee goõ, gimati malayika see rawaa gu rawge hiti hhidinay, gimati Nanku Iliitleemu see hhidina, balotee Taataa kilesi naga khui. ");
INSERT INTO bds_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Inkoo, hangi ga⁄aydeei naraꞌa! Hiti diliqa! Sa gimba ha hhidintay balotee gimati qatlay see. ");
INSERT INTO bds_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gimbaki gu ga⁄aw, ilaꞌaaꞌatisa dosi ti barii heedikaꞌa pahha gwaa slaꞌa hhiyuuda yaamu gu segenge. Ina yaa may mara gosi dabaiĩ gu yondimiisee dosii, gonkoinaa sigigi hadisi yondu paslaapasloo, ma haraa yondiidiri. Teꞌesaa da hheꞌesi gi kaay sa heedi goó ga⁄awa mara gosi, na haraa ga⁄ay naraꞌa. Da hheꞌesi gi waaudi. ");
INSERT INTO bds_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Inkoo hida koi, diliqa, sa gimba unkuray ha hhidintay qatlaykee looimoo gu mara gimaa iliiki⁄iye, angamalee harimaa qatlay gu akhweesuu khay, angamalee hari amasi, angamalee hari amasidiira, angamalee maati qatlay gu konkakeeraa. ");
INSERT INTO bds_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bere himaa khay ubee, mankaraaiya pahha, dangumaa hhanti slay kahhaday guꞌudeege. ");
INSERT INTO bds_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gimbaki gaã gimbuusi sa unkuray, hagunti gimbuusi sa hida goõ ambee, ‘Hangi ga⁄aydeei naraꞌa!’ ” ");
INSERT INTO bds_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Inkoo yaa kahhiyay balalu cada kilesi sa dawaraa da loseenoo cada gungwaa sirakomamidee. Loseenoo hhakee yaa losona gu Pasaaka haa losona gu mukaatee doóba iliiqaasa hamiira ha hida gu Yahuudi. Qatlaykee hhapalooee da deni haa maarimamaa da sariyaa da diini yaa damaamidiyay amoo da oowaraa da Yeesu aslaaꞌamee, magu gaasiri. ");
INSERT INTO bds_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Teꞌesii hingaa ila⁄imbidiri inay haa inay, gi kaayri, inay bee, “Yeraa, inkoo heediki hagu hhanti oowana qatlay gu loseenoo hhakeeilee, sa gimba qatlaykee hida yoo wa⁄a, hida yoo ba⁄atii tlaatleesiyay gau sa gimbakee.” ");
INSERT INTO bds_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Inkoo, qatlaykee Yeesu yaa tongoo da Betaniyaage wana, dugwaa kwahhasuusi sa ⁄agoo ha heedi waku, uma gosi na Simooni, gwaa kooma wakaꞌalee ga⁄ay gu buubaa. Qatlay Yeesu giyaa ilii ⁄agiigine teꞌesii, hadee waka yaagii daadi teꞌesii daqa dosii, yaa konta khoosliya da hhoi ubee, siringima da coko⁄i pahha, daa boo⁄imisi hari tlaa⁄a waka, uma gu tlaa⁄atee na alabaasita. Waꞌay gu khoosliyateesii du⁄iya da kooma tafu gu hhou yaa wanta, du⁄iyatee kiriga dosi yaa peesay wa⁄a hari khisla loi. Da hheꞌesi hadetee gi kereꞌesidi isa da khoosliyatee, gi tosaa gii tuutuqudi du⁄iyatee saga gu Yeesuge, ma laqanti muree daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hida gwaa waaree teꞌesii, qatlay giyaa ilii ariniri hadetee idoo giyaa laqadi, wakinay yaa slahhaairi hari khisla, gi cocoiri hari muunaꞌafa inay haa inay tuba, “Du⁄iyati da peesay wa⁄a, hadeti giĩ soꞌoyi hhamisidi diitiray taqay? ");
INSERT INTO bds_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Inkoo hadeti, bere du⁄iyati ginti naadinta, hiĩ aloo slayda peesay wa⁄a, peesaykee duguũ tosaa aloo hadimisi sa kwaeeli.” Hida hhakee gigi ilii maahhiri hadetee hari dihhay. ");
INSERT INTO bds_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Da hheꞌesi Yeesu gi kaay sa inay tuba, “Maw ilahufidu hadeti! Ina hinti yonditi yondu gu hhou sa ana. ");
INSERT INTO bds_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yuꞌudaa, balalu sliimaa kwaeeli yoó sliimaa wanay haa unkuray, kara bere slaꞌaday, sigi toogunaa laqantay cabuuma dooguna see. Teesaaqay see, ana waaraaba sliimaa haa unkuray balalu sliimaa. ");
INSERT INTO bds_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Gu lou, hadeti hiĩ yonditi sa ana hari muuna gu cabuuma. Idoo giyaa ilii arinti gooay ti naraꞌa. Hiniĩ maakhadi hari du⁄iyati, ma haraa boo⁄isidi slaqwa doyi sa balotee da qaasaraa. ");
INSERT INTO bds_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gu lou, sangu kaay unkuray ambee, qatlay Gimba gu Hhou gu Iliitleemu dugumaa ilii kakaane sa hida daqeemoo sliimaa tiꞌii khoorotii, slime yonduki giĩ yonditi hadeti, dugumaa kakaana sa hiislaslaw gosi.” ");
INSERT INTO bds_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da hheꞌesi Yuuda Isikariyooti, leẽ gu sirakoomiisee mibi haa cada da Yeesu, gi hadakay daqa hhapalooee da denige, ma ilakhuukhuꞌusi haa inay, idoo gi ilii fookidiye Yeesu, gigi taatahhi dabaiĩ koinay. ");
INSERT INTO bds_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Qatlay giyaa ilii akhasiri teesaaqay, yaa hhaꞌaluumidiri hari khisla, teꞌesii hingigi ila⁄imbidiri buaraa peesay sa Yuuda sa iliiawaraa dooina. Da hheꞌesi Yuuda gi tlaatleesi dabiidu mucu gu hhou gu hiifookida Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Inkoo, baloo da tlaatleesoo da losona gu mukaatee doóba iliiqaasa hamiira yaa daadi, qatlay Wayahuudi giyaa ilii cu⁄uu⁄unee ⁄ambeenimaiĩ gu hadisaraa baloteesii da losona gu Pasaaka. Sirakoomiisetee da Yeesu gugi maasidi ina tuba, “Kaale slaꞌada, dandiray ma sugu ilakhuukhuꞌusa kayni daqa da ilii ⁄agoo Pasaaka?” ");
INSERT INTO bds_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Da hheꞌesi Yeesu gi ya⁄abi sirakoomiisee dosi cada, sigigi kaay tuba, “Taa⁄amida Yerusaleemuge, yade amooge hangoo slaslayday haa heedi waku, yaani geregedi sibida da maꞌay kwaahha dosii, lugoo sirakontay mara giyoo ilii dawaraa kaye naqatloo. ");
INSERT INTO bds_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Qatlay goo ilii daadee yade, loo kaaday sa looimoo gu marakee ubee, ‘Maarimuu goori yaani maasi tuba, “Waauu gu dahaa na kaloo tiꞌii, gi ilii ⁄agine losona gu Pasaaka sliimaa haa sirakoomiisee dosi?” ’ ");
INSERT INTO bds_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Teꞌesii ina sangoo laqana waauu gu hiitlaakhu yade gorofaage gu kooma khooslay goõ goo slaꞌane. Teꞌesii la haraa ilakhuukhuꞌusiday ⁄agoo sa dandiray.” ");
INSERT INTO bds_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Da hheꞌesi sirakoomiisetee tosi da cada gi toosaa waauti, gi daadi yaamu gu Yerusaleemuge, daa khay gimbakira sliimaa nahiĩ, idoo Yeesu sigaani ilii kaay gooay gi ilakhuukhuꞌusiri losona gu Pasaaka. ");
INSERT INTO bds_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Letutee hari khwayaiĩ Yeesu haa sirakoomiisetee tosi da mibi haa cada ginaa ilii dayri teꞌesii. ");
INSERT INTO bds_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Qariqaaqari qatlay giyaa ilii ⁄agiiginee, Yeesu ginaa ilii kaay sa inay tuba, “Gu lou, gu lou, sangu kaay leẽ tla⁄aã googunay, hiniĩ fookidi ana.” ");
INSERT INTO bds_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Da hheꞌesi gonkoinaa gi li⁄iri sa gimbakee, gugi tlaatleesiri maamisu lelee lelee tuba, “Malaaꞌay, ti anagoo?” ");
INSERT INTO bds_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeesu gi ilaki⁄isi sa inay tuba, “Ti leẽ gu sirakoomiisee da mibi haa cada, naykee gu hiitika⁄a mukaatimoo sliimaa haa ana lagabay lenge. ");
INSERT INTO bds_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gu lou, Nanku Heedi gwaai, idoo daa ilii handikimi gooay Handikaa da Iliitleemuge. Inkoo, yoo ana heedikaꞌa gu hiifookida Nanku Heedi! Yaati ba⁄ay daqa heedikeesii, bere dugwaati aloo may laqwaloo.” ");
INSERT INTO bds_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Qatlay giyaa ilii ⁄agiiginee, Yeesu yaa hiioy mukaatimoo, gi kaay ⁄iisoo daqa Iliitleemuge, gugi fandakumisi, haa gi tosaa hadisi sa sirakoomiisee dosi. Ina gi kaay tuba, “Owaa ⁄agima, haã na slaqwa doyi.” ");
INSERT INTO bds_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Da hheꞌesi gii oyi qulu⁄uu gu difaay, gi kaay ⁄iisoo daqa Iliitleemuge, gi tosaa hadisi sa inay, gonkoinaa gi tooinaa kitahhaniri hari qulu⁄ukee. ");
INSERT INTO bds_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Teꞌesii gi kaay sa inay tuba, “Haã na ceedee doyi da laqama ila⁄imbidu gu ⁄abu, da tuutuquda sa ilabuꞌuruu gu hida wa⁄a tlakwaroogo. ");
INSERT INTO bds_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gu lou, sangu kaay ana ha kara kitahhaaba difaay balotaꞌa naqatloo gamaa iliikitahhe difaay da ⁄abi Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Qatlay giyaa ilii hheꞌesiri raaꞌamu, raaꞌamee da daareesa Iliitleemu, Yeesu haa sirakoomiisee dosi gi waaudiri oõ gu Miseyituunige. ");
INSERT INTO bds_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeesu gi kaay sa sirakoomiisee dosi tuba, “Letuti unkuray gonkokunaa hanoo lakitay ana, nooti mayday ana lenkway. Gimbaki dugwaa handikimi Handikaa da Iliitleemuge tuba, ‘Ana hamaa sagadahha deꞌemiisay, teꞌesii bee⁄u gosi maati pasidi goõ.’ ");
INSERT INTO bds_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Teesaaqay see, qariqaaqari ana goo iliislafe haagii ca⁄a ayisago, hoo giyaada yade hhapee da Galilaayage.” ");
INSERT INTO bds_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Teꞌesii Peetiro gi kaay sa Yeesu tuba, “Bere deneꞌee koi gonkoinaa goo mayay ugu gi tooinaa lakidiyay, ana hagooti mawaaba ugu coko⁄o seei!” ");
INSERT INTO bds_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeesu gi ilaki⁄isi sa Peetiro tuba, “Gu lou, sugu kaay ugu, hari amasi hhanki gu letuti, konkaku giyoo ilii kahhiye ceearaa ceeoo cada, ugukee loi hanooti tlankida ana waa tami ubee, ‘Heedikee hagu hhidima!’ ” ");
INSERT INTO bds_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Teꞌesii Peetiro gi ilakoomi hiitlahhasu hari ⁄uuru tuba, “Bere gwaaꞌaraa goosee, ana kwanda ga gwaae sliimaa haa ugu, etaa ana hagu tlankaaba ugu coko⁄o seei.” Teꞌesii sirakoomiisee goõ gi kaayri namati teesaaqay leẽ. ");
INSERT INTO bds_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Da hheꞌesi, inay gi dayri daqa wakay yade oõ gu Miseyituunige, uma gu daqatee naa Getesemaani. Teꞌesii Yeesu gi kaay sa sirakoomiisee dosi tuba, “Ibiida tiꞌii, qatlay ana ga ilii firoo kawe Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Teꞌesii gi eteedi Peetiro, Yakoobo haa Yohaana, girigi waaudi pandaage. Yade ina gi li⁄i haa gi bahhangaruusi hari khisla. ");
INSERT INTO bds_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ina gi kaay sa inay tuba, “Ana ha kooma li⁄eemoo da didiri muuna gooii, daadaauusa da gwaaꞌaraa see. Inkoo ibiida tiꞌii, guula sliimaa haa ana.” ");
INSERT INTO bds_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Teꞌesaa gi waaudi pandaage coko⁄o, gi keebeeidi, gii gupu⁄usi pandaa dosi hhapeege, gi firimi tuba, bere Taataa ⁄imbi, sugu hiitlintiꞌisiye balotee da labaꞌasu haa da gwaaꞌaraa dosi daa khoca. ");
INSERT INTO bds_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qatlay giyaa ilii firiirine, gi kaay tuba, “Aaba, ye Taataa, gimba sliimaa daqa dooguu gutii slaahhuslaahhu kilesi. Inkoo aare sini surukuside qulu⁄uki gu labaꞌasu daqa dooaa. Teesaaqay see, hhanti yondita idoo ga iliislae ana, yondiidi idoo ga iliislaꞌade ugu.” ");
INSERT INTO bds_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yeesu gi ki⁄i daqa sirakoomiisetiray, gigi slay inay hiĩ guiri. Ina gi tosaa kaay sa Peetiro tuba, “Ye Simooni hanti cira guꞌudii? Ugu hiidahhasidaabaslii guulimee gimati saa leẽ see? ");
INSERT INTO bds_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Inkoo, hhanti guꞌuday, firima Iliitleemu, ha ba⁄atii gii huuꞌuday koimisuge. Gu lou, muunaiĩ kokuna slaiyay kaba⁄a koimisu, teesaaqay see, slaqoo kokuna ti nanqweree⁄iyay.” ");
INSERT INTO bds_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yeesu gi waaudi kara pandaage, gi firimi Iliitleemu nama gimbakira leẽ giyaa firimi gu pandaa. ");
INSERT INTO bds_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Qatlay giyaa ilii ki⁄i daqa dooinay, daa khay inay hiĩ kara guiri, sa gimba ilaa koina yaa haciri guꞌudee. Teꞌesii inay digiraati maci idoo da kaawaraa sa ina. ");
INSERT INTO bds_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Teꞌesaa gi kara firoo kay. Qatlay giyaa ilii ki⁄i da tamiige, gi kaay sa inay tuba, “Yeraa, Unkuray hati kahhadaaii haã guꞌudiri, haa hangii fiifisidiri? Diraa, diĩ buꞌudi! Yuꞌudaa, Nanku Heedi dugu hiilu⁄i dabaiĩ gu hida gu tlakwige. ");
INSERT INTO bds_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tlawaw, paaree na waaudani! Yuꞌudaa, hikira guni hiifookida, yaa khoci!” ");
INSERT INTO bds_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Qatlay Yeesu giyaa ilii kahhiye gimbage, Yuuda, leẽ gu sirakoomiisee dosi mibi haa cada, yaagi khay sliimaa haa raqa da hida. Hida hhakee yaa konay pangaaee haa hhadimeerii, digaani ya⁄abi sa oowaraa da Yeesu ha hhapalooee da deni, maarimamaa da sariyaa da diini haa gaduũ gu yaamu. ");
INSERT INTO bds_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Inkoo raqatee, qatlay giyaa ilii kahhade dawaraa teꞌesii, Yuuda gu hiifookida Yeesu yaa hheꞌesi yaa laqami sa hida hhakee kakaana tuba, “Hikee goo humbaꞌade, na ina, lugunoo ooday, lugoo khiidintay, haguroo toogunaa waautay daqa hida gu denige.” ");
INSERT INTO bds_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Qatlay giyaa ilii dayri teꞌesii, Yuuda yaati tafai daqa Yeesuge, gi tosaa kaay tuba, “Ye Maarimuu goy,” gugi tosaa humbaꞌadi. ");
INSERT INTO bds_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Teꞌesii hhawatee hhakee gwaa sliimaa khawee haa ina, gi tooinaa ooyiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Da hheꞌesi heedi waku tla⁄aã gu hida hhakeesaa, gwaa qadimidee ilaciyaa haa Yeesu, yaagi slootisi pangaa gosi looboogo, gi tlatlafi eea da yondimiisay gu hhapalooay gu didiru loi, eeatee gi tosaa kereꞌeti. ");
INSERT INTO bds_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Unkuray saganaani khaydiri hari pangaaee haa hhadimeerii sa oowaraa ana kanimiisay gu sariyaa pahha? ");
INSERT INTO bds_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Balalu hhanki sliimaa ana haa waara haa unkuray yaqay mara gu didiruge gu Iliitleemu, haa caacaahhaahhamisa hida, unkuray hanaa oodiriiba ana. Inkoo, gimbaki goõ hingii laqadi taqay, dama buꞌudi gimba gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Da hheꞌesi, sirakoomiisee dosi goõ gugi mayri ina lenkosi. ");
INSERT INTO bds_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Inkoo teꞌesii yaa wana qaraimoo waku, gwaa sirakomaamida Yeesu alungo, yaa qayru leẽ kilesi ila⁄utli. Qatlay hida hhakee gwaa ilii koisiri oowaraa, ");
INSERT INTO bds_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","qaraimokee gi tosaa lakidi hari slaꞌay, qayru gosi yaati meeti dabaiĩ koinay. ");
INSERT INTO bds_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Da hheꞌesi Yeesu dugugi tosaa leehhisi mara gu hhapalooay gu didiru loige, teꞌesii yaay kurunkuridiri hhapalooee goõ da deni, gaduũ gu yaamu haa maarimamaa da sariyaa da diini, gaduũ gonkoinaa gu balasaa da didiri yaa wanay teꞌesii. ");
INSERT INTO bds_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peetiro see gi sirakoomi Yeesu aslaaꞌamee seesegengo, gii day hari kaꞌafu efeenaa da mara gu hhapalooay gu didiru loige, gi tosaa ibiidi tlahhayge sa micoo gu aslaa sliimaa haa hida hhakee gwaa ga⁄aa⁄awee marakee. ");
INSERT INTO bds_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Inkoo hhapalooetee da deni haa gaduũ goõ gu balasaa da didiri yaa tlaatleesiri dabiidu hida, ma sigi kaay dakoo da Yeesu, ma slayri amoo dari gaasaraa ina. Teesaaqay see, yaa slayriiba ma dakoo lensee daqa dosii. ");
INSERT INTO bds_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hida wa⁄a yaa iliitlohhidiri Yeesu gimba gu afaꞌafuumaa pandaa da gaduũ gu balasaage, giyaamati gimbuusiri teesaaqay, gimba gooina hingaa ila⁄imbidiiba coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Da hheꞌesi hida wakinay see hingaagii ca⁄asiri pandaa da balasateesii. Inay see gi kara iliitlohhidiri Yeesu gimba gu afaꞌafuuma, ");
INSERT INTO bds_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","inay bee, “Dandiray haa akhasani gimba waku daqa dosaa tuba, ‘Maraki gu Iliitleemu daa tleehhi hari dabaiĩ gu hida, ana hagooti ilacata, kara hoo asu tleehha mara gu caduu balalu tami kilesi, hikee dugoo tleehhiyaaba ha hida.’ ” ");
INSERT INTO bds_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kara hhakee see giyaamati afaꞌafuumidiri teesaaqay, gimba gooina hingaa wariiakhasiiba coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Teꞌesii da hheꞌesi hhapalooaykee gu didiru loi gii tlay, gi qadidi pandaa da gaduũ gonge, gi maasi Yeesu tuba, “Ugu ha ilaki⁄isidaabaslii gimbakee, daa ilakesaasidiye ha hida hhanki daqa dooguu?” ");
INSERT INTO bds_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gimati teesaaqay see, Yeesu yaati qabi diĩ, yaa ilaki⁄isiiba gimba lenseei. Teꞌesii hhapalooaykee gu didiru loi gi kara maasi tuba, “Inkoo aare sandi kaade, ugu na Kristu goo, Nanku Iliitleemu doó hhaꞌaleesiye ha hida?” ");
INSERT INTO bds_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu gi ilaki⁄isi tuba, “Ee! Ana na hikee gaã unti ha ugu, kara unkuray hagumaa antayi Nanku Heedi, hiĩ ibiidi hari daba gu ⁄uya gu Iliitleemu gu kooma ⁄uuru goõ. Kara gumaa antayi qatlay gimaa ilii ⁄eetiye hari tlonga yadaa rawaa gu rawgo.” ");
INSERT INTO bds_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Teꞌesii hhapalooaykee gu didiru gi feehhimisi kooti dosi, ma laqami slahhaaꞌamee dosi sa gimbakee gu Yeesu, da hheꞌesi gi tosaa kaay sa gaduũ kosi tuba, “Inkoo ha soꞌoyi kara maasana hida wakinay? ");
INSERT INTO bds_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Unkuray gonkokunaa haã akhasidiri gimbakee kosi gu belendeqesa Iliitleemu, inkoo unkuray bee tuba mala? Aarimida kaawa, inkoo heediki haguti malee laqana?” Gonkoinaa hingigi ila⁄imbidiri, gi kaayri tuba, “Gu lou, heedikee ba⁄ay duguti gaasiye!” ");
INSERT INTO bds_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Da hheꞌesi hida wakinay gugi ilii cubuquniri, gi khiidiniri ilaa kosi hari qayru na may arimaa, gugi puukhiri, gu tooinaa maamisiyay, inay bee, “Aare tletimi, miyaa ningii maahhasi ugu?” Teꞌesaa da hheꞌesi sirikaarii gugii oyiri, inay see gugi tooinaa difiri. ");
INSERT INTO bds_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Qatlaykee sliimaa Peetiro yaa wana yade hhapeege, efeenaa da marakeesii gu hhapalooay gu didiru loige. Inkoo sagameeriya waka yaa wanta teꞌesii, ina naa yondimiisoꞌoo da hhapalooaykee, yaagii catidi hari daqa daa iliiwane Peetiro. ");
INSERT INTO bds_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Qatlay giyaa ilii anti Peetiro mici aslaa, ina gugi iliikaasidi naraꞌa. Da hheꞌesi gi kaadi tuba, “Ugu see haã sliimaa wantaabaslii haa Yeesu, heedikaꞌa gu Nasareeti?” ");
INSERT INTO bds_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Teꞌesii Peetiro gi tlanki gimbakee tuba, “Ana heedikee haguti hhidima, kara haã caahhiiba coko⁄o seei gimbakee ga giimaamiside.” Da hheꞌesi gi tosaa gii sati yade kaꞌafu gurii ca⁄araage, teꞌesii konkaku gi ceei. ");
INSERT INTO bds_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Qatlay sagameeriyatee gwaa ilii anti ina teꞌesii, gi kara kaadi sa hida hhakee gwaa ciyoomoo gosii waaree tuba, “Gu lou, heediki see ti danaꞌa gooina!” ");
INSERT INTO bds_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Teꞌesii Peetiro gi kara tlanki gimbakee. Qariqaaqari hida hhakee see gwaa qadimidee teꞌesii coomoo gosii, gi kaayri sa Peetiro, inay bee, “Hiiye, gu lou, ugu ti danaꞌa gooina, sa gimba ugu see ti heedi gu Galilaaya.” ");
INSERT INTO bds_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Teꞌesii Peetiro hingigi tlaatleesi ilawaamisu, haa gi seelimi pandaa dooinay tuba, “Iliitleemu hini ⁄agitine, bere ana sanguũ kaayiiba gimba gu lou! Yeraa, heedikee ga giimaamisidee, ana haguti hhidima sumuku!” ");
INSERT INTO bds_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Teꞌesii cirakiray lenge konkaku gi ceei ceearaa da cadii. Teꞌesii Peetiro gi cira ilahudeesi, gimbakira sugwaa kaay ha Yeesu tuba, “Qatlay konkaku giyoo ilii kahhiye ceearaa ceeoo cada, ugu hanoo tlankida ana waa tami.” Peetiro giyaa ilii caahhi, idoo giyaa laqi, gi tlaatleesi ⁄aa⁄imu hari slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Qatlay daa iliipisi hari tumpaatumpu, hhapalooee da deni sliimaa haa gaduũ gu Yahuudi haa maarimamaa da sariyaa da diini, hida hhakee goõ gu balasaa da didiri, gonkoinaa hingaa ila⁄imbidiri, Yeesu idoo gu laqiyeei. Da hheꞌesi gi ilafahhiri sirikaarii dooina, ma khiidiniri Yeesu dabainge, gugi tooinaa leehhisiri daqa Pilaatuge. ");
INSERT INTO bds_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Teesaaqay, Pilaatu gi maasi ina tuba, “Ugu na inaa mutemi gu Wayahuudi?” Yeesu gi ilaki⁄isi ina tuba, “Ugu niĩ teesaaqay kaadi!” ");
INSERT INTO bds_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Teꞌesii hhapalooee da deni gi tlaatleesidi iliitlohhidu Yeesu hari gimba wa⁄a gu tlaku. ");
INSERT INTO bds_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Da hheꞌesi Pilaatu gi kara maasi Yeesu tuba, “Inkoo ugu ha ilaki⁄isidaabaslii gimba lensee? Akhasi bere hida hhanki, idoo gi ilii gimaamisiyee gimba wa⁄a gu tlaku daqa dooguu!” ");
INSERT INTO bds_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Gimati teesaaqay see, Yeesu yaati qabi diĩ, yaa ilaki⁄isiiba gimba lensee, Pilaatu yaati bakai sa qabaratee da Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Inkoo, yaa wana ou waku baloo da losona gu Pasaakailee. Koraraa sliimaa baloteesii mutemi yoóyii ca⁄asi heedi leẽ jeerago, heedi daa slaiyee ha hida. ");
INSERT INTO bds_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Inkoo, qatlaykee yaa wana heedi waku yade jeerage, uma gosi naa Baraaba, daa khiidimi sliimaa haa hida wakinay, inay gonkoinaa yaa cu⁄iri hida qatlay giyaa ilii qwaqwatliitlinee haa sirikaarii da mutemi. ");
INSERT INTO bds_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Da hheꞌesi, qatlay Pilaatu giyaa ilii itatiitimisiye balasatee da Yeesu, teꞌesii raqa da didiri da hida yaagi khaydi yadaa yaamugo, gi tlaatleesiri firoo, ma sigaa hiica⁄asi heedi leẽ jeerago, idoo giyaa ilii lalaalaqiyee gooay qatlay gu losonailee. ");
INSERT INTO bds_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Teꞌesii Pilaatu gi maasi hida hhakee tuba, “Naraꞌa, inkoo unkuray slaꞌadaaii sangu afiiooyimi mutemi gu Wayahuudi?” ");
INSERT INTO bds_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yaa teesaaqay kaay, sa gimba ina yaa caahhi tuba, hhapalooetee da deni guranti khayri Yeesu daqa dosii, sa tloomu gu giyaadimiisee da Yahuudi, sa gimba Yeesu dugwaa slai ha hida wa⁄a. ");
INSERT INTO bds_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Teꞌesii hhapalooetee da deni gii faafahhiri raqatee da hida, ma kaayri sa Pilaatu, naa hiica⁄asi Baraaba jeerago, Yeesu na meeti khiidimooge. ");
INSERT INTO bds_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Da hheꞌesi Pilaatu gi kara maasi inay tuba, “Bere Baraaba hagooyi ca⁄asa jeerago, hari heediki goó eteedintee tuba, mutemi gu Wayahuudi, inkoo ana haguti malee laqa?” ");
INSERT INTO bds_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hida goõ gi tooinaa maahhiri tuba, “Heedikee dugutii tluhhumisiye musalaabage!” ");
INSERT INTO bds_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatu gi kara maasi tuba, “Yeraa, ha soꞌoyi teesaaqay giimaamisiday? Na idoo mala dati tlakwideei heediki giyaa dakusi?” Inay gi ilakoniri maahhoo hari ⁄uuru, kakaanay tuba, “Dugwii tluhhumisiye musalaabage!” ");
INSERT INTO bds_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Teꞌesii Pilaatu gi tosaa hiica⁄asi Baraaba jeerago, sa gimba ina yaa slai muunaboo⁄eesa raqatee da hida. Da hheꞌesi gi ilafahhi sirikaarii dosi, ma difiri Yeesu hari jeleedimaiĩ, gugi taatahhiri dabaiĩ koinay, magu hiitluhhumisiri musalaabage. ");
INSERT INTO bds_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Teꞌesii sirikaaritee gi leehhisiri Yeesu waꞌay gu efeenaa da mara gu mutemige, daa Praytooriyo eteediidine, gi tooinaa eteediri deneꞌee koina goõ gu raqa dooina. ");
INSERT INTO bds_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Da hheꞌesi sugugi daasiri qayru ubee, qayru gu mutemi pahha, kalay gosi gu daahhiya, gi asu boo⁄imisiri hhamaa gu leqeewaa, sugu tooinaa daasiri saga gosii. ");
INSERT INTO bds_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Teꞌesii gugi tlaatleesiri cehheemisu ubee, heedikaꞌa pahha giyoó gwaa⁄iyee, hari tay gu tooinaa belendeqemisiyay, inay bee, “Ye mutemi gu Wayahuudi, hagu hhouu!” ");
INSERT INTO bds_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Qatlay giyaa ilii cehheemisiri teesaaqay, gugi ilakoniri difoo hari hhadoo sagage, hari tay gu tooinaa ilii cubuqunay, gi keebeeimidiri pandaa dosii hari yaqaayee. ");
INSERT INTO bds_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Qatlay gwaa ilii hheꞌesiri belendeqemisu, gugi afabaciri jurungitira da daa⁄adi, sugugi daamisiri kara qayroo kosi. Da hheꞌesi gugi leehhisiri, magu hiitluhhumisu kayri musalaabage. ");
INSERT INTO bds_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Qatlay giyaa ilii khociicinee, yade amooge hingaa slaslayri haa heedi waku, uma gosi na Simooni gu yaamu gu Kireene, umaiĩ gu yaꞌay kosi gu hhawatee naa Alekisanda haa Rufoosi. Qatlaykee Simooni yaati asu Yerusaleemu kakaakay qaymamuugo. Da hheꞌesi sirikaaritee gugi ooyiri, gugi ⁄uureesiri, ma geregedi musalaaba daa geregedi ha Yeesu, ");
INSERT INTO bds_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","gi tooinaa leehhisiri Yeesu daqa wakay, uma gu daqatee naa Goligoota, maꞌaana da umakee na “Faraa da saga gu heedi.” ");
INSERT INTO bds_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Qatlay giyaa ilii dayri yade, sugugi hadisiri difaay daayii roogi haa umaasay waku, uma gosi na manemaane, ma kitahhi sarii ca⁄asaraa da slahhaaꞌamee slaqwago, ina giyaati siꞌi kitahhu umaasaykee. ");
INSERT INTO bds_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Teꞌesii gugii tluhhumisiri musalaabage. Da hheꞌesi hingigi deehhiniri qayroo kosi, hari amoo darii slakharaa kuura, ma ariniri hingi malee deehhinay qayroo hhakee. ");
INSERT INTO bds_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Qatlay Yeesu dugwaa ilii tluhhumisi musalaabage, yaa qatlay gu ceenee⁄imoo, tleemaa yaa kahhada mahhaaꞌa. ");
INSERT INTO bds_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rawaa gu saga gosii daa hiitluhhusi bangasiya daa kooma handikaa da deni tuba, “MUTEMI GU WAYAHUUDI.” Yaa teesaaqay laqiri, hida ma caahhiri tuba, Yeesu suguũ soꞌoyi gaasiri. ");
INSERT INTO bds_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Teꞌesii sliimaa haa ina fiisiisee cada daa ca⁄atinti digaa hiitluhhumisi musalaabaaee koinay, leẽ hari bara dosi da ⁄uya, kara gu caduu hari bara dosi da basa. ");
INSERT INTO bds_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hida gwaa hiicacaacatee hari teꞌesa, gwaa wahaahaniri ina, haa yaa naqudimisiri sagaiĩ koina, tay tooinaa kakaanay tuba, “Ugu gu ilacata mara gu didiru gu Iliitleemu, haa gugi tleehheda kara hari balalu tami kilesi, ");
INSERT INTO bds_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","aare inkoo hangu ilabuꞌunte ugu lenkoogu! Bere gu lou ugu na Nanku Iliitleemu ⁄eetaayuu musalaabago.” ");
INSERT INTO bds_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kara harima amotee leẽ hhapalooee da deni haa maarimamaa da sariyaa da diini, inay see gugi belendeqemisiri, gi kaayri inay haa inay tuba, “Heediki yaa ilabuꞌuuꞌumi hida wa⁄a, inkoo hingirinti slanqadii ilabuꞌuru ina loi? ");
INSERT INTO bds_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aare inkoo magu arini heediki gungoó hiiduuba tuba, ina na Kristu, Mutemi gu hida gu Israeeli. Yayii ⁄eetiye yadaa musalaabago, ma arini, ma asu ⁄imbani dandi bee, gu lou, ina na mutemi goori.” Hhakira see daa hiitluhhumisi sliimaa haa ina, gugi wahaahaniri harima amotee leẽ. ");
INSERT INTO bds_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Inkoo qatlay letu giyaa ilii daadi tana⁄iyage, hhantee yaagii ca⁄adi, gi ilaslaabidi yaamu goõ, hhantee yaa ilaslaabidi hhapee goõ saa gweleti naqatloo. ");
INSERT INTO bds_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Qatlaykee gu tleemaa da murumundiya, Yeesu yaay ⁄aa⁄isi hari afoo da didiri, gi kaay hari gimba gosi gu Araamaisoo tuba, “Elooyi, Elooyi, lama sabakhitaani.” Maꞌaana dosi, “Iliitleemu goy, Iliitleemu goy, haniĩ soꞌoyi maydi?” ");
INSERT INTO bds_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hida wakinay gwaa qadimidee ilaciyaa ha ina, giyaa ilii akhasiri gimbaki, gi kaayri tuba, “Akhasakunaa, eteediidina Eliyaa, tletimiisaykira gu wakaꞌalee.” ");
INSERT INTO bds_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Teꞌesii heedi waku gii slehheesi, gii oyi dahhamu, gugi khiidimi cina da hhadaage, gigii tulu⁄i waꞌay gu difaay daa mahhaaꞌadige, gigi taatahhi rawaage sa Yeesu, mayii cunqi, heedikee gi tosaa kaay tuba, “Inkoo mawakuna, hagu hhanti ilahufitay, maw na arini, bere Eliyaa yaa khay, magwaa ilabuꞌumi yaqaa musalaabago.” ");
INSERT INTO bds_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Teꞌesii Yeesu gi kara hii⁄aa⁄isi hari afoo da didiri, gi dafidi dandaꞌaaliya, gi tosaa hhami. ");
INSERT INTO bds_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kara nama qatlaykeesii lenge, qayrukira gu didiru daraa kereꞌesi waꞌay gu mara gu didiruge gu Iliitleemu, gii feehhidi bareemoo cada, rawaago biraa naqatloo. ");
INSERT INTO bds_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inkoo sirikaarimokee gu didiru gwaa qadidu teꞌesii pandaa da Yeesuge, qatlay giyaa ilii akhasi ⁄aa⁄imu gosi, kara giyaa ilii arimi Yeesu, idoo giyaa ilii afiimayi, gi kaay tuba, “Gu lou, heediki yaati Nanku Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Kara teꞌesii tigay see yaa wanay wa⁄a, gwaa sliimaa khawee haa Yeesu yadaa hhapee da Galilaayago, Yerusaleemu naqatloo. Inay yaa khuꞌuuꞌunay segengo labaꞌasukee gu Yeesu. Tla⁄aã gooinay yaa wanay Mariyaa Magidaleena, Mariyaa iyoo dooina Yakoobo hiĩ gu coko⁄u haa nankooina Yoose, haa Saloome. Qatlay Yeesu giyaa ilii khookhociicine hhapee da Galilaayage, tigay hhanki gu tami, naa sirakomaamidiyay ina, inay naa qaqaaqayay ⁄agoo haã khooslay sa Yeesu haa sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inkoo letutee, Yeesu giyaa ilii hhami, hatee naa baloo da hida gu Yahuudi da ilakhuukhuꞌumisu gu ⁄agoo, sa gimba heetlaalee dosii yaa baloo da Sabaato. Inkoo letutee qatlay daa ilii day khwayaiĩ, ");
INSERT INTO bds_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","daagi khay heedi waku, uma gosi naa Yoseefu gu tongoo da Arimataaya. Ina yaa gaduwaa gu balasaa da didiri, daa ⁄imbi ha hida, ina see yaa baqaaqamidi khawaraa da Tawaaloo da Iliitleemu. Da hheꞌesi Yoseefu gi hadakay hari ⁄atlimaa daqa Pilaatuge, gi firimi tuuꞌuna da Yeesu, magi qaasa kay. ");
INSERT INTO bds_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Qatlay Pilaatu giyaa ilii akhasi tuba, Yeesu hiĩ hhami, hiraayii tlai. Da hheꞌesi gi eteedi sirikaarimokira gu didiru, magu maasi bere gu lou, Yeesu hiĩ hhami. ");
INSERT INTO bds_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Qatlay Pilaatu sugwaa ilii kaay ha sirikaarimokee kosi tuba, gu lou, hiĩ hhami, gi tosaa kaay sa Yoseefu tuba, “Naraꞌayiiye, taa⁄a ⁄eetisii tuuꞌunatee da Yeesu musalaabago, laga qaasa kayda.” ");
INSERT INTO bds_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Da hheꞌesi Yoseefu gi kiriga kay qayru gu ⁄abaaku sari qaasaraa, yaagii ⁄eetisi tuuꞌunatee da Yeesu musalaabago, gigi khiidimi hari qayrukee, gigi tosaa qaasi ayisa daayii khuri onke. Da hheꞌesi yaagii gwangwaraai tlaa⁄a da didiri loi afa gu ayisateesii, ma ilakhupisi ayisatee. ");
INSERT INTO bds_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyaa Magidaleena haa Mariyaa iyoo da Yoose, yaa ariniri Yeesu daqa dugwaa ilii qaasi. ");
INSERT INTO bds_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Heetlaalee dosii, baloo da Sabaato yaa hiifaakidi. Mariyaa Magidaleena, Saloome haa Mariyaa iyoo da Yakoobo gi tooinaa kiriga kayri du⁄iya daa tafu cuuꞌudi, maroo maakhanay kayri tuuꞌuna da Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kara heetlaalee dosii hari heetlawaa loi, daa iliipisi baloo da Jumaapiiri, qatlay letu giyaa ilii biifiꞌisidi, tigay hhakee gu tami gi hadakayri ayisa daa ilii qaasi Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Teꞌesii hingaa maamisiri inay haa inay tuba, “Inkoo miyaa sandoo gwangwaraai tlaa⁄atira kengage, yaqaa afa gu ayisago?” ");
INSERT INTO bds_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yaa teesaaqay kaayri, sa gimba tlaa⁄atira daa didiri loi. Inkoo, qatlay giyaa ilii dayri ayisage, gi yuꞌudiri taqay, gi aniri, tlaa⁄atira daa afa gu ayisage waara hhaka, dagaã gwangwaraai, kenga gu ayisage wanta. ");
INSERT INTO bds_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tigay hhakee gi tooinaa gii guniri waꞌay gu ayisateesii da maraiyage, teꞌesii waꞌayge yaa aniri qaraimoo, hiĩ ibiidi hari bara da ⁄uya gu maraiyatee, qayru gosi giyaa daasi, gwaa tleedu, gu asu ⁄abaaku poy, tigay hhakee yaa tlaꞌamuumuudiri hari khisla sa gimbakee. ");
INSERT INTO bds_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Teꞌesii qaraimokee gi kaay sa inay tuba, “Hhanti tlaꞌamuumutay! Ana haã caahhi ambee, unkuray Yeesu gu tongoo da Nasareeti haguni damaamitay, hikira daa hiitluhhumisi musalaabage. Inkoo ina hiĩ slafi, hingii ca⁄i ayisago! Yuꞌudaa hhaku, wanaaba tiꞌii. Khocaa arima daqati dugwaa ilii qaasi. ");
INSERT INTO bds_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Inkoo taa⁄amida ki⁄a, la kaawa kayday gimbaki sa sirakoomiisetira tosi haã Peetiro see ubee, ‘Yuꞌudaa, Yeesu sangu giyaadi Galilaayage. Hagoo yade slayday ina, idoo sangwaa ilii kaay gooay ha ina wakaꞌalee.’ ” ");
INSERT INTO bds_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Teꞌesii tigay hhakee yaagii ca⁄iri yadaa waꞌay gu ayisago, gi tooinaa lakidiri teꞌesaa, sa gimba yaa tlaꞌamuumuudiri, yaati amoolaa dakhadakhiri. Gimbakee gwaa kaayriiba sa heedi lensee sa tlaꞌametee giyaa konee.  ");
INSERT INTO bds_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Inkoo qatlay Yeesu giyaa ilii slafi yaagii ca⁄i ayisago, baloo da Jumaapiiri hari tumpaatumpu, Mariyaa Magidaleena, ginaa giyaadi iliica⁄a, hatira giyaa hhoeesi wakaꞌalee, daa kooma gieeri fanqu. ");
INSERT INTO bds_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hadetee gi tosaa waauti, gi kaawa kaydi sa hida hhakira gwaa sliimaa waaree haa ina tuba, “Yeraa! Yeesu yaani slafi, yaanii ca⁄i ayisago!” Inkoo qatlaykee inay yaati ⁄aa⁄ii⁄iminay, tay tooinaa gaiidiyay sa gwaaꞌaraa da Yeesu. ");
INSERT INTO bds_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Qatlay giyaa ilii akhasiri tuba, Yeesu yaani slafi, kara ina guũ arinti, inay yaa ⁄imbiriiba gimbakee coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Qariqaaqari Yeesu gi iliica⁄i sirakoomiisee dosi cada amooge, gwaa qaymamuu gu yaamu gu Yerusaleemu kakaakawee, gi iliica⁄i inay hari kalay waku gu pasla, inay guraa slanqadiri caahharaa. ");
INSERT INTO bds_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Inkoo qatlay giyaa asu ilii caahhiri tuba, hiĩ na Yeesu, gi tooinaa ki⁄iri yade Yerusaleemuge, gi kaawa kayri gimbakee sa sirakoomiisetira waka da Yeesu, teꞌesii deneꞌee hhakee koina yaa kara ⁄imbiriiba gimbakee coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Qariqaaqari, Yeesu ginaa asu iliica⁄i sirakoomiisetira tosi da mibi haa leẽ, qatlay giyaa ilii ⁄agiiginee daqa lenge. Teꞌesii ina gigi ilii maahhi sa ⁄imbaratee tooina daa hhaka, haã sa karahhamuu gu muunaiĩ koina see, sa gimba saa siꞌiri ⁄imbaraa gimbakee sigaa kaay ha hida hhakira, gwaa giyaadee arimaa ina, yaani slafi. ");
INSERT INTO bds_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Da hheꞌesi Yeesu gi kaay sa inay tuba, “Inkoo taa⁄amida hhapapu sliimaa tiꞌii khoorotii, la kakaaru kayday Gimba gu Hhou gu Iliitleemu sa hida goõ. ");
INSERT INTO bds_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hikee gumaa ⁄imba gimbakee, dugugi tosaa hiinunqudisi maꞌayge, ina dugumaa ilabuꞌuna tlakwaroogo. Inkoo hikee gumaa sia Gimbakee gu Hhou, dugumaati ⁄agitina ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gu lou, hhakee gumaa ana ⁄imbee, inay maa laqanay gimba gu denu gu bakaꞌasa hida hari ⁄uuru gu Iliitleemu. Hari uma goy maa hiica⁄amisiyay gieeri gwaa ilii khaabaaꞌamidiyee hida. Kara maa cocoiyay hari gimba waku gu ⁄abu, giyaa hhidinee, giyaa kahhiyee ma akhasaraa see. ");
INSERT INTO bds_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inay maa ooyinay deesasee hari dabaiĩ digima kikihhi see, digimaa ilaqaꞌadiyaaba. Kara gimati kitahhaniri see qada goó gaasa, maa kaka⁄iyaaiiba coko⁄o seei. Inay maa hiiqamidiyay dabaiĩ koina daqa ga⁄iideege, ga⁄iidee maa hiicaaquumidiyay.” ");
INSERT INTO bds_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Qatlay Yeesu Looimoo gu Goõ giyaa ilii hheꞌesi cocoꞌomoo sa sirakoomiisee dosi, da hheꞌesi ina dugurigi tosaa waaudi rawaa gu rawge ha Iliitleemu, gi ibinaa kay hari bara da daba gu ⁄uya gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Da hheꞌesi sirakoomiisetira tosi gi toosaa waauti, gi tlaatleesidi kakaaru Gimba gu Hhou gu Iliitleemu sa hida daqeemoo sliimaa. Kara, ina Yeesu Looimoo gu Goõ gi yondiidi sliimaa haa inay, yaa iliiaꞌaaꞌay sirakoomiisetee tosi. Teꞌesii, ina gi laqaaqami gimba gu denu gu bakaꞌasa hari amoo da Gimba gosi gu Hhou.");
INSERT INTO bds_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ye, hhia gooi, Teyofiilo goó muriidane: Maꞌaana hida wa⁄a hindii dahhasiri handikaa faadoo da gimbakira daay gaasi tla⁄aã goorii ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inay giyaa handikiniri, idoo sandaa ilii catimisi gooay ha hida hhakira gwaa arimee hari ilaa koina yadaa tlaatleesoogo. Kara nama hhakee gwaa kakaakame gimba gu Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Inkoo, ye Teyofiilo, qariqaaqari gaã ilii cangicangimisi naraꞌa gimbakee sliimaa daa yondiidi yadaa tlaatleesoogo, ana haã arimi ti hhoinay handikiru sa ugu, hari amoo da hhoi gimba sliimaa. ");
INSERT INTO bds_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hari amotee, hay dahhasida caahharaa tuba, gimbakira goõ dugwaa caacaahhamisi guti lou. ");
INSERT INTO bds_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Qatlay Heroode gu didiru giyaa ilii mutemi gu hhapee da Yudaaya, daa wana hhapalooay waku, uma gosi naa Sakariyaa. Ina yaati raqa da hhapalooee da afamaraa waku dahhi, uma gosi naa Abiiya. Sakariyaa hadee dosi naa Elisabeeti, yaa afamaraa gu Haruuni dahhada. ");
INSERT INTO bds_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariyaa haa Elisabeeti yaati hida gwaa koomee ibinaa daa tafaꞌadi pandaa da Iliitleemuge. Inay yaa ilakoniri oowaraa ilakaawa haa ya⁄aboo goõ da Taataa Iliitleemu ilawaasa see hhaka. ");
INSERT INTO bds_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Slime inay yaa konaaiiba yaꞌay, sa gimba Elisabeeti yaa mogombiisoꞌoo, kara inay, cada koinaa yaa gaduũ hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Letu waka, Sakariyaa yaa yondimaamidi yondu gosi gu hhapalooaisoo pandaa da Iliitleemuge. Maꞌaana raqa dosi yaati baloo dooina da yondu mara gu didiruge. ");
INSERT INTO bds_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kara, idoo da iliiwane gooay ou gu hhapalooee, Sakariyaa dugwaay leehhi hari kuura ha hhapalooee wakinay, may day mara gu didiruge gu Taataa Iliitleemu sa ilaeehhisa ubaanii. ");
INSERT INTO bds_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Qatlay ubaanii dugwaa ilii ilaeehhiihhimisiye, hida wa⁄a yaay kurunkuridiri khoorooge, tay yaati firiirinay Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Teꞌesii malayika gu Taataa Iliitleemu yaagi ilii khay Sakariyaa. Malayikakee yaati qadidi hari bara da ⁄uya da masabaahu, da iliieehhimisuu ubaanii. ");
INSERT INTO bds_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Qatlay Sakariyaa giyaa ilii arimi malayikakee, hirigii tlai haa gi tlaꞌamuudi hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Inkoo, malayikakee gi kaay tuba, “Ye, Sakariyaa, hhanti tlaꞌamuta! Iliitleemu hiĩ akhasi firoo doogu. Kara hadee doogu Elisabeeti sugu hiidaada naw, uma gosi lugurimaa ayida na Yohaana. ");
INSERT INTO bds_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ugu hhaꞌaluta haa iiriꞌimisida hari khisla sa nakee. Kara hida wa⁄a hhaꞌaluumidiyay, sa gimba gu hiidawaraa dosi. ");
INSERT INTO bds_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Maꞌaana ina heedi gu didiru tleehhidi pandaa da Taataa Iliitleemuge. Nakee hhanti kitahhana difaay, ma kitahhu lensee goó ooniidisa. Ina dugumaati hacisi Muuna gu Iliitleemu yadaa guraꞌa gu iyoo dosaa. ");
INSERT INTO bds_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ina maay dafidi hida wa⁄a gu Israeeli, maa hiifookidiri tlakwaroo dooinaa daqa Taataa Iliitleemuge, Iliitleemu gooina. ");
INSERT INTO bds_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kara, ina maa giyaadi pandaa da Looimoo gu Gonge, sugumaa qay hiidahhasa ha Muuna gu Iliitleemu, tletimiisay Eliyaa pahha. Maay ki⁄isi muunaiĩ gu ayiĩ, gi daqa yaꞌay koinay khuiyay. Slime, hida hhakaꞌa gooba itatiimisu Iliitleemu, gimaa ⁄isina ma akhamisiri gimba gu waaway gu hida hhakaꞌa gu koomee ibinaa daa tafaꞌadi pandaa da Iliitleemuge. Ina teesaaqay laqi, hida digima haraa ilakhuukhuꞌusi sa khawaraa da Looimoo gu Goõ.” ");
INSERT INTO bds_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Da hheꞌesi Sakariyaa gi kaay sa malayika tuba, “Ha malee caahha gimbaki guti louu? Maꞌaana ana haa hadee doyi ti gaduũ hari khisla.” ");
INSERT INTO bds_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malayikakee gugi ilaki⁄isi tuba, “Ana na Gaburiyeeli, malayika gu Iliitleemu, goó qadimida pandaa dosii. Ana dinanti ya⁄abi daqa dooguu, ma sugu kaay gimbaki gu hhou. ");
INSERT INTO bds_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yuꞌudiyaa! Sa gimba haa ⁄imbidiiba gimba gooi, hay dahhasidaaba cocoꞌomoo, balotaꞌa naqatloo damaa ilii laqwaliye nakee. Kara gimbakee dugutii gaasi ha Iliitleemu, qatlay gosi giyoo ilii buꞌudiye!” ");
INSERT INTO bds_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Qatlaykee, hida hhakira gwaati baqaaqamidiyayi Sakariyaa, ina maay ca⁄i khoorooge mara gu didirugo gu Iliitleemu. Inay yaati bakairi sa hiikaaꞌa dosi qoomay gu tleedu waꞌayge. ");
INSERT INTO bds_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Asunkuilee, qatlay giyaa ilii ca⁄i khoorooge, yaay dahhasiiba cocoꞌomoo haa inay. Cirakiray inay gi baraslayiri tuba, yaa slay tletiruu daqa Iliitleemugo teꞌesii mara gosii gu didiruge. Sa gimba yaa cocaacoiyaaba, gi tlaatleesi waratlaymisu daba gosi, ma koisi laqaruu idoo daanii ca⁄adi. Ina gi ilakoomi afana⁄ada. ");
INSERT INTO bds_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Qatlay Sakariyaa balalu kosi giyaa ilii buꞌudiri gu yondu mara gu didiruge, teꞌesaa gi tosaa ki⁄i aya gosii yaamu gu Yerusaleemugo. ");
INSERT INTO bds_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Qoomay coko⁄o gimbaki giyaa ilii cati, Elisabeeti hadee dosi gii loaydi, gi ibiti waꞌay gu marage slehheeri kooani. ");
INSERT INTO bds_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ina gi kaadi tuba, “Taataa Iliitleemu, sinaa taqay yondiidi! Balalu hhankii, siniĩ laqami hiileehha haa sini kwahhi ilamuree doyi pandaa da hidago.” ");
INSERT INTO bds_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeeti hubaykee kosi, qatlay giyaa ilii dayri slehheeri lahhoꞌo, Iliitleemu yaa ya⁄abi malayika Gaburiyeeli tongoo da Nasareetige da hhapee da Galilaayage waara. ");
INSERT INTO bds_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ina gi hadakay daqa sagameeriya wakay, daa kahha kikitoꞌoo, daa eteediidine na Mariyaa. Ina dagaa hheꞌesi dagaay daamisi ha heedi waku, daa eteediidine na Yoseefu gu afamaraa gu mutemi Dawdi. ");
INSERT INTO bds_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malayika Gaburiyeeli giyaa ilii day daqa Mariyaage gi kaay tuba, “Slay cehheemisu, igi haa slaydi hhoinay gu didiru hari khisla! Looimoo gu Goõ sliimaa wana haa igi!” ");
INSERT INTO bds_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Qatlay Mariyaa giyaa ilii akhasidi gimbaki gu malayikakee, gi tlaꞌamuti hari khisla. Ina gi tlaatleesidi ilahudeemisu muuna gosii tuba, maꞌaana da cehheemisuki na mala? ");
INSERT INTO bds_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Teꞌesii malayikakee sagagi kaay ina tuba, “Mariyaa, hhanti tlaꞌamuta! Maꞌaana igi haã slaydi hhoinay gu didiru daqa Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Itatiisi! Inkoo, igi hay loayda haa hay daada naw, haa haguri ayida uma na Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naki, heedi gu didiru tleehhidi haa duguti eteedina ha hida na Nanku Iliitleemu gu Rawaa gu Idadu Sliimaage Waara. Kara Taataa Iliitleemu sugu hadisi ina kitiĩ gu tawaaloo gu mutemi Dawdi, kookoo gosi. ");
INSERT INTO bds_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ina tawaalina kabiraa da Yakoobo koraraa haa koraraa goóba hiifaakoo. Kara Tawaaloo dosi maa kontaaba hiifaakoo etaa!” ");
INSERT INTO bds_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Da hheꞌesi Mariyaa gi maasidi malayikakee tuba, “Ana malee slaw daa⁄u, maꞌaana kahha kikitoꞌoo?” ");
INSERT INTO bds_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malayikakee gi ilaki⁄isi ina tuba, “Igi digaa ilii khayi ha Muuna gu Iliitleemu, haa hiidahhasa da Iliitleemu gu Rawaa gu Idadu Sliimaage Waara, yondita waꞌay kokii. Inkoo, nakee duguti tlintiꞌisi daqa Iliitleemuge haa duguti eteedi, Nanku Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yuꞌudiyaa, Elisabeeti, hiidayuumitoꞌoo doogi, slime konta hubay gu slehheeri lahhoꞌo. Ina daa eteediidine ha hida mogombiisoꞌoo, hiidaada naw gimati gaduwaa see, ");
INSERT INTO bds_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","sa gimba daqa Iliitleemuge hhaka idoo daroó slanqadiye.” ");
INSERT INTO bds_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Da hheꞌesi Mariyaa gi kaadi tuba, “Yuꞌudiyaa, ana ti tongitoꞌoo da Looimoo gu Goõ. Gimbaki hiica⁄iye daqa dooii teesaaqay, idoo gaã ilii kaadi gooay.” Malayikakee gi waaudi. ");
INSERT INTO bds_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nama balalu hhakeesii, Mariyaa gi cira hhiyuti, gi hadakaydi yaamu wakinay naqatloo hhapee da Yudaayage, daa kooma omeeri. ");
INSERT INTO bds_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ina giyaa ilii daadi taysi, gii daadi mara gu Sakariyaage haa gi cehheemisidi Elisabeeti. ");
INSERT INTO bds_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cirakiray qatlay Elisabeeti giyaa ilii akhasidi cehheemisu gu Mariyaa, naw gi tlo⁄osi waꞌay gu guraꞌa gosii. Nama teꞌesii leẽ Elisabeeti dagagi hacisi Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabeeti gi maahhadi hari ⁄uuru, gi kaadi sa Mariyaa tuba, “Igi, digiĩ ⁄aafi ha Iliitleemu ba⁄ay da tigay goõ! Slime nakee gu guraꞌa googii waara, ina see duguũ ⁄aafi. ");
INSERT INTO bds_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ana na miyaa dinigi muriidi taqay, iyoo da Looimoo gooi see yaani khaydi daqa dooii sa cehheemisuu? ");
INSERT INTO bds_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yuꞌudiyaa, cirakiray gaã ilii akhasi afoo da cehheemisu googi, teꞌesii naw gu guraꞌa gooii waara, hinti tlo⁄osi hari hhaꞌaloo. ");
INSERT INTO bds_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Igi digiĩ ⁄aafi! Sa gimba haã iliipaꞌanti tuba, Iliitleemu gimba giyaay fadidi sa igi gimaay gaasi!” ");
INSERT INTO bds_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Inkoo, Mariyaa gi kaadi tuba, “Muuna gooi, daareeremisi Taataa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kara, muuna gooi hinti hhaꞌaluudi sa gimba gu Iliitleemu, Ilabuꞌumiisay goy! ");
INSERT INTO bds_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Maꞌaana yaani yuꞌudi, murumuꞌuuma da tongitoꞌoo dosi. Kara, tlaatleesoo da inkoogo, laqwaloo goõ hiniti eteedinay ana na daa ⁄aafi. ");
INSERT INTO bds_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa gimba Iliitleemu gu kooma ⁄uuru, siniĩ yondiidi gimba gu didiru gu bakaꞌasa, uma gosi kilesi dugunaa tlintiꞌisi! ");
INSERT INTO bds_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kara, ⁄awaariru gosi yoó ilakona laqwaloo haa laqwaloo, daqa hhakeesii goó gwaa⁄ee ina. ");
INSERT INTO bds_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hiĩ yondiidi gimba gu didiru hari ⁄uuru gosi, hiĩ pasidisi hida gungoó hiiduubee muunaiĩ koinay. ");
INSERT INTO bds_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ina hinii ⁄eetisi hida gu deni kiteeri koinaa gu tawaaloogo, haa gii tlaysi hida hhakaꞌa gwaa murumuꞌuumidee. ");
INSERT INTO bds_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hida gu koomee qori giyaa ⁄agimisi ⁄agoo da hhoi. Kara hindaqeeri giyaati gusimi, dabainge konaaiiba idoo lensee. ");
INSERT INTO bds_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hiĩ iliiay yondimiisay gosi Israeeli, tay giislay ⁄awaariru gosi, ");
INSERT INTO bds_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","idoo giyaa ilii fadidi gooay sa ayiĩ koti, Aburahaamu haa laqwaloo dosi koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyaa yaa ibiti haa Elisabeeti slehheeri tami taqaaqay. Da hheꞌesi gi ki⁄idi aya gosii. ");
INSERT INTO bds_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Qatlay balalu kosi Elisabeeti gu hiidawaraa giyaa ilii buꞌudiri, gii daadi naw. ");
INSERT INTO bds_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hida gwaa ibimaamidee ilaciyaa kosi haa hiidayuuma dosi gi akhasiri, idoo Looimoo gu Goõ giyaa ilii laqami ⁄awaariru gu didiru sa Elisabeeti. Inay gi hhaꞌaluumidiri sliimaa haa ina. ");
INSERT INTO bds_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nakee, baloo dosi da gweleti giyaa ilii buꞌuti, hida yaagi khayri mara gu Sakariyaage, gugi daba⁄iri. Teꞌesii inay gi slairi maguri ayiri nakee uma gu taataa gosi Sakariyaa. ");
INSERT INTO bds_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Iyoo dosi gi kaadi tuba, “Teesaaqay gooba! Kwanda duguri aye uma na Yohaana.” ");
INSERT INTO bds_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Inay gigi ilaki⁄isiri tuba, “Asu, heedi lensee ma hhaku hiidayuuma doogii gu kooma umakee?” ");
INSERT INTO bds_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Da hheꞌesi gi laqaniri hari dabaiĩ koina sa Sakariyaa, taataa gu nakee, ma caahhiri ina uma kaloo girinaa slai awaraa nankosi. ");
INSERT INTO bds_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ina gi firimi bangasiya da coko⁄i da ilii handikaa, gi handikimi rawaa kosii tuba, “Uma gosi na Yohaana.” Hida sliimaa yaati bakairi. ");
INSERT INTO bds_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nama teꞌesii lenge, Sakariyaa kara gi tlaatleesi cocoꞌomoo, tay tosaa daareemisi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hida goõ gwaa ibimaamidee ilaciyaa koinay, digigi iliihaci ha gwaa⁄amee da Iliitleemu! Gimbakee gii qoomi daqeemoo sliimaa gu omeeri gu hhapee da Yudaaya. ");
INSERT INTO bds_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hida sliimaa gwaa akhasee gimbaki, gi ilakoniri ilahudeemisu muunaiĩ koinay, kakaanay tuba, “Yuꞌudiyaa nakee, maa heedi mala tleehhidi?” Gu lou, ⁄uuru gu Looimoo gu Goõ yaa sliimaa wana haa ina. ");
INSERT INTO bds_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakariyaa, taataa gu nakee dugugi hacisi Muuna gu Iliitleemu, gi tletimi tuba, ");
INSERT INTO bds_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Looimoo gu Goõ, Iliitleemu gu Israeeli, dugu daareesiye, Sa gimba hindaani ilii khay hida kosi, haa hindi afiigweedi dandiray tongaiimaago. ");
INSERT INTO bds_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ina sindii qadidisi dandiray Ilabuꞌumiisay gu kooma ⁄uuru, hiĩ gwaa afamaraa gu Dawdi dahha yondimiisay gosi, ");
INSERT INTO bds_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","idoo giyaa ilii kaay gooay wakaꞌalee hari amoo da tletimiisee dosi daa tlintiꞌisi. ");
INSERT INTO bds_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ina yaa teesaaqay laqi, ma hindi ilabuꞌumi dabaiĩ gu fa⁄ayaa dooraa haa daqa dabaiĩ gu hida sliimaa hindi wakee. ");
INSERT INTO bds_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Slime yaa teesaaqay yondiidi, ma laqami ⁄awaariru gu didiru daqa okookoiĩ kotii, haa hoóyi slaw ila⁄imbidu gosi giyaa tlintiꞌisi daqa dooinay. ");
INSERT INTO bds_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Maꞌaana hiĩ na gimba giyaa hiifadidi, daqa Aburahaamuge kookoo goori tuba, ");
INSERT INTO bds_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","hindi ilabuꞌuna dabaiĩ gu fa⁄ayaa dooraa, ma sugu yondiidani ina, tlaꞌamee see hhaka, ");
INSERT INTO bds_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","hari ibinaa, ibinaa daa tafaꞌadi pandaa dosi, daa tlintiꞌisi daqa Iliitleemuge, balalu koti sliimaa gu ibidinaa doori.” ");
INSERT INTO bds_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Da hheꞌesi Sakariyaa gi kaay daqa nankosii tuba, “Ugu nankoy, hida gumaati eteedinay tuba, na tletimiisay gu Iliitleemu gu Rawaa gu Idadu Sliimaage Waara. Inay maa teesaaqay laqiyay, sa gimba ugu ha giyata pandaa da Looimoo gu Gonge, ma haraa boo⁄imisidi amamu kosi sa khaymuu gosi. ");
INSERT INTO bds_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Slime ma kakaaru kaydi sa hida gu Iliitleemu, idoo digi ilii ilabuꞌune hari amoo da ilamooyiru tlakwaroo dooina. ");
INSERT INTO bds_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iliitleemu goori sandaa ⁄awaarimi hari khisla, hari amotee, cencee dosi doó raw dahha, hindaa ilii khayda. ");
INSERT INTO bds_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cencetee may wanqasidi daqa hida hhakaꞌay goõ, goó ibiidee hhanteege haa mahhatu gu gwaaꞌaraage, ma giyaadisi yeꞌeeroo koti amoo da qasawge.” ");
INSERT INTO bds_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohaana, nakee gu Sakariyaa gi diiray haa gi muuna hii⁄atli. Da hheꞌesi gi ibinaa kay yade kongoqomeege, balotaꞌa naqatloo giyaa ilii tlaatleesi kakaaru pandaa da hida gu Israeelige. ");
INSERT INTO bds_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Balalu hhakeesii, mutemi gu didiru Kaysaari Aguusito gu hhapee da Ruumi yaa ilafahhi tuba, hida goõ goó ibiidee hhapapu, doó tawaaline ha sirikariinii da Ruumi, umaiĩ koina digi faadiye. ");
INSERT INTO bds_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Handikiruki gu umaiĩ gu hida gunaa tlaatleesoo, gwaay ca⁄u qatlay Kireniiyo giyaa ilii heedi gu didiru gu hhapee da Siiriya). ");
INSERT INTO bds_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Inkoo, hida sliimaa gi ki⁄iri yaamu koinay digaa ilii laqwali, umaiĩ koina digigi handikiru kay. ");
INSERT INTO bds_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Teesaaqay, sa gimba Yoseefu yaa hiidayuumimoo gu afamaraa gu mutemi Dawdi, slime gi waaudi teꞌesaa tongoo da Nasareetigo da hhapee da Galilaayage waara, yade naqatloo yaamu gu Dawdi doó eteedine na Beteleheemu gu hhapee da Yudaayage waara. ");
INSERT INTO bds_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yoseefu dugugi handikiru kay yade sliimaa haa Mariyaa, giyaay daamisi, slime daa guraꞌa. ");
INSERT INTO bds_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Inkoo Yoseefu haa Mariyaa giyaa ilii Beteleheemuge wanee, Mariyaa baloo dosi day dawaraa gi buꞌuti. ");
INSERT INTO bds_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ina gii daadi naw gu badiisu, gugi ilacuudi hari qayroo, gugi tosaa qaatisidi khooslimoo daa ilii ⁄agiigine yakway. Yaa teesaaqay laqadi, sa gimba daqa yaa wantaaba mara gu dahaage. ");
INSERT INTO bds_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Teꞌesii hhapeteesii da Yudaayage, yaa wanay deꞌemiisee wakinay, gwaa ibimaamidee kweerage hhapeteesii. Inay yaati ga⁄aa⁄ayay raqoo gu kuꞌunaanay gooina hari amasi. ");
INSERT INTO bds_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Inkoo, cirakiray malayika gu Taataa Iliitleemu giyaagi iliica⁄i inay. Teꞌesii, wanqamee da Taataa Iliitleemu gii wanqasidi inay bareemoo sliimaa. Inay gi tlaꞌamuudiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malayika gi kaay sa inay tuba, “Hhanti tlaꞌamutay! Yuꞌudiyaa, ana sanguranti khay gimba gu hhou guraa khawa hhaꞌaloo da didiri daqa hida sliimaage. ");
INSERT INTO bds_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Letuti, Beteleheemuge, yaamu gu Dawdi, Ilabuꞌumiisay dugungii day sa unkuray, ina na Kristu, Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kara daqa doogunay laqaru gu maꞌasa gimbaki na nahiĩ tuba, Beteleheemuge hagoo slayday naw duguũ ilacuuy hari qayroo haa duguũ qaatisi khooslimoo doó ilii ⁄agine yakway.” ");
INSERT INTO bds_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Cirakiray, raqa da didiri da malayika yaagii ca⁄adi rawgo, hingigi ilagaasidi haa malayikakee. Inay gonkoinaa gi tlaatleesiri daareesa Iliitleemu, kakaanay tuba, ");
INSERT INTO bds_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Iliitleemu dugu daareesiye rawaa gu rawge! Kara khoorooge qasaw wane, daqa hida hhakaꞌay saa laqami ha Iliitleemu hhoinay gosi gu didiru.” ");
INSERT INTO bds_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Qariqaaqari malayikatee giyaa ilii ki⁄idi rawaa gu rawge, deꞌemiisetira hingigi wariikaayri inay haa inay tuba, “Paaree Beteleheemuge, ma arimaa kayni gimbaki gunii ca⁄u, sandii kaay ha Looimoo gu Goõ hari amoo da malayika.” ");
INSERT INTO bds_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Teesaaqay, inay gi cira hadakayri Beteleheemuge. Qatlay giyaa ilii dayri, yade gi slayri Yoseefu haa Mariyaa, haa gi aniri nakira duguũ qaatisi khooslimoo doó ilii ⁄agine yakway. ");
INSERT INTO bds_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Qatlay deꞌemiisetee giyaa ilii aniri nakee, gi ilakeesiri sa hida goõ gwaa teꞌesii waaree, gimba gu nakee sigaani kaay ha malayika. ");
INSERT INTO bds_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hida goõ gwaa akhasee gimbakee, daa ilakeesi ha deꞌemiisee gi bakaakairi hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Inkoo, Mariyaa giyaati qaasidi muuna gosii, gimbakee goõ giyaati nikinkinta ilahudeemisu muuna gosii. ");
INSERT INTO bds_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Deꞌemiisetira gi ki⁄idi daqa kuꞌunaanay gooinay, tay tooinaa daareemisiyay haa hhaꞌaleemisiyay Iliitleemu hari khisla, sa gimbakee sliimaa giyaa akhasiri haa giyaa aniri. Gu lou, idoo sigaa ilii kaay gooay, yaa teesaaqay hiica⁄i. ");
INSERT INTO bds_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Qatlay nakee, giyaa ilii buꞌudisi balalu gweleti gu daba⁄u gosi, gugi daba⁄iri. Teꞌesii inay gurigi ayiri uma na Yeesu. Hiĩ na uma Mariyaa sagaa kaay ha malayika, maguri ayidi, ina giyaa ilii kahhade hiiloawaraa. ");
INSERT INTO bds_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Da hheꞌesi, balalu gi buꞌudiri gu ilabuusla da Yoseefu haa Mariyaa, idoo da iliiwane gooay sariyaa da Iliitleemu daa handikimi ha Musaa. Inay gugi leehhisiri nakee Yerusaleemuge, mara gu didiruge gu Iliitleemu, magu tlintiꞌisiri sa Taataa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inay yaati yondiidiri, idoo daa ilii handikimi gooay sariyaa da Taataa Iliitleemu tuba, “Yaꞌay sliimaa gu hhawatee gu badiisasaa digi tlintiꞌisiye sa Taataa Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Slime inay hadisiyee sadaaka, idoo daa ilii handikimi gooay sariyaa da Taataa Iliitleemu tuba, hadisiyee “kunde cada baku haaoo cada da tlaba.” ");
INSERT INTO bds_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yuꞌudiyaa, Yerusaleemuge yaa wana heedi waku, uma gosi naa Simi⁄ooni gwaa kooma ibinaa daa tafaꞌadi haa gwaa gwagwa⁄aa⁄ama Iliitleemu. Ina yaa kona kwayru gu didiru gu arimaa afiigweedaraa da hida gu Israeeli. Kara, Muuna gu Iliitleemu yaa sliimaa wana haa ina. ");
INSERT INTO bds_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Muuna gu Iliitleemu yaay tlaaꞌasi sa ina tuba, gwaaiyaaba, gi ilii kahhiye arimaa Kristu gu Taataa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yoseefu haa Mariyaa guraa ilii khayri Yeesu waꞌay gu mara gu didiruge gu Iliitleemu, ma sugu yondiidiri, idoo daa iliislaiye gooay uo gu sariyaa. Letutee Simi⁄ooni gugi slayri teꞌesii, duguraani giyaadi ha Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simi⁄ooni gugi geregedi Yeesu dabaiĩ kosii, tay tosaa daareemisi Iliitleemu, kakaana tuba, ");
INSERT INTO bds_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ye, Looimoo goori gu kooma ⁄uuru goõ, idoo gaa ilii faditi gooay, inkoo, aareesi yondimiisay googu, ma gwaai hari qasaw, ");
INSERT INTO bds_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sa gimba, gu lou haã arimi hari ilaa koi, ilabuꞌuru googu. ");
INSERT INTO bds_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ilabuꞌuriki gaa ilakhuukhuꞌusidi, pandaa da hida sliimaage, ");
INSERT INTO bds_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yoóti cencee tleehhidi, daay tlaaꞌasa amamu koku gu lou, daqa hida gu hhapapu wakinayge. Kara, ilabuꞌurukee haraati khay wanqamee daqa hida kokuu gu Israeeli.” ");
INSERT INTO bds_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taataa haa iyoo da Yeesu yaati bakairi gimbakeege gu Yeesu, daa kaay ha Simi⁄ooni. ");
INSERT INTO bds_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Da hheꞌesi Simi⁄ooni gigi ⁄aafi inay, gi kaay daqa Mariyaage tuba, “Yuꞌudiyaa! Sa gimba gu Nakee hida wa⁄a gu Israeeli, maa huuiyay, kara wakinay maay tlayay. Ina laqaru gu kaaru tleehhidi, slime hida gu tlankiyay. ");
INSERT INTO bds_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Teesaaqay, ina hiitlaaꞌasi ilahudaa gu muunaiĩ gu hida wa⁄a. Kara igi muuna googi dugumaa ilaqai hari khisla, dugunti muti pahha hari pangaa!” ");
INSERT INTO bds_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Teꞌesii, slime daa wana tletimiisoꞌoo daa gaduti hari khisla, uma gosi naa Aana, hotu heedi waku uma gosi naa Fanuweeli gu motoliya da Aseeri. Qatlay dagaa ilii khabimi, yaa ibiti haa hhawata gosi koraraa fanqu, hhamaraa dosi naqatloo. ");
INSERT INTO bds_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Teesaaqay yaati meti mogombitoꞌoo, qatlaykee naqatloo giyaa ilii konte koraraa mibeeri gweleti haa cigahha. Ina yaa waautiiba etaa mara gu didirugo gu Iliitleemu. Amasi haa tleemaa yaati yondimaamita sa Iliitleemu, hari amoo da firoo haa mawaraa ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Qatlaykeesii lenge, Aana yaagi khaydi daqa dooinay marakeesii gu didiruge. Ina gi tlaatleesidi daareemisu Iliitleemu sa nakee, Yeesu. Ina gi cocoꞌodi gimba gu nakee daqa hida, gwaa iliipaꞌaaꞌamee tuba, Iliitleemu afiigweedi hida gu Israeeli. ");
INSERT INTO bds_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoseefu haa Mariyaa giyaa ilii hheꞌesiri gimba sliimaa, idoo daa ilii handikimi gooay ha sariyaa da Iliitleemu, inay gi tooinaa ki⁄iri tongoo dooinay Nasareeti da hhapee da Galilaayage waara. ");
INSERT INTO bds_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nakee, Yeesu gi diiray, kara Iliitleemu gi ilakoomi qawaraa ⁄uuru haa waaway wa⁄a. Slime hhoinay gu didiru gu Iliitleemu yaa sliimaa wana haa ina. ");
INSERT INTO bds_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Koraraa sliimaa Yoseefu haa Mariyaa yaati hhiyumaamidiyay Yerusaleemuge qatlay gu losona gu Pasaaka. ");
INSERT INTO bds_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Qatlay Yeesu giyaa ilii kone koraraa mibi haa cada, inay gurigi hadakayri losonakeesii, idoo daa iliiwane gooay ou gooina. ");
INSERT INTO bds_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Qariqaaqari losonakee giyaa ilii faaki, Yoseefu haa Mariyaa yaa tlaatleesiri hhiyuuma dooina da ki⁄araa ayage. Teesaaqay see, Yeesu gi meeti Yerusaleemuge, Yoseefu haa Mariyaa caahha see guba. ");
INSERT INTO bds_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inay yaati ilahudeesiri tuba, yaa wana sliimaa haa inay tla⁄aã gu raqa daa hhiyumaamida haa inay. Letutee inay gi ilakoniri khocu tlupu. Da hheꞌesi gugi tlaatleesiri daabiidu tla⁄aã gu hiidayuuma dooinay haa deneꞌee koinay gwaa sliimaa hhiyumaamidee. ");
INSERT INTO bds_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Qatlay inay gwaa ilii slayriiba ina, cirakiray leẽ gi ki⁄iri Yerusaleemuge, tay gu tooinaa daabiidiyay. ");
INSERT INTO bds_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Baloo da tamiige, Yeesu gugi slayri waꞌay gu mara gu didiruge gu Iliitleemu, hiĩ ibiidi haa maarimamaa da diini da Yahuudi. Teꞌesii giyaati itatiitimisi haa giyaati maamamisi inay, gimba giyaa kakaakaneei. ");
INSERT INTO bds_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hida goõ gwaa akhasee gimba gu Yeesu, yaati bakairi hari khisla, idoo giyaa ilii kone waaway, haa idoo giyaa ilii ilaki⁄ii⁄imisiye naraꞌa maamisu gu maarimamatee. ");
INSERT INTO bds_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Qatlay Yoseefu haa Mariyaa, gwaa ilii aniri ina, yaati bakairi hari khisla. Iyoo dosi gugi maasidi tuba, “Nankoy, ugu sandii soꞌoyi laqadi taqay? Yuꞌudiyaa! Ana haa Taataa googu hati kona tlaꞌamee da didiri, haguti dabimaamidana ugu!” ");
INSERT INTO bds_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yeesu gi ilaki⁄isi inay tuba, “Ayi! Siniĩ soꞌoyi dabimaamitay? Haã caahhadiriibaslii tuba, ana kwanda ga waare mara gu didiruge gu Taataa gooii?” ");
INSERT INTO bds_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yoseefu haa Mariyaa yaa caahhiriiba maꞌaana da gimbakee Yeesu giyaa kaay sa inay. ");
INSERT INTO bds_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Da hheꞌesi gi ki⁄i sliimaa haa inay Nasareeti naqatloo, balalu sliimaa giyaati itatiitimisi inay. Teꞌesii iyoo dosi, gimbakee sliimaa giyaati ilakonti ilahudeemisu muuna gosii. ");
INSERT INTO bds_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesu gi ilakoomi diirawa, tledewa haa waaway gosi gii roogidi. Kara gi slay hhoinay gu didiru pandaa da Iliitleemuge haa pandaa da hidage. ");
INSERT INTO bds_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Inkoo, yaati kori gu mibi haa kooani gu tawaaloo da mutemi Kaysaari Tiberiiyo. Qatlaykee Pontiyo Pilaatu yaa gafana gu hhapee da Yudaaya, haa mutemi Heroode Antipaasi naa tawaaliilina hhapee da Galilaaya. Kara, Filiipo hhia gosi Heroode naa tawaaliilina hhapee da Itureeya haa Tirakoniiti. Slime mutemi Lisaniiya yaati tawaaliilina hhapee da Abileene. ");
INSERT INTO bds_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anaasi haa Kayaafa naa hhapalooee da deni gu hhapee da Israeeli. Qatlaykeesii gimba gu Iliitleemu yaagi ilii khay Yohaana, nanku Sakariyaa yade kongoqomeege. ");
INSERT INTO bds_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ina gi hadakay daqeemoo sliimaa gu hhapee goõ, gwaa ilaciyaa waaree haa duudu gu Yoridaani, tay tosaa kakaana gimba gu hiinunqudimisu gu hiifookida tlakwaroogo daqa Iliitleemuge, ma ilamooyimi tlakwaroo dooina. ");
INSERT INTO bds_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hari amoo da Yohaana, Iliitleemu yaatii gaamaamisi gimbaki gu Isaaya tletimiisay, idoo giyaa ilii handikimi gooay kitaabuu gosii tuba, “Afoo da didiri wanta da heedi kakaakanta kongoqomeege tuba, ‘Tafaꞌasa amoo sa Looimoo gu Goõ, la tafaꞌasiday amamu kosi cuti! ");
INSERT INTO bds_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Daqeemoo gu koomee hiihuuꞌuma, digi tipidiye, kara omeeri haa tioo goõ, taataahhasakina. Amamu gwaay qolongaaga⁄ee, digi tafaꞌamisiye, slime amamu goõ gu koomee bondeeri, digi hacimisiye tipa. ");
INSERT INTO bds_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hida goõ daqeemoo sliimaa arinayi, ilabuꞌuruu gu Iliitleemu.’ ” ");
INSERT INTO bds_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Inkoo, hida wa⁄a yaa khakhaakhayay daqa Yohaanage, magii nunqudimisi inay. Yohaana gi kaay sa inay tuba, “De, laqwaloti da deesasee pahha! Ha miyaa nangwaa ilii⁄oo⁄i, ma hii⁄ipidiri qupidaa gu Iliitleemu, gwaa khocee? ");
INSERT INTO bds_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Inkoo, laqama ⁄aamu gu laqama hiifookida dooguna tlakwaroogo daqa Iliitleemuge. Kara, hhanti tlaatleesiday ilahudeemisu muunaiĩ kokunay tuba, ‘Taataa goori na Aburahaamu!’ Gu lou, sangu kaay Iliitleemu hiidahhasi hiitlaysa yaꞌay sa Aburahaamu daqa tle⁄eẽ hhankaa. ");
INSERT INTO bds_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Inkoo see kiraara dagaã hheꞌesi, daganii qaasi kibeeri gu khaige! Khai sliimaa gooba boo⁄araa ⁄aamu gu hhou, digi tlaaqi haa digii kwakwahhi aslaage!” ");
INSERT INTO bds_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Raqatira da hida gugi maasidi hari murumuꞌuumaa ina tuba, “Inkoo, hati malee laqana?” ");
INSERT INTO bds_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohaana gigi ilaki⁄isi tuba, “Heedi gu kooma qayroo cada, leẽ gi hadisiye sa hikira guba qayru. Kara heedi gu kooma ⁄agoo wa⁄a, teesaaqay laqiye.” ");
INSERT INTO bds_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Karaanimaiĩ goóyii kurunkurimee koodi slime yaagi khayri daqa Yohaanage, ma digii nunqudimisi. Inay gugi maasiri tuba, “Maarimuu, dandiray ti malee laqana?” ");
INSERT INTO bds_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ina gigi ilaki⁄isi inay tuba, “Hhanti hiioyimintayi daqa hidago peesay gwaay catu hikaꞌa dangwaa ilafahhi ha sirikariinii da Ruumi.” ");
INSERT INTO bds_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Slime sirikaarii gugi maasiri ina tuba, “Hari dandiray ti malee laqana?” Yohaana gigi ilaki⁄isi tuba, “Hhanti afii⁄utlida heedi lensee idadu kosi ma sitaakiikiru see hari afaꞌafuumaa! Kara buꞌudisa hari peesay dangoó buiye.” ");
INSERT INTO bds_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hida yaa konay iliipaꞌaru gu khawaraa da Kristu. Sa gimbakee, gonkoinaa hingaa tlaatleesiri ilahudeemisu muunaiĩ koinay tuba, angamalee Yohaana naa Kristu. ");
INSERT INTO bds_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohaana gigi ilaki⁄isi inay tuba, “Gu lou, ana hanguri maꞌay kilesi hiinunqudimisa. Teesaaqay see, himaa khay heedi gu kooma ⁄uuru, koyi see ba⁄i, ana may condoa see haraay boo⁄iiba gweedaraa da dincaaraa da ye⁄eetoo kosi! Ina hiinunqudimisi unkuray hari Muuna gu Iliitleemu haa hari aslaa. ");
INSERT INTO bds_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ina hiĩ ooyi daba gosii kiyaaray gu heeleꞌemisu, hiĩ tlaatleesi ficinay biraa gosi, ma hiikurunkuri ganoo kuugiya dosii da didiri. Teesaaqay see, muuꞌu gumaa da⁄i hari aslaa doóba hhama!” ");
INSERT INTO bds_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nama teesaaqay leẽ, Yohaana yaa ilakoomi tlaatlaqamisu hida, maay fookidiri daqa Iliitleemuge, tay tosaa kakaana Gimba gu Hhou gu Iliitleemu sa inay. ");
INSERT INTO bds_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Inkoo, Yohaana gi ilii⁄oo⁄i mutemi Heroode Antipaasi, sa gimba giyaa khabimi Heroodiiya, hadee da hhia gosi loi, haa sa tlakwaroo waka wa⁄a giyaa yondiidi. ");
INSERT INTO bds_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Teesaaqay Heroode gii roogisi tlakwaroo waka daqa dosii, tay Yohaana gugi ilapingimi jeerage. ");
INSERT INTO bds_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Qatlay hida digaa ilii hheꞌesi hiinunqudimisu ha Yohaana, Yeesu see dugugii nunqudisi. Yeesu giyaa ilii firiirine Iliitleemu, raw yaati tlaaꞌadi. ");
INSERT INTO bds_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Muuna gu Iliitleemu yaagii ⁄eeti rawgo daqa dosii, tlabiya pahha. Kara afoo yaagii ca⁄adi rawaa gu rawgo, kakanta tuba, “Ugu na Nankoy ga slae! Ugu hanoó muunaboo⁄eesida hari khisla!” ");
INSERT INTO bds_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeesu qatlay giyaa ilii tlaatleesi yondu gosi, yaa koraraa mibeeri tami kona taqaaqay. Kara hida yaati ilahudeesiri tuba, ina yaati nanku Yoseefu, laqwaloo da Heeli. ");
INSERT INTO bds_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heeli, yaa nanku Mataati. Mataati, yaa nanku Laawi. Laawi, yaa nanku Meliiki. Meliiki, yaa nanku Yanaay. Yanaay, yaa nanku Yoseefu. ");
INSERT INTO bds_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoseefu, yaa nanku Matatiiya. Matatiiya, yaa nanku Aamoosi. Aamoosi, yaa nanku Nahuumu. Nahuumu, yaa nanku Esiili. Esiili, yaa nanku Nagaay. ");
INSERT INTO bds_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaay, yaa nanku Maati. Maati, yaa nanku Matatiiya. Matatiiya, yaa nanku Semeyiini. Semeyiini, yaa nanku Yoseeki. Yoseeki, yaa nanku Yooda. ");
INSERT INTO bds_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yooda, yaa nanku Yohanaani. Yohanaani, yaa nanku Reesa. Reesa, yaa nanku Serubabeeli. Serubabeeli ya nanku Seyalitiyeeli Seyalitiyeeli, yaa nanku Neeri. ");
INSERT INTO bds_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri, yaa nanku Meliiki. Meliiki, yaa nanku Aadi. Aadi, yaa nanku Kosaamu. Kosaamu, yaa nanku Elimadaamu. Elimadaamu, yaa nanku Eeri. ");
INSERT INTO bds_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eeri, yaa nanku Yosuuwa. Yosuuwa, yaa nanku Elieseeri. Elieseeri, yaa nanku Yoriimu. Yoriimu, yaa nanku Mataati. Mataati, yaa nanku Laawi. ");
INSERT INTO bds_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Laawi, yaa nanku Simi⁄ooni. Simi⁄ooni, yaa nanku Yuuda. Yuuda, yaa nanku Yoseefu. Yoseefu, yaa nanku Yonaamu. Yonaamu, yaa nanku Eliyakiimu. Eliyakiimu, yaa nanku Meleeya. ");
INSERT INTO bds_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleeya, yaa nanku Meena. Meena, yaa nanku Mataata. Mataata, yaa nanku Nataani. Nataani, yaa nanku Dawdi. ");
INSERT INTO bds_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawdi, yaa nanku Yeese. Yeese, yaa nanku Obeedi. Obeedi, yaa nanku Boaasi. Boaasi, yaa nanku Salimooni. Salimooni, yaa nanku Nakhasooni. ");
INSERT INTO bds_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nakhasooni, yaa nanku Aminadaabu. Aminadaabu, yaa nanku Adimiini. Adimiini, yaa nanku Arinii. Arinii, yaa nanku Khesirooni. Khesirooni, yaa nanku Pereesi. Pereesi, yaa nanku Yuuda. ");
INSERT INTO bds_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuuda, yaa nanku Yakoobo. Yakoobo, yaa nanku Isaaka. Isaaka, yaa nanku Aburahaamu. Aburahaamu, yaa nanku Teera. Teera, yaa nanku Nakhoori. ");
INSERT INTO bds_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakhoori, yaa nanku Seruugi. Seruugi, yaa nanku Reeu. Reeu, yaa nanku Peleegi. Peleegi, yaa nanku Ebeeri. Ebeeri, yaa nanku Saala. ");
INSERT INTO bds_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saala, yaa nanku Kenaani. Kenaani, yaa nanku Arifakisaadi. Arifakisaadi, yaa nanku Seemu. Seemu, yaa nanku Nuuhu. Nuuhu, yaa nanku Lameeki. ");
INSERT INTO bds_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameeki, yaa nanku Metuseela. Metuseela, yaa nanku Enooki. Enooki, yaa nanku Yareedi. Yareedi, yaa nanku Mahalaleeli. Mahalaleeli, yaa nanku Kenaani. ");
INSERT INTO bds_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenaani, yaa nanku Enoosi. Enoosi, yaa nanku Seeti. Seeti, yaa nanku Adaamu. Adaamu, yaa nanku Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Qatlay Yeesu giyaa ilii waaudi teꞌesaa duudu gu Yoridaanigo, tay duguũ iliihaci Muuna gu Iliitleemu, teꞌesaa dugurigi giyaadi ha Muunakee kongoqomeege. ");
INSERT INTO bds_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ina yaa ibiidi taysi balalu mibeeri cigahha, tay dugu tosaa koimisi ha Biriisimoo. Qatlaykee sliimaa yaa ⁄agimiiba idoo lensee. Balalu hhakee giyaa ilii buꞌudiri, gi arimi qori. ");
INSERT INTO bds_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Biriisimoo gi kaay sa Yeesu tuba, “Bere ugu ti Nanku Iliitleemu, ilafahhe tlaa⁄uki, ma mukaatimoo tleehhidi.” ");
INSERT INTO bds_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu gi ilaki⁄isi sa ina tuba, “Daa handikimi, Handikaa da Iliitleemuge tuba, ‘Heedi yoó ibiidiyaaba hari ⁄agoo kilesi.’ ” ");
INSERT INTO bds_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Da hheꞌesi Biriisimoo gi leehhisi Yeesu cina da oõ naqatloo, gi laqami sa ina aalimee goõ da hhapapu goõ waa leẽ. ");
INSERT INTO bds_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Biriisimoo gi kaay sa Yeesu tuba, “Ana sugu qaw ⁄uuru gu tawaaliru hhapapu hhanki sliimaa, haa sugu qaw wanqamee dooina goõ da didiri. Maꞌaana ana sinaa taatahhi gonkoinaa dabaiĩ koi, haydahhasa qawaraa ⁄uuruki sa heedi ga slae. ");
INSERT INTO bds_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Inkoo, bere ugu ha keebeeꞌeta pandaa dooii haa hanigi daareesida, idadu hhakee gonkoinaa koku tleehhidiyay.” ");
INSERT INTO bds_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu gugi ilaki⁄isi ina tuba, “Daa handikimi taqay, ‘Ugu daareesi Taataa Iliitleemu, Iliitleemu googu, haa sugu yondite ina lenkosi kilesi.’ ” ");
INSERT INTO bds_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Da hheꞌesi Biriisimoo gi leehhisi Yeesu Yerusaleemu naqatloo. Taysi gugi qadidisi ina tlankoo gu tleeduge gu mara gu didiru gu Iliitleemu, gi kaay sa ina tuba, “Bere ugu na Nanku Iliitleemu, hanguu kwahhade tiaa hhapeege. ");
INSERT INTO bds_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Maꞌaana daa handikimi tuba, ‘Iliitleemu ilafahhi malayika dosi, magu ga⁄ayri. ");
INSERT INTO bds_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Inay gu tloꞌosiyay dabaiĩ koinay, ma maydi hiitatafida yaaee doogu tlaa⁄age.’ ” ");
INSERT INTO bds_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu gi ilaki⁄isi sa ina tuba, “Teesaaqay laqaaba, daa handikimi tuba, ‘Taataa Iliitleemu, Iliitleemu googu, hagu hhanti koisida.’ ” ");
INSERT INTO bds_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Biriisimoo giyaa ilii hheꞌesi koimisu Yeesu hari amamu hhakee, gugi mamay teꞌesii qoomay waku naqatloo guraay boo⁄u. ");
INSERT INTO bds_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Da hheꞌesi Yeesu gi ki⁄i hhapee da Galilaayage, tay hiĩ haci ⁄uuru gu Muuna gu Iliitleemu. Kara gimba gosi gii qoomi hari khisla hhapapu sliimaa gwaa ilaciyaa waaree. ");
INSERT INTO bds_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yeesu yaa tlaatleesi caacaahhamisu hida sinagoogaguu koinay, hida sliimaa gugi daareesiri. ");
INSERT INTO bds_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Letu waka Yeesu gi hadakay Nasareetige, yaamu dugwaa ilii omi. Baloo da Sabaato gii day waꞌay gu sinagoogige namati ou gosi gooay. Ina gi qadidi, ma somimi Handikaa da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ina sugugi hadisi ha heedi waku kitaabuu gu tletimiisay Isaaya. Kitaabukee daa taagi gugii tlaaꞌasi haa gi slay daqa daa handikimi tuba, ");
INSERT INTO bds_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muuna gu Taataa Iliitleemu, sliimaa wana haa ana, sa gimba hiningii leehhi ana, ma kakaami Gimba gu Hhou daqa kwaeelige. Hinaani ya⁄abi ana, ma kakaami hiica⁄asaraa sa hida daa khiidimi, kara hida gwaa ilahhamaahhamee, ma slayri hiidahhasa da khuꞌuduũ, haa hida doó labaꞌasiye, ma digi afiiooyimi. ");
INSERT INTO bds_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kara hinaani ya⁄abi, ma kakaami sa hida kori da ilii laqane ha Iliitleemu hhoinay gosi gu didiru daqa hidage.” ");
INSERT INTO bds_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeesu giyaa ilii hheꞌesi somaa gimbakee, gi tosaa taagi kitaabukee, haa gugi ki⁄isi daqa yondimiisay gu sinagoogige, ina gi tosaa ibiidi. Hida sliimaa gwaa sinagoogige waaree gugi ilii kaasiri ilaa. ");
INSERT INTO bds_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ina gi tlaatleesi kaawa daqa dooinay tuba, “Letuti Handikati da Iliitleemu hiĩ buꞌuti, idoo gaã ilii akhasidiri gooay.” ");
INSERT INTO bds_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hida sliimaa gwaa teꞌesii waaree, gugi hhaꞌaleesiri ina hari khisla. Kara digigi bakaꞌasi ha gimba gwaa afa gosi dahha, gwaa hacu hhoinay gu didiru. Hingigi maamisiri inay haa inay tuba, “Ayi! Hiĩ nanku Yoseefu goobaslii?” ");
INSERT INTO bds_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu gi kaay sa inay tuba, “Gu lou, siniti kaaday ana hiihhantlisati doó kaawa tuba, ‘Ugu dareesimoo, hangu hhoeeside ugu lenkoogu!’ Slime siniti kaaday tuba, ‘Gimba goõ gaã akhasani, guũ yonditi yade tongoo da Kaperinauumuge, yondiidaku slime tiꞌii yaamu kokuu!’ ” ");
INSERT INTO bds_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeesu gii roogisi kaawa sa inay tuba, “Guti lou, sangu kaay, hhaku tletimiisay doó muriidiye yaamu kosii. ");
INSERT INTO bds_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Inkoo, itatiisa! Gu lou sangu kaay, qatlay gu tletimiisay Eliyaa yaa wanay tigay wa⁄a daa afahhamaahhami hhawatee koina hhapee da Israeelige. Qatlaykeesii tlubay yaa tlubiiba koraraa tami haa slehheeri lahhoꞌo. Kara qori gu didiru yaa wana hhapee gonge da Israeeli. ");
INSERT INTO bds_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Teesaaqay see, Eliyaa dugwaa ya⁄abiiba haa Iliitleemu daqa kwaꞌalitoꞌoo lenge see tla⁄aã gu hhakeesii. Ina dugwaati ya⁄abi ha Iliitleemu daqa kwaꞌalitoꞌoo wakay daa Yahuuditoꞌoo gooba, daa ibimaamida yaamu gu Sareepitage hhapee da Sidoonige. ");
INSERT INTO bds_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kara, qatlay gu tletimiisay Elisaa, yaa wanay Yahuudi wa⁄a gwaa koomee ga⁄ay gu buubaa hhapee da Israeelige. Teesaaqay see, tla⁄aã gooinay hhaku lensee daa hhoeesi ha Iliitleemu. Namaani kilesi dugunaa hhoeesi, heedi gwaa hhapee da Siiriya dahha!” ");
INSERT INTO bds_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hida sliimaa gwaa sinagoogige waaree, giyaa ilii akhasiri gimbakee gu Yeesu, gi slahhaahhaairi hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cirakiray, inay gi qadimidiri, gii ca⁄asiri Yeesu hari ⁄uuru yaamu koinaa. Inay gugi leehhisiri cina da oõ naqatloo, daqa daa ilii tleehhi tongoo da Nasareeti. Teꞌesaa inay gi taariniri maguu kwahhiri hhapeege, ilagweegwe⁄eda da dihhigo, ma gwaai. ");
INSERT INTO bds_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Teesaaqay see, ina gi tosaa hiicati hari tla⁄aã gu raqatee tooina, gi amoo dosi ooyi. ");
INSERT INTO bds_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Da hheꞌesi Yeesu yaa hiigweegwe⁄edi tongoo da Kaperinauumu naqatloo yaamu gu Galilaayage. Balalu gu Sabaatoge, taysi gi tlaatleesi caacaahhamisu hida sinagoogige. ");
INSERT INTO bds_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hida hhakee digigi bakaꞌasi hari khisla ha caacaahhamisu gosi, sa gimba giyaa caacaahhamisi inay hari ⁄uuru gu tawaaloo. ");
INSERT INTO bds_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Teꞌesii, waꞌay gu sinagoogige heedi waku yaa wana daa ilii khaabaaꞌadi ha gieerimoo. Gieerimokee gi maahhi hari afoo da didiri, gi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ye Yeesu gu Nasareeti, ha mala slaꞌada haa dandiray? Hanti khaydii sa hhamisaraa dandiray? Ugu, haguti khuana! Ugu ti hikira daa tlintiꞌisi gwaa daqa Iliitleemu dahha!” ");
INSERT INTO bds_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu gi ilii⁄oo⁄i gieeri tuba, “Qabe diĩ! Inkootuutuu ca⁄ii daqa heedikaa!” Cirakiray, gieerimokee gi ilii cakhadiri hhapeege heedikee pandaa da hida hhakeesii goõ. Ina yaagi toosaa hiica⁄i daqa dosaa ilaqaꞌa see guba. ");
INSERT INTO bds_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Teꞌesii sinagoogige hida sliimaa yaati bakairi hari khisla, hingigi tlaatleesiri maamisu inay haa inay tuba, “Ayi! Hiĩ ti gimba mala? Yuꞌudiyaa heediki kona hiidahhasa haa ⁄uuru gu tawaaloo da ilii⁄oo⁄a gieeri daqa heedigo, cirakiray gi tooinaa hiica⁄iyay.” ");
INSERT INTO bds_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Teesaaqay, gimba gu Yeesu gii qoomi daqeemoo sliimaa hhapeteesii. ");
INSERT INTO bds_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeesu gi waaudi teꞌesaa sinagoogigo, gi hadakay mara gu Simoonige. Taysi yaa slay kumboꞌoo da Simooni, mama⁄ada hari khisla. Hida gwaa waaree teꞌesii gugi firiniri Yeesu, magi hhoeesi. ");
INSERT INTO bds_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ina gi qadida kay ilaciyaa kosii, gii gupu⁄i daqa dosii haa gi ilii⁄oo⁄i ga⁄aykee. Ina dagagi hhoeesi ga⁄aykee kosi. Cirakiray lenge gi qaditi, gi tosaa yonditi sa inay. ");
INSERT INTO bds_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Qatlay letu giyaa ilii huhaahuꞌude, hida goõ gwaa koomee ga⁄iidee paslaapasloo giyaagi leehhimisiri daqa Yeesuge. Ina gi iliiqamidi dabaiĩ kosi ga⁄iidee goõ, gigi hhoeesi. ");
INSERT INTO bds_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ina slime, gii ca⁄amisi gieeri wa⁄a daqa hida daa ilii khaabaaꞌamidigo, tay tooinaa maahhaminay tuba, “Ugu ti Nanku Iliitleemu!” Yeesu gigi ilii⁄oo⁄i gieerikee, ma mayri kaawaraa sa hida teesaaqay, sa gimba inay giyaa khuiyay tuba, ina na Kristu. ");
INSERT INTO bds_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Heetlaalee dosii daa iliipisi, Yeesu gii ca⁄i khoorooge marakeesaa, gi waaudi daqa daba hida. Hida wa⁄a giyaa ilii caahhiri tuba, Yeesu hhaku, gugi tooinaa dabiiduu kayri ina. Qatlay gwaa ilii slayri, gugi tlaatlahhasiri, ma may waauda daqa dooinaa. ");
INSERT INTO bds_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Teꞌesii ina gi kaay sa inay tuba, “Ana kwanda ga kakaaru kawe Gimba gu Hhou gu Tawaaloo da Iliitleemu yaamu wakinayge see, sa gimba ana sinaa gimbakee ya⁄abi.” ");
INSERT INTO bds_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Teesaaqay, Yeesu gi ilakoomi hiicataraa hari tongagu wa⁄a gu hhapee da Yudaaya, tay tosaa caacaahhamisi gimba gu Iliitleemu sinagoogaguu koinay. ");
INSERT INTO bds_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Letu waka, Yeesu yaa qadidi kenga gu tlawa da didirige da Galilaaya, dugwaati niini⁄idi ha raqa da hida wa⁄a, tay tooinaa akhamisiyayi gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Teꞌesii Yeesu gi arimi masuwaa cada kenga gu tlawateesii. Hida gwaa ooyiiyimee samaakii hindii ca⁄iri masuwaago sa ilahhunca da makumbabuu koina hari maꞌay kenga gu tlawage. ");
INSERT INTO bds_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ina gi tosaa hiiday masuwaa lenge tla⁄aã gu masuwaa hhakeesii, hatee danaa Simooni. Ina gi firimi Simooni maay satisi masuwatee segenge coko⁄o waꞌay gu tlawage. Yeesu gi ibiidi masuwateesii, gi tosaa caacaahhamisi hida hhakee masuwateesaa. ");
INSERT INTO bds_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Qatlay giyaa ilii hheꞌesi caacaahhamisu, gi kaay sa Simooni tuba, “Inkoo, leehhisi masuwaa slagwiya naqatloo, lay taareeꞌeday makumbabuu kokuna, ma ooyintiri samaakii.” ");
INSERT INTO bds_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simooni gi ilaki⁄isi Yeesu tuba, “Looimoo gu Goõ, haã yondiidani hari khisla amasi piray, haã oowaniiba ma samaakimoo lensee! Inkoo, sa kaawaratee toku, hay taareea makumbabuu.” ");
INSERT INTO bds_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Qatlay Simooni haa deneꞌee kosi giyaa ilii teesaaqay laqiri, gi ooyiniri samaakii wa⁄a hari khisla, makumbabuu koina see gi tlaatleesiri kereꞌemidu. ");
INSERT INTO bds_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Teesaaqay, inay gi waratlaymisiri dabaiĩ koina sa ⁄oo⁄araa da deneꞌee koina, gwaa masuwawuu wakinayge waaree, maa khayri sa iliiawaraa inay. Deneꞌee hhakee yaagi khayri, gi hacimisiri samaakii masuwawuu cada koinaa, yaati amoolee tlaatleesiri hiihhamaahhamu maꞌayge. ");
INSERT INTO bds_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simooni slime daa eteediidine na Peetiro giyaa ilii arimi gimbakee, gi keebeeidi pandaa da Yeesuge, gi kaay tuba, “Looimoo gu Goõ, waaudi pandaa dooaa, sa gimba ana ti heedi gu kooma tlakwaroo!” ");
INSERT INTO bds_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Maꞌaana sliimaa haa deneꞌee kosi goõ goó samaakii ooyimee, yaati bakairi hari khisla, sa gimba gu hacimaa gu samaakikee giyaa slayri. ");
INSERT INTO bds_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nama teesaaqay, Yakoobo haa Yohaana yaꞌay gu Sebedaayo, deneꞌee kosi gu Simooni, slime yaati bakairi. Yeesu ginaa ilii kaay sa Simooni tuba, “Hhanti tlaꞌamuta! Tlaatleesa da letutaa, ugu samaakii kilesi guni ooyintaaba, hida ginaa ooyinta daqa dooii.” ");
INSERT INTO bds_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Qariqaaqari inay giyaa ilii ca⁄asiri masuwawuu koina hhapee da kaarunge naqatloo, teꞌesii gi mayri idadu sliimaa, gugi tooinaa sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yeesu giyaa ilii cati hari tongoo waka da yaamu gu Galilaayage waara, yuꞌudiyaa, teꞌesii yaa wana heedi gwaa kooma buubaa wa⁄a slaqwa dosii. Qatlay giyaa ilii arimi Yeesu, gi hadakay daqa dosii, gi keebeeꞌedi hhapeege pandaa dosii. Ina gi tlaatlaqasi Yeesu tuba, “Looimoo gu Goõ, hhooa, bere ha slaꞌada, haniidahhasida ilabuusla!” ");
INSERT INTO bds_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu gi tafaꞌasi daba gosi, gugi tosaa nangusi heedikee, sugugi kaay tuba, “Ee, Ana slaꞌa teesaaqay laqa, ugu ma dugu ilabuusli inkootuutuu!” Cirakiray lenge ga⁄aykee kosi gi hhoay sumuku! ");
INSERT INTO bds_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Da hheꞌesi Yeesu, heedikee gugi afakaayi tuba, “Hhanti kaada sa heedi lensee gimbaki. Inkootuutuu taa⁄a hangu laqante daqa hhapalooay gu Iliitleemuge, la hadisa kayda sadaaka sa ilabuuslatee toku, idoo daa ilii ilafahhi gooay sariyaa da Musaage. Hatee noo ilatlawa doogu sa inay.” ");
INSERT INTO bds_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Teesaaqay gimba gu Yeesu, gi tosaa ilaqinci hiiqoomaraa hari khisla. Raqoo wa⁄a gu hida yaay kurunkuriirimidiyay daqa Yeesuge, ma itatiimisiri gimba gu Iliitleemu haa ma digi hhoeemisi ga⁄ay gooina. ");
INSERT INTO bds_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Inkoo, qatlay wa⁄a Yeesu hingaati pasliislimisi ina lenkosi daqa dooinaa, daqa daaba hida, sa firoo da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Letu waka, Yeesu yaa caacaahhamisi hida. Teꞌesii Farisaayoo wakinay haa maarimamaa da sariyaa, yaa wanay yaa ibiidiri, gwaa tongagu paslaapasloo dahhee gu hhapee da Galilaaya, Yudaaya haa Yerusaleemu. ⁄uuru gu Iliitleemu yaa sliimaa wana haa Yeesu sa hhoeemisu gu ga⁄iidee. ");
INSERT INTO bds_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yuꞌudiyaa, hida wakinay cigahha yaagi leehhisiri hari fala heedi waku gwaa tingara⁄uudu. Inay yaa slaiyay, magu leehhisiri waꞌay gu mara daa iliiwane Yeesu, magu qaatisiri pandaa dosii. ");
INSERT INTO bds_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Inkoo, hida hhakee digiraa slanqadi hari dawaraa heedikee marage daqa Yeesuge, sa gimba gu raqa da hida daa qiqincidi teꞌesii. Da hheꞌesi gii dadayri rawaa gu pembeege, gi tooinaa cihhiri pembee daqatiray loii daa iliiwane Yeesu, gii ⁄eetisiri heedikee gwaa tingara⁄uudu, tay hiĩ qaati falage pandaa da Yeesuge. ");
INSERT INTO bds_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeesu giyaa ilii arimi hida hhakee, idoo giyaa iliikonee ⁄imba da didiri daqa dosii, gi tosaa kaay sa heedikee gwaa tingara⁄uudu tuba, “Ye hhia goy, tlakwaroo doogu sliimaa dagaã ilamooyimi!” ");
INSERT INTO bds_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Inkoo, maarimamaa da sariyaa haa Farisaayoo giyaa ilii akhasiri Yeesu hiĩ kaay teesaaqay, gi tlaatleesiri ilahudaa tuba, “Heediki ti miyaa gu kakaakama gimba gu belendeqesa Iliitleemu? Hhaku lensee gu kooma ⁄uuru gu ilamooyiru tlakwaroo, Iliitleemu kilesi na kona!” ");
INSERT INTO bds_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeesu gi caahhi idoo giyaa ilahudeedemisiyeei, gi kaay sa inay tuba, “Sa soꞌoyi ilahudeedemisiday teesaaqay muunaiĩ kokunay? ");
INSERT INTO bds_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gimba haloo na slaahhi hari khisla, kaawaraa tuba, ‘Tlakwaroo doogu sliimaa dagaã ilamooyimi,’ baku kaawaraa tuba, ‘Tlayii, la waauta?’ ");
INSERT INTO bds_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Inkoo, ana slaꞌa unkuray, ma caahhadiri tuba, Nanku Heedi kona ⁄uuru gu tawaaloo guri ilamooyiru tlakwaroo da hida tiꞌii khoorotii!” Teꞌesii Yeesu gi kaay sa heedikira gwaa tingara⁄uudu tuba, “Suguũ kaay, tlayii, oyii fala doogu, la waauta ayage!” ");
INSERT INTO bds_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cirakiray lenge heedikee gwaa tingara⁄uudu gi qadidi ge⁄e pandaa da hida sliimaage, gi tosaa hiioy fala dosi, gi watli ayage, tay tosaa hhaꞌaleemisi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hida sliimaa giyaa ilii aniri teesaaqay, gi bakairi hari khisla! Inay see gi hhaꞌaleesiri Iliitleemu haa digigi iliihaci ha gwaa⁄amee, kakaanay tuba, “Gu lou, letuti haã arini gimba gu didiru gu bakaꞌasa!” ");
INSERT INTO bds_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gimbakee giyaa ilii cati, Yeesu yaagii ca⁄i kenga gu yaamuge. Ina gi arimi karaanii gwaa hiikurunkuriirima koodi oofisi dosii, uma gosi naa Laawi, hiĩ ibiidi teꞌesii. Yeesu gi kaay sa ina tuba, “Hanisirakonte!” ");
INSERT INTO bds_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Laawi gii tlay, gi mamay yondukee kosi gu koodi, gi tosaa sirakoomi Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Da hheꞌesi Laawi gi boo⁄imisi losona gu didiru aya gosii sa Yeesu. Inkoo raqa da didiri da karaanimaiĩ goó hiikurunkurimee koodi haa hida wakinay yaa ibiidiri teꞌesii ⁄aginay ⁄agoo sliimaa haa Yeesu haa Laawi. ");
INSERT INTO bds_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Teesaaqay see, Farisaayoo haa maarimamaa dooina da sariyaa, giyaa ilii aniri Yeesu ⁄agina haa hida hhakee goõ, gi maasiri sirakoomiisee da Yeesu tuba, “Unkuray haa Yeesu sa soꞌoyi ⁄agiigintay haa kitahhaahhantay sliimaa haa karaanimaiĩ goó hiikurunkurimee koodi haa hida hhakee gu koomee tlakwaroo?” ");
INSERT INTO bds_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu gi ilaki⁄isi inay tuba, “Hida gu koomee slaqoo gu hhoi yoó slaiyaaiiba dareesimoo, hhakaꞌa gu koomee ga⁄ay noó slaiyay. ");
INSERT INTO bds_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inkoo, ana hanti khayiiba sa eteeda hida hhakaꞌa gungoó hiiarimee tuba, ibinaa dooina yaa tafaꞌadi. Hanti khay sa eteediru gu hida hhakaꞌa gu koomee tlakwaroo, may fookidiri tlakwaroo dooinaa daqa Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hida wakinay gi kaayri sa Yeesu tuba, “Sirakoomiisee da Yohaana Hiinunqudimiisay haa raqa da Farisaayoo, diqimi wa⁄a inay yoóti mayay ⁄agoo haa kitahhu see, gi firiirinay Iliitleemu. Inkoo, sirakoomiisee doogu soó soꞌoyi mayay teesaaqay laqaraa?” ");
INSERT INTO bds_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu gi ilaki⁄isi sa inay tuba, “Dahaa gu heedi guũ khabimu, hagi malee hiidahhasiday, ma mayri ⁄agoo haa kitahhuu qatlay heedi guũ khabimu tosaa wana sliimaa haa inay? ");
INSERT INTO bds_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Inkoo, balalu gimaa dayee, heedi gwaa khabimu dugurimaa waaudi daqa dooinaa, qatlaykeesii maa asu mayay ⁄agoo haa kitahhuu see.” ");
INSERT INTO bds_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeesu gi kaay sa inay ilaꞌaaꞌaatisati tuba, “Hhaku heedi lensee goó feehhisa dahhamu daqa qayru gu ⁄abugo, ma hiidaqi qayru gwaa faaku hari dahhamukee. Bere teesaaqay laqi, kwanda gi feehhisiye qayrukira gu ⁄abu. Kara dahhamukee gu ⁄abu hingi slaaslaaqasiyaaba haa qayrukee gwaa faaku. ");
INSERT INTO bds_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nama teesaaqay leẽ, hhaku heedi lensee goó hiieesa difaay da ⁄abi waꞌay gu curuqu daa boo⁄imisi hari fala da segi da iliiqaasa difaaytee. Bere teesaaqay laqi, difaaytee da ⁄abi, qatlay giyoo ilii mahhaaꞌade, kwanda gii feehhimiside hari ⁄uuru faloo hhakee gonkoinaa. Kara difaaytee goõ tuutuquta haã faloo hhakee see slime yooti tlakwaakwayay. ");
INSERT INTO bds_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Teesaaqay difaay da ⁄abi kwanda dagoó waꞌay gu curuqeerii gu faloo gu ⁄abige hiieesi. ");
INSERT INTO bds_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kara, bere heedi hiĩ kitahhi difaay da segi, yoó slaiyaaba kitahhu difaay da ⁄abi, maꞌaana ina yoóti kaay tuba, ‘Hataꞌa da segi dati hhoi hari khisla!’ ” ");
INSERT INTO bds_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Letu waka baloo da Sabaato, Yeesu haa sirakoomiisee dosi yaa hiicatiri hari tla⁄aã gu qaymamuu gu ganoo. Qatlaykee sirakoomiisee dosi gi kereꞌemisidi sagaiĩ gu ganoo, gigi pisiginiri dabaiĩ koinay, gi tooinaa ⁄aginay. ");
INSERT INTO bds_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Inkoo Farisaayoo wakinay gwaa waaree teꞌesii gi kaayri sa Yeesu tuba, “Sa soꞌoyi yondimaamitay yondu daa kitlakuusi sariyaage baloo da Sabaatoge!” ");
INSERT INTO bds_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Teꞌesii Yeesu gi ilaki⁄isi sa inay tuba, “Haati somintiriibaslii gimba gu Iliitleemuge, idoo Dawdi giyaa laqi ina haa hida kosi qatlay giyaa ilii qoriimidiri? ");
INSERT INTO bds_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ina yaa hiiday mara gu Iliitleemuge, gi ⁄agimi mukaate daa hadiidimisiye sa Iliitleemu, Dawdi gi ⁄agimi, gi qaqay mukaatetee sa hida kosi! Kara mukaatetee dagaa kitlakuusi ⁄agoo heedi lensee. Hhapalooee kilesi naa ⁄agiiginay.” ");
INSERT INTO bds_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Teesaaqay Yeesu gi ilaki⁄isi Farisaayoo tuba, “Ana na Nanku Heedi, Looimoo gu baloo da Sabaato.” ");
INSERT INTO bds_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baloo waka da Sabaato, Yeesu kara yaay day sinagoogige, gi tlaatleesi caacaahhamisu hida. Teꞌesii yaa wana heedi waku daba gosi gu ⁄uya gwaa tingara⁄uudu. ");
INSERT INTO bds_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Inkoo, Farisaayoo haa maarimamaa da sariyaa gwaati khuꞌuuꞌunay Yeesu naraꞌa, ma aniri, bere higi hhoeesi heedikee baloo da Sabaatoilee. Inay yaati teesaaqay laqiri, ma slayri amoo dari sitaakiru Yeesu pandaa da balasaage. ");
INSERT INTO bds_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Teꞌesii, Yeesu gi caahhi idoo giyaa ilahudeedemisiyeei. Ina gi kaay sa heedikee gwaa daba tingara⁄uudu tuba, “Khoca tiꞌii, qadidi pandaa da hida sliimaage.” Heedikee gi hadakay haa gi qadidi teꞌesii. ");
INSERT INTO bds_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu gi kaay sa inay tuba, “Hangu maasa unkuray, gimba haloo na kitlakuuba yondu baloo da Sabaatoilee? Ti yondu hhoinay baku ti yondu tlakwaroo? Kara haloo na hhoinay baloteesii? Ti ilabuꞌuruu ibinaa gwaaꞌaraago baku ti hhamisaraa ibinaa?” ");
INSERT INTO bds_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeesu gigi yuꞌudi inay gonkoinaa bareemoo sliimaa. Da hheꞌesi gi kaay sa heedikee gwaa daba tingara⁄uudu tuba, “Tafaꞌasi daba googu!” Heedikee gi tosaa tafaꞌasi daba gosi, cirakiray lenge dugugi hhoeesi sumuku. ");
INSERT INTO bds_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Teꞌesii Farisaayoo haa maarimamatee da sariyaa gi slahhaahhaairi hari khisla. Inay hingigi tlaatleesiri ilakhuukhuꞌumisuu inay haa inay, idoo gi laqiyee Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Balalu hhakeesii Yeesu yaa ilakhiinaaꞌadi rawaa gu onke, ma firoo kay Iliitleemu, taysi gugi firiirimi amasi piray. ");
INSERT INTO bds_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Qatlay daa iliipisi, gi eteedi sirakoomiisee dosi giyaa ina slaiye. Teꞌesii Yeesu gii leehhi hhawatee mibi haa cada, girigi ayi uma na ya⁄abimiisee. ");
INSERT INTO bds_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Umaiĩ koina niĩ: Simooni (hiĩ daraa ayi uma gu caduu na Peetiro), Andareyaa hhia gosi gu Peetiro, Yakoobo haa Yohaana, Filiipo, Batolimaayo, ");
INSERT INTO bds_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataayo, Toomaasi, Yakoobo nanku Alifaayo, Tadaayo, Simooni gu raqa da Seloote, ");
INSERT INTO bds_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda nanku Yakoobo haa Yuuda Isikariyooti. Qariqaaqari hiĩ naa hiifookidi Yeesu, gugi taatahhi dabaiĩ gu fa⁄ayaage. ");
INSERT INTO bds_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu giyaa ilii gweegwe⁄edi onko sliimaa haa sirakoomiisee dosi, gi qadidi daqa daa paapaahhatige. Teꞌesii daa wana raqa da didiri da sirakoomiisee dosi, slime haa raqa da didiri da hida gwaa daqeemoo sliimaa dahhee gu hhapee da Yudaayago haa Yerusaleemugo. Kara yaa wanay hhaã gwaa daqeemoo gu kengaa gu tlawa da didiri dahhee gu yaamu gu Tiiro haa Sidooni. ");
INSERT INTO bds_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hida hhakee goõ yaati khayri sa itatiimisu gu Yeesu haa ma hhoeemisi ga⁄ay gooina. Slime hhakira daa labaꞌaaꞌamisiye ha gieeri, gigi hhoeemisi. ");
INSERT INTO bds_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hida goõ gwaa slaiyay nangumisu, sa gimba ⁄uuru gosi yaay cacaaca⁄i, tay gi tosaa hhoeemisi hida goõ. ");
INSERT INTO bds_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Da hheꞌesi Yeesu gi yuꞌudi daqa sirakoomiisee dosii, gi kaay tuba, “Dangwaa ⁄aafi ha Iliitleemu unkuray gu kwaeeli, sa gimba Tawaaloo da Iliitleemu ti tooguna. ");
INSERT INTO bds_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dangwaa ⁄aafi ha Iliitleemu unkuray gu koomee qori inkoo, sa gimba Iliitleemu hangu ankhasi! Dangwaa ⁄aafi unkuray goó gaiidee inkoo, sa gimba asunkuilee maa hhaꞌaluumitay. ");
INSERT INTO bds_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dangwaa ⁄aafi unkuray ha Iliitleemu qatlay dangu ilii wakiye ha hida, dangu ilii tlintiꞌisiye haa dangu ilii wahaahane, giyoó ilii siꞌiyee uꞌuru umaiĩ kokuna gimba gu tlaku pahha, sa gimba goó iliipaꞌantee ana, Nanku Heedi. ");
INSERT INTO bds_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gimbakee gimaa iliica⁄iye, baloteesii lamaati hhaꞌaluumitay haa seehhuusiday! Yuꞌudiyaa, Iliitleemu sangu ilakhuukhuuꞌumisi ⁄aliya rawaa gu rawge. Okookoiĩ koina see, yaa mati teesaaqay labaꞌaaꞌamisiyay tletimiisee da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Inkoo, hoo antayi, unkuray hindaqeeri, sa gimba hhaꞌaloo dooguna gaã hheꞌesidiri gaã slaydiri! ");
INSERT INTO bds_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ha antayi unkuray goó akhaakhamee inkoo, sa gimba maa antayi qori! Ha antayi unkuray goó qasaasawe hari hhaꞌaloo inkoo, sa gimba hamaa slahhaahhaꞌaday haa gaitay! ");
INSERT INTO bds_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ha antayi qatlay hida goõ dangoó ilii dumbine unkuray, sa gimba okookoiĩ koina yaa teesaaqay hhaꞌaleesiri tletimiisee da afaꞌafuumaa.” ");
INSERT INTO bds_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yeesu gi ilakoomi gimba tuba, “Sangu kakaakama unkuray gu itatiitimisee ana, slaꞌa fa⁄ayaa dooguna. Kara yondiida hhoinay sa hhakee gu wakee unkuray. ");
INSERT INTO bds_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Slime ⁄aafakina hhakee goó wakee unkuray, firiirima Iliitleemu sa hhakee goó yondiidiye tlakwaroo daqa doogunay. ");
INSERT INTO bds_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bere heedi slokhosi ugu tlooma lenge, suguu fookide tlooma da cadii see. Kara bere dugu afii⁄utli kooti doogu, hagu hhanti afii⁄itida, sugu hadiside kanchoo doogu see. ");
INSERT INTO bds_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kara, hida goó firiirimee sigi qaydee, bere heedi waku hiioy khooslay googu, hhanti firinta ina, ma sugwaa ki⁄isi. ");
INSERT INTO bds_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yondiida sa hida wakinay, nama amotee gooay unkuray goó iliislaꞌadee, inay ma yondiidiri sa unkuray. ");
INSERT INTO bds_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bere hagiti slaꞌaday hida hhakaꞌa kilesi goó unkuray slaee, hoó hhaꞌaloo mala slayday daqa Iliitleemugo? Hida gu koomee see tlakwaroo yoó slaiyay hida hhakaꞌa goó slaee inay. ");
INSERT INTO bds_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kara, bere ti yonditay hhoinay sa hhakee kilesi goó yondiidee hhoinay sa unkuray, hoó hhaꞌaloo mala slayday? Hida gu koomee see tlakwaroo yoómati teesaaqay laqiyay! ");
INSERT INTO bds_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kara, bere ti hadimisiday kilesi idadu kokuna sa hida hhakaꞌa goó iliipaꞌante tuba, inay yaa ki⁄isiyay idadu hhakee, hoó hhaꞌaloo mala slayday? Hida gu koomee see tlakwaroo yoó hadimisiyay idadu koina sa danaee koina gu koomee tlakwaroo, ma sigima ki⁄isi nama teesaaqay gooay giyaa ilii hadisiri! ");
INSERT INTO bds_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Inkoo, unkuray slaꞌa fa⁄ayaa dooguna haa yondiida gimba gu hhoinay sa inay. Kara inay sigi hadimisidee idadu kokuna, hhanti iliipaꞌantay, ma sangwaa ki⁄isi idoo lensee. Teesaaqay unkuray sangumaa qay ha Iliitleemu ⁄aliya. Kara unkuray maa yaꞌay gu Iliitleemu gu Rawaa gu Idadu Sliimaage Waara, sa gimba Iliitleemu guti hhou daqa hida hhakaꞌay goóba daareesa ina haa hhakaꞌa goó yondiidee tlakwaroo. ");
INSERT INTO bds_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Laqama hari slaꞌamuu goó muuna dahha sa hida, idoo Taataa googuna gooay Iliitleemu giyoó ilii yondiidiye hari slaꞌamuu. ");
INSERT INTO bds_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Hhanti hukuukuntay hida wakinay, unkuray see dangu ba⁄atii hukuna ha Iliitleemu. Hhanti kaaday tuba, wakinay digi ⁄agitine, unkuray see ma dangu may ⁄agitiru teesaaqay ha Iliitleemu. Ilamooyima hida, unkuray see ma dangu ilamooyimi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kara qaqaw sa hida idadu, Iliitleemu sangu qaqay ilakhuaraa da didiri, gimati curuqu daa sookhimi haa dugugi slankudisi ti amoolaa kuꞌumidi. Slawaw tuba, pimokaꞌa goó ilakhuꞌudee sa hida, unkuray see nama hikee, sangunimaa ilakhui ha Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu slime gi kaay sa hida hhakee hari ilaꞌaaꞌaatisati tuba, “Heedi gwaa ilahhamu hiidahhasiyaa giyaadaraa sa danaꞌa gosi gwaa ilahhamu? Gu lou, gonkoinaa hiihuhuiyay bondagee? ");
INSERT INTO bds_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Heedi goó somima yoó hiicatiyaaba maarimuu gosi. Bere heedi hindii gaasi somaa, hiidahhasi maarimuu gosi pahha tleehhida. ");
INSERT INTO bds_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ha soꞌoyi khuꞌuuꞌunta pencerehhemiya da waara ila da hhia googuu, ugu gi mayda arimaa bangasiya ila dooguu? ");
INSERT INTO bds_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ha malee hiidahhasida kaawaraa sa hhia googu tuba, ‘Hhia goy, may sugu baci pencerehhemiya da ila dooguu waara,’ tay ugu loi gi mayda arimaa bangasiya ila dooguu? Ye peereehhiisay! Bace geesaa bangasiya da didiri da ila dooguu waara, teꞌesii ganoo ilii arinta naraꞌa pencerehhemiyatee da ila da hhia googuu waara.” ");
INSERT INTO bds_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yeesu gi ilakoomi gimba tuba, “Hhaku khaimoo gu hhou goó ⁄aamuuda ⁄aamu gu tlaku, nama teesaaqay hhaku khaimoo gu tlaku goó ⁄aamuuda ⁄aamu gu hhou. ");
INSERT INTO bds_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hida yoóti caahhiyay khaimoo hari ⁄aamu gosi. Hida yoó wee⁄iyaaii ⁄aamu gu ⁄anca leqeewaage ma sabiibu see dugoó buꞌunaaba foqoorayge. ");
INSERT INTO bds_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nama teesaaqay heedi gu hhou hari ibinaa dosi yoótii ca⁄asi gimba gu hhou muuna gosaa. Slime heedi gu tlaku hari ibinaa dosi yoótii ca⁄asi gimba gu tlaku muuna gosaa. Heedi, afa gosaa yoóti gimbuusi gimbakaꞌa gwaa hacu muuna gosii. ");
INSERT INTO bds_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sinoó soꞌoyi eteedintay ana, ‘Looimoo gu Goõ, Looimoo gu Goõ!’ Kara tay unkuray hoó toogunaa yonditaaiiba gimba sangoó kakaame? ");
INSERT INTO bds_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sangu laqama, idoo gi iliiwane heedikaꞌa goó khawa daqa dooii haa goó akhamisa gimba gooi haa gigi yondiidi. ");
INSERT INTO bds_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hikee ti heedikaꞌa pahha goó tleehha mara, gi fooli musingi gu ilasegu hari khisla haa gugi tleehhi rawaa gu hhafidage. Qatlay ilawa⁄iya giyaa ilii khaydi, maꞌay kosi gi tlupiri mara hari ⁄uuru. Teesaaqay see, ilawa⁄iyatee yaa hiidahhasidiiba rinqirinqisa marakee, sa gimba dugwaa tleehhi naraꞌa. ");
INSERT INTO bds_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Heedi goó akhamisa gimba gooi, haa gi may yondiida gimbakee koi, ti heedikaꞌa pahha goó tleehha mara hhapeege musingi see hhaku. Qatlay ilawa⁄iya da duudu giyoó ilii ca⁄ade, marakee dugoóti tlupi ha ilawa⁄iya, gi tosaa cira huui haa gi tlakwaakway sumuku!” ");
INSERT INTO bds_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Qatlay Yeesu giyaa ilii hheꞌesi caacaahhamisu gimbakee goõ, tay hida tooinaa akhamisiyayi, gi tosaa waaudi, gi tosaa day Kaperinauumuge. ");
INSERT INTO bds_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Taysi yaa wana sirikaarimoo waku gu didiru gu Ruumi. Sirikaarimokee yaa kona tongimoo gwaa slaiye hari khisla. Tongimoki yaa mama⁄i daati naahhi aloo gwaai. ");
INSERT INTO bds_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sirikaarimokee giyaa ilii akhasi gimba gu Yeesu, yaa ya⁄abi gaduũ gu Wayahuudi daqa dosii, magu firoo kayri ina, maa khay sa hhoeesi tongimoo gosi. ");
INSERT INTO bds_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inay giyaa ilii dayri daqa Yeesuge, gugi tlaatlaqasiri hari khisla, sugugi kaayri tuba, “Sirikaarimoki haraay boo⁄i, ma sugu yonditi teesaaqay. ");
INSERT INTO bds_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Maꞌaana ina hindi slai hari khisla dandiray gaduũ gu Yahuudi, kara ina sindaa tleehhi sinagoogi.” ");
INSERT INTO bds_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Teesaaqay Yeesu gi waaudi sliimaa haa inay. Qatlay giyaa ilii daadaauusi mara gu afisakeesii, ina gi ya⁄abi danaee kosi, ma kaayri sa Yeesu tuba, “Looimoo goori, hangwaa hhanti ilahufita khawaraa yade, ugu ti heedi gu didiru, ana haraa hiiboo⁄iiba kwahhasuusa ugu mara gooii. ");
INSERT INTO bds_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Haã na idoo sangwaa ilatahhi ana lenkooi ambee, haraa hiiboo⁄iiba khawaraa daqa dooguu. Inkoo, hhooa, ugu kaay gimba kilesi, tongimoo goy kwanda gi hhoaye! ");
INSERT INTO bds_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ana see, ti kooma hida gu rawaa koii waaree ⁄uuru gu tawaalooge. Slime kooma sirikaarii waka da biraa gu tawaaloo dooii waaree. Qatlay goó ilii kaawe sa leẽ ambee, ‘Taa⁄a!’ Ina yoóti hadakay. Kara goó ilii kaawe sa waku ambee, ‘Khoca!’ ina yoóti khay. Slime goó ilii kaawe sa tongimoo goy ambee, ‘Yondiidi gimbaki!’ Ina yoóti yondiidi.” ");
INSERT INTO bds_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Qatlay Yeesu giyaa ilii akhasi gimbaki, yaati bakai hari khisla sa sirikaarimokee. Ina gii fookidi daqa raqateesii da hidage, daa sirakomaamida ina, gi kaay tuba, “Etaa, hhapee sliimaa see da Israeeli ha kahha arimaa heedi gu kooma ⁄imba da didiri da hiĩ gooay!” ");
INSERT INTO bds_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hida hhakee daa ya⁄abi daqa Yeesuge giyaa ilii ki⁄iri aya gu afisakeesii, gi slayri tongimokira hiĩ hhoay. ");
INSERT INTO bds_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Qariqaaqari coko⁄o, Yeesu yaa hadakay yaamu wakinay doó eteedine na Nayiini. Slime, sirakoomiisee dosi haa raqa da didiri da hida yaa sliimaa hadakayri haa ina. ");
INSERT INTO bds_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yeesu giyaa ilii daadaauusi kaꞌafu gu yaamuge, hingigi slaslay haa hida gwaa geregedee tuuna da qaraimoo waku, giyaati qaasaraa kakaakay. Kara ina naa naw gu leẽ kilesi daqa iyoo dosii, daa kwaꞌalitoꞌoo. Raqa da didiri da hida gu yaamu hhakee yaa sliimaa wanta haa kwaꞌalitoꞌotee. ");
INSERT INTO bds_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Qatlay Looimoo gu Goõ giyaa ilii arimi kwaꞌalitoꞌotee, gi arimi murumuꞌuuma sa ina, sagagi kaay tuba, “Hhanti ⁄aa⁄ada!” ");
INSERT INTO bds_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Da hheꞌesi, gii sati ilaciyaa gu fala daraa geregedi tuuꞌuna haa gigi nangusi. Hhawatee hhakee gwaa geregedee falatee gi qadimidiri. Ina gi kaay tuba, “Qaraimoo, suguũ kaay, tlayii!” ");
INSERT INTO bds_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Qaraimokee gwaa hhamu, gii tlay haa gi ibiidi, gi tlaatleesi cocoꞌomoo! Yeesu gugi tosaa taatahhi daqa yaayii dosii. ");
INSERT INTO bds_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hida hhakee goõ digigi ooyi ha tlaꞌamee, gi daareesiri Iliitleemu, kakaanay tuba, “Tletimiisay gu didiru hindii ca⁄i tla⁄aã goorii. Iliitleemu yaani khay sa iliiawaraa da hida kosi!” ");
INSERT INTO bds_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gimbaki giyaa yondiidi Yeesu gii qoomi hhapee sliimaa da Yudaaya haa hhapapu gu ilaciyaage. ");
INSERT INTO bds_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sirakoomiisee da Yohaana Hiinunqudimiisay gi ilii khookhocu kayri Yohaana jeerage, sugugi kaayri gimba sliimaa daa yondimaamidiye ha Yeesu. Teesaaqay ina tla⁄aã gooinaa gi ⁄oo⁄i ya⁄abimiisee dosi cada, ");
INSERT INTO bds_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","gigi ya⁄abi daqa Looimoo gu Gonge, magu maasa kayri tuba, “Ugu na inaa Masiiya gwaa khakhaakhawa baku waku guni baqadana?” ");
INSERT INTO bds_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sirakoomiisetira da Yohaana giyaa ilii dayri daqa Yeesuge, gi kaayri sa ina tuba, “Yohaana Hiinunqudimiisay hindaani ya⁄abi, magu maasani ugu tuba, ‘Ugu na inaa Masiiya gwaa khakhaakhawa baku waku guni baqadana?’ ” ");
INSERT INTO bds_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nama qatlaykeesii lenge, Yeesu yaa hhoeemisi hida wa⁄a gwaa koomee ga⁄ay paslaapasloo haa gwaa koomee gieeri, slime gi hhoeemisi hida wa⁄a gwaa ilahhamaahhamee, ma khuꞌuniri. ");
INSERT INTO bds_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Teesaaqay, ina gi ilaki⁄isi hhawatee hhakee gu cada tuba, “Taa⁄amida ki⁄a, la kaaday sa Yohaana gimba goõ guũ antiri haa guũ akhasidiri. Hida gwaa ilaa hhamaahhamee khuꞌuuꞌunay, gwaa yeꞌeeroo tlakwaakwawee khociicinay, gu koomee buubaa digi ilabuslaaslidi, qapanimaiĩ akhaakhamisiyayi, gwaa kaka⁄ee digi slafimaamisi, kwaeeli sigi kakaakana Gimba gu Hhou. ");
INSERT INTO bds_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kara dugwaa ⁄aafi ha Iliitleemu heedikaꞌa goóba mawaraa ⁄imbaraa ana.” ");
INSERT INTO bds_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Qariqaaqari sirakoomiisee da Yohaana giyaa ilii waaudiri, Yeesu gi tlaatleesi cocoꞌomoo daqa raqa da hidage gimba gu Yohaana. Ina gi kaay tuba, “Ilahudeesa, unkuray gaa ilii hada kaydiri kongoqomeege, ma arintiri Yohaana, haa mala slaꞌaday arimaa? Ti cikwahhagoo doó rinqirinqimisiye ha caaqwa? ");
INSERT INTO bds_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bere teesaaqay gooba, haã mala arimaa kaydiri? Heedi gwaa daamisugoo qayroo gu hhoii? Teesaaqay gooba, hida goó daamisee qayroo daa kirigi hari peesay wa⁄a, inay yoóti ibiidiyay ibinaa da hhaꞌaloo maraai gu mutemige! ");
INSERT INTO bds_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Inkoo, haã mala arimaa kaydiri? Tletimiisay goo? Gu lou! Unkuray sangu kaawa ambee, Yohaana guti didiru ba⁄ay da tletimiisay see. ");
INSERT INTO bds_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Heediki na hikira daa handikimi Handikaa da Iliitleemuge tuba, ‘Yuꞌudiyaa, ana ya⁄aba ya⁄abimiisay goy, ina sugu giyaadi, ma hiinaꞌa kay amoo sa ugu.’ ");
INSERT INTO bds_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kara, ana sangu kaawa unkuray ambee, ‘Tla⁄aã gu hida sliimaage daa laqwali hhaku gu didiru da Yohaana Hiinunqudimiisay gooay. Teesaaqay see, heedikaꞌa doó faadiye gu coko⁄o loi Tawaaloo da Iliitleemuge guti didiru ba⁄ay da Yohaana.’ ” ");
INSERT INTO bds_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Hida sliimaa haa karaanimaiĩ see goóyii kurunkurimee koodi yaa akhasiri gimbakee gu Yeesu. Inay yaa ⁄imbiri tuba, yondu gu Iliitleemu yaati tafai, maꞌaana inay ha Yohaana nigaa hiinunqudimisi. ");
INSERT INTO bds_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisaayoo haa maarimamaa da sariyaa da diini yaa ⁄imbiriiba. Inay yaa siꞌiri ilakhuukhuꞌusa da Iliitleemu daqa dooinay, maꞌaana inay yaa siꞌiri, ma digii nunqudimisi ha Yohaana.) ");
INSERT INTO bds_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeesu gi kaay tuba, “Laqwaloti da inkoo ilahudeesa, hanguri idoo mala gooay ilaꞌaaꞌaatisa? Unkuray ti hida gu malee slaqamisee? ");
INSERT INTO bds_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inay ti daaqay hhakaꞌa pahha goó ibiidee sokooniige, tay hingi tooinaa eteedinay tuba, ‘Sangwaa hiifahhani firimbii, haa seehhusidiriiba! Sangwaa raaꞌani raaꞌamee da gaiidimoo, haa ⁄aa⁄adiriiba!’ ");
INSERT INTO bds_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohaana Hiinunqudimiisay yaa khay, yaa ⁄agiiginaaba mukaate ma kitahhu see difaay. Teesaaqay see, unkuray gi kaadiri tuba, ‘Dugwaa ilii khaabaaꞌadi ha gieeri.’ ");
INSERT INTO bds_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nanku Heedi yaani khay, ina ⁄agiigina haa kitahhaahhana, unkuray gi kaadiri tuba, ‘Yuꞌudaa, hheehhiisayki haa oonimiisayki, danaꞌa gu karaanimaiĩ goó hiikurunkurimee koodi haa gu hida gu koomee tlakwaroo!’ ");
INSERT INTO bds_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Teesaaqay see, waaway gu Iliitleemu duguũ ilatahhi tuba, guti lou ibinaa da yaꞌay kosii goó ⁄imbee waawaykee.” ");
INSERT INTO bds_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Letu waka Farisaaymoo waku, uma gosi na Simooni yaa kwahhasuusi Yeesu aya gosii sa ⁄agoo. Yeesu gi hadakay aya gu Farisaaymokeesii, gi tosaa ibiidi sa ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yuꞌudiyaa, hadee waka yaa wanta yaamu hhakeesii, daa khuiye tuba, konta tlakwaroo. Hadetee giyaa ilii akhasidi tuba, Yeesu ⁄agiigina ⁄agoo aya gu Farisaaymokeesii, ina gi tosaa hadakaydi, gii oodi khoosliya da hhoi da alabaasita, daa kooma du⁄iya da tafu gu hhou. ");
INSERT INTO bds_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Qatlay giyaa ilii ⁄agiiginee, hadetee gi qaditi, ilaciyaa haa yeꞌeeroo gu Yeesu, tay tosaa ⁄aa⁄ada. Hherehheraa kosi gi tlaatleesiri tihhiruu yeꞌeeroo gu Yeesuge. Da hheꞌesi gigi buuslidi hari quubu gu saga gosi haa gigi humbaꞌamiti. Kara gigi maakhadi hari du⁄iyatee daa kooma tafu gu hhou. ");
INSERT INTO bds_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Qatlay Farisaaymokee gwaa kwahhasuusu Yeesu giyaa ilii arimi gimbakee, gi ilahudeesi muuna gosii tuba, “Bere heediki gu lou, hiĩ aloo tletimiisay, hiĩ aloo baraslayi tuba, hadeti da nanguugumisa ina ti miyaa, kara ti hadee da malee slanqasa. Ina hiĩ aloo caahhi tuba, ti konta tlakwaroo!” ");
INSERT INTO bds_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeesu gi kaay sa Farisaaymokee tuba, “Simooni, wana gimba sugu slae kaawaraa ugu.” Simooni gi ilaki⁄isi tuba, “Maarimuu sini kaade.” ");
INSERT INTO bds_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu gi kaay tuba, “Yaa wanay hida cada, gwaa koomee iinanu gu peesay daqa heedi gwaa haymaamisa peesay. Leẽ yaa kona iinaa da dinaari miyaa kooani, kara waku dinaari mibeeri kooani. ");
INSERT INTO bds_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Inay cada koinaa digiraa ilii slanqadi bueemaa iinanu koina, heedikee hari muuna gu hhou giyaati ilamooyimi cada koinaa. Inkoo, tla⁄aã gu hida hhakeesii gu cada, kaloo na slai loi heedikee gwaa ilamooyimu inay?” ");
INSERT INTO bds_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simooni gugi ilaki⁄isi ina tuba, “Goo ilatahhe ti hikira daa ilamooyimi iinaa da didiri na slai loi heedikee.” Yeesu gi kaay sa ina tuba, “Guti lou, haã ilaki⁄isidi naraꞌa.” ");
INSERT INTO bds_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Da hheꞌesi Yeesu gii fookidi daqa hadetiray, gi kaay sa Simooni tuba, “Hadeti gaã antii? Ana gaani ilii day tiꞌii mara googuu, siniĩ qaydiiba maꞌay gu hhuncidaa yeꞌeeroo koi. Inkoo, hadeti hiĩ hhuncidi yeꞌeeroo koi hari hherehheraa kosi haa hinigi buuslidi hari quubu gu saga gosi. ");
INSERT INTO bds_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ugu haniĩ kwahhasuusidiiba hari humbaꞌada. Hadeti qatlay gaani ilii day tiꞌii, ina hiĩ maydiiba humbaꞌamidu yeꞌeeroo koi. ");
INSERT INTO bds_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ugu haã maakhadiiba saga gooi hari du⁄iya. Ina hiĩ maakhadi yeꞌeeroo koi hari du⁄iya da kooma tafu gu hhou. ");
INSERT INTO bds_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Inkoo, ugu sugu slaꞌa kaawaraa ambee, tlakwaroo dosi gimati wa⁄a see, dagaã ilamooyimi, sa gimba hiĩ laqanti slaꞌamuu gu didiri. Heedi doó ilamooyine coko⁄o, yoóti laqana slaꞌamuu coko⁄o.” ");
INSERT INTO bds_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Da hheꞌesi Yeesu gi kaay sa hadetee tuba, “Digiĩ ilamooyimi tlakwaroo doogi.” ");
INSERT INTO bds_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hida hhakira gwaa ibiidee meesaage sliimaa haa ina, hingigi tlaatleesiri maamisu inay haa inay tuba, “Ayi! Yuꞌudaa, hiĩ na miyaa, goótii dahhasa ilamooyiru tlakwaroo?” ");
INSERT INTO bds_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeesu gi kara kaay sa hadetira tuba, “⁄imba doogi, hiĩ ilabuꞌunti igi, waaudi hari qasaw!” ");
INSERT INTO bds_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qariqaaqari gimbakee giyaa ilii cati, Yeesu yaa hhiyuudi, yaay cati hari yaamu haa tongagu paslaapasloo. Ina yaa kakaami Gimba gu Hhou gu Tawaaloo da Iliitleemu. Hida gwaa sliimaa waaree haa ina, ti sirakoomiisee dosi da mibi haa cada, ");
INSERT INTO bds_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","haa tigay angaamaka, daa afiica⁄amisi haa ina gieeri haa daa hhoeemisi ga⁄ay. Tla⁄aã gooinay yaa wanta Mariyaa Magidaleena, daa afiica⁄asi ha Yeesu gieeri fanqu. ");
INSERT INTO bds_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Slime yaa wanta Yoaana hadee da Kuusa, yondimiisay gu didiru gu mara gu mutemi Heroode. Slime yaa wanta Susaana haa tigay wakinay wa⁄a, gwaa iliiaꞌaaꞌawee Yeesu haa sirakoomiisee dosi hari khooslay gooina. ");
INSERT INTO bds_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Letu waka raqa da didiri da hida yaa khaydi daqa Yeesuge yaamu paslaapasloogo. Teꞌesii sigigi kaay ilaꞌaaꞌaatisati tuba, ");
INSERT INTO bds_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dooslimiisay waku yaa waaudi qaymoo dosii sa wincalaakharu kawa pisagaroo dosi. Qatlay giyaa ilii wincalaakhaakhane, pisagaroo waka gi huhuꞌudi amooge. Qariqaaqari dagagi kala⁄ami ha hida, kara cira⁄oo yaagi tosaa khaydi, pisagarotee dagagi tosaa noꞌomi goõ. ");
INSERT INTO bds_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pisagaroo waka gi huhuꞌudi gurumaasiyage, daqa daa iliiwane tipa coko⁄o kilesi. Pisagarotee giyaa ilii tiꞌiti teꞌesii, cirakiray barukee gi sluhhi, sa gimba daqatee yaa kontaaba tipa da kooma naa⁄aruũ. ");
INSERT INTO bds_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pisagaroo waka gi huhuꞌudi tla⁄aã gu slanslawriige. Qatlay giyaa ilii tiꞌiti, slanslawrikee gi cira dinaraaray, gi ilaslaabi barukee. ");
INSERT INTO bds_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kara, pisagaroo waka gi huhuꞌudi hhapee da hhoige dii looi. Pisagarotee gi tiꞌiti, gi dinaraaraydi naraꞌa, goo⁄u gi laqwali ilaa waa mibeeri mibi, hiicataraa da hatira daa daamisi.” Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee kosi, gi kaay hari afoo da didiri sa inay tuba, “Ina gu kooma eaa, akhasiye naraꞌa gimbaki.” ");
INSERT INTO bds_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Qariqaaqari sirakoomiisee dosi da Yeesu gugi maasiri ina tuba, “Maꞌaana da ilaꞌaaꞌaatisatee na mala?” ");
INSERT INTO bds_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ina gi kaay sa inay tuba, “Unkuray dangwaa pihhi caahharaa siiri da Tawaaloo da Iliitleemu. Wakinay sigoóti gimbuumisa hari ilaꞌaaꞌaatimisu. Nama teesaaqay, Iliitleemu gimba gosii ilatahhaahhadi, kaawaraa tuba, ‘Giyoómati khuꞌuniri see, yoó anaaiiba, Giyoómati akhamisiyayi see, yoó caahhiyaaiiba.’ ” ");
INSERT INTO bds_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yeesu gi kara kaay sa inay tuba, “Maꞌaana da ilaꞌaaꞌaatisatee na nahaã: Pisagaroo ti gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pisagarotaꞌa daa huhuꞌudi amooge, ti hida hhakaꞌa pahha goó akhamisee gimba gu Iliitleemu. Teꞌesii Biriisimoo yoóti cira khay haa gi tosaa hiica⁄asi gimbakira muunaiĩ koinaa, maa ba⁄atii ⁄imbiyay haa digigi ilabuꞌuna. ");
INSERT INTO bds_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pisagarotee daa huhuꞌudi gurimaasiya da kooma hhafida hari waꞌay kosi, ti hida hhakaꞌa pahha goó akhamisee gimba gu Iliitleemu haa gugi ooyiyayi hari hhaꞌaloo. Teesaaqay see, yoóyi gunaaba naraꞌa muunaiĩ koinay. Maꞌaana inay ti barukaꞌa pahha, kibeeri kosi goóba muta waꞌayge. Inay giyoóti ⁄imbiyay qoomay coko⁄o kilesi. Qatlay digoó ilii khaye ha koimisu, yoóti mayay ⁄imba gimbakee. ");
INSERT INTO bds_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kara, pisagarotira daa huhuꞌudi slanslawriige, ti ilaꞌaaꞌaatimisu gu hida hhakaꞌa, goó akhamisee gimba gu Iliitleemu, qariqaaqari digoóti ilaslaabi ha bahhangara, hindaqaruumaa haa hhaꞌaloo da khooroti. Inay yoóyi ⁄atliyaaiiba muunainge hari gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Inkoo, pisagarotaꞌa daa huhuꞌudi hhapee da hhoige dii looi, ti hida hhakaꞌa pahha goó akhamisee gimbakee gu Iliitleemu haa gugi karahhasiyay hari muunaiĩ gu hhoi. Inay na hida hhakaꞌa goó hiikaasee hari khisla, ti amoolaa hiica⁄asiyay ⁄aamu gu hhou.” ");
INSERT INTO bds_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeesu gi kara kaay sa inay tuba, “Hhaku heedi goó ooyisa caaꞌasiya, gigi ilakhupisi hari ⁄alu baku gigi qaasi hari sira da buburuu. Caaꞌasiyatee dagoóti qaasi garangaasiyage, hida gwaa hiiguumee waꞌay gu marage, ma aniri cencee. ");
INSERT INTO bds_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hhaku gimba lensee daa yakwi, da maye hiitlaaꞌasa. Kara gimba sliimaa daa tumuqi, dugu hiitlaaꞌasi cenceege ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Inkoo, itatiimisa naraꞌa gimbaki koi sangoó kakaame. Heedikaꞌa gu kooma gimba gu Iliitleemu, ina sugumaa hiiroogisi hari khisla. Kara hikaꞌa goóba caahha gimbakee, giyoómati ilahudeesi see kona gimbakee, dugoóti afii⁄utli daqa dosaa.” ");
INSERT INTO bds_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Teꞌesii iyoo da Yeesu haa hhiee kosi yaagi khayri sa arimaa ina. Inay gwaa hiidahhasiriiba iliisata ina, sa gimba gu raqa da hida da didiri. ");
INSERT INTO bds_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Heedi waku gi kaay sa ina tuba, “Yuꞌudiyaa, iyoo doogu haa hhiee koku khoorooge wanay hiĩ qadimidiri, slaiyay arimaa ugu.” ");
INSERT INTO bds_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeesu gigi ilaki⁄isi inay tuba, “Iyoo dooi haa hhiee koi, ti hida goõ goó akhamisee haa goó iliikoomee gimba gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Letu waka Yeesu yaa hiiday masuwaage sliimaa haa sirakoomiisee dosi. Ina gi kaay sa inay tuba, “Paaree, tlo⁄osanee tlawa da didiri hari bara da cadii.” Da hheꞌesi gi waaudiri. ");
INSERT INTO bds_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Qatlay giyaa ilii hhiyumaamidiyee hari masuwaa, Yeesu yaati qaati. Teꞌesii tlawage daagii ca⁄i ilafahhiya da didiri hari khisla. Masuwatee gi tlaatleesidi haca maꞌay, daati naahhi aloo hiihhanay tlawa da didirige. ");
INSERT INTO bds_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sirakoomiisetee tosi gugi ilii hadakayri ina haa gugii leehhisiri. Inay gi maahhiri, kakaanay tuba, “Maarimuu, Maarimuu tlayii! Dandiray slaꞌana kaka⁄u!” Ina yaagi tosaa hiitlay, gi tosaa ilii⁄oo⁄i ilafahhiyatee da dihhi haa gondadee hhakee gu deni. Cirakiray lenge ilafahhiyatee gi kaanahhasidi sumuku. ");
INSERT INTO bds_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeesu gi maasi sirakoomiisee dosi tuba, “Unkuray ⁄imba dooguna kaale wanta?” Teꞌesii inay gi tlaꞌamuumuudiri haa gi bakairi hari khisla. Inay hingigi tlaatleesiri maamisu inay haa inay tuba, “Yuꞌudaa, hiĩ kara ti miyaa? Ina goó ilafahha ilafahhiya haã gondadee gu maꞌay see, gi akhasiyayi ina!” ");
INSERT INTO bds_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeesu haa sirakoomiisee dosi da mibi haa cada gi dayri hhapee da Wageraasige, daraa bara da cadii waara da tlawa da didiri da Galilaaya. ");
INSERT INTO bds_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Qatlay Yeesu giyaa ilii cacaaca⁄iye waꞌay gu masuwateesaa, hingigi slaslay haa heedi waku gu yaamu hhakee, daa ilii khaabaaꞌadi ha gieeri. Qatlay gu tleedu ina yaa daamaamisiyaaba qayro ma marage see yaa ibidiiba. Ina, maraoo daa khodaadiye sa iliiqamidu tuuꞌuna, ginaa ilii ibimaamidi. ");
INSERT INTO bds_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Heedikee giyaa ilii arimi Yeesu, yaati maahhi, gi keebeeidi pandaa dosii. Ina gi kaay hari afoo da didiri tuba, “Ye Yeesu, Nanku Iliitleemu gu Rawaa gu Idadu Sliimaage Waara, mala kooma haa ugu? Inkoo hagu tlaatlaqasa, hani hhanti labaꞌasida!” ");
INSERT INTO bds_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ina yaati teesaaqay kaay, sa gimba Yeesu yaa ilafahhi gieerimokee, may ca⁄i daqa heedikeesaa. Maꞌaana gieerikee yaati nikiikina ilii khaabaaꞌamidu heedikee. Sirikaarii gwaa koimisiri ga⁄aw, tay gugi khiidiidiniri dabainge haã yeꞌeerooge see hari nyololoo. Teesaaqay see, ina giyaati nikiikina kereꞌemisu nyololotee, dugugi tosaa leehhisi ha gieerimokee kongoqomee naqatloo. ");
INSERT INTO bds_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeesu gi maasi gieerikee tuba, “Uma googu na miyaa?” Gi ilaki⁄isi tuba, “Uma goy na ‘Qici.’ ” Ina yaa teesaaqay kaay, sa gimba inay ti raqa da didiri loi. ");
INSERT INTO bds_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gieerikee gi tlaatleesiri tlaatlaqamisu Yeesu hari khisla, magi may ilafahha, gii guuma kayay bonda gu ilaseguge gu khonsleebaa. ");
INSERT INTO bds_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Teꞌesii raqa da didiri da biinoo yaa wanta, daa deꞌeeꞌema ciyoomooge slaaburaa gu onke. Gieeri hhakee gi tlaatlaqasiri Yeesu tuba, “Hhooa handi ilafahhade, ma iliiguuma kayni biinotaꞌa.” Ina gi teesaaqay laqi, ");
INSERT INTO bds_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","gieeri hhakee yaagii ca⁄iri daqa heedikeesaa, gii guuma kayri daqa biinotiray. Raqatee da biinoo, gii gweegwe⁄eti hari ⁄uuru ilagweegwe⁄eda da dihhigo, gii gunti tlawa da didirige, gi tosaa kaka⁄adi goõ. ");
INSERT INTO bds_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Deꞌemiisetee da raqa da biinoo giyaa ilii anti gimbakee gwaay ca⁄u, gi lakiti tongagu koinay. Inay gi kaawa kayri gimbaki sa hida yaamuge haa qaymamuuge. ");
INSERT INTO bds_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Da hheꞌesi hida hhakee yaagi feꞌediri, ma aniri gimbakee gwaanii ca⁄u. Inay giyaa ilii dayri daqateesii daa iliiwane Yeesu, gi aniri heedikira daa afiica⁄asi gieeri. Ina hiĩ ibiidi ilaciyaa haa yeꞌeeroo gu Yeesu, tay hiĩ daamisi qayroo, kara kona waaway gu hhou! Inay gi tlaꞌamuumuudiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Teꞌesii, hhakee gwaa arimee gimbakee, idoo giyaa ilii ca⁄i, gi ilakeesiri sa deneꞌee koina gimbakee goõ gu heedikee daa ilii khaabaaꞌadi gieeri haã idoo dugwaa ilii hhoeesi. ");
INSERT INTO bds_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hida hhakee gu hhapee da Geraasi giyaa ilii akhasiri teesaaqay, gi tlaꞌamuumuudiri hari khisla. Teesaaqay gi tlaatleesiri tlaatlaqamisu Yeesu, ma waaudi hhapee dooinaa! Yeesu gii day masuwaage sliimaa haa sirakoomiisee dosi, gi tosaa waaudi. ");
INSERT INTO bds_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Heedikira daa afiica⁄asi gieeri, gi tlaatlaqasi Yeesu, ma sliimaa waaudiri haa ina. Teꞌesii Yeesu gugi aareesi, sugugi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Taa⁄a ki⁄e aya googuu, sigi kaawa kayde gimbaki gu didiru diĩ yondiidi ha Iliitleemu daqa dooguu.” Teesaaqay, heedikira gi waaudi, gi tlaatleesi kakaaru yaamu sliimaage gimbakee gu didiru daa yondiidi ha Yeesu daqa dosii. ");
INSERT INTO bds_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Qatlay Yeesu giyaa ilii ki⁄i ina dugwaa kwahhasuusi ha raqa da hida, maꞌaana gonkoinaa gwaati baqaaqamidiyayi ina. ");
INSERT INTO bds_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yuꞌudiyaa, teꞌesii yaagi khay heedi waku, uma gosi naa Yayiroo, ina naa giyaadimiisay gu didiru gu sinagoogi. Qatlay giyaa ilii arimi Yeesu yaani day teꞌesii, gi keebeeidi pandaa dosii, tay gu tosaa tlaatlaqamisi, ma hadakay aya gosii. ");
INSERT INTO bds_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ina yaa teesaaqay yondiidi, sa gimba hotosi da leẽ, daa kooma koraraa mibi haa cada, yaa slaꞌada gwaaꞌaraa! Yeesu giyaa ilii hada kakaakaye, raqa da hida wa⁄a yaagi ilii raagiti ina. ");
INSERT INTO bds_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Inkoo, raqateꞌesii yaa wanta hadee waka, daa ilahufimaamidiye ha ga⁄ay gwii caca⁄uu ceedee slaqwa dosaa koraraa mibi haa cada. Hhaku lensee gwaati hhoeesu ina. ");
INSERT INTO bds_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hadetee yaagi khaydi hari aluũ gu Yeesu haa gi nangusidi somborokimoo gu qayru gosi. Cirakiray lenge ceedetira daa hiicacaaca⁄a gi kereꞌeti sumuku. ");
INSERT INTO bds_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu gi maasi tuba, “Miyaa niĩ nangusi ana?” Hida sliimaa gi kaayri tuba, “Dandiray guũ nangusaniiba.” Peetiro gi kaay tuba, “Looimoo gu Goõ, ugu haã anti, duguũ niini⁄idi haa duguũ iliiraagidi ilaciyaa looi ha hida bareemoo sliimaa.” ");
INSERT INTO bds_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Teꞌesii, Yeesu gi kaay tuba, “Ana haã caahhi diniĩ nangusi ha heedi, haã arimi ⁄uuru hiniĩ afiica⁄i.” ");
INSERT INTO bds_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hadetee giyaa ilii baraslayidi tuba, hiidahhasidaaba nahhadaraa pandaa da Yeesuge, ina yaagi khaydi, tay tosaa dakhadakhada, gi keebeeiti pandaa dosii. Teꞌesii gi ilakeesidi pandaa da hidage, idoo saa nangusidi Yeesu haa idoo dagaa cira ilii hhoeesi. ");
INSERT INTO bds_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu gi kaay tuba, “De hotoyi, igi ⁄imba doogi daqa dooii nigiĩ hhoeesi. Taa⁄a ki⁄e hari qasaw.” ");
INSERT INTO bds_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yeesu giyaa ilii kahhiye cocoꞌomooge haa hadetee, heedi waku yaagi khay mara gu Yayiroogo. Ina gi kaay sa Yayiroo tuba, “Hotoogu hhaka, hiĩ hhanti. Inkoo, maarimuu hagu hhanti labaꞌasana, handii kaaꞌani.” ");
INSERT INTO bds_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Teꞌesii Yeesu giyaa ilii akhasi gimbakee, gi kaay sa Yayiroo tuba, “Hhanti tlaꞌamuta, ugu ⁄uuru gu Iliitleemu na ⁄imbi, hotoogu daga hhoeesi.” ");
INSERT INTO bds_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yeesu giyaa ilii day mara gu Yayirooge, yaa ⁄imbiiba heedi lensee, ma hiiday waꞌay gu marage sliimaa haa ina. Teꞌesii Peetiro, Yohaana haa Yakoobo, sliimaa haa taataa gu sagameeriyatee haa iyoo dosi kilesi nayii guniri waꞌay gu marage. ");
INSERT INTO bds_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Qatlaykeesii hida goõ yaati ⁄aa⁄ii⁄iminay haa tooinaa gaiidiyay sa sagameeriyatee. Yeesu gi kaay sa inay tuba, “Maw ⁄aa⁄imu. Sagameeriyati hiĩ gwaꞌatiiba, hinti qati kilesi.” ");
INSERT INTO bds_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inay gi qasayri Yeesu, sa gimba yaa caahhiri tuba, sagameeriyatee hiĩ hhanti. ");
INSERT INTO bds_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeesu giyaa ilii day waꞌayge, gi ooyi daba gu sagameeriyatee, gi kaay sa ina tuba, “Sagameeriya, tlayii!” ");
INSERT INTO bds_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cirakiray lenge, sagameeriyatee gi slafidi, gi tosii hiitlaydi. Yeesu gi ilafahhi ma saga qay ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taataa haa iyoo dosi giyaa ilii aniri hiĩ slafidi, gi bakairi hari khisla. Yeesu gigii gadimi inay tuba, hhanti kaawa kayay sa heedi lensee gimbakee. ");
INSERT INTO bds_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Letu waka Yeesu gi ⁄oo⁄i sirakoomiisetee daqa lenge. Ina sigigi qay hiidahhasaraa haa sigigi pihhi ⁄uuru gu tawaaloo sarii ca⁄amisuu gieeri daqa hidago haa hiidahhasaraa da hhoeemisu ga⁄ay. ");
INSERT INTO bds_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Da hheꞌesi gigi ya⁄abi, ma kakaaru kayri gimba gu Tawaaloo da Iliitleemu, haa hhoeemisu gu ga⁄iidee. ");
INSERT INTO bds_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Slime ina gigi ilakaay inay tuba, “Hhanti hubitay idoo lensee hhiyuuma doogunay: hhadaa, curuquu, ⁄agoo, peesay ma jurungii da cadii see. ");
INSERT INTO bds_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kara, mara lensee dangoo ilii kwahhasuusiye, laa teꞌesii lenge ibitay, maati amoo waautay yaamu hhakeesaa. ");
INSERT INTO bds_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bere hida maa kwahhasuusiyaaiiba unkuray, gamaa ilii waautee teꞌesaa, lamaati gaagahhaday ceceiya yeꞌeeroo kokunaa. Hatee namaa ilatlawaraa dooguna daqa dooinay.” ");
INSERT INTO bds_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Teesaaqay, hida gu Yeesu gi waaudiri, gii catiri hari tongagu haa tongagu, tay tooinaa kakaaniri Gimba gu Hhou haa hhoeemisu ga⁄iidee daqeemoo sliimaa. ");
INSERT INTO bds_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Inkoo Heroode, mutemi gu hhapee da Galilaaya, gi akhasi gimbakee goõ, daa yondimaamidiye ha Yeesu. Ina saga gosi gi tlakwaakway, maꞌaana hida wakinay yaa kakaakanay tuba, “Yohaana Hiinunqudimiisay dugwaani slafisi yaagii ca⁄i ayisago!” ");
INSERT INTO bds_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wakinay yaa kaayri tuba, “Eliyaa, tletimiisay gu Iliitleemu hindaani iliica⁄i!” Kara wakinay yaa kaayri tuba, “Leẽ tla⁄aã gu tletimiisee da wakaꞌalee, yaani slafi ayisago.” ");
INSERT INTO bds_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroode gi kaay tuba, “Yohaana, ana loi nugwaa afakereꞌesi saga! Inkoo, hikee ti miyaa, gimba gosi ga akhaakhamise?” Ina gi ilakoomi koisa arimaa Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Qatlay ya⁄abimiisetee giyaa ilii ki⁄iri daqa Yeesuge hhiyuuma dooinaa, sugugi ilakeesiri ina gimba sliimaa giyaa yondiidiri. Da hheꞌesi, girigi waaudi inay kilakoina daqa daaba hida yaamu daa eteediidine Betisayda. ");
INSERT INTO bds_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Teꞌesii, raqa da hida giyaa ilii caahhadi daqa giyaa khuꞌusi, gugi sirakoniri. Yeesu gigi kwahhasuusi haa gigi tlaatleesi caacaahhamisu gimba gu Tawaaloo da Iliitleemu. Slime gi hhoeemisi hida gwaa slaee hhoaaꞌaw. ");
INSERT INTO bds_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Inkoo, letu giyaa ilii daadaauusidi hiihuua, sirakoomiisetee da mibi haa cada gi hadakayri daqa Yeesuge, sugugi kaayri tuba, “Tiꞌii ti kweerage wana. Aareesi hida hhanki, ma waaudiri tongagu gu ilaciyaa haa maraai gu qaymamuuge waaree, ma slawaraa kayri ⁄agoo haa daqa da ilii guꞌudee.” ");
INSERT INTO bds_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Teꞌesii Yeesu gigi ilaki⁄isi inay tuba, “Unkuray sigi qaydeei ⁄agoo!” Inay gugi ilaki⁄isiri tuba, “Dandiray mukaatee kooani haa samaakii cada kilesi guni kona. Dandiray, bere hoo mayna kiriga kawa ⁄agoo, buꞌudisidaaba hida hhanki gonkoinaa.” ");
INSERT INTO bds_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hhawatee gwaa waaree, faadoo dooina yaa elefu kooani. Yeesu gi kaay sa sirakoomiisee dosi tuba, “Kaawa sa hida hhanki, ma ibiidiri raqoo gu hida mibeeri koakoani taqaaqay.” ");
INSERT INTO bds_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Inay gi teesaaqay laqiri, hida goõ gi ibiidiri. ");
INSERT INTO bds_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu gii oyi mukaatetira da kooani haa samaakikira gu cada, gi ganaꞌasi ilaa rawaa gu rawge, gi daareesi Iliitleemu sa ⁄agotee. Ina gigi fandakumisi mukaatetee haa samaakikira, gi haymisi sa sirakoomiisee dosi, inay ma hadimisiri sa hida hhakee. ");
INSERT INTO bds_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gonkoinaa gi ⁄aginiri, gi akhaakhaniri. Qatlay giyaa ilii hheꞌesiri ⁄agoo, sirakoomiisee da Yeesu yaagii kurunkuriri ⁄agotira daa meti, gi hacimisiri kapapuu mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Letu waka, Yeesu yaa firiirina Iliitleemu ina lenkosi. Sirakoomiisee dosi yaa ilaciyaa kosii wanay. Teꞌesii gi maasi hida hhakee kosi tuba, “Hida hinoóti kaayay tuba, ana na miyaa?” ");
INSERT INTO bds_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Inay gi ilaki⁄isiri sa ina tuba, “Hida wakinay yoóti kakaanay tuba, ugu na Yohaana Hiinunqudimiisay. Kara, wakinay yoóti kakaanay tuba, ugu na Eliyaa. Slime wakinay yoóti kaayay tuba, ugu ti leẽ gu tletimiisee da wakaꞌalee gu Iliitleemu, naani slafi yaagii ca⁄i ayisago.” ");
INSERT INTO bds_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Da hheꞌesi Yeesu gigi kara maasi inay tuba, “Hari unkuray, hanoóti ilahudeesiday tuba, ana na miyaa?” Peetiro gi tosaa ilaki⁄isi sa ina tuba, “Ugu na Kristu, daa ya⁄abi ha Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Teꞌesii Yeesu gigi ilakaay hida kosi tuba, hhanti kaayay sa heedi lensee gimbakee! ");
INSERT INTO bds_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ina gi ilakoomi kaawa sa inay tuba, “Kwanda Nanku Heedi, dugu labaꞌasiye hari khisla haa dugu siꞌi ha gaduũ gu Yahuudi, haa hhapalooee da deni haa maarimamaa da sariyaa. Ina kwanda dugu gaasiye, kara baloo da tamiige gi tosaa slafi yaagii ca⁄i ayisago.” ");
INSERT INTO bds_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Da hheꞌesi, Yeesu gi kaay sa inay gonkoinaa tuba, “Bere heedi slai sirakooma ana, kwanda gi hiifookidiye gimba gosi giyoó slaiye sirakomamidu, haa geregediye musalaaba gosi, labaꞌasu gosi pahha gu balalu sliimaa, gi asu sirakona ana. ");
INSERT INTO bds_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Heedikaꞌa gu slaꞌa ilabuꞌuru ibinaa dosi, higimaa hhamisi. Heedikaꞌa gu hhamisa ibinaa dosi sa ana, hikee ibinaa dosi gimaa ilabuꞌuna. ");
INSERT INTO bds_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Heedi faydaa mala slay, gimati slay hindaqaruumaa da khooroti sliimaa, tay tosii hhamisi ibinatee? ");
INSERT INTO bds_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Inkoo, bere heedi sini arina ilamuree ana haa gimba gooi, gu lou, Nanku Heedi arina ilamuree sa heedikee. Ina maa teesaaqay laqi, qatlaykiray gimaa ilii khaye hari wanqamee dosi, haa hari wanqamee da Taataa gosi haa malayika doóba tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Teꞌesii Yeesu gi kaay sa raqatee da hida tuba, “Gu lou, wanay hida tla⁄aã googunay, guũ qadimidee tiꞌii, maa kaka⁄iyaaiiba, maati gesaa arinayi Tawaaloo da Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Balalu gweleti taqaaqay giyaa iliicatiri, Yeesu giyaa ilii kaay gimbakee, hirigi waaudi Peetiro, Yohaana haa Yakoobo. Inay sliimaa gi ilakhiinaaꞌadiri cina da onke sa firoo Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Qatlay giyaa ilii firiirine Iliitleemu taysi, kalay gu Yeesu gii fookidi. Qayroo kosi gi ⁄abaakwayri poy, gi tlaatleesiri wanqamee ti amoo celeceleiyay. ");
INSERT INTO bds_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Cirakiray, teꞌesii Eliyaa haa Musaa tletimiisetira da wakaꞌalee da Iliitleemu, yaagii ca⁄iri hari wanqamee da didiri da raw, tay tooinaa cocaiyay haa Yeesu. Inay yaati cocaacoiyay, idoo gi ilii gaasiye yondu gu Iliitleemu, hari amoo da gwaaꞌaraa dosi Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peetiro haa deneꞌee kosi yaati qaaqaatiri, digiĩ ooyi ha guꞌudee day looi. Inay giyaa ilii tlayri guꞌudeego, gi aniri wanqamee da hhoinay gu didiru gu Yeesu, kara hhawatee hhakira cada, hiĩ qadimidiri sliimaa haa ina. ");
INSERT INTO bds_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Qatlay Musaa haa Eliyaa giyaa iliislaiyee waaudimoo daqa Yeesugo, Peetiro gi kaay sa ina tuba, “Ye, Looimoo Goori, ti hhoinay dandiray tiꞌii sliimaa wana. Inkoo tleehhane tiꞌii cuuraiĩ tami, leẽ sa ugu, gu caduu sa Musaa, kara gu tamii sa Eliyaa!” Gu lou, Peetiro yaa caahhiiba gimba giyaa cocaacoiye. ");
INSERT INTO bds_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peetiro giyaa ilii cocaacoiye gimbakee, rawaa koinay dagii ca⁄i tlongiya, digigi ilaslaabi ha mahhatu gu tlongiyatee. Inay digaa ilii ilaslaabi ha tlongiyatee, gi tlaꞌamuumuudiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Afoo yaagii ca⁄adi tlongiyateesaa, kakaanta tuba, “Hiĩ na Nankoy gu leẽ ga slae, gunii leehhi! Akhamisakuna!” ");
INSERT INTO bds_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qariqaaqari afotee giyaa ilii hheꞌesidi kaawaraa gimbakee, hida hhakee gu Yeesu, gi aniri Yeesu hinti meeti ina lenkosi. Qatlaykeesii gimbakee gwaa aniri teꞌesii, gwaa kaayriiba sa heedi lenseei. ");
INSERT INTO bds_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Heetlaalee dosii daa iliipisi, Yeesu haa sirakoomiisetee tosi da tami giyaa ilii ⁄eemaamidiye onko, raqa da didiri da hida hingigi slaslaydi haa ina. ");
INSERT INTO bds_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Teꞌesii heedi leẽ tla⁄aã gu raqateesii, gi maahhi hari afoo da didiri, gi kaay tuba, “Ye, Maarimuu hhooa! Haguũ tlaatlaqasi, yuꞌudii nankoy. Maꞌaana ina na nankoy kilesi gu leẽ. ");
INSERT INTO bds_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌudiyaa, ina dugoóti niki ilii khaabaaꞌamidu ha gieeri haa gi ⁄isina ina, ma maahhami. Kara gieeri hhakee goóti ilii cakhadinay hhapeege, gi ⁄isina kwinkwiisii, dugoóti amoolaa iliica⁄i ha sluubariya afa gosii. Ina goóti ilakona labaꞌasu hari khisla, giyoóti geemay coko⁄o kilesi. ");
INSERT INTO bds_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sirakoomiisee doogu hagaa tlaatlaqasi hari khisla, ma hiica⁄asiri gieeri hhakee, yaa hiidahhasiriiba.” ");
INSERT INTO bds_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu gi ilaki⁄isi raqatee tuba, “Eki, de laqwaloti doóba ⁄imba Iliitleemu haa daa hhamaahhanti! Hati ibiida haa unkuray malaalee naqatloo? Hangutii kaasa malaalee naqatloo? Aare satisaayuu nankoogu tiꞌii!” ");
INSERT INTO bds_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Qaraimokee, qatlay giyaa ilii hada kakaakaye daqa Yeesuge, gieeri gugi ilii cakhadi hhapeege pukhu, hiraagi khay kwinkwiisii daqa dosii. Teꞌesii Yeesu gii ca⁄asi gieeri, gugi hhoeesi qaraimokee gi hhoay, gugi ki⁄isi daqa taataa gosii. ");
INSERT INTO bds_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hida sliimaa, gi bakairi hari khisla qatlay giyaa ilii aniri hiidahhasatee da didiri da Iliitleemu. Hida hhakee, giyaa ilii kahhiyee hinti bakairi sa gimbakee gu didiru, daa yondiidi ha Yeesu, ina gi kaay sa sirakoomiisee tuba, ");
INSERT INTO bds_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Itatiisa naraꞌa, gimbaki sangu slae kaawaraa inkoo. Nanku Heedi dugu taatahhi dabaiĩ gu fa⁄ayaa dosii.” ");
INSERT INTO bds_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Teꞌesii, sirakoomiisee dosi yaa caahhadiiba maꞌaana da gimbakee gu Yeesu. Maꞌaanatee dagaa yakwi ha Iliitleemu daqa dooinay, ma mayri baraslawaraa. Kara inay gi tlaꞌamuudiri maasaraa maꞌaana dosi. ");
INSERT INTO bds_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sirakoomiisee da Yeesu, hingigi tlaatleesiri wariiki⁄imisu inay haa inay tuba, miyaa na heedi gu didiru tla⁄aã gooinay. ");
INSERT INTO bds_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu gi caahhi ilahudaa koina. Teesaaqay, ina yaagii satisi khwaylimoo gu coko⁄u, gugi qadidisi tluntlubaa dosii. ");
INSERT INTO bds_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Da hheꞌesi, gi kaay sa sirakoomiisee dosi tuba, “Heedi gu kwahhasuusa khwaylimoki gu coko⁄u hari uma gooi, ana giniĩ kwahhasuusi. Kara heedi gu kwahhasuusa ana, Taataa goy guniĩ kwahhasuusi, gunaa ya⁄abu ana tiꞌii. Maꞌaana heedi gu coko⁄u tla⁄aã googunay, hikee na didiri tla⁄aã googunay unkuray gonkokunaa.” ");
INSERT INTO bds_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohaana gi kaay sa Yeesu tuba, “Ye, Maarimuu, dandiray haa arini heedi waku, hiica⁄aa⁄amisi gieeri daqa hidago hari ⁄uuru gu uma googu. Dandiray hagugi koisani tlaatlahhasa ina, sa gimba ina gu raqa dooriiba.” ");
INSERT INTO bds_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Teꞌesii Yeesu gi kaay sa inay tuba, “Hagu hhanti tlaatlahhamisiday kara, maꞌaana heedi goóba kanimisu unkuray, hari bara dooguna wana.” ");
INSERT INTO bds_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Qatlay Yeesu giyaa ilii daadaauusi ki⁄eemoo rawge, ina hari muuna gosi, gi yade khuꞌusi yaamu gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ina yaa ya⁄abi ya⁄abimiisee, ma giyaadiri sa ina. Inay gi hadakayri tongoo wakay da hhapee da Samariyaa, ma haraa ilakhuukhuꞌusiri gimba sliimaa sa ina. ");
INSERT INTO bds_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Teꞌesii, hida gu tongotee gi siꞌiri kwahhasuusa ina, sa gimba giyaa hada kakaakaye Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Qatlay sirakoomiisee dosi, Yakoobo haa Yohaana giyaa ilii aniri gimbakee, gugi maasiri ina tuba, “Ye, Looimoo goori, slaꞌadaa ma ya⁄abani aslaa, maa hii⁄eti rawgo, magi hhamisidi?” ");
INSERT INTO bds_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeesu giyaa ilii akhasi gimbakee, gigi ilii fookidi haa gigi ilii⁄oo⁄i. ");
INSERT INTO bds_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Da hheꞌesi, inay gi waaudiri tongoo wakayge. ");
INSERT INTO bds_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Qatlay Yeesu haa sirakoomiisee dosi giyaa ilii khociicinee amooge, heedi leẽ gi kaay sa Yeesu tuba, “Hagu sirakooma ugu daqeemoo sliimaa ga kayde!” ");
INSERT INTO bds_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu gugi ilaki⁄isi ina tuba, “Mondadee konay maraoo gu ilii ibinaa, cira⁄oo konta cuuraiĩ. Nanku Heedi konaaba ma daqa da ilii qaatisa see saga gosi.” ");
INSERT INTO bds_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu gi kaay sa heedi waku tuba, “Hanisirakonte!” Heedikee gi kaay sa ina tuba, “Ye, Looimoo gu Goõ, hani geemayde gesaa, maa qaasi taataa gooi.” ");
INSERT INTO bds_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu gugi ilaki⁄isi ina tuba, “May hhakee goó sisiee ana, muunainge ti tuueenaa pahha, ma qamidiri tuueenaa deneꞌee koina. Ba⁄ay ugu taa⁄a kakaami gimba gu Tawaaloo da Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kara heedi waku gi kaay sa Yeesu tuba, “Ye, Looimoo gu Goõ, hagu sirakooma. Inkoo, hani gesaa geemayde, maa aareesi hida gu aya gooi.” ");
INSERT INTO bds_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu gi kaay sa ina tuba, “Heedi gu tlaatleesa doosla hari kooloo gu kuꞌunaanay, tay gii fookidi sa khuꞌuduũ alunge, hikee haraay boo⁄iiba, Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Qariqaaqari gimbakee giyaa ilii cati, Looimoo gu Goõ Yeesu yaay leehhi hida wakinay mibeeri fanqu haa cada. Ina gigi ya⁄abi cada cada, ma sugu giyaadiri yaamu haa daqeemoo sliimaage, giyaa ilii taarimi dawaraa ina. ");
INSERT INTO bds_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yeesu sigigi kaay inay tuba, “Baruũ gu buꞌuru ti wa⁄a, yondimiisee ti coko⁄o. Inkoo, firima Looay gu Qaymoo, ma ya⁄abi yondimiisee waka qaymoo dosii.” ");
INSERT INTO bds_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ina gi kaay tuba, “Unkuray taa⁄amida, caahha tuba, hanguti ya⁄aba ⁄ambeenay pahha tla⁄aã gu takuraaꞌage! ");
INSERT INTO bds_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Unkuray hhanti hubitay bena gu peesay, curuqu ma ye⁄eetoo gu hiifooka see. Qatlay goo ilii amooge wantee, hhantii ooday qoomay wa⁄a sa cehheemisu heedi lenseei. ");
INSERT INTO bds_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Qatlay goo ilii guntee mara lenge see, looti cehheemisiday gesaa hida gu marakee, gi kaaday tuba, ‘Qasaw gu Iliitleemu wane marakii.’ ");
INSERT INTO bds_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bere heedi gu kooma qasaw wana, qasaw gu Iliitleemu meeti haa ina. Bere hhaku heedi gu teesaaqay slanqasa, dangwaa ilii ki⁄i ha qasawkee. ");
INSERT INTO bds_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kara ibiida marakeesii lenge, danguu ilii kwahhasuusi, ⁄agima haa kitahhama idadu sliimaa sangu hadimisiye. Maꞌaana yondimiisay haraatii boo⁄i slawaraa bueemaa kosi. Hhanti loloyintayi maraai wakinayge. ");
INSERT INTO bds_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Unkuray, qatlay ga ilii guntee yaamu wakinayge, kara hida gu teꞌesa gi ilii kwahhasuusiyee unkuray, ⁄agima ⁄agoo sangu hadimisiye. ");
INSERT INTO bds_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ga⁄iidee da yaamu hhakeesii waara, laga hhoeemisiday. Kara inay sigi kaadee ubee, ‘Tawaaloo da Iliitleemu yaani khaydi daqa doogunay.’ ");
INSERT INTO bds_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Qatlay unkuray goo ilii guntee yaamu wakinayge, looee da teꞌesa gi mayda kwahhasuusa unkuray, lay ca⁄aday balabalaluu koinay, gi kaaday ubee, ");
INSERT INTO bds_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ceceiya da yaamu kokuna see, dingii nakafidi yeꞌeeroo kotii, hagati buuslana, hatee namaa ilatlawaraa doori daqa dooinay. Teesaaqay see, caahha, Tawaaloo da Iliitleemu yaani khaydi daqa doogunay!’ ");
INSERT INTO bds_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gu lou, sangu kaay unkuray ambee, baloteesii Iliitleemu maa ⁄agitina loi hida gu yaamu hhakee ba⁄ay da ⁄agitiru gu yaamu gu Sodomaa see!” ");
INSERT INTO bds_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yeesu gi ilakoomi gimba tuba, “Hoo antayi, hida gu yaamu gu Korasiini haa hida gu yaamu gu Betisayda! Yondu gu denu gwaa bakaꞌasu hida, daa yondiidi daqa doogunay, bere dugwaati aloo yondiidi yaamu gu Tiiroge haa Sidooni, hida gu yaamu hhakee yaa aloo hiifookidiyay daqa Iliitleemuge tlakwaroo dooinaa gu segi. Inay yaa aloo teesaaqay laqiyay, tay hiĩ tooinaa daamisiri guniyayuu haa gi ibiidiyay ⁄urage. ");
INSERT INTO bds_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Inkoo, Iliitleemu gimaa ilii hukune khooroo, unkuray ⁄agitiru googuna gumaa dihhu hari khisla ba⁄ay da hikee see gu hida gu Tiiro haa Sidooni. ");
INSERT INTO bds_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ye, hida gu Kaperinauumu, goo ilatahhadee, dangutii tlaysiyaa raw naqatloo? Teesaaqay gooba! Unkuray dangutii ⁄eetisi khonsleebaa naqatloo.” ");
INSERT INTO bds_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Heedikaꞌa goó itatiimisa unkuray, ana ginoó itatiimisi. Kara heedikaꞌa goó sia unkuray, hikee ana ginoó siꞌi. Slime hikee goó sia ana, ina Iliitleemu ginoó siꞌi, gwaa ya⁄abu ana.” ");
INSERT INTO bds_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Qariqaaqari, hida hhakira gu mibeeri fanqu haa cada yaagi ki⁄iri daqa Yeesuge hari hhaꞌaloo da didiri. Inay sugugi kaayri ina tuba, “Ye, Looimoo goori, gieeri see hindi itatiitimisiyay dandiray, qatlay gi iliica⁄aa⁄amisane hari uma googu.” ");
INSERT INTO bds_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu gigi ilaki⁄isi inay tuba, “Sataanimoo gwaa arimi yaay huui rawaa gu rawgo mankaraaiya pahha. ");
INSERT INTO bds_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yuꞌudaa, sanguu hadisi unkuray ⁄uuru gu tawaaloo daqa Iliitleemugo gurii kala⁄araa deesu haa nyeraw, haa guri kaba⁄araa fa⁄ayaa dooguna. Kara, hhaka idoo lensee dangu ilaqaꞌa. ");
INSERT INTO bds_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Teesaaqay see, hhanti hhaꞌaluumitay, sa gimba gieeri hhakee dangwaani itatiimisi. Unkuray hhaꞌaluumida, sa gimba umaiĩ kokuna digaa handikimi rawaa gu rawge.” ");
INSERT INTO bds_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nama qatlaykeesii lenge, Yeesu yaa hhaꞌaluudi hari khisla hari amoo da Muuna gu Iliitleemu. Ina gi kaay tuba, “Ye, Taataa hagu hhaꞌaleesa, ugu Looimoo gu raw haa khooroo! Gimbaki gwaa yakwidi sa hida gu koomee waaway haa gwaa somimee, gugii tlaaꞌasidi sa hida gu digidakwi. Naraꞌa, Taataa, sa gimba ugu dugwaa teesaaqay muunaboo⁄eesi. ");
INSERT INTO bds_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taataa gooi siniĩ taatahhi idadu sliimaa. Hhaku heedi goó khua Naw naraꞌa, Taataa gosi kilesi nugoó khui. Kara, ma Taataa see hhaku heedi goó khua naraꞌa, Naw kilesi nugoó khui haa hida hhakaꞌa Naw giyoo iliislaiye hiitlaaꞌasa.” ");
INSERT INTO bds_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Da hheꞌesi, Yeesu gi ilii fookidi sirakoomiisee dosi, giyaa ilii inay kilakoina wanee, gi kaay sa inay tuba, “Danguu ⁄aafi unkuray, ilaa kokuna yoó arinayi gimbaki! ");
INSERT INTO bds_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sangu kaay yaa wanay tletimiisee wa⁄a haa watemi, gwaa koomee kwayru gu arimaa gimbakee, ga ariirintee, inay giyaa aniriiba. Slime yaa konay kwayru gu akhamisu gimbaki ga akhaakhamiside unkuray, inay giyaa akhasiriiba.” ");
INSERT INTO bds_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Letu waka, maarimuu waku gu sariyaa da diini da Yahuudi gi qadidi, gi maasi Yeesu hari amoo da koisaraa tuba, “Ye, Maarimuu, hati malee laqa, ma aalimi slafimaa gu koraraa haa koraraa goóba hiifaakoo?” ");
INSERT INTO bds_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu gugi ilaki⁄isi ina tuba, “Sariyaage daa mala handikimi? Hagoó malee sominta?” ");
INSERT INTO bds_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Maarimukee gi ilaki⁄isi Yeesu tuba, “Daa handikimi tuba, ‘Slae Taataa Iliitleemu, Iliitleemu googu, hari ilahudaa koku goõ, hari slafimaa koku goõ, hari ⁄uuru googu goõ haa hari waaway googu goõ.’ Kara, daa handikimi tuba, ‘Slae hida danaee koku, idoo hangu iliislaꞌade gooay ugu lenkoogu.’ ” ");
INSERT INTO bds_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu gi kaay sa ina tuba, “Ugu haã ilaki⁄isidi naraꞌa. Teesaaqay laqe balalu sliimaa, ugu ha ibita koraraa haa koraraa goóba hiifaakoo haa Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Inkoo, maarimukee yaa slai laqaruu tuba, ina kona ibinaa daa tafaꞌadi pandaa da Iliitleemuge, gi maasi Yeesu tuba, “Hari heedi danaꞌa gooi, na miyaa?” ");
INSERT INTO bds_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu gi ilaki⁄isi sa ina tuba, “Heedi waku yaay gweegwe⁄edi Yerusaleemugo, gwaa yaamu gu Yeeriko kakaakawa. Ina giyaa ilii amooge wane, dugugi iliitlai ha fiisiisee. Teꞌesii, gugi afababaciniri qayroo kosi haa gugi difiri, gugi mayri teꞌesii, slai gwaaꞌaraa. ");
INSERT INTO bds_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Inkoo, hhapalooay waku yaagii ca⁄i, yaa khoci hari amotee. Ina giyaa ilii arimi heedikee, yaatii cati hari bara waka da amotee. ");
INSERT INTO bds_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nama teesaaqay, Laawimoo waku slime yaagii ta⁄adi teꞌesii, ina see giyaa ilii arimi heedikee, gii cati hari bara waka da amotee. ");
INSERT INTO bds_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Qariqaaqari daagii ta⁄adi dahaa waku hhapee da Samariyaago, gwaa kooma hhiyuuma dosi hari amotee. Qatlay gwaa ilii arimi heedikee, sugugi arimi slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ina gugi tosaa ilii hadakay, gi hhunci sletu gosi hari difaay haa du⁄iya, gigi khiidiidimi hari dahheemaa. Da hheꞌesi gugii daasi rawaa gu daqway gosii, gugi leehhisi mara gu dahaage, gugi mama⁄eedeesi teꞌesii. ");
INSERT INTO bds_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Heetlaalee dosii daa iliipisi, Samarimokee gii ca⁄asi bena gosaa dinaari cada, gigi hadisi sa heedi gu didiru gu marakee gu dahaa. Ina gi kaay sa ina tuba, ‘Mama⁄eedeesi heediki. Bere peesayki yoo buꞌudiyaaba sa ina, ana qatlay goo ilii ki⁄e hari tia, hagoo bua.’ ” ");
INSERT INTO bds_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Da hheꞌesi, Yeesu gi maasi maarimukee gu sariyaa tuba, “Ilahudaa kokuu, daqa heedikeesii, daa iliitlai haa fiisiisee, miyaa na yondiidi ubee, heedi danaꞌa gosi gu ilaciyaa gu lou, tla⁄aã gu hida hhankii gu tamige?” ");
INSERT INTO bds_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ina gi ilaki⁄isi Yeesu tuba, “Heedikira gwaa ⁄awaarimu sa ina.” Yeesu gugi ilaki⁄isi ina tuba, “Ugu see taa⁄a, la teesaaqay loi yondita.” ");
INSERT INTO bds_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeesu haa sirakoomiisee dosi qatlay giyaa ilii amooge wanee, gii guniri tongoo wakay. Teꞌesii hadee waka, daa eteediidine na Maarita, gigi kwahhaasuusidi mara gosii. ");
INSERT INTO bds_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maarita yaa konta hotooina da coko⁄i, uma gosi naa Mariyaa. Qatlaykee Mariyaa yaati ibiti ilaciyaa haa yeꞌeeroo gu Yeesu, tay gu tosaa itatiimisida. ");
INSERT INTO bds_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Inkoo, Maarita yaa qunceeruti, tay tosaa bahhangaruusida sa yondu gu wa⁄a. Teesaaqay gi ilii hadakaydi Yeesu, sugugi kaadi tuba, “Ye, Looimoo Goorii gu Goõ, haguũ baslii iliiqaasa tuba, hhioo dooi niĩ ilii maydi yonduki sliimaa? Inkoo, saga kaade mani iliiaydi!” ");
INSERT INTO bds_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Looimoo gu Goõ gi ilaki⁄isi Maarita tuba, “De Maarita, Maarita. Igi konta makenkeuumaa hari khisla haa konta bahhangara sa idadu gu wa⁄a. ");
INSERT INTO bds_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Inkoo, wanta idoo leẽ kilesi da kaari. Mariyaa hindii leehhedi idoo da hhoi hari khisla, idotee daga afii⁄utliyaaba.” ");
INSERT INTO bds_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Letu waka, Yeesu yaa daqa wakay wana firiirina Iliitleemu. Qatlay giyaa ilii hheꞌesi firoo, leẽ tla⁄aã gu sirakoomiisee dosii gi kaay sa ina tuba, “Looimoo gu Goõ, handi caacaahhamiside, idoo ga ilii firiirine Iliitleemu, Yohaana Hiinunqudimiisay gooay, idoo giyaa ilii caacaahhamisi sirakoomiisee dosi.” ");
INSERT INTO bds_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu gi kaay sa inay tuba, “Qatlay ga ilii firiirintee kakaama tuba, ‘Taataa, uma googu dugu muriidiye. Tawaaloo doogu yaa khayde. ");
INSERT INTO bds_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Balalu sliimaa sandi hadiside ⁄agoo doori, da balotee. ");
INSERT INTO bds_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Handi ilamooyinte tlakwaroo doori, dandiray see hoó ilamooyina, hhakira goõ goó dakumisee daqa doori. Kara handi hhanti hiilu⁄uda koimisuge, ma dandi hhanti hiidafidi tlakwarooge.’ ” ");
INSERT INTO bds_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Ilahudeesa, bere tla⁄aã googunay, leẽ hadakay daqa danaꞌa gosii hari amasidiira, gi kaay daqa dosii tuba, ‘Ye hhia! Aare sinaa qayde mukaatee tami da iinaa. ");
INSERT INTO bds_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wana danaꞌa gooi gu hhiyumaamida yaanii slakhadi aya gooii. Inkoo ana koomaaba ⁄agoo da haysaraa sa ina.’ ");
INSERT INTO bds_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Danaꞌakee kosi gwaa mara gosii waara gwaagi ilaki⁄isi ina tuba, ‘Hani hhanti ilahufita! Afamaraa duguũ hheꞌesi, duguũ khiidimi! Ana haa yaꞌay koi haã qaaqaatani. Ana hayii dahhasaaba hiitlawaraa, sugugi hadisa idoo lensee!’ ");
INSERT INTO bds_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sangu kaay, bere heedikee gimati may see hiitlawa, haa gi hadisi mukaatee maꞌaana ina ti danaꞌa gosi, sa gimba danaꞌa gosi gwaa ilakoomi firoo hari ⁄atlimaa, hiitlay haa gi hadisi idadu sliimaa gi slaiye. ");
INSERT INTO bds_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Teesaaqay, ana sangu kaawa ambee, ‘Unkuray firiirima Iliitleemu sangu qay ha ina, dabimida ha slayday, guutuumisa, sangu afiiooyina afamaraa.’ ");
INSERT INTO bds_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ina goó firiirima, sugoó qay. Kara ina goó dabiida, yoó slay. Slime ina goó guutuusa afamaraage, sugoó afiiooyina. ");
INSERT INTO bds_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gu lou, wanaa taataa lensee tla⁄aã googunay, hiĩ bere nankosi guũ firimi samaakimoo, ina sugugi hadisi deesu? ");
INSERT INTO bds_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Baku, bere nankosi guũ firimi qanaiya, sugugi hadisi nyeraw? ");
INSERT INTO bds_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Inkoo, gimati unkuray ti hida gu koomee tlakwaroo, ha khuꞌuday hadimisu sa yaꞌay kokuna idadu gu hhoi. Teesaaqay, Taataa goó rawaa gu rawge waara, ilakona hari khisla hadimisu Muuna gosi sa hida hhakee goó firiirime ina.” ");
INSERT INTO bds_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Letu waka, Yeesu yaay ca⁄aa⁄amisi gieeri gu afana⁄ada, gwaa ⁄isimu heedi wakuu gi afana⁄adi. Gieeri hhakee giyaa ilii ca⁄iri daqa dosaa, gi tosaa tlaatleesi cocoꞌomoo. Raqatee da hida yaati bakaꞌadi. ");
INSERT INTO bds_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Teꞌesii, wakinay gi kaayri tuba, “Ina, gieeri giyoótii ca⁄amisi hari ⁄uuru gu Belisebuuli, hiĩ gu didiri sa gieeri goõ!” ");
INSERT INTO bds_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hida wakinay gwaa slaiyay koisa Yeesu, gugi firiniri, ma sigi laqami gimba gu bakaꞌasa gwaa rawaa gu raw dahha. ");
INSERT INTO bds_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Inkoo, Yeesu yaa caahhi ilahudaa koina, gi kaay sa inay tuba, “Bere hida gu hhapee leẽ hingi deehhiniri raqoo haa raqoo, gi qwaqwatlinay, hhapee dooina gi hhamisiyay. Kara, bere hida gu mara leẽ hingii deehhiihhiniri raqoo haa raqoo, ⁄uuru gu hida gu marakee see hiikaaiyaaba, ti faaki goõ. ");
INSERT INTO bds_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bere tawaaloo da Sataanimoo hingi deehhimi ina lenkosi, tawaaloo dosi malee qadita? Ana taqay kakaakama, sa gimba ha kakaakantay tuba, ana hoótii ca⁄amisa gieeri harii dahhasa da Belisebuuli! ");
INSERT INTO bds_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Inkoo, bere guti lou, ana hoótii ca⁄amisa gieeri harii dahhasa da Belisebuuli, hida kokuna see yoótii ca⁄amisiyay gieeri hari hiidahhasa dosi! Teesaaqay, inay loi himaa hukunay unkuray. ");
INSERT INTO bds_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bere ana gieeri giyoótii ca⁄amisa hari ⁄uuru gu Iliitleemu, gimbaki ti laqaaqana tuba, unkuray dangwaani ilii khay ha Tawaaloo da Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yeesu gi ilakoomi gimba tuba, “Heedi gu kooma ⁄uuru, giyoó ilii ga⁄aye aya gosi hari khasima, dugunoó ilii may afanangusa khooslaykee kosi. ");
INSERT INTO bds_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Qatlay heedi waku gu kooma ⁄uuru hari khisla ba⁄ay da ina, bere gwaa iliitlai haa gugi kaba⁄i, kwanda gu afii⁄utliye khasimakee kosi giyoó iliipaꞌane. Da hheꞌesi, gi fiisi khooslay goõ gu waara, haa gigi deehhina sa hida wakinay. ");
INSERT INTO bds_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Heedi gu hhaku hari bara dooi, hikee hinoóti kanimisi. Kara heedi goóba hiikurunkura hida daqa dooii, yoóti pasidimisi. ");
INSERT INTO bds_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Qatlay gieeri giyoó ilii ca⁄iye daqa heedigo, yoóti niini⁄imidi hhapee da kaaruuge, dabiidi daqa da ilii fiifisa. Ina yoó slayaaba daqa, yoóti kaay tuba, ‘Inkoo, ha ki⁄a mara gooii, gaa ilii ibimaamide.’ ");
INSERT INTO bds_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Qatlay giyoó iliiki⁄iye teꞌesii, yoóti slay mara gosi duguũ fiici haa duguũ tlemi naraꞌa. ");
INSERT INTO bds_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da hheꞌesi gieerimoo gi waaudi, hiraagi khay gieeri wakinay fanqu gu tlakwi hari khisla ba⁄ay da ina see. Gieeri hhakee goõ gugi iliigunay heedikee, gi ibiidiyay daqa dosii. Teesaaqay, heedikee ibinaa dosi yoóti tlakwaakwayda hari khisla ba⁄ay da tlaatleesoo see.” ");
INSERT INTO bds_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeesu giyaa ilii giimaamisiye gimbakee, hadee leẽ tla⁄aã gu raqateesaa gi maahhadi, gi kaadi tuba, “Dagaa ⁄aafi hadetaꞌa daay daadi ugu haa gugi ruꞌumisidi!” ");
INSERT INTO bds_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Teꞌesii Yeesu gi ilaki⁄isi tuba, “Hari bara waka, digaa ⁄aafi hari khisla hida hhakaꞌa goó itatiimisee gimba gu Iliitleemu haa gugi iliikonay!” ");
INSERT INTO bds_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Qatlay raqoo gu hida giyaa ilii ilaqinciri ilii kurunkurida Yeesu, ina gi kaay tuba, “Laqwaloti ti laqwaloo da tlakwi hari khisla! Inay ti slaiyay, ma sigi laqami gimba gu kaaru. Inkoo, inay sigi laqanaaba gimba lensee gu kaaru, sigi hikira kilesi laqana gu tletimiisay Yoona.” ");
INSERT INTO bds_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wakaꞌalee Yoona yaa laqami gimba gu kaaru, daa yondiidi daqa hida gu yaamu gu Ninaawige. Teesaaqay, Nanku Heedi see, laqaru gu gimba gu bakaꞌasa tleehhidi daqa laqwalotii. ");
INSERT INTO bds_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Baloo da hukumuu malikiyaa da hhapee da Seeba, maa qadita sliimaa haa hida gu laqwaloti, ina tay gi kaada tuba, laqwaloti daga ilawaamisiye sa dakoo dooina. Malikiyatee, yaa hhiyuti yadaa hhapee da segeẽ loaa, ma itatiisidi waaway gu Solomooni. Inkoo, tiꞌii wana heedi gu didiru ba⁄ay da Solomooni see, teesaaqay see unkuray goó itatiisidaaiiba! ");
INSERT INTO bds_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Slime balotee da hukumuu hida gu Ninaawi, maa qadidiyay sliimaa haa hida gu laqwaloti, gi kaayay tuba, hida gu laqwaloti digi ilawaasiye. Sa gimba hida hhanki gu Ninaawi, qatlay sigaa ilii kaay gimba gu Iliitleemu ha Yoona, gii fookidiri daqa Iliitleemuge tlakwaroo dooinaa! Inkoo, tiꞌii wana heedi gu didiru ba⁄ay da Yoona see! ");
INSERT INTO bds_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hhaku heedi goó ooyisa caaꞌasiya, da hheꞌesi gigi yakwi daqa wakay baku gigi ilakhupisi hari ⁄alu. Bere giĩ ooyisi, giyoóti qaasi rawaa gu kalagaa dosii, hida gwaa hiiguumee waꞌay gu marage, ma aniri cencee. ");
INSERT INTO bds_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ilaa ti caaꞌasiya da slaqwa pahha. Bere ilaa koku guti hhoi, slaqwa doogu sliimaa ti hacida cencee. Bere ilaa koku guti tlakwi, slaqwa doogu gonkosaa ti hacida hhantee. ");
INSERT INTO bds_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Inkoo, hangu khuꞌunte naraꞌa tuba, cencee da daqa dooguu waara hhanti hhantee tleehhita! ");
INSERT INTO bds_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bere slaqwa doogu goõ konta cencee, hhantee see hhaka, ti hacida cencee, qatlay gooay slaqwa goõ, dagoó ilii cencuudisiye ha cencee da caaꞌasiya. ");
INSERT INTO bds_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeesu giyaa ilii hheꞌesi kaawaraa gimbakee, Farisaaymoo waku gugi kwahhasuusi aya gosii sa ⁄agoo. Yeesu gi hadakay haa gi ibiidi ilaciyaa haa meesa, ma ⁄agimi ⁄agoo haa ina. ");
INSERT INTO bds_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisaaymokee gi arimi tuba, Yeesu yaa hhunciiba dabaiĩ kosi ou gooinay, giyaa ilii kahhiye ibinaa meesaage, gi bakai hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Da hheꞌesi, Looimoo gu Goõ sugugi kaay ina tuba, “Unkuray Farisaayoo, hoótii hhunciday qulu⁄uu haa saanii hari khooroo kilesi. Teesaaqay see, unkuray waꞌay gu muunaiĩ kokunay haati hacidiri tlakwaroo haa slahhaahhaau idadu, afii⁄utlidu see ti slaꞌaday. ");
INSERT INTO bds_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Unkuray haa bawmitiri! Iliitleemu gwaa tleehhu idoo haa slaqwa hari khooroo, caba naa tleehhi waꞌay slime? ");
INSERT INTO bds_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Unkuray qaqaw hari muunaiĩ idadu gu waꞌayge waaree sa kwaeeli, yuꞌudiyaa, idadu kokuna goõ digi ilabuusli daqa doogunay. ");
INSERT INTO bds_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hoo antayi, unkuray Farisaayoo! Sa gimba hoó hadimisiday sa Iliitleemu daqa leẽ da mibi da idadu daroó hhandahhandeesiye ⁄agooge haa naanu gu naa⁄a paslaapasloo. Teesaaqay see, hoó iliiqaasidaaiiba haaki haa slaꞌamuu gu Iliitleemu! Hiĩ na gimba gu kaaru gaã aloo yonditee, da hheꞌesi dangugi may afahhama yondiida hikee see waku gu digidaku. ");
INSERT INTO bds_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hoo antayi unkuray Farisaayoo! Sa gimba sinagoogige hoóti slaꞌaday ibinaa kiteeri gu pandaage, haa danguma cehheemisi ha hida hari muree sokooniige. ");
INSERT INTO bds_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hoo antayi, sa gimba unkuray ti ayisasu pahha, doóba arimaa ti ayisasu, doó kala⁄ane ha hida, caahharaa see guba.” ");
INSERT INTO bds_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Cirakiray, maarimuu waku gu sariyaa, gi kaay sa Yeesu tuba, “Maarimuu, ga ilii giimaamiside gimbakee, dandiray see handiiti wahanti slime.” ");
INSERT INTO bds_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu gugi ilaki⁄isi ina tuba, “Unkuray see maarimamaa da sariyaa, Laoo dooguna, sa gimba hida giyoóti ilii tleke⁄emisiday khooslay guy loou, goóba hiidahhasaraa geregedaraa. Kara unkuray loi, hagiyoó iliiaydaaiiba geregedaraa ma hari dinca see! ");
INSERT INTO bds_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hoo antayi, sa gimba unkuray hoó tleehhiday ayisasu gu hhoi gu tletimiisetira, daa cu⁄i ha okookoiĩ kokuna! ");
INSERT INTO bds_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Teesaaqay, unkuray ha ilatlatlaatlayday haa haã ⁄imbidiri gimbakee, daa yondiidi ha okookoiĩ kokuna. Maꞌaana inay naa cu⁄iri tletimiisetee, kara unkuray tlehhaahhitay ayisasu koina. ");
INSERT INTO bds_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sa gimbaki Iliitleemu hari waaway gosi siginaa kaay taqay tuba, ‘Sigi ya⁄aba tletimiisee haa ya⁄abimiisee, wakinay tla⁄aã gooinay gi cu⁄iyay haa wakinay gi labaꞌasiyay.’ ");
INSERT INTO bds_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Inkoo, hida gu laqwaloti, kwanda digi ilii ⁄aa⁄iye ceedeti da tletimiisee goõ, daa cu⁄i, yadaa loaa tlaatleesoo daa ilii tleehhi khooroo. ");
INSERT INTO bds_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Gimbakee, maati tlaatleesi ceedee da Abeeligo da Sakariyaa naqatloo, hiĩ daa gaasi tla⁄aã gu masabaahuge haa mara gu didiru gu Iliitleemu. Gu lou, sangu kaay laqwaloti daga ilii⁄aa⁄i sa gimbakee goõ. ");
INSERT INTO bds_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hoo antayi, unkuray maarimamaa da sariyaa! Sa gimba haa tlaatlahhasidiri hida, ma slayri gimba gu lou gu Iliitleemu. Unkuray ti hida hhakaꞌa pahha goó yakwee fungoo gu afamaraa gu caahharaa Iliitleemu. Kara unkuray see hay guntiriiba hari afamaraki. Hida hhakira gwaa hiiguumaguume, hagiyaa tlaatlahhasidiri, ma mayri hiiguuma.” ");
INSERT INTO bds_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeesu giyaa iliica⁄i khoorooge teꞌesaa, Farisaayoo haa maarimamaa da sariyaa gugi tlaatleesiri kanimisu hari dihhay. Slime inay gugi maamisiri gimba wa⁄a paslaapasloo, ");
INSERT INTO bds_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tay gugi koisiri hatliru, magu ooyiri hari gimba gosi. ");
INSERT INTO bds_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Qatlaykeesii, raqa da didiri da hida yaay kurunkuriirimita daqa Yeesuge, haa yaay roogidiri yaati amoolaa dayri elefafaa. Inay see hingaati kala⁄aniri yeꞌeerooge inay haa inay. Yeesu gi tlaatleesi cocoꞌomoo gesaa haa sirakoomiisee dosi tuba, “Hangu ga⁄aydee haa mahhaaꞌamee da hamiira pahha da Farisaayoo, haã ti peereehhii. ");
INSERT INTO bds_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hhaku gimba lensee daa yakwi, da maye hiitlaaꞌasa ha Iliitleemu. Kara gimba sliimaa daa tumuqi, dugu hiitlaaꞌasi cenceege ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Inkoo, gimba sliimaa gaa cocoꞌodiri hhanteege, dugumaa akhasi cenceege. Kara gimba sliimaa hangaay saasahhamitiri eaa kokunay, duguti kakaana hari afoo da didiri pembebu gu maraaigo.” ");
INSERT INTO bds_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yeesu gi kara kaay sa inay tuba, “Danaee koi, hhanti tlaꞌamutay hida goó cu⁄ee slaqoo kilesi. Qariqaaqari giyoó ilii cu⁄iyee unkuray, hhaka idoo lensee gii dahhasiyee laqaraa! ");
INSERT INTO bds_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Inkoo, unkuray sangu laqama, hikaꞌa guraa hiiboo⁄u magu tlaꞌamutiri. Iliitleemu kilesi na gwaa⁄a! Ina qariqaaqari giyoó ilii ⁄isine hida ma kaka⁄iri, kona ⁄uuru gu hiikwahharaa unkuray aslaa doóba hhamaraa Jehanaamuge! Gu lou, sangu kaay, hikee na gwaa⁄a! ");
INSERT INTO bds_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Cira⁄oo kooani da digidakwi, dagoóti naadinaabaslii hari goboree cada kilesi? Teesaaqay see, Iliitleemu dugoó afahhanaaba, ma cira⁄a lensee! ");
INSERT INTO bds_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gu lou, quubu gu sagaiĩ kokuna see dugwaa faadi. Inkoo, hhanti tlaꞌamutay! Unkuray hanguti kaari ba⁄ay da cira⁄oo wa⁄a see!” ");
INSERT INTO bds_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yeesu gi ilakoomi gimba tuba, “Heedi goó ⁄imba ana pandaa da hidage, Nanku Heedi see gu ⁄imbi pandaa da malayika da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Inkoo, heedi gumaa tlanka ana pandaa da hidage, ana see gumaati tlanka pandaa da malayika da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kara, heedi gu kaawa gimba goó kanimisa Nanku Heedi, Iliitleemu gi ilamooyina ina. Inkoo, heedi gu belendeqesa Muuna gu Iliitleemu, ina dugu ilamooyinaaba. ");
INSERT INTO bds_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Qatlay dangu ilii leehhimisiye pandaa da sinagoogaguuge, hida gu denige haa hida gu tawaalooge, hhanti tlaꞌamutay, idoo ga ilii ilaki⁄imisidee baku idoo ga kaadee. ");
INSERT INTO bds_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Muuna gu Iliitleemu hangu caacaahhamisi unkuray qatlaykeesii loii gimba ga slaꞌade kaawa.” ");
INSERT INTO bds_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Heedi waku raqateesii da hidage, gi kaay sa Yeesu tuba, “Maarimuu, kaay sa hhia gooi gu didiru, manguu deehhani aalimee sandaa may ha taataa goori.” ");
INSERT INTO bds_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu gugi ilaki⁄isi ina tuba, “Hhia, ha miyaa ninaa qaasi, ma ilabuꞌumiisay googuna tleehhidi tla⁄aã googunay?” ");
INSERT INTO bds_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Da hheꞌesi, Yeesu gi kaay sa raqatee da hida tuba, “Yuꞌudiyaa! Hangu ga⁄aydeei haa slahhaahhaau paslaapasloo gu idadu. Maꞌaana slafimaa gu heedi, yoó daqa idadu gu wa⁄a gi kone dahhiyaaiiba.” ");
INSERT INTO bds_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kara, Yeesu sigigi kaay inay ilaꞌaaꞌaatisati tuba, “Hindaqaru waku yaa wana, qaymoo dosi, daa boo⁄odi baruũ hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ina gi ilahudeesi muuna gosii tuba, ‘Hati malee laqaa? Ana koomaaba daqa da iliiqaasa baruki koyi!’ ");
INSERT INTO bds_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Da hheꞌesi hindaqarukee gi kaay tuba, ‘Ha taqay laqa! Hati tlakweemisa kuugiyoo koi gu deni gu qari, haa gi tleehha waka da didiri loi! Teꞌesii hagi qaasa baruũ goõ haa khooslay gooi waku.’ ");
INSERT INTO bds_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Da hheꞌesi ha kaawa muuna gooii ambee, ‘Haã qaasidi idadu wa⁄a gu hhoi gu buꞌudisee koraraa wa⁄a! Inkoo, ti fiifisii kilesi, ⁄agimi, kitahhami haa hhaꞌaluudi!’ ");
INSERT INTO bds_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Teꞌesii, Iliitleemu gi kaay sa ina tuba, ‘Ugu haa bawti! Amasi hhanki, ha gwaꞌata! Da hheꞌesi, idadu goõ giyaa ilakiiki⁄imisidi gu miyaa tleehhidiyay?’ ” ");
INSERT INTO bds_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu gii faakisi hari kaawaraa tuba, “Teesaaqay dagani ilii wana, daqa heedi goó ilakiiki⁄imisa idadu wa⁄a sa ina lenkosi, hikee gu hindaqaru gooba daqa gimba gu Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Sa gimbakee hhanti khoslongoruusiday sa ibinaa dooguna tuba, ha mala ⁄agintay. Kara hhanti khoslongoruusiday sa slaqoo kokuna tuba, ha mala daamisiday. ");
INSERT INTO bds_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ibinaa dati kaari ba⁄ay da ⁄agoo. Kara slaqwa dati kaari ba⁄ay da qayroo! ");
INSERT INTO bds_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilahudeesa gimba gu khwankhwaraara. Inay yoó daamisiyaaiiba pisagaroo ma buꞌuruu see, ma kuugiyoo gu deni see konaaiiba. Teesaaqay see, Iliitleemu giyoó tosaa ⁄agimisi inay. Unkuray hanguti kaari hari khisla ba⁄ay da cira⁄oo! ");
INSERT INTO bds_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Miyaa tla⁄aã googunay sa makenkeuumaa da didiri gu hiidahhasa hiiroogisa ibinaa dosi mati saa leẽ see? ");
INSERT INTO bds_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inkoo, bere hay dahhasidaaiiba laqaraa gimba coko⁄u see da hikee gooay, sa soꞌoyi kontay makenkeuumaa sa gimba waku? ");
INSERT INTO bds_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilahudeesa humbalaalay, idoo giyoó ilii dinaraaraye. Yoó yondiidiyaaba yondu haa yoó boo⁄imisiyaaba qayroo. Teesaaqay see, sangu kaay unkuray ambee, mutemi Solomooni see wanqamee dosi goõ, qayroo kosi gwaa hhoiiba hari khisla da humbalaalaykee gooay! ");
INSERT INTO bds_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Inkoo, Iliitleemu yoó teesaaqay tlemi sluufa gu kweera, humbalaalaykee giyoómati waari see letuti haa heetlaalee dugu tosaa hiikwahhi aslaage. Gu lou, caba Iliitleemu hangu ila⁄utlidimisi hari khisla unkuray? Ye hida gu koomee ⁄imbaraa narabu! ");
INSERT INTO bds_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Teesaaqay, hhanti toodoritay, mala ⁄agintay baku mala kitahhantay. Unkuray hhanti kontay makenkeuumaa gimbakeesii. ");
INSERT INTO bds_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hida gu hhidimee Iliitleemu noó toodoriidiyay idadu hhakeesii goõ. Kara, Taataa googuna gu rawaa gu raw khui tuba, idadu hhakee hagi slaꞌaday! ");
INSERT INTO bds_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Inkoo, dabiida geesaai Tawaaloo da Iliitleemu, ina sanguu roogisi idadu hhakee goõ.” ");
INSERT INTO bds_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeesu gi ilakoomi gimba tuba, “Hhanti tlaꞌamutay, raqa da coko⁄i! Maꞌaana Taataa googuna gu rawaa gu raw, hiĩ arimi ti naraꞌa, qawaraa sa unkuray Tawaaloo dosi. ");
INSERT INTO bds_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Naadima idadu kokuna ga kontee, la hadimisiday peesaykee gaã slaydiri sa kwaeeli. La boo⁄imisiday curuqeeraa goóba faakaraa. Unkuray la qaasiday hindaqaruumaa da loi yade rawaa gu rawge doóba slakuda. Daqateesii fiisiisay yoó hiisatiyaaba ma sekeley see yoó tlakweesiyaaba. ");
INSERT INTO bds_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa gimba daqa da iliiwane hindaqaruumaa dooguna, slime na daqa damaa iliiwane muunaiĩ kokuna. ");
INSERT INTO bds_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Balalu sliimaa hangu ilakhuukhuꞌusidee, yondiida sa Iliitleemu. Kara caaꞌasoo dooguna ilakonee ooyimee. ");
INSERT INTO bds_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Unkuray ti yondimiisetaꞌa tleehhida doó baqamida looimoo gooina, maa ki⁄i losona gu khaboogo. Qatlay gimaa ilii khaye, gi kaay guutee, cirakiray sugumaa afiiooyinayi afamaraa. ");
INSERT INTO bds_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dagaa ⁄aafi tongetaꞌa damaa slaye haa looimoo gooina kahhiyay gu baqamidiyayi. Teꞌesii looimoo dugu muunaboo⁄eesi ha inay. Ana sangu kaawa gimbaki gu lou, ina daasi qayroo kosi gu tongaiimaa haa gi ibiidisi hida sa ⁄agoo, gii satimisi ⁄agoo sa inay! ");
INSERT INTO bds_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dagaa ⁄aafi tongetee, looimoo gimaati khaye see hari amasidiira, baku hari tumpaatumpu, bere giĩ slay inay hinti guuliri sa baqamidu gosi! ");
INSERT INTO bds_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Caahha naraꞌa gimbaki. Bere looimoo gu mara hiti caahhi qatlay daa ilii khaye fiisiisay, hiisee⁄iyaaba mara gosi duguma cihhi ha fiisiisee. ");
INSERT INTO bds_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Slime unkuray see kwanda hangu ilakhuukhuꞌusidee, sa gimba Nanku Heedi, himaati khay qatlay unkuray hangoóba iliipaꞌaru.” ");
INSERT INTO bds_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peetiro gi maasi Yeesu tuba, “Looimoo gu Goõ ilaꞌaaꞌaatisati sandii kaadi, sati dandiray kilesii, baku sati hida goõ?” ");
INSERT INTO bds_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Looimoo gu Goõ gugi ilaki⁄isi ina tuba, “Yondimiisay daa ⁄imbi haa gu kooma waaway, ti hiĩ daa qaasi ha looimoo gosi. Ina, yondimiisay gu didiru tleehhidiye, goó hadimisa ⁄agoo sa yondimiisee waka qatlay daa qaasige. ");
INSERT INTO bds_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dugwaa ⁄aafi tongimokaꞌa, looimoo gosi gimaa iliiki⁄iye hhiyuumago, gugi slay ina yondiidi, yondukira sugwaa taatahhi. ");
INSERT INTO bds_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gu lou, ana sangu kaawa unkuray ambee, looimoo gosi gu qaasi tongimokee, ma wariiqadimidi khooslay gosi goõ. ");
INSERT INTO bds_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Inkoo, ilatahha tongimokee ilahudeesi muuna gosii tuba, ‘Looimoo gooi hindii kaai ki⁄eemoo.’ Da hheꞌesi, ina gi tlaatleesi difoo tongee deneꞌee kosi, gu hhawatee haa gu tigay, tay tosaa ⁄agina haa gi kitahhana, ti amoolaa ooniidi. ");
INSERT INTO bds_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Looimoo gu tongimokee yaati khay, baloo gubasli iliipaꞌaru haa qatlay gi hhidine tongimokee. Teꞌesii, looimokee gutii kerekereꞌemisi tongimokee bareemoo haa bareemoo, haa gugi qaasi raqa lenge sliimaa haa hida goóba ⁄imba. ");
INSERT INTO bds_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tongimokaꞌa goó khua slaꞌamuu gu looimoo gosi, tay hingigi may ilakhuukhuꞌusa, haa gi may yondiida, idoo da iliislaiye gooay ha looimoo gosi, dugu difi hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Inkoo, tongimoo goóba caahharaa slaꞌamuu gu looimoo gosi, giyoó ilii yondiidiye gimba guraay boo⁄u ⁄agitiru, ina duguti difi coko⁄u. Heedi saa hadisi idadu wa⁄a ha Iliitleemu, ina see maa hadisi wa⁄a. Kara heedi saa taatahhi idadu wa⁄a hari khisla, daqa dosaa damaa slai idadu wa⁄a hari khisla.” ");
INSERT INTO bds_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeesu gi kaay tuba, “Ana haati khay tiꞌii khoorooge sa ooyisa da aslaa. Kara, ana hanti aloo slaꞌa arimaa, aslatee dagaã hheꞌesi ooyisaraa! ");
INSERT INTO bds_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Inkoo, ana kooma hiinunqudisa da labaꞌasu, gurinaay boo⁄u ana magu ooyi. Kara ibinaa dooi dati maana da didiri, maati amoolaa hiigaasa hiinunqudisatee! ");
INSERT INTO bds_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Unkuray goo ilatahhadeei, ana hanti khayii sa leehhisa da qasaw khoorotii? Teesaaqay gooba! Ti qasaw gooba, ti hiidehhidu hida. ");
INSERT INTO bds_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Qatlaykaa gu inkoogo, tla⁄aã gu hida kooani gu mara leẽ, hida tami hingi kanimisiyay haa hida cada. Kara hhakee see gu cada hingi kanimisiyay haa hhakee gu tami. ");
INSERT INTO bds_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taataa hingi deehhina haa nankosi, kara nankosi see hingi deehhina haa taataa gosi. Yaayii hingi deehhinta haa hotosi, kara hotosi see hingi deehhinta haa yaayii dosi. Kumboꞌoo hingi deehhinta haa hadee da nankosi, kara hadee da nankosi see hingi deehhinta haa kumboꞌoo dosi.” ");
INSERT INTO bds_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Slime Yeesu gi kaay sa raqatira da hida tuba, “Qatlay goó ilii antee tlafoo, hindii ca⁄iri bara da ilacindoo gu biraage, gu lou hoóti kaaday tuba, ‘Tlubay tlubi,’ gu lou dagi tlubi. ");
INSERT INTO bds_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kara, bere hoó antayi caaqwa da bara da wayee fahhanta, hoóti kaaday tuba, ‘Hameeriya yoo wanta,’ kara yoóti teesaaqay. ");
INSERT INTO bds_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Unkuray peereehhiiseti! Gu lou, unkuray khuꞌuday naraꞌa, idoo khooroo haa raw hingoó ilii laqanee. Inkoo, danguri malee slanqadi caahharaa diqimi gu balalu hhankii gu inkooge? ");
INSERT INTO bds_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Unkuray kilakokuna soó soꞌoyi mayday hukuruu gimba gwaa tafau gu yondu? ");
INSERT INTO bds_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Qatlay ga ilii kahhade amooge haa fa⁄ayaa googu, hiĩ gu leehhisa ugu pandaa da hakiimuuge, karahhi mangu wariiakhasidiri haa ina. Bere malee, dugu leehhisi pandaa da hakiimuuge. Kara, hakiimukee gu taatahhi daqa sirikaarimooge, ina gugii lu⁄i jeerage. ");
INSERT INTO bds_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ugu sunguũ kaay ambee, etaa hiica⁄adaaba jeerago, ti geesaa hheꞌesida bueemaa goboriya da hiifaakoo loi!” ");
INSERT INTO bds_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Inkoo, qatlaykeesii lenge, hida wakinay yaa wanay, gwaa kaawee sa Yeesu, gimba gu Galilaaya wakinay Pilaatu giyaa cu⁄i. Qatlay giyaa ilii hadiidimisiyee sadaaka dooina sa Iliitleemu, hida hhakee digaa isooqutlidi, ceedee dooina dagaa hiiroogi haa sadaaka dooina. ");
INSERT INTO bds_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Teꞌesii, Yeesu gi ilaki⁄isi inay tuba, “Unkuray ga ilatahhadee, Galilaayatee daa labaꞌasi teesaaqay gwaaꞌaraa naqatloo, naa konaaii tlakwaroo hari khisla, ba⁄ay da Galilaaya wakinay? ");
INSERT INTO bds_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Suti! Gu lou, sangu kaay, unkuray see bere hanguba kwahharaa tlakwaroo dooguna, gonkokunaa danguti hhamisi da inay gooay. ");
INSERT INTO bds_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kara hida hhakira gu mibi haa gweleti, daa ilii huui ha tlankoo yade Siloaamuge, gi kaka⁄iri. Unkuray ga ilatahhadee inay kilesi naa konaaii tlakwaroo hari khisla, ba⁄ay da hida sliimaa gwaa ibimaamidee Yerusaleemuge? ");
INSERT INTO bds_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Suti! Gu lou, sangu kaay, unkuray see bere hanguba kwahharaa tlakwaroo dooguna, gonkokunaa danguti hhamisi da inay gooay.” ");
INSERT INTO bds_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Da hheꞌesi Yeesu sigigi kaay inay ilaꞌaaꞌaatisati tuba, “Heedi waku yaa kona ⁄ancimoo qaymoo dosii da sabiibuge. Letu waka ina gi hadakay, ma wee⁄i ⁄aamu gu khaimokee. Teesaaqay see, yaa slayiiba ma lensee. ");
INSERT INTO bds_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Heedikee gi kaay sa yondimiisay gu qaymoo dosi tuba, ‘Yuꞌudiyaa! Qoomay gu koraraa tami ana haani khakhay, sa we⁄inay gu ⁄aamu ⁄ancimokaa, inkoo naqatloo haã slayiiba ma lensee. Inkoo, sa soꞌoyi ilakona tlakweemisu gu hhapee diitiray? Ba⁄ay hiti tlatlafaku sumuku.’ ");
INSERT INTO bds_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Teꞌesii, yondimiisaykee gu qaymoo gugi ilaki⁄isi ina tuba, ‘Looimoo goy, hagu hhanti tlatlafana, mayku koriki kilesi, ana hagu iladoosla haa gu iliikuꞌumisa chuukuroo. ");
INSERT INTO bds_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kori gwaa khawa bere maa boo⁄i ⁄aamu, naraꞌa! Bere gumaaba boo⁄araa, asu tlatlafaku sumuku.’ ” ");
INSERT INTO bds_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Inkoo, baloo da Sabaatoge Yeesu yaa caacaahhaahhamisi sinagoogi wakay. ");
INSERT INTO bds_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yuꞌudiyaa, hadee leẽ yaa wanta teꞌesii daa ilii khaabaaꞌadi ha gieerimoo, qoomay gu koraraa mibi haa gweleti. Hadetee danda gosi yaatii khongoi, yaa hiidahhasidiiba tafaꞌa ma coko⁄o seei. ");
INSERT INTO bds_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Qatlay Yeesu giyaa ilii arimi hadetee, gigi eteedi, maa khaydi pandaa dosii, sagagi kaay tuba, “Igi digiĩ gweedi ga⁄ay googaa.” ");
INSERT INTO bds_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Da hheꞌesi, Yeesu gii qaasi dabaiĩ kosi daqa hadeteesii, cirakiray gi qaditi, gi tafaꞌadi cuti. Hadetee gi tlaatleesidi daareesa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Teꞌesii, giyaadimiisay gu didiru gu sinagoogi, gi slahhaai, sa gimba Yeesu yaa hhoeesi hadetee baloo da Sabaato. Giyaadimiisaykee gi kaay sa raqa, daa hiikurunkuriti teꞌesii tuba, “Wanay balalu lahhoꞌo gu yondu. Inkoo bere slaꞌaday, khakhawaa balalu hhakeesii, ma dangu hhoeemisi ga⁄ay googuna. Haa hhanti khayday baloo da Sabaatoge.” ");
INSERT INTO bds_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Teꞌesii, Looimoo gu Goõ, gigi ilaki⁄isi inay tuba, “Ye peereehhiisee! Ti miyaa tla⁄aã googunay baloo da Sabaatoge, goó mawa gweedaraa slee dosi baku daqway gosi qwaamaago, gigi leehhisi wa⁄amuuge sa waw? ");
INSERT INTO bds_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inkoo, hadeti da motoliya da Aburahaamu, Sataanimoo giyaa khiidimi hari ga⁄ay gu tlaku koraraa mibi haa gweleti. Ti naraꞌaabaslii gweedaraa ina khiidimoo gu ga⁄aykaa, gimati baloo da Sabaato?” ");
INSERT INTO bds_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Qatlay Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee, hhakira gwaa kaniinimisee ina, digigi ooyi ha ilamuree hari khisla. Hida wakinay goõ gi hhaꞌaluumidiri hari khisla, sa gimba sliimaa gu hhou giyaa yondimaamidiye. ");
INSERT INTO bds_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Da hheꞌesi, Yeesu gi kaay tuba, “Ilahudeesa, Tawaaloo da Iliitleemu malee slanqasida? Kara hagari mala ilaꞌaaꞌaatisa? ");
INSERT INTO bds_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tawaalotee da Iliitleemu pisagariya da haradaali pahha, daayii oyi ha heedi waku haa gigi daasi qaymoo dosii. Pisagariyatee gi tiꞌiti, gi khaimoo gu didiru tleehhiti. Cira⁄oo gi tleehhedi cuuraiĩ koina daqa elemu kosii.” ");
INSERT INTO bds_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu gi kara kaay tuba, “Ilahuudeesa, Tawaaloo da Iliitleemu haguri mala ilaꞌaaꞌaatisa? ");
INSERT INTO bds_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tawaalotee da Iliitleemu ti hamiira pahha slanqasi, daa hiioy ha hadee waka, gigii roogidi sliimaa haa debabuu tami gu gubaraa gu ganoo, da hheꞌesi gubarakee goõ gi tosaa sluufi.” ");
INSERT INTO bds_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Da hheꞌesi, Yeesu yaa ilakoomi hari hhiyuuma dosi da Yerusaleemu kawa. Ina yaa hiicacati hari yaamu haa tongagu paslaapasloo, tay tosaa caacaahhamisi hida gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Heedi waku gugi maasi ina tuba, “Looimoo gu Goõ, ti hida coko⁄o kilesii damaailabuꞌune ha Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Teꞌesii, Yeesu sigigi kaay inay tuba, “Maguumida gonkokunaa hiiguumaraa, Tawaaloo da Iliitleemuge hari afamaraa gu hiidigidaaku. Sa gimba, sangu kaay unkuray ambee, hida wa⁄a maa koimisiyay hiiguma tawaaloteesii, maa hiidahhasiyaaiiba coko⁄o see. ");
INSERT INTO bds_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Qatlay looimoo gu mara gimaa ilii qadidiye haa gi khiidina afamaraa, unkuray hamaa khoorooge metay. Teꞌesii, hamaa tlaatleesiday kuukukhumisu afamaraa, tay kakantay tuba, ‘Ye looimoo gu mara, sandi afiiooyinte afamaraa.’ Ina sangumaa ilaki⁄isi tuba, ‘Ana hangu hhidima unkuray, haã daqa gaa dahhadee see.’ ");
INSERT INTO bds_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Teꞌesii unkuray sugumaa tlaatleesiday kakaaru ina tuba, ‘Dandiray haa ⁄agini haa kitahhani sliimaa haa ugu, kara ugu haa caacaahhamisidi tongagu kotii.’ ");
INSERT INTO bds_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kara, ina maa ilaki⁄isi unkuray tuba, ‘Ana hangu hhidima haã daqa gaa dahhadee see. Waauda tiaa daqa dooaa unkuray goó yondiidee tlakwaroo!’ ");
INSERT INTO bds_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Taysi unkuray hamaati ⁄aa⁄aday haa hamaati tluꞌuntay ⁄atloo kokuna hari slahhaaꞌamee da didiri. Maꞌaana qatlaykee hagumaa arintayi Aburahaamu, Isaaka, Yakoobo haa tletimiisee goõ da Iliitleemu, wanay Tawaaloo da Iliitleemuge, tay unkuray danguũ kwahhi ha Iliitleemu khoorooge! ");
INSERT INTO bds_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Da hheꞌesi, hida maa khayay ilacindoo gu rawaago haa ilacindoo gu biraago, goraago haa wayeego. Inay maa ibiidiyay meesaage sa ⁄agoo losona gu Tawaaloo da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kara yuꞌudaa! Wanay hida gu hiifaakooge waaree himaa hida gu pandaa tleehhidiyay, kara hida gu pandaage waaree himaa hida gu hiifaakoo tleehhidiyay.” ");
INSERT INTO bds_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Qatlaykeesii loi loii, Farisaayoo wakinay gi hadakayri daqa Yeesuge. Inay sugugi kaayri tuba, “Waaudi tiaa, taa⁄a daqa wakayge, sa gimba Heroode slai gaasaraa ugu.” ");
INSERT INTO bds_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Teꞌesii, Yeesu sigigi ilaki⁄isi tuba, “Taa⁄amida kaawa sa mondokee ubee, ‘Yuꞌudiyaa, letuti haa heetlaalee ana ha hiica⁄amisa gieeri daqa hida daa iliikhaabaꞌamidigo haa hoo hhoeemisa ga⁄iidee. Baloo da tamiige hoo asu hiifaakisa yondu goy.’ ");
INSERT INTO bds_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Teesaaqay see, ana kwanda ga ilakoome hari hhiyuuma doyi letuti, heetlaalee haa bolatiray. Ana kwanda ga teesaaqay laqe, sa gimba hiti naraꞌaaba tletimiisay duguma gaasi daqa wakay kenga gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","De, Yerusaleemu, Yerusaleemu, doó cu⁄a tletimiisee da Iliitleemu, haa gi cakhadinta hari tle⁄eẽ hhakira daa ya⁄abi daqa doogii! Kara ti waa maka ana haa slaꞌa hiikurunkura yaꞌay koki, konkiya gooay idoo giyoó ilii kurunkuride concaa dosi biraa gu hhababeeraa kosii. Teesaaqay see, unkuray haa siꞌidiri! ");
INSERT INTO bds_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yuꞌudaa! Unkuray sliimaa haa yaamu kokuna danguũ may makeebauumaage. Gu lou, sangu kaay, ana hanimaa antaaiiba kara, qatlaykaꞌa naqatloo gamaa ilii kaadee tuba, ‘Dugwaa ⁄aafi hikee gwaa khawa hari uma gu Looimoo gu Goõ.’ ” ");
INSERT INTO bds_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Inkoo, baloo waka da Sabaato, Yeesu dugwaa kwahhasuusi sa ⁄agoo, mara gu giyaadimiisay lenge gu Farisaayoo. Qatlay Yeesu giyaa ilii teꞌesii wane, hida daa kwahhasuusi, gwaati khuꞌuuꞌunay hari diliqimaa. ");
INSERT INTO bds_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yuꞌudaa, pandaa da Yeesuge yaa wana heedi leẽ, gwaa kooma ga⁄ay gu laafimidu slaqwa sliimaa. ");
INSERT INTO bds_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu gi maasi Farisaayoo haa maarimamaa da sariyaa tuba, “Ti kitlakuu sariyaage hhoeemisu hida baloo da Sabaatoge, baku ti kitlakuuba?” ");
INSERT INTO bds_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Inay gi qabiri diĩ. Da hheꞌesi Yeesu gii qaasi daba gosi daqa ga⁄iidaykeesii haa gugi hhoeesi, gugi may, ma waaudi. ");
INSERT INTO bds_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Inkoo, bere leẽ tla⁄aã googunay nankosi baku slee dosi hingii huuꞌudi wa⁄amuge, gii ca⁄asiyaabaslii ciraai gimati baloo da Sabaato?” ");
INSERT INTO bds_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kara, inay yaa hiidahhasiriiba ilaki⁄isa gimbaki gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Qatlay Yeesu giyaa ilii arimi dahaa, idoo giyaa ilii lehhaahhidiyee kiteeri gu koomee muree losonage, sigigi kaay ilaꞌaaꞌaatisati tuba, ");
INSERT INTO bds_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bere duguũ kwahhasuusi ha heedi waku losona gu khabooge, hhanti ibita kiteeri gu koomee muree. Angamalee ina hiĩ kwahhasuusi heedi gu muree hari khisla ba⁄ay da ugu see. ");
INSERT INTO bds_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bere ha teesaaqay laqada, hikira guũ kwahhasuusu unkuray cada kokunaa, yaa khay daqa dooguu haa sugugi kaay tuba, ‘heediki may ma ibiidi kitiĩ googuu.’ Teꞌesii, ugu dugu ooyi ilamuree hari khisla. Hagi asu ibinaa kayda alunge daqa dabaslige muree. ");
INSERT INTO bds_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ba⁄ay bere duguũ kwahhasuusi losonage, hiti ibiidi kiteeri gu alunge. Qatlay hikira guũ kwahhasuusu ugu giyoo ilii khaye, sugugi kaay tuba, ‘Ye danaꞌa goy, khoca tay pandaage, daqa da hhoige.’ Hari amotee ha slayda muree pandaa da dahaa gonge, gu waaree teꞌesii sliimaa haa ugu. ");
INSERT INTO bds_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Heedi gungoó hiitlaysa ina lenkosi, hikee dugu hii⁄eetisi ha Iliitleemu. Kara, hikaꞌa gungoó hii⁄eetisa, hikee dugu hiitlaysi ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Da hheꞌesi, Yeesu gi kaay sa heedikee gwaa kwahhasuusu ina tuba, “Bere ha ⁄isinta losona hari tleemaa baku hari khwayaiĩ, hhanti kwahhasuusida deneꞌee koku, hhiee koku, hiidayuuma doogu haa hindaqeeri goó ilaciyaa ibiidee haa ugu. Bere ha teesaaqay laqada, inay see hiidahhasiyay kwahhasuusa ugu ayeemaa koinay. Hari amotee ugu dugu bui gimbakira goõ sigaa yonditi inay. ");
INSERT INTO bds_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bere ha ⁄isinta losona, hiti kwahhasuusi hida da hhankaa gooay gu kwaeeli, hida gu koomee sletu, hida gwaa tlakwaakwawee haa gwaa ilahhamaahhamee. ");
INSERT INTO bds_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gu lou, hari amotee ugu dugu ⁄aafi, sa gimba hida da hhakee gooay konaaiiba idoo dari buaraa ugu. Teesaaqay, Iliitleemu maa bui ugu, qatlaykaꞌay hida gu koomee ibinaa daa tafaꞌadi gwaa kaka⁄ee, gimaa iliislafiyee.” ");
INSERT INTO bds_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Qatlay heedi leẽ tla⁄aã gu hhakiray gwaa waaree meesaage haa ina, giyaa ilii akhasi gimbakee, gi kaay sa Yeesu tuba, “Duguũ ⁄aafi heedikaꞌa gumaa ⁄agima losona gu Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Teꞌesii, Yeesu gugi ilaki⁄isi tuba, “Heedi waku yaa ⁄isimi losona gu didiru, gi kwahhasuusi hida wa⁄a. ");
INSERT INTO bds_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Qatlay gu losona giyaa ilii buꞌudi, gi ya⁄abi tongimoo gosi, ma kaawaraa kay sa hhakira daa kwahhasuusi tuba, ‘Kwahhasaa, gimba sliimaa gu losona duguũ buꞌudisi.’ ");
INSERT INTO bds_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Inay gonkoinaa gi tlaatleesiri kakaaru gimba gooina, sa soꞌoyi mayay dawaraa losonage. Teesaaqay see, gimbakee yaati laqami tuba, yaa slaiyaaiiba dawaraa losonage. Heedi gu pandaa gi kaay sa tongimokee tuba, ‘Ana haã kirigi qaymoo, kwanda ga arimaa kawe, hhooa hani ilamooyinte.’ ");
INSERT INTO bds_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Heedi waku gi kaay tuba, ‘Ana haã kirigi yakway mibi gu doosla. Inkoo, hagiri koisakaw doosla, hhooa hani ilamooyinte.’ ");
INSERT INTO bds_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Heedi waku gi kaay tuba, ‘Ana haã khabimi, teesaaqay haay dahhasaaba khawaraa losonage.’ ");
INSERT INTO bds_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tongimokee yaagi ki⁄i, gi kaay sa looimoo gosi gimbakee sliimaa. Teꞌesii, looimokee gu mara gi slahhaai hari khisla. Ina gi kaay sa tongimoo gosi tuba, ‘Taa⁄a ciraai balabalaluuge haa amamu gu hiicohhige gu yaamu hhakee, laraa khayda tiꞌii kwaeeli, hida gu koomee sletu, gwaa ilahhamaahhamee haa gwaa tlakwaakwawee.’ ");
INSERT INTO bds_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Qariqaaqari coko⁄o, tongimokee gi kaay sa looimoo gosi tuba, ‘Looimoo goy, gimba siniĩ kaadi haguũ yondiidi. Daqa kahhada wanta sa hida wakinay see.’ ");
INSERT INTO bds_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Teꞌesii, looimokee gi kara kaay sa tongimoo gosi tuba, ‘Taa⁄a kara, balabalaluuge haa amamu gu digimi gu tongagu naqatloo. Hida goo slayde, ligaa hiitlahhasida maa khayri tiꞌii, mara goy ma haci dahaa. ");
INSERT INTO bds_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gu lou, unkuray sangu kaay, wanaaba lensee tla⁄aã gu hhakiray daa kwahhasuusi, gumaa naafa losona goy.’ ” ");
INSERT INTO bds_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kara, raqa da didiri da hida yaa hhiyumaamita sliimaa haa Yeesu. Ina giyaa ilii fookidi inay, gi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Heedi gwaa slaꞌa khawaraa daqa dooii, hiidahhasiyaaba sirakoomiisay goy tleehhida, bere ina guba wakaraa taataa gosi haa iyoo dosi, hadee dosi haa yaꞌay kosi, hhiee kosi gu hhawatee haa gu tigay, gimati ibinaa dosi ina loi. ");
INSERT INTO bds_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kara, heedi goóba hiiowaraa musalaaba gosi haa naagi sirakona ana, hikee hiidahhasiyaaba sirakoomiisay goy tleehhida. ");
INSERT INTO bds_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Maꞌaana, ti miyaa tla⁄aã googunay, qatlay gi iliislaiye tlehhinay kitaraa, goóba ibiida haa gi faadi bueemaa, ma arimi bere kona peesay gu buꞌudisa hiigaasa tlehhinay? ");
INSERT INTO bds_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bere teesaaqay laqiyaaba, gimaa hheꞌesi tlehhinay musingi, haa dugurigi slanqadi hiigaasa tlehhinaykee. Teꞌesii hida goõ gumaa arimee, gumaati qasaasayay, ");
INSERT INTO bds_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tay kakaanay tuba, ‘Heediki yaa tlaatleesi tlehhinay, dugurigi slanqadi hiigaasa.’ ");
INSERT INTO bds_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Inkoo, ilahudeesa mutemi gu waauda sa qwatla kawa gau haa mutemi waku. Ina ibiidiyaabaslii gesaa, gi ilatahhi hari maguuma, bere hiidahhasi qwatla gau haa hikira gu koomaa sirikaarii elefu mibeeri cada, qatlay ina ti kona sirikaarii elefu mibi? ");
INSERT INTO bds_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bere hiidahhasiyaaba, cirakiray ina ya⁄abi ya⁄abimiisee, ma tlaatlaqasa kayri mutemikira gu caduu, gi ilii kahhiye segenge, mangu wariiakhasiri. ");
INSERT INTO bds_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Teesaaqay, hhaku heedi lensee tla⁄aã googunay, gu hiidahhasa sirakoomiisay goy tleehhida, bere guba mawaraa idadu sliimaa gi kone. ");
INSERT INTO bds_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Cakhasaa ti idoo da hhoi hari khisla. Inkoo, bere cakhasaa hiĩ hhamisidi cuuꞌu gosi, miyaa nii dahhasi ki⁄isaraa cuuꞌukira kosi? ");
INSERT INTO bds_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cakhasatee dati hhoiiba, gimati sa hhapee baku gimati sa upa gu cuukuroo see. Teesaaqay dagati kwahhi segenge loii. Heedi gu kooma eaa, akhasiye naraꞌa gimbaki.” ");
INSERT INTO bds_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Inkoo, karaanimaiĩ wa⁄a gu koodi haa hida wakinay wa⁄a gu koomee tlakwaroo, gonkoinaa yaa khakhaakhayay, ma itatiimisiri caacaahhamisu gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Teꞌesii, Farisaayoo haa maarimamaa da sariyaa da diini yaa tlaatleesiri quru⁄umoo, tay tooinaa kakaanay tuba, “Yuꞌudaa, heediki kwahhasuusumisi hida gu koomee tlakwaroo, kara sliimaa ⁄agiigina haa inay.” ");
INSERT INTO bds_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Da hheꞌesi, Yeesu sigigi kaay ilaꞌaaꞌaatisati tuba, ");
INSERT INTO bds_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ilahudeesa heedi leẽ tla⁄aã googunay kona bee⁄u miyaa leẽ. Bere ina hiĩ hhamisi leẽ tla⁄aã gooinaa, hiti malee laqi? Ina hiti may hhakee gu mibeeri gweleti haa gweleti hatlige, gi dabiidukay hikira gu leẽ, gwaati amoolaa slay. ");
INSERT INTO bds_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Qatlay goo iliislaye, ina gwaatii tleke⁄esi kwahhu kosii hari hhaꞌaloo, ");
INSERT INTO bds_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","guraagi khay ayage. Teꞌesii, ina hiti eteedi deneꞌee kosi haa hida goó ibiidee ilaciyaa haa ina, sigigi kaay tuba, ‘Inkoo hhaꞌaluumida sliimaa haa ana, sa gimba bee⁄imokira koyi guũ hhamu hagwaani slay!’ ");
INSERT INTO bds_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sangu kaay unkuray ambee, nama teesaaqay, Iliitleemu haa malayika dosi maa hhaꞌaluumidiyay sa heedi leẽ gu kooma tlakwaroo, gwaanii fookidu daqa Iliitleemuge. Hhaꞌalotee damaa didiri ba⁄ay da hatira da hida mibeeri gweleti haa gweleti, gungoó hiiarimee konay ibinaa daa tafaꞌadi. Teesaaqay yoóti ilahudeemisiyay tuba, konaaiiba gimba saa hiifookidiyee daqa Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kara, Yeesu sigigi kaay ilaꞌaaꞌaatisa waka tuba, “Ilahudeesa hadee leẽ da kooma goboree mibi da peesay. Bere hiĩ hhamisidi leẽ, hiti malee laqada? Ina hiti ooyisida caaꞌasiya, gi fiicida mara gosi haa gi dabita hari maguuma giti amoolaa slayda. ");
INSERT INTO bds_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Qatlay giyoo ilii slayde, ina hiti eteta hhinanu kosi haa hida goó ibiidee ilaciyaa haa ina, sigigi kaada tuba, ‘Inkoo, hhaꞌaluumida sliimaa haa ana, sa gimba goboriyatira toyi diĩ hhanti, hagaã slay!’ ");
INSERT INTO bds_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sangu kaay unkuray ambee, nama teesaaqay, Iliitleemu haa malayika dosi maa hhaꞌaluumidiyay sa heedi leẽ gu kooma tlakwaroo, gwaanii fookidu daqa Iliitleemuge tlakwaroo dosaa.” ");
INSERT INTO bds_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu gi ilakoomi gimba tuba, “Yaa wana heedi waku gwaa kooma yaꞌay cada gu hhawatee. ");
INSERT INTO bds_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Letu waka, hikira gu coko⁄u gi kaay sa taataa gosi tuba, ‘Taataa, sini hadiside aalimee doyi.’ Ina gi deehhimi khooslay gosi sa yaꞌay kosi cada koinaa. ");
INSERT INTO bds_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Balalu angaamaka kilesi giyaa iliicatiri, nakira gu coko⁄u gii kurunkuri khooslay gosi goõ, gi tosaa waaudi hhapee da segenge. Yade ina gi palanquusi khooslay gosi hari ibinaa da slasla⁄iima. ");
INSERT INTO bds_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Qatlay giyaa ilii hheꞌesi palanquusa khooslay gosi goõ, qori gu didiru yaagii ca⁄i hhapetiray. Ina gi tlaatleesi meeta konaaba idoo lensee. ");
INSERT INTO bds_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sa gimbakee, ina gi firoo kay yondu daqa yaamulooay wakuu gu hhapetee. Yaamulooaykee gugi tosaa leehhisi qaymoo dosii, sa ⁄agimisu gu biinoo dosi. ");
INSERT INTO bds_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ina yaa arimi kwayru gu ⁄agoo qafeeraa daa ⁄agiiginee biinotee, maꞌaana wanaaba heedi lensee gwaa qaw idoo da ⁄agoo sa ina. ");
INSERT INTO bds_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Qariqaaqari, gi ilahudeesi muuna gosii gimba gu bawma dosi, hingigi maasi tuba, ‘Ti yondimiisee maka da taataa goy goó ⁄agimee ⁄agoo, giti amoolaa memesinay! Ana tiꞌii hati gwaaꞌa sa qori!’ ");
INSERT INTO bds_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Inkoo, ha ki⁄a daqa taataa gooii haa sugugi kaawa ambee, ‘Ye taataa, ana haã dakusi pandaa da Iliitleemuge haa pandaa dooguu see. ");
INSERT INTO bds_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ana hariiboo⁄aaba kara dinima eteedi nankoogu. Inkoo, ana haniti ilafate leẽ gu yondimiisee doogu pahha.’ ");
INSERT INTO bds_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Da hheꞌesi, gi tosaa waaudi, gi ki⁄i daqa taataa gosii. Giyaa ilii kahhiye segenge, taataa gosi gugi arimi ina yaa khoci, sugugi arimi slahhaaꞌamee. Cirakiray gi tu⁄udi daqa nankosii, ina gi khambacimi nankosi haa gugi humbaꞌadi. ");
INSERT INTO bds_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Teꞌesii, nakee gi kaay sa taataa gosi tuba, ‘Ye taataa, ana haã dakusi pandaa da Iliitleemuge haa pandaa dooguu see. Taataa, ana hariiboo⁄aaba dinima eteedi kara nankoogu.’ ");
INSERT INTO bds_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Teꞌesii, taataa gosi gi kaay sa yondimiisee dosi tuba, ‘Taa⁄amida slehheesaw! Owaaruu ciraai qayriya da hhoi, sugu daasidee, sugu daasidee petee dinca dosii haa sugu daasidee ye⁄eetoo see. ");
INSERT INTO bds_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kara, owaaruu damaa daa wahhati, laga gaasiday, ma ⁄isini losona. ⁄aginee haa hhaꞌaluumidanee sliimaa haa ina. ");
INSERT INTO bds_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa gimba naki koyi yaati gwaai pahha, inkoo slafi kara, yaa papa⁄i, inkoo yaanii ca⁄i.’ Teꞌesii, inay gi tlaatleesiri seehha tay, gi hhaꞌaluumidiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Qatlaykee nankosi gu badiisu yaa qaymooge wana, ina giyaa ilii wawaawatliye, giyaa ilii daadaausi ayage, gi akhasi hida raaiyay haa seehhuusiyay. ");
INSERT INTO bds_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Teꞌesii, ina gi eteedi yondimiisay leẽ haa gugi maasi tuba, ‘Mala na wanta letuti tiꞌii?’ ");
INSERT INTO bds_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yondimiisaykee gi kaay sa ina tuba, ‘Nankooguna gu coko⁄u naani khay ayage. Inkoo taataa googu hiĩ gaasi damaa daa wahhati sa ina, sa gimba guũ slay kara wana saayuudi.’ ");
INSERT INTO bds_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nakee gu badiisu gi slahhaai hari khisla, gi siꞌi hiidawaraa waꞌay gu marage. Taataa gosi yaagii ca⁄i khoorooge, gugi tlaatlaqasi, maay day waꞌay gu marage. ");
INSERT INTO bds_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ina gi ilaki⁄isi taataa gosi tuba, ‘Yuꞌudiyaa! Koraraa hhanki sliimaa ana haã yondiidi yondu sa ugu tongimoo pahha. Kara, baloo lensee haa mayiiba iliikooma gimba googu. Teesaaqay see, ugu sinaa hadisidiiba ana gimati dakhwada lensee, ana see ma ⁄isimi losona haa deneꞌee koi. ");
INSERT INTO bds_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Inkoo, naki koku gwaa palanquusu khooslay googu sliimaa haa slipalauusee, giyaani ilii ki⁄i, suguũ gaasidi damaa daa wahhati.’ ");
INSERT INTO bds_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taataa gosi gi kaay sa ina tuba, ‘Nankoy, ugu hoó sliimaa wana haa ana balalu sliimaa, kara idadu goõ ga koome ti koku. ");
INSERT INTO bds_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dandiray hinti naraꞌa ⁄isiru losona hagi hhaꞌaluumidana, sa gimba nankooguna gu coko⁄u, yaati gwaai pahha, inkoo yuꞌudiyaa ti slafi. Ina yaa hhami, inkoo yaanii ca⁄i.’ ” ");
INSERT INTO bds_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kara, Yeesu gi kaay sa sirakoomiisee dosi, ilaꞌaaꞌaatisati tuba, “Yaa wana hindaqaru waku haa yondimiisay gosi gu didiru. Yondimiisaykee, dugwaa sitaakimi tuba, yaa palanquuqumisi khooslay gu looimoo gosi. ");
INSERT INTO bds_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Teesaaqay, hindaqaru gi eteedi yondimiisaykee gu didiru haa gugi maasi tuba, ‘Ana haã akhasi ugu idoo ga yondimaamite hari khooslay goy! Inkoo, ca⁄asaayuu faadoo doogu, da wariiqadimiduu gu khooslay gooii. Maꞌaana, ugu hiidahhasidaaba yondimiisay goy tleehhida kara.’ ");
INSERT INTO bds_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Da hheꞌesi, yondimiisaykee gu didiru gi ilahudeesi muuna gosii tuba, ‘Inkoo hati malee laqa? Looimoo goy hinigusina yondu gooaa gu yondimiisay gu didirugo. Ana doosla hiidahhasaaba, kara ti ilamuree firiiriru kawa. ");
INSERT INTO bds_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Inkoo, ha khua idoo ga laqe! Teꞌesii qatlay dinoo iliigusine yondu gooaa, hida mani kwahhasuumisiri maraai koinay.’ ");
INSERT INTO bds_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Teesaaqay, gi eteedimi lelee lelee hida goõ, gwaa koomee iinanu gu looimoo gosi. Ina gi maasi hikira gu pandaa tuba, ‘Iinaa doogu daqa looimoo gooii qoomay mala?’ ");
INSERT INTO bds_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Heedikee gi ilaki⁄isi tuba, ‘Kideelimaiĩ miyaa gweleti gu du⁄iya da ⁄aamu gu miseyituuni.’ Karaanimokee gi kaay sa ina tuba, ‘Cheeti da iinaa doogu nahaã oyii, ibiidi ciraai, handakimi kideelimaiĩ miyaa cigahha.’ ");
INSERT INTO bds_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Da hheꞌesi gi maasi gu caduu tuba, ‘Ugu daqa dooguu iinaa dosi ti qoomay mala?’ Heedikee gi ilaki⁄isi tuba, ‘Guniyayuu miyaa leẽ gu ganoo.’ Ina gi kaay tuba, ‘Cheeti da iinaa doogu nahaã oyii, ibiidi ciraai, handakimi guniyayuu mibeeri gweleti!’ ");
INSERT INTO bds_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hindaqarukira gi hhaꞌaleesi yondimiisaykee gu tlaku, idoo giyaa ilii yondiidi hari qeeraa. Maꞌaana, cirihhimaa gu hida gu khooroo, idoo hingoó iliiaꞌayee haa deneꞌee koina, ti wa⁄a ba⁄ay da yaꞌay gu cencee.” ");
INSERT INTO bds_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeesu gi ilakoomi gimba tuba, “Ana sangu kaay ambee, hangu daakaiimitee haa hida gu khooroti, hari khooslay gu khooroti ga kontee. Qatlay idadu hhakee gimaa ilii faakiyee karuumaa dooina, dangumaa kwahhasuusi rawge ma ibitiri koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Heedi daa ⁄imbi gimba gu digidakuge, slime dugoó ⁄imbi gimba gu denuge see. Kara, heedikaꞌa doóba ⁄imba gimba gu digidakuge, slime dugoó ⁄imbiyaaba gimba gu denuge. ");
INSERT INTO bds_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bere unkuray danguu ⁄imbiiba iliikoomaraage naraꞌa, khooslay gu khooroti, inkoo, ti miyaa sangumaa taatahhi khooslaykaꞌa gu lou? ");
INSERT INTO bds_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kara, bere unkuray dangu ⁄imbiyaaba iliikoomage naraꞌa, khooslay gu hida wakinay, inkoo, ti miyaa sangumaa hadisi khooslay googuna unkuray? ");
INSERT INTO bds_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wanaaba yondimiisay goó hiidahhasa yondiida yondu sa looee cada. Sa gimba, ina himaa slai looimoo leẽ haa himaa waki gu caduu, baku hingimaa ilaooyi haa looimoo leẽ haa himaa qooqiidi gu caduu. Unkuray hiidahhasidaaiiba yondiidaraa sa Iliitleemu sliimaa haa sa khooslay qatlaykeesii lenge.” ");
INSERT INTO bds_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Qatlay Farisaayoo giyaa ilii akhasiri gimbakee goõ gu Yeesu, inay gugi qasayri hari qooqiidaraa, maꞌaana inay yaa slaiyay peesay hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Teꞌesii, Yeesu gi kaay sa inay tuba, “Unkuray hangoóti laqantay pandaa da hidage tuba, kontay haaki. Teesaaqay see, Iliitleemu khui muunaiĩ kokuna. Gu lou idotaꞌa doó arinee da kaari pandaa da hidage, hatee pandaa da Iliitleemuge ti khanslaaoo pahha. ");
INSERT INTO bds_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kara, sariyaa da Iliitleemu haa handikaa da tletimiisee da Iliitleemu, dagaa kakaami qatlaykaꞌa naqatloo gu Yohaana Hiinunqudimiisay. Teꞌesaa qatlaykeesaa, Gimba gu Hhou gu Tawaaloo da Iliitleemu dugoóti kakaana. Kara kila heedi yoóti koisi hiidawaraa waꞌay gu tawaaloteesii hari ⁄uuru. ");
INSERT INTO bds_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Teesaaqay see, ti slahharuũ raw haa khooroo hiihhancooa, ba⁄ay da caqariya da coko⁄oniinii da sariyaa da Iliitleemu hhamaraa dosi. ");
INSERT INTO bds_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hhawata gu kereꞌesa tarakaa sa hadee dosi, gi khabina hadee waka, hikee yoóti yondiidi slipalauuma. Kara hhawata gu khabima hadetee daa may ha hhawata gosi, sagagi kereꞌesi tarakaa, hikee see yoóti yondiidi slipalauuma.” ");
INSERT INTO bds_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yeesu gi ilakoomi gimba tuba, “Yaa wana heedi leẽ hindaqaru. Heediki yaa daamaamisi qayroo gu kaari gu kalay gu daahhiya haa qayroo daa boo⁄imisi hari puteeri gu hhoi waa lenge. Balalu sliimaa yaati ⁄agiigina ⁄agoo da tliirii⁄ii. ");
INSERT INTO bds_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Teꞌesii, afamaraa gu hindaqarukeesii, kwaꞌalimoo waku yaa wana daa qaatiitimisiye, uma gosi naa Lasaaro, gwaa kooma inkaahhaai slaqwa sliimaa. ");
INSERT INTO bds_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kara, Lasaaro yaati ariirina kwayru, suguma hadisi ⁄agotaꞌa daa huhaahua meesaa da hindaqarukeesaa. Gwehheeri see yaa khakhaakhayay, haa gi naafinay inkahheerii kosi. ");
INSERT INTO bds_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hiigaasooge, kwaꞌalimokee gi hhami, da hheꞌesi malayika gugii oyiri rawaa gu rawge, ma ibiidi ilaciyaa haa Aburahaamu. Kara hindaqarukira see gi hhami, dugugi qaasi. ");
INSERT INTO bds_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hindaqarukira yadaa khonsleebaago, tay dugu labaꞌasi hari khisla, yaa waratlaysi ilaa kosi rawaage haa gi arimi Aburahaamu segenge loii. Slime Lasaaro, yaa wana ciyoomoo gosii. ");
INSERT INTO bds_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Teꞌesii, hindaqarukira gugi eteedi, kakaana tuba, ‘Ye Taataa Aburahaamu, sini ⁄awaarinte. Inkoo, Lasaaro naykee, ya⁄aba yaa hiitika⁄iye cina da dinca dosi maꞌayge, ma caaquudisi cufaraã goy, sa gimba dini labaꞌaaꞌamisi hari khisla aslaatiige.’ ");
INSERT INTO bds_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aburahaamu gugi ilaki⁄isi ina tuba, ‘Nankoy, inkoo slayii tuba, ugu haa slaydi gimba gu hhou khoorooge, Lasaaro yaa slay gimba gu tlaku. Inkoo ina tiꞌii dugu tlaatlaqaaqamisi, ugu taysi wanta labaꞌasu gu didiruge. ");
INSERT INTO bds_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kara, ti teesaaqay kilesiiba, tla⁄antla⁄a gu unkuray haa dandiray saꞌama wanta daa qaasi, dooba tlo⁄osa. Teesaaqay, hhakira gu slaee tayaa daqa dooraa, hadakawa taysi daqa doogunay, hhanti hiidahhasiyay hiicataraa. Kara, hhakee yadaa daqa doogunaa, gwaa slaee khawaraa tay daqa doorii, slime hhanti hiidahhasiyay hiicataraa.’ ");
INSERT INTO bds_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Da hheꞌesi, hindaqarukira gi kaay tuba, ‘Inkoo, taataa Aburahaamu haguũ tlaatlaqasi ambee, ya⁄abi Lasaaro mara gu taataa gooii. ");
INSERT INTO bds_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ina, ma ilii⁄oo⁄a kay hhiee koi kooani, inay see maa ba⁄atii khayay daqatii da labaꞌasuge.’ ");
INSERT INTO bds_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aburahaamu gugi ilaki⁄isi ina tuba, ‘Hhiee koku, konay gimba gu Iliitleemu, daa handikimi ha Musaa, haa tletimiisee da Iliitleemu. Inay mayki akhamisiyee handikatee.’ ");
INSERT INTO bds_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Teꞌesii, hindaqarukira gi kaay tuba, ‘Taataa Aburahaamu, teesaaqay gooba! Bere heedi gwaa gwaau hadakay daqa dooinay, inay yaa hiifookidiyay daqa Iliitleemuge tlakwaroo dooinaa.’ ");
INSERT INTO bds_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aburahaamu gi kaay sa ina tuba, ‘Bere inay guba akhamisu, gimbakee daa handikimi ha Musaa haa tletimiisee da Iliitleemu, inay ilii qaasiyaaiiba, heedi giyaamati slafi see ayisago.’ ” ");
INSERT INTO bds_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Baloo waka, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Koimisu goó ⁄isima hida ma yondiidiri tlakwaroo, maati wana balalu sliimaa. Teesaaqay see, hiti ana heedikaꞌa goó ⁄isima koimisukee! ");
INSERT INTO bds_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Heedi da hikee gooay, hiti ba⁄ay duguti ilii kufi tlaa⁄a da didiri da saadiruu isa dosii haa dugugii slakhi slagwiya da tlawa da didirige. Gu lou, ti naraꞌaaba ina ma ⁄isimi leẽ gu hhaã gu kahhee hii⁄atla ⁄imbage, ma yondiidiri tlakwaroo. ");
INSERT INTO bds_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Teesaaqay, hangu ga⁄aydee! Bere hhia googu hiĩ dakusi, ilii⁄oo⁄akuu, bere hiĩ kwahhi tlakwaroo dosi, ilamooyimaku. ");
INSERT INTO bds_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bere hiĩ dakusi daqa dooguu waa fanqu baloo lenge, ina yaagi khakhay daqa dooguu waa fanqu baloteesii, gi kaay tuba, ‘Haã kwahhi tlakwaroo doyi.’ Ugu ilamooyimaku.” ");
INSERT INTO bds_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Da hheꞌesi, ya⁄abimiisee gi kaayri sa Looimoo gu Goõ tuba, “Sandii roogiside ⁄imba.” ");
INSERT INTO bds_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Looimoo gu Goõ gi kaay sa inay tuba, “Bere haã aloo kontay ⁄imba gimati coko⁄oniinii see, pisagariya da haradaali pahha, haã aloo hiidahhasiday kaawaraa sa khaimoki gu ⁄ancimoo ubee, ‘Hangi tu⁄ude tiaa, taa⁄a hangi hatlide tlawa da didirige.’ Gu lou, khaimoki hiĩ aloo hiidahhasi muriida unkuray. ");
INSERT INTO bds_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Inkoo ilahudeesa, leẽ tla⁄aã googunay kona tongimoo goó doosla qaymoo, angamalee yoó deꞌena bee⁄u. Qatlay tongimokee giyoó ilii watliye ayage, sugoó kaayiyaa tuba, ‘Khoca tiꞌii ciraai, ⁄agimi fa⁄a sliimaa haa ana?’ ");
INSERT INTO bds_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Suti! Ina hiti kaay sa tongimokee kosi tuba, ‘Sini boo⁄iside ⁄agoo, ila⁄utle naraꞌa ma sini yonditi, qatlaykaꞌa naqatloo goo ilii hheꞌese ⁄agoo haa kitahhu. Ugu hoo asu ⁄aginta haa hoo asu kitahhada.’ ");
INSERT INTO bds_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Teꞌesii, heedikee kaayiyaa ⁄iisoo sa tongimokee, sa gimba giĩ yondiidi, gimba sliimaa duguũ ilafahhi? ");
INSERT INTO bds_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Namati teesaaqay unkuray see, qatlay gaã ilii gaasidiri yondu gimba sliimaa dangwaa ilafahhi, kaawa ubee, ‘Dandiray ti tongimaiĩ kilesi gubasli faydaa. Hanti yondiidani gimbakira kilesi, dandii slaiye magu yondiidani.’ ” ");
INSERT INTO bds_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Qatlay Yeesu giyaa ilii Yerusaleemu kakaakaye, yaa hiicati hari digimi gu hhapee da Samariyaa haa Galilaaya. ");
INSERT INTO bds_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Giyaa ilii day tongoo wakay, hingaa slaslay haa hida mibi, gwaa koomee ga⁄ay gu buubaa. Hida hhakee yaati qadimidiri segenge, ");
INSERT INTO bds_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","gi maahhiri hari afoo da didiri kakaanay tuba, “Ye Yeesu, Looimoo gu Goõ, sandi ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Qatlay giyaa ilii arimi inay, sigigi kaay tuba, “Unkuray, taa⁄amida hangu laqantee daqa hhapalooeege.” Inkoo, inay giyaa ilii khociicinee amooge, digigi ilabuusli buubaa dooina. ");
INSERT INTO bds_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Da hheꞌesi, leẽ tla⁄aã gooinay giyaa ilii arimi duguũ hhoeesi, cirakiray gi ki⁄i daqa Yeesuge, tay tosaa daareemisi Iliitleemu hari afoo da didiri. ");
INSERT INTO bds_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ina gi keebeeꞌedi yeꞌeeroo gu Yeesuge, tay tosaa kakaana ⁄iisoo daqa dosii. Heedikee yaa yaamulooay gu hhapee da Samariyaa. ");
INSERT INTO bds_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Teꞌesii, Yeesu gugi maasi ina tuba, “Hinti hida mibiibaslii diĩ ilabuusli? Hari hhakira wakinay gweleti kaanoki? ");
INSERT INTO bds_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hhakuu waku tla⁄aã gooinaa diĩ arimi, gwaani ki⁄u sa daareesa Iliitleemu, ti hiĩ kilesii gu dahaa gu Yahuudimoo gooba?” ");
INSERT INTO bds_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Da hheꞌesi, Yeesu gi kaay sa heedikee tuba, “⁄imba doogu hiĩ hhoeesidi ugu. Tlayii, taa⁄a waaudi.” ");
INSERT INTO bds_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Letu waka, Farisaayoo yaa maasiri Yeesu tuba, “Tawaaloo da Iliitleemu yaa malaalee khayda?” Yeesu gi ilaki⁄isi inay tuba, “Tawaaloo da Iliitleemu yaa khaydaaba, hari amoo ga iliidahhaside cangicangimisu hari maguuma. ");
INSERT INTO bds_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kara, hida himaa hiidahhasiyaiiba kaawa tuba, ‘Yuꞌudaa, wana tiꞌii!’ baku ‘Yuꞌudaa, wana yade!’ Maꞌaana, Tawaaloo da Iliitleemu tla⁄aã googunay wanta.” ");
INSERT INTO bds_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Balalu yaa khociyay, gamaa ilii arintee kwayru, gu arimaa gimati baloo leẽ see da Nanku Heedi. Gu lou, balotee hagamaa antaaiiba. ");
INSERT INTO bds_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Qatlaykee, hida maa kakaanay sa unkuray tuba, ‘Yuꞌudaa! Naykaꞌa yaqay!’ baku ‘Yuꞌudaa! Nahiĩ tiꞌii!’ Hagimaa hhanti sirakontay. ");
INSERT INTO bds_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nanku Heedi baloo gimaa ilii khaye, maa mankaraaiya pahha, idoo giyoó ilii mankaꞌaside rawge, bara lengo, bara da cadii naqatloo. ");
INSERT INTO bds_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Teesaaqay see, ina kwanda dugu gesaa labaꞌasiye, labaꞌasu wa⁄a haa dugugi siꞌi ha laqwaloti da inkoo. ");
INSERT INTO bds_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kara, idoo daa iliica⁄i gooay balalu hhakiray gu Nuuhuge, teesaaqay daganimaa iliica⁄i slime baloo da Nanku Heedi gimaa iliiki⁄iye. ");
INSERT INTO bds_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Qatlay gu Nuuhu, hida yaa ⁄agiiginay, yaa kitahhaahhanay, hingaa khabiibinay balotira naqatloo Nuuhu giyaa ilii day safiinage. Teꞌesii, ilawa⁄iya yaagi khaydi haa digigi hhamisi gonkoinaa. ");
INSERT INTO bds_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Slime, naama teesaaqay balalu hhakira gu Looti. Hida yaa ⁄agiiginay haa yaa kitahhaahhanay, yaa kirigiiginay haa yaa naadiidinay, yaa dosliislinay haa yaa tlehhaahhidiyay. ");
INSERT INTO bds_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Teesaaqay see, Looti giyaa ilii waaudi Sodomaago, aslaa da dihhi yaagii tuutuquti teꞌesii, yadaa rawgo tlubay pahha. Aslatee gi hhamisidi inay gonkoinaa gwaa meetee teꞌesii. ");
INSERT INTO bds_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Teesaaqay, daganimaa iliica⁄i balotirayi, Nanku Heedi dugumaa iliitlaaꞌasiye. ");
INSERT INTO bds_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Baloteesii, heedi damaa slaye rawaa gu pembee da mara gosii, hhantii ⁄eeti sa hiiowaraa khooslay gosi waꞌay gu marago. Kara, heedi damaa slaye qaymooge, hhanti ki⁄i ayage sa hiiowaraa idoo lensee. ");
INSERT INTO bds_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Slawaw hadee da Looti, gimba gwaay ca⁄u daqa dosii! ");
INSERT INTO bds_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Heedi gu koisa ga⁄aw ibinaa dosi, hikee higimaa hhamisi ibinaa dosi. Slime, heedi gu hadisa ibinaa dosi, hikee himaa slay ibinaa da loi. ");
INSERT INTO bds_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sangu kaay unkuray, amasi hhakee hida cada maa buburuu lenge wanay, leẽ dugurimaa waaudi, gu caduu dugumaa may. ");
INSERT INTO bds_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tigay cada maa saadiidinay sliimaa, leẽ dagarimaa waaudi, da cadii dagamaa may.” ");
INSERT INTO bds_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Da hheꞌesi, sirakoomiisee dosi gugi maasiri ina tuba, “Looimoo gu Goõ, gimbaki maa kaale hiica⁄i?” Ina gi ilaki⁄isi inay tuba, “Daqa da iliiwane sayni, teꞌesii gwadiisu ginoó ilii kurunkuridi.” ");
INSERT INTO bds_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Da hheꞌesi, Yeesu gi kaay sa sirakoomiisee dosi ilaꞌaaꞌaatisa, ma sigi laqami tuba, inay kwanda gi ilakonee firoo Iliitleemu balalu sliimaa, hari hhanti simbariigwaaiyay. ");
INSERT INTO bds_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ina sigigi kaay tuba, “Yaa wana hakiimuu yaamu wakinayge, goóba gwaa⁄amee Iliitleemu, hida see giyoó muriidiyaaba. ");
INSERT INTO bds_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Slime yaamu hhakeesii, yaa wanta kwaꞌalitoꞌoo waka, daa khakhaakhawa daqa hakiimukeesii tiaatia, gi kakanta tuba, ‘Sini hadiside haaki doyi, tla⁄aã gooii haa fa⁄aymoo goy.’ ");
INSERT INTO bds_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Balalu wa⁄a, hakiimukee yaa siꞌi itatiisa gimba gu kwaꞌalitoꞌotee. Hiigaasooge gi ilahudeesi muuna gosii tuba, ‘Ana goómati tlaꞌamuudaaba see Iliitleemu, kara hoó muriidaaba hida. ");
INSERT INTO bds_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Inkoo, sa gimba kwaꞌalitoꞌoti hini ilahufimaamita ana, saga hadisi haaki dosi, mani maydi ba⁄aa⁄aadisa hari ilii khakhawuu ana tiaatia.’ ” ");
INSERT INTO bds_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Looimoo gu Goõ gi kaay tuba, “Akhasa, idoo hakiimukee gu tlaku giĩ ilii kaay. ");
INSERT INTO bds_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Inkoo, Iliitleemu hadisiyaabaaslii haaki sa hida kosi giyaay leehhi, hhakee goó firiirimee ina tleemaa haa amasi? Ina hiikaaiyaa iliiawaraa inay? ");
INSERT INTO bds_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gu lou, sangu kaay unkuray ambee, Iliitleemu sigi hadisi haaki dooina ciraai. Teesaaqay see, qatlay Nanku Heedi gimaa ilii khaye khoorooge, maaslayaa hida kahhiyay goó ⁄imbee Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Da hheꞌesi, Yeesu gi kaay ilaꞌaaꞌaatisati sa hhakaꞌa gungoóyi arimee tuba, konay ibinaa daa tafaꞌadi haa gi qooqiidiyay wakinay. ");
INSERT INTO bds_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ina gi kaay tuba, “Hida wakinay cada yaa hadakayri mara gu didiruge gu Iliitleemu sa firoo Iliitleemu. Leẽ yaa Farisaaymoo gu caduu yaa karaanimoo gu koodi. ");
INSERT INTO bds_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaaymokee gi qadidi ina lenkosi haa gi firimi tuba, ‘Ye Iliitleemu, ha kaawa ⁄iisoo daqa dooguu, sa gimba ana ti hida wakinay pahhaaba gu koomee tlakwaroo, inay goó yondiidee tlakwaroo, slipalauusee haa goó hii⁄utlidee. Kara ana ti karaanimoki pahhaaba gu koodi. ");
INSERT INTO bds_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ana hoó maw ⁄agoo haa kitahhu waa cada jumaage, kara hoó hadimisa leẽ da mibi da idadu goõ goó slawe.’ ");
INSERT INTO bds_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Teꞌesii, karaanimokee gu koodi gi qadidi segenge. Ina yaa koisiiba gimati waratlaysa pandaa dosi rawge. Ina hingaati puupukhuukhumisi muunainge hari slahhaaꞌamee, tay tosaa kakaana tuba, ‘Ye Iliitleemu, sini ⁄awaarinte ana gu kooma tlakwaroo.’ ");
INSERT INTO bds_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gu lou, sangu kaay, karaanimokee gu koodi, yaa ki⁄i ayage, duguũ faadi kona ibinaa daa tafaꞌadi pandaa da Iliitleemuge. Farisaaymokee dugwaa faadiiba teesaaqay. Sa gimba heedi gungoó hiitlaysa ina lenkosi, dugu hii⁄eetisi ha Iliitleemu, kara hikaꞌa gungoó hii⁄eetisa, dugu hiitlaysi ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Letu waka, hida yaa leehhiihhimisiyay daa⁄a⁄ee koina daqa Yeesuge, magi iliiqamidi dabaiĩ kosi. Qatlay sirakoomiisee dosi giyaa ilii aniri teesaaqay, gi ilii maahhiri hida hhakee. ");
INSERT INTO bds_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Teꞌesii, Yeesu gigi eteedi daaqay hhakee maa khayri daqa dosii, gi kaay tuba, “Daaqay mawakina, yaa khayee daqa dooii, hagi hhanti tlaatlahhasiday. Tawaaloo da Iliitleemu dati hida da hhakee gooay. ");
INSERT INTO bds_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gu lou, sangu kaay unkuray, heedi goóba oowaraa Tawaaloo da Iliitleemu daaqay pahha, etaa hikee hiidayaaba tawaaloteesii.” ");
INSERT INTO bds_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Da hheꞌesi, giyaadimiisay waku gu Yahuudi gi maasi Yeesu tuba, “Maarimuu gu muuna hhou, hati malee laqa, ma aalimi slafimaa gu koraraa goóba hiifaakoo?” ");
INSERT INTO bds_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu gi kaay sa ina tuba, “Hani soꞌoyi eteedinta ana gu muuna hhou? Wanaaba heedi lensee gu muuna hhou, ti Iliitleemu kilesi. ");
INSERT INTO bds_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Inkoo, ugu ha khuꞌuda ilakaawa da Iliitleemu tuba, ‘Hhanti slipalauta, hhanti gaasida, hhanti fiisida, hhanti ilatlatlayda afaꞌafuuma, muriidi taataa googu haa iyoo doogu.’ ” ");
INSERT INTO bds_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Heedikee gi ilaki⁄isi tuba, “Ilakaawatee goõ hagaa iliikoomi yadaa tlaatleesoo da qarauumaa dooaa.” ");
INSERT INTO bds_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Qatlay Yeesu giyaa ilii akhasi gimbakee, gi kaay sa ina tuba, “Kahhada wanta idoo leẽ gaã afariislaꞌati. Taa⁄a naadimi idadu goõ ga konte, goo hheꞌeside la qaqayda peesaykee goo slayde sa kwaeeli, hari amotee ugu maa asu slayda hindaqaruumaa da loi yade rawaa gu rawge. Goo ilii hheꞌeside teesaaqay laqaraa, laa asu khayda, ma sirakoomiisay goy tleehhiti.” ");
INSERT INTO bds_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Heedikee giyaa ilii akhasi gimbakee, yaa li⁄i hari khisla, sa gimba ina yaa hindaqaru hari khisla. ");
INSERT INTO bds_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Qatlay Yeesu gwaa ilii arimi heedikee hiĩ li⁄i, gi kaay tuba, “Yuꞌudiyaa idoo daa ilii karahhi, hindaqeeri hiiguuma Tawaaloo da Iliitleemuge! ");
INSERT INTO bds_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gu lou, ti slahharuũ hari khisla, gamiyaa hiicataraa hari pooa da singanoo, ba⁄ay hindaqaru hiidawaraa Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hida hhakira gwaa akhasee gimbaki, gi maasiri tuba, “Bere daa karahhi teesaaqay, inkoo ti miyaa dugunimaa hiidahhasi ilabuꞌuru?” ");
INSERT INTO bds_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu gi kaay tuba, “Hari bara da hida gimbaki dugwii dahhasiyaaba, daqa Iliitleemuge gimba goõ dugwii dahhasi.” ");
INSERT INTO bds_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Teꞌesii, Peetiro gi kaay tuba, “Yuꞌudiyaa, dandiray haani mayni idadu sliimaa gaa kone, hagugi sirakoni ugu!” ");
INSERT INTO bds_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu gi kaay sa ina tuba, “Gu lou, sangu kaay, hhaku heedi lensee gwaani maw mara gosi baku hadee dosi, hhia gosi, hhioo dosi, taataa gosi, iyoo dosi, yaꞌay kosi sa Tawaaloo da Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hikee slay wa⁄a hari khisla, qatlaykii gu inkooge. Kara, qatlaykiray gwaa khocage maa slay slafimaa gu koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Da hheꞌesi, Yeesu hirigi waaudi afayige sirakoomiisee dosi da mibi haa cada, sigigi kaay tuba, “Yuꞌudiyaa, inkoo Yerusaleemu kakaakayna. Gimba sliimaa daa handikimi ha tletimiisee da Iliitleemu sa Nanku Heedi, dugu hiigaasi. ");
INSERT INTO bds_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ina dugumaa taatahhi dabaiĩ gu hida gu hhapapu wakinay. Inay gumaa yaqaayinay, gumaa wahaahanay haa gumaa ilii cubuqunay cubuqari. ");
INSERT INTO bds_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kara gumaa difiyay hari jeleedimaiĩ haa gugi gaasiyay. Baloo da tamige maa slafi ayisago.” ");
INSERT INTO bds_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sirakoomiisee dosi yaa caahhiriiba gimbakee, sa gimba maꞌaana dosi dagaa yakwi daqa dooinaa, kara inay yaa baraslayiriiba Yeesu yaa mala giimaamisi. ");
INSERT INTO bds_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Qatlay Yeesu giyaa ilii daadaauusi yaamu gu Yeerikoge, yaa slay heedi waku gwaa ilahhamu, hiĩ ibiidi kenga gu amooge, tay tosaa firiirina peesay. ");
INSERT INTO bds_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Heedikee giyaa ilii akhasi raqa da hida hiicatida hari teꞌesa, gi maasi hida gwaa ilaciyaa gosii waaree tuba, “Yeraa! Mala naanii ca⁄adi?” ");
INSERT INTO bds_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inay sugugi kaay tuba, “Yeesu gu tongoo da Nasareeti na hiicacaacati.” ");
INSERT INTO bds_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Teꞌesii, ina gi maahhi hari ⁄uuru, kakaana tuba, “Yeesu, Nanku Dawdi, sini ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hida gwaa giyaadee pandaa da raqateesii, gugi ilii ⁄oo⁄iri, ma qabi diĩ. Teesaaqay see, ina gi asu ilakoomi maahhoo hari khisla tuba, “Nanku Dawdi, sini ⁄awaarinte!” ");
INSERT INTO bds_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeesu giyaa ili akhasi, gi qadidi haa gi ilafahhi heedikee duguraa khaye daqa dosii. Heedikee giyaa iliisati ciyoomooge, Yeesu gugi maasi tuba, ");
INSERT INTO bds_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ugu mala slaꞌada, ana ma sugu laqi?” Ina gi ilaki⁄isi tuba, “Looimoo gu Goõ, ana hati slaꞌa ma arimi kara.” ");
INSERT INTO bds_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu gi kaay sa ina tuba, “Arimi kara! ⁄imba doogu hiĩ hhoeesidi ugu.” ");
INSERT INTO bds_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nama qatlaykeesii lenge gi karaai slay ⁄uuru guri khuꞌuduũ, gi tosaa sirakoomi Yeesu, tay tosaa daareemisi Iliitleemu. Hida sliimaa giyaa ilii aniri gimbaki, inay see gi daareesiri Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Qatlay Yeesu giyaa ilii guumi yaamu gu Yeerikoge, ina yaa hiicacaacati hari tla⁄aã gu yaamu hhakee. ");
INSERT INTO bds_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yuꞌudiyaa, teꞌesii heedi waku yaa wana, uma gosi na Sakaayo. Ina naa didiri sa karaanimaiĩ gu koodi, slime yaa hindaqaru. ");
INSERT INTO bds_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ina yaa slai arimaa Yeesu, ina ti miyaa. Inkoo, yaa hiidahhasiiba sa raqa da didiri da hida, sa gimba ina gwaa qunqumaadu. ");
INSERT INTO bds_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Teesaaqay, gi taa⁄adi haa gi giyaadi pandaa da raqateesii. Da hheꞌesi, gii day rawaa gu ⁄ancimooge, ma arimi Yeesu naraꞌa, sa gimba hari amotee hiicati. ");
INSERT INTO bds_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Qatlay Yeesu giyaa ilii day ⁄ancimokeesii, gi yuꞌudi rawaage, sugugi kaay tuba, “Sakaayo, ⁄eetaayuu ciraai hhapeege, maꞌaana letuti ana kwanda ga cimpime mara googuu!” ");
INSERT INTO bds_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Teꞌesii, Sakaayo yaagii ⁄eeti ciraai hhapeege, gi kwahhasuusi Yeesu mara gosii hari hhaꞌaloo da didiri. ");
INSERT INTO bds_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Qatlay hida giyaa ilii ariniri gimbakee, gonkoinaa gi tlaatleesiri quru⁄umoo, tay tooinaa kakaanay tuba, “Yuꞌudaa! Hingii dawa kay mara gu heedi gu kooma tlakwaroo, ma dahaa gosi tleehhidi.” ");
INSERT INTO bds_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Teꞌesii, Sakaayo gi qadidi haa gi kaay sa Yeesu tuba, “Looimoo gu Goõ, yuꞌudiyaa! Inkootuutuu nusuu gu khooslay goy hagu hadimisa sa kwaeeli. Kara, bere haay oyi idoo lensee da heedi harii coraraa, hikee sugu ilaki⁄isa waa cigahha da idotee gaa hiioy.” ");
INSERT INTO bds_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Da hheꞌesi, Yeesu sugugi kaay ina tuba, “Letuti, ilabuꞌuruu yaani khay sa hida gu maraki, sa gimba heediki kona ⁄imba daqa Iliitleemuge, kookoo gosi pahha Aburahaamu. ");
INSERT INTO bds_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Inkoo, Nanku Heedi yaati khay tiꞌii khoorooge, sa dabiidu haa ilabuꞌuru hida guũ hhamee tlakwarooge.” ");
INSERT INTO bds_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Qatlay hida giyaa ilii itatiitimisiyee gimbakee gu Yeesu, ina gii roogisi kaawaraa ilaꞌaaꞌaatisa waka. Ina yaa teesaaqay laqi, sa gimba yaa daadaauusiri Yerusaleemuge, slime inay yaati ilatahhiri tuba, Tawaaloo da Iliitleemu yaatii ca⁄ada ciraai ina giyoo ilii day yade. ");
INSERT INTO bds_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Teesaaqay, ina sigigi kaay inay tuba, “Heedi waku yaa wana gu motoliya da mutemiꞌisoo. Heedikee yaa hhiyuudi yaamu gu segenge, maa ooyi hiidahhasa da mutemi tleehhida haa yaagi ki⁄i hhapee dosii. ");
INSERT INTO bds_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ina giyaa ilii kahhiye waauda, gi eteedi yondimiisee dosi mibi, sigigi hadimisi gonkoinaa peesay wa⁄a. Ina sigigi kaay tuba, ‘Peesaykee haguri kirigintee haa guri naadiidintee, ma slaydiri faydaa, qatlay gamaa ilii ki⁄e naqatloo.’ ");
INSERT INTO bds_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Inkoo heedikee, hida gu hhapee dosi gwaa wakiyay. Inay gi tooinaa ya⁄abiri hida alunkosaa, ma kaawa kayri yade tuba, ‘Dandiray slaꞌanaaba heedikee ma mutemi goori tleehhidi.’ ");
INSERT INTO bds_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Teesaaqay see, sugwaagi hadisi tawaaloo da hhapetee. Qatlay giyaa ilii ki⁄i, mutemi gi eteedi yondimiisetira saa hadisi peesay, ma caahhi ti faydaa qoomay mala, yondimiisee giyaa slayri kirigiruu gooinaa. ");
INSERT INTO bds_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yondimiisay gu pandaa yaagi khay haa gi kaay tuba, ‘Looimoo goy, peesay googu sinaa maydi, hiĩ slay faydaa waa mibi.’ ");
INSERT INTO bds_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mutemi gi kaay tuba, ‘Yondimiisay daa ⁄imbi, haã yonditi naraꞌa. Sa gimba gaã laqanti ⁄imbaraa gimba gu coko⁄uge, inkoo ugu tawaalimi yaamu mibi.’ ");
INSERT INTO bds_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yondimiisay gu cada yaagi khay haa gi kaay tuba, ‘Looimoo goy, peesay googu sinaa maydi, haã slay faydaa waa kooani.’ ");
INSERT INTO bds_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mutemi gi kaay tuba, ‘Naraꞌa, inkoo ugu tawaalimi yaamu kooani.’ ");
INSERT INTO bds_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yondimiisay waku yaagi khay haa gi kaay tuba, ‘Looimoo goy, peesay googu sinaa hadisidi nahiĩ tiꞌii owakuu. Ana hagwaati iliikoomi naraꞌa dahhamuge, ba⁄atii hhana. ");
INSERT INTO bds_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Maꞌaana, ana hagwaa tlaꞌamuudi ugu, sa gimba ugu ti heedi gwaa karahhu. Ugu hoótii oyiminta idadu daqa goóba iliiqaasa, kara hoóti buꞌunta daqa goóba ilii daamisu.’ ");
INSERT INTO bds_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mutemi gi kaay sa ina hari slahhaaꞌamee tuba, ‘Inkoo, ana haguti hukuma hari gimba googu gaã gimbuusidi, ugu ye yondimiisay gu tlaku! Ugu haa khuꞌuda tuba, ana ti heedi gwaa karahhu, goó hiioyima idadu daqa noóba iliiqaasa, kara hoóti buꞌuma baruũ daqa noóba ilii daamisuu. ");
INSERT INTO bds_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Inkoo, ugu haa soꞌoyi maaydi qaasaraa peesay goy benkige? Qatlay gaani ilii ki⁄i hanti aloo hiiowu peesay goy haa faydaa dosi.’ ");
INSERT INTO bds_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Da hheꞌesi, mutemi gi kaay sa hhakira gwaa qadimidee ciyoomoo gosii tuba, ‘Afii⁄utlakunayi goboriyatee da leẽ gi kone, hadisakana sa hikee gu kooma talanta mibi.’ ");
INSERT INTO bds_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Inay sugugi kaayri tuba, ‘Looimoo goori, hiĩ kona faydaa waa mibi!’ ");
INSERT INTO bds_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ina sigigi ilaki⁄isi tuba, ‘Ana sangu kaay, heedikaꞌa gu kooma gimba gu Iliitleemu, ina sugumaa hiiroogisi hari khisla. Kara hikaꞌa goóba gimbakee, gimati koomi see caahhatee da coko⁄o, dugoóti afii⁄utli. ");
INSERT INTO bds_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Inkoo, fa⁄ayatira toyi gwaaba slaꞌa ana, ma mutemi gooina tleehhidi, hari khawankina tiꞌii, ligi cu⁄uday pandaa dooii.’ ” ");
INSERT INTO bds_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Qariqaaqari, Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee, yaa giyaadi pandaa dooinay, gi ilakoomi Yerusaleemu khuꞌusa. ");
INSERT INTO bds_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Qatlay giyaa ilii daadaauusi tongagu gu Betifaage haa Betaniyaa, ilaciyaa haa oõ doó eteedine Miseyituuni, ina yaa ya⁄abi sirakoomiisee dosi cada, sigigi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Taa⁄amida tongotiray naqatloo da pandaa doogunay waara. Qatlay goo ilii daadee tongoteesii, hoo slayday daqumoo duguũ kufi, daqumokee da kahhiye iliidawa ha heedi lensee. Unkuray lugwaa gwetay, luguraa khayday tiꞌii. ");
INSERT INTO bds_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bere unkuray dangoo maasi ha heedi tuba, ‘Yeraa, daqumokee hagu soꞌoyi gweediidintay?’ Unkuray sugu kaadee ubee, ‘Looimoo gu Goõ gu slai.’ ” ");
INSERT INTO bds_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Da hheꞌesi, hhakee daa ya⁄abi, gi waaudiri. Inay giyaa ilii dayri, gi slayri gimba sliimaa, idoo sigaa ilii kaay gooay ha Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Qatlay gwaa ilii gweediidinee daqumokee, looee da daqumokee gigi maasiri inay tuba, “Daqumokee hagu soꞌoyi gweediidintay?” ");
INSERT INTO bds_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Inay gigi ilaki⁄isiri tuba, “Looimoo gu Goõ gu slai.” ");
INSERT INTO bds_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Inay guraagi khayri daqumokee daqa Yeesuge, gi hhafiifiniri qayroo koina danda gu daqumokeesii. Da hheꞌesi gii daasiri Yeesu rawaa kosii. ");
INSERT INTO bds_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ina giyaa ilii khociicine, hida gi hhafiifiniri qayroo koina amooge pandaa dosii, ma laqaniri muree daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yeesu gi day tlaatleesoo da hiigweegwe⁄eda da oõ gu Miseyituunige. Teꞌesii, raqa goõ da sirakoomiisee dosi gi hhaꞌaluumidiri haa gi daareesiri Iliitleemu hari afoo da didiri, sa laqaru gimba gu denu goó bakaꞌasa hida, giyaa aniri. ");
INSERT INTO bds_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inay gi kaayri tuba, “Dugwaa ⁄aafi mutemi gwaa khociicima, hari uma gu Taataa Iliitleemu. Qasaw rawaa gu rawge, hhoinay gu wanqamee da didiri daqa dosii.” ");
INSERT INTO bds_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Teꞌesii, Farisaayoo wakinay tla⁄aã gu raqateesaa, gi kaayri sa Yeesu tuba, “Maarimuu ilii⁄oo⁄ii sirakoomiisee doogu, ma mayri kakaaru gimba da hikee gooay.” ");
INSERT INTO bds_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeesu gigi ilaki⁄isi inay tuba, “Sangu kaay unkuray, bere hida hhanki qabiyay, tle⁄eẽ hhanki yoo maahiiyay.” ");
INSERT INTO bds_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeesu gi daadaauusi yaamu gu Yerusaleemuge. Qatlay giyaa ilii arimi yaamu hhakee, gigi tlaatleesi ilii⁄aa⁄imu. ");
INSERT INTO bds_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ina gi kaay tuba, “De Yerusaleemu, bere hanti aloo caahhada letuti, gimba guroó khawa qasaw haa Iliitleemu, eki, inkoo duguũ yakwi ilaa kokaa. ");
INSERT INTO bds_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gu lou, balalu yaa khociyay, fa⁄ayaa doogi maa tleehhiyay qwaama digi niini⁄ida. Inay maa niini⁄idiyay igi haa gigi iliitlaiyay waꞌayge khooroogo bareemoo sliimaa. ");
INSERT INTO bds_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hiigaasooge, inay maa slakhiyay hhapeege, de Yerusaleemu, haa hida koki, goó ibiidee waꞌay gu bi⁄eenaa kokii. Kara, maa mayaaiiba tlaa⁄a lensee rawaa gu tlaa⁄a wakayge, sa gimba haa baraslaydiiba, qatlay Iliitleemu giyaa ilii khay daqa doogii, magi ilabuꞌumi.” ");
INSERT INTO bds_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Da hheꞌesi, Yeesu gii day efeenaa da mara gu didiruge gu Iliitleemu. Ina gi tlaatleesi gusiisiru hida gwaa naadiidimee idadu gu tambikoo teꞌesii, ");
INSERT INTO bds_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kakaana tuba, “Daa handikimi Handikaa da Iliitleemuge tuba, ‘Mara goy maati mara gu ilii firoo Iliitleemu tleehhidi.’ Inkoo unkuray gwaatii fookidiri ‘maraiya da fiisiisee!’ ” ");
INSERT INTO bds_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Balalu sliimaa Yeesu yaa caacaahhaahhamisi mara gu didiruge. Hhapalooee da deni, maarimamaa da sariyaa da diini haa giyaadimiisee da Wayahuudi, yaa damaamidiyay amoo, magu gaasiri. ");
INSERT INTO bds_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Teesaaqay see, inay yaa slayriiba mucu guri gaasaraa ina, sa gimba hida goõ yaa itatiimisiri gimba gosi hari maguuma da didiri. ");
INSERT INTO bds_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Letu waka, qatlay Yeesu giyaa ilii caacaahhaahhamisiye hida mara gu didiruge haa kakaaru Gimba gu Hhou gu Iliitleemu, hhapalooee da deni, maarimamaa da sariyaa da diini haa gaduũ gu Yahuudi, yaagi khayri daqa dosii. ");
INSERT INTO bds_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Inay gugi maasiri ina tuba, “Sandi kaade, hari ⁄uuru gu tawaaloo mala yondimaamita gimbaki? Baku ha miyaa suguũ hadisi ugu ⁄uurukee?” ");
INSERT INTO bds_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ina gigi ilaki⁄isi inay tuba, “Ana see hangu maasa unkuray gimba leẽ. Sini kaadee, ");
INSERT INTO bds_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","hiinunqudimisu gu Yohaana yaa daqa Iliitleemu dahhi, baku yaa daqa hida dahhi?” ");
INSERT INTO bds_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Teꞌesii, gi idaruusiri inay haa inay tuba, “Bere hoo kaawana tuba, yaa rawaa gu raw dahhi daqa Iliitleemugo, ina hindoo maasi tuba, ‘Asu unkuray magwaa ⁄imbidiriiba ina?’ ");
INSERT INTO bds_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kara, bere hoo kaawana tuba, ‘Yaa daqa hida dahhi,’ hida sliimaa hindoo cakhadinay hari tle⁄eẽ, sa gimba hiĩ iliipaꞌaniri tuba, Yohaana yaa tletimiisay gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Teesaaqay, inay gugi ilaki⁄isiri tuba, “Dandiray ha hhidina hiidahhasa dosi, daqa giyaa dahhade.” ");
INSERT INTO bds_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Teꞌesii, Yeesu sigigi kaay tuba, “Ana see sangu kaawaaba, ti hari ⁄uuru gu tawaaloo mala yondimaamida gimbaki.” ");
INSERT INTO bds_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Inkoo, Yeesu gi ilakoomi kakaaru sa hida ilaꞌaaꞌaatisati tuba, “Heedi waku yaa daamisi sabiibu qaymoo dosii. Qaymotee gigi dubisi sa dooslimiisee wakinay. Da hheꞌesi, ina gi hhiyuudi segenge, gi ibiidi yade balalu wa⁄a. ");
INSERT INTO bds_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Qatlay gu we⁄inay giyaa ilii day, ina yaa ya⁄abi tongimoo gosi daqa dooslimiisetiray, ma sugwaa hadisi bara da ⁄aamu gosi. Teesaaqay see, dooslimiisetira gugi difiri tongimokee haa gugi ki⁄isiri ina hari dabaiĩ kilesi. ");
INSERT INTO bds_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Teesaaqay, looimoo gu qaymotee gi ya⁄abi kara tongimoo waku daqa dooinay. Hikee see gugi difiri haa gugi muriidisiri hari khisla. Inay gugi ki⁄isiri ina hari dabaiĩ kilesi. ");
INSERT INTO bds_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ina gii roogisi kara ya⁄abaraa tongimoo gu tami. Hikee see gugi difiri haa gugii slaamuudisiri, inay gugii kwahhiri kenga gu qaymooge. ");
INSERT INTO bds_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Da hheꞌesi, looimoo gu qaymoo da sabiibu hingigi maasi tuba, ‘Hati malee laqa? Inkoo hati ya⁄aba nankoy ga slae, angamalee inay gu muriidiyay ina.’ ");
INSERT INTO bds_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Qatlay dooslimiisetee gwaa ilii aniri ina yaa khoci, gi gimbuusiri inay haa inay tuba, ‘Yeraa, hiĩ na asu aalimiisayi gu qaymoti. Inkoo, hagu gaasanee, aalimeeti ma toori tleehhiti.’ ");
INSERT INTO bds_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Teesaaqay, giyaa ilii day inay gugi duukhiri kenga gu qaymoo da sabiibuge haa gugi gaasiri. Inkoo, looimoo gu qaymoo da sabiibu, dooslimiisetee giti malee laqi? ");
INSERT INTO bds_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Gu lou, ina yaati khay haa gi hhamisi dooslimiisetee. Kara qaymotee da sabiibu gigi hadisi sa dooslimiisee wakinay!” Hida giyaa ilii akhasiri gimbaki gu Yeesu, gi kaayri tuba, “Gimbaki maa hhantii ca⁄i coko⁄o seei!” ");
INSERT INTO bds_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Teꞌesii, Yeesu gi ilii kaasi ilaa kosi daqa dooinay, gi kaay tuba, “Inkoo, ilatahha maꞌaana da Handikati da Iliitleemu, doó kaawa tuba, ‘Tlaa⁄ukira giyaa siꞌiri tlehhidiisee, hikee hiĩ tlaa⁄u gu didiru tleehhidi gu musingi!’ ");
INSERT INTO bds_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Heedi gwii huua rawaa gu tlaa⁄ukii hitii kereꞌemidi pencerehhemay haa pencerehhemay. Kara heedi da iliihuuiye dugutii saadisi sumuku.” ");
INSERT INTO bds_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Teꞌesii, maarimamaa da sariyaa da diini haa hhapalooee da deni, gi dabiidiri amoo dari oowaraa ina ciraai, sa gimba yaa baraslayiri tuba, inay diginiĩ ilaꞌaaꞌaatisi haa dooslimiisetee da tlakwi. Teesaaqay see, inay yaa tlaꞌamuudiri raqa da hida. ");
INSERT INTO bds_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Da hheꞌesi, maarimamaa da sariyaa haa hhapalooetee gi gigidiniri Yeesu haa gi ya⁄abiri cangincangimisee, gungwaa laqamee tuba ti hida gu hhoi. Inay yaati slaiyay ooyiru ina hari gimba gosi, magu taatahhiri dabaiĩ gu gafanage. ");
INSERT INTO bds_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cangicangimisetee gi maasiri Yeesu tuba, “Maarimuu, dandiray ha khuana tuba, ugu hoóti gimbuusida haa hoóti caacaahhamisida gimba gu lou, kara hoó hiilehhitaaba hida. Ugu hoóti caacaahhamisida gimba gu Iliitleemu hari amoo da loi. ");
INSERT INTO bds_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Inkoo sandi kaade, dandiray ti naraꞌaa buꞌuduu koodi sa Kaysaari baku ti naraꞌaaba?” ");
INSERT INTO bds_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yeesu gi baraslayi inay guti koiiꞌimisiyay hatliru, sigigi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sini laqantee goboriya da dinaari. Kalay haa uma gu miyaa na wana goboriyatii?” ");
INSERT INTO bds_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Inay gugi ilaki⁄isiri tuba, “Gu mutemi Kaysaari.” Yeesu gi kaay sa inay tuba, “Inkoo! Idadu gu Kaysaari hadisa sa Kaysaari, kara idadu gu Iliitleemu hadisa sa Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Inay yaa hiidahhasiriiba ooyiru ina, hari gimba lensee giyaa gimbuusi pandaa da hidage. Inay digaati bakaꞌasi hari khisla hari ilaki⁄isa dosi, gi qabiri diĩ. ");
INSERT INTO bds_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Da hheꞌesi, Sadukaayimaiĩ goó tlatlankimee tuba, hida gwaa kaka⁄ee, maa slafiyaaiiba, yaagi khayri daqa Yeesuge haa gugi maasiri tuba, ");
INSERT INTO bds_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maarimuu, Musaa yaa handikimi sariyaage tuba, bere heedi hhia gosi hiĩ hhami, hiĩ may hadee dosi kontaaba yaꞌay, heedikee kwanda gi aaline kwaꞌalitoꞌotee, ma laqwali yaꞌay sa hhia gosi. ");
INSERT INTO bds_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Inkoo, yaa wanay hhiee fanqu. Hhia gooina gu badiisu gi khabimi hadee, qariqaaqari gi tosii hhami, guba slawaraa yaꞌay. ");
INSERT INTO bds_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hhia gosi gu cada gi khabimi kwaꞌalitoꞌotee, ina see gi hhami guba slawaraa yaꞌay. ");
INSERT INTO bds_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hhia gu tamii see gigi khabimi, gi hhami. Namati teesaaqay leẽ, hhiee hhakee goõ fanqu gigi khabiibiniri hadetee, goõ gi hhamaahhaniri, guba slawaraa yaꞌay haa hadetee. ");
INSERT INTO bds_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Asunkuilee, hadetee see gi hhanti. ");
INSERT INTO bds_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Inkoo, baloo hida gwaa kaka⁄ee digimaa iliislafisiye yaagii ca⁄iyay ayisasugo, hadetee maa hadee da miyaa? Sa gimba inay gonkoinaa giyaa khabiibiniri hadetee.” ");
INSERT INTO bds_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Teꞌesii, Yeesu gi kaay sa inay tuba, “Hida gu qatlayki yoó khabiibinay haa digoó khabiibina. ");
INSERT INTO bds_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hhakira daa faadi ha Iliitleemu tuba, hiraa hiiboo⁄iri slawaraa slafimaa yaagii ca⁄iyay ayisasugo gimaa dayee rawaa gu rawge, maa khabiibinaaiiba haa digimaa khabiibinaaba. ");
INSERT INTO bds_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gu lou, inay maa kaka⁄iyaaiiba kara, sa gimba inay maati malayika pahha. Inay ti yaꞌay gu Iliitleemu, sa gimba digaa slafisi ha ina. ");
INSERT INTO bds_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kara, gimbaki gu slafaraa hida gwaa kaka⁄ee yaagii ca⁄iyay ayisasugo, Musaa see giyaa laqami gu lou, daqa da gimba gu Iliitleemuge da rukutiyatira daa ooyiiyima aslaa. Ina yaa eteedi Looimoo gu Goõ, ‘Iliitleemu gu Aburahaamu, Iliitleemu gu Isaaka haa Iliitleemu gu Yakoobo.’ ");
INSERT INTO bds_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ina ti Iliitleemu gu hida gwaa kaka⁄ee gooba. Ina, ti Iliitleemu gu hida gu slafee, maꞌaana daqa dosii goõ konay slafimaa.” ");
INSERT INTO bds_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Teꞌesii, maarimamaa waka da sariyaa da diini, gi ilaki⁄isiri Yeesu tuba, “Maarimuu haã gimbuusidi naraꞌa!” ");
INSERT INTO bds_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Inay yaa teesaaqay kaayri, sa gimba qatlaykeesaa yaa tlaꞌamuudiri kara maasaraa ina gimba waku. ");
INSERT INTO bds_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Da hheꞌesi, Yeesu gi maasi maarimamatee tuba, “Hida yoó malee kakaanay tuba, Kristu ti Nanku Dawdi? ");
INSERT INTO bds_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maꞌaana, Dawdi ina loi yaa kaay kitaabuu gu Daareesooge tuba, Taataa Iliitleemu yaa kaay sa Looimoo goy gu Goõ tuba, ‘Ibiidi hari bara doyi da ⁄uya, ");
INSERT INTO bds_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","qatlaykaꞌa naqatloo gamaa ilii qaase fa⁄ayaa doogu, biraa gu yeꞌeeroo kokuu.’ ");
INSERT INTO bds_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Inkoo, bere Dawdi, Masiiya gwaati eteediidina, ‘Looimoo gu Goõ.’ Inkoo Masiiya malee kara nankosi tleehhidi?” ");
INSERT INTO bds_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Qatlay hida goõ gwaa ilii itatiitimisiyee, Yeesu gi kaay sa sirakoomiisee dosi tuba, ");
INSERT INTO bds_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hangu ga⁄aydee haa maarimamaa da sariyaa da diini. Inay yoóti slaiyay khookhocu hiĩ daamisiri jurungaguu gu tledi haa digima cehheemisi ha hida hari muree sokooniige. Kara sinagoogige yoóti slaiyay ibinaa kiteeri gu pandaage, haa qatlay gu losonage, yoó slaiyay ibinaa kiteeri doó ilii ibiidiye dahaa gu muree. ");
INSERT INTO bds_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kara nama inay hhakee leẽ yoó afii⁄utlidiyayi idadu maraai gu tigay hhakeesaa gu kwaeeli. Kara nama qatlaykeesii lenge, yoóti firiirinay Iliitleemu hari firoo da tleedi, mangu laqaniri pandaa da hidage tuba, guti hhoi. Gu lou, hida gu teesaaqay slaqamisee digimaa ⁄agitina ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Teꞌesii mara gu didiruge gu Iliitleemu, Yeesu yaa arimi hindaqeeri hiislaslakhiyay sadaaka dooina daqa khoosliya da iliislaslakhu sadaaka. ");
INSERT INTO bds_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Slime ina yaa arimi mogombitoꞌoo waka kwaꞌalitoꞌoo, gi hiislakhadi teꞌesii goboree cada kilesi. ");
INSERT INTO bds_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Teꞌesii, Yeesu gi kaay tuba, “Gu lou, sangu kaay unkuray, kwaꞌalitoꞌoti dabasli idoo, hiĩ hadisidi hari khisla ba⁄ay da hida wakinay goõ. ");
INSERT INTO bds_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hida hhanki goõ, hinti hadisiri sadaaka hindaqaruumaa dooinaa. Inkoo, kwaꞌalitoꞌoti hari kwaꞌaluumaa dosi, hinti hadisidi idadu goõ, giyaa konte sari ibinaa dosi.” ");
INSERT INTO bds_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sirakoomiisee dosi wakinay yaa giimaamisiyay, idoo mara gu didiru gu Iliitleemu dugwaa ilii tlemi hari tle⁄eẽ gu kaari, sliimaa haa idadu gu kaari hida giyaa hadimisiri sadaaka pahha sa Iliitleemu. Yeesu sigigi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gimbaki goõ ga khuꞌuuꞌuntee tiꞌii, balalu maa khayay, maa wantaaba tlaa⁄a lensee damaa meeta rawaa gu tlaa⁄a wakay. Tle⁄eẽ goõ digimaati muumu⁄una.” ");
INSERT INTO bds_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Da hheꞌesi, inay gugi maasiri tuba, “Maarimuu, gimbaki maa malaalee hiica⁄i? Kara, ti laqaru mala gumaa laqama tuba, yaani daadaauusi hiica⁄araa?” ");
INSERT INTO bds_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeesu sigigi ilaki⁄isi inay tuba, “Hangu ga⁄aydee, dangumaa hhanti hiicori. Maꞌaana hida wa⁄a maa khakhayay hari uma goy, tay kakaanay tuba, ‘Ana na ina,’ kara maa kakaanay tuba, ‘Qatlay gu hiifaakoo yaani daadaausi.’ Unkuray hagimaa hhanti sirakontay inay. ");
INSERT INTO bds_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Qatlay unkuray gamaa ilii akhasidee gimba gu gau haa darabimaa tla⁄aã gu hidage, hhanti tlaꞌamutay. Gimbakee kwanda gii ca⁄iye gesaa. Teesaaqay see, hiifaakoo da gimba sliimaa maa cira khaydaaba.” ");
INSERT INTO bds_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Da hheꞌesi, Yeesu gi kaay sa inay tuba, “Qatlaykeesii hhapee leẽ maa qwaatlida haa hhapee waka, kara tawaaloo leẽ maa qwaatli haa tawaaloo waku. ");
INSERT INTO bds_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Damaa wana kintleemoo gu deni, qori gu dihhu haa ga⁄ay gu iliilooyimisu daqeemoo paslaapasloo. Kara, damaa hiicaca⁄i gimba gu hiitlaꞌamuudisa haa laqaru gimba gu denu rawgo. ");
INSERT INTO bds_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Teꞌesii, gimbaki goõ gimaa ilii kahhiye hiica⁄araa, hida himaa ooyinayi unkuray dangugi labaꞌasi. Kara unkuray dangumaa leehhimisi pandaa da giyaadimiisee da denige gu Sinagoogaguu haa dangugi ilapingina jeerage. Kara, unkuray dangumaa leehhimisi pandaa da watemige haa hida goó tawaalimee sa uma goy. ");
INSERT INTO bds_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gimbaki maa qay mucu sa unkuray, gu ilatlawaraa ana pandaa dooinay. ");
INSERT INTO bds_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Teesaaqay, ilakhuukhuꞌusa muunaiĩ kokunay hhanti ilahudeemisiday, idoo ga ilii ilaki⁄isidee sitaakaa dooguna. ");
INSERT INTO bds_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maꞌaana, ana sangumaa hadisa waaway haa gimba gamaa gimbuusidee. Gimbaki wanaaba lensee gu fa⁄ayaa dooguna gumaa hiidahhasa hiikaasa gimati kanisaraa dosi. ");
INSERT INTO bds_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Unkuray dangumaa hiifookidi ha ayiĩ haa amu kokuna, hhiee kokuna, hiidayuuma dooguna haa deneꞌee kokuna see. Slime inay maa cu⁄iyay wakinay tla⁄aã googunaa. ");
INSERT INTO bds_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kara, unkuray dangumaa waki ha hida sliimaa, sa gimba gu uma goy. ");
INSERT INTO bds_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Teesaaqay see, wantaaba gimati quubiya lensee da sagaiĩ kokuna damaa hhamisiye. ");
INSERT INTO bds_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hari hiikaasa dooguna labaꞌasuki goõ, ha ilabuꞌuntay muunaiĩ kokuna.” ");
INSERT INTO bds_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Qatlay gamaa ilii antee yaamu gu Yerusaleemu digiĩ niini⁄idi ha sirikaarii da fa⁄ayaa, caahha tuba, qatlay gu tlakweemisuu gosi yaani daadaauusi. ");
INSERT INTO bds_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Teꞌesii, hida gumaa Yudaayage waaree, lakidiyee omeerige. Hhakira gumaa tla⁄aã gu yaamuge waaree, hiica⁄iyee kenga gu yaamuge. Kara hhakira gumaa qaymamuge waaree, hhanti hiigunay yaamuge. ");
INSERT INTO bds_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maꞌaana balalu hhakee maa balalu gu ⁄agitiru, gimaa ilii buꞌudiye gimba goõ daa handikimi Handikaa da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gu lou, hamaa antayi balalu hhakee gumaa tlakwi hari khisla daqa tigay gumaa koomee hubay haa gumaa ruꞌumisee! Qatlaykeesii damaa wana labaꞌasu gu didiru khoorooge, kara qupidaa gu Iliitleemu maa ilii khay hida hhanki. ");
INSERT INTO bds_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hida wakinay digimaati cu⁄i hari pangaaee, wakinay digimaati leehhisi khiidimooge hhapapu sliimaage. Kara yaamu gu Yerusaleemu digimaa hiikala⁄i tlakwaroo ha hida gu hhapapu, qatlaykaꞌa naqatloo qatlay gu hida hhakee gu hhapapu gu tawaaliru gimaa ilii faakiyee.” ");
INSERT INTO bds_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yeesu gi ilakoomi gimba tuba, “Kara, damaa wana laqaru gu gimba gu bakaꞌasa letuge, slehhenge haa tica⁄eeriige. Tiꞌii khoorooge, hhapapu maa khoslongora gu didiruge wanay haa digimaa ooyi ha tlaꞌamee da didiri, sa kukukhumoo haa gondadee gu deni gumaa hiica⁄ee tlawa da didirige. ");
INSERT INTO bds_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hida maa kwihhimidiyay sa gimba gu tlaꞌamee da didiri, haa arimaa gimbakee gu hiica⁄a khoorooge. Maꞌaana ⁄uuru gu idadu gu rawge waaree, dugumaa rinqirinqisi. ");
INSERT INTO bds_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Qatlaykee, hida gumaa arinayi Nanku Heedi, yaa khoci tlongage hari ⁄uuru haa wanqamee da hhoinay gu didiru. ");
INSERT INTO bds_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Qatlay gimbakee gimaa ilii tlaatleesiye hiicaca⁄uu, qadimida naraꞌa haa gi waratlaysiday sagaiĩ kokuna rawaage, sa gimba ilabuꞌuruu googuna yaani daadaauusi.” ");
INSERT INTO bds_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Da hheꞌesi, Yeesu sigigi kaay inay ilaꞌaaꞌaatisati tuba, “Ilatahha khaimoo gu ⁄ancimoo haa khai wakinay goõ. ");
INSERT INTO bds_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Qatlay giyoó ilii tlaatleesiyee kucufaraa loo⁄oo dooina, unkuray hoó antayi haa gi baraslayidayi tuba, inkoo madeẽ yaani daadaauusi. ");
INSERT INTO bds_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Namati teesaaqay, qatlay unkuray gamaa ilii antee gimbaki goõ sanguũ kaay hiicaca⁄i, caahha tuba, Tawaaloo da Iliitleemu yaani daadaauusidi. ");
INSERT INTO bds_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gu lou, sangu kaay unkuray ambee, laqwaloti da inkoo hiicatidaaba, qatlaykaꞌa naqatloo gimbaki goõ gimaa iliica⁄iye. ");
INSERT INTO bds_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Raw haa hhapee maa hiihhancooiyay. Teesaaqay see, gimba goy maa hiihhancooiyaaba coko⁄o see. ");
INSERT INTO bds_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hangu ga⁄aydee naraꞌa, muunaiĩ kokuna digi ba⁄atii ilii loay ha oona haa yondu gosi gu tlaku, haa khoslongora gu ibinati. Teesaaqay laqa balotira da hiifaakoo dangumaa ba⁄atii ilii khay ciraai. ");
INSERT INTO bds_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maꞌaana, balotee maati khayda hatliroo pahha, daqa hida gonge goó ibiidee khooroo sliimaage. ");
INSERT INTO bds_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Inkoo, diliqa naraꞌa. Qatlay sliimaa firiirima Iliitleemu, ma hiidahhasidiri ba⁄aru haa gimbaki sliimaa gumaa hiica⁄a. Teesaaqay unkuray maa hiidahhasiday qadimidu pandaa da Nanku Heedige.” ");
INSERT INTO bds_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Balalu hhakeesii hari qatlay gu tleemaa, Yeesu yaa caacaahhaahhamisi hida mara gu didiruge gu Iliitleemu. Hari qatlay gu khwayaiĩ ina yaati waauuꞌumidi sa guꞌudee oõ gu Miseyituunige. ");
INSERT INTO bds_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Qatlaykee, hida goõ yaatii tlatlaatlayay hari tumpaatumpu. Inay yaati hadakakaakayay daqa Yeesuge, yade mara gu didiruge gu Iliitleemu, magu itatiimisiri ina. ");
INSERT INTO bds_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Inkoo, losona gu mukaate doóba iliiqaasa hamiira, doó eteedine na Pasaaka, yaa daadaauusi. ");
INSERT INTO bds_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qatlaykee, hhapalooee da deni haa maarimamaa da sariyaa da diini, yaa damaamidiyay amoo da gaasaraa Yeesu. Inay yaa laqiri teesaaqay hari hhaaboo, sa gimba yaa tlaꞌamuudiri gau haa hida. ");
INSERT INTO bds_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Da hheꞌesi, Sataanimoo gi ilii guumi Yuuda, daa eteediidine Isikariyooti, leẽ gu sirakoomiisee mibi haa cada da Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuuda gi waaudi, gi gimbakay haa hhapalooee da deni sliimaa haa sirikaarii da deni da mara gu didiru gu Iliitleemu, idoo gi ilii fookidiye Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inay gi hhaꞌaluumidiri hari khisla, gi ⁄imbiri buaraa peesay sa ina. ");
INSERT INTO bds_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Teꞌesii, Yuuda gi ⁄imbi, gi tlaatleesi dabiidu mucu gu hhou gu hiinawaraa Yeesu, qatlay da ilii hhaka raqa da hida sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Inkoo, baloo da mukaatee doóba iliiqaasa hamiira yaagi daadi. Hatee na baloo ⁄ambeenimoo gu Pasaaka dugoó ilii isahiiquutliye. ");
INSERT INTO bds_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Teesaaqay, Yeesu gi ya⁄abi Peetiro haa Yohaana, sigigi kaay tuba, “Taa⁄amida ilakhuukhuꞌusa ⁄agoo da losona gu Pasaaka, ma ⁄agini sliimaa.” ");
INSERT INTO bds_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Inay gugi maasiri ina tuba, “Ugu kaale slaꞌada, dandiray ma haraa ilakhuukhuꞌusani ⁄agotee?” ");
INSERT INTO bds_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yeesu gi kaay sa inay tuba, “Yuꞌudaa! Qatlay goo ilii guntee yaamuge, hangoo slaslayday haa heedi waku yaani geregedi sibida da maꞌay kwaahha dosii. Unkuray lugoo sirakontay ina, mara giyoo ilii daye naqatloo. ");
INSERT INTO bds_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Unkuray looti kaaday sa looimoo gu marakee ubee, ‘Maarimuu maamaamisi ugu tuba, waauu gu dahaa na kaloo tiꞌii, gi ilii ⁄agine ⁄agoo da losona gu Pasaaka sliimaa haa sirakoomiisee dosi.’ ");
INSERT INTO bds_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ina sangoo laqana waauu gu didiru rawaa gu gorofaage, daa ilakhuukhuꞌusi gu koomaa khooslay goõ. Teꞌesii la haraa ilakhuukhuꞌusiday ⁄agoo da Pasaaka.” ");
INSERT INTO bds_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Inay gi waaudiri, gi slayri idadu sliimaa, idoo Yeesu sigaani ilii kaay gooay gi ilakhuukhuꞌusiri losona gu Pasaaka. ");
INSERT INTO bds_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saa giyaa ilii buꞌuti, Yeesu gi ibiidi sliimaa haa ya⁄abimiisee dosi sa ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kara, ina gi kaay sa inay tuba, “Hari kwayru gu didiru, ana haã kwayruudi ⁄agoo losona gu Pasaakaki sliimaa haa unkuray, qatlay labaꞌasu goy gi ilii kahhiye. ");
INSERT INTO bds_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Maꞌaana, sangu kaay unkuray ambee, ana hamaa ⁄agimaaba kara Pasaaka, qatlaykaꞌa naqatloo dugumaa iliibuꞌudisiye Tawaaloo da Iliitleemuge.” ");
INSERT INTO bds_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Da hheꞌesi, ina gii oyi qulu⁄uu, gi kaay ⁄iisoo sa Iliitleemu, gi kaay sa sirakoomiisee dosi tuba, “Owaa qulu⁄uki kitahhama sliimaa gonkokunaa. ");
INSERT INTO bds_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Maꞌaana, sangu kaay ambee, qatlaykaa gu inkoogo, ana ha kitahhaaba kara difaay, qatlaykaꞌa naqatloo damaa ilii khaye Tawaaloo da Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Teꞌesii, ina gii oyi mukaatimoo, gi kaay ⁄iisoo daqa Iliitleemuge, gugi fandakumisi, haa gi tosaa hadisi sa inay, tay kakaana tuba, “Haã na slaqwa doyi, da hadisiye sa unkuray. Taqay lalaqa sa hiislaslaw goy.” ");
INSERT INTO bds_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nama teesaaqay leẽ, qariqaaqari gii oyi qulu⁄uu giyaa ilii hheꞌesiri ⁄agoo, gii oyi qulu⁄uu, tay kakaana tuba, “Qulu⁄uki na ila⁄imbidu gu ⁄abu hari ceedee doyi, da tuutuquda sa unkuray. ");
INSERT INTO bds_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Inkoo, yuꞌudaa! Hikee guniifookida ana, wana tiꞌii meesaage sliimaa ha ana. ");
INSERT INTO bds_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nanku Heedi, gu lou dugu gaasa kay, idoo daa ilii ilakhuukhuꞌusi gooay. Inkoo, yoo ana heedikaꞌa goo hiifookida ina.” ");
INSERT INTO bds_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Teꞌesii, sirakoomiisee hingigi tlaatleesiri maamisu inay haa inay tuba, ti miyaa tla⁄aã gooinay na hiidahhasi yondu gimbaki. ");
INSERT INTO bds_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Slime daagii ca⁄i kabaaba⁄u tla⁄aã gu sirakoomiiseege tuba, miyaa tla⁄aã gooinay da ilatahhaahhadiye na didiri sa inay goõ. ");
INSERT INTO bds_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Teꞌesii, Yeesu sigigi kaay inay tuba, “Watemi da hhapapu yoóti tawaalinay hida koina hari ⁄uuru. Kara hhaã gu koomee hiidahhasa da tawaaloti rawaa koinay, hingoóti eteedinay iliiaymiisee da hida. ");
INSERT INTO bds_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Teesaaqay gooba daqa doogunay, ba⁄ay hikaꞌa gu didiru tla⁄aã googunay, ina hiti gu coko⁄u tleehhidiye tla⁄aã gu gonge. Kara hikaꞌa gu giyaadimiisay, ina hiti yondimiisaykaꞌa pahha tleehhidiye goó yondiida. ");
INSERT INTO bds_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ilahudeesa, miyaa na didiri tla⁄aã gu hhankii. Ti hikaꞌaa goó ibiida sa ⁄agoo meesaage, baku ti hikaꞌa goó yondiida? Hikaꞌaabaslii goó ibiida sa ⁄agoo meesaage? Inkoo, ana hati waara tla⁄aã googunay, hikaꞌa pahha goó yondiida. ");
INSERT INTO bds_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Unkuray naa metiri sliimaa haa ana, qatlay gu koimisu goy. ");
INSERT INTO bds_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Teesaaqay, idoo ana sinaa ilii hadisi gooay ha Taataa goy tawaaloo, ana see sangu hadisa unkuray tawaaloo, ");
INSERT INTO bds_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ma ⁄agintiri haa ma kitahhantiri meesaa dooii Tawaaloo dooiige. Kara, gi ibitay kiteeri gu tawaalooge, tay gi hukuntay motoliya mibi haa cada da Israeeli.” ");
INSERT INTO bds_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeesu gi kaay tuba, “Simooni, Simooni! Yuꞌudiyaa! Sataanimoo hiĩ firimi, ma koimisi unkuray goõ, taqay dooslimiisay gooay giyoó ilii heeleꞌemisiye baruũ. ");
INSERT INTO bds_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Teesaaqay see, ana haã firimi Iliitleemu sa ugu Simooni ambee, ⁄imba doogu daqa dooii ba⁄atii slakuta. Kara qatlay goo ilii fookite daqa dooii, muuna⁄atlisii hhiee koku.” ");
INSERT INTO bds_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peetiro gi kaay sa ina tuba, “Looimoo gu Goõ, ana haã ⁄imbi waauda sliimaa haa ugu jeerage, gimati gwaaꞌaraage see.” ");
INSERT INTO bds_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu gi kaay tuba, “Peetiro, sugu kaay ugu ambee, konkaku gi ilii kahhiye ceearaa amasi gu letuti, ugu hanooti tlankida waa tami tuba, ana hani hhidinta.” ");
INSERT INTO bds_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Da hheꞌesi, Yeesu gi maasi sirakoomiisee dosi tuba, “Qatlay hangwaa ilii ya⁄abi, hanguba bena gu peesay, curuqu guri hhiyuuma, ye⁄eetoo see, haa afariislaꞌatirii idoo lensee?” Inay gugi ilaki⁄isiri tuba, “Haa afariislaꞌaniiba idoo lensee.” ");
INSERT INTO bds_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ina gi kaay sa inay tuba, “Inkoo, heedi gu kooma bena gii oye, gu kooma curuqu guri hhiyuuma namati teesaaqay. Kara ina guba pangaa, naadine jurungii dosi, ma kirigi pangaa leẽ. ");
INSERT INTO bds_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Maꞌaana, sangu kaay unkuray ambee, gimbaki daa handikimi tuba, ‘Dugwaa ilafaadi sliimaa haa fitlaalootiisee,’ kwanda dugu buꞌudisiye daqa dooii. Gu lou, gimbakee koyi daa handikimi, inkoo hiĩ daadaauusi hiigaasa.” ");
INSERT INTO bds_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sirakoomiisee dosi sugugi kaayri tuba, “Looimoo gu Goõ, yuꞌudiyaa tiꞌii wanay pangaaee cada.” Ina sigigi ilaki⁄isi tuba, “Diĩ buꞌudi.” ");
INSERT INTO bds_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Da hheꞌesi, Yeesu yaagii ca⁄i Yerusaleemugo, gi waaudi oõ gu Miseyituunige, idoo daa iliiwane gooay ou gosi. Kara, slime sirakoomiisee dosi gugi sirakoniri. ");
INSERT INTO bds_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Giyaa ilii dayri yade, ina gi kaay sa inay tuba, “Firima Iliitleemu ha ba⁄atii gii guntay koimisuge.” ");
INSERT INTO bds_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Da hheꞌesi, ina hingigi paslisi daqa dooinaa, segaruũ gu hiilihharaa da tlaa⁄u gooay. Ina gi keebeeidi, gi firimi Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","gi kaay tuba, “Ye Taataa, bere ugu ga iliislaꞌade, sini surukuside qulu⁄uki gu labaꞌasu daqa dooaa. Teesaaqay see, hhanti yondita idoo ga iliislae ana, yondiidi idoo ga iliislaꞌade ugu.” ");
INSERT INTO bds_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Teꞌesii, malayika gu Iliitleemu rawgo yaagi iliica⁄i Yeesu haa gugii ⁄atlisi. ");
INSERT INTO bds_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeesu gi ilii slahhaaꞌamee da didirige wane, yaa ilakoomi firoo hari maguuma. Qatlay giyaa ilii firiirine cufa dosi gi tlaatleesidi tihhiru hhapeege ceedee pahha. ");
INSERT INTO bds_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Qatlay ina giyaa iliitlay firoogo, gi ki⁄i daqa sirakoomiisee dosii. Ina gigi slay inay hiĩ guiri, sa gimba yaa ba⁄aa⁄aadiri sa li⁄eemoo giyaa konee. ");
INSERT INTO bds_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ina gigi maasi inay tuba, “Unkuray soꞌoyi guꞌuuꞌumintay? Tlawuu, firima Iliitleemu, ha ba⁄atii gii guntay koimisuge.” ");
INSERT INTO bds_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Qatlay Yeesu giyaa ilii kahhiye gimbage, yuꞌudiyaa raqa da hida yaagi khaydi teꞌesii. Hida hhanki digiraa giyaadi ha Yuuda, leẽ gu sirakoomiisetira mibi haa cada da Yeesu. Yuuda gi iliisati Yeesu, magu cehheemisi hari humbaꞌada. ");
INSERT INTO bds_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Teꞌesii Yeesu sugugi kaay ina tuba, “Yuuda, gu louu, hatiifookita Nanku Heedi hari humbaꞌada?” ");
INSERT INTO bds_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Qatlay sirakoomiisee da Yeesu giyaa ilii aniri gimba gu slaꞌa hiica⁄a teꞌesii, gi kaayri tuba, “Looimoo gu Goõ, hida hhanki hagi tlaaqanaa hari pangaaee koti?” ");
INSERT INTO bds_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cirakiray, leẽ tla⁄aã gooinaa, gii maahhasi yondimiisay gu hhapalooay gu didiru hari pangaa, gugi afakereꞌesi eea dosi da ⁄uya. ");
INSERT INTO bds_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Teꞌesii, Yeesu gi kaay tuba, “Maw teesaaqay laqa!” Yeesu gi nangusi eea da heedikee haa gugi hhoeesi. ");
INSERT INTO bds_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Da hheꞌesi, Yeesu gi kaay sa hhapalooee da deni, sirikaarii da deni da mara gu didiru gu Iliitleemu haa gaduũ gu Yahuudi gwaa khawee sa oowaraa ina tuba, “Unkuray hanti khaydiri hari pangaaee haa hhadimeerii, ubee ana ti fiisiisay pahha? ");
INSERT INTO bds_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Balalu sliimaa ana haa waara sliimaa haa unkuray mara gu didiruge gu Iliitleemu, unkuray hanaa oodiriiba ana. Inkoo, hiĩ ti qatlay googuna, qatlay gu ⁄uuru gu tawaaloo da ⁄oona.” ");
INSERT INTO bds_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Inkoo, gi ooyiri Yeesu, gugi leehhesiri mara gu hhapalooay gu didiruge. Peetiro gigi sirakoomi alungo hari seesegeẽ. ");
INSERT INTO bds_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Inay giyaa ilii hheꞌesiri hamisa aslaa tla⁄aã gu efeenaage, gi ibiidiri sliimaa. Da hheꞌesi Peetiro gi ibiidi tla⁄aã gooinay. ");
INSERT INTO bds_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Teꞌesii, yondimiisoꞌoo waka sagameeriya gugi arinti Peetiro hiĩ ibiidi ilaciyaa haa cencee da aslaa. Ina gugi iliikaasidi ilaa haa gi kaadi tuba, “Gu lou, heediki see hiĩ sliimaa wana haa Yeesu.” ");
INSERT INTO bds_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Teꞌesii, Peetiro gi tlanki, tay kakaana tuba, “Igi de sagameeriya, ana haguti hhidima ina.” ");
INSERT INTO bds_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Qariqaaqari coko⁄o, heedi waku gi arimi Peetiro, gi kaay tuba, “Ugu see ti leẽ tla⁄aã gooinay!” Peetiro gi ilaki⁄isi tuba, “Hiiye, ana gooba!” ");
INSERT INTO bds_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kara, daa ilii cati qatlay gu saa leẽ, heedi waku gi ilakwikwihhi tuba, “Gu lou, heediki yaa sliimaa wana haa Yeesu, maꞌaana ina slime ti Galilaaymoo.” ");
INSERT INTO bds_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Inkoo, Peetiro gi ilaki⁄isi tuba, “Ugu hiiye, ana ti hhidima idoo ga giimaamiside.” Qatlaykeesii loi loi, tay ina hiti kahhi gimbage, konkaku gi ceei. ");
INSERT INTO bds_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Da hheꞌesi, Looimoo gu Goõ, gii fookidi, gi yuꞌudi Peetiro. Peetiro giislay gimbakira gu Looimoo suguũ kaay tuba, “Letuti konkaku giyoo ilii kahhiye ceearaa, ugu hanooti tlankida waa tami.” ");
INSERT INTO bds_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Teꞌesii, Peetiro gii ca⁄i khoorooge, gi ⁄aa⁄i hari slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Da hheꞌesi, hida hhakira gwaa ga⁄aa⁄awee Yeesu, gwaa belendeqemisiri haa gugi difiri. ");
INSERT INTO bds_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Inay gugi khiidiniri ilaa kosi hari dahhamiya haa gugi maamisiri ina tuba, “Aare tletimi! Sandi kaade ha miyaa nugungii maahhasi!” ");
INSERT INTO bds_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kara gi ilakoniri gimbuumisu gimba wa⁄a gu wahaaharu ina. ");
INSERT INTO bds_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Qatlay daa iliipisi, balasaa da didiri da gaduũ gu Yahuudi gii kurunkuridiri daqa lenge. Tla⁄aã gooinay yaa wanay hhapalooee da deni haa maarimamaa da sariyaa. Da hheꞌesi, Yeesu duguraagi khay pandaa da balasateesii da didirige. ");
INSERT INTO bds_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Inay sugugi kaayri tuba, “Bere ugu na Kristu, aare sandi kaade.” Yeesu gigi ilaki⁄isi inay tuba, “Bere sanguma kaay see gimbaki, ha ⁄imbidaaiiba. ");
INSERT INTO bds_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bere ana see hangu maasa unkuray gimba, hani ilaki⁄isidaaiiba. ");
INSERT INTO bds_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Teesaaqay see, qatlaykaa gu inkoogo, Nanku Heedi ibiidi hari daba gu ⁄uya gu Iliitleemu, gu kooma ⁄uuru goõ.” ");
INSERT INTO bds_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Teꞌesii hida goõ gi kaayri tuba, “Inkoo, ugu na Nanku Iliitleemugo?” Ina sigigi ilaki⁄isi tuba, “Unkuray niĩ kaadiri tuba, ana na ina.” ");
INSERT INTO bds_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Da hheꞌesi, inay gi kaayri tuba, “Inkoo, ti ilatlawa mala waka kara ga slaꞌane? Maꞌaana, dandiray loi hanti akhasani gimbaki afa gosaa loaa.” ");
INSERT INTO bds_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Da hheꞌesi, balasatee da didiri goõ gii tlaydi, gi leehhisiri Yeesu daqa Pilaatuge. ");
INSERT INTO bds_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Inay gugi tlaatleesiri sitaakiru ina, kakaanay tuba, “Heediki haguũ slayni hiicoridi hida gu hhapee doori. Tlaatlahhaahhamisi hida, ma mayri buꞌuduu koodi sa Kaysaari, kara hingi eteediidina tuba, ina na Kristu, mutemi.” ");
INSERT INTO bds_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Teesaaqay, Pilaatu gi maasi Yeesu tuba, “Ugu na inaa mutemi gu Wayahuudi?” Yeesu gi ilaki⁄isi ina tuba, “Ugu niĩ teesaaqay kaadi!” ");
INSERT INTO bds_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaatu gi kaay sa hhapalooee da deni haa sa raqatee da hida tuba, “Ana haã arimiiba gimba lensee gu hukuruu heediki!” ");
INSERT INTO bds_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Teꞌesii, inay gi ilakwikwihhiri tuba, “Heediki hiifaafahhaahhana hida hari caacaahhamisu gosi hhapee sliimaa da Yahuudi. Ina yaa Galilaayago tlaatleesi inkoo yaani day tiꞌii Yerusaleemuge!” ");
INSERT INTO bds_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Qatlay Pilaatu giyaa ilii akhasi gimbakee, gi maasi inay bere Yeesu ti Galilaaymoo. ");
INSERT INTO bds_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ina giyaa ilii baraslayi tuba, Yeesu tawaaloo da Heroodege wana, gugi leehhisi daqa Heroodege, slime balalu hhakeesii Heroode yaa wana Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Qatlay Heroode giyaa ilii arimi Yeesu, ina yaa hhaꞌaluudi hari khisla. Balalu wa⁄a yaa slai arimaa ina, sa gimba ina yaa akhaakhamisi gimba gu Yeesu. Kara yaa kona kwayru gu arimaa Yeesu, laqane gimba goó bakaꞌasa hida. ");
INSERT INTO bds_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroode gi maamisi Yeesu gimba wa⁄a. Teesaaqay see, Yeesu gwaa ilaki⁄isiiba ina gimba lensee. ");
INSERT INTO bds_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hhapalooee da deni haa maarimamaa da sariyaa da diini, gi qadimiti, gi sitaakiniri Yeesu hari ⁄uuru. ");
INSERT INTO bds_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Da hheꞌesi, Heroode haa sirikaarii dosi, gi belendeqesiri Yeesu haa gugi qooqiidiri. Kara, sugugi daasiri qayriya da hhoi hari khisla, gugi ki⁄isiri daqa Pilaatuge. ");
INSERT INTO bds_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Letutee loi, cada koinaa Heroode haa Pilaatu hingigi ilagaamisiri. Maꞌaana wakaꞌalee yaa konay kiiraa tla⁄aã gooinay. ");
INSERT INTO bds_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Da hheꞌesi, Pilaatu gi eteedi hhapalooee da deni, giyaadimiisee da Yahuudi haa hida gwaa waaree, ");
INSERT INTO bds_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","gi kaay sa inay tuba, “Unkuray haguraani khaydiri heediki daqa dooii kakantay tuba, papa⁄eedeedemisi hida. Inkoo yuꞌudaa, ana haguũ laala⁄asi ina tiꞌii pandaa doogunay goõ. Ana haã slayiiba gimba lensee gu sitaakaa dooguna daqa heedikii. ");
INSERT INTO bds_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Slime, Heroode see yaani arimiiba gimba lensee gu hukuruu heediki, hatee na idoo sugwaani ki⁄isi ina daqa doorii. Inkoo yuꞌudaa, hhaku gimba lensee giyaa yondiidi ina, guraa hiiboo⁄u hukuruu gwaaꞌaraa. ");
INSERT INTO bds_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Inkoo, ana ha ilafahha, ina duguma difi, doo hheꞌesiye ana hagu geemaw ina, ma waaudi.” ");
INSERT INTO bds_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Teꞌesii, hida goõ gi maahhiri sliimaa tuba, “Heedikee ti gaasaku! Sandaa gwete Baraaba khiidimoogo!” ");
INSERT INTO bds_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraaba dugwaati khiidimi jeerage, sa gimba yaa ⁄isimi khoslongora yaamuge, haa sa gimba gu cu⁄uduũ.) ");
INSERT INTO bds_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kara, Pilaatu gi gimbuusi haa inay, sa gimba, ina yaa slai geemawaraa Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Teesaaqay see, inay gi ilakoniri maahhoo kakaanay tuba, “Tluhhumisakuu musalaabage, tluhhumisakuu ina!” ");
INSERT INTO bds_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatu sigigi kaay inay waa da tami tuba, “Sa soꞌoyi? Heediki hinti mala dakusi? Ana haã slayiiba gimba lensee daqa dosii, guringii boo⁄u ina duguma hukumi gwaaꞌaraa. Teesaaqay, ina dugu difi hari jeleedimaiĩ, doo hheꞌesiye ana hagu geemaw ina.” ");
INSERT INTO bds_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Inkoo, inay gi ilakoniri maahhoo hari afoo da didiri tuba, Yeesu kwanda dugu hiitluhhumisiye. Teesaaqay maahhoo da afoo dooina gi kaba⁄adi. ");
INSERT INTO bds_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Teꞌesii, Pilaatu gi ⁄imbi, gi kereꞌesi gimba gooina, idoo giyaa iliislaiyee gooay inay. ");
INSERT INTO bds_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilaatu yaagii ca⁄asi heedikira daa khiidimi jeerage, sa gimba gu khoslongora haa sa cu⁄uduũ, inay giyaa firiirinee. Ina gi taatahhi Yeesu daqa dooinay, idoo gi iliislaiyee gooay. ");
INSERT INTO bds_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Qatlay sirikaarii giyaa ilii leehhiihhimisiyee Yeesu, yaa ooyiri Simooni yaamulooay gu Kireene, gwaa qaymoo dahha. Inay sugugii tleke⁄esiri musalaaba, magu geregedi aluũ gu Yeesugo. ");
INSERT INTO bds_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Raqa da didiri da hida yaa sirakomaamita Yeesu. Tla⁄aã gu hida hhakeesii tigay yaa wanay, gwaa ⁄aa⁄ii⁄imee haa gwaa gaimaamidee sa Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Teꞌesii, Yeesu gigi ilii fookidi, sigigi kaay tuba, “Ye tigayi gu yaamu gu Yerusaleemu, hhanti ⁄aa⁄aday sa ana. Ba⁄ay hiti ⁄aa⁄a sa unkuray haa sa yaꞌay kokuna. ");
INSERT INTO bds_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maꞌaana, yuꞌudaa balalu yaa khociyay, hida gimaa iliikaayiyee tuba, ‘Digaa ⁄aafi hhakaꞌa gu mogombiisee, guraiĩ goóba laqwaloo haa isaꞌami goóba ruꞌumisu!’ ");
INSERT INTO bds_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kara qatlaykee, hida maa tlaatleesiyay kakaaru sa omeeri tuba, ‘Omeeri handaa iliihuhuꞌudee, kara tioo handi ilakhupitee!’ ");
INSERT INTO bds_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Maꞌaana ilahudeesa, bere hida hiĩ yondiidiri taqay qatlay khaimoo gi ilii naa⁄iye, maa malaaꞌay khaimoo gwaa kawge?” ");
INSERT INTO bds_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Slime fitlaalootiisee cada digaa leehhisi, digima cu⁄uduũ kay sliimaa haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inay giyaa ilii dayri tiia wakay, doó eteedine na “Faraa da Saga,” teꞌesii gii tluhhumisiri Yeesu musalaabage, sliimaa haa fitlaalootuusetee cada musalaababuu koinay. Leẽ gugi qaasiri hari bara da ⁄uya da Yeesu gu caduu hari bara dosi da basa. ");
INSERT INTO bds_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeesu gi kaay tuba, “Ye Taataa, ilamooyimi hida hhanki, sa gimba hiti hhidinay, idoo gi yondimaamidiyee.” Da hheꞌesi, inay hingigi deehhiniri qayroo kosi, harii slakharaa kuura. ");
INSERT INTO bds_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hida gi qadimidiri gu tooinaa khuꞌunay ina. Slime giyaadimiisee da Yahuudi gugi belendeqemisiri ina hari kakaaru tuba, “Ina yaa ilabuꞌuuꞌumi wakinay. Inkoo, ina see hingi ilabuꞌune ina lenkosi, bere gu lou ina na Kristu, daay leehhi ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Slime sirikaarii see, gugi belendeqemisiri ina, yaagii satiri ciyoomoo gosii, sugugi hadisiri difaay da mahhaaꞌa, ma kitahhi. ");
INSERT INTO bds_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Inay sugugi kaayri tuba, “Bere gu lou, ugu na mutemi gu Wayahuudi, hangu ilabuꞌunte ugu lenkoogu.” ");
INSERT INTO bds_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kara handikaa yaa wanta daa kufi musalaabage rawaa gu saga gosii tuba, “HIĨ NA MUTEMI GU WAYAHUUDI.” ");
INSERT INTO bds_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Da hheꞌesi, leẽ gu fitlaalootuusetira, daa hiitluhhumisi sliimaa haa ina, gugi belendeqesi, gi kaay tuba, “Ugu caba na Kristu? Hangu ilabuꞌunte ugu haã dandiray see.” ");
INSERT INTO bds_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Teꞌesii, hikira gu caduu gugi ilaki⁄isi haa gugi ilii⁄oo⁄i, gi kaay tuba, “Ugu hoó tlaꞌamutaabaslii Iliitleemu, qatlay ugu see, hukumukeesii wanta? ");
INSERT INTO bds_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kara gu lou, dandiray dandinti hukumi hari haaki, maꞌaana hanti slayni hukumuu guraa hiiboo⁄u yondu goori gaa yondiidani. Yuꞌudiyaa, heediki yaa laqiiba gimba lensee gu tlaku.” ");
INSERT INTO bds_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Da hheꞌesi, ina gi kaay tuba, “Ye Yeesu, hanii slayde qatlay goo ilii daade daqa Tawaaloo dooguu.” ");
INSERT INTO bds_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu sugugi ilaki⁄isi ina tuba, “Gu lou, sugu kaay ugu, letuti loi hoo sliimaa wanta haa ana Paradiisoge.” ");
INSERT INTO bds_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Inkoo, daa ilii buꞌudi saa lahhoꞌo da tleemaa, hhantee yaa ilaslaabidi hhapee goõ saa gweleti naqatloo. ");
INSERT INTO bds_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Cencee da letu gi maydi hiida⁄araa, kara pasiyaa da mara gu didiru gu Iliitleemu gii feehhiti kaeeri cada. ");
INSERT INTO bds_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Da hheꞌesi, Yeesu gii ⁄aa⁄isi hari afoo da didiri, gi kaay tuba, “Ye Taataa, dabaiĩ kokuu haã qaasi muuna goy.” Giyaa ilii hheꞌesi kaawaraa gimbaki, gi tosaa hhami. ");
INSERT INTO bds_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Teꞌesii, sirikaarimoo gu didiru giyaa ilii arimi gimbakee gungii ca⁄u, gi daareesi Iliitleemu, kakaana tuba, “Gu lou, heediki yaa kona ibinaa daa tafaꞌadi.” ");
INSERT INTO bds_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Raqa da hida yaa hiikurunkuriti sliimaa sa arimaa da gimbaki. Inay goõ giyaa ilii aniri gimbaki gungii ca⁄u, gi ki⁄iri ayeemaa koinay, tay inay tooinaa puupukhumisiyay muunaiĩ koina hari slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hhakira goõ gwaa khuee Yeesu naraꞌa, sliimaa haa tigay hhakira gwaa sirakomaamidee ina Galilaayago, gi qadimidiri segenge, tay tooinaa khuꞌunay gimbakee. ");
INSERT INTO bds_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Inkoo, heedi leẽ yaa wana uma gosi na Yoseefu, yaamulooay gu yaamu gu Arimataaya, hhapee da Yudaayage. Ina yaa heedi gu hhou haa gwaa kooma ibinaa daa tafaꞌadi pandaa da Iliitleemuge. Kara yaa leẽ tla⁄aã gu giyaadimiisee da balasaa da didiri da Wayahuudi. Ina hingaa ila⁄imbidiiba haa balasatee da didiri haa yondu gooina gu gaasaraa Yeesu, ina yaa baqaaqamidi, khawaraa da Tawaaloo da Iliitleemu hari kwayru gu didiru. ");
INSERT INTO bds_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yoseefu gi hadakay daqa Pilaatuge, gi firimi suguma hadisi tuuꞌuna da Yeesu, magi qaasa kay. ");
INSERT INTO bds_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yoseefu yaagii ⁄eetisi tuuꞌunatee hhapeege. Ina gigi khiidimi hari qayru gu ⁄abaaku, gigi qaasa kay ayisa daa hiikhuri hhafidage. Ayisati dagaa kahhi iliiqaasa heedi lensee. ");
INSERT INTO bds_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Balotee yaa baloo da ilakhuukhuꞌumisu, maꞌaana, Sabaato yaa daadaauusidi tlaatleesaraa. ");
INSERT INTO bds_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tigay hhakira gwaa hhiyuudee sliimaa haa Yeesu Galilaayago, gi sirakoniri Yoseefu, gi aniri ayisa haa idoo tuuꞌuna da Yeesu dagaã ilii qaatisi teꞌesii waꞌayge. ");
INSERT INTO bds_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Da hheꞌesi, yaagi ki⁄iri ayage, gi ilakhuukhuꞌusiri du⁄iya da hhoi haa du⁄iya da tafu hhoi. Baloo da Sabaatoge gii fiifisiri, idoo daa ilii handikimi gooay sariyaa da Musaage. ");
INSERT INTO bds_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Inkoo, baloo da Jumaapiiri hari tumpaatumpu, tigay hhakira gii oyiri du⁄iyatira da tafu hhoi, giyaa ilakhuukhuꞌusiri haa gi hadakayri ayisage. ");
INSERT INTO bds_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Inay giyaa ilii dayri, gi slayri tlaa⁄atira, dagaã gwangwaraai ayisago. ");
INSERT INTO bds_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Giyaa ilii guniri waꞌay gu ayisage, inay yaa aniriiba slaqwa da Looimoo gu Goõ Yeesu. ");
INSERT INTO bds_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Qatlay giyaa ilii kahhiyee hiĩ bakaakairi sa gimbakee, cirakiray hida cada hingagii ca⁄asiri, gi qadimidiri ilaciyaa koinay, gwaa daamisee qayroo gu wanqawanqee mankaraaiya pahha. ");
INSERT INTO bds_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tigay hhakee digigi ilii guumi ha dahhiya, gii gupu⁄umisiri pandadu koina hhapeege naqatloo. Hida hhakira gi kaayri sa tigay hhakee tuba, “Soꞌoyi damaamitay heedi gu slafa tla⁄aã gu tuueenaage? ");
INSERT INTO bds_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wanaaba tiꞌii, Iliitleemu gungii tlaysi! Slawuu idoo sangwaa ilii kaay, giyaa iliiwane sliimaa haa unkuray yade Galilaayage tuba, ");
INSERT INTO bds_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kwanda Nanku Heedi dugu hiilu⁄iye dabaiĩ gu hida gu koomeege tlakwaroo. Dugu hiitluhhumisi musalaabage, kara, baloo da tamiige yaa slafi.’ ” ");
INSERT INTO bds_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Da hheꞌesi, tigay hhakee gii slayri gimbakee gu Yeesu giyaa kaay. ");
INSERT INTO bds_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Qatlay tigay hhakee giyaa ilii ki⁄iri ayisago, gi ilakeesiri gimbakee goõ, sa sirakoomiisetira da mibi haa leẽ sliimaa haa wakinay goõ. ");
INSERT INTO bds_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tigay hhakee, umaiĩ koina niĩ Mariyaa Magidaleena, Yoaana, Mariyaa iyoo da Yakoobo, haa tigay wakinay gwaa waaree sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ya⁄abimiisee, tigay hhakee giyaa ⁄imbiriiba, kara gimbaki gwaati aniri konaaba maꞌaana see. ");
INSERT INTO bds_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Teesaaqay see, Peetiro gii tlay haa gi taa⁄adi ayisa naqatloo. Qatlay giyaa ilii day, gii condoi, gii juurisi waꞌay gu ayisage, gi arimi qayrukira kilesi gu ⁄abaaku. Da hheꞌesi, ina gi ki⁄i, tay hiĩ tosaa bakai sa gimbakee gungii ca⁄u. ");
INSERT INTO bds_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yuꞌudiyaa balotee loi da Jumaapiiri, sirakoomiisee cada da Yeesu yaa hhiyumaamita tongoo waka khuꞌusa, daa eteediidine na Emaaw. Tongotee segaruũ kosi yaa khocu gu saa cada Yerusaleemugo. ");
INSERT INTO bds_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Inay haa inay yaa giimaamisiyay gimbakee goõ gungii ca⁄u. ");
INSERT INTO bds_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Qatlay giyaa ilii cocaacoiyee haa hingi maamisiyay gimbakee, Yeesu ina loi giyaagi iliisati, gi khoci sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Teesaaqay see, ilaa koina digaa hiibo⁄eesi ha Iliitleemu, magu mayri baraslawaraa ina. ");
INSERT INTO bds_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeesu gigi maasi inay tuba, “Ti gimba mala hiĩ ga giimaamisidee unkuray haa unkuray, ga ilii khociicintee?” Inay gi qadimidiri, tay pandadu koina konay slahhaaꞌamee. ");
INSERT INTO bds_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Leẽ tla⁄aã gooinay, uma gosi daa eteediidine na Kileyoopa, gugi ilaki⁄isi ina tuba, “Ugu kilesi na dahaagoo Yerusaleemuge, gu hhidima gimba gungii ca⁄u teꞌesii baalahhanki?” ");
INSERT INTO bds_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeesu gigi maasi inay tuba, “Ti gimba mala hikee?” Inay gugi ilaki⁄isiri tuba, “Gimba gu Yeesu gu Nasareeti. Ina yaa tletimiisay, kara gwaa kooma hiidahhasa da didiri gimba gosiige haa yondu gosii pandaa da Iliitleemuge haa pandaa da hida gonge. ");
INSERT INTO bds_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hhapalooee da deni haa giyaadimiisee da tawaaloo doori, gwaa hiilu⁄iri ina hukumuu gu gwaaꞌaraage. Inay gugii tluhhumisiri musalaabage. ");
INSERT INTO bds_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dandiray haa kona iliipaꞌaru tuba, ina niĩ aloo ilabuꞌuna Israeeli daqa fa⁄ayaago. Kara, letuti ti balalu tami hingii catiri, qatlay gimbaki sliimaa giĩ iliica⁄i. ");
INSERT INTO bds_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Slime, tigay wakinay gu raqa doori hindii bakaꞌasiri dandiray. Inay hiĩ hadakayri ayisage letuti tumpaatumpu, ");
INSERT INTO bds_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","slaqwa dosi giĩ slayriiba. Inay yaagi ki⁄iri, gi kaayri tuba slime digaani iliica⁄i ha malayika yade ayisage, sigaani kaawee tuba, Yeesu ti slafi. ");
INSERT INTO bds_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Da hheꞌesi, deneꞌee koti wakinay hiĩ hadakayri ayisage, gi slayri ayisa namati tiraaqay, tigay hhakira gooay idoo giĩ ilii kaayri. Teesaaqay, ina guũ aniriiba.” ");
INSERT INTO bds_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeesu gi kaay sa inay tuba, “Ye unkuray gu hhidimee, gwaa muunaiĩ hiiloaaꞌawee ⁄imbaraage gimba goõ, daa kakaami ha tletimiisee da Iliitleemu! ");
INSERT INTO bds_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Caba yaati kwanda, Kristu dugu labaꞌasiye hari amotee. Da hheꞌesi ma hiiday wanqamee dosii da didirige?” ");
INSERT INTO bds_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Da hheꞌesi, Yeesu sigigi ilakeesi, idoo Handikaa da Iliitleemu giyaa ilii kaadi daqa dosii, gi tlaatleesi handikaa da Musaago haa handikaa da tletimiisee goõ da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Inay giyaa ilii daadaauusiri tongotiray giyaa kakaakayee, Yeesu gi laqi ubee, hitii cacaacati pahha pandaage. ");
INSERT INTO bds_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Teꞌesii, inay gugi tlaatlaqasiri hari khisla, kakaanay tuba, “Ibiidi tiꞌii sliimaa haa dandiray, sa gimba inkoo hiti khwayaiĩ, kara amasi see yaani dayri.” Teesaaqay, ina gii day marage, gi ibiidi sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Qatlay Yeesu giyaa ilii ibiidi sliimaa haa inay meesaage, ina gii oyi mukaatimoo, gi daareesi Iliitleemu. Da hheꞌesi gugi fendehhemisi haa sigigi hadimisi inay. ");
INSERT INTO bds_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yuꞌudiyaa! Ilaa koina digigi pooisi, inay gugi asu baraslayiri tuba, ti Yeesu. Cirakiray, ina gii hhancooi ilaa koinaa. ");
INSERT INTO bds_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Inay hingigi maamisiri inay haa inay tuba, “Muunaiĩ koti hiĩ ooyiiyinaaiibaslii waꞌay kotii, ina giĩ ilii giimaamisiye haa dandiray amooge, tay ilakesidi sa dandiray Handikaa da Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Namati qatlaykeesii, cirakiray inay yaagi ki⁄iri Yerusaleemuge. Inay gi slayri sirakoomiisetira da mibi haa leẽ, hingii kurunkuridiri daqa lenge sliimaa haa hhakira gwaa waaree haa inay. ");
INSERT INTO bds_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Teꞌesii gigi akhasiri, kakaanay tuba, “Gu lou, Looimoo gu Goõ yaani slafi, kara yaani iliica⁄i Simooni.” ");
INSERT INTO bds_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Da hheꞌesi, hhakira gu cada gi ilakeesiri sa deneꞌee koina, gimba gwaanii ca⁄u daqa dooinay amooge, haa idoo giĩ ilii baraslayiri Yeesu, giĩ ilii fandakusi mukaatimoo. ");
INSERT INTO bds_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Qatlay inay giyaa ilii giimaamisiyee gimbakee, Yeesu gi qadidi tla⁄aã gooinay, gi kaay sa inay tuba, “Qasaw wane sliimaa haa unkuray.” ");
INSERT INTO bds_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Teꞌesii, inay hirigii tlairi haa gi tlaꞌamuudiri, tay ilahudeemisiyay tuba, hiĩ iliitleemimoo aniri. ");
INSERT INTO bds_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yeesu gi kaay tuba, “Haã soꞌoyi tlaꞌamutiri? Kara soꞌoyi kontay qiigiꞌimoo muunaiĩ kokunay? ");
INSERT INTO bds_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inkoo, unkuray arima dabaiĩ koi haa yeꞌeeroo koi, ma antiri tuba ti ana loi. Hani slaapaaꞌamisidee, ma caahhadiri gu lou. Maꞌaana iliitleemimoo konaaba slaqwa, konaaba fararu, idoo ana gooay ganiĩ ilii antiri ha kooma.” ");
INSERT INTO bds_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Qatlay Yeesu giyaa ilii hheꞌesi kaawaraa gimbaki, sigigi laqami inay dabaiĩ kosi haa yeꞌeeroo kosi. ");
INSERT INTO bds_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Inay yaa kahhiyay ⁄imbaraa haa hiĩ bakairi sa hhaꞌaloo giyaa koneei. Teꞌesii ina gigi maasi inay tuba, “Kontaai ⁄agoo tiꞌii?” ");
INSERT INTO bds_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inay sugugi hadisiri ina, samaakimoo daa deequmi. ");
INSERT INTO bds_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ina gigii oyi, gigi ⁄agimi pandaa dooinay. ");
INSERT INTO bds_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Da hheꞌesi, ina gi kaay sa inay tuba, “Hiĩ na gimbakira koyi sangwaa kaay unkuray. Qatlay gaa iliiwaare sliimaa haa unkuray, haa kaay ambee, kwanda gimba goõ dugu hiigaasiye, daa handikimi daqa dooi sariyaa da Musaage, handikaa da tletimiiseege haa Daareesooge.” ");
INSERT INTO bds_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Teꞌesii, Yeesu gi pooisi caahhamuu koina, ma caahhiri maꞌaana da Handikaa da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ina sigigi kaay inay tuba, “Teesaaqay daganaa ilii handikimi tuba, Kristu dugu labaꞌasi, kara baloo da tamiige yaa slafi. ");
INSERT INTO bds_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kara, hari uma gosi, kwahharaa da tlakwaroo haa ilamooyiru gu tlakwaroo dugu kakaana sa hhapapu goõ, tiaa tlaatleesi Yerusaleemugo. ");
INSERT INTO bds_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Unkuray na masaydii da gimbaki. ");
INSERT INTO bds_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yuꞌudaa! Ana sangwaa ya⁄aba Muuna gu Iliitleemu, hiĩ daa hiifadidi ha Taataa goy tuba, sangu hadisi. Inkoo, unkuray ibiida Yerusaleemuge, qatlaykaꞌa naqatloo sangumaa ilii hadisiye hiidahhasa rawaa gu rawgo.” ");
INSERT INTO bds_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Da hheꞌesi, Yeesu girigi giyaadi inay teꞌesaa kenga gu yaamuge tongoo da Betaniyaa naqatloo. Ina gi waratlaysi dabaiĩ kosi, gigi ⁄aafi inay. ");
INSERT INTO bds_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Qatlay ina giyaa ilii ⁄aafaafidiye inay, ina dugugii oyi daqa dooinaa, dugurigi tosaa waaudi rawaa gu rawge ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Da hheꞌesi, inay gugi hhaꞌaleesiri ina, yaagi ki⁄iri Yerusaleemuge hari hhaꞌaloo da didiri. ");
INSERT INTO bds_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Balalu sliimaa inay gi ibiidiri mara gu didiruge gu Iliitleemu, tooinaa daareemisiya Iliitleemu.");
INSERT INTO bds_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tlaatleesoogo khooroo sagaa kahhiye tlehhinay, Gimba yaa wana. Gimbakee yaa sliimaa wana haa Iliitleemu. Kara, Gimbakee yaa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tlaatleesoogo Gimba yaa sliimaa wana haa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hari amoo dosi idadu goõ digaati tleehhi. Kara, wantaaba idoo lensee daaba tlehhinay hari amoo dosi. ");
INSERT INTO bds_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ina na tlaatleesoo da slafimaa, kara slafimaa hhakee hiraa khayri cencee sa hida. ");
INSERT INTO bds_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Slime cencetee wanqada hhanteege, kara hhantee giyaa hiidahhasidiiba kaba⁄a cencetee. ");
INSERT INTO bds_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Heedi waku yaa khay daa ya⁄abi ha Iliitleemu, uma gosi na Yohaana. ");
INSERT INTO bds_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ina yaati khay sa ilatlawa cencetee sa hida, haa hari amoo dosi hida goõ ⁄imbiyee cencetee. ");
INSERT INTO bds_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohaana yaa cencetee gooba. Ina yaati khay, ma ilatlay cencetee sa hida. ");
INSERT INTO bds_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Haã na cencee da loi daa khoca khoorooge haa gii cencuusida kila heedi. ");
INSERT INTO bds_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gimbakee yaa wana khoorooge, kara hari amoo dosi khooroo dagaa tleehhi. Teesaaqay see, khooroo gwaa baraslaydiiba ina. ");
INSERT INTO bds_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ina yaati khay daqa hida kosii, teesaaqay see, hida kosi gwaa ⁄imbiriiba ina. ");
INSERT INTO bds_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hida goõ gwaa oowee ina, sigaa hadisi haaki da yaꞌay gu Iliitleemu tleehhida, hhakee na hida hhakaꞌa gwaa ⁄imbee uma gosi. ");
INSERT INTO bds_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yaꞌay hhakee ti hhakaꞌaaba daa laqwali hari amoo da slaslaw hhawata haa hadee, baku hari slahhaahhaau gu slaqwa, baku hari slaꞌamuu gu hhawata, ti Iliitleemu nigaa tleehhi. ");
INSERT INTO bds_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Inkoo, Gimbakee gi heedi tleehhidi, gi ibiidi sliimaa haa dandiray. Dandiray haã arini wanqamee dosi, wanqamee da Naw gu leẽ gwaa daqa Taataa dahha, yaani haci hhoinay gu didiru haa gu lou. ");
INSERT INTO bds_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohaana yaa ilatlatlay sa hida gimba gosi, sigigi kaay hari afoo da didiri tuba, “Hiĩ na hikira gaa kaay gimba gosi ambee, ‘Ina gwaa khoca aluũ koaa hikee gu didiri ba⁄ay da ana, sa gimba ina yaa wana ana dinaa ilii kahhiye see laqwaloo.’ ” ");
INSERT INTO bds_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Slayii tuba hari buꞌudisaraa dosi, dandiray goõ haã oowani hari khisla hhoinay gu didiru gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sa gimba, sariyaa dagaati hadisi ha Iliitleemu hari amoo da Musaa. Hhoinay gu didiru haa gimba gu lou, yaati khay hari amoo da Yeesu Kristu. ");
INSERT INTO bds_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hhaku heedi lensee gwaa arimu Iliitleemu qatlay lensee. Ti Naw gu leẽ kilesi ina gu Iliitleemu gu sliimaa waara haa Taataa, hikee naa hiitlaaꞌasi Iliitleemu daqa doorii. ");
INSERT INTO bds_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Baloo waka giyaadimiisee da Wayahuudi yaa ya⁄abiri hhapalooee haa Walaawi daqa Yohaanage, Yerusaleemugo. Haã na ilatlawa da Yohaana, gwaa ilii maasiri tuba, “Ugu na miyaa?” ");
INSERT INTO bds_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohaana yaati gimbuusi pandataa yakwaraa see guba tuba, “Ana Kristu gooba.” ");
INSERT INTO bds_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Teꞌesii, inay gugi maasiri tuba, “Inkoo, ugu ti miyaa? Ugu na inaa tletimiisay Eliyaa?” Yohaana gi ilaki⁄isi tuba, “Suti, ana na inaaba.” Gugi maasiri tuba, “Inkoo, ugu na tletimiisaykiraa?” Yohaana gigi ilaki⁄isi tuba, “Suti, ana na inaaba.” ");
INSERT INTO bds_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Inay gugi maasiri kara tuba, “Inkoo, ugu ti miyaa? Kara ugu hati mala oiiꞌinta daqa dooguu ugu loi? Sandi kaade, ma slayni gimba ga leehhisane sa hhakira gundaani ya⁄abee.” ");
INSERT INTO bds_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohaana gigi ilaki⁄isi inay hari gimba gu tletimiisay Isaaya tuba, “Ana na afoo da heedi gu kakaakama kongoqomeege tuba, ‘Tafaꞌasa amoo da Looimoo gu Goõ.’ ” ");
INSERT INTO bds_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Inkoo, hida hhakee daa ya⁄abi, yaa daqa Farisaayoo dahhiyay. ");
INSERT INTO bds_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Inay gugi maasiri ina tuba, “Bere ugu Kristu gooba, Eliyaa gooba, kara tletimiisaykiraaba, inkoo ugu sa soꞌoyi hiinunqudiidimisida?” ");
INSERT INTO bds_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohaana gigi ilaki⁄isi inay tuba, “Gu lou, ana hanguri maꞌay kilesi hiinunqudimisa. Wana leẽ guũ qadidu tla⁄aã googunay, unkuray hagu kahhaday caahha. ");
INSERT INTO bds_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hikee gwaa khoca aluũ koaa, ana haraa hiiboo⁄iiba tongimoo gosi tleehhida, gimati gweedaraa dincaaraa da ye⁄eetoo kosi.” ");
INSERT INTO bds_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gimbakee yaa yade hiicaca⁄i tongoo da Betaniyaage, hari tlo⁄osaa gu duudu gu Yoridaani, yade Yohaana daqa giyaa ilii nunqudiidimisiye. ");
INSERT INTO bds_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Heetlaalee dosii, Yohaana yaa arimi Yeesu yaa khoci daqa dosii, gi kaay tuba, “Yuꞌudaa! Hiĩ na ⁄ambeenimoo gu Iliitleemu gu hiiowa tlakwaroo da khooroo. ");
INSERT INTO bds_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hiĩ na hikira sangwaa kaay gimba gosi ambee, ‘Ina gwaa khoca aluũ koaa, ina na didiri ba⁄ay da ana, sa gimba ina yaa wana ana dinaa ilii kahhiye see laqwaloo.’ ");
INSERT INTO bds_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gu lou, ana loi haguũ caahhiiba ina. Teesaaqay see, ana hanti khay haa hiinunqudimisa hari maꞌay, ina duguma hiitlaaꞌasi daqa hida gu Israeelige.” ");
INSERT INTO bds_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Da hheꞌesi, Yohaana gi ilatlay, kakaana tuba, “Ana haã arimi Muuna gu Iliitleemu yaa hii⁄eeti tlabiya pahha rawaa gu rawgo haa gii ibiidi daqa dosii. ");
INSERT INTO bds_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gu lou, ana loi hagwaa caahhiiba ina. Teesaaqay see, ina gwaa ya⁄abu ana, ma hiinunqudimisi hida hari maꞌay, sinaa kaay tuba, ‘Heedikaꞌa gamaa ante Muuna gu Iliitleemu yaa hii⁄eeti rawaa gu rawgo haa gii ibiidi rawaa kosii, hikee namaa hiinunqudimisi hida hari Muuna gu Iliitleemu.’ ");
INSERT INTO bds_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ana loi haã arimi gimbaki, haa hagu ilatlatlaatlaw ambee, hiĩ ti Nanku Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Heetlaalee dosii, Yohaana yaa qadidi kara nama daqatiray sliimaa haa sirakoomiisee dosi cada. ");
INSERT INTO bds_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Qatlay Yohaana giyaa ilii arimi Yeesu hiicati hari teꞌesa, gi kaay tuba, “Yuꞌudaa! Hiĩ na ⁄ambeenimoo gu Iliitleemu!” ");
INSERT INTO bds_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Qatlay sirakoomiisetee cada da Yohaana giyaa ilii akhasiri ina gimbuusi gimbaki, inay gi sirakoniri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu gii fookidi alunge, gi arimi sirakoomiisetee cada gwaa sirakonay, ina gigi maasi inay tuba, “Unkuray mala damaamitay?” Inay gugi ilaki⁄isiri tuba, “Maarimuu, ugu kaale ibimaamita?” ");
INSERT INTO bds_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yeesu gigi ilaki⁄isi inay tuba, “Khocaa, unkuray ha arintayi daqa goó ilii ibiide!” Teesaaqay, inay gi hadakayri haa gi ariniri, ina daqa giyaa ilii ibimaamidiye. Qatlaykee daa daadaauusi saa mibi da khwayaiĩ. Inay gi ibiidiri haa ina balotee. ");
INSERT INTO bds_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andareyaa, hhia gu Simooni Peetiro, yaa leẽ gu hhakira gu cada gwaa akhasee Yohaana gimbuusi teesaaqay, haa gi sirakoomi Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andareyaa gi hadakay gesaa gi dabiidukay hhia gosi Simooni haa sugugi kaay tuba, “Dandiray haã arini Masiiya.” Hiĩ slime doó eteedine na Kristu. ");
INSERT INTO bds_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Da hheꞌesi, Andareyaa gugi leehhisi Simooni daqa Yeesuge. Yeesu gi khuꞌumi Simooni haa gi kaay tuba, “Ugu na Simooni nanku Yohaana, inkoo duguti eteedina na Keefa.” Hari Yunaanaisoo umaki gu Peetiro, maꞌaana dosi na hhafida. ");
INSERT INTO bds_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Heetlaalee dosii Yeesu yaa hadakay hhapee da Galilaayage. Ina gi arimi Filiipo, sugugi kaay tuba, “Hanisirakonte.” ");
INSERT INTO bds_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filiipo yaa yaamulooay gu yaamu gu Betisayda, slime ti yaamu guũ Andareyaa haa Peetiro. ");
INSERT INTO bds_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ina see Filiipo gi slay Natanaeeli haa sugugi kaay tuba, “Dandiray haã arini ina gimba gosi daa handakimi ha Musaa kitaabuu gu sariyaage, slime tletimiisee da Iliitleemu yaa handikiniri gimba gosi. Ina ti Yeesu gu Nasareeti, Nanku Yoseefu.” ");
INSERT INTO bds_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeeli gi maasi Filiipo tuba, “Gu louu, idoo da hhoi yaa hiidahhasida hiica⁄a Nasareetigo?” Filiipo gi kaay sa Natanaeeli tuba, “Khoca arimi.” ");
INSERT INTO bds_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeesu giyaa ilii arimi Natanaeeli yaa khoci daqa dosii, gi kaay gimba gosi tuba, “Yuꞌudaa! Hikee na Israeelimoo loi loi, waꞌay kosii wantaaba afaꞌafuuma.” ");
INSERT INTO bds_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Teꞌesii, Natanaeeli gi maasi Yeesu tuba, “Ugu haniĩ malee caahhadi ana?” Yeesu gugi ilaki⁄isi ina tuba, “Ana haguũ arimi ugu, qatlay gaã iliiwante yaqay biraa gu ⁄ancimooge, Filiipo giĩ ilii kahhiye see eteedaraa ugu.” ");
INSERT INTO bds_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Teꞌesii, Natanaeeli sugugi kaay Yeesu tuba, “Maarimuu, ugu ti Nanku Iliitleemu! Ugu ti Mutemi gu Israeeli!” ");
INSERT INTO bds_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu gi ilaki⁄isi, sugugi kaay tuba, “Ugu hanti ⁄imbidii, sa gimba sugunti kaay kilesi ambee, ana haguũ arimi ugu, qatlay gaã iliiwante biraa gu ⁄ancimooge? Yuꞌudiyaa, ha arinta gimba gu denu ba⁄ay da hiĩ.” ");
INSERT INTO bds_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yeesu gi kaay sa ina tuba, “Gu lou, sangu kaay ambee, unkuray ha arintayi raw hiitlaaꞌadi haa malayika da Iliitleemu hiidadayay haa hii⁄eemidiyay daqa Nanku Heedige.” ");
INSERT INTO bds_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baloo da tamiige daa wana losona gu khaboo yaamu gu Kanaa da hhapee da Galilaayage. Iyoo da Yeesu yaa wana teꞌesii, ");
INSERT INTO bds_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","slime Yeesu sliimaa haa sirakoomiisee dosi digaa kwahhasuusi losonakeesii gu khabooge. ");
INSERT INTO bds_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Qatlay difaay giyaa iliifaakidi, iyoo dosi Yeesu gi kaadi sa ina tuba, “Hida hhanki digiĩ afiifaaki difaay.” ");
INSERT INTO bds_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu gi kaay sa ina tuba, “Iyoo, ha soꞌoyi gimbuusida gimbakee daqa dooii? Qatlay goy gu yondu kahhi dawaraa.” ");
INSERT INTO bds_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iyoo dosi Yeesu gi kaadi sa yondimiisee tuba, “Idoo sangoo kaayiye ha ina, unkuray yondiida.” ");
INSERT INTO bds_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Inkoo, teꞌesii yaa wanay sibeedoo lahhoꞌo gu deni daa boo⁄imisi hari tle⁄eẽ, sa iliiqamiduu maꞌay. Sibeedoo hhakee digaati qaasi teꞌesii, sa ou gu Wayahuudi gu ilabuslidu. Kila sibida yaa hiidahhasidi hiiowa duumaaee kooani baku fanqu gu maꞌay. ");
INSERT INTO bds_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeesu gi kaay sa yondimiisetee tuba, “Hacimisa maꞌay sibeedoo hhakeesii.” Inay gi hacimisiri sibeedoo hhakee maꞌay rawaa naqatloo. ");
INSERT INTO bds_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Da hheꞌesi, Yeesu sigigi kaay inay tuba, “Inkoo, slagwaw coko⁄o, leehhisa sa nankuay.” Teesaaqay, inay gii slagwiri haa gi leehhisiri sa nankuay. ");
INSERT INTO bds_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nankuay gi slipa⁄adi maꞌay hhakee dingii fooki gi difaay tleehhidiri. Ina yaa caahhiiba difaaytee daqa giyaa dahhade, yondimiisee gwaa hiislagwee maꞌay hhakee daay fooki yaa caahhiri tlaatleesoo dooina. Teꞌesii gi eteedi looimoo gu khaboo, ");
INSERT INTO bds_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","sugugi kaay tuba, “Kila heedi goó ⁄isima losona, yoóti giyaadisi gesaa hadisa difaay da hhoi. Da hheꞌesi, qatlay hida giĩ ilii kitahhaniri khisla, ina yaa asu hiioy difaaytaꞌa daa hhacaꞌadi. Ugu hanti meesidi difaay da hhoi inkoo naqatloo!” ");
INSERT INTO bds_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hiĩ naa gimba gu pandaa gu bakaꞌasa Yeesu giyaa yondiidi, yade yaamu gu Kanaa da Galilaayage. Ina yaa hiitlaaꞌasi wanqamee dosi, sirakoomiisee dosi gugi ⁄imbiri. ");
INSERT INTO bds_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Qariqaaqari gimbaki giyaa ilii cati, Yeesu yaa hiigweegwe⁄edi tongoo da Kaperinauumuge sliimaa haa iyoo dosi, hhiee kosi haa sirakoomiisee dosi. Inay gi ibiidiri taysi balalu angaamaka. ");
INSERT INTO bds_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Qatlay daa ilii daadaauusi losona gu Pasaaka gu Wayahuudi, Yeesu gi hadakay Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yade mara gu didiruge gu Iliitleemu, Yeesu gi slay hida naadiidinay yakway, bee⁄u haa kundee. Kara gi slay hida hiĩ ibiidiri meesasuu koinay, alaalaanayi peesay daa slaiye mara gu didiruge gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ina gi boo⁄imisi jeleedimoo hari welaa, gi gusiisimi hida goõ mara gu didirugo gu Iliitleemu sliimaa haa bee⁄u haa yakway koina. Kara, gi slaslakhi meesasuu gu hida gwaa alaalaamee peesay haa gi wincalaakhami peesay gooina hhapeege. ");
INSERT INTO bds_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ina gi kaay sa hhakira gwaa naadiidimee kundee tuba, “Surukusa idadu kokuna tiaa! Mawu gimbaki! Hhantii fookiday mara gu taataa goy daqa da iliikirigiru haa naadiidiru idadu.” ");
INSERT INTO bds_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Teꞌesii, sirakoomiisee dosi gii slayri gimba daa handikimi Handikaa da Iliitleemuge tuba, “Slaꞌamuu ga koome sa mara gu Iliitleemu, hini ⁄agiyay.” ");
INSERT INTO bds_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Da hheꞌesi, giyaadimiisee da Wayahuudi gi maasiri Yeesu tuba, “Ti gimba mala gu bakaꞌasa ga laqade, gu maꞌasa tuba, ugu ha konta haaki da yondu gimbaki?” ");
INSERT INTO bds_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu gigi ilaki⁄isi inay tuba, “Ilacata maraki gu didiru gu Iliitleemu, ana hagu tleehha balalu tamige!” ");
INSERT INTO bds_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Teꞌesii, giyaadimiisee da Wayahuudi gugi ilaki⁄isiri ina tuba, “Maraki gu didiru gu Iliitleemu dugwaati tleehhi koraraa mibeeri cigahha haa lahhoꞌo. Inkoo ugu ha malee kakanta tuba, hagu tleehheda balalu tamige?” ");
INSERT INTO bds_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Teꞌesii, Yeesu giyaa ilii gimbuusi marakee gu didiru, yaati gimbuusi gimba gu slaqwa dosi. ");
INSERT INTO bds_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Teesaaqay, ina qatlay giyaa ilii slafi ayisago, sirakoomiisee dosi yaa hiislayri gimbakira giyaa kaay. Teꞌesii, inay gi ⁄imbiri Handikaa da Iliitleemu haa gimbakira Yeesu giyaa kaay sa inay. ");
INSERT INTO bds_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Qatlay Yeesu giyaa ilii Yerusaleemuge wane losona gu Pasaakage, hida wa⁄a yaa ariniri, gimba gu bakaꞌasa giyaa yondiidi. Teꞌesii hida wa⁄a gi ⁄imbiri hari uma gosi. ");
INSERT INTO bds_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Teesaaqay see, Yeesu ina loi hingaa taatahhiiba daqa dooinay, sa gimba ina giyaa khui inay goõ, idoo giyaa iliiwanee. ");
INSERT INTO bds_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ina yaa slaiyaaba hida, ma ilatlayri gimba gu hida, sa gimba ina yaati khui sumuku gimba goõ gwaa muunaiĩ gu hidage waara. ");
INSERT INTO bds_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Inkoo, yaa wana giyaadimiisay leẽ Yahuudimoo gu raqa da Farisaayoo, uma gosi na Nikodeemo. ");
INSERT INTO bds_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Baloo waka hari amasi, ina yaa hadakay daqa Yeesuge haa sugugi kaay tuba, “Maarimuu, dandiray khuana tuba, ugu ti maarimuu daa ya⁄abi ha Iliitleemu. Hhaku heedi gu hiidahhasa yondu gimba gu bakaꞌasa da hikee gooay ga yondimaamite ugu, bere Iliitleemu wanaaba sliimaa haa ina.” ");
INSERT INTO bds_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu gugi ilaki⁄isi ina tuba, “Gu lou, gu lou, sugu kaay ugu ambee, heedi hiidahhasiyaaba arimaa Tawaaloo da Iliitleemu, bere duguba laqwaloo waa da cada.” ");
INSERT INTO bds_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodeemo gi maasi Yeesu tuba, “Heedi dugu malee hiidahhasi laqwaloo kara tay ina ti gaduwaa? Gu lou, ina hiidahhasiyaaba hiidawa guraꞌa gu iyoo dosii haa dugugi laqwali waa da cada!” ");
INSERT INTO bds_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu gugi ilaki⁄isi ina tuba, “Gu lou, sugu kaay ugu ambee, bere heedi duguba laqwaloo hari maꞌay haa hari Muuna gu Iliitleemu, hiidahhasiyaaba hiidawaraa Tawaaloo da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Heedi dugoóti laqwali slaqwage hari amoo da taataa gosi haa iyoo dosi. Teesaaqay see, heedi dugoóti laqwali muunage hari amoo da Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ugu hhanti bakaꞌada, sa gimba suguũ kaay ambee, ‘Kwanda dugu laqwaliye waa da cada.’ ");
INSERT INTO bds_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Caaqwa yoóti fahhanta bara gi iliislaꞌade khuꞌusa, haa pupukhumoo gosi hagugi akhamisida. Teesaaqay see, hiidahhasidaaba caahha bara giyaa dahhade haã bara gi kakaakayde. Teesaaqay dagani ilii wana kila heedi daa laqwali hari Muuna gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodeemo gi maasi Yeesu tuba, “Gimbaki malee gii dahhasi hiica⁄a?” ");
INSERT INTO bds_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu gi ilaki⁄isi Nikodeemo tuba, “Ugu ti maarimuu gu didiru gu hida gu Israeeli. Teesaaqay see, gimbaki guti hhidintaa? ");
INSERT INTO bds_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gu lou, sugu kaay ugu ambee, dandiray hati giimaamisana gimba ga khuane, haa hati ilatlatlaatlayna gimba gaã arini. Teesaaqay see, unkuray haã ⁄imbidiriiba gimbaki sangu ilatlatlaatlayne. ");
INSERT INTO bds_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ana sanguũ kakaami unkuray gimba gu khooroti, unkuray haã ⁄imbidiriiba. Inkoo, ha malee gii dahhasiday ⁄imbaraa, bere sangu kaawa gimba gu rawaa gu raw? ");
INSERT INTO bds_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wanaaba heedi gwaa hadakaw rawaa gu rawge, ti ina kilesi gwaa hii⁄eetu rawaa gu rawgo, hikee na Nanku Heedi. ");
INSERT INTO bds_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Musaa gooay idoo giyaa ilii waratlaysi deesukira gu ⁄aray yade kongoqomeege, namati teesaaqay Nanku Heedi kwanda dugu waratlaysiye rawaage, ");
INSERT INTO bds_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kila heedi goó ⁄imba ina, ma slay slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Iliitleemu yaa slai hida gu khooroo, ina yaati amoolaa hadisi Nankosi gu leẽ, kila heedi goó ⁄imba ina, ma may hhama, ina hiti slaye slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iliitleemu yaati ya⁄abiiba Nankosi khoorooge, ma hukumi khooroo. Ina gwaati ya⁄abi, hari amoo dosi khooroo dagama ilabuꞌumi. ");
INSERT INTO bds_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inkoo, heedi goó ⁄imba ina dugu hukunaaba. Heedi goóba ⁄imba ina, hikee dugwaa hheꞌesi dugwaa hukumi, sa gimba ina yaa ⁄imbiiba uma gu Nanku leẽ gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hiĩ na hukumuu tuba, cencee yaa khaydi khoorooge, teesaaqay see, hida gi slairi hhantee ba⁄ay da cencee, sa gimba yondu gooina gwaati tlaku. ");
INSERT INTO bds_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila heedi goó yondiida tlakwaroo, ina hiti waki cencee, kara yaa khayaaba cenceege, yondu gosi gu tlaku duguma may hiitlaaꞌasa pandataa. ");
INSERT INTO bds_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hikaꞌa goó yondiida gimba gu lou, ina yoóti khay cenceege, yondu gosi duguma arimi tuba, dugoóti yondiidi hari akhamisu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gimbakee giyaa ilii cati, Yeesu haa sirakoomiisee dosi yaa waaudiri Yerusaleemugo haa gi hadakayri hhapee da Yudaayage. Ina gi ibiidi yade sliimaa haa inay balalu angaamaka, haa gii nunqudimisi. ");
INSERT INTO bds_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Qatlaykee, Yohaana yaatii nunqudiidimisi slime yade daqa daa eteediidine Ayinooni, ciyoomoo haa daqa daa eteediidine Saleemu, sa gimba yade maꞌay yaa wa⁄a. Taysi hida gwaa ilii hadakakayri, ina giyaa hiinunqudimisi. ");
INSERT INTO bds_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Qatlaykee, Yohaana dugwaa kahhi khiidiru jeerage. ");
INSERT INTO bds_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Inkoo, daagii ca⁄i naanaqamoo tla⁄aã gu sirakoomiisee da Yohaana haa Yahuudimoo leẽ sa ou gu Wayahuudi gu ilabuslidu. ");
INSERT INTO bds_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sirakoomiisetee gi iliihadakayri Yohaana, haa sugugi kaayri tuba, “Maarimuu, heedikira guũ sliimaa waara haa ugu hari tlo⁄osaa gu duudu gu Yoridaani, gaa ilatlaydi gimba gosi, yuꞌudiyaa, inkoo ina hiinunqudiidimisi. Kara hida goõ gu ilii hadakakaakayay ina.” ");
INSERT INTO bds_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohaana gigi ilaki⁄isi inay tuba, “Kila idoo ga kone sandaati hadisi daqa Iliitleemugo. Hhaku heedi gu hiidahhasa slawaraa idoo lensee waka. ");
INSERT INTO bds_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Unkuray loi ti masaydii doyi sangwaa kaay ambee, ‘Ana Kristu gooba. Ana dinaati ya⁄abi kilesi ma sugu haraa giyaadi.’ ");
INSERT INTO bds_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ina gu koomaa khabiisoꞌoo na looimoo gu khaboo. Amooleehhisimoo gu looimoo gu khaboo, ina goó qadida haa ina haa gugi akhamisi, ina hhaꞌaluudi akhasaraa afoo da looimoo gu khaboo. Teesaaqay, hhaꞌaloo doyi hiĩ buꞌuti. ");
INSERT INTO bds_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Inkoo, ina kwanda gi ilaqinciye heedi gu didiru tleehhida hari khisla, ana gi ilaqinca heedi gu coko⁄u tleehhida.” ");
INSERT INTO bds_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yeesu gwaa rawaa gu raw dahha, ina guti didiru ba⁄ay da hida goõ. Heedi gwaa khooroo dahha ina guti khooroo, ina hiti cocoi gimba gu khooroo. Kara, ina gwaa khoca rawaa gu rawgo, hiti kona ⁄uuru ba⁄ay da hida goõ. ");
INSERT INTO bds_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ina hiti ilatlatlaatlay gimbakira giyaa arimi haa giyaa akhasi daqa Iliitleemugo. Teesaaqay see, ilatlatlaw gosi hhaku heedi lensee guũ ⁄imbu. ");
INSERT INTO bds_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kila heedi gu ⁄imba ilatlawa da Yeesu, ina hiti laqaaqana pandataa tuba, Iliitleemu guti lou. ");
INSERT INTO bds_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Caahhi tuba, heedi daa ya⁄abi ha Iliitleemu, ina hiti gimbuumisi gimba gu Iliitleemu, sa gimba Iliitleemu hiĩ hadisi sa ina Muuna gosi ilakhua see hhaka. ");
INSERT INTO bds_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taataa slai Nankosi, haa suguũ taatahhi idadu goõ daba gosii. ");
INSERT INTO bds_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Teesaaqay, kila heedi gu ⁄imba Nanku Iliitleemu, ina kona slafimaa gu koraraa haa koraraa goóba hiifaakoo. Heedi goó sia Nanku Iliitleemu konaaba slafimaa gu koraraa haa koraraa goóba hiifaakoo, hikee qupidaa gu Iliitleemu rawaa kosii wanay. ");
INSERT INTO bds_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Inkoo, Farisaayoo yaa akhasiri tuba, Yeesu hiinunqudiidimisi haa slaslaaslay sirakoomiisee wa⁄a ba⁄ay da Yohaana. ");
INSERT INTO bds_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Teesaaqay see, Yeesu ina loi yaa hiinunqudimisiiba, ti sirakoomiisee dosi naa hiinunqudimisiri. ");
INSERT INTO bds_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yeesu giyaa ilii akhasi gimbakee, yaa waaudi hhapee da Yudaayago, gi ki⁄i kara hhapee da Galilaayage. ");
INSERT INTO bds_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Qatlay giyaa ilii Galilaaya kakaakayee, yaati kwanda ina gii catiye hari hhapee da Samariyaa. ");
INSERT INTO bds_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Teesaaqay, ina gi day yaamu wakinayge gu hhapee da Samariyaa doó eteedine na Sikaarii, ilaciyaa haa qaymotira Yakoobo giyaa hadisi sa nankosi Yoseefu. ");
INSERT INTO bds_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Daqateesii daganaa ilii wana wa⁄amu, Yakoobo giyaa ⁄aagwi koraraa wa⁄a gwaa hiicatee. Inkoo, Yeesu yaa ba⁄aa⁄aadi, sa gimba gu hhiyuuma da tleedi, teesaaqay gi ibiidi kenga gu wa⁄amukeesii. Qatlaykee daa daadaausi saa lahhoꞌo da tleemaa. ");
INSERT INTO bds_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Teꞌesii, hadee waka leẽ Samaritoꞌoo yaagi khaydi sa hheku gu maꞌay. Yeesu gi kaay sa hadetee tuba, “Siniqayde maꞌay na kitahhi.” ");
INSERT INTO bds_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Qatlaykee sirakoomiisee dosi yaa kiriga kayri ⁄agoo yaamuge. ");
INSERT INTO bds_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hadetee gi ilaki⁄isidi Yeesu tuba, “Ugu ti Yahuudimoo ana Samaritoꞌoo. Hani malee iliifirinta maꞌay gu kitahhu ana?” Hadetee yaati maasidi teesaaqay, sa gimba Wayahuudi hingaa ilagaamaamisiyaaiiba haa Wasamariyaa idoo lenge see. ");
INSERT INTO bds_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeesu gi ilaki⁄isi, gi kaay sa hadetee tuba, “Bere hanti caahhada, sawaadii sigi hadisiye ha Iliitleemu, haa ti miyaa sigi kakaakama tuba, siniqayde maꞌay na kitahhi, igi hanti aloo firinta ina, ina sigiĩ hadisi maꞌay gu slafimaa.” ");
INSERT INTO bds_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hadetee gi kaadi sa ina tuba, “Looimoo, ugu kontaaba khoosliya darii slagwa maꞌay, kara wa⁄amuki gu ilasegu. Inkoo, maꞌay hhakee gu slafimaa hagiyaani kaalaa slaydi? ");
INSERT INTO bds_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Taataa goori Yakoobo sindaa hadisi dandiray wa⁄amuki. Kara ina, yaꞌay kosi haa kuꞌunaanay gosi yaa kitahhaahhanay maꞌay gu wa⁄amuki. Inkoo, ugu guti didiruu ba⁄ay da Yakoobo?” ");
INSERT INTO bds_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu gi ilaki⁄isi hadetee tuba, “Heedi gu kitahha maꞌay gu wa⁄amuki, hiti arina wakhaa kara. ");
INSERT INTO bds_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Teesaaqay see, heedi gu kitahha maꞌay sugu hadise ana, etaa ina maa arinaaba wakhaa koraraa haa koraraa goóba hiifaakoo. Kara maꞌay sugu hadise ana, hhaahhiyoo tleehhidiyay waꞌay kosii, yaagi bontlogomidiyay slafimaa gu koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hadetee gi kaadi sa Yeesu tuba, “Looimoo, kalaamay sini qayde maꞌay hhakee, ma may arimaa wakhaa kara, haa maa may khawa kara tiꞌii sa hheku gu maꞌay.” ");
INSERT INTO bds_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu gi ilaki⁄isi hadetee tuba, “Taa⁄a eteeda hhawata googi, luguraa khayda tiꞌii.” ");
INSERT INTO bds_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hadetee gi ilaki⁄isidi Yeesu tuba, “Ana koomaaba hhawata.” Yeesu sagagi kaay tuba, “Igi haã kaadi gu lou ubee, kontaaba hhawata. ");
INSERT INTO bds_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Igi haa konta hhawatee kooani, hhawatakee see ga konte inkoo ti hhawata googiiba. Teꞌesii haã kaadi gu lou.” ");
INSERT INTO bds_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Teꞌesii, hadetee gi kaadi sa Yeesu tuba, “Looimoo, ana haã arimi ugu ti tletimiisay gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ayiĩ koti gu Wasamariyaa yaa okii firiirinay Iliitleemu. Teesaaqay see, unkuray Wayahuudi hati kakaakantay tuba, yade Yerusaleemuge na daqa da loi da ilii firoo Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu gi kaay sa hadetee tuba, “De hadee, hani⁄imbide ana. Gu lou, qatlay yaa khoci, hamaa firiirintaaiiba Taataa okii gimati yade Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Unkuray Wasamariyaa hoóti firiirintay idoo ga hhidintee. Dandiray Wayahuudi hoóti firiirina Iliitleemu ga khuane, sa gimba ilabuꞌuru yaati khay hari amoo da Wayahuudi. ");
INSERT INTO bds_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Teesaaqay see, qatlay yaa khoci, kara yaani hheꞌesi yaani khay, qatlay firimiisee da loi, gimaa ilii firiirinee Taataa Iliitleemu hari muuna haa hari amoo da loi. Gu lou, Taataa Iliitleemu hiti slai hida da hhakee gooay magu firiiriniri. ");
INSERT INTO bds_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iliitleemu ti Muuna, hida goõ goó firiirimee ina, kwanda gu firiirinee ina hari muuna haa hari amoo da loi.” ");
INSERT INTO bds_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hadetee gi kaadi sa Yeesu tuba, “Ana khua tuba Masiiya, doó eteedine Kristu, yaa khoci. Ina gimaa ilii khaye, sandimaa hiitlaaꞌasi dandiray gimba goõ.” ");
INSERT INTO bds_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu sagagi kaay hadetee tuba, “Ana gu giimaamisa haa igi, na ina.” ");
INSERT INTO bds_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Qatlaykee, sirakoomiisee dosi yaagi ki⁄iri, kiriga da ⁄agoogo. Qatlay giyaa ilii dayri, inay gi bakairi hari khisla arimaa Yeesu wana ina lenkosi, cocoi haa hadee. Teesaaqay see, hhaku lensee gwaa maasu hadetee tuba, “Igi ti miyaa ha mala slaꞌada tiꞌii?” Slime yaa maasiriiba Yeesu tuba, “Soꞌoyi giimaamisida haa hadetee?” ");
INSERT INTO bds_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Da hheꞌesi, hadetee gi maydi sibida dosi da maꞌay teꞌesii, gi hadakaydi yaamuge haa gi kaadi sa hida tuba, ");
INSERT INTO bds_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Khocaa arima heedi siniĩ gimbuusu ana gimba goy goõ gaa yondiidi! Gu lou, hiĩ Kristu goo?” ");
INSERT INTO bds_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Teesaaqay, hida wa⁄a yaagii ca⁄iri yaamugo, gi ilii hadakayri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Qatlaykee sirakoomiisee dosi gwaa tlaatlaqaaqamisiyay ina tuba, “Maarimuu, ⁄agimi ⁄agoo.” ");
INSERT INTO bds_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yeesu gigi ilaki⁄isi inay tuba, “Ana kooma ⁄agoo da ⁄agiru unkuray ga hhindintee.” ");
INSERT INTO bds_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Teesaaqay, sirakoomiisee dosi hingigi maamisiri inay haa inay tuba, “Gu louu wana heedi sugwaani leehhisu ⁄agoo?” ");
INSERT INTO bds_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu gi kaay sa inay tuba, “⁄agoo doyi ana ti yondu idoo da slaiye ha Iliitleemu gunaa ya⁄abu haa hiigaasa yondu gosi. ");
INSERT INTO bds_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Unkuray caba hati kakaakantay tuba, ‘Kahhiyay slehheeri cigahha kilesi, qatlay gu buꞌuru yaani day?’ Inkoo, ana sangu kaawa ambee, waratlaysa ilaa kokuna haa yuꞌuda qaymamu, idoo giĩ ilii hamaadiri haa hiĩ buꞌudiri sa buꞌuru! ");
INSERT INTO bds_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ina gu buꞌuuꞌuma slaslaaslay bueemaa kosi, haa hiikurunkuriirina ⁄aamu sa slafimaa gu koraraa goóba hiifaakoo. Teesaaqay, ina gu daamaamisa haa ina gu buꞌuuꞌuma, hiti hhaꞌaluumidiyay sliimaa. ");
INSERT INTO bds_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sa gimbakee, kaawati dati loi tuba, ‘Leẽ hiti daamaamisi haa waku hiti buꞌuuꞌuna.’ ");
INSERT INTO bds_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ana hangwaa ya⁄abi unkuray, maa buꞌuntiri baruũ hangwaaba daamisu, ti hida wakinay naa yondiidiri yondu gwaa karahhu. Teesaaqay, unkuray hanti slaydiri faydaa hari cufa dooina.” ");
INSERT INTO bds_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamariyaa wa⁄a gu yaamu hhakee gu Sikaarii gi ⁄imbiri Yeesu, sa ilatlawa da hadetee. Ina sigaa kaadi inay tuba, “Ina siniĩ gimbuusi ana gimba goy goõ gaa yondiidi!” ");
INSERT INTO bds_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Teesaaqay, Wasamariyaa giyaa ilii dayri daqa Yeesuge, gugi tlaatlaqasiri ina ma ibiidi haa inay. Ina gi ibiidi teꞌesii haa inay balalu cada. ");
INSERT INTO bds_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kara, hida wa⁄a hari khisla gi ⁄imbiri Yeesu, sa gimba giyaa gimbuusi. ");
INSERT INTO bds_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hida hhakee gi kaayri sa hadetee tuba, “Inkoo, dandiray hanti ⁄imbaniiba sa gimbaa googi kilesi. Dandiray hanti ⁄imbani sa gimba haguũ akhasani dandiray loi, haa haã caahhani gu lou tuba, hiĩ na Ilabuꞌumiisay gu khooroo.” ");
INSERT INTO bds_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Qatlay daa ilii cati balalu hhakee cada, Yeesu yaa waaudi teꞌesaa, gi hadakay Galilaayage. ");
INSERT INTO bds_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wakaꞌalee, Yeesu ina loi yaa kaay pandataa tuba, “Tletimiisay dugoó muriidiyaaba ha hida gu hhapee dosi.” ");
INSERT INTO bds_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Teesaaqay, qatlay Yeesu giyaa ilii day Galilaayage, Wagalilaaya gwaa kwahhasuusiri. Inay yaa aniri gimba goõ Yeesu giyaa yondiidi yade Yerusaleemuge qatlay gu losona gu Pasaaka. Inay see slime yaa wanay losonakeesii. ");
INSERT INTO bds_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeesu gi kara ki⁄i yaamu gu Kanaage gu hhapee da Galilaaya, daqa giyaa ilii fooki maꞌay gi difaay tleehhidiri. Yade yaa wana heedi waku karaanimoo gu mutemi. Ina nankosi yaa mama⁄i yade yaamu gu Kaperinauumuge. ");
INSERT INTO bds_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Heediki gi akhasi tuba, Yeesu yaani khay Galilaayage yadaa Yudaayago. Ina gugi ilii hadakay haa gugi tlaatlaqasi, ma hhoeesa kay nankosi gwaa daadaauusu gwaaꞌa. ");
INSERT INTO bds_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Da hheꞌesi, Yeesu gi kaay sa heedikee tuba, “Bere hanguba arimaa gimba gu bakaꞌasa haa gimba gu kaaru, etaa unkuray hani ⁄imbidaaiiba.” ");
INSERT INTO bds_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Karaanimokee gu mutemi gi kaay tuba, “Looimoo, hanguũ firimi poo aya gooii nankoy gi ilii kahhiye gwaaꞌa.” ");
INSERT INTO bds_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeesu sugugi kaay tuba, “Taa⁄a, nankoogu slafi.” Karaanimokee gi ⁄imbi gimba suguũ kaay ha Yeesu, ina gi tosaa waaudi. ");
INSERT INTO bds_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Qatlay ina giyaa ilii kikaaki⁄iye kahhi amooge, hingigi slaslayri haa tongee dosi, inay sugugi kaayri tuba, nankosi hiĩ hhoay. ");
INSERT INTO bds_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Teꞌesii, ina gigi maasi inay qatlay haloo nankosi giĩ ilii hhoay. Inay sugugi kaayri tuba, “Ina hiĩ may ga⁄ay sa⁄alee saa fanqu da tleemaa.” ");
INSERT INTO bds_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Teꞌesii, taataa gu khwaylimokee giislay tuba, hikee na qatlaykira suguũ ilii kaay ha Yeesu tuba, “Taa⁄a, nankoogu slafi.” Teesaaqay, ina haa hida goõ gu mara gosi gi ⁄imbiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hiĩ yaa gimba gu bakaꞌasa gu cada Yeesu giyaa yondiidi, giyaa ilii ki⁄i Galilaayage yadaa Yudaayago. ");
INSERT INTO bds_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gimbakee giyaa ilii cati, Yeesu gi hadakay Yerusaleemuge, qatlay gu losona gu Wayahuudi. ");
INSERT INTO bds_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Inkoo, yade Yerusaleemuge, ilaciyaa haa kaꞌafu doó eteedine Kaꞌafu gu Bee⁄u, yaa wanta tlawa daa niini⁄idi ha balasasuu kooani. Tlawatee dagoóti eteedina hari Eburaanaisoo Betisaydaa. ");
INSERT INTO bds_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Balasasuu hhakeesii ga⁄iidee wa⁄a yaa qaaqaatiri teꞌesii, tla⁄aã gooinay yaa wanay gwaa ilahhamaahhamee, sletuusee haa gwaa tingara⁄uumidee. ");
INSERT INTO bds_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Teꞌesii yaa wana heedi waku gwaa mama⁄a koraraa mibeeri tami haa gweleti. ");
INSERT INTO bds_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeesu gwaa ilii arimi heedikee hiĩ qaati teꞌesii, tay ina khui tuba, heedikee yaa wana teꞌesii balalu wa⁄a, gugi maasi ina tuba, “Slaꞌadaa ma hhoaydi?” ");
INSERT INTO bds_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ga⁄iidaykira gi ilaki⁄isi Yeesu tuba, “Looimoo, ana koomaaba heedi gunii ⁄eetisa waꞌay gu tlawage, qatlay maꞌay digoó ilii tlorontloreesiye. Qatlay ana goó ilii koise hii⁄eeta, goo khawe heedi waku hingii ⁄eeti pandaa dooii.” ");
INSERT INTO bds_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeesu gi kaay sa ina tuba, “Tlayii, oyii fala doogu, la waauta.” ");
INSERT INTO bds_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Cirakiray heedikee gi hhoay, gii oyi fala dosi haa gi waaudi. Inkoo, gimbakee yaay ca⁄i baloo da Sabaatoge. ");
INSERT INTO bds_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Teesaaqay, giyaadimiisee da Wayahuudi gi kaayri sa heedikira diĩ hhoeesi tuba, “Letuti ti baloo da Sabaato, sariyaa doorii ti kitlaku ugu geregeda fala doogu.” ");
INSERT INTO bds_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ina gigi ilaki⁄isi inay tuba, “Heedikira guũ hhoeesu ana, ina siniĩ kaay tuba ‘Oyii fala doogu haa la waauta.’ ” ");
INSERT INTO bds_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Inay gugi maasiri tuba, “Heedi miyaa suguũ kaawu ugu tuba, ‘Oyii fala doogu la waauta?’ ” ");
INSERT INTO bds_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Heedikee diĩ hhoeesi, yaa caahhiiba ti miyaa nuguũ hhoeesi, sa gimba Yeesu yaa hheꞌesi yaa waaudi raqateesaa da hidago daa waara teꞌesii. ");
INSERT INTO bds_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Qariqaaqari, Yeesu gugi slay heedikira giĩ hhoeesi waꞌay gu mara gu didiruge gu Iliitleemu, sugugi kaay ina tuba, “Yuꞌudiyaa ugu duguũ hhoeesi. Inkoo, hhanti yondita kara tlakwaroo, ba⁄atii slayda gimba gu tlaku hari khisla.” ");
INSERT INTO bds_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Heedikee gi waaudi, gi kaawa kay sa giyaadimiisee da Wayahuudi tuba, ti Yeesu niĩ hhoeesi ana. ");
INSERT INTO bds_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Inkoo, sa gimba Yeesu yaa yondiidi gimbaki baloo da Sabaatoge, giyaadimiisee da Wayahuudi gugi labaꞌasiri ina pandataa. ");
INSERT INTO bds_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeesu gigi ilaki⁄isi inay tuba, “Taataa goy yoóti yondiidi balalu sliimaa inkoo see. Ana see slime ha yondimaamida.” ");
INSERT INTO bds_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Teesaaqay, giyaadimiisee da Wayahuudi yaa ilakoniri dabimidu amoo dari gaasa Yeesu. Inay yaa laqiri teesaaqay, sa gimba giyaa yondiidi kilesiiba baloo da Sabaatoge. Slime ina yaa kaay tuba, Iliitleemu ti Taataa gosi, haa hingigi ilakhuukhuꞌusi ina ti leẽ haa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeesu gi ilaki⁄isi giyaadimiisee da Wayahuudi tuba, “Gu lou, sangu kaay, Naw hiidahhasiyaaba yondu gimba lensee ina lenkosi. Ina hiti yondiidi gimbakaꞌa kilesi gi ariirine Taataa gosi gi yondiidiye. Gimba da yondiidiye ha Taataa, Naw see slime guni yondiidi namati teesaaqay. ");
INSERT INTO bds_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Caahhi tuba, Taataa hiti slai Naw, haa sugu laqaaqana gimba goõ hikaꞌa ina Taataa giyoó yondiidiye. Kara ina sugu laqana gimba gu denu ba⁄ay da hiĩ see, unkuray ma bakaꞌadiri. ");
INSERT INTO bds_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Taqay Taataa gooay giyoó iliislafimisiye hida gwaa kaka⁄ee haa sigigi qay slafimaa, namati teesaaqay, ana see Nankosi hadimisa slafimaa sa hhakaꞌa ga slae. ");
INSERT INTO bds_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kara, Taataa hukunaaba heedi lensee, ina hiĩ taatahhi sa Naw ⁄uuru goõ gu hukumuu, ");
INSERT INTO bds_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","hida goõ ma muriidiri Naw, idoo giyoó ilii muriidiyee gooay Taataa. Heedi guba muriida Naw, slime muriidiyaaba Taataa gwaa ya⁄abu Naw. ");
INSERT INTO bds_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Gu lou, sangu kaay unkuray ambee, heedi gu akhamisa gimba goy, haa gugi ⁄imbi ina gunaa ya⁄abu ana, hikee kona slafimaa gu koraraa haa koraraa goóba hiifaakoo, kara ina dugu hukunaaba. Ina hingiicati gwaaꞌaraago haa hingii day slafimaage. ");
INSERT INTO bds_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Gu lou, sangu kaay unkuray ambee, qatlay yaa khoci, kara yaani hheꞌesi yaani day, hida gwaa kaka⁄ee akhasiyayi afoo da Nanku Iliitleemu. Kara, inay gumaa akhasee, maa slayay slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Caahhi tuba, Taataa gooay gi ilii kone slafimaa waꞌay kosii, namati teesaaqay hiĩ hadisi slime sa Naw, ma koomi slafimaa hhakee waꞌay kosii. ");
INSERT INTO bds_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kara, ina hiĩ hadisi sa Naw ⁄uuru gu hukuruu, sa gimba ina ti Nanku Heedi. ");
INSERT INTO bds_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Unkuray hhanti bakaꞌadayi sa gimbaki. Qatlay yaa khoci hida goõ gu waꞌay gu ayisasuge waaree, maa akhasiyayi afoo dosi. ");
INSERT INTO bds_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Inay maa hiica⁄iyay ayisasugo, hhakira gwaa yondiidee gimba gu hhou, maa slafiyay ma slayri slafimaa goóba hiifaakoo. Kara hhakira gwaa yondiidee gimba gu tlaku, maa slafiyay haa digimaa hukuna. ");
INSERT INTO bds_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ana hiidahhasaaba yondu gimba lensee ana lenkoyi. Ana ti hukuma idoo ga iliiakhase gooay daqa Taataago. Kara hukumuu goy guti haaki, sa gimba ana yondiidaaba, idoo ga iliislae gooay ana. Ana ti yondiida idoo gi iliislaiye gooay ina gunaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bere ana hangi ilatlawu ana lenkoyi, ilatlawa doyi daga ila⁄imbiyaaba. ");
INSERT INTO bds_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wana waku gunoó ilatlatlawa, kara ana khua ambee, ilatlatlawu gosi guti lou. ");
INSERT INTO bds_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Unkuray haa ya⁄abidiri hida daqa Yohaana Hiinunqudimiisage, Yohaana gi ilatlay sa unkuray gimba gu lou. ");
INSERT INTO bds_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ana ha ⁄imbaaba ilatlatlawu gu hida, coko⁄o seei. Ana sanguti giimaamisa gimbaki, unkuray danguma ilabuꞌumi. ");
INSERT INTO bds_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohaana yaati taa pahha daa ooyiiyima, haa gii cencuudisida cencee. Unkuray haay leehhediri hhaꞌaluumidu cenceteesii da ya⁄aboo dosii hari qatlay coko⁄o. ");
INSERT INTO bds_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Inkoo, ilatlatlaw ga koome ana kona ⁄uuru ba⁄ay da hikira gu Yohaana see. Caahhi tuba, yondu sinaa hadisi ana ha Taataa, magu hiigaasi, ilatlatlaatlay tuba, Taataa naa ya⁄abi ana. ");
INSERT INTO bds_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taataa gunaa ya⁄abu ana, ina loi hiĩ ilatlay ana. Unkuray kahhaday akhasa afoo dosi, gimati arimaa see kalay gosi. ");
INSERT INTO bds_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kara, gimba gosi wanaaba muunaiĩ kokunay, sa gimba unkuray hani ⁄imbidaaiiba ana daa ya⁄abi ha ina. ");
INSERT INTO bds_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Unkuray kwaꞌaaꞌatay Handikaa da Iliitleemu, sa gimba hati ilahudeedemisiday tuba, waꞌay kosii ha slayday slafimaa gu koraraa haa koraraa goóba hiifaakoo. Keslenkoo Handikati hiti ilatlatlaatlayda ana. ");
INSERT INTO bds_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Teesaaqay see, unkuray slaꞌadaaiiba khawa daqa dooii, ma slaydiri slafimaa hhakee. ");
INSERT INTO bds_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ana oowaaba dumbeesa daqa hidago. ");
INSERT INTO bds_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kara, ana khua unkuray kontaaiiba slaꞌamuu gu Iliitleemu muunaiĩ kokunay. ");
INSERT INTO bds_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ana hanti khay hari uma gu Taataa goy, unkuray hani slaꞌadaaiiba ⁄imba ana. Bere heedi waku yaa khay hari uma gosi ina loi, unkuray haguti cira ⁄imbiday. ");
INSERT INTO bds_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Unkuray hati ooyintay daareesa unkuray haa unkuray, kara daareesa daa daqa Iliitleemu dahha, hagoó dabitaaiiba. Teesaaqay malee hiidahhasiday ⁄imbaraa ana? ");
INSERT INTO bds_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Unkuray hhanti ilahudeesiday tuba, ana hangu sitaakima pandaa da Taataage. Musaa, ina ga iliipaꞌaaꞌantee, ina nangumaa sitaakina unkuray. ");
INSERT INTO bds_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bere unkuray haa aloo ⁄imbiday gimba gu Musaa, ana see haniĩ aloo ⁄imbiday, sa gimba ina naa handikimi gimba goy. ");
INSERT INTO bds_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Inkoo, bere unkuray haã ⁄imbidiriiba gimba daa handikimi ha Musaa, malee hiidahhasiday ⁄imbaraa gimba goy?” ");
INSERT INTO bds_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Qariqaaqari gimbakee giyaa ilii cati, Yeesu yaa waaudi, gi tlo⁄osi hari bara waka da tlawa da didiri da Galilaaya, doó eteedine tlawa da Tiberiyaa. ");
INSERT INTO bds_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Raqa da didiri da hida gi sirakonti Yeesu, sa gimba inay yaa aniri gimba gu bakaꞌasa wa⁄a, giyaa yondiidi hari hhoeemisu ga⁄iidee. ");
INSERT INTO bds_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Da hheꞌesi, Yeesu gi ilakhiinaaꞌadi onke, gi ibiidi taysi sliimaa haa sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Qatlaykee losona gu Pasaaka gu Wayahuudi yaa daadaauusi. ");
INSERT INTO bds_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yade onke, Yeesu giyaa ilii waratlaysi ilaa kosi, gi arimi raqa da didiri da hida yaa khocida daqa dosii. Ina gi maasi Filiipo tuba, “Kaale kiriga kayna mukaatee, ma ⁄agimisani hida hhanki?” ");
INSERT INTO bds_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeesu yaati maasi Filiipo teesaaqay magu ilatahhi ina, sa gimba Yeesu ina loi yaa caahhi idoo gi laqiye. ");
INSERT INTO bds_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filiipo gugi ilaki⁄isi ina tuba, “Gamati kirigani mukaatee da dinaari miyaa cada see, buꞌudisiyaaba hida hhanki, gamati hadisani sa kila heedi fandakumiya da coko⁄i kilesi.” ");
INSERT INTO bds_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Leẽ gu sirakoomiisee dosi, doó eteedine Andareyaa, hhia gosi Simooni Peetiro, sugugi kaay ina tuba, ");
INSERT INTO bds_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tiꞌii wana khwaylimoo leẽ gu kooma mukaatee kooani gu wee⁄oo haa samaakii cada gu digidaku. Gu lou, ⁄agotee ti idoo mala daqa raqa da didirige taqaaqay!” ");
INSERT INTO bds_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeesu gi kaay sa sirakoomiisee dosi tuba, “Ibiidisa hida hhapeege.” Inkoo, daqatee yaa konta sluufaa wa⁄a. Teesaaqay, hida gi ibiidiri hhapeege, hhawatee goõ yaa elefu kooani. ");
INSERT INTO bds_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Da hheꞌesi, Yeesu gii oyi mukaatetira, gi kaay ⁄iisoo sa Iliitleemu, haa gi deehhimi sa hida goõ gwaa ibiidee. Kara, gi laqi namati tiraaqay hari samaakikira. Hida goõ gi slayri idoo giyaa iliislaiye. ");
INSERT INTO bds_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Inkoo, qatlay hida giyaa ilii akhaakhaniri, Yeesu gi kaay sa sirakoomiisee dosi tuba, “Kurunkuraw ⁄agoo diĩ meti, lensee ba⁄atii hhanta.” ");
INSERT INTO bds_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Teesaaqay, inay yaagii kurunkuriri haa gi hacimisiri kapapuu mibi haa cada gu meetu gu mukaatetira kooani da wee⁄oo, daa meesi ha hida hhakira gwaa ⁄agimee. ");
INSERT INTO bds_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hida giyaa ilii aniri gimba gu bakaꞌasa Yeesu giyaa yondiidi, gi tlaatleesiri cocoꞌomoo tuba, “Gu lou, hiĩ na Tletimiisaykira daa tletimi tuba, yaa khay khoorooge!” ");
INSERT INTO bds_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Qatlay Yeesu giyaa ilii caahhi tuba, hida yaa slaiyay oowakawa ina hari ⁄uuru, ma mutemi gooina tleehhidi, ina hingigi pasli haa inay gi waaudi onke ina lenkosi. ");
INSERT INTO bds_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Qatlay daa ilii day khwayaiĩ, sirakoomiisee dosi gii gweegwe⁄ediri tlawa da didirige da Galilaayage. ");
INSERT INTO bds_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Inay gii guniri masuwaage, gi tlaatleesiri tlo⁄osa tlawa yaamu gu Kaperinauumu khuꞌusa. Qatlaykee daa hheꞌesi daa hiihhantuudi, kara Yeesu yaa kahhi dawaraa daqa dooinay. ");
INSERT INTO bds_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tlawa gi tlaatleesidi ⁄uru⁄utlimidu, sa gimba pupuiya da dihhi yaa fahhaahhanta. ");
INSERT INTO bds_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sirakoomiisee dosi gi khociri hari masuwaa maꞌayge kilomiita kooani baku lahhoꞌo. Inay gi aniri Yeesu, yaa khoci hari rawaa gu maꞌay, yaani daadaauusi masuwaa dooinay. Teꞌesii, inay gi tlaꞌamuumuudiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yeesu sigigi kaay tuba, “Ti ana, hhanti tlaꞌamutay!” ");
INSERT INTO bds_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Teesaaqay, inay gwaa slaiyay hiidaasa Yeesu waꞌay gu masuwaage. Cirakiray masuwaa gi daadi kenga gu tlawage hhapee da kaarunge, daqa giyaa kakaakayee. ");
INSERT INTO bds_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Heetlaalee dosii hida gwaa meetee hari kenga gu caduu gu tlawa, yaa baraslayiri tuba, sa⁄alee masuwaa leẽ kilesi niĩ wanta. Kara, inay yaa caahhiri Yeesu yaa hiidayiiba waꞌay gu masuwaage sliimaa haa sirakoomiisee dosi. Sirakoomiisee dosi yaati waaudiri inay kilakoina. ");
INSERT INTO bds_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Masuwawuu wakinay gwaa Tiberiyaa dahhee yaagi khayri ilaciyaa haa daqatira, raqa da hida giyaa ilii ⁄aginiri mukaatee, qariqaaqari Yeesu giyaa ilii kaay ⁄iisoo sa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Teꞌesii hida hhakee gi baraslayiri tuba, Yeesu haa sirakoomiisee dosi yaa wanaaiiba teꞌesii. Teesaaqay, inay gii guniri masuwawuu hhakeesii, gi waaudiri Kaperinauumuge, ma dabiidu kayri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hida hhakee gwaa ilii slayri Yeesu hari tlo⁄osaa gu tlawa da didiri, inay gugi maasiri tuba, “Maarimuu, ugu haani malaalee khaydi tiꞌii?” ");
INSERT INTO bds_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou, sangu kaay ambee, unkuray haniti damaamitaaiiba ana, sa gimba gaã antiri gimba gu bakaꞌasa gaã yondiidi, ti sa gimba gaã ⁄agintiri mukaatetira hagi akhakhantiri. ");
INSERT INTO bds_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Unkuray hhanti yonditay sa ⁄agoo doó tlakwaakwawa, ba⁄ay hiti yondiida sa ⁄agoo doó hiikaasa slafimaa gu koraraa haa koraraa goóba hiifaakoo. Nanku Heedi sangu hadisi unkuray ⁄agoti. Caahha tuba, ina dugunaa ilii qaasi chapaa ha Iliitleemu Taataa.” ");
INSERT INTO bds_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teesaaqay, inay gugi maasiri ina tuba, “Inkoo, hati malee laqana, ma yondiidani yondu da slaiye ha Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu gigi ilaki⁄isi inay tuba, “Yondu gu Iliitleemu na nahiĩ, ⁄imba hikaꞌa giyaa ya⁄abi.” ");
INSERT INTO bds_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Teꞌesii, inay gugi maasiri gi kaayri tuba, “Ti gimba mala gu bakaꞌasa ga yondite, dandiray magu arini, magu ⁄imbani ugu? Ti gimba mala ga yondite? ");
INSERT INTO bds_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ayiĩ koti yaa ⁄aginiri ⁄agoo doó eteedine maana yade kongoqomeege, idoo daa ilii handikimi gooay Handikaa da Iliitleemuge tuba, ‘Ina sigaa hadisi mukaatee rawaa gu rawgo ma ⁄aginiri.’ ” ");
INSERT INTO bds_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou, sangu kaay unkuray ambee, Musaa gooba sangwaa hadisi unkuray mukaatee rawaa gu rawgo. Ti Taataa goy sangoó hadimisi mukaatimoo gu lou rawgo. ");
INSERT INTO bds_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mukaatimoo gu Iliitleemu na hikaꞌa goó hii⁄eeta rawaa gu rawgo, haa gi hadisi slafimaa sa hida gu khooroti.” ");
INSERT INTO bds_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Teesaaqay, inay sugugi kaayri tuba, “Looimoo, balalu sliimaa sandi hadimiside mukaatimokee.” ");
INSERT INTO bds_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeesu sigigi kaay inay tuba, “Ana na mukaatimoo goó hadisa slafimaa sa hida. Ina gwaa khawa daqa dooii etaa arinaaba qori. Kara ina gu ⁄imba ana etaa arinaaba wakhaa. ");
INSERT INTO bds_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Inkoo, ana sangwaa kaay unkuray ambee, unkuray haniimati arintiri see ana, kahhaday haniĩ ⁄imbidiriiba. ");
INSERT INTO bds_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Hida goõ sini hadisiye ha Taataa yaa khayay daqa dooii. Kara kila heedi gwaa khawa daqa dooii, etaa ana hagu kwahhaaba. ");
INSERT INTO bds_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Caahha tuba, ana haatii ⁄eetiiba rawaa gu rawgo, ma yondiidi gimba ga slae ana, ti sa yondu idoo da iliislaiye ha ina gunaa ya⁄abu. ");
INSERT INTO bds_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inkoo, hiĩ na gimba gi slaiye ina gunaa ya⁄abu na nahiĩ tuba, hhanti hhamisa lensee gu hhakira sinaa taatahhi ha ina. Kara, inay hagimaa slafisa balotirayi da hiifaakooge. ");
INSERT INTO bds_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gimba da slaiye ha Taataa goy na nahiĩ tuba, kila heedi gu khuꞌuma Naw haa gugi ⁄imbi, slay slafimaa gu koraraa haa koraraa goóba hiifaakoo. Kara ana hagumaa slafisa ina baloo da hiifaakooge.” ");
INSERT INTO bds_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Teesaaqay, Wayahuudi gi tlaatleesiri iliiquru⁄umoo Yeesu, sa gimba yaa kaay tuba, “Ana na mukaatimoo gwaa hii⁄eetu rawaa gu rawgo.” ");
INSERT INTO bds_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Inay gi kaayri tuba, “Heediki Yeesu goóbaslii nanku Yoseefu, hiĩ taataa gosi haa iyoo dosi hagi khuana? Inkoo ina malee hiidahhasi kaawa tuba, ‘Haanii ⁄eeti rawaa gu rawgo?’ ” ");
INSERT INTO bds_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Teesaaqay, Yeesu sigigi kaay inay tuba, “Hangu hhanti ilii quru⁄uday unkuray haa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hhaku heedi lensee gwaa hiidahhasa khawa daqa dooii, bere duguraaba giyaada ha Taataa goy gunaa ya⁄abu. Kara heedikee ana hagumaa slafisa baloo da hiifaakooge. ");
INSERT INTO bds_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tletimiisee da Iliitleemu yaa handikiniri tuba, ‘Hhaã goõ digi caacaahhamisi ha Iliitleemu.’ Kila heedi gu akhamisa Taataa goy haa hingigi caacaahhamisi daqa dosaa, hikee yaa khay daqa dooii. ");
INSERT INTO bds_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hhaku heedi lensee guũ arimu Taataa. Ti ina kilesi gwaa daqa Iliitleemu dahha, ina kilesi niĩ arimi Taataa. ");
INSERT INTO bds_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gu lou, sangu kaay, heedi guni ⁄imba ana, hikee kona slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ana na mukaatimoo goó hadisa slafimaa sa hida. ");
INSERT INTO bds_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ayiĩ kokuna yaa ⁄aginiri ⁄agoo doó eteedine maana yade kongoqomeege, teesaaqay see, inay gi kaka⁄iri. ");
INSERT INTO bds_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Inkoo, tiꞌii wana mukaatimoo gwaa daqa Iliitleemu dahha. Kila heedi gu ⁄agima mukaatimoki, etaa ina gwaaiyaaba. ");
INSERT INTO bds_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ana na mukaatimoo gu slafimaa, gwaa hii⁄eetu rawaa gu rawgo. Kila heedi gu ⁄agima mukaatimoki, ina ibiidi koraraa haa koraraa goóba hiifaakoo. Kara gu lou, mukaatimoki ga hadise sa slafimaa gu hida gu khooroo ti slaqwa doyi loi ana.” ");
INSERT INTO bds_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Teꞌesii, Wayahuudi hingigi tlaatleesiri kabaaba⁄u inay haa inay kakaanay tuba, “Heediki malee hiidahhasi hadisa slaqwa dosi sa dandiray maga ⁄agini?” ");
INSERT INTO bds_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Teesaaqay, Yeesu sigigi kaay inay tuba, “Gu lou, sangu kaay, bere hanguba ⁄agoo slaqwa da Nanku Heedi haa gi kitahhantay ceedee dosi, hakontaaiiba slafimaa waꞌay kokunay. ");
INSERT INTO bds_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kila heedi gu ⁄agima slaqwa doyi haa gi kitahhana ceedee doyi, hikee kona slafimaa gu koraraa haa koraraa goóba hiifaakoo. Kara hikee ana hagumaa slafisa baloo da hiifaakooge. ");
INSERT INTO bds_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Caahha tuba, slaqwa doyi ti ⁄agoo da loi, haa ceedee doyi ti kitahhu gu lou. ");
INSERT INTO bds_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kila heedi gu ⁄agima slaqwa doyi haa gi kitahhana ceedee doyi, hikee ibiidi ilagaasage haa ana, ana see ha ibiida ilagaasage haa ina. ");
INSERT INTO bds_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taataa goy ina gu tlaatleesoo da slafimaa, naa ya⁄abi ana, kara ana hoóti ibiida sa gimba gosi. Namati teesaaqay, heedi guni ⁄imba ana, ina hiti ibiidi sa gimba goy. ");
INSERT INTO bds_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hiĩ ti mukaatimoo gwaa hii⁄eeta hhapeege rawaa gu rawgo, ti hikira pahhaaba ayiĩ kokuna giyaa ⁄aginiri kongoqomeege gi kaka⁄iri. Ina gu ⁄agima mukaatimoki hiti ibiidi koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeesu yaa gimbuusi gimbaki, giyaa ilii caacaahhaahhamisiye sinagoogige yaamu gu Kaperinauumuge. ");
INSERT INTO bds_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Qatlay sirakoomiisee dosi wa⁄a giyaa ilii akhasiri gimbakee, gi kaayri tuba, “Caacaahhamisuki yaa karahhi! Ti miyaa gu hiidahhasa oowaraa?” ");
INSERT INTO bds_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesu gi caahhi tuba, sirakoomiisee dosi quraaru⁄iyay sa caacaahhamisu gosi, gigi maasi inay tuba, “Inkoo, dangunti muuna tlakweesii ha caacaahhamisuki? ");
INSERT INTO bds_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Inkoo ilahudeesa, hiti malaaꞌay bere hagu arintayi Nanku Heedi hiiday yade rawaa gu rawge, giyaa iliiwane tlaatleesogo? ");
INSERT INTO bds_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Muuna gu Iliitleemu na hadisi sa hida slafimaa goóba hiifaakoo. Heedi hiidahhasiyaaba yondu idoo lensee hari ⁄uuru gosi. Gimbaki sanguũ gimbuusi unkuray, yaa daqa Muuna gu Iliitleemu dahhi, kara guti slafimaa. ");
INSERT INTO bds_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Teesaaqay see, wanay wakinay tla⁄aã googunay goóba ⁄imbaraa ana.” Yeesu yaa kaay teesaaqay, sa gimba ina yaa caahhi yadaa tlaatleesoogo hhakira goóba ⁄imba haa hikira gumaa hiifookida ina. ");
INSERT INTO bds_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yeesu gi ilakoomi gimba tuba, “Haã na idoo sangwaa ilii kaay ambee, hhaku heedi gwaa hiidahhasa khawa daqa dooii, ti hikaꞌa kilesi daroó giyaadiye ha Taataa goy, maa khay daqa dooii.” ");
INSERT INTO bds_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Qatlaykeesaa sirakoomiisee dosi wa⁄a, gi waaudiri, gugi mayri sirakomamidu. ");
INSERT INTO bds_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Da hheꞌesi, Yeesu gi maasi sirakoomiisetira tosi mibi haa cada tuba, “Unkuray see haniti slaꞌadaaii mawaraa ana?” ");
INSERT INTO bds_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simooni Peetiro gugi ilaki⁄isi ina tuba, “Looimoo gu Goõ, ha daqa miyaa kayna? Ugu kilesi na konta gimba gu slafimaa gu koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dandiray haã ⁄imbani haa haã caahhani tuba, ugu na Kristu, Daa tlintiꞌisi gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeesu gigi ilaki⁄isi inay tuba, “Ti ana nangwaa hiileehhi unkuray mibi haa cada. Teesaaqay see, leẽ tla⁄aã googunay ti Biriisimoo!” ");
INSERT INTO bds_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tiꞌii, Yeesu yaati giimaamisi gimba gu Yuuda, nanku Simooni Isikariyooti. Yuuda giyaamati leẽ gu sirakoomiisetira mibi haa cada, qariqaaqari hiĩ na hiifookidi Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Qariqaaqari gimbakee giyaa ilii cati, Yeesu yaa ilakhookhocimi hhapee da Galilaaya. Ina yaa slaiyaaba hadakawa hhapee da Yudaayage, sa gimba giyaadimiisee da Wayahuudi gwaa slaiyay gaasaraa. ");
INSERT INTO bds_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Inkoo, losona gu Wayahuudi daa eteediidine losona gu cuuraiĩ giyaa ilii daadaauusi, ");
INSERT INTO bds_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","hhiee kosi Yeesu sugugi kaayri ina tuba, “Waaudi tiaa, taa⁄a yade hhapee da Yudaayage, sirakoomiisee doogu ma ariniri gimba gu bakaꞌasa ga yondimaamite. ");
INSERT INTO bds_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Heedi gu slaꞌa duguma caahhi ha hida, yondiidiyaaba gimba gosi hari hhaaboo. Inkoo, bere ugu ha yondimaamita gimbaki, hangii ca⁄aside pandaa da hidage.” ");
INSERT INTO bds_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hhiee kosi yaati gimbuusiri teesaaqay, sa gimba inay see yaa ⁄imbiriiba Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeesu gi ilaki⁄isi inay tuba, “Qatlay goy guraa hiiboo⁄u kahhi buꞌuda. Daqa doogunay qatlay sliimaa hiraatiiboo⁄i. ");
INSERT INTO bds_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Hida gu khooroo hiidahhasiyaaiiba wakaraa unkuray. Ana hini wakiyay, sa gimba ana sigi ilatlatlaatlaw inay ambee, ibinaa dooina da tlakwi. ");
INSERT INTO bds_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Unkuray taa⁄amida hadakaw Yerusaleemuge sa losonakee. Ana hadakawaaba, sa gimba qatlay goy guraa hiiboo⁄u kahhi buꞌuda.” ");
INSERT INTO bds_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee sa inay, ina gi meeti Galilaayage. ");
INSERT INTO bds_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Qatlay hhiee kosi giyaa ilii waaudiri losonage yade Yerusaleemuge, slime Yeesu see yaa hadakay yade hari hhaaboo. Ina yaa hadakayba pandataa. ");
INSERT INTO bds_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Inkoo, giyaadimiisee da Wayahuudi gwaa damaamidiyay ina yade losonage, haa gi ilakoniri maamisu tuba, “Kaale wana heedikee?” ");
INSERT INTO bds_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Slime daa wana saasahhamoo wa⁄a tla⁄aã gu raqoo gu hidage, sa gimba gu Yeesu. Hida wakinay yaa kakaakanay tuba, “Hiĩ ti heedi gu hhou.” Kara wakinay yaa kakaakanay tuba, “Suti! Ina hiicoraaridi hida.” ");
INSERT INTO bds_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Teesaaqay see, hhaku heedi lensee gwaa gimbuusu gimba gosi pandataa, sa gimba yaa tlaꞌamuudiri giyaadimiisee da Wayahuudi. ");
INSERT INTO bds_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Qatlay losona giyaa ilii day tla⁄antla⁄a, Yeesu yaa hadakay mara gu didiruge gu Iliitleemu, haa gi tlaatleesi caacaahhamisu. ");
INSERT INTO bds_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Giyaadimiisee da Wayahuudi gi bakairi sa caacaahhamisu gosi, gi kaayri tuba, “Heediki hiĩ malee caahhi gimbaki, ina duguba caacaahhamisu see ha maarimamaa da sariyaa?” ");
INSERT INTO bds_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Teꞌesii, Yeesu gi ilaki⁄isi inay tuba, “Caacaahhamisuki ga caacaahhaahhamise ti kooiiba ana loi, ti caacaahhamisu gu hikira gunaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bere heedi slai yondu gimbakaꞌa da slaiye Iliitleemu, ina caahhi bere caacaahhamisu goy yaa daqa Iliitleemu dahhi baku hati giimaamisa gimba goy ana loi. ");
INSERT INTO bds_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Heedi gu gimbuusa hari hiidahhasa dosi, ina ti dabiidi muree dosi ina loi. Heedi gu dabiida daareesa da hikira gwaa ya⁄abu ina, hikee ti gimbuusi gimba gu lou, kara waꞌay kosii afaꞌafuuma wantaaba. ");
INSERT INTO bds_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musaa sangwaa hadisiibaslii unkuray sariyaa da Iliitleemu? Teesaaqay see, wanaaba heedi lensee tla⁄aã googunay gu iliikomaamida sariyaa. Inkoo, unkuray hani soꞌoyi slaꞌaday gaasaraa ana?” ");
INSERT INTO bds_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Teꞌesii, hida hhakee gugi ilaki⁄isiri ina tuba, “Ugu ha konta gieeri gu tlakwi! Ti miyaa nugu slai gaasaraa ugu?” ");
INSERT INTO bds_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu gigi ilaki⁄isi inay tuba, “Ana haa yondiidi gimba leẽ gu bakaꞌasa baloo da Sabaatoge, inkoo unkuray goõ haringii tlaꞌadiri. ");
INSERT INTO bds_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Teesaaqay see, sa gimba Musaa sangwaa hadisi unkuray oukira gu daba⁄u, unkuray daba⁄aday khwaylimoo gimati baloo da Sabaato see. Oukee giyaamati daqa Musaa dahhiyaaba, yaati daqa okookoiĩ kokuna dahhi. ");
INSERT INTO bds_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Unkuray gimati baloo da Sabaato see, hiidahhasiday daba⁄u nanku hhawata, sariyaa da Musaa dagama may tlakweesa daqa khwaylimokeesii. Inkoo haã soꞌoyi slahhaaꞌadiri, sa gimba gaã hhoeesi heedi ma slafi baloo da Sabaatoge? ");
INSERT INTO bds_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Unkuray hhanti hukuntay hari arimaa kilesi hari khooroo, ba⁄ay hiti hukuma hari amoo da haaki.” ");
INSERT INTO bds_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Teesaaqay, hida wakinay gu Yerusaleemu, hingaa tlaatleesiri maamisu inay haa inay tuba, “Hiĩ heedikiraabaslii gi damaamidiyee magu gaasiri? ");
INSERT INTO bds_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Inkoo yuꞌudaa, ina hiti gi maamisi pandataa cenceege, kara wanaaba gimba lensee inay sugu kakaakaneei ina. Baku angamalee giyaadimiisee hiti khuiyay tuba, gu lou hiĩ na Kristu? ");
INSERT INTO bds_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Inkoo, dandiray khuana heediki daqa giyaa dahhiye. Kristu, qatlay gimaa ilii khaye, haã ⁄imbani hhaku heedi lensee gumaa caahha ina daqa gimaa dahhiye.” ");
INSERT INTO bds_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Da hheꞌesi, Yeesu gi ilakoomi caacaahhamisu mara gu didiruge gu Iliitleemu hari afoo da didiri, kakaana tuba, “Unkuray goõ hani khuꞌuday ana, daqa gaa dahhe see haga khuꞌuday. Ana haati khayiiba harii dahhasa doyi. Teesaaqay see, ina gunaa ya⁄abu ana guti lou. Hikee unkuray hagumati hhidintiri, ");
INSERT INTO bds_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ana hagu khua, sa gimba ana haa daqa dosi dahha, kara ina naa ana ya⁄abi.” ");
INSERT INTO bds_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Teesaaqay inay gi slairi magu ooyiri. Teesaaqay see, hhaku heedi gwaa waratlaysu daba gosi magu ooyi ina, sa gimba qatlay gosi yaa kahhi buꞌudaraa. ");
INSERT INTO bds_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hida wa⁄a gwaa raqateesii waaree gugi ⁄imbiri ina, kakaanay tuba, “Qatlay Kristu gimaa ilii khaye, maa laqaaqanaa gimba gu bakaꞌasa hari khisla, ba⁄ay da heediki?” ");
INSERT INTO bds_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisaayoo gi akhasiri raqatee da hida cocoiyay gimba gu Yeesu. Da hheꞌesi, inay haa hhapalooee da deni gi ya⁄abiri sirikaarii da mara gu didiru gu Iliitleemu, magwaa ooyiri ina. ");
INSERT INTO bds_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeesu gi kaay sa raqa da hida tuba, “Ana hati waara ha unkuray hari qatlay gu coko⁄u kilesi, ha ki⁄a kara daqa dosii ina gunaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Unkuray hanimaa dabitay ana, etaa hanimaa antaaiiba, slime daqa gamaa iliiwaare ana, unkuray hamaa hiidahhasidaaiiba dawaraa.” ");
INSERT INTO bds_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Teesaaqay, giyaadimiisee da Wayahuudi hingigi maamisiri inay haa inay tuba, “Heediki kaale waaudi, dandiray haguiliimayne slawaraa? Gu louu ina hiti waaudiyaa daqa Wayahuudi gwaa pasidee yaamu gu Wayunaanige haa gi caacaahhamisi Wayunaani? ");
INSERT INTO bds_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hiĩ ti gimba mala ina giĩ gimbuusi? Hiĩ soꞌoyi kaay tuba, ‘Unkuray hanimaa dabitay ana, etaa hanimaa antaaiiba, kara yade daqa gamaa iliiwaare ana, unkuray hiidahhasidaaiiba dawaraa?’ ” ");
INSERT INTO bds_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Inkoo, baloo da hiifaakoo da losonakee gu cuuraiĩ yaa baloo da didiri. Teꞌesii Yeesu gi qadidi, gi kaay hari afoo da didiri tuba, “Heedi gu kooma wakhaa yaa khaye daqa dooii, ma kitahhi maꞌay gu slafimaa. ");
INSERT INTO bds_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Handikaa da Iliitleemu gooay giyoó ilii kaade tuba, ‘Heedi guni ⁄imba ana, duudadaa gu maꞌay gu slafimaa yaa gunay muuna gosaa.’ ” ");
INSERT INTO bds_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeesu giyaa ilii gimbuusi gimbaki, yaati gimbuusi gimba gu Muuna gu Iliitleemu, hiĩ hhakaꞌa gwaa ⁄imbee ina gumaa ooyiyayi qariqaaqari. Qatlaykee Muuna gu Iliitleemu yaa kahhi khawa, sa gimba Yeesu dugwaa kahhi daareesa ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Qatlay hida wakinay tla⁄aã gu raqago giyaa ilii akhasiri gimbakee, gi kaayri tuba, “Gu lou, heediki na Tletimiisay gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wakinay gi kaayri tuba, “Hiĩ na Kristu!” Wakinay gi kaayri tuba, “Kristu yaa hiidahhasiyaa hiica⁄a Galilaayago? ");
INSERT INTO bds_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Handikaa da Iliitleemu yaa kaadi tuba, Kristu maa afamaraa gu Dawdigo hiica⁄i, haa dugumaati laqwali yaamu gu Beteleheemuge, yaamu giyaa ilii ibimaamidiye Dawdi.” ");
INSERT INTO bds_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Teesaaqay, raqatee da hida hingigi deehhiihhiniri sa gimba gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hida wakinay tla⁄aã gooinay gwaa slaiyay oowaraa Yeesu. Teesaaqay see, hhaku heedi gwaa waratlaysu dabaiĩ kosi, magu ooyi ina. ");
INSERT INTO bds_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Da hheꞌesi, sirikaaritira yaagi ki⁄iri daqa hhapalooee da denige haa daqa Farisaayooge. Inay gigi maasiri tuba, “Hagwaani soꞌoyi maydiri oowaraa?” ");
INSERT INTO bds_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sirikaaritee gi ilaki⁄isiri inay tuba, “Hagwaani oowaniiba, sa gimba wanaaba heedi gu giimaamisa hari hiidahhasa, heediki gooay!” ");
INSERT INTO bds_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Da hheꞌesi, Farisaayoo gigi maasiri inay tuba, “Gu lou, unkuray see danguntii corii ha hikee? ");
INSERT INTO bds_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gu lou, wanaa giyaadimiisay lensee, baku leẽ gu Farisaayoo gwaa ⁄imbu Yeesu? ");
INSERT INTO bds_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Teesaaqay see, hida hhanki goó ⁄imbee heedikaꞌa, hhidinay sariyaa da Musaa. Inay digaa ilawaasi!” ");
INSERT INTO bds_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodeemo yaa leẽ gu giyaadimiisee da Farisaayoo, gwaa hadakawu daqa Yeesuge baloo waka hari amasi. Ina gi maasi deneꞌee kosi tuba, ");
INSERT INTO bds_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Inkoo, sariyaa doori hukuntaa heedi, dugu kahhi akhasa gesaa, haa dagi caahhi idoo giĩ yondiidi?” ");
INSERT INTO bds_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Inay gi ilaki⁄isiri Nikodeemo tuba, “Ugu see haa Galilaaya dahhadaa? Taa⁄a somimi Handikaa da Iliitleemuge, asu caahhada tuba, wanaaba tletimiisay gwaa hiidahhasa hiica⁄a, hhapee da Galilaayago!”  ");
INSERT INTO bds_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Da hheꞌesi, hida goõ gi waaudiri, kila heedi gi ki⁄i yaamu koinay. ");
INSERT INTO bds_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Inkoo, Yeesu yaagii ca⁄i mara gu didirugo gu Iliitleemu, gi waaudi oõ gu Miseyituunige. ");
INSERT INTO bds_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Heetlaalee dosii hari heetlawaa, Yeesu yaagi khay kara mara gu didiruge gu Iliitleemu. Hida goõ yaagi khayri daqa dosii, ina gi ibiidi, gi tlaatleesi caacaahhamisu inay. ");
INSERT INTO bds_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Teꞌesii, maarimamaa da sariyaa da diini haa Farisaayoo suguraagi khayri hadee daa ilaslaslay slipalauumage. Inay gigi qadidisiri tla⁄aã gu hidage. ");
INSERT INTO bds_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Inay gi kaayri sa Yeesu tuba, “Maarimuu, hadeti dagaã ilaslaslay slipalauumage. ");
INSERT INTO bds_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sariyaa doorii, Musaa hindaati ilafahhi cakhadiru hari tle⁄eẽ hadee da hankaa gooay hiti amoolaa gwaꞌata. Inkoo, ugu hati mala oiiꞌinta?” ");
INSERT INTO bds_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inay yaati maasiri Yeesu teesaaqay, magu hatliniri haa ma slayri amoo dari sitaakiru ina. Teꞌesii, Yeesu gii condoi haa gi tlaatleesi handikiru hhapeege hari dinca dosi. ");
INSERT INTO bds_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qatlay inay gwaa ilii ilakoniri maamisu ina, ina gi qadidi haa sigigi kaay inay tuba, “Heedi gubasli tlakwaroo tla⁄aã googunay, ina giyaadiye cakhada hadeti hari tlaa⁄u.” ");
INSERT INTO bds_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Da hheꞌesi, Yeesu gii condoi kara haa gi handikimi hhapeege. ");
INSERT INTO bds_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Qatlay inay giyaa ilii akhasiri gimbaki, gi tlaatleesiri waaumidu lelee lelee, gaduũ gunaa pandaa waaumidu. Inay gi mayri Yeesu teꞌesii ina lenkosi, haa hadetee hiĩ qaditi teꞌesii pandaa dosii. ");
INSERT INTO bds_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Da hheꞌesi, Yeesu gi qadidi haa gi maasi hadetee tuba, “Igi de iyoo, hida hhakira kaanoki? Hhakuu lensee gu hukuma igi tuba konta tlakwaroo?” ");
INSERT INTO bds_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hadetee gi ilaki⁄isidi tuba, “Ye Looimoo, wanaaba lensee.” Da hheꞌesi, Yeesu sagagi kaay tuba, “Ana see hagi hukumaaba igi. Taa⁄a ayigoogii, tlaatleesa da qatlaykaa hanti yondita kara tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Da hheꞌesi, Yeesu gi ilakoomi gimba sa hida hhakee, sigigi kaay tuba, “Ana ti cencee da hida gu khoorotii waaree. Kila heedi gu sirakooma ana, etaa ina khokhocinaaba hhanteege. Ina yooti kona cencee daroó khawa slafimaa.” ");
INSERT INTO bds_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Teesaaqay, Farisaayoo sugugi kaayri ina tuba, “Ugu hangiti ilatlatlaatlayda ugu lenkoogu. Sa gimbakee ilatlatlaw googu guti louuba.” ");
INSERT INTO bds_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu gigi ilaki⁄isi inay tuba, “Ana hangimati ilatlatlay see ana lenkoyi, ilatlatlawu goy guti lou. Ana ha khua daqa gaa dahhe, kara ha khua daqa ga kakaakawe. Unkuray ha hhidintay daqa gaa dahhe, kara hhidintay daqa ga kakaakawe see. ");
INSERT INTO bds_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Unkuray hati hukuukuntay hari ilahudaa kokuna gu slaqoo kilesi. Ana hukumaaba heedi. ");
INSERT INTO bds_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ana hagamati hukumi see, hukumuu goy guti lou, sa gimba ana lenkoyi waaraaba. Taataa gunaa ya⁄abu ana sliimaa wana haa ana. ");
INSERT INTO bds_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sariyaa doogunayge daa handikimi tuba, ‘Ilatlatlaw gu hida cada dugu ⁄imbi tuba, guti loi.’ ");
INSERT INTO bds_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ana hangu ilatlatlawu ana lenkoyi, slime Taataa, ina gunaa ya⁄abu, hini ilatlatlay ana.” ");
INSERT INTO bds_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Da hheꞌesi, Farisaayoo gi maasiri Yeesu tuba, “Inkoo, Taataa googu kaale wana?” Yeesu gigi ilaki⁄isi inay tuba, “Unkuray hani hhidintay ana, gimati Taataa goy see hagu hhidintay. Bere ana hanaa caahhaday tuba ti miyaa, slime Taataa goy see hagwaa caahhaday.” ");
INSERT INTO bds_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeesu yaa gimbuusi gimbaki, qatlay giyaa ilii caacaahhaahhamisiye daqa daa iliiqamaamidiye sandikoo da sadaaka, mara gu didiruge gu Iliitleemu. Teesaaqay see, wanaaba heedi gwaa oow ina, sa gimba qatlay gosi yaa kahhi buꞌuda. ");
INSERT INTO bds_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu sigigi kaay kara tuba, “Ana ha waauuꞌumida, haa da hheꞌesi unkuray hanidabitay. Teesaaqay see, unkuray hati kaka⁄aday tlakwaroo doogunay. Daqa ga kakaakawe ana, unkuray hiidahhasidaaiiba dawaraa.” ");
INSERT INTO bds_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Teesaaqay, Wayahuudi hingigi maamisiri inay haa inay tuba, “Inkoo, hingiti gaasa kayaa ina lenkosi? Soꞌoyi kakaana tuba, ‘Ana daqa ga iliiwaaude unkuray hiidahhasidaaiiba dawaraa?’ ” ");
INSERT INTO bds_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu sigigi ilaki⁄isi inay tuba, “Unkuray haa tia dahhaday hhapeego, ana haa rawaa gu raw dahha. Unkuray guti khooroti, ana guti khoorotiiba. ");
INSERT INTO bds_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hatee na idoo ana sangwaa ilii kaay unkuray ambee, kaka⁄aday tlakwaroo doogunay. Bere hanguba ⁄imbaraa tuba, ana na ina, hati kaka⁄aday tlakwaroo doogunay.” ");
INSERT INTO bds_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Inay gi maasiri Yeesu tuba, “Sandi kaade ugu ti miyaa?” Yeesu gigi ilaki⁄isi inay tuba, “Ana na hikira sangu giimaamise unkuray tlaatleesoogo. ");
INSERT INTO bds_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ana kooma gimba wa⁄a gu cocoꞌomoo haa gu hukuruu daqa doogunay. Kara, ana hati kakaakama sa hida gu khooroti, gimbakira gaa akhasi daqa Taataago. Ina hinaani ya⁄abi ana, kara ina guti lou.” ");
INSERT INTO bds_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Inay yaa baraslayiriiba tuba, Yeesu yaati gimbuusi haa inay gimba gu Taataa gosi gu rawaa gu raw. ");
INSERT INTO bds_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Teesaaqay, Yeesu sigigi kaay inay tuba, “Unkuray gamaa hheꞌesidee waratlaysa rawaage Nanku Heedi, teꞌesii unkuray ganimaa ilii caahhaday tuba, ana na ina. Slime maa caahhaday tuba, ana yondiidaaba gimba lensee ana lenkoy. Ana ti gimbuusa gimbakira kilesi, dinaa caacaahhamisi ha Taataa goy. ");
INSERT INTO bds_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kara, ina gunaa ya⁄abu sliimaa wana haa ana. Ina hinaa mayiiba ana lenkoyi, sa gimba balalu sliimaa ana hati yondiida gimba gu muunaboo⁄eesa ina.” ");
INSERT INTO bds_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Qatlay Yeesu giyaa ilii gimaamisiye gimbaki, hida wa⁄a gugi ⁄imbiri ina. ");
INSERT INTO bds_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Da hheꞌesi, Yeesu gi kaay sa Wayahuuditira gwaa ⁄imbee ina tuba, “Bere ha iliikontay gimba goy hangu caacaahhaahhamise, unkuray ti sirakoomiisee doyi da loi. ");
INSERT INTO bds_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kara, unkuray ha caahhaday gimba gu lou gu Iliitleemu, hiĩ gu hiica⁄asa unkuray tongaiimaago.” ");
INSERT INTO bds_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Inay gugi ilaki⁄isiri ina tuba, “Dandiray ti laqwaloo da Aburahaamu. Kara, dandiray etaa haa tongee da heedi lensee tleehhidaniiba. Inkoo, ugu ha malee kaada tuba, dandi hiica⁄asi tongaiimaago?” ");
INSERT INTO bds_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou, sangu kaay unkuray ambee, kila heedi goó yondiida tlakwaroo, hikee ti tongimoo gu tlakwaroo. ");
INSERT INTO bds_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tongimoo ibiidiyaaba mara gu looimoo gosii balalu sliimaa. Nanku looimokee na ibiidi marakeesii balalu sliimaa. ");
INSERT INTO bds_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Teesaaqay, bere Nanku Iliitleemu hangu hiica⁄asi tongaiimaa da tlakwaroogo, gu lou, unkuray tongee tleehhitaaiiba kara. ");
INSERT INTO bds_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ana ha khua ambee, unkuray ti okookoiĩ gu laqwaloo da Aburahaamu. Teesaaqay see, unkuray hani slaꞌaday gaasa ana, sa gimba, ha sisaasiꞌiday ⁄imba caacaahhamisu goy. ");
INSERT INTO bds_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ana sanguti giimaamisa gimbakira gaa arimi daqa Taataa gooaa. Namati Teesaaqay, unkuray hati yondimaamitay gimbakira gaa akhasidiri daqa taataa googunaa.” ");
INSERT INTO bds_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Inay gugi ilaki⁄isiri ina tuba, “Dandiray taataa goori na Aburahaamu!” Yeesu gigi ilaki⁄isi inay tuba, “Bere gu lou unkuray ti laqwaloo da Aburahaamu, haã aloo yondimaamitay gimbakira Aburahaamu giyaa yondiidi. ");
INSERT INTO bds_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inkoo, unkuray hani slaꞌaday gaasa ana, sa gimba ana sanguti kakaakama unkuray, gimba gu lou gaa akhasi daqa Iliitleemugo. Gu lou, Aburahaamu yaa yondiidiiba teesaaqay. ");
INSERT INTO bds_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Unkuray hati yondimaamitay gimbakaꞌa taataa googuna gi yondimaamidiye.” Inay gugi ilaki⁄isiri tuba, “Dandiray yaꞌay gu slipalauuma gooba. Dandiray ha kona Taataa leẽ, ina na Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu sigigi kaay inay tuba, “Bere Iliitleemu hiĩ aloo Taataa googuna, haniĩ aloo slaꞌaday ana, sa gimba ana haa daqa Iliitleemu dahha, inkoo tiꞌii waara. Ana haati khayiiba hari muuna goy, ti Iliitleemu naa ana ya⁄abi. ");
INSERT INTO bds_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Inkoo, unkuray hangu soꞌoyiba baraslawa gimba sangu giimaamise? Ti sa gimba unkuray slaꞌadaaiiba akhamisu gimba goy sangu giimaamise. ");
INSERT INTO bds_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Unkuray ti yaꞌay gu taataa googuna Biriisimoo, kara slahhaahhaau gu taataa googuna guni yondimaamitay. Biriisimoo ti cu⁄udiisay yadaa tlaatleesoogo, kara qadidiyaaba gimba gu louge, sa gimba, gimba gu lou wanaaba waꞌay kosii. Qatlay Biriisimoo giyoó ilii gimbuusiye afaꞌafuuma, hikee na ou gosi, sa gimba ina ti afaꞌafuusay haa ti taataa gu afaꞌafuuma goõ. ");
INSERT INTO bds_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Inkoo, sa gimba ana sangu giimaamisa unkuray gimba gu lou gu Iliitleemu, unkuray haniĩ ⁄imbidiriiba ana. ");
INSERT INTO bds_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wanaa leẽ tla⁄aã googunay gu hiidahhasa maꞌasa tuba, ana kooma tlakwaroo? Bere ana sanguti giimaamisa gimba gu lou gu Iliitleemu, hangu soꞌoyiba ⁄imbaraa ana? ");
INSERT INTO bds_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Heedi gu Iliitleemu, akhamisi gimba gu Iliitleemu. Unkuray akhamisidaaiiba gimba gosi, sa gimba unkuray hida gu Iliitleemu gooba.” ");
INSERT INTO bds_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahuudi gi ilaki⁄isiri Yeesu tuba, “Dandiray kaawanaabaslii gimba gu lou tuba, ugu ti Samarimoo, haa ti konta gieeri?” ");
INSERT INTO bds_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeesu gigi ilaki⁄isi inay tuba, “Ana koomaaba gieeri, ana hati muriida Taataa goy. Unkuray hanoó muritaaiiba ana. ");
INSERT INTO bds_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ana damaamidaaba muree doyi ana loi. Wana leẽ gu slaꞌa, ana sinima hadimisi muree, kara ina na hakiimuu gu lou. ");
INSERT INTO bds_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gu lou, sangu kaay unkuray ambee, bere heedi iliikona gimba goy, etaa ina himaa arinaaba gwaaꞌaraa koraraa haa koraraa goóba hiifaakoo.” ");
INSERT INTO bds_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Da hheꞌesi, Wayahuudi gi kaayri sa Yeesu tuba, “Inkoo gu lou haã caahhani tuba, ugu konta gieeri gu tlakwi! Aburahaamu yaa gwaai, kara tletimiisee da Iliitleemu see yaa kaka⁄iri. Teesaaqay see, ugu kakaakanta tuba, ‘Bere heedi iliikona gimba goy, arinaaba gwaaꞌaraa koraraa haa koraraa goóba hiifaakoo.’ ");
INSERT INTO bds_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Inkoo, ugu guti didiruu ba⁄ay da taataa goori Aburahaamu? Ina yaa gwaai, tletimiisee da Iliitleemu slime yaa kaka⁄iri. Inkoo, ugu goo ilatahhade, ugu na miyaa?” ");
INSERT INTO bds_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu gigi ilaki⁄isi inay tuba, “Bere ana sangi dabiida muree ana lenkoyi, muretee toyi hiti diitiray. Taataa goy, hikee unkuray ga kakaakantee tuba, na Iliitleemu googuna, ina na daareesi ana. ");
INSERT INTO bds_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Unkuray, Iliitleemu hagumati hhidintiri, ana hagu khua. Bere ana haã aloo kaawa ambee, Iliitleemu hagu hhidima, ana see hanti aloo kaawa afaꞌafuuma unkuray gooay. Ana hagu khua, kara gimba gosi goó iliikooma. ");
INSERT INTO bds_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taataa googuna Aburahaamu yaa hhaꞌaluudi, hari ilahudeesa tuba, arina baloo doyi da khawaraa khoorotii. Ina giyaa ilii arimi balotee, gi hhaꞌaluudi.” ");
INSERT INTO bds_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Da hheꞌesi, Wayahuudi sugugi kaayri ina tuba, “Ugu kahhada buꞌudisa see koraraa mibeeri kooani! Inkoo, malee kakanta tuba, Aburahaamu hagwaa arinti?” ");
INSERT INTO bds_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu gigi ilaki⁄isi inay tuba, “Gu lou sangu kaay unkuray ambee, Aburahaamu dugwaa ilii kahhiye laqwaloo see, ana haa waara.” ");
INSERT INTO bds_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wayahuudi giyaa ilii akhasiri gimbaki, gi hufidiri tle⁄eẽ magu cakhadiniri haa magu gaasiri. Teesaaqay see, Yeesu gi nahhadi, gii ca⁄i mara gu didirugo gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Letu waka, Yeesu haa sirakoomiisee dosi, giyaa ilii khociicinee, yaa arimi heedi waku gwaa ilahhamu laqwaloo dosaago. ");
INSERT INTO bds_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sirakoomiisee dosi gugi maasiri ina tuba, “Maarimuu, ti miyaa naa yondiidi tlakwaroo, ti heediki baku taataa haa iyoo dosi, ina dugugi laqwali yaa ilahhami?” ");
INSERT INTO bds_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu gigi ilaki⁄isi inay tuba, “Heediki dugwaati laqwaliiba yaa ilahhami, sa gimba gu tlakwaroo dosi, gimati tlakwaroo da taataa haa iyoo dosi. Ina dugwaati laqwali yaa ilahhami, ⁄uuru gu Iliitleemu duguma arimi daqa dosii. ");
INSERT INTO bds_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dandiray kwanda ga yondiidane yondu gu hikira gunaa ya⁄abu ana, qatlay da ilii kahhiye tleemaa. Amasi yaa khociyay, qatlaykee wanaaba heedi lensee gu hiidahhasa yondiida yondu. ");
INSERT INTO bds_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Qatlay ga iliiwaare khoorooge, ana ti cencee sa hida gu khoorotii waaree.” ");
INSERT INTO bds_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbaki, gi cubuqi cubuqari hhapeege, haa gi boo⁄imisi tipa hari cubuqari hhakee. Ina gigi maakhi hari tipa ilaa gu heedikee gwaa ilahhamu. ");
INSERT INTO bds_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Da hheꞌesi, sugugi kaay tuba, “Taa⁄a slirooqisii ilaa koku wa⁄amu gu Siloaamuge.” (Siloaamu maꞌaana dosi na daa ya⁄abi.) Teesaaqay heedikee gi waaudi, gii slirooqisi ilaa kosi, yaagi ki⁄i yaa khuꞌuna. ");
INSERT INTO bds_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Teesaaqay, raqa da didiri da hida gwaa ibimaamidee coomooge haa ina haa wakinay angaamaka gwaa arimee ina wakaꞌalee firifiriirina, hingigi maamisiri inay haa inay tuba, “Heediki ti hikiraabaslii gwaa ibimaamida haa gi firifiriirina?” ");
INSERT INTO bds_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hida angaamaka gu raqatee gi kaayri tuba, “Heediki na ina.” Wakinay raqateesii gi kaayri tuba, “Hiĩ na inaaba, hingaati slaaslaaqasi haa ina.” Teꞌesii ina loi daa hhoeesi, gi ilakoomi kakaaru sa inay tuba, “Ana na ina gwaa ibimaamida haa gi firifiriirima.” ");
INSERT INTO bds_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Da hheꞌesi, inay gugi maasiri ina tuba, “Inkoo, ilaa koku hiĩ malee hiidahhasiri khuꞌuduũ?” ");
INSERT INTO bds_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ina gigi ilaki⁄isi inay tuba, “Heedikaꞌa doó eteedine Yeesu hiĩ boo⁄imisi tipa, hinigi maakhi ilaa koi, haa hinigi kaay tuba, ‘Taa⁄a slirooqisii ilaa koku wa⁄amu gu Siloaamuge.’ Teesaaqay ana gi waaudi, gii slirooqisi, hagi tlaatleesi khuꞌuduũ.” ");
INSERT INTO bds_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Da hheꞌesi, inay gugi maasiri tuba, “Inkoo heedikee kaale wana?” Ina gigi ilaki⁄isi inay tuba, “Ana hhidima ina daqa gi iliiwane.” ");
INSERT INTO bds_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Da hheꞌesi, hida hhakee gugi leehhisiri daqa Farisaayooge heedikee gwaa ilahhamu wakaꞌalee. ");
INSERT INTO bds_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Inkoo, hatee yaa baloo da Sabaato, Yeesu giyaa ilii boo⁄imisi tipa haa gi hhoeesi ilaa gu heedikee. ");
INSERT INTO bds_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Teesaaqay, Farisaayoo gugi maasiri heedikee, idoo ilaa kosi giyaa ilii dahhasiri khuꞌuduũ. Ina gigi ilaki⁄isi inay tuba, “Ina hiniĩ maakhi tipa ilaa koii, ana hagii slirooqisi ilaa koi, inkoo ana ha khuꞌuuꞌuma.” ");
INSERT INTO bds_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Teesaaqay, Farisaayoo angaamaka gi kaayri tuba, “Heediki yaa daqa Iliitleemu dahhiyaaba, sa gimba ina iliikomaamidiyaaba baloo da Sabaato.” Teesaaqay see, wakinay gi kaayri tuba, “Heedi gu kooma tlakwaroo malee gii dahhasi yondu gimba gu bakaꞌasa da hinkaa gooay?” Teꞌesii, hingigi deehhiihhiniri inay haa inay. ");
INSERT INTO bds_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Da hheꞌesi, Farisaayoo gugi maasiri kara heedikee tuba, “Ina niĩ hhoeesii ilaa koku. Inkoo, ugu mala oiiꞌinta sa gimba gu heedikee?” Ina gigi ilaki⁄isi inay tuba, “Ina ti tletimiisay gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Giyaadimiisee da Wayahuudi yaa ⁄imbiriiba tuba, gu lou heediki yaa ilahhami wakaꞌalee, inkoo khuꞌuuꞌuna, giyaa iliieteediri naqatloo taataa haa iyoo dosi. ");
INSERT INTO bds_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Da hheꞌesi, gi maasiri inay tuba, “Heediki ti nakooguna, unkuray ga kakaakantee tuba, dugwaa laqwali yaa ilahhami? Inkoo, ina hiĩ malee gii dahhasi khuꞌuduũ?” ");
INSERT INTO bds_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Teꞌesii, Taataa haa iyoo dosi gigi ilaki⁄isiri inay tuba, “Dandiray ha khuana tuba, heediki ti nankoori haa dugwaati laqwali yaa ilahhami. ");
INSERT INTO bds_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Teesaaqay see, idoo gi ilii khuꞌuuꞌune inkoo, dandiray ha hhidina. Kara dandiray ha hhidina miyaa niĩ hhoeesi ilaa kosi. Unkuray maasakuna ina loi. Ina ti heedi gu didiru haa hiidahhasi ilakeesa gimbakee ina loi.” ");
INSERT INTO bds_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Taataa haa iyoo dosi yaa teesaaqay gimbuusiri, sa gimba inay yaa tlaꞌamuudiri giyaadimiisee da Wayahuudi. Inay yaa caahhiri tuba, giyaadimiisetee hingaa ila⁄imbidiri gusinta sinagoogigo heedi gu ⁄imba tuba, Yeesu na Kristu. ");
INSERT INTO bds_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hatee na idoo, taataa haa iyoo dosi saganaa kaayri tuba, “Ina ti heedi gu didiru, maasakuna ina.” ");
INSERT INTO bds_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Da hheꞌesi, giyaadimiisetee gugi eteediri waa da cada heedikee gwaa ilahhamu, haa sugugi kaayri ina tuba, “Gimbuusi gu lou pandaa da Iliitleemuge! Dandiray ha khuana tuba, heedikee guũ hhoeesu ugu ti kona tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ina gigi ilaki⁄isi inay tuba, “Bere ina ti kona tlakwaroo, ana hhidima. Gimba leẽ ga khue na nahiĩ tuba, wakaꞌalee ana haati ilahhami, inkoo ha khuꞌuuꞌuma.” ");
INSERT INTO bds_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inay gugi maasiri kara ina tuba, “Inkoo, heedikee yaati malee laqi daqa dooguu? Ina yaati malee laqi gi tlaaꞌasi ilaa koku?” ");
INSERT INTO bds_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ina gigi ilaki⁄isi inay tuba, “Ana sanguu hheꞌesi sanguu kaay gimbakee, unkuray kahhaday toogunaa slaꞌadaaiiba ⁄imbaraa gimba sanguũ kaay. Kara slaꞌadaaii sangu kaay? Inkoo, unkuray see hati slaꞌadaaii sirakoomiisee dosi tleehhida?” ");
INSERT INTO bds_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Inay gugi wahaahaniri kakaanay tuba, “Ugu loi na sirakoomiisay gu heedikee! Dandiray ti sirakoomiisee da Musaa! ");
INSERT INTO bds_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dandiray ha khuana tuba, Iliitleemu yaa gimbuusi haa Musaa. Heediki, dandiray ha hhidina daqa giyaa dahhiye!” ");
INSERT INTO bds_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Heedikee gigi ilaki⁄isi inay haa gi kaay tuba, “Hiĩ ti gimba gu bakaꞌasa! Unkuray ha hhidintay daqa giyaa dahhiye. Teesaaqay see, ina niĩ hhoeesi ilaa koi! ");
INSERT INTO bds_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dandiray ha khuana tuba, Iliitleemu itatiisiyaaba firoo da hida gu koomee tlakwaroo. Iliitleemu hiti itatiisi heedi goó firiirima ina haa gi yondiidi idoo gi slaiye ina. ");
INSERT INTO bds_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yadaa tlaatleesoogo Iliitleemu giyaa ilii tleehhi khooroo, hakahhana akhasa heedi hiĩ hhoeesi ilaa gu heedi daa laqwali yaa ilahhamu. ");
INSERT INTO bds_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bere heediki yaa aloo daqa Iliitleemu dahhiyaaba, hiĩ aloo hiidahhasiyaaba yondu idoo lensee.” ");
INSERT INTO bds_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Inay gugi ilaki⁄isiri ina tuba, “Ugu dugwaati laqwali haa dugugi omi tlakwarooge. Inkoo, ugu malee gii dahhasida caacaahhamisu dandiray?” Da hheꞌesi, inay gugi gusiniri Sinagoogigo. ");
INSERT INTO bds_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesu gi akhasi tuba, heedikira giyaa hhoeesi ilaa kosi, Wayahuudi guũ gusiniri sinagoogigo. Da hheꞌesi, Yeesu gugi slay haa gugi maasi ina tuba, “Ugu haã ⁄imbidii Nanku Heedi?” ");
INSERT INTO bds_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Heedikee gugi ilaki⁄isi gi kaay tuba, “Looimoo, Nanku Heedi na miyaa, ana see magu ⁄imbi?” ");
INSERT INTO bds_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu gugi ilaki⁄isi ina tuba, “Ugu haguũ arinti. Kara ina gu giimaamisa haa ugu inkoo, hikee na ina.” ");
INSERT INTO bds_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Heedikee gi kaay tuba, “Looimoo, ana haguũ ⁄imbi.” Ina gi keebeeidi gi firimi Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeesu gi kaay tuba, “Ana haati khay khoorotii sa hukuru, hhakaꞌa gwaa ilahhamaahhamee ma khuꞌuniri, kara hhakaꞌa gu khuꞌuuꞌumee, ma ilahhamaahhaniri.” ");
INSERT INTO bds_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisaayoo angaamaka gwaa ilaciyaage waaree haa Yeesu gi akhasiri gimbakee, gugi maasiri ina tuba, “Gu louu, dandiray slime haati ilahhamaahhanii?” ");
INSERT INTO bds_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu gigi ilaki⁄isi inay tuba, “Bere unkuray haati aloo ilahhamaahhantay, haã aloo kontaaiiba dakoo. Inkoo, sa gimba ha kakaakantay tuba, ‘Ha khuꞌuuꞌuntay,’ teesaaqay unkuray ha kontay dakoo.” ");
INSERT INTO bds_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeesu yaa ilakoomi gimba tuba, “Gu lou, sangu kaay unkuray ambee, heedi gubasli hiidawa hari kaꞌafu gu qwaama da bee⁄u, ina gii day qwaamage hari daqa waka, hikee ti fiisiisay haa ti afii⁄utlidiisayi. ");
INSERT INTO bds_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Heedi gu hiidawa hari kaꞌafu gu qwaama, hikee na deꞌemiisay gu bee⁄u. ");
INSERT INTO bds_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ina sugu afiiooyina afamaraa ha heedi goó ga⁄awa qwaama, slime bee⁄u akhasiyayi afoo dosi. Ina gi eteedina bee⁄u gosi hari umaiĩ koina haa gigii ca⁄asi khoorooge. ");
INSERT INTO bds_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Qatlay giĩ iliica⁄asi bee⁄u gosi goõ khoorooge, ina gi giyaadi pandaa da bee⁄uge, bee⁄u gugi sirakonay ina, sa gimba inay khuiyay afoo dosi. ");
INSERT INTO bds_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bee⁄ukee etaa sirakonaaba dahaa. Inay guti lakidiyay, sa gimba hhidinay afoo da dahaa.” ");
INSERT INTO bds_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu sigaa kaay inay ilaꞌaaꞌaatisati. Teesaaqay see, inay yaa caahhiriiba, ti gimba mala ina giyaa giimaamisiye sa inay. ");
INSERT INTO bds_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Da hheꞌesi, Yeesu sigigi kaay kara tuba, “Gu lou, sangu kaay unkuray ambee, ana ti kaꞌafu gu bee⁄u, gurii guuma qwaamage. ");
INSERT INTO bds_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Goõ gwaa giyaadee khawaraa, ana gaa ilii kahhe, hhakee yaati fiisiisee haa afii⁄utlidiisee, bee⁄u giyaa itatiisiriiba inay. ");
INSERT INTO bds_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ana ti kaꞌafu gu bee⁄u pahha. Heedi gu hiidawa hari amoo doyi, ina dugu ilabuꞌuna. Kara, ina hiiday haa yaa hiica⁄i, haa slay deꞌeẽ gu hhou. ");
INSERT INTO bds_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Fiisiisay yaati khay qwaamage sa fiisi da bee⁄u, sa cu⁄uduũ haa sa tlakweemisu. Ana haati khay ma slayri slafimaa, kara ma slayri slafimaa hhakee wa⁄a. ");
INSERT INTO bds_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ana na deꞌemiisay gu hhou. Deꞌemiisay gu hhou yoó hadisi slafimaa kosi sa ilabuꞌuru gu bee⁄u gosi. ");
INSERT INTO bds_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yondimiisay hiĩ doó buiye musaalaa, hikee deꞌemiisay gu bee⁄u gooba, kara bee⁄u ti kosiiba. Ina giyoó iliiarine takuraaimoo yaa khoci, ina yoóti may bee⁄u haa gi lakidi. Da hheꞌesi, takuraaimoo yoóti iliitlai bee⁄u haa gigii pasidisi. ");
INSERT INTO bds_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ina hiti lakidi, sa gimba ti yondimiisay gu musaalaa kilesi, bee⁄u idoo gooba daqa dosii. ");
INSERT INTO bds_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ana na deꞌemiisay gu hhou. Ana ha khua hhakaꞌa gu koi, kara hhakaꞌa gu koi hini khuiyay ana. ");
INSERT INTO bds_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Namati teesaaqay Taataa hini khui ana, slime ana hagu khua ina. Ana ha hadisa ibinaa doyi sa ilabuꞌuru bee⁄u goy. ");
INSERT INTO bds_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Slime ana ha kooma bee⁄u wakinay hhaã gu qwaamatiiba. Hhakee see kwanda hagiraa khawe, slime inay akhasiyayi afoo doyi. Da hheꞌesi, damaa wana raqa leẽ haa deꞌemiisay leẽ. ");
INSERT INTO bds_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Taataa goy hini slai ana, sa gimba ana hadisa slafimaa koi sa hida, ana magi slay kara. ");
INSERT INTO bds_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wanaaba heedi guni afii⁄utla slafimaa koi, ana hagiti hadisa hari muuna goy. Ana kooma hiidahhasa da hadisa slafimaa koi, slime ha kooma hiidahhasa da hiiowa kara slafimaa koi. Ilakaawati hagaati ooyi daqa Taataa gooaa, ana ma yondiidi teesaaqay.” ");
INSERT INTO bds_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sa gimbaki gu Yeesu, daagii ca⁄i kara deehhoo tla⁄aã gu Wayahuudige. ");
INSERT INTO bds_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hida wa⁄a tla⁄aã gooinay yaa kakaakanay tuba, “Heediki kona gieeri, kara kona khansu! Inkoo, hagu hhanti akhamisidayi ina!” ");
INSERT INTO bds_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wakinay gi kaayri tuba, “Heedi gu kooma gieeri, hiidahhasiyaaba cocoꞌomoo gimba da hikee gooay. Kara, gieeri hiidahhasiyaaiiba hhoeesa ilaa gu heedi gwaa ilahhamu.” ");
INSERT INTO bds_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Inkoo, yade Yerusaleemuge yaa wana losona gu hiislawaraa gu kwahharaa da slasla⁄iima mara gu didirugo gu Iliitleemu. Kara, qatlaykee yaa qatlay gu kijaajimoo. ");
INSERT INTO bds_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Teꞌesii, Yeesu yaa khokhociicina mara gu didiruge gu Iliitleemu, balasaa daa eteediidinege na balasaa da Solomooni. ");
INSERT INTO bds_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Da hheꞌesi, Wayahuudi gi ilii kurunkuridiri Yeesu, gugi maasiri tuba, “Inkoo, ugu hati ilakonta ilahufita muunaiĩ koti malaalee naqatloo? Bere ugu na Kristu, sandi kaade pandataa.” ");
INSERT INTO bds_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu gigi ilaki⁄isi inay tuba, “Ana sanguũ kaay, unkuray slaꞌadaaiiba ⁄imba. Yondu ga yondimaamide goó bakaꞌasa hida hari uma gu Taataa goy, yondukee hini ilatlatlaatlay. ");
INSERT INTO bds_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Teesaaqay see, unkuray haã ⁄imbidiriiba, sa gimba unkuray guti raqa da bee⁄u gooiiba. ");
INSERT INTO bds_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bee⁄u gooi yoó akhamisi afoo dooi, ana hagi khua inay, kara inay hinoó sirakonay ana. ");
INSERT INTO bds_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ana sigi hadisa inay slafimaa gu koraraa haa koraraa goóba hiifaakoo. Inay maa hhanaaiiba coko⁄o see, kara wanaaba heedi gumaa hiidahhasa hii⁄utla inay dabaiĩ koaa. ");
INSERT INTO bds_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taataa goy guũ hadisu inay sa ana, ina guti didiru ba⁄ay da goõ. Kara, wanaaba heedi gu hiidahhasa hii⁄utla inay dabaiĩ gu Taataago. ");
INSERT INTO bds_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ana haa Taataa goy kona ilagaasa.” ");
INSERT INTO bds_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Teꞌesii Wayahuudi gi hufidiri kara tle⁄eẽ, magu cakhadiniri ina. ");
INSERT INTO bds_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeesu gi kaay sa inay tuba, “Ana sunguũ laqaaqami unkuray yondu wa⁄a gu bakaꞌasa hida daqa Taataago. Tla⁄aã gu hhakeesii ti sa yondu haloo sagani cakhadintay ana hari tle⁄eẽ?” ");
INSERT INTO bds_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahuudi gugi ilaki⁄isiri ina tuba, “Dandiray hagu cakhadinaaba ugu hari tle⁄eẽ sa yondu gu hhou gaã yonditi, ti sa gimba ugu haã belendeqesidi Iliitleemu. Kara ugu gimati heedi kilesi, hangi eteediidinta tuba, ugu ti Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu gigi ilaki⁄isi inay tuba, “Daa handakimiibaslii sariyaa doogunayge tuba, ‘Ana haã kaay ambee, unkuray ti iliitleemamee?’ ");
INSERT INTO bds_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iliitleemu giyaa eteedi iliitleemamee, hida hhakira saa hadisi gimba gosi. Kara, khuana tuba, Handikaa da Iliitleemu daga hiidahhasiyaaba hiifooka. ");
INSERT INTO bds_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Taataa hinaa tlintiꞌisi ana haa naagi ya⁄abi khoorooge. Inkoo, unkuray malee kaaday, ana haã belendeqesi Iliitleemu, sa gimba gaã kaay ambee, ‘Ana ti Nanku Iliitleemu?’ ");
INSERT INTO bds_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bere ana yondimaamidaaba yondu gu Taataa goy, hani hhanti ⁄imbiday ana. ");
INSERT INTO bds_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bere ana hati yondimaamida yondu gu Iliitleemu, unkuray gamati maydiri see ⁄imba ana, ⁄imba yondukee ga yondimaamide. Laqa teesaaqay ma caahhadiri haa ma baraslayidiri tuba, Taataa goy sliimaa wana haa ana, ana see sliimaa waara haa Taataa goy.” ");
INSERT INTO bds_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Qatlay Wayahuudi giyaa ilii akhasiri gimbakee, gi koisiri kara oowa ina, teesaaqay see, ina gi ba⁄ami dabaiĩ koinaa. ");
INSERT INTO bds_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Da hheꞌesi, Yeesu gi waaudi kara hari kenga gu caduu gu duudu gu Yoridaani. Ina, gi day daqatiray Yohaana giyaa ilii nunqudiidimisiye wakaꞌalee, gi ibiidi yade balalu angaamaka. ");
INSERT INTO bds_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yade, hida wa⁄a gugi ilii hadakayri ina, haa kakaanay tuba, “Yohaana giyaamati yondiidiiba gimba gu bakaꞌasa, gimba goõ gu Yeesu, giyaa gimbuusi guti lou.” ");
INSERT INTO bds_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yade hida wa⁄a gi ⁄imbiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Inkoo, yaa wana heedi waku uma gosi na Lasaaro, ina yaa mama⁄i. Ina yaa yaamulooay gu tongoo da Betaniyaa, tongoo daa ilii ibimaamidiye Mariyaa haa Maarita hhiee kosi. ");
INSERT INTO bds_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyaa na hatira daa maakhadi Looimoo gu Goõ hari du⁄iya da tafu hhoi haa gi busliti yeꞌeeroo kosi hari quubu gosi. Haã hhia gosi Lasaaro naa mama⁄i. ");
INSERT INTO bds_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Teesaaqay, hhiee hhanki gu cada gi ya⁄abiri ya⁄aboo daqa Yeesuge tuba, “Looimoo gu Goõ, daagoogu ga slaꞌade mama⁄i khisla.” ");
INSERT INTO bds_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Qatlay Yeesu giyaa ilii akhasi gimbaki gi kaay tuba, “Ga⁄ayki haraa khayaaba gwaaꞌaraa, yantii ca⁄i sa daareesa Iliitleemu, haa hari amotee Nanku Iliitleemu duguma daareesi.” ");
INSERT INTO bds_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Inkoo, Yeesu yaa slai Maarita haa hhioo dosi Mariyaa haa hhia gooina Lasaaro. ");
INSERT INTO bds_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Teesaaqay see, qatlay Yeesu giyaa ilii akhasi tuba, Lasaaro mama⁄i, Yeesu yaa meeti yade daqa giyaa iliiwane balalu cada. ");
INSERT INTO bds_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Da hheꞌesi, gi kaay sa sirakoomiisee dosi tuba, “Paaree ki⁄anee hhapee da Yudaayage.” ");
INSERT INTO bds_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sirakoomiisee dosi gi kaayri sa ina tuba, “Maarimuu, ti qatlay coko⁄u kilesi gungii catu, Wayahuudi hiĩ slaiyay cakhadiru ugu hari tle⁄eẽ. Inkoo ugu kara slaꞌadaa ki⁄araa yade?” ");
INSERT INTO bds_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu gigi ilaki⁄isi inay tuba, “Inkoo, qatlay gu tleemaa ti mibiibaslii haa cada? Bere heedi khoci hari qatlay gu tleemaa hiitatafidiyaaba, sa gimba ina ariirina cencee da khooroti. ");
INSERT INTO bds_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bere heedi khoci hari qatlay gu amasi hiitatafidi, sa gimba cencee wantaaba waꞌay kosii.” ");
INSERT INTO bds_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbakee, gi ilakoomi gimba sa inay tuba, “Daagoori Lasaaro hiĩ qaati, teesaaqay see, ana hagu hiitlaysakaw.” ");
INSERT INTO bds_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Da hheꞌesi, sirakoomiisee dosi gi kaayri sa ina tuba, “Looimoo gu Goõ, bere ina hinti qaati dugu hhoeesi.” ");
INSERT INTO bds_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Teꞌesii, Yeesu yaati giimaamisi gimba gu gwaaꞌaraa da Lasaaro. Sirakoomiisee dosi yaa caahhiriiba, inay yaati ilatahhiri tuba, ina hiti giimaamisi tuba, Lasaaro hiti gui kilesi. ");
INSERT INTO bds_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Teesaaqay, Yeesu sigigi kaay inay pandataa tuba, “Lasaaro hiĩ hhami. ");
INSERT INTO bds_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ana haã hhaꞌaluudi sa unkuray ambee ana haã waaraaba yade ina giĩ ilii hhami. Sa gimbakee, unkuray hiidahhasiday ⁄imbaraa. Inkoo paaree daqa dosii.” ");
INSERT INTO bds_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Da hheꞌesi, Toomaasi daa eteediidine Irangimoo, gi kaay sa sirakoomiisee deneꞌee kosi tuba, “Dandiray see paaree, ma kaka⁄ukayni sliimaa haa ina.” ");
INSERT INTO bds_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Qatlay Yeesu haa sirakoomiisee dosi giyaa ilii day yade, gi slayri Lasaaro yaa hheꞌesi yaa ibiidi balalu cigahha ayisage. ");
INSERT INTO bds_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Inkoo, tongoo da Betaniyaa yaa ciyoomoo wanta haa yaamu gu Yerusaleemu, segaruũ gu kilomiita tami. ");
INSERT INTO bds_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wayahuudi wa⁄a yaa khayri, ma tlaatlaqasiri Maarita haa Mariyaa, sa gwaaꞌaraa da hhia gooina Lasaaro. ");
INSERT INTO bds_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Qatlay Maarita giyaa ilii akhasidi tuba, Yeesu yaa khoci, gugi amoodabaawa kaydi. Mariyaa gi meti ayage. ");
INSERT INTO bds_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maarita gi kaadi sa Yeesu tuba, “Looimoo gu Goõ, bere hanti wanta tiꞌii, hhia goy hiĩ gwaaiyaaba. ");
INSERT INTO bds_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Inkoo see ana khua ambee, idoo ga firinte daqa Iliitleemuge, Iliitleemu sugu hadisi ugu.” ");
INSERT INTO bds_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeesu gi kaay sa Maarita tuba, “Hhia googi yaa slafi ayisago.” ");
INSERT INTO bds_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maarita gugi ilaki⁄isidi ina tuba, “Ana khua ina maa slafi yaagii ca⁄i ayisago sliimaa haa hida gwaa kaka⁄ee baloo da hiifaakooge.” ");
INSERT INTO bds_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu sagagi kaay ina tuba, “Ana noó slafimisa hida haa sigigi hadimisa slafimaa. Heedi goó ⁄imba ana, gimati gwaai see, ina hiti ibiidi. ");
INSERT INTO bds_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kara, heedi gu koomaa slafimaa, slime hinoó ⁄imba ana, ina gwaaiyaaba koraraa haa koraraa goóba hiifaakoo. Haã ⁄imbidii gimbaki?” ");
INSERT INTO bds_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maarita gi kaadi sa Yeesu tuba, “Ee Looimoo gu Goõ, haã ⁄imbi ambee, ugu na Kristu, Nanku Iliitleemu, gwaa khawa tiꞌii khoorooge.” ");
INSERT INTO bds_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maarita giyaa ilii hheꞌesidi cocoꞌomoo gimbaki, gi eteeda kaydi hhioo dosi Mariyaa, sagagi kaadi tuba, “Maarimuu wana tiꞌii, digi eteedina.” ");
INSERT INTO bds_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyaa giyaa ilii akhasidi gimbakee, gii tlaydi ciraai, gi hadakaydi daqa Yeesuge. ");
INSERT INTO bds_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Inkoo, Yeesu yaa kahhi dawaraa tongoteesiige, ina yaa kahhi daqatiray hingaa ilii slaslayri haa Maarita. ");
INSERT INTO bds_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayahuudi gwaa waaree sliimaa haa Mariyaa waꞌay gu marage gi tlaatlaqamisiyay, gi aniri Mariyaa hingii tlaydi ciraai haa gii ca⁄adi khoorooge. Inay gigi sirakoniri tay ilahudeemisiyay tuba, ina hiti ⁄aa⁄imu kayda ayisage. ");
INSERT INTO bds_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyaa giyaa ilii daadi daqatiray Yeesu giyaa iliiwane haa gugi anti, gii huuꞌudi yeꞌeeroo kosii. Sugugi kaadi tuba, “Looimoo gu Goõ, bere hanti wanta tiꞌii, hhia goy hiĩ hhanaaba.” ");
INSERT INTO bds_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Qatlay Yeesu giyaa ilii arimi Mariyaa ⁄aa⁄ada, slime Wayahuudi gwaa waaree sliimaa haa ina ⁄aa⁄iyay, Yeesu gi arimi slahhaaꞌamee da didiri muuna gosii haa gi li⁄i. ");
INSERT INTO bds_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Da hheꞌesi, gigi maasi tuba, “Haguũ kaale qaasidiri?” Inay sugugi kaayri ina tuba, “Looimoo gu Goõ, khoca arimi.” ");
INSERT INTO bds_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeesu gi ⁄aa⁄i. ");
INSERT INTO bds_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Teesaaqay, Wayahuudi gwaa waaree teꞌesii, gi kaayri tuba, “Yuꞌudiyaa idoo gwaa iliislaiye Lasaaro!” ");
INSERT INTO bds_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Teesaaqay see, wakinay gi kaayri tuba, “Ina gwaa hhoeesu ilaa gu heedi gwaa ilahhamu, yaa hiidahhasiibaslii tlaatlahhasa Lasaaro, ma may gwaaꞌaraa?” ");
INSERT INTO bds_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeesu tay hiĩ kara arimi slahhaaꞌamee da didiri muuna gosii, gi day ayisage. Ayisatee dagaatii khuri maraiyage, dagagi ilakhupisi hari tlaa⁄a da didiri. ");
INSERT INTO bds_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu gi kaay tuba, “Surukusa tlaa⁄atee.” Maarita hhioo dosi hikira gwaa hhamu gi kaadi tuba, “Looimoo gu Goõ, inkoo hiĩ tlaatleesi tli⁄araa, sa gimba kona balalu cigahha ayisage!” ");
INSERT INTO bds_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeesu sagagi kaay tuba, “Inkoo, ana sigiĩ kaaybaslii ambee, bere ha ⁄imbida ha anta wanqamee da Iliitleemu?” ");
INSERT INTO bds_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Teesaaqay, inay gi surukusiri tlaa⁄atira ayisago. Teꞌesii, Yeesu gi waratlaysi ilaa kosi rawaage gi kaay tuba, “Taataa, ⁄iisoo sa gimba haniĩ akhasidi. ");
INSERT INTO bds_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ana haa caahhi ambee, ugu hanoó akhamisida ana balalu sliimaa. Inkoo ana hanti kaay gimbaki, sa raqati da hida diĩ qadimiti tiꞌii, inay ma ⁄imbiri tuba, ugu naa ana ya⁄abidi.” ");
INSERT INTO bds_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yeesu giyaa ilii hheꞌesi cocoꞌomoo gimbaki, gi eteedi hari afoo da didiri tuba, “Lasaaro, ca⁄aayu tay khoorooge!” ");
INSERT INTO bds_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasaaro, hiĩ gwaa gwaau yaagii ca⁄i khoorooge, tay dabaiĩ haa yeꞌeeroo kosi digiĩ khiidimi hari qayru gu hhou gu ⁄abaaku. Kara pandaa dosi dagaã khiidimi hari dahhamu gu ⁄abaaku. Yeesu sigigi kaay inay tuba, “Gweedakuna ma waaudi.” ");
INSERT INTO bds_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Teesaaqay, Wayahuudi wa⁄a tla⁄aã gu hhakiray gwaa khawee sa tlaatlaqamisu Mariyaa, giyaa ilii aniri gimba Yeesu giyaa yondiidi, inay gugi ⁄imbiri. ");
INSERT INTO bds_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Teesaaqay see, wakinay tla⁄aã gooinaa gi hadakayri daqa Farisaayooge, haa sigigi kaayri gimba diĩ yondiidi ha Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Da hheꞌesi, hhapalooee da deni haa Farisaayoo gi eteediri hiikurunkurida da balasaa da didiri. Teꞌesii, hingigi maamisiri inay haa inay tuba, “Inkoo hati malee laqana? Heediki yondimaamidi gimba wa⁄a gu bakaꞌasa. ");
INSERT INTO bds_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bere hagu mayna ina ma ilakoomi yondu taqay, hida goõ gu ⁄imbiyay ina. Da hheꞌesi, Waruumi yaa khayay gi hhamisiyay mara goori gu didiru gu Iliitleemu haa hhapee doori.” ");
INSERT INTO bds_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Teꞌesii, leẽ tla⁄aã gooinay daa eteediidine na Kayaafa, gwaa hhapalooay gu didiru korikee, gi kaay tuba, “Unkuray ha hhidintay idoo lensee! ");
INSERT INTO bds_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Unkuray hhidintaaii tuba, daraatii boo⁄i daqa doogunay heedi leẽ gwaaꞌaraa sa hida, ba⁄ay da hhamisaraa hhapee goõ?” ");
INSERT INTO bds_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Inkoo, Kayaafa yaati gimbuusiiba gimbaki hari ilahudaa kosi ina loi. Ina hhapalooay gu didiru gooay korikee, yaa tletimi tuba, Yeesu hiti gwaai sa hhapee da Wayahuudi. ");
INSERT INTO bds_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kara ina hiti gwaaiyaaba sa Wayahuudi kilesi, slime ti sa yaꞌay goõ gu Iliitleemu gwaa pasidee, ma higiraa khay goõ daqa lenge. ");
INSERT INTO bds_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Teesaaqay, tlaatleesoo da baloteesaago, giyaadimiisee da Wayahuudi yaa tlaatleesiri ilakhuukhuꞌumisu, ma gaasiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sa gimbakee, Yeesu yaa khookhocimiiba kara pandataa tla⁄aã gu Wayahuudige. Ina hingaati pasli haa inay haa gi waaudi daqa wakay daa ilaciyaa haa kongoqomee, tongoo doó eteedine na Efurayiimu. Ina gi ibiidi taysi sliimaa haa sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Inkoo, losona gu Pasaaka gu Wayahuudi yaa daadaauusi. Hida wa⁄a tongagugo gii laabiri hadakawa Yerusaleemuge baloo da losona giyaa ilii kahhade, ma hingi ilabuusliri ou gooinay. ");
INSERT INTO bds_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inay yaa damaamidiyay Yeesu. Qatlay giyaa ilii qadimidiri mara gu didiruge gu Iliitleemu, hingaa maamisiri tuba, “Haã malee antiri? Gu lou, heediki yaa khayaabaslii losonage?” ");
INSERT INTO bds_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Inkoo, hhapalooee da deni da Wayahuudi haa Farisaayoo yaa hadisiri ilakaawa tuba, bere heedi baraslayi Yeesu daqa gi iliiwane, kwanda gi kaayiye, magu ooyiri. ");
INSERT INTO bds_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balalu lahhoꞌo giyaa ilii kahhiyee sa dawaraa losona gu Pasaaka, Yeesu gi day tongoo da Betaniyaage, daqa daa ilii ibimaamidiye Lasaaro gwaa gwaau, hiĩ daa slafisi ha Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Taysi hida wakinay gii tihhisiri ⁄agoo da khwayaiĩ sa Yeesu, Maarita gii satimisidi sa ina. Leẽ gu heedi gwaa ibiidu sliimaa haa Yeesu sa ⁄agoo yaati Lasaaro. ");
INSERT INTO bds_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Da hheꞌesi, Mariyaa gii oodi nusuu gu liita da du⁄iya da beyii dihhi. Ina gi maakhadi yeꞌeeroo gu Yeesu haa gi buuslidi hari quubu gu saga gosi. Du⁄iyatee dagaati boo⁄imisi hari humbalaalay doó narido eteedine da kooma tafu gu hhou. Mara goõ gii qoomi tafu gu du⁄iyatee. ");
INSERT INTO bds_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Inkoo, Yuuda Isikariyooti, leẽ gu sirakoomiisee dosi, hiĩ namaa hiifookidi Yeesu gugii lu⁄i dabaiĩ gu fa⁄ayaage, gi kaay tuba, ");
INSERT INTO bds_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Du⁄iyati dagaã soꞌoyi may naadiru hari peesay dinaari miyaa tami, peesaykee dugugi hadimisi sa iliiawaraa kwaeeli?” ");
INSERT INTO bds_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuuda yaati teesaaqay kaayiiba, sa gimba yaati ⁄awaarimi sa kwaeeli. Ina yaati kaay teesaaqay, sa gimba ina yaati fiisiisay. Ina naa qamaamidi peesay, haa yaatii oyimiimina waa wa⁄a peesay daa hiislaslaaslakhiye kitangeeriyateesii. ");
INSERT INTO bds_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeesu gi kaay sa inay tuba, “Maw ilahufidu hadeti. Ina hintii tuutuqudi du⁄iyatee da kooma tafu gu hhou sa baloo da qaasaraa tuuꞌuna dooi. ");
INSERT INTO bds_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yuꞌudaa, kwaeeli yoó sliimaa wanay haa unkuray balalu sliimaa. Teesaaqay see, ana waaraaba sliimaa haa unkuray balalu sliimaa.” ");
INSERT INTO bds_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Inkoo, raqa da didiri da Wayahuudi gi caahhadi tuba, Yeesu tongoo da Betaniyaage wana. Raqatee yaati hadakaydi taysi, ti sa arimaa da Yeesu kilesiiba, slime ti sa arimaa da Lasaaro, daa slafisi ha Yeesu gwaaꞌaraago. ");
INSERT INTO bds_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Teesaaqay, hhapalooee da deni gi ilakhuukhuꞌusiri gaasa Lasaaro see slime. ");
INSERT INTO bds_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Sa gimba gu Lasaaro, Wayahuudi wa⁄a hingaa tlintiꞌisidi haa giyaadimiisee dooina, gi ⁄imbiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Heetlaalee dosi, raqa da didiri da hida daa khaydi losona gu Pasaakage, gi akhasidi tuba, Yeesu amooge wana, yaa khakhaakhay yaamu gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Da hheꞌesi, inay gii oyiri elemu gu khai doó tende oine, gii ca⁄iri sa amoodabaawa kawa Yeesu. Inay gi maahhiri kakaanay tuba, “Iliitleemu dugu hhaꞌaleesiye! Duguũ ⁄aafi ina gwaa khawa hari uma gu Taataa Iliitleemu! Dugu ⁄aafiye, Mutemi gu Israeeli!” ");
INSERT INTO bds_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeesu yaa slay daqumoo leẽ, gugi ilii day, idoo daa ilii handikimi gooay tuba, ");
INSERT INTO bds_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Hhanti tlaꞌamutay, ye hida gu yaamu gu Sayuuni. Yuꞌudiyaa! Mutemi googuna yaa khoci, yaanii day rawaa gu daqumooge!” ");
INSERT INTO bds_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sirakoomiisee dosi Yeesu tlaatleesoogo yaa caahhiriiba gimbaki. Qariqaaqari giyaati caahhiri, Yeesu giyaa ilii waaudi rawaa gu rawge. Teꞌesii, inay yaa hiislayri tuba, gimbaki dugwaati handikimi sa ina, haa hida yaa teesaaqay yondiidiri daqa dosii. ");
INSERT INTO bds_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Inkoo, raqa da hida hhakira gwaa sliimaa waaree haa Yeesu, qatlay giyaa ilii eteedi Lasaaro waꞌay gu ayisago haa gwaagi slafisi, inay yaa ilatlawa kayri gimbakee. ");
INSERT INTO bds_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa gimbakee, hida wa⁄a gugi amoo dabaawakayri. Inay yaa akhasiri tuba, Yeesu yaa yondiidi gimbakee gu kaaru gu bakaꞌasa. ");
INSERT INTO bds_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Teesaaqay, Farisaayoo hingigi wariikaayri inay haa inay tuba, “Yuꞌudaa! Dandiray hiidahhasanaaba idoo lensee. Hida sliimaa guti sirakomaamidiyay Ina!” ");
INSERT INTO bds_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Teꞌesii yaa wanay Wayunaani angaamaka tla⁄aã gu hida gwaa dawee Yerusaleemuge sa firoo qatlay gu losonakeesii. ");
INSERT INTO bds_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inay yaa ilii hadakayri Filiipo, yaamulooay gu yaamu gu Betisayda da hhapee da Galilaayage waara, gi kaayri tuba, “Hiiye, dandiray slaꞌana arimaa Yeesu.” ");
INSERT INTO bds_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filiipo gi kaawa kay sa Andareyaa. Da hheꞌesi, inay cada koinaa gi kaawa kayri sa Yeesu idoo daa kaay ha Wayunaanitee. ");
INSERT INTO bds_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeesu gigi ilaki⁄isi inay tuba, “Qatlay gu daareesaraa Nanku Heedi hiĩ buꞌudi. ");
INSERT INTO bds_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gu lou, sangu kaay unkuray ambee, pisagariya da ganoo, bere dabasli huua hhapeege haa gi gwaꞌata, meta nama pisagariya da ganoo kilesi. Bere pisagariya hiĩ gwaꞌati laqwalida ⁄aamu wa⁄a. ");
INSERT INTO bds_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gu lou, heedikaꞌa gu slaꞌa ibinaa dosi, hikee higimaa hhamisi. Kara, heedikaꞌa gu waka ibinaa dosi sa ana khoorotii, higimaa ilabuꞌuna ibinaa dosi da koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bere heedi hiti slai yondiida sa ana, kwanda hini sirakone. Daqa ga iliiwaare ana, yondimiisay goy see ginimaa ilii wana. Heedi gu yondimaamida sa ana, sugumaa hadisi muree ha Taataa goy. ");
INSERT INTO bds_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Inkoo, muuna goy hinti bahhangaruusi. Ana taysa hati mala kaawaa see. Firima Taataa, hinima ilabuꞌumi daqa gimbakaꞌa gwaa khoca qatlaykii? Suti! Ana hanti khay sa gimbakee da yondiidiye qatlaykii. ");
INSERT INTO bds_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taataa, daareesi uma googu!” Teꞌesii, daagii ca⁄i afoo rawaa gu rawgo, kakanta tuba, “Haguũ daareesi, haa hagu kara daareesa.” ");
INSERT INTO bds_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Inkoo, raqa da hida daa qaditi teꞌesii haa gwaa akhasee afotee, gi kaadi tuba, “Hatee ti afoo da gwaasla⁄aa!” Hida angaamaka raqateesaa gi kaayri tuba, “Ti malayika niĩ cocaacoi haa ina!” ");
INSERT INTO bds_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeesu gi kaay sa inay tuba, “Afotee yantii ca⁄adiiba sa faydaa dooi, ti sa faydaa dooguna. ");
INSERT INTO bds_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Inkoo, ti qatlay gu hukumuu gu khooroti. Iliitleemu gu hiilihhi segenge Sataanimoki gu tawaaliilima khooroti. ");
INSERT INTO bds_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ana dinimaa ilii tlaysiye rawaage, hida sliimaa hagimaa hiidafida, maa khayri daqa dooii.” ");
INSERT INTO bds_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yeesu yaa kaay teesaaqay, ma laqami, idoo dugumaa ilii gaasiye. ");
INSERT INTO bds_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Raqatee da hida gi ilaki⁄isidi Yeesu tuba, “Dandiray hanti akhasani sariyaa dooraa tuba, Kristu ti ibiidi koraraa haa koraraa goóba hiifaakoo. Inkoo, ugu malee hiidahhasida kaawa tuba, Nanku Heedi kwanda dugu hiitlaysiye rawaage? ‘Nakee gu Heedi’ ti miyaa?” ");
INSERT INTO bds_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Da hheꞌesi, Yeesu gi kaay sa raqatee tuba, “Cencee kahhada sliimaa wanta haa unkuray qatlay coko⁄u. Unkuray khookhocima, tay toogunaa kontay cencetee, danguma may kaba⁄a ha hhantee. Heedi goó khookhocima hhanteege, hhidina daqa gi kakaakaye. ");
INSERT INTO bds_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Inkoo, ⁄imba qatlay ga iliiwante haa cencetee, ma hida gu cencee tleehhitiri.” Qatlay giyaa ilii hheꞌesi kaawa gimbakee, Yeesu gi waaudi, hingigi yakwakay segenge, duguma may arimaa ha raqatee. ");
INSERT INTO bds_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeesu yaa yondiidi gimba wa⁄a gu bakaꞌasa hari ⁄uuru gu Iliitleemu pandaa dooinay, inay gwaa ⁄imbiriiba. ");
INSERT INTO bds_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Teesaaqay, daatii gaasi gimba daa kaay tletimiisay Isaaya tuba, “Taataa Iliitleemu, miyaa naa ⁄imbi ya⁄aboo doori? Kara, miyaa sugunaay tlaaꞌasi ⁄uuru googu?” ");
INSERT INTO bds_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Teesaaqay, raqatee yaa hiidahhasidiiba ⁄imbaraa, sa gimba Isaaya bere kaay tuba, ");
INSERT INTO bds_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Iliitleemu hiĩ guumuuꞌudisi ilaa koina, ma mayri arimaa, kara, hiĩ ⁄isimi muunaiĩ koina, ma karaarahhiri. Haã teesaaqay yondiidi, ma mayri hiifookida daqa dooii, magi hhoeesi.” ");
INSERT INTO bds_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaaya yaa kaay gimbaki, sa gimba yaa arimi wanqamee da Yeesu, kara gi gimbuusi gimba gosi Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Teesaaqay see, giyaadimiisee wa⁄a da Wayahuudi yaa ⁄imbidi Yeesu. Inkoo, sa gimba gu Farisaayoo, inay yaa ⁄imbiriiba Yeesu pandaa da hidage. Inay yaa tlaꞌamuumuudiri tuba, digi gusina sinagoogigo. ");
INSERT INTO bds_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Caahha tuba, inay yaa slaiyay digima hhaꞌaleesi ha hida ba⁄ay da slawaraa hhaꞌaleesa da daqa Iliitleemu dahha. ");
INSERT INTO bds_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Da hheꞌesi, Yeesu gi maahhi hari afoo da didiri tuba, “Heedi gunoó ⁄imba, slime yoóti ⁄imbi hikira gunaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Heedi gunoó arima ana, slime goóti arina hikira gunaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ana hanti khay khoorotii cencee pahha, kila heedi gu ⁄imba ana, ma hhanti meeti hhanteege. ");
INSERT INTO bds_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Heedi gu akhaakhamisa gimba gooi, gugi may oowaraa, ana hagu hukumaaba. Ana haati khayiiba khoorotii sa hukuruu hida, haati khay sa ilabuꞌuru inay. ");
INSERT INTO bds_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hakimuu wana sa heedi guni sisaasia haa gooba ⁄imba gimba gooi. Gimba loi ga gimaamise, namaa hukuna ina baloo da hiifaakooge. ");
INSERT INTO bds_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sa gimba, ana haati kakaakamaaba gimbaki ana lenkway, ti Taataa gunaa ya⁄abu ana, ninaa ilafahhi, mala gani kaawa haa idoo ga ilii kaawe. ");
INSERT INTO bds_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ana khua tuba, ilakaawa dosi ti slafimaa gu koraraa haa koraraa goóba hiifaakoo. Inkoo, gimba ga kakaakame ana, ti hikaꞌa kilesi sinaa kaay ha Taataa, magu kakaami.” ");
INSERT INTO bds_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Inkoo, baloo leẽ giyaa ilii meti sa buꞌudaraa da losona gu Pasaaka, Yeesu yaa khui tuba, qatlay gosi gu waaudimoo daqa Taataa gosi tiaa khoorotaa hiĩ day. Ina giyaa slai hida kosi gu khoorotii waaree, haa sigigi laqami slaꞌamuu kosi hiifaakoo naqatloo. ");
INSERT INTO bds_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Qatlay Yeesu haa sirakoomiisee dosi giyaa ilii ⁄agiiginee ⁄agoo da khwayaiĩ, Biriisimoo yaa hheꞌesi yaa hiifaafahhi Yuuda, nanku Simooni Isikariyooti, muuna gu hiifookida Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu yaa khui tuba, Taataa gosi yaa taatahhi idadu goõ dabaiĩ kosii. Slime, ina yaa khui tuba, yaa daqa Iliitleemu dahhi haa yaati kikaaki⁄i daqa Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Teesaaqay, Yeesu yaay tlay ⁄agoogo, gi baci kooti dosi haa hingigi tosaa ilakhiidi khiringe dahhamu guri buslidu. ");
INSERT INTO bds_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Da hheꞌesi, gii eesi maꞌay dahhange, gi tlaatleesi hhuncindaa yeꞌeeroo gu sirakoomiisee dosi, haa gigi buslidi hari dahhamukira giyaa ilakhiidi khiringe. ");
INSERT INTO bds_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Inkoo, Yeesu gi day daqa Simooni Peetiro, Peetiro gugi maasi ina tuba, “Looimoo gu Goõ, ugu hati hhuncidaa yeꞌeeroo koi?” ");
INSERT INTO bds_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu gugi ilaki⁄isi ina tuba, “Inkoo, ugu hhidinta idoo ga yondimaamide, teesaaqay see, qariqaaqari hacaahhada.” ");
INSERT INTO bds_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peetiro gi kaay sa ina tuba, “Suti, ugu hhuncidaaba yeꞌeeroo koi coko⁄o see!” Yeesu gugi ilaki⁄isi ina tuba, “Bere ana hhuncaaba yeꞌeeroo koku, ugu kontaaba ilagaasa haa ana.” ");
INSERT INTO bds_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Da hheꞌesi Simooni Peetiro gi kaay tuba, “Looimoo gu Goõ, hhanti hhuncida yeꞌeeroo koi kilesi, slime hhunci dabaiĩ koi haa saga gooi!” ");
INSERT INTO bds_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeesu gi kaay sa inay tuba, “Heedi guũ hheꞌesu hhuncidaa slaqwa sliimaa, yoóti slai kilesi hhuncidaa yeꞌeeroo, sa gimba slaqwa dosi goõ hiĩ ilabuꞌuti. Unkuray see haã ilabuꞌutiri muunainge, gimati gonkokunaa gooba.” ");
INSERT INTO bds_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Caahha tuba, Yeesu gwaa khui heedi gu hiifookida ina, saganaa kaay tuba, “Unkuray haã ilabuꞌutiri, gimati gonkokunaa gooba.” ");
INSERT INTO bds_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeesu giyaa ilii hheꞌesi hhuncidaa yeꞌeeroo gu sirakoomiisee dosi, gi daasi kooti dosi, gi ibiidi daqa giyaa iliiwane. Da hheꞌesi, gigi maasi tuba, “Haã caahhadiri gimbakee gaã yondiidi sa unkuray? ");
INSERT INTO bds_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Unkuray naeteedintay ana ‘Maarimuu’ haa ‘Looimoo gu Goõ.’ Gimbaki guti louu, sa gimba teesaaqay hagani iliiwaara. ");
INSERT INTO bds_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Inkoo, bere ana, Looimoo googuna haa Maarimuu googuna, hanguu hhunci unkuray yeꞌeeroo kokuna, slime unkuray see hanguraa hiiboo⁄odiri hhuncidaa yeꞌeeroo unkuray haa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ana sanguu laqami unkuray ilaꞌaaꞌaatisa, yondiida nama teesaaqay gooay gaã ilii yondiidi sa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gu lou, sangu kaay, tongimoo guti didiruuba ba⁄ay da looimoo gosi. Kara, ma ya⁄abimiisay see guti didiruuba daqa hikee gwaa ya⁄abu ina. ");
INSERT INTO bds_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Inkoo, sa gimba unkuray khuꞌuday gimbakee guti lou haa hagugi yonditay, dangu ⁄aafi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Gimbaki gaã kaay, gunti kaayiiba sa unkuray gonkokunaa. Ana hagi khua hida hhakaꞌa gaa hiileehhi. Teesaaqay see, kwanda dagay gaasiye Handikaa da Iliitleemu, doó kaawa tuba, ‘Hikaꞌa guũ ⁄agimu sliimaa haa ana, ningii fookidi ana.’ ");
INSERT INTO bds_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inkoo, ana sangu kaawa unkuray gimbaki gi ilii kahhiye hiica⁄a, gimaa iliica⁄iye, unkuray ma ⁄imbidiri tuba, ana na ina hikira daa hiileehhi. ");
INSERT INTO bds_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gu lou, gu lou sangu kaay, heedikaꞌa gu kwahhasuusa hikee gwaani ya⁄abi, hikee ana gini kwahhasuusi. Kara hikee gu kwahhasuusa ana, ina hiti kwahhasuusi Iliitleemu, gwaa ya⁄abu ana.” ");
INSERT INTO bds_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeesu giyaa ilii hheꞌesi kaawaraa gimbakee, yaa bahhangaruusi hari khisla muuna gosi, gi kaay pandataa tuba, “Gu lou, gu lou, sangu kaay leẽ tla⁄aã googunay hiniĩ fookidi ana!” ");
INSERT INTO bds_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sirakoomiisee dosi hingigi yuꞌudiri inay haa inay, tay konay tlaꞌamee, caahharaa see guba, Yeesu miyaa guniĩ kaay. ");
INSERT INTO bds_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Leẽ gu sirakoomiisee dosi, hiĩ daa slaiye hari khisla ha Yeesu, yaati ibiidi ilaciyaa gu Yeesuge. ");
INSERT INTO bds_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simooni Peetiro gi waratlay daba gosi sa sirakoomiisaykee, ma maasi Yeesu, ti miyaa guni giimaamisi. ");
INSERT INTO bds_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sirakoomiisaykee tay hiĩ iladici daqa Yeesuge, gugi maasi tuba, “Looimoo gu Goõ, ti miyaa?” ");
INSERT INTO bds_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu gi kaay tuba, “Ti hikaꞌa soo hadise fandakumiyati da mukaatimoo goo hiitika⁄e dabacuge, na ina.” Da hheꞌesi, gii oyi fandakumiya da mukaatimoo, gigii tika⁄i dabacuge, gigi hadisi sa Yuuda, nanku Simooni Isikariyooti. ");
INSERT INTO bds_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuuda giyaa ilii ooyi fandakumiyatee da mukaatimoo, cirakiray Sataanimoo gugi ilii guumi. Yeesu gi kaay sa Yuuda tuba, “Idoo ga slaꞌade laqa, laqaka ciraai!” ");
INSERT INTO bds_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Teꞌesii tla⁄aã gu sirakoomiisee daa ⁄agiigima, hhaku lensee gwaa caahhu Yeesu yaa soꞌoyi kaay sa Yuuda teesaaqay. ");
INSERT INTO bds_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Caahha tuba, Yuuda yaa qamaamidi peesay, teesaaqay sirakoomiisee wakinay yaati ilahudeesiri tuba, Yeesu yaati kaay sa Yuuda kirigiye idadu daa slaiye sa losona, baku dugwaati ya⁄abi hadisakaye idadu sa kwaeeli. ");
INSERT INTO bds_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuuda giyaa ilii ooyi fandakumiyatee da mukaatee, cirakiray gii ca⁄i khoorooge. Qatlaykee yaati amasi. ");
INSERT INTO bds_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Qariqaaqari, Yuuda giyaa ilii waaudi, Yeesu gi kaay tuba, “Inkoo, Nanku Heedi duguũ daareesi, slime Iliitleemu duguũ daareesi hari amoo dosi. ");
INSERT INTO bds_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bere Iliitleemu duguũ daareesi hari amoo da Nanku Heedi, slime Iliitleemu see daareesi Nankosi waꞌay kosii ina lenkosi, kara ina gu hiikaaiyaaba daareesaraa.” ");
INSERT INTO bds_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yeesu gi kaay tuba, “Yaꞌay koi, ana hati kahha waara sliimaa haa unkuray qatlay coko⁄oniinii kilesi. Qariqaaqari hanimaa dabitay. Idoo gaa ilii kaay gooay sa Wayahuudi, unkuray see sangu kaawa ambee, ‘Daqa ga kakaakawe ana, unkuray hiidahhasidaaiiba dawaraa.’ ");
INSERT INTO bds_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ana sangu hadisa ilakaawa da ⁄abi. Hangu slaꞌaaslaꞌadee unkuray haa unkuray, idoo hangwaa ilii slai gooay, nama teesaaqay unkuray see hangu slaꞌaaslaꞌadee. ");
INSERT INTO bds_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bere unkuray hangu slaꞌaaslaꞌaday, hida sliimaa caahhiyay tuba, unkuray ti sirakoomiisee doyi, bere unkuray hangu slaꞌaaslaꞌaday.” ");
INSERT INTO bds_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simooni Peetiro gi maasi Yeesu tuba, “Looimoo gu Goõ, hati kaakaakayda?” Yeesu gugi ilaki⁄isi tuba, “Daqa ga kakaakawe inkoo, hanii dahhasidaaba sirakooma ugu. Teesaaqay see, qariqaaqari hanimaa sirakonta.” ");
INSERT INTO bds_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peetiro gugi maasi Yeesu tuba, “Looimoo gu Goõ, hagu soꞌoyi hiidahhasaaba sirakooma inkoo? Ana gwaaꞌaraa see ha gwaaꞌa sa ugu!” ");
INSERT INTO bds_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu gi ilaki⁄isi tuba, “Gu lou, ugu hanguu ilakhuukhuꞌusidi gwaaꞌaraa sa ana? Ana sugu kaawa, konkaku gi ilii kahhiye ceearaa, hanoo hiifookita waa tami.” ");
INSERT INTO bds_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeesu gi ilakoomi gimba tuba, “Hhanti bahhangaruusidayi muunaiĩ kokunay. Unkuray ⁄imba Iliitleemu, slime hani ⁄imbidee ana. ");
INSERT INTO bds_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ana hati waauda, sangu ilakhuukhuꞌusakaw daqa sa unkuray. Mara gu Taataa gooii ibinaa ti wa⁄a. Bere ibinatee yaa aloo hhaka, sangwaa kaawa. ");
INSERT INTO bds_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ana goo ilii waauude haa sangugi ilakhuukhuꞌusa daqa, hamaa ki⁄a kara manguri waaudi unkuray, daqa goó ilii ibiide ana, unkuray see ibitay. ");
INSERT INTO bds_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Unkuray ha khuꞌuday amoo dari dawaraa daqa ga kawe.” ");
INSERT INTO bds_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaasi gi maasi Yeesu tuba, “Looimoo gu Goõ, dandiray hhidina daqa ga kayde, amotee haga malee hiidahhasa caahharaa?” ");
INSERT INTO bds_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu sugugi kaay tuba, “Ana na amoo, ana na gu lou, haa ana na slafimaa. Heedi hiidahhasiyaa dawaraa daqa Taataage, bere hiicatiyaaba hari daqa dooi. ");
INSERT INTO bds_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bere gu lou hanii aloo caahhaday ana, slime haguũ aloo caahhaday Taataa goy see. Tlaatleesa da inkoo, Taataa goy gu khuꞌuday, kara guũ arintiri.” ");
INSERT INTO bds_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filiipo gi kaay tuba, “Looimoo gu Goõ, sandi laqante Taataa, dandiray buꞌudisana.” ");
INSERT INTO bds_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu gi kaay tuba, “Filiipo, ana haã ibiidi sliimaa haa unkuray balalu hhanki goõ, ugu kahhadaa haniti hhidintaa? Heedi gwaa arimu ana, Taataa giniĩ arimi. Inkoo, malee kaada ubee, ‘Sandi laqante Taataa?’ ");
INSERT INTO bds_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ugu haã ⁄imbidaabaslii tuba, ana sliimaa waara haa Taataa, Taataa see sliimaa wana haa ana? Gimba sangu kakaakaame ti kooiiba, ti gimba gu Taataa goó ibiida sliimaa haa ana. Ina yondimaamidi yonduki kosi hari amoo dooi. ");
INSERT INTO bds_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Unkuray hani ⁄imbidee ana qatlay ga ilii kakaakame tuba, ana sliimaa waara haa Taataa, Taataa see sliimaa wana haa ana. Bere hani ⁄imbidaaiiba ana, ⁄imba sa gimba gu yondu gu bakaꞌasa gaa yondiidi. ");
INSERT INTO bds_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gu lou, sangu kaay, heedi gunoó ⁄imba ana, ina see yondiidi yondu ga yondimaamide ana. Kara, ina hiti yondiidi yondu gu didiru ba⁄ay da hiĩ see, sa gimba hati waauda daqa Taataage. ");
INSERT INTO bds_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Unkuray idoo lensee ga firintee hari uma gooi, haga yondiida, Taataa duguma daareesi hari amoo da Nankosi. ");
INSERT INTO bds_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Firima idoo lensee hari uma goy, haga yondiida.” ");
INSERT INTO bds_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yeesu gi ilakoomi gimba tuba, “Bere hani slaꞌaday ana, iliikontay ilakaawa doyi. ");
INSERT INTO bds_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ana firima Taataa, ina sangwaa ya⁄abi Iliiaymiisay waku gu ibiida haa unkuray koraraa haa koraraa goóba hiifaakoo. ");
INSERT INTO bds_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hikee na Muuna gu lou gu laqaaqama sa hida idoo Iliitleemu gi iliiwane. Hida gu khooroti gwii dahhasiyaaiiba ⁄imba, sa gimba etaa gu arinaaiiba kara guti hhidinay. Unkuray gu khuꞌuday, sa gimba ina sliimaa wana haa unkuray haa ti kooguna tleehhidi muunainge. ");
INSERT INTO bds_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ana hangu mawaaba unkuray kilakokuna makeebee pahha, haa khaw daqa doogunay. ");
INSERT INTO bds_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kahhi qatlay coko⁄oniinii, hida gu khooroti hinimaa kara anaaiiba, teesaaqay see unkuray hanimaa antayi. Ana ti slafa, haa sa gimbakee unkuray see slafiday. ");
INSERT INTO bds_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Qatlaykee, hamaa caahhaday tuba, ana sliimaa waara haa Taataa, kara unkuray sliimaa wantay haa ana, slime ana sliimaa waara haa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Heedi gu ⁄imba ilakaawa doyi haa gigi ooyi, hikee na slai ana. Hikee gu slaꞌa ana, dugu slai ha Taataa goy, slime ana see hagu slaꞌa, kara hangutii ca⁄asa daqa dosii.” ");
INSERT INTO bds_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuuda (Isikariyooti gooba) gi maasi Yeesu tuba, “Looimoo gu Goõ, ugu hangu soꞌoyi laqanta daqa doorii kilesii, hangugi mayda laqaru daqa hida gu khoorotii?” ");
INSERT INTO bds_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu gi kaay sa ina tuba, “Bere heedi hini slai ana, ina ooyi gimba gooi. Taataa gooi gu slai ina, kara dandiray haa khayna daqa dosii gi ibiidana haa ina. ");
INSERT INTO bds_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Heedi goóba slaꞌamuu ana, ooyiyaaba gimba gooi. Kara, gimba gaa akhasidiri ti kooiiba, guti Taataa gwaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ana sanguti kaay unkuray gimbaki, ana ga ilii kahhe sliimaa waara haa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Iliitleemu himaa ya⁄abi hari uma goy Iliiaymiisay daqa doogunay, ti Muuna gosi. Muunakee kosi hangu caacaahhamisi gimba sliimaa, haa sanguu slay gimba sliimaa sangwaa kaay ana. ");
INSERT INTO bds_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ana sangu maw qasaw, qasaw gooi sangu hadisa unkuray. Qasawkee ti hikaꞌa pahhaaba da hadiidimisiye ha hida gu khooroti. Teesaaqay, hhanti bahhangaruusidayi ma tlaꞌamee see hhanti kontay. ");
INSERT INTO bds_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Unkuray haa akhasidiri, idoo sangwaa ilii kaay ambee, ‘Ana waauda, da hheꞌesi haa kara ki⁄a daqa doogunay.’ Bere gu lou, hanaati aloo slaꞌaday, hanti aloo hhaꞌaluumitay tuba, ana ti daqa Taataa kakaakaw, sa gimba hiĩ gunaa ya⁄abu gu didiri ba⁄ay da ana. ");
INSERT INTO bds_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ana sanguti kakaakama gimbaki inkoo, giyaa ilii kahhiye hiica⁄a, gimaa iliica⁄iye unkuray, magu ⁄imbidiri. ");
INSERT INTO bds_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ana gimbuusaaba kara gimba wa⁄a haa unkuray, sa gimba Sataanimoo gu tawaalima khooroti yaa khoci. Ina konaaba ⁄uuru daqa dooii. ");
INSERT INTO bds_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ana yondiida, idoo dinaa ilii ya⁄abi gooay haa ina, hida gu khooroti caahhiyee tuba, Taataa hagu slaꞌa. Inkoo, qadimida, waaudanee tiaa.” ");
INSERT INTO bds_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeesu gi ilakoomi gimba sa sirakoomiisee dosi tuba, “Ana na musabiibu gu lou, Taataa goy na dooslimiisay. ");
INSERT INTO bds_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila eleema waꞌay koii doóba ⁄aamuuda ⁄aamu, Taataa goy giyoóti tlatlafi. Kila eleema doó ⁄aamuuda, giyoóti ilanai, ma ⁄aamuti hari khisla. ");
INSERT INTO bds_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Unkuray elemu pahha, dangwaa ilanai ha caacaahhamisu hangwaa caacaahhamisi. ");
INSERT INTO bds_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Unkuray ibiida ilagaasaraage haa ana, ana see ibiida ilagaasaraage haa unkuray. Eleema ⁄aamutaaba ina lenkosi, bere hingaa ilanuunuꞌusidiiba haa musabiibu. Unkuray see, nama teesaaqay ha ⁄aamutaaiiba bere hanguba ilagaasa haa ana. ");
INSERT INTO bds_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Inkoo, ana ti musabiibu, unkuray ti elemu. Heedi gungu ilagaasa haa ana, slime ana see hangugi ilagaasa haa ina, hikee ⁄aamuudi ⁄aamu wa⁄a. Bere ana hhaku sliimaa haa unkuray hiidahhasidaaiiba yondu lensee. ");
INSERT INTO bds_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Heedi gungubasli ilagaasa haa ana, ina ti eleema daa tlaaqi pahha gi kaadi. Elemu da hhakee gooay, digitii kurunkuri haa digigii kwahhi aslaage. ");
INSERT INTO bds_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bere unkuray hangu ilagaasiday haa ana, haa gimba gooi gi ibiidi muunaiĩ kokunay, firima idoo ga slaꞌadee, sangu yondiidi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hari amoti, Taataa goy dugu daareesi, unkuray goó ilii ⁄aamutee ⁄aamu wa⁄a, gi laqantay tuba, unkuray ti sirakoomiisee doyi. ");
INSERT INTO bds_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Idoo Taataa goy gooay hinaa ilii slai, ana see hangunaa ilii slai unkuray. Ilakooma ibinaa slaꞌamuu hhakeesii koi. ");
INSERT INTO bds_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bere iliikontay ilakaawa doyi, ha ibitay slaꞌamuu gooii, ana gooay idoo gaa ilii ilakoomi ilakaawa da Taataa goy haa gi ibiidi slaꞌamuu kosii. ");
INSERT INTO bds_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ana sanguuti kaay gimbaki, hhaꞌaloo doyi ma ibiti waꞌay kokunay, haa hhaꞌaloo dooguna ma buꞌuti. ");
INSERT INTO bds_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ilakaawa dooi na nahaã, hangu slaꞌaaslaꞌadee unkuray haa unkuray, idoo ana gooay hangwaa ilii slai unkuray. ");
INSERT INTO bds_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Slaꞌamuu gu didiru ba⁄ay da slaꞌamuu goõ na nahiĩ gooay, heedi hadisa ibinaa dosi sa daakeeri kosi. ");
INSERT INTO bds_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Inkoo, bere unkuray hoó iliikontay ilakaawa doyi, daakeeri koi tleehhitay. ");
INSERT INTO bds_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Unkuray hangu kara eteedaaba tongee, sa gimba tongimoo hhidina yondu doó yondiidiye ha looay gosi. Inkoo, unkuray hanguti eteedima daakeeri, sa gimba sanguu kaay gimba goõ gaa akhasi daqa Taataa gooaa. ");
INSERT INTO bds_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Unkuray hanay leehhediriiba ana, ti ana nangwaa hiileehhi unkuray. Ana hangugii leehhi, ma ⁄aamuuda kaydiri ⁄aamu goóba qatla. Inkoo, idoo ga firintee daqa Taataage hari uma goy, ina sangu hadisi idotee. ");
INSERT INTO bds_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Haã na ilakaawa doyi, hangu slaꞌaaslaꞌadee unkuray haa unkuray.” ");
INSERT INTO bds_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeesu yaa ilakoomi gimba sa sirakoomiisee dosi tuba, “Bere hida gu khooroti wakiyay unkuray, caahha tuba, ana ginaa tlaatleesiri wakimaa gesaa, gi ilii kahhiyee wakimaa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bere unkuray hinti aloo hida gu khooroti, khooroti hanguu aloo slaꞌada unkuray hida kosi pahha. Inkoo, hida gu khooroti hanguti wakiyay unkuray, sa gimba unkuray ti hida gu khoorotee gooba, kara ana nangwaa hiileehhi khoorotaa. ");
INSERT INTO bds_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Slawaw gimbakira sangwaa kaay tuba, ‘Tongimoo guti didiruuba ba⁄ay da looimoo gosi.’ Bere hinaa labaꞌasiri ana, slime unkuray see dangu labaꞌasi. Kara, bere yaa ooyiri caacaahhamisu gooi, slime ooyiyayi caacaahhamisu googuna. ");
INSERT INTO bds_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Inay gimbakee goõ gi yondiidiyay daqa doogunay sa uma gooi, sa gimba unkuray ti sirakoomiisee doyi, haa inay hhidinay ina gwaa ya⁄abu ana. ");
INSERT INTO bds_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bere hanti aloo khawaaba gi gimbuusa haa inay, hiĩ aloo konaaiiba dakoo. Inkoo, hanguu dahhasiyaaiiba ⁄iisa, gi kaayay tuba, inay konaaba dakoo. ");
INSERT INTO bds_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Heedi guni waka ana, slime hiti waki Taataa gooi see. ");
INSERT INTO bds_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bere haati aloo yondiidaaba tla⁄aã gooinay yondu daaba aloo hiidahhasa ha heedi lensee, yaa aloo konaaiiba tlakwaroo. Inkoo, yondukee gu bakaꞌasa guũ antiri, tay kahhiyay hindi tooinaa wakiyay ana haa Taataa goy. ");
INSERT INTO bds_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hari amoti, hintii gaasiri, gimba daa handikimi sariyaa dooinay, doó kaawa tuba, ‘Hininti wakiri diitiray.’ ");
INSERT INTO bds_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Qatlay damaa ilii khaye Iliiaymiisaykee gamaa ya⁄abe daqa doogunay daqa Taataago, ina hinimaa ilatlay ana. Ina na Muuna gu lou, haa yaati daqa Taataa dahhi. ");
INSERT INTO bds_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Slime, unkuray see kwanda hani ilatlaydee daqa hida wakinayge, sa gimba haa sliimaa wantay haa ana tlaatleesoo da yondu gooaa.” ");
INSERT INTO bds_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yeesu gi ilakoomi gimba tuba, “Ana sanguu kaay unkuray gimbaki, ma hhanti maydiri ⁄imbaraa dooguna. ");
INSERT INTO bds_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Hida hangu gusinay unkuray sinagoogaguu koinaa. Kara, qatlay yaa khoci, hida gumaa cu⁄ee unkuray, himaati ilahudeesiyay tuba, ti yondimaamidiyay sa Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inay maa yondiidiyay gimbakee goõ, sa gimba Taataa gu hhidinay ma ana see hini hhidinay. ");
INSERT INTO bds_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Inkoo, unkuray sanguti kaay gimbaki, qatlay gimaa ilii daye, may slaydiri tuba, ana sangwaa kaay. Tlaatleesoogo ana sangwaa kaayiiba gimbaki, sa gimba haa sliimaa waara haa unkuray. ");
INSERT INTO bds_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ana ki⁄a daqa hikiray hinaa ya⁄abu, ma hhaku lensee tla⁄aã googunay guni maamaamisa tuba, ‘Hati kaakaakayda?’ ");
INSERT INTO bds_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Inkoo, sa gimba sanguu kaay gimbaki, muunaiĩ kokunay hanti hacidiri li⁄eemoo. ");
INSERT INTO bds_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Teesaaqay see, sanguti kakaakama gimba gu lou, waaudimoo gooi ti faydaa daqa doogunay, sa gimba bere ana haniba waaudimoo, Iliiaymiisaykee yaa khayaaba daqa doogunay. Inkoo, bere ana waauda, hagwaa ya⁄aba daqa doogunay. ");
INSERT INTO bds_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ina gimaa ilii khaye, himaa ilii⁄oo⁄i pandataa hida gu khooroti tlakwaroo dooina, haaki da Iliitleemu, haa hukumuu gwaa khawa. ");
INSERT INTO bds_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gimba gu tlakwarooge, hida hiĩ dakusiri, sa gimba hinoó ⁄imbiyaaiiba ana. ");
INSERT INTO bds_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gimba gu haakige, haaki doyi dagoó arina, sa gimba hati daqa Taataa kaw, unkuray hani kara antaaiiba. ");
INSERT INTO bds_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gimba gu hukumuuge, hida hiĩ dakusiri, sa gimba Sataanimoo gu tawaaliilima khooroti, dugwaa hheꞌesi dugwaa hukumi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ana kahha kooma gimba wa⁄a, sangu slae kaawa, da inkooge haguu dahhasidaaiiba hiikaasa. ");
INSERT INTO bds_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Inkoo, Muunakee gu Iliitleemu gimaa ilii khaye, hangurimaa giyaadi, ma caahhadiri gimba sliimaa gu lou. Ina himaa gimbuusiyaaba ina lenkosi hari ⁄uuru gosi gu tawaaliru, ina sangumaati gimbuusi gimba sliimaa giyoó akhasiye haa sigimaa kaay gimba gumaa khawa. ");
INSERT INTO bds_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ina hinimaati daareesi ana, sa gimba sanguti kakaana gimba, gwaa daqa dooi dahha. ");
INSERT INTO bds_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Idadu sliimaa da kone haa Taataa slime ti koi. Haã na idoo siĩ kaay ambee, Muuna gu Iliitleemu sangu kakaana ya⁄abotira gimaa slaye daqa dooaa.” ");
INSERT INTO bds_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yeesu gi ilakoomi gimba tuba, “Da kahhi qatlay coko⁄u, hani antaaiiba, kara da kahhi qatlay coko⁄u hani antayi.” ");
INSERT INTO bds_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Inkoo, sirakoomiisee waka da Yeesu hingigi maamisiri tuba, “Hiĩ ti gimba mala sandi kakaakane tuba, ‘Da kahhi qatlay coko⁄u hani antaaiiba, kara da kahhi qatlay coko⁄u unkuray hani antayi?’ Kara maꞌaana mala kona gi ilii kakaakane tuba, ‘Sa gimba hati daqa Taataa kaw?’ ” ");
INSERT INTO bds_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Inay hingigi ilakoniri maamisu tuba, “Maꞌaana da ‘qatlay coko⁄u’ na mala? Dandiray hhidina gimba mala gini kakaakana.” ");
INSERT INTO bds_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesu yaa caahhi tuba, inay gwaati slaiyay maasa maꞌaana da gimbakee. Da hheꞌesi gigi maasi tuba, “Hanguti maamaamisiday maꞌaana da gimbakee gaã kaay tuba, qatlay coko⁄u hani antaaiiba, haa qatlay coko⁄u kara hani antayi? ");
INSERT INTO bds_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ana sangu kaawa gu lou, unkuray hamaa ⁄aa⁄aday haa gaitay, tay hida gu khooroti gi hhaꞌaluumidiyay. Unkuray hamaa kontay li⁄eemoo teesaaqay see li⁄eemoo googuna, himaa hiifookidi gi hhaꞌaloo tleehhidi. ");
INSERT INTO bds_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hadee giyoó ilii ba⁄adaa, yoóti arinta slahhaaꞌamee, sa gimba qatlay gosi gu hiidawa hiĩ day. Teesaaqay see, qatlay giĩ ilii daadi, hiislaydaaba kara slahhaaꞌametee, sa gimba gu hhaꞌaloo da slawaraa daa⁄u khoorotii. ");
INSERT INTO bds_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Teesaaqay, inkoo unkuray see ti kontay li⁄eemoo. Qatlay, hangumaa kara ilii arime, hamaa hhaꞌaluumitay, haa hhaꞌalotee hhaku heedi gumaa hiidahhasa bacaraa daqa doogunaa. ");
INSERT INTO bds_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Qatlaykee gimaa ilii buꞌudiye, hanimaa firintaaiiba idoo lensee. Gu lou, sangu kaay, idoo ga firintee daqa Taataage hari uma goy, ina sangu hadisi idotee. ");
INSERT INTO bds_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Inkoo naqatloo haã firintiriiba idoo lensee hari uma goy. Unkuray firima Iliitleemu ha slayday, hhaꞌaloo dooguna buꞌuta.” ");
INSERT INTO bds_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Unkuray sanguti kaay gimbakee hari amoo day hhantlisa. Qatlay yaa khoci, hamaa gimbuusaaba kara haa unkuray hari amoo da hiihhantlimisu, sangumaati kakaama pandataa gimba gu Taataa. ");
INSERT INTO bds_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Balotee gimaa ilii buꞌute, Taataa hangumaa firintay hari uma goy. Caahha ana kaawaaba ambee, sangu firima unkuray daqa Taataage. ");
INSERT INTO bds_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ina loi Taataa hangu slai unkuray, sa gimba unkuray hanii slaꞌadiri ana, haa haã ⁄imbidiri tuba, ana haa daqa Iliitleemu dahha. ");
INSERT INTO bds_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ana haati daqa Taataa dahha, haagi khay khoorotii. Inkoo, khooroti haga maw, ki⁄a daqa Taataage.” ");
INSERT INTO bds_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Da hheꞌesi, sirakoomiisee dosi sugugi kaadi tuba, “Yuꞌudiyaa, inkoo asu gimaamisida pandataa harii hhantlimisu gooba. ");
INSERT INTO bds_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Inkoo, haã asu caahhani tuba, ugu hati khuꞌuda gimba goõ, kara ugu kontaaba piimaa duguma maasi gimba ha heedi lensee. Sa gimbaki, dandiray haã ⁄imbana tuba, ugu haa daqa Iliitleemu dahhada.” ");
INSERT INTO bds_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu gigi maasi tuba, “Gu lou, inkoo haã ⁄imbidirii? ");
INSERT INTO bds_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Qatlay yaa khoci, kara yaani hheꞌesi yaani day, unkuray gonkokunaa ha ciyaakhatay, kila heedi waaudi aya gosii, haniti mayday ana lenkway. Teesaaqay see, hati ana lenkway waaraaba, Taataa sliimaa wana haa ana. ");
INSERT INTO bds_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ana sanguti kaay gimbaki, ma slaydiri qasaw muunaiĩ kokunay ilagaasage haa ana. Khooroti slayday labaꞌasu. Teesaaqay see, hangu muunaiĩ hii⁄atlisidee, sa gimba ana haã slay kaba⁄amuu gimba gu khoorotii.” ");
INSERT INTO bds_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Qatlay Yeesu giyaa ilii hheꞌesi gimba gimbaki, gi ganaꞌasi ilaa kosi rawaa gu rawge, gi kaay tuba, “Taataa, qatlay hiĩ buꞌudi! Daareesi Nankoogu, magu daareesi ugu. ");
INSERT INTO bds_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ugu sugwaa hadisidi ⁄uuru gu tawaaliru hida goõ, ma sigi hadisi slafimaa gu koraraa haa koraraa goóba hiifaakoo, hida hhakira goõ sugwaa hadisidi. ");
INSERT INTO bds_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Slafimaa hhakee na nahhaã. Ti caahharaa ugu, Iliitleemu gu ugu lenkoogu gu lou haa Yeesu Kristu, hiĩ gwaa ya⁄abidi khoorotii. ");
INSERT INTO bds_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ana haguũ daareesi ugu khoorotii, hari amoo da hiigaasa yondu sinaa qaydi, magu yondiidi. ");
INSERT INTO bds_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Inkoo, Taataa hani daareeside pandaa dooguu, hari wanqametira gaa koome gaa ilii sliimaa wane, daa ilii kahhiye tlehhinay khooroo.” ");
INSERT INTO bds_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yeesu gi ilakoomi gimba tuba, “Taataa, ana hagwaa hiitlaaꞌasi duguma caahhi ugu na miyaa daqa hida sinaa hadisidi khoorotii. Inay yaati hida koku, ugu sinigi hadisidi ana. Inay yaa ooyiri caacaahhamisu googu. ");
INSERT INTO bds_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Inkoo, inay khuiyay tuba, gimba sliimaa sinaa hadisi, yaati daqa doogu dahhi, ");
INSERT INTO bds_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sa gimba ana sigaa qay ya⁄abotira sinaa hadisidi, inay giĩ ooyiri. Gu lou, inay yaa khuiyay tuba, ana haati daqa doogu dahha, haa gi ⁄imbiri tuba, ugu naa ya⁄abidi ana. ");
INSERT INTO bds_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ana sangu firiirima. Ana firiirimaaba sa hida goõ gu khooroti. Ana ti firiirima sa hida hhakee kilesi sinaa hadisidi, sa gimba ti hida koku. ");
INSERT INTO bds_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hida goõ ga koome ana ti koku, haa goõ ga konte ugu ti koi. Ana dininti daareesi ilagaasa dooinay. Inay hiĩ laqaniri, idoo na ilii didiri. ");
INSERT INTO bds_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Inkoo, ana ha waauda khoorotaa, haa khaw daqa dooguu. Hida koku kahhiyay wanay khoorotii. Taataa, ugu gooba dakoo, ga⁄awaki hari ⁄uuru gu uma googu, umakira sinaa hadisidi. Ga⁄awaki mangu ilagaasiri sliimaa, dandiray gooay ga iliiwane. ");
INSERT INTO bds_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Qatlay ana gaa ilii sliimaa waaree haa inay, giyaati ga⁄ay haa gigi iliikoomi hari ⁄uuru gu uma googu, sinaa hadisidi. Ana hagiyaa ilakoomi naraꞌa, hhaku heedi gwaa hhamu. Ti hikira kilesi gu hhama, Handikaa da Iliitleemu ma buꞌuti. ");
INSERT INTO bds_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Taataa, inkoo ana haati khakhaakhaw daqa doogu. Ana hati gimaamisa gimbaki qatlay ga ilii kahhe khoorotii, inay ma slayri hhaꞌaloo doyi goõ muunaiĩ koinay. ");
INSERT INTO bds_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ana sigiĩ kaay inay gimba googu, inay digigi waki ha hida gu khooroo, sa gimba inay ti hida gu khooroo gooba, da ana gooay, ti heedi gu khooroo gooba. ");
INSERT INTO bds_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ana hati firiirimaaba ambee, surukusaki khoorotaa. Ana haguti firiirima ambee, ga⁄awaki daqa Biriisimoogo. ");
INSERT INTO bds_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Inay ti hida gu khoorotiiba, ana gooay ga ilii heedi gu khoorotiiba. ");
INSERT INTO bds_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Inay tlintiꞌisaki daqa dooguu hari gimba googu gu lou. Gimba googu guni lou. ");
INSERT INTO bds_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Idoo hanaa ilii ya⁄abidi gooay ana khoorotii, slime ana see giĩ ya⁄abi inay khoorooge. ");
INSERT INTO bds_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ana hanguu tlintiꞌisi sa inay, inay see mangu tlintiꞌisiri sa ugu gu lou. ");
INSERT INTO bds_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Taataa, ana hati firiirimaaba sa sirakoomiiseti kilesi. Slime hati firiirima sa hida sliimaa gumaa ⁄imbee hari caacaahhamisu gooina. ");
INSERT INTO bds_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taataa, ana hati firiirima ambee, hida hhakee goõ idoo leẽ tleehhidiyee, idoo hangaa ilii ilagaasani gooay ugu haa ana. Ana hati firiirima, ma idoo leẽ tleehhidiri sliimaa haa dandiray, hida wakinay, ma ⁄imbiri tuba, ugu naa ana ya⁄abidi khoorotii. ");
INSERT INTO bds_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wanqametira sinaa hadisidi ana, ana see hagaa hadisi sa inay, ma idoo leẽ tleehhidiri, ga iliiwane gooay ana haa ugu, ");
INSERT INTO bds_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ana hangwaa ilagaasi haa inay, slime ugu see hangwaa ilagaasidi haa ana. Inay idoo leẽ tleehhidiyee, hida wakinay gu khooroti ma caahhiri tuba, ugu naa ya⁄abidi ana. Kara, caahhiyee tuba, ugu hagi slaꞌada idoo hani iliislaꞌadee gooay ana. ");
INSERT INTO bds_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taataa, ana ti slaꞌa hida hhakee sinaa hadisidi sliimaa wanee haa ana daqa ga iliiwaare, ma aniri wanqamee dooi. Wanqametee sinaati hadisidi, sa gimba hanaati slaꞌadi, daa ilii kahhiye tlehhinay khooroti. ");
INSERT INTO bds_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taataa gu kooma haaki, hida gu khooroti gimati khuiyaaiiba ugu, ana gu khua ugu. Slime sirakoomiisee doyi see khuꞌuda tuba, ugu naa ya⁄abidi ana. ");
INSERT INTO bds_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ana gungii tlaaꞌasi ugu daqa dooinay, idoo ga iliiwante, haa hati ilakoomaa teesaaqay laqaraa, inay see ma slaꞌaaslairi hida wakinay, idoo hani iliislaꞌade gooay. Kara ana ma ibiidi waꞌay koinay.” ");
INSERT INTO bds_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeesu giyaa ilii hheꞌesi firoo gimbakee, gi waaudi haa sirakoomiisee dosi. Inay gi tlo⁄osiri hari bara waka da hiihuuꞌuma gu Kedirooni, gii guuma kayri qaymoo da ⁄aamuge. ");
INSERT INTO bds_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuuda, gwaa taatahhu Yeesu dabaiĩ gu fa⁄ayaage, ina yaa khui qaymotee, sa gimba Yeesu hingaa slaslaaslay taysi waa wa⁄a sliimaa haa sirakoomiisee dosi. ");
INSERT INTO bds_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Teesaaqay, Yuuda yaagi khay qaymoteesii, tay hingaani giyaadisi ha raqa da sirikaarii da Ruumi sliimaa haa yondimiisee da deni, daa ya⁄abi haa hhapalooee da deni haa Farisaayoo. Inay yaa konay taa, mumbaalaiĩ haa khasima. ");
INSERT INTO bds_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Inkoo, Yeesu tay khui gimba sliimaa gumaa hiica⁄a daqa dosii, gigi ilii hadakay haa gigi maasi tuba, “Miyaa guni dabimaamitay?” ");
INSERT INTO bds_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Inay gugi ilaki⁄isiri tuba, “Yeesu gu Nasareeti!” Yeesu gi kaay tuba, “Ana na ina.” Yuuda gwaa hiifookidu ina, yaa qadidi teꞌesii sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yeesu giyaa ilii kaay tuba, “Ana na ina,” inay gi ki⁄iri alunge haa gi huuiri. ");
INSERT INTO bds_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ina gigi kara maasi tuba, “Miyaa guni dabimaamitay?” Inay gi kaayri tuba, “Yeesu gu Nasareeti!” ");
INSERT INTO bds_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ina sigigi kara kaay tuba, “Sanguu kaay ambee, ana na ina. Bere ana guni dabimaamitay, inkoo maw hhawatee hhanki, ma waaudiri.” ");
INSERT INTO bds_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gimbaki yaatii ca⁄i, dama buꞌudi gimbakira gaa kaay tuba, “Taataa, hida sliimaa sinaa hadisidi, haa hhamisiiba lensee.” ");
INSERT INTO bds_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Da hheꞌesi, Simooni Peetiro hiĩ gwaa kooma pangaa, gigi slootisi looboogo, gii maahhasi tongimoo gu hhapalooay gu didiru, gugi afakereꞌesi eea dosi da ⁄uya. Tongimokee dugwaati eteediidina na Maaliko. ");
INSERT INTO bds_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Teesaaqay, Yeesu gi kaay sa Peetiro tuba, “Ki⁄isii pangaa googu looboo dosii! Gu lou, kitahha qulu⁄uki gu labaꞌasu, sinaa ilakhuukhuꞌusi ha Taataa goy.” ");
INSERT INTO bds_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Da hheꞌesi, sirikaaritira da Ruumi haa giyaadimiisay gooina, sliimaa haa yondimiisee da deni da Wayahuudi, Yeesu gugi ooyiri haa gugi khiidiniri. ");
INSERT INTO bds_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yeesu gugi gesaa leehhisiri daqa Anaasige, kumbaꞌa gu Kayaafa. Kayaafa naa hhapalooay gu didiru korikeesii. ");
INSERT INTO bds_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayaafa naa kaay sa giyaadimiisee da Wayahuudi tuba, ti naraꞌa heedi leẽ gwaaꞌaraa sa hida goõ. ");
INSERT INTO bds_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simooni Peetiro sliimaa haa sirakoomiisay waku yaa sirakomaamidiyay Yeesu. Sirakoomiisayki waku dugwaa khui ha hhapalooay gu didiruge. Teesaaqay, ina gii day efeenaa da hhapalooay gu didiru sliimaa haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peetiro gi meeti afamaraage. Sirakoomiisaykee waku daa khuiye ha hhapalooay gu didiru, gii ca⁄i khoorooge, gi cocoi haa sagameeriya daa wariiqadiidimida afamaraa, gii daasidi Peetiro waꞌayge. ");
INSERT INTO bds_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sagameeriyatee daa afamaraage waara gi maasidi Peetiro tuba, “Ugu see caba ti leẽ gu sirakoomiisee da heediki, diĩ ooyi?” Teꞌesii, Peetiro gi tlanki, tay kakaana tuba, “Suti! Ana na inaaba!” ");
INSERT INTO bds_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tongetee da hhapalooay gu didiru haa hida gwaa ga⁄aa⁄awee yaa hamisiri aslaa tooinaa miciyay, sa gimba caaqwa yaa wanta. Peetiro see yaa wana hiĩ qadidi teꞌesii mici aslaa. ");
INSERT INTO bds_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Teꞌesii, waꞌay gu marage, hhapalooay gu didiru yaa maamaamisi Yeesu gimba gu sirakoomiisee dosi haa caacaahhamisu gosi. ");
INSERT INTO bds_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu gugi ilaki⁄isi tuba, “Balalu sliimaa ana haati caacaahhaahhamisa hida pandataa, sinagoogaguuge haa mara gu didiruge gu Iliitleemu, daqa da ilii kurunkurimidu Wayahuudi goõ. Ana haa kaayiiba gimba lensee hari hhaaboo. ");
INSERT INTO bds_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ana sini soꞌoyi maamaamisida? Maamisi hida hhakee gwaa akhasee ana, gu lou hhakee khuiyay naraꞌa gimba gaa kaay.” ");
INSERT INTO bds_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeesu giyaa ilii hheꞌesi kaawa gimbakee, yondimiisay gwaa qadidu ilaciyaa gosii, gugii maahhasi koofii pandaage, haa sugugi kaay tuba, “Gu louu, teesaaqay gani ilii ilaki⁄isidaa hhapalooay gu didiru?” ");
INSERT INTO bds_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu gi kaay sa heedikee tuba, “Bere haã kaay dakoo, aare kaay pandaa da hidage dakoo doyi. Bere haã kaay naraꞌa, siniĩ soꞌoyi gii maahhasidi?” ");
INSERT INTO bds_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Da hheꞌesi, Anaasi gi ya⁄abi sirikaarii dosi, ma leehhisidi Yeesu daqa Kayaafage, hhapalooay gu didiru, tay kahhi duguũ khiidimi. ");
INSERT INTO bds_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Qatlay Simooni Peetiro giyaa ilii qadidi teꞌesii mici aslaa, wakinay gwaa waaree teꞌesii gugi maasiri tuba, “Ugu see caba ti leẽ gu sirakoomiisee dosi heedikee diĩ ooyi?” Teꞌesii, Peetiro gi tlanki haa gi kaay tuba, “Suti! Ana na inaaba!” ");
INSERT INTO bds_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yondimiisay leẽ gu hhapalooay gu didiru, hhia gosi heedikira, daa afakereꞌesi eea ha Peetiro, gi maasi Peetiro tuba, “Gu lou, ana hagwaa arimiibaslii ugu tindigaage sliimaa haa Yeesu?” ");
INSERT INTO bds_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peetiro gugi kara tlanki Yeesu, nama qatlaykeesii lenge, konkaku gi ceei. ");
INSERT INTO bds_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Qatlay daa ilii daadaausi pisaraa, teꞌesaa daqa Kayaafago Yeesu dugugi leehhisi mara gu Pilaatuge, Gafana gu hhapee da Ruumi, hiĩ gwaa tawaaliilima hhapee da Yudaaya. Giyaadimiisee da Wayahuudi, yaa hiiguniriiba marakeesii, sa gimba hingaa aloo slasla⁄eediisiyay haa gi mayay ⁄agoo losona gu Pasaaka. ");
INSERT INTO bds_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Teesaaqay, Pilaatu yaagii ca⁄i khoorooge, mangi slaslayri haa inay haa gigi maasi tuba, “Heediki guri dakoo mala sitaakikintay?” ");
INSERT INTO bds_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Inay gugi ilaki⁄isiri tuba, “Bere heediki hiĩ aloo konaaba dakoo, haguraani aloo khaynaaba daqa dooguu.” ");
INSERT INTO bds_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilaatu gi kaay tuba, “Unkuray hari waaudakuna, lugu hukuruu kayda unkuray kilakokuna hari amoo da sariyaa dooguna.” Wayahuudi gugi ilaki⁄isiri ina tuba, “Sariyaa da Ruumige, dandiray sandaa qayiiba ⁄uuru gu gaasaraa heedi.” ");
INSERT INTO bds_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gimbaki yaa hiilaqadi teesaaqay, dama buꞌudi gimba gu Yeesu giyaa kaay, idoo gi ilii gwaaiye. ");
INSERT INTO bds_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Da hheꞌesi, Pilaatu gi kara hiiday waꞌay gu marage, gi ilafahhi sirikaarii dosi, Yeesu maduguraa khay pandaa dosii. Teꞌesii, Pilaatu gugi maasi tuba, “Ugu na inaa Mutemi gu Wayahuudi?” ");
INSERT INTO bds_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeesu gi ilaki⁄isi ina tuba, “Gimbakee gaã kaadi ti ilahudaa koku louu baku sugunti kaay ha hida wakinay gimba gooi?” ");
INSERT INTO bds_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatu gugi ilaki⁄isi tuba, “Ayi! Ana ti Yahuudimoogoo? Hida koku loi haa hhapalooee da deni nuguraani khayri ugu daqa dooii. Inkoo, ugu hanti malee laqadi?” ");
INSERT INTO bds_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu gi kaay tuba, “Tawaaloo doyi dati khoorotiiba. Bere tawaaloo doyi dinti aloo da khooroti, yondimiisee doyi yaa aloo qwaatlida, ana dinima may hiilu⁄a dabaiĩ gu Wayahuudige. Teesaaqay see, tawaaloo doyi dati khoorotiiba.” ");
INSERT INTO bds_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Da hheꞌesi, Pilaatu gi kaay tuba, “Teesaaqay, ugu ti mutemigo?” Yeesu gi ilaki⁄isi tuba, “Ugu haã kaadi naraꞌa tuba, ana ti mutemi. Ana dinaati laqwali, sa gimbakee haati khay khoorotii, ana ma ilatlatlay sa hida gimba gu lou. Hida goõ guri bara da gimba gu lou waaree, hiniti akhaakhamisiyayi ana.” ");
INSERT INTO bds_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatu gugi maasi tuba, “Gimba gu lou na mala?” Teꞌesii ina kara gii ca⁄i khoorooge, gi kaay sa Wayahuudi tuba, “Ana haã arimiiba gimba lensee gu hukuruu heediki! ");
INSERT INTO bds_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Inkoo, qatlay gu Pasaaka, kontay ou tuba, sangu afiiooyima khiidimoogo heedi leẽ sa unkuray. Unkuray slaꞌadaaii sangu afiiooyimi mutemi gu Wayahuudi?” ");
INSERT INTO bds_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Teꞌesii, hida goõ gi maahhiri sliimaa tuba, “Heedikee gu hhanti gweta, sandaati gwete Baraaba!” Baraaba yaa afii⁄utlidiisayi. ");
INSERT INTO bds_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Da hheꞌesi, Pilaatu gi ilafahhi sirikaarii dosi, Yeesu duguma leehhisi, duguma difoo kay hari jeleedimaiĩ. ");
INSERT INTO bds_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sirikaaritee gi boo⁄imisidi hhamaa gu leqeewaa haa sugugi daasiri saga gosii. Da hheꞌesi, sugugi daasiri qayriya da mutemi pahha, kalay gosi gu daahhiya. ");
INSERT INTO bds_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sirikaaritee yaa hadakakaakayda pandaa da Yeesuge, tay gu tooinaa difiyay pandaage hari dabaiĩ haa gi kaadi tuba, “Hagu hhouu, ye Mutemi gu Wayahuudi!” ");
INSERT INTO bds_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu gi kara hiica⁄i khoorooge, gi kaay tuba, “Yuꞌudaa, sanguraa khaw heediki daqa doogunay, unkuray ma caahhadiri tuba, ana haã arimiiba dakoo lensee daqa dosii.” ");
INSERT INTO bds_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Da hheꞌesi, Yeesu duguraagii ca⁄i khoorooge, tay hiĩ daasi hhamaa gu leqeewaa haa qayriya da koomaa kalay gu daahhiya. Pilaatu gi kaay sa hida hhakee tuba, “Yuꞌudaa! Heedi googuna nahiĩ!” ");
INSERT INTO bds_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Giyaadimiisetee da hhapalooee da deni haa yondimiisee da deni giyaa ilii aniri Yeesu gi maahhiri tuba, “Heedikee dugutii tluhhumisiye musalaabage! Dugutii tluhhumisiye musalaabage!” Pilaatu gi kaay sa inay tuba, “Unkuray owakunay, lugu hiitluhhumisu kayday unkuray kilakokuna. Ana haã arimiiba dakoo lensee daqa heedikii.” ");
INSERT INTO bds_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahuudi gugi ilaki⁄isiri tuba, “Dandiray kona sariyaa leẽ yoóti kaada tuba, heediki kwanda dugu gaasiye, sa gimba ina hingiti eteedi Nanku Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilaatu giyaa ilii akhasi gimbakee, gi ilaqinci tlaꞌamuuda hari khisla. ");
INSERT INTO bds_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ina gii day kara waꞌay gu marakeesii kosi, gi maasi Yeesu tuba, “Ugu haa kaadahhada?” Teesaaqay see, Yeesu gwaa ilaki⁄isiiba gimba lensee. ");
INSERT INTO bds_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Da hheꞌesi, Pilaatu gi kaay sa ina tuba, “Ugu slaꞌadaabaslii cocoꞌomoo haa ana? Ugu hhidinta, ana kooma ⁄uuru gu tawaaloo gu geemawaraa haa gu hiitluhhumisu ugu musalaabage?” ");
INSERT INTO bds_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu gugi ilaki⁄isi tuba, “Bere ugu sugwaa aloo qayaaba ⁄uuru gu tawaaliru daqa Iliitleemugo, haã aloo kontaaba ⁄uuru lensee daqa dooii. Inkoo, hiĩ guunii lu⁄u ana dabaiĩ kokuu kona tlakwaroo da didiri ba⁄ay da toogu see.” ");
INSERT INTO bds_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sa gimbakee, Pilaatu gi dabiidi amoo dari geemawaraa Yeesu. Teesaaqay see, giyaadimiisee da Wayahuudi gi ilaqincidi maahhoo kakaanay tuba, “Bere heediki hagoo geemayda, ugu fa⁄ayaa gu Kaysaari tleehhita, mutemi gu Ruumi. Heedi gungu hiitlaymaamisa ina mutemi pahha, hiti kaniinimisi Kaysaari!” ");
INSERT INTO bds_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilaatu giyaa ilii akhasi gimbakee, yaa ilafahhi sirikaarii dosi, maay ca⁄asidi Yeesu khoorooge. Ina gi ibinaa kay kitiĩ gu hukumuuge, daqa daa eteediidine na, “Efeenaa da Tle⁄eẽ,” hari gimba gu Eburaanaisoo na “Gabaata.” ");
INSERT INTO bds_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Letutee yaati baloo da ilakhuukhuꞌusa da losona gu Pasaaka, letu yaati asu daadaausidi tana⁄iyage. Pilaatu gi kaay sa Wayahuuditee tuba, “Yuꞌudaa! Mutemi googuna nahiĩ!” ");
INSERT INTO bds_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Da hheꞌesi, inay gi maahhiri tuba, “Gaasaku! Gaasaku! Tluhhusakuu musalaabage!” Pilaatu gigi kara maasi inay tuba, “Gu lou, mutemi googuna gutii tluhhusaa musalaabage?” Hhapalooee da deni gi ilaki⁄isiri tuba, “Dandiray konaaba mutemi waku ti Kaysaari na mutemi goori!” ");
INSERT INTO bds_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Da hheꞌesi, Pilaatu gugi tosaa taataahhi Yeesu dabaiĩ gu sirikaariteesii, ma dugu hiitluhhumisi musalaabage. Inkoo, gurigi tosaa waaudiri Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeesu tay hiĩ geregedi musalaaba gosi, gii ca⁄i, gi yade khuꞌusi daqa daa eteediidine na “Faraa da Saga,” hari gimba gu Eburaanaisoo na “Goligoota.” ");
INSERT INTO bds_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Teꞌesii na daqa dugwaa ilii tluhhumisi musalaabage sliimaa haa hida wakinay cada, leẽ hari bara da ⁄uya haa gu caduu hari bara da basa, Yeesu tla⁄ange. ");
INSERT INTO bds_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu gi ilafahhi dama handikimi handikaa bangasiyage, dagagii tluhhusi rawaa gu musalaaba gu Yeesuge. Bangasiyatee dagaati ilii handikimi tuba, “YEESU GU NASAREETI, MUTEMI GU WAYAHUUDI.” ");
INSERT INTO bds_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Teesaaqay, Wayahuudi wa⁄a yaa sominti handikatee, sa gimba daqatee daa ilii tluhhumisi Yeesu musalaabage, yaati ilaciyaa haa yaamu. Kara, handikatee dagaati handikimi hari gimba gu Eburaanaisoo, Latiiniꞌisoo haa Yunaanaisoo. ");
INSERT INTO bds_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hhapalooee da deni gi kaadi sa Pilaatu tuba, “Hhanti handikinta tuba, ‘Hiĩ na Mutemi gu Wayahuudi.’ Ti handikimi taqay ubee, ‘Heediki yaati kaay tuba, ana na Mutemi gu Wayahuudi!’ ” ");
INSERT INTO bds_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatu gi ilaki⁄isi tuba, “Gimba gaa handikimi, haguũ handikimi, haguu fookaaba.” ");
INSERT INTO bds_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sirikaaritee gii tluhhumisidi Yeesu musalaabage, gii oyiri qayroo kosi, gigi deehhiniri upaiĩ cigahhage, kila sirikaarimoo ma slay upa gosi. Inay yaa mayri hiiowa qayru gosi, daa hhutli rawaago biraa naqatloo, hirimaamidu see guba. ");
INSERT INTO bds_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Teesaaqay, sirikaaritee hingigi warii kaayri tuba, “Jurungiti haga hhanti feehhimisana, kuura ganii slakhanee, ma caahhani jurungiti miyaa naga hiioy.” Inay yaa teesaaqay laqiri, dama buꞌudi Handikaa da Iliitleemu, daa kaadi tuba, “Hingaa deehhiniri qayroo koi, haa gii slaslakhiri kuura sa jurungii dooi.” ");
INSERT INTO bds_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tigay gwaa qadimidee teꞌesii ilaciyaa gu musalaabage yaati iyoo da Yeesu, hhioo da iyoo da Yeesu, sliimaa haa Mariyaa hadee da Kileyoopa, haa Mariyaa Magidaleena. ");
INSERT INTO bds_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeesu giyaa ilii arimi iyoo dosi teꞌesii haa sirakoomiisaykira giyaa slaiye, hiĩ qadidi ilaciyaage, gi kaay sa iyoo dosi tuba, “Iyoo! Yuꞌudiyaa, hikee na nankoogi.” ");
INSERT INTO bds_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Da hheꞌesi, gi kaay sa sirakoomiisaykira tuba, “Yuꞌudiyaa! Hatee na iyoo doogu!” Tlaatleesoo gu qatlaykeesaa, sirakoomiisaykee haraa waaudi iyotee tosi, ma ibinaa kaydi aya gosii. ");
INSERT INTO bds_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Da hheꞌesi, Yeesu yaa caahhi tuba, yondu gosi sliimaa hindii faaki. Slime ina ma hiigaasi Handikaa da Iliitleemu, gi kaay tuba, “Haã wakhiidi.” ");
INSERT INTO bds_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Teꞌesii yaa wana dahhaã gwaa hacu difaay daa mahhaaꞌadi. Hida wakinay gii ooyiri dahhamu, gugii khiidiri cina da khwacaa da khaimoo doó eteedine hisoopo, gigii tulu⁄iri waꞌay gu difaayteesii, gigi taatahhiri rawaage sa Yeesu, ma hiicunqi. ");
INSERT INTO bds_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeesu giyaa ilii hheꞌesi hiicunqa difaaytee, gi kaay tuba, “Gimba sliimaa hiĩ buꞌudi.” Da hheꞌesi, gii gupu⁄usi saga, gi tosaa dafidi dandaꞌaaliya. ");
INSERT INTO bds_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Balotira yaa baloo da Jumaa, baloo da ilakhuukhuꞌusa da baloo da Sabaato. Wayahuudi yaa slaiyaaiiba slaqoo gu tuuꞌuna, ma meetiri musalaababuuge baloo da Sabaato. Kara, Sabaatotee daati kaari hari khisla. Teesaaqay, gi firiniri Pilaatu tuba, yeꞌeeroo gu hida hhakee daa hiitluhhumisi, ma digi qeetimisi, ma kaka⁄iri cira, slaqoo koina, ma digi baci musalaababuugo. ");
INSERT INTO bds_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Da hheꞌesi, sirikaaritee gi hadakaydi, gi qeetimisidi yeꞌeeroo gu heedikira gu pandaa haa heedikira gu caduu daa hiitluhhumisi sliimaa haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Inkoo, inay giyaa ilii dayri daqa Yeesuge, gugi ariniri tuba, yaa hheꞌesi yaa dafidi dandaꞌaaliya. Teesaaqay, gwaa afaqeetimisiriiba yeꞌeeroo. ");
INSERT INTO bds_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sirikaarimoo leẽ gi muti Yeesu tluntlubaage hari labaala. Cirakiray lenge ceedee haa maꞌay yaagii ca⁄iri. ");
INSERT INTO bds_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Heedi gwaa arimu gimbakee noó ilatlay, kara ilatlawa dosi dati loi. Ina khui tuba, gimba giyoó kaaye guti lou, haa yoóti ilatlay unkuray see slime ma ⁄imbidiri. ");
INSERT INTO bds_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gimbaki yaatii ca⁄i, Handikaa da Iliitleemu ma buꞌuti, doó kaawa tuba, “Hhaka faraa dosi lensee damaa qeeta.” ");
INSERT INTO bds_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kara, Handikaa waka da Iliitleemu yoóti kaada tuba, “Hida hhanki gumaa khuꞌunay hikee gwaa mutiri hari labaala.” ");
INSERT INTO bds_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Inkoo, yaa wana heedi leẽ, yaamulooay gu yaamu gu Arimataaya, uma gosi na Yoseefu. Ina yaa sirakoomiisay gu Yeesu hari amoo da hhaaboo, sa gimba yaa tlaꞌamuudi Wayahuudi. Qariqaaqari ina gi hadakay daqa Pilaatuge, gi firimi suguma hadisi tuuꞌuna da Yeesu, magi qaasa kay. Pilaatu gi ⁄imbi, Yoseefu gii oyi tuuꞌunatee. ");
INSERT INTO bds_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodeemo, hiĩ qatlay waku gwaa hadakaw daqa Yeesuge hari amasi, slime yaagi khay. Ina haraagi khay hiirooga da manemaane, haa ubaanii, daa kooma hiiloaruũ gu kiloo mibeeri tami taqaaqay. ");
INSERT INTO bds_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inay cada koinaa gii oyiri tuuꞌunatee da Yeesu, gigi khiidiniri hari kaeeri gu qayru gu ⁄abaaku poy, tay gigi maakhiri hari du⁄iya da kooma tafu gu hhou, doó eteedine na manemaane haa ubaanii. Inay yaati teesaaqay laqiri, idoo da iliiwane gooay ou gu Wayahuudi qaasaraa da tuuꞌunage. ");
INSERT INTO bds_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ilaciyaa haa daqateesii daa ilii tluhhumisi Yeesu musalaabage, yaa wanta tindigaa. Qaymoteesii yaa wanta ayisa da ⁄abi daa hiikhuri maraiyage, daa kahhiye ilii qaasaraa tuuꞌuna. ");
INSERT INTO bds_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Inkoo, balotee yaati baloo da ilakhuukhuꞌumisu gu Sabaato da Wayahuudi. Teesaaqay, sa gimba ayisatee yaa ilaciyaage wanta, hida hhakee gi qasaa kayri tuuꞌunatee da Yeesu teꞌesii. ");
INSERT INTO bds_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Baloo da Jumaapiiri, dati kahhi taaboo⁄a⁄aa, Mariyaa Magidaleena, gi hadakaydi ayisage. Ina giyaa ilii daadi taysi, yaa anti tlaa⁄atira, daa hiigwangwaraai afa gu ayisage dagaã baci. ");
INSERT INTO bds_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Teesaaqay, ina gi taa⁄ati daqa Simooni Peetiroge haa daqa sirakoomiisaykira waku daa slaiye ha Yeesu, sigigi kaadi inay tuba, “Hida hiĩ baciri tuuꞌuna da Looimoo gu Goõ ayisago, haa hhidina daqa giĩ iliiqaasiri!” ");
INSERT INTO bds_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Inkoo, Peetiro sliimaa haa sirakoomiisaykira gi waaudiri, gi yade khuiri ayisage. ");
INSERT INTO bds_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Inay cada koinaa gi tu⁄umidiri, sirakoomiisaykira gi tu⁄udi hari khisla, gii cati Peetiro, gi giyaadi dawaraa ayisage. ");
INSERT INTO bds_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Qatlay giyaa ilii day teꞌesii, gii condoi haa gi biraayuꞌudi ayisatee, gi arimi kaeeri gu qayru gu ⁄abaaku waꞌay gu ayisage. Teesaaqay see, ina yaa hiidayiiba waꞌayge. ");
INSERT INTO bds_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Da hheꞌesi, Peetiro yaagi khay aluũ kosaa, ina gi tosaa hiiday waꞌay gu ayisage, gi arimi kaeeri hhakee gu ⁄abakwi teꞌesii. ");
INSERT INTO bds_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Slime gi arimi kaꞌaã daraa khiidimi saga gu Yeesu. Kaꞌakee dugwaati qwasa⁄i haa dugugi qaasi daqa da inalenkosii segenge haa kaeeri hhakee gu ⁄abakwi. ");
INSERT INTO bds_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Da hheꞌesi, sirakoomiisaykira see gwaa giyaadu dawaraa teꞌesii ayisage, slime gii day waꞌay gu ayisage. Ina see, gi arimi haa gi ⁄imbi gimbakee gungii ca⁄u. ");
INSERT INTO bds_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Qatlaykee sirakoomiisee da Yeesu yaa kahhada caahharaa Handikaa da Iliitleemu, doó kaawa tuba, Yeesu kwanda giyaa slafiye ayisago. ");
INSERT INTO bds_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Da hheꞌesi, sirakoomiisetee da cada, gi ki⁄idi ayeemaa koinay. ");
INSERT INTO bds_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariyaa yaati asu daadi kara ayisage, gi qaditi khoorooge, tay tosaa ⁄aa⁄ada. Qatlay giyaa ilii ⁄aa⁄ii⁄iminte, gii condoꞌodi haa gi birayuꞌuti waꞌay gu ayisage, ");
INSERT INTO bds_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","gi anti malayika cada, hindaamisiri qayroo gu ⁄abakwi. Malayikatee hiĩ ibiti daqa daa iliiwane tuuꞌuna da Yeesu, leẽ hari bara da saga haa waku bara da yeꞌeerooge. ");
INSERT INTO bds_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malayikatee gi maasidi Mariyaa tuba, “De iyoo, soꞌoyi ⁄aa⁄ii⁄iminta?” Ina gigi ilaki⁄isidi tuba, “Hida hiĩ baciri tuuꞌuna da Looimoo gu Goõ, ana hhidima daqa giĩ iliiqaasiri!” ");
INSERT INTO bds_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ina giyaa ilii hheꞌesidi kaawa gimbakee, gii fookiti alunge, gi anti Yeesu hiĩ qadidi teꞌesii. Teesaaqay see, yaa baraslaydiiba tuba, ti ina. ");
INSERT INTO bds_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeesu gi kaay sa ina tuba, “Iyoo, soꞌoyi ⁄aa⁄ii⁄iminta? Miyaa guni dabimaamita?” Mariyaa, yaati ilahudeesidi tuba, yaati cocaacoꞌoda haa heedi goó yondiida tindigateesii. Teꞌesii gi kaadi tuba, “Looimoo, bere ugu niĩ bacidi tuuꞌuna da Yeesu, sini kaade daqa gaã ilii qaasidi, ana hagay ow.” ");
INSERT INTO bds_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeesu gi eteedi tuba, “Mariyaa.” Ina gii fookiti, gi iti hari gimba gu Eburaanaisoo tuba, “Rabooni!” (Umaki maꞌaana dosi na “Maarimuu.”) ");
INSERT INTO bds_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu gi kaay sa ina tuba, “Hani hhanti nangusida, sa gimba kahha waauda rawaage daqa Taataage. Inkoo, taa⁄a daqa hhiee koii, sigi kaadee ubee ana ti waauuꞌumida rawaage daqa Taataage, hiĩ slime gu Taataa googuna. Ina ti Iliitleemu goy, slime unkuray see ti Iliitleemu googuna.” ");
INSERT INTO bds_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Da hheꞌesi, Mariyaa Magidaleena, yaa waauti gi kaawa kaydi sa sirakoomiisetee tuba, “Ana haguũ arimi Looimoo gu Goõ!” Slime ina gi kaadi sa inay gimbakee sliimaa dagaa ya⁄abi. ");
INSERT INTO bds_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hari khwayaiĩ kosi gu balotee da Jumaapiiri, sirakoomiisee hingaa slaslaydi daqa lenge waꞌay gu marage. Teꞌesii, inay gi khiidiniri afamaraaee, sa gimba yaa tlaꞌamuudiri Wayahuudi. Yeesu gigi iliica⁄i, gi qadidi tla⁄aã gooinay, gi kaay sa inay tuba, “Qasaw wane sliimaa haa unkuray.” ");
INSERT INTO bds_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Qatlay Yeesu giyaa ilii hheꞌesi kaawaraa gimbaki, sigigi laqami inay dabaiĩ kosi haa tluntlubaa dosi. Sirakoomiisee dosi gi hhaꞌaluumiti hari khisla, giyaa ilii aniri Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeesu sigigi kara kaay tuba, “Qasaw sliimaa wane haa unkuray. Idoo dinaa ilii ya⁄abi gooay ha Taataa, ana see hangu ya⁄aba unkuray.” ");
INSERT INTO bds_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ina giyaa ilii hheꞌesi kaawa gimbakee, gigi ilii hinpisi, haa gi kaay tuba, “Oowa Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Unkuray bere ilamooyintay tlakwaroo da hida, Iliitleemu slime giti ilamooyina, bere ga ilamooyintaaiiba, Iliitleemu slime gi ilamooyinaaba.” ");
INSERT INTO bds_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Inkoo, Toomaasi doó eteedine Irangimoo, leẽ gu sirakoomiisetira da mibi haa cada, yaa wanaaba haa danaee kosi, qatlay Yeesu giyaa ilii khay. ");
INSERT INTO bds_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teesaaqay, sirakoomiisetira waka, sugugi kaayri tuba, “Dandiray guũ arini Looimoo gu Goõ.” Toomaasi gi kaay sa inay tuba, “Etaa ⁄imbaaba, hati gesaa arima sletu gu sumaari dabaiĩ kosii, kara hati nangusa sletukee gu sumaari hari dinca doyi! Bere haniba hiilu⁄a dinca doyi waꞌay gu tluntlubaa dosii, ⁄imbaaba.” ");
INSERT INTO bds_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Qariqaaqari daa ilii buꞌudi balalu gweleti, sirakoomiisee da Yeesu, yaa hiikurunkuriti sliimaa kara waꞌay gu marakeesii, Toomaasi see yaa teꞌesii wana. Afamaraaee goõ digaamati khiidimi see, Yeesu gigi iliica⁄i kara, gi qadidi tla⁄aã gooinay, gi kaay tuba, “Qasaw wane sliimaa haa unkuray.” ");
INSERT INTO bds_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Da hheꞌesi gi kaay sa Toomaasi tuba, “Hinto dinca doogu nangusi tiꞌii haa arimi dabaiĩ koi. Slime tafaꞌasi daba googu lu⁄ii waꞌay gu tluntlubaa dooii. Ugu hhanti konta qiigiꞌimoo, ⁄imbi.” ");
INSERT INTO bds_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasi gugi ilaki⁄isi ina tuba, “Ye! Looimoo goy haa Iliitleemu goy!” ");
INSERT INTO bds_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu sugugi kaay tuba, “Hanti ⁄imbidii, sa gimba haã anti. Digi ⁄aafi hida hhakaꞌa guniĩ ⁄imbee kahhiyay arimaa!” ");
INSERT INTO bds_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu yaa yondiidi gimba waku wa⁄a gu bakaꞌasa pandaa da sirakoomiisee dosii, daaba handikiru kitaabukii. ");
INSERT INTO bds_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gimbaki duguũ handikimi sa unkuray, ma ⁄imbidiri tuba, Yeesu na Kristu, Nanku Iliitleemu. Slime, hari amoo da ⁄imbaraa Yeesu, ma slaydiri slafimaa uma gosii. ");
INSERT INTO bds_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Qariqaaqari gimbakee giyaa ilii cati, Yeesu gi iliica⁄i kara sirakoomiisee dosi kenga gu tlawa da didiri da Galilaayage, slime doó eteedine “Tlawa da Tiberiyaa.” Ina giyaa taqay iliica⁄i, ");
INSERT INTO bds_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simooni Peetiro, Toomaasi doó eteedine Irangimoo, Natanaeeli yaamulooay gu yaamu gu Kanaa da Galilaaya, haa yaꞌay cada gu Sebedaayo sliimaa haa sirakoomiisee waka cada da Yeesu, gonkoinaa yaa sliimaa wanay. ");
INSERT INTO bds_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simooni Peetiro, gi kaay sa danaee kosi tuba, “Ana ooyiru kaw samaakii.” Inay sugugi kaayri tuba, “Dandiray see hadakayna haa ugu.” Da hheꞌesi gii guniri masuwaage, gi waaudiri, tay tooinaa ooyinay samaakii tlawage. Teesaaqay see, amasi piray yaa slayriiba idoo lensee. ");
INSERT INTO bds_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Qatlay daa ilii tlaatleesi pisaraa, Yeesu gi qadidi kenga gu tlawateesii. Teesaaqay see, sirakoomiisetee gwaa baraslayiriiba tuba, ti ina. ");
INSERT INTO bds_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yeesu gigi maasi inay tuba, “Hhiee koi, haã slaydiriibaslii samaakii ma lensee?” Inay gi ilaki⁄isiri tuba, “Haã slayniiba.” ");
INSERT INTO bds_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeesu gi kaay sa inay tuba, “Lihhaw makumbaa dooguna hari bara da ⁄uya da masuwaa, ha slayday samaakii.” Inay gi teesaaqay laqiri, gi slayri samaakii wa⁄a hari khisla, digiraati amoolaa slanqadi hiiduukha makumbaa waꞌay gu masuwaage, sa gimba gu hacimaa gu samaakii. ");
INSERT INTO bds_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Teꞌesii sirakoomiisaykira daa slaiye ha Yeesu, gi kaay sa Peetiro tuba, “Hiĩ ti Looimoo gu Goõ!” Simooni Peetiro giyaa ilii akhasi gimbakee tuba, ti Looimoo gu Goõ, gi ila⁄utli qayru gosi, hingigi tosaa hiikwahhi tlawateesii. (Qatlay giyaa ilii masuwateesii wane, ina yaati baci jurungii dosi.) ");
INSERT INTO bds_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sirakoomiisetira waka gi sirakonti kenga gu tlawa naqatloo hari masuwaa, tay tooinaa dafimidiyay makumbatee, daa hacidi samaakii. Inay yaa segenge wanaaiiba haa kenga gu tlawa, tledaruũ kosi yaati hiiwanqudimisu gu yeꞌeeroo mibeeri mibi taqaaqay. ");
INSERT INTO bds_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Inay giyaa ilii dayri kenga gu tlawage, gi aniri aslaa da makara, rawaa kosii diĩ da⁄ami samaakii haa mukaatee. ");
INSERT INTO bds_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu gi kaay sa inay tuba, “Hintaa tiꞌii samaakii angaamaka gaani ooyintiri inkootuutuu.” ");
INSERT INTO bds_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Da hheꞌesi, Simooni Peetiro gii day waꞌay gu masuwaage, yaagii duukhi makumbatee kenga gu tlawa naqatloo. Makumbatee yaa hacidi samaakii gu denu mibeeri mibi haa mibeeri kooani haa tami, gimati konti see samaakii wa⁄a teesaaqay, yaa feehhitiiba. ");
INSERT INTO bds_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu gi kaay sa inay tuba, “Khocaa haamisaw guraiĩ.” Hhaku sirakoomiisee lensee gwaa hiidahhasu maasaraa ina tuba, “Ugu ti miyaa?” Sa gimba, yaa caahhiri gu lou tuba, yaati Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeesu gii oyi mukaatimokira, gi hadisi sa sirakoomiisee dosi. Slime, gii oyi samaakii, gi teesaaqay laqi. ");
INSERT INTO bds_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Haã yaati waa da tami, Yeesu iliicaca⁄uu gu sirakoomiisee dosi, qariqaaqari giyaa ilii slafi haa giyaa iliica⁄i ayisago. ");
INSERT INTO bds_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Qatlay inay giyaa ilii hheꞌesiri ⁄agoo, Yeesu gi maasi Simooni Peetiro tuba, “Simooni, nanku Yohaana, hani slaꞌadaa, ba⁄ay da danaee hhanki koku?” Peetiro gi kaay tuba, “Ye, Looimoo gu Goõ, ugu khuꞌuda tuba, hagu slaꞌa.” Yeesu sugugi kaay tuba, “⁄agimisi bee⁄u goy.” ");
INSERT INTO bds_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeesu gugi kara maasi waa da cadii, kakaana tuba, “Simooni, nanku Yohaana, hani slaꞌadaa?” Peetiro gugi ilaki⁄isi tuba, “Ye, Looimoo gu Goõ, ugu khuꞌuda tuba, hagu slaꞌa.” Yeesu sugugi kaay tuba, “Deꞌemi bee⁄u goy.” ");
INSERT INTO bds_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ina gugi kara maasi waa da tamii, kakaana tuba, “Simooni, nanku Yohaana, hani slaꞌadaa?” Peetiro gi slahhaai, sa gimba dugwaa maasi waa tami tuba, “Ye, Looimoo gu Goõ, ugu khuꞌuda tuba, hagu slaꞌa.” Yeesu sugugi kaay tuba, “⁄agimisi bee⁄u goy.” ");
INSERT INTO bds_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yeesu gi kaay sa ina tuba, “Gu lou, qatlay gaa ili kahhade qaraimoo, haa daamisidi qayroo haa gi waauti daqa ga ugu slaꞌade. Inkoo, qatlay gamaa ilii gadute, hamaa tafaꞌasida dabaiĩ koku, heedi waku gumaa ila⁄utlidisi qayroo, haa gugi leehhisi ugu daqa ga ilii slaꞌadaaba hadakawa ugu.” ");
INSERT INTO bds_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeesu yaati kaay gimbaki daqa Peetiroge, ma sugu laqami ti hari gwaaꞌaraa da malee slanqasa, ginirimaa daareesi Iliitleemu. Da hheꞌesi, gi kaay sa Peetiro tuba, “Na sirakonte!” ");
INSERT INTO bds_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Teꞌesii, Peetiro gii fookidi, gi arimi sirakoomiisaykira, daa slaiye hari khisla ha Yeesu, yaa khoci alunkoinaa. Sirakoomiisaykee naa ibiidi ilaciyaa loii haa Yeesu, qatlay gu ⁄agoo da khwayaiĩ, haa naa maasi Yeesu tuba, “Looimoo gu Goõ, ti miyaa nugu hiifookidi?” ");
INSERT INTO bds_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Inkoo, Peetiro giyaa ilii arimi sirakoomiisaykee, gi maasi Yeesu tuba, “Inkoo, Looimoo gu Goõ, hari hiĩ himaa malee gwaai?” ");
INSERT INTO bds_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu gugi ilaki⁄isi tuba, “Bere ana slaꞌa, ina ibiidi qatlaykaꞌa naqatloo gamaa ilii ki⁄e ana, ugu gu mala ilii slaꞌada? Ugu, hanisirakonte ana!” ");
INSERT INTO bds_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Teesaaqay, gimbakee gii qoomi tla⁄aã gu hhiee hhakira goó ⁄imbee Yeesu tuba, sirakoomiisaykee gwaaiyaaba. Yeesu yaa kaayiiba teesaaqay, yaati kaay tuba, “Bere ana slaꞌa, ina ibiidi qatlaykaꞌa naqatloo gamaa ilii ki⁄e, ugu gu mala ilii slaꞌada?” ");
INSERT INTO bds_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hiĩ naa sirakoomiisay gwaa arimu gimbaki haa gugi handikimi. Dandiray hati khuana tuba, ilatlawa dosi dati loi. ");
INSERT INTO bds_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeesu yaa yondiidi slime gimba waku wa⁄a haa dugwaa handikimiiba. Bere gimbakee sliimaa dugwaati handikina, goó ilatahhe khooroo sliimaa yaa aloo kontaaba daqa, da iliiqaasa kitaababaa daa aloo handikine.");
INSERT INTO bds_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hhia Teyofiilo, kitaabuu gooii gu pandaa hikira gwaa handikimi sa ugu, sugwaa handikimi gimba sliimaa, Yeesu giyaa yondiidi haa giyaa caacaahhamisi tlaatleesoo gu yondu gosaa, ");
INSERT INTO bds_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","balotira naqatloo duguraa ilii waaudi rawaa gu rawge ha Iliitleemu. Ina qatlay duguraa ilii kahhiye waaudimoo rawge, yaati gesaa hheꞌesi hadisi ilakaawa dosi hari amoo da Muuna gu Iliitleemu, daqa ya⁄abimiisee dosii giyaa hiileehhi. ");
INSERT INTO bds_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kara, qariqaaqari labaꞌasu gosi giyaa ilii cati, hingaati niki laqaaqaru ina lenkosi daqa dooinay, hari amamu paslaapasloo, gwaa laqamee gu lou tuba, ina hiti slafi. Balalu mibeeri cigahhage gii caca⁄i daqa dooinay, gi kakaami sa inay gimba gu Tawaaloo da Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kara da hheꞌesi, Yeesu qatlay giyaa ilii ⁄agiigine sliimaa haa ya⁄abimiisee dosi, giyaa ilakaay tuba, “Hhanti cira waautay tiaa yaamu gu Yerusaleemugo. Kara sigigi kaay tuba, tiꞌii baqada hiifadidu gu Taataa goy, giyaa ya⁄abi ma gesaa buꞌudi daqa doogunay, gaa ilii akhasidiri gooay gimbaki daqa dooaa. ");
INSERT INTO bds_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohaana haraa maꞌay kilesi hiinunqudiidimisi hida. Inkoo, kahhiyay balalu angaamaka Iliitleemu hiinunqudimisi unkuray hari Muuna gosi haa hari aslaa.” ");
INSERT INTO bds_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kara, Yeesu haa ya⁄abimiisee dosi giyaa ilii kurunkuridiri daqa lenge, gigi maasiri tuba, “Looimoo goori gu Goõ, qatlaykii gana ilii slaꞌadaa ilabuꞌuru dandiray tawaaloo gu Ruumigo, haa ma sandaa ki⁄isidi tawaalotira toori da hhapee doorii da Israeeli?” ");
INSERT INTO bds_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeesu gi ilaki⁄isi sa inay tuba, “Yondukee ti koogunaaba gu caahha qatlay haa baloo, daa qaasi ha Taataa goy hari ⁄uuru gosi. ");
INSERT INTO bds_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gimati teesaaqay see, qatlay Muuna gu Iliitleemu gimaa ilii ⁄eetiye daqa doogunay, unkuray maa slayday ⁄uuru. Kara maa kakantay gimba gooi Yerusaleemuge, daqeemoo sliimaa gu Yudaaya, Samariyaa haa khooroti sliimaa.” ");
INSERT INTO bds_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Qariqaaqari giyaa ilii hheꞌesi kaawa gimbaki, tay gi tooinaa khuꞌunay, dugurigi tosaa waaudi rawaa gu rawge ha Iliitleemu. Tlongiya gugi ilaslaabidi, gwaa hiidahhasiriiba kara arimaa. ");
INSERT INTO bds_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Qatlay giyaa ilii karahhasiri ilaa koina sa khuꞌuduũ naraꞌa rawaa gu rawge, duguraa ilii waauuꞌumidiye, cirakiray hhawatee cada gwaa daamisee qayroo gu ⁄abakwi, gi qadimidiri ilaciyaa koinay, ");
INSERT INTO bds_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","gi kaayri tuba, “Unkuray hida hhanki gu Galilaaya, siĩ soꞌoyi qadimitiri tiꞌii toogunaa khuꞌuntay rawaa gu rawge? Nama Yeesuki leẽ, dariĩ waaudi rawaa gu rawge daqa doogunaa, maa kara ki⁄i khoorotii, nama teesaaqay guũ ilii antiri gooay, giĩ ilii waaudi rawaa gu rawge.” ");
INSERT INTO bds_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Inkoo, qatlay Yeesu duguraa ilii waaudi rawge, ya⁄abimiisee yaa rawaa gu oõ wakuu wanay, uma gosi na Miseyituuni. Da hheꞌesi gi ki⁄iri yade Yerusaleemuge, gi khociri khocu gu baloo da Sabaato. ");
INSERT INTO bds_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Qatlay giyaa ilii dayri yade Yerusaleemuge, gii guuma kayri waauu gwaa rawaa gu marage waara, daqa daa ilii ibimaamidiye Peetiro, Yohaana, Yakoobo haa Andareyaa, Filiipo haa Toomaasi, Batolimaayo haa Mataayo, Yakoobo nanku Alifaayo, Simooni daa Seloote eteediidine haa Yuuda nanku Yakoobo. ");
INSERT INTO bds_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Balalu sliimaa ya⁄abimiisetee goõ gi ilakoniri firoo da Iliitleemu saga lenge. Inay yaa sliimaa wanay haa tigay wakinay, Mariyaa iyoo dosi Yeesu haa hhiee kosi. ");
INSERT INTO bds_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Balalu hhakeesii Peetiro gi qadidi tla⁄aã gu hida gwaa ⁄imbee Kristu, sliimaa dooinaa yaa wanay hida miyaa leẽ haa mibeeri cada taqaaqay. ");
INSERT INTO bds_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Da hheꞌesi gi kaay tuba, “Hhiee koi, kwanda gi buꞌute, handikaa daa tletimi wakaꞌalee ha Muuna gu Iliitleemu hari afa gu mutemi Dawdi, yondukee gu Yuuda Isikariyooti, gwaa giyaadisu hida hhakira gwaa owee Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuuda yaa danaꞌa goori, daa faadi sliimaa haa dandiray. Ina see yaa yondiidi yonduki gu hiiqoomeesa gimba gu Yeesu.” ");
INSERT INTO bds_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yuudaki yaa kirigi qaymoo hari peesaykira giyaa slay hari amoo da tlakwi. Inkoo, qatlay giyaa ilii taysi wane qaymoteesii, gi tosaa huui, guraꞌa gosi gii feehhidi tla⁄antla⁄a, waqanqatatee goõ yaatii ca⁄iri khoorooge. ");
INSERT INTO bds_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hida sliimaa gwaa ibimaamidee yaamu gu Yerusaleemuge, gi akhasiri gimbakee gu Yuuda gwaa hiica⁄u. Da hheꞌesi qaymotee girigi tooinaa ayiri uma hari gimba gooina na “Akelidaama,” maꞌaana dosi na “qaymoo da ceedee.”) ");
INSERT INTO bds_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peetiro gi ilakoomi kakaaru tuba, “Mutemi Dawdi yaa handikimi kitaabuu gu Daareesooge tuba, ‘Mara gosi dugu hhanti ilii qaasi idoo lensee, kara teꞌesii, marakeesii heedi lensee hhanti ibiidi.’ Kara, ‘Heedi waku hiioye, yondu gosi giyaa yondimaamidiye.’ ");
INSERT INTO bds_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Inkoo, kwanda ga hiileehhane heedi leẽ, ma qadidi daqa da Yuudage. Gwii leehhane, tla⁄aã gu hhakiraa goó sliimaa waaree ha dandiray. Qatlay sliimaa Looimoo gu Goõ Yeesu giyaa iliiwane haa giyaa ilii hhiyumaamidiye haa dandiray ");
INSERT INTO bds_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","yadaa loaa tlaatleesoogo. Kara, qatlay Yeesu dugwaa ilii nunqudisi ha Yohaana maꞌayge, balotira naqatloo ina duguraa ilii waaudi rawaa gu rawge daqa dooraa. Inkoo, tla⁄aã gooinay leẽ kwanda hingi ilagaasiye haa dandiray, masaydii pahha gwaa arimu, idoo Yeesu giyaa ilii slafi ayisago.” ");
INSERT INTO bds_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Teꞌesii ya⁄abimiisetee gii leehhidi hida cada, Yoseefu, uma gosi gu deneꞌee na Barsaaba (kara daa eteediidine ha wakinay na Yuusto), haa Matiyaasi. ");
INSERT INTO bds_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Da hheꞌesi gi firiniri tuba, “Looimoo goori gu Goõ, gu lou, ugu khuꞌuda muunaiĩ gu hida goõ, idoo gi iliiwanee. Inkoo, sandi laqante, heedi gaã ugu hiileehhedi tla⁄aã gu hida hhankii gu cadage, ");
INSERT INTO bds_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ma hiioy daqa da yonduki haa ya⁄aboti daa may ha Yuuda, gi tosaa hiifookidi ⁄imbaraa da Yeesugo, gi waaudi daqa daraa hiiboo⁄odi ina.” ");
INSERT INTO bds_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Da hheꞌesi gii slaslakhiri kuura, giyaa ilii faadiri, kuura gi tosaa hiihuuꞌudi daqa Matiyaasige, dugugi tosaa ilafaadi sliimaa haa ya⁄abimiisetira wakinay da mibi haa leẽ. ");
INSERT INTO bds_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Qatlay daa ilii day baloo da losona gu Pentekoositi hida gwaa ⁄imbee Yeesu, hingaa slaslayri daqa lenge yaamu gu Yerusaleemuge sa losonakee. ");
INSERT INTO bds_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Qatlay giyaa ilii kurunkuridiri teꞌesii, cirakiray gi akhasiri afoo ubee, da pupukhumoo gu caaqwa da didiri. Afotee yaagii⁄eti rawaa gu rawgo, gii gunti hari khisla marakeesii giyaa ilii ibiidiri. ");
INSERT INTO bds_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Teꞌesii, daagii ca⁄i daqa dooinay idadu gwaa hiiqoomee ubee, cufeeri gu buruburiya da aslaa pahha. Cufeeri hhakee hingigi deehhiniri, gii ibinaa kayri rawaa gu sagaiĩ koinay. ");
INSERT INTO bds_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Da hheꞌesi, gonkoinaa digigi hacisi Muuna gu Iliitleemu, gi tlaatleesiri cocoꞌomoo gimba waku gu ⁄abu, idoo sigaa ilii qay gooay ⁄uuru ha ina. ");
INSERT INTO bds_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Inkoo qatlaykeesii, yaa wanay Yerusaleemuge Wayahuudi daa ibimaamida teꞌesii, hida gwaa firiirimee Iliitleemu, gwaa hhapapu wa⁄a dahhee. ");
INSERT INTO bds_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Qatlay giyaa ilii akhasiri afotee, raqatee da hida yaagii kurunkuriti, ma ariniri idoo daa hiica⁄adi. Teꞌesii gonkoinaa yaati bakairi, digirigi slanqadi caahharaa, idoo giyaa ilii akhasiri hida hhakee goó ⁄imbee Iliitleemu cocoiyay hari gimba gooina loi. ");
INSERT INTO bds_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gonkoinaa yaati bakairi sumuku, hirigii tlairi, hingigi maamisiri inay haa inay tuba, “Ayi yuꞌudaa! Hida hhanki goõ gu cocaacoee gimba goori, pasliyaaii caba ti looee da Galilaaya loi? ");
INSERT INTO bds_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Inkoo, hida hhanki dandiray gonkotaa hagi malee akhaakhamisana inay hari gimba goori dandiraa laqwali? ");
INSERT INTO bds_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kara, tiꞌii ti wanay hida gu hhapapu paslaapasloo, Partii, Medii haa Elamiyaa, kara looee daa Mesopotaamiyago dahha, Yudaaya, Kapadookiya, Pontoo, Aasiya, ");
INSERT INTO bds_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigiiya, Pamfiliyaa, Misiri haa daqeemoo gu hhapee da Liibiya gu ilaciyaa waaree haa hhapee da Kireene, daa niini⁄idi ha tlawa da didiri, kara haa dahaa gwaa yada dahhee yaamu gu Ruumi, ");
INSERT INTO bds_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Wayahuudi haa hida gwaa hiiguumee diini da Wayahuudige). Hida wakinay yaa Kireete dahhiyay tlawa da didirigo, wakinay yaa hhapee da Araabiya dahhiyay. Kaslenkwaa, dandiray gonkotaa kahhana inay hagitooraa akhaakhamisana cocoiyay hari gimba goori loi, idoo Iliitleemu giyaa ilii yondiidi gimba gu didiru gwaa bakaꞌasu!” ");
INSERT INTO bds_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hida hhanki gonkoinaa gi ilakoniri bakaꞌaraa, hirigi slanqadiri caahharaa gimbaki, tay hingi tooinaa maamisiyay inay haa inay tuba, “Inkoo maꞌaana da gimbaki na mala?” ");
INSERT INTO bds_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Teꞌesii wakinay gi tlaatleesiri yaqaayiru sirakoomisetira da Yeesu tuba, “Hida hhanki hinti ooniimidiri sa difaayti da ⁄abi giĩ kitahhaniri!” ");
INSERT INTO bds_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Da hheꞌesi Peetiro ginaa ilii qadidi sliimaa haa ya⁄abimiisetira daa mibi haa leẽ. Hari afoo da didiri gi tlaatleesi kakaaru sa raqati da hida gi kaay tuba, “Ye deneꞌee koi Wayahuudi haa unkuray gonkokunaa goó tiꞌii ibiidee yaamu gu Yerusaleemuge, itatiisa naraꞌa, ma sangu kaay gimbaki gwaanii ca⁄u.” ");
INSERT INTO bds_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hida hhanki hinti ooniimidiriiba, unkuray gooay idoo gaã ilii ilahudeesidiri! Inkoo ma dati kahhi heetlawaa. ");
INSERT INTO bds_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gu lou, gimbaki gwaanii ca⁄u daqa doorii, na gimba daa kaay wakaꞌalee ha Iliitleemu hari amoo da tletimiisay gosi Yoeeli tuba, ");
INSERT INTO bds_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Balalu gu hiifaakooge, Iliitleemu yaati kaay tuba, ‘Sangumaa hiituutuqa Muuna gooi daqa hida sliimaage. Yaꞌay kokuna gu hhawatee haa gu tigay tletinay haa gi kakaanay gimba gooi, kara qaraiya dooguna maa arinta ilahudaa daqa dooaa, haa gaduũ kokuna see, maa tletinay tletaa gwaa daqa dooi dahhee. ");
INSERT INTO bds_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gu lou, gimati daqa tongee dooi see, sliimaa da hhawatee haã da tigay see, balalu hhakeesii, sigimaa hiituutuqa Muuna gooi, inay see maa tletinay, gi kaayay gimbaki koi. ");
INSERT INTO bds_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kara maa ⁄isima gimba gu denu gumaa bakaꞌasa hida rawge, haa hamaa laqama gimba gu bakaꞌasa tiꞌii khoorotii, damaa wana ceedee, aslaa haa tlonga da kooma eehha guyii loou. ");
INSERT INTO bds_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Letu maatii fookita, maati ⁄oona tleehhita daqa dooinay, kara slehheẽ see, maati daa⁄aday ceedee pahha, damaa ilii kahhiye dawaraa balotee da kaari, da kooma hhoinay gu Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kara, damaa ilii kahhiye dawaraa baloti, kila heedi gumaa ilii⁄aa⁄aa uma gu Taataa Iliitleemu, dugumaati ilabuꞌuna ha ina.’ ” ");
INSERT INTO bds_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peetiro gi ilakoomi gimba tuba, “Ye hida gu Israeeli, itatiisa gimbaki! Yeesu gu Nasareeti yaati heedi daa hiitlaaꞌasi pandataa daqa doogunay ha Iliitleemu hari amoo da hiitlaaꞌasa ⁄uuru gu yondu gu denu haa hari amoo daa bakaꞌasidi hida, idoo unkuray ga ilii khuꞌudee gooay, guti lou. ");
INSERT INTO bds_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Heediki, Yeesu daa hadisi dabaiĩ kokunay ha Iliitleemu hari ilakhuukhuꞌusaraa haa taariru gosi giyaa ina khuiye wakaꞌalee. Kara unkuray hari iliiawaraa da hida gu tlakwi, gugi toogunaa tluhhusidiri musalaabage, gugi gaasidiri. ");
INSERT INTO bds_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Inkoo, Iliitleemu giyaagi tosaa slafisi ina tuuꞌunago, dugwaagii ca⁄asi slahhaaꞌamee da ilahufidukeesaa gu didirugo gu gwaaꞌaraa. Sa gimba gwaaꞌaratee see yaa aloo hiidahhasidaaba oowaraa ina ayisage. ");
INSERT INTO bds_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mutemi Dawdi yaa kaay wakaꞌalee loi gimba gu Masiiya tuba, ‘Balalu sliimaa Looimoo gu Goõ hagwaati arimi pandaa dooii wana, sa gimba hari bara da daba gooi wana gu ⁄uya, ana ma may dakhadakhamoo. ");
INSERT INTO bds_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Muuna gooi hhaꞌaluudi sa gimbakee, kara afa gooi kona hhaꞌaloo da didiri, slaqwa dooi see maa ibita iliipaꞌaruuge, ");
INSERT INTO bds_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sa gimba ugu muuna gooi gu maydaaba khonsleebaage, kara Heedi Googu Gwaa tlintiꞌisidi, hagu maydaaba, ma gubi ayisage. ");
INSERT INTO bds_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ugu siniĩ laqanti amoo da ibinaa da loi, kara sini qayda hhaꞌaloo da didiri sliimaa haa ugu daqa ga iliiwante.’ ” ");
INSERT INTO bds_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peetiro gi kara kaay tuba, “Ye hhiee koi, ana sangu slaꞌa kaawaraa unkuray hari ⁄atlimaa gimba gu okookoo goori mutemi Dawdi. Ina yaati gwaai, dugugi qaasi, sa gimba ayisa dosi tosaa kahhada ti wanta yaamu kotii letuti naqatloo. ");
INSERT INTO bds_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Inkoo, ha khuana mutemi Dawdi yaati tletimiisay gu Iliitleemu. Kara yaati khui Iliitleemu yaatii fadidi, gi seelimi tuba, ‘Maa qaasi heedi leẽ tla⁄aã gu laqwaloo dosii, ma ibiidi kitiĩ gosii gu mutemiꞌisooge.’ ” ");
INSERT INTO bds_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Iliitleemu yaa iliiay mutemi Dawdi, ma arimi gimba gumaa hiica⁄a pandaage, gi kaay gimba gu slafaraa da Kristu ayisago tuba, gwaa aloo mayaaba ina ayisage, slaqwa dosi see giyaa mayaaba, ma gubidi ayisage. ");
INSERT INTO bds_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Heediki Yeesu, daa slafisi ha Iliitleemu yaagii ca⁄i ayisago, kara dandiray gonkotaa ti masaydii da gimbaki gu lou sangu cocaacoe. ");
INSERT INTO bds_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Inkoo, Yeesu dugwaa ilii tlaysi rawaa gu rawge ha Iliitleemu, dugugi daareesi hari khisla, hari ibiidisaraa hari bara da daba gosi gu ⁄uya kitiĩ gosii. Yeesu gi slay Muuna gu Taataa gosi giyaa hiifadidi taai, sugumaa hadisi. Muunakee gu Iliitleemu naa hiikuꞌusi gimbaki ga khuꞌuuꞌuntee, haa ga akhaakhamisideei letuti. ");
INSERT INTO bds_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mutemi Dawdi yaati tlayiiba rawaa gu rawge da Yeesu gooay, kaslenkwaa, yaati kaay tuba, “Taataa Iliitleemu yaati kaay daqa Looimoo gooii gu Goõ tuba, ‘Ibiidi hari bara doyi da ⁄uya, ");
INSERT INTO bds_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","qatlaykaꞌa naqatloo gamaa ilii qaase fa⁄ayaa doogu, biraa gu yeꞌeeroo kokuu.’ ” ");
INSERT INTO bds_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peetiro gi ilakoomi gimba tuba, “Inkoo, hida goõ gu hhapee da Israeeli, unkuray kwanda ga caahhadeei gimbaki gu Yeesu gaa tluhhusidiri musalaabage. Namati inakee leẽ dugunaa hiileehhi ha Iliitleemu, ma Looimoo goori gu Goõ tleehhidi haa ma Kristu tleehhidi.” ");
INSERT INTO bds_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Qatlay hida hhakee giyaa ilii akhasiri gimbaki gu Peetiro, digigi da⁄i muunaiĩ koinay hari khisla. Da hheꞌesi gi maasiri Peetiro haa ya⁄abimiisee wakinay tuba, “Ye hhiee koti, inkoo ti malee laqana?” ");
INSERT INTO bds_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peetiro gi ilaki⁄isi sa inay tuba, “Fookidaaruu daqa Iliitleemuge amamu kokunaa goõ gu tlakwigo. Kara hida sliimaa digii nunqudimisiye maꞌayge hari uma gu Yeesu Kristu, ma sangu ilamooyimi ha Iliitleemu tlakwaroo dooguna. Unkuray ma slaydiri hiifadidukira gu Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Hiifadiduki dugwaati qay ha Iliitleemu sa unkuray haa yaꞌay kokuna, hida hhakira goõ goó hhapapu gu segenge waaree, haa hida sliimaa damaa ⁄oo⁄iye ha Taataa Iliitleemu, Iliitleemu goori.” ");
INSERT INTO bds_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peetiro gigii gadimi inay hari gimba waku wa⁄a, kara gigi tlaatlaqasi tuba, “Hangu ilabuꞌuntee unkuray kilakokuna haa laqwaloti da tlakwi.” ");
INSERT INTO bds_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Inkoo, hhakee gwaa ⁄imbee gimbakee kosi, digigii nunqudimisi maꞌayge. Letutee leẽ yaa hida elefu tami daa hiirogisi daqa raqa da hida gwaa ⁄imbee Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Da hheꞌesi hida hhakee gwaa ⁄imbee Yeesu, gi hadisiri qatlay gooina hari maguuma, ma digi caacaahhamisi ha ya⁄abimiisetee gimba gu Yeesu. Kara ibiidiye daqa lenge, fandakumisiye mukaate, gi ⁄aginay daqa lenge sa hiislawaraa da gwaaꞌaraa dosi, kara firiirinee Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hida wakinay gu Yerusaleemu gugi muriidiri Iliitleemu hari khisla. Hari amoo da ⁄uuru gosi ya⁄abimiisee da Yeesu yaa laqaaqanti gimba wa⁄a gwaa bakaꞌasu hida. ");
INSERT INTO bds_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hida hhakee goõ gwaa ⁄imbee Yeesu, yaa sliimaa ibiidiri daqa lenge sa firoo da Iliitleemu. Kara hingaati wariiqaqaaqayay idadu koina goõ giyaa koneei inay haa inay. ");
INSERT INTO bds_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kara, inay gi tlaatleesiri kirigiruu khooslay gooina waku giyaa konee, hingigi deehhiniri peesay giyaa slayri, hida sliimaa gi slayri, idoo giyaa ilii slaiyeei gooay. ");
INSERT INTO bds_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Balalu sliimaa gi ilakoniri hiikurunkurimidu sa firoo mara gu didiruge gu Iliitleemu. Inay gi fandakumisiri mukaate maraai koinay, gi ⁄aginiri ⁄agoo dooina daqa lenge hari muunaiĩ gu qasaw haa cabuuma, ");
INSERT INTO bds_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","gi hhaꞌaleesiri Iliitleemu, gi muunaiĩ boo⁄eesiri hari khisla hida sliimaa gu yaamu gu Yerusaleemu. Kara balalu sliimaa daqateesii lenge Iliitleemu yaa tosaa hiiroogiigimisi raqa dooinay hida wakinay giyaa ilabuꞌuuꞌune. ");
INSERT INTO bds_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Letu waka Peetiro haa Yohaana yaa hadakakaakayay mara gu didiruge gu Iliitleemu, daa iliifuuruuꞌudi letu, hikee na qatlay Wayahuudi giyaa ilii daareeremisiyee Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Inkoo, yaa wana heedi waku gwaa yeꞌeeroo tlakwaakwaw taysaa loaa qatlay dugwaa ilii laqwali. Balalu sliimaa dugwaati geregediidina ha hida kosi, gugi tooinaa ibiidisiyay ilaciyaa gu kaꞌafu wakuu uma gosi na “Kaꞌafu guraa hiiboo⁄u,” sa firoo da peesay daqa hida gwaa hiigumagaaguumee mara gu didiruge gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Qatlay giyaa ilii arimi Peetiro haa Yohaana yaa daadaauusiri hiiguuma waꞌay gu mara gu didiruge gu Iliitleemu, gigi firimi inay, ma sugu qayri peesay. ");
INSERT INTO bds_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Teꞌesii Peetiro haa Yohaana gugi ilii kaasiri ilaa koina. Da hheꞌesi Peetiro gi kaay sa ina tuba, “Handaa yuꞌute!” ");
INSERT INTO bds_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ina gi tosaa ilii kaasi inay, ina beela slay idoo waka daqa dooinaa. ");
INSERT INTO bds_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Da hheꞌesi Peetiro gi kaay sa ina tuba, “Dandiray konaaba peesay ma sahaabu see da qawaraa sa ugu, inkoo, idotaꞌa ga koomee suguni qaw. Hari uma gu Yeesu Kristu gu Nasareeti, tlayii, khoce!” ");
INSERT INTO bds_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peetiro gigi tosaa ooyi heedikee daba gu ⁄uyage, gigii tlaysi, gi qadidi hari yeꞌeeroo kosi ina lenkosi. Cirakiray yeꞌeeroo haa emberekay gosi gwaa kufimidee, digigi hhoeesi, gi slayri ⁄uuru. ");
INSERT INTO bds_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Heedikee gi tlo⁄osi rawaage hari yeꞌeeroo kosi, gi qadidi haa gi tlaatleesi khocu. Da hheꞌesi, gi tosaa gii day waꞌay gu efeenaa da mara gu didiruge gu Iliitleemu sliimaa haa Peetiro haa Yohaana tay tosaa tlo⁄otlo⁄omisi, kara tosaa hhaꞌaleemisi Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hida sliimaa gwaa ilii aniri khoci tay tosaa hhaꞌaleemisi Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","gi caahhiri tuba, yaati heedikira gwaa ibimaamida kenga gu “kaꞌafu guraa hiiboo⁄uge” gu mara gu didiru sa firoo peesay. Teꞌesii hida goõ digigi iliihaci ha amaaoo, yaati bakairi hari khisla, sa gimbakee gwaa hiica⁄u daqa dosii. ");
INSERT INTO bds_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inkoo qatlay heedikee daa hhoeesi giyaa ilii kahhiye hiĩ tosaa gii nakafi daqa diĩ Peetiroge haa Yohaana, teꞌesii hida goõ yaati bakairi. Inay yaagi tlaatleesiri siragusiru inay, mara gu didiruge gu Iliitleemu daa eteediidine “Waauu gu Solomooni.” ");
INSERT INTO bds_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Qatlay Peetiro giyaa ilii arimi raqatee da hida daa hiikurunkuriti, gi kaay sa inay tuba, “Ye hida gu Israeeli, hariĩ soꞌoyi hiitlaꞌadiri sa gimbaki? Haã soꞌoyi bakaꞌadiri handaagi ilii kaasidiri ilaa ubee, heediki hintii dahhasi pahha khocu, sa gimba gu ⁄uuru goori haa muree doori pandaa da Iliitleemuge? ");
INSERT INTO bds_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Teesaaqay gooba! Iliitleemu gu Aburahaamu, Iliitleemu gu Isaaka, Iliitleemu gu Yakoobo haa okookoiĩ koti, niĩ daareesi yondimiisay gosi Yeesu, hari amoo da hhoeesa heedikee. Unkuray Yeesuki gwaa taatahhadiri dabaiĩ gu tawaaloo da Ruumige, duguma gaasi. Slime, gugi tlankidiri pandaa da Gafana Pilaatu, gimati qatlay giyaa iliislaiye kereꞌesa gimba, magu geemay ina. ");
INSERT INTO bds_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Teꞌesii unkuray hagugi tlankidiri heedikira guba tlakwaroo haa gwaa kooma ibinaa daa tafaꞌadi. Unkuray hagi firintiri sangumay ca⁄asi heedi gwaa cu⁄u hida hari qwaa⁄ii. ");
INSERT INTO bds_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kara, unkuray hagugi gaasidiri heedi gu kooma tlaatleesoo da hhaahhiyoo gu slafimaa. Teesaaqay, Iliitleemu gwaa slafisi gwaagii ca⁄asi ayisago. Gu lou, dandiray ti masaydii gu gimbaki sangu kakaakane. ");
INSERT INTO bds_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","⁄imbaraa da heediki daqa uma gu Yeesuge, niĩ qaydi ⁄uuru sa heediki guũ antiri tiꞌii ga khuꞌudee. Gu lou, ti hari ⁄uuru gu uma gu Yeesu haa hari ⁄imbaraa doó khawa hari amoo da Yeesu, niĩ heediki hhoeesidi sumuku, idoo gaã ilii antiri gooay pandaa doogunay unkuray gonkokunaa. ");
INSERT INTO bds_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Inkoo, hhiee koi, ana khua unkuray haa hida kokuna gu deni gu tawaalooge waaree, Yeesu gwaati gaasidiri bawma da hhidima doogunay. ");
INSERT INTO bds_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kara, hari amoti Iliitleemu yaatii gaasi kaawaratira tosi da wakaꞌalee hari amoo da tletimiisee dosi goõ tuba, ‘Kristu kwanda dugu labaꞌasiye.’ ");
INSERT INTO bds_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Inkoo, fookidaaruu amamu kokunaa gu tlakwigo, iliipaꞌamu Iliitleemu, ma sanguyii ca⁄asi sukumu tlakwaroo dooguna. ");
INSERT INTO bds_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Teesaaqay laqa, ma slaydiri ⁄uuru gu hii⁄abeesa muunaiĩ kokuna daqa Taataa Iliitleemugo goó sliimaa waara haa dandiray. Kara ma sandaa ya⁄abi Kristu daa hiileehhi wakaꞌalee sa ilabuꞌuruu haa sa tawaaliru dandiray, hinti Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ina kwanda gi ibiidiye rawaa gu rawge, qatlay Iliitleemu gimaa ilii hheꞌesiye naqatloo hii⁄abeesa idadu sliimaa, giyaa ilii kaay gooay wakaꞌalee hari amoo da tletimiisee dosi giyaa tlintiꞌisi ina sa yondu gosi. ");
INSERT INTO bds_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musaa tletimiisay yaati kaay tuba, ‘Taataa Iliitleemu, Iliitleemu googuna maa hiitlaysi sa unkuray tletimiisay da ana gooay tla⁄aã gu hhiee kokunaa loaa. Kara, kwanda gamaa itatiimisidee gimba gosi goõ gimaa kaaye sa unkuray. ");
INSERT INTO bds_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Heedi gumaaba itatiisa gimba gu tletimiisayki, dugumaati hhamisi sumuku haa dugumaati tlintiꞌisi daqa raqa da hida kosaa koraraa haa koraraa goóba hiifaakoo, dugugi toosaa hhamisi sumuku ha Iliitleemu.’ ");
INSERT INTO bds_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Peetiro gi ilakoomi gimba tuba, ‘Tletimiisee goõ da Iliitleemu, tlaatleesi qatlay gu Samweeligo haa wakinay gwaa sirakoomee ina, gonkoinaa yaa kakaaniri sa hida gimbaki gu hiicacaaca⁄a balalu hhankii.’ ");
INSERT INTO bds_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Unkuray ti yaꞌay gu tletimiisetee haa gu ila⁄imbidu gu Iliitleemu daa boo⁄imisi haa okookoiĩ koti, gi kaay sa Aburahaamu tuba, ‘Hari amoo da laqwaloo doogu, kabiraa goõ da khooroti, dagamaati ⁄aafi.’ ");
INSERT INTO bds_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Qatlay Iliitleemu giyaa ilii slafisi haa giyaagii ca⁄asi ayisago yondimiisay gosi Yeesu, giyaati geesaa ya⁄abi daqa doogunay hida gu Yahuudi, ma danguma ⁄aafi hari amoo day fookaraa unkuray gonkokunaa amamu kokunaa gu tlakwigo.” ");
INSERT INTO bds_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Qatlay Peetiro haa Yohaana giyaa ilii kahhiyeei kakaaruge sa hida, hhapalooee da Iliitleemu haa heedi gu didiru gu sirikaarii doó ga⁄awa mara gu didiru gu Iliitleemu haa raqa waka da diini da Yahuudi, uma gosi na Sadukaayoo yaagi ilii tlairi inay. ");
INSERT INTO bds_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hida hhanki yaa slahhaahhaairi hari khisla sa Peetiro haa Yohaana, sa gimba giyaa caacaahhaahhamisiyee hida. Kara yaa kakaakanay sa inay tuba, daqa Yeesuge hida gwaa kaka⁄ee maa slafiyay yaagii ca⁄iyay ayisasugo. ");
INSERT INTO bds_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Da hheꞌesi gigi tooinaa ooyiniri, gigi ilapinginiri jeerage heetlaalee dosi naqatloo hari heetlawaa, sa gimba yaa khwayaiĩ. ");
INSERT INTO bds_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kara, tay hida wa⁄a tla⁄aã gu hhakiray gwaa itatiitimisee gimba gu Iliitleemu daa kakaakane Peetiro haa Yohaana, gi tooinaa ⁄imbiri gimbakee, faadoo da hida gwaa ⁄imbee Yeesu gi daadi elefu kooani. ");
INSERT INTO bds_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Heetlaalee dosii, hida gu deni gu Yahuudi, gaduũ haa maarimamaa da sariyaa da diini, gii kurunkuridiri sliimaa yaamu gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tla⁄aã gu hida hhakeesii gu deni, Anaasi hhapalooay gu didiru gu Iliitleemu yaa wana. Slime haa hhapalooee wakinay da deni da Kayaafa gooay, Yohaana, Alekisanda haa hida wakinay gwaa koomee hiidayuuma haa hhapalooay gu didiru. ");
INSERT INTO bds_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Teꞌesii, hida hhakee gu deni gi kaayri sa sirikaarii daa ga⁄aa⁄awa Peetiro haa Yohaana, ma giraa khayri pandaa dooinay, giyaa ilii qadimidiri teꞌesii, gi tlaatleesiri cangicangimisu tuba, “Unkuray ha miyaa sangwaa qay ⁄uuru haa hari uma gu miyaa gurinaa hhoeesidiri heediki?” ");
INSERT INTO bds_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Da hheꞌesi Peetiro dugugi hacisi Muuna gu Iliitleemu, gi ilaki⁄isi sa inay tuba, “Unkuray hida gu deni haa gaduũ gu hida gu Israeeli! ");
INSERT INTO bds_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Letuti dandiray bere handi cangicangimisiday, sa gimbaki gu hhou gwaa yondiidani daqa heedikii gwaa yeꞌeeroo tlakwaakwaw, kara handi cangicangimisiday idoo dugwaa ilii hhoeesi, ");
INSERT INTO bds_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","inkoo ha slaꞌana unkuray haa hida goõ gu hhapee da Israeeli, ma caahhadiri gimbaki tuba, ‘Heediki guũ qadidu tiꞌii pandaa doogunay, haraati uma gu Yeesu Kristu gu Nasareeti hhoay sumuku. Hiĩ gwaa hiitluhhusidiri musalaabage, kara Iliitleemu gwaagi tosaa slafisi haa gwaagii ca⁄asi ayisago!’ ");
INSERT INTO bds_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeesuki na ina daa ilakhuukhuꞌusi Handikaa da Iliitleemuge tuba, ‘Ina na tlaa⁄atira gaa siꞌidiri unkuray hida goó tleehhee maraai, kara gi tlaa⁄a da didiri tleehhidi da sooma doó kaari hari khisla.’ ");
INSERT INTO bds_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Inkoo, hhaku heedi waku gu hiidahhasa ilabuꞌuru hida tlakwaroogo. Yeesu kilesi nii dahhasi, sa gimba hhaku uma waku tiꞌii khoorotii, daa qay sa ilabuꞌuru hida, kara hariti umakee kilesi, dandirii dahhasi ilabuꞌuru.” ");
INSERT INTO bds_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Qatlay hida hhakee gu deni giyaa ilii aniri ⁄atlimaa gu Peetiro haa Yohaana, gi baraslayiri tuba, inay yaati hida gu taqaaqay kilesi, yaa sominiriiba. Kara, inay yaati bakaakairi hari khisla, gi caahhiri tuba, hida hhanki yaa sliimaa wanay haa Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Slime giyaa ilii aniri heedikee daa hhoeesi hiĩ qadidi teꞌesii haa inay, hida hhakee gu deni yaa konaaiiba ilaki⁄isaraa lensee daqa diĩ Peetiroge haa Yohaana. ");
INSERT INTO bds_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sa gimbakee hida hhakee gu deni gi kaayri sa hida koina goó ga⁄awee, maa hiica⁄asiri Peetiro haa Yohaana waaukeesaa hingaa ilii slaslaaslayee balasateesii da didiri da Wayahuudi. Inay gi meetiri teꞌesii gi tlaatleesiri idara inay haa inay, ");
INSERT INTO bds_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Hingigi maamisiri tuba, “Inkoo, hida hhanki hagiti malee laqana? Yuꞌudiyaa, hida sliimaa goó tiꞌii ibiidee Yerusaleemuge ti khuiyay inay hiĩ laqaniri yondu gu didiru guũ bakaꞌasu hida, kara dandiray haguu dahhasanaaba tlanka. ");
INSERT INTO bds_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Inkoo, ba⁄ay giti tlaatlahhasanee, ma mayri hiiqoomeesa gimbaki daqa hidage, kwanda hagi tlaatlahhasane hida hhanki, ma mayri kara kakaaru gimbaki sa heedi lensee hari umaki.” ");
INSERT INTO bds_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Da hheꞌesi hida hhakee gu deni, gi kara eteediri Peetiro haa Yohaana waꞌay gu waauuge, gigii gadiniri tuba, “Kara maa hhanti kakantay sumuku ma caacaahhamisu see hida hari uma gu Yeesu.” ");
INSERT INTO bds_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Inkoo, teꞌesii Peetiro haa Yohaana gi ilaki⁄isiri sa inay tuba, “Hangu ilatahhadee unkuray kilakokuna. Gimba kaloo naraa hiiboo⁄i pandaa da Iliitleemuge, itatiimisu unkuray baku ti itatiimisu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dandiray hiidahhasanaaba mawaraa kakaaru sa hida gimbaki gu didiru gwaa arini haa gwaa akhasani daqa Yeesugo.” ");
INSERT INTO bds_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Da hheꞌesi hida hhakee gu deni gu Yahuudi gigi tlaatlaꞌasiri kara khisla Peetiro haa Yohaana, gi tooinaa geemayri ma waaudiri. Teꞌesii inay yaa baraslayiriiba idoo sigi ⁄agitine, sa gimba hida goõ teꞌesii Iliitleemu ginaa daareeremisiyay sa yonduki gwaa hiica⁄u. ");
INSERT INTO bds_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Heedikee da hhoeesi hari amoo da bakaꞌasa, yaa kona koraraa gwaa hiicatee mibeeri cigahha seei. ");
INSERT INTO bds_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Qariqaaqari Peetiro haa Yohaana digaa ilii geemay, gi ki⁄iri daqa deneꞌee koinay gu koomee ⁄imba, sigigi ilatlayri gimba goõ sigaani kaay ha hhapalooee da deni da Iliitleemu haa gaduũ. ");
INSERT INTO bds_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Qatlay hida hhakee giyaa ilii akhasiri gimbakee, gi firiniri Iliitleemu daqa lenge, gi kaayri tuba, “Ye Looimoo goori gu kooma ⁄uuru goõ, gwaa tleehhu raw haa hhapee, tlawoo gu deni haa idadu sliimaa gu waꞌay koinay waaree, ");
INSERT INTO bds_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ugu haa kaadi gimbaki hari amoo da Muuna gu Iliitleemu daqa taataa goorii Dawdi, hiĩ gwaa yondimiisay googu, gi kaay tuba, ‘Hida gu hhapapu wakinay siĩ soꞌoy slahhaairi, kara hida tooinaa ilahudeemisiyay gimba gu bawma? ");
INSERT INTO bds_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Watemi da khooroti hingii ilakhuukhuꞌusiri sa qwatla, kara hida gu deni goó tawaalimee hingii kurunkuridiri daqa lenge, ma tlankiri Looimoo goori gu Goõ haa Kristu gosi.’ ");
INSERT INTO bds_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gimbaki guti lou! Mutemi Heroode haa Gafana Pontiyo Pilaatu, hida gu hhapapu wakinay haa hida gu hhapee da Israeeli naa hiikurunkuridiri sliimaa tiꞌii yaamu gu Yerusaleemuge. Yaa teesaaqay laqiri, ma ilakhuukhuꞌusiri gaasaraa da yondimiisay googu Yeesu gwaa hiileehhedi, gugi maakhadi du⁄iya, ma Masiiya tleehhidi. ");
INSERT INTO bds_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inay gi yondiidiri yondukee sliimaa hari slaꞌamuu koku gaa taarinti wakaꞌalee, gi ilakhuukhuꞌusidi hari ⁄uuru googu gimbaki miyaa hiica⁄i. ");
INSERT INTO bds_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Inkoo, Ye Looimoo goori gu Goõ, yuꞌudiyaa, idoo hindi ilii tlaatlaꞌamisiyee dandiray. Ugu sandi qayde ⁄uuru dandiray tongee doogu, ma kakaani gimba googu sa hida hari ⁄atlimaa gu didiri. ");
INSERT INTO bds_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tlaaꞌasii ⁄uuru googu, ma hhoeesi hida haa laqami gimba gu denu goó bakaꞌasa hida hari khisla hari uma gu yondimiisay googu Yeesu, gaa tlintiꞌisidi guba tlakwaroo.” ");
INSERT INTO bds_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Qatlay Peetiro, Yohaana haa raqa daa teꞌesii waara giyaa ilii hheꞌesiri firoo, mara giyaa ilii kurunkuridiri dugwaati rinqirinqisi ha ⁄uuru gu Iliitleemu. Teꞌesii, gonkoinaa digigi hacisi Muuna gosi, gi tlaatleesiri kakaaru gimba gosi sa hida hari ⁄atlimaa gu didiri. ");
INSERT INTO bds_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kara, hari bara waka hida goõ gwaa ⁄imbee Yeesu Kristu, yaati ibiidiri daqa lenge muunainge haa waaway gooinay. Hhaku heedi lensee gwaati kaaw tuba, khooslayki ga koome ti kooi ana lenkway, gonkoinaa hingaati wariiqaqaaqayay khooslay gooina daqa lenge. ");
INSERT INTO bds_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hari ⁄uuru gu didiru ya⁄abimiisee daa Yeesu, gi ilakoniri kakaaru tuba, gu lou Iliitleemu yaa slafisi haa gwaagii ca⁄asi Yeesu Kristu ayisago. Kara Iliitleemu gi qay sa hida wa⁄a hhoinay gosi gu didiru. ");
INSERT INTO bds_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hhaku heedi lensee tla⁄aã gooinay daa afiifaaki idoo giyaa ina slaiye. Sa gimba looee daa kooma qaymamuu haa maraai, khooslay gooina giyaati kirigiri, yaagi leehhisiri peesay giyaa slayri, ");
INSERT INTO bds_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","gigi hadisiri sa ya⁄abimiisee da Yeesu. Da hheꞌesi peesaykee dugwaati deehhimi sa hida qatlay giyaa ilii slaiyeei gooay idadu giyaa dakusiri. ");
INSERT INTO bds_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Teꞌesii yaa wana Laawimoo leẽ, uma gosi naa Yoseefu, yaamulooay gu hhapee da Kipiroo. Ya⁄abimiisee da Yeesu guri ayiri uma na Barinaaba. ");
INSERT INTO bds_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ina yaa naadimi qaymoo dosi leẽ giyaa kone, yaagi tosaa leehhisi peesay giyaa slay daqa ya⁄abimiiseege. ");
INSERT INTO bds_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Inkoo yaa wana heedi waku karaai, uma gosi naa Ananiyaa haa hadee dosi Safiira, yaa naadiniri daqa waka da qaymoo dooina. ");
INSERT INTO bds_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Da hheꞌesi ina hari ila⁄imbidu gu hadee dosi gi tosaa yakwi peesay waku giyaa slay kiriga da qaymoteesaa. Peesaykee gwaa meetu, gugi tosaa leehhisi daqa ya⁄abimiiseege, magu deehhiniri sa hida gwaa slaee. ");
INSERT INTO bds_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kara, Peetiro gi kaay sa ina tuba, “Ananiyaa, Sataanimoo hiĩ malee tawaalimi muuna googuu, hagi toogwaa ⁄imbidi koisa hiicora Muuna gu Iliitleemu, kara hagi meesidi peesay waku gaa slaydi kiriga gu qaymoogo? ");
INSERT INTO bds_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Qatlay gaa ilii kahhade naadiru qaymotee, gu lou lou yaa toogu! Kara qariqaaqari gaa ilii naadinti, peesay gwaa slaydi kahhi yaa koogu. Gu lou! Inkoo, haa malee ilahudeesidi muuna googuu teesaaqay laqaraa gimba da hinkaa gooay? Caahhi hida giningii coridiiba, ti Iliitleemu loi guniĩ koisidi hiicora.” ");
INSERT INTO bds_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Qatlay Ananiyaa giyaa ilii akhasi gimbaki gu Peetiro, cirakiray gi tosaa huui hhapeege pukhu! Gi gwaai. Kara hida hhakee goõ gwaa akhaseei gimbakee gwaa hiica⁄u, digigi ooyi ha tlaꞌamee da didiri. ");
INSERT INTO bds_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Da hheꞌesi qaraiya yaagi khaydi, gi ilataagiri tuuꞌuna dosi hari qayru gu ⁄abaaku, gugi geregediri khoorooge, gugi qaasiri. ");
INSERT INTO bds_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Qariqaaqari daa ilii cati saa tami, hadee dosi Safiira yaagii daadi marakeesii daa iliiwane Peetiro, ina yaa akhasidiiba gimbakee gwaa hiica⁄u. ");
INSERT INTO bds_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peetiro gigi maasi tuba, “Sini kaade, hiĩ na peesay gongoo gaa slaydiri igi haa hhawata googi, qatlay gaa ilii naadintiri qaymoo dooguna?” Da hheꞌesi gi ilaki⁄isidi sa ina tuba, “Ee, na hikee kilesi.” ");
INSERT INTO bds_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Teꞌesii Peetiro gi kaay sa ina tuba, “Igi haa hhawata googi hangwaa malee ila⁄imbitiri sliimaa, ma koisidiri Muuna gu Looimoo goori gu Goõ? Yuꞌudiyaa! Qaraiya diĩ qaasidi hhawata googi ilaciyaa gu afamaraage wanta, kara igi see digi geregedi khoorooge.” ");
INSERT INTO bds_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cirakiray Safiira gi huuꞌudi hhapeege pandaa da Peetiroge, gi tosaa gwaꞌati. Qaraiyatira giyaa ilii daadi marage, gi aniri ina see hiĩ gwaꞌati, gi geregediri tuuꞌuna dosi khoorooge, gigi qaasa kayri tluntlubaa da hhawata gosii. ");
INSERT INTO bds_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Da hheꞌesi hida goõ gwaa ⁄imbee Yeesu haa hida gwaa akhaseei gimbakee gwaa hiica⁄u daqa Ananiyaage haa hadee dosi Safiira, digigi ooyi ha tlaꞌamee da didiri loi. ");
INSERT INTO bds_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Inkoo, Iliitleemu gi iliiay ya⁄abimiisee dosi, gi laqaaqaniri tla⁄aã gu hidage gimba wa⁄a gwaa bakaꞌasu inay. Hida goõ gwaa ⁄imbee Yeesu, hingaati slaslaaslayay daqa lenge mara gu didiruge gu Yahuudi, daqa wakay uma gosi na “Waauu gu Solomooni.” ");
INSERT INTO bds_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hhaku heedi lenseei gwaa koisu ⁄imbaraa ilagaasa haa inay. Teesaaqay see, inay digaati muriidi hari khisla ha hida taysi Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gimati teesaaqay see, hida wa⁄a, hhawatee haã tigay seei faadoo dooina yaagii roogiti raqateesii da hida gwaa ⁄imbee Looimoo goori gu Goõ. ");
INSERT INTO bds_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sa gimbakee, hida yaagi geregediniri hari faloo ga⁄iidee dooina tongagugo, gigi tooinaa qaatimisiri falooge haa janfafuuge balabalaluuge. Qatlay Peetiro giyaa ilii cacaacatiye hari teꞌesa, mahhatu gosi ma hiicati hari daqa ga⁄iidee waka, ma hhoaaꞌayri. ");
INSERT INTO bds_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kara raqoo wa⁄a gu hida yaagi khayri daqa ya⁄abimiiseege yadaa tongagu gwaa ilaciyaa waaree haa yaamu gu Yerusaleemu, yaagi leehhimisiri ga⁄iidee haa hida koina daa labaꞌasi ha gieeri, gonkoinaa digaati hhoeemisi ha Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Inkoo hhapalooay gu didiru gu Iliitleemu haa deneꞌee kosi goõ gwaa sliimaa waaree ha ina, gi aniri tloomu sa ya⁄abimiisetee. (Hida hhanki gonkoinaa yaa raqa da diini da Yahuudi, uma gosi na Sadukaayoo). ");
INSERT INTO bds_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Da hheꞌesi gi ya⁄abiri sirikaarii dooina, ma ooyiniri ya⁄abimiisee da Yeesu, gigi ilapinginiri jeerage. ");
INSERT INTO bds_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Inkoo yuꞌudiyaa, hari amasi hhakee malayika gu Taataa Iliitleemu yaagi khay teꞌesii, gi tosaa afiiooyimi afamaraaee gu jeeratee, yaagii ca⁄asi ya⁄abimiisetee khoorooge, gi kaay sa inay tuba, ");
INSERT INTO bds_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Taa⁄amida qadimida mara gu didiruge gu Iliitleemu, la kakantay teꞌesii sa hida gimbaki sliimaa gu ibinati da ⁄abi.” ");
INSERT INTO bds_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Inay giyaa ilii akhasiri teesaaqay, gi hadakayri mara gu didiruge gu Iliitleemu dati kahhi tumpaatumpu, gii guniri, kara gi tlaatleesiri caacaahhamisu hida. Inkoo hhapalooay gu didiru gu Iliitleemu haa deneꞌee kosi giyaa ilii khayri, gi tooinaa eteediri balasaa da didiri da Wayahuudi haa gaduũ goõ gu Israeeli, gi ya⁄abiri sirikaarii dooina harimaa khaydi ya⁄abimiisetee pandaa dooinay jeerago. ");
INSERT INTO bds_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Teꞌesii sirikaaritee da deni qatlay giyaa ilii dayri jeerage, giyaa aniriiba ya⁄abimiisaytira waꞌay gu jeerateesii. Inay gi ki⁄iri, gi kaawa kayri gimbakee daqa hida hhakeesii gu balasaage, ");
INSERT INTO bds_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","gi kayri sa inay tuba, “Dandiray haã slayni afamaraaee goõ gu jeera digiĩ khiidiidimi naraꞌa, kara sirikaarii see hinqadimiti afamaraaeege ga⁄ayda. Inkoo qatlay gaã ilii afiiooyini afamaraaee haã slayniiba heedi lenseei waꞌayge.” ");
INSERT INTO bds_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Inkoo, sirikaarimoo gu didiru gu raqa doó ga⁄awa mara gu didiruge gu Iliitleemu haa hhapalooee da deni da Iliitleemu, giyaa ilii akhasiri gimbakee yaati bakaakairi hari khisla, hirigi slanqadiri baraslawa gimbaki yaa aloo malee kereꞌedi. ");
INSERT INTO bds_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Teꞌesii heedi waku yaagii ta⁄adi gi kaay sa inay tuba, “Yuꞌudaa! Hhawatee hhakira giyaa khiidintiri jeerage, mara gu didiruge wanay caacaahhaahhamisiyay hida.” ");
INSERT INTO bds_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Da hheꞌesi sirikaarimokee gu didiru haa sirikaarii dosi, gi hadakayri marakeesii gu didiruge, giyaagi ooyiniri aslaaꞌamee, giraagi tooinaa khayri ya⁄abimiisetee pandaa da balasaage, sa gimba yaa tlaꞌamuumuudiri digaa aloo cakhadina ha hida hari tle⁄eẽ. ");
INSERT INTO bds_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Qatlay giraa ilii khayri ya⁄abimiisetee, gigi qadidimisiri pandaa da balasaa da didiri da hida gu Yahuudige. Da hheꞌesi hhapalooay gu didiru gu Iliitleemu, gigi tlaatleesi cangicangimisu, ");
INSERT INTO bds_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","gi kaay tuba, “Dandiray hangwaa hiigadini unkuray gi kaawani tuba, ‘Maa hhanti koisiday kara caacaahhamisu hida hari uma gu heedikee!’ Inkoo yuꞌuda bere, unkuray hagi toogunaa ilakontiri caacaahhamisu hida gimba gosi daqeemoo sliimaa Yerusaleemuge. Kara slaꞌaday mandi muriidisidiri dandiray, ma slayni dakoo sa gwaaꞌaraa da heedikee.” ");
INSERT INTO bds_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Teꞌesii Peetiro haa ya⁄abimiisetira wakinay gi ilaki⁄isiri tuba, “Ba⁄ay Iliitleemu guni itatiimisana, ti gimba gu hida gooba. ");
INSERT INTO bds_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iliitleemu gu okookoiĩ koti yaa slafisi haa yaagii ca⁄asi Yeesu ayisago, hikee unkuray gwaa gaasidiri gugii tluhhumisidiri musalaabage. ");
INSERT INTO bds_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Iliitleemu gugi qaasi ina daqa da kooma muree hari khisla, gigi ibiidisi hari bara dosi da daba gu ⁄uya. Ina ma Mutemi haa ma Ilabuꞌumiisay gu hida tleehhidi, ma iliiay laqwaloo da Waisraeeli. Slime, inay maa hiidahhasiri mawaraa tlakwaroo dooina haa gii fookidiyay daqa Iliitleemuge, haa ma sigi ilamooyimi tlakwaroo ha ina. ");
INSERT INTO bds_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gu lou, dandiray ti masaydii gu gimbaki gwaa hiica⁄u, sliimaa ha Muuna gu Iliitleemu daa hadisi ha Iliitleemu sa hida goõ, goó akhamisee ina.” ");
INSERT INTO bds_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Qatlay hida hhakee gu deni gu balasaa giyaa ilii akhasiri gimbakee daa kaay ha Peetiro, gi slahhaahhaairi hari khisla, tay tooinaa slaiyay cu⁄uduũ ya⁄abimiisetee. ");
INSERT INTO bds_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Teꞌesii yaa wana Farisaaymoo leẽ, uma gosi naa Gamalieeli, maarimuu gu sariyaa da diini da Yahuudi, daa muriidi hari khisla ha hida sliimaa. Ina gi qadidi balasateesii da didirige, gi kaay sa sirikaarii doó ga⁄awa ya⁄abimiisetee, madagay ca⁄asi khoorooge coko⁄oniinii. ");
INSERT INTO bds_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Da hheꞌesi, Gamalieeli gi kaay sa hida hhakee gu balasaa da didiri tuba, “Ye! Hida koi gu Israeeli, ilahudeesa naraꞌa idoo ga slaꞌadee laqa hida hhanki! ");
INSERT INTO bds_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Slawaw ti koraraa angaamaka gwaa hiicatee, daa iliica⁄i heedi waku uma gosi naa Teuuda, hingaa hiiduubu pandaa da hidage tuba, ina yaati heedi gu didiru. Teꞌesii yaa wanay hhawatee miyaa cigahha gungaa ilagaasee haa ina. Dugugi gaasi, teꞌesii hida kosi goõ gwaa sirakomaamidee ina, gi pasidiri, yondu gosi yaati diitiray kilesi. ");
INSERT INTO bds_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Qariqaaqari Teuuda dugwaa ilii gaasi, kara heedi waku uma gosi naa Yuuda Galilaaymoo, yaagi khay qatlay sirikariinii da Ruumi giyaa ilii handikiikinte umaiĩ gu hida. Ina gii faafahhi hida wa⁄a mangu ilagaasiri ha ina, ma qwaatliri haa sirikaarii da Ruumi. Ina see dugugi gaasi, raqatee tosi goõ gi tosaa pasiti. ");
INSERT INTO bds_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Inkoo, gimbakii unkuray sanguti slaꞌa kaawa ambee, mawakini hida hhanki gu Yeesu hagi hhanti laqaday idoo lensee, maw waaudiyee. Bere ilakhuukhuꞌusa dooina haa yondu gooina ti gimba gu hida kilesi, dayaaiiba daqa lenge seei. ");
INSERT INTO bds_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bere caacaahhamisukee gu hida yaati daqa Iliitleemu dahhi, hay dahhasidaaiiba tlaatlahhasa hhawatee hhanki. Khuꞌuma naraꞌa angamalee hangooti slayday haa Iliitleemu na qwaqwatlintlitay!” ");
INSERT INTO bds_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Da hheꞌesi gaduũ gu balasatee da didiri hingigi ila⁄imbidiri haa gimba gu Gamalieeli, gi eteediri ya⁄abimiisee waꞌay gu marage. Qatlay digaa ilii hheꞌesi difoo ha sirikaarii hari khwacaa, gigi afakaayiri inay tuba, hhanti caacaahhamisiyay hari uma gu Yeesu. Teꞌesaa gigi geemayri, ma waaudiri. ");
INSERT INTO bds_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Teꞌesaa ya⁄abimiisetee gi waauti pandaa da balasateesaa da didirigo, tay hiĩ tooinaa hhaꞌaluumidiri hari khisla, sa gimba haraa hiiboo⁄iri slawaraa ilamuree da didiri sa uma gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Balalu sliimaa mara gu didiruge haa ayeemaa gu hidage, ya⁄abimiisetee gi ilakonti kakaaru haa caacaahhamisu Gimba gu Hhou gu Iliitleemu qadida see guba tuba, Yeesu na Kristu. ");
INSERT INTO bds_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Balalu hhakiray, qatlay faadoo da sirakoomiisee da Yeesu giyaa ilii roogiigimitee hari khisla, daagii ca⁄i quru⁄umoo tla⁄aã gu Wayahuudi gwaa giimaamisee Yunaanaisoo loi ha Wayahuudi hhaã gwaa looee gu hhapee da Israeeli. Hhakira gwaa giimaamisee Yunaanaisoo gi muunaafidiri tuba, balalu sliimaa tigay koina daa afahhamaahhami hhawatee, digaa hiislayiiba deehhiru gu ⁄agooge. ");
INSERT INTO bds_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Da hheꞌesi ya⁄abimiisetee da mibi ha cada giyaa ilii akhasidi quru⁄umokee, higi tooinaa gii kurunkuriri daqa lenge hida sliimaa gwaa ⁄imbee Yeesu, gi kaayri sa inay tuba, “Ti naraꞌaaba dandiray mawaraa yondu gu kakaaru haa gu caacaahhamisu gimba gu Iliitleemu, ma deehhini ⁄agoo sa hida. ");
INSERT INTO bds_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Inkoo hhiee koi, leehhaw hida fanqu tla⁄aã googunaa, hida daa muriidi hari khisla daa hacisi Muuna gu Iliitleemu haa gu koomee waaway, ma sigi taatahhani yonduki. ");
INSERT INTO bds_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kara tay dandiray hagitooraa hiikarahhana firoo, kakaaru haa caacaahhamisu hida gimba gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gimbaki daa kaay ya⁄abimiisetee gi muunaboo⁄eesi raqa goõ. Inay gii leehhiri Sitefaano, heedi gwaa kooma ⁄imba hari khisla haa gwaa hacu Muuna gu Iliitleemu. Kara gii leehhiri Filiipo, Purokooro, Nikanoori, Timooni, Parimeena haa Nikolaao gwaa yaamu gu Antiyookiya dahha, gi ⁄imbi diini da Yahuudi. ");
INSERT INTO bds_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Raqatee hiraagi tosaa khaydi hida hhakee gu fanqu giyaay leehhiri pandaa da ya⁄abimiiseege. Da hheꞌesi ya⁄abimiisetee gii qamiti dabaiĩ koina daqa dooinay, gi tooinaa firiniri Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gimba gu Iliitleemu gii qoomi, faadoo da hida gwaa ⁄imbee Kristu gii roogiti hari khisla yaamu gu Yerusaleemuge. Kara hhapalooee wa⁄a da Iliitleemu gu Yahuudi gi akhasiri gimba gu Yeesu, gugi ⁄imbiri. ");
INSERT INTO bds_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Inkoo Sitefaano, heedi daa ⁄aafi ha Iliitleemu gu kooma slaꞌamuu kosi gu didiri haa ⁄uuru gosi, gi yondiidi gimba gu denu gwaa bakaꞌasu hida. ");
INSERT INTO bds_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Teꞌesii yaa wanay hida wakinay gwaa tlankee ina, gwaa sinagoogi waka dahhee, uma gosi naa “Hida daa afiigweedi ibinaa da tongaiimaago.” Kara wakinay yaa hhapee da Kireene haa Alekisandariyaa dahhiyay, sliimaa haa wakinay gwaa hhapee da Kilikiyaa haa Aasiya dahhee. Hida hhanki gonkoinaa hingi tlaatleesiri ilaki⁄imisu gimba haa Sitefaano. ");
INSERT INTO bds_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kara, inay hingaay dahhasiriiba kabaaba⁄u haa waaway gosi, sa gimba Muuna gu Iliitleemu nugwaa iliiaꞌaay cocoꞌomooge. ");
INSERT INTO bds_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Da hheꞌesi hida hhakee ginaa ilii faafahhiri hida wakinay hari peesay, ma iliitloohhiri Sitefaano tuba, “Dandiray hagwaa akhasani heediki, kakaana gimba gu belendeqesaraa da Iliitleemu haa Musaa.” ");
INSERT INTO bds_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kara inay gii faafahhiri hida gu Yahuudi, gaduũ haa maarimamaa da sariyaa da Musaa. Inay seei gugi ooyiri Sitefaano, gugi tooinaa leehhisiri pandaa da balasaa da didirige da Wayahuudi. ");
INSERT INTO bds_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Da hheꞌesi hiraagi khayri masaydii da afaꞌafuumaa, gwaa kaawee tuba, “Heediki balalu sliimaa yoó mayaaba kakaaru gimba gu belendeqesaraa marakii gu didiru gu Yahuudi, daa tlintiꞌisi sa Iliitleemu ha sariyaa da Musaa.” ");
INSERT INTO bds_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dandiray haã akhasani kakaana tuba, Yeesuki gu Nasareeti maa ilacati maraki gu didiru, kara ina maa hiifooki ou goori sandaa qay daqa Musaago. ");
INSERT INTO bds_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Inkoo, hida hhakira sliimaa gwaa ibiidee balasateesii da didirige, gi ilii kaasiri ilaa Sitefaano, gi aniri pandaa dosi wanqada ubee pandaa da malayika gu Iliitleemu pahha. ");
INSERT INTO bds_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Da hheꞌesi hhapalooay gu didiru gu Iliitleemu gi maasi Sitefaano tuba, “Sitaakaa sliimaa da cocaacoiye daqa dooguu guti louu?” ");
INSERT INTO bds_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefaano gi ilaki⁄isi tuba, “Eki ye ayiĩ koi haa hhiee koi hani itatiisidee naraꞌa! Iliitleemu goori doó iliiwane wanqamee da hhoi, gwaa hiica⁄u daqa taataa goorii Aburahaamu qatlay giyaa ilii hhapee da Mesopotaamiyage wane, giyaa ilii kahhiye looaraa hhapee da Kharaanige. ");
INSERT INTO bds_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Iliitleemu gi kaay sa ina tuba, ‘Looyi teꞌesaa hhapee doogwaa haa daqa hiidayuuma doogwaa. Taa⁄a waaudi yade, hhapee wakay sugu laqame.’ ");
INSERT INTO bds_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Da hheꞌesi Aburaamu gi looyi teꞌesaa hhapee da Uurugo daa ilii ibimaamidiye hida wakinay daa eteediidine Kalidaayo, gi ibinaa kay hhapee da Kharaanige. Taataa gosi Teera giyaa ilii hhami hhapeteesii, Iliitleemu giyaagi looyisi ina yadaa Kharaanigo tiꞌii hhapetii goó ilii ibitee inkoo. ");
INSERT INTO bds_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Qatlaykeesii Iliitleemu yaa qayiiba aalimee lensee sa Aburahaamu hhapetii, sugwaa qayiiba daqa damati coko⁄oniinii see. Teꞌesii Iliitleemu gii fadidi sa ina tuba, ‘Qariqaaqari sugwaa aloo qay ina haa laqwaloo dosi hhapeti goõ, ma tooina tleehhiti. Qatlaykeesii Aburahaamu giyaamati kahhi see slawaraa naw.’ ");
INSERT INTO bds_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iliitleemu gi kaay sa ina gimbaki tuba, ‘Laqwaloo doogu himaa ibita dahaa pahha koraraa miyaa cigahha hhapee da hida wakinayge, himaa tongee tleehhidiyay yade, kara digimaa labaꞌasi hari khisla.’ ");
INSERT INTO bds_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kara Iliitleemu gi kaay tuba, ‘Inkoo, hagamaati ⁄agitima hhapetee, gimaa ilii ibiidiyee tongee pahha. Qariqaaqari laqwaloo doogu ginimaa iliica⁄ada hhapeteesaa, maa khayri, mani hhaꞌaleesiri ana daqatii.’ ");
INSERT INTO bds_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Da hheꞌesi Iliitleemu gi hadisi sa Aburahaamu ila⁄imbidu gu daba⁄u. Aburahaamu gi laqwali nankosi Isaaka, gugi daba⁄i Isaaka daa ilii day baloo da dagati dugwaa ilii laqwaligo. Qariqaaqari Isaaka gi laqwali Yakoobo, Yakoobo gi laqwali okookoiĩ koti gu mibi haa cada. ");
INSERT INTO bds_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Okookoiĩ hhanki koti gu mibi haa leẽ yaa konay tloomu sa hhia gooina Yoseefu, gigi tooinaa naadiniri tongimoo pahha daqa hida gu Misirige. Gimati teesaaqay see, Iliitleemu kahhi yaa sliimaa wana haa Yoseefu, ");
INSERT INTO bds_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gugi ilabuꞌumi ina labaꞌasu gosaa sliimaa giyaa slay. Iliitleemu gi pihhi hhoinay haa waaway sa ina, gi ⁄isimi Faraaw, mutemi gu Misiri, ma hiileehhi Yoseefu. Da hheꞌesi Faraaw gugi tosaa hiileehhi ina, ma heedi gu didiri tleehhidi gu hhapee goõ da Misiri haa gu mara gosi. ");
INSERT INTO bds_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Qariqaaqari qori gu didiru yaagii ca⁄i hhapee sliimaa da Misirige haa Kanaanige, haraagi khay labaꞌasu gu didiri daqa hidage. Qatlaykeesii Yakoobo haa yaꞌay kosi yaay dahhasiriiba slawaraa ⁄agoo. ");
INSERT INTO bds_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Qatlay Yakoobo giyaa ilii akhasi tuba, yade hhapee da Misirige baruũ wana, gi tosaa ya⁄abi yaꞌay kosi, gi hhiyuudiri taysi Misirige naa asu dawaraa dooina da tlaatleesoo. ");
INSERT INTO bds_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hhiyuuma dooinay da cadiige, Yoseefu hingigi tosaa hiica⁄asi ina lenkosi daqa hhiee kosii, sigigi kaay tuba, ‘Ana ti hhia googuna Yoseefu.’ Kara gii ca⁄asi daqa Faraawge hiidayuuma dosi. ");
INSERT INTO bds_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Da hheꞌesi Yoseefu gi ya⁄abi hhiee kosi tuba, taa⁄amida kaawa sa taataa gooi Yakoobo haa hiidayuuma doyi goõ, ma yaa khayri Misirige. Gonkoinaa faadoo dooina yaa hida mibeeri fanqu haa kooani. ");
INSERT INTO bds_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakoobo giyaa ilii akhasi teesaaqay, ina haa hiidayuuma dosi goõ gi tooinaa hadakayri Misirige. Qariqaaqari ina ginaa ilii hhami taysi, yaꞌay kosi see hhaã gwaa okookoiĩ koti gi tooinaa kaka⁄iri taysi. ");
INSERT INTO bds_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tuueenaa koina gonkoinaa digigi leehhisi yaamu gu Sekeemuge, digigi qaasi ayisa daa hiikhuri maraiyage, daa kirigi ha Aburahaamu hari peesay daqa yaꞌay gu Hamoorigo. ");
INSERT INTO bds_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Inkoo, qatlay gu Iliitleemu yaa daadaauusi hiigaasa da hiifadidu gosi giyaa kaay daqa Aburahaamuge. Iliitleemu gi iliiay hida koti gii tlakhwayri hari khisla hhapee da Misirige. ");
INSERT INTO bds_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Da hheꞌesi mutemi waku gu ⁄abu yaagii ca⁄i, ma tawaalimi hhapee da Misiri, gwaa hhidima gimba lenseei gu Yoseefu. ");
INSERT INTO bds_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hiĩ na mutemi gwaa hiicoru hari cirihhimaa hida koti, gi labaꞌasi okookoiĩ koti hari khisla, hari amoo da ⁄uureesa ma mayri yaꞌay koina gu digiidakwi, ma kaka⁄iri. ");
INSERT INTO bds_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musaa dugwaa qatlaykeesii hiiday, yaa naw gu hhou hari khisla pandaa da Iliitleemuge. Dugugi tosaa omi slehheeri tami hari siiri mara gu taataa gosii. ");
INSERT INTO bds_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Qatlay Musaa dugwaa iliica⁄asi khoorooge, sagameeriya da Faraaw gigi tosaa slaydi nakee teꞌesii, gugi leehhisidi ayigooinayi, gugi omidoo kaydi nankosi loi pahha. ");
INSERT INTO bds_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musaa dugugi caacaahhamisi waaway goõ gu hida gu Misiri, gi heedi gwaa kooma ⁄uuru tleehhidi gimba gosii giyaa giimaamisiye haa yondu gosii. ");
INSERT INTO bds_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Qatlay Musaa giyaa ilii kone koraraa mibeeri cigahha, letu waka giislay muuna gosii arimaa kawaraa hhiee kosi Waisraeeli. ");
INSERT INTO bds_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Qatlay giyaa ilii arimaa kay taysi, gi arimi Misirimoo leẽ ilahufidi hari khisla Israeelimoo. Musaa gi ilabuꞌuru kay Israeelimoo, gii slarakhasi ilahufidukee daqa Misirimokeesii, gugi tosaa gaasi. ");
INSERT INTO bds_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musaa yaati ilahudeesi ina beelaa, Waisraeeli, hhiee kosi caahhiyay tuba, Iliitleemu giyaati ya⁄abi ina sa ilabuꞌuru gooina hari ⁄uuru gosi. Kara tay inay yaa caahhiriiba gimbakee. ");
INSERT INTO bds_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Heetlaalee dosii Musaa gi arimi hhawatee cada gu Waisraeeli gwaa qwaqwatliitlimee, gi koisi ilagaasaraa inay, sigigi kaay tuba, ‘Yeraa, unkuray cada kokunaa, caba ti Waisraeeli. Inkoo hangu soꞌoyi slaꞌaday ilaqaꞌadu unkuray haa unkuray?’ ");
INSERT INTO bds_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Heedikira gwaa ilaqau danaꞌa gosi, gi tafisi Musaa kengage, gigi tlanki, tay tosaa kaay sa ina tuba, ‘Ugu! Ha miyaa nugwaa hiileehhi, ma heedi goori tleehhiti gu tawaaloo haa ilabuꞌumiisay goori? ");
INSERT INTO bds_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Inkoo gu lou, ugu hati slaꞌadaa mani gaasidi, idoo gaã ilii gaasidi gooay Misirimokira sa⁄alee?’ ");
INSERT INTO bds_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Qatlay Musaa giyaa ilii akhasi gimbakee, yaa tlaꞌamuudi, gi tosaa lakidi teꞌesaa hhapee da Misirigo, gi ibinaa kay hhapee da Midiyaanige dahaa pahha. Teꞌesii gi khabimi, gi slay yaꞌay cada gu hhawatee. ");
INSERT INTO bds_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Qariqaaqari, koraraa mibeeri cigahha giyaa ilii buꞌudiri, malayika gu Taataa Iliitleemu yaagi iliica⁄i Musaa hatlige ilaciyaa haa oõ gu Sinaay, rukutimoo gwaa ooyiiyimage buruburiya da aslaa, guba ci⁄araa see. ");
INSERT INTO bds_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Qatlay giyaa ilii arimi gimbakee Musaa yaati bakai hari khisla. Da hheꞌesi gi tosaa hiisati ciyoomooge ma arimi naraꞌa, gi akhasi afoo da Looimoo goori gu Goõ hiĩ kaadi tuba, ");
INSERT INTO bds_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ana na Iliitleemu daa firiirine ha okookoiĩ koku, Iliitleemu gu Aburahaamu, Isaaka haa Yakoobo.’ Da hheꞌesi Musaa gi tlaatleesi dakhadakhamee hari tlaꞌamee da didiri, yaa kara hiidahhasiiba khuꞌuduũ rukutimokee. ");
INSERT INTO bds_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Da hheꞌesi Taataa Iliitleemu gi kaay sa ina tuba, ‘Bace ye⁄etoo koku, maꞌaana daqati gaã ilii qadidi, dagaati tlintiꞌisi sa ana. ");
INSERT INTO bds_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ana haã arimi labaꞌasu gu hida koi gu Misirige waaree, kara haã akhasi ⁄aa⁄imuu gooina. Ana hantii ⁄eeti, magi ilabuꞌumi inay dabaiĩ gu hida gu Misirigo. Inkoo ugu khoca, magu ya⁄abi Misirige, magi iliiawaraa kaydi ilabuꞌuru.’ ” ");
INSERT INTO bds_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sitefaano gi ilakoomi gimba tuba, “Musaaki na ina giyaa siꞌiri hida gu Israeeli gi kaayri tuba, ‘Ugu! Ha miyaa nugwaa hiileehhi, ma heedi goori tleehhiti gu tawaaloo haa ilabuꞌumiisay goori?’ Iliitleemu giyaati ya⁄abi ina ubee, heedi gu didiru pahha gu tawaaloo haa ilabuꞌumiisay gooina pahha, hari amoo da malayikakira gwaa ilii ca⁄u ina rukutimokiray. ");
INSERT INTO bds_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musaa haraa giyaadi hida gu Israeeli yadaa hhapee da Misirigo, gi laqami gimba gwaa bakaꞌasu hida taysi Misirige, kenga gu tlawa da didirige da Saamuge haa koraraa mibeeri cigahhage giyaa ilii hatlige wanee. ");
INSERT INTO bds_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musaaki naa kaay sa Waisraeeli tuba, ‘Iliitleemu sangu hiileehhi tletimiisay da ana gooay tla⁄aã gu hhiee kokunaa loaa.’ ");
INSERT INTO bds_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musaa yaa sliimaa wana haa raqatira da hida gu Israeeli, qatlay giyaa ilii kurunkuridiri yade hatlige, sliimaa haa malayika gwaa cocou haa ina oõ gu Sinaayige, haa yaa sliimaa wana haa okookoiĩ koti. Kara gi ooyi gimba gu slafimaa daqa Iliitleemugo, magu kakaami sa dandiray. ");
INSERT INTO bds_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Teꞌesii ayiĩ koti gwaa itatiisiriiba Musaa. Inay gugi siꞌiri muunaiĩ koina, gi tlaatleesiri hiifookida yade khuꞌusa Misirige. ");
INSERT INTO bds_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kara, inay gi kaayri sa hhapalooay gooina Haruuni tuba, ‘Sandi boo⁄imiside sanaamuu iliitleemamee gu laqamee amoo sa dandiray. Musaaki hindiray ca⁄u hhapee da Misirigo ha hhidina idoo daayii ca⁄adi daqa dosii.’ ");
INSERT INTO bds_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Balalu hhakeesii ginaa ilii boo⁄imisiri hari sahaabu idoo waka da damaa slanqasa. Teꞌesii gi cu⁄iri kuꞌunaanay, idotee sagagi hadimisiri idadu. Kara gi ⁄isiniri losona, gi seehhuusiri tay tooinaa raaiyay sa idotee giyaa boo⁄imisiri hari dabaiĩ koina loi. ");
INSERT INTO bds_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sa gimbakee Iliitleemu gigi taatahhi inay tlakwarooge, tay tooinaa firiirinay letu, tica⁄eerii haa slehheẽ goó rawaa gu rawge waaree, idoo daa ilii handikimi gooay kitaabuu gu tletimiisee da Iliitleemuge tuba, ‘Unkuray! Ye hida gu Israeeli, ana sugunaa cu⁄uu⁄untaaii kuꞌunaanay, haa sinigi hadimisidiri idadu wakinay, qatlay gu koraraa mibeeri cigahha gaa ilii ibiidi hatlige? Suti sa ana gooba! ");
INSERT INTO bds_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ilatahha unkuray haa geregetiri hemaa gaa boo⁄imisidiri sa iliitleemu gu Moleeki daa boo⁄imisi ha hida, haa sanaamuu da iliitleemu waku giyaa boo⁄imisidiri, uma gosi naa tica⁄u gu Refaani, Inkoo hangu ya⁄aba segenge, hiicataraa da yaamu gu Babilooni seei, dabaiĩ gu fa⁄ayaage.’ ” ");
INSERT INTO bds_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitefaano gi kara kaay tuba, “Qatlay okookoiĩ koti giyaa ilii hatlige wanee, yaa konay hemaa daa laqanti tuba, ina Iliitleemu yaa sliimaa wana haa inay. Hematee dagaati boo⁄imisi ha Musaa nama teesaaqay loi, idoo Iliitleemu giyaa ilii kaay gooay dagama boo⁄imisi. ");
INSERT INTO bds_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Qariqaaqari okookoiĩ koti daraa giyaadi ha Yosuuwa, hiraagi khayri hematee, giyaa ilii⁄utliri hhapee da Kanaani dabaiĩ gu hida gu hhapapu hhakiraa, daa gusimi ha Iliitleemu pandaa dooinaa. Hematee yaati meti hhapeteesii koraraa gu tawaaloo da mutemi Dawdi naqatloo. ");
INSERT INTO bds_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mutemi Dawdi slay hhoinay gu didiru pandaa da Iliitleemuge, gi firimi daqa dosii, ina see ma tleehhi mara gu didiru sa Iliitleemu gu Yakoobo. ");
INSERT INTO bds_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mutemi Solomooni nankosi gu Dawdi, naa tleehhi marakee gu didiru gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Gimati teesaaqay see, ha khuana Iliitleemu gu Rawaa gu Idadu Sliimaage Waara, yoó ibiidiyaaba mara doó tleehhiye hari dabaiĩ gu hida, qatlay daa ilii kaay gooay ha tletimiisay gu Iliitleemu tuba, ");
INSERT INTO bds_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Iliitleemu gi kaay, Rawaa gu raw ti kitiĩ goy gu tawaaloo, Kara khooroo ti daqa goó ilii qaase yeꞌeeroo koi, inkoo mara gu malee slanqasa guni tleehheday sa ana? Daqa dooi da ilii fiifisa ti kaale wanta? ");
INSERT INTO bds_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ti ana goobaslii, gwaa boo⁄imisu idadu hhanki sliimaa gu rawaa gu rawge waaree haã khoorotii?’ ” ");
INSERT INTO bds_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitefaano gi karaai kaay tuba, “Unkuray hida gu koomee sagaiĩ gwaa karaarahhee haa muunaiĩ goóba akhamisu Iliitleemu, hoó ba⁄aa⁄ataaiiba kanimisu Muuna gu Iliitleemu, idoo daa ilii lalaalaqiye gooay ayiĩ kokuna! ");
INSERT INTO bds_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wanaa tletimiisay gu Iliitleemu lensee daa may labaꞌasaraa ha okookoiĩ kokuna? Inay yaati amoolee cu⁄iri tletimiisetira daa tletinti khawaraa dosi, Hikee goó Yondiida Hhoinay. ");
INSERT INTO bds_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kara, unkuray gwaa taatahhadiri, hagugi gaasidiri taariruge. Unkuray gwaa oowee sariyaa da Iliitleemu, daraa khay daqa doogunay ha malayika da Iliitleemu, kara tay unkuray hagaa itatiisidiriiba.” ");
INSERT INTO bds_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Qatlay hida gu balasaa da didiri da Wayahuudi giyaa ilii akhasiri teesaaqay gimbakee daqa Sitefaanogo, gi slahhaahhaairi, muunaiĩ koina ti amoo dakhadakhiyay sa ina. ");
INSERT INTO bds_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Teꞌesii Sitefaano dugugi iliihaci Muuna gu Iliitleemu, gi yuꞌudi rawaa gu rawge, gi arimi wanqamee da Iliitleemu daa ceelaalea hari khisla. Kara gi arimi Yeesu hiĩ qadidi hari bara da daba gu ⁄uya gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitefaano gi kaay tuba, “Yuꞌudiyaa raw duguũ pooisi ha Iliitleemu. Kara Yeesu, Nanku Heedi, hiĩ qadidi daqa da mureege hari khisla, hari bara da daba gu ⁄uya gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Qatlay hida gu balasaa da didiri giyaa ilii akhasiri teesaaqay, gi tuntukiri eaa koina hari dabaiĩ, gi maahhiri hari afoo da didiri, magu mayri akhasaraa gimba gosi. Cirakiray gonkoinaa gugi ilii tlairi, ");
INSERT INTO bds_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","teꞌesaa gugi duukhiri khoorooge kuutakeesaa daa hiikhangaꞌasi gu yaamu gu Yerusaleemu, gugi tlaatleesiri cakhadiruu hari tle⁄eẽ. Qatlaykeesii lenge, masaydii daa hiileehhi, gi babaciniri jurungaguu koina, gigi tooinaa qaasiri teꞌesii hhapeege ilaciyaa haa yeꞌeeroo gu heedi waku, uma gosi naa Sawlo. ");
INSERT INTO bds_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hida hhanki gi ilakoniri cakhadiru Sitefaano hari tle⁄eẽ, ina tay tosaa firiirina Iliitleemu tuba, “Ye Looimoo gooi Yeesu, ooyi muuna gooi!” ");
INSERT INTO bds_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Da hheꞌesi gi keebeeidi, gi firimi hari afoo da didiri, gi kaay tuba, “Ye Looimoo gooi Yeesu, hida hhanki sigi hhanti fata tlakwaroti.” Qariqaaqari giyaa ilii hheꞌesi kaawaraa teesaaqay, gi tosaa gwaai. ");
INSERT INTO bds_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kara Sawlo yaa teꞌesii wana, gi ⁄imbi Sitefaano duguma gaasi ha hida hhakee gu deni gu balasaa da didiri. Baloteesii hida goõ gwaa ⁄imbee Yeesu kanisaa da Yerusaleemuge, digigi tlaatleesi labaꞌasu hari khisla. Hida hhakee gonkoinaa gi pasidiri, gi lakidiri hhapee da Yudaayage haa Samariyaage, ya⁄abimiisee kilesi naati meti teꞌesii. ");
INSERT INTO bds_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Qatlay Sitefaano dugwaa ilii gaasi, hida gwaa muriidee Iliitleemu yaagi khayri, gugi tooinaa qaasiri, gi ⁄aa⁄iri hari khisla sa ina. ");
INSERT INTO bds_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Qatlaykeesii loi, Sawlo gi tlaatleesi hhamisaraa kanisaa. Ina gi ilakhookhocimi maraai goõ, gi dukhudukhumi hhawatee haa tigay gwaa ⁄imbee Yeesu, gigi ilapingimi jeerage. ");
INSERT INTO bds_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Inkoo hida hhakira gwaa pasidee, gi tlaatleesiri kakaaru gimba gu Iliitleemu daqeemoo sliimaa giyaa ilii hadakayri. ");
INSERT INTO bds_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filiipo see gi hadakay yaamu gu Samariyaage, teꞌesii gi kakaami sa hida gimba gu Kristu. ");
INSERT INTO bds_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Qatlay raqoo gu hida giyaa ilii akhasiri gimbakee kosi, haa gi aniri gimba gwaa bakaꞌasu hida daa yondimaamidiye hari ⁄uuru gu Iliitleemu, gonkoinaa gugi itatiisiri ina naraꞌa. ");
INSERT INTO bds_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filiipo yaay ca⁄amisi gieeri daqa hida wa⁄ago, tay tooinaa maahhaminay hari ⁄uuru. Kara hida wa⁄a gwaa slaqoo tingara⁄uumidee haa wakinay gwaa yeꞌeeroo tlakwaakwawee, digaa hhoeesi. ");
INSERT INTO bds_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sa hhoeemisukee, hida gu yaamu hhakee gi hhaꞌaluumidiri hari khisla. ");
INSERT INTO bds_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Teꞌesii yaamu hhakeesii gu Samariyaage yaa wana heedi waku, uma gosi naa Simooni, ina gimba gu miislay ginaa yondimaamidi. Kara yaati laqaaqana gimba gwaa bakaꞌaaꞌamisa hida gu teꞌesa koraraa wa⁄a, hingaatii duubaabidi pandaa da hidage tuba, ina na heedi gu didiru. ");
INSERT INTO bds_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Hida sliimaa gu deni haã gu digiidakwi seei, digaa hiidafidi ha gimba gosi gugi akhamisiri naraꞌa, yaa kaayri tuba, “Gu lou, heediki ti kona ⁄uurukira gu Iliitleemu, doó oine na ‘⁄uuru gu Didiru.’ ” ");
INSERT INTO bds_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kara inay gugi ilakoniri itatiimisu naraꞌa, sa gimba inay giyaa bakaꞌasi hari khisla koraraa wa⁄a, hari gimbakee kosi gu miislay giyaa yondimaamidiye. ");
INSERT INTO bds_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yuꞌudiyaa, hida yaa ⁄imbiri Filiipo, qatlay giyaa ilii kakaakane Gimba gu Hhou gu Tawaaloo da Iliitleemu haa uma gu Yeesu Kristu, digigii nunqudimisi, gonkoinaa hhawatee haã tigay see. ");
INSERT INTO bds_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simooni see gi ⁄imbi Yeesu, dugwaa ilii hheꞌesi hiinunqudisa, hingigi sirakomamidiri haa Filiipo. Kara dugwaa bakaꞌasi ha gimba gu denu gu bakaꞌasa gwaa hiicacaaca⁄a, daa yondimaamidiye. ");
INSERT INTO bds_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Inkoo qatlay ya⁄abimiisee daa yade waara Yerusaleemuge, giyaa ilii akhasiri tuba, hida wa⁄a gu hhapee da Samariyaa hiĩ ⁄imbiri gimba gu Iliitleemu, gi tooinaa ya⁄abiri Peetiro haa Yohaana yade. ");
INSERT INTO bds_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Qatlay giyaa ilii dayri yade, gi firiniri sa hida hhakee, ma slayri Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Qatlaykeesii Muuna gu Iliitleemu yaa kahhi hii⁄eeta daqa heedi lenseege tla⁄aã gooinay, inay digaatii nunqudimisi hari uma gu Looimoo goori Yeesu kilesi. ");
INSERT INTO bds_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Da hheꞌesi Peetiro haa Yohaana gii qamidiri dabaiĩ koina daqa hida hhakeesii, inay gi slayri Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Qatlay Simooni giyaa ilii arimi hida gu Samariyaa, hiĩ slayri Muuna gu Iliitleemu, hari amoo da iliiqamidu dabaiĩ ha ya⁄abimiisee, gi hadisi peesay sa inay, ");
INSERT INTO bds_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","gi kaay daqa dooinay tuba, “Ana seei sini qaydeei ⁄uuruki slime, ana bere kila heedi guũ ilii qaasi dabaiĩ koi, slaye Muuna gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Da hheꞌesi, Peetiro gi ilaki⁄isi Simooni tuba, “Hhame taysi haa peesaykee koku, maꞌaana haã ilahudeesidi ubeelaa, hiidahhasida kirigaraa hari peesay idoo doó hadisiye ha Iliitleemu! ");
INSERT INTO bds_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gu lou, ugu kontaaba daqa tiꞌii ma idoo lensee yondukii koorii gu Iliitleemuge, sa gimba muuna googu yaa tafaiiba pandaa da Iliitleemuge. ");
INSERT INTO bds_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Inkoo, fookidaayuu tlakwaroteesaa toogwaa, kara firimi Looimoo goori gu Goõ, angamalee dugu ilamooyina ilahudaa hhakee gu tlakwi ga konte muuna googuu. ");
INSERT INTO bds_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ana haã arimi pandataa ugu duguũ iliihaci ha qada hari khisla, kara ugu ti tongimoo gu tlakwaroo pahha.” ");
INSERT INTO bds_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simooni gi ilaki⁄isi tuba, “Hhooa sini firintee daqa Iliitleemuge, gimbakee sliimaa gaã cocoꞌodiri, hhantii ca⁄i daqa dooii.” ");
INSERT INTO bds_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Inkoo, Peetiro haa Yohaana giyaa ilii hheꞌesiri ilatlawa Kristu haa gi kakaaniri sa hida gimba gu Looimoo goori gu Goõ, inay gi tlaatleesiri ki⁄eemoo yaamu gu Yerusaleemuge. Amooge yaa kakaaniri Gimba gu Hhou gu Yeesu tongagu wa⁄age gu hida gu Samariyaa. ");
INSERT INTO bds_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Inkoo, letu waka malayika gu Taataa Iliitleemu yaagi ilii khay Filiipo, gi kaay tuba, “Tlayii, taa⁄a bara da wayee khuꞌusi balabalataꞌayi daa yaamu gu Yerusaleemu dahha, daa yaamu gu Gaasa khuꞌusidi.” (Balabalati haraa kongoqomee hiicatidi) ");
INSERT INTO bds_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Inkoo, Filiipo gii tlay, gi tlaatleesi waaudimoo hari balabalatee. Qatlay giyaa ilii khociicine, hingigi slaslayri amooge haa Esoopimoo waku afisa. Ina naa heedi gu didiru gwaa qamaamida khooslay sliimaa gu Kandaake, hadee daa tawaalinti hida gu Esoopiya. Heedikee yaati hadakay yaamu gu Yerusaleemuge sa firoo da Iliitleemu, ");
INSERT INTO bds_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yaati kikaaki⁄i Esoopiyage, tay hiĩ ibiidi kokoteeni gosii, tay somina hari afoo da didiri, kitaabuu daa handikimi ha tletimiisay Isaaya. ");
INSERT INTO bds_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Teꞌesii Muuna gu Iliitleemu gi kaay sa Filiipo tuba, “Ta⁄aa satii ilaciyaa gu kokoteenikaꞌay.” ");
INSERT INTO bds_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Da hheꞌesi, Filiipo gi tu⁄udi, maa hiisati kokoteenikiray. Qatlay giyaa ilii day ciyoomooge, gi akhasi heedikee somina kitaabuu gu tletimiisay Isaaya, gugi maasi tuba, “Haã caahhadii gimbakee ga somiiminte?” ");
INSERT INTO bds_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Heedikee gugi ilaki⁄isi ina tuba, “Ha malee caahha, bere heedi hhaku gu ilakeesa sa ana?” Ina gi tosaa kwahhasuusi Filiipo kokoteenikeesii, ma ibiidi sliimaa ha ina. ");
INSERT INTO bds_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inkoo, poohhu gu gimba giyaa somiimine heedikee naa nahiĩ, “Ina duguraati giyaadi ha hida ubee, bee⁄imokaꞌa pahha, daa gaasakakaakaye, kara ubee ⁄ambeenimokaꞌa pahha goó tlakhada diĩ, pandaa da heedi goó sika quubu gosi, nama teesaaqay ina yaa kaayiiba gimba lensee. ");
INSERT INTO bds_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gugi muriidisiri hari khisla, kara dugugi afii⁄iti haaki dosi, Miyaa nii dahhasi ilakeesa gimba gu laqwaloo dosi? Ibinaa dosi dagaati ilaquutli khoorotaa.” ");
INSERT INTO bds_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Afisa gi maasi Filiipo tuba, “Hhooa sini kaade, tletimiisay Isaaya gimba gu miyaa gini ilakesaasidi, gimbaki ti kosi kilesii ina lenkosi, baku guti heedi waku?” ");
INSERT INTO bds_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Da hheꞌesi Filiipo gi tlaatleesi caacaahhamisu afisa poohhukeesaa loi loi gu gimba gu Iliitleemu, sugugi kaay Gimba gu Hhou gu Yeesu Kristu. ");
INSERT INTO bds_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Inkoo, qatlay giyaa ilii khociicinee hari kokoteenikee, gi dayri daqa daa iliiwane maꞌay, afisakee gi kaay sa Filiipo tuba, “Yuꞌudiyaa tiꞌii maꞌay wanay! Idoo mala nini tlaatlaahhasida, ana dinima hhantii nunqudisi?” ");
INSERT INTO bds_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Da hheꞌesi, afisa gi kaay sa heedi gwaa madaadida kokoteeni, ma qadidisi faraasi. Filiipo haa afisa gii guniri maꞌay hhakeesii, dugugii nunqudisi ha Filiipo. ");
INSERT INTO bds_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Qatlay giyaa ilii cacaaca⁄iyeei maꞌay hhakeesaa, cirakiray Muuna gu Looimoo goori gu Goõ harigi waaudi Filiipo daqa wakayge, afisa yaa kara arimiiba Filiipo. Teꞌesii afisa gi ilakoomi haa hhiyuuma dosi, tay duguũ tosaa iliihaci ha hhaꞌaloo da ilabuꞌuru. ");
INSERT INTO bds_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Qatlaykeesii Filiipo hingaati slay ina lenkosi, duguraani day ha Muuna gu Looimoo goori yaamu gu Asootoge. Ina gi hhiyuudi tay tosaa kakaana Gimba gu Hhou gu Yeesu Kristu amooge yaamu sliimaage, yaati day yaamu gu Kaysaariya naqatloo. ");
INSERT INTO bds_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Qatlaykee Sawlo yaa kahhi hari tlaatlaꞌamisu gosi gu hhamisaraa sumuku hida gwaa sirakomaamidee Looimoo gu Goõ. Gi hadakay daqa hhapalooay gu didiruge, ");
INSERT INTO bds_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","gugi firimi, ma sugu handikimi cheetatu gwaa laqamee tuba, Sawlo na miyaa daqa giyaadimiisee da sinagoogaguu gu yaamu gu Dameesikoge. Ina yaa teesaaqay laqi, bere gi slay hhawatee haa tigay gwaa sirakomaamidee amotee da Yeesu, ma giyaa ooyimi hari ⁄uuru haa gigi leehhisi khiidimooge yaamu gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sawlo gi waaudi Yerusaleemugo. Ina giyaa ilii daadaauusi yaamu gu Dameesikoge, cirakiray wanqamee da dihhi loi yadaa rawaa gu rawgo, yaagii wanqasidi Sawlo bareemoo sliimaa. ");
INSERT INTO bds_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sawlo gi huui hhapeege, “Pukhu!” Da hheꞌesi, gi akhasi afoo waka kakanta tuba, “Sawlo, Sawlo, sina soꞌoyi labaꞌaaꞌamisida ana?” ");
INSERT INTO bds_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawlo gi ilaki⁄isi sa ina tuba, “Ugu na miyaa, Looimoo gooi?” Afotira gi kaadi tuba, “Ana na Yeesu. Ana guni labaꞌaaꞌamisida. ");
INSERT INTO bds_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Inkoo, tlayii taa⁄a lay gunta yaamu hhakeesii, taysi sugoo kaay ugu ha heedi waku idoo ga yondite.” ");
INSERT INTO bds_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hida hhakira gwaa sliimaa hhiyumaamidee haa Sawlo gi tooinaa qadimidiri diĩ, yaa hiidahhasiriiba kaawaraa ma gimba lensee. Giyamaati akhasiri see afotira, gwaa aniriiba hikira gwaa gimaamisa. ");
INSERT INTO bds_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawlo gii tlay. Teꞌesii qatlay giyaa ilii diliqisi ilaa kosi, yaa hiidahhasiiba arimaa idoo lenseei. Da hheꞌesi, inay gugi ooyiri dabage, gurigi giyaadiri Dameesiko naqatloo. ");
INSERT INTO bds_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Balalu tami Sawlo yaa hiidahhasiiba khuꞌuduũ sumuku, kara yaa ⁄agimiiba ma kitahhuu gu idoo lensee. ");
INSERT INTO bds_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Inkoo, Dameesikoge yaa wana heedi gwaa sirakomaamida Yeesu, uma gosi naa Ananiyaa. Taataa Iliitleemu gugi eteedi ina tletaage tuba, “Ananiyaa!” Ina gi iidi tuba, “Yee! Looimoo gooi ha tiꞌii waara.” ");
INSERT INTO bds_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Da hheꞌesi, Looimoo gu Goõ gi kaay tuba, “Cira tlayii taa⁄a la hada kayda balabalaa wakay doó eteedine ‘Daa tafaꞌadi,’ mara gu Yuudage la maasida teꞌesii heedi waku uma gosi na Sawlo gu yaamu gu Taariso. Qatlaykii ina firiirina, ");
INSERT INTO bds_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ina dugwaani ilii khay ha Muuna gu Iliitleemu, gi arimi heedi doó eteedine uma gosi na Ananiyaa, yaa khoci, haa hiiqaasi dabaiĩ kosi daqa dosii, ma hiidahhasi khuꞌuduũ karaai.” ");
INSERT INTO bds_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyaa gi ilaki⁄isi tuba, “Looimoo gooi, ana haã akhasi daqa hida wa⁄ago gimba sliimaa gu tlaku gu heediki giyaa yondiidi daqa hida kokuu gwaa ⁄imbee ugu yade yaamu gu Yerusaleemuge. ");
INSERT INTO bds_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kara ina yaani khay tiꞌii Dameesikoge, yaa kona cheeti daani qaydi ⁄uuru sa ina daqa hhapalooay gu didirugo, ma ooyimi hida goõ goó firiirimee ugu.” ");
INSERT INTO bds_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Teesaaqay see, Looimoo gu Goõ gi kaay sa Ananiyaa tuba, “Taa⁄a! Heedikee ti khooslimoo gooi gu kaaru ganii leehhi, sa kakaaru uma gooi pandaa da hida gu hhapapu wakinayge, sa watemi haa sa hida gu Israeeli. ");
INSERT INTO bds_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ana sugu laqama ina, idoo gi iliislaye labaꞌasu hari khisla, sa gimba gu uma gooi.” ");
INSERT INTO bds_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Inkoo, Ananiyaa gi hadakay, marakeesii daa iliiwane ha Sawlo. Teꞌesii gii qaasi dabaiĩ kosi daqa dosii, gi kaay tuba, “Hhia Sawlo, Yeesu, Looimoo goori gu Goõ, hikira gunii ca⁄u daqa dooguu amooge qatlay gaani ilii tay kakaakayde, ina naani ana ya⁄abi daqa dooguu, ma slaydi ⁄uuru guri khuꞌuduũ karaai haa ma dugu hacisi Muuna gu Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Cirakiray idadu wakinay khankhafaa pahha, yaagi huhuiri ilaa gu Sawlogo, ilaa kosi gi kara slayri ⁄uuru gu khuꞌuduũ. Da hheꞌesi, gi qadidi, dugugii nunqudisi. ");
INSERT INTO bds_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Da hheꞌesi, gi ⁄agimi ⁄agoo, gi karaai slay ⁄uuru. Sawlo gi ibiidi yade Dameesikoge balalu angaamaka sliimaa haa sirakoomiisee da Yeesu, gwaa yade waaree. ");
INSERT INTO bds_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Cirakiray Sawlo gi tlaatleesi kakaaru Yeesu Sinagoogaguu gu Yahuudige tuba, “Gu lou, Yeesu ti Nanku Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hida goõ gwaa akhasee Sawlo yaati bakairi hari khisla, gi kaayri tuba, “Heediki, caba na ina, hikira gwaa hhamisu hida gwaa firiirime uma gu Yeesu yade Yerusaleemuge. Kara yaani khay tiꞌii sa ooyiru gu hida goõ goó ⁄imbee Yeesu, magi leehhisi tay digiĩ tooinaa khiidiidimi daqa hhapalooee da denige.” ");
INSERT INTO bds_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawlo gi ilaqinci kakaaru gu gimba gu Iliitleemu hari ⁄uuru gu didiru, gi laqaaqami sa inay Handikaa da Iliitleemugo tuba, “Yeesu na Kristu, kara Wayahuudi daa ibimaamida Dameesikoge, yaa hiidahhasiriiba tlanka gimba gosi.” ");
INSERT INTO bds_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Qatlay daa ilii cati balalu wa⁄a, Wayahuudi waka hingigi slaslayri daqa lenge, gi tlaatleesiri ilakhuukhuꞌumisuu gu gaasaraa Sawlo. ");
INSERT INTO bds_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Teesaaqay see, Sawlo gi cira baraslayi ilakhuukhuꞌumisu gooina. Qatlay sliimaa gu tleemaa haã gu amasii see, inay yaati ga⁄ayri kaꞌafeerii gonge gurii ca⁄araa yaamu gu Dameesiko, magu ooyiri. ");
INSERT INTO bds_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sa gimbakee, hari amasi sirakoomiisee dosi, gugii slakhiri waꞌay gu kapuuge, gugii ⁄eetisiri hari daqa waka daa kooma mucu bi⁄inaa gu yaamuge, gi tosaa lakidi. ");
INSERT INTO bds_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Qatlay Sawlo giyaa ilii day Yerusaleemuge, hingaa koisi ilagaasa haa sirakoomiisee da Yeesu. Teꞌesii hida hhakee gonkoinaa gugi tlaꞌamuudiri, sa gimba yaa ⁄imbiriiba, bere gu lou ina yaa sirakoomiisay gu Yeesu. ");
INSERT INTO bds_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Da hheꞌesi Barinaaba gurigi waaudi Sawlo, gugi leehhisi daqa ya⁄abimiisetiray da Yeesuge. Ina gi kaay sa inay, idoo Sawlo dugwaa iliica⁄i Yeesu amooge, giyaa ilii Dameesiko kakaakaye, Yeesu gi cocoi haa ina. Kara sigigi kaay, idoo Sawlo giyaa ilii kakaami hari ⁄atlimaa uma gu Yeesu yade Dameesikoge. ");
INSERT INTO bds_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Inkoo, sirakoomiisetee gi ⁄imbidi gimba gu Barinaaba. Sawlo hingigi ilagaasi haa inay, gi ilakhookhocimi daqeemoo paslaapasloo gu yaamu gu Yerusaleemu tay tosaa kakaana gimba gu Yeesu hari ⁄atlimaa gu didiri. ");
INSERT INTO bds_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sawlo slime gi cocoi, kara hingigi ilaki⁄imisiri haa Wayahuudi daa cocaacoa gimba gu Yunaanaisoo. Inkoo, inay gi dabiidiri amoo da gaasaraa ina. ");
INSERT INTO bds_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Teꞌesii hida gwaa ⁄imbee Yeesu giyaa ilii akhasiri gimbakee, Sawlo gugi leehhisiri yaamu gu Kaysaariyage. Kara teꞌesaa gugii daasiri meelige, ma waaudi yaamu kosii Taarisoge. ");
INSERT INTO bds_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Da hheꞌesi kanisaa da daqeemoo sliimaa gu Yudaaya, Galilaaya haa Samariyaa gi slaydi ibinaa da qasaw daaba labaꞌasu. Kanisaa gi slaydi ⁄uuru, kara gi ilakonti gwaa⁄amee da Iliitleemu haa dagagi muunay⁄atlisi ha Muuna gu Iliitleemu. Kara, faadoo da hida gwaa ⁄imbee Yeesu, gii roogiti hari khisla. ");
INSERT INTO bds_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peetiro qatlay giyaa ilii ilakhookhociicine hida gwaa ⁄imbee Yeesu daqeemoo paslaapaslooge, gi day daqa hida gu Iliitleemuge gwaa ibimaamidee yade tongoo da Liidage. ");
INSERT INTO bds_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Teꞌesii gi slay heedi waku uma gosi na Ayineeya, gwaa slaqwa tingara⁄uudu, qatlay gu koraraa dagati yaati qaati, hiitlawaraasee yaa hiitlatlaatlayaaba buburuugo. ");
INSERT INTO bds_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peetiro gi kaay sa ina tuba, “Ayineeya, inkootuutuu tiꞌii duguũ hhoeesi ha Yeesu Kristu, tlayii hhafimi fala da buburuu googu.” Cirakiray Ayineeya gii tlay. ");
INSERT INTO bds_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hida goõ gwaa ibimaamidee tongoo da Liidage haa raqamaauu gu Saroonige, giyaa ilii aniri Ayineeya duguũ hhoeesi, yaagii fookidiri amamu koinaa, gi ⁄imbiri Yeesu Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Inkoo, yade tongoo da Yoopage yaa wanta hadee waka, sirakomiisoꞌoo da Yeesu, uma gosi hari Araamaisoo naa Tabiita, hari Yunaanaisoo na Dorikaasi. Hadeti balalu sliimaa yaati yondimaamita gimba gu hhou, kara yaati iliiaꞌaaꞌayda kwaeeli. ");
INSERT INTO bds_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Balalu hhakeesii ina gi mama⁄adi, gi tosaa hhanti. Tigay wakinay gi hhunciri tuuꞌuna dosi, gigi qaatisa kayri waauu gwaa pembee da marage waara. ");
INSERT INTO bds_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Inkoo, tongoo da Liida yaa ilaciyaa wanta haa yaamu gu Yoopa. Teꞌesii qatlay sirakoomiisee da Yeesu giyaa ilii akhasiri tuba, Peetiro kahhi wana teꞌesii Liidage, gi ya⁄abiri hida cada daqa dosii, ma sugu kaawa kayri tuba, “Hhooa khawa ciraai daqa doori tay Yoopage, haa hhantii kaaꞌada.” ");
INSERT INTO bds_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Cirakiray Peetiro gi waaudi haa inay yade Yoopage. Qatlay giyaa ilii dayri marakeesii, gurigii dayri pembeege, waauu daa ilii qaatisi tuuꞌuna da Dorikaasi. Tigay goõ daa afahhamaahhami hhawatee gwaa ibiidee teꞌesii, gi qadimidiri, gi niini⁄idiri Peetiro, tay tooinaa ⁄aa⁄iyay, kara tooinaa laqaaqanay sa ina qayroo koina daa hirimaamidi ha Dorikaasi, qatlay giyaa ilii kahhade haa inay. ");
INSERT INTO bds_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Teꞌesii Peetiro gigi tosaa hiica⁄asi khoorooge gonkoinaa. Da hheꞌesi gi keebeeidi, gi firimi Iliitleemu, gii fookidi daqa tuuꞌunateesi, gi kaay tuba, “Tabiita, tlayii!” Cirakiray gi pooisidi ilaa kosi, qatlay giyaa ilii anti Peetiro, gi tosaa ibiti. ");
INSERT INTO bds_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peetiro gi ooyi daba gosi, gigi iliiay ma qaditi hari yeꞌeeroo kosi. Da hheꞌesi gi eteedi hida hhakee gwaa koomee ⁄imba daqa Yeesuge haa tigay hhakee daa afahhamaahhami hhawatee, gigi tosaa laqami slafida daqa dooinay. ");
INSERT INTO bds_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Gimbaki gu didiru gwaa hiica⁄u, gi tosaa hiiqoomi daqeemoo sliimaage gu Yoopa. Teꞌesii hida wa⁄a gi ⁄imbiri Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Inkoo, Peetiro gi ibiidi Yoopage balalu wa⁄a, haa heedi waku uma gosi na Simooni, gwaa boo⁄ii⁄imisa idadu hari faloo. ");
INSERT INTO bds_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Inkoo yaa wana heedi waku gwaa ibimaamida tongoo da Kaysaariyage, uma gosi naa Korineliyoo, ina yaa sirikaarimoo gu didiru gu raqa da sirikaarii daa hhapee da Itaaliya dahha. ");
INSERT INTO bds_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ina haa hida gu mara gosi gonkoinaa muunaiĩ koinay Iliitleemu ginaa gwaa⁄iyay. Ina yaati iliiaꞌaaꞌay hari muuna gu cabuuma Wayahuudi daa kwaeeli. Kara balalu sliimaa yaa hiidedeliilinaaba firoo Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Letu waka tleemaa giyaa iliifuuruꞌuti, ina yaa arimi pandataa tletaage, malayika gu Iliitleemu gwaagi ilii khay, gugi eteedi tuba, “Ye Korineliyoo!” ");
INSERT INTO bds_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korineliyoo gi yuꞌudi aslaaꞌamee daqa dosii hari tlaꞌamee khisla, gi kaay tuba, “Looimoo goy, mala na wanta?” Malayikakee gi ilaki⁄isi tuba, “Firoo doogu haa yondu googu gu slaꞌamuu gu iliiaꞌawuu kwaeeli, hiĩ dayri rawaa gu rawge pandaa da Iliitleemuge. Kara ina dugu afahhanaaba hhoinay gooina. ");
INSERT INTO bds_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Inkoo, ya⁄abi hida yaamu gu Yoopage, maraa khayri heedi doó eteedine uma gosi na Simooni, kara uma gosi gu caduu na Peetiro. ");
INSERT INTO bds_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Heedikee yoóti ibiidi dahaa pahha mara gu Simoonige, goó faloo boo⁄imisa, mara gosi kenga gu tlawa da didirige wana.” ");
INSERT INTO bds_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qatlay malayikakee gwaa gimbuusu haa ina, giyaa ilii waaudi, Korineliyoo gi eteedi yondimiisee dosi cada haa sirikaarimoo gosi leẽ, goó firiirima Iliitleemu haa goó yondiida sa ina. ");
INSERT INTO bds_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Qatlay giyaa ilii hheꞌesi catimisu sa inay gimba sliimaa gwa hiica⁄u, gigi tosaa ya⁄abi yaamu gu Yoopage. ");
INSERT INTO bds_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Heetlaalee dosii tleemaa giyaa ilii daadi tana⁄iyage, hida hhakee gu tami qatlay giyaa ilii khociicinee amooge, tay hiĩ daadaauusiri Yoopage, Peetiro gii day rawaa gu pembee da mara gu Simoonige sa firoo Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Qatlaykii yaa qoriidi, yaa slai mati ⁄agimi ⁄agoo. Qatlay ⁄agotee dagaa ilii boo⁄ii⁄imisiye, ina dugwaagi ilii khay ha Muuna gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ina gi arimi raw hiĩ tlaaꞌadi, kara idoo da goroorimoo gu didiru pahha gu ⁄abaaku, dugunaa hii⁄eetiitimisi hhapeege yadaa rawgo hari hhagumeerii daa khiidiidimi somborokimaiĩ kosi cigahha. ");
INSERT INTO bds_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Waꞌay gu goroorimokeesii yaa wanay makay haa kuꞌunaanay paslaapasloo, gwaa koomee yeꞌeeroo cigacigahha, kara makay goó hhumbaadee hari guraiĩ khoorotii haa cira⁄oo. ");
INSERT INTO bds_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Da hheꞌesi, gi akhasi afoo kakanta sa ina tuba, “Peetiro tlayii, cu⁄e la ⁄aginta.” ");
INSERT INTO bds_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Teꞌesii Peetiro gi ilaki⁄isi tuba, “Looimoo goy, suti! Hiidahhasaaba, kahha ⁄agoo idoo lenseei daa tlufaafuꞌudi baku da slasla⁄iima sariyaa doorii.” ");
INSERT INTO bds_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kara afotee gi kaadi sa ina tuba, “Hhanti kaada idoo lensee slasla⁄iima, daa ilabuusli ha Iliitleemu.” ");
INSERT INTO bds_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Inkoo gimbakee gi kara hiica⁄i da cadii haa da tamii. Da hheꞌesi, goroorimokee gu didiru dugugi ki⁄isi rawaa gu rawge. ");
INSERT INTO bds_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Inkoo, Peetiro hingaa ilii maamaamisiye ina lenkosi maꞌaana da ilii khawaraa dosi ha Muuna gu Iliitleemu, nama qatlaykeesii lenge, hida hhakira daa ya⁄abi ha Korineliyoo, gi slayri mara gu Simooni goó boo⁄imisa faloo, gi tooinaa qadimidiri kaꞌafuge hari khooroo. ");
INSERT INTO bds_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Inay gi guutusiri, gi maasiri tuba, wanaa dahaa goó ibiida tiꞌii na Simooni, uma gosi gu caduu na Peetiro. ");
INSERT INTO bds_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Qatlaykeesii Peetiro giyaa ilii kahhiye ilahudaa gu ilii khawaraa dosi, Muuna gu Iliitleemu gi kaay sa ina tuba, “Yuꞌudiyaa, wanay hida tami gwaani dabiidu kawee ugu. ");
INSERT INTO bds_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Inkoo tlayii, ⁄eetii biraage, hangu ariirinteei haa hhawatee hhakee. Hhanti qiigiꞌida waauda haa inay, ana nigaani ya⁄abi daqa dooguu.” ");
INSERT INTO bds_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peetiro gii ⁄eeti biraage daqa hhawatee hhakiray, sigigi kaay tuba, “Ana na heedi ga dabimaamitee. Idoo saani khaydiri tiꞌii na mala?” ");
INSERT INTO bds_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Inay gi ilaki⁄isiri Peetiro tuba, “Dandiray Korineliyoo nandaani ya⁄abi, ina gu sirikaarimoo gu didiru, goó yondiida hhoinay, goó firiirima Iliitleemu haa doó muriidiye ha hida goõ gu Wayahuudi. Ina sugwaa kaay ha malayika gu Iliitleemu, ma dugu kwahhasuusi mara gosii, ma itatiisi gimba sugu kaade.” ");
INSERT INTO bds_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Da hheꞌesi, Peetiro gigi kwahhasuusi hida hhakee waꞌay gu marage, ma guiri dahaa kosi pahha. Heetlaalee dosii daa iliipisi, Peetiro gi waaudi haa hida hhakee gu tami. Hhiee wakinay gu Yoopa goó ⁄imbee Yeesu, higigi sirakomamidiri sliimaa haa inay. ");
INSERT INTO bds_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Baloo daa sirakonti, Peetiro haa inay gii guniri yaamu gu Kaysaariyage. Qatlaykeesii Korineliyoo giyaati baqaaqamidi inay hari kwayru gu didiru. Ina yaa hheꞌesi yaa kwahhasuusi aya gosii hida kosi haa deneꞌee kosi gu ciyoomoo, ma itatiisiri gimba gu Peetiro. ");
INSERT INTO bds_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Qatlay Peetiro giyaa ilii dadaadaye waꞌay gu marage, Korineliyoo hingigi slaslay ha ina. Da hheꞌesi, gi keebeeidi pandaa da Peetiroge, gii gupu⁄usi saga gosi daqa dosii. ");
INSERT INTO bds_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Teꞌesii Peetiro gugii tlaysi, gi kaay sa ina tuba, “Qadidi! Ana see ti heedi ugu pahha.” ");
INSERT INTO bds_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Korineliyoo gi qadidi, Peetiro gi ilakoomi cocoꞌomoo haa ina. Qatlay giyaa ilii dadayri waꞌay gu marage, gi slayri teꞌesii hida wa⁄a hingii kurunkuridiri. ");
INSERT INTO bds_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Da hheꞌesi, Peetiro gi kaay sa inay tuba, “Unkuray ha khuꞌuday tuba, daa kitlakuusi sariyaa da Wayahuudige, Yahuudimoo mangu ilagaasi haa hida gu hhapapu wakinay, kara gu hhanti ilii khookhocu kayay. Inkoo, Iliitleemu siniĩ laqami tuba, ‘Hhanti eteeda heedi lensee tuba, ina ti slasla⁄iisay baku guti hhouuba.’ ");
INSERT INTO bds_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Inkoo haã na idoo saani qiigiꞌiiba khaymuu dinii ilii eteedi ha Korineliyoo. Inkoo, aare sini kaade, idoo sinaani eteti ana tiꞌii.” ");
INSERT INTO bds_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korineliyoo gi kaay tuba, “Balalu cigahha gunii catee, ana haa firiirima Iliitleemu aya gooii, yaa mati qatlayki loi, letu giyoó ilii fuuruuꞌute. Cirakiray hhawata waku gi qadidi pandaa dooii, hiĩ daamisi qayroo gu ⁄abakwi poy ti amoo wanqiyay. ");
INSERT INTO bds_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hhawatakee gi kaay tuba, ‘Korineliyoo, Iliitleemu hiĩ akhasi firoo doogu, kara hindii slay yondu googu gu slaꞌamuu gu iliiaꞌawuu kwaeeli. ");
INSERT INTO bds_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Inkoo, ya⁄abi hida Yoopage, ma kaawa kayri sa Simooni, maa khay daqa dooguu, uma gosi gu caduu na Peetiro. Ina ti dahaa, yoó teꞌesii ibiidi daqa Simoonige, goó faloo boo⁄imisa, mara gosi gu kenga gu tlawa da didirige waara.’ ");
INSERT INTO bds_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ana saganaani cira ya⁄abi hida daqa dooguu, ma sugu kaay, maa khaydi tiꞌii. ⁄iisoo, ugu haani boo⁄isidi khawaraa. Inkoo gonkotaa nahaã ha tiꞌii wana pandaa da Iliitleemuge, ma akhasani gimba goõ, sugwaa kaay ha ina, ma sandi kaadi.” ");
INSERT INTO bds_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Da hheꞌesi Peetiro gi tlaatleesi cocoꞌomoo tuba, “Inkoo haã caahhi gu lou, Iliitleemu konaaba hiilehhidu, ");
INSERT INTO bds_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ina giyoóti ⁄imbi hida gu hhapapu sliimaa, goó gwaa⁄ee ina haa goó yondiidee hhoinay pandaa dosii. ");
INSERT INTO bds_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gu lou, unkuray khuꞌuday gimba daa ya⁄abi ha Iliitleemu sa hida gu Israeeli, Gimba gu Hhou guroó khawa ibinaa da qasaw daqa Iliitleemuge, hari amoo da Yeesu Kristu, Looimoo gu Goõ. ");
INSERT INTO bds_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Unkuray ha khuꞌuday gimba gwaa hiica⁄u daqeemoo sliimaa gu Yudaaya, gwaa tlaatleesu Galilaayago, hiinunqudimisukiraa loaa giyaa kakaami Yohaana. ");
INSERT INTO bds_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Unkuray ha khuꞌuday, idoo Iliitleemu giyaa ilii qay sa Yeesu gu Nasareeti Muuna gosi haa ⁄uuru gosi. Kara Yeesu, idoo giyaa ilii khookhocimi daqeemoo sliimaa, tay yondiidi yondu gu hhou haa hhoeemisu hida goõ daa labaꞌaaꞌamisiye ha Biriisimoo, sa gimba Iliitleemu yaa sliimaa wana haa ina. ");
INSERT INTO bds_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dandiray ti masaydii da gimbakee sliimaa giyaa yondiidi Yeesu Yerusaleemuge haa hhapee sliimaa da Wayahuudi. Ti inay nugwaa gaasiri, hari amoo da hiitluhhumisu musalaabage. ");
INSERT INTO bds_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Inkoo, baloo da tamiige, Iliitleemu gwaagi slafisi hari amoo da slafisa ayisago, haa dugugi arimi ha hida. ");
INSERT INTO bds_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ti hida sliimaa gooba gwaa arimee. Ti masaydii daa hiileehhi kilesi ha Iliitleemu. Masayditee ti dandiray gwaa sliimaa ⁄agimee haa gwaa kitahhamee haa ina, qariqaaqari giyaa ilii slafi yaagii ca⁄i ayisago. ");
INSERT INTO bds_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ina hindaa ilafahhi, ma kakaani gimba gu Iliitleemu sa hida goõ haa ma sigi ilatlayni tuba, ina na leẽ daa hiileehhi ha Iliitleemu, ma hukumi hida goõ, hhaã gu slafee haa gwaa kaka⁄ee. ");
INSERT INTO bds_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tletimiisee goõ da Iliitleemu yoó ilatlatlayda gimba gu Yeesu tuba, hida sliimaa goó ⁄imbee ina, tlakwaroo dooina dagoó ilamooyina hari uma gosi.” ");
INSERT INTO bds_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Qatlay Peetiro giyaa ilii kahhiye kakaaru gu gimbakeesii, Muuna gu Iliitleemu yaagii ⁄eeti daqa hida gonge, gwaa itatiitimisee teꞌesii gimbakee. ");
INSERT INTO bds_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wayahuudi doó ⁄imba Yeesu, daa khaydi haa Peetiro yadaa Yoopago, yaati bakaakairi hari khisla, arimaa idoo Iliitleemu giyaa ilii tuutuqi Muuna gosi sa hida gu hhapapu wakinay see. ");
INSERT INTO bds_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Teesaaqay, yaati akhasiri inay gimbuusiyay hari gimba paslaapasloo tay tooinaa daareemisiyay Iliitleemu. Da hheꞌesi, Peetiro gi kaay sa inay tuba, ");
INSERT INTO bds_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hhaku heedi gu hiidahhasa tlaatlahhasa hida hhanki digima may hiinunqudimisu. Inay hiĩ slayri Muuna gu Iliitleemu, dandiray gooay idoo gaa ilii slayni.” ");
INSERT INTO bds_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Teꞌesii Peetiro gi ilafahhi hida hhakee, ma digii nunqudimisi hari uma gu Yeesu Kristu. Da hheꞌesi, Korineliyoo haa deneꞌee hhakee kosi gi tlaatlaqasiri Peetiro, ma ibiidi haa inay balalu angaamaka. ");
INSERT INTO bds_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Inkoo, ya⁄abimiisee da Yeesu haa hida gwaa ⁄imbee ina gu Yudaayage waaree, gi akhasiri gimba tuba, hida gu hhapapu wakinay seei hiĩ ⁄imbiri gimba gu Iliitleemu. ");
INSERT INTO bds_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Qatlay Peetiro giyaa ilii hadakay yaamu gu Yerusaleemuge, Wayahuudi gwaa ⁄imbee Yeesu, gi belendeqesiri Peetiro, ");
INSERT INTO bds_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","gi kaayri tuba, “Ugu haa hadakaydi daqa hida da kahhiye daba⁄u, gi ⁄aginti sliimaa haa inay.” ");
INSERT INTO bds_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kara teꞌesii, Peetiro gi tlaatleesi ilakeesaraa naraꞌa sa inay gim