﻿USE sofia;
DROP TABLE IF EXISTS sofia.bdh_vpl;
CREATE TABLE bdh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bdh_vpl WRITE;
INSERT INTO bdh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Dosị́ éyị́ e tonónɨ́ kóo káa, Lomo oto ere e kɨ́ do sogo káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Do sogo káṇgá nɨ aka kóo tɨ́ lá nyáráne, éyị́ e ndanɨ́ kóo doa mbá wá, zɨ́ mɨtụlụrụ ídíne dụụ́ ne mbụụ́ do mongụ́ mɨkavu. Zɨ́ Lomo kóo ndị́sịné gámáne do iní née lá dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Zɨ́ Lomo úku ledre kɨ́dí, “Bimɨóṇgó idí óṇgó.” Káa zɨ́ bɨ Lomo uku ní, zɨ́ bi tɨ́ óṇgóne. ");
INSERT INTO bdh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Zɨ́ Lomo ídíne kɨ́ rokinyi gɨ ro bimɨóṇgó, zɨ́a ífi dongará bimɨóṇgó e kɨ́ mɨtụlụrụ. ");
INSERT INTO bdh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Zɨ́a ị́fị́ ịrị bimɨóṇgó kɨ́dí, “Kadra” zɨ́ ịrị mɨtụlụrụ ídí ꞌbɨ ené “Ndụlụ.” Zɨ́ kadra útúne, zɨ́ bi áráne. Née go sị́lị́ kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Zɨ́ Lomo úku ledre kɨ́dí, “Bi fúó idí ídí gɨ ro zɨ́a ífi dongará iní kɨ́ ezené iní.” ");
INSERT INTO bdh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Née ní, zɨ́ Lomo óto bifúó. Zɨ́a ífi dongará iní bɨ ꞌdága kɨ́ wo bɨ do káṇgá ní. Zɨ́a méngị roné tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Zɨ́ Lomo ịfị́ ịrị bi bɨ ꞌdága ní kɨ́dí, “Ere.” Zɨ́ kadra útúne, zɨ́ bi áráne, née go gbre sị́lị́. ");
INSERT INTO bdh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Zɨ́ Lomo úku ledre kɨ́dí, “Iní máa wo bɨ do káṇgá ní idí yóko roné do bi kị́éꞌdo zɨ́ ngáká bi ídíne sága.” Zɨ́ ledre née méngị roné tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Zɨ́ Lomo ị́fị́ ịrị ngáká bi née kɨ́dí, “Káṇgá,” zɨ́a ị́fị́ ịrị iní ga bɨ yokonɨ́ royé do bi kị́éꞌdo ní, “Mɨkavu e” Zɨ́ye émeyé komo Lomo. ");
INSERT INTO bdh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Zɨ́ Lomo úku ledre kɨ́dí, “Káṇgá idí ndíkiógụ ṛị́kị́ do kúfú éyị́ e. Idínɨ́ ụ́tụ do ánáye kɨ́ kúfúye e sɨmɨyé gɨ ro zɨ́ye ndị́sịyé ụ́tụtátá royé.” Zɨ́ ledre née méngị roné tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Zɨ́ káṇgá ndíkiógụ kúfú éyị́ e kacɨ́ ṛị́kị́ sị́ doyé e mɨngúngúcua. Sɨmɨ bɨ Lomo lurú éyị́ ga gére née nɨyí go tɨ́ kenée ní, zɨ́a ídíne kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Zɨ́ kadra née útúne, zɨ́ bi áráne, née go ota sị́lị́. ");
INSERT INTO bdh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Zɨ́ Lomo úku ledre kɨ́dí, “Bimɨóṇgó e idínɨ́ ídí komo ere gɨ ro zɨ́a ífi dongará kadra kɨ́ ndụlụ gɨ ro zɨ́ ꞌyị e ówo toso ndumu kɨ́ lịmị kɨ́ sị́lị́ e kpá kɨ́ sɨmɨbi e gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Bimɨóṇgó ga bɨ komo ere née idínɨ́ ndị́sị óṇgó bi do sogo káṇgá.” Zɨ́ye méngị royé tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lomo oto mɨngburoko éyị́ mɨóṇgó e gbre gɨ ro zɨ́ye ndị́sịyé óṇgó bi. Kadra oṇgó ꞌbɨ ené bi kɨ́ kadra. Éfé oṇgó ꞌbɨ ené bi kɨ́ ndụlụ. Zɨ́a kpá óto kele e. ");
INSERT INTO bdh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Lomo oto éyị́ ga gére komo ere íri gɨ ro zɨ́ye ndị́sịyé óṇgó bi do sogo káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ngíti a oṇgó ꞌbɨ ené bi kɨ́ kadra, ngíti géyị ꞌbɨ eyé kɨ́ ndụlụ gɨ ro ífi dongará bimɨóṇgó kɨ́ mɨtụlụrụ. Sɨmɨ bɨ Lomo lurú éyị́ ga gére née mengịnɨ́ royé go tɨ́ kenée ní, zɨ́a ídíne kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Zɨ́ kadra née útúne, zɨ́ bi áráne, née go eso sị́lị́. ");
INSERT INTO bdh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Zɨ́ Lomo úku ledre kɨ́dí, “Iní idí ndíkiógụ tụ́ꞌdụ́ éyị́ trịdrị bɨ nɨyí ndị́sị sɨmɨ iní kacɨ́ ṛị́kị́ sị́ doyé mbá, solụ́ e idínɨ́ ídí ꞌbɨ eyé komo ere ꞌdága, zɨ́ye ndị́sị ị́nyị lóꞌbó royé sɨmɨ síli ꞌdága.” ");
INSERT INTO bdh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Née ní zɨ́ Lomo ótoógụ mɨngburoko bangá iní e kpá kɨ́ ngíti géyị ṛị́kị́ éyị́ trịdrị ga bɨ ꞌbɨ iní ní. Zɨ́a kpá ótoógụ ṛị́kị́ sị́ do solụ́ e. Sɨmɨ bɨ Lomo lurú éyị́ ga gére née mengịnɨ́ royé go tɨ́ kenée ní, zɨ́a ídíne kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Zɨ́ Lomo íꞌbí úndru zɨ́ éyị́ trịdrị ga gére née zɨ́a úku ledre kɨ́dí, “Ídísé étrị zɨ́se ídíse tụ́ꞌdụ́ tụ́ꞌdụ́ tụ́ꞌdụ́ sɨmɨ mɨkavu e mbá. Solụ́ e idínɨ́ kpá étrị zɨ́ye ídíye tụ́ꞌdụ́ tụ́ꞌdụ́ tụ́ꞌdụ́ do sogo káṇgá.” ");
INSERT INTO bdh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Zɨ́ kadra née útúne, zɨ́ bi áráne, née go ịnyị sị́lị́. ");
INSERT INTO bdh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Zɨ́ Lomo úku ledre kɨ́dí, “Káṇgá idí ndíkiógụ ṛị́kị́ sị́ do bangá e. Yée ga bɨ ndịsịnɨ́ ụ́lụ́ yée ꞌbe, bangá súwú e nda kɨ́ éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní.” Zɨ́ éyị́ ga gére née méngị royé tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Zɨ́ Lomo óto bangá ga gére née, yée ga bɨ gɨ ro do ụ́lụ́ yée ní kacɨ́ sị́ doyé, bangá súwú e ꞌbɨ eyé kpá kacɨ́ sị́ doyé, nda kɨ́ éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní kpá kacɨ́ sị́ doyé. Sɨmɨ bɨ Lomo lúrú éyị́ ga gére née mengịnɨ́ royé go tɨ́ kenée ní, zɨ́ye útúásáye kacɨ́ komoa. ");
INSERT INTO bdh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Zɨ́ Lomo úku ledre kɨ́dí, “Idízé mu yéme ꞌyịmaꞌdí e káa do tosozé, zɨ́ye ídíye káa zɨ́ze ní, do ídíye ye ngére e do kénzé e, solụ́ e nda za kɨ́ ṛị́kị́ sị́ do éyị́ trịdrị e mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Née ní zɨ́ Lomo go yéme ꞌyịmaꞌdí káa zɨ́ ne ní, zɨ́a yéme wo go tɨ́ kenée káa zɨ́ ne ní, yeme yée oꞌdo kɨ́ kára. ");
INSERT INTO bdh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Zɨ́a íꞌbí úndru zɨ́ye kɨ́dí, “Ídísé ndíki tụ́ꞌdụ́ owụ́ e gɨ ro zɨ́ bulúndusé e ídíye tụ́ꞌdụ́ tụ́ꞌdụ́ do sogo káṇgá.” Zɨ́se ídíse kéye káa do ngére e do kénzé e, solụ́ e kpá kɨ́ ngíti géyị éyị́ trịdrị ga bɨ do sogo káṇgá ní za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Née ní, zɨ́ Lomo úku ledre zɨ́ye kɨ́dí, “Máíꞌbí ṛị́kị́ sị́ do kúfú éyị́ ga bɨ ndịsịnɨ́ áná mɨáná kɨ́ mɨáná kágá ga bɨ kɨ́ kúfúye sɨmɨyé ní go zɨ́se do sogo káṇgá ba mbá káa do éyị́ mɨánu zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Bɨ kenée ní, ṛị́kị́ sị́ do bangá e mbá, solụ́ e nda kɨ́ éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní, máíꞌbí mbílí éyị́ e go zɨ́ye káa do éyị́ mɨánu.” Zɨ́ éyị́ ga gére née méngị royé tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Zɨ́ Lomo lúrú éyị́ ga bɨ mengị yée née ní zɨ́ye émené komoa. Zɨ́ kadra née útúne, zɨ́ bi áráne, née go ịnyị doa kéṛị́ sị́lị́. ");
INSERT INTO bdh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gị ona, moko ꞌbɨ otoogụ ere e kɨ́ do sogo káṇgá za kɨ́ ngíti géyị éyị́ e mbá ní zɨ́ Lomo méngịónzó a. ");
INSERT INTO bdh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Lomo mengịonzó kóo moko ga gére née mbá sɨmɨ sị́lị́ ịnyị doa kéṛị́, nda sɨmɨ sị́lị́ ịnyị doa gbre máa née zɨ́a ꞌdówụ́roné gɨ sɨmɨ moko bɨ kóo ndịsị méngị a ní. ");
INSERT INTO bdh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Zɨ́ Lomo óto sị́lị́ bɨ ịnyị doa gbre née kɨ́ ledrené owóowó gɨ zɨ́a ꞌdowụ́ kóo roné sɨmɨa gɨ sɨmɨ moko ꞌbɨ ótoógụ éyị́ e bɨ kóo ndịsị méngị a ní. ");
INSERT INTO bdh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ngére Lomo otoogụ kóo ere e kɨ́ do sogo káṇgá kenée. Sɨmɨ bɨ Ngére Lomo otoogụ ere e kɨ́ do sogo káṇgá ní, ");
INSERT INTO bdh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","fụtụ́ éyị́ ndanɨ́ eyé aka kóo do sogo káṇgá mbá wá gɨ zɨ́a Lomo uku aka kóo bɨ yaá iní idí mu tónó éꞌdị ní wá, ꞌyịmaꞌdí ndaá aka kóo gɨ ro méngị moko do sogo káṇgá kpá wá. ");
INSERT INTO bdh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tɨ́ lá iní ndịsị aka kóo lá lágaógụ mɨlágaógụ gɨ sɨmɨ káṇgá, zɨ́a ndị́sịné ndíndi káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Née ní, zɨ́ Ngére Lomo ꞌdíꞌbi káṇgá óꞌbó a káa do oꞌdo, zɨ́a lụ́wụ́ trịdrị sɨmɨ a zɨ́a ídíne trịdrị. ");
INSERT INTO bdh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nda née ní zɨ́ Ngére Lomo líkpí yáká sɨmɨ ngíti bi kɨ́ ịrịné Édene mɨꞌdí gbére, zɨ́a ꞌdíꞌbi oꞌdo née óto wo yáká íri. ");
INSERT INTO bdh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Zɨ́ Ngére Lomo úku ledre zɨ́ ṛị́kị́ tụ́ꞌdụ́ bɨlámá kágá e ụ́tụógụyé sɨmɨ yáká née. Yée ga bɨ kɨ́ bɨlámá tosoyé kpá bɨlámáye gɨ ro ánu yée ní. Ngíti géyị kágá e nɨyí ꞌbɨ eyé bo gbre yana yáká née íri, ngíti a ndịsị íꞌbí trịdrị, ngíti a iꞌbí ꞌbɨ ené komokenzị ꞌbɨ ówo bɨlámá ledre kɨ́ bɨsinyí a. ");
INSERT INTO bdh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ngbuṛu nɨ kóo bo ndịsị kúkú kpụrụ́ gɨ sɨmɨ Édene gɨ ore gɨ ro zɨ́ éyị́ ga bɨ yáká ore ní ndị́sị ngbóróye. Nda go sogo yáká íri zɨ́a rásáne eso. ");
INSERT INTO bdh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mɨzefị sị́lị́ a ndolonɨ́, “Pịsónị.” Kukú ꞌdịyị roné sɨmɨ káṇgá bɨ kɨ́ ịrịné Avíla bɨ kɨ́ dábu sɨmɨné ní. ");
INSERT INTO bdh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dábu ga bɨ do bi née ní nɨyí mbá bɨlámáye kɨ́ tutú ga bɨ ṛíṛiṛí ndịsịnɨ́ úgú yée kɨ́ tụ́ꞌdụ́ késị́ ní, nda kɨ́ Abúṛengú ga bɨ kɨ́ bɨlámá ndonyoyé ní. ");
INSERT INTO bdh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gbre sị́lị́ a ndolonɨ́, “Gịyóna.” Kukú ngiṛigi roné sɨmɨ káṇgá bɨ kɨ́ ịrịné Kụ́sụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ota sị́lị́ a ndolonɨ́, “Tị́gịrị.” Kukú ꞌdịyị ꞌbɨ ené roné mɨꞌdí gbére sɨmɨ káṇgá bɨ kɨ́ ịrịné Asụ́rị ní. Esoyé ndịsịnɨ́ ꞌbɨ eyé ndólo a Efaráta. ");
INSERT INTO bdh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Zɨ́ Ngére Lomo ꞌdíꞌbi oꞌdo née óto wo yáká bɨ Édene née íri zɨ́a ndị́sịné méngị moko sɨmɨ a kpá kɨ́ lúrú bi kacɨ́ a. ");
INSERT INTO bdh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Zɨ́ Ngére Lomo úku ledre zɨ́ oꞌdo née kɨ́dí, “Mɨáná kágá ga bɨ yáká née za mbá, ídí ánu yée káa zɨ́ bɨ íli ní, ");
INSERT INTO bdh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","tɨ́ lá dụụ́ kágá máa wo bɨ ndịsị íꞌbí komokenzị ꞌbɨ ówo bɨlámá ledre kɨ́ bɨsinyí a ní ndá ánu a wá, gɨ zɨ́a togụ́ ánu go yá, ꞌdíꞌbiógụ umbu go komoyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Zɨ́ Ngére Lomo úku ledre kɨ́dí, “Ndaá bɨlámáne zɨ́ oꞌdo ba ndị́sịné ngúcuné wá. Nɨ mɨútúásáne zɨ́ma ótoógụ ꞌyị sáká wo.” ");
INSERT INTO bdh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nda née ní, zɨ́ Ngére Lomo ꞌdíꞌbi bangá ga bɨ kɨ́ solụ́ ga bɨ kóo otoogụ yée gɨ sɨmɨ káṇgá ní kacɨ́ ṛị́kị́ sị́ do eyé mbá kóꞌdụ́ oꞌdo née zɨ́a ndị́sịné ị́fị́ ịrị doyé. Tɨ́ lá ịrị bɨ ịfị́ go do éyị́ trịdrị bɨ nɨ bo ní née goó ịrịa. ");
INSERT INTO bdh_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Zɨ́ oꞌdo née ị́fị́ ịrị do bangá ga gére mbá, kɨ́ solụ́ e mbá, tɨ́ lá ngíti a bɨ zɨ́a útúásáne sáká oꞌdo née ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Née ní zɨ́ Ngére Lomo óto oꞌdo née zɨ́a útú ꞌdúꞌduné ṛí. Sɨmɨ bɨ nɨ cịkị sɨmɨ kútú ꞌbí ní, zɨ́ Lomo lálaógụ ngúru cóngó kóꞌdụ́ a, do ꞌdụ́tụlúgu bifúó née kɨ́ esị. ");
INSERT INTO bdh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Cóngó kóꞌdụ́ bɨ Ngére Lomo ꞌdiꞌbiogụ gɨ ro oꞌdo née ní, zɨ́a óꞌbóógụ a káa do kára do íꞌbí wo zɨ́ oꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Zɨ́ oꞌdo née úku ledre kɨ́dí, “Ba nda go cụ́ cóngó gɨ dongará cóngóma e, kpá esị gɨ sɨmɨ esịmá, mááyí ndólo a ‘Kára,’ gɨ zɨ́a ꞌdiꞌbiogụnɨ́ wo gɨ sɨmɨ cóngó kóꞌdụ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gɨ zɨ́ kéyị née, oꞌdo nɨ ótoómo ꞌbụné kɨ́ mbágáne zɨ́a ófụ́ kára zɨ́ye ídíye kéne éyị́ kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Abú oꞌdo née kɨ́ meꞌbené ndịsịnɨ́ kóo ndị́sị eyé ngíṛá yá, komoyé enyị́ ené e wá. ");
INSERT INTO bdh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kámá nɨ kóo mongụ́ ꞌyị lóndó gɨ dongará bangá sinyí ga bɨ Ngére Lomo otoogụ yée ní mbá. Kadra kị́éꞌdo zɨ́a ógụné ndúꞌyú kára kɨ́dí, “Maꞌdíi, Lomo ya ‘Ndásé ánu mɨáná kágá ga bɨ yáká ba mbá wá káa’?” ");
INSERT INTO bdh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Zɨ́ kára née úkulúgu ledre zɨ́ kámá kɨ́dí, “Lomo yaá azé ánu mɨáná kágá ga bɨ yáká ona ba mbá, ");
INSERT INTO bdh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tɨ́ lá dụụ́ kágá máa wo bɨ yana yáká íri née, Lomo yaá ndazé ánu mɨáná a wá, ndazé gbawá óto sị́lị́ze roa káa bɨ azé úyu.” ");
INSERT INTO bdh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Zɨ́ kámá úkulúgu ledre zɨ́ kára née kɨ́dí, “Úyusé esé e wá. ");
INSERT INTO bdh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Lomo owo bú kɨ́dí togụ́ ánusé mɨáná kágá née go yá, komosé nɨ líkpí zɨ́se ówo dongará bɨsinyí ledre kɨ́ bɨlámá ledre, zɨ́se ídíse káa zɨ́ ne Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sɨmɨ bɨ kára née uwú kɨ́dí mɨáná kágá née nɨ bɨlámáne kɨ́ bɨlámá tosoné gɨ ro ánu a, nɨ kpá bɨlámáne gɨ ro íꞌbí komokenzị zɨ́ ꞌyị ní, zɨ́a ꞌdíꞌbi a ánu a. Zɨ́a íꞌbí ngíti a zɨ́ oꞌdo ꞌbɨ ené bɨ nɨyí kéne ní zɨ́a ánú a. ");
INSERT INTO bdh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Née ní geré zɨ́ komo oꞌdo née kɨ́ meꞌbené líkpíne, zɨ́ye ówo a kɨ́dí yée ndịsịnɨ́ ndị́sị ba ngíṛá. Zɨ́ye ndéréye ꞌdécị tịyị́ ócó a royé. ");
INSERT INTO bdh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nda sɨmɨ bɨ kadra ꞌbuꞌbú go ní, zɨ́ oꞌdo née kɨ́ meꞌbené úwú gboṛụ Ngére Lomo kɨ́ ógụ yáká ore, zɨ́ye geré ndéréye lóꞌboyé dongará kágá ga bɨ yáká ore ní. ");
INSERT INTO bdh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Zɨ́ Ngére Lomo ndólo ndúꞌyú oꞌdo née kɨ́dí, “Áyí ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Zɨ́ oꞌdo née úkulúgu ledre kɨ́dí, “Máúwú gáa gboṛụyị́ kɨ́ ogụ, zɨ́ma ndéréma lóꞌbomá gɨ zɨ́ ngịrị gɨ zɨ́a mááyí ngíṛá.” ");
INSERT INTO bdh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ngére Lomo ya zɨ́a ní, “Ambí uku zɨ́yị ne ya áyí ngíṛá? Ánu mɨáná kágá bɨ máyá ndá ánu a wá ní ánu go?” ");
INSERT INTO bdh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Zɨ́a úkulúgu ledre zɨ́ Lomo kɨ́dí, “Kára bɨ íꞌbíógụ wo zɨ́ma ba iꞌbí mɨáná kágá née ne zɨ́ma go ánu a.” ");
INSERT INTO bdh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Zɨ́ Ngére Lomo úku ledre zɨ́ kára née kɨ́dí, “Éyị́ bɨ méngị kenée née ꞌdi?” Zɨ́ kára née úkulúgu ledre zɨ́ Ngére Lomo kɨ́dí, “Kámá londo máa ne zɨ́ma ánu a.” ");
INSERT INTO bdh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Née ní zɨ́ Ngére Lomo úku ledre zɨ́ kámá kɨ́dí, “Gɨ zɨ́a bɨ méngị éyị́ go kenée ní, “Taramá nɨ ndéré kacɨ́yị gɨ dongará bangákụlụ́ e kɨ́ bangá súwú e mbá, áyị́ ndị́sị lála royị́ fú lá mɨlála bi do sɨmɨyị́, áyí ánu ꞌbɨ eyị́ fú lá ꞌbụrụ gị sɨmɨ sịndị́ kadra bɨ áyí úyu sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mááyí óto báfí dongaráse kɨ́ kára née, kpá dongará owụ́ ꞌbɨ eyị́ e kɨ́ owụ́ ꞌbɨ ené e, nɨ ꞌdítí kánya doyị́, zɨ́yị náná ꞌbɨ eyị́ ṛítí a.” ");
INSERT INTO bdh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Zɨ́ Ngére Lomo úku ledre zɨ́ kára kɨ́dí, “Mááyí íꞌbí ꞌdoꞌdó royị́ sɨmɨ sịndị́ kadra ꞌbɨ árá owụ́, áyí ndị́sị árá owụ́ e tɨ́ fú kɨ́ éyị́ mɨówo ꞌbú oꞌdo ꞌbɨ eyị́ nɨ ndị́sị ídí doyị́ kpá fú kɨ́ngaya Áyí ídí fú lá sị́ sị́lị́ oꞌdo ꞌbɨ eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Gɨ ore, zɨ́ Lomo ị́nyịné úku ledre zɨ́ oꞌdo kɨ́dí, “Gɨ zɨ́a bɨ úwú yị́ eyị́ ledre gɨ tara meꞌbeyị́, zɨ́yị ánu mɨáná kágá bɨ kóo máyá, ‘Ndá ánu a wá ní,’ “Máóto taramá go ro káṇgá gɨ zɨ́ ledre eyị́, tɨ́ bɨ áyí ndị́sị ní, áyí méngị moko zɨ́yị ꞌdóꞌdóyị mɨꞌdóꞌdó kí áyí fú ndíki éyị́ mɨánu ánu a. ");
INSERT INTO bdh_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Gɨ zɨ́ kéyị née ní, káṇgá nɨ ndíkiógụ bɨsinyí kágá ga bɨ kɨ́ kị́nịyé kɨ́ súwú ga bɨ kɨ́ mbụꞌdụyé ní zɨ́yị, áyí ndị́sị méngị moko royé cụ́ kɨ́ mokoné áyí fú ndíki éyị́ mɨánu gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Áyí ndị́sị méngị moko kɨ́ bɨsuwu té kí éyị́ mɨánu nɨ fú ídí zɨ́yị. Ledre máa née nɨ ndị́sị méngị roné kenée gị sɨmɨ sịndị́ kadra bɨ áyí ndáꞌbalúgu royị́ sɨmɨ a sɨmɨ káṇgá kɨ́ꞌdí bɨ kóo máꞌdíꞌbiógụ yị́ị ní. Gɨ zɨ́a bɨ ógụ gɨ sɨmɨ káṇgá ní, sịndị́ kadra nɨ ógụ zɨ́yị ndáꞌbalúgu royị́ ídíyị té káa do káṇgá.” ");
INSERT INTO bdh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nda née ní, zɨ́ Ádama ị́fị́ ịrị meꞌbené Áwa, gɨ zɨ́a nɨ ndíkiógụ ꞌyị e mbá ne. ");
INSERT INTO bdh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Zɨ́ Ngére Lomo nda kóo yeme saná káa zɨ́ bongó ní zɨ́ Ádama e kɨ́ Áwa ésị a royé. ");
INSERT INTO bdh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Née ní, zɨ́ Ngére Lomo úku ledre kɨ́dí, “Cakaba ní ꞌyị ga ba owonɨ́ dongará bɨlámá ledre kɨ́ bɨsinyí ledre go káa zɨ́ ze ní. Bɨ go kenée ní, ndazé ótoómo yée zɨ́ye ndị́sị ꞌdécị mɨáná kágá bɨ yáká née ndị́sị ánu a do ndị́sịyé fí trịdrị wá.” ");
INSERT INTO bdh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Née ní, zɨ́ Ngére Lomo go ꞌdíꞌbióyó Ádama e kɨ́ meꞌbené gɨ sɨmɨ yáká bɨ sɨmɨ Édene ní, do óto wo zɨ́a ndị́sịné óꞌdo éyị́ gɨ ro éyị́ mɨánu zɨ́ye gɨ sɨmɨ káṇgá bɨ oꞌbónɨ́ wo gɨ sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Zɨ́ Lomo ꞌdíꞌbi maláyika e kɨ́ fúndúye zɨ́a íꞌbí rokoꞌbụ zɨ́ye do óto yée sɨmɨ yáká bɨ Édene ní mɨꞌdí gbére ndị́sị lúrú bi kacɨ́ a. Zɨ́ éyị́ ndị́sị gámáꞌdíkí yáká née gbaá káa zɨ́ mongụ́ maku ndịsị ꞌbɨ́léꞌbe ne ní káa bɨ ꞌyị nɨ ólụ́ íri ꞌdécị mɨáná kágá ꞌbɨ trịdrị née ánu a ke. ");
INSERT INTO bdh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Gɨ do kacɨ́ ledre née ní, zɨ́ Ádama ndị́sịyé kɨ́ meꞌbené, zɨ́ meꞌbea ídíne kɨ́ sɨmɨné, zɨ́a áráne owụ́oꞌdo. Zɨ́ Áwa úku ledre kɨ́dí, “Mááyí ị́fị́ ịrịa Káyina gɨ zɨ́a mándíki wo kɨ́ sáká éyị́ bɨ gɨ zɨ́ Ngére Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Gɨ do kacɨ́ Káyina, zɨ́a kpá áráne owụ́oꞌdo do ị́fị́ ịrị wo née ꞌbɨ ené Ábele. Zɨ́ owụ́ ga gére née ngbóróógụyé gbrengárá. Káyina áyí ꞌbɨ eyị́ ꞌyị óꞌdo éyị́, Ábele nɨ ꞌbɨ ené nda ꞌyị ụ́lụ́ kábịṛị́kị e. ");
INSERT INTO bdh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kadra kị́éꞌdo zɨ́ Káyina ꞌdíꞌbi ngíti géyị éyị́ ga bɨ gɨ yáká ené ní ndéréne kɨ́ye íꞌbí yée zɨ́ Ngére Lomo. ");
INSERT INTO bdh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tɨ́ lá zɨ́ Ábele óṇgoónzó ꞌduo ndíká ꞌbɨ kábịṛị́kị ené, do ꞌdíꞌbi bɨlámá esị a bɨ kɨ́ sụꞌbụ́ roné ní íꞌbí a káa do mɨkawu zɨ́ Ngére Lomo. Zɨ́ Lomo ídíne kɨ́ mongụ́ rokinyi gɨ zɨ́ Ábele kpá gɨ ro mɨkawu ené bɨ iꞌbí ní, ");
INSERT INTO bdh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tɨ́ lá nda gɨ ro mɨkawu máa bɨ ꞌbɨ Káyina ní, Ngére Lomo ndaá ꞌbɨ ené kóo kɨ́ rokinyi kɨ́e wá. Née ní zɨ́ mɨmbéꞌde Káyina ésị́ne, zɨ́ do komoa ídíne bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Zɨ́ Ngére Lomo úku ledre zɨ́a kɨ́dí, “Káyina, éyị́ bɨ mɨmbéꞌdeyị́ esị́ gɨ zɨ́a ní ꞌdi? Éyị́ bɨ sínyi do komoyị́ gɨ zɨ́a kenée ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Togụ́ ndị́sị méngị ledre bɨ mɨútúásáne ní, káa bɨ ilinɨ́ yị́ị wá? Tɨ́ lá togụ́ méngị ledre bɨ utúasá wá ní, bɨsinyí ledre nɨ go gbóo kɨ́yị. Ídí tóro ngbúó zɨ́yị rómo komoa.” ");
INSERT INTO bdh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Gɨ ore zɨ́ Káyina úku ledre zɨ́ lúnduné Ábele kɨ́dí, “Nderézé aka lúrú bi yáká.” Nda sɨmɨ bɨ nɨyí go yáká íri ní, zɨ́ Káyina útúne do lúnduné Ábele zɨ́a ócóónzó wo. ");
INSERT INTO bdh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Gɨ do kacɨ́ ledre née ní, zɨ́ Ngére Lomo ndúꞌyú Káyina kɨ́dí, “Ábele nɨ ꞌda?” Zɨ́a úkulúgu ledre zɨ́ Lomo kɨ́dí, “Máówo wá, mááyí nda go ꞌyị lúrú bi kacɨ́ lúndumá maꞌdáa?” ");
INSERT INTO bdh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Zɨ́ Ngére Lomo úku ledre zɨ́a kɨ́dí, “Méngị bɨsinyí ledre zɨ́ lúnduyị́ kenée gɨ zɨ́ ꞌdi? Máúwú gboṛụ sáma lúnduyị́ go kɨ́ kúkú bi gɨ zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Cakaba ní, máóto taramá go kacɨ́yị, káṇgá bɨ ewé sáma lúnduyị́ akpa gɨ do sị́lị́yị ní, utúasá lolụ zɨ́yị ndáꞌbayị́ méngị moko sɨmɨ a wá. ");
INSERT INTO bdh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tónóne gɨ ona ndéréne ꞌdáꞌdá, abú áyí óꞌdo éyị́, káṇgá utúasá ꞌdíꞌbiógụ éyị́ mɨánu zɨ́yị wá. Éyị́ bɨ kɨ́ ịrịné ꞌbe ní ndaá gɨ royị́ kpá wá, odụ ledre eyị́ nɨ ídí dụụ́ gámá rịị́ ꞌdága do sogo káṇgá ba.” ");
INSERT INTO bdh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Zɨ́ Káyina úkulúgu ledre zɨ́ Ngére Lomo kɨ́dí, “Áko Ngére, ꞌdoꞌdó bɨ óto domá née romo do rokoꞌbụmá go. ");
INSERT INTO bdh_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Karaba ní óto máa go zɨ́ma ị́nyịmá gɨ do bi bɨ mándị́sị doa ní, máútúásá lolụ kpá ídí gbóo kɨ́yị wá, zɨ́ma nda ídíma go lá mɨgámáma ꞌdága ní, née go umbumá gɨ zɨ́ ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tɨ́ lá zɨ́ Ngére Lomo úkulúgu ledre zɨ́a kɨ́dí, “Ndaá kenée wá, togụ́ ꞌyị ufu yị́ị, mááyí íꞌbí ꞌdoꞌdó ro ꞌyị née rómo do ꞌbɨ eyị́ ba kɨ́ꞌdí ịnyị doa gbre.” Née ní, zɨ́ Lomo éké tífí ro sɨmɨ komo Káyina gɨ ro zɨ́ ꞌyị e ówo a mbá káa bɨ nɨyí úfu wo ke. ");
INSERT INTO bdh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Zɨ́ Káyina ị́nyịné gɨ do komo Lomo gɨ sɨmɨ Édene gɨ ore ndéré ndị́sịné sɨmɨ ngíti káṇgá mɨꞌdí gbére kɨ́ ịrịné Nódụ. ");
INSERT INTO bdh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Née ní, zɨ́ Káyina e kɨ́ meꞌbené ndíki owụ́oꞌdo zɨ́ye ị́fị́ ịrịa Enóka. Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Káyina nɨ kóo ndị́sị óꞌbó gara, zɨ́a ị́nyịné ị́fị́ ịrị owụ́ ꞌbɨ ené bɨ Enóka ní do gara máa née. ");
INSERT INTO bdh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Sɨmɨ bɨ Enóka ngboró ní zɨ́a ndíki Iráda, zɨ́ Iráda ndíki ꞌbɨ ené Mazéla, zɨ́ Mazéla ndíki ꞌbɨ ené Matụséla, zɨ́ Matụséla nda ndíki ꞌbɨ ené Laméke. ");
INSERT INTO bdh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Zɨ́ Laméke ngbóróne zɨ́a ꞌdíꞌbi kará e gbre, Áda e kɨ́ Zíla. ");
INSERT INTO bdh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Zɨ́ Áda ndíki owụ́ do ị́fị́ ịrịa Zabála. Zabála nɨ ne bulúndu ꞌyị ga bɨ ndịsịnɨ́ gámá mɨꞌdaꞌdágá kɨ́ lúrú bi kacɨ́ bangá eyé e sɨmɨ súwú ní. ");
INSERT INTO bdh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ịrị lúndua nɨ ꞌbɨ ené Zụbála. Zụbála nɨ ne bulúndu ꞌyị ga bɨ ꞌyị ụ́cụ kụꞌdụ́ e kpá ꞌyị ímí káṇgá e ní. ");
INSERT INTO bdh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zɨ́ Zíla kpá ndíki ꞌbɨ ené owụ́oꞌdo zɨ́a ị́fị́ ịrịa Tụbụ́la Káyina. Bɨ ngboróogụ ní, zɨ́a ídí ꞌbɨ ené ꞌyị ụ́cụ ꞌboro. Ịrị lémịa kóo Náma. ");
INSERT INTO bdh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kadra kị́éꞌdo zɨ́ Laméke kóo úku ledre zɨ́ meꞌbené ga bɨ gbre ní kɨ́dí, “Kará ꞌbɨ amá e, úwúsé aka kúrúma kúrú oꞌdo ꞌbɨ esé. Máúfu kóo ngíti owụ́oꞌdo gɨ zɨ́a oto kóo uṇgú romá. ");
INSERT INTO bdh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Togụ́ Lomo úku kóo kɨ́dí ꞌyị bɨ nɨ óto sị́lị́ne ro Káyina ní, née nɨ ꞌdóꞌdo wo kíꞌdí ịnyị doa gbre. Máa Laméke togụ́ ꞌyị oto sị́lị́ne romá, mááyí ꞌbɨ amá ꞌdóꞌdo wo kíꞌdí cị́ ota doa sokó doa ịnyị doa gbre.” ");
INSERT INTO bdh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Gɨ do kacɨ́ umbu Ábele, zɨ́ Ádama e ndíki ngíti owụ́oꞌdo zɨ́ye ị́fị́ ịrị a Séte. Zɨ́ye úku ledre kɨ́dí, “Mbófo éyị́, Lomo iꞌbíogụ dobikulú Ábele bɨ kóo lúndua ufu ní go zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Gɨ ore zɨ́ Séte ndíki owụ́oꞌdo, zɨ́ye ị́fị́ ịrị a Enósa. Née nda go sịndị́ kadra bɨ kóo zɨ́ ꞌyị e ndị́sịyé íni ini zɨ́ Ngére Lomo sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ba ledre ga bɨ kóo gɨ ro Ádama kɨ́ bulúnduné e ní. Sɨmɨ bɨ kóo Lomo otoogụ ꞌyịmaꞌdí e ní, otoogụ kóo yée cé káa zɨ́ ne ní. ");
INSERT INTO bdh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Otoogụ kóo yée oꞌdo kɨ́ kára, zɨ́a ị́fị́ ịrịyé kɨ́dí, “ꞌYịmaꞌdí e.” Zɨ́a ị́nyịné íꞌbí úndru zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sɨmɨ bɨ kóo sɨmɨbi ꞌbɨ Ádama nɨ go míya kị́éꞌdo doa cị́ kéṛị́ doa sokó (130) ní, zɨ́a kóo ndíkiógụ tosoné owụ́oꞌdo zɨ́a ị́fị́ ịrị owụ́ maꞌdáa Séte. ");
INSERT INTO bdh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Zɨ́ Ádama ndị́sịné gɨ do kacɨ́ bɨ ndikinɨ́ Séte ní, sɨmɨbi míya ịnyị doa ota (800). Zɨ́a kóo kpá ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ádama nɨ úyu ní, mengị do sogo káṇgá go sɨmɨbi míya ịnyị doa eso doa cị́ kéṛị́ doa sokó (930). ");
INSERT INTO bdh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɨmɨ bɨ kóo sɨmɨbi nɨ do Séte go míya doa ịnyị (105) ní, zɨ́a ndíki Enósa. ");
INSERT INTO bdh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Gɨ do kacɨ́ a née, zɨ́a ndị́sịné sɨmɨbi míya ịnyị doa ota doa ịnyị doa gbre (807). Zɨ́a ndíki ngíti géyị owụ́ e yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɨmɨbi nɨ kóo do Séte mbá míya ịnyị doa eso doa sókó doa gbre (912) zɨ́a kóo úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sɨmɨ bɨ kóo Enósa mengị go sɨmɨbi cị́ eso doa sokó (90) ní, zɨ́a ndíki Kenána. ");
INSERT INTO bdh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Zɨ́ Enósa méngịné gɨ do kacɨ́ Kenána née sɨmɨbi e míya ịnyị doa ota doa sokó doa ịnyị (815). Zɨ́a ndíki ngíti géyị owụ́ e yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nɨ nda kóo úyu ní sɨmɨbi nɨ kóo doa go mbá míya ịnyị doa eso doa ịnyị (905). ");
INSERT INTO bdh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sɨmɨ bɨ Kenána nɨ kóo go kɨ́ sɨmɨbi cị́ ota doa sokó (70) zɨ́a ndíki Malále. ");
INSERT INTO bdh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Gɨ do kacɨ́ Malále zɨ́a méngịné sɨmɨbi e míya ịnyị doa ota doa cị́ gbre (840), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenána mengị kóo mbá sɨmɨbi míya ịnyị doa eso doa sokó (910), zɨ́a úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malále mengị kóo ꞌbɨ ené sɨmɨbi cị́ ota doa ịnyị (65), zɨ́a ndíki Yéreda. ");
INSERT INTO bdh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Gɨ do kacɨ́ a née, zɨ́ Malále méngịné sɨmɨbi míya ịnyị doa ota doa cị́ kéṛị́ doa sokó (830), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malále mengị kóo mbá sɨmɨbi míya ịnyị doa ota doa cị́ eso doa sokó doa ịnyị (895), zɨ́a úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yéreda mengị kóo mbá sɨmɨbi míya kị́éꞌdo doa cị́ ota doa gbre (162) zɨ́a ndíki Enóka. ");
INSERT INTO bdh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nda gɨ do kacɨ́ a née, zɨ́a méngịné sɨmɨbi míya ịnyị doa ota (800), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yéreda mengị kóo mbá sɨmɨbi míya ịnyị doa eso doa cị́ ota doa gbre (962), zɨ́a úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enóka mengị kóo mbá sɨmɨbi cị́ ota doa ịnyị (65), zɨ́a ndíki Metụséla. ");
INSERT INTO bdh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Zɨ́a méngịné gɨ do kacɨ́ Metụséla née sɨmɨbi míya ota (300), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. Iliofụnɨ́ kóo ledre ꞌbɨ Lomo go. ");
INSERT INTO bdh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enóka mengị kóo mbá sɨmɨbi míya ota doa cị́ ota doa ịnyị (365). ");
INSERT INTO bdh_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ndị́sị ꞌbɨ Enóka kɨ́ mɨméngị ledre ené nɨ kóo bɨlámáne do komo Lomo. Gɨ zɨ́ kéyị née ní, zɨ́ Lomo kóo ꞌdíꞌbi wo lá wayí. ");
INSERT INTO bdh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Zɨ́ Metụséla kóo méngịné mbá sɨmɨbi míya kị́éꞌdo doa cị́ eso doa ịnyị doa gbre (187), zɨ́a ndíki Laméke. ");
INSERT INTO bdh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Gɨ do kacɨ́ a née, zɨ́a méngịné sɨmɨbi míya ịnyị doa gbre doa cị́ eso doa gbre (782) zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Zɨ́a nda kóo úyuné sɨmɨ bɨ mengị kóo go mbá sɨmɨbi míya ịnyị doa eso, doa cị́ ota doa ịnyị doa eso (969) ní. ");
INSERT INTO bdh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laméke mengị kóo mbá sɨmɨbi míya kị́éꞌdo doa cị́ eso doa gbre (182), zɨ́a ndíki owụ́oꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Zɨ́a ị́fị́ ịrịa Nówa. Zɨ́a úku ledre gɨ roa kɨ́dí, “Ba go owụ́ bɨ nɨ sáká zée gɨ sɨmɨ ꞌdoꞌdó bɨ ndịsịzé ꞌdóꞌdó a kɨ́ méngị moko sɨmɨ káṇgá bɨ Lomo oto tarané kacɨ́ a ní.” ");
INSERT INTO bdh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Zɨ́ Laméke kóo méngịné mbá sɨmɨbi míya ịnyị doa cị́ eso doa sokó doa ịnyị (595) gɨ do kacɨ́ bɨ ndikinɨ́ Nówa ní. Zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Zɨ́a úyuné sɨmɨ bɨ kóo sɨmɨbi nɨ doa go mbá míya ịnyị doa gbre doa cị́ ota doa sokó doa ịnyị doa gbre (777) ní. ");
INSERT INTO bdh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Sɨmɨ bɨ Nówa mengị go sɨmɨbi míya ịnyị (500) ní, zɨ́a ndíki owụ́ e ota mbá owụ́ yaꞌdá e. Owụ́ maáge kóo Séme, Áma nda kɨ́ Yépeta. ");
INSERT INTO bdh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sɨmɨ bɨ ꞌyị e nɨyí nda go étrị do sogo káṇgá kɨ́ngaya ní, zɨ́ yée ndíki tụ́ꞌdụ́ owụ́ kará e, ");
INSERT INTO bdh_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","zɨ́ owụ́ yaꞌdá e gɨ sɨmɨ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní lurú owụ́ kará ga gére née kɨ́ ꞌbúne gɨ zɨ́ lámá bɨ royé ní. Zɨ́ye ndị́sịyé ꞌdíꞌbi yée káa do kará e. ");
INSERT INTO bdh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Zɨ́ ledre née sínyíne ro Lomo, zɨ́a úku ledre kɨ́dí, “Máútúásá lolụ ótoómo ꞌDówụ́ma sɨmɨ ꞌyịmaꞌdí e zɨ́ye ndị́sịyé trịdrịyé za fí ní wá gɨ zɨ́a nɨyí úyu mɨúyu. Odụ sɨmɨbi eyé nɨ ídí dụụ́ míya kị́éꞌdo doa cị́kéṛị́ (120) zɨ́ye úyuyé.” ");
INSERT INTO bdh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mɨngburoko raga ꞌyị e nɨyí kóo bo do sogo káṇgá sɨmɨ sịndị́ kadra bɨ kóo owụ́ ꞌbɨ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní ndịsịnɨ́ ndiki owụ́ e kɨ́ nyị́ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní. Nɨyí kóo ye ꞌyị ga bɨ kɨ́ rokoꞌbụyé, ịrịyé ndịsị ówụ́ mɨówụ́ sɨmɨ sịndị́ kadra máa bɨ kóo née ní. ");
INSERT INTO bdh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Zɨ́ Lomo lurú mɨngbóró bɨsinyí ledre ꞌbɨ ꞌyịmaꞌdí e do sogo káṇgá, mɨméngị ledre eyé kɨ́ mɨsómụ́ ledre eyé nɨ nda yị́ ené go mbá bɨsinyíne kɨ́ngaya kacɨ́ kadra mbá, ");
INSERT INTO bdh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","zɨ́ ledre née sínyíne ro Ngére Lomo zɨ́ mɨmbéꞌdea ꞌdécịné gɨ zɨ́a mɨꞌdécị gɨ zɨ́a bɨ otoogụ ꞌyịmaꞌdí e ne do sogo káṇgá ní. ");
INSERT INTO bdh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Zɨ́a úku ledre kɨ́dí, “Mááyí úfuóyó ꞌyị ga gére née mbá ꞌdáꞌba. Zɨ́ma kpá úfuóyó bangá e, solụ́ e, kɨ́ éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní mbá ꞌdáꞌba. Mááyí kɨ́ mongụ́ lerị́ zɨ́ma ótoógụ yée” ");
INSERT INTO bdh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Odụ ꞌyị bɨ kóo nɨ bɨlámáne do komo Lomo ní dụụ́ Nówa. ");
INSERT INTO bdh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ba owụ́ ledre gɨ ro Nówa. Nówa nɨ kóo mbigí ꞌyị ꞌbɨ Lomo, zɨ́ mɨméngị ledre ené ídíne mbá bɨlámáne gɨ dongará ꞌbɨ ꞌyị ga bɨ kóo sɨmɨ sịndị́ kadra née. ");
INSERT INTO bdh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nówa maꞌdáa ndiki kóo owụ́ e ota, Séme, Áma kɨ́ Yépeta. ");
INSERT INTO bdh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nda gɨ ore zɨ́ mɨméngị ledre ꞌbɨ ꞌyịmaꞌdí e do sogo káṇgá ídí ené nda go bɨsinyíne kɨ́ngaya do komo Lomo, gɨ zɨ́a ambáye nda yị́ ené kóo go lá góo rará. ");
INSERT INTO bdh_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Sɨmɨ bɨ Lomo lurú do sogo káṇgá nɨ nda yị́ ené go kenée ní, zɨ́a ówo a kɨ́dí do sogo káṇgá sinyí go gɨ zɨ́a mɨméngị ledre ꞌbɨ ꞌyịmaꞌdí e nɨ nda yị́ ené go mbá bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Née ní zɨ́ Lomo úku ledre zɨ́ Nówa kɨ́dí, “Máyéme romá go gɨ ro zɨ́ma úfuónzó ꞌyịmaꞌdí e za mbá, gɨ zɨ́a do sogo káṇgá sinyíonzó roné go gɨ zɨ́ rará eyé. Káa zɨ́ bɨ go kenée ní, mááyí go ógụ úfuónzó yée kɨ́ éyị́ trịdrị e gɨ do sogo káṇgá za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ídí yéme mongụ́ kuṛúngba zɨ́yị gɨ sɨmɨ kágá bɨ kɨ́ rokoꞌbụné ní. Zɨ́yị ífi ꞌdécị sɨmɨa tụ́ꞌdụ́ káa zɨ́ ifinɨ́ sɨmɨ ꞌdị́cị́ ní, zɨ́yị kúṛúṛu sɨmɨyé mɨkúṛúṛu kɨ́ koꞌdó ꞌdị́cị́ kɨ́ sága mbá. ");
INSERT INTO bdh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mɨyéme a idí ídí káa, mɨákpa a idí ídí mɨólo komo sịndị́ ꞌyị míya eso cị́ gbre doa sokó (450), mɨáya a idí ídí mɨólo komo sịndị́ ꞌyị cị́ ota doa sokó doa ịnyị (75), mɨóló a nda ꞌbɨ ené mɨólo komo sịndị́ ꞌyị cị́ gbre doa ịnyị (45). ");
INSERT INTO bdh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ídí ꞌdóro doa káa zɨ́ do ꞌdị́cị́ ní, zɨ́yị ótoómo bifúó dongará doa née kɨ́ gbɨ́gérị a gɨ ro síli. Sɨmɨ kuṛúngba maꞌdáa, idí ídí ota ngíti a ꞌdága, ngíti a yana ngíti a nda ꞌbɨ ené nde. Zɨ́yị óto mbotụ do gboṛụ a. ");
INSERT INTO bdh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ídí úwú ledre ba bɨlámáne, gɨ zɨ́a mááyí go ógụ kásaógụ mongụ́ iní zɨ́a úcuné do sogo káṇgá mbá, zɨ́ ꞌyịmaꞌdí e kɨ́ éyị́ trịdrị e úyuyé za mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tɨ́ lá mɨyéme ledre nɨ ídí dongaráze kéyị káa, ídí ꞌdíꞌbi meꞌbeyị́ kɨ́ owụ́ ꞌbɨ eyị́ e kɨ́ meꞌbeyé e zɨ́se ólụ́se sɨmɨ kuṛúngba. ");
INSERT INTO bdh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ídí ꞌdíꞌbiútú ṛị́kị́ sị́ do éyị́ trịdrị e yaꞌdáye kɨ́ karáye mbá gɨ ro zɨ́se ómosé kéye sɨmɨ kuṛúngba íri gɨ ro zɨ́ye ídíye trịdrị gɨ zɨ́ mongụ́ iní. ");
INSERT INTO bdh_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Zɨ́yị kpá ꞌdíꞌbiútú ṛị́kị́ sị́ do solụ́ e, bangá e kɨ́ éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní, yaꞌdáye kɨ́ karáye mbá kpa kɨ́yị sɨmɨ kuṛúngba íri, gɨ ro zɨ́se ómosé ndro kéye. ");
INSERT INTO bdh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Gɨ ore zɨ́yị kpá ꞌdíꞌbi éyị́ mɨánu kacɨ́ sị́ doyé mbá kpa zɨ́yị bándáóto yée gɨ rosé kɨ́ éyị́ trịdrị ga gére née.” ");
INSERT INTO bdh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Zɨ́ Nówa méngị ledre ga gére née tɨ́ za cé káa zɨ́ bɨ Lomo uku zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Sɨmɨ bɨ sịndị́ kadra utúasá go ní, zɨ́ Ngére Lomo úku ledre zɨ́ Nówa kɨ́dí, “Nówa, ólụ́sé mu kɨ́ meꞌbeyị́, kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ eyị́ e mbá sɨmɨ kuṛúngba gɨ zɨ́a gɨ dongará ꞌyị ga bɨ sɨmɨ sịndị́ kadra máa ba ní, áyí dụụ́ yị́ị mbigí ꞌyị amá. ");
INSERT INTO bdh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sɨmɨ bɨ ásé go ólụ́ ní, ídí ꞌdíꞌbi ṛị́kị́ sị́ do bɨlámá bangá e ịnyị doa gbre, yaꞌdáye kɨ́ karáye. Zɨ́yị ꞌdíꞌbi ṛị́kị́ sị́ do bɨsinyí bangá e yaꞌdáye kɨ́ karáye. ");
INSERT INTO bdh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nda gɨ ore zɨ́yị ꞌdíꞌbi ṛị́kị́ sị́ do solụ́ e kpá ịnyị doa gbre, yaꞌdáye kɨ́ karáye, káa bɨ kúfúye nɨ ụ́ngbụ ke. ");
INSERT INTO bdh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gɨ do kacɨ́ sị́lị́ ịnyị doa gbre mááyí go ógụ kása iní zɨ́a éꞌdịné kɨ́ sị́lị́ cị́ gbre kɨ́ ndụlụ e kɨ́ kadra mbá gɨ ro zɨ́a úfuónzó éyị́ trịdrị ga bɨ ndịsịnɨ́ ndị́sị gbére bɨ máótoógụ yée ní mbá ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Zɨ́ Nówa méngị ledre ga gére née go tɨ́ káa zɨ́ bɨ Ngére Lomo uku zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Sɨmɨ bɨ iní née nɨ kóo ógụ éꞌdị ní, Nówa nɨ kóo go kɨ́ sɨmɨbi míya ịnyị doa kéṛị́ (600). ");
INSERT INTO bdh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Née ní, zɨ́ Nówa ị́nyịyé kɨ́ meꞌbené, kɨ́ wotị́ne e kɨ́ meꞌbeyé e mbá do ólụ́ye sɨmɨ kuṛúngba gɨ ro ómoyé gɨ zɨ́ mongụ́ iní née. ");
INSERT INTO bdh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Zɨ́ bɨlámá bangá kɨ́ bɨsinyí bangá ga bɨ Lomo uku ledreyé zɨ́ Nówa ní, solụ́ e, kɨ́ éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní, ");
INSERT INTO bdh_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","yaꞌdáye kɨ́ karáye ólụ́ye kɨ́ Nówa e mbá sɨmɨ kuṛúngba káa zɨ́ bɨ Lomo uku zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gɨ do kacɨ́ sị́lị́ ịnyị doa gbre, zɨ́ mongụ́ iní née ꞌdíꞌbi bi do tónóne éꞌdịné. ");
INSERT INTO bdh_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Sɨmɨ sɨmɨbi bɨ sɨmɨbi do Nówa go míya ịnyị doa kéṛị́ (600) ní, sɨmɨ gbre éfé sɨmɨ ꞌdúꞌdu ené sokó doa ịnyị doa gbre, zɨ́ mongụ́ iní ndị́sị lágaógụné gɨ sɨmɨ káṇgá do sogo káṇgá, zɨ́ wo bɨ ndịsị éꞌdị gɨ komo ere ní ndị́sị léfené káa zɨ́ ere likpí go mɨlíkpí ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Zɨ́ iní née éꞌdịné kɨ́ ndụlụ e kɨ́ kadra mbá kɨ́ sị́lị́ cị́ gbre. ");
INSERT INTO bdh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Née kadra bɨ kóo Nówa e kɨ́ meꞌbené kɨ́ wotị́ye ga bɨ ota, Séme, Áma kɨ́ Yépeta kɨ́ meꞌbeyé e mbá olụ́nɨ́ sɨmɨ kuṛúngba ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ꞌDiꞌbiutúnɨ́ kóo bangá súwú e kacɨ́ ṛị́kị́ sị́ doyé, bangákụlụ́ e kacɨ́ ṛị́kị́ sị́ doyé, éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní kpá kacɨ́ ṛị́kị́ sị́ doyé, nda kɨ́ solụ́ e kɨ́ éyị́ trịdrị ga bɨ kɨ́ fúndúye ní kacɨ́ ṛị́kị́ sị́ doyé mbá. ");
INSERT INTO bdh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zɨ́ eyị́ trịdrị ga gére née ógụyé kacɨ́ sị́ doyé e mbá gbre gbre ólụ́ye kɨ́ Nówa e sɨmɨ kuṛúngba. ");
INSERT INTO bdh_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Éyị́ trịdrị ga bɨ kóo mbá olụ́nɨ́ sɨmɨ kuṛúngba ní, nɨyí kóo kɨ́ yaꞌdáye kɨ́ karáye káa zɨ́ bɨ kóo Lomo uku zɨ́ Nówa ní. Gɨ ore zɨ́ Ngére Lomo ꞌdụ́tụ mbotụ. ");
INSERT INTO bdh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Zɨ́ iní éꞌdịné kɨ́ sị́lị́ cị́ gbre, do úcuné do sogo káṇgá kɨ́ngaya, zɨ́ mɨúcu iní née ndị́sịné sị́kpị kuṛúngba ndéré kɨ́e ꞌdága gɨ do sogo káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Zɨ́ iní nda úcuné go bɨsinyíne kɨ́ngaya do sogo káṇgá, zɨ́ kuṛúngba ndị́sị élené doa ndéréne ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nda gɨ ore zɨ́ mɨúcu iní née úcuꞌdụ́tụ do mɨngburoko ngbángbá landa ga bɨ do sogo káṇgá ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Zɨ́a úcutátá roné ꞌdága kɨ́ngaya, zɨ́ mɨngburoko landa ga gére ídíye mbá sị́ iní nde. Zɨ́ iní ídíne ꞌdága gɨ do landa mítiri ịnyị doa gbre. ");
INSERT INTO bdh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Za ṛị́kị́ éyị́ trịdrị e ga bɨ ndịsịnɨ́ ndị́sị gbére kacɨ́ sị́ doyé mbá, solụ́ e, bangákụlụ́ e, bangá súwú e nda kɨ́ éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní kɨ́ ꞌyịmaꞌdí e, úyuónzó royé za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Éyị́ ga bɨ kɨ́ ꞌdówụ́ sɨmɨyé bɨ ndịsịnɨ́ ndị́sị gbére ní, zɨ́ye úyuónzó royé za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Lomo úfuónzó éyị́ trịdrị ga bɨ ndịsịnɨ́ ndị́sị gbére ní go za mbá, ꞌyịmaꞌdí e, bangá e, solụ́ e, nda kɨ́ éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní. Otoomo tɨ́ lá dụụ́ Nówa kɨ́ éyị́ trịdrị ga bɨ nɨyí kéye sɨmɨ kuṛúngba íri ní. ");
INSERT INTO bdh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Zɨ́ iní bɨ ucu née tóroné do sogo káṇgá kɨ́ sị́lị́ míya kị́éꞌdo, cị́ gbre doa sokó. ");
INSERT INTO bdh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tɨ́ lá Lomo somụ́lịgị ledre Nówa kɨ́ éyị́ trịdrị ga bɨ kɨ́e sɨmɨ kuṛúngba ní wá. Zɨ́ Lomo kásaógụ síli zɨ́a ndị́sị ílíne do sogo káṇgá gɨ ro zɨ́ iní bɨ ucu née tónó ndụ́kụ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Née ní zɨ́ mɨlága iní bɨ gɨ sɨmɨ káṇgá ótoómo kɨ́ lágaógụné, zɨ́ wo bɨ ndịsị éꞌdị gɨ komo ere ní ndímíne. ");
INSERT INTO bdh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Zɨ́ iní bɨ kóo ucu née, tónó ndụ́kụ́ne ndoo gɨ do sogo káṇgá. Nɨ ndéréógụ sɨmɨ sị́lị́ míya kị́éꞌdo, cị́ gbre doa sokó ní, iní ndụkụ́onzó roné go. ");
INSERT INTO bdh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nda sɨmɨ ꞌdúꞌdu sokó doa ịnyị doa gbre ꞌbɨ ịnyị doa gbre éfé, zɨ́ kuṛúngba ndéré ndị́sịné do ngíti landa kɨ́ ịrịné Araráta. ");
INSERT INTO bdh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Zɨ́ iní nda ndị́sịné go fú lá ndụ́kụ́ tátá roné nde. Nda go sɨmɨ mɨzefị sị́lị́ ꞌbɨ sokó éfé, zɨ́ do ngíti géyị landa e go ólụ́ógụyé sága. ");
INSERT INTO bdh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Gɨ do kacɨ́ sị́lị́ cị́ gbre, zɨ́ Nówa líkpí bifúó bɨ otoomo ro kuṛúngba ní, ");
INSERT INTO bdh_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","zɨ́a ị́nyịné kása solụ́ bɨ kɨ́ ịrịné fóro ní, nderé yị́ ené fí, zaá gị zɨ́ iní ndụ́kụ́ónzó roné té kí. ");
INSERT INTO bdh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Gɨ do kacɨ́ a née, zɨ́a kása kị́ṛịkóꞌdo gɨ ro zɨ́a ndéréne lúrú bi togụ́ iní ndụkụ́onzó roné gɨ do káṇgá go yá. ");
INSERT INTO bdh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tɨ́ lá sɨmɨ bɨ kị́ṛịkóꞌdo nderéogụ íri ní, bi útú a bi ndaá gɨ zɨ́a iní nɨ aka yị́ ené fú lá bo do sogo káṇgá, zɨ́a ndáꞌbalúgu roné zɨ́ Nówa sɨmɨ kuṛúngba. Zɨ́ Nówa ésịógụ sị́lị́ne do ꞌdíꞌbilúgu wo sɨmɨ kuṛúngba. ");
INSERT INTO bdh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Zɨ́ Nówa ndị́sịné kɨ́ sị́lị́ ịnyị doa gbre, zɨ́a kpá kása ándá kị́ṛịkóꞌdo ndéré lúrú bi. ");
INSERT INTO bdh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Sɨmɨ bɨ kị́ṛịkóꞌdo ndaꞌbaogụ nda kɨ́ tagá ní, nɨ nda go kɨ́ mbílí kágá bɨ olíva ní tarané. Gɨ ore zɨ́ Nówa owo a kɨ́dí iní ndụkụ́ go. ");
INSERT INTO bdh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Zɨ́a ndị́sịné gɨ do kacɨ́ a née kpá sị́lị́ ịnyị doa gbre, zɨ́a kpá kásalúgu kị́ṛịkóꞌdo. Tɨ́ lá ndéré máa bɨ ndéré née ní, ndaꞌbalugu ené lolụ roné zɨ́ Nówa wá. ");
INSERT INTO bdh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, sɨmɨbi ꞌbɨ Nówa nɨ kóo go míya ịnyị doa kéṛị́ doa kị́éꞌdo (601). Sɨmɨ mɨzefị ꞌdúꞌdu ꞌbɨ éfé ꞌbɨ sɨmɨbi máa née ní, zɨ́ iní ndụkụ́onzó roné gɨ do sogo káṇgá. Zɨ́ Nówa líkpí do kuṛúngba, nɨ lúrú bi ní, do káṇgá nɨ go gágá. ");
INSERT INTO bdh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nɨ ndéréógụ bɨ sɨmɨ sị́lị́ cị́ kéṛị́ doa ịnyị doa gbre ꞌbɨ gbre éfé ní, do káṇgá gagá go ngéré. ");
INSERT INTO bdh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Née ní, zɨ́ Lomo úku ledre zɨ́ Nówa kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nówa ólụ́ógụsé gɨ sɨmɨ kuṛúngba mu, yị́ị kɨ́ meꞌbeyị́, nda kɨ́ wotị́se e kɨ́ meꞌbeyé e. ");
INSERT INTO bdh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Zɨ́yị ꞌdíꞌbiógụ éyị́ trịdrị ga bɨ kɨ́yị íri ní sága, solụ́ e, bangá e nda éyị́ trịdrị máa yée ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní gɨ ro zɨ́ye étrịlúgu royé do ídíye tụ́ꞌdụ́ do sogo káṇgá.” ");
INSERT INTO bdh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Née ní, zɨ́ Nówa ólụ́ógụyé sága kɨ́ meꞌbené, nda kɨ́ wotị́ne e kɨ́ meꞌbeyé e. ");
INSERT INTO bdh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Zɨ́ bangá e, kɨ́ éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní nda kɨ́ solụ́ ga bɨ kóo kéye sɨmɨ kuṛúngba ní ólụ́ógụyé mbá sága kacɨ́ sị́ doyé e mɨngúngúcua. ");
INSERT INTO bdh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Née ní, zɨ́ Nówa óꞌbó mbayi zɨ́ Ngére Lomo. Zɨ́a ꞌdíꞌbi ṛị́kị́ sị́ do bɨlámá bangá e kɨ́ solụ́ ga bɨ bɨlámáye ní óṇgoónzó yée do óngbó yée do mbayi née káa do éyị́ ꞌdáná. ");
INSERT INTO bdh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Zɨ́ Lomo ídíne kɨ́ mongụ́ rokinyi gɨ ro ꞌdáná éyị́ bɨ Nówa ꞌdaná zɨ́a ní. Zɨ́a ódroné zɨ́ne kɨ́ roné kɨ́dí, “Tónóne karaba ndéréne ꞌdáꞌdá, máóto lolụ taramá kacɨ́ káṇgá gɨ zɨ́ lúyú ledre ꞌbɨ ꞌyịmaꞌdí e wá. Mɨméngị ledre ꞌbɨ ꞌyịmaꞌdí e mbá nɨ yị́ ené bɨsinyíne kú gɨ do owụ́ye, tɨ́ lá máúfuónzó lolụ éyị́ ga bɨ kɨ́ ꞌdówụ́ sɨmɨyé ní káa zɨ́ wo bɨ máméngị ba wá. ");
INSERT INTO bdh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Tɨ́ káa zɨ́ bɨ do sogo káṇgá nɨ ídí ꞌbɨ ené ní, sịndị́ kadra ꞌbɨ éyị́ e mbá nɨyí ídí, sịndị́ kadra ꞌbɨ ꞌdị́yị́ éyị́ e, kɨ́ sịndị́ kadra ꞌbɨ ꞌdóꞌdụ́ógụ éyị́ e gɨ yáká, sịndị́ kadra ꞌbɨ drụ́ kɨ́ sịndị́ kadra ꞌbɨ bi mɨị́rị́, sịndị́ kadra ꞌbɨ lịmị kɨ́ sịndị́ kadra ꞌbɨ ndumu, nda kɨ́ sịndị́ kadra ꞌbɨ kadra kɨ́ sịndị́ kadra ꞌbɨ ndụlụ. Éyị́ ga gére née nɨyí ídí kenée za fí.” ");
INSERT INTO bdh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gɨ do kacɨ́ née ní, zɨ́ Lomo íꞌbí úndru zɨ́ Nówa e kɨ́ wotị́ne e zɨ́a úku ledre zɨ́ye kɨ́dí, “Ídísé étrị zɨ́ bulúndusé e ídíye tụ́ꞌdụ́ do sogo káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bangá e kɨ́ solụ́ e mbá, nda kɨ́ éyị́ trịdrị ga bɨ ndịsịnɨ́ ndéré kɨ́ do sɨmɨyé bi ní kɨ́ kénzé e, nɨyí ndị́sị éré ngịrịsé mɨéré gɨ zɨ́a máóto yée go sị́ sị́lị́se. ");
INSERT INTO bdh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Éyị́ ga bɨ za mbá ndịsịnɨ́ gámá mɨgámá kɨ́ trịdrị sɨmɨyé ní, máíꞌbí yée go zɨ́se káa do éyị́ mɨánu cé káa zɨ́ bɨ kóo máíꞌbí fụtụ́ éyị́ e zɨ́se ndị́sịsé ánu yée ní. ");
INSERT INTO bdh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Tɨ́ lá ndásé ánu esị bɨ kɨ́ sáma sɨmɨné ní wá. Máási kɨ́e gɨ zɨ́se gɨ zɨ́a trịdrị bɨ sɨmɨ sáma nɨ aka sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Káa zɨ́ bɨ go kenée née ní, togụ́ ꞌyị ufu ezené ꞌyịmaꞌdí mááyí kpá úfu wo. Kpá kenée bangá bɨ úfu ꞌyịmaꞌdí go ní mááyí kpá úfu a ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Lomo otoogụ ꞌyịmaꞌdí cé káa zɨ́ ne ní, gɨ zɨ́ kéyị née ní ꞌyị ufu ꞌyịmaꞌdí, eze a ꞌyịmaꞌdí nɨ úfu wo kpá ne. ");
INSERT INTO bdh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Gɨ zɨ́ kéyị née ní, ili go zɨ́se étrịsé kɨ́ngaya zɨ́ bulúndusé e ídíye do sogo káṇgá ba za mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Née ní zɨ́ Lomo úku ándá ledre zɨ́ Nówa kɨ́ wotị́ne e kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Bɨ ba ní, máóto mɨyéme ledre go gɨ ro zɨ́ma méngị a zɨ́se kɨ́ bulúndusé ga bɨ nɨyí ógụ gɨ do kacɨ́se ní, ");
INSERT INTO bdh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kpá kɨ́ éyị́ trịdrị ga bɨ ólụ́ógụsé kéye gɨ sɨmɨ kuṛúngba, solụ́ e, bangákụlụ́ e, kɨ́ bangá súwú e ní. ");
INSERT INTO bdh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Máóto go káa do mɨyéme ledre zɨ́ze kɨ́se, éyị́ ndaá lolụ íri do úfuónzó éyị́ trịdrị e kɨ́ mɨúcu iní do sogo káṇgá ní wá.” ");
INSERT INTO bdh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Née ní zɨ́ Lomo úku ledre kɨ́dí, “Ba lị́lị mɨyéme ledre bɨ máyéme go gɨ ro zɨ́a ídíne dongaráze kɨ́se kɨ́ éyị́ trịdrị e mbá ní, yée ga bɨ cakaba ba kɨ́ yée ga bɨ nɨyí ídí karanée ní. ");
INSERT INTO bdh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Máóto mɨ́kóṛụ́ amá go komo ere zɨ́a ídíne káa do lị́lị mɨyéme ledre dongaráze kɨ́se kɨ́ do sogo káṇgá mbá. ");
INSERT INTO bdh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kɨ́ꞌdí bɨ mákása mongụ́ iní go gɨ ro zɨ́a éꞌdịné do sogo káṇgá ní, mɨ́kóṛụ́ nɨ ólụ́ógụ. ");
INSERT INTO bdh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Togụ́ olụ́ogụ go kenée, mááyí geré sómụ́ndíki mɨyéme ledre bɨ máyéme dongaráze kɨ́se kɨ́ éyị́ trịdrị e kacɨ́ sị́ doyé e mbá ní. Iní ucu andá lolụ roné zɨ́a úfuónzó éyị́ trịdrị mbá wá. ");
INSERT INTO bdh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kɨ́ꞌdí bɨ mɨ́kóṛụ́ ólụ́ógụ go kenée ní, mááyí lúrúndíki a zɨ́ma geré sómụ́ndíki ledre mɨyémeóto ledre bɨ máyéme dongaráze kɨ́se kɨ́ éyị́ trịdrị e do sogo káṇgá mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nda gɨ ore zɨ́ Lomo úku ledre zɨ́ Nówa kɨ́dí, “Ba go lị́lị mɨyéme ledre bɨ máyémeóto dongaráze kɨ́se kɨ́ éyị́ trịdrị e do sogo káṇgá mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wotị́ Nówa ga bɨ kóo olụ́ogụnɨ́ kéye gɨ sɨmɨ kuṛúngba ní nɨyí, Séme, Áma kɨ́ Yépeta. Áma nɨ ne ꞌbụ Kanána. ");
INSERT INTO bdh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wotị́ Nówa ga bɨ ota née, nɨyí ye bulúndu ꞌyịmaꞌdí e do sogo káṇgá mbá. ");
INSERT INTO bdh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nówa nɨ ne mɨzefị ꞌyị bɨ kóo tonó óꞌdo yáká do ꞌdị́yị́ kóṛó sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sɨmɨ bɨ Nówa ewé leꞌyị́ kóṛó née ní, zɨ́a kóyóne, zɨ́a útú ꞌdúꞌduné gɨ zɨ́a ngíṛá sị́ kụ́tụ́ kacɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Zɨ́ Áma ꞌbụ Kanána ólụ́ ndíki ꞌbụyé kɨ́ ꞌdúꞌdu ngíṛá, zɨ́a ólụ́ógụné ndéréne úku a zɨ́ lúnduné e sága. ");
INSERT INTO bdh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tɨ́ lá zɨ́ Séme kɨ́ Yépeta ꞌdíꞌbi mbílí bongó yáya do goyé zɨ́ye ólụ́ye kɨ́e kɨ́ sogoyé sị́ kụ́tụ́ do lóꞌbụ a do ꞌbụyé kɨ́ ꞌdúꞌdu ngíṛá. Oyóloꞌbónɨ́ komoyé gbụ́ gɨ ꞌdí keṛị́ káa bɨ yée nɨyí lúrú ngíṛá ꞌbụyé. ");
INSERT INTO bdh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sɨmɨ bɨ leꞌyị́ oṇgó gɨ komo Nówa zɨ́a úwú ledre bɨ wotị́ a Áma mengị zɨ́a ní, ");
INSERT INTO bdh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","zɨ́a úku ledre kɨ́dí, “Máóto taramá go kacɨ́ Kanána, nɨ ídí owụ́kụlụ́ ꞌbɨ lúnduné e. Nɨ ídí ꞌbɨ ené za ꞌdáꞌba kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Zɨ́a kpá úku ledre kɨ́dí, “ꞌYị e mbá idínɨ́ íꞌbí mbófo éyị́ zɨ́ Ngére Lomo bɨ ndịsị sáká Séme ní. Zɨ́ Kanána ídí ꞌbɨ ené nda owụ́kụlụ́ ꞌbɨ Séme. ");
INSERT INTO bdh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mááyí úku ledre zɨ́ Ngére Lomo idí íꞌbí úndru zɨ́ Yépeta, zɨ́a ndíki tụ́ꞌdụ́ owụ́ e, zɨ́ bulúnduga ndị́sị ndị́sịyé ndro kɨ́ bulúndu Séme e, zɨ́ Kanána ídí ꞌbɨ ené owụ́kụlụ́ ꞌbɨ Yépeta.” ");
INSERT INTO bdh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Zɨ́ Nówa ndị́sịné gɨ do kacɨ́ mongụ́ iní bɨ kóo ucu ní sɨmɨbi míya ota, cị́ gbre doa sokó (350). ");
INSERT INTO bdh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nówa mengị kóo mbá sɨmɨbi míya ịnyị doa eso, cị́ gbre doa sokó (950) zɨ́a úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ba ledre gɨ ro bulúndu Nówa bɨ wotị́ga ga bɨ Séme, Áma kɨ́ Yépeta ndikinɨ́ yée gɨ do kacɨ́ mongụ́ iní bɨ kóo ucu ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Owụ́ ꞌbɨ Yépeta e nɨyí, Goméra, Magága, Midáyi, Yavána, Tụbụ́la, Misáka nda kɨ́ Tirása. ");
INSERT INTO bdh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Zɨ́ owụ́ ꞌbɨ Goméra ídí ꞌbɨ eyé, Asakenéza, Ripháta nda kɨ́ Togaráma. ");
INSERT INTO bdh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Owụ́ ꞌbɨ Yavána, ꞌbɨ eyé, Elísa, Tarasísi, Kịtị́mị, nda kɨ́ Rodanị́mị. ");
INSERT INTO bdh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ga ba sị́ do bulúndu Yépeta ga bɨ ndịsịnɨ́ ndị́sị kacɨ́ kóꞌdụ́ mɨkavu e kɨ́ do cúkú e ní. Zɨ́ye ndị́sị óto ꞌbe ꞌbɨ eyé e do bi e mɨngúngúcua do ndị́sị ódroyé sɨmɨ mbigí tara máa ꞌbɨ eyé ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Owụ́ ꞌbɨ Áma ꞌbɨ eyé kóo, Kụ́sụ, Ízibiti, Pụ́tụ nda kɨ́ Kanána. ");
INSERT INTO bdh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Owụ́ ꞌbɨ Kụ́sụ nda ꞌbɨ eyé, Séba, Avíla, Sábata, Ráma nda kɨ́ Sabatéka. Zɨ́ owụ́ ꞌbɨ Ráma e nda ídí ꞌbɨ eyé Síba e kɨ́ Dedána. ");
INSERT INTO bdh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ngíti owụ́ ꞌbɨ Kụ́sụ nɨ kóo bo kɨ́ ịrịné Nịmịróda, nɨ kóo ne bɨrará ꞌyị kɨ́ rokoꞌbụné do sogo káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Gɨ zɨ́ sáká éyị́ ꞌbɨ Ngére Lomo zɨ́ Nịmịróda ndị́sịné úfu bangá e kɨ́ngaya. Née sị́ ledre bɨ ꞌyị e ndịsịnɨ́ úku ledre gɨ zɨ́a kɨ́dí, “Lomo idí íꞌbí komokenzị zɨ́yị, zɨ́yị ndị́sịyị́ úfu bangá e kɨ́e káa zɨ́ ꞌbɨ Nịmịróda ní.” ");
INSERT INTO bdh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ga kóo ꞌdesị́ ní, Nịmịróda ndịsị kóo ndị́sị sɨmɨ káṇgá bɨ Sinára ní. Nɨ ne mɨzefị mongụ́ ngére do gara ga bɨ ota, Babelónịya, Eréka, Akáda nda Kalané. ");
INSERT INTO bdh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nda gɨ ore zɨ́a ị́nyịné ndéréne sɨmɨ káṇgá bɨ kɨ́ ịrịné Asíriya, kɨ́ꞌdí bɨ oꞌbó mɨngburoko gara ga bɨ, Nịnévị, Rebóta Íra, Kála, ");
INSERT INTO bdh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nda kɨ́ Résene bɨ nɨ dongará Nịnévị kɨ́ Kála bɨ nɨ ne mongụ́ gara doyé mbá ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Owụ́ ꞌbɨ Ízibiti nɨyí ꞌbɨ eyé Lịdịyádị, Aníma, Labíti, Nefatụ́ma, ");
INSERT INTO bdh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Petarụ́sa, Kasélụ bɨ ndikiogụnɨ́ kúfú ꞌyị ga bɨ Falasitíni ní, nda kɨ́ Kuréto. ");
INSERT INTO bdh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Owụ́ ꞌbɨ Kanána e nɨyí Sidóna bɨ nɨ ndíká ní kɨ́ Éte. ");
INSERT INTO bdh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanána nɨ kpá ne ꞌbụ, Zebụ́sa, Amóra, Girigási, ");
INSERT INTO bdh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ịvị́ta, Aréka, Sinóyi, ");
INSERT INTO bdh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avénda, Zemaráda nda kɨ́ Amáta. Nda gɨ do kacɨ́ a née zɨ́ ꞌyị ꞌbɨ Kanána e áṇgayé ");
INSERT INTO bdh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","zɨ́ mama bɨ dongaráye kɨ́ ngíti géyị ꞌyị e ní tónóne gɨ sɨmɨ Sidóna ndéréógụné gị sɨmɨ Gerári gbóo kɨ́ Gáza, nda mɨꞌdí gbére sɨmɨ Sodóma, Gomóra, Adéma, Zeboyị́ma gbóo kɨ́ Lasa. ");
INSERT INTO bdh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ga ba owụ́ ꞌbɨ Áma e kɨ́ bulúnduga ga bɨ ndịsịnɨ́ ndị́sị do bi e kacɨ́ sị́ doyé kɨ́ tara eyé e mɨngúngúcua ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Zɨ́ Séme bɨ mongụ́ lúndua nɨ Yépeta ní kpá ndíki wotị́ne e. Séme nɨ ne bulúndu ꞌyị ga bɨ ndịsịnɨ́ ndólo yée Ébere e ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Owụ́ ꞌbɨ Séme maꞌdáa nɨyí nda ꞌbɨ eyé Eláma, Asúra, Arɨpakasáda, Lụ́da nda kɨ́ Aráma. ");
INSERT INTO bdh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Owụ́ ꞌbɨ Aráma nɨyí ꞌbɨ eyé, Ụ́zụ, Úla, Getéra nda kɨ́ Mása. ");
INSERT INTO bdh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arɨpakasáda nɨ ꞌbɨ ené ꞌbụ Séla, zɨ́ Séla nda ídí ꞌbɨ ené ꞌbụ Ébere. ");
INSERT INTO bdh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ébere ndíki kóo owụ́ e gbre. Ngíti a ịrịa ꞌbɨ ené Pelége gɨ zɨ́a née sịndị́ kadra bɨ ꞌyịmaꞌdí e ífi bayinɨ́ royé do sogo káṇgá ní. Ịrị lúndua ꞌbɨ ené nda Zakatáni. ");
INSERT INTO bdh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Owụ́ ꞌbɨ Zakatáni nɨyí ꞌbɨ eyé, Alemodáda, Sélefa, Azaramavéta, Zéra, ");
INSERT INTO bdh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoráma, Uzála, Dikéla, ");
INSERT INTO bdh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obála, Abimiyéle, Síba, ");
INSERT INTO bdh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opíra, Avíla nda kɨ́ Zobába. Ga gére née mbá owụ́ ꞌbɨ Zakatáni. ");
INSERT INTO bdh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Káṇgá bɨ kóo ndịsịnɨ́ sɨmɨ a ní tonó gɨ sɨmɨ Mésa ndéréꞌdị́yị roné ꞌdí gbére do bi ekị́ekị́ bɨ gbóo kɨ́ Sefára ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ga ba owụ́ ꞌbɨ Séme ga bɨ ndịsịnɨ́ ndịsị do bi e kacɨ́ sị́ doyé kɨ́ tara eyé e mɨngúngúcua ní. ");
INSERT INTO bdh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ga ba sị́ do bulúndu Nówa ga bɨ wotị́ ga ndikinɨ́ yée kacɨ́ do ꞌbe ꞌbɨ eyé e ní. Nɨyí ye ꞌyị ga bɨ ndikiogụnɨ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e do sogo káṇgá gɨ do kacɨ́ mongụ́ iní bɨ kóo ucu ní. ");
INSERT INTO bdh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ga kóo ꞌdesị́ ní, tara nɨ aka yị́ ené kóo do sogo káṇgá dụụ́ kị́éꞌdo zɨ́ ꞌyị e ndị́sị úku dụụ́ tara máa bɨ kị́éꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sɨmɨ bɨ ꞌyịmaꞌdí e nɨyí ndị́sị kɨ́ gámálící royé ní, zɨ́ye ndéré ꞌdị́yị royé mɨꞌdí gbére do ógụyé do mongụ́ nyárá bi sɨmɨ Sinára, zɨ́ye ndị́sịyé ore. ");
INSERT INTO bdh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Zɨ́ye úku ledre dengbị́ye kɨ́dí, “Ógụsé mu zɨ́ze ónzó bɨlóko do óngbó a bɨlámáne.” Yemenɨ́ kóo bɨlóko née do bi kacɨ́ tutú zɨ́ mɨceceꞌdị koꞌbó nda ídí ꞌbɨ ené do bi kacɨ́ éyị́ bɨ káa zɨ́ seméndị ní. ");
INSERT INTO bdh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Née ní zɨ́ye úku ledre kɨ́dí, “Ógụsé mu, zɨ́ze óꞌbó mongụ́ gara zɨ́ze, kɨ́ mongụ́ ꞌdị́cị́ sɨmɨné mbíwu ꞌdága zɨ́ doa ndéréógụné gị ro ere, gɨ ro zɨ́ ịrịzé ówụ́ne doa káa bɨ azé báyi do sogo káṇgá mbá ke.” ");
INSERT INTO bdh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tɨ́ lá zɨ́ Ngére Lomo ógụné lúrú mongụ́ gara kɨ́ mongụ́ ꞌdị́cị́ bɨ ꞌyị ga gére nɨyí ndị́sị óꞌbó a née. ");
INSERT INTO bdh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Zɨ́ Ngére Lomo úku ledre zɨ́ne kɨ́ roné kɨ́dí, “Káa zɨ́ bɨ ꞌyị ga ba nɨyí go ꞌyị kị́éꞌdo, ndịsịnɨ́ ódro go kpá lá dụụ́ tara bɨ kị́éꞌdo zɨ́ye tónóye go méngị éyị́ káa zɨ́ ba ní, ledre bɨ nɨyí yéme a gɨ ro méngị a ní utúasá rómo yée wá. ");
INSERT INTO bdh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ógụsé mu zɨ́ze ndéréze gɨ́rágá báyi sɨmɨ tara eyé káa bɨ nɨyí ndị́sị úwú royé dengbị́ye ke.” ");
INSERT INTO bdh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Née ní, zɨ́ Ngére Lomo báyi yée gɨrí do sogo káṇgá mbá, zɨ́ye ótoómo kɨ́ óꞌbó mongụ́ gara bɨ kóo née. ");
INSERT INTO bdh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Née sị́ ledre bɨ ịfị́nɨ́ ịrị bi née kɨ́dí Bábele ní gɨ zɨ́a née bi bɨ Ngére Lomo gɨragá bayi tara bɨ do sogo káṇgá ba gɨ doa ní. Nda gɨ ore zɨ́ Ngére Lomo báyi yée mɨkékeṛị́a do sogo káṇgá mbá. ");
INSERT INTO bdh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ba ledre gɨ ro bulúndu Séme e. Sɨmɨbi gbre gɨ do kacɨ́ mongụ́ iní bɨ kóo ucu ní, sɨmɨ bɨ sɨmɨbi ꞌbɨ Séme nɨ go míya (100) ní, zɨ́a ndíki Arɨpakasáda. ");
INSERT INTO bdh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Gɨ do kacɨ́ a née ní, zɨ́ Séme ndị́sịné sɨmɨbi míya ịnyị (500) zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Sɨmɨ bɨ sɨmɨbi ꞌbɨ Arɨpakasáda nɨ go cị́ kéṛị́ a doa sokó doa ịnyị (35) ní, zɨ́a ndíki Séla. ");
INSERT INTO bdh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nda gɨ do kacɨ́ Séla, zɨ́ Arɨpakasáda méngị sɨmɨbi míya eso doa ota (403) zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sɨmɨ bɨ sɨmɨbi nɨ do Séla go cị́ kéṛị́ a doa sokó (30) ní, zɨ́a ndíki Ébere. ");
INSERT INTO bdh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Zɨ́ Séla méngị gɨ do kacɨ́ Ébere née sɨmɨbi míya eso doa ota (403), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sɨmɨ bɨ sɨmɨbi do Ébere go cị́ kéṛị́ a doa sokó doa eso (34) ní, zɨ́a ndíki Pelége. ");
INSERT INTO bdh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Zɨ́ Ébere méngị gɨ do kacɨ́ Pelége née sɨmɨbi míya eso doa cị́ kéṛị́ a doa sokó (430), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Sɨmɨ bɨ sɨmɨbi do Pelége go cị́ kéṛị́ a doa sokó (30) ní, zɨ́a ndíki Réwu. ");
INSERT INTO bdh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Zɨ́ Pelége méngị gɨ do kacɨ́ Réwu née sɨmɨbi míya gbre doa ịnyị doa eso (209), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Sɨmɨ bɨ sɨmɨbi do Réwu go cị́ kéṛị́ a doa sokó doa gbre (32) ní, zɨ́a ndíki Serụ́ga. ");
INSERT INTO bdh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Zɨ́ Réwu méngị gɨ do kacɨ́ Serụ́ga née sɨmɨbi míya gbre doa ịnyị doa gbre (207), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sɨmɨ bɨ sɨmɨbi do Serụ́ga go cị́ kéṛị́ a doa sokó (30) ní, zɨ́a ndíki Nówara. ");
INSERT INTO bdh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Zɨ́ Serụ́ga méngị gɨ do kacɨ́ Nówara née sɨmɨbi míya gbre (200), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Sɨmɨ bɨ sɨmɨbi do Nówara go cị́ kéṛị́ a doa ịnyị doa eso (29) ní, zɨ́a ndíki Téra. ");
INSERT INTO bdh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Zɨ́ Nówara méngị gɨ do kacɨ́ Téra née sɨmɨbi míya kị́éꞌdo doa sokó doa ịnyị doa eso (119), zɨ́a ndíki ngíti géyị owụ́ e, yaꞌdá e kɨ́ kará e. ");
INSERT INTO bdh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Sɨmɨ bɨ sɨmɨbi do Téra go cị́ ota doa sokó (70) ní, zɨ́a ndíki Abaráma e kɨ́ Nówara nda kɨ́ Árana. ");
INSERT INTO bdh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ba ledre gɨ ro bulúndu Téra e. Téra ndiki Abaráma e kɨ́ Nówara nda kɨ́ Árana. Zɨ́ Árana ndíki Lóto. ");
INSERT INTO bdh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Sɨmɨ bɨ Téra ꞌbụ Árana nɨ aka kɨ́ komoné ní, zɨ́ Árana úyuné cịkị sɨmɨ Ụ́rụ káṇgá bɨ ndikinɨ́ wo sɨmɨ a sɨmɨ Babelónịya ní. ");
INSERT INTO bdh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Née ní zɨ́ Abaráma e kɨ́ Nówara gbrengárá ꞌdíꞌbi kará e. Ịrị meꞌbe Abaráma ꞌbɨ ené Sárayi, ịrị meꞌbe Nówara nɨ nda ꞌbɨ ené Mílika nyị́ Árana bɨ lémị Íseke ní. ");
INSERT INTO bdh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Bɨ kenée ní Sárayi nɨ yị́ ené mɨkoto ndiki ené owụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Née ní, zɨ́ Téra ꞌdíꞌbi wotị́ne Abaráma kɨ́ bulúnduné Lóto bɨ wotị́ Árana nda kɨ́ Sárayi meꞌbe wotị́ne Abaráma zɨ́ye ómụ́ye gɨ sɨmɨ Ụ́rụ bɨ sɨmɨ Babelónịya ní ndéréye sɨmɨ káṇgá bɨ Kanána ní. Tɨ́ lá sɨmɨ bɨ nderéogụnɨ́ sɨmɨ gara bɨ ndịsịnɨ́ ndólo a Arána ní, zɨ́ye ndị́sịyé cịkị ore. ");
INSERT INTO bdh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Sɨmɨ bɨ sɨmɨbi ꞌbɨ Téra nɨ go míya gbre doa ịnyị (205) ní, zɨ́ Lomo ꞌdíꞌbi ꞌdówụ́ a cịkị sɨmɨ Arána ore. ");
INSERT INTO bdh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Zɨ́ Ngére Lomo úku ledre zɨ́ Abaráma kɨ́dí, “Ídí ótoómo káṇgá esé, ꞌyị eyị́ e kɨ́ ꞌbụyị́ e mbá, zɨ́yị ómụ́yị sɨmɨ káṇgá bɨ mááyí ꞌdódo a zɨ́yị ní. ");
INSERT INTO bdh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mááyí íꞌbí úndru zɨ́yị, zɨ́ma óto bulúnduyị́ e zɨ́ye étrịyé do ídíye káa do mongụ́ sị́ do. Mááyí óto ịrịyị́ zɨ́a ówụ́ne mɨówụ́ zɨ́yị ídíyị ꞌyị bɨ ꞌyị e nɨyí ndị́sị ndíki úndru kpụrụ́ gɨ zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mááyí íꞌbí úndru zɨ́ ꞌyị ga bɨ nɨyí óto úndruyị́ ní, ꞌyị bɨ nɨ óto tarané kacɨ́yị ní mááyí kpá óto taramá kacɨ́ a. Nda kpụrụ́ gɨ sɨmɨyị́ mááyí íꞌbí úndru zɨ́ ṛị́kị́ kúfú ꞌyịmaꞌdí e do sogo káṇgá mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Née ní zɨ́ Abaráma ị́nyịné ndéréne tɨ́ káa zɨ́ bɨ Ngére Lomo uku zɨ́a ní. Zɨ́ Lóto útúne do kacɨ́ a. Sɨmɨbi ꞌbɨ Abaráma nɨ kóo cị́ ota doa sokó doa ịnyị (75) sɨmɨ bɨ omụ́ gɨ sɨmɨ Arána ní. ");
INSERT INTO bdh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Zɨ́ Abaráma ómụ́ye kɨ́ meꞌbené Sárayi e kɨ́ Lóto owụ́ ꞌbɨ lúnduné, zɨ́ye ꞌdíꞌbi za éyị́ ga bɨ ꞌbɨ ꞌbe ní mbá, ꞌyị ꞌbɨ moko eyé ga bɨ kóo nɨyí kéye sɨmɨ Arána ore ní mbá zɨ́ye ị́nyịyé ndéréye sɨmɨ káṇgá bɨ Kanána ní. Do ndéréógụyé íri. ");
INSERT INTO bdh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Zɨ́ye ókpóye gɨ sɨmɨ Kanána fú lá mɨókpó do ndéréógụyé sɨmɨ owụ́ gara kɨ́ ịrịné Sekéme, do ndị́sịyé cigí kágá bɨ ndịsịnɨ́ ndólo a Móre. Sɨmɨ sịndị́ kadra máa bɨ kóo née ꞌyị ꞌbɨ Kanána e ndịsịnɨ́ kóo ndị́sị ore. ");
INSERT INTO bdh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Née ní zɨ́ Ngére Lomo ꞌdódo roné zɨ́ Abaráma íri zɨ́a úku ledre zɨ́a kɨ́dí, “Mááyí íꞌbí káṇgá ba zɨ́ bulúnduyị́ e za fí.” Zɨ́ Abaráma óꞌbó mbayi zɨ́ Ngére Lomo bɨ ꞌdódo roné zɨ́a ní ore. ");
INSERT INTO bdh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Gɨ do kacɨ́ née ní, zɨ́ Abaráma ị́nyịyé ndéréye do bi bɨ ekị́ekị́ bɨ sɨmɨ Bétele mɨꞌdí gbére ní, zɨ́a óto táya ore. Bétele nɨ ꞌbɨ ené mɨꞌdí gólụ Áyi nɨ ꞌbɨ ené mɨꞌdí gbére. Zɨ́a óꞌbó mbayi ore ndị́sị íni ini zɨ́ Ngére Lomo sị́ a. ");
INSERT INTO bdh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Zɨ́ Abaráma e kpá ị́nyịyé gɨ ore ndéré ꞌdị́yị royé mɨꞌdí sɨmɨ Negébe. ");
INSERT INTO bdh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ mongụ́ ꞌbú útúne. Zɨ́ Abaráma ị́nyịyé gɨ ore ndéréye ndị́sịyé cúkuꞌdée sɨmɨ Ízibiti gɨ zɨ́ mongụ́ ꞌbú née. ");
INSERT INTO bdh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sɨmɨ bɨ nɨ go gbóo gɨ ro ólụ́ sɨmɨ Ízibiti ní, zɨ́a úku ledre zɨ́ meꞌbené Sárayi kɨ́dí, “Sárayi, Máówo bú lámá nɨ royị́ kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sɨmɨ bɨ ꞌyị ga bɨ ꞌbɨ Ízibiti nɨyí lúrúndíki yị́ị ní, nɨyí geré úku ledre kɨ́dí, ‘Ba meꞌbené.’ Née ní nɨyí úfu máa do ótoómo yị́ị trịdrị. ");
INSERT INTO bdh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Togụ́ nduꞌyúnɨ́ yị́ị go yá, ídí úku a zɨ́ye kɨ́dí áyí lémịmá, gɨ ro zɨ́ye ndị́sịyé méngị ledremá kɨ́ngaya gɨ royị́, utúasánɨ́ ufu máa wá gɨ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sɨmɨ bɨ Abaráma ogụnɨ́ sɨmɨ Ízibiti ní, zɨ́ ꞌyị ꞌbɨ Ízibiti e lúrú Sárayi nɨ kára bɨ kɨ́ lámá roné kɨ́ngaya ní. ");
INSERT INTO bdh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nda sɨmɨ bɨ ngíti géyị mɨngburoko ꞌyị ꞌbɨ ngbanga ꞌbɨ mongụ́ ngére Fáro lurúnɨ́ Sárayi nɨ kɨ́ lámá roné kɨ́ngaya ní, zɨ́ye ndéréye úku ledrea zɨ́ mongụ́ ngére, zɨ́ye ógụyé ꞌdíꞌbi wo ndéré kɨ́e ꞌbe ꞌbɨ ngére zɨ́a ndị́sịné íri. ");
INSERT INTO bdh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Gɨ ro ledre Sárayi, zɨ́ ngére ꞌbɨ Ízibiti ndị́sịné méngị ledre Abaráma kɨ́ngaya, do íꞌbí éyị́ ga bɨ káa zɨ́ kábịṛị́kị e, Ị́tị́ e, dongí e, owụ́kụlụ́ e nda kɨ́ gémele e ní zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Gɨ zɨ́a bɨ ngére ꞌbɨ Ízibiti ꞌdíꞌbi Sárayi meꞌbe Abaráma ní, zɨ́ Ngére Lomo kása bɨsinyí ndíyá doa kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e mbá. ");
INSERT INTO bdh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Née ní zɨ́ ngére ꞌbɨ Ízibiti kákasa kacɨ́ Abaráma do úku ledre zɨ́a kɨ́dí, “Méngị kéyị zɨ́ma kenée gɨ zɨ́ ꞌdi? Úku kóo zɨ́ma yaá Sárayi nɨ yị́ ené meꞌbeyị́ wá gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Éyị́ bɨ úku ledre zɨ́ma gɨ zɨ́a yaá, ‘Sárayi nɨ lémịné’ gɨ zɨ́a ní ꞌdi, bɨ zɨ́ma ꞌdíꞌbi wo káa do kára ní? Bɨ ba ní meꞌbeyị́ nɨ go née. ꞌDíꞌbi wo mu zɨ́se ndérése.” ");
INSERT INTO bdh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Née ní, zɨ́ ngére ꞌbɨ Ízibiti úku ledre gɨ ro Abaráma e kɨ́ meꞌbené kɨ́dí, idínɨ́ mu ꞌdíꞌbi éyị́ eyé e mbá zɨ́ye ólụ́ógụ gɨ sɨmɨ Ízibiti gɨ ona ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Gɨ ore zɨ́ Abaráma e kɨ́ meꞌbené ị́nyịyé gɨ sɨmɨ Ízibiti do ꞌdíꞌbi éyị́ eyé e mbá zɨ́ye ndáꞌbalúgu royé sɨmɨ Negébe. Zɨ́ Lóto ndéréne kéye. ");
INSERT INTO bdh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abaráma nɨ nda kóo go kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne, bangákụlụ́ e, késị́ e kpá kɨ́ dábu e. ");
INSERT INTO bdh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Gɨ sɨmɨ Negébe zɨ́a ndị́sịné ómụ́ne gɨ do bi e kɨ́rɨ́ née wá kɨ́rɨ́ née zɨ́a ndéréógụné zaá gị sɨmɨ Bétele do bi kuṛú táya ené bɨ kóo ꞌdesị́ dongará Bétele kɨ́ Áyi ní, ");
INSERT INTO bdh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kɨ́ꞌdí bɨ oꞌbó mɨzefị mbayi ní. Zɨ́ Abaráma ndị́sịné íni ini zɨ́ Ngére Lomo ore. ");
INSERT INTO bdh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lóto bɨ kóo ndịsịnɨ́ gámálící royé kɨ́ Abaráma ní, nɨ nda kpá go kɨ́ tụ́ꞌdụ́ ꞌyị e do kacɨ́ne, kpá kɨ́ kábịṛị́kị e, kɨ́ ị́tị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tɨ́ lá bi eye lolụ kóo zɨ́ye gɨ ro zɨ́ye ndị́sịyé ndro do bi kị́éꞌdo wá gɨ zɨ́a éyị́ e ofụnɨ́ nda kóo zɨ́ye go bɨ utúasá ótoómo yée zɨ́ye ndị́sịyé mbá do bi kị́éꞌdo wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌbáꞌbá bangá ga bɨ ꞌbɨ Abaráma kɨ́ yée ga bɨ ꞌbɨ Lóto ní ndị́sịyé ófụ́ye dongaráye gɨ ro bi. Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, ꞌyị ꞌbɨ Kanána e kɨ́ ꞌyị ꞌbɨ Peréze e nɨyí kóo kpá ore. ");
INSERT INTO bdh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nda née ní zɨ́ Abaráma úku ledre zɨ́ Lóto kɨ́dí, “Owụ́ ꞌbɨ amá a, ófụ́ nda ógụ dongaráze kéyị wá togụ́ mbú dongará ꞌyị ꞌbáꞌbá bangá eyị́ e kɨ́ ꞌbɨ amá e wá. ");
INSERT INTO bdh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mongụ́ ị́rịgbére nɨ bɨ kóꞌdụ́yị íri née, ifizé rozé mu. Ídí mu gélé bi bɨ íli ndéré doa ní. Togụ́ ndéré go do anú, mááyí nda ndéré ꞌbɨ amá do ngelị. Togụ́ do ngelị yá, mááyí nda ndéré ꞌbɨ amá do anú.” ");
INSERT INTO bdh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Zɨ́ Lóto lúrú bi keree, zɨ́a lúrúndíki ꞌbululu bɨ kacɨ́ kóꞌdụ́ Yeredéne nɨ kɨ́ iní doné ngárá ndụkụ́ wá ní bɨ nɨ káa zɨ́ yáká ꞌbɨ Ngére Lomo kpá káa zɨ́ káṇgá ꞌbɨ Ízibiti bɨ mɨꞌdí sɨmɨ Zóra ní. Ledre máa née mengị kóo roné ꞌdáꞌdá gɨ zɨ́ Ngére Lomo kɨ́ óngbó gara ga bɨ Sodóma kɨ́ Gomóra ní. ");
INSERT INTO bdh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Née ní zɨ́ Lóto gélé ꞌbululu bɨ kóꞌdụ́ Yeredéne ní, zɨ́ye ífi royé, zɨ́ Lóto ndéré ndị́sị ꞌbɨ ené mɨꞌdí gbére. ");
INSERT INTO bdh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nda née ní zɨ́ Abaráma ndị́sị ꞌbɨ ené sɨmɨ káṇgá ꞌbɨ Kanána ore. Zɨ́ Lóto ndéré ndị́sị ꞌbɨ ené dongará gara ga bɨ sɨmɨ kpárá ní, zɨ́a óto táya ené gbóo kɨ́ Sodóma. ");
INSERT INTO bdh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ꞌYị ꞌbɨ Sodóma e nɨyí ꞌyị méngị bɨsinyí ledre e, ndịsịnɨ́ méngị mbá ledre ga bɨ Ngére Lomo ili wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Gɨ do kacɨ́ bɨ Lóto e ifinɨ́ royé kɨ́ Abaráma ní, zɨ́ Ngére Lomo úku ledre zɨ́ Abaráma kɨ́dí, “Sị́kpị aka doyị́ do bi bɨ áyí doa née zɨ́yị lúrúꞌdíkí bi cigíyị gbaá. ");
INSERT INTO bdh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Bi bɨ áyí lúrú a née ní, mááyí íꞌbí a zɨ́yị, kɨ́ bulúnduyị́ e za fí. ");
INSERT INTO bdh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mááyí óto bulúnduyị́ e zɨ́ye étrịyé zɨ́ye ídíye káa zɨ́ ꞌbụrụ ní, gɨ ro togụ́ ꞌyị utúasá go ólo ꞌbụrụ yá, nɨ útúásá ólo bulúnduyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ị́nyị mu zɨ́yị gámáꞌdíkí bi née gbaá, gɨ zɨ́a mááyí go íꞌbí a mbá zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Gɨ zɨ́ kéyị née ní zɨ́ Abaráma ómụ́ne kɨ́ táya ené ndéré ndị́sịné sɨmɨ gara bɨ ndịsịnɨ́ ndolo a Éborono cigí kágá bɨ kɨ́ ịrịné Mamaré kɨ́ꞌdí bɨ oꞌbó mbayi zɨ́ Ngére Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Amaraféle nɨ kóo mongụ́ ngére ꞌbɨ Sinára, Ariyóka nɨ kóo ꞌbɨ ené ꞌbɨ Elesára, Kedarolaméra nɨ ꞌbɨ ené ꞌbɨ Eláma, zɨ́ Tidála nda ídí ꞌbɨ ené ꞌbɨ Góyịma, ");
INSERT INTO bdh_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","zɨ́ye ị́nyịyé ndéré útúye kɨ́ okó do ngére e ịnyị. Ngére maáge nɨyí Béra ngére ꞌbɨ Sodóma, Bịrása ngére ꞌbɨ Gomóra, Sinába ngére ꞌbɨ Adéma, Semebére ngére ꞌbɨ Zeboyị́ma, nda kɨ́ ngére ꞌbɨ Béla bɨ nɨ Zóra ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Zɨ́ ngére ga bɨ ịnyị née yóko royé kɨ́ asikíri eyé e mbá sɨmɨ ꞌbululu bɨ kɨ́ ịrịné Sịdị́mị bɨ gbóo kɨ́ mɨkavu bɨ éyị́ trịdrị ndanɨ́ sɨmɨ a wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ngére ga bɨ ịnyị née nɨyí kóo mbá sị́ sị́lị́ Kedarolaméra kɨ́ sɨmɨbi sokó doa gbre, tɨ́ lá nda sɨmɨ sokó doa ota sɨmɨbi zɨ́ye óyólóꞌbó royé ị́cị́ okó roa. ");
INSERT INTO bdh_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nda sɨmɨ sokó doa eso sɨmɨbi, zɨ́ Kedarolaméra kɨ́ ngére ga bɨ ilinɨ́ aka fú ledre ené ní, ị́nyịyé kɨ́ asikíri eyé e ndéré útúye kɨ́ okó do ꞌyị ꞌbɨ Réfa e ga bɨ sɨmɨ Aseteróta Karána ní do rómo komoyé cụ́, zɨ́ye rómo komo ꞌyị ga bɨ Zụ́zụ bɨ sɨmɨ Áma kpá cụ́, do ókpóye rómo komo ꞌyị ꞌbɨ Émị ga bɨ ndịsịnɨ́ ndị́sị sɨmɨ ꞌbululu bɨ Kiriyatámi kpá cụ́, ");
INSERT INTO bdh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","zɨ́ye tátáye ro ꞌyị ꞌbɨ Órị e ga bɨ ndịsịnɨ́ ndịsị do bi ekị́ekị́ bɨ sɨmɨ káṇgá ꞌbɨ Seyíra ní, do ógó ngíti géyị ndéré kɨ́ye mɨꞌdí sɨmɨ Eliparána sɨmɨ súwú. ");
INSERT INTO bdh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Née ní zɨ́ye ndáꞌbalúgu royé ꞌdáꞌba do ndéréógụyé sɨmɨ gara bɨ Misapáta sɨmɨ Kadése ní. Zɨ́ye ꞌdíꞌbi za káṇgá ꞌbɨ ꞌyị ꞌbɨ Amalékị e kɨ́ ꞌbɨ ꞌyị ꞌbɨ Amóra e ga bɨ ndịsịnɨ́ ndị́sị sɨmɨ Azazóna Tamára ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nda gɨ ore zɨ́ ngére ꞌbɨ Sodóma, kɨ́ ꞌbɨ Gomóra, kɨ́ ꞌbɨ Adéma, kɨ́ ꞌbɨ Zeboyị́ma, nda kɨ́ ngére ꞌbɨ Béla bɨ Zóra ní, zɨ́ye ndéréye yóko royé mbá sɨmɨ ꞌbululu sịdị́mị yéme royé gɨ ro okó, ");
INSERT INTO bdh_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kɨ́ Kedarolaméra ngére ꞌbɨ Eláma, kɨ́ Tidála ngére ꞌbɨ Góyịma, kɨ́ Amaraféle ngére ꞌbɨ Sinára, nda kɨ́ Ariyóka ngére ꞌbɨ Elesára. Zɨ́ ngére ga bɨ eso née ị́cị́ okó kɨ́ ngére ga bɨ ịnyị ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sɨmɨ sịndị́ kadra née ní ꞌBululu Sịdị́mị nɨ kóo kɨ́ mɨngburoko gu e kɨ́ mɨceceꞌdị koꞌbó sɨmɨné. Nda sɨmɨ bɨ ngére ꞌbɨ Sodóma kɨ́ ꞌbɨ Gomóra ngásá bayinɨ́ royé gɨ zɨ́ okó ní, zɨ́ ngíti géyị ꞌyị e útúye sɨmɨ mɨngburoko gu ga gére née zɨ́ ngíti géyị ngásá ꞌbɨ eyé do bi ga bɨ ekị́ekị́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Zɨ́ ngére ga bɨ eso née kókụ́ éyị́ ga bɨ kacɨ́ ngére ꞌbɨ Sodóma kɨ́ Gomóra ní kɨ́ éyị́ mɨánu mbá Yóó ndéréye kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Zɨ́ye kpá ꞌdíꞌbi Lóto owụ́ ꞌbɨ lúndu Abaráma, bɨ ndịsị ndị́sị sɨmɨ Sodóma ní kɨ́ eyị́ ené e mbá ókpóye kɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nda gɨ ore zɨ́ ngúru ꞌyị bɨ omo gɨ dongaráye ní ị́nyịné ndéréne úku ledre Lóto zɨ́ Abaráma bɨ Ébere ní. Sɨmɨ sịndị́ kadra máa bɨ kóo née kụ́tụ́ ꞌbɨ Abaráma nɨ kóo gbóo kɨ́ mongụ́ kágá ꞌbɨ Mamaré ꞌyị ꞌbɨ Amóra e ní. Mamaré e kɨ́ lúnduné Esekólo kɨ́ Anéra nɨyí kóo ꞌyị ga bɨ ilinɨ́ ledre ꞌbɨ Abaráma ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Sɨmɨ bɨ Abaráma uwú kɨ́dí ꞌdiꞌbinɨ́ owụ́ ꞌbɨ lúnduné go sɨmɨ okó ní, zɨ́a ị́nyịné yóko asikíri e ga bɨ gɨ sị́ sịndị́ne ní míya ota doa sokó doa ịnyị doa ota (318) zɨ́ye lódụ́ yée gị sɨmɨ ngíti mongụ́ gara kɨ́ ịrịné Dána. ");
INSERT INTO bdh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kɨ́ ndụlụ a née zɨ́a ífi sɨmɨ asikíri ga gére née do óto yée ị́cị́ okó kɨ́ ngére ga gére née do ésị ngásá sɨmɨ sịndị́ye zɨ́ye lódụ́ yée gị sɨmɨ Óba bɨ gɨ ꞌdí do ngelị gɨ sɨmɨ Damásika ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Zɨ́ Abaráma ngákalúgu éyị́ ga bɨ kóo ngakanɨ́ yée ní, do kpá ngákalúgu Lóto owụ́ ꞌbɨ lúnduné kɨ́ éyị́ ené e ga bɨ kóo ꞌdiꞌbinɨ́ yée ní ndro kɨ́ kará e kɨ́ ngíti géyị ꞌyị ga bɨ ꞌdiꞌbinɨ́ yée ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sɨmɨ bɨ Abaráma e nɨyí go ndáꞌbaógụ gɨ do kacɨ́ bɨ romo komo ngére Kedarolaméra kɨ́ lafúga ngére e ní, zɨ́ ngére ꞌbɨ Sodóma ị́nyịné ndéré ꞌdíꞌbi wo sɨmɨ sụmụ sɨmɨ ꞌbululu bɨ Sáve (bɨ ndịsịnɨ́ kpá ndólo a ꞌBululu Ngére) ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Zɨ́ Malekesédeke bɨ nɨ ngére ꞌbɨ Salímu kpá ꞌyị ꞌdáná éyị́ zɨ́ Lomo bɨ rokoꞌbụ a ofụ go ní, ꞌdíꞌbi éyị́ mɨánu kɨ́ leꞌyị́ e íꞌbí yée zɨ́ Abaráma kɨ́ ꞌyị ga bɨ ndaꞌbaogụ kéye née ní. ");
INSERT INTO bdh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Zɨ́a ꞌdíꞌbi sị́lị́ Abaráma, zɨ́a úku ledre kɨ́dí, “Lomo bɨ rokoꞌbụa ofụ go ní, bɨ otoogụ ere kɨ́ do sogo káṇgá ní, idí ídí kɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ꞌYịmaꞌdí e idínɨ́ íꞌbí mbófo éyị́ zɨ́ Lomo bɨ rokoꞌbụ a ofụ go ní, gɨ zɨ́a iꞌbí rokoꞌbụ zɨ́yị ne zɨ́yị rómo komo ezeokóyị e kɨ́e.” Zɨ́ Abaráma ꞌdíꞌbi tákpásị́lị́ kị́éꞌdo gɨ sɨmɨ sokó ꞌbɨ éyị́ ga bɨ ngakanɨ́ yée gɨ sɨmɨ okó ní íꞌbí yée zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nda gɨ ore zɨ́ ngére ꞌbɨ Sodóma úku ledre zɨ́ Abaráma kɨ́dí, “Ídí íꞌbílúgu ꞌyị amá e zɨ́ma, zɨ́yị ꞌdíꞌbi ꞌbɨ eyị́ éyị́ ga bɨ ngakanɨ́ yée née.” ");
INSERT INTO bdh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Zɨ́ Abaráma úkulúgu ledre zɨ́a kɨ́dí, “Málólóbụ́ go zɨ́ma sị́kpị sị́lị́ma zɨ́ Ngére Lomo bɨ rokoꞌbụ a ofụ go ní, bɨ nɨ ne ꞌyị bɨ otoogụ ere e kɨ́ do sogo káṇgá ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","máútúásá amá ṇgúṇgu a zɨ́ma ꞌdíꞌbi éyị́ gɨ zɨ́yị wá, abú mongụ́ éyị́ togụ́ mbú owụ́ a, káa bɨ áyí óyólóꞌbó tarayị́ kɨ́lóndó yá, ‘Máíꞌbí tụ́ꞌdụ́ éyị́ ga bɨ zɨ́ Abaráma née máa.’ ");
INSERT INTO bdh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Éyị́ bɨ máꞌdíꞌbi go ní, tɨ́ lá dụụ́ éyị́ mɨánu bɨ ꞌyị e amá e anunɨ́ ní. Ídí íꞌbí éyị́ e zɨ́ Anéra, Esekólo kɨ́ Mamaré e gɨ zɨ́a née ꞌyị ga bɨ nderézé kéye ní.” ");
INSERT INTO bdh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Gɨ do kacɨ́ a née ní, zɨ́ Ngére Lomo ógụné do Abaráma sɨmɨ ꞌduru do úku ledre zɨ́a kɨ́dí, “Ndá éré ngịrị wá Abaráma, Mááyí ndị́sị lúrú bi kacɨ́yị máa, Mááyí kpá íꞌbí tákpásị́lị́ zɨ́yị kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tɨ́ lá Abaráma ya zɨ́a ní, “Áko Ngére Lomo áyí ꞌyị ꞌbɨ rokoꞌbụ, áyí íꞌbí zɨ́ma bɨ káa ꞌdi bɨ ngárá owụ́ ꞌbɨ amá ndaá ní. ꞌYị bɨ nɨ ꞌdíꞌbi éyị́ sị́lị́ma ga gére née ba Iliyázara bɨ gɨ sɨmɨ Damásika ní tée?” ");
INSERT INTO bdh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Zɨ́ Abaráma kpá úku ledre kɨ́dí, “Ngárá íꞌbí owụ́ e zɨ́ma wá ní, bɨ kenée ní Iliyázara ꞌyị ꞌbɨ moko amá nɨ ꞌdíꞌbi éyị́ sị́lị́ma ga gére née ne.” ");
INSERT INTO bdh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Zɨ́ Ngére Lomo úkulúgu ledre zɨ́ Abaráma kɨ́dí, “Oꞌdo née ꞌdiꞌbi ené éyị́ sị́lị́yị ne wá. Mbigí owụ́ bɨ gɨ sɨmɨyị́ ní, nɨ ꞌdíꞌbi eyị́ sị́lị́yị ga gére née ne.” ");
INSERT INTO bdh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Zɨ́ Ngére Lomo ndóloógụ wo sága úku ledre zɨ́a kɨ́dí, “Lúrú aka bi ꞌdága komo ere zɨ́yị ólo kele ga gére ní, togụ́ áyí útúásá óloónzó yée yá. Bulúnduyị́ e nɨyí karanée ídí kpá tụ́ꞌdụ́ kenée.” ");
INSERT INTO bdh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Zɨ́ Abaráma ṇgúṇgu ledre bɨ Ngére Lomo uku zɨ́a ní, zɨ́a útúásáne kacɨ́ komo Lomo káa do mbigí ꞌyị ené. ");
INSERT INTO bdh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Zɨ́ Ngére Lomo kpá úku ledre zɨ́a kɨ́dí, “Abaráma, Mááyí máa Ngére bɨ ꞌdiꞌbiogụ yị́ị gɨ sɨmɨ Ụ́rụ gara bɨ sɨmɨ káṇgá bɨ Babelónịya ní, gɨ ro íꞌbí káṇgá ba zɨ́yị káa do ꞌbɨ eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Zɨ́ Abaráma ndúꞌyúlúgu wo kɨ́dí, “Áko Ngére Lomo rokoꞌbụyị́ ofụ go, ꞌbe tɨ́ kenée ní, sara mááyí ówo a bɨ kɨ́dí káṇgá née nɨ tɨ́ ídí ꞌbɨ amá maꞌdíi ní lárá a káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ngére Lomo ya zɨ́a ní, “Ídí ndéréógụ kɨ́ dụ́rụ́ ị́tị́ kɨ́ dụ́rụ́ ína, nda kɨ́ yaꞌdá kábịṛị́kị bɨ sɨmɨbi eyé nɨ aka za mbá ota ní, zɨ́yị ꞌdíꞌbiútú kị́ṛịkóꞌdo kɨ́ amámu gɨrí kpa.” ");
INSERT INTO bdh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Zɨ́ Abaráma ógụné kɨ́ éyị́ ga gére née tɨ́ kenée zɨ́ Lomo. Zɨ́a óṇgoꞌdécị sɨmɨyé mbá gbre gbre. Zɨ́a ndáꞌba ótolúgu yée do bi kị́éꞌdo. Tɨ́ lá zɨ́a ótoómo solụ́ ga gére née kenée oṇgoꞌdecị sɨmɨyé wá. ");
INSERT INTO bdh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nda sɨmɨ bɨ solụ́ ga bɨ ndịsịnɨ́ ánu esị ogụnɨ́ gɨ ro ánu esị ga gére ní, zɨ́ Abaráma ndị́sịné ógóóyó yée ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sɨmɨ bɨ kadra nɨ go ndéré útú ní, zɨ́ Abaráma útúne ṛí ꞌdúꞌduné. Zɨ́ mongụ́ bɨsinyí mụtụlụrụ bɨ kɨ́ ngịrịné ní ídíne cigí a gbaá. ");
INSERT INTO bdh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Née ní zɨ́ Ngére Lomo úku ledre zɨ́a kɨ́dí, “Abaráma, ídí ówo a kɨ́dí bulúnduyị́ e nɨyí karanée ídí káa do owụ́kụlụ́ e sɨmɨ káṇgá ꞌbɨ ngíti géyị ꞌyị e. Zɨ́ mị́ngị́ káṇgá máa ga gére née ndị́sịyé ꞌdóꞌdo yée kɨ́ sɨmɨbi e míya eso. ");
INSERT INTO bdh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tɨ́ lá mááyí íꞌbí mongụ́ ꞌdoꞌdó ro mị́ngị́ káṇgá máa ga gére née bɨ nɨyí óto bulúnduyị́ e káa do owụ́kụlụ́ e née ní kɨ́ngaya. Nda gɨ do kacɨ́ a née, bulúnduyị́ ga gére née nɨyí ólụ́ógụ gɨ sɨmɨ káṇgá ꞌbɨ ꞌyị ga gére kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nda gɨ royị́, áyí lúꞌbú mɨlúꞌbú do sogo káṇgá zɨ́yị ngókoyị́ góꞌdo góꞌdo kí, áyí fú úyu do nda óto yị́ị gu. ");
INSERT INTO bdh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bulúnduyị́ e nɨyí ndáꞌbaógụ ándá royé gɨ ꞌdáa ona gɨ do kacɨ́ bɨ ndiki andánɨ́ yée go kɨ́ꞌdí eso ní, gɨ zɨ́a lúyú ledre ꞌbɨ ꞌyị ꞌbɨ Amóra e utúasá aka bɨ gɨ ro zɨ́ma ꞌdóꞌdo yée ní wá.” ");
INSERT INTO bdh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sɨmɨ bɨ kadra utúonzó roné ní, zɨ́ bi nda go ụ́lụ́ne, zɨ́ Abaráma lúrúndíki sɨ́ṛéṛé kɨ́ phoꞌdụ sɨmɨné kɨ́ mɨụ́ndụ phoꞌdụ. Zɨ́ phoꞌdụ ga gére née ndị́sị ókpóye kpụrụ́ gɨ dongará esị ga bɨ bi née. ");
INSERT INTO bdh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Sɨmɨ sịndị́ kadra máa bɨ kóo née, zɨ́ Ngére Lomo yéme ledre kɨ́ Abaráma kɨ́dí, “Máíꞌbí káṇgá ba go zɨ́ bulúnduyị́ e tónóne gɨ ro ngbuṛu ꞌbɨ Ízibiti ndéréógụné gị ro ngbuṛu bɨ Efaráta ní, ");
INSERT INTO bdh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","bɨ nɨ káṇgá ꞌbɨ kúfú ꞌyị ga bɨ Kéna, Kenéze, Kadamóno, ");
INSERT INTO bdh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Éte, Peréze, Réfa, ");
INSERT INTO bdh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amóra, Kanána, Girigási nda kɨ́ Zebụ́sa ní.” ");
INSERT INTO bdh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sárayi meꞌbe Abaráma ndiki ené kóo owụ́ wá. Tɨ́ lá owụ́kụlụ́ ené nɨ kóo bo nyị́ ꞌyị ꞌbɨ Ízibiti kɨ́ ịrịné Agára, ");
INSERT INTO bdh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","gɨ zɨ́ kéyị née ní zɨ́ Sárayi úku ledre zɨ́ Abaráma kɨ́dí, “Bɨ ngárá Ngére Lomo iꞌbí owụ́ zɨ́ma wá ní, ídí mu ṇgúṇgu ledre owụ́kụlụ́ amá née zɨ́se ndị́sịsé kéne káa do kára kɨ́ oꞌdo, éyị́ née kenée nɨ ndíki owụ́ e zɨ́ze.” Zɨ́ Abaráma ṇgúṇgu ledre bɨ Sárayi uku zɨ́a née. ");
INSERT INTO bdh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Née ní gɨ do kacɨ́ bɨ Abaráma ndịsị sɨmɨ Kanána kɨ́ sɨmɨbi sokó ní, zɨ́ Sárayi íꞌbí owụ́kụlụ́ ené Agára bɨ nyị́ ꞌyị ꞌbɨ Ízibiti ní zɨ́ Abaráma káa do kará. ");
INSERT INTO bdh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Zɨ́ Abaráma ndị́sịné kɨ́ Agára káa do kára, zɨ́ Agára go ídíne kɨ́ sɨmɨné. Sɨmɨ bɨ Agára lurú kɨ́dí née nɨ go kɨ́ sɨmɨné ní, zɨ́a tónóne nda ndị́sị lúrúcáyi Sárayi mɨlúrúcáyi. ");
INSERT INTO bdh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Née zɨ́ Sárayi uku ledre zɨ́ Abaráma kɨ́dí, “Bɨsinyí ledre bɨ mááyí ndị́sị ꞌdóꞌdó gɨ zɨ́a ba ngị́rị́ a idí ídí doyị́. Máíꞌbí owụ́kára bɨ owụ́kụlụ́ amá ní zɨ́a ꞌdúꞌduné sogoyị́, bɨ ba ní lurú nda roné nɨ go kɨ́ sɨmɨné ní, zɨ́a ndị́sịné úku cáyi máa. Ngére Lomo idí ꞌdécị ngbanga ne dongaráze kéyị.” ");
INSERT INTO bdh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abaráma ya zɨ́a ní, “Ledre bɨ gɨ ro owụ́kụlụ́ eyị́ ní nɨ do sị́lị́yị. Éyị́ bɨ íli méngị a kɨ́e ní áyí méngị a káa zɨ́ bɨ íli ní.” Gɨ zɨ́ ledre née ní zɨ́ Sárayi tónóne méngị Agára bɨsinyíne, zɨ́ Agára ngásáóyó roné gɨ ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Zɨ́ maláyika ꞌbɨ Ngére Lomo ndíki Agára do ꞌdawú sɨmɨ súwú, ꞌdawú máa née nɨ do mɨsiꞌdi bɨ ndéré ꞌdịyị roné do bi bɨ Sụ́rụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Zɨ́a ndólo wo kɨ́dí, “Agára, owụ́kụlụ́ ꞌbɨ Sárayi, ógụ gɨ ꞌda? Sara áyí ndéré ꞌda?” Agára ya zɨ́a ní, “Mángásáóyó romá gɨ zɨ́ mongụ́ ꞌyị amá Sárayi.” ");
INSERT INTO bdh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Zɨ́ maláyika ꞌbɨ Ngére Lomo úkulúgu ledre zɨ́a kɨ́dí, “Ndáꞌbalúgu royị́ mu zɨ́ mongụ́ ꞌyị eyị́ ꞌbe zɨ́yị ndị́sịyị́ úwú ledre ené.” ");
INSERT INTO bdh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Gɨ ore zɨ́ maláyika ꞌbɨ Ngére Lomo kpá úku ngíti ledre zɨ́a kɨ́dí, “Mááyí óto bulúnduyị́ e zɨ́ye étrịyé do ídíye tụ́ꞌdụ́ ꞌyị bɨ nɨ óloónzó yée ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Zɨ́ maláyika ꞌbɨ Ngére Lomo úku ledre zɨ́a kɨ́dí, “Bɨ ba ní áyí go kɨ́ sɨmɨyị́, áyí áráógụ a owụ́oꞌdo zɨ́yị ị́fị́ ịrị a Isɨméle. Ledre gɨ sɨmɨa kɨ́dí, ‘Ngére Lomo uwú ini eyị́ bɨ gɨ zɨ́ ꞌdoꞌdó ní go.’ ");
INSERT INTO bdh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Owụ́ máa née nɨ ídí káa zɨ́ bangá rará ní dongará ꞌyịmaꞌdí e, nɨ ídí ꞌyị méngị okó kɨ́ ꞌyị e mbá, gɨ zɨ́ kéyị née ní zɨ́ ꞌyị e ídíye kpá mbá okó roa, nɨ ndị́sị ꞌbɨ ené fú lá ngúcuné abú gba kɨ́ lúnduné e.” ");
INSERT INTO bdh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Née ní zɨ́ Agára ị́fị́ ịrị do Ngére Lomo bɨ odro zɨ́ne ní kɨ́dí, “Lomo bɨ lurú máa ní, bɨ ba ní málúrú wo bɨ lurú máa ní go cụ́ kɨ́ komomá.” ");
INSERT INTO bdh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Née sị́ ledre bɨ ndịsịnɨ́ ndólo ꞌdawú née gɨ zɨ́a kɨ́dí, Béralayiróyi bɨ ini ledre gɨ sɨmɨ a yaá ꞌdawú ꞌbɨ Lomo bɨ lurú máa ní. ꞌDawú née nɨ karaba fú lá bo dongará ị́rịgbére ga bɨ Kadése e kɨ́ Berede ní. ");
INSERT INTO bdh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Née ní zɨ́ Agára ndíki owụ́oꞌdo zɨ́ Abaráma, do ị́fị́ ịrị a Isɨméle. ");
INSERT INTO bdh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agára nɨ ndíki Isɨméle zɨ́ Abaráma ní, sɨmɨbi ꞌbɨ Abaráma nɨ kóo go cị́ eso doa ịnyị doa kéṛị́ (86). ");
INSERT INTO bdh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sɨmɨ bɨ sɨmɨbi ꞌbɨ Abaráma nɨ go cị́ eso doa sokó doa ịnyị doa eso (99) ní, zɨ́ Ngére Lomo ꞌdódo roné do úku ledre zɨ́a kɨ́dí, “Mááyí Lomo bɨ ꞌyị rokoꞌbụ ní, ídí óto úndrumá zɨ́yị ndị́sịyị́ méngị fú lá ledre bɨ mɨútúásáne ní. ");
INSERT INTO bdh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mááyí yéme ledre dongaráze kéyị, zɨ́ma óto bulúnduyị́ e zɨ́ye étrịyé tụ́ꞌdụ́.” ");
INSERT INTO bdh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Geré zɨ́ Abaráma útú lóꞌbụ komoné bi, zɨ́ Ngére Lomo úku ledre zɨ́a kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ba go mɨyéme ledre bɨ máyéme zɨ́yị ní. Áyí ídí bulúndu tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e. ");
INSERT INTO bdh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tónóne karaba ndéréne ꞌdáꞌdá, ịrịyị́ ndaá lolụ Abaráma wá ịrịyị́ nda go Abarayáma. Gɨ zɨ́a máóto yị́ị go káa do bulúndu tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e. ");
INSERT INTO bdh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mááyí óto bulúnduyị́ e zɨ́ye étrịyé tụ́ꞌdụ́. Mááyí ótoógụ ṛị́kị́ sị́ do ꞌyịmaꞌdí e gɨ sɨmɨyị́, zɨ́ mɨngburoko ngére e ólụ́ógụyé gɨ sɨmɨyị́. ");
INSERT INTO bdh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mááyí óto mɨyéme ledre amá dongaráze kéyị kpá kɨ́ bulúnduyị́ ga bɨ karanée nɨyí ógụ gɨ do kacɨ́yị zɨ́a ídíne za fí. Zɨ́ma ídíma Lomo bɨ ásé ndị́sị óto úndrua kɨ́ bulúnduyị́ e ga bɨ nɨyí ógụ gɨ do kacɨ́yị ní. ");
INSERT INTO bdh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Káṇgá ꞌbɨ Kanána bɨ áyí sɨmɨ a ꞌyị lóṇgó ba ní, mááyí íꞌbí a zɨ́se kɨ́ bulúnduyị́ ga bɨ nɨyí ógụ gɨ do kacɨ́yị ní za fí, zɨ́ma ídíma Lomo bɨ nɨyí ndị́sị óto úndrua ní.” ");
INSERT INTO bdh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Née ní zɨ́ Ngére Lomo úku ledre zɨ́ Abarayáma kɨ́dí, “Nɨ mɨútúásáne zɨ́yị bándá mɨyéme ledre bɨ dongaráze kéyị kpá kɨ́ bulúnduyị́ ga bɨ nɨyí ógụ gɨ do kacɨ́yị ní bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ba go mɨyéme ledre amá bɨ dongaráze kéyị kpá kɨ́ bulúnduyị́ ga bɨ nɨyí ógụ gɨ do kacɨ́yị ní. Mɨyéme ledre ba ili zɨ́se bándá a, yaꞌdá ga bɨ tara mbotụ esé ní mbá, idínɨ́ útú ngbuṛu. ");
INSERT INTO bdh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ídísé útú ngbuṛu gɨ ro zɨ́a ꞌdódo lị́lị mɨyéme ledre bɨ dongaráze kéyị ní. ");
INSERT INTO bdh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tónóne gɨ ona ndéréne ꞌdáꞌdá, owụ́ yaꞌdá ga bɨ nɨyí ndíki yée tara mbotụ esé e ní mbá, sɨmɨ bɨ sị́lị́ nɨ doyé go ịnyị doa ota ní, idínɨ́ útú ngbuṛu. Gba owụ́ máa yée ga bɨ nɨyí ndíki yée zɨ́se ꞌbe kɨ́ yée ga bɨ úgúsé yée kɨ́ késị́ gɨ zɨ́ ꞌyị lóṇgó e ngárá ndanɨ́ owụ́ ꞌbɨ esé wá ní, idínɨ́ kpá mbá útú ngbuṛu. ");
INSERT INTO bdh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Togụ́ owụ́ ga bɨ ndikinɨ́ zɨ́yị ꞌbe togụ́ mbú yée ga bɨ úgú kɨ́ késị́ idínɨ́ mbá útú ngbuṛu. Nɨ ídí lị́lị ledre bɨ nɨ ꞌdódo a kɨ́dí mɨyéme ledre bɨ dongaráze kéyị ní nɨ ídí za fí. ");
INSERT INTO bdh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Oꞌdo máa wo bɨ útú ngbuṛu wá ní, bandá ené mɨyéme ledre ené bɨ dongaráze kéne ní wá, bɨ kenée ní utúasá ídí káa do ꞌyị amá wá.” ");
INSERT INTO bdh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Zɨ́ Ngére Lomo kpá úku ngíti ledre zɨ́ Abarayáma kɨ́dí, “Tónóne karaba ndéréne ꞌdáꞌdá, ịrị meꞌbeyị́ ndaá lolụ Sárayi wá, ịrị a nda go Sára. ");
INSERT INTO bdh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mááyí íꞌbí úndru zɨ́a, zɨ́a ndíki owụ́oꞌdo zɨ́yị. Zɨ́ma íꞌbí úndru zɨ́a, zɨ́a ídíne mbágá ṛị́kị́ sị́ do ꞌyịmaꞌdí e, mɨngburoko ngére ga bɨ nɨyí ídí do ꞌyị e ní nɨyí ólụ́ógụ gɨ sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Gɨ ore zɨ́ Abarayáma útú lóꞌbụ komoné bi. Zɨ́a kúkugú do úku ledre zɨ́ne kɨ́ roné kɨ́dí, “Utúasánɨ́ go ndíki owụ́oꞌdo zɨ́ oꞌdo bɨ sɨmɨbi ené go míya ní? Sara Sára utúasá go ndíki owụ́ sɨmɨ bɨ sɨmɨbi ené nɨ go cị́ eso doa sokó ní?” ");
INSERT INTO bdh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Zɨ́ Abarayáma ndáꞌbané ndúꞌyúlúgu Lomo kɨ́dí, “Sara togụ́ Isɨméle ꞌdiꞌbi éyị́ sị́lị́ma e ne ní éyị́ bɨ nɨ méngị ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Zɨ́ Lomo úkulúgu ledre zɨ́a kɨ́dí, “ꞌBe tɨ́ kenée ní, tɨ́ lá meꞌbeyị́ Sára nɨ ndíki owụ́oꞌdo zɨ́yị, zɨ́yị ị́fị́ ịrị a Isáka. Mááyí óto mɨyéme ledre amá dongaráze kéne za fí gɨ ro bulúnduga ga bɨ karanée gɨ do kacɨ́ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ini eyị́ bɨ gɨ ro Isɨméle ní máúwú go. Mááyí íꞌbí úndru zɨ́a zɨ́ bulúnduga étrịyé do ídíye tụ́ꞌdụ́. Nɨ ídí bulúndu mɨngburoko ngére e sokó doa gbre, zɨ́ma óto wo zɨ́ tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e ólụ́ógụyé gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tɨ́ lá mááyí óto mɨyéme ledre amá gɨ ro Isáka bɨ Sára nɨ ndíki wo zɨ́yị sɨmɨ sịndị́ kadra káa, kɨ́bi ngíti a.” ");
INSERT INTO bdh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sɨmɨ bɨ Lomo ukuonzó ledre née zɨ́ Abarayáma kenée ní, zɨ́a ndéréókpó ené gɨ ore. ");
INSERT INTO bdh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kpá tɨ́ geré kadra née ní, zɨ́ Abarayáma ꞌdíꞌbi wotị́ne Isɨméle kɨ́ owụ́ yaꞌdá ga bɨ ndikinɨ́ yée zɨ́a ꞌbe, kpá kɨ́ yée ga bɨ ugú yée kɨ́ késị́ kɨ́ yaꞌdá ga bɨ ꞌbe ꞌbɨ ené ore ní mbá ndéré kɨ́ye óto yée zɨ́ye útúye ngbuṛu káa zɨ́ bɨ Lomo uku zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Sɨmɨ bɨ Abarayáma nɨ útú ngbuṛu ní, sɨmɨbi ené nɨ kóo go cị́ eso doa sokó doa ịnyị doa eso (99). ");
INSERT INTO bdh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Sɨmɨbi ꞌbɨ wotị́ a Isɨméle ꞌbɨ ené kóo go sokó doa ota. ");
INSERT INTO bdh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abarayáma e kɨ́ wotị́ne Isɨméle utúnɨ́ kóo ngbuṛu mbá kadra kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Zaá yaꞌdá ga bɨ zɨ́ Abarayáma ꞌbe ní, kɨ́ owụ́ yaꞌdá ga bɨ ndikinɨ́ yée ore, nda kɨ́ yée ga bɨ ugú gɨ zɨ́ ꞌyị lóṇgó e ní utúnɨ́ kóo ngbuṛu mbá kadra máa née kɨ́ Abarayáma e. ");
INSERT INTO bdh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kadra kị́éꞌdo sɨmɨ cóngó kadra, zɨ́ Ngére Lomo ꞌdódo roné zɨ́ Abarayáma sɨmɨ bɨ nɨ mɨndị́sịné ku mbotụ kụ́tụ́ ené bɨ cigí mongụ́ kágá bɨ kɨ́ ịrịné Mamaré ní. ");
INSERT INTO bdh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Zɨ́ Abarayáma sị́kpị doné ꞌdága, zɨ́a lúrúndíki yaꞌdá e ota mɨtóroyé kenée. Sɨmɨ bɨ lurúndiki yée ní, zɨ́a ị́nyịné geré ꞌdiya gɨ tara kụ́tụ́ ené ndéréne zɨ́ye do ótụ́ doné bi kóꞌdụ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Mɨngburoko ꞌyị amá e, togụ́ máútúásá tɨ́ go kacɨ́ komosé yá, ndásé ókpó gɨ domá ꞌyị ꞌbɨ moko esé geré mɨókpó wá. ");
INSERT INTO bdh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Idínɨ́ ógụ kɨ́ owụ́ iní zɨ́se lúgu sịndị́se kɨ́e, zɨ́se ndị́sịsé ca ꞌdówụ́rosé sị́ lị́ndị́ kágá ba ona. ");
INSERT INTO bdh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mááyí ba íꞌbí owụ́ éyị́ mɨánu zɨ́se gɨ ro zɨ́se ánu óꞌbụ rosé kɨ́e kí ásé nda fú ndéréókpó esé, gɨ zɨ́a bɨ ógụndíkisé máa ꞌyị ꞌbɨ moko esé go ní.” Zɨ́ yaꞌdá ga bɨ ota née úkulúgu ledre zɨ́a kɨ́dí, “Bɨlámáne, méngị mu káa zɨ́ bɨ úku née.” ");
INSERT INTO bdh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Née ní zɨ́ Abarayáma ndéré ólụ́ne ꞌdiya zɨ́ Sára sị́ kụ́tụ́. Zɨ́a úku ledre zɨ́a kɨ́dí, “ꞌDiꞌdiya, ꞌdíꞌbi aka mongụ́ gbété tụdụ zɨ́yị ụ́nzụ tụdụ bɨ memelị ní sɨmɨ a kɨ́ꞌdí ota zɨ́yị óꞌbó ambata gɨ sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Zɨ́a ngásáókpóne gɨ ore do bi bɨ kɨ́ ị́tị́ ené e doné ní, zɨ́a gélé zoro ị́tị́ bɨ bɨlámáne ní íꞌbí a zɨ́ ꞌyị ꞌbɨ moko ené idí ꞌdị́ꞌdị ụkụ́ ꞌdiya. ");
INSERT INTO bdh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gɨ ore zɨ́ Abarayáma ꞌdíꞌbi iní umba bangá bɨ iri mɨíri ní kɨ́ wo bɨ kákárá ní nda kɨ́ éyị́ mɨánu ógụ óto a cụ́ ne kóꞌdụ́ye. Sɨmɨ bɨ nɨyí ánu éyị́ ní, nɨ ꞌbɨ ené mɨtóroné sị́ lị́ndị́ kágá kenée. ");
INSERT INTO bdh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Zɨ́ye ndúꞌyú Abarayáma kɨ́dí, “Meꞌbeyị́ Sára nɨ ꞌda?” Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Nɨ bɨ sị́ kụ́tụ́ ꞌdáa ba.” ");
INSERT INTO bdh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Née ní zɨ́ Ngére Lomo úku ledre kɨ́dí, “Mááyí ndáꞌbaógụ ona kɨ́bi ngíti a sɨmɨ sịndị́ kadra káa, née ní meꞌbeyị́ Sára nɨ go kɨ́ owụ́oꞌdo kóꞌdụ́ne.” Sára nɨ kóo mɨndị́sịné sogo Abarayáma ku mbotụ kụ́tụ́ kenée zɨ́a ndị́sịné úwú ledre née. ");
INSERT INTO bdh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abarayáma e kɨ́ Sára nɨyí kóo go gbrengárá mbá ngokoyé. Sɨmɨbi ꞌbɨ Sára okpóomo yị́ ené kóo sɨmɨbi ꞌbɨ ndíki owụ́ go. ");
INSERT INTO bdh_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Née ní zɨ́ Sára útúne kúgú roné kɨ́ roné sɨmɨ bɨ sómụ́ lóꞌbó ledre née ní, zɨ́a úku ledre kɨ́dí, “Gɨ do kacɨ́ bɨ sɨmɨbi bɨ gɨ ro zɨ́ma ndíki owụ́ okpó go, mị́ngị́ ꞌbe ꞌbɨ amá nɨ go kpá ngokoné, mááyí fú lá ndíki owụ́?” ");
INSERT INTO bdh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Zɨ́ Ngére Lomo úku ledre zɨ́ Abarayáma kɨ́dí, “Éyị́ bɨ Sára kukugú zɨ́a úku ledre gɨ zɨ́a kɨ́dí, ‘Maꞌdíi mááyí tɨ́ ndíki owụ́ yá ní ꞌdi, bɨ mááyí go ngokomá káa ní ní?’ ");
INSERT INTO bdh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Éyị́ bɨ nɨ mɨórụné zɨ́ Ngére Lomo ní ꞌdi? Káa zɨ́ bɨ máúku ní, kɨ́bi ngíti a káa zɨ́ ba ní, ‘Mááyí ndáꞌbaógụ ndíki Sára go kɨ́ owụ́oꞌdo kóꞌdụ́ne.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Zɨ́ ngịrị ledre née méngị Sára, zɨ́a ítí kangú kɨ́dí, “Mákúgú amá kugú wá.” Lomo ya zɨ́a ní, “Kúkugú go.” ");
INSERT INTO bdh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Sɨmɨ bɨ yaꞌdá ga gére née nɨyí go ndéré ní, zɨ́ye óyó komoyé lúrú ꞌdị́yị bi nde mɨꞌdí sɨmɨ Sodóma. Gɨ ore zɨ́ Abarayáma ꞌdị́yị yée tara mɨsiꞌdi kenée. ");
INSERT INTO bdh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Zɨ́ Ngére Lomo ódroné zɨ́ne kɨ́ roné kɨ́dí, “Ledre bɨ máíli méngị a ba ndaá mɨútúásáne zɨ́ma ótoécị a gɨ zɨ́ Abarayáma wá. ");
INSERT INTO bdh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Gɨ zɨ́a tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌyị e kɨ́ rokoꞌbụyé nɨyí karanée ólụ́ógụ gɨ sɨmɨ a. Zɨ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí ga bɨ do sogo káṇgá ní mbá mááyí íꞌbí úndru kpụrụ́ gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mágélé wo go zɨ́a ídíne ꞌyị ꞌdódo bɨlámá mɨsiꞌdi zɨ́ owụ́ ꞌbɨ ené e kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e mbá gɨ ro zɨ́ye ndị́sịyé óto úndrumá kɨ́ méngị ledre ga bɨ utúasánɨ́ mɨútúásá ní gɨ ro zɨ́ Ngére Lomo íꞌbí éyị́ bɨ mocụ́ ledre a zɨ́ Abarayáma ní zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Née ní zɨ́ Ngére Lomo kpá úku ngíti ledre kɨ́dí, “Abarayáma, máúwú ledre bɨsinyí mɨméngị ledre ꞌbɨ ꞌyị ꞌbɨ Sodóma e kɨ́ Gomóra e go yaá ofụ nda go. ");
INSERT INTO bdh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Máíli ba ndéré lúrú ledre née za cụ́ kɨ́ komomá, togụ́ ledre bɨ mándị́sị úwú a née nɨ tɨ́ maꞌdíi yá. Togụ́ ndanɨ́ kenée wá, mááyí kpá ówo a.” ");
INSERT INTO bdh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Zɨ́ yaꞌdá ga bɨ gbre ní ndéré ꞌdị́yị royé mɨꞌdí sɨmɨ Sodóma, zɨ́ Ngére Lomo ídíáká ꞌbɨ ené zɨ́ Abarayáma ore. ");
INSERT INTO bdh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Zɨ́ Abarayáma ndósoógụné gbóo ro Ngére Lomo zɨ́a ndúꞌyú wo kɨ́dí, “Bɨ née ní ní áyí úfuónzó ꞌyị méngị bɨsinyí ledre e kɨ́ ꞌyị méngị bɨlámá ledre e mbá? ");
INSERT INTO bdh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sara togụ́ ꞌyị méngị bɨlámá ledre e nɨyí sɨmɨ gara née íri cị́ gbre doa sokó ní, áyí úfuónzó ꞌyị e íri mbá útúásá ótoómo bi gɨ ro ngíti géyị ꞌyị ga bɨ cị́ gbre doa sokó née wá? ");
INSERT INTO bdh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bɨ née ní ní útúásá úfu kótrụ ꞌyị méngị bɨlámá ledre e kɨ́ ꞌyị méngị bɨsinyí ledre wá, útúásá kpá méngị lárá ꞌyị méngị bɨlámá ledre e kɨ́ ꞌyị méngị bɨsinyí ledre ndro wá. Áyí Lomo bɨ ndịsị ꞌdécị yéme ngbanga ꞌyị e do sogo káṇgá ní mbá, ndị́sị méngị yị́ eyị́ dụụ́ ledre bɨ mɨútúásáne ní.” ");
INSERT INTO bdh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ngére Lomo ya zɨ́ Abarayáma ní, “Togụ́ máógụ ndíki ꞌyị méngị bɨlámá ledre e sɨmɨ Sodóma íri cị́ gbre doa sokó, mááyí ótoómo kɨ́ úfuónzó ꞌyị ga bɨ íri née gɨ royé.” ");
INSERT INTO bdh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Zɨ́ Abarayáma úku ledre zɨ́a kɨ́dí, “Ngére Lomo mándị́sị ódro zɨ́yị káa zɨ́ éyị́ bɨ rokoꞌbụmá ofụ go ní, mááyí lá éyị́ bɨ ngárá moko ndaá sɨmɨ a wá káa zɨ́ ꞌbụrụ kɨ́ mbụkụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Sara togụ́ ꞌyị e nɨyí íri lá dụụ́ cị́ gbre doa ịnyị (45) ní, áyí kpá fú úfuónzó ꞌyị ga bɨ sɨmɨ gara née mbá?” Lomo ya zɨ́a ní, “Togụ́ bɨlámá ꞌyị e nɨyí cị́ gbre doa ịnyị yá, mááyí ótoómo kɨ́ úfuónzó ꞌyị ga bɨ íri ní.” ");
INSERT INTO bdh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Zɨ́ Abarayáma kpá ndúꞌyú ándá wo kɨ́dí, “Sara togụ́ ndíki bɨlámá ꞌyị e íri lá dụụ́ cị́ gbre ní?” Lomo ya zɨ́a ní, “Gɨ ro bɨlámá ꞌyị ga bɨ cị́ gbre née ní, máúfuónzó ꞌyị ga bɨ íri née wá.” ");
INSERT INTO bdh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abarayáma ya zɨ́a ní, “Ngére Lomo mɨmbéꞌdeyị́ ndaá ésị́ romá wá. Mááyí aka kpá ndúꞌyú ngíti nduꞌyú káa. Sara togụ́ bɨlámá ꞌyị e nɨyí íri lá dụụ́ cị́ kéṛị́ doa sokó ní?” Lomo ya zɨ́a ní, “Abú bɨlámá ꞌyị e nɨyí lá dụụ́ cị́ kéṛị́ doa sokó yá, máútúásá úfuónzó ꞌyị ga bɨ íri née wá.” ");
INSERT INTO bdh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abarayáma ya zɨ́a ní, “Ngére Lomo mándị́sị nda ódro zɨ́yị káa zɨ́ éyị́ bɨ rokoꞌbụmá ofụ go ní, sara togụ́ ndíki bɨlámá ꞌyị e íri lá dụụ́ cị́kéṛị́ ní?” Lomo ya zɨ́a ní, “Gɨ ro bɨlámá ꞌyị ga bɨ cị́kéṛị́ née ní, máúfuónzó ꞌyị ga bɨ íri née wá.” ");
INSERT INTO bdh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abarayáma ya zɨ́a ní, “Ngére Lomo mɨmbéꞌdeyị́ ndaá ésị́ romá wá. Mááyí aka kpá ndúꞌyú ngíti nduꞌyú káa. Sara togụ́ bɨlámá ꞌyị e nɨyí íri lá dụụ́ sokó ní?” Lomo ya zɨ́a ní, “Gɨ ro bɨlámá ꞌyị ga bɨ sokó née ní, máúfuónzó ꞌyị ga bɨ íri née wá.” ");
INSERT INTO bdh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Sɨmɨ bɨ Ngére Lomo odro asá roné go zɨ́ Abarayáma ní, zɨ́a ndéréókpóne, zɨ́ Abarayáma kpá ndáꞌbalúgu roné ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Zɨ́ maláyika ga bɨ gbre née ndéréógụyé sɨmɨ Sodóma kɨ́ tagá, ogụ ndikinɨ́ Lóto mɨndị́sịné tara mbotụ gara ore. Sɨmɨ bɨ Lóto lurúndiki yée ní, zɨ́a ị́nyịné ndéréne ꞌdíꞌbi yee sɨmɨ sụmụ, zɨ́a lóꞌbụ komoné bi óto úndruyé. ");
INSERT INTO bdh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndásé ókpó gɨ cigí ꞌbe ꞌbɨ ꞌyị ꞌbɨ moko esé ꞌduo mɨókpó wá. Ídísé ógụ ndị́sị bi lúgu ꞌbụrụ gɨ ro sịndị́se, zɨ́se ꞌdúꞌdusé ona, kɨ́ phịyị́ zɨ́se nda ólụ́ógụsé ndérése.” Zɨ́ye úkulúgu ledre zɨ́ Lóto kɨ́dí, “Ɨ́ꞌɨ, azé ꞌdúꞌdu ezé gɨ ꞌdáa do mɨsiꞌdi ona.” ");
INSERT INTO bdh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tɨ́ lá zɨ́ Lóto ódroné zɨ́ye kɨ́ngaya, zɨ́ye úwú ledre ené zɨ́ye ndéréye zɨ́a ꞌbe. Zɨ́a óꞌbó ambata bɨ ngárá ꞌdeꞌdị́ ndaá sɨmɨ wá ní do méngị éyị́ mɨánu zɨ́ye ánu a. ");
INSERT INTO bdh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ꞌDáꞌdá zɨ́ Lóto e kɨ́ ṇgu ené e ꞌdúꞌduyé, zɨ́ ꞌyị ga bɨ ꞌbɨ Sodóma ní mɨngburoko yaꞌdá e kɨ́ phɨṛangá ga bɨ sɨmɨ gara ore ní mbá ógụyé tóro ꞌdíkí ꞌbe ꞌbɨ Lóto gbaá. ");
INSERT INTO bdh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Zɨ́ye ndólo Lóto ndúꞌyú a kɨ́dí, “Ṇgu ga bɨ gáa ogụnɨ́ zɨ́yị ꞌbe ona ba nɨyí go ꞌda? Ídí ꞌdíꞌbiógụ yée zɨ́ze, zɨ́ye ꞌdúꞌduyé sogozé káa do kará e.” ");
INSERT INTO bdh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Née ní zɨ́ Lóto ólụ́ógụné zɨ́ye sága, do ꞌdụ́tụ mbotụ kacɨ́ ṇgu ga gére née. ");
INSERT INTO bdh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ezegámáma e máṇgúṇgú romá zɨ́se, ndásé méngị bɨsinyí ledre káa zɨ́ bɨ ásé úku a née wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Lúrúsé aka, ṇgu ga bɨ ogụnɨ́ née nɨyí cakaba sị́ sị́lị́ma. Togụ́ ásé gɨ ro ledre káa zɨ́ bɨ ásé úku a née yá, nyị́ma e nɨyí bo gbre owonɨ́ aka ledre ꞌbɨ yaꞌdá e wá, mááyí íꞌbíógụ yée zɨ́se, zɨ́se méngị ledre bɨ ílisé méngị a ní kɨ́ye. Ndásé méngị kémbị́ bɨsinyí ledre kɨ́ ꞌyị ga gére née wá. Nɨyí ṇgu e ꞌbe ꞌbɨ amá ona ili zɨ́ma bándá yée.” ");
INSERT INTO bdh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Née ní zɨ́ye úku ledre zɨ́a kɨ́dí, “Ndá tóro ꞌdụ́tụ mɨsiꞌdi zɨ́ze wá, áyí gbékpị́ ꞌyị lóṇgó, íli úku ledre zɨ́ze káa zɨ́ ambi. Azé útúásá méngị láráyị rómo wo bɨ ilizé méngị a zɨ́ ṇgu ga bɨ ogụnɨ́ zɨ́yị ꞌbe née.” Zɨ́ye lányáye fú lá ro ledre née do ị́nyịyé ndéré útúye ꞌdéwe mbotụ ꞌbɨ Lóto. ");
INSERT INTO bdh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Zɨ́ ṇgu ga gére née ólụ́ógụyé sága lálalúgu Lóto ꞌdị́cị́, do ꞌdụ́tụ mbotụ. ");
INSERT INTO bdh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Zɨ́ye sémbị́ komo ꞌyị ga bɨ ku mbotụ ore ní zɨ́ mɨtụlụrụ útúne komoyé mbá, mɨngburoko ꞌyị e kɨ́ owụ́phɨṛangá e utúasánɨ́ ndíki mbotụ wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Zɨ́ maláyika ga bɨ gbre née úku ledre zɨ́ Lóto kɨ́dí, “Ngíti géyị ꞌyị eyị́ e nɨyí bo ona káa zɨ́ yaꞌdá ꞌbɨ nyị́yị e, wotị́yị e, togụ́ nyị́yị e, togụ́ mbú ngíti géyị ꞌyị ga bɨ gɨ do kacɨ́yị ní sɨmɨ gara ona? Ídí ꞌdíꞌbióyó yée gɨ ona ꞌdáꞌba, ");
INSERT INTO bdh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","gɨ zɨ́a azé go ndéré sínyiónzó gara née. Ngére Lomo uwú ledre bɨsinyí mɨméngị ledre eyé go kɨ́ngaya, bɨ kenée ní, kasaogụ zée go gɨ ro sínyiónzó gara ba.” ");
INSERT INTO bdh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Née ní zɨ́ Lóto ị́nyịné ndéréne úku ledre zɨ́ yaꞌdá ga bɨ karanée nɨyí ꞌdíꞌbi nyị́ga ní kɨ́ nyị́ne e kɨ́dí, “ꞌDiꞌdiya, ólụ́ógụsé gɨ ona mu. Ngére Lomo nɨ go ógụ sínyíónzó gara ba.” Tɨ́ lá somụ́nɨ́ yị́ eyé kɨ́dí ndịsị ízi izi. ");
INSERT INTO bdh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nda go kɨ́ sị́ ndóndó, zɨ́ maláyika ga gére née úku ledre zɨ́ Lóto kɨ́dí, “ꞌDiꞌdiya ị́nyị mu zɨ́yị ꞌdíꞌbi meꞌbeyị́ kɨ́ nyị́yị ga bɨ gbre née zɨ́se ólụ́ógụsé gɨ ona, káa bɨ ásé úyu sɨmɨ bɨ Ngére Lomo nɨ sínyiónzó gara ba ní.” ");
INSERT INTO bdh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Sɨmɨ bɨ Lóto nɨ aka fú lá íngbí roné ní, zɨ́ maláyika ga gére née ꞌdíꞌbi sị́lị́ Lóto, sị́lị́ meꞌbea, nda kɨ́ sị́lị́ nyị́ga ga bɨ gbre ní do ꞌdíꞌbiógụ yée gɨ sɨmɨ gara gɨ ore ꞌdáꞌba, gɨ zɨ́a Ngére Lomo ili yómo yée. ");
INSERT INTO bdh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kpá tɨ́ lá sɨmɨ bɨ ꞌdiꞌbiogụnɨ́ yée gɨ sɨmɨ gara gɨ ore go ní, zɨ́ ngúru maláyika úku ledre zɨ́ Lóto e kɨ́dí, “Gɨ ro zɨ́se yómo trịdrịsé, ngásásé mu ndásé lúrú bi ꞌdáꞌba wá, ndásé kpá tóro sɨmɨ ꞌbululu yana ore wá. Ídísé tɨ́ lá ngásáókpó geré do landa ꞌdága káa bɨ ásé úyu ke.” ");
INSERT INTO bdh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Zɨ́ Lóto úkulúgu ledre zɨ́ ngúruyé kɨ́dí, “Ndaá kenée wá mɨngburoko ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Lúrúsé aka mááyí ꞌyị ꞌbɨ moko esé mɨútúásá goó kacɨ́ komosé, zɨ́se go sáká máa yómo trịdrịmá. Tɨ́ lá máṇgúṇgú romá zɨ́se máútúásá ngásá gbála do landa íri wá, bɨsinyí ledre née nɨ ndíki máa yana zɨ́ma úyumá. ");
INSERT INTO bdh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Owụ́ gara nɨ bɨ gbóo ba, nɨ yị́ ené lá owụ́ bi cúkuꞌdée. Abú eye wá, togụ́ ótoómosé mɨsiꞌdi go zɨ́ze ngásáze íri kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ amá e yá azé ómo.” ");
INSERT INTO bdh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Maláyika née ya zɨ́ Lóto ní, “Bɨlámáne máótoómo mɨsiꞌdi go zɨ́yị ndéréyị íri. Máútúásá sínyiónzó gara bɨ úku ledre a née wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bɨ go kenée ní, ngásásé mu ꞌdiꞌdiya íri. Máútúásá aka méngị éyị́ wá, ꞌbúó togụ́ ógụsé go íri.” Née sị́ ledre bɨ ndolonɨ́ ịrị gara née gɨ zɨ́a Zóra ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lóto ngasáogụ sɨmɨ Zóra sɨmɨ bɨ kadra ólụ́ógụ go ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Zɨ́ Ngére Lomo léfe mɨnguṛogó so phoꞌdụ zɨ́a ndị́sị ṛéṛené gɨ komo ere do Sodóma kɨ́ Gomóra. ");
INSERT INTO bdh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Zɨ́a sínyiónzó gara ga bɨ gbre née kɨ́ ꞌbululu ga bɨ sɨmɨyé ní, kɨ́ éyị́ trịdrị ga bɨ íri ní mbá kpá kɨ́ kágá e za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tɨ́ lá bɨ meꞌbe Lóto oyó komoné lúrú bi ꞌdáꞌba ní, zɨ́a óyólóꞌbó roné káa do mɨnguṛogó toꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nda kɨ́ phịyị́ a née, zɨ́ Abarayáma ị́nyịné ndéréne kɨ́ꞌdí bɨ karana toronɨ́ kɨ́ Ngére Lomo doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Zɨ́a lúrú ꞌdị́yị bi mɨꞌdí sɨmɨ Sodóma kɨ́ Gomóra. Lurúndiki tɨ́ lá dụụ́ cika gụ́ndrụ káa zɨ́ cika mụꞌdụtụ́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Sɨmɨ bɨ Lomo sinyionzó gara ga bɨ sɨmɨ ꞌbululu ní, zɨ́a sómụ́ndíki ledre mɨyéme ledre bɨ kóo dongaráye kɨ́ Abarayáma ní, zɨ́a yómo Lóto gɨ sɨmɨ mongụ́ bɨsinyí ledre bɨ mengị roné do bi bɨ kóo Lóto ndịsị ndị́sị doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Zɨ́ Lóto e kɨ́ nyị́ne e ómụ́ye gɨ sɨmɨ Zóra ndéré ndị́sịyé gbála sɨmɨ gu landa, gɨ zɨ́a ngịrị mengị kóo yée mɨméngị kɨ́ ndị́sị sɨmɨ Zóra ore. ");
INSERT INTO bdh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kadra kị́éꞌdo zɨ́ nyị́ a bɨ mongụ́ ní úku ledre zɨ́ owụ́ lémịné kɨ́dí, “ꞌBụzé nɨ go ngokoné, yaꞌdá ndanɨ́ ona zɨ́ze ꞌdíꞌbi yée gɨ ro ndíki owụ́ e wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bɨ go kenée ní, idízé íꞌbí leꞌyị́ zɨ́a gɨ ro zɨ́a kóyóne gɨ do bɨ zɨ́ze ꞌdúꞌduzé sogo a káa do kará gɨ ro zɨ́ze ndíki owụ́ e.” ");
INSERT INTO bdh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kɨ́ ndụlụ a née ní zɨ́ye íꞌbí leꞌyị́ zɨ́ ꞌbụyé éwé a. Zɨ́ nyị́ a bɨ mongụ́ ní ị́nyịné ndéré ꞌdúꞌduné sogo a káa do káa kára. Tɨ́ lá Lóto owo bɨ ya née nyị́ne ní wá, owo kpá bi ndáꞌba a wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kɨ́lóndó a née ní, zɨ́ mongụ́ úku ledre zɨ́ owụ́ lémịné, kɨ́dí “Kɨ́ ndụlụna máꞌdúꞌdu go sogo babá. Idízé mu íꞌbí leꞌyị́ zɨ́a kóyóne kɨ́e gɨ ro kɨ́ ndụlụ ba zɨ́yị kpá ndéré ꞌdúꞌduyị́ sogo a gɨ ro zɨ́ze ídíze gbrengárá mbá kɨ́ owụ́ e.” ");
INSERT INTO bdh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kɨ́ ndụlụ née zɨ́ye go kpá íꞌbí leꞌyị́ zɨ́ ꞌbụyé éwé a zɨ́a kóyóne. Zɨ́ nyị́ a bɨ owụ́ ní kpá ndéréne ꞌdúꞌduné sogo a káa do kára. Owo kpá bɨ ya née nyị́ne ní wá, owo kpá bi ndáꞌba a wá. ");
INSERT INTO bdh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Née ní zɨ́ nyị́ Lóto ga bɨ gbre née ídíye mbá kɨ́ sɨmɨyé gɨ zɨ́ ꞌbụyé. ");
INSERT INTO bdh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Zɨ́ nyị́ a bɨ mongụ́ ní áráne owụ́oꞌdo, zɨ́a ị́fị́ ịrịa Muwába. Bɨ nɨ ne bulúndu kúfú ꞌyị ga bɨ ndịsịnɨ́ ndólo yée karaba kɨ́dí Muwába e ní. ");
INSERT INTO bdh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Zɨ́ nyị́ a bɨ owụ́ ní kpá áráne owụ́oꞌdo, zɨ́a ị́fị́ ịrịa Benámi. Nɨ ne bulúndu kúfú ꞌyị ga bɨ ndịsịnɨ́ ndólo yée karaba kɨ́dí Amóna ní. ");
INSERT INTO bdh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Zɨ́ Abarayáma ómụ́ne gɨ ore ndéréne mɨꞌdí do anú sɨmɨ ị́rịgbére bɨ ndolonɨ́ Negébe ní, zɨ́a ndéré ndị́sịné dongará Kadése kɨ́ Sụ́rụ. Zɨ́a ị́nyịné gɨ ore ndéré ndị́sịné ca sɨmɨ ngíti bi kɨ́ ịrịné Gerári ní, ");
INSERT INTO bdh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","zɨ́ Abarayáma uku yị́ ené zɨ́ ꞌyị e kɨ́dí, “Sára nɨ yị́ ené lémịmá.” Gɨ zɨ́ kéyị née ní zɨ́ Abimaléke ngére ꞌbɨ Gerári kákasa idínɨ́ ógụ kɨ́ Sára zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tɨ́ lá zɨ́ Ngére Lomo ógụné do Abimaléke sɨmɨ ꞌduru do úku ledre zɨ́a kɨ́dí, “Áyí go ógụ úyu gɨ zɨ́a kára bɨ ꞌdíꞌbi née nɨ yị́ ené meꞌbe ꞌyị.” ");
INSERT INTO bdh_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Abimaléke óto aka kóo Sára sogoné káa do kára wá. Zɨ́a ị́nyịné úku ledre kɨ́dí, “Ngére Lomo áyí útúásá úfu ꞌyị kɨ́ ꞌyị ené e lá gbékpị́ne kenée? ");
INSERT INTO bdh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abarayáma ukune kɨ́ tarané zɨ́ma kɨ́dí, ‘Sára nɨ lémịmá,’ zɨ́ kụṛụꞌbụ kára née kpá úku a kɨ́dí, ‘Abarayáma nɨ lúndumá.’ Máméngị ledre née kɨ́ mbigí ledre bɨ do mɨmbéꞌdemá ní, máméngị amá bɨsinyí ledre wá.” ");
INSERT INTO bdh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Née ní zɨ́ Lomo úkulúgu ledre zɨ́ Abimaléke sɨmɨ ꞌduru kɨ́dí, “Maꞌdíi máówo go kɨ́dí, méngị ledre née kɨ́ mbigí ledre bɨ do mɨmbéꞌdeyị́ ní, bɨ kenée ní máụ́cụómo yị́ị kpá go kɨ́ lúyú ledre romá. Née sị́ ledre bɨ máóto yị́ị zɨ́yị óto sị́lị́yị ro kára née gɨ zɨ́a wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Bɨ goó kenée ní, ótoómo meꞌbe oꞌdo née mu zɨ́a ndáꞌbané ꞌbe ꞌbɨ ené, gɨ zɨ́a oꞌdo ꞌbɨ ené nɨ yị́ ené nébị nɨ íni ini gɨ royị́ útúásá úyu wá. Tɨ́ lá togụ́ kála ledre née goó, ásé úyu kɨ́ ꞌyị eyị́ e za mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Sɨmɨ bi mɨárá née ní, zɨ́ Abimaléke ndóloyóko mɨngburoko ꞌyị ꞌbɨ ené e, zɨ́a lị́kpị́ ledre bɨ mengị roné née mbá zɨ́ye. Zɨ́ ꞌyị ga gére née ídíye mbá kɨ́ ngịrị royé kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Gɨ ore zɨ́ Abimaléke ndólo Abarayáma úku ledre zɨ́a kɨ́dí, “Méngị zɨ́ze bɨ káa ꞌdi? Éyị́ bɨ máméngị zɨ́yị bɨsinyíne ní ꞌdi, bɨ zɨ́yị ꞌdíꞌbiógụ mongụ́ bɨsinyí ledre káa zɨ́ ba domá kɨ́ ꞌyị amá e ní? Éyị́ bɨ méngị zɨ́ze née ní ndaá bɨlámáne wá.” ");
INSERT INTO bdh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Zɨ́ Abimaléke ndúꞌyú Abarayáma kɨ́dí, “Éyị́ bɨ sómụ́ wo zɨ́yị méngị kéyị gɨ zɨ́a kenée ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Zɨ́ Abarayáma úkulúgu ledre zɨ́a kɨ́dí, “Máméngị kéyị kenée, máyá bɨ ngárá ꞌyị ga bɨ ona ba erénɨ́ eyé ngịrị Lomo wá ní, nɨyí úfu máa gɨ ro ledre meꞌbemá ba. ");
INSERT INTO bdh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Maꞌdíi Sára nɨ yị́ ené tɨ́ lémịmá, ꞌbụzé kị́éꞌdo tɨ́ lá mbágáze nɨ mɨngúngúcua. Gɨ zɨ́ kéyị née ní zɨ́ma ꞌdíꞌbi wo káa do kára. ");
INSERT INTO bdh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Sɨmɨ bɨ Lomo uku ledre zɨ́ma ya máídí ólụ́ógụ gɨ ꞌbe ꞌbɨ babá zɨ́ma ndéré kɨ́ gámáma mɨꞌdaꞌdágá ní, máúku kóo ledre zɨ́ meꞌbemá máyá, ‘Ba mɨsiꞌdi bɨ áyí yómo máa doa ní. Bi ga bɨ azé gámá doyé ní mbá, ídí úku a zɨ́ ꞌyị e kɨ́dí, “Nɨ lúndumá.” ’ ” ");
INSERT INTO bdh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Zɨ́ Abimaléke ꞌdíꞌbi kábịṛị́kị e, ị́tị́ e kɨ́ owụ́kụlụ́ e yaꞌdáye kɨ́ karáye íꞌbí yée zɨ́ Abarayáma. Zɨ́a íꞌbílúgu Sára meꞌbe Abarayáma zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Zɨ́ Abimaléke úku ledre zɨ́ Abarayáma kɨ́dí, “Bi ga bɨ áyí lúrú yée née za mbá nɨyí do sị́lị́ma. Wo bɨ utúasá go kacɨ́ komoyị́ ní, ídí geré ndéré ndị́sị doa.” ");
INSERT INTO bdh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Zɨ́a ị́nyịné úku ledre zɨ́ Sára kɨ́dí, “Mááyí go íꞌbí mɨṛíṛiṛí késị́ álifu kị́éꞌdo zɨ́ lúnduyị́ gɨ ro zɨ́a ídíne mɨówoné zɨ́ ꞌyị e mbá kɨ́dí kémbị́ ledre ndaá dongaráze kéyị wá.” ");
INSERT INTO bdh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Zɨ́ Abarayáma ị́nyịné íni ini gɨ royé zɨ́ Lomo. Zɨ́ Lomo yómo Abimaléke e, kɨ́ meꞌbené e nda kɨ́ owụ́kụlụ́ ga bɨ kóo ore owụ́kará e ní zɨ́ye ndáꞌbayé ndíki owụ́ e. ");
INSERT INTO bdh_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ledre née mengị roné kenée gɨ zɨ́a Lomo ụcụomo kóo kará ga bɨ zɨ́ Abimaléke ꞌbe ní go kɨ́ ndíki owụ́ gɨ zɨ́ ledre bɨ kóo Abimaléke ayí ꞌdíꞌbi meꞌbe Abarayáma ní. Gɨ do kacɨ́ bɨ iꞌdí sị́lị́ne go gɨ ro Sára ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Née ní zɨ́ Ngére Lomo méngị yéme ledre zɨ́ Sára tɨ́ káa zɨ́ bɨ kóo mocụ́ ledre a zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Zɨ́ Sára ídíne kɨ́ sɨmɨné zɨ́a árá owụ́oꞌdo zɨ́ Abarayáma sɨmɨ bɨ Abarayáma nɨ goó ngokoné té sɨmɨ sịndị́ kadra bɨ kóo Lomo uku ledre a zɨ́ Abarayáma ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Zɨ́ Abarayáma ị́fị́ ịrị owụ́oꞌdo bɨ Sára ndiki zɨ́a née Isáka. ");
INSERT INTO bdh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sɨmɨ bɨ wotị́ a mengị go sị́lị́ ịnyị doa ota ní, zɨ́ Abarayáma ónzó wo ngbuṛu káa zɨ́ bɨ kóo Lomo lorụ Abarayáma kɨ́e ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isáka nɨ árá ní, sɨmɨbi ꞌbɨ Abarayáma nɨ kóo go míya kị́éꞌdo (100). ");
INSERT INTO bdh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Zɨ́ Sára úku ledre kɨ́dí, “Lomo oto kugú go taramá. ꞌYị ga bɨ nɨyí úwú ledre ba ní, azé ị́nyị kéye mbá kúkugú.” ");
INSERT INTO bdh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Zɨ́ Sára kpá úku ledre kɨ́dí, “Ambí owo kóo bɨ ya mááyí ndíki owụ́ zɨ́ Abarayáma ní ne? Bɨ ba ní, mándíki owụ́ go zɨ́ Abarayáma tɨ́ bɨ nɨ ngokoné née.” ");
INSERT INTO bdh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Zɨ́ komo owụ́ go énzịné, zɨ́ye ꞌdíꞌbióyó wo gɨ tara umba. Kadra bɨ ꞌdiꞌbioyónɨ́ Isáka gɨ tara umba ní, zɨ́ Abarayáma méngị mongụ́ ayímbi. ");
INSERT INTO bdh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tɨ́ lá sɨmɨ ngíti sị́lị́, zɨ́ Sára úwú do Isɨméle wotị́ Abarayáma bɨ Agára nyị́ ꞌyị ꞌbɨ Ízibiti ndiki ní kɨ́ ndị́sị kɨ́ ódro ódro fóló do bi ndeke, ");
INSERT INTO bdh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","zɨ́ Sára úku ledre zɨ́ Abarayáma kɨ́dí, “Ídí ógóóyó kára owụ́kụlụ́ née kɨ́ owụ́ ꞌbɨ ené née gɨ ꞌbe gɨ ona ꞌdáꞌba. Máíli zɨ́ owụ́ gɨ sɨmɨ kára owụ́kụlụ́ née karanée ífi sɨmɨ éyị́ sị́lị́yị kɨ́ wotị́ma Isáka wá.” ");
INSERT INTO bdh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Zɨ́ Abarayáma ídíne kɨ́ mongụ́ lerị́ do mɨmbéꞌdené gɨ ro owụ́ ꞌbɨ ené Isɨméle. ");
INSERT INTO bdh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tɨ́ lá zɨ́ Lomo úku ledre zɨ́ Abarayáma kɨ́dí, “Ndá ídí kɨ́ mongụ́ lerị́ do mɨmbéꞌdeyị́ gɨ ro owụ́ ꞌbɨ eyị́ née kɨ́ kára née wá, ídí lá méngị ledre bɨ Sára úku zɨ́yị ní. Ịrịyị́ nɨ ówụ́ do Isáka e kɨ́ owụ́ ꞌbɨ ené e. ");
INSERT INTO bdh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mááyí kpá óto owụ́ bɨ gɨ sɨmɨ kára owụ́kụlụ́ née zɨ́a ídíne bulúndu ṛị́kị́ sị́ do ꞌyịmaꞌdí e gɨ zɨ́a nɨ kpá owụ́ ꞌbɨ eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Akpa kɨ́ phịyị́ a née, zɨ́ Abarayáma ꞌdíꞌbi éyị́ mɨánu kɨ́ kúkú iní bɨ ịcị́nɨ́ gɨ sɨmɨ saná ní íꞌbí a zɨ́ Agára. Zɨ́a ị́mbị́óto a do gu Agára do úku ledre zɨ́a kɨ́dí olụ́ogụnɨ́ mu gɨ ꞌbe gɨ ona kɨ́ owụ́ née ꞌdáꞌba. Zɨ́ Agára e ꞌdíꞌbi mɨsiꞌdi ndéréye kɨ́ gámá lící royé sɨmɨ yana súwú sɨmɨ ị́rịgbére bɨ ndịsịnɨ́ ndólo a Bị́rịsába ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sɨmɨ bɨ iní bɨ sɨmɨ kúkú née ụkụ́ ní, zɨ́ Agára ị́mbị́ owụ́ ꞌbɨ ené née ndéré óto wo sị́ lị́ndị́ mɨdedenye kágá kenée. ");
INSERT INTO bdh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Zɨ́a ị́nyịné gɨ cigí a ndéré ndị́sịné gbála éyị́ ꞌbɨ dongará sịndị́ ꞌyị míya (100). Zɨ́a ódroné zɨ́ne kɨ́ roné kɨ́dí, “Máútúásá ndị́sị ona lúrú wo kɨ́ úyu wá.” Zɨ́a tónóne íni ini kɨ́ mongụ́ lerị́ do mɨmbéꞌdené. ");
INSERT INTO bdh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Zɨ́ Lomo úwú do owụ́ née kɨ́ íni ini, zɨ́ maláyika ꞌbɨ Lomo ndólo Agára gɨ komo ere do úku ledre zɨ́a kɨ́dí, “Ledre máa káa be ꞌdi? Ndá sị́kpị mɨmbéꞌdeyị́ ꞌdága wá. Lomo uwú do owụ́ née go kɨ́ íni ini bi sị́ kágá íri. ");
INSERT INTO bdh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ị́nyị mu ndéré ị́mbị́ sị́kpị owụ́ née ꞌdága, gɨ zɨ́a mááyí óto wo zɨ́a ídíne bulúndu tụ́ꞌdụ́ sị́ do ꞌyịmaꞌdí e.” ");
INSERT INTO bdh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Gɨ ore zɨ́ Lomo ꞌdódo bi ngíti ꞌdawú bɨ ore ní zɨ́ Agára. Sɨmɨ bɨ komo Agára utú ro ꞌdawú née ní, zɨ́a ndéréne lóló iní gɨrí ꞌbé sɨmɨ kúkú ógụné kɨ́e íꞌbí a zɨ́ owụ́ ꞌbɨ ené éwé a. ");
INSERT INTO bdh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Zɨ́ Lomo ídíne kɨ́ owụ́ née zɨ́a ngbóróógụné. Ndịsị kóo ndị́sị ené sɨmɨ súwú, gɨ zɨ́ kéyị née ní zɨ́a ídíne ꞌyị méngị bangá e. ");
INSERT INTO bdh_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Sɨmɨ bɨ nɨ sɨmɨ súwú sɨmɨ ị́rịgbére bɨ Paráná ní, zɨ́ mbágá a ófụ́ kára zɨ́a gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sɨmɨ sịndị́ kadra máa bɨ kóo née, zɨ́ Abimaléke e kɨ́ Pịkóla bɨ nɨ mongụ́ ꞌyị ꞌbɨ asikíri ené e ní ógụyé úku ledre zɨ́ Abarayáma kɨ́dí, “Lomo iꞌbí úndru go zɨ́yị sɨmɨ ledre ga bɨ ndị́sị méngị yée ní za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Bɨ ba ní, máíli go zɨ́yị lólóbụ́ do komo Lomo kɨ́dí, karaba ndéréne ꞌdáꞌdá áyí ndị́sị méngị zɨ́ma kɨ́ owụ́ ꞌbɨ amá e kɨ́ owụ́ ꞌbɨ owụ́ ꞌbɨ amá e fú lá bɨlámá ledre káa zɨ́ bɨ máꞌdíꞌbi yị́ị bɨlámáne sɨmɨ sụmụ sɨmɨ káṇgá bɨ áyí sɨmɨ a ona káa do ꞌyị lóṇgó ba ní.” ");
INSERT INTO bdh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abarayáma ya zɨ́a ní, “Málólóbụ́ go, mááyí ndị́sị méngị a tɨ́ kenée.” ");
INSERT INTO bdh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Gɨ do kacɨ́ a née ní, zɨ́ Abarayáma úkuógụ ledre bɨ sinyí roné gɨ ro ꞌdawú ené bɨ ꞌyị moko ꞌbɨ Abimaléke ngakanɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tɨ́ lá Abimaléke ya zɨ́a ní, “Máówo wá, togụ́ ambí mengị ledre née ne. Úku eyị́ zɨ́ma wá, máúwú go kpá bɨ gɨ tarayị́ née.” ");
INSERT INTO bdh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Née ní zɨ́ Abarayáma ꞌdíꞌbi kábịṛị́kị e kɨ́ ị́tị́ e íꞌbí yée zɨ́ Abimaléke, zɨ́ye ị́nyịyé gbrengárá yéme ledre do ídíye ezesáma e. ");
INSERT INTO bdh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Zɨ́ Abarayáma kpá ꞌdíꞌbi dụ́rụ́ kábịṛị́kị e ịnyị doa gbre óto yée kpị́ gɨ dongará kábịṛị́kị ené e. ");
INSERT INTO bdh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Zɨ́ Abimaléke ndúꞌyú wo kɨ́dí, “Éyị́ bɨ ꞌdíꞌbióyó nda dụ́rụ́ kábịṛị́kị eyị́ ga gére née gɨ dongará lafúye óto yée kpị́ gɨ zɨ́a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Zɨ́ Abarayáma úkulúgu ledre zɨ́a kɨ́dí, “Máíli zɨ́yị ꞌdíꞌbi kábịṛị́kị ga gére née káa do ꞌbɨ eyị́ gɨ ro zɨ́a ꞌdódo a zɨ́ ꞌyị e mbá kɨ́dí máíci ꞌdawú ba máa.” ");
INSERT INTO bdh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Née ní zɨ́ye ndólo ịrị bi née Bị́rịsába, gɨ zɨ́a yaꞌdá ga bɨ gbre née yemenɨ́ kóo ledre dongaráye ore. ");
INSERT INTO bdh_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Gɨ do kacɨ́ bɨ yemeonzónɨ́ ledre goó dongaráye sɨmɨ Bị́rịsába ní, zɨ́ Abimaléke e kɨ́ Pịkóla manda ꞌbɨ asikíri ené e ị́nyịyé ndáꞌbalúgu royé sɨmɨ káṇgá ꞌbɨ ꞌyị ꞌbɨ Falasitíni e. ");
INSERT INTO bdh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Zɨ́ Abarayáma ꞌdị́yị́ kágá bɨ kɨ́ ịrịné tamarasíka sɨmɨ Bị́rịsába ore. Zɨ́a ndị́sịné íni ini zɨ́ Ngére Lomo bɨ nɨ trịdrịné za fí ní ore. ");
INSERT INTO bdh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Zɨ́ Abarayáma maꞌdáa kóo ndị́sịné sɨmɨ káṇgá ꞌbɨ Falasitíni e ore kɨ́ tụ́ꞌdụ́ sɨmɨbi e. ");
INSERT INTO bdh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nda gɨ do kacɨ́ tụ́ꞌdụ́ sɨmɨbi e, zɨ́ Lomo ị́nyịné úzu Abarayáma. Zɨ́a ndólo wo kɨ́dí, “Abarayáma.” Zɨ́ Abarayáma ndị́zịné zɨ́a kɨ́dí, “Ɨɨ́.” ");
INSERT INTO bdh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Lomo ya zɨ́a ní, “Ídí ꞌdíꞌbi Isáka kémbị́ wotị́yị née, bɨ ꞌbúa nɨ doyị́ kɨ́ngaya ní, zɨ́yị ndéré kɨ́e sɨmɨ káṇgá ꞌbɨ Moríya e. Ídí óṇgoónzó wo zɨ́yị óngbó a káa do ꞌdáná éyị́ zɨ́ma do landa bɨ mááyí ꞌdódo a zɨ́yị ní.” ");
INSERT INTO bdh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Zɨ́ Abarayáma ị́nyịné akpa kɨ́ phịyị́ ódó bi ndị́sị do dongí ené, zɨ́a ꞌdíꞌbi wotị́ne Isáka kɨ́ ꞌyị ꞌbɨ moko ené e gbre ndéréye sóꞌdo ngị́rị́. Sɨmɨ bɨ sóꞌdo asánɨ́ ngị́rị́ bɨ gɨ ro óngbó ꞌdáná éyị́ doa go ní, zɨ́ye ị́nyịyé ndéréye do bi bɨ Lomo úku ledre a zɨ́ Abarayáma ní. ");
INSERT INTO bdh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nda go sɨmɨ sị́lị́ ota bɨ mengịnɨ́ kɨ́ ndéré ní, zɨ́ Abarayáma lúrúndíki landa bɨ Lomo uku ledre a ní gɨ gbála. ");
INSERT INTO bdh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Zɨ́a ị́nyịné úku ledre zɨ́ ꞌyị moko ené ga gére née kɨ́dí, “Ndị́sịsé ꞌbɨ esé kɨ́ bangá ba ona sɨmɨ bɨ azé go ndéré kɨ́ wotị́ma íri ní. Azé ndéré íni ini zɨ́ Lomo, azé gɨrí ndáꞌbaógụ.” ");
INSERT INTO bdh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Zɨ́ Abarayáma ị́mbị́óto ngị́rị́ bɨ ayínɨ́ ndéré óngbó éyị́ ꞌdáná doa ní do Isáka. Zɨ́a ꞌdíꞌbi ꞌbɨ ené ṛụ́kpụ́ phoꞌdụ kɨ́ mongụ́ maku yóó zɨ́ye ndéréye. ");
INSERT INTO bdh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Zɨ́ Isáka ndólo ꞌbụné Abarayáma kɨ́dí, “Babá.” Zɨ́ ꞌbụa ndị́zịné kɨ́dí, “Woyị́ị owụ́ ꞌbɨ amáa.” Zɨ́ Isáka ndúꞌyú wo kɨ́dí, “Mongụ́ maku kɨ́ ṛụ́kpụ́ phoꞌdụ nɨyí go bo, sara owụ́ kábịṛị́kị bɨ gɨ ro óngbó a káa do ꞌdáná éyị́ ní nɨ nda ꞌbɨ ené goó ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ꞌBụa ya zɨ́a ní, “Owụ́ ꞌbɨ amáa, Lomo nɨ íꞌbíógụ owụ́ kábịṛị́kị bɨ gɨ ro óngbó a káa do ꞌdáná éyị́ ní.” Nɨyí kpá fú mɨndéréye. ");
INSERT INTO bdh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sɨmɨ bɨ nderéogụnɨ́ go do bi bɨ Lomo uku ledre a ní, zɨ́ Abarayáma óꞌbó mbayi, zɨ́a séséyéme ngị́rị́ e doa bɨlámáne. Zɨ́a ị́nyịné ꞌdíꞌbi wotị́ne Isáka ódó wo ndá, do ị́mbị́óto wo do mbayi gá do ngị́rị́ ga bɨ seséyeme ní. ");
INSERT INTO bdh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Zɨ́a ị́nyịné ꞌdíꞌbi maku áyíne go gɨ ro óṇgoónzó wotị́ne. ");
INSERT INTO bdh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tɨ́ lá zɨ́ maláyika ꞌbɨ Ngére Lomo ndólo wo gɨ komo ere kɨ́dí, “Abarayáma.” Zɨ́a ndị́zịné kɨ́dí, “Ɨɨ́.” ");
INSERT INTO bdh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Zɨ́ Lomo úku ledre zɨ́a kɨ́dí, “Ndá óto so késị́ ro owụ́ née wá. Ndá gbawá méngị kémbị́ ledre kɨ́e. Máówoyéme go kɨ́dí maꞌdíi óto úndrumá go kɨ́ngaya, gɨ zɨ́a ási eyị́ kɨ́ kémbị́ owụ́ ꞌbɨ eyị́ née gɨ zɨ́ma wá.” ");
INSERT INTO bdh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Née ní sɨmɨ bɨ Abarayáma sịkpị doné lúrú bi káa ní, zɨ́a lúrúndíki yaꞌdá kábịṛị́kị bɨ ngiṛí a lanyángeṛị roné go ngará kágá kenée. Zɨ́ Abarayáma ị́nyịné ndéréne íꞌdíógụ kábịṛị́kị née gɨ ngará kágá gɨrí ógụ kɨ́e óṇgoónzó a ꞌdáná a zɨ́ Lomo do bi kacɨ́ wotị́ne. ");
INSERT INTO bdh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Zɨ́ Abarayáma ị́fị́ ịrị bi née kɨ́dí, “Ngére Lomo nɨ íꞌbí a.” Ndéréógụné gị karaba ní, ꞌyị e ndịsịnɨ́ kpá fú ndólo a ịrị bi máa née kɨ́dí, “Do landa bɨ Ngére Lomo nɨ íꞌbí a ní.” ");
INSERT INTO bdh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Zɨ́ maláyika ꞌbɨ Ngére Lomo kpá ndólo ándá Abarayáma gɨ komo ere ");
INSERT INTO bdh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","do úku ledre zɨ́a kɨ́dí, “Málóbụ́ romá go máa Ngére Lomo gɨ zɨ́a ledre bɨ méngị bɨ ngárá ási kɨ́ íꞌbí kémbị́ owụ́ ꞌbɨ eyị́ zɨ́ma wá ní, ");
INSERT INTO bdh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","maꞌdíi mááyí íꞌbí úndru zɨ́yị, zɨ́ bulúnduyị́ e étrịyé ídíye tụ́ꞌdụ́ tụ́ꞌdụ́ tụ́ꞌdụ́ káa zɨ́ kele ga bɨ komo ere kpá káa zɨ́ sayi bɨ do gbúṛóngó ní. Bulúnduyị́ e nɨyí rómo komo ezeokóye e zɨ́ye ꞌdíꞌbi mɨngburoko gara ga bɨ kacɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kpụrụ́ gɨ sɨmɨ bulúnduyị́ e, Mááyí karanée íꞌbí úndru zɨ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e do sogo káṇgá ona za mbá gɨ zɨ́a bɨ óto úndrumá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Zɨ́ Abarayáma ndáꞌbalúgu roné zɨ́ ꞌyị ꞌbɨ moko ené e, zɨ́ye nda ị́nyịyé ndáꞌbalúgu royé sɨmɨ Bị́rịsába kɨ́ꞌdí bɨ Abarayáma ndịsị ndị́sị ní. ");
INSERT INTO bdh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nda gɨ do kacɨ́ ledre ga gére ní, zɨ́ Abarayáma úwu ledre kɨ́dí, “Mílika ndiki owụ́ e go zɨ́ lúnduyị́ Nówara. ");
INSERT INTO bdh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ịrịyé nɨ Ụ́zụ bɨ nɨ owụ́ndíká ní, Bụ́zụ, Kemụwéle ꞌbụ Aráma, ");
INSERT INTO bdh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keséde, Ázo, Piledása, Zidiláfa, nda kɨ́ Bétụwele.” ");
INSERT INTO bdh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bétụwele nɨ nda ꞌbɨ ené ꞌbụ Rebéka. Owụ́ yaꞌdá ga bɨ ịnyị doa ota née Mílika ndiki yée ne zɨ́ Nówara lúndu Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Zɨ́ Nówara ꞌdíꞌbi ngíti kára kɨ́ ịrịné Rúma. Zɨ́a kpá ndíki ꞌbɨ ené owụ́ e eso, ịrị owụ́ ga gére née nɨ, Téba, Gáma, Tésa nda kɨ́ Máka. ");
INSERT INTO bdh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sára mengị kóo do sogo káṇgá mbá sɨmɨbi míya kɨ́ cị́kéṛị́ doa ịnyị doa gbre doné (127). ");
INSERT INTO bdh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Zɨ́a kóo úyuné sɨmɨ Kiríta Arába bɨ ndịsịnɨ́ kpá ndólo a Éborono Káṇgá ꞌbɨ ꞌyị ꞌbɨ Kanána e ní. Zɨ́ Abarayáma ídíne kɨ́ dokụlụ́ zɨ́a ndị́sịné íni meꞌbené née kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Zɨ́a ị́nyịné gɨ do umbu meꞌbené zɨ́a úku ledre zɨ́ kúfú ꞌyị ga bɨ ndịsịnɨ́ ndólo yée Éte e ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mááyí dongaráse ona ꞌyị lóṇgó. Ídísé úgúóyó bi zɨ́ma gɨ ro zɨ́ma óto umbu meꞌbemá sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Zɨ́ye úkulúgu ledre zɨ́ Abarayáma kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mongụ́ ꞌyị, úwú aka ledre bɨ azé úku a zɨ́yị ba, áyí dongaráze ona ꞌyị bɨ kɨ́ úndruyị́ kɨ́ngaya ní. Ídí lúrú bi bɨ utúasá go kacɨ́ komoyị́ do bi bɨ ndịsịzé óto umbu ezé e doa ní zɨ́yị óto umbu eyị́ sɨmɨ a. ꞌYị bɨ nɨ ási kɨ́ bi gɨ zɨ́yị kɨ́ óto umbu eyị́ sɨmɨ a ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Zɨ́ Abarayáma ị́nyịógụné do ótụ́ doné bi kóꞌdụ́ Éte e mị́ngị́ káṇgá e óto úndruyé. ");
INSERT INTO bdh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Togụ́ ṇgúṇgusé tɨ́ go gɨ ro zɨ́ma óto umbu meꞌbemá ona yá, máṇgúṇgú romá zɨ́se ídísé ndúꞌyú Éforono wotị́ Zóra do bi kacɨ́ma, ");
INSERT INTO bdh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","idí úgúóyó gu landa ené bɨ Makeféla tara yáká ené íri née zɨ́ma. Mááyí íꞌbí késị́ bɨ utúasá goó kacɨ́ komoa ní zɨ́a gɨ ro zɨ́ma kpá ídíma kɨ́ bi óto umbu dongaráse ona ndị́sị óto ꞌyị amá e sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Éforono bɨ ꞌyị ꞌbɨ Éte ní nɨ kóo mɨndị́sịné tara mbotụ gara ore dongará ꞌyị ené e zɨ́a úkulúgu ledre zɨ́ Abarayáma do komo ꞌyị ꞌbɨ Éte ga bɨ kóo ore mbá kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ɨ́ꞌɨ, ngére amá, úwú aka ledre bɨ mááyí úku a zɨ́yị ba, máíꞌbí yáká née kɨ́ gu landa bɨ ndúnduꞌyú gɨ roa née go mbá zɨ́yị. Máíꞌbí bi née go zɨ́yị do komo ꞌyị amá ga ba gɨ ro zɨ́yị ndị́sị óto umbu eyị́ e sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Zɨ́ Abarayáma kpá lóꞌbụ komoné bi kóꞌdụ́ ꞌyị ga gére née. ");
INSERT INTO bdh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Zɨ́a úku ledre zɨ́ Éforono do komo ꞌyị ga gére née kɨ́dí, “Utúasá mɨútúásá zɨ́ma nda gba íꞌbí késị́ zɨ́yị gɨ ro yáká née. Ídí ṇgúṇgu a zɨ́ma kenée gɨ ro zɨ́ma óto umbu amá íri.” ");
INSERT INTO bdh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Zɨ́ Éforono úkulúgu ledre zɨ́ Abarayáma kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mongụ́ ꞌyị, úwú aka ledre bɨ mááyí úku a zɨ́yị ba, bi née gɨ ro úgú a, ili mɨṛíṛiṛí késị́ míya eso. Tɨ́ lá ledre bɨ dongaráze kéyị ꞌdi? Ndéré mu óto umbu eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Zɨ́ Abarayáma ṇgúṇgu ledre bɨ Éforono uku ní zɨ́a ꞌdíꞌbiógụ mɨṛíṛiṛí késị́ míya eso íꞌbí a zɨ́a do komo ꞌyị ꞌbɨ Éte e ore. Née késị́ bɨ ꞌyị úgúóyó éyị́ e ndịsịnɨ́ méngị moko kɨ́e dongaráye ní. ");
INSERT INTO bdh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Née ní yáká ꞌbɨ Éforono bɨ sɨmɨ Makeféla gbóo kɨ́ Mamaré ní kɨ́ gu landa bɨ sɨmɨ yáká máa née ní, kɨ́ kágá ga bɨ sɨmɨ a kɨ́ yée ga bɨ do mama ní mbá do íꞌbí a ");
INSERT INTO bdh_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","zɨ́ Abarayáma káa do ꞌbɨ ené do komo ꞌyị ꞌbɨ Éte ga bɨ kóo ku mbotụ mongụ́ gara ore ní. ");
INSERT INTO bdh_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Gɨ do kacɨ́ née ní zɨ́ Abarayáma ꞌdíꞌbi umbu meꞌbené Sára ndéré óto a sɨmɨ Kanána sɨmɨ gu landa bɨ Makeféla cigí Mamaré sɨmɨ gara bɨ Éborono ní. ");
INSERT INTO bdh_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Gɨ ore zɨ́ yáká kɨ́ gu landa née nda ídíye ꞌbɨ Abarayáma. Ndịsị nda kóo óto umbu ꞌyị ené e fú sɨmɨ gu landa née ore. ");
INSERT INTO bdh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Lomo iꞌbí úndru zɨ́ Abarayáma sɨmɨ éyị́ ga bɨ ndịsị méngị yée ní mbá. Zɨ́a ꞌdúꞌduné do sogo káṇgá kɨ́ tụ́ꞌdụ́ sɨmɨbi zɨ́a nda ídíne ngokoné kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kadra kị́éꞌdo zɨ́a ndólo manda ꞌbɨ ꞌyị ꞌbɨ moko ené e, zɨ́a úku ledre zɨ́ manda née kɨ́dí, “Máíli zɨ́yị lólóꞌbụ́ zɨ́ma ");
INSERT INTO bdh_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kɨ́ ịrị Ngére Lomo bɨ otoogụ ere kɨ́ do sogo káṇgá ní kɨ́dí, útúásá lúrú kára zɨ́ wotị́ma Isáka gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Kanána ga bɨ mááyí dongaráye ona ba wá. ");
INSERT INTO bdh_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Máíli zɨ́yị ndéréyị sɨmɨ káṇgá amá zɨ́yị ófụ́ kára zɨ́ wotị́ma Isáka gɨ dongará ꞌyị amá e.” ");
INSERT INTO bdh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Zɨ́ ꞌyị ꞌbɨ moko née ndúꞌyú Abarayáma kɨ́dí, “Sara togụ́ mándéré zɨ́ma ófụ́ kára go zɨ́ Isáka ili ené zɨ́ze ógụzé kéne sɨmɨ káṇgá ba yáa wá ní? Máídí ógụ ꞌdíꞌbi Isáka ndáꞌba kɨ́e sɨmɨ káṇgá esé íri?” ");
INSERT INTO bdh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Zɨ́ Abarayáma úkulúgu ledre zɨ́ ꞌyị ꞌbɨ moko née kɨ́dí, “Ídí ówo a bɨlámáne kɨ́dí ndaá mɨútúásáne zɨ́yị ꞌdíꞌbilúgu wotị́ma íri wá. ");
INSERT INTO bdh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ngére Lomo bɨ komo ere, kóo ꞌdiꞌbiogụ máa gɨ ꞌbe ꞌbɨ babá gɨ dongará sụmụmá e gɨ sɨmɨ káṇgá ezé ona ní, mocụ́ kóo ledre go zɨ́ma kɨ́dí, ‘Mááyí íꞌbí káṇgá ba zɨ́ bulúnduyị́ e ní,’ nɨ kásaógụ maláyika ené zɨ́yị ꞌdáꞌdá íri gɨ ro zɨ́yị ófụ́ kára gɨrí ógụ kɨ́e zɨ́ wotị́ma. ");
INSERT INTO bdh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Togụ́ kára maꞌdáa ili ené zɨ́se ógụsé kéne wá ne, ledre eyị́ ndaá. Tɨ́ lá ndaá mɨútúásáne zɨ́yị ꞌdíꞌbilúgu wotị́ma íri wá.” ");
INSERT INTO bdh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Née ní zɨ́ ꞌyị moko née lólóbụ́ zɨ́ mongụ́ ꞌyị ené Abarayáma kɨ́dí née nɨ méngị ledre bɨ Abarayáma uku zɨ́ne née tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Zɨ́ ꞌyị ꞌbɨ moko née ꞌdíꞌbi gémele e ꞌbɨ mongụ́ ꞌyị ené sokó, zɨ́a ꞌdíꞌbi ngíti géyị bɨlámá éyị́ ga bɨ kɨ́ tosoyé ní gɨ zɨ́ mongụ́ ꞌyị ené. Zɨ́a ndéréne sɨmɨ káṇgá bɨ Mesopatómiya ní, do ókpóne sɨmɨ Aráma Naráyima gara bɨ Nówara ndịsị sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Sɨmɨ bɨ nderéogụ íri ní, zɨ́a óto gémele e ꞌdówụ́royé cígí ngíti ꞌdawú ꞌdáꞌdá olụ́nɨ́ aka sɨmɨ gara wá. Née kóo go kɨ́ kadra tagá sɨmɨ sịndị́ kadra bɨ kará e ndịsịnɨ́ íngi iní sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Née ní zɨ́a íni ini kɨ́dí, “Ngére Lomo, áyí Lomo bɨ mongụ́ ꞌyị amá ndịsị óto úndruyị́ ní. Máṇgúṇgú romá zɨ́yị sɨmɨ sị́lị́ bɨ karaba ba ídí íꞌbí éyị́ bɨ málólóbụ́ gɨ roa zɨ́ mongụ́ ꞌyị amá Abarayáma ní zɨ́ma gɨ ro zɨ́a ídíne kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mááyí go bɨ mɨtóromá do ꞌdawú ba, tụ́ꞌdụ́ nyị́ ꞌyị ga bɨ ꞌbɨ gara ba nɨyí ógụ cakaba íngi iní. ");
INSERT INTO bdh_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ídí óto owụ́kára bɨ mááyí uku ledre zɨ́a máyá, ‘Oto aka ndoko iní eyị́ bi zɨ́yị íꞌbí iní zɨ́ma éwé a,’ zɨ́a ídíne ne wo bɨ nɨ úku ledre zɨ́ma kɨ́dí, ‘Éwé iní mu mááyí kpá íꞌbí a zɨ́ gémele eyị́ e éwé a,’ zɨ́a kpá ídíne ne wo bɨ gélé wo go zɨ́ ꞌyị kasa eyị́ Isáka ní. Gɨ sɨmɨ ledre née ní mááyí ówo a kɨ́dí mɨyéme ledre bɨ yéme wo zɨ́ mongụ́ ꞌyị amá Abarayáma ní née goó wo.” ");
INSERT INTO bdh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ꞌDáꞌdá zɨ́a kɨ́ íni ónzó ini zɨ́ Lomo, zɨ́ Rebéka nyị́ Bétụwele bɨ nɨ nyị́ Mílika meꞌbe Nówara lúndu Abarayáma ní ógụné kɨ́ ndoko iní doné. ");
INSERT INTO bdh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nɨ aka lá owụ́kára tara mbotụ kɨ́ lámá roné kɨ́ngaya owo aka ledre ꞌbɨ yaꞌdá e wá. Zɨ́a ógụné geré ndụ́ṛụ́ꞌbụ́ne sɨmɨ ꞌdawú, íngiꞌdúcu ndoko iní ené do ólụ́ógụné. ");
INSERT INTO bdh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Geré zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ Abarayáma née ngásáꞌdécị doa do úku ledre zɨ́a kɨ́dí, “Máṇgúṇgú romá zɨ́yị, íꞌbí aka iní zɨ́ma éwé a gɨ sɨmɨ ndoko iní eyị́ née.” ");
INSERT INTO bdh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Zɨ́ Rebéka ndálané kɨ́ ndoko iní née zɨ́a úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, éwé iní mu.” Zɨ́a íꞌbí iní zɨ́a éwé a. ");
INSERT INTO bdh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Gɨ do kacɨ́ bɨ ewé asá iní go ní, zɨ́ Rebéka úku ledre zɨ́a kɨ́dí, “Mááyí kpá íꞌbí iní zɨ́ gémele eyị́ e éwé e gị togụ́ ewé asánɨ́ go ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Geré ꞌdiya zɨ́a léfe iní bɨ sɨmɨ ndoko iní ené ní sɨmɨ éyị́ bɨ bangá e ndịsịnɨ́ éwé iní gɨ sɨmɨ a ní zɨ́ gémele ga gére née, do ngásálúgu roné íngi yata iní léfe a zɨ́ye éwé a, do éwé ásá a. ");
INSERT INTO bdh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ꞌYị ꞌbɨ moko née nɨ mɨtóroné kenée ndị́sị lúrú wo ịtị mbá wá, ili tɨ́ lá ówo a togụ́ Ngére Lomo mengị bɨlámá ledre go zɨ́ne sɨmɨ mɨógụné ba yá. ");
INSERT INTO bdh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sɨmɨ bɨ gémele ga gére ewé asánɨ́ iní go ní, zɨ́ oꞌdo née ꞌdíꞌbiógụ amafí bɨ gɨ sɨmɨ dábu ní ésị a ro somo Rebéka. Zɨ́a kpá ꞌdíꞌbiógụ mɨmbitá e gbre gɨ sɨmɨ dábu ésị ro sị́lị́a. ");
INSERT INTO bdh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Zɨ́a ị́nyịné ndúꞌyú Rebéka kɨ́dí, “Áyí nyị́ ambi? Bɨ née ní bi ꞌdúꞌdu nɨ laká bo ꞌbe ꞌbụyị́ íri gɨ ro zɨ́ze ndéré ꞌdúꞌduzé sɨmɨ a?” ");
INSERT INTO bdh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Zɨ́ Rebéka úkulúgu ledre zɨ́a kɨ́dí, “Mááyí nyị́ Bétụwele wotị́ Mílika bɨ ndiki wo zɨ́ Nówara ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Zɨ́a kpá úku ledre kɨ́dí, “Bi ꞌdúꞌdu kɨ́ éyị́ mɨánu ꞌbɨ bangá e nɨ bo zɨ́ze mongụ́ne. ꞌDị́cị́ nɨ kpá bo gɨ ro zɨ́se ꞌdúꞌdusé sɨmɨ a.” ");
INSERT INTO bdh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Née ní zɨ́ oꞌdo née ótụ́ doné bi óto úndru Ngére Lomo, ");
INSERT INTO bdh_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","zɨ́a úku ledre kɨ́dí “Mbófo éyị́ zɨ́ Ngére Lomo bɨ mongụ́ ꞌyị amá Abarayáma ndịsị óto úndrua ní, bɨ otoomo mɨyéme ledre bɨ kóo yeme zɨ́a ní wá ní. Gɨ romá, Ngére Lomo saká máa goó zɨ́ma ndéréógụmá gị ꞌbe ꞌbɨ ꞌyị ga bɨ ꞌbɨ mongụ́ ꞌyị amá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Gɨ ore, zɨ́ Rebéka ngásálúgu roné ꞌbe lị́kpị́ ledre ga bɨ mengịnɨ́ royé íri ní zɨ́ ꞌyị ga bɨ ꞌbɨ mbágáne ní. ");
INSERT INTO bdh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Zɨ́ Labána lúndu Rebéka ị́nyịné ngásáne zɨ́ oꞌdo née do ꞌdawú íri. ");
INSERT INTO bdh_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Sɨmɨ bɨ lurúndiki amafí ro somo Rebéka kɨ́ mɨmbitá sị́lị́a, nda kɨ́ ledre bɨ uwú wo bɨ ndịsị lịkpị́ a bɨ oꞌdo née uku zɨ́a ní, zɨ́a geré ndéréne ógụndíki oꞌdo née kɨ́ tóro cígí gémele ené e do ꞌdawú íri. ");
INSERT INTO bdh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Zɨ́ Labána úku ledre zɨ́a kɨ́dí, “Ógụ mu zɨ́ze ndéréze kéyị ꞌbe. Áyí ꞌyị bɨ Lomo iꞌbí úndru go zɨ́a ní. Ndị́sị tóro do mɨsiꞌdi ona gɨ ro ꞌdi? Máyéme ómo bi goó gɨ royị́ nzíyiné kpá kɨ́ bi gɨ ro gémele eyị́ e.” ");
INSERT INTO bdh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Née ní zɨ́ oꞌdo née ndéréye kɨ́ Labána ꞌbe, do líkpíóyó éyị́ e gɨ do gémele e. Do íꞌbí éyị́ mɨánu kɨ́ bi ꞌdúꞌdu ꞌbɨ bangá e zɨ́ gémele ga gére née kɨ́ iní zɨ́ oꞌdo née zɨ́ye lúgu sịndị́ye kɨ́e kɨ́ ꞌyị ga bɨ ogụnɨ́ kéye ní. ");
INSERT INTO bdh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Do íꞌbíógụ éyị́ mɨánu zɨ́ye, tɨ́ lá zɨ́ oꞌdo née úku ledre kɨ́dí, “Máútúásá aka ánu éyị́ wá, ꞌbúó togụ́ ledre bɨ máógụ kɨ́e ba máúku go zɨ́se.” Labána ya zɨ́a ní, “Úku ledre bɨ ógụ kɨ́e ní mu zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Zɨ́a úku ledre kɨ́dí, “Mááyí ꞌyị ꞌbɨ moko ꞌbɨ Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ngére Lomo iꞌbí úndru go zɨ́ mongụ́ ꞌyị amá Abarayáma kɨ́ngaya zɨ́a ídíne kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne. Iꞌbí kábịṛị́kị e, ína e, ị́tị́ e, mɨṛíṛiṛí késị́ e kɨ́ dábu e, kɨ́ ꞌyị ꞌbɨ moko e kará e kɨ́ yaꞌdá e nda kpá kɨ́ gémele e kɨ́ dongí e. ");
INSERT INTO bdh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sára meꞌbe mongụ́ ꞌyị amá ndiki owụ́ zɨ́a owụ́oꞌdo do ngokoné, bɨ ba ní mongụ́ ꞌyị amá iꞌbí éyị́ sị́lị́ne go mbá zɨ́ owụ́ máa née. ");
INSERT INTO bdh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Zɨ́ mongụ́ ꞌyị amá óto máa lólóbụ́ zɨ́ne do úku ledre zɨ́ma kɨ́dí, ‘Ndá ófụ́ kára zɨ́ wotị́ma gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Kanána e bɨ mááyí sɨmɨ káṇgá eyé ona ꞌyị lóṇgó ba wá, ");
INSERT INTO bdh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ídí ndéré ófụ́ kára zɨ́ wotị́ma gɨ dongará sụmụ babá e gɨ tara mbotụ ezé.’ ");
INSERT INTO bdh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Née ní zɨ́ma ndúꞌyú mongụ́ ꞌyị amá máyá, ‘Togụ́ bɨ kára máa née ili ené útú do kacɨ́ma wá ní?’ ");
INSERT INTO bdh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Zɨ́a úkulúgu ledre zɨ́ma kɨ́dí, ‘Ngére Lomo bɨ mándị́sị óto úndrua kacɨ́ kadra mbá ní, nɨ kása maláyika ené zɨ́yị ꞌdáꞌdá zɨ́a yémeómo ledre zɨ́yị, zɨ́yị ófụ́ kára zɨ́ wotị́ma gɨ dongará sụmụ babá e gɨ tara mbotụ ezé.’ ");
INSERT INTO bdh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Togụ́ ndéréógụ goó dongará sụmụmá e, asinɨ́ yị́ eyé ye kɨ́ ótoómo sị́lị́ye gɨ ro kára maꞌdáa kɨ́dí ndaá útú do kacɨ́yị wá yá, née ndaá ledre eyị́ wá.” ");
INSERT INTO bdh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Sɨmɨ bɨ gáa máógụ do ꞌdawú ꞌdáa ní, zɨ́ma gáa íni ini máyá, ‘Ngére Lomo bɨ mongụ́ ꞌyị amá Abarayáma ndịsị óto úndruyị́ ní, máṇgúṇgú romá zɨ́yị ledre bɨ máógụ gɨ roa ba ídí óto a zɨ́a ídíne bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mááyí go bɨ mɨtóromá do ꞌdawú ba, sɨmɨ bɨ nyị́ ꞌyị ga bɨ ꞌbɨ gara ba nɨyí ógụ íngi iní, wo bɨ máúku ledre go zɨ́a máyá, “Máṇgúṇgú romá zɨ́yị íꞌbí aka iní zɨ́ma gɨ sɨmɨ ndoko iní eyị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Togụ́ uku ledre go zɨ́ma kɨ́dí, “Mongụ́ ꞌyị, éwé iní mu, mááyí kpá íꞌbí a zɨ́ gémele eyị́ e éwé a yá,” idí ídíne owụ́kára máa wo bɨ gélé wo go káa do kára zɨ́ wotị́ mongụ́ ꞌyị amá ní.’ ");
INSERT INTO bdh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Máíniónzó aka ini ba gɨ do mɨmbéꞌdemá kpá wá, ve, zɨ́ Rebéka ógụné kɨ́ ndoko iní doné. Zɨ́a ndụ́ṛụ́ꞌbụ́ne do ꞌdawú íri íngi iní. Zɨ́ma úku ledre zɨ́a máyá, ‘Íꞌbí aka iní zɨ́ma éwé a.’ ");
INSERT INTO bdh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Zɨ́a ndálané kɨ́ ndoko iní née zɨ́a úku ledre zɨ́ma kɨ́dí, ‘Mongụ́ ꞌyị, éwé iní mu, mááyí kpá íꞌbí a zɨ́ gémele eyị́ e éwé a.’ Née ní zɨ́ma éwé iní zɨ́a kpá íꞌbí a zɨ́ gémele amá e. ");
INSERT INTO bdh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Zɨ́ma ndúꞌyú wo kɨ́dí, ‘Áyí nyị́ ambi?’ “Zɨ́a úkulúgu ledre kɨ́dí, ‘Mááyí nyị́ Bétụwele wotị́ Mílika bɨ ndiki wo zɨ́ Nówara ní.’ “Née ní zɨ́ma ésị amafí ro somoa kɨ́ mɨmbitá sị́lị́a. ");
INSERT INTO bdh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Zɨ́ma ótụ́ domá bi óto úndru Ngére Lomo máyá, mámbófo yị́ị go Ngére Lomo bɨ mongụ́ ꞌyị amá ndịsị óto úndrua ní, sáká máa go zɨ́ma ógụmá ndíki owụ́kára gɨ tara mbotụ ꞌbɨ mongụ́ ꞌyị amá káa do kára zɨ́ wotị́a. ");
INSERT INTO bdh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Bɨ ba ní máíli go ówo a gɨ zɨ́se togụ́ ásé ṇgúṇgu a zɨ́se méngị bɨlámá ledre zɨ́ mongụ́ ꞌyị amá yá, togụ́ útúásásé wá, ídísé úku a zɨ́ma gɨ ro zɨ́ma ówo éyị́ bɨ mááyí méngị a ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Zɨ́ Labána e kɨ́ ꞌbụné Bétụwele úkulúgu ledre zɨ́a kɨ́dí, “Bɨ née yị́ ené go mɨyéme ledre ꞌbɨ Ngére Lomo ní, ledre ndaá tarazé úku a kacɨ́ a zɨ́yị wá. ");
INSERT INTO bdh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebéka nɨ go née ꞌdíꞌbi wo mu, zɨ́se ndérése kéne zɨ́ wotị́ mongụ́ ꞌyị eyị́ káa do kára káa zɨ́ bɨ Ngére Lomo uku ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Sɨmɨ bɨ ꞌyị ꞌbɨ moko née uwú ledre bɨ ukunɨ́ kenée ní, zɨ́a ótụ́ doné bi óto úndru Ngére Lomo. ");
INSERT INTO bdh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Gɨ do kacɨ́ ledre née ní, zɨ́ ꞌyị moko née ꞌdíꞌbiógụ mɨṛíṛiṛí késị́ kɨ́ dábu nda kɨ́ bongó e íꞌbí yée zɨ́ Rebéka. Zɨ́a kpá íꞌbí ngíti géyị éyị́ ga bɨ ugúnɨ́ yée kɨ́ tụ́ꞌdụ́ késị́ ní zɨ́ lúndua kɨ́ mbágáa. ");
INSERT INTO bdh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nda née ní, zɨ́ ꞌyị moko née kɨ́ ꞌyị ga bɨ ogụnɨ́ kéye ní ánu éyị́ do éwé éyị́, zɨ́ye ꞌdúꞌduyé ore bi ndre. Nda go kɨ́ phịyị́, zɨ́a úku ledre kɨ́dí, “Másómụ́ utúasá go gɨ ro zɨ́ma ndáꞌbamá kɨ́ sanda zɨ́ mongụ́ ꞌyị amá.” ");
INSERT INTO bdh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Zɨ́ Labána e kɨ́ mbágáne úkulúgu ledre kɨ́dí, “Ótoómosé aka Rebéka maꞌdáa zɨ́ze ona kɨ́ sị́lị́ ịnyị doa gbre togụ́ mbú sị́lị́ sokó, nɨ nda fú ógụ ndéré.” ");
INSERT INTO bdh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndásé lolụ ụ́cụómo máa wá, káa zɨ́ bɨ Ngére Lomo yemeonzó ledre amá go ní. Nɨ mɨútúásáne zɨ́se íꞌbí mɨsiꞌdi zɨ́ma ndáꞌbamá zɨ́ mongụ́ ꞌyị amá.” ");
INSERT INTO bdh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Zɨ́ye úkulúgu ledre kɨ́dí, “Ili go zɨ́ze ndóloógụ Rebéka maꞌdáa zɨ́ze úwú ledre bɨ gɨ tara ní.” ");
INSERT INTO bdh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Zɨ́ye ndóloógụ wo ndúꞌyú wo kɨ́dí, “Bɨ née ní ní ásé go ógụ ndéré kɨ́ oꞌdo ba yá?” Rebéka ya zɨ́ye ní, “Ɨɨ, azé ndéré ndro kéne.” ");
INSERT INTO bdh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Née ní zɨ́ye íꞌbí mɨsiꞌdi zɨ́ Rebéka e kɨ́ kára bɨ ꞌyị ꞌbɨ moko ené ní, nda kɨ́ ꞌyị moko ꞌbɨ Abarayáma née kɨ́ ꞌyị ga bɨ ogụnɨ́ kéye ní. ");
INSERT INTO bdh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Zɨ́ye údru súrú do mɨmbéꞌde Rebéka do úku ledre kɨ́dí, “Ndéré mu, Lomo idí íꞌbí úndru zɨ́yị, zɨ́yị ndíki tụ́ꞌdụ́ owụ́ e gɨ sɨmɨyị́, zɨ́ tetéyị ga gére ndị́sịyé rómo komo ezeokóye e za mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Née ní zɨ́ Rebéka e kɨ́ kára bɨ ꞌyị ꞌbɨ moko ené ní yéme royé zɨ́ye ékị́ ndị́sịyé do gémele e zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ Abarayáma née ꞌdíꞌbi yée, yóó zɨ́ye ndéréye. ");
INSERT INTO bdh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Isáka ndaꞌbaogụ nda gɨ sɨmɨ Béralayiróyi bɨ ini ledre gɨ sɨmɨ a yaá ꞌdawú ꞌbɨ Lomo bɨ lurú máa ní go. Oto nda ꞌbe go sɨmɨ Negébe. ");
INSERT INTO bdh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kadra kị́éꞌdo kɨ́ tagá, zɨ́ Isáka ólụ́ógụné ndéré kɨ́ gámá ꞌdózo komo sịndị́ne kɨ́ sómụ́ ngíti géyị ledre ené e, nɨ lúrú bi káa ní, gémele e nɨyí go ógụ. ");
INSERT INTO bdh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Zɨ́ Rebéka sị́kpị doné zɨ́a lúrúndíki Isáka. Zɨ́a ndítíógụné bi gɨ do gémele ené. ");
INSERT INTO bdh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Zɨ́a ndúꞌyú ꞌyị moko ꞌbɨ Abarayáma née kɨ́dí, “Ambí ndịsị ógụ ꞌdị́yị roné gɨrí mɨꞌdí zɨ́ze yáa née ne?” Zɨ́ ꞌyị moko ꞌbɨ Abarayáma née úkulúgu ledre zɨ́a kɨ́dí, “Née Isáka, wotị́ mongụ́ ꞌyị amá.” Geré zɨ́ Rebéka lóꞌbụꞌdụ́tụ komoné kɨ́ mbílí bongó. ");
INSERT INTO bdh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Zɨ́ ꞌyị moko née lị́kpị́ ledre ga bɨ mengịnɨ́ royé íri ní mbá zɨ́ Isáka. ");
INSERT INTO bdh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Née ní zɨ́ Isáka ꞌdíꞌbi ésị Rebéka sɨmɨ kụ́tụ́ bɨ kóo mbágáa Sára ndịsị ndị́sị sɨmɨ a ní, zɨ́a ídíne go kára zɨ́a. Isáka oto kóo ꞌbúa go kɨ́ngaya. Mɨógụ a zɨ́ Isáka ꞌbe, oto kóo Isáka go zɨ́a sómụ́lị́gị ledre umbu mbágáne. ");
INSERT INTO bdh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Gɨ do kacɨ́ bɨ Sára uyu ní, zɨ́ Abarayáma ꞌdíꞌbi ngíti kára kɨ́ ịrịné Ketụ́ra. ");
INSERT INTO bdh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Zɨ́ Ketụ́ra ndíki owụ́ yaꞌdá e zɨ́a, ịnyị doa kéṛị́. Nɨyí, Zimaráni, Zokosána, Midáni, Mịdịyáni, Isibáka nda kɨ́ Súwa. ");
INSERT INTO bdh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Zɨ́ Zokosána ndíkiógụ ꞌbɨ ené Síba e kɨ́ Dedána. Zɨ́ Dedána ndíkiógụ ꞌbɨ ené Asuríma e, kɨ́ Letụsịtésị e nda kɨ́ Lewumịtésị. ");
INSERT INTO bdh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wotị́ Mịdịyáni nɨyí ꞌbɨ eyé, Éfa, Efére, Enóka, Abị́da, nda kɨ́ Eledáya. Née mbá owụ́ ga bɨ olụ́ogụnɨ́ gɨ sɨmɨ Ketụ́ra ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Zɨ́ Abarayáma ótoómo éyị́ sị́lị́ne e mbá zɨ́ Isáka. ");
INSERT INTO bdh_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tɨ́ lá sɨmɨ bɨ Abarayáma nɨ aka kɨ́ komoné ní, zɨ́a íꞌbí ngíti géyị éyị́ sị́lị́ne e zɨ́ wotị́ne ga bɨ ndiki yée kɨ́ ngíti géyị kará e ní. Zɨ́a úku ledre kɨ́dí idínɨ́ ị́nyị ꞌbɨ eyé gɨ cigí Isáka go ona ꞌdáꞌba, do ndéré ꞌbɨ eyé sɨmɨ káṇgá bɨ mɨꞌdí gbére ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abarayáma mengị kóo do sogo káṇgá mbá sɨmɨbi míya doa cị́ ota doa sokó doa ịnyị (175). ");
INSERT INTO bdh_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Uyu nda kóo sɨmɨ bɨ ngoko goó za kɨ́ngaya ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Zɨ́ wotị́ga Isáka e kɨ́ Isɨméle óto wo kpá sɨmɨ gu landa bɨ Makeféla sɨmɨ yáká ꞌbɨ Éforono wotị́ Zóra ꞌyị ꞌbɨ Éte e gbóo cigí Mamaré ní, ");
INSERT INTO bdh_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","née yáká bɨ kóo Abarayáma ugú gɨ zɨ́ ꞌyị ꞌbɨ Éte e ní. Otonɨ́ Abarayáma e kɨ́ meꞌbené Sára ore. ");
INSERT INTO bdh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Gɨ do kacɨ́ umbu Abarayáma, zɨ́ Lomo íꞌbí úndru zɨ́ wotị́ a Isáka zɨ́a ógụ ndị́sịné cigí ꞌdawú bɨ cigí Béralayiróyi ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ga ba ịrị wotị́ Isɨméle bɨ Agára nyị́ ꞌyị ꞌbɨ Ízibiti bɨ ꞌyị ꞌbɨ moko ꞌbɨ Sára ndiki wo zɨ́ Abarayáma ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ịrị wotị́ Isɨméle ga ba, zezénɨ́ kacɨ́ mɨndíki yée. Mɨzefiyé nɨ Nebayóta, Kedára, Adabéla, Mibasáma, ");
INSERT INTO bdh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misáma, Dụ́ma, Mása, ");
INSERT INTO bdh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adáda, Téma, Zetụ́ra, Nafísa nda kɨ́ Kedéma. ");
INSERT INTO bdh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nɨyí ye ꞌyị ga bɨ sị́ do ga bɨ sokó doa gbre née olụ́ogụ gɨ sɨmɨyé ní. Do ndolo ịrịyé kacɨ́ do ꞌbe ꞌbɨ eyé e kɨ́ ịrị bi ga bɨ táya eyé e nɨyí doyé ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isɨméle mengị kóo mbá sɨmɨbi míya doa cị́kéṛị́ doa sokó doa ịnyị doa gbre (137), zɨ́a úyu lódụ́ kacɨ́ ꞌyị ené e. ");
INSERT INTO bdh_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Zɨ́ bulúnduga ndị́sịyé sɨmɨ ị́rịgbére bɨ tonó gɨ sɨmɨ Avíla ndéréógụné gị sɨmɨ Sụ́rụ gbóo do mama bɨ dongará a kɨ́ Ízibiti sɨmɨ bɨ ꞌyị nɨ ndéré ꞌdị́yị roné mɨꞌdí sɨmɨ Asụ́rị ní. Bɨlámá ndị́sị ndaá ꞌbɨ ené kóo dongaráye kɨ́ lúnduyé e wá. ");
INSERT INTO bdh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ba ledre gɨ ro Isáka wotị́ Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Sɨmɨbi ꞌbɨ Isáka nɨ kóo cị́ gbre, zɨ́a ófụ́ Rebéka nyị́ Bétụwele lémị Labána bɨ nɨ ꞌyị ꞌbɨ Padána Aráma gɨ sɨmɨ Mesopatómiya ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Zɨ́ Isáka íni ini zɨ́ Ngére Lomo do bi kacɨ́ Rebéka gɨ zɨ́a nɨ kára mɨkoto. Zɨ́ Ngére Lomo úwú ini ené zɨ́ meꞌbea ídíne kɨ́ sɨmɨné. ");
INSERT INTO bdh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Zɨ́ owụ́ e ídíye sɨmɨ Rebéka toṇgo, zɨ́ye ndị́sị óṛó royé kɨ́ ezené sɨmɨa. Zɨ́ Rebéka úku ledre kɨ́dí, “Éyị́ ndịsị nda méngị roné zɨ́ma káa gɨ zɨ́ ꞌdi?” Née ní zɨ́a ị́nyịné ndéréne ndúꞌyú Ngére Lomo sɨmɨ ini. ");
INSERT INTO bdh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Zɨ́ Ngére Lomo úkulúgu ledre zɨ́a kɨ́dí, “Ṛị́kị́ sị́ do ꞌyịmaꞌdí e nɨyí gbre sɨmɨyị́, toṇgo ga gére née nɨyí ífi royé mɨífi. Ngúru a nɨ ídí kɨ́ rokoꞌbụné kɨ́ngaya rómo do ezené, owụ́ꞌdáꞌdá nɨ ídí ꞌyị ị́nyị kasa zɨ́ owụ́ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Sɨmɨ bɨ sịndị́ kadra ꞌbɨ Rebéka utúasá go gɨ ro zɨ́a áráne ní, zɨ́a áráógụ tɨ́ owụ́ toṇgo e gbre mbá owụ́ yaꞌdá e. ");
INSERT INTO bdh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Zɨ́ owụ́ꞌdáꞌdá áráógụ ꞌbɨ ené bɨkesị́ne kɨ́ bị roné mbá káa zɨ́ esịnɨ́ roa bongó bɨ yemenɨ́ gɨ sɨmɨ bị bangá ní. Née ní, zɨ́ye ị́fị́ ịrịa Ésawu. ");
INSERT INTO bdh_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Zɨ́ lúndua bɨ aráogụ ꞌbɨ ené gɨ do kacɨ́ a ní, aráogụ ꞌbɨ ené nyé kɨ́ sị́lị́ne ndá ro sịndị́ Ésawu. Née ní, zɨ́ye ị́fị́ ịrịa Yakóbo. Sɨmɨ bɨ Rebéka nɨ árá owụ́ ga gére ní, sɨmɨbi ꞌbɨ Isáka nɨ kóo go cị́ ota. ");
INSERT INTO bdh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sɨmɨ bɨ owụ́ yaꞌdá ga gére née ngboróogụnɨ́ go mɨngburokoyé ní, zɨ́ Ésawu ídíne ꞌyị gámá súwú. Zɨ́ ambá sịndị́ kadra ené ídíne mbá sɨmɨ súwú. Née ní Yakóbo áyí ꞌbɨ eyị́ lá ꞌbe ndị́sị méngị moko ga bɨ ꞌbɨ ꞌbe ní. ");
INSERT INTO bdh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isáka ndịsị óto ꞌbú Ésawu kɨ́ngaya gɨ zɨ́ esị bɨ ndịsị ánu a gɨ do sị́lị́a ní, tɨ́ lá Rebéka oto ꞌbɨ ené yị́ ené ꞌbú Yakóbo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sɨmɨ ngíti sị́lị́, zɨ́ ꞌbú úfu Ésawu kɨ́ngaya sɨmɨ bɨ nɨ ndáꞌbaógụ kɨ́ gámá sɨmɨ súwú ní, zɨ́a ógụndíki Yakóbo kɨ́ ꞌdị́ꞌdị phirinda ené, ");
INSERT INTO bdh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","zɨ́a úku ledre zɨ́ Yakóbo kɨ́dí, “Lúndu ꞌbɨ ené, lára aka phirinda eyị́ née gɨrí ꞌdiya zɨ́ma ndéne a mááyí go úyu gɨ zɨ́ ꞌbú.” (Née sị́ ledre bɨ ndolonɨ́ wo gɨ zɨ́a Edómo ní.) ");
INSERT INTO bdh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Ídí ótoómo bi eyị́ ꞌbɨ owụ́ndíká née zɨ́ma kí, mááyí fú íꞌbí a zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Née ní Ésawu ya zɨ́a ní, “Mááyí go úyu gɨ zɨ́ ꞌbú, ídí káa do owụ́ndíká nɨ méngị ndíki zɨ́ma ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakóbo ya zɨ́a ní, “Ídí lólóbụ́ zɨ́ma kí.” Née ní zɨ́ Ésawu lólóbụ́. Zɨ́a otoomo bi ꞌbɨ owụ́ndíká go zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Gɨ ore, zɨ́ Yakóbo ꞌdíꞌbi phirinda kɨ́ ambata íꞌbí a zɨ́ Ésawu ánu a. Sɨmɨ bɨ anu éyị́ zɨ́a éwé éyị́ ní, zɨ́a ị́nyị ndéréókpóne. Ésawu lurúcayi mɨídíne bɨ káa do owụ́ndíká ní kenée. ");
INSERT INTO bdh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mongụ́ ꞌbú utú kóo sɨmɨ káṇgá née kpị́ gɨ zɨ́ wo bɨ kóo utú sɨmɨ sịndị́ kadra ꞌbɨ Abarayáma ní. Zɨ́ Isáka ị́nyịné ndéréne zɨ́ mongụ́ ngére Abimaléke ꞌbɨ kúfú ꞌyị ga bɨ Falasitíni e ní, sɨmɨ káṇgá bɨ Gerári ní. ");
INSERT INTO bdh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Zɨ́ Ngére Lomo ꞌdódo roné zɨ́ Isáka do úku ledre zɨ́a kɨ́dí, “Ndá ndéré sɨmɨ Ízibiti wá, ídí ndị́sị sɨmɨ káṇgá bɨ mááyí úku ledre a zɨ́yị ndị́sịyị́ sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ídí ndị́sị ca sɨmɨ káṇgá ba ona, mááyí ndị́sị sáká yị́ị zɨ́ma íꞌbí úndru zɨ́yị. Mááyí íꞌbí káṇgá ba mbá zɨ́yị kɨ́ bulúnduyị́ e, mááyí méngị ledre e zɨ́yị kacɨ́ mɨyéme ledre bɨ kóo dongaráze kɨ́ ꞌbụyị́ Abarayáma ní. ");
INSERT INTO bdh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mááyí óto bulúnduyị́ e zɨ́ye étrịyé káa zɨ́ kele ga bɨ komo ere ní, zɨ́ma íꞌbí káṇgá ba mbá zɨ́ye. Kpụrụ́ gɨ sɨmɨ bulúnduyị́ e Mááyí karanée íꞌbí úndru zɨ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e do sogo káṇgá ona za mbá, ");
INSERT INTO bdh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","gɨ zɨ́a Abarayáma uwú kóo ledre amá zɨ́a ndị́sịné méngị ledre ga bɨ máíli yée, kɨ́ ledre ga bɨ máúku yée ní nda kpá kɨ́ lódụ́ lorụ amá e.” ");
INSERT INTO bdh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Née ní zɨ́ Isáka ídíákáne ndị́sịné sɨmɨ Gerári. ");
INSERT INTO bdh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Sɨmɨ bɨ ꞌyị ga bɨ ore nduꞌyúnɨ́ Isáka gɨ ro ledre meꞌbea ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Nɨ lémịmá,” gɨ zɨ́a eré ngịrị kɨ́ úku ledre zɨ́ye ya, “Nɨ meꞌbemá.” Somụ́ yaá ꞌyị ga bɨ ore ní nɨyí úfu née gɨ ro ledre Rebéka gɨ zɨ́a lámá nɨ roa kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sɨmɨ bɨ Isáka luꞌbú nda go ore ní, kadra kị́éꞌdo zɨ́ Abimaléke ngére ꞌbɨ Falasitíni lúrú bi gɨ do subáa zɨ́a lúrúndíki Isáka e kɨ́ ndéndeke kɨ́ meꞌbené Rebéka. ");
INSERT INTO bdh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Zɨ́ ngére Abimaléke kákasa kacɨ́ Isáka, do úku ledre zɨ́a kɨ́dí, “Maꞌdíi nɨ yị́ ené tɨ́ meꞌbeyị́. Sara úku zɨ́ ꞌyị e yá, ‘Nɨ lémịmá’ ní gɨ zɨ́ ꞌdi?” Zɨ́ Isáka úkulúgu ledre zɨ́a kɨ́dí, “Gɨ zɨ́a máyá ꞌbɨ amá nɨyí úfu máa gɨ roa.” ");
INSERT INTO bdh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Zɨ́ Abimaléke úku ledre zɨ́ Isáka kɨ́dí, “Éyị́ bɨ méngị kéyị zɨ́ze kenée gɨ zɨ́a ní ꞌdi? Togụ́ bɨ kóo ngíti ꞌyị nderé sóꞌdo meꞌbeyị́ ní mbé ꞌdíꞌbiógụ kóo komozé née go umbu.” ");
INSERT INTO bdh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Zɨ́ ngére Abimaléke íꞌbí lorụ zɨ́ ꞌyị ené e za mbá kɨ́dí, “Togụ́ ꞌyị oto sị́lị́ne ro Isáka togụ́ mbú ro meꞌbea sɨmɨ káṇgá ba ona, yị́ị máa née odụ a ꞌbɨ eyị́ dụụ́ umbu.” ");
INSERT INTO bdh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Zɨ́ Isáka óꞌdo éyị́ sɨmɨ sɨmɨbi máa née, zɨ́ éyị́ e ánáye zɨ́a kɨ́ngaya gɨ zɨ́a Ngére Lomo iꞌbí úndru go zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Zɨ́a ídíne kɨ́ éyị́ e zɨ́ne, zɨ́ éyị́ máa ga gére kpá fú ndị́sị éyeyé, odụ a zɨ́a nda ídíne goó ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní. ");
INSERT INTO bdh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Née ní gɨ zɨ́ kábịṛị́kị kɨ́ ị́tị́ ga bɨ zɨ́a kpá kɨ́ tụ́ꞌdụ́ ꞌyị ꞌbɨ moko e ní, zɨ́ Falasitíni e nda ndị́sị óto mɨmbéꞌdeyé roa bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Gɨ zɨ́ mɨmbéꞌdekesị́, zɨ́ Falasitíni e ásiyé kɨ́ ꞌdawú bɨ kóo ꞌyị ꞌbɨ moko ꞌbɨ Abarayáma ꞌbụ Isáka icinɨ́ ní káa bɨ nɨyí íngi a do ụ́nzụ ꞌdúcu a mbá kɨ́ káṇgá. ");
INSERT INTO bdh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Née ní zɨ́ Abimaléke úku ledre zɨ́ Isáka kɨ́dí, “Ólụ́ógụ mu gɨ sɨmɨ káṇgá ba gɨ ona ꞌdáꞌba, rokoꞌbụyị́ romo do ꞌbɨ ezé go.” ");
INSERT INTO bdh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Zɨ́ Isáka ómụ́ne gɨ ore ndéré óto táya ené sɨmɨ ꞌBululu ꞌbɨ gara bɨ Gerári ní ndị́sịné ore. ");
INSERT INTO bdh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Zɨ́ Isáka ícilúgu ꞌdawú ga bɨ kóo ꞌbụa Abarayáma ici, zɨ́ Falasitíni e ásiyé kɨ́e gɨ do kacɨ́ umbu Abarayáma ní, zɨ́a ị́fị́lúgu kpá kémbị́ ịrị ga gére née do ꞌdawú ga gére née. ");
INSERT INTO bdh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Sɨmɨ ngíti sị́lị́ zɨ́ ꞌyị ꞌbɨ moko ga bɨ ꞌbɨ Isáka kpá ndéréye íci ngíti ꞌdawú sɨmɨ ꞌbululu bɨ ndịsị kacɨ́ kóꞌdụ́ a ní, zɨ́ye íci ndíki iní bɨ ndịsị lágaógụ gɨ sị́ káṇgá ní. ");
INSERT INTO bdh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tɨ́ lá zɨ́ ꞌyị ꞌbáꞌbá bangá ga bɨ ꞌbɨ ꞌyị ꞌbɨ Gerári e ndị́sịyé ófụ́ye dongaráye kɨ́ ꞌyị ꞌbáꞌbá bangá ga bɨ ꞌbɨ Isáka ní zɨ́ye úku ledre zɨ́ ꞌyị ꞌbɨ Isáka e kɨ́dí, “Ba yị́ ené iní ezé.” Née ní zɨ́ Isáka ị́fị́ ịrị ꞌdawú née “Eséke,” ini ledre gɨ sɨmɨ a kɨ́dí ꞌdawú ófụ́ gɨ zɨ́a ꞌyị e ndịsịnɨ́ kóo ófụ́ ore. ");
INSERT INTO bdh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Née ní zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ Isáka e kpá íci ngíti ꞌdawú, zɨ́ye kpá ófụ́ye gɨ roa. Zɨ́ Isáka ị́fị́ ịrị ꞌdawú máa wo née nda, “Sitína,” ini ledre gɨ sɨmɨ a kɨ́dí ꞌdawú okó. ");
INSERT INTO bdh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Zɨ́ Isáka ómụ́ne gɨ ore ndéré íci ngíti ꞌdawú, ꞌyị ófụ́ ndaá lolụ kɨ́ye gɨ roa wá. Gɨ zɨ́ kéyị née zɨ́a ị́fị́ ịrị ꞌdawú máa wo née kɨ́dí, “Rebóta,” ini ledre gɨ sɨmɨ a bikịdrị́ gɨ zɨ́a ófụ́ ndaá lolụ wá zɨ́a úku ledre kɨ́dí, “Bɨ ba ní Ngére Lomo iꞌbí goó ne zɨ́ze, azé go ógụ ídí kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ze sɨmɨ káṇgá ba ona.” ");
INSERT INTO bdh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Gɨ ore, zɨ́ Isáka ndéréókpóne sɨmɨ gara bɨ Bị́rịsába. ");
INSERT INTO bdh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kɨ́ ndụlụ a née, zɨ́ Ngére Lomo ꞌdódo roné zɨ́ Isáka do úku ledre zɨ́a kɨ́dí, “Mááyí Lomo bɨ kóo ꞌbụyị́ Abarayáma ndịsị óto úndrua ní. Ndá éré ngịrị wá, kacɨ́ kadra mbá mááyí ídí kɨ́yị. Mááyí íꞌbí úndru zɨ́yị zɨ́ bulúnduyị́ e étrịyé do ídíye tụ́ꞌdụ́ kacɨ́ mɨyéme ledre bɨ kóo máyéme zɨ́ ꞌyị ꞌbɨ moko amá Abarayáma ní.” ");
INSERT INTO bdh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Zɨ́ Isáka óꞌbó mbayi ore ndị́sị íni ini sị́ a ore zɨ́ Ngére Lomo. Zɨ́a ụ́bụ́ kụ́tụ́, zɨ́ ꞌyị ꞌbɨ moko ené e íci ngíti ꞌdawú ore. ");
INSERT INTO bdh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sɨmɨ ngíti sị́lị́ zɨ́ ngére Abimaléke ị́nyịné gɨ sɨmɨ Gerári nɨyí kɨ́ Awụ́za ꞌyị íꞌbí lorụ zɨ́a kɨ́ Pịkóla mongụ́ ꞌyị ené ꞌbɨ asikíri ené e ndéréye zɨ́ Isáka. ");
INSERT INTO bdh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Zɨ́ Isáka ndúꞌyú yée kɨ́dí, “Ógụsé zɨ́ma yáa káa be ꞌdi bɨ kóo bi ndị́sịmá ndaá gɨ zɨ́se wá zɨ́se ị́nyịsé ógó máa gɨ sɨmɨ káṇgá esé ní?” ");
INSERT INTO bdh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Owozé go maꞌdíi kɨ́dí Ngére Lomo nɨ yị́ ené kɨ́yị, née ní zɨ́ze úku ledre kɨ́dí nɨ mɨútúásáne zɨ́ze óto mɨyéme ledre dongaráze kése. Idízé mu óto mɨyéme ledre dongaráze, ");
INSERT INTO bdh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kɨ́dí útúásá méngị bɨsinyí ledre zɨ́ze wá. Abú lagazé kóo yị́ị gɨ sɨmɨ káṇgá ezé yá, otozé ezé kóo sị́lị́ze royị́ wá. Bɨ ba ní Ngére Lomo iꞌbí úndru go zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Zɨ́ Isáka méngị mongụ́ ayímbi gɨ royé, zɨ́ye ánu éyị́ kpá kɨ́ éwé éyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nda goó akpa kɨ́ phịyị́ zɨ́ye lólóbụ́ mɨkékeṛị́a dongaráye. Zɨ́ Isáka íꞌbí mɨsiꞌdi zɨ́ye ndéréye, zɨ́ye ị́nyịyé ótoómo wo ore zɨ́ mɨndị́sị a ídíne bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kadra née ní zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ Isáka ógụyé úku ledre ꞌdawú bɨ icinɨ́ ní zɨ́a. Zɨ́ye úku ledre kɨ́dí, “Ndikizé iní go.” ");
INSERT INTO bdh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Zɨ́ Isáka ị́fị́ ịrị ꞌdawú née “Sị́ba.” Ndéréógụné gị karaba ní, ịrị gara bɨ kóo née ní fú lá Bị́rịsába. ");
INSERT INTO bdh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sɨmɨ bɨ sɨmɨbi ꞌbɨ Ésawu nɨ go cị́ gbre ní, zɨ́a ófụ́ kará e gbre, Yodị́ta e kɨ́ Basimáta mbá gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Éte e. Yodị́ta nɨ ꞌbɨ ené nyị́ Bérị, Basimáta ꞌbɨ ené nyị́ Éloni. ");
INSERT INTO bdh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tɨ́ lá zɨ́ kará ga bɨ gbre née íꞌbí dokogo zɨ́ Isáka e kɨ́ Rebéka kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Sɨmɨ bɨ Isáka ngoko go, komoa lurú lolụ kpá bi mbị́ wá ní, zɨ́a ndólo mongụ́ wotị́ne Ésawu do úku ledre zɨ́a kɨ́dí, “Owụ́ ꞌbɨ amáa.” Zɨ́a úkulúgu ledre zɨ́a kɨ́dí, “Ɨɨ́ babá.” ");
INSERT INTO bdh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Zɨ́ Isáka úku ledre zɨ́a kɨ́dí, “Mááyí go ngokomá, máówo sị́lị́ bɨ mááyí úyu sɨmɨ a ní wá. ");
INSERT INTO bdh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ꞌDíꞌbi aka sama eyị́ kɨ́ kéré eyị́ zɨ́yị ólụ́ógụyị́ sɨmɨ súwú ndéré gámásóꞌdo owụ́ bɨlámá ụkụ́ zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ídí ꞌdị́ꞌdị bɨlámá esị bɨ kɨ́ ꞌbúne domá kɨ́ngaya ní, zɨ́yị ógụ kɨ́e zɨ́ma ánu a gɨ ro zɨ́ma íꞌbí úndru zɨ́yị ꞌdáꞌdá zɨ́ma kɨ́ úyumá.” ");
INSERT INTO bdh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Née ní zɨ́ Rebéka úwú ledre ga bɨ Isáka nɨ ndị́sị úku yée zɨ́ wotị́ne Ésawu ní mbá. Sɨmɨ bɨ Ésawu nderé go sɨmɨ súwú gámásóꞌdo bangá úfu a ógụ kɨ́e zɨ́ ꞌbụné ní, ");
INSERT INTO bdh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","zɨ́ Rebéka úku ledre zɨ́ wotị́ne Yakóbo kɨ́dí, “Lúrú aka máúwú gáa do ꞌbụyị́ kɨ́ úku ledre zɨ́ lúnduyị́ Ésawu kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ídí ndéréógụ kɨ́ esị zɨ́ma gɨ sɨmɨ súwú zɨ́yị ꞌdị́ꞌdị a bikinyiné zɨ́ma ánu a gɨ ro zɨ́ma íꞌbí úndru zɨ́yị do komo Ngére Lomo ꞌdáꞌdá zɨ́ma kɨ́ úyumá.’ ");
INSERT INTO bdh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Bɨ ba ní owụ́ ꞌbɨ amáa, ídí úwú ledre ba bɨlámáne zɨ́yị méngị ledre bɨ mááyí úku a zɨ́yị ba. ");
INSERT INTO bdh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ndéré mu do bi bɨ kɨ́ bangá eyị́ e doné ní zɨ́yị ógụyị́ kɨ́ bɨlámá phɨṛangá ína e gbre gɨ ro zɨ́ma ꞌdị́ꞌdị a bikinyiné zɨ́ ꞌbụyị́ ánu a káa zɨ́ bɨ ili ní. ");
INSERT INTO bdh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Zɨ́yị ꞌdíꞌbi a ndéré kɨ́e zɨ́a ánu a gɨ ro zɨ́a íꞌbí úndru ené zɨ́yị ꞌdáꞌdá zɨ́a kɨ́ úyuné.” ");
INSERT INTO bdh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakóbo ya zɨ́ mbágáne Rebéka ní, “Lúndumá Ésawu nɨ yị́ ené oꞌdo bɨ kɨ́ bị roné ní ngárá ꞌbɨ amá bị ndaá romá wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sara togụ́ bɨ babá tatauzu máa, zɨ́a ówo a ya mándá wo wá ní, mándá ídí zɨ́a ꞌyị ṛanga zɨ́a ꞌdíꞌbióyó úndru ené gɨ zɨ́ma zɨ́ taraa nda ólụ́ne ne kacɨ́ma ní wá?” ");
INSERT INTO bdh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Rebéka ya zɨ́a ní, “Owụ́ ꞌbɨ amáa, tara a idí ólụ́ kacɨ́ma. Méngị aka lá ledre bɨ máúku née, zɨ́yị ndéréyị ógụ kɨ́ ína ga gére née zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Née ní zɨ́ Yakóbo ndéréne ógụ kɨ́ye zɨ́ mbágáne. Zɨ́ mbágáa méngị bikinyi éyị́ mɨánu tɨ́ káa zɨ́ bɨ ꞌbụa Isáka ili ní. ");
INSERT INTO bdh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Gɨ ore zɨ́ Rebéka ꞌdíꞌbi bɨlámá bongó kacɨ́ Ésawu, bɨ kóo nɨ zɨ́a ꞌdị́cị́ ní ésị a ro Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Zɨ́a kpá cíṛíngbí saná ína ro kágá sị́lị́ Yakóbo kɨ́ ro goa mbá. ");
INSERT INTO bdh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Zɨ́a íꞌbí bikinyi éyị́ mɨánu bɨ mengị née kɨ́ ambata do sị́lị́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Zɨ́ Yakóbo ꞌdíꞌbi éyị́ mɨánu née ndéré kɨ́e zɨ́ ꞌbụné, zɨ́a ndólo wo kɨ́dí, “Babá.” Zɨ́ ꞌbụ a ndị́zịné do ndúnduꞌyú kɨ́dí, “Née ꞌbɨ ené náambi?” ");
INSERT INTO bdh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Zɨ́ Yakóbo úkulúgu ledre kɨ́dí, “Née máa Ésawu owụ́ndíká eyị́. Máméngị ledre bɨ úku zɨ́ma ní go. Ị́nyịógụ ꞌdága ánu éyị́ mɨánu bɨ máógụ kɨ́e ba gɨ ro zɨ́yị íꞌbí úndru zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Zɨ́ Isáka ndúnduꞌyú kɨ́dí, “Owụ́ ꞌbɨ amáa úfu bangá máa ba lá ꞌdiya káa ní káa be ꞌdi?” Zɨ́ Yakóbo úkulúgu ledre zɨ́ ꞌbụné kɨ́dí, “Ngére Lomo bɨ ndị́sị óto úndrua ní iꞌbíogụne zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Nda née ní zɨ́ Isáka úku ledre zɨ́ Yakóbo kɨ́dí, “Ndósoógụ mu gbóo yána gɨ ro zɨ́ma tátáúzu yị́ị owụ́ ꞌbɨ amáa gɨ ro zɨ́ma ówo a maꞌdíi togụ́ áyí tɨ́ Ésawu yá togụ́ ndá wo wá.” ");
INSERT INTO bdh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Zɨ́ Yakóbo ndósoógụné gbóo ro ꞌbụné. Sɨmɨ bɨ ꞌbụa tatauzu roa ní, zɨ́a úku ledre kɨ́dí, “Sɨmɨ kúrúyị nɨ sɨmɨ kúrú Yakóbo, tɨ́ lá ro kágá sị́lị́yị nɨ kágá sị́lị́ Ésawu.” ");
INSERT INTO bdh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Owo ꞌdíꞌbi Yakóbo wá gɨ zɨ́a ro kágá sị́lị́a nɨ kɨ́ bị roné mbá káa zɨ́ ꞌbɨ Ésawu ní. Née ní zɨ́ Isáka íꞌbí úndru zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Zɨ́a kpá ndúꞌyú ándá nduꞌyú kɨ́dí, “Maꞌdíi áyí tɨ́ owụ́ ꞌbɨ amá bɨ Ésawu ní?” Zɨ́ Yakóbo úkulúgu ledre kɨ́dí, “Née tɨ́ máa.” ");
INSERT INTO bdh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Zɨ́ Isáka úku ledre kɨ́dí, “Owụ́ ꞌbɨ amáa íꞌbíógụ éyị́ mɨánu gɨrí mu zɨ́ma ánu a gɨ ro zɨ́ma íꞌbí úndru zɨ́yị.” Zɨ́ Yakóbo ꞌdíꞌbiógụ éyị́ mɨánu óto a kóꞌdụ́ ꞌbụné zɨ́ ꞌbụa ánu a, do kpá ꞌdíꞌbiógụ leꞌyị́ kóṛó zɨ́a éwé a. ");
INSERT INTO bdh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nda née ní zɨ́ ꞌbụa Isáka úku ledre zɨ́a kɨ́dí, “Ndóso gɨrí mu gbóo zɨ́ma yána owụ́ ꞌbɨ amáa zɨ́yị fáka máa.” ");
INSERT INTO bdh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Zɨ́ Yakóbo ndósoógụné gbóo fáka ꞌbụné. Sɨmɨ bɨ Isáka otụlurú ndonyo bongó ꞌbɨ Ésawu ní, zɨ́ Isáka íꞌbí úndru zɨ́a do úku ledre kɨ́dí, “Maꞌdíi, ba tɨ́ ndonyo owụ́ ꞌbɨ amá, káa zɨ́ ndonyo súwú bɨ kɨ́ úndru ꞌbɨ Ngére Lomo sɨmɨné ní. ");
INSERT INTO bdh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Lomo idí íꞌbí iní gɨ komo ere zɨ́a éꞌdịné do yáká eyị́, gɨ ro zɨ́ kére kɨ́ kágá ga bɨ yáká eyị́ ní ndị́sị ánáye bɨlámáye zɨ́yị nda ídíyị kɨ́ éyị́ mɨánu kɨ́ leꞌyị́ kóṛó kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ṛị́kị́ sị́ do ꞌyịmaꞌdí e mbá idínɨ́ ídí ꞌyị ị́nyị kasa zɨ́yị, zɨ́ye ndị́sịyé ótụ́ doyé bi óto úndruyị́. Zɨ́yị ídíyị ngére do lúnduyị́ e, owụ́ ꞌbɨ mbágáyị e idínɨ́ ndị́sị ótụ́ doyé zɨ́yị. ꞌYị ga bɨ nɨyí óto tarayé kacɨ́yị ní tara Lomo idí ólụ́ kacɨ́ye, yée ga bɨ nɨyí méngị bɨlámá ledre zɨ́yị ní, zɨ́yị kpá méngị bɨlámá ledre zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Sɨmɨ bɨ Isáka iꞌbí asá úndru go zɨ́a, Yakóbo olụ́ogụ okpó go ní, ve zɨ́ lúndua Ésawu ndáꞌbaógụné gɨ do bi gámá. ");
INSERT INTO bdh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Zɨ́a kpá méngị bikinyi éyị́ mɨánu ógụ kɨ́e zɨ́ ꞌbụné. Zɨ́a úku ledre zɨ́ ꞌbụné kɨ́dí, “Babá, ị́nyịógụ mu ánu éyị́ mɨánu gɨ ro zɨ́yị íꞌbí úndru zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Zɨ́ ꞌbụa Isáka ndúꞌyú wo kɨ́dí, “Áyí náambi?” Zɨ́a úkulúgu ledre zɨ́ ꞌbụné kɨ́dí, “Née máa Ésawu owụ́ndíká eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Zɨ́ bi sínyíne ro Isáka zɨ́a ndị́sị lángbané, zɨ́a ndúnduꞌyú kɨ́dí, “Sara ꞌyị bɨ gáa ogụ kɨ́ éyị́ mɨánu zɨ́ma kɨ́ra ꞌbɨ ené náambi? Éyị́ mɨánu bɨ gáa ogụnɨ́ kɨ́e ní máánu go ꞌdáꞌdá gɨ zɨ́yị kɨ́ ógụyị́, máíꞌbí úndru go zɨ́a. Úndru née goó ꞌbɨ ené za fí.” ");
INSERT INTO bdh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sɨmɨ bɨ Ésawu uwú ledre gɨ zɨ́ ꞌbụné kenée ní, zɨ́a útúne íni ini kɨ́ngaya zɨ́a úku ledre zɨ́ ꞌbụné kɨ́dí, “Babá ídí kpá íꞌbí úndru zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tɨ́ lá zɨ́ Isáka úkulúgu ledre zɨ́a kɨ́dí, “Lúnduyị́ ogụ ona lóndo máa ꞌdiꞌbi úndru go.” ");
INSERT INTO bdh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Zɨ́ Ésawu úku ledre kɨ́dí, “Ị́fị́sé ịrịa Yakóbo mbị́. Londo máa go kɨ́ꞌdí gbre. Mɨzefị a londo máa gɨ ro zɨ́ne ídíne owụ́ndíká do bi kacɨ́ma, bɨ ba ní ꞌdiꞌbi úndru amá kpá go.” Zɨ́ Ésawu ndúnduꞌyú kɨ́dí, “Ótoómo eyị́ gáa ngítí úndru maꞌdáa gɨ ro íꞌbí a zɨ́ma wá?” ");
INSERT INTO bdh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Zɨ́ Isáka úkulúgu zɨ́a kɨ́dí, “Owụ́ ꞌbɨ amáa, máíꞌbí úndru go zɨ́a, zɨ́a ídíne ngére dosé. Máóto sụmụ ga go mbá zɨ́ye ndị́sịyé óto úndrua. Máíꞌbí úndru go zɨ́a gɨ ro éyị́ ené ga bɨ yáká ní kpá kɨ́ leꞌyị́ kóṛó. Éyị́ bɨ idíaká gɨ ro zɨ́ma íꞌbí a zɨ́yị ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Zɨ́ Ésawu ṇgúṇgú roné zɨ́ ꞌbụné kɨ́dí, “Úndru nɨ zɨ́yị lá dụụ́ kị́éꞌdo babá? Íꞌbí kpá úndru zɨ́ma ke babá.” Zɨ́ Ésawu kpá útúne íni ini kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Zɨ́ Isáka úku ledre zɨ́a kɨ́dí, “ꞌBe ꞌbɨ eyị́ nɨ ídí sɨmɨ ị́rịgbére kɨ́ꞌdí bɨ fụtụ́ éyị́ e ngborónɨ́ doa zɨ́ sanáye ídíne bɨlámáne wá ní, kpá do bi bɨ ngárá iní eꞌdị doa gɨ komo ere wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Áyí ndị́sị fú lá kɨ́ éyị́ okó do sị́lị́yị zɨ́yị ndị́sịyị́ ị́nyị kasa zɨ́ lúnduyị́. Tɨ́ lá sɨmɨ bɨ áyí ꞌdóꞌdó gɨ zɨ́a ní, áyí ụ́cụóyó ꞌdoꞌdó née gɨ goyị́ ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Zɨ́ Ésawu óto ledre sɨmɨné ro lúnduné Yakóbo gɨ ro úndru bɨ gɨ zɨ́ ꞌbụyé ní. Zɨ́a sómụ́ ledre sɨmɨné kɨ́dí, “Karanée gɨ do kacɨ́ umbu babá, mááyí úfu lúndumá Yakóbo ꞌbúó.” ");
INSERT INTO bdh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Sɨmɨ bɨ Rebéka uwú mɨyéme ledre ꞌbɨ Ésawu née ní, zɨ́a ndólo Yakóbo úku ledre zɨ́a kɨ́dí, “Lúnduyị́ Ésawu yeme roné go gɨ ro úfu yị́ị. ");
INSERT INTO bdh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Bɨ goó kenée ní owụ́ ꞌbɨ amáa ídí méngị ledre bɨ mááyí úku a ba, ídí geré ngásá ꞌbe ꞌbɨ nokoyị́ Labána sɨmɨ Arána. ");
INSERT INTO bdh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ídí ndị́sị íri ꞌbúó togụ́ mɨmbéꞌde lúnduyị́ ịdrị́ go kí. ");
INSERT INTO bdh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Togụ́ okó bɨ mɨmbéꞌdea royị́ née ịdrị́ go somụ́lịgị ledre ga bɨ méngị yée zɨ́a née go yá, mááyí kákasa zɨ́yị nda ndáꞌbaógụyị́ gɨrí. Ndaá mɨútúásáne zɨ́se úyusé zɨ́ma gbrengárá kadra kị́éꞌdo wá.” ");
INSERT INTO bdh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Née ní zɨ́ Rebéka úku ledre zɨ́ Isáka kɨ́dí, “Mááyí kɨ́ mongụ́ lerị́ do mɨmbéꞌdemá gɨ zɨ́ kará ꞌyị lóṇgó ga bɨ Ésawu ofụ́ yée ba. Togụ́ ya zɨ́ Yakóbo kpá ófụ́ kára gɨ ona gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Éte e yá, mɨndị́sịmá utúasá ídí bɨlámáne wá, bɨlámá a máídí úyu ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Née ní zɨ́ Isáka ndóloógụ Yakóbo íꞌbí mandá zɨ́a, zɨ́a úku ledre zɨ́a kɨ́dí, “Ndá ófụ́ kára gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Kanána e wá. ");
INSERT INTO bdh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ị́nyị mu zɨ́yị ndéréyị sɨmɨ Padána Aráma ꞌbe ꞌbɨ bulúnduyị́ Bétụwele. Zɨ́yị ófụ́ kára zɨ́yị gɨ dongará nyị́ nokoyị́ Labána. ");
INSERT INTO bdh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Lomo bɨ kɨ́ rokoꞌbụné kɨ́ngaya ní idí íꞌbí úndru zɨ́yị, zɨ́a óto yị́ị zɨ́yị ndíki tụ́ꞌdụ́ owụ́ e gɨ ro zɨ́yị ídíyị bulúndu ṛị́kị́ sị́ do ꞌyịmaꞌdí e. ");
INSERT INTO bdh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Idí íꞌbí úndru zɨ́yị kɨ́ bulúnduyị́ e za mbá káa zɨ́ bɨ kóo iꞌbí úndru zɨ́ Abarayáma ní, gɨ ro zɨ́yị ꞌdíꞌbi káṇgá bɨ ndị́sị sɨmɨ a káa do ꞌyị lóṇgó ba bɨ kóo iꞌbí zɨ́ Abarayáma ní.” ");
INSERT INTO bdh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Zɨ́ Isáka kása Yakóbo sɨmɨ Padána Aráma ꞌbe ꞌbɨ Labána wotị́ Bétụwele ꞌyị ꞌbɨ Aráma bɨ nɨ lúndu Rebéka mbágá Yakóbo e kɨ́ Ésawu ní. ");
INSERT INTO bdh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Zɨ́ Ésawu ówo a kɨ́dí Isáka iꞌbí úndru go zɨ́ Yakóbo, kasa kpá wo go sɨmɨ Padána Aráma ndéré ófụ́ kára gɨrí. Owo kpá go kɨ́dí sɨmɨ bɨ iꞌbí úndru zɨ́ Yakóbo ní, zɨ́a lórụ wo kɨ́dí, “Ndaá ꞌdíꞌbi kára gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Kanána e wá.” ");
INSERT INTO bdh_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Zɨ́ Ésawu go kpá ówo a kɨ́dí Yakóbo uwú kúrú ꞌbụné kɨ́ mbágáne go zɨ́a ị́nyịné ndéréne sɨmɨ Padána Aráma. ");
INSERT INTO bdh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Née ní ábuwá Ésawu ówo go kɨ́dí ꞌbú nyị́ ꞌyị ꞌbɨ Kanána e ndaá ꞌbɨ ené do ꞌbụné Isáka wá. ");
INSERT INTO bdh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Gɨ zɨ́ kéyị née ní zɨ́ Ésawu ndéréne ꞌbe ꞌbɨ Isɨméle wotị́ Abarayáma. Zɨ́a ófụ́ nyị́a bɨ Maláta lémị Nebayóta ní káa do ngíti kára. ");
INSERT INTO bdh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Zɨ́ Yakóbo ị́nyịné gɨ sɨmɨ Bị́rịsába ꞌdíꞌbi mɨsiꞌdi yóó, ndéréne sɨmɨ Arána. ");
INSERT INTO bdh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Zɨ́a ndéréógụné do ngíti bi, zɨ́a ndị́sịné ꞌdówụ́roné ore gɨ zɨ́a kadra utú go. Zɨ́a ꞌdíꞌbi tutú óto doné gá doa zɨ́a útúne ꞌdúꞌduné. ");
INSERT INTO bdh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Sɨmɨ bɨ nɨ go sɨmɨ ꞌbí ní, zɨ́a ꞌdúꞌduru. Sɨmɨ ꞌduru máa née ní, zɨ́a lúrúndíki mɨsiꞌdi bɨ toko roné kú gɨ do káṇgá zaá gị komo ere, zɨ́ maláyika ga bɨ ꞌbɨ Lomo ní ndị́sịyé ékị́ye kɨ́ ndítíógụyé kacɨ́ mɨsiꞌdi máa née ní. ");
INSERT INTO bdh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Zɨ́a lúrúndíki Ngére Lomo kɨ́ tóroné doné zɨ́a úku ledre kɨ́dí, “Mááyí Ngére Lomo bɨ Abarayáma e kɨ́ Isáka ndịsịnɨ́ óto úndrua ní. Káṇgá bɨ áyí mɨꞌdúꞌduyị́ doa ba mááyí íꞌbí a zɨ́se kɨ́ bulúnduyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bulúnduyị́ e nɨyí karanée étrị zɨ́ye ídíye tụ́ꞌdụ́ tụ́ꞌdụ́ zɨ́se áṇgasé zaá do sogo káṇgá mbá. Ṛị́kị́ sị́ do ꞌyịmaꞌdí do sogo káṇgá mbá mááyí íꞌbí úndru zɨ́ye kpụrụ́ gɨ sɨmɨyị́ kɨ́ bulúnduyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ídí ówo a kɨ́dí, mááyí ídí kɨ́yị zɨ́ma ndị́sịmá bándá yị́ị do bi ga bɨ áyí gámá doyé ní mbá, zɨ́ma ꞌdíꞌbilúgu yị́ị kpá gị sɨmɨ káṇgá bɨ áyí sɨmɨ a ba. Máútúásá ótoómo yị́ị wá ꞌbúó togụ́ mɨyéme ledre bɨ máyéme wo gɨ royị́ ní máméngị go.” ");
INSERT INTO bdh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Sɨmɨ bɨ Yakóbo urú gɨ sɨmɨ ꞌbí ní, zɨ́a úku ledre kɨ́dí, “Ábuwá maꞌdíi Ngére Lomo nɨ bo do bi ba ona, máówo amá kenée wá.” ");
INSERT INTO bdh_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Zɨ́ ngịrị útúne sɨmɨ a zɨ́a úku ledre kɨ́dí, “Bi ba nɨ kɨ́ úndruné, nɨ kpá mɨsiꞌdi bɨ ndịsị ndéré komo ere ní, Lomo nɨ ona.” ");
INSERT INTO bdh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nda go akpa kɨ́ phịyị́, zɨ́ Yakóbo ị́nyịógụné ꞌdíꞌbi tutú bɨ oto doné doa ní ícióto a mbị́ ꞌdága do bi bɨ ꞌduꞌdu doa née. Zɨ́a ꞌdíꞌbi sụꞌbụ́ léfe a doa. ");
INSERT INTO bdh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Née ní zɨ́a ị́fị́ ịrị bi née Bétele, abú bɨ kóo ndịsịnɨ́ ndólo ịrị gara née “Lụ́zụ ní.” ");
INSERT INTO bdh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nda gɨ ore zɨ́ Yakóbo lólóbụ́ zɨ́ Ngére Lomo kɨ́dí, “Togụ́ maꞌdíi áyí tɨ́ lúrú bi kacɨ́ma sɨmɨ ndéré bɨ mááyí ndéré a ba, zɨ́yị ndị́sịyị́ íꞌbí éyị́ mɨánu zɨ́ma kɨ́ bongó e zɨ́ma ésị a, ");
INSERT INTO bdh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","gɨ ro zɨ́ma ndáꞌbalúgu romá zɨ́ babá ꞌbe bɨlámáne yá, née ní áyí ídí Ngére Lomo amá. ");
INSERT INTO bdh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tutú bɨ máícióto ꞌdága ba ní, bi ba nɨ go ógụ ídí bi bɨ nɨyí ndị́sị íni ini zɨ́yị doa ní. Éyị́ ga bɨ áyí ndị́sị íꞌbí yée zɨ́ma ní, mááyí ndị́sị ꞌdíꞌbi kị́éꞌdo gɨ sɨmɨ sokó íꞌbílúgu yée zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Zɨ́ Yakóbo ị́nyịné gɨ ore kpá fú ndéréne, do ndéréógụné sɨmɨ káṇgá bɨ Mesopatómiya káṇgá ꞌbɨ mbágáne. ");
INSERT INTO bdh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Sɨmɨ bɨ nderéogụ do ngíti ꞌdawú ní, zɨ́a lúrúndíki kábịṛị́kị mɨífiyé do bi e ota gbaá dongá ꞌdawú kɨ́ ꞌdúꞌdu gɨ zɨ́a née bi bɨ ndịsịnɨ́ íꞌbí iní mɨéwé zɨ́ye doa ní. Loꞌbụꞌdụtụnɨ́ tara ꞌdawú máa née kɨ́ mongụ́ tutú. ");
INSERT INTO bdh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sɨmɨ bɨ kábịṛị́kị e yokonɨ́ royé go mbá ore ní zɨ́ ꞌyị ꞌbáꞌbá kábịṛị́kị e gbụ́ṛụ́gbụóyó tutú née gɨ tara ꞌdawú née ꞌdáꞌba do ndị́sịyé íꞌbí iní zɨ́ kábịṛị́kị eyé e éwé a. Zɨ́ye ndáꞌbayé gbụ́ṛụ́gbụlúgu tutú née do tara ꞌdawú née. ");
INSERT INTO bdh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Zɨ́ Yakóbo ndúꞌyú ꞌyị ꞌbáꞌbá kábịṛị́kị ga gére née kɨ́dí, “Lúndumá e ógụsé bɨ káa ba gɨ ꞌda?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ogụzé gɨ sɨmɨ Arána.” ");
INSERT INTO bdh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Zɨ́a ndúꞌyú yée kɨ́dí, “Bɨ née ní ówosé Labána owụ́ ꞌbɨ owụ́ ꞌbɨ Nówara bú?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Owozé wo bú.” ");
INSERT INTO bdh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Zɨ́a kpá ndúꞌyú yée, “Éyị́ roa ꞌdi?” Zɨ́ye úku ledre zɨ́a kɨ́dí, “Nɨ bɨlámáne, éyị́ ndaá roa wá. Nyị́a, Rayéle nɨ bɨ ógụ kɨ́ kábịṛị́kị eyé e gɨrí née.” ");
INSERT INTO bdh_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Zɨ́ Yakóbo úku ledre zɨ́ye kɨ́dí, “Lúrúsé aka kadra nɨ aka nyé ꞌdága, ba ndaá aka sịndị́ kadra bɨ zɨ́se yóko kábịṛị́kị e do bi kị́éꞌdo ní wá. Ídísé íꞌbí iní zɨ́ye éwé a, zɨ́se ndáꞌbasé kɨ́ye do bi éyị́ mɨánu.” ");
INSERT INTO bdh_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Zɨ́ye úkulúgu ledre zɨ́ Yakóbo kɨ́dí, “Utúasázé íꞌbí iní zɨ́ kábịṛị́kị e mɨngúngúcua wá, ꞌbúó togụ́ kábịṛị́kị e yokoogụnɨ́ royé go mbá, do gbụ́ṛụ́gbụóyó tutú née gɨ tara ꞌdawú ꞌdáꞌba, azé nda fú íꞌbí iní zɨ́ye ndro.” ");
INSERT INTO bdh_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sɨmɨ bɨ Yakóbo nɨ aka tɨ́ ndị́sị ódro zɨ́ye ní, zɨ́ Rayéle ꞌdéweógụ bi go kɨ́ kábịṛị́kị ꞌbɨ ꞌbụné e gɨ zɨ́a ndịsị ꞌbáꞌbá yée ne. ");
INSERT INTO bdh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sɨmɨ bɨ Yakóbo lurúndiki Rayéle nyị́ nokoné Labána kɨ́ ógụ kɨ́ kábịṛị́kị eyé e ní, zɨ́a ndéréne gbụ́ṛụ́gbụóyó tutú gɨ tara ꞌdawú ꞌdáꞌba, do íngi iní íꞌbí a zɨ́ kábịṛị́kị ꞌbɨ nokoné e éwé a. ");
INSERT INTO bdh_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Zɨ́a útúne fáka Rayéle, zɨ́a tónóne íni ini roa. ");
INSERT INTO bdh_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Zɨ́a úku ledre zɨ́ Rayéle kɨ́dí, née nɨ owụ́ ꞌbɨ lémị Labána bɨ kɨ́ ịrịné Rebéka ní. Née ní geré zɨ́ Rayéle ngásáne ndéré úku ledre a zɨ́ ꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sɨmɨ bɨ Labána uwú ledre Yakóbo nɨ owụ́ ꞌbɨ lémịné ní, geré zɨ́a ị́nyịné ndéréne ꞌdíꞌbi wo do mɨsiꞌdi. Zɨ́ Labána fáka wo íꞌbí mandá zɨ́a kɨ́ ꞌbúne, do ꞌdíꞌbiógụ wo ꞌbe. Zɨ́ Yakóbo lị́kpị́ ledre ga bɨ mengịnɨ́ royé ní mbá zɨ́ Labána. ");
INSERT INTO bdh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Zɨ́ Labána uku ledre zɨ́a kɨ́dí, “Áyí née mbigí a ꞌbɨ amá, lémịmá ndiki yị́ị ne.” Zɨ́ Yakóbo ndị́sịné ore éfé kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Zɨ́ Labána úku ledre zɨ́a kɨ́dí, “Abú áyí mbigí a ꞌbɨ amá, lémịmá ndiki yị́ị ne yá, útúásá ndị́sị méngị moko zɨ́ma lá gbékpị́ a wá, máídí íꞌbí zɨ́yị ndu?” ");
INSERT INTO bdh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labána nɨ kɨ́ nyị́ne e gbre, ịrị nyị́a bɨ mongụ́ ní nɨ Léya, wo bɨ owụ́ ní ịrịa ꞌbɨ ené Rayéle. ");
INSERT INTO bdh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Komo Léya ndaá bɨlámáne wá, zɨ́ Rayéle ídíne owụ́kára bɨ kɨ́ lámá roné kɨ́ngaya do komo ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ꞌBú Rayéle nɨ kóo do Yakóbo kɨ́ngaya, zɨ́a úkulúgu ledre zɨ́ Labána kɨ́dí, “Mááyí méngị moko zɨ́yị kɨ́ sɨmɨbi ịnyị doa gbre gɨ ro zɨ́yị íꞌbí nyị́yị bɨ Rayéle ní zɨ́ma káa do kára.” ");
INSERT INTO bdh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Zɨ́ Labána úkulúgu ledre kɨ́dí, “Nɨ bɨlámáne zɨ́ma íꞌbí wo zɨ́yị gɨ zɨ́ wo bɨ mááyí íꞌbí a zɨ́ ꞌyị lóṇgó ní. Ndị́sị mu ona méngị moko zɨ́ma” ");
INSERT INTO bdh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nda née ní zɨ́ Yakóbo méngị moko kɨ́ sɨmɨbi ịnyị doa gbre gɨ ro Rayéle. Sị́lị́ née kóo zɨ́ Yakóbo lá káa zɨ́ owụ́ sị́lị́ cúkuꞌdée ní gɨ zɨ́a ꞌbú Rayéle ofụ kóo doa go. ");
INSERT INTO bdh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Gɨ ore zɨ́ Yakóbo úku ledre zɨ́ Labána kɨ́dí, “Íꞌbí meꞌbemá mu zɨ́ma. Sɨmɨbi kóo óto zɨ́ma ní utúasá go, máíli go zɨ́a ógụné ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Née ní zɨ́ Labána méngị mongụ́ ayímbi, zɨ́a ndóloyóko ꞌyị e gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tɨ́ lá sɨmɨ ndụlụ máa bɨ kóo née ní, zɨ́ Labána ꞌdíꞌbi yị́ ené nyị́ne bɨ Léya ní íꞌbí a zɨ́ Yakóbo, zɨ́ Yakóbo go ówo wo káa do kára. ");
INSERT INTO bdh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Zɨ́ Labána ꞌdíꞌbi ngúru owụ́kára ꞌyị ꞌbɨ moko ené kɨ́ ịrịné Zílifa íꞌbí a zɨ́ Léya káa do ꞌyị ꞌbɨ moko zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sɨmɨ bɨ bi ará nda go ní, Yakóbo nɨ lúrú bi káa ní, nda yị́ ené go Léya. Zɨ́a ị́nyịné ndéréne úku ledre zɨ́ Labána kɨ́dí, “Méngị nda máa kenée gɨ zɨ́ ꞌdi? Ndaá ꞌbɨ ené bɨ máméngị moko zɨ́yị gɨ ro Rayéle ní wá? Lóndo nda máa gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Zɨ́ Labána úkulúgu ledre kɨ́dí, “Kacɨ́ ondụ́ ꞌbɨ káṇgá ezé ba ona, ofụ́nɨ́ eyé nyị́ ꞌyị bɨ owụ́ ní ꞌdáꞌdá gɨ zɨ́ mongụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mengịonzózé aka ayímbi ꞌbɨ ófụ́ ro máa wo ba mu kí, azé nda fú íꞌbí Rayéle zɨ́yị. Zɨ́yị méngị kpá moko zɨ́ma gɨ roa kɨ́ sɨmɨbi ịnyị doa gbre.” ");
INSERT INTO bdh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Zɨ́ Yakóbo go ṇgúṇgu a. Zɨ́a méngịónzó sị́lị́ ịnyị doa gbre bɨ ꞌbɨ ayímbi ꞌbɨ ófụ́ ro ꞌbɨ Léya ní. Zɨ́ Labána ꞌdíꞌbi nyị́ne bɨ Rayéle ní kpá íꞌbí wo zɨ́ Yakóbo káa do kára. ");
INSERT INTO bdh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Zɨ́ Labána ꞌdíꞌbi ngúru owụ́kára ꞌyị ꞌbɨ moko ené kɨ́ bɨ ịrịné Bíla ní íꞌbí a zɨ́ Rayéle káa ꞌyị ꞌbɨ moko zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Zɨ́ Yakóbo kpá ówo Rayéle káa do kára, tɨ́ lá Yakóbo oto yị́ ené kóo ꞌbú Rayéle kɨ́ngaya rómo do Léya. Zɨ́a íꞌbí roné méngị moko zɨ́ Labána kɨ́ sɨmɨbi ịnyị doa gbre. ");
INSERT INTO bdh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Sɨmɨ bɨ Ngére Lomo lúrú kɨ́dí Yakóbo oto ené ꞌbú Léya kɨ́ngaya wá ní, zɨ́a óto wo ndíki owụ́ e. Zɨ́ Rayéle ídíáká ꞌbɨ ené goó mɨkoto. ");
INSERT INTO bdh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Zɨ́ Léya ídíne kɨ́ sɨmɨné zɨ́a áráne owụ́oꞌdo zɨ́a ị́fị́ ịrịa Rụ́bene. Zɨ́a úku ledre kɨ́dí, “Ledre mengị roné zɨ́ma kenée gɨ zɨ́a Ngére Lomo lurú lerị́ bɨ mááyí kɨ́e ní go. Bɨ ba ní, maꞌdíi oꞌdo ꞌbɨ amá nɨ go ógụ óto ꞌbúma.” ");
INSERT INTO bdh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Zɨ́a kpá ídíne kɨ́ sɨmɨné, zɨ́a áráne kpá owụ́oꞌdo. Zɨ́a úku ledre kɨ́dí, “Ngére Lomo owo go kɨ́dí Yakóbo oto kóo ꞌbúma wá, gɨ zɨ́ kéyị née zɨ́a go kpá íꞌbí ngíti owụ́oꞌdo zɨ́ma.” Née ní zɨ́a ị́fị́ ịrịa Simiyóna. ");
INSERT INTO bdh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Gɨ ore zɨ́a kpá ídíne kɨ́ sɨmɨné, zɨ́a áráne kpá owụ́oꞌdo. Zɨ́a úku ledre kɨ́dí, “Bɨ ba ní, oꞌdo ꞌbɨ amá nɨ ꞌdíꞌbingéṛị máa gɨ zɨ́a mándíki owụ́ yaꞌdá e zɨ́a go ꞌdényé ota.” Zɨ́a ị́fị́ ịrị owụ́ máa née Lévị. ");
INSERT INTO bdh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Zɨ́a kpá ndáꞌba ídíne kɨ́ ngíti sɨmɨné, zɨ́a áráne owụ́oꞌdo. Zɨ́a úku ledre kɨ́dí, “Bɨ ba ní, ili zɨ́ma íꞌbí mbófo éyị́ zɨ́ Ngére Lomo.” Gɨ zɨ́ kéyị née ní zɨ́a ị́fị́ ịrị wo née Zụ́da. Zɨ́a tóroné dụụ́ do owụ́ ga gére née. ");
INSERT INTO bdh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Sɨmɨ bɨ Rayéle owo kɨ́dí née ndiki owụ́ e zɨ́ Yakóbo wá ní, zɨ́a óto ledre sɨmɨné ro lémịné. Zɨ́a úku ledre zɨ́ Yakóbo kɨ́dí, “Máíli kpá ndíki owụ́ e, togụ́ wá nɨ mɨútúásáne zɨ́ma úyumá.” ");
INSERT INTO bdh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Zɨ́ mɨmbéꞌde Yakóbo ésị́ne ro Rayéle, zɨ́a úku ledre kɨ́dí, “Mándá ꞌbɨ amá Lomo zɨ́ma ụ́cụómo yị́ị kɨ́ ndíki owụ́ wá.” ");
INSERT INTO bdh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Zɨ́ Rayéle úkulúgu ledre kɨ́dí, “Owụ́kára ꞌyị ꞌbɨ moko amá Bíla nɨ goó ba zɨ́se ndị́sịsé kéne káa do kára gɨ ro zɨ́a ndíki owụ́ e zɨ́ma, zɨ́ owụ́ máa ga gére née ídíye owụ́ ꞌbɨ amá e.” ");
INSERT INTO bdh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Née ní zɨ́a íꞌbí ꞌyị moko ené Bíla zɨ́ Yakóbo káa do kára. Zɨ́ Yakóbo ndị́sịyé kéne, ");
INSERT INTO bdh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","zɨ́ Bíla ídíne kɨ́ sɨmɨné zɨ́a áráne owụ́oꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Née ní zɨ́ Rayéle úku ledre kɨ́dí, “Lomo uwú ini amá go, ꞌdecịyeme ngbanga amá go zɨ́a íꞌbíógụ owụ́oꞌdo zɨ́ma.” Gɨ zɨ́ kéyị née zɨ́a ị́fị́ ịrịa Dána. ");
INSERT INTO bdh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Zɨ́ Bíla kpá ídíne kɨ́ ngíti sɨmɨné zɨ́a áráne owụ́oꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Zɨ́ Rayéle úku ledre kɨ́dí, “Máóto kóo mɨmbéꞌde sínyí goó ro lémịmá gɨ ro ledre owụ́, bɨ ba ní ꞌyị ꞌbɨ moko amá ndiki owụ́ go zɨ́ma.” Zɨ́a ị́fị́ ịrị owụ́ máa née Nafatáli. ");
INSERT INTO bdh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sɨmɨ bɨ Léya lurú kɨ́dí née ndiki lolụ owụ́ wá ní, zɨ́a ꞌdíꞌbi ꞌyị ꞌbɨ moko ené Zílifa íꞌbí a káa do kára zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zɨ́ Zílifa ꞌyị ꞌbɨ moko ꞌbɨ Léya née ndíki owụ́oꞌdo zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Zɨ́ Léya úku ledre kɨ́dí, “Lomo eme kɨ́ma go.” Zɨ́a ị́fị́ ịrị owụ́ née Gáda. ");
INSERT INTO bdh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zɨ́ Zílifa ꞌyị ꞌbɨ moko ꞌbɨ Léya née kpá ndíki ngíti owụ́oꞌdo zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Zɨ́ Léya úku ledre kɨ́dí, “Mɨmbéꞌdemá ịdrị́ go. Lafúma e kará e nɨyí ndólo máa kára ꞌyị ꞌbɨ rokinyi.” Zɨ́a ị́fị́ ịrị owụ́ máa née Aséra. ");
INSERT INTO bdh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nda go sɨmɨ sịndị́ kadra ꞌbɨ ꞌdóꞌdụ́ógụ éyị́ gɨ yáká, zɨ́ Rụ́bene ndéréne ndíki kágá bɨ ndịsịnɨ́ ndólo a madaráka ní sɨmɨ súwú, zɨ́a ꞌdécị mɨsúrú a ógụ kɨ́e zɨ́ mbágáne Léya. Rayéle ya zɨ́ Léya ní, “Ụ́nzụ aka mɨsúrú madaráka bɨ wotị́ ogụ kɨ́e née zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Zɨ́ Léya úku ledre zɨ́a kɨ́dí, “Oꞌdo ꞌbɨ amá bɨ ꞌdíꞌbi wo née asá aka fú lá wá? Íli ba kpá ꞌdíꞌbi mɨsúrú madaráka ꞌbɨ wotị́ma drú doa?” Zɨ́ Rayéle úkulúgu ledre zɨ́ Léya kɨ́dí, “Bɨlámáne, íꞌbí mu zɨ́ma gɨ ro zɨ́yị ꞌdúꞌduyị́ karaba sogo Yakóbo do bi kulú mɨsúrú madaráka ꞌbɨ wotị́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nda sɨmɨ bɨ Yakóbo ndaꞌbaogụ gɨ yáká kɨ́ tagá ní, zɨ́ Léya ndéréne úku ledre zɨ́a kɨ́dí, “Karaba mááyí ꞌdúꞌdu sogoyị́ gɨ zɨ́a máíꞌbí mɨsúrú madaráka ꞌbɨ wotị́ma go zɨ́ Rayéle.” Sɨmɨ ndụlụ a née ní, zɨ́ Léya ꞌdúꞌduné sogo Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Zɨ́ Lomo úwú ini ꞌbɨ Léya, zɨ́a ídíne kɨ́ sɨmɨné zɨ́a ndíki ịnyị owụ́oꞌdo zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Zɨ́ Léya úku ledre kɨ́dí, “Lomo méngị bɨlámá ledre go zɨ́ma, gɨ zɨ́a máíꞌbí ꞌyị ꞌbɨ moko amá zɨ́ oꞌdo ꞌbɨ amá káa do kára.” Zɨ́a ị́fị́ ịrị owụ́ née Isakára. ");
INSERT INTO bdh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Née ní zɨ́ Léya kpá ídíne kɨ́ sɨmɨné zɨ́a ndíki ịnyị doa kéṛị́ owụ́oꞌdo zɨ́ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Zɨ́ Léya úku ledre kɨ́dí, “Lomo iꞌbí mongụ́ tákpásị́lị́ go zɨ́ma. Bɨ ba ní oꞌdo ꞌbɨ amá nɨ go óto úndrumá kɨ́ngaya gɨ zɨ́a mándíki owụ́ yaꞌdá e go zɨ́a ịnyị doa kéṛị́.” Zɨ́a ị́fị́ ịrị owụ́ máa wo née Zebụlụ́na. ");
INSERT INTO bdh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nda gɨ ꞌdáꞌba zɨ́a ndíki owụ́kára, do ị́fị́ ịrị a Dína. ");
INSERT INTO bdh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Née ní zɨ́ Lomo sómụ́ndíki ledre Rayéle, zɨ́a úwú ledre ené do líkpí mɨsiꞌdi ꞌbɨ ndíki owụ́ zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Zɨ́ Rayéle ídíne kɨ́ sɨmɨné zɨ́a ndíki owụ́oꞌdo, zɨ́a úku ledre kɨ́dí, “Lomo ꞌdiꞌbioyó lerị́ gɨ do mɨmbéꞌdemá go.” ");
INSERT INTO bdh_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Zɨ́a ị́fị́ ịrị a owụ́ máa née Yoséfa. Zɨ́a úku ledre kɨ́dí, “Ngére Lomo idí kpá íꞌbí ngíti owụ́oꞌdo zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Gɨ do kacɨ́ bɨ Rayéle ndiki Yoséfa ní, zɨ́ Yakóbo úku ledre zɨ́ Labána kɨ́dí, “Ídí mu ṇgúṇgu a zɨ́ma ndáꞌbalúgu romá sɨmɨ káṇgá amá. ");
INSERT INTO bdh_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Zɨ́yị íꞌbí meꞌbemá e kɨ́ owụ́ ꞌbɨ amá ga bɨ máméngị moko gɨ royé zɨ́yị ní zɨ́ma, zɨ́yị íꞌbí mɨsiꞌdi zɨ́ma ndéréma gɨ zɨ́a ówo moko bɨ máméngị zɨ́yị ní go mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tɨ́ lá zɨ́ Labána úkulúgu ledre zɨ́a kɨ́dí, “Togụ́ nɨ útúásá kacɨ́ komoyị́ yá, máṇgúṇgú romá zɨ́yị ndá ndéré wá. Lomo ꞌdodo go zɨ́ma kɨ́dí úndru bɨ Ngére Lomo iꞌbí zɨ́ma ba ní nɨ gɨ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Zɨ́a kpá úku ngíti ledre zɨ́ Yakóbo kɨ́dí, “Ídí ólo éyị́ ga bɨ íli yée kacɨ́ moko bɨ méngị ní mbá, mááyí íꞌbí yée zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Ówo moko bɨ máméngị zɨ́yị ní bú bɨlámáne, zɨ́ma lúrú bi kacɨ́ bangá eyị́ e zɨ́ye étrịyé kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sɨmɨ bɨ kóo máógụ ní, éyị́ nɨyí kóo zɨ́yị lá cúkuꞌdée. Bɨ nda ba ní, éyị́ etrịnɨ́ zɨ́yị go kɨ́ngaya rómo do rómó. Ngére Lomo iꞌbí úndru go zɨ́yị, do bi ga bɨ za mbá mágámá doyé ní. Tɨ́ lá bɨ ba ní sịndị́ kadra ogụ go zɨ́ma gɨ ro zɨ́ma tónóma lúrú bi kacɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ amá e.” ");
INSERT INTO bdh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Zɨ́ Labána úkulúgu ledre zɨ́ Yakóbo kɨ́dí, “Máídí íꞌbí zɨ́yị ꞌdi?” Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Ndá aka íꞌbí éyị́ zɨ́ma wá. Tɨ́ lá togụ́ áyí ṇgúṇgu yá, mááyí útúásá ndáꞌba lúrú bi kacɨ́ bangá eyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ídí ṇgúṇgu a zɨ́ma gámáma dongará bangá eyị́ e za mbá, kábịṛị́kị e kɨ́ ína e, yée ga bɨ kɨ́ ṛị́kị́ tífí e royé mɨngúngúcua, téte téte, kpákpa kpákpa, dódórụ togụ́ mbú bụkụlụyé ní mbá zɨ́ma ꞌdíꞌbi yée káa do tákpásị́lị́ kacɨ́ moko bɨ máméngị zɨ́yị ní. ");
INSERT INTO bdh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Togụ́ méngị go kenée, máútúásá lóndo yị́ị sɨmɨ bɨ áyí ógụ lúrúsóꞌdo bangá eyị́ e dongará tákpásị́lị́ bɨ íꞌbí zɨ́ma kacɨ́ moko amá ní wá. Ína bɨ togụ́ tífí ndaá roa téte téte togụ́ kpákpa kpákpa wá togụ́ mbú owụ́ kábịṛị́kị ga bɨ royé ndaá bụkụlụné wá ní, áyí ówo a kɨ́dí máúgu yée née goó mɨúgu.” ");
INSERT INTO bdh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Zɨ́ Labána úkulúgu ledre kɨ́dí, “Bɨlámáne idí mu káa zɨ́ bɨ úku née.” ");
INSERT INTO bdh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sɨmɨ sị́lị́ máa bɨ kóo née ní, zɨ́ Labána ífi sɨmɨ bangá ené e, kábịṛị́kị e kɨ́ ína e yée ga bɨ kɨ́ ṛị́kị́ tífí e royé mɨngúngúcua, téte téte, kpákpa kpákpa, dódórụ, bụkụlụyé ní mbá, zɨ́a íꞌbí yée zɨ́ wotị́ne ndị́sị lúrú bi kacɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Zɨ́a ꞌdíꞌbi bangá ga gére ndéré kɨ́ye do bi bɨ nɨ ꞌdíꞌbi ꞌyị sị́lị́ ota gɨ do bi bɨ Yakóbo nɨ doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Zɨ́ Yakóbo lágáógụ sị́lị́ kágá e ota káa do ngbángbá, zɨ́a lị́lị́ royé kpákpa kpákpa. Zɨ́a ófoóyó wo bɨ lịlị́ ní gɨ ro zɨ́ bɨkenyị́ cóngó a bɨ ꞌdí sɨmɨ née ídíne sága, do ótoómo bi bɨ lịlị́ wá ní kenée gɨ ro zɨ́ye ídíye kɨ́ tífíye. ");
INSERT INTO bdh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Zɨ́a óto ngbángbá ga gére née do bi bɨ bangá e ndịsịnɨ́ éwé iní doa ní, gɨ ro zɨ́a ídíne mbị́ kóꞌdụ́ bangá ga gére sɨmɨ bɨ nɨyí ógụ éwé iní ní. Sɨmɨ bɨ bangá ga gére nɨyí go ꞌbéꞌbe royé, ogụnɨ́ go éwé iní ní, ");
INSERT INTO bdh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","zɨ́ yaꞌdáye ndịsị léꞌbéye do karáye kóꞌdụ́ sị́lị́ kágá ga gére née. Zɨ́ye ndị́sịyé ndíki owụ́ e kɨ́ tífí royé téte téte ngíti géyị kpákpa kpákpa. ");
INSERT INTO bdh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Zɨ́ Yakóbo óto mɨnzéré kábịṛị́kị ga gére zɨ́ye ídíye do bi eyé kpị́, tɨ́ lá zɨ́a óto ngítí bangá ga gére née ndị́sị lúrú bangá ꞌbɨ Labána ga bɨ kɨ́ tífí royé téte téte togụ́ mbú bụkụlụyé ní. Zɨ́a yéme bi kpị́ zɨ́ bangá ené e, oto kotrụ yée kɨ́ ꞌbɨ Labána wá. ");
INSERT INTO bdh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tɨ́ lá kɨ́ꞌdí bɨ mɨngburoko bangá ga gére née ogụnɨ́ go éwé iní ní, zɨ́ Yakóbo óto ngbángbá née kóꞌdụ́ye do bi bɨ ndị́sịnɨ́ éwé iní doa gɨ ro zɨ́ye ndị́sị ꞌbéꞌbe royé cigí a, ");
INSERT INTO bdh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","tɨ́ lá bangá máa yée ga bɨ rógbóye rokoꞌbụyé ndaá ní, Yakóbo oto ené ngbángbá née kóꞌdụ́ye wá. Gɨ ore zɨ́ bangá ga bɨ rógbóye rokoꞌbụyé ndaá ní ídíye go mbá ꞌbɨ Labána, yée ga bɨ kɨ́ rokoꞌbụyé ní mbá ꞌbɨ Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Née mɨsiꞌdi bɨ oto Yakóbo ídíne kɨ́ tụ́ꞌdụ́ éyị́ zɨ́ne ní. Nɨ nda goó ꞌyị bɨ kɨ́ tụ́ꞌdụ́ bangá e zɨ́ne kpá kɨ́ tụ́ꞌdụ́ ꞌyị ꞌbɨ moko e yaꞌdá e kɨ́ kará e, kpá kɨ́ gémele e kɨ́ dongí e ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Zɨ́ Yakóbo úwú ledre kɨ́dí wotị́ Labána e ndịsịnɨ́ úku ledre kɨ́dí, “Yakóbo ꞌdiꞌbi éyị́ ꞌbɨ ꞌbụzé go mbá káa do ꞌbɨ ené. Tụ́ꞌdụ́ éyị́ ga bɨ zɨ́ Yakóbo née gɨ sɨmɨ éyị́ ꞌbɨ ꞌbụzé.” ");
INSERT INTO bdh_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Zɨ́ Yakóbo ówo a kɨ́dí toso ndị́sị ꞌbɨ Labána ndaá ꞌbɨ ené lolụ kɨ́ne bɨlámáne káa zɨ́ bɨ kóna ní wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nda née ní zɨ́ Ngére Lomo úku ledre zɨ́ Yakóbo kɨ́dí, “Ndáꞌbalúgu royị́ mu sɨmɨ káṇgá ꞌbɨ ꞌbụyị́ e kɨ́ sụmụyị́ e, Mááyí lúrú bi kacɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gɨ ore née ní zɨ́ Yakóbo kákasa zɨ́ Rayéle e kɨ́ Léya idínɨ́ ógụndíki née sɨmɨ súwú do bi bɨ bangá ené nɨyí doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Málúrú ndị́sị ꞌbɨ ꞌbụsé ndaá ꞌbɨ ené lolụ kɨ́ma bɨlámáne káa zɨ́ bɨ kóo ꞌdáꞌdá ní wá, tɨ́ lá Lomo bɨ ndịsị lúrú bi kacɨ́ babá nɨ bo kɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ówosé bú kɨ́dí máméngị moko zɨ́ ꞌbụsé kɨ́ rokoꞌbụmá mbá, ");
INSERT INTO bdh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","tɨ́ sɨmɨ ledre née ní zɨ́ ꞌbụsé ndị́sịné méngị láráma do óyólóꞌbó toso tákpásị́lị́ bɨ nɨ íꞌbí a zɨ́ma kacɨ́ moko amá ní kɨ́ꞌdí sokó. Tɨ́ lá Lomo ili ené gɨ ro zɨ́a méngị máa bɨsinyíne wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Togụ́ Labána uku ledre go kɨ́dí, ‘Ína máa yée ga bɨ nɨyí árá yée kɨ́ sanáye téte téte nɨyí ídí tákpásị́lị́ kacɨ́ moko eyị́,’ owụ́ ína ga bɨ ína e nɨyí árá yée ní nɨyí ídí mbá kɨ́ sanáye téte téte. Togụ́ uku kɨ́dí, ‘Yée ga bɨ kɨ́ sanáye kpákpa kpákpa nɨyí ídí tákpásị́lị́ kacɨ́ moko eyị́,’ owụ́ ína ga bɨ nɨyí árá yée ní nɨyí ídí mbá kɨ́ sanáye kpákpa kpákpa. ");
INSERT INTO bdh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Lomo ꞌdiꞌbioyó bangá gɨ zɨ́ ꞌbụsé go ꞌdáꞌba zɨ́a íꞌbí yée zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Sɨmɨ sịndị́ kadra bɨ bangá e ndịsịnɨ́ ꞌbéꞌbe royé ní, zɨ́ma ꞌdúꞌduru kɨ́dí yaꞌdá ína ga bɨ ndịsịnɨ́ léꞌbé do karáye ní yị́ ené dụụ́ yée ga bɨ kɨ́ sanáye téte téte, kpákpa kpákpa nda kɨ́ yée ga bɨ mɨdódórụyé ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Zɨ́ maláyika ꞌbɨ Ngére Lomo úku ledre zɨ́ma sɨmɨ ꞌduru kɨ́dí, ‘Yakóbo.’ Zɨ́ma ndị́zịmá kɨ́dí ‘Ɨɨ́ Ngére.’ ");
INSERT INTO bdh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Zɨ́a úku tátá ledre kɨ́dí, ‘Lúrú aka, yaꞌdá ína ga bɨ ndịsịnɨ́ léꞌbé do karáye ní, yị́ eyé dụụ́ yée ga bɨ kɨ́ sanáye téte téte, kpákpa kpákpa nda kɨ́ yée ga bɨ dódórụ ní. Máméngị ledre née zɨ́a méngị roné kenée gɨ zɨ́a máówo éyị́ bɨ Labána mengị kɨ́yị née go. ");
INSERT INTO bdh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mááyí Lomo bɨ ndịsị lúrú bi kacɨ́ ꞌyị ꞌbɨ Bétele, kɨ́ꞌdí bɨ léfe sụꞌbụ́ do tutú zɨ́yị kɨ́ mócụ́ éyị́ zɨ́ma ní. Cakaba ní ị́nyị mu zɨ́yị ndáꞌbalúgu royị́ do bi bɨ aránɨ́ yị́ị doa ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Zɨ́ Rayéle e kɨ́ Léya úkulúgu ledre zɨ́ Yakóbo kɨ́dí, “Éyị́ nɨ bo bɨ ídíáká zɨ́ze ífi a dongaráze káa do éyị́ kacɨ́ ꞌbụzé ní? ");
INSERT INTO bdh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ndịsị méngị láráze káa zɨ́ ꞌyị lóṇgó e ní gɨ zɨ́ ꞌdi? Ugúoyó ené lá dụụ́ zée ꞌdáꞌba wá, késị́ bɨ iꞌbínɨ́ kacɨ́ze ní sinyionzó go za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Maꞌdíi tụ́ꞌdụ́ éyị́ ga bɨ Lomo ꞌdiꞌbioyó yée gɨ zɨ́ ꞌbụzé née ní yị́ ené éyị́ ezé e kɨ́ owụ́ ꞌbɨ ezé e. Bɨ kenée ní méngị lá ledre bɨ Lomo uku zɨ́yị ní.” ");
INSERT INTO bdh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Zɨ́ Yakóbo óto owụ́ ꞌbɨ ené e kɨ́ meꞌbené e mbá do gémele e, ");
INSERT INTO bdh_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","zɨ́a ócó bangá ené e mbá ꞌdáꞌdá kɨ́ éyị́ ga bɨ ndiki yée sɨmɨ Padána Aráma ní mbá ndáꞌbané kɨ́ye zɨ́ ꞌbụné Isáka sɨmɨ káṇgá bɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Sɨmɨ bɨ Labána ndéré ólo bị kábịṛị́kị ené ní, gɨ do kacɨ́ a née ní zɨ́ Rayéle úgu lomo ꞌbɨ ꞌbụné ga bɨ ꞌbe ore ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ábuwá Yakóbo londo yị́ ené lá Labána ꞌyị ꞌbɨ Aráma káa bɨ nɨ ówo a kɨ́dí née nɨ go ngásáókpó ené. ");
INSERT INTO bdh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Zɨ́a ꞌdíꞌbi éyị́ ené e mbá do ndéréókpóne. Zɨ́a ꞌdógụ ngbuṛu bɨ Efaráta ní, zɨ́a ꞌdíꞌbi mɨsiꞌdi ndéré ꞌdị́yị roné do bi ekị́ekị́ bɨ sɨmɨ káṇgá bɨ Gịlị́dị ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Sɨmɨ sị́lị́ ota do úku ledre zɨ́ Labána kɨ́dí Yakóbo ngasáokpó go. ");
INSERT INTO bdh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Zɨ́ Labána ꞌdíꞌbi ꞌyị ené e, zɨ́ye ógólódụ́ Yakóbo kɨ́ sị́lị́ ịnyị doa gbre do ógụndíki wo do bi ekị́ekị́ bɨ sɨmɨ káṇgá bɨ Gịlị́dị ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kɨ́ ndụlụ a née, zɨ́ Lomo ꞌdódo roné zɨ́ Labána ꞌyị ꞌbɨ Aráma sɨmɨ ꞌduru do úku ledre zɨ́a kɨ́dí, “Ídí bándá royị́, ndaá úku bɨsinyí ledre togụ́ mbú mócụ́ éyị́ zɨ́ Yakóbo cúkuꞌdée wá.” ");
INSERT INTO bdh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakóbo oto kóo táya ené do bi ekị́ekị́ bɨ sɨmɨ káṇgá bɨ Gịlị́dị ní. Sɨmɨ bɨ Labána kɨ́ sụmụné e ogụndikinɨ́ wo ní, zɨ́ye óto ꞌbɨ eyé táya kpá ore. ");
INSERT INTO bdh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Zɨ́ Labána úku ledre zɨ́ Yakóbo kɨ́dí, “Éyị́ bɨ lóndo máa zɨ́yị ngásáókpóyị kɨ́ nyị́ma e káa zɨ́ kará ga bɨ ꞌdiꞌbinɨ́ yée sɨmɨ okó ní gɨ roa ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Éyị́ bɨ úgu royị́ gɨ zɨ́a zɨ́yị ngásáókpóyị úku ꞌdódo zɨ́ma gɨ zɨ́a wá ní ꞌdi? Togụ́ úku ꞌdódo kóo zɨ́ma ní, mááyí kóo óto ayímbi gɨ rosé zɨ́ze léꞌbé keꞌbị kɨ́ ụ́cụ kụꞌdụ́ zɨ́ma íꞌbí mɨsiꞌdi zɨ́se kɨ́ rokinyi do mɨmbéꞌdemá. ");
INSERT INTO bdh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Lúrú aka máúdru gbawá súrú mɨmbéꞌde bulúndumá e kɨ́ nyị́ma e íꞌbí mandá zɨ́ye. Méngị née bɨcayi ledre. ");
INSERT INTO bdh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mááyí kɨ́ rokoꞌbụ zɨ́ma gɨ ro zɨ́ma méngị bɨsinyí ledre kɨ́yị, tɨ́ lá kɨ́ ndụlụna Lomo bɨ ndịsị lúrú bi kacɨ́ ꞌbụyị́ e ní mada máa kɨ́dí, ‘Mándá úku bɨsinyí ledre togụ́ mbú ésị ngịrị sɨmɨyị́ gbawá cúkuꞌdée.’ ");
INSERT INTO bdh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Máówo bú kɨ́dí ndáꞌbalúgu royị́ gɨ zɨ́a ꞌbú ꞌbe ꞌbɨ esé ofụ doyị́ go. Tɨ́ lá éyị́ bɨ úgu lomo amá e gɨ roa ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Zɨ́ Yakóbo úkulúgu ledre zɨ́ Labána kɨ́dí, “Ngịrị mengị máa née, gɨ zɨ́a másómụ́ ꞌbɨ amá kɨ́dí áyí ꞌdíꞌbióyó nyị́yị e gɨ zɨ́ma kɨ́ cóngóro. ");
INSERT INTO bdh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tɨ́ lá togụ́ ówo ꞌyị go kɨ́ra kɨ́ lomo eyị́ e zɨ́ne yá, idínɨ́ úfuóyó wo ꞌdáꞌba. Do komo ꞌyị ezé e kɨ́ra ní. Ídí mu gámásóꞌdo éyị́ eyị́ e dongará éyị́ amá e, togụ́ ówo go zɨ́yị ꞌdíꞌbi a.” Yakóbo owo ené bɨ kɨ́dí Rayéle ugu lomo ga bɨ ꞌbɨ Labána ní go wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Zɨ́ Labána ndéréne gámásóꞌdo bi sɨmɨ kụ́tụ́ ꞌbɨ Yakóbo, zɨ́a ndéréne sɨmɨ kụ́tụ́ ꞌbɨ Léya, nda gɨ ore sɨmɨ kụ́tụ́ ꞌbɨ kará ga bɨ kóo gbre owụ́kụlụ́ e ní, ndiki lomo ené e wá. Nda née ní zɨ́a ndéréne sɨmɨ kụ́tụ́ ꞌbɨ Rayéle. ");
INSERT INTO bdh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ábuwá Rayéle ꞌdiꞌbi lomo ga gére née go do óto yée sị́ bindị́sị bɨ do gémele ené ní zɨ́a ndị́sịné doyé. Zɨ́ Labána gámáne sɨmɨ éyị́ ga bɨ sɨmɨ kụ́tụ́ ore ní mbá owo kémbị́ éyị́ wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Zɨ́ Rayéle úku ledre zɨ́ ꞌbụné, “Mɨmbéꞌdeyị́ nda ésị́ wá, mongụ́ ꞌyị, tɨ́ lá máútúásá tóro ꞌdága do komoyị́ wá, mááyí kɨ́ ndíyá ezé ꞌbɨ kará e romá.” Zɨ́ Labána gámáne má ndiki lomo ené e wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Zɨ́ mɨmbéꞌde Yakóbo ésị́ne. Zɨ́a ndúꞌyú Labána kɨ́ mɨmbéꞌdekesị́ kɨ́dí, “Éyị́ bɨ máméngị zɨ́yị bɨsinyíne ní ꞌdi? Lorụ bɨ máꞌdéwe wo, bɨ zɨ́yị ndị́sịyị́ ógólódụ́ kacɨ́ma gɨ roa kenée wo be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bɨ gɨ́rágá báyi sɨmɨ éyị́ amá e go mbá ní, éyị́ eyị́ bɨ ndíki dongará éyị́ amá e ní go ꞌdi? Óto mu gɨ ꞌdáa kóꞌdụ́ sụmụyị́ e kɨ́ sụmụmá e ona, gɨ ro do ꞌdécị ngbanga dongaráze kéyị. ");
INSERT INTO bdh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ndịsịzé kéyị go kɨ́ sɨmɨbi cị́ kéṛị́ a. Kábịṛị́kị e kɨ́ ína eyị́ e ndịsịnɨ́ ndíki owụ́ e kacɨ́ kadra mbá bɨlámáye, máúfu gbawá yaꞌdá kábịṛị́kị e gɨ sɨmɨ bangá eyị́ e zɨ́ma ánu a. ");
INSERT INTO bdh_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Abú bangá sinyi ꞌdiꞌbi bangá eyị́ e yá, máị́mbị́ógụ umbuyé ꞌdódo a zɨ́yị kɨ́dí née ndaá ꞌbɨ ené luyú amá wá ní wá. Bangá ga bɨ ndịsịnɨ́ ị́ndrị née zɨ́ ngị́rị́ye ídíne domá. Zɨ́yị ndị́sịyị́ úku ledre zɨ́ma ndị́sị íꞌbílúgu kulú bangá eyị́ ga bɨ togụ́ ugunɨ́ yée go kɨ́ kadra togụ́ mbú kɨ́ ndụlụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mɨndị́sịmá nɨ kóo káa zɨ́ ba, kɨ́ kadra, phoꞌdụ kadra nɨ ndị́sị óngbó máa. Nɨ ógụ kɨ́ ndụlụ ní zɨ́ drụ́ ólụ́ne sɨmɨmá ꞌbí ꞌdiꞌbi gbawá komomá. ");
INSERT INTO bdh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sɨmɨbi cị́ kéṛị́ a mááyí mɨndị́sịmá zɨ́yị ꞌbe. Zɨ́ma méngị moko zɨ́yị kɨ́ sɨmɨbi sokó doa eso gɨ ro ófụ́ nyị́yị ga bɨ gbre née, zɨ́ma méngị ngíti moko zɨ́yị kɨ́ sɨmɨbi ịnyị doa kị́éꞌdo gɨ ro úgú bangá e kɨ́e gɨ zɨ́yị. Sɨmɨ ledre ga gére née ní, zɨ́yị ndị́sịyị́ óyólóꞌbó toso tákpásị́lị́ bɨ do íꞌbí a zɨ́ma kacɨ́ moko bɨ máméngị ní gbụ́ gbụ́ kɨ́ꞌdí tụ́ꞌdụ́. ");
INSERT INTO bdh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Togụ́ Lomo bɨ ndịsị lúrú bi kacɨ́ babá, Lomo bɨ ndịsị lúrú bi kacɨ́ Abarayáma e kɨ́ Isáka ndaá ídí kɨ́ma wá, káa bɨ maꞌdíi ógóóyó máa go ꞌdáꞌba kɨ́ sị́lị́ma sokó. Tɨ́ lá Lomo lurú ꞌdoꞌdó amá kɨ́ moko bɨ máméngị wo ní zɨ́a ị́nyịné máda yị́ị kɨ́ ndụlụna.” ");
INSERT INTO bdh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Zɨ́ Labána úkulúgu ledre zɨ́ Yakóbo kɨ́dí, “Kará ga gére née nɨyí nyị́ma e, owụ́ ꞌbɨ eyé ga gére née owụ́ ꞌbɨ amá e kɨ́ bangá ga gére née mbá. Éyị́ ga bɨ lúrú yée née mbá éyị́ amá e. Bɨ kenée ní éyị́ bɨ mááyí méngị a karaba gɨ ro nyị́ma e kɨ́ owụ́ ꞌbɨ eyé e ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ógụ mu zɨ́ze yéme ledre dongaráze kéyị. Idízé ụ́ṛụ́ tutú e kɨ́ra gɨ ro zɨ́ze ndị́sị sómụ́ndíki ledre mɨyéme ledre née gɨ roa.” ");
INSERT INTO bdh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Née ní zɨ́ Yakóbo ꞌdíꞌbi mongụ́ tutú do ícióto a cị́ ꞌdága káa do dosị́ a. ");
INSERT INTO bdh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Zɨ́a úku ledre zɨ́ sụmụné e, “ꞌDóꞌdụ́ yókosé tutú e.” Née ní zɨ́ sụmụga ꞌdóꞌdụ́yóko tutú e do ụ́ṛụ́ a ngị. Zɨ́ye ndị́sịyé cigí mɨụ́ṛụ́ tutú ba ánu éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Zɨ́ Labána ị́fị́ ịrị bi máa née Zɨgárá Sadụ́sa, zɨ́ Yakóbo ị́fị́ ꞌbɨ ené yaá Gịlị́dị. ");
INSERT INTO bdh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Zɨ́ Labána úku ledre kɨ́dí, “Karaba ní tutú bɨ ụṛụ́zé ba nɨ go éyị́ bɨ nɨ óto zée zɨ́ze ndị́sịzé sómụ́ndíki mɨyéme ledre bɨ dongaráze kéyị ní.” Née sị́ ledre bɨ ndolonɨ́ ịrị bi née Gịlị́dị gɨ zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ndị́sịnɨ́ kpá ndólo bi née Mizị́pa, gɨ zɨ́a Labána uku ledre kɨ́dí, “Ngére Lomo idí lúrú bi dozé sɨmɨ bɨ ndazé do bɨkéṛị́ a kéyị wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Togụ́ méngị lárá nyị́ma ga gére, togụ́ ꞌdíꞌbi mbú ngíti géyị kará e, abú ngíti ꞌyị ukuꞌdodo zɨ́ma wá, ídí ówo a kɨ́dí Lomo owo ledre née bɨ dongaráze kéyị ní go.” ");
INSERT INTO bdh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Zɨ́ Labána kpá úku ngíti ledre zɨ́ Yakóbo kɨ́dí, “Mɨụ́ṛụ́ tutú nɨ go ba kɨ́ mongụ́ tutú bɨ otozé wo dongaráze kéyị ní. ");
INSERT INTO bdh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tutú bɨ ụṛụ́zé kɨ́ mongụ́ tutú née nɨ ndị́sị óto zée zɨ́ze ndị́sị sómụ́ndíki a kɨ́dí, máútúásá ókpóómo tutú ga gére née ndéré méngị bɨsinyí ledre kɨ́yị wá, útúásá kpá ókpóómo a zɨ́yị ndéréyị méngị bɨsinyí ledre kɨ́ma wá. ");
INSERT INTO bdh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Lomo bɨ ndịsị lúrú bi kacɨ́ Abarayáma, Lomo bɨ ndịsị lúrú bi kacɨ́ Nówara e kɨ́ Lomo bɨ ndịsị lúrú bi kacɨ́ ꞌbụyé e ní nɨ ꞌdécị ngbanga née ne dongaráze.” Zɨ́ Yakóbo lólóbụ́ kɨ́ ịrị Lomo bɨ ꞌbụa Isáka ndịsị óto úndrua kɨ́dí née nɨ lódụ́ kacɨ́ mɨyéme ledre née. ");
INSERT INTO bdh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Zɨ́ Yakóbo ꞌdáná éyị́ do bi ekị́ekị́ bɨ sɨmɨ káṇgá bɨ Gịlị́dị ní, do ndólo sụmụné e zɨ́ye ánu éyị́ kéye. Gɨ do kacɨ́ éyị́ mɨánu zɨ́ye ꞌdúꞌduyé cịkị ore. ");
INSERT INTO bdh_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Akpa kɨ́ phịyị́ a née, zɨ́ Labána fáka nyị́ne e kɨ́ bulúnduné e zɨ́a údru súrú mɨmbéꞌdeyé za mbá. Zɨ́a ị́nyịné ndáꞌbalúgu roné ꞌbe ꞌbɨ ené. ");
INSERT INTO bdh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Gɨ do kacɨ́ née ní, Yakóbo nɨ mɨndéréne do mɨsiꞌdi, zɨ́ maláyika ga bɨ ꞌbɨ Lomo ní ꞌdódo royé zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sɨmɨ bɨ Yakóbo lurúndiki yée ní, zɨ́a úku ledre kɨ́dí, “Ba táya ꞌbɨ Lomo.” Née ní zɨ́a ị́nyịné ị́fị́ ịrị bi née Manayíma. ");
INSERT INTO bdh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Zɨ́ Yakóbo ị́nyịné kása ꞌyị kasa ené e ꞌdáꞌdá zɨ́ lúnduné Ésawu sɨmɨ káṇgá bɨ kɨ́ ịrịné Seyíra do bi bɨ kóo bulúndu Edómo ndịsịnɨ́ doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Togụ́ ndéré ndíkisé mongụ́ ꞌyị amá Ésawu go yá, zɨ́se úku ledre zɨ́a yaá, ‘ꞌYị kasa eyị́ Yakóbo uku ledre yaá, tụ́ꞌdụ́ sɨmɨbi ga bɨ okpó ba mbá mándị́sị ndịsị ꞌbe ꞌbɨ Labána. ");
INSERT INTO bdh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mándáꞌbaógụ go mááyí kɨ́ tụ́ꞌdụ́, ị́tị́ e, kɨ́ dongí e, kábịṛị́kị e, ína e kpá kɨ́ ꞌyị kasa e yaꞌdá e kɨ́ kará e zɨ́ma. Mákása ꞌyị kasa ga ba máa zɨ́yị gɨ ro zɨ́yị ótoómo bɨsinyí ledre ga bɨ kóo máméngị yée zɨ́yị ní, zɨ́yị ꞌdíꞌbi máa sɨmɨ sụmụ tɨ́ káa do owụ́ ꞌbɨ mbágáyị.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Sɨmɨ bɨ ꞌyị kasa ga gére ndaꞌbalugunɨ́ royé ógụndíki Yakóbo ní, zɨ́ye úku ledre zɨ́a kɨ́dí, “Nderé ndikizé lúnduyị́ Ésawu go, cakaba ní nɨ gɨrí go do mɨsiꞌdi mɨógụné zɨ́yị yána kɨ́ ꞌyị e do kacɨ́ne míya eso (400).” ");
INSERT INTO bdh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Zɨ́ ngịrị útúne sɨmɨ Yakóbo, zɨ́a ífi sɨmɨ ꞌyị ené e kɨ́ bangá ené e gbre. ");
INSERT INTO bdh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sɨmɨ sómụ́ ledre ené, “Togụ́ Ésawu ogụ go útú kɨ́ okó do ngíti géyị ꞌyị ené e yá, ngíti géyị ꞌyị ga bɨ utú aka doyé wá ní nɨyí ngásáókpó zɨ́ye ómoyé.” ");
INSERT INTO bdh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Née ní zɨ́ Yakóbo ị́nyịné íni ini zɨ́ Lomo, “Mbófo éyị́ zɨ́yị Lomo bɨ kóo ndị́sị lúrú bi kacɨ́ bulúndumá Abarayáma kɨ́ ꞌbụmá Isáka ní, áyí Ngére bɨ úku ledre zɨ́ma kɨ́dí, ‘Ndáꞌba mu sɨmɨ káṇgá eyị́ zɨ́ sụmụyị́ e, mááyí óto yị́ị zɨ́ bɨlámá ledre e ndị́sị méngị royé zɨ́yị ní.’ ");
INSERT INTO bdh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Bɨ go kenée ní, Lomo mááyí bɨsinyí ꞌyị. Máútúásá kóo ówo bɨlámá ledre káa zɨ́ bɨ méngị wo zɨ́yị íꞌbí tụ́ꞌdụ́ éyị́ e zɨ́ma ba wá. Sɨmɨ bɨ kóo mááyí ꞌdógụ Yeredéne ní, mááyí kóo dụụ́ kɨ́ ngbángbá do sị́lị́ma, tɨ́ lá bɨ nda ba ní, mááyí go kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ma káa zɨ́ bɨ máífi sɨmɨyé gbre née. ");
INSERT INTO bdh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Áko Lomo, máíni ini ba zɨ́yị gɨ ro zɨ́yị yómo máa gɨ zɨ́ lúndumá Ésawu. Ngịrị a ndịsị méngị máa gɨ zɨ́a nɨ ógụ útú kɨ́ okó domá, kɨ́ kará e kɨ́ owụ́ ga ba mbá. ");
INSERT INTO bdh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tɨ́ lá úku kóo ledre kɨ́dí, ‘Mááyí óto yị́ị zɨ́ bɨlámá ledre e ndị́sị méngị royé zɨ́yị, bulúnduyị́ e nɨyí étrị káa zɨ́ sayi bɨ kóꞌdụ́ mɨkavu bɨ ngárá utúasánɨ́ óloónzó a wá ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Zɨ́ Yakóbo ꞌdúꞌduné cịkị íri. Gɨ sɨmɨ éyị́ ga bɨ zɨ́a ní, zɨ́a ị́nyịné gélé ngíti géyị íꞌbí a zɨ́ lúnduné Ésawu. ");
INSERT INTO bdh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ꞌDiꞌbi kóo kará ína e míya gbre (200), yaꞌdá ye cị́ kéṛị́ a (20), kará kábịṛị́kị e míya gbre (200), yaꞌdá ye cị́ kéṛị́ a (20), ");
INSERT INTO bdh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kará gémele e cị́ kéṛị́ a doa sokó (30) kɨ́ owụ́ ꞌbɨ eyé e, kará ị́tị́ e cị́ gbre (40), yaꞌdá ye sokó (10), nda kɨ́ kará dongí e cị́ kéṛị́ a (20) kɨ́ yaꞌdá ye sokó (10). ");
INSERT INTO bdh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Zɨ́ Yakóbo ị́nyịné ífi bangá ga gére née kacɨ́ sị́ doyé. Zɨ́a ꞌdíꞌbi ꞌyị kasa ené e do óto yée kacɨ́ bangá ga bɨ ifi yée née kị́éꞌdo kị́éꞌdo mbá. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndérésé mu ꞌdáꞌdá íri, ídísé ndéré kɨ́ dongaráse.” ");
INSERT INTO bdh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Zɨ́a úku ledre zɨ́ wo bɨ nɨ ꞌdáꞌdá zɨ́ lafúne ní kɨ́dí, “Sɨmɨ bɨ ndíkísé go kɨ́ lúndumá Ésawu zɨ́a ndúnduꞌyú yaá, ‘Áyí ꞌyị ꞌbɨ ambi, sara áyí ndéré ꞌda, sara ambí nɨ mị́ngị́ bangá ga bɨ kóꞌdụ́ ba ne ní?’ ");
INSERT INTO bdh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ídí úkulúgu ledre zɨ́a kɨ́dí, ‘Bangá ga ba ꞌbɨ ꞌyị kasa eyị́ Yakóbo. Kasa yée zɨ́yị ngéré ené. Nɨ gɨ ꞌdáꞌba gɨrí rayíi.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Zɨ́ Yakóbo kpá úku ledre zɨ́ ngíti géyị ꞌyị kasa ené ga gére née mɨkékeṛị́a mbá kɨ́dí, “Ídísé úku mbá kémbị́ ledre kị́éꞌdo sɨmɨ bɨ ndíkísé go kɨ́ Ésawu e ní. ");
INSERT INTO bdh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ledre nda lị́gị sée kɨ́ úku a bɨ yaá, ‘ꞌYị kasa eyị́ Yakóbo nɨ gɨ ꞌdáꞌba gɨrí rayíi ní wá.’ ” Kacɨ́ sómụ́ ledre ꞌbɨ Yakóbo, iꞌbí kóo tụ́ꞌdụ́ éyị́ ga gére née zɨ́ Ésawu gɨ ro zɨ́ bi émené roa zɨ́a ótoómo bɨsinyí ledre bɨ kóo née mengị wo kɨ́e ní. ");
INSERT INTO bdh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Née ní zɨ́ Yakóbo kásaókpó éyị́ ga gére ené ꞌdáꞌdá, tɨ́ lá zɨ́a ꞌdúꞌduné cịkị do táya ore. ");
INSERT INTO bdh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kɨ́ ndụlụ a née ní, zɨ́ Yakóbo ꞌdíꞌbi meꞌbené e gbrengárá kɨ́ owụ́kará ꞌyị ꞌbɨ moko ené e gbre nda kɨ́ wotị́ne sokó doa kị́éꞌdo (11) do kásaókpó yée sága ngbuṛu bɨ kɨ́ ịrịné Zabụ́kụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Gɨ do kacɨ́ bɨ kásaókpó yée go sága ní, zɨ́a kpá kásaókpó éyị́ ené e mbá sága íri. ");
INSERT INTO bdh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Née ní zɨ́ Yakóbo ídíákáne ore ngúcuné ꞌdogụ ené bi sága wá. Zɨ́ ngíti oꞌdo ógụné útúne kɨ́ okó do Yakóbo, zɨ́ye óṛó royé kéne bi ndre. ");
INSERT INTO bdh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sɨmɨ bɨ oꞌdo née owo ya née utúasá ónzó ngóṛó a bi wá ní, zɨ́a ị́nyịné ócó komo ꞌbungono Yakóbo kpoó, zɨ́ komo ꞌbungono a éfị́ne. ");
INSERT INTO bdh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nda née ní, zɨ́ oꞌdo née úku ledre kɨ́dí, “Íꞌdí sị́lị́yị gɨ romá mu zɨ́ma ndéréma, bi ará go.” Tɨ́ lá zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Máíꞌdí amá sị́lị́ma gɨ royị́ wá, ꞌbúó togụ́ údru súrú go mɨmbéꞌdemá.” ");
INSERT INTO bdh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Zɨ́ oꞌdo née ndúꞌyú wo kɨ́dí, “Ịrịyị́ náambi?” Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Ịrịmá Yakóbo.” ");
INSERT INTO bdh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Gɨ ore zɨ́ oꞌdo née úku ledre kɨ́dí, “Ịrịyị́ ndaá lolụ Yakóbo wá, ịrịyị́ nda go Isɨréle gɨ zɨ́a rómo komo ꞌyị e do sogo káṇgá ba go mbá zɨ́yị go kpá rómo cụ́ komo Lomo.” ");
INSERT INTO bdh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Zɨ́ Yakóbo úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị ị́fị́ aka kpá ịrịyị́ zɨ́ma.” Zɨ́a úkulúgu ledre zɨ́ Yakóbo kɨ́dí, “Éyị́ bɨ ndúꞌyú ịrịmá gɨ roa ní ꞌdi?” Zɨ́ oꞌdo née nda ị́nyịné údru súrú mɨmbéꞌde Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nda née ní, zɨ́ Yakóbo ndólo ịrị bi née Penuwéle. “Máúku ledre née kenée gɨ zɨ́a bɨ málúrú Lomo go cụ́ kɨ́ komomá máúyu wá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Zɨ́ bi nda go aráónzó roné. Zɨ́ Yakóbo ị́nyịné gɨ sɨmɨ Penuwéle ndéréókpóne nda go mɨécịné gɨ zɨ́ ꞌbungononé bɨ efị́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Née sị́ ledre bɨ karaba Isɨréle e anunɨ́ cídrí bɨ sɨmɨ longụ bangá gɨ zɨ́a wá ní, gɨ zɨ́a oꞌdo née ocó kóo Yakóbo do cídrí a bɨ komo ꞌbungono a ní. ");
INSERT INTO bdh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakóbo nɨ lúrú bi káa ní zɨ́a ónzó komoné gbó ro Ésawu kɨ́ ogụ kɨ́ tụ́ꞌdụ́ ꞌyị e do kacɨ́ne míya eso (400). Née ní zɨ́ Yakóbo ị́nyịné ífi owụ́ e, yée ga bɨ ꞌbɨ Léya kɨ́ Rayéle nda kɨ́ ꞌbɨ owụ́kará ꞌyị ꞌbɨ moko ga bɨ gbre ní. ");
INSERT INTO bdh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Zɨ́a óto kará ꞌyị ꞌbɨ moko ga gére née kɨ́ owụ́ ꞌbɨ eyé e ꞌdáꞌdá, Léya kɨ́ ꞌbɨ ené e gɨ do kacɨ́ye, Rayéle kɨ́ Yoséfa nɨyí ꞌbɨ eyé nda dụụ́ gɨ ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Zɨ́ Yakóbo útúne zɨ́ye ꞌdáꞌdá, zɨ́a útúne do ngụ́ṛụ́ sịndị́ne bi ótụ́ doné kóꞌdụ́ Ésawu bi kɨ́ꞌdí ịnyị doa gbre sɨmɨ bɨ ogụ go gbóo cigí lúnduné ní. ");
INSERT INTO bdh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tɨ́ lá zɨ́ Ésawu ngásáne fáka Yakóbo do óto sị́lị́ne do goa tónóne íni ini roa. Zɨ́ye útúye mbá íni ini. ");
INSERT INTO bdh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Zɨ́ Ésawu óyó komoné káa gbó ro kará e kɨ́ owụ́ e. Zɨ́a ndúꞌyú Yakóbo kɨ́dí, “ꞌYị ga bɨ ógụsé kéye ba ꞌbɨ eyé náambi?” Zɨ́ Yakóbo úkulúgu ledre zɨ́a yaá, “Mongụ́ ꞌyị, née owụ́ ga bɨ Lomo owo ledre kɨ́ma zɨ́a íꞌbí yée zɨ́ ꞌyị ꞌbɨ moko eyị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nda née ní, zɨ́ kará ꞌyị moko ga ba kɨ́ owụ́ ꞌbɨ eyé e née ógụyé ótụ́ doyé bi íꞌbí mandá zɨ́ Ésawu. ");
INSERT INTO bdh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Gɨ do kacɨ́ye, zɨ́ Léya kɨ́ owụ́ ꞌbɨ ené e ógụyé ótụ́ doyé bi kóꞌdụ́ Ésawu do kpá íꞌbí mandá zɨ́a. Odụyé nda dụụ́ zɨ́ Yoséfa e kɨ́ Rayéle ógụyé, zɨ́ye méngị a kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Zɨ́ Ésawu ndúꞌyú Yakóbo kɨ́dí, “Lúndu ꞌbɨ enée, ndikízé kɨ́ ꞌyị e do mɨsiꞌdi kɨ́ra mɨndéréye kɨ́ tụ́ꞌdụ́ bangá e, ledre máa ꞌbe káa be ꞌdi?” Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Mákása bangá ga gére née máa zɨ́yị gɨ ro zɨ́ mɨmbéꞌdeyị́ ị́drị́ne romá mongụ́ ꞌyị.” ");
INSERT INTO bdh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tɨ́ lá zɨ́ Ésawu úkulúgu ledre zɨ́a kɨ́dí, “Lúndu ꞌbɨ enée, máútúásá ꞌdíꞌbi tụ́ꞌdụ́ bangá ga gére née wá, gɨ zɨ́a tụ́ꞌdụ́ bangá e nɨyí kpá bo zɨ́ma. ꞌBɨ eyị́ ga gére née idínɨ́ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ndaá kenée wá. Togụ́ ꞌbúma nɨ doyị́, ídí ꞌdíꞌbi tákpásị́lị́ bɨ máíꞌbí zɨ́yị née. Káa zɨ́ bɨ málúrú yị́ị karaba ba ní, nda káa zɨ́ málúrú cụ́ Lomo ní. Gɨ zɨ́a bɨ óto ꞌbúma go zɨ́yị ꞌdíꞌbi máa sɨmɨ sụmụ kɨ́ mɨmbéꞌdeyị́ kị́éꞌdo ní. ");
INSERT INTO bdh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Bɨ go kenée ní, mándéndị́ romá go zɨ́yị ídí ꞌdíꞌbi tákpásị́lị́ bɨ máíꞌbí yée zɨ́yị née, gɨ zɨ́a Lomo saká máa go kɨ́ngaya kɨ́ éyị́ ga gére née.” Nda gɨ zɨ́a bɨ Yakóbo lányá nda ro Ésawu go kɨ́ngaya ní, zɨ́ Ésawu ṇgúṇgu a zɨ́a ꞌdíꞌbi yée. ");
INSERT INTO bdh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Gɨ ore zɨ́ Ésawu úku ledre kɨ́dí, “Nderézé mu ꞌbe. Mááyí ꞌdị́yịóto sée.” ");
INSERT INTO bdh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, cóngó ro mɨnzéré owụ́ ga ba ndaá. Ili kpá zɨ́ma lúrú kacɨ́ mɨnzéré bangá ga bɨ nɨyí aka ụ́lụ umba ní. Togụ́ nderézé kɨ́ye kakara kenée yá, lá kadra kị́éꞌdo bangá ga gére née nɨyí úyuónzó royé mbá. ");
INSERT INTO bdh_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Bɨ kenée ní, mongụ́ ꞌyị ndéré ꞌbɨ eyị́ mu zɨ́ma ꞌdáꞌdá íri, mááyí lódụ́yị́ gɨ yáa ndoo kacɨ́ ndéré bɨ bangá ga ba kɨ́ owụ́ e nɨyí ndéré a ní, gị zɨ́ma ógụmá ꞌbe ꞌbɨ ngére sɨmɨ Seyíra.” ");
INSERT INTO bdh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Nda née ní zɨ́ Ésawu úku ledre zɨ́ Yakóbo kɨ́dí, “Togụ́ kenée, mááyí ótoómo ngíti géyị ꞌyị amá ga ba zɨ́se ógụsé kéye.” Zɨ́ Yakóbo ndúnduꞌyú kɨ́dí, “Nda née kenée gɨ ro ꞌdi? Ngére máíli tɨ́ lá zɨ́yị ị́drị mɨmbéꞌdeyị́ romá éyị́ bɨ nɨ méngị zée ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Née ní kpá ꞌduo kadra née, zɨ́ Ésawu ị́nyịné ndáꞌbalúgu roné sɨmɨ Seyíra. ");
INSERT INTO bdh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tɨ́ lá zɨ́ Yakóbo ị́nyịyé gɨ ore ndéréógụyé do ngíti bi ndịsịnɨ́ ndólo a Sụkótụ kɨ́ꞌdí bɨ lagá kụ́tụ́ zɨ́ne kɨ́ bangá ené e ní. Née sị́ ledre bɨ ndolonɨ́ ịrị bi née gɨ zɨ́a Sụkóta ní. ");
INSERT INTO bdh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Gɨ do kacɨ́ bɨ Yakóbo ịnyịnɨ́ gɨ sɨmɨ Padána Aráma ní, zɨ́ye ndéréógụyé bɨlámáne sɨmɨ mongụ́ gara bɨ kɨ́ ịrịné Sekéme sɨmɨ káṇgá ꞌbɨ Kanána, zɨ́a óto táya ené mɨꞌdí sɨmɨ súwú cigí mongụ́ gara ore. ");
INSERT INTO bdh_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Zɨ́ Yakóbo ị́nyịné úgú bi bɨ oto táya ené doa née gɨ zɨ́ wotị́ Amóra ꞌyị ꞌbɨ Sekéme kɨ́ mɨṛíṛiṛí késị́ míya kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Née ní zɨ́ Yakóbo óꞌbó mbayi gɨ sɨmɨ tutú ore do ị́fị́ ịrị a Lomo bɨ ndịsị lúrú bi kacɨ́ Isɨréle e ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Kadra kị́éꞌdo zɨ́ Dína nyị́ Yakóbo bɨ ndikinɨ́ kɨ́ Léya ní ị́nyịné ndéréne lúrú ngíti géyị kará e gɨ dongará ꞌyị ga bɨ ꞌbɨ Sekéme ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sɨmɨ bɨ komo wotị́ Amóra ngére bɨ ore ꞌyị ꞌbɨ Ịvị́ta bɨ kɨ́ ịrịné kpá Sekéme utú ro Dína ní, zɨ́a ị́nyịné ngáka Dína ndị́sị kɨ́e káa do kára kɨ́ cóngóro. ");
INSERT INTO bdh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nda née ní, zɨ́ ꞌbú Dína nyị́ Yakóbo nda ídíne doa kɨ́ngaya, zɨ́a ndị́sịné lóndo komo owụ́kára née gɨ ro zɨ́ ꞌbúne ídíne doa. ");
INSERT INTO bdh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Zɨ́ Sekéme úku ledre zɨ́ ꞌbụné Amóra kɨ́dí, “Babá ófụ́ owụ́kára née zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sɨmɨ bɨ Yakóbo uwú ledre yaá ngakanɨ́ nyị́ne Dína go ndị́sị kɨ́e kɨ́ cóngóro ní, zɨ́a ndécị́ne tí zaá gị sɨmɨ kadra bɨ wotị́ ga ndaꞌbaogụnɨ́ gɨ sɨmɨ súwú go ꞌbe kɨ́ lúrú kacɨ́ bangá eyé e ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nda née ní, zɨ́ Amóra ꞌbụ Sekéme ndéréne ndúꞌyú Yakóbo gɨ ro ledre nyị́ a zɨ́ wotị́ne. ");
INSERT INTO bdh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Sɨmɨ bɨ wotị́ Yakóbo e uwúnɨ́ ledre bɨ mengị roné zɨ́ye kenée ní, geré zɨ́ye ndáꞌbalúgu royé gɨ sɨmɨ súwú ꞌbe. Zɨ́ ledre née íꞌbí komokenyị́ kɨ́ sɨmɨkesị́ zɨ́ye kɨ́ngaya, gɨ zɨ́a éyị́ bɨ Sekéme mengị née oto kese go ro ꞌyị ꞌbɨ Isɨréle e. Née bɨcayi ledre bɨ utúasá zɨ́a méngị roné wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tɨ́ lá zɨ́ Amóra úku ledre zɨ́ye kɨ́dí, “Mɨmbéꞌde Wotị́ma Sekéme ili nyị́se née go kɨ́ngaya. Ótoómosé wo mu zɨ́a, zɨ́a ꞌdíꞌbi wo káa do meꞌbené. ");
INSERT INTO bdh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nɨ mɨútúásáne zɨ́ze yéme ledre ófụ́ ro dongaráze kése. Azé ꞌdíꞌbi nyị́se e, zɨ́se kpá ꞌdíꞌbi nyị́ze e. ");
INSERT INTO bdh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ásé ndị́sị dongaráze sɨmɨ Sekéme ona do bɨlámá bi. Azé kpá íꞌbí bi ga bɨ ona ní mbá zɨ́se, zɨ́se ndị́sị gámáse kɨ́ bangá esé e sɨmɨ a káa zɨ́ bɨ ílisé ní. Ásé kpá ówo bɨlámá ledre gɨ sɨmɨ káṇgá ba ona.” ");
INSERT INTO bdh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Zɨ́ Sekéme úku ledre zɨ́ ꞌbụ Dína e kɨ́ lúnduga kɨ́dí, “Ótoómosé ledre zɨ́ma, zɨ́ze ófụ́ rozé kéne. Mááyí íꞌbí éyị́ ga bɨ ílisé yée ní mbá zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Úkusé lá ledre éyị́ bɨ ílisé ní, zɨ́se ólo késị́ kára esé káa zɨ́ bɨ ílisé ní, mááyí íꞌbí a zɨ́se togụ́ ótoómosé nyị́se née go zɨ́ma ófụ́ a ní.” ");
INSERT INTO bdh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Gɨ zɨ́a bɨ sinyinɨ́ lémịyé Dína go ní, zɨ́ wotị́ Yakóbo e sómụ́ndíki mani lóndo Sekéme kɨ́ ꞌbụné Amóra kɨ́e sɨmɨ bɨ nɨyí ódro kéye ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Utúasázé méngị ledre káa zɨ́ née wá. Iꞌbízé ezé lémịzé zɨ́ oꞌdo bɨ ngárá utú ngbuṛu wá ní wá. Née mongụ́ komokenyị́ zɨ́ze. ");
INSERT INTO bdh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Azé ṇgúṇgu ledre née ꞌbúó togụ́ ꞌyị esé ga bɨ yaꞌdá e ní utúnɨ́ go mbá ngbuṛu zɨ́ye ídíye go káa zɨ́ze ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Azé nda fú íꞌbí nyị́ze e zɨ́se ófụ́yé e zɨ́ze kpá ófụ́ nyị́se e. Togụ́ ledre née mengị roné go kenée azé fú ógụ ndị́sị kése káa do ꞌyị e kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tɨ́ lá togụ́ ṇgúṇgusé esé ledre útú ngbuṛu wá, azé ꞌdíꞌbi lémịzé zɨ́ze ókpóze kɨ́e.” ");
INSERT INTO bdh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Zɨ́ ledre bɨ ukunɨ́ née útúásáne komo Amóra e kɨ́ wotị́ne Sekéme. ");
INSERT INTO bdh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekéme nɨ owụ́phɨṛangá bɨ kɨ́ ledrené owóowó rómo do ꞌyị ga ꞌbe ꞌbɨ eyé ore mbá ní. Luꞌbú wá, zɨ́a ị́nyịné geré ndéré méngị ledre bɨ ukunɨ́ née gɨ zɨ́a ꞌbú nyị́ Yakóbo ofụ kóo doa go. ");
INSERT INTO bdh_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Née ní, zɨ́ Amóra kɨ́ wotị́ne Sekéme ndéréye ku mbotụ mongụ́ gara ódroyé zɨ́ ꞌyị eyé ga bɨ sɨmɨ gara ore ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ꞌYị ga gére nɨyí bɨlámá ꞌyị e. Nɨ bɨlámáne zɨ́ye ndị́sịyé sɨmɨ káṇgá ezé ona ndị́sị gámá kɨ́ bangá eyé e káa zɨ́ bɨ ilinɨ́ ní gɨ zɨ́a káṇgá ezé nɨ mongụ́ne kɨ́ngaya, nɨ ꞌdíꞌbi zée kéye mbá. Azé ófụ́ nyị́ye zɨ́ye kpá ófụ́ nyị́ze e. ");
INSERT INTO bdh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tɨ́ lá ledre kị́éꞌdo. ꞌYị ga gére née nɨyí ṇgúṇgu a zɨ́ze ídíze kéye káa do ꞌyị kị́éꞌdo ꞌbúó togụ́ zée yaꞌdá e utúzé go mbá ngbuṛu zɨ́ze ídíze káa zɨ́ ye ní. ");
INSERT INTO bdh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Lúrúsé aka, tụ́ꞌdụ́ bangá e kɨ́ tụ́ꞌdụ́ ngíti géyị éyị́ ga bɨ zɨ́ye née nɨyí nda ídí go káa zɨ́ ꞌbɨ ezé e ní. Bɨ kenée ní, ṇguṇguzé mu zɨ́ye kenée gɨ ro zɨ́ye ndị́sịyé dongaráze ona.” ");
INSERT INTO bdh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Zɨ́ yaꞌdá ga bɨ nderénɨ́ ku mbotụ mongụ́ gara ní ị́nyịyé mbá ṇgúṇgu ledre ꞌbɨ Amóra e kɨ́ wotị́ne Sekéme, zɨ́ yaꞌdá e ị́nyịyé mbá útúye ngbuṛu. ");
INSERT INTO bdh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Gɨ do kacɨ́ sị́lị́ ota, sɨmɨ bɨ uṇgú nɨ aka ndị́sị ꞌdóꞌdo yée ní, zɨ́ wotị́ Yakóbo e gbre, Simiyóna e kɨ́ Lévị bɨ nɨyí gɨ sɨmɨ mbágá kɨ́ Dína e ní ị́nyịyé ꞌdíꞌbi mongụ́ maku eyé ndéré útú okó do ꞌyị ga gére née sɨmɨ bɨ ledre lịgị yée go ní. Zɨ́ye úfu zaá yaꞌdá ga bɨ sɨmɨ mongụ́ gara née ore mbá. ");
INSERT INTO bdh_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Zɨ́ye ógụyé kpụrụ́ gɨ do Amóra kɨ́ wotị́ne Sekéme do úfu yée ꞌdáꞌba. Zɨ́ye ꞌdíꞌbi lémịyé Dína gɨ ꞌbe ꞌbɨ Sekéme yóó zɨ́ye ókpóye kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Zɨ́ ngíti géyị wotị́ Yakóbo e ndéréye do bi bɨ ufunɨ́ ꞌyị e doa née do ngáka éyị́ kacɨ́ ꞌyị ga bɨ sɨmɨ mongụ́ gara ore kɨ́ꞌdí bɨ sinyinɨ́ lémịyé ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Zɨ́ye ꞌdíꞌbi bangá ga bɨ kábịṛị́kị e, ị́tị́ e, dongí e nda kɨ́ ngíti géyị éyị́ ga bɨ ilinɨ́ yée sɨmɨ mongụ́ gara gɨ ore ní mbá ókpó kɨ́e sɨmɨ súwú. ");
INSERT INTO bdh_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Gɨ do kacɨ́ bɨ ngaka onzónɨ́ éyị́ ga bɨ kɨ́ ledreyé owóowó ní go ní, zɨ́ye ị́nyịyé ꞌdíꞌbi kará e kɨ́ owụ́ e kacɨ́ye mbá ókpó kɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Zɨ́ Yakóbo úku ledre zɨ́ Simiyóna e kɨ́ Lévị kɨ́dí, “ꞌDíꞌbiógụsé báfí go dongaráze kɨ́ ꞌyị ꞌbɨ Kanána e kɨ́ ꞌyị ꞌbɨ Peréze e mị́ngị́ káṇgá ga ba. ꞌYị ga gére née nɨyí go ógụ ídí mbá okó romá. Lúrúsé aka eyezé kpá wá, togụ́ kotrụnɨ́ royé ógụ útú okó kɨ́ma ní, nɨyí úfu máa kɨ́ éyị́ ga bɨ ꞌbe ꞌbɨ amá ní mbá ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tɨ́ lá zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Nɨ mɨútúásáne zɨ́a méngị lárá lémịzé káa zɨ́ kára bɨ ndịsị gámá kacɨ́ yaꞌdá faa ní?” ");
INSERT INTO bdh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Gɨ do kacɨ́ ledre née ní, zɨ́ Lomo úku ledre zɨ́ Yakóbo kɨ́dí, “Ómụ́ mu ndéré ndị́sịyị́ sɨmɨ Bétele, zɨ́yị óꞌbó mbayi íri zɨ́ Lomo bɨ kóo ꞌdodo roné zɨ́yị sɨmɨ bɨ kóo áyí ndị́sị ngásá gɨ zɨ́ lúnduyị́ Ésawu ní.” ");
INSERT INTO bdh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Née ní, zɨ́ Yakóbo úku ledre zɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e kɨ́ ꞌyị ga bɨ kóo nɨyí kéye ní kɨ́dí, “Ụ́cụóyósé lomo ꞌbɨ ꞌyị lóṇgó ga bɨ do sị́lị́se née mbá ꞌdáꞌba, zɨ́se méngị ondụ́ bɨ ndịsị óto ꞌyị zɨ́a útúásáne kacɨ́ komo Lomo ní, zɨ́se nda ꞌdíꞌbi bɨlámá bongó esé e ésị yée rosé. ");
INSERT INTO bdh_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Gɨ ore zɨ́se ógụsé zɨ́ze ndéréze sɨmɨ Bétele, kɨ́ꞌdí bɨ mááyí óꞌbó mbayi zɨ́ Lomo ní. Lomo bɨ ndịsị úwú ini amá sɨmɨ bɨ mááyí kɨ́ mongụ́ sómụ́ ledre, zɨ́a ndị́sịné lúrú bi ne kacɨ́ma kacɨ́ kadra mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Née ní, zɨ́ye íꞌbí lomo ga gére kɨ́ ngoꞌdi ga bɨ ro mbílíye ní mbá zɨ́ Yakóbo. Zɨ́ Yakóbo ícióto lomo kɨ́ éyị́ mbílí ga gére née sɨmɨ káṇgá cịkị sị́ kágá sɨmɨ Sekéme ore. ");
INSERT INTO bdh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sɨmɨ bɨ Yakóbo e kɨ́ ꞌyị ené e ịnyịnɨ́ go ndéré ní, zɨ́ Lomo ésị ngịrị sɨmɨ ꞌyị ga bɨ sɨmɨ gara ore ní mbá, káa bɨ nɨyí ndéré lódụ́ Yakóbo e kɨ́ ꞌyị ené e ke. ");
INSERT INTO bdh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Zɨ́ Yakóbo e kɨ́ ꞌyị ga bɨ kóo do kacɨ́ne ní ndéréógụyé sɨmɨ bi bɨ kɨ́ ịrịné Lụ́zụ bɨ ndịsịnɨ́ kpá ndólo a Bétele, sɨmɨ káṇgá bɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Sɨmɨ Bétele íri, zɨ́a óꞌbó mbayi zɨ́ Lomo do ị́fị́ ịrị a, Lomo ꞌbɨ Bétele gɨ zɨ́a Lomo ꞌdodo kóo roné zɨ́a ore sɨmɨ bɨ nɨ ngásáóyó roné gɨ zɨ́ lúnduné ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Née ní, zɨ́ Débura bɨ ngboróogụ Rebéka ní úyuné. Do óto bi zɨ́a sị́ ngíti mongụ́ kágá kɨ́ ịrịné óka sɨmɨ Bétele ore. Zɨ́ye ị́fị́ ịrị bi née Alóni Bakụ́tụ. ");
INSERT INTO bdh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Gɨ do kacɨ́ bɨ Yakóbo ndaꞌbaogụ gɨ sɨmɨ Padána Aráma ní, zɨ́ Lomo ꞌdódo roné zɨ́a do íꞌbí ándá úndru zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Zɨ́ Lomo úku ledre zɨ́a kɨ́dí, “Ịrịyị́ nɨ yị́ ené tɨ́ Yakóbo, tɨ́ lá utúasánɨ́ lolụ ndólo yị́ị Yakóbo wá, nɨyí nda ndólo yị́ị go Isɨréle.” Née ní zɨ́a ị́nyịné ị́fị́ ịrị doa Isɨréle. ");
INSERT INTO bdh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Gɨ ore zɨ́ Lomo úku ledre zɨ́a kɨ́dí, “Mááyí Lomo bɨ rokoꞌbụ a ofụ go ní, máíꞌbí rokoꞌbụ go zɨ́yị ndíki tụ́ꞌdụ́ owụ́ e, zɨ́ bulúnduyị́ e étrịyé tụ́ꞌdụ́. Ṛị́kị́ sị́ do ꞌyịmaꞌdí e, kɨ́ bi eyé e nɨyí ólụ́ógụ gɨ sɨmɨyị́, zɨ́ ngíti géyị ídíye káa do mɨngburoko ngére e. ");
INSERT INTO bdh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Káṇgá bɨ kóo máíꞌbí zɨ́ Abarayáma e kɨ́ Isáka ní, máíꞌbí kpá go zɨ́yị, mááyí kpá íꞌbí káṇgá née zɨ́ bulúnduyị́ e gɨ do kacɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sɨmɨ bɨ Lomo uku ledre née kenée ní, zɨ́a ị́nyịné ndéréókpóne gɨ do bi bɨ gáa ndịsị ódro doa zɨ́ Yakóbo ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Gɨ ore, zɨ́ Yakóbo ícióto mongụ́ tutú cị́ ꞌdága do bi bɨ Lomo odro zɨ́a doa née. Zɨ́a ị́nyịné ꞌdíꞌbi leꞌyị́ kɨ́ sụꞌbụ́ léfe a do tutú née káa do ꞌdáná éyị́ óto úndru Lomo kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Zɨ́ Yakóbo ị́fị́ ịrị bi bɨ Lomo odro zɨ́a doa née Bétele. ");
INSERT INTO bdh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Née ní, zɨ́ Yakóbo e ómụ́ye gɨ sɨmɨ Bétele gɨ ore, sɨmɨ bɨ nɨyí aka do mɨsiꞌdi gbála gɨ sɨmɨ Efaráta ní, zɨ́ sịndị́ kadra útúásáne gɨ ro zɨ́ Rayéle áráne. Zɨ́ owụ́ nda tónóne ówoné sɨmɨ a bɨsinyíne kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Gɨ zɨ́a bɨ mɨárá Rayéle ꞌdoꞌdo kóo wo go kɨ́ngaya ní, zɨ́ kára bɨ ndịsị sáká wo gɨ ro zɨ́a áráne ní úku ledre zɨ́a kɨ́dí, “Ndá éré ngịrị wá, áyí árá ngíti owụ́ ꞌbɨ eyị́ owụ́oꞌdo.” ");
INSERT INTO bdh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Sɨmɨ bɨ Rayéle nɨ nda go gbóo gɨ ro úyu ní, zɨ́a ị́nyịné ị́fị́ ịrị wotị́ne née Benóni. Zɨ́ Yakóbo ị́fị́ ꞌbɨ ené Benzemúna. ");
INSERT INTO bdh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Née ní zɨ́ Rayéle úyuné do ícióto wo do mɨsiꞌdi kɨ́ ndéréye sɨmɨ Efaráta bɨ ndolonɨ́ kpá Beteléme ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zɨ́ Yakóbo ꞌdíꞌbi mongụ́ tutú ícióto a do bi zɨ́ Rayéle. Tutú máa née gị sɨmɨ sịndị́ kadra bɨ karaba ba mɨéké ledre nɨ roa kɨ́dí bi zɨ́ Rayéle. ");
INSERT INTO bdh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Gɨ do kacɨ́ née, zɨ́ Isɨréle ómụ́ne ndéré lágá kụ́tụ́ ndị́sịné sɨmɨ a sogo bi bɨ kɨ́ ịrịné Mịgịdéle Edára. ");
INSERT INTO bdh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sɨmɨ bɨ Isɨréle nɨ mɨndị́sịné sɨmɨ ị́rịgbére née ore ní, zɨ́ Rụ́bene ị́nyịné ndéréne ndị́sịné kɨ́ meꞌbe ꞌbụné káa do kára bɨ kɨ́ ịrịné Bíla ní. Zɨ́ ꞌbụ a Isɨréle úwú ledre née. Wotị́ Yakóbo e nɨyí kóo mbá sokó doa gbre. ");
INSERT INTO bdh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wotị́ga máa yée ga bɨ gɨ sɨmɨ Léya ní nɨyí, Rụ́bene bɨ nɨ ne owụ́ndíká ꞌbɨ Yakóbo, Simiyóna, Lévị, Zụ́da, Isakára nda kɨ́ Zebụlụ́na. ");
INSERT INTO bdh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wotị́ga máa yée ga bɨ gɨ sɨmɨ Rayéle ní nɨyí ꞌbɨ eyé, Yoséfa e kɨ́ Benzemúna. ");
INSERT INTO bdh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Yée máa yée ga bɨ gɨ sɨmɨ owụ́kára bɨ ꞌyị ꞌbɨ moko ꞌbɨ Rayéle bɨ kɨ́ ịrịné Bíla ní nɨyí ꞌbɨ eyé, Dána e kɨ́ Nafatáli. ");
INSERT INTO bdh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Yée ga bɨ ꞌbɨ eyé gɨ sɨmɨ owụ́kára bɨ ꞌyị ꞌbɨ moko ꞌbɨ Léya bɨ kɨ́ ịrịné Zílifa ní nɨyí ꞌbɨ eyé, Gáda e kɨ́ Aséra. Ga gére née ịrị wotị́ Yakóbo ga bɨ ndikinɨ́ yée zɨ́a sɨmɨ Padána Aráma ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Zɨ́ Yakóbo ndéréne lúrú ꞌbụné Isáka sɨmɨ Mamaré gbóo kɨ́ Kiríta Arába bɨ ndịsịnɨ́ ndólo a Éborono ní, kɨ́ꞌdí bɨ kóo Abarayáma e kɨ́ Isáka ndịsịnɨ́ ndị́sị ní. ");
INSERT INTO bdh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isáka mengị kóo mbá sɨmɨbi míya kị́éꞌdo doa cị́ eso (180). ");
INSERT INTO bdh_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Uyu nda kóo sɨmɨ bɨ nɨ nda goó ngokoné kɨ́ngaya ní. Zɨ́ wotị́ga ga bɨ Ésawu e kɨ́ Yakóbo ní óto wo. ");
INSERT INTO bdh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ba ledre gɨ ro bulúndu Ésawu ga bɨ ndịsịnɨ́ ndólo yée Edómo e ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ésawu ofụ́ kóo kára gɨ sɨmɨ nyị́ ꞌyị ꞌbɨ Kanána e. Ịrị meꞌbea bɨ nyị́ ꞌyị ga bɨ Éte e ní nɨ Áda nɨ nyị́ Éloni. Meꞌbea máa wo bɨ ꞌbɨ ené nyị́ ꞌyị ꞌbɨ Ịvị́ta ní ịrị a ꞌbɨ ené Olibáma nyị́ Ána bulúndu Zibóna, ");
INSERT INTO bdh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","meꞌbea máa wo bɨ Basimáta ní, nɨ nyị́ Isɨméle lémị Nebayóta. ");
INSERT INTO bdh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Meꞌbe Ésawu e ota mbá ꞌyị ndíki owụ́ e. Meꞌbea bɨ Áda ní ndiki ꞌbɨ ené Elifáza, zɨ́ Basimáta ndíki ꞌbɨ ené Ruwéle, ");
INSERT INTO bdh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","zɨ́ Olibáma nda ndíki ꞌbɨ ené Zéwụsa e kɨ́ Zaláma nda kɨ́ Kóra. Ga gére née ịrị wotị́ Ésawu ga bɨ ndikinɨ́ yée zɨ́a sɨmɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Gɨ ore, zɨ́ Ésawu ꞌdíꞌbi meꞌbené e, wotị́ne e, nyị́ne e, kɨ́ ꞌyị ga bɨ gɨ do kacɨ́ne ní, bangá ené e kɨ́ ngíti géyị éyị́ ꞌbɨ ꞌbe ꞌbɨ ené e bɨ ndiki yée sɨmɨ Kanána ní mbá do ómụ́ne ndéré ndị́sịné gbála gɨ do bi bɨ Yakóbo nɨ doa ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Omụ́ kóo gɨ zɨ́a bi bɨ ndịsịnɨ́ ndị́sị doa kɨ́ Yakóbo e ní, eye lolụ kóo gɨ royé gbrengárá wá. Bangá eyé e etrịnɨ́ nda kóo go kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Née ní zɨ́ Ésawu bɨ ndịsịnɨ́ kpá ndólo wo Edómo ní ómụ́ne ndéré ndị́sịné sɨmɨ káṇgá bɨ do bi ekị́ekị́ bɨ sɨmɨ Seyíra ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ba ledre gɨ ro Ésawu bulúndu ꞌyị ga bɨ ndịsịnɨ́ ndólo yée Edómo e bɨ sɨmɨ káṇgá bɨ do bi ekị́ekị́ sɨmɨ Seyíra ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ga ba ní ịrị wotị́ Ésawu e. Ésawu e ndikinɨ́ Elifáza kɨ́ meꞌbené bɨ Áda ní, zɨ́ meꞌbea bɨ Basimáta ní ndíki ꞌbɨ ené Ruwéle. ");
INSERT INTO bdh_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wotị́ Elifáza ga bɨ ndíki yée ní nɨyí Temána e, Ómara e, Zéfo e, Gatáma e, nda kɨ́ Kenáza. ");
INSERT INTO bdh_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Zɨ́ Ésawu e kpá ndíki ngíti owụ́ kɨ́ ịrịné Elifáza bɨ nɨ ꞌbụ Amaléka kɨ́ ꞌberịné bɨ Timáni ní. Ga gére née ịrị bulúndu Ésawu e bɨ gɨ sɨmɨ meꞌbea bɨ Áda ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wotị́ Ésawu bɨ ndikinɨ́ wo kɨ́ Basimáta kɨ́ ịrịné Ruwéle ní, ndiki ꞌbɨ ené Náta e, Zéra e, Sáma e nda kɨ́ Miza. Ga gére née ịrị bulúndu Ésawu ga bɨ gɨ sɨmɨ meꞌbea bɨ Basimáta ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wotị́ Ésawu máa yée ga bɨ Olibáma nyị́ Ána bulúndu Zibóna ndiki yée ní, nɨyí ꞌbɨ eyé Zéwụsa e, Zaláma e nda kɨ́ Kóra. ");
INSERT INTO bdh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ga gére née kóo sị́ do ga bɨ gɨ dongará bulúndu Ésawu e ní. Elifáza bɨ owụ́ndíká ꞌbɨ Ésawu ní, nɨ ne ꞌyị bɨ ndikiogụ mɨngburoko sị́ do ga bɨ kɨ́ ịrịyé Temána e, Ómara e, Zéfo e, Kenáza e, ");
INSERT INTO bdh_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kóra e, Gatáma e kɨ́ Amaléka e ní. Née kóo mbá sị́ do bɨ Elifáza ndiki yée sɨmɨ Edómo ní. Nɨyí bulúndu Ésawu bɨ tetéye nɨ Áda ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Bulúndu Ésawu ga bɨ gɨ sɨmɨ wotị́ a bɨ Ruwéle ní, nɨyí ꞌbɨ eyé sị́ do ga bɨ kɨ́ ịrịyé Náta e, Zéra e, Sáma e kɨ́ Miza e ní. Sị́ do máa ga gére née Ruwéle ndikiogụ yée ne sɨmɨ Edómo. Nɨyí bulúndu Ésawu bɨ tetéye nɨ Basimáta ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wotị́ Ésawu bɨ ndiki wo kɨ́ meꞌbené bɨ Olibáma ní, ndikiogụ ꞌbɨ ené sị́ do ga bɨ kɨ́ ịrịyé Zéwụsa e, Zaláma e kɨ́ Kóra e ní. Ga gére née sị́ do ga bɨ gɨ sɨmɨ meꞌbe Ésawu bɨ Olibáma nyị́ Ána ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ga gére née ịrị bulúndu Ésawu bɨ ndịsịnɨ́ ndólo yée Edómo ní. Nɨyí kóo mbá mɨngburoko sị́ do gɨ sɨmɨ kúfú yée née. ");
INSERT INTO bdh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ga ba ịrị wotị́ Seyíra ꞌyị ꞌbɨ Órị bɨ nɨyí ye mɨzefị ꞌyị ga bɨ kóo ndịsịnɨ́ ndị́sị sɨmɨ Edómo ore ꞌdesị́ ní. Ịrịyé nɨ, Lotána, Sụbụ́la, Zibóna, Ána, ");
INSERT INTO bdh_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disóna, Ezére e nda kɨ́ Disána. Wotị́ Seyíra ga gére née nɨyí kóo ye sị́ do ꞌyị ꞌbɨ Órị e. ");
INSERT INTO bdh_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wotị́ Seyíra bɨ kɨ́ ịrịné Lotána ndiki ꞌbɨ ené kóo Órị e kɨ́ Omámu. Timáni nɨ ꞌbɨ ené lémị Lotána. ");
INSERT INTO bdh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wotị́a máa wo bɨ kɨ́ ịrịné Sụbụ́la ní, ndikiogụ ꞌbɨ ené kóo Alavána, Manáta, Ebála, Séfo e nda kɨ́ Onáma. ");
INSERT INTO bdh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ngíti wotị́ Seyíra bɨ kɨ́ ịrịné Zibóna ní, ndiki ꞌbɨ ené Ayá e kɨ́ Ána. Ána utúogụ kóo do ngbuṛu bɨ iní a ịrị́ mɨị́rị́ sɨmɨ bɨ ndị́sị ndéré kɨ́ dongí ga bɨ ꞌbɨ ꞌbụné sɨmɨ súwú ánu éyị́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wotị́ Seyíra máa wo bɨ kɨ́ ịrịné Ána ní, ndiki kóo Disóna e kɨ́ Olibáma. ");
INSERT INTO bdh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wotị́ Seyíra máa wo bɨ kɨ́ ịrịné Disóna ní, ndiki kóo Emadána, Esebána, Isarána nda kɨ́ Keráni. ");
INSERT INTO bdh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Zɨ́ wotị́a bɨ Ezére ní, ndiki ꞌbɨ ené Bilána, Zavána e kɨ́ Akána. ");
INSERT INTO bdh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wotị́ Seyíra máa wo bɨ kɨ́ ịrịné Disána ní, ndiki Úza e kɨ́ Arána. ");
INSERT INTO bdh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ga gére née sị́ do ꞌyị ga bɨ ꞌbɨ Órị e ní, Lotána, Sụbụ́la, Zibóna nda kɨ́ Ána, ");
INSERT INTO bdh_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disóna, Ezére e kɨ́ Disána. Wotị́ Seyíra ga gére née nɨyí kóo ye ngére kacɨ́ sị́ doyé ga gére née sɨmɨ káṇgá ꞌbɨ Seyíra ore. ");
INSERT INTO bdh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ba ịrị mɨngburoko ngére ga bɨ kóo ꞌdiꞌbinɨ́ bi do ndị́sịyé do kúfú ꞌyị ga bɨ ꞌbɨ Edómo ní mbá ꞌdáꞌdá gɨ zɨ́ mɨngburoko ngére ga bɨ ꞌbɨ Isɨréle ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Mɨzefị mongụ́ ngére ꞌbɨ Edómo bɨ ꞌyị e otonɨ́ wo ní, nɨ Béla wotị́ Biyóra bɨ mongụ́ gara ené nɨ gara bɨ kɨ́ ịrịné Dinába ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sɨmɨ bɨ Béla uyu ní, zɨ́ Zobába wotị́ Zéra ꞌyị ꞌbɨ Buzóra ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Sɨmɨ bɨ Zobába uyu ní, zɨ́ Usáma bɨ gɨ sɨmɨ káṇgá ꞌbɨ ꞌyị ꞌbɨ Temána ní ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Sɨmɨ bɨ Usáma uyu ní, zɨ́ Adáda wotị́ Bedáda ꞌyị ꞌbɨ Avíti ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. Adáda mengịnɨ́ kóo okó kɨ́ Mịdịyáni e sɨmɨ káṇgá ꞌbɨ Muwába zɨ́a rómo komoyé cụ́. ");
INSERT INTO bdh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Sɨmɨ bɨ Adáda uyu ní, zɨ́ Samála ꞌyị ꞌbɨ Masaréka ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sɨmɨ bɨ Samála uyu ní, zɨ́ Sáwụla ꞌyị ꞌbɨ Rebóta gbóo kɨ́ ngbuṛu bɨ Efaráta ní ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sɨmɨ bɨ Sáwụla uyu ní, zɨ́ Balanána wotị́ Akóbo ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Sɨmɨ bɨ Balanána wotị́ Akóbo uyu ní, zɨ́ Adára ꞌyị ꞌbɨ gara bɨ Péwu ní ꞌdíꞌbi bi kacɨ́ a káa do mongụ́ ngére. Ịrị meꞌbea kóo Metabéle nyị́ Matírida bɨ kɨ́ ịrị nyị́ne Mezába ní. ");
INSERT INTO bdh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ba ịrị kúfú ꞌyị ga bɨ Ésawu ndiki ogụ yée ní. Ịrịyé nɨ Timína e, Aláva e, Yetéte e, ");
INSERT INTO bdh_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibáma, Éla, Pinóna, ");
INSERT INTO bdh_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenáza, Temána, Mibizára, ");
INSERT INTO bdh_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiyéle e kɨ́ Yiráma. Ga gére née mbá ịrị sị́ do ꞌyị ga bɨ kóo nɨyí mɨngburoko sị́ do sɨmɨ Edómo ní. Ịfị́nɨ́ ịrị ga gére née kacɨ́ káṇgá bɨ ndịsịnɨ́ ndị́sị sɨmɨyé ní. Ésawu ndiki ogụ sị́ do ꞌyị ꞌbɨ Edómo e mbá ne. ");
INSERT INTO bdh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakóbo nderé ndịsị kóo sɨmɨ káṇgá bɨ Kanána kɨ́ꞌdí bɨ kóo ꞌbụa ndịsịnɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ba ledre gɨ ro Yakóbo. Sɨmɨ bɨ Yoséfa nɨ kóo go owụ́phɨṛangá sɨmɨbi ené nɨ go sokó doa ịnyị doa gbre ní, zɨ́ye kóo ndị́sịyé kɨ́ mɨngburoko lúnduné e ndịsị ꞌbáꞌbá bangá ꞌbɨ ꞌbụyé. Lúnduga ga gére née kóo wotị́ meꞌbe ꞌbụyé ga bɨ Bíla e kɨ́ Zílifa ní. Zɨ́ Yoséfa ógụné lị́kpị́ bɨsinyí ledre ga bɨ ndịsịnɨ́ méngị royé íri ní mbá zɨ́ ꞌbụyé. ");
INSERT INTO bdh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakóbo otoofụ kóo yị́ ené ꞌbú Yoséfa go rómo do ngíti géyị wotị́ne e mbá, gɨ zɨ́a ndikinɨ́ kóo Yoséfa zɨ́a sɨmɨ bɨ nɨ kóo go ngokoné ní. Zɨ́a ꞌdíꞌbi bongó bɨ kɨ́ bɨlámá tífíne ní íꞌbí a zɨ́ Yoséfa ndị́sị ésị a. ");
INSERT INTO bdh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Sɨmɨ bɨ lúnduga owonɨ́ kɨ́dí ꞌbụyé oto ꞌbú Yoséfa go rómo doyé mbá ní, zɨ́ ꞌbú Yoséfa nzúlúne doyé, zɨ́ye óto bɨsinyí mɨmbéꞌdeyé roa, odronɨ́ lolụ bɨlámá ódro zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sɨmɨ ngíti ndụlụ zɨ́ Yoséfa ꞌdúꞌduru, sɨmɨ bɨ lịkpị́ ꞌduru née zɨ́ lúnduné e ní, zɨ́ ꞌbúa nzúlú tátá roné doyé nda ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Úwúsé aka ꞌduru bɨ máꞌdúru ba. ");
INSERT INTO bdh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Máꞌdúꞌduru, azé ndị́sị ódó kére yáká. ꞌDiya káa ní zɨ́ kụṛụꞌbụ kére bɨ máódó ní ị́nyịógụné tóroné cị́ ꞌdága, zɨ́ kụṛụꞌbụ kére esé e yóko royé gbaá dongá kụṛụꞌbụ kére amá zɨ́ye ótụ́ doyé zɨ́a bi.” ");
INSERT INTO bdh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Zɨ́ lúnduga úku ledre zɨ́a kɨ́dí, “Sɨmɨ sómụ́ ledre eyị́ ní íli ídí káa do mongụ́ ngére zɨ́ rokoꞌbụyị́ ídíne dozé?” Zɨ́ ꞌbú Yoséfa nzúlúne doyé kɨ́ngaya gɨ zɨ́ ꞌduru bɨ ꞌduru kɨ́ ledre bɨ uku wo ní. ");
INSERT INTO bdh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Gɨ ore zɨ́ Yoséfa kpá ꞌdúru ngíti ꞌduru, zɨ́a úku ledre zɨ́ lúnduné e kɨ́dí, “Máꞌdúru kpá ngíti ꞌduru go. ꞌDuru máa wo ba nɨ ꞌbɨ ené, zɨ́ kadra e kɨ́ éfé nda kele e sokó doa kị́éꞌdo ndị́sịyé útúógụyé bi zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Sɨmɨ bɨ lịkpị́ ꞌduru née zɨ́ ꞌbụné kpá zɨ́ lúnduné e ní, zɨ́ ꞌbụa úku ledre zɨ́a oꞌbụóbụ kɨ́dí, “ꞌDuru máa bɨ ꞌdúru née lárá ꞌduru ꞌdi? Sómụ́ ꞌbɨ eyị́ yá mbágáyị kɨ́ma kɨ́ lúnduyị́ e azé ógụ ótụ́ dozé bi do káṇgá kóꞌdụ́yị?” ");
INSERT INTO bdh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Zɨ́ lúndu Yoséfa e óto ledre née sɨmɨyé roa, tɨ́ lá ꞌbụa bandá kóo ledre née sɨmɨ sómụ́ ledre ené. ");
INSERT INTO bdh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kadra kị́éꞌdo zɨ́ lúndu Yoséfa e ꞌdíꞌbi bangá ꞌbɨ ꞌbụyé ndéré kɨ́ye do bi éyị́ mɨánu gbóo kɨ́ Sekéme, ");
INSERT INTO bdh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","zɨ́ Isɨréle úku ledre zɨ́ Yoséfa kɨ́dí, “Káa zɨ́ bɨ owo bú, lúnduyị́ e nderénɨ́ go kɨ́ bangá e do bi éyị́ mɨánu gbóo kɨ́ Sekéme ní, ógụ mu, máíli kása yị́ị zɨ́ye íri.” Zɨ́ Yoséfa úkulúgu ledre zɨ́a kɨ́dí, “Bɨlámáne.” ");
INSERT INTO bdh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Née ní zɨ́ ꞌbụa úku ledre zɨ́a kɨ́dí, “Ndéré mu lúrú lúnduyị́ e kɨ́ bangá ga gére née togụ́ nɨyí mbá bɨlámáye yá zɨ́yị ndáꞌbaógụyị́ kɨ́ ledreyé zɨ́ma.” Zɨ́a kásaókpó wo gɨ do bi bɨ ndịsịnɨ́ doa sɨmɨ ꞌbululu Éborono ní ndéré lúrú lúnduné e. Sɨmɨ bɨ Yoséfa ogụ sɨmɨ Sekéme ní, ");
INSERT INTO bdh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","zɨ́ ngíti oꞌdo ndíki wo kɨ́ gámá lóꞌbó roné sɨmɨ káṇgá née ore, zɨ́a ndúꞌyú Yoséfa kɨ́dí, “Ndịsị gámásóꞌdo ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Zɨ́ Yoséfa úkulúgu ledre zɨ́a kɨ́dí, “Mándị́sị gámásóꞌdo lúndumá e. Útúásá go ꞌdódo bi bɨ bangá eyé e ndị́sịnɨ́ ánu éyị́ doa ní zɨ́ma?” ");
INSERT INTO bdh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Zɨ́ oꞌdo née úkulúgu ledre zɨ́a kɨ́dí, “Omụ́nɨ́ yị́ eyé gɨ ona go. Máúwú ledre gɨ tarayé kɨ́dí, ‘Nderézé mu sɨmɨ Dotána.’ ” Née ní zɨ́ Yoséfa ndéréne lódụ́ kacɨ́ lúnduné e, zɨ́a ndéré ndíki yée gbóo kɨ́ Dotána. ");
INSERT INTO bdh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Zɨ́ lúnduga lúrúndíki wo gɨ gbála, ꞌdáꞌdá gɨ zɨ́a kɨ́ ógụné zɨ́ye, zɨ́ye ndómo tarayé gɨ ro zɨ́ye úfuóyó wo. ");
INSERT INTO bdh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Zɨ́ye úku ledre dengbị́ye kɨ́dí, “ꞌYị ꞌduru ba nɨ gɨ ꞌdáa go ógụ. ");
INSERT INTO bdh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ogụ gɨrí mu, zɨ́ze úfu wo zɨ́ze ónzóóto umbu a sɨmɨ ngúru kuṛú gu ꞌdawú ga ba. Zɨ́ze úku a kɨ́dí bangá sinyí ꞌdiꞌbi wo go, ánuónzó wo go. Zɨ́ze aka ówo éyị́ bɨ nɨ ólụ́ógụ gɨ sɨmɨ ꞌduru ené máa née ní ní.” ");
INSERT INTO bdh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Sɨmɨ bɨ Rụ́bene uwú ledre née kenée ní, zɨ́a sómụ́ sóꞌdo mɨsiꞌdi bɨ née nɨ yómo Yoséfa doa gɨ zɨ́ye ní. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndazé úfu wo wá. ");
INSERT INTO bdh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ndazé ꞌdíꞌbiógụ sáma a kpá wá. ꞌDiꞌbizé lá wo zɨ́ze ụ́cụ wo sɨmɨ kuṛú gu ꞌdawú ga ba sɨmɨ súwú ona, tɨ́ lá ndazé méngị bɨsinyí ledre kɨ́e wá.” Rụ́bene uku kóo ledre née kenée gɨ ro yómo wo gɨ zɨ́ye gɨ ro zɨ́ne ꞌdíꞌbi wo ndáꞌba kɨ́e zɨ́ ꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Née ní, sɨmɨ bɨ Yoséfa ogụ ndiki lúnduné e ní, zɨ́ye útú ꞌdíꞌbi wo íꞌdíógụ bɨlámá bongó ené bɨ kɨ́ bɨlámá tífíne ní gɨ roa ꞌdáꞌba, ");
INSERT INTO bdh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","zɨ́ye ꞌdíꞌbi wo ndéré kɨ́e ụ́cụ wo sɨmɨ kuṛú gu ꞌdawú. Sɨmɨ sịndị́ kadra née iní ndaá kóo sɨmɨ gu ꞌdawú née wá. ");
INSERT INTO bdh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sɨmɨ bɨ ndaꞌbalugunɨ́ royé go ndị́sịyé bi ánu éyị́ ní, zɨ́ye lúrúndíki ꞌyị ga bɨ kɨ́ sị́ doyé Isɨméle e ní kɨ́ ógụyé gɨ sɨmɨ Gịlị́dị. Ịmbị́nɨ́ kóo kágá ga bɨ kɨ́ bɨlámá ndonyoyé kɨ́ ngíti géyị bɨlámá éyị́ mɨndonyo e do gémele eyé ndéré kɨ́e úgúóyó yée sɨmɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Zɨ́ Zụ́da úku ledre zɨ́ lúnduné e kɨ́dí, “Togụ́ ufuzé lúnduzé zɨ́ze ótoécị ledre umbu a ní, éyị́ bɨ azé ówo a gɨ sɨmɨ a ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Togụ́ lá máa yá, idízé úgúóyó wo zɨ́ ꞌyị ꞌbɨ Isɨméle e gɨ zɨ́ wo bɨ azé méngị bɨsinyí ledre kɨ́e ní. Ówosé bú, nɨ lúnduzé, mbigí sanáze kpá sámazé.” Zɨ́ lúnduga ṇgúṇgu a. ");
INSERT INTO bdh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Née ní sɨmɨ bɨ ꞌyị ꞌbɨ Isɨméle ga bɨ gɨ sɨmɨ Mịdịyáni ogụnɨ́ ní, zɨ́ lúndu Yoséfa e lálaógụ wo gɨ sɨmɨ gu ꞌdawú do úgúóyó wo kɨ́ komo késị́ cị́ kéṛị́ a zɨ́ ꞌyị ꞌbɨ Isɨméle ga gére née, zɨ́ye ꞌdíꞌbi wo ókpó kɨ́e sɨmɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Sɨmɨ bɨ Rụ́bene ndaꞌbalugu roné do gu ꞌdawú íri ní, nɨ lúrú bi káa ní Yoséfa ndaá lolụ wá, zɨ́a lófo bongó gɨ roné gɨ zɨ́ sɨmɨkesị́. ");
INSERT INTO bdh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Zɨ́a ndáꞌbalúgu roné úku ledre zɨ́ lúnduné e kɨ́dí, “Owụ́ ba ndaá ꞌbɨ ené lolụ íri wá. Mááyí méngị goó ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Gɨ do kacɨ́ née ní, zɨ́ye óṇgoónzó ína do ꞌdíꞌbi bɨlámá bongó bɨ kɨ́ tífíne kacɨ́ Yoséfa née ní lóꞌdó a sɨmɨ sáma ína née. ");
INSERT INTO bdh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Zɨ́ye ꞌdíꞌbi bongó née ndáꞌba kɨ́e zɨ́ ꞌbụyé. Zɨ́ye úku ledre kɨ́dí, “Owozé bongó ba bi. Lúrú yéme aka za kpó kpó kpó née ndaá bongó ꞌbɨ wotị́yị wá?” ");
INSERT INTO bdh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zɨ́a ówo bongó née tɨ́ kóró zɨ́a úku ledre kɨ́dí, “Ba tɨ́ bongó ꞌbɨ wotị́ma. Bangá sinyí ufu wo go do ánuónzó a. Maꞌdíi lófo bayi Yoséfa go kụ́ṛị́ kụ́ṛị́.” ");
INSERT INTO bdh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gɨ ore zɨ́ Yakóbo lófo bongó bɨ roné ní za mbá ꞌdáꞌba, do ꞌdíꞌbi nzenze bongó ésị a roné íni wotị́ne kɨ́e kɨ́ tụ́ꞌdụ́ sị́lị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Zɨ́ wotị́ga kɨ́ nyị́ga ógụyé mbá zɨ́a gɨ ro ị́drị mɨmbéꞌdea, tɨ́ lá zɨ́a ásiné ili ené do ị́drị mɨmbéꞌdené wá. Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Mááyí íni wotị́ma née gị sɨmɨ bɨ mááyí úyu zɨ́ma ólụ́ma sɨmɨ káṇgá ní.” Née ní zɨ́ Yakóbo ndị́sịné íni wotị́ne née tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Sɨmɨ ledre née ní, zɨ́ ꞌyị ꞌbɨ Mịdịyáni ga gére née úgúóyó Yoséfa sɨmɨ Ízibiti ore zɨ́ Potifá manda ꞌdáꞌdá ꞌbɨ ꞌyị ꞌbɨ moko e ꞌbe ꞌbɨ mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ Zụ́da ómụ́ne ótoómo lúnduné e ndéré ndị́sịné sɨmɨ gara bɨ Adulúma ní cigí ꞌbe ꞌbɨ oꞌdo bɨ kɨ́ ịrịné Íra ní. ");
INSERT INTO bdh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Sɨmɨ bɨ nɨ íri ní, zɨ́ Zụ́da ówo owụ́kára nyị́ ngíti oꞌdo kɨ́ ịrịné Súwa gɨ sɨmɨ nyị́ Kanána e. Zɨ́a ófụ́ wo zɨ́ye ndị́sịyé kéne, ");
INSERT INTO bdh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","zɨ́ owụ́kára née ídíne kɨ́ sɨmɨné do ndíkiógụ owụ́oꞌdo do ị́fị́ ịrịa Éra. ");
INSERT INTO bdh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Zɨ́ kára née kpá ídíne kɨ́ sɨmɨné zɨ́a ndíki owụ́oꞌdo do ị́fị́ ịrịa Onána. ");
INSERT INTO bdh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Zɨ́a kpá ndíki ngíti owụ́oꞌdo do ị́fị́ ịrịa Séla. Aránɨ́ kóo wo sɨmɨ bɨ Yụ́da e nɨyí sɨmɨ gara bɨ Kezɨ́bi ní. ");
INSERT INTO bdh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Sɨmɨ bɨ Éra owụ́ndíká ꞌbɨ Zụ́da ngboró ógụ go káa do yaꞌdá ꞌyị ní, zɨ́ Zụ́da ófụ́ kára zɨ́a kɨ́ ịrịné Tamára. ");
INSERT INTO bdh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tɨ́ lá Éra, owụ́ndíká ꞌbɨ Zụ́da nɨ yị́ ené bɨsinyí ꞌyị do komo Lomo. Née ní zɨ́ Ngére Lomo úfu wo. ");
INSERT INTO bdh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Gɨ ore zɨ́ Zụ́da úku ledre zɨ́ Onána, “ꞌDíꞌbi lụ́mụ́yị née zɨ́yị ndị́sịyị́ kɨ́e káa do kára zɨ́se ndíki owụ́ e kéne sɨmɨ lafa ꞌbɨ lúnduyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tɨ́ lá Onána owo bú kɨ́dí owụ́ ga bɨ yée nɨyí ndíki yée kéne ní ndanɨ́ eyé owụ́ ꞌbɨ ené wá. Sɨmɨ bɨ nɨ go ndị́sị kɨ́ kára umbu bɨ kacɨ́ lúnduné née ní, zɨ́a ndị́sị ndéꞌyị́ ené bi káa bɨ née nɨ óto owụ́ sɨmɨ a zɨ́a ndíki a sɨmɨ lafa ꞌbɨ lúnduné. ");
INSERT INTO bdh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ledre bɨ kóo ndịsị méngị a née nɨ kóo mongụ́ bɨsinyí ledre do komo Ngére Lomo. Zɨ́ Lomo kpá úfuóyó wo. ");
INSERT INTO bdh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Gɨ ore zɨ́ Zụ́da úku ledre zɨ́ Tamára kára ꞌbɨ owụ́ ꞌbɨ ené kɨ́dí, “Ndáꞌba aka mu ndị́sị káa do kára umbu ꞌbe ꞌbɨ ꞌbụyị́ gị togụ́ Séla ngboró ogụ go káa do yaꞌdá ꞌyị.” Somụ́ ꞌbɨ ené ya, “Séla nɨ go kpá ógụ úyu cé káa zɨ́ ꞌbɨ lúnduné e ní.” Née ní zɨ́ Tamára ndáꞌbalúgu roné ꞌbe ꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Gɨ do kacɨ́ tụ́ꞌdụ́ sɨmɨbi e zɨ́ meꞌbe Zụ́da nyị́ Súwa úyuné. Sɨmɨ bɨ Zụ́da ini meꞌbené, lerị́ ụkụ́ nda gɨ roa go ní, zɨ́ye ị́nyịyé ndéréye sɨmɨ Timána kɨ́ ezegámá Íra ꞌyị ꞌbɨ Adulúma zɨ́ yaꞌdá ga bɨ kóo ndịsịnɨ́ ólo kálá kábịṛị́kị ené e ní. ");
INSERT INTO bdh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Sɨmɨ bɨ ukunɨ́ ledre zɨ́ Tamára kɨ́dí, “Tetéyị yaꞌdá ꞌyị ị́nyị go gɨ ro ndéré sɨmɨ Timána ólo kálá kábịṛị́kị ené e ní,” ");
INSERT INTO bdh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","zɨ́a íꞌdíóyó bongó bɨ ndịsị ésị a ꞌbɨ kára umbu ní gɨ roné ꞌdáꞌba. Zɨ́a ꞌdíꞌbi bɨlámá mbílí bongó lóꞌbụ a roné, doné e kɨ́ sɨmɨ komoné mbá gɨ ro zɨ́ne ídíne kpị́. Zɨ́a ndéré ndị́sịné tara mɨsiꞌdi bɨ ndịsị ólụ́ sɨmɨ Enayíma do mɨsiꞌdi bɨ ndịsị ndéré sɨmɨ Timána ní. Owoyeme bú bɨlámáne kɨ́dí, abú bɨ Séla ngboró ogụ go káa do yaꞌdá ꞌyị ní, ilinɨ́ eyé íꞌbí née zɨ́a káa do meꞌbea wá. ");
INSERT INTO bdh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Sɨmɨ bɨ Zụ́da lurúndiki wo ní, zɨ́a sómụ́ a kɨ́dí née kára bɨ ndịsị gámá kacɨ́ yaꞌdá e faa ní, gɨ zɨ́a loꞌbụꞌdụtụ sɨmɨ komoné go. ");
INSERT INTO bdh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Owo ené bɨ kɨ́dí née kára ꞌbɨ owụ́ ꞌbɨ ené ní wá. Zɨ́a ndéréne zɨ́a dogboṛụ mɨsiꞌdi íri do úku ledre zɨ́a kɨ́dí, “Ógụ mu zɨ́ze ndị́sịzé kéyị káa kára kɨ́ oꞌdo.” Zɨ́ Tamára ndúꞌyú wo kɨ́dí, “Áyí íꞌbí zɨ́ma ꞌdi gɨ ro zɨ́ze ndị́sị kéyị?” ");
INSERT INTO bdh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Zɨ́ Zụ́da úkulúgu ledre zɨ́a kɨ́dí, “Mááyí kása owụ́ ína gɨ dongará ína amá e zɨ́yị.” Zɨ́ Tamára ndúꞌyú wo kɨ́dí, “Útúásá go ótoómo éyị́ zɨ́ma ona bɨ zɨ́a ꞌdódo a kɨ́dí maꞌdíi áyí kása ína ní?” ");
INSERT INTO bdh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Zɨ́a úkulúgu ledre zɨ́ Tamára kɨ́dí, “Éyị́ bɨ íli zɨ́ma íꞌbí a zɨ́yị ní ꞌdi?” Zɨ́ Tamára úkulúgu ledre zɨ́a kɨ́dí, “Ngoꞌdi bɨ ro sị́lị́yị kɨ́ nyari bɨ goyị́ née kpá kɨ́ ngbángbá bɨ do sị́lị́yị née.” Zɨ́a ị́nyịné íꞌbí éyị́ ga gére née zɨ́a, zɨ́ye ndị́sịyé kéne. Zɨ́a geré óto owụ́ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Zɨ́ Tamára ndáꞌbané ꞌbe, zɨ́a íꞌdíógụ bɨlámá mbílí bongó bɨ loꞌbụ roné ní do ésịlúgu bongó ꞌbɨ kará umbu e roné. ");
INSERT INTO bdh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Sɨmɨ sịndị́ kadra máa née ní, zɨ́ Zụ́da kása owụ́ ína do sị́lị́ ezegámáne bɨ ꞌyị ꞌbɨ Adulúma zɨ́a ndéré kɨ́e zɨ́ kára née gɨ ro zɨ́a ꞌdíꞌbilúgu éyị́ ené ga bɨ zɨ́a íri ní, tɨ́ lá ogụndiki ené wo do biné née wá. ");
INSERT INTO bdh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Zɨ́a ndúꞌyú ꞌyị ga bɨ ndịsịnɨ́ ndị́sị ore ní kɨ́dí, “Kára bɨ tara mɨsiꞌdi bɨ ndịsị ólụ́ sɨmɨ Enayíma ona bɨ ndịsị gámá kacɨ́ yaꞌdá e faa ba nɨ ꞌda?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Kára ndaá ꞌbɨ ené ona bɨ ndịsị gámá kacɨ́ yaꞌdá e faa ní wá.” ");
INSERT INTO bdh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Née ní zɨ́a ndáꞌbalúgu roné úku a zɨ́ Zụ́da kɨ́dí, “Máówo amá wo wá. ꞌYị ga bɨ ndịsịnɨ́ ndị́sị ore ní ukunɨ́ yaá, ‘Kára ndaá ꞌbɨ ené kú ore bɨ ndịsị gámá kacɨ́ yaꞌdá e faa ní wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Zɨ́ Zụ́da úku ledre kɨ́dí, “Éyị́ ga gére née idí mu zɨ́a, káa bɨ azé ídí káa zɨ́ éyị́ kugú ꞌbɨ ꞌyị e. També mákása tɨ́ owụ́ ína go zɨ́a, tɨ́ lá bɨ ngárá ndíki wo wá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Gɨ do kacɨ́ éfé ota zɨ́ ngíti ꞌyị úku ledre zɨ́ Zụ́da kɨ́dí, “Tamára kára ꞌbɨ owụ́ ꞌbɨ eyị́ luyú ledre go ndị́sị gámáne kacɨ́ yaꞌdá e faa, gɨ zɨ́ kéyị née ní nɨ go kɨ́ owụ́ sɨmɨné.” Sɨmɨ bɨ Yụ́da uwú ledre née ní, zɨ́a úku ledre kɨ́dí, “Idínɨ́ ꞌdíꞌbi Tamára do ónzó a ku phoꞌdụ zɨ́a áṛáónzó roné ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sɨmɨ bɨ ꞌdiꞌbinɨ́ wo go ndéré kɨ́e ní, zɨ́a kákasa zɨ́ teténe yaꞌdá ꞌyị. Zɨ́a úku ledre kɨ́dí, “Owụ́ bɨ sɨmɨmá ba mị́ngị́ éyị́ ga ba oto ne. Lúrú aka ngoꞌdi, nyari kɨ́ ngbángbá ga ba, ówo mị́ngị́ a bú?” ");
INSERT INTO bdh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Zụ́da áyí lúrú bi káa ní, gbó ro éyị́ ené e, zɨ́a úku ledre kɨ́dí, “Ledre ené nɨ maꞌdíi, málúyú ledre máa gɨ zɨ́a máíꞌbí amá Tamára zɨ́ wotị́ma Séla wá.” Gɨ do kacɨ́ ledre née ní ndịsịnɨ́ lolụ kéne káa do kára kɨ́ oꞌdo wá. ");
INSERT INTO bdh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sɨmɨ bɨ sịndị́ kadra utúasá go gɨ ro zɨ́a áráne ní, zɨ́a áráógụ owụ́ toṇgo e mbá yaꞌdá e. ");
INSERT INTO bdh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Sɨmɨ bɨ nɨ árá ní, zɨ́ ngúruyé ésịógụ sị́lị́ne sága zɨ́ kára bɨ ndị́sị árá do sị́lị́ a née ꞌdíꞌbi bɨkesị́ káꞌdá bongó ódó a ro sị́lị́a. Zɨ́ kára née úku ledre kɨ́dí, “Wo ba aráụtụne.” ");
INSERT INTO bdh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tɨ́ lá sɨmɨ bɨ lalalugu sị́lị́ne ní, zɨ́ lúndua geré ólụ́ógụ ené. Zɨ́ kára née úku ledre kɨ́dí, “Née ní go mɨsiꞌdi bɨ ꞌdéwe phụ́trụ zɨ́yị áráyị doa ní.” Nda née ní do ị́fị́ ịrịa Peréze. ");
INSERT INTO bdh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Zɨ́ lúndua bɨ odónɨ́ bɨkesị́ káꞌdá bongó ro sị́lị́a áráne do ị́fị́ ịrịa Zéra. ");
INSERT INTO bdh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sɨmɨ sịndị́ kadra máa bɨ kóo née nderéokpónɨ́ kɨ́ Yoséfa go sɨmɨ Ízibiti. Zɨ́ Potifá ngúru mongụ́ ꞌyị bɨ do ꞌyị óndó bi ga bɨ ꞌbe ꞌbɨ mongụ́ ngére ní, úgú wo gɨ zɨ́ ꞌyị ꞌbɨ Isɨméle ga gére née do ndáꞌbané kɨ́e ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ngére Lomo nɨ kóo kɨ́ Yoséfa zɨ́a óto wo zɨ́ moko ené ídíne bɨlámáne kɨ́ngaya sɨmɨ mɨndị́sị a bɨ ꞌbe ꞌbɨ mongụ́ ꞌyị ené bɨ ꞌyị ꞌbɨ Ízibiti ní. ");
INSERT INTO bdh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Sɨmɨ bɨ mongụ́ ꞌyị ené bɨ ꞌyị ꞌbɨ Ízibiti owo yaá Ngére Lomo nɨ kɨ́ Yoséfa, iꞌbí rokoꞌbụ zɨ́a ne zɨ́ moko ené ndị́sị ndéréne mbá bɨlámáne ní, ");
INSERT INTO bdh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","zɨ́ ledre ꞌbɨ Yoséfa émené komo Potifá kɨ́ngaya zɨ́a gélé Yoséfa káa do bɨlámá ꞌyị ꞌbɨ moko ené. Zɨ́ Potifá óto Yoséfa káa do ꞌyị lúrú bi kacɨ́ ꞌbe ꞌbɨ ené, zɨ́a kpá ótoómo éyị́ sị́lị́ne e mbá zɨ́ Yoséfa ndị́sị lúrú bi kacɨ́ a ne. ");
INSERT INTO bdh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Gɨ sɨmɨ sịndị́ kadra bɨ oto Yoséfa káa do ꞌyị lúrú bi kacɨ́ ꞌbe ꞌbɨ ené, kpá kɨ́ éyị́ sị́lị́ne e mbá ní, zɨ́ Ngére Lomo íꞌbí úndru sɨmɨ éyị́ ga bɨ ꞌyị ꞌbɨ Ízibiti ní gɨ zɨ́ Yoséfa. Lomo iꞌbí kóo úndru sɨmɨ éyị́ ga bɨ ꞌbɨ Potifá ní mbá. Éyị́ máa yée ga bɨ ꞌbe kɨ́ yée ga bɨ yáká ní. ");
INSERT INTO bdh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Née ní zɨ́a ótoómo Yoséfa ndị́sịné lúrú bi kacɨ́ éyị́ ené e mbá ne. Potifá somụ́ ené lolụ ledre éyị́ ga gére née wá, nda lá dụụ́ ledre éyị́ bɨ gɨ ro zɨ́ne ánu a ní. Yoséfa nɨ kóo bɨlámá owụ́phɨṛangá kɨ́ lámá roné, ");
INSERT INTO bdh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","gɨ zɨ́ kéyị née ní, zɨ́ meꞌbe mongụ́ ꞌyị ené óto ꞌbú Yoséfa doné zɨ́a úku ledre zɨ́ Yoséfa kɨ́dí, “Máíli zɨ́ze kótrụ bi ꞌdúꞌdu kéyị.” ");
INSERT INTO bdh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Zɨ́ Yoséfa ási ené. Zɨ́a úku ledre zɨ́ kára née kɨ́dí, “Lúrú aka mongụ́ ꞌyị amá somụ́ ené ledre éyị́ ga bɨ ꞌbe ba mbá wá, zɨ́a ótoómo éyị́ ga gére née mbá zɨ́ma ndị́sị lúrú bi kacɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ꞌYị ndaá ꞌbe ona bɨ romo gɨ domá ní wá. Mongụ́ ꞌyị amá asi kɨ́ kémbị́ éyị́ kị́éꞌdo káa gɨ zɨ́ma wá, lá dụụ́ yị́ị gɨ zɨ́ bɨ áyí meꞌbea ní. Mááyí méngị bɨsinyí ledre née zɨ́ma lúyúma ro Lomo kenée lárá káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Abú bɨ ndịsị úku ledre née zɨ́ Yoséfa kacɨ́ kadra mbá ní, zɨ́a ásiné, kotrụnɨ́ bi ꞌdúꞌdu kéne wá, ndịsị gbawá cígí a. ");
INSERT INTO bdh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kadra kị́éꞌdo, Yoséfa ndéré go ꞌdị́cị́ méngị moko ené káa zɨ́ bɨ lengbe ní. ꞌYị ꞌbɨ moko ga bɨ ꞌbe ore ní ndanɨ́ mbá wá. ");
INSERT INTO bdh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Zɨ́ meꞌbe Potifá ólụ́ne kacɨ́ a íri zɨ́a útúne tị ro bongó ꞌbɨ Yoséfa lála do úku ledre zɨ́a kɨ́dí, “Ógụ mu ndị́sị kɨ́ma.” Tɨ́ lá zɨ́ Yoséfa ótoómo bongó née cịkị do sị́lị́a do gbúgbuógụné sága. ");
INSERT INTO bdh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sɨmɨ bɨ lurú kɨ́dí Yoséfa otoomo bongó ené go cịkị do sị́lị́ne gbugbuogụ go sága ní, ");
INSERT INTO bdh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","zɨ́a ndólo ꞌyị moko ené ga bɨ ore ní. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Lúrúsé aka, ꞌyị ꞌbɨ Ébere bɨ ꞌdiꞌbiogụnɨ́ wo zɨ́ze ꞌbe ona ba, ogụ gɨ ro zɨ́a ndị́sịné úku zée. Olụ́ lodụ́ gáa kacɨ́ma ꞌdị́cị́ áyíne gɨ ro ngáka máa, bɨ zɨ́ma mbụ́mbụ́dụ́ ba. ");
INSERT INTO bdh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sɨmɨ bɨ uwú domá kɨ́ mbụ́mbụ́dụ́ gɨ ro zɨ́ ꞌyị e ógụyé sáká máa ní, zɨ́a ótoómo bongó ené cigíma do gbúgbuógụné sága.” ");
INSERT INTO bdh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Zɨ́ meꞌbe Potifá bándá bongó ꞌbɨ Yoséfa cigíne ore gị zɨ́ mongụ́ ꞌyị ꞌbɨ Yoséfa ndáꞌbaógụné ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Gɨ ore zɨ́ kára née ꞌdíꞌbi ledre née lị́kpị́ a zɨ́ oꞌdo ꞌbɨ ené. “ꞌYị ꞌbɨ Ébere bɨ ꞌdiꞌbiogụnɨ́ wo zɨ́ze ꞌbe ona ba olụ́ lodụ́ gáa kacɨ́ma ꞌdị́cị́ ona gɨ ro ngáka máa. ");
INSERT INTO bdh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tɨ́ lá sɨmɨ bɨ mámbụ́mbụ́dụ́ gɨ ro zɨ́ ꞌyị e ngásáógụyé sáká máa ní, zɨ́a ótoómo bongó ené cigíma do gbúgbuógụné sága.” ");
INSERT INTO bdh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sɨmɨ bɨ mongụ́ ꞌyị ené uwú ledre bɨ meꞌbea lịkpị́ zɨ́a, ya “Née ledre bɨ ꞌyị ꞌbɨ moko eyị́ mengị kɨ́ma ní,” zɨ́ ledre née útúne sɨmɨa ꞌduo káa zɨ́ phoꞌdụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Zɨ́ mongụ́ ꞌyị ꞌbɨ Yoséfa ꞌdíꞌbi wo ónzó a sɨmɨ sị́gịnị kɨ́ꞌdí bɨ ndịsịnɨ́ bándá ꞌyị ga bɨ ꞌdiꞌbinɨ́ yée mɨꞌdíꞌbi ꞌbe ꞌbɨ mongụ́ ngére ní. Tɨ́ lá sɨmɨ bɨ kóo Yoséfa nɨ sɨmɨ sị́gịnị ní, ");
INSERT INTO bdh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngére Lomo nɨ kóo bo kɨ́e. Zɨ́a ówo ledre kɨ́ Yoséfa zɨ́ ledre ené óto ꞌyị ga bɨ ndịsịnɨ́ lúrú bi kacɨ́ sị́gịnị ore ní mbá ídíye kɨ́ rokinyi kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Née ní zɨ́ ꞌyị lúrú bi kacɨ́ sị́gịnị óto Yoséfa káa do manda ꞌdáꞌdá zɨ́ ꞌyị ga bɨ nɨyí mɨꞌdíꞌbiyé sɨmɨ sị́gịnị ore ní, zɨ́a kpá ndị́sịné lúrú bi kacɨ́ éyị́ ga bɨ ore ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ꞌYị lúrú bi kacɨ́ sị́gịnị otonɨ́ eyé sómụ́ ledre kɨ́ngaya gɨ ro éyị́ ga bɨ Yoséfa ndị́sị lúrú bi kacɨ́ye ní wá, gɨ zɨ́a Ngére Lomo nɨ kóo bo kɨ́e zɨ́ moko ené ndị́sị ndéréne ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Gɨ do kacɨ́ ledre ga gére ní, zɨ́ ꞌyị íꞌbí leꞌyị́ e kɨ́ ezené ꞌyị óꞌbó ambata zɨ́ mongụ́ ngére ꞌbɨ Ízibiti, méngị ledre bɨ emengụ́ ní do komo mongụ́ ꞌyị eyé mongụ́ ngére ꞌbɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Zɨ́ mɨmbéꞌde ngére née ésị́ne ro ꞌyị ꞌbɨ moko ené ga bɨ gbre née bɨsinyíne kɨ́ngaya, ");
INSERT INTO bdh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","zɨ́a ꞌdíꞌbi yée ónzó yée sɨmɨ sị́gịnị ꞌbe ꞌbɨ mongụ́ ꞌyị lúrú bi do ꞌyị óndó bi ga bɨ ꞌbe ꞌbɨ mongụ́ ngére ore kɨ́ꞌdí bɨ onzónɨ́ Yoséfa sɨmɨ sị́gịnị ní. ");
INSERT INTO bdh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Zɨ́ mongụ́ ꞌyị bɨ ndịsị lúrú bi do ꞌyị óndó bi e ní íꞌbí yée zɨ́ Yoséfa ndị́sị lúrú bi kacɨ́ye. Gɨ do kacɨ́ bɨ ndịsịnɨ́ ore go kɨ́ tụ́ꞌdụ́ sị́lị́ e ní, ");
INSERT INTO bdh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","sɨmɨ ngíti ndụlụ zɨ́ yaꞌdá ga bɨ otonɨ́ yée sɨmɨ sị́gịnị ba, ꞌyị íꞌbí leꞌyị́ kɨ́ ꞌyị óꞌbó ambata zɨ́ mongụ́ ngére ꞌbɨ Ízibiti ꞌdúꞌduru. ꞌDuru máa ga gére née nɨyí mbá kɨ́ ini ledre e sɨmɨyé kpị́ kpị́ kpị́. ");
INSERT INTO bdh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sɨmɨ bɨ Yoséfa ogụ zɨ́ye kɨ́ phịyị́ a née ní, zɨ́a ndíki yée kɨ́ ndị́sị sómụ́ ledre kɨ́ mongụ́ lerị́. ");
INSERT INTO bdh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Zɨ́a ndúꞌyú mɨnbguroko ꞌyị moko ꞌbɨ mongụ́ ngére ga bɨ nɨyí kéye sɨmɨ sị́gịnị née ní kɨ́dí, “Ledre máa káa be ꞌdi bɨ ndị́sịsé karaba mbá kɨ́ lerị́ ní?” ");
INSERT INTO bdh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Zée gbrengárá ꞌduruzé ꞌduru e, tɨ́ lá ꞌyị bɨ zɨ́a úkuógụ ini ledre gɨ sɨmɨyé zɨ́ze ní ndaá.” Zɨ́ Yoséfa úkulúgu ledre zɨ́ye kɨ́dí, “Lomo nɨ útúásá úkuógụ ini ledre gɨ sɨmɨ ꞌduru née ne. Lị́kpị́sé aka ꞌduru esé maꞌdáa zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Née ní zɨ́ mongụ́ ꞌyị máa wo bɨ ꞌbɨ ené ꞌyị íꞌbí leꞌyị́ zɨ́ mongụ́ ngéré ní lị́kpị́ ꞌduru ené zɨ́ Yoséfa kɨ́dí, “Máꞌdúru mongụ́ kókó kóṛó kɨ́ tóro kóꞌdụ́ma, ");
INSERT INTO bdh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kóṛó máa née ní nɨ kɨ́ mɨngarasáne e ota. Sɨmɨ bɨ mbílía tonó ụ́ꞌbụ ní, zɨ́a sụ́rụ́ne do ánáógụ bɨkesị́ mɨánáne. ");
INSERT INTO bdh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mááyí kenée kɨ́ kóꞌdo leꞌyị́ kóṛó ꞌbɨ mongụ́ ngére do sị́lị́ma. Zɨ́ma ꞌdíꞌbi bɨkesị́ mɨáná née lụ́rụ a sɨmɨ kóꞌdo ꞌbɨ mongụ́ ngére zɨ́ma ꞌdíꞌbi a íꞌbí a zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Zɨ́ Yoséfa úku ledre zɨ́a kɨ́dí, “Ini ledre gɨ sɨmɨ ꞌduru née nɨ káa, mɨngarasá kóṛó ga bɨ ota née nɨyí sị́lị́ e ota. ");
INSERT INTO bdh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sɨmɨ sị́lị́ ota mongụ́ ngére nɨ ꞌdíꞌbiógụ yị́ị gɨ sɨmɨ sị́gịnị zɨ́a ótolúgu yị́ị do bi moko eyị́ káa zɨ́ bɨ kóo ꞌdáꞌdá ní. Nda née ní zɨ́yị ndị́sịyị́ íꞌbí leꞌyị́ kóṛó ené zɨ́a cé káa zɨ́ bɨ kóo ndị́sị méngị a zɨ́a bɨlámáne ní. ");
INSERT INTO bdh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Karanée sɨmɨ bɨ ledre e emenɨ́ go zɨ́yị ní, ídí sómụ́ndíki ledremá zɨ́yị ówo ledre kɨ́ma zɨ́yị kpá úkuógụ ledremá zɨ́ mongụ́ ngére zɨ́a ꞌdíꞌbiógụ máa gɨ sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ꞌYị e ꞌdiꞌbiogụnɨ́ máa ona ye gɨ sɨmɨ káṇgá ezé ꞌbɨ Ébere e kɨ́ cóngóro. Ona máméngị kpá gbawá ledre bɨ do útúásá ónzó máa sɨmɨ sị́gịnị gɨ zɨ́a ní.” ");
INSERT INTO bdh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Sɨmɨ bɨ mongụ́ ꞌyị máa wo bɨ ꞌbɨ ené ꞌyị óꞌbó ambata zɨ́ mongụ́ ngére lurú ini ledre bɨ Yoséfa ukuogụ ba nɨ mɨútúásáne ní, zɨ́a úku ledre zɨ́ Yoséfa kɨ́dí, “Máꞌdúru kpá ꞌduru, zɨ́ma ị́mbị́ gbété e ota kɨ́ ambata sɨmɨyé domá. ");
INSERT INTO bdh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Gbété bɨ do lafúne ní, toso bɨlámá ambata ga bɨ ndịsịnɨ́ óꞌbó yée zɨ́ mongụ́ ngére ní nɨ sɨmɨ a, tɨ́ lá zɨ́ solụ́ e ndị́sịyé lágá yée gɨ sɨmɨ gbété gɨ domá gɨ ore.” ");
INSERT INTO bdh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Zɨ́ Yoséfa úku ledre zɨ́a kɨ́dí, “Ini ledre gɨ sɨmɨ ꞌduru née nɨ káa, gbété ga bɨ ota née ní, née sị́lị́ e ota. ");
INSERT INTO bdh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sɨmɨ sị́lị́ ota mongụ́ ngére nɨ ꞌdíꞌbiógụ yị́ị gɨ sɨmɨ sị́gịnị zɨ́a íngíónzó yị́ị komo kágá. Zɨ́ solụ́ e ógụyé ndị́sị lágá umbuyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sị́lị́ ota gɨ do kacɨ́ ledre née, née kóo sị́lị́ bɨ aránɨ́ mongụ́ ngére née sɨmɨ a ní. Zɨ́a méngị ayímbi zɨ́ mɨngburoko ꞌyị ꞌbɨ moko ené e. Zɨ́a ꞌdíꞌbiógụ ꞌyị íꞌbí kóꞌdo leꞌyị́ zɨ́ne kɨ́ ꞌyị óꞌbó ambata zɨ́ne gɨ sɨmɨ sị́gịnị. Zɨ́a óto yée kóꞌdụ́ mɨngburoko ꞌyị moko ené e. ");
INSERT INTO bdh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Zɨ́a ꞌdíꞌbilúgu ꞌyị íꞌbí kóꞌdo leꞌyị́ zɨ́ne do bi moko, gɨ ro zɨ́a ndị́sịné íꞌbí leꞌyị́ zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tɨ́ lá zɨ́a íngíónzó ꞌyị óꞌbó ambata cé káa zɨ́ bɨ Yoséfa uku zɨ́ye sɨmɨ bɨ ukuogụ ini ledre gɨ sɨmɨ ꞌdúru zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Abú kenée ndotó, ꞌyị íꞌbí leꞌyị́ zɨ́ mongụ́ ngére somụ́ndiki ené ledre Yoséfa wá. Ledre bɨ kóo Yoséfa uku zɨ́a ní somụ́lịgị yị́ ené go. ");
INSERT INTO bdh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Gɨ do kacɨ́ sɨmɨbi e gbre, zɨ́ mongụ́ ngére ꞌbɨ Ízibiti ꞌdúꞌduru. Nɨ kenée mɨtóroné kacɨ́ kóꞌdụ́ mongụ́ ngbuṛu bɨ Náyili ní, ");
INSERT INTO bdh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","nɨ lúrú bi káa ní, zɨ́ mɨngburoko mɨóto ị́tị́ e ịnyị doa gbre (7) kɨ́ bɨlámá sanáye ṛíṛiṛí ólụ́ógụyé gɨ sɨmɨ iní ndị́sị ánu éyị́ dongará lómí e kenée. ");
INSERT INTO bdh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Gɨ do kacɨ́ yée née ní, zɨ́ ngíti géyị mɨlárá rógbó ị́tị́ e ịnyị do a gbre (7) kpá ólụ́ógụyé gɨ sɨmɨ iní dongará yée ga bɨ gáa ba do gbúṛóngó kenée. ");
INSERT INTO bdh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ꞌDiya káa ní, zɨ́ mɨlárá rógbó ị́tị́ ga gére née nánáónzó bɨlámá mɨóto ị́tị́ ga bɨ kɨ́ sanáye ṛíṛiṛí née do ánuónzó yée mbá. Gɨ ore zɨ́ mongụ́ ngére ꞌbɨ Ízibiti úrúne gɨ sɨmɨ ꞌbí. ");
INSERT INTO bdh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Zɨ́ ꞌbí kpá ꞌdíꞌbi ándá wo zɨ́a kpá ꞌdúru ándá ngíti ꞌduru. Sɨmɨ ꞌduru máa née ní, zɨ́ mɨngburoko do kére e ịnyị doa gbre (7) mbá mụdụ kɨ́ bɨlámá kúfúye ụ́tụógụyé do kókó kére kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Gɨ do kacɨ́ née ní, zɨ́ ngíti géyị mɨlárá do kére e ịnyị doa gbre (7) mbá kíríkála kpá ụ́tụógụyé do kókó kére kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Zɨ́ do kére bɨ kíríkála ịnyị doa gbre (7) ba ụ́lụ mụdụ ga bɨ kɨ́ bɨlámá kúfúye née mbá. Gɨ ore zɨ́ mongụ́ ngére ꞌbɨ Ízibiti úrúne gɨ sɨmɨ ꞌbí zɨ́a ówo a kɨ́dí yị́ ené ꞌduru. ");
INSERT INTO bdh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kɨ́ phịyị́ a née ní, zɨ́a ndị́sịné sómụ́ ledre née kɨ́ngaya. Née ní zɨ́a kákasa kacɨ́ ꞌyị mála e kɨ́ ꞌyị ꞌbɨ komokenzị ga bɨ sɨmɨ Ízibiti ore ní mbá. Zɨ́ mongụ́ ngére ꞌbɨ Ízibiti lị́kpị́ ꞌduru bɨ ꞌduru wo ní zɨ́ye, tɨ́ lá ꞌyị bɨ nɨ úkuógụ ini ledre gɨ sɨmɨ ꞌduru née zɨ́a ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Zɨ́ ꞌyị íꞌbí leꞌyị́ úku ledre zɨ́ mongụ́ ngére kɨ́dí, “Lúrú aka sɨmɨ lịgị amá. Másómụ́ndíki lúyú ledre amá go. ");
INSERT INTO bdh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Sɨmɨ bɨ kóo mɨmbéꞌdeyị́ esị́ rozé kɨ́ ꞌyị óꞌbó ambata zɨ́yị ꞌdíꞌbi zée ónzó zée sɨmɨ sị́gịnị ꞌbe ꞌbɨ mongụ́ ꞌyị ꞌbɨ ꞌyị óndó bi eyị́ ní, ");
INSERT INTO bdh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","sɨmɨ kémbị́ ndụlụ, zɨ́ze ị́nyịzé gbrengárá ꞌdúꞌduru, ini ledre gɨ sɨmɨ ꞌduru ga gére née mbá kpị́ kpị́ kpị́. ");
INSERT INTO bdh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tɨ́ lá owụ́ ꞌyị ꞌbɨ Ébere nɨ kóo bo kɨ́ze íri. Nɨ ꞌyị ꞌbɨ moko ꞌbe ꞌbɨ mongụ́ ꞌyị bɨ ndịsị lúrú bi do ꞌyị óndó bi bɨ ꞌbe ꞌbɨ mongụ́ ngére ní. Zɨ́ze lị́kpị́ ꞌduru ezé e zɨ́a, zɨ́a úkuógụ ini ledre gɨ sɨmɨyé zɨ́ze. ");
INSERT INTO bdh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Zɨ́ ledre ga bɨ uku yée zɨ́ze ní méngị roné tɨ́ kenée. Zɨ́yị ꞌdíꞌbilúgu máa do bi moko amá káa zɨ́ bɨ kóo ꞌdesị́ ní, zɨ́yị íngíónzó ngíti oꞌdo née.” ");
INSERT INTO bdh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Née ní zɨ́ mongụ́ ngére née kákasa kacɨ́ Yoséfa do geré ꞌdíꞌbiógụ wo gɨ sɨmɨ sị́gịnị gɨrí ꞌdiya. Sɨmɨ bɨ Yoséfa olo doné zɨ́a ésị bɨlámá bongó roné ní, zɨ́ye ꞌdíꞌbi wo ndéré kɨ́e kóꞌdụ́ mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “Máꞌdúꞌduru ꞌyị bɨ zɨ́a úkuógụ ini ledre gɨ sɨmɨ a ní ndaá. Tɨ́ lá ukunɨ́ ledre gɨ royị́ ya útúásá go úkuógụ ini ledre gɨ sɨmɨ ꞌduru née zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Zɨ́ Yoséfa úkulúgu ledre zɨ́ mongụ́ ngére kɨ́dí, “Máútúásá amá úkuógụ ini ledre gɨ sɨmɨa wá, tɨ́ lá Lomo nɨ úkulúgu ledre kacɨ́ a ne zɨ́yị bɨ nɨ útúásá do mɨmbéꞌdeyị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “Máꞌdúꞌduru mááyí mɨtóromá do gbúṛóngó Náyili, ");
INSERT INTO bdh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","zɨ́ mɨngburoko mɨóto ị́tị́ e ịnyị doa gbre (7) kɨ́ bɨlámá sanáye ṛíṛiṛí ólụ́ógụyé gɨ sɨmɨ iní ndị́sị ánu lómí. ");
INSERT INTO bdh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Gɨ do kacɨ́ yée ga gére ní, zɨ́ ngíti géyị mɨlárá rógbó ị́tị́ e ịnyị doa gbre (7) kpá ólụ́ógụyé gɨ sɨmɨ iní cóngó kɨ́rókóye mbá sága. Málúrúndíki aka mɨlárá ị́tị́ e sɨmɨ Ízibiti ona kenée wá. ");
INSERT INTO bdh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Zɨ́ mɨlárá rógbó ị́tị́ ga bɨ kɨ́ cóngó kɨ́rókóye mbá sága ba ánuónzó mɨzefị bɨlámá mɨóto ị́tị́ ga bɨ gáa kɨ́ sanáye ṛíṛiṛí née mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tɨ́ bɨ gɨ do kacɨ́ bɨ anunɨ́ mɨóto ị́tị́ ga gére ní, ꞌyị utúasá úku a bɨ yaá mengịnɨ́ ledre go kenée ní wá. Nɨyí yị́ eyé fú lá rógbóye káa zɨ́ bɨ ꞌdáꞌdá ní. Gɨ ore zɨ́ma úrúma gɨ sɨmɨ ꞌbí. ");
INSERT INTO bdh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Zɨ́ma kpá ꞌdúꞌduru zɨ́ mɨngburoko do kére ịnyị doa gbre mbá mụdụ kɨ́ bɨlámá kúfúye ụ́tụógụyé do kókó kére kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Gɨ do kacɨ́ née ní, zɨ́ ngíti géyị do kére ga bɨ ịnyị doa gbre (7) née ídíye mbá kíríkála kúfúye ndaá kpá wá, ụ́tụógụyé do kókó kére kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Zɨ́ do kére bɨ kíríkála ịnyị doa gbre née ụ́lụ mụdụ ga bɨ kɨ́ bɨlámá kúfúye née mbá. Zɨ́ma lị́kpị́ ꞌduru ba zɨ́ ꞌyị mála e, tɨ́ lá ꞌyị bɨ zɨ́a úkuógụ ini ledre bɨ gɨ sɨmɨ ꞌduru née zɨ́ma ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Zɨ́ Yoséfa úkulúgu ledre zɨ́ mongụ́ ngére kɨ́dí, “ꞌDuru ga bɨ gbre née ní yị́ eyé lá kémbị́ ꞌduru kị́éꞌdo. Lomo ꞌdodo zɨ́yị née ledre bɨ née nɨ ógụ méngị a ní. ");
INSERT INTO bdh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bɨlámá mɨngburoko mɨóto ị́tị́ ga bɨ ịnyị doa gbre (7) née ní, née sɨmɨbi ịnyị doa gbre, mụdụ ga bɨ ịnyị doa gbre (7) née kpá sɨmɨbi ịnyị doa gbre (7). Née yị́ ené lá ledre kị́éꞌdo kpá kémbị́ ꞌduru. ");
INSERT INTO bdh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mɨlárá rógbó ị́tị́ ga bɨ olụ́ogụnɨ́ gɨ ꞌdáꞌba ịnyị doa gbre née kɨ́ kíríkála ga bɨ ịnyị doa gbre (7) née ní, née ꞌbɨ eyé mongụ́ ꞌbú bɨ nɨ útú kɨ́ sɨmɨbi ịnyị doa gbre (7) ní. ");
INSERT INTO bdh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ngére, ledre née nɨ méngị roné tɨ́ cé kenée. Lomo ꞌdódo ledre bɨ née nɨ ógụ méngị a ní go zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sɨmɨbi nɨ ídí ịnyị doa gbre (7) zɨ́ éyị́ mɨánu ndị́sị ídíne zɨ́ ꞌyị e sɨmɨ káṇgá ꞌbɨ Ízibiti ona mbá káa zɨ́ kuꞌdú ní, ");
INSERT INTO bdh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","tɨ́ lá gɨ do kacɨ́ sɨmɨbi máa yée née ní, mongụ́ ꞌbú nɨ ógụ útú kɨ́ sɨmɨbi ịnyị doa gbre (7). ꞌYị e nɨyí sómụ́ lịgị ledre éyị́ mɨánu bɨ kóo nɨ káa zɨ́ kuꞌdú sɨmɨ Ízibiti ní mbá, zɨ́ ꞌbú ndị́sị léwe bi sɨmɨ káṇgá ꞌbɨ Ízibiti dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ꞌYị e utúasánɨ́ sómụ́ndíki ledre éyị́ mɨánu bɨ kóo née wá, gɨ zɨ́a ꞌbú bɨ nɨ ógụ útú gɨ do kacɨ́ a née ní nɨ ídí bɨsinyíne kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sị́ ledre bɨ ꞌduru née ogụ do mongụ́ ngére do mɨsiꞌdiné gbre ní, Lomo oto yeme sómụ́ ledre go gɨ roa bɨlámáne, Lomo nɨ ógụ méngị a luꞌbú lolụ wá. ");
INSERT INTO bdh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Bɨ ba ní ili go zɨ́ mongụ́ ngére gélé ꞌyị ꞌbɨ komokenzị bɨ lurú bi bú sɨmɨ ledre olụ́olụ́ do óto wo zɨ́a lúrú bi do káṇgá ꞌbɨ Ízibiti mbá. ");
INSERT INTO bdh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mongụ́ ngére idí gélé ngíti géyị mɨngburoko ꞌyị e zɨ́ye ꞌdíꞌbi kị́éꞌdo gɨ sɨmɨ ịnyị (5) gɨ sɨmɨ éyị́ mɨánu bɨ nɨ káa zɨ́ kuꞌdú sɨmɨ Ízibiti ona kacɨ́ sɨmɨbi bɨ ịnyị doa gbre (7) née mbá. ");
INSERT INTO bdh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ídí íꞌbí lorụ idínɨ́ kótrụ éyị́ mɨánu ga gére née mbá óto yée ꞌbe ꞌbɨ mongụ́ ngére ꞌbɨ Ízibiti zɨ́a ídíne sɨmɨ gara e káa do éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Éyị́ mɨánu ga gére née idínɨ́ bándá óto yée káa do tóṇgó gɨ ro ꞌyị ga bɨ sɨmɨ káṇgá ba, zɨ́ye ndị́sịyé ánu a gɨ zɨ́ mongụ́ ꞌbú bɨ nɨ ógụ útú sɨmɨ Ízibiti kɨ́ sɨmɨbi ịnyị doa gbre (7) ní, káa bɨ ꞌyị e nɨyí úyuónzó royé gɨ zɨ́ ꞌbú ke.” ");
INSERT INTO bdh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Zɨ́ mɨyéme ledre née útúásáne komo mongụ́ ngére kɨ́ mɨngburoko ꞌyị ꞌbɨ moko ené e. ");
INSERT INTO bdh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Née ní zɨ́ mongụ́ ngére ndúꞌyú ꞌyị ꞌbɨ moko ené e, “Azé útúásá ówo ꞌyị káa zɨ́ oꞌdo ba, bɨ kɨ́ ꞌDówụ́ Lomo sɨmɨné ní gɨ ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Gɨ ore zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “Káa zɨ́ bɨ Lomo óto yị́ị go zɨ́yị ówoyéme ledre mbá bɨlámáne ní, ngíti ꞌyị bɨ zɨ́ze gélé a bɨ nɨ ꞌyị komokenzị, lurú bi bú sɨmɨ ledre olụ́olụ́ káa zɨ́yị ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bɨ kenée ní, mááyí go ógụ óto yị́ị káa do ꞌyị lúrú bi kacɨ́ éyị́ ga bɨ ꞌbe ꞌbɨ amá ona ní mbá. ꞌYị ga bɨ sɨmɨ Ízibiti ona ní nɨyí úwú lorụ mbá gɨ zɨ́yị. Lá gɨ zɨ́a bɨ mááyí mongụ́ ngére ní ꞌbɨ amá rokoꞌbụ nɨ rómo gɨ ꞌbɨ eyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Née ní zɨ́ mongụ́ ngére úku ledre kɨ́dí, “Máóto yị́ị go káa do ꞌyị lúrú bi do káṇgá ꞌbɨ Ízibiti mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Zɨ́ ngére née ꞌdíꞌbi ngoꞌdi ené bɨ ndịsị óto kacɨ́ sị́lị́ne kɨ́e sɨmɨ wáraga gɨ ro sị́lị́ne ní ésị a ro sị́lị́ Yoséfa. Zɨ́a ésị bɨlámá mɨṛíṛiṛí bongó roa. Do kpá íꞌbí nyari bɨ yemenɨ́ gɨ sɨmɨ dábu ní zɨ́ Yoséfa ónzó a goné. ");
INSERT INTO bdh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Zɨ́a íꞌbí arabíya bɨ usáni ndịsị lála ní zɨ́ Yoséfa bɨ nɨ geré do kacɨ́ mị́ngị́ káṇgá ꞌbɨ Ízibiti ní ndị́sị gámáne kɨ́e. Asikíri nɨyí ꞌbɨ eyé ndị́sị gbúrógbó kɨ́dí, “Ídísé ótoómo mɨsiꞌdi fúó.” Née ní zɨ́a óto Yoséfa káa do ꞌyị lúrú bi kacɨ́ káṇgá ꞌbɨ Ízibiti mbá. ");
INSERT INTO bdh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “Máóto yị́ị máa kɨ́ rokoꞌbụmá ꞌbɨ mongụ́ ngére ꞌbɨ káṇgá Ízibiti ba. Ledre bɨ úku go ní, ꞌyị bɨ nɨ óyólóꞌbó a ní ndaá sɨmɨ Ízibiti ona mbá wá.” ");
INSERT INTO bdh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Zɨ́ mongụ́ ngére ócó ịrị do Yoséfa kɨ́dí Zefanáta Panéya. Zɨ́a íꞌbí Aseníta nyị́ ꞌyị ꞌdáná éyị́ bɨ Potifára gɨ sɨmɨ Óno ní zɨ́ Yoséfa káa do meꞌbea. Zɨ́ Yoséfa gámáne sɨmɨ káṇgá ꞌbɨ Ízibiti mbá. ");
INSERT INTO bdh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Sɨmɨbi ꞌbɨ Yoséfa nɨ kóo cị́ kéṛị́ a do sokó (30) sɨmɨ bɨ ólụ́ sɨmɨ moko ꞌbɨ mongụ́ ngére ꞌbɨ Ízibiti ní. Gɨ ro zɨ́a méngị moko ené, zɨ́a ólụ́ógụné gɨ ꞌbe ꞌbɨ mongụ́ ngére ndéré kɨ́ gámáne sɨmɨ káṇgá ꞌbɨ Ízibiti za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sɨmɨ sɨmɨbi ịnyị doa gbre (7) née ní, zɨ́ éyị́ mɨánu ólụ́ógụné kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Zɨ́ Yoséfa kótrụ éyị́ mɨánu ga bɨ olụ́ogụnɨ́ sɨmɨ sɨmɨbi bɨ ịnyị doa gbre (7) née sɨmɨ gara ga bɨ ꞌbɨ Ízibiti ní mbá do óto yée sɨmɨ gbagba ga bɨ sɨmɨ gara ga gére née. Éyị́ mɨánu ga bɨ olụ́ogụnɨ́ gɨ sɨmɨ yáká ga bɨ gbaá dongá gara ga gére mɨkékeṛị́a mbá zɨ́a óto yée sɨmɨ a ore. ");
INSERT INTO bdh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Zɨ́ kére ga bɨ Yoséfa yoko yée ní ídíye ṛụ́ṛụ ṛụ́ṛụ káa zɨ́ sayi ga bɨ iní kotrụ yée kóꞌdụ́ mɨkavu ní. Éyị́ mɨánu ofụ nda kóo go zɨ́a ótoómo kɨ́ ékéóto a bi gɨ zɨ́a bi ndárába ndaá lolụ wá. ");
INSERT INTO bdh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ꞌDáꞌdá gɨ zɨ́ Mongụ́ ꞌbú née kɨ́ útú ne, Aseníta nyị́ ꞌyị ꞌdáná éyị́ bɨ Potifára gɨ sɨmɨ Óno ndiki kóo owụ́ go gbre zɨ́ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yoséfa ịfị́ ịrị owụ́ndíká ené née Manási. Ini Ledre gɨ sɨmɨ a kɨ́dí, “Lomo oto máa go zɨ́ma sómụ́lị́gị ledre ꞌdoꞌdó amá kɨ́ ledre ꞌyị amá ga bɨ zɨ́ babá ꞌbe ní mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ịfị́ ịrị gbre owụ́ ꞌbɨ ené Efarayíma. Ini ledre gɨ sɨmɨ a kɨ́dí sɨmɨ ꞌdoꞌdó amá mbá, “Lomo oto máa go zɨ́ma étrịmá.” ");
INSERT INTO bdh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Zɨ́ sɨmɨbi ịnyị doa gbre (7) bɨ kóo éyị́ mɨánu aná sɨmɨ a kɨ́ngaya sɨmɨ Ízibiti ní ụ́kụ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Zɨ́ bizóró ꞌbɨ ꞌbú bɨ kóo Yoséfa uku ledre a ní tónóne tɨ́ káa zɨ́ bɨ kóo Yoséfa uku ní sɨmɨ ị́rịgbére ga bɨ gbaá ro Ízibiti ní mbá. ꞌBú nɨ tɨ́ bo ní, tɨ́ lá sɨmɨ káṇgá ꞌbɨ Ízibiti mbá éyị́ mɨánu nɨ yị́ ené bo. ");
INSERT INTO bdh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sɨmɨ bɨ ꞌyị ꞌbɨ Ízibiti e otụlurúnɨ́ ndonyo ꞌbú ní, zɨ́ ꞌyị e tónóye íni ini zɨ́ mongụ́ ngére gɨ ro éyị́ mɨánu zɨ́ye. Zɨ́ mongụ́ ngére úku ledre zɨ́ ꞌyị ꞌbɨ Ízibiti e kɨ́dí, “Ndérésé zɨ́ Yoséfa, ledre bɨ uku go zɨ́se ní, ídísé méngị wo.” ");
INSERT INTO bdh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Sɨmɨ bɨ ꞌbú aṇga nda go sɨmɨ káṇgá ꞌbɨ Ízibiti mbá ní, zɨ́ Yoséfa úku ledre idínɨ́ mu tónó úgú kére zɨ́ ꞌyị ꞌbɨ Ízibiti e gɨ zɨ́a ꞌbú nɨ nda kóo go bɨsinyíne kɨ́ngaya sɨmɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Zɨ́ ꞌyị ga bɨ gɨ sɨmɨ ngíti géyị káṇgá e ní ndị́sị ógụyé sɨmɨ Ízibiti ndị́sị úgú kére gɨ zɨ́ Yoséfa gɨ zɨ́a ꞌbú utú kóo go bɨsinyíne sɨmɨ káṇgá ga bɨ do sogo káṇgá ba mbá. ");
INSERT INTO bdh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Sɨmɨ bɨ kóo Yakóbo úwú ledre kɨ́dí kére nɨ bo sɨmɨ Ízibiti ní, zɨ́a úku ledre zɨ́ wotị́ e kɨ́dí, “Éyị́ bɨ ndị́sịsé lá lúrú komosé gɨ roa ona ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Máúwú ledre go kɨ́dí kére nɨ bo sɨmɨ Ízibiti. Ndérésé mu íri úgú kére zɨ́ze káa bɨ azé úyu gɨ zɨ́ ꞌbú.” ");
INSERT INTO bdh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Zɨ́ lúndu Yoséfa e sokó ị́nyịyé ndéréye sɨmɨ Ízibiti úgú kére. ");
INSERT INTO bdh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tɨ́ lá Yakóbo otoomo ené kóo Benzemúna owụ́ lúndu Yoséfa zɨ́ye ndéréye kéye wá káa bɨ ngíti ledre nɨ méngị wo ke. ");
INSERT INTO bdh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Née ní zɨ́ owụ́ ꞌbɨ Yakóbo ídíye dongará ꞌyị ga bɨ kóo nderénɨ́ úgú kére gɨ sɨmɨ Ízibiti ní gɨ zɨ́a mongụ́ ꞌbú utú kóo kpá go sɨmɨ Kanána. ");
INSERT INTO bdh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yoséfa nɨ ne gávana ꞌbɨ káṇgá ꞌbɨ Ízibiti, ndịsịne úgúóyó kére zɨ́ ꞌyị e. Sɨmɨ bɨ lúnduga ogụnɨ́ ní, zɨ́ye ótụ́ doyé bi do káṇgá óto úndrua. ");
INSERT INTO bdh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Sɨmɨ bɨ ogụnɨ́ ní, geré zɨ́ Yoséfa ówo tosoyé kɨ́dí ga ba lúnduné e. Tɨ́ lá ili ené geré gɨ ro ꞌdódo roné zɨ́ye wá, zɨ́a ndị́sị ódroné zɨ́ye fú lá bɨsinyíne kɨ́dí, “Ógụsé gɨ ꞌda?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ogụzé gɨ sɨmɨ káṇgá ꞌbɨ Kanána, úgú kére.” ");
INSERT INTO bdh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Abú Yoséfa owo tɨ́ toso lúnduné e go yá, lúnduga owonɨ́ eyé toso a wá. ");
INSERT INTO bdh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Zɨ́ Yoséfa sómụ́ndíki ꞌduru kóo ꞌduru gɨ royé ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ásé mbeze e. Ógụsé ba lúrú yéme bi bɨ útúásásé go ógụ kɨ́ okó dozé gɨ doa ní.” ");
INSERT INTO bdh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ꞌyị ꞌbɨ moko eyị́ e ogụnɨ́ úgú éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Azé mbá owụ́ ꞌbɨ kémbị́ ꞌyị kị́éꞌdo. Ndazé ezé mbeze e wá.” ");
INSERT INTO bdh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yoséfa ya zɨ́ye ní, “Ṛanga, ógụsé née lúrú yéme bi bɨ útúásásé go ógụ kɨ́ okó dozé gɨ doa ní.” ");
INSERT INTO bdh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ndikinɨ́ ꞌyị ꞌbɨ moko eyị́ e sokó doa gbre (12) mbá owụ́ yaꞌdá e, azé mbá owụ́ ꞌbɨ kémbị́ ꞌbụ kị́éꞌdo, oꞌdo máa née ndịsị ndị́sị sɨmɨ Kanána. Lomo ꞌdiꞌbi ngúruzé go, wo bɨ owụ́ ní nɨ cịkị zɨ́ ꞌbụzé ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yoséfa ya zɨ́ye ní, “Tɨ́ káa zɨ́ bɨ máúku ba, ásé mbeze e. ");
INSERT INTO bdh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mááyí ba ógụ úwú maꞌdíi ledre bɨ gɨ rosé ní, togụ́ ndaá, málóbụ́ sịndị́ ngére ꞌbɨ káṇgá ba go zɨ́se. Ólụ́ógụsé gɨ ona wá ꞌbúó togụ́ owụ́ lúndusé bɨ úkusé ledre a née ogụ go ona. ");
INSERT INTO bdh_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sée mbá ásé ídíáká sɨmɨ sị́gịnị ona. Ngúrusé idí mu ndéréógụ kɨ́ lúndusé bɨ úkusé ledre a née gɨ ro zɨ́ma ówo a kɨ́dí ledre bɨ úkusé ní nɨ maꞌdíi. Togụ́ kenée wá málóbụ́ sịndị́ ngére ꞌbɨ káṇgá ba go zɨ́se ásé mbeze e.” ");
INSERT INTO bdh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Zɨ́a úku ledre do óto yée mbá sɨmɨ sị́gịnị kɨ́ sị́lị́ ota. ");
INSERT INTO bdh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sɨmɨ sị́lị́ ota née, zɨ́a úku ledre zɨ́ye kɨ́dí, “Mááyí kpá ꞌyị óto úndru Lomo. Ledre bɨ mááyí úku a ba, ídísé méngị a gɨ ro zɨ́se ómosé. ");
INSERT INTO bdh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Togụ́ ledre esé nɨ maꞌdíi, ídísé ótoómo ngúrusé sɨmɨ sị́gịnị ona, zɨ́ ngítí se ga gére ꞌdíꞌbi kére ndéré kɨ́e zɨ́ ꞌyị esé e ꞌbe gɨ zɨ́ ꞌbú. ");
INSERT INTO bdh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Zɨ́se ꞌdíꞌbi owụ́ lúndusé bɨ úkusé ledre née gɨrí ógụ kɨ́e. Mááyí ówo a kɨ́dí ledre bɨ úkusé zɨ́ma ní nɨ maꞌdíi. Gɨ ore, ásé ómo ufuzé sée wá.” Zɨ́ye go ṇgúṇgu ledre née. ");
INSERT INTO bdh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Zɨ́ye tónóye ódroyé dengbị́ye kɨ́dí, “Maꞌdíi ndịsịnɨ́ ꞌdóꞌdo zée gɨ ro lúnduzé. Lúrúsé aka káa zɨ́ bɨ kóo lúnduzé nɨ ndị́sị íni ini kɨ́ ṇgúṇgú roné zɨ́ze gɨ ro trịdrịné ní, ꞌdụtụzé mbílíze ngbụ́rụ́ lerị́ a mengị zée wá. Lomo iꞌbí ꞌdoꞌdó go rozé ba.” ");
INSERT INTO bdh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ngúruyé bɨ kɨ́ ịrịné Rụ́bene ya zɨ́ye ní, “Máúku kóo ledre go zɨ́se kɨ́dí ndazé méngị lúnduzé née kenée wá, úwúsé esé e wá. Sáma a ndaꞌba dozé ba gɨ zɨ́ ledre née.” ");
INSERT INTO bdh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Owonɨ́ eyé bɨ kɨ́dí Yoséfa owoyeme ledre bɨ yée ndịsịnɨ́ úku a ba bú ní wá. Gɨ zɨ́a togụ́ ili go úku ledre zɨ́ye yá, ngíti ꞌyị nɨ ógụ ne óyólóꞌbó a sɨmɨ tara bɨ owonɨ́ bú ní. ");
INSERT INTO bdh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Zɨ́a óyó roné gɨ cigíye tónóne íni ini. Zɨ́a ndáꞌbaógụné tónóne ódroné zɨ́ye. Zɨ́a ꞌdíꞌbi Simiyóna gɨ dongaráye do ódó wo do komoyé ore. ");
INSERT INTO bdh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Zɨ́ Yoséfa úku ledre idínɨ́ léfe kére zɨ́ye sɨmɨ kombo eyé e, késị́ eyé e idínɨ́ ótolúgu a zɨ́ye do kére eyé e. Idínɨ́ kpá íꞌbí éyị́ mɨánu bɨ zɨ́ye ndéréye kɨ́ ánu a kacɨ́ mɨsiꞌdi ní. Gɨ do kacɨ́ bɨ mengịnɨ́ ledre ga gére née go zɨ́ye kenée ní, ");
INSERT INTO bdh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","zɨ́ye ị́mbị́óto éyị́ e do dongí eyé e yóó zɨ́ye ndéréye. ");
INSERT INTO bdh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nda go do bi ꞌdúꞌdu kɨ́ ndụlụ, zɨ́ ngúruyé líkpí tara kombo ené gɨ ro ꞌdíꞌbiógụ éyị́ mɨánu íꞌbí a zɨ́ dongí ené ní, nɨ lúrú bi káa ní, zɨ́a ndíki mɨṛíṛiṛí késị́ ené otolugunɨ́ go sɨmɨ kombo ené. ");
INSERT INTO bdh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Zɨ́a úku ledre zɨ́ lúnduné e kɨ́dí, “Iꞌbílugunɨ́ mɨṛíṛiṛí késị́ amá go zɨ́ma, lúrúsé aka nɨ bɨ sɨmɨ kombo amá ba.” Zɨ́ mɨmbéꞌdeyé ꞌdécịné zɨ́ye ndị́sịyé lángbayé zɨ́ye úku ledre dongaráye kɨ́dí, “Éyị́ bɨ Lomo mengị nda zɨ́ze bɨ káa ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Sɨmɨ bɨ nderéogụnɨ́ go zɨ́ ꞌbụyé Yakóbo sɨmɨ Kanána ní, zɨ́ye lị́kpị́ ledre ga bɨ mengịnɨ́ royé íri ní mbá zɨ́a kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mongụ́ ꞌyị bɨ sɨmɨ káṇgá ꞌbɨ Ízibiti íri née, mengị zée bɨsinyíne. Zɨ́a ndị́sịné méngị láráze káa zɨ́ éyị́ bɨ azé mbeze e sɨmɨ káṇgá née ní ní. ");
INSERT INTO bdh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tɨ́ lá zɨ́ze ítí kangú zɨ́a kɨ́dí, ‘Azé yị́ ezé bɨlámá ꞌyị e. Ndazé ezé mbeze e wá. ");
INSERT INTO bdh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ꞌBụzé ndiki zée sokó doa gbre (12) mbá owụ́ yaꞌdá, ngúruzé ndaá lolụ wá, wo bɨ owụ́ ní idíaká go cịkị zɨ́ ꞌbụzé ꞌbe sɨmɨ Kanána.’ ");
INSERT INTO bdh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Zɨ́a úku ledre zɨ́ze kɨ́dí, ‘Gɨ ro zɨ́ma ówo a kɨ́dí ásé bɨlámá ꞌyị e, ídísé ótoómo ngúru lúndusé zɨ́ma ona, zɨ́se ꞌdíꞌbi éyị́ mɨánu ndéré kɨ́e zɨ́ ꞌyị esé e gɨ zɨ́ ꞌbú. ");
INSERT INTO bdh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tɨ́ lá ídísé ꞌdíꞌbiógụ lúndusé bɨ ambáodụ́ née gɨrí ógụ kɨ́e zɨ́ma. Mááyí ówo a kɨ́dí ndásé mbeze e wá ásé yị́ esé bɨlámá ꞌyị e. Gɨ ore mááyí ótoómo sị́lị́ma gɨ ro lúndusé zɨ́se ndị́sị gámáse kɨ́ úgú éyị́ e sɨmɨ káṇgá ba ona.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sɨmɨ bɨ nɨyí ndị́sị léfeóyó kére gɨ sɨmɨ kombo eyé ní, zɨ́ye ndíki owụ́ kombo mɨṛíṛiṛí késị́ eyé e sɨmɨ kombo eyé mɨkékeṛị́a mbá. Zɨ́ ngịrị ledre née méngị yée kɨ́ ꞌbụyé e mbá mɨméngị. ");
INSERT INTO bdh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Zɨ́ ꞌbụyé Yakóbo úku ledre zɨ́ye kɨ́dí, “Ílisé go zɨ́ owụ́ ꞌbɨ amá e ụ́kụ́ye mbá? Yoséfa ndaá lolụ wá, Simiyóna ndaá lolụ kpá wá, bɨ ba ní ílisé go kpá ꞌdíꞌbi Benzemúna. Lerị́ máa nɨ nda ídí romá go cụ́ káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Zɨ́ Rụ́bene úku ledre zɨ́ ꞌbụyé kɨ́dí, “Babá, ídí ótoómo wo do sị́lị́ma, mááyí lúrú bi kacɨ́ a. Togụ́ mándáꞌbaógụ kɨ́e wá, idínɨ́ úfu owụ́ ꞌbɨ amá e gbre do bi kacɨ́ a.” ");
INSERT INTO bdh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Zɨ́ Yakóbo úkulúgu ledre kɨ́dí, “Máótoómo sị́lị́ma gɨ ro Benzemúna zɨ́a útúne do kacɨ́se zɨ́se ndérése kéye sɨmɨ Ízibiti wá. Lúnduga uyunɨ́ go mbá idíaká go lá dụụ́ ne. Togụ́ zɨ́se ꞌdíꞌbi wo née zɨ́a kpá úyuné yá, née go kpá umbumá gɨ zɨ́a mááyí go ngoko ꞌyị.” ");
INSERT INTO bdh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ꞌBú nɨ aka fú lá méngị ꞌyị e kɨ́ngaya sɨmɨ káṇgá bɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Sɨmɨ bɨ Yakóbo kɨ́ owụ́ ꞌbɨ ené e anuonzónɨ́ kére bɨ kóo ogụnɨ́ kɨ́e gɨ sɨmɨ Ízibiti ní go ní, zɨ́ Yakóbo úku ledre zɨ́ wotị́ne e kɨ́dí, “Ndáꞌbasé mu sɨmɨ Ízibiti ndéré úgú ngíti owụ́ yata éyị́ mɨánu zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Zɨ́ Zụ́da úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị bɨ íri née uku kóo ledre zɨ́ze oꞌbụóꞌbụ kɨ́dí togụ́ ógụsé kɨ́ ambáodụ́se wá, ‘Útúásásé lúrú komomá wá.’ ");
INSERT INTO bdh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Togụ́ ótoómo Benzemúna go zɨ́ze ndéréze kéye yá, mɨúgú éyị́ mɨánu nɨ ídí zɨ́ze ꞌdiya. ");
INSERT INTO bdh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tɨ́ lá togụ́ ótoómo sị́lị́yị gɨ roa wá, utúasázé ndéré wá gɨ zɨ́a mongụ́ ꞌyị née uku kɨ́dí togụ́ ógụsé kɨ́ ambáodụ́se née wá, ‘Útúásásé lúrú komomá wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Zɨ́ Yakóbo úku ledre kɨ́dí, “Méngịsé kéyị zɨ́ma bɨsinyíne káa gɨ zɨ́ ꞌdi, bɨ zɨ́se úku ledre zɨ́ oꞌdo née íri kɨ́dí ngíti lúndusé nɨ bo ní?” ");
INSERT INTO bdh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Oꞌdo née nduꞌyú zée do bɨlámá mɨsiꞌdi gɨ ro ówo ledre bɨ gɨ do bizé kɨ́ ꞌyị ꞌbe ꞌbɨ ezé e kɨ́dí, ‘ꞌBụsé nɨ bo trịdrị? Ngíti lúndusé nɨ kpá bo?’ Zɨ́ze úkulúgu ledre zɨ́a kacɨ́ nduꞌyú ené. Bɨ kenée ní azé ówo a bɨ kɨ́dí nɨ úku ledre yaá, ‘Idízé ógụ kɨ́ lúnduzé ní’ káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Zɨ́ Zụ́da úku ledre zɨ́ ꞌbụyé kɨ́dí, “Ótoómo sị́lị́yị mu gɨ ro owụ́ née zɨ́ze ndéréze kéye úgú éyị́ mɨánu, gɨ zɨ́ wo bɨ zée kése kɨ́ owụ́ ꞌbɨ ezé e, azé úyu mbá gɨ zɨ́ ꞌbú ní. ");
INSERT INTO bdh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mááyí ídí máa ꞌyị lúrú bi kacɨ́ a. Áyí ndúꞌyú máa gɨ roa. Togụ́ mándáꞌbaógụ kɨ́e óto wo kóꞌdụ́yị wá, mááyí go máa bɨsinyí ꞌyị kɨ́ngaya gɨ ro ledre ené. ");
INSERT INTO bdh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Idí ndazé lúꞌbú káa zɨ́ ba wá, káa bɨ nderé andázé rozé ba go kɨ́ꞌdí gbre.” ");
INSERT INTO bdh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Zɨ́ ꞌbụyé Yakóbo úku ledre zɨ́ye kɨ́dí, “Togụ́ kenée yá, ídísé méngị ledre ba. Ídísé ꞌdíꞌbi ngíti géyị bɨlámá éyị́ ga bɨ gɨ sɨmɨ káṇgá ba gɨ ona sɨmɨ kombo esé e ndéré íꞌbí a zɨ́ oꞌdo née káa do tákpásị́lị́. Kpá kɨ́ éyị́ ga bɨ káa zɨ́ sụꞌbụ́ mɨndonyo, tezị, kágá ụkụ́, nda kɨ́ ngíti géyị kágá ga bɨ nɨyí bo ní ndéré kɨ́e zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ídísé ꞌdíꞌbi mɨṛíṛiṛí késị́ mongụ́ne gɨ ro togụ́ ógụsé go íri yá, késị́ máa wo bɨ kóna iꞌbílugunɨ́ zɨ́se ní, zɨ́se íꞌbí a. Éyị́ née kenée iꞌbíluyúnɨ́ née kóo mɨíꞌbílúyú. ");
INSERT INTO bdh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ꞌDíꞌbisé lúndusé mu zɨ́se ị́nyịsé ndáꞌbasé zɨ́ oꞌdo née íri. ");
INSERT INTO bdh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Lomo bɨ kɨ́ rokoꞌbụné kɨ́ngaya ní, idí ị́drị mɨmbéꞌde oꞌdo née rosé gɨ ro zɨ́a íꞌdí sị́lị́ne gɨ ro lúndusé bɨ íri ní zɨ́se ndáꞌbaógụsé kéye kɨ́ Benzemúna e mbá bɨlámáse. Togụ́ ꞌbɨ amá ledre go dụụ́ zɨ́ owụ́ ꞌbɨ amá e ndị́sị úyuyé yá, mengị éyị́ wá, idí mu kenée.” ");
INSERT INTO bdh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Zɨ́ye ꞌdíꞌbi tákpásị́lị́ ga bɨ yemenɨ́ yée ní, kɨ́ yata mɨṛíṛiṛí késị́ nda kɨ́ lúnduyé Benzemúna yóó zɨ́ye ndéréye sɨmɨ Ízibiti, do ndéréógụyé zɨ́ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sɨmɨ bɨ Yoséfa lúrú kɨ́dí ꞌdiꞌbiogụnɨ́ Benzemúna go ní, zɨ́a úku ledre zɨ́ ꞌyị bɨ ndịsị lúrú bi kacɨ́ ꞌbe ꞌbɨ ené ní kɨ́dí, “ꞌDíꞌbi yaꞌdá ga gére née ndéré kɨ́ye zɨ́ma ꞌbe. Zɨ́yị óṇgoónzó bangá zɨ́yị méngị éyị́ mɨánu zɨ́ze kéye kɨ́ yana kadra.” ");
INSERT INTO bdh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Zɨ́ oꞌdo née méngị tɨ́ ledre ga bɨ Yoséfa uku yée ní, do ꞌdíꞌbi yée ꞌbe ꞌbɨ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Sɨmɨ bɨ ꞌdiꞌbiotonɨ́ yée go ꞌdị́cị́ ní, zɨ́ ngịrị méngị yée kɨ́ngaya. Zɨ́ye ndị́sịyé sómụ́ ledre kɨ́dí, “ꞌDiꞌbiogụnɨ́ zée ꞌdị́cị́ kɨ́ra ba goó gɨ ro ledre késị́ ga bɨ kóo otolugunɨ́ yée sɨmɨ kombo ezé sɨmɨ mɨzefị ógụ bɨ ogụzé ona ní tée. Ayí gɨ ro ꞌdíꞌbingéṛị zée zɨ́ne ndị́sịné méngị láráze gɨ ro zɨ́ne ꞌdíꞌbi dongí ezé e gɨ ro zɨ́ne óto zée káa do owụ́kụlụ́ e.” ");
INSERT INTO bdh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Née ní zɨ́ye ndéréye zɨ́ ꞌyị lúrú bi kacɨ́ ꞌbe ꞌbɨ Yoséfa née úku ledre zɨ́a sɨmɨ bɨ nɨyí go ku mbotụ ní. ");
INSERT INTO bdh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Zɨ́ye úku ledre zɨ́ ꞌyị ꞌbɨ moko née kɨ́dí, “Lúrú aka, ogụzé kóo go ꞌdáꞌdá ona úgú éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Sɨmɨ bɨ nderéogụzé go do bi ꞌdówụ́ro azé líkpí tara kombo ezé e ní, zɨ́ze ndíki késị́ ezé e otolugunɨ́ go sɨmɨ kombo ezé e. Bɨ ba ní ndaꞌbaogụzé go kɨ́e nɨ goó ba. ");
INSERT INTO bdh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Owozé wá, togụ́ ambí otolugu késị́ máa née ne yá? Ogụzé kpá go kɨ́ yata késị́ gɨ ro úgú ngíti éyị́ mɨánu kɨ́e zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Zɨ́ ꞌyị ꞌbɨ moko née úku ledre kɨ́dí, “Ndásé éré ngịrị wá. Ambí owone, Lomo bɨ ndị́sịsé íni ini zɨ́a kɨ́ ꞌbụsé e ní iꞌbílugu mɨṛíṛiṛí késị́ née ba ne zɨ́se. Wo bɨ kóo úgúsé kére kɨ́e ní, mándíki kóo go cé.” Nda gɨ ore zɨ́a ꞌdíꞌbiógụ Simiyóna zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Zɨ́a ꞌdíꞌbi yée ésị yée ꞌdị́cị́ kacɨ́ Yoséfa, íꞌbí iní zɨ́ye lúgu sịndị́ye kɨ́e. Zɨ́a kpá íꞌbí éyị́ mɨánu zɨ́ dongí eyé e. ");
INSERT INTO bdh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Zɨ́ye ꞌdíꞌbiógụ éyị́ ga bɨ ogụnɨ́ kɨ́ye gɨ ro íꞌbí a zɨ́ Yoséfa káa do tákpásị́lị́ ní óto yée nzíyiyé gɨ zɨ́a uwúnɨ́ go kɨ́dí yée nɨyí ánu éyị́ mɨánu kɨ́ Yoséfa e. ");
INSERT INTO bdh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sɨmɨ bɨ Yoséfa ndaꞌbaogụ go ꞌbe ní, zɨ́ye íꞌbí tákpásị́lị́ ga bɨ ogụnɨ́ kɨ́e ní zɨ́a, zɨ́ye útú lóꞌbụ komoyé bi óto úndrua. ");
INSERT INTO bdh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Zɨ́ Yoséfa ndúꞌyú ledre sɨmɨ sanáye kpá kɨ́ ledre ngoko ꞌbụyé kɨ́dí, “Ngoko ꞌbụsé bɨ úkusé ledrea zɨ́ma ona ní nɨ káa be ꞌdi? Nɨ aka kɨ́ komoné?” ");
INSERT INTO bdh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “ꞌBụzé bɨ ꞌyị ꞌbɨ moko eyị́ ní, nɨ bo kɨ́ komoné kɨ́ sanáne bɨlámáne.” Zɨ́ye ótụ́ doyé bi óto úndru a. ");
INSERT INTO bdh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Zɨ́a lúrú bi kere, zɨ́a ónzó komoné ro Benzemúna bɨ owụ́ ꞌbɨ mbágáa ní. Zɨ́a ndúꞌyú yée kɨ́dí, “Née owụ́ lúndusé bɨ úkusé ledre a zɨ́ma ní?” Zɨ́a ị́nyịné úku ledre kɨ́dí, “Lomo idí méngị bɨlámá ledre zɨ́yị owụ́ ꞌbɨ amáa.” ");
INSERT INTO bdh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Zɨ́ sɨmɨkozo méngị wo do komo lúndua ore zɨ́a gbúgbuógụné sága lúrúsóꞌdo bi bɨ née nɨ íni ini doa ní. Zɨ́a ólụ́ne ngúcuné ꞌdị́cị́ ené íni ini íri. ");
INSERT INTO bdh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Zɨ́a ụ́tụ sɨmɨné do lúgu komoné, zɨ́a ndáꞌbalúgu roné dongaráye. Zɨ́a úku ledre kɨ́dí, “ꞌDíꞌbiógụsé éyị́ mɨánu mu.” ");
INSERT INTO bdh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Zɨ́ye ꞌdíꞌbióto éyị́ mɨánu ꞌbɨ Yoséfa ngúcuné, ꞌbɨ lúnduga kpá ngúcuyé, ꞌyị ga bɨ ꞌbɨ Ízibiti bɨ ndịsịnɨ́ ánu éyị́ kéye ní kpá ngúcuyé, gɨ zɨ́a ꞌyị ꞌbɨ Ízibiti e anu kotrụnɨ́ éyị́ kɨ́ ꞌyị ꞌbɨ Ébere wá, ndịsịnɨ́ lúrúcáyi ꞌyị ꞌbɨ Ébere e mɨlúrúcáyi. ");
INSERT INTO bdh_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Otonɨ́ bi ndị́sị zɨ́ lúndu Yoséfa e mbá kacɨ́ mɨndíki yée. Tónóne gɨ ro wo bɨ ndíká ní, ndéréógụné gị ro ambáodụ́ye. Zɨ́ tarayé ị́drị́ne sɨmɨ bɨ lurúnɨ́ ledre née kenée ní. ");
INSERT INTO bdh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ndịsịnɨ́ ꞌdíꞌbikása éyị́ mɨánu zɨ́ye gɨ do tarabíza bɨ kóꞌdụ́ Yoséfa ní. Éyị́ mɨánu bɨ iꞌbínɨ́ zɨ́ Benzemúna ní nɨ mongụ́ne rómo ꞌbɨ lúnduga ga gére née kɨ́ꞌdí ịnyị. Née ní zɨ́ye ánu éyị́ kɨ́ éwé éyị́ do ídíye kɨ́ Yoséfa e mbá kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Zɨ́ Yoséfa úku ledre zɨ́ ꞌyị moko bɨ ndịsị lúrú bi kacɨ́ ꞌbe ꞌbɨ ené ore ní kɨ́dí, “Ídí léfe kére cị́ꞌdị́ sɨmɨ kombo ꞌbɨ ꞌyị ga gére née útúásáne kacɨ́ rokoꞌbụ bɨ zɨ́ye gɨ ro ị́mbị́ a ní. Zɨ́yị ꞌdíꞌbi késị́ eyé ótolúgu a zɨ́ye do kére máa ga gére née. ");
INSERT INTO bdh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Zɨ́yị óto kóꞌdo amá bɨ gɨ sɨmɨ mɨṛíṛiṛí késị́ ní do kére bɨ ꞌbɨ owụ́ lúnduyé ní, ndro kɨ́ késị́ ené bɨ iꞌbí gɨ ro kére ní.” Zɨ́ ꞌyị ꞌbɨ moko née méngị ledre ga gére née tɨ́ káa zɨ́ bɨ Yoséfa úku zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Akpa kɨ́ sị́ ndóndó do íꞌdí sị́lị́ ꞌyị gɨ royé kɨ́ dongí eyé e yóó do ndéréye. ");
INSERT INTO bdh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sɨmɨ bɨ nderénɨ́ aka kpálá ca gɨ sɨmɨ yana gara ní, zɨ́ Yoséfa úku ledre zɨ́ ꞌyị ꞌbɨ moko bɨ ndịsị lúrú bi kacɨ́ ꞌbe ꞌbɨ ené ní kɨ́dí, “ꞌDiꞌdiya, ngásá lódụ́ kacɨ́ ꞌyị ga bɨ gáa ba mu, togụ́ ngásá ndíki yée go yá, ídí úku ledre zɨ́ye kɨ́dí, ‘Méngịlúgusé bɨsinyí ledre do bi kacɨ́ bɨlámá ledre gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ba ndaá kóꞌdo bɨ mongụ́ ꞌyị amá ndịsị éwé éyị́ sɨmɨ a zɨ́a kpá ndị́sị lúrú ledre ené e sɨmɨ a ní wá? Méngịsé bɨsinyí ledre go kɨ́ngaya.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Sɨmɨ bɨ ꞌyị ꞌbɨ moko née ngasá ndiki yée ní, zɨ́a úku ledre ga gére née zɨ́ye tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, úku lárá ledre zɨ́ze kenée gɨ zɨ́ ꞌdi? Zée ꞌyị ꞌbɨ moko eyị́ e utúasázé méngị kéyị kenée wá. ");
INSERT INTO bdh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Lúrú aka, késị́ ga bɨ kóo ndikizé yée do kére ezé e ní, ndaꞌbaogụzé kóo kɨ́e kú gɨ sɨmɨ káṇgá ꞌbɨ Kanána íꞌbílúgu a zɨ́yị. Éyị́ bɨ azé nda úgu mɨṛíṛiṛí késị́ togụ́ mbú dábu gɨ ꞌbe ꞌbɨ mongụ́ ꞌyị eyị́ gɨ roa ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Togụ́ ndíki mɨṛíṛiṛí kóꞌdo née goó sɨmɨ éyị́ kacɨ́ ngúruzé, idínɨ́ geré úfu wo ꞌdáꞌba, zɨ́ ngítíze née ídíákáye káa do owụ́kụlụ́ sị́ sị́lị́yị.” ");
INSERT INTO bdh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Zɨ́ oꞌdo née úku ledre kɨ́dí, “Bɨlámáne, idí mu ídí káa zɨ́ bɨ úkusé née. Tɨ́ lá ꞌyị bɨ nɨyí ndíki wo kɨ́ mɨṛíṛiṛí kóꞌdo née zɨ́ne ní, nɨ ídí owụ́kụlụ́ zɨ́ma, ngítíse nɨyí ídíáká kɨ́ ro doyé.” ");
INSERT INTO bdh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Geré née ní zɨ́ye ị́mbị́óto kombo eyé e do tónóye líkpí tarayé. ");
INSERT INTO bdh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Zɨ́ oꞌdo née tónóne gámásóꞌdo sɨmɨ éyị́ eyé e. Tonó kɨ́ ndíká ndéréógụné ro ambáodụ́ye. Zɨ́a ndíki kóꞌdo sɨmɨ éyị́ kacɨ́ Benzemúna bɨ ambáodụ́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Zɨ́ ledre née sínyíne royé bɨsinyíne, zɨ́ye tónóye lófo bongó gɨ royé. Zɨ́ye ékị́lúgu royé do dongí eyé e ndáꞌbayé ꞌdáꞌba kɨ́ꞌdí bɨ ịnyịnɨ́ gáa gɨ sɨmɨ gara ní. ");
INSERT INTO bdh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Nɨyí ógụ ní, Yoséfa nɨ aka fú mɨndị́sịné ꞌbe. Zɨ́ Zụ́da kɨ́ lúnduné e ógụ útúye bi kóꞌdụ́ a kenée. ");
INSERT INTO bdh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Zɨ́ Yoséfa úku ledre zɨ́ye kɨ́dí, “Éyị́ bɨ méngịsé née kenée ꞌdi? Ówosé esé bɨ kɨ́dí ꞌyị káa zɨ́ ma ba nɨ kɨ́ rokoꞌbụ ꞌbɨ lúrúndíki ledre e ní wá?” ");
INSERT INTO bdh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Zɨ́ Zụ́da úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, azé úku a ba kɨ́dí ꞌdi? Azé úku a bɨ kɨ́dí azé bɨlámá ꞌyị e ní lárá a káa be ꞌdi? Lomo ꞌdodo ogụ lúyú ledre ezé go sága. Bɨ ba ní azé go mbá owụ́kụlụ́ eyị́ e, ndaá lá dụụ́ wo bɨ ndikinɨ́ kóꞌdo zɨ́a née wá.” ");
INSERT INTO bdh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Zɨ́ Yoséfa úkulúgu ledre zɨ́a kɨ́dí, “Éyị́ ndaá kenée wá, lá dụụ́ ꞌyị bɨ ndikinɨ́ kóꞌdo zɨ́a ní nɨ ídíákáne káa do owụ́kụlụ́ amá. Sée ga bɨ ledre esé ndaá ní, ásé ndáꞌba zɨ́ ꞌbụsé ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Née ní zɨ́ Zụ́da ndósoógụné gị ro Yoséfa úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, máówo bú rokoꞌbụ bɨ zɨ́yị ní nɨ gbóo kɨ́ ꞌbɨ mongụ́ ngére, ị́drị aka mɨmbéꞌdeyị́, ledre nɨ taramá máíli úku a zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ndúꞌyú kóo zée kɨ́dí ꞌbụzé nɨ aka bo kɨ́ komoné yá? Ngíti géyị lúnduzé e nɨyí kpá bo yá? ");
INSERT INTO bdh_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ukuluguzé kóo ledre go zɨ́yị kɨ́dí, ‘Ngoko ꞌbụzé nɨ aka bo kɨ́ ambáodụ́ ené bɨ ndikinɨ́ zɨ́a do ngokoné ní. Tɨ́ lá mongụ́ lúndua bɨ nɨyí kéne gɨ sɨmɨ mbágá kị́éꞌdo ní uyune. ꞌBụzé iliofụ ledre owụ́ máa née go gɨ zɨ́a bɨ nɨ nda go lá ngúcuné gɨ sɨmɨ mbágáne ní.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Zɨ́yị úku ledre zɨ́ze kɨ́dí, idízé ógụ kɨ́ owụ́ máa née zɨ́yị, gɨ ro zɨ́yị lúrú wo. ");
INSERT INTO bdh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Zɨ́ze kóo úkulúgu ledre zɨ́yị kɨ́dí, ‘Owụ́ née utúasá ótoómo ꞌbụné e wá, togụ́ nderéoyó roné gɨ cigí ꞌbụné go yá, ꞌbụa née nɨ geré úyu.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tɨ́ lá zɨ́yị úku ledre zɨ́ze kɨ́dí, ꞌbúó togụ́ ogụzé go kɨ́ owụ́ lúnduzé née yá, azé fú lúrú komoyị́. ");
INSERT INTO bdh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sɨmɨ bɨ nderéogụzé zɨ́ ꞌyị ꞌbɨ moko eyị́ bɨ ꞌbụzé ní, zɨ́ze úku kúrúyị née zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Née ní zɨ́ ꞌbụzé úku ledre kɨ́dí, ‘Ndáꞌba ándásé rosé mu úgú yata éyị́ mɨánu zɨ́ze.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tɨ́ lá zɨ́ze úkulúgu ledre zɨ́a kɨ́dí, ‘Utúasázé ndéré wá ꞌbúó togụ́ owụ́ lúnduzé ba ní nderé go kɨ́ze. Togụ́ nderézé ngúcuzé utúasázé lúrú komo oꞌdo née wá ꞌbúó togụ́ nderézé go ndro kɨ́ owụ́ lúnduzé.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Zɨ́ ꞌbụzé úkulúgu ledre zɨ́ze kɨ́dí, ‘Ówosé bú bɨlámáne kɨ́dí meꞌbemá Rayéle ndiki kóo owụ́ e zɨ́ma dụụ́ gbre. ");
INSERT INTO bdh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ngúruyé ịndrị go, zɨ́ma úku ledre kɨ́dí, “Maꞌdíi bangá sinyí lófo bayi wo go kụ́ṛị́ kụ́ṛị́.” Tɨ́ bɨ kóo née ní zaá gị ba málúrú komoa wá. ");
INSERT INTO bdh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Togụ́ ꞌdíꞌbisé kpá wo ba go gɨ zɨ́ma zɨ́ ngíti ledre ndíki wo íri yá, lerị́ bɨ ótosé romá née nɨ úfu máa gɨ zɨ́a mááyí go ngoko ꞌyị.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Bɨ née ní mongụ́ ꞌyị, togụ́ ndaꞌbazé zɨ́ ꞌbụzé ꞌdáa owụ́ ba ndaá yá, bɨ ꞌbú owụ́ ba ofụ do ꞌbụa go ní, ");
INSERT INTO bdh_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","zɨ́a ówo a yaá ndaꞌbaogụzé go ngúcuzé owụ́ née ndaá yá, nɨ geré úyu. Lerị́ bɨ nɨ ólụ́ roa née nɨ úfu wo gɨ zɨ́a nɨ yị́ ené go ngoko ꞌyị. ");
INSERT INTO bdh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mááyí máa ꞌyị lúrú bi kacɨ́ a zɨ́ma ꞌdíꞌbilúgu wo zɨ́ babá ꞌbe kɨ́ bɨlámá sanáne. Zɨ́ma kóo go lólóbụ́ zɨ́ babá kɨ́dí, ‘Togụ́ mándáꞌbaógụ kɨ́e wá, lúyú ledre née idí ídí ꞌbɨ amá za fí.’ ");
INSERT INTO bdh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Gɨ zɨ́ kéyị née ní, máṇgúṇgú romá zɨ́yị mongụ́ ꞌyị, máídí ídíáká zɨ́yị ona káa do owụ́kụlụ́, owụ́ née idínɨ́ mu ndáꞌba kɨ́ lúnduné. ");
INSERT INTO bdh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mááyí ndáꞌbalúgu romá zɨ́ babá lárá a káa be ꞌdi togụ́ ndaꞌbazé kɨ́ owụ́ née wá ní? Ndá ótoómo máa zɨ́ma lúrú lerị́ bɨ nɨ ógụ ro babá gɨ zɨ́ sómụ́ ledre bɨ gɨ ro owụ́ née ní wá.” ");
INSERT INTO bdh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yoséfa utúasá ụ́tụ sɨmɨné do komo ꞌyị moko ga bɨ mɨtóroyé kóꞌdụ́ a ore ní wá, zɨ́a úku ledre kɨ́ kúrúne ꞌdága kɨ́dí, “ꞌYị e idínɨ́ ólụ́ógụ gɨ do komoné gɨ ona mbá sága.” Née ní sɨmɨ bɨ ꞌyị e olụ́ogụnɨ́ ní, zɨ́a úku ledre gɨ do biné zɨ́ lúnduné e. ");
INSERT INTO bdh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Zɨ́a útúne íni ini kɨ́ kúrúne ꞌdága zɨ́ ꞌyị ꞌbɨ Ízibiti e úwú doa. Zɨ́ ꞌyị ga bɨ ꞌbe ꞌbɨ mongụ́ ngére ní úwú ledre máa née. ");
INSERT INTO bdh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Zɨ́ Yoséfa úku ledre zɨ́ lúnduné e kɨ́dí, “Ba máa Yoséfa, lúndusé. Babá nɨ aka tɨ́ kɨ́ komoné?” Tɨ́ lá lúnduga utúasánɨ́ úkulúgu ledre zɨ́a wá, gɨ zɨ́ ngịrị a bɨ nɨ kóꞌdụ́ye née. ");
INSERT INTO bdh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Zɨ́ Yoséfa úku ledre zɨ́ lúnduné e kɨ́dí, “Ídísé ndósoógụ gbóo romá.” Sɨmɨ bɨ ndoso ogụnɨ́ ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ba máa Yoséfa lúndusé bɨ kóo úgúóyósé zɨ́ ꞌyị ꞌbɨ Ízibiti e ní. ");
INSERT INTO bdh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bi ndaá sínyí rosé zɨ́ mɨmbéꞌdesé ésị́ne rosé gɨ zɨ́a bɨ kóo úgúóyósé máa ní wá. Lomo ꞌdiꞌbiogụ máa ne ꞌdáꞌdá yáa gɨ ro yómo ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Gɨ zɨ́a ba aka lá dụụ́ gbre sɨmɨbi ꞌbɨ ꞌbú bɨ utú do ꞌyị e ní. Sɨmɨbi nɨ aka ꞌdáꞌdá ịnyị (5), ꞌyị óꞌdo éyị́ gɨ ro ꞌdíꞌbiógụ éyị́ mɨánu ndaá. ");
INSERT INTO bdh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Lomo ꞌdiꞌbiogụ máa ne zɨ́se ꞌdáꞌdá yána gɨ ro yómo sée gɨ sɨmɨ bizóró ba, gɨ ro zɨ́se ídíse kɨ́ bulúndusé e trịdrị. ");
INSERT INTO bdh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ꞌDíꞌbiógụsé esé máa ona se wá, yị́ ené Lomo. Oto máa go zɨ́ma ídíma mongụ́ ꞌyị lúrú bi kacɨ́ mongụ́ ngére kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e mbá, kpá kɨ́ rokoꞌbụ zɨ́ma do ꞌyị e kɨ́ éyị́ ga bɨ sɨmɨ Ízibiti ona ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Bɨ ba ní ị́nyịsé mu zɨ́se ndáꞌbasé zɨ́ babá úku ledre zɨ́a kɨ́dí, ‘Ba ledre bɨ wotị́yị Yoséfa uku ní. Lomo oto máa go zɨ́ma ídíma ngére do Ízibiti e mbá. Ídí mu ógụ ꞌdiya zɨ́ma yána. ");
INSERT INTO bdh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Áyí ógụ ndị́sị sɨmɨ ị́rịgbére bɨ Gósene ní gɨ ro zɨ́yị ídíyị dongáma. Yị́ị, owụ́ ꞌbɨ eyị́ e kɨ́ bulúnduyị́ e kɨ́ bangá eyị́ e nda kɨ́ ngíti géyị éyị́ eyị́ ga bɨ ꞌbɨ ꞌbe ní mbá. ");
INSERT INTO bdh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mááyí lúrú bi kacɨ́se íri, gɨ zɨ́a sɨmɨbi ꞌbɨ mongụ́ ꞌbú bɨ utú do ꞌyị e ba nɨ aka ꞌdáꞌdá ꞌdényé sɨmɨbi ịnyị (5). Káa bɨ sée kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ esé e nda kɨ́ ngíti géyị éyị́ esé e ásé úyu gɨ zɨ́ ꞌbú ke.’ ");
INSERT INTO bdh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Lúrúsé go cụ́ kɨ́ rosé, lúndumá Benzemúna owo kpá go kɨ́dí maꞌdíi máa Yoséfa mándị́sị ódro zɨ́se ba tɨ́ máa. ");
INSERT INTO bdh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ndérésé mu zɨ́se lị́kpị́ ledre rokoꞌbụ bɨ mááyí kɨ́e do ꞌyị ꞌbɨ Ízibiti e kɨ́ ledre ga bɨ lúrúsé yée yána cụ́ kɨ́ komosé ní zɨ́ babá. Zɨ́se ꞌdíꞌbiógụ wo zɨ́ma yána ꞌdiya.” ");
INSERT INTO bdh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Zɨ́a ị́nyịné fáka lúnduné Benzemúna zɨ́a íni ini roa, zɨ́ Benzemúna kpá fáka wo íni ini roa. ");
INSERT INTO bdh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Zɨ́a ndéréne kɨ́ fáka lúnduné e kɨ́ ndị́sị íni ini royé. Gɨ do kacɨ́ a née ní zɨ́ lúnduga nda tónóye ódroyé zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sɨmɨ bɨ sanda nderéogụ zɨ́ mongụ́ ngére kɨ́dí, lúndu Yoséfa ogụnɨ́ go ní, zɨ́ mongụ́ ngére kɨ́ ꞌyị ené e ídíye mbá kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “Ídí úku ledre zɨ́ lúnduyị́ e, ‘Ị́mbị́ótosé éyị́ e mu do dongí esé e, zɨ́se ndáꞌbalúgu rosé sɨmɨ káṇgá ꞌbɨ Kanána. ");
INSERT INTO bdh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Idínɨ́ ꞌdíꞌbiógụ ꞌbụyị́ kɨ́ ꞌyị ꞌbe ꞌbɨ esé e mbá zɨ́ma yána. Mááyí íꞌbí bɨlámá bi zɨ́ye sɨmɨ Ízibiti ona, gɨ ro zɨ́ye kpá ndị́sị ánu bɨlámá éyị́ bɨ ꞌbɨ káṇgá ba.’ ");
INSERT INTO bdh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ídí kpá úku ledre zɨ́ye idínɨ́ ꞌdíꞌbi arabíya gɨ sɨmɨ Ízibiti gɨ ona kpa gɨ ro ꞌdíꞌbi meꞌbeyé e kɨ́ owụ́ e, zɨ́ye ꞌdíꞌbiútú ꞌbụyị́ gɨrí ógụ kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ndásé sómụ́ ledre éyị́ e wá, gɨ zɨ́a bɨlámá éyị́ ga bɨ sɨmɨ Ízibiti ona ní, nɨyí ídí mbá ꞌbɨ esé.” ");
INSERT INTO bdh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Née ní zɨ́ owụ́ ꞌbɨ Yakóbo e méngị tɨ́ ledre ga bɨ mongụ́ ngére uku zɨ́ye ní. Zɨ́ Yoséfa íꞌbí arabíya zɨ́ye kɨ́ éyị́ mɨánu bɨ nɨyí ánu a do mɨsiꞌdi ní tɨ́ káa zɨ́ bɨ mongụ́ ngére úku ledre a zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Zɨ́ Yoséfa íꞌbí mɨkánda bongó zɨ́ye kacɨ́ye cé. Tɨ́ lá zɨ́a íꞌbí ꞌbɨ Benzemúna bongó ịnyị kɨ́ mɨṛíṛiṛí késị́ míya ota (300). ");
INSERT INTO bdh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Zɨ́a íꞌbí kása éyị́ e káa zɨ́ ga ba zɨ́ ꞌbụné, yaꞌdá dongí e sokó (10) mbá kɨ́ bɨlámá éyị́ ga bɨ gɨ sɨmɨ Ízibiti ore ní doyé, mbágá dongí e kpá sokó mbá kɨ́ kére e, ambata e nda kɨ́ ngíti géyị éyị́ mɨánu bɨ ꞌbụa nɨ ánu a kacɨ́ mɨsiꞌdi ní doyé. ");
INSERT INTO bdh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Zɨ́a íꞌbí mɨsiꞌdi zɨ́ lúnduné e zɨ́ye ndéréye. Zɨ́ Yoséfa úku ledre zɨ́ye sɨmɨ bɨ nɨyí go ndéré ní kɨ́dí, “Ndásé ndéré kɨ́ ófụ́ do mɨsiꞌdi wá.” ");
INSERT INTO bdh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Zɨ́ye ị́nyịyé gɨ sɨmɨ Ízibiti ndáꞌbayé zɨ́ ꞌbụyé Yakóbo sɨmɨ káṇgá ꞌbɨ Kanána. ");
INSERT INTO bdh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Zɨ́ye úku ledre zɨ́ ꞌbụyé kɨ́dí, “Yoséfa nɨ bo trịdrị. Nɨ ne kɨ́ rokoꞌbụ zɨ́ne do káṇgá bɨ Ízibiti ní mbá.” Zɨ́ Yakóbo ndị́sịné ónzó komoné gɨ zɨ́a ṇgúṇgu ené kóo ledre eyé née wá. ");
INSERT INTO bdh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tɨ́ lá sɨmɨ bɨ lịkpị́nɨ́ ledre ga bɨ Yoséfa ꞌdicí yée mbá zɨ́a ní, nda sɨmɨ bɨ lurú arabíya ga bɨ Yoséfa kasa yée gɨ ro do ꞌdíꞌbi wo gɨrí sɨmɨ a ní, zɨ́ lomo ro ꞌbụyé Yakóbo ndáꞌbaógụné roa. ");
INSERT INTO bdh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Zɨ́ Yakóbo úku ledre kɨ́dí, “Maꞌdíi, máṇgúṇgu go. Owụ́ ꞌbɨ amá Yoséfa nɨ bo trịdrị. Mááyí ógụ ndéré lúrú wo ꞌdáꞌdá zɨ́ma kɨ́ úyumá.” ");
INSERT INTO bdh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Née ní zɨ́ Yakóbo kókụ́ éyị́ ené e mbá, nda sɨmɨ bɨ nderéogụ sɨmɨ Bị́rịsába ní, zɨ́a ꞌdáná éyị́ zɨ́ Lomo bɨ kóo ꞌbụa Isáka ndịsị óto úndrua ní ore. ");
INSERT INTO bdh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nda go kɨ́ ndụlụ, zɨ́ Lomo ꞌdódo roné zɨ́ Yakóbo sɨmɨ ꞌduru do úku ledre zɨ́a kɨ́dí, “Yakóbo.” Zɨ́a úkulúgu ledre zɨ́a kɨ́dí, “Ɨɨ́ Ngére.” ");
INSERT INTO bdh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Zɨ́ Lomo úku ledre zɨ́a kɨ́dí, “Mááyí Lomo bɨ kóo ꞌbụyị́ ndịsị óto úndrua ní. Ngịrị ndaá méngị yị́ị kɨ́ ndéré sɨmɨ Ízibiti wá, gɨ zɨ́a mááyí ógụ íꞌbí úndru zɨ́yị, zɨ́yị ndíkiógụ tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌyịmaꞌdí e íri. ");
INSERT INTO bdh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mááyí ꞌdị́yịóto yị́ị gị sɨmɨ Ízibiti. Zɨ́ma kpá ꞌdíꞌbilúgu yị́ị gɨrí. Áyí úyu do sị́lị́ mbigí wotị́yị Yoséfa.” ");
INSERT INTO bdh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Zɨ́ Yakóbo ị́nyịné gɨ sɨmɨ Bị́rịsába gɨ ore, zɨ́ owụ́ ꞌbɨ ené e ꞌdíꞌbi wo kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ eyé e mbá sɨmɨ arabíya bɨ mongụ́ ngére iꞌbí gɨ ro do ꞌdíꞌbi wo kɨ́e ní. ");
INSERT INTO bdh_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Zɨ́ye kpá ꞌdíꞌbi za bangá eyé e kɨ́ éyị́ eyé ga bɨ ꞌbɨ ꞌbe ga bɨ ndikinɨ́ sɨmɨ káṇgá bɨ Kanána ní, zɨ́ye ndéréye sɨmɨ Ízibiti. Zɨ́ Yakóbo ꞌdíꞌbi bulúnduné e mbá kɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Zɨ́a ꞌdíꞌbi wotị́ne e, bulúnduné ga bɨ owụ́ yaꞌdá e ní, kɨ́ nyị́ne e, teténe e mbá sɨmɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ꞌYị ga bɨ ꞌbɨ Yakóbo nderé kɨ́ye sɨmɨ Ízibiti ní, nɨyí, Rụ́bene owụ́ndíká ené, ");
INSERT INTO bdh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Wotị́ Rụ́bene nɨyí ꞌbɨ eyé, Anóka, Pálụ, Ézorono nda kɨ́ Karamí. ");
INSERT INTO bdh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyóna, wotị́ga nɨyí ꞌbɨ eyé, Zemụwéle, Zamína, Oyáda, Zakíni, Zóra, nda Sálo wo bɨ mbágáa ꞌbɨ ené nyị́ ꞌyị ꞌbɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lévị, wotị́ga nɨyí ꞌbɨ eyé, Geresóna, Káta, kɨ́ Miráré. ");
INSERT INTO bdh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zụ́da, wotị́ga nɨyí ꞌbɨ eyé, Éra, Onána, Séla, Peréze nda kɨ́ Zéra. (Éra e kɨ́ Onána uyunɨ́ ꞌbɨ eyé cịkị sɨmɨ Kanána.) Owụ́ ꞌbɨ Peréze ꞌbɨ eyé, Ézorono e kɨ́ Amụ́lụ. ");
INSERT INTO bdh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakára, wotị́ga nɨyí ꞌbɨ eyé, Tóla, Púwa, Zasụ́ba nda kɨ́ Simaróna. ");
INSERT INTO bdh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebụlụ́na, wotị́ga nɨyí ꞌbɨ eyé, Seréda, Elóna, Zaléle. ");
INSERT INTO bdh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sɨmɨ bɨ Léya ndiki owụ́ ga gére née zɨ́ Yakóbo sɨmɨ Padána Aráma ní, zɨ́a ndíki owụ́kára dongaráye kị́éꞌdo kɨ́ ịrịné Dína. Owụ́ ga gére née nɨyí kóo mbá cị́ kéṛị́ a doa sokó doa ota (33). ");
INSERT INTO bdh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gáda, wotị́ga nɨyí ꞌbɨ eyé, Zefóna, Ági, Sụ́ni, Ezebóno, Érị, Aródi, nda kɨ́ Aréli. ");
INSERT INTO bdh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aséra, wotị́ga nɨyí ꞌbɨ eyé, Imána, Isáva, Isívi, nda kɨ́ Beríya. Ịrị lémịyé Séra. Owụ́ ꞌbɨ Beríya ꞌbɨ eyé, Ebére e kɨ́ Malakéle. ");
INSERT INTO bdh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ga ba ịrị owụ́ ga bɨ Yakóbo ndikinɨ́ yée kɨ́ Zílifa kára ꞌyị ꞌbɨ moko bɨ Labána iꞌbí wo zɨ́ nyị́ne Léya ní. Nɨyí ꞌbɨ eyé mbá sokó doa ịnyị doa kéṛị́ (16). ");
INSERT INTO bdh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Wotị́ Yakóbo ga bɨ gɨ sɨmɨ Rayéle ní, nɨyí dụụ́ gbre, Yoséfa e kɨ́ Benzemúna. ");
INSERT INTO bdh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nda sɨmɨ Ízibiti íri, zɨ́ Aseníta, nyị́ Potifára ꞌyị ꞌdáná éyị́ bɨ gɨ sɨmɨ Óno ní, ndíki Manási e kɨ́ Efarayíma zɨ́ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wotị́ Benzemúna nɨyí ꞌbɨ eyé, Béla, Béka, Asebéla, Géra, Námana, Éyị, Rósa, Mupíma, Apị́ma nda kɨ́ Aráda. ");
INSERT INTO bdh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ga ba ꞌbɨ eyé bulúndu Yakóbo ga bɨ gɨ sɨmɨ Rayéle ní, nɨyí mbá sokó doa eso (14). ");
INSERT INTO bdh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wotị́ Dána nɨ ꞌbɨ ené, Ụsị́ma. ");
INSERT INTO bdh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wotị́ Nafatáli nɨyí ꞌbɨ eyé, Zazéle, Gụ́nị, Zezére nda kɨ́ Siléma. ");
INSERT INTO bdh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ga ba ꞌbɨ eyé bulúndu Yakóbo ga bɨ gɨ sɨmɨ Bíla bɨ owụ́kára ꞌyị ꞌbɨ moko bɨ Labána iꞌbí zɨ́ nyị́ne Rayéle ní, nɨyí mbá ịnyị doa gbre (7). ");
INSERT INTO bdh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bulúndu Yakóbo ga bɨ nderénɨ́ kɨ́ Yakóbo sɨmɨ Ízibiti ní, nɨyí mbá cị́ ota doa ịnyị doa kéṛị́ (66). Olonɨ́ kará ꞌbɨ owụ́ e wá. ");
INSERT INTO bdh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Nda kɨ́ owụ́ ꞌbɨ Yoséfa ga bɨ ndiki yée gbre sɨmɨ Ízibiti ní, zɨ́ owụ́ ga bɨ sị́ sịndị́ Yakóbo ní ídíye mbá cị́ ota doa sokó (70). ");
INSERT INTO bdh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakóbo kasaokpó Zụ́da ꞌdáꞌdá zɨ́ Yoséfa sɨmɨ Ízibiti gɨ ro zɨ́a ógụné sóngó yée sɨmɨ gara bɨ Gósene ní. Sɨmɨ bɨ nderéogụnɨ́ nda goó sɨmɨ Gósene ní, ");
INSERT INTO bdh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","zɨ́ Yoséfa ékị́ne sɨmɨ arabíya ené ndéréne sɨmɨ Gósene sóngó ꞌbụné Yakóbo. Sɨmɨ bɨ ndikínɨ́ ní, zɨ́ Yoséfa fáka ꞌbụné, zɨ́a íni ini kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Zɨ́ Yakóbo úku ledre zɨ́ Yoséfa kɨ́dí, “Bɨ ba ní, abú máúyu yá máúyu sara íri, málúrú komoyị́ go, máówo go kɨ́dí áyí bo trịdrị.” ");
INSERT INTO bdh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Née ní zɨ́ Yoséfa úku ledre zɨ́ lúnduné e kɨ́ ꞌyị ga bɨ ꞌbɨ ꞌbụné e ní mbá kɨ́dí, “Nɨ mɨútúásáne zɨ́ma ndéréma úku ledre zɨ́ mongụ́ ngére kɨ́dí, ‘Lúndumá e kɨ́ ꞌyị ga bɨ ꞌbɨ babá ní ogụnɨ́ gɨ sɨmɨ Kanána go zɨ́ma ona. ");
INSERT INTO bdh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nɨyí yị́ eyé ꞌyị ụ́lụ́ bangá e, ꞌdiꞌbiogụnɨ́ kábịṛị́kị e, ína e, ị́tị́ e kɨ́ ngíti géyị éyị́ eyé e go mbá kɨ́ye.’ ");
INSERT INTO bdh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Sɨmɨ bɨ mongụ́ ngére ndolo sée go nduꞌyú sée kɨ́dí, ‘Moko esé nɨ ꞌdíya yá?’ ");
INSERT INTO bdh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ídísé úkulúgu ledre zɨ́a kɨ́dí, ‘Azé yị́ ezé ꞌyị ụ́lụ́ bangá e kú gɨ do owụ́ze káa zɨ́ bɨ kóo mɨngburoko ꞌyị ezé e ndịsịnɨ́ méngị a ní.’ Gɨ ore nɨ ótoómo sée zɨ́se ndị́sịsé sɨmɨ ị́rịgbére bɨ Gósene ní, gɨ zɨ́a ꞌyị ga bɨ ꞌbɨ Ízibiti ní, ilinɨ́ ndị́sị kótrụ royé kɨ́ ꞌyị ụ́lụ́ bangá e wá.” ");
INSERT INTO bdh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Zɨ́ Yoséfa ndéréne úku ledre zɨ́ mongụ́ ngére, kɨ́dí, “Babá kɨ́ lúndumá e ogụnɨ́ go gɨ sɨmɨ Kanána ona. ꞌDiꞌbiogụnɨ́ kábịṛị́kị e, ína e, ị́tị́ e kɨ́ ngíti géyị éyị́ eyé e go mbá kɨ́ye sɨmɨ ị́rịgbére bɨ Gósene ní.” ");
INSERT INTO bdh_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yoséfa ꞌdiꞌbiutú lúnduné ga bɨ ịnyị (5) née ndéré ꞌdódo yée zɨ́ mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Zɨ́ mongụ́ ngére ndúꞌyú yée kɨ́dí, “Ndị́sịsé méngị moko ꞌdi?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, azé yị́ ezé ꞌyị ụ́lụ́ bangá e cé káa zɨ́ ꞌbɨ bulúnduzé e ní. ");
INSERT INTO bdh_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ogụzé go ndị́sị ca sɨmɨ káṇgá ba ona, gɨ zɨ́a mongụ́ ꞌbú utú go bɨsinyíne sɨmɨ káṇgá ꞌbɨ Kanána, éyị́ bɨ zée kɨ́ bangá ezé e zɨ́ze ánu a ní ndaá lolụ wá. Bɨ ba ní ṇguṇgúzé rozé zɨ́yị, ídí ṇgúṇgu a zɨ́ze ndị́sịzé sɨmɨ Gósene ona.” ");
INSERT INTO bdh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Zɨ́ mongụ́ ngére úku ledre zɨ́ Yoséfa kɨ́dí, “ꞌBụyị́ e kɨ́ lúnduyị́ e ogụnɨ́ go zɨ́yị, ");
INSERT INTO bdh_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","káṇgá ꞌbɨ Ízibiti nɨ do sị́lị́yị, ídí óto ꞌbụyị́ e kɨ́ lúnduyị́ e idínɨ́ ídí sɨmɨ bɨlámá bi bɨ Gósene ní. Togụ́ lúrú ngíti géyị ꞌyị e nɨyí bo dongaráye bɨ nɨyí mɨútúásáye ní, ídí óto yée zɨ́ye ndị́sịyé lúrú bi kacɨ́ bangá amá e.” ");
INSERT INTO bdh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Née ní zɨ́ Yoséfa ꞌdíꞌbiógụ ꞌbụné Yakóbo ꞌdódo wo zɨ́ mongụ́ ngére. Gɨ do kacɨ́ bɨ Yakóbo íꞌbí mandá zɨ́ mongụ́ ngére ní, ");
INSERT INTO bdh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","zɨ́ mongụ́ ngére ndúꞌyú wo kɨ́dí, “Sɨmɨbi eyị́ nɨ goó ndu?” ");
INSERT INTO bdh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Zɨ́ Yakóbo úkulúgu ledre zɨ́a kɨ́dí, “Sɨmɨbi amá nɨ go mbá míya kị́éꞌdo doa cị́ kéṛị́ a doa sokó (130). Sɨmɨbi amá ndaá za káa zɨ́ ꞌbɨ bulúndumá e wá. Tɨ́ lá mándị́sị yéme romá wá, mágámá lící romá go kɨ́ngaya gɨ zɨ́ ꞌdoꞌdó.” ");
INSERT INTO bdh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Zɨ́ Yakóbo íꞌbí mandá zɨ́ mongụ́ ngére, zɨ́a ị́nyịné yóó ókpóne. ");
INSERT INTO bdh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Née ní zɨ́ Yoséfa íꞌbí bɨlámá bi zɨ́ ꞌbụné e kɨ́ lúnduné e ndị́sịyé sɨmɨ a sɨmɨ Ízibiti, do bɨlámá bi gbóo kɨ́ gara bɨ kɨ́ ịrịné Ramasé káa zɨ́ bɨ mongụ́ ngére uku ní. ");
INSERT INTO bdh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Zɨ́ Yoséfa íꞌbíógụ éyị́ mɨánu zɨ́ ꞌbụné e kɨ́ lúnduné e kɨ́ ꞌyị ga bɨ ꞌbe ꞌbɨ eyé e ní zɨ́a útúásáne kacɨ́ye kɨ́ owụ́ e mbá. ");
INSERT INTO bdh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Éyị́ mɨánu ndaá lolụ kóo zɨ́ ꞌyị e sɨmɨ káṇgá e mbá wá gɨ zɨ́a ꞌbú utú go bɨsinyíne kɨ́ngaya, gɨ zɨ́ kéyị née zɨ́ rokoꞌbụ ꞌyị ꞌbɨ Ízibiti kɨ́ Kanána ụ́kụ́ne goó mɨụ́kụ́ gɨ zɨ́ ꞌbú. ");
INSERT INTO bdh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Zɨ́ Yoséfa ꞌdóꞌdụ́yóko késị́ ga bɨ ugúnɨ́ kére kɨ́e sɨmɨ káṇgá ꞌbɨ Ízibiti kɨ́ káṇgá ꞌbɨ Kanána ní mbá, zɨ́a ꞌdíꞌbi késị́ née ndéré kɨ́e óto a ꞌbe ꞌbɨ mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sɨmɨ bɨ késị́ ụkụ́ gɨ zɨ́ ꞌyị ꞌbɨ Ízibiti e kɨ́ ꞌyị ꞌbɨ Kanána e go ní, zɨ́ ꞌyị ꞌbɨ Ízibiti e ógụyé zɨ́ Yoséfa do úku ledre zɨ́a kɨ́dí, “Íꞌbí éyị́ mɨánu mu zɨ́ze. Azé go úyu gɨ zɨ́ ꞌbú. Késị́ ụkụ́ gɨ zɨ́ze go.” ");
INSERT INTO bdh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Zɨ́ Yoséfa úkulúgu ledre zɨ́ye kɨ́dí, “Ídísé ógụ kɨ́ bangá e esé zɨ́ma, zɨ́ma íꞌbí éyị́ mɨánu doa zɨ́se togụ́ késị́ esé ụkụ́ go mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Née ní zɨ́ye ꞌdíꞌbiógụ bangá eyé e zɨ́ Yoséfa, zɨ́a íꞌbí éyị́ mɨánu zɨ́ye do usáni eyé e, kábịṛị́kị eyé e, ína eyé e ị́tị́ eyé e, kpá dongí eyé e. Sɨmɨ Sɨmɨbi máa née ní zɨ́ Yoséfa ndị́sịné íꞌbí éyị́ mɨánu zɨ́ye do bangá eyé e. ");
INSERT INTO bdh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Sɨmɨ bɨ sɨmɨbi née ụkụ́ go ní, zɨ́ ꞌyị e kpá ógụyé zɨ́ Yoséfa úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, utúasázé ótoécị ledre gɨ zɨ́yị wá. Késị́ ezé e kɨ́ bangákụlụ́ ezé e nɨyí go mbá ꞌbɨ eyị́. Owụ́ éyị́ bɨ idíaká cúkuꞌdée káa gɨ ro zɨ́ze íꞌbí a zɨ́yị ní ndaá lolụ wá. Odụ éyị́ ga bɨ idíakánɨ́ go lá dụụ́ kụṛụꞌbụzé kɨ́ gbékpị́ káṇgá bɨ zɨ́ze ní. ");
INSERT INTO bdh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Azé úyu zɨ́ káṇgá ezé e sínyíye tɨ́ do komoyị́ káa gɨ ro ꞌdi? Azé úgúóyó kụṛụꞌbụzé kɨ́ káṇgá ezé e zɨ́yị gɨ ro éyị́ mɨánu, zɨ́ze ídíze kɨ́ káṇgá ezé e mbá owụ́kụlụ́ ꞌbɨ mongụ́ ngére. Zɨ́yị íꞌbí kúfú zɨ́ze gɨ ro zɨ́ze ꞌdị́yị́ a bɨ nɨ óto zée zɨ́ze ídíze trịdrị kpá káa bɨ ꞌyị bɨ zɨ́a ndị́sịné sɨmɨ káṇgá née ndaá lolụ wá.” ");
INSERT INTO bdh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Zɨ́ Yoséfa úgú bi ga bɨ sɨmɨ Ízibiti ní mbá zɨ́ mongụ́ ngére. ꞌYị ꞌbɨ Ízibiti e ugúoyónɨ́ bi eyé go mbá, gɨ zɨ́a ꞌbú mengị nda kóo yée go kɨ́ngaya. Bi ga bɨ sɨmɨ Ízibiti ore ní mbá nda goó ꞌbɨ mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Zɨ́ Yoséfa óto ꞌyị e zɨ́ye ídíye go mbá owụ́kụlụ́ ꞌbɨ mongụ́ ngére ꞌbɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Odụ ꞌyị ga bɨ kóo ugú bi eyé wá ní dụụ́ ꞌyị ꞌdáná éyị́ e, gɨ zɨ́a mongụ́ ngére ndị́sị kóo íꞌbí sáká éyị́ ꞌbɨ mɨánu zɨ́ ꞌyị ꞌdáná éyị́ e kacɨ́ kadra mbá. Éyị́ mɨánu máa bɨ kóo gɨ zɨ́ mongụ́ ngére ní, ndịsị kóo ásá kɨ́ye. Née sị́ ledre bɨ ugúoyónɨ́ bi eyé e gɨ zɨ́a wá ní. ");
INSERT INTO bdh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Zɨ́ Yoséfa úku ledre zɨ́ ꞌyị e kɨ́dí, “Bɨ ba ní máúgú sée kɨ́ bi esé e go mbá zɨ́ mongụ́ ngére. Kúfú nɨ goó ba zɨ́se óꞌdo a yáká esé e. ");
INSERT INTO bdh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tɨ́ lá sɨmɨ bɨ sịndị́ kadra ꞌbɨ ꞌdíꞌbiógụ éyị́ gɨ yáká ogụ go ní, zɨ́se ífi sɨmɨ a ịnyị. Kémbị́ a gɨ sɨmɨ ịnyị née zɨ́se íꞌbí a zɨ́ mongụ́ ngére. Zɨ́ ngítí a ídíne káa do kúfú kɨ́ éyị́ mɨánu zɨ́se kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ esé e.” ");
INSERT INTO bdh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Zɨ́ye úkulúgu ledre kɨ́dí, “Mongụ́ ꞌyị, yómo trịdrịzé go. Azé kɨ́ rokinyi zɨ́ze ídíze káa do owụ́kụlụ́ e zɨ́ mongụ́ ngére.” ");
INSERT INTO bdh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Née ní zɨ́ Yoséfa óto ledre née zɨ́a ídíne káa do lorụ gɨ ro bi ga bɨ sɨmɨ Ízibiti ní kɨ́dí kị́éꞌdo gɨ sɨmɨ ịnyị (5) ꞌbɨ éyị́ ga bɨ nɨyí ꞌdíꞌbiógụ a gɨ yáká ní, nɨ ídí ꞌbɨ mongụ́ ngére. Lorụ née nɨ fú lá kenée gị karaba. Bi bɨ ngárá ndaá ꞌbɨ mongụ́ ngére wá ní, dụụ́ bi ꞌbɨ ꞌyị ꞌdáná éyị́ e. ");
INSERT INTO bdh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Sɨmɨ sịndị́ kadra máa née ní zɨ́ Isɨréle e óto ꞌbe ꞌbɨ eyé sɨmɨ Ízibiti sɨmɨ ị́rịgbére bɨ Gósene ní. Zɨ́ye ndíki tụ́ꞌdụ́ éyị́ e íri, do étrịyé zɨ́ye ídíye tụ́ꞌdụ́. ");
INSERT INTO bdh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakóbo ndịsị kóo sɨmɨ Ízibiti íri kɨ́ sɨmɨbi sokó doa ịnyị doa gbre (17). Sɨmɨbi bɨ Yakóbo mengị ní, nɨ kóo mbá míya kị́éꞌdo cị́ gbre doa ịnyị doa gbre (147). ");
INSERT INTO bdh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sɨmɨ bɨ sịndị́ kadra nɨ go gbóo zɨ́ Yakóbo úyuné ní, zɨ́a ndólo Yoséfa úku ledre zɨ́a kɨ́dí, “Togụ́ ꞌbúma nɨ tɨ́ doyị́ ídí óto sị́lị́yị ro kótóma zɨ́yị lólóbụ́ zɨ́ma yaá née utúasá óto máa sɨmɨ Ízibiti ona wá. ");
INSERT INTO bdh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sɨmɨ bɨ togụ́ máúyu go ní, ídí ndéré óto umbumá kɨ́ꞌdí bɨ otonɨ́ bulúndumá e ní.” Zɨ́ Yoséfa úkulúgu ledre zɨ́a kɨ́dí, “Mááyí méngị a káa zɨ́ bɨ úku ní.” ");
INSERT INTO bdh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Zɨ́ Yakóbo úku ledre zɨ́a kɨ́dí, “Ídí lólóbụ́ gɨ ro zɨ́ma ówo a.” Nda née ní zɨ́ Yoséfa lólóbụ́ zɨ́a, zɨ́ Yakóbo ótụ́ doné bi gɨ do ṛangba ené íni ini zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nda gɨ do kacɨ́ ngíti géyị sịndị́ kadra e zɨ́ sanda ndéréne zɨ́ Yoséfa kɨ́dí, “ꞌBụyị́ nɨ kɨ́ ndíyá kɨ́ngaya.” Zɨ́ Yoséfa ꞌdíꞌbi wotị́ne ga bɨ gbre, Manási e kɨ́ Efarayíma ní kpa kɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sɨmɨ bɨ ukunɨ́ ledre zɨ́ Yakóbo kɨ́dí, “Wotị́yị Yoséfa ogụ go lúrú yị́ị ní,” zɨ́a óꞌbụ roné ị́nyịné ndị́sịné tara ṛangba ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Zɨ́ Yakóbo úku ledre zɨ́ Yoséfa kɨ́dí, “Lomo bɨ kɨ́ rokoꞌbụné kɨ́ngaya ní ꞌdodo kóo roné zɨ́ma sɨmɨ Lụ́zụ sɨmɨ káṇgá bɨ Kanána ní, zɨ́a kóo íꞌbí úndru zɨ́ma, ");
INSERT INTO bdh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","zɨ́a úku ledre zɨ́ma kɨ́dí, ‘Mááyí óto yị́ị zɨ́yị étrịyị́ kɨ́ngaya, zɨ́ bulúnduyị́ e ndíkiógụ ṛị́kị́ sị́ do ꞌyịmaꞌdí e. Mááyí karanée íꞌbí káṇgá ba zɨ́yị kɨ́ bulúnduyị́ ga bɨ nɨyí ógụ gɨ do kacɨ́yị ní za fí, zɨ́a ídíne káa do ꞌbɨ eyé.’ ");
INSERT INTO bdh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Bɨ ba ní wotị́yị ga bɨ ndikinɨ́ yée zɨ́yị gbre sɨmɨ káṇgá ꞌbɨ Ízibiti ona ꞌdáꞌdá zɨ́ma kɨ́ ógụmá zɨ́yị sɨmɨ káṇgá ꞌbɨ Ízibiti ní, nɨyí go ógụ ídí wotị́ma e, Efarayíma e kɨ́ Manási. Nɨyí go ógụ ídí zɨ́ma káa zɨ́ Rụ́bene e kɨ́ Simiyóna bɨ nɨyí wotị́ma e ní. ");
INSERT INTO bdh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Owụ́ ga bɨ gɨ do kacɨ́ye ní, nɨyí nda ídí go ꞌbɨ eyị́ e. Éyị́ sị́lị́ bɨ nɨyí ógụndíki a ní, nɨ ógụ gɨ zɨ́ Manási e kɨ́ Efarayíma. ");
INSERT INTO bdh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ledre nɨ gɨ ro mbágáyị káa. Sɨmɨ bɨ máị́nyị gɨ sɨmɨ Padána zɨ́ Rayéle úyuné do mɨsiꞌdi sɨmɨ káṇgá ꞌbɨ Kanána ní, zɨ́a kóo íꞌbí mongụ́ sómụ́ ledre zɨ́ma. Efaráta bɨ ndịsịnɨ́ kpá ndólo a Beteléme ní nɨ aka yị́ ené kóo gbála, zɨ́ze kóo óto wo cịkị do mɨsiꞌdi ore.” ");
INSERT INTO bdh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sɨmɨ bɨ Yakóbo lurú wotị́ Yoséfa ga gére ní, zɨ́a ndúnduꞌyú kɨ́dí, “Owụ́ ga gére née náambi e?” ");
INSERT INTO bdh_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Zɨ́ Yoséfa úkulúgu ledre zɨ́ ꞌbụné kɨ́dí, “Babá, née owụ́ ga bɨ Lomo iꞌbí yée zɨ́ma ona ní.” Yakóbo ya zɨ́a ní, “Ógụ kɨ́ye zɨ́ma yána, gɨ ro zɨ́ma íꞌbí úndru zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Komo Yakóbo lurú lolụ kóo bi mbị́ wá gɨ zɨ́ ngoko, gɨ zɨ́ kéyị née ní, utúasá lúrú bi bɨlámáne wá. Née ní zɨ́ Yoséfa ꞌdíꞌbiógụ wotị́ne ga gére née gbóo ro Yakóbo, zɨ́ ꞌbụa fáka yée roné íꞌbí úndru zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Zɨ́a úku ledre zɨ́ Yoséfa kɨ́dí, “Máówo amá lolụ kóo bɨ kɨ́dí mááyí lúrú komoyị́ ní wá. Bɨ ba ní Lomo otoomo máa go zɨ́ma kpá lúrú owụ́ e gɨ sɨmɨyị́.” ");
INSERT INTO bdh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Zɨ́ Yoséfa ị́mbị́óyó yée gɨ do sịndị́ Yakóbo do útúlóꞌbụ komoné bi. ");
INSERT INTO bdh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Zɨ́ Yoséfa ꞌdíꞌbi yée gbrengárá, zɨ́a óto Efarayíma zɨ́ Yakóbo do ngelị do óto Manási do anú. ");
INSERT INTO bdh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Zɨ́ Yakóbo ngílífi sị́lị́ne. Zɨ́a óto sị́lị́ne ꞌbɨ anú do Efarayíma bɨ nɨ owụ́ ní. Do nda óto sị́lị́ne ꞌbɨ ngelị do Manási bɨ ndíká ní. ");
INSERT INTO bdh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Zɨ́a íꞌbí úndru zɨ́ Yoséfa do úku ledre kɨ́dí, “Lomo bɨ kóo bulúndumá Abarayáma ndịsị óto úndrua ní, zɨ́ babá Isáka kpá ndị́sịné óto úndrua ní, nɨ kpá Lomo bɨ ndịsị lúrú bi kacɨ́ma gị karaba ní ní. ");
INSERT INTO bdh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nɨ ne Lomo bɨ lúrú bi kacɨ́ma sɨmɨ ledre e za mbá ní, idí íꞌbí úndru zɨ́ owụ́ ga ba Ịrịmá idí ndị́sị ówụ́ doyé, zɨ́ ịrị babá Abarayáma kɨ́ ịrị Isáka kpá ndị́sị ówụ́ne doyé Idínɨ́ étrị tụ́ꞌdụ́ do sogo káṇgá.” ");
INSERT INTO bdh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Sɨmɨ bɨ Yoséfa lurú ꞌbụné oto nda yị́ ené sị́lị́ne ꞌbɨ anú do Efarayíma ní, zɨ́ bi sínyíne roa. Zɨ́a ị́nyịné gɨ ro ꞌdíꞌbióyó sị́lị́ ꞌbụné ꞌbɨ anú gɨ do Efarayíma gɨ ro óto a do Manási. ");
INSERT INTO bdh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Zɨ́ Yoséfa úku ledre zɨ́ ꞌbụné kɨ́dí, “Babá, owụ́ndíká nɨ ba óto sị́lị́yị ꞌbɨ anú doa.” ");
INSERT INTO bdh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tɨ́ lá Yakóbo asi yị́ ené mɨási. Zɨ́a úku ledre kɨ́dí, “Máówo bú, owụ́ ꞌbɨ amáa, máówo bú. Bulúndu Manási nɨyí kpá ídí tụ́ꞌdụ́. Tɨ́ lá bulúndu Efarayíma nɨyí ídí tụ́ꞌdụ́ rómo do ꞌbɨ Manási, bulúnduga nɨyí ndíkiógụ tụ́ꞌdụ́ sị́ do ꞌyịmaꞌdí e.” ");
INSERT INTO bdh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Zɨ́ Yakóbo íꞌbí úndru zɨ́ye sɨmɨ sị́lị́ bɨ kóo née zɨ́a úku ledre kɨ́dí, “Karanée Isɨréle e nɨyí ndị́sị ndólo ịrịsé sɨmɨ bɨ ilinɨ́ go íꞌbí úndru ní. Nɨyí úku ledre kɨ́dí, ‘Lomo idí íꞌbí úndru zɨ́yị káa zɨ́ bɨ iꞌbí úndru zɨ́ Efarayíma e kɨ́ Manási ní.’ ” Née mɨsiꞌdi bɨ kóo Yakóbo oto Efarayíma kɨ́e ꞌdáꞌdá zɨ́ Manási ní. ");
INSERT INTO bdh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Née ní, zɨ́ Yakóbo úku ledre zɨ́ Yoséfa kɨ́dí, “Káa zɨ́ bɨ lúrú go née, málúꞌbú lolụ gɨ do kacɨ́ ba kɨ́ngaya wá. Tɨ́ lá Lomo nɨ lúrú bi kacɨ́se zɨ́a ꞌdíꞌbilúgu sée sɨmɨ káṇgá ꞌbɨ bulúndusé e. ");
INSERT INTO bdh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Bɨ ba ní, máíꞌbí Sekéme go zɨ́yị ndaá zɨ́ lúnduyị́ e wá. Née bɨlámá ị́rịgbére bɨ kóo máꞌdíꞌbi gɨ zɨ́ ezeokóma e Amóra e ní.” ");
INSERT INTO bdh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Zɨ́ Yakóbo ndóloyóko wotị́ne e úku ledre zɨ́ye kɨ́dí, “Ídísé yóko rosé mbá do bi kị́éꞌdo gɨ ro ledre bɨ karanée nɨ méngị roné zɨ́se ní zɨ́ma úku a zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ídísé yóko rosé zɨ́se úwú ledre ba sée wotị́ Yakóbo e. Ídísé úwú kúrúma kúrú ꞌbụsé, Isɨréle. ");
INSERT INTO bdh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rụ́bene áyí owụ́ndíká amá, áyí yị́ị rokoꞌbụ amá, mándíki yị́ị sɨmɨ bɨ kóo mááyí aka do sịndị́ma ní. Áyí yị́ị kɨ́ úndruyị́ kpá kɨ́ rokoꞌbụ zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Áyí cakaba tɨ́ lá káa zɨ́ mongụ́ ngbuṛu ní, cóngó ledre bɨ zɨ́a ídíne gɨ do biyị́ ní ndaá, gɨ zɨ́a ndị́sị go kɨ́ meꞌbe ꞌbụyị́ káa do kára bi ꞌdúꞌdu amá azá goó gɨ zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyóna e kɨ́ Lévị ásé do lúndu, ásé ídí ꞌbɨ esé ꞌyị méngị okó kɨ́ mɨngburoko maku ga bɨ do sị́lị́se née ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Máútúásá úku yéme ledre gɨ royé e wá, máútúásá kpá ólụ́ sɨmɨ ledre eyé e wá, gɨ zɨ́a ufunɨ́ ꞌyị e goó kɨ́ mɨmbéꞌdekesị́ bɨ zɨ́ye ní, zɨ́ye ndị́sịyé kɨ́ ꞌdéwe sịndị́ ị́tị́ ꞌbɨ ꞌyị e káa zɨ́ bɨ ilinɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Máóto taramá goó kacɨ́ mɨmbéꞌdekesị́ esé née bɨsinyíne, sɨmɨkesị́ esé née ofụ nda go. Bulúndusé e nɨyí báyi faa dongará kúfú Isɨréle e mbá. ");
INSERT INTO bdh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Zụ́da, lúnduyị́ e nɨyí ndị́sị mbófo yị́ị, zɨ́ye ndị́sị óto úndruyị́ gɨ zɨ́a áyí rómo komo ezeokóyị e. ");
INSERT INTO bdh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Áyí ídí káa zɨ́ kemị ní, nɨ nánáónzó bangá ené togụ́ anu go zɨ́a lérené yá, zɨ́a ndáꞌba ꞌdúꞌduné bi. Káa zɨ́ mbágá kemị ní, éyị́ bɨ nɨ tóro ꞌdụ́tụ kóꞌdụ́yị ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Áyí ídí kɨ́ ngbángbá ꞌbɨ ídí káa do manda zɨ́yị, bulúnduyị́ e nɨyí ídí ngére do kúfú ꞌyị e mbá kúfú ꞌyịmaꞌdí e mbá nɨyí ndị́sị óto úndruyé zɨ́ye ndị́sị íꞌbí tákpásị́lị́ zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nɨ ódóngéṛị dongí ené ro kókó sịndị́ kóṛó bɨ nɨ mɨútúásáne komoa ní. Zɨ́a ndị́sịné lóꞌdó bongó ené sɨmɨ iní kóṛó bɨ káa zɨ́ sáma ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Komoa nɨ ídí bɨkesị́ne rómo gɨ do iní kóṛó, soa nɨ ídí bɨkenyị́ne rómo do mɨényị́ iní umba. ");
INSERT INTO bdh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebụlụ́na, nɨ ndị́sị kɨ́ ꞌbe tara mongụ́ ngbuṛu, zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụ tóroyé do gbúṛóngó ngbuṛu maꞌdáa née. Mamayé nɨ ídí geré gbóo kɨ́ káṇgá bɨ Sidóna ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakára, nɨ ídí kɨ́ rokoꞌbụné káa zɨ́ dongí bɨ ndịsị ꞌdúꞌdu dongará éyị́ ga bɨ ịmbị́ yée ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Sɨmɨ bɨ lúrú bi ꞌdówụ́ro née nɨ bɨlámáne zɨ́ ị́rịgbére a ídíne kpá bɨlámáne ní, nɨ óyóyéme sogoné, zɨ́a íꞌbí roné ndị́sị ị́mbị́ éyị́ owóowó ga bɨ ore ní. Zɨ́a ídíne owụ́kụlụ́ ꞌbɨ moko ga bɨ ore ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dána nɨ ídí ꞌyị ꞌdécị yéme ngbanga zɨ́ ꞌyị ené e káa zɨ́ ngíti géyị ꞌyị ga bɨ kóo ꞌbɨ Isɨréle e ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Owụ́ ꞌbɨ eyị́ e kɨ́ bulúnduyị́ e nɨyí ídí káa zɨ́ kámá dogboṛụ mɨsiꞌdi, togụ́ lagá usáni go yá, ꞌyị bɨ ndịsị ngásá kɨ́ usáni máa née nɨ útúógụ gɨ doa. ");
INSERT INTO bdh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ngére Lomo mándị́sị óto komomá gɨ ro zɨ́yị yómo zée. ");
INSERT INTO bdh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gáda, ꞌyị ngáka éyị́ e nɨyí karanée útú kɨ́ okó do bulúnduyị́ e, tɨ́ lá nɨyí rómo komo ꞌyị ga gére née cụ́. ");
INSERT INTO bdh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Bi bɨ Aséra, nɨ ndị́sị doa ní nɨ ꞌdíꞌbiógụ bɨlámá éyị́ mɨánu kɨ́ngaya. Zɨ́a ndị́sịné íꞌbí bɨlámá éyị́ mɨánu bɨ nɨ mɨútúásáne gɨ ro mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatáli, nɨ yị́ ené káa zɨ́ nyazu ní. Nɨ ndị́sị gámá kɨ́ ro doné. Nɨ ndị́sị ndíki mbá owụ́ ga bɨ kɨ́ lámá royé kɨ́ngaya ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yoséfa nɨ ꞌbɨ ené káa zɨ́ kóṛó bɨ ndịsị áná kɨ́ngaya ní, kpá káa zɨ́ kóṛó bɨ kóꞌdụ́ ngbuṛu ní, bɨ mɨrásá a rasá zɨ́a ꞌdụ́tụ bi mbá ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ezeokóyị nɨyí ndị́sị útú kɨ́ okó doyị́, zɨ́ye ndị́sịyé méngị yị́ị ꞌduo kɨ́ mɨmbéꞌdekesị́. ");
INSERT INTO bdh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tɨ́ lá sama bɨ do sị́lị́a ní utúasá kị́zị wá, sị́lị́a utúasá óꞌdó kɨ́ éꞌbe sama wá, gɨ zɨ́a Lomo bɨ kɨ́ Rokoꞌbụné kɨ́ngaya bɨ ndịsị lúrú bi kacɨ́ Yakóbo ní, nɨ ne bi lóꞌbo kpá ꞌyị ꞌbáꞌbá Isɨréle e, ");
INSERT INTO bdh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","gɨ zɨ́a Lomo bɨ ꞌbụyị́ ndịsị óto úndrua ní ndịsị sáká yị́ị ne, gɨ zɨ́a Lomo bɨ kɨ́ rokoꞌbụné kɨ́ngaya ní ndịsịne íꞌbí úndru bɨ gɨ komo ere gɨ ꞌdága ní zɨ́yị, nɨ kpá íꞌbí úndru do iní bɨ ndịsị lágaógụ gɨ sị́ káṇgá ní, zɨ́ bangá eyị́ e, bulúnduyị́ e étrịyé zɨ́ye ídíye tụ́ꞌdụ́. ");
INSERT INTO bdh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Úndru bɨ máíꞌbí zɨ́yị ba nɨ kɨ́ rokoꞌbụné kɨ́ngaya rómo do úndru ga bɨ kóo ꞌdesị́ ní mbá, romo kpá gɨ do tákpásị́lị́ ga bɨ kóo gɨ zɨ́ bulúnduyị́ e ní mbá. Úndru ga gére née idínɨ́ ógụ zɨ́ Yoséfa, gɨ zɨ́a nɨ ídíne manda zɨ́ lúnduné e za mbá. ");
INSERT INTO bdh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benzemúna, nɨ ídí ꞌbɨ ené káa zɨ́ máárára bɨ kɨ́ ꞌbú roné ní, kɨ́ phịyị́ nɨ nánáónzó bangá e zɨ́a ánu yée, kɨ́ tagá zɨ́ye ífi sɨmɨ ngítí a kɨ́ lafúne e.” ");
INSERT INTO bdh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ga bɨ sokó doa gbre (12) née mbá sị́ do Isɨréle. Née ledre bɨ ꞌbụyé Yakóbo uku zɨ́ye sɨmɨ bɨ nɨ íꞌbí úndru zɨ́ye kacɨ́ mɨsiꞌdiné mɨngúngúcua ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Zɨ́ Yakóbo yóko wotị́ne e úku ledre zɨ́ye kɨ́dí, “Mááyí go ógụ úyu zɨ́ze ndíkíze kɨ́ ꞌyị amá e. Ídísé óto máa cigí babá sɨmɨ gu landa bɨ sɨmɨ yáká ꞌbɨ Éforono ꞌyị ꞌbɨ Éte ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Gu landa bɨ Makeféla née nɨ kóo sɨmɨ yáká bɨ Abarayáma ugú gɨ ro ndị́sị óto bi e sɨmɨ a gɨ zɨ́ Éforono ꞌyị ꞌbɨ Éte, gbóo kɨ́ Mamaré sɨmɨ káṇgá ꞌbɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Otonɨ́ kóo Abarayáma e kɨ́ meꞌbené Sára ore, do kóo óto Isáka e kɨ́ meꞌbené Rebéka kpá ore, máóto meꞌbemá Léya kpá ore. ");
INSERT INTO bdh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ugúnɨ́ kóo yáká née go kɨ́ éyị́ ga bɨ sɨmɨyé ní mbá gɨ zɨ́ Éte e.” ");
INSERT INTO bdh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sɨmɨ bɨ Yakóbo ukuonzó ledre go zɨ́ wotị́ne e ní, zɨ́a ꞌdúꞌdulúgu roné bi, zɨ́ sịndị́ kadra útúásáne zɨ́a úyuné. ");
INSERT INTO bdh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Zɨ́ Yoséfa útúne kụkụrụkụ do umbu ꞌbụné do fáka wo zɨ́a ndị́sịné íni ini roa. ");
INSERT INTO bdh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Zɨ́ Yoséfa ị́nyịné úku ledre idínɨ́ yéme umbu ꞌbụné kɨ́ kágá bɨlámáne káa bɨ nɨ sínyí. ");
INSERT INTO bdh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Sị́lị́ ꞌbɨ sụ́sụ kágá née nɨ mbá cị́ gbre (40). Zɨ́ ꞌyị ꞌbɨ Ízibiti e íni wo kɨ́ sị́lị́ cị́ ota doa sokó (70). ");
INSERT INTO bdh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sɨmɨ bɨ sị́lị́ ꞌbɨ ini ụkụ́ go ní, zɨ́ Yoséfa úku ledre zɨ́ mị́ngị́ káṇgá ga bɨ mɨngburoko ꞌyị ꞌbɨ moko ꞌbɨ mongụ́ ngére ní kɨ́dí, “Togụ́ ledre amá eme komosé tɨ́ mɨéme yá, ídísé ndéré kɨ́ sanda ba úku a zɨ́ mongụ́ ngére kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Babá oto kóo máa go lólóbụ́ zɨ́ne kɨ́dí, “Mááyí go ógụ úyu, ídí óto máa sɨmɨ gu bɨ kóo máíciómo gɨ romá sɨmɨ Kanána ní.” Bɨ ba ní máṇgúṇgú romá zɨ́yị ídí ṇgúṇgu a zɨ́ma ndéréma óto ꞌbụmá zɨ́ma ndáꞌbaógụmá.’ ” ");
INSERT INTO bdh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mongụ́ ngére ya zɨ́a ní, “Ndéré mu óto ꞌbụyị́ káa zɨ́ bɨ lólóbụ́ zɨ́a kɨ́dí née nɨ méngị a kenée ní.” ");
INSERT INTO bdh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Sɨmɨ bɨ Yoséfa ꞌdíꞌbi umbu ꞌbụné ndéré kɨ́e óto a ní, zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ mongụ́ ngére nda kɨ́ mɨngburoko ꞌyị ga bɨ ꞌbɨ Ízibiti ní ndéréye ꞌdị́yịóto Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Zɨ́ ꞌyị ga bɨ kacɨ́ Yoséfa kɨ́ yée ga bɨ kacɨ́ ꞌbụa ní ị́nyịyé mbá ndéréye ꞌdị́yịóto umbu. Odụ ꞌyị ga bɨ idíakánɨ́ sɨmɨ Gósene ní dụụ́ mɨnzéré owụ́ e nda kɨ́ bangá eyé e. ");
INSERT INTO bdh_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Zɨ́ ꞌyị ngásá kɨ́ arabíya e kɨ́ ꞌyị ngásá kɨ́ usáni e kpá ndéréye ndro kéye. ꞌYị e nɨyí kóo tụ́ꞌdụ́ bɨ utúnɨ́ do kacɨ́ Yoséfa ní. ");
INSERT INTO bdh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sɨmɨ bɨ ꞌdogụnɨ́ bi, nderéogụnɨ́ goó sɨmɨ Atáda bɨ sága Yeredéne mɨꞌdí gbére kɨ́ꞌdí bɨ ndịsịnɨ́ ócó kére ní, zɨ́ye ndị́sịyé ore íni ini, íni ini kɨ́ngaya. Née ní zɨ́ Yoséfa íni ꞌbụné ore kɨ́ sị́lị́ ịnyị doa gbre (7). ");
INSERT INTO bdh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Sɨmɨ bɨ ꞌyị ꞌbɨ Kanána ga bɨ ndịsịnɨ́ ndị́sị ore lurúnɨ́ ini bɨ méngị roné kɨ́ngaya sɨmɨ Atáda ní, zɨ́ye úku ledre kɨ́dí, “Mongụ́ lerị́ ro ꞌyị ꞌbɨ Ízibiti e.” Zɨ́ ịrị bi née nda ídíne Ábele Miziráma. ");
INSERT INTO bdh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Née ní, zɨ́ wotị́ Yakóbo e méngị ledre tɨ́ káa zɨ́ bɨ ꞌbụyé úku zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Zɨ́ye ꞌdíꞌbi umbu ꞌbụyé ndéré kɨ́e sɨmɨ Kanána óto a sɨmɨ gu landa bɨ Makeféla gbóo kɨ́ Mamaré, bɨ sɨmɨ yáká bɨ kóo Abarayáma ugú gɨ ro ndị́sị óto bi e sɨmɨ a gɨ zɨ́ Éforono ꞌyị ꞌbɨ Éte e ní. ");
INSERT INTO bdh_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Gɨ do kacɨ́ bɨ otonɨ́ bi ní, zɨ́ Yoséfa ị́nyịyé kɨ́ lúnduné e kɨ́ ꞌyị ga bɨ kóo nderénɨ́ kéye óto bi ní mbá ndáꞌbalúgu royé sɨmɨ Ízibiti. ");
INSERT INTO bdh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sɨmɨ bɨ lúndu Yoséfa lurúnɨ́ ꞌbụyé uyu go ní, zɨ́ye úku ledre kɨ́dí, “Togụ́ Yoséfa somụ́ndiki bɨsinyí ledre bɨ kóo mengịzé zɨ́a, zɨ́a méngị lúgu a zɨ́ze ní, azé méngị ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Née ní zɨ́ye kákasa zɨ́ Yoséfa kɨ́dí, “ꞌBụyị́ uku kóo ledre zɨ́ze ꞌdáꞌdá zɨ́a kɨ́ úyuné, ");
INSERT INTO bdh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ba ledre bɨ ídísé úku a zɨ́ Yoséfa ní. Máṇgúṇgú romá zɨ́yị ídí ótoómo luyú kɨ́ bɨsinyí ledre kóo lúnduyị́ e mengịnɨ́ zɨ́yị ní.’ Bɨ ba ní ídí ótoómo ledre zɨ́ze gɨ sɨmɨ lúyú ledre ezé, zée ga bɨ ndịsịzé óto úndru Lomo ꞌbɨ ꞌbụyị́ ní.” Sɨmɨ bɨ Yoséfa uwú ledre née ní, zɨ́ sɨmɨkozo méngị wo zɨ́a útúne íni ini. ");
INSERT INTO bdh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Zɨ́ lúnduga ógụyé útúye lóꞌbụ komoyé bi kóꞌdụ́ a. Zɨ́ye úku ledre kɨ́dí, “Azé cakaba go owụ́kụlụ́ eyị́ e.” ");
INSERT INTO bdh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Zɨ́ Yoséfa úkulúgu ledre zɨ́ lúnduné e kɨ́dí, “Ndásé éré ngịrị wá. Mándá kɨ́ rokoꞌbụ zɨ́ma óyólóꞌbó ledre bɨ Lomo yeme go ní wá. ");
INSERT INTO bdh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Abú yémesé kóo rosé gɨ ro méngị bɨsinyí ledre kɨ́ma yá, tɨ́ lá Lomo yeme kóo ledre née zɨ́a ídíne kenée ne gɨ ro zɨ́ne yómo tụ́ꞌdụ́ ꞌyị e káa zɨ́ bɨ nɨ ndị́sị méngị roné cakaba ba. ");
INSERT INTO bdh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Zɨ́a úku yéme ledre zɨ́ye kɨ́dí, bɨ goó kenée ní ndásé éré ngịrị wá. Mááyí íꞌbí éyị́ e zɨ́se kɨ́ owụ́ ꞌbɨ esé e mbá.” ");
INSERT INTO bdh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yoséfa ndịsịnɨ́ kóo kɨ́ lúnduné e sɨmɨ Ízibiti. Nɨ úyu ní, sɨmɨbi ené nɨ go míya kị́éꞌdo doa sokó (110). ");
INSERT INTO bdh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yoséfa luꞌbú kóo do sogo káṇgá go kɨ́ngaya. Zɨ́a lúrú owụ́ e gɨ sɨmɨ Efarayíma kɨ́ bulúndu Efarayíma e. Zɨ́a kpá ị́mbị́ owụ́ ga bɨ gɨ sɨmɨ Makíri wotị́ Manási ní. ");
INSERT INTO bdh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nda sɨmɨ ngíti sịndị́ kadra zɨ́ Yoséfa úku ledre zɨ́ lúnduné e kɨ́dí, “Mááyí go ógụ úyu. Tɨ́ lá Lomo nɨ ógụ sáká sée do ꞌdíꞌbióyó sée gɨ sɨmɨ káṇgá ba ndéré kɨ́se sɨmɨ káṇgá bɨ kóo mocụ́omo ledre a zɨ́ Abarayáma, Isáka nda kɨ́ Yakóbo ní.” ");
INSERT INTO bdh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Bɨ ba ní, ídísé lólóbụ́ zɨ́ma kɨ́dí, ásé ꞌdíꞌbi umbumá kpa kɨ́se sɨmɨ bɨ Lomo nɨ go ꞌdíꞌbi sée ndéré kɨ́se sɨmɨ Kanána ní. ");
INSERT INTO bdh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Née ní, zɨ́ Yoséfa úyuné cịkị sɨmɨ Ízibiti ore sɨmɨ bɨ sɨmɨbi ené nɨ go míya kị́éꞌdo doa sokó (110) ní. Do yéme umbu a bɨlámáne kɨ́ kágá do óto a sɨmɨ sondụ́ụ.");
INSERT INTO bdh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ba ledre gɨ ro bulúndu bulúndu Kɨ́résịto Yésụ, tonó gɨ ro ngére Dawídi ndéréógụné gị ro Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarayáma ndiki Isáka. Zɨ́ Isáka ndíki Yakóbo. Zɨ́ Yakóbo ndíki Zụ́da e kɨ́ lúnduné e. ");
INSERT INTO bdh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zɨ́ Zụ́da ndíki ꞌbɨ ené Peréze e kɨ́ Zéra. Mbágáye ꞌbɨ ené Tamára. Zɨ́ Peréze ndíki ꞌbɨ ené Ézorono. Zɨ́ Ézorono ndíki ꞌbɨ ené Ráma. ");
INSERT INTO bdh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Zɨ́ Ráma ndíki ꞌbɨ ené Aminadába. Zɨ́ Aminadába ndíki ꞌbɨ ené Nasóna. Zɨ́ Nasóna ndíki ꞌbɨ ené Salamóna ");
INSERT INTO bdh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Zɨ́ Salamóna ndíki ꞌbɨ ené Bowáza, ịrị mbágáa Rába. Zɨ́ Bowáza ndíki ꞌbɨ ené Óbede, ịrị mbágáa Rúta. Zɨ́ Óbede ndíki ꞌbɨ ené Zése. ");
INSERT INTO bdh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zɨ́ Zése ndíki ꞌbɨ ené Dawídi bɨ kóo nɨ mongụ́ ngére ní. Dawídi ndiki ꞌbɨ ené Solomóna, mbágáa nɨ Beteseyị́da kára umbu kacɨ́ Ụrị́ya. ");
INSERT INTO bdh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Zɨ́ Solomóna ndíki ꞌbɨ ené Rebóma. Zɨ́ Rebóma ndíki ꞌbɨ ené Abiyáza. Zɨ́ Abiyáza ndíki ꞌbɨ ené Ása. ");
INSERT INTO bdh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Zɨ́ Ása ndíki ꞌbɨ ené Zesofáti. Zɨ́ Zesofáti ndíki ꞌbɨ ené Zeróma. Zɨ́ Zeróma ndíki ꞌbɨ ené Uzíya. ");
INSERT INTO bdh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Zɨ́ Uzíya ndíki ꞌbɨ ené Zotáma. Zɨ́ Zotáma ndíki ꞌbɨ ené Áza. Zɨ́ Áza ndíki ꞌbɨ ené Izikíya. ");
INSERT INTO bdh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Zɨ́ Izikíya ndíki ꞌbɨ ené Manási. Zɨ́ Manási ndíki ꞌbɨ ené Amóna. Zɨ́ Amóna ndíki ꞌbɨ ené Zosíya. ");
INSERT INTO bdh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zɨ́ Zosíya ndíki ꞌbɨ ené Zekíni, do ndíki ngíti géyị lúnduga sɨmɨ bɨ ezeokó Isɨréle e ꞌdiꞌbinɨ́ yée ndéré kɨ́ye sɨmɨ Babelónịya ní. ");
INSERT INTO bdh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gɨ do kacɨ́ a bɨ Yụ́da e ndaꞌbaogụnɨ́ ꞌbɨ eyé gɨ sɨmɨ Babelónịya ní, zɨ́ Zekíni ndíki ꞌbɨ ené Seretiyéle. Zɨ́ Seretiyéle ndíki ꞌbɨ ené Zerụbábele. ");
INSERT INTO bdh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zɨ́ Zerụbábele ndíki ꞌbɨ ené Abiyụ́da. Zɨ́ Abiyụ́da ndíki ꞌbɨ ené Alikíma. Zɨ́ Alikíma ndíki ꞌbɨ ené Azóra. ");
INSERT INTO bdh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Zɨ́ Azóra ndíki ꞌbɨ ené Zadóka. Zɨ́ Zadóka ndíki ꞌbɨ ené Akímu. Zɨ́ Akímu ndíki ꞌbɨ ené Elụyụ́da. ");
INSERT INTO bdh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Zɨ́ Elụyụ́da ndíki ꞌbɨ ené Eliyázara. Zɨ́ Eliyázara ndíki ꞌbɨ ené Matána. Zɨ́ Matána ndíki ꞌbɨ ené Yakóbo. ");
INSERT INTO bdh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zɨ́ Yakóbo ndíki ꞌbɨ ené Yoséfa oꞌdo ꞌbɨ Maríya. Née Maríya bɨ mbágá Kɨ́résịto Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bulúndu Yésụ nɨyí kóo mɨífiyé káa. Tonó gɨ ro Abarayáma ndéréógụné gị ro mongụ́ ngére Dawídi, ndiki andánɨ́ kóo ṛị́kị́ ꞌyị eyé e go kɨ́ꞌdí sokó doa eso (14). Do tónó ndíki ngíti géyị gɨ sɨmɨ sịndị́ kadra ꞌbɨ mongụ́ ngére Dawídi ndéréógụné gị sɨmɨ sịndị́ kadra bɨ ezeokó Isɨréle e ꞌdiꞌbinɨ́ yée ndéré kɨ́ye sɨmɨ Babelónịya ní, kpá sokó doa eso. Zɨ́ ngíti géyị tónóye gɨ ore ndéréógụné gị sɨmɨ sịndị́ kadra bɨ aránɨ́ Kɨ́résịto sɨmɨ a ní. Ndiki andánɨ́ ṛị́kị́ ꞌyị eyé e go kpá sokó doa eso. ");
INSERT INTO bdh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ledre gɨ ro mɨndíki Kɨ́résịto Yésụ tonó kóo káa. Korónɨ́ kóo mbágáa Maríya zɨ́ ngíti oꞌdo kɨ́ ịrịné Yoséfa. ꞌDáꞌdá zɨ́ Yoséfa kɨ́ ówo royé kéne káa do oꞌdo kɨ́ kára, zɨ́ Maríya ídíne kɨ́ sɨmɨné, owụ́ maꞌdáa ogụ yị́ ené sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gɨ zɨ́a bɨ Yoséfa ndịsị méngị ledre ga bɨ Lomo ili yée ní, kpá gɨ zɨ́a bɨ ili ené íꞌbí komokenyị́ ro do Maríya wá ní, zɨ́a kóo áyíne gɨ ro ótoómo wo lá wayí kenée ꞌyị e ndanɨ́ ówo a wá. ");
INSERT INTO bdh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sɨmɨ bɨ Yoséfa yeme roné go kenée ní, zɨ́ Ngére kása maláyika ꞌdiya ógụ úku ledre zɨ́a sɨmɨ ꞌduru kɨ́dí, “Yoséfa bulúndu ngére Dawídi, ndá sómụ́ ledre gɨ ro ótoómo kɨ́ ꞌdíꞌbi Maríya káa do meꞌbeyị́ wá, owụ́ bɨ sɨmɨ a née ogụ ené gɨ zɨ́ ꞌyịmaꞌdí wá, Lomo yeme yị́ ené ne sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ne. ");
INSERT INTO bdh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɨ áráógụ owụ́ née owụ́oꞌdo, ídí ị́fị́ ịrị a Yésụ, gɨ zɨ́a nɨ yómo ꞌyị ené e gɨ sɨmɨ lúyú ledre eyé e.” ");
INSERT INTO bdh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ledre bɨ kóo Ngére ukuiꞌbí tara ngíti nébị ní, mengị roné née goó ne tɨ́ káa zɨ́ bɨ kóo uku ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Karanée ngíti owụ́kára ku mbotụ nɨ ídí kɨ́ sɨmɨné, zɨ́a áráne owụ́oꞌdo, do ndị́sị ndólo wo Imanuwéle,” ledre gɨ sɨmɨ a kɨ́dí, “Lomo nɨ kɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sɨmɨ bɨ Yoséfa urú ní, zɨ́a tɨ́ ꞌdíꞌbi Maríya káa do meꞌbené káa zɨ́ bɨ maláyika ꞌbɨ Ngére ogụ úku a zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Abú Yoséfa ꞌdiꞌbi tɨ́ Maríya go káa do meꞌbené yá, kotrụnɨ́ bi ꞌdúꞌdu kéne wá, zaá gị zɨ́ Maríya árá owụ́ bɨ sɨmɨné née té kí, zɨ́ Yoséfa ị́fị́ ịrị a Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Gɨ do kacɨ́ a bɨ kóo aránɨ́ Yésụ sɨmɨ Beteléme ngíti gara sɨmɨ káṇgá bɨ Yụdáya sɨmɨ bɨ kóo Eróde nɨ ore ne ngére ní, zɨ́ ngíti géyị ꞌyị komokenzị e ógụyé gɨ gbére sɨmɨ Yerụsaléma ore, ");
INSERT INTO bdh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","zɨ́ye ndúnduꞌyú kɨ́dí, “Owụ́ bɨ aránɨ́ wo káa do ngére ꞌbɨ Yụ́da e ona ba, nɨ ꞌdí ꞌda? Kele ené ꞌdodo ledre a go zɨ́ze gbére ꞌdáa, ógụzé ba óto úndrua.” ");
INSERT INTO bdh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sɨmɨ bɨ ngére Eróde uwú ledre née kenée ní, zɨ́ bi sínyíne roa kɨ́ ꞌyị ga bɨ ꞌbɨ Yerụsaléma ní mbá. ");
INSERT INTO bdh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Zɨ́a ndóloyóko manda ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ ꞌyị ꞌdódo lorụ e, ndúꞌyú yée kɨ́dí, “Úwúsé kóo kɨ́dí nɨyí árá Kɨ́résịto maꞌdáa ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Zɨ́ye úkulúgu ledre kɨ́dí, “Ukunɨ́ kóo kɨ́dí, nɨyí árá wo sɨmɨ Beteléme, káṇgá ꞌbɨ Yụdáya ona. Ngíti nébị uku kóo kɨ́dí Lomo uku yaá, ");
INSERT INTO bdh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Beteléme, ndaá ꞌbɨ eyị́ lá dụụ́ owụ́ gara sɨmɨ káṇgá ꞌbɨ Yụ́da e wá. Mongụ́ ngére nɨ karanée ólụ́ógụ gɨ sɨmɨyị́ gɨ ona zɨ́a ídíne ꞌyị lúrú bi kacɨ́ ꞌyị amá e Isɨréle e za mbá.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Née ní, zɨ́ Eróde ndólo ꞌyị komokenzị ga gére née sɨmɨ ugu gɨ ro ówo a gɨ zɨ́ye lurúnɨ́ kóo kele máa née kɨ́ be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndérésé mu sɨmɨ Beteléme gámásóꞌdo owụ́ máa née. Togụ́ ndíkisé wo goó, ídísé ndáꞌbaógụ ꞌdódo bia zɨ́ma gɨ ro zɨ́ma kpá ndéréma óto úndrua.” ");
INSERT INTO bdh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sɨmɨ bɨ ngére Eróde odro go zɨ́ye ní, zɨ́ye ólụ́ógụyé ndéréye. Kele bɨ ndịsị útú zɨ́ye ꞌdáꞌdá ní, nzara zɨ́a kpá ólụ́ógụné útúne zɨ́ye ꞌdáꞌdá. Zɨ́a ndéré tóroné té do ꞌbe bɨ owụ́ máa née nɨ sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nɨyí kóo kɨ́ mongụ́ rokinyi kɨ́ lúrú kele née kɨ́ útúne zɨ́ye kpá fú ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Zɨ́ye ndéréógụyé ndíki Yésụ kɨ́ mbágáne Maríya, zɨ́ye útúye do ngụ́ṛụ́ sịndị́ye óto úndru a. Zɨ́ye líkpí tara kombo eyé e, ꞌdíꞌbiógụ dábu kɨ́ abúṛengú kɨ́ bɨlámá sụꞌbụ́ mɨndonyo íꞌbí yée zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nda go kɨ́ ndụlụ, zɨ́ Lomo ódroné zɨ́ye sɨmɨ ꞌduru kɨ́dí ndanɨ́ ndáꞌba gɨ ꞌdí zɨ́ Eróde wá, idínɨ́ ndéré gɨ do ngíti mɨsiꞌdi kpị́. ");
INSERT INTO bdh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sɨmɨ bɨ yaꞌdá ga gére née okpónɨ́ go ní, zɨ́ Ngére Lomo kása maláyika ógụ ódroné zɨ́ Yoséfa sɨmɨ ꞌduru kɨ́dí, “ꞌDiꞌdiya, ị́nyịsé mu kɨ́ meꞌbeyị́ zɨ́se ꞌdíꞌbi owụ́ ba ngásá ndị́sị kɨ́e sɨmɨ Ízibiti gɨ zɨ́a Eróde ayí go gámásóꞌdo wo gɨ ro úfu a. Ídísé ndị́sị íri ꞌbúó togụ́ mándólolúgu sée máa.” ");
INSERT INTO bdh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kpá tɨ́ akpa kɨ́ ndụlụ née, zɨ́ Yoséfa e kɨ́ meꞌbené ꞌdíꞌbi owụ́ née, zɨ́ye ngásáye sɨmɨ Ízibiti, ");
INSERT INTO bdh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","zɨ́ye ndị́sịyé íri zɨ́ Eróde úyuné té kí. Ledre née ꞌdodo ini ledre gɨ sɨmɨ ledre kóo Ngére Lomo ukuiꞌbí zɨ́ ngúru nébị úku a ní kɨ́dí, “Mándólolúgu owụ́ ꞌbɨ amá go gɨ sɨmɨ Ízibiti.” ");
INSERT INTO bdh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sɨmɨ bɨ Eróde owo kɨ́dí ꞌyị komokenzị ga gére née londonɨ́ née go ní, zɨ́ mɨmbéꞌdea ésị́ne zɨ́a kása asikíri ené e ndéré úfu owụ́ yaꞌdá ga bɨ sɨmɨ Beteléme ore kpá kɨ́ yée ga bɨ gbaá ore ní mbá ꞌdáꞌba. Tonónɨ́ úfu yée gɨ ro yée ga bɨ sɨmɨbi eyé nɨ gbre ní ndáꞌbaógụné nde. ");
INSERT INTO bdh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zɨ́ mongụ́ lerị́ ídíne tɨ́ káa zɨ́ bɨ kóo nébị Yeremáya uku ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Do kará Isɨréle e ndịsị ówụ́ kɨ́ íni ini kɨ́ mbụ́mbụ́dụ́ kɨ́ mongụ́ lerị́ sɨmɨ gara bɨ Ráma ní. Ndịsịnɨ́ íni ini gɨ ro owụ́ ꞌbɨ eyé e, gɨ zɨ́a ufuonzónɨ́ yée go mbá. Mbámɨowụ́ máa ga gére née ilinɨ́ do ụ́cụómo yée kɨ́ íni ini wá.” ");
INSERT INTO bdh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sɨmɨ bɨ Eróde uyu nda go ní, zɨ́ maláyika ꞌbɨ Ngére Lomo ógụné sɨmɨ ꞌduru zɨ́ Yoséfa sɨmɨ Ízibiti ");
INSERT INTO bdh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","zɨ́a úku ledre kɨ́dí, “Ị́nyịsé mu kɨ́ meꞌbeyị́ zɨ́se ꞌdíꞌbi owụ́ zɨ́se ndáꞌbasé sɨmɨ káṇgá esé ꞌbɨ Isɨréle e. Eróde bɨ kóo ayí gɨ ro úfu wo ní uyu go.” ");
INSERT INTO bdh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zɨ́ Yoséfa ị́nyịyé kɨ́ meꞌbené ꞌdíꞌbi Yésụ, yóó do ndáꞌbayé sɨmɨ Káṇgá eyé ꞌbɨ Isɨréle e. ");
INSERT INTO bdh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ábuwá Arakaláyo nɨ nda goó ne ngére do bi kacɨ́ ꞌbụné sɨmɨ káṇgá bɨ Yụdáya ní. Zɨ́ ngịrị méngị Yoséfa kɨ́ ndáꞌbané íri. Zɨ́ Lomo úku ledre zɨ́a sɨmɨ ꞌduru, zɨ́ye nda ndéréye sɨmɨ Galiláya. ");
INSERT INTO bdh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ndịsịnɨ́ nda kóo sɨmɨ gara bɨ Nazeréta ní. Utúasá go kɨ́ ledre bɨ kóo ngíti nébị uku gɨ ro Kɨ́résịto maꞌdáa kɨ́dí, “Nɨyí ndị́sị ndólo wo ꞌyị ꞌbɨ Nazeréta.” ");
INSERT INTO bdh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, ngíti oꞌdo nɨ kóo bo kɨ́ ịrịné Yiwáni, nɨ ꞌyị Bábátị́zị́ ꞌyị e. Zɨ́a ndị́sịné úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e sɨmɨ Yụdáya gbála sɨmɨ súwú ");
INSERT INTO bdh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kɨ́dí, “Ídísé mu óyólóꞌbó mɨmbéꞌdesé, gɨ zɨ́a sịndị́ kadra nɨ go gbóo gɨ ro zɨ́ Lomo bɨ komo ere ní ídíne Ngére esé.” ");
INSERT INTO bdh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yiwáni nɨ oꞌdo bɨ kóo nébị Isáya uku ledre a kɨ́dí, “ꞌYị nɨ karanée ndị́sị ótrụ́ ledre zɨ́ ꞌyị sɨmɨ súwú kɨ́dí, yémeómosé mɨsiꞌdi mu nzíyiné zɨ́ Ngére, ídísé ꞌdózo yéme mɨsiꞌdi zɨ́a ní.” ");
INSERT INTO bdh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yiwáni ésị kóo roné bongó bɨ uꞌyúnɨ́ gɨ sɨmɨ bị bangá bɨ Gémele ní, zɨ́a ódó roné káꞌdá bɨ yemenɨ́ gɨ sɨmɨ saná ní. Mongụ́ éyị́ mɨánu ené nɨ kóo mbíra kɨ́ tezị. ");
INSERT INTO bdh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tụ́ꞌdụ́ ꞌyị e ịnyịnɨ́ kóo gɨ sɨmɨ Yerụsaléma, kɨ́ yée ga bɨ gɨ sɨmɨ káṇgá bɨ Yụdáya ní, nda kpá kɨ́ ꞌyị máa yée ga bɨ gbóo gbóo kóꞌdụ́ ngbuṛu bɨ Yeredéne ore ní mbá ndéréye úwú ledre ꞌbɨ Lomo gɨ tara Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sɨmɨ bɨ ꞌyị ga gére née ukuogụnɨ́ lúyú ledre eyé e ní, zɨ́a bábátị́zị́ yée sɨmɨ ngbuṛu bɨ ndolonɨ́ Yeredéne ní. ");
INSERT INTO bdh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sɨmɨ bɨ lurú tụ́ꞌdụ́ Farụsáyo e, kɨ́ Sadụkáyo e kɨ́ ógụyé kɨ́ꞌdí bɨ ndịsị íꞌbí babatị́za ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Sée ga bɨ ásé bɨsinyíse káa zɨ́ kámá okó ní, ambí uku zɨ́se ne ya ídísé ngásáóyó rosé gɨ zɨ́ sɨmɨkesị́ ꞌbɨ Lomo bɨ nɨ ógụ dosé ní? ");
INSERT INTO bdh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Togụ́ kenée yá, ídísé méngị éyị́ bɨ nɨ ꞌdódo a kɨ́dí óyólóꞌbósé mɨméngị ledre esé go maꞌdíi ní. ");
INSERT INTO bdh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Éyị́ ndaá kpá lóndo sée zɨ́se sómụ́ ledre kɨ́dí Lomo nɨ ótoómo ledre zɨ́se gɨ zɨ́a bɨ ásé bulúndu Abarayáma ní wá. Máúku zɨ́se maꞌdíi tutú ga bɨ bi née, Lomo utúasá go óyólóꞌbó yée zɨ́ye ídíye káa do bulúndu Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lomo nɨ go nzíyiné gɨ ro lágáónzó kágá e bi. Maꞌdíi, kágá máa wo bɨ aná bɨlámáne wá ní, nɨ lágáónzó a do ụ́cụ a ku phoꞌdụ. ");
INSERT INTO bdh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mándị́sị bábátị́zị́ sée kɨ́ iní gɨ ro zɨ́se óyólóꞌbó sómụ́ ledre esé. Tɨ́ lá gɨ do kacɨ́ma ngíti mongụ́ ꞌyị nɨ ógụ, bɨ romo domá ní. Máútúásá gbawá íꞌdíógụ wará ené gɨ sịndị́a. Nɨ bábátị́zị́ ꞌbɨ ené sée kɨ́ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo kɨ́ phoꞌdụ. ");
INSERT INTO bdh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nɨ ꞌbɨ ené yị́ ené káa zɨ́ ꞌyị ócó komo kére ní. Nɨ léfeóto kére ené sɨmɨ bɨlámá éyị́, cící a née zɨ́a kótrụ a trị́e do óngbóóyó a ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sɨmɨ ngíti sịndị́ kadra zɨ́ Yésụ ị́nyịné gɨ sɨmɨ káṇgá bɨ Galiláya ní ndéréne ngbuṛu bɨ Yeredéne ní gɨ ro zɨ́ Yiwáni bábátị́zị́ née. ");
INSERT INTO bdh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zɨ́ Yiwáni úku ledre zɨ́a kɨ́dí, “Máíli ba zɨ́yị íꞌbí babatị́za zɨ́ma yị́ị, ógụ nda zɨ́ma ba lárá a káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zɨ́ Yésụ úkulúgu ledre zɨ́ Yiwáni kɨ́dí, “Ba go bɨlámá sịndị́ kadra gɨ ro zɨ́yị bábátị́zị́ máa, gɨ zɨ́a ilizé mbá ndị́sị méngị ledre ga bɨ Lomo ili yée ní.” Zɨ́ Yiwáni ṇgúṇgu a. ");
INSERT INTO bdh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zɨ́ Yiwáni go bábátị́zị́ wo. Sɨmɨ bɨ olụ́ogụ gɨ sɨmɨ iní ní, geré zɨ́ ere líkpí roné. Zɨ́a lúrúndíki ꞌDówụ́ Lomo kɨ́ ógụné doné káa zɨ́ kị́ṛịkóꞌdo ní. ");
INSERT INTO bdh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Zɨ́ Lomo ódroné gɨ komo ere kɨ́dí, “Ba mbigí Owụ́ ꞌbɨ amá, ꞌbúa ofụ domá go, mááyí kɨ́ rokinyi gɨ zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gɨ ore zɨ́ ꞌDówụ́ Lomo ꞌdíꞌbi Yésụ ndéré kɨ́e sɨmɨ súwú gbála gɨ ro zɨ́ ngére ꞌbɨ bɨcayi lomo e úzu wo. ");
INSERT INTO bdh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zɨ́ Yésụ méngịné sɨmɨ súwú íri sị́lị́ cị́ gbre (40) anu éyị́ mbá wá. Zɨ́ ꞌbú nda go méngị wo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Zɨ́ Satána ógụné úku ledre zɨ́a kɨ́dí, “Togụ́ áyí tɨ́ mbigí Owụ́ ꞌbɨ Lomo yá, ídí úku ledre zɨ́ owụ́ tutú ga bɨ bi ba idínɨ́ óyólóꞌbó royé káa do ambata gɨ ro zɨ́yị ánu a gɨ zɨ́ ꞌbú.” ");
INSERT INTO bdh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Zɨ́ Yésụ ị́nyịné úkulúgu ledre zɨ́ Satána kɨ́dí, “Nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘ꞌYịmaꞌdí utúasá ídí trịdrị lá dụụ́ gɨ zɨ́ éyị́ mɨánu wá. Kúrú Lomo nɨ óto ꞌyị e ne zɨ́ye ídíye trịdrị.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gɨ do kacɨ́ ledre née, zɨ́ ngére ꞌbɨ bɨcayi lomo e ꞌdíꞌbi Yésụ ndéré ékị́ kɨ́e do mongụ́ ꞌDị́cị́ ꞌbɨ Lomo sɨmɨ Yerụsaléma bɨ oꞌbónɨ́ ngbángbáne ꞌdága ní do úku ledre zɨ́a kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Togụ́ áyí tɨ́ Owụ́ ꞌbɨ Lomo yá, ídí mu léꞌbéútú bi ꞌdáa. Gɨ zɨ́a nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, “ ‘Lomo nɨ kása maláyika ené e zɨ́ye sáká yị́ị, káa bɨ áyí útú útru sịndị́yị ro tutú e ke.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zɨ́ Yésụ úkulúgu ledre zɨ́ Satána kɨ́dí, “Nɨ mɨékéne kɨ́dí, ‘Ndá úzu Ngére Lomo eyị́ wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Zɨ́ ngére ꞌbɨ bɨcayi lomo e kpá ꞌdiꞌbi wo ndéré ékị́ kɨ́e do mongụ́ ngbángbá landa ꞌdága, zɨ́a ꞌdódo káṇgá e kɨ́ manda eyé e kɨ́ rokoꞌbụ ga bɨ zɨ́ye ní mbá zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Zɨ́a úku ledre zɨ́ Yésụ kɨ́dí, “Togụ́ útú cakaba bi zɨ́yị óto úndrumá yá, éyị́ ga bɨ za mbá máꞌdódo yée zɨ́yị née, mááyí íꞌbí yée zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zɨ́ Yésụ úku ledre zɨ́ Satána kɨ́dí, “Ídí ị́nyị gɨ cigíma íri, nɨ mɨékéne kɨ́dí, ídí óto úndru Ngére Lomo eyị́ zɨ́yị ndị́sịyị́ méngị dụụ́ ledre ené.” ");
INSERT INTO bdh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Gɨ do kacɨ́ ledre née ní, zɨ́ ngére ꞌbɨ bɨcayi lomo e ndéréóyó roné, zɨ́ maláyika e nda ógụyé sáká wo. ");
INSERT INTO bdh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kacɨ́ ledre née luꞌbú wá, do ónzó Yiwáni ꞌyị Bábátị́zị́ ꞌyị e sɨmɨ sị́gịnị. Sɨmɨ bɨ Yésụ uwú kɨ́dí onzónɨ́ Yiwáni go sɨmɨ sị́gịnị ní, zɨ́a ị́nyịné ndáꞌbalúgu roné sɨmɨ káṇgá bɨ Galiláya ní. ");
INSERT INTO bdh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndịsị ené kóo sɨmɨ Nazeréta ore wá, okpó geré mɨókpó sɨmɨ gara bɨ Kapáranawúma ní. Gara máa née nɨ kóo do gbúṛóngó mɨkavu Galiláya mɨꞌdí sɨmɨ káṇgá ꞌbɨ kúfú ꞌyị ga bɨ Zebụlụ́na kɨ́ Nafatáli ní. ");
INSERT INTO bdh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ledre née utúasá go kpịnị kɨ́ ledre bɨ nébị Isáya uku ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ꞌYị ga bɨ Zebụlụ́na e kɨ́ Nafatáli e ní, ndịsịnɨ́ ndị́sị gbóo kóꞌdụ́ mɨkavu Galiláya, née Yụ́da e. ꞌYị ga bɨ ndịsịnɨ́ sága Yeredéne gɨ ꞌdí keṛị́ nda kɨ́ yée ga bɨ sɨmɨ Galiláya ní, nɨyí ꞌyị ga bɨ ngárá ndanɨ́ Yụ́da e wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ꞌYị ga bɨ ndịsịnɨ́ kóo ndị́sị sɨmɨ mɨtụlụrụ ní, mongụ́ bimɨóṇgó ogụ go zɨ́ye. Yée máa ga bɨ kóo ndịsịnɨ́ ꞌbɨ eyé do bi bɨ umbu ndịsị íꞌbí ꞌdoꞌdó ro ꞌyị e sɨmɨ a ní, bimɨóṇgó oṇgó go zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gɨ sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ Yésụ tónóne úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e kɨ́dí, “Ídísé óyólóꞌbó mɨmbéꞌdesé zɨ́se ṇgúṇgu ledre ꞌbɨ Lomo. Gɨ zɨ́a sịndị́ kadra nɨ go gbóo gɨ ro zɨ́a ídíne káa do Ngére esé.” ");
INSERT INTO bdh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kadra kị́éꞌdo, Yésụ nɨ go ndị́sị ndéré do gbúṛóngó mɨkavu Galiláya, zɨ́a lúrúndíki Simúna Pétero kɨ́ lúnduné Andiríya. Nɨyí go ndị́sị ónzó mbírá kénzé eyé sɨmɨ iní. ");
INSERT INTO bdh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zɨ́a ndólo yée kɨ́dí, “Ógụsé mu ndị́sị lódụ́ kacɨ́ma, gɨ ro zɨ́ma óto sée káa do ꞌyị ꞌdíꞌbiógụ ꞌyị e zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sɨmɨ bɨ uwúnɨ́ ledre née kenée ní, geré zɨ́ye ótoómo mbírá eyé ore zɨ́ye ógụ útúye do kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zɨ́ye ókpóye gɨ ore ꞌdáꞌdá, zɨ́a ndíki Zebedị́ya kɨ́ wotị́ne e gbre, Yakóbo kɨ́ lúnduné Yiwáni. Nɨyí sɨmɨ kuṛúngba ndị́sị yéme komo mbírá eyé. Zɨ́ Yésụ ndólo phɨṛangá ga gére née gbrengárá kɨ́ lúnduné. ");
INSERT INTO bdh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Geré zɨ́ye ótoómo mbírá eyé kɨ́ ꞌbụyé ore, do útúye do kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zɨ́ Yésụ gámáne sɨmɨ Galiláya mbá. Togụ́ ogụ ndiki ꞌyị e go sɨmɨ ꞌDị́cị́ Kótrụro e, nɨyí ndị́sị íni ini zɨ́ Lomo yá, zɨ́a ꞌdódo ledre ꞌbɨ Lomo zɨ́ye ore. Zɨ́a kpá úku bɨlámá ledre bɨ yeme gɨ ro ꞌyịmaꞌdí e ní zɨ́ye. ꞌYị ga bɨ nɨyí kɨ́ ṛị́kị́ ndíyá e royé ore ní, zɨ́a kpá yómo yée gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zɨ́ phanda ledre bɨ Yésụ ndịsị méngị a née áṇgané sɨmɨ ị́rịgbére bɨ Sụ́rịya ní mbá. Zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụyé kɨ́ ṛị́kị́ ndíyá eyé e zɨ́ Yésụ ndị́sịné ꞌdíꞌbióyó a gɨ royé. ꞌYị máa yée ga bɨ nɨyí kɨ́ dokéké sɨmɨyé, kɨ́ yée ga bɨ sɨmɨ doyé sinyí go mɨsínyí ní, nda kɨ́ yée ga bɨ kɨ́ umbu sịndị́ye ní, zɨ́a yómo yée mbá. ");
INSERT INTO bdh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụyé zɨ́ Yésụ. ꞌYị ga bɨ gɨ sɨmɨ Galiláya, kɨ́ yée ga bɨ gɨ sɨmɨ gara bɨ Dikapolị́sị, kɨ́ Yerụsaléma, kɨ́ káṇgá bɨ Yụdáya, nda kɨ́ yée ga bɨ gɨ sága ngbuṛu Yeredéne ní mbá. ");
INSERT INTO bdh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sɨmɨ bɨ Yésụ lurú tụ́ꞌdụ́ ꞌyị e nɨyí go ndị́sị ógụ zɨ́ne kɨ́ngaya ní, zɨ́a ékị́ ndị́sịné gá do landa. Zɨ́ ꞌyị lódụ́ kacɨ́ga ógụ ndị́sịyé cigí a. ");
INSERT INTO bdh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Zɨ́a tónóne ꞌdódo ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní, bɨlámá bi bɨ ꞌbe Lomo komo ere ꞌdáa ní, nɨ ídí ꞌbɨ eyé. ");
INSERT INTO bdh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ndịsịnɨ́ íni ini gɨ zɨ́a bɨ bi sínyí royé mɨsínyí ní, nɨyí karanée ídí kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌbúóꞌbụ́ royé mɨꞌbúóꞌbụ́ ní, nɨyí ídí ye mị́ngị́ do sogo káṇgá ba. ");
INSERT INTO bdh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ꞌbú kɨ́ kodró ꞌbɨ mɨméngị ledre ga bɨ Lomo ili yée ní doyé ní, nɨyí ídí ye mɨléreyé gɨ zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị bɨlámá ledre zɨ́ lafúye ní, Lomo nɨ kpá méngị bɨlámá ledre zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ bɨsinyí ledre ndaá do mɨmbéꞌdeyé wá ní, nɨyí lúrú Lomo cụ́ kɨ́ komoyé. ");
INSERT INTO bdh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌdíꞌbiógụ dụụ́ bɨlámá ledre dongará ꞌyị e ní, nɨyí ndị́sị ndólo yée Owụ́ ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Úndru nɨ ídí zɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị yée bɨsinyíne gɨ zɨ́a bɨ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní, nɨyí ídíye ꞌbe ꞌbɨ Lomo komo ere. ");
INSERT INTO bdh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Úndru nɨ ídí zɨ́se sɨmɨ bɨ ꞌyị e nɨyí ndị́sị úku sée, ꞌdóꞌdo sée kɨ́ ndị́sị trótro tụ́ꞌdụ́ bɨsinyí ledre e rosé kɨ́ ṛanga gɨ zɨ́a bɨ ṇgúṇgusé ledre amá ní. ");
INSERT INTO bdh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bi nda sínyí rosé wá. Ídísé kúkugú kɨ́ rokinyi, gɨ zɨ́a tákpásị́lị́ esé nɨ ídí mongụ́ne komo ere. Ndịsịnɨ́ kóo méngị lárá nébị ga bɨ kóo gɨ zɨ́se ꞌdesị́ ꞌdáꞌdá ní kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Zɨ́ Yésụ kpá fú ndị́sịné ꞌdódo ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ásé do sogo káṇgá ba káa zɨ́ toꞌdo ní. Tɨ́ lá togụ́ toꞌdo nzulú go ní, nɨ útúásá áyálúgu roné káa be ꞌdi? Odụ a dụụ́ do léfeóyó a ꞌdáꞌba zɨ́ ꞌyị e ndị́sị gámáye doa. ");
INSERT INTO bdh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nda kpá lá dụụ́ toꞌdo wá, ásé do sogo káṇgá ba káa zɨ́ bimɨóṇgó ní, gɨ zɨ́a gara bɨ oꞌbónɨ́ wo có do landa ꞌdága ní, utúasá ené lóꞌbo wá. ");
INSERT INTO bdh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kpá kenée ꞌyị e ụndụnɨ́ eyé phoꞌdụ lóꞌbụꞌdụ́tụ a sị́ pheṛé wá. Ndịsịnɨ́ yị́ eyé óto a do nyárá bi gɨ ro zɨ́a óṇgó bi zɨ́ ꞌyị e ꞌdị́cị́ ore mbá. ");
INSERT INTO bdh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mɨméngị ledre esé idí ídí bimɨóṇgó zɨ́ ꞌyị e gɨ ro zɨ́ye lúrú bɨlámá mɨméngị ledre esé zɨ́ye ndị́sịyé mbófo ꞌBụsé bɨ komo ere ní.” ");
INSERT INTO bdh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ndásé sómụ́ a bɨ kɨ́dí máógụ go ꞌdíꞌbióyó lorụ ga bɨ kóo ꞌbɨ nébị e ní wá, máógụ yị́ amá tɨ́ lá gɨ ro zɨ́ ꞌdódo ledre eyé ídíne maꞌdíi. ");
INSERT INTO bdh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Máúku zɨ́se maꞌdíi, tɨ́ káa zɨ́ bɨ do sogo káṇgá kɨ́ ere nɨ aka bo ba ní, utúasánɨ́ ꞌdíꞌbióyó ngíti owụ́ ledre cúkuꞌdée gɨ dongará ledre ga bɨ ekénɨ́ sɨmɨ lorụ ꞌbɨ Lomo ní wá, ꞌbúó togụ́ ledre ga bɨ ekénɨ́ yée sɨmɨ lorụ née mengịnɨ́ royé go mbá ní. ");
INSERT INTO bdh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ꞌYị bɨ asi go gɨ ro ledre kị́éꞌdo gɨ dongará ledre ga bɨ ekénɨ́ yée sɨmɨ lorụ ꞌbɨ Lomo, zɨ́a sínyi do ngíti ꞌyị idí kpá ási kenée ní, ꞌyị máa née utúasá ídí kɨ́ ledrené owóowó ꞌbe ꞌbɨ Lomo komo ere wá. ꞌYị máa wo bɨ nɨ ṇgúṇgu ledre lorụ ꞌbɨ Lomo zɨ́a ndị́sịné ꞌdódotátá a zɨ́ lafúne e ní, nɨ ídí kɨ́ ledrené owóowó ꞌbe ꞌbɨ Lomo komo ere. ");
INSERT INTO bdh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gɨ zɨ́ kéyị née ní máúku zɨ́se, togụ́ méngịsé ledre ga bɨ Lomo ili yée ní rómo do Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ e wá, útúásásé ólụ́ ꞌbe ꞌbɨ Lomo komo ere wá.” ");
INSERT INTO bdh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Úwúsé ledre bɨ kóo ukunɨ́ zɨ́ bulúnduzé ga bɨ kóo ꞌdesị́ ní go kɨ́dí, ‘Ndá úfu ꞌyị wá.’ ꞌYị bɨ nɨ úfu ꞌyị ní, nɨyí ꞌdécị ngbanga roa. ");
INSERT INTO bdh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tɨ́ lá máúku zɨ́se ꞌyị bɨ sɨmɨa ndịsị ésị́ bɨsinyíne ro lafúne e ní, nɨyí ꞌdécị ngbanga roa. Kpá kenée ꞌyị máa wo bɨ nɨ ndólo ezené yaá nɨ ꞌyị ṛifu ní, nɨyí ꞌdíꞌbi wo ndéré kɨ́e kóꞌdụ́ mɨngburoko ꞌyị ꞌdécị ngbanga e. Tɨ́ lá ꞌyị máa wo bɨ nɨ úku ledre yaá moko ndaá sɨmɨ ezené wá ní, nɨyí ụ́cụ wo ku phoꞌdụ bɨ ngárá ịlị́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bɨ kenée ní, togụ́ íli gáa go ndéré íꞌbí tákpásị́lị́ sị́ mbayi, zɨ́yị sómụ́ndíki a kɨ́dí ledre nɨ bo dongaráse kɨ́ ngíti ꞌyị yá, ");
INSERT INTO bdh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ídí ótoómo tákpásị́lị́ née dongá mbayi ore kí, zɨ́yị ndéréyị zɨ́se yéme dongaráse kɨ́ ꞌyị née, zɨ́yị nda ndáꞌbaógụyị́ íꞌbí tákpásị́lị́ eyị́. ");
INSERT INTO bdh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Togụ́ lúyú ledre go ro ngíti ꞌyị, ili go ndéré kɨ́yị do ngbanga yá, ídí ndéré zɨ́se yéme ledre née kéne ꞌdáꞌdá gɨ zɨ́a kɨ́ ndéréne kɨ́yị do ngbanga, káa bɨ ngére nɨyí íꞌbí yị́ị do ónzó yị́ị sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Máúku zɨ́se maꞌdíi, áyí ídí sɨmɨ sị́gịnị íri ólụ́ógụ wá ꞌbúó togụ́ késị́ bɨ ilinɨ́ gɨ zɨ́yị ní íꞌbí go mbá.” ");
INSERT INTO bdh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Úwúsé ledre kóo ukunɨ́ zɨ́ ꞌyị ezé ga bɨ kóna ní go kɨ́dí, ‘Ndá méngị ꞌberị wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tɨ́ lá máúku zɨ́se maꞌdíi, ꞌyị bɨ lurú kára zɨ́ ꞌbú kára máa née méngị wo ní, ndịsị go kɨ́ kára née sɨmɨ sómụ́ ledre. ");
INSERT INTO bdh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Togụ́ komoyị́ bɨ do anú ayí óto yị́ị zɨ́yị lúyú ledre yá, ídí ꞌdíꞌbióyó komoyị́ máa née ꞌdáꞌba. Nɨ bɨlámáne zɨ́ kémbị́ éyị́ sínyíne gɨ royị́ gɨ zɨ́ wo bɨ do ụ́cụ kụṛụꞌbụyị́ nyé ku phoꞌdụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kpá kenée togụ́ sị́lị́yị ꞌbɨ anú ayí óto yị́ị zɨ́yị lúyú ledre yá, ídí ꞌdíꞌbióyó sị́lị́yị née ꞌdáꞌba. Nɨ bɨlámáne zɨ́ kémbị́ éyị́ sínyíne gɨ royị́ gɨ zɨ́ wo bɨ do ụ́cụ kụṛụꞌbụyị́ nyé ku phoꞌdụ ní.” ");
INSERT INTO bdh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ngíti ꞌdódo ledre nɨ kpá káa, ‘oꞌdo bɨ otoomo meꞌbené go ní, idí íꞌbí wáraga ꞌbɨ ótoómo roꞌyị zɨ́ kára máa née.’ ");
INSERT INTO bdh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tɨ́ lá máúku zɨ́se maꞌdíi, ꞌyị bɨ ótoómo meꞌbené lá gbékpị́ne ndaá gɨ zɨ́a bɨ mengị ꞌberị ní wá ní, oto kára née go ꞌyị méngị ꞌberị. ꞌYị bɨ nɨ ofụ́ kára bɨ oꞌdo otoomo wo née ní, mengị ꞌberị go.” ");
INSERT INTO bdh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ngíti ꞌdódo ledre nɨ kóo kpá káa, zɨ́ bulúnduzé ga kóna ꞌdesị́ ní kɨ́dí, ‘Ledre bɨ lóbụ́ go kóꞌdụ́ Ngére Lomo ní, ndá óyólóꞌbó a wá idí ídí do biné.’ ");
INSERT INTO bdh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tɨ́ lá máúku zɨ́se, ndásé lólóbụ́ kú wá, togụ́ mbú lóbụ́ ere, gɨ zɨ́a née bi ndị́sị ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ndásé kpá lóbụ́ do sogo káṇgá wá gɨ zɨ́a Lomo ndịsị óto sịndị́ne doa. Ndásé kpá gbawá lólóbụ́ kɨ́ ịrị Yerụsaléma, nɨ mongụ́ gara ꞌbɨ Mongụ́ Ngére. ");
INSERT INTO bdh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndá kpá lólóbụ́ kɨ́ ịrị bị doyị́ wá, gɨ zɨ́a utúasá eyị́ ótoógụ kémbị́ bịdo zɨ́a ídíne bụkụlụné togụ́ mbú bɨkenyị́ne ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bɨlámá a ídí úku lá éyị́ kị́éꞌdo, togụ́ ‘Ɨɨ’ idí ídí ‘ɨɨ,’ togụ́ ‘Ɨ́ꞌɨ’ idí ídí ‘ɨ́ꞌɨ.’ Mɨúkuókpó ledre káa zɨ́ yée ga gére ní ndịsị ógụ gɨ zɨ́ Satána.” ");
INSERT INTO bdh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ngíti ꞌdódo ledre nɨ kóo kpá káa, zɨ́ bulúnduzé ga kóna ní kɨ́dí, ‘Togụ́ ꞌyị mengịnɨ́ okó zɨ́ ngíti a útrulóko komo ezené yá, idínɨ́ kpá útrulóko ꞌbɨ ené. Togụ́ utruꞌdewe so ezené yá, idínɨ́ kpá útruꞌdéwe ꞌbɨ ené.’ ");
INSERT INTO bdh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tɨ́ lá máúku zɨ́se, ꞌyị ndaá méngịlúgu bɨsinyí ledre kɨ́ bɨsinyí ledre wá. Togụ́ ꞌyị ongbo komoyị́, ídí óyó wo bɨ gɨ ꞌdíkeṛị́ ní zɨ́a kpá óngbo a. ");
INSERT INTO bdh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Togụ́ ngíti ꞌyị ili ndólo yị́ị kóꞌdụ́ ngére e gɨ ro ꞌdíꞌbi ngúru bongó gɨ zɨ́yị yá, ídí ꞌdíꞌbi ngíti a tákpa ro wo bɨ kị́éꞌdo née íꞌbí a zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Togụ́ asikíri gaga yị́ị ị́mbị́ éyị́ ené, ndéré ꞌdógụ ngbuṛu kɨ́e kị́éꞌdo yá, ídí ị́mbị́ tátá a ndéré ꞌdógụ ngbuṛu e kɨ́e gbre. ");
INSERT INTO bdh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Togụ́ ꞌyị ombo éyị́ gɨ zɨ́yị yá, komoyị́ ndaá ị́ndị́ kɨ́e wá, ídí íꞌbí a zɨ́a. Wo bɨ ili sáká késị́ gɨ zɨ́yị ní, ídí íꞌbí a zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ngíti ꞌdódo ledre nɨ kóo kpá káa, zɨ́ bulúnduzé ga kóna ní kɨ́dí, ‘Ídí óto ꞌbú lafúyị e zɨ́yị sógó ezeokóyị e.’ ");
INSERT INTO bdh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tɨ́ lá máúku zɨ́se, ídísé óto ꞌbú ezeokóse e, zɨ́se ndị́sịsé íni ini zɨ́ Lomo gɨ ro ngíti géyị ꞌyị ga bɨ ndịsịnɨ́ méngị sée bɨsinyíne ní, ");
INSERT INTO bdh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","méngị kéyị kenée, nɨ óto sée zɨ́se ídíse mbigí owụ́ ga bɨ ꞌbɨ ꞌBụsé bɨ komo ere ní. Wo Lomo, ndịsị ótoómo kadra súwuné zɨ́ bɨsinyí ꞌyị e kpá kɨ́ bɨlámá ꞌyị e. Zɨ́a ndị́sịné kása iní zɨ́ ꞌyị méngị bɨsinyí ledre kpá kɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní. ");
INSERT INTO bdh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Togụ́ ótosé lá dụụ́ ꞌbú ꞌyị ga bɨ ndịsịnɨ́ óto ꞌbúse ní, Lomo nɨ nda íꞌbí tákpásị́lị́ zɨ́se gɨ ro ꞌdi? Gba ꞌyị ga bɨ ndịsịnɨ́ ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e ní ndịsịnɨ́ méngị kéyị kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Togụ́ íꞌbí mandá lá dụụ́ zɨ́ lafúyị e ní, bɨlámá ledre bɨ ore romo do ꞌbɨ lafúyị e ní wo be? Née ndaá kpá ledre bɨ ꞌyị ga bɨ ṇguṇgunɨ́ aka ledre ꞌbɨ Lomo wá ndịsịnɨ́ méngị a ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kacɨ́ kadra mbá, mɨméngị ledre esé idí ídí bɨlámáne káa zɨ́ bɨ mɨméngị ledre ꞌbɨ ꞌBụsé bɨ komo ere nɨ bɨlámáne ní.” ");
INSERT INTO bdh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ndásé ꞌdódo méngị ledre ga bɨ Lomo ili yée ní gɨ ro zɨ́ ꞌyị e lúrú a wá, káa bɨ ásé zángá tákpásị́lị́ gɨ zɨ́ ꞌBụsé Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ꞌYị ga bɨ ndịsịnɨ́ lóndo royé kɨ́dí yée nɨyí mbigí ꞌyị ga bɨ ꞌbɨ Lomo ní, ndịsịnɨ́ méngị kéyị kenée ye. Sɨmɨ bɨ nɨyí go sɨmɨ ꞌDị́cị́ Kótrụro e togụ́ mbú do mɨsiꞌdi kɨ́ꞌdí bɨ ꞌyị e nɨyí ore tụ́ꞌdụ́ ní, ndịsịnɨ́ méngị kéyị kenée gɨ ro zɨ́ ꞌyị e ndị́sị mbófo yée. Máúku zɨ́se, odụ tákpásị́lị́ eyé goó dụụ́ wo bɨ ꞌyị ga gére née iꞌbínɨ́ zɨ́ye née. ");
INSERT INTO bdh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Togụ́ íꞌbí éyị́ go zɨ́ ꞌyị yá, ndá ócó tarayị́ kɨ́e zɨ́ ꞌyị e ówo a mbá wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ꞌBụyị́ bɨ komo ere ꞌyị ówo mɨótoécị ledre ꞌbɨ ꞌyị e ní, idí ówo a lá dụụ́ ne gɨ ro zɨ́a íꞌbí tákpásị́lị́ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mááyí kpá úku a zɨ́se, ndásé ídí káa zɨ́ ꞌyị ga bɨ ndịsịnɨ́ lóndo royé togụ́ nɨyí go sɨmɨ ꞌDị́cị́ Kótrụro e togụ́ mbú dogboṛụ mɨsiꞌdi kɨ́ꞌdí bɨ tụ́ꞌdụ́ ꞌyị e nɨyí ore ní, zɨ́ye ndị́sị ị́nyịógụyé ndị́sị íni ini zɨ́ Lomo kɨ́ sómụ́ ledre bɨ gɨ ro zɨ́ ꞌyị e ówo yée kɨ́dí yée nɨyí mbigí ꞌyị ga bɨ ꞌbɨ Lomo ní, ꞌyị ga bɨ ndịsịnɨ́ méngị kéyị kenée ní, ꞌdiꞌbinɨ́ tákpásị́lị́ eyé go gɨ zɨ́ ꞌyịmaꞌdí e, ndaá gɨ zɨ́ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Togụ́ íli íni ini yá, ídí ólụ́ ꞌdị́cị́, zɨ́yị ꞌdụ́tụ mbotụ kacɨ́yị, zɨ́yị íni ini zɨ́ ꞌBụyị́ bɨ komo ere ní ndoo sɨmɨ ugu roné. Nɨ ꞌyị bɨ owo ledre ga bɨ do mɨmbéꞌde ꞌyị e ní mbá bú, nɨ íꞌbí tákpásị́lị́ zɨ́yị ne. ");
INSERT INTO bdh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Togụ́ áyí go íni ini maꞌdáa yá, ndá ndị́sị lála tụ́ꞌdụ́ ledre e ngbángáne káa zɨ́ ꞌyị ga bɨ owonɨ́ aka Lomo wá ní wá. Somụ́nɨ́ ꞌbɨ eyé kɨ́dí Lomo nɨ úwú ini eyé gɨ zɨ́ tụ́ꞌdụ́ ledre ga bɨ yée nɨyí úku a ní. ");
INSERT INTO bdh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ndá ídí káa zɨ́ye wá. Gɨ zɨ́a éyị́ ga bɨ íli yée ní, ꞌBụyị́ owo mbá bú ꞌdáꞌdá gɨ zɨ́yị kɨ́ ndúꞌyú wo. ");
INSERT INTO bdh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ini esé idí ídí káa, “ ‘ꞌBụzé komo ere, ꞌyị e za mbá idínɨ́ óto úndruyị́, ");
INSERT INTO bdh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","idínɨ́ ówo yị́ị káa do Ngére eyé, idínɨ́ méngị ledre eyị́ do sogo káṇgá ona káa zɨ́ bɨ komo ere ꞌdága íri ní. ");
INSERT INTO bdh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ídí íꞌbí éyị́ mɨánu ezé ꞌbɨ karaba zɨ́ze. ");
INSERT INTO bdh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ídí ótoómo lúyú ledre ezé zɨ́ze káa zɨ́ bɨ ndịsịzé ótoómo a zɨ́ yée ga bɨ ndịsịnɨ́ lúyú rozé ní. ");
INSERT INTO bdh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndá úzu zée kɨ́ngaya wá, ídí yómo zée gɨ zɨ́ Satána.’ ");
INSERT INTO bdh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Togụ́ ótoómosé ledre go zɨ́ ꞌyị ga bɨ mengịnɨ́ sée bɨsinyíne ní, ꞌBụsé bɨ komo ere ní, nɨ kpá ótoómo ledre zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Togụ́ ótoómosé ledre zɨ́ ꞌyị ga bɨ luyúnɨ́ ledre rosé ní wá, ꞌBụsé bɨ komo ere ní, ótoómo ené kpá lúyú ledre esé wá.” ");
INSERT INTO bdh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sɨmɨ bɨ ásé go órụ́ tarasé ní, ndásé óto rosé zɨ́ do komosé ídíne bɨsinyíne káa zɨ́ ꞌyị ga bɨ ndịsịnɨ́ lóndo royé gɨ ro do ówo a mbá kɨ́dí ásé go órụ́ tarasé ní wá. ꞌYị ga bɨ owonɨ́ Lomo wá ní, ndịsịnɨ́ méngị kéyị kenée ye. Máúku zɨ́se, yée máa ga gére née ndikinɨ́ tákpásị́lị́ eyé goó gɨ zɨ́ ꞌyịmaꞌdí e ndaá gɨ zɨ́ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Abú ásé ndị́sị órụ́ tarasé yá, sɨmɨ komosé kɨ́ rosé mbá idí ídí bɨlámáne káa zɨ́ bɨ lengbe ní. ");
INSERT INTO bdh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌYịmaꞌdí e ndanɨ́ ówo a bɨ ya ásé go órụ́ tarasé ní wá, ꞌBụsé bɨ komo ere bɨ ndịsị ówo ledre gɨ do mɨmbéꞌde ꞌyị ní, idí ówo a lá dụụ́ ne gɨ ro zɨ́a íꞌbí tákpásị́lị́ zɨ́se.” ");
INSERT INTO bdh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ndásé ꞌdóꞌdụ́yóko éyị́ e zɨ́se do sogo káṇgá ona wá, gɨ zɨ́a ngánza nɨ ánu ngíti géyị, zɨ́ kụndụ́ óꞌbó ngíti géyị, zɨ́ ꞌyị ugu e úgu ngíti géyị, zɨ́ éyị́ ga gére née sínyí eyé mbá. ");
INSERT INTO bdh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bɨlámá a ídísé óto komosé gɨ ro éyị́ ga bɨ komo ere ní. Gɨ zɨ́a ngánza kɨ́ kụndụ́ kɨ́ ꞌyị ugu e ndanɨ́ eyé íri gɨ ro sínyiónzó éyị́ ga gére née wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kacɨ́ kadra mbá, mɨmbéꞌdesé idí ídí gɨ ro éyị́ ga bɨ komo ere ní. ");
INSERT INTO bdh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Komosé nɨ káa zɨ́ mɨụ́ndụ phoꞌdụ ní, togụ́ ụndụnɨ́ phoꞌdụ bɨlámáne yá, ásé lúrú bi kacɨ́ a drá mɨtụlụrụ ndaá. ");
INSERT INTO bdh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Togụ́ komosé lurú bi bɨlámáne wá, ásé ndị́sị fú lá sɨmɨ mɨtụlụrụ. Kpá kenée togụ́ bimɨóṇgó ꞌbɨ Lomo ndaá sɨmɨsé wá, mɨtụlụrụ bɨ ásé ídí sɨmɨ a ní nɨ nda rómo mɨrómo. ");
INSERT INTO bdh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ꞌYị kị́éꞌdo útúásá ídí káa do ꞌyị ꞌbɨ ngére e gbre wá. Nɨ óto ꞌbú wo bɨ kị́éꞌdo ní, zɨ́a sógó ngíti a mɨsógó. Togụ́ kenée wá, nɨ óto úndru ngíti a rómo do eze a. Ndá óto komoyị́ ro Lomo kpá ro éyị́ ga bɨ ꞌbɨ sága ba wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndásé ndị́sị sómụ́ ledresé kɨ́ngaya kɨ́ rosé, ledre gɨ ro éyị́ mɨánu, iní mɨéwé, nda kɨ́ bongó e gɨ ro ésị yée wá. Ndaá ꞌbɨ ené bɨ ledre trịdrịsé nɨ zɨ́ Lomo owóowó rómo do éyị́ mɨánu ní wá, ndaá ꞌbɨ ené bɨ ledre kụṛụꞌbụsé nɨ zɨ́ Lomo owóowó rómo do bongó ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lúrúsé aka lá dụụ́ solụ́ e, yáká eyé ndaá, gbagba eyé ndaá kpá wá, ꞌBụzé bɨ komo ere ní ndịsị lúrú bi kacɨ́ye. Sée kɨ́ solụ́ e, ambí romonɨ́ do lafúye ní ye, ndaá sée wá? ");
INSERT INTO bdh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sómụ́ ledre bɨ ndịsịzé sómụ́ a gɨ rozé kɨ́ rozé ní, utúasá ené óto zée zɨ́ze lúꞌbúze do sogo káṇgá ba wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Éyị́ bɨ ndị́sịsé sómụ́ sɨmɨsé gɨ ro bongó gɨ roa ní ꞌdi? Lúrúsé aka gba mɨsụ́rụ́ kágá ga bɨ ngárá mengịnɨ́ moko wá ní, Lomo ndịsị kpá fú óto lámá royé. ");
INSERT INTO bdh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Abú kpá za cụ́ Solomóna mongụ́ ngére bɨ kóo ꞌbɨ Isɨréle e ní, kɨ́ tụ́ꞌdụ́ bɨlámá bongó ga bɨ kóo zɨ́ne ní mbá, lámá bɨ kóo roa ní, romo ené do lámá bɨ ro mɨsụ́rụ́ kágá e ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Togụ́ bɨ Lomo oto lámá bú ro éyị́ ga bɨ káa zɨ́ súwú e, karaba nɨyí ídí bɨlámáye kɨ́lóndó gagánɨ́ go zɨ́ye áṛáónzó royé ní, ala nda sée ga bɨ kɨ́ ledresé zɨ́a owóowó ní? Éyị́ bɨ ṇgúṇgusé ledre ꞌbɨ Lomo kɨ́ rokoꞌbụné gɨ zɨ́a wá ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ndásé ndị́sị sómụ́ ledre bɨ kɨ́dí, azé ánu karaba ꞌdíya, azé ndíki iní éwé a ꞌdáya, azé ndíki bongó ésị a ꞌdáya ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ꞌYị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní ndịsịnɨ́ sómụ́ ledre kenée ye. ꞌBụsé bɨ komo ere ní, owo yị́ ené éyị́ ga bɨ ílisé yée ní mbá bú. ");
INSERT INTO bdh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mɨzefị ledre, ídísé óto Lomo kɨ́ ledrené owóowó, zɨ́se ndị́sịsé méngị ledre ga bɨ Lomo ili yée ní. Éyị́ ga bɨ za mbá ílisé yée ní, nɨ íꞌbí yée zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ndásé ndị́sị sómụ́ ledre ga bɨ ꞌbɨ kɨ́lóndó ní wá, kɨ́lóndó owo ledre ga bɨ gɨ roné ní ne. Ídísé óto komosé dụụ́ gɨ ro ledre ga bɨ ꞌbɨ karaba ní ní.” ");
INSERT INTO bdh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ndá ꞌdécị ngbanga lafúyị e wá, káa bɨ Lomo nɨ kpá ꞌdécị ngbangayị́ ke. ");
INSERT INTO bdh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gɨ zɨ́a mɨsiꞌdi bɨ ndị́sị ꞌdíꞌbi a ꞌdécị ngbanga lafúyị e doa née ní, Lomo nɨ ꞌdíꞌbi kpá wo ꞌdécị ngbangayị́ doa. Éyị́ bɨ méngị kɨ́ye ní, nɨ méngị kpá wo kɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Éyị́ bɨ ndị́sịsé úku ledre owụ́ lúyú ledre ꞌbɨ lafúse e bɨ cúkuꞌdée ní kɨ́ rokoꞌbụné rómo do ꞌbɨ esé mɨngburoko lúyú ledre e gɨ zɨ́a ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Áyí úku ledre zɨ́ ezeyị́ yaá née idí ꞌdíꞌbióyó owụ́ cící éyị́ gɨ komoa lárá a káa be ꞌdi? Sɨmɨ bɨ útúásá eyị́ lúrúndíki mongụ́ kụṛụꞌbụ éyị́ bɨ komoyị́ ní kɨ́ royị́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sée ꞌyị ga bɨ ndị́sịsé lóndo rosé gɨ ro zɨ́ ꞌyị e ówo sée ní, ídísé ꞌdíꞌbióyó mongụ́ kụṛụꞌbụ éyị́ bɨ komosé ní kí, gɨ ro zɨ́ komosé ídíne drá, ásé nda fú ꞌdíꞌbióyó owụ́ cící éyị́ gɨ komo lafúse.” ");
INSERT INTO bdh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Zɨ́ Yésụ kpá úku ngíti ledre kɨ́dí, “Ndá íꞌbí éyị́ bɨ ꞌbɨ Lomo ní zɨ́ ị́sị wá. Éyị́ bɨ nɨ mɨṛíṛíne bɨlámáne káa zɨ́ dábu ní, ndá ụ́cụóto a kóꞌdụ́ mụkụ́ṛụ́ e bi wá, nɨyí ndị́sị ꞌdítí sínyi a. Zɨ́ye ndáꞌbayé náná báyi sɨmɨyị́ nzéré nzéré. ");
INSERT INTO bdh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Éyị́ bɨ íli ní, ídí ómbo a Lomo nɨ íꞌbí a zɨ́yị. Éyị́ bɨ ndaá zɨ́yị wá ní, ídí gámásóꞌdo a áyí ndíki a. Ídí kóko mbotụ, Lomo nɨ líkpí a zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ꞌYị bɨ ndịsị ómbo éyị́ ní, nɨyí íꞌbí a zɨ́a. ꞌYị bɨ ndịsị gámásóꞌdo éyị́ ní, nɨ ndíki a. ꞌYị bɨ ndịsị kóko mbotụ ní, nɨyí líkpí a zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ambí nɨ dongaráse ore ne togụ́ owụ́ ꞌbɨ ené ombo ambata yá zɨ́a ꞌdíꞌbi tutú íꞌbí a zɨ́a ní? ");
INSERT INTO bdh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Togụ́ ombo kénzé yá, zɨ́a ꞌdíꞌbi kámá íꞌbí a zɨ́a ní? ");
INSERT INTO bdh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tɨ́ bɨ ásé ꞌyị lúyú ledre e ní, ówosé kacɨ́ íꞌbí bɨlámá éyị́ e bú zɨ́ owụ́ ꞌbɨ esé e. Bɨ kenée ní, ꞌBụsé bɨ komo ere ní, nɨ nzíyiné gɨ ro íꞌbí bɨlámá éyị́ zɨ́ ꞌyị bɨ ombo ní rómo do ꞌbɨ esé. ");
INSERT INTO bdh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Bɨ goó kenée ní, sɨmɨ ledre mbá ídí méngị zɨ́ ꞌyị e éyị́ bɨ íli zɨ́ye méngị a zɨ́yị ní. Ledre née kotrụ goó zaá ledre gɨ ro ledre lorụ kɨ́ ledre gɨ ro nébị e mbá. ");
INSERT INTO bdh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ídí ólụ́ ꞌbe ꞌbɨ Lomo gɨ do owụ́ mbotụ bɨ cúkuꞌdée ní. Mongụ́ mbotụ bɨ wé, kɨ́ mongụ́ mɨsiꞌdi bɨ ngúó ní, tụ́ꞌdụ́ ꞌyị e ndịsịnɨ́ ndéré gɨ doa zɨ́ umbu. ");
INSERT INTO bdh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tɨ́ lá owụ́ mbotụ kɨ́ owụ́ mɨsiꞌdi bɨ cúkuꞌdée ní, ꞌyị e cúkuꞌdée nɨyí ndéré gɨ doa lá ye ndíki trịdrị. ");
INSERT INTO bdh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Komosé idí ídí rosé gɨ zɨ́ nébị ga bɨ ꞌyị ṛanga e ní. Nɨyí ógụ zɨ́se kɨ́ bɨlámá tosoyé lá gɨ ꞌdí sága, tɨ́ lá nda mɨꞌdí sɨmɨ, nɨyí yị́ eyé káa zɨ́ bangá sinyí e ní. ");
INSERT INTO bdh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ásé ówoyéme yée dụụ́ gɨ ro mɨánáye. ꞌYị e utúasánɨ́ go ꞌdécị mánga gɨ komo kị́nị togụ́ mbú goófo gɨ komo ngéyé? ");
INSERT INTO bdh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kpá kenée bɨlámá kágá ndịsị ána dụụ́ bɨlámá mɨánáne, bɨsinyí kágá áná ꞌbɨ ené kpá dụụ́ bɨsinyí mɨánáne. ");
INSERT INTO bdh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bɨlámá kágá aná ené bɨsinyí mɨáná kágá wá, bɨsinyí kágá aná ené kpá bɨlámá mɨáná kágá wá. ");
INSERT INTO bdh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kágá máa yée ga bɨ ilinɨ́ áná bɨlámá mɨánáye wá ní, mị́ngị́ a nɨ lágáóyó a ꞌdáꞌba do óngbó a. ");
INSERT INTO bdh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bɨ kenée ní, ásé ówoyéme nébị ga gére née gɨ zɨ́ mɨméngị ledre eyé. ");
INSERT INTO bdh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ndaá ꞌbɨ ené bɨ kɨ́dí ꞌyị ga bɨ za mbá ndịsịnɨ́ ndólo máa Ngére, Ngére ní, nɨyí ólụ́ mbá ꞌbe ꞌbɨ Lomo komo ere ní wá. Dụụ́ wo bɨ ndịsị méngị ledre ga bɨ Babá ili yée ní, nɨ ólụ́ dụụ́ ne íri. ");
INSERT INTO bdh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kadra bɨ Lomo nɨ ꞌdécị ngbanga ꞌyịmaꞌdí e ní, tụ́ꞌdụ́ ꞌyị e nɨyí ndólo máa, ‘Ngére, Ngére.’ Zɨ́ye ndị́sị úku ledre kɨ́dí, ndịsịzé kóo úku ledre eyị́ ze zɨ́ ꞌyị e kɨ́ rokoꞌbụ bɨ kóo íꞌbí zɨ́ze ní, zɨ́ze ndị́sịzé lágaóyó dokéké e gɨ sɨmɨ ꞌyị e kɨ́ ịrịyị́, zɨ́ze kpá kɨ́ méngị mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé ní. ");
INSERT INTO bdh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tɨ́ lá Mááyí úkulúgu ledre zɨ́ye máyá, ‘Máówo amá sée wá, ídísé ị́nyị gɨ romá íri sée ꞌyị luyú e.’ ");
INSERT INTO bdh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bɨ kenée ní, ꞌyị bɨ nɨ úwú ledre bɨ mááyí úku a ba, zɨ́a óto a sɨmɨ moko ní, nɨ go káa zɨ́ ꞌyị bɨ ụ́bụ́ ꞌdị́cị́ ené, do landa zɨ́ sị́ ꞌdị́cị́ maꞌdáa ídíne ngị́rị ní. ");
INSERT INTO bdh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Abú iní nɨ éꞌdị kɨ́ mongụ́ síli sɨmɨné ndị́sị ílíne ro ꞌdị́cị́ née, zɨ́ ngbuṛu úcuyé gị roa yá, ndụrụ wá gɨ zɨ́a otonɨ́ sị́ a go ngị́rị. ");
INSERT INTO bdh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kpá kenée, ꞌyị máa wo bɨ nɨ úwúómo ledre bɨ mááyí úku a ba lá kɨ́ mbílíne ní, nɨ go cé káa zɨ́ bɨcayi ꞌyị bɨ ụbụ́ ꞌdị́cị́ ené do sayi ní. ");
INSERT INTO bdh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sɨmɨ bɨ iní nɨ éꞌdị, zɨ́ ngbuṛu e úcuyé, zɨ́ mongụ́ síli ógụné ndị́sị kị́zị ꞌdị́cị́ née ní, nɨ geré ndụ́rụ sínyi roné bɨsinyíne.” ");
INSERT INTO bdh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sɨmɨ bɨ Yésụ ukuonzó ledre ga gére zɨ́ye kenée ní, zɨ́a lụ́tụ́ne komoyé, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ ꞌdódo ledre ené, ");
INSERT INTO bdh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","gɨ zɨ́a ꞌdódo ledre ené nɨ káa zɨ́ ꞌyị bɨ kɨ́ rokoꞌbụ zɨ́ne, ndaá ꞌbɨ ené káa zɨ́ ꞌbɨ ꞌyị ga bɨ ꞌyị ꞌdódo lorụ e ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sɨmɨ bɨ Yésụ nditíogụ gɨ do landa kɨ́ ꞌdódo ledre zɨ́ ꞌyị e ní, zɨ́ tụ́ꞌdụ́ ꞌyị e kpá útúye do kacɨ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Zɨ́ ngíti oꞌdo kɨ́ umbunonó roné ógụ útúne gbrị do ngụ́ṛụ́ sịndị́ne kóꞌdụ́ Yésụ ṇgúṇgú roné kɨ́dí, “Áko Mongụ́ ꞌyị, togụ́ utúasá go kacɨ́ komoyị́, ídí yéme máa zɨ́ romá ídíne drá.” ");
INSERT INTO bdh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zɨ́ Yésụ ꞌdózo sị́lị́ne óto a ro oꞌdo née zɨ́a úku ledre kɨ́dí, “Máíli go kenée royị́ eme mu.” Geré zɨ́ umbunonó née ụ́kụ́ne gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Zɨ́ Yésụ lórụ wo oꞌbụóꞌbụ kɨ́dí, “Éyị́ bɨ mengị roné zɨ́yị née ndá aka geré úku a zɨ́ ꞌyị e wá. Ídí aka ndéré zɨ́ ꞌyị ꞌdáná éyị́, togụ́ lurú royị́ utúasá kacɨ́ komoa go yá, nɨ ṇgúṇgu a kɨ́dí ɨɨ, royị́ eme go. Zɨ́yị nda ꞌdíꞌbi bangá ndéré óṇgoónzó a gɨ ro íꞌbílúgu mbófo éyị́ kɨ́e zɨ́ Lomo káa zɨ́ bɨ nɨ mɨékéne sɨmɨ lorụ ꞌbɨ Mụ́sa ní. ꞌYị e nɨyí geré ówo a mbá kɨ́dí royị́ eme go.” ");
INSERT INTO bdh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sɨmɨ bɨ Yésụ ndaꞌbaogụ sɨmɨ gara bɨ Kapáranawúma ní, zɨ́ ngúru mongụ́ ꞌyị ꞌbɨ asikíri e ꞌbɨ káṇgá ꞌbɨ Róma ógụné úku ledre zɨ́ Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mongụ́ ꞌyị, ꞌyị ꞌbɨ moko amá nɨ ꞌbe ꞌdáa mɨꞌdóꞌdóne kɨ́ngaya kɨ́ ndíyá umbu sịndị́, nɨ mɨꞌdúꞌduné gɨ zɨ́a bi.” ");
INSERT INTO bdh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Bɨlámáne mááyí ógụ yómo wo gɨ do ndíyá máa née.” ");
INSERT INTO bdh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Zɨ́ mongụ́ ꞌyị née úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, mááyí ꞌyị lúyú ledre, utúasá zɨ́yị ógụyị́ zɨ́ma ꞌbe wá. Ídí lá úku kása kúrúyị zɨ́ ꞌyị ꞌbɨ moko amá máa née ómoné. ");
INSERT INTO bdh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gɨ zɨ́a mándị́sị méngị moko sị́ sị́lị́ mɨngburoko ꞌyị ga bɨ domá ní. Zɨ́ma nda kpá ídíma mongụ́ ꞌyị do ngíti géyị ꞌyị e. Mááyí úku ledre zɨ́ ngíti a kɨ́dí, ‘Ídí ndéré ꞌdáa’ zɨ́a tɨ́ ndéréne, Mááyí ndólo ngíti a kɨ́dí, ‘Ógụ mu,’ zɨ́a tɨ́ ógụné. Mááyí úku ledre zɨ́ ꞌyị ꞌbɨ moko kɨ́dí, ‘Ídí méngị moko ba,’ zɨ́a tɨ́ méngị a.” ");
INSERT INTO bdh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sɨmɨ bɨ Yésụ uwú ledre née kenée ní, zɨ́a úku ledre zɨ́ ꞌyị ga bɨ ndịsịnɨ́ lódụ́ kacɨ́ne ní kɨ́dí, “Máúku zɨ́se maꞌdíi, sɨmɨ kúfúse Isɨréle e za mbá, mándíki aka ꞌyị kɨ́ ledre ꞌbɨ Lomo do mɨmbéꞌdené káa zɨ́ oꞌdo ba wá. ");
INSERT INTO bdh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Karanée ꞌdáꞌdá íri, ṛị́kị́ sị́ do ꞌyịmaꞌdí e gɨ sɨmɨ káṇgá eyé e mɨngúngúcua a nɨyí ndéré zɨ́ye ndị́sị kótrụ royé ndro sɨmɨ ayímbi ꞌbe ꞌbɨ Lomo kɨ́ Abarayáma e kɨ́ Isáka e kɨ́ Yakóbo e, mɨngburoko ꞌyị ga kóna ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ꞌdáꞌdá ní. ");
INSERT INTO bdh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kúfú Isɨréle e mbá nɨyí kóo ndéré ndị́sị ꞌbe ꞌbɨ Lomo sɨmɨ rokinyi née íri ye. Tɨ́ lá gɨ zɨ́a bɨ ilinɨ́ zɨ́ Lomo ídíne ne Ngére eyé wá ní, utúasánɨ́ lolụ ídí íri wá. Nɨyí ụ́cụ yée sɨmɨ mongụ́ mɨtụlụrụ kɨ́ꞌdí bɨ ꞌyị e nɨyí ndị́sị mbụ́mbụ́dụ́ kɨ́ náná do soyé gɨ zɨ́ éyị́ mɨówo ní.” ");
INSERT INTO bdh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zɨ́ Yésụ úku ledre zɨ́ mongụ́ ꞌyị gáa ogụ ndúꞌyú wo ní kɨ́dí, “Ndáꞌba mu ꞌbe. Ṇgúṇgu ledre eyị́ oto ꞌyị ndíyá eyị́ go zɨ́a ómoné.” Geré zɨ́ ndíyá ụ́kụ́ne gɨ ro ꞌyị ꞌbɨ moko née ꞌbe íri. ");
INSERT INTO bdh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sɨmɨ bɨ Yésụ nderéogụ ꞌbe ꞌbɨ Pétero ní, do úku ledre zɨ́a kɨ́dí ro towụ́ Pétero ịrị́ mɨị́rị́ nɨ mɨꞌdúꞌduné gɨ zɨ́a bi. ");
INSERT INTO bdh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zɨ́ Yésụ ólụ́ne zɨ́a ꞌdị́cị́ íri, zɨ́a ꞌdíꞌbi sị́lị́a lála sị́kpị wo ꞌdága, geré zɨ́ sɨmɨ saná a émené. Zɨ́a tónóne yéme éyị́ mɨánu zɨ́ Yésụ kɨ́ ꞌyị ené ga gére ní. ");
INSERT INTO bdh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nda sɨmɨ bɨ kadra utú go ní, zɨ́ tụ́ꞌdụ́ ꞌyị e ꞌdíꞌbiógụ ꞌyị eyé ga bɨ kɨ́ dokéké e sɨmɨyé ní zɨ́ Yésụ. Zɨ́a lá úku kúrúne, zɨ́ dokéké e ólụ́ógụyé mbá gɨ sɨmɨ ꞌyị ga bɨ gáa ogụnɨ́ kɨ́ye zɨ́a ní. Zɨ́a kpá yómo tụ́ꞌdụ́ ꞌyị ndíyá e. ");
INSERT INTO bdh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ledre née mengị roné go tɨ́ káa zɨ́ bɨ kóo nébị Isáya uku ní kɨ́dí, “ꞌDiꞌbioyó ndíyá gɨ rozé, zɨ́a ꞌdíꞌbióyó éyị́ mɨówo gɨ rozé.” ");
INSERT INTO bdh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sɨmɨ bɨ Yésụ lurú tụ́ꞌdụ́ ꞌyị e nɨyí kpá fú cigíne ore ní, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, yée ꞌdogụnɨ́ aka bi mu sága mɨkavu Galiláya gɨ ꞌdí keṛị́. ");
INSERT INTO bdh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ịnyịnɨ́ aka ndéré wá, zɨ́ ngúru ꞌyị ꞌdódo lorụ ꞌbɨ Mụ́sa ógụné úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, máíli zɨ́ze ndéréze kése gị do bi bɨ íli ndéré doa ní.” ");
INSERT INTO bdh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Zɨ́ Yésụ úkulúgu ledre zɨ́ oꞌdo née kɨ́dí, “Lúrú goó, gba oꞌdo bangá e emenɨ́ gɨ zɨ́ma ye gɨ zɨ́a nɨyí kɨ́ gu eyé e ndị́sị ꞌdúꞌdu sɨmɨ a. Solụ́ e nɨyí kɨ́ ꞌdị́cị́ eyé e ndịsịnɨ́ ꞌdúꞌdu sɨmɨ a. Tɨ́ lá Máa bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí ní, gba bi ꞌdówụ́ro ndaá zɨ́ma wá.” ");
INSERT INTO bdh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zɨ́ ngúru ꞌyị lódụ́ kacɨ́ga ị́nyịné úku ledre zɨ́a kɨ́dí, “Ngére, babá ngoko go, ili aka zɨ́ma ndáꞌbamá óto wo kí zɨ́ma ndáꞌbaógụmá lódụ́ kacɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “ꞌYị ga bɨ nɨyí go káa zɨ́ umbu ꞌyị e gɨ zɨ́a bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní idínɨ́ óto wo. Ógụ ꞌbɨ eyị́ mu lódụ́ kacɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nda gɨ ore zɨ́a ékị́ne sɨmɨ kuṛúngba, zɨ́ ꞌyị lódụ́ kacɨ́ga ékị́ lódụ́ kacɨ́ a, Yóó zɨ́ye ndéréye. ");
INSERT INTO bdh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nɨyí aka lá cịkị sɨmɨ yana iní, zɨ́ mongụ́ síli ógụné kpị kpị kpị ndị́sị ílí iní gbuwa gbuwa sɨmɨ kuṛúngba. Yésụ nɨ yị́ ené kóo mɨꞌdúꞌduné. ");
INSERT INTO bdh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zɨ́ ꞌyị lódụ́ kacɨ́ga ndéréye úru wo kɨ́dí, “Ngére, ꞌdiꞌdiya yómo zée mu azé go úyu.” ");
INSERT INTO bdh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sɨmɨ bɨ Yésụ ịnyịogụ ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Érésé ngịrị gɨ ro ꞌdi, ꞌdesị́ ba ṇgúṇgusé aka esé ledremá kɨ́ngaya fú lá wá?” Zɨ́a ị́nyịógụné ꞌdága úku ledre zɨ́ mongụ́ síli née zɨ́a tóroné zɨ́ bi ídíne sií. ");
INSERT INTO bdh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zɨ́ tara ꞌyị ené ga gére née ị́drị́ne mbá mɨị́drị́ zɨ́ye ndị́sị úku ledre dengbị́ye kɨ́dí, “Bɨ káa lárá ꞌyị ꞌdi? Bɨ síli uwú kúrú a gba ne ní.” ");
INSERT INTO bdh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sɨmɨ bɨ ꞌdogụnɨ́ bi go sága gɨ ꞌdí keṛị́ ní, zɨ́ye ndéréógụyé sɨmɨ owụ́ do ꞌbe ꞌbɨ ꞌyị ga bɨ ndịsịnɨ́ ndólo yée Gadára e ní. Nɨyí aka cịkị do mɨsiꞌdi, zɨ́ ngíti géyị yaꞌdá e gbre kɨ́ dokéké sɨmɨyé, bi gámá ꞌyị e ndaá gɨ do mɨsiꞌdi née gɨ zɨ́ rará bɨ ro yaꞌdá ga gére née wá. ");
INSERT INTO bdh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zɨ́ye úku ledre zɨ́ Yésụ kɨ́dí, “Yị́ị, Owụ́ ꞌbɨ Lomo, éyị́ bɨ íli gɨ zɨ́ze ní ꞌdi, ógụ liṇgi ba go gɨ ro ꞌdécị ngbanga rozé ꞌdáꞌdá gɨ zɨ́ sịndị́ kadra ꞌbɨ ꞌdécị ngbangazé?” ");
INSERT INTO bdh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ábuwá mụkụ́ṛụ́ nɨyí yị́ eyé kóo gbóo ore ndị́sị ánu éyị́ eyé. ");
INSERT INTO bdh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zɨ́ dokéké ga bɨ sɨmɨ yaꞌdá ga gére ní ṇgúṇgú royé zɨ́ Yésụ kɨ́dí, “Togụ́ ili lágaóyó zée gɨ sɨmɨ yaꞌdá ga ba yá, idí kása zée ndéré ndị́sị sɨmɨ mụkụ́ṛụ́ ga bɨ ꞌdáa ba.” ");
INSERT INTO bdh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Nderénɨ́ mu ólụ́ ndị́sị sɨmɨ mụkụ́ṛụ́ ga gére ní.” Geré zɨ́ye ndéréye. Sɨmɨ bɨ olụ́nɨ́ go sɨmɨ mụkụ́ṛụ́ e ní, zɨ́ mụkụ́ṛụ́ e ụ́dụyé rụ gɨ dogboṛụ landa ngásá útúye sɨmɨ mɨkavu do úyuyé mbá. ");
INSERT INTO bdh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ꞌYị ga bɨ ndịsịnɨ́ lúrú bi kacɨ́ mụkụ́ṛụ́ ga gére ní, sɨmɨ bɨ lurúnɨ́ ledre bɨ Yésụ mengị née kenée ní, zɨ́ye ngásáye úku ꞌdódo a zɨ́ ꞌyị e sɨmɨ gara. ");
INSERT INTO bdh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Zɨ́ ꞌyị e gɨ sɨmɨ gara gɨrí ógụyé úku ledre zɨ́ Yésụ idí ólụ́ógụ gɨ sɨmɨ gara eyé gɨ ona ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zɨ́ Yésụ ị́nyịné ékị́ne sɨmɨ kuṛúngba, ꞌdógụ bi ndéréne sɨmɨ gara bɨ ndịsị ndị́sị sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nda go ꞌbe íri, zɨ́ ngíti géyị ꞌyị e ị́mbị́ógụ ngíti owụ́phɨṛangá bɨ nɨ mɨgịgị́ṛị́ ní zɨ́a kɨ́ gbagbara. Zɨ́ Yésụ owo a kɨ́dí ꞌyị ga gére née owonɨ́ go ya née nɨ útúásá yómo wo. Zɨ́a úku ledre zɨ́a kɨ́dí, “Owụ́ ꞌbɨ amáa ídí ódó mɨmbéꞌdeyị́, máótoómo lúyú ledre eyị́ go.” ");
INSERT INTO bdh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Geré zɨ́ ngíti géyị ꞌyị ꞌdódo lorụ ị́nyịyé úku ledre dengbị́ye kɨ́dí, “Uku sinyi ledre go, otoasá roné go kɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tɨ́ lá zɨ́ Yésụ ówo sómụ́ ledre eyé née, zɨ́a úku ledre zɨ́ye kɨ́dí, “Éyị́ bɨ mɨmbéꞌdesé nɨ gɨ zɨ́a bɨsinyíne kenée ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wo be ꞌdi nɨ née mɨꞌdiyíne zɨ́ma úku a, ‘Máótoómo lúyú ledre eyị́ go,’ togụ́ mbú, ‘Ị́nyịógụ mu ꞌdága tónó gámáyị?’ ");
INSERT INTO bdh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tɨ́ lá gɨ ro zɨ́se ówo a kɨ́dí Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ kɨ́ rokoꞌbụ zɨ́ne gɨ ro ótoómo lúyú ledre ꞌbɨ ꞌyị e do sogo káṇgá ona,” zɨ́a úku ledre zɨ́ mɨgịgị́ṛị́ ba kɨ́dí, “Ị́nyịógụ mu ꞌdíꞌbi gbagbara eyị́ zɨ́yị ndáꞌbayị́ ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tɨ́ maꞌdíi zɨ́ oꞌdo née ị́nyịógụné ndáꞌbané ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị e lurúnɨ́ ledre née kenée ní, zɨ́ ngịrị méngị yée kɨ́ngaya, zɨ́ye ndị́sịyé mbófo Lomo bɨ iꞌbí rokoꞌbụ kenée zɨ́ ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Káa zɨ́ bɨ Yésụ nɨ go mɨndéréókpóne ní, zɨ́a ndíki ngíti oꞌdo kɨ́ ịrịné Matáyo sɨmɨ mákɨtabu nɨ ꞌyị ꞌdóꞌdụ́ ụsórụ, Yésụ ya zɨ́a ní, “Ídí lódụ́ kacɨ́ma,” Zɨ́ Matáyo útúne do kacɨ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sɨmɨ bɨ Yésụ nɨyí go zɨ́ Matáyo ꞌbe kɨ́ ꞌyị ené e do bi éyị́ mɨánu ní, zɨ́ tụ́ꞌdụ́ ꞌyị ꞌdóꞌdụ́ ụsórụ e kɨ́ ngíti géyị ꞌyị luyú e, ógụyé zɨ́ye ndị́sị ánu éyị́ kɨ́ Yésụ nda kɨ́ ꞌyị lódụ́ kacɨ́ga. ");
INSERT INTO bdh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Zɨ́ ngíti géyị Farụsáyo e ógụye úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ga gére née kɨ́dí, “Éyị́ bɨ mongụ́ ꞌyị esé ndịsịnɨ́ ánu éyị́ kɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ e kpá kɨ́ ꞌyị lúyú ledre e gɨ zɨ́a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sɨmɨ bɨ Yésụ uwú ledre ba ní, zɨ́a úku ledre zɨ́ Farụsáyo ga gére née kɨ́dí, “ꞌYị bɨ ndíyá ndaá roa wa ní gamásoꞌdo ené dokotóro wá, tɨ́ lá ꞌyị ndíyá e ndịsịnɨ́ gámásóꞌdo dokotóro ye. ");
INSERT INTO bdh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tɨ́ lá ndérésé mu zɨ́se gámásóꞌdo ini ledre gɨ sɨmɨ ledre bɨ Lomo uku kɨ́dí, ‘Máíli ídísé ídí ꞌyị ówo ledre kɨ́ ꞌyị e, ndaá ꞌbɨ ené ꞌdáná éyị́ esé e wá.’ Gɨ zɨ́a máógụ amá gɨ ro bɨlámá ꞌyị e wá, yị́ ené gɨ ro bɨsinyí ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nda sɨmɨ ngíti sị́lị́, zɨ́ ꞌyị ga bɨ ndịsịnɨ́ lódụ́ kacɨ́ Yiwáni Babatị́za ní ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, zée kɨ́ Farụsáyo e ndịsịzé órụ́ tarazé, tɨ́ lá ꞌyị lódụ́ kacɨ́yị orụ́nɨ́ ꞌbɨ eyé tarayé wá gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yésụ ya zɨ́ye ní, “ꞌYị ga bɨ nderénɨ́ ófụ́ kára, mɨkánda adrúgu nɨ dongaráye ní, lerị́ mengị yée wá. Lerị́ nɨ méngị yée sɨmɨ bɨ ꞌdiꞌbioyónɨ́ wo gɨ dongaráye go ní. ");
INSERT INTO bdh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ngíti a, ꞌyị utúasá ị́cị́ ꞌdụ́tụ uṇgú bɨ ro kuṛú bongó ní kɨ́ mɨkánda a wá. Mɨkánda bongó née nɨ ngụ́rógụ́ zɨ́a lálalófo kuṛú a née kɨ́ mongụ́ uṇgú. ");
INSERT INTO bdh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kpá kenée, ꞌyị e utúasánɨ́ lótó leꞌyị́ sɨmɨ kuṛú ndoko wá. Togụ́ lotónɨ́ yá, leꞌyị́ née nɨ ụ́ꞌbụ geré zɨ́ kuṛú ndoko née ndóko ené zɨ́ leꞌyị́ kúkúónzó roné bi. Idínɨ́ lótó leꞌyị́ sɨmɨ mɨkánda ndoko gɨ ro zɨ́ ndoko e kɨ́ leꞌyị́ ídíye mɨbándáye.” ");
INSERT INTO bdh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cịkị ore, zɨ́ ngúru mongụ́ ꞌyị ógụ útúne gbrị kóꞌdụ́ Yésụ úku ledre kɨ́dí, “Nyị́ma otoomo ꞌdówụ́ne go cakaba, ógụ aka óto sị́lị́yị doa gɨ ro zɨ́a ómoné.” ");
INSERT INTO bdh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zɨ́ Yésụ ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéréye zɨ́ oꞌdo née ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sɨmɨ mɨndéréye do mɨsiꞌdi, zɨ́ kára kɨ́ ndíyá ꞌbɨ kará e roné sɨmɨbi doa goó sokó doa gbre (12) ụkụ́ wá, ógụné gbóo sogo Yésụ do ꞌdíꞌbi tara bongó gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Zɨ́a úku ledre zɨ́ne kɨ́ roné kɨ́dí, “Togụ́ máꞌdíꞌbi lá tara bongó bɨ roa née yá, romá nɨ éme.” ");
INSERT INTO bdh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Geré zɨ́ Yésụ óyó roné lúrúndíki wo. Zɨ́a úku ledre kɨ́dí, “Nyị́ma, ídí ódó mɨmbéꞌdeyị́, ṇgúṇgu ledre eyị́ yómo yị́ị go.” Maꞌdíi, geré zɨ́ ro kára née émené. ");
INSERT INTO bdh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sɨmɨ bɨ Yésụ nɨyí ógụ kɨ́ ꞌyị ené e ꞌbe ꞌbɨ mongụ́ ꞌyị née íri ní, kụꞌdụ́ nɨ ndị́sị úku ledre, mbụ́dụ́ nɨ ówụ́, ");
INSERT INTO bdh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","zɨ́a úku ledre zɨ́ye kɨ́dí, “Ólụ́ógụsé aka sága, owụ́kára ba uyu ené wá ꞌduꞌdu yị́ ené lá mɨꞌdúꞌdu.” Zɨ́ ꞌyị e útúye mbá kúgú a. ");
INSERT INTO bdh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sɨmɨ bɨ ꞌyị e olụ́ogụnɨ́ gɨ ꞌdị́cị́ ini go mbá sága ní, zɨ́ Yésụ ólụ́ne ndéré ꞌdíꞌbi sị́lị́ umbu, geré zɨ́a úrúne, do ị́nyịógụné ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Zɨ́ phanda ledre née áṇgané sɨmɨ gara e za mbá. ");
INSERT INTO bdh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sɨmɨ mɨndéréókpó Yésụ gɨ ore, zɨ́ yaꞌdá e gbre komoyé ndaá lódụ́ wo kɨ́ ṇgúṇgú royé zɨ́a kɨ́dí, “Mongụ́ ꞌyị, Bulúndu ngére Dawídi, ídí ówo ledre zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sɨmɨ bɨ nɨ goó za ꞌdị́cị́ ní zɨ́ yaꞌdá ga bɨ komoyé ndaá ba ólụ́ lódụ́ kacɨ́ a gị ꞌdị́cị́, zɨ́a ndúꞌyú yée kɨ́dí, “Ṇgúṇgusé go kɨ́dí mááyí útúásá likpí komosé?” Zɨ́ye úkulúgu ledre kɨ́dí, “Ɨɨ, ṇguṇguzé go kenée Ngére.” ");
INSERT INTO bdh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Zɨ́ Yésụ óto sị́lị́ne ro komoyé zɨ́a úku ledre kɨ́dí, “Gɨ zɨ́ ṇgúṇgu ledre esé mááyí yómo sée,” ");
INSERT INTO bdh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","zɨ́ komoyé tɨ́ likpíne. Zɨ́ Yésụ lórụ yée oꞌbụóbụ kɨ́dí, “Ndásé úku ledre bɨ máméngị zɨ́se née zɨ́ ꞌyị e wá.” ");
INSERT INTO bdh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Abú kenée ndotó, tɨ́ lá bɨ olụ́ogụnɨ́ gɨ ore ní, zɨ́ye úku ledre née zɨ́ phanda a báyiné sɨmɨ gara e za mbá. ");
INSERT INTO bdh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kpá lá bɨ Yésụ kɨ́ ꞌyị ené e nɨyí aka gɨ ro ólụ́ógụ ní, zɨ́ ngíti géyị yaꞌdá e ị́mbị́ógụ ngíti oꞌdo kɨ́ dokéké sɨmɨné odro gɨ zɨ́a wá zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nda sɨmɨ bɨ Yésụ ógóóyó dokéké née ní, oꞌdo bɨ kóo odro wá ní, zɨ́a geré tónó ódroné. Zɨ́ ledre née lụ́tụ́ne komo ꞌyị ga bɨ ore née zɨ́ye úku ledre kɨ́dí, “Ledre mengị aka roné zɨ́ze Isɨréle e ona kenée wá.” ");
INSERT INTO bdh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tɨ́ lá Farụsáyo e ya, “Satána iꞌbí rokoꞌbụ née zɨ́a ndị́sị ogóóyó dokéké e kɨ́e gɨ sɨmɨ ꞌyị e ne.” ");
INSERT INTO bdh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zɨ́ Yésụ gámáne sɨmɨ gara kɨ́ ị́rịgbére ga bɨ ore ní, kɨ́ ndị́sị ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e sɨmɨ ꞌDị́cị́ Kótrụro e eyé e, kɨ́ ndị́sị úku bɨlámá ledre gɨ ro ꞌbe ꞌbɨ Lomo zɨ́ ꞌyị e nda kpá kɨ́ sị́kpị ꞌyị e gɨ do ṛị́kị́ ndíyá eyé e. ");
INSERT INTO bdh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sɨmɨ bɨ lurú tụ́ꞌdụ́ ꞌyị e ꞌdii ní, zɨ́ lerị́ye méngị wo gɨ zɨ́a ꞌyị ga gére née ngíti géyị ꞌyị e ndịsịnɨ́ méngị láráye ꞌyị sáká yée ndaá, káa zɨ́ kábịṛị́kị bɨ ngárá mị́ngị́ye ndaá ní. ");
INSERT INTO bdh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Tụ́ꞌdụ́ ꞌyị e nɨyí go nzíyiyé gɨ ro úwú ledre ꞌbɨ Lomo, tɨ́ lá sée ꞌyị ꞌdódo ledre maáge, éyesé wá. ");
INSERT INTO bdh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bɨ kenée ní, ídísé íni ini zɨ́ Ngére bɨ nɨ mị́ngị́ moko maꞌdáa ní, zɨ́a kásaógụ yata ꞌyị ꞌbɨ moko zɨ́se gɨ ro zɨ́se ndị́sị ꞌdódo bɨlámá ledre kéye zɨ́ ꞌyị e mbá.” ");
INSERT INTO bdh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zɨ́ Yésụ ndólo ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre (12) ní, íꞌbí rokoꞌbụ ꞌbɨ ógóóyó bɨcayi lomo e kpá kɨ́ sị́kpị ꞌyị ndíyá e kɨ́e zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ba ịrị ꞌyịmɨkása ga bɨ sokó doa gbre (12) ní. Simúna bɨ ngíti ịrịa kpá Pétero ní, kɨ́ lúnduné Andiríya, Yakóbo wotị́ Zebedị́ya, kɨ́ lúnduné Yiwáni, ");
INSERT INTO bdh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nda Phị́lịpo, kɨ́ Batilimáyo, Tóma kɨ́ Matáyo ꞌyị ꞌdóꞌdụ́ ụsórụ, Yakóbo wotị́ Alafáyo, nda Tadéyo, ");
INSERT INTO bdh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kɨ́ Simúna Zíloto, kɨ́ Yụ́da bɨ gɨ sɨmɨ gara bɨ Keriyóta bɨ iꞌbí ngbángá Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sɨmɨ bɨ Yésụ kasa ꞌyịmɨkása ené ga bɨ sokó doa gbre (12) ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndásé ndéré ꞌbe ꞌbɨ ꞌyị ga bɨ ndanɨ́ Yụ́da e wá ní wá, togụ́ sɨmɨ káṇgá ꞌbɨ ꞌyị ga bɨ Samáriya e ní kpá wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ídísé ndéré ꞌbe ꞌbɨ Isɨréle e gɨ zɨ́a oyónɨ́ sogoyé go zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Zɨ́se úku ledre zɨ́ye kɨ́dí, ‘Sịndị́ kadra nɨ go gbóo gɨ ro zɨ́ Lomo ídíne Ngére doyé.’ ");
INSERT INTO bdh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zɨ́se sị́kpị ꞌyị ndíyá e kpá kɨ́ úru ꞌyị e gɨ sɨmɨ umbu. ꞌYị ga bɨ kɨ́ sámá royé ní, zɨ́se yéme sanáye, zɨ́se ógóóyó dokéké e gɨ sɨmɨ ꞌyị e. ꞌYị e ndanɨ́ íꞌbí éyị́ zɨ́se gɨ ro moko máa née wá gɨ zɨ́a máíꞌbí rokoꞌbụ née zɨ́se gbékpị́ne. ");
INSERT INTO bdh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sɨmɨ mɨndérése, ndásé ꞌdíꞌbi késị́ wá, ");
INSERT INTO bdh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ndásé gbawá ꞌdíꞌbi yata bongó e kɨ́ éyị́ sịndị́ e zɨ́se sɨmɨ kombo, ndásé kpá gbawá ꞌdíꞌbi ngbángbá. ꞌYị ga bɨ ásé ndéré méngị moko zɨ́ye née nɨyí lúrú bi kacɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Gara togụ́ do ꞌbe bɨ ógụsé go sɨmɨ a ní, zɨ́ ngúru mị́ngị́ ꞌbe ꞌdíꞌbi sée sɨmɨ sụmụ yá, ídíse ꞌdúꞌdu ore, ásé nda fú ndéréókpó. ");
INSERT INTO bdh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ꞌBe bɨ ógụsé go sɨmɨ a ní, ídísé íꞌbí mandá ore. ");
INSERT INTO bdh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Togụ́ ꞌdiꞌbinɨ́ sée go sɨmɨ sụmụ, ídísé íni ini zɨ́ Lomo idí íꞌbí úndru zɨ́ye ore. Togụ́ ꞌdiꞌbinɨ́ sée wá, úndru esé née idí ídíáká zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ꞌYị ga bɨ ꞌdiꞌbinɨ́ sée sɨmɨ sụmụ gɨ ro úwú ledre ga bɨ ógụsé kɨ́e zɨ́ye ní wá ní, ídísé ụ́ꞌbụ́ómo ꞌbụrụ bɨ ro sịndị́se ní cịkị ore gɨ ro do ówo a mbá kɨ́dí asinɨ́ goó gɨ rosé. ");
INSERT INTO bdh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Zɨ́a kpá úku ngíti ledre zɨ́ye kɨ́dí, Máúku zɨ́se maꞌdíi, ꞌdoꞌdó ꞌbɨ ꞌyị ga bɨ kóo Lomo ꞌdoꞌdo yée sɨmɨ Sodóma kɨ́ Gomóra ní emene gɨ zɨ́ ꞌdoꞌdó bɨ nɨ ꞌdóꞌdo ꞌyị ga bɨ asinɨ́ kɨ́ úwú ledre gɨ tarasé ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ásé ídí dongará bɨsinyí ꞌyị e íri káa zɨ́ kábịṛị́kị ga bɨ dongará máárára e mị́ngị́ye ndaá ní. Gɨ zɨ́ kéyị née ní, komosé idí ídí rosé, zɨ́ mɨmbéꞌdesé ídíne zɨ́ ꞌyị e mbá bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ídísé kpá bándá rosé gɨ zɨ́ ngíti géyị Yụ́da e, nɨyí ꞌdíꞌbiógụ sée kóꞌdụ́ mɨngburoko ꞌyị eyé e sɨmɨ ꞌDị́cị́ Kótrụro e, zɨ́ye ꞌdóꞌdo sée. ");
INSERT INTO bdh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ásé ídí zɨ́ye káa zɨ́ bɨsinyí ꞌyị e ní, zɨ́ye ꞌdíꞌbiógụ sée kóꞌdụ́ mɨngburoko ꞌyị e kpá kɨ́ mɨngburoko ngére e gɨ ro zɨ́ye ꞌdécị ngbanga rosé. Ábuwá ásé go ndéré ꞌdódo ledre amá zɨ́ye kpá kɨ́ ꞌyị ga bɨ ngárá ndanɨ́ Yụ́da e wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Togụ́ ꞌdiꞌbinɨ́ sée go yá, ndásé sómụ́ ledre kɨ́dí, ásé ndéré úku a ba ya ꞌdíya wá. ꞌDówụ́ Lomo nɨ úkuíꞌbí ledre ne zɨ́se úku a. ");
INSERT INTO bdh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ásé ndị́sị úku dụụ́ éyị́ bɨ ꞌBụsé Lomo nɨ ndị́sị úkuíꞌbí a zɨ́se sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ne ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Karanée ngíti géyị ꞌyị e nɨyí íꞌbí ngbángá lúnduyé e kɨ́ lémịyé do úfu yée, zɨ́ ngíti géyị ꞌbụmɨowụ́ e méngị a zɨ́ owụ́ ꞌbɨ eyé e kpá kenée, zɨ́ owụ́ e ídíye okó ro ꞌyị ndíki yée do úfu ꞌyị ndíki yée gɨ zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tụ́ꞌdụ́ ꞌyị e nɨyí karanée sógó sée gɨ zɨ́a bɨ ṇgúṇgusé ledre amá ní. Yée bɨ ṇguṇgunɨ́ ledremá zɨ́ye tóroyé ngbúó sɨmɨ ꞌdoꞌdó ní, Lomo nɨ karanée íꞌbí trịdrị zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Togụ́ ꞌdoꞌdonɨ́ sée sɨmɨ gara bɨ ásé sɨmɨ a gɨ zɨ́a bɨ ndị́sịsé ꞌdódo ledre amá ore ní, ídísé ngásá sɨmɨ ngíti a. Mááyí ndáꞌbaógụ ꞌdiya ꞌdáꞌdá gɨ zɨ́se kɨ́ gámá lící rosé kenée sɨmɨ káṇgá ꞌbɨ Isɨréle e mbá kɨ́ úku ledre amá zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ꞌYị bɨ ndịsịnɨ́ ꞌdódo ledre zɨ́a ní, romo ené do ꞌyị ꞌdódo ledre wá. Kpá kenée ꞌyị ꞌbɨ moko romo ené do mongụ́ ꞌyị ené wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Káa zɨ́ bɨ mááyí ꞌyị ꞌdódo ledre zɨ́se kpá manda esé ní, ídísé ówo a kɨ́dí nɨyí ndólo sée Belezabụ́bụ káa zɨ́ bɨ ndịsịnɨ́ ndólo máa ní gɨ zɨ́a mááyí mongụ́ ꞌyị esé. ");
INSERT INTO bdh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ndásé éré ꞌyị ga bɨ nɨyí ndị́sị méngị láráse gɨ zɨ́a bɨ ṇgúṇgusé ledre amá ní wá. Lomo ili ídísé ꞌdódo ledre ené e za mbá zɨ́ ꞌyị e bɨkéṛị́ a ndaá lóꞌbo wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ledre ga bɨ mɨꞌdódo yée zɨ́se kɨ́ ndụlụ kɨ́ kadra ní ídísé ózoógụ yée zɨ́ kadra zɨ́ tụ́ꞌdụ́ ꞌyị e úwú yée mbá. ");
INSERT INTO bdh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ndásé éré ꞌyị ga bɨ nɨyí úfu lá dụụ́ gbékpị́ rosé, utúasánɨ́ óto sị́lị́ye ro trịdrịsé wá ní wá. Ídísé éré ngịrị Wo bɨ nɨ ụ́cụ kụṛụꞌbụsé nyé ku phoꞌdụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mɨnzéré owụ́ solụ́ e, ledreyé ndaá owóowó wá, ꞌyị nɨ úgú yée ꞌdényé gbre dụụ́ kɨ́ giníya kị́éꞌdo. Lomo bɨ otoogụ yée ní, ili ené zɨ́ye úyuyé lá sɨkala wá gɨ zɨ́a owo yị́ ené yée mbá bú. ");
INSERT INTO bdh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lomo owo ledre gɨ rosé bú bɨlámáne, gba bị dosé olo yée kékị́éꞌdo mbá. ");
INSERT INTO bdh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndásé éré ngịrị ꞌyị ga bɨ ilinɨ́ dụụ́ úfu gbékpị́ rosé ní wá, ledresé nɨ zɨ́ Lomo owóowó rómo do gbékpị́ éyị́ trịdrị e mbá. ");
INSERT INTO bdh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ꞌYị ga bɨ erénɨ́ ngịrị wá, togụ́ toronɨ́ ngị́rị úku ledre fúó zɨ́ ꞌyị e kɨ́dí yée nɨyí ꞌyị amá e yá, mááyí úku ledreyé zɨ́ Babá komo ere kpá fúó kɨ́dí, maꞌdíi nɨyí tɨ́ ꞌyị amá e. ");
INSERT INTO bdh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Togụ́ asinɨ́ gɨ romá gɨ zɨ́ komo ꞌyị e yá, mááyí kpá ási gɨ royé kóꞌdụ́ Babá bɨ komo ere ní kɨ́dí ndanɨ́ eyé ꞌyị amá e wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ndásé sómụ́ a bɨ kɨ́dí bɨ máógụ ba ledre e nɨyí ídí mbá bɨlámáye ní wá. ꞌYị ga bɨ ṇguṇgunɨ́ ledremá wá ní, mɨmbéꞌdeyé nɨ ndị́sị ídí phoꞌdụ zɨ́ye ndị́sịyé kɨ́ úfu ngíti géyị ꞌyị ga bɨ ṇguṇgunɨ́ ledre amá go ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngíti géyị “ ‘owụ́ yaꞌdá e nɨyí zíngi ro ꞌbụyé e kɨ́dí ꞌbụyé ṇguṇgunɨ́ ledremá gɨ ro ꞌdíya. Zɨ́ owụ́kará e méngị a zɨ́ mbágáye kpá kenée gɨ zɨ́a bɨ mbágáye ṇguṇgunɨ́ ledremá ní. Kará ꞌbe e nɨyí méngị a kpá kenée zɨ́ tetéye e. ");
INSERT INTO bdh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ledre née ꞌdodo go kɨ́dí, okó nɨ ógụ ro ꞌyị bɨ ṇguṇgu ledre amá go ní cịkị gɨ zɨ́ ꞌyị ené e gɨ ꞌbe.’ ");
INSERT INTO bdh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Togụ́ ꞌyị oto ꞌbú ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e rómo domá yá, ꞌyị née utúasá ené ídí ꞌyị lódụ́ kacɨ́ma wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ꞌYị bɨ utúasá ị́mbị́ mɨngbúngbu kágá ené íꞌbí roné kɨ́e zɨ́ ꞌdoꞌdó kɨ́ umbu gɨ romá wá ní, utúasá ídí káa do ꞌyị lódụ́ kacɨ́ma wá. ");
INSERT INTO bdh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Togụ́ ꞌyị ya née ṇguṇgu ledremá wá káa bɨ ezeokóma e nɨyí úfu née yá, sɨmɨ bɨ ufunɨ́ wo go ní, ndiki trịdrị bɨ za fí ní wá. Togụ́ ezeokóma e ufunɨ́ ꞌyị gɨ zɨ́a bɨ ṇguṇgu ledremá ní yá, nɨ ndiki trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Togụ́ ꞌyị ꞌdiꞌbi sée sɨmɨ sụmụ gɨ zɨ́a bɨ ásé ꞌyị amá e ní, ꞌyị née ꞌdiꞌbi kpá máa go. ꞌYị bɨ ꞌdiꞌbi máa go sɨmɨ sụmụ ní, ꞌdiꞌbi kpá babá go gɨ zɨ́a kasaogụ máa ne. ");
INSERT INTO bdh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Togụ́ ꞌyị ꞌdiꞌbi nébị sɨmɨ sụmụ gɨ zɨ́a bɨ Lomo kasaogụ wo ne ní yá, Lomo nɨ íꞌbí tákpásị́lị́ zɨ́ye ndro kɨ́ nébị maꞌdáa. Togụ́ ꞌyị ꞌdiꞌbi ꞌyị méngị ledre ga bɨ Lomo ili yée ní sɨmɨ sụmụ, Lomo nɨ íꞌbí tákpásị́lị́ zɨ́ye ndro kɨ́ ꞌyị máa née. ");
INSERT INTO bdh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndaá kpá lá dụụ́ née wá, togụ́ ꞌyị iꞌbí iní zɨ́se éwé a gɨ zɨ́a bɨ ásé ꞌyị lódụ́ kacɨ́ma e ní yá, Lomo nɨ íꞌbí úndru zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sɨmɨ bɨ Yésụ ukuonzó ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre née kenée ní, zɨ́a ị́nyịné ndéréne kɨ́ ꞌdódo ledre kpá kɨ́ úku ledre ꞌbɨ Lomo sɨmɨ gara ga bɨ ꞌbɨ Galiláya ore ní. ");
INSERT INTO bdh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yiwáni ꞌyị Bábátị́zị́ ꞌyị e nɨ sɨmɨ sị́gịnị. Zɨ́ phanda Kɨ́résịto ówụ́ ndíki wo ꞌdị́cị́ íri. Zɨ́a kása ꞌyị lódụ́ kacɨ́ne e zɨ́ Yésụ ndúꞌyú wo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Áyí ba Kɨ́résịto bɨ nébị e ukunɨ́ ledrea kɨ́dí nɨ ógụ ní, ala áyí ngíti ꞌyị kpị́?” ");
INSERT INTO bdh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zɨ́ Yésụ kásalúgu yée kɨ́dí, “Ledre ga bɨ mándị́sị ꞌdódo yée, zɨ́se úwú a go kɨ́ mbílíse kɨ́ yée ga bɨ lúrúsé máa kɨ́ méngị yée ní, ídísé ndéré úku yée zɨ́ Yiwáni kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ꞌyị ga bɨ lurú bi wá ní málíkpí komoyé go, mɨgịgị́ṛị́ e máyéme sịndị́ye go, ꞌyị ga bɨ kɨ́ sámá royé ní máyéme yée go, mɨmbílí ngbụtụ́ e málíkpí mbílíye go, umbu e nɨyí go kɨ́ úrú, mááyí go kpá ndị́sị úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị lerị́ e. ");
INSERT INTO bdh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ídísé kpá úku a zɨ́a kɨ́dí, Lomo nɨ íꞌbí úndru zɨ́ ꞌyị ga bɨ asinɨ́ gɨ romá wá gɨ zɨ́ ledre ga bɨ mándị́sị méngị yée ní.” ");
INSERT INTO bdh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yiwáni nɨyí go ndáꞌba ní, zɨ́ Yésụ óyólúgu komoné tónóne úku ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga ba ní gɨ ro Yiwáni kɨ́dí, “Oꞌdo bɨ kóo ndị́sịsé ndéré lúrú wo sɨmɨ súwú ꞌdáa ní náambi? Ówosé kóo wo lá káa zɨ́ lómí bɨ síli ndịsị ílí a káa zɨ́ cící éyị́ ní? ");
INSERT INTO bdh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Togụ́ kenée wá ní, ílisé kóo zɨ́a ídíne íri kɨ́ mongụ́ bɨlámá bongó roné? ꞌYị ga bɨ kɨ́ bongó e royé kenée ní ndịsịnɨ́ ndị́sị dụụ́ ye do mɨngburoko bi ga bɨ ꞌbɨ ngére e ní. ");
INSERT INTO bdh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sara togụ́ kenée ní, éyị́ bɨ kóo ndérésé lúrú a ní ꞌdi? Ndérésé lúrú nébị? ꞌBe tɨ́ kenée ní, máúku zɨ́se oꞌdo née romo do nébị. ");
INSERT INTO bdh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Née oꞌdo bɨ kóo Lomo uku ledre a do éké ledre gɨ roa kɨ́dí, “ ‘Mááyí kása ꞌyị kasa amá zɨ́yị ꞌdáꞌdá, gɨ ro zɨ́a yémeómo mɨsiꞌdi zɨ́yị nzíyiné.’ ");
INSERT INTO bdh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Máúku zɨ́se maꞌdíi, gɨ dongará ꞌyị ga bɨ kará e ndikinɨ́ yée ní ꞌyị rómo do Yiwáni Babatị́za ndaá. Tɨ́ lá ꞌyị máa wo bɨ nɨ odụ ꞌyị ꞌbe ꞌbɨ Lomo komo ere ní, romo do Yiwáni dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tónóne gɨ sɨmɨ sịndị́ kadra bɨ kóo Yiwáni Babatị́za ndị́sị úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e, ndéréógụné gị karaba ní, ledre ꞌbɨ Lomo bɨ komo ere ní nɨ kóo go mɨndéréne ꞌdáꞌdá, tɨ́ lá ꞌyị ga bɨ otonɨ́ royé okó ro ledre ꞌbɨ Lomo ní ndịsịnɨ́ gámásóꞌdo mɨsiꞌdi gɨ ro ụ́cụómo a kɨ́ cóngó ro. ");
INSERT INTO bdh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ledre ga bɨ mbá nébị e ekénɨ́ yée nda kpá kɨ́ lorụ ꞌbɨ Mụ́sa, ndéréógụné gị sɨmɨ sịndị́ kadra ꞌbɨ Yiwáni, nɨyí gɨ ro ledre ꞌbe ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Togụ́ ṇgúṇgusé go kenée, Yiwáni babatị́za nɨ nébị káa zɨ́ Ilíya nébị bɨ kóo Lomo ukuꞌdodo ledre mɨógụ ené ní. ");
INSERT INTO bdh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ꞌYị bɨ kɨ́ mbílí ro doné, idí índi mbílíne úwúyéme ledre ba bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mááyí ótoásá ꞌyị ga bɨ cakaba ba kɨ́ ꞌdi? Nɨyí yị́ eyé káa zɨ́ owụ́ ga bɨ nɨyí do bi ndeke ní. Zɨ́ ngíti géyị ndị́sịyé ndólo lafúye, ");
INSERT INTO bdh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","úku ledre zɨ́ye kɨ́dí, ‘Ndịsịzé úku keꞌbị kɨ́ ụ́cụ kị́drị́, ógụsé léꞌbé keꞌbị zɨ́ze wá, ukuzé keꞌbị ini, sɨmɨkozo ꞌdiꞌbi sée kpá wá. ");
INSERT INTO bdh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sɨmɨ bɨ Yiwáni ogụ ní, anu bɨlámá éyị́ wá, ewé leꞌyị́ kóṛó kpá wá ní, úkusé yị́ esé kɨ́dí nɨ kɨ́ dokéké sɨmɨné.’ ");
INSERT INTO bdh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Zɨ́ Owụ́ ꞌbɨ ꞌYịmaꞌdí ógụné ndị́sị kɨ́ ánu éyị́ kpá kɨ́ éwé éyị́ e kɨ́ ꞌyị e ní, úkusé yị́ esé kɨ́dí, ‘Lúrúsé aka oꞌdo ba. Nɨ ꞌyị mɨmbéꞌde, ꞌyị kóyó kpá ezegámá ꞌyị ꞌdóꞌdụ́ ụsórụ e kɨ́ ꞌyị lúyú ledre e.’ Tɨ́ lá komokenzị ndịsị ꞌdódo roné maꞌdíi kacɨ́ mɨméngị ledre.” ");
INSERT INTO bdh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zɨ́ Yésụ tónóne úku ledre zɨ́ ꞌyị e sɨmɨ gara ga bɨ kóo mengị tụ́ꞌdụ́ mɨngburoko ledre e ga bɨ kɨ́ rokoꞌbụyé sɨmɨyé ní, gɨ zɨ́a oyóloꞌbónɨ́ eyé mɨmbéꞌdeyé zɨ́ye ṇgúṇgu ledre ꞌbɨ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Áko, sée ꞌyị ꞌbɨ gara ga bɨ Korazíni kɨ́ Beteseyị́da ní, Lomo nɨ karanée ꞌdóꞌdo sée bɨsinyíne. Togụ́ mɨngburoko ledre ga bɨ mengịnɨ́ royé káa do ꞌdódo ledre zɨ́se ní, idí mengịnɨ́ kóo royé née sɨmɨ gara ga bɨ Táyire kɨ́ Sidóna ní, káa bɨ ꞌyị ga bɨ íri née oyóloꞌbónɨ́ kóo mɨmbéꞌdeyé go ꞌdesị́ zɨ́ye ṇguṇgu ledre ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Máúku zɨ́se, abú ꞌyị ga bɨ ꞌbɨ Táyire kɨ́ Sidóna Lomo nɨ karanée ꞌdóꞌdo yée yá, nɨ ídí kɨ́ ngítíne. ");
INSERT INTO bdh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sée ꞌyị ꞌbɨ gara bɨ Kapáranawúma ní, sómụ́sé kɨ́dí Lomo nɨ ꞌdíꞌbi sée ꞌbe ꞌbɨ ené komo ere? Ɨ́ꞌɨ, ꞌdiꞌbi ené sée íri wá. Nɨ ụ́cụ sée ku phoꞌdụ bɨ za fí ní. Togụ́ mɨngburoko ledre ga bɨ máméngị yée sɨmɨ gara esé ona ní, idí mengịnɨ́ kóo royé née sɨmɨ gara Sodóma, káa bɨ idíaká ba go gị karaba. ");
INSERT INTO bdh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Karanée kadra ngbanga, Lomo nɨ ꞌdóꞌdo sée rómo do ꞌbɨ Sodóma.” ");
INSERT INTO bdh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Zɨ́ Yésụ ị́nyịné mbófo Lomo kɨ́dí, “Babá, áyí Ngére do éyị́ e za mbá, kpá do Ere kɨ́ Káṇgá. Mámbófo yị́ị gɨ zɨ́a ótoécị maꞌdíi ledre eyị́ ba gɨ zɨ́ ꞌyị ga bɨ ya yée nɨyí ꞌyị ówo ledre e ní, zɨ́yị nda ꞌdódo a zɨ́ yée ga bɨ kɨ́ owụ́ ówo ledre ní. ");
INSERT INTO bdh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Babá, née ledre bɨ utúasá kacɨ́ komoyị́ ní, gɨ ro zɨ́a ídíne kenée.” ");
INSERT INTO bdh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zɨ́a kpá úku ngíti ledre kɨ́dí, “Babá, iꞌbí rokoꞌbụ ledre e go za mbá zɨ́ma. ꞌYị bɨ owoyeme ledre gɨ romá ní ndaá dụụ́ Babá, ꞌyị ówoyéme ledre gɨ ro Babá ndaá dụụ́ máa kɨ́ ꞌyị ga bɨ mágélé yée go gɨ ro ꞌdódo Babá zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sée ga bɨ za mbá ndị́sịsé ꞌdóꞌdó gɨ zɨ́ lorụ bɨ mɨngburoko ꞌyị esé e ịmbị́otonɨ́ dosé ní, ídísé ógụ zɨ́ma, mááyí sáká sée gɨ ro zɨ́se ꞌdówụ́rosé. ");
INSERT INTO bdh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ídísé íꞌbí mɨmbéꞌdesé zɨ́ma, zɨ́se ndị́sịsé lódụ́ dụụ́ kacɨ́ lorụ amá, gɨ zɨ́a mɨmbéꞌdemá nɨ bɨlámáne ro ꞌyị e gɨ zɨ́a bɨ mándị́sị ówo ꞌdoꞌdó eyé ní. Togụ́ ílisé ledre amá go yá, mááyí ị́drị mɨmbéꞌdesé zɨ́a ị́drị́ne nzoó zɨ́se ꞌdówụ́rosé. ");
INSERT INTO bdh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gɨ zɨ́a lorụ bɨ mááyí íꞌbí a zɨ́se ní ndaá ꞌbɨ ené owóowó wá, nɨ yị́ ené fáfáka utúasá íꞌbí kụ́rụ́ rosé wá.” ");
INSERT INTO bdh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ ꞌdécị bi kpụrụ́ gɨ sɨmɨ ngíti yáká kére. Zɨ́ ꞌyị lódụ́ kacɨ́ga ndị́sịyé lófo ngorụ kére kɨ́ ánu a gɨ zɨ́ ꞌbú. ");
INSERT INTO bdh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Zɨ́ ngíti géyị Farụsáyo e ị́nyịyé úku ledre zɨ́ Yésụ kɨ́dí, “Lúrú aka ꞌyị lódụ́ kacɨ́yị ga ba nɨyí go méngị moko sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro.” ");
INSERT INTO bdh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yésụ ya zɨ́ye ní, “Ówosé éyị́ bɨ kóo Dawídi kɨ́ ꞌyị ené e mengịnɨ́ sɨmɨ bɨ kóo ꞌbú mengị yée ní bú? ");
INSERT INTO bdh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Olụ́nɨ́ kɨ́ ꞌyị ené e ꞌDị́cị́ ꞌbɨ Lomo, éyị́ ga bɨ ꞌdanánɨ́ Lomo kɨ́e, ꞌyị ꞌdáná éyị́ e nɨyí ánu a lá dụụ́ ye ní, zɨ́ye ꞌdíꞌbi a ánu a. ");
INSERT INTO bdh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ólosé esé ledre bɨ Mụ́sa eké sɨmɨ lorụ kɨ́dí ꞌyị ꞌdáná éyị́ bɨ sị́lị́ ené ꞌbɨ moko sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo utú go ndro sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro ní, idí méngị a ndaá zɨ́a lúyú ledre wá ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Máúku zɨ́se maꞌdíi, wo bɨ kɨ́ rokoꞌbụné rómo do rokoꞌbụ ꞌbɨ ꞌDị́cị́ ꞌbɨ Lomo ní nɨ ona. ");
INSERT INTO bdh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Idí ówosé ini ledre bɨ sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘Máíli ídísé ídí ꞌyị ówo ledre kɨ́ ꞌyị e, ndaá ꞌbɨ ené ꞌdáná éyị́ esé e wá ní bo,’ káa bɨ úku sínyisé esé ledre ro ꞌyị e amá e wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bɨ kenée ní Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ngére do Sị́lị́ ꞌbɨ ꞌDówụ́ro.” ");
INSERT INTO bdh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zɨ́ Yésụ ókpóne gɨ ore ꞌdáꞌdá, zɨ́a ndéré ólụ́ne sɨmɨ ngíti ꞌDị́cị́ Kótrụro ꞌbɨ Yụ́da e, ");
INSERT INTO bdh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ngíti oꞌdo nɨ ore cídrí sị́lị́a gagá mɨgágá nzɨ sị́lị́ga mengịnɨ́ lolụ moko wá. Zɨ́ Farụsáyo e gámásóꞌdo mɨsiꞌdi gɨ ro ꞌdíꞌbi Yésụ. Zɨ́ye ndúꞌyú wo kɨ́ mani kɨ́dí, “Togụ́ ꞌyị nɨ kɨ́ ndíyá ní, nɨ mɨútúásáne do sị́kpị wo sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro?” ");
INSERT INTO bdh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “ꞌYị nɨ bo dongaráse ore togụ́ Kábịṛị́kị ené utú sɨmɨ gu sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro ní utúasá lálaógụ a wá? ");
INSERT INTO bdh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ꞌYịmaꞌdí nɨ kɨ́ ledrené owóowó rómo do Kábịṛị́kị. Gɨ zɨ́ kéyị née, nɨ mɨútúásáne do ndị́sị méngị dụụ́ bɨlámá ledre sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro.” ");
INSERT INTO bdh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zɨ́a ị́nyịné úku ledre zɨ́ oꞌdo bɨ sị́lị́a mengị moko wá née kɨ́dí, “ꞌDózo aka sị́lị́ née mu.” Sɨmɨ bɨ ꞌdózo ní, geré zɨ́ sị́lị́a ídíne bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Zɨ́ ledre née sínyíne ro Farụsáyo e. Zɨ́ye ólụ́ógụyé ndéré ndómo tarayé gɨ ro úfu Yésụ ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Zɨ́ Yésụ ndéré óyó yị́ ené roné gɨ ore. Zɨ́ tụ́ꞌdụ́ ꞌyị e kpá útúye rụrụ do kacɨ́ a, zɨ́a ꞌdíꞌbióyó ndíyá gɨ royé mbá. ");
INSERT INTO bdh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Zɨ́a lórụ ꞌyị ga bɨ ꞌdiꞌbioyó ndíyá gɨ royé ní, ndanɨ́ úku ledrené zɨ́ ꞌyị e faa wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ledre bɨ Yésụ mengị née ꞌdodo go ledre bɨ kóo nébị Isáya eké ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ba wo bɨ mágélé káa do ꞌyị kasa amá ní, ꞌbúa ofụ domá go, mááyí kɨ́ mongụ́ rokinyi gɨ roa. Mááyí íꞌbí ꞌdówụ́ma zɨ́a, zɨ́a ndị́sịné úku ledre zɨ́ kúfú ꞌyị e mbá kɨ́dí, Lomo nɨ karanée ꞌdécị ngbanga zɨ́ye bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ꞌYị kása amá máa née ndaá ꞌbɨ ené ꞌyị ófụ́ kɨ́ gbúrógbó do ꞌyị e wá. Nderé ené kpá kɨ́ ꞌdódo ledre zɨ́ ꞌyị e kacɨ́ mɨsiꞌdi e kɨ́ doné wóꞌdụ́ wóꞌdụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nɨ íꞌbí rokoꞌbụ zɨ́ ꞌyị máa yée ga bɨ ṇguṇgunɨ́ ledre Lomo go ní. ꞌYị máa yée ga bɨ ṇguṇgunɨ́ aka wá ní, asi ené gɨ royé wá. Nɨ ndị́sị tóro gɨ ro ꞌyị ené e fú kenée tɨ́ bɨ zɨ́a rómo komo Satána ní. ");
INSERT INTO bdh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɨ ne ꞌyị bɨ ꞌyị e do sogo káṇgá mbá nɨyí óto mɨmbéꞌdeyé roa ní.” ");
INSERT INTO bdh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kadra kị́éꞌdo do kókóógụ ngíti oꞌdo nɨ kɨ́ dokéké sɨmɨné, lurú bi gɨ zɨ́a wá, odro kpá wá. Zɨ́ Yésụ lágaóyó dokéké née gɨ sɨmɨ a, geré zɨ́ komoa líkpíne, zɨ́a kpá tónóne ódroné. ");
INSERT INTO bdh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zɨ́ tara ꞌyị e ị́drị́ne mbá mɨị́drị́, zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Ba ndaá Bulúndu ngére Dawídi wá?” ");
INSERT INTO bdh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sɨmɨ bɨ Farụsáyo e uwúnɨ́ ledre née kenée ní, zɨ́ye úku ledre kɨ́dí, “Yésụ ndịsị lágaóyó dokéké gɨ zɨ́a manda eyé Belezabụ́bụ iꞌbí rokoꞌbụ née zɨ́a ne.” ");
INSERT INTO bdh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Togụ́ ꞌyị ꞌbɨ káṇgá kị́éꞌdo, togụ́ mbú gara kị́éꞌdo togụ́ mbú ꞌbe ndịsịnɨ́ méngị okó dengbị́ye yá, ꞌbe ꞌbɨ eyé née nɨ báyi ené. ");
INSERT INTO bdh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kpá kenée togụ́ Satána ndịsịnɨ́ méngị okó dengbị́ye yá, toro yemenɨ́ royé wá, nɨyí báyi eyé mɨbáya. ");
INSERT INTO bdh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Togụ́ málágaóyó dokéké e kɨ́ rokoꞌbụ bɨ gɨ zɨ́ Belezabụ́bụ ní, sara ꞌyị esé e ndịsịnɨ́ ꞌbɨ eyé lágaóyó yée kɨ́ rokoꞌbụ gɨ zɨ́ ambi? ꞌYị esé maáge nɨyí úku yéme a ye sómụ́ ledre esé ndaá mbị́ wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Togụ́ lágaóyó dokéké kɨ́ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo, ꞌdodo go kɨ́dí Lomo ogụ go káa do Ngére dosé.” ");
INSERT INTO bdh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Zɨ́ Yésụ kpá úku muruwayi kɨ́dí, “ꞌYị ugu utúasá ngáka éyị́ gɨ zɨ́ ꞌyị bɨ kɨ́ rokoꞌbụné ní wá, ꞌbúó togụ́ rokoꞌbụa romo do ꞌbɨ mị́ngị́ éyị́ née go. ");
INSERT INTO bdh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ꞌYị bɨ ṇguṇgu ya málágaóyó bɨcayi lomo e kɨ́ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo wá ní, nɨ okó romá. ꞌYị ga bɨ ilinɨ́ ndị́sị báyi ꞌyị e káa bɨ nɨyí ṇgúṇgu ledre amá ní, nɨyí okó romá. ");
INSERT INTO bdh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lomo nɨ ótoómo ledre zɨ́ ꞌyị abú luyú ba kóo za lúyú ledre bɨ káa be ꞌdíya. Éyị́ kị́éꞌdo togụ́ ꞌyị ukucayi ledre gɨ do bi ꞌDówụ́ Lomo, Lomo otoomo ené ledre zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Máúku zɨ́se, Máa bɨ Lomo kasaogụ máa ba, togụ́ ꞌyị ukucayi ledre gɨ do bi Owụ́ ꞌbɨ ꞌYịmaꞌdí yá, Lomo nɨ ótoómo ledre zɨ́a. Togụ́ ukucayi ledre gɨ do bi ꞌDówụ́ Lomo yá, tɨ́ bɨ nɨ ndị́sị ꞌbɨ ené ní, Lomo otoomo ledre zɨ́a kú wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ndịsịnɨ́ ówoyéme ꞌyịmaꞌdí gɨ zɨ́ mɨméngị ledre ené. Bɨlámá ꞌyị, mɨméngị ledre ené nɨ bɨlámáne. Bɨsinyí ꞌyị, mɨméngị ledre ené nɨ kpá bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Máúku zɨ́se, éyị́ ga bɨ ndị́sịsé úku yée sɨmɨ ꞌdódo ledre esé zɨ́ ꞌyị e ní, ndịsị ówo royé káa zɨ́ okó phoꞌdụ ní, ndị́sịsé née úku ledre ga bɨ do mɨmbéꞌdesé ní zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bɨlámá ledre ndịsị ólụ́ógụ gɨ ku bɨlámá ꞌyị. Zɨ́ bɨsinyí ledre ndị́sị ólụ́ógụ ꞌbɨ ené kpá gɨ ku bɨsinyí ꞌyị. Gɨ zɨ́a née éyị́ bɨ nɨ sɨmɨ mɨmbéꞌdea ní. ");
INSERT INTO bdh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lomo nɨ ꞌdódoógụ bɨsinyí ledre ga bɨ ꞌyị e ndịsịnɨ́ úku yée ní mbá karanée kadra ngbanga, zɨ́a ꞌdécị ngbanga royé kacɨ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lomo nɨ ꞌdécị ngbanga ꞌyị kacɨ́ mɨódro ꞌbɨ ꞌyị. Wo bɨ nɨ bɨlámáne ní, zɨ́a úku a yaá ba bɨlámá ꞌyị. Togụ́ bɨsinyíne yá, zɨ́a úku a yaá ba bɨsinyí ꞌyị.” ");
INSERT INTO bdh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zɨ́ Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ ꞌbɨ Yụ́da e úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, méngị aka ledre bɨ kɨ́ rokoꞌbụné ní mu zɨ́ze lúrú a.” ");
INSERT INTO bdh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yésụ ya zɨ́ye ní, “Sée ꞌyị luyú ledre e, ledre mengị kóo roné kɨ́ rokoꞌbụné zɨ́ nébị Yóna káa do ꞌdódo ledre e zɨ́se, tɨ́ lá ílisé esé ṇgúṇgu a wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mongụ́ kénzé ụlụ kóo Yóna, zɨ́a méngịné sị́lị́ ota (3) sɨmɨ a, zɨ́a nda síꞌdíógụ wo. Kpá kenée, Máa bɨ Lomo kasaogụ máa ba ní, Mááyí méngị sɨmɨ káṇgá kpá sị́lị́ ota (3) zɨ́ma nda úrúma. ");
INSERT INTO bdh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ꞌYị ꞌbɨ Nịnévị nɨyí karanée úku ledre kɨ́dí ásé ꞌyị lúyú ledre e, gɨ zɨ́a oyóloꞌbónɨ́ kóo mɨmbéꞌdeyé zɨ́ye ṇgúṇgu ledre ꞌbɨ Lomo bɨ kóo Yóna ndịsị úku a ní. Bɨ ba ní, máa bɨ márómo do Yóna ní ílisé kpá óyólóꞌbó mɨmbéꞌdesé zɨ́se ṇgúṇgu ledre ꞌbɨ Lomo gɨ taramá wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mongụ́ ngére nɨ kóo bo kára ꞌyị, ịnyị kú gɨ sɨmɨ káṇgá ené Séba ógụ úwú ledre gɨ tara Solomóna. Nɨ karanée ꞌdécị ngbangasé, gɨ zɨ́a máa bɨ márómo gɨ do Solomóna ní, ílisé úwú ledre gɨ taramá wá. ");
INSERT INTO bdh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Togụ́ bɨcayi lomo olụ́ogụ go gɨ sɨmɨ ꞌyị, nɨ ndéré gámásóꞌdo kpá té ngíti ꞌyị gɨ ro ólụ́ ndị́sịné sɨmɨ a. Togụ́ ndiki ngíti ꞌyị mbá wá, ");
INSERT INTO bdh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nɨ úku ledre kɨ́dí, ‘Bɨlámá a máídí ndáꞌba kɨ́ꞌdí bɨ kóo mándị́sị ndị́sị ní.’ Togụ́ nderé ndiki ꞌDówụ́ Lomo ndaá sɨmɨ mɨmbéꞌde ꞌyị née fú lá wá, nɨ ídí ené kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɨ ndéré ndóloógụ lafúne e bɨcayi lomo e ịnyị doa gbre yée ga bɨ nda bɨsinyíye kɨ́ngaya ní zɨ́ye ndị́sịyé kéye mɨmbéꞌde ꞌyị née íri, zɨ́ ꞌyị née nda sínyí tátá roné ꞌdáꞌdá. Sée ꞌyị ga bɨ cakaba ba ní, née éyị́ bɨ nɨ méngị roné zɨ́se ní.” ");
INSERT INTO bdh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sɨmɨ bɨ Yésụ nɨ fú ndị́sị ꞌdódo ledre zɨ́ tụ́ꞌdụ́ ꞌyị e ꞌdị́cị́ ní, zɨ́ mbágáa kɨ́ lúnduga ógụ tóroyé sága kákasa kɨ́dí yée ilinɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Zɨ́ ngíti ꞌyị gɨ dongará ꞌyị ga bɨ ore née úku ledre zɨ́a kɨ́dí, “Mbágáyị kɨ́ lúnduyị́ e ilinɨ́ yị́ị sága ꞌdáa ilinɨ́ ódro zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “mbágáma e ꞌbe náambi e? Sara Lúndumá e ꞌbe náambi e?” ");
INSERT INTO bdh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zɨ́a kụ́ꞌdụ sị́lị́ne ro ꞌyị lódụ́ kacɨ́ne e, zɨ́a úku ledre kɨ́dí, “Ga gére née mbágáma e kɨ́ lúndumá e. ");
INSERT INTO bdh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ꞌYị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ Babá bɨ komo ere ili ní, nɨyí ye mbágáma e, lémịmá e kɨ́ lúndumá e.” ");
INSERT INTO bdh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cịkị sɨmɨ sị́lị́ née, sɨmɨ ngíti sịndị́ kadra, zɨ́ Yésụ ólụ́ógụyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ ꞌbe ndéré ndị́sịné kóꞌdụ́ mɨkavu Galiláya. ");
INSERT INTO bdh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Zɨ́ tụ́ꞌdụ́ ꞌyị e yóko royé cigí a íri gɨ ro úwú ledre e gɨ taraa. Zɨ́a ékị́ ndị́sịné sɨmɨ kuṛúngba ꞌyị e nɨyí ꞌbɨ eyé mbá do gbúṛóngó sága. ");
INSERT INTO bdh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zɨ́a ꞌdódo tụ́ꞌdụ́ ledre e zɨ́ye sɨmɨ muruwayi kɨ́dí, “Ngíti ꞌyị ịnyị kóo ndéré óyụ kúfú yáká ené, zɨ́a ndị́sịné óꞌdo éyị́. ");
INSERT INTO bdh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kúfú ga bɨ ndịsị óyụ yée ní, ngíti géyị utúnɨ́ do mɨsiꞌdi, zɨ́ solụ́ e lagá yée. ");
INSERT INTO bdh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ngíti géyị utúnɨ́ do landa zɨ́ye ụ́tụyé ꞌdiya gɨ zɨ́a bɨ káṇgá ndaá ore mbị́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sɨmɨ bɨ kadra suwu ní, zɨ́ye gágáye rúfú gɨ zɨ́a cíyíye ndaá sɨmɨ káṇgá wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ngíti géyị utúnɨ́ ꞌbɨ eyé dongará kị́nị e. Sɨmɨ bɨ ngborónɨ́ ní, zɨ́ kị́nị ga gére née álaꞌdụ́tụ yée anánɨ́ wá, zɨ́ye ndáꞌbá eyé mbá andulé. ");
INSERT INTO bdh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngíti géyị utúnɨ́ ꞌbɨ eyé sɨmɨ bɨlámá káṇgá. Zɨ́ mị́ngị́ yáká ówo gɨ sɨmɨ ngíti bi kongụ ịnyị (100), gɨ sɨmɨ ngíti a kongụ ota (60), gɨ sɨmɨ ngíti a ꞌbɨ ené kongụ kị́éꞌdo doa sokó (30). ");
INSERT INTO bdh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ꞌYị bɨ uwú ledre bú ní, ídí úwú ledre ba bɨlámáne.” ");
INSERT INTO bdh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nda gɨ ꞌdáꞌba, zɨ́ ꞌyị lódụ́ kacɨ́ga ógụ ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, éyị́ bɨ ndị́sị ódro zɨ́ze fú lá sɨmɨ muruwayi gɨ zɨ́a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Lomo ꞌdódo mɨótoécị ledre ga bɨ ꞌbe ꞌbɨ ené komo ere ní go zɨ́se, tɨ́ lá ꞌdodo ené zɨ́ ngíti géyị ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tɨ́ lá ꞌyị bɨ kɨ́ éyị́ zɨ́ne ní nɨyí íꞌbí yata zɨ́a, zɨ́ éyị́ nda ídíne zɨ́a kɨ́ngaya. ꞌYị máa wo bɨ éyị́ ndaá zɨ́a wá ní, gba owụ́ a bɨ zɨ́a ní, nɨyí ꞌdíꞌbióyó a gɨ zɨ́a ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Née sị́ ledre bɨ mándị́sị ódro zɨ́ ꞌyị e sɨmɨ muruwayi gɨ zɨ́a ní. “Abú nɨyí tɨ́ lúrú éyị́ ga bɨ mááyí ndị́sị méngị yée ní kɨ́ komoyé yá, lurú yemenɨ́ eyé wá, abú nɨyí tɨ́ kɨ́ úwú ledre ga bɨ mááyí ndị́sị úku yée ní kɨ́ mbílíye yá, olụ́ ené sɨmɨ doyé wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Ledre née mengị roné go tɨ́ cé káa zɨ́ bɨ kóo Lomo uku zɨ́ nébị Isáya eké a ní, kɨ́dí, “ ‘Ásé úwú ledre ga bɨ mááyí ndị́sị úku yée ní utúasá ené ólụ́ sɨmɨ dosé wá, abú ásé lúrú éyị́ ga bɨ mándị́sị méngị yée ní, utúasá esé ówoyéme a wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gɨ zɨ́a bɨ doyé orụ yị́ ené mɨórụ ní, utúasánɨ́ eyé úwú ledre kɨ́ mbílíye wá, ꞌdụtụnɨ́ komoyé kpá go ngbụ́rụ́. Nɨyí kóo ndị́sị lúrú éyị́ ga bɨ mándị́sị méngị yée ní kɨ́ komoyé, zɨ́ye ndị́sị úwú a kɨ́ mbílíye, zɨ́ye ndị́sịyé ówoyéme sɨmɨ ledre e kɨ́ mɨmbéꞌdeyé do ndáꞌbaógụyé zɨ́ma, káa bɨ mááyí yómo yée.’ ");
INSERT INTO bdh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Tɨ́ lá Lomo nɨ íꞌbí úndru zɨ́se gɨ zɨ́a komosé lurú bi bú, mbílíse uwú ledre bú bɨlámáne ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bɨ kenée ní, máúku zɨ́se maꞌdíi, tụ́ꞌdụ́ nébị e kɨ́ ngíti géyị ꞌyị ga bɨ kóo ꞌdesị́ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní, ndịsịnɨ́ kóo óto komoyé gɨ ro lúrú éyị́ ga bɨ lúrúsé yée ní tɨ́ lá utúasánɨ́ lúrú a wá, ndịsịnɨ́ kpá índi mbílíye gɨ ro úwú ledre ga bɨ úwúsé yée ní utúasánɨ́ úwú a wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Úwúsé nda ini ledre gɨ sɨmɨ muruwayi ꞌbɨ ꞌyị bɨ nderé óyụ kúfú ní mu. ");
INSERT INTO bdh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kúfú ga bɨ utúnɨ́ do mɨsiꞌdi ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị ga bɨ abú uwúnɨ́ tɨ́ bɨlámá ledre bɨ gɨ ro ꞌbe ꞌbɨ Lomo ní go yá, owoyemenɨ́ eyé ledre gɨ sɨmɨ a wá, zɨ́ Satána ógụné ꞌdíꞌbióyó bɨlámá ledre née gɨ do mɨmbéꞌdeyé ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kúfú ga bɨ utúnɨ́ do landa ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị ga bɨ uwúnɨ́ lá ledre ꞌbɨ Lomo geré zɨ́ye ꞌdíꞌbióto a ꞌdiya do mɨmbéꞌdeyé ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gɨ zɨ́a bɨ cíyí ledre maꞌdáa ndaá do mɨmbéꞌdeyé wá ní, sɨmɨ bɨ ꞌdoꞌdó ogụ go royé gɨ zɨ́a bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo ní, geré zɨ́ye óyó sogoyé zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kúfú máa wo bɨ utú ꞌbɨ ené dongará kị́nị ní, nɨ ꞌbɨ ené káa zɨ́ ꞌyị máa wo bɨ abú uwú tɨ́ ledre ꞌbɨ Lomo go yá, tɨ́ lá mongụ́ somụ́ ledre ené yị́ ené gɨ ro tụ́ꞌdụ́ éyị́ ga bɨ ꞌbɨ sága ba. Gɨ zɨ́ kéyị née, ledre ꞌbɨ Lomo bɨ ṇguṇgu ní, mɨáná a ndaá ꞌbɨ ené sɨmɨ a wá. ");
INSERT INTO bdh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ꞌYị máa wo bɨ uwú yeme ledre ꞌbɨ Lomo ní, nɨ ꞌbɨ ené káa zɨ́ kúfú ga bɨ utúnɨ́ sɨmɨ bɨlámá káṇgá, ngíti a aná ꞌbɨ ené míya (100), ngíti a ꞌbɨ ené cị́ ota (60) zɨ́ ngíti a ídí ꞌbɨ ené cị́ kéṛị́ a doa sokó (30) ní.” ");
INSERT INTO bdh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zɨ́ Yésụ kpá ị́nyịné úku ngíti muruwayi kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa zɨ́ oꞌdo bɨ nderé óyụ bɨlámá kúfú yáká ené ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nda go sɨmɨ ngíti sịndị́ kadra kɨ́ ndụlụ, zɨ́ ꞌyị bɨ nɨ okó ro mị́ngị́ yáká née ndéréne óyụ kúfú angángúya sɨmɨ kére ꞌbɨ oꞌdo née, zɨ́a ndéréókpó ené. ");
INSERT INTO bdh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sɨmɨ bɨ kére ngboró do gbóṛụ́ne nɨ nda go léfe kúfúne ní, zɨ́ angángúya kpá ólụ́ógụné dongará a. ");
INSERT INTO bdh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Zɨ́ ꞌyị ꞌbɨ moko ꞌbɨ mị́ngị́ yáká née ógụyé úku ledre zɨ́ mongụ́ ꞌyị eyé kɨ́dí, ‘Mongụ́ ꞌyị, bɨ kóo oyụnɨ́ yáká ꞌdáa dụụ́ kúfú kére ní, sara angángúya née ogụnɨ́ nda ꞌbɨ eyé íri gɨ ꞌda?’ ");
INSERT INTO bdh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mị́ngị́ yáká ya kɨ́dí, ‘Ezeokóma e oyụnɨ́ ye.’ “ꞌYị ꞌbɨ moko e ya kɨ́dí, ‘Íli go zɨ́ze ndéré lálaóyó yée ꞌdáꞌba?’ ");
INSERT INTO bdh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mị́ngị́ yáká ya zɨ́ye ní, ‘Ɨ́ꞌɨ, ótoómosé aka kenée káa bɨ ásé lála kótrụ yée ndro kɨ́ kére e ke. ");
INSERT INTO bdh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Idínɨ́ aka ídí mbá kenée, gị sɨmɨ sịndị́ kadra ꞌbɨ óṇgo kére. Mááyí ogụ úku a zɨ́ ꞌyị ga bɨ nɨyí óṇgo kére ní kɨ́dí, idínɨ́ aka ndéré fị lálaóyó angángúya née ódó yée, do óngbóóyó yée ꞌdáꞌba, zɨ́ye nda óṇgo kére ndéré kɨ́e sɨmɨ gbagba.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zɨ́ Yésụ kpá úku ngíti muruwayi kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa zɨ́ oꞌdo bɨ ꞌdiꞌbi kúfú kágá bɨ ndịsịnɨ́ ndólo a musɨtáda nderé kɨ́e óyụ a yáká ené ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Abú kágá née kúfú ga nɨyí nzéré yá, sɨmɨ bɨ oyụ ní, zɨ́a ngbóró ógụné mongụ́ kágá rómo do ngíti géyị kágá e yáká ore mbá. Zɨ́a nda ídíne go kágá bɨ zɨ́ solụ́ e ógụyé ndị́sị ụ́bụ́ ꞌbe ꞌbɨ eyé komo a.” ");
INSERT INTO bdh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zɨ́a kpá úku ngíti muruwayi kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa zɨ́ owụ́ ꞌdeꞌdị́ bɨ lá cúkuꞌdée kará e ndịsịnɨ́ lótó mongụ́ leꞌyị́ kɨ́e zɨ́a átáne gɨ zɨ́a ní.” ");
INSERT INTO bdh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yésụ ndịsị kóo úku éyị́ ga gére née zɨ́ ꞌyị e mbá sɨmɨ muruwayi. Ledre bɨ kị́éꞌdo zɨ́a úku a zɨ́ye ndaá sɨmɨ muruwayi wá ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yésụ ndịsị née méngị ledre ga bɨ kóo Lomo uku zɨ́ ngúru nébị éké a kɨ́dí, “Mááyí ndị́sị úku ledre zɨ́ye sɨmɨ muruwayi. Mááyí úku ꞌdódo ledre ga bɨ kóo mɨótoécịné kú sɨmɨ sịndị́ kadra bɨ kóo máótoógụ do sogo káṇgá sɨmɨ a ní zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nda gɨ do kacɨ́ ꞌdódo ledre, zɨ́ Yésụ ótoómo tụ́ꞌdụ́ ꞌyị ga gére née ore zɨ́a ndáꞌbané ꞌbe kɨ́ꞌdí bɨ ndịsị ꞌdúꞌdu ní do ólụ́ne ꞌdị́cị́. Zɨ́ ꞌyị lódụ́ kacɨ́ga ólụ́ lódụ́ kacɨ́ a zɨ́ye ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, úkuógụ aka ini ledre gɨ sɨmɨ muruwayi ꞌbɨ tóꞌdó ga úku ní zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Zɨ́a úkulúgu ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Oꞌdo bɨ oyụ bɨlámá kúfú née Owụ́ ꞌbɨ ꞌYịmaꞌdí. ");
INSERT INTO bdh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yáká nɨ ꞌbɨ ené do sogo káṇgá ba. Bɨlámá kúfú nɨ ꞌbɨ ené ꞌyị ga bɨ ṇguṇgunɨ́ Lomo go káa do ngére eyé ní. Bɨsinyí kúfú ꞌbɨ ené ꞌyị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ ꞌbɨ Satána ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ezeokó mị́ngị́ yáká bɨ oyụ bɨsinyí kúfú ní nɨ ꞌbɨ ené ngére ꞌbɨ bɨcayi lomo e. Kadra óṇgo kére nɨ ꞌbɨ ené odụ sịndị́ kadra ꞌbɨ do sogo káṇgá ba. ꞌYị óṇgo kére nɨyí ꞌbɨ eyé maláyika e. ");
INSERT INTO bdh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Bɨsinyí kúfú ga bɨ odónɨ́ yée óngbó yée née, nɨyí ꞌbɨ eyé née ꞌyị ga bɨ Lomo nɨ ꞌdécị ngbangayé sɨmɨ odụ sịndị́ kadra ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ kása maláyika ené e ndéré ị́cị́óyó tóꞌdó kɨ́ éyị́ ga bɨ ndịsị ꞌdíꞌbiógụ luyú kɨ́ ꞌyị méngị bɨsinyí ledre gɨ ꞌbe ꞌbɨ ené mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Do ụ́cụ yée mbá sɨmɨ mongụ́ gu phoꞌdụ bɨ ịlị́ wá ní zɨ́ye ndị́sịyé mbụ́mbụ́dụ́ kɨ́ náná do soyé gɨ zɨ́ éyị́ mɨówo. ");
INSERT INTO bdh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ꞌYị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní, zɨ́ royé ndị́sị ṛíṛíne káa zɨ́ sụ́lụ́ kadra gɨ zɨ́ rokoꞌbụ ꞌbɨ ꞌBụyé Lomo bɨ doyé ní. Togụ́ mbílíse nɨ bo yá, ídísé úwú ledre bɨ máúku née.” ");
INSERT INTO bdh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zɨ́a kpá úku ngíti muruwayi kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa ꞌyị bɨ ndiki mongụ́ késị́ bɨ otoecịnɨ́ sɨmɨ káṇgá ní.” Zɨ́a kpá ótoécị ándá a. Gɨ zɨ́ rokinyi zɨ́a ndáꞌbané úgúóyó éyị́ ga bɨ zɨ́ne ꞌbe ní mbá, do ndáꞌbané úgú bi bɨ ótoécị késị́ née doa ní zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Zɨ́a kpá úku ngíti muruwayi kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa zɨ́ ꞌyị bɨ nderé gámásóꞌdo gali bɨ kɨ́ tosoné ṛíṛiṛí kɨ́ mongụ́ keꞌbịné ꞌdága ní gɨ ro úgú a. ");
INSERT INTO bdh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sɨmɨ bɨ nderé ndíki ní, zɨ́a ndáꞌbané úgúóyó éyị́ ga bɨ zɨ́ne ꞌbe ní mbá do ndéréne úgú gali née.” ");
INSERT INTO bdh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Zɨ́a kpá úku ngíti a kɨ́dí, “Ledre nɨ gɨ ro ledre ga bɨ ꞌbe ꞌbɨ Lomo komo ere ní káa zɨ́ ꞌyị méngị kénzé ga bɨ onzóomonɨ́ mbírá kénzé sɨmɨ iní zɨ́ ṛị́kị́ kénzé e lákayé sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sɨmɨ bɨ tụ́ꞌdụ́ kénzé e lakanɨ́ go sɨmɨ a ní, zɨ́ mị́ngị́ mbírá ógụyé lálaógụ mbírá do gbúṛóngó, ndị́sịyé gélé kénzé e. Zɨ́ye ꞌdíꞌbióto yée ga bɨ ilinɨ́ ní sɨmɨ éyị́, yée ga bɨ ilinɨ́ wá ní, zɨ́ye ụ́cụóyó yée ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Karanée sɨmɨ odụ sịndị́ kadra ledre e nɨyí méngị royé kenée. Maláyika e nɨyí ógụ ífi dongará bɨsinyí ꞌyị e kɨ́ bɨlámá ꞌyị e, ");
INSERT INTO bdh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","do ꞌdíꞌbi yée ụ́cụ yée sɨmɨ mongụ́ gu phoꞌdụ bɨ ịlị́ wá ní, kɨ́ꞌdí bɨ ꞌyị e nɨyí ndị́sị mbụ́mbụ́dụ́ kɨ́ náná do soyé gɨ zɨ́ éyị́ mɨówo ní.” ");
INSERT INTO bdh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Ówosé ini ledre gɨ sɨmɨ ledre ga bɨ máúku yée née go?” Zɨ́ye ṇgúṇgu a kɨ́dí, “Ɨɨ, owozé go.” ");
INSERT INTO bdh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zɨ́ Yésụ kpá úku ledre zɨ́ye kɨ́dí, “Ini ledre sɨmɨa nɨ káa, ꞌyị ꞌdódo lorụ ga bɨ mbá ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní nɨyí ídí ꞌbe ꞌbɨ Lomo komo ere káa zɨ́ mị́ngị́ ꞌbe bɨ olụ́ ꞌdị́cị́ zɨ́a ꞌdóꞌdụ́ógụ mɨkánda éyị́ e kɨ́ kuṛúga mbá sága gɨ ꞌdị́cị́ ené ní.” ");
INSERT INTO bdh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sɨmɨ bɨ Yésụ ꞌdodo asá ledre sɨmɨ muruwayi zɨ́ye ore ní, zɨ́a ndéréókpóne gɨ ore. ");
INSERT INTO bdh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sɨmɨ bɨ nderéogụ sɨmɨ Nazeréta sɨmɨ gara bɨ ngboró sɨmɨ a ní, zɨ́a tónóne ꞌdódo ledre zɨ́ Yụ́da e sɨmɨ ꞌDị́cị́ Kótrụro. ꞌYị ga bɨ owonɨ́ wo kɨ́ ꞌdódo ledre ní zɨ́ tarayé ị́drị́ne mbá mɨị́drị́. Zɨ́ye úku ledre kɨ́dí, “Ndiki rokoꞌbụ kɨ́ mongụ́ ówo ledre bɨ zɨ́a ndị́sịné ꞌdódo mɨngburoko ledre kɨ́e bɨ káa ba gɨ ꞌda? Sara mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé née? ");
INSERT INTO bdh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Owozé wo bú bɨlámáne nɨ wotị́ Yoséfa bɨ ꞌyị yéme éyị́ e gɨ sɨmɨ kágá ní, ịrị mbágáa Maríya. Lúndu ga nɨyí Yakóbo e, Yoséfa e, Simúna e nda kɨ́ Yụ́da e. ");
INSERT INTO bdh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lémị ga nɨyí kpá mbá kɨ́ze ona. Sara ndiki rokoꞌbụ zɨ́a ndị́sịné méngị ledre ga gére née kɨ́e née gɨ ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Zɨ́ ꞌyị ga gére née óto mɨmbéꞌdekesị́ ro Yésụ. Zɨ́a ị́nyịné úku ledre zɨ́ye kɨ́dí, “Ndịsịnɨ́ óto úndru nébị do bi ga bɨ ꞌdí sogo ní tɨ́ lá bi bɨ nébị née ngboró doa kɨ́ ꞌyị ꞌbe ꞌbɨ ené otonɨ́ eyé úndrua wá.” ");
INSERT INTO bdh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gɨ zɨ́a bɨ ꞌyị ꞌbɨ Nazeréta e ṇguṇgunɨ́ eyé ledre ꞌbɨ Yésụ wá ní, Yésụ mengị ené mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé ní zɨ́ye ore wá. ");
INSERT INTO bdh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sɨmɨ sịndị́ kadra máa née ní, zɨ́ phanda Yésụ ówụ́ ndíki mbílí ngére Eróde, ");
INSERT INTO bdh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","zɨ́a úku ledre zɨ́ ngíti géyị ꞌyị ꞌbɨ moko ené e kɨ́dí, “Née Yiwáni ꞌyị Bábátị́zị́ ꞌyị e bɨ kóo ufunɨ́ wo ní urúne, ndịsị méngị mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé née ne gɨ zɨ́ kéyị née.” ");
INSERT INTO bdh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eróde onzó kóo Yiwáni sɨmɨ sị́gịnị gɨ ro do úfu wo gɨ ro Erodíya meꞌbe lúnduné Phị́lịpo, ");
INSERT INTO bdh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","gɨ zɨ́a Yiwáni ndịsị úku ledre kɨ́dí, “Eróde, ndaá bɨlámáne wá, lúnduyị́ nɨ aka kɨ́ komoné áyí ꞌdíꞌbi meꞌbe a káa do kára zɨ́yị káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eróde ayí kóo geré gɨ ro úfu Yiwáni mɨúfu tɨ́ lá bi úfu wo ndaá gɨ zɨ́a tụ́ꞌdụ́ ꞌyị e ṇguṇgunɨ́ yị́ eyé mbá ledre ga bɨ Yiwáni ndịsị úku yée ní gɨ zɨ́a owonɨ́ go kɨ́dí Yiwáni nɨ yị́ ené nébị. ");
INSERT INTO bdh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nda sɨmɨ sị́lị́ ꞌbɨ ayímbi, née ayímbi ꞌbɨ sị́lị́ bɨ kóo aránɨ́ Eróde maꞌdáa sɨmɨ a ní, zɨ́ nyị́ Erodíya kára bɨ ꞌdiꞌbi gɨ zɨ́ lúnduné ba ndị́sịné léꞌbé keꞌbị, zɨ́ Eróde ídíne kɨ́ mongụ́ rokinyi ");
INSERT INTO bdh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","zɨ́a lólóbụ́ zɨ́ owụ́kára née kɨ́dí éyị́ bɨ ili ní idí úku ledre a née nɨ íꞌbí a zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Zɨ́ owụ́kára née ndúꞌyú mbágáne, née idí úku ledre ꞌdi? Mbágáa ya zɨ́a ní, idí úku a kɨ́dí, “Máíli do lágáꞌdécị go Yiwáni Babatị́za zɨ́ye ógụ kɨ́ doa gɨrí do éyị́ zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Zɨ́ ledre née íꞌbí mongụ́ sómụ́ ledre zɨ́ ngére Eróde. Nda lá gɨ zɨ́a bɨ uku gáa ledre née do komo tụ́ꞌdụ́ mɨngburoko ꞌyị ga bɨ ndolo ogụ yée ní, zɨ́a tɨ́ kákasa ");
INSERT INTO bdh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","idínɨ́ mu ndéré úfu Yiwáni zɨ́ye ógụ kɨ́ doa do éyị́ zɨ́ owụ́kára née lúrú a. ");
INSERT INTO bdh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Zɨ́ye ógụ kɨ́ do Yiwáni do éyị́ íꞌbí a zɨ́ owụ́kára née, zɨ́a ndéréne ꞌdódo a zɨ́ mbágáne. ");
INSERT INTO bdh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zɨ́ sanda ndéréne zɨ́ ꞌyị lódụ́ kacɨ́ Yiwáni, zɨ́ye ógụyé ꞌdíꞌbi umbu Yiwáni ndéré óto a. Zɨ́ye ndéréye úku ledre bɨ mengị roné née zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sɨmɨ bɨ Yésụ uwú ledre umbu Yiwáni ní, zɨ́a ị́nyịné kɨ́ ꞌyịmɨkása ené e ékị́ye sɨmɨ kuṛúngba ꞌdógụ mɨkavu Galiláya aka gɨ ro ndéré ndị́sịyé do bi bɨ tụ́ꞌdụ́ ꞌyị e ndanɨ́ doa wá ní. Zɨ́ ꞌyị ga bɨ íri née kpá úwú ledre a zɨ́ye ndéréye sóngó wo. ");
INSERT INTO bdh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nɨyí ndéréógụ bɨ do gbúṛóngó ní, tụ́ꞌdụ́ ꞌyị e nɨyí go íri ꞌdii. Zɨ́ lerị́ye méngị wo zɨ́a ꞌdíꞌbióyó ndíyá e gɨ royé. ");
INSERT INTO bdh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nda go za kɨ́ tagá, zɨ́ ꞌyị lódụ́ kacɨ́ga úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, kadra utú go, éyị́ mɨánu ndaá kpá ona wá. Ótoómo sị́lị́yị gɨ ro ꞌyị ga gére née mu zɨ́ye ndéréye gámásóꞌdo éyị́ mɨánu zɨ́ye ánu a.” ");
INSERT INTO bdh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zɨ́ Yésụ úkulúgu ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Ndanɨ́ ndéré wá, ídísé íꞌbí éyị́ mɨánu se zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Zɨ́ ꞌyị lódụ́ kacɨ́ga úkulúgu ledre kɨ́dí, “Mongụ́ ꞌyị, odụ éyị́ bɨ do sị́lị́ze ona ní lá dụụ́ ambata ịnyị (5) kɨ́ mɨnzéré kénzé e gbre.” ");
INSERT INTO bdh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zɨ́a úku ledre kɨ́dí, “Ógụsé aka kɨ́ ambata máa ga gére née yáa.” ");
INSERT INTO bdh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yésụ ya ꞌyị e idínɨ́ ndị́sị do súwú ga gére née bi ore. Zɨ́a ꞌdíꞌbi ambata kɨ́ kénzé ga bɨ gbre née do sị́lị́ne, zɨ́a lúrú bi komo ere, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo, zɨ́a ꞌdéweífi sɨmɨyé. Zɨ́a íꞌbí a do sị́lị́ ꞌyị lódụ́ kacɨ́ne ga gére née idínɨ́ ífi yée zɨ́ ꞌyị e ánu a. ");
INSERT INTO bdh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Zɨ́ tụ́ꞌdụ́ ꞌyị ga ba ánu éyị́ zɨ́ye léreyé mbá. Ngítí a ga bɨ idíaká ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née ꞌdóꞌdụ́ ꞌdúcu gbété e kɨ́e sokó doa gbre (12). ");
INSERT INTO bdh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ꞌYị ga bɨ anunɨ́ éyị́ ní, yaꞌdá e nɨyí kóo álifu ịnyị (5,000). Olonɨ́ kará e kɨ́ owụ́ e wá. ");
INSERT INTO bdh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Geré gɨ do kacɨ́ éyị́ mɨánu née, zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née idínɨ́ mu ꞌdógụ mɨkavu ndéréókpóye ꞌdáꞌdá. Zɨ́a aka ídíáká ꞌbɨ ené ꞌdáꞌba gɨ ro úku ledre zɨ́ ꞌyị ga gére née ndáꞌbayé ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sɨmɨ bɨ uku ledre go zɨ́ ꞌyị ga gére née kɨ́dí bayinɨ́ mu ní, zɨ́a ndéré ékị́ne do landa ngúcuné íni ini zɨ́ Lomo. Ndịsị íri gị kɨ́ tagá ngúcuné. ");
INSERT INTO bdh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kuṛúngba bɨ gáa ꞌyị lódụ́ kacɨ́ga nɨyí sɨmɨ a ní nderé go sɨmɨ iní gbála gɨ do gbúṛóngó. Gɨ zɨ́ síli bɨ ndịsị ílí do iní kɨ́ rokoꞌbụné ní, zɨ́ iní nda ndị́sịné ụ́cụlóꞌbó kuṛúngba gbụ́ gbụ́ gbụ́, bi ndéré eme lolụ ngụ́. ");
INSERT INTO bdh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nda kɨ́ sị́ ndóndó, zɨ́ Yésụ ékị́ógụné gɨ do landa gɨrí ndị́sị ndéréne do iní zɨ́ ꞌyị ené ga bɨ sɨmɨ kuṛúngba née káa zɨ́ ndịsị ndéré do ngáká bi ní. ");
INSERT INTO bdh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ga ga gére née lurúnɨ́ wo do iní kɨ́ ndị́sị ógụꞌdị́yị roné mɨꞌdí zɨ́ye ní, zɨ́ ngịrị méngị yée. Zɨ́ye útúye ndị́sị mbụ́mbụ́dụ́ gɨ zɨ́a somụ́nɨ́ ꞌbɨ eyé kɨ́dí née go “ꞌYị lárá.” ");
INSERT INTO bdh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Geré ꞌdiya zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ndásé éré ngịrị wá, née máa.” ");
INSERT INTO bdh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zɨ́ Pétero úkulúgu ledre zɨ́a ya, “Mongụ́ ꞌyị togụ́ née tɨ́ yị́ị maꞌdíi, ídí mu ṇgúṇgu a zɨ́ma ndéréma gɨ do iní ógụmá zɨ́yị íri.” ");
INSERT INTO bdh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yésụ ya zɨ́a ní, “Ógụ mu.” Zɨ́ Pétero ékị́ógụné gɨ sɨmɨ kuṛúngba ndị́sị ndéréne do iní mɨꞌdí zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tɨ́ lá sɨmɨ bɨ Pétero lurú iní nɨ ndị́sị kị́zị kɨ́ rokoꞌbụné kɨ́ngaya gɨ zɨ́ mongụ́ síli ní, zɨ́ ngịrị méngị wo, geré zɨ́a tónóne ólụ́ne sɨmɨ iní. Zɨ́a ótrụ́ ledre kɨ́dí, “Ngére yómo máa mu.” ");
INSERT INTO bdh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Geré zɨ́ Yésụ áꞌdané sáká wo, zɨ́a úku ledre kɨ́dí, “Pétero ṇgúṇgu aka eyị́ ledremá kɨ́ngaya fú wá, éré ngịrị gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sɨmɨ bɨ Pétero ekị́lugunɨ́ royé kɨ́ Yésụ sɨmɨ kuṛúngba ní, geré zɨ́ mongụ́ síli bɨ gáa ba tóroné. ");
INSERT INTO bdh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zɨ́ ꞌyị ga bɨ sɨmɨ kuṛúngba née óto úndrua, zɨ́ye úku ledre kɨ́dí, “Yésụ, áyí Owụ́ ꞌbɨ Lomo maꞌdíi.” ");
INSERT INTO bdh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zɨ́ye ꞌdógụ bi do ndéréógụyé sɨmɨ owụ́ gara bɨ kɨ́ ịrịné Geneseréta ní. ");
INSERT INTO bdh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sɨmɨ bɨ ꞌyị ga bɨ ꞌbɨ gara née owonɨ́ kɨ́dí Yésụ ogụ née ne ní, zɨ́ye kákasa sɨmɨ gara ore mbá kɨ́dí ꞌyị ga bɨ ꞌyị eyé e nɨyí kɨ́ ndíyá ní, idínɨ́ ógụ kéye zɨ́ Yésụ, nɨ go sɨmɨ gara ore. ");
INSERT INTO bdh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Zɨ́ ꞌyị ndíyá e ṇgúṇgú royé zɨ́a idí ṇgúṇgu a zɨ́ye óto sị́lị́ye lá gba ro tara bongó ené. Maꞌdíi yée ga bɨ otonɨ́ sị́lị́ye ro tara bongó ené ní, zɨ́ ndíyá eyé e tɨ́ ụ́kụ́ne gɨ royé. ");
INSERT INTO bdh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nda gɨ ore zɨ́ ngíti géyị Farụsáyo e kɨ́ ngíti géyị ꞌyị ga bɨ ndịsịnɨ́ ꞌdódo lorụ ní, ógụyé gɨ sɨmɨ Yerụsaléma ndúꞌyú Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Éyị́ bɨ ꞌyị lódụ́ kacɨ́yị ga ba ilinɨ́ méngị kéyị kacɨ́ ondụ́ ezé gɨ zɨ́a wá ní ꞌdi? Ndịsịnɨ́ ánu éyị́ geré mɨánu ilinɨ́ lúgu sị́lị́ye kí wá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zɨ́ Yésụ ndúꞌyú lúgu yée kɨ́dí, “Sara ílisé méngị kéyị kacɨ́ lorụ ꞌbɨ Lomo wá gɨ ro ꞌdi, bɨ zɨ́se ndị́sịsé méngị dụụ́ ledre ga bɨ ondụ́ esé ili yée ní. ");
INSERT INTO bdh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Lomo iꞌbí lorụ kɨ́dí, ‘Ídí óto úndru ꞌbụyị́ e kɨ́ mbágáyị.’ ‘ꞌYị bɨ nɨ uku tara sinyí zɨ́ ꞌbụné e kɨ́ mbágáne ní, idínɨ́ úfu wo ꞌdáꞌba.’ ");
INSERT INTO bdh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tɨ́ lá ndị́sịsé ꞌdódo ledre kɨ́dí, togụ́ ꞌyị uku ledre zɨ́ ꞌbụné e kɨ́ mbágáne kɨ́dí, ‘Éyị́ ga bɨ ílisé gɨ ro zɨ́ye sáká sée kɨ́e ní, máíꞌbí go káa do tákpásị́lị́ zɨ́ Lomo,’ ");
INSERT INTO bdh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ndaá gɨ ro zɨ́ye óto úndruyé kɨ́e wá. ꞌDéwesé née go lorụ ꞌbɨ Lomo gɨ ro ondụ́ esé ꞌbɨ Yụ́da e. ");
INSERT INTO bdh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ndị́sịsé lóndo rosé kɨ́dí ásé ꞌyị méngị ledre ꞌbɨ Lomo, ábuwá ledre bɨ nébị Isáya uku gɨ rosé ní nɨ maꞌdíi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘ꞌYị ga ba ndịsịnɨ́ óto úndrumá lá dụụ́ do tarayé, tɨ́ lá mɨmbéꞌdeyé nɨ yị́ ené gɨ romá gbála. ");
INSERT INTO bdh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndịsịnɨ́ óto úndrumá lá gbékpị́ne, ndị́sịnɨ́ tɨ́ ꞌdódo ledre ní, tɨ́ lá yị́ eyé lorụ eyé ꞌbɨ ꞌyịmaꞌdí e.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ndóloyóko tụ́ꞌdụ́ ꞌyị e zɨ́a úku ledre zɨ́ye kɨ́dí, “Ídísé úwú ledre ba zɨ́se ówoyéme a bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndaá ꞌbɨ ené éyị́ mɨánu bɨ ꞌyị ánu ní nɨ oto wo ne zɨ́a ídíne ꞌyị lúyú ledre wá, yị́ ené bɨsinyí ódro bɨ gɨ taraꞌyị ní.” ");
INSERT INTO bdh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ógụyé úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ówo go kɨ́dí ledre bɨ gáa úku ba sinyí yị́ ené ro Farụsáyo e go mɨsínyí?” ");
INSERT INTO bdh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Éyị́ ga bɨ mbá ngárá Babá bɨ komo ere ꞌdịyị́ yée ne wá ní, nɨ lálaóyó yée mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ndásé óto komosé ro ledre ꞌbɨ Farụsáyo ga gére née wá, nɨyí yị́ eyé manda ga bɨ komoyé ndaá ní. ꞌYị bɨ komoa ndaá ní togụ́ lala ezené bɨ komoa ndaá ní, yée gbrengárá nɨyí útú sɨmɨ gu.” ");
INSERT INTO bdh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Zɨ́ Pétero úku ledre kɨ́dí, “Mongụ́ ꞌyị, úku ꞌdódo aka ini ledre gɨ sɨmɨ muruwayi bɨ úku née zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yésụ ya zɨ́ye ní, “Áyí, ówosé esé kpá wá? ");
INSERT INTO bdh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ówosé bɨ kɨ́dí éyị́ mɨánu ndịsị ólụ́ gɨ ku ꞌyị, zɨ́a ókpóne sɨmɨ ꞌyị, zɨ́a nda ólụ́ógụné gɨ sɨmɨ ꞌyị ꞌdáꞌba ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bɨsinyí ledre bɨ ndịsị ówụ́ gɨ taraꞌyị ní, ndịsị ólụ́ógụ gɨ yana mɨmbéꞌde ꞌyị. Gɨ zɨ́ kéyị née zɨ́ ꞌyị ídíne bɨsinyíne do komo Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bɨ kenée ní, bɨsinyí ledre ga bɨ káa zɨ́ úfu ꞌyị, sóꞌdo roꞌyị kɨ́ ꞌyị bɨ ófụ́sé rosé kéne wá ní, kɨ́ ledre ꞌbɨ gámá faa kacɨ́ kará e togụ́ yaꞌdá e, kɨ́ ugu, kɨ́ ṛanga, kpá úku tara sinyí zɨ́ ꞌyị e. Ledre ga gére née mbá olụ́ogụnɨ́ gɨ do mɨmbéꞌde ꞌyị. ");
INSERT INTO bdh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Éyị́ ga gére née ndịsịnɨ́ óto ꞌyị e ye zɨ́ye ídíye bɨsinyíye do komo Lomo. Ndaá ꞌbɨ ené ánu éyị́ mɨánu togụ́ mbú ꞌyị lúgu sị́lị́ne wá ní óto ꞌyị ne zɨ́a ídíne do komo Lomo bɨsinyíne ní wá.” ");
INSERT INTO bdh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zɨ́ Yésụ nda ị́nyịné gɨ ore ndéréne sɨmɨ gara ga bɨ Táyire kɨ́ Sidóna ní. ");
INSERT INTO bdh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Zɨ́ ngíti kára gɨ sɨmɨ kúfú bɨ Kanána e ndịsị ndị́sị do bi gbóo ore ógụné ṇgúṇgú roné zɨ́ Yésụ kɨ́dí, “Ngére, Bulúndu Dawídi, ówo aka ledre kɨ́ma. Nyị́ma dokéké e ndịsịnɨ́ méngị wo bɨsinyíne kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tɨ́ lá Yésụ ukulugu ené ledre zɨ́a wá. Zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ógụyé úku ledre zɨ́ Yésụ kɨ́dí, “Ógóóyó kára née gɨ ore ꞌdáꞌba. Ndịsị fú lá gbúrógbó do kacɨ́ze kɨ́ ledre ené née.” ");
INSERT INTO bdh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zɨ́ Yésụ úkulúgu ledre zɨ́ kára née kɨ́dí, “Lomo kasaogụ máa lá dụụ́ gɨ ro sáká ꞌyị amá e Isɨréle e gɨ zɨ́a nɨyí káa zɨ́ kábịṛị́kị ga bɨ mị́ngị́ye ndaá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Zɨ́ kára née ndósoógụné gbóo útúne gbrị kóꞌdụ́ Yésụ. Zɨ́a úku ledre zɨ́ Yésụ kɨ́dí, “Ngére, sáká máa mu.” ");
INSERT INTO bdh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yésụ ya zɨ́a ní, “Ndaá ꞌbɨ ené bɨlámáne do ꞌdíꞌbi éyị́ mɨánu ꞌbɨ owụ́ e íꞌbí a zɨ́ ị́sị e wá.” ");
INSERT INTO bdh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ngére, nɨ tɨ́ kenée. Tɨ́ lá ị́sị e ꞌdoꞌdụ́nɨ́ nyụnyụ́ éyị́ mɨánu gɨ sị́ tarabíza ꞌbɨ mị́ngị́ye bú.” ");
INSERT INTO bdh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Née ní, zɨ́ Yésụ úkulúgu ledre zɨ́ kára née kɨ́dí, “Kára ṇgúṇgu ledre eyị́ ofụ go. Éyị́ bɨ íli ní mááyí méngị a zɨ́yị.” Kpá tɨ́ geré sɨmɨ sịndị́ kadra née zɨ́ ro nyị́ kára née émené. ");
INSERT INTO bdh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zɨ́ Yésụ ị́nyịné gɨ ore ndáꞌbané kóꞌdụ́ mɨkavu Galiláya. Zɨ́a ndéré ékị́ne do landa ndị́sịné bi. ");
INSERT INTO bdh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụyé zɨ́a kɨ́ ꞌyị eyé ga bɨ kɨ́ umbu sịndị́ye, ꞌyị komo mɨꞌdụ́tụ e, mɨgịgị́ṛị́ e, yée ga bɨ odronɨ́ wá ní, nda kpá kɨ́ yée ga bɨ kɨ́ toso ndíyá eyé e mɨngúngúcua ní. Do ógụ óto yée mbá cigí Yésụ bi kenée, zɨ́a óto sị́lị́ne royé zɨ́ye ómo yée mbá. ");
INSERT INTO bdh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zɨ́ taraꞌyị e ị́drị́ne kɨ́ lúrú ꞌyị ga bɨ odronɨ́ wá ní kɨ́ ódro, mɨgịgị́ṛị́ e sịndị́ye ꞌdózo roné go, yée ga bɨ kɨ́ umbu sịndị́ye ní nɨyí go kɨ́ gámá, mɨkomo mɨꞌdụ́tụ nɨyí go lúrú bi. Zɨ́ye mbófo Lomo bɨ Isɨréle e ndịsịnɨ́ íni ini zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zɨ́ Yésụ ndólo ꞌyị lódụ́ kacɨ́ne e zɨ́a úku ledre zɨ́ye kɨ́dí, “Lerị́ ꞌyị ga ba mengị máa go, mengịzé kéye go sị́lị́ ota éyị́ mɨánu ndaá zɨ́ye wá. Ndaá bɨlámáne zɨ́ma ótoómo yée zɨ́ye ndáꞌbayé kɨ́ ꞌbú wá káa bɨ komoyé nɨ ụ́lụ́ yana zɨ́ye útúye ke.” ");
INSERT INTO bdh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Zɨ́ ꞌyị lódụ́ kacɨ́ga úkulúgu ledre zɨ́a kɨ́dí, “Azé ówo éyị́ mɨánu sɨmɨ súwú ona íꞌbí a zɨ́ tụ́ꞌdụ́ káa zɨ́ wo née gɨ ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yésụ ya zɨ́ye ní, ambata nɨ zɨ́se kɨ́rɨ́ née ndu? Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ambata e nɨyí ịnyị doa gbre (7) nda lá kɨ́ mɨnzéré kénzé e.” ");
INSERT INTO bdh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Zɨ́a úku ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga gére née ndị́sịyé bi do káṇgá. ");
INSERT INTO bdh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Zɨ́a ꞌdíꞌbi ambata ga bɨ ịnyị doa gbre (7) kɨ́ mɨnzéré kénzé ga gére née, sɨmɨ bɨ iꞌbí mbófo éyị́ go zɨ́ Lomo ní, zɨ́a ꞌdéweífi sɨmɨyé zɨ́a íꞌbí yée zɨ́ ꞌyị lódụ́ kacɨ́ne e, zɨ́ye nda íꞌbí a zɨ́ ꞌyị ga gére ní. ");
INSERT INTO bdh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Zɨ́ tụ́ꞌdụ́ ꞌyị ga gére née ánu éyị́, zɨ́ye léreyé mbá. Ngítí éyị́ mɨánu ga bɨ idíakánɨ́ ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ꞌdóꞌdụ́ ꞌdúcu gbété e kɨ́e kpá ịnyị doa gbre (7). ");
INSERT INTO bdh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gɨ sɨmɨ ꞌyị ga bɨ kóo anunɨ́ éyị́ ní, olonɨ́ lá dụụ́ yaꞌdá e álifu eso (4,000). Olonɨ́ kará e kɨ́ owụ́ e wá. ");
INSERT INTO bdh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gɨ do kacɨ́ bɨ Yésụ bayi ꞌyị ga gére née go ní, zɨ́a nda ékị́ne sɨmɨ kuṛúngba zɨ́ye ndéréye sɨmɨ bi bɨ ndịsịnɨ́ ndólo a Magadána ní. ");
INSERT INTO bdh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sɨmɨ ngíti sị́lị́, zɨ́ Farụsáyo e kɨ́ Sadụkáyo e ógụyé úzu Yésụ idí méngị ledre bɨ kɨ́ rokoꞌbụné ní gɨ ro zɨ́ye ówo a kɨ́dí Lomo kasaogụ wo ne gɨ komo ere. ");
INSERT INTO bdh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Togụ́ go kɨ́ tagá yá, ndị́sịsé úku ledre kɨ́dí, ‘Kɨ́lóndó kadra nɨ súwu gɨ zɨ́a bi nɨ komo ere gbawu káa.’ ");
INSERT INTO bdh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Togụ́ kɨ́ phịyị́ yá, zɨ́se ndị́sịsé úku ledre kɨ́dí, ‘Mụ́kụ́ nɨ go kụụ née ní iní nɨ éꞌdị karaba.’ Ówosé tɨ́ lá kacɨ́ úku ledre gɨ ro éyị́ ga bɨ ndịsịnɨ́ méngị royé komo ere ní, togụ́ nda gɨ ro éyị́ ga bɨ ndị́sịnɨ́ méngị royé ca cakaba ní yá, ówosé esé e wá. ");
INSERT INTO bdh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ílisé lúrú ledre ga bɨ kɨ́ rokoꞌbụyé ní té kí ásé fú ṇgúṇgu a. Gɨ zɨ́a bɨ ásé ꞌyị luyú ledre e ní, útúásásé esé ṇgúṇgu a wá. Ledre bɨ mááyí ꞌdódo a zɨ́se ní dụụ́ wo bɨ kóo mengị roné zɨ́ Yóna ní.” Gɨ ore, zɨ́ Yésụ ndéréókpóne. ");
INSERT INTO bdh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sɨmɨ bɨ Yésụ ꞌdogụnɨ́ bi sága ní, ꞌyị lódụ́ kacɨ́ga nɨyí lúrú bi ní, otoomo lịgịnɨ́ ambata go. ");
INSERT INTO bdh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Komosé idí ídí rosé gɨ zɨ́ bɨsinyí ꞌdódo ledre ꞌbɨ Farụsáyo e kɨ́ Sadụkáyo e bɨ káa zɨ́ ꞌdeꞌdị́ bɨ ndịsịnɨ́ óto a sɨmɨ ambata eyé e ní.” ");
INSERT INTO bdh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zɨ́ye úkulóꞌbó ledre dongaráye kɨ́dí, “Uku ledre née kenée ba gɨ zɨ́a bɨ ledre lịgị zée kɨ́ ꞌdíꞌbiútú ambata ní.” ");
INSERT INTO bdh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yésụ owo sómụ́ ledre eyé née go bú. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Éyị́ bɨ ndị́sịsé úku ledre ambata gɨ roa ní ꞌdi, ṇgúṇgusé aka esé ledremá fú wá ke? ");
INSERT INTO bdh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sómụ́lị́gịsé ledre ambata bɨ kóo ịnyị máíꞌbí zɨ́ ꞌyị e álifu ịnyị ní go, sara ngítíye bɨ idíaká ní, ꞌdóꞌdụ́ ꞌdúcusé kóo gbété kɨ́e ndu? ");
INSERT INTO bdh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Togụ́ wo née wá ní, sara ambata bɨ kóo ịnyị doa gbre (7) máíꞌbí zɨ́ ꞌyị e álifu eso (4,000) ánu a ní, ꞌdóꞌdụ́ ꞌdúcusé kóo gbété kɨ́ ngítíye ndu? ");
INSERT INTO bdh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Éyị́ bɨ sómụ́sé ledre gɨ zɨ́a kɨ́dí máúku gáa née ledre ambata gɨ roa ní ꞌdi? Komosé idí ídí rosé gɨ zɨ́ bɨsinyí ꞌdódo ledre ꞌbɨ Farụsáyo e kɨ́ Sadụkáyo e.” ");
INSERT INTO bdh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Zɨ́ye nda ówoyéme a kɨ́dí uku ené gáa ba ledre gɨ ro ambata wá, uku yị́ ené ledre bɨsinyí ꞌdódo ledre ꞌbɨ Farụsáyo e kɨ́ Sadụkáyo e. ");
INSERT INTO bdh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sɨmɨ bɨ Yésụ nderéogụnɨ́ gbóo kɨ́ gara bɨ Kayisaríya Phị́lịpo ní, zɨ́a ndúꞌyú ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “ꞌYị e ndịsịnɨ́ sómụ́ a kɨ́dí, Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ náambi?” ");
INSERT INTO bdh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ngíti géyị ꞌyị e ya nɨ Yiwáni ꞌyị Bábátị́zị́ ꞌyị e, ngíti géyị ya nɨ Ilíya, ngíti géyị ya nɨ Yeremáya, togụ́ wá, nɨ ngúru nébị e.” ");
INSERT INTO bdh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Zɨ́a ndúꞌyúlúgu yée kɨ́dí, “Sara sómụ́sé ꞌbɨ esé kɨ́dí mááyí náambi?” ");
INSERT INTO bdh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simúna Pétero ya zɨ́a ní, “Áyí Kɨ́résịto, Owụ́ ꞌbɨ Lomo bɨ nɨ trịdrị ní.” ");
INSERT INTO bdh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yésụ ya zɨ́a ní, “Simúna wotị́ Yóna, Lomo iꞌbí úndru go zɨ́yị. ꞌYịmaꞌdí ukuiꞌbí ené ledre née zɨ́yị ne wá, Babá bɨ komo ere ní ukuiꞌbí ne. ");
INSERT INTO bdh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Máúku zɨ́yị, ịrịyị́ nɨ karaba go Pétero, ledre gɨ sɨmɨ a kɨ́dí, ‘Landa.’ Mááyí óto sị́ ꞌdị́cị́ amá doa. Umbu utúasá ndụ́rụ ꞌdị́cị́ máa née wá. ");
INSERT INTO bdh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mááyí íꞌbí rokoꞌbụ bɨ gɨ ꞌbe ꞌbɨ Lomo komo ere ní zɨ́yị. Éyị́ bɨ ási go gɨ roa ní, Lomo nɨ kpá ási gɨ roa gɨ komo ere. Éyị́ bɨ ṇgúṇgu ledre a go ní, Lomo nɨ kpá ṇgúṇgu a.” ");
INSERT INTO bdh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nda gɨ ore zɨ́a ésị sị́lị́ne komo ꞌyị lódụ́ kacɨ́ne e kɨ́dí ndanɨ́ aka úku ꞌdódo a bɨ ya née nɨ Kɨ́résịto ní zɨ́ ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ndị́sịné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, nɨ mɨútúásáne zɨ́ne ndéréne sɨmɨ Yerụsaléma. Gɨ ro zɨ́ mɨngburoko ꞌyị e, manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní kɨ́ ꞌyị ꞌdódo lorụ e ꞌdóꞌdo née, zɨ́ye úfu née, sɨmɨ sị́lị́ ota zɨ́ne úrúne. ");
INSERT INTO bdh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Zɨ́ Pétero ndólo wo sogo éyị́ úku ledre zɨ́a kɨ́dí, “Ngére Lomo, ndá ótoómo ledre née zɨ́a méngị roné zɨ́yị wá.” ");
INSERT INTO bdh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Ịnyị gɨ romá íri, áyí zɨ́ma go káa zɨ́ tutú bɨ toro ꞌdụtụ mɨsiꞌdi ní, sómụ́ ledre eyị́ ndaá ꞌbɨ Lomo wá, yị́ ené ꞌbɨ Satána.” ");
INSERT INTO bdh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nda gɨ ore zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Togụ́ ꞌyị ili ídí ꞌyị lódụ́ kacɨ́ma yá, ídí ótoómo kɨ́ méngị ꞌbɨ ené ledre bɨ ili ne ní, zɨ́a ị́mbị́ mɨngbúngbu kágá ené ꞌbɨ ꞌdoꞌdó lódụ́ máa. ");
INSERT INTO bdh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Togụ́ ꞌyị íli bándá trịdrịné kɨ́ roné, zɨ́a úyuné. Togụ́ iꞌbí roné zɨ́ umbu gɨ romá yá, zɨ́a ndíki trịdrị. ");
INSERT INTO bdh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wo be ꞌdi emene, zɨ́ ꞌyị ídíne kɨ́ éyị́ ga bɨ do sogo káṇgá mbá zɨ́ne, zɨ́a úyuné mɨúyu? Sara togụ́ uyu go ní, éyị́ nɨ bo nɨ íꞌbí a zɨ́ Lomo gɨ ro íꞌbílúgu trịdrị zɨ́a? ");
INSERT INTO bdh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ sɨmɨ rokoꞌbụ ꞌbɨ ꞌBụné gɨ komo ere kɨ́ maláyika e, zɨ́a íꞌbí tákpásị́lị́ zɨ́ ꞌyịmaꞌdí e kacɨ́ mɨméngị ledre eyé. ");
INSERT INTO bdh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Máúku zɨ́se, ngíti géyị ꞌyị e gɨ dongaráse ga bɨ ásé tóro née, utúasánɨ́ aka úyu wá, nɨyí lúrú Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ndáꞌbaógụ ídíne Ngére kí.” ");
INSERT INTO bdh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sị́lị́ ịnyị doa kéṛị́ (6) gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ꞌdíꞌbi Pétero e kɨ́ Yakóbo nda Yiwáni owụ́ lúndu Yakóbo, yée ota zɨ́ye ndéré ékị́ ndị́sịyé do landa ngúcuyé. ");
INSERT INTO bdh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Zɨ́ toso Yésụ óyólóꞌbó roné zɨ́ye do landa íri. Zɨ́ sɨmɨ komoa ndị́sị ndícíne káa zɨ́ sụ́lụ́ kadra ní, zɨ́ bongó bɨ ro a ní ényị́ne kpɨ́lélé káa zɨ́ bimɨóṇgó ní. ");
INSERT INTO bdh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tɨ́ do komoyé née, zɨ́ Ilíya e kɨ́ Mụ́sa ógụyé zɨ́ye ndị́sị ódroyé kɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Zɨ́ Pétero úku ledre zɨ́ Yésụ kɨ́dí, “Ngére, utúasá mɨútúásá zɨ́ze ndị́sịzé ona. Togụ́ ṇgúṇgu go yá, mááyí lágá kụ́tụ́ e ota (3) kɨ́ra, kị́éꞌdo zɨ́yị, kị́éꞌdo zɨ́ Mụ́sa ngíti a zɨ́ Ilíya.” ");
INSERT INTO bdh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sɨmɨ bɨ nɨ aka ngbụ́rụ́ ndị́sị úku ledre née ní, zɨ́ bɨkenyị́ bụṛụngụ́ ógụné kụụ káa zɨ́ cika ní sólụ yée yeré. Zɨ́ kúrú ꞌyị ówụ́ne kpụrụ́ gɨ sɨmɨ bụṛụngụ́ gɨrí kɨ́dí, “Ba Owụ́ ꞌbɨ amá, ꞌbúa ofụ domá go, mááyí kɨ́ rokinyi gɨ zɨ́a. Ídísé úwú ledre gɨ taraa.” ");
INSERT INTO bdh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ga uwúnɨ́ ledre née kenée ní, zɨ́ ngịrị útúne sɨmɨyé zɨ́ye útú lóꞌbụ komoyé bi. ");
INSERT INTO bdh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tɨ́ lá zɨ́ Yésụ ógụné óto sị́lị́ne royé úku ledre zɨ́ye kɨ́dí, “Ndásé éré ngịrị wá, ị́nyịógụsé mu ꞌdága.” ");
INSERT INTO bdh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sɨmɨ bɨ sịkpịnɨ́ doyé ꞌdága ní, lurúndikinɨ́ ngíti ꞌyị wá lá dụụ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kɨ́ ndítíógụyé gɨ do landa gɨrí, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ndásé aka úku ledre ga bɨ gáa lúrúsé née zɨ́ ngíti géyị ꞌyị e wá ꞌbúó togụ́ lúrúsé Owụ́ ꞌbɨ ꞌYịmaꞌdí urú go gɨ sɨmɨ umbu.” ");
INSERT INTO bdh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née úku ledre zɨ́a kɨ́dí, “Sara éyị́ bɨ ꞌyị ꞌdódo lorụ ukunɨ́ ledre gɨ zɨ́a kɨ́dí, Ilíya nɨ ndáꞌbaógụ ụ́tụ roné fị ne gɨ zɨ́a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Maꞌdíi, Ilíya nɨ ógụụ́tụ roné ne zɨ́a ótoyéme éyị́ e za mbá do mɨsiꞌdiyé? ");
INSERT INTO bdh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Máúku zɨ́se Ilíya ogụ yị́ ené tɨ́ go, tɨ́ lá mɨngburoko ꞌyị e ilinɨ́ eyé ꞌdíꞌbi wo sɨmɨ sụmụ wá, mengịnɨ́ nda yị́ eyé wo bɨsinyíne. Nɨyí ógụ méngị lárá Owụ́ ꞌbɨ ꞌYịmaꞌdí kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zɨ́ ꞌyị lódụ́ kacɨ́ga ówo a kɨ́dí uku née ledre Yiwáni Babatị́za. ");
INSERT INTO bdh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sɨmɨ bɨ ogụnɨ́ nda go dongará tụ́ꞌdụ́ ꞌyị e ní, zɨ́ ngíti oꞌdo ógụné útúne sị́ sịndị́ Yésụ úku ledre zɨ́a kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ngére ídí ówo ledre kɨ́ wotị́ma,” nɨ kɨ́ dokéké sɨmɨné, ndịsị nda ꞌdóꞌdó gɨ zɨ́a go kɨ́ngaya. Ndịsị kɨ́ lálaónzó wo ku phoꞌdụ kpá sɨmɨ iní. ");
INSERT INTO bdh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Máꞌdíꞌbiógụ gáa wo zɨ́ ꞌyị lódụ́ kacɨ́yị ga ba, tɨ́ lá utúasánɨ́ eyé sáká wo wá. ");
INSERT INTO bdh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zɨ́ Yésụ ị́nyịné úku ledre zɨ́ye kɨ́ ꞌyị ga bɨ ore ní mbá kɨ́dí, “Dosé orụ go kɨ́ngaya gɨ ro zɨ́se ṇgúṇgu ledremá. Máídí ndị́sị zɨ́se ona gị kɨ́ be ꞌdi? Máídí ụ́tụsɨmɨmá zɨ́ze ndị́sị kése kenée gị kɨ́ be ꞌdi? Ógụsé kɨ́ owụ́oꞌdo née gɨrí mu yána.” ");
INSERT INTO bdh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sɨmɨ bɨ ogụnɨ́ kɨ́ owụ́oꞌdo née ní ní, zɨ́ Yésụ ódroné zɨ́ dokéké née kɨ́ rokoꞌbụné, geré zɨ́a ólụ́ógụné gɨ sɨmɨ owụ́oꞌdo née zɨ́ roa émené cịkị ore. ");
INSERT INTO bdh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ógụyé ndúꞌyú wo sɨmɨ bɨ nɨ ngúcuné ní kɨ́dí, “Éyị́ bɨ utúasázé lágaóyó dokéké née gɨ zɨ́a wá ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Yị́ ené gɨ zɨ́a bɨ ṇgúṇgu ledre esé nɨ cúkuꞌdée ní. Abú ṇgúṇgu ledre esé nɨ cúkuꞌdée káa zɨ́ kúfú musɨtáda, ásé úku ledre zɨ́ mongụ́ landa bɨ ꞌdáa kɨ́dí, ‘Ị́nyị mu ꞌdáꞌba,’ nɨ tɨ́ ị́nyị gɨ ore. Máúku zɨ́se, éyị́ bɨ nɨ órụ zɨ́se ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Zɨ́a kpá úku ledre zɨ́ye kɨ́dí, “Dokéké e káa zɨ́ ga gére née ásé lágáóyó yée gɨ sɨmɨ ꞌyị ꞌbúó togụ́ ínisé ini kɨ́ órụ́ rosé zɨ́ Lomo kí.” ");
INSERT INTO bdh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yésụ ogụnɨ́ go mbá ndro sɨmɨ Galiláya ní, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Sịndị́ kadra nɨ go gbóo gɨ ro do íꞌbí ngbángá Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ ezeokóga. ");
INSERT INTO bdh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zɨ́ye úfu wo, nda sɨmɨ sị́lị́ ota zɨ́a úrú ené.” Zɨ́ ledre née íꞌbí lerị́ ro ꞌyị lódụ́ kacɨ́ga mbá. ");
INSERT INTO bdh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gɨ kacɨ́ bɨ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e nderéogụnɨ́ sɨmɨ gara bɨ Kapáranawúma ní, zɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ ga bɨ ꞌbɨ ꞌDị́cị́ ꞌbɨ Lomo ní ógụyé ndúꞌyú Pétero kɨ́dí, “Mongụ́ ꞌyị esé íꞌbí ụsórụ ꞌbɨ ꞌDị́cị́ ꞌbɨ Lomo bú?” ");
INSERT INTO bdh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pétero ya zɨ́ye ní, “Ɨɨ iꞌbí bú.” Sɨmɨ bɨ nderéogụnɨ́ nda go ꞌbe ní, zɨ́ Yésụ ndúꞌyú Pétero kɨ́dí, “Simúna, sɨmɨ sómụ́ ledre eyị́ ní, ngére ga bɨ do sogo káṇgá ba ndịsịnɨ́ ꞌdóꞌdụ́ ụsórụ akpa gɨ zɨ́ ꞌyị eyé e, togụ́ mbú gɨ zɨ́ ꞌyị lóṇgó e?” ");
INSERT INTO bdh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Zɨ́ Pétero úkulúgu ledre kɨ́dí, “Ndịsịnɨ́ ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị lóṇgó e.” Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “ꞌYị eyé e ndanɨ́ kɨ́ ledre wá. ");
INSERT INTO bdh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tɨ́ lá ilizé ezé zɨ́ mɨmbéꞌdeyé ésị́ne rozé wá, ndéré mu ngbuṛu ị́kpị́ iní, mɨzefị kénzé bɨ áyí ị́kpị́ógụ a ní, ídí líkpí taraa, áyí ndíki késị́ ku a, zɨ́yị ꞌdíꞌbi a ndéré íꞌbí a káa do ụsórụ gɨ rozé kéyị.” ");
INSERT INTO bdh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sɨmɨ sịndị́ kadra máa née ní, zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ógụyé ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, ambí nɨ karanée ídí ne mongụ́ ꞌyị ꞌbe ꞌbɨ Lomo komo ere zɨ́ lafúne e mbá?” ");
INSERT INTO bdh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zɨ́ Yésụ ndóloógụ owụ́ tóroné dongará ꞌyị e kɨ́rɨ́ née. ");
INSERT INTO bdh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Zɨ́a úku ledre gɨ ro owụ́ née kɨ́dí, “Máúku zɨ́se maꞌdíi, togụ́ ótosé rosé ndoo káa zɨ́ mɨnzéré owụ́ e wá, útúásásé ógụ ꞌbe ꞌbɨ Lomo komo ere wá. ");
INSERT INTO bdh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bɨ go kenée ní, ꞌyị bɨ ꞌboꞌbụ́ roné go káa zɨ́ owụ́ ba ní ní, nɨ go ne mongụ́ ꞌyị ꞌbe ꞌbɨ Lomo ꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kpá kenée, togụ́ ꞌyị ꞌdiꞌbi owụ́ bɨ cúkuꞌdée káa zɨ́ wo ba sɨmɨ sụmụ, kɨ́dí ꞌdíꞌbi née go kpá máa. ");
INSERT INTO bdh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ꞌYị bɨ ṇguṇgu ledremá abú nɨ aka lá cúkuꞌdée káa zɨ́ owụ́ ba, zɨ́ ngíti ꞌyị ógụné lóndo wo zɨ́a lúyú ledre yá, nɨ ídí bɨlámáne togụ́ odónɨ́ káꞌdá ro goa, do odóngeṛị wo kɨ́e ro tutú do ụ́cụ wo kɨ́e bu sɨmɨ mongụ́ kụ́lụ́. ");
INSERT INTO bdh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Mongụ́ nduwú nɨ ídí zɨ́ ꞌyị ga bɨ nɨyí ndị́sị lóndo ꞌyị e zɨ́ye lúyú ledre ní. Maꞌdíi, ngíti géyị ꞌyị e nɨyí ídí ꞌyị lóndo ꞌyị e. ꞌYị máa ga gére ní, Lomo nɨ ꞌdóꞌdo yée bɨsinyíne kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Togụ́ lúrú ngíti sị́lị́yị togụ́ mbú ngíti sịndị́yị ayí óto yị́ị zɨ́yị lúyú ledre yá, ídí óṇgoóyó a ꞌdáꞌba. Nɨ bɨlámáne zɨ́yị ndíki trịdrị bɨ za fí ní kɨ́ sịndị́yị kị́éꞌdo gɨ zɨ́ wo bɨ áyí ídí kɨ́ sịndị́yị togụ́ mbú sị́lị́yị gbrengárá do ụ́cụ yị́ị nyé sɨmɨ mongụ́ gu phoꞌdụ bɨ ịlị́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Togụ́ ngúru komoyị́ ayí óto yị́ị zɨ́yị lúyú ledre yá, ídí cígíóyó a ꞌdáꞌba. Nɨ bɨlámáne zɨ́yị ndíki trịdrị bɨ za fí ní kɨ́ komoyị́ kị́éꞌdo gɨ zɨ́ wo bɨ áyí ídí kɨ́ komoyị́ gbrengárá do ụ́cụ yị́ị nyé sɨmɨ mongụ́ gu phoꞌdụ bɨ ịlị́ wá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ídísé ówo a kɨ́dí, ꞌyị ndaá lúrú cáyi ꞌyị gɨ dongará mɨnzéré owụ́ ga ba wá. Máúku zɨ́se maꞌdíi, maláyika ga bɨ ndịsịnɨ́ ndị́sị kɨ́ Babá komo ere ní, nɨyí íꞌbí ngbángá ꞌyị máa née zɨ́ Babá. ");
INSERT INTO bdh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Babá kasaogụ máa yómo ꞌyị lúyú ledre e. ");
INSERT INTO bdh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sómụ́sé ꞌbɨ esé káa be ꞌdi? Togụ́ ꞌyị nɨ kɨ́ kábịṛị́kị e zɨ́ne míya zɨ́ kémbị́ a ị́ndrịné ní, mị́ngị́ a utúasá ótoómo yée ga bɨ cị́ eso doa sokó doa ịnyị doa eso (99) née zɨ́a ndéréne gámásóꞌdo wo bɨ ịndrị née wá? ");
INSERT INTO bdh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sɨmɨ bɨ togụ́ ndiki go ní, máúku zɨ́se maꞌdíi, nɨ ídí kɨ́ mongụ́ rokinyi gɨ roa kɨ́ngaya rómo do yée ga bɨ cị́ eso doa sokó doa ịnyị doa eso (99) ngárá ịndrịnɨ́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kpá kenée ꞌBụsé Lomo bɨ komo ere ní, ili ené zɨ́ bɨkéṛị́ owụ́ ị́ndrịné gɨ dongará lafúne wá.” ");
INSERT INTO bdh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Togụ́ ezeyị́ bɨ ṇguṇgu ledremá go ní luyú ledre royị́ yá, ídí ndéré úku ꞌdódo luyú ené née zɨ́a sɨmɨ bɨ ásé lá gbre kéne ní. Togụ́ ṇguṇgu go yá, yéme dongaráse go kéne. ");
INSERT INTO bdh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Togụ́ ili ené ṇgúṇgu a wá, ídí ndólo ꞌyị kị́éꞌdo togụ́ mbú gbre zɨ́se ídíse kéye, ‘Gɨ ro ledre ga bɨ za mbá ásé ótoyéme yée dongará ꞌyị kɨ́ ezené ní idí ídí do komo ꞌyị e gbre togụ́ mbú ota (3).’ ");
INSERT INTO bdh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Togụ́ ili ené kpá úwú ledre gɨ tara ꞌyị ga gére née wá, zɨ́yị ndéré kɨ́e zɨ́ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní zɨ́ye ódroyé zɨ́a. Togụ́ íli kpá fú wá, ídísé ási gɨ roa káa zɨ́ ꞌyị bɨ ngárá ṇgúṇgu aka ledre ꞌbɨ Lomo wá ní, togụ́ mbú ꞌyị ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Máúku zɨ́se maꞌdíi, ledre bɨ tórosé go doa do sogo káṇgá ona ní, Lomo bɨ komo ere ní toro kpá go doa kenée. Wo bɨ ásisé go gɨ roa ní Lomo bɨ komo ere nɨ kpá ási gɨ roa kenée. ");
INSERT INTO bdh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mááyí go kpá úku ándá a zɨ́se, togụ́ ꞌyị e gbre gɨ dongaráse do sogo káṇgá ona otonɨ́ sómụ́ ledre eyé go kị́éꞌdo ndúꞌyú Lomo gɨ ro éyị́ bɨ ilinɨ́ ní, Babá Lomo bɨ komo ere ní nɨ íꞌbí a zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nɨ kenée maꞌdíi, togụ́ ꞌyị e gbre togụ́ mbú ota yokonɨ́ royé íni ini gɨ zɨ́a bɨ nɨyí ꞌyị amá e ní, mááyí ídí dongaráye.” ");
INSERT INTO bdh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Zɨ́ Pétero ógụné zɨ́ Yésụ do ndúꞌyú wo kɨ́dí, “Ngére, togụ́ ezemá ndịsị lúyú ledre romá ní, máídí ótoómo ledre zɨ́a kɨ́ꞌdí ndu? Kɨ́ꞌdí ịnyị doa gbre?” ");
INSERT INTO bdh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yésụ ya zɨ́a ní, “Ɨ́ꞌɨ, ndaá lá kɨ́ꞌdí ịnyị doa gbre (7) wá, idí ídí kɨ́ꞌdí cị́ ota doa sokó doa ịnyị doa gbre (77).” ");
INSERT INTO bdh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bɨ kenée ní, ledre gɨ ro ꞌbe ꞌbɨ Lomo nɨ cé káa zɨ́ ngére bɨ kóo ꞌyị moko ené e ꞌdiꞌbinɨ́ késị́ gɨ zɨ́a ili nda go zɨ́ye íꞌbílúgu a ní. ");
INSERT INTO bdh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Káa zɨ́ bɨ mongụ́ ꞌyị nɨ go tónó ótoyéme ledre ga gére née ní, zɨ́ye ꞌdíꞌbiógụ ngúru ꞌyị ꞌbɨ moko bɨ kóo ꞌdiꞌbi tụ́ꞌdụ́ késị́ ené ní kóꞌdụ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gɨ zɨ́a bɨ rokoꞌbụ bɨ zɨ́ ꞌyị moko née íꞌbílúgu mongụ́ késị́ née kɨ́e ndaá ní, mongụ́ ꞌyị ené ya kɨ́dí togụ́ kenée yá, idínɨ́ ꞌdíꞌbi wo kɨ́ meꞌbea kɨ́ owụ́ ꞌbɨ ené e nda kɨ́ éyị́ ga bɨ zɨ́a ní mbá úgúóyó yée ꞌdáꞌba gɨ ro do íꞌbílúgu késị́ ené née. ");
INSERT INTO bdh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Zɨ́ ꞌyị moko née útúne do ngụ́ṛụ́ sịndị́ne kóꞌdụ́ mongụ́ ꞌyị ené ṇgúṇgú roné zɨ́a kɨ́dí, ‘Áko mongụ́ ꞌyị, ótoómo ledre zɨ́ma, mááyí íꞌbílúgu késị́ née mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Zɨ́ lerị́a méngị mongụ́ ꞌyị née zɨ́a ótoómo ledre zɨ́a kɨ́dí ndá lolụ íꞌbílúgu késị́ née wá. ");
INSERT INTO bdh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tɨ́ lá bɨ ị́nyị gɨ ore ndéréne ní, zɨ́a ówo ngúru ezené ꞌyị moko bɨ kóo ꞌdiꞌbi késị́ gɨ zɨ́a kpá lá cúkuꞌdée ní. Zɨ́a útúne doa geré ꞌdíꞌbi kúrúa ngị́rị kɨ́dí, ‘Íꞌbílúgu késị́ amá bɨ zɨ́yị ní mu.’ ");
INSERT INTO bdh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Zɨ́ eze a née útúne do ngụ́ṛụ́ sịndị́ne ṇgúṇgú roné zɨ́a kɨ́dí, ‘Áko, ótoómo ledre zɨ́ma, mááyí íꞌbílúgu késị́ née mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Eze moko a née asi yị́ ené mɨási. Sɨmɨ ledre née ní, zɨ́a lála wo ndéré kɨ́e sɨmɨ sị́gịnị. Zɨ́ eze a née ndị́sịné íri gị do íꞌbíónzó késị́ ené née té kí. ");
INSERT INTO bdh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sɨmɨ bɨ lafúga ꞌyị ꞌbɨ moko e lurúnɨ́ ledre bɨ mengị kɨ́ ezené née ní, zɨ́a sínyíne royé kɨ́ngaya do ndéréye úku ꞌdódo ledre ga bɨ mengịnɨ́ royé née ní mbá zɨ́ mongụ́ ꞌyị eyé. ");
INSERT INTO bdh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Zɨ́ mongụ́ ꞌyị née ndólo ꞌyị ꞌbɨ moko née do úku ledre zɨ́a kɨ́dí, ‘Áyí bɨsinyí ꞌyị, Máótoómo kóo tụ́ꞌdụ́ késị́ amá bɨ kacɨ́yị gɨ zɨ́a ṇgúṇgú royị́ kɨ́dí máídí ótoómo ledre zɨ́yị ní. ");
INSERT INTO bdh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Útúásá eyị́ ótoómo ledre zɨ́ ezeyị́ née káa zɨ́ bɨ kóo máótoómo ledre zɨ́yị ní wá?’ ");
INSERT INTO bdh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gɨ zɨ́ sɨmɨkesị́, zɨ́ mongụ́ ꞌyị ené ꞌdíꞌbi a ndéré kɨ́e sɨmɨ sị́gịnị do ndị́sị ꞌdóꞌdo wo gị zɨ́a íꞌbílúgu késị́ bɨ kóo ꞌdiꞌbi ní za mbá kí. ");
INSERT INTO bdh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Née ledre bɨ Babá gɨ komo ere nɨ méngị a zɨ́se ní, ꞌbúó togụ́ ótoómosé ledre go zɨ́ lafúse gɨ yana mɨmbéꞌdesé.” ");
INSERT INTO bdh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sɨmɨ bɨ Yésụ ꞌdódo asá ledre née ní, zɨ́a ị́nyịné gɨ sɨmɨ Galiláya ndéréne sága ngbuṛu bɨ Yeredéne sɨmɨ káṇgá bɨ Yụdáya ní. ");
INSERT INTO bdh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zɨ́ tụ́ꞌdụ́ ꞌyị e lódụ́ wo íri, zɨ́a ndị́sịné yómo yée ga bɨ kɨ́ ndíyá royé ní. ");
INSERT INTO bdh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Zɨ́ ngíti géyị Farụsáyo e ógụyé úzu Yésụ kɨ́ nduꞌyú kɨ́dí, “Nɨ mɨútúásáne zɨ́ ꞌyị ótoómo meꞌbené tɨ́ lá gɨ ro owụ́ ledre bɨ nɨ bo ní?” ");
INSERT INTO bdh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ólosé esé mɨéké kúrú Lomo wá? Kú gɨ dosị́ne Lomo ‘otoogụ ꞌyịmaꞌdí e oꞌdo kɨ́ kára,’ ");
INSERT INTO bdh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Née kpá sị́ ledre bɨ oꞌdo nɨ ótoómo ꞌbụné kɨ́ mbágáne kenée zɨ́a ófụ́ kára zɨ́ye ódó royé kɨ́ meꞌbené ídíye éyị́ kị́éꞌdo ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gɨ ore, ndanɨ́ lolụ ꞌyị e gbre wá, nɨyí goó éyị́ kị́éꞌdo. Bɨ kenée ní, éyị́ bɨ Lomo kótrụ go ní, ꞌyịmaꞌdí ndaá báyi a wá.” ");
INSERT INTO bdh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Zɨ́ye ndúꞌyú Yésụ kɨ́dí, “Togụ́ kenée maꞌdíi ní, sara Mụ́sa eké nda kóo kɨ́dí ꞌyị idí íꞌbí wáraga ꞌbɨ ótoómo roꞌyị zɨ́ kára máa née zɨ́a ndéréne kɨ́e gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yésụ ya zɨ́ye ní, “Mụ́sa eké kóo ledre née zɨ́se Yụ́da e kenée gɨ ro zɨ́se ótoómo meꞌbesé e gɨ zɨ́a dosé orụ mɨórụ. Tɨ́ lá ndaá ꞌbɨ ené kóo mɨyémené kenée gɨ dosị́ne wá. ");
INSERT INTO bdh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Máúku zɨ́se, togụ́ meꞌbeyị́ soꞌdo ené oꞌdo ꞌdí sogo wá, zɨ́yị ótoómo wo zɨ́yị ndéréyị ófụ́ ngíti kára yá, lúyú ledre go, gɨ zɨ́a sóꞌdo née go royị́ ꞌdí sogo.” ");
INSERT INTO bdh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ꞌYị lódụ́ kacɨ́ga ya zɨ́a ní, “Togụ́ ledre nɨ nda yị́ ené gɨ ro oꞌdo kɨ́ kára goó kenée yá, nɨ bɨlámáne ꞌyị ndaá ꞌbɨ ené lolụ ófụ́ kára wá.” ");
INSERT INTO bdh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yésụ ya zɨ́ye ní, “Tụ́ꞌdụ́ ꞌyị e utúasánɨ́ ꞌdíꞌbi ꞌdódo ledre née wá, tɨ́ lá dụụ́ yée ga bɨ utúasánɨ́ go ndị́sị ngúcuyé ní. ");
INSERT INTO bdh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngíti géyị utúasánɨ́ ꞌdíꞌbi kará e wá gɨ zɨ́a aránɨ́ yị́ eyé yée kú kenée. Ngíti géyị, ꞌyị e mengịnɨ́ yée ye. Ngíti géyị asinɨ́ yị́ eyé kú ye gɨ zɨ́a bɨ iꞌbínɨ́ royé go méngị dụụ́ moko bɨ ꞌbe ꞌbɨ Lomo komo ere ní. ꞌYị bɨ utúasá go ṇgúṇgu ledre née ní, zɨ́a ṇgúṇgu a.” ");
INSERT INTO bdh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nda gɨ ore zɨ́ ngíti géyị ꞌyị e ógụyé kɨ́ mɨnzéré owụ́ e zɨ́ Yésụ íni ini doyé kpá kɨ́ íꞌbí úndru zɨ́ye. Tɨ́ lá zɨ́ ꞌyị lódụ́ kacɨ́ga ndị́sịyé ụ́cụómo ꞌyị ga bɨ ogụnɨ́ kɨ́ owụ́ ga gére ní. ");
INSERT INTO bdh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ótoómosé mɨnzéré owụ́ ga gére née zɨ́ye ógụyé zɨ́ma. Ndásé ụ́cụómo yée wá, ꞌBe ꞌbɨ Babá bɨ komo ere ní, nɨ gɨ ro ꞌyị ga bɨ káa zɨ́ mɨnzéré owụ́ e ní.” ");
INSERT INTO bdh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sɨmɨ bɨ Yésụ ini ini go zɨ́ Lomo idí íꞌbí úndru zɨ́ owụ́ ga gére ní, zɨ́a ndéréókpóne gɨ ore. ");
INSERT INTO bdh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nda née ní, zɨ́ ngíti owụ́phɨṛangá ógụné ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, bɨlámá ledre bɨ máídí méngị a gɨ ro zɨ́ma ndíki trịdrị bɨ za fí ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yésụ ya zɨ́a ní, “Ndúꞌyú máa gɨ ro bɨlámá ledre gɨ ro ꞌdi? Lomo nɨ dụụ́ ne bɨlámáne. Togụ́ íli trịdrị bɨ za fí ní yá, ídí lódụ́ lorụ ga bɨ Lomo uku yée ní.” ");
INSERT INTO bdh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zɨ́ phɨṛangá née ndúꞌyú ándá wo kɨ́dí, “Lorụ ga bɨ káa zɨ́ yée ga be ꞌdi?” Yésụ ya zɨ́a ní, lorụ ga bɨ káa zɨ́, “ ‘Ndá úfu ꞌyị wá, ndásé sóꞌdo rosé kɨ́ ꞌyị bɨ ófụ́sé rosé kéne wá ní wá, ndá úgu ugu wá, ndá ṛáṛanga wá, ");
INSERT INTO bdh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ídí óto úndru ꞌbụyị́ kɨ́ mbágáyị,’ zɨ́yị ‘óto ꞌbú lafúyị e káa zɨ́ bɨ óto ꞌbúyị kɨ́ royị́ ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Owụ́phɨṛangá née ya zɨ́a ní, “Óo, lorụ ga gére née máméngị yée go mbá kenée. Ngítí a bɨ idíaká ní nda go ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zɨ́ Yésụ úkulúgu a zɨ́a kɨ́dí, “Togụ́ íli méngị zaá maꞌdíi ledre yá, ídí ndéré úgúóyó éyị́ eyị́ e gɨ ꞌbe mbá ꞌdáꞌba. Zɨ́yị íꞌbíóyó késị́ye zɨ́ ꞌyị lerị́ e, gɨ ore zɨ́yị nda ndáꞌbaógụyị́ lódụ́ máa. Lomo nɨ íꞌbí mongụ́ úndru zɨ́yị komo ere.” ");
INSERT INTO bdh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sɨmɨ bɨ owụ́phɨṛangá née uwú ledre bɨ Yésụ uku zɨ́a kenée ní, zɨ́ bi sínyíne roa gbála. Zɨ́a ókpóne gɨ ore kɨ́ do komoné bɨsinyíne gɨ zɨ́a nɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Máúku zɨ́se maꞌdíi, nɨ mɨórụné kɨ́ngaya zɨ́ ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní ógụné ꞌbe ꞌbɨ Lomo komo ere. ");
INSERT INTO bdh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mááyí kpá úku a zɨ́se kɨ́dí, ndaá mɨórụné zɨ́ mongụ́ bangá bɨ gémele ní ólụ́ phụ́trụ bi gɨ sɨmɨ gu lị́bịra wá, nda zɨ́ ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní, nɨ mɨórụné kɨ́ngaya zɨ́a ólụ́ne ꞌbe ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yésụ uwúnɨ́ ledre née kenée ní, zɨ́ye ónzó komoyé kɨ́ngaya, zɨ́ye úku ledre kɨ́dí, “Ambí nɨ nda ómo goó ne?” ");
INSERT INTO bdh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zɨ́ Yésụ lúrú yée gbóó, zɨ́a úku ledre kɨ́dí, “Éyị́ bɨ ꞌyịmaꞌdí utúasá méngị a wá ní, Lomo utúasá yị́ ené bú méngị a.” ");
INSERT INTO bdh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Zɨ́ Pétero úkulúgu ledre zɨ́a kɨ́dí, “Sara aka nda zée ga bɨ otoomozé ꞌbɨ ezé éyị́ e go mbá zɨ́ze ndị́sịzé lódụ́ go lá dụụ́ yị́ị ní, ꞌbɨ ezé nɨ nda ídí ꞌbɨ ené go ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, sɨmɨ bɨ karanée ledre e nɨyí oyóloꞌbó royé mbá mɨkándayé ní, zɨ́ Owụ́ ꞌbɨ ꞌYịmaꞌdí ídíne goó mɨndị́sịné do kị́tị ngére ené kɨ́ mongụ́ rokoꞌbụné ní, sée ga bɨ ásé ꞌyị lódụ́ kacɨ́ma e ba ní, ásé ídí kpá mɨndị́sịsé do kị́tị ngére zɨ́se ndị́sịsé ꞌdécị ngbanga Isɨréle e kacɨ́ sị́ doyé ga bɨ sokó doa gbre née mbá. ");
INSERT INTO bdh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ꞌYị ga bɨ otoomonɨ́ éyị́ eyé e za mbá, ꞌbe ꞌbɨ eyé e, lúnduyé e, lémịyé e, ꞌbụyé e kɨ́ mbágáye e, kɨ́ owụ́ ꞌbɨ eyé e gɨ ro lódụ́ kacɨ́ma ní, Lomo nɨ íꞌbí tụ́ꞌdụ́ éyị́ e zɨ́ye, kpá kɨ́ trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tɨ́ lá tụ́ꞌdụ́ ꞌyị máa yée ga bɨ cakaba nɨyí zɨ́ lafúye ꞌdáꞌdá ní, nɨyí karanée ídí ꞌdáꞌba. Tụ́ꞌdụ́ ꞌyị máa yée ga bɨ nɨyí ꞌdáꞌba nɨyí karanée ídí ꞌdáꞌdá.” ");
INSERT INTO bdh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zɨ́ Yésụ tónóne úku muruwayi kɨ́dí, “Ledre gɨ ro ꞌbe ꞌbɨ Lomo komo ere nɨ káa zɨ́ mị́ngị́ yáká bɨ nderé ndólo ꞌyị e gɨ ro ógụyé méngị moko késị́ sɨmɨ yáká ené ní. ");
INSERT INTO bdh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sɨmɨ bɨ ꞌyị ga gére née odónɨ́ sómụ́ ledre go kɨ́ mị́ngị́ yáká ní, zɨ́a kása yée kɨ́dí nderénɨ́ mu méngị moko sɨmɨ yáká ené. ");
INSERT INTO bdh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Sɨmɨ sịndị́ kadra ịnyị doa eso (9), zɨ́ mị́ngị́ yáká kpá ndéréne ndíki ngíti géyị ꞌyị e mɨtóroyé sɨmɨ sụ́ụ gbékpị́ne moko ndaá royé wá. ");
INSERT INTO bdh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Zɨ́a úku ledre zɨ́ye kɨ́dí, ‘Máíli gáa sée, zɨ́se kpá ndérése méngị moko yáká amá. Mááyí íꞌbí késị́ bɨ mɨútúásáne ní zɨ́se.’ ");
INSERT INTO bdh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Zɨ́ ꞌyị ga gére née ndéréye. “Kɨ́ yana kadra nda kpá kɨ́ komo kadra tagá, zɨ́a ndéréne méngị a kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nda go za kɨ́ tagá, zɨ́a kpá ndéréne ndíki ngíti géyị ꞌyị e nɨyí mɨtóroyé. Zɨ́a úku ledre zɨ́ye kɨ́dí, ‘Éyị́ bɨ ndị́sị ónzósé kadra gbékpị́ne méngịsé moko gɨ zɨ́a wá ní ꞌdi?’ ");
INSERT INTO bdh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Zɨ́ ꞌyị ga gére née úkulúgu ledre zɨ́a kɨ́dí, ‘Gɨ zɨ́a ꞌyị bɨ zɨ́a íꞌbí moko zɨ́ze ní ndaá.’ “Zɨ́a úku ledre zɨ́ye kɨ́dí, ‘Nɨ mɨútúásáne zɨ́se ndérése méngị moko yáká amá.’ ");
INSERT INTO bdh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kɨ́ tagá a née, zɨ́ mị́ngị́ yáká úku ledre zɨ́ ꞌyị lúrú bi kacɨ́ moko ené kɨ́dí, ‘Ndólo ógụ ꞌyị ꞌbɨ moko ga bɨ yáká ꞌdáa ní mu zɨ́ye ꞌdíꞌbi késị́ eyé. Ídí tónó a kɨ́ ꞌyị ga bɨ ogụnɨ́ gɨ ꞌdáꞌba ní nda gị ro yée ga bɨ tonónɨ́ ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Zɨ́ ꞌyị ga bɨ tonónɨ́ moko kɨ́ tagá ní ógụyé ꞌdíꞌbi késị́ eyé kpá káa zɨ́ ꞌbɨ ꞌyị ga bɨ tonónɨ́ moko kɨ́ phịyị́ ní. ");
INSERT INTO bdh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nda sɨmɨ bɨ ꞌyị ga bɨ tonónɨ́ moko kɨ́ phịyị́ ogụnɨ́ ꞌdíꞌbi késị́ eyé ní, somụ́nɨ́ ꞌbɨ eyé kɨ́dí késị́ eyé nɨ ídí mongụ́ne. Nɨyí ídí kɨ́e ní, iꞌbínɨ́ zɨ́ye go kpá késị́ bɨ iꞌbínɨ́ zɨ́ ꞌyị ga bɨ tonónɨ́ moko gɨ ꞌdáꞌba ní. ");
INSERT INTO bdh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sɨmɨ bɨ ꞌdiꞌbinɨ́ késị́ née ní ní, zɨ́ye tónóye úku mɨngụ́ngụ́rụ́ ledre dongaráye ro mị́ngị́ yáká. ");
INSERT INTO bdh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Zɨ́ye úku ledre zɨ́a kɨ́dí, ‘Zée ga bɨ tonózé méngị moko kú akpa kɨ́ phịyị́ gị kɨ́ tagá ní, áyí íꞌbí késị́ zɨ́ze útúásáne kɨ́ ꞌyị ga bɨ ogụnɨ́ ꞌbɨ eyé gɨ ꞌdáꞌba ní lárá a káa be ꞌdi? Kenée ndaá bɨlámáne wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Zɨ́a úku ledre zɨ́ ngúruyé kɨ́dí, ‘Máméngị amá sée bɨsinyíne wá. Máíꞌbí zɨ́se née tɨ́ késị́ bɨ gáa ṇgúṇgusé ledre a ní. ");
INSERT INTO bdh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ꞌDíꞌbisé késị́ esé mu zɨ́se ndérése. Máíli íꞌbí zɨ́ ꞌyị ga bɨ tonónɨ́ moko kɨ́ tagá ní, kpá késị́ bɨ máíꞌbí zɨ́se née. ");
INSERT INTO bdh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Née yị́ ené késị́ amá, éyị́ bɨ máíli méngị a kɨ́e ní, mááyí méngị a. Bi sinyí rosé née gɨ zɨ́a bɨ mááyí ꞌyị méngị bɨlámá ledre zɨ́ ꞌyị e ní?’ ” ");
INSERT INTO bdh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Née ní, zɨ́ Yésụ úku ledre kɨ́dí, “ꞌYị ga bɨ ꞌdáꞌba ní nɨyí ídíye ꞌdáꞌdá. Yée ga bɨ ꞌdáꞌdá ní nɨyí ídí ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sɨmɨ bɨ Yésụ nɨ mɨndéréne sɨmɨ Yerụsaléma ní, zɨ́a ndólo ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre (12) ní sogo éyị́, zɨ́a úku ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Azé go bɨ ndéré sɨmɨ Yerụsaléma ba, ngíti géyị ꞌyị e nɨyí íꞌbí ngbángá Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní kɨ́ ꞌyị ꞌdódo lorụ e. Nɨyí ꞌdécị ngbanga a do úfu a, ");
INSERT INTO bdh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","do íꞌbí wo zɨ́ ꞌyị ga bɨ ngárá ndanɨ́ Yụ́da e wá ní, zɨ́ye fóló wo, ócó a do phéphé a do mɨngbúngbu kágá. Tɨ́ lá gɨ do kacɨ́ sị́lị́ ota (3) nɨ úrú gɨ sɨmɨ umbu.” ");
INSERT INTO bdh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gɨ ore, zɨ́ meꞌbe Zebedị́ya ꞌdíꞌbi wotị́ne ga bɨ Yakóbo e kɨ́ Yiwáni ógụ útúne kéye kóꞌdụ́ Yésụ ṇgúṇgú roné zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zɨ́ Yésụ ndúꞌyú wo kɨ́dí, “Éyị́ bɨ íli ní ꞌdi?” Kára née ya zɨ́a ní, “Kɨ́ꞌdí bɨ áyí go do Kị́tị Ngére eyị́ ní, owụ́ ꞌbɨ amá ga bɨ gbre ba ídí ꞌdíꞌbióto yée cigíyị. Ngíti a do sị́lị́yị ꞌbɨ anú ngíti a do ngelị.” ");
INSERT INTO bdh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yésụ ya zɨ́ye ní, “Ówosé esé éyị́ bɨ ásé ndúnduꞌyú gɨ roa ní wá. Útúásásé go ṇgúṇgu a zɨ́se ꞌdóꞌdóse káa zɨ́ bɨ mááyí ógụ ꞌdóꞌdó ní?” Yakóbo e kɨ́ Yiwáni ya zɨ́a ní, “Azé útúásá.” ");
INSERT INTO bdh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yésụ ya zɨ́ye ní, “Ɨɨ, ásé tɨ́ ꞌdóꞌdó. Tɨ́ lá óto ꞌyị e zɨ́ye ndị́sịyé do anú kɨ́ do ngelị ní, ndaá ꞌbɨ ené moko amá wá. Babá ndịsị yị́ ené yéme ledre máa wo née ne.” ");
INSERT INTO bdh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yésụ ga bɨ ore sokó uwúnɨ́ ledre née ní, zɨ́ mɨmbéꞌdeyé ésị́ne ro Yakóbo e kɨ́ Yiwáni kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zɨ́ Yésụ ndólo ꞌyị ené ga gére née úku ledre zɨ́ye kɨ́dí, “Ówosé bú, ngére ga bɨ do sogo káṇgá ba ndịsịnɨ́ ndị́sị do ꞌyị e kɨ́ rokoꞌbụ. Zɨ́ye ndị́sịyé méngị yée káa zɨ́ bɨ ilinɨ́ yị́ eyé ní. ");
INSERT INTO bdh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tɨ́ lá ndásé méngị kéyị kenée wá. Togụ́ ꞌyị gɨ dongaráse ili zɨ́ne ídíne ꞌdáꞌdá zɨ́ lafúne e yá, idí ídí ꞌyị ị́nyị kasa zɨ́ lafúne, ");
INSERT INTO bdh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","wo bɨ ili zɨ́ne ídíne ꞌdáꞌdá ní, idí óto roné káa do owụ́kụlụ́ zɨ́ lafúne, ");
INSERT INTO bdh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","cé káa zɨ́ bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí ogụ ené gɨ ro zɨ́ ꞌyị e ị́nyị kasa zɨ́a wá ní, yị́ ené gɨ ro ị́nyị kasa zɨ́ ꞌyị e, kpá gɨ ro íꞌbí roné zɨ́ umbu gɨ ro yómo tụ́ꞌdụ́ ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sɨmɨ bɨ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e nɨyí go ndéréókpó gɨ sɨmɨ Zérịko ní, zɨ́ tụ́ꞌdụ́ ꞌyị e lódụ́ wo. ");
INSERT INTO bdh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sɨmɨ sịndị́ kadra máa née ní, mɨkomo mɨꞌdụ́tụ e gbre mbá yaꞌdá e, nɨyí kóo mɨndị́sịyé dogboṛụ mɨsiꞌdi kenée. Sɨmɨ bɨ uwúnɨ́ ledre kɨ́dí Yésụ ndịsị ndéré née ne ní, zɨ́ye ótrụ́ ledre ꞌdága kɨ́dí, “Ngére, Bulúndu Dawídi, ídí aka lúrú lerị́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Zɨ́ tụ́ꞌdụ́ ꞌyị e ụ́cụómo yée kɨ́dí ndanɨ́ gbúrógbó wá. Tɨ́ lá gbúrógbó tatánɨ́ nda royé ꞌdáꞌdá kɨ́dí, “Ngére, Bulúndu Dawídi, ídí aka lúrú lerị́ze.” ");
INSERT INTO bdh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zɨ́ Yésụ tóroné ndólo yée, zɨ́a ndúꞌyú yée kɨ́dí, “Ílisé máídí méngị zɨ́se ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ngére, ilizé zɨ́yị líkpí komozé.” ");
INSERT INTO bdh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Zɨ́ lerị́ye méngị Yésụ. Zɨ́a óto sị́lị́ne ro komoyé, geré zɨ́ komoyé líkpíne, zɨ́ye útúye lódụ́ kacɨ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sɨmɨ bɨ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e nderéogụnɨ́ go gbóo kɨ́ Yerụsaléma zɨ́ye ógụyé sɨmɨ gara kɨ́ ịrịné Betefége do landa bɨ kɨ́ kágá ga bɨ olíva doné bɨ ndịsịnɨ́ ndólo a Landa Olíva ní, zɨ́a kásaókpó ꞌyị lódụ́ kacɨ́ne e gbre ꞌdáꞌdá, ");
INSERT INTO bdh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kɨ́dí, “Ndéréókpósé mu sɨmɨ gara íri, ásé ndéré ndíki mbágá dongí kɨ́ owụ́ ꞌbɨ ené mɨódóótoyé tara mɨsiꞌdi kenée, ídísé líkpí yée gbrengárá ógụ kɨ́ye zɨ́ma yáa. ");
INSERT INTO bdh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Togụ́ ngíti ꞌyị ayí úku ledre kɨ́dí, líkpísé bangá ga gére née gɨ ro ꞌdíya yá, ídísé úku a zɨ́a kɨ́dí Ngére ili yée ne. Nɨ geré ótoómo yée zɨ́se.” ");
INSERT INTO bdh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ledre née mengị roné go té káa zɨ́ bɨ kóo ngúru nébị eké ní, ");
INSERT INTO bdh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kɨ́dí, “Ídísé úku ledre zɨ́ nyị́ ꞌyị ga bɨ ꞌbɨ Yerụsaléma ní, ‘Lúrúsé aka, Ngére esé nɨ go ógụ zɨ́se. Nɨ ꞌyị mɨmbéꞌde kịdrị́, ndịsị ógụ gbóo do dongí, nɨ bɨ mɨndị́sịné do owụ́ dongí gɨrí née.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née ndéréye méngị tɨ́ ledre bɨ Yésụ uku zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Zɨ́ye ógụyé kɨ́ dongí ga gére née zɨ́ Yésụ, zɨ́ ngíti géyị ónzó bongó eyé e do dongí ga gére née. Zɨ́ Yésụ ékị́ ndị́sịné doyé. ");
INSERT INTO bdh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zɨ́ tụ́ꞌdụ́ ꞌyị e ízí bongó eyé e do mɨsiꞌdi, zɨ́ ngíti géyị ꞌdécị ꞌbɨ eyé mbílí tịyị́ e ízí yée do mɨsiꞌdi. ");
INSERT INTO bdh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zɨ́ tụ́ꞌdụ́ ngíti géyị ꞌyị ga bɨ utúnɨ́ zɨ́ Yésụ ꞌdáꞌdá, nda kɨ́ yée ga bɨ gɨ do kacɨ́ a ní ndị́sịyé mbófo wo kɨ́dí, “Mbófo éyị́ zɨ́ Bulúndu Dawídi.” “Úndru idí ídí zɨ́ wo bɨ ogụ kɨ́ ịrị Ngére Lomo ní.” “Mbófo éyị́ zɨ́ Lomo bɨ komo ere ní.” ");
INSERT INTO bdh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sɨmɨ bɨ Yésụ olụ́ sɨmɨ Yerụsaléma ní, zɨ́ bi kị́zịné mɨkị́zị gɨ zɨ́ ꞌyị e. Zɨ́ ꞌyị e ndị́sịyé ndúnduꞌyú kɨ́dí, “ꞌYị máa bɨ ogụ ba káa náambi?” ");
INSERT INTO bdh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ Yésụ ogụnɨ́ kéye née úkulúgu ledre kɨ́dí, “Née Yésụ, nébị bɨ gɨ sɨmɨ Nazeréta owụ́ gara bɨ sɨmɨ káṇgá bɨ Galiláya ní.” ");
INSERT INTO bdh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zɨ́ Yésụ ndéré ólụ́ne do ligá ꞌDị́cị́ ꞌbɨ Lomo, zɨ́a ógóbáyi ꞌyị ga bɨ ndịsịnɨ́ úgúóyó éyị́ kɨ́ yée ga bɨ ndịsịnɨ́ úgú eyị́ e ore ní mbá ꞌdáꞌba. Zɨ́a ị́trị́ónzó tarabíza ꞌbɨ ꞌyị óyólóꞌbó késị́ e kɨ́ bi ndị́sị ꞌbɨ ꞌyị ga bɨ ndịsịnɨ́ úgúóyó amámu e ní kpụkpụ́kpụ bi. ");
INSERT INTO bdh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘ꞌDị́cị́ amá nɨ ꞌdị́cị́ ꞌbɨ ini zɨ́ma,’ tɨ́ lá óyólóꞌbósé nda yị́ esé go káa do ‘bi lóꞌbo ꞌbɨ ꞌyị ugu e.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gɨ do kacɨ́ ledre née zɨ́ ꞌyị e ógụyé kɨ́ ꞌyị ga bɨ kɨ́ komoyé mɨꞌdụ́tụné kɨ́ mɨgịgị́ṛị́ e zɨ́a ꞌDị́cị́ ꞌbɨ Lomo ore, zɨ́a yómo yée. ");
INSERT INTO bdh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tɨ́ lá sɨmɨ bɨ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ ꞌyị ꞌdódo lorụ e lurúnɨ́ mɨngburoko ledre ga bɨ Yésụ ndịsị méngị yée kenée née ní, zɨ́ye ndị́sịyé kpá úwú do owụ́ e kɨ́ ndị́sị mbófo wo do ligá ꞌDị́cị́ ꞌbɨ Lomo kɨ́dí, “Mbófo éyị́ zɨ́ Bulúndu Dawídi”, zɨ́ bi sínyíne royé gbála. ");
INSERT INTO bdh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Zɨ́ mɨngburoko ꞌyị ga gére née ndúꞌyú Yésụ kɨ́dí, “Úwú ledre bɨ owụ́ ga gére née ndịsịnɨ́ úku a née goó?” Yésụ ya zɨ́ye ní, “Ɨɨ, Máúwú go. Sara ólosé esé ledre bɨ ekénɨ́ sɨmɨ mɨéké kúrú Lomo kɨ́dí, “ ‘ꞌDódo ledre go zɨ́ owụ́ e kɨ́ síṛí owụ́ e zɨ́ye íꞌbí mbófo éyị́ zɨ́ma ní wá’?” ");
INSERT INTO bdh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Zɨ́ Yésụ ólụ́ógụné gɨ sɨmɨ Yerụsaléma gɨ ore ndéré ꞌdúꞌduné sɨmɨ owụ́ gara bɨ Beteníya ní. ");
INSERT INTO bdh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Akpa kɨ́ phịyị́ sɨmɨ bɨ Yésụ nɨ go ndáꞌbalúgu roné sɨmɨ Yerụsaléma ní, ꞌbú ufu kóo wo go mɨúfu. ");
INSERT INTO bdh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Zɨ́a lúrúndíki ndóṛí dogboṛụ mɨsiꞌdi. Sɨmɨ bɨ olụ́ sị́ a ní, kémbị́ mɨáná a ndaá tɨ́ lá dụụ́ mbílía. Zɨ́a úku ledre zɨ́ kágá née kɨ́dí, “Tɨ́ bɨ áyí ndị́sị ꞌbɨ eyị́ ní, áná lolụ kú wá.” Geré zɨ́ ndóṛí née gágáne. ");
INSERT INTO bdh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ga lurúnɨ́ ledre née kenée ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́. Zɨ́ye úku ledre kɨ́dí, “Bɨ káa lárá ledre ꞌdi, kágá ba gagá ꞌdiya gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, togụ́ ṇgúṇgusé ledre ꞌbɨ Lomo go ítísé kangú a wá, útúásásé méngị lá dụụ́ ledre bɨ máméngị zɨ́ ndóṛí née wá, ásé kpá útúásá úku ledre zɨ́ landa ba, ‘Ndéré mu, útú sɨmɨ mongụ́ iní bɨ ꞌdáa,’ zɨ́a tɨ́ méngị roné kenée. ");
INSERT INTO bdh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Togụ́ ṇgúṇgu tɨ́ ledre ꞌbɨ Lomo go, éyị́ ga bɨ áyí íni ini zɨ́ Lomo gɨ royé ní, nɨ íꞌbí a zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zɨ́ Yésụ ndáꞌbalúgu roné do ligá ꞌDị́cị́ ꞌbɨ Lomo, sɨmɨ bɨ nɨ ndị́sị ꞌdódo ledre zɨ́ ꞌyị e ní, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kpá kɨ́ ngíti géyị mɨngburoko Yụ́da e ógụyé zɨ́a. Zɨ́ye ndúꞌyú wo kɨ́dí, “Ndíki rokoꞌbụ bɨ ndị́sị méngị éyị́ ga ba kɨ́e ba gɨ ꞌda? Ambí iꞌbí rokoꞌbụ máa née zɨ́yị ne?” ");
INSERT INTO bdh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yésụ ya zɨ́ye ní, ꞌdáꞌdá zɨ́ma kɨ́ úku ledre zɨ́se, “Mááyí aka kpá ndúꞌyú sée. Togụ́ úkulúgusé ledre go kacɨ́ a zɨ́ma, mááyí nda fú úku ꞌdódo ledre ꞌyị bɨ iꞌbí rokoꞌbụ zɨ́ma ndị́sị méngị éyị́ ga gére kɨ́e ní. ");
INSERT INTO bdh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Rokoꞌbụ bɨ Yiwáni ndịsị íꞌbí babatị́za kɨ́e zɨ́ ꞌyị e ní ogụ gɨ zɨ́ Lomo gɨ komo ere togụ́ mbú gɨ zɨ́ ꞌyịmaꞌdí e?” Zɨ́ye ódroyé dongaráye kɨ́dí, “Togụ́ ukuzé yaá ogụ gɨ komo ere yá, nɨ ndúꞌyú zée kɨ́dí, ‘Sara ṇguṇguzé nda ledre ené wá gɨ ro ꞌdi?’ ");
INSERT INTO bdh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tɨ́ lá togụ́ ukuzé yaá rokoꞌbụ née ogụ gɨ zɨ́ ꞌyịmaꞌdí e yá, tụ́ꞌdụ́ ꞌyị ga ba nɨyí zíngi eyé gɨ zɨ́a owonɨ́ Yiwáni bú kɨ́dí nɨ yị́ ené nébị.” ");
INSERT INTO bdh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nda née ní, zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Owozé ezé e wá.” Zɨ́a úku ledre zɨ́ye kɨ́dí, “Bɨ kenée ní, máúku ꞌdódo amá ledre ꞌyị bɨ iꞌbí rokoꞌbụ zɨ́ma ndị́sị méngị éyị́ ga gére née kɨ́e ní wá.” ");
INSERT INTO bdh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zɨ́ Yésụ úku ledre zɨ́ mɨngburoko ꞌyị ga gére née kɨ́dí, “Ili zɨ́se sómụ́ ledre sɨmɨ muruwayi ba bɨlámáne. Ngíti oꞌdo nɨ kóo bo kɨ́ wotị́ne e gbre. Kadra kị́éꞌdo zɨ́a úku ledre zɨ́ owụ́ndíká kɨ́dí, ‘Ndéré aka karaba méngị moko yáká.’ ");
INSERT INTO bdh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Owụ́ndíká née ya zɨ́ ꞌbụné ní, ‘Mándéré amá a wá.’ Tɨ́ lá nda gɨ ꞌdáꞌba, zɨ́a óyólóꞌbó sómụ́ ledre ené zɨ́a ndéréne. ");
INSERT INTO bdh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Zɨ́ ꞌbụa ndéréne úku kpá kémbị́ ledre née zɨ́ ngíti wotị́ne. Zɨ́a úkulúgu ledre zɨ́a kɨ́dí, ‘Babá mááyí ndéré.’ Abú uku kenée, nderé ené wá. ");
INSERT INTO bdh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Gɨ dongará wotị́ga ga bɨ gbre née, ambí mengị ledre kacɨ́ kúrú ꞌbụyé ní ne?” Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Owụ́ndíká mengị ne.” Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ídísé ówo a bɨlámáne, ꞌyị ꞌdóꞌdụ́ ụsórụ e kɨ́ kará ga bɨ ndịsịnɨ́ gámá kacɨ́ yaꞌdá e faa ní, togụ́ oyóloꞌbónɨ́ sómụ́ ledre eyé, nɨyí ógụụ́tụ eyé ye ꞌbe ꞌbɨ Lomo gɨ zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gɨ zɨ́ kéyị née, Yiwáni ogụ kóo ꞌdódo mɨsiꞌdi méngị ledre ga bɨ Lomo ili yée ní zɨ́se, ṇgúṇgusé esé ledre ené wá, tɨ́ lá ꞌyị ꞌdóꞌdụ́ ụsórụ e kɨ́ kará ga bɨ ndịsịnɨ́ gámá kacɨ́ yaꞌdá e faa ní, ṇguṇgunɨ́ nda yị́ eyé ledre ené ye. Abú lúrúsé yée tɨ́ kɨ́ méngị ledre ga bɨ Lomo ili yée ní yá, ílisé esé óyólóꞌbó somụ́ ledre esé zɨ́se ṇgúṇgu ledre ené wá. ");
INSERT INTO bdh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Úwúsé aka kpá ngíti muruwayi ba. Ngíti oꞌdo oꞌdo kóo yáká ené zɨ́a ꞌdị́yị́ kóṛó sɨmɨ a. Zɨ́a íciꞌdíkí gara gbaá roa. Zɨ́a íci gu káa do ndoko gɨ ro do ndị́sị lụ́rụ mɨáná kóṛó née sɨmɨ a. Zɨ́a yéme bi ndị́sị ꞌdága gɨ ro zɨ́ ꞌyị ꞌbáꞌbá yáká máa née ékị́ ndị́sịné doa ꞌbáꞌbá éyị́. Zɨ́a óto ꞌyị ꞌbɨ moko e ndị́sị méngị moko ore, yóó zɨ́a ndéréókpóne do bi gbála. ");
INSERT INTO bdh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sɨmɨ bɨ sịndị́ kadra ꞌbɨ kpɨ́ṛékpe mɨáná kóṛó ogụ ní, zɨ́ mị́ngị́ yáká kása ꞌyị kasa ené zɨ́ ꞌyị lúrú bi kacɨ́ yáká idí ụ́nzụ kóṛó máa ꞌbɨ ené gɨ ro do ógụ kɨ́e zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Zɨ́ ꞌyị ꞌbɨ moko ga bɨ yáká íri née ꞌdíꞌbi ꞌyị ga bɨ mị́ngị́ yáká kasa yée née. Zɨ́ye ócó ngíti a bɨsinyíne, zɨ́ye úfu ngíti a geré mɨúfu, zɨ́ye óngbo otayé kɨ́ tutú. ");
INSERT INTO bdh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Zɨ́a kpá kása ngíti géyị ꞌyị ꞌbɨ moko ené e rómo gɨ do yée ga bɨ ꞌdáꞌdá ní, zɨ́ye yáká íri. Zɨ́ye méngị yée kpá bɨsinyíne káa zɨ́ yée ga bɨ ꞌdáꞌdá ní. ");
INSERT INTO bdh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Odụ a, zɨ́a nda kása cụ́ owụ́ ꞌbɨ ené zɨ́ye yáká íri. Zɨ́a úku ledre kɨ́dí, ‘Nɨyí óto úndru wotị́ne.’ ");
INSERT INTO bdh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tɨ́ lá sɨmɨ bɨ lurúndikinɨ́ owụ́ née ní, zɨ́ye yéme ledre kɨ́dí, ‘Nɨ ídíne karanée mị́ngị́ yáká ba. Ógụsé mu zɨ́ze úfu wo ꞌdáꞌba zɨ́ze ꞌdíꞌbi yáká ba káa do ꞌbɨ ezé.’ ");
INSERT INTO bdh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gɨ ore zɨ́ye ꞌdíꞌbi wo, do lála óyó wo gɨ yáká gɨ ore ꞌdáꞌba, zɨ́ye úfu wo. ");
INSERT INTO bdh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Bɨ kenée ní, sɨmɨ bɨ mị́ngị́ yáká née nɨ ndáꞌbaógụ ní, nɨ méngị kɨ́ ꞌyị ꞌbɨ moko ga gére née ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Nɨ úfu ꞌyị ꞌbɨ moko ga gére née mbá ꞌdáꞌba, zɨ́a ꞌdíꞌbiógụ mɨkánda ꞌyị ꞌbɨ moko e gɨ ro zɨ́ne kpá ndíki éyị́ gɨ yáká ené née.” ");
INSERT INTO bdh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yésụ ya zɨ́ye ní, “Ówosé bú kɨ́dí mɨéké kúrú Lomo uku kɨ́dí, “ ‘Tutú bɨ ꞌyị óꞌbó ꞌdị́cị́ e asinɨ́ gɨ roa ní, ogụ nda yị́ ené go tutú bɨ kɨ́ ledrené owóowó ní wá. Ngére mengị ledre née ne zɨ́a ídíne kenée. Née ledre bɨ owó komozé mɨówó ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Máúku zɨ́se maꞌdíi, bɨlámá bi bɨ ꞌbe ꞌbɨ Lomo ꞌdáa ní, Lomo nɨ ꞌdíꞌbióyó a gɨ zɨ́se, zɨ́a íꞌbí a zɨ́ ꞌyị ga bɨ nɨyí méngị moko ené do bɨlámá mɨsiꞌdiné ní. ");
INSERT INTO bdh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ꞌYị bɨ nɨ lése utú do tutú née ní, nɨ ꞌdéwe geré mɨꞌdéwe. ꞌYị máa wo bɨ tutú née nɨ útú doa ní, nɨ kányá geré mɨkányá.” ");
INSERT INTO bdh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sɨmɨ bɨ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ Farụsáyo e uwúnɨ́ ledre ga bɨ Yésụ ndịsị úku yée sɨmɨ muruwayi kenée ní, zɨ́ye ówo a kɨ́dí, ndịsị úku ledre née gɨ royé. ");
INSERT INTO bdh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Zɨ́ye ndị́sịyé gámásóꞌdo mɨsiꞌdi gɨ ro ꞌdíꞌbi wo, tɨ́ lá bi ꞌdíꞌbi wo ndaá, ngịrị tụ́ꞌdụ́ ꞌyị e mengị yée mɨméngị gɨ zɨ́a ambá ꞌyị e ṇguṇgunɨ́ yị́ eyé mbá ledrea kɨ́dí nɨ nébị. ");
INSERT INTO bdh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zɨ́ Yésụ kpá úku ngíti ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ledre gɨ ro ꞌbe ꞌbɨ Lomo nɨ káa zɨ́ mongụ́ ngére bɨ mengị ayímbi ꞌbɨ owụ́ ꞌbɨ ené bɨ ofụ́ kára ní. ");
INSERT INTO bdh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Zɨ́a kása ꞌyị ꞌbɨ moko ené e ndéré ndólo ꞌyị ga bɨ ili zɨ́ye ógụyé sɨmɨ ayímbi ní. Tɨ́ lá ꞌyị ga bɨ ndolo yée ní, asinɨ́ yị́ eyé mbá mɨási ogụnɨ́ eyé e wá. ");
INSERT INTO bdh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Zɨ́ ngére née kpá kása ngíti géyị ꞌyị ꞌbɨ moko ené e zɨ́ ꞌyị ga bɨ ndolo yée ꞌdáꞌdá ní kɨ́dí, ‘Úkusé zɨ́ye máúfu tụ́ꞌdụ́ ị́tị́ amá e go, éyị́ mɨánu nɨyí go mbá nzíyiné ogụnɨ́ mu sɨmɨ ayímbi.’ ");
INSERT INTO bdh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“ꞌYị ga bɨ ndolo yée née asinɨ́ yị́ eyé fú lá mɨási. Ngíti géyị ịnyịnɨ́ ndéré eyé yáká, ngíti géyị nderénɨ́ yị́ eyé sɨmɨ ngíti géyị moko eyé e. ");
INSERT INTO bdh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Zɨ́ ngíti géyị ꞌdíꞌbi ꞌyị ga bɨ ogụnɨ́ kɨ́ sanda née ócó yée bɨsinyíne, do úfu yée. ");
INSERT INTO bdh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Zɨ́ ledre née sínyíne ro ngére née, zɨ́a íꞌbí okó do ꞌyị ga bɨ mengịnɨ́ ledre née, do úfu yée, do óngbó gara eyé mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Zɨ́a nda úku ledre zɨ́ ꞌyị ꞌbɨ moko ené ga bɨ ndaꞌbaogụnɨ́ née kɨ́dí, ‘Káa zɨ́ bɨ sịndị́ kadra ogụ go ꞌyị ga bɨ mándólo yée ngárá utúasánɨ́ eyé ógụnɨ́ wá ní, ");
INSERT INTO bdh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ndáꞌba ándásé rosé mu do mɨsiꞌdi, tɨ́ lá ꞌyị ga bɨ ndíkisé yée go ní, ídísé ndólo yée idínɨ́ ógụ.’ ");
INSERT INTO bdh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nda gɨ ore zɨ́ ꞌyị ꞌbɨ moko ga gére née ólụ́ógụyé do mɨsiꞌdi íri zɨ́ye ndólo tɨ́ lá ꞌyị ga bɨ ndikinɨ́ yée go ní, bɨlámáye kɨ́ bɨsinyíye mbá, zɨ́ bi ndị́sị ídíne mbá kɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tɨ́ lá sɨmɨ bɨ ngére ịnyị ndéré kɨ́ íꞌbí mandá zɨ́ ṇgu ené e ní, zɨ́a ónzó komoné ro ngíti ꞌyị dongará ṇgu ga gére née bongó ꞌbɨ ayímbi ndaá roa wá. ");
INSERT INTO bdh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Zɨ́ ngére née úku ledre zɨ́a kɨ́dí, ‘Ezegámá ólụ́ yáa káa be ꞌdi, ngárá bongó ꞌbɨ ayímbi ndaá royị́ wá ní.’ Ledre ndaá kóo tara oꞌdo née wá. ");
INSERT INTO bdh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Zɨ́ ngére úku ledre zɨ́ ꞌyị moko ené e kɨ́dí, ‘Ódósé sị́lị́ oꞌdo née kɨ́ sịndị́a, zɨ́se ụ́cụógụ wo sɨmɨ mụtụlụrụ sága ꞌdáa, kɨ́ꞌdí bɨ karanée ꞌyị e nɨyí ndị́sị íni ini kɨ́ náná do soyé ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Tụ́ꞌdụ́ ꞌyị e nɨyí mɨndóloyé, tɨ́ lá mɨgéléye nɨyí cúkuꞌdée.” ");
INSERT INTO bdh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zɨ́ Farụsáyo e yéme ledre gɨ ro ꞌdíꞌbi Yésụ togụ́ uku luyú ledre go ní. ");
INSERT INTO bdh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Zɨ́ye kása ngíti géyị ꞌyị lódụ́ kacɨ́ye kpá kɨ́ ngíti géyị ꞌyị ga bɨ ꞌbɨ Eróde ní zɨ́ Yésụ. Sɨmɨ bɨ ogụnɨ́ íri ní, zɨ́ye ndólo wo kɨ́dí, “ꞌYị ꞌdódo ledre, owozé go kɨ́dí, ꞌyị e otonɨ́ úndruyị́ go kɨ́ngaya gɨ zɨ́a ndị́sị ꞌdódo zɨ́ye dụụ́ maꞌdíi ledre bɨ Lomo ili zɨ́ye méngị a ní. Ífi eyị́ sɨmɨ ꞌyị e wá. ꞌYịmaꞌdí e nɨyí zɨ́yị mbá kɨ́ ledreyé owóowó. ");
INSERT INTO bdh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Íꞌbí aka somụ́ ledre zɨ́ze. Kacɨ́ komoyị́ ní, nɨ mɨútúásáne zɨ́ze íꞌbí ụsórụ zɨ́ Káyísara togụ́ ndazé íꞌbí a wá?” ");
INSERT INTO bdh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tɨ́ lá Yésụ owo mani eyé née bú. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Sée ga bɨ ndị́sịsé lóndo rosé kɨ́dí ásé bɨlámáse ní, éyị́ bɨ ógụsé úzu máa gɨ roa ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ꞌDódosé aka késị́ bɨ ndị́sịsé lengbe íꞌbí a káa do ụsórụ ona ní zɨ́ma lúrú a.” Zɨ́ye íꞌbíógụ a zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Zɨ́a ndúꞌyú yée kɨ́dí, “Bɨ sɨmɨ késị́ máa ba lị́lị ambi? Sara bɨ roa ba ịrị ambi?” ");
INSERT INTO bdh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Née lị́lị Káyísara.” Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Éyị́ bɨ ꞌbɨ Káyísara ní ídísé íꞌbí a zɨ́ Káyísara. Wo bɨ ꞌbɨ Lomo ní, ídísé íꞌbí a zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sɨmɨ bɨ uwúnɨ́ ledre née kenée ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́. Zɨ́ye ị́nyịyé gɨ cigí Yésụ gɨ ore ókpóye. ");
INSERT INTO bdh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kpá sɨmɨ kémbị́ kadra née ní, zɨ́ Sadụkáyo e bɨ ngárá ṇguṇgunɨ́ ꞌbɨ eyé ledre úrú gɨ sɨmɨ umbu wá ní, ógụyé zɨ́ Yésụ zɨ́ye ndólo wo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ꞌYị ꞌdódo ledre, Mụ́sa ekéomo kóo zɨ́ze sɨmɨ lorụ kɨ́dí, togụ́ ꞌyị ofụ́ kára ndikinɨ́ owụ́ kéne wá, zɨ́a úyuné yá, lúndu a idí ꞌdíꞌbi kára umbu née zɨ́ye ndíki owụ́ kéne zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lúrú aka, ꞌyị e nɨyí kóo bo dongaráze ona ịnyị doa gbre mbá lúndu e. Zɨ́ ndíká eyé ꞌdíꞌbi kára, ndikinɨ́ owụ́ kéne wá, zɨ́a úyuómo kára máa née zɨ́ lúndua bɨ gɨ do kacɨ́ a ní ꞌdíꞌbi kára máa née. ");
INSERT INTO bdh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zɨ́a kpá úyuné, zɨ́ ota lúnduyé ꞌdíꞌbi a, zɨ́a kpá úyuné. Zɨ́a ndéréne kenée ógụné gị ro ambáodụ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Odụ a, zɨ́ kára née úyuné. ");
INSERT INTO bdh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bɨ kenée ní, sɨmɨ bɨ karanée ꞌyị e nɨyí úrú gɨ sɨmɨ umbu ní, kára máa née nɨ nda ídí go meꞌbe ambi. Bɨ kóo nɨ go meꞌbeyé mbá ní?” ");
INSERT INTO bdh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Sómụ́ lúyúsé ledre go gɨ zɨ́a ówosé esé mɨéké kúrú Lomo, togụ́ mbú rokoꞌbụ ꞌbɨ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sɨmɨ bɨ Lomo nɨ úru ꞌyị e gɨ sɨmɨ umbu ní, ngíti éyị́ bɨ zɨ́a ídíne kɨ́dí ófụ́ roꞌyị togụ́ mbú ndéré do oꞌdo ní ndaá. ꞌYị e nɨyí ídí dụụ́ káa zɨ́ maláyika e komo ere ní. ");
INSERT INTO bdh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gɨ ro ledre úrú gɨ sɨmɨ umbu ní, ólosé esé ledre bɨ Lomo uku zɨ́se sɨmɨ mɨéké kúrúne ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Uku kɨ́dí, ‘Mááyí Lomo bɨ ndịsị lúrú kacɨ́ Abarayáma, kɨ́ Isáka nda kɨ́ Yakóbo e ní.’ Ndaá ꞌbɨ ené Lomo ꞌbɨ umbu e wá, nɨ yị́ ené Lomo ꞌbɨ ꞌyị ga bɨ trịdrị ní.” ");
INSERT INTO bdh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị e uwúnɨ́ ledre bɨ Yésụ uku kenée ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ mɨꞌdódo ledre ené. ");
INSERT INTO bdh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sɨmɨ bɨ Yésụ romo komo Sadụkáyo e go ní, zɨ́ Farụsáyo ndíkíye ndómo tarayé. ");
INSERT INTO bdh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zɨ́ ngúruyé bɨ owo ledre gɨ ro lorụ go bɨlámáne ní ị́nyịné úzu Yésụ kɨ́ nduꞌyú kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ꞌYị ꞌdódo ledre, lorụ be ꞌdi nɨ ne kɨ́ ledrené owóowó?” ");
INSERT INTO bdh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yésụ ya zɨ́a ní, “ ‘Ídí óto ꞌbú Ngére bɨ Lomo eyị́ ní kɨ́ mɨmbéꞌdeyị́ kị́éꞌdo, kɨ́ lomo royị́ mbá, kpá kɨ́ sómụ́ ledre eyị́ mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Née mɨzefị lorụ bɨ kɨ́ ledrené owóowó ní. ");
INSERT INTO bdh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gbre a ꞌbɨ ené nda wo ba, ‘Ídí óto ꞌbú lafúyị e káa zɨ́ bɨ óto ꞌbúyị kɨ́ royị́ ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lorụ ga bɨ Mụ́sa eké yée kɨ́ yée ga bɨ ngíti géyị nébị e ekénɨ́ yée ní, odónɨ́ royé mbá ro lorụ ga bɨ gbre née.” ");
INSERT INTO bdh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sɨmɨ bɨ Farụsáyo ga gére née nɨyí aka fú cigí Yésụ ore ní, zɨ́a ndúꞌyú yée kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ndị́sịsé sómụ́ a ní, Kɨ́résịto nɨ náambi? Nɨ mbị́ owụ́ ꞌbɨ ambi?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Nɨ owụ́ ꞌbɨ ngére Dawídi.” ");
INSERT INTO bdh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yésụ ya zɨ́ye ní, “Sara togụ́ kenée ní, ꞌDówụ́ Lomo uku nda kóo ledre zɨ́ Dawídi ndólo Kɨ́résịto Ngére ené gɨ ro ꞌdi? Dawídi maꞌdáa uku kóo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Lomo uku ledre zɨ́ Ngére amá kɨ́dí, “Ndị́sị do sị́lị́ma ꞌbɨ anú ona, gị sɨmɨ sịndị́ kadra bɨ mááyí óto ezeokóyị e mbá sị́ sịndị́yị ní.” ’ ");
INSERT INTO bdh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Togụ́ Dawídi ndolo nda wo go Ngére ní, sara nɨ nda ídí owụ́ ꞌbɨ ené lárá a káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ꞌYị bɨ zɨ́a útúásáne úkulúgu ledre kacɨ́ nduꞌyú bɨ Yésụ nduꞌyú née ndaá. Tónóne sɨmɨ sịndị́ kadra bɨ kóo née ꞌyị bɨ zɨ́a tóroógụné ndúꞌyú wo kɨ́ ngíti nduꞌyú ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nda gɨ ore zɨ́ Yésụ ódroné zɨ́ tụ́ꞌdụ́ ꞌyị e kɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ꞌYị ꞌdódo lorụ e kɨ́ Farụsáyo e otonɨ́ nda royé go kɨ́dí, yée nɨyí ye ꞌyị ꞌdódoyéme lorụ ꞌbɨ Mụ́sa. ");
INSERT INTO bdh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bɨ kenée ní, ídísé úwú ledre eyé zɨ́se ndị́sịsé méngị éyị́ ga bɨ nɨyí úku yée zɨ́se ní. Tɨ́ lá ndásé ꞌdíꞌbi mɨméngị ledre eyé wá gɨ zɨ́a ledre ga bɨ ndịsịnɨ́ ꞌdódo yée ní mengịnɨ́ eyé wá. ");
INSERT INTO bdh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Otonɨ́ tụ́ꞌdụ́ lorụ owóowó do ꞌyị e gɨ ro zɨ́ye ndị́sịyé méngị yée, tɨ́ lá yée kɨ́ royé utúasánɨ́ eyé kpá méngị lorụ máa ga gére née wá. ");
INSERT INTO bdh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ndịsịnɨ́ méngị ledre eyé e gɨ ro do lúrú a. Ekéotonɨ́ gba mɨéké kúrú Lomo ro saná zɨ́ye ódóóto a mụụ́ sɨmɨ komoyé, ngíti géyị ro kágá sị́lị́ye. Zɨ́ye íngí kelele e ndríí tara bongó eyé e. ");
INSERT INTO bdh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sɨmɨ ayímbi ilinɨ́ ndị́sị ꞌduo do mɨngburoko bi ndị́sị e kɨ́ bi ndị́sị ga bɨ otonɨ́ yée ꞌdáꞌdá sɨmɨ ꞌDị́cị́ Kótrụro e ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Sɨmɨ bɨ nɨyí sɨmɨ sụ́ụ ní, ilinɨ́ zɨ́ ꞌyị e ndị́sị óto úndruyé sɨmɨ bɨ nɨyí íꞌbí mandá zɨ́ye ní kpá kɨ́ ndị́sị ndólo yée ‘ꞌYị ꞌdódo ledre e.’ ");
INSERT INTO bdh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tɨ́ lá ndásé óto rosé zɨ́ ꞌyị e ndị́sị ndólo sée ‘ꞌYị ꞌdódo ledre e,’ wá, gɨ zɨ́a mongụ́ ꞌyị esé nɨ dụụ́ kị́éꞌdo. Ásé mbá lúndu e kɨ́ lémị e. ");
INSERT INTO bdh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ndásé kpá ndólo ꞌyị do sogo káṇgá ona ‘ꞌbụsé’ wá, gɨ zɨ́a ꞌBụsé nɨ dụụ́ kị́éꞌdo wo bɨ komo ere ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndásé ótoómo rosé zɨ́ ꞌyị e ndólo sée ‘mongụ́ ꞌyị,’ wá, gɨ zɨ́a mongụ́ ꞌyị esé nɨ kị́éꞌdo, máa Kɨ́résịto. ");
INSERT INTO bdh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mongụ́ ꞌyị bɨ dongaráse ní, nɨ idí ꞌyị ị́nyị kasa zɨ́ lafúne. ");
INSERT INTO bdh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ꞌYị bɨ ndịsị óto roné zɨ́ lafúne ꞌdáꞌdá ní, nɨ ídí ꞌdáꞌba, ꞌyị máa wo bɨ ndịsị óto roné ꞌdáꞌba ní, nɨ ídíne zɨ́ lafúne e ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ íꞌbí ꞌdoꞌdó rosé karanée. ꞌDụ́tụsé mbotụ ólụ́ ꞌbe ꞌbɨ Lomo komo ere go gɨ zɨ́ ꞌyị e. Kụṛụꞌbụsé, útúásásé kpá ólụ́ íri wá togụ́ mbú ótoómo bi zɨ́ ꞌyị máa yée ga bɨ ayínɨ́ ólụ́ íri ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ íꞌbí ꞌdoꞌdó rosé. Ndị́sịsé gámá do sogo káṇgá kɨ́ mɨkavu mbá gámásóꞌdo ꞌyị bɨ nɨ ṇgúṇgu ledre esé ní, sɨmɨ bɨ ówosé kémbị́ ꞌyị máa go ní, zɨ́se ndị́sịsé ꞌdódo ledre bɨ nɨ ésị wo ku phoꞌdụ rómo gɨ do wo bɨ ꞌdáꞌdá ní gɨ ro zɨ́a ídíne káa zɨ́ se. ");
INSERT INTO bdh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ásé go sɨmɨ ꞌdoꞌdó. Sée ꞌyị ꞌdóꞌdo ledre zɨ́ ꞌyị e ngárá komosé ndaá ní. ꞌDódosé ledre zɨ́ ꞌyị e kɨ́dí, ‘Togụ́ ꞌyị lobụ́ ꞌDị́cị́ ꞌbɨ Lomo yá, ndaá ꞌbɨ ené luyú wá. Tɨ́ lá togụ́ ꞌyị lobụ́ dábu bɨ ꞌDị́cị́ ꞌbɨ Lomo ní, née lúyú ledre.’ ");
INSERT INTO bdh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ówosé ledre wá gɨ zɨ́ ꞌdi. Éyị́ bɨ kɨ́ ledrené owóowó ní nɨ ꞌdi? Dábu togụ́ mbú ꞌDị́cị́ ꞌbɨ Lomo bɨ oto dábu ne zɨ́a ídíne luyú ndaá roa wá ní? ");
INSERT INTO bdh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ꞌDódosé kpá ledre zɨ́ ꞌyị e kɨ́dí, ‘Togụ́ ꞌyị lobụ́ mbayi bɨ ndịsịnɨ́ ꞌdáná éyị́ zɨ́ Lomo doa ní yá, ledre ndaá sɨmɨ a wá. Tɨ́ lá togụ́ ꞌyị lobụ́ éyị́ bɨ iꞌbínɨ́ wo zɨ́ Lomo ní, née lúyú ledre.’ ");
INSERT INTO bdh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ówosé ledre wá gɨ zɨ́ ꞌdi. Éyị́ bɨ kɨ́ ledrené owóowó ní nɨ ꞌdi? Éyị́ bɨ iꞌbínɨ́ zɨ́ Lomo ní togụ́ mbú mbayi bɨ ndịsịnɨ́ ꞌdáná éyị́ zɨ́ Lomo doa ní, bɨ oto éyị́ née ne zɨ́a ídíne luyú ndaá roa wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ꞌYị bɨ lobụ́ mbayi ꞌbɨ Lomo ní, lobụ́ go za éyị́ ga bɨ sị́ mbayi ore ní mbá. ");
INSERT INTO bdh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kpá kenée ꞌyị bɨ lobụ́ ꞌDị́cị́ ꞌbɨ Lomo go ní, lobụ́ née go Lomo bɨ mị́ngị́ ꞌdị́cị́ máa née ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ꞌYị bɨ lobụ́ ere go ní, lobụ́ née go kị́tị ngére ꞌbɨ Lomo kpá kɨ́ kụṛụꞌbụ Lomo maꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ ꞌdóꞌdo sée bɨsinyíne. Ndị́sịsé tɨ́ ꞌdíꞌbi zaá éyị́ ga bɨ gɨ yáká esé e ní íꞌbí yée zɨ́ Lomo káa do mɨkawu. Tɨ́ lá méngịsé esé mbigí ledre bɨ kóo ásé méngị a káa zɨ́ méngị bɨlámá ledre zɨ́ ꞌyị e, lúrúndúwú ꞌyị e, méngị maꞌdíi ledre e ní wá. Née kóo éyị́ ga bɨ ásé ndị́sị méngị yée ndro kɨ́ yée ga bɨ ndị́sịsé méngị yée née. ");
INSERT INTO bdh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sée ꞌyị ꞌdódo ledre ga bɨ ngárá komosé ndaá ba, ndị́sịsé ị́kpị́óyó owụ́ ṇgoṇgó bɨ cúkuꞌdée do iní bɨ ílisé éwé a ní ꞌdáꞌba, tɨ́ lá ị́kpị́óyósé esé mongụ́ mɨsosókó bɨ sɨmɨ iní née wá, zɨ́se éwé a sɨmɨsé. ");
INSERT INTO bdh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ ꞌdóꞌdo sée bɨsinyíne. Ndị́sịsé lúgu lá dụụ́ ro kóꞌdo kɨ́ éyị́ ga bɨ ndị́sịsé ánu éyị́ sɨmɨyé ní, tɨ́ lá zɨ́se ótoómo sɨmɨyé ngurongbo kɨ́ ị́ndrị bɨ mongụ́ mɨmbéꞌde kɨ́ mongụ́ ꞌbú éyị́ ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sée Farụsáyo bɨ ngárá komosé ndaá ní, ídísé lúgu sɨmɨ kóꞌdo kɨ́ éyị́ ga bɨ ndị́sịsé ánu éyị́ sɨmɨyé ní kí. Gɨ ore, royé bɨ ꞌdí sága ní nɨ kpá árá ené zɨ́ye ídíye drá. ");
INSERT INTO bdh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ ꞌdóꞌdo sée bɨsinyíne. Ásé cé káa zɨ́ bi bɨ oꞌbónɨ́ wo bɨlámáne kɨ́ lámá roné gɨ ꞌdí sága, tɨ́ lá sɨmɨ a íri yị́ ené lá dụụ́ cóngó kɨ́ bɨsinyí alá éyị́ e ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ásé cé kenée gɨ ꞌdí sága. Do komo ꞌyị e, ásé ꞌyị méngị bɨlámá ledre e, tɨ́ lá ꞌdí sɨmɨsé, mɨmbéꞌdesé kɨ́ mɨméngị ledre esé emenɨ́ eyé e ngụ́. ");
INSERT INTO bdh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Sée ꞌyị ꞌdódo lorụ e, kɨ́ Farụsáyo e, ndị́sịsé lóndo rosé gbékpị́ne. Lomo nɨ ꞌdóꞌdo sée bɨsinyíne. Ndị́sịsé óꞌbó bi zɨ́ nébị e zɨ́se ndị́sịsé kpá kɨ́ kúṛíṛi yéme ro bi zɨ́ mbigí ꞌyị ga bɨ ndịsịnɨ́ méngị ledre ꞌbɨ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Zɨ́se ndị́sịsé úku ledre kɨ́dí, ‘Togụ́ ásé kóo bo sɨmɨ sịndị́ kadra bɨ kóo ꞌbɨ bulúndusé e ní yá, káa bɨ útúásásé esé kóo ṇgúṇgu a zɨ́se kótrụ rosé kéye léfe sáma nébị e wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bɨ kenée ní, úkusé go cụ́ kɨ́ tarasé kɨ́dí ásé bulúndu ꞌyị ga bɨ kóo ufunɨ́ nébị ga bɨ kóo née. ");
INSERT INTO bdh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Káa zɨ́ bɨ go kenée ní, ꞌdíꞌbisé mɨméngị ledre ꞌbɨ bulúndusé ga gére née mu ndéré kɨ́e ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ásé káa zɨ́ kámá okó ní. Ndị́sịsé ụ́lụ́ bɨsinyí ledre bɨ káa zɨ́ súrú kámá ní. Ásé ómo gɨ sɨmɨ phoꞌdụ bɨ Lomo nɨ ụ́cụ sée sɨmɨ a ní lárá a káa be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bɨ kenée ní, Mááyí kása nébị e kɨ́ ꞌyị ꞌbɨ komokenzị e kɨ́ ꞌyị ꞌdódo ledre e zɨ́se. Tɨ́ lá ásé úfu ngíti géyị, zɨ́se phéphéónzó ngíti géyị do mɨngbúngbu kágá, zɨ́se ndị́sịsé kɨ́ ócó ngíti géyị sɨmɨ ꞌDị́cị́ Kótrụro e, kpá kɨ́ ógó lící ngíti géyị gɨ sɨmɨ ngíti gara sɨmɨ ngíti a. ");
INSERT INTO bdh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gɨ zɨ́ kéyị née ní, Lomo nɨ íꞌbí ꞌdoꞌdó rosé gɨ ro bɨlámá ꞌyị ené ga bɨ úfusé yée ní, tónóne gɨ ro Ábele ndéréógụné gị ro Zakaríya wotị́ Berekíya, bɨ kóo úfusé wo za cụ́ dongará ꞌDị́cị́ ꞌbɨ Lomo kɨ́ mbayi bɨ ndịsịnɨ́ ꞌdáná éyị́ sị́ a zɨ́ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Máúku zɨ́se maꞌdíi, Lomo nɨ íꞌbí ꞌdoꞌdó ꞌbɨ bɨsinyí ledre ga gére née dosé sée ꞌyị máa ga bɨ sɨmɨ sịndị́ kadra bɨ cakaba ba.” ");
INSERT INTO bdh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Sée ꞌyị ꞌbɨ Yerụsaléma, úfusé kóo nébị e, zɨ́se kpá óngbóónzó ngíti géyị ꞌyịmɨkása ga bɨ kóo Lomo kasaogụ yée zɨ́se ní kɨ́ tutú. Máíli kóo tɨ́ gɨ ro kótrụ owụ́ ꞌbɨ esé e káa zɨ́ mbágá ngono bɨ kotrụ owụ́ ꞌbɨ ené trị́é sị́ fúndúne ní, tɨ́ lá ílisé esé kenée wá. ");
INSERT INTO bdh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bɨ kenée ní, ꞌDị́cị́ esé ꞌbɨ Lomo nɨ go ógụ ídí tobó. ");
INSERT INTO bdh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Máúku ba go wo zɨ́se, tónóne cakaba ndéréne ꞌdáꞌdá, útúásásé aka lolụ lúrú máa wá ꞌbúó togụ́ ásé úku ledre kɨ́ tarasé kí kɨ́dí, ‘Úndru idí ídí zɨ́ wo bɨ ogụ kɨ́ ịrị Ngére Lomo ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sɨmɨ bɨ Yésụ olụ́ogụ gɨ sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo gɨ ore nɨ nda go ndéréókpó ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ndị́sị úku ledre toso mɨóꞌbó ꞌdị́cị́ ga bɨ ore ní zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Lúrúsé ꞌdị́cị́ ga gére née go? Máúku zɨ́se maꞌdíi, tutú bɨ kị́éꞌdo karanée nɨ ídíáká do lafúne ní ndaá, nɨyí ndụ́rụónzó yée za mbá bi.” ");
INSERT INTO bdh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sɨmɨ bɨ Yésụ nɨ mɨndị́sịné ngúcuné do Landa Olíva ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ógụyé zɨ́a. Zɨ́ye ndúꞌyú wo kɨ́dí, “Ledre máa née nɨ méngị roné kɨ́ be ꞌdi? Sara éyị́ bɨ nɨ ꞌdódo mɨndáꞌbaógụyị́ kɨ́ odụ do sogo káṇgá ba ní ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Komosé idí ídí rosé, ngíti géyị ꞌyị e ndanɨ́ lóndo sée wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tụ́ꞌdụ́ ꞌyị e nɨyí ógụ úku ledre kɨ́dí mákása yée máa, ngíti géyị nɨyí úku ꞌbɨ eyé kɨ́dí, ‘Mááyí Kɨ́résịto,’ bɨ kenée ní, nɨyí lóndo tụ́ꞌdụ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ásé úwú gboṛụ okó e, kɨ́ ledre okó máa yée ga bɨ nɨyí ndị́sị méngị royé do ngíti géyị bi e ní, ndásé sị́kpị mɨmbéꞌdesé ꞌdága wá. Ledre ga gére née nɨyí méngị royé kenée kí, tɨ́ lá née ndaá ꞌbɨ ené aka odụ do sogo káṇgá ba wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngíti géyị ꞌyị e gɨ sɨmɨ ngíti káṇgá nɨyí ị́nyị ndéré útú kɨ́ okó do ngíti káṇgá. Ngíti mị́ngị́ káṇgá nɨ kása ꞌyị ené e ndéré útú kɨ́ okó do ezené bɨ ꞌbɨ ngíti káṇgá kpị́ ní. Bizóró ꞌbɨ ꞌbú nɨ útú do ꞌyị e mbá, zɨ́ mɨkị́ꞌdị káṇgá ídíne do bi e mɨngúngúcua bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ga gére née aka yị́ ené lá dosị́ nduwú. ");
INSERT INTO bdh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ngíti géyị ꞌyị e nɨyí ꞌdíꞌbi sée íꞌbí sée zɨ́ mɨngburoko mị́ngị́ káṇgá e zɨ́ye ꞌdóꞌdo sée, do kɨ́ úfu ngíti géyị ꞌyị e gɨ dongaráse. Tụ́ꞌdụ́ ꞌyị e mbá nɨyí sógó sée gɨ zɨ́a bɨ ṇgúṇgusé ledremá ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gɨ zɨ́ ngịrị, tụ́ꞌdụ́ ngíti géyị ꞌyị e nɨyí ási gɨ romá, zɨ́ye óyólóꞌbó royé sógó lafúye zɨ́ye kpá ndị́sịyé íꞌbí lafúye e zɨ́ ezeokóye. ");
INSERT INTO bdh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nda kpá lá dụụ́ wo née wá, tụ́ꞌdụ́ ngíti géyị ꞌyị ṛanga e nɨyí ógụ kɨ́dí yée nɨyí kpá nébị e zɨ́ye lóndo tụ́ꞌdụ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gɨ zɨ́ tụ́ꞌdụ́ bɨsinyí ledre ga bɨ nɨyí méngị royé kenée ní, zɨ́ tụ́ꞌdụ́ ngíti géyị ꞌyị e ótoómo kɨ́ óto ꞌbú lafúye. ");
INSERT INTO bdh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tɨ́ lá ꞌyị bɨ nɨ ódó mɨmbéꞌdené zɨ́a tóroné ngbúó oyó sogoné zɨ́ma mbá wá ní, sɨmɨ odụ sịndị́ kadra, nɨ ídí kɨ́ trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bɨlámá ledre bɨ gɨ ro ꞌbe ꞌbɨ Lomo ní, nɨyí aka úku ꞌdódo a zɨ́ ꞌyị e za mbá kí, odụ do sogo káṇgá ba nɨ nda fú ógụ. ");
INSERT INTO bdh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Née ní sɨmɨ bɨ lúrúndíkisé ‘mongụ́ éyị́ bɨsinyí go kɨ́ tóro do bi ꞌbɨ Lomo’ cé káa bɨ kóo nébị Dániyele uku ledreyé ní, ꞌyị bɨ nɨ ólo ledre ba ní, idí ówoyéme ini ledre gɨ sɨmɨ a bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sɨmɨ bɨ ledre máa ga gére née nɨyí go méngị royé ní, ꞌyị ga bɨ nɨyí sɨmɨ Yụdáya ní, idínɨ́ ngásá komo landa e. ");
INSERT INTO bdh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ꞌYị bɨ ledre née nɨ ndíki wo do ꞌdị́cị́ ní, ndaá ndítíógụ ólụ́ ꞌdị́cị́ ꞌdíꞌbi éyị́ e kí wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ꞌYị máa wo bɨ ledre née ndiki wo yáká ní, ndaá ndáꞌba ꞌbe gɨ ro ꞌdíꞌbi bongó ené kí wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nɨ ídí bɨsinyí sịndị́ kadra zɨ́ kará ga bɨ kɨ́ sɨmɨyé kpá kɨ́ kará máa yée ga bɨ owụ́ nɨyí ndị́sị ụ́lụ umba kóꞌdụ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ídísé íni ini zɨ́ Lomo, bɨsinyí ledre née ndaá méngị roné sɨmɨ sịndị́ kadra ꞌbɨ drụ́ togụ́ mbú sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ꞌDoꞌdó née nɨ rómo yée ga bɨ kóo mengịnɨ́ royé kú gɨ sɨmɨ sịndị́ kadra bɨ kóo Lomo otoogụ káṇgá ba sɨmɨ a ní. Toso bɨsinyí ledre née mengị andá lolụ roné kenée pị́ṛị́wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Togụ́ Lomo nda kóo ꞌdósoógụ sịndị́ kadra ꞌbɨ ꞌdoꞌdó née zɨ́a ídíne gbúꞌdu wá, káa bɨ ꞌyị ómo ndaá. Tɨ́ lá gɨ ro ledre ꞌyị ené ga bɨ gelé yée ní, zɨ́a ꞌdósoógụ sịndị́ kadra née gbúꞌdu. ");
INSERT INTO bdh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sɨmɨ sịndị́ kadra ꞌbɨ bɨsinyí ledre máa née ní, togụ́ ꞌyị ogụ úku ledre zɨ́se kɨ́dí, ‘Kɨ́résịto nɨ go ba,’ togụ́ mbú kɨ́dí ‘Nɨ go bɨ ꞌdáa’ yá, ndásé ṇgúṇgu a wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gɨ zɨ́a tụ́ꞌdụ́ ꞌyị ṛanga e nɨyí ógụ zɨ́ye ndị́sị úku ledre ya yée nɨyí Kɨ́résịto, ngíti géyị ya yée nɨyí nébị e. Zɨ́ye ndị́sịyé méngị mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé ní gɨ ro lóndo kpá za cụ́ mɨgélé ꞌyị ga bɨ ꞌbɨ Lomo ní togụ́ mɨsiꞌdi nɨ bo zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ledre ga bɨ máénzị komosé kɨ́e née ní, ndaá lị́gị sée wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Togụ́ ꞌyị uku ledre zɨ́se ya, ‘Kɨ́résịto nɨ sɨmɨ súwú ꞌdáa yá,’ ndásé ndéré íri wá. Togụ́ uku mbú ya ‘Kɨ́résịto nɨ ꞌdị́cị́ ona yá, ndásé ṇgúṇgu a wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gɨ zɨ́a mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí, nɨ ídí káa zɨ́ nzagba bɨ ꞌbɨleꞌbe, zɨ́ phoꞌdụ a óṇgóne kú gɨ gbére gị gólụ ní. ꞌYị e nɨyí lúrú a mbá kɨ́ komoyé. ");
INSERT INTO bdh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bi bɨ umbu eyị́ nɨ doa ní, lugúnu e nɨyí yóko royé ore. ");
INSERT INTO bdh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Geré gɨ do kacɨ́ ꞌdoꞌdó ga gére ní, “ ‘zɨ́ kadra ị́lị́ne mbụụ́, éfé oṇgó kpá wá, zɨ́ kele e ndị́sị ṛéṛeyé gɨ ꞌdága gɨrí, née ní zɨ́ éyị́ ga bɨ komo ere ní mbá ndị́sị kị́zịyé.’ ");
INSERT INTO bdh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Sɨmɨ sịndị́ kadra máa née ní, éyị́ bɨ nɨ ꞌdódo mɨógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí ní nɨ ꞌdódo roné komo ere, zɨ́ ꞌyịmaꞌdí e do sogo káṇgá útúye mbá ndị́sị íni ini. Nɨyí lurúndikinɨ́ Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ógụ gɨ komo ere kpụrụ́ gɨ sɨmɨ bụṛụngụ́ kɨ́ cóngó roné kpá kɨ́ mongụ́ rokoꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nɨ kása maláyika e ené e ndéréye kɨ́ ímí dịbịlị e do bi e za mbá gɨ ro zɨ́ye ꞌdóꞌdụ́yóko ꞌyị ené ga bɨ gelé yée go zɨ́ne ní gɨ do sogo káṇgá mbá. ");
INSERT INTO bdh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ídísé lúrútóko lị́lị ledre gɨ ro kágá e. Sɨmɨ bɨ mbílí kágá tonó go ụ́ꞌbụlúgu roné ní, kɨ́dí ndumu nɨ go gbóo. ");
INSERT INTO bdh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kpá kenée, sɨmɨ bɨ lúrúsé éyị́ ga gére née nɨyí go kɨ́ méngị royé kenée ní, ídísé ówo a kɨ́dí, sịndị́ kadra bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ sɨmɨ a ní nɨ go gbóo. ");
INSERT INTO bdh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Máúku zɨ́se maꞌdíi, ledre née nɨ méngị roné ꞌdáꞌdá kí gɨ zɨ́ ꞌyị ga bɨ cakaba ba kɨ́ úyuónzó royé. ");
INSERT INTO bdh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Do sogo káṇgá kɨ́ ere nɨyí ụ́kụ́ mbá, tɨ́ lá ledre amá ụkụ́ ené wá.” ");
INSERT INTO bdh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ꞌYị bɨ owo sịndị́ kadra kɨ́ sị́lị́ bɨ ledre ga gére née nɨyí méngị royé sɨmɨ a ní ndaá. Gba maláyika ga bɨ komo ere kɨ́ Owụ́ ꞌbɨ ꞌYịmaꞌdí ní owonɨ́ wá. Tɨ́ lá Babá owo dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sɨmɨ bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ ní, ledre nɨyí ídí cé káa zɨ́ bɨ kóo sɨmɨ sịndị́ kadra bɨ kóo ꞌbɨ Nówa ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gɨ zɨ́a, ꞌdáꞌdá gɨ zɨ́ mongụ́ iní bɨ kóo eꞌdị zɨ́a úcuné do sogo káṇgá ba za mbá ní, ꞌyị e otonɨ́ yị́ eyé kóo komoyé lá dụụ́ gɨ ro ánu éyị́ e kɨ́ éwé éyị́ e, ngíti géyị kɨ́ ófụ́ royé ndéréne kenée gị sɨmɨ sịndị́ kadra bɨ zɨ́ Nówa ólụ́ye sɨmɨ kuṛúngba ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ꞌYị e owonɨ́ eyé kóo éyị́ bɨ nɨ ógụ méngị roné ní wá, zaá gị sɨmɨ bɨ mongụ́ iní eꞌdị zɨ́a úcuné do sogo káṇgá ba zɨ́a úfuónzó ꞌyị e za mbá ní. Mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ lị́yị ꞌyị e gú kenée. ");
INSERT INTO bdh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Maꞌdíi, kadra bɨ mááyí ndáꞌbaógụ ní, togụ́ ꞌyị e gbre nɨyí méngị moko yáká yá, mááyí yomo wo bɨ kị́éꞌdo ṇguṇgu ledre amá go ní zɨ́ma ótoómo wo bɨ ṇguṇgu ledre amá wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kpá kenée, togụ́ kará e nɨyí gbre do bi ụ́sụ éyị́, mááyí yomo wo bɨ kị́éꞌdo ṇguṇgu ledre amá go ní zɨ́ma ótoómo wo bɨ ṇguṇgu ledre amá wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Bɨ kenée ní, ídísé ídí kɨ́ komosé rosé, gɨ zɨ́a bɨ ngárá ówosé kadra bɨ Ngére esé nɨ ndáꞌbaógụ sɨmɨa ní wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ówosé bú kɨ́dí, togụ́ kóo mị́ngị́ ꞌbe owo sịndị́ kadra bɨ ꞌyị ugu nɨ ógụ úgu éyị́ ené sɨmɨ a bú ní, káa bɨ nɨ óndóráyi bi ndre, otoomo ꞌyị ugu zɨ́a úgu éyị́ ené e wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bɨ kenée ní, ledre ndaá lị́gị sée wá, gɨ zɨ́a mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ lị́yị sée mɨlị́yị. Ówosé sịndị́ kadra a wá. ");
INSERT INTO bdh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ꞌYị ꞌbɨ moko bɨ mɨméngị ledre ené nɨ mɨútúásáne nɨ kpá ꞌyị komokenzị ní nɨ wo be ꞌdi, wo bɨ mongụ́ ꞌyị ené oto wo lúrú bi kacɨ́ lafúga ꞌyị ꞌbɨ moko e, zɨ́a ndị́sịné íꞌbí éyị́ mɨánu eyé e zɨ́ye sɨmɨ sịndị́ kadra bɨ mɨútúásáne ní? ");
INSERT INTO bdh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nɨ ídí bɨlámáne zɨ́ ꞌyị moko née togụ́ mongụ́ ꞌyị ené ogụ ndiki wo tɨ́ fú kɨ́ lúrú bi kacɨ́ lafúne kenée ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Máúku zɨ́se maꞌdíi, mị́ngị́ ꞌbe née nɨ óto ꞌyị moko née zɨ́a ídíne ꞌyị lúrú bi kacɨ́ yị́ ené ga bɨ ꞌbe ore ní mbá. ");
INSERT INTO bdh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tɨ́ lá idí kóo ꞌyị ꞌbɨ moko née nɨ bɨsinyí ꞌyị zɨ́a sómụ́ ledre kɨ́dí, ‘Mongụ́ ꞌyị ené nderé go gbála ndaꞌbaogụ ené ꞌdiya wá,’ ");
INSERT INTO bdh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","zɨ́a ndị́sịné kɨ́ ócó lafúne ga gére née bɨsinyíne kpá kɨ́ ánu éyị́ kɨ́ éwé leꞌyị́ kɨ́ ꞌyị kóyó e. ");
INSERT INTO bdh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mongụ́ ꞌyị née nɨ ndáꞌbaógụ sɨmɨ sị́lị́ kɨ́ sịndị́ kadra bɨ ꞌyị ꞌbɨ moko née owo wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nɨ ꞌdóꞌdo ꞌyị ꞌbɨ moko née bɨsinyíne, zɨ́a ónzó wo dongará ꞌyị ga bɨ ndịsịnɨ́ lóndo royé kɨ́dí yée nɨyí bɨlámá ꞌyị e ní kɨ́ꞌdí bɨ ini nɨ gú ídí kɨ́ náná do so ꞌyị gɨ zɨ́ éyị́ mɨówo ní.” ");
INSERT INTO bdh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Sɨmɨ sịndị́ kadra máa née ní, ledre gɨ ro ꞌbe ꞌbɨ Lomo komo ere nɨ ídí káa zɨ́ owụ́kará ga bɨ sokó (10) ꞌdiꞌbinɨ́ lámba eyé ndéréye sóngó mɨkánda adrúgu bɨ ili ógụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yée ga bɨ ịnyị (5) ní nɨyí ꞌyị komokenzị e, ngítí géyị ga bɨ ịnyị (5) ní nɨyí ꞌbɨ eyé ꞌyị cayi e. ");
INSERT INTO bdh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yée ga bɨ ꞌyị cayi e ní ꞌdiꞌbinɨ́ lámba eyé e tɨ́ go ní, tɨ́ lá ꞌdiꞌbiutúnɨ́ eyé yata sụꞌbụ́ phoꞌdụ wá. ");
INSERT INTO bdh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yée ga bɨ ꞌyị komokenzị ní ꞌdiꞌbinɨ́ ꞌbɨ eyé lámba eyé, zɨ́ye ꞌdíꞌbi yata sụꞌbụ́ phoꞌdụ kpa sɨmɨ kúkú ndéré kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zɨ́ mɨkánda adrúgu née lúꞌbúne kɨ́ngaya ogụ ené ꞌdiya wá. Zɨ́ ꞌbí ꞌdíꞌbi owụ́kará ga bɨ ndịsịnɨ́ sóngó wo ba zɨ́ye útúye mbá ꞌdúꞌduyé. ");
INSERT INTO bdh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nda go kɨ́ yana ndụlụ, zɨ́ ngíti ꞌyị gbúrógbóne kɨ́dí, ‘ꞌDiꞌdiya, mɨkánda adrúgu ogụ go, ị́nyịógụsé mu ꞌdíꞌbi wo sɨmɨ sụmụ.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Zɨ́ owụ́kará ga gére née gbúgbu úrúye óto phoꞌdụ do lámba eyé e. ");
INSERT INTO bdh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Zɨ́ yée ga bɨ ꞌyị cayi e ní úku ledre zɨ́ lafúye ga bɨ ꞌyị komokenzị ní kɨ́dí, ‘Sákásé aka zée kɨ́ owụ́ sụꞌbụ́ phoꞌdụ. Lámba ezé ayínɨ́ go ị́lị́.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Zɨ́ owụ́kará ga bɨ ꞌyị komokenzị ní, úkulúgu ledre zɨ́ lafúye ga gére née kɨ́dí, ‘Sụꞌbụ́ phoꞌdụ utúasá ásá zɨ́ze kése mbá wá, bɨlámá a ídísé ndéré úgú ꞌbɨ esé.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Tɨ́ lá sɨmɨ bɨ oyónɨ́ aka lá sogoyé ndéréye úgú sụꞌbụ́ phoꞌdụ ní, zɨ́ mɨkánda adrúgu née ógụné. Zɨ́ owụ́kará ga bɨ ꞌyị komokenzị bɨ kóo nɨyí yị́ eyé nzíyiyé ní ndéréye kéye sɨmɨ ꞌdị́cị́ bɨ ayínɨ́ ófụ́ kára sɨmɨ a ní. Do ꞌdụ́tụ mbotụ. ");
INSERT INTO bdh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nda gɨ ꞌdáꞌba zɨ́ yée ga bɨ gáa nderénɨ́ úgú sụꞌbụ́ phoꞌdụ ní ndáꞌbaógụyé. Zɨ́ye ndóndóló kɨ́dí, ‘Ngére, Ngére, líkpí mbotụ zɨ́ze.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tɨ́ lá zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, ‘Máúku zɨ́se maꞌdíi, máówo amá sée wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Bɨ kenée ní, komosé idí ídí rosé gɨ zɨ́a ówosé esé sị́lị́ kɨ́ sịndị́ kadra bɨ ledre née nɨ méngị roné sɨmɨ a ní wá. ");
INSERT INTO bdh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nɨ ídí kpá káa zɨ́ ꞌyị bɨ ịnyị ndéré do ngíti bi zɨ́a íꞌbíómo éyị́ ené ga bɨ ꞌbɨ ꞌbe ní mbá zɨ́ ꞌyị ꞌbɨ moko ené e ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iꞌbí késị́ álifu ịnyị (5,000) zɨ́ mɨzefịyé, zɨ́a íꞌbí álifu gbre (2,000) zɨ́ gbreyé nda zɨ́ otayé (3) ꞌbɨ ené álifu kị́éꞌdo (1,000) kpịnị kacɨ́ rokoꞌbụyé mɨkékeṛị́a. Zɨ́a ị́nyịné ndéréókpóne. ");
INSERT INTO bdh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Zɨ́ wo bɨ iꞌbínɨ́ álifu ịnyị (5,000) zɨ́a ní, geré tónóne méngị moko kɨ́e zɨ́a ndíki yata a doa kpá álifu ịnyị (5,000). ");
INSERT INTO bdh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wo bɨ iꞌbínɨ́ zɨ́a álifu gbre (2,000) ní, zɨ́a ndíki yata a doa kpá álifu gbre (2,000). ");
INSERT INTO bdh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tɨ́ lá wo bɨ iꞌbínɨ́ zɨ́a álifu kị́éꞌdo ní, zɨ́a ꞌdíꞌbi késị́ ꞌbɨ mongụ́ ꞌyị ené née ndéréne ícióto a sɨmɨ káṇgá. ");
INSERT INTO bdh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nda gɨ do kacɨ́ ngbángbá sị́lị́, zɨ́ mongụ́ ꞌyị née ndáꞌbaógụné. Zɨ́a ndóloyóko ꞌyị ꞌbɨ moko ené ga gére née ndúꞌyú yée gɨ ro éyị́ bɨ mengịnɨ́ wo go kɨ́ késị́ ené ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Zɨ́ wo bɨ kóo mongụ́ ꞌyị iꞌbí zɨ́a álifu ịnyị (5,000) ní ꞌdíꞌbiógụ kpá ngíti álifu ịnyị. Zɨ́a úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, íꞌbí kóo zɨ́ma álifu ịnyị (5,000), mándíki yata a doa go kpá álifu ịnyị (5,000).’ ");
INSERT INTO bdh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mongụ́ ꞌyị ené ya zɨ́a ní, ‘Mbófo éyị́ zɨ́yị, áyí cóngó ꞌyị ꞌbɨ moko. Méngị moko go kɨ́ owụ́ késị́ bɨ cúkuꞌdée ní bɨlámáne, mááyí óto yị́ị ꞌyị lúrú bi kacɨ́ tụ́ꞌdụ́ éyị́ amá e. Ógụ mu zɨ́ze ídíze kéyị sɨmɨ rokinyi.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Zɨ́ wo bɨ iꞌbínɨ́ zɨ́a álifu gbre (2,000) ní ꞌdíꞌbiógụ kpá ngíti álifu gbre. Zɨ́a úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, íꞌbí kóo zɨ́ma álifu gbre (2,000), mándíki yata a doa go kpá álifu gbre (2,000).’ ");
INSERT INTO bdh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mongụ́ ꞌyị ené ya zɨ́a ní, ‘Mbófo éyị́ zɨ́yị, áyí cóngó ꞌyị ꞌbɨ moko. Méngị moko go kɨ́ owụ́ késị́ bɨ cúkuꞌdée ní bɨlámáne, mááyí óto yị́ị ꞌyị lúrú bi kacɨ́ tụ́ꞌdụ́ éyị́ amá e. Ógụ mu zɨ́ze ídíze kéyị sɨmɨ rokinyi.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Zɨ́ wo bɨ iꞌbínɨ́ zɨ́a álifu kị́éꞌdo (1,000) ní ógụné. Zɨ́a úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, máówo bú bi ndeke ndaá ꞌbɨ ené royị́ wá. Abú óꞌdo éyị́ wá áyí fú lá ꞌdíꞌbiógụ éyị́ e gɨ yáká, zɨ́yị ndị́sịyị́ kpá kótrụ éyị́ mɨánu gɨ do bi bɨ ꞌdị́yị́ éyị́ doa yị́ị wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngịrịyị́ mengị máa ne, zɨ́ma ótoécị késị́ eyị́ sɨmɨ káṇgá. Lúrú aka ba tɨ́ kacɨ́ sị́lị́yị bɨ kóo ódó kɨ́e ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mongụ́ ꞌyị ené ya zɨ́a ní, ‘Áyí bɨsinyí ꞌyị kpá ꞌyị ngịdrị. Ówo bú mándị́sị ꞌdíꞌbiógụ éyị́ e gɨ yáká bɨ máóꞌdo máa wá ní, zɨ́ma ndị́sịmá kpá kótrụ éyị́ mɨánu gɨ do bi bɨ máꞌdị́yị́ éyị́ doa wá ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Áyí kóo ndéré kɨ́ késị́ amá née óto a zɨ́a méngị moko zɨ́ma gɨ ro zɨ́ma ndáꞌbaógụmá ndíki a ngboró go.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Zɨ́ mongụ́ ꞌyị née úku ledre kɨ́dí, ‘ꞌDíꞌbisé álifu kị́éꞌdo (1,000) née gɨ zɨ́a ꞌdáꞌba zɨ́se íꞌbí a zɨ́ wo bɨ nɨ kɨ́ álifu zɨ́ne sokó (10,000) ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gɨ zɨ́a ꞌyị bɨ kɨ́ éyị́ zɨ́ne ní, Lomo nɨ íꞌbí yata éyị́ e zɨ́a, zɨ́a nda ídíne kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne kɨ́ngaya. Tɨ́ lá ꞌyị máa wo bɨ éyị́ ndaá ꞌbɨ ené zɨ́a wá ní, owụ́ a bɨ zɨ́a ní, nɨyí ꞌdíꞌbióyó a gɨ zɨ́a ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ꞌYị ꞌbɨ moko máa wo bɨ moko ndaá sɨmɨ a wá née, ꞌdíꞌbisé wo, zɨ́se ụ́cụógụ wo sɨmɨ mụtụlụrụ sága kɨ́ꞌdí bɨ ini nɨ gú ídí kɨ́ náná do so ꞌyị gɨ zɨ́ éyị́ mɨówo ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sɨmɨ bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ kɨ́ mongụ́ rokoꞌbụné káa do Ngére kɨ́ maláyika e ené ní, nɨ ndị́sị do kị́tị ngére ené kɨ́ rokoꞌbụ bɨ gɨ komo ere ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Zɨ́a ndóloyóko ṛị́kị́ sị́ do ꞌyịmaꞌdí e za mbá kóꞌdụ́ne, zɨ́a ndị́sịné ífi sɨmɨyé káa zɨ́ ꞌyị ꞌbáꞌbá kábịṛị́kị e ndị́sị ífi sɨmɨ ína e kɨ́ kábịṛị́kị e ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nɨ óto kábịṛị́kị e do sị́lị́ne ꞌbɨ ánu, zɨ́a óto ína e ꞌbɨ eyé do ngelị. ");
INSERT INTO bdh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Née ní, Ngére Yésụ nɨ úku ledre zɨ́ yée ga bɨ do sị́lị́ne ꞌbɨ anú ní kɨ́dí, ‘Sée ga bɨ Babá iꞌbí úndru go zɨ́se ní, ógụsé mu ꞌdíꞌbi úndru bɨ Lomo yemeomo gɨ rosé ꞌbe ꞌbɨ ené kú ꞌdesị́ ꞌdáꞌdá gɨ zɨ́ Lomo kɨ́ ótoógụ do sogo káṇgá ba ní ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gɨ zɨ́a sɨmɨ bɨ kóo mááyí kɨ́ ꞌbú ní, zɨ́se íꞌbí éyị́ mɨánu zɨ́ma, sɨmɨ bɨ mááyí kɨ́ kodró ní, zɨ́se íꞌbí iní mɨéwé zɨ́ma, sɨmɨ bɨ mááyí káa zɨ́ ꞌyị lóṇgó ní, zɨ́se ꞌdíꞌbi máa sɨmɨ sụmụ. ");
INSERT INTO bdh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mááyí do lerị́ bongó, zɨ́se íꞌbí bongó zɨ́ma. Mááyí kɨ́ ndíyá, zɨ́se ndị́sịsé cigíma. Onzónɨ́ máa sɨmɨ sị́gịnị, zɨ́se ndị́sị ógụsé lúrú máa.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Née ní ꞌyị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní nɨyí úkulúgu ledre kɨ́dí, ‘Ngére, áyí kóo kɨ́ ꞌbú kɨ́ be ꞌdi bɨ zɨ́ze íꞌbí éyị́ mɨánu zɨ́yị ní, togụ́ mbú kɨ́ kodró royị́ kɨ́ be ꞌdi bɨ zɨ́ze íꞌbí iní mɨéwé zɨ́yị ní? ");
INSERT INTO bdh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Áyí kóo káa zɨ́ ꞌyị lóṇgó ꞌda bɨ zɨ́ze ꞌdíꞌbi yị́ị sɨmɨ sụmụ ní, togụ́ mbú do lerị́ bongó kɨ́ be ꞌdi bɨ zɨ́ze íꞌbí bongó zɨ́yị ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Útú kóo ndíyá togụ́ mbú onzónɨ́ yị́ị sɨmɨ sị́gịnị zɨ́ze ndéréze lúrú yị́ị ní kɨ́ be ꞌdi?’ ");
INSERT INTO bdh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ngére Yésụ nɨ úkulúgu ledre kɨ́dí, ‘Máúku zɨ́se maꞌdíi, ledre ga bɨ za mbá ndị́sịsé méngị yée zɨ́ ꞌyị amá e ga bɨ ngárá ndanɨ́ kɨ́ ledreyé owóowó wá ní, méngịsé née zɨ́ma.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nɨ úku ledre zɨ́ ꞌyị ga bɨ do sị́lị́ne ꞌbɨ ngelị ní kɨ́dí, ‘Ị́nyịsé gɨ romá íri sée ꞌyị ga bɨ Babá ndaá kɨ́ rokinyi gɨ zɨ́se wá ní. Bi esé nɨ go mongụ́ phoꞌdụ bɨ kotụ́omonɨ́ gɨ ro ngére ꞌbɨ bɨcayi lomo e kɨ́ maláyika ené e za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gɨ zɨ́a sɨmɨ bɨ mááyí kɨ́ ꞌbú ní, íꞌbísé éyị́ mɨánu zɨ́ma wá, mááyí kɨ́ kodró, íꞌbísé iní mɨéwé zɨ́ma wá, ");
INSERT INTO bdh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","sɨmɨ bɨ mááyí ꞌyị lóṇgó ní, ꞌdíꞌbisé esé máa sɨmɨ sụmụ wá, mááyí do lerị́ bongó, íꞌbísé esé bongó zɨ́ma wá. Mááyí kɨ́ ndíyá zɨ́ma kpá ídíma sɨmɨ sị́gịnị, ógụsé esé lúrú máa wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nɨyí kpá úkulúgu ledre kɨ́dí, ‘Ngére, áyí kóo kɨ́ ꞌbú togụ́ mbú kodró, zɨ́yị ídíyị ꞌyị lóṇgó ní kɨ́ be ꞌdi? Áyí kóo do lerị́ bongó togụ́ kɨ́ ndíyá, togụ́ mbú sɨmɨ sị́gịnị ní ꞌda, bɨ zɨ́ze ógụzé lúrú yị́ị wá ní?’ ");
INSERT INTO bdh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ngére nɨ úkulúgu ledre kɨ́dí, ‘Máúku zɨ́se maꞌdíi ꞌyị amá ga bɨ ledreyé ndaá owóowó wá, bɨ ngárá sákásé yée wá ní, sákásé esé kpá máa wá.’ ");
INSERT INTO bdh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Nda gɨ ore nɨyí ụ́cụ bɨsinyí ꞌyị e sɨmɨ ꞌdoꞌdó bɨ odụ a ndaá ní, tɨ́ lá bɨlámá ꞌyị e nɨyí ndéré ꞌbɨ eyé sɨmɨ rokinyi bɨ za fí ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sɨmɨ bɨ Yésụ ukuonzó ledre ga bɨ ndịsị úku yée née go mbá ní, zɨ́a ị́nyịné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Káa zɨ́ bɨ ówosé go bɨlámáne kɨ́dí sịndị́ kadra ꞌbɨ Ayímbi Umbuokpó nɨ go kɨ́lóndó sogo a re ní, née go kpá sịndị́ kadra bɨ nɨyí íꞌbí ngbángá Owụ́ ꞌbɨ ꞌYịmaꞌdí sɨmɨ a zɨ́ ezeokóga phéphéónzo wo do mɨngbúngbu kágá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kpá cịkị sɨmɨ sị́lị́ bɨ kóo née ní, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kpá kɨ́ ngíti géyị mɨngburoko ꞌyị ꞌbɨ Yụ́da e yóko royé ꞌbe ꞌbɨ ngúru mongụ́ ꞌyị ꞌdáná éyị́ kɨ́ ịrịné Kayáfa, ");
INSERT INTO bdh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","yokonɨ́ royé yéme ledre gɨ ro ꞌdíꞌbi úgu Yésụ úfu wo ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Tɨ́ lá ndazé ꞌdíꞌbi wo sɨmɨ sị́lị́ ꞌbɨ ayímbi wá, káa bɨ ꞌyị e nɨyí zíngi.” ");
INSERT INTO bdh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sɨmɨ bɨ kóo Yésụ nɨ sɨmɨ Beteníya ꞌbe ꞌbɨ ngíti oꞌdo kɨ́ ịrịné Simúna bɨ kóo kɨ́ sámá roné ní, ");
INSERT INTO bdh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","zɨ́ ngíti kára ógụné kɨ́ sụꞌbụ́ mɨndonyo bɨ ugúnɨ́ kɨ́ tụ́ꞌdụ́ késị́ ní sɨmɨ kúkú, zɨ́a dụ́dụ a mbá do Yésụ sɨmɨ bɨ nɨ mɨndị́sịné dongará ꞌyị lódụ́ kacɨ́ne e ánu éyị́ ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yésụ lurúnɨ́ kára née kɨ́ léfe sụꞌbụ́ kenée ní, zɨ́ bi sínyíne royé zɨ́ye úku ledre kɨ́dí, “Kára née lefe sinyi nda sụꞌbụ́ née bi kenée gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Zɨ́ye kpá úku ledre kɨ́dí, “Nɨyí kóo úgúóyó sụꞌbụ́ née kɨ́ tụ́ꞌdụ́ késị́ do ífi báyi a zɨ́ ꞌyị lerị́ e.” ");
INSERT INTO bdh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ndásé sínyi ịrị kára née wá, mengị bɨlámá ledre go zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ꞌYị lerị́ ga bɨ ndị́sịsé úku ledreyé née, ásé ídí kéye kacɨ́ kadra mbá, tɨ́ lá máútúásá lolụ ídí kése kacɨ́ kadra e mbá wá. ");
INSERT INTO bdh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sɨmɨ bɨ kára née lefe sụꞌbụ́ domá ní, yeme née umbumá gɨ ro óto a. ");
INSERT INTO bdh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Máúku zɨ́se maꞌdíi, kɨ́ꞌdí bɨ ꞌyị e nɨyí go ndị́sị úku bɨlámá ledre ꞌbɨ Lomo do sogo káṇgá mbá ní, ledre bɨ kára née mengị zɨ́ma née nɨyí ndị́sị úkuógụ a do ndị́sị ꞌyị sómụ́ndíki ledrea gɨ roa.” ");
INSERT INTO bdh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Zɨ́ ngúru ꞌyị lódụ́ kacɨ́ Yésụ bɨ ndịsịnɨ́ ndólo a Yụ́da Keriyóta ní ị́nyịné ndéréne zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní, ");
INSERT INTO bdh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","zɨ́a ndúꞌyú yée kɨ́dí, “Togụ́ máíꞌbíógụ wo go zɨ́se ní, éyị́ bɨ ásé íꞌbí a zɨ́ma ní ꞌdi?” Zɨ́ye ólo késị́ cị́ kéṛị́ a doa sokó íꞌbí a zɨ́ Yụ́da. ");
INSERT INTO bdh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tónóne sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ Yụ́da ndị́sịné gámásóꞌdo bɨlámá mɨsiꞌdi bɨ gɨ ro ꞌdíꞌbiógụ Yésụ doa zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sɨmɨ mɨzefị sị́lị́ ꞌbɨ Ayímbi bɨ ndịsịnɨ́ ndólo a ꞌDeꞌdị́ ndaá ní, zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ógụyé ndúꞌyú Yésụ kɨ́dí, “Íli zɨ́ze ndéréze yéme éyị́ mɨánu zɨ́yị gɨ ro Ayímbi Umbuokpó ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Ídísé ndéré zɨ́ ngíti oꞌdo sɨmɨ gara ꞌdáa zɨ́se úku ledre zɨ́a kɨ́dí, ‘ꞌYị ꞌdódo ledre uku yaá sịndị́ kadra nɨ go gbóo. Mááyí ógụ kɨ́ ꞌyị lódụ́ kacɨ́ma e ánu Ayímbi Umbuokpó zɨ́yị ꞌbe ona.’ ” ");
INSERT INTO bdh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Zɨ́ ꞌyịmɨkása ga gére née ndéréye yéme éyị mɨánu ꞌbɨ Ayímbi née íri tɨ́ káa zɨ́ bɨ Yésụ uku zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sɨmɨ bɨ nda go kɨ́ tagá ní, zɨ́ Yésụ tónóye ánu éyị́ kɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sɨmɨ bɨ nɨyí go ánu éyị́ mɨánu ní, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, ngúrusé nɨ íꞌbí ngbángáma zɨ́ ezeokóma e.” ");
INSERT INTO bdh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Zɨ́ ledre née sínyíne royé, zɨ́ye tónóye ítí kangú gɨ royé kɨ́dí, “Wo bɨ nɨ maꞌdíi ní, Ngére, ndaá ꞌbɨ ené máa wá.” ");
INSERT INTO bdh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Kpá tɨ́ akpa ngúrusé bɨ ndịsịzé ésị kótrụ sị́lị́ze kéne sɨmɨ éyị́ mɨánu ní nɨ íꞌbí ngbángáma ne. ");
INSERT INTO bdh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Owụ́ ꞌbɨ ꞌYịmaꞌdí, nɨ ndéré tɨ́ káa ledre bɨ ekénɨ́ gɨ roa ní. Tɨ́ lá mongụ́ ꞌdoꞌdó nɨ ídí zɨ́ ꞌyị bɨ nɨ íꞌbí ngbángáma Owụ́ ꞌbɨ ꞌYịmaꞌdí ní. Nɨ kóo ídí zɨ́a bɨlámáne togụ́ ndikiogụnɨ́ wo wá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zɨ́ Yụ́da bɨ nɨ iꞌbí ngbángá Yésụ ní úku ledre kɨ́dí, “Wo bɨ maꞌdíi ní, ꞌyị ꞌdódo ledre, ndaá ꞌbɨ ené máa wá.” Yésụ ya zɨ́a ní, “Tɨ́ yị́ị.” ");
INSERT INTO bdh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sɨmɨ bɨ nɨyí ndị́sị ánu éyị́ ní, zɨ́ Yésụ ꞌdíꞌbi ambata, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo gɨ roa, zɨ́a ꞌdéweífi sɨmɨ a zɨ́a íꞌbí a zɨ́ ꞌyị lódụ́ kacɨ́ne e, zɨ́a úku ledre kɨ́dí, “Ba kụṛụꞌbụmá, ídísé ꞌdíꞌbi a zɨ́se ánu a.” ");
INSERT INTO bdh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gɨ do kacɨ́ née, zɨ́a ꞌdíꞌbi kóꞌdo, do íꞌbí mbófo éyị́ gɨ roa zɨ́ Lomo, zɨ́a íꞌbí a zɨ́ye, zɨ́a úku ledre kɨ́dí, “Sée mbá ídísé éwé a.” ");
INSERT INTO bdh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Née sámamá bɨ ndeꞌyị́ bi káa do mɨyéme ledre dongaráse kɨ́ Lomo gɨ ro zɨ́a ótoómo lúyú ledre esé ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gɨ do kacɨ́ éyị́ mɨánu, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Utúasázé lolụ éwé leꞌyị́ kóṛó kése káa zɨ́ wo ba wá, gị sɨmɨ sịndị́ kadra bɨ azé éwé mɨkánda éyị́ kése ꞌbe ꞌbɨ Babá ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sɨmɨ bɨ ukunɨ́ keꞌbị ní, zɨ́ye ndéréókpóye do Landa Olíva. ");
INSERT INTO bdh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nda née ní, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Kɨ́ ndụlụ ba, ásé ási gɨ romá mbá, káa zɨ́ bɨ nɨ mɨékéne kɨ́dí, “ ‘Mááyí úfu ꞌyị ꞌbáꞌbá kábịṛị́kị e, zɨ́ kábịṛị́kị e ngásá báyi royé mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tɨ́ lá, gɨ do kacɨ́ bɨ mááyí úrú gɨ sɨmɨ umbu ní, mááyí ógụ ndéréụ́tụ romá máa ꞌdáꞌdá zɨ́se sɨmɨ káṇgá bɨ Galiláya ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Zɨ́ Pétero úkulúgu ledre zɨ́a kɨ́dí, “Abú lafúma e nɨyí ngásáómo yị́ị mbá yá, máótoómo yị́ị wá.” ");
INSERT INTO bdh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yésụ ya zɨ́a ní, “Máúku zɨ́yị maꞌdíi, kɨ́ ndụlụ ba ní, ꞌdáꞌdá zɨ́ ngono kɨ́ ụ́cụ koko, áyí ási gɨ romá kɨ́ꞌdí ota.” ");
INSERT INTO bdh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tɨ́ lá zɨ́ Pétero úkulúgu ledre kɨ́dí, “Togụ́ kpá umbu yá, máótoómo yị́ị wá.” Zɨ́ ngíti géyị lafúga ga bɨ ꞌyị lódụ́ kacɨ́ Yésụ ní uku a kpá mbá kenée. ");
INSERT INTO bdh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zɨ́ Yésụ ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ ore ndéréye sɨmɨ ngíti bi kɨ́ ịrịné Getesemáni, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Ndị́sịsé aka ona mááyí aka ndéré ꞌdáꞌdá ꞌdáa íni ini zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Zɨ́a ndólo Pétero e kɨ́ wotị́ Zebedị́ya e gbre, Yakóbo e kɨ́ Yiwáni zɨ́ye ndéréye kéye, zɨ́ sɨmɨkozo kɨ́ sómụ́ ledre tónóne méngị wo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Mááyí go kɨ́ mongụ́ lerị́ do mɨmbéꞌdemá kɨ́ngaya ꞌdówụ́ma ayí ụ́kụ́ gɨ zɨ́a geré mɨụ́kụ́. Ídísé ndị́sị kɨ́ komosé rosé.” ");
INSERT INTO bdh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Zɨ́a ndéré ꞌdóso roné cúkuꞌdée ꞌdáꞌdá kenée, zɨ́a útúlóꞌbụ komoné bi íni ini zɨ́ Lomo kɨ́dí, “Babá, togụ́ nɨ útúásáne kacɨ́ komoyị́ yá, ndá ótoómo máa zɨ́ma ꞌdóꞌdóma wá. Tɨ́ lá ndaá ídí káa zɨ́ bɨ máíli máa ní wá, idí ídí kacɨ́ mɨyéme ledre eyị́.” ");
INSERT INTO bdh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sɨmɨ bɨ ini asá ini ní, zɨ́a ndáꞌbalúgu roné zɨ́ ꞌyị lódụ́ kacɨ́ne e. Nɨ ógụ ní, nɨyí yị́ eyé go mbá ꞌdúꞌdu eyé. Zɨ́a ndúꞌyú Pétero kɨ́dí, “Útúásásé óꞌbụ rosé zɨ́se ndị́sịsé dilá kɨ́ owụ́ sịndị́ kadra kị́éꞌdo wá? ");
INSERT INTO bdh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ídísé ndị́sị íni ini zɨ́ Lomo zɨ́ komosé ídíne rosé káa bɨ ásé útú sɨmɨ lúyú ledre ke. Ílisé tɨ́ gɨ ro méngị ledre ga bɨ maꞌdíi ní, tɨ́ lá rokoꞌbụ ndaá rosé wá.” ");
INSERT INTO bdh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zɨ́a kpá ndáꞌba ándá roné íni ini káa zɨ́ gáa ꞌdáꞌdá ní kɨ́dí, “Babá, togụ́ nɨ mɨyémené gɨ ro zɨ́ma ꞌdóꞌdóma té kí yá, idí mu méngị roné káa zɨ́ bɨ íli ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sɨmɨ bɨ ndaꞌbaogụ ní, zɨ́a ndíki yée kpá mɨꞌdúꞌduyé, gɨ zɨ́a koꞌdónɨ́ gɨ zɨ́ ꞌbí go mɨkóꞌdó. ");
INSERT INTO bdh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zɨ́a kpá ndáꞌbalúgu roné íni ini zɨ́ Lomo. Née kóo go ota mɨndéré a íni ini zɨ́ Lomo, uku kpá fú ledre bɨ kị́éꞌdo ba ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zɨ́a ndáꞌbaógụné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ásé aka yị́ esé fú lá ꞌdúꞌdu ꞌdówụ́rosé? Lúrúsé go, sịndị́ kadra nɨ go gbóo do íꞌbí ngbángá Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ ꞌyị lúyú ledre e. ");
INSERT INTO bdh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ị́nyịógụsé mu zɨ́ze ndéréze. Lúrúsé aka, wo bɨ iꞌbí ngbángáma ní nɨ gɨrí go ógụ née.” ");
INSERT INTO bdh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sɨmɨ bɨ Yésụ nɨ aka cịkị ndị́sị ódro ní, zɨ́ Yụ́da bɨ ngúru ꞌyị gɨ dongará ꞌyị lódụ́ kacɨ́ Yésụ ga bɨ kóo sokó doa gbre (12) ní ógụné. Ogụnɨ́ kóo kɨ́ tụ́ꞌdụ́ ꞌyị e mbá kɨ́ mɨngburoko maku e kɨ́ ngbóndó e do sị́lị́ye. Manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ ngíti géyị mɨngburoko ꞌyị e kasanɨ́ yée ye. ");
INSERT INTO bdh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yụ́da maꞌdáa yemeomo ledre go kɨ́ye kɨ́dí, “ꞌYị bɨ mááyí ndéré geré fáka wo íꞌbí mandá zɨ́a ní, née go wo, ídísé geré ꞌdíꞌbi wo.” ");
INSERT INTO bdh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zɨ́ Yụ́da ndéréne geré mbị́ zɨ́ Yésụ, zɨ́a fáka Yésụ, íꞌbí mandá zɨ́a kɨ́dí, “ꞌYị ꞌdódo ledre, mandá zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Ezegámá, méngị ledre bɨ ógụ gɨ roa ní mu.” Geré zɨ́ ꞌyị ga gére née ógụyé ꞌdíꞌbi Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Zɨ́ ngúru ꞌyị lódụ́ kacɨ́ Yésụ lálaógụ mongụ́ maku lágá ꞌdécị mbílí ngúru ꞌyị ꞌbɨ moko ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́ e kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Ótolúgu mongụ́ maku eyị́ née do biné, gɨ zɨ́a ꞌyị ga bɨ mbá úfu ꞌyị kɨ́ mongụ́ maku ní, nɨyí úfu yée kpá kɨ́ mongụ́ maku. ");
INSERT INTO bdh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ówo eyị́ bɨ kɨ́dí, togụ́ mándólo Babá yá, nɨ geré kásaógụ tụ́ꞌdụ́ maláyika e ꞌdii sáká máa ní wá? ");
INSERT INTO bdh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tɨ́ lá togụ́ máméngị go kenée ní, ledre bɨ mɨéké kúrú Lomo uku kɨ́dí nɨ méngị roné zɨ́ma kenée ní, nɨ nda ídí káa do maꞌdíi káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zɨ́ Yésụ úku ledre zɨ́ ꞌyị ga bɨ ogụnɨ́ ꞌdíꞌbi wo née kɨ́dí, “Éyị́ bɨ ógụsé kɨ́ maku e kɨ́ ngbóndó e ꞌdíꞌbi máa gɨ roa káa zɨ́ éyị́ bɨ málúyú ledre ní ꞌdi? Mándị́sị ꞌdódo ledre sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo kacɨ́ kadra mbá ꞌdíꞌbisé máa wá gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tɨ́ lá éyị́ née mengị roné kenée gɨ ro zɨ́ ledre ga bɨ kóo nébị e ukunɨ́ yée ní ídíye maꞌdíi.” Nda née ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ngásá báyi royé mbá. ");
INSERT INTO bdh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zɨ́ ꞌyị ga bɨ ꞌdíꞌbi Yésụ ní ꞌdíꞌbi wo ndéré kɨ́e ꞌbe ꞌbɨ Kayáfa mongụ́ ꞌyị ꞌdáná éyị́ e, kɨ́ꞌdí bɨ ꞌyị ꞌdódo lorụ e kɨ́ ngíti géyị mɨngburoko ꞌyị e kotrụnɨ́ royé ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tɨ́ lá, zɨ́ Pétero útúne do kacɨ́ye gɨ gbála gị zɨ́ye ndéré ólụ́ye kɨ́ Yésụ do ligá ngbanga ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́. Zɨ́ Pétero ólụ́ne ndị́sịné dongará ꞌyị ga bɨ ndịsịnɨ́ óndó mbotụ ore ní gɨ ro lúrú ledre bɨ nɨyí ógụ méngị a kɨ́e ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ mɨngburoko ꞌyị ꞌdécị ngbanga e ndị́sịyé gámásóꞌdo ledre bɨ gɨ ro úkuóto a ro Yésụ gɨ ro zɨ́ye úfu wo gɨ roa ní. ");
INSERT INTO bdh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tɨ́ lá ndikinɨ́ eyé lúyú ledre roa wá, abú tụ́ꞌdụ́ ꞌyị e ogụnɨ́ gɨ ro trótro ledre roa kɨ́ ṛanga. Odụ a zɨ́ ꞌyị e gbre ógụyé ");
INSERT INTO bdh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","úku ledre kɨ́dí, “Oꞌdo ba úku ledre kɨ́dí, ‘Mááyí ndụ́rụ ꞌDị́cị́ ꞌbɨ Lomo, zɨ́ma ụ́bụ́lúgu a sɨmɨ sị́lị́ ota (3).’ ” ");
INSERT INTO bdh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Zɨ́ mongụ́ ꞌyị ꞌdáná éyị́ née ị́nyịné ꞌdága úku ledre zɨ́ Yésụ kɨ́dí, “Ledre ndaá tarayị́ zɨ́yị úku a kacɨ́ ledre ba wá? Úwú eyị́ ledre bɨ ꞌyị ga gére née nɨyí ndị́sị trótro a royị́ née wá?” ");
INSERT INTO bdh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tɨ́ lá Yésụ ịtị ené e wá. Zɨ́ mongụ́ ꞌyị ꞌdáná éyị́ úku ledre zɨ́a kɨ́dí, “Mándúꞌyú ba yị́ị do komo Lomo. Ídí úku maꞌdíi zɨ́ze, áyí Kɨ́résịto bɨ nɨ Owụ́ ꞌbɨ Lomo ní?” ");
INSERT INTO bdh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yésụ ya zɨ́a ní, “Ɨɨ, tɨ́ káa zɨ́ bɨ úku née. Tɨ́ lá máúku ba wo zɨ́se mbá, karanée ásé lúrú Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ndị́sị zɨ́ Lomo bɨ rokoꞌbụa ofụ go ní do anú kpá kɨ́ ógụ gɨ komo ere kpụrụ́ gɨ sɨmɨ bụṛụngụ́.” ");
INSERT INTO bdh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sɨmɨ bɨ mongụ́ ꞌyị ꞌdáná éyị́ uwú ledre née kenée ní, zɨ́a lófo bongó gɨ roné kɨ́ mɨmbéꞌdekesị́. Zɨ́a úku ledre kɨ́dí, “Uku sinyi ledre go, éyị́ bɨ ilizé ngíti géyị ꞌyị e zɨ́ye ógụyé úku ngíti ledre gɨ roa ní ndaá lolụ wá. Úwúsé tara sinyí bɨ uku née go cụ́ kɨ́ mbílíse. ");
INSERT INTO bdh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sómụ́sé ꞌbɨ esé káa be ꞌdi?” Zɨ́ye úkulúgu ledre kɨ́dí, “Utúasá go gɨ ro do úfu wo ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zɨ́ye ndị́sịyé údru súrú komo Yésụ kɨ́ útru wo kɨ́ sị́lị́ye. Ngíti géyị sembị́nɨ́ ꞌbɨ eyé kóo wo mɨsémbị́. ");
INSERT INTO bdh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kɨ́ ndị́sị ndúꞌyú wo kɨ́dí, “Bɨ úku yá née nɨ Kɨ́résịto ní, ambí ocó yị́ị née ne?” ");
INSERT INTO bdh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pétero nɨ kóo mɨndị́sịné dongará ꞌyị e do ligá kenée. Zɨ́ owụ́kára ꞌbɨ moko bɨ ore ní ógụné úku ledre zɨ́ Pétero kɨ́dí, “Málúrú káa zɨ́ áyí kpá ngúru ꞌyị bɨ kóo ndịsịnɨ́ gámá kɨ́ Yésụ bɨ gɨ sɨmɨ Galiláya ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tɨ́ lá zɨ́ Pétero ítí kangú do komoyé ore mbá kɨ́dí, “Máówo amá ledre gɨ ro ledre bɨ áyí úku a née wá.” ");
INSERT INTO bdh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zɨ́ Pétero ị́nyịné gɨ ore ndéréne tara mbotụ gara, kɨ́ꞌdí bɨ ngíti owụ́kára lurúndiki wo zɨ́a úku ledre zɨ́ ꞌyị ga bɨ íri ní gɨ ro Pétero kɨ́dí, “ꞌYị née nɨyí kóo kɨ́ Yésụ ꞌyị ꞌbɨ Nazeréta.” ");
INSERT INTO bdh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Zɨ́ Pétero lólóbụ́ kɨ́dí, “Do komo Lomo, máówo oꞌdo née wá.” ");
INSERT INTO bdh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kacɨ́ ledre ba luꞌbú kpá wá, zɨ́ ngíti géyị ꞌyị ga bɨ kóo mɨtóroyé ore ní ógụyé úku ledre zɨ́ Pétero kɨ́dí, “Maꞌdíi, áyí ngúruyé gɨ zɨ́a ndị́sị ódro káa zɨ́ ꞌyị ꞌbɨ Galiláya e ní.” ");
INSERT INTO bdh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Zɨ́a lólóbụ́ kɨ́dí, “Do komo Lomo, máówo amá oꞌdo née wá.” Geré, zɨ́ ngono ụ́cụ koko. ");
INSERT INTO bdh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Zɨ́ ledre bɨ kóo Yésụ uku zɨ́a kɨ́dí, “ꞌDáꞌdá zɨ́ ngono ụ́cụ koko, áyí ási gɨ romá kɨ́ꞌdí ota (3) ní,” geré zɨ́ ledre née ngásáógụné sɨmɨ Pétero. Gére zɨ́ sɨmɨkozo méngị wo, zɨ́a ólụ́ógụné sága ndị́sị íni ini kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nda go kɨ́ sị́ ndóndó, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ ngíti géyị mɨngburoko ꞌyị ꞌbɨ Yụ́da e ólụ́ógụyé kɨ́ ledre bɨ kɨ́dí idínɨ́ úfu Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zɨ́ye ódó Yésụ do ꞌdíꞌbi wo ndéré kɨ́e kóꞌdụ́ Piláto bɨ nɨ ne gávana ní. ");
INSERT INTO bdh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sɨmɨ bɨ Yụ́da Keriyóta bɨ iꞌbí ngbángá Yésụ owo kɨ́dí ꞌdecịnɨ́ ngbanga Yésụ go ꞌbɨ umbu ní, zɨ́ sɨmɨkozo méngị wo zɨ́a ꞌdíꞌbi késị́ bɨ kóo iꞌbínɨ́ zɨ́a cị́ kéṛị́ a doa sokó (30) ní íꞌbílúgu a zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní kɨ́ ngíti géyị mɨngburoko ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Málúyú ledre go zɨ́ma íꞌbí ngbángá ꞌyị bɨ ngárá luyú ledre wá ní.” Zɨ́ ꞌyị ga gére née úkulúgu ledre zɨ́ Yụ́da kɨ́dí, “Née ndaá lolụ ledre ezé wá, née ledre eyị́.” ");
INSERT INTO bdh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Gɨ ore zɨ́ Yụ́da ónzóóto késị́ née cịkị sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo ore do ndáꞌbané ndéré ingíonzó roné. ");
INSERT INTO bdh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní, ꞌdíꞌbi késị́ née gɨ bi, zɨ́a úku ledre kɨ́dí, “Kacɨ́ lorụ utúasánɨ́ bándáóto késị́ ba ꞌDị́cị́ ꞌbɨ Lomo ona wá gɨ zɨ́a née késị́ sáma.” ");
INSERT INTO bdh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Née ní zɨ́ye ꞌdíꞌbi késị́ née ndéréye úgú bi kɨ́e gɨ zɨ́ ꞌyị óꞌbó pheṛé gɨ ro ndị́sị óto umbu ꞌyị lóṇgó e sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Née sị́ ledre bɨ ndịsịnɨ́ ndólo bi née gɨ zɨ́a zaá gị karaba kɨ́dí Yáká Sáma ní. ");
INSERT INTO bdh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zɨ́ ledre bɨ kóo nébị Yeremáya uku ní ídíne maꞌdíi, “Zɨ́ye ꞌdíꞌbi komo késị́ bɨ kóo cị́ kéṛị́ a doa sokó (30), née késị́ bɨ ꞌyị ꞌbɨ Isɨréle e ṇguṇgunɨ́ ledre a íꞌbí a gɨ roa ní, ");
INSERT INTO bdh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","zɨ́ye ꞌdíꞌbi késị́ née ndéréye úgú bi kɨ́e gɨ zɨ́ ꞌyị óꞌbó pheṛé káa zɨ́ bɨ Ngére Lomo uku zɨ́ma ní.” ");
INSERT INTO bdh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sɨmɨ bɨ ogụnɨ́ kɨ́ Yésụ kóꞌdụ́ Gávana Piláto ní, zɨ́a ndúꞌyú Yésụ kɨ́dí, “Áyí mongụ́ ngére ꞌbɨ Yụ́da e?” Yésụ ya zɨ́a ní, “Ɨɨ, nɨ kpá tí káa zɨ́ bɨ úku née.” ");
INSERT INTO bdh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sɨmɨ bɨ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ mɨngburoko ꞌyị ꞌbɨ Yụ́da e ukuotonɨ́ ledre roa ní, ịtị ené wá. ");
INSERT INTO bdh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Zɨ́ Piláto kpá ndúꞌyú Yésụ kɨ́dí, “Úwú eyị́ ledre bɨ nɨyí ndị́sị trótro a royị́ née wá?” ");
INSERT INTO bdh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tɨ́ lá Yésụ ịtị wá, uku gbawá bɨkéṛị́ ledre kacɨ́ ledre bɨ ukuotonɨ́ roa ní. Zɨ́ tara Piláto ị́drị́ne gɨ zɨ́ ledre née mɨị́drị́ kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kadra Ayímbi Umbuokpó e mbá, gávana ndịsị lengbe ótoómo kémbị́ ꞌyị gɨ sɨmɨ sị́gịnị wo bɨ tụ́ꞌdụ́ ꞌyị e gelénɨ́ go mbá wo ní. ");
INSERT INTO bdh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sɨmɨ sịndị́ kadra máa née ní, ngíti oꞌdo nɨ kóo bo sɨmɨ sị́gịnị ore ꞌyị méngị bɨsinyí ledre kɨ́ ịrịné Barába. ");
INSERT INTO bdh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Née ní sɨmɨ bɨ Piláto ndúꞌyú tụ́ꞌdụ́ ꞌyị ga bɨ kotrụnɨ́ royé ní kɨ́dí, “ꞌYị bɨ ílisé zɨ́ma ótoómo wo zɨ́se gɨ sɨmɨ sị́gịnị ní náambi, Barába togụ́ mbú Yésụ bɨ ndịsịnɨ́ ndólo wo yaá Kɨ́résịto ní?” ");
INSERT INTO bdh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gɨ zɨ́a Piláto owo bú kɨ́dí Yụ́da e otonɨ́ bɨsinyí mɨmbéꞌdeyé ro Yésụ gbékpị́ne zɨ́ye ógụyé kɨ́e kóꞌdụ́ne ní. ");
INSERT INTO bdh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sɨmɨ bɨ Piláto nɨ mɨndị́sịné do kị́tị ngére ené ní, zɨ́ meꞌbea kákasa zɨ́a kɨ́dí, “Ndá óto sị́lị́yị ro oꞌdo bɨ luyú ené ledre wá née wá, gɨ zɨ́a bɨsinyí ꞌduru ogụ ándá roné go domá gɨ ro ledre ené.” ");
INSERT INTO bdh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tɨ́ lá zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ mɨngburoko ꞌyị ꞌbɨ Yụ́da e ꞌdíꞌbi do tụ́ꞌdụ́ ꞌyị ga gére née kɨ́ ledre kɨ́dí idínɨ́ úku ledre gɨ ro do ótoómo Barába, do úfu Yésụ ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Zɨ́ gávana kpá ndúnduꞌyú kɨ́dí, “ꞌYị ga bɨ gbre ba, ꞌyị bɨ ílisé zɨ́ma ótoómo wo zɨ́se ní náambi?” Zɨ́ ꞌyị e ị́nyịyé mbá úkulúgu ledre zɨ́a kɨ́dí, “Barába.” ");
INSERT INTO bdh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Zɨ́ Piláto ndúnduꞌyú kɨ́dí, “Sara máídí nda méngị kɨ́ Yésụ bɨ ndịsịnɨ́ kpá ndólo wo Kɨ́résịto ní go ꞌdi?” Zɨ́ye ị́nyịyé mbá úkulúgu ledre kɨ́dí, “Ídí phéphéónzo wo do mɨngbúngbu kágá.” ");
INSERT INTO bdh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Zɨ́ Piláto ndúꞌyú yée kɨ́dí, “Gɨ ro ꞌdi? Ledre bɨ luyú wo ní ꞌdi?” Tɨ́ lá zɨ́ tụ́ꞌdụ́ ꞌyị ga gére gbúrógbó tátá royé nda ꞌdáꞌdá kɨ́dí, “Ídí phéphéónzo wo do mɨngbúngbu kágá.” ");
INSERT INTO bdh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sɨmɨ bɨ Piláto lurú ꞌyị e ayínɨ́ yị́ eyé go zíngi eyé, mbị́ éyị́ bɨ zɨ́ne méngị a ní ndaá ní, zɨ́a ꞌdíꞌbi iní lúgu sị́lị́ne kɨ́e do komoyé ore. Zɨ́a úku ledre kɨ́dí, “Mɨsiꞌdi umbu oꞌdo née ndaá do sị́lị́ma wá. Née yị́ ené ledre esé.” ");
INSERT INTO bdh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Zɨ́ ꞌyị e ị́nyịyé mbá úkulúgu ledre kɨ́dí, “Sáma a idí ndáꞌba dozé kɨ́ owụ́ ꞌbɨ ezé e.” ");
INSERT INTO bdh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gɨ ore zɨ́a ꞌdíꞌbiógụ Barába gɨ sɨmɨ sị́gịnị. Zɨ́a ꞌdíꞌbiógụ Yésụ ócó wo, do ótoómo wo zɨ́ye ndéréye kɨ́e phéphé wo do mɨngbúngbu kágá. ");
INSERT INTO bdh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Zɨ́ asikíri ga bɨ ꞌbɨ gávana ní ꞌdíꞌbi Yésụ ndéré kɨ́e sɨmɨ mongụ́ bi eyé ꞌbɨ asikíri e zɨ́ye yóko royé mbá cigí a íri. ");
INSERT INTO bdh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Zɨ́ye íꞌdíógụ bongó ꞌbɨ Yésụ gɨ roa ꞌdáꞌba do ésị mongụ́ ngbángbá bongó eyé ꞌbɨ asikíri e roa, ");
INSERT INTO bdh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","do kụ́ṛókụ́ kị́nị káa do komụ́ ésị a ro doa. Zɨ́ye íꞌbí ngbángbá do sị́lị́a káa zɨ́ ꞌbɨ ngére ní. Do ndị́sịyé útúye do ngụ́ṛụ́ sịndị́ye fólo wo kɨ́dí, “Ba, mongụ́ ngére ꞌbɨ Yụ́da e.” ");
INSERT INTO bdh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Zɨ́ye ndị́sịyé údru súrú roa, do ꞌdíꞌbi ngbángbá bɨ gɨ do sị́lị́a née ndị́sịyé ócó wo kɨ́e ro doa. ");
INSERT INTO bdh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sɨmɨ bɨ folo asánɨ́ wo go ní, zɨ́ye íꞌdíógụ mongụ́ ngbángbá bongó bɨ gáa roa ní, zɨ́ye ésịlúgu bongó máa ꞌbɨ ené ní roa. Zɨ́ye ꞌdíꞌbi wo ndéréye kɨ́e phéphé wo do mɨngbúngbu kágá. ");
INSERT INTO bdh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sɨmɨ mɨndéréye, zɨ́ye ndíkíye kɨ́ ngíti oꞌdo do mɨsiꞌdi kɨ́ ịrịné Simúna ndịsị ógụ gɨ sɨmɨ gara bɨ kɨ́ ịrịné Kuréne ní. Zɨ́ye gága oꞌdo née ị́mbị́ mɨngbúngbu kágá ꞌbɨ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Zɨ́ye ndéréógụyé do landa bɨ ndịsịnɨ́ ndólo a Gologóta bɨ ini ledre gɨ sɨmɨ a kɨ́dí, “Cóngó doꞌyị ní.” ");
INSERT INTO bdh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sɨmɨ bɨ nderéogụnɨ́ do landa née íri ní, zɨ́ye íꞌbí leꞌyị́ kóṛó bɨ lefenɨ́ kágá sɨmɨ a ní zɨ́ Yésụ idí éwé a gɨ zɨ́ okó éyị́ mɨówo. Tɨ́ lá sɨmɨ bɨ ewéuzu ní, zɨ́a ási ené kɨ́ éwé a. ");
INSERT INTO bdh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sɨmɨ bɨ phephénɨ́ wo go do mɨngbúngbu kágá ní, zɨ́ye ónzó gbégbé ífi báyi bongó ené e kɨ́e dongaráye. ");
INSERT INTO bdh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Zɨ́ asikíri ga gére née ndéré ndị́sịyé bi ndị́sị lúrúkása wo. ");
INSERT INTO bdh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Zɨ́ye ékéóto ledre bɨ ufunɨ́ wo gɨ roa ní gá doa ꞌdága kɨ́dí, BA YÉSỤ, MONGỤ́ NGÉRE ꞌBƗ YỤ́DA E. ");
INSERT INTO bdh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Phephénɨ́ kóo kpá ꞌyị ugu e gbre kéne sɨmɨ sịndị́ kadra máa née. Kémbị́ a do sị́lị́ Yésụ ꞌbɨ anú, ngíti a do ngelị. ");
INSERT INTO bdh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ndéré kacɨ́ mɨsiꞌdi gɨ ore ní ndị́sịyé úku sínyi ledre zɨ́ Yésụ, kpá kɨ́ ndị́sị lágá doyé, ");
INSERT INTO bdh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kɨ́ ndị́sị úku ledre zɨ́a kɨ́dí, “Úku yaá née nɨ ógụ ndụ́rụ ꞌDị́cị́ ꞌbɨ Lomo zɨ́ne ụ́bụ́lúgu a sɨmɨ sị́lị́ ota, togụ́ áyí tɨ́ Owụ́ ꞌbɨ Lomo maꞌdíi yá, ídí mu yómo royị́, zɨ́yị ndítíógụyị́ gɨ do mɨngbúngbu kágá gɨrí bi yáa.” ");
INSERT INTO bdh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní kɨ́ ꞌyị ꞌdódo lorụ e nda kɨ́ mɨngburoko Yụ́da e ndị́sịyé fólo wo kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Nɨ ꞌyị yómo ꞌyị e, tɨ́ lá utúasá yómo roné wá gɨ zɨ́ ꞌdi? Nɨ kpá mongụ́ ngére ꞌbɨ Isɨréle e. Idí mu ndítíógụ gɨ do mɨngbúngbu kágá gɨrí, zɨ́ze ṇgúṇgu ledrea. ");
INSERT INTO bdh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ndịsị úku ledre kɨ́dí, ‘Mááyí Owụ́ ꞌbɨ Lomo.’ Née nɨ ꞌyị bɨ ṇguṇgu ledre ꞌbɨ Lomo go ní. Lomo idí mu yómo wo cakaba togụ́ Lomo ili wo bú ní.” ");
INSERT INTO bdh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kpá kenée, gba ꞌyị ugu ga bɨ phephénɨ́ yée kéye ní, zɨ́ye kpá ndị́sịyé ụ́ṛụ́ kese doa. ");
INSERT INTO bdh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nda gɨ ore née ní, nɨ ndéréógụ kɨ́ yana kadra ní, zɨ́ mụtụlụrụ útúne sɨmɨ gara ore mbụụ́ bi oṇgó wá zaá gị sɨmɨ sịndị́ kadra ota kɨ́ tagá. ");
INSERT INTO bdh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sɨmɨ sịndị́ kadra ota (3) kɨ́ tagá née ní, zɨ́ Yésụ gbúrógbóne ꞌdága kɨ́dí, “Ilóyi, Ilóyi, Lị́ma sabákatani?” Ledre gɨ sɨmɨ a kɨ́dí, “Lomo amá, Lomo amá, ótoómo máa gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sɨmɨ bɨ ngíti géyị ꞌyị ga bɨ nɨyí mɨtóroyé ore uwúnɨ́ ledre ba ní, zɨ́ye úku ledre kɨ́dí, “Nɨ go ndólo Ilíya.” ");
INSERT INTO bdh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Zɨ́ ngíti ꞌyị gɨ dongará ꞌyị ga bɨ gáa ore ní geré ngásáne ꞌdíꞌbi katúu. Zɨ́a ónzó a bu sɨmɨ mɨndogó leꞌyị́ kóṛó do ésịóto a do kágá ndéré kɨ́e óto a tara Yésụ gɨ ro zɨ́a mbụ́lụ́ a. ");
INSERT INTO bdh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Zɨ́ ngíti géyị ꞌyị e úku ledre kɨ́dí, “Idízé ótoómo wo ngúcuné. Zɨ́ze aka lúrú a togụ́ Ilíya nɨ ógụ yómo wo yá.” ");
INSERT INTO bdh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gɨ do kacɨ́ bɨ Yésụ gbúrógbó andá kpá roné kɨ́ kúrúne ꞌdága ní, zɨ́a ótoómo ꞌdówụ́ne. ");
INSERT INTO bdh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sɨmɨ sịndị́ kadra bɨ kóo née, zɨ́ mongụ́ mbílí bongó bɨ ingí ꞌdecịnɨ́ sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo kɨ́e ní, lófo ífi sɨmɨné gberé gbre kú gɨ ꞌdága gị bi. Zɨ́ do sogo káṇgá kị́zịné landa e kɨ́ ífi báyi sɨmɨyé. ");
INSERT INTO bdh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Zɨ́ bi ga bɨ zɨ́ ꞌyị ga bɨ kóo uyunɨ́ go ꞌdesị́ ní ndókoyé. Zɨ́ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ní úrúye gɨ sɨmɨ umbu do ídíye trịdrị. ");
INSERT INTO bdh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Zɨ́ye ólụ́ógụyé gɨ sɨmɨ bi. Nda gɨ do kacɨ́ a bɨ Yésụ urú gɨ sɨmɨ umbu ní, zɨ́ ꞌyị ga gére née ndáꞌbalúgu royé sɨmɨ Yerụsaléma zɨ́ tụ́ꞌdụ́ ꞌyị e lúrú yée cụ́ kɨ́ komoyé trịdrị. ");
INSERT INTO bdh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sɨmɨ bɨ mongụ́ ꞌyị ꞌbɨ asikíri e kɨ́ asikíri ené ga bɨ ndịsịnɨ́ óndó Yésụ sɨmɨ bi bɨ otonɨ́ wo sɨmɨ a lurúnɨ́ kịꞌdị káṇgá kɨ́ ledre ga bɨ mengịnɨ́ royé mbá ní, zɨ́ ngịrị útúne sɨmɨyé kɨ́ngaya, zɨ́ye úku ledre kɨ́dí, “Maꞌdíi, nɨ yị́ ené tɨ́ Owụ́ ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tụ́ꞌdụ́ kará ga bɨ ogụnɨ́ kɨ́ Yésụ gɨ sɨmɨ káṇgá bɨ Galiláya ndị́sịyé sáká wo kɨ́ éyị́ bɨ ili ní, nɨyí kóo mɨtóroyé ndị́sị lúrú kasa bi gɨ gbála. ");
INSERT INTO bdh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dongará kará ga gére née kóo Maríya bɨ gɨ sɨmɨ gara bɨ kɨ́ ịrịné Magɨdála ní, Maríya bɨ mbágá Yakóbo e kɨ́ Yoséfa, nda kɨ́ mbágá Yakóbo e kɨ́ Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nɨ ndéréógụ kɨ́ tagá ní, zɨ́ ngíti oꞌdo kɨ́ ịrịné Yoséfa nɨ ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ zɨ́ne ní ógụné gɨ sɨmɨ gara bɨ ndịsịnɨ́ ndólo a Aramatáyo ní. Nɨ ngúru ꞌyị lódụ́ kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Zɨ́a ndéréne ndúꞌyú Piláto idí ṇgúṇgu a zɨ́ne ꞌdíꞌbi umbu Yésụ ndéré óto a. Zɨ́ Piláto úku ledre do íꞌbí umbu Yésụ zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zɨ́ Yoséfa ꞌdíꞌbi umbu Yésụ yeme a sɨmɨ bɨlámá bɨkenyị́ mbílí bongó, ");
INSERT INTO bdh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ndéré kɨ́e óto a sɨmɨ mɨkánda bi ené bɨ iciomo gɨ roné sɨmɨ landa ní. Zɨ́a gbụ́ṛụ́gbụóto mongụ́ mɨsɨsɨlekpe tutú ngbụtụrụ́ tara bi maꞌdáa do ndéréókpóne. ");
INSERT INTO bdh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maríya bɨ gɨ sɨmɨ Magɨdála nda kɨ́ ezené Maríya nɨyí kóo mɨndị́sịyé íri re kenée ndị́sị lúrú kása bi máa née. ");
INSERT INTO bdh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kɨ́lóndó a née kóo Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní kɨ́ Farụsáyo e ị́nyịyé ndéréye zɨ́ Piláto. ");
INSERT INTO bdh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Zɨ́ye úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ledre bɨ ꞌyị ṛanga ba uku sɨmɨ bɨ kóo nɨ aka trịdrị ní ngásáógụ go sɨmɨzé. Uku kóo ledre kɨ́dí, ‘Née nɨ úyu, gɨ do kacɨ́ sị́lị́ ota zɨ́ne úrúne.’ ");
INSERT INTO bdh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Idí kása asikíri e zɨ́ye ndéré ndị́sịyé sị́ bi íri óndó bi kɨ́ sị́lị́ ota (3) káa bɨ ꞌyị lódụ́ kacɨ́ga nɨyí ógụ úgu umbua zɨ́ye úku a zɨ́ ꞌyị e kɨ́dí urú go gɨ sɨmɨ umbu. Ṛanga máa wo née nɨ nda áṇga zɨ́a sínyíne rómo gɨ do yée ga bɨ kóo ꞌdáꞌdá ní za mbá.” ");
INSERT INTO bdh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Zɨ́ Piláto úku ledre zɨ́ye kɨ́dí, “ꞌDíꞌbisé asikíri e mu zɨ́se ndérése óto yée ndị́sị óndó bi née zaá bɨlámáne káa zɨ́ bɨ ásé ówo kacɨ́ a ní.” ");
INSERT INTO bdh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Née ní zɨ́ yaꞌdá ga gére née ndéréye sị́ bi. Zɨ́ye kúṛúṛu ꞌdụ́tụ tara bi née kuṛí, do ꞌdíꞌbióto asikíri e íri ndị́sị óndó a. ");
INSERT INTO bdh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Akpa kɨ́ sị́ ndóndó sɨmɨ sị́lị́ gɨ do kacɨ́ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Maríya Magɨdála kɨ́ ezené Maríya ị́nyịyé ndéréye sị́ bi. ");
INSERT INTO bdh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ꞌDiya káa ní, zɨ́ mongụ́ kịꞌdị káṇgá méngị roné, zɨ́ maláyika ꞌbɨ Ngére Lomo ógụné gɨ komo ere gbụ́ṛụ́gbụóyó tutú bɨ otonɨ́ ngbụtụrụ́ tara mbotụ bi bɨ zɨ́ Yésụ ní ꞌdáꞌba, do ndị́sịné gá do tutú née. ");
INSERT INTO bdh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Zɨ́ sɨmɨ komo maláyika née ndị́sị ṛíṛíne ganya ganya ganya káa zɨ́ mɨꞌbɨ́léꞌbe iní ní, zɨ́ bongó bɨ roa ní ídíne bɨkenyị́ne kpɨ́lélé. ");
INSERT INTO bdh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Zɨ́ asikíri ga bɨ otonɨ́ yée ndị́sị ꞌbáꞌbá bi née ní ní, zɨ́ royé úyuné za mbá mɨúyu gɨ zɨ́ ngịrị, zɨ́ye ídíye káa zɨ́ éyị́ bɨ uyunɨ́ go mɨúyu ní. ");
INSERT INTO bdh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Zɨ́ maláyika née úku ledre zɨ́ kará ga gére née kɨ́dí, “Ndásé esé éré ngịrị wá. Máówo bú kɨ́dí ndị́sịsé gámásóꞌdo umbu Yésụ bɨ phephéonzónɨ́ wo do mɨngbúngbu kágá ní. ");
INSERT INTO bdh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ndaá ꞌbɨ ené lolụ ona wá, urú yị́ ené go káa zɨ́ bɨ kóo uku zɨ́se ní. Ógụsé mu lúrú bi kacɨ́ a kɨ́ꞌdí bɨ kóo otonɨ́ wo ní. ");
INSERT INTO bdh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ndérésé mu ꞌdiꞌdiya úku a zɨ́ ꞌyị lódụ́ kacɨ́ga kɨ́dí, ‘Urú yị́ ené gɨ sɨmɨ umbu go, ndéréókpó go zɨ́se ꞌdáꞌdá íri sɨmɨ káṇgá bɨ Galiláya ní. Ásé ndéré ndíki wo íri.’ Née ledre bɨ mááyí úku a zɨ́se ní.” ");
INSERT INTO bdh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gɨ ore zɨ́ kará ga gére née gbúgbuógụyé gɨ sɨmɨ bi gɨrí abú kɨ́ ngịrị royé yá, mɨmbéꞌdeyé nɨ mɨꞌdúcuné kɨ́ mongụ́ rokinyi. Zɨ́ye ngásáye úku ledre née zɨ́ ꞌyị lódụ́ kacɨ́ga. ");
INSERT INTO bdh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ꞌDiya káa ní zɨ́ Yésụ ndíkíye kɨ́ kará ga gére née. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Mandá zɨ́se.” Zɨ́ kará ga gére née ógụyé gbóo cigí a do útúye sị́ sịndị́a óto úndrua. ");
INSERT INTO bdh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ndásé éré ngịrị wá. Ndérésé mu úku a zɨ́ ꞌyị lódụ́ kacɨ́ma e, zɨ́ye ndéréye sɨmɨ Galiláya, nɨyí ógụndíki máa íri.” ");
INSERT INTO bdh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sɨmɨ bɨ kará ga gére née nɨyí do mɨsiꞌdi mɨndéréye ní, zɨ́ asikíri ga bɨ otonɨ́ yée ndị́sị óndó bi bɨ zɨ́ Yésụ ní ị́nyịyé ndéréye sɨmɨ gara úku ledre ga bɨ mengịnɨ́ royé íri ní mbá zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní. ");
INSERT INTO bdh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sɨmɨ bɨ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e yóko royé kɨ́ ngíti géyị mɨngburoko ꞌyị eyé e yéme ledre bɨ yée nɨyí méngị a ní, zɨ́ye úgú komo asikíri ga gére née kɨ́ tụ́ꞌdụ́ késị́, ");
INSERT INTO bdh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","zɨ́ye úku ledre zɨ́ye kɨ́dí, “ídísé úku a zɨ́ ꞌyị e kɨ́dí, ‘ꞌYị lódụ́ kacɨ́ga ogụnɨ́ kɨ́ ndụlụna zɨ́ye úgu umbua sɨmɨ bɨ ásé ꞌdúꞌdu ní.’ ");
INSERT INTO bdh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Togụ́ gávana nɨ úwú ledre née yá, azé ódro zɨ́a utúasá méngị sée bɨsinyíne wá.” ");
INSERT INTO bdh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gɨ ore zɨ́ asikíri e ꞌdíꞌbi késị́ née, zɨ́ye méngị a tɨ́ káa zɨ́ bɨ ukunɨ́ zɨ́ye ní. Zɨ́ phanda ledre née áṇgané tɨ́ kadra née dongará Yụ́da e ore mbá. ");
INSERT INTO bdh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nda gɨ ore zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ga bɨ sokó doa kị́éꞌdo ní ị́nyịyé ndéréye sɨmɨ Galiláya do landa bɨ Yésụ uku ledre a zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sɨmɨ bɨ ogụndikinɨ́ wo íri, zɨ́ye óto úndrua, tɨ́ lá ledre née utúasá ené kacɨ́ komo ngíti géyị ꞌyị lódụ́ kacɨ́ga wá. ");
INSERT INTO bdh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zɨ́ Yésụ nda go ógụné za gbóo cigíye zɨ́a úku ledre zɨ́ye kɨ́dí, “Babá iꞌbí úndru ledre ga bɨ komo ere kɨ́ yée ga bɨ do sogo káṇgá ona ní go mbá zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bɨ kenée ní, ídísé mu ndéré zɨ́ kúfú ꞌyị e za mbá, zɨ́se óyólóꞌbó yée káa do ꞌyị lódụ́ kacɨ́ma e, zɨ́se bábátị́zị́ yée kɨ́ ịrị ꞌBụ, kɨ́ ịrị Owụ́, nda kɨ́ ꞌDówụ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ídísé ꞌdódo ledre zɨ́ye idínɨ́ óto úndru ledre ga bɨ máúku yée zɨ́se ní mbá. Maꞌdíi mááyí ídí kése kacɨ́ kadra mbá zaá gị sɨmɨ bɨ mááyí ndáꞌbaógụ do sogo káṇgá ona ní.”");
INSERT INTO bdh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ba dosị́ bɨlámá ledre gɨ ro Kɨ́résịto Yésụ Owụ́ ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nɨ káa zɨ́ bɨ kóo nébị Isáya eké kɨ́dí, “Mááyí kása ꞌyị kasa amá zɨ́yị ꞌdáꞌdá, gɨ ro zɨ́a yémeómo mɨsiꞌdi zɨ́yị nzíyiné.” ");
INSERT INTO bdh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“ꞌYị nɨ karanée ndị́sị ótrụ́ ledre zɨ́ ꞌyị e sɨmɨ súwú kɨ́dí, yémeómosé mɨsiꞌdi mu nzíyiné zɨ́ Ngére, ídísé ꞌdózo yéme mɨsiꞌdi zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zɨ́ Yiwáni ógụ ndị́sịné sɨmɨ súwú ndị́sị úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e kɨ́dí, “Ídísé ṇgúṇgu ledre ꞌbɨ Lomo zɨ́se óyólóꞌbó mɨmbéꞌdesé do bábátị́zị́ sée gɨ ro zɨ́ Lomo ótoómo lúyú ledre esé e.” ");
INSERT INTO bdh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zɨ́ tụ́ꞌdụ́ ꞌyị e gɨ do bi e mɨngúngúcua, ngíti géyị gɨ sɨmɨ káṇgá bɨ Yụdáya ní kɨ́ tụ́ꞌdụ́ ngíti géyị gɨ sɨmɨ Yerụsaléma ndéréye zɨ́ Yiwáni. Zɨ́ye úkuógụ lúyú ledre eyé e, zɨ́a bábátị́zị́ yée sɨmɨ ngbuṛu bɨ Yeredéne ní. ");
INSERT INTO bdh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yiwáni esị kóo roné bongó bɨ uꞌyúnɨ́ gɨ sɨmɨ bị bangá bɨ gémele ní, zɨ́a ódó roné káꞌdá bɨ yemenɨ́ gɨ sɨmɨ saná ní, éyị́ mɨánu ené nɨ kóo mbíra kɨ́ tezị. ");
INSERT INTO bdh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Zɨ́a kóo kpá úku ledre kɨ́dí, “ꞌYị bɨ nɨ ógụ gɨ do kacɨ́ma ní, rokoꞌbụa romo do ꞌbɨ amá go kɨ́ngaya. Máútúásá gbawá ídíma káa do ꞌyị líkpí káꞌdá wará ené gɨ ro íꞌdíógụ a gɨ sịndị́a. ");
INSERT INTO bdh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Máíꞌbí babatị́za zɨ́se lá kɨ́ iní, nɨ íꞌbí ꞌbɨ ené zɨ́se babatị́za bɨ kɨ́ ꞌDówụ́ Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ Yésụ ógụné gɨ sɨmɨ gara bɨ Nazeréta sɨmɨ káṇgá bɨ Galiláya ní, zɨ́ Yiwáni bábátị́zị́ wo sɨmɨ ngbuṛu bɨ Yeredéne ní. ");
INSERT INTO bdh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sɨmɨ bɨ Yésụ nɨ nda go ólụ́ógụ gɨ sɨmɨ iní ní, zɨ́a lúrú ere likpí roné go, zɨ́ ꞌDówụ́ Lomo ógụné doa pá pá pá pá káa zɨ́ kị́ṛịkóꞌdo ní. ");
INSERT INTO bdh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Geré zɨ́ kúrú ówụ́ne zɨ́a gɨrí kɨ́dí, “Áyí Owụ́ ꞌbɨ amá ꞌbúyị ofụ domá go. Mááyí kɨ́ rokinyi gɨ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gɨ ore geré, zɨ́ ꞌDówụ́ Lomo, ꞌdíꞌbi wo ndéré kɨ́e gbála sɨmɨ súwú, ");
INSERT INTO bdh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","zɨ́a ndị́sịné íri kɨ́ sị́lị́ cị́ gbre, zɨ́ Satána ndị́sịné úzu wo. Bangá súwú e nɨyí kóo kpá kɨ́ye íri. Zɨ́ ngíti géyị maláyika e ndị́sịyé sáká wo. ");
INSERT INTO bdh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gɨ do kacɨ́ bɨ Eróde ónzó Yiwáni sɨmɨ sị́gịnị ní, zɨ́ Yésụ ị́nyịné ndéréne sɨmɨ Galiláya, zɨ́a úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị e íri kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Sịndị́ kadra nɨ go gbóo gɨ ro zɨ́ Lomo ídíne Ngére esé. Ídísé mu ṇgúṇgu bɨlámá ledre ꞌbɨ Lomo zɨ́se ótoómo bɨsinyí ledre e mbá ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kadra kị́éꞌdo, zɨ́ Yésụ ị́nyịné ndéréne do gbúṛóngó mɨkavu Galiláya, zɨ́a lúrúndíki Simúna e kɨ́ lúnduné Andiríya, kɨ́ ónzó mbírá eyé sɨmɨ iní gɨ zɨ́a nɨyí yị́ eyé ꞌyị ꞌdíꞌbi kénzé e. ");
INSERT INTO bdh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zɨ́a úku ledre zɨ́ye, kɨ́dí, “Ógụsé mu lódụ́ kacɨ́ma, zɨ́ma ꞌdódo ledre zɨ́se, gɨ ro zɨ́se ídíse ꞌyị ꞌdíꞌbiógụ ꞌyị e, ndaá lolụ ꞌyị ꞌdíꞌbi kénzé wá.” ");
INSERT INTO bdh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Geré zɨ́ye ótoómo mbírá gɨ do sị́lị́ye zɨ́ye lódụ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zɨ́a ndéréókpóne gɨ ore lá cúkuꞌdée, zɨ́a lúrúndíki wotị́ Zebedị́ya, Yakóbo e kɨ́ lúnduné Yiwáni sɨmɨ kuṛúngba, ndịsịnɨ́ tóko komo mbírá eyé. ");
INSERT INTO bdh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sɨmɨ bɨ Yésụ lurúndiki yée ní, zɨ́a ndólo yée. Zɨ́ye ótoómo ꞌbụyé Zebedị́ya e, kɨ́ ꞌyị ꞌbɨ moko eyé e sɨmɨ kuṛúngba ore, zɨ́ye útúye do kacɨ́ Yésụ, yóó zɨ́ye ndéréókpóye. ");
INSERT INTO bdh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zɨ́ye ndéréógụyé sɨmɨ ngíti gara sɨmɨ Galiláya bɨ kɨ́ ịrịné Kapáranawúma ní. Nda sɨmɨ ngíti Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ye ólụ́ye ꞌDị́cị́ Kótrụro, zɨ́ Yésụ ndị́sịné ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Zɨ́ tara ꞌyị ga bɨ uwúnɨ́ ꞌdódo ledre ené ní ị́drị́ne mbá mɨị́drị́, gɨ zɨ́a mɨꞌdódo ledre ené nɨ kóo kɨ́ rokoꞌbụné, ndaá ꞌbɨ ené kóo káa zɨ́ ꞌbɨ ꞌyị ꞌdódo lorụ ꞌbɨ Mụ́sa wá. ");
INSERT INTO bdh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, ngíti oꞌdo nɨ kóo kpá bo sɨmɨ ꞌDị́cị́ Kótrụro ore nɨ kɨ́ dokéké sɨmɨné. Zɨ́a tónóne íni ini, zɨ́a ị́nyịné úku ledre zɨ́ Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yị́ị, ꞌyị ꞌbɨ Nazeréta ba, éyị́ bɨ íli gɨ zɨ́ze ní ꞌdi? Ógụ kɨ́ra go gɨ ro úfuónzó zée? Máówo yị́ị bú. Áyí Yésụ, Mbigí Owụ́ ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zɨ́ Yésụ úku ledre zɨ́ dokéké née cụ́ kɨ́ sɨmɨné kɨ́dí, “Ídí ndécị́ tí, ólụ́ógụ gɨ sɨmɨ oꞌdo née mu” ");
INSERT INTO bdh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zɨ́ dokéké kángba oꞌdo née bɨsinyíne, zɨ́a óto wo ndị́sị lángbané zi zi zi. Zɨ́ dokéké gbúrógbóne ꞌdága sɨmɨ oꞌdo née íri, ábuwá née go mɨólụ́ógụ a. ");
INSERT INTO bdh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Zɨ́ ledre née lụ́tụ́ne komo ꞌyị e za mbá, zɨ́ye tónóye úku ledre dongaráye kɨ́dí, “Bɨ káa ꞌbɨé ledre ꞌdi? ꞌBɨé mɨkánda ledre? Oꞌdo ba iꞌbí lorụ zɨ́ dokéké e zɨ́ye tɨ́ úwú kúrúa.” ");
INSERT INTO bdh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Zɨ́ phanda ledre bɨ Yésụ mengị née áṇgané sɨmɨ Galiláya za mbá. ");
INSERT INTO bdh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sɨmɨ bɨ olụ́ogụnɨ́ gɨ sɨmɨ ꞌDị́cị́ Kótrụro ní, zɨ́ye ndéréye kɨ́ Yakóbo e kɨ́ Yiwáni ꞌbe ꞌbɨ Simúna e kɨ́ Andiríya. ");
INSERT INTO bdh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nɨyí ndéréógụ íri ní, towụ́ Simúna kára ꞌyị nɨ mɨꞌdúꞌduné bi, gɨ zɨ́a roa ịrị́ mɨị́rị́. Zɨ́ye ị́nyịyé úku ledrea zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zɨ́ Yésụ ndéré ꞌdíꞌbi sị́lị́a, lálasị́kpị wo ꞌdága. Geré zɨ́ sɨmɨ saná kára née zázáne, zɨ́a méngị éyị́ mɨánu zɨ́ Yésụ kɨ́ ꞌyị ené e. ");
INSERT INTO bdh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nda go kɨ́ tagá, zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụyé kɨ́ ꞌyị ndíyá eyé e kpá kɨ́ yée ga bɨ kɨ́ dokéké e sɨmɨyé ní zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Zɨ́ ꞌyị ga bɨ ꞌbɨ gara née yóko royé tụ́ꞌdụ́ tara mbotụ ꞌdị́cị́ bɨ Yésụ nɨ sɨmɨ a ní, ");
INSERT INTO bdh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","zɨ́a ꞌdíꞌbióyó ṛị́kị́ ndíyá eyé e gɨ royé mbá. Yée ga bɨ kɨ́ dokéké e sɨmɨyé ní, zɨ́a lágaóyó yée gɨ sɨmɨyé mbá, zɨ́a ụ́cụómo dokéké ga gére née ndanɨ́ ódro wá, gɨ zɨ́a owonɨ́ Yésụ bú. ");
INSERT INTO bdh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zɨ́ Yésụ áfáne akpa ngúcuné kɨ́ sị́ ndóndó sɨmɨ bɨ bi nɨ aka mbumbumbu ní, ndéréne gɨ cigí ꞌbe re gbála íni ini zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Zɨ́ Simúna e kɨ́ lafúne e ndéréye gámásóꞌdo wo. ");
INSERT INTO bdh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sɨmɨ bɨ nderé ndikinɨ́ wo ní, zɨ́ye úku ledre zɨ́a kɨ́dí, “Tụ́ꞌdụ́ ꞌyị e nɨyí ndị́sị gámásóꞌdo yị́ị.” ");
INSERT INTO bdh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Nderézé aka sɨmɨ ngíti géyị owụ́ gara ga bɨ kpị́ ní, máíli kpá úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị ga bɨ íri ní. Gɨ zɨ́a, née moko bɨ máógụ gɨ roa ní.” ");
INSERT INTO bdh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zɨ́ye gámáye sɨmɨ tụ́ꞌdụ́ ngíti géyị owụ́ gara ga bɨ sɨmɨ Galiláya ore ní, kɨ́ úku ledre ꞌbɨ Lomo sɨmɨ ꞌDị́cị́ Kótrụro e, kpá kɨ́ lágaóyó dokéké e gɨ sɨmɨ ꞌyị e ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Zɨ́ ngíti ꞌyị kɨ́ bɨsinyí umbunonó roné ógụné ṇgúṇgú roné zɨ́ Yésụ, kɨ́dí, “Áko, togụ́ utúasá go kacɨ́ komoyị́, ídí yómo máa.” ");
INSERT INTO bdh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zɨ́ lerị́ méngị Yésụ, zɨ́a óto sị́lị́ne ro oꞌdo née, zɨ́a úku ledre kɨ́dí, “Máíli go kenée, royị́ eme mu.” ");
INSERT INTO bdh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Geré, zɨ́ bɨsinyí umbunonó née ụ́kụ́ne gɨ roa, zɨ́ roa ndáꞌbaógụné bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zɨ́ Yésụ kásalúgu wo kɨ́ lórụ oꞌbụóꞌbụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ndá úku ꞌdódo ledre née zɨ́ ꞌyị e wá. Ídí ndéré zɨ́ ꞌyị ꞌdáná éyị́, zɨ́yị óṇgoónzó bangá íꞌbí mbófo éyị́ kɨ́e zɨ́ Lomo káa zɨ́ bɨ Mụ́sa eké ní, nɨyí geré ówo a kɨ́dí umbunonó bɨ royị́ ní ụkụ́ go.” ");
INSERT INTO bdh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Oꞌdo née tonó nda yị́ ené geré úku ledre née zɨ́ ꞌyị e. Gɨ zɨ́ kéyị née, Yésụ utúasá lolụ ndéré sɨmɨ ngíti géyị gara e wá. Ndịsịnɨ́ nda kóo lá do bi bɨ ngárá ꞌyị e ndanɨ́ doa tụ́ꞌdụ́ wá ní. Abú kenée ndotó, tụ́ꞌdụ́ ꞌyị e nɨyí kpá fú ndị́sị ógụ zɨ́a kacɨ́ gara e mɨngúngúcua. ");
INSERT INTO bdh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gɨ do kacɨ́ owụ́ sị́lị́ ca, zɨ́ Yésụ ndáꞌbalúgu roné sɨmɨ gara bɨ Kapáranawúma, zɨ́ ꞌyị e úwú ledrea kɨ́dí ndaꞌbaogụ go ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Zɨ́ tụ́ꞌdụ́ ꞌyị e ógụyé, ꞌdúcu ꞌdị́cị́ bɨ nɨ sɨmɨ a ní ndá, kémbị́ bifúó ndaá lolụ wá. Zɨ́a ndị́sịné ꞌdódo ledre ꞌbɨ Lomo zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Zɨ́ ngíti géyị yaꞌdá e eso (4) ị́mbị́ógụ ngíti mɨgịgị́ṛị́ kɨ́ gbagbara zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gɨ zɨ́a bɨ bi ndéréógụyé zɨ́ Yésụ íri ndaá gɨ zɨ́ ꞌyị wá ní, zɨ́ye ékị́ye íciphụ́trụ do ꞌdị́cị́ fúó, zɨ́ye ị́mbị́ésị oꞌdo née zɨ́ Yésụ ꞌdị́cị́ íri, kɨ́ káꞌdá nyé kɨ́ gbagbara née. ");
INSERT INTO bdh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sɨmɨ bɨ Yésụ lurú kɨ́dí yaꞌdá ga gére née ṇguṇgunɨ́ ledre ené go ní, zɨ́a úku ledre zɨ́ mɨgịgị́ṛị́ née kɨ́dí, “Owụ́ ꞌbɨ amáa, máótoómo lúyú ledre eyị́ go.” ");
INSERT INTO bdh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngíti géyị ꞌyị ꞌdódo lorụ e nɨyí kóo mɨndị́sịyé kenée ndị́sị sómụ́ ledre kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Oꞌdo née uku née kenée ledre ꞌdi? Uku sinyi ledre go. Lomo nɨ dụụ́ ne ꞌyị ótoómo lúyú ledre ꞌbɨ ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Geré zɨ́ Yésụ ówo sómụ́ ledre eyé, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndị́sịsé sómụ́ ledre kenée gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ledre be ꞌdi nɨ ꞌdiya zɨ́ma gáa úku a zɨ́ oꞌdo née, ‘Máótoómo lúyú ledre eyị́ go, togụ́ ị́nyịógụ mu, ꞌdíꞌbi sáka eyị́ zɨ́yị ndáꞌbayị́ ꞌbe’? ");
INSERT INTO bdh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Máíli ídísé ówo a kɨ́dí, máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, mááyí kɨ́ rokoꞌbụ gɨ ro ótoómo lúyú ledre ꞌbɨ ꞌyịmaꞌdí e kɨ́e do sogo káṇgá ba.” Zɨ́a óyó komoné úku ledre zɨ́ mɨgịgị́ṛị́ née kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ị́nyịógụ mu, ꞌdíꞌbi sáka eyị́ mu zɨ́yị ndáꞌbayị́ ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zɨ́ oꞌdo née ị́nyịógụné tɨ́ do komoyé née, ꞌdíꞌbi sáka ené, yóó do ndáꞌbané ꞌbe. Zɨ́ tara ꞌyị ga bɨ kóo ore ní ị́drị́ye mbá mɨị́drị́, zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Mbófo éyị́ zɨ́ Lomo. Tɨ́ bɨ ndịsịzé ona ní, lurúzé aka ledre káa zɨ́ wo ba kú wá.” ");
INSERT INTO bdh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zɨ́ Yésụ kpá ndáꞌba ándá roné do gbúṛóngó mɨkavu Galiláya, zɨ́ tụ́ꞌdụ́ ꞌyị e ógụyé zɨ́a, zɨ́a ndị́sịné ꞌdódo ledre zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Zɨ́a ndéréókpóne gɨ ore, zɨ́a lúrúndíki ꞌyị ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e kɨ́ ịrịné Lévị Matáyo, owụ́ ꞌbɨ Alafáyo, mɨndị́sịné sɨmɨ mákɨtabu. Yésụ ya zɨ́a ní, “Ógụ mu, lódụ́ kacɨ́ma.” Geré zɨ́ Matáyo ị́nyịógụné zɨ́ye ndéréye kɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kɨ́ tagá a née zɨ́ Lévị yéme éyị́ mɨánu zɨ́ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e. Zɨ́ tụ́ꞌdụ́ ngíti géyị ꞌyị ꞌdóꞌdụ́ ụsórụ kpá ógụyé íri kɨ́ ngíti géyị ꞌyị lúyú ledre e gɨ zɨ́a nɨyí nda kóo go mbá ꞌyị lódụ́ kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sɨmɨ bɨ ꞌyị ꞌdódo lorụ e ga bɨ Farụsáyo e lurúndiki Yésụ kɨ́ ánu éyị́ mɨánu kɨ́ ꞌyị ga gére née ní, zɨ́ye ị́nyịyé ndúꞌyú ꞌyị lódụ́ kacɨ́ga kɨ́dí, “Mongụ́ ꞌyị née ndịsịnɨ́ ánu éyị́ kɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ kpá kɨ́ lúyú ledre ga gére née gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sɨmɨ bɨ Yésụ uwú ledre née kenée ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “ꞌYị ga bɨ ndanɨ́ ꞌyị ndíyá e wá ní, nderénɨ́ eyé lengbe zɨ́ dokotóro e wá, dụụ́ ꞌyị ndíyá e. Máógụ amá gɨ ro bɨlámá ꞌyị e wá, yị́ ené gɨ ro ꞌyị lúyú ledre e.” ");
INSERT INTO bdh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ꞌYị ga bɨ ndịsịnɨ́ lódụ́ kacɨ́ Yiwáni ní, kɨ́ Farụsáyo e ndịsịnɨ́ lengbe órụ́ éyị́. Zɨ́ ngíti géyị ꞌyị e ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, ꞌyị lódụ́ kacɨ́ Yiwáni e kɨ́ Farụsáyo e nɨyí go órụ́ éyị́, sara ꞌyị eyị́ e orụ́nɨ́ ꞌbɨ eyé éyị́ wá gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “ꞌYị ga bɨ ogụnɨ́ ꞌdị́yịóto mɨkánda kára ní, nɨyí ndị́sị ꞌbú lárá a káa be ꞌdi bɨ mɨkánda adrúgu nɨ kɨ́ye ore ní? Utúasánɨ́ ndị́sị ꞌbú wá. ");
INSERT INTO bdh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sịndị́ kadra nɨ ógụ, do ꞌdíꞌbióyó mɨkánda adrúgu née gɨ zɨ́ye, née go sịndị́ kadra bɨ zɨ́ye órụ́ éyị́ ní. ");
INSERT INTO bdh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Utúasá zɨ́ ꞌyị ị́cị́ꞌdụ́tụ uṇgú bɨ ro kuṛú bongó ní, kɨ́ tara mɨkánda bongó wá. Mɨkánda bongó née, nɨ lálalófo kuṛú a née fúó, zɨ́ uṇgú née nda áyané rómo wo bɨ ꞌdáꞌdá ní. ");
INSERT INTO bdh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Utúasá kpá do lótó mɨkánda leꞌyị́ kóṛó sɨmɨ kuṛú ndoko wá, gɨ zɨ́a mɨkánda leꞌyị́ née nɨ ụ́ꞌbụ kɨ́ cóngó roné, zɨ́a lóko kuṛú ndoko née gburá, zɨ́ leꞌyị́ kɨ́ ndoko née sị́nyị́ye gbrengárá. Bɨlámá a, idínɨ́ lótó mɨkánda leꞌyị́ sɨmɨ mɨkánda ndoko ené kpị́.” ");
INSERT INTO bdh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kadra kị́éꞌdo sɨmɨ ngíti Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéréye kpụrụ́ gɨ sɨmɨ ngíti yáká kére, zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née tónóye lófo ngorụ kére, kɨ́ ánu a. ");
INSERT INTO bdh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Zɨ́ Farụsáyo e úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, éyị́ bɨ ꞌyị eyị́ e ndịsịnɨ́ méngị moko sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro bɨ ngárá ndaá sị́lị́ ꞌbɨ moko wá ní gɨ zɨ́a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ólosé esé ledre bɨ kóo Dawídi mengị sɨmɨ sịndị́ kadra bɨ kóo ꞌbú mengị yée kɨ́ ꞌyị ené mɨméngị ní wá? ");
INSERT INTO bdh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kóo sɨmɨ sịndị́ ꞌbɨ Abiyatára mongụ́ ꞌyị ꞌdáná éyị́ ní, ꞌbú mengị kóo Dawídi kɨ́ ꞌyị ené e go kɨ́ngaya, zɨ́a ólụ́ne ꞌDị́cị́ ꞌbɨ Lomo. Zɨ́a ꞌdíꞌbi ambata bɨ kóo ꞌyị ꞌdáná éyị́ e nɨyí ánu a lá dụụ́ ye ní, zɨ́a ánu a, zɨ́a íꞌbí ngíti géyị zɨ́ ꞌyị ené e ánu a.” ");
INSERT INTO bdh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Sị́lị́ ꞌbɨ ꞌDówụ́ro nɨ gɨ ro ꞌyịmaꞌdí e, ndaá ꞌbɨ ené ꞌyịmaꞌdí e gɨ ro Sị́lị́ ꞌbɨ ꞌDówụ́ro wá. ");
INSERT INTO bdh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Owụ́ ꞌbɨ ꞌYịmaꞌdí, nɨ Ngére do Sị́lị́ ꞌbɨ ꞌDówụ́ro.” ");
INSERT INTO bdh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sɨmɨ ngíti Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ ólụ́ne sɨmɨ ꞌDị́cị́ Kótrụro, ngíti oꞌdo nɨ kóo ore, kɨ́ umbusị́lị́ne. ");
INSERT INTO bdh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Zɨ́ ngíti géyị Farụsáyo e ndị́sịyé lúrú bi togụ́ Yésụ yéme sị́lị́ oꞌdo née go sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro yá, zɨ́ye íꞌbí ngbángá a zɨ́ mɨngburoko ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zɨ́ Yésụ úku ledre zɨ́ oꞌdo née kɨ́dí, “Ị́nyịógụ mu tóro ꞌdága do komo ꞌyị ga ba.” ");
INSERT INTO bdh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zɨ́ Yésụ ndúꞌyú Farụsáyo ga gére ní, “Ledre be ꞌdi nɨ mɨútúásá do méngị a sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro. Méngị bɨlámá ledre káa zɨ́ sáká ꞌyị? Togụ́ méngị bɨsinyí ledre káa zɨ́ úfu ꞌyị?” Ukulugunɨ́ ledre mbá wá. ");
INSERT INTO bdh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zɨ́a lúrú yée, zɨ́ bi sínyíne roa, zɨ́a ídíne kpá kɨ́ mongụ́ sómụ́ ledre, gɨ zɨ́a bɨ doyé orụ mɨórụ ní. Zɨ́a úku ledre zɨ́ oꞌdo née kɨ́dí, “ꞌDózo sị́lị́yị née mu mbị́.” Zɨ́a ꞌdózo a, zɨ́ sị́lị́a ndáꞌbaógụné bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Zɨ́ Farụsáyo ga gére née ị́nyịyé, ndéréye kótrụ royé kɨ́ mɨngburoko ꞌyị ga bɨ ꞌbɨ Eróde e ní yéme mɨsómụ́ ledre gɨ ro úfu Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zɨ́ Yésụ ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéréye do gbúṛóngó mɨkavu Galiláya. Zɨ́ tụ́ꞌdụ́ ꞌyị e gɨ sɨmɨ káṇgá bɨ Galiláya ní lódụ́ wo íri. ");
INSERT INTO bdh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Sɨmɨ bɨ ꞌyị e uwúnɨ́ ledre ga bɨ ndịsị méngị yée ní, zɨ́ ngíti géyị ị́nyịyé gɨ sɨmɨ Yerụsaléma kɨ́ káṇgá ga bɨ Yụdáya kɨ́ Ịdụmáya, nda kɨ́ ngíti géyị ị́rịgbére ga bɨ sága Yeredéne kɨ́ gara bɨ Táyire, kɨ́ Sidóna ní ógụyé zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gɨ zɨ́a bɨ, ꞌyị máa ga gére née ofụnɨ́ nda go ní, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e yémeómo ngíti owụ́ kuṛúngba nzíyiné zɨ́ne ndị́sịné sɨmɨ a gɨ zɨ́ bi kɨ́ ídíne royé ndá ke. ");
INSERT INTO bdh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zɨ́a sị́kpị tụ́ꞌdụ́ ꞌyị e gɨ do ndíyá eyé e. Zɨ́ ngíti géyị ꞌyị ndíyá e ndị́sị kɨ́ ị́trị́ royé gɨ ro ógụyé gbóo ro Yésụ, gɨ ro óto sị́lị́ye roa. ");
INSERT INTO bdh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sɨmɨ bɨ bɨcayi lomo e lurúndikinɨ́ wo ní, zɨ́ye ndị́sị útúye bi kóꞌdụ́ Yésụ gbúrógbóye ꞌdága kɨ́dí, “Áyí Owụ́ ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Zɨ́ Yésụ lórụ yée kɨ́dí, ndanɨ́ úku ꞌdódo ledrené zɨ́ ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zɨ́ Yésụ ékị́ne do landa, zɨ́a ndólo ꞌyị ga bɨ ili yée ní, ");
INSERT INTO bdh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","zɨ́a géléógụ yaꞌdá e sokó doa gbre (12), káa do ꞌyịmɨkása ené e gɨ ro zɨ́ne kása yée kacɨ́ bi e kɨ́ úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e, ");
INSERT INTO bdh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kpá gɨ ro zɨ́ye ídíye kɨ́ rokoꞌbụ do dokéké e gɨ ro ndị́sị lágaóyó yée kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ba ịrị ꞌyị ga bɨ gelé yée sokó doa gbre ní. Simúna, wo bɨ Yésụ íꞌbí ngíti ịrị zɨ́a, “Pétero” ní, ");
INSERT INTO bdh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nda Yakóbo e kɨ́ lúnduné Yiwáni, owụ́ ꞌbɨ Zebedị́ya e. Née yée ga bɨ kóo Yésụ ịfị́ ịrịyé kɨ́dí, “Owụ́ Rará e” ní, ");
INSERT INTO bdh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nda Andiríya, Phị́lịpo, Batilimáyo, Matáyo, Tóma, Yakóbo wotị́ Alafáyo, Tadéyo, Simúna Zíloto, ");
INSERT INTO bdh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nda kɨ́ Yụ́da Keriyóta, bɨ íꞌbí ngbángá Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Zɨ́ Yésụ ndáꞌbayé ꞌbe, zɨ́ tụ́ꞌdụ́ ꞌyị e kpá yóko royé, bi ánu éyị́ ndaá lolụ zɨ́a kɨ́ ꞌyị lódụ́ kacɨ́ne e wá. ");
INSERT INTO bdh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sɨmɨ bɨ ꞌyị ené e uwúnɨ́ ledre a ní, zɨ́ye ị́nyịyé ndéréye gɨ ro ꞌdíꞌbilúgu wo, gɨ zɨ́a, ukunɨ́ go ya, “Sɨmɨ doa sinyí go mɨsínyí.” ");
INSERT INTO bdh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngíti géyị ꞌyị ꞌdódo lorụ ga bɨ ogụnɨ́ gɨ sɨmɨ Yerụsaléma ní, ukunɨ́ ꞌbɨ eyé kɨ́dí, “Yésụ nɨ kɨ́ Belezabụ́bụ sɨmɨné. Iꞌbí cóngó ro zɨ́a ne, zɨ́a ndị́sịné lágaóyó dokéké e kɨ́e.” ");
INSERT INTO bdh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zɨ́ Yésụ ndólo yée, úku ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, “Satána nɨ kpá ndị́sị lágaóyó Satána ꞌdáꞌba? ");
INSERT INTO bdh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Togụ́ ꞌyị ꞌbɨ ngére ndịsịnɨ́ méngị okó dengbị́ye yá, káṇgá ꞌbɨ ngére née toroyeme roné wá. ");
INSERT INTO bdh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kpá kenée togụ́ sụmụ e ifinɨ́ royé, ndị́sị méngị okó akpa dengbị́ye yá, ꞌbe ꞌbɨ eyé née toroyeme roné wá. ");
INSERT INTO bdh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Togụ́ Satána ndịsị nda go méngị okó akpa kɨ́ ꞌyị ené e ní, nɨyí nda ndị́sị méngị moko ené káa be ꞌdi? Rokoꞌbụ a nɨ ụ́kụ́. ");
INSERT INTO bdh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ꞌYị utúasá ólụ́ ꞌdị́cị́ ꞌbɨ mongụ́ ngére, ngáka éyị́ ené e wá, ꞌbúó togụ́ odóụtụ ngére née kí, nɨ nda fú ngáka éyị́ ené e gɨ ꞌdị́cị́ ndéré kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Máúku zɨ́se maꞌdíi, Lomo nɨ ótoómo mɨlúyú ledre ꞌbɨ ꞌyị e, kɨ́ ledre ga bɨ ndịsịnɨ́ úku sínyi yée ní mbá. ");
INSERT INTO bdh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Togụ́ ꞌyị uku sinyi ledre gɨ do bɨ ꞌDówụ́ Lomo yá, Lomo otoomo ledre zɨ́a kú wá, gɨ zɨ́a mengị née go bɨsinyí ledre bɨ ngárá utúasá ụ́kụ́ kú wá ní.” ");
INSERT INTO bdh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yésụ uku ledre née kenée, gɨ zɨ́a bɨ ꞌyị ꞌdódo lorụ ga gére née ukunɨ́ ledre kɨ́dí, “Nɨ kɨ́ bɨcayi lomo sɨmɨné ní.” ");
INSERT INTO bdh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zɨ́ mbágá Yésụ kɨ́ lúnduga ndéréógụyé do bi bɨ nɨ doa ní, zɨ́ye tóroyé cịkị sága, kákasa ꞌdị́cị́ íri ndóloógụ wo zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ gbaá cigí Yésụ ní úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, mbágáyị kɨ́ lúnduyị́ e nɨyí ndólo yị́ị sága ꞌdáa.” ");
INSERT INTO bdh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Mbágáma e kɨ́ lúndumá e ꞌbe náambi e?” ");
INSERT INTO bdh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zɨ́a lúrú ꞌyị ga bɨ nɨyí mɨndị́sịyé cigíne gbaá ba, zɨ́a úku ledre kɨ́dí, “Ga bɨ nɨyí ndị́sị ba, mbágáma e kɨ́ lúndumá e. ");
INSERT INTO bdh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ꞌYị ga bɨ ndịsịnɨ́ méngị ledre ga bɨ Lomo ili yée ní, nɨyí ye lúndumá e lémịmá e kɨ́ mbágáma e.” ");
INSERT INTO bdh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sɨmɨ ngíti sịndị́ kadra zɨ́ Yésụ kpá ndéréne ndị́sị ꞌdódo ledre zɨ́ ꞌyị e do gbúṛóngó mɨkavu Galiláya. Zɨ́ tụ́ꞌdụ́ ꞌyị e yóko royé cigí a gbaá. Zɨ́a ékị́ ndị́sịné sɨmɨ kuṛúngba ndị́sị ꞌdódokása ledre zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ꞌDódo tụ́ꞌdụ́ ledre e zɨ́ye sɨmɨ muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Úwúsé aka ledre ba, ngíti oꞌdo nderé kóo óyụ kúfú ené. ");
INSERT INTO bdh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sɨmɨ bɨ ndịsị óyụ kúfú ní, zɨ́ ngíti géyị útúye do mɨsiꞌdi, zɨ́ solụ́ e ógụyé lágá yée. ");
INSERT INTO bdh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ngíti géyị utúnɨ́ ꞌbɨ eyé do gbụ́gbụ́rụ́ kɨ́ꞌdí bɨ káṇgá ndaá ꞌbeꞌbeꞌde ore wá ní. Zɨ́ye ụ́tụyé ꞌdiya gɨ zɨ́a cíyíye olụ́ ené sɨmɨ káṇgá mbị́ wá. ");
INSERT INTO bdh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sɨmɨ bɨ bɨrará kadra suwu kɨ́ngaya ní, zɨ́ye áꞌdáye gɨ zɨ́a cíyíye ndaá sɨmɨ káṇgá mbị́ wá, zɨ́ye gágáye rúfú. ");
INSERT INTO bdh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ngíti géyị kúfú utú ꞌbɨ ené do bɨ kɨ́ kị́nị e doné ní. Sɨmɨ bɨ ụtụ ní, ngboró yeme roné wá gɨ zɨ́a kị́nị olụ́ịndị́ yị́ ené nda ꞌdụ́tụ bi ngbóró gɨ zɨ́a mbá. ");
INSERT INTO bdh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngíti a utú ꞌbɨ ené sɨmɨ ngomụ káṇgá, zɨ́a ánáne bɨlámáne kɨ́ngaya. Gɨ sɨmɨ ngíti bi mị́ngị́ yáká owo kongụ kị́éꞌdo doa sokó, gɨ sɨmɨ ngíti a ꞌbɨ ené kongụ ota. Zɨ́a ówo gɨ sɨmɨ ngíti a kongụ ịnyị.” ");
INSERT INTO bdh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zɨ́ Yésụ úku ledre kɨ́dí, “ꞌYị bɨ mbílía uwú ledre bú ní, idí úwú ledre née.” ");
INSERT INTO bdh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sɨmɨ bɨ Yésụ nɨ nda go ngúcuné ní, zɨ́ ꞌyịmɨkása ené e kɨ́ ngíti géyị ꞌyị lódụ́ kacɨ́ga ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, ledre ꞌbɨé gɨ sɨmɨ muruwayi gána ní káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Mááyí ba go ꞌdódo a zɨ́se. Togụ́ zɨ́ ngíti géyị ꞌyị e yá, mááyí ꞌdódo a zɨ́ye sɨmɨ muruwayi, ");
INSERT INTO bdh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","gɨ ro “ ‘nɨyí lúrú éyị́ ga bɨ mándị́sị méngị yée ní, utúasá esé ówoyéme a wá, zɨ́ye ndị́sịyé úwú ledre ga bɨ mááyí ndị́sị úku yée ní utúasá ené ólụ́ sɨmɨ dosé wá Idí oyóloꞌbónɨ́ mɨsómụ́ ledre eyé ba bo, káa bɨ Lomo otoomo mɨlúyú ledre eyé go.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zɨ́a kpá úku ledre zɨ́ye kɨ́dí, “Ówosé esé ini ledre gɨ sɨmɨ muruwayi née fú lá wá? Ásé nda ówoyéme ngíti géyị muruwayi ga bɨ mááyí úku yée ní káa be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kúrú Lomo nɨ káa zɨ́ kúfú bɨ ndịsịnɨ́ óyụ a yáká ní. ");
INSERT INTO bdh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ngíti géyị ꞌyị e nɨyí ꞌbɨ eyé káa zɨ́ kúfú bɨ utú do mɨsiꞌdi ní. Nɨyí úwú kúrú Lomo ꞌdiya, luꞌbú kpá wá, geré zɨ́ Satána ógụné ꞌdíꞌbióyó a gɨ sɨmɨyé. ");
INSERT INTO bdh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ngíti géyị ꞌyị e nɨyí ꞌbɨ eyé káa zɨ́ landa ní. Nɨyí úwú kúrú Lomo zɨ́ye ídíye ꞌdiya kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nda gɨ zɨ́a bɨ cíyí ledre maꞌdáa ndaá sɨmɨyé wá ní, geré zɨ́ye ótoómo a gɨ zɨ́ ꞌdoꞌdó bɨ ndiki yée go ní. ");
INSERT INTO bdh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ngíti géyị nɨyí ꞌbɨ eyé káa zɨ́ kúfú bɨ utú dongará kị́nị ní, ");
INSERT INTO bdh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nda gɨ zɨ́ sómụ́ ledre éyị́ ga bɨ ꞌbɨ sága, zɨ́ye ndị́sịyé óto ꞌbúye kɨ́ngaya ní, zɨ́ ꞌbú ledre ꞌbɨ Lomo nda ụ́kụ́ne gɨ doyé, utúasánɨ́ eyé lolụ áná bɨlámá mɨánáye wá. ");
INSERT INTO bdh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngíti géyị ꞌyị e nɨyí ꞌbɨ eyé káa zɨ́ ngomụ káṇgá ní. Sɨmɨ bɨ úwú kúrú Lomo ní, zɨ́ye ṇgúṇgu a, zɨ́ sómụ́ ledre eyé óyólóꞌbó roné bɨlámáne, zɨ́ye ꞌdíꞌbi a, zɨ́ye ndị́sịyé méngị ledre ga bɨ Lomo ili ní, zɨ́ mɨméngị ledre eyé ídíne bɨlámáne káa zɨ́ kúfú bɨ anáogụ kongụ kị́éꞌdo doa sokó (30), kongụ ota (60) nda kɨ́ yée ga bɨ anáogụnɨ́ kongụ ịnyị (100) ní.” ");
INSERT INTO bdh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zɨ́ Yésụ kpá úku ngíti ledre zɨ́ye kɨ́dí, “ꞌYị ụndụoto phoꞌdụ bú ꞌdị́cị́ kacɨ́ne, zɨ́a lóꞌbụꞌdụ́tụ a sị́ pheṛé, togụ́ sị́ ṛangba? Nɨ óto phoꞌdụ née do nyárá bi. ");
INSERT INTO bdh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gɨ ro zɨ́ éyị́ ga bɨ sɨmɨ mɨtụlụrụ ní, ídíye mbá do nyárá bi. Gba ledre ga bɨ nɨyí mɨótoécịyé ní do ówo yée mbá. ");
INSERT INTO bdh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ꞌYị bɨ mbílía úwú ledre bú ní, idí úwú ledre née.” ");
INSERT INTO bdh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zɨ́a kpá úku ledre kɨ́dí, “Ídísé óto ledre ga bɨ úwúsé yée née sɨmɨ dosé. Mɨsiꞌdi bɨ ndị́sịsé méngị ꞌyị e kɨ́e ní, nɨ ídí kpá ne mɨsiꞌdi bɨ do méngịsé e kɨ́e nda za kɨ́ngaya ní. ");
INSERT INTO bdh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ꞌYị bɨ nɨ kɨ́ éyị́ e zɨ́ne ní, nɨyí íꞌbí yata a zɨ́a nda za kɨ́ngaya. ꞌYị máa wo bɨ ngárá éyị́ eyenɨ́ zɨ́a wá ní, abú wo bɨ zɨ́a cúkuꞌdée née nɨyí ꞌdíꞌbióyó a gɨ zɨ́a kpụ́rụ́ ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zɨ́ Yésụ úku ngíti muruwayi kɨ́dí, “Ledre gɨ ro ꞌbe ꞌbɨ Lomo káa zɨ́ ꞌyị bɨ oyụ kúfú yáká ní. ");
INSERT INTO bdh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kɨ́ kadra kɨ́ ndụlụ mbá togụ́ nɨ ꞌdúꞌdu togụ́ nɨ mbú dilá yá, kúfú ga bɨ oyụ yée ní nɨyí ụ́tụ zɨ́ye ngbóróye abú owo wá. ");
INSERT INTO bdh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Káṇgá ndịsị íꞌbí éyị́ mɨánu zɨ́ye lá dụụ́ ne, zɨ́ye ngbóróye kɨ́e, aka kókó sịndị́ye, nda gɨrí zɨ́ye ngbóróye, zɨ́ye gbóṛụ́ye, nda geré go mɨánáye. ");
INSERT INTO bdh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nda sɨmɨ bɨ kére nɨ go nzíyiné gɨ ro óṇgó a ní, zɨ́a nda tónóne óṇgo a.” ");
INSERT INTO bdh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zɨ́ Yésụ kpá úku ngíti muruwayi zɨ́ye kɨ́dí, “Mááyí ótoásá ledre gɨ ro ꞌbe ꞌbɨ Lomo ꞌdáa ní kɨ́ ꞌdi? Muruwayi bɨ nɨ útúásá kɨ́e ní wo be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nɨ káa zɨ́ kúfú musɨtáda ní. Gɨ zɨ́a nɨ kúfú bɨ nɨ nzéré kɨ́ngaya ní. ");
INSERT INTO bdh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Abú kúfú kágá née nɨ nzéré kenée ndotó, togụ́ ꞌdịyị́nɨ́ go yáká ụtụ go yá, zɨ́a ngbóró rómoné do ngíti géyị éyị́ ga bɨ yáká ore ní mbá. Nɨ rásá tụ́ꞌdụ́, zɨ́ solụ́ e ndị́sị ụ́bụ́ ꞌbe ꞌbɨ eyé komoa.” ");
INSERT INTO bdh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yésụ ndịsị kóo ꞌdódo ledre zɨ́ ꞌyị e sɨmɨ muruwayi. Mengị kenée gɨ do bɨ zɨ́ye ówoꞌdíꞌbi ini ledre gɨ sɨmɨyé. ");
INSERT INTO bdh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kacɨ́ kadra e mbá, togụ́ Yésụ nɨ go ndị́sị ꞌdódo ledre yá, zɨ́a ndị́sịné ꞌdódo ngíti géyị ledre e sɨmɨ muruwayi. Sɨmɨ bɨ lurú go tɨ́ lá céré yée kɨ́ ꞌyị lódụ́ kacɨ́ne e ní, zɨ́a ị́nyịné úkuógụ ledre gɨ sɨmɨ muruwayi ga gére née mbá zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nda kɨ́ tagá a née ní, zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “ꞌDogụzé aka bi mu sága gɨ ꞌdí keṛị́.” ");
INSERT INTO bdh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Zɨ́ye ị́nyịyé ótoómo tụ́ꞌdụ́ ꞌyị ga bɨ yokonɨ́ royé née ore, zɨ́ ꞌyị lódụ́ kacɨ́ga ékị́lódụ́ kacɨ́ a sɨmɨ owụ́ kuṛúngba bɨ gáa ndịsị sɨmɨ a ní, zɨ́ ngíti géyị ꞌyị e ékị́ ꞌbɨ eyé sɨmɨ ngíti géyị kuṛúngba e yóó, zɨ́ye ndéréókpóye. ");
INSERT INTO bdh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Zɨ́ mongụ́ síli ógụné kpịkpịkpịkpị, zɨ́a ndị́sịné ílíógụ iní sɨmɨ kuṛúngba bɨ Yésụ nɨ sɨmɨ a ní, gbuwa gbuwa gbuwa, ngítí kuṛúngba nda kɨ́ ꞌdúcu go cúkuꞌdée. ");
INSERT INTO bdh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yésụ, nɨ mɨꞌdúꞌduné, kɨ́ doné gá do éyị́ ꞌdága. Zɨ́ ꞌyị lódụ́ kacɨ́ga ga ba ị́nyịyé úru wo, kɨ́dí, “Áko, ꞌYị ꞌdódo ledre, sómụ́ eyị́ ledre umbu bɨ azé go úyu a, ba wá?” ");
INSERT INTO bdh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zɨ́a ị́nyịógụné, úku ledre zɨ́ síli kpá kɨ́ kụ́ṛụ́mụ iní kɨ́dí, “Ídí tóro tí.” Zɨ́ síli tóroné tí, zɨ́ mongụ́ gboṛụ bi bɨ gáa ba ídíne sií. ");
INSERT INTO bdh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zɨ́ Yésụ óyó komoné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Áyi, érésé ngịrị gɨ zɨ́ ꞌdi? Ṇgúṇgusé aka esé ledremá fú lá wá?” ");
INSERT INTO bdh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zɨ́ ngịrị ledre bɨ Yésụ mengị née ólụ́ne royé gbála, zɨ́ye tónóye úku ledre dengbị́ye kɨ́dí, “Bɨ káa lárá ꞌyị ꞌdi, bɨ síli kɨ́ kụ́ṛụ́mụ iní uwúnɨ́ ledre ené gba ye ní?” ");
INSERT INTO bdh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Zɨ́ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e go ꞌdógụ bi ndéréógụyé sɨmɨ gara bɨ Gerésa ní. ");
INSERT INTO bdh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sɨmɨ bɨ Yésụ nɨ go ndítíógụ gɨ sɨmɨ kuṛúngba ní, zɨ́ ngíti oꞌdo kɨ́ dokéké sɨmɨné ólụ́ógụné gɨ dongará bi e zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oꞌdo máa née, ambá bi ndị́sị ené nda yị́ ené kóo sị́ bi e íri. ꞌYị bɨ nɨ útúásá ódó wo abú kpá gba cụ́ kɨ́ káꞌdá késị́ ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Odó andánɨ́ kóo sịndị́a kɨ́ sị́lị́a go mɨódó ándá kɨ́ káꞌdá késị́ ndịsị ꞌdécị yée gɨ roné fú lá mɨꞌdécị, gɨ zɨ́a, cóngó roa ofụ kóo go. ꞌYị bɨ zɨ́a útúásáne gba gɨ ro ꞌdíꞌbingéṛị wo ní ndaá kpá wá. ");
INSERT INTO bdh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kɨ́ꞌdí bɨ nɨ go dongará bi máa ga gére née íri, togụ́ kɨ́ kadra togụ́ kɨ́ ndụlụ yá, zɨ́a ndị́sị gbúrógbóne ꞌdága kpá ndị́sị kɨ́ óṇgo roné kɨ́ tutú e. ");
INSERT INTO bdh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sɨmɨ bɨ oꞌdo née lúrúndíki Yésụ gɨ gbála ní, geré zɨ́a ngásáógụné zɨ́a íri, zɨ́a útúne gbrị do ngúṛú sịndị́ne bi kóꞌdụ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Zɨ́a gbúrógbóne ꞌdága kɨ́dí, “Yésụ, yị́ị Owụ́ ꞌbɨ Lomo bɨ komo ere ní, éyị́ bɨ íli gɨ zɨ́ma ní ꞌdi? Ídí lólóbụ́ zɨ́ma do komo Lomo kɨ́dí, ógụ eyị́ ba gɨ ro méngị bɨsinyí ledre kɨ́ma wá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Oꞌdo née uku ledre kenée gɨ zɨ́a bɨ Yésụ úku ledre zɨ́ dokéké née kɨ́dí, “Ólụ́ógụ gɨ sɨmɨ oꞌdo née mu.” ");
INSERT INTO bdh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zɨ́ Yésụ ndúꞌyú wo kɨ́dí, “Ịrịyị́ náambi?” Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ịrịmá Owụ́tụ́ꞌdụ́, gɨ zɨ́a bɨ, azé tụ́ꞌdụ́ ní.” ");
INSERT INTO bdh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Zɨ́a ndị́sịné dódó roné ro Yésụ kɨ́ngaya kɨ́dí, “Ndá lágaóyó zée gɨ ore wá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tụ́ꞌdụ́ mụkụ́ṛụ́ e nɨyí kóo gbóo ore, ndịsịnɨ́ ánu éyị́ dogboṛụ landa. ");
INSERT INTO bdh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zɨ́ dokéké ga gére née dódó royé zɨ́ Yésụ kɨ́dí, “Kása zée ndéré ndị́sị sɨmɨ mụkụ́ṛụ́ ga bɨ ꞌdáa ba.” ");
INSERT INTO bdh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zɨ́ Yésụ íꞌbí mɨsiꞌdi zɨ́ dokéké e ólụ́ógụyé gɨ sɨmɨ oꞌdo née, zɨ́ye ndéré ólụ́ye sɨmɨ mụkụ́ṛụ́ e. Zɨ́ tụ́ꞌdụ́ mụkụ́ṛụ́ ga gére née éyị́ ꞌbɨ álifu gbre, ị́nyịyé rụ ndụ́ṛụ́ꞌbụ́ye gɨ do gboṛụ landa, ndéré útúye mbá sɨmɨ mongụ́ mɨkavu do úyuyé mbá. ");
INSERT INTO bdh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Zɨ́ ꞌyị ꞌbáꞌbá mụkụ́ṛụ́ ga gére née ị́nyịyé ngásáye úku ꞌdódo ledre bɨ mengị roné née sɨmɨ gara, kpá kɨ́ ngíti géyị bi ga bɨ gbóo gbóo ore ní mbá. Zɨ́ ꞌyị e ógụyé mbá lúrú ledre bɨ mengị roné née. ");
INSERT INTO bdh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sɨmɨ bɨ ogụnɨ́ zɨ́ Yésụ ní, zɨ́ye ndíki oꞌdo bɨ Yésụ lagaogụ dokéké e gɨ sɨmɨ a ba kɨ́ ndị́sị bɨlámáne kɨ́ bongó roné. Zɨ́ ngịrị méngị ꞌyị ga gére née kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ꞌYị ga bɨ lurúnɨ́ ledre bɨ méngị roné zɨ́ oꞌdo née, kpá kɨ́ wo bɨ zɨ́ mụkụ́ṛụ́ e ní, zɨ́ye ndị́sịyé úku a zɨ́ lafúye e. ");
INSERT INTO bdh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Zɨ́ ꞌyị máa ga gére née ndị́sị dódó royé ro Yésụ, idí mu ólụ́ógụ gɨ sɨmɨ káṇgá eyé gɨ ore ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sɨmɨ bɨ Yésụ ékị́ go sɨmɨ kuṛúngba ní, zɨ́ oꞌdo bɨ dokéké e olụ́ogụnɨ́ gɨ sɨmɨ a ní dódó roné ro Yésụ yée idínɨ́ ndéré kéne. ");
INSERT INTO bdh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yésụ ṇguṇgu ené zɨ́ye ndéréye kéne wá, tɨ́ lá zɨ́a úku ledre zɨ́a kɨ́dí, “Ndáꞌba aka ꞌbe zɨ́ ꞌyị eyị́ e, zɨ́yị lị́kpị́ bɨlámá ledre bɨ Ngére Lomo mengị zɨ́yị kɨ́ bɨlámá mɨmbéꞌdené ní zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zɨ́ oꞌdo née ị́nyịné ndéréne kɨ́ úku ꞌdódo ledre bɨ Yésụ mengị zɨ́a née zɨ́ ꞌyị e sɨmɨ káṇgá bɨ Dikapolị́sị kɨ́ tụ́ꞌdụ́ gara ga bɨ ore sokó ní mbá. Zɨ́ tara ꞌyị ga bɨ kóo ore ní ị́drị́ne mbá mɨị́drị́. ");
INSERT INTO bdh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zɨ́ Yésụ ékị́lúgu roné sɨmɨ kuṛúngba zɨ́a ꞌdógụ bi sága gɨ ꞌdí kéṛị́, zɨ́ tụ́ꞌdụ́ ꞌyị e kpá ị́nyịyé yóko royé gbaá cigí a do gbúṛóngó mɨkavu Galiláya íri. ");
INSERT INTO bdh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Zɨ́ ngúru mongụ́ ꞌyị ꞌbɨ ꞌDị́cị́ Kótrụro kɨ́ ịrịné Yáyiro ógụné íri. Sɨmɨ bɨ lurúndiki Yésụ ní, zɨ́a ógụ ndị́sịné ndoo sị́ sịndị́ Yésụ, ");
INSERT INTO bdh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ṇgúṇgú roné kɨ́ngaya kɨ́dí, “Áko, mongụ́ ꞌyị, nyị́ma nɨ kɨ́ ndíyá zaá oꞌbụóꞌbụ ógụ aka ndéré óto sị́lị́yị roa, gɨ ro zɨ́ ndíyá máa née ụ́kụ́ne gɨ roa zɨ́a ídíne trịdrị.” ");
INSERT INTO bdh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zɨ́ Yésụ ị́nyịyé ndéréye kɨ́ oꞌdo née. Zɨ́ tụ́ꞌdụ́ ꞌyị e útúye rụụ do kacɨ́ye, mɨsiꞌdi eye lolụ kóo zɨ́ye wá, ndịsịnɨ́ nda ndéré kɨ́ ị́trị́ royé mɨị́trị́. ");
INSERT INTO bdh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ngíti kára nɨ kóo dongará ꞌyị ga gére née kɨ́rɨ́ née kɨ́ ndíyá káꞌdá ꞌbɨ kará e roné, sɨmɨbi doa kɨ́e go sokó doa gbre. ");
INSERT INTO bdh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gamá zɨ́ tụ́ꞌdụ́ dokotóro e go má, zɨ́ késị́ ụ́kụ́ne gɨ zɨ́a mɨụ́kụ́, tɨ́ lá ndíyá tatá nda yị́ ené roa ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sɨmɨ bɨ kára née uwú ledre Yésụ ní, geré zɨ́a ndéréne gɨ ꞌdí sogo a gɨ dongará tụ́ꞌdụ́ ꞌyị ga gére née óto sị́lị́ne ro bongó bɨ ro Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Zɨ́a somụ́ ledre kɨ́dí, “Togụ́ máóto sị́lị́ma lá ro bongó ené yá, ndíyá ba nɨ ụ́kụ́ gɨ romá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sɨmɨ bɨ mengị kenée ní, geré zɨ́ ndíyá née ụ́kụ́ne gɨ roa. Zɨ́a ówo a kɨ́dí sɨmɨ sanáne eme go. ");
INSERT INTO bdh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zɨ́ Yésụ kpá ówo a kɨ́dí rokoꞌbụ bɨ sɨmɨné ní mengị moko go. Zɨ́a lúrú bi ꞌdí sogoné, zɨ́a ndúnduꞌyú kɨ́dí, “Ambí oto sị́lị́ne ro bongó amá ne?” ");
INSERT INTO bdh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Zɨ́ ꞌyị lódụ́ kacɨ́ga úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ‘Lúrú aka lá tụ́ꞌdụ́ ꞌyị ga bɨ gbaá cigíyị ba, áyí ówo ꞌyị bɨ oto sị́lị́ne royị́ ní káa be ꞌdi?’ ” ");
INSERT INTO bdh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Abú ndotó, Yésụ nɨ kpá fú ndị́sị lúrú bi kere gɨ ro ówo ꞌyị bɨ oto sị́lị́ne roné ní. ");
INSERT INTO bdh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Zɨ́ kára née owo ledre bɨ mengị roné zɨ́ne ní, zɨ́a ógụné kɨ́ mbéꞌbé gɨ zɨ́ ngịrị útúne sị́ sịndị́ Yésụ, do úku ledre e gɨ do biné zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Owụ́ ꞌbɨ amáa, ndíyá ụkụ́ go gɨ royị́, gɨ zɨ́a bɨ ṇgúṇgu ledremá ní. Ndéré mu bɨlámáne ꞌdóꞌdó lolụ wá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sɨmɨ bɨ Yésụ nɨ aka ndị́sị ódro ní, zɨ́ ngíti géyị ꞌyị e ógụyé gɨ ꞌbe ꞌbɨ Yáyiro, zɨ́ye úku ledre zɨ́ Yáyiro kɨ́dí, “Mongụ́ ꞌyị, nyị́yị otoomo ꞌdówụ́ go. Ndá lolụ ꞌdóꞌdo mongụ́ ꞌyị née wá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ledre née ata ené kóo kacɨ́ komo Yésụ wá, zɨ́a ị́nyịné úku ledre zɨ́ Yáyiro kɨ́dí, “Lomo royị́ ndaá úyu wá, ídí lá ṇgúṇgu ledremá.” ");
INSERT INTO bdh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yésụ ili ené zɨ́ tụ́ꞌdụ́ ꞌyị e lódụ́ née wá, lá dụụ́ Pétero e kɨ́ Yakóbo e kɨ́ lúnduné Yiwáni e. ");
INSERT INTO bdh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nɨyí ógụ bɨ ꞌbe ꞌbɨ Yáyiro íri ní, tụ́ꞌdụ́ ꞌyị e nɨyí go íni ini kɨ́ mbụ́mbụ́dụ́. ");
INSERT INTO bdh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Zɨ́ Yésụ ị́nyịné ólụ́ne ꞌdị́cị́ ini, zɨ́a úku ledre zɨ́ ꞌyị ga bɨ íri née kɨ́dí, “Ndásé íni ini wá, owụ́ née uyu ené wá, ꞌduꞌdu yị́ ené née lá mɨꞌdúꞌdu.” ");
INSERT INTO bdh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Zɨ́ ꞌyị ga bɨ ꞌdị́cị́ íri née útúye coo kúgú wo mɨkúgú. Gɨ do kacɨ́ bɨ uku ledre zɨ́ye ólụ́ógụyé sága ní, zɨ́a ꞌdíꞌbi ꞌbụmɨowụ́ kɨ́ mbágáa nda kɨ́ ꞌyị lódụ́ kacɨ́ga ga bɨ nɨyí kéye ní do ólụ́ókpóye sɨmɨ ngíti sɨmɨ ꞌdị́cị́ bɨ otonɨ́ umbu owụ́ née sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Zɨ́ Yésụ ꞌdíꞌbi sị́lị́ owụ́ née do úku ledre zɨ́a kɨ́ tara Aráma kɨ́dí, “Talíta kụ́mụ” kɨ́dí, “Nyị́ma, ị́nyịógụ mu ꞌdága” ");
INSERT INTO bdh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Geré zɨ́ owụ́kára née úrúne, zɨ́a ị́nyịógụné ꞌdága ndị́sị gámáne. Zɨ́ tara ꞌbụa kɨ́ mbágáa kɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ị́drị́ne mbá mɨị́drị́. ");
INSERT INTO bdh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Zɨ́ Yésụ úku ledre oꞌbụóbụ zɨ́ ꞌbụa kɨ́ mbágáa kɨ́dí ꞌyị e ndanɨ́ aka ówo ledre bɨ mengị roné née wá. Zɨ́a kpá úku ledre zɨ́ye idínɨ́ íꞌbí éyị́ mɨánu zɨ́a ánu a. ");
INSERT INTO bdh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ e ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ ore ndáꞌbalúgu royé sɨmɨ Nazeréta, owụ́ gara bɨ Yésụ ngboró sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sɨmɨ ngíti Sị́lị́ ꞌbɨ ꞌDówụ́ro zɨ́ Yésụ ndị́sịné ꞌdódo ledre zɨ́ tụ́ꞌdụ́ ꞌyị e sɨmɨ ꞌDị́cị́ Kótrụro. Zɨ́ tara ꞌyị e ị́drị́ne mbá mɨị́drị́ kɨ́ úwú ledre ga bɨ ndịsị úku yée ní. Zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Oꞌdo ba ndiki mongụ́ ówo ledre bɨ ꞌdényé káa ba gɨ ꞌda? Ambí ꞌdodo ledre ga gére née zɨ́a ne? Sara aka lá rokoꞌbụ bɨ ndịsị méngị mɨngburoko ledre ga gére née kɨ́e née, ndiki gɨ ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Zɨ́ ngíti géyị ꞌyị e úku ledre kɨ́dí, “Née ndaá ꞌyị yéme éyị́ e gɨ sɨmɨ kágá ba wá? Bɨ nɨ owụ́ ꞌbɨ Maríya bɨ lúnduga nɨyí Yakóbo, Yoséfa, Yụ́da kɨ́ Simúna e ní wá? Lémịga ndịsịnɨ́ ndị́sị fú kɨ́ze ona” Zɨ́ye lúrúcáyi wo do ásiyé kɨ́ ṇgúṇgu ledre ené. ");
INSERT INTO bdh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yésụ ya zɨ́ye ní, “ꞌYị lóṇgó e ndịsịnɨ́ óto úndru nébị ye. Togụ́ nda ꞌbe yá, sụmụga otonɨ́ eyé úndrua wá.” ");
INSERT INTO bdh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gɨ zɨ́a bɨ tụ́ꞌdụ́ye ṇguṇgunɨ́ ledre ené wá ní, mengị ené ledre ga bɨ kɨ́ rokoꞌbụyé ní ore wá, ꞌdiꞌbioyó ndíyá lá gɨ ro ngíti géyị ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Zɨ́a kóo ndị́sịné sómụ́lóꞌbó ledre bɨ ꞌyị ga gére née ṇguṇgunɨ́ ledrené, gɨ zɨ́a wá ní. Zɨ́ Yésụ ị́nyịyé ndéréye sɨmɨ owụ́ gara ga bɨ gbóo gbóo ore ní, kɨ́ ꞌdódo ledre zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nda sɨmɨ ngíti sị́lị́, zɨ́a ndóloyóko ꞌyịmɨkása ené ga bɨ sokó doa gbre (12) ní, zɨ́a íꞌbí rokoꞌbụ zɨ́ye ídíye do dokéké e, zɨ́a kása yée gbre gbre. ");
INSERT INTO bdh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Sɨmɨ mɨndérése, ídísé ꞌdíꞌbi lá dụụ́ ngbángbá. Ndásé ꞌdíꞌbi kombo e, ambata e, kɨ́ késị́ wá. ");
INSERT INTO bdh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wará bɨ sịndị́se ní asá go, ndásé ꞌdíꞌbiṛóngó bongó wá. ");
INSERT INTO bdh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Togụ́ ógụsé go sɨmɨ ngíti gara, ídísé ndị́sị sɨmɨ ꞌbe bɨ ꞌdiꞌbinɨ́ sée go sɨmɨ a sɨmɨ sụmụ ní ásé nda fú ókpó gɨ ore. ");
INSERT INTO bdh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ꞌBe máa wo bɨ ꞌdiꞌbinɨ́ sée sɨmɨ a sɨmɨ sụmụ wá, uwúnɨ́ ledre esé kpá sɨmɨ a wá ní yá, ídísé ụ́ꞌbụ́ ꞌbụrụ gɨ ro sịndị́se cịkị ore sɨmɨ bɨ ásé go ndéréókpó ní gɨ ro zɨ́a ꞌdódo a kɨ́dí, asinɨ́ go gɨ romá.” ");
INSERT INTO bdh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zɨ́ye ndéréókpóye, ndị́sị úku ledre zɨ́ ꞌyị e, idínɨ́ óyólóꞌbó mɨmbéꞌdeyé. ");
INSERT INTO bdh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Zɨ́ye lágaóyó dokéké e gɨ sɨmɨ tụ́ꞌdụ́ ꞌyị e, zɨ́ye sụ́sụꞌbụ́ ro tụ́ꞌdụ́ ꞌyị ndíyá e, zɨ́ ndíyá eyé ụ́kụ́ne. ");
INSERT INTO bdh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Zɨ́ ngére Eróde úwú phanda ledre Yésụ. Zɨ́ ngíti géyị ꞌyị e ndị́sịyé úkulóꞌbó ledre kɨ́dí, “Yiwáni ꞌyị bábátị́zị́ ꞌyị e bɨ kóo ufunɨ́ wo ba, urú go ne, ndịsị méngị ledre ga bɨ kɨ́ rokoꞌbụyé gére née gɨ zɨ́ kéyị née.” ");
INSERT INTO bdh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngíti géyị ꞌyị e ya, Yésụ nɨ, “Nébị Ilíya kóna ní.” Ngíti géyị ya, “Nɨ ngúru nébị gɨ dongará nébị ga bɨ kóo ꞌdesị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sɨmɨ bɨ Eróde uwú ledre ga bɨ ꞌyị e ndịsịnɨ́ úku yée gɨ ro Yésụ kenée ní, zɨ́a úku ꞌbɨ ené kɨ́dí, “Zɨ́ Yiwáni kóo máúfu wo ní, úrúne née go tɨ́ ne maꞌdíi?” ");
INSERT INTO bdh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eróde ꞌdiꞌbi kóo Erodíya meꞌbe lúnduné Phị́lịpo. Zɨ́ Yiwáni úku ledre kɨ́dí ndaá bɨlámáne zɨ́a méngị kéyị kenée wá. Zɨ́a ꞌdíꞌbi Yiwáni óto wo sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yiwáni ya kɨ́dí, “Ndaá mɨútúásáne zɨ́yị ꞌdíꞌbióyó kára gɨ zɨ́ lúnduyị́ nda zɨ́yị wá.” ");
INSERT INTO bdh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Gɨ zɨ́ kéyị née ní, kémbị́ ꞌbú Yiwáni ndaá kóo do Erodíya wá. Zɨ́a kóo óto ledre sɨmɨné kɨ́dí, née nɨ úfu Yiwáni ꞌbúó. ");
INSERT INTO bdh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eróde ndịsị kóo éré kɨ́ úfu Yiwáni kpá ngịrị, gɨ zɨ́a owo bú kɨ́dí, Yiwáni luyú ené ledre wá. Zɨ́a úku ledre zɨ́ ꞌyị ꞌbɨ sị́gịnị e idínɨ́ lúrú bi kacɨ́ a. Abú ledre bɨ Yiwáni ndịsị kóo úku a ní ndịsị ꞌdóꞌdo sómụ́ ledre ené yá ili kóo kpá fú ndị́sị úwú yata ledre e gɨ zɨ́ Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Zɨ́ mɨsiꞌdi líkpíne zɨ́ kára née Erodíya, gɨ ro úfu Yiwáni. Eróde mengị ayímbi ꞌbɨ sị́lị́ bɨ kóo aránɨ́ née sɨmɨ a ní. Zɨ́a ndóloógụ mɨngburoko ꞌyị ené e kpá kɨ́ mɨngburoko manda ga bɨ ꞌbɨ asikíri e ndịsịnɨ́ méngị moko kéye sɨmɨ káṇgá bɨ Galiláya ní. ");
INSERT INTO bdh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Zɨ́ nyị́ Erodíya ólụ́ne ndị́sị léꞌbé keꞌbị, zɨ́ rokinyi méngị Eróde e kɨ́ ꞌyị ga bɨ kóo ndịsịnɨ́ ánu éyị́ kéye ní mbá. Zɨ́ Ngére ị́nyịné úku ledre zɨ́ owụ́ née kɨ́dí, “Éyị́ bɨ íli zɨ́ma íꞌbí a zɨ́yị ní ꞌdi? Mááyí íꞌbí a zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Zɨ́a ị́nyịné lólóbụ́ zɨ́ owụ́ née kɨ́dí, “Tɨ́ lá éyị́ bɨ íli wo ní mááyí íꞌbí a zɨ́yị, abú yana káṇgá bɨ mááyí ngére sɨmɨ a ba.” ");
INSERT INTO bdh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Zɨ́ owụ́ née ngásáne ndúꞌyú mbágáne kɨ́dí, “Máídí úku ledre ꞌdi?” Mbágáa ya zɨ́a ní, “Idínɨ́ íꞌbíógụ kúṛógbó do Yiwáni ꞌyị bábátị́zị́ ꞌyị e zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Zɨ́ owụ́ née geré ị́nyịné ngásándáꞌbané úku ledre zɨ́ ngére kɨ́dí, “Máíli idínɨ́ íꞌbíógụ kúṛógbó do Yiwáni Babatị́za zɨ́ma do éyị́ ona.” ");
INSERT INTO bdh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Zɨ́ bi sị́nyị́ne ro ngére gbála. Nda lá, gɨ zɨ́a bɨ, lolóbụ́ go do komo ꞌyị ga bɨ ndoloogụ yée ní, zɨ́ ngịrị méngị wo asi wá. ");
INSERT INTO bdh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Zɨ́a kása ꞌyị kɨ́dí, “Ndéré mu úfu Yiwáni zɨ́yị ógụyị́ kɨ́ kúṛógbó doa gɨrí.” Zɨ́ asikíri née ndéréne sɨmɨ sị́gịnị íri, zɨ́a úfu Yiwáni, zɨ́a óṇgo ꞌdécị goa, ");
INSERT INTO bdh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","do ógụné kɨ́ kúṛógbó doa do éyị́, zɨ́a ị́nyịné íꞌbí a zɨ́ owụ́ née. Zɨ́a ndéréne kɨ́e íꞌbí a zɨ́ mbágáne. ");
INSERT INTO bdh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yiwáni uwúnɨ́ ledre a ní, zɨ́ye ógụyé ꞌdíꞌbi umbu a, ndéréye kɨ́e óto a. ");
INSERT INTO bdh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zɨ́ ꞌyịmɨkása e ndáꞌbaógụyé, zɨ́ye úku ꞌdódo ledre ga bɨ mengịnɨ́ yée kɨ́ ledre ga bɨ ꞌdodonɨ́ yée zɨ́ ꞌyị e ní, mbá zɨ́ Yésụ maꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Née ní zɨ́ tụ́ꞌdụ́ ꞌyị e nda kóo ndị́sị kɨ́ ógụ zɨ́ye gbụ́rụ́ gbụrụ gbụ́rụ́ gbụrụ, sịndị́ kadra zɨ́ Yésụ ánu éyị́ kɨ́ ꞌyịmɨkása ené e ndaá. Zɨ́a úku ledre zɨ́ ꞌyịmɨkása ené e kɨ́dí, “Nderézé aka mu do ngíti owụ́ bi gɨ ro zɨ́se aka ꞌdówụ́rosé cúkuꞌdée.” ");
INSERT INTO bdh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Zɨ́ye ị́nyịyé ngúcuyé kɨ́ kuṛúngba ndéréye do ngíti owụ́ bi. ");
INSERT INTO bdh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Zɨ́ tụ́ꞌdụ́ ꞌyị e lúrú yée kɨ́ ndéré, zɨ́ye tónóye ógụyé gɨ sɨmɨ gara ga bɨ ore ní mbá, ndị́sị ngásáye rụụ gɨ do gbúṛóngó, ógụụ́tụ royé fị ye gɨ zɨ́ Yésụ íri. ");
INSERT INTO bdh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sɨmɨ bɨ Yésụ ekị́ogụ gɨ sɨmɨ kuṛúngba ní, zɨ́a lúrú tụ́ꞌdụ́ ꞌyị ga gére née, zɨ́ lerị́ye méngị wo, gɨ zɨ́a nɨyí kacɨ́ komoa káa zɨ́ kábịṛị́kị ga bɨ ꞌyị lúrú bi ndaá kacɨ́ye wá ní. Zɨ́a tónóne ꞌdódo tụ́ꞌdụ́ ledre e zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nda go kɨ́ tagá, zɨ́ ꞌyị lódụ́ kacɨ́ga ógụyé úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, bi ba ꞌbe ndanɨ́ doa wá, kadra utú kpá go. ");
INSERT INTO bdh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ídí úku ledre zɨ́ ꞌyị ga ba ndéréye do bi ga bɨ gbóo gbóo kɨ́ra ní ní, gɨ ro zɨ́ye úgú éyị́ mɨánu, zɨ́ye ánu a.” ");
INSERT INTO bdh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ídísé íꞌbí éyị́ mɨánu zɨ́ye.” Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “ꞌYị ga gére née ofụnɨ́ go. Abú késị́ idí ba gáa zɨ́ze ona kpá za cụ́ késị́ ꞌbɨ ꞌyị bɨ mengị moko gɨ roa sɨmɨbi kị́éꞌdo ní yá, utúasá fú lá úgú éyị́ mɨánu, zɨ́a ásáne kɨ́ ꞌyị ga gére née wá.” ");
INSERT INTO bdh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Ambata nɨ zɨ́se kɨ́rɨ́ née mbá ndu?” Sɨmɨ bɨ nderénɨ́ lúrú a ní, zɨ́ye ógụyé kɨ́ ledre kɨ́dí, “Ambata nɨ íri lá dụụ́ ịnyị, kɨ́ mɨnzéré kénzé e gbre.” ");
INSERT INTO bdh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Zɨ́ Yésụ úku ledre, idínɨ́ ífibáyi ꞌyị ga gére née zɨ́ye ndị́sịyé bi do súwú e ore. ");
INSERT INTO bdh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Zɨ́ ꞌyị e ndị́sịyé bi e mɨngúngúcua, ngíti géyị míya, ngíti géyị cị́ gbre doa sokó. ");
INSERT INTO bdh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zɨ́ Yésụ ꞌdíꞌbi ambata bɨ ịnyị kɨ́ mɨnzéré kénzé ga bɨ gbre née, zɨ́a lúrú bi komo ere ꞌdága, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo, do ꞌdéweífi sɨmɨ a. Zɨ́a íꞌbí yée zɨ́ ꞌyị lódụ́ kacɨ́ne e ífi yée zɨ́ ꞌyị e. Zɨ́a ífi mɨnzéré kénzé ga bɨ gbre née kacɨ́ye kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Zɨ́ ꞌyị ga gére née ánu éyị́, zɨ́a útúásáne kɨ́ye kpịnị. ");
INSERT INTO bdh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Zɨ́ lódụ́ kacɨ́ga ꞌdóꞌdụ́yóko nyụnyụ́ ambata kɨ́ kénzé bɨ ꞌyị e lereomonɨ́ ní, zɨ́ gbété e ꞌdúcuyé kɨ́ye sokó doa gbre. ");
INSERT INTO bdh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ꞌYị ga bɨ kóo anunɨ́ éyị́ née ní, olonɨ́ yaꞌdá e mbá álifu ịnyị. ");
INSERT INTO bdh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Geré gɨ ore, zɨ́ Yésụ kása ꞌyị lódụ́ kacɨ́ne e ndéré ꞌbɨ eyé ꞌdáꞌdá kɨ́ kuṛúngba sóngó née sɨmɨ Beteseyị́da. Zɨ́a aka ídíáká ꞌbɨ ené ꞌdáꞌba úku ledre zɨ́ ꞌyị ga gére née ndáꞌbayé ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sɨmɨ bɨ uku ledre go zɨ́ ꞌyị ga gére née kɨ́dí bayinɨ́ mu ní, zɨ́a ékị́ne do landa íni ini zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zɨ́a ndị́sịné do gbúṛóngó íri ngúcuné gị kɨ́ tagá, zɨ́ ꞌyị lódụ́ kacɨ́ga ndéréógụyé kɨ́ kuṛúngba yana mongụ́ mɨkavu. ");
INSERT INTO bdh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zɨ́ Yésụ lúrúndíki ꞌyị lódụ́ kacɨ́ne e kɨ́ ꞌdóꞌdó kɨ́ ndéré yana iní, gɨ zɨ́a bɨ síli ilí ꞌdịyị roné yóó doyé ní. Nda go kɨ́ sị́ ndóndó zɨ́ Yésụ tónó ndéréne do iní zɨ́ye íri, zɨ́a áyíne ókpóómo yée. ");
INSERT INTO bdh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Zɨ́ye lúrúndíki Yésụ kɨ́ ndéré do iní, somụ́nɨ́ ꞌbɨ eyé kɨ́dí, nɨ ꞌyị lárá, zɨ́ye tónó gbúrógbóye gɨ zɨ́ ngịrị. ");
INSERT INTO bdh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sɨmɨ bɨ ịnyịnɨ́ mbá lúrúndíki Yésụ ní, zɨ́ ngịrị méngị yée kɨ́ngaya. Zɨ́ Yésụ úku ledre kɨ́dí, “Ndásé éré ngịrị wá, ídísé ódó mɨmbéꞌdesé née yị́ ené máa.” ");
INSERT INTO bdh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Zɨ́a ékị́ne zɨ́ye sɨmɨ kuṛúngba, geré zɨ́ mongụ́ síli bɨ gáa née ndécị́ne, zɨ́ bi ídíne sií. Zɨ́ ledre née lụ́tụ́ne komoyé. ");
INSERT INTO bdh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Abú lurúnɨ́ ledre bɨ Yésụ méngị zɨ́a óyólóꞌbó ambata bɨ cúkuꞌdée ní, ídíne mongụ́ éyị́ zɨ́ tụ́ꞌdụ́ ꞌyị e mbá ánu a ní, go cụ́ kɨ́ komoyé yá, zɨ́ sómụ́ ledre eyé ꞌdụ́tụné owoꞌdiꞌbinɨ́ ini ledre gɨ sɨmɨ a wá. ");
INSERT INTO bdh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sɨmɨ bɨ ꞌdogụnɨ́ bi go sága ní, zɨ́ye ndéréye sɨmɨ gara bɨ Geneseréta ní, zɨ́ye ị́nyịyé ódóngéṛị kuṛúngba ore. ");
INSERT INTO bdh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sɨmɨ bɨ ekị́ogụnɨ́ ní, geré zɨ́ ꞌyị e ówo a kɨ́dí Yésụ ogụ née ne. ");
INSERT INTO bdh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Zɨ́ ꞌyị ga gére née báyiyé sɨmɨ gara ga bɨ ore ní mbá kɨ́ ị́mbị́ógụ ꞌyị ndíyá eyé e zɨ́ Yésụ tɨ́ káa zɨ́ bɨ lengbe ndịsịnɨ́ méngị a togụ́ owonɨ́ go ya Yésụ nɨ go ore ní. ");
INSERT INTO bdh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bi ga bɨ za mbá Yésụ ndịsị ndéré doyé ní, ꞌyị e ndịsịnɨ́ ị́mbị́ógụ ꞌyị ndíyá eyé e zɨ́a, togụ́ sɨmɨ sụ́ụ zɨ́ye ndị́sị dódó royé roa gɨ ro zɨ́ ꞌyị ndíyá eyé e ꞌdíꞌbi lá gba tara bongó bɨ gɨ roa ní. Yée ga bɨ ꞌdiꞌbinɨ́ sị́lị́ye roa ní, zɨ́ ndíyá eyé ụ́kụ́ne gɨ royé mbá. ");
INSERT INTO bdh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kadra kị́éꞌdo zɨ́ Farụsáyo e kɨ́ ngíti géyị ꞌyị ꞌdódo lorụ ga bɨ ogụnɨ́ gɨ sɨmɨ Yerụsaléma ní yóko royé cigí Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Zɨ́ye lúrúndíki ngíti géyị ꞌyị lódụ́ kacɨ́ Yésụ kɨ́ ndị́sị ánu éyị́ kɨ́ “ị́ndrị” née kɨ́dí lugunɨ́ sị́lị́ye kí wá. ");
INSERT INTO bdh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yụ́da e, kɨ́ngaya kɨ́ Farụsáyo e, anunɨ́ eyé eyị́ geré mɨánu wá, nɨyí aka lúgu sị́lị́ye kacɨ́ ondụ́ eyé kí. ");
INSERT INTO bdh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Togụ́ ndaꞌbaogụnɨ́ go gɨ sɨmɨ sụ́ụ yá, nɨyí aka lúgu sị́lị́ye kí nɨyí fú ánu éyị́. Zɨ́ye ndị́sịyé kpá lódụ́ kacɨ́ ngíti géyị ondụ́ ga bɨ káa zɨ́ lúgu sɨmɨ éyị́ ga bɨ ndịsịnɨ́ ánu éyị́ sɨmɨyé ní. ");
INSERT INTO bdh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Zɨ́ Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ ga gére née ndúꞌyú Yésụ kɨ́dí, “Éyị́ bɨ ꞌyị lódụ́ kacɨ́yị mengịnɨ́ ledre e gɨ zɨ́a kacɨ́ lorụ ꞌbɨ ondụ́ ꞌbɨ mɨngburoko ꞌyị ezé e gɨ zɨ́a wá ní ꞌdi? Bɨ zɨ́ye ndị́sịyé ánu éyị́ geré mɨánu, lugunɨ́ sị́lị́ye kí wá ní?” ");
INSERT INTO bdh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ábuwá, nébị Isáya uku kóo gɨ rosé tɨ́ mbigí ledre kɨ́dí, “ ‘ꞌYị ga ba ndịsịnɨ́ óto úndrumá lá dụụ́ do tarayé, tɨ́ lá mɨmbéꞌdeyé nɨ yị́ ené gɨ romá gbála. ");
INSERT INTO bdh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ndịsịnɨ́ mbófo máa lá gbékpị́ne, ndị́sịnɨ́ tɨ́ ꞌdódo ledre ní, tɨ́ lá yị́ eyé lorụ eyé ꞌbɨ ꞌyịmaꞌdí e.’ ");
INSERT INTO bdh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ótoómosé mbigí lorụ ꞌbɨ Lomo kenée, zɨ́se nda yị́ esé lányáse ro ondụ́ esé ꞌbɨ ꞌyịmaꞌdí e.” ");
INSERT INTO bdh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zɨ́a úku ándá ledre zɨ́ye kɨ́dí, “Ndị́sịsé léꞌbéꞌdófụ do lorụ ꞌbɨ Lomo, zɨ́se ndị́sịsé méngị ledre esé e kacɨ́ ondụ́ ꞌbɨ bulúndusé e. ");
INSERT INTO bdh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mụ́sa iꞌbí kóo lorụ ꞌbɨ Lomo go zɨ́se kɨ́dí, ‘Ídí óto úndru ꞌbụyị́ e kɨ́ mbágáyị. ꞌYị bɨ nɨ uku tara sinyí zɨ́ ꞌbụné e kɨ́ mbágáne ní, idínɨ́ úfu wo ꞌdáꞌba.’ ");
INSERT INTO bdh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ndị́sịsé ꞌdódo lorụ bɨ ꞌbɨ bulúndusé e ní zɨ́ ꞌyị e kɨ́dí, togụ́ ꞌyị ꞌbụa togụ́ mbú mbágáa ili sáká éyị́ gɨ zɨ́a yá, nɨ mɨútúásáne ꞌyị née idí úku ledre zɨ́ ꞌbụné née togụ́ mbágáne kɨ́dí, ‘Éyị́ bɨ máíli sáká yị́ị kɨ́e ní, ndaá lolụ wá, máíꞌbí go zɨ́ Lomo.’ ");
INSERT INTO bdh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ndị́sịsé née go sínyiónzó ꞌyị e, sakánɨ́ lolụ ꞌbụyé e kɨ́ mbágáye wá. ");
INSERT INTO bdh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ótoómosé lorụ bɨ ꞌbɨ Lomo kenée, zɨ́se lányáse ro ondụ́ esé. Zɨ́se ndị́sịsé méngị tụ́ꞌdụ́ ngíti géyị bɨsinyí ledre e.” ");
INSERT INTO bdh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zɨ́ Yésụ ndóloógụ tụ́ꞌdụ́ ꞌyị e, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ídísé aka úwú ledre bɨ mááyí úku a ba, zɨ́se ówo ini ledre gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Éyị́ bɨ ꞌyịmaꞌdí ánu sɨmɨné ní, oto ené wo zɨ́a ídíne bɨsinyíne do komo Lomo wá. Bɨsinyí ledre bɨ ndịsị olụ́ogụ gɨ taraꞌyị ní, ndịsị óto ꞌyị ne, zɨ́a ídíne bɨsinyíne do komo Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ꞌYị bɨ mbílía uwú ledre bú ní, ídí úwú ledre née bɨlámáne.” ");
INSERT INTO bdh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sɨmɨ bɨ Yésụ ndaꞌbanɨ́ nda gɨ ore go ꞌbe, nɨyí go ꞌdị́cị́ ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ndúꞌyú wo gɨ ro muruwayi bɨ gáa uku née. ");
INSERT INTO bdh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ówosé esé ini ledre gɨ sɨmɨ ledre bɨ gáa máúku née fú lá wá? Máyá, éyị́ bɨ ꞌyịmaꞌdí anu wo sɨmɨné ní, oto ené wo zɨ́a ídíne bɨsinyíne do komo Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Éyị́ mɨánu nderé ené ndị́sị sɨmɨ mɨmbéꞌde ꞌyị wá, ndịsị lá sɨmɨ ꞌyị, nda gɨrí, zɨ́a ólụ́ógụné gɨ sɨmɨ a sága. Éyị́ mɨánu e mbá nɨyí bɨlámáye gɨ ro ánu yée.” ");
INSERT INTO bdh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Zɨ́a ị́nyịné kpá úku ngíti ledre kɨ́dí, “Éyị́ bɨ ndịsị ꞌdíꞌbióyó ꞌyị gɨ ro Lomo ꞌdáꞌba ní, nɨ lá dụụ́ bɨsinyí mɨmbéꞌde ꞌyị. ");
INSERT INTO bdh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gɨ zɨ́a ꞌyị bɨ mɨmbéꞌdea emengụ́ ní, bɨsinyí mɨsómụ́ ledre nɨyí ndị́sị ógụ zɨ́a káa zɨ́: méngị ꞌberị, kɨ́ úgu ugu, kɨ́ úfu ꞌyị e, kɨ́ sóꞌdo roꞌyị kɨ́ ꞌyị bɨ ófụ́sé rosé kéne wá ní, ");
INSERT INTO bdh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kɨ́ óto ꞌbú éyị́ ꞌbɨ ꞌyị e, kɨ́ ngíti géyị bɨsinyí ledre e, kɨ́ lóndo ꞌyị e, kɨ́ ledre bɨ ndịsị ꞌdíꞌbiógụ komokenyị́ ní, kɨ́ óto bɨsinyí mɨmbéꞌde ro ꞌyị e, kɨ́ lị́kpị́ ịrị ꞌyị, kɨ́ ị́lị́, nda kpá kɨ́ bɨcayi ledre e. ");
INSERT INTO bdh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bɨsinyí ledre káa zɨ́ ga gére ní, ndịsịnɨ́ ólụ́ógụ gɨ sɨmɨ mɨmbéꞌde ꞌyị, zɨ́ye óyólóꞌbó ꞌyị bɨsinyíne do komo Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zɨ́ Yésụ ị́nyịné gɨ ore ndéréne sɨmɨ gara bɨ Táyire ní. Zɨ́a ólụ́ne sɨmɨ ngíti ꞌdị́cị́ ili ené kóo zɨ́ ngíti ꞌyị ówo a wá. Abú kenée ndotó, ledrea utúasá ené lóꞌbo wá. ");
INSERT INTO bdh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngíti kára nɨ kóo ore nyị́a nɨ kɨ́ dokéké sɨmɨné. Sɨmɨ bɨ uwú ledre kɨ́dí Yésụ nɨ sɨmɨ ngíti ꞌbe ore ní, zɨ́a geré ógụné útúne do ngụ́ṛụ́ sịndị́ne bi kóꞌdụ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kára máa née nɨ nyị́ ꞌyị ꞌbɨ Gịrị́gị aránɨ́ wo sɨmɨ káṇgá bɨ Sụ́rịya bɨ ndịsịnɨ́ kpá ndólo a Fonị́sịya ní. Zɨ́a ógụ dódó roné zɨ́ Yésụ idí ndéré lágaóyó dokéké gɨ sɨmɨ nyị́ne ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Éyị́ mɨánu ꞌbɨ owụ́ e idínɨ́ ánu yị́ eyé ye, ndanɨ́ íꞌbí a zɨ́ ị́sị e wá.” ");
INSERT INTO bdh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kára née ya, “Nɨ tɨ́ káa zɨ́ bɨ úku née Ngére. Abú kenée ndotó, ị́sị nɨyí ꞌdóꞌdụ́ ꞌbɨ eyé gbóo nyụnyụ́ a bɨ nɨ ndị́sị ṛéṛe gɨ tara owụ́ maáge ní.” ");
INSERT INTO bdh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yésụ ya zɨ́a ní, “Ódro go bɨlámáne, ndáꞌba mu ꞌbe, dokéké olụ́ogụnɨ́ gɨ sɨmɨ owụ́ ꞌbɨ eyị́ go.” ");
INSERT INTO bdh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Zɨ́ kára née ndáꞌbalúgu roné ꞌbe, zɨ́a ógụndíki owụ́ kɨ́ ꞌdúꞌdu dokéké olụ́ogụnɨ́ gɨ sɨmɨa go. ");
INSERT INTO bdh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zɨ́ Yésụ ị́nyịné gɨ sɨmɨ gara bɨ Táyire, ndéréne kpụrụ́ gɨ sɨmɨ wo bɨ Sidóna ní, zɨ́a ndéréógụné do mɨkavu Galiláya, zɨ́a ndéréókpóne sɨmɨ Dikapolị́sị. ");
INSERT INTO bdh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Zɨ́ ngíti géyị ꞌyị e ógụyé kɨ́ ngíti oꞌdo, nɨ mɨmbílí ngbụtụ́, odroenzị roné gɨ zɨ́a wá, zɨ́ye dódó royé ro Yésụ, idí óto sị́lị́ne ro oꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sɨmɨ bɨ Yésụ ꞌdíꞌbi oꞌdo née ndoo ꞌdí sogo ní, zɨ́a ésị nzisị́lị́ne gu mbílía. Zɨ́a lúꞌbu súrú, zɨ́a óto a do dondene oꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Zɨ́ Yésụ ị́nyịné lúrú bi komo ere ꞌdága, zɨ́a ꞌdówụ́ne difi, zɨ́a úku ledre kɨ́dí, “Éfata” ledre gɨ sɨmɨ a kɨ́dí, “Líkpí mu” ");
INSERT INTO bdh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Geré, zɨ́ mbílí oꞌdo née líkpíne, zɨ́ dondenea kpá líkpí roné, zɨ́a tónó ndị́sị ódroné zɨ́ ꞌyị e bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zɨ́ Yésụ úku ledre kɨ́dí, “Ndásé aka úku ꞌdódo ledre née zɨ́ ꞌyị e wá.” Abú ụcụomo yée kenée ndotó, ukutatánɨ́ nda yị́ eyé ledre née ꞌdáꞌdá. ");
INSERT INTO bdh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sɨmɨ bɨ ꞌyị e uwúnɨ́ ledre née ní, zɨ́a lụ́tụ́ne kacɨ́ komoyé, zɨ́ye úku ledre kɨ́dí, “Ábuwá, Yésụ nɨ yị́ ené bɨlámá ꞌyị. Mengịyeme ofụ ledre e go. Yeme ꞌyị ga bɨ odronɨ́ wá ní zɨ́ye ódroyé. Yée ga bɨ mɨmbílí ngbụtụ́ e ní, zɨ́ye úwú ledre.” ");
INSERT INTO bdh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sɨmɨ ngíti sịndị́ kadra, zɨ́ tụ́ꞌdụ́ ꞌyị e kpá yóko royé. Sɨmɨ bɨ éyị́ mɨánu ndaá lolụ zɨ́ye wá ní, zɨ́ Yésụ ndóloógụ ꞌyị lódụ́ kacɨ́ne e úku ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lerị́ ꞌyị ga ba mengị máa yáa go mɨméngị, mengịzé kéye kɨ́ra go sị́lị́ ota, éyị́ mɨánu ndaá zɨ́ye wá. ");
INSERT INTO bdh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Utúasá zɨ́ma ótoómo yée ndáꞌbayé ꞌbe kɨ́ ꞌbú wá, komoyé nɨ ụ́lụ́ do mɨsiꞌdi, zɨ́ye útúye gɨ zɨ́a ngíti géyị ogụnɨ́ gɨ gbála.” ");
INSERT INTO bdh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ꞌYị lódụ́ kacɨ́ga ya zɨ́a ní, “Azé ówo éyị́ mɨánu sɨmɨ súwú ona íꞌbí a zɨ́ tụ́ꞌdụ́ ꞌyị e káa zɨ́ ga gére née gɨ ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Ambata nɨ zɨ́se kɨ́rɨ́ née ndu?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ambata nɨ lá dụụ́ ịnyị doa gbre (7).” ");
INSERT INTO bdh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Zɨ́a úku ledre zɨ́ ꞌyị e kɨ́dí ndị́sịsé aka bi. Zɨ́a ꞌdíꞌbi ambata ga bɨ ịnyị doa gbre (7) née, íꞌbí mbófo éyị́ zɨ́ Lomo gɨ royé, zɨ́a ꞌdéweífi sɨmɨyé, íꞌbí yée zɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ ro ífi yée zɨ́ ꞌyị e, zɨ́ye méngị a tɨ́ kenée. ");
INSERT INTO bdh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mɨnzéré kénzé e nɨyí kóo kpá bo zɨ́ye ore cúkuꞌdée, zɨ́ Yésụ kpá íꞌbí mbófo éyị́ zɨ́ Lomo, zɨ́a ị́nyịné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née, idínɨ́ kpá ífi kénzé ga gére née zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Zɨ́ ꞌyị ga gére née ánu éyị́, zɨ́a ásáne kɨ́ye mbá. Zɨ́ ꞌyị lódụ́ kacɨ́ga ꞌdóꞌdụ́yóko ngítí a bɨ ꞌyị e lereomonɨ́ ní, kɨ́ mbụ́ra e kpá ịnyị doa gbre. ");
INSERT INTO bdh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ꞌYị e nɨyí kóo tụ́ꞌdụ́, yaꞌdá e nɨyí ꞌbɨ eyé álifu eso (4,000). Zɨ́ Yésụ íꞌbí mɨsiꞌdi zɨ́ye ndáꞌbayé ꞌbe ꞌbɨ eyé e. ");
INSERT INTO bdh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Geré zɨ́ye ị́nyị ꞌbɨ eyé kɨ́ ꞌyị lódụ́ kacɨ́ne e ékị́ye sɨmɨ kuṛúngba ndéréye sɨmɨ ngíti káṇgá kɨ́ ịrịné Dalamanụ́ta. ");
INSERT INTO bdh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zɨ́ ngíti géyị Farụsáyo e ógụyé úzu Yésụ kɨ́ ndúꞌyú kɨ́dí, “Idí méngị ngíti géyị ledre ga bɨ kɨ́ rokoꞌbụyé komo ere ní.” ");
INSERT INTO bdh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zɨ́ Yésụ ꞌdówụ́ne difi, zɨ́a úku ledre zɨ́ye kɨ́dí, “Éyị́ bɨ ꞌyị ga bɨ cakaba ba ndịsịnɨ́ ndúnduꞌyú gɨ ro zɨ́ye lúrú ledre bɨ kɨ́ rokoꞌbụyé té kí kɨ́ komosé gɨ zɨ́a ní ꞌdi? Máúku zɨ́se maꞌdíi, máútúásá méngị éyị́ kenée zɨ́ ꞌyị e káa zɨ́se née wá.” ");
INSERT INTO bdh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zɨ́a ótoómo yée ore, zɨ́a ndáꞌba ékị́lúgu roné sɨmɨ kuṛúngba, do ꞌdógụ mɨkavu sága gɨ ꞌdí keṛị́. ");
INSERT INTO bdh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ábuwá ꞌyịmɨkása e otoomolịgịnɨ́ ambata go. Wo bɨ zɨ́ye sɨmɨ kuṛúngba ní nɨ lá dụụ́ kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yésụ ya zɨ́ye ní, “Komosé idí ídí rosé. Zɨ́se ꞌbáꞌbá rosé gɨ zɨ́ bɨsinyí ꞌdódo ledre ꞌbɨ Farụsáyo e kɨ́ ꞌyị ꞌbɨ Eróde e bɨ káa zɨ́ ꞌdeꞌdị́ bɨ ndịsịnɨ́ óto a sɨmɨ ambata eyé e ní.” ");
INSERT INTO bdh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zɨ́ye tónó ódroyé dengbị́ye kɨ́dí, “Uku ledre née kenée gɨ zɨ́a bɨ ambata ndaá zɨ́ze ona wá ní?” ");
INSERT INTO bdh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yésụ ówo sómụ́ ledre eyé née go, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndị́sịsé ódro gɨ ro ambata bɨ ngárá ndaá ní gɨ ro ꞌdi? Ówoyémesé esé fú lá ledre née wá? Éyị́ bɨ mɨmbéꞌdesé nɨ gɨ zɨ́a bɨsinyíne kenée ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bɨ komosé nɨ bo ní, lúrúsé esé bi wá? Mbílíse uwú ené kpá ledre wá? Sómụ́ndíkisé esé kpá ledre wá? ");
INSERT INTO bdh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sɨmɨ bɨ kóo máꞌdéweífi sɨmɨ ambata ga bɨ ịnyị (5), zɨ́ ꞌyị ga bɨ álifu ịnyị (5,000) ní, ngítí a bɨ kóo anuomonɨ́ ní, ꞌducunɨ́ kóo gbété e ndu?” Zɨ́ye úkulúgu ledre kɨ́dí, “Gbété e sokó doa gbre (12).” ");
INSERT INTO bdh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sara yée ga bɨ kóo ịnyị doa gbre (7) máꞌdéweífi sɨmɨyé zɨ́ ꞌyị ga bɨ álifu eso (4,000) ní, ꞌdóꞌdụ́ ꞌdúcusé kóo mbụ́ra e kɨ́ ngítí ye ndu?” Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Mbụ́ra e ịnyị doa gbre (7).” ");
INSERT INTO bdh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yésụ ya zɨ́ye ní, “Sara née ní ní, ówosé aka ledre gɨ sɨmɨ a fú lá wá?” ");
INSERT INTO bdh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zɨ́ye ógụyé sɨmɨ Beteseyị́da, zɨ́ ngíti géyị ꞌyị e ꞌdíꞌbiógụ ngíti oꞌdo komoa ndaá, zɨ́ye dódó royé ro Yésụ idí óto sị́lị́ne ro oꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zɨ́ Yésụ ꞌdíꞌbi sị́lị́a, zɨ́ye ólụ́ógụyé kéne gɨ sɨmɨ owụ́ gara née sága. Zɨ́a óṛó súrú ro komo oꞌdo née, zɨ́a óto sị́lị́ne roa, zɨ́a ndúꞌyú wo kɨ́dí, “Lúrúndíki éyị́ e go íri?” ");
INSERT INTO bdh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zɨ́a lúrú bi cii, zɨ́a úku ledre kɨ́dí, “Málúrúndíki tɨ́ ꞌyị e go ní, tɨ́ lá nɨyí káa zɨ́ kágá e ndịsịnɨ́ gámá ye ní.” ");
INSERT INTO bdh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zɨ́ Yésụ kpá ótoándá sị́lị́ne ro komoa, zɨ́ komoa líkpíne zɨ́a nda lúrúyéme éyị́ e bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Ndáꞌba mu ꞌbe, tɨ́ lá ndá aka ꞌdódo royị́ zɨ́ ꞌyị e sɨmɨ gara íri wá.” ");
INSERT INTO bdh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zɨ́ Yésụ ị́nyịyé gɨ sɨmɨ Beteseyị́da gɨ ore kɨ́ ꞌyị lódụ́ kacɨ́ne e, do ndéréógụyé sɨmɨ do ꞌbe ga bɨ cigí gara bɨ Kayisaríya Phị́lịpo ní. Sɨmɨ ndéréye do mɨsiꞌdi, zɨ́a ndúꞌyú ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “ꞌYị e ndịsịnɨ́ úku a ya mááyí náambi?” ");
INSERT INTO bdh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ngíti géyị ꞌyị e ukunɨ́ ꞌbɨ eyé kɨ́dí, áyí Yiwáni ꞌyị Bábátị́zị́ ꞌyị e, ngíti géyị ya, áyí nébị Ilíya, ngíti géyị ya, áyí ngúru nébị ga bɨ kóo ꞌdesị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zɨ́ Yésụ kpá ndúꞌyú ándá yée kɨ́dí, “Sara nda sée, úkusé ꞌbɨ esé kɨ́dí mááyí náambi?” Pétero ya zɨ́a ní, “Áyí Kɨ́résịto.” ");
INSERT INTO bdh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zɨ́ Yésụ lórụ yée kɨ́dí, “Ndásé aka úku ꞌdódo ledre máa née zɨ́ ꞌyị e wá.” ");
INSERT INTO bdh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Zɨ́ Yésụ tónóne ꞌdódo ledre bɨ ꞌyị e nɨyí méngị née kɨ́e ní zɨ́ ꞌyị lódụ́ kacɨ́ne kɨ́dí, “Mɨngburoko ꞌyị e, kɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kpá kɨ́ ꞌyị ꞌdódo lorụ e nɨyí karanée ị́nyị mbá méngị láráma, zɨ́ye úfu máa, gɨ do kacɨ́ sị́lị́ ota, zɨ́ma úrúma.” ");
INSERT INTO bdh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sɨmɨ bɨ uku ledre fúó kenée ní, kɨ́dí nɨyí karanée méngị láráne zɨ́ye kpá úfu née ní, zɨ́ Pétero ꞌdíꞌbi wo ndéré kɨ́e ndoo ꞌdí sogo, ndị́sịné úku ledre zɨ́a éyị́ ndaá méngị roné kenée wá. ");
INSERT INTO bdh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zɨ́ Yésụ óyó kóꞌdụ́ne zɨ́ ꞌyị lódụ́ kacɨ́ne e, zɨ́a úku ledre zɨ́ Pétero kɨ́dí, “Ị́nyị gɨ cigíma íri Satána. Sómụ́ ledre eyị́ née ndaá ꞌbɨ ené ꞌbɨ Lomo wá, yị́ ené ꞌbɨ ꞌyịmaꞌdí.” ");
INSERT INTO bdh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nda gɨ ore, zɨ́ Yésụ ndóloyóko tụ́ꞌdụ́ ꞌyị e kpá kɨ́ ꞌyị lódụ́ kacɨ́ne e zɨ́a úku ledre zɨ́ye kɨ́dí, “Togụ́ ꞌyị ili ídí ꞌyị lódụ́ kacɨ́ma yá, idí ótoómo ledre ené e mbá zɨ́a ị́mbị́ mɨngbúngbu kágá ené lódụ́ máa. ");
INSERT INTO bdh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ꞌYị bɨ ili yómo roné kɨ́ roné ní, omo gú wá. Togụ́ ꞌyị iꞌbí roné za mbá zɨ́ma kpá gɨ ro bɨlámá ledre ꞌbɨ Lomo yá, nɨ ídí kɨ́ trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Abú ꞌyị nɨ ba kɨ́ éyị́ ga bɨ do sogo káṇgá ba za mbá zɨ́ne, togụ́ trịdrị bɨ za fí ní ndaá zɨ́a wá yá, éyị́ ga gére née mengịnɨ́ éyị́ zɨ́a mbá wá. ");
INSERT INTO bdh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Éyị́ bɨ kị́éꞌdo do sogo káṇgá ona yaá nɨ ꞌdíꞌbiógụ trịdrị bɨ za fí ní zɨ́ ꞌyị ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Togụ́ dokuwu mengị ꞌyị zɨ́a otoomo ledre amá lá gɨ zɨ́ ngịrị ꞌyị lúyú ledre ga bɨ ilinɨ́ ledre amá wá ní yá, sɨmɨ bɨ karanée máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, mááyí ndáꞌbaógụ kɨ́ maláyika amá e sɨmɨ rokoꞌbụ ꞌbɨ Babá ní, dokuwu nɨ kpá méngị máa zɨ́ma ótoómo ꞌyị máa née.” ");
INSERT INTO bdh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zɨ́a kpá úku ándá ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, ngíti géyị ꞌyị e gɨ dongaráse bɨ ásé tóro née, nɨyí aka lúrú rokoꞌbụ bɨ gɨ ꞌbe ꞌbɨ Lomo ní kɨ́ komoyé té kí nɨyí nda fú úyu.” ");
INSERT INTO bdh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gɨ do kacɨ́ sị́lị́ ịnyị doa kéṛị́ (6), zɨ́ Yésụ ꞌdíꞌbi Pétero e, kɨ́ Yakóbo e, kɨ́ lúnduné Yiwáni zɨ́ye ndéré ékị́ye ngúcuyé do ngbángbá landa ꞌdága. Zɨ́ toso Yésụ óyólóꞌbó roné do komoyé do landa íri. ");
INSERT INTO bdh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zɨ́ bongó bɨ roa ní óyólóꞌbó roné bɨkenyị́ne kpɨ́lélé, ngíti éyị́ ndaá káa zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Zɨ́ mɨngburoko ꞌyị e gbre, Ilíya e kɨ́ Mụ́sa bɨ kóo Lomo ꞌdiꞌbi yée go ꞌdesị́ ní, ólụ́ógụyé zɨ́ Yésụ, zɨ́ye ndị́sị ódroyé kéye. ");
INSERT INTO bdh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Zɨ́ Pétero úku ledre zɨ́ Yésụ kɨ́dí, “ꞌYị ꞌdódo ledre, utúasá mɨútúásá zɨ́ze ndị́sịzé ona. Nɨ bɨlámáne zɨ́ze yéme kụ́tụ́ e ota kɨ́ra, ꞌbɨ eyị́, ꞌbɨ Mụ́sa kɨ́ ꞌbɨ Ilíya.” ");
INSERT INTO bdh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pétero owo mbị́ éyị́ bɨ née ndịsị úku a née wá gɨ zɨ́a ngịrị mengị yée go mɨméngị kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Geré zɨ́ mongụ́ bụṛụngụ́ ógụné kụụ sólụ yée yeré, zɨ́ kúrú ꞌyị ówụ́ne gɨrí kɨ́dí, “Ba Owụ́ ꞌbɨ amá, ꞌbúa ofụ domá go. Ídísé úwú ledre gɨ taraa.” ");
INSERT INTO bdh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zɨ́ye lúrú bi cigíye gbaá, lurúndikinɨ́ lá dụụ́ Yésụ, Mụ́sa e kɨ́ Ilíya ndanɨ́ eyé lolụ wá. ");
INSERT INTO bdh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nda sɨmɨ mɨékị́ógụyé gɨ do landa gɨrí, zɨ́a ị́nyịné lórụ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Ndásé úku ꞌdódo ledre bɨ gáa lúrúsé née zɨ́ ꞌyị e wá, ꞌbúó togụ́ karanée máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, máúrú go gɨ sɨmɨ umbu.” ");
INSERT INTO bdh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pétero e ukunɨ́ ledre née zɨ́ ꞌyị e mbá wá. Zɨ́ye ndị́sịyé úkulóꞌbó a lá dengbị́ye kɨ́dí, “Née kenée lárá ledre ꞌdi, kɨ́ ledre ꞌbɨ úrú gɨ sɨmɨ umbu sɨmɨné kenée née?” ");
INSERT INTO bdh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zɨ́ye ndúꞌyú Yésụ kɨ́dí, “Ndaá ꞌbɨ ené bɨ ꞌyị ꞌdódo lorụ ꞌbɨ Mụ́sa ukunɨ́ kɨ́dí, Ilíya nɨ aka ógụ ꞌdáꞌdá kí zɨ́ Kɨ́résịto nda ógụné ní wá?” ");
INSERT INTO bdh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Maꞌdíi, Ilíya nɨ aka ndáꞌbaógụ fị ne yémelúgu ledre ga bɨ kóo sinyínɨ́ ní kí. Sara éyị́ bɨ mɨéké kúrú Lomo uku ledre gɨ zɨ́a kɨ́dí, Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ꞌdóꞌdó zɨ́ ꞌyị e ásiyé gɨ ro a gɨ zɨ́a kí ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Máúku zɨ́se, Ilíya ogụ kóo go mengịnɨ́ kóo lárá a bɨsinyíne cé káa zɨ́ bɨ mɨéké kúrú uku Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sɨmɨ bɨ Yésụ ndaꞌbaogụnɨ́ zɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ idíakánɨ́ ꞌbɨ eyé ꞌdáꞌba ore ní, zɨ́ye ógụndíki tụ́ꞌdụ́ ꞌyị e, ꞌyị ꞌdódo lorụ e nɨyí go ndị́sị ítí kangú kɨ́ ꞌyị lódụ́ kacɨ́ga ga gére ní. ");
INSERT INTO bdh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị ga gére née lurúndikinɨ́ Yésụ ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́, zɨ́ye ụ́dụyé mbá rụụ ngásáye íꞌbí mandá zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zɨ́ Yésụ ndúnduꞌyú kɨ́dí, “Ndị́sịsé ítí kangú bɨ ꞌdényé bɨ káa ba ba gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Zɨ́ ngíti oꞌdo gɨ do ngárá ꞌyị e kɨ́rɨ́ née úku ledre kɨ́dí, “ꞌYị ꞌdódo ledre, máógụ gáa kɨ́ owụ́ ꞌbɨ amá ba zɨ́yị. Dokéké ndịsị méngị wo, ꞌdụ́tụ taraa go, odro lolụ gɨ zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Togụ́ tonó wo go yá, zɨ́a lálaónzó wo gbụ bi, zɨ́ somụ́ ndị́sị ógụné taraa kodụ kodụ kodụ káa. Zɨ́a ndị́sịné kɨ́ náná do soné, zɨ́a órụné gɨ zɨ́a ꞌduo gbɨgaga káa. Mándúꞌyú gáa ꞌyị lódụ́ kacɨ́yị ga ba, gɨ ro zɨ́ye lágaóyó a gɨ sɨmɨ a ní, romo yée mɨrómo utúasánɨ́ kɨ́e wá.” ");
INSERT INTO bdh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yésụ ya zɨ́ye ní, “Ṇgúṇgusé aka esé ledremá wá? Azé ndị́sị go fú lá kése káa ní? Utúasá idí kenée wá. Ógụsé kɨ́ owụ́ née gɨrí mu zɨ́ma yáa.” ");
INSERT INTO bdh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zɨ́ye ógụyé kɨ́ owụ́ née zɨ́ Yésụ. Sɨmɨ bɨ bɨcayi lomo lúrúndíki Yésụ ní, zɨ́a óto owụ́ née zɨ́ roa ndị́sị lángbané, zɨ́a lálaónzó owụ́ née gbụ bi, zɨ́a ndị́sị gbúrógbóne, zɨ́ somụ́ kpá ndị́sị ógụné gɨ taraa. ");
INSERT INTO bdh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zɨ́ Yésụ ị́nyịné ndúꞌyú ꞌbụa kɨ́dí, “Éyị́ máa née luꞌbú kɨ́e goó?” ꞌBụa ya zɨ́ Yésụ ní, “Tonó kóo méngị wo go kú gɨ do owụ́ a zaá gị karaba ba. ");
INSERT INTO bdh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndịsị kɨ́ lálaónzó wo ku phoꞌdụ, kpá kɨ́ lálaónzó wo sɨmɨ iní gɨ ro zɨ́ne úfu wo ꞌdáꞌba. Togụ́ útúásá go sáká zée, lúrú aka lerị́ze zɨ́yị lágaóyó a gɨ sɨmɨ owụ́ née ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yésụ ya zɨ́ ꞌbụ owụ́ née ní ní, “Úku yá togụ́ mááyí útúásá yá? ꞌYị bɨ ṇguṇgu ledremá go ní, owo bú kɨ́dí máútúásá go méngị éyị́ e mbá.” ");
INSERT INTO bdh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Geré zɨ́ ꞌbụ owụ́ née úku ledre kɨ́dí, “Maꞌdíi, máṇgúṇgu ledreyị́ go lá cúkuꞌdée. Ídí sáká máa, gɨ ro zɨ́ma ṇgúṇgu ledreyị́ nda za kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sɨmɨ bɨ Yésụ lurú tụ́ꞌdụ́ ꞌyị e nɨyí go yóko royé cigíye kɨ́ oꞌdo née ní ní, zɨ́a úku ledre zɨ́ bɨcayi lomo née kɨ́dí, “Yị́ị, bɨ ꞌdụ́tụ mbílí owụ́ ba kpá kɨ́ taraa ní, ólụ́ógụ gɨ sɨmɨ a mu ndá lolụ ndáꞌbalúgu royị́ sɨmɨ a wá.” ");
INSERT INTO bdh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zɨ́ bɨcayi lomo née ị́drị́ónzó owụ́ née gbụ bi zɨ́a ndị́sị gbúgbúne káa zɨ́ ayí go úyu ní, geré zɨ́ bɨcayi lomo née ólụ́ógụné gɨ sɨmɨ a, zɨ́ owụ́ née ídíne káa zɨ́ uyu go ní. Zɨ́ tụ́ꞌdụ́ ꞌyị e úku ledre kɨ́dí, “Uyu go.” ");
INSERT INTO bdh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Zɨ́ Yésụ ꞌdíꞌbi sị́lị́ owụ́ née, lálasị́kpị wo ꞌdága zɨ́ roa ídíne bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zɨ́ Yésụ ndáꞌbayé kɨ́ ꞌyị lódụ́ kacɨ́ne e ꞌbe zɨ́ye ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, éyị́ bɨ gáa utúasázé lágaóyó bɨcayi lomo gɨ sɨmɨ owụ́ née gɨ zɨ́a wá ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yésụ ya zɨ́ye ní, “Ini zɨ́ Lomo utúasá kɨ́ ledre e káa zɨ́ ga gére ne dụụ́ ne.” ");
INSERT INTO bdh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zɨ́ye ị́nyịyé gɨ ore ndéréye kpụrụ́ gɨ sɨmɨ káṇgá bɨ Galiláya ní. Yésụ ili kóo zɨ́ kémbị́ ꞌyị ówo bi bɨ yée nɨyí ndéré ndị́sị doa ní wá, ");
INSERT INTO bdh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gɨ zɨ́a bɨ kóo ndịsị ꞌdódo ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e ní. Zɨ́a úku ledre zɨ́ye kɨ́dí, “Nɨyí karanée íꞌbí ngbángá, Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ ꞌyịmaꞌdí e, do úfu wo. Nda sɨmɨ sị́lị́ ota (3) zɨ́a úrú ené.” ");
INSERT INTO bdh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ꞌYị lódụ́ kacɨ́ga owoꞌdiꞌbinɨ́ ledre gɨ sɨmɨ ledre bɨ kóo ndịsị ꞌdódo a née wá, gɨ zɨ́ kéyị née, ꞌyị ndúꞌyú wo ndaá kóo wá gɨ zɨ́ ngịrị. ");
INSERT INTO bdh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Zɨ́ye ndáꞌbaógụyé ꞌbe sɨmɨ gara bɨ Kapáranawúma ní. Zɨ́ Yésụ ndúꞌyú ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ndị́sịsé gáa ítí kangú do mɨsiꞌdi ꞌdáa gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ukulugunɨ́ ledre kacɨ́ a zɨ́a wá, gɨ zɨ́a ndịsịnɨ́ ítí kangú gɨ ro ambí nɨ dongaráye ne ledrea owóromo do ꞌbɨ lafúne e. ");
INSERT INTO bdh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zɨ́ Yésụ ndị́sịné bi, zɨ́a ndóloógụ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre (12) ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Togụ́ ꞌyị ili ídí ꞌdáꞌdá zɨ́ lafúne e yá, idí óto roné ndoo, zɨ́a ídíne ꞌdáꞌba, zɨ́a kpá ídíne ꞌyị ị́nyị kasa zɨ́ lafúne e za mbá.” ");
INSERT INTO bdh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Zɨ́ Yésụ ꞌdíꞌbi ngíti owụ́ úku ledre zɨ́a tóroné kóꞌdụ́ ꞌyị lódụ́ kacɨ́ne ga gére née. Zɨ́a fáka owụ́ née zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Togụ́ ꞌyị ꞌdiꞌbi owụ́ káa zɨ́ wo ba sɨmɨ sụmụ gɨ zɨ́a bɨ nɨ ꞌyị lódụ́ kacɨ́ma ní, ꞌdiꞌbi née kpá go máa sɨmɨ sụmụ. ꞌYị bɨ ꞌdiꞌbi máa go sɨmɨ sụmụ ní, ꞌdiꞌbi ené née lá dụụ́ máa wá, ꞌdiꞌbi née go kpá wo bɨ kasaogụ máa ní sɨmɨ sụmụ.” ");
INSERT INTO bdh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Geré zɨ́ Yiwáni úku ledre kɨ́dí, “ꞌYị ꞌdódo ledre, ogụ ndikizé ngíti oꞌdo kɨ́ ndị́sị lágaóyó dokéké e gɨ sɨmɨ ꞌyị e. Zɨ́ze ụ́cụómo wo gɨ zɨ́a ndaá ꞌbɨ ené ngúruzé wá.” ");
INSERT INTO bdh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yésụ ya zɨ́a ní, “Ndásé ụ́cụómo ꞌyị káa zɨ́ wo née wá. ꞌYị bɨ ndịsị méngị bɨlámá ledre kɨ́ ịrịmá ní, úku sínyi ené ledre gɨ do bi máa wá. ");
INSERT INTO bdh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ꞌYị bɨ ngárá ndaá okó rozé wá ní, née go ꞌyị ezé. ");
INSERT INTO bdh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Máúku zɨ́se maꞌdíi, abú ꞌyị iꞌbí zɨ́se lá gba iní mɨéwé, gɨ zɨ́a bɨ, ásé ꞌyị ꞌbɨ Kɨ́résịto ní, Lomo nɨ karanée méngị bɨlámá ledre zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Owụ́ káa zɨ́ wo ba ṇguṇgu ledremá go, togụ́ ꞌyị londo wo zɨ́a lúyú ledre yá, nɨ ídí bɨlámáne togụ́ odónɨ́ káꞌdá ro goa, do odóngeṛịnɨ́ wo kɨ́e ro tutú do ụ́cụ wo kɨ́e bu sɨmɨ mongụ́ iní yá, nɨ éme gbála. ");
INSERT INTO bdh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Togụ́ ngúru sị́lị́yị ayí óto yị́ị zɨ́yị lúyú yá, ídí óṇgoóyó a ꞌdáꞌba. Nɨ bɨlámáne zɨ́yị ndéréyị ꞌbe ꞌbɨ Lomo kɨ́ sị́lị́yị kị́éꞌdo, gɨ zɨ́ wo bɨ áyí ndéré kɨ́ sị́lị́yị gbrengárá ku phoꞌdụ bɨ ịlị́ wá ní. ");
INSERT INTO bdh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kpá kenée, togụ́ ngúru sịndị́yị ayí óto yị́ị zɨ́yị lúyú ledre yá, ídí óṇgoóyó a ꞌdáꞌba. Nɨ bɨlámáne zɨ́yị ndéréyị ꞌbe ꞌbɨ Lomo kɨ́ sịndị́yị kị́éꞌdo, gɨ zɨ́ wo bɨ áyí ndéré ku phoꞌdụ kɨ́ sịndị́yị gbrengárá ní. ");
INSERT INTO bdh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Togụ́ ngúru komomyị́ ayí óto yị́ị, zɨ́yị lúyú ledre yá, ídí cígíóyó a ꞌdáꞌba. Nɨ bɨlámáne zɨ́yị ndéréyị ꞌbe ꞌbɨ Lomo kɨ́ komoyị́ kị́éꞌdo, gɨ zɨ́ wo bɨ áyí ndéré kɨ́ komoyị́ gbrengárá do ụ́cụ yị́ị nyé ku phoꞌdụ bɨ ịlị́ wá ní, ");
INSERT INTO bdh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kɨ́ꞌdí bɨ “ ‘kidri ga bɨ ndịsịnɨ́ ánu ꞌyị e ngárá uyunɨ́ wá, kɨ́ phoꞌdụ bɨ ngárá ịlị́ kpá wá ní.’ ");
INSERT INTO bdh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ꞌYịmaꞌdí nɨ ídí mɨútúásáne do komo Lomo kpụrụ́ gɨ sɨmɨ ꞌdoꞌdó káa zɨ́ toꞌdo bɨ lefenɨ́ sɨmɨ ụkụ́ ní. ");
INSERT INTO bdh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Toꞌdo nɨ bɨlámá éyị́. Togụ́ ayá lolụ wá, moko ndaá lolụ sɨmɨ a wá. Mɨméngị ledre esé e idínɨ́ ínyi zɨ́ lafúse e káa zɨ́ toꞌdo ní gɨ ro zɨ́se ndị́sịsé kéye sɨmɨ bikịdrị́.” ");
INSERT INTO bdh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zɨ́ Yésụ ị́nyịné gɨ ore ndéréne sɨmɨ káṇgá ꞌbɨ Yụdáya sága ngbuṛu Yeredéne. Zɨ́ tụ́ꞌdụ́ ꞌyị e kpá ógụyé zɨ́a ore, zɨ́a tónóne ꞌdódo ledre zɨ́ye káa zɨ́ bɨ lengbe ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Zɨ́ ngíti géyị Farụsáyo e ógụyé úzu wo kɨ́dí, “Mongụ́ ꞌyị, nɨ mɨútúásáne zɨ́ ꞌyị ótoómo meꞌbené?” ");
INSERT INTO bdh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Mụ́sa eké kóo zɨ́se sɨmɨ lorụ yaá ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Mụ́sa ekéomo kóo zɨ́ze kɨ́dí, togụ́ ꞌyị otoomo meꞌbené yá, idí íꞌbí wáraga ꞌbɨ ótoómo roꞌyị zɨ́ kára máa née.” ");
INSERT INTO bdh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Mụ́sa eké kóo lorụ née zɨ́se kenée gɨ zɨ́a bɨ dosé orụofụ go ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sɨmɨ bɨ kóo Lomo otoogụ éyị́ e ní, ‘otoogụ ꞌyịmaꞌdí e oꞌdo kɨ́ kára.’ ");
INSERT INTO bdh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Gɨ zɨ́ kéyị née, oꞌdo nɨ ótoómo ꞌbụné kɨ́ mbágáne, zɨ́a ófụ́ kára zɨ́ye óto ꞌbe kéne. ");
INSERT INTO bdh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Zɨ́ ꞌyị ga bɨ gbre née ídíye nda éyị́ kị́éꞌdo.’ Ndanɨ́ lolụ gbre wá, nɨyí goó éyị́ kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Éyị́ bɨ Lomo oto go káa do éyị́ kị́éꞌdo ní, ꞌyịmaꞌdí ndaá ífi sɨmɨ a wá.” ");
INSERT INTO bdh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sɨmɨ bɨ olụ́nɨ́ nda go ꞌdị́cị́ ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ndúꞌyú wo gɨ ro ledre gána née. ");
INSERT INTO bdh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, ꞌyị bɨ otoomo mɨzefị meꞌbené, zɨ́a ndéréne ófụ́ ngíti kára ní, mengịnɨ́ née go ꞌberị ro mɨzefị meꞌbené. ");
INSERT INTO bdh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kpá kenée, togụ́ kára otoomo mɨzefị oꞌdo ꞌbɨ ené, zɨ́a nda ndéréne ꞌdíꞌbi ngíti oꞌdo yá, mengịnɨ́ née go kpá ꞌberị kɨ́ ngíti oꞌdo née ro mɨzefị oꞌdo ꞌbɨ ené.” ");
INSERT INTO bdh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ꞌYị e ndịsịnɨ́ kóo ógụ kɨ́ owụ́ ꞌbɨ eyé e zɨ́ Yésụ gɨ ro zɨ́a íꞌbí úndru zɨ́ye. Zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ụ́cụómo yée. ");
INSERT INTO bdh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zɨ́ ledre née kóo sínyíne ro Yésụ. Zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Ndásé ụ́cụómo owụ́ e kɨ́ ógụyé zɨ́ma wá, ótoómosé yée idínɨ́ ógụ zɨ́ma. Bi bɨ ꞌbe ꞌbɨ Lomo nɨ gɨ ro ꞌyị ga bɨ káa zɨ́ mɨnzéré owụ́ ga gére née. ");
INSERT INTO bdh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Maꞌdíi, ꞌyị bɨ ṇguṇgu ledre ꞌbe ꞌbɨ Lomo káa zɨ́ owụ́ wá ní, utúasá ólụ́ íri wá.” ");
INSERT INTO bdh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Zɨ́a tónóne ị́mbị́ owụ́ ga gére née kékị́éꞌdo ndị́sị kɨ́ óto sị́lị́ne doyé íꞌbí úndru zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sɨmɨ bɨ Yésụ nɨ nda go gɨ ro ndéréókpó ené gɨ ore ní, zɨ́ ngíti oꞌdo ngásáógụné útúne gbrị do ngụ́ṛụ́ sịndị́ne, úku ledre zɨ́ Yésụ kɨ́dí, “Bɨlámá ꞌyị ꞌdódo ledre, mááyí méngị káa be ꞌdi zɨ́ma ndíki trịdrị bɨ za fí ní?” ");
INSERT INTO bdh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yésụ ya zɨ́a ní, “Ndólo máa bɨlámá ꞌyị gɨ ro ꞌdi? Bɨlámá ꞌyị ndaá. Odụ bɨlámá ꞌyị dụụ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Owo lorụ e bú bɨlámáne, ‘Ndá úfu ꞌyị wá, ndásé sóꞌdo rosé kɨ́ ꞌyị bɨ ófụ́sé rosé kéne wá ní wá, ndá úgu ugu wá, ndá úkuóto ledre ro ꞌyị wá, ndá lóndo ꞌyị gɨ ro éyị́ ené wá, ídí óto úndru ꞌbụyị́ e kɨ́ mbágáyị.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Oꞌdo née ya, “ꞌYị ꞌdódo ledre, tónóne kú gɨ do owụ́ma, máléꞌbé amá gɨ do lorụ wá.” ");
INSERT INTO bdh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Gɨ zɨ́a ꞌbúa nɨ kóo do Yésụ. Zɨ́ Yésụ lúrú wo gbóó, zɨ́a úku ledre zɨ́a kɨ́dí, “Éyị́ nɨ bo kị́éꞌdo méngị aka wá. Ndéré mu úgúóyó éyị́ ga bɨ zɨ́yị ꞌbe ní mbá ꞌdáꞌba, zɨ́yị ífibáyi késị́ye zɨ́ ꞌyị lerị́ e, zɨ́yị ndáꞌbaógụyị́ lódụ́ kacɨ́ma. Lomo nɨ karanée íꞌbí tụ́ꞌdụ́ éyị́ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gɨ zɨ́ ledre bɨ Yésụ uku kenée ní, zɨ́ bi sínyíne ro oꞌdo née gbála. Zɨ́a ndéréne gɨ ore kɨ́ do komoné mɨsínyíne, gɨ zɨ́a nɨ kóo kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zɨ́ Yésụ lúrú bi keree, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Nɨ mɨórụné kɨ́ngaya gɨ ro zɨ́ ꞌyị ga bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye ní ólụ́ye ꞌbe ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Zɨ́ ledre née lụ́tụ́ne komo ꞌyị lódụ́ kacɨ́ga ga gére née. Zɨ́ Yésụ kpá úku ándá ledre zɨ́ye kɨ́dí, “Owụ́ ꞌbɨ amáa e, maꞌdíi, nɨ mɨórụné kɨ́ngaya gɨ ro zɨ́ ꞌyị ólụ́ne ꞌbe ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nɨ owụ́ ledre cúkuꞌdée zɨ́ mongụ́ bangá bɨ gémele ní, ólụ́ógụné gɨ sɨmɨ gu lị́bịra gɨ ꞌdí keṛị́. Tɨ́ lá gɨ ro ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní, nɨ mɨórụné gɨ ro zɨ́a ólụ́ne ꞌbe ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ga uwúnɨ́ ledre née kenée ní, zɨ́a lụ́tụ́ne komoyé, zɨ́ye ódroyé dengbị́ye kɨ́dí, “Sara togụ́ nda go kenée ní, ambí nɨ nda ómo ne?” ");
INSERT INTO bdh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zɨ́ Yésụ lúrú yée keree, zɨ́a úku ledre zɨ́ye kɨ́dí, “Togụ́ zɨ́ ꞌyịmaꞌdí e yá, ledre káa zɨ́ née nɨ ídí mɨórụné. Ledre e nɨyí yị́ eyé kacɨ́ komo Lomo mbá cúkuꞌdée.” ");
INSERT INTO bdh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Zɨ́ Pétero úku ledre zɨ́a kɨ́dí, “Lúrú áka, mongụ́ ꞌyị, otoomozé éyị́ ezé e go mbá, zɨ́ze útúze do kacɨ́yị káa zɨ́ ba.” ");
INSERT INTO bdh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yésụ ya zɨ́a ní, “Pétero, togụ́ ꞌyị otoomo ꞌbe ꞌbɨ ené, kɨ́ owụ́ ꞌbɨ ené e, kɨ́ lúnduné e kɨ́ lémịné e nda kɨ́ mbágáne kɨ́ ꞌbụné e, kpá kɨ́ yáká ené e gɨ romá kɨ́ bɨlámá ledre yá, ");
INSERT INTO bdh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nɨ ndíki tụ́ꞌdụ́ éyị́ e, ꞌdị́cị́ e, lúndu e, lémị e, mbágá e, owụ́ e kɨ́ yáká e rómo gɨ do yée ga bɨ cakaba ba nda kpá kɨ́ ꞌdoꞌdó e. Karanée zɨ́a kpá ndíki trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tụ́ꞌdụ́ ꞌyị máa yée ga bɨ ledreyé nɨ mɨówóne ní, utúasánɨ́ lolụ gú karanée ídí kɨ́ ledreyé owóowó wá. Yée ga ledreyé ndaá owóowó wá ní, nɨyí nda ídí ye kɨ́ ledreyé owóowó.” ");
INSERT INTO bdh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zɨ́ye ị́nyịyé ꞌdíꞌbi mɨsiꞌdi bɨ nderé ꞌdịyị roné sɨmɨ Yerụsaléma ní, Yésụ nɨ kóo za ꞌdáꞌdá zɨ́ ꞌyị lódụ́ kacɨ́ne e, zɨ́ ledre née lụ́tụ́ne komoyé, zɨ́ ngíti géyị ꞌyị ga bɨ utúnɨ́ do kacɨ́ a ní, ídíye kɨ́ ngịrị royé. Zɨ́a kpá ị́nyịné ndóloyóko ꞌyịmɨkása ené e ꞌdí sogo, zɨ́a úkuógụ ledre bɨ nɨ gú méngị née ní zɨ́ye, ");
INSERT INTO bdh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","kɨ́dí, “Úwúsé aka ledre bɨ mááyí úku a zɨ́se ba. Azé ba go ndéré sɨmɨ Yerụsaléma, kɨ́ꞌdí bɨ nɨyí íꞌbí ngbángá Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ ꞌyị ꞌdódo lorụ e ní. Nɨyí ꞌdécị ngbanga a idínɨ́ úfu wo, do íꞌbí wo do sị́lị́ ꞌyị ga bɨ ngárá ndanɨ́ Yụ́da e wá ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Zɨ́ye ndị́sịyé kɨ́ fólo máa, zɨ́ye lúbu súrú komomá, zɨ́ye ócó máa, zɨ́ye ị́nyịyé úfu máa. Zɨ́ma ídíma umbumá kɨ́ sị́lị́ ota, zɨ́ma úrú amá.” ");
INSERT INTO bdh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Née ní, zɨ́ Yakóbo e kɨ́ Yiwáni wotị́ Zebedị́ya ógụyé ndoo zɨ́ Yésụ, ya zɨ́a ní, “Mongụ́ ꞌyị, éyị́ nɨ bo, ilizé gáa zɨ́yị méngị a zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zɨ́a ndúꞌyú yée kɨ́dí, “Ílisé gáa zɨ́ma méngị zɨ́se ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Zɨ́ye úku a zɨ́a kɨ́dí, “Sɨmɨ bɨ áyí gú karanée ndị́sị do kị́tị ngére eyị́ ní, ilizé zɨ́ze ídíze gbrengárá káa do mɨngburoko ꞌyị eyị́ e gbóo kɨ́yị, ngíti ꞌyị do sị́lị́yị ꞌbɨ anú, ngíti ꞌyị ꞌbɨ ené do ngelị.” ");
INSERT INTO bdh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Ɨ́ꞌɨ, ówosé esé éyị́ bɨ ásé ndúnduꞌyú gɨ roa ní wá. Útúásásé go gɨ ro éwé tara kóꞌdo nduwú bɨ mááyí gú ógụ éwé a ní maꞌdíi? Útúásásé go gɨ ro ꞌdíꞌbi babatị́za ꞌbɨ nduwú bɨ mááyí gú ógụ ꞌdíꞌbi a ní?” ");
INSERT INTO bdh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ɨɨ, azé útúásá.” Yésụ ya zɨ́ye ní, “Ɨɨɨ, tɨ́ maꞌdíi, ásé tɨ́ gú éwé tara kóꞌdo ndúwú bɨ mááyí ógụ éwé a ní kpá kɨ́ babatị́za ꞌbɨ nduwú bɨ mááyí gú ógụ ꞌdíꞌbi a ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tɨ́ lá gɨ ro ndị́sị bɨ do anú kɨ́ do ngelị ní, ndaá ꞌbɨ ené ledre amá wá. Bi ga gére née nɨyí yị́ eyé gɨ ro ꞌyị ga bɨ yemeotonɨ́ go gɨ royé ní.” ");
INSERT INTO bdh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ga ga bɨ sokó uwúnɨ́ ledre née ní, zɨ́ sɨmɨyé ésị́ne ro Yakóbo e kɨ́ Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zɨ́ Yésụ ndóloyóko yée do úku ledre zɨ́ye kɨ́dí, “Ídísé ówo a kɨ́dí ꞌyị ga bɨ lurúnɨ́ yée káa do ngére e nda kpá kɨ́ ngíti géyị mɨngburoko ꞌyị ga bɨ ngárá ndanɨ́ Yụ́da e wá ní nɨyí ye ꞌyị ga bɨ kɨ́ rokoꞌbụyé do ꞌyị e mbá ní. Zɨ́ye ndị́sịyé óto ꞌyị e méngị moko zɨ́ye káa zɨ́ éyị́ bɨ ꞌyị e nɨyí owụ́kụlụ́ eyé e ní. ");
INSERT INTO bdh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Éyị́ ndaá kenée dongaráse wá. Togụ́ ꞌyị gɨ dongaráse ili ídíne mongụ́ ꞌyị, idí óto roné káa do ꞌyị kasa ꞌbɨ lafúne e mbá. ");
INSERT INTO bdh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Togụ́ ngíti ꞌyị gɨ dongaráse ili zɨ́ne ídíne manda ꞌdáꞌdá zɨ́ lafúne e mbá yá, idí ídí káa do ꞌyị ꞌbɨ moko ꞌbɨ lafúne e mbá. ");
INSERT INTO bdh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Abú gba Owụ́ ꞌbɨ ꞌYịmaꞌdí ógụ ené gɨ ro zɨ́ ꞌyị e méngị moko zɨ́a wá, ogụ yị́ ené gɨ ro méngị moko zɨ́ ꞌyị e, kpá gɨ ro íꞌbí roné úyuné gɨ ro yómo tụ́ꞌdụ́ ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zɨ́ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne ndéréógụyé sɨmɨ gara bɨ Zérịko ní. Sɨmɨ bɨ nɨyí go mɨndéréókpóye kɨ́ ꞌyị lódụ́ kacɨ́ne e nda kɨ́ tụ́ꞌdụ́ ꞌyị e gɨ sɨmɨ gara gɨ ore ní, zɨ́ye ndíki oꞌdo bɨ komoa ndaá ní. Nɨ wotị́ Timáyo bɨ ndịsịnɨ́ kpá ndólo a Batimáyo ní, nɨ mɨndị́sịné dogboṛụ mɨsiꞌdi ndị́sị ómbo éyị́ gɨ zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sɨmɨ bɨ úwú ledre kɨ́dí, née Yésụ ꞌyị ꞌbɨ Nazeréta ogụ ne ní, zɨ́a gbúrógbóne ꞌdága kɨ́dí, “Yésụ Owụ́ ꞌbɨ Dawídi, lúrú aka lerị́ma.” ");
INSERT INTO bdh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ ndịsịnɨ́ ndéré kɨ́ Yésụ e née, ndị́sịyé kɨ́ngaya ụ́cụómo wo kɨ́dí, idí mụ́kụ́. Abú kenée ndotó, zɨ́ oꞌdo née nda gbúrógbó tátá roné ꞌdáꞌdá kɨ́dí, “Yésụ Owụ́ ꞌbɨ Dawídi, lúrú aka lerị́ma.” ");
INSERT INTO bdh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zɨ́ Yésụ úwú ledre née, zɨ́a tóroné, zɨ́a úku ledre zɨ́ ꞌyị ga gére née kɨ́dí, “Ndólosé aka oꞌdo bɨ ndịsị gbúrógbó née gɨrí yáa.” Zɨ́ye ị́nyịyé úku ledre zɨ́a kɨ́dí, “Royị́ inyi nda mu, ị́nyịógụ mu ꞌdága nɨ go ndólo yị́ị.” ");
INSERT INTO bdh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Geré zɨ́a ụ́cụóyó mongụ́ bongó bɨ onzó roné ní ꞌdáꞌba, zɨ́a ị́nyịógụné ꞌdága do sịndị́ne ógụné zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zɨ́ Yésụ ndúꞌyú wo kɨ́dí, “Máídí méngị zɨ́yị ꞌdi?” Zɨ́a úku ledre kɨ́dí, “ꞌYị ꞌdódo ledre, máíli lá dụụ́ lúrú bi.” ");
INSERT INTO bdh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yésụ ya zɨ́a ní, “Bɨlámáne, ndéré mu, komoyị́ eme go, gɨ zɨ́a bɨ ṇgúṇgu ledremá go ní.” Geré née ní, zɨ́ komoa líkpíphụ́trụ roné. Sɨmɨ bɨ Yésụ nɨyí nda go ndéréókpó ní, zɨ́ oꞌdo ba útúne kpɨ́ṛáká do kacɨ́ye, yóó, zɨ́ye ndéréye kéye. ");
INSERT INTO bdh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sɨmɨ bɨ Yésụ kɨ́ ꞌyị lódụ́ kacɨ́ne e nɨyí go gbóo kɨ́ Yerụsaléma, nderénɨ́ kpụrụ́ gɨ sɨmɨ owụ́ gara bɨ Betefége kɨ́ Beteníya cigí Landa Olíva ní, zɨ́ Yésụ kása ꞌyị lódụ́ kacɨ́ne e gbre ꞌdáꞌdá, ");
INSERT INTO bdh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kɨ́dí, “Ndérésé mu sɨmɨ ꞌbe ga bɨ doꞌdónozé ꞌdáa née. Ásé ógụndíki owụ́phɨṛangá dongí bɨ ngárá ꞌyị e ekị́nɨ́ aka doa kú wá ní, mɨódóótoné kenée tara ngíti ꞌbe. Ídísé líkpí a, zɨ́se ógụsé kɨ́e gɨrí zɨ́ma yáa. ");
INSERT INTO bdh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Togụ́ ꞌyị e nduꞌyúnɨ́ sée kɨ́dí, méngịsé kéyị kenée gɨ ro ꞌdíya yá, ídíse úku a zɨ́ye kɨ́dí, Ngére ili ne, nɨ gɨrí kásalúgu a ꞌdiya.” ");
INSERT INTO bdh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Zɨ́ye ndéréye, do ógụyé ndíki phɨṛangá dongí mɨódóótoné tara ngíti ꞌbe cigí mɨsiꞌdi kenée tɨ́ káa zɨ́ bɨ Yésụ uku ní. Geré zɨ́ye tónóye líkpí a. ");
INSERT INTO bdh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngíti géyị ꞌyị e nɨyí kóo kpá mɨtóroyé do mɨsiꞌdi ore, zɨ́ye ị́nyịyé úku ledre zɨ́ yaꞌdá ga bɨ gbre Yésụ kasa yée née kɨ́dí, “ꞌBɨé ledre ꞌdi, bangá bɨ ásé líkpí a née ꞌbɨ ambi?” ");
INSERT INTO bdh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Zɨ́ye úkulúgu ledre zɨ́ ꞌyị ga gére née tɨ́ káa zɨ́ bɨ Yésụ uku zɨ́ye ní. Zɨ́ ꞌyị ga gére née ótoómo yée, zɨ́ye ꞌdíꞌbi bangá née ndéréye kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Zɨ́ye ógụyé kɨ́e zɨ́ Yésụ, zɨ́ye ónzó ngíti géyị bongó eyé e doa, zɨ́ Yésụ ékị́ ndị́sịné doa. ");
INSERT INTO bdh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zɨ́ ngíti géyị ꞌyị e ꞌdíꞌbiógụ bongó eyé e, ngíti géyị ꞌdecịnɨ́ ꞌbɨ eyé mbílí tịyị́ e do ízí yée zɨ́a kɨ́ rokinyi do mɨsiꞌdi gɨ ro óto úndrua. ");
INSERT INTO bdh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Zɨ́ ꞌyị ga bɨ nɨyí ꞌbɨ eyé ꞌdáꞌdá, kɨ́ yée ga bɨ gɨ do kacɨ́ a gɨ ꞌdáꞌba ní, ndị́sịyé ụ́cụ koko kɨ́ yéyéyị́ kɨ́ ndị́sị ótrụ́ ledre ꞌdága kɨ́dí, “Mbófo éyị́ zɨ́ Lomo. Úndru idí ídí zɨ́ wo bɨ ogụ kɨ́ ịrị Ngére Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Úndru idí ídí zɨ́ wo bɨ ogụ go ndị́sị do kị́tị ngére ꞌbɨ bulúnduzé Dawídi ní. Mbófo éyị́ zɨ́ Lomo Komo Ere. ");
INSERT INTO bdh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zɨ́ Yésụ ị́nyịyé kɨ́ ꞌyị ené e ólụ́ye sɨmɨ Yerụsaléma, do ndéréye do ligá ꞌDị́cị́ ꞌbɨ Lomo. Gɨ zɨ́a, kadra utú nda kóo go mɨútú, zɨ́a lúrú éyị́ ga bɨ ore ní, nda go lá ꞌdiꞌdiya, zɨ́ye ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre (12) ní gɨ ore, yóó do ndáꞌbalúgu royé ꞌdáꞌba sɨmɨ Beteníya. ");
INSERT INTO bdh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Zɨ́ bi árálóꞌbó roné, zɨ́ Yésụ ị́nyịyé ndáꞌbalúgu royé gɨ sɨmɨ Beteníya sɨmɨ Yerụsaléma, ꞌbú mengị nda kóo Yésụ maꞌdáa go mɨméngị. ");
INSERT INTO bdh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Zɨ́a lúrúndíki ndóṛí ꞌbɨ ꞌbe gɨ gbála kɨ́ mbílíne gbụkụ. Abú née ndaá aka kóo sịndị́ kadra gɨ ro mɨkánda mɨáná a wá yá, zɨ́a sómụ́ ledre kɨ́dí, ambí owo ne, éyị́ née kenée kuṛú mɨánága ga bɨ idíakánɨ́ ní, nɨyí ba bo ꞌdága íri. Zɨ́a ị́nyịné ndéréne gị sị́ ndóṛí née íri lúrú bi, lurú bi má, kémbị́ mɨáná a ndaá. ");
INSERT INTO bdh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cịkị ore, zɨ́ Yésụ ị́nyịné óto tarané kacɨ́ a née kɨ́dí, “Tɨ́ káa zɨ́ bɨ áyí go née ní, útúásá ꞌbɨ eyị́ lolụ áná gɨ ro zɨ́ ꞌyị e ánu mɨánáyị kú wá.” ꞌYị lódụ́ kacɨ́ga uwúnɨ́ kóo ledre bɨ uku née go. ");
INSERT INTO bdh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sɨmɨ bɨ olụ́nɨ́ nda go sɨmɨ Yerụsaléma ní, zɨ́ Yésụ ólụ́ne do ligá ꞌDị́cị́ ꞌbɨ Lomo, zɨ́a ógóbáyi ꞌyị ga bɨ ndịsịnɨ́ úgú éyị́ e kpá kɨ́ úgúóyó éyị́ e ore ní ꞌdáꞌba. Zɨ́a kpá ndị́sịné kɨ́ ị́trị́ónzó tarabíza bɨ ꞌyị óyólóꞌbó késị́ e ndịsịnɨ́ óyólóꞌbó késị́ e doa ní kpụkpụ́kpụ bi. Nda kpá kɨ́ bi ndị́sị ꞌbɨ ꞌyị ga bɨ ndịsịnɨ́ úgúóyó amámu e ní. ");
INSERT INTO bdh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yésụ ili ené zɨ́ ꞌyị e ị́mbị́ éyị́ e ndéréꞌdécị bi kɨ́e gɨ do ligá ꞌdị́cị́ ꞌbɨ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sɨmɨ bɨ ndịsị ꞌdódo ledre ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ndaá ꞌbɨ ené mɨékéne bɨ kɨ́dí, “ ‘ꞌDị́cị́ amá nɨ ꞌdị́cị́ ꞌbɨ ini zɨ́ma’? Tɨ́ lá óyólóꞌbósé nda yị́ esé go káa do ‘bi lóꞌbo ꞌbɨ ꞌyị ugu e.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sɨmɨ bɨ ledre ga bɨ Yésụ ndịsị ꞌdódo yée do ligá ꞌDị́cị́ ꞌbɨ Lomo ní, owụ́ndiki mbílí manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kpá kɨ́ ꞌyị ꞌdódo lorụ e ní, zɨ́ye ndị́sịyé gámásóꞌdo mɨsiꞌdi gɨ ro zɨ́ye úfu wo. Abú kenée ndotó, nɨyí kóo mbá kɨ́ ngịrị royé, gɨ zɨ́a, tụ́ꞌdụ́ ꞌyị e ilinɨ́ yị́ eyé kóo mbá Yésụ gɨ zɨ́ bɨlámá ꞌdódo ledre ené. ");
INSERT INTO bdh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nda go kɨ́ tagá ndụlụ, gɨ do kacɨ́ ꞌdódo ledre, zɨ́ Yésụ maꞌdáa ólụ́ógụyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ sɨmɨ gara gɨ ore ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nda káa zɨ́ kɨ́lóndó a née kɨ́ phịyị́, nɨyí kpá go ndáꞌbalúgu royé sɨmɨ Yerụsaléma, zɨ́ye lúrú ndóṛí bɨ karana Yésụ oto tarané kacɨ́ a ní, gagá go zawu gɨ ꞌdága gị ro cíyíne e. ");
INSERT INTO bdh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Zɨ́ Pétero ị́nyịné sómụ́ndíki ledre bɨ karana Yésụ mengị ní, zɨ́a úku ledre kɨ́dí, “Ɨ́, ꞌyị ꞌdódo ledre, lúrú aka kágá bɨ karana óto tarayị́ kacɨ́ a ba, gagá go.” ");
INSERT INTO bdh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ídísé ṇgúṇgu ledre ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ídísé óto ledre ba sɨmɨ dosé. ꞌYị bɨ iꞌbí roné go za mbá zɨ́ Lomo ní, togụ́ uku ledre zɨ́ landa bɨ ꞌdáa kɨ́dí, ‘Ídí ị́nyị gɨ ore zɨ́yị ndéré útúyị sɨmɨ mɨkavu bɨ ꞌdáa,’ togụ́ ꞌyị née owo go bɨlámáne kɨ́dí ledre bɨ née uku née nɨ méngị roné yá, zɨ́ Lomo óto ledre née, zɨ́a tɨ́ méngị roné zɨ́ ꞌyị née kenée. ");
INSERT INTO bdh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Káa zɨ́ bɨ éyị́ nɨ kenée bo ní, máúku zɨ́se maꞌdíi, togụ́ íꞌbísé rosé go mbá zɨ́ Lomo, nda sɨmɨ bɨ ásé ndị́sị íni ini zɨ́ Lomo, zɨ́se ndúꞌyú wo gɨ ro éyị́ ní, ídísé ṇgúṇgu a kɨ́dí, éyị́ bɨ ndúꞌyúsé wo gɨ roa née, ásá tɨ́ ndíki a maꞌdíi, Lomo nɨ tɨ́ íꞌbí éyị́ maꞌdáa zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndásé íni ini zɨ́ ꞌBụzé Lomo nyé kɨ́ bɨsinyí ledre sɨmɨsé ro lafúse e wá, gɨ ro zɨ́ Lomo úwú ini esé. ");
INSERT INTO bdh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Togụ́ ásé go íni ini zɨ́ ꞌBụsé Lomo gɨ ro zɨ́a ótoómo lúyú ledre esé yá, ídísé ówo a kɨ́dí lafúse ga bɨ nɨyí ógụ ndúꞌyú sée gɨ ro zɨ́se ótoómo ledre zɨ́ye ní, ídísé ị́drị mɨmbéꞌdesé, zɨ́se ótoómo ledre zɨ́ye. ꞌBụzé Lomo nɨ kpá ótoómo lúyú ledre esé.” ");
INSERT INTO bdh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Née ní, zɨ́ Yésụ ndéréógụyé kɨ́ ꞌyị lódụ́ kacɨ́ne e go sɨmɨ Yerụsaléma, zɨ́ye ndị́sịyé gámáye do ligá ꞌDị́cị́ ꞌbɨ Lomo. Zɨ́ ngíti géyị manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ ngíti géyị ꞌyị ꞌdódo lorụ e, kɨ́ ngíti géyị mɨngburoko ngére e ógụyé zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Zɨ́ye úku ledre zɨ́a kɨ́dí, “Ndíki ꞌbɨ eyị́ rokoꞌbụ máa bɨ zɨ́yị ndị́sịyị́ méngị ledre e kɨ́e ꞌdényé bɨ káa ba ba gɨ ꞌda? Ambí iꞌbí rokoꞌbụ máa née zɨ́yị ne?” ");
INSERT INTO bdh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yésụ ya zɨ́ye ní, “Máíli aka ndúꞌyú sée kɨ́ nduꞌyú kị́éꞌdo kí. Togụ́ úkulúgusé ledre go kacɨ́ a zɨ́ma, mááyí nda fú úku ꞌdódo ledre rokoꞌbụ bɨ mándị́sị méngị ledre e kɨ́e ba zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Úkusé aka zɨ́ma, Yiwáni ndiki kóo rokoꞌbụ bɨ zɨ́a ndị́sịné bábátị́zị́ ꞌyị e kɨ́e ní gɨ ꞌda? Gɨ zɨ́ ꞌyịmaꞌdí e? Togụ́ kenée wá, nda gɨ zɨ́ Mbigí Lomo?” ");
INSERT INTO bdh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Zɨ́ye tónóye ndị́sị úku ledre dengbị́ye kɨ́dí, “Azé úku a zɨ́a ba kɨ́dí ꞌdi? Togụ́ ukuzé ya gɨ zɨ́ Lomo, nɨ geré úku a kɨ́dí, bɨ kenée ní, ilizé nda kóo ledre ené wá gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Togụ́ ukuzé ya ndiki rokoꞌbụ née gɨ zɨ́ ꞌyịmaꞌdí e, utúasá kpá wá.” Gɨ zɨ́a, nɨyí kóo kɨ́ ngịrị royé gɨ zɨ́ ꞌyị e, gɨ zɨ́a, tụ́ꞌdụ́ ꞌyị e ṇguṇgunɨ́ kóo go mbá kɨ́dí, Yiwáni nɨ nébị. ");
INSERT INTO bdh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zɨ́ye nda ị́nyịyé úkulúgu ledre kacɨ́ a zɨ́a kɨ́dí, “Owozé wá.” Yésụ ya zɨ́ye ní, “Ɨɨ, bɨ kenée ní, máíli amá lolụ kpá úku ledre rokoꞌbụ bɨ mándị́sị méngị ledre e kɨ́e ní, zɨ́se wá.” ");
INSERT INTO bdh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zɨ́ Yésụ ị́nyịné úku ledre zɨ́ mɨngburoko ꞌyị ga gére née sɨmɨ muruwayi kɨ́dí, “Ngíti oꞌdo, ꞌdiꞌbiogụ kóo kúfú kóṛó zɨ́a ꞌdị́yị́ a yáká ené. Zɨ́a ị́nyịné íciꞌdíkí gara ro yáká máa née gbaá, zɨ́a íci gu gɨ ro do ndị́sị lụ́rụ kóṛó maꞌdáa sɨmɨ a. Gɨ ore, zɨ́a óꞌbóyéme bi gɨ ro zɨ́ ꞌyị bɨ nɨ ndị́sị ꞌbáꞌbá yáká maꞌdáa a née ní, ndị́sịné sɨmɨ a ꞌdága kɨ́ lúrú bi. Zɨ́a yéme ledre kɨ́ ngíti géyị ꞌyị e, zɨ́a ótoómo yáká máa née zɨ́ye, idínɨ́ ndị́sị méngị moko sɨmɨ a. Yóó zɨ́a ndéréókpóne gbála. ");
INSERT INTO bdh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Nda sɨmɨ kadra mɨꞌdécị mɨáná kóṛó máa ga gére ní, zɨ́a ị́nyịné kása ngíti ꞌyị kasa ené zɨ́ ꞌyị ga bɨ yáká íri ní, gɨ ro zɨ́ye kpá íꞌbí ꞌbɨ ené kóṛó gɨ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sɨmɨ bɨ ꞌyị kasa née ogụ íri ní, zɨ́ ꞌyị ga gére née ꞌdíꞌbi wo, zɨ́ye ócó wo, zɨ́a ngásálúgu roné zɨ́ mị́ngị́ yáká kɨ́ gbékpị́ sị́lị́ne. ");
INSERT INTO bdh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Zɨ́ mị́ngị́ yáká ị́nyịné kpá kása ngíti ꞌyị kasa ené, zɨ́ ꞌyị ga gére née kpá ị́nyịyé ócó wo do ócólóko doa, zɨ́ye méngịlárá a ꞌduo bɨsinyíne. ");
INSERT INTO bdh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Zɨ́a kpá kása ngíti ꞌyị kasa, zɨ́ ꞌyị ga gére née ị́nyịyé úfu wo. Zɨ́a kpá kása tụ́ꞌdụ́ ngíti géyị, mengịnɨ́ yée kpá kenée, ocónɨ́ ngíti géyị bɨsinyíne, zɨ́ye úfu ngíti géyị mɨúfu. ");
INSERT INTO bdh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ngíti ꞌyị kasa gɨ ro zɨ́a kása a ndaá lolụ kóo wá. Mbigí owụ́ ꞌbɨ ené bɨ oto ꞌbúa kɨ́ngaya ní, idíaká nda kóo go lá dụụ́ ne. Zɨ́a nda ị́nyịné kása cụ́ wo dụụ́ gɨ ꞌdáꞌba kɨ́ sómụ́ ledre bɨ kɨ́dí, ‘Bɨ ba nda go zaá mbigí owụ́ ꞌbɨ amá ní, nɨyí go ógụ éré wo.’ ");
INSERT INTO bdh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Sɨmɨ bɨ yaꞌdá ga bɨ yáká íri née, lurúndikinɨ́ nda go cụ́ mbigí owụ́ ꞌbɨ mị́ngị́ yáká ní, zɨ́ye úku ledre dengbị́ye kɨ́dí, ‘Ndazé ṛifu zɨ́ze ótoómo yáká ba wá. Idízé úfu owụ́ ꞌbɨ ené née kpá ꞌdáꞌba, gɨ ro zɨ́ yáká máa ba nda ídíne geré ꞌbɨ ezé.’ ");
INSERT INTO bdh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Née ní, zɨ́ye ị́nyịyé ꞌdíꞌbi owụ́ née, ócó a, do ócóónzó wo, zɨ́ye ꞌdíꞌbi umbua ndéréye ụ́cụ a tara yáká kenée.” ");
INSERT INTO bdh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Née ní, zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Bɨ kenée ní, mị́ngị́ yáká nɨ nda méngị goó ꞌdi? Máúku zɨ́se, otoomo ꞌyị ꞌbɨ moko ga gére née wá, nɨ ógụ úfu yée mbá do bi kulú owụ́ ꞌbɨ ené née, zɨ́a nda óto ngíti géyị ꞌyị e ndị́sịyé méngị moko sɨmɨ yáká ené née.” ");
INSERT INTO bdh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ólosé aka esé mɨéké kúrú Lomo bɨ uku kɨ́dí, “ ‘Tutú bɨ kóo ꞌyị óꞌbó ꞌdị́cị́ e asinɨ́ gɨ roa ní, ogụ nda yị́ ené go tutú bɨ kɨ́ ledrené owóowó ní. ");
INSERT INTO bdh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ledre ba ní, Ngére ezé Lomo mengị kóo ne, zɨ́a nda ówóne go mɨówó, zɨ́a émené komozé.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zɨ́ mɨngburoko ꞌyị ꞌbɨ Yụ́da e áyíye gɨ ro ꞌdíꞌbi Yésụ, gɨ zɨ́a, owonɨ́ go kɨ́dí, uku muruwayi née royé. Tɨ́ lá zɨ́ye éré ngịrị tụ́ꞌdụ́ ꞌyị e, zɨ́ye ótoómo wo, do ndéréókpóye gɨ cigí a. ");
INSERT INTO bdh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gɨ do kacɨ́ ledre née ní, zɨ́ mɨngburoko Isɨréle ga gére née kása ngíti géyị Farụsáyo e kɨ́ ngíti géyị ꞌyị ꞌbɨ Eróde e zɨ́ Yésụ gɨ ro úzu wo togụ́ Yésụ maꞌdáa uku luyú ledre go ro akúma ꞌbɨ Róma yá, zɨ́ye ꞌdíꞌbi wo. ");
INSERT INTO bdh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Zɨ́ye ị́nyịyé ógụyé zɨ́a, ya zɨ́ Yésụ ní, “ꞌYị ꞌdódo ledre, owozé bú kɨ́dí, ṛánga eyị́ lengbe ṛanga kú wá, ledre bɨ ꞌyị e ndịsịnɨ́ sómụ́ a ní, ata ené kacɨ́ komoyị́ kpá wá, sómụ́ eyị́ ledre moko ꞌbɨ ꞌyị e kpá wá, ndị́sị ꞌdódo yị́ eyị́ tɨ́ lá dụụ́ mbigí ledre ꞌbɨ Lomo. Bɨ kenée ní, úku aka zɨ́ze, utúasá mɨútúásá zɨ́ze íꞌbí ụsórụ zɨ́ mongụ́ ꞌyị Káyísara ngére ꞌbɨ káṇgá Róma? Idízé íꞌbí a? Ídí úku a zɨ́ze. Togụ́ ndazé íꞌbí a wá, ídí kpá úku a zɨ́ze.” ");
INSERT INTO bdh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Zɨ́ Yésụ ówo mani eyé née téké, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ílisé úzu máa gɨ ro ꞌdi? Íꞌbíógụsé aka komo késị́ gɨrí zɨ́ma yáa.” ");
INSERT INTO bdh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zɨ́ye ị́nyịyé ógụ kɨ́e zɨ́a. Zɨ́a ndúꞌyú yée kɨ́dí, “Bɨ ro késị́ ba lị́lị sɨmɨ komo ambi, sara ịrị ꞌyị ba, née ịrị ambi?” Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Née, lị́lị sɨmɨ komo Káyísara.” ");
INSERT INTO bdh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Née ní, Yésụ ya zɨ́ye ní, “Togụ́ kenée yá, ídísé íꞌbí éyị́ bɨ ꞌbɨ Káyísara ní zɨ́a, zɨ́se íꞌbí éyị́ bɨ ꞌbɨ Lomo ní, zɨ́ Lomo.” Zɨ́ tara yaꞌdá ga gére née ị́drị́ne mbá mɨị́drị́, gɨ zɨ́ ledre bɨ Yésụ ukulugu zɨ́ye ní, zɨ́ye ị́nyịyé ótoómo wo. ");
INSERT INTO bdh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nda gɨ ore, zɨ́ Sadụkáyo ga bɨ ngárá ṇguṇgunɨ́ ledre úrú gɨ sɨmɨ umbu wá ní ógụyé ndúꞌyú Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Zɨ́ye ndúꞌyú Yésụ kɨ́dí, “ꞌYị ꞌdódo ledre, Mụ́sa eké kóo lorụ ba zɨ́ze kɨ́dí, togụ́ ꞌyị uyuomo owụ́ e do kacɨ́ne wá, ꞌyị maꞌdáa bɨ uyu née, lúndua idí ꞌdíꞌbi kára umbu bɨ kacɨ́ a née, gɨ ro zɨ́a ndíkiógụ owụ́ do bi kacɨ́ lúndu máa née. ");
INSERT INTO bdh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ngíti ledre mengị kóo roné káa, owụ́ yaꞌdá e nɨyí kóo bo ịnyị doa gbre (7) mbá lúndu e. Zɨ́ mongụ́ye ofụ́ kára, kára máa née ndiki aka kóo owụ́ zɨ́a wá, geré zɨ́a úyuómo kára née. ");
INSERT INTO bdh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Zɨ́ lúndua bɨ utú do sogoa ní, ꞌdíꞌbi kára umbu eyé máa née, ndikinɨ́ owụ́ kéne kpá wá, zɨ́a kpá úyu ené, ótoómo kára máa née. Zɨ́ ota (3) lúnduyé ꞌdíꞌbitátá kára máa née, ndikinɨ́ owụ́ kéne kpá wá, zɨ́a kpá úyuné. ");
INSERT INTO bdh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Zɨ́ ledre née ndéréne kenée kacɨ́ owụ́ yaꞌdá ga gére née za mbá. Odụa nda dụụ́ ambáodụ́ye, zɨ́a ꞌdíꞌbi kára máa née, ndikinɨ́ owụ́ kpá wá, zɨ́a kpá úyu ené, ótoómo kára née. Nda gɨ do kacɨ́ yaꞌdá ga gére née mbá, zɨ́ kára née nda úyu ꞌbɨ ené dụụ́ gɨ ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bɨ goó kenée ní, togụ́ karanée urúnɨ́ kɨ́ yaꞌdá ga gére née go gɨ sɨmɨ umbu mbá ní, kára máa née nɨ nda ídí go mbị́ meꞌbe ambi? Bɨ owụ́ yaꞌdá ga bɨ ịnyị doa gbre (7) née, kára née nɨ kóo go meꞌbeyé mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Lúyúsé go gbála, gɨ zɨ́a bɨ ówosé esé ini ledre gɨ sɨmɨ mɨéké kúrú Lomo kɨ́ rokoꞌbụ ꞌbɨ Lomo kpá wá ní. ");
INSERT INTO bdh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sɨmɨ bɨ ꞌyị e nɨyí úrú gɨ sɨmɨ umbu ní, kará e kɨ́ yaꞌdá e ꞌdiꞌbinɨ́ lolụ royé wá, nɨyí nda ídí eyé mbá káa zɨ́ maláyika ga bɨ komo ere ꞌdága ꞌdáa ní. ");
INSERT INTO bdh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nda gɨ ro ledre mɨúrú gɨ sɨmɨ umbu, ólosé esé mɨéké kúrú Lomo bɨ uku ledre gɨ ro kadra bɨ kóo kúrú Lomo owụ́ogụ zɨ́ Mụ́sa gɨ sɨmɨ phoꞌdụ kɨ́ ndící komo kágá ní wá? Ekénɨ́ sɨmɨ a íri kɨ́dí, Lomo uku zɨ́ Mụ́sa kɨ́dí, ‘Mááyí Lomo bɨ ndịsị lúrú kacɨ́ Abarayáma, kɨ́ Isáka nda kɨ́ Yakóbo e ní.’ ");
INSERT INTO bdh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Sée Sadụkáyo e, lúyúsé ledre go. Ndaá ꞌbɨ ené Lomo ꞌbɨ ꞌyị ga bɨ nɨyí umbuyé ní wá, yị́ ené Lomo ꞌbɨ ꞌyị ga bɨ trịdrị ní.” ");
INSERT INTO bdh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ngíti ꞌyị ꞌdódo lorụ ꞌbɨ Mụ́sa nɨ kóo kpá dongará ꞌyị e ore, ndịsị kóo úwú ledre ga bɨ Sadụkáyo ga gére ndịsịnɨ́ úkulóꞌbó a kɨ́ Yésụ e ní, owo kóo go kɨ́dí, Yésụ ukulugu ledre go zɨ́ Sadụkáyo e bɨlámáne, née ní, zɨ́a ị́nyịné ógụné ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, lorụ bɨ romo gɨ do lafúne e mbá ní, ꞌbɨé wo be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Lorụ bɨ kɨ́ ledrené owóowó ní nɨ ba, ‘Úwúsé aka sée Isɨréle e, Mbigí Lomo nɨ dụụ́ kị́éꞌdo bɨ nɨ Ngére ezé ní. ");
INSERT INTO bdh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ídí óto ꞌbú Ngére bɨ Lomo eyị́ ní kɨ́ mɨmbéꞌdeyị́ kị́éꞌdo, kɨ́ sómụ́ ledre eyị́ mbá, kɨ́ lomo royị́ mbá nda kpá kɨ́ rokoꞌbụyị́ za mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ngíti a bɨ kpá káa zɨ́a romo gɨ do lafúne e mbá ní, nɨ ꞌbɨ ené. Ídí óto ꞌbú lafúyị e káa zɨ́ bɨ óto ꞌbúyị kɨ́ royị́ ní. Ngíti cóngó lorụ bɨ romo gɨ do yée ga bɨ gbre née ndaá.” ");
INSERT INTO bdh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Zɨ́ oꞌdo née úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Bɨlámáne, ꞌyị ꞌdódo ledre, ledre née nɨ tɨ́ kenée maꞌdíi. Káa zɨ́ bɨ úku née, tɨ́ lá ngére ezé Lomo nɨ dụụ́ ne bɨkéṛị́ ngére, ngíti a ndaá ꞌbɨ ené do kacɨ́ a née wá. ");
INSERT INTO bdh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Togụ́ óto ꞌbú Lomo kɨ́ngaya kɨ́ mɨmbéꞌdeyị́ kị́éꞌdo, kɨ́ sómụ́ ledre eyị́ mbá, kɨ́ rokoꞌbụyị́ za mbá, zɨ́yị óto ꞌbú lafúyị e káa zɨ́ bɨ óto ꞌbúyị kɨ́ royị́ ní yá, méngị née go mongụ́ bɨlámá ledre bɨ Lomo nɨ ídí gɨ zɨ́yị kɨ́ rokinyi kɨ́ngaya ní, gɨ zɨ́a, ledre née romo go do ꞌdáná éyị́ e za mbá.” ");
INSERT INTO bdh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zɨ́ Yésụ ị́nyịné ówo a gɨ zɨ́a téké kɨ́dí, mɨúkulúgu ledre ené nɨ kɨ́ bɨlámá sómụ́ ledre sɨmɨné, ya zɨ́ oꞌdo née ní ní, “Mbófo éyị́, sómụ́ ledre eyị́ emesá. Áyí go lá gbóo gɨ ro ówo Lomo káa do ngére eyị́.” Nda gɨ do kacɨ́ ledre née ní, ꞌyị ga bɨ kóo nɨyí okó ro Yésụ ní, utúasánɨ́ lolụ kóo ógụ úzu Yésụ kɨ́ ngíti nduꞌyú wá. ");
INSERT INTO bdh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zɨ́ Yésụ kóo ndị́sịné kpá fú ꞌdódo ledre zɨ́ ꞌyị e do ligá ꞌDị́cị́ ꞌbɨ Lomo íri, zɨ́a ị́nyịné ndúnduꞌyú kɨ́dí, “Sara ꞌyị ꞌdódo lorụ e ukunɨ́ ledre kɨ́dí Kɨ́résịto nɨ bulúndu Dawídi lárá káa be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngére Dawídi uku kóo ledre kacɨ́ kúrú ꞌDówụ́ Lomo gɨ ro Kɨ́résịto maꞌdáa kɨ́dí, “ ‘Ngére ezé Lomo nɨ úku ledre zɨ́ ngére amá kɨ́dí, “Ndị́sị do sị́lị́ma ꞌbɨ anú ona, gị sɨmɨ sịndị́ kadra bɨ mááyí óto ezeokóyị e mbá sị́ sịndị́yị ní.” ’ ");
INSERT INTO bdh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawídi kɨ́ roné ndịsị ndólo Kɨ́résịto Ngére, togụ́ kenée ní, Kɨ́résịto nɨ ídí bulúndu a lárá a káa be ꞌdi?” Zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sịyé úwú ledre ené kɨ́ mongụ́ rokinyi ní. ");
INSERT INTO bdh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Zɨ́ Yésụ ị́nyịné ꞌdódo ledre zɨ́ye kɨ́dí, “Komosé idí ídí rosé, ndásé ídí káa zɨ́ ꞌyị ꞌdódo lorụ e wá. Ndịsịnɨ́ ésị mɨngburoko mɨkokoro bongó e royé ndị́sị kɨ́ gámáye kɨ́e sɨmɨ sụ́ụ, gɨ ro zɨ́ ꞌyị e ndị́sịyé íꞌbí mandá zɨ́ye kɨ́ dokuwu. ");
INSERT INTO bdh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Togụ́ olụ́nɨ́ go sɨmɨ ꞌDị́cị́ Kótrụro e, togụ́ mbú mɨngburoko ayímbi yá, ilinɨ́ ndị́sị té do mɨngburoko bi ndị́sị e gɨ ro zɨ́ye ídíye owóowó. ");
INSERT INTO bdh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ndịsịnɨ́ éṛị ꞌbe ꞌbɨ kará umbu e zɨ́ kará umbu ga gére née ndị́sịyé sáká yée. Owụ́ éyị́ bɨ do sị́lị́ kará ga gére ní, zɨ́ye ndị́sịyé íꞌbí a zɨ́ye ánu. Togụ́ nda go sịndị́ kadra ꞌbɨ ini zɨ́ Lomo yá, zɨ́ye ndị́sịyé ódroyé ngbángbáne. Gɨ zɨ́ kéyị née ní, Lomo nɨ ꞌdóꞌdo yée bɨsinyíne.” ");
INSERT INTO bdh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nda gɨ do kacɨ́ ꞌdódo ledre do ligá ꞌDị́cị́ ꞌbɨ Lomo, zɨ́ Yésụ ndéré ndị́sịné gbóo cigí bi bɨ ꞌyị e ndịsịnɨ́ ónzó késị́ e doa ní, zɨ́a ndị́sịné lúrú ꞌyị ga bɨ ndịsịnɨ́ ónzó késị́ káa do tákpásị́lị́ zɨ́ Lomo ní. ꞌYị ga bɨ kɨ́ tụ́ꞌdụ́ késị́ e zɨ́ye ní, zɨ́ye ndị́sịyé ónzó a sɨmɨ sondụ́ụ née íri. ");
INSERT INTO bdh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Née ní, zɨ́ ngíti kára umbu ꞌyị lerị́ ngárá éyị́ ndaá zɨ́a wá ní, ógụné kɨ́ odụ owụ́ késị́ bɨ zɨ́ne bɨ nɨyí útúásá úgú lá owụ́ éyị́ bɨ cúkuꞌdée kɨ́e ní, ónzó a sɨmɨ sondụ́ụ káa do tákpásị́lị́ zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zɨ́ Yésụ ị́nyịné ndóloyóko ꞌyị lódụ́ kacɨ́ne e trị́é do bi kéṛị́ a, ya zɨ́ye ní, “Máúku zɨ́se maꞌdíi, kára bɨ gáa ogụ ónzó késị́ kɨ́ra ba, onzóromo késị́ go gɨ do ꞌyị ga bɨ gáa onzónɨ́ késị́ ona ní za mbá, ");
INSERT INTO bdh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","gɨ zɨ́a, ꞌyị máa ga gére née onzónɨ́ lá késị́ bɨ gɨ do tụ́ꞌdụ́ a bɨ zɨ́ye ní. Kára ba, za kɨ́ lerị́ ené née mbá, iꞌbí ꞌbɨ ené késị́ bɨ do sị́lị́ne ní go mbá, née kóo wo bɨ otoomo gɨ ro éyị́ mɨánu zɨ́ne ní.” ");
INSERT INTO bdh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sɨmɨ bɨ Yésụ nɨ go ólụ́ógụ gɨ sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo ní, zɨ́ ngúru ꞌyị lódụ́ kacɨ́a ị́nyịné úku ledre kɨ́dí, “ꞌYị ꞌdódo ledre, lúrú aka lá mɨngburoko tutú ga bɨ oꞌbónɨ́ ꞌdị́cị́ ga ba kɨ́e ba, kpá kɨ́ lámá bɨ ro ꞌdị́cị́ máa ga gére née.” ");
INSERT INTO bdh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Née kpá éyị́? ꞌDị́cị́ ga gére née kɨ́ mbágá lámá née bɨ royé née, kpá kɨ́ mɨngburoko tutú ga bɨ oꞌbónɨ́ yée kɨ́e née mbá, nɨyí ógụ ndụ́rụónzó yée kɨ́rɨ́ née mbá bi, bɨkéṛị́ tutú bɨ zɨ́a ídíákáne do ezené ꞌdága ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sɨmɨ bɨ Yésụ nɨ go mɨndị́sịné gá do Landa Olíva mɨꞌdí zɨ́ ꞌDị́cị́ ꞌbɨ Lomo ní, zɨ́ Pétero e, kɨ́ Yakóbo e, kɨ́ Yiwáni e, kɨ́ Andiríya ógụyé ndoo ndúꞌyú wo, ");
INSERT INTO bdh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Úku aka zɨ́ze, ledre máa née nɨ méngị roné kenée kɨ́ be ꞌdi? Lị́lị ledre bɨ nɨ ꞌdódo a zɨ́ze kɨ́dí ledre née nɨ ógụ méngị roné kenée ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Komosé idí ídí rosé, ꞌyị e ndanɨ́ lóndo sée wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tụ́ꞌdụ́ ꞌyị e nɨyí karanée ógụ kɨ́ ịrịmá, zɨ́ye ndị́sị úku ledre kɨ́dí yée nɨyí Kɨ́résịto, gɨ zɨ́ kéyị née ní, nɨyí lóndo tụ́ꞌdụ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ásé karanée úwú ledre kɨ́dí okó nɨ go ógụ, ngíti géyị yá kɨ́dí okó nɨ go ꞌdáa, sɨmɨ bɨ ledre ga gére nɨyí go ndị́sị méngị royé kenée ní, ndásé sị́kpị mɨmbéꞌdesé ꞌdága wá. Ledre ga gére nɨyí méngị royé kenée, tɨ́ lá née ndaá ꞌbɨ ené aka odụ do sogo káṇgá ba wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kúfú ngíti géyị ꞌyị e nɨyí karanée ndéré útú kɨ́ okó do kúfú ngíti géyị ꞌyị e, zɨ́ ngíti káṇgá ndéré útúne kɨ́ okó do ngíti káṇgá. Mongụ́ ꞌbú nɨ útú, zɨ́ kịꞌdị káṇgá ndị́sị méngị roné do ngíti géyị bi e. Née aka lá dosị́ ꞌdoꞌdó maꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ídísé tóro ngbúó káa zɨ́ bɨ ásé go ꞌyị lódụ́ kacɨ́ma e ní. Ngíti géyị ꞌyị e nɨyí karanée ꞌdíꞌbi sée ógụ kɨ́se kóꞌdụ́ ꞌyị úku ngbanga e do ócó sée sɨmɨ ꞌDị́cị́ Kótrụro e. Nɨyí karanée ꞌdíꞌbiógụ sée kóꞌdụ́ gávana e kɨ́ mɨngburoko ngére e gɨ ro úku ledre gɨ romá zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ꞌDáꞌdá zɨ́ do sogo káṇgá ba ụ́kụ́ne, nɨ mɨútúásáne do ꞌdódo bɨlámá ledre zɨ́ ṛị́kị́ kúfú ꞌyị e za mbá. ");
INSERT INTO bdh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Togụ́ karanée ꞌdiꞌbinɨ́ sée go do ógụ kɨ́se kóꞌdụ́ mɨngburoko ꞌyị ga gére née yá, ndásé ndị́sị sómụ́ ledre sɨsɨkala ꞌdáꞌdá gɨ ro úku a togụ́ ilinɨ́ go úwú ledre gɨ tarasé ní wá. Ídísé úku zɨ́ye tɨ́ lá dụụ́ ledre bɨ ꞌDówụ́ Lomo uku go zɨ́se ní. Gɨ zɨ́a, úkusé née kúrú Lomo, née ndaá sómụ́ ledre esé wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Lúndu e nɨyí íꞌbí lúnduyé e zɨ́ umbu, ꞌbụmɨowụ́ nɨ méngị a kpá kenée zɨ́ owụ́ ꞌbɨ ené. Owụ́ e nɨyí zíngi ro ꞌyị ndíki yée do íꞌbí yée zɨ́ umbu. ");
INSERT INTO bdh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tụ́ꞌdụ́ ꞌyị e nɨyí sógó sée gɨ zɨ́a bɨ ásé ꞌyị lódụ́ kacɨ́ma e ní. Abú kenée ndotó, ꞌyị bɨ nɨ iꞌbí roné ndị́sị lódụ́ kacɨ́ma gị sɨmɨ odụ sịndị́ kadra ꞌbɨ do sogo káṇgá ba ní, nɨ ndíki trịdrị bɨ za fí ní.” ");
INSERT INTO bdh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sɨmɨ bɨ lúrúndíkisé mongụ́ bɨsinyí éyị́ kɨ́ tóro do bi bɨ ngárá ndaá zɨ́a tóroné doa wá ní, ꞌyị bɨ nɨ ólo ledre ba ní, idí ówoyéme ini ledre gɨ sɨmɨ a bɨlámáne. Gɨ ore ꞌyị ga bɨ nɨyí sɨmɨ Yụdáya ní, idínɨ́ ngásá komo landa e. ");
INSERT INTO bdh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Togụ́ bɨsinyí ledre máa née ogụndiki ꞌyị do ꞌdị́cị́, ndaá ndítíógụ ólụ́ ꞌdị́cị́ gɨ ro ꞌdíꞌbi éyị́ kí wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Togụ́ ꞌyị bɨ ledre máa née ndiki wo yáká ní, ndaá lolụ ngásá ndáꞌba ꞌbe gɨ ro ꞌdíꞌbi yata bongó wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kadra máa née nɨ sínyí gbála, zɨ́ kará ga bɨ kɨ́ sɨmɨyé, kpá kɨ́ yée ga bɨ kɨ́ owụ́ e kóꞌdụ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ídísé íni ini zɨ́ Lomo kɨ́ngaya kɨ́dí, ledre máa née, ndaá méngị roné sɨmɨ kadra drụ́ wá, ");
INSERT INTO bdh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ꞌdoꞌdó ꞌbɨ sịndị́ kadra máa née nɨ ídí bɨsinyíne kɨ́ngaya zɨ́a rómoné gɨ do bizóró e za mbá, gɨ zɨ́a mengị aka roné ꞌdáꞌdá a do sogo káṇgá ona kú wá, tónóne sɨmɨ kadra bɨ kóo Lomo otoogụ káṇgá ba kɨ́ ere e, do ndéréógụné gị cakaba ní. Ngíti ledre utúasá lolụ kpá méngị roné kenée wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Idí Ngére Lomo ndaá kóo ꞌdósoógụ sịndị́ kadra ledre máa née gbúꞌdu wá, káa bɨ ꞌyị ómo ndaá. Nda lá gɨ ro mɨgéléógụ ꞌyị ené e, zɨ́a ꞌdósoógụ a gbúꞌdu. ");
INSERT INTO bdh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sɨmɨ sịndị́ kadra máa née togụ́ ngíti ꞌyị uku ledre kɨ́dí, ‘Lúrúsé aka Kɨ́résịto ogụ go.’ Togụ́ kenée wá, ‘Nɨ go bɨ ꞌdáa yá,’ ndásé ṇgúṇgu a wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tụ́ꞌdụ́ ꞌyị ṛanga e nɨyí karanée ógụ kɨ́ ịrị Kɨ́résịto ngíti géyị kɨ́ ịrị nébị e, zɨ́ye ndị́sịyé méngị mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé ní gɨ ro ndị́sị lóndo mɨgélé ꞌyị ga bɨ ꞌbɨ Lomo ní, togụ́ nɨ útúásá zɨ́ye méngị a kenée yá. ");
INSERT INTO bdh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Káa zɨ́ bɨ go kenée ní, komosé idí ídí rosé kɨ́ngaya. Máénzị komosé go ꞌdáꞌdá gɨ zɨ́ ledre káa zɨ́ ga gére née kɨ́ méngị royé. ");
INSERT INTO bdh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tɨ́ lá sɨmɨ sịndị́ kadra máa née, gɨ do kacɨ́ ꞌdóꞌdó née ní, “ ‘zɨ́ kadra ị́lị́ne mbụụ́, éfé oṇgó kpá wá, ");
INSERT INTO bdh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zɨ́ kele e ndị́sị ṛéṛeyé gɨ ꞌdága gɨrí, zɨ́ éyị́ ga bɨ komo ere ní mbá ndị́sị kị́zịyé.’ ");
INSERT INTO bdh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sɨmɨ sịndị́ kadra née ꞌyị e nɨyí lúrú Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ógụ gɨ komo ere kpụrụ́ gɨ sɨmɨ bụṛụngụ́ kɨ́ cóngó roné kpá kɨ́ mongụ́ rokoꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nɨ kása maláyika ené e zɨ́ye báyiyé do bi e do sogo káṇgá za mbá, zɨ́ye ꞌdóꞌdụ́yóko ꞌyị ené e ga bɨ gelé yée go ní, mbá do bi kị́éꞌdo. ");
INSERT INTO bdh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ídísé lúrú lị́lị ledre bɨ mándị́sị úku a ba lá dụụ́ gɨ ro ndóṛí. Togụ́ lúrúsé mɨkánda mbílí ndóṛí nɨyí go ụ́ꞌbụ yá, kɨ́dí ndumu nɨ go gbóo. ");
INSERT INTO bdh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kpá kenée, togụ́ lúrúsé ṛị́kị́ ledre e go kɨ́ méngị royé kenée komo ere yá, ídísé ówo a kɨ́dí, kadra mɨndáꞌbaógụmá nɨ go gbóo. ");
INSERT INTO bdh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Máúku zɨ́se kɨ́dí, ledre máa née nɨ méngị roné sɨmɨ bɨ ꞌyị ga bɨ cakaba ba uyuonzó aka roné wá ní. ");
INSERT INTO bdh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ere e kɨ́ do sogo káṇgá ba nɨyí ụ́kụ́ mbá, tɨ́ lá kúrúma ụkụ́ ené e wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kadra mɨndáꞌbaógụmá, ꞌyị e mbá utúasánɨ́ ówo a wá, abú maláyika ga bɨ komo Ere ní, owonɨ́ wá, gba máa Owụ́ ꞌbɨ Lomo máówo kpá wá. ꞌBụzé Lomo owo dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Káa zɨ́ bɨ go kenée ní, komosé idí ídí rosé. Zɨ́se ídíse nzíyisé gɨ zɨ́a kadra ledre máa née ówosé wá. ");
INSERT INTO bdh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Mɨndáꞌbaógụmá nɨ ídí ené káa zɨ́ ꞌbɨ oꞌdo bɨ kóo ịnyị gɨ ꞌbe ꞌbɨ ené ndéréne do ngíti bi gbála ní. Sɨmɨ bɨ kóo ịnyị ndéré ní, zɨ́a ífibáyi moko zɨ́ ꞌyị ꞌbɨ moko ené e mbá kpị́kpị́kpị́, zɨ́a kpá úkuómo ledre zɨ́ ꞌyị ꞌbɨ moko máa wo bɨ ndịsị ꞌbɨ ené lúrú bi kacɨ́ mbotụ gara ní kɨ́dí, ‘Komoyị́ idí ídí kacɨ́ma do mɨsiꞌdi, mándéré go, mááyí ndáꞌbaógụ.’ ");
INSERT INTO bdh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Gɨ zɨ́ kéyị née ní, komosé idí ídí rosé gɨ zɨ́a ówosé esé kadra bɨ mị́ngị́ ꞌbe née nɨ ndáꞌbaógụ sɨmɨ a ní wá. Ambí owo ne ngíti géyị yá, nɨ ndáꞌbaógụ kɨ́ tagá, togụ́ kɨ́ ndụlụ, kɨ́ sɨmɨbi, togụ́ kɨ́ phịyị́. ");
INSERT INTO bdh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Abú mɨógụ a nɨ lị́yị sée mɨlị́yị yá, idí ógụndíki sée fú lá kɨ́ óndó bi. ");
INSERT INTO bdh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ledre bɨ máúku zɨ́se ba, máúku go zɨ́ ꞌyị amá e mbá, ‘Komosé idí ídí rosé.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sɨmɨ sịndị́ kadra née ngítí sị́lị́ idíaká kóo go gbre gɨ ro do méngị Ayímbi Umbuokpó kɨ́ Ayímbi Ambata bɨ ꞌDeꞌdị́ ndaá sɨmɨ a wá ní. Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ ꞌyị ꞌdódo lorụ e yéme royé ndị́sị gámásóꞌdo mɨsiꞌdi bɨ do ꞌdíꞌbi Yésụ doa wayí gɨ ro úfu wo ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Zɨ́ye úku ledre kɨ́dí, “Tɨ́ lá ndazé ꞌdíꞌbi wo kadra ayímbi wá, káa bɨ ꞌyị e nɨyí zíngi rozé ke.” ");
INSERT INTO bdh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sɨmɨ bɨ Yésụ nɨ sɨmɨ Beteníya do bi éyị́ mɨánu ꞌbe ꞌbɨ Simúna bɨ kɨ́ umbunonó roné ní, zɨ́ ngíti kára ógụné kɨ́ bɨlámá sụꞌbụ́ mɨndonyo bɨ ugúnɨ́ kɨ́ tụ́ꞌdụ́ késị́ ní, zɨ́a líkpí tara kúkú sụꞌbụ́ née do léfe a mbá do Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Zɨ́ bi sínyíne ro ngíti géyị ꞌyị ga bɨ kóo ore ní, zɨ́ye tónóye úku ledre dongaráye kɨ́dí, “Áyi, kára née lefe sinyi nda sụꞌbụ́ née kenée gɨ ro ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nɨyí kóo úgúóyó a kɨ́ tụ́ꞌdụ́ késị́, káa zɨ́ késị́ bɨ gɨ ro íꞌbí a zɨ́ ꞌyị bɨ mengị moko go kɨ́ tụ́ꞌdụ́ éfé e, go gbóo zɨ́a ídíne sɨmɨbi kị́éꞌdo ní, do íꞌbí a zɨ́ ꞌyị lerị́ e.” Zɨ́ye ị́nyịyé úku sínyi ledre zɨ́ kára née ꞌduo gbála. ");
INSERT INTO bdh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ótoómosé kára née, ꞌyị ndaá ꞌdóꞌdo wo wá. Mengị mongụ́ bɨlámá ledre go zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ásé ídí kacɨ́ kadra ga ba mbá kɨ́ ꞌyị lerị́ ga gére née, zɨ́se ndị́sịsé íꞌbí éyị́ zɨ́ye sɨmɨ kadra bɨ ílisé go íꞌbí a sɨmɨ a ní. Tɨ́ lá mándị́sị amá kɨ́se za fí wá. ");
INSERT INTO bdh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mengị zɨ́ma née go ꞌbɨ ené ledre bɨ utúasá go méngị a ní. Lefeụtụ sụꞌbụ́ mɨndonyo née domá gɨ ro yémeómo máa nzíyiné gɨ ro bi bɨ nɨyí óto a zɨ́ma ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Máúku zɨ́se maꞌdíi, bi ga bɨ nɨyí úku bɨlámá ledre doyé ní mbá, ledre bɨ kára née mengị wo zɨ́ma ní, nɨyí úkuógụ a zɨ́ ꞌyị e ndị́sịyé sómụ́ndíki ledrea gɨ roa.” ");
INSERT INTO bdh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zɨ́ Yụ́da Keriyóta, ngúru ꞌyị lódụ́ kacɨ́ Yésụ ndéréne zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní íꞌbí ngbángá Yésụ zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zɨ́ bi émené royé gbála kɨ́ úwú ledre bɨ Yụ́da uku née, zɨ́ye úku ledre zɨ́a kɨ́dí, yée nɨyí íꞌbí késị́ zɨ́a. Née ní, zɨ́ Yụ́da tónóne gámásóꞌdo bɨlámá mɨsiꞌdi bɨ gɨ ro zɨ́ne íꞌbíógụ Yésụ maꞌdáa doa zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sɨmɨ mɨzefị sị́lị́ ꞌbɨ Ayímbi Ambata bɨ ngárá ꞌDeꞌdị́ ndaá sɨmɨ wá ní, kacɨ́ ondụ́ bɨ Yụ́da e, née sị́lị́ bɨ ndịsịnɨ́ óṇgoónzó phɨṛangá kábịṛị́kị sɨmɨ a gɨ ro Ayímbi Umbuokpó ní, zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ ị́nyịyé ndúꞌyú wo kɨ́dí, “Íli gáa zɨ́ze ndéréze yéme bi gɨ ro Ayímbi Umbuokpó ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Née ní zɨ́a kása ꞌyị e gbre gɨ dongaráye ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ndérésé mu sɨmɨ Yerụsaléma íri, ásé ndíki ngíti oꞌdo íri kɨ́ ndáꞌbaógụ gɨ ngbuṛu kɨ́ ndoko iní doné. Ídísé lódụ́ wo ");
INSERT INTO bdh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","zaá gị ꞌbe, zɨ́se ndúꞌyú mị́ngị́ ꞌbe máa née kɨ́dí, ꞌYị ꞌdódo ledre ya, ꞌbɨ ené ꞌdị́cị́ bɨ yée nɨyí ánu éyị́ mɨánu ꞌbɨ Ayímbi Umbuokpó sɨmɨ a kɨ́ ꞌyị lódụ́ kacɨ́ne e ní, nɨ ꞌbɨ ené wo bɨ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nɨ ꞌdódo bi ꞌbɨ ṇgu e zɨ́se sɨmɨ ꞌdị́cị́ máa wo bɨ ụbụ́nɨ́ wo gá do ezené ꞌdị́cị́ ꞌdága ní, yemeomonɨ́ bi go mbá nzíyiné, zɨ́se sɨmɨ a íri, ídísé yéme éyị́ mɨánu ꞌbɨ ayímbi sɨmɨ a íri nzíyiné gɨ rozé.” ");
INSERT INTO bdh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Zɨ́ ꞌyị lódụ́ kacɨ́ga ga bɨ gbre née ndéréye, zɨ́ye ógụyé sɨmɨ Yerụsaléma íri, zɨ́ye ndíki éyị́ e tɨ́ káa zɨ́ bɨ Yésụ uku ledre a zɨ́ye ní, zɨ́ye ị́nyịyé yéme éyị́ mɨánu ꞌbɨ Ayímbi Umbuokpó ore. ");
INSERT INTO bdh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nda go kɨ́ tagá, zɨ́ Yésụ ógụyé kɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre née mbá sɨmɨ Yerụsaléma do bi bɨ gáa yemeomonɨ́ go zɨ́ye nzíyiné ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sɨmɨ bɨ nɨyí nda go ánu éyị́ ní, zɨ́ Yésụ ị́nyịné úku ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, ngúrusé nɨ íꞌbí ngbángáma zɨ́ ezeokóma e. Tɨ́ ꞌyị bɨ ndịsịzé ésịkótrụ sị́lị́ze kéne sɨmɨ éyị́ mɨánu ní.” ");
INSERT INTO bdh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sɨmɨ bɨ uwúnɨ́ ledre née ní, zɨ́ bi sínyíne royé gbála, zɨ́ye tónóye úku ledre zɨ́a mɨkékeṛị́a kɨ́dí, “Mongụ́ ꞌyị, wo bɨ maꞌdíi ní ndaá ꞌbɨ ené máa wá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yésụ ya zɨ́ye ní, “ꞌYị maꞌdáa nɨ ídí gɨ dongaráse ga bɨ sokó doa gbre bɨ ndịsịzé ésịkótrụ sị́lị́ze kéye sɨmɨ éyị́ mɨánu ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gɨ romá, wo bɨ ogụ go káa do ꞌyịmaꞌdí ní, ledre amá ndaá. Mɨéké kúrú Lomo ukuyeme go kɨ́dí nɨyí ꞌdóꞌdo máa, zɨ́ye úfu máa. Ledre née nɨ tɨ́ ógụ méngị roné kenée maꞌdíi, nɨ sínyí gbála zɨ́ ꞌyị bɨ nɨ íꞌbíógụ máa ní. Nɨ kóo ídí bɨlámáne zɨ́ ꞌyị máa née togụ́ ndanɨ́ kóo ndíkiógụ wo wá ní.” ");
INSERT INTO bdh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sɨmɨ bɨ nɨyí aka fú ánu éyị́ ní, zɨ́ Yésụ maꞌdáa ị́nyịné ꞌdíꞌbi ambata, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo, zɨ́a ꞌdéweífi sɨmɨ a, zɨ́a íꞌbí a zɨ́ ꞌyị lódụ́ kacɨ́ne e ga gére née, ya zɨ́ye ní, “Ánusé mu, née kụṛụꞌbụmá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Zɨ́a kpá ꞌdíꞌbi kóꞌdo bɨ kɨ́ leꞌyị́ kóṛó sɨmɨné ní, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo, zɨ́a íꞌbí kóꞌdo máa née zɨ́ye, zɨ́ye éwé leꞌyị́ kóṛó bɨ sɨmɨ a née kacɨ́ye cé. ");
INSERT INTO bdh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yésụ ya zɨ́ye ní, “Ba lị́lị sámamá bɨ ndéꞌyị́ bi káa do yéme ledre zɨ́ tụ́ꞌdụ́ ꞌyị e ní, née go éyị́ bɨ nɨ yéme mɨkánda ledre dongará ꞌBụzé Lomo kɨ́ tụ́ꞌdụ́ ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Máúku zɨ́se maꞌdíi, máéwé ándá aka lolụ leꞌyị́ kóṛó káa zɨ́ wo ba ꞌdiya wá, mááyí éwé ꞌbúó mɨkánda a ꞌbe ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Née ní, zɨ́ Yésụ kɨ́ ꞌyịmɨkása ené e úku keꞌbị mbófo Lomo, zɨ́ye ị́nyịyé yóó ndéréye do Landa Olíva. ");
INSERT INTO bdh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ásé ị́nyị mbá ngásáómo máa, káa zɨ́ bɨ nɨ mɨékéne sɨmɨ kúrú Lomo ní kɨ́dí, “ ‘Mááyí úfu ꞌyị ꞌbáꞌbá kábịṛị́kị e, zɨ́ kábịṛị́kị e ngásá báyi royé mbá.’ ");
INSERT INTO bdh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Togụ́ máúrú go gɨ sɨmɨ umbu yá, mááyí ndéréókpó sóngó sée sɨmɨ káṇgá bɨ Galiláya ní.” ");
INSERT INTO bdh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pétero ya zɨ́a ní, “Mongụ́ ꞌyị, togụ́ lafúma ga ba nɨyí ngásáómo yị́ị ye yá, mángásáómo yị́ị kú wá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yésụ ya zɨ́a ní, “Ɨɨ, ídí óto ledre ba sɨmɨ doyị́ bɨlámáne, karaba kɨ́ ndụlụ, sɨmɨ bɨ oꞌdo ngono ụcụ aka koko kɨ́ꞌdí gbre wá ní, áyí ási gɨ romá kɨ́ꞌdí ota (3), yá née owo ené máa wá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Zɨ́ Pétero ị́nyịné úku ledre cụ́ kɨ́ sɨmɨné zɨ́a kɨ́dí, “Mongụ́ ꞌyị, máútúásá úku ledre kɨ́dí ‘máówo yị́ị wá’ ní kú wá. Togụ́ umbu yá, umbu.” Zɨ́ lafúga ị́nyịyé úku ledre kpá mbá kenée. ");
INSERT INTO bdh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sɨmɨ bɨ ogụnɨ́ nda go do Landa Olíva ní, zɨ́ye ị́nyịyé ógụyé do bi bɨ kɨ́ ịrịné Getesemáni ní. Zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne máa ga gére née kɨ́dí, “Ndị́sịsé aka kɨ́ra, mááyí aka ndéré íni ini zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Née ní, zɨ́a ị́nyịné ꞌdíꞌbi lá dụụ́ Simúna Pétero e, kɨ́ Yakóbo e, kɨ́ Yiwáni e, zɨ́ye ndéréye kéye. Zɨ́ Yésụ maꞌdáa ídíne kɨ́ mongụ́ sómụ́ ledre, do ndúwúne kpá mɨndúwú, ");
INSERT INTO bdh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","zɨ́a úku ledre zɨ́ye kɨ́dí, “Sómụ́ ledre bɨ mááyí kɨ́e yáa ní ofụ go, másómụ́ sómụ́ ledre née nɨ úfu máa goó ne, ídísé aka ndị́sị ona kɨ́ komosé rosé.” ");
INSERT INTO bdh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Zɨ́a ị́nyịné ndéréne gịe re cúkuꞌdée kenée, zɨ́a útúne gbrị do ngụ́ṛụ́ sịndị́ne, do lóꞌbụ komoné bi, tónóne íni ini kɨ́dí, “Babá Lomo, togụ́ sịndị́ kadra utúasá go ne gɨ zɨ́yị yá, ndá lolụ ótoómo máa zɨ́ma ndúwúma wá. ");
INSERT INTO bdh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Babá, rokoꞌbụyị́ romo do ledre e za mbá, ídí ꞌdíꞌbióyó nduwú ba gɨ romá ꞌdáꞌba. Máúku amá née kɨ́dí ídí méngị ledre maꞌdáa káa zɨ́ bɨ máíli ní wá. Ledre bɨ yéme go yị́ị ní, ídí méngị dụụ́ wo.” ");
INSERT INTO bdh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Zɨ́a ị́nyịné gɨ ore ndáꞌbalúgu roné zɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ ota née. Nɨ ógụ íri ní, nɨyí yị́ eyé go mbá ꞌdúꞌdu eyé. Zɨ́a ị́nyịné úku ledre zɨ́ Pétero kɨ́dí, “Simúna, ásé yị́ esé go mbá ꞌdúꞌdu esé, útúásásé esé ndị́sị dilá gba kɨ́ sịndị́ kadra kị́éꞌdo wá? ");
INSERT INTO bdh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Komosé idí ídí rosé, zɨ́se kpá ndị́sịsé íni ini zɨ́ Lomo káa bɨ ásé lúyú ledre ke. Lomo rosé ili tɨ́ go ní, tɨ́ lá cóngó rosé ndaá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zɨ́a ị́nyịné kpá ndáꞌbalúgu roné íni ini zɨ́ Lomo, zɨ́a úku kpá té bɨkéṛị́ ledre bɨ gáa uku ꞌdáꞌdá ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Zɨ́a ị́nyịné ndáꞌbalúgu roné zɨ́ ꞌyị lódụ́ kacɨ́ne e, zɨ́a ógụndíki yée kpá kɨ́ ꞌdúꞌdu eyé, gɨ zɨ́a, saná komoyé owó nda go mɨówó kɨ́ngaya. Ledre ndaá lolụ kóo tarayé zɨ́ye úku a zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nda sɨmɨ ota (3) mɨndáꞌbaógụa, zɨ́a úku ledre zɨ́ye kɨ́dí, “Ásé aka yị́ esé kpá fú ꞌdúꞌdu esé? Asá go. Kadra ledre ogụ go. Lúrúsé aka, iꞌbínɨ́ máa, wo bɨ ogụ káa do ꞌyịmaꞌdí ní, go do sị́lị́ ꞌyị mɨlúyú ledre e. ");
INSERT INTO bdh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ị́nyịógụsé mu zɨ́ze ndéréze. Lúrúsé aka ꞌyị bɨ nɨ íꞌbí máa zɨ́ ꞌyị ga ba ní, nɨ gɨrí go née.” ");
INSERT INTO bdh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sɨmɨ bɨ ngárá Yésụ ukuonzó aka ledre gɨ tarané wá ní, geré zɨ́ Yụ́da maꞌdáa bɨ ngúru ꞌyị lódụ́ kacɨ́ Yésụ ní, ógụyé kɨ́ tụ́ꞌdụ́ ꞌyị e rụụ kɨ́ maku okó e, kɨ́ ngbóndó e do sị́lị́ye. Manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, ꞌyị ꞌdódo lorụ e, kɨ́ mɨngburoko ngére e ní, kasanɨ́ kóo yée ye gɨ ro ꞌdíꞌbi Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yụ́da uku gáa ledre go zɨ́ye kɨ́dí, “Tɨ́ lá ꞌyị bɨ mááyí fáka wo ní, née ꞌyị máa bɨ ásé ꞌdíꞌbi wo ní. Ídísé geré ꞌdíꞌbingéṛị wo, zɨ́se ndéré kɨ́e.” ");
INSERT INTO bdh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sɨmɨ bɨ Yụ́da ogụnɨ́ ní, zɨ́a ndéréne geré zɨ́ Yésụ ya zɨ́a ní, “ꞌYị ꞌdódo ledre,” zɨ́a ị́nyịné fáka wo. ");
INSERT INTO bdh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Geré née ní, zɨ́ye ị́nyịyé ꞌdíꞌbingéṛị Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Zɨ́ ngúru ꞌyị gɨ dongará ꞌyị lódụ́ kacɨ́ Yésụ maꞌdáa lálaógụ maku okó gɨ sɨmɨ siṛíkpa, zɨ́a ị́nyịné lágáꞌdécị mbílí ꞌyị moko ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́ tụ. ");
INSERT INTO bdh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yésụ ya zɨ́ye ní, “Ógụsé kɨ́ maku okó e, kɨ́ ngbóndó e gɨ ro ꞌdíꞌbi máa ní. Mááyí ꞌyị méngị bɨsinyí ledre e? ");
INSERT INTO bdh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mááyí kɨ́se kɨ́ra kacɨ́ kadra mbá kɨ́ ndị́sị ꞌdódo ledre e zɨ́se do ligá ꞌDị́cị́ ꞌbɨ Lomo, ꞌdíꞌbisé nda kóo máa wá gɨ zɨ́ ꞌdi? Nɨ go méngị roné káa zɨ́ bɨ mɨéké kúrú Lomo uku ní.” ");
INSERT INTO bdh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Née ní, zɨ́ ꞌyị lódụ́ kacɨ́ga ụ́dụyé mbá ngásáye, zɨ́ye ótoómo wo kɨ́ ngúcuné do sị́lị́ ꞌyị ga bɨ ogụnɨ́ ꞌdíꞌbi wo ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngíti owụ́phɨṛangá nɨ kóo ore, onzó roné lá bongó mɨónzó, zɨ́a ị́nyịné lódụ́ Yésụ. Sɨmɨ bɨ ilinɨ́ nda kóo kpá gɨ ro ꞌdíꞌbi wo ní, ");
INSERT INTO bdh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","zɨ́ mɨónzó bongó née líkpíne gɨ roa, zɨ́a ótoómo a cịkị kɨ́rɨ́ née, do ngásáne ngíṛá. ");
INSERT INTO bdh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Née ní, zɨ́ ꞌyị ga bɨ kóo ꞌdiꞌbinɨ́ Yésụ ní, ị́nyịyé ndéréye kɨ́ Yésụ maꞌdáa ꞌbe ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́. Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ mɨngburoko ngére e, kpá kɨ́ ꞌyị ꞌdódo lorụ e yóko royé mbá íri. ");
INSERT INTO bdh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Abú ledre née nɨ kóo oꞌbụóꞌbụ ndotó, zɨ́ Pétero kóo ódó mɨmbéꞌdené, zɨ́a ndị́sịné kpá fú lódụ́ kacɨ́ Yésụ ndo ndo ndo gɨ ꞌdáꞌba gɨ ro zɨ́ne lúrú ledre bɨ ilinɨ́ méngị a kɨ́ Yésụ maꞌdáa ní. Sɨmɨ bɨ olụ́okpónɨ́ go kɨ́ Yésụ ꞌbe ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́ íri ní, zɨ́ Pétero maꞌdáa ólụ́úgu roné do ligá íri do ndéré ndị́sịné gɨ zɨ́ drụ́ ro phoꞌdụ dongará ꞌyị ga bɨ ꞌbɨ moko ore ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e nda kɨ́ ngíti géyị mɨngburoko ꞌyị ꞌdécị ngbanga e ndị́sịyé gámásóꞌdo ledre bɨ zɨ́ye úkuóto a ro Yésụ gɨ ro zɨ́ye ꞌdíꞌbi wo úfu a ní, tɨ́ lá ledre bɨ kị́éꞌdo káa zɨ́ye ówo a ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sɨmɨ ledre ga gére née mbá, abú tụ́ꞌdụ́ ngíti géyị ꞌyị e ukuotonɨ́ ledre ro Yésụ maꞌdáa ndotó yá, ledre ga bɨ ukuotonɨ́ yée ní, nderénɨ́ eyé mbá cee kị́éꞌdo wá. ");
INSERT INTO bdh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Zɨ́ ngíti géyị ꞌyị e úkuóto ꞌbɨ eyé kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Uwúzé gɨ taraa kɨ́dí, née nɨ ndụ́rụónzó mongụ́ ꞌDị́cị́ ꞌbɨ Lomo bɨ bulúnduzé e ụbụ́nɨ́ ye ba, zɨ́ne ụ́bụ́lúgu a do biné dụụ́ sɨmɨ sị́lị́ ota, ꞌyị e ụbụ́nɨ́ ye wá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Abú ukunɨ́ kenée ndotó, kúrúye nɨ kóo kpá fú kpị́kpị́kpị́. ");
INSERT INTO bdh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Zɨ́ mongụ́ ꞌyị ꞌdáná éyị́ ị́nyịógụ tóroné kóꞌdụ́ye mbá, zɨ́a ndúꞌyú Yésụ, kɨ́dí, “Ledre ndaá tarayị́ zɨ́yị úku a kacɨ́ ledre ga bɨ ꞌyị ga gére née ukunɨ́ née wá?” ");
INSERT INTO bdh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tɨ́ lá Yésụ ịtị ené wá. Zɨ́ mongụ́ ꞌyị ꞌdáná éyị́ kpá ndúꞌyú ándá Yésụ kɨ́dí, “Áyí ba Kɨ́résịto, wo bɨ Lomo geléogụ wo go káa do Mbigí Owụ́ ꞌbɨ ené ní?” ");
INSERT INTO bdh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yésụ ya zɨ́a ní, “Ɨɨ, mááyí tɨ́ wo maꞌdíi, ásé gú lúrú Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ndị́sị zɨ́ Lomo bɨ rokoꞌbụa ofụ go ní do anú, kpá kɨ́ ógụ gɨ komo ere kpụrụ́ gɨ sɨmɨ bụṛụngụ́.” ");
INSERT INTO bdh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Geré zɨ́ mongụ́ ꞌyị ꞌdáná éyị́ ị́nyịné lófo bongó gɨ roné kɨ́ sɨmɨkesị́, zɨ́a úku ledre zɨ́ ꞌyị e kɨ́dí, “Éyị́ bɨ ilizé kpá fú úwú ledre gɨ zɨ́ ngíti géyị ꞌyị e gɨ roa ní ꞌdi ");
INSERT INTO bdh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","bɨ uku tara sinyí go ro Lomo cụ́ kɨ́ tarané ya née nɨ Ngére Lomo ní. Sómụ́ ledre esé nɨ káa be ꞌdi?” Zɨ́ye ị́nyịyé mbá úku ledre kɨ́dí, “Née ndaá ledre bɨ nɨyí ótoómo kɨ́ úfu wo gɨ zɨ́a ní wá, idínɨ́ úfu wo ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Zɨ́ ngíti géyị tónóye ndị́sị lúbu súrú komoa, do ị́nyịyé ódóꞌdụ́tụ komoa kɨ́ bongó, do ócó wo, zɨ́ye úku ledre kɨ́dí, “Ambí ocó yị́ị née ne? Ị́fị́ aka ịrịa.” Zɨ́ ꞌyị óndó bi ga bɨ ore née ị́nyịyé kpá ócó wo. ");
INSERT INTO bdh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sɨmɨ bɨ Pétero nɨ aka kpá fú ndị́sị do ligá ore ro phoꞌdụ ní, zɨ́ owụ́kára ꞌyị ꞌbɨ moko bɨ ꞌbe ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́ ore ní, ógụné. ");
INSERT INTO bdh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sɨmɨ bɨ lurúndiki Pétero ní, zɨ́a lúrú wo gbóó. Zɨ́a úku ledre zɨ́ Pétero kɨ́dí, “Áyi, áyí ba tɨ́ ngúru ꞌyị gɨ dongará ꞌyị ga bɨ ꞌbɨ Yésụ ꞌyị ꞌbɨ Nazeréta ba ke.” ");
INSERT INTO bdh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Zɨ́ Pétero úkulúgu ledre zɨ́ kára née kɨ́dí, “Úku née kenée ledre ꞌdi? Máówo amá oꞌdo née wá. Máówoꞌdíꞌbi amá kpá ledre gɨ sɨmɨ ledre bɨ áyí ndị́sị úku a née wá.” Zɨ́ Pétero ị́nyịné ndéréne mɨꞌdí ku mbotụ bɨ olụ́ogụ sága ní. ");
INSERT INTO bdh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gɨ do kacɨ́ a née ní, zɨ́ owụ́kára née kpá ị́nyịné ndéréne tara mbotụ íri, zɨ́a lúrúndíki Pétero kɨ́ tóro, zɨ́a ị́nyịné úku ándá ledre zɨ́ ꞌyị ga bɨ kóo ndịsịnɨ́ tóro ore ní kɨ́dí, “Nɨ kpá tɨ́ ngúru ꞌyị gɨ dongará ꞌyị ga bɨ ꞌbɨ Yésụ ní maꞌdíi.” ");
INSERT INTO bdh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Zɨ́ Pétero kpá ị́nyịné ítí kangú. Do kacɨ́ ledre máa wo née akpa kpá wá, geré zɨ́ ꞌyị ga bɨ kóo ndịsịnɨ́ tóro ore ní, ị́nyịyé kpá úku ledre zɨ́ Pétero kɨ́dí, “Utúasá zɨ́yị ítí kangú yá née ndaá ꞌyị ꞌbɨ Yésụ wá ní wá, gɨ zɨ́a, owozé kpá tɨ́ bú áyí ꞌyị ꞌbɨ Galiláya.” ");
INSERT INTO bdh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Née ní, zɨ́ Pétero tónóne lólóbụ́ kɨ́dí, “Togụ́ ledre bɨ máúku ba ndaá maꞌdíi ledre wá, Lomo idí íꞌbí mongụ́ ꞌdoꞌdó zɨ́ma. ꞌYị bɨ ndị́sịsé úku ledre gɨ roa née, máówo amá wo kú wá.” ");
INSERT INTO bdh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Geré née ní, zɨ́ oꞌdo ngono ụ́cụ koko zɨ́ Pétero sómụ́ndíki ledre bɨ Yésụ uku zɨ́a kɨ́dí, “Karaba kɨ́ ndụlụ kɨ́ꞌdí bɨ ngono ụcụ aka koko kɨ́ꞌdí gbre wá ní, áyí ítí kangúma kɨ́ꞌdí ota yá, née owo ené máa wá.” Zɨ́ mongụ́ sɨmɨkozo méngị Pétero, zɨ́a útúne geré ndị́sịné íni ini. ");
INSERT INTO bdh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Akpa kɨ́ phịyị́, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní, mɨngburoko ꞌyị e kpá kɨ́ ꞌyị ꞌdódo lorụ ga bɨ ꞌbɨ Mụ́sa ní, nda kɨ́ mɨngburoko ꞌyị ꞌdécị ngbanga e, yóko royé za mbá gɨ ro yéme ledre kị́éꞌdo. Zɨ́ye ị́nyịyé ódó Yésụ, zɨ́ye ꞌdíꞌbi wo ndéréye kɨ́e kóꞌdụ́ Piláto. ");
INSERT INTO bdh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sɨmɨ bɨ ogụnɨ́ kɨ́ Yésụ íri ní, zɨ́ Piláto ndúnduꞌyú kɨ́dí, “ꞌYị ga ba ukunɨ́ ya úku ledre yá née nɨ mongụ́ ngére ꞌbɨ Yụ́da e. Áyí tɨ́ mongụ́ ngére ꞌbɨ Yụ́da e maꞌdíi?” Yésụ ya zɨ́a ní, “Kpá tí káa zɨ́ bɨ úku née.” ");
INSERT INTO bdh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní úkuóto tụ́ꞌdụ́ ledre e roa. ");
INSERT INTO bdh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Zɨ́ Piláto kpá ị́nyịné ndúꞌyú wo kɨ́dí, “Ledre ndaá tarayị́ zɨ́yị úku a kacɨ́ ledre ga bɨ ndịsịnɨ́ trótro yée ba wá? Lúrú aka tụ́ꞌdụ́ ledre ga bɨ ndịsịnɨ́ úku yée ba.” ");
INSERT INTO bdh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yésụ uku ené ledre kacɨ́ ledre ga gére née zɨ́a mbá wá, zɨ́ ledre née lụ́tụ́ne kacɨ́ komo Piláto gbála. ");
INSERT INTO bdh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sɨmɨ kadra Ayímbi Umbuokpó, Piláto ndịsị lengbe ótoómo ꞌyị bɨ ꞌyị e nduꞌyúnɨ́ wo gɨ roa gɨ sɨmɨ sị́gịnị ní. ");
INSERT INTO bdh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sɨmɨ sịndị́ kadra máa née ní, ngíti oꞌdo nɨ kóo bo sɨmɨ sị́gịnị ore kɨ́ ịrịné Barába. Wo kɨ́ ngíti géyị lafúne ꞌdiꞌbi kóo yée gɨ zɨ́a ufunɨ́ ꞌyị e sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị e yokonɨ́ royé ndị́sị gbúrógbóye kɨ́ ndị́sị méngị ledre bɨ utúasá wá ní. ");
INSERT INTO bdh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ yokonɨ́ royé ní ógụyé ndúꞌyú Piláto gɨ ro zɨ́a íꞌdí sị́lị́ne gɨ ro kémbị́ ꞌyị gɨ sɨmɨ sị́gịnị káa zɨ́ bɨ lengbe ndịsị méngị a ní. ");
INSERT INTO bdh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Zɨ́ Piláto ndúꞌyú yée kɨ́dí, “Ílisé zɨ́ma ótoómo zɨ́se ngére bɨ ꞌbɨ Yụ́da e ní?” ");
INSERT INTO bdh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Piláto owo bɨ kɨ́dí manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní, ogụnɨ́ kɨ́ Yésụ zɨ́ne gɨ zɨ́a bɨ otonɨ́ bɨsinyí mɨmbéꞌdeyé roa. ");
INSERT INTO bdh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní úku ledre, ꞌyị e idínɨ́ úku ledre zɨ́ Piláto idí ótoómo Barába gɨ sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Zɨ́ Piláto kpá ị́nyịné ndúꞌyú yée kɨ́dí, “Máídí nda méngị kɨ́ Yésụ bɨ ndị́sịsé ndólo wo mongụ́ ngére ꞌbɨ Yụ́da e ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Zɨ́ye ị́nyịyé ótrụ́lúgu ledre zɨ́ Piláto kɨ́dí, “Oꞌdo née idí úyu, idínɨ́ phéphé wo do mɨngbúngbu kágá, zɨ́a úyuné ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piláto ya zɨ́ye ní, “Bɨsinyí ledre bɨ mengị wo ní, nɨ ꞌdi?” Tɨ́ lá otrụ́tatánɨ́ ledre nda ꞌdáꞌdá kɨ́dí, “Ídí phéphéónzo wo do mɨngbúngbu kágá.” ");
INSERT INTO bdh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Piláto ili kóo méngị ꞌyị ga gére née gɨ ro zɨ́ bi émené royé, zɨ́a ị́nyịné ótoómo Barába zɨ́ye. Zɨ́a úku ledre zɨ́ asikíri ené e ócó Yésụ bɨsinyíne, do ꞌdíꞌbi wo ndéré phéphéónzó a. ");
INSERT INTO bdh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Zɨ́ asikíri ga gére née nda ꞌdíꞌbi Yésụ gɨ ore ndéré kɨ́e ꞌbe ꞌbɨ ngére, zɨ́ye ị́nyịyé ndóloyóko royé mbá do ídíye tụ́ꞌdụ́ íri. ");
INSERT INTO bdh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Zɨ́ye ésị mɨgbagbawu bongó ro Yésụ, zɨ́ye kpá kụ́ṛókụ́ kị́nị zɨ́ye ésị a ro do Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Née ní, zɨ́ye tónóye ndị́sị lágá sị́lị́ye zɨ́a kɨ́ ledre kɨ́dí, “Sɨmɨbi idí ídí doyị́ tụ́ꞌdụ́, mongụ́ ngére ꞌbɨ Yụ́da e.” ");
INSERT INTO bdh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Zɨ́ye ndị́sịyé kɨ́ ócó doa kɨ́ ngbángbá, kpá kɨ́ lúbu súrú komoa, zɨ́ye útúye do ngụ́ṛụ́ sịndị́ye, ndị́sịyé fóló wo kɨ́dí, yée otonɨ́ née úndrua. ");
INSERT INTO bdh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sɨmɨ bɨ folo asánɨ́ nda wo go ní, zɨ́ye ị́nyịyé íꞌdíógụ ngbángbá mɨgbagbawu bongó bɨ esịnɨ́ gáa roa ní, do ị́nyịyé ésịlúgu mbigí bongó ené roa. Zɨ́ye nda ị́nyịyé ólụ́ógụ kɨ́e gɨ ro ndéré kɨ́e kɨ́ꞌdí bi bɨ ilinɨ́ phéphé wo doa ní. ");
INSERT INTO bdh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sɨmɨ bɨ asikíri ga gére née nɨyí go mɨndéréye do mɨsiꞌdi kɨ́ Yésụ ní, zɨ́ye ndíkíye kɨ́ ngíti oꞌdo do mɨsiꞌdi ịrịa Simúna, oꞌdo máa née nɨ ꞌyị ꞌbɨ gara bɨ ꞌyị e ndịsịnɨ́ ndólo a Kuréne ní. Simúna maꞌdáa nɨ ꞌbụ Alakɨzánde e kɨ́ Rụ́fụ. Nɨ kóo go ólụ́ sɨmɨ Yerụsaléma. Zɨ́ asikíri ga gére née gága wo ị́mbị́ mɨngbúngbu kágá bɨ Yésụ ịmbị́ née. ");
INSERT INTO bdh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Zɨ́ye ógụyé kɨ́ Yésụ do bi bɨ ndịsịnɨ́ úfu ꞌyị e doa ní, ndolonɨ́ Gologóta, ledre gɨ sɨmɨ a kɨ́dí, cóngó doꞌyị. ");
INSERT INTO bdh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nda íri, zɨ́ye ị́nyịyé íꞌbí leꞌyị́ kóṛó bɨ kotrụnɨ́ kɨ́ ngíti kágá ní zɨ́ Yésụ, gɨ ro zɨ́a éwé a gɨ ro zɨ́ okó éyị́ mɨówo ụ́kụ́ne gɨ roa, zɨ́a ási ené kɨ́ éwé a. ");
INSERT INTO bdh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Née ní, zɨ́ye íꞌdíógụ bongó ené, zɨ́ye ị́nyịyé phéphé wo do mɨngbúngbu kágá máa née, zɨ́ye sị́kpị wo kɨ́e ꞌdága, zɨ́ye ónzó gbégbé ífibáyi bongó ené e kɨ́e dongaráye. ");
INSERT INTO bdh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ledre máa née mengị kóo roné sɨmɨ sịndị́ kadra ịnyị doa eso kɨ́ phịyị́. ");
INSERT INTO bdh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Zɨ́ye ị́nyịyé éké ledre bɨ kóo ufunɨ́ wo gɨ roa ní, do phéphéóto a doa ꞌdága kɨ́dí, “Ba, mongụ́ ngére ꞌbɨ Yụ́da e.” ");
INSERT INTO bdh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Phephénɨ́ kóo yée kɨ́ ꞌyị ugu e gbre, ngíti a do sị́lị́a ꞌbɨ anú, ngíti a do ngelị. ");
INSERT INTO bdh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ꞌYị ga bɨ kóo ndịsịnɨ́ ókpó kacɨ́ mɨsiꞌdi gɨ ore ní, zɨ́ye ndị́sịyé úku wo kpá kɨ́ úkucáyi ledre gɨ do bi a kɨ́dí, “Bɨ kóo úku yá áyí ndụ́rụ mongụ́ ꞌDị́cị́ ꞌbɨ Lomo, zɨ́yị ụ́bụ́lúgu a lá sɨmɨ sị́lị́ ota ní, ");
INSERT INTO bdh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ékị́ógụ nda lolụ gɨrí zɨ́yị yómo royị́ wá gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ ꞌyị ꞌdódo lorụ e ndị́sịyé kpá fóló wo kɨ́dí, “Ndịsị kóo lá yómo ngíti géyị ꞌyị e ní, yomo nda lolụ roné wá? ");
INSERT INTO bdh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Káa zɨ́ bɨ nɨ wo bɨ Lomo geléogụ wo káa do Kɨ́résịto, mongụ́ ngére ꞌbɨ Isɨréle e ní, idízé aka lúrú a, togụ́ ekị́ogụ gɨ do kágá gɨrí go cakaba bi yáa yá, azé geré ṇgúṇgu wo.” ꞌYị ga bɨ kóo gbre phephénɨ́ yée kɨ́ Yésụ e ní, ndịsịnɨ́ kóo kpá úku wo. ");
INSERT INTO bdh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sɨmɨ bɨ kóo kadra nɨ nda go kpíkpíṛíkpí sɨmɨ do ní, zɨ́ mụtụlụrụ útúne do káṇgá mbá kɨ́ sịndị́ kadra ota. ");
INSERT INTO bdh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sɨmɨ bɨ sịndị́ kadra ota ogụ nda go ní, zɨ́ Yésụ ị́nyịné íni ini ꞌdága kɨ́dí, “Ilóyi, Ilóyi, Lị́ma sabákatani?” Ledre gɨ sɨmɨ a kɨ́dí, “Lomo amá, Lomo amá, ótoómo máa gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Zɨ́ ngíti géyị ꞌyị ga bɨ ore ní, ị́nyịyé úwú doa, zɨ́ye úku ledre kɨ́dí, “Úwúsé aka, nɨ go ndólo nébị Ilíya.” ");
INSERT INTO bdh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Née ní, zɨ́ ngúru ꞌyị gɨ dongaráye ị́nyịné ngásáne ꞌdíꞌbi éyị́ káa zɨ́ katúu ní, zɨ́a ónzó a bu sɨmɨ mɨndógó leꞌyị́ kóṛó, zɨ́a ésị a do kágá, zɨ́a sị́kpị a, óto a tara Yésụ ꞌdága íri. Zɨ́a úku ledre zɨ́ lafúne e kɨ́dí, “Ndị́sịsé aka tí, zɨ́ze lúrú a togụ́ Ilíya nɨ gɨrí ógụ gɨ ro ị́mbị́óto wo bi yá.” ");
INSERT INTO bdh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Zɨ́ Yésụ íni ini kɨ́ mongụ́ kúrúne ꞌdága, geré zɨ́a ótoómo ꞌdówụ́ne. ");
INSERT INTO bdh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Née ní geré zɨ́ mongụ́ mbílí bongó bɨ ingí ꞌdecịnɨ́ sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo kɨ́e ní, lófo ífi sɨmɨné gberé gbre kú gɨ ꞌdága gị bi. ");
INSERT INTO bdh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sɨmɨ bɨ mongụ́ ꞌyị ꞌbɨ asikíri e bɨ kóo ndịsị tóro ore kóꞌdụ́ Yésụ do mɨngbúngbu kágá, uwú ini bɨ Yésụ ini wo kɨ́ mongụ́ kúrúne geré zɨ́a ótoómo ꞌdówụ́ne ní, zɨ́a ị́nyịné úku ledre kɨ́dí, “Máúku zɨ́se zaá maꞌdíi, oꞌdo ba nɨ mbigí Owụ́ ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngíti géyị kará e nɨyí kóo kpá ore, ndị́sị lúrúkása bi gɨ gbála, Maríya Magɨdála kɨ́ Salóme kɨ́ Maríya mbágá Yoséfa kɨ́ Yakóbo owụ́, nɨyí kóo bo dongaráye. ");
INSERT INTO bdh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Utúnɨ́ kóo do kacɨ́ Yésụ kú gɨ sɨmɨ káṇgá bɨ Galiláya ní kóo kɨ́ ị́nyị kasa zɨ́a. Tụ́ꞌdụ́ ngíti géyị kará ga bɨ kóo ogụnɨ́ kɨ́ Yésụ sɨmɨ Yerụsaléma ní, nɨyí kóo kpá mbá ore. ");
INSERT INTO bdh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nda kóo go za kɨ́ tagá sɨmɨ sịndị́ kadra bɨ ꞌyị e ndịsịnɨ́ yéme royé gɨ ro Sị́lị́ ꞌbɨ ꞌDówụ́ro ní, ");
INSERT INTO bdh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","zɨ́ ngíti oꞌdo kɨ́ ịrịné Yoséfa gɨ sɨmɨ gara bɨ Aramatáyo ódó mɨmbéꞌdené káa zɨ́ oꞌdo ꞌyị ní, zɨ́a ndéréne ndúꞌyú Piláto gɨ ro umbu Yésụ. Yoséfa nɨ ngúru ꞌyị gɨ dongará mɨngburoko ꞌyị ꞌbɨ Yụ́da e. Ndịsị kpá óto komoné gɨ ro mɨógụ Lomo káa do ngére do ꞌyịmaꞌdí e. ");
INSERT INTO bdh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sɨmɨ bɨ Piláto uwú kɨ́dí, Yésụ uyu go ní, zɨ́ tara a ị́drị́ne mɨị́drị́, zɨ́a úku ledre kɨ́dí, “Née kenée lárá ledre ꞌdi, bɨ zɨ́ oꞌdo née úyuné lá ꞌdiya kenée ní?” Zɨ́a ndóloógụ mongụ́ ꞌyị ꞌbɨ asikíri e gána ní ndúꞌyú wo togụ́ Yésụ uyu tɨ́ go maꞌdíi yá. ");
INSERT INTO bdh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sɨmɨ bɨ Piláto uwú ya Yésụ uyu tɨ́ go maꞌdíi ní, zɨ́a ị́nyịné úku ledre zɨ́ Yoséfa kɨ́dí, “ꞌDíꞌbi umbu Yésụ maꞌdáa mu ndéré óto a.” ");
INSERT INTO bdh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zɨ́ Yoséfa úgú bɨlámá bɨkenyị́ mbílí bongó, zɨ́ye ꞌdíꞌbiógụ umbu Yésụ, óto a sɨmɨ a, zɨ́ye ndéréye óto wo sɨmɨ bi bɨ kóo icinɨ́ kacɨ́ ondụ́ eyé sɨmɨ landa ní. Zɨ́ye gbụ́ṛụ́gbụóto mongụ́ tutú ngbụtụrụ́ tara bi maꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maríya Magɨdála, kɨ́ Maríya mbágá Yoséfa e ndịsịnɨ́ kóo lúrúkása bi bɨ otonɨ́ Yésụ maꞌdáa doa ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gɨ do kacɨ́ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Maríya Magɨdála, kɨ́ Salóme, kɨ́ Maríya mbágá Yakóbo e úgú sụꞌbụ́ mɨndonyo e gɨ ro ndéré sụ́sụ a ro umbu Yésụ. ");
INSERT INTO bdh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Akpa kɨ́ phịyị́ sɨmɨ sị́lị́ gɨ do kacɨ́ Sị́lị́ ꞌbɨ ꞌDówụ́ro sɨmɨ bɨ sụ́lụ́ kadra nɨ go ꞌdága ní, zɨ́ye ị́nyịyé ndéréye sị́ bi. ");
INSERT INTO bdh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kɨ́ ndéréye do mɨsiꞌdi, zɨ́ye ndúꞌyú royé dengbị́ye kɨ́dí, “Ambí nɨ laká gbụ́ṛụ́gbụóyó mongụ́ tutú karaba zɨ́ze gɨ tara bi ne?” ");
INSERT INTO bdh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tɨ́ lá sɨmɨ bɨ nɨyí lúrú bi káa ní, zɨ́ye ówo a kɨ́dí gbụṛụgbụ oyónɨ́ mongụ́ tutú née go ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sɨmɨ bɨ kará ga gére née olụ́nɨ́ sɨmɨ bi íri ní, zɨ́ye ónzó komoyé káa gbó ro owụ́phɨṛangá kɨ́ ndị́sị sɨmɨ bi íri do sị́lị́ ꞌbɨ anú, kɨ́ ngbángbá bɨkenyị́ bongó roné. Zɨ́ Lomo royé lị́yịné, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́, gɨ zɨ́ lárá ledre káa zɨ́ wo née. ");
INSERT INTO bdh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Geré zɨ́ owụ́phɨṛangá née úku ledre zɨ́ye kɨ́dí, “Ɨꞌɨ, ndásé lị́yị wá, máówo bú kɨ́dí, ógụsé ba lúrú bi gɨ ro Yésụ ꞌyị ꞌbɨ Nazeréta bɨ ufunɨ́ wo ní. Ndaá ꞌbɨ ené lolụ kɨ́ra wá, urú yị́ ené gɨ sɨmɨ umbu go. Lúrúsé aka lá, ba bi bɨ kóo otonɨ́ wo doa ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndérésé mu cakaba úku a zɨ́ Pétero e, kɨ́ lafúne e ꞌyị lódụ́ kacɨ́ Yésụ kɨ́dí, ‘Yésụ maꞌdáa nɨ ndéréụ́tụ roné fị ne ꞌdáꞌdá zɨ́se sɨmɨ káṇgá bɨ Galiláya ní, ásé nda ógụndíki wo geré íri káa zɨ́ bɨ kóo uku zɨ́se ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Née ní, zɨ́ye ólụ́ógụyé gɨ sɨmɨ bi mɨlángbayé gɨ zɨ́ ngịrị, geré zɨ́ye tónóye ngásáye. Ukuꞌdodonɨ́ kóo ledre máa née zɨ́ ꞌyị e do mɨsiꞌdi mbá wá. Odụ ledre bɨ Márɨko ekéne kɨ́ sị́lị́ne ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sɨmɨ sị́lị́ gɨ do kacɨ́ Sị́lị́ ꞌbɨ ꞌDówụ́ro bɨ Yésụ urú gɨ sɨmɨ umbu sɨmɨ a akpa kɨ́ sị́ ndóndó ní, zɨ́a ꞌdódoụ́tụ roné zɨ́ Maríya Magɨdála, bɨ kóo Yésụ lagaogụ dokéké e ịnyị doa gbre (7) gɨ sɨmɨa ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Zɨ́ Maríya maꞌdáa ị́nyịné ndéréne úku ꞌdódo a zɨ́ ezegámáne e, ꞌyị lódụ́ kacɨ́ Yésụ ga bɨ kóo nɨyí ꞌbɨ eyé ndị́sị íni Yésụ maꞌdáa ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sɨmɨ bɨ uwúnɨ́ gɨ taraa kɨ́dí Yésụ urú gɨ sɨmɨ umbu go, née lurú gáa wo go trịdrị cụ́ kɨ́ komoné ní, ṇguṇgunɨ́ eyé kóo ledre máa née wá. ");
INSERT INTO bdh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gɨ do kacɨ́ a née, zɨ́ Yésụ kpá ꞌdódo roné sɨmɨ ngíti tosoné kpị́ zɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ kóo gbre, sɨmɨ bɨ nɨyí mɨndéréye do mɨsiꞌdi gɨ sɨmɨ gara ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Zɨ́ye ndáꞌbalúgu royé sɨmɨ Yerụsaléma, zɨ́ye úku ꞌdódo ledre née zɨ́ lafúye e, tɨ́ lá a ṇguṇgunɨ́ eyé kóo ledre máa née kpá wá. ");
INSERT INTO bdh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nda gɨrí, sɨmɨ bɨ ꞌyịmɨkása ga bɨ sokó doa kéṛị́ (11) née ndịsịnɨ́ ánu éyị́ ní, zɨ́ Yésụ ꞌdódo roné zɨ́ye, zɨ́a úku ledre zɨ́ye, gɨ zɨ́a do ngíti géyị lafúye e orụ yị́ ené kóo mɨórụ kɨ́ ṇgúṇgu ledre ꞌbɨ lafúye ga bɨ lurúnɨ́ trịdrịné go cụ́ kɨ́ komoyé ní. ");
INSERT INTO bdh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nda née ní, zɨ́ Yésụ maꞌdáa úku ledre zɨ́ye kɨ́dí, “Ndérésé mu kacɨ́ bi e za mbá kɨ́ úku bɨlámá ledremá zɨ́ ꞌyị e za mbá. ");
INSERT INTO bdh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ꞌYị bɨ ṇguṇgu ledremá go ní, zɨ́se bábátị́zị́ wo, nɨ gú ómo gɨ sɨmɨ ꞌdoꞌdó bɨ odụa nda ní. ꞌYị bɨ ṇguṇgu wá ní, nɨyí ꞌdóꞌdo wo. ");
INSERT INTO bdh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Zɨ́ ꞌyị ga bɨ ṇguṇgunɨ́ go ní, ídíye kɨ́ rokoꞌbụ káa zɨ́ bɨ nɨyí go ꞌyị amá e ní, zɨ́ye kɨ́ ódroyé sɨmɨ ṛị́kị́ tara e kɨ́ ndị́sị lágaóyó dokéké e gɨ sɨmɨ ꞌyị e kɨ́ ịrịmá. ");
INSERT INTO bdh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Abú ꞌdiꞌbinɨ́ kámá okó kɨ́ sị́lị́ye, abú ewénɨ́ ngónụ́ kémbị́ éyị́ mengị yée wá. Nɨyí óto sị́lị́ye ro ꞌyị ndíyá e, zɨ́ ndíyá eyé ụ́kụ́ne.” ");
INSERT INTO bdh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sɨmɨ bɨ Yésụ ukuonzó ledre go zɨ́ye ní, zɨ́ Lomo nda ꞌdíꞌbilúgu wo ꞌbe ꞌbɨ ené komo ere, zɨ́a ndị́sịné do sị́lị́ anú ꞌbɨ Lomo káa do mongụ́ ngére. ");
INSERT INTO bdh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zɨ́ ꞌyị lódụ́ kacɨ́ Ngére Yésụ ga gére ndéréye kɨ́ úku bɨlámá ledre zɨ́ ꞌyị e kacɨ́ bi e za mbá. Zɨ́ Ngére kóo ndị́sịné méngị moko kɨ́ye, zɨ́ mɨngburoko ledre ga bɨ ndị́sịnɨ́ méngị yée kɨ́ rokoꞌbụné ní ꞌdódo a kɨ́dí ledre ga bɨ úku yée ní nɨ maꞌdíi.");
INSERT INTO bdh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mongụ́ ꞌyị Teyófịlo, tụ́ꞌdụ́ ngíti géyị ꞌyị e eké omonɨ́ ledre ga bɨ kóo gɨ do bi Yésụ, bɨ kóo Yésụ maꞌdáa ndịsị méngị yée dongaráze ní go bi ꞌdesị́. ");
INSERT INTO bdh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ekénɨ́ tɨ́ za cé ledre ga bɨ kóo ꞌyịmɨkása ga kóo ꞌdesị́ lurúnɨ́ kɨ́ komoyé zɨ́ye ndị́sịyé lị́kpị́ a ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gɨ zɨ́a bɨ ledre ga bɨ ꞌyị ga gére née ekénɨ́ ní, nɨyí mbá maꞌdíi ledre e ní, máyá nɨ mɨútúásáne zɨ́ma éké kása yée zɨ́yị, ");
INSERT INTO bdh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","gɨ do bɨ zɨ́yị ówoyéme a yá ꞌdodonɨ́ kóo maꞌdíi ledre e go zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sɨmɨ bɨ kóo Eróde nɨ mongụ́ ngére ꞌbɨ káṇgá bɨ Yụdáya ní, ngíti ꞌyị ꞌdáná mbayi ꞌbɨ Lomo nɨ kóo bo kɨ́ ịrịné Zakaríya. Nɨ gɨ dongará ꞌyị ꞌdáná éyị́ ga bɨ manda eyé nɨ mbá Abiyáza ní. Ịrị meꞌbea Elizebéta, nɨ kpá gɨ sɨmɨ kúfú bulúnduyé bɨ Aróna ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakaríya e gbrengárá kɨ́ meꞌbené, mɨméngị ledre eyé nɨ kacɨ́ kadra mbá fú lá mbị́ do komo Lomo, gɨ zɨ́a ndịsịnɨ́ éré lorụ ꞌbɨ Ngére Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tɨ́ lá owụ́ ndaá ꞌbɨ ené kóo zɨ́ye wá gɨ zɨ́a meꞌbea nɨ mɨkoto, nɨyí nda kpá yị́ eyé go ngokoyé utúasánɨ́ lolụ ndíki owụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nda sɨmɨ ngíti sị́lị́, sịndị́ kadra utúasá go zɨ́ Zakaríya e kɨ́ lafúne ndéréye sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo ꞌdáná éyị́ zɨ́ Lomo, ");
INSERT INTO bdh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kacɨ́ ondụ́ ꞌbɨ ꞌyị ꞌdáná éyị́ e. Zɨ́ gbégbé ꞌdódo Zakaríya zɨ́a ólụ́ne ꞌDị́cị́ ꞌbɨ Lomo ꞌdáná éyị́ zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sɨmɨ bɨ Zakaríya olụ́ go ꞌDị́cị́ ꞌbɨ Lomo nɨ go ndị́sị óngbó abúṛengú kɨ́ ndonyoné ꞌdị́cị́ íri ní, tụ́ꞌdụ́ ꞌyị ga bɨ ogụnɨ́ ní nɨyí ꞌbɨ eyé ndị́sị íni ini zɨ́ Lomo sága. ");
INSERT INTO bdh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cịkị ꞌdị́cị́ íri, zɨ́ maláyika bɨ Ngére Lomo kasa ní ógụ tóroné do sị́lị́ ꞌbɨ anú cigí mbayi bɨ ndịsịnɨ́ ꞌdáná éyị́ doa ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sɨmɨ bɨ Zakaríya lurú maláyika née kenée ní, zɨ́ lomo roa lị́yịné gɨ zɨ́ ngịrị. ");
INSERT INTO bdh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Zɨ́ maláyika née úku ledre kɨ́dí, “Ndá éré ngịrị wá Zakaríya, Lomo uwú ini bɨ ndị́sị íni a ní go. Meꞌbeyị́ Elizebéta nɨ ndíki owụ́ zɨ́yị owụ́oꞌdo. Ídí ị́fị́ ịrịa Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɨ óto sée kɨ́ meꞌbeyị́ zɨ́se ídíse kɨ́ rokinyi, tụ́ꞌdụ́ ꞌyị e nɨyí ídí kɨ́ rokinyi sɨmɨ bɨ nɨyí úwú a kɨ́dí aránɨ́ wo go ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nɨ ídí kɨ́ ledrené owóowó sɨmɨ moko bɨ ꞌbɨ Ngére Lomo ní. Ndaá ꞌyị éwé leꞌyị́ wá, nɨ dụụ́ mɨꞌdúcuné kɨ́ ꞌDówụ́ Lomo kú gɨ sɨmɨ mbágáne. ");
INSERT INTO bdh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nɨ ꞌdíꞌbilúgu ngíti géyị Isɨréle e ga kóna luyúnɨ́ gɨ do mɨsiꞌdi ꞌbɨ Ngére Lomo go ní zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nɨ ndị́sị gámá kɨ́ úku kúrú Lomo sɨmɨ rokoꞌbụ ꞌDówụ́ Lomo cé káa zɨ́ nébị Ilíya kóna ní, zɨ́a ndị́sịné kɨ́ yéme dongará ꞌyị ga bɨ sinyí go kɨ́ owụ́ ꞌbɨ eyé e ní, kpá kɨ́ sáká ꞌyị ga bɨ sómụ́ ledre eyé ndaá bɨlámáne do mɨsiꞌdi ꞌbɨ Lomo wá ní, nda kpá kɨ́ yémeómo ꞌyị e nzíyiyé zɨ́ Ngére Yésụ.” ");
INSERT INTO bdh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zɨ́ Zakaríya ndúꞌyú maláyika née kɨ́dí, “Mááyí ówo a bɨ kɨ́dí éyị́ nɨ ndéré méngị roné zɨ́ma kenée ní lárá a káa be ꞌdi? Bɨ mááyí go ngokomá káa zɨ́ ba, kára bɨ zɨ́ma ní nɨ go kpá ngokoné ní.” ");
INSERT INTO bdh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Zɨ́ maláyika née úkulúgu ledre zɨ́ Zakaríya kɨ́dí, “Zakaríya, ịrịmá Gábɨrele. Kacɨ́ kadra mbá azé fú lá kɨ́ Lomo do bi kị́éꞌdo, kasa máa ne kɨ́ bɨlámá ledre née ógụ úku a zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gɨ zɨ́a bɨ íli ṇgúṇgu ledre bɨ máúku zɨ́yị ba wá ní, tarayị́ nɨ ídí mɨꞌdụ́tụné ódro wá gị sɨmɨ sịndị́ kadra bɨ owụ́ née nɨ árá sɨmɨ a ní.” ");
INSERT INTO bdh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gɨ zɨ́ kéyị née, ꞌyị ga bɨ ndịsịnɨ́ sóngó wo sága ní ndịsịnɨ́ go má zɨ́ye úku ledre kɨ́dí, “ꞌBɨé laká nda ꞌdi, Zakaríya luꞌbú karaba sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo ꞌdényé káa ní ní.” ");
INSERT INTO bdh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sɨmɨ bɨ olụ́ogụ gɨ ꞌDị́cị́ ꞌbɨ Lomo gɨrí ní, ndịsị nda ódro zɨ́ye lá kɨ́ sị́lị́ne. Zɨ́ ꞌyị ga gére née tɨ́ geré ówo a kɨ́dí Lomo ꞌdodo ngíti mɨkánda ledre go zɨ́a ꞌdị́cị́ íri. ");
INSERT INTO bdh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sɨmɨ bɨ sịndị́ kadra ꞌbɨ moko ené ụkụ́ ní, zɨ́a ị́nyị ndáꞌbalúgu roné ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nda gɨ do kacɨ́ sị́lị́ cúkuꞌdée, zɨ́ meꞌbea Elizebéta ídíne kɨ́ sɨmɨné. Zɨ́a ndị́sịné ꞌbe éfé ịnyị, olụ́ogụ gɨ ꞌbe wá. ");
INSERT INTO bdh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Zɨ́ Elizebéta íꞌbí mbófo éyị́ zɨ́ Lomo kɨ́dí, “Mbófo éyị́ zɨ́yị Ngére Lomo gɨ ro ledre bɨ méngị zɨ́ma ba. Ówo ledre go kɨ́ma zɨ́yị ꞌdíꞌbióyó mongụ́ dokuwu bɨ mááyí kɨ́e ní gɨ domá ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sɨmɨ bɨ Elizebéta nɨ go kɨ́ sɨmɨné ꞌbɨ éfé ịnyị doa kéṛị́ (6) ní, zɨ́ Lomo kpá kása maláyika Gábɨrele sɨmɨ Nazeréta ngíti owụ́ gara sɨmɨ Galiláya, ");
INSERT INTO bdh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","zɨ́ owụ́kára tara mbotụ nɨ kóo go mɨkóróne zɨ́ ngíti oꞌdo kɨ́ ịrịné Yoséfa. Nɨ gɨ sɨmɨ kúfú ngére Dawídi. Owụ́ kára maꞌdáa ịrị a Maríya. ");
INSERT INTO bdh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Zɨ́ Gábɨrele ndéréógụné íri, zɨ́a íꞌbí mandá kɨ́dí, “Mandá zɨ́yị Maríya, útúásá go kacɨ́ komo Ngére Lomo, Lomo idí kɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Zɨ́ Maríya ndị́sị ónzó komoné kɨ́ toso mandá bɨ maláyika ogụ íꞌbí a zɨ́ne née. ");
INSERT INTO bdh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Zɨ́ maláyika úku ledre zɨ́ Maríya kɨ́dí, “Maríya, ndá éré ngịrị wá, útúásá yị́ eyị́ mɨútúásá kacɨ́ komo Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Áyí ógụ ídí kɨ́ sɨmɨyị́ zɨ́yị árá ógụ a owụ́oꞌdo. Ídí ị́fị́ ịrị a Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nɨ ídí mongụ́ ꞌyị. ꞌYị e nɨyí ndị́sị ndólo wo Owụ́ ꞌbɨ Lomo. Ngére Lomo nɨ óto wo káa do ngére káa zɨ́ bulúndua bɨ kóo Dawídi ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nɨ ídí ngére do kúfú Isɨréle e za fí, ꞌyị ꞌdíꞌbióyó wo ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríya ya zɨ́ maláyika ní, “Ledre máa née nɨ méngị roné née lárá a kɨ́e ꞌdi bɨ máówo aka kpá ledre ꞌbɨ yaꞌdá e wá ní?” ");
INSERT INTO bdh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maláyika ya zɨ́a ní, “Owụ́ née nɨ ógụ ené sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo. Lomo nɨ ndị́sị ne sáká yị́ị gɨ zɨ́a owụ́ bɨ áyí ndíkiógụ a née nɨ yị́ ené Owụ́ ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lúrú aka gba ngoko sụmụyị́ bɨ Elizebéta ba, nɨ go kɨ́ sɨmɨné ꞌbɨ éfé ịnyị doa kéṛị́ (6). ꞌYị e owonɨ́ go mbá kɨ́dí utúasá lolụ kóo ndíki owụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ledre bɨ Lomo uku go ní, nɨ méngị roné.” ");
INSERT INTO bdh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríya ya, “Káa zɨ́ bɨ mááyí ꞌyị ꞌbɨ moko ꞌbɨ Ngére Lomo ní, máṇgúṇgu ledre bɨ úku ili méngị a zɨ́ma ní go.” Geré zɨ́ maláyika née lélị́ ené gɨ ore. ");
INSERT INTO bdh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Zɨ́ Maríya yéme roné ndéréne lúrú Elizebéta sɨmɨ owụ́ gara do bi ekị́ekị́ sɨmɨ Yụdáya, ");
INSERT INTO bdh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","zɨ́a ógụné ꞌbe ꞌbɨ Zakaríya zɨ́a íꞌbí mandá. ");
INSERT INTO bdh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sɨmɨ bɨ Elizebéta uwú kúrú Maríya ní, geré zɨ́ sɨmɨa ndị́sịné ndéndeke kɨ́ mongụ́ rokinyi. Zɨ́ Elizebéta lúrú rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo roné. ");
INSERT INTO bdh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Zɨ́a ódroné kɨ́ kúrúne ꞌdága kɨ́dí, “Maríya, Lomo iꞌbí úndru go zɨ́yị rómo do ꞌbɨ lafúyị e mbá. Iꞌbí kpá úndru go zɨ́ Owụ́ bɨ sɨmɨyị́ née. ");
INSERT INTO bdh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Áko, Lomo eme laká kɨ́ma káa gɨ zɨ́ ꞌdi, bɨ zɨ́ mbágá Ngére amá ị́nyịné za cụ́ ne ógụné lúrú máa ní? ");
INSERT INTO bdh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maríya, sɨmɨ bɨ gáa máúwú kúrú yị́ị ní, geré zɨ́ sɨmɨmá ndị́sịné ndéndeke kɨ́ mongụ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngére Lomo idí ídí kɨ́yị, gɨ zɨ́a ṇgúṇgu go yá éyị́ bɨ ili méngị a zɨ́yị ní, idí mu méngị a.” ");
INSERT INTO bdh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maríya ya kɨ́dí, “Mákófó ịrị Ngére amá Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mááyí go kɨ́ rokinyi gɨ zɨ́ Lomo ꞌyị yómo máa. ");
INSERT INTO bdh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Máa bɨ mándá éyị́ wá ba, oto ledremá go zɨ́ne owóowó. Tónóne karaba ndéréne ꞌdáꞌdá, tụ́ꞌdụ́ ꞌyị e nɨyí ndị́sị úku ledre kɨ́dí Lomo iꞌbí úndru go zɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wo, Mbigí Lomo bɨ kɨ́ rokoꞌbụné kɨ́ngaya ní mengị mongụ́ ledre go zɨ́ma. ꞌYị e idínɨ́ ndị́sị kófó ịrịa. ");
INSERT INTO bdh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ꞌYị ga bɨ nɨyí ndị́sị óto úndru a ní, nɨ ndị́sị méngị bɨlámá ledre zɨ́ye ndéréne mɨndéré za fí. ");
INSERT INTO bdh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mengị tụ́ꞌdụ́ mɨngburoko ledre e go, Ngére máa yée ga bɨ ndịsịnɨ́ ị́lị́ mɨị́lị́ ní, nɨ báyi yée mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Zɨ́a ꞌdíꞌbióyó rokoꞌbụ gɨ zɨ́ yée ga bɨ ndịsịnɨ́ óto ledreyé kɨ́ royé owóowó ní, zɨ́a óto yée ga bɨ ꞌbụoꞌbụ́nɨ́ royé mɨꞌbúóꞌbụ́ ní do bi kacɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iꞌbí tụ́ꞌdụ́ éyị́ e go zɨ́ ꞌyị ga bɨ kóna ndịsịnɨ́ ndúwú gɨ zɨ́ lerị́ ní, oto yée ga bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye ní go káa do ꞌyị lerị́ e. ");
INSERT INTO bdh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ledre bɨ kóo mocụ́ gɨ ro sáká Isɨréle e ní lịgị wo wá, nɨ go ndị́sị sáká yée. ");
INSERT INTO bdh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Uku kóo zɨ́ bulúnduzé Abarayáma kɨ́ owụ́ ꞌbɨ owụ́ ꞌbɨ ené e kpá kenée kɨ́dí née nɨ ndị́sị sáká yée kenée za fí odụ a ndaá.” ");
INSERT INTO bdh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maríya ndịsị kóo zɨ́ Elizebéta íri káa zɨ́ éyị́ ꞌbɨ éfé ota ní, zɨ́a nda ndáꞌbalúgu roné ꞌbe ꞌbɨ ené. ");
INSERT INTO bdh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Née ní, zɨ́ sịndị́ kadra ꞌbɨ Elizebéta útúásáne, zɨ́a áráne owụ́oꞌdo. ");
INSERT INTO bdh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Zɨ́ phanda ledre née ówụ́ ndíki sụmụ Elizebéta kɨ́ eze ꞌbe ꞌbɨ ené e mbá kɨ́dí, Ngére Lomo mengị bɨlámá ledre go zɨ́a. Zɨ́ Elizebéta kɨ́ ꞌyị ga gére née mbá ídíye kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sɨmɨ bɨ síṛí owụ́ mengị go sị́lị́ ịnyị doa ota ní, zɨ́ye yóko royé ónzó wo ngbuṛu, kacɨ́ ondụ́ eyé ꞌbɨ Yụ́da e. Ilinɨ́ kóo gɨ ro ị́fị́ ịrị ꞌbụa doa, Zakaríya. ");
INSERT INTO bdh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Zɨ́ mbágá a úku ledre kɨ́dí, “Ɨ́ꞌɨ, ndanɨ́ ị́fị́ ịrị ꞌbụa doa wá, ịrịa idí ídí Yiwáni.” ");
INSERT INTO bdh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Zɨ́ye ụ́tụyé zɨ́a kɨ́dí, “Ɨ́, ịrị káa zɨ́ née ndaá sɨmɨ kúfúse wá.” ");
INSERT INTO bdh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zɨ́ye ndúꞌyú Zakaríya kɨ́ sị́lị́ye togụ́ ili zɨ́ ịrị owụ́ ba ídíne náambi yá? ");
INSERT INTO bdh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zɨ́a ndúꞌyú yée kɨ́ sị́lị́ne gɨ ro éyị́ ꞌbɨ éké ledre. Zɨ́a éké ịrị owụ́ née zɨ́ye, “Yiwáni.” ");
INSERT INTO bdh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Geré zɨ́ tara Zakaríya líkpíne zɨ́a tónóne ódroné kɨ́ ndị́sị mbófo Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zɨ́ tara eze ꞌbe ꞌbɨ ené e ị́drị́ye mbá mɨị́drị́, zɨ́ ꞌyị e ídíye sɨmɨ Yụdáya mbá kɨ́ ledre née tarayé. ");
INSERT INTO bdh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngíti géyị ꞌyị ga bɨ uwúnɨ́ ledre máa née ní ní, zɨ́ye ndị́sịyé sómụ́ lóꞌbó ledre kɨ́dí, “Owụ́ née nɨ gú ídí toso ꞌyị máa bɨ kɨ́e ꞌdi káa zɨ́ bɨ Ngére Lomo yeme ledre gɨ roa ne kenée ní?” ");
INSERT INTO bdh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zɨ́ ꞌDówụ́ Lomo ꞌdúcu Zakaríya, zɨ́a ị́nyịné úku ledre bɨ gú karanée nɨ méngị roné ní kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mbófo éyị́ zɨ́ Lomo bɨ nɨ Ngére ꞌbɨ Isɨréle e ní, gɨ zɨ́a ogụ go yómo ꞌyị ené e. ");
INSERT INTO bdh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kasaogụ ꞌyị bɨ kɨ́ rokoꞌbụné ní go gɨ sɨmɨ kúfú ngére Dawídi gɨ ro yómo zée, ");
INSERT INTO bdh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","káa zɨ́ bɨ kóo ukuiꞌbí tara nébị ené ga kóna ꞌdesị́ ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bɨ ba ní, omozé gɨ zɨ́ ezeokóze e kpá kɨ́ yée ga bɨ ndịsịnɨ́ sógó zée ní go. ");
INSERT INTO bdh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Lomo mengị bɨlámá ledre née zɨ́ bulúnduzé e kenée gɨ ro ꞌdódo a kɨ́dí ledre bɨ kóo née yeme zɨ́ye ní lịgị ené née wá. ");
INSERT INTO bdh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Née mɨyéme ledre kóo dongaráye kɨ́ bulúnduzé Abarayáma, ");
INSERT INTO bdh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","gɨ ro zɨ́ze ómozé gɨ zɨ́ ezeokóze e, gɨ do bɨ zɨ́ze ndị́sịzé méngị moko ené kɨ́ sómụ́ ledre ezé kị́éꞌdo ngịrị ndaá, ");
INSERT INTO bdh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","gɨ zɨ́a azé go mbigí ꞌyị ené e do komo a kacɨ́ kadra mbá. ");
INSERT INTO bdh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yị́ị, owụ́ ꞌbɨ amá, ꞌyị e nɨyí ndị́sị ndólo yị́ị kɨ́dí nébị ꞌbɨ Lomo gɨ zɨ́a áyí ndị́sị ndéré zɨ́a ꞌdáꞌdá kɨ́ yémeómo ꞌyị e zɨ́ Ngére nzíyiné. ");
INSERT INTO bdh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Áyí ꞌdódo ledre zɨ́ye yá idínɨ́ ṇgúṇgu ledre ꞌbɨ Lomo gɨ do bɨ zɨ́ Lomo ótoómo lúyú ledre eyé gɨ ro zɨ́ye ndíki trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ledre née nɨ méngị roné kenée gɨ zɨ́ bɨlámá mɨmbéꞌde Lomo bɨ rozé ní, nɨ kásaógụ ꞌyị gɨ komo ere káa do bimɨóṇgó zɨ́ze do sogo káṇgá ona, ");
INSERT INTO bdh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","zɨ́ bi óṇgóne zɨ́ ꞌyị ga bɨ nɨyí sɨmɨ mɨtụlụrụ ꞌbɨ lúyú ledre zɨ́ ngịrị umbu ndị́sịné méngị yée kacɨ́ kadra mbá ní, zɨ́a ndị́sịné ꞌdódo mɨsiꞌdi ꞌbɨ Lomo zɨ́ze, zɨ́ mɨmbéꞌdezé ị́drị́ne gɨ zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","“Née ní, zɨ́ Yiwáni nda ngbóró ógụné go yaꞌdá ꞌyị. Zɨ́ Lomo íꞌbí rokoꞌbụ zɨ́a, zɨ́a ndéré ndị́sịné sɨmɨ súwú gbála gị sɨmɨ sịndị́ kadra bɨ zɨ́a tónóne ꞌdódo ledre ꞌbɨ Lomo zɨ́ Isɨréle e ní.” ");
INSERT INTO bdh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sɨmɨ sịndị́ kadra kị́éꞌdo, zɨ́ Agụ́sụto bɨ ndolonɨ́ wo Káyísara ní iꞌbí lorụ kɨ́dí, idínɨ́ ólo ꞌyị ꞌbɨ Róma mbá gɨ ro zɨ́ne ówo a togụ́ nɨyí mbá ndu. ");
INSERT INTO bdh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Née kóo mɨzefị ólo ꞌyị e bɨ olonɨ́ sɨmɨ bɨ Korịnị́yo nɨ gávana sɨmɨ ngíti gara ꞌbɨ Róma kɨ́ ịrịné Sụ́rịya ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Zɨ́ ꞌyị e ndị́sị ndéréye sɨmɨ gara eyé e gɨ ro do ólo yée íri. ");
INSERT INTO bdh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zɨ́ Yoséfa bulúndu ngére Dawídi ị́nyịné gɨ sɨmɨ Nazeréta owụ́ gara sɨmɨ Galiláya, ndéréne sɨmɨ Beteléme mongụ́ gara bɨ kóo Dawídi nɨ ngére sɨmɨ a, sɨmɨ Yụdáya ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nderénɨ́ kɨ́ Maríya bɨ korónɨ́ zɨ́a ní gɨ do bɨ do ólo yée kéne íri. Sịndị́ kadra ꞌbɨ Maríya maꞌdáa nɨ kóo go gbóo gɨ ro zɨ́a áráne. ");
INSERT INTO bdh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sɨmɨ bɨ nɨyí aka cịkị íri ní, zɨ́ sịndị́ kadra ené ꞌbɨ árá go útúásáne. ");
INSERT INTO bdh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Zɨ́a tɨ́ árá mɨzefị owụ́ ꞌbɨ ené née owụ́oꞌdo. Zɨ́a kụ́ṛụ́kụ yéme wo kɨ́ mbílí bongó do óto wo kɨ́e yaa sɨmɨ kuṛungbú bɨ bangá e ndịsịnɨ́ ánu éyị́ sɨmɨ a ní, gɨ zɨ́a bi ndaá lolụ kóo zɨ́ye sɨmɨ ꞌdị́cị́ ꞌbɨ ṇgu e wá. ");
INSERT INTO bdh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, ꞌyị ꞌbáꞌbá kábịṛị́kị e nɨyí kóo gbóo kɨ́rɨ́ née ndị́sị ꞌbáꞌbá bangá eyé e kɨ́ ndụlụ. ");
INSERT INTO bdh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Zɨ́ maláyika ꞌbɨ Ngére Lomo ógụné zɨ́ye íri, zɨ́ rokoꞌbụ ꞌbɨ Lomo óṇgó bi cigíye gbaá wéé, zɨ́ ngịrị méngị yée kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Zɨ́ maláyika née úku ledre zɨ́ye kɨ́dí, “Ndásé éré ngịrị wá. Máógụ kɨ́ bɨlámá sanda zɨ́se wo bɨ bi nɨ éme rosé gɨ zɨ́a mɨéme kpá kɨ́ tụ́ꞌdụ́ ꞌyị e mbá ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aránɨ́ gáa owụ́ go zɨ́se wo bɨ nɨ ídí ꞌYị yómo ꞌyị e ní, sɨmɨ Beteléme gara bɨ kóo Dawídi nɨ sɨmɨ a ngére ní. Nɨ Kɨ́résịto kpá Ngére. ");
INSERT INTO bdh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Togụ́ ndérésé yá, ásé ndíki owụ́ maꞌdáa mɨkụ́ṛụ́kụné sɨmɨ mbílí bongó otonɨ́ wo go kɨ́e sɨmɨ kuṛungbú bɨ bangá e ndịsịnɨ́ ánu éyị́ sɨmɨ a ní.” ");
INSERT INTO bdh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Luꞌbú wá, zɨ́ tụ́ꞌdụ́ ngíti géyị maláyika e ógụyé gɨ komo ere ídíye ndro kɨ́ ezeyé gáa ogụ ní. Zɨ́ye ndị́sịyé kófó ịrị Lomo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Idízé kófó ịrị Lomo bɨ komo ere ní, bikịdrị́ idí ídí zɨ́ ꞌyịmaꞌdí e do sogo káṇgá gɨ zɨ́a mengị bɨlámá ledre go zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sɨmɨ bɨ maláyika e ndaꞌbalugunɨ́ royé komo ere ní, zɨ́ ꞌyị ꞌbáꞌbá kábịṛị́kị ga gére née yéme ledre kɨ́dí, “Nderézé aka mu sɨmɨ Beteléme lúrú ledre bɨ mengị roné íri, bɨ Ngére Lomo kasa ledre a zɨ́ze ba.” ");
INSERT INTO bdh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Zɨ́ye ndéréógụyé íri ndíki Maríya kɨ́ Yoséfa kɨ́ síṛí owụ́ mɨꞌdúꞌduné sɨmɨ kuṛungbú tɨ́ káa zɨ́ bɨ ukunɨ́ zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sɨmɨ bɨ nderé ndikinɨ́ owụ́ née tɨ́ kenée ní, zɨ́ye lị́kpị́ ledre bɨ mengị roné zɨ́ye gɨ ro owụ́ née ní ní mbá zɨ́ Maríya kɨ́ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ꞌYị ga bɨ uwúnɨ́ ledre née kenée ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́. ");
INSERT INTO bdh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Zɨ́ Maríya ụ́lụ ledre ga gére née mbá sɨmɨné ndị́sị kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Zɨ́ yaꞌdá ga gére née ị́nyị ndáꞌbalúgu royé kɨ́ kófó ịrị Lomo kpá kɨ́ mbófo wo gɨ ro ledre bɨ uwúnɨ́ zɨ́ye lúrú a go cụ́ kɨ́ komoyé tɨ́ káa zɨ́ bɨ maláyika e ukunɨ́ zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sɨmɨ bɨ síṛí Yésụ mengị go sị́lị́ ịnyị doa ota (8) ní, née kóo go sị́lị́ bɨ do ónzó wo ngbuṛu sɨmɨ a ní kacɨ́ ondụ́ ꞌbɨ Yụ́da e. Do ị́fị́ ịrịa Yésụ, née ịrị bɨ kóo maláyika ịfị́ ꞌdodo sɨmɨ bɨ Yésụ maꞌdáa ndaá aka kóo wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nda gɨ ore zɨ́ sịndị́ kadra útúásáne zɨ́ Maríya gɨ do kacɨ́ árá bɨ ará ní, gɨ ro zɨ́a ndáꞌba ólụ́lúgu roné ꞌDị́cị́ ꞌbɨ Lomo káa zɨ́ bɨ lorụ ꞌbɨ Mụ́sa uku ní. Zɨ́ye ꞌdíꞌbi síṛí Yésụ ndéré kɨ́e sɨmɨ Yerụsaléma sɨmɨ ꞌDị́cị́ kótrụro íꞌbí mbófo éyị́ zɨ́ Lomo gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nɨ mɨékéne sɨmɨ lorụ ꞌbɨ Lomo kɨ́dí, “Owụ́ndíká ga bɨ yaꞌdá e ní, idínɨ́ ndéré kɨ́ye zɨ́ Lomo,” ");
INSERT INTO bdh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","gɨ ro do íꞌbí tákpásị́lị́ káa zɨ́ bɨ lorụ ꞌbɨ Lomo uku ní, “Nɨyí ꞌdíꞌbi amámu e gbre kɨ́ kị́ṛịkóꞌdo kpá gbre ndéré kɨ́e káa do éyị́ ꞌdáná.” ");
INSERT INTO bdh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, ngoko oꞌdo nɨ kóo bo sɨmɨ Yerụsaléma ore kɨ́ ịrịné Simiyóna, nɨ ꞌyị bɨ iꞌbí roné za mbá zɨ́ Lomo ní. Oꞌdo née nɨ mɨꞌdúcuné kɨ́ ꞌDówụ́ Lomo, kacɨ́ kadra mbá ndịsị óto komoné gɨ ro Kɨ́résịto zɨ́a ógụné yómo Isɨréle e. ");
INSERT INTO bdh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ꞌDówụ́ Lomo uku kóo ledre go zɨ́a kɨ́dí, wo Simiyóna utúasá aka úyu wá ꞌbúó togụ́ lurú Kɨ́résịto bɨ Ngére Lomo nɨ kásaógụ wo ní go kɨ́ komoné kí. ");
INSERT INTO bdh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sɨmɨ sị́lị́ máa bɨ kóo née ní, zɨ́ ꞌDówụ́ Lomo kása Simiyóna zɨ́a ndéréne do ligá ꞌDị́cị́ ꞌbɨ Lomo. Nɨ ógụ íri ní, Maríya kɨ́ Yoséfa ꞌdiꞌbiogụnɨ́ síṛí Yésụ go íri gɨ ro zɨ́a íꞌbí úndru zɨ́ Yésụ maꞌdáa káa zɨ́ bɨ bụ́kụ ꞌbɨ lorụ uku ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Zɨ́ Simiyóna ị́mbị́ wo do íꞌbí mbófo éyị́ zɨ́ Lomo gɨ roa kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yị́ị Lomo bɨ kɨ́ mongụ́ rokoꞌbụyị́ ní, uku kóo zɨ́ma yá útúásá aka ꞌdíꞌbi máa wá, ꞌbúó togụ́ málúrú ꞌyị yómo ꞌyị e bɨ kóo uku ledre a ní go, áyí nda fú ꞌdíꞌbi máa. Bɨ ba ní, ꞌdíꞌbi nda máa ꞌyị kasa eyị́ mu. ");
INSERT INTO bdh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Komomá lurú nda ꞌyị yómo ꞌyị e go, ");
INSERT INTO bdh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kásaógụ wo go zɨ́ ꞌyị e za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nɨ go káa zɨ́ bimɨóṇgó ní gɨ ro ꞌdódo yị́ị zɨ́ ꞌyị ga bɨ owonɨ́ aka yị́ị wá ní. Nɨ kpá óto kúfú Isɨréle e ndị́sị kófó ịrịyị́.” ");
INSERT INTO bdh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Zɨ́ tara Yoséfa kɨ́ Maríya ị́drị́ne gɨ zɨ́ ledre bɨ Simiyóna ndịsị úku a gɨ ro Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Zɨ́ Simiyóna íꞌbí úndru zɨ́ Yoséfa kɨ́ Maríya, zɨ́a úku ledre zɨ́ Maríya kɨ́dí, “Owụ́ ꞌbɨ eyị́ ba ní karanée óto Lomo zɨ́a ꞌdíꞌbióyó rokoꞌbụ gɨ zɨ́ ngíti géyị Isɨréle, zɨ́a íꞌbí a zɨ́ ngíti géyị. Owụ́ ba nɨ kpá ídí ꞌyị bɨ nɨyí lúrú tóko lị́lị ledre gɨ roa ní. Gɨ zɨ́ kéyị née, nɨyí karanée ndị́sị sógó wo. Nɨ óto ꞌyị ga bɨ ṇguṇgunɨ́ ledre ené ní zɨ́ye ídíye kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nɨ ꞌdódoógụ ledre ga bɨ do mɨmbéꞌde ngíti géyị ꞌyị e ní mbá. Gɨ zɨ́ kéyị née, mɨmbéꞌdeyị́ nɨ karanée ꞌdécị kɨ́ lúrú ndúwú wo.” ");
INSERT INTO bdh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ngíti nébị nɨ kóo kpá bo ngoko kára kɨ́ ịrịné Ána nyị́ Fanuwéle gɨ sɨmɨ kúfú bɨ ndolonɨ́ Aséra ní. Nɨ kára umbu. Ofụ́nɨ́ royé kɨ́ oꞌdo ꞌbɨ ené mengịnɨ́ sɨmɨbi lá dụụ́ ịnyị doa gbre (7) geré zɨ́ oꞌdo ꞌbɨ ené née úyu ené. ");
INSERT INTO bdh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Zɨ́a ndị́sịné gɨ kacɨ́ oꞌdo ꞌbɨ ené née kɨ́ sɨmɨbi cị́ eso doa eso (84). Otoomo ꞌDị́cị́ ꞌbɨ Lomo wá, ndịsị íni ini kɨ́ órụ́ tarané zɨ́ Lomo kɨ́ ndụlụ kɨ́ kadra mbá. ");
INSERT INTO bdh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sɨmɨ bɨ Simiyóna nɨ ndị́sị íꞌbí úndru ní, zɨ́ kára née ógụné geré ndị́sị íꞌbí mbófo éyị́ zɨ́ Lomo. Zɨ́a úku ledre bɨ gɨ do bɨ Yésụ ní mbá zɨ́ ꞌyị ga bɨ ndịsịnɨ́ óto komoyé gɨ ro Ngére ꞌyị yómo ꞌyị e bɨ Lomo uku ledre kásaógụ wo sɨmɨ Yerụsaléma káa do ꞌyị yómo ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sɨmɨ bɨ Yoséfa e kɨ́ Maríya mengịonzónɨ́ ledre bɨ lorụ ꞌbɨ Lomo ili zɨ́ye méngị a ní go ní, zɨ́ye ị́nyịyé ndáꞌbalúgu royé ꞌbe sɨmɨ Nazeréta sɨmɨ Galiláya. ");
INSERT INTO bdh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Zɨ́ Yésụ ngbóróne go mongụ́ne kɨ́ rokoꞌbụné, zɨ́a ídíne kɨ́ mongụ́ ówo ledre zɨ́ne gɨ zɨ́a Lomo ndịsị sáká wo ne. ");
INSERT INTO bdh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kacɨ́ sɨmɨbi e mbá Yoséfa kɨ́ Maríya ndịsịnɨ́ ndéré sɨmɨ Yerụsaléma sɨmɨ Ayímbi bɨ Umbuokpó ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sɨmɨ bɨ Yésụ mengị go sɨmɨbi sokó doa gbre ní, zɨ́ye ndéréye kɨ́ mbágá née sɨmɨ ayímbi máa née kacɨ́ ondụ́ ꞌbɨ Yụ́da e. ");
INSERT INTO bdh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nda go gɨ do kacɨ́ ayímbi, zɨ́ mbágáa ị́nyịyé ndáꞌbalúgu royé ꞌbe, ábuwá Yésụ idíaká go cịkị ꞌdáꞌba sɨmɨ Yerụsaléma owonɨ́ eyé e wá. ");
INSERT INTO bdh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Somụ́nɨ́ ꞌbɨ eyé kɨ́dí nɨ ba bo dongará tụ́ꞌdụ́ ꞌyị ga ba zɨ́ye ndéréye kadra teké. Zɨ́ye tóroyé lúrú sóꞌdo wo dongará sụmụ yée kpá kɨ́ ezegámáye. ");
INSERT INTO bdh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Má, ndikinɨ́ eyé wo wá. Zɨ́ye ị́nyị ndáꞌbalúgu royé drú ꞌdáꞌba sɨmɨ Yerụsaléma ndéré lúrú bi gɨ roa íri. ");
INSERT INTO bdh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nda gɨ do kacɨ́ sị́lị́ ota zɨ́ye ndéréye ndíki wo sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo, mɨndị́sịné dongará ꞌyị ꞌdódo ledre e, ndị́sị úwú yée, zɨ́a kpá kɨ́ ndúꞌyú yée. ");
INSERT INTO bdh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ꞌYị ga bɨ ndịsịnɨ́ úwú wo ní zɨ́ tarayé ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ ówo ledre bɨ nɨ kɨ́e kpá kɨ́ ledre ga bɨ ndịsị kɨ́ úkulúgu yée ní. ");
INSERT INTO bdh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sɨmɨ bɨ mbágáa kɨ́ ꞌbụa lurúndikinɨ́ wo ní, zɨ́ wo bɨ gɨ zɨ́ye ní ụ́kụ́ne mɨụ́kụ́. Zɨ́ mbágáa úku ledre kɨ́dí, “Owụ́ ꞌbɨ amáa, méngị zée káa gɨ zɨ́ ꞌdi? Bɨ zɨ́ze ndị́sịzé kɨ́ ꞌbụyị́ gámásóꞌdo yị́ị má ní.” ");
INSERT INTO bdh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Zɨ́a úkulúgu ledre zɨ́ mbágáne kɨ́dí, “Ndị́sịsé gámásóꞌdo máa gɨ ro ꞌdi? Ówosé esé bɨ kɨ́dí ili zɨ́ma ndị́sị ndị́sịmá sɨmɨ ꞌdị́cị́ ꞌbɨ Babá ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Owo ꞌdiꞌbinɨ́ eyé ledre gɨ sɨmɨ ledre bɨ uku née wá. ");
INSERT INTO bdh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zɨ́a óto úndruyé do útúne doꞌdónoyé zɨ́ye ndáꞌbayé sɨmɨ Nazeréta. Zɨ́ mbágáa óto ledre ga gére née mbá sɨmɨné. ");
INSERT INTO bdh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zɨ́ Yésụ nda ngbóróógụné kɨ́ bɨlámá sanáne, do ídíne kɨ́ mongụ́ ówo ledre zɨ́ ꞌbúa ídíne do ꞌyị e kɨ́ngaya zɨ́a óto Lomo ídíne kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sɨmɨ bɨ kóo Tịbérịya Káyísara nɨ ngére do káṇgá ꞌbɨ Róma kɨ́ sɨmɨbi sokó doa ịnyị ní, do kóo óto Pánato Piláto káa do gávana do ꞌyị ga bɨ sɨmɨ Yụdáya ní, Eróde nɨ ꞌbɨ ené gávana do ꞌyị ga bɨ sɨmɨ Galiláya ní, Phị́lịpo lúndu Eróde nɨ ꞌbɨ ené gávana do ꞌyị ga bɨ sɨmɨ Itụ́rịya kpá kɨ́ yée ga bɨ sɨmɨ Trakóni ní, zɨ́ Liyasaníya nda ídí ꞌbɨ ené gávana do ꞌyị ga bɨ sɨmɨ Abiléne ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Ána kɨ́ towụ́ne Kayáfa nɨyí ye mɨngburoko ꞌyị ꞌdáná éyị́ e. Yiwáni wotị́ Zakaríya nɨ yị́ ené kóo sɨmɨ súwú. Zɨ́ Lomo íꞌbí moko zɨ́a íri. ");
INSERT INTO bdh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zɨ́a tónó gámáne kɨ́ úku ledre ꞌbɨ Lomo zɨ́ ꞌyị e kacɨ́ kóꞌdụ́ ngbuṛu bɨ Yeredéne ní, sága gɨ ꞌdí keṛị́ kpá sága gɨ ꞌdí keṛị́. Kɨ́dí ꞌyị e idínɨ́ ótoómo kɨ́ lúyú ledre zɨ́ye ṇgúṇgu ledre ꞌbɨ Lomo gɨ ro do bábátị́zị́ yée zɨ́ Lomo ótoómo lúyú ledre eyé ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nébị Isáya uku kóo ledre a go ꞌdesị́ sɨmɨ bụ́kụ ené kɨ́dí, “ꞌYị nɨ karanée ndị́sị ótrụ́ ledre sɨmɨ súwú zɨ́ ꞌyị e kɨ́dí, yémeómosé mɨsiꞌdi mu nzíyiné zɨ́ Ngére, ídísé ꞌdózo yéme mɨsiꞌdi zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ídísé lósoꞌdụ́tụ ꞌbululu e ꞌdáꞌba. Landa e kɨ́ bi ekị́ekị́ e, ídísé lóso yée kpɨ́kásí. Zɨ́se ꞌdózo yéme mɨngóꞌdụ́ mɨsiꞌdi e zɨ́ye ídíye mbị́. Zɨ́se lósoꞌdụ́tụ gɨ́ṛítí e kuṛí. ");
INSERT INTO bdh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kúfú ꞌyịmaꞌdí e mbá nɨyí ówo a kɨ́dí oꞌdo ba Lomo kasa wo ne ógụ yómo ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Née ní, zɨ́ tụ́ꞌdụ́ ꞌyị e go ndị́sị ógụyé mutruu zɨ́ Yiwáni gɨ ro zɨ́a bábátị́zị́ yée. Zɨ́a úku ledre zɨ́ye oꞌbụóꞌbụ kɨ́dí, “Sée ꞌyị mani ga bɨ mɨméngị ledre esé nɨ bɨsinyíne káa zɨ́ kámá okó ní, ambí uku zɨ́se ya ídísé ngásáóyó rosé gɨ zɨ́ zingi ꞌbɨ Lomo bɨ nɨ ógụ dosé ní ne? ");
INSERT INTO bdh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Togụ́ ílisé tɨ́ gɨ ro zɨ́se ndíki trịdrị yá, ídísé ótoómo lúyú ledre zɨ́se ṇgúṇgu ledre ꞌbɨ Lomo, zɨ́ mɨméngị ledre esé ndị́sị ídíne bɨlámáne. Ndásé ídí dụụ́ kɨ́ sómụ́ ledre bɨ kɨ́dí, azé yị́ ezé bulúndu Abarayáma omozé ꞌbɨ ezé yị́ ezé go ní wá. Lomo nɨ kɨ́ rokoꞌbụ zɨ́a óyólóꞌbó tutú ga bɨ bi ba zɨ́ye ídíye káa do bulúndu Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ásé zɨ́ Lomo káa zɨ́ kágá bɨ ꞌdịyị́nɨ́ mɨꞌdị́yị́ yáká ní. Goṇgo ꞌbɨ Lomo nɨ go do sị́lị́a nzíyiné, kágá máa wo bɨ bɨlámá mɨáná a ndaá ní, nɨ lágáónzó a do óngbóóyó a ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zɨ́ tụ́ꞌdụ́ ꞌyị ga gére née ndúꞌyú Yiwáni kɨ́dí, “Éyị́ bɨ idízé nda méngị a ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zɨ́ Yiwáni úkulúgu ledre zɨ́ye kɨ́dí, “Togụ́ bongó nɨ zɨ́yị gbre, ídí íꞌbí ngúru a zɨ́ ꞌyị bɨ bongó nda zɨ́a wá ní. Togụ́ éyị́ mɨánu nɨ bo zɨ́yị, ídísé ánu a kɨ́ ꞌyị bɨ nɨ ꞌbú ní.” ");
INSERT INTO bdh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abú kpá ꞌyị ga bɨ ndịsịnɨ́ ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e sɨmɨ sụ́ụ ní, zɨ́ye ndéréye gɨ ro babatị́za. Zɨ́ye ndúꞌyú Yiwáni kɨ́dí, “Mongụ́ ꞌyị, Sara nda zée, idízé méngị ꞌbɨ ezé ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Zɨ́ Yiwáni úkulúgu ledre zɨ́ye kɨ́dí, “Ndásé ꞌdíꞌbi késị́ maꞌdáa rómo do wo bɨ mɨngburoko ꞌyị e esé e ilinɨ́ ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Zɨ́ asikíri e ndúꞌyú wo kɨ́dí, “Sara nda zée?” Yiwáni ya zɨ́ye ní, “ꞌYị e ndanɨ́ úgú komosé wá, ndásé kpá gágaóto ledre ro ꞌyị wá. Késị́ bɨ ndịsịnɨ́ íꞌbí a zɨ́se do bi moko ní, ídísé ꞌdíꞌbi dụụ́ wo.” ");
INSERT INTO bdh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gɨ zɨ́ ledre ga gére ní, Zɨ́ sómụ́ ledre ꞌbɨ ꞌyị e ndị́sị ídíne gɨ ro Yiwáni faa, ngíti géyị ya ala zɨ́a ídíne née Kɨ́résịto bɨ Lomo uku ledre kásaógụ a káa do ꞌyị yómo ꞌyị e ní wá? ");
INSERT INTO bdh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zɨ́ Yiwáni úkulúgu ledre zɨ́ye kɨ́dí, “Mábábátị́zị́ ꞌbɨ amá sée lá kɨ́ iní. Ngíti ꞌyị nɨ bo rokoꞌbụ a romo do ꞌbɨ amá nɨ ógụ. Máútúásá gbawá ndósoógụ cigí a gɨ ro lálaógụ wará ené gɨ sịndị́a. Nɨ ꞌbɨ ené bábátị́zị́ sée kɨ́ ꞌDówụ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nɨ ꞌbɨ ené yị́ ené káa zɨ́ ꞌyị ócó komo kére ní. Nɨ léfeóto kére ené sɨmɨ bɨlámá éyị́, cící a née zɨ́a kótrụ a trị́e do óngbóóyó a ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Née ledre bɨ kóo Yiwáni ndịsị úku a zɨ́ye do tụ́ꞌdụ́ mɨsiꞌdi e gɨ ro bɨlámá ledre ꞌbɨ Lomo bɨ kóo ndịsị ꞌdódo a zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yiwáni ndịsị kóo kpá máda ngére Eróde Andipá gɨ zɨ́ bɨsinyí ledre ga bɨ ndịsị mengị yée káa zɨ́ bɨ ngakaoyó kára Erodíya gɨ zɨ́ lúnduné ꞌdíꞌbi yị́ ené zɨ́ne ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Zɨ́ Eróde kpá lúyú ngíti ledre zɨ́a ꞌdíꞌbi Yiwáni ónzó a ngbrɨwó sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ꞌDáꞌdá do ónzó Yiwáni sɨmɨ sị́gịnị, kadra kị́éꞌdo nɨ go ndị́sị bábátị́zị́ tụ́ꞌdụ́ ꞌyị e, zɨ́ Yésụ ndéréne zɨ́a, zɨ́a bábátị́zị́ wo. Sɨmɨ bɨ Yésụ maꞌdáa nɨ ndị́sị íni ini zɨ́ Lomo ní, zɨ́ ere líkpíne zɨ́a káa zɨ́ mbotụ ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Zɨ́ ꞌDówụ́ Lomo ógụné doa káa zɨ́ kị́ṛịkóꞌdo ní. Zɨ́ kúrú ꞌyị ówụ́ne gɨrí kɨ́dí, “Áyí mbigí owụ́ ꞌbɨ amá, ꞌbúyị ofụ domá go, mááyí kɨ́ rokinyi gɨ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yésụ tonó kóo méngị moko ꞌbɨ Lomo sɨmɨ bɨ mengị go sɨmɨbi cị́ kéṛị́ a do sokó (30) ní. ꞌYị e mbá ndịsịnɨ́ ꞌbɨ eyé kóo sómụ́ a kɨ́dí nɨ owụ́ ꞌbɨ Yoséfa bɨ kɨ́ ịrịné Élị ní. ");
INSERT INTO bdh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Élị nɨ ꞌbɨ ené owụ́ ꞌbɨ Matáta, Matáta nɨ ꞌbɨ ené owụ́ ꞌbɨ Lévị, Lévị nɨ ꞌbɨ ené owụ́ ꞌbɨ Mélịkị, Mélịkị nɨ ꞌbɨ ené owụ́ ꞌbɨ Zanáyi, Zanáyi nɨ ꞌbɨ ené owụ́ ꞌbɨ Yoséfa. ");
INSERT INTO bdh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoséfa nɨ ꞌbɨ ené owụ́ ꞌbɨ Matatíya, Matatíya nɨ ꞌbɨ ené owụ́ ꞌbɨ Amósa. Amósa nɨ ꞌbɨ ené owụ́ ꞌbɨ Nawúma. Nawúma nɨ ꞌbɨ ené owụ́ ꞌbɨ Esíli. Esíli nɨ ꞌbɨ ené owụ́ ꞌbɨ Nagáyi. ");
INSERT INTO bdh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagáyi nɨ ꞌbɨ ené owụ́ ꞌbɨ Máta. Máta nɨ ꞌbɨ ené owụ́ ꞌbɨ Matatíya. Matatíya nɨ ꞌbɨ ené owụ́ ꞌbɨ Seméni. Seméni nɨ ꞌbɨ ené owụ́ ꞌbɨ Yoséke. Yoséke nɨ ꞌbɨ ené owụ́ ꞌbɨ Yóda. ");
INSERT INTO bdh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yóda nɨ ꞌbɨ ené owụ́ ꞌbɨ Yonána. Yonána nɨ ꞌbɨ ené owụ́ ꞌbɨ Résa. Résa nɨ ꞌbɨ ené owụ́ ꞌbɨ Zerụbábele. Zerụbábele nɨ ꞌbɨ ené owụ́ ꞌbɨ Seretiyéle. Seretiyéle nɨ ꞌbɨ ené owụ́ ꞌbɨ Nérị. ");
INSERT INTO bdh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérị nɨ ꞌbɨ ené owụ́ ꞌbɨ Meléki. Meléki nɨ ꞌbɨ ené owụ́ ꞌbɨ Ádi. Ádi nɨ ꞌbɨ ené owụ́ ꞌbɨ Kosóma. Kosóma nɨ ꞌbɨ ené owụ́ ꞌbɨ Elimadáma. Elimadáma nɨ ꞌbɨ ené owụ́ ꞌbɨ Éra. ");
INSERT INTO bdh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Éra nɨ ꞌbɨ ené owụ́ ꞌbɨ Yósuwa. Yósuwa nɨ ꞌbɨ ené owụ́ ꞌbɨ Eliyázara. Eliyázara nɨ ꞌbɨ ené owụ́ ꞌbɨ Zoríma. Zoríma nɨ ꞌbɨ ené owụ́ ꞌbɨ Matáta. Matáta nɨ ꞌbɨ ené owụ́ ꞌbɨ Lévị. ");
INSERT INTO bdh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lévị nɨ ꞌbɨ ené owụ́ ꞌbɨ Simiyóna. Simiyóna nɨ ꞌbɨ ené owụ́ ꞌbɨ Yụ́da. Zụ́da nɨ ꞌbɨ ené owụ́ ꞌbɨ Yoséfa. Yoséfa nɨ ꞌbɨ ené owụ́ ꞌbɨ Yonáma. Yonáma nɨ ꞌbɨ ené owụ́ ꞌbɨ Alikíma. ");
INSERT INTO bdh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Alikíma nɨ ꞌbɨ ené owụ́ ꞌbɨ Melíya. Melíya nɨ ꞌbɨ ené owụ́ ꞌbɨ Ména. Ména nɨ ꞌbɨ ené owụ́ ꞌbɨ Matáta. Matáta nɨ ꞌbɨ ené owụ́ ꞌbɨ Natána. Natána nɨ ꞌbɨ ené owụ́ ꞌbɨ Dawídi. ");
INSERT INTO bdh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawídi nɨ ꞌbɨ ené owụ́ ꞌbɨ Zése. Zése nɨ ꞌbɨ ené owụ́ ꞌbɨ Óbede. Óbede nɨ ꞌbɨ ené owụ́ ꞌbɨ Bowáza. Bowáza nɨ ꞌbɨ ené owụ́ ꞌbɨ Solomóna. Solomóna nɨ ꞌbɨ ené owụ́ ꞌbɨ Nasóna. ");
INSERT INTO bdh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasóna nɨ ꞌbɨ ené owụ́ ꞌbɨ Aminadába. Aminadába nɨ ꞌbɨ ené owụ́ ꞌbɨ Adimíni nɨ ꞌbɨ ené owụ́ ꞌbɨ Aráni. Aráni nɨ ꞌbɨ ené owụ́ ꞌbɨ Ézorono. Ézorono nɨ ꞌbɨ ené owụ́ ꞌbɨ Peréze. Peréze nɨ ꞌbɨ ené owụ́ ꞌbɨ Zụ́da. ");
INSERT INTO bdh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zụ́da nɨ ꞌbɨ ené owụ́ ꞌbɨ Yakóbo. Yakóbo nɨ ꞌbɨ ené owụ́ ꞌbɨ Isáka. Isáka nɨ ꞌbɨ ené owụ́ ꞌbɨ Abarayáma. Abarayáma nɨ ꞌbɨ ené owụ́ ꞌbɨ Téra. Téra nɨ ꞌbɨ ené owụ́ ꞌbɨ Nówara. ");
INSERT INTO bdh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nówara nɨ ꞌbɨ ené owụ́ ꞌbɨ Serụ́ga. Serụ́ga nɨ ꞌbɨ ené owụ́ ꞌbɨ Réwu. Réwu nɨ ꞌbɨ ené owụ́ ꞌbɨ Pelége. Pelége nɨ ꞌbɨ ené owụ́ ꞌbɨ Ébere. Ébere nɨ ꞌbɨ ené owụ́ ꞌbɨ Séla. ");
INSERT INTO bdh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Séla nɨ ꞌbɨ ené owụ́ ꞌbɨ Kayinána. Kayinána nɨ ꞌbɨ ené owụ́ ꞌbɨ Arafakasáda. Arafakasáda nɨ ꞌbɨ ené owụ́ ꞌbɨ Séme. Séme nɨ ꞌbɨ ené owụ́ ꞌbɨ Nówa. Nówa nɨ ꞌbɨ ené owụ́ ꞌbɨ Laméke. ");
INSERT INTO bdh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laméke nɨ ꞌbɨ ené owụ́ ꞌbɨ Metụséla. Metụséla nɨ ꞌbɨ ené owụ́ ꞌbɨ Enóka. Enóka nɨ ꞌbɨ ené owụ́ ꞌbɨ Zérada. Zérada nɨ ꞌbɨ ené owụ́ ꞌbɨ Malále. Malále nɨ ꞌbɨ ené owụ́ ꞌbɨ Kenána. ");
INSERT INTO bdh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenána nɨ ꞌbɨ ené owụ́ ꞌbɨ Enósa. Enósa nɨ ꞌbɨ ené owụ́ ꞌbɨ Séte. Séte nɨ ꞌbɨ ené owụ́ ꞌbɨ Ádama. Ádama nɨ ꞌbɨ ené owụ́ ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sɨmɨ bɨ Yiwáni iꞌbí babatị́za go zɨ́ Yésụ ní, zɨ́ ꞌDówụ́ Lomo ꞌdúcu Yésụ, zɨ́a ị́nyịné gɨ sɨmɨ Yeredéne gɨ ore sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo ndéréne sɨmɨ súwú gbála, ");
INSERT INTO bdh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","zɨ́ ngére ꞌbɨ bɨcayi lomo e úzu wo sɨmɨ súwú íri ꞌdényé kɨ́ sị́lị́ cị́ gbre anu éyị́ mbá wá, zɨ́ ꞌbú kóo méngị wo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zɨ́ ngére ꞌbɨ bɨcayi lomo e úku ledre zɨ́a kɨ́dí, “Bɨ áyí tɨ́ Owụ́ ꞌbɨ Lomo ní, ídí óyólóꞌbó tutú ga bɨ bi ba káa do ambata zɨ́yị ánu a gɨ zɨ́ ꞌbú ke.” ");
INSERT INTO bdh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zɨ́ Yésụ úkulúgu ledre zɨ́ Satána kɨ́dí, “Nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘ꞌYịmaꞌdí utúasá ídí trịdrị lá dụụ́ gɨ zɨ́ éyị́ mɨánu wá, kúrú Lomo nɨ óto ꞌyị e ne zɨ́ye ídíye trịdrị.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Zɨ́ ngére ꞌbɨ bɨcayi lomo e kpá ndólo wo ékị́ kɨ́e do mongụ́ bi ekị́ekị́ ꞌdága ꞌdódo éyị́ ga bɨ do sogo káṇgá ba mbá zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Zɨ́a úku ledre zɨ́ Yésụ kɨ́dí, “Lúrú go, éyị́ ga bɨ za mbá áyị́ lúrú yée née, mááyí máa mị́ngị́ye. Togụ́ ili yá, mááyí óto yị́ị ngére doyé mbá. Iꞌbínɨ́ éyị́ ga gére née go mbá zɨ́ma, mááyí íꞌbí yée zɨ́ ꞌyị káa zɨ́ bɨ máíli ní. ");
INSERT INTO bdh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ili tɨ́ lá zɨ́yị óto sómụ́ ledre eyị́ romá zɨ́yị óto úndrumá.” ");
INSERT INTO bdh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yésụ ya zɨ́ Satána ní, “Ị́nyị gɨ cigíma íri, nɨ mɨékéne kɨ́dí, ‘Ídí óto úndru Ngére Lomo eyị́, zɨ́yị ndị́sịyị́ méngị dụụ́ ledre ené.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gɨ ore zɨ́ Satána ndólo wo ndéré ékị́ kɨ́e do mongụ́ ngbángbá ꞌDị́cị́ ꞌbɨ Lomo ꞌdága sɨmɨ Yerụsaléma do úku ledre zɨ́a kɨ́dí, “Togụ́ áyí tɨ́ Owụ́ ꞌbɨ Lomo maꞌdíi, léꞌbéútú mu bi ꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘Lomo nɨ kása maláyika ené e sáká yị́ị. ");
INSERT INTO bdh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nɨyí sáká yị́ị káa bɨ áyí útú útru sịndị́yị ro tutú e ke.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Zɨ́ Yésụ úkulúgu ledre zɨ́ Satána kɨ́dí, “Nɨ mɨékéne kɨ́dí, ‘Ndá úzu Ngére Lomo eyị́ wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sɨmɨ bɨ ngére ꞌbɨ bɨcayi lomo e uzu wo go má ní, zɨ́a aka ótoómo wo gɨ ro ngíti sịndị́ kadra. ");
INSERT INTO bdh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nda gɨ do kacɨ́ ledre ga gére ní, zɨ́ Yésụ ị́nyịné sɨmɨ rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo ndáꞌbalúgu roné sɨmɨ káṇgá bɨ Galiláya ní. Zɨ́ phanda ledre ga bɨ ndịsị méngị yée ní áṇgané sɨmɨ gara ore za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sɨmɨ ngíti sịndị́ kadra zɨ́a ólụ́ne sɨmɨ ꞌDị́cị́ Kótrụro e ndị́sịné ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e. Zɨ́ ꞌyị e ị́nyịyé mbá ndị́sị íꞌbí mbófo éyị́ zɨ́ Lomo gɨ ro ꞌdódo ledre ené. ");
INSERT INTO bdh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zɨ́a ndéréókpóne sɨmɨ Nazeréta kɨ́ꞌdí bɨ kóo ngboró ní. Nda sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro zɨ́a ndéréne sɨmɨ ꞌDị́cị́ Kótrụro káa zɨ́ bɨ lengbe ndịsị méngị a ní. Zɨ́a ị́nyị tóroné ꞌdága ólo mɨéké kúrú Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Zɨ́ye íꞌbíógụ bụ́kụ ꞌbɨ nébị Isáya zɨ́a, zɨ́a líkpí bi bɨ ndịsị ódro kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lomo iꞌbí ꞌDówụ́ne go zɨ́ma, gɨ zɨ́a oto máa go ndị́sị ꞌdódo bɨlámá ledre ené zɨ́ ꞌyị lerị́ e. Kasa máa kɨ́dí née Lomo née nɨ líkpíóyó ꞌyị ga bɨ mɨódó yée sɨmɨ káꞌdá ꞌbɨ lúyú ledre ní, ꞌyị ga bɨ komoyé lurú bi wá ní, née nɨ líkpí a gɨ ro zɨ́ye lúrú bi, kasa máa kpá gɨ ro ꞌyị ga bɨ ngíti géyị ꞌyị e ndịsịnɨ́ lúrú ꞌdófụ bi gɨ doyé ní, zɨ́ye ídíye kɨ́ ledreyé owóowó, ");
INSERT INTO bdh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kasa máa kpá gɨ ro úku ꞌdódo a zɨ́ ꞌyị e kɨ́dí, sịndị́ kadra bɨ gɨ ro zɨ́ Ngére Lomo yómo yée sɨmɨ a ní nɨ go gbóo.” ");
INSERT INTO bdh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sɨmɨ bɨ Yésụ oloonzó ledre ní, zɨ́a íꞌbílúgu bụ́kụ zɨ́ ꞌyị ꞌbɨ moko bɨ ore ní, zɨ́a ndáꞌba ndị́sịné bi. Zɨ́ komo ꞌyị ga bɨ sɨmɨ ꞌDị́cị́ Kótrụro ore ní ídíye mbá roa círii. ");
INSERT INTO bdh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zɨ́a ị́nyịné úku ledre zɨ́ye kɨ́dí, “Ledre bɨ gáa máólo née, ukunɨ́ kóo go ꞌdesị́, karaba ní, lúrúsé nda go cụ́ kɨ́ komosé.” ");
INSERT INTO bdh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Zɨ́ tara ꞌyị ga gére née ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ ledre ga bɨ uku yée ní. Zɨ́ye ndị́sịyé úkulóꞌbó ledre dongaráye kɨ́dí, “Áyi, owụ́ née ndiki ledre née kenée gɨ ꞌda, née ndaá ꞌbɨ ené wotị́ Yoséfa bɨ kɨ́ra ba wá?” ");
INSERT INTO bdh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ledre ga bɨ kóo úwúsé mándị́sị méngị yée sɨmɨ Kapáranawúma ní, utúasá mɨútúásá kacɨ́ komosé gɨ ro zɨ́ma méngị yée ona? Nɨ mɨékéne kɨ́dí, ‘ꞌYị mála idí yómo roné kí, zɨ́a nda yómo ngíti géyị ꞌyị e.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Zɨ́a kpá úku ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, otonɨ́ úndru nébị sɨmɨ káṇgá ené wá. ");
INSERT INTO bdh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ídísé ówo a kɨ́dí tụ́ꞌdụ́ umbu nɨyí kóo bo sɨmɨ káṇgá ꞌbɨ Isɨréle e sɨmɨ sịndị́ kadra ꞌbɨ nébị Ilíya. Iní oro kóo kɨ́ sɨmɨbi kị́éꞌdo kɨ́ éfé ịnyị doa kéṛị́ doné, zɨ́ ꞌbú kóo útúne do ꞌyị e kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lomo kasa ené kóo Ilíya ndéré sáká kará umbu ga gére née mbá wá, kasa kóo wo ndéré sáká dụụ́ kára umbu máa wo bɨ sɨmɨ gara bɨ Zarefáta sɨmɨ káṇgá bɨ Sidóna ní. ");
INSERT INTO bdh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ngíti géyị Isɨréle e nɨyí kóo bo sɨmɨ sịndị́ kadra ꞌbɨ nébị Ilísa kɨ́ sámá royé, sámá née ụkụ́ kóo gɨ royé wá, odụ ꞌyị bɨ ꞌdiꞌbioyónɨ́ sámá née gɨ roa ní dụụ́ Námana bɨ ꞌyị ꞌbɨ Sụ́rịya ní.” ");
INSERT INTO bdh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sɨmɨ bɨ ꞌyị ga bɨ sɨmɨ ꞌDị́cị́ Kótrụro ore uwúnɨ́ ledre bɨ Yésụ uku née kenée ní, zɨ́ye zíngi eyé geré mɨzíngi. ");
INSERT INTO bdh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Zɨ́ye ꞌdíꞌbi Yésụ lála wo ólụ́ógụ kɨ́e gɨ sɨmɨ gara sága, ndéré ékị́ kɨ́e do bi ekị́ekị́ ꞌdága née bi ekị́ekị́ bɨ oꞌbónɨ́ gara née doa ní gɨ ro zɨ́ye ị́trị́ wo gɨrí gɨ do bɨ zɨ́a útúónzó roné ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Zɨ́a ụ́cụ lị́lịné dongará tụ́ꞌdụ́ ꞌyị e do ndéréókpó ené gɨ zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zɨ́a ị́nyịné ndáꞌbalúgu roné sɨmɨ Kapáranawúma ngíti owụ́ gara sɨmɨ Galiláya, sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́a ndị́sịné ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ꞌYị ga bɨ kóo íri ndịsịnɨ́ úwú ꞌdódo ledre ené ní, zɨ́ tarayé ị́drị́ne mbá mɨị́drị́ gɨ zɨ́a ꞌdódo ledre ené nɨ kɨ́ rokoꞌbụ ꞌbɨ Lomo sɨmɨné. ");
INSERT INTO bdh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sɨmɨ sịndị́ kadra bɨ Yésụ nɨ ndị́sị ꞌdódo ledre sɨmɨ ꞌDị́cị́ Kótrụro née, ngíti oꞌdo bɨ kɨ́ bɨcayi lomo sɨmɨné ní nɨ ore, geré zɨ́a tónóne gbúrógbóne do Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yị́ị Yésụ, máówo yị́ị bú áyí mbigí Owụ́ ꞌbɨ Lomo gɨ sɨmɨ gara Nazeréta. Ógụ ba go geré gɨ ro úfuónzó zée?” ");
INSERT INTO bdh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Zɨ́ Yésụ ódroné zɨ́ bɨcayi lomo bɨ sɨmɨ oꞌdo née kɨ́ rokoꞌbụ kɨ́dí, “Ídí ndị́sị tí, ndá líkpí tarayị́ wá. Ólụ́ógụ gɨ sɨmɨ oꞌdo née mu.” Zɨ́ bɨcayi lomo kángba oꞌdo née do ị́drị́ónzó wo gbụ bi do komo ꞌyị ga bɨ ore née mbá, do ólụ́ógụné gɨ sɨmɨ a, oto uṇgú ro oꞌdo née mbá wá. ");
INSERT INTO bdh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Zɨ́ tara ꞌyị e ị́drị́ne gɨ zɨ́ ledre née mbá mɨị́drị́ zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Bɨ káa lárá ledre bɨ káa be ꞌdi, zɨ́ oꞌdo ba ndị́sị ódroné kɨ́ cóngó ro kpá kɨ́ mongụ́ rokoꞌbụné ní? Uku ledre zɨ́ bɨcayi lomo e, zɨ́ye úwú kúrúa, zɨ́ye ólụ́ógụyé gɨ sɨmɨ oꞌdo ba tɨ́ maꞌdíi.” ");
INSERT INTO bdh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Zɨ́ phanda Yésụ áṇgané do bi ga gére née kɨ́rɨ́ née za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nda go gɨ do kacɨ́ ꞌdódo ledre, zɨ́ Yésụ ólụ́ ógụyé gɨ sɨmɨ ꞌDị́cị́ Kótrụro kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéréye ꞌbe ꞌbɨ Simúna Pétero. Ábuwá towụ́ Simúna maꞌdáa roa emengụ́, nɨ kɨ́ drụ́ roné. Zɨ́ ꞌyị ga bɨ ꞌbe ore ní ndúꞌyú Yésụ, idí yómo wo. ");
INSERT INTO bdh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zɨ́ Yésụ ndéré tóroné cigí a, zɨ́a úku ledre zɨ́ bɨsinyí drụ́ bɨ ro kára née kɨ́dí, “Ólụ́ógụ gɨ sɨmɨ a mu.” Geré zɨ́ ro kára née zázáne, zɨ́a ị́nyịné ndéréne méngị éyị́ mɨánu zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nda go kɨ́ tagá ndụlụ, zɨ́ ꞌyị e ndị́sị ꞌdíꞌbiógụ ꞌyị eyé ga bɨ kɨ́ ndíyá royé ní ógụ kɨ́ye zɨ́ Yésụ gɨ ro zɨ́a yómo yée. ");
INSERT INTO bdh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ngíti géyị ꞌyị ga gére née nɨyí ꞌbɨ eyé kɨ́ bɨcayi lomo e sɨmɨyé. Gɨ zɨ́ rokoꞌbụ Yésụ, zɨ́ye gbúgbuógụyé gɨ sɨmɨ ꞌyị ga gére ní kɨ́ ndị́sị gbúrógbóye kɨ́dí, “Áyí Owụ́ ꞌbɨ Lomo.” Zɨ́ Yésụ ụ́cụómo yée kɨ́ ódro gɨ zɨ́a owonɨ́ wo bú nɨ Kɨ́résịto wo bɨ Lomo kasaogụ káa do ꞌyị yómo ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nda káa zɨ́ kɨ́lóndó a née kɨ́ phịyị́ zɨ́ Yésụ ị́nyị ndéré ené do bi bɨ ꞌyị e ndanɨ́ doa wá ní. Zɨ́ ꞌyị e ndị́sịyé gámásóꞌdo wo. Sɨmɨ bɨ ndikinɨ́ wo ní, zɨ́ye úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, ilizé ezé lolụ zɨ́yị ndéréómo zée wá.” ");
INSERT INTO bdh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Zɨ́a úkulúgu ledre zɨ́ ꞌyị ga gére née kɨ́dí, “Ndásé lá dụụ́ se ꞌyị ga bɨ Babá kasa máa ꞌdódo ledre ené zɨ́ye ní wá. Máíli kpá ꞌdódo bɨlámá ledre bɨ gɨ ro ꞌbe ꞌbɨ Lomo ní zɨ́ ngíti géyị ꞌyị e. Kasaogụ máa gɨ ro zɨ́ma méngị a kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gɨ do kacɨ́ ledre née, zɨ́ Yésụ kpá fú ndị́sị kɨ́ gámáne kɨ́ ꞌdodo ledre ꞌbɨ Lomo zɨ́ ꞌyị e sɨmɨ ꞌDị́cị́ Kótrụro ga bɨ sɨmɨ Yụdáya ore ní za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kadra kị́éꞌdo zɨ́ Yésụ ndéré tóroné do gbúṛóngó mongụ́ mɨkavu bɨ Galiláya ní, zɨ́ tụ́ꞌdụ́ ꞌyị e yóko royé cigí a zɨ́a ndị́sịné ꞌdódo ledre ꞌbɨ Lomo zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Zɨ́a óyó komoné do lúrúndíki kuṛúngba e gbre mị́ngị́ye odóngeṛịnɨ́ go kóꞌdụ́ gbúṛóngó kenée, nɨyí go ndị́sị lúgu mbírá eyé e. ");
INSERT INTO bdh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zɨ́a ndéré ékị́ne sɨmɨ ngúru kuṛúngba, née wo bɨ ꞌbɨ Simúna ní. Zɨ́a úku ledre kɨ́dí, “Ị́trị́ ꞌdóso aka kuṛúngba maꞌdáa mɨꞌdí sɨmɨ iní íri.” Sɨmɨ bɨ Simúna ịtrị́ ní, zɨ́ Yésụ ndị́sị yéme roné bi ndị́sị ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sɨmɨ bɨ ꞌdodo asá ledre ní, zɨ́a úku ledre zɨ́ Simúna kɨ́dí, “Ị́trị́ tátá mu sɨmɨ yana iní gɨ ro zɨ́yị ónzó mbírá.” ");
INSERT INTO bdh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simúna ya zɨ́a ní, “Mongụ́ ꞌyị, icizé rozé kɨ́ mbírá go bi ndre ba, kémbị́ éyị́ ndaá. Nda lá kacɨ́ kúrúyị, mááyí ónzó a.” ");
INSERT INTO bdh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sɨmɨ bɨ onzónɨ́ mbírá ní, zɨ́ tụ́ꞌdụ́ kénzé e útúye sɨmɨ a. Gɨ zɨ́a bɨ ofụnɨ́ nda go ní, zɨ́ mbírá tónóne lófoné. ");
INSERT INTO bdh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Zɨ́ Simúna e tónó kéwu lafúye ga bɨ sɨmɨ ngíti kuṛúngba ní, idínɨ́ ógụ sáká yée. Zɨ́ lafúye ga gére née ógụyé do tónóye lála mbírá kɨ́ kénzé ga gére née sɨmɨ kuṛúngba. Zɨ́ kénzé e ídíye sɨmɨ kuṛúngba ga bɨ gbre née cị́ꞌdị́. Nda gɨ zɨ́ mɨówó ye, kuṛúngba ayí nda go ólụ́ sị́ iní. ");
INSERT INTO bdh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sɨmɨ bɨ Simúna Pétero lurú ledre née kenée ní, zɨ́a útúne sị́ sịndị́ Yésụ bi, ṇgúṇgú roné do úku ledre zɨ́ Yésụ kɨ́dí, “Ngére, mááyí ꞌyị lúyú ledre, máútúásá ídí gbóo kɨ́yị wá, ídí ị́nyị gɨ cigíma ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Zɨ́ tara Simúna Pétero kɨ́ lafúne ga gére née ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ tụ́ꞌdụ́ kénzé ga bɨ ꞌdiꞌbinɨ́ yée kenée ní. ");
INSERT INTO bdh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ngíti géyị lafú Simúna ga bɨ Yakóbo e kɨ́ Yiwáni wotị́ Zebedị́ya ní, zɨ́ tarayé ị́drị́ne kpá mbá mɨị́drị́ gɨ zɨ́ ledre máa née. Gɨ zɨ́ ledre bɨ gáa Simúna uku ní, zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Simúna ndá éré ngịrị wá. Tónóne cakaba ndéréne ꞌdáꞌdá, áyí ídí go ꞌyị ꞌdíꞌbiógụ ꞌyị e zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Geré née ní, zɨ́ Simúna ị́nyịyé kɨ́ lafúne ga gére née ódóóto kuṛúngba eyé e kóꞌdụ́ gbúṛóngó ore, yóó, do útúye do kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sɨmɨ ngíti sịndị́ kadra sɨmɨ ngíti owụ́ gara, zɨ́ ngíti oꞌdo kɨ́ sámá roné ógụné zɨ́ Yésụ. Zɨ́a útúne kóꞌdụ́ Yésụ bi ṇgúṇgú roné zɨ́a kɨ́dí, “Ngére, togụ́ utúasá kacɨ́ komoyị́ mɨútúásá, ídí ꞌdíꞌbióyó sámá ba gɨ romá gɨ ro zɨ́ romá ídíne drá.” ");
INSERT INTO bdh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zɨ́ Yésụ óto sị́lị́ne ro oꞌdo née do úku ledre zɨ́ oꞌdo née kɨ́dí, “Máṇgúṇgu go, royị́ idí mu ídí drá.” Tɨ́ maꞌdíi, geré zɨ́ sámá ụ́kụ́ne gɨ ro oꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Ndá aka ꞌdíꞌbi ledre née tarayị́ wá. Ídí aka ndéré zɨ́ ꞌyị ꞌdáná éyị́ kí. Zɨ́yị íꞌbí tákpásị́lị́ zɨ́ Lomo káa zɨ́ bɨ Mụ́sa eké ledre a ꞌyị e idínɨ́ ndị́sị méngị a kenée sɨmɨ bɨ togụ́ bɨlámá ledre mengị roné go zɨ́ye ní. Gɨ ro do ówo a mbá kɨ́dí éyị́ mengị roné go.” ");
INSERT INTO bdh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Abú kenée ndotó, ꞌdesị́ phanda ledre bɨ Yésụ mengị née, aṇga go do bi ga bɨ kɨ́rɨ́ née née za mbá. Zɨ́ tụ́ꞌdụ́ ꞌyị e nda ndị́sị ógụyé úwú ledre ga bɨ nɨ ndị́sị ꞌdódo yée ní. Zɨ́a kpá ndị́sịné kɨ́ yómo ngíti géyị gɨ do ndíyá eyé e. ");
INSERT INTO bdh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sɨmɨ ledre ga gére née mbá, kɨ́ꞌdí bɨ Yésụ ili go íni ini zɨ́ Lomo ní, zɨ́a ndéréne do bi bɨ ꞌyị e ndanɨ́ doa wá ní, zɨ́a íni ini zɨ́ Lomo íri. ");
INSERT INTO bdh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sɨmɨ ngíti sị́lị́ kpị́, Yésụ nɨ go ndị́sị ꞌdódo ledre ꞌbɨ Lomo zɨ́ ꞌyị e. Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ ga bɨ ꞌbɨ Lomo ní nɨyí kóo mɨndị́sịyé gbóo kɨ́rɨ́ née. Ngíti géyị ogụnɨ́ gɨ sɨmɨ gara ga bɨ ꞌbɨ Galiláya mɨngúngúcua ní, ngíti géyị ꞌbɨ eyé gɨ sɨmɨ káṇgá bɨ Yụdáya kpá kɨ́ Yerụsaléma ní. Zɨ́ Ngére Lomo íꞌbí rokoꞌbụ zɨ́ Yésụ, zɨ́a ndị́sịné ꞌdíꞌbióyó ndíyá kɨ́e gɨ ro ꞌyị e ore. ");
INSERT INTO bdh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ꞌYị e nɨyí lúrú bi ní, ịmbị́ogụnɨ́ ngíti oꞌdo go do gbagbara nɨ kɨ́ umbu sịndị́ gamá gɨ zɨ́a wá. Ilinɨ́ kóo ólụ́ kɨ́e ndéré óto wo kóꞌdụ́ Yésụ ꞌdị́cị́ íri. ");
INSERT INTO bdh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sɨmɨ bɨ bi ólụ́ kɨ́ oꞌdo née zɨ́ Yésụ gɨ ꞌdí tara mbotụ ndaá gɨ zɨ́ tụ́ꞌdụ́ ꞌyị e ní, zɨ́ye ékị́ye kɨ́e do ꞌdị́cị́ ꞌdága. Zɨ́ye líkpí phụ́trụ bi mbị́ kɨ́ꞌdí bɨ Yésụ nɨ ore ní, zɨ́ye ị́mbị́ ésị oꞌdo née nyé kɨ́ gbagbara née gɨ doa zɨ́a íri. ");
INSERT INTO bdh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sɨmɨ bɨ Yésụ owo kɨ́dí yaꞌdá ga gére née ṇguṇgunɨ́ ledrené go ní, zɨ́a úku ledre zɨ́ oꞌdo bɨ ịmbị́ogụnɨ́ wo née kɨ́dí, “Lúndu ꞌbɨ ené e, máótoómo lúyú ledre eyị́ go.” ");
INSERT INTO bdh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Gɨ zɨ́ ledre bɨ Yésụ uku née ní, geré zɨ́ Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ ga gére née tónóye ódroyé dengbị́ye kɨ́dí, “Oꞌdo máa née ꞌbe ené náambi bɨ nɨ ndị́sị úku bɨsinyí ledre kenée née? Lomo nɨ dụụ́ ne ꞌyị ótoómo lúyú ledre zɨ́ ꞌyị e.” ");
INSERT INTO bdh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yésụ owo sómụ́ ledre eyé née go zɨ́a ndúꞌyú yée kɨ́dí, “Éyị́ bɨ ndị́sịsé sómụ́ ledre do mɨmbéꞌdesé gɨ zɨ́a kenée ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ledre máa wo be ꞌdi nɨ gáa née gbóo zɨ́ma úku a, máótoómo lúyú ledre eyị́ go, togụ́ kenée wá, máídí úku a máyá ị́nyịógụ mu ꞌdíꞌbi sáka eyị́ zɨ́yị ndáꞌbayị́ ꞌbe? ");
INSERT INTO bdh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Máíli úku a zɨ́se, máa bɨ Lomo kasaogụ máa káa do ꞌyịmaꞌdí ní, mááyí kɨ́ rokoꞌbụ zɨ́ma do sogo káṇgá ona gɨ ro ótoómo lúyú ledre ꞌbɨ ꞌyị e kɨ́e.” Zɨ́a ị́nyịné úku ledre zɨ́ oꞌdo bɨ kɨ́ umbu sịndị́ne née kɨ́dí, “ị́nyịógụ mu, ꞌdíꞌbi sáká eyị́ mu zɨ́yị ndáꞌbayị́ ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Geré née ní, kɨ́ráwu zɨ́a ị́nyịógụné ꞌdága tɨ́ do komo ꞌyị ga gére née mbá ꞌdíꞌbi sáka ené do ndáꞌbané ꞌbe kɨ́ mongụ́ rokinyi kɨ́ ndị́sị íꞌbílúgu mbófo éyị́ zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Zɨ́ ledre née ówóne komo tụ́ꞌdụ́ ꞌyị ga bɨ ore née mbá zɨ́ye ídíye kɨ́ mongụ́ ngịrị royé do ndị́sịyé íꞌbílúgu mbófo éyị́ zɨ́ Lomo kɨ́dí, “Éyị́ bɨ mengị roné karaba ba, ꞌyịmaꞌdí utúasá méngị a wá.” ");
INSERT INTO bdh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Zɨ́ Yésụ ólụ́ógụné gɨ ore ndéré ndíki Lévị kɨ́ ndị́sị tara mákɨtabu ené ꞌbɨ ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e. Zɨ́ Yésụ ndólo wo kɨ́dí, “Lévị, áyí go ꞌyị ꞌbɨ moko amá, ógụ mu zɨ́ze ndéréze kéyị.” ");
INSERT INTO bdh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lévị kala wá, zɨ́a ótoómo éyị́ ga bɨ ꞌbɨ moko née yóó do útúne lódụ́ kacɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nda sɨmɨ ngíti sị́lị́, zɨ́ Lévị yéme mongụ́ éyị́ mɨánu kɨ́ ịrị Yésụ. Zɨ́ Lévị maꞌdáa ndólo tụ́ꞌdụ́ lafúne ga bɨ ndịsịnɨ́ ꞌdóꞌdụ́ ụsórụ kéye íꞌbí a zɨ́ akúma ní, nda kpá kɨ́ ngíti géyị ꞌyị e gɨ ro zɨ́ye ánu éyị́ mɨánu máa née kɨ́ Yésụ e. ");
INSERT INTO bdh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sɨmɨ bɨ Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ e lurúnɨ́ Yésụ kɨ́ ánu éyị́ kɨ́ ꞌyị ga gére née kenée ní, zɨ́a sínyí ené royé mɨsínyí. Zɨ́ye ndị́sịyé úku mɨngụ́ngụ́rụ́ ledre ro Yésụ. Zɨ́ye úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ga kɨ́dí, “Éyị́ bɨ mongụ́ ꞌyị esé née ndịsị ánu éyị́ gɨ roa kɨ́ ꞌyị lúyú ledre e kpá kɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ e káa zɨ́ née ní ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Máúku zɨ́se, ꞌyị bɨ ndíyá ndaá roa wá ní, nderé ené zɨ́ dokotóro wá, ꞌyị ndíyá ndịsị ndéréne gɨ ro do yómo née. ");
INSERT INTO bdh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Máógụ amá gɨ ro ꞌyị ga bɨ ya yée nɨyí eyé bɨlámáye ní wá. Máógụ gɨ ro ꞌyị lúyú ledre e zɨ́ye óyólóꞌbó mɨmbéꞌdeyé gɨ ro zɨ́ye ómoyé.” ");
INSERT INTO bdh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nda gɨ ore, zɨ́ ngíti géyị ꞌyị e gɨ dongará ꞌyị ga gére née ndúꞌyú Yésụ kɨ́dí, “ꞌYị lódụ́ kacɨ́ Yiwáni ꞌyị íꞌbí babatị́za ndịsịnɨ́ órụ́ tarayé zɨ́ye kpá ndị́sị íni ini zɨ́ Lomo, ꞌyị ꞌbɨ Farụsáyo e ndịsịnɨ́ méngị a kpá kenée. Sara ꞌyị eyị́ e orụ́nɨ́ ꞌbɨ eyé tarayé wá gɨ zɨ́ ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Zɨ́ Yésụ úkulúgu ledre kɨ́dí, “Sɨmɨ sómụ́ ledre esé ní, ꞌyị ga bɨ ndoloogụnɨ́ yée sɨmɨ ayímbi ꞌbɨ ófụ́ roꞌyị ní ndanɨ́ ánu éyị́ wá tɨ́ bɨ mɨkánda adrúgu nɨ bo kɨ́ye ore ní? ");
INSERT INTO bdh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sịndị́ kadra nɨ ógụ wo bɨ nɨyí ꞌdíꞌbióyó wo gɨ dongará ꞌyị ené ga gére ní, zɨ́ye nda ndị́sịyé kɨ́ ꞌbú.” ");
INSERT INTO bdh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zɨ́a kpá úku ngíti muruwayi kɨ́dí, “ꞌYị nda ị́cị́ tóko tara mɨkánda bongó ro kuṛú a wá. Togụ́ mengị kenée yá, mɨkánda bongó née nɨ lála lófo kuṛú a née zɨ́ uṇgú a nda ídíne mongụ́ne, bi ị́cị́ a ndaá lolụ wá. ");
INSERT INTO bdh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kpá kenée, togụ́ kára ili lótó leꞌyị́ ené yá, nda lótó a sɨmɨ sorụ́ ndoko wá. Gɨ zɨ́a sɨmɨ bɨ leꞌyị́ née nɨ ụ́ꞌbụ ní, zɨ́ sorụ́ ndoko née ndóko ené, zɨ́ leꞌyị́ sínyíne mbá bi. ");
INSERT INTO bdh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bɨlámá a, idínɨ́ lótó leꞌyị́ tɨ́ sɨmɨ mɨkánda ndoko. ");
INSERT INTO bdh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ngíti géyị ꞌyị e ilinɨ́ éwé yị́ eyé tɨ́ fú lá kuṛú leꞌyị́. Gɨ zɨ́ kéyị née ilinɨ́ eyé mɨkánda leꞌyị́ kóṛó wá kɨ́dí ndumu eme yị́ ené ne.” ");
INSERT INTO bdh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kadra kị́éꞌdo sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ ị́nyịné kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéré ꞌdécị bi kpụrụ́ gɨ sɨmɨ yáká, sɨmɨ bɨ kére nɨ aka lá ngorụné ní. Zɨ́ ꞌyị lódụ́ kacɨ́ga ndị́sị lófo ngorụ kére ga gére née kɨ́ ánu a. ");
INSERT INTO bdh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Zɨ́ Farụsáyo e ị́nyịyé úku ledre kɨ́dí, “Áyi, tɨ́ bɨ ówosé bú karaba Sị́lị́ ꞌbɨ ꞌDówụ́ro ní, ndị́sịsé nda méngị moko sɨmɨ a gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zɨ́ Yésụ úkulúgu ledre zɨ́ Farụsáyo ga gére née kɨ́dí, “Ólosé esé ledre bɨ kóo Dawídi mengị sɨmɨ bɨ kóo ꞌbú mengị yée kɨ́ ꞌyị ené e ní wá? ");
INSERT INTO bdh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kadra kị́éꞌdo ꞌbú mengị kóo Dawídi kɨ́ ꞌyị ené go kɨ́ngaya. Zɨ́a ndéré ólụ́ne sɨmɨ ꞌdị́cị́ ꞌbɨ Lomo, zɨ́a ꞌdíꞌbi ambata ga kóo ore, ꞌyị ꞌdáná éyị́ zɨ́ Lomo nɨyí ánu a dụụ́ ye ní zɨ́a ánu a. Zɨ́a kpá íꞌbí a zɨ́ ꞌyị ené ga bɨ kóo nɨyí kéye ní.” ");
INSERT INTO bdh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zɨ́ Yésụ úku odụ ledre yaá, “Máa Owụ́ ꞌbɨ ꞌYịmaꞌdí mááyí Ngére do Sị́lị́ ꞌbɨ ꞌDówụ́ro.” ");
INSERT INTO bdh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sɨmɨ ngíti sịndị́ kadra kpị́ sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ ndéré ólụ́ne ꞌDị́cị́ Kótrụro ndị́sị ꞌdódo ledre. Ngíti oꞌdo nɨ kpá ore sị́lị́a ꞌbɨ anú ngụrogụ́ mɨngụ́rógụ́ mengị moko wá. ");
INSERT INTO bdh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ngíti géyị Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ e nɨyí kóo ore ndị́sị gámásóꞌdo mɨsiꞌdi bɨ togụ́ Yésụ luyú ledre go yá, zɨ́ye ꞌdíꞌbi wo. Gɨ zɨ́ kéyị née ní, zɨ́ye ndị́sịyé sémbe wo mɨsémbe kɨ́dí togụ́ nɨ yéme sị́lị́ oꞌdo née karaba sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro yá. ");
INSERT INTO bdh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yésụ owo sómụ́ ledre bɨ nɨyí kɨ́e née bú, zɨ́a ị́nyịné úku ledre zɨ́ oꞌdo bɨ kɨ́ mɨngụ́rógụ́ sị́lị́ne née kɨ́dí, “Ị́nyịógụ mu tóro do nyárá bi kɨ́ra gɨ do bɨ zɨ́ ꞌyị ga ba mbá lúrú yị́ị.” Zɨ́ oꞌdo née tɨ́ ị́nyị tóroné do komo ꞌyị e ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Zɨ́ Yésụ úkulúgu ledre zɨ́ ꞌyị ga gére née kɨ́dí, “Mándúꞌyú aka sée, ledre máa wo be ꞌdi emene do méngị a sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, méngị bɨsinyí ledre togụ́ mbú méngị bɨlámá ledre bɨ yómo ꞌyị togụ́ mbú ótoómo ꞌyị zɨ́a úyuné?” ");
INSERT INTO bdh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zɨ́a lúrú bi kere gbaá ꞌyị ị́tị ndaá. Zɨ́a úku ledre zɨ́ oꞌdo née kɨ́dí, “ꞌDózo sị́lị́yị mu.” Nɨ ꞌdózo sị́lị́ne káa ní, sị́lị́ a nɨ go bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Zɨ́ ledre née óto Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ e kɨ́ mongụ́ mɨmbéꞌde késị́ ro Yésụ, zɨ́ye ndị́sị ódroyé dengbị́ye gámásóꞌdo mɨsiꞌdi bɨ yée nɨyí ꞌdíꞌbi Yésụ úfu wo doa. ");
INSERT INTO bdh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sɨmɨ ngíti sị́lị́ gɨ do kacɨ́ ledre née, zɨ́ Yésụ ndéré ékị́ne do mongụ́ landa, ndị́sịné íni ini zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zɨ́ bi áráne nda go kɨ́ phịyị́, zɨ́a ndólo ꞌyị lódụ́ kacɨ́ne e. Sɨmɨ bɨ ogụnɨ́ ní, zɨ́a gélé ngíti géyị sokó doa gbre (12) zɨ́a úku ledre kɨ́dí, “Yée ga ba nɨyí go ꞌyịmɨkása amá e.” Nɨyí, ");
INSERT INTO bdh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simúna, bɨ Yésụ ịfị́ ngíti ịrịa Pétero ní, nɨyí kɨ́ owụ́ ꞌbɨ mbágáne Andiríya nda Yakóbo, Yiwáni, Phị́lịpo, Batilimáyo, ");
INSERT INTO bdh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matáyo, Tóma, Yakóbo wotị́ Alafáyo, Simúna bɨ ndịsịnɨ́ ndólo wo Owụ́rará ní. Gɨ zɨ́a mɨmbéꞌdea ndịsị ésị́ gɨ ro ꞌyị ené e. ");
INSERT INTO bdh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yụ́da wotị́ Yakóbo, nda Yụ́da Keriyóta bɨ iꞌbí ngbángá Yésụ ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zɨ́a ndítíógụné kɨ́ ꞌyị ené ga gére née gɨ do bi ekị́ekị́ gɨrí ndéré tóroné kenée, zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị yóko royé cigí a. Zɨ́ ꞌyị lódụ́ kacɨ́ga kɨ́ tụ́ꞌdụ́ ngíti géyị ꞌyị e gɨ sɨmɨ Yụdáya mbá, yée ga bɨ gɨ sɨmɨ Yerụsaléma ní, nda kɨ́ ngíti géyị ga bɨ ogụnɨ́ gɨ gbála gɨ sɨmɨ Táyire kɨ́ Sidóna ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ngíti géyị ꞌyị ga gére née ogụnɨ́ ꞌbɨ eyé úwú ledre ga bɨ Yésụ maꞌdáa ndịsị ꞌdódo yée ní. Ngíti ogụnɨ́ ꞌbɨ eyé kɨ́ ndíyá eyé e gɨ ro zɨ́a yómo yée. Yée ga bɨ kɨ́ bɨcayi lomo e sɨmɨyé ní gɨ ro zɨ́a lágaóyó yée ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ꞌYị ga bɨ kɨ́ ndíyá royé ní mbá, zɨ́ye ndị́sịyé trị́trị́ royé gɨ zɨ́a ofụnɨ́ go gɨ ro zɨ́ye óto sị́lị́ye ro Yésụ gɨ ro zɨ́ ndíyá eyé ụ́kụ́ne mbá gɨ zɨ́a owonɨ́ go nɨ kɨ́ rokoꞌbụ ꞌbɨ yómo ꞌyị e zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zɨ́a óyó komoné lúrú ꞌyị lódụ́ kacɨ́ne ga gére ní, zɨ́a úku ledre zɨ́ye kɨ́dí, “Sée ꞌyị lerị́ e, Lomo iꞌbí úndru go zɨ́se gɨ zɨ́a ásé go ꞌyị ꞌbɨ ꞌBe ꞌbɨ ené e. ");
INSERT INTO bdh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sée ga bɨ kɨ́ ꞌbú rosé ní, Lomo iꞌbí úndru go zɨ́se gɨ zɨ́a nɨ karanée íꞌbí éyị́ mɨánu bɨ ụkụ́ wá ní zɨ́se. Sée ga bɨ ásé cakaba ndị́sịsé íni ini ní, Lomo iꞌbí úndru go zɨ́se ásé karanée ídí kɨ́ mongụ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Togụ́ ꞌyị e ndịsịnɨ́ sógó sée, zɨ́ye ꞌdíꞌbióyó sée gɨ dongaráye ꞌdáꞌba kpá kɨ́ úkucáyi sée gɨ zɨ́a bɨ ṇgúṇgusé ledremá máa bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí ní, Lomo nɨ íꞌbí úndru zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Abú mengịnɨ́ sée bɨsinyíne kenée ndotó, ídísé ídí kɨ́ rokinyi gɨ zɨ́a Lomo nɨ karanée ꞌdíꞌbióto sée ꞌbe ꞌbɨ ené. ꞌYị ga gére née ꞌyị eyé e ndịsịnɨ́ kóo ꞌdóꞌdo nébị ga kóna ní kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sée ga bɨ ásé kɨ́ rokinyi gɨ zɨ́a ásé kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́se ní, odụ a nɨ nda karanée ídí zɨ́se lerị́ sɨmɨ bɨ ngárá éyị́ ga gére née ndanɨ́ lolụ zɨ́se wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sée ga bɨ ásé bɨlámáse ndị́sịsé ánu dụụ́ bɨlámá éyị́ e ní, ásé karanée ídí do lerị́ éyị́ mɨánu. Kpá kenée, sée ga bɨ ásé sɨmɨ rokinyi ní, ásé karanée ídí kɨ́ mongụ́ lerị́. ");
INSERT INTO bdh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Sée ga bɨ ꞌyị e mbá ndịsịnɨ́ mbófo sée ní, ásé karanée ídí kɨ́ mongụ́ lerị́. ꞌYị ga gére née, ꞌyị eyé e ndịsịnɨ́ kóo mbófo nébị ꞌyị ṛanga e kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Zɨ́ Yésụ kpá úku ngíti ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, ídísé óto ꞌbú ezeokóse, zɨ́se ndị́sịsé méngị bɨlámá ledre zɨ́ ꞌyị ga bɨ otonɨ́ ꞌbúse wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ndásé méngị lúgu bɨsinyí ledre zɨ́ ꞌyị ga bɨ mengịnɨ́ sée bɨsinyíne ní wá, ídísé íni ini zɨ́ Lomo gɨ royé. ");
INSERT INTO bdh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Togụ́ ꞌyị ongbo komoyị́ bɨ gɨ ꞌdí keṛị́ ní yá, ídí óyólóꞌbó wo bɨ gɨ ꞌdí keṛị́ ní zɨ́a óngbo a. Togụ́ ꞌyị ngaka éyị́ eyị́ yá, ndá lálalúgu a gɨ zɨ́a wá. ");
INSERT INTO bdh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Togụ́ ꞌyị ombo éyị́ gɨ zɨ́yị, ídí íꞌbí a zɨ́a, wo bɨ saká éyị́ gɨ zɨ́yị ní togụ́ ili íꞌbílúgu a wá, ndá lolụ ndéré ndúꞌyú wo gɨ roa wá. ");
INSERT INTO bdh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Éyị́ bɨ íli zɨ́ ꞌyị e méngị a zɨ́yị ní, ídí méngị kpá wo zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Togụ́ ótosé dụụ́ ꞌbú ꞌyị ga bɨ ndịsịnɨ́ óto ꞌbúse ní, Lomo mengị ené bɨlámá ledre zɨ́se wá. ꞌYị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní, ndịsịnɨ́ óto dụụ́ ꞌbú ꞌyị ga bɨ ndịsịnɨ́ óto ꞌbúye ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Togụ́ ndị́sịsé méngị bɨlámá ledre dụụ́ zɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị bɨlámá ledre zɨ́se ní yá, Lomo mengị ené bɨlámá ledre zɨ́se wá. ꞌYị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní, ndịsịnɨ́ méngị bɨlámá ledre dụụ́ zɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị bɨlámá ledre zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Togụ́ íꞌbí éyị́ lá dụụ́ zɨ́ ꞌyị bɨ nɨ íꞌbí éyị́ zɨ́yị ní yá, Lomo mengị ené bɨlámá ledre zɨ́yị wá. ꞌYị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní, ndịsịnɨ́ íꞌbí éyị́ dụụ́ zɨ́ ꞌyị ga bɨ nɨyí íꞌbí éyị́ zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ídísé óto ꞌbú ezeokóse e zɨ́se ndị́sịsé méngị bɨlámá ledre zɨ́ye. Togụ́ íꞌbísé éyị́ go zɨ́ye yá, ndásé lolụ sómụ́ ledre a wá. Lomo nɨ méngị mongụ́ bɨlámá ledre zɨ́se kacɨ́ a gɨ zɨ́a ásé go mbigí owụ́ ga bɨ ꞌbɨ Lomo bɨ rokoꞌbụ a ofụ go ní. Ndịsị lengbe méngị bɨlámá ledre zɨ́ bɨsinyí ꞌyị e kpá kɨ́ bɨlámáye e. ");
INSERT INTO bdh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lerị́ lafúse idí méngị sée kpá káa zɨ́ bɨ lerị́se ndịsị méngị ꞌBụsé Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ndásé ꞌdécị ngbanga ꞌyị wá káa bɨ Lomo nɨ kpá ꞌdécị ngbangasé. Ndásé úku sínyi ledre gɨ do bi ꞌyị wá, káa bɨ ásé kpá ídí zɨ́ Lomo bɨsinyí ꞌyị e. Ídísé ótoómo lúyú ledre ꞌbɨ lafúse e gɨ ro zɨ́ Lomo kpá ótoómo lúyú ledre esé. ");
INSERT INTO bdh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ídísé íꞌbí éyị́ zɨ́ ꞌyị e gɨ ro zɨ́ Lomo kpá íꞌbí éyị́ zɨ́se. Togụ́ méngịsé go kenée, Lomo nɨ méngị bɨlámá ledre zɨ́se rómo wo bɨ méngịsé née kɨ́e. Bɨlámá ledre ga bɨ ndị́sịsé méngị yée née, Lomo nɨ méngị lúgu a zɨ́se kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zɨ́a kpá úku muruwayi máa wo ba kɨ́dí, “Sɨmɨ sómụ́ ledre esé ní, ꞌyị komo mɨꞌdụ́tụ nɨ ꞌdíꞌbi sị́lị́ ezené ꞌyị komo mɨꞌdụ́tụ lála wo ndéré kɨ́e? Togụ́ mengị kenée, nɨ lála ezené née zɨ́ye útú eyé gbrengárá sɨmɨ gu. ");
INSERT INTO bdh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ꞌYị bɨ ndịsịnɨ́ ꞌdódo ledre zɨ́a ní, romo ené do ꞌyị ꞌdódo ledre zɨ́ne wá. Kɨ́ꞌdí bɨ owoyeme nda ledre go ní, zɨ́a ndị́sịné méngị té ledre ga bɨ ꞌyị ꞌdódo ledre ené ndịsị méngị yée ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndá ndị́sị óto komoyị́ lá dụụ́ ro owụ́ ledre bɨ ngíti ꞌyị mengị luyú go, zɨ́yị ndị́sịyị́ úku dụụ́ ledre a ní wá. Ídí óto komoyị́ ro mongụ́ lúyú ledre bɨ ndị́sị lúyú a ngárá ówo wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bɨ áyí kpá ꞌyị lúyú ledre ní, áyí úku lárá ledre káa be ꞌdi zɨ́ ngíti ꞌyị idí ótoómo kɨ́ lúyú ledre. Yị́ị ꞌyị mani ba ídí ótoómo ꞌbɨ eyị́ lúyú ledre kí, áyị́ nda fú úku ledre zɨ́ ꞌyị idí ótoómo kɨ́ lúyú ledre.” ");
INSERT INTO bdh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Née sị́ ledre bɨ bɨlámá kágá ndịsị ánáógụ bɨlámá mɨánáne gɨ zɨ́a ní. Bɨsinyí kágá ndịsị ánáógụ ꞌbɨ ené kpá té bɨsinyí mɨánáne. ");
INSERT INTO bdh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ndịsịnɨ́ ówoyéme kágá e mbá dụụ́ gɨ ro mɨánáye. Utúasánɨ́ líkpí mánga gɨ komo ngéyé wá. Togụ́ goófo yá, likpínɨ́ gɨ komo ráka kpá wá. ");
INSERT INTO bdh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gɨ zɨ́ kéyị née ní, bɨlámá ꞌyị ndịsị méngị bɨlámá ledre dụụ́ ne gɨ zɨ́a bɨlámá ledre máa née nɨ sɨmɨ mɨmbéꞌde a. Bɨsinyí ꞌyị ndịsị méngị ꞌbɨ ené dụụ́ bɨsinyí ledre gɨ zɨ́a mɨmbéꞌde a nɨ bɨsinyíne. Ledre bɨ ꞌyị ndịsị úku a kɨ́ méngị a ní, ꞌdị́cị́ a nɨ yana mɨmbéꞌde a.” ");
INSERT INTO bdh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Éyị́ bɨ ndị́sịsé ndólo máa gɨ roa Ngére, Ngére, ní ꞌdi? Bɨ ngárá ílisé kpá méngị ledre ga bɨ mándị́sị ꞌdódo yée zɨ́se ní wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Máúku aka owụ́ ledre zɨ́se gɨ ro ꞌyị bɨ ndịsị méngị ledre amá ní. ");
INSERT INTO bdh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ꞌYị née nɨ cé káa zɨ́ ꞌyị bɨ togụ́ ili ụ́bụ́ ꞌdị́cị́ yá, nɨ aka íci kágá ꞌdị́cị́ née sɨmɨ káṇgá ngị́rị kí, zɨ́a nda ụ́bụ́ a. Abú mongụ́ iní nɨ ógụ kɨ́ mongụ́ síli éꞌdịné yá, ꞌdị́cị́ née utú wá gɨ zɨ́a ụbụ́nɨ́ go do bɨlámá mɨsiꞌdiné. ");
INSERT INTO bdh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ꞌYị máa wo bɨ ili úwú ledre amá zɨ́a ndị́sịné méngị ledre kacɨ́ a wá ní, nɨ káa zɨ́ ꞌyị máa wo bɨ ụbụ́ ené ꞌdị́cị́ ené do bɨlámá mɨsiꞌdiné wá ní. Sɨmɨ bɨ mongụ́ iní nɨ ogụ kpá kɨ́ mongụ́ síli ní, geré zɨ́ ꞌdị́cị́ née útú ené gɨ zɨ́a ụbụ́nɨ́ eyé do bɨlámá mɨsiꞌdiné wá.” ");
INSERT INTO bdh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sɨmɨ bɨ Yésụ ukuasá ledre ga bɨ gáa ndịsị úku yée née go ní, zɨ́ye ị́nyịyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ ore ndáꞌbayé sɨmɨ gara bɨ Kapáranawúma ní. ");
INSERT INTO bdh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sɨmɨ gara ore, ngíti mongụ́ ꞌyị ꞌbɨ asikíri e ꞌbɨ Róma nɨ kóo bo ꞌyị ꞌbɨ moko ené ꞌbɨ ꞌbe bɨ kɨ́ ledrené zɨ́a owóowó ní nɨ kɨ́ ndíyá kɨ́ngaya, kpá gbóo gɨ ro zɨ́ ꞌdówụ́ a ụ́kụ́ne. ");
INSERT INTO bdh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sɨmɨ bɨ mongụ́ ꞌyị ꞌbɨ asikíri e née uwú ledre Yésụ ní, zɨ́a ị́nyịné kása ngíti géyị mɨngburoko ꞌyị ga bɨ ꞌbɨ Yụ́da e ní zɨ́ Yésụ idí ógụ yómo ꞌyị ꞌbɨ moko ené ba. ");
INSERT INTO bdh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Zɨ́ mɨngburoko ꞌyị ga gére née ógụyé zɨ́ Yésụ, zɨ́ye ṇgúṇgú royé kɨ́dí, “Áko mongụ́ ꞌyị, utúasá mɨútúásá zɨ́yị ndéréyị yómo ꞌyị moko ꞌbɨ mongụ́ ꞌyị née. Mongụ́ ꞌyị née nɨ zɨ́ze kɨ́ra bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ꞌBú ꞌyị ezé e nɨ doa kɨ́ngaya, ụbụ́ mongụ́ ꞌDị́cị́ Kótrụro bɨ zɨ́ze kɨ́ra ba ne.” ");
INSERT INTO bdh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zɨ́ Yésụ ị́nyịné zɨ́ye ndéréye. Sɨmɨ bɨ nɨyí nda go gbóo ꞌbe ní, zɨ́ mongụ́ ꞌyị ꞌbɨ asikíri e née kása ngíti eze lámáne ndéré úku ledre zɨ́ Yésụ do mɨsiꞌdi kɨ́dí, “Ngére, ndá ꞌdóꞌdó royị́ ógụyị́ cụ́ zɨ́ma ꞌbe wá áyí yị́ eyị́ mongụ́ ꞌyị gɨ zɨ́a mándá ꞌbɨ amá kɨ́ ledremá owóowó wá. ");
INSERT INTO bdh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Née ngúru sị́ ledre bɨ máíli ógụ gɨ zɨ́a cụ́ máa zɨ́yị wá ní. Bɨlámá a ídí lá úku kúrúyị, nɨ óto ꞌyị moko amá zɨ́a ị́nyịné gɨ do ndíyá. ");
INSERT INTO bdh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mándị́sị méngị moko sị́ lorụ zɨ́ma kpá ídíma kɨ́ asikíri e sị́ sị́lị́ma. Togụ́ máyá ngúru a idí ógụ yá, zɨ́a tɨ́ ógụné. Togụ́ máyá idí ndéré do bi káa yá, zɨ́a ndéréne. Togụ́ máíꞌbí moko zɨ́ ꞌyị moko amá ꞌbe yá, zɨ́a tɨ́ méngị a.” ");
INSERT INTO bdh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sɨmɨ bɨ Yésụ uwú maꞌdíi ledre bɨ oꞌdo née uku kenée ní, zɨ́ ledre née ówóne komoa. Zɨ́a ị́nyị óyó komoné úku ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ ndịsịnɨ́ lódụ́ kacɨ́ a née kɨ́dí, “Do ngará Isɨréle e mbá, mándíki aka ꞌyị bɨ ṇguṇgu ledre ꞌbɨ Lomo go kɨ́ngaya káa zɨ́ ꞌbɨ oꞌdo ba ní ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ꞌYị ga bɨ oꞌdo née kasa yée zɨ́ Yésụ, nɨyí ndáꞌbaógụ bɨ íri ní, ꞌyị moko bɨ kɨ́ ndíyá ba roa eme yị́ ené go. ");
INSERT INTO bdh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Do kacɨ́ ledre máa wo née ní, zɨ́ Yésụ ị́nyịné kɨ́ ꞌyị lódụ́ kacɨ́ne ené e gɨ ore zɨ́ tụ́ꞌdụ́ ꞌyị lódụ́ kacɨ́ a útúye do kacɨ́ye zɨ́ye ndéréye sɨmɨ ngíti gara kɨ́ ịrịné Náyína. ");
INSERT INTO bdh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngíti kára umbu nɨ kóo sɨmɨ gara née ore ndiki owụ́ kpá lá dụụ́ kị́éꞌdo owụ́oꞌdo. Ábuwá bɨkéṛị́ owụ́ née uyu yị́ ené go tụ́ꞌdụ́ ꞌyị e ogụnɨ́ go sɨmɨ ini ore nɨyí go ndéré óto a. ");
INSERT INTO bdh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sɨmɨ bɨ Ngére Yésụ lurú kára née kenée ní, zɨ́ sɨmɨkozo méngị wo zɨ́a úku ledre kɨ́dí, “Ndá lolụ íni ini wá.” ");
INSERT INTO bdh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Zɨ́ Yésụ maꞌdáa ꞌdíꞌbingéṛị gbagbara. Zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ị́mbị́ umbu ba tóroyé. Zɨ́a úku ledre zɨ́ umbu kɨ́dí, “Owụ́, ị́nyịógụ mu.” ");
INSERT INTO bdh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Beré, zɨ́ owụ́phɨṛangá líkpí phụ́trụ komoné, do ị́nyịógụ ndị́sịné ꞌdága ndị́sị ódroné. Yésụ ya zɨ́a ní, ndáꞌba mu zɨ́ mbágáyị ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Zɨ́ tara ꞌyị ga bɨ sɨmɨ ini née ị́drị́ne mbá mɨị́drị́. Zɨ́ye ndị́sịyé mbófo Lomo kɨ́dí, “Mbófo éyị́, Lomo kasaogụ ngúru mongụ́ nébị go ógụ ndị́sị sáká zée ꞌyị ené e.” ");
INSERT INTO bdh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Zɨ́ phanda ledre bɨ Yésụ mengị née báyiné kacɨ́ tara ꞌbe ga bɨ sɨmɨ káṇgá bɨ Yụdáya ore ní za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Née ní, zɨ́ ꞌyị lódụ́ kacɨ́ Yiwáni ị́nyịyé ndéré úku ledre ga bɨ Yésụ mengị yée née mbá zɨ́ Yiwáni. ");
INSERT INTO bdh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Zɨ́ Yiwáni maꞌdáa kása ꞌyị e gbre gɨ dongará ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, ndérésé aka mu ndúꞌyú Ngére, “Nɨ née go tɨ́ owụ́ ꞌbɨ Lomo bɨ kóo uku ledre a kɨ́dí née nɨ kásaógụ wo ní, ala née aka ngíti ꞌyị kpị́?” ");
INSERT INTO bdh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zɨ́ yaꞌdá ga bɨ Yiwáni Babatị́za kasa yée née ndéréógụyé zɨ́ Yésụ zɨ́ye ndúꞌyú wo kɨ́dí, “Mongụ́ ꞌyị, mongụ́ ꞌyị ezé Yiwáni kasa zée ógụ ndúꞌyú yị́ị kɨ́dí, áyí ba go tɨ́ ꞌyị bɨ Lomo uku ledre kásaógụ wo káa do ꞌyị yómo ꞌyị e ní ala áyí aka ba ngíti ꞌyị kpị́?” ");
INSERT INTO bdh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, Yésụ nɨ go ndị́sị yómo tụ́ꞌdụ́ ꞌyị ndíyá e gɨ sɨmɨ ṛị́kị́ ndíyá eyé e. Zɨ́a kpá lágaóyó bɨcayi lomo e gɨ sɨmɨ ngíti géyị ꞌyị e ꞌdáꞌba. ꞌYị máa yée ga bɨ komoyé ꞌdụtụ mɨꞌdụ́tụ ní zɨ́a líkpí a. ");
INSERT INTO bdh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sɨmɨ bɨ mengị onzó moko bɨ gáa ꞌyị ꞌbɨ Yiwáni ogụ ndikinɨ́ wo roa ní, zɨ́a ị́nyịné úku ledre zɨ́ye kɨ́dí, “Ledre ga bɨ lúrúsé yée kɨ́ yée ga bɨ úwúsé yée ní, ídísé ndéré úku a zɨ́ Yiwáni. ꞌYị ga bɨ kóo ngárá lurúnɨ́ bi wá ní, nɨyí go lúrú bi, yée ga bɨ kóo mɨgịgị́ṛị́ ní nɨyí go gámá. Yée ga bɨ kɨ́ sámá royé ní, royé eme go. Mɨmbílí ngbụtụ́ nɨyí go ndị́sị úwú ledre. Umbu e urúnɨ́ gɨ sɨmɨ umbu go. ꞌYị ga bɨ ndịsịnɨ́ lúrú yée káa zɨ́ moko ndaá sɨmɨyé wá ní, nɨyí go úwú bɨlámá ledre ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ꞌYị bɨ nɨ íꞌbí roné ndị́sị lódụ́ kacɨ́ma sɨmɨ ledre e za mbá ní, nɨ ídí mbigí ꞌyị amá, Lomo nɨ óto wo zɨ́a ídíne kɨ́ mongụ́ rokinyi.” ");
INSERT INTO bdh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sɨmɨ bɨ ꞌyị ga bɨ Yiwáni kasaogụ yée née ndaꞌbalugunɨ́ royé ní, zɨ́ Yésụ ndáꞌba ndị́sị ódroné zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ gáa ba kɨ́dí, “Sɨmɨ bɨ kóo ndị́sịsé úwú ledre ga bɨ Yiwáni ndịsị úku yée zɨ́se sɨmɨ yana súwú ní, lúrúsé kóo wo kacɨ́ komosé káa zɨ́ bɨcayi ꞌyị bɨ sómụ́ ledre ené nɨ gbre gbre káa zɨ́ lómí ga bɨ síli ndịsị ílílóꞌbó yée ní? ");
INSERT INTO bdh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Togụ́ kenée wá ní, ndérésé nda kóo íri lúrú ꞌyị bɨ esị bɨlámá bongó roné ní? ꞌYị ga bɨ ndịsịnɨ́ ésị bɨlámá bongó ga bɨ ugúnɨ́ yée kɨ́ tụ́ꞌdụ́ késị́ ní, nɨyí ye ꞌyị ga bɨ ndịsịnɨ́ ndị́sị ꞌbe ꞌbɨ mongụ́ ngére ní, gɨ zɨ́a nɨyí yị́ eyé ꞌyị ga bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye ní. ");
INSERT INTO bdh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nɨ maꞌdíi, máówo bú kɨ́dí ndérésé kóo lúrú Yiwáni gɨ zɨ́a ówosé bú kɨ́dí nɨ nébị. Máúku zɨ́se, rokoꞌbụ ledre ené romo do ꞌbɨ nébị e. ");
INSERT INTO bdh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Née oꞌdo bɨ ekénɨ́ ledre a sɨmɨ mɨéké kúrú Lomo kɨ́dí, “ ‘Mááyí kása ꞌyị kasa amá zɨ́yị ꞌdáꞌdá, gɨ ro zɨ́a yémeómo mɨsiꞌdi zɨ́yị nzíyiné.’ ");
INSERT INTO bdh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Máúku zɨ́se maꞌdíi, ꞌyịmaꞌdí ga bɨ ndikiogụnɨ́ yée do sogo káṇgá ba za mbá, wo bɨ nɨ rómo do Yiwáni ní ndaá. Dụụ́ ꞌyị bɨ nɨ cúkuꞌdée ꞌbe ꞌbɨ Lomo ní, ledre ené nɨ rómo ꞌbɨ Yiwáni ne.” ");
INSERT INTO bdh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị ga gére née uwúnɨ́ ledre bɨ Yésụ uku kenée ní, zɨ́ye ị́nyịyé za kɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ e mbá ṇgúṇgu ledre ꞌbɨ Lomo, gɨ zɨ́a Yiwáni íꞌbí kóo babatị́za go zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Zɨ́ Farụsáyo e kɨ́ yée ga bɨ nɨyí ꞌbɨ eyé ꞌyị ꞌdódo lorụ ga bɨ kóo Mụ́sa eké yée ní, ási eyé mɨási gɨ ro Lomo kpá kɨ́ úwú ledre ga bɨ Yiwáni ndịsị úku yée ní gɨ zɨ́a Yiwáni íꞌbí ené kóo babatị́za zɨ́ye wá. ");
INSERT INTO bdh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zɨ́ Yésụ úku ledre gɨ ro ꞌyị ga gére née kɨ́dí, “Mááyí ótoásá ꞌyị ga ba kɨ́ ꞌdi? Bɨ ngárá ṇguṇgunɨ́ ledre amá wá ní? ");
INSERT INTO bdh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɨlámá a nɨyí káa zɨ́ mɨnzéré owụ́ e do bi ndeke kɨ́ lafúye ní. Yée ga bɨ ndịsịnɨ́ úku keꞌbị kɨ́ ụ́cụ kị́drị́ ní, zɨ́ye úku ledre zɨ́ ngíti géyị lafúye kɨ́dí, “ ‘Ledre esé sinyí kenée gɨ zɨ́ ꞌdi? Togụ́ ukuzé keꞌbị rokinyi kɨ́ ụ́cụ kị́drị́ yá, ílisé léꞌbé keꞌbị wá, togụ́ ukuzé nda keꞌbị ini yá, ílisé kpá íni ini wá ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Lúrúsé aka, sɨmɨ bɨ kóo Yiwáni Babatị́za maꞌdáa ogụ dongaráse zɨ́a ndị́sịné káa zɨ́ órụ́ roné mɨórụ́ ní, anu éyị́ mɨánu kɨ́ngaya wá, nda kpá ꞌyị éwé leꞌyị́ wá, zɨ́se ndị́sịsé fála wo kɨ́dí nɨ kɨ́ bɨcayi lomo e sɨmɨné. ");
INSERT INTO bdh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sɨmɨ bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí ógụ ndị́sị dongaráse kɨ́ ánu kótrụ éyị́ kpá kɨ́ éwé éyị́ e ndro kése ní, ndị́sịsé kpá fála Máa kɨ́dí Mááyí ꞌyị mɨmbéꞌde kpá ꞌyị kóyó zɨ́ma ụ́nzụ ꞌyị lúyú ledre e kɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ óto yée káa do ezegámá e. ");
INSERT INTO bdh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sée ga bɨ ndị́sịsé úwú ledre ga bɨ Yiwáni uku yée kɨ́ yée ga bɨ máógụ ndị́sị úku yée ní, ásé ówoyéme a dụụ́ se kɨ́dí ndịsịzé úku née ledre ga bɨ ꞌbɨ Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nda gɨ do kacɨ́ ledre ga gére née sɨmɨ ngíti sị́lị́ kpị́, zɨ́ ngíti mongụ́ ꞌyị nɨ Farụsáyo kɨ́ ịrịné Simúna. Zɨ́a yéme éyị́ mɨánu ꞌbe ꞌbɨ ené do ndólo Yésụ gɨ roa. Zɨ́ Yésụ ndéréne go ógụné íri do ndị́sịyé ánu éyị́. ");
INSERT INTO bdh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngíti kára nɨ kóo bo sɨmɨ gara bɨ Simúna nɨ sɨmɨ a ore ní. ꞌYị ga bɨ ore ní owonɨ́ wo mbá nɨ kára bɨ mɨméngị ledre ené emengụ́ ní. Sɨmɨ bɨ kára máa née uwú ledre kɨ́dí Yésụ nɨ ꞌbe ꞌbɨ Simúna bɨ Farụsáyo ore ní, zɨ́a ꞌdíꞌbi bɨlámá sụꞌbụ́ mɨndonyo bɨ kɨ́ ndonyoné trụụ ní, ndéréne ólụ́ne kɨ́e ru ꞌdị́cị́ bɨ Yésụ nɨyí ndị́sị ánu éyị́ sɨmɨ a kɨ́ ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Zɨ́a óyó roné gɨ ꞌdí sogo Yésụ ndéré útúne sị́ sịndị́a bi, ꞌdíꞌbi sịndị́ Yésụ maꞌdáa ngbúó ndị́sịné íni ini roa. Zɨ́ do sogo sịndị́ Yésụ sílíne zɨ́líꞌbéte gɨ zɨ́ iní komoa. Sɨmɨ bɨ ini asá ini ní, zɨ́a ndị́sịné óꞌdó iní komoné née gɨ ro sịndị́ Yésụ kɨ́ bi doné bɨ alamɨála née. Zɨ́a ꞌdíꞌbi sụꞌbụ́ mɨndonyo bɨ gáa ogụ kɨ́e ní dụ́dụ a mbá ro sịndị́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sɨmɨ bɨ Simúna bɨ Farụsáyo lurú ledre ga bɨ kára née nɨ ndị́sị méngị yée ro Yésụ kenée ní, zɨ́a ndị́sị ódroné zɨ́ne kɨ́ roné kɨ́dí, “Áyi, ábuwá mongụ́ ꞌyị ba ndaá ꞌbɨ ené nébị wá ke. Idí ídí nébị yá, káa bɨ owo go kɨ́dí kára née nɨ ꞌyị lúyú ledre, utúasá ótoómo wo ndósoógụné ndị́sị óto sị́lị́ne roné wá.” ");
INSERT INTO bdh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sɨmɨ bɨ Yésụ owo kɨ́dí Simúna nɨ go ndị́sị sómụ́ ledre kenée ní, zɨ́a ị́nyịné úku ledre zɨ́ Simúna kɨ́dí, “Máíli aka gáa úku owụ́ ledre zɨ́yị.” Zɨ́ Simúna úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ódro mu mongụ́ ꞌyị.” ");
INSERT INTO bdh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zɨ́a úku ledre kɨ́dí yaꞌdá e nɨyí kóo bo gbre, zɨ́ye ị́nyịyé ndéréye sáká késị́ gɨ zɨ́ ngíti mongụ́ ꞌyị. Gɨ dongará yaꞌdá ga bɨ gbre née, ngíti ꞌyị saká ꞌbɨ ené míya ịnyị (500), ꞌbɨ ngíti a ꞌbɨ ené dụụ́ cị́ gbre doa sokó (50). ");
INSERT INTO bdh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Késị́ bɨ yaꞌdá ga gére née sakánɨ́ ní ụkụ́ yị́ ené go. Rokoꞌbụ bɨ zɨ́ye íꞌbílúgu a kɨ́e ní ndaá ꞌbɨ ené lolụ kpá wá. Zɨ́ mị́ngị́ késị́ lúrú a kenée, zɨ́a úku ledre zɨ́ yaꞌdá ga gére née kɨ́dí, “Ndásé lolụ sómụ́ ledre wá, késị́ née idí mu ndásé íꞌbílúgu a wá. Gɨ dongará yaꞌdá ga bɨ gbre née, ambi nɨ óto ꞌbú mị́ngị́ késị́ née za kɨ́ngaya ní ne?” ");
INSERT INTO bdh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Zɨ́ Simúna úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, oꞌdo bɨ kɨ́ tụ́ꞌdụ́ késị́ kacɨ́ne ní, nɨ óto ꞌbú mị́ngị́ késị́ née ne kɨ́ngaya.” Yésụ ya zɨ́a ní, “Úku go maꞌdíi, wo bɨ kɨ́ tụ́ꞌdụ́ késị́ sogoné ní, nɨ óto ꞌbú mị́ngị́ késị́ ne kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zɨ́ Yésụ óyó komoné zɨ́ kára gáa ndịsị íni ini ní, zɨ́a úku ledre zɨ́ Simúna kɨ́dí, “Lúrú go Simúna, kára ba ṇguṇgu ledremá go rómo doyị́ kɨ́e. Bɨ gáa máógụ ꞌbe ꞌbɨ eyị́ ona ní, íꞌbí eyị́ iní zɨ́ma lúgu ꞌbụrụ gɨ ro sịndị́ma kɨ́e wá. Zɨ́a léfe za cụ́ iní komoné ro sịndị́ma do ndị́sịné óꞌdóóyó a kpá za cụ́ kɨ́ bị doné. ");
INSERT INTO bdh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sɨmɨ bɨ máólụ́ zɨ́yị ꞌbe ona ní, fáka máa kɨ́ íꞌbí mandá zɨ́ma kɨ́ ꞌbúne wá. Kára née iꞌbí mandá zɨ́ma ne kɨ́ ꞌbúne, zɨ́a fáka sịndị́ma ndá sɨmɨ kóꞌdụ́ne. ");
INSERT INTO bdh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ꞌDíꞌbi máa sɨmɨ sụmụ bɨlámáne kpá wá, kára née ꞌdiꞌbi nda máa ne sɨmɨ sụmụ káa zɨ́ mị́ngị́ ꞌbe nɨ nda ne wo ní. ");
INSERT INTO bdh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Máúku zɨ́yị Simúna, gɨ zɨ́a bɨ kára née ṇguṇgu ledremá go kɨ́ngaya ní, Lomo lụlụoyó tụ́ꞌdụ́ lúyú ledre ené ga kóo née go za mbá. ꞌYị bɨ otoomonɨ́ lúyú ledre ené lá cúkuꞌdée ní, ꞌbú ꞌyị e nɨ doa kpá cúkuꞌdée. ꞌYị bɨ otoomonɨ́ lúyú ledre ené mongụ́ne ní, ꞌbú ꞌyị e nɨ doa kpá mongụ́ne.” ");
INSERT INTO bdh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zɨ́ Yésụ úku ledre zɨ́ kára máa née kɨ́dí, “Máúku zɨ́yị, máótoómo lúyú ledre eyị́ e go za mbá.” ");
INSERT INTO bdh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Zɨ́ ngíti géyị ṇgu ga bɨ nɨyí kpá ore ní, ị́nyịyé ndị́sị úku ledre dengbị́ye kɨ́dí, “Oꞌdo née ili ótoásá roné kɨ́ Lomo ndị́sị ótoómo lúyú ledre ꞌbɨ ꞌyị e ꞌdáꞌba.” ");
INSERT INTO bdh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Zɨ́ Yésụ kpá úku ándá ledre zɨ́a kɨ́dí, “Gɨ zɨ́a bɨ ṇgúṇgu ledremá go ní, ómo yị́ eyị́ go. Ndáꞌba mu ꞌbe, mɨmbéꞌdeyị́ idí ídí teéteké.” ");
INSERT INTO bdh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nda gɨ do kacɨ́ ledre máa wo née ní, zɨ́ Yésụ ị́nyịné kɨ́ ꞌyị lódụ́ kacɨ́ne ga bɨ sokó doa gbre (12) née ndị́sị gámáye kɨ́ úku bɨlámá ledre gɨ ro ꞌbe Lomo zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ngíti géyị kará ga bɨ kóo Yésụ lagaoyó bɨcayi lomo e gɨ sɨmɨyé, kɨ́ yée ga bɨ kóo sịkpị yée gɨ do ndíyá, káa zɨ́ Maríya bɨ gɨ sɨmɨ Magɨdála bɨ Yésụ lagaoyó bɨcayi lomo e gɨ sɨmɨ a ịnyị doa gbre, ");
INSERT INTO bdh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nda kɨ́ Zowána meꞌbe Kúza. Kúza maꞌdáa nɨ manda ꞌbɨ ꞌyị ꞌbɨ moko ga bɨ ꞌbɨ ngére Eróde ní. Nda kpá kɨ́ ngíti kára kɨ́ ịrịné Suzéna, nda kpá kɨ́ ngíti géyị kará e. Kará ga gére née ndịsịnɨ́ kóo lódụ́ kacɨ́ Yésụ kɨ́ ꞌyịmɨkása ené e kɨ́ ndị́sị íꞌbí eyị́ ga bɨ Yésụ ilinɨ́ yée kɨ́ ꞌyịmɨkása ne e ní zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zɨ́ tụ́ꞌdụ́ ꞌyị e ị́nyịyé gɨ sɨmɨ gara gɨ ore kpá kɨ́ ngíti géyị kacɨ́ do ꞌbe ga bɨ ore ní ndị́sị ógụyé zɨ́ Yésụ kɨ́ úwú bɨlámá ledre ga bɨ ndịsị úku yée ní. Zɨ́a úku ngíti ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kadra kị́éꞌdo, zɨ́ ngíti oꞌdo ꞌdíꞌbi kúfú zɨ́a ndéréne yáká. Sɨmɨ bɨ ogụ go yáká ní, geré zɨ́a tónóne óyụ kúfú. Zɨ́ ngíti géyị léꞌbéútúye do mama, zɨ́ ꞌyị e ndị́sịyé ꞌdítí a kɨ́ ndéréye. Gɨ zɨ́a bɨ nɨyí do nyárá bi ní, zɨ́ solụ́ e ógụyé ánu yée. ");
INSERT INTO bdh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zɨ́ ngíti géyị útú ꞌbɨ eyé do landa. Gɨ zɨ́a bɨ ngárá mɨꞌbeꞌbe káṇgá ndaá ore bɨlámáne wá ní, zɨ́ye ụ́tụógụyé ꞌdiya. Sɨmɨ bɨ bɨrará kadra suwu nda ní, zɨ́ye gágáye rúfú gɨ zɨ́a mɨꞌbeꞌbe káṇgá nda zɨ́ cíyíye ólụ́ne sɨmɨ a wá. ");
INSERT INTO bdh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ngíti géyị utúnɨ́ ꞌbɨ eyé dongará kị́nị e. Zɨ́ye ụ́tụyé ngbóróye ndro kɨ́ kị́nị ga gére ní. Sɨmɨ bɨ kị́nị ga gére olụ́ịndị́nɨ́ nda yị́ eyé ní, zɨ́ kére ga gére née nda ídí eyé mbá andulé, anánɨ́ eyé lolụ wá. ");
INSERT INTO bdh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ngíti géyị utúnɨ́ ꞌbɨ eyé do bɨlámá káṇgá, do ụ́tụyé ngbóróye kɨ́ mɨngburoko kókó sịndị́ye do ánáye mbá mụdụ.” Sɨmɨ bɨ ukuasá ledre née go ní, zɨ́a ꞌdụ́tụ a kɨ́ ledre bɨ kɨ́dí, “Ídísé sómụ́ sɨmɨ ledre née bɨlámáne.” ");
INSERT INTO bdh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zɨ́ ꞌyị lódụ́ kacɨ́ga ị́nyịyé ndúꞌyú wo kɨ́dí, “Ini ledre gɨ sɨmɨ muruwayi née yaá ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Máúku phụ́trụ ledre gɨ ro ledre ꞌbe ꞌbɨ Lomo zɨ́se go fúó. Mándị́sị úku a zɨ́ ngíti géyị ꞌyị e sɨmɨ muruwayi. “ ‘Abú nɨyí tɨ́ lúrú bi, utúasánɨ́ lurúndikinɨ́ éyị́ wá. Abú nɨyí tɨ́ úwú ledre e, utúasánɨ́ ówoyéme a.’ ");
INSERT INTO bdh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ini ledre gɨ sɨmɨ muruwayi bɨ gáa ba nɨ kɨ́dí, kúrú Lomo bɨ ndịsịnɨ́ úku a zɨ́ ꞌyị e ní nɨ káa zɨ́ ndịsịnɨ́ óyụ kúfú ní. ");
INSERT INTO bdh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kúfú máa yée ga bɨ utúnɨ́ do mama ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị máa yée ga bɨ ukunɨ́ tɨ́ ledre ꞌbɨ Lomo go zɨ́ye, ꞌdiꞌbiotonɨ́ eyé ngị́rị sɨmɨ yana mɨmbéꞌdeyé wá ní. Sɨmɨ bɨ ngére ꞌbɨ bɨcayi lomo e lurú ngárá cíyí a ndaá do mɨmbéꞌdeyé wá ní, zɨ́a ógụné ꞌdiya ꞌdíꞌbióyó a gɨ sɨmɨyé ꞌdáꞌba káa bɨ nɨyí lányá ro ledre ꞌbɨ Lomo, zɨ́a yómo yée ke. ");
INSERT INTO bdh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kúfú máa yée ga bɨ utúnɨ́ do landa ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị máa yée ga bɨ togụ́ ukunɨ́ ledre ꞌbɨ Lomo go zɨ́ye yá, zɨ́ye ṇgúṇgu a ꞌdiya kɨ́ ꞌbúne, tɨ́ lá cíyí ledre maꞌdáa ndaá ꞌbɨ ené ngị́rị sɨmɨ mɨmbéꞌdeyé wá. Sɨmɨ bɨ ꞌdoꞌdó ndiki yée go ní, geré zɨ́ye ónzóóto ledre ꞌbɨ Lomo bɨ ṇguṇgunɨ́ née. ");
INSERT INTO bdh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kúfú máa yée ga bɨ utúnɨ́ ꞌbɨ dongará kị́nị e ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị máa yée ga bɨ ṇguṇgunɨ́ tɨ́ ledre Lomo go ní, ndaá ꞌbɨ ené za kɨ́ mɨmbéꞌdeyé mbá wá, gɨ zɨ́ kéyị née rokoꞌbụyé ndaá ꞌbɨ ené e wá. Gɨ zɨ́a mɨmbéꞌdeyé nɨ yị́ ené kpá mongụ́ne gɨ ro éyị́ ga bɨ ꞌbɨ sága ba, kpá kɨ́ rokinyi bɨ ꞌbɨ sága ba. Gɨ zɨ́ kéyị née utúasánɨ́ eyé tóro ngbúó méngị ledre ꞌbɨ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kúfú máa yée ga bɨ utúnɨ́ ꞌbɨ eyé sɨmɨ ngomụ káṇgá ní, nɨyí ꞌbɨ eyé káa zɨ́ ꞌyị máa yée ga bɨ uwúnɨ́ ledre ꞌbɨ Lomo zɨ́ye ꞌdíꞌbi a do mɨmbéꞌdeyé kɨ́ngaya, zɨ́ye ndị́sịyé méngị mbá bɨlámá ledre ga bɨ Lomo ili ní.” ");
INSERT INTO bdh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zɨ́ Yésụ kpá ị́nyịné úku ngíti muruwayi gɨ do kacɨ́ wo bɨ ꞌdáꞌdá ní kɨ́dí, “Máúku zɨ́se ꞌyị bɨ kị́éꞌdo káa yaá ụndụoto phoꞌdụ go ꞌdị́cị́ kacɨ́ne kɨ́ ndụlụ zɨ́a lóꞌbụꞌdụ́tụ a sị́ pheṛé togụ́ zɨ́a ésịóto e ru sị́ ṛangba ní nda. Togụ́ ụndụotonɨ́ phoꞌdụ go kɨ́ ndụlụ ꞌdị́cị́ yá, ndịsịnɨ́ lengbe óto a gá do éyị́ ꞌdága gɨ do bɨ zɨ́a óṇgó bi ꞌdị́cị́ komo ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sịndị́ kadra nɨ ógụ zɨ́ ꞌyị e ówoyéme ledre amá mbá zaá bɨlámáne wo bɨ kị́éꞌdo zɨ́a lóꞌboné ní nda gɨ zɨ́a Lomo nɨ nda ꞌdódo a za cụ́ ne zɨ́ye fúó. ");
INSERT INTO bdh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ídísé úwú ledre ga bɨ mándị́sị úku yée zɨ́se ba bɨlámáne zɨ́se ṇgúṇgu a. Gɨ zɨ́a togụ́ ꞌyị ṇguṇgu ledre amá go yá, Lomo nɨ nda ꞌdódo yata ledre e zɨ́a za kɨ́ngaya. ꞌYị bɨ ili ṇgúṇgu ledre amá wá, gɨ zɨ́a somụ́ yị́ ené ya née owo yị́ ené ledre bú, owụ́ ledre bɨ owo née, Lomo nɨ lụ́lụ a gɨ sɨmɨ doa mbá zɨ́a ídíákáne gbékpị́e.” ");
INSERT INTO bdh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gɨ ore, zɨ́ ngíti géyị owụ́ ꞌbɨ mbágá Yésụ, nda kpá kɨ́ mbágáye Maríya ndéréye lúrú Yésụ. Sɨmɨ bɨ ogụnɨ́ kɨ́ꞌdí bɨ Yésụ nɨ ore ní, bi ógụyé ndaá kóo gbóo ro Yésụ maꞌdáa wá gɨ zɨ́ tụ́ꞌdụ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Zɨ́ ngíti ꞌyị gɨ dongará tụ́ꞌdụ́ ꞌyị ga bɨ ndịsị ꞌdódo ledre zɨ́ye née ị́nyịné ndéréne ndoo gị zɨ́ Yésụ uku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, mbágáyị kɨ́ lúnduyị́ e nɨyí sága ꞌdáa ogụnɨ́ zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Zɨ́a úkulúgu ledre zɨ́ ꞌyị ga gére née mbá kɨ́dí, “Máúku zɨ́se maꞌdíi, ꞌyị ga bɨ ndịsịnɨ́ úwú ledre ꞌbɨ Lomo bɨ mándị́sị ꞌdódo a, zɨ́ye ndị́sịyé méngị ledre e kacɨ́ a ní, nɨyí go kpá mbágáma e kɨ́ lúndumá e.” ");
INSERT INTO bdh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nda sɨmɨ ngíti sị́lị́, zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “ꞌDogụzé aka mɨkavu mu sága gɨ ꞌdí keṛị́.” Zɨ́ye ékị́ye sɨmɨ kuṛúngba, go ndéréye gɨ ro ꞌdógụ bi sága. ");
INSERT INTO bdh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Zɨ́ye ndéréógụyé go sɨmɨ yana mɨkavu, ṛí zɨ́ Yésụ útú ꞌdúꞌdu ené. Zɨ́ mongụ́ síli ógụné kpị kpị kpị, zɨ́ iní ndị́sị kádané gɨ zɨ́a sɨmɨ kuṛúngba, zɨ́ kuṛúngba ndị́sị kị́zịné kɨ́ ízi roné kɨ́ éwé iní sɨmɨné áyíne go kpá gbóo gɨ ro ólụ́ sị́ iní, umbu ogụ go zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gɨ zɨ́ ngịrị, zɨ́ ꞌyịmɨkása ené ga gére née úru wo kɨ́dí, “Mongụ́ ꞌyị, mongụ́ ꞌyị, ꞌdiꞌdiya ị́nyịógụ mu azé go úyu.” Zɨ́ Yésụ úrúne ndíki ledre nɨ go tɨ́ ndị́sị méngị roné kenée. Zɨ́a ị́nyịné úku ledre zɨ́ síli kɨ́dí, “Ídí tóro tí, ndá ílí wá.” Zɨ́a kpá úku ledre zɨ́ iní bɨ ndịsị káda ba kɨ́dí, “Ídí tóro kpá tí, ndá káda wá.” Tɨ́ maꞌdíi zɨ́ síli kɨ́ mɨkáda iní tóroyé zɨ́ bi ídíne sií. ");
INSERT INTO bdh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zɨ́a ị́nyịné úku ledre zɨ́ ꞌyịmɨkása ené ga gére née kɨ́dí, “Érésé ngịrị gɨ zɨ́ ꞌdi, ṇgúṇgusé aka esé ledremá fú lá wá ke?” Zɨ́ tarayé ị́drị́ne mbá mɨị́drị́ gɨ zɨ́ ledre máa wo née zɨ́ye ndị́sị ódroyé dengbị́ye kɨ́dí, “Bɨ káa lárá ꞌyị bɨ káa be ꞌdi bɨ odro lá kɨ́ tarané zɨ́ síli kɨ́ iní úwú kúrú a ní.” ");
INSERT INTO bdh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zɨ́ye ꞌdógụ mɨkavu Galiláya ndéréógụyé sɨmɨ gara ꞌbɨ ꞌyị ga bɨ Gerésa ní. ");
INSERT INTO bdh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ábuwá ngíti oꞌdo nɨ kóo sɨmɨ ngíti gara sɨmɨ káṇgá née íri, nɨ kɨ́ tụ́ꞌdụ́ bɨcayi lomo e sɨmɨné. Kpálá bɨ Yésụ nditíogụ gɨ sɨmɨ kuṛúngba ní, geré zɨ́ye ndíkíye kɨ́ oꞌdo bɨ kɨ́ bɨcayi lomo e sɨmɨné née. Nɨ nda yị́ ené kóo gɨ zɨ́ye go kɨ́ nzanga komoné ndịsị nda gámá ené go ngíṛá, olụ́ogụ nda gɨ ꞌbe ndị́sị ꞌdúꞌdu ené dongará bi ga bɨ zɨ́ umbu e ní. ");
INSERT INTO bdh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kpálá bɨ lurúndiki Yésụ ní, zɨ́a tónó gbúrógbóne gɨ zɨ́ nzanga bɨcayi lomo ga gére née, zɨ́a ndéré útúne gbrị kóꞌdụ́ Yésụ do kpá gbúrógbóne ꞌdága kɨ́dí, “Yésụ, yị́ị owụ́ ꞌbɨ mbigí Lomo, éyị́ bɨ íli méngị a kɨ́ma ní ꞌdi? Máṇgúṇgú romá zɨ́yị, ndá geré ꞌdóꞌdo máa wá.” ");
INSERT INTO bdh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Oꞌdo née uku ledre kenée gɨ zɨ́a, Yésụ ódro zɨ́ bɨcayi lomo ga gére née idínɨ́ ólụ́ógụ gɨ sɨmɨ oꞌdo née ꞌdáꞌba. Ndịsịnɨ́ nda kóo méngị wo bɨsinyíne zɨ́ ꞌyị e nda kóo ndị́sị éré wo mbá mɨéré. Abú utúꞌdiꞌbinɨ́ ba zaá wo do ódó sị́lị́a kɨ́ sịndị́a mɨódó cụ́ kɨ́ káꞌdá késị́, ɨ́ꞌɨ, zɨ́a ndị́sị ꞌdécị éyị́ ga gére née gɨ roné mbá kɨ́ rokoꞌbụ bɨcayi lomo ga gére née. Zɨ́a ndị́sị gámáne gɨ zɨ́ye nda lá rịị́ ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zɨ́ Yésụ ndúꞌyú bɨcayi lomo bɨ sɨmɨ oꞌdo née kɨ́dí, “Ịrịyị́ náambi?” Zɨ́a úkulúgu ledre zɨ́ Yésụ tara oꞌdo née kɨ́dí, “ịrịmá owụ́tụ́ꞌdụ́.” Ịfị́ ịrịné kenée gɨ zɨ́a nɨyí sɨmɨ oꞌdo née tɨ́ tụ́ꞌdụ́ maꞌdíi. ");
INSERT INTO bdh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Zɨ́ye ṇgúṇgú royé zɨ́ Yésụ kɨ́dí, “Ndaá aka geré ógó yée zɨ́ye ndéré útúye sɨmɨ mongụ́ gu ꞌbɨ nduwú bɨ gɨ ro bɨcayi lomo e ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tụ́ꞌdụ́ mɨkụ́ṛụ́ nɨyí kóo kpá ro ngíti owụ́ landa ore ndị́sị ánu éyị́. Zɨ́ bɨcayi lomo ga gére úku ledre zɨ́ Yésụ idí ṇgúṇgu a zɨ́ye ndéré ólụ́ ndị́sịyé sɨmɨ mɨkụ́ṛụ́ ga bɨ íri née. ");
INSERT INTO bdh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zɨ́ye ólụ́ógụyé gɨ sɨmɨ oꞌdo née ndéré ólụ́ye mbá sɨmɨ mɨkụ́ṛụ́ ga gére ní. Zɨ́ éyị́ ídíne sɨmɨ do mɨkụ́ṛụ́ ga gére née káa zɨ́ nzanga ní, zɨ́ye ụ́dụyé rụụ ngásá ndúṛúꞌbụ́ye, ndéré útúye sɨmɨ mɨkavu nónụ́ye gɨ zɨ́ iní do úyuyé mbá. ");
INSERT INTO bdh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sɨmɨ bɨ ꞌyị ꞌbáꞌbá mɨkụ́ṛụ́ ga gére née lurúnɨ́ ledre bɨ mengị roné kenée ní, zɨ́ye ị́nyịyé ngásá ndáꞌbayé sɨmɨ gara kɨ́ úku ledre bɨ mengị roné née zɨ́ ꞌyị e kpá kɨ́ ngíti géyị bi ga bɨ gbóo gbóo ore ní mbá. ");
INSERT INTO bdh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Zɨ́ ꞌyị e ndéréye kacɨ́ ledre ga bɨ uwúnɨ́ ní. Zɨ́ye ndéréye ndíki oꞌdo bɨ bɨcayi lomo e olụ́ogụnɨ́ gɨ sɨmɨ a ba nɨ go ndị́sị cigí sịndị́ Yésụ bi kenée komoa oṇgó yị́ ené go nɨ go kɨ́ bɨlámá bongó roné. Zɨ́ ngịrị ledre née ólụ́ne ro ꞌyị ga bɨ lurúnɨ́ ní mbá. ");
INSERT INTO bdh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Zɨ́ye ndị́sịyé úkutátá a zɨ́ ꞌyị ga bɨ lurúnɨ́ kɨ́ komoyé wá ní kɨ́dí, maꞌdíi Yésụ yomo oꞌdo née go. ");
INSERT INTO bdh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gɨ zɨ́ ngịrị ledre bɨ mengị roné née, zɨ́ ꞌyị ꞌbɨ Gerésa e úku ledre zɨ́ Yésụ idí mu ólụ́ógụ gɨ sɨmɨ káṇgá eyé gɨ ore ꞌdáꞌba. Zɨ́ Yésụ ékị́ye kɨ́ ꞌyị ené e sɨmɨ kuṛúngba zɨ́ye ndéréóyó royé gɨ ore ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Zɨ́ oꞌdo bɨ lagaoyónɨ́ bɨcayi lomo e gɨ sɨmɨa ba ṇgúṇgú roné zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị azé ndéré ezé kése.” Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ndáꞌba aka ꞌbe zɨ́yị úku ledre bɨ Lomo mengị zɨ́yị née zɨ́ ꞌyị e ꞌbe íri.” Tɨ́ maꞌdíi, zɨ́ oꞌdo née ndáꞌbané ꞌbe ndéré kɨ́ úku ledre bɨ Yésụ mengị zɨ́a née zɨ́ ꞌyị e sɨmɨ gara ore mbá. ");
INSERT INTO bdh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zɨ́ Yésụ ị́nyịyé gɨ ore ꞌdógụ bi ndáꞌbalúgu royé sɨmɨ Galiláya. Sɨmɨ bɨ ogụnɨ́ íri ní, zɨ́ tụ́ꞌdụ́ ꞌyị e ꞌdíꞌbi wo sɨmɨ sụmụ gɨ zɨ́a ndịsịnɨ́ go kú sóngó wo. ");
INSERT INTO bdh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ngíti mongụ́ ꞌyị nɨ kóo bo ore kɨ́ ịrịné Yáyiro, nɨ mongụ́ ꞌyị bɨ ndịsị lúrú bi kacɨ́ moko sɨmɨ ꞌDị́cị́ Kótrụro ꞌbɨ Lomo ní. Zɨ́a ógụné útúne sị́ sịndị́ Yésụ ṇgúṇgú roné zɨ́a idí ógụ ꞌbe ꞌbɨ ené. ");
INSERT INTO bdh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ábuwá, bɨkéṛị́ nyị́ a, odụ owụ́ maꞌdáa kpá dụụ́ née kị́éꞌdo née, owụ́ ꞌbɨ sɨmɨbi sokó doa gbre nɨ kɨ́ ndíyá gbála, go gbóo kɨ́ umbu. Sɨmɨ bɨ Yésụ uwú ledre née kenée ní, zɨ́ye ị́nyịyé kɨ́ Yáyiro e go ndéréye lúrú ndíyá. Gɨ zɨ́a ꞌyị e ofụnɨ́ go, bi ndéré ndaá lolụ kóo bɨlámáne wá. ");
INSERT INTO bdh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ábuwá ngíti kára nɨ kóo kpá bo dongará tụ́ꞌdụ́ ꞌyị ga gére née ore nɨ kɨ́ ndíyá ꞌbɨ kará e roné ndịsị nda kóo méngị wo bɨsinyíne ndaá do bɨlámá mɨsiꞌdiné káa zɨ́ bɨ lengbe ní wá. ꞌDiꞌbi kɨ́e ꞌdényé sɨmɨbi sokó doa gbre. Tɨ́ lá ꞌyị bɨ nɨ yómo wo ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Zɨ́ kára née ólụ́ne ndoo gɨ ngará tụ́ꞌdụ́ ꞌyị ga gére née ndéré óto sị́lị́ne ro tara bongó bɨ ro Yésụ ní. Geré zɨ́ bɨsinyí sáma ndíyá bɨ kóo ndịsị léfeógụ ro kára née káa zɨ́ ꞌdíya ní tóro ní. ");
INSERT INTO bdh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yésụ owo gáa go kɨ́dí ꞌyị oto sị́lị́ne go roné. Zɨ́a ndúnduꞌyú kɨ́dí, “Ambí oto sị́lị́ne romá ne?” Sɨmɨ bɨ ꞌyị e itínɨ́ nda go mbá kangú ní, zɨ́ Pétero bɨ ngúru ꞌyịmɨkása ené ní úku ledre kɨ́dí, “Mongụ́ ꞌyị, lúrú aka lá tụ́ꞌdụ́ ꞌyị ga ba, zɨ́yị úku ledre yá ambi oto sị́lị́ne royị́ ne?” ");
INSERT INTO bdh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yésụ ya, “Abú tɨ́ kenée ndotó, máówo go kɨ́dí ꞌyị oto sị́lị́ne go romá, gɨ zɨ́a rokoꞌbụ bɨ romá ní mengị moko go.” ");
INSERT INTO bdh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sɨmɨ bɨ kára née lurú ledre bɨ mengị roné kenée ní, bi lóꞌbo a ndaá lolụ wá, zɨ́a ị́nyịné tɨ́ do komo tụ́ꞌdụ́ ꞌyị ga gére née ógụ útúne sị́ sịndị́ Yésụ úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, máóto sị́lị́ma máa royị́ gɨ zɨ́a mááyí kɨ́ ndíyá, gɨ zɨ́ kéyị née, ndíyá bɨ romá ní ụkụ́ go.” ");
INSERT INTO bdh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Zɨ́a úku ledre zɨ́ kára née kɨ́dí, “Owụ́ ꞌbɨ amáa, ndíyá ụkụ́ gɨ royị́ gɨ zɨ́a bɨ ṇgúṇgu ledremá ní. Ndéré yị́ eyị́ mu, mɨmbéꞌdeyị́ idí ídí teéteké.” ");
INSERT INTO bdh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sɨmɨ bɨ Yésụ nɨ ngbụ́rụ́ ndị́sị úku ledre máa wo née yá, sanda ogụ go zɨ́ Yáyiro mongụ́ ꞌyị bɨ ndịsị lúrú bi kacɨ́ ꞌDị́cị́ Kótrụro ꞌbɨ Lomo ní kɨ́dí, “Owụ́ otoomo ꞌdówụ́ go, ndá lolụ ndolo mongụ́ née zɨ́a ndéréne gbékpị́e wá.” ");
INSERT INTO bdh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sɨmɨ bɨ Yésụ uwú ledre bɨ ukunɨ́ zɨ́ Yáyiro kenée ní, zɨ́a óyó komoné úku ledre zɨ́ Yáyiro kɨ́dí, “Mɨmbéꞌdeyị́ ndaá ꞌdécị gɨ zɨ́ ledre bɨ ukunɨ́ née wá, ídí lá ṇguṇgu ledremá kɨ́dí rokoꞌbụ nɨ bo zɨ́ma, owụ́ ꞌbɨ eyị́ née nɨ ómo ené.” ");
INSERT INTO bdh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Zɨ́ Yésụ ị́nyịyé gɨ ore mbá ndéréye ꞌbe ꞌbɨ Yáyiro íri. Sɨmɨ bɨ Yésụ ayí ólụ́ ꞌdị́cị́ íri ní, zɨ́a úku ledre dụụ́ zɨ́ ꞌyịmɨkása ené e ota. Née kóo Pétero e kɨ́ Yiwáni nda kɨ́ Yakóbo. Nda lá dụụ́ ꞌbụmɨowụ́ kɨ́ mbágáa zɨ́ye ólụ́ye ꞌdị́cị́ ini. ");
INSERT INTO bdh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ini nɨ kenée mɨndéréne. Zɨ́ Yésụ maꞌdáa ị́nyịné ụ́cụómo ꞌyị e kɨ́dí, “Ndásé íni ini wá, owụ́kára ba uyu ené e wá, ꞌduꞌdu yị́ ené lá mɨꞌdúꞌdu.” ");
INSERT INTO bdh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Zɨ́ ꞌyị ga bɨ ndịsịnɨ́ íni ini née útúye kúkugú gɨ zɨ́a owonɨ́ tɨ́ go owụ́kára née uyu go mɨúyu maꞌdíi. ");
INSERT INTO bdh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Zɨ́ Yésụ ꞌdíꞌbi sị́lị́ umbu do úku ledre kɨ́dí, “Owụ́ ꞌbɨ amáa, ị́nyịógụ mu.” ");
INSERT INTO bdh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Beré, zɨ́ owụ́kára líkpíphụ́trụ komoné, zɨ́ ꞌdówụ́ a ndáꞌbaógụné. Zɨ́a úku ledre kɨ́dí idínɨ́ íꞌbí éyị́ mɨánu zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zɨ́ tara mbágá owụ́ née kɨ́ ꞌbụa ị́drị́ye mbá mɨị́drị́. Tɨ́ lá zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí ledre bɨ mengị roné née ndanɨ́ úku a zɨ́ ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sɨmɨ bɨ Yésụ ndolo yoko ꞌyịmɨkása ené ga bɨ ịnyị doa gbre go mbá do bi kị́éꞌdo ní, zɨ́a íꞌbí cóngó ro kɨ́ rokoꞌbụ zɨ́ye gɨ ro zɨ́ye rómo komo bɨcayi lomo e kɨ́e kpá gɨ ro zɨ́ye ndị́sịyé ꞌdíꞌbióyó ndíyá kɨ́e gɨ ro ꞌyị e ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Zɨ́a kása yée kɨ́dí, “Ndérésé mu kɨ́ ꞌdódo bɨlámá ledre bɨ gɨ ro ꞌbe ꞌbɨ Lomo ní, zɨ́se kpá kɨ́ sị́kpị ꞌyị e gɨ do ndíyá eyé e.” ");
INSERT INTO bdh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Zɨ́a kpá úku ledre zɨ́ye kɨ́dí, “Sɨmɨ bɨ ásé go ndéré ní, ndásé ídí kɨ́ sómụ́ ledre gɨ ro ꞌdíꞌbi éyị́ ga bɨ káa zɨ́ ngbángbá ní, togụ́ kombo, togụ́ ambata, togụ́ mbú késị́, nda kɨ́ ngíti géyị bongó e, gɨ ro zɨ́ éyị́ máa ga gére née sáká sée wá. ");
INSERT INTO bdh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Togụ́ ógụsé go sɨmɨ ngíti ꞌbe, mị́ngị́ ꞌbe maáge ꞌdiꞌbinɨ́ sée go sɨmɨ sụmụ yá, ndásé ndéréókpó wá, ídísé ndị́sị ore. ");
INSERT INTO bdh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ꞌBe bɨ ógụsé sɨmɨ a ꞌdiꞌbinɨ́ sée sɨmɨ sụmụ wá ní, ídísé ụ́ꞌbụ́ ꞌbụrụ bɨ gɨ ro sịndị́se cịkị ore zɨ́a ꞌdódo a kɨ́dí asinɨ́ go gɨ ro bɨlámá ledre amá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yóó, zɨ́ ꞌyịmɨkása ga gére née ndéréye kacɨ́ tara ꞌbe ga bɨ ore ní za mbá kɨ́ úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị e kpá kɨ́ ꞌdíꞌbióyó ndíyá gɨ ro ꞌyị e ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Zɨ́ ngíti géyị ꞌyị e úku ledre ga bɨ Yésụ ndịsị méngị yée née mbá zɨ́ Eróde Andipá. Ngíti géyị somụ́nɨ́ ꞌbɨ eyé kɨ́dí Yésụ nɨ Yiwáni ꞌyị íꞌbí babatị́za zɨ́ ꞌyị e bɨ kóo ufunɨ́ wo ní urú go ne gɨ sɨmɨ umbu ndịsị méngị ledre ga gére née ne. Zɨ́ ledre máa née kóo sínyíne mɨsínyí ro Eróde. ");
INSERT INTO bdh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngíti géyị yá Yésụ nɨ nda mbú nébị kóo kɨ́ ịrịné Ilíya ní urú ne gɨ sɨmɨ umbu zɨ́a ndị́sịné méngị ledre ga gére ní, ngíti géyị ya nɨ ngúru ꞌyị gɨ dongará nébị ga kóo uyunɨ́ ꞌdesị́ ní urúne zɨ́a ógụné ndị́sị méngị ledre ga gére ní. ");
INSERT INTO bdh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Zɨ́ Eróde ndị́sịné úkulóꞌbó ledre zɨ́ne kɨ́ roné kɨ́dí, “ꞌYị née ndaá Yiwáni wá. Gɨ zɨ́a ufunɨ́ kóo Yiwáni go, do óṇgo ꞌdécị goa tụ, ayí úrú láráne kɨ́e ꞌdi? Née ndaá wo wá. Togụ́ kenée yá, máíli aka lúrú wo cụ́ kɨ́ komomá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zɨ́ ꞌyịmɨkása ga bɨ Yésụ kasa yée ndéré kɨ́ úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị e ní ndáꞌbaógụyé, zɨ́ye úku ledre ga bɨ mengịnɨ́ yée íri ní mbá zɨ́ Yésụ. Gɨ do kacɨ́ ledre ga gére ní, zɨ́ Yésụ maꞌdáa ꞌdíꞌbi yée ndéré kɨ́ye sɨmɨ ngíti owụ́ gara ꞌbɨ Galiláya ore kɨ́ ịrịné Beteseyị́da. ");
INSERT INTO bdh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Zɨ́ ꞌyị e úwú ledre a kɨ́dí nderénɨ́ go kɨ́ ꞌyị lódụ́ kacɨ́ne e sɨmɨ Beteseyị́da, zɨ́ye lódụ́ógụ wo gị íri. Zɨ́a ꞌdíꞌbi yée sɨmɨ sụmụ do ndị́sịné úku bɨlámá ledre gɨ ro ꞌbe ꞌbɨ Lomo zɨ́ye. Zɨ́a ndị́sịné kpá kɨ́ sị́kpị ꞌyị máa yée ga bɨ kɨ́ ndíyá ní gɨ do ndíyá eyé e. ");
INSERT INTO bdh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sɨmɨ bɨ ꞌyịmɨkása ené e lurúnɨ́ kɨ́dí kadra utú go ní, zɨ́ye ógụyé úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, lurúzé kadra utú go ili go zɨ́ ꞌyị ga gére née báyiyé ndéréye do bi ga bɨ nɨyí útúásá ndíki bi ꞌdúꞌdu kɨ́ éyị́ mɨánu zɨ́ye doa gɨ zɨ́a bi bɨ azé doa ba yị́ ené owụ́ bi, bi ꞌdúꞌdu kɨ́ éyị́ mɨánu utúasá ídí ona gɨ ro sáká tụ́ꞌdụ́ ꞌyị e káa zɨ́ née wá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zɨ́ Yésụ úkulúgu ledre zɨ́ ꞌyịmɨkása ené ga gére née kɨ́dí, “Ásé íꞌbí éyị́ mɨánu zɨ́ye.” Zɨ́ ꞌyịmɨkása ga gére née úkulúgu ledre zɨ́a kɨ́dí, “Ɨ́, mongụ́ ꞌyị, azé ndíki éyị́ mɨánu íꞌbí a zɨ́ tụ́ꞌdụ́ ꞌyị e káa zɨ́ née gɨ ꞌda? Odụ éyị́ bɨ zɨ́ze ona lá dụụ́ ambata e ịnyị kɨ́ mɨóngbó kénzé e gbre. Née ndaá éyị́ bɨ nɨ méngị moko ní wá. ꞌBúó azé ꞌdíꞌbi mongụ́ komo késị́ ndéré úgú éyị́ mɨánu kɨ́e tée?” ");
INSERT INTO bdh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ꞌYị ga gére née nɨyí kóo tụ́ꞌdụ́, yaꞌdá e ngúcuyé nɨyí ꞌbɨ eyé álifu ịnyị (5,000). Zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ífi báyisé yée idínɨ́ ndị́sị bi, do bi e kékị́éꞌdo cị́ gbre doa sokó (50).” ");
INSERT INTO bdh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Zɨ́ ꞌyị lódụ́ kacɨ́ga ífi báyi ꞌyị ga gére née tɨ́ kenée káa zɨ́ bɨ Yésụ uku ní, zɨ́ ꞌyị e ndị́sịyé bi. ");
INSERT INTO bdh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Zɨ́ Yésụ ị́nyịné ꞌdíꞌbi ambata ga bɨ ịnyị kɨ́ kénzé ga bɨ gbre née, zɨ́a sị́kpị a ꞌdága, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo gɨ roa, zɨ́a ꞌdíꞌbi ambata, zɨ́a ꞌdéwe sɨmɨ a. Zɨ́a íꞌbí kása a zɨ́ ꞌyị lódụ́ kacɨ́ne e, idínɨ́ íꞌbí a zɨ́ ꞌyị ga gére née ánu a. ");
INSERT INTO bdh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Zɨ́ ꞌyị ga gére née ánu éyị́ zɨ́ye léreyé mbá. Zɨ́ ꞌyịmɨkása e ụ́nzụ ꞌdúcu gbété e sokó doa gbre (12) kɨ́ ngítí éyị́ mɨánu ga bɨ idíakánɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sɨmɨ ngíti sịndị́ kadra zɨ́ Yésụ ị́nyịné lá kɨ́ ꞌyị lódụ́ kacɨ́ne e ndéréye lé do ngíti owụ́ bi kɨ́ꞌdí bɨ ngárá tụ́ꞌdụ́ ꞌyị e ndanɨ́ íri wá ní, zɨ́a ndị́sịné íni ini zɨ́ Lomo. Zɨ́a ị́nyịné ndúꞌyú ꞌyịmɨkása ené ga gére née kɨ́dí zɨ́ye na, “Úkusé aka mbigí ledre zɨ́ma, ꞌyị e ndịsịnɨ́ úku ledre gɨ do bimá kɨ́dí mááyí amá kú mbị́ náambi?” ");
INSERT INTO bdh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Zɨ́ ꞌyịmɨkása ené ga gére née úkulúgu ledre e zɨ́a mbá mɨngúngúcua, “Ngíti géyị ya nɨ Yiwáni ꞌyị Bábátị́zị́ ꞌyị e kóna ní, ngíti géyị ya ɨ́ꞌɨ, nɨ nébị kóo ꞌdesị́ kɨ́ ịrịné Ilíya ní, ngíti géyị ya nɨ ngúru nébị gɨ dongará nébị ga kóna uyunɨ́ ní urú ne zɨ́a ndáꞌbaógụné née.” ");
INSERT INTO bdh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zɨ́a nda ndúꞌyú za cụ́ sómụ́ ledre ꞌbɨ ꞌyịmɨkása ené ga gére née kɨ́dí, “Sara aka nda sée, ndị́sịsé ꞌbɨ esé úku a dongaráse ní kɨ́dí, mááyí náambi?” Zɨ́ ngúru ꞌyịmɨkása ené bɨ Pétero ní úkulúgu a zɨ́a kɨ́dí, “Áyí Kɨ́résịto, wo bɨ Lomo kasa wo ógụ yómo zée ꞌyịmaꞌdí e ní.” ");
INSERT INTO bdh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Zɨ́ Yésụ ésị sị́lị́ne komoyé kɨ́dí, “Ndásé aka úku ledre née zɨ́ ꞌyị e wá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zɨ́ Yésụ kpá úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Gɨ zɨ́a bɨ mááyí Owụ́ ꞌbɨ ꞌYịmaꞌdí ní, ngíti géyị mɨngburoko ꞌyị e kɨ́ mɨngburoko manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e zɨ́ Lomo ní, nda kɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌdódo lorụ ní nɨyí úfu máa, sɨmɨ sị́lị́ ota zɨ́ma úrúma.” ");
INSERT INTO bdh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Zɨ́ Yésụ úku ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga gére née kɨ́dí, “Máúku zɨ́se maꞌdíi, togụ́ ꞌyị ili ídíne ꞌyị lódụ́ kacɨ́ma, idí ídí nzíyiné gɨ ro úyu gɨ romá. ");
INSERT INTO bdh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ꞌYị bɨ ili yómo roné ne kɨ́ roné ní, nɨ úyu ené gɨ zɨ́a utúasá ené yómo roné wá. Wo bɨ nɨ ótoómo roné mbá zɨ́ma, togụ́ umbu yá, née idí úyu kɨ́ lódụ́ kacɨ́ma ní, mááyí yómo wo. ");
INSERT INTO bdh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wo be ꞌdi emene, zɨ́yị óyó sogoyị́ zɨ́ tụ́ꞌdụ́ gbékpị́ éyị́ ga bɨ ꞌbɨ do sogo káṇgá ba mbá zɨ́yị ndị́sịyị́ lódụ́ dụụ́ kacɨ́ma gɨ ro zɨ́yị ídíyị kɨ́ trịdrị bɨ za fí ní? ");
INSERT INTO bdh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sɨmɨ odụ sịndị́ kadra kɨ́ꞌdí bɨ karanée Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ do sogo káṇgá ba kɨ́ maláyika e kpá kɨ́ rokoꞌbụ bɨ Babá iꞌbí zɨ́ma ní, mááyí kpá ási gɨ ro ꞌyị bɨ asi kɨ́ úwú ledre amá ní. ");
INSERT INTO bdh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Máúku zɨ́se maꞌdíi, ngíti géyị ꞌyị e gɨ dongaráse bɨ ásé tóro née utúasánɨ́ aka úyu cakaba wá, ꞌbúó togụ́ lurúnɨ́ rokoꞌbụ ꞌbɨ ꞌbe ꞌbɨ Lomo go.” ");
INSERT INTO bdh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sɨmɨ sị́lị́ ịnyị doa ota gɨ do kacɨ́ ódro née ní, zɨ́ Yésụ ị́nyịné ꞌdíꞌbi ꞌyịmɨkása ené ota, née kóo Pétero, Yiwáni, nda kɨ́ Yakóbo, zɨ́ye ndéréye do ngíti mongụ́ landa do bi ené bɨ utúasá komoa gɨ ro zɨ́ne ndị́sịné doa íni ini zɨ́ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sɨmɨ bɨ nɨ aka cịkị íni ini zɨ́ Lomo ní, zɨ́ rokoꞌbụ ꞌbɨ Lomo óyólóꞌbó tosoa, zɨ́ toso sɨmɨ komoa óyólóꞌbó roné kpị́, zɨ́ bongó bɨ roa ní ényị́ne kpɨ́lélé. ");
INSERT INTO bdh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Zɨ́ yaꞌdá e gbre Mụ́sa e kɨ́ Ilíya, ");
INSERT INTO bdh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ólụ́ógụyé sɨmɨ rokoꞌbụ ꞌbɨ Lomo zɨ́ye ndị́sịyé ódroyé dongaráye kɨ́ Yésụ. Ndịsịnɨ́ kóo úku mɨsiꞌdi ledre umbu bɨ Yésụ nɨ ndéré úyu a sɨmɨ Yerụsaléma ní. ");
INSERT INTO bdh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sɨmɨ bɨ nɨyí ndị́sị ódro ní, zɨ́ Pétero e kɨ́ lafúne ga bɨ gbre née útúye ꞌdúꞌduyé. Zɨ́ye gbúgbu úrúye ndíki Yésụ kɨ́ yaꞌdá ga bɨ gáa gbre ogụnɨ́ zɨ́a ní. Zɨ́ rokoꞌbụ ꞌbɨ Lomo oto wo zɨ́ roa ndị́sị ṛíṛí mɨṛíṛí. ");
INSERT INTO bdh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sɨmɨ bɨ Pétero lurú kɨ́dí yaꞌdá ga gére née nɨyí go ndéré eyé ní, zɨ́ Pétero maꞌdáa úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, ꞌyị ga gére née ayínɨ́ nda ndéré ꞌda, idízé ndị́sị kéye ona. Azé yéme kụ́tụ́ ota (3) zɨ́se kéye, kị́éꞌdo zɨ́yị, ngíti a zɨ́ Mụ́sa ngíti a nda ꞌbɨ ené zɨ́ Ilíya.” Pétero uku ledre née lá sɨmɨ mɨtụlụrụ owo wá. ");
INSERT INTO bdh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sɨmɨ bɨ Pétero nɨ aka cịkị ndị́sị úku ledre née kenée ní, zɨ́ rokoꞌbụ ꞌbɨ Lomo ógụné káa zɨ́ bụṛụngụ́ ní, sólụ Yésụ kɨ́ yaꞌdá ga gére née nda kɨ́ Pétero e kɨ́ lafúne ga gére née yeré. Zɨ́ ngịrị méngị Pétero e gɨ zɨ́ ledre née mɨméngị kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Zɨ́ Lomo úku kása ledre kpụrụ́ gɨ sɨmɨ bụṛụngụ́ née zɨ́ Pétero e kɨ́ lafúne ga gére née kɨ́dí, “Ba Owụ́ ꞌbɨ amá, mágélé wo máa. Ídísé úwú ledre gɨ taraa.” ");
INSERT INTO bdh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sɨmɨ bɨ Lomo odro go zɨ́ye ní, nɨyí ídí kɨ́e ní Mụ́sa e kɨ́ Ilíya ndanɨ́ eyé lolụ wá, nda lá Yésụ ngúcuné. Sɨmɨ sịndị́ kadra bɨ kóo née, ukunɨ́ ledre née zɨ́ ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zɨ́ bi áráne kɨ́ phịyị́, zɨ́ye ndítíógụyé gɨ do landa gɨrí. Zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ otoomonɨ́ yée ore ní ógụyé zɨ́ Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ábuwá ngíti oꞌdo nɨ dongará ꞌyị ga gére née kɨ́rɨ́ née ndiki owụ́ kpálá kpó kị́éꞌdo owụ́ née bɨcayi lomo e olụ́nɨ́ go sɨmɨ a. Zɨ́ oꞌdo née ótrụ́ ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, ógụ aka yómo owụ́ ꞌbɨ amá, odụ owụ́ bɨ zɨ́ma ní tɨ́ dụụ́ née kị́éꞌdo née. ");
INSERT INTO bdh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bɨcayi lomo ga gére née ndịsị nda méngị wo bɨsinyíne kɨ́ lálaónzó wo bi zɨ́a ndị́sịné kɨ́ gbúrógbóne gɨ zɨ́ye, zɨ́ somụ́ ndị́sị ólụ́ógụné gɨ taraa kotrụ kotrụ kotrụ káa. Ili ndị́sị ótoómo wo wá ꞌbúó togụ́ lurú cóngó ro owụ́ née ụkụ́ go mɨụ́kụ́. ");
INSERT INTO bdh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Máꞌdíꞌbiógụ wo zɨ́ ꞌyị lódụ́ kacɨ́yị ga ba gɨ ro zɨ́ye lágaóyó dokéké ga gére née gɨ sɨmɨ a ní, utúasánɨ́ kɨ́e wá, zɨ́ma ndị́sịmá sóngó yị́ị ba.” ");
INSERT INTO bdh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zɨ́ Yésụ ị́nyịné úku ledre zɨ́ ꞌyịmɨkása ga gére née kɨ́dí, “Ílisé ṇgúṇgu ledre ꞌbɨ Lomo kɨ́ mɨmbéꞌdesé kị́éꞌdo wá gɨ zɨ́ ꞌdi. Azé ndị́sị go fú lá kése kenée?” Zɨ́a úku ledre zɨ́ ꞌbụmɨowụ́ née kɨ́dí, “Ógụ kɨ́ owụ́ née gɨrí mu yáa.” ");
INSERT INTO bdh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sɨmɨ bɨ owụ́ née nɨ go ógụ zɨ́ Yésụ ní, zɨ́ éyị́ kpá lálaónzó wo bi ndị́sị kángba wo bɨsinyíne. Zɨ́ Yésụ lágaóyó bɨcayi lomo ga gére née gɨ sɨmɨ a zɨ́a íꞌbílúgu wo zɨ́ ꞌbụa. ");
INSERT INTO bdh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Zɨ́ tara ꞌyị ga gére née ị́drị́ne mbá mɨị́drị́. Zɨ́ye úku ledre kɨ́dí, “Lurúzé mbigí rokoꞌbụ ꞌbɨ Lomo go cụ́ kɨ́ komozé.” Sɨmɨ bɨ ꞌyị e nɨyí aka fú kɨ́ ledre máa née yá, zɨ́ Yésụ óyólóꞌbó roné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ídísé úwú ledre ba zɨ́se óto a sɨmɨ dosé. Sịndị́ kadra nɨ ógụ do íꞌbí Owụ́ ꞌbɨ ꞌYịmaꞌdí zɨ́ ezeokóga.” ");
INSERT INTO bdh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Owoꞌdiꞌbinɨ́ ini ledre gɨ sɨmɨ ledre bɨ Yésụ uku née wá, gɨ zɨ́a nɨ yị́ ené mɨótoécịné gɨ zɨ́ye. Utúasánɨ́ kpá gbawá ndúꞌyú wo, gɨ zɨ́a ngịrị mengị yị́ ené yée mɨméngị. ");
INSERT INTO bdh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zɨ́ ꞌyị lódụ́ kacɨ́ Yésụ gére née tónóye go ndị́sị úkulóꞌbó ledre dongaráye yaá, “Ambí gɨ dongaráze ba nɨ ídíne manda ꞌdáꞌdá zɨ́ lafúne e ne?” ");
INSERT INTO bdh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zɨ́ Yésụ ꞌdíꞌbióto ngíti owụ́ tóroné cigíne gɨ zɨ́a owo sómụ́ ledre ꞌbɨ ꞌyịmɨkása ené ga gére née go. ");
INSERT INTO bdh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Lúrúsé owụ́ ba go? ꞌYị bɨ ꞌdíꞌbi owụ́ káa zɨ́ wo ba go sɨmɨ sụmụ gɨ romá ní, ꞌdiꞌbi máa go sɨmɨ sụmụ. ꞌYị bɨ ꞌdiꞌbi máa go sɨmɨ sụmụ ní, ꞌdiꞌbi kpá Lomo bɨ kasaogụ máa ní go sɨmɨ sụmụ. ꞌYị bɨ ndịsị ꞌbúóꞌbụ́ roné mɨꞌbúóꞌbụ́ ní, nɨ ídí kɨ́ ledrené owóowó zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zɨ́ Yiwáni ngúru ꞌyịmɨkása ꞌbɨ Yésụ ị́nyịné úku ledre zɨ́ Yésụ kɨ́dí, “mongụ́ ꞌyị, nderé ndikizé ngíti oꞌdo kɨ́ ndị́sị lága óyó bɨcayi lomo e gɨ sɨmɨ ꞌyị e kɨ́dí íꞌbí rokoꞌbụ zɨ́ne yị́ị. Zɨ́ze ụ́cụómo wo gɨ zɨ́a owozé bú ndaá ꞌbɨ ené ngúruzé wá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Zɨ́ Yésụ úkulúgu ledre zɨ́ Yiwáni kɨ́dí, “Ndásé ụ́cụómo wo wá. Ndịsị née go óto moko ezé zɨ́a ngbóró tátá roné. Née ndaá ezeokóze wá.” ");
INSERT INTO bdh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sɨmɨ bɨ sịndị́ kadra nɨ nda go gbóo gɨ ro zɨ́ Yésụ maꞌdáa ndáꞌbalúgu roné komo ere ní, zɨ́a yéme roné ndéréne sɨmɨ Yerụsaléma. ");
INSERT INTO bdh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Zɨ́a kása ꞌyị kasa ené e idínɨ́ yémeómo bi nzíyiné sɨmɨ ngíti owụ́ gara kɨ́ ịrịné Samáriya. ");
INSERT INTO bdh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sɨmɨ bɨ ꞌyị kasa ga bɨ Yésụ kasa yée née ogụnɨ́ íri ní, ꞌyị ꞌbɨ Samáriya e ya yée utúasánɨ́ eyé yémeómo bi zɨ́ Yésụ wá gɨ zɨ́a ndaá ꞌbɨ ené ṇgu eyé wá, ili ndéré ené mɨndéré sɨmɨ Yerụsaléma. ");
INSERT INTO bdh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zɨ́ ledre bɨ ꞌyị ꞌbɨ Samáriya e mengịnɨ́ ngárá ilinɨ́ yéme bi zɨ́ Yésụ wá ní sínyíne ro ꞌyị lódụ́ kacɨ́ Yésụ ga bɨ Yakóbo e kɨ́ Yiwáni ní. Zɨ́ye úku ledre zɨ́ Ngére Yésụ, idí úku ledre, Lomo idí ụ́cụógụ phoꞌdụ gɨ komo ere sɨmɨ Samáriya gɨ ro zɨ́ ꞌyị ga gére née áṛáónzó royé ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yésụ ya zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére ní, idínɨ́ ótoómo ledre née ꞌdáꞌba, sómụ́ ledre eyé née ndaá bɨlámáne wá. ");
INSERT INTO bdh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yóó, zɨ́ye ndéréókpóye, ꞌdúꞌduyé nda gbála sɨmɨ ngíti owụ́ gara kpị́. ");
INSERT INTO bdh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yésụ nɨyí aka fú do mɨsiꞌdi mɨndéréye sɨmɨ Yerụsaléma, zɨ́ye ndíkíye kɨ́ ngíti oꞌdo. Zɨ́ oꞌdo née úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, máíli zɨ́ze ndéréze kéyị kɨ́ꞌdí bɨ íli ndéré ní.” ");
INSERT INTO bdh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zɨ́ Yésụ úkulúgu ledre zɨ́ oꞌdo née kɨ́dí, “Máa Owụ́ ꞌbɨ ꞌYịmaꞌdí ꞌbe ndaá ꞌbɨ ené gɨ romá wá, mááyí yị́ amá ꞌyị gámá ꞌdáa ꞌdága gba oꞌdo bangá e nɨyí kɨ́ gu eyé ga bɨ ndịsịnɨ́ ólụ́ ꞌdúꞌdu sɨmɨ a ní. Kpá gba solụ́ e nɨyí mbá kɨ́ ꞌbe ꞌbɨ eyé e. Éyị́ ga gére née ndanɨ́ gɨ romá mbá wá, gbawá bi ꞌdówụ́ro zɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sɨmɨ ngíti sịndị́ kadra, zɨ́ Yésụ úku ledre zɨ́ ngíti oꞌdo kɨ́dí, “Ógụ mu lódụ́ máa.” Oꞌdo née ya zɨ́ Yésụ ní, “Ngére, máóto aka babá kí.” ");
INSERT INTO bdh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yésụ ya zɨ́a ní, ngíti géyị ꞌyị ga bɨ ṇguṇgunɨ́ ledremá wá ní, nɨyí yị́ eyé go káa zɨ́ umbu e ní, idínɨ́ ndị́sị cigí ꞌbụyị́ zɨ́ye óto wo. Yị́ị bɨ ṇgúṇgu ledremá go ba ní, ídí mu ndéré kɨ́ úku bɨlámá ledre bɨ gɨ ro ꞌbe ꞌbɨ Lomo ní zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kpá kenée sɨmɨ ngíti sịndị́ kadra, ngíti oꞌdo ya zɨ́ Yésụ ní, “Máṇgúṇgu ledreyị́ go Ngére, mááyí lódụ́ yị́ị. Tɨ́ lá ili aka zɨ́ma ndéréma ꞌdící kacɨ́ma zɨ́ ꞌyị amá e, zɨ́ma nda ndáꞌbaógụmá lódụ́ kacɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Máúku zɨ́yị, ꞌyị bɨ nɨ kɨ́ mɨsómụ́ ledre gbre gbre ní, utúasá ídí ꞌyị ꞌbe ꞌbɨ Lomo wá.” ");
INSERT INTO bdh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gɨ do kacɨ́ ódro ga bɨ Ngére Yésụ odro yée née mbá, wo Yésụ maꞌdáa zɨ́a ị́nyịné ndólo ꞌyị e cị́ ota doa sokó doa gbre (72) zɨ́a úkuíꞌbí ledre tarayé idínɨ́ ídí gbre gbre ndéré kɨ́ úku ledre zɨ́ ꞌyị e do bi ga bɨ née ili ndéréógụ doyé ní mbá. ");
INSERT INTO bdh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kɨ́dí, tụ́ꞌdụ́ ꞌyị e nɨyí go nzíyiyé gɨ ro ṇgúṇgu mɨkánda bɨlámá ledre bɨ máógụ kɨ́e ní, ꞌyị kasa eyenɨ́ aka zɨ́ma gɨ ro zɨ́ye ꞌdíꞌbi bɨlámá ledre máa ba báyiyé kɨ́e zɨ́ tụ́ꞌdụ́ ꞌyị e mbá wá. Káa zɨ́ bɨ Ngére Lomo nɨ ne mị́ngị́ moko maꞌdáa ní, ídísé íni ini zɨ́a idí géléógụ yata ꞌyị kasa e gɨ ro zɨ́ye báyiyé kɨ́ úku bɨlámá ledre ené zɨ́ ꞌyị e za mbá. ");
INSERT INTO bdh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ídísé mu ndéré. Ásé ídí dongará bɨsinyí ꞌyị e íri káa zɨ́ kábịṛị́kị ga bɨ dongará máárára e mị́ngị́ye ndaá ní. ");
INSERT INTO bdh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ndásé ꞌdíꞌbi komo késị́ gɨ ro ndéré kɨ́ úgú éyị́ mɨánu kɨ́e zɨ́se wá, gba kombo, ndásé ꞌdíꞌbi a wá, ndásé kpá ꞌdíꞌbi yata éyị́ sịndị́ drú yata wo bɨ sịndị́se ní wá. Ndásé kpá sínyi sịndị́ kadra kɨ́ íꞌbí mandá zɨ́ ꞌyị e do mɨsiꞌdi wá. ");
INSERT INTO bdh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ꞌBe bɨ ógụsé go sɨmɨ a ní, ídísé íꞌbí mandá. Gɨ do kacɨ́ a née, mɨzefị ledre bɨ ásé úku a zɨ́ye ní idí ídí kɨ́dí Lomo idí ídí kɨ́se sɨmɨ ꞌbe ba. ");
INSERT INTO bdh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Togụ́ mị́ngị́ ꞌbe née nɨ ꞌyị bɨ kɨ́ ledre ꞌbɨ Lomo do mɨmbéꞌdené ní, mandá bɨ ásé íꞌbí a kɨ́ úndru ꞌbɨ Lomo sɨmɨné ní, nɨ ídí káa do úndru sɨmɨ ꞌbe née. Togụ́ ledre ꞌbɨ Lomo ndaá ꞌbɨ ené sɨmɨ ꞌbe née wá, úndru ꞌbɨ Lomo ogụ ené ore kpá wá. ");
INSERT INTO bdh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ꞌBe bɨ ꞌdiꞌbinɨ́ sée go sɨmɨ a sɨmɨ sụmụ ní, ídísé ndị́sị dụụ́ ore, ndásé gámá faa wá. Éyị́ mɨánu esé e kɨ́ iní mɨéwé esé e idí ídí dụụ́ yée ga bɨ iꞌbínɨ́ go zɨ́se ore ní. Nɨ mɨútúásáne zɨ́ ꞌyị ꞌbɨ moko ndíki éyị́ kacɨ́ moko bɨ mengị wo ní. ");
INSERT INTO bdh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ꞌBe ga bɨ za mbá ásé ógụ sɨmɨyé ní, togụ́ mị́ngị́ye ꞌdiꞌbinɨ́ sée go sɨmɨ sụmụ yá, ídísé ndị́sị ore, zɨ́se ánu éyị́ ga bɨ nɨyí íꞌbí yée zɨ́se ore ní. ");
INSERT INTO bdh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Togụ́ ꞌyị ndíyá nɨyí ore yá, zɨ́se íni ini zɨ́ Lomo kɨ́ óto sị́lị́se doyé gɨ ro zɨ́ ndíyá eyé ụ́kụ́ne gɨ royé. Zɨ́se úku ledre ꞌbɨ Lomo zɨ́ye kɨ́dí, sịndị́ kadra ogụ go zɨ́ye, idínɨ́ mu ṇgúṇgu ledre ꞌbɨ Lomo gɨ ro zɨ́ye ógụyé ꞌbe ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ꞌBe bɨ ꞌdiꞌbinɨ́ sée sɨmɨ sụmụ wá ní, ídísé ólụ́ógụ ókpó esé, zɨ́se úku ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Azé go ụ́ꞌbụ́ ꞌbụrụ gɨ ro sịndị́ze ótoómo a cịkị zɨ́se ona. Ídísé ówo a kɨ́dí, sịndị́ kadra ꞌbɨ ledre ga bɨ ꞌbe ꞌbɨ Lomo ní, nɨ go gbóo.” ");
INSERT INTO bdh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gɨ do kacɨ́ ledre máa wo née, zɨ́ Yésụ úku ngíti ledre kpá zɨ́ ꞌyịmɨkása ga gére née gɨ ro ꞌyị ga bɨ nɨyí asi gɨ ro ledre ꞌbɨ Lomo ní kɨ́dí, “Máúku zɨ́se zaá maꞌdíi, ꞌyị ga bɨ za mbá nɨyí ási gɨ rosé ní, ꞌdoꞌdó bɨ Lomo nɨ íꞌbí a royé ní, nɨ rómo do wo bɨ kóo iꞌbí ro ꞌyị lúyú ledre ga bɨ kóo sɨmɨ káṇgá bɨ Sodóma ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Zɨ́a kpá úku ngíti ledre gɨ ro ꞌyị ga bɨ ndị́sị gámá kɨ́ ledre ꞌbɨ Lomo dongaráye ní kɨ́dí, “Sée ꞌyị ga bɨ ꞌbɨ gara Korazíni kɨ́ sée ga bɨ sɨmɨ Beteseyị́da ní, karanée ꞌdáꞌdá íri Lomo nɨ íꞌbí ꞌdoꞌdó rosé gɨ zɨ́a ílisé ṇgúṇgu ledre ené wá. Mɨngburoko ledre ga bɨ ꞌbɨ Lomo máméngị sɨmɨ gara esé ba, idí máméngị kóo née sɨmɨ gara ꞌbɨ ngíti géyị ꞌyị e káa zɨ́ yée ga bɨ sɨmɨ Táyire kɨ́ Sidóna ní, káa bɨ oyóloꞌbónɨ́ sómụ́ ledre eyé go, ṇguṇgunɨ́ ledre ꞌbɨ Lomo go ꞌdesị́. ");
INSERT INTO bdh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ídísé ówo a bɨlámáne kɨ́ꞌdí bɨ karanée Lomo ili go ꞌdécị ngbanga ꞌbɨ ꞌyịmaꞌdí e do sogo káṇgá ní, sée ꞌyị ꞌbɨ Korazíni kɨ́ Beteseyị́da, Lomo nɨ ꞌdóꞌdo sée rómo do ꞌbɨ Táyire kɨ́ Sidóna. ");
INSERT INTO bdh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kpá kenée gɨ rosé, sée ꞌyị ga bɨ sɨmɨ mongụ́ gara bɨ Kapáranawúma ní. Ndásé sómụ́ a bɨ kɨ́dí ꞌbɨ esé ledre nɨ ídí bɨlámáne kadra ꞌdécị ngbanga ní wá gɨ zɨ́a ásisé kpá kɨ́ ṇgúṇgu ledre ꞌbɨ Lomo go. Ásé ídí kpá sɨmɨ ꞌdoꞌdó kɨ́ umbu bɨ odụ a ndaá ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zɨ́ Yésụ maꞌdáa nda kpá úku ngíti ledre zɨ́ ꞌyị ga bɨ nɨ kása yée née kɨ́dí, “Togụ́ ꞌyị asi gɨ rosé, asi née go kpá gɨ romá. Togụ́ ꞌyị ꞌdiꞌbi sée sɨmɨ sụmụ, ꞌdiꞌbi née go kpá máa sɨmɨ sụmụ. Wo bɨ asi gɨ romá go ní, asi née go kpá gɨ ro Lomo bɨ kasaogụ máa ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sɨmɨ bɨ ꞌyị ga bɨ Yésụ kasa yée ndaꞌbaogụnɨ́ ní, zɨ́ye úku ledre zɨ́ Yésụ kɨ́ mongụ́ rokinyi kɨ́dí, “Ngére, sɨmɨ bɨ ndịsịzé ꞌdódo ledre eyị́ zɨ́ ꞌyị e ní, zɨ́ bɨcayi lomo e ndị́sịyé éré ngịrị gɨ zɨ́ ịrịyị́ bɨ ndịsịzé ị́fị́ a ní, zɨ́a ndị́sị ngásáóyó roné.” ");
INSERT INTO bdh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Málúrúndíki Satána go kɨ́ útúóyo roné gɨ komo ere káa zɨ́ mɨꞌbɨ́léꞌbe iní ní. ");
INSERT INTO bdh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rokoꞌbụ née nɨ gɨ ro zɨ́se ndị́sịsé méngị okó kɨ́ Satána kɨ́e, zɨ́se kɨ́ rómo komoa sɨmɨ ledre e za mbá za fí utúasá úfu trịdrịsé wá. ");
INSERT INTO bdh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ndásé ídí kɨ́ rokinyi lá gɨ zɨ́a bɨ bɨcayi lomo e ngasáoyónɨ́ royé gɨ zɨ́se ní go wá. Ídísé ídí kɨ́ rokinyi gɨ ro ịrịsé bɨ Lomo nɨ éké a sɨmɨ bụ́kụ ꞌbɨ trịdrị komo ere ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sɨmɨ kadra bɨ kóo née ní, zɨ́ ꞌDówụ́ Lomo óto Yésụ zɨ́a ídíne kɨ́ rokinyi, zɨ́a úku ledre zɨ́ Lomo kɨ́dí, “Babá, áyí Ngére do ere kpá kɨ́ do sogo káṇgá mbá, mbófo éyị́ zɨ́yị, zɨ́yị ótoécị rokoꞌbụyị́ gɨ zɨ́ ꞌyị ga bɨ ndịsịnɨ́ óto royé kɨ́ royé káa do ꞌyị ówo ledre e ní, zɨ́yị nda ꞌdódo a zɨ́ yée ga bɨ ꞌyị ówo ledre e lurúnɨ́ yée moko ndaá sɨmɨyé wá ní. Méngị ꞌdị́yị kenée gɨ zɨ́a née ledre bɨ utúasá mɨútúásá kacɨ́ komoyị́ ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zɨ́a kpá úku ledre kɨ́dí, “Babá, otoomo ledre e go za mbá do sị́lị́ma gɨ zɨ́a owoyeme máa dụụ́ ne. Kpá káa zɨ́ bɨ máówoyéme wo dụụ́ máa ní. ꞌYị máa yée ga bɨ ṇguṇgunɨ́ ledre amá go, nɨyí go ꞌyị amá e ní, mááyí ꞌdódoyéme wo zɨ́ye.” ");
INSERT INTO bdh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sɨmɨ bɨ Yésụ nɨyí nda go céré ye kɨ́ ꞌyị lódụ́ kacɨ́ne e ní, zɨ́a úku phụ́trụ ledre zɨ́ye kɨ́dí, “Lúrúsé go, Lomo mengị bɨlámá ledre go zɨ́se, ndị́sịsé go lúrú a kɨ́ méngị mɨngburoko ledre ga bɨ kɨ́ rokoꞌbụyé ní cụ́ kɨ́ komosé. ");
INSERT INTO bdh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Máúku ledre née zɨ́se gbékpị́ne wá. Tụ́ꞌdụ́ nébị e kɨ́ mɨngburoko ngére tonónɨ́ kóo go ꞌdesị́ óto komoyé gɨ ro zɨ́ye lúrú ledre ga bɨ ásé lúrú yée ba, tɨ́ lá lurúndikinɨ́ wá, kpá gɨ ro úwú ledre ga bɨ ásé úwú yée ba, uwúnɨ́ kpá wá.” ");
INSERT INTO bdh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gɨ do kacɨ́ ledre ga gére ní, nda go kpá sɨmɨ ngíti sị́lị́, zɨ́ ngúru mongụ́ ꞌyị ꞌdódo lorụ ga bɨ ꞌbɨ Lomo, ị́nyịógụ tóroné ꞌdága úzu Yésụ kɨ́ꞌdí bɨ Yésụ nɨ ꞌdódo ledre zɨ́ ꞌyị e ní kɨ́dí, “Mongụ́ ꞌyị, éyị́ bɨ máídí méngị a gɨ ro zɨ́ma ndíki trịdrị bɨ za fí ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yésụ ya zɨ́a ní, “Sara bɨ áyí tɨ́ mongụ́ ꞌyị ꞌdódo lorụ ní, lorụ maꞌdáa uku yaá ꞌdi? Sara ndị́sị ólo a zɨ́yị ndị́sịyị́ ꞌdódo a zɨ́ ꞌyị e lárá a káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “ ‘Ídí óto ꞌbú Ngére bɨ Lomo eyị́ ní kɨ́ mɨmbéꞌdeyị́ kị́éꞌdo, kɨ́ lomo royị́ mbá za kɨ́ rokoꞌbụyị́ kɨ́ sómụ́ ledre eyị́ mbá.’ ‘Zɨ́yị óto ꞌbú lafúyị e káa zɨ́ bɨ óto ꞌbúyị kɨ́ royị́ ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zɨ́ Yésụ úkulúgu ledre zɨ́ oꞌdo bɨ gáa née kɨ́dí, “Bɨlámáne, ídí méngị ledre ga gére née kenée, áyí ndíki trịdrị bɨ za fí ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Oꞌdo née ili kpá fú óto roné zɨ́ Yésụ kɨ́dí ledre bɨ née ndịsị úku a née, née owoyeme bú. Zɨ́a ndúꞌyú Yésụ kɨ́dí “Lafúma ga bɨ máídí óto ꞌbúye ní náambi?” ");
INSERT INTO bdh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zɨ́ Yésụ úkulúgu ledre zɨ́ oꞌdo née do ngíti mɨsiꞌdiné kpị́ kɨ́dí, “Kadra kị́éꞌdo, ngíti oꞌdo ịnyị kóo gɨ sɨmɨ Yerụsaléma ndéréne sɨmɨ ngíti owụ́ gara kɨ́ ịrịné Zérịko, zɨ́ ꞌyị ugu e útúye roa ócó wo gbóo kɨ́ umbu zɨ́ye ngáka éyị́ ené e gɨ roa mbá do ngásáókpó eyé ótoómo wo ngbali bi kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kutrú gɨ do kacɨ́ ꞌyị ugu ga bɨ ngasá bayinɨ́ royé née ní, zɨ́ ngúru ꞌyị ꞌdáná éyị́ ógụné kpá kacɨ́ mɨsiꞌdi née. Zɨ́a ógụndíki oꞌdo née ngbali bi. Zɨ́a ꞌdécị bi gɨ dogboṛụ mɨsiꞌdi yóó, ókpó ené. ");
INSERT INTO bdh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zɨ́ ngíti oꞌdo gɨ sɨmɨ kúfú ꞌyị ga bɨ ndịsịnɨ́ ndolo yée Lévị e ní, nɨ kpá ꞌyị méngị moko sɨmɨ ꞌDị́cị́ Kótrụro ꞌbɨ Lomo. Sɨmɨ bɨ lurú oꞌdo née ngbali bi ní, zɨ́a kpá ꞌdécị bi yóó do ókpó ené. ");
INSERT INTO bdh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Zɨ́ ꞌyị ꞌbɨ Samáriya ógụndíki oꞌdo née kpá fú ngbali bi, zɨ́ lerị́ oꞌdo née méngị wo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Zɨ́ Samáriya née ndósoógụné truú ro oꞌdo née do sị́kpị wo ꞌdága. Zɨ́a lúgu uṇgú ga bɨ roa née drá, zɨ́a óto kágá komo a do ódó a. Zɨ́a ị́mbị́ óto wo do bangá ené bɨ ndịsị ị́mbị́ ꞌyị ní ndéré óto wo sɨmɨ ꞌdị́cị́ ꞌbɨ ṇgu e gɨ ro do lúrú bi kacɨ́ a ore. ");
INSERT INTO bdh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sɨmɨ bɨ bi aráloꞌbó roné ní, zɨ́a ótoómo késị́ zɨ́ ꞌyị bɨ ndịsị lúrú bi kacɨ́ bi máa née. Zɨ́a úkuómo ledre kɨ́dí togụ́ késị́ ba ụkụ́ go, ídí kpá lúrú kacɨ́ a kɨ́ késị́ bɨ nɨ bo ní, mááyí ndáꞌbaógụ íꞌbílúgu a. ");
INSERT INTO bdh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sɨmɨ bɨ Yésụ ukuonzó ledre ga gére née go ní, zɨ́a ị́nyịné ndúꞌyú ꞌyị ꞌdódo lorụ née kɨ́dí, “Sɨmɨ sómụ́ ledre eyị́ ní, gɨ dongará yaꞌdá ga bɨ ota máúku ledreyé née, ambí mengị bɨlámá ledre zɨ́ ꞌyị bɨ ꞌyị ugu e ocónɨ́ wo ní ne?” ");
INSERT INTO bdh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “ꞌYị bɨ saká oꞌdo bɨ ꞌyị ugu e ocónɨ́ wo ní mengị bɨlámá ledre ne.” Yésụ ya zɨ́a ní úku go maꞌdíi, “Ndéré mu zɨ́yị ndị́sịyị́ méngị bɨlámá ledre zɨ́ ꞌyị e kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yésụ nɨyí aka kpá fú do mɨsiꞌdi mɨndéréye sɨmɨ Yerụsaléma. Zɨ́ye ndéréógụyé sɨmɨ gara bɨ Márata e kɨ́ lémịné nɨyí sɨmɨ a ní. Zɨ́ Márata ꞌdíꞌbi yée ꞌbe ꞌbɨ ené ore sɨmɨ sụmụ. ");
INSERT INTO bdh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Zɨ́ Maríya lémị Márata maꞌdáa ndéré ndị́sịné cigí Ngére Yésụ ndị́sị úwú ledre ꞌbɨ Lomo bɨ ndị́sị ꞌdódo a ní. ");
INSERT INTO bdh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gɨ zɨ́a bɨ Márata ꞌdiꞌbi nda ambá sịndị́ kadra go ngúcuné sɨmɨ moko ndị́sị yéme éyị́ mɨánu zɨ́ Yésụ kɨ́ ꞌyị kasa ené e ní, zɨ́a ógụné úku ledre kɨ́dí, “Ngére, úku aka ledre zɨ́ Maríya idí ógụ sáká máa. Lúrú aka mongụ́ moko bɨ mándị́sị méngị a lá ngúcumá ba, nɨ nda lá ndị́sị ené cigíyị íri gbékpị́ne ní.” ");
INSERT INTO bdh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zɨ́ Ngére Yésụ úkulúgu ledre zɨ́ Márata kɨ́dí, “Márata ndá óto tụ́ꞌdụ́ gbékpị́ ledre ga gére née kɨ́ ledreyé zɨ́yị owóowó wá. ");
INSERT INTO bdh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lémịyị́ gelé go ledre ꞌbɨ Lomo gɨ ro ndị́sị úwú a. Née go éyị́ bɨ kɨ́ ledrené owóowó rómo do ledre e za mbá ní. Utúasánɨ́ ꞌdíꞌbióyó a gɨ zɨ́a wá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kadra kị́éꞌdo zɨ́ Yésụ lúrú ngíti owụ́ bi zɨ́a ndéré ndị́sịné doa íni ini zɨ́ ꞌBụné Lomo. Sɨmɨ bɨ ini asá ini go ní, zɨ́ ngúru ꞌyị lódụ́ kacɨ́ga ógụné ndúꞌyú wo kɨ́dí, “Ngére, ꞌdódo aka mɨsiꞌdi ꞌbɨ íni ini zɨ́ Lomo zɨ́ze káa zɨ́ bɨ kóo Yiwáni ꞌyị Bábátị́zị́ ꞌyị e ndịsị ꞌdódo a zɨ́ ꞌyị lódụ́ kacɨ́ne e ní.” ");
INSERT INTO bdh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Gɨ ore zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Togụ́ ásá gɨ ro íni ini zɨ́ Lomo yá, ídísé íni a káa, “ ‘ꞌBụzé, ịrịyị́ idí ídí kɨ́ úndruné, ꞌyị e za mbá idínɨ́ ówo yị́ị káa do Ngére eyé. ");
INSERT INTO bdh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ídí íꞌbí éyị́ mɨánu ezé ꞌbɨ karaba zɨ́ze. ");
INSERT INTO bdh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ídí ótoómo lúyú ledre ezé zɨ́ze, káa zɨ́ bɨ ndịsịzé ótoómo a zɨ́ yée ga bɨ ndịsịnɨ́ lúyú rozé ní. Ndá ótoómo zée zɨ́ze lúyú ledre gɨ zɨ́ úzu éyị́ wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zɨ́ Yésụ kpá fú ꞌdodo yata ledre kɨ́dí, “Togụ́ ngúru ꞌyị gɨ dongaráse nderé kɨ́ yana ndụlụ úku ledre zɨ́ eze ꞌbe ꞌbɨ ené kɨ́dí, ‘Togụ́ nzíyi éyị́ mɨánu nɨ bo do sị́lị́yị yá, sáká aka máa kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ṇgu ogụ go zɨ́ma cakaba, nzíyi éyị́ ndaá do sị́lị́ma zɨ́ma íꞌbí a zɨ́a wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Zɨ́ eze ꞌbe ꞌbɨ ené née úku kása ledre zɨ́a cịkị gɨ ꞌdị́cị́ gɨrí kɨ́dí, ‘Ndá ꞌdóꞌdo máa wá, mbotụ nɨ yị́ ené go mɨꞌdụ́tụné, azé yị́ ezé kɨ́ owụ́ e go kpá mbá mɨꞌdúꞌduzé. Éyị́ bɨ zɨ́ma ị́nyịógụmá íꞌbí a zɨ́yị cakaba ní ní ndaá ꞌbɨ ené e wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Abú eze ꞌbe ꞌbɨ ené née ili ị́nyịógụ méngị sáká éyị́ zɨ́a wá, nda lá gɨ zɨ́a bɨ nɨ fú lá ndị́sị ṇgúṇgú roné ní, zɨ́ eze ꞌbe ꞌbɨ ené née ị́nyịógụné íꞌbí sáká éyị́ nda za kɨ́ngaya rómo wo bɨ gáa ili ní.” ");
INSERT INTO bdh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Máúku zɨ́se, togụ́ ílisé éyị́, ídísé ómbo a, Lomo nɨ íꞌbí a zɨ́se. Éyị́ bɨ ílisé ní, ídísé gámásóꞌdo a, ásé ndíki a. Togụ́ ndị́sịsé kpá fú ṇgúṇgú rosé gɨ ro éyị́ yá, nɨyí íꞌbí a zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nɨ maꞌdíi, ꞌyị bɨ ndịsị ómbo éyị́ gɨ zɨ́ Lomo ní, nɨ íꞌbí a zɨ́a. Wo bɨ ndịsị gámásóꞌdo éyị́ kɨ́ ịrị Lomo ní, nɨ ndíki a. Wo bɨ ndịsị ṇgúṇgú roné gɨ ro éyị́ ní, Lomo nɨ líkpí mɨsiꞌdi a zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Sée ꞌbụmɨowụ́ e, togụ́ owụ́ ꞌbɨ eyị́ ombo kénzé gɨ zɨ́yị, gɨ ro zɨ́ne ánu a ní, áyí nda íꞌbí zɨ́a kámá? ");
INSERT INTO bdh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Togụ́ ombo gɨ zɨ́yị mbú ꞌbu ngono ní, áyí nda íꞌbí zɨ́a ágarabu? ");
INSERT INTO bdh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Togụ́ sée ꞌyịmaꞌdí e kɨ́ lúyú ledre rosé ówosé kacɨ́ íꞌbí bɨlámá éyị́ bú zɨ́ owụ́ ꞌbɨ esé e ní, ꞌBụsé Lomo bɨ komo ere ní, nɨ íꞌbí ꞌbɨ ené nda za cụ́ ꞌDówụ́ Lomo bɨ eme romo do éyị́ e mbá ní zɨ́ ꞌyị bɨ nɨ íni ini gɨ roa ní.” ");
INSERT INTO bdh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kadra kị́éꞌdo zɨ́ Yésụ lágaóyó bɨcayi lomo gɨ sɨmɨ ngíti oꞌdo. Geré zɨ́a oꞌdo née tónóne ódroné. Zɨ́ tara tụ́ꞌdụ́ ꞌyị ga bɨ ore née ị́drị́ye mbá mɨị́drị́. ");
INSERT INTO bdh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Zɨ́ ngíti ꞌyị gɨ dongará ꞌyị ga bɨ ore ní úku ledre kɨ́dí, Belezabụ́bụ bɨ ngére ꞌbɨ bɨcayi lomo e ní iꞌbí rokoꞌbụ ne zɨ́ Yésụ ndị́sịné lágaóyó bɨcayi lomo e kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Zɨ́ ngíti géyị ꞌyị ndúꞌyú wo idí méngị ledre bɨ kɨ́ rokoꞌbụ bɨ gɨ komo ere ní gɨ ro zɨ́ye lúrú a. ");
INSERT INTO bdh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yésụ owo sómụ́ ledre eyé née bú, zɨ́a úku ledre zɨ́ye kɨ́dí, togụ́ ꞌyị ꞌbɨ káṇgá kị́éꞌdo, togụ́ mbú ꞌbe kị́éꞌdo ndịsịnɨ́ méngị okó dengbị́ye yá, ꞌbe ꞌbɨ eyé née nɨ báyi ené. ");
INSERT INTO bdh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kpá kenée togụ́ Satána ndịsịnɨ́ méngị okó dengbị́ye yá, toro yemenɨ́ royé wá, nɨyí báyi eyé mɨbáya. Máúku ledre née kenée gɨ zɨ́a úku ledre kɨ́dí, Belezabụ́bụ iꞌbí rokoꞌbụ ne zɨ́ma lágaóyó bɨcayi lomo kɨ́e. ");
INSERT INTO bdh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Togụ́ málágaóyó bɨcayi lomo e kɨ́ rokoꞌbụ bɨ gɨ zɨ́ Belezabụ́bụ ní, sara ꞌyị esé e ndịsịnɨ́ lágaóyó yée kɨ́ rokoꞌbụ ꞌbɨ ambi? ꞌYị esé maáge nɨyí úku yéme a ye kɨ́dí sómụ́ ledre esé ndaá mbị́ wá. ");
INSERT INTO bdh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Togụ́ kenée wá, málágaóyó bɨcayi lomo e kɨ́ rokoꞌbụ ꞌbɨ Lomo, ꞌdodo go kɨ́dí Lomo ogụ go káa do Ngére dosé. ");
INSERT INTO bdh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mị́ngị́ ꞌbe bɨ nɨ yị́ ené kɨ́ rokoꞌbụné ní, ꞌyị ugu utúasá ndéré úgu éyị́ ené wá. ");
INSERT INTO bdh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ꞌBúó togụ́ rokoꞌbụ ꞌyị ugu romo do ꞌbɨ mị́ngị́ ꞌbe née go yá, nɨ nda fú ndéré ngáka ꞌbe née kɨ́ éyị́ ga bɨ sɨmɨ ꞌbe née mbá do ífibáya yée. ");
INSERT INTO bdh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ꞌYị bɨ ṇguṇgu ledre amá wá ní, nɨ okó romá. ꞌYị máa wo bɨ ndolo yoko ꞌyị e zɨ́ma wá ní, ndịsị báyi ꞌyị amá e. ");
INSERT INTO bdh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Togụ́ bɨcayi lomo olụ́ogụ go gɨ sɨmɨ ꞌyị, nɨ ndéré gámásóꞌdo kpá té ngíti ꞌyị gɨ ro ólụ́ ndị́sịné sɨmɨ a. Togụ́ ndiki ngíti ꞌyị mbá wá, nɨ úku ledre kɨ́dí, ‘Bɨlámá a máídí ndáꞌba kɨ́ꞌdí bɨ kóo mándị́sị ndị́sị ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“Togụ́ nderé ndiki ꞌDówụ́ Lomo ndaá sɨmɨ mɨmbéꞌde ꞌyị née fú lá wá, nɨ ídí ené kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nɨ ndéré ndóloógụ lafúne e bɨcayi lomo e ịnyị doa gbre yée ga bɨ nda bɨsinyíye kɨ́ngaya ní zɨ́ye ndị́sịyé kéye mɨmbéꞌde ꞌyị née, zɨ́ ꞌyị née nda sínyí tátá roné ꞌdáꞌdá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sɨmɨ bɨ Yésụ nɨ aka fú ndị́sị úku ledre ga gére ní, zɨ́ ngíti kára ore ị́nyịné úku ledre kɨ́dí, “Yésụ, mbágáyị bɨ ndiki yị́ị ní, Lomo íꞌbí úndru go zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zɨ́ Yésụ úkulúgu ledre kɨ́dí, “Lomo nɨ íꞌbí úndru zɨ́ ꞌyị ga bɨ ndịsịnɨ́ úwú ledre ené zɨ́ye ꞌdíꞌbióto a do mɨmbéꞌdeyé ní.” ");
INSERT INTO bdh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị e nɨyí fú lá ndị́sị ógụ ní, zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Sée ꞌyị luyú ledre e ga bɨ cakaba ba, ílisé lúrú ngíti ledre bɨ kɨ́ rokoꞌbụné ní. Útúásásé lúrú a wá, go tɨ́ lá wo bɨ kóo mengị Yóna ní. ");
INSERT INTO bdh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ledre bɨ mengị roné zɨ́ Yóna ní, ꞌdodo go zɨ́ ꞌyị ꞌbɨ Nịnévị kɨ́dí Lomo kasa wo ne. Kpá kenée, Máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, nɨ méngị roné zɨ́ma kenée gɨ ro zɨ́ ꞌyị ga bɨ cakaba ba, ówo a kɨ́dí Lomo kasaogụ Máa ne. ");
INSERT INTO bdh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mongụ́ ngére nɨ kóo bo kára, ịnyị kú gɨ sɨmɨ káṇgá ené Séba ógụ úwú ledre gɨ tara Solomóna. Nɨ karanée ꞌdécị ngbangasé, gɨ zɨ́a máa bɨ márómo gɨ do Solomóna ní, ílisé úwú ledre gɨ taramá wá. ");
INSERT INTO bdh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ꞌYị ꞌbɨ gara Nịnévị oyóloꞌbónɨ́ kóo mɨmbéꞌdeyé zɨ́ye ṇguṇgunɨ́ ledre ꞌbɨ Lomo gɨ zɨ́ Yóna. Nɨyí ꞌdécị ngbangasé, gɨ zɨ́a máa bɨ márómo do Yóna ní, ílisé ṇgúṇgu ledremá wá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ụndụotonɨ́ eyé Phoꞌdụ ꞌdị́cị́ do lóꞌbụꞌdụ́tụ a sị́ pheṛé wá, ndịsịnɨ́ óto a do nyárá bi gɨ ro zɨ́a óṇgó bi zɨ́ ꞌyị e ꞌdị́cị́ ore mbá. ");
INSERT INTO bdh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Komosé nɨ bimɨóṇgó. Togụ́ komoyị́ nɨ bɨlámáne, áyí ndị́sị sɨmɨ bimɨóṇgó. Togụ́ komoyị́ ndaá bɨlámáne wá, áyí ndị́sị ndị́sị sɨmɨ mɨtụlụrụ. ");
INSERT INTO bdh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ledre ga bɨ máꞌdódo yée zɨ́se ní nɨyí go bimɨóṇgó zɨ́se. Ídísé ówo a kɨ́dí ndanɨ́ eyé mɨtụlụrụ wá. ");
INSERT INTO bdh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Togụ́ ledre ꞌbɨ Lomo nɨ go sɨmɨsé, ngítí owụ́ bɨsinyí ledre utúasá ídíáká sɨmɨsé wá, ásá útúásá ówo ledre ga bɨ Lomo ili zɨ́ ꞌyị e ndị́sị méngị yée ní mbá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sɨmɨ bɨ Yésụ ꞌdodo asá ledre go ní, zɨ́ ngúru ꞌyị gɨ dongará Farụsáyo e ógụné ndólo wo gɨ ro éyị́ mɨánu ꞌbe ꞌbɨ ené. Zɨ́ Yésụ ndéréne ndị́sịné do bi éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sɨmɨ bɨ mị́ngị́ ꞌbe née lurú Yésụ tonó geré ánu éyị́ lugu sị́lị́ne kacɨ́ ondụ́ eyé ꞌbɨ Farụsáyo e kí wá ní, zɨ́ tara ị́drị́ne mɨị́drị́. ");
INSERT INTO bdh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Zɨ́ Ngére Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Sée Farụsáyo e, ndị́sịsé yéme lá dụụ́ sanáse gɨ ꞌdí sága, yémesé esé mɨmbéꞌdesé wá. Mɨmbéꞌdesé nɨ mɨꞌdúcuné kɨ́ ꞌbú éyị́ kpá kɨ́ bɨsinyí ledre e. ");
INSERT INTO bdh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ówosé ledre wá gɨ zɨ́ ꞌdi, ndaá ꞌbɨ ené bɨ kɨ́dí Lomo bɨ yeme sanáse née, yeme mɨmbéꞌdesé kpá ne ní wá? ");
INSERT INTO bdh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Togụ́ ndị́sịsé go íꞌbí éyị́ zɨ́ ꞌyị lerị́ e, Lomo nɨ ídí kɨ́ rokinyi kɨ́se zɨ́se ídíse mbigí ꞌyị ené e. ");
INSERT INTO bdh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Sée Farụsáyo e, Lomo nɨ karanée ꞌdoꞌdó sée kɨ́ngaya. Abú ásé tɨ́ ndị́sị íꞌbí mɨkawu éyị́ esé e zɨ́a yá, ili ídísé kpá ndị́sị méngị bɨlámá ledre zɨ́ ꞌyị e, zɨ́se kpá óto ꞌbúa. ");
INSERT INTO bdh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Sée Farụsáyo e, Lomo nɨ karanée ꞌdóꞌdo sée kɨ́ngaya gɨ zɨ́a bɨ ndị́sịsé óto ledresé owóowó sɨmɨ ꞌDị́cị́ Kótrụro e, ílisé ndị́sị dụụ́ do mɨngburoko bi ndị́sị e, ílisé kpá ꞌyị e idínɨ́ ndị́sị óto úndrusé togụ́ ayínɨ́ go íꞌbí mandá zɨ́se ní.” ");
INSERT INTO bdh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Sée Farụsáyo e, Lomo nɨ karanée ꞌdóꞌdo sée kɨ́ngaya gɨ zɨ́a ꞌyị e ndịsịnɨ́ lúrú rosé gɨ ꞌdí sága nɨ bɨlámáne, owonɨ́ eyé bɨ kɨ́dí mɨmbéꞌdesé emengụ́ ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zɨ́ ngúru ꞌyị ꞌdódo lorụ ị́nyịné úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, ndị́sị née go kpá úkucáyi zée.” ");
INSERT INTO bdh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Sée ꞌyị ꞌdódo lorụ e, Lomo nɨ karanée kpá ꞌdóꞌdo sée kɨ́ngaya gɨ zɨ́a ndị́sịsé gága ꞌyị e idínɨ́ ndị́sị lódụ́ kacɨ́ lorụ, tɨ́ lá méngịsé esé e wá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Zɨ́a kpá úku ngíti ledre kɨ́dí, “Sée Yụ́da e, abú ndị́sịsé óꞌbó yéme bi e zɨ́ nébị ga bɨ kóo ufunɨ́ yée ꞌdesị́ ní ndotó, Lomo nɨ karanée ꞌdóꞌdo sée kɨ́ngaya gɨ zɨ́a bulúndusé e ufunɨ́ kóo nébị ga gére née ye. ");
INSERT INTO bdh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ndị́sịsé née ꞌdódo a kɨ́dí ledre bɨ kóo bulúndusé e mengịnɨ́ née nɨ bɨlámáne, ufunɨ́ nébị e, zɨ́se ídí ꞌbɨ esé ꞌyị óꞌbó bi e zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gɨ zɨ́a bɨ Lomo nɨ yị́ ené ꞌyị komokenzị ní, zɨ́a úku ledre kɨ́dí, ‘Mááyí kása nébị amá e kɨ́ ꞌyịmɨkása amá e zɨ́ Yụ́da e, nɨyí úfu ngíti géyị, zɨ́ye ꞌdóꞌdo ngíti géyị bɨsinyíne.’ ");
INSERT INTO bdh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gɨ zɨ́ kéyị née, sée Yụ́da ga bɨ cakaba ba, Lomo nɨ nda ꞌdóꞌdo go sée gɨ ro nébị ga bɨ kóo bulúndusé e tonónɨ́ úfu yée kú sɨmɨ sịndị́ kadra bɨ kóo otoogụ do sogo káṇgá ní. ");
INSERT INTO bdh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tónóne gɨ ro Káyina wotị́ Ádama bɨ kóo ufu Ábele lúnduné ní, ndéréógụné gị ro Zakaríya bɨ kóo ufunɨ́ wo za cụ́ dongará ꞌdị́cị́ ꞌbɨ Lomo kɨ́ mbayi kɨ́ꞌdí bɨ ndịsịnɨ́ ꞌdáná éyị́ zɨ́ Lomo ní. Máúku zɨ́se maꞌdíi, sée ꞌyị ga bɨ cakaba ba nɨyí ꞌdódo sée gɨ ro ledre ga gére née. ");
INSERT INTO bdh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Sée ꞌyị ꞌdódo lorụ e, Lomo nɨ karanée kpá ꞌdóꞌdo sée kɨ́ngaya gɨ zɨ́a ílisé esé zɨ́ ꞌyị e ówo mbigí ledre bɨ ꞌbɨ Lomo ní wá. Gɨ zɨ́a sée, ílisé esé kpá ledre ꞌbɨ Lomo wá.” ");
INSERT INTO bdh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sɨmɨ bɨ Yésụ ukuonzó ledre ga gére ní, zɨ́ Farụsáyo e kɨ́ ꞌyị ꞌdódo lorụ e ndị́sịyé fála ledre gáa ndịsị úku yée ní kɨ́ ndị́sị ndúꞌyú ꞌdóꞌdo wo kɨ́ nduꞌyú e, ");
INSERT INTO bdh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","gɨ do bɨ ꞌdíꞌbi wo kɨ́dí luyú ledre go. ");
INSERT INTO bdh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nda sɨmɨ ngíti sị́lị́ gɨ do kacɨ́ ledre máa wo née ní, zɨ́ tụ́ꞌdụ́ ꞌyị e yóko royé ꞌdii cigí Yésụ gɨ ro úwú ledre bɨ gɨ taraa ní. Gɨ zɨ́a bɨ ofụnɨ́ nda kóo go ní, zɨ́ye ndị́sịyé ꞌdítílúyú do sogo sịndị́ lafúye. Sɨmɨ bɨ Yésụ tonó ódro ní, zɨ́a úkuụ́tụ ledre fị zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Komosé idí ídí rosé gɨ zɨ́ Farụsáyo nɨyí ꞌyị mani e.” ");
INSERT INTO bdh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Karanée ꞌdáꞌdá íri sɨmɨ odụ sịndị́ kadra ꞌbɨ ꞌdécị ngbanga, bɨkéṛị́ lúyú ledre ꞌbɨ Farụsáyo ga gére née wo bɨ yaá ꞌdodoogụnɨ́ do nyárá bi wá ní ndaá. Nɨyí karanée ózoógụ yée za mbá zɨ́ kadra. ");
INSERT INTO bdh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ledre ga bɨ za mbá úkuúgusé yée mɨúkuúgu sɨmɨ mɨtụlụrụ togụ́ mbú sɨmɨ bɨ ólụ́sé go ꞌdị́cị́ ní, Lomo nɨ karanée ꞌdódoógụ yée zɨ́ tụ́ꞌdụ́ mbílí e mbá úwú a. ");
INSERT INTO bdh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Máúku zɨ́se, ndásé éré ngịrị ꞌyị ga bɨ rokoꞌbụ eyé nɨ cúkuꞌdée lá dụụ́ ꞌbɨ úfu sanáse bɨ nɨ káṇgá ní wá. Ngíti éyị́ bɨ nɨyí méngị a gɨ do kacɨ́ a ní ndaá ꞌbɨ ené e wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ꞌYị bɨ ídísé éré a ní, nɨ Lomo gɨ zɨ́a nɨ ne kɨ́ rokoꞌbụ ꞌbɨ úfu ꞌyị kpá kɨ́ rokoꞌbụ ꞌbɨ ónzó ꞌyị ku mongụ́ phoꞌdụ bɨ ngárá ịlị́ kú wá ní. Máúku zɨ́se ídísé éré wo. ");
INSERT INTO bdh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Lúrúsé aka, abú mɨnzéré owụ́ solụ́ ndanɨ́ kɨ́ ledreyé owóowó zɨ́ ꞌyịmaꞌdí e wá yá, Lomo owo yée kékị́éꞌdo mbá bú. Wo bɨ kị́éꞌdo yaá owo wá ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Abú gba bị dosé, Lomo owo kékị́éꞌdo mbá. Ásé kɨ́ ledresé zɨ́ Lomo owóowó rómo do tụ́ꞌdụ́ owụ́ solụ́ e. Gɨ zɨ́ kéyị née, máyá zɨ́se ní, ndásé éré ngịrị gɨ zɨ́ gbékpị́ rokoꞌbụ ꞌbɨ ꞌyịmaꞌdí e wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ꞌYị bɨ eré ngịrị gɨ zɨ́ gbékpị́ rokoꞌbụ bɨ lá ꞌbɨ ꞌyịmaꞌdí e ní, zɨ́a ódó mɨmbéꞌdené úku ledre fúó dongará tụ́ꞌdụ́ ꞌyị e kɨ́dí née nɨ ꞌyị amá gɨ zɨ́a née ṇguṇgu ledremá go ní, Máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, karanée kadra ꞌdécị ngbanga, Mááyí tóro do komo Lomo kɨ́ maláyika ené e úku ledre gɨ ro ꞌyị née kɨ́dí, maꞌdíi née ꞌyị amá ṇguṇgu ledremá go. ");
INSERT INTO bdh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ꞌYị bɨ nɨ éré ngịrị gɨ zɨ́ rokoꞌbụ ꞌbɨ ꞌyịmaꞌdí e zɨ́a óyó sogoné zɨ́ma ní, mááyí karanée kpá óyó sogomá zɨ́a do komo maláyika e kadra ꞌdécị ngbanga. ");
INSERT INTO bdh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Máúku aka ngíti ledre zɨ́se, togụ́ ꞌyị uku cayi ledre gɨ do bi Má, Owụ́ ꞌbɨ ꞌYịmaꞌdí yá, Lomo nɨ ótoómo ledre zɨ́a. Togụ́ uku sinyi ledre kɨ́dí rokoꞌbụ bɨ Mándị́sị méngị ledre e kɨ́e ba ndaá rokoꞌbụ ꞌbɨ ꞌDówụ́ Lomo bɨ ogụ gɨ zɨ́ Lomo wá, Lomo otoomo ledre zɨ́ ꞌyị née wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Togụ́ karanée ꞌdiꞌbiogụnɨ́ sée gɨ zɨ́a bɨ ṇgúṇgusé ledre amá ní sɨmɨ ꞌDị́cị́ Kótrụro e kóꞌdụ́ mɨngburoko ꞌyị ꞌdáná mbayi ꞌbɨ Lomo, togụ́ mbú kóꞌdụ́ ngére e yá, ndásé éré ngịrị kɨ́ ndị́sị sómụ́ lóꞌbó ledre bɨ ásé úkulúgu a togụ́ nduꞌyúnɨ́ sée go ní wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ꞌDówụ́ Lomo nɨ úkuíꞌbí ledre bɨ zɨ́se úkulúgu a ní ne zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zɨ́ ngúru ꞌyị gɨ dongará ꞌyị ga bɨ Yésụ ndịsị ódro zɨ́ye née ị́nyịné úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, ídí úku ledre zɨ́ mongụ́ lúndumá, éyị́ ga bɨ ꞌbụzé uyuomo yée ní, idí mu ífi sɨmɨyé zɨ́a íꞌbíógụ ꞌbɨ amá.” ");
INSERT INTO bdh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Lúrú goó, máógụ amá do sogo káṇgá ona gɨ ro ífi sɨmɨ éyị́ ga bɨ ꞌbụsé uyuomo yée ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ndáꞌbané kpá úku ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ ndịsị ódro zɨ́ye ní kɨ́dí, “Komosé idí ídí rosé, ndásé ꞌdíꞌbi ꞌbú éyị́ ꞌbɨ sága ba óto a zɨ́se ꞌdáꞌdá wá, gɨ zɨ́a tụ́ꞌdụ́ éyị́ ꞌbɨ sága ba yomonɨ́ eyé ꞌyị wá abú áyí kɨ́ye ba cụ́ káa zɨ́ ꞌdíya.” ");
INSERT INTO bdh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nda gɨ ore zɨ́ Yésụ ị́nyịné úku ngíti ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, “Ngíti oꞌdo, oꞌdo kóo mongụ́ yáká ené zɨ́ kére ánáye zɨ́a nguku, do ṛóngoyé mbá mɨṛóngo. ");
INSERT INTO bdh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Zɨ́a ndị́sịné sómụ́ ledre kɨ́dí, ‘Kɨ́bi ba kére aná zɨ́ma go kɨ́ngaya, bɨ ngárá gbagba eye wá ba, mááyí ndíṛíóto yée ꞌda?’ ");
INSERT INTO bdh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Zɨ́a úku ledre zɨ́ne kɨ́ roné kɨ́dí, ‘Togụ́ kenée yá, mááyí ndụ́rụóyó kuṛú gbagba née ꞌdáꞌba, zɨ́ma ụ́bụ́ mɨkánda nda mongụ́ne, zɨ́ma ndíṛí kére née za kɨ́ mɨnzéré éyị́ ga bɨ ꞌbɨ ꞌbe ní mbá sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kɨ́bi ngíti a, máméngị moko wá, mááyí ánu kɨ́ éwé lá dụụ́ éyị́ ga gére née zɨ́ odụ ledre amá ídíne dụụ́ rokinyi.’ ");
INSERT INTO bdh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Zɨ́ Lomo úkulúgu ledre zɨ́ oꞌdo née kɨ́dí, ‘Ówo ledre wá gɨ zɨ́ ꞌdi, sómụ́ yá trịdrị nɨ do sị́lị́yị? Togụ́ kenée yá, mááyí ꞌdíꞌbi ꞌdówụ́yị kɨ́ ndụlụ ba togụ́ éyị́ ga bɨ kɨ́ ledreyé zɨ́yị owóowó née nɨyí nda ídí ꞌbɨ ambí yá?’ ” ");
INSERT INTO bdh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yésụ ya née ledre bɨ nɨ méngị roné zɨ́ ꞌyị ga bɨ otonɨ́ komoyé dụụ́ gɨ ro éyị́ ga bɨ ꞌbɨ sága ba ilinɨ́ óto ledre ꞌbɨ Lomo zɨ́ye owóowó wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zɨ́ Yésụ ndáꞌbané úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Bɨ kenée ní, máúku zɨ́se, ndásé sómụ́ ledre gɨ ro trịdrịsé, éyị́ bɨ ásé ánu a ní, togụ́ mbú sanáse kɨ́ bongó bɨ ásé ị́sị a ní wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Trịdrị idí ídí ne kɨ́ ledrené owóowó gɨ zɨ́a romo do éyị́ mɨánu kɨ́ bongó. ");
INSERT INTO bdh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lúrúsé aka solụ́ e, tɨ́ bɨ ngárá ledreyé ndaá owóowó wá ní, Lomo ndịsị lúrú bi kacɨ́ye. Ledresé nɨ zɨ́ Lomo owóowó nɨ lúrú bi kacɨ́se rómo ꞌbɨ solụ́ e mbá. ");
INSERT INTO bdh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Éyị́ ga bɨ ꞌyị e ndịsịnɨ́ sómụ́ ledreyé née mbá, iꞌbínɨ́ eyé trịdrị zɨ́ ꞌyị e wá, Lomo ndịsị íꞌbí trịdrị zɨ́ ꞌyị e dụụ́ ne. ");
INSERT INTO bdh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Káa zɨ́ bɨ gbékpị́ éyị́ ga gére née, iꞌbínɨ́ eyé trịdrị zɨ́ ꞌyị wá ní, ndásé óto komosé dụụ́ royé wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lúrúsé aka mɨsúrú kágá ga bɨ sɨmɨ súwú ní, kɨ́ lámá ga bɨ royé ní mbá, ngíti géyị mɨṛíṛíye gindri gindri ꞌdiꞌbiogụnɨ́ bongó zɨ́ye wá. Abú za cụ́ mongụ́ ngére kóo kɨ́ ịrịné Solomóna ní, abú nɨ kɨ́ tụ́ꞌdụ́ éyị́ zɨ́ne, bongó ené emeogụnɨ́ káa zɨ́ mɨsúrú kágá ga gére née mbá wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Éyị́ bɨ ílisé ṇgúṇgu ledre ꞌbɨ Lomo gɨ zɨ́a wá ní ꞌdi. Togụ́ bɨ Lomo lurú bi kacɨ́ gbékpị́ mɨsúrú kágá e sɨmɨ súwú bú ní, nɨ nda ꞌbɨ ené ótoómo kɨ́ íꞌbí bongó e zɨ́se ga bɨ kɨ́ ledresé zɨ́a owóowó wá ní káa be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndásé óto mɨmbéꞌdesé dụụ́ gɨ ro éyị́ mɨánu kɨ́ éyị́ mɨéwé, zɨ́se ndị́sịsé sómụ́ sɨmɨsé gɨ royé wá ");
INSERT INTO bdh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ꞌYị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní, ꞌbú éyị́ ga gére née ndịsị ꞌdíꞌbióyó sómụ́ ledre eyé gɨ zɨ́ Lomo. Ndásé sómụ́ ledre wá, ꞌBụsé owo éyị́ ga bɨ ílisé yée ní mbá bú nɨ íꞌbí yée zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bɨlámá a ídísé óto Lomo zɨ́se káa do Ngére esé. Owo éyị́ ga bɨ ílisé yée ní mbá bú, nɨ íꞌbí yée zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sée ꞌyị lódụ́ kacɨ́ma e, ngịrị ndaá méngịsé wá. ꞌBụsé bɨ komo ere ní, yemeomo bi go ꞌbe ꞌbɨ ené gɨ rosé. ");
INSERT INTO bdh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ndásé óto komosé dụụ́ ro éyị́ ga bɨ ꞌbɨ do sogo káṇgá ba wá gɨ zɨ́a ndịsịnɨ́ sinyí eyé mɨsínyí zɨ́ye ndị́sị ụ́kụ́ eyé kpá mɨụ́kụ́. Ídísé óto komosé dụụ́ ro ledre ꞌbɨ Lomo bɨ ụkụ́ wá, sinyí kpá wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bi bɨ óto éyị́ eyị́ bɨ kɨ́ ledrené owóowó doa ní, mɨmbéꞌdeyị́ nɨ ídí kpá fú íri.” ");
INSERT INTO bdh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Sée ꞌyị amá e máúku zɨ́se, ndásé ndị́sị lị́gị rosé wá. Kacɨ́ kadra mbá ídísé ídí nzíyisé gɨ ro mɨndáꞌbaógụmá, ");
INSERT INTO bdh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","cé káa zɨ́ ꞌyị ꞌbɨ moko bɨ ndịsịnɨ́ tɨ́ fú lá góꞌdo sóngó mongụ́ ꞌyị eyé kɨ́ ndáꞌbaógụ gɨ sɨmɨ ayímbi gɨ ro zɨ́ne ị́nyịné ꞌdiya líkpí mbotụ zɨ́a ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Togụ́ mongụ́ ꞌyị née ogụ ndiki ꞌyị ꞌbɨ moko ené ga gére née kɨ́ óto komoyé kacɨ́ne yá, nɨ ídí kɨ́ye kɨ́ rokinyi zɨ́a méngị bɨlámá ledre zɨ́ye gɨ ro zɨ́ye ídíye kpá kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sịndị́ kadra ꞌbɨ mongụ́ née ndaá mɨówoné wá. Togụ́ sɨmɨ kútú ndụlụ togụ́ kɨ́ sɨmɨbi mɨárá yá, ꞌyị ówo a ndaá. Mongụ́ ledre tɨ́ lá togụ́ ogụ go yá, nɨ méngị bɨlámá ledre zɨ́ ꞌyị ꞌbɨ moko ga bɨ nɨ ógụndíki yée nzíyiyé ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Úwúsé aka ledre ba, ꞌyị bɨ owo bú bɨlámáne kɨ́dí ꞌyị ugu nɨ ógụ karaba lágá ꞌdéwe mbotụ ené zɨ́a úgu éyị́ e ní, ꞌyị née utúasá ené ólụ́ógụ gɨ ꞌbe wá. ");
INSERT INTO bdh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɨ kpá kenée gɨ ro mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí. Ídísé ídí nzíyisé gɨ zɨ́a mɨndáꞌbaógụmá ówosé esé e wá, Mááyí lị́yị sée mɨlị́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zɨ́ ngúru ꞌyịmɨkása ꞌbɨ Yésụ bɨ kɨ́ ịrịné Pétero ní ị́nyịné ndúꞌyú Yésụ kɨ́dí, “Ngére, muruwayi bɨ úku née nɨ dụụ́ zɨ́ze togụ́ kpá za zɨ́ ngíti géyị ꞌyị e mbá?” ");
INSERT INTO bdh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zɨ́ Ngére Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Bɨlámá ꞌyị bɨ nɨ kɨ́ komokenzị zɨ́a ndị́sịné méngị ledre bɨ mɨútúásáne bɨ mongụ́ ꞌyị ené utúasá go óto wo zɨ́a ndị́sịné lúrú bi kacɨ́ ꞌyị kasa ené e gɨ ro zɨ́a ndị́sịné íꞌbí éyị́ eyé e sɨmɨ sịndị́ kadra ené ní, nɨ náambi? ");
INSERT INTO bdh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nɨ ídí bɨlámáne zɨ́ ꞌyị kasa bɨ mongụ́ ꞌyị ené nɨ ógụndíki wo ndị́sị méngị moko ené do bɨlámá mɨsiꞌdiné ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Máúku zɨ́se ba maꞌdíi, mongụ́ ꞌyị née nɨ óto wo zɨ́a ndị́sị lúrú bi kacɨ́ éyị́ ené e mbá. ");
INSERT INTO bdh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Togụ́ zɨ́ ꞌyị ꞌbɨ moko née somụ́ a kɨ́dí, ‘Mongụ́ ꞌyị amá ógụ aka ꞌdiya wá,’ zɨ́a ndị́sị ené kóyó ené kɨ́ ócó ngíti géyị ꞌyị ꞌbɨ moko ga bɨ yaꞌdá e kɨ́ kará e kɨ́ leꞌyị́ komoné. ");
INSERT INTO bdh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nɨ lị́yị ní mongụ́ ꞌyị ené ógụndíki wo go ngbụ́rụ́ ro ledre née kenée, mongụ́ ꞌyị née nɨ ꞌdóꞌdo wo bɨsinyíne do ógóóyó wo zɨ́a ndéré ndị́sịné zɨ́ ꞌyị ga bɨ ṇguṇgunɨ́ ledre ꞌbɨ Lomo wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Togụ́ ꞌyị ꞌbɨ moko bɨ owo éyị́ ga bɨ mongụ́ ꞌyị ené ili zɨ́ne méngị a ní bú bɨlámáne zɨ́a ásiné kɨ́ méngị a ní, maꞌdíi, mongụ́ ꞌyị ené née nɨ ꞌdóꞌdo wo kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tɨ́ lá ꞌyị moko máa wo bɨ owo ené éyị́ bɨ mongụ́ ené ili zɨ́ne méngị a ní wá ní, togụ́ luyú ledre go yá, mongụ́ ꞌyị née nɨ tɨ́ ꞌdóꞌdo wo ndaá za kɨ́ngaya wá. Kpá kenée ꞌyị máa wo bɨ Lomo méngị bɨlámá ledre go zɨ́a ní, Lomo ili zɨ́a méngị ledre bɨlámáne zɨ́ne. ꞌYị máa wo bɨ Lomo mengị bɨlámá ledre go zɨ́a za kɨ́ngaya ní, Lomo ili zɨ́a méngị ledre zɨ́ne kpá za kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zɨ́ Yésụ kpá úku ledre kɨ́dí, “Máógụ amá kɨ́ bikịdrị́ do sogo káṇgá ba wá, yị́ ené phoꞌdụ. Nɨ kóo ídí bɨlámáne togụ́ do sogo káṇgá máa tonó go áṛá. ");
INSERT INTO bdh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tɨ́ lá mááyí ógụ ídí sɨmɨ mongụ́ úzu éyị́, zɨ́ma ꞌdóꞌdóma mɨꞌdóꞌdó kɨ́ngaya, ꞌbúó togụ́ ꞌdoꞌdó máa née ụkụ́ go. ");
INSERT INTO bdh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lúrúsé íri káa zɨ́ éyị́ bɨ máógụ kótrụ sée ní? Ɨ́ꞌɨ, máógụ gɨ ro zɨ́se ífi sɨmɨsé. ");
INSERT INTO bdh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Togụ́ ꞌyị e nɨyí ꞌbe ꞌbɨ eyé ịnyị yá, yée ga bɨ gbre ní nɨyí óyólóꞌbó royé ídíye okó ro yée ga bɨ ota ní. Togụ́ kenée wá, yée ga bɨ ota ní, nɨyí óyólóꞌbó royé ídíye okó ro yée ga bɨ gbre ní. ");
INSERT INTO bdh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ꞌBụmɨowụ́ nɨ ídí okó ro wotị́ne, zɨ́ wotị́a ídíne okó roa. Mbámɨowụ́ nɨ ídí okó ro nyị́ne, zɨ́ nyị́a ídíne okó roa. Togụ́ kára nɨ ídí okó ro meꞌbe wotị́ne, zɨ́ meꞌbe wotị́a ídíne okó roa.” ");
INSERT INTO bdh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zɨ́a kpá úku ngíti ledre zɨ́ tụ́ꞌdụ́ ꞌyị ga gére née mbá kɨ́dí, “Togụ́ lúrúsé iní nɨ go ụ́lụ gɨ gbére kɨ́ngaya yá, geré zɨ́se ówo a kɨ́dí iní nɨ go ógụ éꞌdị. Tɨ́ maꞌdíi zɨ́ iní éꞌdịné.” ");
INSERT INTO bdh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kpá kenée togụ́ síli nɨ go ndị́sị ílíógụ ịrị́ ịrị́ yá, ásé geré ówo a kɨ́dí bi mɨị́rị́ ogụ go. Tɨ́ maꞌdíi, zɨ́a ídíne kenée. ");
INSERT INTO bdh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sée ga bɨ ótosé rosé káa do ꞌyị ówo ledre e, kɨ́ ndị́sị ówo ini ledre gɨ sɨmɨ toso síli ledre ga bɨ ndịsịnɨ́ ílí komo ere kɨ́ yée ga bɨ bi ona ní, sara ówoyémesé ini ledre gɨ sɨmɨ lị́lị ledre bɨ Lomo ndịsị mengị yée zɨ́ma cakaba ba wá ní gɨ zɨ́ ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nɨ kóo ídí bɨlámáne zɨ́se ówo maꞌdíi ledre zɨ́se méngị wo. ");
INSERT INTO bdh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Togụ́ ngíti ꞌyị iꞌbí ngbángáyị go zɨ́ ngére e yá, ídísé yéme dongaráse kéne ꞌdáꞌdá zɨ́a kɨ́ ꞌdíꞌbi ókpó yị́ị do ngbanga zɨ́ye ꞌdécị ngbanga royị́ do íꞌbí yị́ị zɨ́ asikíri e ndéréye kɨ́yị sɨmɨ sị́gịnị. ");
INSERT INTO bdh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Togụ́ ótoómo go zɨ́ éyị́ méngị roné kenée, áyí ídí sɨmɨ sị́gịnị ꞌbúó togụ́ késị́ bɨ ilinɨ́ gɨ zɨ́yị née íꞌbíónzó go, áyí fú ólụ́ógụ.” ");
INSERT INTO bdh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ ngíti géyị ꞌyị e úku ledre zɨ́ Yésụ kɨ́dí, Piláto iꞌbí okó go ro ꞌyị ga bɨ ꞌbɨ Galiláya bɨ nɨyí ndị́sị ꞌdáná éyị́ zɨ́ Lomo sɨmɨ ꞌDị́cị́ Kótrụro do úfu ngíti géyị. ");
INSERT INTO bdh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Lúrúsé íri káa zɨ́ éyị́ bɨ umbu bɨ ngíti géyị ꞌyị ꞌbɨ Galiláya ga gére uyunɨ́ née nɨ gɨ zɨ́a bɨ lúyú ledre eyé romo do ꞌbɨ lafúye go mbá ní? ");
INSERT INTO bdh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Máúku zɨ́se, togụ́ óyólóꞌbósé mɨmbéꞌdesé zɨ́se ṇgúṇgu ledre ꞌbɨ Lomo wá, ngíti géyị ꞌyị e gɨ dongaráse nɨyí úyu kpá kenée. ");
INSERT INTO bdh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sara nda yée ga bɨ kóo sokó doa ịnyị doa ota mongụ́ ꞌdị́cị́ ndụrụonzó yée sɨmɨ Yerụsaléma cigí mɨkavu bɨ Silowámo ní. Sómụ́sé ledre née méngịné roné zɨ́ye kenée née gɨ zɨ́a bɨ lúyú ledre eyé romo do ꞌbɨ ngíti géyị ꞌyị ga bɨ sɨmɨ Yerụsaléma ní? ");
INSERT INTO bdh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yaꞌdá ga gére née luyúnɨ́ eyé ledre wá. Togụ́ óyólóꞌbósé mɨmbéꞌdesé zɨ́se ndáꞌbaógụsé zɨ́ Lomo wá, ásé úyu kpá kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gɨ do kacɨ́ ledre máa wo née ní, zɨ́ Yésụ tónóne úku muruwayi kɨ́dí, “Ngíti oꞌdo ꞌdịyị́ kóo ndóṛí ꞌbɨ ꞌbe yáká ené. Kadra kị́éꞌdo zɨ́a ndéréne gɨ ro mɨáná a, ogụ ndiki ené fú lá mɨáná a wá. ");
INSERT INTO bdh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Zɨ́ mị́ngị́ yáká née úku ledre zɨ́ ꞌyị ꞌbɨ moko bɨ oto wo ndị́sị lúrú bi kacɨ́ yáká née ní ní kɨ́dí, ‘Ndóṛí ba mengị kɨ́ra go sɨmɨbi ota aná wá. Sị́ ledre bɨ zɨ́a ndị́sịné gɨ roa kɨ́rɨ́ née ní ní ndaá, ꞌdụtụ bi née go gbékpị́e, ídí lágáóyó a ꞌdáꞌba.’ ");
INSERT INTO bdh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Zɨ́ ꞌyị ꞌbɨ moko née úkulúgu ledre zɨ́ mongụ́ ꞌyị ené née kɨ́dí, ‘Mongụ́ ꞌyị, otoomozé aka kenée kɨ́ sɨmɨbi kị́éꞌdo. Mááyí aka íciꞌdíkí a gbaá, zɨ́ma ụ́nzụ ngénye nyaṇgu léfe a sị́ a. ");
INSERT INTO bdh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Togụ́ aná lolụ kpá wá, kɨ́ bi ngíti a zɨ́ze nda lágáóyó a.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sɨmɨ ngíti sịndị́ kadra sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ Yésụ kóo ndị́sịné ꞌdódo ledre zɨ́ ꞌyị e sɨmɨ ngúru ꞌDị́cị́ Kótrụro e. ");
INSERT INTO bdh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ábuwá ngíti kára nɨ kóo dongará ꞌyị ga bɨ Yésụ ndịsị ꞌdodo ledre zɨ́ye née ore nɨ kɨ́ dokéké e sɨmɨné, zɨ́ye góꞌdụ wo zɨ́a ndị́sị ndéréne gɨ zɨ́ye nda goro goro káa kɨ́ sɨmɨbi e sokó doa ịnyị doa ota. ");
INSERT INTO bdh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zɨ́ Yésụ lúrú kára née, zɨ́a ndólo wo kɨ́dí, Mamá, ógụ gɨrí zɨ́ma ꞌdáꞌdá yáa. Zɨ́ kára née ógụné, zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Ndíyá bɨ ndịsị ꞌdóꞌdo yị́ị kɨ́ tụ́ꞌdụ́ sɨmɨbi ba Lomo ꞌdiꞌbioyó go.” ");
INSERT INTO bdh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Zɨ́a óto sị́lị́ne ro sogo kára née, geré zɨ́ sogoa ꞌdózo roné, zɨ́a tónóne íꞌbílúgu mbófo éyị́ zɨ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zɨ́ ledre bɨ Yésụ mengị née sínyí ené ro mongụ́ ꞌyị ꞌbɨ ꞌDị́cị́ Kótrụro mɨsínyí kɨ́dí yomo ꞌyị sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro gɨ ro ꞌdíya. Zɨ́ mongụ́ ꞌyị ꞌbɨ ꞌDị́cị́ Kótrụro née kpá úku ledre zɨ́ ꞌyị e kɨ́dí, “Azé kɨ́ gbékpị́ sị́lị́ e ịnyị doa kéṛị́ gɨ ro méngị moko sɨmɨ a, ídísé ógụ dongará sị́lị́ ga gére ní gɨ ro do ꞌdíꞌbióyó ndíyá gɨ rosé sɨmɨ a. Ndaá sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro wá.” ");
INSERT INTO bdh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Zɨ́ Ngére Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Ndị́sịsé lóndo rosé kenée gɨ zɨ́ ꞌdi? Sara bɨ ndị́sịsé líkpí bangá esé e sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro ndéré kɨ́ye gɨ ro éwé iní ní. ");
INSERT INTO bdh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kára née nɨ bulúndu Abarayáma, Satána odóngeṛị kóo wo kɨ́ sɨmɨbi sokó doa ịnyị doa ota (18). Mándá líkpí wo sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro wá?” ");
INSERT INTO bdh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zɨ́ ledre bɨ Yésụ uku née sínyíne ro ezeokóga ga gére ní. Zɨ́ bi émené ro tụ́ꞌdụ́ ꞌyị e mbá gɨ zɨ́ mongụ́ bɨlámá ledre bɨ Yésụ mengị née. ");
INSERT INTO bdh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zɨ́ Yésụ úku muruwayi zɨ́ye kɨ́dí, “ꞌBe ꞌbɨ Lomo nɨ káa zɨ́ ꞌdi? Éyị́ bɨ mááyí óto ásá a kɨ́e ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ꞌBe ꞌbɨ Lomo nɨ káa zɨ́ kúfú kágá bɨ musɨtáda ꞌyị ꞌdịyị́ wo yáká ené ní. Abú kúfú a nɨ nzéré káa zɨ́ kúfú kịndrị́ ní yá, nɨ ngbóró ógụ ené mongụ́ kágá kɨ́ tụ́ꞌdụ́ mɨrásáne e zɨ́ tụ́ꞌdụ́ solụ́ e ndị́sị ógụ útúye komoa kpá kɨ́ ụ́bụ́ ꞌbe ꞌbɨ eyé e.” ");
INSERT INTO bdh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zɨ́a kpá úku ándá ledre kɨ́dí, “Éyị́ bɨ mááyí óto ásá ꞌbe ꞌbɨ Lomo kɨ́e ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nɨ ídí káa zɨ́ owụ́ ꞌdeꞌdị́ bɨ cúkuꞌdée ní, nɨyí lótó mongụ́ leꞌyị́ kɨ́e, zɨ́ leꞌyị́ née ꞌdị́ꞌdịné gɨ zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zɨ́ Yésụ ị́nyịné gɨ ore ndéréne kɨ́ ólụ́ne kacɨ́ do ꞌbe e kɨ́ gara ga bɨ kacɨ́ mɨsiꞌdi ní kɨ́ ꞌdodo ledre ꞌbɨ Lomo zɨ́ ꞌyị e gị zɨ́a ndéré ólụ́ne sɨmɨ Yerụsaléma. ");
INSERT INTO bdh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Zɨ́ ngíti ꞌyị gɨ dongará ꞌyị ga bɨ ndịsị ꞌdódo ledre zɨ́ye ní ndúꞌyú wo kɨ́dí, “Ngére, Lomo nɨ yómo lá dụụ́ ngíti géyị ꞌyị e ndaá ꞌyị e mbá wá?” Zɨ́ Yésụ úkulúgu ledre zɨ́ye mbá kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ꞌYị idí gámásóꞌdo mɨsiꞌdi za kɨ́ rokoꞌbụné mbá gɨ ro zɨ́a ólụ́ne ꞌbe ꞌbɨ Lomo. Tụ́ꞌdụ́ ꞌyị e nɨyí yéme royé gɨ ro zɨ́ye ólụ́ye íri, utúasánɨ́ eyé ólụ́ wá. ");
INSERT INTO bdh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sɨmɨ bɨ togụ́ Lomo ꞌdụtụ mbotụ ené go ní, sée ga bɨ nɨ ꞌdụ́tụómo sée sága ní, ásé tóro tara mbotụ ndị́sị ṇgúṇgú rosé kɨ́dí, ‘Mongụ́ ꞌyị, idí líkpí mbotụ zɨ́ze.’ “Nɨ úkulúgu ledre zɨ́se gɨrí kɨ́dí, ‘Máówo amá sée wá. Máówo amá kpá bi bɨ ógụsé gɨ doa ní wá?’ ");
INSERT INTO bdh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ásé úku ledre zɨ́a kɨ́dí, ‘Luyúzé komoyị́ go, anuzé kóo éyị́ mɨánu kɨ́ éwé éyị́ e kése, ndị́sị kóo kpá ꞌdódo ledre sɨmɨ gara ezé e.’ ");
INSERT INTO bdh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Nɨ úkulúgu ledre zɨ́se gɨrí kɨ́dí, ‘Maꞌdíi, máówo amá sée wá, máówo amá kpá bi bɨ ógụsé gɨ doa ní wá. Ídísé ị́nyị gɨ ore ꞌdáꞌba sée ꞌyị lúyú ledre e.’ ");
INSERT INTO bdh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Gɨ ore, ásé ndị́sị íni ini kɨ́ ndị́sị náná do sosé gɨ zɨ́a ásé lúrú kása Abarayáma e kɨ́ Isáka e kɨ́ Yakóbo e nda kɨ́ ngíti géyị nébị e kɨ́ ndị́sị ꞌbe ꞌbɨ Lomo íri. Tɨ́ lá sée, ndásé íri wá. ");
INSERT INTO bdh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ṛị́kị́ sị́ do ꞌyịmaꞌdí e gɨ do sogo káṇgá ba za mbá nɨyí ógụ sɨmɨ ayímbi ꞌbe ꞌbɨ Lomo íri. ");
INSERT INTO bdh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ídísé lúrú ledre née bɨlámáne. ꞌYị ga bɨ kóo ledreyé ndaá zɨ́ ꞌyịmaꞌdí e owóowó wá ní, nɨyí nda yị́ eyé go kɨ́ ledreyé zɨ́ Lomo owóowó.” ");
INSERT INTO bdh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cịkị sɨmɨ sịndị́ kadra bɨ Yésụ ndịsị ꞌdódo ledre sɨmɨa née ní, zɨ́ ngíti géyị Farụsáyo e ógụyé úku ledre zɨ́ Yésụ kɨ́dí, “Ólụ́ógụ mu gɨ ona ꞌdáꞌba gɨ zɨ́a ngére Eróde Andipá yeme ledre go gɨ ro úfu yị́ị.” ");
INSERT INTO bdh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zɨ́ Yésụ úkulúgu ledre zɨ́ Farụsáyo ga gére née kɨ́dí, “Ídísé ndáꞌba úku ledre zɨ́ Eróde ꞌyị mani née kɨ́dí, karaba kɨ́ kɨ́lóndó máíli aka lágaóyó bɨcayi lomo e gɨ sɨmɨ ꞌyị e kɨ́ yómo ꞌyị ndíyá e kí. Nda sɨmɨ ota sị́lị́ zɨ́ moko máa née ụ́kụ́ne.” ");
INSERT INTO bdh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Karaba kɨ́ kɨ́lóndó ndéréógụné sɨmɨ sị́lị́ ota, mááyí ídí mɨndéréma ꞌdáꞌdá gị sɨmɨ Yerụsaléma, ngíti éyị́ ụcụomo máa yana wá. Nébị ga bɨ kóo ꞌdáꞌdá ní ufunɨ́ yée mbá íri. ");
INSERT INTO bdh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Zɨ́ Yésụ ṇgúṇgú roné gɨ ro ꞌyị ga bɨ ꞌbɨ Yerụsaléma ní kɨ́dí, “Áko, sée ꞌyị ga bɨ ꞌbɨ Yerụsaléma ní, mááyí kɨ́ mongụ́ lerị́ gɨ rosé gɨ zɨ́a Lomo kasa kóo nébị e zɨ́se, zɨ́se úfu yée. Zɨ́se óngboónzó ngíti géyị ꞌyị ga bɨ Lomo kasa yée zɨ́se kɨ́ bɨlámá sanda ní kɨ́ tutú. Máíꞌbí romá gɨ ro kótrụ sée trị́é káa zɨ́ mbágángono bɨ kotrụ owụ́ ꞌbɨ ené e sị́ fúndúne ní, ílisé esé e wá. ");
INSERT INTO bdh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ídísé ówo a bɨlámáne kɨ́dí Lomo oyó sogoné go zɨ́se. Útúásásé lúrú máa cakaba wá ꞌbúó togụ́ sịndị́ kadra ogụ go zɨ́se úku ledre kɨ́dí, ‘Úndru idí ídí zɨ́ wo bɨ nɨ ógụ kɨ́ ịrị Ngére Lomo ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nda go sɨmɨ ngíti sịndị́ kadra kpị́ sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro, zɨ́ ngúru manda ꞌbɨ Farụsáyo e ndólo Yésụ gɨ ro éyị́ mɨánu ꞌbe ꞌbɨ ené. Zɨ́ ꞌyị máa yée ga bɨ nɨyí okó ro Yésụ ní, ndị́sịyé lúrú sémbe Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nɨyí ídí kɨ́e ní, ngíti oꞌdo sịndị́a kɨ́ sị́lị́a ụṛụ́nɨ́ mbá mɨụ́ṛụ́ gɨ dongará ꞌyị ga bɨ ore ní, ịnyị toro go ꞌdága kóꞌdụ́ Yésụ kenée. ");
INSERT INTO bdh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zɨ́ Yésụ ndúꞌyú Farụsáyo máa ga gére née kɨ́ ꞌyị ꞌdódo lorụ e kɨ́dí, “Nɨ mɨútúásáne do yómo ꞌyị sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro?” ");
INSERT INTO bdh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ukulugunɨ́ ledre mbá wá. Zɨ́ Yésụ ꞌdíꞌbi sị́lị́ne ro oꞌdo née geré zɨ́ ndíyá ụ́kụ́ne gɨ roa. Zɨ́ Yésụ kásalúgu wo ꞌbe, bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ndúꞌyú yée kɨ́dí, “Togụ́ ngúru ꞌyị gɨ dongaráse née zɨ́ owụ́ ꞌbɨ ené, togụ́ ngúru bangákụlụ́ ené útúne sɨmɨ gu sɨmɨ Sị́lị́ ꞌbɨ ꞌDówụ́ro ní, nɨ ótoómo a íri gɨ zɨ́a née ndaá sị́lị́ ꞌbɨ moko wá?” ");
INSERT INTO bdh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ledre ndaá tarayé mbá wá. ");
INSERT INTO bdh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sɨmɨ bɨ Yésụ lurú ṇgu ga bɨ ndịsịnɨ́ ógụ gelénɨ́ mbá mɨngburoko bi ndị́sị gɨ ro ndị́sị doa ní, zɨ́a ị́nyịné úku muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Togụ́ ndolonɨ́ yị́ị go sɨmɨ ayímbi yá, ndá lúrú té mongụ́ bi ndị́sị gɨ ro ndị́sị doa wá, éyị́ née kenée ndolonɨ́ kpá ngíti mongụ́ ꞌyị bɨ romo doyị́ ní go. ");
INSERT INTO bdh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sɨmɨ bɨ mongụ́ ṇgu née ogụ go ní, mị́ngị́ ꞌbe nɨ ógụ sị́kpị yị́ị kɨ́dí, ‘Ídí ndéré ndị́sị do bi máa wo bɨ ꞌdáa, mongụ́ ꞌyị bɨ ogụ ba nɨ ógụ ndị́sị ona.’ Mɨị́nyịyị́ nɨ ídí kɨ́ komokenyị́. ");
INSERT INTO bdh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Togụ́ ndolonɨ́ yị́ị go do ngíti bi, kɨ́ꞌdí bɨ ógụ go íri ní, ídí aka ndéré ndị́sị do owụ́ bi ndị́sị kí. ꞌYị bɨ ndolo yị́ị née nɨ ógụ sị́kpịóto yị́ị ne do bi bɨ yeme gɨ royị́ ní. Áyí ówó komo ꞌyị ga bɨ ore née geré mɨówó. ");
INSERT INTO bdh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gɨ zɨ́a ꞌyị bɨ ndịsị óto roné cúkuꞌdée ní, nɨyí sị́kpị wo ꞌdága. Wo bɨ ndịsị sị́kpị roné ꞌdága ní, nɨyí óto wo nde.” ");
INSERT INTO bdh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gɨ ore zɨ́ Yésụ ndáꞌbané úku ledre zɨ́ mị́ngị́ ꞌbe kɨ́dí, “Togụ́ yéme éyị́ mɨánu go gɨ ro ꞌyị e yá, ndá ndólo lá dụụ́ ezegámáyị e kɨ́ sụmụyị́ e kɨ́ mɨngburoko ꞌyị ga bɨ kɨ́ éyị́ e zɨ́ye ní wá. Gɨ zɨ́a togụ́ ilinɨ́ kpá yéme éyị́ mɨánu gɨ ro ꞌyị e yá, nɨyí ndólo kpá té dụụ́ yị́ị. Iꞌbílugunɨ́ éyị́ bɨ kóo méngị zɨ́ye née go zɨ́yị. ");
INSERT INTO bdh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sɨmɨ bɨ óto ayímbi go ní, ídí ndólo ꞌyị lerị́ e kɨ́ mɨgịgị́ṛị́ e, kɨ́ yée ga bɨ kɨ́ siri ro sịndị́ye ní, nda kɨ́ ꞌyị komo mɨꞌdụ́tụ e. ");
INSERT INTO bdh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Abú utúasánɨ́ méngị lúgu ledre zɨ́se wá yá, karanée sɨmɨ sịndị́ kadra bɨ Lomo nɨ úru mbigí ꞌyị e ené e gɨ sɨmɨ umbu ní, Lomo nɨ íꞌbí úndru zɨ́yị.” ");
INSERT INTO bdh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sɨmɨ bɨ ngúru ꞌyị gɨ dongará ꞌyị ga bɨ ndịsịnɨ́ gbóo cigí Yésụ ánu éyị́, uwú ledre bɨ Yésụ ndịsị ꞌdódo a née kenée ní, zɨ́a ị́nyịné úku ledre kɨ́dí, “ꞌYị ga bɨ karanée nɨyí ndị́sị ánu éyị́ sɨmɨ ayímbi ꞌbe ꞌbɨ Lomo ní, nɨyí ídí kɨ́ rokinyi.” ");
INSERT INTO bdh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zɨ́ Yésụ úkulúgu ledre zɨ́ oꞌdo née kɨ́dí, “Ngíti oꞌdo mengị kóo mongụ́ ayímbi zɨ́a ndóloyóko tụ́ꞌdụ́ ꞌyị e gɨ roa. ");
INSERT INTO bdh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sɨmɨ bɨ sịndị́ kadra utúasá go ní, zɨ́ mị́ngị́ ꞌbe kása ꞌyị ꞌbɨ moko ené ndéré kɨ́ úku ledre zɨ́ ꞌyị e kɨ́dí, ‘Sịndị́ kadra utúasá go ogụnɨ́ mu.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“ꞌYị ga bɨ ndolonɨ́ yée ní ogụnɨ́ eyé e mbá wá, ya yée nɨyí kɨ́ moko eyé e. Mɨzefị ꞌyị ya, ‘Máúgú yáká cakaba máíli ndéré lúrú a. Gɨ zɨ́ kéyị née, máútúásá ógụ wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ngíti a ya, ‘Máúgú ị́tị́ e cakaba ịnyị gɨ ro ndị́sị méngị moko kɨ́ye, mááyí aka ndéré úzu yée togụ́ utúasánɨ́ go méngị moko yá. Máútúásá ógụ wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ngíti a ya, ‘Máófụ́ kára cakaba, máútúásá ógụ wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Zɨ́ ꞌyị ꞌbɨ moko ndáꞌbané úku ledre ga gére née zɨ́ mongụ́ ꞌyị ené. Zɨ́ bi sínyíne roa gbála. Zɨ́a kása ꞌyị ꞌbɨ moko née kɨ́dí, ‘Ídí ólụ́ógụ do mɨsiꞌdi íri zɨ́yị ndólo ꞌyị lerị́ e kɨ́ mɨgịgị́ṛị́ e, kɨ́ ꞌyị komo mɨꞌdụ́tụ e, kɨ́ yée ga bɨ kɨ́ siri ro sịndị́ye ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Zɨ́ ꞌyị ꞌbɨ moko née ndéréne, zɨ́a ndáꞌbaógụné úku ledre zɨ́ mị́ngị́ ꞌbe kɨ́dí, ‘Mongụ́ ꞌyị, ꞌyị ga gére née ogụnɨ́ go, tɨ́ lá ngíti géyị bi ndị́sị nɨyí aka gbékpị́e ꞌyị ndanɨ́ doyé wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zɨ́a kpá kása ándá ꞌyị ꞌbɨ moko née, ‘Ídí ólụ́ógụ do mɨsiꞌdi kɨ́ ꞌbe ꞌbɨ ꞌyị e, zɨ́yị ndólo yée gɨ ro zɨ́ bi ndị́sị ga gére née ídíye mbá kɨ́ ꞌyị e doyé. ");
INSERT INTO bdh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ꞌYị ga bɨ mándólo yée ꞌdáꞌdá ngárá ogụnɨ́ wá ní, maꞌdíi utúasánɨ́ ndéne úzu toꞌdo éyị́ mɨánu bɨ máyéme gɨ royé ba wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nda gɨ ore, zɨ́ Yésụ ị́nyịné kpá fú lódụ́ mɨsiꞌdi ndéréne sɨmɨ Yerụsaléma. Tụ́ꞌdụ́ ꞌyị e nɨyí go kpá rụụ do kacɨ́ a. Zɨ́a óyó komoné úku ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Togụ́ ꞌyị ili ídí ꞌyị lódụ́ kacɨ́ma yá, idí óto ꞌbúma rómo do ꞌbụné kɨ́ mbágáne, kɨ́ meꞌbené kɨ́ owụ́ ꞌbɨ ené e kɨ́ lúnduné e kɨ́ lémịné e kpá kɨ́ kụṛụꞌbụné mbá, nɨ fú ídí ꞌyị lódụ́ kacɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndaá kpá lá dụụ́ wo née wá, ꞌyị bɨ ili go ídíne ꞌyị lódụ́ kacɨ́ma ní, idí íꞌbí roné zɨ́ umbu gɨ romá. ");
INSERT INTO bdh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ledre née nɨ káa zɨ́ togụ́ ꞌyị ili ụ́bụ́ ꞌdị́cị́ yá, nɨ aka ówo rokoꞌbụ késị́ do sị́lị́ne kí nɨ fú tónó moko. ");
INSERT INTO bdh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Togụ́ mengị kenée wá, nɨ méngị moko née lá mburu yana zɨ́ rokoꞌbụ a ụ́kụ́ne zɨ́ ꞌyị e kúgú wo. ");
INSERT INTO bdh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Zɨ́ye úku ledre kɨ́dí, ‘Oto dosị́ moko, mengịonzó wá romo wo go mburu yana.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kpá kenée ngére bɨ nɨ kɨ́ ꞌyị e zɨ́ne álifu sokó, togụ́ ili ndéré útú kɨ́ okó do ezené ngére bɨ nɨ yị́ ené kɨ́ ꞌyị e ené álifu cị́ kéṛị́ a ní yá, nɨ aka lúrú rokoꞌbụné kí nɨ fú ndéré méngị okó née. ");
INSERT INTO bdh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Togụ́ owo go kɨ́dí rokoꞌbụné nda yá, nɨ kákasa zɨ́ ezeokóne née kɨ́dí, ‘Okó ndaá ídí wá, yée idínɨ́ yéme dongaráye.’ ");
INSERT INTO bdh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nɨ gɨ rosé kpá kenée. Togụ́ ꞌyị ili ídí ꞌyị lódụ́ kacɨ́ma yá, ídí ótoómo yị́ ené e za mbá, zɨ́a ídíne ꞌyị lódụ́ kacɨ́ma. ");
INSERT INTO bdh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Toꞌdo nɨ bɨlámá éyị́. Togụ́ ayá lolụ wá ní, áyí méngị lárá a káa be ꞌdi zɨ́a áyálúgu roné? ");
INSERT INTO bdh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bɨ ngárá moko ndaá lolụ sɨmɨ a, gbawá gɨ ro do méngị ngíti géyị éyị́ e kɨ́e wá ní, odụ a dụụ́ do léfeóyó a ꞌdáꞌba. “ꞌYị bɨ uwú ledre bú ní, idí úwú ledre bɨ máúku née.” ");
INSERT INTO bdh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kadra kị́éꞌdo ꞌyị ꞌdóꞌdụ́ ụsórụ e gɨ zɨ́ ꞌyị e kɨ́ tụ́ꞌdụ́ ꞌyị lúyú ledre e ogụnɨ́ go ndị́sị úwú ledre ga bɨ Yésụ nɨ ndị́sị ꞌdódo yée zɨ́ ꞌyị e ní. ");
INSERT INTO bdh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Zɨ́ Farụsáyo e kɨ́ ngíti géyị ꞌyị ꞌdódo lorụ e ndị́sịyé úku mɨngụ́ngụ́rụ́ ledre ro Yésụ kɨ́dí, “Oꞌdo née otoomo ꞌyị lúyú ledre e zɨ́ye ndị́sịyé ánu éyị́ kéye.” ");
INSERT INTO bdh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zɨ́ Yésụ ódroné zɨ́ye sɨmɨ muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Togụ́ áyí kɨ́ kábịṛị́kị e zɨ́yị míya (100), zɨ́ wo bɨ kị́éꞌdo ní ị́ndrịné, útúásá ótoómo yée ga bɨ cị́ eso doa sokó doa ịnyị doa eso (99) née zɨ́yị ndéréyị gámásóꞌdo wo bɨ ịndrị kị́éꞌdo née wá? ");
INSERT INTO bdh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sɨmɨ bɨ ndíki go ní, áyí ídí kɨ́ mongụ́ rokinyi zɨ́yị óꞌbo a ndáꞌba kɨ́e ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sɨmɨ bɨ ógụ goó ꞌbe ní, áyí ndóloyóko lafúyị e yá, ‘Mándólo sée gɨ ro zɨ́ze ndị́sịzé kése kɨ́ rokinyi gɨ zɨ́a kábịṛị́kị amá bɨ ịndrị ní mándíki go.’ ");
INSERT INTO bdh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yésụ ya zɨ́ye ní, ledre née nɨ kpá kenée komo ere. Togụ́ ꞌyị lúyú ledre kị́éꞌdo, oyóloꞌbó sómụ́ ledre ené go zɨ́a ṇgúṇgu ledre ꞌbɨ Lomo yá, Lomo nɨ ídí kɨ́ rokinyi gɨ roa rómo do tụ́ꞌdụ́ ꞌyị ga bɨ oyóloꞌbónɨ́ sómụ́ ledre eyé wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sara togụ́ ngíti kára nɨ kɨ́ komo késị́ ené sokó (10), zɨ́ wo bɨ kị́éꞌdo ní útúị́ndrị roné gɨ sɨmɨ a cịkị ꞌdị́cị́ ore, utúasá ụ́ndụ phoꞌdụ zɨ́a ndị́sịné ókósóꞌdo a gị zɨ́a ndíki a kí ní wá? ");
INSERT INTO bdh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sɨmɨ bɨ ndíki go ní, nɨ ndóloyóko lafúne e kɨ́ eze ꞌbe ꞌbɨ ené e zɨ́a úku ledre zɨ́ye kɨ́dí, ‘Mándólo sée gɨ ro zɨ́ze ndị́sịzé kése kɨ́ rokinyi gɨ zɨ́a késị́ amá bɨ ịndrị ní, mándíki go.’ ");
INSERT INTO bdh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ledre née nɨ kpá kenée komo ere. Togụ́ ꞌyị lúyú ledre kị́éꞌdo oyóloꞌbó sómụ́ ledre ené go zɨ́a ṇgúṇgu ledre ꞌbɨ Lomo yá, maláyika e mbá nɨyí ídí kɨ́ rokinyi gɨ ro bɨ kéṛị́ ꞌyị lúyú ledre bɨ oyóloꞌbó sómụ́ ledre ené zɨ́a ṇgúṇgu ledre ꞌbɨ Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zɨ́ Yésụ kpá úku ngíti muruwayi kɨ́dí, “Ngíti oꞌdo nɨ kóo bo kɨ́ wotị́ne e gbre. ");
INSERT INTO bdh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Zɨ́ wotị́a bɨ owụ́ ní úku ledre zɨ́ ꞌbụyé kɨ́dí, ‘Babá, éyị́ sị́lị́yị ga bɨ gɨ ro ífi báyi yée zɨ́ze owụ́ ꞌbɨ eyị́ e ní, íꞌbí ꞌbɨ amá mu gɨ sɨmɨyé.’ ꞌBụyé kala kpá wá, zɨ́a ífi báyi éyị́ sị́lị́ne zɨ́a iꞌbí ꞌbɨ owụ́ ꞌbɨ ené bɨ owụ́ ní. ");
INSERT INTO bdh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Lá owụ́ sị́lị́ cúkuꞌdée, zɨ́ wotị́a bɨ owụ́ ní úgúóyó ꞌbɨ ené éyị́ bɨ ꞌbụyé iꞌbí zɨ́a ní mbá ꞌdáꞌba, zɨ́a ꞌdíꞌbi késị́ ndéréne gbála sɨmɨ ngíti káṇgá. Zɨ́a sínyiónzó késị́ née íri sɨmɨ ledre ga bɨ ngárá moko ndaá sɨmɨyé wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nɨ ídí kɨ́e ní, ꞌbú utú go sɨmɨ káṇgá bɨ nɨ sɨmɨa íri née, késị́ ndaá lolụ zɨ́a ánu éyị́ kɨ́e wá. ");
INSERT INTO bdh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Zɨ́a ídíne káa do ꞌyị ꞌbɨ moko ꞌbɨ ngíti oꞌdo gɨ dongará mị́ngị́ káṇgá ga bɨ íri ní, ndị́sị lúrú bi kacɨ́ mụkụ́ṛụ́ ené e kɨ́ íꞌbí éyị́ mɨánu zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ꞌYị íꞌbí éyị́ mɨánu ndaá zɨ́a wá, nɨ nda kóo go gbóo gɨ ro ánu éyị́ mɨánu ga bɨ ꞌbɨ mụkụ́ṛụ́ e ní. ");
INSERT INTO bdh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Zɨ́a sómụ́lóꞌbó sɨmɨ doné zɨ́a úku ledre kɨ́dí, ‘ꞌYị ꞌbɨ moko ga bɨ ꞌbɨ babá ní, éyị́ mɨánu nɨ gɨ royé bo kɨ́ngaya. Mááyí ndị́sị úyu gɨ zɨ́ ꞌbú ona ba. ");
INSERT INTO bdh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mááyí ndáꞌba zɨ́ma úku ledre zɨ́a máyá, “Babá, málúyú go ro Lomo kpá royị́. ");
INSERT INTO bdh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Máútúásá amá lolụ ídíma káa do owụ́ ꞌbɨ eyị́ wá. Ídí nda óto máa dongará ꞌyị ꞌbɨ moko eyị́ e.” ’ ");
INSERT INTO bdh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yóó, zɨ́a ị́nyịné ndáꞌbané ꞌbe zɨ́ ꞌbụné. “Zɨ́ ꞌbụa lúrúndíki wo gɨ gbála kɨ́ ógụné do mɨsiꞌdi, zɨ́a ídíne kɨ́ mongụ́ sɨmɨkozo gɨ roa. Zɨ́a ngásáne ndéré útúne ro wotị́ne fáka wo íꞌbí mandá zɨ́a kɨ́ ꞌbúne. ");
INSERT INTO bdh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Zɨ́ wotị́a úku ledre zɨ́a kɨ́dí, ‘Babá, málúyú go ro Lomo kpá royị́. Máútúásá lolụ ídíma káa do owụ́ ꞌbɨ eyị́ wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Zɨ́ ꞌbụa úku ledre zɨ́ ꞌyị moko e kɨ́dí, ‘Ngásásé mu ꞌdiꞌdiya ndéréógụ kɨ́ bɨlámá bongó, kɨ́ ngoꞌdi kɨ́ éyị́ sịndị́ zɨ́a ésị yée. ");
INSERT INTO bdh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Zɨ́se ndéréógụsé kɨ́ zoro ị́tị́ óṇgoónzó a gɨ ro zɨ́ze ánu a kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wotị́ma ba nɨ kóo go umbuné. Bɨ ba ní, ndaꞌbaogụ go trịdrị. Ịndrị kóo go, ndaꞌbaogụ go.’ Zɨ́ye tónóye ánu éyị́ kɨ́ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ledre ba nɨ ndị́sị méngị roné ní, wotị́a bɨ mongụ́ ní nɨ aka ꞌbɨ ené yáká. Zɨ́a ị́nyịné gɨ yáká gɨrí go sɨkala ndáꞌbaógụné ꞌbe. Zɨ́a ógụ ólụ́ne sɨmɨ gboṛụ kị́drị́ kɨ́ do ꞌyị e, keꞌbị nɨ go ndị́sị méngị roné zɨ́ye ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zɨ́a ndólo ngúru ꞌyị ꞌbɨ moko bɨ ꞌbe ore ndúꞌyú wo kɨ́dí, ‘Éyị́ bɨ mengị roné ní ꞌdi?’ ");
INSERT INTO bdh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Zɨ́ ꞌyị ꞌbɨ moko née úkulúgu ledre kɨ́dí, ‘Bɨsinyí ledre ndaá, lúnduyị́ kóo ịndrị ní, ndaꞌbaogụne zɨ́ ꞌbụsé úku ledre do óṇgoónzó zoro ị́tị́ gɨ ro zɨ́ ꞌyị e ánu a, bɨ nɨyí ndị́sị ndéndeke née.’ ");
INSERT INTO bdh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Zɨ́ ledre née sínyíne ro wotị́a bɨ mongụ́ née gbála, zɨ́a ásiné cịkị do mɨsiꞌdi ili ógụ ꞌbe wá. Zɨ́ ꞌbụyé ndéréne dódó roné roa idí mu ógụ ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Zɨ́a úkulúgu ledre zɨ́ ꞌbụyé kɨ́dí, ‘Lúrú aka, tụ́ꞌdụ́ sɨmɨbi ga ba za mbá azé kéyị ona. Zɨ́ma ndị́sịmá óto úndruyị́ kɨ́ méngị moko kpá káa zɨ́ ꞌyị ꞌbɨ moko ní, íꞌbí zɨ́ma gbawá owụ́ ína zɨ́ma gɨ ro zɨ́ze ánua kɨ́ lafúma e. ");
INSERT INTO bdh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lúrú aka nda ꞌyị máa bɨ sinyionzó késị́ eyị́ mbá do kará ga bɨ moko ndaá sɨmɨyé wá ní, sɨmɨ bɨ ledre romo wo, ndaꞌbaogụ nda goó ꞌbe ní, zɨ́yị úfu za cụ́ ị́tị́ zɨ́a gɨ ro zɨ́ ꞌyị e ógụyé ánu a.’ ");
INSERT INTO bdh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Zɨ́ ꞌbụa úkulúgu ledre zɨ́a kɨ́dí, ‘Lúrú ledre máa née kɨ́e? Mbé bɨ azé kéyị ona ní, éyị́ ga bɨ ꞌbɨ amá ní nɨyí fú mbá ꞌbɨ eyị́. ");
INSERT INTO bdh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ufunɨ́ ị́tị́ née gɨ zɨ́a lúnduyị́ née nɨ kóo go umbuné. Bɨ ba ní, ndaꞌbaogụ go trịdrị. Ịndrị kóo go, ndaꞌbaogụ go.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Ngíti mongụ́ ꞌyị nɨ kóo bo, zɨ́ ꞌyị e úku ledre zɨ́a kɨ́dí, ꞌyị ꞌbɨ moko ené bɨ ndị́sị lúrú bi kacɨ́ késị́ ní, ndịsị sínyi késị́. ");
INSERT INTO bdh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Zɨ́ mongụ́ ꞌyị née ndólo ꞌyị ꞌbɨ moko ené née úku ledre zɨ́a kɨ́dí, ‘Máúwú tụ́ꞌdụ́ bɨsinyí ledre go gɨ royị́. ꞌDíꞌbiógụ aka késị́ ga bɨ ndị́sị méngị moko kɨ́e ní zɨ́ma lúrú a. Gɨ zɨ́a tónóne karaba ndéréne ꞌdáꞌdá, ndá lolụ ꞌyị ꞌbɨ moko amá ona wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“ꞌYị ꞌbɨ moko née ya zɨ́a ní, ‘Mongụ́ ꞌyị amá nɨ go otoomo máa gɨ sɨmɨ moko. Rokoꞌbụmá ndaá gɨ ro ndéré kɨ́ íci gu kɨ́e zɨ́ ꞌyị e gɨ ro késị́ wá, máútúásá kpá ómbo éyị́ wá, mááyí méngị ba goó ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Zɨ́a sómụ́ndíki ledre kɨ́dí togụ́ kenée yá, gɨ ro zɨ́ ꞌyị e ꞌdíꞌbi née sɨmɨ sụmụ gɨ do kacɨ́ a bɨ née ndaá lolụ sɨmɨ moko wá ní, née nɨ méngị éyị́ káa.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Zɨ́a ndólo ꞌyị ga bɨ kóo ndịsịnɨ́ ꞌdíꞌbi késị́ ꞌbɨ mongụ́ ꞌyị ené gɨ zɨ́a ní. Zɨ́a ndúꞌyú mɨzefịyé kɨ́dí, ‘ꞌDiꞌbi kóo késị́ ꞌbɨ mongụ́ ꞌyị amá gɨ zɨ́ma ndu?’ ");
INSERT INTO bdh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Zɨ́a úkulúgu ledre zɨ́ ꞌyị ꞌbɨ moko née kɨ́dí, ‘Máꞌdíꞌbi kóo gɨ zɨ́yị kúkú sụꞌbụ́ míya ịnyị doa ota.’ “ꞌYị ꞌbɨ moko née ya, ‘Ídí nda éké a lá dụụ́ míya eso.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Zɨ́a ndúꞌyú ngíti ꞌyị kɨ́dí, ‘ꞌBɨ eyị́ ꞌbɨ ené ndu?’ “Zɨ́a úkulúgu a zɨ́ ꞌyị ꞌbɨ moko née kɨ́dí, ‘Suwáli kére álifu kị́éꞌdo.’ “Zɨ́ ꞌyị ꞌbɨ moko née úku a zɨ́a ya, ‘Éké nda lá míya ịnyị doa ota.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Zɨ́ mongụ́ ꞌyị née úku ledre zɨ́ ꞌyị ꞌbɨ moko ené née kɨ́dí méngị née komokenzị zɨ́yị. ꞌYị ꞌbɨ do sogo káṇgá nɨyí kɨ́ komokenzị gɨ royé kɨ́ royé romo do ꞌyị ga bɨ ꞌbɨ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sée ꞌyị lódụ́ kacɨ́ma e, ídísé méngị bɨlámá ledre zɨ́ ꞌyị e kɨ́ éyị́ ga bɨ zɨ́se do sogo káṇgá ba, gɨ ro karanée togụ́ éyị́ ga gére née ụkụ́nɨ́ go yá, ásé nda ndíki bɨlámá bi bɨ za fí ní komo ere. ");
INSERT INTO bdh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“ꞌYị bɨ utúasá go lúrú bi kacɨ́ owụ́ éyị́ ní, nɨ kpá útúásá lúrú bi kacɨ́ mongụ́ éyị́. Togụ́ utúasá lúrú bi kacɨ́ owụ́ éyị́ wá, utúasá kpá lúrú bi kacɨ́ mongụ́ éyị́ wá. ");
INSERT INTO bdh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Togụ́ iꞌbínɨ́ owụ́ éyị́ ꞌbɨ do sogo káṇgá ba gɨ ro zɨ́yị lúrú bi kacɨ́ a, útúásá lolụ kɨ́e wá ní, nɨyí nda íꞌbí mongụ́ éyị́ ꞌbɨ komo ere ní zɨ́yị káa be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Togụ́ útúásá lúrú bi kacɨ́ éyị́ ꞌbɨ ngíti ꞌyị wá ní, ambí nɨ nda íꞌbí éyị́ zɨ́yị gɨ ro zɨ́a ídíne káa do ꞌbɨ eyị́ ní ne? ");
INSERT INTO bdh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ꞌYị kị́éꞌdo utúasá ídí ꞌyị ꞌbɨ ngére e gbre wá. Nɨ óto ꞌbú wo bɨ kị́éꞌdo ní, zɨ́a sógó ngíti a. Kpá kenée, útúásá óto ledre Lomo kɨ́ késị́ zɨ́yị mbá owóowó wá.” ");
INSERT INTO bdh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gɨ zɨ́a bɨ Farụsáyo e nɨyí kɨ́ ꞌbú késị́ doyé kɨ́ngaya ní, sɨmɨ bɨ uwúnɨ́ ledre bɨ Yésụ uku née kenée ní, zɨ́ye ndị́sịyé kúgú wo mɨkúgú. ");
INSERT INTO bdh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ndị́sịsé óto rosé zɨ́ ꞌyị e kɨ́ ledresé owóowó, ówosé esé bɨ kɨ́dí Lomo owo ledre ga bɨ do mɨmbéꞌdesé bú ní wá. Éyị́ bɨ do sogo káṇgá ba ndịsịnɨ́ lúrú a kɨ́ ledrené owóowó ní, moko ndaá bɨ ené sɨmɨ a zɨ́ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ꞌDáꞌdá gɨ zɨ́ Yiwáni babatị́za, ꞌyị e ndịsịnɨ́ aka kóo mbá óto úndru lorụ bɨ kóo Mụ́sa eké kpá kɨ́ ledre ga bɨ kóo nébị e ndịsịnɨ́ úku yée ní. Sɨmɨ bɨ Yiwáni ogụ nda ndị́sị ꞌdódo bɨlámá ledre gɨ ro ꞌbe ꞌbɨ Lomo kɨ́dí, ꞌyị e idínɨ́ ówo Lomo káa do Ngére eyé ní, mɨmbéꞌdeyé nɨ go mbá íri. ");
INSERT INTO bdh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Abú karanée Lomo nɨ óyólóꞌbó do sogo káṇgá ba kɨ́ ere yá, ngíti éyị́ bɨ kị́éꞌdo gɨ sɨmɨ ledre ga bɨ kóo ekénɨ́ yée sɨmɨ lorụ nɨyí ꞌdíꞌbíóyó a ꞌdáꞌba ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ꞌYị bɨ otoomo meꞌbené, zɨ́a nda ndéréne ofụ́ ngíti kára ní, luyú ledre go. Nda gɨ ore oꞌdo bɨ ófụ́ kára née go ní, luyú kpá ledre go.” ");
INSERT INTO bdh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ngíti mongụ́ ꞌyị nɨ kóo bo, kacɨ́ kadra mbá ndịsị ésị roné fú lá bɨlámá bongó, zɨ́a ndị́sịné ánu fú lá bɨlámá éyị́ mɨánu. ");
INSERT INTO bdh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zɨ́ ngíti géyị ꞌyị e ndị́sịyé ị́mbị́ógụ ngíti ꞌyị lerị́ nɨ kɨ́ ịrịné Lázoro, roa ba za mbá uṇgú, ndị́sị óto wo tara mbotụ ꞌbe ꞌbɨ mongụ́ ꞌyị née. ");
INSERT INTO bdh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázoro maꞌdáa ili tɨ́ lá zɨ́ne ndị́sịné ánu nyụnyụ́ éyị́ mɨánu bɨ nɨ ndị́sị ṛéṛe sị́ tarabíza ꞌbɨ oꞌdo née bi ní káa bɨ née nɨ úyu gɨ zɨ́ ꞌbú ke. Sɨmɨ ledre ga gére née mbá zɨ́ ị́sị ndị́sịyé léwe uṇgú ga bɨ ro Lázoro ní. ");
INSERT INTO bdh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nda sɨmɨ ngíti sị́lị́, zɨ́ ꞌyị lerị́ née úyuné. Zɨ́ maláyika e ꞌdíꞌbi wo ndéré kɨ́e do bi kɨ́ꞌdí bɨ Abarayáma ndịsị ndị́sị ní. Zɨ́ mongụ́ ꞌyị née úyuné do óto bi zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Zɨ́ trịdrị a ndéréókpó ꞌbɨ ené geré do bɨsinyí bi bɨ ꞌbɨ ꞌdoꞌdó kɨ́ngaya ní. Nɨ sị́kpị doné lúrú bi ꞌdága káa ní, zɨ́a lúrúndíki Lázoro ꞌyị lerị́ bɨ kóo ba gbála kɨ́ ndị́sị eyé kɨ́ Abarayáma do bɨlámá bi. ");
INSERT INTO bdh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gɨ zɨ́ éyị́ mɨówo, zɨ́ oꞌdo née gbúrógbóne ꞌdága kɨ́dí, ‘Áko mongụ́ ꞌyị Abarayáma, ótoómo ledre zɨ́ma, mááyí go úyu. Kása aka Lázoro idí lá ésị nzisị́lị́ne bɨ do tifi ní sɨmɨ iní kịdrị́, ógụ éꞌde a dondenemá, gịe zɨ́ owụ́ bi ị́drị́ne romá.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Zɨ́ Abarayáma úkulúgu ledre zɨ́a kɨ́dí, ‘Sómụ́ aka lá sɨmɨ bɨ kóo áyí aka do sogo káṇgá ní, rokinyi nɨ dụụ́ ꞌbɨ eyị́, zɨ́ lerị́ ídíne dụụ́ ꞌbɨ Lázoro. Bɨ ba ní, áyí go sɨmɨ lerị́ Lázoro nɨ go sɨmɨ rokinyi. ");
INSERT INTO bdh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nda kpá lá dụụ́ née wá, mongụ́ gu nɨ go dongaráze kése. ꞌYị ndaá gɨ yáa ndéréne íri togụ́ gɨrí ógụné yáa wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Zɨ́ mongụ́ ꞌyị née úkulúgu ledre zɨ́ Abarayáma kɨ́dí, ‘Togụ́ kenée yá, kása nda lá Lázoro maꞌdáa zɨ́ze ꞌbe ꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Lúndumá e nɨyí bo íri ịnyị, idí úku ledre zɨ́ye ndanɨ́ méngị bɨsinyí ledre zɨ́ ꞌyị e wá, káa bɨ nɨyí ógụ kpá sɨmɨ ꞌdoꞌdó bɨ mááyí sɨmɨ a yáa ba ke.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Zɨ́ Abarayáma úkulúgu ledre zɨ́a kɨ́dí, ‘Ɨ́ꞌɨ Lázoro utúasá ndéré íri wá. Idínɨ́ ndị́sị úwú lorụ bɨ kóo Mụ́sa eké kɨ́ ledre ga bɨ kóo nébị e ndịsịnɨ́ úku yée ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Oꞌdo née ya, ‘Ɨ́ꞌɨ, mongụ́ ꞌyị, ili za cụ́ ꞌyị bɨ urú go gɨ sɨmɨ umbu ní, zɨ́a ndéréne uku ledre née zɨ́ye ne nɨyí fú ṇgúṇgu a.’ ");
INSERT INTO bdh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abarayáma ya zɨ́a ní, ‘Togụ́ utúasánɨ́ eyé ṇguṇgu ledre ꞌbɨ Mụ́sa e kɨ́ nébị e wá, abú ꞌyị urú gɨ sɨmɨ umbu zɨ́a ndéréne úku ledre zɨ́ye ya, utúasánɨ́ eyé kpá fú lá ṇgúṇgu a wá.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zɨ́ Yésụ ị́nyịné úku ngíti ledre zɨ́ ꞌyị lódụ́ kacɨ́ née kɨ́dí, “ꞌYị bɨ ndịsị lóndo lafúne e gɨ ro zɨ́ye lúyú ledre ní, nɨ go gbóo. ꞌYị máa née nɨ ndíki mongụ́ bɨsinyí nduwú. ");
INSERT INTO bdh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ꞌYị káa zɨ́ née, ꞌbe kóo do ódóngéṛị mongụ́ tutú ro goa do ụ́cụ wo kɨ́e bu sɨmɨ mongụ́ iní zɨ́a úyuné íri. Gɨ zɨ́ wo bɨ nɨ óto owụ́ bɨ cúkuꞌdée káa zɨ́ wo ba zɨ́a lúyú ledre ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Komosé idí ídí rosé. “Togụ́ ngúru ꞌyị gɨ dongará ꞌyị ga bɨ ṇguṇgunɨ́ ledremá go ní, luyú ledre go yá, ídísé lórụ wo. Togụ́ oyóloꞌbó sómụ́ ledre ené go yá, ídísé ótoómo ledre zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Togụ́ luyú ledre royị́ kɨ́ꞌdí ịnyị doa gbre (7) kadra kị́éꞌdo, zɨ́a kpá ógụné zɨ́yị kɨ́ꞌdí ịnyị doa gbre (7) kadra kị́éꞌdo ya ídí ótoómo ledre zɨ́ne yá, ídí ótoómo ledre zɨ́a.” ");
INSERT INTO bdh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kadra kị́éꞌdo zɨ́ ꞌyịmɨkása ꞌbɨ Yésụ ị́nyịyé úku ledre kɨ́dí, “Ngére, ídí sáká zée, zɨ́ze ṇgúṇgu ledre eyị́ nda za kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Abú ledre ꞌbɨ Lomo bɨ ṇgúṇgu ní nɨ cúkuꞌdée káa zɨ́ kúfú kágá bɨ musɨtáda ní yá, áyí útúásá úku ledre zɨ́ mongụ́ kágá bɨ káa zɨ́ ngónó ní kɨ́dí, ‘Ị́ꞌbịóyó royị́ gɨ ore, zɨ́yị ndéré tóroyị́ gbála sɨmɨ mɨkavu ꞌdáa.’ Kágá née nɨ úwú yị́ị, zɨ́a méngị a tɨ́ kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zɨ́ Yésụ kpá úku ngíti muruwayi zɨ́ye kɨ́dí, “Togụ́ ꞌyị ꞌbɨ moko ndaꞌbaogụ go ꞌbe gɨ do bi moko gáa ndịsị méngị a ní, mongụ́ ꞌyị ené nɨ geré úku ledre zɨ́a ya, ‘Ógụ ndị́sị bi ánu éyị́?’ ");
INSERT INTO bdh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ɨ́ꞌɨ, mongụ́ ꞌyị ené nɨ úku ledre zɨ́a kɨ́dí, ‘Méngị éyị́ mɨánu ꞌbɨ tagá zɨ́ma ánu a kí, áyí nda fú ógụ ndị́sị bi ánu ꞌbɨ ené éyị́.’ ");
INSERT INTO bdh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sɨmɨ ledre ga gére née mbá, mongụ́ ꞌyị née utúasá ené íꞌbí mbófo éyị́ zɨ́ ꞌyị moko née wá gɨ zɨ́a née moko bɨ ogụ gɨ roa ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ledre née nɨ gɨ rosé kpá kenée. Togụ́ méngịsé moko bɨ iꞌbínɨ́ zɨ́se ní go yá, ídísé lá úku a kɨ́dí, ‘Azé ꞌbɨ ezé lá ꞌyị ꞌbɨ moko e, ndịsịzé méngị dụụ́ moko bɨ iꞌbínɨ́ zɨ́ze ní.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sɨmɨ bɨ Yésụ nɨ do mɨsiꞌdi mɨndéréne sɨmɨ Yerụsaléma ní, nderé kóo kpụrụ́ gɨ dongará káṇgá ga bɨ gbre, Samáriya kɨ́ Galiláya ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Zɨ́ye ndéréógụyé go sɨmɨ ngíti do ꞌbé, zɨ́ yaꞌdá e sokó (10) mbá kɨ́ umbunonó royé ógụ tóroyé dogboṛụ mɨsiꞌdi re kenée. ");
INSERT INTO bdh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sɨmɨ bɨ Yésụ ogụ nda go gbóo ní, zɨ́ye ị́nyịyé mbá ótrụ́ ndólo wo kɨ́dí, “Áko, Yésụ, mongụ́ ꞌyị, ídí lúrú lerị́ze zɨ́yị sáká zée ke.” ");
INSERT INTO bdh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Zɨ́ Yésụ lúrú yée zɨ́a úku ledre zɨ́ye kɨ́dí, “Ídísé ndéré zɨ́ ꞌyị ꞌdáná éyị́ e gɨ ro zɨ́ye lúrú rosé togụ́ umbunonó née ụkụ́ go yá.” Nɨyí ndéréógụ yana ní, royé nɨ go bɨlámáne. ");
INSERT INTO bdh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sɨmɨ bɨ ngúruyé lurú roné nɨ go bɨlámáne ní, zɨ́a ndáꞌbaógụné ndị́sị íꞌbílúgu mbófo éyị́ zɨ́ Lomo kɨ́ kúrúne ꞌdága. ");
INSERT INTO bdh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Zɨ́a útúne lóꞌbụ komoné bi kóꞌdụ́ Yésụ ndị́sịné mbófo wo gɨ zɨ́a ndaá ꞌbɨ ené Yụ́da wá, nɨ gɨ sɨmɨ kúfú ꞌyị ga bɨ Samáriya e ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zɨ́ Yésụ ndúꞌyú wo kɨ́dí, “Ndaá ꞌbɨ ené bɨ gáa ásá sokó ní wá? Sara yée ga bɨ ịnyị doa eso ní nɨyí nda goó ꞌda? ");
INSERT INTO bdh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɨ zɨ́ ꞌyị lóṇgó ba ógụné dụụ́ ne íꞌbílúgu mbófo éyị́ zɨ́ Lomo ní?” ");
INSERT INTO bdh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zɨ́ Yésụ úku ledre zɨ́ oꞌdo máa née kɨ́dí, “Gɨ zɨ́a bɨ ṇgúṇgu ledre ꞌbɨ Lomo go ní, Lomo yomo yị́ị go, ndáꞌba yị́ eyị́ mu ꞌbe.” ");
INSERT INTO bdh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nda gɨ ore zɨ́ Farụsáyo e ndúꞌyú Yésụ kɨ́dí, “Lomo nɨ ógụ ídíne káa do ngére do sogo káṇgá kɨ́ be ꞌdi?” Yésụ ya zɨ́ye ní, “Mɨógụ Lomo ídíne káa do ngére, lurúnɨ́ eyé kɨ́ komo ꞌyị káa zɨ́ bɨ ndị́sịsé sómụ́ a née wá. ");
INSERT INTO bdh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ꞌYị e utúasánɨ́ kpá úku a bɨ kɨ́dí, ‘Lúrúsé aka, nɨ goó ba, togụ́ nɨ goó bɨ ꞌdáa ba wá,’ gɨ zɨ́a Lomo nɨ cakaba go dongaráse.” ");
INSERT INTO bdh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zɨ́ Yésụ úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Sịndị́ kadra nɨ ógụ zɨ́se ídíse nzíyisé gɨ ro lúrú mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí, tɨ́ lá útúásásé lúrúndíki a wá. ");
INSERT INTO bdh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ngíti géyị ꞌyị e nɨyí úku ledre zɨ́se kɨ́dí, ‘Owụ́ ꞌbɨ ꞌYịmaꞌdí ogụ go ona togụ́ mbú ogụ go ꞌdáa yá,’ ndásé úwú ledre eyé ga gére née wá. ");
INSERT INTO bdh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gɨ zɨ́a mɨndáꞌbaógụ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ídí káa zɨ́ mɨꞌbɨ́léꞌbe iní bɨ ꞌbɨleꞌbe zɨ́a óṇgóné kú gɨ komo ere zaá gị bi ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Éyị́ bɨ nɨ aka ídí ní, ꞌyị ga bɨ nɨyí aka trịdrị ba nɨyí ási gɨ romá, zɨ́ye ꞌdóꞌdo máa kɨ́ngaya kɨ́ tụ́ꞌdụ́ ṛị́kị́ sị́ do ꞌdoꞌdó e kí. ");
INSERT INTO bdh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sɨmɨ sịndị́ kadra bɨ Mááyí ndáꞌbaógụ sɨmɨ a ní, mɨméngị ledre ꞌbɨ ꞌyịmaꞌdí e nɨ ídí ené cé káa zɨ́ ledre kóo ꞌyị e ndịsịnɨ́ méngị a sɨmɨ sịndị́ kadra bɨ kóo ꞌbɨ Nówa ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ꞌYị e otonɨ́ yị́ eyé komoyé dụụ́ ro éyị́ mɨánu eyé e kɨ́ éyị́ mɨéwé eyé e, zɨ́ ngíti géyị kɨ́ ófụ́ royé. Zɨ́ ledre née méngị roné kenée gị sɨmɨ sịndị́ kadra bɨ zɨ́ Nówa kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ ené e ólụ́ye mbá sɨmɨ kuṛúngba ní. Zɨ́ mongụ́ iní úcuné úfuónzó ꞌyị ga bɨ kóo sága ní mbá. ");
INSERT INTO bdh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ledre née mengị kóo roné kpá kenée sɨmɨ sịndị́ kadra ꞌbɨ ngíti mongụ́ ꞌyị kɨ́ ịrịné Lóto. ꞌYị e otonɨ́ yị́ eyé kóo komoyé dụụ́ ro éyị́ mɨánu e kɨ́ éyị́ mɨéwé eyé e, ngíti géyị nɨyí ndị́sị ꞌbɨ eyé úgúóyó éyị́ e, ngíti géyị ndịsịnɨ́ ꞌbɨ eyé úgú éyị́ e zɨ́ye, ngíti géyị nɨyí ꞌbɨ eyé óꞌdo éyị́ ngíti géyị ndịsịnɨ́ ꞌbɨ eyé ụ́bụ́ ꞌdị́cị́ e. ");
INSERT INTO bdh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sɨmɨ sịndị́ kadra bɨ Lóto kɨ́ owụ́ ꞌbɨ ené e olụ́ogụnɨ́ gɨ sɨmɨ Sodóma ní, zɨ́ Lomo kasaogụ phoꞌdụ kɨ́ mɨnguṛogó so phoꞌdụ bɨ ndịsịnɨ́ ndóló a barụ́tụ ní gɨ komo ere ndị́sị éꞌdịné zɨ́ ꞌyị ga bɨ kóo ore ní áṛáónzó royé mbá. ");
INSERT INTO bdh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ledre née nɨ ídí cé kenée sɨmɨ sịndị́ kadra bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí ndáꞌbaógụ sɨmɨ a ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sɨmɨ sịndị́ kadra née ní, ꞌyị bɨ nɨ do ꞌdị́cị́ ní, ndaá ndítíógụ ólụ́ ꞌdị́cị́ gɨ ro ꞌdóꞌdụ́ ógụ yị́ ené e sága kí wá. Wo bɨ gáa nɨ ꞌbɨ ené yáká ní, utúasá ndáꞌbaógụ ꞌbe kí wá. ");
INSERT INTO bdh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ídísé sómụ́ndíki ledre bɨ kóo mengị meꞌbe Lóto ní. ");
INSERT INTO bdh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Togụ́ ꞌyị ya née ili ndị́sị lódụ́ kacɨ́ma wá káa bɨ née nɨ úyu yá, omo ené e wá. ꞌYị bɨ ya née nɨ lódụ́ kacɨ́ma, abú née uyu yá mengị éyị́ wá ní, uyu ené e wá. ");
INSERT INTO bdh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Máúku zɨ́se, sɨmɨ ndụlụ bɨ ledre née nɨ méngị roné sɨmɨ a ní, togụ́ ꞌyị e gbre nɨyí mɨꞌdúꞌduyé do ṛangba kị́éꞌdo yá, wo bɨ ṇguṇgu ledremá go ní, Lomo nɨ ꞌdíꞌbi dụụ́ wo zɨ́a ótoómo eze a née kenée. ");
INSERT INTO bdh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kará e gbre nɨyí do bi ụ́sụ éyị́, Lomo nɨ ꞌdíꞌbi wo bɨ ṇguṇgu ledremá go ní, zɨ́a ótoómo eze a née kenée. ");
INSERT INTO bdh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kpá kenée yaꞌdá e nɨyí ídí yáká gbre, wo bɨ ṇguṇgu ledremá go ní, Lomo nɨ ꞌdíꞌbi dụụ́ wo zɨ́a ótoómo eze a née kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née úku ledre zɨ́a kɨ́dí, “Ngére, ledre máa née nɨ méngị roné ꞌda?” Zɨ́ Yésụ úkulúgu ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, “Ledre máa née loꞌbo wá, nɨ ídí cé káa zɨ́ umbu bangá bɨ bi zɨ́ lugúnu e ówo a mbá ní.” ");
INSERT INTO bdh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ꞌdódo ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née gɨ ro ledre ꞌbɨ ini zɨ́ Lomo, ndanɨ́ ꞌdóꞌdó gɨ zɨ́ íni ini zɨ́ Lomo wá. ");
INSERT INTO bdh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ngíti ngére ꞌbɨ ngíti káṇgá nɨ kóo bo, ndaá ꞌbɨ ené ꞌyị éré Lomo wá, somụ́ ené kpá do ꞌyị e wá. ");
INSERT INTO bdh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kára umbu nɨ kóo bo sɨmɨ káṇgá ꞌbɨ ngére máa née ngíti géyị ꞌyị e mengịnɨ́ kóo wo bɨsinyíne. Zɨ́ kára née ndị́sị éṛịné kɨ́ ngbanga ené née zɨ́ ngére née má. ");
INSERT INTO bdh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Zɨ́ ngére née ásiné kɨ́ sáká kára née kɨ́ ngbángbá sịndị́ kadra. Odụ a, zɨ́a úku ledre zɨ́ne kɨ́ roné kɨ́dí, ‘Abú mándá ꞌyị éré Lomo wá, másómụ́ kpá do ꞌyịmaꞌdí e wá yá, ");
INSERT INTO bdh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nɨ mɨútúásáne zɨ́ma sáká kára ba. Togụ́ máméngị kenée wá, nɨ fú lá ndị́sị ógụ ꞌdóꞌdo máa.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Ngére née ndaá ꞌbɨ ené ꞌyị éré Lomo wá, sómụ́sé aka sɨmɨ ledre bɨ uku née. ");
INSERT INTO bdh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sómụ́sé Lomo utúasá méngị bɨlámá ledre zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ndúꞌyú wo gbụụ́ gɨ ro sáká éyị́ ní wá? Nɨ ndị́sị ógólúgu yée fú lá mɨógólúgu? ");
INSERT INTO bdh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nɨ ndị́sị sáká yée ꞌdiya. Sɨmɨ bɨ karanée, Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ ní, nɨ kpá fú ógụndíki ꞌyị e kɨ́ ṇgúṇgu ledrené?” ");
INSERT INTO bdh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zɨ́ Yésụ kpá úku muruwayi gɨ ro ꞌyị ga bɨ ndịsịnɨ́ lúrú royé kɨ́dí yée nɨyí ye mbigí ꞌyị ꞌbɨ Lomo, zɨ́ye ndị́sịyé lúrú cáyi lafúye e mbá mɨlúrú cáyi ní ");
INSERT INTO bdh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","kɨ́dí, “Kadra kị́éꞌdo, zɨ́ yaꞌdá e gbre ị́nyịyé ndéréye sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo íni ini zɨ́ Lomo. Ngíti a ꞌbɨ ené Farụsáyo, ngíti a ꞌbɨ ené ꞌyị ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Zɨ́ wo bɨ Farụsáyo ní ị́nyị tóroné ꞌdága mbófo roné zɨ́ Lomo kɨ́dí, ‘Mbófo éyị́ zɨ́yị Lomo, gɨ zɨ́a mándá ꞌbɨ amá ꞌyị lúyú ledre káa zɨ́ ꞌyị ugu e wá, kpá káa zɨ́ ngíti géyị ꞌyị ga bɨ ndịsịnɨ́ méngị bɨsinyí ledre ní wá, máóto komomá dụụ́ ro meꞌbemá. Mándá ꞌbɨ amá kpá káa zɨ́ ꞌyị ꞌdóꞌdụ́ ụsórụ bɨ ꞌdáa ba wá. ");
INSERT INTO bdh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sɨmɨ sị́lị́ ịnyị doa gbre (7), mándị́sị órụ́ taramá kɨ́ꞌdí gbre máánu éyị́ wá. Zɨ́ma ndị́sịmá íꞌbí ngíti géyị éyị́ ga bɨ mándị́sị ndíki yée ní káa do tákpásị́lị́ zɨ́yị.’ ");
INSERT INTO bdh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nda née ní, zɨ́ ngíti oꞌdo bɨ nɨ ꞌbɨ ené ꞌyị ꞌdóꞌdụ́ ụsórụ ba ị́nyịné ꞌbúóꞌbụ́ roné ndéré tóroné gbála, ótụ́ doné bi kɨ́ lerị́ gɨ zɨ́ lúyú ledre ené ndị́sị íni ini zɨ́ Lomo kɨ́ ndị́sị óngbo kóꞌdụ́ne kɨ́dí, ‘Lomo, mááyí ꞌyị lúyú ledre, ídí ótoómo ledre zɨ́ma.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zɨ́ Yésụ úku ledre zɨ́ye kɨ́dí, “Máúku zɨ́se maꞌdíi, ꞌyị bɨ ndaꞌba gɨ ore drá lúyú ledre ndaá lolụ roa wá ní, nɨ wo bɨ ndịsị ꞌbúóꞌbụ́ roné íni ini zɨ́ Lomo ní, ndaá Farụsáyo bɨ gáa née wá. ꞌYị bɨ ndịsị ꞌbúóꞌbụ́ roné mɨꞌbúóꞌbụ́ ní, nɨ ídí kɨ́ ledrené owóowó, wo bɨ ndịsị óto ledrené owóowó ní, nɨyí óto wo nde.” ");
INSERT INTO bdh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kadra kị́éꞌdo zɨ́ ꞌyị e ndị́sị ógụyé kɨ́ owụ́ ꞌbɨ eyé e zɨ́ Yésụ gɨ ro zɨ́a íꞌbí úndru zɨ́ye. Zɨ́ ledre née kóo sínyí ené ro ꞌyị lódụ́ kacɨ́ga mɨsínyí. Zɨ́ye úku ledre kɨ́dí ndásé ndị́sị ꞌdóꞌdo mongụ́ ꞌyị kɨ́ ledre esé née wá. ");
INSERT INTO bdh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yésụ ya zɨ́ye ní, “Ídísé ótoómo mɨnzéré owụ́ e zɨ́ye ógụyé zɨ́ma, ndásé ógólúgu yée wá. Mbigí ꞌyị ga bɨ ꞌbɨ ꞌbe ꞌbɨ Lomo ní, yị́ ené dụụ́ yée ga bɨ ndịsịnɨ́ ótoómo royé káa zɨ́ mɨnzéré owụ́ e ní. ");
INSERT INTO bdh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Maꞌdíi, ꞌyị ga bɨ ilinɨ́ ótoómo royé káa zɨ́ mɨnzéré owụ́ e zɨ́ Lomo ídíne Ngére eyé wá ní, utúasánɨ́ ógụ ꞌbe ꞌbɨ Lomo wá.” ");
INSERT INTO bdh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kadra kị́éꞌdo zɨ́ ngíti mongụ́ ꞌyị ógụné ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, áyí bɨlámá ꞌyị ꞌdódo ledre, éyị́ bɨ máídí méngị a zɨ́ma ndíki trịdrị bɨ za fí ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zɨ́ Yésụ úkulúgu ledre zɨ́a kɨ́dí, “Éyị́ bɨ ndólo máa gɨ roa bɨlámá ꞌyị ní ꞌdi? Odụ bɨlámáne ꞌyị yị́ ené dụụ́ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ówo lorụ bɨ Mụ́sa eké kɨ́dí, ‘Ndásé sóꞌdo rosé kɨ́ ꞌyị bɨ ófụ́sé rosé kéne wá ní wá, ndá úfu ꞌyị wá, ndá úgu ugu wá, ndá ṛáṛanga wá, ídí óto úndru ꞌbụyị́ kɨ́ mbágáyị ní bú bɨlámáne.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Mátónó kóo méngị ledre ga gére née go kú gɨ do owụ́ma ndéréógụné gị karaba.” ");
INSERT INTO bdh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sɨmɨ bɨ Yésụ uwú ledre née kenée ní, zɨ́a úku ledre zɨ́a kɨ́dí, “Bɨlámáne, ngítí ledre nɨ bo kị́éꞌdo méngị aka wá. Ídí ndéré úgúóyó éyị́ ga bɨ zɨ́yị ꞌbe ní mbá ꞌdáꞌba. Zɨ́yị íꞌbí késị́ye zɨ́ ꞌyị lerị́ e, zɨ́yị ndáꞌbaógụyị́ lódụ́ kacɨ́ma. Áyí ídí kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́yị komo ere.” ");
INSERT INTO bdh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sɨmɨ bɨ oꞌdo née uwú ledre née kenée ní, zɨ́ bi sínyíne roa gɨ ro éyị́ ené e gɨ zɨ́a nɨ ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní. ");
INSERT INTO bdh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zɨ́ Yésụ lúrú kacɨ́ oꞌdo née kɨ́ ndéré, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne e kɨ́dí, “Máúku zɨ́se maꞌdíi, nɨ mɨórụné kɨ́ngaya zɨ́ ꞌyị ga bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye ní gɨ ro zɨ́ye ógụyé ꞌbe ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nɨ ídí mɨꞌdiyíne zɨ́ gémele ólụ́phụ́trụ bi gɨ sɨmɨ gu lị́bịra, tɨ́ lá nɨ ídí mɨórụné kɨ́ngaya zɨ́ ꞌyị bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní ógụné ꞌbe ꞌbɨ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zɨ́ ꞌyị ga bɨ uwúnɨ́ ledre bɨ Yésụ úku née ndúꞌyú Yésụ kɨ́dí, “Togụ́ nda go kenée ní, ambí nɨ nda ómo ne?” ");
INSERT INTO bdh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Éyị́ bɨ nɨ mɨórụné zɨ́ ꞌyịmaꞌdí e ní, orụ ené zɨ́ Lomo wá.” ");
INSERT INTO bdh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Zɨ́ Pétero úku ledre zɨ́a kɨ́dí, “Mongụ́ ꞌyị, sara zée ga bɨ otoomozé yị́ ezé e go mbá zɨ́ze íꞌbí rozé lódụ́ kacɨ́yị ba, ledre nɨ ídí gɨ rozé káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Maꞌdíi, togụ́ ꞌyị otoomo ꞌbe ꞌbɨ ené go, kɨ́ meꞌbené kɨ́ owụ́ ꞌbɨ ené e, lúnduné e kɨ́ ꞌyị ga ndikiogụnɨ́ wo ní gɨ ro zɨ́ne ídíne ꞌyị ꞌbɨ ꞌbe ꞌbɨ Lomo yá, ");
INSERT INTO bdh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Lomo nɨ íꞌbí tụ́ꞌdụ́ éyị́ e zɨ́ ꞌyị máa née, zɨ́a kpá ndíki trịdrị bɨ za fí ní gɨ zɨ́ Lomo maꞌdáa.” ");
INSERT INTO bdh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ ndólo ꞌyịmɨkása ené ga bɨ sokó doa gbre née ꞌdí sogo, zɨ́a úku ledre zɨ́ye kɨ́dí, “Káa zɨ́ bɨ azé go ndéré sɨmɨ Yerụsaléma ba, ídísé ówo a bɨlámáne kɨ́dí, ledre ga bɨ kóo nébị e ukunɨ́ yée ꞌdesị́, gɨ ro Owụ́ ꞌbɨ ꞌYịmaꞌdí ní, nɨyí go ógụ méngị royé mbá káa zɨ́ bɨ kóo ukunɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nɨyí íꞌbí ngbángá a zɨ́ asikíri ga bɨ ꞌbɨ Róma ní, zɨ́ye ndị́sịyé kɨ́ fóló wo, kɨ́ úkucáyi wo, zɨ́ ngíti géyị kɨ́ údru súrú roa, zɨ́ye ócó wo, do ꞌdíꞌbi wo úfu a. ");
INSERT INTO bdh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sɨmɨ bɨ otonɨ́ bi zɨ́a ní, zɨ́a méngịné lá dụụ́ sị́lị́ gbre, nda sɨmɨ ota sị́lị́, zɨ́a úrú ené.” ");
INSERT INTO bdh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ꞌYị lódụ́ kacɨ́ga owonɨ́ eyé ini ledre gɨ sɨmɨ ledre bɨ ndịsị úku a née wá. Gɨ zɨ́a ledre née nɨ yị́ ené mɨótoécịné gɨ zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sɨmɨ bɨ Yésụ nderé ógụ go gbóo kɨ́ Zérịko ní, zɨ́ye ógụndíki ngíti oꞌdo komoa ndaá mɨndị́sịné dogboṛụ mɨsiꞌdi kenée ndị́sị ómbo éyị́ gɨ zɨ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sɨmɨ bɨ uwú do tụ́ꞌdụ́ ꞌyị e kɨ́ ndị́sị ndéré ní, zɨ́a ndúnduꞌyú kɨ́dí, “ꞌBɨé karaba ledre ꞌdi bɨ tụ́ꞌdụ́ ꞌyị e ndịsịnɨ́ ndéré káa ní ní?” ");
INSERT INTO bdh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Zɨ́ ngíti géyị ꞌyị e úku ledre zɨ́a kɨ́dí, “Yésụ bɨ ꞌyị ꞌbɨ Nazeréta ní ndéréne bɨ zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sịyé lódụ́ wo née.” ");
INSERT INTO bdh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Geré zɨ́ oꞌdo née gbúrógbóne ꞌdága kɨ́dí, “Yésụ bulúndu ngére Dawídi, ídí ówo ledre kɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Zɨ́ ngíti géyị ꞌyị e gɨ dongará ꞌyị ga bɨ nɨyí ndị́sị ndéré née ị́nyịyé ụ́cụómo wo kɨ́dí, ndá gbúrógbó wá. Zɨ́a nda gbúrógbóne ꞌdáꞌdá kɨ́ngaya kɨ́dí, “Yésụ bulúndu ngére Dawídi, ídí ówo ledre kɨ́ma.” ");
INSERT INTO bdh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zɨ́ Yésụ tóroné zɨ́a úku ledre zɨ́ ꞌyị ga gére née idínɨ́ ꞌdíꞌbiógụ oꞌdo née gɨrí zɨ́ne yáa. Sɨmɨ bɨ ꞌdiꞌbiogụnɨ́ wo ní, zɨ́ Yésụ ndúꞌyú wo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Éyị́ bɨ íli máídí méngị a zɨ́yị ní ꞌdi?” Zɨ́a úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ngére, máíli lá dụụ́ lúrú bi.” ");
INSERT INTO bdh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Gɨ zɨ́a bɨ ṇgúṇgu ledre ꞌbɨ Lomo go ní, komoyị́ likpí mu.” ");
INSERT INTO bdh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tɨ́ maꞌdíi, zɨ́ komoa líkpíne zɨ́a geré útúne do kacɨ́ Yésụ ndéré kɨ́ íꞌbílúgu mbófo éyị́ zɨ́ Lomo. Sɨmɨ bɨ tụ́ꞌdụ́ ꞌyị ga gére née lurúnɨ́ ledre bɨ mengị roné née kenée ní, zɨ́ye tónóye kpá ndị́sị mbófo Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zɨ́ Yésụ ógụyé sɨmɨ ngíti gara kɨ́ ịrịné Zérịko, nɨ yị́ ené fú lá mɨndéréókpóne. ");
INSERT INTO bdh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ngíti mongụ́ ꞌyị kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne nɨ sɨmɨ gara née ore kɨ́ ịrịné Zakáyo, nɨ manda ꞌdáꞌdá ꞌbɨ ꞌyị ꞌdóꞌdụ́ ụsórụ gɨ zɨ́ ꞌyị e ndị́sị íꞌbí a zɨ́ akúma. ");
INSERT INTO bdh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sɨmɨ bɨ Yésụ olụ́ sɨmɨ gara née ore ní, Zakáyo ili kóo gɨ ro zɨ́ne lúrú wo, mɨsiꞌdi ndaá zɨ́a wá gɨ zɨ́a nɨ gbụ́gbụ́ ꞌyị, ꞌyị e ofụnɨ́ kóo go. ");
INSERT INTO bdh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zɨ́ Zakáyo ngásá ꞌdécị bi ndéré ékị́ne komo mongụ́ bongó kɨ́ꞌdí bɨ Yésụ nɨ ógụ ndéréókpóne gɨ ore ní. ");
INSERT INTO bdh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zɨ́ Yésụ ógụné sị́ kágá née ore, zɨ́a lúrú bi ꞌdága, zɨ́a ndólo Zakáyo kɨ́dí, “Zakáyo ndítí ógụ gɨrí mu ꞌdiya, mááyí ba ndéré ṇgu ꞌbe ꞌbɨ eyị́.” ");
INSERT INTO bdh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zɨ́ Zakáyo ndítí ógụné ꞌdíꞌbi Yésụ ndéré kɨ́e ꞌbe ꞌbɨ ené, zɨ́a yéme mongụ́ éyị́ mɨánu zɨ́ Yésụ kɨ́ ꞌyị ené e mbá. ");
INSERT INTO bdh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ꞌYị ga bɨ owonɨ́ Zakáyo bú ní, sɨmɨ bɨ uwúnɨ́ ledre bɨ Yésụ uku kɨ́dí née nɨ ṇgu ꞌbɨ Zakáyo ní, zɨ́ye ndị́sịyé úku mɨngụ́ngụ́rụ́ ledre kɨ́dí, “Nderé ṇgu ꞌbe ꞌbɨ ꞌyị lúyú ledre.” ");
INSERT INTO bdh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sɨmɨ bɨ ndịsịnɨ́ nda go ní, zɨ́ Zakáyo ị́nyịógụné úku ledre zɨ́ Yésụ kɨ́dí, “Ngére, éyị́ ga bɨ ꞌbɨ amá ꞌbɨ ꞌbe ní, mááyí ífi sɨmɨyé íꞌbí yée zɨ́ ꞌyị lerị́ e. Togụ́ máꞌdíꞌbi kóo késị́ go gɨ zɨ́ ꞌyị e kɨ́ yatané sɨmɨ ugu yá, mááyí íꞌbílúgu a zɨ́ye kpá kɨ́ yatané rómoné mɨrómo kɨ́ꞌdí eso (4).” ");
INSERT INTO bdh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zɨ́ Yésụ ị́nyịné uku ledre zɨ́ Zakáyo kɨ́dí, “Zakáyo, yị́ị kɨ́ ꞌyị ꞌbɨ ꞌbe ꞌbɨ eyị́ e mbá, Lomo otoomo lúyú ledre esé go karaba gɨ zɨ́a áyí bulúndu Abarayáma. ");
INSERT INTO bdh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Owụ́ ꞌbɨ ꞌYịmaꞌdí ogụ ené gɨ ro bɨlámá ꞌyị e wá, ogụ yị́ ené gɨ ro gámásóꞌdo ꞌyị lúyú ledre e gɨ ro yómo yée.” ");
INSERT INTO bdh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zɨ́ ꞌyị e ndị́sịyé kpá fú uwú ledre ga bɨ Yésụ ndịsị úku yée ní. Sɨmɨ bɨ nderéogụnɨ́ go gbóo kɨ́ mongụ́ gara bɨ Yerụsaléma ní, ngíti géyị ꞌyị e somụ́nɨ́ ꞌbɨ eyé kóo go geré kɨ́dí sịndị́ kadra bɨ zɨ́ye ídíye ꞌyị ꞌbɨ ꞌbe ꞌbɨ Lomo ní ogụ go. Gɨ zɨ́ kéyị née ní, zɨ́ Yésụ úku ledre zɨ́ye sɨmɨ muruwayi kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ngíti mongụ́ ꞌyị ịnyị kóo gɨ sɨmɨ káṇgá ené ndéréne sɨmɨ ngíti káṇgá gɨ ro do óto née gɨrí mongụ́ ngére, zɨ́ne ndáꞌbaógụné ídíne ngére sɨmɨ káṇgá ené. ");
INSERT INTO bdh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sɨmɨ bɨ ayí go gɨ ro ndéré ní, zɨ́a ndólo ꞌyị ené ga bɨ sokó ꞌbɨ moko ore ní, zɨ́a ótoómo késị́ do sị́lị́ye kɨ́dí, ‘Ídí méngị moko kɨ́ késị́ amá ba zɨ́a ngbóróne zɨ́ma ndáꞌbaógụmá ndíki a.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tụ́ꞌdụ́ ngíti géyị ꞌyị ga bɨ sị́ sị́lị́a ore ní, sogónɨ́ yị́ eyé wo mɨsógó. Zɨ́ye kása ꞌyị zɨ́ mongụ́ ngére kɨ́dí, ‘Ilizé ezé do óto oꞌdo née káa do ngére dozé wá.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sɨmɨ ledre ga gére née mbá, do tɨ́ óto wo káa do ngére. Sɨmɨ bɨ ndaꞌbaogụ ní, zɨ́a kákasa zɨ́ ꞌyị ꞌbɨ moko ené ga bɨ otoomo késị́ do sị́lị́ye gɨ ro zɨ́ye ngbóró a ní, ili go zɨ́ne ówo a. ");
INSERT INTO bdh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Zɨ́ mɨzefịyé úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, késị́ kóo íꞌbí zɨ́ma míya kị́éꞌdo gɨ ro ngbóró a ní, ndikiogụ owụ́ e go míya sokó.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mongụ́ ꞌyị ené ya zɨ́a ní, ‘Mbófo éyị́ áyí bɨlámá ꞌyị ꞌbɨ moko. Káa zɨ́ bɨ útúásá go lúrú bi kacɨ́ owụ́ késị́ bɨ cúkuꞌdée ní, máóto yị́ị go káa do ngúru mongụ́ ꞌyị ndị́sị lúrú bi kacɨ́ gara amá e sokó.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Zɨ́ gbre ꞌyị úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, késị́ máa ꞌbɨ amá bɨ íꞌbí zɨ́ma míya kị́éꞌdo gɨ ro ngbóró a ní, ndikiogụ owụ́ e go míya ịnyị.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Mongụ́ ꞌyị ya zɨ́a ní, ‘Máóto yị́ị go káa do ngúru mongụ́ ꞌyị ndị́sị lúrú bi kacɨ́ gara amá e kpá ịnyị.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Zɨ́ ota ꞌyị ꞌdíꞌbiógụ ꞌbɨ ené tɨ́ dụụ́ komo késị́ kóo mongụ́ ꞌyị ené iꞌbí zɨ́a ní. Zɨ́a úku ledre kɨ́dí, ‘Mongụ́ ꞌyị, ꞌbɨ amá késị́ bɨ íꞌbí zɨ́ma míya kị́éꞌdo ní nɨ goó ba, cé do bi née. Máódó wo, zɨ́ma ótoécị a ṛịị́ káa bɨ nɨ ị́ndrị. ");
INSERT INTO bdh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Máméngị kenée gɨ zɨ́ ngịrị, gɨ zɨ́a ndá ꞌbɨ eyị́ ꞌyị ndéndeke kɨ́ ꞌyị e wá. Éyị́ bɨ ngárá ndaá ꞌbɨ eyị́ wá ní, ndị́sị ꞌdíꞌbi a. Éyị́ kacɨ́ ngíti ꞌyị gɨ yáká, zɨ́yị ꞌdíꞌbi a káa zɨ́ ꞌdị́yị́ yị́ị ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ngére ya zɨ́a ní, ‘Áyí bɨcayi ꞌyị ꞌbɨ moko. Mááyí go ꞌdécị ngbangayị́ káa zɨ́ bɨ úku née. Ówo bú bɨlámáne kɨ́dí, mándá ꞌyị ndeke wá. Éyị́ bɨ ngárá ndaá ꞌbɨ amá wá ní, mándị́sị ꞌdíꞌbi a. Éyị́ kacɨ́ ngíti ꞌyị yáká, zɨ́ma ꞌdíꞌbi a káa zɨ́ máꞌdị́yị́ máa ní. ");
INSERT INTO bdh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Éyị́ bɨ óto késị́ amá gɨ zɨ́a sɨmɨ moko gɨ ro zɨ́a ngbóróne wá ní ꞌdi? Káa bɨ mááyí ógụ ba ndíki a ndiki owụ́ go.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Zɨ́ ngére úku ledre zɨ́ ngíti géyị ꞌyị ꞌbɨ moko ga bɨ nɨyí mɨtóroyé kenée ní kɨ́dí, ‘ꞌDíꞌbisé míya bɨ kị́éꞌdo née mu gɨ zɨ́a zɨ́se íꞌbí a zɨ́ wo bɨ nɨ kɨ́e zɨ́ne sokó ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Zɨ́ ngíti géyị ꞌyị ꞌbɨ moko ga gére née úkulúgu ledre zɨ́ ngére kɨ́dí, ‘Mongụ́ ꞌyị, ezezé née nɨ go kɨ́ késị́ zɨ́ne ꞌdényé sokó.’ ");
INSERT INTO bdh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ngére ya zɨ́ye ní, ‘Máúku zɨ́se maꞌdíi, ꞌyị bɨ nɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ne ní, nɨyí íꞌbí yata a zɨ́a. Wo bɨ kɨ́ éyị́ e zɨ́ne cúkuꞌdée ní, nɨyí ꞌdíꞌbióyó a gɨ zɨ́a ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ꞌYị ga bɨ otonɨ́ royé káa do ezeokóma e ní, ídísé ꞌdíꞌbiógụ yée kóꞌdụ́ma ona úfu yée ꞌdáꞌba.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nda gɨ do kacɨ́ ledre ga bɨ Yésụ uku yée ní, zɨ́ Yésụ ị́nyịné kpá fú lódụ́ mɨsiꞌdi ndéréne sɨmɨ Yerụsaléma. ");
INSERT INTO bdh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sɨmɨ bɨ nderéogụ go gbóo kɨ́ owụ́ gara ga bɨ gbre Betefége kɨ́ Beteníya do landa bɨ kɨ́ kágá ga bɨ ndịsịnɨ́ ndólo yée Olíva doné ní, zɨ́a kása ꞌyị lódụ́ kacɨ́ne e gbre kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ndéréókpósé mu sɨmɨ gara bɨ kóꞌdụ́ze íri née, sɨmɨ bɨ ásé go ólụ́ íri ní, ásé ndíki phɨṛangá Dongí bɨ ngárá ekị́nɨ́ aka doa wá ní mɨódóótoné dogboṛụ mɨsiꞌdi kenée. Ídísé líkpí a ógụ kɨ́e zɨ́ma yáa. ");
INSERT INTO bdh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Togụ́ ngíti ꞌyị nduꞌyú sée ya líkpísé bangá née gɨ ro ꞌdíya yá, ídísé úku a zɨ́a kɨ́dí, ‘Ngére iline.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Zɨ́ yaꞌdá ga gére née ndéréye ndíki éyị́ e tɨ́ káa zɨ́ bɨ gáa ngére uku ní. ");
INSERT INTO bdh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sɨmɨ bɨ tonónɨ́ líkpí a ní, zɨ́ mị́ngị́ga úku ledre kɨ́dí, “Ndị́sịsé líkpí bangá née gɨ ro ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Ngére iline.” ");
INSERT INTO bdh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Zɨ́ye ógụ kɨ́ bangá née, zɨ́ye ónzó bongó eyé e doa, zɨ́ye ị́mbị́óto Yésụ gá doa. ");
INSERT INTO bdh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zɨ́ ngíti géyị ꞌyị e ónzó ꞌbɨ eyé bongó eyé e do mɨsiꞌdi óto úndru Yésụ kɨ́e gɨ ro zɨ́a ógụ ndéréókpóne gɨ doa. ");
INSERT INTO bdh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sɨmɨ bɨ nderéogụ go gbóo kɨ́ mɨsiꞌdi bɨ ndụṛụꞌbụ́ gɨ do Landa Olíva ní, zɨ́ tụ́ꞌdụ́ ꞌyị lódụ́ kacɨ́ga ga gére née tónóye ndị́sị mbófo Lomo kɨ́ mongụ́ rokinyi kɨ́ kúrúye ꞌdága kacɨ́ mɨngburoko ledre ga bɨ Yésụ mengị yée zɨ́ye lúrú a za cụ́ kɨ́ komoyé ní. ");
INSERT INTO bdh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Zɨ́ye ndị́sịyé úku ledre kɨ́dí, “Úndru idí ídí zɨ́ ngére bɨ ogụ kɨ́ ịrị Ngére Lomo ní.” “Mɨndị́sị ezé kéye idí ídí bɨlámáne. ꞌYị e za mbá idínɨ́ íꞌbí mbófo éyị́ zɨ́ Lomo bɨ nɨ komo ere ní.” ");
INSERT INTO bdh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Zɨ́ ngíti géyị Farụsáyo ga bɨ dongará tụ́ꞌdụ́ ꞌyị ga gére ní ị́nyịyé úku ledre zɨ́ Yésụ kɨ́dí, “Mongụ́ ꞌyị, ídí úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ ꞌyị ga gére née ndanɨ́ ndị́sị úku ledre kɨ́ gbúrógbó kenée wá.” ");
INSERT INTO bdh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yésụ ya zɨ́ye ní, “Máúku zɨ́se maꞌdíi, togụ́ yaá ꞌyị ga gére née ndanɨ́ gbúrógbó wá, tutú ga bɨ bi née nɨyí ị́nyị mbá gbúrógbó kɨ́ ndị́sị mbófo máa.” ");
INSERT INTO bdh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sɨmɨ bɨ nderéogụ go gbóo kɨ́ Yerụsaléma, lurú do gara go cáa ní, zɨ́a útúne íni ini. ");
INSERT INTO bdh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Zɨ́a úku ledre kɨ́dí, “Áko ꞌyị ga bɨ ꞌbɨ Yerụsaléma ní, ꞌyị lódụ́ kacɨ́ma owonɨ́ éyị́ bɨ yée nɨyí méngị a zɨ́ dongaráye ídíne bɨlámáne kɨ́ Lomo ní go. Nɨ kóo ídí bɨlámáne togụ́ ị́nyịsé káa mbá ówo a kenée ní. Tɨ́ lá nɨ yị́ ené mɨlóꞌboné gɨ zɨ́se. ");
INSERT INTO bdh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ídísé ówo a kɨ́dí, ezeokóse nɨyí ógụ tóro ꞌdíkí gara esé gbaá, zɨ́ye ndị́sịyé ị́cị́ okó rosé bi ólụ́ógụsé ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nɨyí ꞌdéwe gara née, zɨ́ye sínyiónzó éyị́ ga bɨ ore ní mbá ngítí éyị́ bɨ nɨ ídíáká ní ndaá. Éyị́ née nɨ méngị roné kenée gɨ zɨ́a ówosé esé sịndị́ kadra bɨ Lomo ógụ yómo sée sɨmɨ a ní wá.” ");
INSERT INTO bdh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zɨ́ Yésụ ólụ́ne do ligá ꞌDị́cị́ ꞌbɨ Lomo, zɨ́a lágaóyó ꞌyị ga bɨ ndịsịnɨ́ úgúóyó éyị́ e ore ní mbá ꞌdáꞌba. ");
INSERT INTO bdh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Nɨ mɨékéne sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘ꞌDị́cị́ amá nɨ ꞌdị́cị́ ꞌbɨ ini zɨ́ma,’ ‘Tɨ́ lá óyólóꞌbósé nda yị́ esé go káa do bi lóꞌbo ꞌbɨ ꞌyị ugu e.’ ” ");
INSERT INTO bdh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gɨ do kacɨ́ ledre née ní, zɨ́a nda ndị́sịné ꞌdódo ledre zɨ́ ꞌyị e sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo kacɨ́ kadra mbá. Gɨ zɨ́ ledre née ní, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e, kɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌdódo lorụ bɨ Mụ́sa eké ní, kpá kɨ́ ngíti géyị mɨngburoko ꞌyị e, zɨ́ye ndị́sịyé yéme ledre gɨ ro úfu Yésụ. ");
INSERT INTO bdh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mɨsiꞌdi bɨ zɨ́ye ndíki a gɨ ro úfu wo ní nda gɨ zɨ́a ꞌyị e ndịsịnɨ́ yị́ eyé mbá úwú ledre ga bɨ Yésụ maꞌdáa ndịsị úku yée ní. ");
INSERT INTO bdh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kadra kị́éꞌdo zɨ́ Yésụ ndị́sịné ꞌdódo ledre kpá kɨ́ úku bɨlámá ledre ꞌbɨ Lomo zɨ́ ꞌyị e do ligá ꞌDị́cị́ ꞌbɨ Lomo. Nɨ ídí kɨ́e ní, manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kɨ́ ꞌyị ꞌdódo lorụ e ꞌbɨ Mụ́sa nda kpá kɨ́ ngíti géyị mɨngburoko ꞌyị ꞌbɨ Yụ́da maáge ogụnɨ́ go. Zɨ́ye ndúꞌyú Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Yị́ị ba, ambí iꞌbí rokoꞌbụ zɨ́yị ndị́sịyị́ ꞌdódo ledre kɨ́e sɨmɨ ꞌDị́cị́ Kótrụro ní ne?” ");
INSERT INTO bdh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “ꞌDáꞌdá zɨ́ma kɨ́ úkulúgu ledre zɨ́se, mándúꞌyú aka sée. ");
INSERT INTO bdh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Rokoꞌbụ bɨ Yiwáni ndịsị íꞌbí babatị́za kɨ́e zɨ́ ꞌyị e née ndiki gɨ ꞌda? Lomo iꞌbí zɨ́a ne gɨ komo ere, togụ́ kenée wá ní, nda ꞌyịmaꞌdí e gɨ do sogo káṇgá gɨ ona?” ");
INSERT INTO bdh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Zɨ́ yaꞌdá ga gére née tónóye ódroyé dongaráye kɨ́dí, “Togụ́ uku luguzé ledre zɨ́a kɨ́dí, Lomo iꞌbí rokoꞌbụ ne zɨ́ Yiwáni yá, nɨ geré úku a kɨ́dí, ‘Sara togụ́ kenée ní ṇguṇguzé nda ledre ené wá gɨ ro ꞌdi?’ ");
INSERT INTO bdh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Togụ́ ukuzé kɨ́dí, ‘ꞌYịmaꞌdí,’ iꞌbí rokoꞌbụ née ne zɨ́a yá, ꞌyị ga bɨ ndịsịnɨ́ úwú ꞌdódo ledre ené ní, nɨyí zíngi zɨ́ye óngbo zée kɨ́ tutú gɨ zɨ́a nɨ go sɨmɨ doyé bɨlámáne kɨ́dí Yiwáni nɨ yị́ ené nébị.” ");
INSERT INTO bdh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zɨ́ye ị́nyịyé úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Owozé wá togụ́ Yiwáni ndiki rokoꞌbụ née gɨ ꞌdáya yá.” ");
INSERT INTO bdh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yésụ ya zɨ́ye ní, “Togụ́ kenée yá, máúku lúgu amá kpá ledre zɨ́se kacɨ́ nduꞌyú esé née wá.” ");
INSERT INTO bdh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gɨ do kacɨ́ ledre née ní, zɨ́ Yésụ úku muruwayi kɨ́dí, “Ngíti oꞌdo oꞌdo kóo yáká ené, zɨ́a ótoómo a do sị́lị́ ngíti géyị ꞌyị e idínɨ́ ndị́sị méngị moko sɨmɨ a. Zɨ́a ị́nyịné ndéréne gbála sɨmɨ ngíti káṇgá. ");
INSERT INTO bdh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sɨmɨ bɨ éyị́ ga bɨ yáká née anánɨ́ go ní, zɨ́ mị́ngị́ yáká máa née kása ngúru ꞌyị ꞌbɨ moko ené idí ndéré zɨ́ ꞌyị ga bɨ ndịsịnɨ́ méngị moko yáká ené íri ní, idínɨ́ íꞌbí ꞌbɨ ené éyị́ bɨ gɨ yáká gɨrí ní zɨ́ne. Sɨmɨ bɨ ꞌyị bɨ kasanɨ́ wo née nderéogụ íri ní, zɨ́ ꞌyị ga bɨ yáká íri ní ị́nyịyé ócó wo zɨ́ye ógólúgu wo kɨ́ gbékpị́ sị́lị́ne. ");
INSERT INTO bdh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Zɨ́a kása ngíti ꞌyị ꞌbɨ moko zɨ́ye méngị wo kpá kenée óto dokuwu roa zɨ́ye ógólúgu wo kɨ́ gbékpị́ sị́lị́ne. ");
INSERT INTO bdh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Zɨ́a kpá kása ngíti ꞌyị, zɨ́ye kpá ócó wo óto uṇgú roa zɨ́ye ị́trị́ ógụ wo gɨ sɨmɨ gara sága. ");
INSERT INTO bdh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mị́ngị́ yáká ya, ‘Mááyí nda méngị ba ꞌdi? Togụ́ kenée yá, mááyí nda kása za cụ́ mbigí owụ́ ꞌbɨ amá bɨ kɨ́ ꞌbúne domá kɨ́ngaya ní, éyị́ née kenée nɨyí óto úndrua.’ ");
INSERT INTO bdh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Sɨmɨ bɨ ꞌyị ga gére lurúnɨ́ nda owụ́ ꞌbɨ mị́ngị́ yáká ní, zɨ́ye yéme ledre dongaráye kɨ́dí, ‘Wotị́a nɨ bɨ ógụ gɨrí née, nɨ ídí karanée ne mị́ngị́ yáká ba. Idízé úfu wo ꞌdáꞌba gɨ ro zɨ́ yáká ba nda ídíne káa do ꞌbɨ ezé.’ ");
INSERT INTO bdh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Zɨ́ye ị́nyịyé ꞌdíꞌbi wo lála ógụa gɨ yáká sága zɨ́ye úfu wo. “Bɨ née ní ní, mị́ngị́ yáká née nɨ nda méngị kɨ́ye goó ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Máúku zɨ́se maꞌdíi, oꞌdo née nɨ ꞌdíꞌbi ꞌyị ga gére née úfu yée mbá, zɨ́a íꞌbí yáká née zɨ́ ngíti géyị ꞌyị e nda ndị́sịyé méngị moko sɨmɨ a ye.” Sɨmɨ bɨ ngíti géyị ꞌyị e uwúnɨ́ ledre née kenée ní, zɨ́ye úku ledre kɨ́dí, “Toso ledre káa zɨ́ wo née nda méngị roné wá.” ");
INSERT INTO bdh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Zɨ́ Yésụ lúrú yée gbóó, zɨ́a úku ledre zɨ́ye kɨ́dí, “Úkusé go mbị́, sara ledre bɨ mɨéké kúrú Lomo uku kɨ́dí, “ ‘Tutú bɨ ꞌyị óꞌbó ꞌdị́cị́ e asinɨ́ gɨ roa ní, ogụ nda yị́ ené go tutú bɨ kɨ́ ledrené owóowó ní?’ ");
INSERT INTO bdh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ꞌYị bɨ nɨ útú do tutú née ní, nɨ útú ꞌdéwe roné. Wo bɨ tutú née nɨ útú doa ní, nɨ kányá a geré mɨkányá.” ");
INSERT INTO bdh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Geré zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kpá kɨ́ ꞌyị ꞌdódo lorụ e ní, yéme royé gɨ ro ꞌdíꞌbi Yésụ gɨ zɨ́a owonɨ́ go kɨ́dí uku muruwayi née gɨ royé. Utúasánɨ́ kóo ꞌdíꞌbi wo sɨmɨ sịndị́ kadra née wá gɨ zɨ́ ngịrị. Owonɨ́ bú kɨ́dí ꞌyị e nɨyí zíngi royé gɨ zɨ́a ꞌyị e ilinɨ́ yị́ eyé ledre ꞌbɨ Yésụ maꞌdáa. ");
INSERT INTO bdh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nda gɨ ore zɨ́ ꞌyị ga bɨ ilinɨ́ ꞌdíꞌbi wo ní, ndị́sịyé sémbe wo. Zɨ́ye kása mbeze eyé e ndị́sị sémbe wo gɨ ro togụ́ uku ledre go bɨsinyíne kɨ́ ꞌbɨ eyé yá, zɨ́ye ꞌdíꞌbi wo íꞌbí a zɨ́ akúma ꞌbɨ Róma. ");
INSERT INTO bdh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Zɨ́ ngúru ꞌyị gɨ dongará mbeze ga gére née ndúꞌyú Yésụ kɨ́dí, “Mongụ́ ꞌyị, owozé go kɨ́dí ledre ga bɨ ndị́sị úku yée kɨ́ ꞌdódo yée ní, nɨyí yị́ eyé mbá maꞌdíi. Ndá ꞌbɨ eyị́ ꞌyị ífi sɨmɨ ꞌyị e wá. Ndị́sị ꞌdódo zɨ́ ꞌyị e dụụ́ maꞌdíi ledre bɨ gɨ zɨ́ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sómụ́ ledre eyị́ nɨ káa be ꞌdi, idízé íꞌbí ụsórụ zɨ́ Káyísara ngére ꞌbɨ Róma togụ́ ndazé íꞌbí a wa?” ");
INSERT INTO bdh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yésụ owo sómụ́ ledre eyé née bú, zɨ́a úku ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ambí nɨ kɨ́ késị́ zɨ́ne ore ne. Bɨ sɨmɨ késị́ máa ba lị́lị ambi?” ");
INSERT INTO bdh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Zɨ́ye úkulúgu ledre zɨ́a kɨ́dí, “Née lị́lị Káyísara.” Yésụ ya zɨ́ye ní, togụ́ kenée yá, “Éyị́ bɨ ꞌbɨ Káyísara ní ídísé íꞌbí a zɨ́a, wo bɨ ꞌbɨ Lomo ní, ídísé íꞌbí a zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gɨ zɨ́ tụ́ꞌdụ́ ꞌyị ga bɨ ore née, bi ꞌdíꞌbi Yésụ ndaá kóo wá káa bɨ ꞌyị ga gére née nɨyí zíngi ke. Odụ a zɨ́ye ndáꞌba ndị́sịyé sií, tarayé ịdrị́ go mbá mɨị́drị́ gɨ zɨ́ ledre bɨ Yésụ uku ní. ");
INSERT INTO bdh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nda gɨ ore zɨ́ ngíti géyị Yụ́da ga bɨ ndịsịnɨ́ ndólo yée Sadụkáyo ení, ṇguṇgunɨ́ eyé bɨ kɨ́dí ꞌyị e urúnɨ́ gɨ sɨmɨ umbu bú ní wá. Zɨ́ye ị́nyịyé ndéréye ndúꞌyú Yésụ kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mongụ́ ꞌyị, Mụ́sa eké sɨmɨ lorụ kɨ́dí togụ́ ꞌyị ꞌdiꞌbi kára ndikinɨ́ owụ́ kéne wá, zɨ́ oꞌdo máa née úyuné yá, lúndua idí ꞌdíꞌbi kára umbu née. Gɨ ro zɨ́a ndíki owụ́ zɨ́ lúnduné bɨ uyu née. ");
INSERT INTO bdh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oꞌdo née ndikinɨ́ kóo yée ịnyị doa gbre (7). Mɨzefịyé ꞌdiꞌbi kára zɨ́a úyuné ótoómo kára máa née. ");
INSERT INTO bdh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Zɨ́ gbreyé kpá ꞌdíꞌbi wo zɨ́a kpá úyuné. ");
INSERT INTO bdh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sɨmɨ bɨ otayé (3) ꞌdiꞌbi kára máa née ní ní, zɨ́a kpá úyu ené ótoómo kára née owụ́ nda kpá wá. ");
INSERT INTO bdh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Odụ a nda zɨ́ kára máa née úyuné ne. ");
INSERT INTO bdh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Togụ́ maꞌdíi ꞌyị e nɨyí tɨ́ úru gɨ sɨmɨ umbu, kɨ́ꞌdí bɨ karanée urúnɨ́ go ní, kára máa née nɨ nda ídí go meꞌbe ambi, bɨ yaꞌdá ga bɨ ịnyị doa gbre (7) née kára nɨ kóo go meꞌbeyé mbá ní?” ");
INSERT INTO bdh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ledre ꞌbɨ ófụ́ kára kɨ́ ledre ꞌbɨ ꞌdíꞌbi oꞌdo nɨ lá dụụ́ zɨ́ ꞌyị e do sogo káṇgá ona. ");
INSERT INTO bdh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ꞌYị máa yée ga bɨ uyunɨ́ gɨ do sogo káṇgá gɨ ona go nɨyí nda go ꞌyị ga bɨ ꞌbɨ Lomo ní togụ́ karanée Lomo uru yée go yá, éyị́ ndaá lolụ zɨ́ye kɨ́dí ꞌdíꞌbi roꞌyị káa do kára kɨ́ oꞌdo ní wá. ");
INSERT INTO bdh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Utúasánɨ́ lolụ kpá úyu wá gɨ zɨ́a nɨyí nda yị́ eyé go káa zɨ́ maláyika e ní. Nɨyí go owụ́ ga bɨ ꞌbɨ Lomo ní gɨ zɨ́a Lomo uru yée go gɨ sɨmɨ umbu. ");
INSERT INTO bdh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gɨ ro úrú gɨ sɨmɨ umbu, Mụ́sa uku kóo ledre goó gɨ roa sɨmɨ bɨ kóo lurú phoꞌdụ kɨ́ ndící komo kágá ní kɨ́dí maꞌdíi, ꞌyị e nɨyí úrú gɨ sɨmɨ umbu. Ndịsị ndólo Ngére Lomo kɨ́dí, ‘Mááyí Lomo bɨ ndịsị lúrú kacɨ́ Abarayáma, kɨ́ Isáka nda kɨ́ Yakóbo e ní.’ ");
INSERT INTO bdh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lomo bɨ yaꞌdá ga gére ndịsịnɨ́ kóo íni ini zɨ́a née ndaá ꞌbɨ ené Lomo ꞌbɨ ꞌyị ga bɨ uyunɨ́ go mɨúyu ní wá, yị́ ené Lomo ꞌbɨ ꞌyị ga bɨ nɨyí trịdrị ní.” ");
INSERT INTO bdh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Zɨ́ ngíti géyị ꞌyị ꞌdódo lorụ e úku ledre zɨ́ Yésụ kɨ́dí, “Ledre bɨ úkulúgu née nɨ maꞌdíi.” ");
INSERT INTO bdh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gɨ do kacɨ́ ledre née, ꞌyị bɨ nɨ útúásá ndúꞌyú Yésụ ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zɨ́ Yésụ ndúꞌyú Yụ́da ga gére née kɨ́dí, “Éyị́ bɨ ngíti géyị ꞌyị e ndịsịnɨ́ úku ledre gɨ zɨ́a kɨ́dí, Kɨ́résịto nɨ lá gbóo bulúndu ngére Dawídi gɨ zɨ́a ní ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawídi maꞌdáa uku kóo go kpá cụ́ kɨ́ tarané sɨmɨ Keꞌbị ꞌbɨ Dawídi e kɨ́dí, “ ‘Ngére Lomo uku kóo ledre zɨ́ Ngére ꞌyị yómo ꞌyị e kɨ́dí, “Ndị́sị do sị́lị́ma ꞌbɨ anú ona ");
INSERT INTO bdh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gị sɨmɨ sịndị́ kadra bɨ mááyí óto ezeokóyị mbá sị́ sịndị́yị ní.” ’ ");
INSERT INTO bdh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sara togụ́ bɨ Dawídi ndolo nda kóo Kɨ́résịto go Ngére ené ní, Kɨ́résịto maꞌdáa nɨ nda ídí owụ́ ꞌbɨ ené lárá káa be ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sɨmɨ bɨ ꞌyị e nɨyí ndị́sị úwú ledre ga bɨ Yésụ nɨ ndị́sị úku yée ba ní, zɨ́a ị́nyịné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Komosé idí ídí rosé gɨ zɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌdódo lorụ ní. Ndịsịnɨ́ ésị mɨngburoko ngbángbá bongó e royé ndị́sị kɨ́ gámáye kɨ́e gɨ dongará ꞌyị e gɨ ro zɨ́ ꞌyị e lúrú yée kɨ́dí yée nɨyí mɨngburoko ꞌyị e. Zɨ́ye ndị́sị ndị́sịyé do mɨngburoko bi ndị́sị e ꞌdáꞌdá sɨmɨ ꞌDị́cị́ Kótrụro e, nda kɨ́ mɨngburoko bi ndị́sị ga bɨ do bi ayímbi ní. ");
INSERT INTO bdh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Zɨ́ye ndị́sịyé kpá lóndo kará umbu e, zɨ́ kará umbu ga gére née ndị́sị íꞌbí éyị́ e zɨ́ye. Zɨ́ye ndị́sị lóndo royé ndị́sị íni ngbángbá ini gɨ ro zɨ́ ꞌyị e lúrú yée káa do mbigí ꞌyị ga bɨ ꞌbɨ Lomo ní. Ábuwá Lomo nɨ karanée ꞌdóꞌdo yée bɨsinyíne kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nda go sɨmɨ sịndị́ kadra ꞌbɨ íꞌbí tákpásị́lị́, zɨ́ Yésụ ndị́sịné lúrú ꞌyị ga bɨ kɨ́ tụ́ꞌdụ́ éyị́ e zɨ́ye ní kɨ́ ndị́sị ndéré íꞌbí ꞌbɨ eyé tákpásị́lị́ eyé sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo. ");
INSERT INTO bdh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Zɨ́a kpá lúrú ngíti kára bɨ nɨ kára umbu ní kɨ́ ndéré íꞌbí ꞌbɨ ené odụ owụ́ késị́ bɨ zɨ́ne ní ꞌdé káa do tákpásị́lị́ ne. ");
INSERT INTO bdh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zɨ́ Yésụ ị́nyịné úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Máúku zɨ́se maꞌdíi, kára umbu née iꞌbí késị́ go káa do tákpásị́lị́ rómo do ꞌbɨ ngíti géyị ꞌyị e kɨ́e mbá. ");
INSERT INTO bdh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ꞌYị ga bɨ kɨ́ tụ́ꞌdụ́ késị́ zɨ́ye ní, ꞌdiꞌbinɨ́ lá owụ́ a bɨ cúkuꞌdée ní íꞌbí a zɨ́ Lomo. Kára née ꞌdiꞌbi tɨ́ lá odụ owụ́ késị́ bɨ zɨ́ne ní mbá íꞌbí a zɨ́ Lomo.” ");
INSERT INTO bdh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Zɨ́ ngíti géyị ꞌyị lódụ́ kacɨ́ Yésụ ndị́sị ódroyé gɨ ro ꞌDị́cị́ ꞌbɨ Lomo bɨ oꞌbónɨ́ bɨlámáne kpá kɨ́ bɨlámá tutú e ní. Zɨ́ye kpá ndị́sị ódroyé gɨ ro bɨlámá éyị́ ga bɨ ꞌyị e iꞌbínɨ́ yée zɨ́ Lomo ní. Zɨ́ Yésụ ị́nyịné úkulúgu ledre zɨ́ye kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Máúku zɨ́se maꞌdíi, tutú ga bɨ ásé ndị́sị úku ledreyé née, sịndị́ kadra nɨ ógụ do ndụ́rụónzó yée za mbá bi, wo bɨ kị́éꞌdo káa yaá nɨ ídíáká do ezené ịtrị́onzónɨ́ bi wá ní ndaá.” ");
INSERT INTO bdh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gɨ zɨ́ ledre bɨ Yésụ uku zɨ́ye kenée ní, zɨ́ye ị́nyịyé ndúꞌyú lúgu wo kɨ́dí mongụ́ ꞌyị, “Ledre máa née nɨ méngị roné née kɨ́ be ꞌdi? Éyị́ bɨ nɨ ꞌdódo a zɨ́ze kɨ́dí ledre ayí go méngị roné kenée ní ní ꞌdi?” ");
INSERT INTO bdh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Mɨzefị éyị́ bɨ mááyí úku a zɨ́se ní nɨ komosé idí ídí rosé. Ndásé ótoómo ꞌyị e zɨ́ye lóndo sée kɨ́dí yée nɨyí go máa Kɨ́résịto ní wá. Nɨyí kpá úku ledre kɨ́dí ba go sịndị́ kadra bɨ zɨ́ Lomo ídíne ngére do ꞌyị e sɨmɨ a ní. Ndásé ṇgúṇgu ledre née wá. ");
INSERT INTO bdh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nda kpá lá dụụ́ wo née wá, togụ́ ásé go ndị́sị úwú ledre okó kịꞌdị kịꞌdị kịꞌdị, kɨ́dí okó ayí go útú ꞌdáa togụ́ mbú ayí útú ona yá, ndásé éré ngịrị wá, née ndaá ꞌbɨ ené aka sịndị́ kadra bɨ zɨ́ do sogo káṇgá ba ụ́kụ́ne sɨmɨ a ní wá. Éyị́ ga gére née nɨyí aka méngị royé kenée mbá kí.” ");
INSERT INTO bdh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Zɨ́ Yésụ kpá úku ngíti ledre zɨ́ye kɨ́dí, “Kúfú ngíti géyị ꞌyị e nɨyí ị́nyị ndéré útú kɨ́ okó do ngíti kúfú. Mongụ́ ngére ꞌbɨ ngíti káṇgá nɨ ị́nyị ndéré útúne kɨ́ okó do ezené ꞌbɨ ngíti káṇgá. ");
INSERT INTO bdh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Zɨ́ kịꞌdị káṇgá kị́zị bi kɨ́ rokoꞌbụné kɨ́ngaya, zɨ́ mongụ́ ꞌbú útúne sɨmɨ ngíti géyị káṇgá e zɨ́ ꞌyị e ndị́sị kɨ́ úyuyé, zɨ́ mɨngburoko lárá ledre ga bɨ mengịnɨ́ aka royé ꞌdáꞌdá a wá ní ndị́sị méngị royé komo ere, zɨ́ ꞌyị e lúrú a kɨ́ komoyé zɨ́ ngịrị ndị́sịné méngị yée kɨ́ngaya gɨ zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“ꞌDáꞌdá zɨ́ ledre ga gére née kɨ́ méngị royé, ngíti géyị ꞌyị e nɨyí karanée ꞌdíꞌbi sée zɨ́ye méngị láráse kɨ́ngaya, zɨ́ye ógụ kɨ́se sɨmɨ ꞌDị́cị́ Kótrụro e kóꞌdụ́ mɨngburoko ngére eyé e kpá kɨ́ ngíti géyị mɨngburoko ꞌyị eyé ꞌbɨ Yụ́da e, do óto ngíti géyị lafúse sɨmɨ sị́gịnị gɨ zɨ́a bɨ ṇgúṇgusé ledre amá ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Togụ́ Yụ́da ga gére née ꞌdiꞌbiogụnɨ́ sée go dongaráye kenée yá, née go sịndị́ kadra gɨ ro zɨ́se úku bɨlámá ledre amá zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sɨmɨ bɨ ꞌdiꞌbinɨ́ sée go ní, ndásé sómụ́ ledre gɨ ro ledre bɨ ásé úku a gɨ ro zɨ́se ómosé ní wá. ");
INSERT INTO bdh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mááyí íꞌbí komokenzị zɨ́se, ledre bɨ ásé úku a ní, ꞌyị bɨ kị́éꞌdo káa gɨ dongará ezeokóse ga gére née nɨ kálá ní ndaá. ");
INSERT INTO bdh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngíti géyị bɨsinyí ledre e kpị́ gɨ zɨ́ yée ga gére née nɨyí kpá bo nɨyí méngị sée. ꞌYị ndíki sée kɨ́ lúndusé e kɨ́ sụmụsé e kɨ́ eze lámáse e nɨyí íꞌbí ngbángá ngíti géyị ꞌyị e gɨ dongaráse zɨ́ Yụ́da ga gére née úfu yée. ");
INSERT INTO bdh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tụ́ꞌdụ́ ꞌyị e nɨyí karanée sógó sée gɨ zɨ́a bɨ ṇgúṇgusé ledremá ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Abú ledre e nɨyí karanée méngị sée kenée ndotó, ꞌyị óto sị́lị́ne ndaá ro trịdrịsé wá. ");
INSERT INTO bdh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Togụ́ ledre máa ga gére née nɨyí go méngị sée yá, ídísé tóro ngbúó, ásé karanée ndíki trịdrị bɨ za fí ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Togụ́ lúrúsé mongụ́ gara bɨ Yerụsaléma, ezeokóga toro ꞌdikínɨ́ go gbaá kɨ́ okó, ídísé ówo a kɨ́dí née go bizóró. ");
INSERT INTO bdh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sée ga bɨ sịndị́ kadra ꞌbɨ ledre máa née, nɨ ndíki sée ásé sɨmɨ Yụdáya ní, ídísé ngásá ꞌbɨ esé geré komo landa. Lafúse ga bɨ ledre máa née nɨ ndíki yée sɨmɨ Yerụsaléma ore ní, ndanɨ́ ndị́sị wá idínɨ́ geré ólụ́ógụ ꞌdáꞌba. Yée ga bɨ ngárá ndanɨ́ gáa sɨmɨ gara ore wá ní, ndanɨ́ lolụ ndáꞌbalúgu royé íri gɨ ro ꞌdóꞌdụ́ éyị́ eyé e wá. ");
INSERT INTO bdh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Née go sịndị́ kadra zɨ́ éyị́ ga bɨ kóo ekénɨ́ ledreyé sɨmɨ mɨéké kúrú Lomo ní méngị royé tɨ́ káa zɨ́ bɨ ekénɨ́ ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sịndị́ kadra née nɨ ídí bɨsinyíne zɨ́ kará ga bɨ kɨ́ sɨmɨyé kpá zɨ́ yée ga bɨ kɨ́ owụ́ e do sị́lị́ye ní. Sɨmɨ Yụdáya ore mbá, nɨyí ꞌdóꞌdo ꞌyị e zɨ́ye ídíye mɨꞌdóꞌdóye kɨ́ngaya. ");
INSERT INTO bdh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yụ́da e, ꞌyị ga bɨ ꞌbɨ Yerụsaléma née, ezeokóye nɨyí lágáónzó ngíti géyị kɨ́ mɨngburoko maku e, do ꞌdíꞌbi ókpó ngíti géyị sɨmɨ káṇgá bɨ kpị́ ndaá ꞌbɨ eyé ꞌbɨ Yụ́da e wá ní. Yerụsaléma, mongụ́ gara née nɨ ídí sị́ sịndị́ ezeokó née, ꞌbúó togụ́ sịndị́ kadra utúasá go zɨ́ Lomo íꞌbí bikịdrị́ sɨmɨ a. ");
INSERT INTO bdh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lárá ledre nɨyí méngị roné komo ere. Toso kadra kɨ́ toso éfé kpá kɨ́ toso kele e nɨyí óyólóꞌbó royé mbá kpị́. Nda gɨ ore, zɨ́ mɨngburoko ngbuṛu e ndị́sị kádayé kɨ́ kúkúye kɨ́ rokoꞌbụyé. Zɨ́ mɨmbéꞌde ꞌyịmaꞌdí e do sogo káṇgá mbá ndị́sị léꞌbéne kpị́kpị kpị́kpị kpị́kpị gɨ zɨ́ ngịrị ledre née. ");
INSERT INTO bdh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Zɨ́ cóngó ro ꞌyị e ụ́kụ́ne mɨụ́kụ́ gɨ zɨ́ ngịrị, gɨ zɨ́a owonɨ́ go kɨ́dí Lomo nɨ go ndéré kị́zị ere zɨ́ éyị́ ga bɨ gɨrí ní útúógụyé do ꞌyịmaꞌdí e. ");
INSERT INTO bdh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nda gɨ ore zɨ́ye lúrúndíki Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ ógụ gɨ komo ere kpụrụ́ gɨ sɨmɨ bụṛụngụ́ kɨ́ cóngó roné kpá kɨ́ mongụ́ rokoꞌbụné. ");
INSERT INTO bdh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Éyị́ ga bɨ máúku ledreyé née, sɨmɨ bɨ nɨyí go méngị royé ní, ídísé tóro ngbúó gɨ zɨ́a sịndị́ kadra bɨ zɨ́ Lomo ꞌdíꞌbióyó sée gɨ sɨmɨ ꞌdoꞌdó ní nɨ go gbóo.” ");
INSERT INTO bdh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zɨ́ Yésụ úku muruwayi zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Lúrúsé aka bongó née kpá kɨ́ ngíti géyị kágá ga gére. ");
INSERT INTO bdh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Togụ́ lúrúsé mbufu nɨyí go ndị́sị ụ́ꞌbụ yá, ídísé ówo a kɨ́dí iní nɨ go gbóo gɨ ro ndáꞌbaógụ éꞌdị. ");
INSERT INTO bdh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ledre née nɨ kpá kenée gɨ ro Lomo. Éyị́ ga bɨ máúku ledreyé ní mbá togụ́ lúrúsé yée nɨyí go méngị royé yá, ídísé ówo a kɨ́dí sịndị́ kadra bɨ zɨ́ ꞌyị e ídíye ꞌyị ga bɨ ꞌbɨ ꞌbe ꞌbɨ Lomo ní nɨ go gbóo.” ");
INSERT INTO bdh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Zɨ́ Yésụ kpá úku ngíti ledre kɨ́dí, “Maꞌdíi, ledre ga bɨ máúku yée née mbá, ndaá ꞌbɨ ené bɨ ya kɨ́dí nɨyí méngị royé sɨmɨ bɨ ꞌyị ga bɨ nɨyí trịdrị ba uyuonzónɨ́ royé go ní wá, nɨyí lúrú a cụ́ kɨ́ komoyé. ");
INSERT INTO bdh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Abú do sogo káṇgá kɨ́ ere nɨyí ụ́kụ́ yá, ledre amá ụkụ́ enée wá. ");
INSERT INTO bdh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Káa zɨ́ bɨ goó kenée ní, ndásé ndị́sị lị́gị rosé dụụ́ sómụ́ ledre éyị́ mɨánu kɨ́ éyị́ mɨéwé e kpá kɨ́ ledre ꞌdoꞌdó ga bɨ nɨyí ndị́sị kɨ́ ndíki sée ní wá, káa bɨ sịndị́ kadra ꞌbɨ ledre ga bɨ máúku yée zɨ́se née nɨ lị́yị sée mɨlị́yị ke. ");
INSERT INTO bdh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ledre ga bɨ máúku yée née nɨ lị́yị ꞌyị e mɨlị́yị káa zɨ́ éyị́ ndụrụ ne rụ doyé ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gɨ zɨ́ kéyị née, ídísé ídí fú lá nzíyisé kacɨ́ kadra mbá. Ídísé ndị́sị íni ini zɨ́ Lomo idí íꞌbí rokoꞌbụ zɨ́se, gɨ ro zɨ́se ndị́sị tórosé ngbúó gị sɨmɨ sịndị́ kadra bɨ Owụ́ ꞌbɨ ꞌYịmaꞌdí nɨ ndáꞌbaógụ ndíki sée sɨmɨ a ní.” ");
INSERT INTO bdh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yésụ ndịsị kóo ꞌdódo ledre zɨ́ ꞌyị e sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo sɨmɨ Yerụsaléma ore kacɨ́ kadra e za mbá. Togụ́ nda go kɨ́ ndụlụ yá, zɨ́ye ólụ́ógụyé kɨ́ ꞌyị lódụ́ kacɨ́ne e gɨ sɨmɨ mongụ́ gara gɨ ore ndéré ꞌdúꞌduyé sɨmɨ owụ́ gara do landa bɨ ndịsịnɨ́ ndólo a Landa Olíva ní. ");
INSERT INTO bdh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Togụ́ bi ará go kɨ́ phịyị́ yá, zɨ́ tụ́ꞌdụ́ ꞌyị e ndị́sị ógụyé ndị́sị úwú ledre bɨ nɨ ndị́sị ꞌdódo a zɨ́ye sɨmɨ ꞌDị́cị́ ꞌbɨ Lomo sɨmɨ Yerụsaléma ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Née ní, sịndị́ kadra ꞌbɨ Ayímbi bɨ ndịsịnɨ́ ndólo a ꞌDeꞌdị́ ndaá ndịsịnɨ́ kpá ndólo a Umbuokpó ní nɨ go gbóo. ");
INSERT INTO bdh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sɨmɨ sịndị́ kadra máa bɨ kóo née ní, zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e ní, kɨ́ ꞌyị ga bɨ ndịsịnɨ́ ꞌdódo lorụ ní, nɨyí go ndị́sị gámásóꞌdo Yésụ gɨ ro úfu wo wayí gɨ zɨ́ ngịrị tụ́ꞌdụ́ ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ábuwá Satána olụ́ go sɨmɨ ngúru ꞌyịmɨkása ꞌbɨ Yésụ kɨ́ ịrịné Yụ́da. Nɨ gɨ sɨmɨ owụ́ gara kɨ́ ịrịné Keriyóta. Ndị́sịnɨ́ nda ndólo wo Yụ́da ꞌyị ꞌbɨ Keriyóta. ");
INSERT INTO bdh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zɨ́ Yụ́da maꞌdáa lóloné ndéréne zɨ́ manda ga bɨ ꞌbɨ ꞌyị ꞌdáná éyị́ e kpá kɨ́ ngíti géyị mɨngburoko ꞌyị ga bɨ ndịsịnɨ́ lúrú bi kacɨ́ ꞌDị́cị́ ꞌbɨ Lomo ní, gámásóꞌdo mɨsiꞌdi bɨ née nɨ íꞌbíógụ Yésụ do a gɨ ro zɨ́ye ꞌdíꞌbi wo ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Zɨ́ yaꞌdá ga gére née ídíye kɨ́ rokinyi, zɨ́ye ṇgúṇgu ledre íꞌbí késị́ zɨ́ Yụ́da gɨ ro zɨ́a íꞌbíógụ Yésụ zɨ́ye. ");
INSERT INTO bdh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sɨmɨ bɨ Yụ́da ꞌdiꞌbi késị́ ní, zɨ́a ídíne kɨ́ rokinyi, zɨ́a ndị́sịné gámásóꞌdo mɨsiꞌdi bɨ née nɨ íꞌbíógụ Yésụ zɨ́ye doa wayí tụ́ꞌdụ́ ꞌyị e utúasánɨ́ ówo a wá ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Zɨ́ sị́lị́ ꞌbɨ Ayímbi bɨ ndịsịnɨ́ ndólo a ꞌDeꞌdị́ ndaá ní, née mɨzefị sị́lị́ bɨ ndịsịnɨ́ óṇgoónzó phɨṛangá kábịṛị́kị e kɨ́ sómụ́ndíki ledre Umbuokpó. ");
INSERT INTO bdh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zɨ́ Yésụ ị́nyịné kása ꞌyị lódụ́ kacɨ́ne e gbre, Pétero kɨ́ Yiwáni, kɨ́dí “Ndérésé mu yémeómo bi zɨ́ze nzíyiné gɨ ro zɨ́ze ndéréze ánu Ayímbi Umbuokpó doa.” ");
INSERT INTO bdh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Zɨ́ye ndúꞌyú lúgu Yésụ kɨ́dí, “Íli idízé ndéré yémeómo bi máa née ꞌda?” ");
INSERT INTO bdh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ndérésé mu sɨmɨ gara íri, ásé ndíki ngíti oꞌdo kɨ́ ndáꞌbaógụ gɨ ngbuṛu kɨ́ ndoko iní oꞌbo do goné, ídísé lódụ́ógụ wo gị ꞌbe. ");
INSERT INTO bdh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Zɨ́se ndúꞌyú mị́ngị́ ꞌbe kɨ́dí, Mongụ́ ꞌyị ezé ya kɨ́dí, ꞌdị́cị́ bɨ yémeómo gɨ ro zɨ́ne ógụné kɨ́ ꞌyị lódụ́ kacɨ́ne e ánu Ayímbi Umbuokpó sɨmɨ a ní nɨ wo be ꞌdi? ");
INSERT INTO bdh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yésụ ya kɨ́dí, nɨ ꞌdódo ꞌdị́cị́ zɨ́se wo bɨ oꞌbónɨ́ do ezené ꞌdága ní. Yemenɨ́ bi go sɨmɨa íri mbá nzíyiné, ídísé ótoyéme éyị́ mɨánu maꞌdáa sɨmɨ a íri.” ");
INSERT INTO bdh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zɨ́ ꞌyị lódụ́ kacɨ́ga ga gére née ndéréye ndíki éyị́ e, tɨ́ káa zɨ́ bɨ Yésụ úku zɨ́ye ní. Zɨ́ye yéme Umbuokpó ore. ");
INSERT INTO bdh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sɨmɨ bɨ go sịndị́ kadra ꞌbɨ éyị́ mɨánu ní, zɨ́ Yésụ ndéréye kɨ́ ꞌyịmɨkása ené ga bɨ sokó doa gbre (12) née ndị́sịyé gbaá ánu éyị́. ");
INSERT INTO bdh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Zɨ́a ị́nyịné úku ledre zɨ́ ꞌyịmɨkása ené ga gére née kɨ́dí, “Mándị́sị kú óto komomá gɨ ro sịndị́ kadra ꞌbɨ Ayímbi Umbuokpó ba gɨ ro zɨ́ze ánu a ndro kése káa ꞌdáꞌdá zɨ́ sịndị́ kadra amá ꞌbɨ ꞌdoꞌdó ógụné. ");
INSERT INTO bdh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Maꞌdíi, utúasázé aka lolụ ánu kótrụ sị́lị́ze kése kadra ayímbi káa zɨ́ wo ba ꞌdiya wá, ꞌbúó togụ́ ini ledre gɨ sɨmɨ ayímbi káa zɨ́ ba ꞌyị e owoyemenɨ́ go sɨmɨ bɨ nɨyí go ꞌyị ga bɨ ꞌbɨ ꞌbe Lomo ní.” ");
INSERT INTO bdh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gɨ do kacɨ́ née ní, zɨ́a ꞌdíꞌbi kóꞌdo leꞌyị́, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo gɨ roa, zɨ́a úku ledre kɨ́dí, “Sée mɨkékeṛị́a mbá ídísé éwé leꞌyị́ ba. ");
INSERT INTO bdh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Utúasázé éwé ándá leꞌyị́ kóṛó kése káa zɨ́ wo ba aka lolụ ꞌdiya wá, ꞌbúó togụ́ sịndị́ kadra bɨ Lomo nɨ ógụ ídí káa do Ngére do ꞌyị e sɨmɨ a ní ogụ go.” ");
INSERT INTO bdh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gɨ do kacɨ́ née, zɨ́a ꞌdíꞌbi ambata, zɨ́a íꞌbí mbófo éyị́ zɨ́ Lomo, zɨ́a ꞌdéwe sɨmɨ a, zɨ́a íꞌbí a zɨ́ ꞌyịmɨkása ené e, zɨ́a úku ledre kɨ́dí, “Ba kụṛụꞌbụmá bɨ máíꞌbí gɨ rosé ní, ídísé ánu a kɨ́ sómụ́ndíki ledremá.” ");
INSERT INTO bdh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kpá kenée gɨ do kacɨ́ éyị́ mɨánu, zɨ́a ꞌdíꞌbi kóꞌdo, zɨ́a úku ledre kɨ́dí, “Bɨ sɨmɨ kóꞌdo ba sámamá bɨ nɨ ndéꞌyị́ bi gɨ rosé gɨ ro yéme ledre dongaráse kɨ́ Lomo ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ꞌYị máa wo bɨ nɨ íꞌbí ngbángáma do úfu máa ní, nɨ dongaráze ona ndịsịzé ánu kótrụ sị́lị́ze ba tɨ́ kéye. ");
INSERT INTO bdh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maꞌdíi, Máa Owụ́ ꞌbɨ ꞌYịmaꞌdí, nɨ úyu, gɨ zɨ́a Lomo yeme ne kenée. Tɨ́ lá nɨ ídí mongụ́ nduwú zɨ́ ꞌyị bɨ nɨ tóro íꞌbí ngbángá a ní gɨ zɨ́a Lomo nɨ ꞌdódo wo kɨ́ngaya.” ");
INSERT INTO bdh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sɨmɨ bɨ ꞌyịmɨkása ga gére née uwúnɨ́ ledre bɨ Yésụ uku kenée ní, zɨ́ye tónóye úku mɨngụ́ngụ́rụ́ ledre dongaráye kɨ́dí, “Ambí ili méngị bɨsinyí ledre née kenée ne?” ");
INSERT INTO bdh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zɨ́ ꞌyịmɨkása ga gére née kpá ndị́sịyé úkulóꞌbó ledre dongaráye kɨ́dí, “Ambí gɨ dongaráze ba nɨ ídíne manda ꞌdáꞌdá zɨ́ lafúne e?” ");
INSERT INTO bdh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zɨ́ Yésụ úkulúgu ledre zɨ́ye kɨ́dí, “Ngére ga bɨ ꞌbɨ do sogo káṇgá ba ndịsịnɨ́ óto royé zɨ́ ꞌyị eyé e kɨ́dí yée nɨyí mɨngburoko ꞌyị e. Zɨ́ye óto royé kɨ́dí yée nɨyí bɨlámá ꞌyị sáká ꞌyị e. ");
INSERT INTO bdh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Máúku zɨ́se, ndásé ídí káa zɨ́ye née wá. Togụ́ ꞌyị nɨ dongaráse kɨ́ ledrené owóowó yá, idí ídí káa zɨ́ ꞌyị bɨ ledrea ndaá owóowó wá ní. Wo bɨ nɨ manda ní, idí ídí káa zɨ́ ꞌyị ꞌbɨ moko ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mándúꞌyú aka sée ambí nɨ mongụ́ ꞌyị ní ne? ꞌYị máa wo bɨ ndịsị lá mɨndị́sị mengị moko wá ní togụ́ mbú wo bɨ ndịsị méngị moko ní? Tɨ́ lá mááyí dongaráse ona káa zɨ́ ꞌyị méngị moko ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mbófo éyị́ zɨ́se, sɨmɨ ꞌdoꞌdó ga bɨ ndikinɨ́ máa ní mbá, óyósé sogosé zɨ́ma wá. ");
INSERT INTO bdh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Káa zɨ́ bɨ Babá iꞌbí rokoꞌbụ zɨ́ma, zɨ́ma ídíma káa do ngére ní, mááyí kpá íꞌbí rokoꞌbụ zɨ́se, ");
INSERT INTO bdh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","gɨ ro zɨ́ze ndị́sịzé do bi kị́éꞌdo kése ꞌbe ꞌbɨ Lomo kɨ́ ánu éyị́ kpá kɨ́ ꞌdécị ngbanga ro kúfú Isɨréle e bɨ sokó doa gbre ní.” ");
INSERT INTO bdh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Zɨ́ Yésụ ị́nyịné úku ledre zɨ́ Simúna kɨ́dí, “Lúrú aka Simúna, Satána yeme roné go gɨ ro úzu yị́ị oꞌbụóꞌbụ káa zɨ́ mɨgombị mengị moko ne ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Abú kenée ndotó, máíni ini go zɨ́ Babá gɨ royị́, gɨ ro zɨ́yị tóroyị́ ngbúó sɨmɨ úzu éyị́ née útúásá útú wá. Sɨmɨ bɨ ndáꞌbaógụ go zɨ́ma ní, ídí ndịsị íꞌbí rokoꞌbụ zɨ́ lafúyị e.” ");
INSERT INTO bdh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Zɨ́a ị́nyịné úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Ngére, mááyí go nzíyimá gɨ royị́. Togụ́ sị́gịnị yá, idínɨ́ óto zée kéyị, togụ́ umbu yá, azé úyu kéyị.” ");
INSERT INTO bdh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Zɨ́ Yésụ úkulúgu ledre zɨ́ Pétero kɨ́dí, “Máúku zɨ́yị Pétero, kɨ́lóndó kɨ́ sɨmɨbi ꞌdáꞌdá zɨ́ ngono kɨ́ ụ́cụ koko, áyí ási gɨ romá kɨ́ꞌdí ota yá née owo ené máa wá.” ");
INSERT INTO bdh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gɨ do kacɨ́ ledre bɨ uku zɨ́ Pétero ní, zɨ́a nda ị́nyịné ndúꞌyú ꞌyị lódụ́ kacɨ́ne ga gére née mbá kɨ́dí, “Sɨmɨ bɨ kóo mákása sée lá kɨ́ gbékpị́ sị́lị́se ndéré kɨ́ ꞌdódo bɨlámá ledre amá zɨ́ ꞌyị e, ꞌdíꞌbisé késị́ gɨ ro ánu éyị́ kɨ́e wá, gbawá kombo, gbawá ngíti wará ní, lerị́ éyị́ mengịnɨ́ kóo sée goó?” Zɨ́ye úkulúgu ledre zɨ́ Yésụ kɨ́dí, “Lerị́ kémbị́ éyị́ mengị zée wá.” ");
INSERT INTO bdh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zɨ́a úku ngíti ledre zɨ́ye kɨ́dí, “Ba ndaá lolụ ledre máa bɨ kóo née wá, ili nda go zɨ́se ꞌdíꞌbi késị́ kɨ́ kombo esé e kpa. ꞌYị bɨ mongụ́ maku ndaá zɨ́a wá ní, idí úgúóyó ngíti bongó ené ꞌdáꞌba, zɨ́a ndéréne úgú maku zɨ́ne. ");
INSERT INTO bdh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ídísé ówo a kɨ́dí, ledre ga bɨ kóo ekéomonɨ́ gɨ romá ꞌdesị́ sɨmɨ mɨéké kúrú Lomo kɨ́dí, ‘Nɨyí karanée ꞌdóꞌdo máa káa zɨ́ ꞌyị bɨ mengị bɨsinyí ledre ní,’ sịndị́ kadra ené ogụ go.” ");
INSERT INTO bdh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ a uwúnɨ́ ledre bɨ uku née kenée ní, zɨ́ye úkulúgu ledre zɨ́a ꞌdiya kɨ́dí, “Ngére, mɨngburoko maku nɨyí bo zɨ́ze ona gbre.” Zɨ́a úkulúgu ledre zɨ́ye kɨ́dí, “Ledre máa wo née asá go kenée.” ");
INSERT INTO bdh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zɨ́ Yésụ ólụ́ógụné gɨ sɨmɨ yana gara gɨ ore káa zɨ́ bɨ lengbe ní ndéréne do Landa bɨ kɨ́ kágá ga bɨ ndịsịnɨ́ ndólo yée Olíva doné ní. Zɨ́ ꞌyị lódụ́ kacɨ́ga ndéréye lódụ́ wo íri. ");
INSERT INTO bdh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sɨmɨ bɨ nderéogụ íri ní, zɨ́a úku ledre zɨ́ ꞌyị lódụ́ kacɨ́ne ga gére née kɨ́dí, “Ídísé ndị́sị íni ini zɨ́ Lomo gɨ ro zɨ́a ndị́sịné sáká sée gɨ sɨmɨ ledre ga bɨ nɨyí kɨ́ ndị́sị ndíki sée ní.” ");
INSERT INTO bdh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gɨ do kacɨ́ ledre née ní, zɨ́a ị́nyịné gɨ cigíye ndéréne re, do útúne do ngụ́ṛụ́ sịndị́ne íni ini zɨ́ Lomo kɨ́dí, ");
INSERT INTO bdh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Babá, togụ́ nɨ útúásá kacɨ́ komoyị́ yá, ndá ótoómo máa zɨ́ma ndúwúma sɨmɨ nduwú bɨ nɨ go ógụ ba wá. Ledre maꞌdáa idí méngị roné kacɨ́ mɨyéme ledre eyị́, nda ídí kacɨ́ sómụ́ ledre amá wá.” ");
INSERT INTO bdh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Zɨ́ Lomo kásaógụ maláyika ógụ íꞌbí rokoꞌbụ zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gɨ zɨ́ mongụ́ éyị́ mɨówo, zɨ́a ndị́sịné íni ini zɨ́ Lomo cụ́ kɨ́ sɨmɨné. Zɨ́ bɨsuwu bɨ ndịsị kúkú gɨ roa trịị bi ní, óyólóꞌbó roné ídíne bɨkesị́ne káa zɨ́ sáma ní. ");
INSERT INTO bdh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Zɨ́a ị́nyịné ndáꞌbalúgu roné zɨ́ ꞌyị lódụ́ kacɨ́ne e. Nɨ ógụ íri ní, nɨyí go mbá ꞌdúꞌdu cóngó royé ụkụ́ kpá go mbá mɨụ́kụ́ gɨ zɨ́ lerị́. ");
INSERT INTO bdh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zɨ́a úku ledre zɨ́ye kɨ́dí, “Ásé yị́ esé ꞌdúꞌdu esé? Ídísé ndị́sị íni ini zɨ́ Lomo gɨ ro zɨ́a ndị́sịné sáká sée gɨ sɨmɨ ledre ga bɨ nɨyí kɨ́ ndị́sị ndíki sée ní.” ");
INSERT INTO bdh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sɨmɨ bɨ Yésụ nɨ aka ngbụ́rụ́ ndị́sị úku ledre zɨ́ ꞌyị ené ga gére ní, rụụ, zɨ́ tụ́ꞌdụ́ ngíti géyị ꞌyị e ndéꞌyị́ógụyé, Yụ́da bɨ nɨ ngúru ꞌyị lódụ́ kacɨ́ Yésụ maꞌdáa ní, ꞌdiꞌbiogụ yée ne. Zɨ́a ndéréne geré fáka Yésụ íꞌbí mandá zɨ́a. ");
INSERT INTO bdh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Zɨ́ Yésụ úku ledre zɨ́a kɨ́dí, “Yụ́da, ógụ fáka ꞌdódo Owụ́ ꞌbɨ ꞌYịmaꞌdí kɨ́ íꞌbí mandá zɨ́a ba gɨ zɨ́a bɨ íꞌbí ngbángáma go ní?” ");
INSERT INTO bdh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sɨmɨ bɨ ꞌyị lódụ́ kacɨ́ Yésụ owonɨ́ kɨ́dí bɨsinyí ledre ogụ née go ne ní, zɨ́ye úku ledre zɨ́ Yésụ kɨ́dí “Ngére, ilizé go tónó lágá yée kɨ́ mɨngburoko maku ga ba?” ");
INSERT INTO bdh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Zɨ́ ngúruyé ị́nyịné kóo gɨ ro lágá ónzó ꞌyị ꞌbɨ moko ꞌbɨ mongụ́ ꞌyị ꞌdáná éyị́ fí umbu, zɨ́ mongụ́ maku nda útúne lá gbóo ro mbílía do anú, lágá ꞌdécị a tụ. ");
INSERT INTO bdh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zɨ́ Yésụ gbúrógbóne do ꞌyị lódụ́ kacɨ́ne ga gére