﻿USE sofia;
DROP TABLE IF EXISTS sofia.bdd_vpl;
CREATE TABLE bdd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bdd_vpl WRITE;
INSERT INTO bdd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lele bewa Toꞌabihetena Yesu tubunao nugenugetadi weyahidi. Yesu tubuna hauhauna Debida, ma tubuna nugenugetana Ebalahamo. ");
INSERT INTO bdd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Weyahina bewa gide: Ebalahamoina natuna Aisake, ma Aisake natuna Yakobo, ma Yakobo natunao Yuda matasinao. ");
INSERT INTO bdd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaina natunao Pelesi ma Dela, sinadiu sanina Temali, Pelesi natuna Esiloni, ma Esiloni natuna Elama, ");
INSERT INTO bdd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ma Elama natuna Aminadaba, ma Aminadaba natuna Nasoni, ma Nasoni natuna Salimoni, ");
INSERT INTO bdd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ma Salimoni mwanena Leyabi ma natudiu Bwasa, ma Bwasa mwanena Ludi, ma Bwasa ma Ludi natudiu Obedi, ma Obedi natuna Yese. ");
INSERT INTO bdd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese natuna Debida tauna kini, ma Debidaina Ulaiya mwanena ꞌihematabaleya ma ꞌihaiya ta natudiu Solomoni. ");
INSERT INTO bdd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Lehoboama, ma Lehoboama natuna Ebaya, ma Ebaya natuna Esa, ");
INSERT INTO bdd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ma Esa natuna Yosepata, ma Yosepata natuna Yolama, ma Yolama natuna Usaya, ");
INSERT INTO bdd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya natuna Yotama, ma Yotama natuna Eyasi, ma Eyasi natuna Hesakaya. ");
INSERT INTO bdd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesakaya natuna Manasa, ma Manasa natuna Amoni, ma Amoni natuna Yosaya. ");
INSERT INTO bdd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya natunao Yekonaya matasinao, ma ꞌidi tutaina meBabiloni sinaoma ma meYudiya siꞌabiyahidiya ta sitauyediya ꞌidi tupwa Babiloni ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tutaina Babiloni ꞌoina simiyamiya. Yekonaya natuna Siyalitiyeli, ma Siyalitiyeli natuna Selubabela. ");
INSERT INTO bdd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Ebiyuda, ma Ebiyuda natuna Ilaiyakimi, ma Ilaiyakimi natuna Esoli. ");
INSERT INTO bdd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esoli natuna Sadoka, ma Sadoka natuna Ekimi, ma Ekimi natuna Eliyuda. ");
INSERT INTO bdd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda natuna Eliyesa, Eliyesa natuna Madani, ma Madani natuna Yakobo. ");
INSERT INTO bdd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo natuna Yosepa, tauna Meli mwanena, ma Meliina natuna Yesu. Yesu tauna sihesaniyeya Toꞌabihetena. ");
INSERT INTO bdd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yesu tubunaowedi sanidi ꞌadi baibaiwa potitu. Ceguma Ebalahamo ꞌoinega tahasili ma Debida ꞌoina, beno ꞌadi baibaiwa potini. Ma ꞌeguma Debida ꞌoinega tahasila ee tutaina meBabiloni meYudiya sitauyediya Babiloni ꞌoina, beno ꞌadi baibaiwa potini. Ma ꞌidi tuta Babiloni ꞌoina ꞌoinega ma Yesu ꞌina tuta ꞌoina ꞌadi baibaiwa wete potini. ");
INSERT INTO bdd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bewa gide Toꞌabihetena Yesu ꞌina liꞌu. Yesu sinana Meli silosonaneya Yosepa baꞌidana, ta ꞌabwa geya simiyaluwa ma Meli ꞌigamwa, ma ꞌina gamwaina Yaluyaluwa Tabuna ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma Yosepaina ꞌinuwagala Meli ꞌina gamwa weyahina. Tauna loheya bwebweꞌana, ta geya nuwana ma Meli ꞌigihemwadine, ma ꞌinuwatuhu ꞌabehega ꞌilogwahata gahuwe. ");
INSERT INTO bdd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma Yosepa ꞌina nuwatuhu ꞌabwa ꞌipaipaihowa, ta ꞌina tuta ꞌenowa nihiyega Yehoba ꞌina anelose ꞌaigeda ꞌihegwaeya, ꞌigwae, “Yosepa, ꞌowa Debida tubuna, sahena ꞌunuwanuwagala Meli ꞌina gamwa weyahina, beno Yaluyaluwa Tabuna ꞌoinega, tuwa ꞌeguma ꞌutoe mwaneu. ");
INSERT INTO bdd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma ꞌabwa natuna meloheyana ꞌihenatune, ma ꞌuhesaniye sanina Yesu, weyahina tauna ꞌina tomotaiyao ꞌidi pui ꞌoidiyega ꞌabwa ꞌiꞌabihetedi.” ");
INSERT INTO bdd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginauledi silatulatu weyahina mwalohene palopita ꞌaigeda ꞌina gwae ꞌihepwaila nugetediya ta Buki Tabu ꞌoina ꞌilelediya ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Gumalaulauna geya ꞌilogwali ma ꞌigamwa ma natuna meloheyana ꞌihenatune, ma sanina sida hesaniye Imanuweli.” (Ma saniina ꞌana bui Yehoba baꞌidadai.) ");
INSERT INTO bdd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma Yosepa ꞌenoꞌenowega ꞌitoholowa ta aneloseina ꞌina gwae ꞌihematamataneya, ma Meli ꞌihaiya, ");
INSERT INTO bdd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ma geya ꞌwapina ꞌiꞌiabitoho ma ꞌana siga ꞌihenatuna, ma Yosepa gwamaina ꞌihesaniyeya Yesu. ");
INSERT INTO bdd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tutaina Yesu ꞌiliꞌuwa Bedeliyema ꞌoina, Helodi tauna ꞌiloiloina Yudiya ꞌalona. Ma tutaina ꞌoina tupwadi tosanasanapuwao tupwa bomatuwega sitauyama ma meYelusalema ꞌoidiya sihesilala, ");
INSERT INTO bdd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sigwae, “Toꞌeha meYudiya ꞌidi kini hauhaunaina? Casanapuya ꞌiliꞌu pwaiya, weyahina ꞌina ꞌipwala ꞌaꞌiteya tupwa bomatuwega ꞌisaehaneya, ꞌoinega ꞌatauyama sabi ꞌetuluha ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cidi gwae bewa toloinaina Helodi ꞌihesagoheya ma ꞌiꞌateyohowa ma wete meYelusalema mabwaiyadi siꞌateyohowa gwae bewa weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma Helodi meYudiya ꞌidi topwaoli madoudi ma loina ꞌana toheꞌitao* ꞌibwau ꞌautedima ma ꞌoidiya ꞌihesilala ꞌigwaeya, “To tupwa ꞌoina Toꞌabihetenaina ꞌina ꞌebeliꞌu?” ");
INSERT INTO bdd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma sigwae, “Bedeliyema ꞌoina, beno Yudiya ꞌalona, gide palopita ꞌina hepwaila Buki Heꞌasisi ꞌalona ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bedeliyema ꞌalona ꞌigu boda Isileli ꞌidi toloina ꞌabwa ꞌilatuma, ma ꞌiꞌitayahidi. Bewa weyahina Bedeliyema ꞌasa wasawasa ma sanina madouna Yudiya ꞌasainao mabwaiyana ꞌoidiyega.’” ");
INSERT INTO bdd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Coinega Helodi tosanasanapuwedi ꞌibwau gahuwediya, ma ꞌoidiya ꞌihesilaleya tutaina ꞌipwalaina ꞌilatu hohauwa. ");
INSERT INTO bdd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cihesilala ma ꞌidi hemaisa ꞌihesagoheya ma ꞌiloinaediya, ꞌigwae, “Watauya Bedeliyema ꞌoina ma gwamaina waꞌebese bwaibwaini, ma ꞌeguma walobeya wahilama ꞌoiguwa ma wahepwaila, ma taugu wete yatauya ma yaꞌetuluha ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nage ꞌoinega silatuwa ma sitauya, ma ꞌipwalaina mwalo tupwa bomatu ꞌoina siꞌeꞌebubuya matadiya ꞌisaehaneya tauna simuliyeya ma tupwaina ꞌipwalaina ꞌisaemasiya ꞌoina sitauya ta gwamaina silobeya, ");
INSERT INTO bdd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ma ꞌipwalaina weyahina siyaliyaya madou hedada. ");
INSERT INTO bdd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gwamaina silobeya ma siluhuwa hadai ma gwama sinana Meli baꞌidana siꞌitediya, ma siꞌetuluha gwamaina ꞌoina. Wete helauwedi siꞌewedima ma gwamaina ꞌoina silagudiya, beno goula ma ꞌinisenisi ma wete mulo. ");
INSERT INTO bdd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma muliyetega nihiyega Yehoba ꞌihemataluwediya ma sahena Helodi ꞌoina sihilahila, ꞌoinega sitoholowa ma mali ꞌedega sitauya ꞌidi ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sitauya, ma hesi Yosepa ꞌoina anelose ꞌaigeda nihiyega ꞌilatuwa ma ꞌihegwaeya, ꞌigwae, “Yosepa, ꞌutoholo ma gwama masinana ꞌutoedi ma wadena tupwa Itipita ꞌoina ma nobwa wamiyamiya ma ꞌana siga yahemataluwego, ma walohihilama. Cimi dena bewa huhuna, weyahina Helodi nata beno gwamaina ꞌiꞌebese ma ꞌabehega ꞌiloheꞌamasi.” ");
INSERT INTO bdd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Coinega nihuwanina ꞌoina Yosepa ꞌitoholowa ma gwama masinana ꞌitoediya ma sitauya Itipita. ");
INSERT INTO bdd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma Itipita ꞌoina simiyamiya ma ꞌana siga Helodi ꞌiꞌamasa. Cidi miya taumanaina nage ma ꞌabehega Yehoba ꞌina gwae ꞌilatu, gwaeina ꞌaigeda palopita ꞌihepwaila nugeteya ꞌigwae, “Itipita ꞌoinega natugu yabwauweyama.” ");
INSERT INTO bdd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma tutaina Helodi tosonogaedi ꞌiyamwa ꞌasaediya, weyahina geya sihilama, ꞌidi ꞌabo weyahina ꞌigamwasowala madouna, ma ꞌina loina ꞌilaguya ta toloꞌalehao ꞌihewasaediya Bedeliyema ꞌasanao ꞌoidiya, ma ꞌabehega gwagwama loheloheyadi taudi ꞌadi bolime ꞌeluwa ꞌoinega ꞌisuluwa sida loheꞌamasidi. Gwagwamaedi bewa gide ꞌadi loina Helodi ꞌilaguya, weyahina tosonogaedi ꞌidi gwae ꞌoinega ꞌisanapu pwaiya gwamaina ꞌina liꞌu ꞌana tuta. ");
INSERT INTO bdd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Coinega tutaina ꞌilatuwa toꞌaha palopita Yelemaiya mwalo ꞌihepwaila nugeteya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dougwaegwae ꞌasa Lamaꞌa ꞌoinega tahesagohe. Nuwagala ma mataneu sidogwaegwae. Litiyeli maꞌina susuwao sidoudou, ma ꞌidi dou ꞌoinega sahena siyaliyaliyaya, natudiyao ꞌidi ꞌamasa weyahina.” ");
INSERT INTO bdd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Itipita ꞌoina simiyamiya eeta ꞌana siga Helodi ꞌiꞌamasa, ma Yehoba ꞌina anelose ꞌilatuwa Yosepa ꞌoina, ta nihiyega ꞌihegwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ꞌigwae, “Yosepa, ꞌutoholo ma gwama masinana ꞌutoedi ma wahila Isileli ꞌoina, weyahina gwama ꞌana ꞌaleha ꞌiꞌamasa pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma Yosepa ꞌitoholowa, ma gwama masinana ꞌitoediya ma sihila Isileli. ");
INSERT INTO bdd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sihilama ta Yosepa wasa ꞌihesagoheya ꞌabehega Helodi natuna Alekeleo ꞌihesuwaheyeya ma ꞌihetoloina tupwa Yudiya ꞌoina, ma Yosepa ꞌimatauta ta geya nuwana ꞌitauya Yudiya ꞌoina, ma nihiyega Yehoba sanapu ꞌiꞌebwaeya, ma ꞌisakowasiya ꞌitauya tupwa Galili ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ma ꞌiloꞌasa Nasaleta ꞌoina. Bewa ꞌoinega palopitao ꞌidi hepwaila nugeta ꞌilatuwa sigwae, “Tauna ꞌabwa sihesaniye gwama Nasaleta.” ");
INSERT INTO bdd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tuta nage ꞌoina Yoni toꞌabihebabitaiso ꞌilatuwa balabala ꞌawawa tupwa Yudiya ꞌalona ma ꞌilolohatoto ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Cimi mumuga galana ꞌoidiyega wanuwabui, weyahina Yehoba nata ꞌoida ꞌihetoloina.” ");
INSERT INTO bdd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Palopita Aiseya mwalohene bewa Yoniina weyahina ꞌigwaeya, “Tobwau ꞌaigeda tupwa balabala ꞌawawa ꞌenana madouna ꞌoinega ꞌihepwaila latuwa ma ꞌigwae, ‘Badaina ꞌina ꞌeda wahunae ma wagihedumwalu.’” ");
INSERT INTO bdd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ma Yoni ꞌana ꞌaleꞌo hebai kameli hunuhunuwana tuwa, ma ꞌana gadiwana kameli ꞌwapina, ma ꞌana ꞌeꞌahai bilolo ma mwagagau tuwa. ");
INSERT INTO bdd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma Yoniina tupwa balabala ꞌawawa ꞌilolohatoto ta meYelusalema ma Yudiya ꞌana tomiyao ma weꞌaha Yolidani papalina ꞌana tomiyao mabwaiyadi siꞌautama Yoni ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ma ꞌidi mumuga galana sihepwailediya, ma ꞌoinega ꞌiꞌabihe babitaisowedi weꞌaha Yolidani ꞌalona. ");
INSERT INTO bdd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma Palisiyao ma Sadusiyao baibaiwadi wete sinaoma sabi babitaiso, ta Yoni ꞌiꞌitediya ma ꞌihegwaediya, ꞌigwae, “Toꞌabo ꞌomi gide mwata! Ma wanuwatuhuya ꞌabehega nata Yehoba ꞌina gamwasowala ꞌoinega wadena, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Coinega ꞌilobwainegomiya ma ꞌimi nuwabui moisa waheꞌitaedi ꞌimi paihowa bwebweꞌadi ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma sahena wanuwanuwa hane ꞌabehega ꞌomi Ebalahamo tubunao ma ꞌoinega Yehoba ꞌiꞌatemuyemuyegomi. Hesi geya! Ma waꞌita Yehoba sawasawahina ma dimwa bewa ꞌoidiyega Ebalahamo tubunao ꞌipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ma ꞌeguma ꞌimi mumuga geya bwebweꞌadi nata Yehoba ꞌiheyatalaegomi, gide ꞌaiwe ꞌeguma geya huwaina bwebweꞌana, tomota sigoha yahuledi ma ꞌaiwe ꞌalaꞌalata ꞌoina siuledi ma sigabudi. ");
INSERT INTO bdd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ceguma wanuwabui, taugu weꞌahega yaꞌabihe babitaisowegomi, ma hesi ꞌabwa ꞌaigeda loheya muliguwega ꞌinaonaoma, tauna ꞌimadou sinegauwa, ta geya ꞌilobwainegau ma weyahina ꞌana butu yalihasi. Ma loheyaina ꞌitauyama, ma Yaluyaluwa Tabuna, gide ꞌaiwe ninima, ꞌoinega nata ꞌiꞌabihe babitaiso. ");
INSERT INTO bdd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma wete ꞌina goliyega witi ꞌisapidi ma huwaidi sigubala ma muliyetega huwaina ꞌausaladi ꞌihedodo ꞌina hada ꞌeꞌahai, ma mohomohowedi ꞌigabudi ꞌaiwe ninima hatayaina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tuta nage ꞌoina Yesu tupwa Galili ꞌiꞌebesineya ma ꞌinaowa Yolidani, Yoni ꞌoina, sabi babitaiso. ");
INSERT INTO bdd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Coinega Yoni nuwanuwana Yesu baꞌidana sihesaꞌugelasa, ma ꞌigwaeya, “Cilobwaineya ma ꞌowa ꞌuꞌabihe babitaisogau, ma togidega ꞌunaoma ma ꞌabehega taugu yaꞌabihe babitaisogo?” ");
INSERT INTO bdd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yesu Yoni ꞌina gwae ꞌihemaiseya, ꞌigwae, “Geya. Hesi bewa gide ꞌowa ꞌuꞌabihe babitaisogau. Weyahina bewa ꞌoinega loina mabwaiyadi ꞌausaladi tamuliyedi.” ");
INSERT INTO bdd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Coinega Yoni ꞌitagwala ma Yesu ꞌiꞌabihe babitaisoya. Ma ꞌoinega Yesu weꞌahega ꞌigayohanema, ma galewa ꞌiꞌesoꞌeya ma Yesu Yehoba Yaluyaluwana ꞌiꞌiteya ꞌana ꞌita gide gabubu ꞌisuluma ma ꞌoina ꞌitowa. ");
INSERT INTO bdd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma hesi ꞌaigeda ꞌenana galewega ꞌigwaema ꞌigwae, “Beno natugu moisa. Tauna weyahina yayaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bewa ꞌoinega Yehoba Yaluyaluwana Yesu ꞌitoeya ma ꞌitauyeya tupwa balabala ꞌawawa ma ꞌabehega ꞌana tohona Seitani ꞌoinega ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma sabwelo poti ꞌalona geya ꞌiꞌai, ma ꞌigomaleya madouna. ");
INSERT INTO bdd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma totohoina ꞌilatuma ma ꞌigwaeya, “Ceguma ꞌowa Yehoba Natuna, dimwa bewa ꞌuloinaedi ma siheꞌeꞌahai.” ");
INSERT INTO bdd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Yesu ꞌigwaeya, “Buki Heꞌasisi ꞌalona loina ꞌimiyamiya ꞌabehega, ‘Tomota yawasidi geya ꞌeꞌahaimo ꞌoinega, ma hesi Yehoba ꞌina gwaeyao mabwaiyadi ꞌoidiyega.’” ");
INSERT INTO bdd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Coinega Seitani Yesu ꞌitoeya ma ꞌitauyeya Yelusalema, ma Hada Heꞌasisi* tabwana moisa ꞌoina ꞌihetoholoya, ");
INSERT INTO bdd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ma ꞌihegwaeya, ꞌigwae, “Ceguma ꞌowa Yehoba Natuna, bewa ꞌoinega ꞌulataheya, ma geyaꞌabwa ꞌuhesihesilae. Weyahina Buki Heꞌasisi ꞌigwae pwaiya ꞌigwae, ‘Yehoba ꞌina anelose ꞌiloinaedi ma siꞌitayahigo,’ ma wete ꞌigwae, ‘Nimadiyega siꞌahaligo, ma ꞌoinega sahena ꞌuhesihesilae dimwa ꞌoidiya.’” ");
INSERT INTO bdd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yesu wete ꞌigwaeya, “Caigeda wete gwae Buki Heꞌasisi ꞌoina ꞌimiyamiya, ꞌigwaeya, ‘Sahena ꞌino Bada Yehoba ꞌutohotoho.’” ");
INSERT INTO bdd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ma Seitani Yesu ꞌitoeya ꞌoya madouna tabwanina, ta nage ꞌoina ꞌebe loina wasawasa baleꞌuwa mabwaiyana Yesu ꞌoina ꞌiheꞌitediya, ");
INSERT INTO bdd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ma wete ꞌitohohileya, ꞌigwae, “Tupwa nage mabwaiyadi yada ꞌebwaego, ꞌeguma ꞌubeꞌu sulu ma ꞌoiguwa ꞌutuluha, nata ꞌebe loinaedi yaꞌebwaego.” ");
INSERT INTO bdd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Coinega ꞌiheliyeya ꞌigwae, “Seitani ꞌuꞌebesinegau. Buki Heꞌasisi ꞌalona loina ꞌimiyamiya ꞌabehega, ‘Cino Bada Yehoba namo ꞌoina ꞌuꞌetuluha ma taunamo ꞌina gwae ꞌuhematamatanedi.’” ");
INSERT INTO bdd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma Seitani Yesu ꞌiꞌebesineya, ma muliyega aneloseyao silatuwa ma silemeya. ");
INSERT INTO bdd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ma muliyetega Yesu wasa ꞌihesagoheya ꞌabehega Yoni deliya silaguluhuweya, ꞌoinega ꞌihila ma Galili ꞌoina ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Coinega Nasaleta ꞌiꞌebesineya ma ꞌiloꞌasa Kapaneumi holai, beno susu Sebuloni ma Napitalai ꞌidi baleꞌuwa. ");
INSERT INTO bdd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ginaula bewa weyahina palopita Aiseya mwalohene ꞌihepwaila ta Buki Heꞌasisi ꞌoina ꞌileleya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebuloni ma Napitalai, ꞌidi gogo beno hola ma weꞌaha Yolidani gamwagamwanidiya, taudi ganamuli ꞌidi tupwa, sanina Galili. ");
INSERT INTO bdd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Taudi guguyou ꞌina tupwa ꞌoina simiyamiya, ma hesi bewa tuwa maedana madouna siꞌita pwaiya, weyahina mwalo ꞌamasa ꞌina tupwa galana ꞌoina simiyana, ma bewa tuwa ꞌasilala ꞌoidiya ꞌisaehaneya.” ");
INSERT INTO bdd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuta nage ꞌoina Yesu ꞌina lohatoto ꞌihegaina ta ꞌigwae, “Cimi paihowa galadi ꞌoidiyega wanuwabui, weyahina nata ma Yehoba ꞌihetoloina ꞌoida.” ");
INSERT INTO bdd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Coinega ꞌaigeda tuta Yesu Galili holai ꞌihasahasane, ta togomana siteluwa matasina ꞌiꞌitediya ꞌidi gomana siyahuyahuwe, ꞌaigeda Saimoni, tauna wete sihesaniyeya Pita, ma tasina sanina Andulu. ");
INSERT INTO bdd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Coinega ꞌibwauwediya, ta ꞌigwae, “Wamuliyegau ma tomota waꞌonadi.” ");
INSERT INTO bdd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nage ꞌoina ꞌidi gomana siꞌebesineya ma Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Coinega wete ꞌihasahasane, ma togomana sitetoi wagai ꞌidi gomana sigibugibubudi ꞌiꞌita lobediya, taudi Yemesa ma Yoni matamadiu, tauna sanina Sebedi. Eema Yesu Yemesaina ma tasina ꞌibwauwedima, ");
INSERT INTO bdd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma sitoholowa, ma waga ta tamadiu siꞌebesinediya, ta Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili mabwaiyana ꞌisakowasiyeya, ma ꞌidi hada tapwalolo ꞌoidiya ꞌilohatotowa, ma tetela bwebweꞌana Yehoba ꞌina loina weyahina ꞌihehepwaila, ma wete tomota ꞌadi lohalao ꞌoidiyega ꞌiꞌabi hebwebweꞌanediya mabwaiyadi. ");
INSERT INTO bdd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Coinega Yesu tetelina ꞌisaweyaneya Siliya gogonao mabwaiyadi ꞌoidiya, ꞌoinega tolohalao mabwaiyadi sitautauyedima ꞌoina, taudi silohala madouna ma wahidi simuyamuya, ma taudi hiꞌahiꞌa* siꞌabi hebuwediya, ma taudi ꞌadi lohala hebwasubwasumo ma wete tobelu, ma Yesu ꞌiꞌabi hebwebweꞌanediya mabwaiyadi. ");
INSERT INTO bdd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bewa weyahina boda madouna Yesu simuliyeya, Galiliyega ma Dikapoliyega ma Yelusalemega ma Yudiyega ma wete Yolidani hali tupwega. ");
INSERT INTO bdd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu boda madouna ꞌiꞌitediya, ꞌoinega ꞌiꞌebesinediya ma ꞌihaneya ꞌoyai ma ꞌimiyatoiya, ꞌoina, ma ꞌina tomuliyao wete sihanema. ");
INSERT INTO bdd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Coinega Yesu ꞌihegaina ma ꞌiheꞌita ꞌoidiya, ꞌigwae: ");
INSERT INTO bdd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Comi maꞌimi nuwadobi wayaliyaya, weyahina Yehoba nimana wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Comi todou wete wayaliyaya, ꞌabwa Yehoba ꞌiheyaliyayegomi. ");
INSERT INTO bdd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Comi ꞌimi mumuga nuhana, wayaliyaya weyahina ꞌabwa Yehoba baleꞌu mabwaiyana ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ma ꞌeguma ꞌomi mumuga ꞌausalana nuwanuwami madouna wayaliyaya, beno ꞌabwa mumuga bwebweꞌana ꞌatemiya ꞌimadou. ");
INSERT INTO bdd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ma ꞌomi toꞌatemuyamuya wayaliyaya, weyahina Yehoba wete ꞌiꞌatemuyamuyaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Comi ꞌatemi ꞌausaladi wayaliyaya, weyahina ꞌabwa Yehoba waꞌita. ");
INSERT INTO bdd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Comi toꞌabi henuwadaumwala wayaliyaya, weyahina Yehoba ꞌiꞌahwa natunegomi. ");
INSERT INTO bdd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ceguma ꞌomi ꞌimi paihowa bwebweꞌana weyahina tomota siꞌalehegomi, beno wayaliyaya weyahina Yehoba nimana wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ma ꞌeguma weyahigu tomota siloloheliwegomi, siꞌaleꞌalehegomi, ma ꞌidi ꞌabowega siꞌahwa galegalegomi, wayaliyaya tuwa. ");
INSERT INTO bdd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Moisa ꞌilobwainegomiya ma wayaliyaya madouna, weyahina ꞌabwa ꞌami maisa bwebweꞌana galewa waloba. Ma ꞌomi gide Yehoba ꞌina palopitao mwalo. Weyahina taudi wete ꞌidi miya mwau silobeya tomota ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Comi gide hola mebaleꞌu weyahidi. Ma hesi ꞌeguma hola ꞌina waiwai ꞌigumwala, geya sawasawahina ma ꞌibwebweꞌana hila, ꞌoinega talogwahate ma tasiwa yahule ꞌeda ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Ma wete ꞌomi gide mayale mebaleꞌu weyahidi. Ceguma mayale tagabu, sahena walata ꞌoinega taꞌahuꞌahu hetaluhi, ma hesi ꞌebe lagu tabwanina talagu, ma hada mabwaiyana ꞌiꞌasilala. Wete gide ꞌeguma ꞌoya pwatana taheꞌasa, geya sawasawahina ma ꞌasaina tadahwa. ");
INSERT INTO bdd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Comi wete gide, ꞌilobwainegomiya ma ꞌimi ꞌasilala waꞌabi heꞌasilala tomota ꞌoidiya, ma ꞌoinega ꞌimi paihowa bwebweꞌana siꞌita ma Tamamiu galewa sihepwatuwe. ");
INSERT INTO bdd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sahena wanuwanuwatuhu ꞌabehega taugu yanaoma ma Mosese ꞌina loinao nuwana palopitao ꞌidi heꞌitao yaꞌewayahuledi. Ma hesi yanaoma ma ꞌabehega loinaedi yaꞌabilatuhedi. ");
INSERT INTO bdd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ma yahegwaegomi ꞌabehega loinaedi silatu ma geyaꞌabwa ꞌaigeda toꞌaha muhemuhena ꞌoidiyega ꞌisawala ma ꞌana siga galewa ma baleꞌu sisawala. ");
INSERT INTO bdd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ma ꞌeguma taiya loinaedi ꞌaigeda ꞌoidiyega muhemuhena ꞌilogwahate, ma tomota wete gide ꞌiheꞌitaedi, tauna Yehoba ꞌina ꞌebeloina ꞌalona tauna toloduduna moisa, ma hesi ꞌeguma loinaedi ꞌuhematamatanedi ma ꞌuheꞌitaedi, beno saniu ꞌimadou Yehoba ꞌina ꞌebeloina ꞌalona. ");
INSERT INTO bdd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Wete yahegwaegomi ꞌabehega ꞌilobwainegomiya ma mumugami taudi Palisiyao ma loina ꞌana toheꞌitao ꞌidi mumuga ꞌida bwebweꞌana sinedi. Ma ꞌeguma geya, sahena Yehoba ꞌina ꞌebeloina ꞌoina waluhuluhu. ");
INSERT INTO bdd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Loina nugenugetana tubudao ꞌoidiya wasanapuya, ꞌigwae, “Sahena loheꞌamasa, ma ꞌeguma taiya ꞌiloheꞌamasa, loina ꞌiloba.” ");
INSERT INTO bdd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma hesi taugu yaloinegomi ꞌabehega ꞌeguma taiya ꞌowa tasiu ꞌugamwasowale, ꞌabwa loina ꞌuloba. Ma ꞌeguma tasiu ꞌuꞌahwa galagalae loina ꞌuloba, toloinao ꞌoidiyega. Ma wete ꞌeguma tasiu ꞌana gwae mwauna ꞌulagu, ꞌabwa ꞌuluhu ꞌasa ꞌalaꞌalatana* ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Coinega ꞌeguma ꞌino pwaoli ꞌuꞌeweꞌeweyama ma ꞌabehega ꞌupwaoli Yehoba ꞌoina, ma ꞌeguma ꞌebwa ꞌunuweya ꞌabehega tasiuina ꞌinuwagala ꞌowa ꞌino mumuga weyahina, ");
INSERT INTO bdd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ꞌilobwainegowa ma ꞌino pwaoli ꞌulagu ꞌebe pwaoli deina, ma ꞌuhila tasiu ꞌoina ma ꞌutoho ma baꞌidau walabina hila, ma muliyetega ꞌuhilama ma Yehoba ꞌoina ꞌupwaoli. ");
INSERT INTO bdd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ma ꞌeguma ꞌaigeda loheya ꞌitoego ma ꞌitauyego sabi heyatalaego, ꞌilobwainegowa ma nugeta puiina ꞌugihedumwalu mwayamwayauwe maꞌiyau. Ma ꞌeguma geya, ꞌa toheꞌewaina ꞌida tauyego toloina ꞌoina ma ꞌa loina ꞌuloba, beno silagugo deliya, ");
INSERT INTO bdd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ma hesi geyaꞌabwa ꞌulatulatu ma ꞌana laba ꞌa buki mabwaiyana ꞌuhemaisa hegumwalidi. ");
INSERT INTO bdd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Loina nugenugetana wasanapu pwaiya, ꞌigwae, “Sahena logwali,” ");
INSERT INTO bdd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ma hesi taugu yaloinegomi ꞌabehega ꞌeguma to loheya wahine ꞌoina ꞌinuwatuhu dahwana, tauna ꞌatena ꞌipui pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ceguma mata ꞌebeulauina ꞌebubunega ꞌiꞌabihebeꞌugo ꞌilobwaineya ꞌubwai yahule. Muya geya madouna ꞌeguma wahiu ꞌaigeda tuwa ꞌuloyahule, ma hesi muya madouna ꞌeguma matau weyahina Yehoba wahiu mabwaiyana ꞌiule suluhe ꞌasa ꞌalaꞌalatana* ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Gide wete ꞌeguma nima ꞌebeulauina ꞌina paihowega ꞌiꞌabihebeꞌugo ꞌilobwaineya ma ꞌuꞌupwa yahule. Muya geya madouna ꞌeguma wahiu ꞌaigeda tuwa ꞌuloyahule, ma hesi muya madouna ꞌeguma nimau weyahina Yehoba wahiu mabwaiyana ꞌiulesuluhe ꞌasa ꞌalaꞌalatana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Loina nugenugetana ꞌigwaeya, “Ceguma loheya ꞌaigeda nuwanuwana ma mwanena ꞌisaꞌile ꞌina leta loheyaina ꞌida lele ma mwanena ꞌiꞌebwae ma ꞌoinega ꞌisaꞌila.” ");
INSERT INTO bdd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma hesi taugu yahegwaegomi ꞌabehega, ꞌeguma loheya mwanena geya ꞌipui ma tuwa ꞌisaꞌila ma ꞌihaibala hali wahine ꞌoina, loheyaina beno mwanena nugenugetana ꞌiꞌabihepuiya, ꞌeguma wahineina ꞌihaibala hali loheya ꞌoina. Ma loheyaina ꞌeguma ꞌihai wahine saꞌisaꞌilina ꞌoina beno loheyaina wete topui. ");
INSERT INTO bdd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wete loina nugenugetana wasanapuya ꞌigwaeya, “Ceguma wagwaehane, sahena ꞌimi gwaeyedi waleꞌwaleꞌwadi, ma hesi Yehoba weyahina wapaihowedi.” ");
INSERT INTO bdd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma hesi taugu ꞌimi gwae hane mabwaiyadi yaꞌausidi. Geyaꞌabwa galewa weyahina wagwaegwae hane nuwana waꞌeꞌetaꞌwataꞌwalulu, weyahina galewa Yehoba ꞌina ꞌebemiya. ");
INSERT INTO bdd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sahena baleꞌu weyahina waꞌeꞌetaꞌwataꞌwalulu, weyahina ꞌahena ꞌana ꞌebelagu, wete sahena Yelusalema weyahina waꞌeꞌetaꞌwataꞌwalulu, weyahina toloina madouna ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wete sahena debau weyahina ꞌuꞌetaꞌwataꞌwalulu, weyahina geya sawasawahiu ma debau ꞌaigeda ꞌuloine ma ꞌiwaꞌeꞌe, nuwana ꞌiduba, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma hesi ꞌeguma gwae moisa, ꞌugwae, “Moisa.” Ma ꞌeguma geya, ꞌugwae “Geya.” Weyahina ꞌeguma gwae ꞌulohepoi, beno Seitani ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Loina nugenugetana wasanapu pwaiya, ꞌigwae, “Mata ꞌaigeda ꞌana henimahila mata ꞌaigeda, ma sala ꞌana henimahila sala ꞌaigeda.” ");
INSERT INTO bdd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma taugu yahegwaegomi ꞌabehega sahena wahenimahila, ma hesi ꞌeguma taiya ꞌaseꞌaseu ꞌebeulanega ꞌisapi, sahena ꞌuhehenima hile, ma hesi ꞌaseꞌase ꞌadigeyageyau wete ꞌutagwale ma ꞌisapi. ");
INSERT INTO bdd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma ꞌeguma taiya heyatala ꞌoinega ꞌa ꞌaleꞌo ꞌiꞌewa, ꞌino sita wete ꞌuꞌebwae. ");
INSERT INTO bdd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma wete ꞌeguma taiya ꞌihegwaego ma ꞌina tobwatobwa ꞌuꞌahala gogo ꞌaigeda ꞌoinega ma gogo ꞌaigeda ꞌoina, ꞌilobwainegowa ma ꞌupasima ma gogo heluwena wete ꞌoina ꞌutauya. ");
INSERT INTO bdd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma wete ꞌeguma taiya ꞌiꞌahwaꞌahwanoi ꞌoiuwa ginaula ꞌaigeda weyahina, ginaulaina ꞌuꞌebwae, ma sahena ꞌino tobwatobwa ꞌunuwanuwahi. ");
INSERT INTO bdd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gwae nugenugetana wasanapu pwaiya ꞌigwae, “Ciyamiyao wahelauwedi, ma hesi ꞌami ꞌalehao waloꞌalehedi.” ");
INSERT INTO bdd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma taugu yahegwaegomi ꞌami ꞌalehao wahelauwedi, ma taudi siꞌabi hemuyemuyegomi weyahidi waꞌahwanoi Yehoba ꞌoina ma ꞌiꞌabihetedi. ");
INSERT INTO bdd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bewa ꞌoinega Tamadai galewa ꞌiꞌahwa natunegomi, weyahina tauna helau huhuna, ma tauna wete ꞌina sinala ꞌihalahala togalagala ma tobwebweꞌana ꞌoidiya, ma wete ꞌina dohi ꞌitagwatagwale tobwebweꞌana ma taudi geya tobwebweꞌana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma ꞌeguma ꞌiyamiyaomo wahehelauwedi, geya sawasawahina ma maisa Yehoba ꞌoinega waloba, weyahina togalaedi, gide takesi ꞌana toꞌewao, ꞌidi helau gide ꞌomi ꞌimi helau, ꞌiyadiyaomo sihehelauwedi. ");
INSERT INTO bdd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wete ꞌeguma tasimiyaomo waheꞌiyaꞌiyaguwedi geya mumugami hali tomota mumugadi ꞌibwebweꞌana sine, weyahina taudi ganamuli ꞌiyadiyaomo sihehelabinidi, ꞌoinega taudi ma ꞌomi tuwa mumugami mahemahetena. ");
INSERT INTO bdd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ma ꞌomi ꞌilobwainegomiya ma mumugami ꞌausalana mabwaiyana, gide Tamamiu galewa. ");
INSERT INTO bdd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wete Yesu ꞌigwaeya: Ceguma tutaina nuwanuwami ma wahelau taudi towewelohe ꞌoidiya, sahena tomota matadiya wapaipaihowa. Ceguma gide wapaihowa ꞌese, sahena hepwatu nuwana maisa walobaloba Tamamiu galewa ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ma tutaina wahehelau towewelohe ꞌoidiya, sahena yoguli wamuꞌamuꞌa, gide taudi toꞌeꞌaboꞌabo hada tapwalolo nuwana ꞌasa ꞌoidiya yoguli simuꞌamuꞌadi ma ꞌabehega tomota ꞌidi helau siꞌitadi ma sihepwatuwedi. Hede ꞌadi maisa tuta bewamo ꞌoina silobaloba ma hesi tuta ꞌinaonaoma geya maisadimo. ");
INSERT INTO bdd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma ꞌomi tutaina wahehelau tuwa waꞌebwaya dahwana, ");
INSERT INTO bdd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ma ꞌoinega sahena tomota siꞌitaꞌita, ma Tamamiumo ꞌimi ꞌebwaya dahwanaina ꞌiꞌita, ma muliyetega maisa bwebweꞌana ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Cimi ꞌahwanoi wete gide, ꞌeguma waꞌahwanoi Yehoba ꞌoina, sahena toꞌeꞌaboꞌabo gide waꞌahwaꞌahwanoi, weyahina taudi nuwanuwadi ma tomota matadiya tapwalolo ꞌalona nuwana ꞌasai sitoholo ma siꞌahwaꞌahwanoi. Moisa ꞌadi hepwatu tuta bewa tuwa silobaloba, ma tuta ꞌinaonaoma geya. ");
INSERT INTO bdd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma ꞌowa ꞌeguma ꞌuꞌahwanoi, ꞌuluhu nugeta ꞌino hada ꞌalona ma ꞌuhadagudu ma ꞌuꞌahwanoi dahwana Tamadaina ꞌoina, ma taunamo ꞌiꞌitago ma muliyetega maisa bwebweꞌana ꞌiꞌebwaego. ");
INSERT INTO bdd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma wete ꞌimi ꞌahwanoi ꞌoidiya sahena walolohilahiladi gwae gide taudi ganamuli siꞌobaꞌoba. Taudi ꞌidi hemisa ma gwae baibaiwadi ꞌoidiyega maisa bwebweꞌana siloba. ");
INSERT INTO bdd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sahena ꞌomi taudi gide, weyahina ꞌomi Tamamiu ꞌimiyamiya, ma tauna ꞌami mwauwao ꞌisanapu nugetediya ma muliyetega weyahina waꞌahwaꞌahwanoi. ");
INSERT INTO bdd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Coinega tuta ꞌahwanoi ꞌoidiya bewa gide waꞌahwanoi ꞌesa: “Tamama galewa, saniu ꞌaheꞌasisiye, ma ꞌaꞌahwanoiyego ma ꞌowa ꞌuloinemai, ");
INSERT INTO bdd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ma ꞌoinega ꞌino nuwatuhuwedi ꞌapaihowadi, gide tuwa megalewa sipaipaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cama ꞌeꞌahai sabwelo ꞌaigeda ꞌaigeda ꞌoina ꞌuꞌebwaꞌebwaemai. ");
INSERT INTO bdd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma ꞌima mumuga galadi ꞌunuwasamudi, gide wete tauma ꞌiyamayao ꞌidi mumuga galadi ꞌoima ꞌanuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma sahena ꞌutohotohomai, ma hesi togalaina ꞌoinega ꞌuꞌabihetemai.” ");
INSERT INTO bdd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ceguma ꞌomi ꞌiyamiyao ꞌidi puiyao ꞌoimiya wanuwasamudi, Tamamiu galewa wete ꞌimi puiyao ꞌinuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma hesi ꞌeguma ꞌiyamiyao ꞌidi puiyao ꞌoimiya sahena wanuwanuwa samudi, Tamamiu wete ꞌomi ꞌimi puiyao sahena ꞌinuwanuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wete ꞌeguma tutaina ꞌoina tapwalolo weyahina wahudi, beno geya sowana waꞌai, sahena manimi ꞌilolonohunohu gide tuwa tonuwagala. Ma toꞌabo ꞌidi paihowa gide, weyahina taudi ꞌadi ꞌita siꞌabihegaledi ma ꞌabehega ꞌidi hudi tomota sisanapu. Taudi ꞌadi hepwatu tuta bewamo silobaloba, ma ꞌabwa geya. ");
INSERT INTO bdd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma ꞌomi hesi tutaina ꞌeꞌahai ꞌoinega wahudi tapwalolo weyahina, wamanibuyo ma wasinate, ");
INSERT INTO bdd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌoinega tomota ꞌimi hudiina sahena sisanasanapu ma Tamamiumo toꞌaha ꞌatemiya ꞌimiyamiya ꞌisanasanapu ma ꞌana maisa ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sahena ꞌimi wasawasa baleꞌuwa waheheꞌautedi, weyahina sohusohu ma mwahulu wasawasa baleꞌuwa siꞌabiꞌabi hegaladi ma wete toyagaha siluhuluhu ꞌimi hada ꞌoidiya sabi yagaha, ");
INSERT INTO bdd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ma hesi ꞌimi wasawasa galewa weyahina wahehetapewa. Weyahina galewa geya wete sohusohu nuwana mwahulu ma ꞌida tobwatobwa siꞌabihegaladi, ma wete geya toyagaha. ");
INSERT INTO bdd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma to tupwa ꞌimi wasawasa ꞌimiyamiya, beno tupwaina ꞌoina ꞌimi nuwatuhu ꞌipili. ");
INSERT INTO bdd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matada gide wahida ꞌana ꞌasilala. Coinega ꞌeguma matadaina ꞌausalana, wahida mabwaiyana ꞌasiꞌasilalana, ");
INSERT INTO bdd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ma ꞌeguma matada sigala, wahida wete mabwaiyana siguguyou, ma ꞌeguma ꞌasilalaina ꞌigibo, ꞌabwa guguyou ꞌubwaꞌubwa ꞌiꞌali sakowasiyegita. ");
INSERT INTO bdd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Topaihowa geya sawasawahina ma ꞌihetopaihowa badao ꞌeluwa ꞌoidiya, ꞌaigeda ꞌilogwahate ma hesi ꞌaigeda tuwamo weyahina ꞌipaihowa, ma ꞌoinega ꞌaigeda ꞌiꞌahwa bwebweꞌane ma ꞌaigeda ꞌiꞌahwa galagala. Coinega geya sawasawahina ma Yehoba ꞌina paihowa ma wasawasa baleꞌu taꞌabiluwedi. ");
INSERT INTO bdd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Coinega yahegwaegomi ꞌabehega sahena ꞌimi miya baleꞌuwa weyahina wanuwanuwatuhu madouna, ꞌami ꞌeꞌahai ta ꞌami weꞌaha ta ꞌami ꞌaleꞌo weyahidi. Weyahina yawasida ginaula madouna ꞌoida, ma tobwatobwaedi wahi weyahidi geya ginaula madouna. ");
INSERT INTO bdd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bewa ꞌaigeda ꞌebeꞌita yaꞌebwaegomi bwasumo ꞌoidiya, tuta mabwaiyana geya sidauna, geya siꞌeliꞌeli, ma wete geya ꞌidi hada ꞌeꞌahaimo. Bwasumowedi ginaula ꞌiꞌiudi, ma tuwa beno Tamadai galewa tuta baibaiwana ꞌadi ꞌeꞌahai ꞌiꞌebwaꞌebwaedi. Ma hesi wanuwatuhuyahi ꞌabehega ꞌomi madoumi Yehoba ꞌoina, ꞌoinega sawasawahina ma ꞌiheꞌaigomi. ");
INSERT INTO bdd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma taiya ꞌoimiyega sawasawahina ꞌina nuwatuhuwega ꞌina tuta baleꞌuwa ꞌiꞌabiheduduli? Geya, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Coinega toꞌaha weyahina wanuwanuwatuhu madouna ꞌami ꞌaleꞌo weyahidi? Ma ꞌaigeda wete bewa ꞌebeꞌita, haneyao ꞌidi bwala gogowa weyahidi wanuwatuhu dadani. Tuta baibaiwana geya sipaihowa ma wete geya ꞌadi ꞌaleꞌo sipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma moisa, Solomoni ꞌana ꞌaleꞌowao ma ꞌana pasao ꞌadi ꞌita ꞌausaladi, ma hane ꞌadi ꞌita hesi bwebweꞌana hedada. ");
INSERT INTO bdd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Coinega wanuwanuwatuhu Yehoba ꞌina ꞌitayahina ꞌoimiya weyahina. Tauna pwatula ꞌihepasediya hane bwebweꞌadi ꞌoidiyega; nige haneyedi sididiya ma gona siwelai ma sigabudi, ma ꞌomi pwatula wabwebweꞌana sinediya, ma hesi ꞌami ꞌaleꞌowao ꞌiꞌebwaegomi. Coinega sahena ꞌimi hemisa Yehoba ꞌoina ꞌiweꞌaweꞌa. ");
INSERT INTO bdd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Geyaꞌabwa wanuwanuwatuhu madouna ma wagwaegwae ꞌabehega, “Toꞌaha ꞌaꞌai?” bo “Toꞌaha ꞌanuma?” bo “Toꞌaha ꞌaꞌote?” ");
INSERT INTO bdd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gwae bewa gide tomiya ganamuli ꞌidi gwae. Ma toꞌaha ꞌimi nuwatuhu Tamamiu galewa ꞌisanapu pwaidiya, gide ꞌami ꞌeꞌahai ta ꞌami weꞌaha ta wete ꞌami ꞌaleꞌo ꞌiꞌebwaegomi tuwa. ");
INSERT INTO bdd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cilobwainegomiya ma nugeta Yehoba ꞌina loina ta ꞌina ꞌeda dumwaluna waꞌebese ma wamuliye, eeta ꞌami ꞌeꞌahai ma ꞌami ꞌaleꞌo ꞌiꞌebwaegomi wete. ");
INSERT INTO bdd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Geyaꞌabwa wanuwanuwatuhu gona weyahina. Beno namo nata tuwa weyahina wanuwanuwatuhu. Ma sabwelo sinaonaoma ꞌadi mwau sahena sabwelo nata ꞌana mwau baꞌidana talagulagu hegogone, ma hesi sabwelo ꞌaigeda ꞌaigeda taudi ꞌadi mwau weyahidi tanuwanuwatuhu ꞌadi sabwelowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sahena tomota waꞌahwaꞌahwa galagaladi ꞌamuge wete Yehoba ꞌiꞌahwa galagalaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Weyahina to ginaula ꞌoidiyega tomota waꞌahwa galagalaedi nata ꞌoidiyega Yehoba ꞌiꞌahwa galagalaegomi, ma wete togidega wamumuga ꞌesa tomota ꞌoidiya Yehoba gide wete ꞌimumuga ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ma geya sawasawahina ma tasiu weyahina ꞌugwae ꞌabehega matana ꞌaiwe tupwatupwana ꞌimiyamiya, weyahina ꞌowa wete matauwa ꞌetupwa ꞌimiyamiya, ma geya ꞌuꞌita. ");
INSERT INTO bdd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Geyaꞌabwa tasiu ꞌugwaegwaene ꞌabehega ꞌaiwe tupwatupwana ꞌuꞌewayahule matanega, weyahina ꞌowa wete matauwa ꞌetupwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cowa hede ꞌaigeda toꞌabo, ꞌawa? Ma hesi ꞌetupwa matauwega ꞌuꞌewayahule nugete, ma ꞌoinega ꞌuꞌebubuna bwaibwaina ma muliyetega tasiu matanega ꞌaiwe tupwatupwana ꞌuꞌewayahule. ");
INSERT INTO bdd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sahena Yehoba ꞌina ginaulao ꞌuꞌeꞌeheleye ꞌedewa ꞌoidiya, tabu ta silogwahatedi ma sinaligo. Geya sawasawahina ma wete ꞌimi bagi bawe waꞌebwaꞌebwaedi, tabu ma wete siꞌahuhe biꞌibiꞌidi. ");
INSERT INTO bdd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Waꞌahwanoi, ma Yehoba ꞌiꞌebwaegomi. Wete waꞌebesa ma ꞌoinega waloba. Ma waulaꞌeꞌe ma ꞌahwaꞌeda ꞌisoꞌe. ");
INSERT INTO bdd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ceguma taꞌahwanoi, Yehoba ꞌiꞌebwaya ꞌoida, ma ꞌeguma taꞌebeꞌebesa ꞌabwa taloba, ma wete ꞌeguma taꞌeulaulaꞌeꞌe beno ꞌahwaꞌeda ꞌihuwe ꞌoida. ");
INSERT INTO bdd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ma togidega ꞌomi gwagwama tamadiyao, ꞌeguma natumiyao ꞌeꞌahai weyahina siꞌahwanoi, beno daꞌule waꞌebwaedi? ");
INSERT INTO bdd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bo ꞌeguma silahana weyahina siꞌahwanoi mwata waꞌebwaedi? Geya hene! ");
INSERT INTO bdd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Moisa ꞌomi togala, ma ꞌimi ꞌehele natumiyao ꞌoidiya wasanapu pwaiya, ꞌabehega ginaula ꞌausaladimo waꞌebwaꞌebwaedi. Gide wete Tamamiu galewa, ꞌeguma waꞌahwanoi ꞌoina, ꞌisanapuya toꞌaha bwebweꞌana ꞌilobwainegomiya ma ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ma ꞌeguma nuwanuwami toꞌaha ma tomota ꞌoimiya sipaihowa, beno ꞌomi wete gide ꞌoidiya wapaihowa ꞌese, weyahina bewa Mosese ma palopitao ꞌidi loina ꞌana bwagila. ");
INSERT INTO bdd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Cahwa ꞌiꞌiuna ꞌoinega waluhu ma sahena ꞌahwa madouna ꞌoinega, beno ꞌebe hesilae ꞌana ꞌeda. Cedaina madouna ma ꞌana tauya meyameyahana ma tomota mabwaiyadi ꞌoina sitautauya. ");
INSERT INTO bdd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma yawasi bwebweꞌana ꞌana ꞌeda ꞌana tauya mwauna, ta ꞌana ꞌahwa ꞌiꞌiuna tuwa, ma tomota hisahisadimo ꞌoina siluhuluhu. ");
INSERT INTO bdd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tohepwaila ꞌaboꞌabodi ꞌoidiyega waꞌitayahigomi, weyahina tupwadi ꞌabwa sinaoma ꞌoimiya, ꞌadi ꞌita gide sipi manamanasamidi, ma ꞌalodiya hesi gide tuwa ꞌedewa lolosasa. ");
INSERT INTO bdd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma ꞌidi paihowao ꞌoidiyega ꞌabwa wasanapudi, weyahina talitali geya sawasawahina huwaina ꞌihepiyoi. Buyubuyuwa wete gide geya sawasawahina ma huwaina ꞌihedamaya. ");
INSERT INTO bdd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Weyahina ꞌaiwe bwebweꞌadi huwaidi bwebweꞌadi, ma ꞌaiwe galadi huwaidi wete galadi. ");
INSERT INTO bdd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma ꞌiyamo ꞌaiwe bwebweꞌadi geya sawasawahina ma huwaidi galadi sihuwaedi. Ta wete ꞌaiwe galadi geya sawasawahidi ma huwaidi bwebweꞌadi sihuwaedi. ");
INSERT INTO bdd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma hene ꞌeguma ꞌaiwe geya sida huwa huwaina bwebweꞌana, nata tagoha yahule ma tagabu. ");
INSERT INTO bdd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Gide wete tohepwaila ꞌaboꞌabodi ꞌidi paihowega sawasawahina taꞌinanadi. ");
INSERT INTO bdd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Baibaiwadi ꞌoiguwa siꞌahwaꞌahwa bada ma ꞌabwa sahena siluhuluhu Yehoba ꞌina ꞌebeloina ꞌoina, beno namo taudi Tamagu galewa ꞌana tohematamatanao. ");
INSERT INTO bdd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tuta ꞌinaonaoma ꞌoina tomota baibaiwadi ꞌabwa ꞌoiguwa sigwae, “Bada, ꞌapaihowa weyahiu ma saniuwega ꞌalologuguya ma hiꞌahiꞌa tomota ꞌoidiyega ꞌaula latuwediya, ma wete paihowa ꞌebe henainaida ꞌapaihowediya.” ");
INSERT INTO bdd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma hesi ꞌoidiya ꞌabwa yagwae, “Geya yasanapugomi taiyawedi ꞌomi. Wahila ma geyaꞌabwa waluhuluhuma, weyahina ꞌomi togala.” ");
INSERT INTO bdd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Cigu gwae bewa ꞌeguma taiya ꞌihesagohedi ma ꞌihematamatanedi, tauna gide ꞌaigeda tohadaꞌabi sanasanapuna, ꞌina wahuwahu dimwa ꞌoina ꞌiꞌabiya, ");
INSERT INTO bdd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ma muliyetega dohi ꞌidobima, ma yagewa ꞌidauma, wete yaumai madouna ꞌitowa, ma ꞌina hadaina geya ꞌiguli, weyahina ꞌina wahuwahu dimwa ꞌoina ꞌiꞌabiya. ");
INSERT INTO bdd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma ꞌeguma taiya ꞌigu gwae bewa ꞌihesagohediya ma geya ꞌimuliyedi, tauna gide toheyauyaule ꞌina hada ꞌiꞌabiya nenegwala ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Coinega dohi madouna ꞌidobiya, ma yagewa ꞌidauwa, ma wete yaumai madouna ꞌitowa, ma hadaina ꞌiguliya ma ꞌileꞌwa yahuleya. ");
INSERT INTO bdd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tutaina heꞌita bewa Yesu ꞌilosalohidiya ma bodaedi nuwadi ꞌihenainaida, ");
INSERT INTO bdd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ma sigwae, “Heꞌita bewa waiwaina, ma ꞌida loina ꞌana toheꞌitao ꞌidi heꞌita weꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Coinega ꞌoyega ꞌidobima ma boda madouna simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma ꞌoidiyega ꞌaigeda loheya ma ꞌana lepelo ꞌinaoma Yesu ꞌoina ꞌiꞌahetulasa, ma ꞌihegwaeya ꞌigwae, “Bada, ꞌeguma ꞌino nuwatuhu gide, sawasawahina ma ꞌuꞌabihe bwebweꞌanegau.” ");
INSERT INTO bdd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ta Yesu nimanega loheya ꞌwapina ꞌiꞌabi tohoya, ma ꞌigwae, “Cehe ꞌausala! Cubwebweꞌana.” Ta loheyaina ꞌana lepelo ꞌigumwala mwayamwayauwa, ta ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Coinega Yesu ꞌihegwaeya, “Cutauya ma sahena ꞌeta taiya ꞌoina ꞌuhehepwailegau, ma hesi dumwadumwaluna ꞌutauya topwaoli ꞌoina ma ꞌiꞌitago, ma ꞌoinega ꞌupwaoli Yehoba ꞌoina toꞌaha gide ꞌada loina Mosese ꞌoinega, ma tomota sisanapugo ꞌabehega ꞌubwebweꞌana pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Eeta Yesu ꞌinaoma gogo Kapaneumi ꞌoina, ma toloꞌalehao taudi meLoma ꞌadi tohanugeta ꞌaigeda ꞌinaoma ma ꞌiꞌahwanoiya Yesu ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ꞌigwae, “Bada, ꞌigu ꞌaliꞌe ꞌaigeda ꞌilohala, ma hadai maꞌana muya madouna ꞌiꞌenoꞌeno, ma geya sawasawahina ma ꞌinihu.” ");
INSERT INTO bdd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta Yesu ꞌigwae, “Nata yanaowa ma yaꞌabihe yawesai.” ");
INSERT INTO bdd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma loheyaina Yesu ꞌina gwae ꞌihemisaeya, ꞌigwae, “Bada, geya ꞌilobwainego ma ꞌigu hada ꞌuluhu, ma hesi ꞌugwaemo ma ꞌigu ꞌaliꞌe ꞌiyawesai. ");
INSERT INTO bdd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Weyahina taugu loina yasanasanapu, ma ꞌagu toloinao ꞌidi gwae ꞌana tomuliya, ma wete ꞌigu toloꞌalehao yaloinaedi, ma ꞌeguma ꞌaigeda ꞌoina yagwae, ‘Cutauya’, ꞌitauya tuwa; ma ꞌeguma ꞌaigeda ꞌoina yagwae, ‘Cunaoma’, wete ꞌinaoma; ma ꞌeguma ꞌigu topaihowa ꞌaigeda yahegwae, ‘Bewa ꞌupaihowaꞌ, ꞌipaihowa tuwa.’” ");
INSERT INTO bdd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cina hepwaila bewa ꞌoinega Yesu ꞌiyaliyaya madouna, ta ꞌisakowasiya ma bodaedi simulimuliye ꞌihegwaediya, ꞌigwae, “Moisa, geya ꞌaigeda taiya yaloba meIsileli ꞌoimiyega ꞌina hemisa loheya bewa gide, ");
INSERT INTO bdd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ma yahepwaila ꞌoimiya ꞌabehega baibaiwa hedade ꞌabwa tupwa mabwaiyana ꞌoidiyega sisawalama ma ꞌane Ebalahamo ma Aisake ma Yakobo maꞌiyadiyao siꞌai hegogona Yehoba ꞌina ꞌebeloina ꞌalona, ");
INSERT INTO bdd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ma hesiyage ꞌomi ꞌabehega Yehoba natunao ꞌiula latuwegomi guguyou ꞌalona, ma nobwa wadou ma wahesalaꞌiꞌita, muyamuya ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eeta Yesu toloꞌaleha ꞌadi tohanugetaina ꞌihegwaeya, “Causala, ꞌuhila. Cino ꞌaliꞌe nata ꞌiyawesai, gide ꞌino hemisa.” Tuta nage ꞌoina ꞌina ꞌaliꞌeina waiwai ꞌilobeya. ");
INSERT INTO bdd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Coinega Yesu Pita ꞌina hada ꞌiluhuwa, ma Pita lawana ꞌiꞌiteya ꞌilohala, wahina ꞌiloyahiyahiya. ");
INSERT INTO bdd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eeta ꞌinaowa ma nimana ꞌiꞌabiya, ma ꞌina lohala ꞌisawala, ma ꞌitoholowa ma ꞌeꞌahai ꞌiꞌatububuya Yesu weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Coinega boi hohauwa tomiya ꞌasao tupwadi tomota siꞌewedima, taudi hiꞌahiꞌa* ꞌoidiya simiyamiya, ꞌoinega Yesu hiꞌahiꞌaedi ꞌina gwaeyega ꞌiula latuwediya, ma wete tolohalao mabwaiyadi ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ginauledi bewa silatu pwaiya ma ꞌoinega palopita Aiseya ꞌina hepwaila nugeta ꞌilatuwa, gide Buki Heꞌasisi ꞌoina ꞌihepwaila ꞌigwae, “Tauna ꞌida muyamuya ma ꞌada lohalao ꞌana toꞌewayahula.” ");
INSERT INTO bdd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tuta nage ꞌoina Yesu boda madouna ꞌiꞌitediya sitoholo sakowasiyeya, ꞌoinega ꞌana tomuliyao ꞌihegwaediya ma ꞌabehega wagega sihabala hali tupwa. ");
INSERT INTO bdd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Coinega ꞌaigeda loina ꞌana toheꞌita ꞌinaoma ma Yesu ꞌihegwaeya ꞌigwae, “Toheꞌita, nuwanuwagu ma yamuliyego. To tupwa ꞌoina ꞌutautau taugu yamuliyego.” ");
INSERT INTO bdd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yesu loheyaina ꞌihegwaeya, ꞌigwae, “Cedewa totopwatula maꞌidi gaula, ma wete bwasumo maꞌidi nehwa, ma taugu Loheyaiguina geya ꞌigu ꞌebe ꞌenomo.” ");
INSERT INTO bdd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta ꞌaigeda wete tomuliya ꞌinaoma ma Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌutagwalegau ma yahila nugeta ma tamagu yayamwa ꞌina ꞌamasa weyahina, ma yalagu, ma muliyetega yamuliyego.” ");
INSERT INTO bdd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta Yesu ꞌihegwaeya, “Tuwa! Nobwa tamau, ma hesi ꞌumuliyegau, ma taudi toꞌamasao ꞌidi toꞌamasa silagu galiha.” ");
INSERT INTO bdd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Coinega Yesu ma ꞌana tomuliyao sigeluwa wagai, ");
INSERT INTO bdd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ma sihabahabala hali tupwa, ma Yesu waga ꞌalona ꞌiꞌeno sineya. Ma muliyetega wediliya madouna ꞌitowa, ma bagodu ꞌisiwasiwa diꞌwa wagai, ma ꞌiꞌiunamo ma sidamana. ");
INSERT INTO bdd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta Yesu sihanoya ma sigwae, “Bada, ꞌulememai ꞌamuge tadamana.” ");
INSERT INTO bdd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma ꞌihegwaediya, “Toꞌaha weyahina wamatauta? Togidega geya ꞌimi hemisamo, ꞌawa?” Coinega ꞌitoholowa ma yaumai ma bagodu ꞌiheliyediya, ꞌigwae, “Walolagu!” Ma niꞌu mabwaiyana ꞌidaumwala. ");
INSERT INTO bdd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Coinega tomotaiyedi siꞌiteya nuwadi ꞌihenainaida ma sigwae, “To loheya bewa, ta yaumai ma bagodu ꞌenana simuliyeya?” ");
INSERT INTO bdd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sihabala pwaiya ma siluhuwa meGadala ꞌidi tupwa, ma loheya siteluwa hiꞌahiꞌa ꞌiꞌabihebuwediya ma galiha duluhina ꞌoinega silatuma. Ma mumugadi gala hedade, ꞌoinega geya sawasawahina ma ꞌaigeda taiya ꞌidi tupwaina ꞌoinega ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Siteluwaedi Yesu siꞌiteya ma sitalaꞌasona, sigwae, “Cei! Cowa Yehoba Natuna, toꞌaha ꞌutohotoho ma ꞌabehega ꞌupaihowa ꞌoima? Cabehega tuta bewa ꞌunaoma sabi ꞌabihe muyemuyemai ma muliyetega heyatala?” ");
INSERT INTO bdd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma deidiya bawe baibaiwadi siduladula, ma ꞌadi toꞌitayahinao siꞌitaꞌitayahidi. ");
INSERT INTO bdd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Coinega hiꞌahiꞌaedi Yesu ꞌoina siꞌahwanoiya, sigwae, “Ceguma ꞌuula latuhemai, sawasawahina ma baweyedi nage ꞌoidiya ꞌuhetunemai?” ");
INSERT INTO bdd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma ꞌihegwaediya, “Walatuma.” Ta loheloheya siteluwaedi ꞌoidiyega hiꞌahiꞌaedi siulalatuwa ta silomwaya mwayauwa, bawe ꞌoidiya siluhuwa, ꞌoinega baweyedi mabwaiyadi sipili butubutu ta ꞌadeꞌadewalega sibeꞌuwa ma holai sidamana. ");
INSERT INTO bdd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Coinega baweyao ꞌadi toꞌitayahinaowedi simatauta ma sidena sitauya ꞌidi ꞌasa, ma ginauledi siꞌitediya mabwaiyana sihepwailediya tomiya ꞌasaedi ꞌoidiya, toꞌaha gide yauyauledi ꞌoidiya ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ta tomiya ꞌasaedi mabwaiyadi silatuma Yesu sabi ꞌitaina, ma tutaina silobeya silohesohesoiyeya ma ꞌabehega ꞌidi tupwa ꞌiꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Coinega Yesu wagai ꞌigeluwa ma ꞌihabala hila ꞌina gogowa. ");
INSERT INTO bdd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma ꞌaigeda topeu boda siꞌahaliya ꞌina ꞌebeꞌeno ꞌoina ma sinaoleyama Yesu ꞌoina. Bodaedi ꞌidi hemisa Yesu ꞌisanapuya ma topeu ꞌihegwaeya ꞌigwae, “Natugu, ꞌuyaliyaya, ꞌino mumuga galadi ꞌadi nuwasam ꞌuloba pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma tupwadi loina ꞌana toheꞌitao Yesu ꞌina gwae sihesagoheya ma taudimo sihehegwaegwae sigwae, “Yesuina ꞌigwaegwae hopaꞌala Yehoba ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Cidi nuwatuhuina Yesu ꞌisanapu pwaiya ma ꞌihegwaediya, ꞌigwae, “Toꞌaha weyahina ꞌatemiyega wanuwanuwatuhu galana? ");
INSERT INTO bdd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma toꞌaha wanuwatuhuya yada gwae loheya bewa ꞌoina ma ꞌabehega yagwae, ‘Cino mumuga galana yanuwasam pwaiya’, nuwana yada gwae, ‘Cutoholo ma ꞌutauya’? ");
INSERT INTO bdd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma wasanapu ꞌabehega taugu Loheyaiguina baleꞌuwa ma sawesawehigu tomota ꞌidi mumuga galana yanuwasamudi.” Coinega topeuina ꞌihegwaeya, ꞌigwae, “Cutoholo ma ꞌino ꞌebeꞌeno ꞌuꞌahali ma ꞌutauya ꞌino gogowa.” ");
INSERT INTO bdd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Coinega topeuina ꞌitoholowa ma ꞌitauya ꞌina gogowa.’ ");
INSERT INTO bdd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma bodaedi paihowa bewa siꞌiteya ma maꞌidi heꞌasisi Yehoba sihehepwatuwe, weyahina tauna Yesu ꞌana toꞌabihewaiwai. ");
INSERT INTO bdd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Coinega Yesu tupwa bewa ꞌiꞌebesineya ma ꞌitauya, ma loheya ꞌaigeda ꞌiꞌiteya, sanina Madiu, takesi ꞌana hada ꞌebe paihowa ꞌalona ꞌimiyamiya, ꞌoinega ꞌihegwaeya, ꞌigwae, “Madiu, ꞌumuliyegau.” Ta Madiu ꞌitoholowa ma Yesu ꞌimuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Muliyetega hada ꞌaigeda ꞌoina Yesu ꞌiluhuwa sabi ꞌai ma tolopui gide takesi ꞌana toꞌewao ma tolopui tupwadi wete sinaoma, ma Yesu maꞌana tomuliyao maꞌiyadiyao simiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Coinega tupwadi Palisiyao siꞌiteya ma Yesu ꞌana tomuliyao ꞌoidiya sihesilala, sigwae, “Toꞌaha weyahina ꞌimi toheꞌita takesi ꞌana toꞌewao ma wete togala tupwadi baꞌidanao siꞌaiꞌai hegogona?” ");
INSERT INTO bdd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ma Yesu gwae bewa ꞌihesagoheya ma ꞌihegwaediya, “Taudi wahidi waiwaidi geya nuwadi toꞌabihebwebweꞌana, ma tolohalao hesi. ");
INSERT INTO bdd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Coinega ꞌilobwainegomiya ma Yehoba ꞌina gwae wanuwa sabwalena Buki Heꞌasisi ꞌoina, ꞌigwaeya, ‘Nuwanuwagu ꞌatemuyamuya, ma geya nuwagu pwaoli.’ Bewa yanaoma geya tobwebweꞌana weyahidi, ma hesi topui sabi ꞌabihetedi.” ");
INSERT INTO bdd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ta Yoni ꞌana tomuliyao sinaoma ma Yesu sihegwaeya, sigwae, “Tauma ma Palisiyao ꞌima tapwalolo weyahina ꞌai ꞌoinega ꞌahudi, ma togidega ma ꞌoinega ꞌowa ꞌa tomuliyao geya sida hudi?” ");
INSERT INTO bdd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Coinega Yesu gwae hegehegedi ꞌiꞌebwaediya, ꞌigwae, “Togidega, sawasawahina hai ꞌana toyoꞌowao sinuwagala ꞌeguma tohai meloheyana maꞌiyadiu siyaliyaliyaya? Nuwana geya, ꞌawa? Ma wanuwatuhuyahi ꞌabehega tuta ꞌinaonaoma ma tohaiina ꞌiꞌebesinedi, ma hesi sinuwagala ma ꞌeꞌahai ꞌoinega siꞌetala heꞌasisi.” ");
INSERT INTO bdd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma ꞌaigeda wete gwae hegehegedi ꞌihegwaediya, ꞌigwae, “Geya sawasawahina ma ꞌaleꞌo ꞌehauna tupwatupwana ꞌaleꞌo miyamiyana tabwabwada, ꞌamuge gide taigalaina ꞌilotaigalasehe. ");
INSERT INTO bdd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma geya wete sawasawahina ma weꞌaha ꞌehauna ma waiwaina tasiwa ꞌwapi ꞌebesiwa miyamiyana ꞌoina. Ceguma bewa gide tapaipaihowa ꞌese, weꞌaha ꞌina seseha ꞌoinega ꞌwapiina ꞌilotaigala, ma weꞌahaina ꞌilotasiwa, ma ꞌoinega ꞌebesiwaina ꞌigala. Ma ꞌilobwaineya ma weꞌaha ꞌehauna ma waiwaina tasiwa ꞌebesiwa ꞌehauna ꞌalona, ma ꞌoinega mabwaiyana bwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cabwa Yesu ꞌihehegwaegwae ma ꞌaigeda toloina ꞌinaoma ma Yesu matana ꞌiꞌahetulasa, ma ꞌigwae, “Bada, natugu wahinena nige ꞌiꞌamasa, ma nuwanuwagu ꞌunaoma ma wahina ꞌuꞌabitoho ma ꞌitoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma Yesu ꞌitoholowa ta maꞌana tomuliyao toloinaina simuliyeya, ");
INSERT INTO bdd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ma sitautauya, ma wahine ꞌaigeda bweyahina ꞌidaudau bolime tuwelo ꞌoidiya mulidiyega ꞌinaoma, ma Yesu ꞌana ꞌaleꞌo papalina ꞌiꞌabitohoya. ");
INSERT INTO bdd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Weyahina ꞌina nuwatuhu ꞌatena ꞌigwaeya, “Ceguma tuwa Yesu ꞌana ꞌaleꞌomo yaꞌabitoho, nata yabwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ma Yesu ꞌiloꞌitahila ta wahineina ꞌiꞌiteya, ma ꞌigwae, “Yauwedo natugu, ꞌino hemisega ꞌubwebweꞌana pwaiya.” Ma tuta nage ꞌoina wahineina ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Coinega Yesu ꞌitauya ma toloinaina ꞌina hada ꞌilatuwa ma ꞌiꞌiteya todou sidoudou ma lololi ꞌana tomuꞌao lololi simuꞌamuꞌadi, ta ꞌenadi madou hedada. ");
INSERT INTO bdd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta Yesu ꞌihegwaediya ꞌigwae, “Walatu. Gwama bewa geya ꞌiꞌamasa, ma hesi ꞌiꞌeno sineya.” Ma simaluweya. ");
INSERT INTO bdd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eeta bodaedi silatuwa ma Yesu ꞌiluhuwa ma gwamaina nimana ꞌiꞌabiya, ta mayawasina ꞌitoholowa. ");
INSERT INTO bdd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Muliyetega wasaina bewa ꞌiꞌedadana tupwa mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tupwa nage ꞌoinega Yesu ꞌitautauyama, tomata gibugibu ꞌeluwa simuliyeya, ma sibwaubwau ꞌenadi madouna ꞌoinega, sigwae, “Debida tubuna ee, ꞌuꞌatemuyemuyemai!” ");
INSERT INTO bdd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ta hadai ꞌiluhuwa ma tomata gibugibuwedi sinaoma ꞌoina, ma Yesu ꞌihegwaediya, “Togidega wahemisegauwa ꞌabehega sawasawahigu matami yaꞌabi heꞌasilala?” Ma taudi sigwae, “Bada, sawasawahiu.” ");
INSERT INTO bdd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Coinega matadi ꞌiꞌabitohodiya ma ꞌihegwaediya, “Cimi hemisa ꞌoidiyega matami siꞌasilala,” ");
INSERT INTO bdd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ma matadi siꞌasilala. Ma Yesu loina paꞌalina ꞌiꞌebwaediya, ꞌigwae, “Sahena taiya ꞌoina wahehepwailegau.” ");
INSERT INTO bdd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ta hesi sitauya, ma Yesu ꞌina loina siligehiya, ma ꞌina paihowaina sihepwaila dadaneya tupwa mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma Yesu maꞌana tomuliyao sitautauya, ma ꞌaigeda loheya welabana memenana sibuiya sitoeyama Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma ꞌoinega Yesu welabana ꞌipaꞌiya, ma loheyaina ꞌibwebweꞌana ma ꞌihegwaegwae. Ma boda maꞌidi yaliyaya Yesu siꞌahwa bwebweꞌaneya, ma sigwae, “Geya ꞌeta taiya ꞌina paihowa bewa gide taꞌita Isileli ꞌalona.” ");
INSERT INTO bdd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma hesi Palisiyao sigwaeya, “Welabanao ꞌidi bada ꞌina waiwaiyega Yesu welabanao ꞌipaꞌipaꞌidi, ma geya Yehoba ꞌina waiwaiyega.” ");
INSERT INTO bdd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ta Yesu ꞌasa madoudi ma ꞌiꞌiudi ꞌoidiya ꞌisakowasiya ma ꞌidi hada tapwalolowao ꞌoidiya ꞌiheꞌita ma ꞌiloguguya Yehoba ꞌina loina tetelina weyahina, ma wete lohala baibaiwana ꞌoidiyega tomota ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma boda ꞌiꞌitediya ma ꞌiꞌatemuyemuyediya, weyahina ꞌadi mwauwao ꞌoidiyega geya ꞌadi toꞌabihetenamo, gide sipi ꞌwaniꞌwanidi, geya ꞌadi toꞌitayahinamo. ");
INSERT INTO bdd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma ꞌana tomuliyao ꞌihegwaediya, “Mamasalai bwebweꞌana, ma toꞌeliꞌeli ꞌomi hisahisamimo. ");
INSERT INTO bdd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Coinega tanoha taniwagana ꞌoina waꞌahwanoi ma topaihowao wete ꞌihesumanedi, ꞌina tanoha siꞌeli.” ");
INSERT INTO bdd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ꞌana tomuliyao site tuwelo ꞌibwauwediya ma loina ma waiwai ꞌiꞌebwaediya ma ꞌoinega sawasawahidi hiꞌahiꞌa tomota ꞌoidiyega siulalatuhedi ma lohala ma weꞌa ꞌoidiyega tomota siꞌabihe bwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cana tomuliyaowedi sanidiyao bewa: Nugeta Saimoni, tauna sihesaniyeya Pita, ma tasina Andulu, wete Yemesa ma tasina Yoni, taudi tamadiu Sebedi, ");
INSERT INTO bdd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","wete Pilipi ma Batolomiu ma Tomasi ma Madiu, tauna takesi ꞌana toꞌewa, ma wete hali Yemesa tauna Alipiyo natuna, ma Tadiyasi, ");
INSERT INTO bdd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma wete hali Saimoni, tauna toꞌalaꞌoheꞌohe Isileli ꞌina miyawasi Loma weyahina, ma Yudasa Isakaliyota, tauna ꞌabwa Yesu ꞌitebae. ");
INSERT INTO bdd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu site tuwelowedi ꞌiloinediya ma ꞌihesumanediya, ꞌigwae, “Sahena taudi ganamuli ꞌoidiya watautauya, ma wete sahena Sameliya ꞌasanao ꞌoidiya waluhuluhu, ");
INSERT INTO bdd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ma hesi sipi ꞌwaniꞌwanidi ꞌoidiya watauya, taudi beno ꞌida bodao meIsileli, ");
INSERT INTO bdd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ma ꞌoidiya wahepwaila ꞌabehega Yehoba ꞌina loina ꞌilatu pwaima. ");
INSERT INTO bdd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tolohalao waꞌabihe yawesaidi ma toꞌamasa waꞌabihe toholodi ma tolepelowao waꞌabihe bwebweꞌanedi, ma wete hiꞌahiꞌa tomota ꞌoidiyega waulalatuhedi. Yehoba ꞌina helau ꞌiꞌebwae daisigomi pwaiya, ꞌoinega ꞌomi wete sawasawahimi ma waꞌebwaya ꞌawawa tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ma ꞌimi sakowasi ꞌoina sahena mane ꞌimi peha ꞌoidiya wadoꞌodoꞌo, haite weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sahena wete peha waꞌewaꞌewa, sahena wete ꞌami ꞌaleꞌo ꞌeluwa, sahena ꞌami butu ꞌeluwa, sahena ꞌimi digona ꞌeluwa waꞌewaꞌewadi, ma hesi ꞌabwa ꞌami ꞌiluwana waloba, ꞌabwa waꞌai. ");
INSERT INTO bdd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma ꞌeguma ꞌasa madouna bo ꞌiꞌiuna ꞌoina waluhu waꞌebesa nugeta taiya ꞌina mumuga ꞌausalana, ma ꞌoina wahetaumana ee ꞌana siga tupwaina waꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ꞌeguma ꞌaigeda hada ꞌoina waluhu, nugeta waloyauwedo ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ceguma susuwedi ꞌidi mumuga ꞌausalana, wahelauwedi ma wagwae helauwedi, ma ꞌeguma ꞌidi mumuga galana sahena ꞌimi helau ma ꞌimi gwae helau ꞌoidiya wamudamudali. ");
INSERT INTO bdd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Ma ꞌeguma geya ꞌaigeda taiya ꞌitoegomi ꞌina hada, nuwana ꞌimi gwae geya ꞌihesagohedi, ꞌasaina ꞌoinega walatu ma ꞌahemiyega gawalina walohutuhutui yahuledi ꞌidi tupwa, beno ꞌebeꞌita ꞌasa taniwagadiyao ꞌoidiya, ma muliyetega ꞌasaina waꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Moisa, ꞌabwa yatala ꞌana tuta ꞌoina, taudi ꞌasaedi silologwahategemiya loina madou hedada siloba, ma geya gide meSodoma ma meGomola ꞌadi loina. ");
INSERT INTO bdd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Wanuwatuhuyahi ꞌabehega taugu yahesumanegomi gide sipi manamanasamumi watautauya ꞌedewa lolosasa gamwagamwanidiya, ꞌoinega sawasawahina ma wanuwasanapu mwata gide, ma hesi wamumuga hohonuha gide gabubu. ");
INSERT INTO bdd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Coinega waꞌitayahigomi, weyahina tomota ꞌabwa sitauyegomi, yatala weyahina, ma hada tapwalolo ꞌoidiya ꞌabwa siꞌetutuwegomi, ");
INSERT INTO bdd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ma sitoegomi ma sitauyegomi toloinao ma kiniyao matadiya ma siheꞌewegomi, weyahina ꞌomi ꞌabehega ꞌigu bodao, ma wasagu ꞌoidiya wahepwaile, ma wete tupwa ꞌatamana tomotaedi ꞌimi hepwaila sihesagohe. ");
INSERT INTO bdd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Ma ꞌeguma matadiya sihetohologomi sahena waꞌateꞌateyoho togidega wagwae ꞌesa, weyahina tutaina ꞌabwa Yehoba ꞌimi gwae ꞌida ꞌebwaegomi, ");
INSERT INTO bdd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ma geya ꞌabehega ꞌomi wagwaegwae, ma Yehoba yaluyaluwana ꞌoimiyega ꞌigwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma wete tuta sinaonaoma ꞌoidiya tomota ꞌidi susu ꞌalona loꞌaleha ꞌilatu weyahigu, beno loheya tasina ꞌitebae ma siloheꞌamasi. Gide wete tamana natuna ꞌitebae ma siloheꞌamasi. Wete gwagwama sinadiyao ma tamadiyao ꞌoidiya siloꞌaleha ma siloheꞌamasidi. ");
INSERT INTO bdd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma tomota mabwaiyadi siloꞌalehegomi weyahina ꞌomi ꞌabehega ꞌagu tohemisao. Ma ꞌeguma taiyawedi siꞌalamaꞌiꞌita ma sitoholo paꞌala ma ꞌana siga tuta ꞌana ꞌebelosaloha ꞌoina, ꞌabwa yaliyaya hataya siloba. ");
INSERT INTO bdd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Ma ꞌeguma ꞌaigeda tupwa ꞌoina sihunuhunugomi, wadena hali ꞌasa ꞌoina. Moisa ꞌabwa, sahena ꞌasa mabwaiyana Isileli ꞌalona wapaipaihowa salohi, ma taugu loheyaiguina yahilama. ");
INSERT INTO bdd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tomuliya geya sawasawahina ma ꞌina toheꞌita ꞌimadousine. Gide wete topaihowa geya sawasawahina ma ꞌina bada ꞌiloine. ");
INSERT INTO bdd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma hesi ꞌausala ꞌeguma ꞌabehega ꞌomi ꞌagu tomuliyao, ma ꞌomi ma taugu tahemahemahetena. Weyahina taugu hada toniwagagu, ma ꞌeguma sihesaniyegau Tomudulele, ꞌomi ꞌigu bodao ꞌabwa siꞌahwa galagalaegomi madouna. ");
INSERT INTO bdd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Coinega sahena tomotaedi wamatamatautedi, weyahina ginauledi ꞌwaiꞌwaihidi ꞌabwa Yehoba ꞌiꞌabi latuwedi, ma siꞌasilala. ");
INSERT INTO bdd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eeta toꞌaha guguyou ꞌoina yahepwailediya ꞌoimiya, sabwelowa wahepwailedi tomota baibaiwadi ꞌoidiya, ma toꞌaha yaheꞌahwa henahenaeya ꞌoimiya wahepwaila latuwedi ꞌimi talubeꞌuwega. ");
INSERT INTO bdd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ma taudi wahimi siloloheꞌamasi sahena wamatamatautedi, weyahina taudi wahimimo sawasawahina ma siloheꞌamasi, ma yaluyaluwami geyaꞌabwa. Ma hesi Yehoba wamataute, weyahina tauna sawasawahina ma ꞌasa ꞌalaꞌalatana* ꞌoina wahimi ma yaluyaluwami ꞌiloheꞌamasi luwedi. ");
INSERT INTO bdd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Cebeꞌita bewa, ꞌeguma dinegwa ꞌeluwa tagimwanedi, ꞌadi maisa toea ꞌaigeda tuwa, ma hesi Yehoba ꞌiꞌitaꞌitayahidi, ma ꞌeguma ꞌaigeda ꞌiꞌamasa, beno Tamamiuina ꞌina nuwatuhu ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma bwagana geya sawasawahina ma hunuhunuwa wahasili deba ꞌaigeda ꞌoina, ma hesi Yehoba ꞌadi baibaiwa ꞌisanasanapu. ");
INSERT INTO bdd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Coinega sahena waꞌateꞌateyoho, weyahina ꞌomi Yehoba ꞌina ginaula madouna, ma dinegwa geya ginaula madouna. ");
INSERT INTO bdd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ceguma taiyawedi weyahigu sihehepwaila tomota matadiya, ꞌabwa galewa taugu wete weyahidi yahepwaila Tamagu matana. ");
INSERT INTO bdd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ꞌeguma taiyawedi siuhalegau tomota matadiya, taugu wete ꞌabwa galewa Tamagu matana yauhaledi. ");
INSERT INTO bdd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sahena wanuwanuwatuhu ꞌabehega ꞌigu dobima baleꞌuwa ꞌoinega nuwadaumwala waloba. Geya hene, ma ꞌaleha hesi. ");
INSERT INTO bdd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cigu dobima weyahina loheya tamana ꞌiloꞌalehe, ma wete wahine sinana ꞌiloꞌalehe, ma wahine lawana ꞌiloꞌalehe, ");
INSERT INTO bdd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ma loheya ꞌina susu siloꞌalehe. ");
INSERT INTO bdd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma ꞌeguma taiya tamana ma sinana ꞌihelauwedi madouna, ma taugu ꞌiꞌiuna, tauna geya sawasawahina ma ꞌimuliyegau. Ma ꞌeguma taiya wete natuna meloheyana bo mewahinena, ꞌihelauwe madouna, ma taugu ꞌiꞌiuna, tauna geya sawasawahina ma ꞌimuliyegau. ");
INSERT INTO bdd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma ꞌeguma taiya yawasina geya ꞌitagwale ma ꞌiꞌamasa kelose ꞌoina, gide taugu, tauna geya sawasawahina ma ꞌimuliyegau. ");
INSERT INTO bdd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma ꞌeguma taiya tauna yawasina weyahina ꞌipaipaihowa, ꞌabwa ꞌiꞌwadalele; ma ꞌeguma taiya yawasina ꞌiꞌwadalele weyahigu, ꞌabwa yawasi ꞌausalana ꞌiloba hila. ");
INSERT INTO bdd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma ꞌeguma taiya ꞌitoegomi, taugu ma ꞌagu Tohesumanaina wete ꞌitoemai. ");
INSERT INTO bdd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ꞌeguma ꞌowa palopita ꞌutoe ꞌina hepalopita weyahina, ꞌabwa palopita ꞌana maisa ꞌuloba. Ma ꞌeguma ꞌowa loheya ꞌausalana ꞌutoe ꞌina mumuga bwebweꞌana weyahina, ꞌabwa loheya bwebweꞌana ꞌana maisa ꞌuloba. ");
INSERT INTO bdd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma ꞌeguma ꞌowa weꞌaha gogai ꞌagu tohemisa ꞌehauna ꞌaigeda ꞌoina ꞌuꞌehele, yahegwaego ꞌabwa ꞌa maisa ꞌausalana ꞌuloba.” ");
INSERT INTO bdd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ꞌina lohatoto ꞌana tomuliyao site tuwelo ꞌoidiya ꞌilosalohiya, ma ꞌoinega tupwaina ꞌiꞌebesineya ma ꞌisakowasiya ꞌasaedi ꞌaigeda ꞌaigeda ꞌoidiya, ꞌiheꞌita ma ꞌilolohatoto. ");
INSERT INTO bdd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tuta nage ꞌoina Yoni toꞌabihebabitaiso deliya silagu pwaiya, ma Toꞌabihetenaina ꞌina paihowa tetelina ꞌihesagoheya, ma ꞌoinega ꞌana tomuliyao ꞌihesumanediya ta sitauya Yesu ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ma sihesilaleya, sigwae, “Togidega ꞌowa Toꞌabihetenaina weyahiu ꞌayamwayamwa, bo hali loheya ꞌayamwayamwa?” ");
INSERT INTO bdd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta ꞌidi gwae Yesu ꞌihemaiseya, ꞌigwae, “Wahila ma Yoni ꞌoina waheꞌoteꞌotetela ginauledi ꞌoiguwega wahesagoheya, ma wete waꞌitediya, ");
INSERT INTO bdd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tomata gibugibu matadi ꞌitayahala pwaiya, toheꞌauꞌau sibwebweꞌana pwaiya ta sitautauya, tolepelo wahidi sibwebweꞌana hila, totenatuitui gwae sihehesagohe, toꞌamasa sitoholo hila, ma wete tohewewelohe tetela bwebweꞌana sihesagohe pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Coinega watauya ma Yoni wahegwae ma sahena weyahigu ꞌihehenuwanaluwa, weyahina ꞌeguma taiya ꞌina hemisa weyahigu geya ꞌiweꞌa, tauna ꞌiyaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eeta Yoni ꞌana tomuliyaowedi sihila, ma Yesu ꞌiꞌahwa lalagata ma boda ꞌoidiya Yoni weyahina ꞌihepwaila ꞌigwaeya, “Mwalo mabwaiyami tupwa balabala ꞌawawa watauya Yoni sabi hesagohaina, ma toꞌaha nuwanuwami ma ꞌabehega waꞌita? Cemi nuwanuwami ꞌabehega ꞌaigeda pwatula sinabwana yaumai ꞌinihunihuwe waꞌita? ");
INSERT INTO bdd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“Bo nuwana ꞌaigeda loheya ma ꞌana ꞌaleꞌo wasawasa sabi ꞌitaina? Bo geya, weyahina taudi ma ꞌadi ꞌaleꞌo wasawasa toloina madoudi ꞌidi tupwa simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Ma toꞌaha hede weyahina ta watauya balabala ꞌawawa? Nuwana ꞌabehega wanuwatuhuya nata palopita ꞌaigeda waꞌita ꞌawa? Moisa, loheyaina waꞌiteya palopitao ꞌimadou sinediya. ");
INSERT INTO bdd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoniina weyahina mwalo Yehoba ꞌina gwae Buki Heꞌasisi ꞌoina bewa gide ꞌihepwaila nugeteya, ꞌigwae, ‘Bewa ꞌigu tohalewasa yahesumane matauwa ꞌitautauya, ma ꞌino ꞌeda ꞌihuna.’” ");
INSERT INTO bdd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta Yesu wete ꞌigwae, “Moisa, Yoni toꞌabihebabitaiso tauna mebaleꞌu mabwaiyadi ꞌimadou sinediya, ma hesi mabwaiyadi taudi Yehoba ꞌina ꞌebeloina ꞌalona Yoni simadou sineya. ");
INSERT INTO bdd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Tuta Yoni ꞌina ꞌabihebabitaiso ꞌoinega ma nige, tomota sitohotoho waiwai ma ꞌabehega Yehoba ꞌina ꞌebeloina ꞌoina siluhu, ma tohewaiwaiyedi taudi ꞌidi waiwaiyega siluhu. ");
INSERT INTO bdd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mwalo palopitao mabwaiyadi ꞌidi gwaeyao ma Mosese ꞌina loina ꞌoidiyega gwae hemisa sigwae nugeta eeta ꞌana laba Yoni ꞌitauyama. ");
INSERT INTO bdd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma ꞌeguma nuwanuwami ma wanuwasabwalena Yoni weyahina, wada sanapu ꞌabehega tauna tuwa Ilaitiyaina weyahina wayamwayamwa. ");
INSERT INTO bdd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Coinega ꞌeguma taiya matenana gwae bewa ꞌihesagohedi. ");
INSERT INTO bdd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Comi boda ꞌehaumi togidega yagwae hegehegedi ꞌesa weyahimi? Nuwana yagwae ꞌomi gide tuwa gwagwama ꞌebe maketi ꞌalona siꞌeꞌeheyaheyale, ma ꞌiyadiyao ꞌoidiya sibwaubwau sigwae, ");
INSERT INTO bdd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ciyamayao, togidega ꞌiya ta ꞌalahulahusa ma geya wada sobuwa! Ma wete ꞌadou gwaegwae ma geya wada douwa!’ ");
INSERT INTO bdd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Gwae hegehegediyedi ꞌana nuwasabwalena ꞌabehega Yoni ꞌinaoma ma geya ꞌiꞌai ma geya ꞌinuma, ma ꞌoinega wagwae ꞌabehega hiꞌahiꞌa Yoni ꞌiꞌabi hebuweya! ");
INSERT INTO bdd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma taugu Loheyaiguina yanaoma ma yaꞌaiꞌai ma yanumanuma, ma wete weyahigu walolomugi, wagwaegwae, ‘Loheyaina toꞌai ma tonuma hedahedade, ma topui takesi ꞌana toꞌewao ma topui baibaiwadi ꞌiheꞌiyaꞌiyaguwedi.’ “Ma taudi tosanapu moisa ꞌabwa ꞌidi paihowa bwebweꞌadi ꞌoidiyega sanapu moisa ꞌilatulatu.” ");
INSERT INTO bdd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Coinega Yesu ꞌasaedi ꞌina paihowa waiwaidi siꞌiteya, ma geya sinuwabui ꞌidi puiyao ꞌoidiyega, taudi ꞌiheheliyediya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Comi meKolasini ma meBedeseida ꞌatemuyamuyaimi hesi. Weyahina ꞌebe henainaidaedi yapaihowa pwaidiya ꞌoimiya, ma hesi geya wanuwabui. Ma hesi ꞌeguma meTaiya ma meSaidoni ꞌoidiya yada paihowediya, beno mwalo hene sida nuwabuiya, ma sibasibauwa ꞌadi ꞌaleꞌo sida ꞌotedi ma giba ꞌoidiyega sida gibadi ma sida heꞌitaedi ꞌabehega ꞌidi mumuga galadi ꞌoidiyega sinuwabui pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma hesi ꞌomi geya, ꞌoinega yatala ꞌana sabwelo ꞌoina nata Yehoba meTaiya ma meSaidoni ꞌiꞌatemuyemuyedi, ma ꞌomi sahena. ");
INSERT INTO bdd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ma ꞌomi meKapaneumi togidega? Cabehega taumimo waꞌabilagasigomi galewa, ꞌawa? Geya hene! Ma hesi nata Bwebweso ꞌalona siula dobihegomi. Weyahina ꞌebe henainaidaedi yapaihowa pwaidiya ꞌoimiya ma hesi geya wanuwabui, ma mwalo ꞌeguma meSodoma ꞌoidiya yada paihoweya, mwalo hene sida nuwabuiya, ma ꞌane Yehoba sahena ꞌimutumutudi, ma nige ꞌidi ꞌasa ꞌida miyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Coinega yatala ꞌana sabwelo ꞌoina Yehoba nata meSodoma ꞌiꞌatemuyemuyedi, ma ꞌomi sahena.” ");
INSERT INTO bdd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tuta nage ꞌoina Yesu ꞌigwaeya, “Yauwedo Tamagu, ꞌowa galewa ma baleꞌu ꞌadi toloina, sanapu bewa ꞌudahweya tosonogao ma tonuwasabwalenao ꞌoidiyega, ma hesi gwagwama ꞌiꞌiudi ꞌoidiya ꞌuheꞌitaeya. ");
INSERT INTO bdd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moisa Tamagu, ꞌino nuwatuhu bewa ꞌausala.” ");
INSERT INTO bdd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma wete ꞌigwaeya, “Ginaula mabwaiyana Tamagu nimaguwa ꞌilagu pwaidiya ma Tamaguina taboinamo ꞌisanapugauwa, ma taugu wete Tamagu taugumo yasanapuya, ma wete ꞌeguma taiyawedi taudi nuwanuwagu ma Tamagu yaheꞌitae ꞌoidiya, taudi wete sisanapu. ");
INSERT INTO bdd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ma ꞌoinega ꞌomi ꞌimi paihowa mwauna, wanaoma ꞌoiguwa, ma yaꞌabihe ꞌaiyawasigomi. ");
INSERT INTO bdd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma ꞌomi waheꞌauꞌaunawegau ma maꞌiyagwao tapaihowa, ma ꞌoinega yaluyaluwami ꞌidi ꞌaiyawasi siloba, weyahina taugu ꞌigu mumuga nuhana ma tonuwasulu. ");
INSERT INTO bdd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Coinega paihowaedi ma ꞌahaꞌahalaedi yaꞌebwaegomi meyameyahana.” ");
INSERT INTO bdd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabatiya Yesu maꞌana tomuliyao tanoha ꞌalonega sitauya, ta tomuliyaowedi sigomaleya, ꞌoinega witi huwaina siꞌabilolodiya ma siꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma tutaina Palisiyao siꞌitediya, Yesu sihegwaeya, sigwae, “Bada, togidega ma ꞌoinega ꞌa tomuliyao Sabati ꞌana loina siligeligehi?” ");
INSERT INTO bdd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Coinega Yesu ꞌidi gwae ꞌihemaiseya, ꞌigwae, “Buki Heꞌasisi ꞌoina sileleya Debida weyahina, ꞌeguma wahasili wasanapu ꞌabehega Debidaina maꞌiyanao sigomaleya, ");
INSERT INTO bdd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ta Yehoba ꞌina hada ꞌiluhuwa ma beledi heheꞌasisina ꞌiꞌeweya ta siꞌaiya. Belediina maꞌana loina, ꞌabehega topwaolimo ꞌadi tagwala ma siꞌai, ma hesi sigomaleya ta ꞌoinega tuwa siꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Buki Heꞌasisi ꞌalona loina wete ꞌimiyamiya ꞌabehega Hada Heꞌasisi ꞌana topwaoliyao Sabati ꞌana loina siligehi, ma beno geya pui. ");
INSERT INTO bdd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Moisa Hada Heꞌasisi ginaula madouna, ma hesi ꞌaigeda ginaula madou hedade bewa. ");
INSERT INTO bdd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yehoba ꞌina gwae ꞌabehega, ‘Pwaoli geya nuwagu, ma ꞌatemuyamuya hesi.’ Ceguma gwae bewa ꞌana sanapu wasanapu, sahena ꞌagu tomuliyao waꞌahwaꞌahwa galagalaedi, weyahina geya sipui. ");
INSERT INTO bdd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Weyahina Sabati ꞌana toloina loheyaiguina taugu tuwa.” ");
INSERT INTO bdd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nage ꞌoinega Yesu ꞌitauya, ma ꞌidi Hada tapwalolo ꞌoina ꞌiluhuwa. ");
INSERT INTO bdd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta nobwa ꞌaigeda loheya nima meyomeyona, ꞌoinega Palisiyao Yesu ꞌoina sihesilala, sigwaeya, “Bada, togidega, sawasawahina ma Sabati ꞌoina tolohala taꞌabihe bwebweꞌanidi?” Ma ꞌidi hesilalaina weyahina beno ꞌeguma Yesu ꞌigwae pui, eema siheꞌewa toloina matana. ");
INSERT INTO bdd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma ꞌidi gwae Yesu ꞌihemaiseya, ꞌigwae, “Togidega ꞌomi ꞌeguma ꞌaigeda maꞌina sipi ꞌaigeda tuwamo, ma sabwelo Sabati ꞌoina gaula ꞌalona ꞌibeꞌu, ꞌilobwaineya ma ꞌilisi hanehe? ");
INSERT INTO bdd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Moisa sipi ginaula ꞌiꞌiuna, ma tomota hesi ginaula madouna. Coinega sawasawahina ma paihowa bwebweꞌadi Sabatiya tapaihowadi.” ");
INSERT INTO bdd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Coinega Yesu loheyaina ꞌihegwaeya, ꞌigwae, “Nimau ꞌuyasi.” Ta loheyaina nimana ꞌiyasiya ma ꞌibwebweꞌana hila, gide wete hali nimana. ");
INSERT INTO bdd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma hesi Palisiyao maꞌadi gamwasowala silatuwa ma taudimo siloina togidega Yesu siloheꞌamasi ꞌese. ");
INSERT INTO bdd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Taudi ꞌidi loina ꞌwaihina Yesu ꞌisanapu pwaiya, ꞌoinega tupwa nage ꞌiꞌebesineya ma ꞌitauya hali tupwa, ma tomota mabwaiyadi simuliyeya, ta nage ꞌoina tolohala mabwaiyadi ꞌiꞌabihe bwebweꞌanediya, ");
INSERT INTO bdd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ma wete ꞌihegwaediya ma ꞌabehega sahena sihehepwaila dadane tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cina paihowaina bewa mwalo palopita Aiseya Yehoba ꞌina gwae ꞌihepwaila nugeteya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Waꞌita ꞌigu topaihowa bewa hesihesinuwaina, ma ꞌateguwega yahelauweya maꞌigu yaliyaya. Yaluyaluwagu yalagu ꞌoina ma loina dumwaludi ꞌihepwailedi taudi ganamuli ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tauna nata geya ꞌiheheꞌoheꞌohe bo ꞌihehebwaubwau bo ꞌasa ꞌalona ꞌigwaegwae ꞌasona. ");
INSERT INTO bdd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Digona lasalasana sahena ꞌilologwahate. Ma wete wodam butabutana sahena ꞌiuleule, ta ꞌana siga tauna ꞌoinega loina dumwaluna ꞌihewaiwai, ");
INSERT INTO bdd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ma ꞌane tauna saninega tomiya ganamuli sihemise.” ");
INSERT INTO bdd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Caigeda loheya, mwalo welabana ꞌidi paihowega matana sigibuwa, ma wete memenana ꞌibuiya, ꞌoinega siꞌeweyama Yesu ꞌoina ta ꞌiꞌabihe bwebweꞌaniya, ma sawasawahina ꞌigwae ma ꞌiꞌebubuna. ");
INSERT INTO bdd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Coinega tomota mabwaiyadi nuwadi ꞌihenainaida ma sigwae, “Bewa Toꞌabihetenaina, Debida ꞌina susuwega, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma hesi Palisiyao paihowa bewa wasana sihesagoheya ma sigwae, “Geya, ma hesi welabanao ꞌiyadi sanina Tomudulele ꞌina waiwaiyega hiꞌahiꞌa ꞌiula latuhediya.” ");
INSERT INTO bdd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma Yesu ꞌidi nuwatuhu ꞌisanapu pwaiya ta ꞌihegwaediya, ꞌigwae, “Tomudulele tauna ꞌiyanao geya sowana ꞌiulaula latuwedi.” Ma wete ꞌigwae, “Ceguma ꞌaigeda ꞌebeloina ꞌoina tomota siwataha ma siboidimo siloloꞌaleha, ꞌabwa ꞌebeloinaina ꞌiweꞌa ma ꞌibeꞌu. Casa bo susu wete gide ꞌeguma ꞌalodiya wataha ꞌilatu, ꞌabwa siweꞌa ma sibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Seitani wete gide, ꞌeguma maꞌina bodao siboidimo siloꞌaleha, nata ꞌina ꞌebeloinaina ꞌibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wagwae pwaiya ꞌabehega taugu Tomudulele ꞌina waiwaiyega hiꞌahiꞌa yaula latuwediya, ma taiya hede ꞌina waiwaiyega ꞌomi waulaula latuwedi? Tomudulele ꞌoinega, bo Yehoba ꞌoinega? Bewa weyahina wanuwanuwatuhu ma wasanapu ꞌabehega taiya taugu. ");
INSERT INTO bdd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Ma taugu hesi Yehoba Yaluyaluwana ꞌina waiwaiyega hiꞌahiꞌa yaula latuwediya, ꞌoinega wasanapu ꞌabehega Yehoba ꞌina loina ꞌilatu pwaima ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Cebeꞌita bewa loheya waiwaina gide Seitani ꞌina hada. Geya sawasawahina ꞌaigeda taiya ꞌiluhu ma ꞌina tobwatobwa ꞌilohetuwe, ma hesi ꞌeguma ꞌaigeda loheya balaeyega tohewaiwaiina nimana ma ꞌahena ꞌipai nugetedi, ma ꞌoinega muliyetega sawasawahina ꞌiluhu ꞌina hada ma tobwatobwaedi ꞌilohetuwe. ");
INSERT INTO bdd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ceguma taiyawedi taudi geya ꞌagu toꞌabihetenao, taudi ꞌagu ꞌalehao. Ma wete taudi taiyawedi geya baꞌidagwao ꞌada paihowa hegogona, taudi ꞌigu paihowa siꞌabiꞌabi hegala. ");
INSERT INTO bdd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Coinega bewa yahegwae bwaibwainigomi ꞌabehega tomota ꞌidi puiyao ma ꞌidi gwae galadi mabwaiyana Yehoba ꞌinuwasamudi. Beno namo ꞌeguma Yaluyaluwa Tabuna siꞌahwa galegale, geya sowana Yehoba ꞌinuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Ma ꞌeguma taiya ꞌiꞌahwa galegalegau taugu Loheyaiguina, Yehoba nata gwaeina ꞌinuwasam, ma ꞌeguma taiya Yaluyaluwa Tabuna ꞌiꞌahwa galegale gesowana Yehoba ꞌinuwanuwasam, tuta bewa ꞌoina, ma tuta sinaonaoma ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu wete ꞌihegwaediya, “Caiwe ꞌeguma ꞌausalana, huwaina wete ꞌausalana. Ma ꞌeguma ꞌaiwe galana, huwaina wete galana. Weyahina ꞌaiwe ꞌaigeda ꞌaigeda huwaidi ꞌoidiyega tasanasanapudi ꞌabehega ꞌaiwedi ꞌausaladi bo galadi. ");
INSERT INTO bdd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Comi tuwa mwata natunao, ꞌoinega geya sawasawahina ma gwae ꞌausaladi waꞌinanadi, weyahina mabwaiyami togala, ma wete ꞌimi nuwatuhuwao toꞌaha gide ꞌatemiya simiyamiya, tuta mabwaiyana ꞌahwamiyega silatulatuma. ");
INSERT INTO bdd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Weyahina loheya ꞌausalana ꞌatenega ginaula ꞌausaladi ꞌipaihowa, ma hesi loheya galana ꞌatenega ginaula galadi ꞌipaipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Coinega yahegwaegomi ꞌabehega sabwelo yatala ꞌoina ꞌomi ꞌimi gwae bwagabwaga mabwaiyadi weyahidi Yehoba ꞌihesilalegomi, ma huhuna wahepwaile latuwedi. ");
INSERT INTO bdd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Ma ꞌowa ꞌino gwaeyao tuwa ꞌoidiyega Yehoba ꞌiꞌahwa bwebweꞌanego, bo nuwana ꞌiꞌahwa galegalego.” ");
INSERT INTO bdd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eeta loina ꞌana toheꞌitao ma tupwadi Palisiyao Yesu sihegwaeya, sigwae, “Toheꞌita, nuwanuwama ma ꞌilaꞌilala ꞌaigeda ꞌupaihowa ma ꞌaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yesu ꞌihegwaediya, “Comi tomota ꞌehaumi galami ma ganawala huhumi, beno huhuna ꞌilaꞌilala waꞌebeꞌebesa ma ꞌabehega ꞌoidiyega wasanapu bwaibwainigau ꞌabehega Yehoba ꞌoinega yanaoma, ma hesi sahena ꞌilaꞌilalaedi waꞌitaꞌita. Beno namo palopita Yona weyahina wanuwatuhuyahi, tauna tuwa ꞌilaꞌilala weyahimi. ");
INSERT INTO bdd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Weyahina tauna Yonaina sabwelo ꞌetoi ma nihuwana ꞌetoi ꞌoidiya silahana madouna gamwana ꞌimiyamiya, ꞌabwa taugu Loheyaiguina wete gide sabwelo ꞌetoi ma nihuwana ꞌetoi ꞌoidiya baleꞌu ꞌalona yamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Cabwa sabwelo yatala ꞌoina nata meNinibe sitoholo ma mehau ꞌomi siheꞌewegomi, weyahina Yona ꞌoidiya ꞌilohatotowa ma Ninibeyedi ꞌidi mumuga galana ꞌoidiyega sinuwabuiya, ma ꞌomi tuta bewa lohatoto ꞌausala hedade wahesagoha pwaiya ma geya wada nuwabuiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wete gide kuini mwalo yalasi ꞌoinega ꞌinaoma Solomoni ꞌina gwae sonosonogadi sabi hesagohedi, ma ꞌabwa sabwelo yatala ꞌoina kuiniina ꞌitoholo ma mehau ꞌomi ꞌiheꞌewegomi, weyahina tauna bwagebwagega ꞌinaoma Solomoni ꞌina gwae sonosonogadi sabi hesagohedi, ta sauga bewa gwae sonosonoga hedadedi wahesagohediya ma ꞌomi geya wada nuwabuiya. ");
INSERT INTO bdd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ceguma hiꞌahiꞌa loheya ꞌaigeda ꞌoinega ꞌilatu, loheya ꞌibwebweꞌana, ma hiꞌahiꞌaina nata tuwa ꞌatamana ꞌiyawayawala bwagabwaga ma ꞌina ꞌebe ꞌaiyawasi ꞌiꞌebeꞌebesa ma geya ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Coinega hiꞌahiꞌaina ꞌiboinamo ꞌoina ꞌigwae, ‘Nuwana yalohihila ꞌigu ꞌebemiya nugenugetana ꞌoina.’ Eeta ꞌihila ta ꞌebemiyaina ꞌilobeya hadenamo seꞌiseꞌilina ma ꞌatuꞌatububuna. ");
INSERT INTO bdd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Coinega ꞌitauya ma hiꞌahiꞌa site sebeni wete ꞌitoedima ta baꞌidanao siluhuwa ꞌebemiyaina ꞌoina, ta nobwa baꞌidanao simiyamiya. Eeta loheyaina ꞌina miya siꞌabihegala bwaibwainiya, mwalo geya gide. Mehau ꞌomi wete gide togala ma ꞌimi ꞌebe losaloha gala hedade.” ");
INSERT INTO bdd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ꞌabwa boda ꞌoidiya ꞌihehegwaegwae, ma sinana ma tasinao sinaoma, ma ꞌatamana sitotoholo, ma siꞌebeꞌebesa togidega ma ꞌoina sigwae. ");
INSERT INTO bdd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Coinega ꞌaigeda loheya wasadi ꞌiꞌeweyama Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ta Yesu loheyaina ꞌina gwae ꞌihemaiseya, ꞌigwae, “Taiya hede sinagu, ma taiyawedi tasigwao?” ");
INSERT INTO bdd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Coinega ꞌana tomuliyao ꞌoidiya ꞌilonimasusuwa ma ꞌigwae, “Bewa taudi sinagu ma tasigwao. ");
INSERT INTO bdd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Weyahina ꞌeguma taiyawedi Tamagu galewa ꞌina nuwatuhu simulimuliye, taudi tasigwao, nuwana nuhugwao, nuwana sinagwao.” ");
INSERT INTO bdd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nage sabweloina ꞌoina Yesu hadaina ꞌoinega ꞌilatuwa, ma ꞌidobi holai ꞌimiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma boda madouna siꞌautama ꞌoina, ta ꞌaigeda waga ꞌiꞌahaꞌahai ꞌoina ꞌigeluwa, ꞌimiyatoiya, ma boda ꞌoyaꞌoya sitotoholo. ");
INSERT INTO bdd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma heꞌita baibaiwana ꞌiꞌebwaediya gwae hegehegediyega, ꞌigwaeya, “Toꞌabitanoha ꞌaigeda ꞌina tanoha ꞌitauya, ma witi patuna ꞌisaweyaneya, ");
INSERT INTO bdd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ta tupwana patuwedi sibeꞌuwa ꞌedai, ma ꞌoinega bwasumo siꞌitediya, sisuluwa ta siꞌaidiya. ");
INSERT INTO bdd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma tupwana patu baleꞌu lodaꞌudaꞌuleina ꞌoina sibeꞌuwa, ma muliyetega sibwala mwayamwayauwa, weyahina baleꞌu ꞌiꞌiuna tuwa, ");
INSERT INTO bdd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ꞌoinega hala ꞌibwahalidiya ta siwelaiya, weyahina lamudi geya baleꞌu gogaina siloba. ");
INSERT INTO bdd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Ma tupwana patu talitali ꞌoidiya sibeꞌuwa ma sibwala mahemahetena, ma talitaliyaedi ꞌihewaiwaiya, ta ꞌisahila heꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma tupwana patu baleꞌu ꞌausalana ꞌoina sibeꞌuwa, ta sibwalama ta simadouwa ma sihuwa, ꞌoinega patu huwadi ꞌadi baibaiwa handeledi, ma tupwana sikisiti, ma wete tupwana teti. ");
INSERT INTO bdd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Ceguma matenami gwae bewa wahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ta ꞌana tomuliyao silatuma ta Yesu sihegwaeya, sigwae, “Toꞌaha weyahina gwae hegehegediyedi bodaedi ꞌoidiya ꞌuheꞌita?” ");
INSERT INTO bdd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma Yesu ꞌigwaeya, “Comi Yehoba ꞌoimiya ꞌitagwala pwaiya ma ꞌina loina ꞌalona ꞌana tosanapuwao, ma bodaedi geya. ");
INSERT INTO bdd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ceguma taiyawedi gide maꞌidi sanapu, nata loheposeyana madou hedade siloba, ma hesi ꞌeguma taiyawedi geya ꞌidi sanapumo ma toꞌaha nuwana ꞌoidiya ꞌimiyamiya nata mabwaiyana siloheꞌwaihi. ");
INSERT INTO bdd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bewa huhuna gwae hegehegediyega yaheꞌita ꞌoidiya, weyahina ꞌidi ꞌebubuna ꞌoidiyega geya siꞌita bwaibwaini, ma wete ꞌidi hesagoha ꞌoidiyega geya sisanapu. ");
INSERT INTO bdd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tomotaedi weyahidi mwalo Aiseya ꞌihepwaila nugeta, ꞌigwae, ‘Cabwa wahehesagoha ma sahena nuwami ꞌisabwasabwalena. Ma wete waꞌeꞌebubuna tuwa ma hesi geya waꞌita. ");
INSERT INTO bdd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Weyahina tomotaedi ꞌidi nuwatuhuwao siꞌeloꞌwaniya, ma tenadi ꞌituiya, ta wete matadi ꞌigibuwa. Tabu ta matadiyega siꞌita, ma tenadiyega sihesagoha ma sinuwasabwalena, ta ꞌoiguwa siꞌita hila, ma yaꞌabi hebwebweꞌanedi.’ ");
INSERT INTO bdd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ma ꞌomi maꞌimi yaliyaya, weyahina matamiyega waꞌitaꞌita ma tenamiyega wahehesagoha. ");
INSERT INTO bdd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Moisa, ginaula bewa waꞌebubudi ta wahesagohedi mwalo palopitao ma todumwaluwao nuwanuwadi madouna ma siꞌitadi bo sihesagohedi, ta geya silobadi. ");
INSERT INTO bdd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Coinega patu ꞌana saweyana ꞌana sanapu wahesagohe. ");
INSERT INTO bdd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ceguma taiya Yehoba ꞌina loina tetelina ꞌihesagoheyamo, ma geya ꞌinuwasabwalena, ꞌabwa togalaina ꞌinaoma ma gwaeyedi loheya ꞌatenega ꞌiꞌewayahuledi. Beno patuwedi sibeꞌuwa ꞌedai ꞌadi sanapu. ");
INSERT INTO bdd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ma wete patuwedi baleꞌu lodaꞌudaꞌuleina ꞌoina sibeꞌuwa, taudi tetela bwebweꞌana sihesagoheya, ma maꞌidi yaliyaya sitagwala, ");
INSERT INTO bdd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ma geya lamudi ꞌipaꞌala, ꞌoinega tuta ꞌiꞌiuna tuwa ꞌoina simiyamiya, ma ꞌeguma to tuta ꞌoina tetela bwebweꞌana ꞌana hemisa weyahina mwau nuwana hegamwagamwagu siloba sibeꞌu mwayamwayau. ");
INSERT INTO bdd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ma patuwedi talitali ꞌoidiya sibeꞌuwa, taudi tetela bwebweꞌana sihesagoheya, ma hesi ꞌidi nuwatuhu baleꞌu weyahina ma wete wasawasa ꞌana nuwatuhuwao, ma nuwatuhuwedi tetela bwebweꞌana siloheꞌamasiya, ta geya sawasawahina ma sihuwa. ");
INSERT INTO bdd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ma patuwedi baleꞌu ꞌausalana ꞌoina sibeꞌuwa, taudi tetela bwebweꞌana sihesagoheya, ma ꞌana nuwasabwalena ꞌoidiya ꞌimiyamiya, ta huwaidi ꞌausala silagudiya. Tupwadi huwaidiyao handeledi, ma tupwadi sikisiti, ma tupwana teti.” ");
INSERT INTO bdd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gwae hegehegedi ꞌaigeda wete Yesu ꞌiꞌebwaediya, ꞌigwae, “Yehoba ꞌina loina gide tuwa ꞌaigeda loheya witi patuna bwebweꞌadi ꞌina tanoha ꞌisaweyanediya. ");
INSERT INTO bdd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma nihuwana siꞌeno sinediya, ma ꞌana ꞌaleha ꞌaigeda ꞌinaoma tanoha, ta ꞌawata ꞌana ꞌita gide witi wete ꞌisaweyaneya witi moisa ꞌalona, ma muliyetega ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Coinega mabwaiyadi sibwala ta sihuwa, ma badaina ꞌina topaihowao ꞌawataedi siꞌita lobediya. ");
INSERT INTO bdd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma topaihowaedi sinaoma ta sihegwaeya, ‘Bada, patu ꞌausalana ꞌino tanoha mwalo ꞌusaweyaneya, ma togidega ta ꞌoinega ꞌawata baꞌidanao sibwala mahemahetena?’ ");
INSERT INTO bdd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ma tanoha taniwagana ꞌigwaeya, ‘Nuwana ꞌagu ꞌaleha ꞌaigeda ꞌisaweyaneya.’ Coinega ꞌina topaihowao sigwaeya, ‘Togidega? Sawasawahina ma ꞌawataedi ꞌadabu yahuledi?’ ");
INSERT INTO bdd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ma badaina ꞌigwaeya, ‘Tuwa! Walaguyawa, ma sibwala mahetena, weyahina ꞌeguma watoho ꞌawasina wadabu yahuledi, nuwana tupwana witi wete mahetenao wadabu ꞌaigededi. ");
INSERT INTO bdd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma tuta ꞌeliꞌeli hesi ꞌoina topaihowao yahegwaedi ma ꞌawasina sidomwaꞌautedi nugeta ta siꞌuinidi, ta ꞌoinega sigabu yahuledi, ma witi sidomwaꞌautedi ta ꞌigu hada ꞌeꞌahaiya sihedodo.’” ");
INSERT INTO bdd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Caigeda wete gwae hegehegedi ꞌiꞌebwaediya, ꞌigwae, “Yehoba ꞌina loina gide tuwa seyala patuna ꞌaigeda loheya ꞌiꞌeweya ma tanoha ꞌidauniya. ");
INSERT INTO bdd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Seyala patuna ꞌiꞌiuna tuwa ma ꞌina bwala mulina ꞌimadou gide ꞌaiwe, ma ꞌoinega bwasumowao sinaoma ta lahalahanao ꞌoidiya ꞌidi nehwa siꞌabidiya.” ");
INSERT INTO bdd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Caigeda wete gwae hegehegedi ꞌiꞌebwaediya, ꞌigwae, “Yehoba ꞌina loina gide tuwa pwalawa ꞌana ꞌebe ꞌabiheseseha. Wahine ꞌiꞌeweya ꞌiꞌiuna tuwa ta pwalawa madouna baꞌidana ꞌihebweliyeya, ꞌoinega mabwaiyana ꞌiseseha.” ");
INSERT INTO bdd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ꞌina gwaeyedi gwae hegehegedi mabwaiyadi ꞌoidiyega boda ꞌiheꞌitediya, weyahina tauna tuta mabwaiyana gwae hegehegediyega ꞌiheheꞌita tomota mabwaiyadi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bewa ꞌoinega palopita ꞌina gwae ꞌilatuwa, beno mwalo hene ꞌihepwaila nugeteya, ꞌigwae, “Gwae hegehegediyega yahepwaila, ma yagwaene toꞌaha Yehoba ꞌidahweya baleꞌu ꞌana paihowa hauhau ꞌoinega ma nige.” ");
INSERT INTO bdd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ma Yesu boda ꞌiꞌebesinediya ma ꞌiluhuwa hadai, ma ꞌana tomuliyao sinaoma ta ꞌoina sigwaeya, “Gwae hegehegedi ꞌawata tanoha ꞌoina ꞌana nuwasabwalena ꞌulihasi, ma ꞌasanapu.” ");
INSERT INTO bdd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Coinega Yesu ꞌigwae, “Witi patuna ꞌana tosaweyana taugu Loheyaiguina, ");
INSERT INTO bdd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ma tanoha beno baleꞌu mabwaiyana, ma witi beno taudi Yehoba ꞌina loina ꞌana tomuliyao, ma ꞌawata beno togalanaina ꞌana topaihowao, ");
INSERT INTO bdd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ma ꞌawata ꞌana tosaweyana beno tauna Seitani, ma tuta ꞌeliꞌeli beno tuta ꞌana ꞌebelosaloha, ma toꞌeliꞌeli taudi anelose, ");
INSERT INTO bdd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ma tuta ꞌana ꞌebelosaloha ꞌoina togala taudi tuwa gide ꞌawata sihegogonedi ma sigabu yahuledi. ");
INSERT INTO bdd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","“Ma taugu Loheyaiguina ꞌigu aneloseyao yahesumanedi ma pui ꞌana toheꞌitao galadiyedi sihegogonedima ma ꞌigu ꞌebeloina ꞌoinega ");
INSERT INTO bdd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","siula latuhedi, ꞌaiwe ꞌalaꞌalasina ꞌalona. Beno tupwaina ꞌoina tomota sidou ma sihesalaꞌiꞌita muyamuya ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Ma muliyetega tobwebweꞌadi Tamadiu ꞌina ꞌebeloina ꞌalona siꞌasilala gide sinala. “Ceguma taiya matenana gwae bewa ꞌihesagohe. ");
INSERT INTO bdd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yehoba ꞌina loina gide tuwa wasawasa goula ma mane madouna, mwalo baleꞌu ꞌaigeda ꞌoina sidahweya, ma ꞌaigeda loheya ꞌilobeya, ta ꞌidahwa hileya, ma maꞌina yaliyaya ꞌitauya, ma ꞌina tobwatobwa mabwaiyadi ꞌihegimwaneyediya, ma ꞌadi maisao ꞌiꞌeweya ta baleꞌuina ꞌigimwaneya. ");
INSERT INTO bdd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma wete Yehoba ꞌina loina tuwa gide toꞌahwaꞌune ꞌaigeda, mwali ꞌausala nuwanuwana. ");
INSERT INTO bdd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Coinega ꞌaigeda mwali ꞌausala hedade ꞌilobeya, ta ꞌoinega tauna ꞌina bagi mabwaiyadi ꞌiulediya ma ꞌabehega mwaliina ꞌausala hedade ꞌiꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ma wete Yehoba ꞌina loina gide tuwa gomana tomota siyahuweya holai, ma hali silahana ma hali silahana siꞌonediya, ");
INSERT INTO bdd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ta gomanaina ꞌimaha ꞌapuꞌapuwa ma silisiya ꞌoyaꞌoya, ma simiyatoiya, ma silahana mabwaiyadi siwatahiya, ta silahana ꞌausaladi gaeba ꞌoidiya silagudiya, ma silahana galadi siulediya. ");
INSERT INTO bdd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Gide wete, tuta ꞌana ꞌebelosaloha ꞌoina, aneloseyao sinaoma ma togala siwatahidi tobwebweꞌana ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ma siula latuwedi ꞌaiwe ꞌalaꞌalasina ꞌalona, ma ꞌoina sidou ma sihesalaꞌiꞌita muyamuya ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Coinega Yesu ꞌihesilala ꞌoidiya, ꞌigwae, “Togidega gwae hegehegediyedi mabwaiyadi wasanapudiya?” Ma sihesagoha ma siꞌahwa moisa, sigwae, “Cehe.” ");
INSERT INTO bdd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma ꞌihegwaediya, “Bewa tuwa wasanapu ꞌabehega loina ꞌana toheꞌitao ꞌeguma Yehoba ꞌina loina simanasama pwaiya, taudi gide tuwa ꞌaigeda hada toniwagana ꞌina tobwatobwa tupwadi miyamiyadi ma tupwadi ꞌehaudi ta mabwaiyadi ꞌalodiya wasawasa ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu ꞌina gwae hegehegediyedi ꞌilosalohidiya, ma tupwa nage ꞌiꞌebesinediya, ");
INSERT INTO bdd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma ꞌihila ꞌina ꞌasa, ma ꞌidi Hada tapwalolo ꞌoina ꞌiluhuwa ma ꞌiheꞌitediya, ma tomota nuwadi ꞌihenainaida ta sigwaeya, “Loheya bewa taꞌehega ꞌoinega ꞌina sanapu ma ꞌina paihowa waiwaidi ꞌiꞌewaꞌewadi?” ");
INSERT INTO bdd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma wete sigwae, “Nuwana loheya bewa toꞌabiꞌabi hada natuna? Ma sinana Meli, ma tasinao Yemesa ma Yosepa ma Saimoni ma Yudasa, ");
INSERT INTO bdd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ma wete nuhunao mahetedao tamiyamiya. Ma togidega hede ta loheya bewa ꞌisanapu hedada?” ");
INSERT INTO bdd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Coinega silogwahateya. Ma Yesu ꞌihegwaediya, ꞌigwae, “Palopitao ꞌadi heꞌasisi silobaloba hali ꞌasa ꞌoidiya. Ma taudi ꞌidi ꞌasa, bo ꞌidi hada, geya ꞌadi heꞌasisimo.” ");
INSERT INTO bdd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eema Yesu nobwa ꞌina paihowa waiwaidi geya baibaiwadi ꞌipaihowadi, weyahina geya sihemisae. ");
INSERT INTO bdd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tuta nage ꞌoina Helodi, tauna Galili ꞌana toloina, Yesu ꞌina paihowa wasana ꞌihesagoheya, ");
INSERT INTO bdd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ta ꞌina topaihowao ꞌihegwaediya, ꞌigwae, “Beno loheyaina tauna Yoni toꞌabihebabitaiso, ꞌabehega ꞌamasega ꞌitoholo hila pwaiya, ma ꞌoinega maꞌina waiwai ꞌipaipaihowa.” ");
INSERT INTO bdd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Weyahina mwalo Helodi Yoni ꞌiꞌabiyahiya, ma ꞌipaiya, ma deliya ꞌilaguya. Ma Yoni ꞌana ꞌabiyahina huhuna beno ꞌaigeda wahine sanina Helodiyasa, beno Helodi tasina Pilipi mwanena, ");
INSERT INTO bdd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ma Helodi ꞌiꞌwayeya ta ꞌihaiya, ma Yoni Helodi ꞌihegwaeya ꞌigwae, “Nage geya mumuga ꞌausalana, weyahina tasiu mwanena ꞌuhaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Beno huhuna Helodi nuwanuwana ma Yoni ꞌiloheꞌamasi, ma hesi tomota mabwaiyadi siꞌahwa palopitaeya, ꞌoinega Helodi ꞌimatauta ma geya Yoni ꞌiloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Muliyetega Helodi ꞌina sabwelo liꞌu ꞌana ꞌebe nuwatuhu yahina guyaina ꞌoina boda siꞌautama, ma Helodiyasa natuna wahinena boda matadiya ꞌisobusobu, ma Helodi ꞌiꞌabihe yaliyayeya. ");
INSERT INTO bdd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma Helodi gumalaulauina ꞌoina ꞌigwae helauwa ma ꞌabehega ꞌeguma toꞌaha nuwanuwana ꞌiꞌebwae tuwa, ma wete ꞌigwae hemisa. ");
INSERT INTO bdd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Coinega sinana ꞌigwae gumalaulauina ꞌoina, ma gumalaulauina Helodi ꞌihegwaeya, ꞌigwae, “Nuwanuwagu Yoni toꞌabihebabitaiso mwaguna gaeba ꞌoina ꞌulagu ma ꞌuꞌebwaegau.” ");
INSERT INTO bdd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Coinega Helodi ꞌinuwagala madouna, ma hesi ꞌina gwae hemisa ꞌinuwatuhu yahiya, ta boda ꞌina hegwaegwae sihesagoha pwaiya, ꞌoinega ꞌitagwala, ");
INSERT INTO bdd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ta ꞌina topaihowao deliya ꞌihesumanediya, ma Yoni taniꞌona siꞌupweya, ");
INSERT INTO bdd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ma mwaguna gaeba ꞌoina sidoꞌoya ta siꞌeweyama, ta gumalaulau siꞌebwaeya. Ma gumalaulauina ꞌiꞌeweya, ꞌitauyeya sinana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ma Yoni ꞌana tomuliyao sinaoma, ta Yoni wahina siꞌeweya, ta silaguya galiha, ma muliyetega sitauya Yesu ꞌoina, ta ginaula bewa sihepwaileya. ");
INSERT INTO bdd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta Yesu tetelaina bewa ꞌihesagohediya, ꞌoinega ꞌilatuwa ta wagai ꞌigeluwa, ꞌitauya tupwa yoho ꞌawawa. Ma boda Yesu tetelina sihesagoheya, ta ꞌidi ꞌasa ꞌoidiyega silatuwa, ma ꞌedega sitauya Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma tutaina Yesu wagega ꞌiulasuluwa ꞌoyaꞌoya boda madouna ꞌiꞌitediya, ta ꞌina ꞌatemuyemuyega tolohalao ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma lahilahiya ꞌana tomuliyao sinaoma ta Yesu sihegwaeya, sigwae, “Bada, tupwa bewa balabala ꞌawawa, ma nata ꞌiboi. Coinega boda bewa ꞌuhesumanedi ma sihila, ma ꞌadi sigimwane ꞌasa deidiya ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ta Yesu ꞌigwaeya, “Sahena sitautauya, ma ꞌomi hesi ꞌeꞌahai waꞌebwaedi ma siꞌai.” ");
INSERT INTO bdd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma taudi sigwae, “Ya! Cama geya baibaiwana, beno namo beledi nima ꞌaiꞌaigeda ma silahana ꞌeluwa.” ");
INSERT INTO bdd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta Yesu ꞌigwaeya, “Beledi ma silahanaedi waꞌebwaegau.” ");
INSERT INTO bdd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Coinega boda ꞌiloinaediya ma modumoduwa simiyatoiya, ma beledi nima ꞌaiꞌaigeda ta silahana ꞌeluwa ꞌiꞌewediya, ma ꞌiꞌita haneya galewa, ta ꞌeꞌahaiyedi weyahidi ꞌigwae helauwa, ma muliyetega beledi ꞌigimwahisiya, ta ꞌana tomuliyao ꞌiꞌebwaediya, ma taudi tomota ꞌoidiya siheguyaiya. ");
INSERT INTO bdd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ma mabwaiyadi siꞌaiya ta simwausuwa, ma ꞌeꞌahai tupwatupwadi sidomwa ꞌautediya, ma kodo tuwelo silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Toꞌaiyedi loheloheya daisidimo ꞌadi baibaiwa paibi tausani gide, ta wete wahiwahine ma gwagwama geya sihasilidi. ");
INSERT INTO bdd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Coinega ꞌana tomuliyaowedi ꞌiloinaediya, ma wagai sigeluwa ma ꞌabehega sinugeta hali tupwa, ma tauna ꞌabehega tomota mabwaiyadi ꞌihegwaedi ma sihila ꞌidi ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sigeluwa, ma Yesu boda ꞌihewasaediya, ta muliyetega tauna ꞌiboinamo ꞌoyai ꞌihaneya sabi ꞌahwanoi Yehoba ꞌoina, ma ꞌiboiya. Ciboi pwaiya, ma Yesu ꞌiboinamo ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cimiyamiya ta tomuliyaowedi ꞌidi waga siwoseyeya ta sidobi pwaiya niꞌuwa, ma bagodu madouna silobeya ma ꞌidi waga ꞌilolobuibui, ta wete yaumai matadiyega ꞌinaonaoma. ");
INSERT INTO bdd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gona ꞌadaꞌadaleya Yesu hola tabwanega ꞌitautauyama, ma ꞌana tomuliyaowedi deidiya ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cana tomuliyaowedi Yesu siꞌiteya hola pwatanega ꞌinaonaoma, ta simatauta madouna, ꞌoinega siꞌalabwauwa, ꞌidi nuwatuhu ꞌabehega welabana siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Yesu ꞌihegwaediya, “Sahena wamatauta. Taugu tuwa, ꞌimi Cinapwana.” ");
INSERT INTO bdd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Pita ꞌigwaeya, “Bada, ꞌeguma ꞌowa, ꞌuhegwaegau ma hola pwatanega yanaowa ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Yesu ꞌigwae, “Cunaoma.” Coinega Pita wagega ꞌisuluwa ma hola pwatanega ꞌitauya Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Citautauya ma yaumai madouna ꞌiꞌiteya, ma ꞌimatauta, ta holai ꞌidamana, ma ꞌibwauwa, “Bada ꞌuꞌabihetegau!” ");
INSERT INTO bdd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma Yesu ꞌilomwayamwayauwa ma Pita ꞌiꞌabiyahiya, ta ꞌigwae, “Tohemisa ꞌiꞌiuu, toꞌaha weyahina ꞌuhenuwanaluwa?” ");
INSERT INTO bdd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Coinega siteluwa wagai sigeluwa, ma yaumai ꞌiꞌata. ");
INSERT INTO bdd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma taudi waga ꞌana tomiyao siꞌetuluha Yesu ꞌoina, ma sigwae, “Moisa tuwa ꞌowa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eema sihabala tupwa Genesaleta ꞌoina ma sisuluwa ꞌoyaꞌoya. ");
INSERT INTO bdd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sisuluwa ma tupwaina ꞌana tomiyao Yesu siꞌinaneya, ta wasa sihedabalaleya ꞌidi ꞌasa mabwaiyana ꞌoidiya, ma ꞌidi tolohalao mabwaiyadi siꞌewedima Yesu ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ta siꞌahwanoiyeya, sigwae, “Bada, sawasawahina ma tolohalaowedi ꞌa ꞌaleꞌo papalina siꞌabitoho?” Ta Yesu ꞌitagwala, ma taudi ꞌana ꞌaleꞌo siꞌabitohoya sibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Muliyetega Palisiyao ma loina ꞌana toheꞌitao Yelusalemega sitauyama Yesu ꞌoina, ma sihegwaeya sigwae, ");
INSERT INTO bdd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Toꞌaha weyahina ꞌa tomuliyao ꞌeguma muliya ꞌabwa ꞌai geya nimadi sida buyoya, beno tubudao ꞌidi loina siligeligehi?” ");
INSERT INTO bdd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma ꞌihegwaediya, “Comi wete Yehoba ꞌina loina waligeligehi, weyahina tubumiyao ꞌidi mumuga wamulimuliyedi. ");
INSERT INTO bdd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yehoba ꞌina loina ꞌeluwa bewa, ꞌaigeda ꞌigwae, ‘Tamau ma sinau ꞌuheꞌasisiyedi.’ Heluwena wete ꞌigwae, ‘Ceguma taiya tamana bo sinana ꞌiꞌahwa galegaledi, sawasawahina waloheꞌamasi.’ ");
INSERT INTO bdd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma ꞌomi ꞌimi heꞌita ꞌaboꞌabo, wagwae, ‘Ceguma taiya tamana ma sinana ꞌihegwaedi, ꞌigwae, “Cigu tobwatobwao yatagwala pwaiyediya Yehoba ꞌoina, ꞌoinega geya sawasawahigu ma yaꞌabihetegomi.” ’ Coinega ꞌimi nuwatuhu ꞌabehega loheyaina ꞌina ꞌabihetena nuwana ꞌina heꞌasisi tamana ꞌoina geya ginaula madouna. ");
INSERT INTO bdd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tubumiyao ꞌidi loinaina ꞌoinega Yehoba ꞌina loina waheginaula besobesoweya. ");
INSERT INTO bdd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Bewa ꞌimi ꞌabo. Mwalo hene Aiseya palopita weyahimi ꞌihepwaila nugeta, tutaina Yehoba ꞌina gwae ꞌihepwaileya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tomota bewa ꞌahwadiyega sihehe ꞌasisiyegau ma geya ꞌatediyega, ");
INSERT INTO bdd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ma wete ꞌoiguwa sitapwatapwalolo besobeso, weyahina ꞌidi heꞌitao taugu geya ꞌoiguwega, ma hesi tomota tuwa ꞌidi nuwatuhuwega.’” ");
INSERT INTO bdd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Coinega tomota ꞌibwauwedima ma ꞌihegwaediya, “Gwae bewa wahesagohe ma wasanapu ꞌabehega ");
INSERT INTO bdd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ꞌeꞌahaiyedi ꞌahwadega siluhuluhu geya sawasawahina ma siꞌabihe biꞌigita, ma hesi gwaeyedi ꞌahwadega silatulatuma taudi hesi siꞌabiꞌabi hebiꞌigita.” ");
INSERT INTO bdd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ma Yesu ꞌana tomuliyao ꞌoina sinaoma ma sihegwaeya, “Bada, ꞌuhesagoheya ꞌabehega Palisiyao ꞌino gwae bewa weyahina sideba mwadina.” ");
INSERT INTO bdd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Yesu ꞌigwaeya, “Caiweyedi Tamagu geya ꞌiꞌumadi, ꞌabwa ꞌidabu yahuledi. ");
INSERT INTO bdd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma tuwa, Palisiyaowedi simiyamiya ꞌana siga sibeꞌu, weyahina taudi tohanugeta matagibugibudi, ma ꞌiyadiyao ꞌeguma matagibugibudi sihanugetedi, nata mabwaiyadi gaula sibeꞌu.” ");
INSERT INTO bdd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Coinega Pita ꞌiꞌahwalagata ma ꞌigwae, “Gwae hegehegedi bewa ꞌana nuwasabwalena ꞌulihasi ꞌoima.” ");
INSERT INTO bdd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta Yesu ꞌigwaeya, “Nuwana ꞌomi wete ꞌabwa nuwami geya ꞌisabwalena, ");
INSERT INTO bdd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Coinega wasanapu ꞌabehega toꞌaha ꞌahwadega ꞌiluhuluhu gamwada ꞌidobidobi, ma muliyetega ꞌitautauya mohomoho ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma hesi toꞌaha tomota ꞌahwadiyega ꞌilatulatuma, beno ꞌatediyega silatulatuma ma siꞌabiꞌabi hebiꞌidi, ");
INSERT INTO bdd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","beno nuwatuhu galadi gide loheꞌamasa ta loyawe ta ganawala ta yagaha ta gwae ꞌaboꞌabo ta gwae sinala wete. ");
INSERT INTO bdd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ginaulaedi bewa ꞌoidiyega tomota ꞌiꞌabiꞌabi hebiꞌidi, ma ꞌeguma nimada sahena tabuyobuyo tuta ꞌai ꞌoina, beno yaluyaluwada geya ꞌiꞌabihebiꞌidi.” ");
INSERT INTO bdd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ma Yesu tupwaina ꞌiꞌebesineya ta ꞌitauya Taiya ma Saidoni tupwaidi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma tupwaina ꞌoinega Kenani wahineina ꞌaigeda ꞌilatuwa, ma Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌowa Debida ꞌina susu, ꞌuꞌatemuyemuyegau, weyahina natugu mewahinena hiꞌahiꞌa ꞌiꞌabihebuweya.” ");
INSERT INTO bdd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma Yesu wahineina ꞌina bwau geya ꞌihemaise, ꞌoinega ꞌana tomuliyao sinaoma ma Yesu siꞌahwanoiyeya, sigwae, “Wahineina ꞌuhesumane ma ꞌitauya, weyahina ꞌibwau hedahedade.” ");
INSERT INTO bdd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma Yesu ꞌigwaeya, “Taugu yanaoma sipi ꞌwaniꞌwanidi Isilelimo ꞌina ꞌebeloina ꞌalona weyahidi.” ");
INSERT INTO bdd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma hesi wahineina ꞌinaoma, ma Yesu matana ꞌiꞌetuluha, ta ꞌigwaeya, “Bada ꞌuꞌabihetegau.” ");
INSERT INTO bdd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta Yesu ꞌigwaeya, “Geya sawasawahina ma gwagwama ꞌadi yaꞌebwae ꞌedewa ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma wahineina ꞌigwaeya, “Bada, beno moisa. Ma togidega ꞌeꞌahai mugumuguna, ꞌeguma sigubagubala bada ꞌina ꞌebeꞌai ꞌoinega, sawasawahina ma ꞌina ꞌedewao siꞌaidi?” ");
INSERT INTO bdd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Coinega Yesu wahineina gwaeina ꞌihemaiseya, ꞌigwae, “Wahine, ꞌowa tuwa tohemisa moisa, ꞌoinega bewa tuwa ꞌino hemisaina huwaina ꞌilatuwa.” Ma tutaina nage ꞌoina wahineina natuna ꞌibwebweꞌana hila. ");
INSERT INTO bdd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ta Yesu tupwaina ꞌiꞌebesineya ma ꞌihasahasane Galili holai, ta ꞌoyai ꞌihaneya, ma nobwa ꞌimiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta boda madouna sihanema ma ꞌidi tolohalao siꞌewedima, taudi tohaꞌauꞌau ta taudi hesilae ꞌoinega siweꞌa, ta taudi tomata gibugibu, ta taudi naꞌonaꞌo, ma tupwadi tolohalao wete Yesu deina sihalagudiya, ma ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma bodaedi siꞌitediya beno naꞌonaꞌowedi sihegwaegwae ma wete sihesagoha bwaibwaini, ma taudi hesilae ꞌoidiyega siweꞌa sibwebweꞌana hila, ma tohaꞌauꞌau sitauya dumwadumwalu, ma tomata gibugibu matadi sitayahala. Coinega bodaedi nuwadi ꞌihenainaida ta meIsileli ꞌidi Yehobaina sihehepwatuwe. ");
INSERT INTO bdd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ta Yesu ꞌana tomuliyao ꞌibwauwedima, ma ꞌihegwaediya, “Boda bewa yaꞌatemuye muyediya, weyahina sabwelo ꞌetoi ꞌebwa mahetegwao ꞌamiyamiya, geya ꞌadimo. Geya nuwagu ma magomaledi yahesumana hiledi, ꞌamuge gide ma ꞌedai sihemwalomwalohana.” ");
INSERT INTO bdd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma ꞌana tomuliyao sihegwaeya sigwae, “Tupwa bewa balabala ꞌawawa, ma togidega boda madouna bewa ꞌadi ꞌeꞌahai taloba ꞌese?” ");
INSERT INTO bdd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ta Yesu ꞌihesilalediya, ꞌigwae, “Hisa ꞌami belediyao?” Ma sigwaeya, “Beledi sebeni ma tupwana silahana ꞌiꞌiudi.” ");
INSERT INTO bdd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Coinega boda ꞌihegwaediya ma baleꞌuwa simiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta beledi sebeni ma silahanaedi ꞌiꞌewediya ma weyahidi ꞌigwae helauwa Yehoba ꞌoina, ma ꞌiꞌehisihisiya, ta ꞌiꞌebwaediya ꞌana tomuliyao ꞌoidiya, ma taudi siheguyaiyeya bodaedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma mabwaiyadi siꞌaiya ma simwausuwa ma muliyetega ꞌeꞌahai tupwatupwadi sidomwa ꞌautediya ta kodo sebeni silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Toꞌaiyedi loheloheyamo ꞌadi baibaiwa powa tausani, ma wete wahiwahine ma gwagwama baibaiwadi geya sihasilidi. ");
INSERT INTO bdd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Muliyetega boda ꞌihesumanediya ma sihila, ma Yesu wagai ꞌigeluwa, ta Magadani tupwaina ꞌoina ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Caigeda tuta ꞌoina tupwadi Palisiyao ma Sadusiyao sinaoma ma Yesu sihesilaleya, sabi tohoina, ma sihegwaeya, “Sawasawahina ma ꞌilaꞌilala ꞌaigeda ꞌupaihowa ma ꞌaꞌahwa moisa ꞌabehega ꞌino waiwai Yehoba ꞌoinega ꞌinaoma?” ");
INSERT INTO bdd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Yesu ꞌigwaeya, “Comi ꞌeguma sinala waꞌita ꞌisopusopu ma galewa tupwa bwauliyega ꞌilobwehabwehali, wasanapuya ꞌabehega gona ꞌisiwaloha bwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma ꞌeguma gonagona galewa belabelalana ma dubadubana waꞌitadi, beno wasanapuya ꞌabehega duba ꞌinaonaoma. Ta beno ꞌilaꞌilalaedi yaloyaloha ꞌoidiya ꞌadi sanapu wasanapu pwaidiya, ma hesi ꞌilaꞌilala bewa tutaedi weyahidi geya wasanapudi. ");
INSERT INTO bdd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mehau ꞌomi galami, ma ganawala huhumi, beno huhuna ꞌilaꞌilala waꞌebeꞌebese ma ꞌoidiyega wasanapu bwaibwainigau ꞌabehega Yehoba ꞌoinega yanaoma. Hesi geyaꞌabwa ꞌilaꞌilalaedi waꞌitaꞌitadi. Beno namo Yona weyahina wanuwatuhuyahi, tauna tuwa ꞌilaꞌilala weyahimi.” Coinega Yesu ꞌiꞌebesinediya ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ta hali tupwa sihabala, ma ꞌana tomuliyaowedi ꞌadi ꞌulaheya geya siꞌewadi, weyahina sinuwanaideya. ");
INSERT INTO bdd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma nobwa Yesu ꞌihegwaediya, “Palisiyao ma Sadusiyao ꞌadi beledi ꞌana ꞌebe ꞌabiheseseha ꞌoinega waꞌita yahigomi.” ");
INSERT INTO bdd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Coinega ꞌana tomuliyaowedi siboidimo ꞌoidiya sigwaeya, “Nuwana Yesu ꞌina gwae huhuna bewa weyahina ꞌada ꞌulaheya tanuwanaideya.” ");
INSERT INTO bdd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Yesu ꞌidi nuwatuhu ꞌisanapu pwaiya, ꞌoinega ꞌihegwaediya, “Toꞌaha weyahina wagwaegwae ꞌabehega geya ꞌami ꞌulaheyamo? Beno geya weyahina yagwae. Geya wahemisa moisa, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","“Geya hede wanuwa sabwalena tutaina beledi nima ꞌaiꞌaigeda ꞌoidiyega tomota paibi tausani yaheꞌaidiya, ma ꞌeꞌahai ꞌana tupwa mabwaiyana wadomwa heꞌauteya, ma ꞌoinega kodo baibaiwadi walohemahediya? ");
INSERT INTO bdd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tomota wete powa tausani beledi sebeni ꞌoidiyega yaheꞌaidiya ma ꞌana tupwa mabwaiyana wadomwa ꞌauteya, ta kodo baibaiwana ꞌoinega walohemahediya? ");
INSERT INTO bdd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Coinega toꞌaha weyahina ta geya wanuwa sabwalena ꞌabehega geya ꞌeꞌahai weyahina yagwaegwae? Ma hesi Palisiyao ma Sadusiyao ꞌidi ꞌebe ꞌabiheseseha ꞌoinega waꞌitayahigomi.” ");
INSERT INTO bdd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tuta nage ꞌoina sisanapuwa ꞌabehega geya beledi moisa ꞌana ꞌebe ꞌabiheseseha weyahina ꞌigwaegwae, ma Palisiyao ta Sadusiyao ꞌidi heꞌitao ꞌoidiyega siꞌitayahidi. ");
INSERT INTO bdd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ma Yesu ꞌinaoma Sisaliya Pilipai ꞌina tupwa ꞌoina, ma ꞌihesilala ꞌana tomuliyao ꞌoidiya, ꞌigwaeya, “Togidega tomota ꞌidi gwae ꞌabehega taugu Loheyaiguina taiya?” ");
INSERT INTO bdd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta sigwaeya, “Tupwana tomota sigwae ꞌabehega ꞌowa Yoni toꞌabihebabitaiso, ma tupwana tomota sigwaeya ꞌabehega ꞌowa Ilaitiya, ma tupwadi sigwaeya ꞌabehega ꞌowa Yelemaiya, bo nuwana ꞌaigeda palopita nugenugetana.” ");
INSERT INTO bdd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta Yesu ꞌihesilalediya, ꞌigwae, “Ma ꞌomi togidega ꞌimi nuwatuhu ꞌabehega taugu taiya?” ");
INSERT INTO bdd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Coinega Saimoni Pita ꞌihemaiseya ꞌigwae. “Cowa Toꞌabihetena, Yehoba mayawasina Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Yesu Pita ꞌihegwaeya, ꞌigwae, “Saimoni, Yona natuna, ꞌowa moisa toyaliyaya ꞌaigeda, weyahina ꞌino sanapu bewa geya tomota ꞌoidiyega, ma hesi Tamagu galewa ꞌina sanapuwega ꞌiꞌebwaegowa. ");
INSERT INTO bdd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma wete yahegwaego ꞌabehega saniu Pita, ta ꞌowa dimwa, ma ꞌoiuwa ꞌigu hekalesiya yaꞌabi, ma ꞌoinega sahena ꞌamasa bo nuwana mumuga galana sihewaiwai sine. ");
INSERT INTO bdd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma wete ꞌebeloina galewa ꞌana ꞌebesoꞌe yaꞌebwaego, ma toꞌaha baleꞌuwa ꞌuꞌausiya, galewa wete siꞌausi, ma wete ꞌeguma toꞌaha baleꞌuwa ꞌusoꞌe galewa wete sisoꞌe.” ");
INSERT INTO bdd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Eeta Yesu ꞌana tomuliyao ꞌiloina paꞌalediya, ꞌigwae, “Sahena ꞌaigeda taiya ꞌoina wahehepwailegau ꞌabehega taugu Toꞌabihetenaina.” ");
INSERT INTO bdd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuta nage ꞌoina Yesu ꞌihegaina ma ꞌana tomuliyao ꞌiheꞌitediya, ꞌigwae, “Cilobwaineya ma yatauya Yelusalema, ma nobwa muyamuya baibaiwadi yalobadi, babadao ta topwaoli madoudi ma loina ꞌana toheꞌitao ꞌoidiyega, ma nage ꞌoina siloheꞌamasigau, ma sabwelo hetoina ꞌoina Yehoba ꞌiꞌabihetoholo hilegau.” ");
INSERT INTO bdd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Pita Yesu ꞌitoewasiyeya, ma ꞌiheliyeya, ꞌigwae, “Bada, ginaula bewa sahena ꞌoiuwa ꞌilatulatu!” ");
INSERT INTO bdd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Yesu ꞌitehinowa, ta Pita ꞌoina ꞌigwae, “Cowa Seitani, bewa tuwa ꞌuꞌebesinegau! Sahena ꞌuꞌauꞌausigau! Cino nuwatuhu tomota ꞌidi nuwatuhu, ma geya Yehoba ꞌina nuwatuhu gide.” ");
INSERT INTO bdd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Muliyetega Yesu ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Taiya ꞌeguma nuwanuwana ma ꞌimuliyegau, ꞌilobwaineya ma tauna ꞌina nuwatuhuwao ꞌilogwahatedi, ma tauna ꞌana kelose ꞌiꞌahali, ma ꞌoinega ꞌiꞌamasa, beno gide ꞌagu muliyaina ꞌana ꞌeda. ");
INSERT INTO bdd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Ma ꞌeguma taiya yawasina ꞌinuwahi, ꞌabwa yawasiina ꞌiloheꞌwadalele. Ma ꞌeguma yawasina weyahigu ꞌitagwale ma ꞌiꞌamasa, tauna nata yawasina bwebweꞌana ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Ceguma ꞌida wasawasao baleꞌuwa madou hedade talobadi, beno ginaula bwagabwaga, ma hesi ginaula madouna beno yawasida bwebweꞌana. Weyahina ꞌeguma yawasida bwebweꞌana taloheꞌwadalele, geya ꞌaigeda wete ꞌana miyalaena ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Cabwa taugu Loheyaiguina yalohihilama, beno Tamagu ꞌina wasawasa ꞌasiꞌasilalana, ta wete aneloseyao baꞌidagwao, ma tomota ꞌidi paihowao ꞌadi maisa yaꞌebwaedi. ");
INSERT INTO bdd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Yagwaeya moisa ꞌoimiya ꞌabehega tomota tupwami sahena waꞌamaꞌamasa ꞌana siga taugu Loheyaiguina yahilama sabi loina, ma ꞌoina waꞌita hilegau.” ");
INSERT INTO bdd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sabwelo sikisi mulina Yesu ꞌana tomuliyao ꞌetoi ꞌitoediya, ta sihaneya ꞌoya ꞌaigeda dudulena ꞌoina. Tomuliyaowedi taudi Pita ma Yemesa matasina Yoni. ");
INSERT INTO bdd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tutaina taudimo simiyamiya ꞌoyai Yesu maninina siꞌiteya ꞌinamanamala gide sinala ꞌana ꞌita, ma ꞌana ꞌaleꞌo ꞌana waꞌewaꞌeꞌeina gide ꞌasilala ꞌisaesaehane. ");
INSERT INTO bdd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma wete Mosese ma Ilaitiya silatuma ta Yesuina baꞌidadiu sihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Coinega Pita ꞌiꞌahwalagata ma Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌida miya bewa gide ꞌausalana, ꞌoinega ꞌilobwaineya ma ꞌeguma ꞌutagwala, hadahada ꞌetoi yaꞌabidi, ma ꞌaigeda ꞌowa weyahiu, ma ꞌaigeda Mosese weyahina, ma ꞌaigeda Ilaitiya weyahina.” ");
INSERT INTO bdd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ꞌina gwae ꞌabwa geya ꞌilosalohi ma yaloyaloha ꞌasilalana ꞌiꞌahuhe taluhidiya, ma yaloyaloha ꞌoinega ꞌenana ꞌaigeda sihesagoheya, ꞌigwae, “Bewa Natugu bwebweꞌana hedade, tauna weyahina yayaliyaya madouna, ꞌoinega ꞌina gwaeyao wahesagohedi.” ");
INSERT INTO bdd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma Yesu ꞌana tomuliyaowedi gwaeina sihesagoheya ta maꞌidi matauta sibeꞌu talutalubuꞌiya, ");
INSERT INTO bdd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ma Yesu ꞌinaoma ta ꞌiꞌabihe toholodiya, ꞌigwaeya, “Watoholo. Sahena wamatamatauta.” ");
INSERT INTO bdd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Coinega sisapaila ta Yesu ꞌiboinamo ꞌitotoholo siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yesu baꞌidanao ꞌoyega sidobidobima, ma Yesu ꞌihegwaediya, ꞌigwae, “Ginauledi nige waꞌitediya sahena tomota ꞌoidiya wahehepwaila ꞌana siga taugu Loheyaiguina ꞌamasega yatoholo hilama.” ");
INSERT INTO bdd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma Yesu ꞌana tomuliyao ꞌoina sihesilala, sigwae, “Toꞌaha weyahina loina ꞌana toheꞌitao sigwaeya ꞌabehega Ilaitiya ꞌabwa ꞌinugetama, ma muliyetega Toꞌabihetenaina ꞌilatu?” ");
INSERT INTO bdd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta Yesu ꞌigwaeya, “Cehe gide, Ilaitiya ꞌabehega ꞌinugetama, ma ꞌoinega ginaula mabwaiyadi ꞌiꞌabihe dumwaludi. ");
INSERT INTO bdd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma hesi Ilaitiyaina ꞌilatu pwaima, ma tomota geya siꞌinana, ta hesi sipaipaihowa galana ꞌoina toꞌaha ꞌidi nuwatuhu gide, nata wete taugu Loheyaiguina gide ꞌoiguwa simumuga ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Coinega tomuliyaowedi nage ꞌoina sisanapuya ꞌabehega Yesu Yoni toꞌabihebabitaiso weyahina ꞌigwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Coinega Yesu maꞌana tomuliyao sidobidobi boda ꞌoidiya, ma ꞌaigeda loheya ꞌinaoma, ta ꞌiꞌahetulasa Yesu matana, ");
INSERT INTO bdd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma ꞌigwaeya “Bada, natugu ꞌuꞌatemuyemuye, ma ꞌuꞌabihe bwebweꞌani, weyahina tuta mabwaiyana ꞌana lomagisubu weyahina ꞌitaitai, ta wahina simuyamuya madouna, ma sauga tupwana ꞌoidiya ꞌaiwe ninininima ꞌoina ꞌibeꞌubeꞌu, ma sauga tupwana weꞌaha ꞌoina ꞌibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma ꞌa tomuliyao ꞌoidiya yanaoleyama, ta geya sawasawahina ma siꞌabihe bwebweꞌani.” ");
INSERT INTO bdd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Coinega Yesu ꞌihegwaediya, “Hede ꞌomi togidega? Tonuwa potapotami ꞌiya. Nuwana geya wahemisaegau, ꞌawa? Cimi nuwapotapota ꞌoinega yawahi dabalala. Hana gwamaina wanaoleyama ꞌoiguwa, ma yaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gwamaina sinaoleyama, ma Yesu hiꞌahiꞌa ꞌiloinaeya, ma lomagisubu gwamaina ꞌoinega ꞌilatuwa ta ꞌibwebweꞌana hila. ");
INSERT INTO bdd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Muliyetega Yesu ꞌana tomuliyao tupwadi sinaoma siboidimo Yesu baꞌidanao, ma sihegwaeya, sigwae, “Bada, togidega tauma ta geya sawasawahima ma hiꞌahiꞌaina ꞌaulalatuhe?” ");
INSERT INTO bdd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta Yesu ꞌigwaeya, “Weyahina ꞌimi hemisa ꞌiweꞌa. Yagwae moisa ꞌeguma ꞌimi hemisa ꞌana waiwai gide seyala patuna, ꞌabwa ꞌoya nage ꞌoina wagwae, ‘Bewa ꞌoinega ꞌumiya dobi,’ nata ꞌihematamatana tuwa. Gide wete ginaula mabwaiyadi sawasawahimi ma wapaihowadi.” ");
INSERT INTO bdd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO bdd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Muliyetega Galili ꞌoina simiyamiya, ma Yesu ꞌihenuwa laguwediya, ꞌigwae, “Cabwa ꞌagu toteba ꞌitebaegau taugu Loheyaiguina ꞌagu ꞌalehao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ma siloheꞌamasigau, ma sabwelo hetoina ꞌoina Yehoba ꞌiꞌabihetoholo hilegau.” Yesu ꞌina hepwaila bewa weyahina sinuwagala moisa. ");
INSERT INTO bdd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Muliyetega sitauya Kapaneumi ꞌoina, ma takesi Hada Heꞌasisi weyahina ꞌana toheꞌautao sinaoma ta Pita ꞌoina sigwaeya, “Togidega, sawasawahina ma ꞌino toheꞌitaina ꞌitakesi, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita ꞌigwaeya, “Cehe, nata ꞌina takesi ꞌilagu.” Coinega ꞌihilama hadai, ma Yesu Pita ꞌihegwaeya, ꞌigwae, “Saimoni, toꞌaha ꞌino nuwatuhu toloinao baleꞌuwa weyahidi, taiyawedi ꞌoidiyega takesi siꞌewaꞌewa? natudiyao ꞌoidiyega? bo hali tomota ꞌoidiyega?” ");
INSERT INTO bdd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ꞌigwaeya, “Hali tomota ꞌoidiyega.” Ta Yesu wete ꞌigwae hila, ꞌigwaeya, “Moisa! Coinega taudi natudiyao geyaꞌabwa sitaketakesi. ");
INSERT INTO bdd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma sahena taloguipaila, ꞌamuge ma ꞌoida sinuwagala. Coinega bewa tuwa huku ꞌuꞌewa ma ꞌudobi holai, ma ꞌeguma silahana nugenugetana ꞌuꞌatu, ꞌahwana ꞌusoꞌe ma ꞌalonega mane ꞌuꞌeweyama ma ꞌuꞌebwaedi, beno ꞌowa ma taugu ꞌida takesi sawasawahida.” ");
INSERT INTO bdd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tuta nage ꞌoina Yesu ꞌana tomuliyao sinaoma ma sihegwaeya, sigwae, “Bada, taiya sanina madouna Yehoba ꞌina ꞌebeloina ꞌalona?” ");
INSERT INTO bdd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Coinega Yesu gwama ꞌaigeda ꞌibwauweyama, ma gwamaina gamwagamwanidiya ꞌihetoholoya, ");
INSERT INTO bdd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","ma ꞌihegwaediya, “Yagwae moisa, taiyawedi ꞌomi ꞌeguma ꞌimi nuwadobi gwama bewa gide, ꞌomi sanimi madoudi Yehoba ꞌina ꞌebeloina ꞌalona, ma ꞌeguma geya wanuwabui ma gwagwama ꞌiꞌiudi gide, sahena waluhuluhu ꞌina ꞌebeloina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Coinega ꞌeguma ꞌaigeda loheya gwama bewa gide ꞌitoe weyahigu, tauna taugu wete ꞌitoegau. ");
INSERT INTO bdd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma hesi ꞌeguma taiya ꞌitoho ma ꞌagu tohemisao gwagwama bewa ꞌoidiyega ꞌaigeda ꞌiꞌabihebeꞌu, loheyaina nuwana wahineina ꞌilobwaineya ma dimwa madouna taniꞌona silosipwa, madimwaina siula dobihe niꞌuwa, ma ꞌidamana. ");
INSERT INTO bdd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Comi mebaleꞌu ꞌatemuyamuyaimi ꞌiya, weyahina ꞌebe beꞌu baibaiwadi simiyamiya. Moisa tuwa, ꞌilobwaineya ma ꞌebe beꞌuwao baleꞌuwa simiyamiya, ma hesi ꞌeguma loheya ꞌitoho ma ꞌiyanao ꞌiꞌabihebeꞌudi, ꞌabwa loheyaina ꞌihesilae moisa. ");
INSERT INTO bdd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ma ꞌeguma nimau bo ꞌaheu ꞌiꞌabihebeꞌugo ꞌilobwaineya ma ꞌuꞌupwa yahuledi. Geya beno ꞌana galamo ꞌeguma manima tomwatomwau nuwana maꞌino haꞌauꞌau ma yawasiu bwebweꞌana ꞌuloba. Ma hesi gala hedade ꞌoiuwa ꞌeguma manima luwaluwau ma maꞌae luwaluwau siula dobihego ꞌaiwe ꞌalaꞌalata hatayana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Matau wete gide, ꞌeguma ꞌiꞌabi hebeꞌugo, ꞌubwai yahule tuwa, weyahina geya ꞌaigeda wete ꞌana galamo ꞌeguma mamata ꞌaiꞌaigedau ma yawasiu bwebweꞌana ꞌuloba. Ma hesi gala hedade ꞌoiuwa ꞌeguma mamata luwaluwau siula dobihego ꞌasa ꞌalaꞌalata ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Gwagwama bewa gide sahena ꞌaigeda ꞌoidiyega walososomane. ");
INSERT INTO bdd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Moisa, gwagwamaedi ꞌidi aneloseyao tuta mabwaiyana galewa Tamagu matana simiyamiya, ma siꞌeꞌebubu. ");
INSERT INTO bdd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma togidega ꞌeguma loheya ꞌina sipiyao ꞌadi baibaiwa handeledi, ma ꞌaigeda ꞌoidiyega ꞌitauya puiya ma ꞌiꞌwaniya, nata nainiti nainiyedi ꞌoyai ꞌilagudiya ma ꞌwaniꞌwaninaina ꞌiꞌebese, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Ma ꞌeguma ꞌiloba hila, yagwae moisa nata ꞌina yaliyaya madou hedade. Ma hesi site nainiti nainiyedi bwebweꞌadi geya weyahidi ꞌiyaliyaya hedade. ");
INSERT INTO bdd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Coinega bewa tuwa wasanapu ꞌabehega Tamamiu galewa geya nuwana ma gwagwamaedi ꞌoidiyega ꞌaigeda taiya ꞌihesilae. ");
INSERT INTO bdd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ma ꞌeguma tasiu ꞌipaihowa galana ꞌoiuwa, ꞌutoho ma wateluwamo ꞌina puiina waꞌabihedumwalu, ma ꞌeguma ꞌenau ꞌihesagohe, ꞌausala, beno waꞌahwa ꞌiyaꞌiyagu pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma ꞌeguma geya nuwana ma ꞌenau ꞌihesagohe, tomota ꞌaigeda, nuwana ꞌeluwa wete, ꞌutoedima baꞌidamiyao tasiu nina ꞌoina wagwae ma ꞌina pui ꞌana moisa ꞌinuwasabwaleni. ");
INSERT INTO bdd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ꞌeguma tuwa geya nuwana ma ꞌihesagohegemi, wagwae latu tohekalesiyao mabwaiyadi ꞌoidiya, ma ꞌeguma geya nuwana wete tohekalesiyao ꞌidi gwae ꞌihesagohedi, walogwahate tuwa, ma ꞌimiya ganamuli gide takesi ꞌana toꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yagwae moisa ꞌoimiya, toꞌaha ꞌeguma baleꞌuwa wapaidi, ginauledi galewa nata wete sipaidi. Ma wete toꞌaha ꞌeguma baleꞌuwa walihasidi, nata ginauledi wete galewa silihasidi. ");
INSERT INTO bdd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Bewa tuwa yahegwaegomi ꞌabehega ꞌeguma ꞌoimiyega wateluwa baleꞌuwa ꞌimi nuwatuhu mahemahetena, ma waꞌahwanoi gide Tamagu galewa ꞌoina, nata tuwa ꞌipaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Weyahina ꞌeguma ꞌaigeda tupwa ꞌoina ꞌeluwa bo ꞌetoi tomota saniguwega simiyaꞌauta, taugu wete gamwagamwanidiya yamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ma Pita ꞌinaoma ma Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌeguma tasigu tuta baibaiwana ꞌoiguwa galana ꞌipaipaihowa, mahisa sawasawahina ma ꞌina puiyedi yanuwasamudi, masebeni, bo nuwana ꞌehisa?” ");
INSERT INTO bdd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Yesu ꞌigwaeya, “Geya masebenimo, ma hesi mabaibaiwana. ");
INSERT INTO bdd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Weyahina Yehoba ꞌina loina gide kini ꞌaigeda, tauna nuwanuwana ma ꞌina topaihowao ꞌidi lowaga sihemaise ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Coinega ꞌihegaina ma loheya ꞌaigeda siꞌeweyama ꞌina lowaga teni tausani kina, ");
INSERT INTO bdd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ma geya sawasawahina ꞌihemaise, ꞌoinega badaina ꞌiloina ma ꞌabehega loheyaina mwanena ta natudiyao ma ꞌidi tobwatobwao mabwaiyadi sigimwaneyedi, ma ꞌadi maisa toloina ꞌiꞌewa topaihowaina ꞌina lowaga weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma topaihowaina maꞌina nuwagala ꞌiꞌetuluha, ma ꞌiꞌahwanoiya ꞌoina, ꞌigwae, ‘Bada ꞌuꞌatemuyemuyegau, ma ꞌabwa ꞌigu lowaga mabwaiyana yahemaise.’ ");
INSERT INTO bdd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Coinega bada ꞌiꞌatemuyamuyaeya ma ꞌina lowaga mabwaiyana ꞌinuwasamudiya, ma ꞌoinega topaihowaina ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Cilatuwa ma ꞌiyana ꞌaigeda ꞌilobeya, ma ꞌiyanaina ꞌina lowaga ꞌoina toea handeledimo, ta ꞌiyanaina taniꞌona ꞌiꞌabiya ma ꞌiꞌabihe matausiya, ꞌigwaeya, ‘Bewa tuwa ꞌino lowaga ꞌoiguwa ꞌuhemaisa!’ ");
INSERT INTO bdd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Coinega ꞌiyanaina ꞌiꞌetuluha ma ꞌoina ꞌiꞌahwanoiya, ꞌigwae, ‘Tuwa ꞌuꞌatemuyemuyegau, ma ꞌabwa ꞌigu lowaga mabwaiyana yahemaise.’ ");
INSERT INTO bdd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma ꞌiyana ꞌenana geya ꞌihesagohe, ta deliya ꞌilaguya, ma ꞌabehega nobwa ꞌimiyamiya ma ꞌana siga ꞌina lowaga mabwaiyana ꞌihemaise. ");
INSERT INTO bdd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ma topaihowaedi ꞌiyadiyao ginaulina siꞌiteya ꞌoinega sinuwagala ma sitauya ꞌidi bada ꞌoina ta siteluwaedi sihepwailediya. ");
INSERT INTO bdd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Coinega badaina ꞌina topaihowa ꞌibwauweyama ma ꞌihegwaeya, ꞌigwae, ‘Cowa topaihowa galau, weyahina ꞌino ꞌahwanoi ꞌatemuyemuyega ꞌino lowaga mabwaiyana yanuwa samudiya, ");
INSERT INTO bdd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ꞌoinega ꞌowa wete sawasawahina ma ꞌiyau ꞌuꞌatemuyemuye ma ꞌina lowaga wete ꞌunuwasam.’ ");
INSERT INTO bdd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Coinega badaina ꞌigamwasowala moisa, ta deli ꞌana toꞌitayahinao ꞌihegwaediya, ma topaihowaina deliya silaguya ma ꞌabehega nobwa ꞌimiyamiya ꞌana siga ꞌina lowaga mabwaiyana ꞌihemaise hegumwali.” ");
INSERT INTO bdd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Coinega Yesu ꞌina gwae ꞌilosalohiya, ꞌigwae, “Tamagu galewa wete ꞌoimiya ꞌipaihowa gide, ꞌeguma tasimiyao sahena waꞌatemuyemuyedi, ma ꞌidi puiyao wanuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu ꞌina heꞌitaedi ꞌilosalohidiya ma tupwa Galili ꞌiꞌebesineya, ma Yudiya ꞌina tupwa ꞌiluhuwa, beno weꞌaha Yolidani hali papaliya. ");
INSERT INTO bdd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma boda wete madouna Yesu simuliyeya ta nobwa ꞌidi tolohalao ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Coinega Palisiyao sinaoma ta nuwanuwadi ma Yesu sitoho, ꞌoinega ꞌoina sihesilala, sigwae, “Bada, sawasawahina ma pui tupwana weyahina loheya mwanena ꞌisaꞌile?” ");
INSERT INTO bdd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta Yesu ꞌigwae, “Buki Heꞌasisi ꞌoina wasanapu pwaiya lelelena ꞌabehega tuta ꞌana ꞌebe hegaina ꞌoina Tohemasalaha tomota ꞌeluwa ꞌihemasalehediya, meloheyana ma mewahinena, ");
INSERT INTO bdd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma ꞌigwaeya, ‘Bewa huhuna ꞌoinega loheya tamana ma sinana ꞌiꞌebesinedi ma mwanena baꞌidana simiyaluwa, ma siteluwaedi siheꞌwapina ꞌaigeda tuwa, ");
INSERT INTO bdd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ma tuta bewa siheꞌaigeda pwaiya. Yehoba ꞌihemiyaluwa pwaiyediya, ꞌoinega sahena ꞌeta taiya ꞌihemiya wasiyedi’.” ");
INSERT INTO bdd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Coinega sigwaeya, “Toꞌaha weyahina Mosese ꞌiloina ꞌabehega loheya sawasawahina ma pepa ꞌoina ꞌina logwahata ꞌihepwaile, ma mwanena ꞌiꞌebwae, ma muliyetega ꞌisaꞌila?” ");
INSERT INTO bdd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yesu ꞌigwaeya, “Beno ꞌimi nuwapota weyahina, ꞌoinega Mosese ꞌitagwala ꞌoimiya ma mwanemiyao gide wasaꞌila ꞌesedi, ma hesi tuta nugenugetana geya wete tagwala saꞌila weyahina ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma yahegwaegomi ꞌabehega ꞌeguma loheya ꞌaigeda mwanena geya ꞌipui, ma loheya tuwa ꞌisaꞌila ma ꞌihaibala hali wahine ꞌoina, beno ꞌilogwaliya.” ");
INSERT INTO bdd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Coinega ꞌana tomuliyao sihegwaeya, sigwae, “Ceguma loheya mamwanena ꞌadi loina bewa gide, sahena hai.” ");
INSERT INTO bdd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Yesu ꞌigwaeya, “Heꞌita bewa geya tomota mabwaiyadi weyahidi, ma hesi ꞌeguma Yehoba sanapu ꞌiꞌebwaeya tupwanamo tomota ꞌoidiya ma sisanapu ");
INSERT INTO bdd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ꞌabehega loheloheya tupwana ꞌidi liꞌu hohau ꞌoinega geya sawasawahina ma sihai, ma wete tupwadi loheloheya ꞌwawadi siꞌewediya ma geya sowana sihai, ma tupwadi Yehoba ꞌina loina weyahina siboidimo siꞌausidiya ma sahena sihaihai. Ceguma taiya gwae bewa sawasawahina ma ꞌisanapu, maꞌina sanapu ꞌinuwasabwalena.” ");
INSERT INTO bdd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ta tomota gwagwama siꞌewedima Yesu ꞌoina ma ꞌabehega ꞌiꞌabitohodi ma weyahidi ꞌiꞌahwanoi Yehoba ꞌoina. Ma hesi ꞌana tomuliyao gwagwamaedi siꞌetobodediya. ");
INSERT INTO bdd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ta Yesu ꞌigwaeya, “Sahena gwagwama waꞌetoꞌetobodedi, ma hesi watagwaledi ma ꞌoiguwa sinaoma, weyahina gwagwamaedi gide Yehoba ꞌina ꞌebeloina ꞌilobwainediya moisa.” ");
INSERT INTO bdd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Coinega Yesu gwagwamaedi ꞌiꞌabitohodiya, ma muliyetega ꞌiꞌebesinediya. ");
INSERT INTO bdd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Muliyetega ꞌaigeda loheya Yesu ꞌoina ꞌinaoma ta ꞌigwaeya, “Toheꞌita, to paihowa bwebweꞌana yada paihowa ma ꞌoinega yawasigu miyamiya hatayana yada loba?” ");
INSERT INTO bdd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Yesu ꞌigwaeya, “Toꞌaha weyahina paihowa bwebweꞌana ꞌuhesilala ꞌoiguwa? Caigeda tuwamo ꞌina mumuga bwebweꞌana. Eeta ꞌeguma nuwanuwau ma yawasiu hataya ꞌuloba, sawasawahina ma tauna ꞌina loinao ꞌumuliyedi.” ");
INSERT INTO bdd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma loheyaina ꞌihesilala, ꞌigwaeya, “To loina?” Ta Yesu ꞌigwaeya, “Sahena ꞌahuyemate; sahena logwali; sahena yagaha; sahena hepwaila ꞌaboꞌabo; ");
INSERT INTO bdd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma tamau ma sinau ꞌuheꞌasisiyedi; ma wete ꞌiyamwao ꞌuhelauwedi gide ꞌuboi ꞌuhelauwego.” ");
INSERT INTO bdd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta hewaliina ꞌigwae, “Loinaedi mabwaiyadi yamuliya bwaibwainidiya, ma toꞌaha wete yada paihowa?” ");
INSERT INTO bdd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta Yesu ꞌigwaeya, “Ceguma nuwanuwau ma mumugau mabwaiyana bwebweꞌana, ꞌuhila ꞌino ꞌasa, ma ꞌino tobwatobwa mabwaiyadi ꞌuhegimwaneyedi, ma ꞌadi maisa ꞌuheguyaiye towewelohe ꞌoidiya, ma ꞌoinega ꞌunaoma ma ꞌumuliyegau, ma ꞌoinega ꞌabwa wasawasa galewa ꞌuloba.” ");
INSERT INTO bdd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Loheyaina Yesu ꞌina gwae bewa ꞌihesagoheya, ta maꞌina nuwagala ꞌihila. Tauna ꞌana bolime geya baibaiwana, ta ꞌina tobwatobwa baibaiwa hedade ꞌinuwahidiya. ");
INSERT INTO bdd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Coinega Yesu ꞌana tomuliyao ꞌihegwaediya, “Moisa, towasawasao ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌoina mwauna. ");
INSERT INTO bdd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","“Ma wete yahegwaegomi ꞌabehega hebai kameli ꞌina luhu nidili ꞌana ꞌebesula ꞌoinega mwauna, ma hesi tohewasawasa ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌoina mwau hedada.” ");
INSERT INTO bdd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu ꞌana tomuliyao ꞌina gwae bewa sihesagoheya ta nuwadi ꞌihenainaida hedadeya, ma sigwaeya, “Ceguma bewa gide, taiya hede sawasawahina ma ꞌebe yaliyaya ꞌiloba?” ");
INSERT INTO bdd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma Yesu ꞌiꞌebubudiya ma ꞌigwaeya, “Ginaula bewa mwau hedada tomota ꞌoidiya, ma hesi Yehoba ꞌoina ginaula mabwaiyana meyameyahadi.” ");
INSERT INTO bdd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Coinega Pita ꞌihesilala, ꞌigwaeya, “Bada, tauma togidega? Weyahina ꞌima tobwatobwao mabwaiyadi ꞌaꞌebesine pwaidiya ta ꞌamuliyegowa.” ");
INSERT INTO bdd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Yesu ꞌihegwaediya, “Yagwae moisa, ꞌabwa baleꞌu ꞌana ꞌabiheꞌehau ꞌoina taugu Loheyaiguina ꞌigu wagahata wasawasa ꞌoina yamiyatoi, ma wete ꞌomi ꞌagu tomuliyao wate tuwelo ꞌimi wagahata tuwelo ꞌoidiya wete wamiyatoi, ma meIsileli ꞌidi susuwao tuwelo waloinaedi. ");
INSERT INTO bdd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Ma ꞌeguma taiyawedi ꞌomi ꞌimi hadao, bo tasimiyao, bo sinamiyao, bo nuhumiyao, bo tamamiyao, bo natumiyao, bo ꞌimi tanohao waꞌebesinedi, ꞌabwa ginauledi waꞌebesinediya ꞌadi miyalaena ma ꞌadi loheposeyana handeledi walobadi, yawasimi hataya baꞌidana. ");
INSERT INTO bdd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Ma tuta bewa tohanugetao baibaiwadi ꞌabwa simuliya, ma taudi simulimuliya ꞌabwa sinugeta. ");
INSERT INTO bdd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yehoba ꞌina loina gide tuwa loheya ꞌaigeda maꞌina tanoha, loheyaina ꞌabwakululu ꞌitoholowa ma ꞌitauya ꞌasai ta tupwadi topaihowao ꞌitoediya sabi paihowa ꞌina tanoha. ");
INSERT INTO bdd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Coinega loina ꞌilaguya ma ꞌabehega sabwelo ꞌaigeda paihowa ꞌana maisa kina ꞌaigeda, ta sitagwala. Coinega ꞌihesumanediya ta sitauya ꞌina tanoha sabi paihowa. ");
INSERT INTO bdd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma sinala ꞌisaehanema ta loheyaina ꞌitauya hila ꞌasaina ꞌoina, ta tomota tupwadi ꞌilobediya simiyamiya bwagabwaga. ");
INSERT INTO bdd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Coinega ꞌibwauwedima ta ꞌigwaeya, ‘Comi wete watauya ꞌigu tanoha wapaihowa, ma ꞌimi paihowa ꞌana maisa dumwaluna yaꞌebwaegomi.’ Coinega sitauya tanoha. ");
INSERT INTO bdd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Coinega ꞌasudiladila ma wete lahilahiya ꞌitauya hila ꞌasaina ꞌoina, ta nobwa tomota tupwadi ꞌilobediya, ta ꞌibwauwediya ta wete ꞌihesumanediya, ta sitauya ꞌina tanoha. ");
INSERT INTO bdd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ma lahilahi moisa wete ꞌilatu hila ta ꞌitauya ꞌasai ma tomota wete tupwadi ꞌilobediya ta ꞌihesilalediya, ꞌigwae, ‘Toꞌaha weyahina sabwelo mabwaiyana wamiyamiya bwagabwaga?’ ");
INSERT INTO bdd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma sigwaeya, ‘Weyahina geya ꞌeta taiya ꞌibwauwemai sabi paihowa.’ Ta loheyaina ꞌigwaeya, ‘Comi wete watauya ꞌigu tanoha ma wapaihowa.’ ");
INSERT INTO bdd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Coinega boi hohau ꞌoina tanoha toniwagana ꞌina paihowa ꞌana toꞌitayahi ꞌihegwaeya, ꞌigwae, ‘Topaihowao mabwaiyadi ꞌubwauwedima ma ꞌadi maisa ꞌuꞌebwaedi, taudi tonaoma hauhaudi ꞌoidiyega ꞌuhegaina ma ꞌadi maisa ꞌuꞌebwaꞌebwaedi, ma ꞌana siga taudi sabwelo mabwaiyana ꞌoina sipaihoweya.’ ");
INSERT INTO bdd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Coinega taudi lahilahimo ꞌoina sipaihowa sinaoma ma ꞌadi maisa kina ꞌaigeda ꞌaigeda siꞌeweya. ");
INSERT INTO bdd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Muliyetega mabwaiyadi wete topaihowaedi sinaoma ta ꞌadi maisa kina ꞌaigeda ꞌaigeda siꞌeweya. Ma topaihowa nugenugetadi wete, taudi sabwelo mabwaiyana ꞌoina sipaihowa, sinaoma ta ꞌidi nuwatuhu ꞌabehega nata maisa ꞌana loheposeyana siꞌewa, ta geya, taudi wete kina ꞌaigeda tuwa siloꞌahala. ");
INSERT INTO bdd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Coinega ꞌidi kina siꞌewediya ma tanoha toniwagana ꞌoina silomugiya, ");
INSERT INTO bdd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ma sigwaeya, ‘Tomota hauhaudi sinaoma ꞌidi paihowa tuta toꞌutoꞌupanamo, ma tauma sabwelo mabwaiyana hala ꞌalona ꞌapaihowa, ma taudi ꞌadi maisa gide tuwa mabwaiyama mahemahetena.’ ");
INSERT INTO bdd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma badaina ꞌaigeda ꞌoidiyega ꞌihegwaeya, ꞌigwae, ‘Ciyagu, geya wete yaꞌabowego, weyahina ꞌida loina nugenugetana ꞌabehega kina ꞌaigeda tuwamo ꞌuꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cino kina bewa ꞌuꞌewa ma ꞌutauya. Ma taugu ꞌigu loina ꞌabehega tomota hauhaudi sinaoma ꞌadi maisa yaꞌebwaedi ꞌowa gide ꞌa maisa. ");
INSERT INTO bdd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maisa bewa taugu ꞌigu ꞌebeloina. Sahena ꞌomi waloiloina. Sahena ꞌigu helau tomota ꞌoidiya weyahina waheꞌipiꞌipi.’ ");
INSERT INTO bdd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Coinega taudi simulimuliya ꞌabwa sinugeta, ma taudi sinugenugeta ꞌabwa simuliya.” ");
INSERT INTO bdd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cabwa Yesu Yelusalema weyahina ꞌihanehane ma ꞌana tomuliyao site tuwelo ꞌitoediya ꞌeda papalina, ma taudimo, ma ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ꞌigwae, “Bewa tuwa tahanehane Yelusalema, ma nobwa ꞌagu totebaina taugu Loheyaiguina ꞌitebaegau topwaoli madoudi ma loina ꞌana toheꞌitao ꞌoidiya, ma ꞌigu ꞌamasa weyahina siloina, ");
INSERT INTO bdd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ma muliyetega siꞌebwayegau taudi geya meYudiya ꞌoidiya, ma silotuyanegau, ma balaeyega sisapigau, ma kelose ꞌoina situtu hepatugau, ma sabwelo hetoina ꞌoina Yehoba ꞌiꞌabihe toholo hilegau.” ");
INSERT INTO bdd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Muliyetega Sebedi mwanena manatunao sinaoma ta sinadiuina Yesu ꞌoina ꞌiꞌetuluha ma ꞌiꞌahwanoiya ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta Yesu ꞌigwaeya, “Toꞌaha nuwanuwau?” Ma wahineina ꞌigwaeya, “Nuwanuwagu ma natugwao ꞌoidiya ꞌutagwala ma ꞌeguma tutaina ꞌuhetoloina, sawasawahina ma deiuwa simiyatoi sabi loina, ꞌaigeda ꞌino ꞌebeulega ma ꞌaigeda ꞌino ꞌadigeyegeyega.” ");
INSERT INTO bdd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Coinega Yesu loheloheyaedi ꞌihegwaediya, “Comi ꞌimi ꞌahwanoi bewa ꞌana nuwasabwalena geya wasanasanapu. Muya biyoina ꞌoinega yanuma, togidega, sawasawahina ꞌomi wete ꞌoinega wanuma?” Ma sigwae, “Sawasawahima.” ");
INSERT INTO bdd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma Yesu ꞌigwaeya, “Moisa, biyoina ꞌoinega yanuma ꞌomi wete ꞌabwa wanuma, ma hesi geya sawasawahigu ma yahesinuwa taiyawedi ꞌabwa ꞌigu hetoloina ꞌoina ꞌigu ꞌebeulega ma ꞌigu ꞌadigeyegeyega simiyatoi sabi loina, weyahina Tamagu ꞌiboimo ꞌabwa ꞌihesinuwa.” ");
INSERT INTO bdd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ma tomuliyao site teniyedi Yemesa ma Yoni ꞌidi ꞌahwanoi sihesagoheya, ma sigamwasowalediya. ");
INSERT INTO bdd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Coinega Yesu mabwaiyadi ꞌibwau heꞌautediya, ma ꞌihegwaediya, “Comi wasanapuya ꞌabehega babadao baleꞌuwa ꞌidi loheloheyao siloiloina paꞌaledi, ");
INSERT INTO bdd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ma ꞌomi sahena wete gide taudi wapaihowa ꞌese. Ma ꞌeguma taiya ꞌowa nuwanuwau ma ꞌoimiyega ꞌuhetoloina, ꞌilobwainegowa ma ꞌiyamwao weyahidi ꞌuhetopaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Ma wete ꞌeguma taiya ꞌowa nuwanuwau ma ꞌoimiyega ꞌuhetohanugeta ꞌilobwainegowa ma ꞌiyamwao weyahidi ꞌuhetopaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wete gide taugu Loheyaiguina yasuluma baleꞌuwa, geya ꞌabehega tomota weyahigu sipaihowa, ma hesi sabi paihowa tomota weyahidi, ma wete yatagwalegauwa ma yaꞌamasa tomota mabwaiyami ꞌami lihasa weyahina.” ");
INSERT INTO bdd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Coinega Yeliko siꞌebesineya ma boda madouna Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma loheya tomata gibugibu ꞌeluwa ꞌeda papalina simiyatoiya, Yesu ꞌina sakowasi wasana sihesagoheya, ꞌoinega Yesu ꞌoina sibwauwa, “Debida tubuna yo, ꞌuꞌatemuyemuyemai.” ");
INSERT INTO bdd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ta boda siteluwaedi ꞌenadi sihesagoheya, ma siꞌetobodediya, sigwae, “Walolagu! Tuwa bwau.” Ma ꞌoinega siteluwaedi sibwaubwau ꞌoheꞌohe, sigwae, “Bada, Debida tubuna yo, ꞌuꞌatemuyemuyemai.” ");
INSERT INTO bdd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Coinega Yesu ꞌitoholowa ta ꞌibwauwedima ta ꞌigwaeya, “Toꞌaha nuwanuwami ma weyahimi yapaihowa?” ");
INSERT INTO bdd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma sigwaeya, “Bada, sawasawahina ma matama ꞌuꞌabihe bwebweꞌanedi?” ");
INSERT INTO bdd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ma Yesu ꞌiꞌatemuyemuyediya, ma matadi ꞌiꞌabitohodiya, ma sibwebweꞌana, ma ꞌoinega Yesu wete simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma sihanehane Yelusalema weyahina, ta Bedipegi deina silatulatu, beno ꞌoya Olibe gabulena, ma Yelusalema matadiyega tupwana bwaga. Coinega Yesu ꞌana tomuliyao ꞌeluwa ꞌihesumane nugetediya, ");
INSERT INTO bdd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ꞌigwaeya, “Watauya ꞌasa nage matamiya, ma hebai ꞌase waloba, ꞌaiwe ꞌoina silohoya, ma natuna loheyana mahetena simiyamiya. Walihasidi, ma waꞌewedima ꞌoiguwa. ");
INSERT INTO bdd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ceguma taiya ꞌihesilalegomi ꞌimi paihowaina weyahina, wagwae, ‘Bada nuwanuwana,’ ma ꞌoinega ꞌitagwale ꞌoimiya.” ");
INSERT INTO bdd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ginaula bewa ꞌilatuwa weyahina mwalo palopita ꞌihepwaila nugeteya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saiyoni* tomotainao wahegwaedi wagwae, ‘Waꞌita ꞌimi toloina madouna ꞌinaonaoma ꞌoimiya. Tauna tonuwadobi moisa, ta ꞌase ꞌigeluya, ta ꞌaseina meloheyana ma yauyaubona.’” ");
INSERT INTO bdd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Coinega Yesu ꞌina gwaeina ꞌana tomuliyaowedi sihematamataneya ma sitauya, ");
INSERT INTO bdd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ta ꞌase manatuna silobediya ta siꞌewedima, ta ꞌadi ꞌwama ꞌase guidiya siloyesoya, ma Yesu ꞌigeluhaneya. ");
INSERT INTO bdd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma boda mabwaiyadi wete ꞌadi ꞌwama ꞌedai siyesodiya, ma tupwadi ꞌaiwe lahanao manabaidi sitalagasidiya, silagudi ꞌeda ꞌana pasa weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma tupwana boda Yesu sinugeteya, ma tupwana boda simulimuliya, ta mabwaiyadi sinoꞌonoꞌo ma sihehepwatu, sigwae, “Yauwedo Debida tubuna yo. Bada saninega ꞌunaoma sabi ꞌabihetemai, ꞌoinega tauna Tomiyahane hedade ꞌahehepwatuwe.” ");
INSERT INTO bdd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Coinega Yelusalema ꞌoina siluhuwa, ma tomota mabwaiyadi siꞌateyoho moisa, ma sigwaeya, “Taiya hede nage?” ");
INSERT INTO bdd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma ꞌana ꞌwayabuwao tomotaedi ꞌidi gwae sihemaiseya, sigwae, “Bewa palopita, gwama Nasaleta, sanina Yesu, Galili ꞌina ꞌebeloina ꞌoinega ꞌinaoma.” ");
INSERT INTO bdd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Coinega Yesu Yehoba ꞌina Hada Heꞌasisi ꞌoina ꞌiluhuwa ta togimwaneyao ma tohegimwaneyao mabwaiyadi ꞌipaꞌi latuwediya, ma mane ꞌana tohesaꞌugelasao ꞌidi teibele ꞌiꞌahubuinediya, ma gabubu ꞌadi tohegimwaneyao ꞌidi ꞌebemiya wete ꞌiꞌahubuinediya, ");
INSERT INTO bdd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ma ꞌihegwaediya, ꞌigwae, “Buki Heꞌasisi ꞌoina Yehoba ꞌina gwae sileleya, ꞌigwae, ‘Cigu Hada nata sanina sibwauwe hada ꞌebe ꞌahwanoi,’ ma ꞌomi wabui lohihiliya ma ꞌabehega ꞌimi ꞌebe yagaha.” ");
INSERT INTO bdd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Coinega tomata gibugibu ma tohaꞌauꞌau Yesu ꞌoina sinaoma Hada Heꞌasisi ꞌalona ta mabwaiyadi ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma topwaoli madoudi ma loina ꞌana toheꞌitao Yesu ꞌina paihowa waiwaidi siꞌitediya, ma wete gwagwama sihesagohediya Hada Heꞌasisi ꞌalona sinoꞌonoꞌo, sigwae, “Debida Tubuna yo, ꞌuꞌabihetemai.” ");
INSERT INTO bdd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Coinega babadaowedi Yesu sigamwasowaleya ta sigwaeya, “Gwagwamaedi bewa ꞌidi gwae ꞌuhesagoheya?” Ma Yesu ꞌigwae, “Cehe, yahesagoheya. Ma togidega Buki Heꞌasisi ꞌoina wahasihasili, ꞌigwaeya, ‘Gwagwama ꞌiꞌiudi ꞌahwadiyega ꞌa hepwatu moisa ꞌuloba.’” ");
INSERT INTO bdd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Coinega Yesu ꞌiꞌebesinediya, ta Yelusalemega ꞌilatuwa, ta Bedani ꞌoina ꞌiluhuwa, ta nobwa ꞌiꞌenowa. ");
INSERT INTO bdd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gona ꞌiꞌadaleya, ma Yesu ꞌitoholowa, ta ꞌilohihila Yelusalema, magomalena. ");
INSERT INTO bdd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma ꞌedai ꞌaiwe ꞌana ꞌita gide tuwa damaya ꞌiꞌita lobeya, ma ꞌinaowa deina, ta geya ꞌaigeda huwaina ꞌiꞌita loba, weyahina nabainamo. Coinega Yesu ꞌaiweina ꞌiheliyeya, ꞌigwaeya, “Cabwa sahena wete ꞌuhuwahuwa hila.” Ma ꞌaiweina ꞌiwelaiya mwayamwayauwa. ");
INSERT INTO bdd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ma Yesu ꞌana tomuliyao siꞌiteya, ta nuwadi ꞌihenainaida, ma sigwaeya, “Togidega ta ꞌoinega ꞌaiweina ꞌiwelai mwayamwayauwa?” ");
INSERT INTO bdd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Yesu ꞌihegwaedi, “Yagwae moisa ꞌoimiya, ꞌeguma maꞌimi hemisa, ma geya maꞌimi henuwanaluwa, ginaula bewa ꞌaiwe ꞌoina yapaihoweya ꞌomi wete gide wapaihowa ꞌese, ma ꞌeguma ꞌoya nage waloine ma wagwae, ‘Cumiya dobi holai,’ nata ꞌipaihowa gide. ");
INSERT INTO bdd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ma ꞌeguma maꞌimi hemisa Yehoba ꞌoina waꞌahwanoi ꞌabwa waloba.” ");
INSERT INTO bdd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Coinega Hada Heꞌasisi ꞌoina ꞌiluhu ta ꞌiheꞌiheꞌita, ma topwaoli madoudi ma babadao sinaoma ma Yesu sihesilaleya, sigwaeya, “Loheya, taiya ꞌina loinega ta bewa gide ꞌupaipaihowa ꞌese?” ");
INSERT INTO bdd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Yesu ꞌihegwaediya, ꞌigwae, “Nugeta yahesilala ꞌoimiya, ma ꞌeguma wahemaise, taugu wete yahegwaegomi ꞌagu loina weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Cigu hesilala bewa: Taiya ꞌina loinega ta Yoni toꞌabihebabitaiso ꞌipaipaihowa? Yehoba, bo ꞌaigeda tomota?” Coinega siboidimo ꞌoidiya siheheꞌoheꞌohe, sigwae, “Cina gwae togidega tahemaisa ꞌese? Weyahina ꞌeguma tagwae ‘Yehoba ꞌoinega’, nata ꞌihegwae hilegita ma ꞌigwae, ‘Ma! Toꞌaha hede weyahina ta Yoni geya wahemisae?’ ");
INSERT INTO bdd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma ꞌeguma tagwae ‘Tomota ꞌoinega’, nata boda sigamwasowalegita weyahina mabwaiyadi Yoni siꞌahwa palopitaeya.” ");
INSERT INTO bdd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Coinega Yesu ꞌina hesilala geya sihemaise bwaibwaini, ma hesi sigwaeya “Geya ꞌasanapu.” Ma Yesu wete ꞌoidiya ꞌigwae, “Taugu sahena wete yahepwaila ꞌoimiya taiya ꞌina loinega ma bewa gide yapaipaihowa.” ");
INSERT INTO bdd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu wete topwaoliyedi ma babadaedi ꞌihegwaediya, “Togidega ꞌeguma loheya natunao meloheyadi ꞌeluwa tamadiu tautuwa ꞌoina ꞌigwae, ‘Natugu, nata ꞌutauya tanoha ꞌupaihowa,’ ");
INSERT INTO bdd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ta ꞌilogwahata, ma muliyetega ꞌinuwabuiya ta ꞌitauya ꞌipaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Loheyaina natuna ꞌalomauna gide wete ꞌihegwaeya, ꞌigwae, ‘Natugu nata ꞌutauya tanoha ꞌupaihowa,’ ta natunaina ꞌigwaeya ‘Cehe, ꞌausala, nata yatauya’, ma hesi geya ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Coinega siteluwaedi ꞌoidiyega taiya tamana ꞌina gwae ꞌihematamataneya?” Ma sigwae, “Tautuwa.” Coinega Yesu ꞌihegwaediya, ꞌigwae, “Cehe, moisa tuwa, togala taudi takesi ꞌana toꞌewao ma toganawalao wete gide siluhu nugeta Yehoba ꞌina ꞌebeloina ꞌoina, ma ꞌomi mulidiyega. ");
INSERT INTO bdd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Weyahina mwalo Yoni ꞌeda dumwaluna ꞌiheꞌitegomiya ma ꞌomi geya wahemisa, ma hesi takesi ꞌana toꞌewao ma toganawalao sihemiseya. Ma matamiyega wete waꞌiteya sinuwabuiya, ma ꞌomi hesi geya wanuwabui bo nuwana wahemise, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ma Yesu wete ꞌihegwaediya, ꞌigwae, “Caigeda gwae hegehegedi wete wahesagohe tobegula weyahina. Tobegulaina gileipa daisinamo ꞌibeguliya ꞌina tanoha ma ꞌabwalu ꞌipaihoweya ma gileipa ꞌana ꞌebebibi wete ꞌipaihoweya, ma hada tanohina ꞌalona ꞌiꞌabiya, ꞌoinega ꞌina topaihowao ꞌihegwaediya siꞌitaꞌitayahi, ma tauna ꞌitauya hali tupwa. ");
INSERT INTO bdd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ma hedodona ꞌana tuta, badaina ꞌina ꞌaliꞌeyao tupwadi ꞌihesumana hilediya ꞌina tanoha gileipa huwaina sabi ꞌewadi tanoha ꞌana toꞌitayahinao ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ta tutaina sitauya tobegulaedi ꞌaliꞌeyaowedi siꞌabiyahidiya, ta ꞌaigeda sisapiya, ma heluwena siloheꞌamasiya, ma hetoina dimwega siꞌahu bwalebwaleya. ");
INSERT INTO bdd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Muliyetega tobegulaina tupwana wete ꞌina ꞌaliꞌeyao tupwana baibaiwana ꞌihesumanediya, ma taudi wete gide sipaihowa ꞌesediya. ");
INSERT INTO bdd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ma ꞌebelosaloha ꞌoina natuna loheyana ꞌihesumaneya ꞌoidiya, ma ꞌigwaeya, ‘Tauna hede natugu, ma ꞌoinega siheꞌasisiye.’ ");
INSERT INTO bdd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ma natunaina ꞌilatuwa ꞌoidiya ta toꞌitayahinaowedi siboidimo ꞌoidiya sigwae, ‘Ciyagwao, loheya bewa ꞌinaonaoma, tauna badaina natuna ꞌaigeda tuwamo, ꞌoinega nata bewa taloheꞌamasi, ma tauda tanoha taloina.’ ");
INSERT INTO bdd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Coinega siꞌabiyahiya, ta tanohega siule latuweya mulimuliya, ma siloheꞌamasiya. ");
INSERT INTO bdd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Coinega ꞌeguma tutaina tonitanoha ꞌihilama, toꞌaha ꞌina toꞌitayahinedi ꞌoidiya ꞌipaihowa?” ");
INSERT INTO bdd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma ꞌigwaeya, “Toloheꞌamasiyedi ꞌabwa ꞌiꞌabihegaladi moisa, ma tanoha ꞌitagwale toꞌitayahinao ꞌausaladi ꞌoidiya, ma taudi tanoha huwaina siꞌebwae tonitanohina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Coinega Yesu wete gwae hegehegediyega Buki Heꞌasisi ꞌoinega ꞌihepwaileya, ꞌigwae, “Nuwana Buki Heꞌasisi ꞌina hepwaila geya wanuwatuhuyahi, beno ꞌigwaeya, ‘Logidiina mwalo tohadaꞌabi silogwahateya, ma tuta bewa sihetoholo pwaiya ma sihelogidi nugeteya, ma logidi mabwaiyadi ꞌiloinaedi. Beno Bada ꞌina paihowa ꞌebe henainaida ꞌoida.’ ");
INSERT INTO bdd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Coinega yahegwaegomi ꞌabehega Yehoba ꞌina loina ꞌoimiyega ꞌiꞌewayahule, ma ꞌiꞌebwaya hali boda ꞌoidiya, ma taudi ꞌoidiyega huwaina ꞌausalana ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ceguma taiya ꞌibeꞌu logidi nage ꞌoina nata luluna ꞌilasadi, ma ꞌeguma logidiina ꞌaigeda taiya ꞌoina ꞌibeꞌu nata wahina ꞌiꞌahu hepwaliliyamo.” ");
INSERT INTO bdd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesu ꞌina gwae hegehegedi bewa topwaoli madoudi ma Palisiyao sihesagoheya ma sisanapuya ꞌabehega taudi weyahidi ꞌigwaegwae hegehegedi. ");
INSERT INTO bdd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Coinega ꞌidi nuwatuhu siꞌebeꞌebese ma ꞌabehega Yesu siꞌabiyahi, ma hesi geya sawasawahina ma siꞌabiyahi, weyahina boda simatautediya, weyahina bodaedi Yesu siꞌahwa palopitaeya. ");
INSERT INTO bdd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Caigeda wete gwae hegehegedi Yesu ꞌiꞌebwaediya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yehoba ꞌina loina gide kini ꞌaigeda ꞌai ꞌipaihoweya natuna meloheyana ꞌina hai weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Coinega ꞌina topaihowao ꞌihesumanediya ma taiyawedi taudi ꞌihenuwa laguwediya sitoedima ꞌai ꞌoina, ta sitauya sabi toedima, ma hesi tomotaiyedi kini ꞌina bwau silogwahateya. ");
INSERT INTO bdd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Coinega tupwana wete ꞌina topaihowao ꞌihesumanediya ma taudi ꞌihenuwa laguwediya sihegwaediya wete ꞌabehega, ‘Bada ꞌina ꞌai ꞌigibubu pwaiya. Cina bulumakau madoudi ma ꞌina bulumakau yauyaubodi ꞌihunu pwaidiya ma ꞌeꞌahai mabwaiyana ꞌiꞌatububuya. Wanaoma ma tatauya natunaina ꞌina hai ꞌeꞌahaina waꞌai.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ta taudi geya sinaoma, ma hesi sipili ꞌwaiha, ta hali tupwa ma hali tupwa ꞌoidiya sitauya. Caigeda loheya ꞌina tanoha ꞌitauya, ꞌaigeda loheya ꞌina paihowa ꞌoina ꞌitauya, ");
INSERT INTO bdd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma tupwadi wete bada ꞌina topaihowao siꞌabiyahidiya, ma siꞌabihe mwadinediya, ta siloheꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Coinega kiniina ꞌigamwasowala moisa, ta ꞌina toloꞌalehao ꞌihesumanediya, ta toloheꞌamasaedi simutudiya, ma ꞌidi ꞌasa sigabuya. ");
INSERT INTO bdd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ma kiniina ꞌina topaihowao ꞌoidiya ꞌigwaeya, ‘Hai ꞌeꞌahaina ꞌatuꞌatububuina, ma hesi taudi yahenuwa laguwediya geya sawasawahina ma sinaoma. ");
INSERT INTO bdd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Coinega ꞌeda ꞌoidiya wasakowasi ma ꞌeguma taiyawedi walobediya watoedima ma hai ꞌeꞌahaina siꞌai.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Coinega silatuwa ꞌedai ma tomota baibaiwadi siheꞌautedima, tupwadi togala ma tupwadi tobwebweꞌadi, ma ꞌoinega hai ꞌana hadaina silohemaheya. ");
INSERT INTO bdd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tutaina kini ꞌinaoma taumanao sabi ꞌitadi, ta loheya ꞌaigeda ꞌiꞌita lobeya, tauna geya hai ꞌana ꞌaleꞌo ꞌiꞌote, ");
INSERT INTO bdd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ꞌoinega ꞌihesilaleya, ꞌigwaeya, ‘Ciyagu, togidega hai ꞌaleꞌoina geya ꞌuꞌote, ma toꞌehega ꞌuluhuma?’ Ma loheyaina geya sawasawahina ma hesilala bewa ꞌihemaise. ");
INSERT INTO bdd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Coinega kiniina ꞌina topaihowao ꞌihegwaediya, ‘Loheya bewa waꞌabiyahi, ma nimana ma ꞌaena wapaidi, ma waula latuwe tupwa guguyou ꞌoina, ma nage ꞌoina tomota sidou ma sihesalaꞌiꞌita muya ꞌoinega.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Weyahina tomota mabwaiyadi Yehoba ꞌina henuwalagu silobeya, ma hisahisadimo ꞌihesinuwediya.” ");
INSERT INTO bdd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma Palisiyao siboidimo siꞌetoꞌautama, ta siloina togidega ma hesilalega siꞌabowe, ma Yesu ꞌina pui siloba. ");
INSERT INTO bdd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Coinega loina silobeya, ma ꞌadi tomuliyao ma Helodi ꞌina bodao baꞌidadiyao sihesumanediya Yesu ꞌoina, ta sigwae, “Bada ꞌasanapu pwaigowa ꞌabehega ꞌowa toheꞌita moisa, ta Yehoba ꞌina nuwatuhu ꞌuheꞌitae moisa, ma wete tomota ꞌidi waiwai weyahina geya ꞌumatauta, ma tuwa gwae moisa ꞌuhehepwaile mahemahetena tomota mabwaiyadi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Coinega bewa tuwa ꞌuhegwaemai, togidega sawasawahina ma kini Sisa weyahina takesi talagu, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yesu ꞌidi nuwatuhu galana ꞌisanapuya, ꞌoinega ꞌigwae, “Comi toꞌabo! Toꞌaha weyahina watohotohogau? ");
INSERT INTO bdd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ma hana maneina takesi weyahina waheꞌitegau.” Coinega mane ꞌaigeda siꞌebwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ta Yesu ꞌihegwaediya, ꞌigwae, “Wahegwaegau, mane bewa ꞌoina taiya maꞌamaꞌayauna ma sanina?” ");
INSERT INTO bdd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma sigwaeya, “Kini Sisa.” Coinega Yesu ꞌihegwaediya, “Cehe, gide. Coinega ꞌeguma kini ꞌina ginaula waꞌebwae kini ꞌoina, ma ꞌeguma Yehoba ꞌina ginaula Yehoba ꞌoina waꞌebwae.” ");
INSERT INTO bdd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu ꞌina gwae sanasanapuna hedade sihesagoheya, ta geya ꞌidi ꞌebe gwaemo, ꞌoinega siꞌebesineya ma sihawasiya. ");
INSERT INTO bdd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nage sabweloina ꞌoina tupwana Sadusiyao, taudi geya sihemisa toꞌamasa ꞌidi toholo hila weyahina, sinaoma ta Yesu ꞌoina sihesilala, ");
INSERT INTO bdd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","sigwaeya, “Bada, Mosese ꞌina loina ꞌigwaeya, ‘Ceguma loheya mamwanena ma geya natudimo ma loheyaina ꞌiꞌamasa, loheyaina tasina hiwapeina baꞌidana sihai, ma ꞌoinega ꞌeguma wahine ꞌihenatuna natunao toꞌamasaina hesuwahenao.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Caigeda loheya matasinao sikisi baꞌidamao ꞌamiyamiya, ta loheyaina ꞌihaiya ma ꞌiꞌamasa, ma geya natunamo, ma toꞌamasaina tasina deinega hiwapeina baꞌidana sihaiya, ");
INSERT INTO bdd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ma tasinaina wete ꞌiꞌamasa, ma tauna wete geya natunamo. Ma gide tuwa tasinao mabwaiyadi hiwapeina sihaihai, ");
INSERT INTO bdd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ma mulidiyega wahine wete ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Coinega toholo hila ꞌana sauga wahineina to loheya nata mwanena moisa? Weyahina mabwaiyadi sihai pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Yesu hesilala bewa ꞌihemaiseya, ꞌigwae, “Bewa ꞌimi pui, weyahina Buki Heꞌasisi geya wasanapu, ma wete Yehoba ꞌina waiwai geya wasanapu. ");
INSERT INTO bdd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","“Toholo hila ꞌana sauga tomota sahena sihaihai ma hesi ꞌidi miya gide aneloseyao galewa. ");
INSERT INTO bdd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma Yehoba ꞌina gwae ꞌoimiya toholo hila weyahina Buki Heꞌasisi ꞌoina ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Taugu Ebalahamo ꞌina Yehoba, ma Aisake ꞌina Yehoba, ma Yakobo ꞌina Yehoba.’ Yehoba geya tomota ꞌamaꞌamasidi ꞌidi Yehoba, ma hesi tomota mayawasidi ꞌidi Yehoba, ꞌoinega babadaedi mayawasidi bewa tuwa simiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu ꞌina gwae bewa boda sihesagoheya maꞌidi yaliyaya ꞌina heꞌita waiwaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Eeta Palisiyao sihesagoha pwaiya ꞌabehega Yesu Sadusiyao ꞌidi hesilala ꞌihemaiseya ta geya ꞌaigeda wete ꞌidi ꞌebe gwaemo, ꞌoinega Palisiyaowedi Yesu ꞌoina sinaoma, ");
INSERT INTO bdd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ta ꞌoidiyega ꞌaigeda loina ꞌana tosanapu Yesu ꞌoina ꞌihesilala sabi tohoina, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Toheꞌita, loina mabwaiyana ꞌoidiyega to loina madouna?” ");
INSERT INTO bdd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Yesu ꞌigwaeya, “‘Cino Bada Yehoba ꞌuhelauwe ꞌateu ma yaluyaluwau ma ꞌino nuwatuhu mabwaiyadi ꞌoidiyega.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Bewa loina nugenugetana ma madouna. ");
INSERT INTO bdd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ꞌaigeda wete loina madouna gide bewa ꞌigwaeya, ‘Ciyamwao ꞌuhelauwedi, gide ꞌuboi ꞌuhelau hilego.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Loina ꞌeluwaedi, loina mabwaiyana ma palopitao ꞌidi gwae mabwaiyadi huhudi.” ");
INSERT INTO bdd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tutaina Palisiyao siꞌetoꞌautama ta Yesu ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ꞌigwae, “Togidega Toꞌabihetenaina Keliso, taiya ꞌina susuwega ꞌilatuma?” Ma sigwaeya, “Debida.” ");
INSERT INTO bdd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Coinega Yesu ꞌigwaeya, “Togidega ta ꞌoinega mwalo Yaluyaluwa Tabuna Debida ꞌiꞌabihe sanapuya ma Debida Toꞌabihetenaina ꞌiꞌahwa badaeya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yehoba ꞌina gwae ꞌigu bada ꞌoina, ꞌigwaeya: Cigu ꞌebeulega ꞌumiyatoi ma ꞌana siga ꞌa ꞌalehao yalagu dobihedi ꞌaheu gabulena.’ ");
INSERT INTO bdd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ceguma Debida ꞌina bada Toꞌabihetenaina, togidega hede ta Debida ꞌina susuwega muliyetega Toꞌabihetena ꞌilatuma?” ");
INSERT INTO bdd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu ꞌina hesilala bewa geya ꞌaigeda wete taiya sawasawahina ma ꞌihemaise, ta tuta muliyetega Yesu simatauteya, ꞌoinega geya ꞌaigeda taiya ꞌitoho ma ꞌihesilala hila Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ta Yesu boda ma ꞌana tomuliyao ꞌoidiya ꞌigwaeya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mwalo hene meIsileli Mosese ꞌiloiloinaedi, ta nige loina ꞌana toheꞌitao ma Palisiyao gide siloiloina ꞌesegomi. ");
INSERT INTO bdd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Coinega toꞌaha gide siheꞌitegomiya wamuliyedi, ma hesi ꞌidi paihowao sahena waheꞌauꞌaunaowedi, weyahina taudi siheheꞌitamo, ma geya ꞌidi heꞌitaedi sipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Taudi ꞌahaꞌahala mwaudi tomota siꞌebwaꞌebwaedi, ma hesi taudi geya sitagwala ma ꞌahaꞌahalaedi ꞌoidiyega siꞌabihetedi. ");
INSERT INTO bdd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Cidi paihowao mabwaiyana sipaipaihowadi ma ꞌabehega tomota siꞌitadi ma sihepwatuwedi, beno gwaeyao Buki Heꞌasisi ꞌoinega leleleledi manidiya ma nimadiya siꞌabihe paꞌinediya, ta ꞌadi ꞌaleꞌowao duduledi sisohasohadi, ");
INSERT INTO bdd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ta guyai ꞌadi tuta nuwanuwadi ma wagahata simiyatoi, ma wete hada tapwalolo ꞌoidiya ꞌebemiya ꞌausaladi nuwanuwadi, ");
INSERT INTO bdd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ma ꞌeguma ꞌebe maketi ꞌoina sitauya nuwanuwadi ma tomota baibaiwadi siloyauwedowedi nuwana siꞌahwa toheꞌitaedi. ");
INSERT INTO bdd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma ꞌomi hesi sahena tomota siꞌahwaꞌahwa toheꞌitegomi, weyahina ꞌimi toheꞌita ꞌaigeda tuwamo, ma mabwaiyami wahemahemahetena. ");
INSERT INTO bdd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Wete sahena ꞌaigeda taiya baleꞌuwa waꞌahwaꞌahwa tamanae, weyahina tamamiu ꞌaigeda tuwamo galewa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Sahena wete tomota siꞌahwaꞌahwa badaegomi, weyahina Keliso tauna ꞌiboinamo ꞌimi bada. ");
INSERT INTO bdd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma ꞌeguma taiya ꞌoimiyega nuwanuwana ꞌihetohanugeta ꞌida heꞌaliꞌe ꞌoimiya, ");
INSERT INTO bdd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ma ꞌeguma taiya ꞌoimiyega ꞌinuwahane nata ꞌisulu, ma ꞌeguma taiya ꞌinuwadobi nata ꞌihane. ");
INSERT INTO bdd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ma hesi ꞌomi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi, weyahina ꞌimi ꞌabowega tomota waꞌausidiya ma ꞌoinega Yehoba ꞌina ꞌebeloina ꞌoina sahena siluhuluhu. Comi geyaꞌabwa waluhuluhu, ma tomota wete taiyawedi nuwanuwadi ma siluhu wanuwahidiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO bdd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Comi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi, weyahina ꞌaigeda wete bewa ꞌimi pui. Tuta baibaiwana waꞌadaꞌadau sakowasi ꞌasa baibaiwadi ꞌoidiya ma ꞌabehega ꞌami tomuliya ꞌaigeda waloba, ma muliyetega tomotaina waheꞌita ma gide ꞌomi wapaipaihowa Tomudulele ꞌoina, tauna gide ꞌipaihowa hedada. ");
INSERT INTO bdd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Hesi ꞌatemuyamuyaimi, weyahina ꞌomi tohanugetao mata gibugibumi, wagwae, ‘Ceguma taiya Hada Heꞌasisi saninega ꞌiꞌetaꞌwataꞌwalulu beno geya ꞌaigeda toꞌaha, ma hesi ꞌeguma taiya goulaedi Hada Heꞌasisi ꞌalona ꞌoidiyega ꞌiꞌetaꞌotaꞌolulu beno ginaula madouna, ꞌoinega ꞌilobwaineya ma ginaulaina ꞌipaihowa.’ ");
INSERT INTO bdd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Moisa, ꞌomi yauyauleimi ma mata gibugibumi! Toꞌaha madouna? Hada Heꞌasisi ꞌana goula? bo Hada Heꞌasisi tauna ꞌoinega goula ꞌiheꞌasisiyeya? ");
INSERT INTO bdd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ma wete wagwae ꞌabehega ꞌeguma taiya ꞌebe pwaoli saninega ꞌiꞌetaꞌolulu, beno geya ꞌaigeda toꞌaha, ma hesi ꞌeguma ꞌiꞌetaꞌwalulu pwaoliina ꞌebe pwaoli ꞌoina, beno ginaula madouna, ꞌoinega toꞌaha ꞌigwae hemiseya, sawasawahina ma ꞌipaihowa.’ ");
INSERT INTO bdd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Comi yauyauleimi! Toꞌaha madouna? Pwaoliina, bo ꞌebe pwaoli tauna ꞌoinega pwaoliina ꞌiꞌabihe ꞌasisiyeya? ");
INSERT INTO bdd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Coinega ꞌeguma taiya ꞌebe pwaoli saninega ꞌiꞌetaꞌwalulu, tauna wete ginaula mabwaiyana ꞌebe pwaoli ꞌoina ꞌoidiyega ꞌiꞌetaꞌwataꞌwalulu. ");
INSERT INTO bdd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma wete ꞌeguma taiya Hada Heꞌasisi saninega ꞌiꞌetaꞌwataꞌwalulu, tauna wete Hada Heꞌasisi ꞌana tomiya saninega ꞌiꞌetaꞌwataꞌwalulu. ");
INSERT INTO bdd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma ꞌeguma taiya galewa saninega ꞌiꞌetaꞌwalulu, tauna Yehoba ma wete ꞌina ꞌebemiya saninega ꞌiꞌetaꞌwataꞌwalulu. ");
INSERT INTO bdd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Comi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi hesi, weyahina toꞌabo ꞌomi. Moisa ꞌimi helauwedi ꞌausala weyahina ꞌimi helauwedi ꞌimi ginaula mabwaiyadi ꞌoidiyega, tobwatobwa madoudi ma wete ginaula ꞌiꞌiudi, gide hali pam ma hali pam ꞌoidiyega, ma hesi loina ꞌetoi madoudi wanuwanaidediya, beno mumuga dumwaluna ma ꞌatemuyamuya ma hemisa. Sowasowana ma ginaula bewa madoudi wapaihowadi, ma wete sahena ginaula ꞌiꞌiudi wanuwanuwa naidedi. ");
INSERT INTO bdd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ma ꞌomi tohanugetao mata gibugibuimi, ꞌami ꞌwayahi ꞌoinega sohusohu waꞌewa yahuledi ma hesi hebai madouna, kameli gide watonetonedi. ");
INSERT INTO bdd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Comi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi hesi, weyahina ꞌimi ꞌabowega biyo ma gaeba ꞌatamanega wabuyodiya, ma ꞌalodiya biꞌibiꞌidi, beno yagaha ma mumuga galadi simaha. ");
INSERT INTO bdd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Comi Palisiyao mata gibugibuimi, ꞌimi biyo ta ꞌimi gaeba ꞌalodi waꞌabi heꞌehau nugetedi, ma ꞌoinega wete ꞌatamanega waꞌabi heꞌehaudi. ");
INSERT INTO bdd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Comi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi weyahina ꞌomi toꞌabo, gide tuwa galiha waꞌewaꞌeꞌedi ma ꞌausaladi, tabwana ꞌadi ꞌita ꞌausala hedade, ma hesi ꞌalodiya tomota hilihiliyadi ma ginaula biꞌibiꞌidi simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Comi ꞌami ꞌita tomota matadiya ꞌabehega tohanugetao ꞌausalami, ma ꞌalomiya ꞌabo ma gala baibaiwana simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Comi loina ꞌana toheꞌitao ma Palisiyao ꞌatemuyamuyaimi ta toꞌabowao, weyahina palopitao nugenugetadi ꞌadi galiha ꞌoidiya ꞌadi ꞌebe nuwatuhuyahina waꞌabidiya, ma wete tobwebweꞌana mwalo hene ꞌadi ꞌebe nuwatuhuyahinao waꞌatububudiya, ");
INSERT INTO bdd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ma wagwae, ‘Ceguma mwalo hene tamiyamiya tubudao ꞌidi tuta, sahena tubudaowedi talemelemedi palopitao ꞌadi loheꞌamasa weyahina.’ ");
INSERT INTO bdd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cimi gwae bewa ꞌoinega wahepwaila pwaiya ꞌabehega palopitao ꞌadi toloheꞌamasao tubudiyao ꞌomi. ");
INSERT INTO bdd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Coinega taudi ꞌidi paihowaedi ꞌabwa walosalohidi. ");
INSERT INTO bdd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Comi mwata natunao, ta geya sawasawahina ma ꞌasa ꞌalaꞌalatana* ꞌoinega wadena. ");
INSERT INTO bdd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Coinega palopitao ma tosanapuwao ma loina ꞌana toheꞌitao yahesumanediwa ma nata tupwadi waloheꞌamasidi, nuwana kelose ꞌoina watutu hepaꞌinedi, ma tupwadi ꞌimi hada tapwalolo ꞌoidiya balaeyega wahunudi, ma ꞌasa ꞌaigeda ꞌaigeda ꞌoidiyega wapaꞌidi. ");
INSERT INTO bdd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Ma ꞌana ꞌebelosaloha ꞌoina tobwebweꞌana ꞌadi loheꞌamasa ꞌana maisa mabwaiyana ꞌomi waloba. Loheya nugenugetana Ebeli tauna tobwebweꞌana siloheꞌamasiya, eeta siloloheꞌamasa ꞌana siga Balakaya natuna Sakaliya wete siloheꞌamasiya Hada Heꞌasisi ma ꞌebe pwaoli gamwagamwanidiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Moisa, loheꞌamasaidi mabwaiyadi ꞌadi maisa nata ꞌomi mehau bewa waloba. ");
INSERT INTO bdd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalema yo! Togidega ta palopitao ꞌuloheꞌamasidiya ma wete Yehoba ꞌina tohalewasao galewega ꞌulodaꞌulediya. Tuta baibaiwana nuwanuwagu ma ꞌino tomotaiyao yabwau heꞌautedima gide ꞌamꞌam natunao pepenega ꞌiꞌahusamudiya, ma tuwa silogwahategauwa. ");
INSERT INTO bdd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Coinega Yehoba nata ꞌiꞌebesinego ma maꞌino pui tuwa ꞌumiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta yahegwaego ꞌabehega sahena wete ꞌuꞌitaꞌita hilegau ma ꞌana siga ꞌino tomotaiyao sitagwala ꞌoiguwa ma sigwae, ‘Tahepwatuwe tauna Yehoba saninega ꞌinaoma.’” ");
INSERT INTO bdd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Coinega Yesu Hada Heꞌasisi saugaina ma ꞌiꞌebesine ma ꞌana tomuliyao sinaoma ta Hada Heꞌasisi ꞌana hadao Yesu ꞌoina siheꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Yesu ꞌigwaeya, “Hadaedi mabwaiyadi waꞌebubudi, yagwae bwaibwaina ꞌabwa mabwaiyadi sileꞌwa yahuledi ma sahena wete tupwa ꞌiꞌiuna waꞌitaꞌita hila.” ");
INSERT INTO bdd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Muliyetega ꞌitauya Olibe ꞌoyana ꞌoina ta ꞌimiyatoiya, ma ꞌana tomuliyao ꞌoina sinaoma ta siboidimo simiyamiya ma ꞌoinega sihesilaleya, sigwaeya, “Bada, ꞌuhegwaemai to tuta ꞌoina Hada Heꞌasisi sileꞌwa, ma ꞌino tuta hilama, ma tuta ꞌana ꞌebelosaloha weyahina ꞌadi ꞌilaꞌilala ꞌuheꞌitemai ma ꞌasanapu.” ");
INSERT INTO bdd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Coinega Yesu ꞌihegwaediya, ꞌigwae, “Waꞌitayahigemi ꞌamuge ma tomota tupwadi siꞌabowegomi. ");
INSERT INTO bdd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Weyahina ꞌabwa baibaiwadi saniguwega sihepwaila ma ꞌabehega sihanugete puigomi ma ꞌaigeda ꞌaigeda ꞌigwae, ‘Taugu Toꞌabiheteina,’ ma tomota baibaiwadi simuliyedi. ");
INSERT INTO bdd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wete wasa ꞌabwa wahesagohedi ꞌalehao deimiya ma bwaga weyahidi, ma sahena waꞌateꞌateyoho. Weyahina ginaula bewa silatu nugeta ma hesi baleꞌu ꞌana ꞌebelosaloha ꞌabwa. ");
INSERT INTO bdd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Weyahina ꞌabwa hali boda ma hali boda ꞌoidiya siloꞌaleha, ma wete hali ꞌebeloina ma hali ꞌebeloina ꞌoidiyega siloꞌaleha, ma gomale madouna ma mwaniꞌiniꞌi silatu tupwa mabwaiyadi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ginaulaedi tuta mwaudi ꞌadi ꞌebehegaina tuwa. ");
INSERT INTO bdd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Comi nata tomota siꞌabiyahigomi ma siꞌabihe muyemuyegomi nuwana siloheꞌamasigomi, ma tupwa mabwaiyadi tomotainao siloꞌalehegomi weyahina ꞌabehega ꞌomi ꞌagu tohemisao, ");
INSERT INTO bdd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ma mwauwedi weyahidi ꞌabwa tupwami waweꞌa ma waboimo ꞌiyamiyao watebaedi, nuwana waloꞌalehedi. ");
INSERT INTO bdd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wete palopita ꞌaboꞌabowao silatuma ma tupwami sihanugete puigomi. ");
INSERT INTO bdd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma wete mumuga galana ꞌina madou ꞌoinega tomota tupwana baibaiwana ꞌidi helau ꞌatediyega ꞌiweꞌa. ");
INSERT INTO bdd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma ꞌeguma taiya ꞌiheꞌalamaꞌiꞌita ma ꞌitoholo paꞌala ma ꞌana siga tuta ꞌana ꞌebelosaloha ꞌoina, yaliyaya hataya ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Ma Yehoba ꞌina loina tetelina ꞌiꞌedadana nugeta tupwa mabwaiyana ꞌoidiya, ma boda mabwaiyadi ꞌana loguguya sihesagohe, ma muliyetega tuta ꞌana ꞌebelosaloha ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Cabwa ꞌilaꞌilalaina palopita Daniyela ꞌihepwaila nugetaeya ꞌilatu, beno ginaula gala hedade ma didiga tupwa heꞌasisi ꞌoina ꞌitoholo. (Ceguma taiya gwae bewa ꞌihasili ꞌinuwasabwalena.) ");
INSERT INTO bdd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tuta nage ꞌoina Yudiya ꞌana tomiyanao sawasawahidi ma ꞌoya ꞌoidiya sidena. ");
INSERT INTO bdd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma ꞌeguma taiya wagahata ꞌimiyamiya ꞌidena mwayamwayau, ma sahena ꞌiluhuluhu hila ꞌina hada ꞌina tobwatobwa sabi ꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ꞌeguma taiya tanoha ꞌipaipaihowa sahena ꞌihilahila ꞌana ꞌaleꞌo hali tupwa ꞌilaguya sabi ꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Ma tuta nage ꞌoina togamwagamwao ma tohesusuwao siheꞌatemuyamuya. ");
INSERT INTO bdd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Coinega waꞌahwanoi ma tuta ꞌausalana Yehoba ꞌiꞌebwaegomi ꞌimi tuta dena ꞌoina, ma sahena gogai ꞌana tuta, bo nuwana Sabati ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Moisa, tuta nage mwau hedade, weyahina baleꞌu ꞌana hemasalaha hohau ꞌoinega eeta ꞌana siga tuta bewa, geya ꞌaigeda wete mwauina bewa gide, ma muliyetega mwau bewa sahena wete ꞌilatulatu hilama. ");
INSERT INTO bdd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mwau nage ꞌana sabwelowao ꞌeguma Yehoba sahena ꞌiꞌabiꞌabi hetoꞌutoꞌupadi, nata tomota mabwaiyadi siꞌamasa, ma hesi Yehoba sabwelowedi ꞌiꞌabihe toꞌutoꞌupadi beno ꞌina boda heheꞌasaidi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Coinega ꞌeguma taiya ꞌihegwaegomi ma ꞌigwae, ‘Keliso bewa,’ nuwana ‘Nage,’ sahena wahehemisedi. ");
INSERT INTO bdd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Weyahina Keliso ꞌaboꞌabodi ma palopita ꞌaboꞌabodi ꞌabwa silatu ma ꞌilaꞌilala waiwaidi tomota matadiya sipaihowaidi, ma ꞌoidiyega ꞌeguma sawasawahidi Yehoba ꞌina bodao heheꞌasaidi wete sida ꞌabiheꞌwanidi. ");
INSERT INTO bdd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma ꞌomi ginaula bewa weyahina yahepwaila nugeta pwaiya ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Coinega ꞌeguma sihegwaegomi, sigwae, ‘Keliso tupwa balabala ꞌawawa ꞌimiyamiya,’ sahena pwatula nage ꞌoina watautauya. Ma ꞌeguma sigwae, ‘Keliso hada ꞌalona ꞌimiyamiya,’ sahena wahehemisedi. ");
INSERT INTO bdd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Taugu Loheyaiguina ꞌigu latu hilama ꞌana ꞌita gide tuwa namala madouna yalasiyega ꞌiꞌasilala ta ꞌana siga bwauli. ");
INSERT INTO bdd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Taꞌeha ꞌoina ꞌwayoha ꞌimiyamiya beno ꞌoina ꞌaoꞌao siꞌauꞌautama. ");
INSERT INTO bdd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ma tuta mwauina ꞌigumwala ma muliyetega sinala ꞌiguguyou, ma wete waiꞌena ꞌina ꞌasilala ꞌigibogibo, ma ꞌipwalao galewega sigubala, ma ginaula baibaiwadi galewa simiyamiya ꞌidi waiwai siweꞌa. ");
INSERT INTO bdd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tuta nage ꞌoina taugu Loheyaiguina ꞌigu ꞌilaꞌilala galewega ꞌilatuma, ma boda mabwaiyadi baleꞌuwa siꞌitegau yaloha pwatanega maꞌigu waiwai ma maꞌigu wasawasa madouna yalatulatuma, ma sidougwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma wete yoguli simuꞌa ma ꞌigu aneloseyao yahesumanedi ma ꞌigu boda hesihesinuwaidi siheꞌautedima baleꞌu mabwaiyana ma yaumai mabwaiyana ꞌidi tupwa ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Cebeꞌita saido ꞌoinega yaheꞌitegomi, beno ꞌeguma saido ꞌigalugalu wasanapuya losihe ꞌana tuta deina. ");
INSERT INTO bdd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ma wete ꞌeguma ꞌilaꞌilalaedi bewa waꞌitaloba pwaidiya wasanasanapu ꞌabehega ꞌigu tuta hilama deina ꞌilatu pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moisa, yaso bewa nata geya wagumwala ma ꞌana siga ginaulaedi mabwaiyadi silatu. ");
INSERT INTO bdd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cabwa galewa ma baleꞌu sisawala, ma ꞌigu gwaeyao geyaꞌabwa tuwa sisawasawala. ");
INSERT INTO bdd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Geya ꞌeta taiya ꞌisanapu to tuta, nuwana to sabwelo ꞌoina yahilama, ma wete aneloseyao galewa geya sisanapu. Taugu wete geya yasanapu. Tamagu ꞌiboinamo ꞌisanapuya. ");
INSERT INTO bdd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tuta nage, Nowa ꞌina tuta gide. ");
INSERT INTO bdd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Weyahina Nowa ꞌina tuta tomota ꞌadi siꞌaiꞌai ma ꞌadi weꞌaha sinumanuma ma sihehehai, ma wete sihaihai, ma ꞌana siga Nowa ꞌina waga ꞌigeluwa, ");
INSERT INTO bdd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ma yagewa ꞌiloheꞌateyohodiya, ta ꞌoinega tomota mabwaiyadi sidamana, ma taugu Loheyaiguina ꞌigu hilama gide. ");
INSERT INTO bdd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Tuta nage ꞌoina ꞌeguma loheya ꞌeluwa tanoha, ꞌaigeda yatoe ma ꞌaigeda ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wete ꞌeguma wahiwahine siteluwa siꞌeꞌehalo, ꞌaigeda yatoe ma ꞌaigeda ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Coinega waꞌitayahi bwaibwaini, weyahina ꞌigu hilama ꞌana tuta geya wasanapu. ");
INSERT INTO bdd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma wanuwatuhuyahi ꞌeguma taiya hada toniwagana ꞌisanapuya ma to tuta nihuwana ꞌalona toyagaha ꞌiluhu ꞌina hada, ꞌiꞌatububu bwaibwaina ma ꞌiꞌoꞌoyatola, ma sahena ꞌina hada ꞌibwalebwale. ");
INSERT INTO bdd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Coinega ꞌomi wete waꞌatububu bwaibwaina, ma ꞌigu tuta hila weyahina wayamwegau, weyahina taugu Loheyaiguina ꞌigu hilama ꞌana tuta geya wasanapu. ");
INSERT INTO bdd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Topaihowa ꞌausaladi ma sanasanapuidi ꞌidi mumuga bewa gide: Ceguma taiya tauna ꞌina bada ꞌihesinuweya ma hada ꞌiꞌitayahi ma topaihowao ꞌadi ꞌeꞌahai ꞌiꞌebwaedi sabwelo ꞌaigeda ꞌaigeda ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ꞌabwa ꞌeguma badaina ꞌihilama ma ꞌina topaihowaina ꞌiloba ꞌipaipaihowa dumwalu, nata weyahina ꞌiyaliyaya ma ꞌoina ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","‘Cino paihowa ꞌausaladi weyahina yayaliyaya, ꞌoinega ginaula mabwaiyadi ꞌadi loina yaꞌebwaego ma ꞌuloina.’ ");
INSERT INTO bdd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ma hesi ꞌeguma topaihowa ꞌimumuga galana ma ꞌiboinamo ꞌoina ꞌigwae, ‘Cigu bada ꞌabwa ꞌiheheboi,’ ");
INSERT INTO bdd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma ꞌihegaina ma ꞌiyanao ꞌisapi dadanedi ma ꞌiꞌai hedahedade, nuwana ꞌinuma hedahedade toheyauyaule baꞌidanao, ");
INSERT INTO bdd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ma ꞌoinega ꞌina bada ꞌeguma ꞌiloheꞌateyohoyama ma ꞌina paihowa galana ꞌiꞌitalobadi, ");
INSERT INTO bdd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nata hadega ꞌipaꞌi ma maisa galana ꞌiꞌebwae toꞌabowao ꞌidi tupwa, nage ꞌoina sidou ma sihesalaꞌiꞌita, muya ꞌoinega”. ");
INSERT INTO bdd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma Yesu ꞌihegwaediya wete, ꞌigwae, “Yehoba ꞌina loina bewa gide: wahiwahine site teni ꞌidi mayale siꞌewediya ma sitauya tohai meloheyana sabi helatuina ꞌina hai guyaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Coidiyega site paibi yauyauleidi ma site paibi sanapudi. ");
INSERT INTO bdd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Toheyauyauleyedi ꞌidi mayale geya ꞌana weꞌaha ꞌana lohepoi siꞌewa, ");
INSERT INTO bdd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ma hesi taudi tosanapuwedi maꞌidi weꞌaha ꞌana lohepoi ꞌidi botolo ꞌoidiya siꞌahalidiya ꞌidi mayaleyao baꞌidanao. ");
INSERT INTO bdd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Ma tohai meloheyana ꞌiheboiya, ꞌoinega mabwaiyadi siloloyamwana ta siꞌeno sinediya. ");
INSERT INTO bdd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Coinega nihuwana gamwana loheya ꞌaigeda ꞌibwauwa, ꞌigwae, ‘Tohaiina bewa ꞌilatu pwaima, watoholo ma tayoꞌo. ");
INSERT INTO bdd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Coinega wahiwahineyedi mabwaiyadi sitoholowa, ta ꞌidi mayale siꞌatububudiya. ");
INSERT INTO bdd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Coinega wahiwahineyedi yauyauleidi ꞌiyadiyao ꞌoidiya siꞌahwanoiya, sigwaeya, ‘Ciyamayao, mayale ꞌana weꞌaha tupwana waꞌebwaemai, weyahina ꞌima mayale nata sigibo.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma sanapudiyedi sigwaeya, ‘Nuwana geya ꞌima weꞌaha sawasawahina ma tupwana ꞌaꞌebwaegomi, ꞌoinega ꞌomi watauya tohegimwaneyao ꞌoidiya ma ꞌimi mayale ꞌadi weꞌaha wagimwanedi.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Coinega sitauya sabi gimwane, ma tohai ꞌilatuma, ta taudi siꞌatububu pwaiya baꞌidanao siluhuwa hai ꞌeꞌahaina weyahina, ma ꞌahwa ꞌeda sigududiya. ");
INSERT INTO bdd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muliyetega ꞌiyadiyao gimwaneyega sihilama ma sigwaeya, ‘Bada, ꞌeda ꞌusoꞌe ma ꞌaluhuwa.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma ꞌidi gwae ꞌihemaiseya, ꞌigwae, ‘Comi hali boda, geya yasanapugomi.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Coinega sawasawahimi waꞌitayahi, weyahina sabweloina, nuwana tutaina yalohihilama, geya wasanapu. ");
INSERT INTO bdd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yehoba ꞌina loina wete gide ꞌeguma ꞌaigeda bada nata ꞌitauya hali tupwa, ma ꞌina topaihowao ꞌibwauwedima, ma ꞌihegwaediya ma ꞌabehega ꞌina tobwatobwa siꞌitayahi. ");
INSERT INTO bdd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Ma ꞌaigeda ꞌina mane ꞌina topaihowa ꞌiꞌebwaeya ꞌana baibaiwa paibi handeledi kina, ma loheya heluwena tu handeledi kina, ma loheya hetoina handeledi kina, weyahina ꞌina ꞌebwaya ꞌoidiya taudi ꞌaigeda ꞌaigeda ꞌidi waiwai gide. Ma muliyetega badaina ꞌiꞌebesinediya ta ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Coinega loheyaina tauna maꞌina paibi handeledi kina ꞌina bada ꞌina maneina ꞌiꞌewediya, ta ꞌoidiyega ꞌihepaihoweya, ta ꞌadi loheposeyana paibi handeledi wete ꞌilobediya. ");
INSERT INTO bdd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Loheya heluwena wete gide ꞌina tu handeledi kinaedi ꞌihepaihowediya ta ꞌoidiyega ꞌina bada ꞌina mane ꞌana loheposeyana tu handeledi wete ꞌilobeya. ");
INSERT INTO bdd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma loheya hetoina, tauna maꞌina handeledi kina, ꞌiꞌeweya ta baleꞌu ꞌiꞌeliya, ta ꞌina bada ꞌina maneina ꞌidahweya ꞌalona. ");
INSERT INTO bdd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ta tuta dudulena mulina ꞌidi bada ꞌihilama, ta ꞌihesilalediya ꞌidi paihowa ꞌadi maisa weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma loheya ꞌina mane paibi handeledi kina ꞌinaoma, ta ꞌana loheposeyana paibi handeledi kina wete ꞌiꞌewedima, ta ꞌigwaeya, ‘Bada, paibi handeledi kina ꞌuꞌebwaegauwa ma ꞌana loheposeyana paibi handeledi kina wete yalobeya, ta bewa.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma badaina ꞌigwaeya, ‘Causala, ꞌowa topaihowa bwaibwaina ta dumwaluna. Cuhetapewa pwaiya ginaula ꞌiꞌiudi ꞌoidiyega, ꞌoinega ꞌa loina ginaula madoudi weyahidi yaꞌebwaego, ma wete ꞌigu yaliyaya bewa ꞌoina ꞌumiyamiya.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Muliyetega loheya heluwena maꞌina tu handeledi kina ꞌilatuma, ta ꞌana loheposeyana tu handeledi kina wete ꞌiꞌewedima, ma ꞌigwaeya, ‘Bada, tu handeledi kina ꞌuꞌebwaegauwa ta ꞌana loheposeyana tu handeledi kina wete yalobeya, ta bewa.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Coinega badaina ꞌigwaeya, ‘Causala, ꞌowa topaihowa bwaibwaina ta dumwaluna, ꞌuhetapewa pwaiya ginaula ꞌiꞌiudi ꞌoidiyega, ꞌoinega ꞌa loina ginaula madoudi weyahidi yaꞌebwaego, ma ꞌowa wete ꞌigu yaliyaya bewa ꞌoina ꞌumiyamiya.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Eeta loheya hetoina maꞌina handeledi kina ꞌinaoma, ma ꞌigwaeya, ‘Bada, yasanapugowa ꞌabehega ꞌowa loheya paꞌaliu, ma ꞌino wasawasa ꞌuꞌewaꞌewa hali tomota ꞌidi paihowa ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ꞌoinega yamatautegowa, ta ꞌino handeledi kinaina baleꞌu ꞌalona yadahweya, ta ꞌino mane bewa.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma badaina ꞌiheliyeya, ꞌigwae, ‘Topaihowa galau ta tologwahata ꞌowa, ꞌusanapugauwa ꞌabehega ꞌigu wasawasa yaꞌewaꞌewa hali tomota ꞌidi paihowa ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ꞌeguma ꞌigu mane banika ꞌoina ꞌuda laguya, beno tutaina yahilama ma ꞌana lohepoi yaloba!’ ");
INSERT INTO bdd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta ꞌina ꞌaliꞌeyao ꞌoidiya ꞌigwaeya, ‘Cigu handeledi kina ꞌoinega waꞌewa, ma loheyaina tauna loheposeyana madouna ꞌilobeya ꞌoina waꞌebwae. ");
INSERT INTO bdd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Weyahina ꞌeguma taiya ꞌana heguheguyai ꞌiloheposeyane, ꞌana loheposeyana wete ꞌiloba, ma ꞌimadou; ma ꞌeguma taiya geya ꞌiloheposeyane, toꞌaha ꞌoina ꞌimiyamiya ꞌoinega ꞌabwa siꞌewa yahule.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Coinega ꞌina ꞌaliꞌeyao ꞌihegwaedi ma topaihowa galanaina siula latuhe ꞌatamana guguyou tupwaina ꞌoina, ma nobwa tomota maꞌidi muyamuya sidoudou ma sihesalaꞌiꞌita baꞌidanao. ");
INSERT INTO bdd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cabwa taugu Loheyaiguina, maꞌigu wasawasa ꞌasiꞌasilalaina, ma maꞌigu aneloseyao ꞌalatuma, ma ꞌoinega ꞌigu wagahata wasawasa ꞌoina yamiyatoi sabi loina, ");
INSERT INTO bdd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ma ꞌebeloina baleꞌuwa mabwaiyadi tomotaedi mataguwa siheꞌautedima, ma yawatahidi gide sipi ꞌadi toꞌitayahina ꞌiwatahidi goti ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ma sipi yalagu wasiyedi ꞌigu ꞌebeulega ma goti ꞌigu ꞌadigeyegeyega. ");
INSERT INTO bdd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ma ꞌoinega toloina taugu taudi ꞌigu ꞌebeula ꞌoina yahegwaedi ma yagwae, ‘Comi Tamagu ꞌina helauwega wayaliyaya, wanaoma ma ꞌimi ꞌebeloinaina waꞌewa, beno baleꞌu ꞌana hemasalaha hohau ꞌoinega ꞌiꞌatububuya weyahimi. ");
INSERT INTO bdd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Weyahina ꞌomi mwalo yagomaleya ma waheꞌaigauwa, ma wete taniꞌogu ꞌiyahala ma weꞌaha waꞌebwaegauwa, yahesugalagala ꞌimi ꞌasa ma wabwauwegauwa ꞌimi hada, ");
INSERT INTO bdd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ma wete geya ꞌagu ꞌaleꞌomo ma waheꞌotegauwa, wete yalohala ma waboꞌenegauwa, ma wete deli ꞌoina yamiyamiya ma waboꞌenegauwa.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Coinega todumwaluwedi ꞌoiguwa sigwae, ‘Bada, to tuta hede ꞌaꞌitegowa ma ꞌa gomale ma ꞌaheꞌaigowa, nuwana taniꞌou ꞌiyahala ma weꞌaha ꞌaꞌebwaegowa, ");
INSERT INTO bdd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","nuwana ꞌuhesugalagala ꞌima ꞌasa ta ꞌabwauwegowa ꞌima hada, nuwana geya ꞌa ꞌaleꞌomo ma ꞌaheꞌotegowa, ");
INSERT INTO bdd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","nuwana maꞌa lohala, nuwana deliya ꞌumiyamiya ma ꞌaboꞌenegowa?’ ");
INSERT INTO bdd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Coinega yagwae ꞌoidiya, ma yagwae, ‘Moisa, ꞌeguma taiya ꞌowa ꞌiyagwao ꞌiꞌiudi ꞌaigeda ꞌoidiyega ꞌuꞌabihete, beno taugu wete ꞌuꞌabihetegau.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma taudi ꞌigu ꞌadigeyageya simiyamiya yahegwaedi, ‘Comi togala waꞌebesinegau, ma watauya ꞌaiwe ninima hatayana ꞌoina, tauna Yehoba ꞌiꞌatububuya Tomudulele ma ꞌina bodao weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Weyahina mwalo maꞌagu gomale ma geya waheꞌaigau, wete taniꞌogu ꞌiyahala ma geya ꞌaigeda wete weꞌaha waꞌebwaegau, ");
INSERT INTO bdd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ma yahesugalagala ꞌimi ꞌasa ma geya wabwauwegau ꞌimi hada, ma geya ꞌagu ꞌaleꞌomo ma geya waheꞌotegau, wete yalohala ma wete deliya yamiyamiya ma geya wahaboꞌenegau.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Muliyetega taudi gwae bewa sihemaise, ma sigwae, ‘Bada, to tuta ꞌaꞌitegowa maꞌa gomale, nuwana taniꞌou ꞌiyahala, nuwana ꞌuhesugalagala, nuwana geya ꞌa ꞌaleꞌomo, nuwana ꞌulohala, nuwana deliya ꞌumiyamiya, ma geya ꞌalemego?’ ");
INSERT INTO bdd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma yahegwaedi, ‘Moisa, tutaedi ꞌoidiya ꞌeguma tomota ꞌiꞌiudi bewa ꞌaigeda geya waꞌabihete, beno ꞌoina geya walemegau.’ ");
INSERT INTO bdd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Coinega taudi sitauya muya hataya ꞌoina, ma todumwalu hesi yawasi hataya siloba.” ");
INSERT INTO bdd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu ꞌina heꞌitaedi bewa ꞌilosalohiya, ma ꞌana tomuliyao ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ꞌigwaeya, “Wasanapuya sabwelo ꞌeluwa ma Hataona Guyaina tapaihowa, ma ꞌoinega taugu Loheyaiguina ꞌagu toteba ꞌiꞌebwaegau ꞌagu ꞌalehao ꞌoidiya, ma kelose ꞌoina siloheꞌamasigau.” ");
INSERT INTO bdd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Coinega topwaoli madoudi ma meIsileli ꞌidi babadao siꞌetoꞌautama Kaiyapa ꞌina hada madouna ꞌoina, tauna topwaoliyedi ꞌidi bada madouna. ");
INSERT INTO bdd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta babadaowedi taudimo siloina ma ꞌabehega ꞌabowega Yesu siꞌabiyahi ma siloheꞌamasi, ");
INSERT INTO bdd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ta sigwaeya, “Sahena guyai ꞌalona Yesu taꞌabiꞌabiyahi, ꞌamuge ta tomota sigamwasowala ma siloꞌaleha ꞌoida.” ");
INSERT INTO bdd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tutaina Yesu Bedani ꞌoina ꞌimiyamiya, Saimoni ꞌina hada. Tauna mwalo tolepelo ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Coinega ꞌaigeda wahine maꞌina holowa ꞌilatuma, ma holowaina ꞌana maisa madouna, ma botolo bwebweꞌana hedade ꞌoina sisiweya. Yesu ꞌabwa hadai ꞌiꞌaiꞌai, ma wahineina ꞌilatuma ta holowaina Yesu debana ꞌisiweya. ");
INSERT INTO bdd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma Yesu ꞌana tomuliyao siꞌiteya, ta wahineina silomugiyeya, sigwaeya, “Toꞌaha weyahina holowa ꞌimudaliya? ");
INSERT INTO bdd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cilobwaineya ma holowaina ꞌigimwaneye, ma maisa madouna ꞌiꞌewa, ma ꞌiheguyai tohewewelohe ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Yesu ꞌidi gwaeina ꞌisanapuya ta ꞌihegwaediya, ꞌigwae, “Sahena walolomugiye wahine bewa, ꞌina paihowa ꞌoiguwa bwebweꞌana hedade. ");
INSERT INTO bdd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Toheweweloheyedi wagwaegwaenedi tuta mabwaiyana simiyamiya deimiya, ma hesi taugu geya tuta dudulena baꞌidamiu tamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wahine bewa ꞌiheholowa pwaigauwa wahigu ꞌana lagu galiha weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yagwae moisa ꞌoimiya, ꞌabwa wasagu tomota siꞌoteteli baleꞌu mabwaiyana ꞌoina, ma wahineina ꞌina paihowa ꞌoiguwa wasana wete siꞌoteteli.” ");
INSERT INTO bdd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma Yesu ꞌana tomuliyao ꞌaigeda sanina Yudasa Isakaliyota ꞌitauya topwaoli madoudi ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma ꞌihegwaediya ꞌigwae, “Cehisa maisa nata waꞌebwaegau, ꞌeguma Yesu ꞌoimiya yatebaeyawa?” Ta mane siliba ꞌana baibaiwa teti siꞌebwaeya. ");
INSERT INTO bdd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Coinega Yudasa tuta bwebweꞌana ꞌiyamweya ma ꞌabehega Yesu ꞌoidiya ꞌitebae ma siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hataona ꞌaiina beledi daisina, geya ꞌana ꞌabihesesehamo siꞌaiꞌai. Ta Hataona ꞌaiina ꞌana sabwelo nugeta ꞌoina Yesu ꞌana tomuliyao tupwadi ꞌoina sinaoma ma sigwaeya, “Bada, taꞌeha ꞌoina nuwanuwau ma Hataona ꞌeꞌahaiina weyahiu ꞌaꞌatububu?” ");
INSERT INTO bdd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Coinega Yesu ꞌigwaeya, “Watauya Yelusalema ma ꞌigu ꞌahwanoi ꞌaigeda loheya ꞌoina wahepwaila, wagwae, ‘Cima toheꞌita ꞌina gwae bewa gide, ꞌabehega “Cigu tuta ꞌilatu pwaiya ma nuwanuwagu ma ꞌino hadai Hataona ꞌaiina maꞌagu tomuliyao ꞌaꞌai.”’” ");
INSERT INTO bdd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ta tomuliyaedi Yesu ꞌina gwaeina simuliyeya, ta loheyaina ꞌina hada Hataona ꞌaiina siꞌatububuya. ");
INSERT INTO bdd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Coinega lahilahiya Yesu maꞌana tomuliyao site tuwelowedi siluhuwa ta ꞌeꞌahaiina siꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma ꞌidi ꞌaiina ꞌoina Yesu ꞌigwaeya, “Ciyagwao, yagwae moisa ꞌabehega ꞌaigeda ꞌoimiyega nata ꞌitebaegau.” ");
INSERT INTO bdd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma Yesu ꞌina gwae bewa weyahina sinuwagala moisa, ta ꞌaigeda ꞌaigeda Yesu ꞌoina ꞌihesilala ꞌigwaeya, “Bada taiya tauna? Nuwana taugu?” ");
INSERT INTO bdd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma Yesu ꞌihegwaediya, “Loheyaina tauna baꞌidagu gaeba ꞌaigeda ꞌoinega ꞌaꞌaiꞌai, tauna nata ꞌitebaegau. ");
INSERT INTO bdd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Taugu Loheyaiguina ꞌabwa yatautauya ꞌedaina mwalo Buki Heꞌasisi ꞌoina sihepwaila nugeteya, ma hesi ꞌagu totebaina ꞌatemuyamuyaina, ma bwebweꞌana ꞌeguma mwalo sahena sinana ꞌihehenatune.” ");
INSERT INTO bdd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Coinega ꞌana toteba Yudasa ꞌihegwaeya, “Bada to loheya tauna? Nuwana taugu?” Ta Yesu ꞌigwaeya, “Cugwae pwaiya boꞌi.” ");
INSERT INTO bdd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Siꞌaiꞌai ma Yesu ꞌeꞌahai ꞌiꞌeweya ta weyahina ꞌigwae helauwa, ma ꞌiꞌabihisiya ta ꞌana tomuliyao ꞌiꞌebwaediya, ꞌigwaeya, “Bewa wahigu waꞌewa ma waꞌai.” ");
INSERT INTO bdd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma waini mabiyona wete ꞌiꞌeweya, ma weyahina ꞌiloyauwedowa Yehoba ꞌoina, ma ꞌiꞌebwaediya, ma ꞌigwaeya, “Mabwaiyami wanuma. ");
INSERT INTO bdd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bewa bweyahigu, loina hauhauna weyahina, ꞌidaudau tomota mabwaiyami ꞌimi puiyao ꞌadi ꞌebe nuwasam weyahina. ");
INSERT INTO bdd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma yahegwaegomi tuta bewa ma mulina waini bewa geyaꞌabwa ꞌoinega yanumanuma hila ta ꞌana siga ꞌomi baꞌidagwao waini hauhauna tanuma Tamagu ꞌina tupwa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Coinega wali ꞌaigeda siwaliyeya ta silatuwa, ma sihaneya ꞌoya Olibe ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Yesu ꞌihegwaediya, ꞌigwae, “Nata nihuwana mabwaiyami wadena sinegau, gide Buki Heꞌasisi ꞌina hepwaila ꞌigwaeya, ‘Toꞌitayahina sipi yaloheꞌamasi ma sipi silelewana.’ ");
INSERT INTO bdd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma taugu ꞌigu toholo hila mulina Galili ꞌoina yatautauya, ta ꞌomi muliguwega wanaowa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Coinega Pita ꞌiꞌapulagata ma ꞌigwaeya, “Nata mabwaiyadi sidena sinego ma taugumo baꞌidau.” ");
INSERT INTO bdd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Yesu Pita ꞌihegwaeya, “Yagwae moisa, nihuwana nata, muliyetega ꞌabwa ꞌamꞌam ꞌidou, ma ꞌowa matoi ꞌuuhalegau.” ");
INSERT INTO bdd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Pita ꞌigwaeya, “Bada, sahena hede yauhauhalego! Ceguma siloheꞌamasigo taugu baꞌidau wete siloheꞌamasigita.” Tomuliyao mabwaiyadi wete gide sihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Eeta Yesu ꞌana tomuliyao baꞌidanao sihapwesa tupwa sanina Gedesemani, ma ꞌihegwaediya, ꞌigwae, “Cebwa wamiyatoi ma yanao nobwa tupwaina yaꞌahwanoi Tamadai ꞌoina,” ");
INSERT INTO bdd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ma hesi sitetoiyedi baꞌidanao ꞌitoediya, taudi Pita ma Sebedi natunao, ma ꞌinuwagala madouna, nuwana ꞌisiwapa, ");
INSERT INTO bdd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ꞌihegwaediya ꞌigwae, “Yanuwagala madouna, gide ꞌabwa yaꞌamasa, ꞌebwa wamiyamiya, waꞌoꞌoyatola ma baꞌidagwao taꞌahwaꞌahwanoi.” ");
INSERT INTO bdd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma ꞌihanaowa tupwana ta ꞌibeꞌusuluwa, ꞌiꞌahwanoi, ꞌigwaeya, “Tamagu yo, ꞌeguma sawasawahina muyamuya biyoina bewa ꞌoiguwega ꞌuꞌewa ma geyaꞌabwa yanumanuma, ma hesi geyaꞌabwa ꞌigu nuwatuhuwega, ꞌowa tuwa ꞌino nuwatuhu gide ꞌupaihowe.” ");
INSERT INTO bdd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cigumwala, ma ꞌihilama ꞌana tomuliyao ꞌilobediya siꞌenosinediya, ma Pita ꞌilohanohanoya, ꞌihegwaeya, ꞌigwae, “Geya sowana sauga ꞌiꞌiuna tuwa waꞌoꞌoyatola ma waꞌabihetegau. ");
INSERT INTO bdd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hede waꞌoꞌoyatola waꞌahwaꞌahwanoi ꞌabehega sahena waluhuluhu ꞌebe tohona ꞌoina. Yaluyaluwami nuwanuwana ma hesi wahimi siweꞌa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cigumwala, ꞌihanaowa wete, ꞌiꞌahwanoiya, ꞌigwae, “Tamagu yo, ꞌeguma geya sowana muyamuya biyoina ꞌuꞌewa, ma ꞌeguma ꞌino nuwatuhu gidemusa, tuwa yanuma.” ");
INSERT INTO bdd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eeta ꞌihilama wete ꞌana tomuliyaowedi ꞌilobediya wete siꞌenosinediya, weyahina mataꞌenoꞌeno ꞌiꞌewa pwaidiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Coinega ꞌiꞌebesinediya ꞌebwa, ꞌinaohila ma ꞌiꞌahwanoi matoina, gide nige ꞌiꞌahwanoi ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cigumwala, ꞌihilama tomuliyaowedi ꞌihegwaediya, “Bwebweꞌana waꞌenoꞌeno, waꞌaiyawasi. Cigu sauga ꞌilatu pwaima, ma ꞌagu totebaina nata taugu Loheyaiguina ꞌitebaegau togalagalaedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Watoholo, tatauya, waꞌita ꞌagu totebaina ꞌilatu pwaima.” ");
INSERT INTO bdd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Cabwa Yesuina ꞌihehegwaegwae, ma Yudasaina ma ꞌina boda baibaiwadi sihapwesama maꞌidi ꞌebe ꞌalehao ma maꞌidi wepasi. Weyahina topwaoli madoudi ma tomota ꞌidi babadao sihewasaedima Yudasa baꞌidanao, ma Yudasaina Yesu ꞌana tomuliya, sitetuwelo ꞌaigeda ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ma Yudasaina nige ꞌebeheꞌita ꞌihesumanediya, ꞌigwae, “Waꞌita ꞌeguma taiya yaꞌatusapwali, beno loheyaina waꞌabiyahi,” ");
INSERT INTO bdd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ma ꞌidumwaluwa Yesu ꞌiꞌatusapwaliya, ta ꞌigwaeya, “Yauwedo Bada.” ");
INSERT INTO bdd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yesu ꞌigwaeya, “Ciyagu, togidega ꞌino naoma?” Cigumwala, ma sitauyama Yesu siꞌabiyahiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Siꞌabiꞌabiyahi ma ꞌiyana ꞌaigeda ꞌina ꞌelepa ꞌaleha ꞌilisiloloya ma toloꞌaleha ꞌaigeda ꞌihunuya ma tenana ꞌiꞌupwa yahuleya. Loheyaina topwaoli madouna ꞌina topaihowa ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Yesu ꞌihegwaeya, “Tuwa, ꞌino ꞌebe ꞌaleha ꞌulagu hila ꞌina ꞌebemiya, ꞌeguma taloloꞌaleha, ꞌabwa ꞌelepa ꞌaleha ꞌoinega taꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ma hesi wada sanapu ꞌabehega sawasawahina yada ꞌahwanoi Tamaguina sauga bewa ma ꞌida ꞌebwaegau ꞌina aneloseyao ꞌidi bodao tausani ma tausaniyao sabi ꞌabihetegau. ");
INSERT INTO bdd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma hesi ginaula bewa mabwaiyana silatulatu ꞌabehega toꞌaha mwalo Buki Heꞌasisi ꞌoina silelediya weyahigu silatuwa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nage ꞌoina Yesu bodaedi ꞌihesilalediya, ꞌigwae, “Taugu ꞌabehega toyagaha ꞌawa, ta maꞌimi ꞌebe ꞌaleha ta maꞌimi wepasi walatuma waꞌabiyahigau. Ma togidega ma mwalo Hada Heꞌasisi ꞌoina yamiyamiya, tomota ꞌoidiya yaheheꞌita ta geya wada ꞌabiyahigauwa? ");
INSERT INTO bdd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma hesi bewa gide wapaihowa ꞌesa ma ꞌabehega togidega palopitaowedi mwalo weyahigu silelediya ma sauga bewa silatuma.” Eema ꞌana tomuliyao mabwaiyadi siꞌebesineya ma sidena. ");
INSERT INTO bdd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Toloꞌalehaowedi Yesu siꞌabiyahiya ma sitoeya topwaoli madouna Kaiyapa matana, nage ꞌoina loina ꞌana toheꞌitao ma babadao siꞌetoꞌautama. ");
INSERT INTO bdd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma hesi Pita ꞌana muliya tupwana bwaga, ma siluhuwa Topwaoli Madouna ꞌina ꞌasa, ma Pitaina wete ꞌiluhuwa ꞌimiyatoiya Topwaoli Madouna ꞌina topaihowao baꞌidanao. Cina nuwatuhu ꞌabehega Yesu ꞌana loina ꞌihesagohe ma ꞌiꞌita. ");
INSERT INTO bdd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eeta topwaoli madoudi ma toloinao baibaiwadi nuwanuwadi Yesu ꞌina pui siloba ma ꞌabehega ꞌina ꞌamasa siloine, ꞌoinega siꞌebeꞌebesa toheꞌewao ꞌaboꞌabodi, ");
INSERT INTO bdd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ma baibaiwadi siheheꞌewa Yesu ꞌina puiyao weyahidi, ma geya ꞌeta ꞌina pui siloba. Eema ꞌebelosaloha ꞌoina siteluwaedi sinaoma, ");
INSERT INTO bdd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sigwaeya, “Yesuina ꞌina gwae ꞌahesagoheya ꞌabehega sowasowana Yehoba ꞌina Hada Heꞌasisi ꞌiligehi yahule ma sabwelo ꞌetoi ꞌoidiya ꞌiꞌabihila.” ");
INSERT INTO bdd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Coinega topwaoli madouna ꞌitoholowa, Yesu ꞌihesilala ꞌigwaeya, “Toꞌaha ꞌino heꞌisa ꞌidi heꞌewa bewa weyahiu?” ");
INSERT INTO bdd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yesu tuwa ꞌihehenonomo. Ma topwaoli madouna ꞌihesilala, ꞌigwaeya, “Yehoba miyamiya hatayana matana ꞌuheꞌisa moisa, togidega ꞌowa Keliso, Yehoba Natuna, bo geya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yesu ꞌigwaeya, “Cino gwaeina gidemusa. Ma wete yahegwaegomi beno ꞌabwa taugu Loheyaiguina waꞌitegau Tohewaiwaina ꞌina ꞌebeulega yamiyatoi sabi loina, ma wete ꞌigu hilama waꞌita galewa yaloha debadiya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bewa ꞌoina topwaoli madounaina ꞌihegamwagamwaguwa ma tauna ꞌana ꞌaleꞌo ꞌiꞌigaliya, ꞌigwaeya, “Yesuina boꞌi Yehoba ꞌisinaliya. Geya sowana toheꞌewa wete sihehegwaegwae, weyahina Yesuina ꞌina gwae gala hedadena tahesagoha pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Togidega ꞌimi nuwatuhu?” Ma mabwaiyadi sigwaeya, “Sowasowana ma ꞌiꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Coinega tupwadi manina siꞌesoheya, ma tupwadi sisapisapiya ta sihehesilala, ");
INSERT INTO bdd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sigwaegwae, “Cabehega ꞌowa Kelisoina, ma sowasowana ꞌuhesumane gide palopita ma ꞌuhegwaemai taiya ꞌisapigowa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma hesi Pitaina ꞌatamana ꞌimiyatoiya ta ꞌiꞌeꞌebubuna, ma gumalaulau topaihowa ꞌitauya ꞌoina ꞌihegwaeya, “Cowa Yesu gwama Galiliina mwalo baꞌidau wamiyamiya, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Pitaina tomotaedi matadiya ꞌimwehihiya, ꞌigwae, “Cino gwaeina huhuna geya yada sanapuya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Coinega Pitaina ꞌihapwesa tupwana, ma ꞌaigeda wete gumalaulau ꞌiꞌiteya, ma ꞌiyanao nobwa ꞌihegwaediya, ꞌigwae, “Bewa loheyaina mwalo Yesu gwama Nasaletaina baꞌidana simiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma weteyage Pitaina ꞌiꞌetaꞌotaꞌoluluwa ꞌimwehihiya, ꞌigwae, “Loheyaina geya yada sanapuya.” ");
INSERT INTO bdd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sauga ꞌiꞌiuna ma tupwadi toꞌebubunaedi Pita deina sinaoma ma sigwae, “Moisa tuwa, ꞌowa Yesu ꞌana tomuliya ꞌaigeda. Cino gwaeina meGalili ꞌidi gwae gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma hesi Pitaina maꞌina gwae galana ꞌibwauhaneya, ꞌiꞌetaꞌotaꞌoluluwa, ꞌigwae, “Loheyaina geya yasanapu.” Ma sauga bewa ꞌoina ꞌamꞌam loheyana ꞌidouwa, ");
INSERT INTO bdd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ma Pitaina ꞌinuwatuhuya Yesu ꞌina gwaeina ꞌabehega “Muliyetega ma ꞌamꞌam ꞌidou ma ꞌowa matoi ꞌumwehihiyegau.” Cinuwatuhuya, maꞌina nuwagala ꞌihapwesa, ta ꞌidouwa madouna. ");
INSERT INTO bdd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gona ꞌiꞌadaleya, topwaoli madoudi ma babada mabwaiyadi siloina Yesu weyahina, nuwanuwadi ꞌabehega siloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Coinega Yesu nimana sipaidiya ma sitauyeya toloina madouna Pailato ꞌoina, ma ꞌabehega Pailatoina ꞌida loina. ");
INSERT INTO bdd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma Yudasaina ꞌisanapuya ꞌabehega Yesu ꞌiꞌiuna ma siloheꞌamasi, ꞌoinega ꞌinuwabuiya, ta ꞌina mane siliba teti ꞌihilediya topwaoliyao ma babadao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ta ꞌigwae, “Yalopuiya, weyahina loheya bwebweꞌana ꞌoimiya yatebaeya.” Ma sigwaeya, “Beno geya ꞌaigeda toꞌaha ꞌoima, ma ꞌowa tuwa weyahiu ꞌunuwanuwatuhu.” ");
INSERT INTO bdd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Coinega mane tetiyedi ꞌiula suluhedi Hada Heꞌasisi ꞌalona, ma ꞌihapwesa ma ꞌitauya, ma balaeyega ꞌaniꞌona ꞌididi heyapasiya, ta ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma topwaoliyedi maneyedi sihegogonediya, ta sigwae, “Geya sawasawahina ma Yehoba ꞌana helau ꞌoina talagulagu, weyahina mane bewa loheya ꞌana loheꞌamasa maisana.” ");
INSERT INTO bdd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Coinega siboidimo siloina ma maneina ꞌoinega ꞌaigeda toꞌabi walata ꞌina baleꞌu ꞌaigeda sihemaiseya, ma ꞌabehega baleꞌuina taumanao ꞌadi galiha. ");
INSERT INTO bdd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Coinega baleꞌuina sibwauweya, “Bweyaha baleꞌuina”, ma saninaina ꞌabwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nage ꞌoina toꞌaha palopita Yelemaiya ꞌigwae nugeteya ꞌihapwesa, weyahina mwalo Buki Heꞌasisi ꞌoina sileleya ꞌabehega, “MeIsileli tauna ꞌana maisa sibwauweya, beno dimwa siliba ꞌadi baibaiwa teti, ta maneyedi siꞌewedima. ");
INSERT INTO bdd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma ꞌoinega toꞌabi walataina ꞌina baleꞌu sihemaiseya, gidemusa ꞌida Bada ꞌihemataluwegauwa.” ");
INSERT INTO bdd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Coinega Yesu Pailato matana sihetoholoya, tauna toloina madouna, ma Pailatoina Yesu ꞌihesilaleya, ꞌigwae, “Cuhepwaila, ꞌowa meYudiya ꞌidi kini, ꞌawa?” Ma Yesu ꞌigwaeya, “Beno ꞌugwae pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Coinega topwaoli madoudi ma babadao Yesu siheꞌeweya Pailato matana, ma Yesu geya ꞌaigeda toꞌaha ꞌihehemaise. ");
INSERT INTO bdd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma Pailato ꞌigwaeya, “Togidega, hepwaila bewa ꞌa heꞌewa weyahidi ꞌuhesagoheya?” ");
INSERT INTO bdd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yesu geya wete ꞌihemaise, ma tuwa ꞌihehenono, ꞌoinega Pailatoina nuwana ꞌihepwanopwanowa madouna. ");
INSERT INTO bdd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bolime ꞌaigeda ꞌaigeda ꞌoidiya, Hataona Guyaina ꞌoina toloinaina ꞌina mumuga beno deliyega ꞌaigeda loheya ꞌilihasi ma ꞌilatu, ꞌeguma taiya boda sihesinuweya. ");
INSERT INTO bdd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma tuta nage ꞌoina ꞌaigeda loheya deliya ꞌimiyamiya, sanina Balaba, tomota mabwaiyadi sisanapuya ꞌabehega tauna togala madouna. ");
INSERT INTO bdd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Coinega tomota mabwaiyadi siꞌetoꞌautama Pailato ꞌoina, ma Pailato ꞌihesilalediya, ꞌihegwaediya, “To loheya nuwanuwami ma weyahimi yalihasi? Balaba? bo Yesu tauna sibwauweya Toꞌabihetena?” ");
INSERT INTO bdd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Weyahina Pailato ꞌisanapuya ꞌabehega heꞌipiꞌipiyega Yesu sitebaeya sabi loheꞌamasina. ");
INSERT INTO bdd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma wete tutaina ꞌabwa Pailato yatala ꞌipaipaihowa, ma mwanena wasa ꞌihetuneyama ma ꞌigwaeya, “Sahena wete toꞌaha ꞌuloinae loheya beno bwebweꞌana. Weyahina nige yanihiyeya, ta ꞌebe matauta madouna ꞌoiguwa.” ");
INSERT INTO bdd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma hesi topwaoli madoudi ta babadao tomota siboꞌa heyaheyabadi ma ꞌabehega siꞌahwanoi Pailato ꞌoina ma Balaba ꞌilihasi ꞌoidiya ta Yesu siloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Coinega toloinaina ꞌihesilalediya, ꞌigwaeya, “Siteluwa ꞌoidiyega taiya nuwanuwami ma weyahimi yalihasi.” Coinega sigwaeya, “Balaba.” ");
INSERT INTO bdd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pailato ꞌigwaeya, “Ma togidega yaloina ꞌese Yesu tauna sibwauweya Toꞌabihetena?” Coinega mabwaiyadi sigwaeya, “Kelose ꞌoina tada tutuhepaꞌine!” ");
INSERT INTO bdd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma Pailato ꞌihegwaediya, “Toꞌaha hede ꞌina pui, ma ꞌoinega ꞌabehega ꞌamasa ꞌiloba?” Ma sibwau ꞌasoꞌasona, sigwaeya, “Kelose ꞌoina tada tutuhepaꞌine!” ");
INSERT INTO bdd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Coinega Pailato ꞌisanapuya ꞌabehega geya ꞌina waiwaimo, ma boda siheꞌoheꞌohe ꞌana ꞌoleya ꞌabehega nata sihegaina ma siheꞌupwa. Coinega weꞌahega nimana ꞌibuyoya bodaedi matadiya, ma ꞌigwae, “Sahena wete toꞌaha yaloiloina loheya bewa bwebweꞌana ꞌina ꞌamasa weyahina, ma waboimo wada loina.” ");
INSERT INTO bdd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma boda mabwaiyadi sigwaeya, “Bwebweꞌana! Tauma ꞌada loina, ma ꞌana maisa ꞌada loba, tauma, ma mehau sihanehanema ꞌoidiya wete.” ");
INSERT INTO bdd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Coinega Pailato ꞌidi gwae ꞌihesagoheya, ta Balaba ꞌilihasiya, ma wete ꞌina toloꞌalehao ꞌiloinaediya ma Yesu balaeyega sisapi, ma muliyetega ꞌabwa situtuhepaꞌi kelose ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Coinega toloinaina ꞌina toloꞌalehao Yesu sisapiya, ma siluhuweya ꞌidi hada madouna ꞌalona, ta ꞌidi boda mabwaiyadi sibwau heꞌautedima Yesu ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ma ꞌana ꞌaleꞌowao sihalolodiya, ta ꞌaleꞌo wasawasa ꞌoinega siheꞌoteya sabi lotuyae, ");
INSERT INTO bdd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ma ꞌana talatala talitali ꞌoidiyega sipaihoweya, ma debana silaguya, ma guna ꞌina ꞌebeula silaguya, ma wete matana siꞌetuluha ma silolotuyane, sigwaeya, “Yauwedo ꞌowa meYudiya ꞌidi kini, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma wete siꞌesoheya, ta ꞌina guna siꞌeweya, ma ꞌoinega debana sisapiya. ");
INSERT INTO bdd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta ꞌidi lotuyana ꞌigumwala, ma ꞌaleꞌo wasawasa ꞌoinega sihaloloya, ta tauna ꞌana ꞌaleꞌowega siheꞌwama hileya, ma sitoeya sabi hekeloseye. ");
INSERT INTO bdd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yesu sihapweseya ma sitauyeya, ma ꞌedai Sailini loheyaina ꞌaigeda, sanina Saimoni, sihalobeya, ma siloineya ma Yesu ꞌana kelose ꞌiꞌahali. ");
INSERT INTO bdd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ma Saimoniina ꞌiꞌahala ta ꞌana siga silatuwa Goligota tupwaina. (Goligota, ꞌana sanapu beno mwagu ꞌasaina.) ");
INSERT INTO bdd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ta waini ma paseꞌuma sihebweliyeya ta siꞌebwaeya, ma ꞌabehega sahena muya madouna ꞌilotolotoho, ma hesi Yesu ꞌilotohoyamowa ta ꞌilogwahateya. ");
INSERT INTO bdd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Coinega, kelose baleꞌuwa silaguya ma Yesu ꞌoina situtu hepaꞌiya ma sihetoholoya, ma muliyetega topaihowaedi Yesu ꞌana ꞌaleꞌo siꞌewediya ma siguyaiyeya siboimo ꞌoidiya, ma ꞌidi heguyai ꞌeꞌopiꞌopi sipaihoweya gide kati, ma ꞌeguma taiya ꞌinugeta ꞌana ꞌaleꞌo ꞌida ꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Muliyetega simiyatoiya ma siheheꞌasine. ");
INSERT INTO bdd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma wete ꞌana kelose tabwanina sileleya, “Yesu tauna meYudiya ꞌadi toloina.” Beno ꞌina ꞌamasaina lamuna. ");
INSERT INTO bdd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wete toyagaha ꞌeluwa siꞌabi hekelosediya, ꞌaigeda Yesu ꞌina ꞌebeulega ma ꞌaigeda ꞌina ꞌadigeyegeyega. ");
INSERT INTO bdd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma tomota tupwadi ꞌedai Yesu ꞌana kelose ꞌoina silolotuyana ma sihehenama, ");
INSERT INTO bdd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sigwae “Ca mudala! Cugwaeya ꞌabehega sawasawahiu ma Hada Heꞌasisi ꞌuligehi ma sabwelo ꞌetoi ꞌoina ꞌuꞌabihila. Hana ꞌuda ꞌetopelego ꞌuboi ma keloseyega ꞌusuluma, ꞌeguma ꞌowa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wete gidemusa topwaoli madoudi ta loina ꞌana toheꞌitao ta babada Yesu silotuyaneya, ma sigwae, ");
INSERT INTO bdd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hali tomota ꞌilemediya, ma tauna ꞌida ꞌetopele. Tauna ꞌabehega tupwa Isileli ꞌana toloina. Hana keloseyega ꞌisuluma ma ꞌoinega tahemisae. ");
INSERT INTO bdd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauna ꞌabehega Yehoba ꞌana tohemisa ma ꞌigwaeya, ‘Taugu Yehoba Natuna.’ Ceguma Yehoba nuwanuwana tauna, ꞌida ꞌetolihasi, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma toyagahaedi Yesu baꞌidanao siꞌabi hekelosediya, taudi ꞌadi keloseyega sibwaꞌabala ma taudi Yesu siheliyeya. ");
INSERT INTO bdd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Casudiladila ma lahilahi gogo mabwaiyana ꞌiguguyouwa. ");
INSERT INTO bdd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma lahilahiya Yesu ꞌenana madounega ꞌibwauwa ma ꞌigwaeya, “Eli, eli, lamasabakitani!” Cana bui beno gide, “Cigu Yehoba, ꞌigu Yehoba, toꞌaha weyahina ꞌuꞌebesinegauwa?” ");
INSERT INTO bdd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma tupwana tomota deina sitotoholo ꞌina bwau sihesagoheya, ma sigwaeya, “Wahesagohe! Loheya bewa Ilaitiya ꞌibwaubwauwe.” ");
INSERT INTO bdd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Coinega ꞌaigeda ꞌoidiyega ꞌipiliya ma balou ꞌiꞌeweya, ma waini memaina ꞌoina ꞌihepwaseya, ꞌoinega ꞌaigeda ꞌaiꞌaiwe matana ꞌibadiyeya, ma ꞌiheꞌetohaneheya Yesu ꞌahwana, ma ꞌimalaꞌuꞌuya. ");
INSERT INTO bdd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma loheyaina ꞌiyanao sigwaeya, “Tuwa tayamwayamwa, nuwana nata Ilaitiya ꞌilatuma ma ꞌiꞌetolihasi.” ");
INSERT INTO bdd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma Yesu ꞌenana madounega ꞌibwau hila, ma yawasina ꞌigumwala. ");
INSERT INTO bdd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma ꞌaleꞌoina* Hada Heꞌasisi ꞌana libu ꞌilotaliliya tabwanega ma ꞌisuluwa duduna, ma mwaniꞌiniꞌi ꞌipiliya, ma daꞌule madoudi siꞌemutumutudiya. ");
INSERT INTO bdd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma wete galiha siꞌesoꞌediya ma tohemisao tupwana baibaiwadi mwalo siꞌamasa wahidi sitoholo hila, ");
INSERT INTO bdd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ma Yesu ꞌina toholo mulina taudi wete galihega sihapwesama, ma Yelusalema ꞌoina siluhuwa, ma tomota tupwana baibaiwadi ꞌoidiya sihapwesa. ");
INSERT INTO bdd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma toloꞌalehaowedi maꞌidi tohanugeta saugenina Yesu kelose ꞌoina siꞌitaꞌitayahiya, mwaniꞌiniꞌi ma ginaula mabwaiyana siꞌitediya, ta simatauta madouna, sigwaeya, “Moisa, loheya bewa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wahiwahine wete tupwana bwagebwagega siꞌeꞌebubuna, taudi mwalo Galiliyega Yesu sihemuli tabubuweyama, ma ꞌana sipaipaihowa. ");
INSERT INTO bdd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Caigeda sanina Meli Magidala, ma ꞌina waliyesa tauna Yemesa ma Yosepa sinadiu, ma wete Sebedi natunao sinadiu. ");
INSERT INTO bdd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lahilahiya ꞌaigeda Alimatiya loheyaina ꞌinaoma Pailato ꞌoina, tauna towasawasa ma wete Yesu ꞌana tomuliya ꞌaigeda, sanina Yosepa. ");
INSERT INTO bdd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma Pailato ꞌoina wahina ꞌiꞌahwanoiyeya, ma Pailato ꞌitagwala. ");
INSERT INTO bdd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Citagwala, ma Yosepa maꞌina hewahewaliyao Yesu wahina siꞌeweya, ma ꞌaleꞌo waꞌewaꞌeꞌena ma ꞌehauna ꞌoinega siwaduhiya. ");
INSERT INTO bdd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma Yosepaina ꞌana galiha hauhauna ꞌoina silaguya, ma galihina sipidiya gide duluha ꞌalona. Ma daꞌule madouna ma pwaꞌupwaꞌuwana ꞌoinega galihina ꞌahwana silagu bodeya, ma muliyetega Yosepa ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Meli Magidala maꞌina waliyesa galihina deina simiyatoiya, ma siheheꞌasine. ");
INSERT INTO bdd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma Yesu siꞌabi hekeloseyeya meYudiya ꞌidi sabwelo ꞌatububu ꞌoina, ꞌoinega gona ꞌiꞌadaleya, beno ꞌidi Sabati, topwaoli madouna ma Palisiyao bodaidi sitauya Pailato ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ma sigwaeya, “Bada, toꞌaboina mwalo mayawasina ꞌimiyamiya ꞌina gwae ꞌanuwatuhuya ꞌigwae, ‘Sabwelo ꞌetoi ma ꞌamasega yatoholo hila.’ ");
INSERT INTO bdd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Coinega ꞌeguma sawasawahina, ꞌuloina ma galiha ꞌana toꞌitayahinao siꞌitayahi bwaibwaini ma ꞌana siga sabwelo ꞌetoi, tabu ta ꞌana tomuliyao sinaoma ma Yesu wahina siyagahi ma sidene, ma tomota siꞌabowedi ꞌabehega ꞌamasega ꞌitoholo hila, ma ꞌoinega ꞌabo mulimuliyana ꞌabo nugetana ꞌida gala sine.” ");
INSERT INTO bdd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma Pailato ꞌihegwaediya, ꞌigwaeya, “Cimi toꞌita yahinaowedi toloꞌalehao simiyamiya, watauyedi ma galiha simiya loyamwa bwaibwaini.” ");
INSERT INTO bdd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Coinega sitauya ma galiha ꞌahwana ꞌana loboda dimwaina wete sibwadeya, ma nobwa toꞌitayahinaedi sihalagudiya. ");
INSERT INTO bdd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabati mulina gona ꞌiꞌadaleya wiki hauhauna ꞌana sabwelo nugenugetana ꞌoina, Meli Magidala maꞌina waliyesa sinaoma galiha sabi boꞌene. ");
INSERT INTO bdd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma mwaniꞌiniꞌi madouna ꞌipiliya, beno Bada ꞌina anelose ꞌaigeda galewega ꞌisuluma, ta dimwa galiha ꞌahwanega ꞌibuiwasiyeya, ma ꞌoina ꞌimiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aneloseina ꞌana ꞌita gide namala, ma ꞌana ꞌaleꞌo waꞌewaꞌeꞌena moisa. ");
INSERT INTO bdd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma galiha ꞌana toꞌitayahinao anelose siꞌiteya ma simatauta madouna, ꞌoinega sitaiya ma sibeꞌuwa baleꞌuwa toꞌamasa gide. ");
INSERT INTO bdd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma aneloseina wahiwahineyedi ꞌihegwaediya ꞌigwaeya, “Sahena waꞌateꞌateyoho. Yasanasanapu ꞌomi Yesu tauna siloheꞌamasiya wabesebese. ");
INSERT INTO bdd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tauna geya ꞌebwa, weyahina ꞌamasega ꞌitoholo pwaiya, gide mwalo ꞌihegwaegomiya. Wanaoma ma ꞌina ꞌebeꞌeno waꞌita gaugaulinamo, ");
INSERT INTO bdd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ma muliyetega watauya mwayamwayau ma ꞌana tomuliyao wahegwaedi ꞌabehega Yesu ꞌamasega ꞌitoholo pwaiya, ma nata ꞌinugeta Galili ꞌoina, ma ꞌomi wamuliye, nage ꞌoina waꞌita. Beno tuwa.” ");
INSERT INTO bdd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Coinega wahiwahineyedi maꞌidi matauta, ma wete maꞌidi yaliyaya, galiha siꞌebesineya ma sipili mwayamwayauwa, ꞌabehega Yesu ꞌana tomuliyao ꞌoidiya ginaula bewa sida hepwaile. ");
INSERT INTO bdd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma Yesu ꞌedai ꞌilobediya ma ꞌiloyauwedowediya, ma sinaoma ma ꞌahena sigitohodiya ma siꞌetuluha ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Coinega Yesu ꞌihegwaediya, ꞌigwaeya, “Sahena waꞌateꞌateyoho, ma hesi watauya ma ꞌiyagwao wahemataluwedi ma sitauya Galili ꞌoina, nage ꞌoina ꞌabwa siꞌitegau.” ");
INSERT INTO bdd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wahiwahineyedi ꞌabwa ꞌedai sitautauya, ma galihina ꞌana toꞌitayahinao tupwadi sitauya ꞌasa Yelusalema ꞌoina, ma toꞌaha silatuwa gide sihepwaileya topwaoli madoudi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Coinega topwaoliyedi ma babada mahetediyao siꞌetoꞌautama ma siloina, ta mane toꞌitayahinaowedi siꞌebwaediya ");
INSERT INTO bdd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma ꞌane tomota ꞌoidiya sida hepwaila dadane, ma ꞌane sida gwae, “Nihuwana ꞌaꞌenoꞌeno ma Yesu ꞌana tomuliyao sitauyama ta wahina siyagahiya.” ");
INSERT INTO bdd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Eeta sihegwaediya, sigwae, “Ceguma toloina madouna wasa bewa ꞌihesagohe, nata ꞌaꞌabowe ma ꞌoinega geya sawasawahina ma ꞌigamwasowala ꞌoimiya.” ");
INSERT INTO bdd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Coinega ꞌidi mane siꞌeweya, ma topwaoliyedi ma babadao ꞌidi nuwatuhuina sihematamataneya, ma ꞌidi hepwailaina ꞌilelewana meYudiya ꞌoidiya, ꞌoinega bewa tuwa gide wete sihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Coinega Yesu ꞌana tomuliyao site lebeni sitauya Galili, ma sihaneya ꞌoyaina Yesu ꞌihepwaileya ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ma Yesu siꞌiteya ma ꞌoina siꞌetuluha. Ma tupwadi ꞌoidiyega ꞌabwa maꞌidi henuwanaluwa. ");
INSERT INTO bdd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eeta Yesu ꞌinaoma ꞌoidiya ma ꞌihegwaediya, ꞌigwae, “Tamagu loina waiwaina mabwaiyana galewa ma baleꞌuwa ꞌiꞌebwae pwaigauwa. ");
INSERT INTO bdd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Coinega watauya ma ꞌasa mabwaiyadi ꞌoidiya waloguguya, ma ꞌoinega tomota sihemisaegau, ma wete waꞌabihe babitaisodi Tamagu saninega ma Natuna Taugu saniguwega ma wete Yaluyaluwa Tabuna saninega. ");
INSERT INTO bdd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Loina mabwaiyana yaꞌebwaegomiya ma waheꞌitaedi, ma taudi wete sida muliyedi. Ma moisa, taugu baꞌidamiu tamiyamiya sauga mabwaiyana ꞌoidiya, sauga bewa ma ꞌana siga baleꞌu ꞌana ꞌebelosaloha ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Toꞌabihetena Yesu, tauna Yehoba natuna, wasana bwebweꞌana ꞌana ꞌebehegaina beno: ");
INSERT INTO bdd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mwalona hene palopita Aiseya Yesu wasana ꞌilele nugeteya, beno Yehoba ꞌenana ꞌihepwaileya, ꞌigwae: “Bewa ꞌigu tohalewasa yahewasae ma ꞌinugeta, ma ꞌino ꞌeda ꞌihunae. ");
INSERT INTO bdd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ma tupwa yoho ꞌawawa ꞌoina ꞌenana madounega ꞌihepwaila latu ma ꞌigwaegwae, ‘Bada ꞌina ꞌeda wahunae, waꞌabihedumwalu.’” ");
INSERT INTO bdd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Coinega Yoni toꞌabihe babitaisoina ꞌilatuwa yoho ꞌawawa, ꞌihepwaila tomota ꞌoidiya, ꞌigwae, “Mumugami galadi ꞌoidiyega wanuwabui ma yaꞌabihe babitaisogemi ma Yehoba ꞌimi mumugaedi ꞌinuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma tomota mabwaiyadi tupwa Yudiya mabwaiyana ꞌoidiyega ma meYelusalema wete mabwaiyadi sisawalama, Yoni ꞌina guguya sabi hesagohe. Sihesagoheya ma mumugadi galadi sihehepwaile, ma ꞌiꞌabihe babitaisodiya weꞌaha Yolidani ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni ꞌana ꞌwama tuwa kameli hunuhunuwana, ma ꞌana gadiwana kameli ꞌwapina, ma ꞌanaedi tuwa bilolo eema mwagagau. ");
INSERT INTO bdd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yoni ꞌiguguya ma ꞌigwae, “Tauna muliguwega ꞌinaonaoma ꞌihemadou sinegauwa. Geya ꞌilobwainegau ma ꞌahena ꞌoina yatuluha ma ꞌana butu yalihasi. ");
INSERT INTO bdd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taugu weꞌahega tuwa yaꞌabihe babitaisogomi, ma tauna loheyainaina Yaluyaluwa Tabuna ꞌoinega ꞌiꞌabihe babitaisogomi.” ");
INSERT INTO bdd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sauga nage ꞌoina Yesu ꞌasa Nasaleta ꞌiꞌebesineya, tupwa Galili ꞌoinega, ma ꞌinaoma weꞌaha Yolidani ꞌoina, ma Yoni Yesu ꞌiꞌabihe babitaisoya. ");
INSERT INTO bdd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cibabitaiso, ma Yesu weꞌahega ꞌigayohanema, ma ꞌiꞌita haneya galewa ꞌiꞌeigala luweya ma Yaluyaluwa Tabuna ꞌana ꞌita gide gabubu ꞌisuluma ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wete ꞌenana ꞌaigeda galewega ꞌigwaema, ꞌigwae, “Cowa natugu ꞌausalana, weyahiu yayaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nage ꞌoina Yehoba Yaluyaluwana Yesu ꞌihesumaneya, ꞌitauya yoho ꞌawawa, ");
INSERT INTO bdd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ma nobwa sabwelo poti ꞌimiyamiya, ma Seitani ꞌitohotoho waiwai ꞌabehega Yesu ꞌiꞌabi hebeꞌu. Ma tupwaina ꞌoina hebahebai sasasasaedi simiyamiya, ma hesi aneloseyao Yesu siꞌitayahiya. ");
INSERT INTO bdd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Muliyetega Helodi maꞌina topaihowao Yoni deliya silaguluguheya. Yoni ꞌabwa deliya ꞌimiyamiya, ma Yesu ꞌilatuwa Galili, ma wasa bwebweꞌana Yehoba ꞌoinega ꞌiguguyaeya, ꞌigwae, “Sauga ꞌilatu pwaima Yehoba ꞌihetoloina ꞌoida. Coinega ꞌimi puiyao ꞌoidiyega wanuwabui ma wasana bwebweꞌana wahemisae.” ");
INSERT INTO bdd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sauga ꞌaigeda Yesu holega ꞌihasahasane ta ꞌiꞌitanao togomana siteluwa matasina Galili holai ꞌidi gomana siyahuyahuwe, taudi Saimoni ma Andulu. ");
INSERT INTO bdd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta Yesu ꞌibwauwedima, ꞌigwae, “Wamuliyegau ma tomota waꞌonadi.” ");
INSERT INTO bdd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nage tuwa ꞌoina ꞌidi gomana siꞌebesineya ma Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wete ꞌihanaowa tupwana, ta Yemesa ma Yoni, taudi Sebedi natunao, ꞌiꞌitediya wagai ꞌidi gomana siꞌatuꞌatububu. ");
INSERT INTO bdd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ta ꞌibwauwedima ma tamadiu maꞌina topaihowao siꞌebesinediya nobwa wagai ma Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Muliyetega sinaoma ꞌasa madouna sanina Kapaneumi ꞌoina, ma Sabatiya Yesu hada tapwalolo ꞌoina ꞌiluhuwa, ꞌiheꞌita. ");
INSERT INTO bdd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ciheheꞌita ma tomota mabwaiyadi nuwadi ꞌihepwanopwanowa, ta sigwaeya, “Heꞌita bewa waiwaina, ma hesi ꞌida loina ꞌana toheꞌitao ꞌidi heꞌita weꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Ma hada tapwaloloina ꞌoina ꞌaigeda loheya ꞌimiyamiya, ma loheyaina ꞌoina hiꞌahiꞌa mwalo ꞌiluhuwa ma ꞌimiyamiya. Coinega loheyainaina Yesu ꞌoina ꞌibwauwa, ma ꞌigwae, “Yesu, gwama Nasaleta, toꞌaha lamuna ꞌunaoma ꞌoima? Nuwanuwau ꞌabehega ꞌuhunumai, ꞌawa? Ma yasanapu bwaibwainigowa ꞌowa tuwa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesu ꞌiloineya, ꞌigwae, “Culolagu, ma loheyaina ꞌoinega ꞌuhapwesa.” ");
INSERT INTO bdd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Coinega hiꞌahiꞌa loheyaina ꞌiꞌabi hededeliya. Cidededela, ma ꞌiꞌasoꞌasona madouna, ma muliyetega hiꞌahiꞌa loheyaina ꞌalonega ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Coinega tomota mabwaiyadi sihenainaida, ma siboi sihehesilala hiledi, sigwae, “Togidega heꞌita hauhauna bewa? Bewa loheyaina ꞌina loinega hiꞌahiꞌa ꞌiloinaedi ma simuliye.” ");
INSERT INTO bdd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma Yesu wasana sihewasa dadaneya Galili tupwana mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu hada tapwalolo ꞌoinega ꞌilatuwa ta Yemesa ma Yoni mahetenao sinaowa Saimoni ma Andulu ꞌidi hada. ");
INSERT INTO bdd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma Saimoni lawana ꞌilohala weyahina wahina ꞌiyahiyahiya. Coinega Yesu sihemataluweya wahineina ꞌana lohala weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ta Yesu ꞌiluhuwa ꞌoina ma nimanega ꞌiꞌabihe toholoya, ta ꞌana lohalaina ꞌigumwala. Coinega wahineina ꞌilatuwa ma ꞌadi ꞌipaihoweya. ");
INSERT INTO bdd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma ꞌilahilahi, sinala ꞌisopu pwaiya, ma tomota ꞌidi tolohalao ma wete taudi hiꞌahiꞌa ꞌiꞌabi hebuwediya sitoedima Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma wete ꞌasa ꞌana tomiyao mabwaiyadi sihegogona ma hada mataꞌahwana sitotoholo. ");
INSERT INTO bdd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Coinega tolohalao mabwaiyadi ma wete taudi hiꞌahiꞌa ꞌiꞌabi hebuwediya mabwaiyadi Yesu ꞌiꞌabihe bwebweꞌanediya. Ma hiꞌahiꞌa ꞌiꞌausidiya, ꞌigwae, “Geyaꞌabwa wahehepwailegau,” weyahina Yesu sisanapuya. ");
INSERT INTO bdd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ciꞌiuna ma gona ꞌiꞌadale, Yesu ꞌitoholowa ma hadega ꞌilatuwa, ꞌiboi ꞌinaowa yoho ꞌawawa, ꞌiꞌahwanoiya Tamana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimoni ma ꞌiyanao wete silatuwa ma Yesu siꞌebeseya, ");
INSERT INTO bdd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ta silobeya, ma sihegwaeya, “Tomota mabwaiyadi nuwanuwadi ꞌowa.” ");
INSERT INTO bdd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yesu ꞌigwaeya, “Tatau ꞌasa tupwadi wete ꞌoidiya, yaguguya. Bewa weyahina yanaoma.” ");
INSERT INTO bdd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Coinega Galili mabwaiyana ꞌisakowasiyeya ma ꞌidi hada tapwalolo ꞌoidiya ꞌiguguya, ma wete hiꞌahiꞌa* tomota ꞌoidiyega ꞌiula latuhediya. ");
INSERT INTO bdd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma tolepelo ꞌaigeda Yesu ꞌoina ꞌinaoma ꞌiꞌetuluha, ma ꞌiꞌahwanoiyeya, ꞌigwae, “Ceguma ꞌowa ꞌino nuwatuhu gide, sowasowahina ma ꞌuꞌabihe bwebweꞌanegau.” ");
INSERT INTO bdd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Coinega Yesu ꞌiꞌate muyemuyeya, ma nimanega loheyaina ꞌwapina ꞌiꞌabi tohoya, ma ꞌigwae, “Cehe gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta loheyaina ꞌwapina ꞌibwebweꞌana mwayamwayauwa. ");
INSERT INTO bdd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ma Yesu loheyaina ꞌiloina hepaꞌaleya, ma ꞌigwae, “Cutauya, ma gesowana taiya ꞌeta ꞌoina ꞌuhehepwailegau, ma hesi ꞌudumwalu topwaoli ꞌoina ꞌiꞌitago, ma ꞌino pwaoli ꞌuꞌebwaya Yehoba ꞌoina, toꞌaha gide ꞌada loina Mosese ꞌoinega. Eema tomota sisanapugo ꞌabehega ꞌowa ꞌubwebweꞌana pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma loheyaina geya Yesu ꞌina loina ꞌihematamatane, ma hesi tomota ꞌoidiya ꞌihepwaila dadaneya. Eeta Yesu geya sowasowahina ma ꞌiyawala ꞌasaedi ꞌalodiya, ta ꞌoinega ꞌinaowa yoho ꞌawawa ma nobwa ꞌimiyamiya, ma tomota tupwa mabwaiyana ꞌoidiyega sinaoma ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sabwelo tupwana sigumwala ma Yesu ꞌihila Kapaneumi ꞌoina, ma wasana sihesagoheya ꞌabehega Yesu ꞌihila pwaima. ");
INSERT INTO bdd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma boda madouna hada ꞌalona ma wete ꞌahwaꞌedaina ꞌatamanina siꞌetoꞌauta, ma Yesu ꞌiguguya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma boda topeu ꞌaigeda ma hewaina siꞌeweyama ma ꞌana toꞌahalaedi sitehata siꞌahaliyama. ");
INSERT INTO bdd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma sitohoya ma topeuina siluhuwe Yesu ꞌoina, ma geya sowasowahidi, weyahina boda ꞌimadou hedada, eeta siꞌahala haneheya hada tabwana, ma ꞌana ꞌatoha sibwaleya, ꞌigumwala eeta topeuina ma hewaina sihedawedaweya, Yesu matana silaguya. ");
INSERT INTO bdd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Coinega Yesu loheloheyaedi ꞌidi hemisa ꞌisanapuya ma topeuina ꞌihegwaeya, “Natugu, ꞌino puiyao mabwaiyana yanuwasamudiya.” ");
INSERT INTO bdd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Ma tupwana loina ꞌana toheꞌitao deina simiyamiya Yesu ꞌina gwae sihesagoheya ma siboi ꞌatediya sinuwanuwatuhu, sigwae, “Loheya bewa ꞌigwae bwagabwaga ma Yehoba ꞌisinaliya. Geya ꞌeta taiya sowasowahina ma tomota ꞌidi puiyao ꞌinuwasamudi, beno tuwa Yehoba sowasowahina.” ");
INSERT INTO bdd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma hesi Yesu ꞌatena ꞌidi nuwatuhu ꞌisanapuya, ꞌoinega ꞌihegwaediya, “Toꞌaha weyahina beno gide wanuwanuwatuhu ꞌesa? ");
INSERT INTO bdd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma wanuwatuhuya ꞌabehega to gwae sowasowahina ma topeu bewa ꞌoina yagwaene, sowasowana yagwae, ‘Cino puiyao yanuwasamudiya,’ bo sowasowana yagwae, ‘Cutoholo ma ꞌino ꞌebeꞌeno ꞌuꞌahali ma ꞌutau.’ ");
INSERT INTO bdd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bewa ꞌoina wasanapugau ꞌabehega taugu Loheyaiguina maꞌigu loina ma baleꞌuwa tomota ꞌidi puiyao yanuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Coinega topeuina ꞌihegwaeya, “Taugu bewa yahegwaego ‘Cutoholo ꞌino ꞌebeꞌeno ꞌuꞌahali ma ꞌutauya ꞌino ꞌasa.’” ");
INSERT INTO bdd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma ꞌitoholowa, ꞌina ꞌebeꞌeno ꞌiꞌahaliya, ma boda matadiya ꞌilatuwa. Nage ꞌoina boda mabwaiyadi nuwadi ꞌipwanopwanowa, ma Yehobaina sihehepwatuwe, sigwaeya, “Paihowa bewa maꞌaigeda tuwa taꞌiteya.” ");
INSERT INTO bdd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Eema Yesu ꞌihila hola Galili ꞌoina, ma wete boda siꞌautama, ꞌiheꞌita ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ciheꞌita ꞌigumwala ma ꞌinaonao. Ma loheya ꞌaigeda takesi ꞌana toꞌewa ꞌiꞌiteya ꞌina hada ꞌebe paihowa ꞌoina ꞌimiyamiya. Loheyaina Libai, ma tamana Alipiyo. Ma Yesu ꞌihegwaeya, “Libai ꞌumuliyegau.” Coinega Libaiina ꞌitoholowa ma Yesu ꞌimuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Muliyetega Yesu maꞌana tomuliyao sinaoma Libai ꞌina hada sabi ꞌai, ma boda Yesu simuliyeya, taudi tolopui gide takesi ꞌana toꞌewao ma tolopui tupwadi wete, Yesu maꞌana tomuliyao baꞌidadiyao simiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Simiyamiya ta Palisi ꞌidi loina ꞌana toheꞌitao siꞌitediya, eeta Yesu ꞌana tomuliyaowedi ꞌoidiya sihesilala, sigwae, “Toꞌaha weyahina ꞌimi toheꞌita takesi ꞌana toꞌewaowedi ma tolopuiyedi wete baꞌidanao siꞌaiꞌai hegogona?” ");
INSERT INTO bdd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma Yesu Palisiyao ꞌidi gwae ꞌihesagoheya, ta ꞌihegwaediya, “Taudi wahidi waiwaidi genuwadi toꞌabihe bwebweꞌana, ma tolohalao hesi. Taugu yanaoma geya ꞌabehega tobwebweꞌadi weyahidi, ma hesi topui yaꞌabihetedi.” ");
INSERT INTO bdd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yoni ꞌana tomuliyao ma wete Palisiyao sihudiya ꞌidi tapwalolo weyahina, ꞌoinega tupwadi loheloheya Yesu ꞌoina sinaoma ma sihesilala, sigwaeya, “Yoni ꞌana tomuliyao ma wete Palisiyao ꞌadi tomuliyao sihudihudi, ma togidega ꞌa tomuliyaowedi geya sihudi?” ");
INSERT INTO bdd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Coinega Yesu gwae hegehegediyega ꞌihegwaediya, “Togidega, ꞌilobwaineya ma hai ꞌana toyoꞌowao sinuwagala ma sihudi ꞌeguma tohai meloheyana baꞌidadiu simiyamiya? Geya wete. Ceguma tauna baꞌidanao mabwaiyadi siyaliyaya. ");
INSERT INTO bdd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma wanuwatuhuyahi ꞌeguma sauga ꞌinaonaoma tohaiina ꞌiꞌebesinedi ee ꞌabwa sihudi, maꞌidi nuwagala.” ");
INSERT INTO bdd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma ꞌaigeda wete gwae hegehegedi ꞌiꞌebwaediya, ꞌigwae, “Geya sowasowahina ma ꞌaleꞌo ꞌehauna tupwatupwana ꞌoinega ma ꞌwama miyamiyana tabwabwada, tabu ma taitaigalanaina ꞌiꞌeigala hila ma ꞌihemadou. ");
INSERT INTO bdd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma wete geya ꞌeta taiya weꞌaha waiwaina ma ꞌehauna ꞌisiwa ꞌwapi ꞌebesiwa miyamiyaidi ꞌoidiya, tabu ma silotaigala ma weꞌahina wete ꞌitasiwa ma ꞌihepaipaisiye, ma hesi ꞌeguma tasiwa ꞌwapi ꞌebesiwa hauhaudimo ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati ꞌaigeda Yesu maꞌana tomuliyao tanoha ꞌalonega sitautau ma tomuliyaowedi ꞌidi tauya ꞌoina witi huwaina siꞌabilolodiya ma siꞌaiꞌai. ");
INSERT INTO bdd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Palisiyao siꞌitediya ta Yesu sihegwaeya, sigwae, “Bada, togidega ta ꞌa tomuliyaowedi Sabati ꞌana loina siligehiya?” ");
INSERT INTO bdd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eeta Yesu ꞌihegwaediya, ꞌigwae, “Buki Heꞌasisi ꞌana lele Debida weyahina ꞌeguma wahasili, wasanapu beno tauna maꞌiyanao sigomaleya madouna. ");
INSERT INTO bdd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Coinega Yehoba ꞌina hada Debidaina ꞌiluhu ta beledi heꞌaheꞌasisina ꞌiꞌeweya ma siꞌaiya. Belediina ma ꞌana loina ꞌabehega topwaolimo ꞌadi tagwala ma siꞌai. Ma tuwa sigomaleya, ꞌoinega topwaoli madouna, sanina Ebaya, ꞌitagwala ta siꞌaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wete Yesu ꞌihegwaediya, ꞌigwae, “Yehoba Sabati ꞌiꞌebwaegita ꞌida bwebweꞌana weyahina, geya ꞌabehega ꞌihemasalahegita Sabati weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ma hesi Sabati ꞌana toloinaina taugu Loheyaiguina tuwa.” ");
INSERT INTO bdd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Muliyetega Yesu ꞌihilama hada tapwalolowa. Nage ꞌoina ꞌaigeda loheya nima meyomeyona ꞌilobeya ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma Palisiyao Yesu siꞌeꞌebubu, ma ꞌeguma loheya ꞌiꞌabihe bwebweꞌane Sabatiya nata siheꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Coinega Yesu loheyaina ꞌihegwaeya, “Cutoholo ꞌulagama,” ma loheyaina ꞌitoholowa ta ꞌilaga. ");
INSERT INTO bdd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cilagama. Yesu babadaedi ꞌihegwaediya, ꞌigwae, “Bewa ꞌigu hesilala ꞌoimiya: To nuwatuhu bwebweꞌana ꞌoida? Sabati ꞌoina tomota talemedi, bo taloheꞌamasidi?” ");
INSERT INTO bdd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ma Yesu ꞌiꞌebubu yahiyahidiya maꞌina gamwasowala ma wete maꞌina nuwagala ꞌidi debapaꞌala weyahina, ma loheyaina ꞌihegwaeya, “Nimau ꞌuyasi,” ma nimanaina ꞌiyasi hedumwaluya ma ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Coinega Palisiyao maꞌidi gamwasowala silatuwa, ma Helodi ꞌina boda mahetediyao siloiloina togidega Yesu siloheꞌamasi ꞌese. ");
INSERT INTO bdd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ꞌiꞌebesinediya maꞌana tomuliyaowedi sidobiya Galili holai, ma boda madouna simuliyeyama. ");
INSERT INTO bdd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bodaedi bewa Yesu ꞌina paihowao wasana sihesagoheya, ta Galiliyega ma Yudiyaega ma Yelusalemega ma Idumea tupwanega ma Yolidani hali tupwega ma wete ꞌasaedi Taiya ma Saidoni deidiyega siꞌetoꞌautama. ");
INSERT INTO bdd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Weyahina Yesu tolohalao ꞌiꞌabihe bwebweꞌanediya, eeta tolohalaowedi baibaiwadi siheheduidui, nuwanuwadi siꞌabitoho, ꞌoinega Yesu ꞌana tomuliyaowedi ꞌihegwaediya, “Waga weyahigu waꞌeweyama, ma ꞌeguma tomotaedi siheheduidui hedada, yagelu wagai.” ");
INSERT INTO bdd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma taiyawedi tomota hiꞌahiꞌa ꞌoidiya siluhuwa, ma ꞌeguma Yesuina siꞌita sibeꞌu ma siꞌeno talutalubuꞌi matana ma sibwaubwau, sigwae, “Cowa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Yesu ꞌiloina paꞌalediya, ꞌigwae, “Sahena wabwaubwau ma wahehepwailegau ꞌabehega Taugu Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Muliyetega ꞌoyai ꞌihaneya, ma tupwadi ꞌana tomuliyaowedi ꞌihesinuwediya ma ꞌibwauwediya, sihanema ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ma ꞌihegwaediya, ꞌigwae, “Comi wate tuwelo yahesinuwegomiya ma ꞌomi baꞌidagwao tamiyamiya, ma muliyetega yahewasaegomi ꞌasa tupwadi ꞌoidiya, ma waguguya ma waiwai ꞌoinega hiꞌahiꞌa tomota ꞌoidiya waulalatuhedi.” ");
INSERT INTO bdd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ma sanidi bewa: Saimoni, tauna ꞌibwauweya Pita. ");
INSERT INTO bdd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ma wete Yemesa ma tasina Yoni, taudi Sebedi natunao, ma Yesu ꞌibwauwediya Bowanage (ma Bowanage ꞌana nuwasabwalena ꞌabehega taudi tutu gide). ");
INSERT INTO bdd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma wete Andulu ma Pilipi ma Batolomiu ma Madiu ma Tomasi, ma Yemesa ꞌina waliyesa, tauna Alipiyo natuna, ma Tadiyasi ma Saimoni ꞌina waliyesa, tauna toꞌalaꞌoheꞌohe madouna Isileli ꞌina miyawasi Loma weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma wete Yudasa Isakaliyota, tauna ꞌabwa Yesu ꞌitebae. ");
INSERT INTO bdd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ꞌihila ꞌasai, ma boda madouna siꞌautama, ma geya sowasowahina Yesu maꞌana tomuliyaowedi siꞌaiyawasi eema siꞌai. ");
INSERT INTO bdd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma ꞌina susuwao sihesagoheya ꞌabehega Yesu geya ꞌida ꞌaiyawasiya, ꞌoinega sinaowa ꞌabehega sitoeyama, sigwaegwae, “Ciheyauyaule pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma loina ꞌana toheꞌitao tupwadi Yelusalemega sidobima, ma Yesu ꞌina paihowa madouna siꞌiteya, ma sigwae, “Loheya bewa ꞌihetopaihowa weyahina welabana ꞌidi bada beno Tomudulele ꞌilemeleme, ma tauna ꞌina waiwaiyega welabanao ꞌipaꞌipaꞌidi.” ");
INSERT INTO bdd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Coinega Yesu loheloheyaowedi ꞌibwauwedima ma gwae hegehegediyega ꞌiheꞌita ꞌoidiya, ꞌigwae, “Toꞌaha weyahina Tomudulele ꞌabehega tauna ꞌiyanao ꞌipaꞌidi?” ");
INSERT INTO bdd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ma wete ꞌigwaeya, “Ceguma ꞌaigeda ꞌebeloina ꞌoina loheloheya siwatahidi ma siboi siloꞌaleha hiladi, ꞌabwa ꞌebeloinaina ꞌiweꞌa ma ꞌibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wete ꞌeguma susu ꞌaigeda ma siwatahi ma siboi siloꞌaleha hiladi, ꞌidi miya ꞌigala. ");
INSERT INTO bdd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tomudulele wete gide, ꞌeguma maꞌiyanao siboi siloloꞌaleha hiladi, ꞌabwa ꞌina ꞌebeloinaina ꞌibeꞌu, ma ꞌigumwala hataya. ");
INSERT INTO bdd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Cebeꞌita ꞌaigeda wete loheya waiwaina, beno Tomudulele ꞌina hada: Geya sowasowahina ꞌaigeda taiya ꞌiluhu tohewaiwaiina ꞌina hada ma ꞌina tobwatobwa ꞌiꞌewadi, ma hesi ꞌeguma ꞌaigeda loheya gulaha ꞌoinega tohewaiwaiina nimana ma ꞌahena ꞌipai nugetedi, ee ꞌabwa ꞌiluhu ꞌina hada, ma tobwatobwa ꞌiꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Coinega bewa yahegwae bwaibwainigomi ꞌabehega tomota ꞌidi puiyao ma ꞌidi gwae galagala mabwaiyana Yehoba ꞌida nuwasamudi, ");
INSERT INTO bdd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ma hesi ꞌaigeda tuwa geya, beno ꞌeguma taiya Yaluyaluwa Tabuna ꞌiꞌahwa galagalae, Yehoba nata geya ꞌinuwanuwasam, ma bewa mumuga galanaina ꞌoina ꞌimiya hataya.” ");
INSERT INTO bdd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bewa gide Yesu ꞌigwae ꞌesa weyahina sigwaegwae ꞌabehega tauna ꞌoina hiꞌahiꞌa ꞌiluhuwa. ");
INSERT INTO bdd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eema Yesu sinana ma tasinao silatuwa ma ꞌatamana sitoholowa, ma gwaemo sihewasaeya Yesu ꞌoina ma ꞌabehega ꞌihapwesa ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ma tomotaedi Yesu deina simiyatoiya, ma sihegwaeya, “Bada, sinau ma tasimwao waꞌita latu ꞌatamana, nuwanuwadi ꞌowa.” ");
INSERT INTO bdd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ꞌihegwae hilediya, “Taiya sinagu? Ma taiyawedi tasigwao?” ");
INSERT INTO bdd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma ꞌana tomuliyaowedi deina simiyatoiya ꞌiꞌeꞌebubudi, ma ꞌigwaeya, “Waꞌita bewa taudi sinagu ma tasigwao. ");
INSERT INTO bdd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Taiya ꞌowa ꞌeguma Yehoba ꞌina nuwatuhuina ꞌumulimuliya, ꞌowa beno tasigu bo nuhugu, nuwana sinagu.” ");
INSERT INTO bdd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Muliyetega wete Yesu ꞌihila hola Galili papalina sabi heꞌita, ma boda madou hedade siꞌetoꞌautama, ꞌoinega Yesu waga ꞌaigeda ꞌiꞌahaꞌahai holai ꞌoina ꞌigeluwa, ꞌimiyatoiya, ma boda madouna sitoholowa ꞌoyaꞌoya. ");
INSERT INTO bdd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma Yesu gwae hegehegedi baibaiwana ꞌoidiyega ꞌiheꞌita ꞌoidiya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wahesagoha: Tobegula ꞌaigeda ꞌina tanoha ꞌinaowa ma witi patuna ꞌisaweyanediya, ");
INSERT INTO bdd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ma tupwana patu ꞌedai sibeꞌuwa, ma bwasumo siꞌitediya, ta sitowa dobiya ma siꞌaidiya. ");
INSERT INTO bdd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma tupwana patu baleꞌu lodaꞌudaꞌuleina ꞌoina sibeꞌuwa ma sibwala mwayamwayauwa, weyahina baleꞌuina ꞌiꞌiuna, ");
INSERT INTO bdd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ꞌoinega hala ꞌiꞌalasidiya ma siwelaiya, weyahina geya baleꞌu gogaina siloba. ");
INSERT INTO bdd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma tupwadi patu talitali ꞌoidiya sibeꞌuwa ma sibwala hebwehebweliya, ma geya sowasowahina ma patuwedi sihuwa, weyahina talitali ꞌihewaiwaiya ta ꞌisahila heꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma hesi tupwana patu baleꞌu bwebweꞌana ꞌoina sibeꞌuwa, ma sibwalama sihemadouwa ma sihuwa, ma tupwana patuwedi huwaidi ꞌadi baibaiwa teti, ma tupwadi sikisiti, ma wete tupwadi handeledi. ");
INSERT INTO bdd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Ceguma matenami, gwae bewa wahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Muliyetega boda sisawala ma Yesu ꞌiboinamo, ma tupwadi tomota ma ꞌana tomuliyao site tuwelowedi baꞌidadiyao sinaoma, ma Yesu ꞌoina sihesilala, sigwaeya, “Cino gwae hegehegedi toꞌaha ꞌana nuwasabwalena?” ");
INSERT INTO bdd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Ma Yesu ꞌigwaeya, “Comi moisa Yehoba ꞌoimiya ꞌitagwala ma ꞌina loina huhuna ꞌana tosanapuwao, ma hesi tomota baibaiwadi nuwadi ꞌiꞌelopota ma gwae hegehegedimo sihehesagohe, ma ꞌana nuwasabwalena ꞌabwa geya sisanapu, ma wete ꞌana sanapu siꞌebeꞌebese ma geyaꞌabwa silobaloba. Coinega wete geyaꞌabwa ꞌidi puiyao ꞌoidiyega sinuwanuwabui ma geyaꞌabwa Yehoba ꞌinuwanuwa samudi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma Yesu ꞌihegwaediya, ꞌigwaeya, “Togidega, ꞌigu gwae hegehegediyedi ꞌadi sanapu geya ꞌoimiya, ꞌawa? Ma togidega tupwadi gwae hegehegedi bewa gide wada sanapu ꞌesedi? ");
INSERT INTO bdd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tobegulaina Yehoba ꞌina gwae gide patu ꞌisaweyaneya. ");
INSERT INTO bdd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tupwadi patuwedi sibeꞌuwa ꞌedai, gide tomotaedi Yehoba ꞌina gwae sihesagoheya, ma Seitani ꞌinaoma eema gwaeina ꞌoidiyega ꞌiꞌewa yahulediya. ");
INSERT INTO bdd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Wete gide patuwedi baleꞌu lodaꞌudaꞌuleina ꞌoidiya sibeꞌuwa, ꞌadi sanapu ꞌabehega ꞌeguma tomotaedi Yehoba ꞌina gwae sihesagoheya ma maꞌidi yaliyaya sitagwala, ");
INSERT INTO bdd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ma hesi geya walowalodi paꞌalidi ꞌilagudi, ꞌoinega sauga ꞌiꞌiuna tuwa simiyamiya, ma ꞌabwa to sauga ꞌoina Yehoba ꞌina gwae ꞌana hemisa weyahina mwau nuwana ꞌaleha siloba, beno ꞌoina sibeꞌu mwayamwayau. ");
INSERT INTO bdd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ma patuwedi taudi talitali ꞌoidiya sibeꞌuwa ꞌadi sanapu ꞌabehega tomotaedi taudi Yehoba ꞌina gwae sihesagoheya, ");
INSERT INTO bdd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma hesi ꞌidi nuwatuhu baleꞌu ma wasawasa weyahidi, ꞌoidiyega Yehoba ꞌina gwae siloheꞌamasiya, ma geya sowasowahina huwaidi silagu. ");
INSERT INTO bdd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ma ꞌane patuwedi baleꞌu bwebweꞌana ꞌoina sibeꞌuwa, ꞌana nuwasabwalena ꞌabehega tomotaedi taudi maꞌidi tagwala moisa Yehoba ꞌina gwae sihesagoheya, ꞌoinega huwaidi bwebweꞌadi ma baibaiwadi ꞌilagudiya. Tupwadi huwaidiyao teti, ma tupwadi sikisiti, ma tupwadi handeledi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Yesu ꞌoidiya ꞌigwaeya, “Geyaꞌabwa mayale ꞌasiꞌasilalaina taꞌahusam walata nuwana sita ꞌoidiya, ma hesi ꞌatamana talagu ma ꞌiꞌasilala, ");
INSERT INTO bdd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ma ꞌoinega toꞌaha ꞌatemiya wadahwediya ꞌabwa ꞌasilalaina ꞌiꞌabihe latuhedi ma taꞌitadi. ");
INSERT INTO bdd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ceguma matenami, gwae bewa wahesagohedi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma wete ꞌihegwaediya, “Wanuwatuhuyahi ma gwae wahesagohe bwaibwaini, weyahina toꞌaha ꞌomi ꞌimi ꞌebwaya, wete gide maisa waꞌewa, ma hesi ma ꞌana loheposeyana. ");
INSERT INTO bdd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Weyahina ꞌeguma taiya Yehoba ꞌina tobwatobwa ꞌoina ꞌimiyamiya, tobwatobwaina ꞌiloheposeyane. Ma ꞌeguma taiya geya Yehoba ꞌina tobwatobwa ꞌoina, eema toꞌaha bwebweꞌana ꞌoina ꞌimiyamiya Yehoba ꞌabwa ꞌoinega ꞌiꞌewa yahuledi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma Yesu ꞌigwaeya, “Yehoba ꞌina loina tomota ꞌoidiya gidemusa hewana loheya ꞌina tanoha ꞌidauniya, ");
INSERT INTO bdd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ma loheyaina ꞌiꞌenowa ma ꞌitoholo sabwelo ma nihuwana, ma hewanaina sibwalabwala ma sipilipili, ma hesi ꞌidi bwalaina ꞌana lamu geya ꞌida sanapuya. ");
INSERT INTO bdd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Weyahina baleꞌu ꞌiloiloina ꞌidi bwala ma ꞌidi huwa weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma muliyetega ꞌabwa huwaina ꞌimatuha, ꞌoinega toni tanohaina ꞌiheꞌale ꞌetahi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu wete ꞌihegwaediya, ꞌigwaeya, “Togidega Yehoba ꞌina hetoloina ꞌana gwae hegehegedi yaꞌabi heꞌasilala ꞌese ꞌoimiya? ");
INSERT INTO bdd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nuwana gide ꞌaigeda ꞌaiwe patuna, ꞌoina yagwaebala, beno seyala,* weyahina seyala patuna ꞌiꞌiuna, ");
INSERT INTO bdd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ma ꞌeguma taꞌuma ma ꞌibwala ma ꞌiheꞌaiwe ma lahanao madoudi ꞌilagudi, ma laganaowedi logulogudi ꞌoidiya bwasumowao ꞌidi nehwa siꞌabidi.” ");
INSERT INTO bdd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ꞌina guguya ꞌoina gwae hegehegedi baibaiwadi wete ꞌoidiyega ꞌiheheꞌita. Ceguma tomota ꞌoidiya ꞌimeyameyahana, ma sida sanapu. ");
INSERT INTO bdd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Weyahina tauna sauga baibaiwana gwae hegehegediyega ꞌilologuguya boda ꞌoidiya, ma ꞌana tomuliyaomo ꞌoidiya gwae hegehegediyedi ꞌilihalihasidi. ");
INSERT INTO bdd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lahilahiya Yesu ꞌina heꞌita wagai ꞌilosalohiya, ta ꞌana tomuliyao ꞌihegwaediya, “Wagelu ma tahabala hali tupwa.” ");
INSERT INTO bdd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eeta sigeluwa ma sihabala ma boda holai siꞌebesinediya, ma tupwadi wete wagaina simulimuliye. ");
INSERT INTO bdd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma wediliya madouna silobeya, ta dibana wagai ꞌisiwasiwa taona ma ꞌiꞌiuna sidamana. ");
INSERT INTO bdd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Yesu waga gwahuna ꞌana ꞌulide ꞌilaguya ma ꞌiꞌeno sineya, ma ꞌana tomuliyao silohanohanoya ma sigwaeya, “Bada, ꞌutoholo ma ꞌulememai; ꞌiꞌiuna ꞌaꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma Yesu ꞌitoholowa, ta yaumai ma dibana ꞌiloinaediya, ꞌigwae, “Tuwa! Cuꞌemutugo ma ꞌudaumwala.” Coinega yaumai ꞌilolaguwa ma hola mabwaiyana ꞌidaumwala. ");
INSERT INTO bdd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Toꞌaha weyahina waꞌateyohowa? Togidega ta geya ꞌimi hemisamo?” ");
INSERT INTO bdd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma nuwadi ꞌihepwanopwanowa ma siꞌateyohowa, ma siboidimo ꞌoidiya sigwaeya, “Loheya toꞌatoꞌaha bewa, yaumai ma dibana ꞌenana simuliyeya?” ");
INSERT INTO bdd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Eema sihabala ma siluhuwa meGelasine ꞌidi gadowa. ");
INSERT INTO bdd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Siluhuwa ma Yesu ꞌisuluwa dabala ma loheya ꞌaigeda ꞌilobeya hiꞌahiꞌa* ꞌoina, ꞌina ꞌebemiyaina beno duluha, ꞌoinega ꞌilatuma, ");
INSERT INTO bdd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","ma duluhaina beno tomota ꞌadi galiha. Ma loheya bewa mwalo tomota sitohoya ma ꞌabehega sipai gulahega (beno seni ꞌoinega), ma geya sowasowahidi, weyahina gulahaedi sauga baibaiwana ꞌiupaupadi nimanega ma ꞌahenega. Geya ꞌeta sawasawahina ma ꞌiꞌabiyahi, eeta ꞌidena sinediya ma ꞌitauya pwatula. ");
INSERT INTO bdd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nihuwana ma sabwelo mabwaiyana ꞌoidiya galiha ma ꞌoyai ꞌiꞌasoꞌasona, ma taunamo daꞌuleyega ꞌihunuhunu hila. ");
INSERT INTO bdd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma loheyainaina Yesu bwagebwagega ꞌiꞌiteyama, ma ꞌipilima ta Yesu matana ꞌiꞌetuluha. ");
INSERT INTO bdd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Cabwa tuwa ꞌiꞌasoꞌasona ma ꞌigwae, “Yesu yo, ꞌowa Yehoba tohewaiwai hedada Natuna, toꞌaha ꞌabehega ꞌutohotoho ma ꞌupaihowa ꞌoiguwa? Yaꞌahwanoi ꞌoiuwa Yehoba saninega sahena ꞌuꞌabiꞌabi hemuyemuyegau.” ");
INSERT INTO bdd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gwae bewa ꞌigwaeneya weyahina Yesu ꞌihegwae pwaiya, ꞌigwaeya, “Hiꞌahiꞌa, loheya bewa ꞌoinega ꞌulatu.” ");
INSERT INTO bdd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma Yesu wete ꞌihesilala ꞌigwae, “Togidega saniu?” Ma tauna ꞌigwaeya, “Sanigu Baibaiwa Hedada, weyahina mabodaima loheya bewa ꞌalona ꞌamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ꞌiꞌahwaꞌahwanoi ꞌoheꞌohe Yesu ꞌoina, ꞌigwaeya, “Sahena ꞌasa bewa ꞌoinega ꞌuulaula latuhemai. ");
INSERT INTO bdd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Ma hesi ꞌuhewasaemai ma ꞌaluhu bawe bodaidi nage siduladula ꞌoyai.” ");
INSERT INTO bdd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ꞌitagwalediya ma hiꞌahiꞌaedi loheyaina ꞌoinega silatuwa ma siluhuwa bawe ꞌoidiya, eeta baweyedi sihebuwa ma mabwaiyadi sipili butubutuwa, ma ꞌadeꞌadewala siꞌeloula holai ma sidamana. Baweyedi ꞌadi baibaiwa gide tutausani. ");
INSERT INTO bdd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Coinega bawe ꞌadi toꞌitayahinao ꞌidi matautega sidena ma silatuwa ꞌasai, ma ginauledi siꞌitediya mabwaiyana sihewasaediya ꞌasa madouna ma ꞌasa ꞌiꞌiudi tomotaedi ꞌoidiya. Coinega toniꞌasa sinaoma ma ꞌabehega siboimo matadiyega siꞌita togidega ta ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Coinega Yesu ꞌoina sinaoma, ma loheyaina siꞌiteya, mwalo hiꞌahiꞌa ꞌalona simiyamiya, debana ꞌidumwaluwa ma ꞌaleꞌo ꞌiꞌoteya ta ꞌimiyamiya. Nage ꞌoina mabwaiyadi siꞌateyohowa. ");
INSERT INTO bdd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Coinega tohalewasaedi tomota ꞌoidiya siheꞌoteꞌoteteleya togidega loheyaina ꞌibwebweꞌana ꞌesa ma bawe togidega sihesilae ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nage ꞌoina toniꞌasa sihegaina ma Yesu silososomane ma ꞌabehega ꞌidi tupwa ꞌiꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Coinega Yesu wagai ꞌidobidobi sabi gelu, ma loheyaina nige ꞌiꞌabihe bwebweꞌaneya Yesu ꞌoina ꞌiꞌahwanoiya, ꞌigwae, “Bada, sawasawahina yamuliyego?” ");
INSERT INTO bdd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yesu ꞌigwaeya, “Geya sawasawahina, ma hesi ꞌuhila ma ꞌutau ꞌino susuwao ꞌoidiya ꞌuheꞌoteꞌotetele Yehoba ꞌina ꞌatemuyemuyega ꞌiꞌabihe bwebweꞌanegowa, eema sihesagohe.” ");
INSERT INTO bdd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Coinega loheyaina ꞌitauya ꞌebeloina Dikapoli ꞌasaina nima ꞌeluꞌeluwa ꞌoidiya, ma Yesu ꞌina paihowao waiwaidi weyahidi ꞌiheꞌoteꞌotetela, ma tomota mabwaiyadi sihesagoheya, ta nuwadi ꞌihepwanopwanowa. ");
INSERT INTO bdd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu maꞌana tomuliyao sihabala hila, ma boda madouna siꞌautama gadowaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eema loheya ꞌaigeda sanina Yailo, loheyaina tauna hada tapwalolo ꞌana toꞌitayahina, ꞌinaoma ma Yesu ꞌilobeya, ma matana ꞌituluha, ");
INSERT INTO bdd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ꞌiꞌahwanoi waiwai, ꞌigwaeya, “Bada, natugu mewahinena ꞌana lohala ꞌimwau hedada. Tauna gwamasine tuwa. Nuwanuwagu ꞌunaoma ꞌuꞌabitoho ma ꞌibwebweꞌana, ma sahena ꞌiꞌamaꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eeta Yesu baꞌidana sinaonao, ma boda madouna sihehemulitabubu ma siheheduidui ꞌedai. ");
INSERT INTO bdd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bodaedi ꞌalodiya wahine ꞌaigeda baꞌidadiu maꞌana lohala. Lohalaina beno bweyahina ꞌidaudau bolime tuwelo, ta ꞌabwa tuwa ꞌidaudau. ");
INSERT INTO bdd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mwalo toꞌoba baibaiwadi ꞌoidiya ꞌina mane mabwaiyana ꞌilohegumwaliya, ma hesi ꞌidi paihowaina ꞌoina geya ꞌida bwebweꞌana tohona, ma hesi ꞌana lohalaina ꞌimadomadou. ");
INSERT INTO bdd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Wahineina Yesu ꞌihemuli tabubuweya weyahina mwalo wasana ꞌihesagoheya, ma ꞌatena ꞌinuwanuwatuhu, ꞌigwaeya, “Ceguma tuwa Yesu ꞌana ꞌaleꞌomo yaꞌabitoho beno nata yabwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Coinega ꞌinaowa deina ma ꞌana ꞌaleꞌoina ꞌiꞌabitohoya, ma bweyahina ꞌina dau ꞌilolagu mwayamwayauwa, ma ꞌiboi ꞌana ꞌamna ꞌilotohoya ꞌabehega ꞌibwebweꞌana pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ta Yesu ꞌilotohoya ꞌabehega waiwai ꞌoinega ꞌilatuwa, ma ꞌiꞌita lohihila, ma boda ꞌihesilalediya, ꞌigwae, “Taiya ꞌagu ꞌaleꞌo ꞌiꞌabitohoya?” ");
INSERT INTO bdd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eeta ꞌana tomuliyaowedi sihegwaeya, “Bada, boꞌi ꞌuꞌita pwaiya boda simiya sakowasiyegowa, ma siheheduidui, ma toꞌaha weyahina ꞌuhesilala taiya ꞌiꞌabi tohogowa?” ");
INSERT INTO bdd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yesu ꞌiloꞌita dadana ma ꞌabehega ꞌiꞌita taiya ꞌina waiwai ꞌoina ꞌihabala. ");
INSERT INTO bdd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma wahineina ꞌiboi ꞌilotohoya nage ꞌoina bwebweꞌana ꞌilobeya, ma ꞌinaoma maꞌina dedela ma wete maꞌina ꞌateyoho, eeta ꞌibeꞌuwa ma ꞌiꞌeno talutalubuꞌiya Yesu matana, ꞌihepwaila bwaibwaina ꞌabehega tauna ꞌipaihoweya. ");
INSERT INTO bdd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eeta Yesu ꞌigwaeya, “Natugu, ꞌino hemisega ta ꞌubwebweꞌana. Cutoholo maꞌino yaliyaya ꞌutau. Cino lohalao mabwaiyana sigumwala pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Saugaina ꞌoina Yesu ꞌigwaegwae wahineina ꞌoina, ma tupwadi loheloheya wasa siꞌeweyama Yailo ꞌina hadega, sigwaeya, “Natuu yawasina ꞌigumwala, ma sahena wete toheꞌitaina ꞌina sauga ꞌuꞌabiꞌabiyahi.” ");
INSERT INTO bdd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Yesu wete wasaina ꞌihesagoheya, ta Yailo ꞌihegwaeya, ꞌigwae, “Sahena ꞌuꞌateꞌateyoho, ma hesi ꞌuhemisegau.” ");
INSERT INTO bdd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Coinega Yesu boda madouna ꞌiꞌausidiya ma sahena simulimuliye, ma hesi ꞌana tomuliyao sitetoi baꞌidanao, beno Pita ma Yemesa ma tasina tauna Yoni, ");
INSERT INTO bdd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","sinaonao ta Yailo ꞌina hada silatuwa, ma wui ma dou madouna sihesagoheya. ");
INSERT INTO bdd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta Yesu ꞌiluhuwa ma ꞌihegwaediya, “Toꞌaha weyahina wawuiwui ma wadoudou? Gwama bewa geya ꞌiꞌamasa, tuwa ꞌiꞌenoꞌeno.” Ma sihenamaeya. ");
INSERT INTO bdd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sihehenama, eeta Yesu ꞌipaꞌidiya ta silatuwa ꞌatamana, ma gwama tamana ma sinana maꞌana tomuliyao sitetoiyedi Yesu baꞌidanao siluhuwa gwamaina ꞌina ꞌebeꞌenowa. ");
INSERT INTO bdd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma gwamaina nimana Yesu ꞌiꞌabiya ma ꞌigwaeya, “Talita kumi.” Ma ꞌana bui, “Gwamasine ꞌutoholoma.” ");
INSERT INTO bdd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nage ꞌoina ꞌitoholo mwayamwayauwa ma ꞌiyawala, weyahina ꞌana bolime tuwelo ꞌilobeya. Tamana ma sinana nuwadi ꞌihepwanopwanowa moisa. ");
INSERT INTO bdd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Yesu ꞌiꞌausidiya, ꞌigwae, “Sahena taiya ꞌeta ꞌoina wahehepwaila ꞌigu paihowa bewa weyahina, ma hesi gwama ꞌana waꞌebwae ma ꞌiꞌai.” ");
INSERT INTO bdd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu maꞌana tomuliyao ꞌasa nage siꞌebesineya ma sihilama ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma Sabatiya ꞌidi hada tapwalolo ꞌoina ꞌiluhuwa ꞌiheheꞌita, ma tomota sihesagoheya, ta mabwaiyadi nuwadi ꞌihepwanopwanowa ꞌina sanapu ma ꞌina paihowa weyahidi, ma sigwaeya, “Loheya bewa toꞌehega ꞌina sonoga ꞌilobeya? Ma wete paihowaedi waiwaidi nimanega ꞌipaihowediya ma toꞌehega waiwaiina ꞌilobeya?” ");
INSERT INTO bdd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma sigwaeya, “Loheya bewa toꞌabi hada tuwa. Ma sinana Meli, ma tasinao Yemesa ta Yosese ta Yudasa ta Saimoni, ta wete nuhunao baꞌidadao tamiyamiya, ꞌawa?” Coinega Yesu silogwahateya. ");
INSERT INTO bdd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Yesu ꞌihegwaediya, ꞌigwae, “Palopitao siheꞌasisiyanedi hali ꞌasa ꞌoidiya, ma taudi ꞌidi ꞌasa geya. Weyahina tuwa taudi ꞌidi bodao, wete ꞌidi susuwao, silologwahatedi.” ");
INSERT INTO bdd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Coinega Yesu nuwana ꞌihepwanopwanowa weyahina tomotaedi geya sihemise, eeta geya sawasawahina ma paihowa waiwaidi ꞌebwa ꞌipaihowadi. Beno tuwa tolohalao tupwadi ꞌiꞌabi tohodiya ma sibwebweꞌana. Coinega Yesu ꞌisakowasiya ꞌasa ꞌoidiya, ꞌiheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma ꞌana tomuliyao site tuwelo ꞌibwauwediya, ma ꞌiloinaediya ma ꞌabehega ꞌeluwa ꞌeluwa sisakowasi ꞌasa ꞌoidiya, ma wete loina ma waiwai ꞌiꞌebwaediya ma ꞌoinega sawasawahidi hiꞌahiꞌa tomota ꞌoidiyega siula latuhedi, ");
INSERT INTO bdd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ta ꞌina guguya ꞌoina ꞌiloinaediya, ꞌigwae, “Geyaꞌabwa ꞌeta toꞌaha waꞌewaꞌewa. Sahena ꞌeꞌahai nuwana peha bo mane. Beno tuwa ꞌimi guna nimamiya, ");
INSERT INTO bdd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ma ꞌami butu waꞌotedi, ma hesi sahena ꞌwama ꞌeluwa waꞌoteꞌotedi.” ");
INSERT INTO bdd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma wete ꞌihegwaediya, “Ceguma to hada ꞌoina sibwauwegomiya ma ꞌoina waluhuluhu, hadaina ꞌoina wahehada ma ꞌana siga tupwaina waꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma hesi ꞌeguma ꞌasa tupwadi ꞌoidiya walatu ma tomotaedi geya sibwauwegomi ma wete geya ꞌimi loguguya sihesagohe, ꞌasaedi ꞌahemi gawalana ꞌoina walohutuhutu yahule ma waꞌebesine, ma ꞌoinega waheꞌitadi ꞌabehega nata mwau ꞌoidiya ꞌilatu.” ");
INSERT INTO bdd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Coinega ꞌana tomuliyaowedi sisakowasiya ꞌasa mabwaiyana ꞌoidiya, siguguya ma ꞌabehega tomota mumugadi galana silogwahatedi ma sinuwabui, ");
INSERT INTO bdd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ta hiꞌahiꞌa tomota ꞌoidiyega siula latuhedi ta tolohalao mabwaiyadi wete siheholoidi ma sibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Coinega Yesu wasana tomota sihewasa dadaneya ꞌasa mabwaiyana ꞌoidiya, ma Kini Helodi ꞌihesagoheya. Weyahina tupwana tomota sigwaegwae ꞌabehega, “Yoni toꞌabihebabitaiso ꞌamasega ꞌitoholo hila, ma maꞌina waiwai madouna ꞌipaipaihowa.” ");
INSERT INTO bdd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tupwadi sigwae ꞌabehega, “Tauna tuwa Ilaitiya.” Ma wete tupwadi sigwae, “Tauna palopita ꞌaigeda gide palopitaowedi nugenugetaidi.” ");
INSERT INTO bdd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helodi wete wasana ꞌihesagoheya ma ꞌigwae, “Nuwana tauna Yoni toꞌabihebabitaiso. Mwalo yaloheꞌamasiya, ma nuwana ꞌitoholohila.” ");
INSERT INTO bdd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Weyahina mwalo Helodi Yoni ꞌiꞌabiyahiya ma deliya ꞌipaiya, ma Yoni ꞌana ꞌabiyahina lamuna beno wahine ꞌaigeda sanina Helodiyasa, beno Helodi tasina Pilipi mwanena ma Helodi ꞌiꞌeweya, ta baꞌidana sihaiya. ");
INSERT INTO bdd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Eema Yoni Helodi ꞌihegwaeya ꞌabehega, “Nage geya mumuga bwebweꞌana,” weyahina tasina mwanena ma ꞌihaiya. ");
INSERT INTO bdd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ma Yoni ꞌina guguyaina weyahina wahineina ꞌinuwagala ma nuwanuwana Yoni ꞌida loheꞌamasi, ma hesi geya sawasawahina, ");
INSERT INTO bdd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","weyahina Helodi ꞌinuwahiya ꞌabehega Yoniina tauna loheya dumwadumwaluna Yehoba ꞌina topaihowa ꞌaigeda, ꞌoinega Helodi Yoni ꞌiheꞌasisiyeya, ma sauga baibaiwana Helodi nuwanuwana ma Yoni ꞌina gwae ꞌihesagohe, ma weyahina ꞌiꞌateyohowa. ");
INSERT INTO bdd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Eeta Helodiina ꞌina sauga liꞌu ꞌana sabwelo ꞌilatuwa ma Helodiyasa ꞌedaꞌeda ꞌinuwalobeya Yoni ꞌana loheꞌamasa weyahina. Sabwelo liꞌu ꞌana ꞌebenuwa tuhuyahina ꞌeꞌahaina siꞌatububuya, ma tupwadi taumanao sitoedima ꞌaiina ꞌoina. Taumanaedi gabemani ꞌadi tohanugetao ma toloꞌaleha ꞌadi tohanugetao, ma wete tupwadi Galili ꞌasaina ꞌadi babadao. ");
INSERT INTO bdd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Saugaina Helodiina ma ꞌana taumanao siꞌaiꞌai, Helodiyasa natuna mewahinena ꞌiluhuma matadiya ma selowega ꞌiꞌabihe yaliyayediya. Eeta Helodi gumalaulauina ꞌoina ꞌigwae helauwa ꞌigwae, “Ceguma toꞌaha ꞌino hesinuwa ma ꞌoiguwa ꞌuꞌahwanoi, yatagwala ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma wete ꞌibwauhaneya tamada, ꞌigwaeya, “Moisa tuwa yagwae hemisa, toꞌaha nuwanuwau yaꞌebwaego, ꞌeguma ꞌuꞌahwanoi ꞌigu ꞌebeloina weyahina yawatahi, ma tupwana yaꞌebwaego.” ");
INSERT INTO bdd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Coinega gumalaulauina ꞌihapwesa, ma ꞌitauya sinana ꞌoina, ꞌihesilala, ꞌigwae, “Sinagu toꞌaha ꞌino nuwatuhu ma kini ꞌoina yaꞌahwanoiye?” Ma sinana ꞌigwaeya, “Kini ꞌuhegwae, ꞌugwae, ‘Nuwanuwagu Yoni toꞌabihebabitaiso mwaguna.’” ");
INSERT INTO bdd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eeta gumalaulauina ꞌilomwayamwayauwa, ma ꞌihila kina ꞌoina, ꞌigwaeya, “Nuwanuwagu sauga bewa Yoni toꞌabihebabitaiso mwaguna gaeba ꞌoina ꞌudoꞌo, ma ꞌuꞌebwaegau.” ");
INSERT INTO bdd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Helodi ꞌinuwagala, ma geya sawasawahina ma ꞌiguipaila, weyahina ꞌibwauhaneya tamada taumanaowedi wete matadiya, ");
INSERT INTO bdd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","eeta deli ꞌana toꞌitayahi ꞌaigeda ꞌiloinaeya ꞌabehega ꞌitauya ma Yoni mwaguna ꞌiꞌupweyama. Ta ꞌoinega toꞌita yahinina deliya ꞌitauya ma Yoni ꞌaniꞌona ꞌiꞌupweya, ");
INSERT INTO bdd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ta mwaguna gaeba ꞌidoꞌoya ta ꞌiꞌeweyama gumalaulauina ꞌiꞌebwaeya, ma tauna ꞌiꞌahaliya, ꞌitauyeya sinana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma Yoni ꞌana tomuliyao ꞌina ꞌamasa wasana sihesagoheya, ma sinaoma ma Yoni wahina siꞌeweya ma sigaliheya. ");
INSERT INTO bdd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ma Yesu ꞌina topaihowao site tuwelo sihilama ma Yesu ꞌoina ꞌidi paihowa ma ꞌidi heꞌita mabwaiyana sihepwailediya. ");
INSERT INTO bdd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma tomota baibaiwadi sinaonaoma ma sihilahila, ta ꞌoinega geya sawasawahina ma Yesu ꞌana tomuliyao siꞌaiyawasi ma siꞌai, ꞌoinega ꞌihegwaediya, ꞌigwae, “Tupwa bewa taꞌebesine ma tatauya yoho ꞌawawa, ma nobwa tupwana waꞌaiyawasi.” ");
INSERT INTO bdd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eeta siboidimo wagai sigeluwa, ma sihabala ꞌaigeda tupwaina ꞌoina, beno yoho ꞌawawa. ");
INSERT INTO bdd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma bodaedi Yesu maꞌana tomuliyaowedi ꞌidi geluina siꞌiteya, ma sisanapuya tupwaina ꞌoina sitautauya, ꞌoinega taudi ma ꞌasa mabwaiyadi ꞌadi tomiyao wete mahetediyao ꞌedega sipilipili, ma silatu nugeta tupwainaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cabwa muliyetega waga ꞌiluhuwa ma Yesu ꞌisuluwa dabala, ma boda madouna nenegwala ꞌiꞌitediya ma ꞌiꞌate muyamuyaediya, weyahina taudi gide sipiyao geya ꞌadi toꞌitayahinamo, ꞌoinega ꞌiheꞌaleya ma sanapu baibaiwana ꞌiheꞌitaeya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma lahilahiya ꞌana tomuliyaowedi sinaoma, ma Yesu ꞌoina sigwaeya, “Bada, tupwa bewa yoho ꞌawawa ma sinala ꞌisopusopu, ");
INSERT INTO bdd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ꞌoinega bodaedi bewa ꞌuhesumanedi, ma sitauya, ma ꞌadi sigimwane ꞌasai ma hada deidiya ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yesu ꞌihegwaediya, ꞌigwae, “Ma togidega? Comi geya sowana waheꞌaidi, ꞌawa?” Ma ꞌana tomuliyao sigwaeya, “Bada, geya sawasawahina, weyahina mabwaiyadi ꞌadi ꞌana maisa gide tausani kina.” ");
INSERT INTO bdd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta Yesu ꞌihesilalediya, ꞌigwae, “Hisa beledi ꞌoimiya. Watauya waꞌebesa.” Sitauya ma silobeya, ma Yesu sihegwaeya, sigwae, “Beledi nima ma silahana ꞌeluwa ꞌalobediya.” ");
INSERT INTO bdd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Coinega boda ꞌiloinediya ma mabwaiyadi simiyatoiya boda ma boda pwatula ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ceeta siwatahidiya simiyatoiya, boda tupwadi handeledi, ma boda tupwadi pipiti. ");
INSERT INTO bdd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma beledi nima ma silahana ꞌeluwaedi ꞌiꞌewediya, ma galewa ꞌiloꞌita haneya ma ꞌigwae helau ꞌeꞌahaiyedi weyahidi, ma muliyetega belediyedi ꞌihisidiya ma ꞌana tomuliyaowedi ꞌiꞌebwaediya, eeta siheguyaiyediya. Ma silahana ꞌeluwaedi wete gidemusa ꞌihisidiya ma ꞌiꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Coinega mabwaiyadi siꞌaiya ma simwausuwa. ");
INSERT INTO bdd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma beledi ma silahana tupwatupwadi sidomwa ꞌautediya ma kodo tuwelo silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Toꞌaiyedi loheloheyamo sihasilidiya ꞌadi baibaiwa gide paibi tausani. ");
INSERT INTO bdd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cigumwala ma ꞌana tomuliyaowedi ꞌiloinaediya ma wagai sigelu, ꞌigwaeya, “Wagelu ma wanugeta Bedeseida hali tupwa, ma taugu ꞌabwa boda yahetauidi ma sihila ꞌidi ꞌasa.” ");
INSERT INTO bdd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Coinega sigeluwa ma Yesu boda ꞌihetauidiya, ma muliyetega ꞌihaneya ꞌoyai sabi ꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ciboi pwaiya ma ꞌana tomuliyaowedi niꞌu ꞌawawa siꞌadaꞌadau, ma tauna ꞌiboinamo ꞌoyaꞌoya, ");
INSERT INTO bdd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ꞌiꞌitediya ꞌidi wose ꞌoinega wahidi ꞌisabulolowa, weyahina yaumai matadiyega ꞌitowatowama. Ma sauga ꞌiꞌiuna ma gona ꞌiꞌadale, eeta Yesu hola debanega ꞌitauya ma ꞌabehega deidiyega ꞌinao ma ꞌiꞌebesinedi. ");
INSERT INTO bdd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Eeta ꞌana tomuliyaowedi Yesu siꞌiteya hola debanega ꞌinaonaoma, ma ꞌidi nuwatuhu ꞌabehega welabana, ");
INSERT INTO bdd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ꞌoinega simatauta ma siwuiya. Ma Yesu ꞌihegwaediya, ꞌigwae, “Sahena waꞌateꞌateyoho. Taugu tuwa, ꞌimi Badaina.” ");
INSERT INTO bdd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma wagai ꞌigeluwa baꞌidanao ma yaumai ꞌigumwala. Ma nuwadi ꞌihepwanopwanowa madouna, ");
INSERT INTO bdd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","weyahina Yesu ꞌina waiwai lamuna geya sinuwa sabwalena. Ceguma saugenina tomota baibaiwadi ꞌadi beledi Yesu ꞌiheguyaiya ma lamuna sida sanapuya ma ꞌoinega nuwadi ꞌida sabwalena, ma hesi geya sida sanapuya, weyahina nuwadi ꞌiꞌelopota. ");
INSERT INTO bdd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Coinega sihabala tupwa Genesaleta gadowaina ꞌoina, siluhuwa, ma ꞌidi waga nage ꞌoina silohoya. ");
INSERT INTO bdd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma saugaina sisuluma toni ꞌasaedi Yesu siꞌinaneya, ");
INSERT INTO bdd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ma ꞌoinega tomotaedi sihila ꞌasa mabwaiyana ꞌoidiya ma tolohalao siꞌewedima ꞌebeꞌeno ꞌoidiyega, ma Yesu ꞌoina sitauyediya, ꞌeguma sihesagohe to tupwa ꞌoina ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma Yesu ꞌisakowasi tupwa mabwaiyana ꞌoidiya, tupwana ꞌasa madouna ma ꞌasa ꞌiꞌiudi ma tanoha ꞌoidiya. Ma tomota baibaiwadi ꞌidi tolohalao siꞌewedima ꞌebe maketi ꞌoidiya siyamwayamwa, ma siꞌahwanoiyeya, sigwae, “Bada, sawasawahina ꞌima tolohalaowedi ꞌa ꞌaleꞌo papalina siꞌabitoho?” Eeta Yesu ꞌoidiya ꞌitagwala. Coinega taudi ꞌana ꞌaleꞌo siꞌabitohoya ta sibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ta Palisiyao ma loina ꞌana toheꞌitao tupwadi wete baꞌidadiyao Yelusalemega sinaoma ma Yesu ꞌoina sihegogona, ");
INSERT INTO bdd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ma tupwadi ꞌana tomuliyao siꞌita lobediya manima biꞌibiꞌidi siꞌaiꞌai, geya nimadi sideulidi. ");
INSERT INTO bdd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Weyahina Palisiyao ma wete meYudiya mabwaiyadi mumugadi tubudiyaowega tuwa gide, nugeta nimadi sideuli bwaibwainidi ꞌabwa siꞌai. ");
INSERT INTO bdd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma ꞌeguma ꞌebe gimwane ꞌoinega sinaoma nimadi sideuli nugete ꞌabwa siꞌai. Ma wete loina baibaiwana tubudiyao ꞌoidiyega gaeba ma biyo ma walata ꞌadi deula weyahina simulimuliye. ");
INSERT INTO bdd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Coinega bewa Palisiyao ma loina ꞌana toheꞌitaowedi Yesu ꞌoina sihesilala, sigwae, “Toꞌaha weyahina ꞌa tomuliyaowedi tubudao ꞌidi loina geya siheꞌasisiyanedi, ma manima biꞌibiꞌidi siꞌai?” ");
INSERT INTO bdd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Yesu ꞌihegwaediya ꞌigwae, “Comi toꞌeꞌaboꞌabo. Mwalona Aiseya palopita weyahimi ꞌigwae nugeta bwaibwaina, Yehoba ꞌina gwae ta sileleya bewa gide: Tomotaedi ꞌahwadiyega siheꞌasisiyanegau, ma hesi ꞌatediyega geya. ");
INSERT INTO bdd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma wete ꞌoiguwa sitapwatapwalolo bwagabwaga, weyahina ꞌidi heꞌitao taugu geya ꞌoiguwega, ma hesi tomota tuwa ꞌidi nuwatuhuwega.” ");
INSERT INTO bdd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ma Yesu ꞌihegwaediya wete, ꞌigwae, “Mumugami galana! Yehoba ꞌina loina wadahweya ma hesi tubumiyao mumugadi wamulimuliyedi.” ");
INSERT INTO bdd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma wete ꞌigwaeya, “Cabehega ꞌomi tosanapu moisa, ma hesi geya; weyahina Yehoba ꞌina loinao waguiguipailedi, ma hesi tubumiyao mumugadi waꞌabiꞌabi yahidi. ");
INSERT INTO bdd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mwalo Mosese Yehoba ꞌina loina moisa ꞌiꞌebwaediya, ꞌigwae, ‘Tamau ma sinau ꞌuheꞌasisiyanedi.’ Ma wete, ‘Ceguma taiya tamana ma sinana ꞌiꞌahwa galagalaedi ꞌilobwaineya ma waloheꞌamasi.’ ");
INSERT INTO bdd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma ꞌomi ꞌimi heꞌita ꞌaboꞌaboina wagwae, ‘Ceguma ꞌaigeda taiya tamana ma sinana ꞌihegwaedi, ꞌigwae, “Cigu tobwatobwao yatagwala pwaiyeya Yehoba ꞌoina ma heheꞌasisiyaina, ꞌoinega geya sawasawahina ma yalemegomi.” ’ ");
INSERT INTO bdd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bewa ꞌimi loinaina ꞌoinega loheya tamana ma sinana ꞌadi lema waꞌauꞌausi. ");
INSERT INTO bdd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tubumiyao ꞌidi loina bewa ꞌoinega, Yehoba ꞌina loina waheginaula bwagebwageya, ma ꞌimi heꞌitao baibaiwadi gide geya Mosese ꞌina loinao Yehoba ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Coinega boda ꞌibwau hiledima ma ꞌihegwaediya, “Cigu gwae bewa mabwaiyami wahesagohe, ma nuwami ꞌiꞌeloꞌasilala. ");
INSERT INTO bdd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Geya ꞌeta toꞌaha taꞌai ma siꞌabiꞌabi hebiꞌigita, ma hesi ginauledi ꞌatedega silatulatu sawasawahidi ma siꞌabihe biꞌigita.” ");
INSERT INTO bdd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO bdd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eeta Yesu maꞌana tomuliyao boda siꞌebesinediya ma hadai siluhuwa, eema ꞌana tomuliyaowedi sihesilaleya sigwae, “Sawasawahina ꞌino gwae hegehegediina ꞌulihasi ꞌoima?” ");
INSERT INTO bdd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Eeta Yesu ꞌihegwaediya, “Nuwana ꞌomi wete nuwami geya ꞌiꞌeloꞌasilala, ꞌawa? Coinega geya wasanapu ꞌabehega toꞌaha taꞌaiꞌai ma ꞌiluhuluhu ꞌaloda geya wete ꞌida ꞌabihebiꞌigita, ");
INSERT INTO bdd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","weyahina geya ꞌateda ꞌiluhu, ma hesi gamwadamo ꞌoina ꞌiluhuwa ma muliyetega ꞌilatu mohomoho ꞌoina.” (Yesu ꞌina heꞌita bewa ꞌana sanapu ꞌabehega geya ꞌeta wete ꞌeꞌahai heheꞌasisina, ma hesi mabwaiyana taꞌai.) ");
INSERT INTO bdd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma Yesu wete ꞌigwaeya, “Toꞌaha tomota ꞌatediyega silatulatu sawasawahina ma siꞌabihe galegita, ");
INSERT INTO bdd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","gidemusa nuwatuhu galana ma logwali, yagaha, loheꞌamasa, pui, ");
INSERT INTO bdd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lomata tobwatobwa, gamwasowala, ꞌabo, ganawala, heꞌipiꞌipi, sinala, nuwahane, ma heyauyaule. ");
INSERT INTO bdd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bewa ginauledi galadi tomota ꞌalodiyega silatulatu ma sigihegihe biꞌidi.” ");
INSERT INTO bdd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nage ꞌoina Yesu ꞌitoholowa ma ꞌitauya Taiya ma Saidoni tupwaidiina, ma ꞌaigeda hada ꞌoina ꞌiluhuwa, weyahina geya nuwana ma tomota sisanapu ꞌina latu weyahina, ma hesi geya sawasawahina ma ꞌiꞌedahwana, ");
INSERT INTO bdd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","weyahina ꞌaigeda wahine Yesu ꞌina latu wasana ꞌihesagoheya. Ma wahineina geya wahine Yudiya ma hesi tauna gwama Pinisiya, tupwa Siliya ꞌalonega, ma natuna mewahinena hiꞌahiꞌa ꞌiꞌabi hegaleya, eeta sinana ꞌinaoma ma Yesu ꞌahena ꞌituluha ma ꞌiꞌahwanoiya ma ꞌabehega hiꞌahiꞌa natuna ꞌoinega ꞌida paꞌi. ");
INSERT INTO bdd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yesu ꞌigwaeya, “Cilobwaineya ma sedaseda ꞌadiwa yaꞌebwaya nugetedi, ma geya sawasawahina ma sedaseda ꞌadiwa ꞌedewa yaꞌebwaedi.” ");
INSERT INTO bdd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wahine ꞌigwaeya, “Cehe moisa Bada, ma hesi ꞌedewa ꞌebeꞌai gabulena sedaseda ꞌadiwa mohomohona ꞌoinega siꞌaiꞌai.” ");
INSERT INTO bdd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Yesu ꞌigwaeya, “Yauwedo! Beno gwae moisa. Coinega ꞌutoholo ma ꞌuhila ꞌino hada. Hiꞌahiꞌa natuu ꞌoinega ꞌilatuwa ma ꞌibwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eeta wahineina ꞌitoholowa ma ꞌitauya ꞌina hada, ma natunaina ꞌilobeya ꞌina ꞌebeꞌeno ꞌoina ꞌibwebweꞌana pwaiya. ");
INSERT INTO bdd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma Yesu Taiya ꞌiꞌebesineya, ta ꞌitauya Saidoni, ꞌoinega wete ꞌihataona Dikapoli tupwaina ꞌoidiya, ma ꞌihapwesama Galili holai. ");
INSERT INTO bdd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ꞌaigeda loheya siꞌeweyama Yesu ꞌoina, tauna tenatuituina ma wete guguguguina, ma Yesu siꞌahwanoiyeya ma ꞌabehega ꞌiꞌabitoho ma ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma Yesu loheyaina ꞌitoeya ma boda ꞌoidiyega sihawasiya siboidimo, ma Yesu nima matagigina ꞌoinega loheya tenana ꞌilagu luhuwediya, ma muliyetega ꞌiboi nimana ꞌiꞌesoheya ma loheya memenana ꞌiꞌabitohoya, ");
INSERT INTO bdd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ꞌoinega Yesu ꞌiloꞌita hane galewa, ma ꞌatemuyemuyega ꞌigwaeya, “Epapata,” beno ꞌana bui “Culosabwalena.” ");
INSERT INTO bdd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eeta loheyaina tenana silosabwalena, ma wete memenana ꞌibwebweꞌana, ma sawasawahina ꞌigwae ma ꞌihesagoha dumwalu. ");
INSERT INTO bdd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Yesu tomota ꞌiꞌetobodediya ma ꞌabehega geyaꞌabwa taiya ꞌoina sida hehepwaila. Ma ꞌetobodaina geya sihesagohe, ma hesi siheꞌoteꞌotetela dadaneya tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tomotaedi sihesagoheya nuwadi ꞌihepwanopwanowa madouna, ma sigwae, “Cina paihowa mabwaiyana bwebweꞌana ma ꞌebenuwa pwanopwano, weyahina totenatui ma guguguguidi ꞌiꞌabihe bwebweꞌanediya ta sowasowahina sihegwaegwae, ma sihesagoha.” ");
INSERT INTO bdd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sauga nage ꞌoina boda madouna wete sihegogonama Yesu ꞌoina, ma geya ꞌadimo. Coinega ꞌana tomuliyao ꞌibwauwedima, ma ꞌihegwaediya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tomota bewa yaꞌate muyamuyaediya, weyahina sabwelo ꞌetoi ꞌebwa baꞌidadao tamiyamiya, ma geya ꞌadimo. ");
INSERT INTO bdd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ceguma magomaledi yahesumanedi, tabu ma ꞌedai sihemwalomwalohana, weyahina tupwadi bwagebwagega sitauyama.” ");
INSERT INTO bdd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eeta Yesu ꞌana tomuliyaowedi sihegwaeya, sigwae, “Togidega tupwa yoho ꞌawawa ꞌoina tomotaedi bewa ꞌadi taloba ꞌese?” ");
INSERT INTO bdd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Coinega Yesu ꞌihesilalediya, ꞌigwae, “Hisa ꞌami belediyao simiyamiya?” Ma sigwae, “Sebenimo.” ");
INSERT INTO bdd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eeta boda ꞌiloinediya ma baleꞌuwa simiyatoiya. Simiyatoiya ma beledi sebeniyedi ꞌiꞌewediya ma weyahidi ꞌiloyauwedowa Yehoba ꞌoina, ma ꞌiꞌehisihisiya, ꞌiꞌebwaediya ꞌana tomuliyao ꞌoidiya, ma tomota siꞌebwaediya, eema siheguyai sakowasiyeya. ");
INSERT INTO bdd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma wete tupwana silahana ꞌiꞌiudi simiyamiya, weyahidi Yesu ꞌigwae helauwa Yehoba ꞌoina, ma ꞌana tomuliyaowedi ꞌiloinediya, ma siheguyaiyedi tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Coinega mabwaiyadi siꞌaiya ta simwausuwa, ma muliyetega ꞌeꞌahai tupwatupwadi sidomweya ma kodo sebeni silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma bodaedi ꞌadi baibaiwa gide powa tausani. Eeta ꞌihewasa hilediya. ");
INSERT INTO bdd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tuta nage ꞌoina ꞌana tomuliyao baꞌidanao ꞌidi waga sigeluwa ma sinaowa Dalimanuta tupwaina. ");
INSERT INTO bdd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Eeta Palisiyao sinaoma, ma Yesu ꞌoina siheꞌoheꞌohena, ma sitohoya ma ꞌabehega galewega ꞌilaꞌilala ꞌida heꞌitae ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma Yesu maꞌina nuwagala ꞌihegwaediya ꞌigwae, “Togidega ma ꞌoinega yaso bewa nuwanuwami ꞌilaꞌilala, ma hesi geya ꞌeta waꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Coinega ꞌiꞌebesinediya ma wagai ꞌigeluwa, ma sihabala hali tupwa. ");
INSERT INTO bdd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma hesi ꞌadi haite sinuwanaideya, ma beledi ꞌaigeda tuwa wagai ꞌitupwa. ");
INSERT INTO bdd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yesu ꞌihemataluwediya, ꞌigwae, “Waꞌita Palisiyao ma Helodi ꞌadi beledi ꞌana ꞌebe ꞌabiheseseha ꞌoinega waꞌita yahigomi.” ");
INSERT INTO bdd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Coinega tomuliyaowedi siboidimo ꞌoidiya sigwaeya, “Yesu ꞌina gwaeina lamuna weyahina ꞌada haiteina tanuwanaideya.” ");
INSERT INTO bdd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesu ꞌidi nuwatuhu ꞌisanapuya, ꞌoinega ꞌihegwaediya, “Toꞌaha weyahina wagwaegwae ꞌabehega geya ꞌami haitemo? Beno geya weyahina taugu yagwaegwae. Togidega ꞌimi nuwatuhu siꞌelopota ma geya sawasawahina ma ꞌigu gwae lamuna wasanapu. ");
INSERT INTO bdd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mamatami ma geya waꞌita, ma wete matenami ma geya wada hesagoha, ꞌoinega geyaꞌabwa wanuwanuwa tuhuyahi ꞌigu paihowao boda ꞌadi heꞌai weyahina, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tutaina beledi nima ꞌoinega tomota paibi tausani yaheꞌaidiya hisa kodo ꞌulaheya ꞌoidiyega wahegogonediya?” Ma sigwae “Tuwelo.” ");
INSERT INTO bdd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma Yesu ꞌihenaida wete ꞌigwaeya, “Ma tutaina beledi sebeni ꞌoinega tomota powa tausani yaheꞌaidiya, ma hisa kodo ꞌulaheya ꞌoidiyega wahegogoneya?” Ma sigwae, “Sebeni.” ");
INSERT INTO bdd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Coinega Yesu ꞌigwaeya, “Comi togidega ta geya nuwami ꞌida sabwalena.” ");
INSERT INTO bdd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Eeta Bedeseida ꞌoina sitauyama, ma loheya ꞌaigeda mata gibugibuina sitoeyama Yesu ꞌoina, siꞌahwanoiyeya ꞌabehega ꞌiꞌabitoho ma ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Coinega Yesu tomata gibugibuina nimana ꞌoina ꞌiꞌabiya ma ꞌitoeya, ꞌasaina siꞌebesineya. Ma Yesu loheyaina matana ꞌihulasiya, ma nimanega matanaina ꞌiꞌabitohodiya, ma ꞌihegwaeya, “Sawasawahina toꞌaha ꞌuꞌitadi?” ");
INSERT INTO bdd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Coinega loheyaina ꞌiloꞌita dadana ma ꞌigwaeya, “Tomota yaꞌitediya, ma ꞌadi ꞌita gide tuwa ꞌaiwe siꞌeꞌelo yawala.” ");
INSERT INTO bdd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma wete Yesu loheyaina matana ꞌiꞌabitoho hilediya, ma ꞌiꞌebubuna, eeta ꞌiꞌasilala bwaibwaina, ma ginaula mabwaiyadi ꞌiꞌitediya. ");
INSERT INTO bdd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Coinega Yesu ꞌihewasaeya, ꞌigwae, “Geyaꞌabwa ꞌuhilahila ꞌasa madouna ꞌoina, ma hesi ꞌutauya ꞌuboi ꞌino hada.” ");
INSERT INTO bdd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ta Yesu maꞌana tomuliyao sinaonao Sisaliya Pilipai tupwaidi weyahidi ma ꞌedai ꞌana tomuliyaowedi ꞌihegwaediya, ꞌigwae, “Togidega tomota ꞌidi gwae weyahigu wahesagohediya ꞌabehega taiya taugu?” ");
INSERT INTO bdd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma tomuliyaowedi sigwae, “Tomota tupwadi sigwaeya ꞌabehega ꞌowa Yoni Toꞌabihebabitaiso, ma wete tupwadi sigwae ꞌabehega ꞌowa Ilaitiya, ma tupwadi sigwae ꞌabehega ꞌowa palopita nugenugetaina ꞌaigeda.” ");
INSERT INTO bdd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Coinega wete ꞌihesilalediya, “Ma ꞌomi togidega ꞌimi nuwatuhu ꞌabehega taugu taiya?” Eema Pita ꞌihemaiseya ꞌigwae, “Cowa Keliso Toꞌabihetenaina.” ");
INSERT INTO bdd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Yesu ꞌiloina paꞌalediya, ꞌigwae, “Geya sawasawahina ꞌeta taiya ꞌoina wahehepwailegau.” ");
INSERT INTO bdd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma Yesu ꞌiheꞌale ꞌiheꞌita ꞌoidiya toꞌaha ꞌabwa ꞌoina ꞌilatu, ma ꞌigwaeya, “Taugu Loheyaiguina ꞌabwa muya madouna yaloba. Weyahina babada ta topwaoli madoudi ta loina ꞌana toheꞌitao ꞌabwa silogwahategau ma siloheꞌamasigau, ma sabwelo ꞌetoi mulina ꞌabwa yatoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ꞌina gwaeina bewa ꞌoinega ꞌilagu hemasalaheya ꞌina ꞌamasa weyahina. Coinega Pita Yesu ꞌitoeya, ma mahetena sinaowa hagana, ma Pitaina ꞌiꞌausiya ma ꞌabehega ginauledi sahena silatulatu Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Yesu ꞌihasakowasi ma ꞌana tomuliyao ꞌiꞌeꞌebubudiya, ma ꞌiheliya Pita ꞌoina, ꞌigwaeya, “Cowa Seitani, bewa sauga ꞌuꞌebesinegau! Weyahina ꞌino nuwatuhuwedi nuwatuhu ꞌasa gabulena ꞌana nuwatuhu, ma hesi geya Yehoba ꞌina nuwatuhu gide.” ");
INSERT INTO bdd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Coinega Yesu boda mabwaiyadi ma wete ꞌana tomuliyao mahetediyao ꞌibwau heꞌautedima, ma ꞌihegwaediya, ꞌigwae, “Taiya ꞌeguma nuwanuwana ma ꞌimuliyegau, ꞌilobwaineya ma ꞌiboi ꞌina loina ꞌilogwahate, ma ꞌaneyage ꞌiboi ꞌana kelose ꞌiꞌahali ma ꞌiꞌamasa, beno gide ꞌana ꞌedaꞌeda, ꞌeguma taiya ꞌimuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma hesiyage ꞌeguma taiya yawasina ꞌinuwahi, ꞌabwa yawasinaina ꞌiheꞌwadalele. Ma ꞌeguma taiya weyahigu ma wasana bwebweꞌana weyahina yawasina ꞌitagwale ma ꞌiꞌamasa, tauna ꞌabwa yawasi moisa ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma ꞌeguma ꞌida wasawasao baleꞌuwa madou hedadedi talobediya beno ginaula bwagabwaga, ma hesi ginaula madou hedada beno yawasida moisa. ");
INSERT INTO bdd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Weyahina ꞌeguma yawasida moisa taheꞌwadalele, beno geya wete ꞌeta ꞌana hemiyalae ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ma ꞌeguma taiya ꞌowa weyahigu ꞌuhedeba mwadimwadina, wete ꞌigu heꞌitao weyahidi ꞌuhedeba mwadimwadina, ma ꞌuuhalegau yaso bewa galadi ma ganaganawalidi matadiya, ꞌabwa taugu Loheyaiguina wete yauhalego, tutaina Tamagu ꞌina wasawasa maemaedanaina ꞌoinega yahilama ma aneloseyao wete baꞌidagwao.” ");
INSERT INTO bdd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma wete Yesu ꞌihegwaediya, “Moisa tuwa, tupwami ꞌoimiyega geyaꞌabwa waꞌamaꞌamasa ma ꞌana siga Yehoba ꞌina loina waiwaina ꞌilatuma ma waꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sabwelo sikisi mulina Yesu ꞌana tomuliyao ꞌetoi ꞌitoediya, taudi Pita ma Yemesa ma Yoni baꞌidanao sihaneya ꞌoya ꞌaigeda dudulena ꞌoina, ma siboi simiyamiya, siꞌiteya Yesu maninina ꞌimaedana ");
INSERT INTO bdd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma ꞌana ꞌaleꞌo waꞌewaꞌeꞌena moisa, ma ꞌana ꞌita geya ꞌeta taiya baleꞌuwa sowasowana ma ꞌaleꞌoina ꞌiheꞌehau hila ꞌana waꞌewaꞌeꞌeina gide. ");
INSERT INTO bdd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma wete Ilaitiya ma Mosese sihapwesama ma Yesuina baꞌidadiu sihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Coinega Pita Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌida miya bewa bwebweꞌana, ꞌoinega ꞌimi hadahada ꞌetoi ꞌaꞌabidi, ꞌaigeda ꞌowa weyahiu, ꞌaigeda Mosese, ma ꞌaigeda Ilaitiya.” ");
INSERT INTO bdd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Beno Pita ꞌigwaegwae bwagabwaga weyahina tauna maꞌiyanao simatauta hedadeya. ");
INSERT INTO bdd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eeta yaloyaloha wete ꞌisuluwa ma ꞌiꞌahusamudiya. Yaloyalohaina ꞌoinega ꞌaigeda ꞌenana sihesagoheya, ꞌigwae, “Bewa natugu bwebweꞌana hedada, ma ꞌina gwae wahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma silomwayamwayauwa ma siloꞌita dadana, ma Yesu ꞌiboinamo, ma geya ꞌeta wete taiya siꞌita. ");
INSERT INTO bdd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Coinega ꞌoyega sisulusuluma ma Yesu ꞌiloinaediya, ꞌigwae, “Ginauledi nige waꞌita pwaidiya geyaꞌabwa tomota ꞌoidiya wahehepwailedi eema ꞌana siga taugu Loheyaiguina ꞌamasega yatoholo hilama.” ");
INSERT INTO bdd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Coinega ginauledi sidahwediya, ma siboi sihehegwaegwae, sigwaeya, “Cina gwaeina toholohila weyahina togidega ꞌana sanapu?” ");
INSERT INTO bdd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma Yesu ꞌoina sihesilala wete, sigwaeya, “Toꞌaha weyahina loina ꞌana toheꞌitao sigwae ꞌabehega Ilaitiya ꞌinugetama, ma gwahunega Toꞌabihetenaina ꞌitautauyama?” ");
INSERT INTO bdd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ma Yesu ꞌigwaeya, “Cehe gidemusa. Ilaitiya ꞌabehega ꞌilatu nugetama, ma ꞌoinega ginaula mabwaiyana ꞌiꞌabihe dumwaludi. Ma hesi Ilaitiyaina ꞌilatu pwaima, ma tomota sipaihowa galagala ꞌoina gide ꞌidi nuwatuhu, toꞌaha gide Buki Tabu ꞌihepwaila nugeteya. Ma wete taugu Loheyaiguina toꞌaha weyahina Buki Tabu ꞌihepwaila nugetegauwa ꞌabehega muya baibaiwadi yalobadi, ma wete tomota silogwahategau?” ");
INSERT INTO bdd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eeta ꞌoyega sisuluma ma ꞌana tomuliyao mabwaiyadi siloba hilediya, ma boda baibaiwadi baꞌidadiyao ma wete loina ꞌana toheꞌitao baꞌidadiyao siheꞌoheꞌoheya. ");
INSERT INTO bdd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma tutaina boda Yesu siꞌinaneya nuwadi ꞌipwanopwanowa madouna, ma sipilipili mwayamwayau sabi ꞌitaina. ");
INSERT INTO bdd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sipilima ma Yesu ꞌidi heꞌoheꞌohe weyahina ꞌihesilalediya, ꞌigwae, “Toꞌaha weyahina wahehegwaegwae?” ");
INSERT INTO bdd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma ꞌaigeda loheya bodaedi ꞌoidiyega Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌidi heꞌoheꞌohe lamuna natugu, weyahina ꞌina lohala ꞌoinega geya sawasawahina ma ꞌigwae. ");
INSERT INTO bdd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tuta tupwana hiꞌahiꞌa ꞌina paihowega ꞌitaitai ma ꞌahwanega gwalabusobuso sihapwehapwesa, ma ꞌihesalaꞌiꞌita ma ꞌidededela. Coinega ꞌa tomuliyao yaꞌahwanoiyedi ma ꞌabehega hiꞌahiꞌa gwama ꞌoinega sipaꞌihapwese, ma geya sowasowadi.” ");
INSERT INTO bdd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Coinega Yesu ꞌihegwaediya, ꞌigwae, “Comi togidega, ta deba paꞌala hedade? Tuta bewa ꞌimi deba paꞌala ꞌoinega yahewahi dabalala. Tuwa gwamaina watauyeyama ma yaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eeta gwamaina siꞌeweyama Yesu ꞌoina, ma hiꞌahiꞌa ꞌiꞌiteya Yesu, ꞌoinega ꞌiginaoya gwamaina ma ꞌitai ma baleꞌuwa ꞌibeꞌuwa, ꞌidededela ma ꞌahwanega gwala busobuso silatulatu. ");
INSERT INTO bdd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma tamanaina ꞌoina Yesu ꞌihesilala, ꞌigwae, “To tuta ꞌoina ꞌina lohala ꞌihegaineya?” Ma tamana ꞌigwaeya, “Cina tuta sedasedega. ");
INSERT INTO bdd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma ꞌeguma ꞌitai, sauga tupwana ꞌibeꞌu ꞌaiwe ꞌalaꞌalasina ꞌoidiya ma sauga tupwana bwasi niꞌuna ꞌoidiya, nata eeta ꞌiloheꞌamasi. Coinega ꞌeguma sowasowana ꞌuda ꞌatemuyamuya ma ꞌuꞌabihetemai.” ");
INSERT INTO bdd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma Yesu loheyaina ꞌihegwaeya, ꞌigwae, “Cugwae pwaiya, ‘Ceguma sowasowana,’ ꞌawa? Ma hesi ꞌunuwatuhuyahi ꞌabehega ꞌeguma tahemisa, ginaula mabwaiyana sawasawahina ꞌoida.” ");
INSERT INTO bdd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nage ꞌoina loheyaina ꞌigwae hedahedada, “Moisa tuwa yahemisa, ma geya yahemisa hedada. Nuwanuwagu ma ꞌigu hemisa ꞌugihewaiwaiye.” ");
INSERT INTO bdd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma boda baibaiwadi sipilipilima Yesu ꞌiꞌitediya, ꞌoinega hiꞌahiꞌa ꞌiheliyeya, ꞌigwae, “Cowa hiꞌahiꞌa ꞌino paihowega, gwama ꞌiheyauyauleya, yaloinego ma ꞌuꞌebesine hatae, ma geya sowana wete ꞌuluhuluhu hila ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Coinega hiꞌahiꞌaina ꞌiꞌasoꞌasona, ma ꞌana hebwasubwasumo ꞌiginaoya, ma ꞌidedela madouna, ma hiꞌahiꞌaina ꞌihapwesa ꞌitauya, ma boda gwamaina siꞌiteya ꞌana ꞌita gide ꞌiꞌamasa, ma simatauteya ma sigwae, “Beno ꞌiꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesu gwama nimana ꞌiꞌabiya ma ꞌiꞌabihe toholoya, ta gwamaina ꞌitoholowa maꞌina bwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muliyetega Yesu ma ꞌana tomuliyao siluhu hadai ma nobwa siboi. Eeta tomuliyaowedi Yesu sihegwaeya, sigwae, “Bada, togidega tauma geya sawasawahina hiꞌahiꞌa ꞌapaꞌi ma ꞌihapesa?” ");
INSERT INTO bdd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma Yesu ꞌigwaeya, “Geya ꞌeta wete ginaula ꞌoinega ma hiꞌahiꞌa tapaꞌihapwese. Beno tuwa ꞌahwanoiyega Yehoba ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Nage ꞌoinega Yesu ma ꞌana tomuliyao tupwaina siꞌebesineya, ma Yesu geya nuwana ma boda sisanapu toꞌeha ꞌoina sitauya, ꞌoinega Galili ꞌedaina ꞌoina sitautauya, ma ꞌana tomuliyao ꞌiheꞌitediya ꞌina ꞌamasa weyahina, ꞌigwaeya, “Cabwa Loheyaiguina ꞌagu toteba ꞌiꞌebwayaegau ꞌagu ꞌalehao ꞌoidiya ma siloheꞌamasigau. ");
INSERT INTO bdd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eeta sabwelo ꞌetoi mulina ꞌabwa yatoholohila.” Ma ꞌina heꞌita bewa weyahina geya sisanapu, ma hesi geya ꞌoina sihesilala, weyahina simatauta. ");
INSERT INTO bdd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eeta ꞌasa Kapaneumi ꞌoina sihapwesa ma hadai siluhuwa, ma nobwa Yesu ꞌana tomuliyao ꞌihesilalediya ꞌigwae, “To ginaula weyahina waheheꞌoheꞌohe ꞌedai?” ");
INSERT INTO bdd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma sideba mwadina, ꞌoinega geya sihemaisa, weyahina ꞌidi heꞌoheꞌohe lamuna beno taiya ꞌoidiyega ꞌidi tohanugeta. ");
INSERT INTO bdd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Coinega Yesu ꞌimiyatoiya ma site tuwelo ꞌibwauwediya ma ꞌiheꞌita ꞌoidiya, ꞌigwaeya, “Ceguma taiya ꞌowa nuwanuwau ma ꞌoimiyega ꞌuhebada, ꞌilobwainegowa ma ꞌuboi ꞌugihesuluhego ma ꞌuhetopaihowa ꞌiyamwao weyahidi.” ");
INSERT INTO bdd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Coinega ꞌaigeda gwama ꞌitoeyama ma gamwagamwanidiya ꞌihetoholoya ma ꞌiꞌatusapwaliya ma ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ceguma taiya ꞌowa gwama bewa gidemusa ꞌuhelauwe weyahigu, ꞌowa taugu wete ꞌuhelauwegau, ma geya ꞌabehega yaboi ꞌuhelauwegau ma wete ꞌagu Tohetune Yehoba baꞌidagu ꞌuhelauwemaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma Yoni ꞌigwaeya, “Bada, ꞌaigeda loheya ꞌaꞌiteya saniuwega hiꞌahiꞌa ꞌiulaula latuhedi, ꞌoinega ꞌaꞌetobodeya weyahina loheyaina geya ꞌida boda.” ");
INSERT INTO bdd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yesu ꞌigwaeya, “Geya sowana waꞌauꞌausi, weyahina ꞌeguma taiya ꞌeta ginaula waiwaidi taugu saniguwega ꞌipaihowadi, geya sowana wete ꞌeta ꞌisinasinaligau. ");
INSERT INTO bdd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Weyahina ꞌeguma taiyawedi geya siloloꞌalehegita, taudi silemelemegita. ");
INSERT INTO bdd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma wete wanuwatuhu ꞌabehega ꞌeguma taniꞌomi ꞌiyahala ma taiya ꞌihenumegomi weyahina ꞌomi Keliso ꞌina bodao, tauna ꞌana maisa bwebweꞌana ꞌabwa ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ma hesi ꞌagu tohemisao gwagwamaedi ꞌeguma taiya ꞌitohodi, ma ꞌoidiyega ꞌaigeda ꞌiꞌabihebeꞌu, loheyaina bo wahineina ꞌilobwaineya ma daꞌule madouna taniꞌona sisipwa madaꞌulena siula suluhe niꞌuwa. ");
INSERT INTO bdd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wete ꞌeguma nimau ꞌigihebeꞌugo ꞌilobwaineya ma ꞌuꞌupwa yahule. Beno geya ꞌana galamo ꞌeguma manima ꞌupwaꞌupwau ma yawasi bwebweꞌana ꞌuloba. Ma hesi gala hedadena ꞌoiuwa ꞌeguma manima luwaluwau ma siula suluhego ꞌaiwe ꞌalaꞌalata hataya ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO bdd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ma wete ꞌeguma ꞌaheu ꞌigihe beꞌugo, ꞌilobwaineya ma ꞌuꞌupwa yahule. Beno geya ꞌana galamo ꞌeguma ma ꞌino lopego ma yawasiu bwebweꞌana ꞌuloba. Ma hesi gala hedadena ꞌoiuwa, ꞌeguma maꞌahe luwaluwau siula suluhego ꞌaiwe ꞌalaꞌalasinaina ꞌoina. Casaina ꞌoina ꞌaiwe ꞌalaꞌalasina geya ꞌida gibowa. ");
INSERT INTO bdd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO bdd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Matau wete gidemusa ꞌeguma ꞌigihebeꞌugo ꞌubwaiyahule wete, weyahina geya ꞌeta ꞌana galamo ꞌeguma mamata ꞌaiꞌaigedau ma Yehoba ꞌina ꞌebeloina ꞌuloba. Ma hesi gala hedadena ꞌoiuwa, ꞌeguma mamata luwaluwau siula suluhego ꞌaiwe ꞌalaꞌalata ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Casaina ꞌoina mwahulu ꞌoidiya yapwayapwa sisopisopila hataya ma wete ꞌaiweina geya ꞌida gibowa. ");
INSERT INTO bdd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Coinega tomota mabwaiyadi ꞌabwa ꞌaiwe ꞌalaꞌalasina ꞌiꞌabi hebwebweꞌanedi, gide hola ꞌeꞌahai ꞌiꞌabi hebwebweꞌaneya. ");
INSERT INTO bdd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hola ginaula bwebweꞌana, ma ꞌeguma ꞌana ꞌamna ꞌigumwala geya sawasawahina ma ꞌiꞌamna hila. Coinega ꞌilobwainegomiya ma mumugami waboi walotoho, ꞌana lotohona gidemusa wahehelau hilegomi.” ");
INSERT INTO bdd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma Yesu tupwaina ꞌiꞌebesineya ma Yudiya ꞌina tupwa ꞌitauya, ma ꞌihabala weꞌaha Yolidani hali tupwa, eeta boda madouna siꞌetoꞌauta hilama ꞌoina, ma mumuganaina gide wete ꞌiheꞌita ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta Palisiyao sinaoma ma nuwanuwadi Yesuina sitoho, ꞌoinega sihesilala ꞌoina, sigwae, “Bada, togidega ꞌida loina saꞌila weyahina? Sawasawahina loheya mwanena ꞌisaꞌile?” ");
INSERT INTO bdd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Yesu ꞌigwaeya, “Togidega Mosese loina ꞌiꞌebwaya ꞌesegomiya?” ");
INSERT INTO bdd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma Palisiyao sigwaeya, “Mosese ꞌitagwala ma ꞌeguma loheya nuwanuwana ma ꞌisaꞌila, nugeta pepa ꞌaigeda ꞌoina ꞌina guipaila ꞌihepwaile, ma mwanena ꞌiꞌebwae, ma ꞌisaꞌile.” ");
INSERT INTO bdd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma Yesu ꞌihegwaediya, ꞌigwae, “Mosese loina beno ꞌiꞌebwaegomiya ꞌimi deba paꞌala weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma hesi wanuwatuhuyahi Yehoba ꞌina hemasalaha hauhauna ꞌoinega tomota ꞌeluwa ꞌihemasalahediya, loheyana ma mewahinena. ");
INSERT INTO bdd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bewa lamuna ꞌoinega loheya tamana ta sinana ꞌiꞌebesinedi, ma mwanena baꞌidana simiyaluwa, ");
INSERT INTO bdd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma siteluwaedi wahidi ꞌaigeda tuwa. Mwalo siteluwaedi simiya wasiwasiya, ma bewa tutaina ꞌoina siloꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yehoba ꞌilagu ꞌaigedediya, ꞌoinega geya sowana tomota sitoho ma silagulagu wasiyedi.” ");
INSERT INTO bdd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muliyetega Yesu maꞌana tomuliyao sihila hadai, ma tomuliyaowedi sihesilala hila saꞌila weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eeta Yesu ꞌihegwaediya, “Ceguma taiya loheya mwanena ꞌisaꞌile ma ꞌihaibala, loheya bewa mwanena nugenugetaina ꞌoina galana ꞌipaihoweya, weyahina ꞌiganawala. ");
INSERT INTO bdd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma wete ꞌeguma wahine mwanena ꞌisaꞌile ma ꞌihaibala, wahineina ꞌiganawala.” ");
INSERT INTO bdd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma tomota gwagwama siꞌewedima Yesu ꞌoina ꞌabehega ꞌiꞌabi tohodi. Ma hesi ꞌana tomuliyao gwagwamaedi siꞌausidiya. ");
INSERT INTO bdd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma Yesu ꞌana tomuliyao ꞌiꞌitediya ma ꞌiheliyediya, ꞌigwae, “Sahena gwagwama waꞌauꞌausidi, ma hesi watagwaledi ma ꞌoiguwa sinaoma, weyahina gwagwama bewa gide Yehoba ꞌina ꞌebeloina ꞌilobwainediya. ");
INSERT INTO bdd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yahegwaegomi ꞌeguma taiyewedi taudi geyaꞌabwa gwagwama bewa gide ꞌidi hemisa, nata sahena Yehoba ꞌina ꞌebeloina ꞌoina siluhuluhu.” ");
INSERT INTO bdd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Coinega Yesu gwagwamaedi ꞌiꞌahalidiya, ma wete ꞌiꞌabi tohodiya, eema ꞌigwae helauwediya. ");
INSERT INTO bdd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma Yesu ꞌitoholo ꞌitautauya, ma ꞌaigeda loheya ꞌipilima, ma ꞌiꞌetuluha Yesu matana, ma ꞌigwaeya, “Bada, yasanapugowa ꞌabehega ꞌowa toheꞌita bwebweꞌau, ꞌoinega toꞌaha yada paihowa ma ꞌane yawasigu miyamiya hatayana yaloba?” ");
INSERT INTO bdd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yesu loheyaina ꞌihegwaeya, ꞌigwae, “Togidega ma ꞌoinega ꞌuꞌahwa bwebweꞌanegauwa? Geya ꞌeta taiya wete bwebweꞌana, beno tuwa Yehoba. ");
INSERT INTO bdd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ma Yehobaina ꞌina loinao ꞌusanapu pwaidiya, beno ꞌabehega: Sahena loheꞌamasa. Sahena ganawala. Sahena yagaha. Sahena hepwaila ꞌaboꞌabo. Sahena ꞌabowega tomota ꞌidi tobwatobwa ꞌuꞌewaꞌewadi. Ma wete tamau ma sinau ꞌuheꞌasisiyanedi.” ");
INSERT INTO bdd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma loheyaina ꞌigwaeya, “Bada, ꞌigu tuta sedasedega ꞌana siga nige, loinaedi yamuliya bwaibwainidiya.” ");
INSERT INTO bdd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Coinega Yesu maꞌina yaliyaya loheyaina ꞌiꞌebubuya ma ꞌigwae, “Beno tuwa ꞌaigeda ginaula ꞌilosapuligowa. Coinega ꞌuhila ꞌino ꞌasa, ma ꞌino tobwatobwa mabwaiyana ꞌuhegimwaneye, ma ꞌadi maisa ꞌuheguyaiye towewelohe ꞌoidiya, eema ꞌunaoma ꞌumuliyegau, ꞌabwa muliyetega ꞌino wasawasa galewa ꞌuloba hila.” ");
INSERT INTO bdd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gwae bewa loheyaina ꞌihesagoheya, ma ꞌina wasawasa madouna weyahina nuwana ꞌigala moisa, ma maꞌina nuwagala ꞌihila, ta Yesu ꞌina gwaeina geya ꞌimuliye. ");
INSERT INTO bdd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Coinega Yesu ꞌiloꞌita dadana ma ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Ceguma taiyawedi taudi maꞌidi wasawasa madouna, ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌalona mwauna.” ");
INSERT INTO bdd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma ꞌana tomuliyao nuwadi ꞌihepwanopwanowa ꞌina gwaeina weyahina. Coinega Yesu ꞌihegwaediya, ꞌigwae, “Natugwao, Yehoba ꞌina ꞌebeloina ꞌana luhu mwau hedada. ");
INSERT INTO bdd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ee moisa, kameli tauna hebahebai madouna, ꞌoinega tupwana mwauna ma nidili ꞌana bwalena ꞌoinega kameliina ꞌiluhu, ma hesi towasawasao ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌoina mwau hedada.” ");
INSERT INTO bdd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu ꞌina gwaeina ꞌana tomuliyao sihesagoheya ma nuwadi ꞌihepwanopwano hedada, ma sihegwaeya, “Ceguma beno gide, taiya hede sawasawahina ma ꞌebe yaliyayaina ꞌiloba?” ");
INSERT INTO bdd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Coinega Yesu ꞌiꞌeꞌebubudi ma ꞌigwaeya, “Ginaula bewa mwau hedada tomota ꞌoidiya, ma hesi geya mwauna Yehoba ꞌoina, weyahina Yehoba ꞌoina ginaula mabwaiyana sowasowana.” ");
INSERT INTO bdd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta Pita Yesu ꞌihegwaeya, ꞌigwae, “Bada, tauma togidega? Weyahina ꞌima tobwatobwao mabwaiyadi ꞌaꞌebesinediya ma ꞌamuliyegowa.” ");
INSERT INTO bdd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ma Yesu ꞌigwaeya, “Ee moisa, ꞌeguma taiyawedi ꞌomi ꞌimi hadao ta tasimiyao ta nuhumiyao ta sinamiyao ta tamamiyao ta natumiyao ta ꞌimi baleꞌu wete waꞌebesinediya, ma wete muya waloba weyahigu ta wasa bwebweꞌana ꞌana hepwaila weyahina, ꞌami maisa tuta bewa waloba gide handeledi hadao ta tasimiyao ta nuhumiyao ta sinamiyao ta natumiyao ta ꞌimi baleꞌu wete, ma ꞌabwa galewa yawasimi hataya wete waloba. ");
INSERT INTO bdd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ta bewa tutaina tohanugetao baibaiwadi ꞌabwa simuliya, ma taudi simulimuliya ꞌabwa sinugeta.” ");
INSERT INTO bdd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cabwa ꞌedai sihanehane Yelusalema weyahina, ma Yesu ꞌinugenugeta ma ꞌana tomuliyao simulimuliya, ta maꞌidi nuwapwanopwano, ma tupwadi tomota wete maꞌidi ꞌateyoho ꞌedai simulimuliyedi. Eeta ꞌana tomuliyao site tuwelowedi ꞌibwau ꞌautehiledima ma ꞌihemataluwediya toꞌaha ꞌiꞌiunamo ma ꞌilatu ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ꞌigwaeya, “Bewa tuta tahane Yelusalema, ma nobwa ꞌagu totebaina taugu Loheyaiguina ꞌitebaegau topwaoli madoudi ta loina ꞌana toheꞌitao ꞌoidiya, ma ꞌigu ꞌamasa weyahina siloina, ma muliyetega siheꞌebwaegau taudi geya meYudiya ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ma taudi meganamuli silotuyanegau ta siꞌesohegau ta gulahega sisapigau ma ꞌoinega siloheꞌamasigau, ma sabwelo ꞌetoi yatoholohila.” ");
INSERT INTO bdd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Coinega Yemesa ma Yoni, taudi Sebedi natunao, Yesu ꞌoina sinaowa, sihegwaeya, sigwae, “Bada, ꞌanaoma sabi ꞌahwanoi ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma Yesu ꞌigwaeya, “Toꞌaha nuwanuwami ma yapaihowa weyahimi?” ");
INSERT INTO bdd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Coinega sigwaeya, “Cabwa ꞌino ꞌebeloina ꞌoina nuwanuwama ma deiuwa ꞌamiyatoi, ꞌaigeda ꞌino ꞌebeulega ma ꞌaigeda ꞌino ꞌadigeyegeyega.” ");
INSERT INTO bdd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Yesu ꞌihegwaediya, ꞌigwae, “Comi ꞌimi ꞌahwanoiina lamuna geya wasanapu. Togidega? Muya ꞌana biyoina yanuma, sawasawahina ma ꞌomi wete ꞌoinega wanuma? Ma wete babitaiso mwauna ꞌabwa yaloba, togidega ꞌomi wete gide sawasawahimi ma wababitaiso ꞌesa?” ");
INSERT INTO bdd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta sigwaeya, “Sawasawahima.” Ma Yesu ꞌigwaeya, “Moisa, biyoina ꞌabwa ꞌoinega yanuma, ꞌomi wete ꞌoinega wanuma, wete babaitaisoina ꞌoinega ꞌiꞌiunamo ꞌabwa yababitaiso ꞌomi wete ꞌoinega wababitaiso, ");
INSERT INTO bdd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ma hesi geya sawasawahigu ma yahesinuwa taiyewedi ꞌabwa ꞌigu hetoloina ꞌoina ꞌigu ꞌebeulega ma ꞌigu ꞌadigeyegeyega simiyatoi, weyahina Yehoba tauna ꞌina ꞌebeloina ma ꞌihesinuwa.” ");
INSERT INTO bdd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta tomuliyao site teni Yemesa ma Yoni ꞌidi ꞌahwanoi sihesagoheya ma sigamwasowalediya. ");
INSERT INTO bdd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eeta Yesu mabwaiyadi ꞌibwau heꞌautediya ma ꞌihegwaediya, “Comi wasanapuya taudi baleꞌuwa sibwauwediya ꞌabehega babadao, ꞌidi tomotaiyao siloiloina paꞌaledi. ");
INSERT INTO bdd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma ꞌomi geyaꞌabwa wete gide taudi wapaipaihowa ꞌesa. Ma hesi taiya ꞌowa ꞌeguma nuwanuwau ma ꞌoimiyega ꞌuhetoloina, ꞌilobwainegowa ma ꞌiyamwao weyahidi ꞌuhetopaihowa. ");
INSERT INTO bdd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta wete ꞌeguma taiya ꞌowa nuwanuwau ma ꞌoimiyega ꞌuhetohanugeta, ꞌilobwainegowa ma ꞌiyamwao mabwaiyadi weyahidi ꞌuhetopaihowa. ");
INSERT INTO bdd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Taugu Loheyaiguina wete gide ꞌigu suluma baleꞌuwa geya ꞌabehega tomota weyahigu sipaihowa, ma hesi sabi paihowa tomota weyahidi, ma wete yatagwalegauwa ma yaꞌamasa tomota mabwaiyami ꞌami ꞌebelihasa weyahina.” ");
INSERT INTO bdd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eeta sitautauya Yeliko, ma tutaina Yesu maꞌana tomuliyao Yeliko siꞌebesineya boda madouna siꞌwayabudiya, ta tomata gibugibu sanina Batimiyo silobeya, tauna Timiyo natuna, ma tuta baibaiwana ꞌeda papalina ꞌoina ꞌimiyamiya, ꞌiꞌahwaꞌahwanoi mane ta tobwatobwa weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma Batimiyoina ꞌihesagoheya ꞌabehega Yesu gwama Nasaleta ꞌitautau, ꞌoinega Yesu ꞌoina ꞌibwauwa, ꞌigwae, “Yesu yo, ꞌowa Debida ꞌina susu, ꞌuꞌatemuyemuyegau.” ");
INSERT INTO bdd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eeta tomota mabwaiyadi Batimiyoina siꞌausiya, sigwae, “Tuwa, ꞌulolagu!” Ma tuwa ꞌiwuiwui ꞌenana madounega, ꞌigwae, “Debida tubuna yo, ꞌuꞌatemuyemuyegau.” ");
INSERT INTO bdd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Coinega Yesu ꞌitoholo henonowa, ma ꞌigwae, “Wabwauweyama.” Ma tomota sigwae, “Bwebweꞌana, ꞌutoholo. Yesu ꞌibwauwegowa.” ");
INSERT INTO bdd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Coinega ꞌana ꞌabobo ꞌiꞌewayahuleya ma ꞌitoholo mwayamwayauwa, ma Yesu ꞌoina ꞌinaoma. ");
INSERT INTO bdd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Cinaoma ma Yesu ꞌihegwaeya, ꞌigwae, “Toꞌaha nuwanuwau ma weyahiu yapaihowa?” Ma tomata gibugibuina ꞌigwaeya, “Bada, sawasawahina ma matagu ꞌugiheꞌasilala?” ");
INSERT INTO bdd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta Yesu ꞌihegwaeya, ꞌigwae, “Bwebweꞌana! Cino hemisa ꞌoinega matau ꞌiꞌasilala.” Nage ꞌoina matana ꞌiꞌasilala, ma ꞌedai Yesu ꞌimuliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eeta silagalaga Yelusalema weyahina, ma ꞌasa ꞌiꞌiudi Bedani ma Bedipegi deidiya silatulatu, beno ꞌoya Olibe gabulena, ma Yelusalema matadiya tupwana bwaga. Ta Yesu ꞌana tomuliyao ꞌeluwa ꞌihetune nugetediya tupwaedi ꞌiꞌiudi ꞌoidiya maꞌadi hemataluwa, ");
INSERT INTO bdd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ꞌigwaeya, “Watauya ꞌasa nage matamiya ꞌoina, ma ꞌeguma wahapwesa ꞌasaina matana, hebahebai ꞌaigeda waꞌitaloba ꞌaiwe ꞌoina silohoya, beno ꞌase hauhauna, tauna geya tomota sida geluya. Hebahebaiina walihasi ma waꞌeweyama. ");
INSERT INTO bdd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma ꞌeguma ꞌeta taiya ꞌihesilala ꞌoimiya ma ꞌigwae, ‘Toꞌaha weyahina beno hebahebaiina walihasiya?’ loheyaina wahegwae, ꞌabehega, ‘Bada nuwanuwana ma tuta ꞌiꞌiunamo ꞌabwa ꞌihewasa hileyama.’” ");
INSERT INTO bdd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Coinega site luwaedi sitauya ꞌasaina ꞌoina, ma hebahebai ꞌase silobeya hada mata ꞌahwaina ma ꞌaiwe ꞌoina silohoya, ꞌoinega sihegaina ma silihalihasi. ");
INSERT INTO bdd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Silihalihasi ma tupwadi loheloheya sitotoholo deidiya sigwaeya, “Toꞌaha weyahina beno hebahebaiina walihalihasi?” ");
INSERT INTO bdd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma site luwaedi sigwaeya, “Bada nuwanuwana, ma tuta toꞌutoꞌupana tuwa ꞌabwa ꞌihetune hileyama,” ma ꞌoidiya sitagwaleya. ");
INSERT INTO bdd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma hebahebaiina siꞌeweya sitauyeya Yesu ꞌoina, ta ꞌadi ꞌaleꞌowega gwahuna siyesoya, ꞌoinega Yesu ꞌigeluwa, ta ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma boda mabwaiyadi wete ꞌadi ꞌaleꞌo ꞌedai siyesodiya, ma tupwadi ꞌaiwe lahalahadi ma nabaidi sigulediya ꞌeda ꞌana hepasa weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma tupwana boda Yesu sihanugeteya ma tupwadi boda simuliyeya, ta mabwaiyadi sihehepwatu ma sibwaubwau, sigwae, “Yauwedo Bada, weyahina Yehoba saninega ꞌunaoma sabi ꞌabihetemai. ");
INSERT INTO bdd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Cebeloina tubumai Debida ꞌoinega ꞌilatu hilama. Bewa weyahina Yehoba Tolotabwana hedada ꞌahehepwatuwe.” ");
INSERT INTO bdd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ma Yesuina Yelusalema ꞌoina ꞌihapwesa, ma Hada Heꞌasisi ꞌoina ꞌiluhuwa, ma ginaula baibaiwana Hada Heꞌasisi ꞌalona ꞌiꞌeꞌebubudiya, eema sinala ꞌisopuwa, ꞌoinega maꞌana tomuliyao site tuwelo mahetenao sihila Bedani ꞌoina, siꞌenowa. ");
INSERT INTO bdd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gona ꞌiꞌadaleya, sitoholowa ma Bedani ꞌoinega sihilahila Yelusalema weyahina, ta Yesu ꞌigomaleya, ");
INSERT INTO bdd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","eeta bwagebwagega ꞌaiwe ꞌana ꞌita gide damaya manabanabaina ꞌiꞌiteya, ꞌoinega ꞌinaowa deina ma nuwanuwana ꞌabehega huwaina ꞌiꞌai, ma hesi ꞌiꞌiteya nabainamo, ꞌaiwehuwahuwa ꞌabwa geya ꞌana tuta. ");
INSERT INTO bdd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Coinega Yesu ꞌaiweina ꞌiheliyeya, ma ꞌigwae, “Geyaꞌabwa wete ꞌuhuwahuwa hila ma tomota ꞌoinega siꞌaiꞌai.” Ma ꞌina gwaeina ꞌana tomuliyao sihesagoheya. ");
INSERT INTO bdd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Coinega Yelusalema ꞌoina sinaoma, ma Hada Heꞌasisi ꞌalona ꞌiluhuwa, ma tohegimwaneyao ma togimwaneyao ꞌalonega ꞌipaꞌi hapwesediya, ma mane ꞌana tohesaꞌugelasao ꞌidi teibele ꞌiꞌahu sepalediya, ma gabubu ꞌadi tohegimwaneyao ꞌidi ꞌebemiya wete ꞌiꞌahu buinediya. ");
INSERT INTO bdd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma wete hada ꞌalona ꞌihegagaleya ma sahena loheloheya maꞌidi tobwatobwa sitautau hada ꞌalonega. ");
INSERT INTO bdd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ꞌiheꞌitediya, ꞌigwae, “Yehoba ꞌina gwae Buki Heꞌasisi ꞌoina sileleya, geya wasanapu, ꞌigwaeya, ‘Cigu hadaina ꞌabwa sibwauwe tomota mabwaiyadi ꞌidi ꞌebe ꞌahwanoi.’ Ma hesi ꞌomi waꞌabi buiya ꞌabehega ꞌimi ꞌebe yagaha.” ");
INSERT INTO bdd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ma topwaoli madoudi ma loina ꞌana toheꞌitao Yesu ꞌina paihowa tetelina sihesagoheya, ta sigamwasowaleya ma sinuwanuwatuhu togidega ma siloheꞌamasi, ma hesi geya sowasowahidi, weyahina simatauta, ta wete Yesu ꞌina heꞌitao boda mabwaiyadi nuwadi ꞌiꞌeweya. ");
INSERT INTO bdd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma ꞌiboiya, ꞌoinega Yesu maꞌana tomuliyao ꞌasaina siꞌebesineya, sitauya Bedani. ");
INSERT INTO bdd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gona ꞌiꞌadaleya ma sitoholowa sabi hila Yelusalema, ma ꞌedai sitautau, ma Yesu ꞌaiweina ꞌiheliyeya siꞌiteya nabaina mabwaiyana siwelaiya. ");
INSERT INTO bdd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ta Pita Yesu ꞌina heliyaina ꞌinuwatuhu yahiya ma ꞌihegwaeya, ꞌigwae, “Bada ꞌuꞌita, ꞌaiweina ꞌuheliyeya ꞌiwelai pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Yesu ꞌihegwaediya, ꞌigwae, “Ceguma ꞌimi hemisa Yehoba ꞌoina walagu, beno ꞌomi wete paihowa waiwaidi wapaihowadi. ");
INSERT INTO bdd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wete yagwae moisa ꞌoimiya, ꞌeguma taiya ꞌomi geya ꞌida henuwanaluwa, ma ꞌeguma maꞌina hemisa ma toꞌaha ꞌigwaene silatu tuwa, ꞌeguma ꞌoya nage ꞌiloine ma ꞌigwae, ‘Cumiya dobi niꞌuwa,’ beno ꞌina gwaeina ꞌihematamatane. ");
INSERT INTO bdd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Coinega yahegwaegomi toꞌaha waꞌahwanoiye Yehoba ꞌoina, wahemisa tuwa ma ꞌane waloba, ma wete ꞌabwa waloba. ");
INSERT INTO bdd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wete ꞌeguma waꞌahwanoi Yehoba ꞌoina, ꞌiyamiyao ꞌidi mumuga wanuwasamudi, ꞌeguma toꞌaha ꞌidi puiyao ꞌoimiya, bewa ꞌoinega Tamamiu galewa ꞌomi wete ꞌimi puiyao ꞌinuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO bdd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Coinega sihila pwaima Yelusalema, ma Yesu Hada Heꞌasisi ꞌalona ꞌiyawayawala, ma topwaoli ta loina ꞌana toheꞌitao ta wete babadao sinaoma, ");
INSERT INTO bdd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ma Yesu sihesilaleya, sigwae, “Loheya, taiya ꞌina loinega ta bewa gide ꞌupaipaihowa ꞌesa?” ");
INSERT INTO bdd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Yesu ꞌihegwaediya, ꞌigwae, “Nugeta yahesilala ꞌoimiya, ma ꞌeguma wahemaise, taugu wete yahegwaegomi ꞌigu loina weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Cigu hesilala bewa: Taiya ꞌina loinega ma Yoni toꞌabihebabitaiso ꞌipaipaihowa? Yehoba? Bo ꞌaigeda loheya?” ");
INSERT INTO bdd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Coinega siboidimo ꞌoidiya siheheꞌoheꞌohe, sigwaeya, “Cina gwae togidega tahemaisa ꞌese? Weyahina ꞌeguma tagwae, ‘Yehoba ꞌoinega,’ nata ꞌihegwae hilegita, ma ꞌigwae, ‘Bo! Toꞌaha weyahina ta Yoni geya wahemisae?’ ");
INSERT INTO bdd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma ꞌeguma tagwae, ‘Tomota ꞌoidiyega,’ nata boda sigamwasowalegita.” Weyahina tomota baibaiwadi Yoni sihemisaeya ꞌabehega palopita moisa. ");
INSERT INTO bdd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Coinega Yesu ꞌina hesilala geya sihemaisa bwaibwaini, ma hesi sigwae, “Geya ꞌasanapu?” Coinega Yesu wete ꞌihegwaediya, ꞌigwae, “Taugu geyaꞌabwa wete ꞌoimiya yahehepwaila latu taiya ꞌina loinega ma bewa gidemusa yapaipaihowa ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Coinega Yesu ꞌigwae hegehegediyediya, ꞌigwae, “Caigeda loheya ꞌina tanoha ꞌidauniya gileipa daisinamo ma ꞌali ꞌipaihoweya, ma gileipa ꞌana ꞌebe bibi ꞌipaihoweya, ma hada tanoha ꞌalona ꞌiꞌabiya, ꞌoinega ꞌina topaihowao ꞌiloinediya ma siꞌitaꞌitayahi, ta tauna ꞌitauya hali tupwa. ");
INSERT INTO bdd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ma hedodona ꞌana tuta, badaina ꞌina hewali ꞌaigeda ꞌihesumaneya ma ꞌabehega gileipa huwaina tanoha ꞌana toꞌitayahinaedi ꞌoidiyega ꞌiꞌeweyama. ");
INSERT INTO bdd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Citautauya ta geya siꞌebwaꞌebwae, ma hesi siꞌabiyahiya ta sisapiya, ꞌoinega nimenimenamo sihewasaeya ꞌihila. ");
INSERT INTO bdd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Coinega badaina ꞌina hewali heluwena wete ꞌihewasaeya ꞌoidiya, ma sihunuya debana, ta maꞌina debamwadina ꞌihila. ");
INSERT INTO bdd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Coinega wete hetoina ꞌihewasaeya ꞌoidiya ta siloheꞌamasiya. Ma baibaiwadi wete ꞌihetunediya ꞌoidiya, ma tupwadi sisapidiya ta tupwadi silohe ꞌamasidiya, eeta mabwaiyadi siꞌabihe galediya. ");
INSERT INTO bdd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Nage ꞌoina ꞌaigeda tuwamo ꞌimiyamiya, tauna natuna moisa. Tauna wete ꞌihewasaeya ꞌoidiya, ꞌina nuwatuhu ꞌigwaeya, ‘Tauna tuwa natugu, nata siheꞌasisiyane.’ ");
INSERT INTO bdd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ma natunaina ꞌilatuwa ꞌoidiya ma toꞌitayahinaowedi siboidimo ꞌoidiya sigwae, ‘Bada bewa natuna ꞌinaonaoma, ma ꞌeguma taloheꞌamasi nata tanoha bewa mabwaiyana taloinae.’ ");
INSERT INTO bdd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Coinega siꞌabiyahiya ta siloheꞌamasiya, ma tanohega siula latuheya papaliya.” ");
INSERT INTO bdd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu ꞌina heꞌoteꞌotetela ꞌilosalohiya, ma ꞌihesilala ꞌoidiya, ꞌigwaeya, “Toꞌaha ꞌabwa badaina ꞌipaihowa? Moisa tuwa badaina ꞌabwa ꞌinaoma ma topaihowaedi ꞌiloheꞌamasidi, ma tanohaina toꞌitayahi hagadi wete ꞌiꞌebwaedi.” ");
INSERT INTO bdd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wete Yesu gwae hegehegedi Buki Heꞌasisi ꞌoinega ꞌihepwaileya, ꞌigwae, “Wanuwatuhuya Buki Heꞌasisi ꞌina hepwaila bewa gide: Logidiina mwalo tohadaꞌabi siguipaileya, ta bewa sihetoholo nugeteya hada mata ꞌahwaina ma logidi mabwaiyadi ꞌiloinaedi. ");
INSERT INTO bdd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Beno Bada ꞌina paihowa ꞌebe henainaida ꞌoida.” ");
INSERT INTO bdd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu ꞌina gwae hegehegediyedi topwaoli madoudi ma Palisiyao sihesagoheya, ma sisanapuya ꞌabehega taudi tuwa weyahidi ꞌigwaegwae, ꞌoinega sitohotoho ma siꞌabiyahi, ma hesi geya sawasawahina weyahina simatauta boda ꞌoidiya. Eeta siꞌebesineya ma sitauya. ");
INSERT INTO bdd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma ꞌoinega babadaowedi sihetunediya tupwadi Palisiyao ma wete Helodi ꞌina bodao, ma taudi sitauya Yesu ꞌoina ma ꞌabehega hesilalega sida ꞌabowe ma ꞌina hemaisa pui siloba. ");
INSERT INTO bdd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sitauyama Yesu ꞌoina ma sihegwaeya, sigwae, “Bada, ꞌasanapugowa ꞌabehega ꞌowa toheꞌita moisa, ma tomota ꞌidi waiwai weyahina geya ꞌuda matauta, ma tuwa gwae moisega ꞌuhehepwaila mahemahetena tomota mabwaiyadi ꞌoidiya, beno Yehoba ꞌina ꞌeda ꞌuheheꞌita bwaibwaini. Coinega togidega? Cilobwainegita ma Kini Sisa ꞌina takesi taꞌebwae, bo sahena? ");
INSERT INTO bdd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sowasowana takesiina tahemaisa Kini ꞌoina, bo sahena?” Ma Yesu ꞌidi ꞌabo ꞌisanapu pwaiya, ꞌoinega ꞌihegwaediya, ꞌigwae, “Toꞌaha weyahina watohotohogau? Hana maneina waꞌeweyama, ma yaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Coinega mane daꞌule ꞌaigeda siꞌebwaeya. Ma Yesu ꞌihegwaediya, ꞌigwae, “Mane bewa ꞌoina taiya ꞌana maꞌamaꞌayau ma sanina?” Ma sigwae “Kini Sisa.” ");
INSERT INTO bdd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta Yesu ꞌihegwaediya, “Ee gide, ꞌeguma Kini ꞌina ginaula waꞌebwae Kini ꞌoina, ma ꞌeguma Yehoba ꞌina ginaula Yehoba waꞌebwae.” Ma Yesu ꞌina gwaeina weyahina nuwadi ꞌihepwanopwano madouna. ");
INSERT INTO bdd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Coinega wete Sadusiyao sinaoma ma Yesu ꞌoina sihesilala, taudi geya sihemihemisa toꞌamasa ꞌidi toholohila weyahina, ma sigwaeya, ");
INSERT INTO bdd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bada, ꞌida loina bewa gide Mosese ꞌileleya, ꞌigwae, ‘Ceguma ꞌaigeda loheya ꞌihai ma geya natunamo ma ꞌiꞌamasa, loheyaina tasina hiwapena baꞌidana sihai, ma ꞌeguma wahine ꞌigamwa beno natunao ꞌihenatunediya toꞌamasaina miyalaenao’” ");
INSERT INTO bdd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Coinega ꞌebeꞌita siꞌebwaeya sigwae, “Caigeda loheya matasinao simiyamiya ꞌadi baibaiwa site sebeni, ma ꞌadi tautuwaina ꞌihaiya ma muliyetega geya ꞌihenatuna ma loheyaina ꞌiꞌamasa. Coinega wete tasina deinega hiwapeina ꞌihaiya, ta wete gidemusa geya ꞌihenatuna ma ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Coinega tasina deinega hiwapeina ꞌiꞌeweya, ma wete simiyamiya ta geya ꞌihenatuna, ma loheyaina ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma site hataedi wete gidemusa siꞌamaꞌamasa ma hesi geya natudiyaomo. Ta muliyetega wahine wete ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Coinega toholohila ꞌana tuta wahineina nata to loheya mwanena moisa? Weyahina mabwaiyadiyedi wahineina sihaiya?” ");
INSERT INTO bdd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Yesu ꞌidi hesilalaina ꞌihemaiseya, ꞌigwae, “Bewa ꞌimi heyauyaule, weyahina Buki Heꞌasisi geya wada sanapuya, ma wete Yehoba ꞌina waiwai geya wada sanapuya. ");
INSERT INTO bdd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Toholohila ꞌana tuta ꞌoina tomota geyaꞌabwa sihaihai, ma hesi ꞌidi miya aneloseyao galewa gidemusa. ");
INSERT INTO bdd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Mwalona Yehoba Mosese ꞌihegwaeya toholohila weyahina, ꞌeguma Buki Heꞌasisi wahasili, nata waꞌita loba. Weyahina tutaina Mosese yoho ꞌawawa ꞌitautauya ma Yehoba ꞌaiwe ꞌalaꞌalasina ꞌoinega Moseseina ꞌihegwaeya ꞌigwae, ‘Taugu Ebalahamo ꞌina Yehoba, ma Aisake ꞌina Yehoba, ma Yakobo ꞌina Yehoba.’ ");
INSERT INTO bdd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yehoba geya tomota ꞌamaꞌamasidi ꞌidi Yehoba, ma hesi tomota mayawasidi ꞌidi Yehoba, ꞌoinega tubudaowedi mayawasidi bewa tuwa simiyamiya. Ma ꞌomi ꞌimi heꞌita ginaula bewa weyahina geya dumwaluna.” ");
INSERT INTO bdd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eeta loina ꞌana toheꞌita ꞌaigeda ꞌinaoma, ma taudi ꞌidi heꞌoheꞌohena Yesu baꞌidadiu ꞌihesagoheya, ma ꞌidi hesilalao ꞌadi maisa Yesu ꞌoinega ꞌihesagohediya wete ꞌabehega ꞌausala hedada, ꞌoinega tauna wete Yesu ꞌoina ꞌihesilala ꞌigwaeya, “Bada, loina mabwaiyadi ꞌoidiyega to loina madouna?” ");
INSERT INTO bdd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta Yesu ꞌigwaeya, “Loina madouna bewa: Comi meIsileli ꞌigu gwaeina wahesagohe ꞌabehega Bada Yehoba ꞌiboinamo. ");
INSERT INTO bdd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Coinega ꞌino Bada Yehoba ꞌuhelauwe ꞌateu mabwaiyanega ta yaluyaluwau ta nuwau ta wete ꞌino waiwai mabwaiyana ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma ꞌaigeda wete loina madouna bewa: Ciyamwao ꞌuhelauwedi gide ꞌowa ꞌuboi ꞌuhehelauwego. Loina ꞌeluwaedi loina mabwaiyadi simadou sinediya.” ");
INSERT INTO bdd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eeta loina ꞌana toheꞌitaina Yesu ꞌina gwae ꞌihesagoheya, ma ꞌigwaeya, “Bada, ꞌino gwae beno gwae moisa, ꞌabehega tauna ꞌiboinamo tuwa Yehoba, ma geya ꞌaigeda wete Yehoba ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Coinega ꞌilobwainegita ma tahelauwe ꞌateda mabwaiyanega ta nuwada mabwaiyanega ta ꞌida waiwai mabwaiyanega, ma wete ꞌiyadao tahelauwedi gidemusa tauda tahehelau ꞌesegita. Loina ꞌeluwaedi madoudi, ma hesi hebai nuwana ꞌeꞌahai tapwaoliye Yehoba ꞌoina, beno geya madouna, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ta Yesu loheyaina ꞌina gwae ꞌihesagoheya ꞌabehega dumwaluna, ma ꞌihegwaeya ꞌigwae, “Beno gwae moisa, ma ꞌowa Yehoba ꞌina ꞌebeloina ꞌoina ꞌuhahalatulatu.” Tuta nage ꞌoina tomota Yesu simatauteya, ma geya ꞌeta taiya sowasowana ma ꞌihesilala hila. ");
INSERT INTO bdd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma ꞌoinega Yesu Hada Heꞌasisi ꞌalona ꞌiheheꞌita tomota ꞌoidiya, ma ꞌihegwaediya ꞌigwae, “Togidega ma ꞌoinega loina ꞌana toheꞌitao sigwae ꞌabehega Debida ꞌina susuwega Keliso ꞌiliꞌuwa? ");
INSERT INTO bdd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Weyahina Debida mwalo Yaluyaluwa Tabuna ꞌina waiwai ꞌoinega Kelisoina ꞌiꞌahwa badaeya, ꞌigwae: Yehoba ꞌina gwae ꞌigu Bada ꞌoina, ꞌigwaeya, ‘Cigu ꞌebeulega ꞌumiyatoi ma ꞌana siga ꞌa ꞌalehao yalagu suluhedi ꞌaheu gabulena.’ ");
INSERT INTO bdd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Debidaina ꞌina Bada Keliso, ꞌoinega togidega hede ta Debida ꞌina susuwega ꞌabwa Keliso ꞌiliꞌuma?” Ma boda mabwaiyadi Yesu ꞌina heꞌita nuwadi ꞌiꞌeweya. ");
INSERT INTO bdd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Coinega Yesu ꞌihegwaediya, ꞌigwae, “Sahena loina ꞌana toheꞌitao mumugadi wamulimuliye. Weyahina taudi mumugadi tuwa gidemusa tuta baibaiwana nuwanuwadi maꞌadi ꞌaleꞌo duduledi siꞌotedi, ma tomota gamwagamwanidiya sisakosakowasi ma ꞌabehega siheꞌasisiyedi. ");
INSERT INTO bdd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma wete nuwanuwadi ꞌebemiya bwebweꞌana hada tapwalolo ꞌoidiya, ma wete guyai ꞌadi tuta nuwanuwadi ma wagahata simiyatoi. ");
INSERT INTO bdd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta wete tuta mabwaiyana tomota matadiya siꞌahwaꞌahwanoi dudulena Yehoba ꞌoina, ma hesi ꞌidi ꞌahwanoiina geya bwebweꞌana, weyahina ꞌatediya sinuwanuwatuhu togidega nata hiwahiwape siꞌabo ꞌesedi ma ꞌidi tobwatobwao siꞌewadi. Coinega nata Yehoba maisa galana ꞌiꞌebwaedi.” ");
INSERT INTO bdd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu Hada Heꞌasisi ꞌoina helau ꞌana ꞌebe lagu deina ꞌimiyatoiya, ma tomota ꞌidi helau mane silagulagu ma Yesu ꞌiꞌeꞌebubuna, ma towasawasao ꞌidi helau madoudi ꞌiꞌitediya, ");
INSERT INTO bdd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ma wete hiwape wewelohena ꞌiꞌiteya ꞌina helau toea ꞌeluwamo ꞌilagudiya. ");
INSERT INTO bdd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu ꞌiꞌiteya ma ꞌana tomuliyao ꞌibwau heꞌautedima, ma ꞌihegwaediya, ꞌigwae, “Moisa tuwa, hiwape nage ꞌina helau mabwaiyadi ꞌidi helau ꞌimadou sinediya. ");
INSERT INTO bdd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Weyahina mabwaiyadi ꞌidi tupwa madouna ꞌimiyamiya, ma hesi hiwape nage weweloheina, ma ꞌina mane mabwaiyana ꞌilaguya, ta geya ꞌeta wete ꞌina tupwa ꞌimiyamiya ma ꞌoinega ꞌana ꞌigimwane.” ");
INSERT INTO bdd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eeta Yesu maꞌana tomuliyao Hada Heꞌasisi ꞌoinega silatuwa, ma ꞌana tomuliya ꞌaigeda Hada Heꞌasisi ꞌana hadao Yesu ꞌiheꞌitaeya, ꞌigwae, “Bada, ꞌuꞌita hadaedi ꞌadi paihowa bwebweꞌana hedada, daꞌule madoudi ꞌoidiyega siꞌabidiya.” ");
INSERT INTO bdd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yesu ꞌigwae, “Hadaedi madoudi ꞌuꞌitediya ꞌiꞌiunamo ma mabwaiyadi siligeha yahuledi ma geyaꞌabwa wete ꞌeta tupwa waꞌitaꞌita hila.” ");
INSERT INTO bdd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Muliyetega Yesu ꞌitauya Olibe ꞌoyana ꞌoina ta ꞌimiyatoiya, ma ꞌoinega Hada Heꞌasisi Yelusalema ꞌoina ꞌiꞌeꞌebubuna, ma Pita ta Yemesa ta Yoni ta Andulu sinaoma ma siboidimo Yesu baꞌidadiu, eema sihegwaeya, sigwae, ");
INSERT INTO bdd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bada ꞌuhegwaemai to tuta ꞌoina Hada Heꞌasisi siligehi, ma to ꞌilaꞌilala ꞌadi ꞌita ꞌoidiyega ꞌada sanapu ꞌabehega ginauledi ꞌiꞌiunamo silatuma?” ");
INSERT INTO bdd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Coinega Yesu ꞌiheꞌale ꞌoidiya ꞌihepwaila ma ꞌigwaeya, “Waꞌita yahigomi tabu ma tomota tupwadi siꞌabowegomi. ");
INSERT INTO bdd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Weyahina ꞌabwa tomota baibaiwadi saniguwega sinaonaoma ma ꞌabehega sihanugeta puigomi, ma ꞌaigeda ꞌaigeda ꞌoidiyega sigwae, ‘Taugu Kelisoina,’ ma tomota baibaiwadi simuliyedi. ");
INSERT INTO bdd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wete wasa ꞌabwa wahesagohedi ꞌalehao deimiya, ma wete bwaga, taudimo siꞌaleꞌaleha hiladi, ma hesi sahena waꞌateꞌateyoho. Ginaula bewa nata silatu nugeta ma hesi baleꞌu ꞌana ꞌebelosaloha ꞌana tuta ꞌabwa hedada. ");
INSERT INTO bdd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Weyahina ꞌabwa hali boda ma hali boda siꞌaleha hiladi, ma wete hali ꞌebeloina ma hali ꞌebeloina siloꞌaleha hiladi, ma wete mwaniꞌiniꞌi sipilipili hali tupwa ma hali tupwa ꞌoidiya, ma gomale madoudi sihapwehapwesa. Ma ginaulaedi bewa tuta mwauna ꞌana ꞌebehegaina tuwa. ");
INSERT INTO bdd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ta ꞌomi hesi waꞌitayahigomi, weyahina tomota ꞌabwa siꞌabiyahigomi ma sitauyegomi yatala weyahina, ta Hada Tapwalolo ꞌoidiya sisapigomi, ta wete ꞌabwa toloinao ma kiniyao matadiya sitoegomi ma watoholo ma siheyatalaegomi, beno weyahina ꞌomi ꞌabehega taugu ꞌigu bodao, ta saugaina ꞌoina teteligu wahepwaile ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma teteligu bwebweꞌana ꞌiꞌelelewana nugeta tupwa mabwaiyana ꞌoidiya, ma muliyetega tuta ꞌana ꞌebelosaloha ꞌihapwesa. ");
INSERT INTO bdd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ma ꞌeguma toloinao matadiya sihetohologomi yatala weyahina, sahena waꞌateꞌateyoho togidega wagwae ꞌesa. Ma hesi maꞌimi ꞌatepatu tuwa wagwae, weyahina geya ꞌabehega ꞌomi ꞌimi gwae wahehepwaile, ma hesi Yaluyaluwa Tabuna nata gwae ꞌiꞌebwaegomi, ma wahepwaila latuhe. ");
INSERT INTO bdd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ta wete tuta sinaonaoma ꞌoidiya tomota ꞌidi susu ꞌalodiya ꞌaleha ꞌihapwesa weyahigu, beno loheya tasina ꞌitebae ma siloheꞌamasi. Ma wete gide tamana natuna ꞌitebae ma siloheꞌamasi. Ma wete gwagwama sinadiyao ta tamadiyao sitebaedi ma siloheꞌamasidi. ");
INSERT INTO bdd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ta tomota mabwaiyadi ꞌabwa siloꞌalehegomi weyahina ꞌomi ꞌabehega ꞌagu tohemisao. Ma hesi taiyawedi ꞌomi weyahigu waꞌatepatu ee ꞌana siga tuta ꞌana ꞌebelosaloha ꞌoina, nata ꞌebe yaliyaya waloba. ");
INSERT INTO bdd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Cabwa ꞌeguma ꞌomi waꞌitadi hali tomota ginaula gala hedadedi ma didigadi sihetoholodi tupwa heꞌaheꞌasisina ꞌoina (Ceguma taiya nage gwaeina ꞌihasili ꞌabwa ꞌisanapu), tuta nage ꞌoina Yudiya ꞌana tomiyao ꞌilobwainediya ma ꞌoya ꞌoidiya sidena. ");
INSERT INTO bdd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma ꞌeguma taiya wagahata ꞌimiyamiya ꞌidena mwayamwayau, ma sahena ꞌiluhuluhu hila ꞌina hada ꞌalona ꞌina tobwatobwa sabi ꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ꞌeguma taiya wete tanoha ꞌipaipaihowa geyaꞌabwa wete ꞌihilahila ꞌana ꞌaleꞌo hali tupwa ꞌilaguya ꞌiꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Ma tuta nage ꞌoina togamwa ma tohesusuwao sihenuwaꞌoleꞌole. ");
INSERT INTO bdd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Coinega waꞌahwanoi waiwai ma tuta bwebweꞌana Yehoba ꞌiꞌebwaegomi ꞌimi tuta dena ꞌoina, ma sahena gogai ꞌana tuta. ");
INSERT INTO bdd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Moisa tuwa, tuta nage ꞌoina mwau hedada, weyahina tutaina Yehoba baleꞌu ꞌihemasaleheya ꞌoinega ma ꞌana siga nige geya ꞌaigeda wete mwau nage gide ꞌida latuwa, ma ꞌabwa geya sowana wete mwau bewa gide ꞌida latu hila. ");
INSERT INTO bdd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mwau nina ꞌana sabwelowao ꞌeguma Yehoba sahena ꞌiꞌabiꞌabi hetotoꞌupe beno tomota mabwaiyadi siꞌamasa, ma hesi Yehoba sabwelowedi ꞌabwa ꞌiꞌabi hetotoꞌupadi, tauna ꞌina tomotaiyao hesihesinuwaidi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tutaina ꞌoina ꞌeguma taiya ꞌihegwaegomi, ꞌigwae, ‘Keliso bewa’ nuwana ‘Nage,’ sahena wahehemisaedi. ");
INSERT INTO bdd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Weyahina Keliso ꞌaboꞌabodi ma palopita ꞌaboꞌabodi beno silatulatuma ma ꞌilaꞌilala waiwaidi tomota ꞌoidiya siheꞌitaedi, ma ꞌoidiyega ꞌeguma sawasawahidi Yehoba ꞌina bodao hesihesinuwaidi siꞌabowedi. ");
INSERT INTO bdd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Coinega waꞌita yahigomi, weyahina ginaulaedi bewa yahepwaila pwaiya ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma tuta mwauwedi ꞌigumwala ma muliyetega sinala ꞌiguguyou, ma wete waiꞌena ꞌina maedana ꞌigibo, ");
INSERT INTO bdd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ma ꞌipwala galewa sigubagubala, ma ginaulao galewa mabwaiyadi simiyamiya ꞌidi waiwai siꞌelo weꞌa. ");
INSERT INTO bdd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuta nage ꞌoina mebaleꞌu taugu Loheyaiguina siꞌitegau yaloha ꞌoidiyega yasulusuluma maꞌigu waiwai ta maꞌigu wasawasa madouna, ");
INSERT INTO bdd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ꞌoinega ꞌigu aneloseyao yahetunedi, ꞌigu bodao hesihesinuwaidi sihegogonedima baleꞌu ta galewa ta yaumai mabwaiyadi ꞌidi tupwa ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Cebeꞌita saido ꞌoinega yaheꞌitegomi ꞌabehega ꞌeguma saido nabaina hauhaudi ꞌilagulagudi, beno wasanapuya ꞌesihe ꞌana tuta ꞌabwa ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma wete ꞌilaꞌilalaowedi ꞌoimiya yahepwailediya, ꞌeguma to tuta ma waꞌita lobadi, beno wasanapuya ꞌabehega ꞌigu tuta hilama ꞌana tuta ꞌiꞌehohoya. ");
INSERT INTO bdd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moisa tuwa, yaso bewa geya sowana wagumwagumwala ma ꞌana siga ginaulaedi mabwaiyadi silatu. ");
INSERT INTO bdd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Cabwa galewa ma baleꞌu sisawala, ma hesi ꞌigu gwae geya sowana ꞌisawasawala. ");
INSERT INTO bdd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma hesi geya ꞌeta taiya ꞌisanapu to tuta nuwana to sabwelo ꞌoina yahilama, ta wete aneloseyao galewa geya sisanapu. Ma taugu wete geya yasanapu. Ta Tamagu ꞌiboinamo ꞌisanapuya. ");
INSERT INTO bdd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Coinega walomatayahi, weyahina ꞌigu tuta hilama geya wasanapu.” ");
INSERT INTO bdd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cebeꞌita wete Yesu ꞌiꞌebwaediya ꞌigwae, “Ceguma ꞌaigeda bada ꞌabehega ꞌina hada ꞌabwa ꞌipilisine ma ꞌitautau hali tupwa, ꞌina topaihowa ꞌaigeda ꞌaigeda ꞌidi paihowa ꞌiheguyaidi, ma ꞌiloinedi ma ꞌabehega ꞌina hada siꞌitayahi, ma wete hada ꞌana ꞌahwaꞌeda ꞌana toꞌitayahina ꞌihegwae, ꞌigwae, ‘Geyaꞌabwa ꞌuꞌenoꞌeno, ma hesi ꞌulomatayahi bwaibwaini.’ ");
INSERT INTO bdd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Coinega ꞌilobwainegomiya ma walomatayahi ma wayamweyamwegau, weyahina toni hadaina ꞌina latu ꞌana tuta geya wasanapu, nuwana lahilahiya, nuwana nihuwana gamwana, nuwana gona ꞌadaꞌadale, nuwana gonagona. ");
INSERT INTO bdd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Geyaꞌabwa yalatulatuma ma ꞌenoꞌenowega ꞌatemi yaloheyoho. ");
INSERT INTO bdd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Cigu hemataluwa bewa ꞌoimiya ma wete tomota mabwaiyadi ꞌoidiya ꞌabehega walomatayahi bwaibwaini.” ");
INSERT INTO bdd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hataona Guyaina ꞌana ꞌebe nuwatuhuyahina ꞌabwa ꞌilatu sabwelo ꞌeluwa mulina. Guyaina ꞌalona ꞌadi pwalawa geya ꞌana ꞌebe ꞌabi hesesehamo siꞌai. Ma topwaoli madoudi ta loina ꞌana toheꞌitao sinuwanuwatuhu togidega ma Yesu siꞌabo ꞌese eema ꞌabehega siꞌabiyahi ma siloheꞌamasi, ");
INSERT INTO bdd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ma sigwaeya, “Geyaꞌabwa guyaina ꞌalona Yesu taꞌabiꞌabiyahi, tabu ma tomota sigamwasowalegita ma siloꞌalehegita.” ");
INSERT INTO bdd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ꞌabwa Bedani ꞌoina ꞌimiyamiya Saimoni ꞌina hada, tauna mwalo lepelo ꞌaigeda; ma tutaina Yesu ꞌiꞌaiꞌai Saimoni ꞌina hada, wahine ꞌaigeda maꞌina holowa ꞌiluhuma; ma holowaina sanina nadi, maisana madouna, ma ꞌana botolo ꞌausala hedadena. Ma wahine botoloina ꞌahwana ꞌiꞌahulaseya, ma holowaina Yesu debana ꞌisiweya. ");
INSERT INTO bdd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma tupwadi tomota siꞌiteya ma wahine silomugiyeya, sigwae, “Toꞌaha weyahina holowa ꞌimudaliya? ");
INSERT INTO bdd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cilobwaineya ma holowaina ꞌihegimwaneye ma ꞌana maisa teli handeledi kina gide ꞌiꞌewa ma ꞌiheguyaiye towewelohe ꞌoidiya.” Coinega wahineina siheliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yesu ꞌihegwaediya, ꞌigwae, “Tuwa! Walolagu! Geya sowana wahine waꞌabiꞌabi hedohedou, weyahina ꞌina lema ꞌoiguwa bwebweꞌana hedada. ");
INSERT INTO bdd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Toweweloheyedi wagwaegwaenedi tuta baibaiwana deimiya simiyamiya, ma ꞌeguma to tuta nuwanuwami tuwa walemedi, ma taugu hesi geya tuta dudulena baꞌidamiu tamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ma wahine bewa toꞌaha ꞌoina madouna ꞌipaihoweya ꞌoiguwa, beno wahigu ꞌiheholoi nugeteya sabi ꞌatububuina ꞌagu lagu galiha weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ma moisa tuwa, ꞌabwa wasagu ꞌana guguya tomota sihesagohe baleꞌu mabwaiyana ꞌoina, ma wahine bewa ꞌina paihowa ꞌoiguwa wete wasana siheꞌoteꞌotetele.” ");
INSERT INTO bdd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Coinega Yesu ꞌana tomuliya ꞌaigeda site tuwelo ꞌoidiyega, tauna Yudasa Isakaliyota, ꞌitauya topwaoliyao ꞌidi babadao ꞌoidiya ma nuwanuwana Yesu ꞌoidiya ꞌitebae. ");
INSERT INTO bdd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudasa ꞌina gwae sihesagoheya, ma siyaliyaya ma ꞌoina sigwae hemisa ꞌabehega ꞌana maisa siꞌebwae. Coinega Yudasa tuta bwebweꞌana ꞌiloyamweya ma ꞌabehega Yesu ꞌoidiya ꞌitebae ma siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Guyai ꞌana tuta, beledi geya ꞌana ꞌabi hesesehamo siꞌaiꞌai, ma ꞌana sabwelo nugenugetaina ꞌoina lamiyao sihunudi Hataona ꞌana ꞌebe nuwatuhuyahina weyahina, ma sabweloina ꞌoina Yesu ꞌana tomuliyao sihegwaeya sigwae, “Bada, taꞌeha ꞌoina nuwanuwau ma Hataona Guyaina weyahina ꞌaꞌatububu?” ");
INSERT INTO bdd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Coinega ꞌana tomuliyao ꞌeluwa ꞌihewasediya maꞌadi hemataluwa, ꞌigwaeya, “Watau Yelusalema, ma ꞌeguma loheya ꞌaigeda maꞌina ꞌebegoi ꞌiꞌahaliya waloba, loheyaina wamuliye ma baꞌidamiu waluhu hadai, ma tonihada wahegwae bewa gide, wagwae, ‘Bada bewa gide ꞌigwae ꞌesa ꞌigwaeya, “To tupwa ꞌeguma ꞌutagwale ma ꞌoina maꞌagu tomuliyao Hataona ꞌeꞌahaina ꞌaꞌai?” ’ ");
INSERT INTO bdd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eema ꞌiheꞌitegomi tupwa madouna tabwana ꞌatuꞌatububuina. Tauna ꞌoina Hataona ꞌeꞌahaina waꞌatububu weyahida.” ");
INSERT INTO bdd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Coinega tomuliyaowedi sitauya ma ꞌasa Yelusalema ꞌoina siluhuwa ma toꞌaha gide Yesu ꞌigwaeneya ꞌoidiya ginauledi mabwaiyadi silobediya, ta hadaina ꞌoina Hataona ꞌeꞌahaina siꞌatububuya weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta lahilahiya Yesu maꞌana tomuliyao sinaoma, ");
INSERT INTO bdd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ma site tuwelo simiyatoiya sabi lohepaꞌala. Ta ꞌidi ꞌai ꞌalona Yesu ꞌihegwaediya, “Ciyagwao yahegwae bwaibwainigomi ꞌabehega ꞌaigeda loheya bewa baꞌidadai taꞌaiꞌai, ꞌabwa tauna nata ꞌiꞌiunamo ma ꞌitebaegau.” ");
INSERT INTO bdd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma Yesu ꞌina gwae bewa weyahina sinuwagala, ta ꞌaigeda ꞌaigeda Yesu sihegwaeya, sigwae, “Bada, taiya? Nuwana taugu?” ");
INSERT INTO bdd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma Yesu ꞌigwaeya, “Cagu totebaina ꞌomi wate tuwelowedi ꞌoimiyega, ta tauna baꞌidagu gaeba ꞌoina ꞌaꞌai. ");
INSERT INTO bdd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taugu Loheyaiguina ꞌabwa yatauya ꞌedaina mwalo Buki Tabu ꞌoina sihepwaila nugeteya, ma hesi ꞌagu totebaina nuwagalagalaina moisa; ma bwebweꞌana ꞌeguma mwalo sinana geyaꞌabwa ꞌihehenatune, weyahina ꞌina liꞌu ꞌoinega ꞌihenuwa galagala ꞌina paihowa galana weyahina.” ");
INSERT INTO bdd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cabwa siꞌaiꞌai, ma Yesu beledi ꞌiꞌeweya ma weyahina ꞌigwae helauwa, ta ꞌihisiya ma ꞌiꞌebwaediya, ꞌigwae, “Bewa waꞌai wahigu.” ");
INSERT INTO bdd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ta waini mabiyoina wete ꞌiꞌeweya, ma weyahina ꞌiloyauwedo Yehoba ꞌoina, ma ꞌiꞌebwaediya, ma mabwaiyadi sinuma. ");
INSERT INTO bdd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta wete ꞌihegwaediya, ꞌigwae, “Bewa bweyahigu ꞌidaudau tomota mabwaiyami weyahimi, beno loina ꞌehauna. ");
INSERT INTO bdd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma yahegwaegomi tuta bewa ma mulina waini bewa geyaꞌabwa ꞌoinega yanumanuma hila ma ꞌana siga waini ꞌehauna ꞌabwa yanuma Yehoba ꞌina tupwa.” ");
INSERT INTO bdd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Coinega wali ꞌaigeda siwaliyeya ma sihapwesa sihaneya ꞌoya Olibe ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma Yesu ꞌihegwaediya, “Ciꞌiunamo ma mabwaiyami wadena sinegau, gide Buki Heꞌasisi ꞌina hepwaila ꞌigwaeya, ‘Toꞌitayahina sipi yaloheꞌamasi ma sipiyedi siꞌelelewana.’ ");
INSERT INTO bdd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma ꞌigu toholohila mulina Galili ꞌoina yatauya, ma ꞌomi muliguwega wanaoma.” ");
INSERT INTO bdd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Coinega Pita ꞌigwaeya, “Nata mabwaiyadi sidenasinego, ma taugu tuwa baꞌidau tamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta Yesu Pita ꞌihegwaeya, “Yagwae moisa ꞌoiuwa nihuwana nata muliyega ꞌabwa ꞌamꞌam ꞌidou maluwa, beno ꞌowa ꞌuuhalegau matoi.” ");
INSERT INTO bdd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma ꞌoinega Pita ꞌiꞌahwapaꞌala ꞌigwaeya, “Bada, geyaꞌabwa yauhauhalego. Ceguma siloheꞌamasigo, taugu wete baꞌidau siloheꞌamasigita.” Tomuliyao mabwaiyadi wete gide sigwae ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ma sinaowa ꞌaigeda tupwa sanina Gedesemani ꞌoina, ma ꞌana tomuliyaowedi ꞌoidiya ꞌigwaeya, “Bewa ꞌoina wamiyamiya, ma taugu yaꞌahwanoi Yehoba ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma sitetoi baꞌidanao ꞌitoediya, taudi Pita ma Yemesa ma Yoni, ta Yesu ꞌiꞌateyohowa maꞌina nuwagala, ");
INSERT INTO bdd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ma ꞌihegwaediya, “Cigu nuwagala madouna ma ꞌoinega ꞌabehega yaꞌamasa, ma ꞌomi tuwa ꞌebwa wamiyamiya, waꞌoꞌoyatola ta walomatayahi.” ");
INSERT INTO bdd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma Yesu ꞌihutulaga tupwana ma ꞌibeꞌu talutalubuꞌiya ma ꞌiꞌahwaꞌahwanoi ꞌabehega ꞌeguma sawasawahina muya bewa Yehoba ꞌiꞌewa yahule, ");
INSERT INTO bdd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ꞌigwaegwae, “Tamagu, paihowa baibaiwana sowasowahiu, ꞌoinega nuwanuwagu ma muya biyoina bewa ꞌoiguwega ꞌuꞌewayahule, ma hesi geya ꞌabehega taugu ꞌigu nuwatuhuwega, ta hesi ꞌowa ꞌino nuwatuhuwega ꞌupaihowa.” ");
INSERT INTO bdd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Coinega ꞌihila ma sitetoiyedi ꞌilobediya siꞌeno sinediya, ma Pita ꞌilohanohanoya, ꞌigwae, “Saimoni, togidega ta ꞌuꞌenoꞌeno. Geya sowasowahiu ma tuta ꞌiꞌiuna tuwa ꞌoina ꞌuꞌoyatola, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma wete ꞌihegwaediya mabwaiyadi, ꞌigwae, “Cilobwainegomiya ma waꞌoꞌoyatola ma waꞌahwaꞌahwanoi, ma ꞌoinega geyaꞌabwa Seitani ꞌitohotoho hedadegomi. Moisa yaluyaluwami nuwanuwana, ma hesi wahimi siꞌelodabalala.” ");
INSERT INTO bdd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Coinega Yesu ꞌilaga hila ma ꞌina ꞌahwanoiina ꞌilohileya. ");
INSERT INTO bdd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma wete Yesu ꞌihila ꞌana tomuliyao ꞌoidiya, ꞌilobediya wete siꞌenosinediya, weyahina mata ꞌenoꞌeno ꞌiꞌewa pwaidiya. Ma ꞌilohanohanodiya, ta sitoholowa maꞌidi debamwadina, ma geya wete ꞌidi gwaemo. ");
INSERT INTO bdd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta Yesu wete ꞌilaga ma ꞌiꞌahwaꞌahwanoi, ma ꞌina hilama hetoina ꞌoina ꞌilobediya siꞌenosinediya, ta ꞌihegwaediya, “Togidega, ꞌabwa waꞌenoꞌeno ma waꞌaiꞌaiyawasi? Ta ꞌigu tuta bewa ꞌilatu pwaima ma taugu Loheyaiguina ꞌiꞌiunamo sitebaegau togala ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Watoholo ma tatau, weyahina ꞌagu totebaina bewa ꞌinaonaoma.” ");
INSERT INTO bdd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ꞌabwa ꞌigwaegwae ma Yudasa ꞌihapwesama, tauna Yesu ꞌana tomuliyao site tuwelo ꞌaigeda ꞌoidiyega. Beno weyahina topwaoliyao madoudi ta loina ꞌana toheꞌitao ta babadao sihewasaedima ꞌidi toꞌalehao Yudasa mahetediu ma ꞌabehega Yesu siꞌabiyahi, ma bodaedi ꞌidi ꞌebe ꞌalehao ta wepasi wete siꞌewediya. ");
INSERT INTO bdd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma Yudasa ꞌilaꞌilalaina ꞌiꞌebwaya pwaiya ꞌoidiya, ꞌihepwaileya, ꞌigwae, “Ceguma taiya yaꞌatusapwali, beno tauna Yesu, ma waꞌabiyahi ma walomatayahi ma watauye.” ");
INSERT INTO bdd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Coinega ꞌidumwaluwa Yesu ꞌoina ma ꞌihelauweya ma ꞌiꞌatusapwaliya. ");
INSERT INTO bdd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eeta bodaedi silatuma ma Yesuina siꞌabiyahiya. ");
INSERT INTO bdd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma Yesu ꞌana bodao ꞌaigeda ꞌoidiyega ꞌitotoholo deina, ma ꞌina ꞌelepa ꞌilisiloloya, ma totaꞌona madouna ꞌina topaihowa tenana ꞌiꞌupwa yahuleya. ");
INSERT INTO bdd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Yesu boda ꞌihegwaediya, ꞌigwae, “Nuwana taugu toyagaha ta ꞌoinega maꞌimi ꞌebeꞌaleha ma maꞌimi wepasi wanaoma sabi ꞌabiyahigau. ");
INSERT INTO bdd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta toꞌaha lamuna ꞌoinega geya waꞌabiyahigau sabwelowedi gamwagamwanimiya yamiyamiya Hada Heꞌasisi ꞌoina ma yaheheꞌita tomota ꞌoidiya? Ma tuwa hesi ginaula bewa silatuma ma ꞌane palopitao ꞌidi gwae nugeta Buki Heꞌasisi ꞌalona sihapwesa bwaibwaina.” ");
INSERT INTO bdd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Coinega Yesu ꞌana tomuliyao mabwaiyadi sidena sineya. ");
INSERT INTO bdd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma ꞌaigeda hewali maꞌana ꞌaleꞌo ꞌaigeda tuwa Yesu ꞌimuliyeya, ma toloꞌalehao nuwanuwadi siꞌabiyahi, ");
INSERT INTO bdd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ta siꞌabisapuliya ta ꞌana ꞌaleꞌomo siꞌeweya, ma bugebugewanamo ꞌidena. ");
INSERT INTO bdd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma Yesu sitoeyama ma siluhuweya topwaoli madouna ꞌina hada, weyahina hadaina ꞌoina topwaoli madoudi ta babadao ta loina ꞌana toheꞌitao siꞌetoꞌautama. ");
INSERT INTO bdd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Pita bwagebwagega Yesu ꞌimulimuliye ma ꞌinaoma Topwaoli madouna ꞌina ꞌasa, ma Pitaina toꞌitayahinao baꞌidanao simiyatoiya ta ꞌaiwe ꞌoina simwaimwailu. ");
INSERT INTO bdd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eeta topwaoli madoudi ta babadaedi nuwanuwadi Yesu ꞌana toheꞌewao silobadi ma ꞌidi heꞌewaina ꞌoinega Yesu siloheꞌamasi, ma hesi geya ꞌeta wete siloba. ");
INSERT INTO bdd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Weyahina toheꞌewao baibaiwadi sihehepwailamo, ma hesi ꞌidi hepwailaedi geya sihemahemahetena. Taudi mabwaiyadi toꞌabo tuwa. ");
INSERT INTO bdd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma tupwadi ꞌoidiyega sitoholowa ma Yesu siheꞌewa ꞌaboꞌaboweya, sigwae, ");
INSERT INTO bdd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yesu ꞌina gwae ꞌaigeda ꞌahesagoheya ꞌigwae, ‘Hada Heꞌasisi bewa tomota siꞌabiya, ꞌabwa yaligehi yahule, ma sabwelo ꞌetoi ꞌoidiya yaꞌabihila, ma geya tomota nimadiyega,’” ");
INSERT INTO bdd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ma hesi ꞌidi heꞌewa ginaula bewa weyahina geya sihemahemahetena. ");
INSERT INTO bdd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Coinega topwaoli madouna ꞌitoholowa gamwagamwanidiya, ma Yesu ꞌihesilaleya, ꞌigwae, “Geya ꞌuda hemaiseya, ꞌawa? Loheloheya ꞌidi heꞌewa ꞌoiuwa ꞌuhesagoheya?” ");
INSERT INTO bdd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Yesu tuwa ꞌihehenono ta geya wete ꞌida gwaeya. Eeta topwaoli madouna Yesu ꞌihesilala hileya, ꞌigwae, “Togidega, ꞌowa Yehoba natuna Toꞌabihetenaina, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Yesu ꞌigwaeya, “Cehe! Taugu! Ma wete ꞌabwa taugu Loheyaiguina waꞌitegau Tohewaiwai moisa ꞌina ꞌebeulega yamiyamiya, ma wete galewa yaloha debadiyega yanaoma.” ");
INSERT INTO bdd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Coinega topwaoli madounaina ꞌigamwasowala moisa, ꞌoinega ꞌiboinamo ꞌana ꞌaleꞌo ꞌiꞌigaliya, ma ꞌigwaeya, “Cina gwae galana wahesagoheya? Moisa, loheya bewa Yehoba ꞌisinaliya. Tuwa! Geyaꞌabwa wete ꞌana toheꞌewao sigwaegwaene ꞌina puiyao weyahidi. Togidega ꞌimi nuwatuhu Yesu weyahina?” Ma ꞌoinega mabwaiyadi sigwaeya, “Cilobwaineya tuwa ma ꞌiꞌamasa!” ");
INSERT INTO bdd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nage ꞌoina tupwadi tomota Yesu siꞌesoheya, ma matana ꞌaleꞌowega siwaduya, ma sihunu dadaneya maꞌidi ꞌehetete, sigwaeya, “Cuhegwaemai taiya ꞌihunugowa?” Ma toꞌita yahinedi Yesu siꞌabiyahiya, sisapiya ta sitauyeya. ");
INSERT INTO bdd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta Pita ꞌabwa ꞌatamana ꞌimiyamiya, ma topwaoli madouna ꞌina topaihowa gumalaulauna ꞌaigeda ꞌilatuma, ");
INSERT INTO bdd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ta Pita ꞌiꞌiteya ꞌimwaimwailu. Coinega wahineina Pita ꞌiꞌeꞌebubuya, ta ꞌigwaeya, “Yesu gwama Nasaleta ꞌowa mwalo baꞌidau wamiyamiya, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Pita ꞌiuhala, ꞌigwaeya, “Ginaulaina ꞌugwaegwaene geya yasanapu toho.” Coinega Pita ꞌilatuwa mulimuliya. ");
INSERT INTO bdd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma gumalaulauina Pita ꞌihenima susuweya tomiyaedi ꞌoidiya, ꞌigwaeya, “Loheya nage Yesu ꞌina boda ꞌaigeda.” ");
INSERT INTO bdd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Pita ꞌihesagoheya ma ꞌiuhala hila, ꞌigwae, “Taugu geya.” Tuta ꞌiꞌiuna mulina toꞌebubunaowedi Pita sihegwaeya, sigwae, “Moisa tuwa, ꞌuꞌabowa. Cowa Yesu ꞌina boda, weyahina ꞌowa gwama Galili.” ");
INSERT INTO bdd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Coinega Pita ꞌiuhala moisa, ma gwae galana ꞌoinega ꞌibwauhaneya, ꞌigwae, “Yesu tauna wagwaegwaene, taugu geya yasanapu toho. Tamada!” ");
INSERT INTO bdd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta tutaina ꞌoina ꞌamꞌam ꞌidouwa maluwa, ma nage ꞌoina Pita ꞌinuwatuhuya Yesu ꞌina gwaeina ꞌabehega “Muliyega ꞌabwa ꞌamꞌam ꞌidou maluwa, beno ꞌowa ꞌuuhalegau matoi.” Ma Pita ꞌina ꞌaboina galana ꞌinuwatuhuya, ma ꞌidouwa. ");
INSERT INTO bdd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gona ꞌiꞌadaleya ma topwaoli madoudi ta babadao ta loina ꞌadi toheꞌitao ta wete toloinao mabwaiyadi siꞌetoꞌautama, ma siloina Yesu weyahina, ꞌoinega nimana sipaidiya ma sitauyeya Pailato ꞌoina ma ꞌabehega Pailatoina ꞌiloinae. ");
INSERT INTO bdd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Coinega Pailato Yesu ꞌihesilaleya ma ꞌigwae, “Cuhepwaila, ꞌowa meYudiya ꞌidi kini, ꞌawa?” Ma Yesu ꞌigwaeya, “Beno ꞌugwae pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eeta topwaoli madoudi ginaula baibaiwana weyahidi Yesu siheꞌeweya. ");
INSERT INTO bdd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Coinega Pailato Yesu ꞌihesilala hileya, ꞌigwae, “Togidega ta geya ꞌuda hemaisa? Hepwaila bewa siheheꞌewago ꞌuhesagoheya?” ");
INSERT INTO bdd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesu geya wete toꞌaha ꞌida hemaiseya, ꞌoinega Pailato nuwana ꞌihepwanopwanowa madouna. ");
INSERT INTO bdd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bolime ꞌaigeda ꞌaigeda Hataona Guyaina ꞌoidiya toloinaina ꞌina mumuga beno deliyega ꞌaigeda loheya ꞌida lihasi ma ꞌilatuma, ꞌeguma taiya boda sihesinuweya. ");
INSERT INTO bdd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tuta nage ꞌoina tupwadi meLoma ꞌadi ꞌalehao meYudiya deliya simiyamiya. Mwalo meYudiyaedi geya nuwadi meLoma ꞌidi loina, ꞌoinega siloꞌalehediya, ma ꞌaigeda ꞌoidiyega sanina Balaba ꞌalehaina ꞌalona tomota ꞌiloheꞌamasidiya. Coinega meLomaedi Balaba maꞌiyanao siꞌabiyahidiya ma deliya silagu luhuwediya. ");
INSERT INTO bdd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eeta boda siꞌetoꞌautama ma siꞌahwanoiya Pailato ꞌoina, sigwaeya, “Sawasawahina ma ꞌaigeda loheya ꞌulihasi weyahima, gide ꞌima ꞌahwanoi ꞌoiuwa ꞌupaipaihowa bolime ꞌaigeda ꞌaigeda ꞌoidiya?” ");
INSERT INTO bdd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Pailato ꞌihegwaediya, “Nuwanuwami ꞌabehega meYudiya ꞌimi kini yalihasi weyahimi, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Weyahina Pailato ꞌisanapuya ꞌabehega topwaoli madoudi ꞌidi heꞌipiꞌipiyega siꞌwayamiya. ");
INSERT INTO bdd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma hesi topwaoli madoudi tomota ꞌidi nuwatuhu sihenuwalagu pwaiyeya ꞌoidiya, ꞌoinega Yesu siguipaileya ma Balaba hesi sanina siꞌinaneya, ma ꞌabehega ꞌilihasi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma Pailato ꞌihegwaediya ꞌigwae, “Togidega hede yaloina ꞌese tauna wabwauweya ꞌimi kini?” ");
INSERT INTO bdd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma sitalaꞌasona, sigwae, “Kelose ꞌoina tatutuhepaꞌi!” ");
INSERT INTO bdd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pailato ꞌigwaeya, “Toꞌaha hede ꞌina pui ta ꞌoinega ꞌabehega ꞌamasa ꞌiloba?” Ma siwuiwui ꞌenadi madounega, sigwae, “Kelose ꞌoina tatutuhepaꞌi.” ");
INSERT INTO bdd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Coinega Pailato nuwanuwana ma boda ꞌiꞌabihe yaliyayaedi, ta Balaba ꞌilihasiya ꞌoidiya, ma ꞌina toloꞌalehao ꞌiloinaediya ma Yesu gulahega sisapiya ma muliyetega ꞌabwa situtuhepaꞌine kelose ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailato ꞌina toloꞌalehao Yesu sisapiya ma sitoeya ꞌina hada siluhuweya, beno toloꞌaleha ꞌidi tupwa madouna hadaina ꞌalona ma toloꞌalehao ꞌidi bodao mabwaiyadi sibwau heꞌautedima. ");
INSERT INTO bdd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Coinega wasawasao ꞌadi ꞌaleꞌo bwehabwehalinega Yesu siheꞌwameya, ma debana ꞌana pasa talitali ꞌoinega sipaihoweya ma debana silaguya. ");
INSERT INTO bdd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma siheꞌaleya lotuyanega siloyauwedoweya, ma sihegwaeya, “Yauwedo, ꞌowa meYudiya ꞌidi kini baa!” ");
INSERT INTO bdd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma wete ꞌaiwe ꞌoinega Yesu debana sisapiya, ma siꞌesoheya, ta lotuyanega Yesu matana siꞌetuluha. ");
INSERT INTO bdd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cidi lotuyana ꞌigumwala, ta ꞌaleꞌo wasawasaedi ꞌoinega sihaloloya, ma ꞌiboi ꞌana ꞌaleꞌowega siheꞌote hileya, ma sitoeya sabi gihekelose. ");
INSERT INTO bdd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesu sitoeya, ꞌasa madouna ꞌoinega silatuwa, ma silobeya gwama Sailini pwatulega ꞌitautauyama, ta siloineya ma Yesu ꞌana kelose ꞌiꞌahali. Loheyaina sanina Saimoni, beno Alekisana ma Lupuso tamadiu. ");
INSERT INTO bdd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Coinega sitoeya tupwa Goligota ꞌoina (Ma Goligota ꞌana sanapu beno Mwagu ꞌasaina), ");
INSERT INTO bdd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ma mulamula siꞌebwaeya, beno waini ta mulo baꞌidana, ma ꞌabehega geyaꞌabwa muya madouna ꞌilolotoho, ta Yesu ꞌiguipaileya. ");
INSERT INTO bdd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma ꞌoinega baleꞌuwa situtu hepaꞌiyeya kelose ꞌoina, ma sihetoholoya. Muliyetega topaihowaowedi Yesu ꞌana ꞌaleꞌo siꞌewediya, eeta siguyaiyeya siboidimo ꞌoidiya. Cidi heguyaina gide kati ꞌoinega, ta ꞌeguma taiya ꞌiwini ꞌana ꞌaleꞌo ꞌaigeda ꞌiꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tutaina Yesu siꞌabihe keloseya beno gonagona ꞌana gamwagamwana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma ꞌana kelose ꞌoina sileleya, “MeYudiya ꞌidi kini.” Beno ꞌina ꞌamasa lamuna. ");
INSERT INTO bdd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ma wete toyagaha ꞌeluwa siꞌabihe kelosediya, ꞌaigeda ꞌina ꞌebeulega ma ꞌaigeda ꞌina ꞌadigeyegeyega. ");
INSERT INTO bdd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO bdd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tomota ꞌedai sitautau ma Yesu kelose ꞌoina siꞌiteya, ma silotuyaneya ma sihenameya, sigwae, “Nuwaꞌoleꞌoleu ꞌiya! Cugwaeya ꞌabehega sawasawahiu Hada Heꞌasisi ꞌuligehi ma sabwelo ꞌetoi ꞌoidiya ꞌuꞌabihila. ");
INSERT INTO bdd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hana ꞌuꞌabihetego ꞌuboi ma kelose ꞌoinega ꞌusuluma.” ");
INSERT INTO bdd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma wete topwaoli madoudi ta loina ꞌana toheꞌitao siboi ꞌoidiya sigwaehaneya, ma Yesu siꞌeheteteyeya, sigwaegwae, “Hali tomota ꞌilemediya, ma hana ꞌiboi ꞌida leme? ");
INSERT INTO bdd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tauna ꞌabehega Toꞌabihetenaina ma tupwa Isileli ꞌana toloina, hana keloseina ꞌoinega ꞌida suluma ma tada ꞌita ma ꞌane tahemisae.” Ma wete toyagahaowedi Yesu baꞌidanao siꞌabihe kelosediya, taudi ꞌadi kelose ꞌoidiyega sibwau baleya eema siheliyeya. ");
INSERT INTO bdd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma ꞌiꞌasudiladila pwaiya, ma tupwa mabwaiyana ꞌiguguyouwa ꞌana siga lahilahiya. ");
INSERT INTO bdd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lahilahiya Yesu ꞌenana madounega ꞌibwauwa, ꞌigwae, “Eloi, eloi, lama sabakitani,” ma ꞌana bui, “Cigu Yehoba, ꞌigu Yehoba, toꞌaha weyahina ꞌuꞌebesinegauwa?” ");
INSERT INTO bdd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma tupwadi deina sitotoholo ꞌina bwauina sihesagoheya ma sigwae, “Wahesagoha, Ilaitiya ꞌibwaubwauwe.” ");
INSERT INTO bdd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Coinega ꞌaigeda ꞌoidiyega ꞌipiliya ta balou ꞌiꞌeweya, ma waini memaina ꞌoina ꞌihebuteya, eeta ꞌaiwe ꞌaigeda matana ꞌibadiyeya, ma ꞌiꞌeyoyo haneheya Yesu ꞌahwana, ꞌitonunusiya, ma loheyaina ꞌigwaeya, “Tuwa tayamwayamwa, nuwana ꞌiꞌiunamo Ilaitiya ꞌilatuma ma kelose ꞌoinega ꞌiꞌabihete.” ");
INSERT INTO bdd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eeta Yesu ꞌenana madounega ꞌiwuiya, ma yawasina ꞌigumwala. ");
INSERT INTO bdd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma ꞌaleꞌoina Hada Heꞌasisi ꞌana biliupa ꞌiꞌeꞌigala luweya tabwanega ma ꞌisuluwa duduna. ");
INSERT INTO bdd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma toloꞌalehao ꞌadi tohanugeta Yesu ꞌana kelose matana ꞌitotoholo, Yesu ꞌina ꞌamasa ꞌana ꞌita bewa gide ꞌiꞌiteya, ꞌoinega ꞌigwaeya, “Moisa tuwa, loheya nage Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tupwadi wahiwahine wete bwagebwagega siꞌeꞌebubuna, beno Meli Magidala maꞌina waliyesa, tauna Yosepa ma tasina ꞌalomauna Yemesa sinadiu, ma Salome wete, ");
INSERT INTO bdd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","taudi mwalo Yesu simuliyeya ma ꞌana sipaihoweya ꞌina sakowasi Galili ꞌoina, ma tupwadi wahiwahine wete Galili ꞌoinega silagama Yelusalema Yesu baꞌidanao. Ma mabwaiyadi Yesu ꞌina ꞌamasa siꞌeꞌebubu. ");
INSERT INTO bdd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma ꞌilahilahi pwaiya, beno ꞌatububu ꞌana tuta sabwelo ꞌinaonaoma weyahina, beno meYudiya ꞌidi Sabati. ");
INSERT INTO bdd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Coinega Alimatiya loheyaina sanina Yosepa ꞌinaoma, tauna maꞌana hemisa ma ꞌiyamwayamwa ma to tuta Yehoba baleꞌuwa ꞌida hetoloina. Tauna Yosepaina ꞌinaoma ta maꞌina ꞌatepatu ꞌiluhuwa Pailato matana, ma Yesu wahina ꞌiꞌahwanoiyeya ma ꞌabehega ꞌigalihe. ");
INSERT INTO bdd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma ꞌoinega Pailato ꞌisalutuwa, ꞌigwae, “Ciyaa! Yesu ꞌiꞌamasa?” Coinega toloꞌalehao ꞌadi tohanugeta ꞌibwauweyama ma ꞌinaoma, ta Pailato ꞌihesilaleya, ꞌigwae, “Togidega, Yesu ꞌiꞌamasa pwaiya?” ");
INSERT INTO bdd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma loheyaina ꞌigwaeya, “Cehe, ꞌiꞌamasa pwaiya.” Coinega Pailato ꞌitagwala ma ꞌabehega Yosepa Yesu wahina ꞌiꞌewa. ");
INSERT INTO bdd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ta Yosepa ꞌaleꞌo waꞌewaꞌeꞌena ꞌigimwaneya, ma ꞌiꞌeweyama, ta maꞌina topaihowao Yesu wahina kelose ꞌoinega silagu dobiheya, ma ꞌaleꞌoina ꞌoinega siwaduya, muliyetega sigaliheya. Ma galihinaina yalayalaina gide duluha daꞌule ꞌalona, eema daꞌule madouna ma pwaꞌupwaꞌuwana ꞌoinega galihina siꞌahubodeya. ");
INSERT INTO bdd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Meli Magidalaina ma ꞌina waliyesa, tauna Yosese sinana maꞌiyana siꞌeꞌebubuna, ta siꞌiteya galihina ꞌoina wahinaina silaguya. ");
INSERT INTO bdd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabatiina ꞌigumwala, ma Meli Magidala ma ꞌina waliyesa, tauna Yemesa sinana, ma Salome wete baꞌidadiu holowa bwebweꞌana sigimwaneya ma ꞌabehega Yesu wahina ꞌoinega siheholoi. ");
INSERT INTO bdd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gona ꞌiꞌadaleya beno wiki ꞌana sabwelo nugenugetaina ꞌoina, ma sinala ꞌina saehohau ꞌoina wahiwahineyedi maꞌidi holowa sinaonaoma Yesu galihinaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma siboidimo sihehegwaegwae, sigwaeya, “Taiya nata ꞌahubodaina galihina ꞌahwanega ꞌida buihile weyahida?” Weyahina daꞌuleina madou hedada. ");
INSERT INTO bdd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma siloꞌita naowa, galihaina ꞌana ꞌahuboda daꞌuleina ꞌahwanega ꞌibuihileya, ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Coinega wahiwahineyedi galiha ꞌalona siluhuwa, ma ꞌidi ꞌebeulega hewali maꞌana ꞌaleꞌo waꞌewaꞌeꞌena ꞌimiyamiya siꞌiteya, ma siꞌateyohowa. ");
INSERT INTO bdd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma hewaliina ꞌihegwaediya, ꞌigwae, “Sahena waꞌateꞌateyoho. Yesu gwama Nasaleta, tauna sigihe keloseya waꞌebeꞌebese, ma geya tauna ꞌebwa ꞌimiyamiya, weyahina tauna ꞌitoholo hila. Cina ꞌebeꞌeno bewa waꞌiteya galihinamo. ");
INSERT INTO bdd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hesi wahila ma Yesu ꞌana tomuliyao ꞌoidiya ta wete Pita ꞌoina wahepwaila, wagwae, ‘Yesu nata ꞌinugeta Galili, ma ꞌomi wamuliya, ma nage ꞌoina waꞌita, gide mwalo ꞌina hepwaila ꞌoimiya.’” ");
INSERT INTO bdd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Coinega wahiwahineyedi galihega silatu mwayamwayauma ma sidena, weyahina nuwadi ꞌihepwanopwanowa, ma wete sidedededela, maꞌidi ꞌateyoho ta geya ꞌeta taiya ꞌoina sihepwaila. ");
INSERT INTO bdd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiki ꞌana sabwelo nugenugetaina gonagona, Yesu ꞌina toholohila ꞌoina ꞌilatu nugeta Meli Magidala ꞌoina, tauna ꞌalonega mwalo hiꞌahiꞌa site sebeni Yesu ꞌiula latuhediya. ");
INSERT INTO bdd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Coinega Meliina ꞌinaoma ma Yesu ꞌina tomota ꞌihemataluwediya, ta taudi tuwa ꞌabwa maꞌidi nuwagala sidoudou Yesu weyahina. ");
INSERT INTO bdd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma Meli hemataluwa ꞌiꞌebwaediya ꞌigwae, “Yesu yaꞌiteya mayawasina.” Ta taudi siꞌahwa ꞌaboꞌaboweya. ");
INSERT INTO bdd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma muliyetega Yesu ꞌana tomuliyao ꞌeluwa Yelusalemega sihapwesama ma hali ꞌasa weyahina sitautauya, ma Yesu ꞌiꞌabilatuheya ꞌiboi hali ꞌita ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eeta site luwaedi sigogona sihila Yelusalema, ma ꞌiyadiyao sihemataluwediya, ma hesi geya sihemisaedi. ");
INSERT INTO bdd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muliyetega Yesu ꞌana tomuliyao site lebeni siꞌaiꞌai, ma Yesu matadiya ꞌilatuwa, ma ꞌiheliyediya ꞌidi nuwapota weyahina, ꞌigwaeya, “Ciyadao taudi ꞌigu toholohila mulina siꞌitegauwa ta ꞌoimiya sihehepwaila, ma togidega ta geya wahemisaedi?” ");
INSERT INTO bdd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Coinega hemataluwa ꞌiꞌebwaediya, ꞌigwae, “Watauya tupwa mabwaiyana, ma wasagu tomota mabwaiyadi ꞌoidiya waguguyae. ");
INSERT INTO bdd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eema taiyewedi sihemisaegauwa waꞌabihe babitaisowedi ma lema bwebweꞌana siloba, ma ꞌeguma taiyewedi geya sihemisaegau ꞌabwa loina galana siloba. ");
INSERT INTO bdd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Ma ꞌagu tohemisaowedi ꞌilaꞌilala waiwaidi ꞌabwa sipaihowadi, beno saniguwega hiꞌahiꞌa tomota ꞌoidiyega siulalatuhedi, ma ꞌenana hagana ma hagana ꞌoidiyega sihehe gwaegwae, ");
INSERT INTO bdd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ma ꞌeguma mwata lolosasadi siꞌabi lagasidi, geyaꞌabwa ꞌidi ꞌenali ꞌoidiyega siꞌamaꞌamasa. Wete weꞌaha newanewalina ꞌeguma sinuma geyaꞌabwa siꞌamaꞌamasa. Ta wete ꞌeguma tolohalao siꞌabitohodi, sibwebweꞌana tuwa.” ");
INSERT INTO bdd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cida Bada Yesu ꞌina hemataluwa ꞌana tomuliyao ꞌoidiya ꞌilosaloha pwaiya ma ꞌihaneya galewa, ma Yehoba ꞌina ꞌebeulega ꞌimiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta ꞌoinega ꞌana tomuliyaowedi sitauya tupwa mabwaiyana ꞌoidiya ma Yesu wasana siguguyaeya, ma hesi Badaina baꞌidadiu sipaipaihowa, ta ꞌina waiwai ꞌoinega paihowaedi ꞌebe henainaida sipaihowediya, ma ꞌoinega tomota wasaina sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cae, Bada Tiyopilo. Tomota tupwana baibaiwana Yesu heꞌoteꞌotetelina silele pwaidiya toꞌaha gide ꞌina paihowa ꞌoida weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Heꞌoteꞌotetelaedi silelediya toꞌaha gide taudi matadiyega siꞌita nugeteya, ꞌoinega gwaeina siloguguya ma siheꞌoteꞌotetela ꞌoima, ");
INSERT INTO bdd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ma hesi, nuwatuhuwedi mabwaiyadi ꞌidi ꞌebehegaina ꞌoinega ꞌitauyama ꞌana siga nige, ta yasanapu bwaibwainidiya, ꞌoinega nuwanuwagu ma mabwaiyadi yada heꞌoteꞌotetela bwaibwainidi ꞌoiuwa, ");
INSERT INTO bdd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ma ꞌoinega nuwatuhuwedi ꞌuhesagoha pwaidiya lamuna ꞌuda sanapu ma wete ꞌuꞌahwa moisaedi. ");
INSERT INTO bdd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cigu heꞌoteꞌotetela ꞌana ꞌebehegaina bewa gidemusa: Tutaina Helodi ꞌina tuta hetoloina Yudiya ꞌoina, topwaoli ꞌaigeda sanina Sakaliya. Mwanena Elisabeti. Siteluwaedi ꞌidi susu boda topwaoliyao, ma hesi Sakaliya ꞌina boda topaihowa sanina Abaiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ma siteluwaedi ꞌidi miya ꞌidumwalu hedadeya Yehoba matana, weyahina Yehoba ꞌina loinao mabwaiyana sihematamatana bwaibwainidiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma hesi siteluwaedi geya ꞌeta natudiu, weyahina Elisabeti ꞌagaꞌagalina, wete ꞌiheꞌaiꞌaihale pwaiya, ta mwanena wete ꞌihetautaubada pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Caigeda tuta ꞌoina Sakaliyaina ꞌina boda ꞌidi sabwelo ma pwaoli sipaihowa Yehoba matana. ");
INSERT INTO bdd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Weyahina gidemusa mumugadi, ma ꞌiyanao ꞌoidiyega Sakaliya hesinuwa ꞌilobeya, ꞌoinega Bada ꞌina Hada Heꞌasisi ꞌoina ꞌiluhu ma ꞌabehega ꞌaiwe masina mahaina bwebweꞌana gide gadoꞌa* ꞌigabu ꞌebe pwaoli ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma masinaina ꞌana tuta gabu ꞌoina boda madouna Hadainaina ꞌatamana siꞌahwaꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Coinega Yehoba ꞌina tohalewasa anelose ꞌilatuwa Sakaliyaina matana, ma ꞌaiweina masinaina mahaina bwebweꞌana ꞌana ꞌebe gabu ꞌebeulega ꞌitoholowa. ");
INSERT INTO bdd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaliyaina ꞌiꞌiteya ma nuwana ꞌihenainaida, ma wete ꞌimatauta madouna. ");
INSERT INTO bdd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Coinega aneloseina Sakaliya ꞌihegwaeya ꞌigwae, “Sakaliya, sahena ꞌumatamatauta ma hesi ꞌuyaliyaya. Weyahina ꞌino ꞌahwanoi Yehoba ꞌihesagoheya, ꞌoinega mwaneu Elisabeti ꞌabwa natumiu loheyana ꞌihenatune ma sanina ꞌulagu Yoni. ");
INSERT INTO bdd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tauna weyahina ꞌabwa ꞌuyaliyaya, ma wete tomota mabwaiyadi siyaliyaya gwamaina ꞌina liꞌu weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Weyahina natumiuina ꞌabwa sanina madouna Yehoba matana, ma hesi sahena waini ma weꞌaha waiwaidi ꞌinumanumadi, weyahina ꞌina liꞌu ꞌoinega nata ꞌimaha Yaluyaluwa Tabunega. ");
INSERT INTO bdd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma ꞌoinega tauna meIsileli baibaiwadi ꞌitoe hiledima ꞌidi Bada Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma tauna nata maꞌina waiwai ta maꞌina ꞌatepatu ma Yehoba weyahina ꞌida hetohepwaila, ta ꞌina waiwai gidemusa mwalona palopita Ilaitiya ꞌina waiwai. Ma guguya ꞌoinega tama nuwadi ꞌibuidi ma natudiyao sinuwatuhudi. Ma wete loina ꞌadi toligehiyao nuwadi ꞌibuidi ma ꞌeda dumwaluna ꞌoinega sitauya, ma ꞌoinega Bada ꞌina tomota ꞌiꞌatububudi Toꞌabihetenaina ꞌina tauyama weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Coinega Sakaliyaina aneloseina ꞌihegwaeya, ꞌigwae, “Gwaeina bewa ꞌana hesagoha palipalina, weyahina taugu yahetaubada, ma mwanegu wete ꞌiheꞌaiꞌaihale pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Coinega aneloseina ꞌigwaeya, “Taugu Gebeliyela, ma tuta mabwaiyana ꞌoidiya Yehoba matana yatotoholo, ꞌoinega tuta bewa ꞌoina tauna ꞌihesumanegauma, yatauyama ꞌoiuwa, ma wasa bwebweꞌana bewa yahepwaile ꞌoiuwa. ");
INSERT INTO bdd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma hesi wasaina bewa ꞌowa geya ꞌuhemisae, ꞌoinega nata memenau ꞌimwau ma geyaꞌabwa ꞌuhehegwaegwae ꞌana siga wasa bewa ꞌana moisa ꞌilatu. Cabwa hesi ꞌuhegwaegwae hila.” ");
INSERT INTO bdd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ma tomotaedi mabwaiyadi ꞌabwa tuwa ꞌatamana siyamwayamwana, ma sinuwanuwatuhu sigwae, “Toꞌaha weyahina Sakaliya ꞌiheheboi Hada Heꞌasisi ꞌoina?” ");
INSERT INTO bdd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Muliyetega Sakaliyaina ꞌilatuma ma geya sowasowahina ꞌoidiya ꞌigwae, weyahina memenana ꞌimwauwa. Coinega sisanapuya ꞌabehega Hada Heꞌasisi ꞌalona ꞌilaꞌilala ꞌiꞌita pwaiya. Ma ꞌoinega geya sowasowahina ma ꞌoidiya ꞌigwae, ma hesi tuwa nimanega ꞌilaꞌilala ꞌipaihoweya. ");
INSERT INTO bdd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma Sakaliyaina ꞌina pwaoli ꞌana sabwelowedi sigumwala ma ꞌilohihila ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma muliyetega mwanenaina Elisabeti ꞌigamwa, ma waiꞌena paibi ꞌalodiya geya ꞌida yawala ma hesi hadai ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma ꞌigwaeya, “Bewa taugu ꞌagu lema Yehoba ꞌoinega. Mwalo ꞌagaꞌagaligu, ꞌoinega maꞌigu mwadina, ma tuta bewa ꞌigu debamwadina ꞌigumwala.” ");
INSERT INTO bdd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeti ꞌina waiꞌena sikisiina, ma tutaina ꞌoina Yehoba ꞌina anelose sanina Gebeliyela ꞌihesumaneya ma ꞌitauya tupwa Galili ꞌasa ꞌaigeda sanina Nasaleta ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ma wahine ꞌaigeda nuwanuwadeyana sanina Meli ꞌoina ꞌilatuwa. Gumalaulauina ma Yosepa tamadiyao sitagwala ma sihehaiyedi. Yosepaina tauna Debida tubuna. ");
INSERT INTO bdd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma anelose Meli ꞌoina ꞌilatuwa ma ꞌihegwaeya ꞌigwae, “Yauwedo Meli. Bada ꞌina helau madou hedadena ꞌoiuwa, ma tauna bewa tuwa maheteu.” ");
INSERT INTO bdd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Coinega Meli nuwana ꞌihenainaida moisa, ma gwaeyedi weyahidi ꞌinuwanuwatuhu dadana. ");
INSERT INTO bdd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta anelose ꞌigwaeya, “Meli, sahena ꞌumatamatauta. Weyahina Yehoba ꞌina helau madou hedadena ꞌoiuwa ꞌimiyamiya, ");
INSERT INTO bdd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ma ꞌabwa nata ꞌugamwa ma natuu loheyana ꞌuhenatune ma sanina ꞌulagu, Yesu. ");
INSERT INTO bdd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tauna nata ꞌaigeda tohewaiwai madouna, weyahina ꞌabwa nata tomota siꞌita ma weyahina sigwae ꞌabehega tauna Tomiya Tabwana Natuna, ma Bada Yehoba loina waiwai ꞌiꞌebwae, gide tubuna Debida ꞌina loina, ");
INSERT INTO bdd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ma ꞌoinega Yakobo ꞌina bodao ꞌiloinaedi, ma hesi ꞌina ꞌebeloinaina geyaꞌabwa ꞌigumwagumwala.” ");
INSERT INTO bdd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Coinega Meli anelose ꞌihegwaeya ꞌigwae, “Togidega nata bewa ꞌilatu ꞌesa? Weyahina taugu geya mwanegumo.” ");
INSERT INTO bdd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta anelose ꞌigwaeya, “Yaluyaluwa Tabuna nata ꞌisuluma ꞌoiuwa, ma Yehoba ꞌiꞌabi hewaiwaiyego, ma natuu bwebweꞌana hedadena ma heꞌasisina ꞌuhenatune. Tauna nata sibwauwe Yehoba Natuna. ");
INSERT INTO bdd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma ꞌusanapu ꞌabehega nibaiuina Elisabeti ꞌiheꞌaiꞌaihale pwaiya ma ꞌiꞌagala, ma hesi wahineinaina bewa tuwa ꞌigamwa pwaiya ta bewa ꞌina waiꞌena hesikisina. ");
INSERT INTO bdd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Weyahina ginaula mabwaiyana Yehoba sowasowahina ma ꞌipaihowadi.” ");
INSERT INTO bdd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Coinega Meli ꞌigwaeya, “Taugu Yehoba ꞌina topaihowa. Toꞌaha gidemusa ꞌino gwae ꞌoiguwa, tuwa ꞌida latu.” Ma aneloseina Meli ꞌiꞌebesineya ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma tuta bewa mulina Meli ꞌitoholowa ma Yudiya ꞌoyadiya ꞌitauya mwayamwayauwa, Elisabeti ꞌina ꞌasa ꞌoina ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cilatuwa ma Sakaliya ꞌina hada ꞌoina ꞌiluhuwa ma nibainaina Elisabeti ꞌihelauweya. ");
INSERT INTO bdd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Beno ꞌoina Elisabeti nibainaina ꞌina helau ꞌihesagoheya ma gamwanega gwamaina ꞌimwasala, ma wete Yaluyaluwa Tabuna Elisabetiina ꞌilohemaheya, ");
INSERT INTO bdd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma ꞌenana madounega ꞌiwuiya ꞌigwae, “Nibaya, Yehoba ꞌihelauwegowa, geya ꞌeta wete wahine gidemusa ꞌowa. Ma ꞌabwa natuu ꞌuhenatune gomagoma bwainina. ");
INSERT INTO bdd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma toꞌaha weyahina ꞌowa ꞌigu Bada sinana ma ꞌunaoma ꞌuboꞌeboꞌenegau? ");
INSERT INTO bdd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma hesi ꞌino loyauwedo yahesagoheya ta gwamaina ꞌiyaliyaya ma ꞌimwasala gamwaguwa. ");
INSERT INTO bdd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ma ꞌowa Bada ꞌina gwae ꞌana tohemisa, ꞌoinega maꞌino yaliyaya, weyahina ꞌabwa nata ꞌana moisa ꞌilatu ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta Meli ꞌigwaeya, “Tuta mabwaiyana ꞌateguwega Bada yahehepwatuwe, ");
INSERT INTO bdd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma wete tuta mabwaiyana ꞌoidiya yaluyaluwagu ꞌiyaliyaliyaya Yehoba ꞌagu tolemaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Weyahina taugu ꞌina topaihowa wewelohegu, ma hesi ꞌoiguwa ꞌiꞌitaꞌita suluma, ma ꞌabehega tuta sinaonaoma ꞌoidiya mehau mabwaiyadi sihepwatuwegau. ");
INSERT INTO bdd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Weyahina Yehoba tauna Tohewaiwai moisa, paihowa waiwaidi ꞌipaihowediya weyahigu, ma wete tauna sanina bwebweꞌana ma heheꞌasisiina. ");
INSERT INTO bdd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tauna ꞌana toheꞌasisiyanao mehau yaso ꞌaigeda ꞌaigeda ꞌiꞌateꞌate muyamuyaedi. ");
INSERT INTO bdd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ma hesi taudi togagasaedi ma tonuwa hanehaneyedi nimana ꞌana waiwaiyega ꞌiꞌahupeinedi. ");
INSERT INTO bdd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ma wete Tauna tohewasawasao ꞌiꞌabiꞌabi dobihedi ꞌidi ꞌebemiya wasawasao ꞌoidiyega, ma hesi toweweloheyao ꞌiꞌabiꞌabi hanehedi. ");
INSERT INTO bdd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ma wete togomaleyao ꞌiheheꞌaidiya ta simwausuwa, ma tohewasawasao nimenimedimo ꞌihehesumane hilediya. ");
INSERT INTO bdd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tauna wete ꞌina gwae hemisaina tubudao ꞌoidiya ꞌinuwatuhu yahiya ꞌoinega tauda meIsileli ꞌiꞌatemuyamuyaegita ma ꞌilemegita, ");
INSERT INTO bdd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","gidemusa ꞌina gwae hemisaina tubudao Ebalahamo ma natunao ꞌoidiya, ꞌabehega ꞌida ꞌatemuyamuya hataedi.” ");
INSERT INTO bdd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma Meli ꞌina gwaeina ꞌilosalohidiya, ma ꞌoinega nibainaina mahetena simiyana ꞌana siga waiꞌena ꞌetoi sigumwala, ma muliyetega ꞌilohihila ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ma hesi Elisabetiina ꞌimiyamiya ee ꞌana siga ꞌihenatuna, ta gwamaina meloheyana. ");
INSERT INTO bdd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eeta Elisabeti ꞌina bodao ma ꞌiyanao Yehoba ꞌina helau ꞌoina sihesagoheya, ma mabwaiyadi mahetenao siyaliyaya hegogona. ");
INSERT INTO bdd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma gwamaina ꞌina tuta liꞌu mulina ma sabwelo sebeni sigumwala, ꞌoinega ꞌina bodao siꞌautama gwamaina ꞌina ꞌebeselolo ꞌwapina matana sabi ꞌupwa, ma ꞌabehega tamana sanina ꞌoinega sihewaliyese. ");
INSERT INTO bdd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ta sinanaina ꞌiꞌausiya ꞌigwae, “Sahena tamana ꞌoina wahehewaliyese, ma hesi sanina walagu Yoni.” ");
INSERT INTO bdd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta ꞌiyanaowedi sigwaeya, “Sani beno ꞌomi geya sanimi!” ");
INSERT INTO bdd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Coinega nimadiyega henimasusuwega gwamaina tamana sihesilaleya ma ꞌabehega gwamaina to sani silagu. ");
INSERT INTO bdd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ta Sakaliyaina ꞌebelele ꞌiꞌahwanoiyeya, siꞌebwaeya ma gwamaina sanina ꞌoina ꞌileleya ꞌigwae, “Sanina Yoni.” Ma bodaedi saninaina siꞌiteya ma nuwadi ꞌihenainaida. ");
INSERT INTO bdd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Beno ꞌoina Sakaliya memenana ꞌimeyameyahana hila, ma ꞌigwae hila, ma Yehoba ꞌihepwatuweya. ");
INSERT INTO bdd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eeta ꞌiyanaowedi mabwaiyadi simatauta. Muliyetega tetelaina ꞌiꞌedadana Yudiya ꞌoyana ma tupwanao mabwaiyadi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma tomotaedi sihesagoheya ma sinuwatuhu dadana, ma siboidimo ꞌoidiya sihesilala hilediya sigwae, “Gwama bewa nata togidega ꞌabwa ꞌina paihowa?” Weyahina siꞌiteya Yehoba ꞌina waiwai ꞌoina ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eeta tamanaina Sakaliya Yaluyaluwa Tabuna ꞌilohemaheya, ma ꞌipalopisai, ꞌigwae nugeta ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bada tahepwatuwe tauna meIsileli ꞌida Yehoba, weyahina tauna ꞌitauya pwaima ꞌoida ma ꞌabehega ꞌiꞌabihetegita ma miyamwau ꞌoinega ꞌilihasigita. ");
INSERT INTO bdd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Coinega ꞌina hewali Debida ꞌina susuwega ꞌada Toꞌabihetenaina ꞌiꞌabi latuheya ꞌoida. ");
INSERT INTO bdd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mwalona Yehoba ꞌina palopitao nugenugetaidi ꞌina gwaeina gidemusa sihepwaila nugeteya, ");
INSERT INTO bdd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ma ꞌabehega ꞌida lemegita ꞌada ꞌalehao ꞌoidiyega ma wete ꞌada tolohesohesoiyao ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ma wete mwalo ꞌigwae hemisa ma ꞌabehega tubudao nugenugetaidi ꞌiꞌatemuyamuyaedi ma ꞌina gwae hemisaina geyaꞌabwa ꞌinuwanuwanaide. ");
INSERT INTO bdd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gwae hemisaina tubudai Ebalahamo weyahina Yehoba ꞌiꞌebwaeya ");
INSERT INTO bdd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ma ꞌabehega ꞌilihasigita ꞌada ꞌalehao ꞌoidiyega ma ꞌoinega maꞌida ꞌatepatu ꞌoina tapaihowa, ");
INSERT INTO bdd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma wete sabwelo ꞌaigeda ꞌaigeda ꞌoidiya maꞌida mumuga bwebweꞌana tadumwalu tauna matana. ");
INSERT INTO bdd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma ꞌowa natugu, ꞌabwa nata sibwauwego Tohewaiwai moisa ꞌina palopita, weyahina ꞌowa nata ꞌunugeta ma Bada ꞌina ꞌeda ꞌuꞌatububu, ");
INSERT INTO bdd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","beno ꞌina tomotaiyao ꞌuhenuwalagudi ma ꞌabehega mumuga galadi ꞌadi nuwasam ꞌoidiyega ꞌadi ꞌabihetena siloba. ");
INSERT INTO bdd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Weyahina Yehoba ꞌina ꞌatemuyamuya ꞌoida, madou hedadena, ma ꞌabwa ꞌida ꞌabihetena galewega gide ꞌasilala ꞌiꞌabiꞌabilatuhe ꞌoida, ");
INSERT INTO bdd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ma ꞌoinega taudi wete guguyou ma ꞌamasa ꞌidi tupwa ꞌoina simiyamiya ꞌida ꞌabiheꞌasilaladi, ma ꞌoinega mabwaiyada ꞌihanugetegita miya daumwala ꞌana ꞌeda ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma ꞌoinega gwamaina ꞌihemadouwa ma yaluyaluwana wete ꞌihewaiwaiya. Ma ꞌitauya yoho ꞌawawa, ma nobwa ꞌiboinamo ꞌimiyamiya ꞌana siga meIsileli ꞌoidiya ꞌilatuwa ꞌiloguguya. ");
INSERT INTO bdd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yoni ꞌina tuta hesedaseda ꞌoina toloina ꞌaigeda madouna sanina Sisa Ogusito ꞌimiyamiya, ma ꞌina loina ꞌilaguya ma ꞌabehega gogo ꞌaigeda ꞌaigeda tomotaedi sanidiyao sileledi. ");
INSERT INTO bdd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Loinaina ꞌihegaina tutaina Kuwilinio ꞌina tuta hetoloina Siliya ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Coinega tomota mabwaiyadi sitauya ꞌasa tamadiya ma ꞌane sanidiyao sileledi. ");
INSERT INTO bdd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepa wete Nasaletega ꞌitoholowa, beno Galili ꞌalonega, ma ꞌitauya Yudiya, Debida ꞌina gogo sanina Bedeliyema ꞌoina, weyahina Yosepa tauna Debida ꞌina susu ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Coinega Meli mahetena sitauya ma ꞌabehega nobwa sanidi sileledi, ma Meliina magamwagamwana. ");
INSERT INTO bdd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma tutaina Bedeliyema ꞌoina simiyamiya ma ꞌina waiꞌena ꞌiloba pwaiya ta ꞌihenatuna, ");
INSERT INTO bdd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ꞌoinega gwamaina ꞌaleꞌowega ꞌiwaduya ma hebai ꞌidi ꞌebeꞌai ꞌoina ꞌilaguya. Weyahina hada taumana ꞌimaha pwaiya, ta geya ꞌaigeda wete sawasawahina ma ꞌoina siluhu. ");
INSERT INTO bdd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma tupwaina ꞌoina sipi ꞌadi toꞌitayahinao hinuwana siꞌoꞌoyatola pwatula, ma ꞌidi sipiyao siꞌitaꞌita yahidi, ");
INSERT INTO bdd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ma Bada ꞌina anelose ꞌiloheꞌate yohodiya ma ꞌina ꞌasilalega mabwaiyadi simatauta. ");
INSERT INTO bdd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Coinega aneloseina ꞌihegwaediya, ꞌigwae, “Sahena wamatamatauta, ma hesi wayaliyaya, weyahina wasa bwebweꞌana yaꞌeweyama ꞌoimiya, ma nata tomota mabwaiyadi wete ꞌidi ꞌebe yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma wasaina bewa, nige hinuwanaina Debida ꞌina ꞌasa, ꞌami Toꞌabihetenaina ꞌiliꞌuwa, Tauna ꞌida Bada Keliso. ");
INSERT INTO bdd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Coinega ꞌana ꞌebe loꞌinanaina bewa, ma ꞌeguma gwamaina ꞌaleꞌo ꞌoinega siwaduya ma hebai ꞌidi ꞌebeꞌai ꞌoina ꞌiꞌenoꞌeno waloba, tauna tuwa beno gwamaina.” ");
INSERT INTO bdd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma tutaina ꞌoina anelose wete baibaiwadi galewega sihuhulaima, ma Yehoba sihehepwatuwe, ");
INSERT INTO bdd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sigwaegwae, “Yehoba galewa tahepwatuwe, ma baleꞌuwa taudi ꞌihelauwediya simiya yaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cigumwala ma aneloseyedi sihila pwaiya galewa, ma sipi ꞌadi toꞌitayahinao siboidimo ꞌoidiya sigwae, “Bedeliyema ꞌoina tatauya ma ginaulaina Bada ꞌihepwaileya taꞌita.” ");
INSERT INTO bdd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Coinega silomwayamwayauwa ma sitauya, ma Meli ma Yosepa ta wete gwamaina hebai ꞌidi ꞌebeꞌai ꞌoina ꞌiꞌenoꞌeno silobeya. ");
INSERT INTO bdd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nage ꞌoina siꞌiteya ma gwamaina tamana ma sinana sihegwaediya toꞌaha gide anelose ꞌina gwae ꞌoidiya gwamaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma tupwana tomota wete wasaina sihesagoheya ta nuwadi ꞌihenainaida toꞌitayahi sipiyedi ꞌidi gwaeina weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ta Meli gwaeyedi mabwaiyadi ꞌinuwatuhu yahidiya ma nuwana ꞌihenetediya weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Coinega toꞌitayahi sipiyedi sihila ma maꞌidi hepwatu Yehoba sanina siꞌabilagasiya, weyahina anelose ꞌina hepwaila ꞌoidiya ꞌana moisa sihesagoheya, ma wete siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma ꞌina wiki ꞌaigeda ꞌigumwala pwaiya, ma gwamaina ꞌina ꞌebeselolo ꞌwapina siꞌupwa yauleya ma sihesaniyeya Yesu, sanina beno mwalo anelose Meli ꞌiꞌebwaeya tutaina ꞌabwa geya ꞌigamwa. ");
INSERT INTO bdd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma ꞌina tuꞌwau mulina Meli ꞌana ꞌabiheꞌehau ꞌana tuta ꞌilobeya, ta natudiuina sitoeya sihaneya Yelusalema, ma ꞌane gwamaina siꞌebwayae Yehoba ꞌoina gide Mosese ꞌina loina ꞌabehega sipaihowa. ");
INSERT INTO bdd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yehoba ꞌina loinaina bewa gide sileleya, ꞌigwae, “Gwagwama toliꞌu nugeta meloheyadi watagwaledi Bada ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma wete taudi ꞌidi pwaoli Yehoba weyahina sitauyedi, gidemusa ꞌina loina ꞌilaguya, ꞌigwae, “Cimi pwaoli bunetutu ꞌeluwa bo gabubu ꞌeluwa.” ");
INSERT INTO bdd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma nage tutaina ꞌoina Yelusalema ꞌoina ꞌaigeda bada sanina Simioni ꞌimiyamiya. Tauna loheya bwebweꞌana, ma wete Yehoba ꞌiheꞌasisiyaneya madouna, ma ꞌiyamwayamwa meIsileli ꞌadi Toꞌabihetena weyahina. Loheyaina Yaluyaluwa Tabuna ꞌoina ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Yaluyaluwa Tabunaina ꞌiheꞌiteya ma ꞌabehega sahena ꞌiꞌamaꞌamasa ma ꞌana siga Toꞌabihetenaina Yehoba ꞌoinega ꞌiꞌita nugeta. ");
INSERT INTO bdd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma Yaluyaluwa Tabuna ꞌihenuwa laguweya, ma Simioniina ꞌiluhuwa Hada Heꞌasisi ꞌoina, ta Yosepa ma Meli gwamaina Yesu siꞌahaliyama Hada Heꞌasisi ꞌoina, ma weyahina sipaihowa gide loina ꞌina hepwaila. ");
INSERT INTO bdd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Coinega Simioni gwamaina ꞌiꞌahaliya ma Yehoba ꞌoina ꞌiloyauwedowa, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bada, ꞌino gwae hemisa ꞌoiguwa yaloba pwaiya, ꞌoinega bewa tuwa ꞌutagwalegau ma maꞌigu yaliyaya yaꞌamasa, ");
INSERT INTO bdd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Weyahina mataguwega ꞌino Toꞌabihetenaina yaꞌiteya, ");
INSERT INTO bdd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","bewa Tauna ꞌulagu latuheya mabwaiyama ꞌoima, ");
INSERT INTO bdd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ta taudi ganamuli ꞌidi Toꞌabiheꞌasilala, ma tauma ꞌino tomota meIsileli ꞌima ꞌebe hepwatu.” ");
INSERT INTO bdd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma tamana ma sinana nuwadi ꞌihepwanopwanowa ꞌina gwaeyedi natudiu weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Coinega Simioni ꞌigwae helauwediya, ta ꞌigwae Meli ꞌoina, tauna Yesu sinana, ma ꞌigwaeya, “Cuꞌita gwama bewa Yehoba ꞌihesinuweya ma ꞌoinega ꞌabwa meIsileli tupwana baibaiwadi ꞌiꞌabihe beꞌudi, ma tupwana baibaiwadi ꞌiꞌabihe toholodi, ma tauna tuwa ꞌabwa ꞌiheꞌilaꞌilala tomota ꞌoidiya, ma tupwadi siꞌahwa ꞌaboꞌabowe, ");
INSERT INTO bdd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ma ꞌoinega ꞌidi nuwatuhu dahwadahwaidi ꞌiꞌabi latuhedi. Ma ꞌowa Meli nata ꞌino nuwagala gide suna ꞌibadibadigo.” ");
INSERT INTO bdd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nage ꞌoina ꞌaigeda wahine topalopisai ꞌimiyamiya, sanina Ana, tauna Penuwela natuna, ma wete Aseli ꞌina susu ꞌaigeda. Wahineina ꞌiheꞌaiꞌaihale pwaiya weyahina mwalo hene ꞌihai ta mamwanena simiyamiya gide bolime sebeni. ");
INSERT INTO bdd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma mwanena ꞌiꞌamasa ta tauna ꞌihiwapeya, ma ꞌimiyamiya ꞌana siga ꞌana bolime ꞌeitipowa. Ma wahineina tauna Hada Heꞌasisi geya ꞌida ꞌebesineya sabwelo ma hinuwana ꞌoidiya, ma Hada Heꞌasisi ꞌalona Yehoba ꞌiheheꞌasisiye, ma ꞌiꞌahwaꞌahwanoi hegomaleyega. ");
INSERT INTO bdd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tuta nage ꞌoina wahineina ꞌinaoma ma Yehoba ꞌoina ꞌiloyauwedowa, ma gwamaina weyahina ꞌigwae meYelusalema ꞌoidiya, ꞌigwaeya, “Gwama bewa tauna ꞌada Toꞌabihetena tayamweyamweya.” ");
INSERT INTO bdd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ma paihowa mabwaiyana silosaloha pwaidiya, toꞌaha gide Yehoba ꞌina loina, ma sihila Galili ꞌoina, weyahina taudi meNasaleta. ");
INSERT INTO bdd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta gwamaina ꞌimadouwa ta maꞌina waiwai, ma wete maꞌina sanapu, weyahina Yehoba gwamaina ꞌihelauweya madouna. ");
INSERT INTO bdd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bolime ꞌaigeda ꞌaigeda ꞌoidiya Yesu sinana ma tamana sihanehane Yelusalema, Hataona Guyaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma tutaina Yesu ꞌina bolime tuwelo ꞌilobeya ta mahetediu sihaneya guyaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Coinega tutaina guyai ꞌigumwala ta mabwaiyadi sisawala ꞌidi gogowa, ma gwamaina Yesu tuwa Yelusalema ꞌoina ꞌimiyamiya. Tamana ma sinana geya sisanapu, ");
INSERT INTO bdd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ma ꞌidi nuwatuhu ꞌabehega tauna boda mahetenao. Coinega sitautauya ma ꞌana siga ꞌiboiya, ma Yesu siꞌebeseya ꞌidi bodao ma ꞌiyadiyao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ma geya siloba, ꞌoinega sihila Yelusalema, ma nobwa siꞌebeseya, ");
INSERT INTO bdd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ta geya siloba ꞌana siga sabwelo ꞌetoi sigumwala, ta silobeya Hada Heꞌasisi* ꞌalona, meYudiya ꞌidi toheꞌitao mahetenao simiyamiya, ꞌihehesagohedi ma wete ꞌihehesilala ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma taudi ꞌina hemaisao bwebweꞌadi ma dumwaludi sihesagoheya ta mabwaiyadi nuwadi ꞌihenainaida. ");
INSERT INTO bdd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta wete tutaina tamana ma sinana siꞌiteya nuwadi ꞌihenainaida, ta sinana ꞌihegwaeya, ꞌigwae, “Natugu, toꞌaha weyahina bewa gidemusa ꞌupaihowa ꞌeseya, ta ꞌoinega maꞌima nuwagala tamau baꞌidagu ꞌabesebesego?” ");
INSERT INTO bdd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Coinega Yesu ꞌigwaeya, “Toꞌaha weyahina wabesebesegau? Nuwana geya wasanapu ꞌagu lobwaina taugu Tamagu ꞌina Hada yamiyamiya?” ");
INSERT INTO bdd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tamana ma sinana geya nuwadi ꞌisabwalena ꞌina gwaeina weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Coinega mahetenao sihila Nasaleta, ma nobwa ꞌidi gwae ꞌihemata matanediya. Ma hesi sinana ginaula bewa weyahidi ꞌinuwanuwatuhu madouna. ");
INSERT INTO bdd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Yesu ꞌihehemadou ta maꞌina sanapu, ꞌoinega Yehoba ꞌiyaliyaya weyahina, ma tomota wete gide ꞌidi ꞌebe yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Toloina madouna Sisa, sanina Taibiliya, tauna ꞌiloiloina bolime pipitini ꞌoidiya, ma gabulena Ponitio Pailato tupwa Yudiya ꞌana toloina, ma Helodi tupwa Galili ꞌana toloina, ma tasina Pilipi tupwa Ituliya ma Tilakoniti ꞌadi toloina, ma Lisaniya tupwa Abiline ꞌana toloina. ");
INSERT INTO bdd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma Anasa ma Kaiyapa taudi topwaoliyao ꞌadi toloinao. Tutaina nage ꞌoina Yehoba ꞌina gwae ꞌinaoma Sakaliya natuna Yoni ꞌoina, tauna tupwa yoho ꞌawawa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nage ꞌoina Yoni ꞌitoholowa, ma Yolidani tupwainao ꞌoidiya ꞌitauya, ma tomota ꞌoidiya ꞌiguguya, ꞌigwaeya, “Cimi paihowa galadi waguipailedi ma yaꞌabihe babitaisogemi ta ꞌoinega Yehoba ꞌimi puiyao ꞌida nuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gide Buki Heꞌasisi ꞌoina palopita Aiseya ꞌihepwaila nugeta, ꞌigwaeya, “Tohalewasa ꞌaigeda yoho ꞌawawa ꞌenana madounega ꞌihehepwaila latu, ma ꞌigwaeya, ‘Bada ꞌina ꞌeda wahuna, ma waꞌabihedumwalu. ");
INSERT INTO bdd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Loꞌoyaꞌoya mabwaiyadi waꞌeliyahuledi ma sidumwalu, ma saꞌasaꞌala mabwaiyadi wasamudi. Ma wete ꞌeda pwayopwayoꞌedi waꞌabihe dumwaludi ma ꞌeda daꞌudaꞌulena wahesapusapudi. ");
INSERT INTO bdd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma ꞌoinega tomota mabwaiyadi Yehoba ꞌina ꞌabihetena siꞌita.’” ");
INSERT INTO bdd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Coinega tomota mabwaiyadi sinaowa Yoni ꞌoina ma ꞌabehega ꞌiꞌabihe babitaisowedi, ma Yoniina ꞌihegwaediya, ꞌigwae, “Toꞌabo ꞌomi, gide mwata! Ma wanuwatuhuya ꞌabehega nata Yehoba ꞌina gamwasowala ꞌoinega wadena, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Coinega ꞌilobwainegomiya ma ꞌimi nuwabui moisa waheꞌitae ꞌimi paihowa bwebweꞌadi ꞌoidiyega. Ma sahena wagwaegwae ꞌabehega ꞌomi Ebalahamo tubunao ꞌoinega Yehoba ꞌiꞌatemuya muyaegomiya. Geya hene! Ma waꞌita Yehoba sowasowahina ma daꞌule bewa ꞌoidiyega Ebalahamo tubunao ꞌihemasalahadi. ");
INSERT INTO bdd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ma ꞌeguma mumugami geya bwebweꞌadi ꞌabwa Yehoba ꞌibwaꞌomategomi gide ꞌaiwe, ꞌeguma geya huwaina bwebweꞌana, loheloheya sigoha yahule, ma ꞌaiwe ꞌalaꞌalata ꞌoina siuledi, ma sigabudi.” ");
INSERT INTO bdd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Coinega bodaedi Yoni sihesilaleya, sigwae, “Toꞌaha ꞌilobwainemaiya ma ꞌapaihowa?” ");
INSERT INTO bdd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma Yoniina ꞌigwaeya, “Ceguma taiyawedi ꞌomi ꞌami ꞌaleꞌo ꞌeluwa ma ꞌiyamiyao geya ꞌadi ꞌaleꞌomo, ꞌaigeda waꞌebwaedi. Ma wete gide ꞌeguma ꞌami madouna, tupwana togomaleyao ꞌoidiya waheguyaiye.” ");
INSERT INTO bdd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma tupwana wete takesi ꞌana toꞌewao sinaoma ꞌidi babitaiso weyahina, ma Yoni ꞌoina sihesilala, sigwaeya, “Toheꞌita, tauma togidega ꞌama loina.” ");
INSERT INTO bdd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Coinega Yoni ꞌigwaeya, “Takesi ꞌana loinega waꞌewaꞌewa, ma hesi sahena walolohepoi.” ");
INSERT INTO bdd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma tupwadi wete toloꞌalehao sihesilala, sigwaeya, “Ma tauma, togidega ꞌama loina?” Ta Yoni ꞌigwaeya, “Comi ꞌami maisao sowasowahimi ma hesi weyahidi wayaliyaya, ma sahena ꞌami maisa ꞌana lohepoi ꞌabowega ma ꞌabihematautega waꞌewaꞌewa tomota ꞌoidiyega.” ");
INSERT INTO bdd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ma hesi tomota mabwaiyadi maꞌidi hemisa siyamwayamwa Toꞌabihetenaina Keliso ꞌina latuma weyahina, ma Yoni siꞌiteya ma mabwaiyadi sihenuwanaluwa ma sigwaeya, “Nuwana tauna Toꞌabihetenaina, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Coinega Yoni ꞌigwae latuwa ꞌoidiya, ꞌigwaeya, “Taugu weꞌahega tuwa yaꞌabihe babitaisogemi, ma hesi ꞌaigeda loheya muliguwega ꞌinaonaoma ma Yaluyaluwa Tabuna ꞌoinega, gide ꞌaiwe ninininimaina, ꞌoinega ꞌiꞌabihe babitaisogemi. Tauna ꞌihemadou sinegauwa, ꞌoinega geya ꞌilobwainegau ma ꞌana butu yalihasi. ");
INSERT INTO bdd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma loheyaina ꞌina hinawega nata witi ꞌitutu ma huwaina sigubala, ma muliyetega huwaina bwebweꞌana ꞌihedodo ꞌina hada ꞌeꞌahaiya, ma mohomohonaowedi ꞌaiwe ꞌalaꞌalata hataya ꞌoina ꞌigabudi.” ");
INSERT INTO bdd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma guguya wete baibaiwana ꞌoidiyega tetela bwebweꞌana Yoni ꞌiguguyaeya tomota ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ma wete Yoniina toloina sanina Helodi ꞌiꞌahwa galagalaeya, ꞌigwaeya, “Helodi ꞌupuiya. Helodiyasa tauna tasiu mwanena, ma ꞌuhaiya.” Ma tupwana wete Helodi ꞌino puiyao tauna Helodiina ꞌoina ꞌihepwailediya. ");
INSERT INTO bdd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Coinega Helodi ꞌigamwasowala, ta Yoni deliya ꞌilagu luhuweya. Nage ꞌoinega Helodiina ꞌina pui ꞌihemadou bwaibwaina. ");
INSERT INTO bdd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma Yoni boda mabwaiyadi ꞌiꞌabihe babitaisowediya, ma muliyetega Yesu wete ꞌiꞌabihe babitaisoweya, ma ꞌoinega Yesu Yehoba ꞌoina ꞌiꞌahwanoiya, ma galewa ꞌiꞌesoꞌeya, ");
INSERT INTO bdd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Yaluyaluwa Tabuna, mawahina ꞌana ꞌita gide gabubu, ꞌisuluma Yesu ꞌoina. Coinega ꞌaigeda ꞌenana galewega ꞌigwaema, ꞌigwae, “Cowa natugu moisa, weyahiu yayaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma tutaina Yesu ꞌana bolime gide teti ꞌilobeya, ꞌina paihowa tomota ꞌoidiya ꞌihegaineya. Ma tomota sinuwatuhuya ꞌabehega Tauna tamana Yosepa. Ta Yosepaina tamana Heli, ");
INSERT INTO bdd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ma Heli tamana Madati, ma Madati tamana Libai, ma Libai tamana Meliki, ma Meliki tamana Yanai, ma Yanai tamana Yosepa, ");
INSERT INTO bdd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ma Yosepa tamana Matadaya, ma Matadaya tamana Emosi, ma Emosi tamana Neumi, ma Neumi tamana Esili, ma Esili tamana Nagai, ");
INSERT INTO bdd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ma Nagai tamana Mahati, ma Mahati tamana Matadaya, ma Matadaya tamana Semini, ma Semini tamana Yoseki, ma Yoseki tamana Yoda, ");
INSERT INTO bdd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ma Yoda tamana Yoanani, ma Yoanani tamana Lisa, ma Lisa tamana Selubabela, ma Selubabela tamana Siyelitiyeli, ma Salatieli tamana Nili, ");
INSERT INTO bdd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ma Nili tamana Meliki, ma Meliki tamana Adi, ma Adi tamana Kosami, ma Kosami tamana Elimadami, ma Elimadami tamana Eli, ");
INSERT INTO bdd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ma Eli tamana Yosuwa, ma Yosuwa tamana Eliyesa, ma Eliyesa tamana Yolima, ma Yolima tamana Madati, ma Madati tamana Libai, ");
INSERT INTO bdd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ma Libai tamana Simioni, ma Simioni tamana Yuda, ma Yuda tamana Yosepa, ma Yosepa tamana Yonami, ma Yonami tamana Ilayakimi, ");
INSERT INTO bdd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ma Ilayakimi tamana Meliya, ma Meliya tamana Mena, ma Mena tamana Matata, ma Matata tamana Nadani, ma Nadani tamana Debida, ");
INSERT INTO bdd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ma Debida tamana Yese, ma Yese tamana Obedi, ma Obedi tamana Boasa, ma Boasa tamana Salimoni, ma Salimoni tamana Nasoni, ");
INSERT INTO bdd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ma Nasoni tamana Aminadaba, ma Aminadaba tamana Adamina, ma Adamina tamana Anai, ma Anai tamana Esiloni, ma Esiloni tamana Pelesi, ma Pelesi tamana Yuda, ");
INSERT INTO bdd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ma Yuda tamana Yakobo, ma Yakobo tamana Aisake, ma Aisake tamana Ebalahamo, ma Ebalahamo tamana Tela, ma Tela tamana Naoli, ");
INSERT INTO bdd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ma Naoli tamana Seluge, ma Seluge tamana Leu, ma Leu tamana Peligi, ma Peligi tamana Ibeli, ma Ibeli tamana Sila, ");
INSERT INTO bdd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ma Sila tamana Keinana, ma Keinana tamana Apakisadi, ma Apakisadi tamana Semi, ma Semi tamana Nowa, ma Nowa tamana Lemeki, ");
INSERT INTO bdd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ma Lemeki tamana Metusela, ma Metusela tamana Inoke, ma Inoke tamana Yeledi, ma Yeledi tamana Malaleli, ma Malaleli tamana Keinana, ");
INSERT INTO bdd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ma Keinana tamana Inosi, ma Inosi tamana Seti, ma Seti tamana Adama, ma Adama tamana Yehoba. ");
INSERT INTO bdd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Coinega Yaluyaluwa Tabuna Yesu ꞌilohemaheya, ma Yolidaniyega Yesu ꞌitoeya ma ꞌitauyeya tupwa yoho ꞌawawa. ");
INSERT INTO bdd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sabwelo poti ꞌoidiya Seitani ꞌitoho waiwai ma ꞌabehega Yesu ꞌiꞌabihebeꞌu, ma sabwelowedi ꞌoidiya Yesu geya ꞌiꞌai tohona, ma ꞌoinega ꞌigomaleya madouna. ");
INSERT INTO bdd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Seitaniina Yesu ꞌihegwaeya, ꞌigwae, “Ceguma ꞌowa Yehoba Natuna, daꞌule bewa ꞌuloinaedi ma siheꞌeꞌahai.” ");
INSERT INTO bdd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Yesu ꞌigwaeya, “Buki Heꞌasisi ꞌalona loina ꞌimiyamiya ꞌabehega ‘Tomota yawasidi geya ꞌeꞌahaimo ꞌoinega sida lobeya.’” ");
INSERT INTO bdd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Coinega Seitani Yesu ꞌitoe haneheya ma baleꞌu ꞌina ꞌebeloinao mabwaiyana ꞌiheꞌiteya tutaina nage ꞌoina, ma ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Bewa ꞌebeloina wasawasaedi mabwaiyadi yaꞌebwaego, ꞌeguma ꞌoiguwa ꞌuꞌetuluha. Weyahina mabwaiyanaina tuwa ꞌigu ꞌebeloina. Ma ꞌeguma taiya ꞌoina nuwanuwagu ma yaꞌebwae, tuwa yaꞌebwae.” ");
INSERT INTO bdd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesu ꞌigwaeya, “Buki Heꞌasisi ꞌalona loina ꞌimiyamiya, ꞌigwae, ‘Cino Bada Yehobamo ꞌoina ꞌuꞌetuluha ma ꞌiboimo ꞌenana ꞌuhematamatanedi.’” ");
INSERT INTO bdd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Coinega Seitani Yesu ꞌitoe hileya ma ꞌitauyeya Yelusalema ma Hada Heꞌasisi tabwa sehenina ꞌihaneheya ma ꞌoina ꞌihegwaeya, ꞌigwae, “Ceguma ꞌowa Yehoba Natuna, bewa ꞌoinega ꞌuulataheya ma gesowana ꞌusilasilahe, ");
INSERT INTO bdd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","weyahina Buki Heꞌasisi ꞌihepwaila pwaiya, ꞌigwae, ‘Yehoba ꞌina aneloseyao ꞌiloinaedi ma siꞌitayahigo.’ ");
INSERT INTO bdd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma ꞌaigeda ꞌina hepwaila ꞌigwaeya, ‘Cino aneloseyao siꞌahaligo ma ꞌoinega gesowana ꞌaheu sisilasilae daꞌule ꞌoidiya.’” ");
INSERT INTO bdd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yesu gwaeina ꞌihemaiseya ꞌigwae, “Caigeda wete gwae Buki Heꞌasisi ꞌoina ꞌimiyamiya, ꞌigwaeya, ‘Sahena ꞌino Bada Yehoba ꞌutohotoho.’” ");
INSERT INTO bdd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ma ꞌoinega Seitani ꞌina tohona mabwaiyana Yesu ꞌoina ꞌilosalohiya, ta ꞌiꞌebesineya, ma hali tuta ꞌoina ꞌida hilama. ");
INSERT INTO bdd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eeta Yesu Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌihila Galili. Ma nage ꞌoina tetelina ꞌilelewana Galili tupwainao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","weyahina meGaliliyedi ꞌidi hada tapwalolo ꞌoidiya ꞌiloguloguguya, ma ꞌoinega mabwaiyadi siꞌahwa bwebweꞌaneya. ");
INSERT INTO bdd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ma muliyetega Yesu ꞌinaoma Nasaleta ꞌoina, tauna nage ꞌina gogo moisa. Ma Sabati ꞌoina Yesu ꞌiluhuwa hada tapwalolowa, mumugana gidemusa. Coinega ꞌitoholowa ma Buki Heꞌasisi ꞌihasili, ");
INSERT INTO bdd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ꞌoinega palopita Aiseya ꞌina lele siꞌebwaeya, ta ꞌiyahaliya ma hasilaina ꞌilobeya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bada Yaluyaluwana ꞌoiguwa ꞌimiyamiya. Tauna ꞌihesinuwegauwa ma towewelohe ꞌoidiya tetela bwebweꞌana yaguguyae. Ma paipaidi wete ꞌoidiya ꞌihesumanegauwa ma ꞌadi lihasa weyahina yahepwaila. Ma tomata gibugibu wete matadi ꞌidi ꞌasilala hila weyahina yahepwaila. Ma wete ꞌihesumanegauwa ma tomiya mwau ꞌadi ꞌalehao nimadiyega yaꞌetolihasidi. ");
INSERT INTO bdd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma yahepwaila wete bolimeina ꞌabwa Bada ꞌiꞌabihetegomi.” ");
INSERT INTO bdd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ma Yesu leleyedi ꞌihasili pwaidiya ta ꞌinupilidiya, ꞌoinega buki ꞌana toꞌitayahina ꞌiꞌebwae hileya, ma ꞌimiyatoiya. Ma tohenonowedi mabwaiyadi nuwadi ꞌiꞌeweya, ꞌoinega simiyamiya ta siꞌeꞌebubu. ");
INSERT INTO bdd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Coinega ꞌihegwaediya, ꞌigwae, “Gwae bewa yahasila pwaiya ta wahesagoheya, mwalo sihepwaila nugeteya, ma bewa tutaina ꞌilatu pwaima.” ");
INSERT INTO bdd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma taudi nuwadi ꞌihenainaida moisa, ꞌoinega ꞌina gwaeyedi bwebweꞌadi weyahidi sihepwatuweya, sigwae, “Loheya bewa Yosepa natuna, ꞌawa? Ma togidega hede?” ");
INSERT INTO bdd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Coinega ꞌihegwaediya, ꞌigwae, “Hesi yasanapugomiya weyahina nata gwae hegehegediyega wahegwaegau ma wagwae, ‘Cowa toꞌabihe bwebweꞌana, ꞌoinega ꞌuboi ꞌuꞌabihe bwebweꞌanigo.’ Ma wete nata ꞌimi gwae ꞌaigeda ꞌoinega wahegwaegau ma wagwae, ‘Paihowaedi waiwaidi gogo Kapaneumi ꞌoina ꞌupaihowediya, gide wete ꞌupaihowa ꞌesedi ꞌebwa ꞌida gogo bewa ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma yahegwae bwaibwainigomi ꞌabehega geya ꞌaigeda palopita ꞌina bodao ꞌoidiyega ꞌana heꞌasisi ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ma wanuwatuhuyahi ꞌabehega mwalo palopita Ilaitiya ꞌina tuta, hiwahiwape baibaiwadi Isileli ꞌoina simiyamiya, ma Yehoba geya Isileli wahineina ꞌihesinuwe ma Ilaitiya ꞌiꞌitayahi tutaina gomale madouna, weyahina bolime ꞌetoi ma tupwana ꞌoidiya geya ꞌwesu, ");
INSERT INTO bdd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ma hesi ꞌaigeda hiwape Salepati ꞌoinega Yehoba ꞌihesinuwaneya Ilaitiya ꞌana ꞌitayahina weyahina, beno Saidoni tupwaina, ma Yehoba Ilaitiya ꞌihewasaeya hiwapeina ꞌina gogowa, ta ꞌiꞌitayahiya. ");
INSERT INTO bdd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma palopita Ilaisa wete ꞌina tuta ꞌoina tolepelo baibaiwadi Isileli ꞌoina simiyamiya, ma geya ꞌaigeda taiya ꞌoidiyega ꞌiꞌabiꞌabi hebwebweꞌane, ma hesi ꞌaigedamo gwama Siliya ꞌiꞌabihe bwebweꞌaneya sanina Nemani.” ");
INSERT INTO bdd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu ꞌina gwaeyedi bewa ꞌoidiyega taudi totapwalolowedi ꞌiꞌabihe gamwasowalidiya, ");
INSERT INTO bdd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ꞌoinega sitoholowa ma Yesu siꞌabiyahiya ma ꞌasega sitoe latuheya ma sitauyeya ꞌidi ꞌasa ꞌoyaina ꞌoina, ma ꞌoyaina debana silaguya ma ꞌabehega sihasepale dobihe ꞌadeꞌadewala. ");
INSERT INTO bdd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma tauna bodaedi ꞌihaupediya ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma muliyetega ꞌidobiya Kapaneumi ꞌoina, beno Galili tupwaina, ta nobwa Sabatiya tomota ꞌiheꞌitediya. ");
INSERT INTO bdd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma tomota mabwaiyadi nuwadi ꞌihenainaida weyahina ꞌina heꞌita mabwaiyana waiwaina. ");
INSERT INTO bdd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma hada tapwaloloina ꞌoina ꞌaigeda loheya ꞌimiyamiya, ma loheyaina ꞌoina hiꞌahiꞌa* mwalo ꞌiluhuwa ta ꞌimiyamiya, ꞌoinega loheyaina ꞌenana madounega ꞌibwauwa ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ya! Yesu ꞌowa gwama Nasaleta, toꞌaha lamuna ta ꞌunaoma ꞌoima? Nuwanuwau ꞌabehega ꞌumutumai, ꞌawa? Ma ꞌowa hesi yasanapugowa, ꞌowa tuwa Yehoba Natuna.” ");
INSERT INTO bdd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma Yesu ꞌiloinaeya ma ꞌigwae, “Culolagu, ma loheya beno ꞌoinega ꞌulatu.” Ta dumwadumwaluna boda matadiya hiꞌahiꞌaina loheya ꞌiulaeya baleꞌuwa ta ꞌoinega hiꞌahiꞌa ꞌihapwesa, ma geya ꞌaigeda hesilae loheyaina ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Coinega mabwaiyadi sisalutuwama, ma siboidimo sihesilalediya, sigwae, “Togidega hede bewa? Ma gwaemo ꞌina waiwai ꞌoinega hiꞌahiꞌa ꞌiloinaediya ta sihapwesa.” ");
INSERT INTO bdd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eeta Yesu tetelina silelewaneya Galili tupwainao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Coinega Yesu Hada tapwalolowega ꞌilatuma, ma Saimoni ꞌina hada ꞌiluhuwa. Ma Saimoni lawana wahi yahiyahi ꞌoinega ꞌilohala, ꞌoinega Yesu siꞌahwanoiyeya ma ꞌiꞌabihe bwebweꞌane. ");
INSERT INTO bdd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Coinega Yesu ꞌiluhuwa, ma ꞌina ꞌebeꞌenoina deina ꞌitoholowa, ta lohalaina ꞌiloineya ma ꞌina lohalaina ꞌisawala, ꞌoinega wahineina ꞌitoholo ta ꞌadiwa ꞌiꞌatububuya. ");
INSERT INTO bdd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma hesi sinala ꞌisopu pwaiya, ma tomota ꞌidi tolohalao ꞌadi lohalao hagadi ma hagadi sitoedima Yesu ꞌoina, ta mabwaiyadi ꞌaigeda ꞌaigeda ꞌiꞌabitohodiya ta sibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma wete tupwana baibaiwadi ꞌoidiyega hiꞌahiꞌa silatulatu ma siwuiwui, sigwaeya, “Moisa ꞌowa Yehoba Natuna!” Ma Yesu ꞌiꞌausidiya ma sahena gide sigwaegwae ꞌesa, weyahina sisanapu pwaiya ꞌabehega tauna Toꞌabihetenaina Yehoba ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma gona ꞌiꞌadale pwaiya, ta Yesu gogoina ꞌiꞌebesineya, ma ꞌiboinamo yoho ꞌawawa ꞌitauya. Ta tomota baibaiwadi sihegaina ma ꞌabehega Yesu sibese, ma tutaina silobeya sihegwaeya, sigwae, “Sahena ꞌutautauya. Cebwa tuwa tamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Coinega ꞌihegwaediya, ꞌigwae, “Tupwana wete gogo ꞌoidiya yatautau ma Yehoba ꞌina loina tetelina yaguguyae. Bewa tetelaina weyahina ma Yehoba ꞌihewasaegauma.” ");
INSERT INTO bdd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eeta ꞌilatuwa ma ꞌitauya Yudiya tupwanao mabwaiyadi ꞌoidiya, ma ꞌidi hada tapwalolo ꞌalodiya ꞌiguguya sakowasiya. ");
INSERT INTO bdd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Caigeda tuta Yesu ꞌitoholo hola Genesaleta papalina, ta boda sinaoma ma sitoholo pogiyamowa ma ꞌabehega Yehoba ꞌina gwae Yesu ꞌoinega sihesagohe. ");
INSERT INTO bdd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nage ꞌoina togomana ꞌidi waga ꞌeluwa ꞌiꞌitediya deina silisidiya dabala, ma togomanaedi siulasulu pwaiya ma ꞌidi gomanedi sibuyobuyodi. ");
INSERT INTO bdd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Coinega Yesu waga ꞌaigeda ꞌoina ꞌigeluwa, beno Saimoni ꞌina waga, ma Saimoni ꞌihegwaeya ma tupwana ꞌitaladobiya niꞌuwa, ma wagaina ꞌoina Yesu ꞌimiyatoiya ma ꞌiheꞌita boda ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma ꞌina heꞌita ꞌigumwala ta Saimoni ꞌihegwaeya, ꞌigwae, “Saimoni tupwana ꞌutaladobi niꞌuwa ma ꞌino gomana ꞌuyahuwe.” ");
INSERT INTO bdd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Saimoni ꞌigwae, “Bada, hinuwanega hene ꞌagomana masaliya ma geya ꞌaigeda wete silahana ꞌaꞌonatoho. Ma tuwa ꞌino gwae weyahina, ꞌoinega yayahuwe.” ");
INSERT INTO bdd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Siyahuweya, ma silahana baibaiwa hedada siꞌonediya, ta gomanaina ꞌabehega ꞌilotasabu. ");
INSERT INTO bdd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Coinega ꞌiyadiyao hali waga siloꞌuyowediya ta ꞌabehega sinaoma ma siꞌabihetedi. Coinega taudi ꞌidi wagega sinaoma ta waga ꞌeluwaedi silohemahediya, ta ꞌiꞌiunamo ma sidamana. ");
INSERT INTO bdd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nage ꞌoina Saimoni Pita silahana ꞌana baibaiwa ꞌiꞌitediya, ta Yesu ꞌahena ꞌiꞌetuluha, ma Pita ꞌigwaeya, “Bada, ꞌuꞌebesinegau, weyahina taugu togala.” ");
INSERT INTO bdd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gwae bewa ꞌiꞌinaneya, weyahina ꞌiyanao mahetenao nuwadi ꞌihenainaida madouna silahanaedi siꞌonediya weyahina, ");
INSERT INTO bdd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ma wete gide Saimoni ꞌiyanaowedi Yemesa ma Yoni, taudi Sebedi natunao. Coinega Yesu Pita ꞌihegwaeya, ꞌigwae, “Sahena ꞌuꞌateꞌateyoho. Ma hesi bewa ꞌoinega ma tomota gide ꞌuꞌona ꞌesedi.” ");
INSERT INTO bdd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Coinega ꞌidi wagaedi silisidiya dabala, ta ginaula mabwaiyana siꞌebesinediya ma Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma hali tuta Yesu wete ꞌaigeda ꞌasa ꞌoina ꞌimiyamiya. Tupwaina ꞌoina ꞌaigeda loheya wahina mabwaiyana lepelo ꞌiꞌeweya. Coinega loheyaina Yesu ꞌiꞌitalobeya ma ꞌibeꞌuwa ꞌahena ma ꞌiꞌahwanoiyeya, ꞌigwae, “Bada, ꞌeguma ꞌino nuwatuhu gide, sowasowahina ma ꞌuꞌabihe bwebweꞌanegau.” ");
INSERT INTO bdd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma Yesu nimanega loheya ꞌwapina ꞌiꞌabi tohoya ma ꞌigwae, “Cehe, bwebweꞌana! Cuꞌehau.” Ma loheyaina ꞌana lepelo ꞌigumwala mwayamwayauwa. ");
INSERT INTO bdd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Coinega Yesu loheyaina ꞌoina ꞌilohatoto, ꞌigwaeya, “Cutautau ma gesowana ꞌaigeda taiya wete ꞌoina ꞌuhehepwailegau, ma hesi ꞌutau topwaoli ꞌoina ma ꞌiꞌitago, ma ꞌoinega ꞌino pwaoli ꞌuꞌebwae Yehoba ꞌoina, toꞌaha gide ꞌada loina Mosese ꞌoinega, ma ꞌoinega tomota sisanapugo ꞌabehega ꞌubwebweꞌana pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma hesi nage ꞌoinega ma Yesu tetelina ꞌimadou bwaibwaina, ma boda mabwaiyadi siꞌetoꞌautama ma ꞌabehega Yesu ꞌina gwae sihesagohe, ma wete ꞌadi lohalao ꞌabehega ꞌiꞌabihe bwebweꞌanedi, ");
INSERT INTO bdd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ma hesi tuta baibaiwana boda ꞌoidiyega ꞌitautauya wasiwasi ma ꞌiꞌahwaꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sabwelo ꞌaigeda ꞌoina Yesu boda ꞌiheheꞌitadi. Ma tupwadi Palisiyao ma loina ꞌana toheꞌitao taudi sinaoma Galili ta Yudiya ta Yelusalema tupwainao ꞌoidiyega, ma boda mahetediyao simiyamiya, ma sihenono. Tuta nage ꞌoina Yehoba ꞌina waiwaiyega tolohalao ꞌiꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Coinega boda ꞌaigeda topeu mahewaina siꞌahaliyama, eeta sitohoya ma ꞌabehega siluhuwe hadai ma Yesu matana silagu. ");
INSERT INTO bdd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma geya sowasowahidi, weyahina boda madou hedada. Coinega topeuina siꞌahala haneheya hada tabwanina ma ꞌana ꞌatoha siꞌewa yahuleya, ma ꞌoinega topeuina mahewaina sihedawe daweyeya bodaedi gamwagamwanidiya, ta Yesu matana silaguya. ");
INSERT INTO bdd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma Yesu loheloheyaedi ꞌidi hemisa ꞌisanapuya, ta loheyaina ꞌihegwaeya, ꞌigwae, “Ciyagu, ꞌino puiyao ꞌadi nuwasam ꞌuloba pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma hesi loina ꞌana toheꞌitao ma Palisiyao Yesu ꞌina gwaeyedi sihesagohediya ta siboidimo ꞌoidiya sihehesilaladi, sigwaeya, “Yesu bewa togidega ta Yehoba ꞌoina ꞌihohopaꞌala? Weyahina geya ꞌaigeda taiya sowasowahina ma tomota ꞌidi puiyao ꞌinuwasamudi, beno tuwa Yehoba sowasowahina.” ");
INSERT INTO bdd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Cidi nuwatuhu Yesu ꞌisanapu pwaiya, ꞌoinega ꞌihegwaediya, “Toꞌaha weyahina ꞌatemiya beno gide wanuwatuhu ꞌesa? ");
INSERT INTO bdd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma toꞌaha wanuwatuhuya sowasowahigu yagwaene loheya bewa ꞌoina ma ꞌabehega yagwae, ‘Cino puiyao yanuwasam pwaidiya,’ bo yagwae, ‘Cutoholo ma ꞌutauya’? ");
INSERT INTO bdd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma wasanapu taugu Loheyaiguina maꞌigu loina baleꞌuwa ma tomota ꞌidi puiyao yanuwasamudi.” Coinega topeuina ꞌihegwaeya, ꞌigwae, “Taugu bewa yahegwaego, ‘Cutoholo ma ꞌino ꞌebeꞌeno ꞌuꞌahali ma ꞌutau ꞌino gogowa.’” ");
INSERT INTO bdd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma ꞌilomwayamwayauwa ma boda matadiyega ꞌitoholowa ma ꞌina ꞌebeꞌeno ꞌiꞌahaliya ma ꞌitauya ꞌina gogowa, ta maꞌina yaliyaya Yehoba ꞌihepwatuweya. ");
INSERT INTO bdd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eeta boda mabwaiyadi nuwadi ꞌihenainaida madouna, ta maꞌidi heꞌasisi Yehoba sihepwatuweya, ma sigwae, “Nige ꞌaigeda ꞌebe henainaida taꞌiteya.” ");
INSERT INTO bdd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma muliyetega Yesu ꞌilatuwa, ma ꞌaigeda takesi ꞌana toꞌewa sanina Libai ꞌiꞌiteya ꞌina hada ꞌebe paihowa ꞌoina ꞌimiyamiya, ma ꞌihegwaeya, ꞌigwae, “Libai ꞌumuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Coinega Libaiina ꞌitoholowa, ta ginaula mabwaiyana ꞌiꞌebesinediya, ma Yesu ꞌimuliyeya. ");
INSERT INTO bdd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Coinega Libai ꞌina ꞌai madouna ꞌipaihoweya Yesu weyahina, ma boda madouna sinaoma Libai ꞌina hada ꞌaiina weyahina, ma takesi ꞌana toꞌewao ma tomota baibaiwadi wete mahetediyao. ");
INSERT INTO bdd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eeta Palisiyao ta ꞌidi loina ꞌana toheꞌitao silolomugi Yesu ꞌana tomuliyao ꞌoidiya, sigwaeya, “Toꞌaha lamuna ma takesi ꞌana toꞌewao ta wete togala tupwadi mahetemiyao waꞌai hegogona?” ");
INSERT INTO bdd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Yesu ꞌidi gwaeina ꞌihemaiseya, ꞌigwae, “Taudi wahidi waiwaidi genuwadi toꞌabihe bwebweꞌana, ma tolohalao hesi. ");
INSERT INTO bdd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taugu yanaoma geya ꞌabehega tobwebweꞌadi weyahidi ma hesi topuiyao yaꞌabihetedi, ma ꞌabehega nuwabui ꞌoinega ma sibwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma muliyetega tupwadi tomota Yesu sihegwaeya, sigwae, “Yoni ꞌana tomuliyao tuta baibaiwana magomaledi siꞌahwaꞌahwanoi Yehoba ꞌoina, wete gide Palisiyao ꞌadi tomuliyao ꞌidi paihowa, ma togidega ta ꞌowa ꞌa tomuliyao geya sihudi, ma tuwa siꞌaiꞌai ma sinumanuma besobeso.” ");
INSERT INTO bdd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Coinega Yesu ꞌigwaeya, “Togidega, ꞌilobwaineya ma hai ꞌana toꞌebubuwao sihudi ꞌeguma tohai meloheyana mahetediu siyaliyaya? Geya, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma ꞌiyamo tuta ꞌinaonaoma ꞌoina ma tohaiina ꞌiꞌebesinedi, ꞌoinega hesi sinuwagala ma sihudi, ma sigomale.” ");
INSERT INTO bdd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma wete ꞌaigeda gwae hegehegedi ꞌiheꞌoteꞌoteteliya ꞌoidiya, ꞌigwaeya, “Geya sowasowahina ꞌaleꞌo ꞌehauna tupwana taꞌewa ma ꞌaleꞌo miyamiyaina tabwabwada. Geya! Ma ꞌeguma gide, hesi ꞌaleꞌo hauhauna tagihegala, ma wete hauhauna tupwatupwanaina ꞌaleꞌo miyamiyana geya ꞌilobwaine. ");
INSERT INTO bdd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta wete geya ꞌaigeda taiya weꞌaha waiwaina gidemusa waini ꞌehauna ꞌisiwa ꞌwapi ꞌebesiwa miyamiyaidi ꞌoidiya, tabu ma silotaigala ma weꞌaha ta ꞌebesiwa ꞌadi mudala. ");
INSERT INTO bdd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma hesi tasiwa ꞌwapi ꞌebesiwa ꞌehau daisinamo ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma ꞌeguma taiya waini miyamiyana ꞌinuma, nata ꞌigwae ꞌabehega genuwana hauhauna, weyahina ꞌabehega waini miyamiyana hesi bwebweꞌana hedada.” ");
INSERT INTO bdd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabati ꞌaigeda ꞌoina Yesu maꞌana tomuliyao tanoha ꞌalonega sitauya, ma ꞌana tomuliyaowedi witi huwaina siꞌabilolodiya, ma sihosodiya nimadiyega ma siꞌaidiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma tupwadi Palisiyao siꞌitediya, ta sigwaeya, “Togidega ta Sabati ꞌana loina wadiꞌwadiꞌwai?” ");
INSERT INTO bdd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Coinega Yesu Palisiyao ꞌidi gwae ꞌihemaiseya, ꞌigwae, “Buki Heꞌasisi ꞌoina sileleya Debida weyahina, ma ꞌeguma wahasili wasanapu ꞌabehega tauna maꞌiyanao sigomaleya, ");
INSERT INTO bdd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ma Yehoba ꞌina Hada ꞌoina ꞌiluhuwa, ta beledi heꞌaheꞌasisina ꞌiꞌeweya, ta siꞌaiya. Belediina maꞌana loina ꞌabehega topwaolimo ꞌadi tagwala ma siꞌai. Ma sigomaleya, ꞌoinega tuwa siꞌaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Coinega Yesu wete ꞌihegwaediya, ꞌigwae, “Sabati ꞌana toloina tuwa taugu Loheyaiguina.” ");
INSERT INTO bdd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma wete ꞌaigeda Sabati ꞌoina Yesu ꞌiluhu hada tapwalolo ꞌaigeda ꞌoina, ma ꞌiheꞌita. Hadaina ꞌoina ꞌaigeda loheya ꞌimiyamiya nima ꞌebeulanega meyomeyona. ");
INSERT INTO bdd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma wete tupwadi loina ꞌana toheꞌitao ta Palisiyao simiyamiya, ma Yesu silomata yahiya, ma ꞌeguma loheyaina ꞌiꞌabihe bwebweꞌane Sabati ꞌoina, ꞌabwa ꞌaneyage ꞌoinega siheꞌewa toloinao matadiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Yesu hesi ꞌidi nuwatuhu ꞌisanapuya, ꞌoinega loheyaina ꞌihegwaeya, ꞌigwae, “Cutoholo ma ꞌulagama.” Ma loheyaina ꞌitoholowa ta ꞌilaga. ");
INSERT INTO bdd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Coinega Yesu Palisiyao maꞌiyadiyao ꞌihegwaediya ꞌigwae, “Bewa ꞌigu hesilala ꞌoimiya: To nuwatuhu bwebweꞌana ꞌoida? Sabati ꞌoina tomota talemedi bo taloheꞌamasidi?” ");
INSERT INTO bdd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eeta mabwaiyadi ꞌiꞌebubu yahiyahidiya, ta ꞌoinega loheyaina ꞌihegwaeya, ꞌigwae, “Nimau ꞌuyasi hedumwalu.” Ta loheyaina nimana ꞌiyasi hedumwaluya, ta ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nage ꞌoina Palisiyao maꞌiyadiyao sigamwasowala bwaibwaina, ta siboidimo ꞌoidiya sigwae, “Loheya bewa togidega taꞌabihelolagu ꞌese?” ");
INSERT INTO bdd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tuta nage ꞌoina Yesu ꞌihaneya ꞌoyai, ma nobwa hinuwana mabwaiyana Yehoba ꞌoina ꞌiꞌahwaꞌahwanoi. ");
INSERT INTO bdd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Coinega gona ꞌiꞌadaleya ta ꞌana tomuliyao ꞌibwauwediya, ma ꞌoidiyega site tuwelo ꞌihesinuwediya, ma ꞌibwauwediya tohepwailao. ");
INSERT INTO bdd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tohepwailaowedi sanidi bewa: Saimoni, tauna wete ꞌihesaniyeya Pita, ma tasina Andulu, ma wete Yemesa ma Yoni ma Pilipi ma Batolomiu, ");
INSERT INTO bdd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma wete Madiu ma Tomasi ma hali Yemesa, tauna Alipiyo natuna, ma wete hali Saimoni, tauna toꞌalaꞌoheꞌohe ꞌidi miyawasi Loma weyahina, ");
INSERT INTO bdd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma wete Yudasa tauna Yemesa natuna, ma wete Yudasa Isakaliyota, tauna ꞌabwa Yesu ꞌitebae. ");
INSERT INTO bdd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ma mabwaiyadi baꞌidanao ꞌoyega sisuluma ꞌwabu ꞌoina, sitoholowa. Cwabuina ꞌoina boda madouna simiyamiya, taudi sinaoma Yudiya ta Yelusalema ꞌoidiyega, ma wete Taiya ta Saidoni tupwa holega. ");
INSERT INTO bdd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Taudi sinaoma ꞌabehega Yesu ꞌina gwae sihesagohe, ma wete ꞌabehega ꞌadi lohalao ꞌiꞌabihe bwebweꞌanedi. Ma wete taudi hiꞌahiꞌa siluhuwa ꞌoidiya, nuwanuwadi ma yaluyaluwaedi ꞌoidiyega ꞌida ulalatuhedi. ");
INSERT INTO bdd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bodaedi mabwaiyadi nuwanuwadi ma Yesu siꞌabitoho ma ꞌoinega ꞌadi lohalao sigumwala, weyahina siꞌiteya Yesu ꞌoina waiwai ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Coinega Yesu ꞌana tomuliyaowedi ꞌiꞌebubudiya ta ꞌihegwaediya, ꞌigwae: Ceguma ꞌomi wewelohemi, wayaliyaya weyahina Yehoba nimana wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ma ꞌomi ꞌeguma wagomale wayaliyaya, weyahina ꞌabwa wamwausu. Ma wete ꞌeguma ꞌomi wadou, wayaliyaya weyahina ꞌabwa wahenama. ");
INSERT INTO bdd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Taugu Loheyaiguina, ma sowasowana wayaliyaya ꞌeguma weyahigu tomota siloloꞌalehegomi, nuwana siguipailegomi, nuwana siꞌahwa yaliyegomi, nuwana siꞌahwa galegalegomi. ");
INSERT INTO bdd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tuta nage ꞌoidiya ꞌeguma mwauwedi silatu, weyahidi wayaliyaya, ma watoholo ma wasobu, weyahina ꞌami maisa bwebweꞌana galewa ꞌimiyamiya. Ta wanuwatuhuyahi ꞌabehega toꞌahwa galagalaedi tubudiyao mwalo palopitao siꞌahwa galegalediya, gide wete ꞌomi tuta bewa ꞌoina siꞌahwaꞌahwa galegalegomi. ");
INSERT INTO bdd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma ꞌeguma hesi ꞌomi wahewasawasa nuwaꞌoleꞌoleimi, weyahina ꞌimi wasawasa waloba pwaiya, ma ꞌabwa geya. ");
INSERT INTO bdd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ma taiyawedi ꞌomi bewa tuwa wamwausuwa, ꞌabwa wanuwagala weyahina ꞌiꞌiuna gomale madouna waloba. Ma wete ꞌeguma bewa tuwa wahehenama, ꞌabwa maꞌimi nuwagala wadou. ");
INSERT INTO bdd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ma tutaedi ꞌoidiya ꞌeguma tomota baibaiwadi siꞌahwa bwebweꞌanegomi, wanuwahila ma wanuwagala, weyahina mwalo taudi tubudiyao wete gidemusa palopita ꞌaboꞌabo siꞌahwa bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ma ꞌigu heꞌita bewa wahesagohe, ma ꞌami ꞌalehao wahelauwedi, ta taudi siguipailegomiya waꞌabihetedi, ");
INSERT INTO bdd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ma wete taudi siꞌahwaꞌahwa galegalegomi waꞌahwa bwebweꞌanedi, ma taudi siloloꞌalehegomi weyahidi waꞌahwaꞌahwanoi ma Yehoba ꞌiꞌabihetedi. ");
INSERT INTO bdd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma ꞌeguma taiya ꞌaseꞌaseu ꞌisapi, sahena ꞌuhehenima hile, ma hesi hali ꞌaseꞌaseu wete ꞌutagwale ma ꞌisapi. Ma ꞌeguma taiya ꞌino sita ꞌiꞌeweya, ꞌa ꞌaleꞌo wete ꞌutagwale ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma wete ꞌeguma taiya ꞌoiuwa ꞌiꞌahwanoi ginaula ꞌaigeda weyahina, ginaulaina ꞌuꞌebwae. Ma ꞌeguma taiya ꞌino tobwatobwa ꞌiꞌeweya ma ꞌoina ꞌimiyamiya, sahena weyahina ꞌugwaegwae hilahila. ");
INSERT INTO bdd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma ꞌeguma toꞌaha nuwanuwami ma tomota ꞌoimiya sipaihowe, ꞌomi wete gide ꞌoidiya wapaihowa ꞌese. ");
INSERT INTO bdd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ma ꞌeguma tomota tupwadi sihelauwegomi ma siboidimo wahelauwedi, geya ꞌana bwebweꞌanamo ꞌoimiya, weyahina togala wete ꞌiyadiyao sihehelauwedi, ꞌoinega taudi ma ꞌomi tuwa mumugami mahemahetena. ");
INSERT INTO bdd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma wete gide ꞌeguma tupwana tomota siꞌabihetegomi ma siboidimo waꞌabihetedi, geya ꞌaigeda wete ꞌana bwebweꞌana ꞌoimiya, weyahina togala wete ꞌiyadiyao siꞌabihetedi. Ma mumugadi tuwa gide wete ꞌomi mumugami. ");
INSERT INTO bdd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma ꞌeguma helau waꞌebwaya taboidimo wanuwatuhuya ma ꞌabehega ꞌoimiya sihemaisa hile, toꞌaha paihowaina ꞌana bwebweꞌana ꞌoimiya? Paihowaina gide togala sipaipaihowadi ꞌiyadiyao ꞌoidiya, ma ꞌabehega ꞌidi ꞌebwayaina maisana siloba hila. ");
INSERT INTO bdd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma ꞌomi hesi ꞌami ꞌalehao wahamwadi, ma wahelauwedi, ta waꞌebwaya ꞌoidiya, ma sahena hemaisa weyahina wayamwayamwa. Ma ꞌabwa ꞌami maisa madouna waloba, ma ꞌoinega ꞌomi Tomiya tabwana hedada natunao. Weyahina tauna tohopaꞌalao ma togalao ꞌihehelauwedi. ");
INSERT INTO bdd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Coinega ꞌomi wete tuwa wahelau, gide Tamamiu ꞌihehelau ꞌesegomi. ");
INSERT INTO bdd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma sahena tomota waꞌahwaꞌahwa galegaledi, tabu ma Yehoba wete ꞌiꞌahwa galegalegomi. Ma wete sahena ꞌiyamiyao waheꞌewadi, ma ꞌoinega ꞌomi sahena heꞌewa walobaloba. Ma hesi ꞌiyamiyao mumugadi wanuwasamudi, ma ꞌoinega Yehoba wete mumugami ꞌinuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma wete maꞌimi nuwatagwala tomota wahelauwedi, ma ꞌoinega Yehoba ꞌihelauwegomi, ma ꞌina helauina madou hedada ꞌoimiya ꞌilosiwa. Weyahina toꞌaha ꞌimi paihowa tomota ꞌoidiya, Yehoba wete gide ꞌipaipaihowa ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Coinega gwae hegehegedi bewa ꞌiꞌebwaediya, ꞌigwae, “Togidega? Sowasowahina ma ꞌaigeda tomatagibugibu ꞌiyana matagibugibuina ꞌihanugete? Gesowana ꞌawa? Ceguma gide ꞌipaihowa ꞌese, nata siteluwaedi gaula ꞌoina sibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wete gide ꞌeguma ꞌaigeda tomuliya, geya sowasowahina ma ꞌina toheꞌita ꞌisanapu sine. Ma hesi ꞌeguma ꞌina sanapu ꞌimadou, beno siteluwaedi ꞌidi sanapu mahemahetena. ");
INSERT INTO bdd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Geya ꞌilobwainego ma haletau weyahina ꞌugwae ꞌeguma matana ꞌaiwe tupwatupwana ꞌimiyamiya, weyahina ꞌowa wete matauwa ꞌetupwa ꞌimiyamiya, ma geya ꞌuꞌita. ");
INSERT INTO bdd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Coinega sahena haletau ꞌuhehegwae ma ꞌugwae, ‘Haletagu, ꞌilobwainegau ma ꞌaiwe tupwatupwana matauwega yaꞌewayahule,’ weyahina ꞌowa wete ꞌetupwa madouna matauwa ꞌimiyamiya geya ꞌuꞌita. Moisa ꞌowa ꞌaigeda toꞌabo, ꞌawa? Ma hesi ꞌetupwa matauwa ꞌuꞌewayahule nugeta, ma ꞌoinega ꞌuꞌebubuna bwaibwaina, ma muliyetega haletau matanega ꞌaiwe tupwatupwana ꞌuꞌewayahule. ");
INSERT INTO bdd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Caiwe bwebweꞌana geya sowasowahina ma huwaina galana ꞌihuwae. Gide wete ꞌaiwe galana geya sowasowahina ma huwaina bwebweꞌana ꞌihuwae. ");
INSERT INTO bdd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Coinega ꞌaiwe ꞌaigeda ꞌaigeda huwaidi ꞌoidiyega tasanasanapudi ꞌabehega ꞌaiweyedi bwebweꞌadi bo galadi. Geya sowasowahina ma talitali ꞌoidiyega damaya huwaina taloba. Wete gide geya sowasowahina ma buyubuyuwa ꞌoinega piyoi huwaina taloba. ");
INSERT INTO bdd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gide loheya mumugana, ꞌeguma loheya ꞌina nuwatuhu ꞌausalana mumugana mabwaiyana bwebweꞌana. Ma ꞌeguma loheyaina ꞌina nuwatuhu galadi mumugana mabwaiyana galadi. Weyahina nuwatuhuwedi toꞌaha gide ꞌatemiya simiyamiya sauga baibaiwana ꞌahwamiyega silatulatu. ");
INSERT INTO bdd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ma toꞌaha weyahina waꞌahwaꞌahwa badaegau, ma ꞌigu gwae geya wahematamatanedi. ");
INSERT INTO bdd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma ꞌeguma taiya ꞌowa ꞌunaoma ꞌoiguwa ma ꞌigu gwae ꞌuhesagohedi ma ꞌupaihowadi, ꞌowa mumugau gide ꞌaigeda tohadaꞌabi yaheꞌitae ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ma tohadaꞌabiina nugeta ꞌina wahuwahu paꞌalina ꞌilobeya, daꞌudaꞌule ꞌoina, ma ꞌina hada ꞌoina ꞌiꞌabiya, ꞌoinega tutaina ꞌwesu madouna ꞌisuluwa ta ꞌabaita ꞌidauwa. Ta ꞌina dau ꞌoinega hadaina ꞌihunuya madouna, ma geya ꞌiꞌabihegala, weyahina wahuwahu bwebweꞌana ꞌoina ꞌiꞌabiya. ");
INSERT INTO bdd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma hesi ꞌeguma taiya ꞌowa ꞌigu gwae ꞌuhesagoheyamo ma geya ꞌuhematamatane, ꞌowa tuwa gide tohadaꞌabi negwanegwala daisina ꞌoina ꞌiꞌabiya. Ma tutaina ꞌabaita ꞌilatuwa hadaina ꞌihunuya, ta ꞌibuineya ma ꞌiligeha yahuleya.” ");
INSERT INTO bdd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ma Yesu ꞌina gwae tomota ꞌoidiya ꞌigumwala, ma ꞌilatuwa ꞌitauya Kapaneumi ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gogoina ꞌoina toloꞌalehao taudi meLoma ꞌadi tohanugeta ꞌaigeda maꞌina hewali simiyamiya. Ma ꞌina hewaliina ꞌihelau bwaibwaineya, ma tuta nage ꞌoina ꞌilohala madouna, ma ꞌiꞌiuna ma ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma toloinaina Yesu ꞌina naoma wasana ꞌihesagoheya, ta meYudiya ꞌidi babadao tupwadi ꞌihetunediya Yesu ꞌoina siꞌahwanoi ma ꞌabehega Yesu ꞌinaoma ma ꞌina hewaliina ꞌiꞌabihe bwebweꞌane. ");
INSERT INTO bdd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ma babadaowedi sinaoma Yesu ꞌoina ma siꞌahwanoiya, sigwae, “Bada, nuwanuwama ꞌunaoma ma tatauya, ma ꞌiyamai ꞌina hewali ꞌaigeda ꞌilohala ꞌuꞌabihe bwebweꞌane, weyahina tauna loheya bwebweꞌana, ");
INSERT INTO bdd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ma mabwaiyada meYudiya ꞌihelauwegita, ta ꞌida hada tapwalolo ꞌiꞌabiya.” ");
INSERT INTO bdd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Coinega Yesu ꞌitagwala ta baꞌidadiu sitauya. Sitautauya ta tupwaina deina sihapwesa, ta toloinaina ꞌiyanao tupwadi wete ꞌihewasediya Yesu sabi ꞌausina. Ta sinaoma Yesu ꞌoina, ta sigwaeya, “Bada ꞌima tohanugetaina ꞌigwaeya ꞌabehega ꞌowa loheya madouna, geya ꞌilobwainego ma ꞌuluhu ꞌina hada. ");
INSERT INTO bdd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma wete geya ꞌilobwainego ma tauna maheteu ꞌedai wahelobaloba. Ma hesi nuwanuwana ꞌabehega ꞌugwaemo ma ꞌoinega ꞌina hewaliina ꞌibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma ꞌenana bewa gide ꞌigwaeya, ‘Taugu loina yasanasanapu ta ꞌagu toloinao ꞌidi gwae ꞌana tohematamatana, ma wete ꞌigu toloꞌalehao yaloiloinaedi, ta ꞌeguma ꞌaigeda yahegwae, “Cutauya,” tuwa ꞌitauya; ma ꞌeguma ꞌaigeda wete ꞌoina yagwae, “Cunaoma,” wete ꞌinaoma, ma ꞌeguma ꞌigu topaihowa ꞌaigeda yahegwae ma yagwae, “Bewa ꞌupaihowa,” tuwa ꞌipaihowa.’” ");
INSERT INTO bdd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bewa gwaeyedi Yesu ꞌihesagohediya ta ꞌiyaliyaya, ma ꞌitoholo lohihila ta bodaedi sihehemuli tabubu ꞌihegwaediya, ꞌigwae, “Moisa, yahegwaegomi geya ꞌaigeda taiya wete yalobaloba meIsileli ꞌoimiyega ꞌina hemisa loheya bewa gide.” ");
INSERT INTO bdd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Coinega tohewasaedi sihila toloinaina ꞌina hada ma nobwa hewaliina silobeya, ꞌibwebweꞌana pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma geya tuta dudulena mulina Yesu ꞌinaowa ꞌaigeda ꞌasa ꞌoina, sanina Neini. Ta ꞌana tomuliyao ma wete boda madouna siꞌwayabuya. ");
INSERT INTO bdd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cinaoma ꞌasaina deina, ta toꞌamasa ma ꞌana toꞌahalao ꞌilobediya silatulatuma ꞌasaina ꞌoinega. Toꞌamasaina hiwape natuna, ꞌaigeda tuwa. Coinega hiwapeina boda madouna mahetenao sitautauya sabi lagutaona. ");
INSERT INTO bdd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta Yesu hiwapeina ꞌiꞌiteya, ma ꞌiꞌate muyamuyaeya, ma ꞌihegwaeya, “Sahena ꞌudoudou.” ");
INSERT INTO bdd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Coinega ꞌinaowa ma toꞌamasina ꞌana wadu ꞌiꞌabitohoya, ma toꞌahalaedi sitoholo henonowa. Ma Yesu ꞌigwaeya, “Hewali, yahegwaego ꞌutoholo.” ");
INSERT INTO bdd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma hewaliina ꞌitoholowa ta ꞌigwaeya. Coinega Yesu hewaliina ꞌitoeya ta sinana ꞌiꞌebwaeya. ");
INSERT INTO bdd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nage ꞌoina tomotaiyao simatauta ma Yehoba sihepwatuweya, sigwae, “Palopita madouna bewa ꞌilatu pwaima. Bewa Yehoba ꞌina haboꞌena tauda ꞌina tomotaiyao ꞌoida.” ");
INSERT INTO bdd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eeta Yesu tetelina sihewasa dadaneya Yudiya mabwaiyana, ma wete gogowedi deina mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ma muliyetega Yoni ꞌana tomuliyao wasa bewa sihepwaileya Yoniina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Coinega ꞌana tomuliyao ꞌeluwa ꞌibwauwediya ma ꞌihegwaediya, ꞌigwae, “Watauya ma badaina wahesilale, nuwana tauna Toꞌabihetenaina weyahina mwalo yagwaegwaeya, bo hali loheya wete tayamwa?” ");
INSERT INTO bdd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma sitauyama Yesu ꞌoina ma sihegwaeya, sigwae, “Yoni toꞌabihebabitaiso ꞌihewasemaiya ta ꞌanaoma sabi hesilalago, nuwana ꞌowa Toꞌabihetenaina, bo hali loheya wete ꞌayamwa?” ");
INSERT INTO bdd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tuta nage ꞌoina Yesu ꞌabwa tuwa tolohalao ꞌadi lohalao ta ꞌadi muyao ma hiꞌahiꞌa ꞌoidiya ꞌiꞌabiꞌabi hebwebweꞌana, ma wete tomata gibugibu matadi ꞌiꞌabihe ꞌasilalediya. ");
INSERT INTO bdd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma muliyetega siteluwaedi ꞌidi hesilala Yesu ꞌihemaiseya, ꞌigwae, “Wahila ma Yoni ꞌoina waheꞌoteꞌotetela ginaulaedi ꞌoiguwega wahesagoha pwaidiya ma waꞌitediya, beno tomata gibugibu matadi sitayahala, tohaꞌauꞌau sibwebweꞌana pwaiya ta siyawayawala, tolepelo wahidi sibwebweꞌana hila, totenatui gwae sihesagoha pwaidiya, toꞌamasa sitoholo hila, ma wete wewelohedi tetela bwebweꞌana sihesagoha pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Coinega watauya ma Yoni wahegwae ma sahena weyahigu ꞌihehenuwanaluwa, weyahina ꞌeguma taiya ꞌina hemisa weyahigu sahena ꞌiweꞌaweꞌa tauna ꞌida yaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoni ꞌana tomuliyao sihila, ma Yesu ꞌihegaina ma boda ꞌoidiya Yoni weyahina ꞌihepwaila ꞌigwaeya, “Mwalo mabwaiyami tupwa yoho ꞌawawa watauya Yoni sabi hesagohina, ma toꞌaha nuwanuwami ma ꞌabehega waꞌita? Nuwana ꞌabehega ꞌaigeda pwatula madouna yaumai ꞌinihunihuwe wada ꞌita, wa? ");
INSERT INTO bdd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nuwana ꞌaigeda loheya ma ꞌana ꞌaleꞌo wasawasa sabi ꞌitaina? Geya! Weyahina taudi maꞌadi ꞌaleꞌo wasawasa toloina madouna ꞌidi tupwa simiyamiya maꞌidi yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma toꞌaha hede weyahina ta watauya tupwa yoho ꞌawawa? Nuwana wanuwatuhuya ꞌabehega nata palopita ꞌaigeda waꞌita, wa? Moisa tuwa, loheya waꞌiteya palopitao ꞌihemadou sinediya. ");
INSERT INTO bdd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yoniina weyahina mwalo Yehoba ꞌina gwae Buki Heꞌasisi ꞌoina bewa gide ꞌihepwaila nugeteya ꞌigwae, ‘Bewa ꞌigu tohewasa yahewasaeyawa matauwa ꞌitauya, ma ꞌino ꞌeda ꞌihuna.’” ");
INSERT INTO bdd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Coinega Yesu wete ꞌigwae, “Yoni tauna mebaleꞌu mabwaiyadi ꞌihemadou sinediya, ta mabwaiyadi taudi Yehoba ꞌina ꞌebeloina ꞌalona Yoni sihemadou sineya.” ");
INSERT INTO bdd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Coinega bodaedi ma wete takesi ꞌana toꞌewao Yesu ꞌina gwaeyedi sihesagohediya, ta Yehoba sihepwatuweya, weyahina taudi mwalo Yoni ꞌiꞌabihe babitaisowediya. ");
INSERT INTO bdd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma hesi Palisiyao ma loina ꞌana tosanapuwao Yehoba ꞌina nuwatuhu sabi ꞌabihetedi siguipaileya, ꞌoinega genuwadi ma Yoni ꞌiꞌabihe babitaisodi. ");
INSERT INTO bdd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Coinega Yesu ꞌigwaeya, “Comi mehau togidega hede yagwae ꞌesaꞌesa mumugami weyahina? ");
INSERT INTO bdd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nuwana yagwae, ꞌomi gide tuwa gwagwama ꞌebe maketi ꞌalona siꞌeꞌeheyaheyale ta ꞌiyadiyao ꞌoidiya sibwaubwau, sigwaegwae, ‘Ciyamayao, togidega ꞌiya ta ꞌalahulahusa ma geya wada sobuwa, ma wete ꞌadou gwaegwae ma geya wada douwa.’ ");
INSERT INTO bdd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cedaꞌedaedi bewa ꞌana sanapu ꞌabehega Yoni toꞌabihe babitaisoina ꞌinaoma ma beledi sahena ꞌiꞌaiꞌai ma waini geya ꞌida numeya, ma ꞌoinega wagwae ꞌabehega hiꞌahiꞌa Yoni ꞌiꞌabihe yauyauleya? ");
INSERT INTO bdd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma hesi taugu Loheyaiguina yanaoma ta yaꞌaiꞌai, yanumanuma, ma wete weyahigu walolomugi, wagwaegwae, ‘Loheya bewa toꞌai ma tonuma hedahedada, ma wete takesi ꞌana toꞌewao ta tupwadi wete topui ꞌiheꞌiyaꞌiyaguwediya.’ ");
INSERT INTO bdd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma taudi tosanapu moisa ꞌabwa ꞌidi paihowa bwebweꞌadi ꞌoidiyega sanapu moisa ꞌilatulatu.” ");
INSERT INTO bdd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Caigeda tuta Palisi ꞌaigeda sanina Saimoni, Yesu ꞌibwauweya ma mahetena siꞌaiꞌai. Coinega Yesu ꞌiluhuwa Palisiina ꞌina hada ta ꞌimiyatoiya sabi ꞌai. ");
INSERT INTO bdd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma gogo nage ꞌoina ꞌaigeda wahine galana ꞌimiyamiya. Wahineina ꞌisanapuya ꞌabehega Palisi ꞌina hada Yesu ꞌiꞌaiꞌai. Coinega holowa bwebweꞌana ma ꞌana botolo ꞌausala hedadena ꞌiꞌeweyama, ");
INSERT INTO bdd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesu deina ꞌitoholowa ma ꞌidoudou, ma mataneunega Yesu ꞌahena ꞌihebuteya, ta debanega ꞌisaudiya, weyahina wahineina debana dudulena, ma wete Yesu ꞌahena ꞌinisoya, ma holowaina ꞌisiweya Yesu ꞌahena. ");
INSERT INTO bdd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Coinega Palisiina ꞌiboinamo ꞌoina ꞌinuwatuhu dahwana ꞌigwaeya, “Loheya bewa, ꞌeguma tauna palopita, ꞌida sanapu wahineina ꞌiꞌabiꞌabitoho ꞌabehega tauna togala.” ");
INSERT INTO bdd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bewa ꞌoinega Yesu ꞌihegwaeya ma ꞌigwae, “Saimoni, nuwanuwagu ma ꞌaigeda ginaula yahepwaile ꞌoiuwa.” Ta Saimoni ꞌigwaeya, “Bada, to ginaula? Cuda hegwaegauma.” ");
INSERT INTO bdd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Coinega Yesu ꞌigwae, “Caigeda towasawasa ma loheya ꞌeluwa ꞌihebukidiya, ꞌaigeda ꞌana buki gide paibi handeledi kina, ma ꞌaigeda pipiti kina. ");
INSERT INTO bdd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma siteluwaedi geya sowasowahidi ma sihemaise, ꞌoinega towasawasaina siteluwaedi ꞌadi bukiina ꞌinuwasamudiya. Coinega yahesilalego, siteluwaedi ꞌoidiyega taiya ꞌidi badaina ꞌiloyauwedoweya?” ");
INSERT INTO bdd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Coinega Saimoni Yesu ꞌina gwae ꞌihemaiseya, ꞌigwae, “Nuwana loheyaina tauna ꞌina buki madouna ꞌiloyauwedoweya.” Ta Yesu ꞌigwaeya, “Cehe, moisa.” ");
INSERT INTO bdd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Coinega ꞌiꞌita lohihila wahineina ꞌoina, ma ꞌigwaeya, “Saimoni, wahine bewa ꞌina paihowa weyahigu ꞌuꞌiteya, geya gide ꞌowa. Weyahina ꞌino hada yaluhuma, ta weꞌaha ꞌahegu ꞌana ꞌebebuyo weyahina geya ꞌuꞌebwaegau, ma hesi wahine bewa mataneunega ꞌahegu ꞌibuyodiya, ta debanega ꞌisaudiya. ");
INSERT INTO bdd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma wete ꞌowa haesota ꞌana niso geya ꞌupaihowa ꞌoiguwa, ma tauna hesi ꞌigu latu hauhauwega ꞌahegu ꞌinisonisodi. ");
INSERT INTO bdd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Geya wete debagu holowega ꞌuheheholoigau, ma tauna hesi ꞌina holowega ꞌahegu ꞌiheholoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tauna ꞌina puiyao baibaiwadi yanuwasam pwaidiya, ꞌoinega ꞌihelauwegauwa madouna, ma hesi ꞌeguma taiya ꞌina pui ꞌiꞌiuna ma yanuwasam, beno ꞌina helau ꞌoiguwa wete ꞌiꞌiuna.” ");
INSERT INTO bdd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Coinega Yesu wahineina ꞌihegwaeya, ꞌigwae, “Cino galao yanuwasam pwaidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma loheloheyaedi taudi mahetenao siꞌaiꞌai, Yesu ꞌina gwae sihesagoheya ta taboidimo ꞌoidiya silolomugi, sigwae, “Taiya hede bewa ta ꞌabehega galana ꞌinuwasamudi?” ");
INSERT INTO bdd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yesu hesi wahineina ꞌoina ꞌigwaeya, “Cino hemisa ꞌoinega ꞌabihetena ꞌulobeya, ꞌoinega maꞌino yaliyaya ꞌutauya.” ");
INSERT INTO bdd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma muliyetega Yesu ꞌitoholowa ma ꞌitauya gogo madoudi ma ꞌiꞌiudi ꞌoidiya, Yehoba ꞌina loina tetelina bwebweꞌana sabi guguyae, ma ꞌana tomuliyao site tuwelowedi mahetenao. ");
INSERT INTO bdd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ma wete tupwana wahiwahine mahetediyao, beno taudi mwalo ꞌoidiyega hiꞌahiꞌa Yesu ꞌiula latuhediya, ma wete ꞌadi lohalao ꞌiꞌabi hebwebweꞌanediya. Wahiwahineyedi beno Meli Magidala, tauna mwalo ꞌoinega hiꞌahiꞌa sebeni Yesu ꞌiula latuhediya, ");
INSERT INTO bdd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma wete Yowana, tauna Kusa mwanena, Kusaina Helodi ꞌina topaihowa, ma wete Susana, ma wete tupwadi wahiwahine mahetediyao. Wahiwahineyedi taudi ꞌidi tobwatobwa ꞌoidiyega Yesu maꞌiyanao siꞌitayahidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tomota baibaiwadi gogo mabwaiyana ꞌoidiyega sinaoma ta siꞌauta Yesu ꞌoina, ma Yesu gwae hegehegedi ꞌoinega ꞌiheꞌitediya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Totanoha paihowa ꞌaigeda ꞌina tanoha ꞌitauya ta witi patuna ꞌisaweyanediya, ma tupwadi patu ꞌedai sibeꞌuwa ma tomota sibasa hibibiya, ma wete bwasumo siꞌitediya, ta sisuluma ma siꞌaidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma tupwana patu baleꞌu lodaꞌudaꞌuleina ꞌoina sibeꞌuwa ta sibwala ma muliyetega siwelaiya, weyahina baleꞌuina geya gogaina. ");
INSERT INTO bdd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma tupwadi patu talitali ꞌoidiya sibeꞌuwa, ta sibwala hegogona, ma hesi talitali ꞌihewaiwaiya ta ꞌisahila heꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma tupwana baleꞌu ꞌausalana ꞌoina sibeꞌuwa ta sibwalama, ma simadouwa ma sihuwa, ta ꞌoidiyega ꞌebayo bwebweꞌana silobeya, weyahina patuwedi ꞌaigeda ꞌaigeda ꞌoidiyega handeledi silobediya.” Coinega Yesu boda ꞌihegwaediya, ꞌigwae, “Ceguma matenami gwae bewa wahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ma muliyetega ꞌana tomuliyao Yesu sihesilaleya, sigwae, “Cino gwae hegehegediyedi toꞌaha ꞌadi sanapu?” ");
INSERT INTO bdd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma tauna ꞌigwaeya, “Comi Yehoba ꞌoimiya ꞌitagwala pwaiya ma ꞌina loina ꞌalodi moisa ꞌana tosanapuwao, ma hesi tomota baibaiwadi gwae hegehegedi sihesagoheya, ma ꞌana nuwasabwalena geya, ma wete ꞌana nuwasabwalena sibesebese ma gesowana silobaloba. ");
INSERT INTO bdd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ma gwae hegehegedi ꞌana lihasa bewa gide: Patuina beno Yehoba ꞌina gwae. ");
INSERT INTO bdd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma patuwedi ꞌedai sibeꞌuwa taudi beno tomotaedi gwaemo sihesagoheya, ma Seitani ꞌinaoma ma ꞌatediyega gwaeyedi ꞌiꞌewayahuleya, ꞌoinega gesowana sihemihemise ma ꞌabehega Yehoba ꞌiꞌabihetedi. ");
INSERT INTO bdd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma patuwedi sibeꞌuwa baleꞌu lolodaꞌudaꞌulena ꞌoina tomotaedi taudi beno Yehoba ꞌina gwae weyahina siyaliyaya, ma hesi geya lamudi ꞌipaꞌapaꞌala, weyahina ꞌidi hemisa geya madouna, ma ꞌeguma ꞌebe tohona ꞌoidiya ꞌilatu nata sibeꞌu. ");
INSERT INTO bdd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma patuwedi talitali ꞌoidiya sibeꞌuwa, tomotaedi taudi gwaeina sihesagoheya, ma hesi ꞌidi nuwatuhu mabwaiyana ꞌitautauya wasawasao ta baleꞌu yaliyayaina ta wete ginaula baibaiwana ꞌoidiya, ma ꞌoinega Yehoba ꞌina gwae ꞌoidiya geya huwaina ꞌida latuwa. ");
INSERT INTO bdd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma patuwedi baleꞌu bwebweꞌana ꞌoina sibeꞌuwa, taudi beno ma ꞌidi ꞌatetagwala gwaeina sihesagoheya, ꞌoinega siheꞌalamaꞌiꞌitana, ma Yehoba ꞌina gwae ꞌoidiya ꞌihuwa bwaibwaina.” ");
INSERT INTO bdd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ma Yesu wete ꞌoidiya ꞌigwaeya, “Geya ꞌaigeda taiya mayale ꞌalaꞌalasina ꞌilagulagu dahwa walata bo sita ꞌoidiyega, ma hesi ꞌatamana ꞌilagu ma ꞌaneyage hada ꞌana tomiyao ꞌiꞌasilala ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ceguma to ginaula ꞌatemiya wadahwediya, ꞌabwa ꞌasilalaina ꞌiꞌabilatuhe. Ma toꞌaha ꞌulagu dahweya, ꞌabwa ginauledi ꞌilolatuhe ꞌatamana. ");
INSERT INTO bdd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Coinega wanuwatuhuyahi ma gwae wahesagoha bwaibwaini. Weyahina ꞌeguma taiya ꞌoina Yehoba ꞌina tobwatobwa ꞌimiyamiya, nata tobwatobwaina ꞌilohepoi. Ma taiya ꞌoina geya Yehoba ꞌina tobwatobwa ꞌimiyamiya, ma ꞌiboinamo ꞌinuwatuhuya ꞌabehega Yehoba ꞌina tobwatobwa ꞌoina ꞌimiyamiya, nata Yehoba tobwatobwaedi ꞌoinega ꞌiꞌewayahuledi.” ");
INSERT INTO bdd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ma muliyetega Yesu sinana ma tasinao sinaoma sabi ꞌitaina, ma boda madou hedada, ꞌoinega geya sowasowahina ma siluhu Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma gwaemo sihewasaeya, sigwae, “Bada, sinau ma tasimwao waꞌitalatu ꞌatamana sitotoholo, ma nuwanuwadi ꞌowa.” ");
INSERT INTO bdd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Coinega Yesu ꞌihegwaediya, ꞌigwae, “Geya siboimo, ma hesi ꞌeguma taiyewedi Yehoba ꞌina gwae sihehesagohe ma simulimuliye, beno taudi sinagwao ma tasigwao.” ");
INSERT INTO bdd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Caigeda tuta Yesu ma ꞌana tomuliyao sigeluwa, ma ꞌoidiya ꞌihepwaila, ꞌigwaeya, “Tahabala hali tupwa.” Ta siꞌuꞌeya, ");
INSERT INTO bdd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ma sipilipili ma Yesu ꞌiꞌenoꞌeno ta ꞌiꞌeno sineya. Eeta wediliya madouna ꞌitowama ma dibana madouna sisiwasiwa taona wagai, ma ꞌiꞌiuna ma sidamana. ");
INSERT INTO bdd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Coinega loheloheyaedi Yesu silohanohanoya ma sigwae, “Bada ꞌutoholo, ꞌiꞌiunamo tadamana!” Coinega ꞌitoholowa ma yaumai ma bagodu ꞌiheliyediya, ꞌigwae, “Walolagu!” Ta silolaguwa ma ꞌidaumwala. ");
INSERT INTO bdd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma Yesu ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Comi togidega, geya wahemihemisaegau, ꞌawa?” Ma taudi sideba mwadina, ta wete nuwadi ꞌihenainaida, ma siboidimo ꞌoidiya sigwae, “To loheya hede bewa? Ta yaumai ma dibana ꞌiloinaediya ma ꞌenana sihesagoheya!” ");
INSERT INTO bdd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ma Galili hali tupwa sihabala pwaiya ta siluhuwa meGelasine ꞌidi gadowa. ");
INSERT INTO bdd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Coinega Yesu ꞌisuluwa dabala, ma toniꞌasa ꞌaigeda ꞌilatuma. Loheyaina mwalo ꞌalona hiꞌahiꞌa siluhuwa ma ꞌoina simiyamiya. Ma loheyaina tuta dudulena ꞌaleꞌo geya ꞌida ꞌoteya, ma hada ꞌoidiya geya ꞌida miya, ma hesi ꞌina ꞌebemiya galiha duluhina ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Coinega loheyaina Yesu ꞌiꞌiteya ma ꞌibwau ta ꞌibeꞌu ꞌeno talutalubuꞌiya, ma ꞌibwau waiwaiya, ꞌigwae, “Yesu yo, ꞌowa Yehoba Tohewaiwai hedada Natuna, toꞌaha ꞌutohotoho ma ꞌabehega ꞌupaihowa ꞌoiguwa? Tuwa! Sahena ꞌuꞌabiꞌabi hemuyemuyegau.” ");
INSERT INTO bdd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gwae bewa ꞌiꞌinaneya weyahina Yesu ꞌihegwae pwaiya, ꞌigwaeya “Hiꞌahiꞌa, loheyaina beno ꞌoinega ꞌulatu.” Ta wanuwatuhu ꞌabehega loheyaina mwalo tuta baibaiwana hiꞌahiꞌa ꞌiꞌabiꞌabi heyauyaule, ꞌoinega siꞌabiyahiya ma nimana ta ꞌahena sipaidiya gulaha pwawati, beno seni ꞌoidiyega, ma tuwa seniyedi ꞌiupaupadi ta wete hiꞌahiꞌa loheyaina ꞌitautauye tupwa yoho ꞌawawa. ");
INSERT INTO bdd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Coinega Yesu loheyaina ꞌihesilaleya, ꞌigwae, “Togidega saniu?” Ma tauna ꞌigwaeya, “Sanigu Baibaiwa Hedada, weyahina hiꞌahiꞌa baibaiwadi siluhu pwaiya ꞌaloguwa ta simiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma yaluyaluwaedi ꞌenadi Yesu ꞌoina siꞌahwanoi waiwai sigwaeya, “Sahena ꞌuulaula suluhemai gaula ꞌebesilahe ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ma hesi ꞌuhesumanemai ma ꞌaluhu bawe bodaidi nage siduladula ꞌoyai.” Coinega ꞌitagwala, ");
INSERT INTO bdd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ta silatuwa loheyaina ꞌoinega ma bawe ꞌoidiya siluhuwa. Nage ꞌoina baweyedi siheyauyauleya, ma mabwaiyadi sipili butubutu ta ꞌadeꞌadewala sibeꞌuwa, ta holai sidamana. ");
INSERT INTO bdd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma bawe ꞌadi toꞌitayahinao baweyedi ꞌidi silahe siꞌiteya ta simatauta, ꞌoinega sidena ta sitauya ꞌasai, ta wasaina toꞌaha gide siꞌiteya sihepwailediya gogo madoudi ta gogo ꞌiꞌiudi tomotaedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Coinega tomotaedi sinaoma ma ꞌabehega taudi matadiyega siꞌita toꞌaha ꞌilatuwa. Sinaoma Yesu ꞌoina ma loheyaina siꞌiteya, mwalo hiꞌahiꞌa ꞌalona simiyamiya ꞌibwebweꞌana pwaiya, ma ꞌaleꞌo ꞌiꞌoteya, ma Yesu ꞌahena deina ꞌimiyamiya. Nage ꞌoina mabwaiyadi simatauta. ");
INSERT INTO bdd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma tohewasaedi tomota ꞌoidiya siheꞌoteꞌotetela togidega loheyaina ꞌibwebweꞌana ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Coinega meGelasine mabwaiyadi simatauta madouna, ma Yesu silohesohesoiyeya ma ꞌabehega ꞌiꞌebesinedi. Coinega Yesu ꞌidobiya wagai ta ꞌigeluwa, ma sitauya. ");
INSERT INTO bdd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma loheyaina ꞌiꞌabihe bwebweꞌaneya Yesu ꞌoina ꞌiꞌahwanoiya ꞌigwae, “Sowasowahina yamuliyego?” Coinega Yesu ꞌihegwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ꞌigwae, “Geya. Ma hesi ꞌuhila ma ꞌutauya ꞌasai, ma toꞌaha gide Yehoba ꞌoiuwa ꞌipaihoweya ꞌuhepwaila dadane.” Eeta loheyaina ꞌitauya gogoina ꞌalonega, ma Yesu ꞌina paihowa waiwaina ꞌiheꞌoteꞌoteteliya tomiyaꞌasa mabwaiyadi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ma Yesu maꞌana tomuliyao sihabala hila, ma boda madouna maꞌidi yaliyaya sihesohoteya, weyahina tauna tuwa siyamwayamwa. ");
INSERT INTO bdd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Coinega ꞌaigeda loheya ꞌiluhu latuma, sanina Yailo, tauna ꞌidi hada tapwalolo ꞌana toꞌitayahina. Cinaoma ma Yesu ꞌahena ꞌiꞌetuluha, ma ꞌigwaeya, “Bada tatau ꞌigu hada, ");
INSERT INTO bdd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ma natugu ꞌilohala madouna ꞌuꞌabihe bwebweꞌane. Tauna tuwa natugu ꞌaigeda tuwa, ꞌana bolime tuwelo, hadai ꞌiꞌenoꞌeno, tuta ꞌiꞌiuna ma ꞌiꞌamasa.” Coinega baꞌidana sitauya. Ma Yailo mahetena ꞌedai sitautau ta boda madouna simuliyediya, siheheduidui. ");
INSERT INTO bdd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma bodaedi ꞌalodiya ꞌaigeda wahine mahetediu, maꞌana lohala. Lohalaina beno bweyahina ꞌidaudau bolime tuwelo ꞌoidiya, ma tuwa ꞌabwa ꞌidaudau. Tuta baibaiwana toꞌabimuya sitohotoho ma ꞌabehega siꞌabihe bwebweꞌane, ma geya sowasowahidi. ");
INSERT INTO bdd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wahineina Yesu mulinega ꞌinaoma ma ꞌana ꞌaleꞌo papalina ꞌiꞌabitohoya, ta bweyahina ꞌina dau ꞌiyapasa mwayamwayauwa. ");
INSERT INTO bdd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eeta Yesu ꞌisalutuwama, ꞌigwaeya, “Hei! Taiya ꞌiꞌabi tohogauwa?” Ta mabwaiyadi siuhala, ma hesi Pita ꞌihegwaeya, ꞌigwae, “Bada, bodaedi siheheduidui ta ꞌoiuwa situpa.” ");
INSERT INTO bdd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yesu ꞌigwaeya, “Geya! Caigeda taiya ꞌagu ꞌaleꞌo ꞌiꞌabitohoya, weyahina yalotohoya ꞌoiguwega waiwai ꞌihapwesa, ta toꞌabi tohonaina ꞌoina ꞌihabala.” ");
INSERT INTO bdd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma wahineina ꞌisanapuya ꞌabehega Yesu ꞌisanapu pwaiya ꞌina paihowa, ꞌoinega ꞌinaoma maꞌina ꞌateyoho, ꞌibeꞌu talutalubuꞌiya Yesu ꞌahena, ma boda matadiya ꞌina ꞌabitohona lamuna ꞌihepwaila latuheya, ꞌigwae, “Bada, nuwanuwagu yabwebweꞌana, ꞌoinega ꞌa ꞌaleꞌo yaꞌabitohoya, ma yabwebweꞌana mwayamwayauwa.” ");
INSERT INTO bdd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Yesu wahineina ꞌihegwaeya, ꞌigwae, “Natugu, ꞌino hemisa ꞌoinega ꞌubwebweꞌana pwaiya, Cutoholo maꞌino yaliyaya ꞌutauya.” ");
INSERT INTO bdd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ꞌabwa ꞌigwaegwae wahineina ꞌoina, ma tutaina ꞌoina Yailo ꞌina hadega ꞌina topaihowa ꞌaigeda wasa ꞌiꞌeweyama Yailo ꞌoina, ꞌigwaeya, “Taubada, natuu yawasina ꞌigumwala pwaiya, ma sahena toheꞌitaina ꞌina tuta wete ꞌuuleule.” ");
INSERT INTO bdd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wasaina bewa Yesu ꞌihesagoheya ma Yailo ꞌihegwaeya, ꞌigwae, “Sahena ꞌuꞌateꞌateyoho. Ma hesi ꞌuhemisaegau ꞌabehega natuu nata ꞌibwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Coinega sitauya ma ꞌasai sihapwesa, ma Yesu boda mabwaiyadi ꞌiꞌausidiya ma sahena hadaina ꞌoina siluhuluhu, tuwa beno nuwanuwana Pita ta Yoni ta Yemesa, ma wete gwamaina tamana ta sinana mahetenao siluhu. ");
INSERT INTO bdd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma boda hadai ꞌabwa tuwa sidoudou ta wete siwuiwui gwamaina weyahina. Coinega Yesu ꞌiꞌausidiya ꞌigwae, “Tuwa! Dou walolagu! Weyahina gwama geya ꞌiꞌamasa, ma hesi tuwa ꞌiꞌenosineya.” ");
INSERT INTO bdd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma mabwaiyadi Yesu simaluweya, weyahina sisanapuya ꞌabehega ꞌiꞌamasa pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Coinega Yesu gwama nimana ꞌiꞌabiyahiya ma ꞌihegwaeya, ꞌigwae, “Gwamasine, ꞌutoholo.” ");
INSERT INTO bdd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta gwama dumwaluna yawasina ꞌihilama ma ꞌitoholowa. Ma Yesu gwamaina sinana ma tamana ꞌoidiya ꞌigwaeya, “Ceꞌahai waꞌebwae ma ꞌiꞌai.” ");
INSERT INTO bdd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nage ꞌoina tamana ma sinana nuwadi ꞌihenainaida moisa. Ma Yesu wete ꞌihenuwa laguwediya ꞌigwae, “Sahena ꞌaigeda taiya ꞌoina wahehepwaila ꞌigu paihowa bewa weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ta Yesu ꞌina topaihowao site tuwelo ꞌibwau ꞌautedima, ꞌadi loina ma waiwai ꞌiꞌebwaediya, sawasawahidi hiꞌahiꞌa tomota ꞌoidiyega siula latuhedi, ma wete ꞌadi lohalao siꞌabihe bwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Coinega ꞌihewasediya ma ꞌabehega Yehoba ꞌina hetoloina tomota ꞌoidiya siguguyae, ma wete lohalao siꞌabihe bwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma wete ꞌina guguya ꞌoina ꞌiloinaediya, ꞌigwae, “Sahena ꞌaigeda toꞌaha waꞌewaꞌewa. Sahena guna bo peha bo ꞌeꞌahai bo mane, bo ꞌami ꞌwama ꞌeluwa. ");
INSERT INTO bdd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma ꞌeguma to hada ꞌoina sibwauwegomi ma waluhuluhu, hadaina ꞌoina wahetaumana ma ꞌana siga tupwaina waꞌebesine. ");
INSERT INTO bdd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma ꞌeguma to ꞌasa ꞌoina geya sitoegemi ꞌidi hada ꞌoidiya, gogoina namonamoina ꞌahemiyega walohutuhutu yahuledi ma waꞌebesinedi, ma ꞌoinega waheꞌitadi ꞌabehega nata mwau ꞌoidiya ꞌilatu.” ");
INSERT INTO bdd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma ꞌoinega topaihowaedi sitauya, ta tupwa mabwaiyana ꞌoidiya sisakowasiya ma tetela bwebweꞌana siloguguyae, ma wete tolohalao tupwa ꞌaigeda ꞌaigeda ꞌoidiya siꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma hesi Helodi, tauna Galili ꞌana toloina, ginauledi bewa silatulatu tetelidi ꞌihesagohediya, ta nuwana ꞌihenainaida madouna weyahina tupwadi tomota sigwaeya, “Yoni toꞌabihebabitaiso ꞌabehega ꞌamasega ꞌitoholo hila,” ");
INSERT INTO bdd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma tupwadi sigwaeya, “Bo nuwana Ilaitiya ꞌilatuma,” ma wete tupwadi sigwaeya, ꞌabehega “Tauna ꞌaigeda palopita miyamiyaina ꞌiꞌamasa ta tuta bewa ꞌitoholo hilama.” ");
INSERT INTO bdd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma Helodi hesi ꞌigwaeya, “Yoni taugu ꞌigu loinega ta ꞌaniꞌona siꞌupweya. Ma to loheya hede beno sigwaegwaene.” Nage ꞌoina Helodi ꞌitoho waiwai ma ꞌabehega Yesu ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma Yesu ꞌina topaihowaowedi ꞌidi sakowasiyega sihilama, ta ꞌidi paihowa mabwaiyana siheꞌoteꞌoteteliya Yesu ꞌoina. Ta muliyetega ꞌidi badaina ꞌitoediya, ta baꞌidanao sitauya ꞌaigeda gogo sanina Bedeseida ꞌoina, ma ꞌabehega siboidimo nobwa simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma geya sowasowahidi, weyahina boda wasa sihesagoheya, ma Yesuina simulimuliyeya ta sinaoma ꞌoina. Coinega Yesu ꞌoidiya ꞌitagwala ma Yehoba ꞌina loina weyahina ꞌiheꞌitediya, ma wete ꞌadi lohalao ꞌiꞌabihe bwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Simiyamiya ta sinala ꞌisopuwa ma sitetuwelowedi sinaoma ma Yesu sihegwaeya, sigwae, “Bada, boda bewa ꞌuhesumanedi ma sihila gogo deidiya, ma nobwa ꞌeꞌahai ma ꞌebeꞌeno sibesa, ma ꞌoidiya siꞌaiyawasi. Weyahina bewa ꞌebwa yoho ꞌawawa.” ");
INSERT INTO bdd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Coinega Yesu ꞌoidiya ꞌigwaeya, “Togidega, ꞌomi nata geya waheheꞌaidi, ꞌawa?” Ma taudi sigwaeya, “Togidega nata ꞌaheꞌai ꞌesedi? Weyahina ꞌama geya baibaiwanamo. Beledi nima ma silahana luwa situpwa. Togidega, nuwanuwau ꞌabehega ꞌatau ma bodaedi ꞌadi ꞌagimwane?” ");
INSERT INTO bdd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ma bodaedi ꞌoidiyega loheloheyamo ꞌadi baibaiwa gide paibi tausani. Coinega Yesu ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Tomotaedi wawatahidi ma ꞌidi boda ꞌoidiyega walagudi, gide tomota pipiti boda ꞌaigeda ꞌaigeda ꞌoidiya, ma gide simiyatoi ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ma ꞌina loinaina mabwaiyana gide sipaihoweya ta simiyatoiya ꞌidi boda ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Coinega Yesu beledi nima ma wete silahana ꞌeluwa ꞌiꞌewediya, ma galewa ꞌiꞌita haneya, ta ꞌeꞌahaiyedi weyahidi ꞌigwae helauwa. Ma muliyetega ꞌihisidiya ma ꞌana tomuliyao ꞌiꞌebwaediya ma siheguyai tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Coinega mabwaiyadi siꞌaiya ta simwausuwa, ma ꞌeꞌahai tupwatupwadi sihegogonediya, ta boha tuwelo silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta Yesu maꞌana tomuliyao sitauya, ma muliyetega Yesu ꞌiboi ꞌimiyamiya, ma Yehoba ꞌoina ꞌiꞌahwaꞌahwanoi. Ma ꞌina ꞌahwanoi ꞌigumwala ta ꞌana tomuliyao ꞌihesilala ꞌoidiya, ꞌigwae, “Toꞌaha tomota ꞌidi gwae weyahigu, ꞌabehega taiya taugu?” ");
INSERT INTO bdd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma taudi sigwaeya, “Tomota tupwadi sigwae ꞌabehega ꞌowa Yoni toꞌabihebabitaiso, ma tupwadi sigwae ꞌabehega ꞌowa Ilaitiya, ma tupwadi sigwae ꞌabehega ꞌowa ꞌaigeda palopita nugenugetana ꞌamasega ꞌutoholo hilama.” ");
INSERT INTO bdd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Coinega wete ꞌihesilalediya, ꞌigwae, “Ma ꞌomi togidega ꞌimi nuwatuhu ꞌabehega taiya taugu?” Ta Pita ꞌigwae, “Cowa Toꞌabihetena, Yehoba ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nage ꞌoina Yesu ꞌana tomuliyao ꞌiloina paꞌalediya ma sahena sihehepwaile tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ta wete ꞌihegwaediya, ꞌigwae, “Taugu Loheyaiguina ma ꞌabwa muya madouna yaloba. Weyahina babadao ma topwaoli madoudi ma wete loina ꞌana toheꞌitao nata siguipailegau ma siloheꞌamasigau, ma sabwelo hetoina ꞌoina Yehoba ꞌiꞌabihetoholo hilegau.” ");
INSERT INTO bdd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Muliyetega mabwaiyadi ꞌoidiya ꞌigwae, “Ceguma taiya ꞌowa nuwanuwau ma ꞌumuliyegau, sahena ꞌuboi weyahiu ꞌunuwanuwatuhu. Ma hesi ꞌuboi ꞌa kelose ꞌuꞌahali sabwelo ꞌaigeda ꞌaigeda ma ꞌoinega ꞌumuliyegau. ");
INSERT INTO bdd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ma ꞌeguma taiya yawasina ꞌinuwahi ꞌabwa yawasina ꞌiheꞌwaihi. Ma ꞌeguma taiya yawasina weyahigu ꞌitagwale ma ꞌiꞌamasa, tauna ꞌabwa yawasina ꞌausalana ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ceguma ꞌida wasawasao madou hedada talobadi beno ginaula bwagabwaga, ma hesi ginaula madouna beno yawasida bwebweꞌana. Weyahina ꞌeguma yawasida bwebweꞌana taheꞌwaihi, beno mwau hedada. ");
INSERT INTO bdd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Taugu Loheyaiguina, ma ꞌeguma taiya ꞌowa weyahigu ꞌudebamwadina ma wete ꞌigu heꞌita weyahina ꞌudebamwadina ma ꞌuuhalegau, ꞌabwa yauhalego tutaina ꞌeguma yahilama maꞌagu hepwatu ta maꞌigu ꞌasilalaina, ta wete Tamagu maꞌina aneloseyao ꞌidi ꞌasilalaina ꞌoiguwa. ");
INSERT INTO bdd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yagwae moisa ꞌoimiya ꞌabehega tomota tupwami geyaꞌabwa waꞌamaꞌamasa ta ꞌana siga Yehoba ꞌina hetoloina matamiya waꞌita.” ");
INSERT INTO bdd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gwaeyedi bewa sigumwala ma gide wiki ꞌaigeda mulina, Pita ta Yoni ta wete Yemesa Yesu ꞌitoediya, ma mahetenao sihaneya ꞌaigeda ꞌoya ꞌoina sabi ꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma ꞌabwa tuwa Yesu ꞌiꞌahwaꞌahwanoi, ma manina ꞌana ꞌita ꞌibuiya ta wete ꞌana ꞌaleꞌo waꞌewaꞌeꞌena moisa. ");
INSERT INTO bdd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nage ꞌoina loheya ꞌeluwa silatuwa, ma Yesu mahetediu sihehegwaegwae, taudi beno Mosese ma Ilaitiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Taudi wete ꞌoidiyega ꞌasilala ꞌiꞌasiꞌasilala, ma Yesu mahetediu sihehegwaegwae Yesuina ꞌina ꞌamasa ꞌabwa Yelusalema ꞌoina weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta Pita maꞌiyanao siꞌenosinediya, ma ꞌoinega siꞌeno toholowa, ma ꞌasilala madouna siꞌiteya ꞌisae Yesu maꞌiyanao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nata ma siteluwaedi Yesu siꞌebesine, ma Pita ꞌiꞌapulagata ma ꞌigwae, “Bada, bwebweꞌana ꞌeguma taudi siteluwaedi mahetedai ꞌabwa tamiyamiya, ma ꞌoinega ꞌimi yoheyohe ꞌetoi ꞌaꞌabidi, ꞌaigeda ꞌowa weyahiu, ma ꞌaigeda Mosese weyahina ma wete ꞌaigeda Ilaitiya weyahina.” Beno Pita tuwa ꞌigwaegwae bwagabwaga. ");
INSERT INTO bdd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ꞌina gwae ꞌabwa geya ꞌilosalohi, ta tabwanidiya yalowa ꞌisuluma ta ꞌiꞌahuhe taluhidiya, ꞌoinega sitetoiyedi simatauta. ");
INSERT INTO bdd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma yaloha ꞌoinega ꞌenana sihesagoheya, ꞌigwae, “Bewa Natugu bwebweꞌana hedada, ꞌina gwae wahesagohedi.” ");
INSERT INTO bdd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma ꞌenanaina ꞌigumwala ta Yesu ꞌiboinamo siꞌiteya ꞌitotoholo. Saugaina nage ꞌoina toꞌaha gidemusa matadiya siꞌiteya geya ꞌeta taiya ꞌoina sihepwaile, ma sidahweya. ");
INSERT INTO bdd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gona ꞌiꞌadaleya ta Yesu maꞌana tomuliyao ꞌoyega sisuluma ꞌasai, ma boda madouna mahetediyao sihelobaloba. ");
INSERT INTO bdd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma ꞌaigeda loheya bodaedi ꞌoidiyega Yesu ꞌiꞌiteya ta ꞌiwuiya, ꞌigwae, “Toheꞌita, nuwanuwagu ma natugu ꞌuꞌabihe bwebweꞌane, tauna natugu ꞌaigeda tuwamo. ");
INSERT INTO bdd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ma tuta baibaiwana ꞌeguma hiꞌahiꞌa gwamaina ꞌiꞌabiyahiya, natuguina ꞌiwuiwui madouna ma ꞌihehebwasubwasumo, weyahina ꞌitaitai ma ꞌahwanega gwalabuso silatulatu. Tuta baibaiwana gidemusa ꞌiꞌabiꞌabi hemuyamuya. ");
INSERT INTO bdd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma ꞌa tomuliyaedi yaꞌahwanoiyediya ma ꞌabehega hiꞌahiꞌaina siulalatuhe, ma geya sowasowahidi.” ");
INSERT INTO bdd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Coinega Yesu ꞌoidiya ꞌigwaeya, “Mehau ꞌomi hede togidega? Ta debami paꞌala hedada! Nuwana geya wahemisaegau, ꞌawa? Cimi debapaꞌalina ꞌoinega yalowahiꞌwata.” Coinega loheyaina ꞌihegwaeya, ꞌigwae, “Natuina ꞌuꞌeweyama ꞌoiguwa.” ");
INSERT INTO bdd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma gwamaina ꞌinaoma Yesu ꞌoina, ta hiꞌahiꞌa gwamaina ꞌiulasuluheya baleꞌuwa ta ꞌitaiya, ꞌoinega Yesu ꞌiloina ma yaluyaluwaina ꞌilatuwa ma gwamaina ꞌibwebweꞌana. Ta muliyetega Yesu gwamaina ꞌitoeya tamana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tuta nage ꞌoina tomota mabwaiyadi Yehoba ꞌina waiwai siꞌiteya, ꞌoinega nuwadi ꞌihenainaida madouna. Ma tomotaedi ꞌabwa sihehenainaida ꞌina paihowa weyahina, ma Yesu ꞌana tomuliyao ꞌihegwaedi, ");
INSERT INTO bdd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ꞌigwaeya, “Cigu gwae bewa nata yahepwaile ꞌoimiya wanuwatuhuyahi bwaibwaini, beno taugu Loheyaiguina ꞌiꞌiunamo ma sitebae ma ꞌagu ꞌalehao ꞌoidiya siꞌebwayaegau.” ");
INSERT INTO bdd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nage ꞌoina ꞌiꞌabi heꞌwani bwaibwainidiya, ꞌoinega geya sowasowahina ma ginaula bewa weyahidi nuwadi ꞌisabwalena, ma Yesu ꞌoina geya sihesilala ma ꞌabehega ꞌida heꞌitae ꞌoidiya, weyahina simatauta. ");
INSERT INTO bdd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ta muliyetega ꞌana tomuliyaowedi siheꞌoheꞌoheya ꞌabehega taiya ꞌoidiyega ꞌadi tohanugeta. ");
INSERT INTO bdd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Yesu hesi ꞌidi nuwatuhu ꞌisanapudiya. Coinega gwama ꞌaigeda ꞌitoeyama ta deina ꞌihetoholoya, ");
INSERT INTO bdd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ꞌihegwaediya, “Gwama bewa waꞌita. Ceguma taiya ꞌowa gwama bewa weyahigu ꞌuhelauwe, ꞌowa beno ꞌuhelau pwaigauwa, ma wete ꞌagu Tohewasaina ꞌuhelau pwaiyeya. Coinega ꞌeguma taiya ꞌoimiyega sanina geya madouna tauna ꞌihane hedadeya.” ");
INSERT INTO bdd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma Yoni ꞌiꞌapulagata ma ꞌigwaeya, “Bada, ꞌaigeda loheya ꞌaꞌiteya ta saniuwega hiꞌahiꞌa ꞌiulaula hapwesedi. Eeta ꞌaꞌausiya, weyahina loheyaina geya ꞌida boda.” ");
INSERT INTO bdd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma Yesu ꞌigwaeya, “Sahena waꞌauꞌausi! Weyahina ꞌeguma taiya tauna geya ꞌiloloꞌalehegomi tauna ꞌami toꞌabihetena.” ");
INSERT INTO bdd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sabweloina ꞌihahohoyama ta Yesu ꞌihila galewa, ꞌoinega ꞌina nuwatuhu ꞌilaguya ma ꞌabehega ꞌitautau Yelusalema. Coinega ꞌitoholo ma maꞌana tomuliyao sitauya. ");
INSERT INTO bdd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sitautauya, ma Yesu ꞌana tomuliyao tupwadi ꞌihewasa nugetediya, meSameliya ꞌidi gogowa, ma ꞌabehega ꞌebeꞌaiyawasi weyahina siꞌatububu. ");
INSERT INTO bdd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma hesi tomiya ꞌasaedi geya ꞌoidiya sitagwatagwala, weyahina sinuwatuhuya Yesu geya ꞌidi gogo ꞌoina ꞌitautauya, ma hesi ꞌitautauya Yelusalema. ");
INSERT INTO bdd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yemesa ta Yoni gwae bewa sihesagoheya, ta Yesu ꞌoina sigwaeya, “Bada, togidega? Sowasowahina taloina ma ꞌaiwe ꞌalaꞌalata galewega ꞌisuluma ꞌiꞌalahe gumwalidi?” ");
INSERT INTO bdd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yesu ꞌigwaeya, “Tuwa! Sahena gide.” ");
INSERT INTO bdd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma ꞌoinega hali gogowa sitauya. ");
INSERT INTO bdd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sitautauya, ta ꞌaigeda loheya ꞌinaoma ma Yesu ꞌoina ꞌigwaeya, “Taugu nuwanuwagu ma yamuliyego. To tupwa ꞌoina ꞌutautauya yamuliyego.” ");
INSERT INTO bdd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Coinega Yesu loheyaina ꞌihegwaeya, ꞌigwae, “Cedewa totopwatula maꞌidi gaula ma wete bwasumo maꞌidi nehwa, ma taugu Loheyaiguina geya ꞌigu ꞌebeꞌenomo.” ");
INSERT INTO bdd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Coinega heluwena wete ꞌinaoma ma Yesu loheyaina ꞌoina ꞌigwaeya, “Cumuliyegau.” Ma tauna ꞌigwaeya, “Bada, ꞌutagwalegau ma nugeta yahila, ma tamagu yayamwa ꞌina ꞌamasa weyahina, yagalihe, ma muliyetega yamuliyego.” ");
INSERT INTO bdd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yesu ꞌigwaeya, “Tuwa nobwa tamauina, ma taudi toꞌamasa ꞌidi toꞌamasa sigalihedi. Ma ꞌowa hesi ꞌino paihowa ꞌabehega ꞌuhetohalewasa Yehoba ꞌina ꞌebeloina weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma hetoina wete ꞌinaoma ta ꞌigwaeya, “Bada bwebweꞌana ma yamuliyego, ta ꞌutagwalegau ma nugeta yahila ma ꞌigu susuwao yahelauwedi, ma muliyetega yamuliyego.” ");
INSERT INTO bdd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Coinega Yesu wete ꞌihegwaeya, ꞌigwae, “Ceguma taiya ꞌowa nuwanuwau ma ꞌupaihowa ta maꞌino henuwanaluwa, geya ꞌa lobwaina ma Yehoba ꞌina ꞌebeloina weyahina ꞌupaihowa.” ");
INSERT INTO bdd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tuta nage mulina, tupwadi wete ꞌana tomuliyao ꞌihesinuwediya, sebeniti ꞌadi baibaiwa, ma ꞌeluwa ꞌeluwa ꞌihesumane nugetediya gogo baibaiwadi ꞌoidiya, ma ꞌane toniꞌasa siꞌatububudi Yesu ꞌina tauyama ꞌoidiya weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ꞌihegwaediya, ꞌigwae, “Celiꞌeli bwebweꞌana ma toꞌeliꞌeli ꞌomi tupwamimo, ꞌoinega toni tanoha ꞌoina waꞌahwaꞌahwanoi ma ꞌane topaihowao wete ꞌihesumanedi ꞌina tanoha sabi ꞌelina. ");
INSERT INTO bdd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sauga bewa yahesumanegomi, watauya gide sipi manamanasamina ꞌedewa lolosasaidi gamwagamwanidiya. ");
INSERT INTO bdd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Sahena mane waꞌewaꞌewa, sahena ꞌeꞌahai mabohaidi, sahena ꞌami butu waꞌewaꞌewadi. Ma ꞌeguma ꞌedai watautau sahena tomota mahetemiyao wahehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ma ꞌeguma ꞌaigeda hada ꞌoina waluhu, nugeta wahegwaedi, wagwae, ‘Daumwala ꞌoimiya.’ ");
INSERT INTO bdd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma ꞌeguma nuwadaumwala ꞌana topaihowao simiyamiya, ꞌimi helauina ꞌoidiya ꞌida miyamiya. Ma ꞌeguma geya, tuwa helauina ꞌihilawa ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Ma ꞌeguma hadaina ꞌoina wamiyamiya, ma toꞌaha ꞌami, nuwana ꞌami weꞌaha matamiya silagu tuwa waꞌai, weyahina topaihowao ꞌilobwainediya ma ꞌadi ꞌiluwana siloba. Ma sahena watautau hali hada ꞌoidiya, ma hesi hadaina ꞌoina waluhu nugeta ꞌoina tuwa wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma ꞌeguma to ꞌasa ꞌoina siꞌahe sohetegomiya ma ꞌoidiya waluhuwa, ma toꞌaha matamiya silagu latuheya, tuwa waꞌai. ");
INSERT INTO bdd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma wete gogoina ꞌoina wamiyamiya ꞌidi tolohalao waꞌabihe bwebweꞌanedi, ma wete toni ꞌasao wahegwaedi, wagwae, ‘Yehoba ꞌina loina ꞌiꞌiunamo ma ꞌilatu ꞌoimiya.’ ");
INSERT INTO bdd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma ꞌeguma to ꞌasa ꞌoina walatu ma silogwahategomi, mulimuliya ꞌeda ꞌoidiya wahahila ma wahegwaedi, wagwae, ");
INSERT INTO bdd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Waꞌita, ꞌimi gogo nenegwalina ꞌahemega ꞌaꞌalohutuhutu yahule, ma wasanapu ꞌabehega Yehoba ꞌina loina deimiya ꞌimiyamiya!’ ");
INSERT INTO bdd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yagwae moisa ꞌoimiya, ꞌabwa bwaꞌomatana ꞌana tuta ꞌoina taudi gogowedi silogwahategomiya loina madou hedadena siloba, ma geya gide meSodoma ꞌadi loina.” ");
INSERT INTO bdd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Coinega tupwaedi ꞌana tomiyao ꞌihegwaediya, ꞌigwae, “MeKolesini ta meBedeseida ꞌatemuyamuyaimi. Weyahina ꞌigu paihowa ꞌebe henainaidaedi yapaihowa pwaidiya matamiya ma hesi geya wanuwabui, ma hesi ꞌeguma meTaiya ta meSaidoni ꞌoidiya yada paihowediya, beno mwalohene sida nuwabui pwaiya, ma sibauwa ꞌadi ꞌaleꞌowega sida ꞌotedi ta giba ꞌoidiyega sida gibediya, ta siheꞌitaedi ꞌabehega mumuga galana ꞌoidiyega sinuwabui pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma ꞌomi hesi geya uleulena. Coinega bwaꞌomatana ꞌana sabweloina ꞌoina Yehoba ꞌabwa meTaiya ta meSaidoni ꞌiꞌatemuyamuyaedi, ma ꞌomi geya. ");
INSERT INTO bdd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma meKapaneumi ꞌomi togidega, ꞌabehega waꞌabilagasigomi galewa, ꞌawa? Nata geya! Ma hesi nata siulasuluhegomi Bwebweso ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ta ꞌana tomuliyaowedi ꞌoidiya ꞌigwaeya, “Ceguma taiya ꞌimi gwae ꞌihesagohedi, beno taugu ꞌigu gwae ꞌihesagoheya. Ma ꞌeguma taiya ꞌilogwahategomi taugu wete ꞌilogwahategauwa. Ma wete ꞌagu Tohewasaina ꞌilogwahateya.” ");
INSERT INTO bdd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma ꞌana tomuliyaowedi site sebeniti ꞌidi paihowega sihilama, ta maꞌidi yaliyaya Yesu ꞌoina siheꞌoteꞌotetela, sigwaeya, “Bada, ꞌeguma welabanao bo hiꞌahiꞌa saniuwega ꞌaloinaediya, ta sihapwesa.” ");
INSERT INTO bdd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Yesu ꞌoidiya ꞌigwaeya, “Tomudulele yaꞌiteya galewega ꞌisulusuluma gide tuwa namala ꞌina pili. ");
INSERT INTO bdd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Coinega wasanapu ꞌabehega yaꞌabihewaiwai pwaigomiya ma ꞌoinega sowasowahimi wahewaiwai ꞌada ꞌalehaina ꞌina paihowa mabwaiyana ꞌoidiya, ma ꞌeguma mwata bo ganihana wabasa yahidi, sahena wamatamatauta, weyahina gesowana toꞌaha siꞌabihe galegomi.” ");
INSERT INTO bdd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ta wete ꞌihegwaediya, “Moisa ꞌimi paihowa hiꞌahiꞌa ꞌoidiya waiwaina, ta weyahina wayaliyaya, ma beno geya ginaula madouna, ma hesi ꞌimi ꞌebeyaliyaya madouna ꞌeguma sanimi galewa silele pwaidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tuta nage ꞌoina Yaluyaluwa Tabuna Yesu ꞌiꞌabihe yaliyayaeya, ta ꞌigwaeya, “Yauwedo Tamagu, ꞌowa galewa ta baleꞌu ꞌadi Toloina, nuwasabwalena bewa ꞌudahweya tosonogao ma tonuwasabwalenao ꞌoidiyega, ma hesi gwagwama ꞌiꞌiudi ꞌoidiya ꞌuheꞌitaeya. Moisa Tamagu, ꞌino nuwatuhu bwebweꞌana bewa.” ");
INSERT INTO bdd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nage tutaina ꞌoina wete ꞌigwaeya, “Ginaula mabwaiyadi Tamagu nimaguwa ꞌilagudiya, ma Tamagu ꞌiboimo ꞌisanapugauwa, ma Taugu wete yaboimo Tamagu yasanapuya, ma wete taiyewedi taudi ꞌeguma nuwanuwagu ma Tamagu yaheꞌitae ꞌoidiya, taudi wete sida sanapu.” ");
INSERT INTO bdd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Coinega Yesu ꞌiloꞌita lohihila ꞌana tomuliyao ꞌoidiya ma ꞌihegwaediya, ꞌigwae, “Comi maꞌimi yaliyaya, weyahina ginaulaedi matamiyega waꞌitaꞌita. ");
INSERT INTO bdd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yagwae moisa ꞌoimiya ꞌabehega mwalo palopitao ta toloinao baibaiwadi nuwanuwadi ma ginaulaedi siꞌitadi, ma hesi geya siꞌitaꞌita, ta wete gwaeyedi wahesagohediya taudi wete nuwanuwadi ma ꞌabehega sihesagohedi, ta geya sida hesagohediya.” ");
INSERT INTO bdd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma ꞌaigeda loina ꞌana tohanugeta ꞌitauyama ma Yesu ꞌoina ꞌihesilala sabi tohona, ꞌigwaeya, “Bada, toꞌaha yapaihowa ma yawasigu hataya yada loba?” ");
INSERT INTO bdd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Coinega Yesu ꞌigwaeya, “Loinaedi Mosese ꞌilelediya Buki Heꞌasisi ꞌoina, ꞌusanapu pwaidiya, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma loheyaina ꞌigwaeya, “Cehe, loina bewa gidemusa, ‘Cino Bada Yehoba ꞌuda helauwe ꞌateu ta yaluyaluwau ta ꞌino waiwai ta ꞌino nuwatuhu mabwaiyadi ꞌoidiyega. Ma wete ꞌiyamwao ꞌuda helauwedi gidemusa ꞌuboi ꞌuhelauwego.’” ");
INSERT INTO bdd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Coinega Yesu ꞌigwaeya, “Beno gwae moisa, ꞌoinega gide ꞌuda paihowa ꞌese ma yawasiu hataya ꞌuda loba.” ");
INSERT INTO bdd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma loheyaina ꞌina nuwatuhu ꞌabehega tauna todumwalu, ꞌoinega Yesu wete ꞌoina ꞌihesilala hila, “Taiya hede ꞌiyagu?” ");
INSERT INTO bdd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Coinega Yesu gwae hegehegediyega loheyaina ꞌihegwaeya, ꞌigwae, “Caigeda loheya Yelusalemega ꞌitoholowa ma ꞌitautauya Yeliko, ta ꞌedai toyagaha ꞌilobediya ma siꞌabiyahiya, ꞌana ꞌaleꞌo siꞌigalidiya ta sihunu geyogeyoiya, ꞌiꞌiunamo ꞌiꞌamasa, ma siꞌebesineya ma sitauya. ");
INSERT INTO bdd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sitauya, ma loheyaina ꞌiꞌenoꞌeno eeta ꞌaigeda topwaoli ꞌihapwesama, ma tohesilaeina ꞌiꞌiteya, ma ꞌinaowa ma ꞌeda papalinega ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta wete gide topwaoli ꞌadi tolema ꞌaigeda ꞌitauyama, ta loheyaina ꞌiꞌiteya, ta wete ꞌiꞌeꞌebubuyamo ma ꞌiꞌebesineya. ");
INSERT INTO bdd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma muliyetega ꞌaigeda gwama Sameliya ꞌihapwesama, ma loheyaina ꞌiꞌiteya ta ꞌiꞌatemuyamuyaeya. ");
INSERT INTO bdd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Coinega deina ꞌinaowa, ma holowa ta waini ꞌilagu latuhediya, ma ꞌana hesilaeyedi ꞌoidiya ꞌisiwediya ma ꞌipaidiya, ta muliyega ꞌina hebai ꞌoina ꞌidoꞌoya ma baꞌidana sitauya ꞌaigeda hada taumana ꞌoina ta nobwa ꞌiꞌitayahiya. ");
INSERT INTO bdd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gona ꞌiꞌadaleya, ma kina ꞌeluwa ꞌiꞌewediya ma hadaina ꞌana toꞌitayahina ꞌiꞌebwaeya, ta ꞌihegwaeya, ‘Tohesilae bewa ꞌuꞌitayahi weyahigu, ma ꞌeguma ꞌehisa wete mane ꞌulaguya weyahina, taugu yahilama yagihedumwalu ꞌoiuwa.’” ");
INSERT INTO bdd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Coinega Yesu loheyaina ꞌihesilaleya ꞌigwae, “Taiya tohesilaeina ꞌiyana sitetoiyedi ꞌoidiyega?” ");
INSERT INTO bdd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma loheyaina ꞌigwaeya, “Tauna ꞌana tohelauina.” Coinega Yesu ꞌigwaeya, “Beno gwae moisa, ꞌutauya ma gidemusa ꞌupaihowa ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ma Yesu maꞌana tomuliyao sitauya ta silatuwa ꞌaigeda tupwa ꞌoina, ma wahine ꞌaigeda, sanina Malida ꞌitoeya ꞌina hada. ");
INSERT INTO bdd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma wahineina tasina wete ꞌimiyamiya, sanina Meli, ma Meliina ꞌinaoma ta Yesu deina ꞌimiyatoiya, ma ꞌina gwae sabi hesagohena. ");
INSERT INTO bdd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Malida ꞌiꞌeꞌuleya ta ꞌina paihowa baibaiwana. Coinega Malida ꞌinaoma Yesu ꞌoina ma ꞌigwaeya, “Bada togidega ma tasigu baꞌidau wamiyamiya, ma geya ꞌida lemegauwa? Sowasowahina ꞌuhegwae ma ꞌiꞌabihetegau ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ta Yesu ꞌigwaeya, “Malida, togidega ma ginaula mabwaiyana weyahidi ꞌunuwanuwatuhu, ");
INSERT INTO bdd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ma hesi ꞌaigedamo ginaula madouna weyahina ꞌunuwatuhu, gidemusa tasiu Meli ꞌina hesinuwa. Meli nuwanuwana ma ꞌigu gwae ꞌida hesagohedi, ꞌoinega geya sowahina ꞌaigeda taiya ꞌiꞌausi.” ");
INSERT INTO bdd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Caigeda tuta Yesu ꞌiboinamo tupwa ꞌaigeda ꞌoina ꞌiꞌahwaꞌahwanoi. Cina ꞌahwanoi mulina ꞌana tomuliya ꞌaigeda ꞌihegwaeya, ꞌigwae, “Bada, ꞌahwanoi ꞌuheꞌitemai, gidemusa Yoni ꞌana tomuliyao ꞌahwanoi ꞌiheꞌita ꞌesediya.” ");
INSERT INTO bdd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Coinega Yesu ꞌoidiya ꞌigwaeya, “Bewa gide waꞌahwanoi ꞌesa, wagwae: Tamama, saniu ꞌaheꞌasisiyane. Caꞌahwanoi ꞌoiuwa ma ꞌane ꞌuloinemai. ");
INSERT INTO bdd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cama sabwelo ꞌaigeda ꞌaigeda nata ꞌuꞌebwaemai. ");
INSERT INTO bdd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ta ꞌima mumuga galadi ꞌunuwasamudi weyahina ꞌiyamayao ꞌidi puiyao ꞌoima ꞌanuwasamudi. Ma hesi sahena ꞌutohotohomai.” ");
INSERT INTO bdd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma Yesu wete ꞌoidiya ꞌigwaeya, “Cahwanoi ꞌana sanapu bewa gidemusa. Ceguma taiya ꞌowa ꞌaigeda ꞌa taumana hinuwana gamwana ꞌitauyawa ꞌoiuwa, ma geya ꞌaigeda toꞌaha ꞌoiuwa ma ꞌuꞌebwae ꞌana lohepaꞌala weyahina, ꞌoinega ꞌilobwainegowa ma ꞌiyau ꞌaigeda ꞌoina ꞌutauya ma ꞌuꞌahwanoi, ma ꞌugwae, ‘Ciyagu, sowasowahina ma ꞌulemegau ma beledi ꞌetoi ꞌuꞌebwaegau, ");
INSERT INTO bdd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","weyahina ꞌaigeda ꞌiyagu nige ꞌeda dudulenega ꞌitauyama, ma geya ꞌeta toꞌaha ꞌoiguwa ma ꞌida lohepaꞌala.’ ");
INSERT INTO bdd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma ꞌeguma loheyaina hada ꞌalonega ꞌino gwae ꞌihemaiseyawa ma ꞌigwae, ‘Ciyagu, sahena wahiꞌwataꞌwata ꞌulagulagu weyahina manatugwao ꞌaꞌenoꞌeno, ma wete ꞌahwaꞌeda yaꞌausiya, ꞌoinega geya sowasowahina yalemego.’ ");
INSERT INTO bdd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma ꞌeguma ꞌihegagala ꞌoiuwa tuwa ꞌuꞌalaꞌoheꞌohe, ma ꞌoinega ꞌida ꞌenotoholo, ma toꞌaha ꞌino ꞌahwanoi gidemusa ꞌiꞌebwaego. ");
INSERT INTO bdd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Coinega yahepwaila ꞌoimiya, waꞌahwanoi ma nata Yehoba ꞌiꞌebwaegomi. Wete waꞌebesa ma nata waloba, ma wete waꞌetunatuna ma ꞌoinega ꞌahwaꞌeda ꞌisoꞌe weyahimi. ");
INSERT INTO bdd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Weyahina ꞌeguma taꞌahwanoi Yehoba ꞌiꞌebwaya ꞌoida, ma wete ꞌeguma taꞌebesa wete nata taloba, ma wete ꞌeguma taꞌetunatuna, ꞌoinega ꞌahwaꞌeda ꞌida soꞌe. ");
INSERT INTO bdd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ma togidega ꞌomi gwagwama tamadiyao, ꞌeguma natumiyao silahana weyahina siꞌahwanoi, mwata waꞌebwaedi? ");
INSERT INTO bdd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nuwana pou weyahina siꞌahwanoi ganihana waꞌebwaedi? Geya bo? ");
INSERT INTO bdd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Moisa, ꞌomi togala ma ꞌimi ꞌebwaya natumiyao ꞌoidiya wasanasanapu ꞌabehega ginaula bwebweꞌana waꞌebwaꞌebwaedi. Gide wete Tamamiu galewa ꞌina ꞌebwaya ꞌoimiya bwebweꞌana hedada, ma ꞌeguma waꞌahwanoi ꞌoina, nata Yaluyaluwa Tabuna ꞌiꞌebwaegomi.” ");
INSERT INTO bdd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma tutaina Yesu loheya ꞌaigeda ꞌilobeya, tauna hiꞌahiꞌa ꞌina paihowega memenana ꞌilidowa ma geya ꞌida gwaeya, ꞌoinega Yesu hiꞌahiꞌaina ꞌiula latuheya, eeta loheyaina ꞌibwebweꞌana ma ꞌigwaeya. Nage ꞌoina tomota siꞌiteya ma nuwadi ꞌihenainaida. ");
INSERT INTO bdd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Coinega tupwadi sigwae, “Hiꞌahiꞌa ꞌidi badaina, Tomudulele ꞌina waiwaiyega Yesu hiꞌahiꞌaina ꞌiulalatuheya.” ");
INSERT INTO bdd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma tupwadi wete Yesu sitohoya ma ꞌabehega ꞌilaꞌilala tupwadi ꞌida paihowedi weyahidi, ma sida ꞌahwamoisa ꞌabehega ꞌina waiwai Yehoba ꞌoinega ꞌitauyama. ");
INSERT INTO bdd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Yesu bodaedi ꞌidi nuwatuhuina ꞌisanapu pwaiya, ma ꞌihegwaediya, ꞌigwae, “Tomudulele tauna ꞌiyanao gesowana ꞌipaꞌipaꞌidi.” Ma wete ꞌigwaeya, “Ceguma ꞌaigeda ꞌebeloina ꞌoina loheloheya siwataha ma siboi siloꞌaleha, nata ꞌebeloinaina ꞌiweꞌa ma ꞌibeꞌu. Ma wete gidemusa ꞌeguma ꞌaigeda susu taudimo siloꞌaleha, nata ꞌabwa ꞌidi miya ꞌigala. ");
INSERT INTO bdd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitani wete gidemusa ꞌeguma maꞌina bodao siboidimo siloꞌaleha nata ꞌina ꞌebeloinaina ꞌibeꞌu. Ma togidega ma wagwae ꞌabehega Tomudulele ꞌina waiwaiyega hiꞌahiꞌa yaula latuhedi, ");
INSERT INTO bdd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ma taiya hede ꞌina waiwaiyega ꞌomi hiꞌahiꞌa waula latuhedi? Tomudulele ꞌoinega bo Yehoba ꞌoinega? Bewa weyahina wanuwanuwatuhu ma wasanapu ꞌabehega taiya taugu. ");
INSERT INTO bdd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma taugu hesi Yehoba ꞌina waiwaiyega hiꞌahiꞌa yaulaula latuhedi, ꞌoinega wada sanapu ꞌabehega Yehoba ꞌina loina ꞌilatu pwaima ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Seitaniina tauna gide ꞌaigeda loheya waiwaina, ta maꞌina ꞌebe ꞌaleha ꞌina hada madouna ꞌiꞌitaꞌitayahi, ma geya sowana ꞌaigeda taiya ꞌina tobwatobwa ꞌiꞌabihegala. ");
INSERT INTO bdd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma ꞌeguma ꞌaigeda loheya waiwai hedada ꞌihapwesama, nata loheyaina ꞌipai ma ꞌina ꞌebe ꞌaleha nimanega ꞌiꞌewadi, ma ꞌina tobwatobwa mabwaiyadi ꞌiꞌewadi ma ꞌiyanao ꞌiꞌebwaedi. ");
INSERT INTO bdd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ceguma taiyawedi taudi geya ꞌagu toꞌabihetena, taudi ꞌagu ꞌalehao. Ma wete taiyawedi taudi geya baꞌidagwao ꞌada paihowa hegogona, taudi ꞌigu paihowa siꞌabihegaleya. ");
INSERT INTO bdd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ma ꞌeguma hiꞌahiꞌa loheya ꞌaigeda ꞌoinega ꞌihapwesa, loheya ꞌida bwebweꞌana ma hiꞌahiꞌaina nata tuwa ꞌatamana ꞌiyawayawala besobeso ma ꞌina ꞌebeꞌaiyawasi ꞌibesabesa ma gesowana ꞌilobaloba. Coinega hiꞌahiꞌaina ꞌiboinamo ꞌigwae, ‘Cana ꞌita yahila ꞌigu ꞌebemiya ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Coinega ꞌihila ma ꞌebemiyaina ꞌiloba hileya ꞌasiꞌasilalana ma ꞌatuꞌatububuna. ");
INSERT INTO bdd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eeta ꞌitauya ma hiꞌahiꞌa site sebeni galadi moisa wete ꞌitoedima, ma baꞌidanao siluhuwa ꞌebemiyaina ꞌoina, ta nobwa mahetenao simiyamiya, ꞌoinega loheyaina ꞌina ꞌebemiya siꞌabihegala bwaibwainiya, mwalo geya gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gidemusa Yesu ꞌigwae ꞌesa boda ꞌoidiya, ma ꞌaigeda wahine ꞌoidiyega ꞌenana madounega ꞌiwuiya, ma Yesu ꞌoina ꞌigwaeya, “Bada wahineina tauna gamwanega ꞌihenatunegowa ma wete susunega ꞌususuwa, tauna toyaliyaya moisa.” ");
INSERT INTO bdd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma Yesu wete ꞌigwaeya, “Taudi hesi ꞌeguma Yehoba ꞌina gwae sihesagohe ma ꞌina gwae sihematamatane, taudi toyaliyaya moisa.” ");
INSERT INTO bdd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma bodaedi Yesu sitoholo ꞌwabuꞌwabuneya, ma ꞌiꞌahwa lalagata ma ꞌoidiya ꞌigwaeya, “Mehau ꞌomi galami! Beno lamuna ꞌilaꞌilala waꞌebeꞌebese, ma sahena hesi ꞌilaꞌilalaedi waꞌitaꞌitadi. Ma ꞌiyamo Yona weyahina ꞌeguma wanuwatuhuyahi, tauna tuwa ꞌilaꞌilalaina weyahimi. ");
INSERT INTO bdd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Weyahina Yona ꞌina paihowa ꞌoinega meNinibe sisanapuya ꞌabehega tauna Yehoba ꞌoinega ꞌinaoma. Gide wete taugu Loheyaiguina ꞌigu paihowa ꞌoidiyega mehau ꞌomi wada sanapugau ꞌabehega Yehoba ꞌoinega yanaoma. ");
INSERT INTO bdd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cabwa hesi, sabwelo bwaꞌomatana ꞌoina meSiba ꞌidi kuini ꞌida toholo ma mehau ꞌomi ꞌiheꞌewegomi, weyahina mwalo hene wahineina bwagebwagega ꞌinaoma Solomoni ꞌina gwae sanasanapuna sabi hesagohena, ma bewa tuwa gwae sanasanapu hedada wahesagohediya, ma genuwami. ");
INSERT INTO bdd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wete gide sabwelo bwaꞌomatana ꞌoina meNinibe ꞌabwa sitoholo ma mehau ꞌomi siheꞌewegomi, weyahina mwalo hene Yona ꞌoidiya ꞌiguguya, ta mumugadi galadiyedi ꞌoidiyega sinuwabuiya, ma ꞌomi bewa tuwa guguya bwebweꞌana hedada wahesagohediya, ma geya wanuwabui hila. ");
INSERT INTO bdd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Geya ꞌeta taiya mayale ꞌigabu ma ꞌidahwa gaula, nuwana gaeba gabulena, ma hesi ꞌebelagu tabwanina ꞌilagu ma ꞌoinega taudi hada ꞌana toluhuwao ꞌiꞌasilaladi. ");
INSERT INTO bdd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Weyahina matau wahiu ꞌana ꞌasilala gide, ma ꞌeguma matau ꞌasiꞌasilalaina wahiu mabwaiyana wete ꞌasiꞌasilalaina. Ma ꞌeguma matau ꞌigala wahiu mabwaiyana wete ꞌiguguyou. ");
INSERT INTO bdd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Coinega ꞌuꞌitayahigo tabu ma ꞌino ꞌasilalaina ꞌiguguyou. ");
INSERT INTO bdd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ma ꞌeguma wahiu mabwaiyana ꞌasilala ꞌoina ꞌimiyamiya, ma geya ꞌaigeda wete guguyou ꞌoina, mabwaiyana tuwa ꞌasiꞌasilalaina, gide tuwa ꞌasilala madouna ꞌina ꞌasilala.” ");
INSERT INTO bdd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ꞌina gwae ꞌigumwala pwaiya, ma ꞌaigeda Palisi Yesu ꞌibwauweya ma mahetena siꞌai. Coinega ꞌiluhuwa ma ꞌimiyatoiya ꞌebeꞌai ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma Palisiina nuwana ꞌihenainaida weyahina Yesu ꞌiꞌiteya nimana geya ꞌibuyodi ma ꞌiꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Yesu Palisiina ꞌina nuwatuhuina ꞌisanapu pwaiya, ꞌoinega ꞌoina ꞌigwaeya, “Comi Palisiyao gide tuwa biyo ma gaeba, weyahina gwahumiumo wabuyobuyodi, ma ꞌalomiya ꞌimaha moisa yagaha ma mumuga galadi ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Waheyauyauleya! Weyahina geya wasanasanapu ꞌabehega tauna ꞌwapimi ꞌipaihowediya, ꞌatemi wete ꞌipaihowedi. ");
INSERT INTO bdd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma ꞌilobwainegomiya ma ꞌatemi ꞌeheꞌehele ꞌoinega waꞌabihe ꞌasilaladi, ma ꞌoinega waꞌasilala bwaibwaina. ");
INSERT INTO bdd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ma ꞌomi Palisiyao hesi ꞌatemuyamuyaimi! Tuwa ꞌimi helau bwebweꞌana, weyahina helauina ꞌana loina mabwaiyana waꞌitayahi bwaibwainiya, ꞌimi tobwatobwa madoudi ma ꞌiꞌiudi ꞌoidiyega tupwana Yehoba waꞌebwaꞌebwae, gide hali pam ma hali pam ꞌoidiyega. Ma hesi loina tuwa madoudi wanuwanaidediya, beno Yehoba ꞌana helau ta wete loina dumwadumwaluna. Sowasowana ginaula bewa madoudi wapaihowadi, ma wete sahena ginaula ꞌiꞌiudi wanuwanuwa naidedi. ");
INSERT INTO bdd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Comi Palisiyao ꞌatemuyamuyaimi, weyahina hada tapwalolo ꞌoidiya nuwanuwami ma ꞌabehega ꞌebemiya bwebweꞌana ꞌoidiya wamiyatoi, ma wete nuwanuwami ma ꞌabehega tutaina ꞌeguma watautau ꞌasai tomota mabwaiyadi siheꞌasisiyegomi. ");
INSERT INTO bdd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ma hesi tuwa ꞌatemuyamuyaimi, weyahina ꞌatemi gide galiha bisubisulidi, tomota ꞌoidiyega sitautau ma geya sisanasanapu ꞌabehega galiha.” ");
INSERT INTO bdd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ma ꞌaigeda loina ꞌana tohanugeta Yesu ꞌihegwaeya, ꞌigwae, “Bada, ꞌino gwaeyedi bewa ꞌoidiyega ꞌusinalimaiya, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yesu ꞌoina ꞌigwaeya, “Comi wete loina ꞌana tohanugetao ꞌatemuyamuyaimi, weyahina tomota ꞌahaꞌahala mwaudi waꞌebwaꞌebwaedi, ma ꞌomi geya hesi wada tagwala ma ꞌahaꞌahalaedi ꞌoidiyega walemedi. ");
INSERT INTO bdd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Catemuyamuyaimi, weyahina tubumiyao mwalo palopitao siloheꞌamasidiya, ma ꞌomi palopitaowedi galihidi ꞌoidiya ꞌadi ꞌebenuwatuhu yahina waꞌabiꞌabidi. ");
INSERT INTO bdd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ginaula bewa ꞌoinega tubumiyao ꞌidi loina waꞌahwa bwebweꞌaneya, beno taudi palopitao siloheꞌamasidiya, ma ꞌomi galihidi ꞌoidiya ꞌadi ꞌebenuwatuhu yahina waꞌabidi. ");
INSERT INTO bdd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ginaulaedi weyahidi Yehoba ꞌina sanapu ꞌilaguya, ꞌigwae, ‘Cabwa tupwadi palopitao ma ꞌigu tohepwailao yahesumanediwa, ma tupwadi waloheꞌamasidi ma tupwadi nata wapaꞌidi.’ ");
INSERT INTO bdd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Coinega mehau ꞌomi nata maisa mabwaiyana waloba palopitaowedi baleꞌu ꞌebehagaina ꞌoinega ma nige ꞌadi loheꞌamasa weyahina, ");
INSERT INTO bdd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","beno Ebeli siloheꞌamasiya ma ꞌoinega siloloheꞌamasa ma ꞌana siga Sakaliya ꞌina tuta ꞌoina siloheꞌamasiya Hada Heꞌasisi ma ꞌebepwaoli gamwagamwanidiya. Moisa tuwa loheꞌamasaedi mabwaiyadi ꞌadi maisa mehau ꞌomi waloba. ");
INSERT INTO bdd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Comi loina ꞌana tohanugetao ꞌatemuyamuyaimi, weyahina sanapu ꞌana ꞌahwaꞌeda waꞌausiya, ma ꞌomi geya sowasowahimi waluhu, ma taudi wete nuwanuwadi ꞌabehega siluhu ta ꞌomi waꞌausidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma tupwainaina nage Yesu ꞌiꞌebesineya, ma muliyetega loina ꞌana toheꞌitao ta Palisiyao sitohowaiwai hesilala baibaiwadi ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ꞌabehega togidega ma ꞌina gwae pui siloba, ma ꞌoinega siheꞌewa. ");
INSERT INTO bdd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Boda madou hedada siꞌetoꞌautama ma sihetupa duidui, ma Yesu ꞌigwae nugeta ꞌana tomuliyao ꞌoidiya, ꞌigwaeya, “Waꞌita yahigomi ma Palisiyao ꞌidi paihowa ꞌaboꞌabo sahena wapaipaihowadi, weyahina ꞌidi paihowa gide tuwa pwalawa ꞌana ꞌebeꞌabi heseseha. Cebeꞌabi hesesehaina ꞌeguma toꞌaha gide ꞌiꞌiuna, nata ꞌiꞌabi hemadou, ");
INSERT INTO bdd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ma ginaulaedi dahwadahwaidi ꞌabwa Yehoba ꞌiꞌabilatuhedi ma siloꞌatamanedi. ");
INSERT INTO bdd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma wete toꞌaha guguyou ꞌoina wagwaeneya nata sabwelo ꞌoina tomota sihesagohe. Ma toꞌaha weyahina waheꞌahwa henahena hada ꞌalona, nata tomota mabwaiyadi ꞌoidiya sihepwaila latuhedi. ");
INSERT INTO bdd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ma ꞌiyagwao yahegwaegomi, taudi wahimi siloheꞌamasi, sahena wamatamatautedi, weyahina taudi wahimimo sowasowahina ma siloheꞌamasi, ma yaluyaluwami geya. ");
INSERT INTO bdd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma hesi Yehoba wamataute, weyahina tauna maꞌina loina ma ꞌiloheꞌamasa nugetegomi ma muliyetega ꞌiula suluhegomi ꞌasa ꞌalaꞌalata* ꞌoina. Moisa tuwa, ꞌiboinamo wamataute! ");
INSERT INTO bdd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Hisa gidemusa dinegwa ꞌadi maisa? Geya madouna, gidemusa toea ꞌeluwamo ma bwasumo nima ꞌaiꞌaigeda ꞌadi baibaiwa. Ma tuwa Yehoba geyaꞌabwa wete ꞌaigeda ꞌoidiyega ꞌinuwa nuwanaide. ");
INSERT INTO bdd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ma ꞌiyamo geya sowasowahina ma deba wahasili mwagu ꞌaigeda ꞌoina, Yehoba ꞌadi baibaiwa ꞌisanasanapudi. Coinega sahena waꞌateꞌateyoho, weyahina ꞌomi Yehoba ꞌina ginaula madouna, ma dinegwa geya ginaula madouna. ");
INSERT INTO bdd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ma bewa wete wasanapu bwaibwaini: Ceguma taiyawedi weyahigu tomota matadiya sihepwaila, taugu Loheyaiguina nata weyahidi yada hepwaila Tamagu ꞌina aneloseyao matadiya. ");
INSERT INTO bdd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma ꞌeguma taiyawedi siuhalegau tomota matadiya, taugu wete ꞌabwa Yehoba ꞌina aneloseyao matadiya yauhaledi. ");
INSERT INTO bdd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taugu Loheyaiguina, ma ꞌeguma taiya ꞌiꞌahwa galegalegau, Yehoba nata gwaeina ꞌinuwasam. Ma ꞌeguma taiya Yaluyaluwa Tabuna ꞌiꞌahwa galegale, nata geyaꞌabwa Yehoba ꞌinuwanuwasam. ");
INSERT INTO bdd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma ꞌeguma tomota sitoegomi hada tapwalolo ꞌoidiya sabi heyatalaegomi babadao ta toloinao matadiya, sahena waꞌateꞌateyoho bo nuwana wanuwanuwatuhu togidega ꞌidi hesilalaina wahemaisa ꞌese, ");
INSERT INTO bdd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","weyahina ꞌabwa tutaina beno ꞌoina Yaluyaluwa Tabuna baꞌidamiu, ma nata tauna ꞌiheꞌitegomi toꞌaha wagwaene.” ");
INSERT INTO bdd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma bodaedi ꞌoidiyega ꞌaigeda tomota ꞌigwaeya, “Toheꞌita, tasigu ꞌuhegwae ma tupwana ꞌebeloina ꞌiꞌebwaegau, mwalo tamamai ꞌilaguya.” ");
INSERT INTO bdd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Yesu loheyaina ꞌenana ꞌihemaiseya, ꞌigwae, “Loheya, taugu geya sowasowahigu ma yahetoloina ꞌami heguheguyaiina weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma wete ꞌina gwaeina ꞌitubweya ma boda mabwaiyadi ꞌoidiya ꞌigwaeya, “Waꞌitayahigomi ma sahena wasawasa nuwami ꞌiꞌewaꞌewa. Geya sowasowahina ma wasawasa ꞌoinega yawasimi bwebweꞌana waloba.” ");
INSERT INTO bdd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Coinega ꞌebeꞌita ꞌiꞌebwaediya gwae hegehegediyega, ꞌigwaeya, “Caigeda tohewasawasa ꞌina tanoha madoudi ma baibaiwadi, ta ꞌeliꞌeli madouna ꞌoidiyega ꞌilobeya. ");
INSERT INTO bdd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eeta loheyaina ꞌiboinamo ꞌinuwatuhu dadana, ma ꞌigwaeya, ‘Celiꞌeli madouna ta ꞌigu hada ꞌeꞌahai geya sowasowahina. Coinega toꞌaha yapaihowa? ");
INSERT INTO bdd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nuwana bewa gidemusa, hada ꞌeꞌahai miyamiyadi yaleꞌwa yahuledi, ma hauhaudi ta madoudi yaꞌabidi, ma ꞌoidiya ꞌeꞌahai ta wete ꞌigu tobwatobwao mabwaiyana yahedodo, ");
INSERT INTO bdd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ma muliyetega maꞌigu yaliyaya sowasowahigu ma yagwae, “Caigeda towasawasa taugu. Boꞌi yaꞌatububuwa ta ꞌigu wasawasao mabwaiyana sowasowahigu bolime hisa sinaonaoma weyahidi. Eeta paihowa ꞌoinega yaꞌaiyawasi, ma hesi tuwa yaliyayamo, weyahina ꞌagu ma ꞌagu weꞌaha mabwaiyana sowasowahigu.” ’ ");
INSERT INTO bdd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma Yehoba loheyaina ꞌoina ꞌigwaeya, ‘Loheya yauyauleiu! Hinuwana bewa yawasiu ꞌilolagu, ma tobwatobwaedi ꞌulagulagudiya, taiya nata weyahina?’” ");
INSERT INTO bdd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma Yesu ꞌina gwae ꞌana ꞌebelolagu ꞌoina ꞌigwaeya, “Moisa, ꞌeguma taiya wasawasa weyahina ꞌipaihowa, ma ꞌimiya wasawasa tobwatobwa baleꞌuwa ꞌoidiyega, ma geya galewa ꞌana wasawasa ꞌoidiyega, tauna yauyauleina!” ");
INSERT INTO bdd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Coinega ꞌana tomuliyao ꞌoidiya ꞌigwaeya, “Sahena ꞌimi miya weyahina wanuwanuwatuhu madouna, ꞌamiwa ma ꞌami ꞌaleꞌo weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Weyahina yawasida ginaula madouna mabwaiyada ꞌoida, ma tobwatobwaedi ꞌwapi weyahina geya ginaula madouna. ");
INSERT INTO bdd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Bewa ꞌaigeda ꞌebeꞌita yaꞌebwaegomi ꞌaoꞌao weyahidi, tuta baibaiwana geya sida dauna, geya sida ꞌetahiya, ma wete geya ꞌidi hada ꞌeꞌahaimo. Bwasumowedi ginaula ꞌiꞌiudi, ma tuwa Yehoba tuta baibaiwana ꞌadiwa ꞌiꞌebwaꞌebwaedi, ma hesi wanuwatuhuyahi ꞌabehega ꞌomi ginaula madouna Yehoba ꞌoina, ꞌoinega sowasowahina ma ꞌiheꞌaigomi. ");
INSERT INTO bdd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Taiya ꞌoimiyega sowasowana ꞌina nuwatuhuwega ꞌina tuta baleꞌuwa ꞌiꞌabiheduduli? Geya, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Moisa tuwa, ꞌateyoho geya wete ꞌina lema ꞌoida ginaula ꞌiꞌiuna weyahina, ma toꞌaha lamuna waꞌateꞌateyoho ginaula madouna weyahidi? ");
INSERT INTO bdd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ma ꞌaigeda wete bewa ꞌebeꞌita, hane ꞌidi bwala weyahina wanuwanuwatuhu. Tuta baibaiwana geya sida paihowa, ma wete geya ꞌadi ꞌaleꞌo sida paihowediya. Ma moisa tuwa, Solomoni ꞌana ꞌwamao ma ꞌana pasao ꞌadi ꞌita ꞌausaladi, ma hesi hane ꞌadi ꞌita ꞌausala hedadena. ");
INSERT INTO bdd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Coinega wanuwanuwa Yehoba ꞌina ꞌitayahina ꞌoimiya weyahina. Tauna ꞌawata ꞌihepasediya hoyadi bwebweꞌadi ꞌoidiyega, nata sididi ma gona siwelai ma sigabudi, ma ꞌomi ꞌawata wabwebweꞌana sinediya, ꞌoinega sowasowana ꞌami ꞌwamao Yehobaina ꞌiꞌebwaegomi. Ma ꞌiyamo sahena ꞌimi hemisa Yehoba ꞌoina ꞌiweꞌaweꞌa. ");
INSERT INTO bdd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ma weteyage sahena wanuwanuwatuhu madouna nuwana waꞌateyoho ꞌeꞌahai weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tomiya baleꞌu mabwaiyadi ginaulaedi weyahidi sinuwanuwatuhu, ma toꞌaha ꞌimi nuwatuhu Yehoba ꞌisanapu pwaidiya, gidemusa ꞌamiwa ta ꞌami weꞌaha ta wete ꞌami ꞌwama. ");
INSERT INTO bdd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ma ꞌilobwainegomiya nugeta Yehoba ꞌina loina ꞌoina watagwalegomi, ma ꞌoinega ꞌamiwa ta ꞌami ꞌwama wete ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma ꞌomi moisa Yehoba ꞌina sipiyao, ꞌoinega sahena waꞌateꞌateyoho, weyahina tauna ꞌihesinuwa paigomiya ma ꞌina ꞌebeloina ꞌoina waluhu. ");
INSERT INTO bdd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Coinega ꞌimi tobwatobwao wahegimwaneyedi ma maneyedi waheguyaiyedi towewelohe ꞌoidiya, ma ꞌoinega galewa ꞌimi wasawasa ꞌimiya hataya. Wasawasaina galewa ꞌimiyamiya geya wete ꞌina ꞌebegumwalamo, weyahina geya ꞌaigeda wete toyagaha tupwaina ꞌoina, ma wete geya sohusohu. ");
INSERT INTO bdd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma ꞌeguma to tupwa ꞌoina ꞌimi wasawasa ꞌimiyamiya beno ꞌoina ꞌimi nuwatuhu sipili. ");
INSERT INTO bdd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Coinega waꞌatububu bwaibwaina ma ꞌami ꞌwamao waꞌotedi, ta wete maꞌimi mayale ꞌasiꞌasilaladi ma wayamwayamwa, ");
INSERT INTO bdd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","gidemusa hewahewaliyao ꞌidi bada siyamwayamwa ꞌina hilama hai ꞌeꞌahaina ꞌoinega. Ma ꞌeguma to tuta ꞌoina ꞌilatuma ma ꞌahwaꞌeda ꞌoina ꞌiꞌetunatuna, dumwaluna tuwa ꞌahwaꞌedaina sisoꞌe ma ꞌiluhuma. ");
INSERT INTO bdd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma ꞌeguma simata paꞌali ma siꞌatuꞌatububudi ma siyamwayamwa ma ꞌilobadi, nata siyaliyaya madouna. Yagwae moisa ꞌoimiya ꞌidi badaina nata ꞌwama ꞌebe paihowa ꞌiꞌote, ma hewaliyaowedi simiyatoi ma tauna weyahidi ꞌida hetopaihowa. ");
INSERT INTO bdd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ma wete ꞌeguma ꞌina tuta hilama ꞌoina ꞌiheheboi, ma hinuwana gamwana nuwana gona ꞌadaꞌadale ꞌilatuma, ma tuwa gide ꞌidi miyaina, ma ꞌilobadi, nata wete siyaliyaya madouna. ");
INSERT INTO bdd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ma wete ginaula ꞌaigeda bewa wanuwatuhuyahi, ꞌeguma toni hada ꞌisanapuya to tuta ꞌoina toyagaha ꞌiluhuluhu ꞌina hada, nata ꞌiꞌatububu bwaibwaina ma ꞌiꞌoꞌoyatola ma sahena ꞌina hada ꞌibwalebwale. ");
INSERT INTO bdd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Coinega ꞌomi wete waꞌatububu bwaibwaina ma ꞌigu tuta hilama weyahina wayamwegau, weyahina taugu Loheyaiguina ꞌigu hilama ꞌana tuta geya wasanapu.” ");
INSERT INTO bdd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Coinega Pita ꞌigwaeya, “Bada, beno taumamo weyahima ꞌugwaegwae, bo nuwana tomota mabwaiyadi weyahidi?” ");
INSERT INTO bdd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ta Yesu ꞌigwaeya, “Topaihowa bwebweꞌadi ma sanasanapuidi mumugadi bewa gide, ꞌeguma taiya tauna ꞌina bada ꞌihesinuwe ma hada ꞌiꞌitayahi, ma ꞌiyanao ꞌadi ꞌiꞌebwaedi sabwelo ꞌaigeda ꞌaigeda ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ꞌabwa ꞌeguma badaina ꞌihilama ma ꞌina topaihowa ꞌiloba ꞌipaipaihowa bwaibwaina, nata weyahina ꞌiyaliyaya ma ꞌoina ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","‘Cino paihowa mabwaiyana bwebweꞌana, ꞌoinega ginaula mabwaiyadi ꞌadi loina yaꞌebwaego ma ꞌuloina.’ ");
INSERT INTO bdd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma hesi ꞌeguma topaihowaina ꞌiboimo ꞌoina ꞌigwae, ‘Cigu bada ꞌabwa ꞌiheheboi, ꞌoinega taugu ꞌigu nuwatuhu yapaihowadi.’ Coinega ꞌiyanaowedi loheloheyadi ma mewahinedi ꞌisapisapidi, ma wete geya ꞌeꞌahai ꞌida ꞌebwaediya, ma ꞌiboinamo ꞌiꞌaiꞌai ma ꞌinumanuma, ma ꞌinuma yauyaule. ");
INSERT INTO bdd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ma muliyetega ꞌabwa badaina ꞌilohesalutuyama, ma ꞌina hewali ꞌina paihowa galana ꞌiꞌitaloba, nata hadega ꞌipaꞌi, ma ꞌoinega maisa gala hedadena ꞌiloba, taudi tologwahata ꞌidi tupwa. ");
INSERT INTO bdd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma ꞌeguma taiya ꞌina bada ꞌina nuwatuhu ꞌisanapu ma tuwa geya ꞌiꞌatububu ta wete geya ꞌipaihowa, ꞌabwa sapi mwauna ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta ꞌeguma taiya ꞌina bada ꞌina nuwatuhu geya ꞌisanapu, ma ꞌipaihowa pui, nata sapi ꞌiloba, ta geya madouna. Ma ꞌeguma hewali ꞌana heguheguyai madouna, ꞌilobwaineya ma ꞌina bada weyahina ꞌipaihowa madouna; ta ꞌeguma ꞌana heguheguyai madou hedada, sowasowana ꞌipaihowa madou hedada. ");
INSERT INTO bdd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Taugu boi yatauma ma ꞌabehega ꞌaiwe yamuꞌa ꞌebwa baleꞌuwa, ta nuwanuwagu ꞌilomwayamwayau ma ꞌiꞌalata. ");
INSERT INTO bdd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma hesi tuta ꞌiꞌiuna ma babitaiso galana yaloba, ꞌoinega maꞌigu ꞌateyoho ma ꞌana siga babitaisoina ꞌoiguwa sipaihowa. ");
INSERT INTO bdd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ma togidega? Wanuwatuhuya ꞌabehega ꞌigu latuma baleꞌuwa ꞌoinega daumwala waloba? Geya hene. Ma hesi yahegwaegomi nata ꞌaleha ta wataha ꞌoimiya silatu. ");
INSERT INTO bdd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tutaina bewa ꞌoidiyega ma tuta sinaonaoma ꞌoidiya nata susu ꞌalodiya wataha silatu. Susuwedi ꞌalodiya ꞌeguma gidemusa tomota ꞌadi baibaiwa nima, nata ꞌalodiyega sitetoi siheꞌupwa siteluwa ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ma wete ꞌeguma tama natuna loheyana ꞌoina ꞌiꞌaleha, nata wete natunaina tamana ꞌoina ꞌiloꞌaleha. Gidemusa wete sina ꞌeguma ꞌiloꞌaleha natuna mewahinena ꞌoina, nata wete tauna sinana ꞌiloꞌaleha. Ma wete ꞌeguma wahine ꞌiꞌaleha lawana mewahinena ꞌoina, nata lawanaina ꞌoina ꞌiheꞌupwa hila.” ");
INSERT INTO bdd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma Yesu wete tomotaedi ꞌoidiya ꞌigwaeya, “Tutaina ꞌeguma waꞌita bolimana yaloha dubadubana sihanehanema, wanuwatuhuya ꞌabehega nata ꞌidohi, beno moisa. ");
INSERT INTO bdd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma ꞌeguma tupwa yalasi ꞌoinega yaumai ꞌitowatowama, beno ꞌoinega wasanapu pwaiya ꞌabehega tuta ꞌiꞌiuna ma hala ꞌihapwesa. ");
INSERT INTO bdd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Moisa ꞌomi baleꞌu ꞌadi ꞌilaꞌilalao wasanapu pwaidiya, ma hesi Yehoba ꞌina ꞌilaꞌilalao geya wasanapudi tuta hauhauna nage weyahina. Beno ꞌimi ꞌabo. ");
INSERT INTO bdd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ma toꞌaha lamuna ta geya wahesinuwa bwaibwaina ma ꞌeda dumwalunega watauya? ");
INSERT INTO bdd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Ma ꞌeguma ꞌa ꞌaleha ꞌinaoma ma ꞌitoego ꞌabehega ꞌiheyatalaego, ꞌilobwainegowa ma tutaina ꞌedai watautauya ꞌutoho ma galanaina ꞌupaihowa pwaiya ꞌuꞌabihedumwalu, ma ꞌoinega sahena ꞌa toheyatalaina ꞌitoetoego toloina ꞌoina, tabu ma toloinaina toloꞌalehao ꞌiloinaedi ma deliya silagugo. ");
INSERT INTO bdd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma yahegwaego hesi sahena wete ꞌulatulatu ma ꞌana siga ꞌa buki mabwaiyana ꞌuhemaisa hegumwalidi!” ");
INSERT INTO bdd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tutaina ꞌoina tupwadi loheloheya sinaoma ma Yesu ꞌoina siheꞌoteꞌotetela meGalili weyahidi, sigwaeya, “Bada, meGalili tupwadi sipwaopwaoli Yehoba ꞌoina, ma Pailato ꞌina toloꞌalehao ꞌiloinaediya ta tomotaedi siloheꞌamasidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Coinega Yesu ꞌihegwaediya, “Ma wanuwatuhu ꞌabehega taudi mumugadi galana ma ꞌiyadiyao geya galadi, ꞌoinega siloheꞌamasidiya, ꞌawa? Geya! MeGalili mabwaiyadi topui tuwa gide. ");
INSERT INTO bdd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Ma ꞌomi wete ꞌabwa waꞌamasa gide tuwa taudi, ꞌeguma mumugami galadiyedi ꞌoidiyega geya wanuwabui. ");
INSERT INTO bdd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Ma taudi meSailoma site ꞌeitiniyedi tutaina hada madouna ꞌibeꞌuwa ta ꞌiloheꞌamasidiya, togidega ꞌimi nuwatuhu ꞌabehega taudi mumugadi gala hedadena meYelusalema mabwaiyadi ꞌoidiyega, ta ꞌoinega hesilaeina silobeya? ");
INSERT INTO bdd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Geya hene! Ma hesi ꞌomi ꞌabwa ꞌeguma mumugami ꞌoidiyega geya wanuwabui, ꞌabwa waꞌamasa site ꞌeitiniyedi gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma muliyetega ꞌaigeda wete gwae hegehegedi ꞌiꞌebwaediya ꞌigwae, “Caigeda loheya ꞌina tanoha ꞌaiwe ꞌiꞌumeya gide damaya. Ma tuta baibaiwana ꞌinaonaoma ꞌaiweina ma huwaina sabi bayoina, ta geya ꞌaigeda tuta huwaina ꞌida lobeya. ");
INSERT INTO bdd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Coinega ꞌina tanohina ꞌana toꞌitayahina ꞌihegwaeya, ꞌigwae, ‘Cusanapu pwaiya ꞌabehega bolime ꞌetoi ꞌoidiya yahilahilama ꞌebwa damayaina huwaina sabi bayoina, ma huwaina geya ꞌaigeda yaloba toho. Bewa tuwa ꞌugoha yahule, weyahina baleꞌu bwebweꞌana ꞌimudamudali.’ ");
INSERT INTO bdd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma toꞌitayahinaina ꞌina bada ꞌihegwaeya, ꞌigwae, ‘Bada yo, tuwa! Sahena yagohagoha yahule, ma hesi ꞌina gala yaloba ma gawala ꞌoina yalagu, hali bolime ꞌoina taꞌita, ");
INSERT INTO bdd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ma ꞌeguma ꞌihuwa, tuwa ꞌitotoholo, ta ꞌeguma geya huwainamo, ꞌoinega ꞌugoha yahule.’” ");
INSERT INTO bdd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Caigeda Sabati ꞌoina hada tapwalolo ꞌoina ꞌiluhuwa ma ꞌiheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta ꞌaigeda wahine ꞌimiyamiya, ma bolime ꞌeitini ꞌalodiya hiꞌahiꞌa ꞌoina ꞌimiyamiya, ꞌoinega ꞌilolohala, ma ꞌina tauya tuwa ꞌihahatulutuluha, ta geya sowasowahina ꞌisapaila ma ꞌitauya dumwalu. ");
INSERT INTO bdd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma tutaina Yesu wahineina ꞌiꞌiteya ta ꞌibwauweya, “Wahine ꞌunaoma.” Cinaoma ta ꞌihegwaeya, “Caihale, ꞌa lohala ꞌoinega yalihasigo.” ");
INSERT INTO bdd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Coinega nimana ꞌilaguya wahineina ꞌoina, ma ꞌisapaila ta Yehoba ꞌihepwatuweya. ");
INSERT INTO bdd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nage ꞌoina hada tapwaloloina ꞌana toꞌitayahina Yesu ꞌina paihowa ꞌiꞌiteya, ta ꞌigamwasowala weyahina Sabatiya lohala ꞌiꞌabihe bwebweꞌaneya, ꞌoinega loheyaina boda ꞌoidiya ꞌihepwaila, ꞌigwaeya, “Cada loina tasanasanapu ꞌabehega sabwelo sikisi ꞌoidiya ꞌida paihowao tapaihowadi. Bewa geya ꞌana ꞌita bwebweꞌana ma Sabatiya tolohalao siꞌewedima ma ꞌadi lohalao taꞌabihe bwebweꞌanedi.” ");
INSERT INTO bdd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Yesu ꞌihesagoha pwaiya, ta mabwaiyadi ꞌoidiya ꞌigwaeya, “Caboꞌaboimiu, weyahina ꞌomi mumugami Sabati ꞌaigeda ꞌaigeda ꞌoidiya ꞌimi hebaiyao mabwaiyadi ꞌadi ꞌali ꞌoidiyega walihasidi, ma silatulatu ꞌatamana weꞌaha sabi numa. ");
INSERT INTO bdd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma togidega wahineina wanuwatuhuya ꞌabehega geya sowasowahina ma ꞌana mwau ꞌoinega yalihasi ma ꞌabihetena ꞌiloba, gidemusa ꞌimi hebahebaiyaowedi. Weyahina wahine bewa Ebalahamo ꞌina boda ꞌaigeda, ma hesi Seitani bolime ꞌeitini ꞌoidiya ꞌiꞌabiyahiya.” ");
INSERT INTO bdd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu ꞌina gwae bewa ꞌoinega tolomugiyedi ꞌiꞌabihedeba mwadinediya, ma hesi tomota baibaiwa hedada siyaliyaya madouna Yesu ꞌina paihowa waiwaidi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Coinega bodaedi ꞌoidiya wete ꞌigwaeya, “Togidega Yehoba ꞌina hetoloina yaꞌabiheꞌasilala ꞌese ꞌoimiya. Nuwana bewa gide ꞌaigeda ꞌaiwe ꞌoinega yagwae hegehegedi. ");
INSERT INTO bdd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Loheya ꞌaigeda seyala patuna ꞌiꞌeweya, ma ꞌatamana ꞌibeguliya, ma ꞌibwala ta ꞌihemadouwa, ma muliyetega bwasumo sinaoma ma ꞌidi nehwa lahanao ꞌoidiya siꞌabidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Coinega wete ꞌihegwae hilediya, ꞌigwae, “To gwae hegehegediyega yaꞌabihe ꞌasilala ꞌese ma ꞌoinega Yehoba ꞌina hetoloina wasanapu? ");
INSERT INTO bdd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nuwana bewa gide: Wahine ꞌaigeda pwalawa ꞌana ꞌebeꞌabi heseseha ꞌiꞌiuna tuwa ꞌiꞌeweya, ma pwalawa madouna mahetena ꞌihebweliyeya, ꞌoinega pwalawa ꞌiseseha.” ");
INSERT INTO bdd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tutaina Yesu ꞌitautau Yelusalema, ma ꞌedai tupwana ꞌasa madoudi ta ꞌiꞌiudi ꞌoidiya ꞌilatuwa, ma ꞌoidiya ꞌiheheꞌita ta ꞌiloguguya. ");
INSERT INTO bdd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Coinega ꞌaigeda loheya Yesu ꞌihesilaleya, ꞌigwae, “Bada, togidega? Nata tomota hisahisadimo ꞌabihetena siloba, ꞌawa?” Ma Yesu ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Cehe gide, ma hesi watoho waiwai ma waluhu ꞌahwaꞌedaina ꞌiꞌiuna ꞌoinega. Weyahina baibaiwadi sitoho ma ꞌabehega siluhu, ma siꞌaipate ꞌasaya. ");
INSERT INTO bdd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma ꞌabwa wete toni hadaina ꞌahwaꞌeda ꞌigudu, ma ꞌomi ꞌatamana watotoholo, ma ꞌahwaꞌedaina ꞌoina waꞌetunatuna, ma waꞌahwanoi, wagwae, ‘Bada, ꞌahwaꞌeda ꞌusoꞌe ma ꞌaluhuwa.’ Ma nata badaina ꞌenami ꞌihemaisa ma ꞌoimiya ꞌigwae, ‘Taꞌehega wanaoma? Geya yasanapugomi.’ ");
INSERT INTO bdd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma ꞌoinega ꞌomi wahemaisa ma wagwae, ‘Tauma mwalo mahetemwao taꞌaiya, tanumanuma, ma wete ꞌima ꞌasa ꞌuheheꞌita.’ ");
INSERT INTO bdd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma ꞌoinega nata Badaina ꞌihegwaegomi ma ꞌigwae, ‘Moisa, geya yasanapugomi. Taꞌehega watauyama? Wahila ma sahena waluhuluhuma, weyahina ꞌomi togala.’ ");
INSERT INTO bdd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ma ꞌoinega ꞌabwa ꞌeguma Ebalahamo ta Aisake ta Yakobo ma wete palopitao mabwaiyadi mahetediyao waꞌitadi Yehoba ꞌina ꞌebeloina ꞌoina simiyamiya, ma ꞌomi maꞌimi dou ta maꞌimi hesalaꞌiꞌita tutaina ꞌoina, ꞌeguma ꞌatamana wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma tupwa mabwaiyana ꞌoidiyega tomota sinaoma, ma ꞌidi ꞌebemiya bwebweꞌadi siꞌewadi Yehoba ꞌina ꞌebeloina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ma ꞌeguma taiyawedi bewa tuwa sinugenugeta ꞌabwa simuliya, ma taiyawedi taudi bewa tuwa simulimuliya ꞌabwa sinugeta.” ");
INSERT INTO bdd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tuta nage ꞌoina tupwadi Palisiyao sinaoma ma Yesu sihegwaeya, sigwae, “Bewa tuwa ꞌulomwayamwayau ma ꞌudena, tabu ma Helodi ꞌiloheꞌamasigo!” ");
INSERT INTO bdd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Coinega Yesu ꞌoidiya ꞌigwaeya, “Watauya ma bosasaina wahegwae ꞌabehega bewa tuwa hiꞌahiꞌa tomota ꞌoidiyega yaulaula hapwesedi, tolohalao yaꞌabiꞌabi hebwebweꞌanedi, ma wete gona gidemusa, ma ꞌiꞌadale ꞌigu paihowa mabwaiyana yalosalohi. ");
INSERT INTO bdd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Ma taugu ꞌabwa yatautau Yelusalema, nata ta gona ta hedabaha yalatu, ma nobwa yaꞌamasa, weyahina palopitao mabwaiyama ꞌima ꞌebeꞌamasa Yelusalema.” Coinega Yesu nuwana ꞌigala ta Yelusalema weyahina ꞌidouwa, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalema he, togidega ma palopitao ꞌulohelohe ꞌamasidi, ma wete Yehoba ꞌina tohalewasao dimwega ꞌuꞌahuꞌahu yamatedi? Tuta mabwaiyana nuwanuwagu ma ꞌino tomotaedi yabwau ꞌautedima gide ꞌamꞌam natunao papenega ꞌiꞌahuyahidiya, ma hesi silogwahategauwa! ");
INSERT INTO bdd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Coinega Yehoba ꞌiꞌiunamo ma ꞌiꞌebesinego, ma yahegwaego ꞌabehega sahena wete ꞌuꞌitaꞌita hilegau ma ꞌana siga ꞌino tomotaedi sitagwala ꞌoiguwa ma sigwae, ‘Tauna Yehoba saninega ꞌinaonaoma tahepwatuwe.’” ");
INSERT INTO bdd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabati ꞌaigeda ꞌoina Yesu ꞌitauya sabi ꞌai Palisi ꞌidi bada ꞌaigeda ꞌina hada. Hadaina ꞌoina ꞌiluhuwa ma boda siꞌeꞌebubu, ");
INSERT INTO bdd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","weyahina tupwaina ꞌoina ꞌaigeda tolohala ꞌimiyamiya, wahina mabwaiyana siꞌeloseseha. ");
INSERT INTO bdd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Coinega Yesu tolohalaina weyahina ꞌihesilala loina ꞌana tosanapuwao ta Palisiyao ꞌoidiya, ꞌigwaeya, “Togidega? Wanuweya ꞌabehega bwebweꞌana ꞌeguma tolohala sabwelo Sabati ꞌoina taꞌabihe bwebweꞌane, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ta ꞌina gwae geya sihemaisa, ma muliyetega Yesu tolohalaina nimana ꞌiꞌabiya, ma ꞌana lohala ꞌiꞌabihe bwebweꞌaneya. Eeta ꞌihewaseya ta ꞌitauya ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Coinega ꞌihegwaediya, ꞌigwae, “Ceguma taiyewedi ꞌomi maꞌimi hebaiyao gide ꞌase bo bulumakau, ma ꞌaigeda hebaiina sabwelo Sabatiya ꞌibeꞌu gaula ꞌoina, togidega, ꞌana lobwaina ma walisi hanehe?” ");
INSERT INTO bdd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma taudi tuwa geya ꞌidi hemaisamo. ");
INSERT INTO bdd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Caiina ꞌalona Yesu loheloheya ꞌiꞌitediya, taudi nuwanuwadi ma ꞌebemiya bwebweꞌana ꞌoidiya simiyatoi, ꞌoinega ꞌaigeda gwae hegehegedi ꞌiꞌebwaediya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ceguma taiya ꞌina hada ꞌibwauwego hai guyaina weyahina, sahena tohai ꞌina ꞌebeulega ꞌumiyatoi, weyahina ꞌeguma loheya ꞌaigeda sanina madouna ꞌinaoma, ");
INSERT INTO bdd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","beno guyai taniwagana ꞌihegwaego ma ꞌutauya papaliya, ma ꞌino ꞌebemiyaina ꞌoina loheya hauhaunaina ꞌimiyatoi. Ma ꞌowa nata maꞌino debamwadina papaliya ꞌuhila. ");
INSERT INTO bdd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Coinega ꞌeguma sibwauwego ma ꞌuluhuluhu ꞌoidiya, ꞌebemiyaina papaliya ꞌuhesinuwane ma ꞌoina ꞌumiyatoi, ma ꞌoinega tutaina ꞌeguma guyai toniwagana ꞌinaoma ma ꞌiꞌitago, nata ꞌoiuwa ꞌigwae, ‘Ciyagu, ꞌumiyalaga gamwagamwana,’ ta ꞌoinega ꞌulaga maꞌino yaliyaya ma wete ꞌa hepwatu loheloheya matadiya. ");
INSERT INTO bdd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bewa ꞌoinega tasanapu ꞌabehega taiya tauna ꞌiꞌabilagasi, ꞌabwa ꞌisulu; ma ꞌeguma taiya tauna ꞌilagusuluhe, nata ꞌihane.” ");
INSERT INTO bdd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Coinega Yesu Palisiina ꞌibwauweya ma ꞌoina ꞌigwaeya, “Ceguma ꞌeꞌahai ꞌupaihoweya, sahena ꞌiyamwao bo tasimwao, bo ꞌino bodao bo towasawasao ꞌubwaubwauwedi ꞌai nina ꞌoina, weyahina taudi ꞌabwa sibwauwego sabi hemaisa ꞌoiuwa. ");
INSERT INTO bdd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma hesi ꞌeguma ꞌeꞌahaiina ꞌupaihowa, taudi wewelohedi ta peupeudi ta toheꞌauꞌau ta wete tomatagibugibu ꞌubwauwedi, ");
INSERT INTO bdd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ma ꞌoinega ꞌahwa bwebweꞌana moisa ꞌuloba, weyahina bewa taudi geya sowasowahidi ma ꞌino helauina sihemaisa. Ma hesi Yehoba ꞌoinega ꞌa maisa ꞌuloba, tutaina ꞌeguma tobwebweꞌadi ꞌamasega ꞌiꞌabihe toholodi.” ");
INSERT INTO bdd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ta baꞌidanao siꞌaiꞌai, ma ꞌaigeda ꞌoidiyega gwae bewa ꞌihesagoheya, ta Yesu ꞌihegwaeya, ꞌigwae, “Cehe gide! Ceguma taiyewedi siluhu Yehoba ꞌina ꞌebeloina ꞌoina ma siꞌai, siyaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Coinega Yesu loheyaina ꞌina gwae ꞌihemaiseya, ꞌigwae, “Caigeda loheya ꞌeꞌahai madouna ꞌipaihoweya ma tomota baibaiwadi ꞌibwauwediya. ");
INSERT INTO bdd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma ꞌeꞌahaiina ꞌipaihowa pwaiya, ta ꞌina hewali ꞌihewasaeya tomotaedi ꞌoidiya ma ꞌihegwaediya, ‘Ceꞌahai sipaihowa pwaiya, ꞌoinega wanaoma tatauya ma waꞌai.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ma mabwaiyadi geya nuwadi, ꞌoinega hali gwae ma hali gwae siꞌebwaeya. Caigeda ꞌigwaeya, ‘Tanoha hauhauna yagimwane pwaiya, ꞌoinega nuwana yatautau ma yahaboꞌene. Ma yauwedo madouna, ma hesi geyaꞌabwa yanaonaowa.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ꞌaigeda wete ꞌigwaeya, ‘Yauwedo madouna, nuwana taugu wete geyaꞌabwa yanaonaowa, weyahina bulumakau nimaluwaluwa ta wete ꞌebegesoha nimaꞌaiꞌaigeda yagimwane pwaidiya, ꞌoinega yatautauya ma ꞌabehega beno bulumakau ꞌeluwa yahepaihowa tohodi ꞌebegesoha ꞌaigeda silisi bwaibwaini bo geya.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma wete ꞌaigeda ꞌigwaeya, ‘Taugu hauhauna yahaiya, ꞌoinega nata geyaꞌabwa yanaonaowa.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Eeta hewaliina ꞌihila ma ꞌina badaina ꞌoina ꞌihepwaila, ꞌigwaeya, ‘Mabwaiyadi genuwadi.’ Ma toni hadaina ꞌigamwasowala, ꞌoinega ꞌina hewaliina ꞌoina ꞌigwaeya, ‘Cutauya mwayamwayau gogo madoudi ꞌadi ꞌedao mabwaiyadi ꞌoidiya, ma ꞌeguma hisa tomota ꞌulobediya, bwagana nanaewana bo belubeluina bo matagibugibuna bo peupeuna, tuwa mabwaiyadi ꞌutoedima siꞌai.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ma hewaliina ꞌipaihoweya gide, ma muliyetega ꞌinaoma ta ꞌigwaeya, ‘Bada yo, tomotaedi yatoedima, ma hesi ꞌino hadaina geya silohemaha.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ta badaina wete ꞌigwaeya, ‘Ceda mabwaiyadi ꞌoidiya ꞌutauya, ma tomota ꞌuhegwaedi ma sinaoma, ma ꞌigu hada silohemaha. ");
INSERT INTO bdd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta hesi tomotaedi yatoe nugetediya sahena ꞌaigeda ꞌoidiyega ꞌaguina ꞌilolotoho.’” ");
INSERT INTO bdd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma boda madouna mahetenao sitautauya, ma ꞌoinega Yesu ꞌiꞌitahila, ta bodaedi ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taiya ꞌeguma nuwanuwana ma ꞌimuliyegau, nugeta ꞌihamwegau moisa ma tamana ta sinana ta mwanena ta natunao ta tasinao ta nuhunao, ma wete tauna tuwa weyahina ꞌilogwahatedi. Ma ꞌeguma geya, tauna geya ꞌagu tomuliya. ");
INSERT INTO bdd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma ꞌeguma taiya yawasina geya ꞌitagwale ma ꞌiꞌamasa kelose ꞌoina gide taugu, tauna geya sowasowahina ma ꞌimuliyegau. ");
INSERT INTO bdd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gide tuwa ꞌeguma taiya nuwanuwana ma hada madouna ꞌiꞌabi, nugeta ginaula mabwaiyadi ꞌiꞌatububudi hadaina weyahina, ");
INSERT INTO bdd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","tabu ma logidimo ꞌihetoholodi ma geya hada mabwaiyana ꞌilosalohi. Bewa ꞌoinega nata tomota siꞌita ta loheyaina silotuyane. ");
INSERT INTO bdd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ma sigwae, ‘Loheya bewa gide waiwaina ma logidi ꞌihetoholodiya ta geya hadaina mabwaiyana ꞌiꞌabi.’ ");
INSERT INTO bdd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ta wete ꞌeguma ꞌaigeda kini maꞌina toloꞌalehao teni tausani sitautauya sabi loꞌaleha wete hali kini maꞌina bodao tuweniti tausani ꞌoidiya, togidega kini nata ꞌinuwatuhu ꞌesa? Nuwana nugeta ꞌimiyatoi ta ꞌinuwatuhu ma ꞌabehega sowasowahidi sihewaiwai ꞌadi ꞌalehaowedi ꞌoidiya, bo geya? ");
INSERT INTO bdd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma ꞌeguma geya, ꞌina tohalewasao ꞌihewasaedi ma sipilibodedi, ꞌeguma hali kiniina maꞌina bodao ꞌabwa bwagabwaga simiyamiya, ma ꞌoinega mahetediyao sihegwaegwae daumwala weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Coinega Yesu ꞌina hemataluwa ꞌilosalohiya, ma ꞌoidiya ꞌigwae, “Bewa gide wete ꞌagu muliya ꞌana ꞌeda. Ceguma taiya ꞌowa nuwanuwau ma ꞌumuliyegau, nugeta ꞌino ꞌebeloina mabwaiyana ꞌuꞌebesinedi. ");
INSERT INTO bdd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Hola ginaula bwebweꞌana. Ma ꞌeguma ꞌana ꞌamna ꞌigumwala, geya sowasowahina ma ꞌiꞌamna hila. ");
INSERT INTO bdd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Geya wete ꞌilobwalobwaine ma baleꞌu ꞌiꞌabihe bwebweꞌane, ma hesi talogwahateyamo. “Ceguma matenami gwae bewa wahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Caigeda tuta takesi ꞌana toꞌewao ma hali togala tupwadi wete sinaoma Yesu sabi hesagohina. ");
INSERT INTO bdd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Coinega Palisiyao ta loina ꞌana toheꞌitao silomugiyeya, sigwae, “Loheya bewa togalao ꞌiꞌahwa ꞌiyaꞌiyaguwediya ma wete mahetenao siꞌaiꞌai.” ");
INSERT INTO bdd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ta ꞌidi gwaeina Yesu ꞌihemaiseya gwae hegehegediyega, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Togidega ꞌeguma ꞌaigeda ꞌoimiyega ꞌina sipi ꞌadi baibaiwa handeledi, ma ꞌaigeda ꞌiꞌwadalele, sowasowahina ma nainiti naeniyedi pwatula ꞌiꞌebesinedi ma sipiina ꞌwadaꞌwadalelena ꞌiꞌebese ꞌana siga ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma ꞌeguma ꞌiloba nata maꞌina yaliyaya ꞌahalana ꞌilagu ma ꞌihila ꞌasai, ");
INSERT INTO bdd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ꞌoinega ꞌiyanao ꞌibwau heꞌautedima ma ꞌihegwaedi, ꞌigwae, ‘Sipiina ꞌwadaꞌwadalelena yaloba pwaiya, ꞌoinega weyahina tayaliyaya.’ ");
INSERT INTO bdd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Coinega gide wete ꞌeguma ꞌaigeda togala ꞌinuwabui, megalewa aneloseyao weyahina siyaliyaya madouna, ma hesi tobwebweꞌadi site nainti naeniyedi weyahidi ꞌidi yaliyaya ꞌiꞌiuna. ");
INSERT INTO bdd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Gide wete ꞌeguma wahine ꞌina kina ꞌadi baibaiwa nima bwaubwau, ma ꞌaigeda ꞌiheꞌwadaleleya, ꞌoinega toꞌaha ꞌida paihowa ma kinaina ꞌiloba? Nuwana mayale ꞌigabu, ma hada mabwaiyana ꞌiseꞌili ma ꞌibesa bwaibwaina ꞌana siga ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma ꞌeguma ꞌiloba, nata ꞌiyanao ꞌibwau ꞌautedima ma ꞌoidiya ꞌigwae, ‘Cigu kinaina yaheꞌwaihiya yaloba pwaiya, ꞌoinega weyahina tayaliyaya?’ ");
INSERT INTO bdd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gide wete ꞌeguma ꞌaigeda togala ꞌinuwabui, nata Yehoba ꞌina aneloseyao weyahina siyaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Yesu wete ꞌigwae hegehegediya, ꞌigwae, “Caigeda bada natunao loheyadi ꞌeluwa baꞌidanao simiyamiya, ");
INSERT INTO bdd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ta ꞌalomauna tamana ꞌihegwaeya, ꞌigwae, ‘Tamagu, nuwanuwagu ma bewa tuwa ꞌagu heguheguyai ꞌuꞌebwaegau.’ Coinega bada ꞌina tobwatobwa mabwaiyana ꞌiheguyaiyeya natunaowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sabwelo tupwana sigumwala, ma ꞌalomauna ꞌina tobwatobwa ꞌihegimwaneyediya, ma ꞌana maisa mane ꞌiꞌeweya, ma tupwaina ꞌiꞌebesineya, ta tupwa bwaga hedada ꞌoina ꞌitauya, ma nobwa yaliyaya bwagabwaga ꞌoinega ꞌina mane ꞌilohegumwalidiya. ");
INSERT INTO bdd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Cina mane mabwaiyana ꞌigumwala ta nimenimenamo ꞌimiyamiya, ma tuta nage ꞌoina gomale madouna tupwaina ꞌoina ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Coinega loheyaina ꞌina paihowa ꞌiꞌebesa, ta ꞌaigeda ꞌasa ꞌana bada ꞌilobeya, ta ꞌihewaseya ma ꞌina baweyao ꞌiꞌitayahidi. ");
INSERT INTO bdd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta loheyaina nuwanuwana ma bawe ꞌadiyega ꞌiꞌai, weyahina geya ꞌanamo. ");
INSERT INTO bdd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tuta nage ꞌoina nuwana ꞌisabwalena, ma ꞌiboinamo ꞌoina ꞌigwaeya, ‘Moisa, tamagu ꞌina topaihowao ꞌadi ꞌeꞌahai madouna, ma taugu ꞌebwa tuwa gomale ꞌihunuhunugau. ");
INSERT INTO bdd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Coinega yatoholo ma yatauya tamagu ꞌoina yagwae, “Tamagu, yagala pwaiya Yehoba ꞌoina, ma wete ꞌowa ꞌoiuwa. ");
INSERT INTO bdd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta geya ꞌilobwainegau ma ꞌuꞌahwa natuwegau, ma hesi ꞌuꞌahwa topaihowegau.” ’ ");
INSERT INTO bdd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Bewa gide ꞌinuwanuwatuhu ꞌesa, ta ꞌoinega ꞌitoholowa ma tamana weyahina ꞌitauya, ma bwagebwagega tamana ꞌiꞌiteyama ꞌitautauyama, ꞌoinega maꞌina ꞌatemuyamuya ꞌipili ꞌoina, ma ꞌiꞌatusapwaliya, ta mahetena sihehedoudou. ");
INSERT INTO bdd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Eeta natunaina tamana ꞌihegwaeya, ꞌigwae, ‘Tamagu, yagala pwaiya Yehoba ꞌoina ma wete ꞌowa ꞌoiuwa, ꞌoinega geya ꞌilobwainegau ma ꞌuꞌahwa natunegau.’ ");
INSERT INTO bdd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma hesi tamana ꞌina hewaliyao ꞌibwauwediya ma ꞌoidiya ꞌigwaeya, ‘Walomwayamwayau ma ꞌwama bwebweꞌana waꞌeweyama ma natugu waheꞌote, ma wete ꞌana nipuna waꞌeweyama ma nimana walagu, ma ꞌana butu ꞌahena walagu, ");
INSERT INTO bdd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ma muliyetega watauya ma bulumakau yauyaubona ta momonana wahunuyama, ma ꞌeꞌahai madouna tapaihowa, ma ꞌoinega maꞌida yaliyaya tauna mahetedai taꞌai. ");
INSERT INTO bdd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Weyahina natugu bewa mwalo ꞌiꞌamasa, ta nige mayawasina taloba hileya.’ Coinega sihegaina ma siguyai maꞌidi yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma hesi natuna tautuwa ꞌabwa tanoha ꞌipaipaihowa. Cina paihowa ꞌigumwala, ma tutaina ꞌasa deina ꞌilatulatu, lahusa ma selo ꞌihesagohediya. ");
INSERT INTO bdd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Coinega ꞌaigeda ꞌidi hewali ꞌibwauweya ma ꞌihesilaleya, ꞌigwae, ‘Toꞌaha lamuna ꞌoinega siyaliyaliyaya?’ ");
INSERT INTO bdd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma hewaliina ꞌigwaeya, ‘Tasiu ꞌihila pwaima ta tamana bulumakau yauyaubona ta momonana ꞌihunuya, ma mahetemai ꞌayaliyaliyaya, weyahina natunaina maꞌina bwebweꞌana ꞌiloba hileya.’ ");
INSERT INTO bdd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Gwae bewa ꞌihesagoheya ta ꞌigamwasowala madouna, ta genuwana ma hadai ꞌiluhu. “Coinega tamana ꞌilatuma ma natuna tautuwana ꞌihegwaeya ꞌabehega mahetena siluhu hadai. ");
INSERT INTO bdd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma hesi loheyaina ꞌilogwahata, weyahina ꞌigamwasowala hedada, ma tamana ꞌoina ꞌigwaeya, ‘Tamagu, hisa bolime ꞌoidiya weyahiu yapaipaihowa ma ꞌino heyowana mabwaiyana yapaihowediya, ma geya ꞌaigeda tuta ꞌuda helauwegauwa. Geya ꞌaigeda wete hebai ꞌuꞌebwaegau ma maꞌiyagwao ꞌaꞌai hegogona ma ꞌayaliyaya. Geya hene! ");
INSERT INTO bdd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma natuina bewa ꞌino tobwatobwa mabwaiyana ꞌimudaliya tosogalao ꞌoidiya, ma toꞌaha weyahina ꞌuhelauweya, ma bulumakau yauyaubona ta momonana ꞌuhunuya weyahina?’ ");
INSERT INTO bdd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ta ꞌoinega badaina natuna ꞌoina ꞌigwaeya, ‘Natugu, ꞌusanapuya ꞌabehega ꞌowa tuta mabwaiyana deiguwa ꞌumiyamiya, ma toꞌaha gide ꞌigu ꞌebeloinao, mabwaiyana nimauwa simiyamiya, ");
INSERT INTO bdd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ma hesi tasiu bewa ꞌiꞌamasa, ta bewa tuwa mayawasina taloba hileya, ꞌoinega ꞌilobwainegita ma mahetedai tayaliyaya.’” Tetela bewa ꞌoinega Yesu Palisiyao ma loina ꞌana toheꞌitao ꞌigwae hegehegediyediya. ");
INSERT INTO bdd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Wete Yesu gwae hegehegedi ꞌaigeda ꞌana tomuliyao ꞌiꞌebwaediya, ꞌigwae, “Loheya towasawasa maꞌina topaihowa, tauna ꞌina wasawasa ꞌana toꞌitayahina, ta ꞌaigeda tuta ꞌoina tupwadi loheloheya wasa siꞌeweyama towasawasaina ꞌoina, sigwaeya, ‘Bada, ꞌino topaihowaina ꞌino tobwatobwa ꞌihehepaipaisiyedi.’” ");
INSERT INTO bdd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Coinega, towasawasaina ꞌina topaihowaina ꞌibwauweyama, ma ꞌihegwaeya, ꞌigwae, “Hepwaila galadi weyahiu yahesagoheya ꞌoinega bewa tuwa ꞌigu tobwatobwa ꞌadi pepao ꞌuꞌebwae hilegau, ma ꞌoiguwega ꞌulatu.” ");
INSERT INTO bdd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Coinega topaihowaina ꞌinuwatuhuwa ta ꞌigwae, ‘Togidega nata yapaihowa ꞌesa, weyahina ꞌigu badaina ꞌilogwahategauwa? Geya sowasowahina ma yatanoha paihowa, ma wete debamwadina ꞌeguma yatautauya tomota ꞌoidiya, ꞌeꞌahai weyahina yaloꞌahwaꞌahwanoi.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cinuwanuwatuhu ma ꞌaigeda ꞌeda ꞌinuwalobeya, ꞌigwaeya, ‘Cehe, bewa gide yapaihowa ꞌese ma ꞌoinega ꞌiyagwao baibaiwadi yalobadi, ꞌeguma paihowa bewa ꞌoinega yalatu.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eeta ꞌina badaina ꞌina tobukiyao ꞌibwauwediya, ma ꞌaigeda ꞌaigeda ꞌoidiya ꞌihesilala. Loheya nugenugetaina ꞌoina ꞌihesilala, ꞌigwaeya, ‘Hisa ꞌa buki ꞌigu badaina ꞌoina?’ ");
INSERT INTO bdd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma ꞌigwaeya, ‘Holowa ꞌadi baibaiwa handeledi yabukidiya.’ Coinega topaihowaina ꞌigwaeya, ‘Pepa bewa ꞌoina ꞌa bukiyedi ꞌuleledi ma pipitimo ꞌulagu.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma ꞌaigeda wete ꞌiluhuwa ta ꞌihesilaleya, ꞌigwae, ‘Ma ꞌowa hisa ꞌa buki?’ Ta ꞌigwaeya, ‘Ceꞌahai ꞌadi baibaiwa handeledi yabukidiya.’ Coinega tauna wete ꞌigwaeya, ‘Pepa bewa ꞌoina ꞌa bukiina ꞌulele ma ꞌeitimo ꞌulagu.’ Ma mabwaiyadi gide ꞌadi bukiyedi silagu suluhediya. ");
INSERT INTO bdd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Coinega ꞌina badaina ꞌina paihowa bewa wasana ꞌihesagoheya, ma ꞌihepwatuweya, weyahina mebaleꞌu sihewaiwai ꞌidi wasawasa ꞌana paihowa ꞌoina, ma hesi Yehoba ꞌina bodao geya sihewaiwai ꞌidi paihowao ꞌasilala weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ta Yesu wete ꞌihegwaediya, “Baleꞌu wasawasao galadi, ma ꞌeguma wasawasaedi ꞌoidiyega ꞌiyamiyao wahelauwedi, ꞌabwa taudi sihaesotegomi ꞌebemiya hatayaina ꞌoina, tutaina wasawasaedi sigumwala. ");
INSERT INTO bdd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Weyahina ꞌeguma taiya ginaula ꞌiꞌiuna ꞌoina ꞌihematamatana, wete ginaula madoudi ꞌoidiya ꞌihematamatana. Ma ꞌeguma ꞌiꞌiudi ꞌoidiya ꞌiꞌabo wete ginaula madoudi ꞌoidiya ꞌiꞌabo. ");
INSERT INTO bdd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Comi wete, ꞌeguma geya baleꞌu wasawasao weyahidi wapaihowa bwaibwaini, nata Yehoba geyaꞌabwa wete wasawasa moisa ꞌiꞌebwaꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma ꞌeguma ꞌiyamiyao ꞌidi wasawasa weyahidi geya wapaihowa bwaibwaini, gesowana wete Yehoba ꞌimi wasawasaina ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Coinega topaihowa geya sowasowahina ma ꞌihetopaihowa bada ꞌeluwa ꞌoidiya, ma ꞌaigeda ꞌiguipaile ma hesi ꞌaigedamo weyahina ꞌipaihowa, ma ꞌoinega ꞌaigeda ꞌiꞌahwa bwebweꞌane ma ꞌaigeda ꞌiꞌahwa galagalae. Coinega geya sowasowahina ma Yehoba ꞌina paihowa ma wasawasa baleꞌuwa taꞌabiluwedi.” ");
INSERT INTO bdd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Saugaina Palisiyao gwaeina sihesagoheya ta Yesu silotuyaneya, weyahina taudi mane nuwanuwadi madouna. ");
INSERT INTO bdd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Coinega Yesu Palisiyaowedi ꞌoidiya ꞌigwaeya, “Comi wanuwatuhuya ꞌabehega mumugami bwebweꞌana tomota matadiya, ma hesi galana mabwaiyana ꞌatemiya Yehoba ꞌisanasanapudi, weyahina ginaulaedi tomota nuwadi siꞌeweya, Yehoba ꞌilogwahatediya. ");
INSERT INTO bdd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisa tuwa, Mosese ma palopitao ꞌidi loinao ꞌoimiya simiyamiya ꞌana siga Yoni toꞌabihebabitaiso ꞌinaoma, ma tuta nage ꞌoinega ꞌana siga nige tetela bwebweꞌana Yehoba ꞌina loina weyahina ꞌabwa ꞌahehepwailedi, ma ꞌebeloinaina weyahina tomota baibaiwadi maꞌidi waiwai sitohotoho ma siluhuluhu. ");
INSERT INTO bdd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Galewa ma baleꞌu ꞌidi sawala sowasowahina, ma hesi Mosese ꞌina loinao bwagana ꞌiꞌiu sehenina, geyaꞌabwa sigumwagumwala.” ");
INSERT INTO bdd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ma Yesu wete ꞌoidiya ꞌigwaeya, “Ceguma taiya loheya mwanena ꞌisaꞌile ma ꞌihaibala hali wahine ꞌoina, tauna ꞌipui pwaiya, ma wete ꞌeguma wahine saꞌisaꞌilina ꞌihaihila hali loheya ꞌoina, loheyaina tauna wete ꞌipui pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ma Yesu wete ꞌihegwaediya, ꞌigwae, “Caigeda tuta ꞌoina towasawasa ꞌaigeda ma Lasalo simiyamiya. Towasawasaina ꞌana ꞌaleꞌowao ꞌausala hedadedi ma wete ꞌanao mabwaiyadi bwebweꞌadi, ꞌoinega sabwelo ꞌaigeda ꞌaigeda ꞌoidiya maꞌina yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma Lasalo wewelohena ma lobweꞌabweꞌaina, ꞌoinega Lasaloina towasawasaina hada ꞌahwaꞌeda ꞌoina ꞌimiyamiya, ");
INSERT INTO bdd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ma ꞌabehega towasawasaina ꞌana mugumuguna ꞌoinega ꞌida ꞌai. Ma Lasaloina bweꞌanao tuta baibaiwana ꞌedewa siyamoyamosidi. ");
INSERT INTO bdd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ma tutaina Lasalo ꞌiꞌamasa aneloseyao sitoeya ta Ebalahamo deina silaguya tobwebweꞌana ꞌidi tupwa. Ma muliyetega wete towasawasaina ꞌiꞌamasa ma sigaliheya, ");
INSERT INTO bdd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ma tauna maꞌina muya madouna toꞌamasa ꞌidi tupwa ꞌoinega ꞌiꞌita haneya, ta Lasalo ꞌiꞌiteya Ebalahamo baꞌidana simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Coinega ꞌibwau madouna ma ꞌigwaeya, ‘Tamagu yo! Cuda ꞌatemuyemuyegau ma Lasalo ꞌuhewasaeyama ma weꞌaha gogaina nimanega memenagu ꞌiꞌabihegogai, weyahina tuta bewa yamuyamuya madouna ꞌaiwe ꞌalaꞌalata ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ma Ebalahamo ꞌihegwaeya, ꞌigwae, ‘Natugu, ꞌusanapuya ꞌabehega mwalo yawasiu mabwaiyana yaliyayamo, ma hesi Lasalo geya ꞌaigeda ꞌebeyaliyaya ꞌiloba. Coinega bewa tutaina tauna maꞌina yaliyaya, ma ꞌowa ꞌumuyamuya. ");
INSERT INTO bdd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma wete ꞌuda sanapu ꞌabehega gamwagamwanida saꞌala madouna ꞌimiyamiya, ꞌiwatahigita, ꞌoinega geya sowasowahina ma bewa ꞌoinega ꞌahabalawa ꞌoimiya. Comi wete, geya sowasowahimi ma wahabalama ꞌoima.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Towasawasaina ꞌigwaeya, ‘Ee bwebweꞌana, ma benomo nuwanuwagu ma Lasalo ꞌuhewasae ꞌigu bodao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ma tasigwao site nima ꞌida hemataluwedi, tabu ma taudi wete sinaoma muya ꞌina tupwa bewa ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Coinega Ebalahamo loheyaina ꞌihegwaeya, ꞌigwae, ‘Tasimwaowedi ꞌadi tohenuwalagu simiyamiya, taudi beno Mosese ta palopitao ꞌidi gwaeyedi Buki Heꞌasisi ꞌoina. Gwaeyedi ꞌalona sowasowahina ma tasimwaowedi sihesagoha bwaibwaini.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma hesi towasawasaina ꞌigwaeya, ‘Tamagu, beno geya sowasowahina. Ma ꞌeguma taiya ꞌamasega ꞌitoholohila ma ꞌitauya ꞌoidiya, ma tauna siꞌita, ꞌoinega sinuwabui bwaibwaini.’ ");
INSERT INTO bdd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ta Ebalahamo wete ꞌigwaeya, ‘Ceguma Mosese ma palopitao ꞌidi gwae geya sihemisaedi, geyaꞌabwa wete ꞌaigeda taiya sihehemisae, bwagana ꞌeguma ꞌaigeda toꞌamasa ꞌitoholo hila ma ꞌitauya ꞌoidiya.’” ");
INSERT INTO bdd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Coinega Yesu ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Tomota tupwadi nata ꞌebetoho baibaiwana sipaihowadi ꞌoimiya ma ꞌabehega siꞌabi hebeꞌugomi, ma ꞌeguma taiyawedi taudi ꞌebetohowedi sipaihowediya tuwa ꞌatemuyamuyaidi. ");
INSERT INTO bdd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma ꞌeguma taiya toꞌabi hebeꞌuina, ꞌilobwaineya ma daꞌule madouna silosipwa ꞌaniꞌona ma niꞌu dubaduba siulasuluhe, ma ꞌoinega sahena gwagwama siheheꞌauꞌaunaowe. ");
INSERT INTO bdd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Coinega waꞌitayahigomi, ma ꞌeguma tasiu ꞌoiuwa ꞌipaihowa galagala, ꞌuhegwae ꞌina puiina, ma ꞌeguma ꞌinuwabui ꞌunuwasam. ");
INSERT INTO bdd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma ꞌeguma tasiu ꞌina sabwelo ꞌaigeda ꞌoina ta masebeni ꞌipaihowa galagala ꞌoiuwa, ma tuta ꞌaigeda ꞌaigeda ꞌoina ꞌiꞌahwaꞌahwanoi ꞌoiuwa sabi nuwasam, ꞌilobwainegowa ma mabwaiyana ꞌunuwasamudi.” ");
INSERT INTO bdd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eeta Yesu ꞌana tohepwailaowedi sigwaeya, sigwae, “Cima hemisa ꞌuꞌabihewaiwai.” ");
INSERT INTO bdd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma badaina ꞌigwaeya, “Ceguma ꞌimi hemisa ꞌana waiwai gide seyala patuna, sowasowahina ma ꞌaiwe bewa madouna ꞌoina wagwae, ‘Cudabugo ma niꞌuwa ꞌuboi ꞌuꞌumago,’ nata ꞌimi gwaeina ꞌihematamatane.” ");
INSERT INTO bdd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma wete ꞌoidiya ꞌigwaeya, “Ceguma ꞌaigeda taiya ꞌowa ma ꞌino hewali, tauna togesoha bo nuwana hebai ꞌana toꞌitayahina, ma tutaina ꞌeguma hewaliina ꞌina paihowega ꞌilatuma, geya sowasowahina ma ꞌuloina ꞌabehega tauna ꞌiꞌai nugeta, ");
INSERT INTO bdd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ma hesi ꞌugwae, ‘Cagu ꞌuꞌatububu ma ꞌuꞌitayahigau ma yaꞌai, ma ꞌoinega ꞌowa muliyetega ꞌuꞌai ma ꞌunuma.’ ");
INSERT INTO bdd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Coinega hewaliina ꞌina paihowa weyahina ꞌana loyauwedo geya ꞌida lobeya ꞌina bada ꞌoinega, weyahina tauna tuwa ꞌina paihowa. ");
INSERT INTO bdd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma ꞌomi wete gidemusa, ꞌeguma tutaina ginaula mabwaiyana wapaihowadi, toꞌaha gide yaloinegomiya, wagwae, ‘Cehe, tauma tuwa topaihowa, ꞌoinega toꞌaha gidemusa ꞌama loinaina gide ꞌapaihoweya, beno gide ꞌama lobwaina moisa.’” ");
INSERT INTO bdd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ma Yesu Yelusalema weyahina ꞌitautauya ma Sameliya ta Galili gamwagamwanidiya ꞌilatulatu. ");
INSERT INTO bdd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ta ꞌaigeda ꞌasa ꞌoina ꞌinaoma ma tolepelo nima luwaluwa ꞌilobediya, eema ꞌina ꞌeda ꞌoinega siha hila, ");
INSERT INTO bdd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma sibwaubwau ꞌenadi madounega, sigwaeya, “Bada Yesu ꞌuꞌatemuyamuyaemai.” ");
INSERT INTO bdd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Coinega ꞌiloꞌitahila ma ꞌihegwaediya, “Watauya ma topwaoli ꞌoidiya waheꞌitaegomi.” Ma sitautauya ꞌedai ta ꞌadi lepelo ꞌigumwala, ");
INSERT INTO bdd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ma ꞌaigeda loheya ꞌoidiyega, tauna gwama Sameliya, ꞌiꞌiteya ꞌabehega ꞌibwebweꞌana pwaiya, ꞌoinega ꞌihila ma ꞌenana madounega Yehoba ꞌihepwatuweya, ");
INSERT INTO bdd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ma Yesu ꞌahena ꞌibeꞌu talutalubuꞌiya ma ꞌoina ꞌiloyauwedowa. ");
INSERT INTO bdd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Coinega Yesu loheyaina ꞌihegwaeya, “Nige wate nima luwaluwa yaꞌabihe bwebweꞌanegomiya, ma taꞌeha site naeniyedi? ");
INSERT INTO bdd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Togidega geya sihilama ma Yehoba ꞌoina siloyauwedo? Ma ꞌowa taumana geya Yudiya ꞌoinega, ma ꞌunaoma sabi loyauwedo. ");
INSERT INTO bdd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Coinega ꞌino hemisega ꞌabihetena ꞌulobeya. Causala, ꞌutoholo ma ꞌutau.” ");
INSERT INTO bdd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisiyao tupwadi sinaoma ma Yesu sihesilaleya to tuta gide ꞌoina Yehoba ꞌina loina ꞌilatuma. Coinega Yesu ꞌidi hesilalaina ꞌihemaiseya bewa gidemusa, ꞌigwaeya, “Geya sowasowahina ma tomota matadiya Yehoba ꞌina loina ꞌinaonaoma siꞌita. ");
INSERT INTO bdd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma wete geya sowasowahidi ma sigwae, ‘Waꞌita Bewa’, bo nuwana ‘Nage’, weyahina Yehoba ꞌina loina ꞌoimiya ꞌimiya pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Coinega ꞌana tomuliyao ꞌihegwaediya, ꞌigwae, “Cabwa yaꞌebesinegomi, ma muliyetega nuwanuwami madouna ma taugu Loheyaiguina baꞌidamiu tada miyamiya sabwelo ꞌaigeda tuwa weyahina, ma hesi nata geya waꞌiteꞌitegau. ");
INSERT INTO bdd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma ꞌeguma tomota sigwae, ‘Keliso nage’, bo nuwana ‘Bewa’, nata sahena wamulimuliyedi. ");
INSERT INTO bdd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Weyahina saugaina ꞌeguma yanaonaoma, galewa ꞌana ꞌita gide ꞌasilala daisinamo, gide namala madouna ꞌana ꞌita. ");
INSERT INTO bdd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Ta muliyetega ma ginauledi sihapwesa, nugeta mehau bewa silogwahategau, ma ꞌoidiyega muya yaloba. ");
INSERT INTO bdd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Cigu hilama ꞌana tuta Nowa ꞌina tuta gidemusa. ");
INSERT INTO bdd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Weyahina Nowa ꞌina tuta siꞌaiꞌai ma sinumanuma ma wete loheloheyadi ta wahiwahinedi sihaihai ꞌana siga Nowa ꞌina waga ꞌigeluwa, ta yagewa ꞌilatuwa ta ꞌoinega tomota mabwaiyadi ꞌimutudiya. Ma taugu Loheyaiguina ꞌigu hilama gidemusa. ");
INSERT INTO bdd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ma wete Lota ꞌina tuta gide, saugaina tomota mabwaiyadi siꞌaiꞌai ma sinumanuma, ma wete sigimwagimwane ma sihehegimwane, ta wete sitanohapaihowa ma sihadahadaꞌabi, ");
INSERT INTO bdd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ta ꞌana siga Lota Sodoma ꞌiꞌebesineya, ꞌoinega ꞌaiwe ganinisa ma daꞌule yahiyahidi galewega sigubalama gide dohi, ma tomota mabwaiyadi ꞌiloheꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ginauledi silatuwa ꞌoidiya, ꞌabwa wete gide tomota ꞌoidiya sida latu ꞌesa, beno tutaina taugu Loheyaiguina yahilama. ");
INSERT INTO bdd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ma sabweloina ꞌoina ꞌeguma taiya wagahata ꞌimiyamiya, sahena wete hada ꞌalona ꞌiluhuluhu ma ꞌabehega ꞌilotobwatobwa. Wete ꞌeguma taiya tanoha ꞌipaipaihowa sahena ꞌasa weyahina ꞌipilipili. ");
INSERT INTO bdd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Ma hesi wanuwatuhuyahi toꞌaha gide ꞌihapwesa Lota mwanena ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Ceguma taiya tauna yawasina weyahina ꞌiꞌaipate, nata yawasinaina ꞌiheꞌwadalele, ma ꞌeguma taiya yawasina ꞌitagwale ma ꞌiheꞌwadalele, ꞌabwa ꞌiloba hila. ");
INSERT INTO bdd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ma yahegwae bwaibwainigomi ꞌabehega hinuwanaina nage ꞌoina tomota ꞌeluwa ꞌebeꞌeno ꞌaigeda ꞌoina siꞌeno, ma ꞌaigeda yatoe ta ꞌaigeda ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wete gide wahiwahine ꞌeluwa siꞌeꞌehalo, ꞌaigeda yatoe ta ꞌaigeda ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO bdd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Coinega ꞌana tomuliyaowedi sihesilaleya, sigwae, “Bada, taꞌeha?” Ta Yesu ꞌihegwaediya, “Taꞌeha ꞌoina ꞌwayoha ꞌimiyamiya beno ꞌoina ꞌaoꞌao siꞌetoꞌetoꞌauta.” ");
INSERT INTO bdd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eema ꞌaigeda gwae hegehegedi Yesu ꞌiꞌebwaediya ma ꞌabehega sahena ꞌahwanoi ꞌoinega siweꞌaweꞌa. ");
INSERT INTO bdd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Bewa gidemusa ꞌigwaeya, “Caigeda ꞌasa ꞌoina toloina ꞌaigeda madouna ꞌimiyamiya, tauna Yehoba geya ꞌida matauteya ta wete loheloheya geya ꞌida heꞌasisiyediya. ");
INSERT INTO bdd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tupwaina ꞌoina wete ꞌaigeda hiwape ꞌimiyamiya, ma tuta baibaiwana hiwapeina ꞌilatulatu toloinaina ꞌoina ta ꞌiꞌahwaꞌahwanoi ꞌoina lema weyahina, ꞌigwae, ‘Bada, ꞌagu ꞌaleha ꞌoinega ꞌuꞌabihetegau.’ ");
INSERT INTO bdd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Tuta ꞌaigeda ꞌaigeda gide ꞌina paihowa, ma toloinaina genuwana ma ꞌileme. Ta ꞌaigeda tuta ꞌoina toloinaina ꞌilowahiꞌwata, ꞌoinega ꞌiboinamo ꞌoina ꞌigwaeya, ‘Tuwa Yehoba geya yamataute ta wete loheloheya geya yada heꞌasisiyanediya, ");
INSERT INTO bdd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma hesi hiwape bewa ꞌina tauya hilahilama ꞌoiguwa weyahina yaꞌabihete ꞌana ꞌaleha ꞌoinega, tabu ma ꞌagu wahiꞌwata ꞌilagu hila.’” ");
INSERT INTO bdd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Coinega Yesu wete ꞌihegwaediya, ꞌigwae, “Toloinaina ꞌina gwae weyahina wanuwatuhu. Tauna loheya galana ma hesi hiwape ꞌilemeya. ");
INSERT INTO bdd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wete gide Yehoba ꞌina tomotaiyao hehesinuwaidi nata ꞌilemedi, ꞌeguma siꞌahwanoi hilahila ꞌoina, sabwelo ma nihuwana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Moisa tuwa, ꞌina lemaina dumwaluna nata ꞌipaihowa ꞌoidiya. “Ma togidega ꞌomi wanuwatuhu ꞌeseya ꞌeguma saugaina taugu Loheyaiguina yahilama baleꞌu bewa ꞌoina, hisa tomota maꞌidi hemisa yalobadi sitoholo paꞌala?” ");
INSERT INTO bdd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tomota tupwadi sinuwatuhuya ꞌabehega taudi dumwaludi ma hali tomota geya, ꞌoinega Yesu ꞌigwae hegehegediyediya bewa gide, ");
INSERT INTO bdd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ꞌigwaeya, “Caigeda tuta ꞌoina loheloheya siteluwa siluhuwa Hada Heꞌasisi ꞌoina sabi ꞌahwanoi Yehoba ꞌoina. Caigeda Palisi ma ꞌaigeda takesi ꞌana toꞌewa. ");
INSERT INTO bdd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Coinega Palisiina ꞌitoholowa ma ꞌiꞌahwanoiya, ꞌigwae, ‘Yehoba yo, yaloyauwedo ꞌoiuwa weyahina taugu geya gide ꞌiyagwao mumugadi, weyahina taudi toyagaha hedade, ma ꞌaboꞌaboidi, ma lologwalidi, ma wete taugu geya gide takesi ꞌana toꞌewa nage. ");
INSERT INTO bdd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Taugu hesi wiki ꞌaigeda ꞌaigeda sabwelo ꞌeluwa ꞌoidiya ꞌeꞌahai ꞌoinega yahudihudi, ma wete ꞌigu tobwatobwa mabwaiyana ꞌoinega tupwana yaꞌebwaꞌebwaego.’ ");
INSERT INTO bdd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma hesi takesi ꞌana toꞌewaina bwagebwagega ꞌitoholowa, ta maꞌina debamwadina lumalumana ꞌitutuya, ma ꞌituluha ta ꞌiꞌahwanoi, ꞌigwaeya, ‘Yehoba yo, ꞌusanapu pwaigauwa ꞌabehega taugu togala, ꞌoinega ꞌuꞌatemuyemuyegau!’” ");
INSERT INTO bdd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta Yesu wete ꞌoidiya ꞌigwaeya, “Moisa, loheyaina bewa ꞌina ꞌahwanoiina weyahina ꞌana ꞌahwabwebweꞌana ꞌilobeya Yehoba ꞌoinega, ma hesi Palisiina geya. Weyahina ꞌeguma taiya tauna ꞌiꞌabilagasi nata silagusuluhe, ma ꞌeguma taiya tauna ꞌilagusuluhe siꞌabilagasi.” ");
INSERT INTO bdd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tupwadi tomota natudiyao ꞌiꞌiudi siꞌewedima ma ꞌabehega Yesu ꞌiꞌabitohodi, ma ꞌana tomuliyao tomotaedi siꞌitediya ta siꞌausidiya. ");
INSERT INTO bdd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma Yesu ꞌibwau heꞌautediya ma ꞌigwae, “Sahena gwagwama waꞌauꞌausidi ma hesi watagwaledi ma ꞌoiguwa sinaoma. Weyahina gwagwama bewa gide Yehoba ꞌina ꞌebeloina ꞌilobwaine bwaibwainidiya. ");
INSERT INTO bdd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yahegwaegomi ꞌeguma taiyewedi taudi gwagwama bewa gide ꞌidi hemisa, sowasowana Yehoba ꞌina ꞌebeloina ꞌoina siluhuluhu, ma hesi ꞌeguma geya, nata geya.” ");
INSERT INTO bdd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","MeYudiya ꞌidi tohanugeta ꞌaigeda ꞌinaoma ma Yesu ꞌihesilaleya, ꞌigwae, “Bada, yasanapuya ꞌabehega ꞌowa toheꞌita bwebweꞌana, ꞌoinega toꞌaha nata yapaihowa ma yawasigu hataya yaloba?” ");
INSERT INTO bdd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Yesu loheyaina ꞌihegwaeya, “Togidega ta ꞌoinega ꞌuꞌahwa bwebweꞌanaegauwa? Geya ꞌeta taiya bwebweꞌana, beno tuwa Yehoba. ");
INSERT INTO bdd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ma Yehoba ꞌina loinao ꞌusanapu pwaidiya, beno ꞌabehega: Sahena logwali, Sahena loheꞌamasa, Sahena yagaha, Sahena hepwaila ꞌaboꞌabo, Ma wete tamau ma sinau ꞌuheꞌasisiyanedi.” ");
INSERT INTO bdd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ta loheyaina ꞌigwaeya, “Cigu tuta gwamega ta nige loinaedi beno yamuliya bwaibwainidiya.” ");
INSERT INTO bdd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cina gwaeina bewa gide Yesu ꞌihesagoheya, ꞌoinega ꞌigwaeya, “Caigeda ginaula tuwa ꞌilosapuligowa, beno ꞌabehega ꞌino tobwatobwa mabwaiyana ꞌuhegimwaneyedi ma ꞌadi maisa towewelohe ꞌoidiya ꞌuheguyaiyedi, ta ꞌoinega ꞌunaoma, ꞌumuliyegau ma ꞌoinega ꞌabwa ꞌino wasawasa galewa ꞌuloba.” ");
INSERT INTO bdd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gwae bewa loheyaina ꞌihesagoheya, ta ꞌina wasawasa madouna ꞌinuwahiya, ꞌoinega nuwana ꞌigala moisa. ");
INSERT INTO bdd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cina nuwagalaina Yesu ꞌisanapu pwaiya, ꞌoinega tomota ꞌoidiya ꞌigwaeya, “Ceguma taiyewedi taudi maꞌidi wasawasa madouna ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌoina mwau hedada. ");
INSERT INTO bdd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moisa, kameli tauna hebai madouna, ꞌoinega tupwana mwauna ma nidili ꞌana ꞌebesula ꞌoinega ꞌiluhu, ma hesi towasawasao ꞌidi luhu Yehoba ꞌina ꞌebeloina ꞌoina mwau hedade.” ");
INSERT INTO bdd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bodaedi Yesu mahetenao simiyamiya gwaeina sihesagoheya, ta sihesilaleya, sigwae, “Ceguma bewa gidemusa, taiya hede sowasowahina ma ꞌebe yaliyayaina ꞌiloba?” ");
INSERT INTO bdd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Coinega ꞌigwaeya ꞌoidiya, “Toꞌaha tomota ꞌoidiya geya sowasowahina, Yehoba ꞌoina ginaulaedi meyameyahadi.” ");
INSERT INTO bdd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Coinega Pita Yesu ꞌihegwaeya, “Bada, ma tauma togidega? Weyahina ꞌima ꞌasao ꞌaꞌebesine pwaidiya ma ꞌamuliyegowa.” ");
INSERT INTO bdd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ta Yesu mabwaiyadi ꞌihegwaediya, ꞌigwae, “Yahepwaila dumwalu ꞌoimiya, ꞌeguma taiyewedi ꞌomi ꞌimi gogo bo mwanemiyao bo tasimiyao bo tamamiyao bo sinamiyao bo natumiyao waꞌebesinediya ma Yehoba ꞌina loina ꞌoina watagwalegemiya, ");
INSERT INTO bdd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tuta bewa ꞌoina maisa madouna waloba, ma wete tuta sinaonaoma ꞌoina yawasimi hataya waꞌewa.” ");
INSERT INTO bdd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu site tuwelowedi ꞌibwau ꞌautedima ma ꞌitoediya papaliya ta ꞌihegwaediya, “Bewa tuwa tahanehane Yelusalema ma ginaulaina mabwaiyana palopitao mwalona silelediya taugu Loheyaiguina weyahigu nata silatu ma waꞌitadi. ");
INSERT INTO bdd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nugeta siꞌebwayaegau taudi geya meYudiya ꞌoidiya, ma silotuyanegau ma siꞌabihedeba mwadinegau ma siꞌesohegau, ");
INSERT INTO bdd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ta wete balaeyega sisapigau, ma siloheꞌamasigau, ta sabwelo hetoina ꞌoina ꞌamasega yatoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma ꞌana tomuliyaedi geya ꞌaigeda ꞌina gwaeina ꞌana nuwasabwalena ꞌoidiya ꞌiluhu. ");
INSERT INTO bdd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ma Yesu Yeliko ꞌoina ꞌilatulatu, ma ꞌaigeda tomatagibugibu ꞌedai ꞌimiyamiya, ꞌiloloꞌahwaꞌahwanoi mane ma tobwatobwa weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yesu ma ꞌana bodao ꞌenadi ꞌihesagoheya, ta ꞌisalutuwa ma ꞌigwaeya, “Taiyewedi beno?” ");
INSERT INTO bdd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ta sigwaeya, “Yesu gwama Nasaleta ꞌitautauya,” ");
INSERT INTO bdd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Coinega tomatagibugibuina ꞌibwau ꞌenana madounega ma ꞌigwae, “Yesu yo, ꞌowa Debida ꞌina susu, ꞌuꞌatemuyemuyegau!” ");
INSERT INTO bdd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma taudi tomotaedi sinugetama loheyaina siꞌausiya, sigwae, “Culolagu! Tuwa wui!” Ma tuwa ꞌibwau ꞌenana madounega ma ꞌigwae, “Debida tubuna yo, ꞌuꞌatemuyemuyegau.” ");
INSERT INTO bdd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Coinega Yesu ꞌitoholowa ta ꞌihegwaediya ma loheyaina sibwauweyama. Ta ꞌinao pwaima ta Yesu ꞌihesilaleya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Toꞌaha nuwanuwau ma yapaihowa ꞌoiuwa?” Coinega ꞌigwaeya, “Bada sowasowahina ma matagu ꞌuꞌabihe ꞌasilaladi?” ");
INSERT INTO bdd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Yesu ꞌigwaeya, “Bewa tuwa matau ꞌiꞌasilala, weyahina ꞌino hemisa ꞌoinega ꞌubwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nage ꞌoina matana ꞌiꞌasilala, ta maꞌina loyauwedo Yehoba ꞌoina Yesu ꞌimuliyeya. Ma bodaedi siꞌiteya, ta mabwaiyadi Yehoba sihepwatuweya. ");
INSERT INTO bdd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ma Yesu Yeliko ꞌoina ꞌiluhu pwaiya, ma ꞌasaina ꞌalonega ꞌitautauya. ");
INSERT INTO bdd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tupwaina ꞌoina ꞌaigeda takesi ꞌadi toꞌewao ꞌadi tohanugeta ꞌimiyamiya, sanina Sakiusa, tauna towasawasa ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma tutaina Yesu ꞌitautauya, Sakiusa nuwanuwana ma Yesu ꞌida ꞌita ꞌabehega taiya tauna, ma hesi geya sowasowahina ma ꞌiꞌita, weyahina tauna loheya toꞌutoꞌupana, ma wete boda madouna. ");
INSERT INTO bdd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Coinega ꞌipili nugeta ta ꞌaiwe ꞌaigeda ꞌihaneya, sanina sikamole, ta nage ꞌoinega Yesu ꞌida ꞌita, ꞌeguma saugaina tupwaina ꞌoina ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma saugaina Yesu ꞌinaoma tupwaina ꞌoina, ꞌiꞌitahaneya ta Sakiusa ꞌiꞌiteya, ꞌoinega ꞌihegwaeya, ꞌigwae, “Sakiusa, ꞌusuluma mwayamwayau, weyahina nata taugu baꞌidau ꞌino hada tamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiusa ꞌilomwayamwayauwa ta ꞌisuluwa, ma maꞌina yaliyaya Yesu baꞌidana sihelobaloba. ");
INSERT INTO bdd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nage ꞌoina tomotaedi ginaula bewa siꞌiteya, ma silomugiyeya, sigwaeya, “Togidega ta Yesu ꞌiluhuwa togala ꞌina hada?” ");
INSERT INTO bdd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Sakiusaina ꞌitoholowa ta Yesu ꞌihegwaeya, ꞌigwae, “Bada, bewa ꞌoinega ꞌigu tobwatobwa mabwaiyana yaꞌupwaluwa ma ꞌaigeda tupwa towewelohe yaꞌebwaedi. Ta wete ꞌeguma taiya ꞌoinega mwalo yaꞌewa puiya, yada hemaise maꞌana lohepoi ꞌehata wete yaꞌebwae.” ");
INSERT INTO bdd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Coinega Yesu ꞌihegwaeya, “Bewa tuwa hada bewa ꞌoina ꞌabihetena ꞌilatuma, weyahina loheya bewa tauna ꞌaigeda Ebalahamo ꞌina boda. ");
INSERT INTO bdd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Taugu Loheyaiguina, ta yanaoma ma ꞌane todeya yaꞌebesedi ma yaꞌabihetedi, gide loheya bewa.” ");
INSERT INTO bdd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma Yelusalema deina nata ma silatu, eeta bodaedi sinuwanuwatuhu ꞌabehega Yehoba ꞌina loina nata ꞌihegaina, ꞌoinega gwae hegehegedi bewa ꞌiꞌebwaediya, ");
INSERT INTO bdd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ꞌigwaeya, “Caigeda bada ꞌiꞌatububu pwaiya ta ꞌitautauya tupwana bwaga ꞌoina ma ꞌabehega nobwa ꞌihetoloina, ma ꞌabwa muliyetega ꞌilohihilama. ");
INSERT INTO bdd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mulina ma ꞌitauya, ꞌina topaihowao teni ꞌibwau heꞌautedima ma ꞌadi heguheguyai kina ꞌaigeda ꞌaigeda ꞌiꞌebwaediya ma ꞌihegwaediya, ‘Cami heguheguyai bewa wahepaihowadi ma ꞌana lohepoi waloba, ꞌana siga yalohihilama.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma muliyetega badaina ꞌina tomotaiyao tupwadi silogwahateya, geya nuwadi ma ꞌoidiya ꞌihetoloina, ꞌoinega wasa sihesumaneya, sigwaeya, ‘Loheyaina beno geya nuwama ma ꞌoima ꞌihetoloina.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma badaina tuwa ꞌihetoloina. Eeta tutaina ꞌilohihilama ta ꞌina topaihowaedi ꞌibwau heꞌautedima, nuwanuwana ꞌisanapu ꞌadi heguheguyaiyedi ꞌoidiyega hisa loheposeyana silobediya. ");
INSERT INTO bdd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ma loheya ꞌaigeda ꞌinugetama ꞌina badaina matana ꞌitoholowa, ma ꞌihegwaeya, ꞌigwae, ‘Bada, ꞌino kinaina ꞌaigeda mwalo ꞌuꞌebwaegauwa bewa ꞌana lohepoi wete teni yalobediya.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Coinega badaina ꞌigwaeya, ‘Causala! Cowa toguibiga moisa, weyahina ginaula ꞌiꞌiuna ma ꞌuhepaihowa bwaibwainiya, ꞌoinega maisau yaꞌebwaego, beno ꞌasa teni ꞌoidiya ꞌuhetoloina.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ma loheya heluwena wete ꞌinaoma ta ꞌigwaeya, ‘Bada, ꞌino kinaina ꞌaigeda mwalo ꞌuꞌebwaegauwa bewa ꞌana lohepoi paibi yalobediya.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Coinega tauna wete ꞌihegwaeya, ꞌigwae, ‘Casa paibi ꞌoidiya ꞌuhetoloina.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ma hetoina wete ꞌinaoma ma ꞌihegwaeya, ‘Bada, ꞌino kinaina bewa ꞌaleꞌo ꞌoinega yawaduya ta yalagu bwaibwainiya. ");
INSERT INTO bdd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Weyahina yamatautegowa ꞌamuge ma ꞌiꞌwaiha. Ma moisa, yamatautegowa weyahina ꞌowa loheya paꞌaliu ma ꞌino wasawasa ꞌuꞌewaꞌewa hali tomota ꞌidi paihowa ꞌoidiyega. Coinega ꞌino kina bewa ꞌuꞌewa hila.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ma badaina ꞌigwaeya, ‘Moisa, ꞌowa topaihowa galau. Tuwa ꞌuboi ꞌino gwaeyega ꞌa loina yaꞌebwaego. Weyahina ꞌusanapugauwa ꞌabehega taugu loheya paꞌaligu, ta ꞌigu wasawasa yaꞌewaꞌewa hali tomota ꞌidi paihowa ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ma toꞌaha huhuna ta ꞌoinega geya ꞌigu maneina banika ꞌoina ꞌulagu, ma saugaina yahilama maꞌana lohepoi yaloba?’ ");
INSERT INTO bdd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Coinega taudi badaina deina sitotoholo ꞌihegwaediya, ꞌigwaeya, ‘Cigu kinaina ꞌoinega waꞌewa, ma loheyaina tauna loheposeyana madouna ꞌilobeya waꞌebwae.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ma taudi sigwaeya, ‘Bada, sahena ꞌaꞌebwaꞌebwae, weyahina tauna teni kina ꞌiꞌewediya ta sowasowahina.’ ");
INSERT INTO bdd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ma badaina wete ꞌoidiya ꞌigwaeya, ‘Tuwa waꞌebwae, weyahina ꞌeguma taiya ꞌana heguheguyai ꞌiloheposeyane, ꞌana loheposeyana wete ꞌiloba, ma ꞌeguma taiya geya ꞌiloheposeyane, toꞌaha ꞌoina ꞌimiyamiya ꞌabwa ꞌoinega siꞌewayahule. ");
INSERT INTO bdd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Coinega bewa tuwa ꞌagu ꞌalehaowedi, taudi silogwahategauwa ma ꞌabehega geya nuwadi ꞌoidiya yahetoloina, watoedima ma mataguwa waloheꞌamasidi.’” ");
INSERT INTO bdd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ꞌina gwae bewa ꞌilosalohiya ma ꞌitoholowa, ta maꞌana tomuliyao sihanehane Yelusalema weyahina, ");
INSERT INTO bdd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ta ꞌidi tauya ꞌoina Bedipegi ma Bedani deidiya silatulatu, beno Olibe ꞌoyana gabulena, ꞌoinega ꞌana tomuliyao ꞌeluwa ꞌihesumane nugetediya tupwaedi ꞌiꞌiudi ꞌoidiya maꞌadi henuwalagu, ");
INSERT INTO bdd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ꞌigwaeya, “Casa nage matamiya ꞌoina watauya, ta nage ꞌoina nata ꞌaigeda hebai waꞌitaloba, beno ꞌase yauyaubona, tauna geya tomota sida gelu tohoya, hebaiina walihasi waꞌeweyama. ");
INSERT INTO bdd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma ꞌeguma taiya ꞌigwae, ‘Toꞌaha weyahina beno hebaiina walihalihasi?’ loheyaina wahegwae, wagwae, ‘Bada nuwanuwana.’” ");
INSERT INTO bdd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Coinega taudi sitauya ta ginaula mabwaiyadi silobediya gide Yesu ꞌihegwae ꞌesediya. ");
INSERT INTO bdd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma tutaina ꞌaseina silihasiya ma toni hebaiyedi sihegwaediya, sigwaeya, “Togidega ta ꞌima hebai walihalihasi?” ");
INSERT INTO bdd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta sigwaeya, “Bada nuwanuwana.” ");
INSERT INTO bdd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma hebaiina siꞌeweya ta sitauyeya Yesu ꞌoina, ma ꞌadi ꞌwamega gwahuna siloyesoya, ꞌoinega Yesu ꞌigeluhaneya, ");
INSERT INTO bdd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ta ꞌitautauya ma tomota baibaiwadi ꞌadi ꞌwamao ꞌedai siyesodiya. ");
INSERT INTO bdd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Silatulatu Yelusalema deina, ta sidobidobi Olibe ꞌedana ꞌoina, ta ꞌana tomuliyaowedi mabodaidi maꞌidi yaliyaya Yehoba sihehepwatuwe, weyahina ꞌina paihowa waiwaidi siꞌita pwaidiya, ");
INSERT INTO bdd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","sigwaegwae, “Yauwedo Bada, Yehoba Saninega ꞌutauyama, ꞌoinega yaliyaya ma hepwatu galewa ꞌoina simadou hedada.” ");
INSERT INTO bdd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Coinega Palisiyao tupwadi bodaedi ꞌoidiyega Yesu sihegwaeya, sigwaeya, “Bada, ꞌa tomuliyaedi ꞌuhegwaedi ma silolagu.” ");
INSERT INTO bdd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Yesu ꞌigwaeya, “Sahena yaꞌauꞌausidi, weyahina ꞌeguma taudi silolagu daꞌule ꞌenadi ꞌilagu ma sibwau.” ");
INSERT INTO bdd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ꞌilatu pwaiya Yelusalema deina, ma ꞌasaina madouna ꞌiꞌiteya, nuwana ꞌigala ma ꞌidouwa, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yelusalema yo, nata tomotaimwao ꞌatemuyamuyaidi, weyahina tuta bewa ꞌoina ꞌadi ꞌabihetenaina ꞌihapwesama, ma hesi geya sisanapu. ");
INSERT INTO bdd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma hesi tuta ꞌinaonaoma ꞌoidiya ꞌadi ꞌalehao silatu ma simutudi, weyahina nata ꞌino tupwa mabwaiyana siꞌali sakowasiye, ");
INSERT INTO bdd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ma mabwaiyadi siluhu ma tomotaimwao silohegumwalidi, ma wete hada mabwaiyadi sileꞌwa yahuledi. Muyaedi ꞌabwa ꞌoiuwa silatu, weyahina natumwaowedi ꞌadi toꞌabihetenaina geya siꞌinana.” ");
INSERT INTO bdd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Coinega ꞌitauya ta ꞌiluhuwa Hada Heꞌasisi ꞌalona, ma tohegimwane ꞌalonega ꞌipaꞌidiya, ma ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ꞌigwaeya, “Buki Heꞌasisi ꞌoina Yehoba ꞌina gwae sileleya ꞌigwaeya, ‘Cigu hada ꞌabehega hada ꞌebe ꞌahwanoi, ma ꞌomi waꞌabibuiya ta ꞌabehega ꞌimi ꞌebeyagaha.’” ");
INSERT INTO bdd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma sabwelo ꞌaigeda ꞌaigeda Hada Heꞌasisiina ꞌoina ꞌiheheꞌita, ma topwaoli madoudi ta loina ꞌana toheꞌitao ma wete tohanugetao sitohotoho ma ꞌabehega Yesu siloheꞌamasi, ");
INSERT INTO bdd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ma geya sowasowahidi, weyahina Yesu ꞌina heꞌitao tomota baibaiwadi nuwadi ꞌiꞌeweya. ");
INSERT INTO bdd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Caigeda tuta ꞌoina Yesu ꞌiheheꞌita Hada Heꞌasisi ꞌoina, beno tetela bwebweꞌana ꞌihehepwaila tomota ꞌoidiya, ma topwaoliyao ma loina ꞌana toheꞌitao ma wete babadao sinaoma ta Yesu sihesilaleya, ");
INSERT INTO bdd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","sigwae, “Loheya, taiya ꞌina loinega ta bewa gide ꞌupaipaihowa ꞌese?” ");
INSERT INTO bdd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma Yesu ꞌihegwaediya, ꞌigwaeya, “Nugeta yahesilala ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Taiya ꞌina loinega ta Yoni toꞌabihebabitaiso ꞌipaihowa? Yehoba bo ꞌaigeda tomota?” ");
INSERT INTO bdd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Coinega taudimo ꞌoidiya sinuwanuwatuhu, ta sigwaeya, “Cina gwae togidega tahemaisa ꞌese? Weyahina ꞌeguma tagwae, ‘Yehoba ꞌoinega’ nata ꞌihegwae hilegita ꞌigwae, ‘Ma! Toꞌaha hede weyahina ta Yoni geya wahemise?’ ");
INSERT INTO bdd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma ꞌeguma tagwae, ‘Tomota ꞌoinega,’ tabu ta boda daꞌuleyega siꞌahu yamategita, weyahina tomota mabwaiyadi Yoni sihemisaeya ꞌabehega tauna ꞌaigeda palopita.” ");
INSERT INTO bdd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Coinega ꞌina hesilalaina geya sihemaise bwaibwaini, ma hesi sigwaeya, “Geya ꞌasanapu.” ");
INSERT INTO bdd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yesu wete ꞌigwaeya, “Taugu wete sahena ꞌoimiya yahehepwaila latuwe ꞌabehega taiya ꞌina loinega ta bewa gide yapaipaihowa ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Coinega Yesu tomotaedi ꞌigwae hegehegediyediya ꞌigwaeya, “Caigeda loheya ꞌina tanoha gileipa daisinamo ꞌiꞌumeya, ma ꞌina topaihowao ꞌihegwaediya ma siꞌitaꞌitayahi, ma tauna ꞌitauya hali tupwa, ta nobwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Ma hedodona ꞌana tuta badaina ꞌina hewali ꞌaigeda ꞌihesumane hileya ma ꞌabehega gileipa huwaina tanoha ꞌana toꞌitayahinao ꞌoidiyega ꞌiꞌeweyama. Citautauya ta geya siꞌebwae, ma hesi sisapiya ta manimenimenamo sihesumaneya ta ꞌihila. ");
INSERT INTO bdd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Coinega badaina ꞌina hewali heluwena wete ꞌihesumaneya ꞌoidiya, ta sihunuya, ta wete siꞌabihedeba mwadineya, ta sihesumaneya ꞌihila. ");
INSERT INTO bdd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Ma wete hetoina ꞌihesumaneya ꞌoidiya, ta wete sihunu heꞌiꞌiwasiya, ma sipaꞌi latuweya. ");
INSERT INTO bdd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Coinega toni tanohaina ꞌinuwanuwatuhu, ꞌigwaeya, ‘To ꞌeda wete yapaihowa? Tuwa taugu natuguina yahesumane ma ꞌoinega siꞌamayabe, weyahina tauna tuwa natugu.’ ");
INSERT INTO bdd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ma saugaina topaihowaedi bada natuna siꞌiteya ꞌinaonaoma siboidimo ꞌoidiya sigwaegwae, ‘Ciyagwao, loheya nage ꞌinaonaoma, tauna badaina natuna ꞌaigeda tuwa, ꞌoinega nata tuwa taloheꞌamasi ma tauda tanoha taloinae.’ ");
INSERT INTO bdd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Coinega siꞌabiyahiya ta tanohega siula latuweya mulimuliya, ta nobwa siloheꞌamasiya.” Ma Yesu ꞌina heꞌoteꞌotetela ꞌigumwala pwaiya ta ꞌihesilala ꞌoidiya, ꞌigwaeya, “Toꞌaha nata badaina ꞌina toꞌita yahinaowedi ꞌoidiya ꞌipaihowa? ");
INSERT INTO bdd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Moisa, badaina ꞌabwa ꞌilatu ma topaihowaedi ꞌiloheꞌamasidi, ma ꞌoinega tanohina hali toꞌitayahinao ꞌiꞌebwaedi.” Babadaedi Yesu ꞌina gwae bewa gide sihesagoheya ta sigwaeya, “Tauda sahena wete gide!” ");
INSERT INTO bdd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Yesu ꞌiꞌebubudiya ta wete ꞌoidiya ꞌigwaeya, “Togidega ꞌana sanapu Buki Heꞌasisi ꞌina hepwailaina, ꞌigwaeya, ‘Logidiina mwalo tohadaꞌabi silogwahateya, ta tuta bewa sihetoholo nugeteya hada mataꞌahwanina ma logidi mabwaiyadi ꞌiloinaedi.’ ");
INSERT INTO bdd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ceguma taiya ꞌibeꞌu logidi bewa ꞌoina, nata luluna ꞌilasadi, ma logidiina ꞌeguma ꞌibeꞌu ꞌaigeda taiya tabwanina nata wahina ꞌiꞌahu piyapiyeyamo.” ");
INSERT INTO bdd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bewa ꞌoina topwaoliyedi ta loina ꞌana toheꞌitao ꞌedaꞌeda siꞌebeseya ta ꞌabehega Yesu siꞌabiyahi, weyahina sisanapuya ꞌabehega taudi tuwa weyahidi ꞌigwae hegehegediya, ma hesi geya siꞌabiyahi weyahina boda ꞌoidiya simatauta. ");
INSERT INTO bdd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eeta tuta baibaiwana Yesu silolomatayahi ma ꞌabehega toꞌaha ꞌina pui siloba, eema ꞌoinega sihepwaile toloina ꞌoina ma ꞌiheyatalae, ꞌoinega tomota tupwadi sihesumanediya Yesu ꞌoina ta hesilalega siꞌabowe ma ꞌabehega ꞌina pui siloba. ");
INSERT INTO bdd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma tomotaiyedi sinaoma ta Yesu sihegwaeya, sigwae, “Bada, moisa ꞌowa ꞌino gwaeyao ta ꞌino heꞌitao mabwaiyana dumwaludi, ma wete ꞌasanapugowa ꞌabehega geya wete ꞌaigeda loheya ꞌuda matauteya, ma hesi Yehoba ꞌina nuwatuhu ꞌana toheꞌita moisa ꞌowa. ");
INSERT INTO bdd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Coinega togidega, sowasowahina ma Kini Sisa weyahina takesi talagu, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Yesu boꞌi ꞌidi ꞌaboina ꞌisanapuya, ꞌoinega ꞌihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ꞌigwaeya, “Hana maneina waꞌeweyama yaꞌita.” Coinega siꞌebwaeya ta ꞌihegwaediya, ꞌigwaeya, “Wahegwaegau taiya bewa maꞌamaꞌayauna ma sanina maneina ꞌoina?” Ta taudi sigwaeya, “Kini Sisa.” ");
INSERT INTO bdd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Coinega Yesu ꞌigwaeya, “Cehe gide! Ceguma Kini ꞌina ginaula waꞌebwaya Kini ꞌoina, ma ꞌeguma Yehoba ꞌina ginaula Yehoba waꞌebwae.” ");
INSERT INTO bdd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu ꞌina gwae bewa boda matadiya mabwaiyana dumwaluna, ta geya ꞌaigeda wete ꞌina gwae pui siloba, ta ꞌatedi ꞌiyohowa ma simiya henonowa. ");
INSERT INTO bdd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Coinega wete tupwana Sadusiyao, taudi geya sihemisa toꞌamasa ꞌidi toholo hila weyahina, sinaoma ta Yesu ꞌoina sihesilala, sigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bada, loina bewa gide Mosese ꞌileleya weyahida, ꞌigwaeya, ‘Ceguma ꞌaigeda loheya ꞌihai ma geya natunamo ma ꞌiꞌamasa, loheyaina tasina hiwapeina baꞌidana sihai ta ꞌoinega ꞌeguma wahineina ꞌihenatuna, natunaina toꞌamasina ꞌana miyalaena.’” ");
INSERT INTO bdd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Coinega ꞌebeꞌita siꞌebwaeya, sigwaeya, “Caigeda loheya matasinao simiyamiya ꞌadi baibaiwa site sebeni, ta ꞌadi tautuwaina ꞌihaiya ta geya natunamo, ma muliyetega loheyaina ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Coinega tasina deinega hiwapeina ꞌiꞌeweya ta wete simiyamiyana ta geya natunamo, ta loheyaina ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Coinega tasina wete deinega hiwapeina ꞌihaiya, ta wete gide geya natunamo, ta ꞌiꞌamasa. Ta gide tuwa tasinao mabwaiyadi hiwapeina sihaihaiya siꞌamasa, ma geya natudiyaomo, ");
INSERT INTO bdd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ta muliyetega wahine wete ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ma toꞌaha ꞌunuwatuhuya tomotaedi weyahidi, to loheya wahineina mwanena moisa, tutaina ꞌeguma ꞌamasega sitoholo hila? Weyahina site sebeniyedi sihaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ta Yesu ꞌidi gwae ꞌihemaiseya, ꞌigwaeya, “Wanuwatuhuyahi ꞌabehega tuta bewa ꞌoina wahine ma loheya sihaihai, ");
INSERT INTO bdd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ma hesi tuta ꞌinaonaoma ꞌoina ꞌeguma wahine ma loheya sowasowahidi ma ꞌamasega sitoholo hila nata geyaꞌabwa wete sihaihai. ");
INSERT INTO bdd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Weyahina nata taudi gide aneloseyao, ta geyaꞌabwa wete siꞌamaꞌamasa hila, ma hesi Yehoba ꞌiꞌahwa natunedi weyahina ꞌamasega sitoholo hila. ");
INSERT INTO bdd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Ma Mosese mwalohene ꞌiheꞌita bwaibwainigita toꞌamasa ꞌidi toholo hila weyahina. Saugaina Mosese pwatula ꞌalona ꞌitautauya ta Yehoba ꞌaiwe sabelulu ꞌoinega ꞌihegwaeya, ꞌigwaeya, “Taugu Ebalahamo ta Aisake ta Yakobo ꞌidi Yehoba.’ ");
INSERT INTO bdd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bewa ꞌana nuwasabwalena ꞌabehega geya toꞌamasa ꞌidi Yehoba, ma hesi taudi mayawasidi ꞌidi Yehoba, weyahina babadaedi Yehoba ꞌina tupwa tuta bewa mayawasidi simiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Nage ꞌoina loina ꞌana toheꞌitao simatauta ta tupwadi sigwaeya, “Toheꞌita, ꞌino maisa bwebweꞌana hedade,” ꞌoinega geya ꞌaigeda wete hesilala siꞌebwaꞌebwae. ");
INSERT INTO bdd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Coinega Yesu wete ꞌihesilala ꞌoidiya ꞌigwaeya, “Togidega ta ꞌoinega tomota tupwadi sigwaeya, ꞌabehega Debida ꞌina susuwega Toꞌabihetenaina Keliso ꞌilatu, ");
INSERT INTO bdd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","weyahina buki wali Same ꞌoina Debida ꞌina gwae ꞌigwaeya, ‘Yehoba ꞌigwaeya ꞌigu Bada ꞌoina ꞌigwaeya: Cigu ꞌebeulega ꞌumiyatoi, ");
INSERT INTO bdd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta ꞌana siga ꞌa ꞌalehao yalagu suluhedi ꞌaheu ꞌadi ꞌebelagu gabulena.’ ");
INSERT INTO bdd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Debidaina ꞌina Bada Keliso, ma togidega hede Debida ꞌina susuwega muliyetega Keliso ꞌilatuma?” ");
INSERT INTO bdd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Coinega boda mabwaiyadi sihehenono, ma Yesu ꞌana tomuliyao ꞌihegwaediya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tasigwao, sahena loina ꞌana toheꞌitao ꞌidi mumuga wamulimuliye. Weyahina taudi mumugadi tuwa gide tuta baibaiwana nuwanuwadi ma ꞌadi ꞌaleꞌowao duduledi siꞌotedi ma tomota gamwagamwanidiya sisakosakowasi ma ꞌabehega siheꞌasisiyedi. Ta wete nuwanuwadi ꞌidi ꞌebemiya bwebweꞌadi Hada Tapwalolo ꞌoidiya, ta wete guyai ꞌadi tuta nuwanuwadi ma wagahata simiyatoi. ");
INSERT INTO bdd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta wete tuta baibaiwana tomota matadiya Yehoba ꞌoina siꞌahwaꞌahwanoi dudulena, ma hesi ꞌidi ꞌahwanoiina geya bwebweꞌana, weyahina ꞌatediya sinuwanuwatuhu togidega nata hiwahiwape siꞌabo ꞌesedi ma ꞌidi tobwatobwao siꞌewadi. Coinega ꞌabwa Yehoba maisa galana ꞌiꞌebwaedi.” ");
INSERT INTO bdd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ꞌiꞌeꞌebubuna ta towasawasao ꞌidi helau mane helau ꞌana ꞌebelagu ꞌoina silagulagudi. ");
INSERT INTO bdd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ciꞌeꞌebubuna ta ꞌaigeda hiwape wewelohena ꞌiꞌiteya, ꞌilaga ta ꞌina helau toea ꞌeluwamo ꞌilagudiya. ");
INSERT INTO bdd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Coinega Yesu ꞌigwaeya, “Moisa yahegwaegomi mabwaiyadi ꞌoidiyega hiwape nage ꞌina helau madou hedade, ");
INSERT INTO bdd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","weyahina mabwaiyadi ꞌidi tupwa madouna ꞌimiyamiya, ma hiwape nage wewelohena ta ꞌina mane mabwaiyana ꞌilaguya. Geya ꞌaigeda wete ꞌina tupwa ꞌimiyamiya ma ꞌoinega ꞌana ꞌilogimwane.” ");
INSERT INTO bdd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma Yesu ꞌana tomuliyao tupwadi Hada Heꞌasisi ꞌana ꞌita bwebweꞌana siꞌiteya, ta Yesu siheꞌiteya ma sigwaeya, “Bada, Hada Heꞌasisiina ꞌana pasao ꞌadi ꞌita bwebweꞌana hedade, weyahina daꞌule madoudi ꞌoidiyega siꞌabiya, ma wete tomota ꞌidi helauwao bwebweꞌadi ꞌoidiyega sihepaseya.” Ma Yesu ꞌoidiya ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Hadaina nige waꞌiteya, ma tuta ꞌinaonaoma ꞌoina mabwaiyana sileꞌwa yahuledi, ma sahena wete ꞌaigeda tupwa waꞌitaꞌita hile.” ");
INSERT INTO bdd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Coinega Yesu ꞌoina sihesilala, sigwaeya, “Toheꞌita ꞌuhegwaemai to tuta ꞌoina Hada Heꞌasisiina siligehi, ma to ꞌilaꞌilala ꞌadi ꞌita ꞌoidiyega ꞌada sanapu ꞌabehega ginauledi ꞌugwaenediya nata silatuma?” ");
INSERT INTO bdd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta Yesu ꞌoidiya ꞌigwaeya, “Waꞌitayahigomi ꞌamuge ta tomota tupwadi siꞌabowegomi, weyahina ꞌabwa tomota tupwana baibaiwana saniguwega sinaoma ma ꞌabehega sinugeta puiyegomi, ma ꞌaigeda ꞌaigeda ꞌigwae, ‘Taugu Toꞌabihetena,’ ma tupwadi wete sigwae, ‘Toꞌabihetenaina ꞌina tuta ꞌiꞌehohoyama.’ Ma hesi sahena taudi ꞌenadi wamulimuliyedi. ");
INSERT INTO bdd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Ma ꞌeguma wete loꞌaleha ma sahiya wasana wahesagohe, sahena waꞌateꞌateyoho, weyahina ginaulaedi sida latu nugeta ma baleꞌu ꞌana ꞌebelosaloha ꞌabwa.” ");
INSERT INTO bdd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma wete ꞌihegwaediya, “Cabwa hali boda hali boda ꞌoidiya siloꞌaleha. Ma wete hali ꞌebeloina hali ꞌebeloina ꞌoidiya siloꞌaleha. ");
INSERT INTO bdd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Ma tutaina ꞌoina mwaniꞌiniꞌi hali tupwa ma hali tupwa ꞌoidiya, ma gomale madouna, ma wete muyamuya madoudi, ma wete nata ꞌebe henainaida ta ꞌebe matauta galewega silatuma. ");
INSERT INTO bdd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma hesi nugeta ꞌami ꞌalehao siꞌabiyahigomi ma siꞌabihe muyemuyegomi, ma wete hada tapwalolo ꞌoidiya siheyatalaegomi ma deliya silagugomi. Ma wete kiniyao ta toloinao matadiya sitoegomi ma siheyatalaegomi weyahina ꞌomi ꞌabehega ꞌigu bodao. ");
INSERT INTO bdd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Cimi yatalaedi ꞌoidiya wasagu wahepwaile ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma sahena wanuwanuwatuhu hedade, ꞌeguma tutaina watoho ma ꞌoidiya wagwaegwae, ");
INSERT INTO bdd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","weyahina taugu ꞌabwa gwae dumwaludi ta sanapu yaꞌebwaegomi ma ꞌami ꞌalehao gesowana siꞌahwa ꞌaboꞌabowegomi. ");
INSERT INTO bdd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Tutaina ꞌoina wete tamamiyao ta sinamiyao ta tasimiyao ta ꞌimi susuwao ta wete ꞌiyamiyao sitebaegomi, ta tupwadi ꞌoimiyega siloheꞌamasidi, ");
INSERT INTO bdd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ta tomota mabwaiyadi siloꞌalehegomi weyahina ꞌomi ꞌabehega ꞌagu tohemisao. ");
INSERT INTO bdd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma hesi sahena ꞌaigeda toꞌehimi siꞌabiꞌabihegala, ");
INSERT INTO bdd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ma ꞌomi watoholo paꞌala eeta ꞌoinega yawasimi hataya waloba. ");
INSERT INTO bdd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ma ꞌeguma to tuta ꞌoina Yelusalema waꞌita toloꞌalehao simiya sakowasiye wasanapuya ꞌabehega nata Yelusalema silohegwatu. ");
INSERT INTO bdd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Coinega Yudiya ꞌana tomiyao sowasowahidi ma ꞌoyai sidena. Ma wete Yelusalema ꞌana tomiyao sowasowahidi ma ꞌasega silatu. Wete gide taudi tanoha sipaipaihowa geyaꞌabwa ꞌasai siluhuluhu hila. ");
INSERT INTO bdd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabwelowedi ꞌoidiya Yehoba ꞌina yatala nata ꞌilatu tomota ꞌoidiya, ta ꞌoinega Buki Heꞌasisi ꞌina hepwaila nugeta mabwaiyana ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Tuta nage ꞌoina togamwagamwa ma tohesusuwao siꞌatemuyamuya, weyahina tuta mwauna mebaleꞌu weyahidi, ta nage ꞌoina nata Yehoba ꞌina gamwasowalega meYudiya ꞌiꞌabihe muyamuyadi moisa. ");
INSERT INTO bdd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nage ꞌoina toloꞌalehaowedi ꞌabwa tupwana tomota siloheꞌamasidi, ma tupwadi siꞌabiyahidi ta hali tupwa ma hali tupwa ꞌoidiya sitauyedi, ma toloꞌalehaowedi taudi tomiya ganamuli ꞌabwa sihewaiwai ma Yelusalema mabwaiyana siloine, ma ꞌoina sisakosakowasi ꞌana siga toloꞌalehaowedi ꞌidi loina ꞌilolagu. ");
INSERT INTO bdd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ma wete muliyetega ꞌebehenainaida silatuma sinala ma waiꞌena ta ꞌipwalao ꞌoidiyega, ma tomiya baleꞌu mabwaiyadi ꞌidi matautega sitaitai weyahina bagodu madoudi sidagugu hanema, ");
INSERT INTO bdd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ta ꞌoinega maꞌidi matauta madouna siyamwayamwa ꞌabehega to ginaula wete galana nata baleꞌuwa ꞌida latu, weyahina ginaula mabwaiyana galewa simiyamiya ꞌidi waiwai siꞌeloweꞌa. ");
INSERT INTO bdd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Taugu Loheyaiguina, ta tuta nage ꞌoina mebaleꞌu mabwaiyadi siꞌitegau yalohega yasulusuluma, maꞌigu waiwai ta maꞌigu wasawasa madouna. ");
INSERT INTO bdd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma ꞌeguma waꞌita ꞌilaꞌilalaedi bewa sihegaina hohau, beno waꞌatepatu ma waꞌitahane, ꞌami ꞌabihetena ꞌilatulatu.” ");
INSERT INTO bdd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Coinega Yesu wete ꞌaigeda gwae hegehegediyega ꞌihegwaediya, ꞌigwaeya, “Caiweina saido ma wete tupwana ꞌaiweyao ꞌeguma waꞌitadi, ");
INSERT INTO bdd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ta nabaidi ꞌehaudi ꞌigalugalu wasanapuya ꞌabehega losihe ꞌana tuta ꞌilohohoya. ");
INSERT INTO bdd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gide wete ꞌeguma ꞌilaꞌilalaedi waꞌitalobadi, beno wada sanapu ꞌabehega Yehoba ꞌina loina ꞌilatulatuma. ");
INSERT INTO bdd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yagwae moisa ꞌoimiya mehau ꞌomi sahena wagumwagumwala ta ꞌana siga ginaulaedi silatu nugeta. ");
INSERT INTO bdd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cabwa galewa ta baleꞌu sisawala ma hesi ꞌigu gwaeyao geyaꞌabwa sisawasawala. ");
INSERT INTO bdd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ma waꞌitayahigomi ma sahena ꞌeꞌahai ta numa weꞌaha waiwaidi ꞌoidiya watautauya hedade, ma wete sahena ꞌimi miya baleꞌuwa weyahina wanuwanuwatuhu hedade, ꞌamuge ma sabweloina ꞌoina Yehoba ꞌiloheꞌateyohogomi ta gide gomana ꞌoinega siꞌonegomi. ");
INSERT INTO bdd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Weyahina sabweloina ꞌoina mebaleꞌu mabwaiyadi ꞌiloheꞌateyohodi ꞌina bwaꞌomatana ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Coinega waꞌatububu hataya, ma tuta baibaiwana waꞌahwaꞌahwanoi ꞌabehega maꞌimi ꞌatepatu ginaulaedi ꞌoidiyega wahewaiwai, ma sowasowana watoholo taugu Loheyaiguina mataguwa.” ");
INSERT INTO bdd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tuta bewa ꞌoidiya Yesu Hada Heꞌasisi ꞌoina ꞌiheheꞌita, ta lahilahiya ꞌihilahila Olibe ꞌoyana ꞌoina ꞌiꞌenoꞌeno, ");
INSERT INTO bdd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ma gonagona ꞌaigeda ꞌaigeda tomota sitautauya Hada Heꞌasisi ꞌoina Yesu sabi hesagoheina. ");
INSERT INTO bdd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma Hataona Guyaina ꞌana tuta ꞌiꞌehohoya ta ꞌane pwalawa daisinamo geya ꞌana ꞌebe ꞌabisesehamo siꞌai. ");
INSERT INTO bdd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tutaina ꞌoina topwaoliyao madoudi ta loina ꞌana toheꞌitao sinuwanuwatuhu dadana togidega ma Yesu siꞌabiyahi ma siloheꞌamasi, ta geya sowasowahidi, weyahina boda simatautediya. ");
INSERT INTO bdd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nage ꞌoina Seitani Yudasa ꞌoina ꞌiluhuwa, tauna sanina heluwena Isakaliyota, ma wete tauna Yesu ꞌana tomuliya ꞌaigeda site tuwelo ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Coinega Yudasaina ꞌitauya Topwaoli Madoudi ta Hada Heꞌasisi ꞌana toꞌitayahinao ꞌoidiya, ma baꞌidadiu sihegwaegwaeya ꞌabehega togidega Yesu ꞌitebae ꞌese ma siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yudasa ꞌina gwae sihesagoheya ma siyaliyaya, ta ꞌoina sigwae hemisa ꞌabehega ꞌana maisa siꞌebwae. ");
INSERT INTO bdd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ma Yudasa wete ꞌoidiya ꞌitagwala, ꞌoinega tuta bwebweꞌana ꞌiyamweya ta ꞌabehega Yesu ꞌoidiya ꞌitebae ma siꞌabiyahi, ma sahena tomota matadiya. ");
INSERT INTO bdd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Coinega Hataona ꞌana sabwelo ꞌilatuwa, ta pwalawa geya ꞌana ꞌabihesesehamo siꞌai, ma wete lamiyao sihunudi Hataona ꞌana ꞌebenuwatuhu weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Coinega Yesu ꞌana tomuliyao Yoni ma Pita ꞌihegwaediya, ꞌigwaeya, “Watauya ma Hataona ꞌaiina weyahida waꞌatububu.” ");
INSERT INTO bdd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta taudi sigwaeya, “Taꞌeha ꞌoina nuwanuwau ma ꞌaꞌatububu?” ");
INSERT INTO bdd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Coinega ꞌoidiya ꞌigwaeya, “Watauya Yelusalema ꞌoina walatu, ma ꞌeguma ꞌaigeda loheya maꞌina weꞌaha patu ꞌiꞌahaliya waloba, loheyaina wamuliye, ma ꞌeguma hadai ꞌiluhuluhu ꞌomi wete hadaina ꞌoina waluhu, ");
INSERT INTO bdd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma tonihada wahegwae, wagwae, ‘Cima toheꞌita bewa gide ꞌigwae ꞌesa ꞌigwaeya, “To tupwa ꞌutagwale ma ꞌoina maꞌagu tomuliyao Hataona ꞌaiina ꞌaꞌai?” ’ ");
INSERT INTO bdd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma ꞌoinega nata tupwa madouna tabwana ta ꞌatuꞌatububuina ꞌiheꞌitegomi, tauna ꞌoina Hataona ꞌaiina waꞌatububu weyahida.” ");
INSERT INTO bdd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Coinega ꞌana tomuliyaowedi sitauya ta toꞌaha gide Yesu ꞌigwaeneya ꞌoidiya, ginauledi mabwaiyadi silobediya, ta hadaina ꞌoina Hataona ꞌeꞌahaiina siꞌatububuya weyahidi. ");
INSERT INTO bdd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ma ꞌeꞌahai siꞌatububu pwaiya, ta Yesu maꞌana tohepwailao simiya ꞌautama, ta baꞌidanao siꞌaiꞌai, ");
INSERT INTO bdd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ma ꞌidi ꞌaiina ꞌalona Yesu ꞌihegwaediya, ꞌigwaeya, “Nuwanuwagu madouna ma ꞌomi baꞌidagwao Hataona ꞌeꞌahaiina taꞌai ma muliyetega ꞌigu muyamuyao yalobadi. ");
INSERT INTO bdd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma yahegwaegomi ꞌigu ꞌai bewa ꞌana ꞌebelosaloha, ta geya wete Hataona ꞌaiina yalotolotoho hila ꞌana siga ꞌana sanapu moisa ꞌilatu Yehoba ꞌina ꞌebeloina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ta waini mabiyona ꞌiꞌeweya, ta weyahina ꞌiloyauwedowa Yehoba ꞌoina, ma muliyetega ꞌihegwaediya, ꞌigwaeya, “Biyo bewa waꞌewa ma ꞌaigeda ꞌaigeda mabwaiyami wanuma. ");
INSERT INTO bdd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma yahegwaegomi tuta bewa ma muliyetega waini bewa sahena ꞌoinega yanumanuma hila ta ꞌana siga Yehoba ꞌina loina ꞌilatu.” ");
INSERT INTO bdd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","20","Ta beledi ꞌiꞌeweya, ta weyahina ꞌiloyauwedowa Yehoba ꞌoina ma muliyetega ꞌiꞌabihisiya, ma ꞌoidiya ꞌiheguyaiya, ma ꞌihegwaediya, “Bewa wahigu, ");
INSERT INTO bdd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ma waꞌita, loheyaina tauna nata ꞌitebaegau tuta bewa baꞌidagu ꞌaꞌaiꞌai. ");
INSERT INTO bdd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Taugu Loheyaiguina ꞌabwa yatauya ꞌedaina mwalo Yehoba ꞌiloineya, ma hesi ꞌagu totebaina hesi ꞌatemuyamuyana!” ");
INSERT INTO bdd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Coinega ꞌana tomuliyaowedi taudi ꞌoidiya sihesilala, sigwaeya, “Taiya hede bewa gide ꞌina paihowa?” ");
INSERT INTO bdd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Coinega taudi ꞌoidiyega heꞌoheꞌohena ꞌilatuwa ꞌabehega taiya lohanena mabwaiyadi ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Coinega Yesu ꞌihegwaediya, ꞌigwaeya, “Baleꞌuwa kiniyao ꞌidi tomotao ꞌoidiya siloiloina, ta topaihowaowedi ꞌidi toloinao siꞌahwaꞌahwa bwebweꞌanedi, ");
INSERT INTO bdd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ma ꞌomi sahena gide taudi, ma hesi taiya tauna ꞌoimiyega lohanena ꞌida loduduna tauna gide tuwa ꞌimi hewali, ma wete ꞌimi tohanugetao sida hetopaihowa weyahimi. ");
INSERT INTO bdd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ma toꞌaha wanuwatuhuya, ꞌabehega taiya lohanena, ꞌeguma ꞌaigeda ꞌimiyatoi ꞌiꞌaiꞌai ta ꞌaigeda weyahina ꞌihehetapewa? Nuwana tauna toꞌai ꞌawa? Ma taugu tuwa tohetapewaina, weyahina waꞌita taugu gamwagamwanimiya bewa tuwa yahetahetapewa, ta taugu gide ꞌimi hewali. ");
INSERT INTO bdd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ma ꞌomi ꞌigu tuta mwau ꞌoidiyega boꞌi watoholo paꞌala, ta bewa tuwa ꞌomi baꞌidagwao tamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Coinega toꞌaha gide Tamagu ꞌigu ꞌebeloina ꞌiꞌebwaegauwa ꞌomi wete gide yaꞌebwae ꞌesegomi, ");
INSERT INTO bdd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ma ꞌoinega ꞌomi ꞌigu ꞌebeloina ꞌoina baꞌidagwao ꞌabwa taꞌai ma tanuma, ta wete wagahata wasawasa ꞌoidiya wamiyatoi ma meIsileli ꞌidi susuwao tuwelo waloinaedi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma wete Yesu ꞌigwaeya, “Saimoni gwae bewa ꞌuhesagohe, weyahina Seitani tagwala ꞌiꞌewa pwaiya ma mabwaiyami ꞌitohogomi, gide tuwa tobegula ꞌina witiyao ꞌiꞌahu hutuhutu tohodiya, ");
INSERT INTO bdd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ma sahena ꞌebetohoina ꞌoina ꞌuweꞌaweꞌa, weyahina weyahiu yaꞌahwanoi waiwaiya ꞌino toholo paꞌala weyahina. Coinega ꞌeguma to tuta ma ꞌunuwahilama ꞌeda ꞌausalana ꞌoina, tasimwao wete ꞌuꞌabihe waiwaiyedi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Coinega Pita ꞌigwaeya, “Bada, yapasima pwaiya weyahiu, ma ꞌeguma deliya silaguluguhego, taugu wete baꞌidau, ma ꞌeguma wete siloheꞌamasigo, taugu wete gide siloheꞌamasigau.” ");
INSERT INTO bdd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yesu ꞌihegwaeya, “Pita, yagwae moisa ꞌoiuwa, nata muliyetega ma ꞌamꞌam ꞌidou, ma nugeta ꞌowa ꞌuuhalaegau matoi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ta Yesu mabwaiyadi ꞌihegwaediya, ꞌigwaeya, “Mwalo yahesumanegomiya ma yahegwaegomiya, ꞌoinega geya ꞌimi mane ꞌana ꞌebedoꞌo bo ꞌimi peha bo ꞌami butu waꞌewaꞌewadi, ma togidega mwau walobeya?” Ta taudi sigwaeya, “Geya ꞌeta wete toꞌaha.” ");
INSERT INTO bdd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Coinega Yesu wete ꞌihegwaediya, “Bewa tuwa ꞌimi mane maꞌana ꞌebedoꞌo ma ꞌimi peha wete waꞌewadi. Ma ꞌeguma taiya ꞌoimiyega geya ꞌina ꞌelepa ꞌalehamo, ꞌana ꞌaleꞌo ꞌigimwaneye ma ꞌana maisa ꞌoinega ꞌina ꞌelepa ꞌida gimwane. ");
INSERT INTO bdd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Weyahina tuta ꞌilatu pwaima, ma ꞌoinega Buki Heꞌasisi ꞌoina mwalo ꞌaigeda gwae weyahigu sileleya, ꞌida latu moisa, ꞌigwaeya, ‘Siyatalaeyeya gide tuwa ꞌaigeda loina ꞌana toligeha.’ Ma wete gwae baibaiwana weyahigu sowasowana silatu.” ");
INSERT INTO bdd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ta taudi ꞌina gwae sihemaiseya sigwaeya, “Bada, ꞌima ꞌelepa ꞌalehao bewa ꞌeluwa.” Ma Yesu ꞌigwaeya, “Beno sowasowahina.” ");
INSERT INTO bdd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma Yesu ꞌasa madouna ꞌiꞌebesineya, ta maꞌana tomuliyao sihilama ꞌoya Olibe ꞌoina, beno ꞌidi ꞌebeꞌeno. ");
INSERT INTO bdd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tupwaina ꞌoina sinaoma, ta Yesu ꞌana tomuliyao ꞌihegwaediya, “Waꞌahwaꞌahwanoi Yehoba ꞌoina ma ꞌoinega sahena Seitani ꞌitohotohogemi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ta muliyetega ꞌana tomuliyao ꞌoidiyega ꞌihawasiya, ta taunamo nobwa ꞌahena ꞌitulaseya, ta ꞌiꞌahwaꞌahwanoi Tamana ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ꞌigwaeya, “Tamagu yo, ꞌeguma nuwanuwau, muyamuya biyoina bewa ꞌoiguwega ꞌuda ꞌewayahule. Ma sahena taugu ꞌigu nuwatuhu ꞌoinega, ma hesi ꞌowa ꞌino nuwatuhu ꞌoinega ꞌupaihowa.” ");
INSERT INTO bdd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Coinega anelose galewega ꞌilatuwa ta Yesu ꞌiꞌabihe waiwaiyeya, ");
INSERT INTO bdd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ma nuwana ꞌimwau hedadeya, ꞌoinega ꞌiꞌahwanoi waiwaiya, ta ꞌana ꞌamweyahi ꞌipesupesu baleꞌuwa, gide tuwa bweyaha ꞌidaudau. ");
INSERT INTO bdd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu ꞌina ꞌahwanoi ꞌilosalohiya, ma ꞌitoholowa ta ꞌihila, ꞌana tomuliyao ꞌiꞌitediya ꞌidi nuwamwau ꞌoinega siꞌeno sinediya, ");
INSERT INTO bdd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","eeta ꞌihegwaediya, ꞌigwaeya, “Sahena waꞌenoꞌeno! Watoholo ma waꞌahwaꞌahwanoi, sahena Seitani ꞌitohotohogemi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ꞌabwa ꞌilolohatoto ma boda silatuma, ta Yudasa baꞌidadiu, tauna Yesu ꞌana tomuliya ꞌaigeda, ta bodaedi ꞌihanugetedima. Yudasaina ꞌinaowa Yesu deina ta ꞌabehega ꞌiꞌatusapwali. ");
INSERT INTO bdd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Coinega Yesu Yudasa ꞌihegwaeya, ꞌigwaeya, “Yudasa, geya ꞌumwadina ma ꞌunaoma, ta taugu Loheyaiguina ꞌatusapwalega ꞌutebatebaegau!” ");
INSERT INTO bdd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma Yesu ꞌana tomuliyaedi sisanapu pwaiya toꞌaha nata ꞌilatu, ꞌoinega sigwaeya, “Bada, togidega, tahunudi?” ");
INSERT INTO bdd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eeta ꞌaigeda ꞌana tomuliyaina ꞌina ꞌelepa ꞌaleha ꞌiꞌabilagasiya ma Topwaoli Madouna ꞌina topaihowa tena ꞌebeulega ꞌiꞌupwa yahuleya. ");
INSERT INTO bdd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ta Yesu ꞌigwaeya, “Walolagu! Sahena gide!” Ta muliyetega Yesu loheyaina tenana ꞌiꞌabitohoya, ma ꞌiꞌabihe bwebweꞌaneya. ");
INSERT INTO bdd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu ꞌana toꞌabiyahinaowedi, taudi Topwaoli Madoudi ma Hada Heꞌasisi ꞌana toꞌitayahinao ta babadao sinaoma, ta Yesu ꞌihegwaediya, ꞌigwaeya, “Hede taugu toyagaha, ta ꞌoinega maꞌimi ꞌelepa ꞌaleha ta maꞌimi wepasi wanaoma sabi ꞌabiyahigau! ");
INSERT INTO bdd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ma toꞌaha huhuna ta ꞌoinega geya waꞌabiyahigau sabwelowedi mabwaiyadi gamwagamwanimiya yamiyamiya Hada Heꞌasisi ꞌalona yaheheꞌita tomota ꞌoidiya? Ma bewa tuwa ꞌabehega watoho ma waꞌabiyahigau weyahina loina guguyou ꞌina tuta ꞌilatu pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Coinega Yesu siꞌabiyahiya, ta sitoeya Topwaoli Madouna ꞌina hada. Ma Pita bwagebwagega ꞌimuliyedima. ");
INSERT INTO bdd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hadaina ꞌana ꞌabwalu ꞌalona topaihowao ꞌaiwe siholeya ta mabwaiyadi simwaimwailu. Pita ꞌiꞌitediya ta ꞌoidiya wete ꞌiluhuwa. ");
INSERT INTO bdd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Coinega topaihowa ꞌaigeda mewahinena Pita ꞌiꞌeꞌebubuya ta ꞌigwaeya, “Loheya bewa mwalo Yesu baꞌidana yaꞌitediya.” ");
INSERT INTO bdd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma Pita ꞌiuhala ta ꞌigwaeya, “Wahine, geya yasanapu taiya tauna weyahina ꞌugwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Muliyetega ꞌaigeda wete loheya Pita ꞌiꞌeꞌebubuya ta ꞌihegwaeya, ꞌigwae, “Cowa ꞌaigeda ꞌana tomuliyaina.” Ta Pita ꞌigwaeya, “Ciya! Taugu geya!” ");
INSERT INTO bdd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma tupwana simiya ꞌamana, ma loheya ꞌaigeda wete ꞌenana waiwaina ꞌoinega ꞌiyanao ꞌihegwaediya, ꞌigwaeya, “Moisa, loheya bewa Yesu ꞌana tomuliya ꞌaigeda, weyahina tauna gwama Galili.” ");
INSERT INTO bdd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Pita ꞌigwaeya, “Ciyagu, loheyaina weyahina ꞌugwaegwae geya yasanapu.” Cabwa ꞌigwaegwae ma ꞌamꞌam meloheyana ꞌidouwa. ");
INSERT INTO bdd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Coinega Yesu ꞌiꞌita hila ta Pita ꞌiꞌiteya, ta nage ꞌoina Pita ꞌinuwatuhu yahiya Badaina ꞌina gwae tutaina ꞌigwaeya, “Nata muliyetega ma ꞌamꞌam ꞌidoudou ma nugeta ꞌowa ꞌuuhalegau matoi.” ");
INSERT INTO bdd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eema Pita nuwana ꞌigala madouna, ta ꞌilatuwa ꞌatamana, ta ꞌidouwa. ");
INSERT INTO bdd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ta Yesu ꞌana toꞌitayahinao taudi Yesu silolotuyaneya ma sisapisapiya. ");
INSERT INTO bdd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma wete matana sipaiya ma sahena ꞌiꞌeꞌebubuna, ta sisapisapi ma sihehesilala, sigwaeya, “Cuhegwaemai taiya ꞌisapigowa? Weyahina ꞌugwae ꞌabehega ꞌowa palopita.” ");
INSERT INTO bdd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta wete tupwana gwae galadi ꞌoidiyega siheheliye ta ꞌana siga ");
INSERT INTO bdd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","gona ꞌiꞌadaleya, ma ꞌoinega meYudiya ꞌidi babadao, beno Topwaoli madoudi ta loina ꞌana toheꞌitao sideli ꞌauta, ma Yesu siꞌeweyama, ta gamwagamwanidiya sihetoholoya, ");
INSERT INTO bdd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ma sihesilaleya sigwaeya, “Cuhepwaila dumwalu ꞌoima, togidega ꞌowa Toꞌabihetenaina bo geya?” Coinega Yesu ꞌihegwaediya, ꞌigwaeya, “Geya wahemisaegau, ꞌoinega sahena yahehepwaila ꞌoimiya, ");
INSERT INTO bdd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","weyahina ꞌeguma hesilala yaꞌebwaegomi geyaꞌabwa wahehemaisadi. ");
INSERT INTO bdd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma wasanapu ꞌabehega tuta bewa ꞌoinega ma muliyetega taugu Loheyaiguina yamiyamiya Yehoba Tohewaiwai hedade ꞌina ꞌebeulega.” ");
INSERT INTO bdd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Coinega mabwaiyadi sigwaeya, “Cawa, tomada! Cowa Yehoba natuna?” Coinega ꞌidi gwae ꞌihemaiseya, ꞌigwae, “Beno wagwae pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Coinega taudi sigwaeya, “Boꞌi ꞌina gwae pui taloba pwaiya, ꞌoinega sahena wete ꞌana toheꞌewao weyahidi tanuwanuwatuhu, weyahina ꞌiꞌabo pwaiya ꞌabehega tauna Yehoba natuna.” ");
INSERT INTO bdd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Coinega mabwaiyadi sitoholowa, ta Yesu sitoeya ta sitauyeya toloina madouna sanina Pailato ꞌoina, sabi yatalae. ");
INSERT INTO bdd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sitauyeya Pailatoina ꞌoina, ta Yesu weyahina sihepwaila ꞌaboꞌabowa, sigwaeya, “Loheya bewa ꞌina heꞌita ꞌahesagohediya ta ꞌabehega tauma meYudiya ꞌihawasiyemai, beno gide ꞌigwaeya, ‘Sahena Kini Sisa ꞌana takesi walagulagu, weyahina taugu kiniina, ta Toꞌabihetenaigu.’” ");
INSERT INTO bdd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Coinega Pailato Yesu ꞌihesilaleya, ꞌigwaeya, “Togidega, ꞌowa meYudiya ꞌidi kini, wa?” Ta ꞌihegwaeya, ꞌigwae, “Beno ꞌugwae pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ta muliyetega Pailato topwaoliyedi ta bodao ꞌihegwaediya ꞌigwaeya, “Loheya bewa geya ꞌeta ꞌina pui yaloba.” ");
INSERT INTO bdd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma taudi tuwa siheꞌewa yahiya, sigwae, “Ciꞌaboꞌabowego beno, weyahina ꞌaloba pwaiya tomota ꞌiꞌaboꞌabowedi ma ꞌabehega gabemaniyao ꞌoidiyega ꞌiwatahidi. Weyahina Galili ꞌoina ꞌihegaineya ꞌina ꞌaboina, ta Yudiya tupwanao mabwaiyadi ꞌilohegumwalidiya, ma ꞌilatu pwaima tupwa bewa ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cidi gwae bewa Pailato ꞌihesagoheya ta ꞌihegwaediya, “Togidega tauna gwama Galili, wa?” ");
INSERT INTO bdd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma taudi sigwaeya, “Cehe, gide.” Coinega Pailato ꞌihegwaediya, ꞌigwaeya, “Galili beno Helodi ꞌina ꞌebeloina, ꞌoinega Yesu watauye Helodi ꞌoina ma tauna ꞌiloinae, weyahina bewa tuwa Helodi ꞌebwa Yelusalema ꞌoina ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sitauyeya Helodi ꞌoina, ta tutaina Helodi Yesu ꞌiꞌiteya ꞌiyaliyaya madouna, weyahina tuta dudulena Helodiina nuwanuwana ma Yesu ꞌiꞌita, weyahina wasana ꞌihesagoheya, ta ꞌina paihowa waiwaidi nuwanuwana ma ꞌiꞌitadi. ");
INSERT INTO bdd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Coinega Helodi Yesu ꞌihesilala hedadeya, ta geya ꞌaigeda wete ꞌida hemaiseya. ");
INSERT INTO bdd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta topwaoli madoudi ta loina ꞌana toheꞌitao silaga Helodi ꞌoina, ma Yesu siheheꞌewa tubatubali. ");
INSERT INTO bdd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma ꞌoinega Helodi maꞌina toloꞌalehao Yesu silolotuyaneya ta siꞌahwa galegaleya. Ma muliyetega kini ꞌana ꞌwama siheꞌoteya ma sihesumane hileya Pailato ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sabweloina ꞌoina Helodi ma Pailato ꞌidi hegamwagamwagu tuta dudulena ꞌoinega siheꞌiyaꞌiyaguwa. ");
INSERT INTO bdd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Coinega Pailato Topwaoli Madoudi ma babada ta tupwana meYudiyaedi ꞌibwau heꞌautedima, ");
INSERT INTO bdd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta ꞌihegwaediya, ꞌigwaeya, “Loheya bewa ꞌoiguwa waꞌeweyama ta wahepwaileya ꞌabehega tomota ꞌiꞌwaniyediya, ta matamiya yaheyatala pwaiyeya ma geya ꞌaigeda ꞌina pui yalobaloba ꞌimi heꞌewaowedi ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helodi wete geya ꞌaigeda pui ꞌilobaloba, ta ꞌoida ꞌihesumane hileyama. Coinega geya wete loheꞌamasa ꞌilobwaine, ");
INSERT INTO bdd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ma sapimo ꞌiloba, ma ꞌoinega yatagwala ma ꞌitauya.” ");
INSERT INTO bdd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO bdd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Coinega bodaedi mahemahetena sibwauwa sigwaeya, “Tauna ꞌiꞌamasa, ma hesi Balaba ꞌulihasi weyahima.” ");
INSERT INTO bdd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabaina loheꞌamasa weyahina deliya silaguya, weyahina tupwaina ꞌoina mwalo Balaba maꞌiyanao meLoma siloꞌalehediya, ta tupwana loheloheya siloheꞌamasidiya. ");
INSERT INTO bdd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ma Pailato nuwanuwana ma Yesu ꞌiꞌetolihasi, ꞌoinega boda wete ꞌihesilalediya, ");
INSERT INTO bdd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ma hesi taudi siꞌalamanimanini hedadeya, sigwaeya, “Kelose ꞌoina tatutu hepaꞌine!” ");
INSERT INTO bdd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailato ꞌina gwae hetoina ꞌoina ꞌihegwaediya, ꞌigwaeya, “Toꞌaha hede ꞌina pui ta ꞌoinega ꞌabehega ꞌamasa ꞌiloba? Weyahina geya ꞌeta wete galana ꞌoina yalobaloba. Ma hesi sapimo ꞌilobwaineya ma muliyetega yalihasi.” ");
INSERT INTO bdd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma hesi bodaedi tuwa ꞌabwa sibwaubwau hedahedade, sigwaegwae, “Kelose ꞌoina tatutu hepaꞌine!” Ta bodaedi ꞌidi gwae ꞌihewaiwaiya, ");
INSERT INTO bdd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ꞌoinega Pailato ꞌoidiya ꞌitagwala ma Yesu sida ꞌabihekelose. ");
INSERT INTO bdd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma loheyaina nuwanuwadi ꞌiꞌetolihasi weyahidi, tuwa ꞌiꞌetolihasiya, tauna toloheꞌamasaina deliya silaguya mwalo tutaina tauna meLoma ꞌidi tohanugetao ꞌiloꞌaleha ꞌoidiya. Coinega Pailatoina boda nimadiya Yesu ꞌilaguya, ma ꞌidi nuwatuhuina sida losalohi. ");
INSERT INTO bdd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesu sitoe pwaiya ta sitauyeya, ma ꞌedai ꞌaigeda loheya sanina Saimoni silobeya, tauna gwama Sailini, pwatulega ꞌilatuma ta ꞌitautauya ꞌasai. Coinega toloꞌalehaowedi Saimoniina siloineya ta Yesu ꞌana kelose ꞌiꞌahaliya, ta ꞌimuliya. ");
INSERT INTO bdd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma boda madouna Yesu simuliyeya, ma wete wahiwahine baibaiwadi simulimuliya, ma sidoudou maꞌidi nuwagala Yesu weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma Yesu ꞌiꞌitahila ta wahiwahineyedi ꞌihegwaediya, “Comi Yelusalema wahiwahinediyao, sahena weyahigu wadoudou, ma ꞌomi waboi weyahimi ma natumiyao weyahidi wadou, ");
INSERT INTO bdd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","weyahina tuta ꞌinaonaoma ꞌoina mwau ꞌilatu ma taiyawedi ꞌomi ꞌagaꞌagalimi, nuwana geya natumimo, nata bwebweꞌana waloba. ");
INSERT INTO bdd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Weyahina tutaedi ꞌoidiya ꞌabwa tomota ꞌoya ꞌoidiya sigwae, ‘Coya, wabeꞌuma ma wasamumai!’ ");
INSERT INTO bdd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Moisa, taugu nata yahesilae, ma ꞌomi ꞌabwa wahesilae geyogeyoi. Weyahina taugu gide ꞌaiwe ꞌidahigu, ma ꞌomi tuwa gide ꞌaiwe ꞌamaꞌamasidi.” ");
INSERT INTO bdd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma togala wete ꞌeluwa sitoediya ta Yesu baꞌidanao siloheꞌamasidi. ");
INSERT INTO bdd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Coinega ꞌaigeda tupwa ꞌoina silatuwa, sanina Mwagu, ma tupwaina ꞌoina kelose baleꞌuwa silaguya ma Yesu situtu hepaꞌineya ma sihetoholoya, ma togalaedi siteluwa wete ꞌadi kelose ꞌoidiya situtu hepaꞌiyediya, ta ꞌaigeda Yesu ꞌebeulanega, ma heluwena Yesu ꞌadigeyageyanega sihetoholodiya. ");
INSERT INTO bdd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Coinega Yesu ꞌigwaeya, “Tamagu yo, ꞌidi pui bewa ꞌunuwasamudi, weyahina geya sisanapu toꞌaha sipaipaihowa.” Ma toloꞌalehaowedi Yesu ꞌana ꞌwama siꞌeweya, ta ꞌoinega siꞌeheyaheyaleya, tuwa gide siulahesinuwa, ma ꞌoinega ꞌeguma taiyawedi sinugeta ꞌwamaedi siꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nage ꞌoina tomota siꞌeꞌebubuna, ta meYudiya ꞌadi tohanugetao Yesu silolotuyaneya, sigwaegwae, “Hali tomota ꞌiꞌabihetediya, ma hana bewa tuwa tauna ꞌida ꞌabihete, ꞌeguma tauna Toꞌabihetena Keliso Yehoba ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Toloꞌalehaowedi wete Yesu silotuyaneya, ta waini memaina siꞌeweyama ta siꞌabihaneheya, ");
INSERT INTO bdd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma sigwaeya, “Ceguma ꞌowa meYudiya ꞌidi kini, ꞌuꞌetopelego ꞌuboi.” ");
INSERT INTO bdd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma wete ꞌana kelose pwatana ꞌina ꞌamasa huhuna sileleya, ꞌigwaeya, “Loheya bewa meYudiya ꞌidi kini.” ");
INSERT INTO bdd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Keloseyedi ꞌoidiyega ꞌaigeda togalaina Yesu ꞌiheliyeya, ꞌigwaeya, “Toꞌaha weyahina ꞌowa Toꞌabihetenaina, ma geya ꞌuꞌetopelegita?” ");
INSERT INTO bdd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma togalaina heluwena ꞌiyanaina ꞌiheliyeya, ꞌigwae, “Togidega Yehoba geya ꞌumataute? Ma ꞌuhesagohe tatetoi ꞌada loina ꞌaigeda tuwa siꞌebwaegita, ");
INSERT INTO bdd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ma loinaina ꞌowa ma taugu ꞌilobwainegita, weyahina tauda togala, ma loheya bewa geya ꞌeta ꞌina puimo.” ");
INSERT INTO bdd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Coinega loheyaina Yesu ꞌihegwaeya, “Yesu, ꞌabwa ꞌino hetoloina ꞌana tuta, sowasowahina ma ꞌunuwatuhugau?” ");
INSERT INTO bdd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Yesu ꞌigwaeya, “Yagwae moisa ꞌoiuwa, ꞌowa ma taugu tupwa ꞌausalana ꞌoina nata tamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Casudiladila ma sinala ꞌiguguyouwa, ꞌoinega tupwa mabwaiyana ꞌiguguyouwa ta ꞌana siga lahilahiya ꞌasa ꞌiꞌasilala hila. ");
INSERT INTO bdd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma ꞌaleꞌoina ꞌoinega Hada Heꞌasisi sibiliupeya, tutaina ꞌoina ꞌilotaigala luwa. ");
INSERT INTO bdd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Coinega Yesu ꞌenana madounega ꞌibwauwa, ꞌigwaeya, “Tamagu yo, yaluyaluwagu nimauwa yalagulagu.” Cina gwae bewa ꞌigwaeneya ma yawasina ꞌigumwala. ");
INSERT INTO bdd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nage ꞌoina toloꞌalehao ꞌadi tohanugeta ꞌiꞌiteya Yesu yawasina ꞌigumwala, ꞌoinega Yehoba ꞌihepwatuweya ꞌigwaeya, “Moisa, loheya bewa loheya bwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma wete toꞌebubuna mabwaiyadi tupwaina ꞌoina siꞌetoꞌautama Yesuina ꞌina ꞌamasa siꞌiteya, ta maꞌidi nuwagala sihila ꞌidi ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma Yesu ꞌiyanao ta wete wahiwahineyedi mwalo Galiliyega simuliyeyama, taudi bwaga sitotoholo ma Yesu ꞌina ꞌamasa siꞌeꞌebubu. ");
INSERT INTO bdd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Caigeda loheya sanina Yosepa, Yudiya loheyaina ꞌina ꞌasa ꞌiꞌiuna Alimatiya, tauna loheya bwebweꞌana ta maꞌana hemisa. Loheyaina meYudiya ꞌidi tohanugeta ꞌaigeda, ta ꞌiyamwayamwa ma to tuta Yehoba ꞌihetoloina meYudiya ꞌoidiya. Mwalo tutaina tohanugetao nuwanuwadi ma Yesu siloheꞌamasi, ma Yosepaina geya nuwana. ");
INSERT INTO bdd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Loheyaina Pailato ꞌoina ꞌitauya, ta Yesu wahina ꞌiꞌahwanoiyeya ma ꞌabehega ꞌigalihe. ");
INSERT INTO bdd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Coinega Pailato ꞌitagwala, ta Yosepa maꞌiyanao Yesu wahina kelose ꞌoinega siꞌewa suluheyama, ta siwaduhiya ꞌaleꞌo waꞌewaꞌeꞌena ꞌoinega, ma muliyetega sigaliheya. Gogoina siyalaiya gide tuwa duluha dimwa ꞌalona, ma geya ꞌaigeda tuta toꞌamasa wahina ꞌoina silagu. ");
INSERT INTO bdd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabwelo nage ꞌoina meYudiya ꞌidi tuta ꞌatububuna ꞌidi Sabati weyahina. ");
INSERT INTO bdd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ma wahiwahineyedi mwalo Galiliyega Yesu simuliyeyama taudi sitauya Yesu ꞌana galiha siꞌiteya, ma wete wahina ꞌana ꞌebelagu siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Coinega sihila ꞌasai ta holowa ꞌausalana siꞌatububuya Yesu wahina ꞌana holowa weyahina, ta sabweloina mulina siꞌaiyawasiya, weyahina Sabati gide ꞌana loina. ");
INSERT INTO bdd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Coinega wete gona ꞌiꞌadaleya, beno wiki ꞌana sabwelo nugenugetana gonagona, ma wahiwahineyedi holowa siꞌatububuya siꞌeweya, ma sitauyeyama gogowa. ");
INSERT INTO bdd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sitauyama ma gogo siꞌiteya ꞌana ꞌahuboda dimwa sibui hile pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Coinega galihina ꞌalona siluhuwa, ma Yesu wahina geya siꞌitatoho. ");
INSERT INTO bdd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Coinega gogoina ꞌoina maꞌidi henuwanaluwa simiyamiya ma siꞌeꞌebubuna, ma tuta ꞌiꞌiuna ꞌoina loheya ꞌeluwa, ma ꞌadi ꞌwama waꞌewaꞌeꞌena ta ꞌasiꞌasilalana silatuwa, ta deidiya sitoholowa. ");
INSERT INTO bdd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wahiwahine loheyaedi siꞌitediya ta simatauta, ꞌoinega sibeꞌu talutalubuꞌiya baleꞌuwa, ma loheloheyaedi wahiwahine ꞌoidiya sigwaeya, “Toꞌaha weyahina toꞌamasa ꞌidi tupwa ma loheya mayawasina waꞌebeꞌebese? ");
INSERT INTO bdd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tauna geya ꞌebwa, ta ꞌina gwaeina ꞌoimiya wanuwatuhuyahi mwalo Galili ꞌoina baꞌidamiu wamiyamiya, tutaina ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Taugu Loheyaiguina nata siheꞌebwayaegau togala ꞌoidiya, kelose ꞌoina situtu hepaꞌiyegau, ma sabwelo hetoina ꞌoina ꞌamasega nata yatoholo hila’.” ");
INSERT INTO bdd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wahiwahineyedi gwae bewa sinuwatuhu yahiya, ");
INSERT INTO bdd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ꞌoinega galihina siꞌebesineya sitauya Yesu ꞌina topaihowao site lebeni ma ꞌiyadiyao ꞌoidiya, ta sihepwaila toꞌaha gide gogowa ꞌoidiya ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tohepwailaedi taudi Meli Magidala ta Yowana ta hali Meli, tauna Yemesa sinana, ma wete tupwadi wahiwahine baꞌidadiyao, Yesu ꞌina toholo hila weyahina ꞌina topaihowaowedi sihegwaediya, ");
INSERT INTO bdd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ma tomotaedi wahiwahine ꞌidi gwae geya sihemisae, ꞌidi nuwatuhu ꞌabehega tuwa silolotuyena. ");
INSERT INTO bdd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma hesi Pita ꞌitoholowa, ꞌipili gogoina ꞌoina, ꞌiꞌitaluhuwa ꞌaleꞌomo, ꞌoinega ꞌihila maꞌina nuwapwanopwano toꞌaha ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sabweloina ꞌoina Yesu ꞌana tomuliyao ꞌeluwa sitautauya ꞌaigeda ꞌasa ꞌoina sanina Emeusa. Casaina ꞌana dudula Yelusalema ꞌoinega gide ꞌeguma gonegonega tatoholo ma gonagonaina ꞌana gamwagamwana ꞌoina talatu. ");
INSERT INTO bdd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Siteluwaedi sitautauya ma sihehegwaegwae ginauledi Yesu ꞌoina silatuwa weyahidi, ");
INSERT INTO bdd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sitautauya sigwaegwae liya, ꞌoinega Yesu ꞌoidiya ꞌilatuwa ta baꞌidadiu sitautauya. ");
INSERT INTO bdd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yesuina siꞌita pwaiya, ma hesi gesowana siꞌinana. ");
INSERT INTO bdd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Coinega ꞌihegwaediya, ꞌigwaeya, “To nuwatuhu weyahina wahegwaegwae liya?” Ma taudi maꞌidi nuwagala sitoholo henonowa. ");
INSERT INTO bdd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma ꞌiyanaina sanina Kaliopasa ꞌigwae hila, ta Yesu ꞌoina ꞌigwaeya, “Ciya, ꞌowa ꞌuboimo Yelusalema ꞌoina geya ꞌusanapu toꞌaha ꞌilatuwa sabwelo ꞌetoi ꞌoidiya wa?” ");
INSERT INTO bdd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Coinega Yesu ꞌigwaeya, “Toꞌaha?” Ma taudi sigwaeya, “Nuwatuhuwedi Yesu gwama Nasaleta ꞌoina silatuwa. Loheyaina tauna palopita, ma wete Yehoba ma tomota matadiya ꞌina gwaeyao ta ꞌina paihowao waiwaidi. ");
INSERT INTO bdd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma ꞌima Topwaoli Madoudi ma ꞌima tohanugetao loheyaina siyatalaeya ꞌina ꞌamasa weyahina, ta muliyetega toloꞌalehao situtu hepaꞌiyeya kelose ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma ꞌahemiseya ꞌabehega ꞌida ꞌabihetemai tauma meIsileli. Siloheꞌamasiya ma sabwelo ꞌeluwa sigumwala, ma nige sabwelo hetoina. ");
INSERT INTO bdd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma tupwana wahiwahine ꞌoimega nuwama siꞌabiheꞌwaniya weyahina nige ꞌabwa kululu sitauya galiha, ");
INSERT INTO bdd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ta Yesuina wahina geya siꞌitatoho, ma sihilama, ta toꞌaha gide anelose ꞌidi heꞌita ꞌoidiya beno ꞌoima sihepwaila ꞌabehega ꞌitoholo hila pwaiya. ");
INSERT INTO bdd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wete gide tupwadi ꞌoimega sitauya galihina ꞌoina, ta silobeya gide wahiwahineyedi ꞌidi hepwaila, ta Yesuina geya siꞌitatoho.” ");
INSERT INTO bdd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Coinega Yesu ꞌoidiya ꞌigwaeya, “Nuwapotapotaimi, weyahina geya palopitao nugenugetadi ꞌidi gwaeyao wada hemisediya. ");
INSERT INTO bdd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Toꞌabihetenaina ꞌilobwaine bwaibwainiya ma muyamuyaedi ꞌida lobadi ma ꞌoinega muliyetega sanina ꞌihemadou.” ");
INSERT INTO bdd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Coinega ꞌihegaina ma ꞌoidiya ꞌilihasa toꞌaha gide Buki Heꞌasisi ꞌina hepwaila Toꞌabihetenaina weyahina. Mosese ta palopitao ꞌidi bukiyao ꞌoidiyega ꞌihegaina, ma Buki Heꞌasisi mabwaiyana ꞌilohegumwalidiya, ta ꞌoinega sanapu sida loba. ");
INSERT INTO bdd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma tupwaina ꞌoina sitautauya deina silatu pwaiya, ta Yesu ꞌihegwaediya, ꞌigwaeya, “Wamiyamiya ma yatautauya.” ");
INSERT INTO bdd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma taudi sigwaeya, “Geya! Sahena ꞌutautauya, ꞌebwa taꞌeno, weyahina ꞌiboi pwaiya.” Coinega ꞌitagwala, ma ꞌiluhuwa ꞌidi hada. ");
INSERT INTO bdd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cidi tuta ꞌai ꞌoina, Yesu beledi ꞌiꞌeweya, ta weyahina ꞌigwae helauwa, ma muliyetega ꞌiꞌabihisiya ta ꞌiꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nage ꞌoina nuwadi ꞌisabwalena ta Yesuina siꞌinaneya, ta ꞌoidiyega ꞌiꞌwaiha. ");
INSERT INTO bdd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ta siteluwaedi taudi ꞌoidiya sigwaegwae, sigwaeya, “Moisa tutenina ꞌedai tanaonaoma, ma ꞌilihalihasa Buki weyahina, ꞌada lotohona hagana gide tuwa ꞌaiwe ꞌateda ꞌisabesabelulu.” ");
INSERT INTO bdd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Coinega sitoholo mwayamwayauwa ma sitauya Yelusalema, ta nobwa ꞌiyadiyao site lebeni silobediya, ma tupwadi wete baꞌidadiyao simiya ꞌautama, ");
INSERT INTO bdd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ma bodaedi Yesu weyahina sigwaegwae, sigwaeya, “Saimoni ꞌida Badaina ꞌiꞌita pwaiya, ꞌamasega ꞌitoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ta siteluwaedi wete siheꞌoteꞌotetela toꞌaha gide ꞌedai ꞌilatuwa, ma wete ꞌina ꞌabihisi beledi ꞌoinega siꞌinaneya, siteteliya. ");
INSERT INTO bdd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cabwa ꞌiyadiyao ꞌoidiya siheꞌoteꞌotetela ma Yesuina ꞌilatuwa ta gamwagamwanidiya ꞌitoholowa, ꞌigwaeya, “Helau ꞌoimiya,” ");
INSERT INTO bdd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ta siꞌiteya ma simatauta, ꞌidi nuwatuhu ꞌaigeda yaluyaluwa galana. ");
INSERT INTO bdd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Coinega Yesu ꞌihegwaediya, ꞌigwaeya, “Sahena wamatamatauta! Sahena wete wahehenuwanaluwa. Taugu tuwa. ");
INSERT INTO bdd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ma hesi nimagu ta ꞌahegu waꞌitadi ma waꞌabitohogau, weyahina yaluyaluwa galana geya ꞌwapinamo, ta wete geya lulunamo.” ");
INSERT INTO bdd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Gide ꞌihegwaeya, ma wete nimana ta ꞌahena ꞌiheꞌitaediya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nage ꞌoina siyaliyaya, ma hesi tupwana maꞌidi henuwanaluwa weyahina geya sihemisa moisa. Ma ꞌihegwaediya, “Ceꞌahai hisa, waꞌebwaegau ma yaꞌai?” ");
INSERT INTO bdd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma silahana tupwana mwesomwesona siꞌebwaeya, ");
INSERT INTO bdd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma matadiya ꞌiꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma ꞌihegwaediya, ꞌigwaeya, “Gwaeyedi yatetela pwaidiya ꞌoimiya tutaina taugu baꞌidamiu, mabwaiyana weyahigu sileleya Mosese ꞌina Buki ꞌoina ta palopitao ꞌidi buki ꞌoidiya ma wete buki wali Same ꞌoidiya, ma ꞌoinega ꞌigu hepwailaina ꞌana sanapu moisa ꞌida latu.” ");
INSERT INTO bdd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nage ꞌoina nuwadi ꞌiꞌabihe ꞌasilalediya ta Buki Heꞌasisi sisanapuya. ");
INSERT INTO bdd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma ꞌoidiya ꞌigwaeya, “Bewa gide silele ꞌesediya ꞌigwae, ‘Toꞌabihetenaina muyamuya ta ꞌamasa ꞌida loba, ma sabwelo hetoina ꞌoina ꞌamasega ꞌida toholo hila, ");
INSERT INTO bdd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ma muliyetega saninega tetela bwebweꞌana, nuwabui ma galana ꞌana nuwasam weyahidi siguguyae.’ Cidi guguyaina ꞌida hegaina Yelusalema ꞌoinega, ma ꞌida sakowasi baleꞌu mabwaiyana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ginaula bewa ꞌomi tuwa ꞌadi tohepwailao. ");
INSERT INTO bdd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma hesi taugu nata Tamagu ꞌina gwae hemisaina, beno Yaluyaluwana yahesumaneyama ꞌoimiya ma ꞌiꞌabihe waiwaiyegomi, ꞌoinega Yelusalema ꞌoina wayamwayamwa weyahina.” ");
INSERT INTO bdd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Coinega ꞌina gwae ꞌilosalohiya, ma muliyetega ꞌitoediya ma sitauya Bedani ꞌoina, ta nobwa nimana ꞌiyasidiya ꞌoidiya, ma ꞌigwae helauwediya. ");
INSERT INTO bdd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cina gwae helauina ꞌoina, ꞌaena ꞌiꞌeweya ma ꞌihaneya galewa. ");
INSERT INTO bdd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Taudi ꞌina ꞌebehaneina ꞌoina maꞌidi heꞌasisi siꞌetuluha, ma muliyetega maꞌidi yaliyaya madouna sihila Yelusalema. ");
INSERT INTO bdd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sihila ma Hada Heꞌasisi ꞌalona tuta baibaiwana Yehoba sihehepwatuwe. ");
INSERT INTO bdd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tuta ꞌebe hegaina hauhau ꞌoina Gwae huhuna ꞌimiyamiya. Huhunaina tuwa Tauna Keliso. Tauna Yehoba baꞌidana, eeta tauna tuwa Yehobaina. ");
INSERT INTO bdd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Weyahina ꞌebe hegaina hauhau ꞌoina Gwae huhunaina Yehoba baꞌidana simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma Gwae huhunaina tauna ginaula mabwaiyana ꞌipaihowediya ma wete ginaula mabwaiyadi ꞌihemasalahediya Yehoba baꞌidana, ta geya ꞌeta wete tohemasalaha. ");
INSERT INTO bdd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gwae huhunaina mayawasina moisa, ꞌoinega ꞌasilala ꞌiꞌeweyama ta ꞌiꞌabi latuheyama tomiya baleꞌu mabwaiyada ꞌoida. ");
INSERT INTO bdd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma ꞌoinega ꞌasilalaina guguyou ꞌoina ꞌisae haneya ma guguyouina geya ꞌina waiwaimo. Casilalaina geya wete ꞌina ꞌebe lolagumo. ");
INSERT INTO bdd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Eeta Yehoba loheya ꞌaigeda ꞌihesumaneya, sanina Yoni, ");
INSERT INTO bdd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tauna tomota ꞌoidiya ꞌinaoma ma ꞌabehega ꞌasilalaina weyahina ꞌida hepwaile ma ꞌoinega ꞌabehega tomota baibaiwadi sihesagohe ma ꞌidi hemisa silagu ꞌasilalaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tauna Yoniina geya ꞌasilalaina, ma hesi ꞌasilalaina ꞌana toꞌetala hepwahepwaila. ");
INSERT INTO bdd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma ꞌasilalaina ꞌasilala moisa. Gogo gabulena mabwaiyada ꞌoida ꞌiheꞌasilala. ");
INSERT INTO bdd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tauna ꞌitauya pwaima gogo gabulena ꞌoina, ma gogo gabulena ꞌimiyamiya, ma tauna tuwa gogo gabulena ꞌana tohemasalaha, ma gogo gabulena ꞌana tomiyaedi geya sisanapu to loheya. ");
INSERT INTO bdd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ma saugaina wete ꞌiboi ꞌinaoma ꞌina bodao ꞌoidiya, ma wete taudi silogwahateya. ");
INSERT INTO bdd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma hesi boda tupwadimo ꞌina gwae sihesagoheya ta sihemisaeya ꞌabehega tauna tuwa Toꞌabihetenaina. Coinega bodaedi ꞌoidiya ꞌitagwala ꞌabehega Yehoba natunao. ");
INSERT INTO bdd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bodaedi taudi tagwae siliꞌuhila. Ma liꞌuhilaina geya ꞌabehega loheloheya bweyahidi nuwana ꞌidi nuwatuhu ꞌoinega. Ma hesi liꞌuhilaina Yehoba ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma Gwae huhuna ꞌiheloheya, ma bewa tuwa mahetedai tamiyamiya. Ma ꞌina wasawasa madou hedadena ꞌiꞌabi hemaedaneya ꞌoima ta ꞌaꞌiteya, ꞌoinega ꞌasanapuya ꞌabehega tauna tuwa Yehoba natuna moisa, ma wete tauna tohelau moisa, wete mumugana mabwaiyana bwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mwalo Yoni Yesu ꞌihepwaileya ꞌenana madouna ꞌoinega ꞌigwae, “Loheyainaina bewa tauna weyahina yahehewasa, tutaina yagwaeya, ‘Loheya ꞌaigeda muliguwega ꞌitautauyama, sanina madou hedadena ꞌabwa taugu. Weyahina taugu ꞌabwa geya yaliꞌu ma tauna ꞌimiyamiya.’ ");
INSERT INTO bdd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","“Tauna tohelau ma toꞌebwaya moisa, weyahina ꞌina helauina ꞌoinega mabwaiyada ꞌilohemahegita. ");
INSERT INTO bdd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yehoba ꞌina loina Mosese ꞌoinega silatuwa. Ma hesi helau moisa ma mumuga bwebweꞌadi Yesu Keliso ꞌoinega silatuma. ");
INSERT INTO bdd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yehoba ꞌana ꞌita geya ꞌeta taiya ꞌida ꞌiteya, ma hesi natuna moisa ꞌiboi ꞌisanasanapu Tamana ꞌana ꞌita. Weyahina tauna Tamana deina ꞌimiyamiya, ꞌoinega tauna Tamana ꞌana ꞌita ꞌiheꞌitegita.” ");
INSERT INTO bdd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tuta beno ꞌoidiya, meYudiya ꞌidi tohanugetao topwaoli tupwadi ma Libai tupwana ꞌina bodao ꞌoidiyega sihesumanedima Yelusalema ꞌoinega Yoni sabi hesilalaina ꞌabehega tauna to loheya. ");
INSERT INTO bdd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Beno ꞌoina Yoni geya ꞌilowahiꞌwata ꞌidi hesilalaina ꞌoina weyahina, ma hesi ꞌidi hesilalaina ꞌana maisa bwebweꞌana ma maemaedanina ꞌiꞌebwaediya ꞌigwae, “Taugu geya Toꞌabihetenaina.” ");
INSERT INTO bdd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Coinega taudi wete sihesilala hileya sigwae, “Hede taiya ꞌowa? Bo ꞌabehega ꞌowa Ilaitiya?” Ma Yoni ꞌigwaeya, “Taugu geya Ilaitiya.” Ma taudi wete sihesilala hileya sigwae, “Bo nuwana ꞌowa ꞌaigeda wete palopita, palopitainaina tauna ꞌayamwayamwa?” Ma Yoni ꞌihegwae hilediya ꞌigwae, “Geya.” ");
INSERT INTO bdd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Coinega tohesilalaedi wete sigwae hila, sigwae, “Cowa hede to loheya? Mane hana ꞌuda hegwaemai ma ꞌaneyage ꞌalohihila ma ꞌima tohanugetao ꞌahegwae bwaibwainidi toꞌaha gide ꞌino hegwaegwae weyahiu.” ");
INSERT INTO bdd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma Yoni ꞌigwaeya, “Mwalona palopita Aiseya weyahigu ꞌihepwaila pwaiya ꞌigwae, ‘Cabwa nata tobwau ꞌaigeda yoho ꞌawawa ꞌilatu ma ꞌibwaubwau ꞌigwae, “Cinapwana ꞌina ꞌeda wahunae ma waꞌabi heduhedumwalu.”’” ");
INSERT INTO bdd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Coinega tohalewasaedi taudi Palisiyedi sihewasaedima sihesilaleya sigwae, “Ceguma ꞌowa geya Toꞌabihetenaina, bo ꞌowa geya Ilaitiya, bo ꞌowa geya palopitaina tauna weyahina ꞌayamwayamwana, hede toꞌaha weyahina ꞌuꞌabiꞌabi hebabitaiso?” ");
INSERT INTO bdd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma Yoni ꞌidi hesilalaina ꞌihemaiseya ꞌigwae, “Taugu tuwa tomota weꞌahega yaꞌabiꞌabi hebabitaisodi. Ma loheyaina geya wasanapu bewa tuwa gamwagamwanimiya ꞌitotoholo. ");
INSERT INTO bdd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tauna tuwa muliguwega ꞌitautauyama, sanina madou hedadena ꞌabwa taugu. Geya sawasawahigu ma ꞌana butu ꞌahenega yalihasi yahule, weyahina tauna loheya madou hedadena.” ");
INSERT INTO bdd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ginaula mabwaiyana bewa Bedani ꞌoina silatuwa, beno Yoni ꞌina ꞌebe hebabitaiso ꞌoina, Yolidani hali tupwega. ");
INSERT INTO bdd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ciꞌadaleya, Yoni Yesu ꞌiꞌiteya ꞌitautauyama ꞌoina. Ma Yoni boda ꞌihegwaediya ꞌigwae, “Loheya nage ꞌitautauyama Yehoba ꞌina lami, tauna ꞌabwa mebaleꞌu weyahida ꞌiꞌamasa, ma ꞌida puiyao ꞌiꞌewa yahuledi. ");
INSERT INTO bdd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Loheyainaina mwalona weyahina yahepwaila nugeta, tutaina yagwaeya ꞌabehega loheya ꞌaigeda muliguwega ꞌitautauyama, tauna sanina madou hedadena ꞌabwa taugu. Weyahina tauna tonugeta, ꞌabwa muliyetega yalatuma. ");
INSERT INTO bdd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Loheyainaina taugu geya yasanapu toho. Beno yasanapuya ꞌabehega taugu meIsileli ꞌoimiya yatauyama ma weꞌaha ꞌoinega yaꞌabiꞌabi hebabitaisogemi. Muliyetega ꞌabwa ꞌigu paihowa ꞌoinega loheyainaina ꞌomi wasanapu.” ");
INSERT INTO bdd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yoni ꞌihepwaila latuwa ꞌigwae, “Yehoba Yaluyaluwana yaꞌiteya ꞌana ꞌita gidemusa gabubu galewega ꞌisuluma Yesu ꞌoina ꞌitowa. ");
INSERT INTO bdd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mwalo loheyainaina geya yasanapu toho. Ma hesi Yehoba tauna ꞌihesumanegauma babitaiso weꞌahega yapaipaihowadi, ꞌihegwaegauwa ꞌigwae, ‘Cabwa nata Yaluyaluwagu ꞌuꞌita ꞌisuluma ma loheyaina ꞌoina ꞌitowa, beno tauna ꞌabwa Yaluyaluwagu ꞌoinega boda ꞌiꞌabi hebabitaisodi.’” ");
INSERT INTO bdd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Coinega Yoni boda ꞌihegwaediya ꞌigwae, “Loheyainaina moisa mataguwega yaꞌiteya, ma bewa tuwa weyahina ꞌoimiya yahehewasa tauna moisa Yehoba natuna.” ");
INSERT INTO bdd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ciꞌadaleya hali sabwelo ꞌoina, Yoni maꞌana tomuliyao siteluwa mahetenao sitotoholo, ");
INSERT INTO bdd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ma Yesu siꞌiteya deidiyega ꞌitautauya. Coinega Yoni ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Loheyaina nage Yehoba ꞌina lami.” ");
INSERT INTO bdd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eema siteluwaedi Yoni ꞌina gwae sihesagoheya, ꞌoinega Yesu simuliyeya. ");
INSERT INTO bdd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Simulimuliyeya, sitautauya ma Yesuina ꞌiꞌita lohihila, ta ꞌiꞌitediya mulinega sitautauyama. Coinega ꞌihesilalediya ꞌigwae, “Toꞌaha nuwanuwami?” Ma taudi sigwae, “Toheꞌita, taꞌehina ꞌumiyamiya?” ");
INSERT INTO bdd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Coinega Yesu ꞌihegwaediya, ꞌigwae, “Tanaowa ma ꞌigu ꞌebe miya yaheꞌitegomi.” Sitautauya ma Yesu ꞌina ꞌebe miyaina siꞌiteya, beno lahilahi, ꞌoinega nobwa mahetenao simiya heboiya. ");
INSERT INTO bdd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tomuliyaedi siteluwa ꞌoidiyega ꞌaigeda sanina Andulu, Saimoni Pita tasina. ");
INSERT INTO bdd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anduluina tasinaina Saimoni ꞌinuwatuhuya, ꞌoinega ꞌitauya tasinaina ꞌibesa mwayamwayauweya, ma ꞌilobeya, ma ꞌihegwaeya ꞌigwae, “Mesaiyaina ꞌalobeya.” (Mesaiya* ꞌana bui Keliso, beno ꞌena Gilisi. Ma ꞌana sanapu Toꞌabihetena.) ");
INSERT INTO bdd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eeta Anduluina tasina Saimoni ꞌitoeya ma mahetena sitauya Yesu ꞌoina. Ma Yesu Saimoniina ꞌiꞌebubuya, ꞌihegwaeya, ꞌigwae, “Cowa saniu Saimoni, tamau Yoni. Bewa tuwa saniu hauhauna yabwauwe Pita.” (Pita ꞌana bui beno daꞌule.) ");
INSERT INTO bdd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gona ꞌiꞌadaleya, Yesu nuwanuwana ꞌitauya Galili. Citauya ma Galili ꞌoina Pilipi ꞌilobeya, ꞌibwauweya ꞌigwae, “Pilipi, ꞌunaoma ꞌumuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi ꞌina ꞌasa sanina Bedeseida, beno Andulu ma Pita ꞌidi ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Muliyetega Pilipi Nataniyela ꞌilobeya, ma ꞌihegwaeya ꞌigwae, “Nataniyela, loheyaina sigwaegwaeneya ꞌalobeya. Tauna mwalona Mosese ꞌina buki ꞌoina weyahina ꞌihehegwaegwae. Palopitao ꞌidi lele ꞌoidiya wete weyahina sihegwaegwaeneya. Tauna tuwa Yesu, tamana Yosepa, Nasaleta loheyaina.” ");
INSERT INTO bdd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma Nataniyela Pilipi ꞌihegwaeya ꞌigwae, “Geya ꞌeta toꞌaha bwebweꞌana Nasaleta ꞌoinega ꞌida latuwa.” Ma hesi Pilipi ꞌigwaeya, “Tuwa hana ꞌunaoma, tatauya ma loheyaina ꞌuꞌita.” Coinega siteluwaedi sitauya Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sitautauya, ma Yesu Nataniyela ꞌiꞌiteya, ma Nataniyelaina weyahina ꞌihegwaegwaeya ꞌigwae, “Loheya nage gwama Isileli moisa, ma mumugana ꞌausalana mabwaiyana.” ");
INSERT INTO bdd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyela Yesu ꞌihesilaleya ꞌigwae, “Togidega ta ꞌusanapugauwa?” Ma Yesu ꞌigwae, “Nige heneyage yaꞌita nugetegowa ꞌabwa muliyetega Pilipi ꞌibwauwegowa, tutaina ꞌowa damaya huhuna ꞌumiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Coinega Nataniyela Yesu ꞌihegwaeya ꞌigwae, “Cinapwana, ꞌowa moisa Yehoba natuna. Ma wete ꞌowa meIsileli ꞌima kini.” ");
INSERT INTO bdd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Coinega Yesu ꞌihegwaeya ꞌigwae, “Nataniyela, ꞌabwa hesi ꞌuhemisaegauwa weyahina yahegwaegowa ꞌabehega damaya ꞌoina ꞌumiyamiya ma yaꞌitegowa, ꞌawa? Ma hesi ꞌuda sanapu ꞌabehega bewa tuwa ꞌebeꞌita ꞌiꞌiuna ꞌoiuwa. Ma ꞌabwa nata tuta sinaonaoma ꞌoidiya ꞌabwa ginaula madoudi ꞌuꞌitadi.” ");
INSERT INTO bdd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma Yesu wete ꞌihegwaediya ꞌigwae, “Yagwae moisa ꞌoimiya, ꞌabwa nata galewa huwehuweina ꞌuꞌita, ma wete Yehoba ꞌina aneloseyao ꞌuꞌitadi sihanehane ma sisulusuluma taugu Loheyaiguina ꞌoiguwa.” ");
INSERT INTO bdd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sabwelo ꞌeluwa sigumwala ma hehai sipaihowa ꞌasa sanina Kena ꞌoina, beno Galili ꞌina tupwa ꞌoina. Hehaiina solana Yesu sinana ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta Yesu wete maꞌana tomuliyao hehaiina ꞌoina sibwauwediya ma siluhuwa ꞌeꞌahaiina siꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cidi ꞌaiina solana ꞌadi waini mabwaiyana ꞌigumwala, ꞌoinega Yesu sinana ꞌihegwaeya ꞌigwae, “Natugu, waini mabwaiyana ꞌigumwala pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Coinega Yesu sinana ꞌenana ꞌihemaiseya, ꞌigwae, “Cowa sahena ꞌuloiloinegau, weyahina geya ꞌigu paihowa yahegaine.” ");
INSERT INTO bdd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma ꞌiyamo Yesuina sinana topaihowao ꞌihegwaediya ꞌigwae, “Yesu ꞌenana wahesagohe, ꞌeguma toꞌaha nuwanuwana tuwa wada paihowa.” ");
INSERT INTO bdd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tupwaina ꞌoina weꞌaha ꞌadi weꞌaha patu ꞌadi baibaiwa sikisi sitotoholo, daꞌule ꞌoidiyega sipaihowediya. Taudi sowasowahidi ma weꞌaha madouna ꞌoidiyega silohemahadi, meYudiya mumugadiyega ꞌidi ꞌebe deudeula weyahidi. ");
INSERT INTO bdd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Coinega Yesu topaihowaedi ꞌihegwaediya ma weꞌaha patuwedi gaugaulidimo weꞌahega silohemahediya ta mabwaiyadi simaha. ");
INSERT INTO bdd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma wete ꞌihegwaediya ma weꞌaha patuwedi ꞌoidiyega weꞌaha tupwadi sigoidiya ma sitauyediya haiina toni wagana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Coinega hehaiina toni wagana weꞌahedi ꞌinuma tohodiya, ta ꞌadi ꞌamna bwebweꞌana. Weyahina weꞌahedi ꞌihemala waini pwaiya, tuwa waini moisa. Beno ꞌoina hehaiina toni waganaina geya ꞌisanapu taꞌehega waini bewa siꞌeweya, benomo topaihowaedi sisanapuya. Eema hehaiina toni wagana tohai loheyana ꞌihegwae gahuweya ");
INSERT INTO bdd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ꞌigwae, “Togidega ta waini bewa bwebweꞌana neꞌabwega tuwa ꞌabwa ꞌulagu latuheyama? Ma hesi ꞌuda sanapu ꞌabehega tauda mumugada beno waini bwebweꞌana taꞌebwae nugetedi tomota ꞌoidiya ꞌabwa muliyetega waini galana.” ");
INSERT INTO bdd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Beno Yesu ꞌina ꞌilaꞌilala waiwaina ꞌihegaine nugeteya ꞌasa Kena ꞌoina, beno Galili tupwaina, ma ꞌiheꞌitaeya tomota ꞌoidiya, ma wetenuge ꞌina waiwai siꞌiteya, ꞌoinega ꞌana tomuliyao sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hehaiina ꞌigumwala, ma Yesu sinana ma tasinao ma wete ꞌana tomuliyao mahetenao sisuluwa Kapaneumi ꞌoina. Beno ꞌoina simiyamiya tupwana sabwelo ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","MeYudiya ꞌidi Hataona Guyaina ꞌana tuta ꞌiꞌehohoya, ma Yesu ꞌihaneya Yelusalema, ");
INSERT INTO bdd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yehoba ꞌina Hada Heꞌasisi* ꞌoina ꞌiluhuwa ma tohegimwane ꞌiꞌitediya sihehegimwane. Tohegimwaneyedi beno bulumakau ma sipi ma wete gabubu sihehegimwaneyedi hadainaina ꞌoina. Mane ꞌadi toheꞌebwaya hila wete ꞌiꞌitediya ꞌidi ꞌebelagu hatahatala deina simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Coinega Yesu balae ꞌiꞌeweya ma ꞌoinega tohegimwaneyedi ma ꞌidi hebahebaiyao Yehoba ꞌina hada ꞌoinega ꞌipaꞌidiya. Mane ꞌadi toheꞌebwaya hilao ꞌidi ꞌebe lagu hatahatala wete ꞌiꞌahu peinediya ma ꞌidi mane ꞌihabiya biyaunediya. ");
INSERT INTO bdd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma wete gabubu ꞌadi tohegimwane ꞌihegwaediya ꞌigwae, “Cimi bwasumowao waꞌahalidi ma hada bewa ꞌoinega walatu, sahena Tamagu ꞌina hada wahehemohomoho ma ꞌabehega ꞌimi ꞌebe gimwane.” ");
INSERT INTO bdd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cana tomuliyao siꞌeꞌebubu ma Yehoba ꞌina buki ꞌina hepwaila sinuwatuhu yahiya beno ꞌigwaeya, “Yehoba yo, ꞌino hada tobwebweꞌana ꞌiya, ma nuwagu ꞌiꞌeweya.” ");
INSERT INTO bdd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Muliyetega meYudiya ꞌidi tohanugetao sitauya Yesu sihesilaleya sigwae, “To ꞌilaꞌilala nata ꞌoinega ꞌuheꞌitemai ma ꞌoinega ꞌasanapu to loina ꞌoinega ginaula bewa ꞌupaipaihowadi?” ");
INSERT INTO bdd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Coinega Yesu ꞌenadi ꞌihemaiseya ꞌigwae, “Hada bewa ꞌeguma waligehi, nata sawasawahigu sabwelo ꞌetoi ꞌoidiya yahetoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma ꞌiyamo taudi sigwaeya, sigwae, “Hada bewa sabwelo ꞌetoi ꞌoidiya ꞌuhetoholo hila? Ma hesi ꞌuda sanapu ꞌabehega hada bewa bolime poti sikisi ꞌoidiya siꞌabiꞌabi.” ");
INSERT INTO bdd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma hesi Yesu geya hada moisana weyahina ꞌihehegwaegwae, ma ꞌiboi tuwa wahina weyahina ꞌihegwaegwaeya. ");
INSERT INTO bdd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Muliyetega Yesu ꞌamasa ꞌoinega ꞌitoholo hila ee ꞌabwa ꞌana tomuliyaedi ꞌina gwaeina ꞌoidiya sinuwatuhuya, ꞌoinega Yehoba ꞌina hepwailina bukiina ꞌoina ma wete Yesuina ꞌina gwaeyedi ꞌabwa hesi sihemisa bwaibwainidiya. ");
INSERT INTO bdd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tutaina ꞌoina Yesu Hataona Guyaina ꞌoina ꞌimiyamiya. Ma boda mabwaiyadi ꞌina paihowa waiwaina siꞌiteya, ꞌoinega sihemisaeya ꞌabehega tauna tuwa Toꞌabihetenaina. ");
INSERT INTO bdd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma hesiyage bodaedi Yesu geya ꞌihemisaedi. Weyahina ꞌidi nuwatuhu mabwaiyana ꞌisanapu nugetediya. ");
INSERT INTO bdd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Coinega geya ꞌeta taiya sawasawahina ma boda weyahidi ꞌihegwaegwae Yesu ꞌoina, weyahina Yesu boda mabwaiyadi ꞌidi nuwatuhu ꞌatediya simiyamiya ꞌisanasanapudi. ");
INSERT INTO bdd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Loheya ꞌaigeda sanina Nikodimo, tauna Palisi ꞌidi boda ꞌaigeda. Ma wete tauna meYudiya ꞌadi tohanugeta. ");
INSERT INTO bdd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Loheyainaina nihuwanega ꞌitauya Yesu ꞌoina ma ꞌihegwaeya ꞌigwae, “Cinapwana, ꞌasanapuya ꞌowa toheꞌitaina Yehoba ꞌoinega ꞌutauyama. Weyahina geya ꞌeta taiya ꞌina paihowa waiwaina ꞌowa gidemusa ꞌeguma Yehoba geya mahetena.” ");
INSERT INTO bdd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Coinega Yesu Nikodimo ꞌihegwaeya ꞌigwae, “Yagwae moisa ꞌoiuwa, ꞌeguma geyaꞌabwa ꞌuliꞌu hila, geyaꞌabwa wete Yehoba ꞌina ꞌebeloina ꞌuꞌitaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodimo Yesu ꞌihesilaleya ꞌigwae, “Togidega ma taugu loheya madougu ma ꞌabehega sinagu gamwanega yaliꞌu hila? Ma moisa tuwa, geya sawasawahigu ma sinagu gamwana yaluhu ma ꞌihenatune hilegau.” ");
INSERT INTO bdd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Coinega Yesu Nikodimo ꞌihegwaeya ꞌigwae, “Yagwae moisa ꞌoiuwa, ꞌeguma geyaꞌabwa weꞌaha ma Yehoba Yaluyaluwana ꞌoidiyega ꞌuliꞌuliꞌu hila, nata geyaꞌabwa wete Yehoba ꞌina ꞌebe loina ꞌoina ꞌuluhuluhu. ");
INSERT INTO bdd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tomota natudiyao siliꞌu tomota moisa. Ma Yehoba Yaluyaluwana ꞌoinega yaluyaluwamo ꞌihenatune. ");
INSERT INTO bdd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Coinega sahena nuwau ꞌihehenainaida weyahina yahegwaegowa ꞌabehega ꞌihenatune hilago. ");
INSERT INTO bdd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yaumai ꞌina towa wete gidemusa, ꞌeguma taꞌehega nuwanuwana ma ꞌoinega ꞌitowa, nata tuwa wete ꞌoinega ꞌitowama. Ta yaumai nata moisa ꞌenadi tahesagohedi, ma hesi geya tasanapu taꞌehega yaumai ꞌihahaꞌesama, nuwana toꞌeha ꞌitautauya. Ceda ꞌaigedanaina wete gidemusa ꞌeguma taiyawedi Yehoba Yaluyaluwana ꞌihenatunedi.” ");
INSERT INTO bdd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Coinega Nikodimo Yesu ꞌihesilala hileya ꞌigwae, “Toꞌaha ꞌino gwaeina ꞌana sanapu?” ");
INSERT INTO bdd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Yesu Nikodimo ꞌenana ꞌihemaiseya ꞌigwae, “Cowa ꞌaigeda meIsileli ꞌidi tohanugeta madouna. Ma toꞌaha weyahina ꞌigu gwae bewa ꞌoiuwa geya ꞌusanapu? ");
INSERT INTO bdd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ma yagwae moisa ꞌoiuwa ꞌabehega bewa tuwa ꞌahehegwae bwaibwainigomi toꞌaha gidemusa ꞌasanapudiya ma ꞌaꞌitediya. Ma hesi ꞌima gwaeyedi geya wada hesagohediya ma nuwana wada hemisaediya. ");
INSERT INTO bdd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ceguma baleꞌu weyahina ꞌahehepwaila ma geya wada hemisaediya, togidega nata galewa ꞌina ꞌebe loina wasanapu ꞌese tutaina ꞌeguma galewa weyahina ꞌahegwaegwae ꞌoimiya? ");
INSERT INTO bdd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Coimiyega geya ꞌeta taiya wete galewa ꞌoina ꞌihane tohona, yaboi Loheyaiguina sowasowagu, weyahina galewega yasulu nugetama. ");
INSERT INTO bdd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mwalona gidemusa tubudao ꞌoidiya yoho ꞌawawa sitautauya ma Mosese mwata pwawati ꞌoinega ꞌipaihoweya ma ꞌaiwe ꞌoinega ꞌiꞌabi haneheya ma ꞌoinega tubudaowedi lema silobeya. Coinega taugu ꞌabwa nata wete ꞌaiwe ꞌoina siꞌabi hanehegau, ");
INSERT INTO bdd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ma taiyawedi ꞌomi ꞌeguma wahemisaegauwa, nata yawasi miyamiya hatayana waloba. ");
INSERT INTO bdd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Comi tomiya baleꞌu Yehoba ꞌihelauwegomiya sinabwana, ꞌoinega taugu natunaina ꞌaigeda tuwa ꞌitagwalegauwa ꞌoimiya, ma ꞌoinega taiyawedi ꞌomi ꞌeguma wahemisaegau, geyaꞌabwa wahehesilae, ma hesi yawasimi miyamiya hatayana waloba. ");
INSERT INTO bdd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta Yehobaina natunaina taugu ꞌihesumanegauma baleꞌuwa geya ꞌabehega yaloinaegomi, ma hesi yatauyama ꞌimi pui ꞌoidiyega sabi lemegomi. ");
INSERT INTO bdd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Coinega taiyawedi ꞌomi ꞌeguma Yehoba natunaina taugu wahemisegau, nata geyaꞌabwa loina mwaudi walobalobadi. Ma hesi taiyawedi ꞌomi geya wahemisegau, ꞌomi loina mwauna ꞌoina waluhu pwaiya, weyahina taugu Yehobaina natunaina moisa geya wahemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Loinaedi mwaudiyedi huhuna bewa gidemusa: Maedanaina ꞌisulu pwaima baleꞌuwa, ma hesi tomiya baleꞌu nuwanuwadi guguyou. Coinega maedanaina silogwahateya, weyahina mumugadiyedi galadi. ");
INSERT INTO bdd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Coinega taiyawedi mumugadi galadi maedanaina geya nuwadi. Ma wete geya nuwadi ma maedanaina ꞌoina silatu, nata gidemusa mumugadiyedi galadi maedanaina ꞌiꞌabi latuhedi. ");
INSERT INTO bdd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma hesi taiyawedi mumugadi bwebweꞌadi, nata taudi maꞌidi yaliyaya maedanaina ꞌoina silatu ma maedanaina ꞌidi mumuga bwebweꞌadiyedi ꞌiꞌabi latuhedi ꞌabehega Yehoba ꞌoinega simumuga ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Muliyetega Yesu maꞌana tomuliyao sitauya Yudiya ꞌina tupwa ꞌoina. Tupwainaina ꞌoina sabwelo tupwadi ꞌoidiya simiyamiya ma Yesu tomota ꞌiꞌabiꞌabi hebabitaisodi. ");
INSERT INTO bdd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoni wete ꞌasa ꞌaigeda sanina Ainoni ꞌoina, beno ꞌasa Selimi deina, ꞌiꞌabiꞌabi hebabitaiso. Weyahina tupwainaina ꞌoina weꞌaha madouna ꞌimiyamiya, eeta weꞌahinaina ꞌoina boda sitautauyama, ma Yoni ꞌiꞌabiꞌabi hebabitaisodi. ");
INSERT INTO bdd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tutainaina ꞌoina Yoni ꞌabwa geya deliya silagu luhuwe. ");
INSERT INTO bdd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta Yoni ꞌana tomuliyao Yudiya loheyaina ꞌaigeda mahetediu siheꞌoheꞌohena babitaiso weyahina. Weyahina geya sisanapu taiya ꞌina babitaiso bwebweꞌana hedadena tauna sawasawahina ma tomota ꞌiꞌabi heꞌehaudi. ");
INSERT INTO bdd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Coinega toheꞌoheꞌoheyedi sitauya Yoni ꞌoina sigwae, “Cinapwana, mwalona loheyaina ꞌoima ꞌugwaegwaeneya tutaina ꞌowa ma tauma Yolidani weꞌahina hali tupwanega tamiyamiya. Tauna bewa tuwa loheyaina ꞌiꞌabiꞌabi hebabitaiso, ma boda mabwaiyadi ꞌina babitaiso nuwadi ꞌiꞌeweya, ꞌoinega siꞌauꞌauta ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma Yoni ꞌana tomuliyaedi ꞌenadi ꞌihemaiseya ꞌigwae, “Geya ꞌeta taiya sowasowahina ma ꞌiheloheya madou ꞌeguma Yehoba geya ꞌoina ꞌitagwala. ");
INSERT INTO bdd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Coimiya wete yagwae pwaiya ta wasanapuya ꞌabehega taugu geya Toꞌabihetenaina. Taugu tuwa Yehoba ꞌihesumanegauma yanugetama ta loheyainaina ꞌana muliya. ");
INSERT INTO bdd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Loheyainaina tauna gidemusa haihai meloheyana ma taugu tuwa ꞌana tohayahina. Tuwa gidemusa ꞌeguma haihai loheyana mwanena ꞌiloba ma ꞌoinega ꞌiyana ꞌaigeda haihai loheyainaina ꞌenana ꞌihesagohe ma weyahina ꞌiyaliyaya. Coinega taugu wete gide Yesu wasana yahesagoheya ma weyahina yayaliyaya sinabwana. ");
INSERT INTO bdd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tauna ꞌilobwaineya ma ꞌiheloheya madou, ma hesi taugu tuwa yamuliyeyamo. ");
INSERT INTO bdd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Loheyainaina tauna galewega ꞌisuluma, tomota mabwaiyadi ꞌimadou sinediya. Weyahina taiya ꞌeguma baleꞌuwega ꞌitauyama, tauna tuwa baleꞌu loheyaina, ma baleꞌu ginaulinao ꞌoidiyega ꞌihehegwaegwae. Ma hesi loheyainaina tauna galewega ꞌisuluma, tauna moisa tomota mabwaiyadi ꞌimadou sinediya. ");
INSERT INTO bdd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Toꞌaha gide ꞌinonodiya ta ꞌiꞌitediya weyahidi ꞌihehegwaegwae. Ma hesi ꞌina gwaeyedi geya ꞌeta taiya ꞌida ꞌabi yahidiya. ");
INSERT INTO bdd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma hesi taiyawedi ꞌeguma ꞌina gwaeyedi siꞌabiꞌabi yahidi, beno taudi sihepwaileya ꞌabehega Yehoba ꞌina gwae moisa. ");
INSERT INTO bdd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","“Loheyainaina Yehoba ꞌihesumaneyama tauna ꞌina gwae ꞌihehepwailedi, weyahina Yehoba Yaluyaluwana ꞌoinega ꞌilohemaheya. ");
INSERT INTO bdd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eeta Yehoba natunaina ꞌihelauweya, ꞌoinega ꞌina ꞌebeloina mabwaiyana natuna nimana ꞌilaguya. ");
INSERT INTO bdd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Coinega taiyawedi ꞌomi ꞌeguma Yehoba natunaina wahemisae, nata yawasi hataya waloba. Ma hesi taiyawedi ꞌomi ꞌeguma Yehoba natunaina geya wahemisae, nata geyaꞌabwa yawasi hataya walobaloba, ma hesi ꞌomi nata Yehoba ꞌina gamwasowala ꞌoimiya geyaꞌabwa ꞌigumwagumwala.” ");
INSERT INTO bdd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu ꞌina ꞌabi hebabitaiso ꞌoinega ꞌana tomuliyao baibaiwadi ꞌilobediya. Ma hesi Yoni ꞌana tomuliyao geya baibaiwadi. ");
INSERT INTO bdd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu moisa geya babitaiso ꞌida paihowediya, ꞌana tomuliyaedi siboi babitaiso sipaipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma Palisiyao ꞌenadi Yesu ꞌihesagoheya ꞌabehega ꞌina paihowa wasana sisanapuya, ꞌoinega Yudiya ꞌiꞌebe sineya ma ꞌilohihila Galili. ");
INSERT INTO bdd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Cina tauyaina ꞌoina nuwanuwana ma ꞌabehega Sameliya ꞌoinega ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Coinega ꞌitauya Sameliya ꞌana gamwagamwana ꞌoina ꞌilatuwa ma ꞌitautauya ta ꞌasa ꞌaigeda ꞌoina ꞌilatuwa, ꞌasainaina sanina Saika, ꞌoinega geya ꞌeda saliyana mwalona Yakobo baleꞌuina natuna Yosepa ꞌiꞌebwaeya. ");
INSERT INTO bdd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Casainaina ꞌoina weꞌaha ꞌeli ꞌaigeda ꞌimiyamiya, Yakobo mwalo ꞌana paipaihowa. Yesu tupwainaina ꞌoina ꞌilatuwa ꞌasudiladila gamwana. Wahina ꞌibeluwa, ma weꞌahina papalina ꞌimiyatoiya sabi ꞌaiyawasi. ");
INSERT INTO bdd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tuta ꞌiꞌiuna ꞌoina ma Sameliya wahineina ꞌaigeda ꞌilatuwa weꞌahinaina ꞌoina ꞌana weꞌaha sabi goi. Beno ꞌoina Yesu wahineina ꞌiꞌiteya ma ꞌoina ꞌiꞌahwanoiya ꞌigwae. “Wahine, weꞌaha ꞌuꞌebwaegau yanuma.” ");
INSERT INTO bdd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tuta beno ꞌoina Yesu ꞌiboinamo ꞌimiyamiya, weyahina ꞌana tomuliyaedi sitauya ꞌasa madouna ꞌoina ꞌadi sigimwagimwane. ");
INSERT INTO bdd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Coinega Sameliya wahineina Yesu ꞌihegwaeya, “Cuꞌita, ꞌowa Yudiya loheyaina ma taugu Sameliya wahineina. Ma toꞌaha weyahina weꞌaha weyahina ꞌoiguwa ꞌuꞌahwanoiyeya?” Weyahina meYudiya ma meSameliya geya siꞌahwa ꞌiyaꞌiyagu. ");
INSERT INTO bdd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Coinega Yesu Sameliya wahineina ꞌihegwaehileya, “Yehoba ꞌeguma ꞌina helau ꞌoiuwa ꞌusanasanapu, ma wete ꞌeguma ꞌusanapugauwa taiya taugu ꞌoiuwa weꞌaha weyahina yaꞌahwaꞌawanoi, ꞌowa hesi ꞌilobwainegowa ꞌoiguwa ꞌuda ꞌahwanoi ma weꞌaha yawasiu weyahina yaꞌebwaego.” ");
INSERT INTO bdd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma wahineina ꞌigwaeya “Cinapwana, ꞌowa geya ꞌino ꞌebe goimo. Weyahina weꞌaha gaula bewa ꞌisulu hedadeya ma ꞌugwaeya ꞌabehega weꞌaha ꞌuꞌebwaegau yawasigu weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Cowa nuwana ꞌutohotoho ma ꞌabehega tubudai Yakobo ꞌulagu suluhe? Ma hesiyage ꞌuda sanapu ꞌabehega ꞌama weꞌaha ꞌeli bewa, Yakobo mwalona heneyage ꞌipaihoweya ma weꞌahinaina bewa, manatunao ma wete ꞌidi hebahebaiyao ꞌidi ꞌebe numa.” ");
INSERT INTO bdd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Yesu wahineina ꞌihegwae hileya, “Taiya ꞌeguma weꞌaha bewa ꞌoinega ꞌinuma, nata wete taniꞌona ꞌiyahala hila. ");
INSERT INTO bdd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma hesi taiya ꞌeguma weꞌahina ꞌoiguwega yaꞌebwae ma ꞌinuma, nata geyaꞌabwa wete taniꞌona ꞌiyahayahala hila. Weyahina weꞌahina ꞌoiguwega yaꞌebwae, nata ꞌatena ꞌihebidala yawasina miyamiya hatayana weyahina.” ");
INSERT INTO bdd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Coinega wahineina ꞌigwaeya “Cinapwana, weꞌahinaina bewa tuwa ꞌuda ꞌebwaegau, ma ꞌaneyage geyaꞌabwa taniꞌogu ꞌiyahayahala hila bo nuwana geyaꞌabwa wete yahilahilama weꞌaha ꞌeli bewa ꞌoina ma yagoigoi hila.” ");
INSERT INTO bdd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Coinega Yesu wahineina ꞌihegwae hileya, “Cutauya mwaneu ꞌuꞌauliyama.” ");
INSERT INTO bdd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma wahineina Yesu ꞌihegwaeya ꞌigwae, “Ciya, taugu geya mwanegumo.” Coinega Yesu wahineina ꞌenana ꞌihemaiseya ꞌigwae, “Moisa beno ꞌugwaeya ꞌabehega geya mwaneumo. ");
INSERT INTO bdd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma hesi mwanemwao ꞌadi baibaiwa nima ꞌaiꞌaigeda taudi bewa tuwa geya mahetemwao. Ma hesi loheyaina tauna bewa tuwa maheteu wamiyamiya geya mwaneu moisana, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Coinega wahineina ꞌigwaeya, “Cinapwana, ꞌabwa hesi yasanapugowa ꞌowa ꞌabe ꞌaigeda palopita. ");
INSERT INTO bdd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bewa tuwa ꞌuhegwaegau to tupwa ꞌoina ꞌilobwaineya ma Yehoba ꞌoina tatapwalolo? Weyahina tauma mwalona tubumayao ꞌoidiyega ma bewa tuwa ꞌitautauya ꞌima ꞌoya bewa Sameliya ꞌoina ꞌatapwatapwalolo. Ma hesi ꞌomi meYudiya wagwaeya ꞌabehega Yelusalema ꞌebe tapwalolo moisa.” ");
INSERT INTO bdd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma Yesu wahineina ꞌihegwae hileya, “Wahine, bewa tuwa ꞌuhemisaegau. Weyahina ꞌabwa tuta sinaonaoma ꞌoidiya, tomota geyaꞌabwa ꞌoya bewa Sameliya ꞌoina bo Yelusalema ꞌoina sitapwatapwalolo. ");
INSERT INTO bdd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Comi meSameliya geya wasanapu taiya ꞌoina watapwatapwalolo. Ma hesiyage tauma meYudiya ꞌasanapuya taiya ꞌoina ꞌatapwatapwalolo, weyahina tauma ꞌoimega Yehoba ꞌina lemaina ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma sauga deina ma wete bewa ꞌilatu pwaima, ma taiyawedi taudi Tamada ꞌana totapwalolowao moisa, Tamadai ꞌoina sitapwalolo yaluyaluwadi mabwaiyana ꞌoidiyega ma wete nuwadi moisa ꞌoidiyega. Weyahina totapwalolowedi taudi bewa gide Yehoba nuwanuwana ma ꞌoina sitapwalolo. ");
INSERT INTO bdd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Weyahina Yehoba tauna tuwa yaluyaluwa, ꞌoinega taiyawedi ꞌeguma ꞌoina sitapwatapwalolo, ꞌilobwainediya ma yaluyaluwadi mabwaiyana ꞌoinega ma wete nuwadi moisa ꞌoidiyega ꞌoina sitapwalolo.” ");
INSERT INTO bdd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Coinega wahineina Yesu ꞌihegwaehileya, “Yasanapuya ꞌabehega ꞌabwa nata Toꞌabihetenaina ꞌitauyama, tauna sibwauweya Keliso. Tauna nata ꞌitauyama ꞌabwa ginaula mabwaiyana ꞌoida ꞌilihasidi.” ");
INSERT INTO bdd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Yesu ꞌihegwaeya, ꞌigwae, “Taugu bewa Toꞌabihetenaina ꞌoiuwa yahehegwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tutaina ꞌoina Yesu ꞌana tomuliyaedi silohihilama, ta ꞌidi Cinapwana siꞌiteya wahine mahetena sihehegwaegwae. Coinega taudi nuwadi ꞌihenainaida, ma hesiyage geya ꞌeta taiya Yesuina ꞌihesilala ma ꞌigwae, “Toꞌaha nuwanuwau?” Bo ꞌigwae, “Toꞌaha weyahina wahine maheteu wahehegwaegwae?” ");
INSERT INTO bdd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma hesi wahineina ꞌina ꞌebe goi ꞌiꞌebesineya ma ꞌitauya ꞌasai, tomota ꞌihegwaediya ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ciyagwao, wanaoma tatauya waꞌita loheyaina tauna mumugagu mabwaiyana ꞌoiguwa ꞌihepwailediya nuwana tauna Toꞌabihetenaina?” ");
INSERT INTO bdd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Coinega tomotaedi ꞌasa madounaina ꞌoinega silatuwa ma sitauya Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Beno ꞌoina tomuliyaedi Yesu sihegwaeya sigwae, “Cinapwana, mane musa ꞌeta toꞌaha ꞌuda ꞌaputoho?” ");
INSERT INTO bdd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma hesi ꞌihegwae hilediya, ꞌigwae, “Cagu ꞌeꞌahai ꞌimiyamiya, ꞌomi geya wasanapu.” ");
INSERT INTO bdd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ta tomuliyaedi nuwadi ꞌihenainaida, ma siboi ꞌoidiya sigwae, “Nuwana ꞌeta taiya ꞌana ꞌeꞌahai ꞌitauyeyama.” ");
INSERT INTO bdd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Muliyetega Yesu ꞌana tomuliyaedi ꞌihegwae hilediya, “Bewa tauna ꞌaguina: Tauna ꞌihesumanegauma ꞌina nuwatuhu yapaihowadi ma ꞌina paihowa mabwaiyana yalosalohidi.” ");
INSERT INTO bdd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Coinega wete ꞌihegwae hilediya ꞌigwae, “Tomadega ꞌimi nuwatuhu ꞌabehega waiꞌena ꞌehata sigumwala ꞌabwa mamasalai. Ma hesi yagwae moisa ꞌoimiya ꞌabehega mamasalai bewa tuwa ꞌilatu pwaiya. Nata hina waꞌita lohihila ma tanoha ꞌadi ꞌita waꞌitadi. ");
INSERT INTO bdd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma hesi taiyawedi ꞌeguma ꞌeꞌetahiina ꞌoina siꞌetahi, nata ꞌadi maisa siloba. Tanohinaina ꞌeꞌetahinaina yawasi miyamiya hatayana weyahina. Tanohinaina ꞌana todauna hagadi ma wete ꞌana toꞌetahi hagadi, ma hesi mabwaiyadi nata ꞌidi yaliyaya mahemahetena. ");
INSERT INTO bdd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ta moisa tuwa Yehoba ꞌina buki ꞌoina ꞌihepwaila bwaibwaina ꞌigwaeya ‘Loheya ꞌaigeda todauna ma ꞌaigeda toꞌetahi.’ ");
INSERT INTO bdd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Coinega bewa tuwa taugu yahehesumanegomi ma tanohinaina ꞌoina geya wadauna ꞌoinega waꞌetahi. Hali tomota mwalo sidauna, ma ꞌidi paihowega ꞌomi ꞌetahi nata wapaihowa.” ");
INSERT INTO bdd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Casa nage ꞌoina meSameliya baibaiwadi Yesu sihemisaeya, weyahina wahineina ꞌoidiya ꞌihepwaila ꞌigwae, “Cigu ꞌedaꞌeda mabwaiyana ꞌoiguwa ꞌihepwailediya.” ");
INSERT INTO bdd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Saugaina ꞌoina meSameliya sitauya Yesu ꞌoina ma sigwae, “Ceguma sowasowahina ꞌowa mahetemai tada miyamiya.” Coinega ꞌitagwala ma ꞌimiya hila gide sabwelo ꞌeluwa ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Coinega boda baibaiwadi wete sihemisaeya ꞌina gwae weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eeta wahineina sihegwaeya sigwae, “Moisa tuwa ꞌino gwaeina geya ꞌuꞌabo. Ta geya ꞌabehega ꞌino gwaemo ꞌoidiyega ma ꞌahemiseya, weyahina tauma ꞌaboi wete ꞌina gwae ꞌahesagohediya ma ꞌasanapuya ꞌabehega moisa tauna tuwa Tolemaina gogo gabulena mabwaiyada weyahida.” ");
INSERT INTO bdd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sabwelo ꞌeluwa sigumwala ma Yesu tupwaina ꞌiꞌebesineya ta Galili ꞌoina ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesuina ꞌiboinamo ꞌigwaeya, “Moisa, palopita geya ꞌadi heꞌasisimo ꞌeguma siboi ꞌidi ꞌasa ꞌoina siguguguya.” ");
INSERT INTO bdd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma hesi tutaina Yesu Galili ꞌoina ꞌilatuwa, meGalili siyaliyaya, weyahina bodaedi Yesu ꞌina paihowa waiwaina siꞌiteya tutaina mwalo sitauya Yelusalema Hataona Guyaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Muliyetega Yesu ꞌilohihila Kena ꞌoina, beno Galili ꞌina tupwa ꞌoina. Casainaina ꞌoina mwalona Yesu weꞌaha ꞌiꞌabi buiya ma ꞌihemala wainiya. Beno ꞌoina toloina ꞌaigeda madouna natuna ꞌilohala ma ꞌasa Kapaneumi ꞌoina ꞌiꞌenoꞌeno. ");
INSERT INTO bdd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Toloinaina Yesu wasana ꞌihesagoheya ꞌabehega Yudiya ꞌoinega ꞌitautauyama Galili. Coinega loheyainaina Yesu ꞌoina ꞌitauya ma ꞌiꞌahwanoiya ꞌigwae, “Ceguma sawasawahina ꞌowa mahetegu tatauya Kapaneumi ma natugu ꞌuꞌabi hebwebweꞌane. Weyahina gwamainaina ꞌiꞌiunamo ma yawasina ꞌigumwala.” ");
INSERT INTO bdd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Coinega Yesu toloinaina ꞌihegwae hileya, “Geya ꞌeta taiya ꞌida hemisaegauwa, beno tuwa ꞌeguma ꞌigu paihowa waiwaidi yaꞌabi latuhedi waꞌitadi ee ꞌabwa wahemisaegau.” ");
INSERT INTO bdd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma hesi toloinaina Yesu ꞌihegwaeya, “Cinapwana, ꞌulomwayamwayau ꞌunaoma tatauya, nata gide natugu yawasina ꞌigumwala.” ");
INSERT INTO bdd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Coinega Yesu ꞌigwae, “Natuina ꞌiꞌiuna ma ꞌibwebweꞌana, nata ꞌulohihila natuina ꞌuꞌita bwebweꞌana ꞌimiyamiya.” Eeta loheyaina Yesu ꞌina gwae ꞌihemisaeya ma ꞌilohihila natunaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Citautauya ta ꞌedai ꞌina topaihowao ꞌeluwa ꞌilobediya, ma wasa siꞌebwaeya sigwae, “Cinapwana, natuina ꞌibwebweꞌana pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Coinega ꞌihesilalediya ꞌigwae, “To sauga gide ꞌoina natugu ꞌiyawesaiya?” Ma taudi sigwae, “Boi ꞌasudiladila ꞌana gamwagamwana ꞌoina ma wahina mabwaiyana ꞌiyawesaiya.” ");
INSERT INTO bdd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nage ꞌoina gwamaina tamana Yesu ꞌina gwae ꞌinuwatuhuya tutaina ꞌoina ꞌigwae, “Natuina ꞌiꞌiunamo ma ꞌibwebweꞌana.” Beno ꞌoina loheyainaina maꞌina susuwao Yesu sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bewa Yesu ꞌina paihowa waiwaina heluwena ꞌiꞌabi latuheya, tutaina Yudiya ꞌoinega ꞌitauyama ma Galili ꞌoina ꞌipaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Muliyetega Yesu ꞌihaneya Yelusalema meYudiya ꞌidi guyai weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalema ꞌoina sipi ꞌidi ꞌahwaꞌeda deina, weꞌaha ꞌaigeda niꞌuna ꞌimiyamiya. Weꞌahinaina meYudiya ꞌenadiyega beno Bedeseida. Ma weꞌahinaina papalina hada ꞌebe ꞌaiyawasi maꞌana ꞌahwaꞌeda ꞌadi baibaiwa nima ꞌaiꞌaigeda simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hadaedi ꞌoidiya tololohala baibaiwadi siꞌenoꞌeno, taudi mata gibugibuidi ma peupeudi ma wete hemwalomwalo howaidi. ");
INSERT INTO bdd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO bdd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tolohalaedi ꞌoidiyega loheya ꞌaigeda ꞌana lohala ꞌoina ꞌimiyamiya gide bolime teti ꞌeiti (38) sigumwala. ");
INSERT INTO bdd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tutainaina Yesu ꞌitauyama loheyainaina ꞌiꞌiteya ta wete ꞌisanapuya ꞌabehega ꞌana lohalaina ꞌoina ꞌimiyamiya tuta saliya hedadena ꞌoidiya. Coinega Yesu loheyaina ꞌihegwaeya ꞌigwae, “Nuwanuwau ma ꞌubwebweꞌana?” ");
INSERT INTO bdd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Coinega loheyaina Yesu ꞌenana ꞌihemaiseya ꞌigwae, “Cinapwana, geya ꞌeta taiya weyahigu ma ꞌiꞌahala dobihegau weꞌaha bewa ꞌina tuta nihu ꞌoina. Tuta baibaiwana ꞌoidiya yatohotohona ma ꞌabehega yaboigumo yadobi weꞌahaina bewa ꞌoina, ma hesi geya sawasawahigu. Weyahina taugu ꞌabwa yaheheboi ma ꞌiyagwaowedi silomwayamwayau sidobi nugeta ma ꞌadi lohalaedi ꞌoidiyega sigumwagumwala, ma taugu ꞌagu ꞌitaina.” ");
INSERT INTO bdd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma Yesu loheyaina ꞌihegwaehileya, “Cutoholo ꞌino sita ꞌuꞌewadi ma ꞌutauya.” ");
INSERT INTO bdd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saugaina ꞌoina loheya ꞌibwebweꞌana ma ꞌina sita ꞌiꞌewediya ma ꞌitauya. Sabweloinaina ꞌoina Sabati, ");
INSERT INTO bdd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ꞌoinega meYudiya ꞌidi tohanugetao loheyaina siꞌiteya ma sihegwaeya sigwae, “Geya ꞌana ꞌita bwebweꞌana Sabati ꞌoina ꞌino sita ꞌuꞌaꞌahala dadanedi.” ");
INSERT INTO bdd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Loheyaina ꞌidi gwae ꞌihemaiseya ꞌigwae, “Loheyaina tauna ꞌiꞌabi hebwebweꞌanegauwa ꞌihegwaegauwa ꞌigwae, ‘Cino sita ꞌuꞌewadi ma ꞌutauya.’” ");
INSERT INTO bdd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Coinega sihesilala hileya sigwae, “To loheya beno gidemusa ꞌihegwae ꞌesegowa?” ");
INSERT INTO bdd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma hesi loheyaina ꞌana lohala ꞌigumwagumwala ꞌana toꞌabi hebwebweꞌanaina geya ꞌisanapu. Weyahina ꞌasainaina ꞌoina boda madouna simiyamiya ma Yesu soladiyega ꞌitauya pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muliyetega Yesu loheyaina ꞌilobeya Yehoba ꞌina hada solana, ma ꞌihegwaeya ꞌigwae, “Bewa tuwa ꞌubwebweꞌana pwaiya, ꞌoinega sahena wete ꞌupuipui hila, nata gide ginaula gala hedadedi ꞌoiuwa silatu.” ");
INSERT INTO bdd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Beno ꞌoina loheyaina ꞌitauya meYudiya ꞌidi tohanugetao ꞌoidiya ma ꞌana toꞌabi hebwebweꞌanaina ꞌihepwaileya ꞌabehega Yesu tauna ꞌana toꞌabi hebwebweꞌanaina. ");
INSERT INTO bdd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Beno huhuna ꞌoinega meYudiyaedi Yesu siheꞌaleheya, weyahina ginaula bewa Sabati ꞌoina ꞌipaihoweya. ");
INSERT INTO bdd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma hesi Yesu meYudiyaedi ꞌihegwaediya ꞌigwae, “Sabwelo mabwaiyana ꞌoidiya Tamagu ꞌipaipaihowa, ꞌoinega taugu wete gide yapaihowa ꞌesa.” ");
INSERT INTO bdd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","MeYudiyaedi Yesu ꞌina gwae sihesagoheya, ꞌoinega sitohotoho waiwai ma ꞌabehega togidega ma siloheꞌamasi. Weyahina Sabati ꞌana loina ꞌiligehiya, ma wete ꞌigwaeya ꞌabehega Yehoba Tamana moisa ta ꞌabehega Yehoba mahetena sihemahemahetena. ");
INSERT INTO bdd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Coinega Yesu tomotaedi ꞌihegwaediya ꞌigwae, “Yagwae moisa ꞌoimiya, taugu geya sowasowahigu ma yaboi ꞌigu nuwatuhu ꞌoinega yapaihowa. Ma hesiyage toꞌaha gide Tamagu yaꞌiteya ꞌipaipaihowadi, taugu wete gide yapaihowa ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ma Tamagu ꞌihelauwegauwa, ꞌoinega ꞌina paihowa mabwaiyana toꞌaha gide ꞌipaipaihowadi ꞌiheꞌitegauwa. Ma wete paihowa madoudi nata ꞌabwa ꞌiheꞌitegau ma yapaihowadi, ꞌoinega mabwaiyami nuwami sihenainaida. ");
INSERT INTO bdd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gide Tamagu toꞌamasa ꞌiꞌabiꞌabi hetoholo hiledi ma yawasidi ꞌiꞌebwaꞌebwaedi. Coinega taugu wete gide yawasi hauhauna tomota yaꞌebwaꞌebwaedi taiyawedi taudi yahesinuwedi. ");
INSERT INTO bdd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Ma wada sanapu ꞌabehega Tamagu geya ꞌeta wete ꞌina loina mwauna ꞌimiyamiya tomota ꞌadi heyatala weyahina, weyahina heyatala ꞌana loina mabwaiyana ꞌiꞌebwae pwaigauwa ma yaboi yapaihowadi, ");
INSERT INTO bdd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ma ꞌoinega mabwaiyami waheꞌasisiyanegau gide Tamagu waheheꞌasisiyana ꞌese. Ma ꞌeguma taiyawedi geya waheꞌasisiyanegau, beno wete Tamagu tauna ꞌihesumanegauma geya waheꞌasisiyane. ");
INSERT INTO bdd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Coinega yahegwae bwaibwainigomi ꞌeguma taiyawedi ꞌomi ꞌigu gwae wahesagohedi ma wete ꞌagu Tohesumaneina wahemisae, nata yawasi miyamiya hatayaina waloba. Ma ꞌoinega heyatala ꞌana tuta ꞌoina ꞌomi geyaꞌabwa loina walobaloba. Weyahina ꞌomi ꞌamasa ꞌina tupwa waꞌebesineya ma wahabala yawasi hauhauna ꞌina tupwa. ");
INSERT INTO bdd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ma wete yahegwae bwaibwainigomi ꞌabehega tuta bewa tuwa ꞌilatulatuma, bo tagwae tuta ꞌilatu pwaima ma toꞌamasa Yehoba natuna ꞌenana sihesagohe, beno taugu tuwa ꞌenagu. Ma ꞌeguma taiyawedi ꞌomi ꞌenagu wahesagohe, nata yawasi hauhauna waloba. ");
INSERT INTO bdd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“Tamagu tauna yawasi moisa huhuna, ꞌoinega ꞌoiguwa ꞌitagwala ma taugu wete yawasi huhuna, ");
INSERT INTO bdd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ma wete heyatalaina ꞌana loina ꞌiꞌebwaegauwa ma taugu heyatala yapaihowadi, taugu tuwa Loheyaiguina moisa. ");
INSERT INTO bdd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Coinega sahena nuwami sihehenainaida gwae bewa weyahina. Ma wete tuta ꞌinaonaoma ꞌoina toꞌamasa mabwaiyadi nata ꞌenagu sihesagohe ");
INSERT INTO bdd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma galihega silatuma. Ma ꞌeguma taiyawedi taudi mumugadi bwebweꞌadi, nata yawasi bwebweꞌana siloba. Ma taiyawedi taudi mumugadi geya bwebweꞌadi, loina mwauna siloba. ");
INSERT INTO bdd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Taugu wete geya sowasowahigu ma yaboigumo paihowaedi yapaihowadi, weyahina ꞌigu loina heyatala weyahina Yehoba tauna ꞌiheꞌitegauwa, ꞌoinega ꞌigu loina bwebweꞌana. Weyahina taugu geya yatohotoho ma ꞌabehega yaboi ꞌigu nuwatuhu yapaihowadi, ma hesi toꞌaha gide ꞌagu Tohesumaneina ꞌina nuwatuhu gide yapaihowa ꞌesedi. ");
INSERT INTO bdd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Eeta ꞌeguma yaboi weyahigu yahehepwaila, nata geyaꞌabwa waꞌahwaꞌahwa moisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma hesiyage wada sanapu ꞌabehega hali loheya weyahigu ꞌihepwaila pwaiya, ma yasanapuya toꞌaha gide ꞌina hepwaila weyahigu mabwaiyana gwae moisa. ");
INSERT INTO bdd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Loheyainaina mwalona tohalewasa tupwadi ꞌoina wahesumanediya, sanina Yoni. Ta gwae moisa ꞌiꞌebwaediya ta ꞌoimiya wete sihepwaila bwaibwaina.” ");
INSERT INTO bdd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Coinega Yesu wete ꞌihegwaediya ꞌigwae, “Taugu tomota ꞌidi hepwaila geya weyahina yada nuwatuhuwa. Ma hesi gwae bewa Yoni weyahina yahehepwaila ma ꞌoinega nuwami ꞌiꞌasilala ma ꞌabihetena waloba. ");
INSERT INTO bdd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni tauna gide mayale waiwaina, ꞌoinega ꞌomi nuwanuwami ma ꞌina ꞌasilalaina ꞌoina wayaliyaya tuta ꞌiꞌiunamo. ");
INSERT INTO bdd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma Yoni weyahigu ꞌihepwaila, beno geya ginaula madouna. Ma hesi ginaula ꞌaigeda madou hedadena ꞌimiyamiya, beno ꞌebeꞌitaedi Tamagu ꞌoinega bewa tuwa yapaipaihowadi. Coinega paihowaedi weyahidi wanuwatuhu bwaibwaina, ma ꞌoinega wasanapugau ꞌabehega Tamagu tauna ꞌihesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Tamagu tauna weyahigu ꞌihepwaila pwaiya ma hesi ꞌomi geya ꞌeta tuta ꞌenana wahesagoha toho, bo nuwana manina waꞌita tohoya, ");
INSERT INTO bdd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma wete ꞌina gwae ꞌoimiya geya ꞌatemiya walagudi, huhunaina geya wahemisaegau ꞌabehega taugu Yehoba ꞌoinega yatauyama. ");
INSERT INTO bdd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yehoba ꞌina buki wahasihasili. Ma wanuwatuhu ꞌabehega bukiina ꞌoinega yawasimi miyamiya hatayana wada loba. Ma hesi geya wasanapu ꞌabehega bukiina taugu tuwa weyahigu ꞌihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Beno ꞌoinega geya nuwami ma wanaoma ꞌoiguwa yawasimi miyamiya hatayana weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ma hesi wada sanapu ꞌabehega taugu geya tomota ꞌidi hepwatu weyahidi yada nuwatuhuwa. ");
INSERT INTO bdd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Comi weteyage yasanapu pwaigomiya, geya ꞌeta wete Yehoba ꞌana helau ꞌatemiya walagu tohodi. ");
INSERT INTO bdd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taugu Tamagu saninega yatauyama ma geya wahemisaegau. Ma hesi ꞌomi ꞌeguma hali loheya tauna saninega ꞌitauyawa ꞌoimiya, nata loheyainaina wahemisae. ");
INSERT INTO bdd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ta moisa tuwa, ꞌomi nuwanuwami ma ꞌami hepwatu waboi ꞌoimiyega wahesagohedi. Ma hesi geya watohona ma ꞌane Yehoba ꞌiboimo ꞌoinega ꞌami hepwatu walobadi. Beno ꞌoinega geya sowasowahimi ma wahemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Sahena wanuwanuwatuhu ꞌabehega taugu nata Tamagu ꞌoina yaheꞌewegami, loheya ꞌaigeda hesi tauna nata ꞌiheꞌewegami, tauna wanuwatuhuya ꞌabehega ꞌabwa nata ꞌilemegomi, sanina Mosese. ");
INSERT INTO bdd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma ꞌeguma moisa Mosese wahemisaeya, taugu wete gide wahemisaegau. Weyahina Mosese tauna mwalona Yehoba ꞌina buki ꞌoina weyahigu ꞌihepwaila pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma hesi ꞌina hepwailina geya wahemisae, ꞌoinega geya sowasowahimi ma ꞌigu gwae wahemisaedi.” ");
INSERT INTO bdd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Coinega Yesu ꞌilohihilama Galili ꞌina tupwa ma ꞌigeluwa ꞌihabala Galili holaina hali tupwanega. Holainaina sanina heluwena Taibiliya. ");
INSERT INTO bdd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Eeta boda madouna mulinega sitauya, weyahina ꞌina paihowa waiwaina tolohala ꞌoidiya siꞌita pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Coinega Yesu maꞌana tomuliyao sihaneya ꞌoyai simiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tutaina ꞌoina meYudiya ꞌidi Hataona Guyaina ꞌana tuta ꞌiꞌehohoya. ");
INSERT INTO bdd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ꞌiꞌita lohihila ma boda madouna ꞌiꞌitediya mulinega sitautauyama, ꞌoinega Yesu Pilipi ꞌihegwaeya ꞌigwae, “Taꞌehega nata ꞌeꞌahai tagimwanedi ma boda bewa taheꞌaidi?” ");
INSERT INTO bdd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hesilala bewa ꞌoinega Pilipi ꞌitohoya, ma hesi Yesu ꞌisanapu nugeteya toꞌaha nata ꞌipaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma Pilipi Yesu ꞌihegwaeya ꞌigwae, “Boda bewa madou hedadena, ma ꞌeguma tu handeledi kina ꞌoinega beledi tagimwanedi weyahidi, bwagana nata ꞌiꞌiuna ꞌiꞌiuna siꞌai, ma hesi nata geyaꞌabwa mabwaiyadi sowasowahidi.” ");
INSERT INTO bdd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Coinega Yesu ꞌana tomuliya ꞌaigeda wete Yesu ꞌihegwaeya ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gwama ꞌaigeda yalobeya ꞌana beledi nima ꞌaiꞌaigeda, ma wete ꞌana silahana ꞌeluwa. Ma boda mabwaiyadi geya sowasowahidi.” Tomuliyaina sanina Andulu, Saimoni Pita tasina. ");
INSERT INTO bdd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Muliyetega Yesu ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Tomota mabwaiyadi wahegwaedi ma modumoduwa simiya ꞌalatutu.” Weyahina ꞌasainaina ꞌoina modumodu ꞌana ꞌasa, ꞌoinega mabwaiyadi modumodu ꞌoina simiya toiya, loheloheyaedimo ꞌadi baibaiwa gide paibi tausani. ");
INSERT INTO bdd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Muliyetega Yesu beledi ꞌiꞌewediya ma weyahidi ꞌigwae helauwa Yehoba ꞌoina, ꞌabwa muliyetega tomotaedi simiyatoiya ꞌiheguyaiyediya ma silahanedi wete gide ꞌoidiya ꞌipaihowa ꞌesediya. Coinega mabwaiyadi siꞌaiya ta sowasowahidi, simwausuwa. ");
INSERT INTO bdd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Simwausuwa, ta Yesu ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Beledi ꞌana tupwa mabwaiyana wasiwa heꞌautedi, sahena ꞌeta toꞌehina wete wamudamudali.” ");
INSERT INTO bdd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Coinega belediyedi mugumugudi sisiwa heꞌautediya ma boha tuwelo ꞌadi baibaiwa silohemahediya. ");
INSERT INTO bdd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cigumwala ma bodaedi Yesu ꞌina paihowa waiwaina ꞌana ꞌilaꞌilala siꞌiteya ma sigwae, “Tauna tuwa bewa palopitainaina tauna ꞌabehega gogo gabulena ꞌoina ꞌitauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eeta Yesu tomotaedi ꞌisanapudiya ꞌabehega nata siꞌabiyahi ma ꞌoidiya ꞌihekini. Ma hesi Yesuina geya nuwana, ꞌoinega ꞌiboinamo ꞌilohihila ꞌoyai. ");
INSERT INTO bdd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Coinega lahilahiyega ꞌana tomuliyaedi sidobiya Galili holaina gadowaina ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ma ꞌidi waga ꞌoina sigeluwa ma sihahabala Kapaneumi, ma niꞌu ꞌawawa ꞌiguguyouwa. Eeta Yesu geya ꞌitauya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Coinega sihahabala ma niꞌuwa yaumai ma bagodu madouna silobeya. ");
INSERT INTO bdd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tutaina ꞌoina sihadobiya niꞌu gamwagamwana, ꞌabwa muliyetega Yesu siꞌiteya hola tabwanega ꞌitautauyama ꞌidi waga deina. Beno ꞌoina simatauta. ");
INSERT INTO bdd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma ꞌiyamo Yesu ꞌihegwaediya ꞌigwae. “Sahena wamatamatauta, taugu tuwa.” ");
INSERT INTO bdd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Coinega tomuliyaedi Yesu sidoꞌoya wagai, ma tutaina ꞌoina sisohota ꞌasaina silagalaga ꞌoina gadowaina. ");
INSERT INTO bdd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gona ꞌiꞌadaleya ma bodaedi taudi Galili holaina hali tupwanega simiyamiya, sisanapuya ꞌabehega boi Yesu maꞌana tomuliyao ꞌidi waga ꞌaigeda tuwa ꞌoinega sigeluwa. Ma hesi ꞌidi lohihila ꞌoina tomuliyaedi siboidimo sigeluwa wagai ta sitauya, ma Yesu geya mahetediu sigelu. ");
INSERT INTO bdd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma ꞌiyamo waga tupwadi Taibiliya ꞌoinega sitauyama gadowaina ꞌoina boi Yesu boda beledi ꞌoinega ꞌiheꞌaidiya, tutaina belediyedi ꞌiꞌahwa bwebweꞌanediya Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma bodaedi Yesu maꞌana tomuliyao sibesa ꞌasaediya, ꞌoinega wagaedi ꞌoidiya sigeluwa, ma sihabala Kapaneumi ꞌoina Yesu sibesebese. ");
INSERT INTO bdd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Muliyetega Galili holaina hali tupwega silobeya, ma sihegwaeya, sigwae, “Cinapwana, tolahisa ꞌuhabalama?” ");
INSERT INTO bdd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Coinega Yesu tomotaedi ꞌihegwaediya ꞌigwae, “Yagwae moisa ꞌoimiya, belediyedi ꞌoidiyega yaheꞌaigomiya ma wamwausuwa ꞌoinega bewa wabesebesegau, geya ꞌigu paihowa waiwaidi ꞌadi ꞌilaꞌilalaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Coinega bewa tuwa yahegwaegomi, sahena ꞌeꞌahai gumwagumwalidi weyahidi wapaipaihowa, ma hesi ꞌeꞌahai yawasimi miyamiya hatayana weyahidi wapaihowa. Ceꞌahainaina bewa weyahina yahehegwaegwae. Loheyaiguina taugu nata yaꞌebwaegomi. Weyahina Tamagu ꞌina paihowa bewa weyahina ꞌihesumanegauma ma yapaihowadi.” ");
INSERT INTO bdd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Coinega tomotaedi Yesu sihegwae hileya, “Toꞌaha nata ꞌoidiyega Yehoba ꞌina paihowa ꞌapaihowadi?” ");
INSERT INTO bdd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma Yesu ꞌihegwae hilediya, “Yehoba ꞌina paihowaina bewa gide taugu wahemisaegauwa, weyahina tauna ꞌihesumanegauma.” ");
INSERT INTO bdd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma wete sihegwae hileya, “To ꞌilaꞌilala nata ꞌoima ꞌupaihowa ma ꞌoinega ꞌahemisaego? ");
INSERT INTO bdd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mwalona gide tubumayao yoho ꞌawawa ꞌeꞌahainaina siꞌaiya sanina mana. Yehoba ꞌina buki ꞌoina wete gide ꞌihepwaila ꞌesa ꞌigwae, ‘Ceꞌahainaina galewega ꞌiꞌebwaediya ma siꞌaiya.’ Coinega ꞌowa mane wete ꞌino ꞌilaꞌilala ꞌupaihowa ma ꞌaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma Yesu tomotaedi ꞌihegwaediya ꞌigwae, “Yagwae moisa ꞌoimiya, Mosese ꞌeꞌahainaina beno geya galewega ꞌiꞌebwaegomi, ma hesi Tamagu tauna hene ꞌeꞌahai moisaina galewega ꞌiꞌebwaꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma ꞌeꞌahainaina Yehoba ꞌoinega tauna ꞌilatu pwaima baleꞌuwa ma tomota yawasidi ꞌiꞌebwaꞌebwaedi.” ");
INSERT INTO bdd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Coinega taudi wete Yesu sihegwaeya, sigwae, “Cinapwana, ꞌeꞌahainaina beno sauga mabwaiyana ꞌuꞌebwaꞌebwaemai.” ");
INSERT INTO bdd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma Yesu wete ꞌihegwaediya, “Taugu yawasimi ꞌana ꞌeꞌahai, ꞌoinega taiyawedi ꞌomi ꞌeguma watauyama ꞌoiguwa, geyaꞌabwa wagomagomale. Taiyawedi wete ꞌeguma ꞌomi wahemisaegau, nata geyaꞌabwa taniꞌomi siyahayahala. ");
INSERT INTO bdd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ma yahegwae pwaigomiya ꞌabehega waꞌita pwaigauwa, ma hesi geya wahemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tomotaedi taudi Tamagu ꞌiꞌebwaegauwa hesi nata ꞌoiguwa sitauyama, ma ꞌeguma sitauyama ꞌoiguwa, nata geyaꞌabwa yalolohesohesoiyedi. ");
INSERT INTO bdd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Weyahina taugu galewega yasuluma geya ꞌigu nuwatuhu sabi paihowaina, ma hesi tauna ꞌihesumanegauma ꞌina nuwatuhu sabi paihowaina. ");
INSERT INTO bdd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cihesumanegauma ma ꞌigu tomotaedi ꞌiꞌebwaegauwa ꞌina nuwatuhu bewa gide ma ꞌabehega geyaꞌabwa ꞌeta taiya ꞌoidiyega yaheꞌwadalele. Ma hesi mabwaiyadi ꞌamasa ꞌoinega yada ꞌabi hetoholo hiladi tuta ꞌana ꞌebe losaloha ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tamagu bewa gide wete ꞌina nuwatuhu ma ꞌabehega taiyawedi ꞌeguma taugu natunaina siꞌitegauwa ma sihemisaegauwa, nata yawasidi miyamiya hatayana siloba. Ma wete tuta ꞌana ꞌebe losaloha ꞌoina ꞌamasa ꞌoinega yaꞌabi hetoholo hiladi.” ");
INSERT INTO bdd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Beno ꞌoina meYudiya Yesu ꞌina gwae sihesagoheya ma silomugiyeya ꞌina gwaeina weyahina ꞌigwae, “Taugu bewa ꞌeꞌahainaina galewega yasuluma.” ");
INSERT INTO bdd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma siboidimo ꞌoidiya sigwae, “Loheya bewa Yosepa natuna, sanina Yesu, ꞌawa? Tamana ma sinana wete tasanapu pwaidiya, ma togidega ta ꞌigwaeya ꞌabehega tauna galewega ꞌisuluma?” ");
INSERT INTO bdd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Coinega Yesu ꞌihegwae hilediya, “Sahena waboi ꞌoimiya weyahigu walolomugi. ");
INSERT INTO bdd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Weyahina Tamagu ꞌihesumanegauma ma ꞌoinega taiyawedi ꞌomi ꞌilisigomi ma wanaoma ꞌoiguwa, ꞌomi nata tuta ꞌana ꞌebe losaloha ꞌoina ꞌamasa ꞌoinega yaꞌabihetoho hilegomi. Ma taiyawedi ꞌeguma geya ꞌilisidima taudi nata geyaꞌabwa ꞌoiguwa sinaonaoma. ");
INSERT INTO bdd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Gwae bewa mwalo heneyage Yehoba ꞌina buki ꞌoina palopitao sileleya sigwae, ‘Tomota mabwaiyadi nata ꞌadi heꞌita Yehoba ꞌoinega siloba.’ Ma ꞌoinega taiyawedi ꞌomi Tamadai ꞌina heꞌita wahesagoheya ma wasanapudiya, ꞌomi nata ꞌoiguwa watauyama. ");
INSERT INTO bdd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma geya ꞌeta taiya Tamadai ꞌiꞌita toho, beno tuwa yaboi, weyahina taugu ꞌoinega yasuluma. ");
INSERT INTO bdd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Coinega bewa yagwae moisa ꞌoimiya ꞌeguma taiyawedi ꞌomi wahemisaegau, nata yawasi miyamiya hatayana waloba. ");
INSERT INTO bdd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taugu tuwa yawasimi ꞌana ꞌeꞌahai. ");
INSERT INTO bdd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tubumiyaowedi mwalona yoho ꞌawawa ꞌoina ꞌeꞌahai sanina mana siꞌaiya, ma ꞌiyamo geya manaina ꞌoinega yawasidi miyamiya hatayana siloba, ma hesi ꞌoinega simiyamiya ꞌana siga siꞌamasaeya. ");
INSERT INTO bdd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Ma hesi ꞌeꞌahai hauhaunaina galewega ꞌisuluma taiyawedi ꞌomi ꞌeguma waꞌewa ma waꞌai, nata geyaꞌabwa waꞌamaꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Weyahina taugu yawasimi ꞌana ꞌeꞌahai galewega yasuluma, ma taiyawedi ꞌomi ꞌeguma ꞌeꞌahainaina ꞌoiguwega waꞌai, nata yawasimi miyamiya hatayana waloba. Ceꞌahainaina beno taugu hesiyogu yaꞌebwaegomi ma waꞌai, weyahina wahigu yatagwaleya mebaleꞌu mabwaiyami yawasimi weyahina.” ");
INSERT INTO bdd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Beno ꞌoina meYudiya siboidimo siheꞌoheꞌohena sigwae, “Togidega ma loheya bewa ꞌabehega hesiyona ꞌiꞌebwaegita ma taꞌai?” ");
INSERT INTO bdd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Coinega Yesu ꞌihegwae hilediya, “Yagwae moisa ꞌoimiya, taugu loheyaiguina moisa, ma ꞌeguma hesiyogu geyaꞌabwa waꞌaiꞌai ma wete ꞌeguma geyaꞌabwa bweyahigu wanumanuma, nata geyaꞌabwa yawasimi miyamiya hatayaina walobaloba. ");
INSERT INTO bdd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma hesi taiyawedi ꞌomi ꞌeguma hesiyogu waꞌai ma bweyahigu wanuma, nata moisa yawasimi miyamiya hatayaina waloba, ma wete taugu ꞌabwa nata ꞌamasa ꞌoinega yaꞌabi hetoholo hilegomi tuta ꞌana ꞌebe losaloha ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Weyahina wahigu bewa tauna ꞌeꞌahai moisa, ma wete bweyahigu ꞌebe numa moisa. ");
INSERT INTO bdd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Taiyawedi ꞌomi ꞌeguma wahigu waꞌewa waꞌai ma bweyahigu wanuma, ꞌomi ꞌoiguwa wamiyamiya ma taugu wete ꞌoimiya yamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu tauna moisa miyamiya hatayaina ꞌihesumanegauma, tauna ꞌoinega yawasigu yaꞌewaꞌewa. Coinega taugu wete gide, ꞌeguma taiyawedi ꞌomi hesiyogu waꞌai, ꞌomi nata wete yawasimi ꞌoiguwega waꞌewaꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“Ceꞌahainaina bewa galewega ꞌisuluma geya gide tubumiyaowedi ꞌeꞌahainaina mwalona yoho ꞌawawa siꞌaiya. Weyahina ꞌeꞌahainaina mwalona siꞌaiya ma geya ꞌoinega yawasidi miyamiya hatayana siloba, ma hesi ꞌoinega simiyamiya ꞌana siga siꞌamasaeya. Ma hesi ꞌeꞌahaiina bewa ꞌoiguwega taiyawedi ꞌomi ꞌeguma waꞌai, nata yawasimi miyamiya hatayana waloba.” ");
INSERT INTO bdd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Gwae bewa mabwaiyana ꞌihepwaila latuhediya Kapaneumi ꞌoina tutaina hada tapwalolo ꞌoina ꞌiheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ciheheꞌita, ma ꞌana tomuliyao Yesu ꞌina gwaeina sihesagoheya, ꞌoinega tupwana baibaiwadi siboidimo ꞌoidiya sigwae, “Gwae bewa ꞌana hesagoha mwauna, ꞌoinega tauda geya nuwada.” ");
INSERT INTO bdd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma hesi Yesu nige heneyage ꞌisanapu pwaiya ꞌabehega ꞌana tomuliyaowedi gwae bewa weyahina silolomugi. Coinega ꞌihegwaediya ꞌigwae, “Gwae bewa weyahina ma ꞌabehega waguipaila? ");
INSERT INTO bdd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Taugu loheyaiguina moisa ma togidega ꞌeguma waꞌitegau yahane ꞌasainaina mwalona ꞌoinega yasuluma? ");
INSERT INTO bdd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yehoba Yaluyaluwana ꞌiboinamo yawasimi ꞌana toꞌebwaya, ma hesiyage wahimi geya ꞌeta wete ꞌina lema ꞌoimiya. Cigu gwaeyedi yaꞌebwaya pwaigomiya ma ꞌoidiyega yawasimi Yehoba Yaluyaluwana ꞌoinega waꞌewaꞌewadi. ");
INSERT INTO bdd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma hesiyage tupwami geya wahemisegauwa.” Gwae bewa Yesu ꞌiꞌinanediya weyahina ꞌisanapu nugeteya taiyawedi geya sihemisae, ma wete ꞌisanapuya taiya tauna ꞌabwa nata ꞌitebae ꞌana ꞌalehaowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Coinega wete ꞌigwae, “Nuwatuhu bewa weyahina mwalona yahegwaegomiya ꞌabehega geya ꞌeta taiya sowasowahina ma ꞌitauyama ꞌoiguwa, ꞌeguma Tamagu geya ꞌoina ꞌitagwala.” ");
INSERT INTO bdd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bewa weyahina tomuliyaedi taudi Yesu silogwahateya ma siꞌebesineya. ");
INSERT INTO bdd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma site tuwelowedi siboidimo simiya hila, ꞌoinega Yesu ꞌihegwaediya ꞌigwae, “Comi togidega, nuwanuwami wete watauya?” ");
INSERT INTO bdd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Coinega Saimoni Pita Yesu ꞌenana ꞌihemaiseya ꞌigwae, “Cinapwana, taiya nata ꞌoina ꞌatauya? Weyahina ꞌowa ꞌuboi yawasi miyamiya hatayana ꞌana gwae ꞌoiuwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma wete tauma ꞌahemisaegowa ꞌabehega ꞌowa Toꞌabihetenaina Yehoba ꞌoinega ꞌutauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Coinega Yesu ꞌihegwae hilediya, ꞌigwae, “Moisa tuwa, ꞌomi wate tuwelo yahesinuwa pwaigomiya, ma hesiyage ꞌoimiyega nata ꞌaigeda Seitani ꞌina boda.” ");
INSERT INTO bdd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gwae bewa Yesu ꞌigwaeneya Yudasa weyahina, tauna Saimoni Isakaliyota natuna. Yudasaina tauna tuwa ꞌaigeda Yesu ꞌana tomuliya, ma hesi nata Yesu ꞌitebae ꞌana ꞌalehaowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Muliyetega Yesu Galili ꞌina ꞌebe loina mabwaiyana ꞌoidiya ꞌitauya, ma hesiyage geya nuwana Yudiya ꞌina ꞌebe loina ꞌoidiya ꞌitauya. Weyahina meYudiya ꞌidi ꞌinapwanaedi nuwanuwadi Yesu siloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sauga beno ꞌoina meYudiya ꞌidi Yoheyohe Guyaina ꞌiꞌehohoya. ");
INSERT INTO bdd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Coinega Yesu tasinao sihegwaeya ꞌoina sigwae, “Casa bewa ꞌuꞌebesine ma ꞌutauya Yudiya, ma ꞌa tomuliyao nobwa ꞌino paihowa siꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma wete sigwae, “Geya ꞌeta taiya paihowa dahwana ꞌoinega sanina ꞌida hemadouwa. Ceguma nuwanuwau ma tomota mabwaiyadi sisanapugo ꞌowa tuwa ꞌuboi ꞌuheꞌitaego ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tasinaowedi gwae bewa siꞌinaneya ꞌoina weyahina geya sihemisae. ");
INSERT INTO bdd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Coinega Yesu ꞌihegwae hilediya, “Casainaina ꞌoina ꞌigu sauga tauya geya ꞌana tuta ꞌiloba. Ma hesi ꞌomi ꞌami lobwaina to tuta ꞌoina ꞌeguma nuwanuwami, watauya. ");
INSERT INTO bdd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Weyahina ꞌomi nata geyaꞌabwa mebaleꞌu siloloꞌalehegomi, ma taugu hesi siloꞌalehegauwa, weyahina mumugadi galanaina yahepwailediya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Comi nata watauya guyaiina ꞌoina, taugu nata geyaꞌabwa yatautauyawa, weyahina ꞌigu sauga ꞌabwa geya ꞌilatu.” ");
INSERT INTO bdd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Gwae bewa ꞌiꞌebwaediya ꞌoinega sitauya, ma tauna tuwa Galili ꞌoina ꞌimiyahila. ");
INSERT INTO bdd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Coinega Yesu tasinaowedi siꞌebesineya ma sitauya guyaiina ꞌoina. Muliyetega Yesu wete ꞌitauya dahwana ma ꞌasainaina ꞌoina ꞌilatuwa, ma geya ꞌeta taiya ꞌisanapu toho. ");
INSERT INTO bdd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tutaina ꞌoina meYudiya ꞌidi ꞌinapwanao Yesu sibesebeseya ma sigwaegwae, “Taꞌeha tauna loheyainaina?” ");
INSERT INTO bdd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tomota baibaiwadi siboidimo ꞌoidiya siheheꞌahwa henahena Yesu weyahina. Tupwadi tomota sigwae, “Tauna loheya bwebweꞌana.” Ma tupwadi tomota sigwae, “Tauna wete toꞌeꞌaboꞌabo ꞌaigeda, tomota ꞌiꞌwayaꞌwayamidi.” ");
INSERT INTO bdd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma hesi geya ꞌeta taiya Yesu ꞌihepwaila latuwe, weyahina meYudiya ꞌidi ꞌinapwanao simatautediya. ");
INSERT INTO bdd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma guyai ꞌana gamwagamwana ꞌoina Yesu Hada Heꞌasisi ꞌoina ꞌiluhuwa ma ꞌiheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Beno ꞌoina meYudiya nuwadi ꞌihenainaida madouna, sigwae, “Toꞌehega loheya bewa ꞌina sanapu ꞌiloba ꞌeseya? Weyahina tauna geya ꞌeta ꞌebe seꞌulu madouna ꞌoina ꞌiluhu tohona.” ");
INSERT INTO bdd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Coinega Yesu ꞌihegwaediya ꞌigwae, “Taugu geya yaboi ꞌigu nuwatuhuwega yaheheꞌita, ma hesi tauna ꞌihesumanegauma ꞌina nuwatuhu ꞌoinega yaheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taiyawedi ꞌomi ꞌeguma Yehoba ꞌina nuwatuhu wapaipaihowa, ꞌomi nata wasanapugau ꞌabehega ꞌigu heꞌitaina Yehoba ꞌoinega, ma geya yaboi ꞌigu nuwatuhuwega. ");
INSERT INTO bdd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma hesi wanuwatuhuyahi ꞌeguma taiya ꞌiboimo ꞌina nuwatuhu ꞌiheheꞌita, ꞌiboimo sanina weyahina ꞌipaipaihowa. Ma hesi taugu nuwanuwagu ma tauna ꞌihesumanegauma sanina yaꞌabi hemadou. Weyahina taugu ꞌigu gwaeyao moisa, ma wete geya ꞌigu puimo. ");
INSERT INTO bdd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma togidega? Mosese loinaina ꞌiꞌebwaegomiya wanuwa naideya? Ma geya ꞌeta taiya ꞌoimiyega loinaedi ꞌimuliya bwaibwainidi. Ma bewa watohotohogau ma ꞌabehega waloheꞌamasigau.” ");
INSERT INTO bdd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Coinega bodaedi Yesu sihegwae hileya, “Yaluyaluwa biꞌi debau ꞌiꞌabi heyauyauleya ꞌoinega beno gide ꞌugwaegwae ꞌesa? Taiya hede nuwanuwana ma ꞌabehega ꞌiloheꞌamasigo?” ");
INSERT INTO bdd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Coinega Yesu bodaedi wete ꞌihegwaediya ꞌigwae, “Wagamwasowalegauwa weyahina loheya yaꞌabi hebwebweꞌaneya Sabati ꞌana sabwelo ꞌoina? Ma ꞌomi togidega ꞌimi paihowa Sabati ꞌina sabwelo ꞌoina? ");
INSERT INTO bdd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Weyahina Mosese ꞌina loina ꞌabehega natumiyao loheloheyadi ꞌidi ꞌebe selolo ꞌwapina waꞌupwa yahuledi. (Loinaina bewa geya Mosese ꞌoinega, ma hesi tubumiyao nugenugetadi ꞌoidiyega loina bewa ꞌitauyama.) ");
INSERT INTO bdd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Coinega ꞌedaꞌeda bewa ꞌeguma gide wapaihowa ꞌesedi ma gwagwama loheloheyadi ꞌoidiya gide wapaihowa ꞌesedi Sabati ꞌana sabwelo ꞌoina, beno moisa Mosese ꞌina loina wamulimuliye. Ma toꞌaha hede weyahina ta waloꞌalehegauwa tutaina loheya Sabati ꞌana sabwelo ꞌoina yaꞌabi hebwebweꞌaniya? ");
INSERT INTO bdd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Coinega sahena ꞌiyamiyao ꞌadi ꞌita ꞌoinega weyahidi wagwaegwae hesihesinuwa. Ma hesi soladiya loina dumwalunega wagwae hesihesinuwa bwaibwaina.” ");
INSERT INTO bdd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Saugaina ꞌoina meYelusalema tupwadi sigwaeya sigwae, “Loheya bewa nuwana tauna nuwanuwadi ma ꞌabehega siloheꞌamasi, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma hesi waꞌita, boda gamwagamwanidiya ꞌitoholowa ma ꞌoidiya ꞌihehegwaegwae ma geya ꞌeta taiya ꞌenana ꞌida hehileya. Togidega ma ꞌida tohanugetao siꞌahwa moisaeya ꞌabehega tauna tuwa Toꞌabihetenaina, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma nuwana geya, weyahina mabwaiyada loheya bewa tasanapuya to ꞌasa ꞌoinega ꞌitauyama. Ma hesi Toꞌabihetenaina ꞌeguma ꞌitauyama, geya ꞌeta taiya ꞌina ꞌebe tauyama ꞌisanapu.” ");
INSERT INTO bdd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tutaina Yesu ꞌabwa Yehoba ꞌina hada ꞌoina ꞌiheheꞌita, ꞌenana madouna ꞌoinega ꞌihegwaegwaeya ꞌigwae, “Moisa tuwa, wasanapu pwaigauwa to ꞌasa ꞌoinega yatauyama, ma hesi wanuwatuhuyahi ꞌabehega tauna ꞌihesumanegauma ꞌina loina ꞌoinega yatauyama ꞌasa bewa ꞌoina. Geya yaboi ꞌigu loina ꞌoinega ma ꞌasa bewa ꞌoina yatauyama. Cagu tohesumaneina tauna mumugana bwebweꞌana, ma ꞌomi geya wasanapu tauna. ");
INSERT INTO bdd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yaboi hesi yasanasanapu weyahina tauna ꞌihesumanegauma ma wete tauna ꞌoinega yatauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Beno ꞌoina loheloheyaedi sitohoya ma ꞌabehega siꞌabiyahi, ma togidega ta geya ꞌeta taiya ꞌwapina ꞌiꞌabi toho. Weyahina ꞌina ꞌamasa ꞌana sauga geya ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma hesi tomota tupwana baibaiwadi sihemisaeya, ꞌoinega sigwae, “Loheya bewa moisa Toꞌabihetena, weyahina geya sowasowahina ma ꞌeta taiya ꞌitauyama ma loheya bewa ꞌina paihowa waiwaina ꞌinugete.” ");
INSERT INTO bdd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eeta tomota ꞌidi gwae dahwana meYudiya ꞌidi ꞌinapwanao sisanapuya, ꞌoinega taudi ma topwaoli madoudi ꞌidi tuilalao sihesumanediya sitauya Yesu ꞌabehega siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sitauyama ma Yesu ꞌihegwaediya ꞌigwae, “Taugu tuwa sauga ꞌiꞌiunamo ꞌoina ꞌoimiya yamiyamiya ma wete yalohihila tauna ꞌihesumanegauma ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cabwa nata wabesegau ma gesowana walobegau. Casainaina ꞌoina yamiyamiya ꞌomi geya sowasowahimi ꞌoina watauyawa.” ");
INSERT INTO bdd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Coinega meYudiyaedi siboidimo ꞌoidiya sigwae, “Toꞌehega ꞌabehega ꞌihaꞌesa ma geyaꞌabwa talobaloba? Bo nuwana ꞌabehega taudi meYudiya siboi ꞌidi ꞌasa ꞌoinega silatuwa ma sitauya tupwa ganamuliyedi ꞌoidiya simiyamiya, ma nobwa tomiya ganamuliyedi ꞌiheꞌitadi, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Cina gwaeina togidega ꞌana sanapu? Weyahina ꞌigwaeya ꞌigwae, ‘Nata wabesegau, ma hesi gesowana walobegau’. Ma wete ꞌigwaeya ꞌigwae, ‘Casainaina ꞌoina yamiyamiya ꞌomi geya sowasowahimi ma ꞌoina watauyawa.’” ");
INSERT INTO bdd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ma guyainaina ꞌana ꞌebe losaloha, beno ꞌana sabwelo madouna ꞌoina, Yesu boda gamwagamwanidiya ꞌitoholowa ma ꞌenana madounega ꞌihegwaediya ꞌigwae, “Taiyawedi ꞌomi ꞌeguma taniꞌomi siyahala, wanaoma ꞌoiguwa ma weꞌaha wanuma. ");
INSERT INTO bdd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Weyahina Buki Heꞌasisi ꞌoina ꞌihepwaila ꞌigwae, ‘Taiyawedi ꞌagu tohemisaowedi, ꞌatediyega weꞌaha ꞌidaudau tomota yawasidi weyahina.’” ");
INSERT INTO bdd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ꞌihehegwaegwae Yaluyaluwa Tabuna weyahina, ma muliyetega ꞌabwa ꞌana tohemisaowedi Yaluyaluwa Tabuna ꞌoidiya ꞌiluhu. Tutaina beno ꞌoina, Yaluyaluwa Tabuna ꞌabwa geya tomota ꞌoidiya ꞌiluhu, weyahina Yesu ꞌabwa geya ꞌihane ꞌina ꞌebeloina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesu ꞌina hegwaegwae tomota sihesagoheya ꞌoinega tupwana baibaiwadi siboidimo ꞌoidiya sigwae, “Moisa tuwa, loheya bewa palopitaina sigwaegwaeneya.” ");
INSERT INTO bdd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma tupwadi sigwae, “Tauna tuwa Toꞌabihetenaina.” Ma tupwadi wete sigwae, “Moisa wanuwatuhuya ꞌabehega Toꞌabihetenaina Galili ꞌoinega ꞌitauyama? Cana ꞌita geya sowasowahina. ");
INSERT INTO bdd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Weyahina Buki Heꞌasisi ꞌoina ꞌihepwaila pwaiya ꞌabehega Toꞌabihetenaina nata tubudai Debida ꞌina susu ꞌoinega ꞌitauyama. Ma wete Debidaina ꞌina ꞌasa Bedeliyema ꞌoina, nata Toꞌabihetenaina ꞌoina ꞌiliꞌu.” ");
INSERT INTO bdd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bewa ꞌoinega, tomota ꞌoidiya miya wasiwasi ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tomotaedi tupwadi nuwanuwadi ma Yesu siꞌabiyahi, ma hesi geya ꞌeta taiya ꞌoidiyega Yesu ꞌwapina ꞌiꞌabitoho. ");
INSERT INTO bdd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Coinega tuilalaedi silohihila topwaoli madoudi ma wete Palisiyao ꞌoidiya, ꞌoinega ꞌinapwanaowedi ꞌidi tuilalaedi sihesilalediya sigwae, “Toꞌaha weyahina geya waꞌabiyahi ma watauyeyama?” ");
INSERT INTO bdd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Coinega tuilalaedi sigwae, “Loheya nage ꞌina gwae mabwaiyana bwebweꞌadi. Geya ꞌeta taiya gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Coinega Palisiyedi sigwae, “Nuwana ꞌihenuwa ꞌewegomiya, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma hesi wada sanapu ꞌabehega geya ꞌeta taiya ꞌinapwanao ꞌoidiyega bo wete tauma Palisiyao ꞌoimega Yesu ꞌihemisae. ");
INSERT INTO bdd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Boda baibaiwadi hesi sihemisaeya, weyahina taudi Mosese ꞌina loinao geya sisanapudi, ꞌoinega taudi Yehoba ꞌina loina mwau hedadena nata siloba.” ");
INSERT INTO bdd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Toloinaedi ꞌoidiyega ꞌaigeda sanina Nikodimo, tauna mwalona nihuwanega Yesu ꞌoina ꞌitauya ma mahetena sihegwaegwaeya. Nikodimoina toloinaowedi ꞌihegwaediya ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tauda ꞌida loina ꞌabehega geyaꞌabwa taloiloina bwagabwaga, ma hesi loheya tahesilalae ma ꞌina pui tabesa nugete, ꞌabwa muliyetega toꞌaha ꞌana loina taꞌebwae.” ");
INSERT INTO bdd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Coinega ꞌinapwanaowedi Nikodimo sihegwae hileya, “Nuwana ꞌowa Galili loheyaina, ꞌawa? Ma hesi ꞌeguma Buki Heꞌasisi ꞌuhasili, nata ꞌusanapu ꞌabehega geya ꞌeta wete palopita Galili ꞌoinega ꞌitauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Muliyetega mabwaiyadi silohihila ꞌidi hada ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma Yesu ꞌilatuwa, ꞌitauya Olibe ꞌoyana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gona ꞌiꞌadaleya ma Yesu wete ꞌilohihila Hada Heꞌasisi ꞌalona, ma tomota mabwaiyadi wete simiya ꞌwabuꞌwabuya ma tauna wete ꞌimiyatoiya ma ꞌiheꞌitediya. ");
INSERT INTO bdd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Muliyetega loina ꞌadi toheꞌitao* ma wete Palisiyao wahine ꞌaigeda sitoeyama Yesu ꞌoina. Weyahina wahineina siꞌitalobeya pui ꞌipaihoweya, ꞌoinega sihetoholoya tomota gamwagamwanidiya, ma Yesu sihegwaeya sigwae, ");
INSERT INTO bdd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Toheꞌita, wahine bewa ꞌalobeya pui ꞌipaihoweya. ");
INSERT INTO bdd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tauda ꞌida loina Mosese ꞌiꞌebwaegita ꞌabehega ꞌeguma taiyawedi tolopui talobadi wahine bewa gidemusa, ꞌabehega ꞌilobwainediya ma daꞌule ꞌoidiyega taꞌahu yamatedi ma siꞌamasa. Ma hesi ꞌowa togidega ꞌino nuwatuhu wahine bewa weyahina?” ");
INSERT INTO bdd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gwae bewa siꞌinaneya ma ꞌabehega ꞌoinega Yesu ꞌina ꞌabo siloba ma wete siheyatalae. Ma hesi ꞌidi gwaeina Yesu geya ꞌihemaise, tuwa ꞌimiya bwasibwasiꞌaꞌa ma negwanegwala ꞌoina nimanega ꞌilelelele. ");
INSERT INTO bdd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Taudi ꞌabwa tuwa sihehesilala dada, ꞌoinega Yesu ꞌitoholowa ma ꞌihegwaediya ꞌigwae, “Ceguma ꞌomi ꞌoimiyega taiya geya ꞌina puimo, bewa tuwa daꞌule ꞌiꞌewa ma wahineina ꞌoina ꞌiula nugeta.” ");
INSERT INTO bdd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Coinega ꞌimiya bwasibwasiꞌaꞌa hila ma wete negwanegwala ꞌoina ꞌilelelele. ");
INSERT INTO bdd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Beno ꞌoina Yesu ꞌina gwae sihesagoheya ma ꞌaigeda ꞌaigeda ꞌidi pui sinuwatuhudiya ma ꞌoinega silatulatu. Cinapwanaowedi sihapwesa nugeta, ta baibaiwadi simuliya, eeta siteluwaedi Yesu ma wahineina ꞌitotoholo baꞌidana siꞌebesinediya. ");
INSERT INTO bdd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Muliyetega Yesu ꞌisapaila hila ta wahineina ꞌihesilaleya ꞌigwae, “Loheloheyaedi taꞌehega sihaꞌesa? Ta geya ꞌeta taiya ꞌimiya hila ma tauna ꞌiheꞌewago?” ");
INSERT INTO bdd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma wahineina ꞌigwaeya, “Cinapwana, geya ꞌeta taiya.” Coinega Yesu wete ꞌigwaeya, “Bwebweꞌana, taugu nata geyaꞌabwa wete yaheheꞌewago. Coinega bewa tuwa ꞌutauya ma hesi sahena wete ꞌupuipui hila.” ");
INSERT INTO bdd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Coinega Yesu wete ꞌihegwae hilediya ꞌigwae, “Taugu gogo gabulena ꞌana ꞌasilala. Ma taiyawedi ꞌomi ꞌeguma wamuliyegau, nata taugu ꞌasilalaina yawasimi ꞌoidiya yasae hane, ma ꞌoinega geyaꞌabwa guguyou ꞌoina watautauya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma hesi Palisiyedi Yesu sihegwaeya sigwae, “Cowa hene ꞌuboi weyahiu ꞌuhehegwaegwae, ꞌoinega geya wete ꞌahemisamo.” ");
INSERT INTO bdd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu wete ꞌihegwaediya ꞌigwae, “Yaboi moisa weyahigu yahehegwaegwae, ma hesi toꞌaha gide ꞌigu hepwaila, mabwaiyadi hepwaila moisa. Weyahina yasanapuya taꞌehega yatauyama ma wete yasanapuya taꞌeha yatautauya. Ma hesi ꞌomi geya wasanapu taꞌehega yatauyama ma wete geya wasanapu taꞌeha yahahaꞌesa. ");
INSERT INTO bdd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Comi, ꞌimi hesinuwa mebaleꞌu ꞌidi hesinuwa gidemusa. Ma hesiyage taugu geya ꞌeta taiya weyahina yada hesinuwa, bo nuwana yada loina. ");
INSERT INTO bdd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma ꞌeguma tomota weyahidi yahesinuwa, nata ꞌigu loina mabwaiyana bwebweꞌana. Weyahina loinaina geya yaboi ꞌigu loina, ma hesi Tamagu tauna ꞌihesumanegauma mahetegu ꞌima loinega yaloiloina. ");
INSERT INTO bdd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mosese ꞌina loinaedi wasanapudiya ꞌabehega ꞌeguma tohepwaila siteluwa ꞌoidiyega ꞌidi hepwaila mahemahetena, beno hepwaila moisa. ");
INSERT INTO bdd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taugu yaboi weyahigu yahehepwaila, ma Tamagu wete weyahigu ꞌihehepwaila, tauna ꞌihesumanegauma.” ");
INSERT INTO bdd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Coinega sihesilaleya sigwae, “Tamauina taꞌeha ꞌimiyamiya?” Ma Yesu ꞌenadi ꞌihemaiseya, ꞌigwae, “Geya wasanapugau, ꞌoinega Tamagu wete geya wasanapu. Ma ꞌeguma moisa wada sanapugauwa, Tamagu wete wada sanapuya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu ꞌina heꞌitaedi bewa, Hada Heꞌasisi ꞌoina ꞌiheꞌitaediya, helau ꞌadi ꞌebe doꞌona deidiya. Ma hesi geya ꞌeta taiya Yesu ꞌiꞌabiyahi, weyahina ꞌina tuta ꞌabwa geya ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu wete ꞌihegwaediya, “Cabwa nata yaꞌebe sinegomi, ma hesi ꞌasainaina ꞌoina yatautauya geya sowasowahimi ma ꞌoina watauyawa. Weyahina nata moisa waꞌebesegau, ma hesi nata ꞌimi pui ꞌoidiyega waꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Coinega meYudiyaedi siboidimo ꞌoidiya sigwae, “Toꞌaha ꞌina gwaeina ꞌana sanapu, weyahina ꞌigwaeya ꞌabehega ꞌasainaina ꞌoina ꞌitautauya, geya sowasowahida ma ꞌoina tatauya? Bo nuwana ꞌiboimo ꞌabehega ꞌiloheꞌamasa hile?” ");
INSERT INTO bdd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma Yesu wete ꞌihegwaediya, ꞌigwae, “Comi gogo gabulena ꞌoinega walatuma, ma taugu hesiyage tabwanega yasuluma. Coinega ꞌomi moisa ꞌimi gogo bewa, taugu geya. ");
INSERT INTO bdd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Beno huhuna ꞌoinega yahegwaegomiya ꞌabehega ꞌimi pui nata ꞌoidiyega waꞌamasa, ꞌeguma geya wahemisaegau taugu.” ");
INSERT INTO bdd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Coinega taudi wete Yesu sihegwaeya sigwae, “To loheya hede ꞌowa?” Ta tauna wete ꞌenadi ꞌihemaiseya ꞌigwae, “Mwalona yahegwae pwaigomiya taugu taiya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ma wete ꞌihegwae hilediya ꞌigwae, “Sowasowahigu ma ginaula baibaiwadi weyahidi yahegwaegwae ma wete weyahidi yaloina, ma hesiyage tauna ꞌihesumanegauma mumugana mabwaiyana bwebweꞌana. Toꞌaha gidemusa ꞌoinega yahesagohediya, beno tuwa taudi weyahidi yahehegwaegwae mebaleꞌu ꞌoimiya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma hesi taudi tuwa Yesuina ꞌina gwaeina ꞌoidiya Tamana weyahina geya nuwadi ꞌiꞌasilala tohona. ");
INSERT INTO bdd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ma Yesu wete ꞌigwaeya, “Taugu Loheyaiguina moisa ꞌabwa nata waꞌabi hanehegau ma beno ꞌoina nata wasanapugau taugu taiya, ma wete wasanapu ꞌabehega taugu geya yaboi ꞌigu nuwatuhu ꞌoinega yada paihowa, ma hesi toꞌaha gide Tamagu ꞌiheꞌitegauwa ꞌoidiyega yahehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tauna ꞌihesumanegauma geya ꞌiꞌebesinegau, deiguwa ꞌimiyamiya. Weyahina tuta mabwaiyana ꞌoidiya ꞌigu paihowa ꞌoidiyega yaꞌabiꞌabi heyaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ꞌina gwaeina bewa tomota tupwana baibaiwadi sihesagoheya, ꞌabwa hesi sihemisae bwaibwainiya. ");
INSERT INTO bdd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Coinega meYudiyaedi taudi Yesu sihemisaeya, ꞌihegwaediya ꞌigwae, “Cigu heꞌita ꞌeguma wamuliyedi, ꞌomi moisa ꞌagu tomuliyao. ");
INSERT INTO bdd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma ꞌoinega sanapu moisa waloba, ma sanapuina ꞌoinega lihasa waloba.” ");
INSERT INTO bdd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma taudi Yesu sihegwaeya sigwae, “Ciya, tauma hene Ebalahamo ꞌina bodao, geya ꞌeta taiya wete ꞌina loina ꞌoinega ꞌipaimai. Ma toꞌaha weyahina ꞌugwaeya ꞌabehega lihasa ꞌoiuwega ꞌaloba?” ");
INSERT INTO bdd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Coinega Yesu wete ꞌihegwae hilediya ꞌigwae, “Yagwae moisa ꞌoimiya, taiyawedi ꞌeguma ꞌidi paihowa galadi, taudi beno bodaedi geya lihasa ꞌoina simiyamiya. Weyahina ginaula galadi ꞌina waiwai ꞌoinega ꞌipaidiya. ");
INSERT INTO bdd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Weyahina topaihowa taudi geya lihalihasidi, tuta mabwaiyana geya susu ꞌina boda ꞌoina sida miya hataya. Ma hesi toni hada natuna tauna susu ꞌina boda ꞌona miyamiya hatayana. ");
INSERT INTO bdd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Comi wete gidemusa, ꞌeguma toni hada natunaina ꞌilihasigomi ꞌomi nata bewa tuwa lihalihasimi. ");
INSERT INTO bdd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Yasanapu pwaigomiya ꞌomi Ebalahamo ꞌina bodao, ma hesiyage watohotoho ma ꞌabehega waloheꞌamasigau. Weyahina ꞌigu heꞌitao geya ꞌatemiya wada lagudiya. ");
INSERT INTO bdd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma hesiyage taugu toꞌaha gide Tamagu ꞌiheꞌitegauwa, wete gide ꞌoimiya yahehegwaegwaenedi. Comi hesi toꞌaha gidemusa tamamiu ꞌoinega wahesagoheya, wete gide wapaipaihowa ꞌesedi.” ");
INSERT INTO bdd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Coinega Yesu ꞌenana sihemaiseya sigwae, “Ciya, tauma heneyage Ebalahamo tamamai.” Ma Yesu wete ꞌihegwaediya ꞌigwae, “Ceguma ꞌomi moisa Ebalahamo natunao, ꞌina paihowega wada paihowa. ");
INSERT INTO bdd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma hesi ꞌomi ꞌimi paihowa hagana, weyahina watohotoho ma ꞌabehega taugu gwaeina moisaina ꞌana tohepwailina Yehoba ꞌoinega waloheꞌamasigau. Ma wete paihowaedi bewa gide wapaipaihowa ꞌesedi, geya gidemusa Ebalahamo ꞌina paihowa. ");
INSERT INTO bdd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Comi hene waboi tamamiu ꞌina paihowa ꞌoinega watautauya.” Coinega Yesu ꞌenana sihemaiseya sigwae, “Tauma geya tama budabudaima, tauma hene tamamaina ꞌaigeda tuwa Yehoba.” ");
INSERT INTO bdd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu wete ꞌihegwaediya ꞌigwae, “Comi ꞌeguma moisa Yehoba tamamiu, wada helauwegauwa. Weyahina taugu Yehoba ꞌihesumanegauma, ma ꞌasa bewa ꞌoina yatauyama. Ma geya ꞌabehega yaboi ꞌigu nuwatuhuwega yatauyama ꞌasa bewa ꞌoina, ma hesi tauna ꞌihesumanegauma ꞌina nuwatuhu ꞌoinega yatauyama. ");
INSERT INTO bdd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Coinega toꞌaha weyahina ꞌigu gwae geya wada sanapudiya? Nuwana ꞌigu hepwailaedi geya wada hesagoha bwaibwainidiya. ");
INSERT INTO bdd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Comi hesiyage Seitani tamamiu, ꞌoinega nuwanuwami ma tamamiuina ꞌina nuwatuhuwedi wapaihowadi. Weyahina sauga ꞌebe hegaina hauhau ꞌoinega ꞌitauyama, tauna toloheꞌamasa moisa. Geya ꞌeta wete ꞌeda dumwadumwaluna ꞌoinega ꞌida tauya. Weyahina geya ꞌeta wete gwae moisa ꞌoina ꞌida miyana. Tuta mabwaiyana ꞌoidiya ꞌeꞌaboꞌabo ꞌoidiyega ꞌihehegwaegwae, weyahina tauna tuwa beno gidemusa mumugana, ma wete tauna toꞌeꞌaboꞌabowao mabwaiyadi tamadiu. ");
INSERT INTO bdd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma hesiyage taugu gwae moisa ꞌoimiya yahehepwailedi, ma geya wada hemisaegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ma togidega? Sowasowahimi ma ꞌeta taiya ꞌoimiyega ꞌigu ꞌeda galadi ꞌihepwailedi? Nuwana geya sowasowahimi, ꞌawa? Coinega ꞌeguma gwae moisa ꞌoidiyega yahehegwaegwae, toꞌaha weyahina geya wada hemisaegauwa? ");
INSERT INTO bdd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Weyahina taiya ꞌeguma moisa Yehoba ꞌoinega ꞌitauyama, tauna moisa Yehoba ꞌina gwae ꞌana tohesagoha bwaibwaina. Ma ꞌomi hesi nuwana geya Yehoba ꞌoinega watauyama, ꞌoinega Yehoba ꞌina gwae geya wada hesagohediya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","MeYudiyaedi ꞌidi ꞌinapwanao Yesu ꞌina gwaeina sihemisaeya, sigwae, “Mwalona ꞌima gwae weyahiu, ꞌana moisa ꞌilatu pwaima. Weyahina ꞌagwaeya ꞌabehega ꞌowa Sameliya loheyaina, ma wete hiꞌahiꞌa* ꞌoiuwa ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma Yesu ꞌihegwaediya ꞌigwae, “Taugu geya hiꞌahiꞌa ꞌoiguwa, weyahina Tamagu yaheꞌasisiyaneya, ma hesi geya waheꞌasisiyanegau. ");
INSERT INTO bdd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taugu moisa yaboi geya sanigu yada ꞌabi haneheya. Toloina ꞌaigeda tauna hesi sanigu ꞌiꞌabiꞌabi hanehe. ");
INSERT INTO bdd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Coinega yagwae moisa ꞌoimiya taiyawedi ꞌomi ꞌeguma ꞌigu gwae wagwahu bigadi, ꞌomi nata geyaꞌabwa waꞌamaꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Coinega meYudiyaedi wete sihegwaeya sigwae, “Cabwa hesi ꞌasanapu bwaibwainigowa, tomada ꞌabe hiꞌahiꞌa ꞌoiuwa ꞌimiyamiya. Weyahina Ebalahamo ꞌasanapuya ꞌiꞌamasa pwaiya ma wete palopitao ꞌasanapudiya siꞌamasa pwaiya. Ma ꞌugwaeya ꞌabehega taiyawedi ꞌeguma ꞌino gwae sihegwahu bigadi, geyaꞌabwa siꞌamaꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tamamaina Ebalahamo ꞌiꞌamasa pwaiya, ꞌoinega sahena ꞌutohotoho ma ꞌabehega tamamaina ꞌulagu suluhe ma ꞌuboi ꞌulagu hanehego. Palopitao wete siꞌamasa pwaiya, ꞌoinega sahena wete ꞌutohotoho ma ꞌabehega ꞌulagu suluhedi, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eema Yesu ꞌihegwaediya ꞌigwae, “Taugu ꞌeguma yaboi moisa yahehepwatu hilegau, ꞌagu hepwatuina ginaula bwagabwaga. Ma hesi Tamagu tauna moisa ꞌagu tohepwatuina, tauna tuwa wagwaeneya ꞌabehega ꞌimi Yehoba. ");
INSERT INTO bdd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma hesi tauna geya wasanapu toho, yaboi tuwa yasanapuya. Ma ꞌeguma yagwae, ‘Geya yasanapu,’ nata yaꞌabowegomi gidemusa ꞌomi waꞌeꞌaboꞌabo. Ma hesiyage tauna yasanapu bwaibwainiya ꞌoinega ꞌenanaina yagwahugwahu bigadi. ");
INSERT INTO bdd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamamiuina Ebalahamo maꞌina yaliyaya ma ꞌabehega ꞌigu sabwelo ꞌiꞌita, ꞌoinega ꞌigu sabweloina ꞌiꞌiteya ma ꞌiyaliyaya madouna.” ");
INSERT INTO bdd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Coinega meYudiyaedi Yesu sihegwaeya sigwae, “Cowa ꞌabwa geya ꞌino bolime pipiti ꞌuloba ma ꞌugwaeya ꞌabehega Ebalahamo ꞌuꞌiteya.” ");
INSERT INTO bdd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma Yesu ꞌihegwaediya, ꞌigwae, “Yagwae moisa ꞌoimiya, taugu nugeta yamiyamiya, ꞌabwa muliyetega Ebalahamo ꞌiliꞌuwa.” ");
INSERT INTO bdd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Coinega meYudiyaedi daꞌule siꞌewediya ma ꞌabehega siꞌahu yamate, ma Yesu ꞌoidiyega ꞌihaꞌwaiha ma Hada Heꞌasisi ꞌoinega ꞌilatuwa ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hali sabwelo ꞌoina Yesu ꞌitautauya ta ꞌedai loheya ꞌaigeda mata gibugibuina ꞌilobeya, loheyaina ꞌina mata gibugibuina ꞌina sauga liꞌu ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma Yesu ꞌana tomuliyao sihegwae sigwae, “Toheꞌita, taiya ꞌina pui ꞌoinega loheya nage ꞌiliꞌuwa mata gibugibuina? Ciboimo tuwa ꞌina pui bo sinana ma tamana ꞌidi pui?” ");
INSERT INTO bdd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Coinega ꞌenadi Yesu ꞌihemaiseya ꞌigwae, “Geya tauna ꞌina pui ꞌoinega, bo nuwana sinana ma tamana ꞌidi pui ꞌoinega. Ma hesi tuwa nage gidemusa matana ꞌigibuwa ma ꞌoinega tomota mabwaiyadi Yehoba ꞌina paihowa waiwaina siꞌita, loheyaina ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tauna ꞌihesumanegauma ꞌina paihowa sowasowana tapaihowadi sabwelo ꞌoina, weyahina nihuwana ꞌeguma ꞌilatu, geya sowasowahina tapaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Coinega tutaina taugu baleꞌuwa yamiyamiya, taugu tuwa baleꞌuina ꞌana ꞌasilalaina.” ");
INSERT INTO bdd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Gwae bewa ꞌiꞌinanediya ꞌigumwala, ma baleꞌuwa ꞌiꞌesoha ma ꞌesohanaina ꞌoinega baleꞌu mahetena ꞌihinisiya ta dobadobaꞌa ꞌipaihoweya, ma ꞌoinega loheyaina mata gibugibuinaina matana ꞌoina ꞌiꞌeꞌabiꞌabiyeya. Cigumwala ");
INSERT INTO bdd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ma ꞌihegwaeya ꞌigwae, “Cutauya Sailome weꞌahina ꞌoina matauina ꞌubuyo.” (Sailome ꞌana bui beno hesumane.) Coinega loheyaina ꞌitauya Sailome weꞌahina ꞌoina, matanaina ꞌibuyoya ma ꞌibwebweꞌana ma wete ꞌihilama. ");
INSERT INTO bdd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Muliyetega loheyaina ꞌiyanaowedi ma wete tomotaedi taudi loheyaina sisanapuya ꞌabehega tauna toloꞌahwaꞌahwanoi ta sigwae, “Tauna bewa toloꞌahwaꞌahwanoi hedahedada sauga mabwaiyana ꞌimiyamiya ma ꞌiloloꞌahwaꞌahwanoi, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Coinega tupwadi sigwae, “Cehe, tauna tuwa beno loheyainaina.” Ma wete tupwadi sigwae, “Ciya, hagana, ma hesi loheya ꞌaigeda ꞌana ꞌita tauna gidemusa.” Ma ꞌiyamo loheyaina ꞌiboimo ꞌihepwaila hileya ꞌigwae, “Geya, taugu tuwa toloꞌahwa ꞌahwanoiina.” ");
INSERT INTO bdd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Coinega sihesilaleya sigwae, “Togidega matau ꞌibwebweꞌana ꞌesa?” ");
INSERT INTO bdd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma loheyainaina ꞌenadi ꞌihemaiseya ꞌigwae, “Loheya ꞌaigeda sanina Yesu dobadobaꞌa ꞌipaihoweya ma matagu ꞌoina ꞌiꞌeꞌabiꞌabiyeya, ma ꞌihegwaegauwa ꞌigwae, ‘Cutauya Sailome weꞌahina ꞌoina matauina ꞌubuyo.’ Coinega yatauya weꞌahina ꞌoina mataguina yabuyoya, ꞌoinega nige bewa mataguina ꞌibwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ta wete sihesilala hileya sigwae, “Taꞌeha tauna loheyainaina?” Ma ꞌihegwaediya ꞌigwae, “Cinamuge, geya yasanapu.” ");
INSERT INTO bdd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yesu loheyaina matana ꞌiꞌabiꞌabi hebwebweꞌaneya Sabati ꞌana sabwelo ꞌoina. Coinega tomata gibugibuina sitoeya ma sitauyeya Palisiyao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma Palisiyedi tomata gibugibuina wete sihesilala hileya sigwae, “Togidega matauina ꞌibwebweꞌana ꞌesa?” Coinega ꞌihegwaediya ꞌigwae, “Dobadobaꞌa ꞌipaihoweya ma mataguwa ꞌiꞌeꞌabiꞌabiyeya ma weꞌaha ꞌoina yabuyoya ma mataguina ꞌibwebweꞌana.” ");
INSERT INTO bdd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Coinega Palisiyedi tupwadi sigwae, “Matauina ꞌana topaihowaina, tauna geya Yehoba ꞌoinega ꞌitauyama. Weyahina Sabati ꞌana loina geya ꞌida muliyediya.” Ma tupwadi wete sigwae, “Togidega, togala ꞌeta sowasowahina ma ꞌilaꞌilala bewa gidemusa ꞌipaihowa ꞌese? Bo geya ꞌeta taiya sowasowahina, ꞌawa?” Bewa ꞌoinega wataha ꞌoidiya ꞌilatuwa. Weyahina boda tupwadi ꞌidi gwae hagadi ma hali boda wete ꞌidi gwae hagadi. ");
INSERT INTO bdd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Muliyetega Palisiyedi wete tomata gibugibuina sihesilala hileya sigwae, “Cowa togidega ꞌino nuwatuhu matau ꞌana toꞌabi hebwebweꞌanaina weyahina?” Coinega tauna ꞌigwaeya, “Tauna palopita ꞌaigeda.” ");
INSERT INTO bdd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma hesi meYudiyaedi loheyaina geya sihemisae ꞌabehega tauna moisa mata gibugibuina ma ꞌabehega bewa tuwa matana ꞌibwebweꞌana hila. Coinega sinana ma tamana sibwauwediya ");
INSERT INTO bdd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ma sihesilalediya sigwae, “Tauna bewa moisa natumiu? Ma wete wasanapuya ꞌabehega mamata gibugibuina ꞌiliꞌuwa? Ma wete togidega ta matana ꞌibwebweꞌana hila?” ");
INSERT INTO bdd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Coinega loheyaina sinana ma tamana Palisiyao ꞌenadi sihemaiseya sigwae, “Tauma bewa moisa natumai, ma wete ꞌasanapuya ꞌabehega mata gibugibuina ꞌiliꞌuwa. ");
INSERT INTO bdd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma hesi geya ꞌasanapu togidega matana ꞌibwebweꞌana ꞌesa. Ma wete geya ꞌasanapu taiya matana ꞌiꞌabi hebwebweꞌaniya. Ma mane hana tauna wahesilala. Tauna boꞌiyage ꞌihemadou pwaiya, sowasowahina ma ꞌiboi weyahina ꞌihegwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sinanaina ma tamanaina gwae bewa siꞌinanediya weyahina meYudiya ꞌidi tohanugetao simatautediya. Weyahina meYudiya ꞌidi loina silaguya ꞌabehega taiyawedi ꞌeguma Yesu siꞌahwa Toꞌabihetena, taudi nata hada tapwalolo ꞌoinega sipaꞌidi. ");
INSERT INTO bdd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bewa huhuna ꞌoinega loheyaina tamana ma sinana sigwaeya sigwae, “Mane hana tauna wahesilala ma ꞌiboi weyahina ꞌihegwaegwae, weyahina ꞌihemadou pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Coinega wete tomata gibugibuina sibwau hileya ma sihegwaeya sigwae, “Cuhepwaila bwaibwaina ꞌoima, weyahina loheyaina ꞌasanapu bwaibwainiya tauna togala.” ");
INSERT INTO bdd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma ꞌigwaeya, “Geya yasanapu nuwana tauna togala, bo nuwana geya. Ma tuwa beno yasanapuya matagu ꞌigibuwa ma ꞌiꞌabihe bwebweꞌanigauwa.” ");
INSERT INTO bdd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Coinega ꞌoina sihesilala, sigwae, “Toꞌaha matauina ꞌoina ꞌipaihoweya ma ꞌubwebweꞌana?” ");
INSERT INTO bdd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma tauna wete ꞌihegwaediya, “Nige heneyage yahegwae pwaigomiya ma ꞌenagu geya wahesagohe. Toꞌaha weyahina ꞌabehega wahesagoha hila? Nuwana nuwanuwami ma ꞌabehega wamuliye, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma hesi taudi siheliyeya sigwae, “Cowa tuwa ꞌana tomuliyaina, taiya hedeyage. Ma tauma Mosese ꞌana tomuliyao, ");
INSERT INTO bdd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","weyahina ꞌasanapuya ꞌabehega Yehoba ꞌina hepwailao ꞌiꞌebwaeya Mosese ꞌoina. Ma hesi loheyaina beno geya ꞌasanapu taꞌehega ꞌitauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Loheyaina ꞌenadi ꞌihemaiseya ꞌigwae, “Cebe nuwa henainaida, weyahina loheyaina matagu ꞌiꞌabi hebwebweꞌaneya, ma hesi geya wasanapu taꞌehega ꞌitauyama. ");
INSERT INTO bdd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ta wete mabwaiyada tasanasanapu ꞌabehega Yehoba geya sowasowahina ma togala ꞌenadi ꞌihesagohedi, beno tuwa ꞌeguma taiya Yehoba ꞌiheꞌasisiyane ma ꞌina nuwatuhu ꞌipaihowadi, nata tauna ꞌenana Yehoba ꞌihesagohedi. ");
INSERT INTO bdd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ma wete tasanasanapu ꞌabehega baleꞌu ꞌana hemasalaha hauhau ꞌoinega ta nige bewa, geya ꞌeta taiya wasana tahesagohe ꞌabehega tomata gibugibu ꞌiꞌabiꞌabi hebwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Loheyaina beno ꞌeguma geya Yehoba ꞌoinega, geya sawasawahina ma ꞌilaꞌilala bewa gide ꞌipaihowa ꞌese.” ");
INSERT INTO bdd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta Palisiyedi loheyaina sihegwaeya sigwae, “Cino liꞌu hauhau ꞌoinega ꞌitauyama ꞌowa ꞌaigeda topui. Ma bewa ꞌabehega ꞌutohotoho ma ꞌuheꞌitemai, ꞌawa? Taiya ꞌowa nigeyage?” Coinega loheyaina hada tapwalolo ꞌoinega sipaꞌiya ma ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Loheyaina wasana Yesu ꞌihesagoheya ꞌabehega hada tapwalolo ꞌoinega sipaꞌiya, ꞌoinega ꞌitauya loheyainaina ꞌibeseya, ta ꞌilobeya, ma ꞌihegwaeya ꞌigwae, “Loheyaina moisa ꞌuhemisaeya?” ");
INSERT INTO bdd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma loheyaina ꞌigwae, “Cinapwana, taiya ꞌabehega yahemisaeya?” ");
INSERT INTO bdd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Coinega Yesu wete ꞌihegwae hileya ꞌigwae, “Loheyainaina ꞌuꞌita pwaiya ta tauna bewa tuwa maheteu wahehegwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Coinega loheyaina ꞌigwae, “Cinapwana, ꞌabwa hesi yahemisaegowa,” eeta ꞌiꞌetuluha Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Muliyetega Yesu ꞌigwae, “Taugu yatauya pwaima baleꞌuwa ma yaloinaegomi ma ꞌoinega taiyawedi ꞌomi mata gibugibuimi, matami sibwebweꞌana hila. Ma hesi taudi sigwaeya ꞌabehega matadi bwebweꞌana, nata matadi sigibu.” ");
INSERT INTO bdd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta Palisiyedi Yesu deina sitotoholo ꞌina gwaeina sihesagoheya ma sigwae, “Togidega ma tauma ꞌabehega wete mata gibugibuima, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma Yesu ꞌihegwaediya ꞌigwae, “Comi ꞌeguma mata gibugibuimi, geyaꞌabwa ꞌimi mumuga galadi. Ma hesi wagwaeya ꞌabehega matami bwebweꞌadi, ꞌoinega ꞌimi mumuga galadiyedi ꞌabwa tuwa simiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu wete ꞌihegwaediya ꞌigwae, “Yagwae moisa ꞌoimiya, taiyawedi ꞌeguma sipi ꞌadi ꞌali ꞌana ꞌahwaꞌeda geya ꞌoinega siluhu, ma sinao hali tupwega siluhu, taudi sanidi toyagaha. ");
INSERT INTO bdd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma hesi taiya ꞌeguma sipi ꞌidi ꞌahwaꞌeda moisa ꞌoinega ꞌiluhu, tauna sipi ꞌadi toꞌitayahina. ");
INSERT INTO bdd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Weyahina ꞌidi ꞌahwaꞌedaina ꞌana toꞌitayahina ꞌahwaꞌedaina ꞌisoꞌe. Cisoꞌeya ma sipi ꞌadi toꞌitayahinaina ꞌiluhu ma ꞌina sipiyedi ꞌaigeda ꞌaigeda sanidi ꞌoidiyega ꞌibwaubwauwedi. Cibwauwedi ma ꞌenana sihesagohe, ma ꞌinugetedi, silatulatu ꞌatamana. ");
INSERT INTO bdd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Silatu mabwaiyadi ma ꞌadi toꞌitayahinaina ꞌinugenugeta ma taudi simulimuliyaya. Weyahina ꞌadi toniina ꞌenana sisanasanapu ma wete simanasameya. ");
INSERT INTO bdd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipiyedi geya sowasowahina ma ꞌeta taiya hagahagana sihemuli tabubu, ma hesi nata hali loheya ꞌoidiyega sidena. Weyahina hali loheya ꞌenadi geya sisanapu ma wete geya simanasamedi.” ");
INSERT INTO bdd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu gwae hegehegedi bewa ꞌoidiya ꞌiꞌinaneya, ma hesi taudi tuwa geya ꞌoidiya ꞌimaedana tohona toꞌaha weyahina ꞌihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Coinega Yesu wete ꞌihegwae hilediya ꞌigwae, “Yagwae moisa ꞌoimiya, taugu sipi ꞌidi ꞌahwaꞌeda moisa. ");
INSERT INTO bdd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Toꞌitayahinedi mwalona sinugetama taudi toyagaha, ꞌoinega ꞌenadi sipiyedi geya sihesagohedi.” ");
INSERT INTO bdd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Coinega wete ꞌihegwae hilediya ꞌigwae, “Taugu tuwa bewa sipiyedi ꞌidi ꞌahwaꞌedaina. Coinega taiyawedi ꞌomi ꞌeguma ꞌoiguwega waluhu, nata bwebweꞌana waloba. Weyahina sauga ꞌaigeda ꞌaigeda nata ꞌoidiya ꞌoiguwega waluhuluhu ma wete ꞌoiguwega walatulatu ma modumodu bwebweꞌana ꞌoidiya waꞌaiꞌai. ");
INSERT INTO bdd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ma hesi toyagaha ꞌidi paihowa beno nata sitauyama siyagaha ma siloheꞌamasa, ma wete sipi siꞌabi hegaladi. Taugu hesiyage yatauyama ma ꞌoinega ꞌoiguwega tomota yawasidi bwebweꞌana ma mahamahana siloba.” ");
INSERT INTO bdd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Coinega wete ꞌihegwae hilediya ꞌigwae, “Taugu moisa sipi ꞌadi toꞌitayahina bwebweꞌagu, weyahina yawasigu yatagwaleya ma ꞌabehega ꞌigu sipi weyahidi yaꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma hesiyage taiya ꞌeguma geya sipi ꞌadi toꞌitayahina moisa ma maisamo weyahina ꞌipaipaihowa, tutaina ꞌeguma ꞌedewa sasasasaina ꞌiꞌita ꞌitautauyama, nata sipiyedi ꞌiꞌebesinedi ma ꞌidena. Cabwa hesi ꞌedewaina sasasasaina ꞌinaoma ma sipi tupwadi ꞌiloheꞌamasidi ma mabwaiyadi ꞌipaꞌi lelewanedi. ");
INSERT INTO bdd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Loheyaina bewa gidemusa nata ꞌidena weyahina tauna tuwa maisamo weyahina ꞌipaipaihowa, tauna geya sipiyedi weyahidi ꞌinuwatuhu.” ");
INSERT INTO bdd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Coinega wete ꞌihegwaediya ꞌigwae, “Ma taugu hesi sipi ꞌadi toꞌitayahina bwebweꞌagu, weyahina ꞌigu sipiyao mabwaiyadi yasanasanapudi ma wete taudi sisanasanapugau. ");
INSERT INTO bdd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Gidemusa tuwa, Tamagu ꞌisanasanapugau ma wete taugu Tamagu yasanasanapu. Eema yawasigu yatagwaleya ma ꞌigu sipi weyahidi yaꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cigu sipi tupwadi wete simiyamiya taudi tuta bewa ꞌoina geya ꞌigu ꞌali ꞌalona simiyamiya. Ma hesi yatohotoho ma sipidiyedi yatoedima, ma ꞌoinega ꞌenagu sihesagohe ma ꞌoiguwa sinaoma maꞌiyadiyao siheboda ꞌaigeda, ma wete ꞌaneyage ꞌadi toꞌitayahina ꞌaigeda tuwa. ");
INSERT INTO bdd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamaguina tauna ꞌihelauwegauwa madouna, weyahina yawasigu yatagwaleya ma yaꞌamasa ꞌabwa muliyetega yawasigu yaꞌewahila. ");
INSERT INTO bdd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Cigu ꞌamasaina geya ꞌeta taiya ꞌiloinaegau ma yaꞌamasa, yaboi tuwa yatagwalegauwa ma yaꞌamasa. Sowasowahigu yatagwalegau yaꞌamasa, ma weteyage sowasowahigu yawasigu yaꞌewa hila, weyahina Tamagu bewa gide ꞌina nuwatuhu ta wete ꞌina loina ꞌoiguwa.” ");
INSERT INTO bdd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu ꞌina gwaeyedi weyahidi meYudiya siboidimo siheꞌoheꞌohena madouna, ꞌoinega ꞌoidiya wataha ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nage ꞌoina tomota baibaiwa hedade sigwae, “Loheya beno hiꞌahiꞌa ꞌoina ꞌimiyamiya, ꞌoinega ꞌiꞌabiꞌabi heyauyaule. Sahena ꞌina gwae wahehesagohedi.” ");
INSERT INTO bdd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma hesiyage tomota tupwadi sigwae, “Ciya, bewa geya gidemusa hiꞌahiꞌa ꞌina gwae. Weyahina yaluyaluwa biꞌi geya sowasowahina tomata gibugibu bewa gidemusa ꞌiꞌabi hebwebweꞌana ꞌese.” ");
INSERT INTO bdd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gogagogai ꞌana tuta ꞌoina guyai ꞌaigeda Yelusalema ꞌoina sipaihoweya, beno meYudiya ꞌidi ꞌebe nuwatuhuyahina weyahina beno Hada Heꞌasisi siꞌabi hemaedana hileya ma sibwaꞌa heꞌasisiyane Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Guyainaina ꞌoina Yesu Hada Heꞌasisi ꞌoina ꞌiyawala dadana ꞌaigeda biliupa ꞌoina. Biliupainaina sibwauweya Kini Solomoni ꞌina biliupa. ");
INSERT INTO bdd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nage ꞌoina meYudiya Yesu sihaꞌwabuꞌwabuya ma sihegwaeya sigwae, “Tuta mabwaiyana ꞌoidiya ꞌowa ꞌima nuwatuhu ꞌuhehe lahalahadi. Ma to tuta ꞌoina ꞌabwa ꞌoima ꞌuhepwaila bwaibwaina, ꞌowa moisa Toꞌabihetenaina bo geya?” ");
INSERT INTO bdd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma Yesu ꞌihegwaediya ꞌigwae, “Coimiya yahepwaila pwaiya ma geya wahemisaegau. Ma wete paihowaedi Tamagu saninega yapaipaihowadi ta ꞌoidiyega wete sihepwaila pwaigauwa, ");
INSERT INTO bdd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ma hesiyage geya wahemisa tohogau, weyahina ꞌomi geya ꞌigu sipiyao moisa. ");
INSERT INTO bdd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Weyahina taugu ꞌigu sipiyao ꞌenagu sisanasanapu, ma wete taugu yasanasanapudi eema simulimuliyegau. ");
INSERT INTO bdd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma wete ꞌigu sipiyedi yawasidi miyamiya hatayana yaꞌebwaediya ma ꞌoinega geyaꞌabwa sigalagala. Ma wete taudi nata geyaꞌabwa ꞌeta taiya nimaguwega ꞌiꞌwayeꞌwayegau. ");
INSERT INTO bdd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sipiyedi Tamagu tauna ꞌiꞌebwaegauwa, ꞌoinega geya ꞌeta taiya sowasowahina ma Tamagu nimanega ꞌiꞌwaya. Weyahina tauna ginaula mabwaiyana ꞌihemadou sinediya. ");
INSERT INTO bdd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taugu ma Tamagu ꞌaigeda tuwa.” ");
INSERT INTO bdd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Coinega meYudiyaedi daꞌule wete siꞌewediya ma ꞌabehega Yesu siꞌahu heꞌamasi, ");
INSERT INTO bdd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ma Yesuina ꞌiꞌitediya ma ꞌihegwaediya ꞌigwae, “Paihowa bwebweꞌadi ma wete baibaiwadi Tamagu ꞌoinega yapaihowediya ꞌoimiya ma waꞌitediya, ma to paihowa hede weyahina nuwanuwami ma ꞌabehega daꞌuleyega waloheꞌamasigau?” ");
INSERT INTO bdd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Coinega meYudiyaedi Yesu ꞌenana sihemaiseya sigwae, “Geya ꞌabehega ꞌino paihowa bwebweꞌadi weyahidi ꞌahunugo, ma hesiyage ꞌino gwae hohopaꞌala weyahidi ꞌahunugo. Weyahina ꞌowa tuwa loheya masiha ma ꞌugwaeya ꞌabehega ꞌowa tuwa Yehobaina.” ");
INSERT INTO bdd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Coinega Yesu wete ꞌihegwae hilediya ꞌigwae, “Cima loina ꞌoidiya Buki Heꞌasisi ꞌoina silele pwaiya Yehoba ꞌina gwae ꞌabehega, ‘Comi tuwa yehobaedi.’ ");
INSERT INTO bdd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma moisa tuwa Yehoba ꞌina hepwailaina ꞌina Buki Heꞌasisi ꞌoidiya mabwaiyana geya ꞌida ꞌabowa. Ma bukinaina ꞌoina ꞌihepwaila ꞌabehega tomotaedi taudi Yehoba ꞌina gwae ꞌiꞌebwaediya, ma ꞌiꞌahwa yehobaediya. ");
INSERT INTO bdd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Coinega toꞌaha weyahina ꞌigu gwae wanuwatuhuya ꞌabehega gwae hohopaꞌala tutaina yagwaeya ꞌabehega taugu Yehoba natuna? Ma hesi waꞌita, taugu ꞌihesinuwanegauwa ma ꞌihesumanegauma ma yatauyama baleꞌuwa ma ꞌina paihowa yapaipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Coinega ꞌeguma taugu geya Tamagu ꞌina paihowa yada paihowediya, sahena wete wahehemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma ꞌeguma taugu moisa Tamagu ꞌina paihowa yapaipaihowadi, ma geya wahemisaegau, tuwa hede paihowaedi wahemisaedi, ꞌabwa hesi ꞌigu paihowaedi ꞌoidiyega wasanapu bwaibwainigau ꞌabehega taugu moisa Tamagu ꞌoiguwa ꞌimiyamiya ma wete taugu Tamagu ꞌoina yamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nage ꞌoina meYudiyaedi wete sitohoya ma ꞌabehega siꞌabiyahi, ma hesi nimadiyega ꞌilatuwa ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ciꞌebesinediya ma ꞌihabala hila Yolidani weꞌahina ꞌoina, beno Yoni ꞌina ꞌebe hebabitaiso nugenugetana deina, ma ꞌoina nobwa ꞌiloꞌasa. ");
INSERT INTO bdd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nage ꞌoina boda siꞌautama ꞌoina ma siboidimo ꞌoidiya sihegwaegwaeya sigwae, “Yoni moisa geya ꞌeta paihowa waiwaina ꞌipaihowadi, ma hesiyage ꞌina hepwaila loheya bewa weyahina ꞌana moisa ꞌilatu pwaima, ta wete taꞌahwa moisaeya.” ");
INSERT INTO bdd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Casainaina ꞌoina tomota baibaiwadi Yesu sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Loheya ꞌaigeda lolohalaina sanina Lasalo, Bedani loheyaina. Loheyainaina nuhunao siteluwa mahetenao simiyamiya, ꞌaigeda sanina Meli ma ꞌaigeda sanina Malida. ");
INSERT INTO bdd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meliina tauna ꞌabwa nata Yesu ꞌahena ꞌiheholoi ma wete debanega Yesuina ꞌahena ꞌilogogosi. ");
INSERT INTO bdd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Coinega tutaina nuhudiuina Lasalo ꞌilohala taudi tuwa nuhunaowedi wasa sitauyeya Yesu ꞌoina sigwae, “Cinapwana, ꞌiyauina Lasalo ꞌilohala.” ");
INSERT INTO bdd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nage ꞌoina Yesu Lasalo wasana ꞌihesagoheya ꞌoinega tomota ꞌihegwaediya ꞌigwae, “Lohalaina beno ꞌana sanapu nata geyaꞌabwa yawasina ꞌigumwagumwala. Ma hesi lohala nage ꞌoina ꞌilatuwa ma ꞌoinega tomota mabwaiyadi Yehoba sihepwatuwe ma wete natunaina sihepwatuwe.” ");
INSERT INTO bdd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu Malida matasina ma wete nuhudiuina Lasalo ꞌihelauwediya madouna. ");
INSERT INTO bdd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eeta tutaina Lasalo wasana ꞌihesagoheya ꞌasainaina ꞌoina ꞌimiyamiya, ꞌoina sabwelo ꞌeluwa ꞌimiya hila. ");
INSERT INTO bdd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sabwelowedi ꞌeluwa sigumwala ma ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Bewa tuwa talohihila Yudiya.” ");
INSERT INTO bdd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Coinega ꞌana tomuliyaedi sihegwaeya sigwae, “Cinapwana, sahena tatautauya ꞌasainaina ꞌoina. Weyahina ꞌeguma tatauya, nata meYudiya daꞌuleyega siꞌahu heꞌamasigo.” ");
INSERT INTO bdd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Coinega Yesu ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Sabwelo ꞌana mabwaiyana beno gonagona ꞌoinega ma ꞌitauya ꞌana siga lahilahi. Sabweloina ꞌoina ꞌeguma ꞌeta taiya loheya ꞌitauya, nata geyaꞌabwa ꞌihehetupatupa. Weyahina gogo gabulena ꞌana maedana ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma hesi ꞌeguma ꞌeta loheya nihuwanega ꞌitauya, nata ꞌihetupa deyadeya. Weyahina nihuwana ꞌoina geya ꞌeta wete heꞌala hemaedana ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gwaeyedi ꞌiꞌinanediya ma wete ꞌoidiya ꞌigwaeya, “Ciyadaina Lasalo ꞌiꞌeno sineya, ꞌoinega yatauya ma yahano.” ");
INSERT INTO bdd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Coinega ꞌana tomuliyaedi sigwae, “Cinapwana, ꞌeguma moisa ꞌiꞌeno sineya, nata moisa ꞌana lohalaina ꞌoinega ꞌibwebweꞌana hila.” ");
INSERT INTO bdd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Weyahina tomuliyaedi ꞌidi nuwatuhu ꞌabehega Lasalo moisa ꞌiꞌeno sineya Yesu weyahina ꞌihehegwaegwae. Ma hesi Yesu ꞌina gwae ꞌana sanapu ꞌabehega Lasalo moisa yawasina ꞌigumwala pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Coinega Yesu ꞌigwae latu bwaibwaina ꞌoidiya ꞌigwae, “Lasalo yawasina ꞌigumwala pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma hesiyage maꞌigu yaliyaya, weyahina ꞌina ꞌamasaina geya ꞌoina yamiyamiya ma ꞌoinega ꞌigu paihowa waiwaina waꞌita ma wahemisaegau. Ma tuwa wete bwebweꞌana, ma hana tuwa tatauya ma taꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Coinega Tomasi tauna sibwauweya Didiluwaluwa ꞌiyanaowedi ꞌihegwaediya ꞌigwae, “Cida toheꞌita tuwa mahetedai tatauya, ꞌeguma ꞌiꞌamasa, tauda wete taꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Coinega tutaina Yesu Bedani deina ꞌilatuwa ma wasa ꞌihesagoheya ꞌabehega sabwelo ꞌehata sigumwala ꞌoidiya Lasalo sigaliheya. ");
INSERT INTO bdd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bedani beno geya bwaga Yelusalema ꞌoinega, ");
INSERT INTO bdd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","eeta meYudiya baibaiwadi maꞌidi ꞌate muyamuya sitauyama Malida ma Meli ꞌabehega nuwadi siꞌabi hebwebweꞌanidi. ");
INSERT INTO bdd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sauga nage ꞌoina Malida Yesu wasana ꞌihesagoheya ꞌabehega ꞌitauyama, ꞌoinega ꞌiboinamo ꞌilatuwa ꞌedai Yesu sabi helatuina. Ma Meli beno hadai ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malidaina Yesu ꞌilobeya ma ꞌihegwaeya ꞌigwae, “Cinapwana, ꞌowa ꞌeguma ꞌebwa ꞌuda miyamiyana, nuhugu geyaꞌabwa yawasina ꞌida gumwagumwala. ");
INSERT INTO bdd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma hesiyage yasanapuya ꞌabehega ꞌeguma toꞌaha weyahina Yehoba ꞌoina ꞌuꞌahwanoi nata tuwa ꞌino ꞌahwanoiina maisana ꞌiꞌebwaego.” ");
INSERT INTO bdd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Coinega Yesu Malida ꞌihegwaeya ꞌigwae, “Nuhuina nata ꞌitoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Coinega wahineina ꞌigwae, “Cehe, yasanapuya nata moisa tuta ꞌana ꞌebe losaloha ꞌoina galihega ꞌitoholo hila.” ");
INSERT INTO bdd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Coinega Yesu wahineina wete ꞌihegwae hileya ꞌigwae, “Taugu moisa toholo hila huhuna ma wete yawasi moisa. Ma taiyawedi ꞌeguma sihemisaegau, tutaina ꞌeguma yawasidi ꞌigumwala, yawasi miyamiya hatayana siloba. ");
INSERT INTO bdd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma taiyawedi ꞌeguma mayawasidi ma sihemisaegau, nata geyaꞌabwa yawasidi ꞌigumwagumwala. Coinega togidega ꞌigu gwae bewa ꞌoiuwa, ꞌuhemisaegauwa bo geya?” ");
INSERT INTO bdd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta Malida ꞌigwae, “Cinapwana, yahemisaegowa ꞌabehega ꞌowa Toꞌabihetenaina, Yehoba natuna, gogo gabulena bewa ꞌoina ꞌutauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Malida ꞌina gwae mulina ꞌilohihila hadai ma tasinaina Meli ꞌihegwae gahuya ꞌigwae, “Ciyagu, Toheꞌitaina ꞌilatuma ma ꞌihesilalegowa.” ");
INSERT INTO bdd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nage ꞌoina Meli tasina ꞌenana ꞌihesagoheya ꞌoinega ꞌisiwa toholo mwayamwayauwa ma ꞌitauya Yesu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma hesiyage Yesu ꞌabwa geya ꞌasainaina ꞌoina ꞌiluhuma, ꞌabwa tuwa tupwaina Malida ꞌoina ꞌilobeya ꞌoina ꞌitotoholo. ");
INSERT INTO bdd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sauga nage ꞌoina meYudiyaedi taudi Meli mahetediu sihehedoudouwa Meliina ꞌina tauya ꞌoina siꞌiteya, ma ꞌidi nuwatuhu ꞌabehega ꞌitautauya galiha ꞌidou, ꞌoinega sihemuli tabubuya mahetediu sitauya. ");
INSERT INTO bdd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Coinega tutaina Meli Yesu ꞌoina ꞌilatuwa ꞌahena ꞌituluha ma ꞌiheꞌasisiyaneya, ma ꞌigwaeya, ꞌigwae, “Cinapwana, ꞌowa ꞌeguma ꞌebwalai ꞌebwa ꞌuda miyamiya geyaꞌabwa wete nuhuguina yawasina ꞌida gumwagumwala.” ");
INSERT INTO bdd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu nage ꞌoina ꞌiꞌiteya Meli ma meYudiyaedi mahetenao sitauyama sidoudou. Cidi douwega Yesu wete ꞌatena ꞌimuyamuya ma nuwana ꞌigala madouna. ");
INSERT INTO bdd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma ꞌihegwaediya ꞌigwae, “Mane ꞌoina ꞌana galihina?” Ma taudi sigwae, “Cinapwana, ꞌunaoma tatauya ma ꞌaheꞌitago.” ");
INSERT INTO bdd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ta Yesu wete ꞌidouwa. ");
INSERT INTO bdd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Coinega meYudiyaedi Yesu siꞌiteya ma sigwaeya, “Ciyanaina moisa ꞌihelauweya madouna.” ");
INSERT INTO bdd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta ꞌoidiyega tupwadi sigwae, “Tauna tuwa Yesuina mwalona tomata gibugibu ꞌiꞌabihe bwebweꞌaniya. Ma toꞌaha weyahina geya ꞌitauyama ma ꞌiyanaina bewa ꞌilemema geyaꞌabwa yawasina ꞌigumwagumwala?” ");
INSERT INTO bdd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Beno ꞌoina Yesu tuwa maꞌina nuwagala madouna ma galihina ꞌoina ꞌilatuwa. Galihina duluha, ꞌoinega ꞌahwanaina daꞌule tabatabana ꞌoinega silagu ꞌausiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ta Yesu boda ꞌihegwaediya ꞌigwae, “Daꞌuleina nage galihina ꞌoinega waꞌewa yahule.” Coinega Malida tauna tuwa loheyaina yawasina ꞌigumwagumwala nuhuna Yesu ꞌenana ꞌihemaiseya ꞌigwae, “Cinapwana, tuta bewa ꞌoina ꞌimwahulu pwaiya. Weyahina ꞌebwalai heneyage ꞌahemiya taona pwaiya ta nige bewa sabwelo hehatana ꞌilobeya.” ");
INSERT INTO bdd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Yesu Malida ꞌihegwaeya ꞌigwae, “Mwalona yahegwae pwaigowa, ꞌeguma moisa ꞌuhemisaegauwa, nata Yehoba ꞌina waiwai ꞌuꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Coinega daꞌuleina sibui wasiyeya, ma Yesu ꞌiꞌita haneya galewa, ma ꞌiꞌahwanoiya ꞌigwae, “Tamagu yauwedo, weyahina ꞌowa ꞌenagu ꞌana tohesagoha. ");
INSERT INTO bdd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yasanapuya ꞌowa moisa ꞌenagu ꞌana tohesagoha bwaibwaina, ꞌoinega ꞌigu ꞌahwanoi bewa ꞌoiuwa ꞌuda hesagohe ma ꞌoinega ꞌino waiwai tomotaedi bewa siꞌita ma sihemisa ꞌabehega ꞌowa moisa ꞌuhesumanegauma.” ");
INSERT INTO bdd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu ꞌina ꞌahwanoi mulina ꞌenana madouna ꞌoinega ꞌibwauwa ꞌigwae, “Lasalo, ꞌulatuma!” ");
INSERT INTO bdd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nage ꞌoina Lasalo galihega maꞌana wadu ꞌilatuma. Weyahina nimana ma ꞌahena ma wete manina ꞌaleꞌo ꞌoidiyega siwaduhidiya. Ta Yesu boda ꞌihegwaediya ꞌigwae, “Cana waduhedi walihasidi ma ꞌitauya.” ");
INSERT INTO bdd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nage ꞌoina meYudiyaedi taudi Meli ꞌana tohaboꞌenedi Yesu ꞌina paihowa siꞌiteya ma ꞌoinega sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma hesiyage tupwadi geya sihemisae, ꞌoinega Palisiyao ꞌoidiya silohihila sihepwaila toꞌaha gide ꞌidi ꞌita Yesu ꞌina paihowa weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Coinega Palisiyaowedi ma wete topwaoli ꞌidi ꞌinapwanao simiya ꞌauta, ma sihegwaegwaeya sigwae, “Toꞌaha loheyaina ꞌoina tapaihowa? Weyahina bewa tuwa ginaula waiwaidi ꞌipaipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma ꞌeguma geyaꞌabwa toꞌaha ꞌoina tapaipaihowa, nata tomota mabwaiyadi ꞌilisidi, ꞌabwa hesi meLoma ꞌidi loina mwauna ꞌoida ꞌilatu, ma ꞌida Yehoba ꞌina hada ma wete ꞌida boda mabwaiyadi siꞌabi hegaladi.” ");
INSERT INTO bdd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Coidiyega loheya ꞌaigeda sanina Kaiyapa, tauna bolime nage ꞌoina topwaoli ꞌidi ꞌinapwana madouna. Ciyanaowedi ꞌihegwaediya ꞌigwae, “Comi hede nuwa potapotaimi? ");
INSERT INTO bdd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma hesi waꞌita! Ceguma loheya ꞌaigeda tuwa ꞌiꞌamasa mabwaiyada weyahida, beno bwebweꞌana. Ma hesi geya ꞌana ꞌita bwebweꞌana ꞌeguma meLoma sitauyama ma ꞌida boda mabwaiyana Yudiya ꞌoina siꞌabi hegaladi.” ");
INSERT INTO bdd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiyapaina gwae bewa ꞌiꞌinaneya geya tauna ꞌina nuwatuhuwega, ma hesi bolimeina beno ꞌoina tauna topwaoliyedi mabwaiyadi ꞌidi ꞌinapwana madouna. Coinega tuta beno ꞌoina ꞌipalopisai ꞌabehega tuta muliya ꞌoina, nata Yesu ꞌiꞌamasa meYudiya mabwaiyadi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma geya ꞌabehega meYudiya siboidimo weyahidi, ma hesi Yehoba ꞌina tomotaiyao mabwaiyadi gogo gabulena ꞌoina simiyamiya, ꞌihemiya ꞌautedi boda ꞌaigeda tuwa ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sauga nage ꞌoina toloinaedi ꞌidi loina silaguya ma ꞌabehega Yesu siloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nage ꞌoina Yesu meYudiyaedi geya matadiya ꞌida haꞌataꞌatamana, ꞌoinega ꞌiꞌebesinediya ma ꞌitauya ꞌasa ꞌaigeda madouna ꞌoina sanina Epileimi, yoho ꞌawawa deina, ma nobwa maꞌana tomuliyaedi ꞌoina simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sauga nage ꞌoina meYudiyaedi ꞌidi Hataona Guyaina ꞌana sauga ꞌilobeya, ꞌoinega tomota baibaiwadi ꞌidi ꞌasa ꞌoidiyega sihanema Yelusalema ꞌoina sabi ꞌabiꞌehau hiladi ꞌabwa muliyetega ꞌidi Guyaiina sipaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nage ꞌoina Yesu siꞌebeseya, ꞌidi ꞌebesaina ꞌoina Hada Heꞌasisi deina sitotoholo ma sihehegwaegwae sigwae, “Togidega, loheyaina nata gesowana ꞌitauyama guyai bewa ꞌoina, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tomota ꞌidi gwae bewa gide, weyahina ꞌidi babadao ꞌidi loina paꞌalina silaguya, beno topwaoliyedi ꞌidi ꞌinapwanao ma wete Palisiyedi siloinaediya ꞌabehega ꞌeguma to tupwa ꞌoina Yesu siloba, mwayamwayau babadaowedi ꞌoidiya sihepwaila ma siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sabwelo sikisi simiyamiya ma Hataona Guyaina sipaihowa, ma Yesu ꞌitauya Bedani, beno Lasalo ꞌina ꞌasa ꞌoina. Lasalo tauna mwalona Yesu ꞌamasa ꞌoinega ꞌiꞌabi hetoholo hileya. ");
INSERT INTO bdd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu ꞌitauya ꞌasainaina ꞌoina ma nobwa ꞌana sipaihowa. Malida tauna ꞌadi ꞌipaipaihowa, ma Yesuina maꞌina bodao ma Lasalo siꞌaiꞌai. ");
INSERT INTO bdd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Muliyetega Meli holowa ꞌaigeda bwebweꞌana sanina nadi ma wete ꞌana maisa madouna, ꞌiꞌeweyama Yesu ꞌahena ꞌiheholoiya ma wete Meliina debanega Yesuina ꞌahena ꞌisaudiya. Holowainaina mahaina madou hedadena ꞌoinega mahainega hada ꞌalona mabwaiyana ꞌimiya hegagaleya. ");
INSERT INTO bdd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ta ꞌoinega Yudasa Isakaliyota, tauna tuwa Yesu ꞌana tomuliya ꞌaigeda ma wete tauna tuwa loheyainaina ꞌabwa nata Yesu ꞌiheꞌebwayae, ꞌilomugiya ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Toꞌaha weyahina holowa nage geya ꞌihegimwaneya ma ꞌana maisa gide teli handeledi kina ꞌiꞌewa ma wewelohe ꞌoidiya ꞌiheguyai?” ");
INSERT INTO bdd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasa ꞌina gwae geya ꞌabehega moisa wewelohe weyahidi ꞌihehegwaegwae, ma hesi tauna tuwa weyahina ꞌihehegwaegwae. Tauna tuwa toyagaha ꞌaigeda ma Yesu ꞌana tomuliyao ꞌidi mane ꞌana toꞌita yahina tauna. Coinega ꞌidi maneina ꞌiꞌitaꞌita yahi ma maneinaina ꞌoinega ꞌiyagayagaha. ");
INSERT INTO bdd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma Yesu Yudasa ꞌihegwaeya, “Tuwa ꞌulolagu, sahena wete toꞌaha ꞌoina ꞌugwaegwaene. Toꞌaha gide ꞌoiguwa ꞌipaihoweya, beno tuwa ꞌagu hemiya taona weyahina. ");
INSERT INTO bdd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta ꞌowa nige wewelohe weyahidi ꞌuhehegwaegwae, taudi tuta mabwaiyana ꞌoidiya mahetemiyao wamiyamiya. Ma hesi taugu nata geyaꞌabwa tuta saliyana ꞌoimiya yamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ma meYudiya boda madouna Yesu wasana sihesagoheya ꞌabehega Bedani ꞌoina ꞌimiyamiya, ꞌoinega ꞌasainaina ꞌoina sitauya. Nuwanuwadi Yesu ma Lasalo siꞌitadi, Lasaloina tauna mwalona ꞌamasega Yesu ꞌiꞌabi hetoholo hileya. ");
INSERT INTO bdd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Coinega topwaoliyao ꞌidi ꞌinapwanao Lasalo weyahina sihetala gwaeya ma ꞌabehega siloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Weyahina meYudiya baibaiwadi Lasalo siꞌiteya ma ꞌadi tohanugetaowedi ꞌoidiyega sihawahawasi ma Yesu simulimuliye. ");
INSERT INTO bdd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hali sabwelowa boda madouna taudi sitauyama Yelusalema Hataona Guyaina weyahina Yesu wasana sihesagoheya ꞌabehega ꞌabwa nata Yesu Yelusalema ꞌoina ꞌiluhuma. ");
INSERT INTO bdd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Coinega tomotaedi sadasada lahwaina siꞌewediya ma silatuwa ꞌedai Yesu sabi lobaina. Cedaina ꞌoina sitotoholo ma ꞌenadi madouna ꞌoidiyega sibwaubwau sigwae, “Yauwedo Cinapwana, Yehoba saninega ꞌutauyama, ma ꞌuhetoloina madouna ꞌima ꞌasa Isileli ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesuina hebai ꞌaigeda sanina ꞌase ꞌoina ꞌigeluwa ma ꞌiluhuluhu Yelusalema. Tuwa gide toꞌaha Buki Heꞌasisi ꞌoina ꞌihepwaila, gide wete ꞌilatu ꞌesa, tutaina ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“MeSaiyoni, sahena wamatamatauta, bewa tuwa ꞌimi kini ꞌoimiya ꞌiluhuluhuwa. Tauna ꞌase hauhauna ꞌoina ꞌigeluwa.” ");
INSERT INTO bdd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sauga nage ꞌoina tomuliyaedi gwae bewa sihesagoheya ma hesi geya ꞌoidiya ꞌimaedana. Yesu ꞌina ꞌamasa ꞌoinega ma ꞌina toholo hila ꞌoina ꞌabwa hesi Yehobaina ꞌina gwaeina Buki Heꞌasisi ꞌoina sinuwatuhu yahiya ma sisanapuya toꞌaha gide tomota ꞌidi paihowa Yesu ꞌoina, gwaeina ꞌana moisa ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma bodaedi taudi matadiya Yesu Lasalo galihega ꞌibwauweya ma ꞌamasega ꞌiꞌabi hetoholo hileya, taudi sitauya ꞌiyadiyao ꞌoidiya ma Lasalo ꞌina toholo hila wasana sihepwaila dadaneya. ");
INSERT INTO bdd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nage ꞌoina meYudiya baibaiwadi Yesu ꞌina paihowa waiwaina wasana sihesagoheya, ꞌoinega sitauya Yesu ꞌina tauyama ꞌana sauga ꞌoina ma ꞌabehega ꞌina luhu Yelusalema ꞌoina sihelatu. ");
INSERT INTO bdd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Beno ꞌoina Palisiyao siboidimo ꞌoidiya sigwae, “Moisa tuwa, ꞌida waiwai ꞌigumwala. Weyahina tomota mabwaiyadi Yesu ꞌina boda ꞌoina sitautauya.” ");
INSERT INTO bdd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tuta nage ꞌoina meGilisi tupwadi bodaedi soladiya simiyamiya. Taudi tuwa totapwalolo ꞌidi ꞌasega siliya hanema Yelusalema ꞌoina sabi tapwalolo, Hataona Guyaina ꞌana tuta ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","MeGilisiyedi sitauyama Pilipi ꞌoina, ma sihesilala, sigwaeya, “Cinapwana, nuwanuwama Yesu ꞌaꞌita.” Pilipiina tauna Bedeseida loheyaina, beno Galili ꞌina tupwa ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Coinega Pilipi ꞌitoholowa ma ꞌitauya Andulu ꞌihegwaeya, ma siteluwaedi sitauya Yesu ꞌoina, ma meGilisiyedi ꞌidi nuwatuhuina sihepwaileya ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Coinega meGilisiyedi ꞌenadi Yesu ꞌihemaiseya, ꞌigwae, “Bewa tuwa tuta ꞌilatu pwaima ma taugu Loheyaiguina ꞌagu hepwatu yaloba. ");
INSERT INTO bdd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Coinega bewa tuwa yahegwae bwaibwainigomi, ꞌeguma hewana baleꞌu ꞌoina wadauni, ꞌitalasawala ma solanega nata ꞌisiwa ꞌeꞌenina madouna ma bwebweꞌana taloba. Weyahina hewana ꞌeguma geyaꞌabwa baleꞌu ꞌoina tadaudauni, ma ꞌitalasawala, nata geyaꞌabwa wete ꞌeꞌenina bwebweꞌana talobaloba. ");
INSERT INTO bdd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Coinega ꞌeda ꞌaigedanaina wete gide, ꞌeguma taiya baleꞌu ꞌoina yawasina ꞌihelauwe baleꞌu ꞌana miya weyahina, nata yawasina bwebweꞌana geyaꞌabwa ꞌilobaloba. Ma hesi taiya ꞌeguma baleꞌu ꞌoina yawasina ꞌitagwale, nata tauna moisa tuta ꞌinaonaoma ꞌoidiya yawasi hataya ꞌiloba. ");
INSERT INTO bdd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Coinega taiyawedi ꞌomi ꞌeguma nuwanuwami ma ꞌoiguwa wahetopaihowa, ꞌomi wamuliyegau. Ma to ꞌasa ꞌoina yamiyamiya, ꞌomi wete ꞌasainaina ꞌoina wamiyamiya. Ma taiya ꞌeguma wete weyahigu wahetopaihowa, nata ꞌomi Tamagu ꞌiꞌahwa bwebweꞌanegomi.” ");
INSERT INTO bdd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu wete ꞌigwaeya, “Tuta nage ꞌoina nuwagu ꞌigala hedadeya ꞌoinega togidega nata Tamagu ꞌoina yaꞌahwanoi ꞌesa? Nuwana bewa gidemusa ꞌoina yaꞌahwanoi ꞌesa ma ꞌabehega mwau bewa ꞌoinega ꞌilemegau. Ma geyaꞌabwa bewa gide yaꞌahwaꞌahwanoi ꞌesa. Weyahina mwau bewa tauna weyahina yatauyama. ");
INSERT INTO bdd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ma hesiyage bewa gidemusa yaꞌahwanoi ꞌesa, yagwae, ‘Tamagu, saniu ꞌuꞌabi hanehe.’” Nage ꞌoina ꞌenana ꞌaigeda galewega ꞌigwae, “Sanigu yaꞌabi hanehe pwaiya, ma ꞌabwa nata wete yaꞌabi hanehe hila.” ");
INSERT INTO bdd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tuta nage ꞌoina bodaedi sitotoholowa ꞌenana nage sihesagoheya, ꞌoinega siboidimo ꞌoidiya sigwae, “Tutu ꞌitutututu.” Ma hesi tupwadi sigwae, “Geya, Yehoba ꞌina anelose ꞌaigeda ꞌihehegwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Yesu bodaedi ꞌihegwaediya ꞌigwae, “Cenanaina nige wahesagoheya geya taugu weyahigu, ma hesi ꞌomi weyahimi. ");
INSERT INTO bdd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Eeta tuta ꞌilatu pwaima ma Yehoba gogo gabulena ꞌana tomiyao ꞌiloinaedi, ma wete togala ꞌadi toloina gogo gabulena bewa ꞌoinega ꞌipaꞌi. ");
INSERT INTO bdd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma hesi taugu ꞌeguma baleꞌuwega siꞌabi hanehegau ꞌaiwe ꞌoina, nata tomota mabwaiyadi yalisidima ma sinaoma ꞌoiguwa.” ");
INSERT INTO bdd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu ꞌina ꞌamasa weyahina bewa gidemusa ꞌiheꞌita ꞌesediya. ");
INSERT INTO bdd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bodaedi Yesu ꞌina gwae sihesagoheya ꞌigumwala ma ꞌenana sihemaiseya sigwae, “Cima Buki Heꞌasisi ꞌoina ꞌihepwaila ꞌabehega Toꞌabihetena miyamiya hatayana. Ma hesi ꞌowa ꞌugwaeya ꞌabehega Loheyainaina siꞌabi hanehe. Taiya tauna Loheyainaina?” ");
INSERT INTO bdd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Cidi gwaeina Yesu ꞌihemaiseya ꞌigwae, “Sauga ꞌiꞌiuna ꞌoina maedana ꞌoimiya ꞌimiyamiya, ꞌoinega bewa tuwa maedanaina ꞌoina watauya. Weyahina guguyou ꞌeguma ꞌilatuma, nata geya sowasowahimi ma ꞌeda waꞌita. Weyahina taiya ꞌeguma guguyou ꞌoina ꞌitauya, geya sawasawahina ma ꞌisanapu toꞌeha ꞌitautauya. ");
INSERT INTO bdd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Coinega tuta bewa ꞌoina watoho ma maedanaina ꞌina miyana ꞌoimiya wahemisae ma ꞌoinega ꞌomi maedanaina natunao ma maemaedanimi.” Yesu ꞌina gwae bewa ꞌoidiya ꞌigumwala, ma ꞌitauya, eeta ꞌoidiyega ꞌiꞌwaiha. ");
INSERT INTO bdd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu ꞌilaꞌilala moisa baibaiwadi ꞌiheꞌitediya, ma hesiyage geya sihemisae toho. ");
INSERT INTO bdd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Coinega toꞌaha gidemusa mwalona palopita Aiseya ꞌina hepwaila Buki Heꞌasisi ꞌoina, ꞌabwa hesi ꞌana moisa ꞌilatu bwaibwainama ꞌigwae, “Cinapwana, wasaedi ꞌahepwailediya, taiya hede ꞌihemisaediya? Ma wete Cinapwanaina ꞌina waiwai taiyawedi ꞌoidiya ꞌiheꞌitaediya?” ");
INSERT INTO bdd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","MeYudiyaedi geya sihemisa, weyahina Aiseyaina Buki Heꞌasisi ꞌoina wete ꞌihepwaila, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yehoba matadi ꞌiꞌabi heguguyou pwaiya, ma wete ꞌidi nuwatuhu ꞌiꞌausiya. Coinega geya sawasawahidi ma matadi ꞌoidiyega siꞌebubuna ma wete geya sawasawahidi ma ꞌidi nuwatuhu ꞌiꞌasilala. Coinega geya sawasawahidi ma sitauyama ꞌoiguwa ma yaꞌabi hebwebweꞌanidi.” ");
INSERT INTO bdd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aiseya gwae bewa ꞌiꞌinaneya weyahina Yesu ꞌina hewaiwai ꞌisanapu nugeteya ꞌoinega weyahina ꞌihepwaila nugeta. ");
INSERT INTO bdd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nage ꞌoina meYudiyaedi ꞌidi tohanugetao tupwana baibaiwadi Yesu sihemisaeya, ma hesiyage geya sihepwaila hapwesa. Weyahina Palisiyao simatautediya, nata gide hada tapwalolo ꞌoinega silohesohesoiyedi. ");
INSERT INTO bdd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ma wete tomotaedi taudi nuwanuwadi ma ꞌadi ꞌahwa bwebweꞌana tomota ꞌoidiyega siloba, ma hesi geya nuwadi ma Yehoba ꞌoinega ꞌadi ꞌahwa bwebweꞌana siloba. ");
INSERT INTO bdd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Eeta Yesu ꞌenana madouna ꞌoinega ꞌihegwaediya ꞌigwae, “Taiyawedi ꞌomi ꞌeguma wahemisaegau, ꞌomi wete tauna ꞌihesumanegauwa wahemisaeya. ");
INSERT INTO bdd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma wete taiyawedi ꞌomi ꞌeguma waꞌitegauwa, ꞌomi wete ꞌagu tohesumaneina waꞌita pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taugu bewa maedanaina yatauyama baleꞌuwa ma ꞌoinega taiyawedi ꞌomi ꞌeguma wahemisaegau, nata geyaꞌabwa guguyou ꞌoina watautauya. ");
INSERT INTO bdd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma wete taiyawedi ꞌomi ꞌeguma ꞌenagu wahesagohedi, ma geya wapaihowadi, nata geyaꞌabwa ꞌimi pui weyahidi yaloiloinaegomi. Weyahina taugu yatauyama geya ꞌabehega tomota ꞌidi pui sabi heyatalaina, ma hesi yatauyama tomota ꞌidi pui ꞌoidiyega yaꞌabihetedi. ");
INSERT INTO bdd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Weyahina taiyawedi ꞌomi ꞌeguma walogwahategau ma ꞌigu gwae wete walogwahatediya, nata tuta ꞌana ꞌebe losaloha ꞌoina loina waloba. Loinaina beno ꞌigu gwaeyedi ꞌoidiyega nata waloba. ");
INSERT INTO bdd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Weyahina gwaeyedi taugu geya ꞌigu nuwatuhu ꞌoidiyega, ma hesi toꞌaha gide tauna ꞌihesumanegauma ꞌina nuwatuhu ꞌoidiyega ꞌilohatotogauwa, wete gide ꞌoimiya yahehepwailediwa. ");
INSERT INTO bdd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cina lohatotowedi mabwaiyadi yasanapudiya yawasi miyamiya hatayana ꞌoidiya simiyamiya. Coinega toꞌaha gidemusa Tamagu ꞌina lohatoto ꞌoiguwa, wete gide bewa ꞌoimiya yahehepwailediwa.” ");
INSERT INTO bdd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hataona guyaina ꞌana sauga ꞌiꞌeꞌehoho, ma Yesu ꞌisanapuya ꞌabehega ꞌina sauga ꞌiloba pwaiya ma baleꞌu bewa ꞌiꞌebesine ma ꞌilohihila Tamana ꞌoina. Yesu ꞌina bodaowedi ꞌihelauwediya madouna, ꞌina tuta ꞌebe hegaina hauhau ꞌoinega ma ꞌana ꞌebe losaloha ꞌoina ꞌihelauwediya. ");
INSERT INTO bdd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sauga nage ꞌoina Yesu ma ꞌana tomuliyao nima bwaubwau ma ꞌeluwa mahetenao siꞌaiꞌai. Ma Yudasa Isakaliyota, tauna Saimoni natuna, Seitani ꞌoina ꞌiluhu pwaiya ꞌihenuwa laguweya ma ꞌabehega Yesu ꞌitebae. ");
INSERT INTO bdd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma hesi Yesu ꞌisanapu pwaiya ꞌabehega ginaula mabwaiyana Tamana ꞌiꞌebwaya pwaiya ma ꞌiboimo ꞌiloina. Ma wete Yesu ꞌisanapuya ꞌabehega Yehoba ꞌoinega ꞌitauyama ma ꞌisanapuya ꞌabehega Yehoba ꞌoina nata wete ꞌilohihila. ");
INSERT INTO bdd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eeta ꞌidi ꞌebe ꞌaiina ꞌoinega Yesu ꞌitoholowa, ꞌana ꞌaleꞌo ꞌiꞌewa yahuleya, ma tawelo ꞌiꞌoteya. ");
INSERT INTO bdd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Muliyetega gaeba ꞌoina weꞌaha ꞌisiweya, ma ꞌana tomuliyaedi ꞌahedi ꞌibuyodiya, ꞌabwa muliyetega taweloina ꞌoinega ꞌahediyedi ꞌisaudiya. ");
INSERT INTO bdd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Coinega Yesu Saimoni Pita ꞌoina ꞌilatuwa ma Saimoniina Yesu ꞌihegwaeya ꞌigwae, “Cinapwana, sahena ꞌaheguwedi ꞌubuyobuyodi.” ");
INSERT INTO bdd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma Yesu Saimoni ꞌenana ꞌihehileya ꞌigwae, “Geya ꞌusanapu toꞌaha bewa tuwa ꞌoiuwa yapaipaihowa, ma hesi tuta muliya ꞌoina ꞌabwa hesi ꞌusanapu.” ");
INSERT INTO bdd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Coinega Saimoni Pita ꞌihegwae hileya ꞌigwae, “Sahena ꞌeta wete tuta ꞌoina ꞌahegu ꞌubuyobuyodi.” Coinega Yesu wete ꞌigwae, “Ceguma geyaꞌabwa ꞌaheu yabuyobuyodi, ꞌowa geya ꞌiyagu.” ");
INSERT INTO bdd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimoni Pita Yesu ꞌoina ꞌitagwala ꞌigwae, “Cinapwana, bwebweꞌana. Ta geya ꞌabehega ꞌahegumo, ma hesi nuwanuwagu nimagu wete debagu mabwaiyana ꞌubuyodi.” ");
INSERT INTO bdd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Coinega Yesu ꞌihegwaeya ꞌigwae, “Taiyawedi ꞌomi ꞌeguma wahatui pwaiya, ꞌilobwainegomiya ma ꞌahemimo yabuyodi ma ꞌoinega wahimi mabwaiyadi siꞌehau. Yasanapugomiya ꞌomi bwebweꞌami, ma hesi geya mabwaiyami bwebweꞌami.” ");
INSERT INTO bdd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu gwae bewa ꞌiꞌinaneya weyahina ꞌisanapu nugeteya taiya nata ꞌoidiyega Yesu ꞌitebae, tutaina ꞌigwae, “Geya mabwaiyami bwebweꞌami.” ");
INSERT INTO bdd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cahediyedi ꞌibuyodiya ꞌigumwala ma ꞌana ꞌaleꞌoina ꞌisipwa hileya ma ꞌimiya toiya. Cabwa hesi ꞌihegwaediya ꞌigwae, “Nuwamiya ꞌimaedana toꞌaha yapaihoweya ꞌoimiya, bo geya? ");
INSERT INTO bdd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Comi wabwauwegauwa ꞌabehega taugu Toheꞌita ma wete ꞌimi Cinapwana. Ta beno moisa, geya waꞌabo. ");
INSERT INTO bdd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taugu moisa ꞌimi Toheꞌita ma wete ꞌimi Cinapwana ma ꞌahemi yabuyodiya. Coinega ꞌomi wete ꞌilobwainegomiya ma ꞌiyamiyao ꞌahedi wabuyodi. ");
INSERT INTO bdd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wahetotowanegau ma toꞌaha gide ꞌoimiya yapaihoweya, ꞌomi wete gidemusa ꞌiyamiyao ꞌoidiya wapaihowa ꞌesedi. ");
INSERT INTO bdd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bewa yahegwae bwaibwainigomi ꞌabehega geya ꞌeta taiya topaihowa ꞌina ꞌinapwana ꞌida hanesineya. Tohewasa wete gidemusa, geya sowasowahina ma ꞌana tohesumaneina ꞌihanesine. ");
INSERT INTO bdd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Heꞌitaedi mabwaiyadi wasanapudiya, ma ꞌeguma wapaihowadi, nata ꞌomi ꞌebe yaliyaya bwebweꞌana waloba. ");
INSERT INTO bdd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Cigu gwae bewa geya ꞌabehega mabwaiyami weyahimi, ma hesiyage taiyawedi taudi yahesinuwana pwaidiya weyahidi yahehegwaegwae. Ma hesi Buki Heꞌasisi ꞌoina hali loheya weyahina ꞌihepwaila, ꞌana moisa ꞌilatu bwaibwaina tutaina ꞌigwae, ‘Loheyainaina tauna ꞌana yaꞌebwaꞌebwaeya, tauna tuwa loheyainaina nata ꞌimiya lohihila ma ꞌiloꞌalehegau.’ ");
INSERT INTO bdd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ginauledi bewa yahepwaila pwaidiwa ꞌoimiya, ma ꞌoinega ꞌabwa tuta muliya ꞌoina silatuma, ꞌabwa waꞌitadi ma wahemisaegau ꞌabehega taugu tuwa Loheyaiguina bewa yahehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Moisa tuwa, ꞌabwa yahewasaegomi tomota ꞌoidiya, ma ꞌeguma taiya ꞌitagwala ꞌoimiya, beno tauna ꞌitagwala pwaiya ꞌoiguwa, ma wete ꞌitagwala ꞌagu tohewasaina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Gwae bewa ꞌigwaenediya ꞌigumwala, ma nuwana ꞌigala madouna, ꞌoinega ꞌana tomuliyaedi ꞌoidiya ꞌihepwaila latuwa ꞌigwae, “Yagwae moisa ꞌoimiya, nata ꞌoimiyega loheya ꞌaigeda ꞌitebaegau.” ");
INSERT INTO bdd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nage ꞌoina tomuliyaedi mabwaiyadi nuwadi ꞌihenainaida ꞌoinega mabwaiyadi siheꞌebuꞌebubuna hilediya, weyahina geya sisanapu taiya weyahina ꞌidi Cinapwanaina ꞌoidiya ꞌihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tuwa ꞌana tomuliyaina ꞌaigeda, tauna moisa ꞌiyana, Yesuina deina ꞌimiyana. ");
INSERT INTO bdd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eeta Saimoni Pita nimanega tomuliyainaina ꞌihegwaeya ꞌigwae, “Cuhesilala taiya weyahina ꞌihehegwaegwae?” ");
INSERT INTO bdd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ma tomuliyaina tauna Yesu deina ꞌiꞌeno hilahila, Yesu ꞌihegwaeya ꞌigwae, “Cinapwana, taiya weyahina ꞌuhehegwaegwae?” ");
INSERT INTO bdd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Coinega loheyaina ꞌenana Yesu ꞌihemaiseya ꞌigwae, “Cuꞌitaꞌita nata ꞌeguma beledi yahisi ma ꞌwayahi ꞌoina yahepwasa ma yaꞌebwae, tauna beno loheyainaina.” Coinega Yesu beledi ꞌiꞌiuna ꞌiꞌeweya ꞌwayahi ꞌoina ꞌihepwaseya ma Yudasa ꞌiꞌebwaeya, tauna tuwa Saimoni Isakaliyota natuna. ");
INSERT INTO bdd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sauga nage ꞌoina Yudasa beledi ꞌiꞌeweya ma Seitani ꞌoina ꞌiluhuwa. Coinega Yesu Yudasaina ꞌihegwaeya ꞌigwae, “Culomwayamwayau ma ꞌino paihowaina ꞌupaihowa.” ");
INSERT INTO bdd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma ꞌiyamo bodaedi, taudi mahetediyao simiyamiya, Yesuina ꞌina gwaeina Yudasa ꞌoina geya sisanapu toꞌaha weyahina ꞌihehegwaegwae. ");
INSERT INTO bdd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasaina tauna ꞌidi mane ꞌana toꞌitayahina, ꞌoinega ꞌidi nuwatuhu ꞌabehega Yesu Yudasa ꞌihegwaeya ma ꞌitauya guyaina weyahina ginaula ꞌigimwane, bo nuwana ꞌitautauya wewelohe ꞌoidiya ma ꞌidi mane ꞌiꞌebwaedi. ");
INSERT INTO bdd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eeta Yudasa belediina ꞌiꞌaiya, ma ꞌilomwayamwayauwa ꞌilatuwa ꞌatamana. Beno nihuwana. ");
INSERT INTO bdd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasaina ꞌiꞌebesinediya, ma Yesu ꞌana tomuliyaedi ꞌihegwaediya ꞌigwae, “Taugu Loheyaiguina ꞌigu sauga ꞌilatu pwaima, ma ꞌigu wasawasa ꞌilatu, ma wete taugu Yehoba ꞌina wasawasa yaꞌabilatuhe. ");
INSERT INTO bdd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cabwa nata ꞌoiguwega Yehoba sanina ꞌiꞌabi hanehe, ma wete Yehoba ꞌiboi ꞌoinega taugu sanigu ꞌiꞌabi hanehe mwayamwayauwe. ");
INSERT INTO bdd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natugwao, tuta ꞌiꞌiunamo taugu mahetemiu tamiyamiya. Ma ꞌabwa nata yaꞌebesinegomi ma wabesegau. Ma hesi bewa tuwa yahegwaegomi gide mwalona meYudiya yahegwae ꞌesediya yagwae, ‘Casainaina ꞌoina yatautauya, ꞌomi geya sowasowahimi ma ꞌoina watauyawa.’ ");
INSERT INTO bdd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Coinega wete ꞌomi loina hauhauna bewa yaꞌebwaegomi ma ꞌaigeda ꞌaigeda ꞌatemiyega wahelau hilegami. Ma wahelau hilegami gidemusa taugu yahehelauwegomi. ");
INSERT INTO bdd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma ꞌoinega ꞌimi helauina tomota baibaiwadi siꞌita, ma sisanapugomi ꞌabehega ꞌomi moisa ꞌagu tomuliyao.” ");
INSERT INTO bdd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ma Saimoni Pita Yesu ꞌihesilaleya ꞌigwae, “Cinapwana, taꞌeha ꞌuhahaꞌesa?” Coinega Yesu Saimoni ꞌenana ꞌihemaiseya ꞌigwae, “Sauga bewa ꞌoina geya sowasowahiu ma ꞌumuliyegau, ma hesi sauga ꞌinaonaoma ꞌoina ꞌabwa hesi ꞌumuliyegau ꞌasainaina ꞌoina yatautauya.” ");
INSERT INTO bdd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma Pita Yesu wete ꞌenana ꞌihemaiseya, ꞌigwae, “Cinapwana, toꞌaha weyahina sauga bewa ꞌoina geyaꞌabwa yamulimuliyego? Hesi ꞌuda sanapu yatagwalegauwa ma weyahiu yaꞌamasa.” ");
INSERT INTO bdd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Coinega Yesu ꞌigwae, “Cino gwaeyedi geya yahemisaedi, ma hesi ꞌoiuwa yahepwaila dumwalu nata nihuwanega ꞌumwehihiyegau matoi, ꞌabwa muliyetega ꞌamꞌam ꞌidou.” ");
INSERT INTO bdd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu wete ꞌihegwaediya, ꞌigwae, “Sahena nuwami sihehelahalaha, ma hesi Yehoba wahemisae ma wete taugu wahemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Casainaina Tamagu ꞌoina ꞌimiyamiya hada baibaiwadi sitotoholo, ꞌoinega ꞌasainaina ꞌoina yatauya ma ꞌimi ꞌebemiya yaꞌatububudi. Gwae bewa ꞌeguma geya moisa, geyaꞌabwa wete ꞌoimiya yahehepwaile. ");
INSERT INTO bdd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma ꞌeguma yatauya ma ꞌimi ꞌebe miya yaꞌatububudi ꞌigumwala, nata yahilama yatoegomi ma tatauya gogoinaina ꞌoina yamiyamiya, ma ꞌomi wete ꞌoina wamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Cedainaina ꞌoinega yatautauya ꞌomi wasanapu pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma Tomasi Yesu ꞌihesilaleya ꞌigwae, “Cinapwana, to ꞌeda ꞌoinega ꞌutautauya? Togidega ma ꞌedainaina ꞌada sanapu?” ");
INSERT INTO bdd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Coinega Yesu Tomasi ꞌihegwaeya ꞌigwae, “Taugu ꞌeda, ma gwae moisa, ma wete yawasimi huhudi. Weyahina geya ꞌeta taiya sowasowahina ma Tamagu ꞌoina ꞌitauya ꞌeguma loheyainaina geya ꞌoiguwega ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Taugu moisa wasanapu pwaigauwa ma Tamagu wete wasanapuya, ꞌoinega bewa tuwa Tamagu wasanasanapu ma wete ꞌana ꞌita waꞌitaꞌita.” ");
INSERT INTO bdd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nage ꞌoina Pilipi Yesu ꞌihesilaleya ꞌigwae, “Cinapwana, Tamauina hede ꞌuheꞌitemai.” ");
INSERT INTO bdd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma Yesu ꞌenana ꞌihemaiseya ꞌigwae, “Pilipi, sauga saliya hedadena ꞌoimiya yamiyamiya ma hesi geya ꞌusanapu tohogau. Taiyawedi ꞌomi waꞌita pwaigauwa, ꞌomi Tamagu wete waꞌita pwaiya. Coinega toꞌaha weyahina ꞌugwaeya, ‘Tamauina hede ꞌuheꞌitemai?’ ");
INSERT INTO bdd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bo nuwana geya wahemisaegau ꞌabehega taugu Tamagu ꞌoiguwa ꞌimiyamiya, ma taugu wete ꞌoina yamiyamiya.” Coinega wete ꞌihegwaediya ꞌigwae, “Gwaeyedi yagwaenediya ꞌoimiya, taugu geya ꞌenagu. Ma hesi Tamagu tauna ꞌenana yagwaenediwa, weyahina tauna ꞌoiguwa ꞌimiyamiya ma ꞌoiguwega ꞌipaipaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Coinega bewa tuwa wahemisaegau ꞌabehega taugu Tamagu ꞌoina yamiyamiya ma wete Tamagu tauna ꞌoiguwa ꞌimiyamiya. Ma ꞌeguma ꞌigu gwaeyedi geya wahehemisaedi, hede ꞌigu paihowaedi waiwaidi wanuwatuhudi ma ꞌoidiyega wahemisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bewa tuwa ꞌoimiya yahepwaila dumwalu, ꞌeguma taiyawedi ꞌomi wahemisaegau nata paihowaedi waiwaidi yapaihowediya, ꞌomi wete gidemusa wapaihowa ꞌesedi. Ma wete tuta muliya ꞌoina ꞌimi paihowa waiwai hedadena waꞌabi latuhedi, weyahina taugu yatautauya Tamagu ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma ꞌeguma toꞌaha nuwanuwami ma saniguwega waꞌahwanoi, nata yaꞌebwaegomi, ma ꞌoinega Tamagu ꞌana hepwatu ꞌiloba ꞌigu paihowega. ");
INSERT INTO bdd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ceguma toꞌaha nuwanuwami ma saniguwega waꞌahwanoi, nata taugu yapaihowa.” ");
INSERT INTO bdd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Coinega Yesu ꞌana tomuliyaedi wete ꞌihegwaediya ꞌigwae, “Ceguma moisa wahelauwegauwa, ꞌigu loinao mabwaiyadi wahematamatanedi. ");
INSERT INTO bdd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma wete Tamagu ꞌoina yaꞌahwanoi ma ꞌami tolema ꞌaigeda ꞌihesumaneyama, ");
INSERT INTO bdd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","tauna tuwa Yaluyaluwa moisa ma dumwadumwaluna. Ma ꞌoinega tauna ꞌoimiya ꞌimiya hataya. Mebaleꞌu geya sowasowahidi ma Yaluyaluwanaina ꞌoina sitagwaledi, weyahina ꞌana ꞌita geya siꞌita ma geya wete sisanapu. Ma hesiyage ꞌomi Tolemainaina wasanasanapu, weyahina sauga ꞌaigeda ꞌaigeda ꞌoidiya ꞌatemiya ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma hesiyage ꞌeguma yaꞌebesinegomi, sahena ꞌimi nuwatuhu ꞌabehega wahesina sinageheya, weyahina nata yatauya ꞌabwa wete yalohihilama ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Ciꞌiunamo ma yaꞌebesinegomi. Ma hesi mebaleꞌu taudi geya sihemisaegau nata geyaꞌabwa siꞌitaꞌita hilegau. Ma hesiyage ꞌomi nata moisa waꞌita hilegau mayawasigu yamiyamiya. Beno ꞌoinega ꞌomi nata wete yawasi miyamiya hatayana ꞌoiguwega waloba. ");
INSERT INTO bdd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“Sabwelo nage nata ꞌoina ꞌabwa hesi wasanapugau ꞌabehega taugu Tamagu ꞌoina yamiyamiya, ma ꞌomi wete ꞌoiguwa wamiyamiya, ma taugu wete ꞌoimiya yamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ma taiyawedi ꞌomi ꞌeguma ꞌigu loina wasanapudiya ma wahematamatanedi, ꞌomi moisa wahelauwegauwa. Coinega Tamagu ꞌomi nata wete ꞌihelauwegomi, ma wete taugu nata yahelauwegomi, ma yaboi yaheꞌitaegau ꞌoimiya.” ");
INSERT INTO bdd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sauga beno ꞌoina hali Yudasa, geya Isakaliyota natuna, Yesu ꞌihegwaeya ꞌigwae, “Cinapwana, toꞌaha weyahina ꞌabehega tauma ꞌoima ꞌuheꞌitaego ma ꞌabehega mebaleꞌu ꞌoidiya geyaꞌabwa?” ");
INSERT INTO bdd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Coinega Yesu loheyaina ꞌenana ꞌihemaiseya ꞌigwae, “Taiyawedi ꞌomi ꞌeguma wahelauwegau ma ꞌigu gwae wamuliyedi, nata Tamagu wete ꞌihelauwegomi. Ma ꞌoinega tauna baꞌidagu ꞌatauyawa ꞌoimiya ma ꞌomi ma tauma tamiya hegogona. ");
INSERT INTO bdd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma taiyawedi ꞌomi ꞌeguma geya wahelauwegau ꞌomi geya ꞌigu gwae ꞌana topaihowao. Ma hesi gwaeyedi wahesagohediya, taugu geya ꞌoiguwega, ma hesi Tamagu ꞌoinega, tauna ꞌihesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Sauga bewa ꞌoina taugu baꞌidamiu tamiyamiya ꞌoinega ꞌigu gwae bewa yaꞌebwaꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma hesi sauga muliya ꞌoina ꞌabwa hesi tolemaina saniguwega Yehoba ꞌihesumaneyama ꞌoimiya, tauna tuwa Yaluyaluwa Tabuna, nuwatuhu mabwaiyana ꞌiheꞌitegomi ma wete ꞌigu gwaeyedi mabwaiyadi ꞌoimiya ꞌiꞌabi henuwatuhu yahigomi. ");
INSERT INTO bdd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ma hesi taugu sauga ꞌiꞌiunamo ma yaꞌebesinegomi, ꞌoinega taugu tuwa ꞌigu nuwadaumwala ꞌoinega nuwadaumwala yaꞌebwaegomi. Nuwadaumwala bewa geya gidemusa mebaleꞌu ꞌoidiyega, ꞌoinega sahena nuwami sihehelahalaha bo ꞌatemi siyohoyoho. ");
INSERT INTO bdd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Cigu gwae bewa wahesagoha pwaidiya, beno ‘Nata yatauya, ꞌabwa wete yahilama ꞌoimiya.’ Ma hesi ꞌomi ꞌeguma wahelauwegau, ꞌigu tauyaina Tamadaina ꞌoina weyahina wayaliyaya. Weyahina Tamadainaina tauna ꞌihane sinegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Sauga bewa ꞌoidiya ginaulaedi yahepwaila pwaidiya ꞌoimiya, ma ꞌeguma sauga sinaonaoma ꞌoidiya ginaulaedi silatu, nata waꞌahwa moisaegau. ");
INSERT INTO bdd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nata geyaꞌabwa wete sauga saliyana ꞌoimiya yahehegwaegwae, weyahina bewa tuwa mebaleꞌu ꞌidi toloina galana ꞌitautauyama. Tauna geya sawasawahina ma ꞌihewaiwai sinegau. ");
INSERT INTO bdd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma hesi ꞌagu lohatoto Tamagu ꞌoinega sauga baibaiwana yapaipaihowadi, bewa ꞌoinega ma mebaleꞌu sisanapugau ꞌabehega Tamagu yahelauweya. Tuwa tauna beno. Watoholo ma tatauya.” ");
INSERT INTO bdd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Coinega Yesu wete ꞌihegwaediya ꞌigwae, “Taugu ꞌaiwe huwahuwa moisa waini weyahina, ma Tamagu tauna topaihowa. ");
INSERT INTO bdd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lahagwao ꞌeguma geya sida huwa bwaibwaina nata tauna lahagwaowedi ꞌiꞌupwa yahuledi. Ma hesi lahagwaowedi ꞌeguma huwaidi bwebweꞌadi nata moisa ꞌiꞌabi bwaibwainidi ma sihuwa bwaibwaina. ");
INSERT INTO bdd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Comi wete gidemusa ꞌigu gwae ꞌoidiyega yaꞌabihe bwebweꞌanegomiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Comi ꞌoiguwa wamiyamiya ma taugu wete ꞌoimiya yamiyamiya. Comi ꞌeguma geyaꞌabwa ꞌoiguwa wamiyamiya nata geyaꞌabwa huwaimi bwebweꞌadi silagulagu. Ceda ꞌaigedanaina wete gide, ꞌeguma ꞌaiwe madouna laganao ꞌoinega simiyawasi nata laganaowedi geya huwaidi bwebweꞌadi silagulagu. ");
INSERT INTO bdd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Taugu gide ꞌaiwe ꞌaigeda madouna ma ꞌomi gide lahagwao. Coinega taiyawedi ꞌomi ꞌeguma ꞌoiguwa wamiyamiya nata huwaimi bwebweꞌadi silagulagu. Weyahina taugu ꞌeguma geya, nata geya sowasowahimi ma paihowa bwebweꞌadi wapaihowadi. ");
INSERT INTO bdd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Coinega taiyawedi ꞌomi ꞌeguma geyaꞌabwa ꞌoiguwa wamiyamiya, nata Tamagu ꞌoiguwega ꞌiꞌewa yahulegomi ma wawelai. Gidemusa ꞌaiwe lagalaganao siwelawelai ma ꞌaiwe ꞌalaꞌalasidi ꞌoidiya sigabugabudi. ");
INSERT INTO bdd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma hesi ꞌoiguwa ꞌeguma wamiyamiya, ma wete ꞌigu gwae ꞌoimiya simiyamiya, ma toꞌaha ꞌeguma nuwanuwami ma saniguwega waꞌahwanoi, nata tuwa wete walobadi. ");
INSERT INTO bdd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma ꞌeguma moisa wamuliya bwaibwainigau, nata huwaimi bwebweꞌadi silatu ma ꞌoidiyega tomota siꞌita ma Yehoba sihepwatuwe. ");
INSERT INTO bdd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamagu ꞌihelauwegauwa madouna, ꞌoinega taugu wete yahelauwegomiya madouna, ma ꞌoinega ꞌigu helauina ꞌoina wada miyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma ꞌigu loinao ꞌeguma wete wamuliya bwaibwainidi nata ꞌomi wete ꞌigu helau ꞌoina wamiyamiya. Gide taugu Tamagu ꞌina loinao yamuliya bwaibwainidiya, ꞌoinega ꞌina helau ꞌoina yamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Beno tuwa tauna gidemusa yahegwaegomiya, ma ꞌoinega ꞌigu yaliyayega wayaliyaya ma nuwami mabwaiyana sibwebweꞌana. ");
INSERT INTO bdd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma bewa ꞌigu loina ꞌoimiya ma ꞌaigeda ꞌaigeda wahelau hilegomi gidemusa yahehelauwegomi. ");
INSERT INTO bdd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma taiya ꞌeguma ꞌiyanao weyahidi ꞌiꞌamasa, beno moisa helau madou hedadena. ");
INSERT INTO bdd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Comi ꞌeguma ꞌigu loinao wagwahu bigadi ꞌomi moisa ꞌiyagwao. ");
INSERT INTO bdd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sauga bewa ꞌoinega ma ꞌilagalaga geyaꞌabwa wete yaꞌahwaꞌahwa topaihowaegomi. Weyahina topaihowa geya ꞌilobwainedi ma ꞌidi ꞌinapwanao ꞌidi nuwatuhu sisanapudi. Ma hesi ꞌilobwainegomiya bewa tuwa yaꞌahwa ꞌiyaguwegomi, Weyahina toꞌaha gidemusa Tamagu ꞌoinega yahesagohediya, boꞌiyage yahepwaila pwaidiwa ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Comi geya wahesinuwegau ma ꞌoimiya yaheꞌinapwana. Taugu hesiyage yahesinuwanegomiya ma ꞌabehega yahesumanegomi, wapaihowa, ma ꞌimi paihowaedi ꞌoidiyega huwaimi bwebweꞌadi silatu, ma wete ꞌoimiya simiya hataya. Ma ꞌoinega toꞌaha nuwanuwami, ma saniguwega waꞌahwanoi, nata wete Tamagu ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma yalohatotogomi ꞌabehega wahelau hilegomi.” ");
INSERT INTO bdd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Coinega Yesu wete ꞌihegwaediya ꞌigwae, “Mebaleꞌu ꞌeguma silogwahategomi, wanuwatuhuyahi ꞌabehega taugu mwalona wete gide siꞌesegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ma ꞌeguma mumugami tomiya baleꞌu gidemusa tomiya baleꞌu sihelauwegomi, weyahina sisanapuya ꞌabehega ꞌomi ꞌiyadiyao. Ma ꞌiyamo sauga bewa ꞌoina, ꞌomi yahesinuwane pwaigomiya, ꞌoinega mebaleꞌu ꞌoidiyega yaꞌewa yahulegomiya. Eeta ꞌomi geya wete mebaleꞌu ꞌidi boda ꞌoidiya wamiyamiya. Beno huhuna ꞌoinega mebaleꞌu silogwahategomiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Gwaeyedi yaꞌebwaegomiya wanuwatuhuyahi paꞌalidi, tutaina yagwaeya ꞌabehega geya ꞌeta topaihowa sowasowahina ma ꞌina ꞌinapwana ꞌihanesine. Weyahina taugu mwalona gide siloꞌalehegauwa, ꞌoinega ꞌomi nata wete gide siloꞌalehegemi. Ma ꞌeguma mwalona ꞌigu gwae sida muliyaediya, ꞌomi wete gide ꞌimi gwae nata simuliya. ");
INSERT INTO bdd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ginaulaedi galadi bewa nata ꞌoimiya sipaihowadi weyahina ꞌomi ꞌigu bodao, ma wete tauna ꞌihesumanegauma geya sisanapu. ");
INSERT INTO bdd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma ꞌeguma mwalona geyaꞌabwa ꞌoidiya yatautauya ma ꞌoidiya yahehepwaila, geyaꞌabwa wete ꞌidi pui ꞌoidiya sida miyamiya. Ma hesi yatauya pwaiya ꞌoidiya ta wete yagwae pwaiya ꞌoidiya. Coinega geya sowasowahidi ma ꞌidi puiyedi weyahidi sigwae hila. ");
INSERT INTO bdd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma taiyawedi ꞌeguma silogwahategau, bodaedi beno taudi wete Tamagu silogwahateya. ");
INSERT INTO bdd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","“Ma wete ꞌeguma mwalo geyaꞌabwa ꞌigu paihowa waiwaidi matadiya yada paipaihowadi, beno geya ꞌidi puimo. Ma hesi paihowaedi yapaihowa pwaidiya ꞌoidiya, paihowaedi geya ꞌeta taiya gide ꞌida paihowa ꞌesediya. Ma paihowaedi siꞌita pwaidiya, ma hesi Tamagu ma taugu tuwa silogwahatemaiya. ");
INSERT INTO bdd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma ꞌidi paihowa galadiyedi silatu bwaibwaina weyahina Buki Heꞌasisi ꞌoina ꞌihepwaila ꞌigwae, ‘Silogwahategauwa geya huhunamo.’ ");
INSERT INTO bdd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Comi nata ꞌami tolema Tamagu ꞌoinega yahesumaneyama. Tauna Yaluyaluwaina, gwae moisa huhuna. Tauna nata ꞌihetohepwaila weyahigu. ");
INSERT INTO bdd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma wete ꞌomi weyahigu wahetohepwaila. Weyahina ꞌomi ꞌigu paihowa hauhau ꞌebe hegaina eema ꞌana siga bewa, ꞌomi mahetegwao.” ");
INSERT INTO bdd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu ꞌana tomuliyaedi wete ꞌihegwaediya ꞌigwae, “Ginaulaedi yagwaenediya ꞌoimiya ma ꞌoinega geyaꞌabwa ꞌoiguwega wabeꞌubeꞌu. ");
INSERT INTO bdd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Weyahina ꞌabwa nata hada tapwalolo ꞌoidiyega sipaꞌigomi, ma wete tuta sinaonaoma ꞌoidiya taiyawedi siloheꞌamasigomi nata taudi ꞌidi nuwatuhu ꞌabehega ginaula bwebweꞌana sipaipaihowa Yehoba ꞌina ꞌebe yaliyaya. ");
INSERT INTO bdd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cidi paihowaedi galadi nata ꞌoimiya sipaihowadi weyahina Tamagu ma taugu geya sisanapumai. ");
INSERT INTO bdd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ginaula bewa yahepwailediwa, ma ꞌeguma sauganaina silatu, nata wanuwatuhu hila ꞌabehega ginaulaedi ꞌoimiya hepwailediya.” Coinega wete ꞌihegwaediya ꞌigwae, “Ginaulaedi bewa mwalona geya yahepwaila nugetedi ꞌoimiya, weyahina sauga baibaiwana ꞌoidiya taugu baꞌidamiu. ");
INSERT INTO bdd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ma hesi ꞌiꞌiunamo ma yaꞌebesinegomi ma yatauya tauna ꞌihesumanegauma ꞌoina, ꞌoinega ginaulaedi yahehepwailedi ꞌoimiya. Bewa tuwa nata yaꞌebesinegomi ma hesi geya ꞌeta taiya ꞌida hesilalegau nuwana ꞌida gwae, ‘Cinapwana, taꞌeha ꞌutautauya?’ ");
INSERT INTO bdd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","“Ma ginaulaedi yagwaenediya ꞌoimiya weyahidi wanuwagala madouna. ");
INSERT INTO bdd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma hesiyage bewa yagwae moisa ꞌoimiya ꞌabehega bwebweꞌana ꞌoimiya ꞌeguma yaꞌebesinegomi. Weyahina ꞌeguma geyaꞌabwa yaꞌebeꞌebe sinegomi, nata geyaꞌabwa wete Tolemaina ꞌitautauyama ꞌoimiya. Ma hesi ꞌeguma yaꞌebesinegomi ma yatauya, nata ꞌami Tolemaina yahesumaneyama ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma tutaina ꞌeguma ꞌitauyama ꞌoimiya, nata ginaula ꞌetoi mebaleꞌu ꞌiheꞌitadi ma sisanapudi. Ginaulaedi beno taudi, paihowa galadi, ma paihowa bwebweꞌadi, ma wete heyatala weyahidi. ");
INSERT INTO bdd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Ma tutaina ꞌeguma ꞌiheꞌitadi ma geya sihemisaegau, tomotaiyedi taudi ginaula galadi ꞌadi topaihowao moisa. ");
INSERT INTO bdd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma wete tauna nata mumuga bwebweꞌana ꞌiheꞌitegami, weyahina taugu yatautauya Tamagu ꞌoina ma geyaꞌabwa wete waꞌitaꞌita hilegau. ");
INSERT INTO bdd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tolemaina tauna nata wete mebaleꞌu bwaꞌomatana ꞌiheꞌitadi ma ꞌoinega mebaleꞌu sisanapu ꞌabehega bwaꞌomatana ꞌitauya pwaima baleꞌuwa. Weyahina baleꞌuina ꞌana toloinaina ꞌina paihowa galadi ꞌoidiyega ꞌana heyatala ꞌiloba pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Heꞌita baibaiwa hedadedi simiyamiya, ma hesi nata geyaꞌabwa yahehepwailediwa sauga bewa ꞌoina, weyahina geya sowasowahimi ma wasanapudi. ");
INSERT INTO bdd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma hesiyage ꞌabwa nata Yaluyaluwa Tabuna ꞌitauyama ꞌabwa hesi tauna ꞌihanugetegomi ginaula mabwaiyana ꞌausaladi ꞌoidiya. Tauna nata geyaꞌabwa ꞌina loina ꞌoinega ꞌiloiloina, ma hesiyage toꞌaha gidemusa Tamagu ꞌoinega ꞌihesagoheya nata ꞌoidiyega ꞌiloina. Ma wete nata ꞌihegwaegomi toꞌaha ꞌabwa sauga sinaonaoma ꞌoidiya silatu. ");
INSERT INTO bdd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tauna nata wete ꞌigu sonogega ꞌiheꞌitegomi ma ꞌoinega sanigu waꞌabi hanehe. ");
INSERT INTO bdd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma toꞌaha gidemusa Tamagu ꞌina ꞌebe loinao, mabwaiyana taugu ꞌigu ꞌebe loinao. Beno ꞌoinega yagwaeya ꞌabehega ꞌigu sonogega ꞌiheꞌitegomi.” ");
INSERT INTO bdd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Coinega Yesu wete ꞌihegwaediya ꞌigwae, “Sauga ꞌiꞌiunamo ma geyaꞌabwa waꞌiteꞌitegau. Ma sauga ꞌiꞌiunamo ꞌoina ꞌabwa wete waꞌita hilegau.” ");
INSERT INTO bdd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Coinega tomuliyaedi tupwadi sihegwae hilediya sigwae. “Togidega ꞌina gwaeina ꞌana sanapu, weyahina ꞌigwaeya ꞌabehega sauga ꞌiꞌiunamo ꞌoina ma ꞌiꞌebe sinegita ma wete sauga ꞌiꞌiunamo ꞌoina ꞌabwa wete taꞌita hila? Ma wete ꞌigwaeya ꞌabehega ꞌitautauya Tamana ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Coinega toꞌaha sauga ꞌiꞌiuna ꞌana sanapu?” Ma tomuliyaedi sigwae, “Cinamuge, geya tasanapu toꞌaha weyahina ꞌihehegwaegwae.” ");
INSERT INTO bdd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Eeta Yesu ꞌana tomuliyaedi ꞌidi nuwatuhu ꞌisanapuya, ꞌoinega ꞌihegwaediya ꞌigwae, “Toꞌaha weyahina wahehegwaegwae? Bo nuwana yahegwaegomiya ꞌabehega sauga ꞌiꞌiunamo ma yaꞌebesinegomi ꞌabwa wete sauga ꞌiꞌiunamo ꞌoina waꞌita hilegau weyahina wahehegwaegwae, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma hesiyage bewa yahegwae bwaibwainigomi ꞌabehega ꞌabwa nata maꞌimi nuwagala weyahigu wadou. Ma tomiya baleꞌu nata ꞌigu tauya weyahina siyaliyaya. Ma hesiyage ꞌimi nuwa galaedi nata sauga sinaonaoma ꞌoidiya ꞌiꞌabibui ma wayaliyaya. ");
INSERT INTO bdd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tuwa gide ꞌeguma wahine ꞌina tuta henatuna ꞌoina, nata maꞌina nuwagala weyahina muya ꞌiloba. Ma tutaina ꞌeguma ꞌihenatuna, muya mabwaiyana ꞌinuwenaide, ta ꞌiyaliyaya tuwa, weyahina gwama ꞌiꞌahala pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Coinega ꞌomi wete gide, sauga bewa ꞌoina maꞌimi nuwagala. Ma tutaina ꞌeguma yahilama ꞌoimiya ma waꞌitegau, nata weyahigu wayaliyaya madouna. Yaliyayaina nata geyaꞌabwa ꞌeta taiya ꞌiꞌewaꞌewa yahuledi ꞌoimiyega. ");
INSERT INTO bdd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma tuta nage ꞌoina geyaꞌabwa ꞌeta toꞌaha weyahidi wahehesilalegau, ma moisa hesi saniguwega Tamagu ꞌoina ginaulinaina weyahina waꞌahwanoi, nata tuwa ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Comi mwalo ta bewa ꞌoina saniguwega geya ꞌeta toꞌaha weyahina wada ꞌahwanoiya. Coinega bewa tuwa ꞌeguma ꞌeta toꞌaha nuwanuwami, waꞌahwanoi ma ꞌiꞌebwaegomi, ma ꞌoinega wayaliyaya moisa.” ");
INSERT INTO bdd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Coinega Yesu wete ꞌihegwaediya ꞌigwae, “Ginaulaedi gwae hegehegedi ꞌoidiyega yahepwaile pwaidiwa ꞌoimiya. Ma hesi sauga sinaonaoma ꞌoidiya nata geyaꞌabwa wete gwae hegehegedi ꞌoidiyega yahehegwaegomi, ma hesiyage nata Tamagu weyahina ꞌabwa hesi yagwae hapwesa bwaibwaina ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma sauga nage ꞌoina nata ꞌomi saniguwega Tamagu ꞌoina waꞌahwanoi, taugu nata geyaꞌabwa weyahimi yaꞌahwaꞌahwanoi, ");
INSERT INTO bdd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","weyahina Tamagu ꞌihelauwe pwaigomiya. Cina helauina huhuna weyahina ꞌomi wahelauwegauwa, ma wete wahemisaegauwa ꞌabehega taugu Yehoba ꞌoinega yatauyama. ");
INSERT INTO bdd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ta moisa tuwa beno, taugu Tamagu ꞌoinega yatauyama ma baleꞌu bewa ꞌoina yamiyamiya. Coinega bewa tuwa baleꞌu yaꞌebeꞌebesine ma yalolohihila Tamagu ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Coinega ꞌana tomuliyaedi sihegwaeya sigwae, “Cinapwana, bewa tuwa ꞌoima ꞌugwaelatu bwaibwaina, weyahina geya gwae hegehegedi ꞌoidiyega ꞌugwae. ");
INSERT INTO bdd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Coinega bewa tuwa ꞌasanapu bwaibwainigowa ꞌabehega ꞌowa moisa ginaula mabwaiyana ꞌusanapudiya. Coinega bewa tuwa geyaꞌabwa wete ꞌahehesilala hilago, weyahina ꞌima nuwatuhu mabwaiyadi ꞌusanapu pwaidiya. Beno ꞌoinega ꞌahemisaegowa ꞌabehega ꞌowa moisa Yehoba ꞌoinega ꞌutauyama.” ");
INSERT INTO bdd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Coinega Yesu wete ꞌihegwae hilediya ꞌigwae, “Bewa tuwa ꞌabwa hesi wahemisaegauwa, ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ma hesiyage wada sanapu ꞌabehega tuta ꞌinaonaoma ꞌoina, bo nuwana tagwae tuta bewa ꞌilatu pwaima, ma mabwaiyami waliya sawala ꞌimi ꞌasa ꞌoidiya ma yaboigumo ꞌebwa yamiyamiya. Ta geya ꞌabehega moisa yaboigumo, weyahina Tamagu baꞌidagu ꞌamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Gwae bewa yaꞌinanediwa ꞌoimiya ma ꞌoiguwega wanuwa daumwala. Ma hesiyage ꞌimi miya gogo gabulena ꞌoina nata ꞌigala. Ma hesiyage waꞌatepatu, weyahina taugu gogo gabulena ꞌana loina mabwaiyana yahewaiwai sinediya.” ");
INSERT INTO bdd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Gwae bewa Yesu ꞌigwaenediya ꞌigumwala, ma ꞌiꞌita haneya galewa ma ꞌiꞌahwanoiya, ꞌigwae, “Tamagu, bewa tuwa ꞌigu tuta ꞌilatu pwaima ma taugu tuwa natuina sanigu ꞌuꞌabi hanehe ma ꞌoinega taugu wete saniu yaꞌabi hanehe. ");
INSERT INTO bdd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Weyahina loina mabwaiyana tomota weyahidi ꞌuꞌebwaya pwaigauwa ma taugu yawasidi miyamiya hatayana baibaiwadi yaꞌebwaedi, tomotaedi ꞌuꞌebwaegauwa ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yawasiina miyamiya hatayana bewa gidemusa ꞌina ꞌeda: Ceguma tomota sisanapugo ꞌabehega ꞌowa moisa Yehoba, ma wete ꞌeguma sisanapugau ꞌabehega taugu Toꞌabiheteguina ꞌowa ꞌuhesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gogo gabulena bewa ꞌoina saniu yaꞌabi hanehe pwaiya, weyahina paihowaedi ꞌuꞌebwaegauwa yapaihowa pwaidiya. ");
INSERT INTO bdd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Coinega Tamagu, bewa tuwa matauwa sanigu ꞌuꞌabi hanehe, gidemusa mwalona tuwa ꞌowa ma taugu ꞌida wasawasaina, muliyetega ꞌabwa gogo gabulena ꞌilatuma. ");
INSERT INTO bdd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tamagu, mumugau mabwaiyana yaheꞌita pwaidiya taudi tomotaedi gogo gabulena ꞌoina ꞌuꞌebwaegauwa ꞌoidiya. Ma wete ꞌenau mabwaiyana siꞌobigaiya, weyahina tomotaedi ꞌowa ꞌuꞌebwaegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ginaulaedi mabwaiyadi ꞌuꞌebwaegauwa sisanapu pwaidiya ꞌabehega mabwaiyadi ꞌowa ꞌoiuwega sitauyama. ");
INSERT INTO bdd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Weyahina gwaeyedi ꞌuꞌebwaegauwa yaheꞌita pwaidiya ma wete sihemiseya. Coinega sisanapu bwaibwainigauwa ꞌabehega ꞌowa moisa ꞌoiuwega yatauyama ma wete sihemisaegauwa ꞌabehega ꞌowa ꞌuhesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Coinega bewa tuwa weyahidi yaꞌahwa ꞌahwanoiwa ꞌoiuwa. Ta geya ꞌabehega mebaleꞌu weyahidi, ma hesi tomotaedi taudi ꞌuꞌebwaegauwa weyahidi, weyahina taudi ꞌino tomotaiyao. ");
INSERT INTO bdd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Weyahina toꞌaha gidemusa ꞌoiguwa simiyamiya, ꞌowa mabwaiyana ꞌino ꞌebeloinao. Ma wete ꞌowa toꞌaha gidemusa ꞌoiuwa simiyamiya, mabwaiyana taugu ꞌigu ꞌebeloinao, ma ꞌoidiyega sanigu ꞌihemadou pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sauga ꞌiꞌiunamo ma yalohihilawa ꞌoiuwa, nata geyaꞌabwa baleꞌu bewa wete ꞌoina yamiyamiya. Ma hesiyage tomotaedi taudi ꞌuꞌebwaegauwa nata tuwa baleꞌu bewa ꞌoina simiyamiya. Tamagu, ꞌowa moisa saniu heheꞌasisiyanaina, ꞌoinega bewa tuwa yaꞌahwaꞌahwanoi ꞌoiuwa ma tomotaedi ꞌowa ꞌino waiwai ꞌoinega ꞌuꞌitayahidi ma ꞌoinega siheboda ꞌaigeda, tuwa gide ꞌowa ma taugu huhunida ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Weyahina tutaina taugu mahetediu, ꞌowa ꞌino waiwai ꞌoinega yaꞌitaꞌita yahidi. Waiwaiina ꞌowa ꞌuꞌebwaegauwa ꞌoinega yaꞌitaꞌita yahidi. Ma Tamagu, boꞌiyage ꞌusanapu pwaiya beno tomotaedi ꞌuꞌebwaegauwa, geya ꞌeta taiya ꞌoidiyega yaheꞌwaihi. Beno tuwa loheyaina ꞌino buki ꞌoina lele ꞌimiyamiya ꞌabehega tauna ꞌiꞌwaiha, loheyainaina ꞌiboinamo ꞌihesilae. ");
INSERT INTO bdd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ma hesiyage taugu ꞌiꞌiunamo ma yahilawa ꞌoiuwa, ma ꞌigu gwaeyedi yagwaenediya ꞌigu tomotaiyao gogo gabulena ꞌoidiya, ma ꞌoinega ꞌigu yaliyayega sida yaliyaya madouna. ");
INSERT INTO bdd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cino gwaeyedi yaꞌebwaya pwaidiya, ma hesiyage mebaleꞌu ꞌino tomotaedi silogwahatediya. Weyahina taudi mebaleꞌu ꞌidi boda geya ꞌoina simiyamiya. Taugu tuwa wete gidemusa mebaleꞌu geya ꞌidi boda ꞌoina yamiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma geya ꞌabehega yaꞌahwaꞌahwanoi ma baleꞌuwega ꞌuꞌewa yahuledi, ma hesi nuwanuwagu ma ꞌabehega togalaina ꞌoinega ꞌuꞌahu suꞌwasuꞌwanidi. ");
INSERT INTO bdd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taudi geya mebaleꞌu ꞌidi boda ꞌoina simiyamiya, gide wete taugu. ");
INSERT INTO bdd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Taudi weyahidi yaꞌahwaꞌahwanoi ꞌoiuwa ma ꞌino gwae moisanega ꞌuꞌabihe bwebweꞌanidi ma ꞌoinega ꞌino bodao ꞌehaudi taudi. ");
INSERT INTO bdd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tuwa gidemusa ꞌowa ꞌuhesumanegauma baleꞌu bewa ꞌoina ꞌoinega taugu wete gidemusa tomotaedi yahesumanedi tomiya baleꞌu ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tomotaedi weyahidi yatagwalegauwa ꞌoiuwa ma ꞌoinega sauga ꞌinaonaoma ꞌoina taudi wete sitagwaledi moisa ꞌoiuwa. ");
INSERT INTO bdd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tamagu, geya ꞌabehega taudi siboi weyahidi yaꞌahwa ꞌahwanoiwa, ma hesiyage taudi ꞌabwa nata ꞌidi gwae ꞌoidiyega sihemisaegau, taudi wete weyahidi yaꞌahwa ꞌahwanoiwa. ");
INSERT INTO bdd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yaꞌahwaꞌahwanoi ꞌoiuwa ma ꞌabehega mabwaiyadi sida heboda ꞌaigeda ꞌoida, gide ꞌowa ma taugu ꞌaigeda tuwa. Ma ꞌoinega mebaleꞌu sihemisaegau ꞌabehega ꞌowa moisa ꞌuhesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mwalona ꞌino wasawasaina bwebweꞌanaina ꞌuꞌebwaegauwa, taudi wete gide yaꞌebwae pwaidiya, ma ꞌoinega mabwaiyadi sida heboda ꞌaigeda. Gidemusa ꞌowa ma taugu ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Taugu moisa ꞌoidiya yamiyamiya ma ꞌowa wete gide ꞌoiguwa ꞌumiyamiya, ma ꞌoinega sida heboda ꞌaigeda bwaibwaina. Ma ꞌoinega mebaleꞌu siꞌitadi ma sida sanapugau ꞌabehega ꞌowa moisa ꞌuhesumanegauma. Ma wete sisanapugo ꞌabehega moisa ꞌuhelauwediya gidemusa ꞌuhelauwegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamagu, tomotaedi ꞌuꞌebwaegauwa, nuwanuwagu ma ꞌasainaina ꞌoina yatautauya taudi wete ꞌasainaina ꞌoina mahetegwao ꞌada miyamiya ma ꞌoinega ꞌigu wasawasaina ꞌuꞌebwaegauwa nage ꞌoina siꞌita. Weyahina muliyetega ma baleꞌu bewa ꞌupaihoweya, taugu ꞌuhelauwe nugetegauwa. ");
INSERT INTO bdd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamagu, ꞌowa moisa bwebweꞌau. Ma hesiyage mebaleꞌu geya sisanapugo, yaboi hesi yasanasanapugo. Ma wete tomotaedi sisanapugauwa ꞌabehega ꞌowa ꞌuhesumanegauma. ");
INSERT INTO bdd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Coinega mumugau yaheꞌita pwaiyeya ꞌoidiya, ma ꞌabwa nata wete yaheꞌite hiladi, ma ꞌoinega ꞌino helauina ꞌateguwa ꞌimiyamiya taudi ꞌatediya wete gidemusa ꞌida miyamiya, ma taugu wete ꞌoidiya yada miyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ꞌina ꞌahwanoi mulina, maꞌana tomuliyao sitauya papali ꞌaigeda sanina Kidiloni weꞌahina sihabaleya, ma Olibe tanohina ꞌoina siluhuwa. ");
INSERT INTO bdd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Yudasaina totebaina tupwaina ꞌisanapu bwaibwainiya. Weyahina sauga baibaiwana Yesu maꞌana tomuliyao ꞌoina sitautau. ");
INSERT INTO bdd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Coinega Yudasa toloꞌalehaowedi baꞌidanao sinao tupwaina ꞌoina, maꞌidi wodam ma mayale, ma wete maꞌidi gwegwe ꞌaleha. Ma toloꞌalehaowedi ꞌadi tohewasao taudi topwaoli ma Palisiyao. ");
INSERT INTO bdd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma hesi Yesu ginaula mabwaiyadi ꞌisanapu nugetediya toꞌaha nata ꞌoina ꞌilatu. Coinega Yesu ꞌinaowa toloꞌalehaedi ꞌoidiya ma ꞌihesilalediya ꞌigwae, “Taiya waꞌebeꞌebese?” ");
INSERT INTO bdd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma taudi sigwae, “Caigeda Nasaleta loheyaina, sanina Yesu.” Coinega Yesu ꞌihegwae hilediya, “Taugu!” Ma totebaina toloꞌalehaowedi baꞌidadiu sitohotoholo. ");
INSERT INTO bdd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sauga nage ꞌoina tutaina Yesu ꞌigwaeya, “Taugu,” beno ꞌoina toloꞌalehaedi tupwana sihutu hila ma sibeꞌuwa baleꞌuwa. ");
INSERT INTO bdd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Muliyetega toloꞌalehaedi baleꞌuwega sitoholo hila, ma Yesuina wete ꞌihegwae hilediya ꞌigwae, “Taiya waꞌebeꞌebese?” Coinega taudi sigwae, “Nasaleta loheyaina ꞌaigeda, sanina Yesu.” ");
INSERT INTO bdd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Coinega wete ꞌihegwae hilediya ꞌigwae, “Nige yahegwae pwaigomiya, taugu. Ma ꞌeguma taugu moisa wabesebesegau, hede ꞌagu tomuliyaowedi bewa watagwaledi ma sitauya ꞌidi ꞌasa.” ");
INSERT INTO bdd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu gwae bewa ꞌiꞌinaneya ma ꞌoinega ꞌina ꞌahwanoiina Tamana ꞌoina ꞌana moisa ꞌilatu bwaibwaina, tutaina ꞌigwae, “Tamagu, loheloheyaowedi ꞌuꞌebwaegauwa geya ꞌeta taiya ꞌoidiyega yaheꞌwaihi.” ");
INSERT INTO bdd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma Saimoni Pita Yesu deina ꞌitotoholo ꞌina ꞌelepa ꞌaleha tolobwanega ꞌilisi ꞌeweya, ma Topwaoli Madouna ꞌina topaihowa tenana ꞌebeulega ꞌiꞌupwa yahuleya. Topaihowaina sanina Maleko. ");
INSERT INTO bdd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Coinega Yesu Saimoni Pita ꞌihegwaeya ꞌigwae, “Cino ꞌelepa ꞌaleha ꞌana ꞌebe laguwa ꞌulagu hila, sahena ꞌagu muya biyoina ꞌusuꞌwasuꞌwani. Weyahina biyo bewa Tamagu ꞌiꞌebwaegauwa ma ꞌabehega yanuma.” ");
INSERT INTO bdd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nage ꞌoina toloꞌalehaowedi maꞌidi tohanugetao ma wete meYudiya ꞌidi hewahewaliyao Yesu siꞌabi yahiya ma nimana sipaiya. ");
INSERT INTO bdd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nugeta sitauyeya Anasa ꞌina hada. Anasa tauna Kaiyapa bwahiyana. Bolime nage ꞌoina Kaiyapaina tauna topwaoliyao ꞌidi taubada madouna. ");
INSERT INTO bdd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tauna tuwa Kaiyapaina mwalona meYudiya ꞌihegwaediya ꞌabehega ꞌilobwaineya ma loheya ꞌaigeda tuwa ꞌiꞌamasa tomota mabwaiyadi weyahidi. ");
INSERT INTO bdd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Coinega Yesu sitoeya ma ꞌana tomuliya ꞌeluwa boda simuliyedi. Taudi Saimoni Pita ma wete ꞌaigeda tomuliya tauna Topwaoli Madouna ꞌiyana. Coinega boda baꞌidadiyao siluhuwa Topwaoli Madouna ꞌina hada. ");
INSERT INTO bdd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita hesiyage geya ꞌiluhu hadai, ꞌatamana ꞌitotoholo. Muliyetega tomuliyaina tauna tuwa Topwaoli Madouna ꞌiyanaina ꞌilatuwa, ma wahine ꞌaigeda tauna ꞌahwaꞌeda ꞌana toꞌitayahina ꞌihegwaeya ma ꞌabehega Pita ꞌoina ꞌitagwala ma ꞌiluhu hadai. Coinega wahineina Pita ꞌitagwaleya ma ꞌiluhuwa hadai. ");
INSERT INTO bdd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nage ꞌoina wahineina Pita ꞌihegwaeya ꞌigwae, “Cowa nuwana Yesu ꞌana tomuliya ꞌaigeda, ꞌawa?” Ta Pitaina ꞌimwehihiya ꞌigwae, “Ciya, taugu hene geya!” ");
INSERT INTO bdd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ma sauga nage ꞌoina gogagogai ꞌana tuta, ꞌoinega topaihowa ma toloꞌalehaedi ꞌaiwe sihataliya ma ꞌoina simwaimwailu. Coinega Pitaina ꞌiꞌitediya simwaimwailu, ta wete tauna ꞌiluhuwa ꞌoidiya, ma mahetenao simwaimwailu. ");
INSERT INTO bdd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nage ꞌoina Topwaoli Madouna Yesu ꞌihesilaleya ꞌigwae, “Taiyawedi taudi ꞌa tomuliyaowedi? Ma wete togidega ꞌuheheꞌita ꞌesedi?” ");
INSERT INTO bdd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Coinega Yesu Topwaoli Madouna ꞌenana ꞌihemaiseya ꞌigwae, “Sauga mabwaiyana ꞌoidiya ꞌatamana ta hada tapwalolo ꞌoidiya ta Yehoba ꞌina Hada Heꞌasisi solana yaheheꞌita. Coinega meYudiya mabwaiyadi ꞌigu heꞌita sihesagohediya ta sisanapudiya. Weyahina ꞌigu heꞌita geya yada dahweya. Tuta mabwaiyana tomota matadiya yaheheꞌita. ");
INSERT INTO bdd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Coinega toꞌaha weyahina taudi geya ꞌoidiya wahesilala? Weyahina ꞌigu gwae mabwaiyadi taudi sihesagoha pwaidiya toꞌaha ꞌigu hegwaegwae ꞌoidiya mabwaiyana sisanasanapudi.” ");
INSERT INTO bdd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu ꞌina hemaisao ꞌihepwailediya ꞌigumwala, ꞌoinega ꞌaigeda toloꞌaleha deina ꞌitoholo ma nimana ꞌoinega Yesu ꞌiꞌahu nahenaheya, ma ꞌihegwaeya, ꞌigwae, “Taiya ꞌowa nige Topwaoli Madouna ꞌoina bewa gidemusa ꞌugwae ꞌesa?” ");
INSERT INTO bdd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Coinega Yesu loheyaina ꞌenana ꞌihemaiseya, ꞌigwae, “Ceguma moisa ꞌusanapuya ꞌabehega yagwae puiya, bewa tuwa ꞌigu gwae puiina ꞌugwae latuhe. Ma ꞌeguma ꞌigu gwae bwebweꞌadi, toꞌaha weyahina ꞌuꞌahu nahenahegauwa?” ");
INSERT INTO bdd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Coinega Anasa Yesu maꞌana pai ꞌihesumane hileya ma ꞌilohihila Topwaoli Madouna ꞌoina, sanina Kaiyapa. ");
INSERT INTO bdd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma Pitaina ꞌabwa ꞌaiweina ꞌoina ꞌimwaimwailu bodaedi mahetediu ma sihesilaleya sigwae, “Cowa nuwana ꞌaigeda bewa loheyaina ꞌana tomuliya, ꞌawa?” Ma Pitaina wete ꞌimwehihi hila ꞌigwae, “Ciya, taugu hene geya.” ");
INSERT INTO bdd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Coinega Topwaoli Madouna ꞌina topaihowa ꞌaigeda, tauna mwalo Pita loheyaina ꞌaneyage tenana ꞌiꞌupweꞌupweya ꞌina susu ꞌaigeda, ꞌihegwaeya Pitaina ꞌigwae, “Cowa nuwana mahetena Olibe tanohina ꞌoina yaꞌitegomiya mwalo, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta Pitaina wete ꞌimwehihi hila ꞌigwae, “Ciya, geya.” Tuwa beno ma ꞌamꞌam loheyana ꞌidouwa. ");
INSERT INTO bdd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Coinega Yesu Kaiyapa ꞌina hadega sitoehileya ma sitauyeya toloina madouna tauna Loma loheyaina sanina Pailato ꞌina hada ꞌoina. Silatuwa ma gona ꞌiꞌadaleya. Coinega meYudiyaedi geya sawasawahidi ma toloinaina ꞌina hada ꞌoina siluhu. Weyahina mumugadi ꞌeguma nuwanuwadi ma Hataona Guyaina siꞌai, geyaꞌabwa meLoma ꞌidi hada ꞌoina siluhuluhu, beno taudi ꞌidi heꞌasisi. ");
INSERT INTO bdd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Beno ꞌoinega Pailato ꞌilatuwa ꞌatamana ma ꞌihesilalediya ꞌigwae, “Togidega ꞌimi nuwatuhu loheya bewa ꞌana heꞌewa weyahina, hana wagwae ma yahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Coinega meYudiyaedi sihemaiseya sigwae, “Loheya bewa ꞌeguma moisa geya ꞌina puimo, geyaꞌabwa wete ꞌatoetoeyama ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma Pailatoina wete ꞌihegwae hilediya ꞌigwae, “Hede ꞌomi wanaoma watoe ma watauye nobwa waboi ꞌimi loina ꞌoidiyega waheyatalae.” Coinega meYudiyaedi sigwae, “Geya ꞌeta wete ꞌama tagwala ma ꞌeta taiya ꞌina ꞌamasa weyahina ꞌaloina ma ꞌaloheꞌamasi.” ");
INSERT INTO bdd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gwae bewa ꞌilatuwa ma ꞌoinega Yesuina ꞌina gwaeina ꞌina ꞌamasa weyahina ꞌana moisa ꞌilatu bwaibwaina, beno mwalona ꞌigwaeya togidega nata ꞌiꞌamasa ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Coinega Pailato ꞌiluhu hila ꞌina ꞌebe miyaina ꞌoina ma Yesu ꞌibwauweya ꞌiluhuwa ma ꞌihesilaleya ꞌigwae, “Cowa moisa meYudiya ꞌidi kini?” ");
INSERT INTO bdd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Coinega Yesuina Pailato ꞌenana ꞌihemaiseya ꞌigwae, “Cino hesilalaina ꞌowa tuwa ꞌuboi ꞌoiuwega bo ꞌeta taiyawedi weyahigu sihegwaegwaeya ꞌoiuwa?” ");
INSERT INTO bdd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma Pailato ꞌigwaeya, “Cino nuwatuhu ꞌabehega taugu Yudiya loheyaina? Cowa hene ꞌuboi ꞌino bodao maꞌidi topwaoli ꞌidi babadao sitoegoma, ꞌoinega ꞌuhepwaila bwaibwaina toꞌaha ꞌino pui?” ");
INSERT INTO bdd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma Yesu ꞌigwaeya, “Baleꞌu bewa taugu geya ꞌigu ꞌebeloina. Weyahina taugu ꞌeguma moisa baleꞌu bewa ꞌigu ꞌebeloina, ꞌagu tomuliyaedi sawasawahidi ma weyahigu silosabilau ma meYudiya geyaꞌabwa siꞌabiꞌabi yahigau. Ta moisa tuwa, baleꞌu bewa taugu geya ꞌigu ꞌebeloina.” ");
INSERT INTO bdd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Coinega Pailatoina Yesu wete ꞌihesilala hileya ꞌigwae, “Cabehega ꞌowa ꞌaigeda kini?” Ma Yesu ꞌigwae, “Beno tuwa ꞌugwae pwaiya, weyahina yaliꞌuma ta baleꞌu bewa ꞌoina yatauyama ginaula bewa weyahina, ma ꞌoinega sanapu moisa weyahina yahetohepwaila, ma taiyawedi ꞌeguma sanapu moisaina sihemisae ma siꞌabiyahi, taudi beno ꞌenagu ꞌana tohesagohao moisa.” ");
INSERT INTO bdd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Coinega Pailatoina wete Yesu ꞌoina ꞌihesilala, ꞌigwae, “Toꞌaha sanina sanapu moisa?” Pailato ꞌihesilala ꞌigumwala, ma ꞌilatuwa ꞌatamana, ta meYudiyaedi ꞌihegwaediya ꞌigwae, “Loheya bewa geya ꞌeta wete pui ꞌoinega yaloba. ");
INSERT INTO bdd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma hesiyage ꞌomi tuta mabwaiyana ꞌoidiya mumugami ma ꞌabehega Hataona Guyaina ꞌaigeda ꞌaigeda ꞌadi tuta ꞌoidiya, deli ꞌadi tomiya ꞌoidiyega ꞌaigeda loheya yalihasi weyahimi. Coinega togidega ꞌimi nuwatuhu, meYudiya ꞌimi kini bewa ꞌoimiya yalihasi?” ");
INSERT INTO bdd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Coinega bodaedi mabwaiyadi siꞌapu lagata ma ꞌenadi madounega sigwaeya, “Geya, tauna sahena ꞌulihalihasi, nuwanuwama Balabasa hesi ꞌulihasi weyahima.” (Balabasaina tauna toyagaha.) ");
INSERT INTO bdd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Coinega Pailato Yesu ꞌitoeya ꞌinaowa ꞌina toloꞌalehaedi ꞌiꞌebwaediya ma gulahega sisapiya. ");
INSERT INTO bdd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Muliyetega toloꞌalehaedi talitali siꞌeweya, Yesu ꞌana talatala sipaihoweya, ma Yesu debana silaguya. Cabwa wete ꞌaigeda ꞌaleꞌo wasawasa bwehabwehalina siꞌeweya ma siheꞌoteya. ");
INSERT INTO bdd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Coinega sinaowa deina ma sigwae lotuyaneya, sigwae, “MeYudiya ꞌidi kini yo, yauwedo.” Ma wete nimadiyega sisapiya. ");
INSERT INTO bdd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Pailato ꞌilatu hila ma bodaedi ꞌihegwaediya, ꞌigwae, “Loheya bewa yatoeyama ꞌoimiya, ma waboi matamiyega waꞌita ma wasanasanapu ꞌabehega geya ꞌeta wete pui ꞌoinega yaloba toho.” ");
INSERT INTO bdd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Coinega Yesu maꞌana talatala, ma wete maꞌana ꞌaleꞌo wasawasa bwehabwehalina ꞌilatuwa ꞌatamana, ma Pailatoina wete bodaedi ꞌihegwaediya ꞌigwae, “Bewa tauna loheyainaina waꞌita!” ");
INSERT INTO bdd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nage ꞌoina topwaoliyao ꞌidi ꞌinapwanao ma wete ꞌidi topaihowao Yesu siꞌiteya, ꞌoinega ꞌenadi madounega sibwauwa, sigwae, “Kelose ꞌoina watutu hepaꞌine!” Coinega Pailatoina ꞌihegwaediya, ꞌigwae, “Hede ꞌomi wanaoma watoe watauye ma watutu hepaꞌine, weyahina taugu geya ꞌeta ꞌina pui yaloba toho.” ");
INSERT INTO bdd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Coinega meYudiyaedi sigwae, “Tauma ꞌima loina ꞌabehega bewa tuwa ꞌida ꞌamasa. Weyahina ꞌiꞌabowa ꞌabehega tauna Yehoba natuna.” ");
INSERT INTO bdd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cidi gwaeina Pailato ꞌihesagoheya eeta ꞌimatauta madouna. ");
INSERT INTO bdd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Coinega Yesu ꞌitoehileya ma siluhuwa ꞌina hada ꞌoina, ma ꞌihesilaleya ꞌigwae, “Cowa taꞌehega ꞌutauyama?” Ma hesiyage Yesuina geya ꞌeta toꞌaha ꞌigwaene. ");
INSERT INTO bdd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Coinega Pailatoina wete ꞌihesilala hileya ꞌigwae, “Toꞌaha weyahina ꞌigu hesilala geya ꞌuhemaisa? Geya ꞌusanapu ꞌabehega taugu sawasawahigu ma yaloinaego? Ceguma yagwae silihasigo, nata wete lihasa ꞌuloba, ma ꞌeguma yagwae siloheꞌamasigo, nata wete tuwa siloheꞌamasigo.” ");
INSERT INTO bdd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta Yesu Pailato ꞌihegwaeya ꞌigwae, “Geya ꞌeta wete ꞌino loina ꞌoiguwa ꞌimiyamiya, ꞌeguma Yehoba geya ꞌoiuwa ꞌitagwala. Ma hesiyage ꞌuda sanapu ꞌabehega loheyaina tauna ꞌiheꞌebwayaegauma ꞌino loina ꞌoina, ꞌina pui gala hedadena, ꞌabwa ꞌowa ꞌino pui.” ");
INSERT INTO bdd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailatoina Yesu ꞌina gwae gidemusa ꞌihesagoha ꞌeseya, ꞌoinega nuwanuwana madouna Yesu ꞌilihasi. Ma hesiyage meYudiyaedi geya nuwadi, ꞌoinega mabwaiyadi ꞌenadi madounega sigwaeya, “Yesu ꞌeguma ꞌulihasi, ꞌowa geya Sisa ꞌiyana. Weyahina loheya beno ꞌiꞌabowa ꞌabehega tauna kini ꞌaigeda, ma hesiyage Sisa ꞌiboinamo kini. Coinega tasanapuya ꞌabehega tauna Sisa ꞌana ꞌaleha.” ");
INSERT INTO bdd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailato gwae bewa gidemusa ꞌihesagoha ꞌeseya, ꞌoinega Yesu ꞌilatuheya ꞌatamana, ma Pailato ꞌebeloina bwasaina ꞌoina ꞌimiyatoiya. Bwasaina ꞌane daꞌule ꞌoinega sipaihoweya ma sibwauweya Gabata, beno meYudiya ꞌenadi. ");
INSERT INTO bdd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tuta nage ꞌoina ꞌasu diladila gamwana ꞌoina. Cabwa ꞌiꞌadale hali sabwelo ꞌoina Hataona Guyaina siꞌai. Tutaina ꞌoina Pailato meYudiya ꞌihegwaediya ꞌigwae, “Waꞌita, loheya bewa tauna ꞌimi kini.” ");
INSERT INTO bdd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma taudi sigwae, “Geya, watauya kelose ꞌoina watutu hepaꞌine.” Coinega Pailatoina wete ꞌihesilala hilediya ꞌigwae, “Togidega ta ꞌimi kini ma ꞌabehega ꞌaloheꞌamasi?” Coinega topwaoliyao ꞌidi babadao sigwae, “Tauma hene Sisa ꞌiboinamo ꞌima kini, geya ꞌeta wete taiya.” ");
INSERT INTO bdd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eeta Pailatoina ꞌitagwala ꞌoidiya ma Yesu Kolose ꞌoina situtu hepaꞌine. Coinega toloꞌalehaedi Yesu siꞌabi yahiya ma sitauyeya. ");
INSERT INTO bdd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sitauyeya ma Yesu ꞌiboinamo ꞌana kelose ꞌiꞌahaliya, ma toloꞌalehaedi mahetenao sitauya ꞌasa ꞌaigeda sanina Bulubulu ꞌoina, ma hesiyage sanina meYudiya ꞌenadiyega sigwae Goligota. ");
INSERT INTO bdd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Casainaina ꞌoina Yesu situtu hepaꞌineya ꞌana kelose ꞌoina. Ma ꞌana keloseina deina loheloheya siteluwa wete situtu hepaꞌinediya ꞌadi kelose ꞌoidiya, loheya ꞌaigeda ꞌina ꞌebeulega ma ꞌaigeda ꞌina ꞌadigeyegeyega, ma Yesu gamwagamwana. ");
INSERT INTO bdd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yesuina ꞌana kelose debana Pailato gwae ꞌileleya ma ꞌiꞌahu hepaꞌineya ꞌigwae, “Yesu gwama Nasaleta tauna meYudiya ꞌidi kini.” ");
INSERT INTO bdd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Casainaina ꞌoina Yesu siꞌabi hekeloseyeya geya bwaga Yelusalema ꞌoinega. Coinega meYudiya baibaiwadi gwaeina sihasiliya, weyahina gwaeina sileleya ꞌena ꞌetoi ꞌoidiyega. MeYudiya ꞌenadiyega ma meLoma ꞌenadiyega ma wete meGilisi ꞌenadiyega. ");
INSERT INTO bdd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Coinega topwaoliyao ꞌidi babadao sitauya Pailato sihegwaeya sigwae, “Cinapwana, toꞌaha weyahina ‘MeYudiya ꞌidi kini’ ꞌuleleya? Ma hesiyage ꞌuda lele ꞌugwae, ‘Loheya bewa ꞌigwaeya ꞌabehega tauna meYudiya ꞌidi kini.’” ");
INSERT INTO bdd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Coinega Pailato babadaedi ꞌihegwaediya ꞌigwae, “Nata geya wete yalagulagu lohihili, tuwa nage gidemusa ꞌimiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Muliyetega toloꞌalehaedi taudi Yesu siꞌabi hekeloseyeya sitehataedi Yesuina ꞌana ꞌaleꞌo siꞌewediya ma siboidimo ꞌoidiya siheguyaiyeya. Cana hewanu wete siꞌeweya ma sigwae, “Caleꞌo bewa tabataba hedadena ma wete saliyana, geya ꞌana tubwemo. Coinega nata geyaꞌabwa tahahaigaigali, ma hesiyage ꞌeꞌopiꞌopi ꞌaigeda tapaihowa gidemusa kati. Ma ꞌoinega ꞌeguma taiya ꞌinugeta hewanu bewa ꞌiꞌewa.” ");
INSERT INTO bdd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nuwatuhu bewa gidemusa sipaihowa ꞌeseya, ma ꞌoinega Yehoba ꞌina Buki Heꞌasisi ꞌoina gwaeina ꞌana moisa ꞌilatu bwaibwaina, tutaina ꞌigwae, “Cagu ꞌaleꞌo siheguyaiyediya, ma hesi ꞌagu hewanu siꞌeꞌopiꞌopiyediya.” Ma ꞌina gwaeina bewa gidemusa moisa tuwa toloꞌalehaedi sipaihowa ꞌeseya. ");
INSERT INTO bdd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma Yesuina ꞌana kelose deina wahiwahine sitehata sitotoholo, taudi beno Yesu sinana matasina, ma wete hali Meli tauna Kilopa mwanena, ma wete Meli Magidala. ");
INSERT INTO bdd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta Yesu ꞌiꞌita suluwa sinana ma wete ꞌana tomuliya tauna ꞌihelauweya madouna sitotoholo, ꞌoinega sinanaina ꞌihegwaeya ꞌigwae, “Sinagu, loheya beno natuu.” ");
INSERT INTO bdd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yesu loheyaina wete gidemusa ꞌihegwae ꞌeseya ꞌigwae, “Ciyagu, sinau beno.” Coinega Yesuina ꞌina ꞌamasa mulina, loheyaina Yesu sinana ꞌitoeya ꞌina hada ma ꞌiꞌitayahiya. ");
INSERT INTO bdd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tuta nage ꞌoina Yesu ꞌisanapuya ꞌabehega ginaula mabwaiyana ꞌilohegumwalidiya, ꞌoinega ꞌigwaeya, “Taniꞌogu ꞌiyahala.” Ma ꞌoinega Yehoba ꞌina buki ꞌina gwaeina ꞌana moisa ꞌilatu bwaibwaina. ");
INSERT INTO bdd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tupwaina ꞌoina weꞌaha payupayuyuna, sanina waini, mabiyona silaguya ꞌimiyamiya. Coinega balou siꞌeweya, weꞌahina ꞌoina sihebuteya, ma ꞌaiwe ꞌaigeda sanina hisopa ꞌoina siꞌatubadiyeya, ma siꞌeyoyowe haneheya Yesu sopana ma ꞌabehega ꞌimalaꞌuꞌu. ");
INSERT INTO bdd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cimalaꞌuꞌu ꞌigumwala ma ꞌigwae, “Cigumwala pwaiya.” Tuwa beno ma mwaguna ꞌilotasouwa, ꞌisuluwa ꞌahalana, ma yawasina ꞌigumwala. ");
INSERT INTO bdd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma meYudiyaedi ꞌidi tohanugetao Pailato ꞌoina siꞌahwanoiya, ma ꞌeguma sawasawahina ꞌitagwala ꞌoidiya ma loheloheyaedi kelose ꞌoidiya sisanasanana ꞌahedi silasadi, ma ꞌoinega siꞌamasa mwayamwayau, eeta ꞌadi kelose ꞌoidiyega siꞌahala suluhedi. Weyahina sisanapuya ꞌidi sabwelo madouna ꞌihohoya, ꞌoinega geya nuwadi ma ꞌabehega loheloheyaedi ꞌadi kelose ꞌoidiya sisanasanana ꞌidi Sabatinaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Coinega toloꞌalehaedi Pailato ꞌoidiya ꞌitagwala ma sitauya keloseyedi ꞌoidiyega loheloheyaedi siteluwa ꞌahedi siꞌahu lasediya. Loheya ꞌaigeda ꞌahena silasediya ꞌigumwala, ma wete hali loheya ꞌahena silasediya. ");
INSERT INTO bdd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Muliyetega Yesu ꞌoina sitauyama, ma siꞌiteya yawasina ꞌigumwala pwaiya, ꞌoinega ꞌahena geya silasadi. ");
INSERT INTO bdd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Beno namo toloꞌaleha ꞌaigeda ꞌaliliya ꞌiꞌeweya ma Yesu lisulisuna ꞌibadiya, ma lisulisunega bweyaha ma weꞌaha sidauwa. ");
INSERT INTO bdd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Taugu tuwa mataguwega yaꞌiteya, ꞌoinega weyahidi ꞌoimiya yahehewasa, ma ꞌoinega gwaeyedi bewa moisadi wahesagohedi ma wahemisaedi. ");
INSERT INTO bdd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ginaulaedi bewa silatuma ma ꞌoinega Yehobaina ꞌina gwaeina ꞌina Buki Heꞌasisi ꞌoina ꞌihepwaileya, ꞌana moisa ꞌilatu bwaibwaina, tutaina ꞌigwae, “Geyaꞌabwa wete hilihiliyana silasalasadi.” ");
INSERT INTO bdd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yehoba ꞌina buki ꞌoina wete ꞌihepwaila ꞌigwaeya, “Cana tobadiyedi nata ꞌoina siꞌebubuna.” ");
INSERT INTO bdd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Muliyetega loheya ꞌaigeda sanina Yosepa ꞌitauyama Pailato ꞌoina ma Yesu wahina ꞌihetalamuya. Loheyainaina tauna Alimatiya loheyaina, tauna tuwa ꞌaigeda wete Yesu ꞌana tomuliya dahwadahwaina, weyahina meYudiya ꞌimatautediya. Coinega Pailato Yosepa ꞌoina ꞌitagwala, ma Yesu wahina kelose ꞌoinega ꞌiꞌahala suluheya ma ꞌitauyeya. ");
INSERT INTO bdd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Loheya ꞌaigeda wete ꞌitauyama, Yosepaina ꞌilemeya ma Yesu wahina siꞌahaliya. Loheyaina sanina Nikodimo, tauna tuwa mwalona nihuwanega ꞌitauya Yesu ꞌoina ma mahetena sihegwaegwaeya. Loheyainaina holowa ꞌaigeda mahaina bwebweꞌana ma wete madouna ma mwauna ꞌiꞌahaliyama, ꞌana mwauina gide loheya ꞌana mwau. Holowinaina solana, mulo ma alowesi mahetena sihebweliya. ");
INSERT INTO bdd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Eeta loheloheyaedi siteluwaedi Yesu wahina siꞌahaliya, ma holoina ꞌoinega wahinaina siheholoiya, ꞌabwa muliyetega ꞌaleꞌo waꞌewaꞌeꞌena ma dudulena siꞌeweya ma ꞌoinega wahina siwaduhiya holoina ꞌana tupwa mahetena siwaduha hegogoya. MeYudiya ꞌidi toꞌamasao ꞌadi hemiya taona gidemusa sipaihowa ꞌeseya. ");
INSERT INTO bdd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu ꞌina ꞌebe ꞌamasaina deina gogo ꞌaigeda ꞌimiyamiya. Gogoina ꞌoina galiha ꞌaigeda hauhauna ꞌimiyamiya, geya ꞌeta taiya toꞌamasa ꞌoina silagu toho. ");
INSERT INTO bdd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Coinega galihinaina ꞌoina Yesu wahina silaguya. Weyahina galihaina deidiya, ma wete sisanapuya ꞌabehega meYudiya ꞌidi Sabati madouna deina silatu pwaiya. ");
INSERT INTO bdd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wiki ꞌana sabwelo nugenugetaina gona ꞌadaꞌadale ꞌoina Meli Magidala ꞌitauya galiha ꞌiꞌiteya, ꞌana ꞌahusuꞌwana sibui wasiyeya. ");
INSERT INTO bdd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Coinega ꞌipili lohihila Yesu ꞌana tomuliyaowedi ꞌihegwaediya ꞌigwae, “Cinapwana galihega siꞌeweya ma taꞌeha nana silaguya, geya tosanapunamo.” Tomuliyaedi beno Saimoni Pita ma loheyaina tauna Yesu ꞌiyana moisa. ");
INSERT INTO bdd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Coinega siteluwaedi sigogona sitauya galihina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cidi tauyaina ꞌoina sipiliyamowa, ma loheyaina tauna Yesu ꞌiyanaina moisa galihina ꞌoina ꞌilatu nugeta ");
INSERT INTO bdd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ma galihina ꞌoina ꞌiꞌetuluha ꞌiꞌita luhuwa galihinamo, beno ꞌaleꞌodimo siꞌenoꞌeno. Loheyainaina galihina ꞌoina geya ꞌiluhu. ");
INSERT INTO bdd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Muliyetega Saimoni Pita ꞌipili latuwa, ta dumwaluna galihina ꞌoina ꞌiluhuwa, ma wete ꞌiꞌiteya galihinamo, ma hesiyage ꞌaleꞌowedi ꞌiꞌitediya siꞌenoꞌeno. ");
INSERT INTO bdd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Caleꞌowedi ꞌeluwa ꞌiꞌitediya, ꞌaigeda mwaguna ꞌana samu, ma ꞌaigeda wahina mabwaiyana ꞌana samu. Mwagunaina ꞌana samuina ꞌiꞌiteya tuwa losilosipwana, ma wete ꞌiꞌiteya wahinaina ꞌana samu ꞌoinega ꞌiꞌeno wasiya. ");
INSERT INTO bdd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Loheyaina tauna ꞌilatu nugeta galihina ꞌoina, ꞌiyanaina Pita mulinega wete ꞌiluhuwa galihina ꞌoina, ma ꞌaleꞌodimo wete ꞌiꞌitediya, ma ꞌiꞌahwa moisa. ");
INSERT INTO bdd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma hesiyage maꞌiyanaina geya Yehoba ꞌina gwaeina ꞌina buki ꞌoina sinuwatuhuyahi, tutaina ꞌigwaeya ꞌabehega ꞌabwa nata galihega ꞌitoholo hila. ");
INSERT INTO bdd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Coinega siteluwaedi silohihila ꞌidi hada. ");
INSERT INTO bdd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma hesiyage Meli ꞌabwa tuwa galihina ꞌoina ꞌitotoholo ma ꞌidoudou. Cidoudou ma ꞌiꞌetuluha galihina ꞌoina ");
INSERT INTO bdd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ꞌiꞌita luhuwa Yehoba ꞌina anelose ꞌeluwa simiyamiya Yesu ꞌina ꞌebeꞌenoina ꞌoina, maꞌadi ꞌaleꞌo waꞌewaꞌeꞌedi. Caigeda ꞌaba ꞌununega ma ꞌaigeda ꞌaba ꞌahenega. ");
INSERT INTO bdd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Siteluwaedi Meli sihegwaeya sigwae, “Toꞌaha weyahina ꞌudoudou?”. Ma Meli ꞌigwaeya, “Cigu Cinapwana galiha bewa ꞌoinega siꞌeweya ma taꞌeha nana silaguya, ma weyahina yadoudou.” ");
INSERT INTO bdd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Muliyetega Meli ꞌiꞌita lohihila Yesu deina ꞌitotoholo, ma ꞌiyamo geya ꞌisanapu toho ꞌabehega tauna Yesu. ");
INSERT INTO bdd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ta Yesu Meli ꞌihesilaleya ꞌigwae, “Taiya weyahina ꞌubesabesa ma ꞌudoudou?” Ma Meliina ꞌina nuwatuhu ꞌabehega tanoha ꞌana topaihowa ꞌaigeda, ꞌoinega ꞌihegwaeya ꞌigwae, “Cinapwana, ꞌeguma ꞌowa moisa ꞌuꞌeweya, bewa tuwa ꞌuhepwaile taꞌeha ꞌulaguya, ma yaꞌewa hila.” ");
INSERT INTO bdd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Muliyetega Yesu Meli sanina ꞌiꞌinaneya ꞌigwae, “Meli.” Meliina ꞌihutu lohihila, ma Yesu ꞌoina ꞌigwaeya, ꞌigwae, “Labonai.” (Labonai ꞌana sanapu ‘Toheꞌita.’) ");
INSERT INTO bdd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma Yesu ꞌihegwae hileya ꞌigwae, “Sahena ꞌuꞌabiꞌabi tohogau, weyahina ꞌabwa geya Tamagu ꞌoina yahane. Ma hesiyage ꞌutauya tasigwao ꞌoidiya, ma ꞌuhegwaedi ꞌabehega bewa tuwa taugu yahanehane Tamagu ꞌoina, tauna ꞌomi wete Tamamiu. Tauna taugu ꞌigu Yehoba ma ꞌomi wete ꞌimi Yehoba.” ");
INSERT INTO bdd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Coinega Meli Magidala ꞌitauya tomuliyaedi ꞌoidiya ma ꞌoidiya ꞌihepwaila ꞌigwae, “Cinapwana yaꞌiteya ꞌitoholo hila pwaiya.” Meli Yesuina ꞌenanaedi ꞌihepwaila latuhediya tomuliyaedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma wete wiki ꞌana sabwelo nugenugetaina lahilahiyega Yesu ꞌana tomuliyaowedi ꞌoidiya ꞌilatuwa. Tutaina ꞌoina, ꞌana tomuliyaedi hada ꞌaigeda ꞌoina siluhuwa ma siꞌeda gudu suꞌwasuꞌwana ma solana simiyamiya, weyahina meYudiya simatautediya. Coinega Yesu ꞌoidiya ꞌilatuwa ma gamwagamwanidiya ꞌitoholowa ma ꞌihegwaediya ꞌigwae, “Sahena waꞌateꞌate yoho.” ");
INSERT INTO bdd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Muliyetega nimana ma lisulisuna ꞌana tomuliyaedi ꞌiheꞌitediya. Beno ꞌoina ꞌana tomuliyaedi siꞌiteya ma siyaliyaya madouna, weyahina ꞌidi Cinapwanaina siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Coinega Yesu wete ꞌana tomuliyaedi ꞌihegwae hilediya ꞌigwae, “Waꞌate patu, sahena ꞌateyoho. Weyahina Tamagu tauna ꞌihesumanegauma, ꞌoinega taugu wete gidemusa ꞌomi yahesumanegemi.” ");
INSERT INTO bdd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cina gwaeina mulina, yawasina ꞌimuꞌa baleya ꞌoidiya, ma wete ꞌihegwaediya ꞌigwae, “Yaluyaluwa Heꞌasisi waꞌewa. ");
INSERT INTO bdd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ma ꞌoinega ꞌeguma tomota ꞌidi puiyao wanuwasamudi, nata Yehoba wete ꞌinuwasamudi. Ma ꞌeguma taiyawedi ꞌidi puiyao geya wanuwasamudi, nata ꞌoidiya simiya hataya.” ");
INSERT INTO bdd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tutaina beno ꞌoina Tomasi geya mahetediu ma Yesu ꞌilatuwa. Tomasiina tauna tuwa Yesu ꞌana tomuliya ꞌaigeda sitetuwelo ꞌoidiyega, sanina heluwena Didiluwaluwa. ");
INSERT INTO bdd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Coinega tutaina Tomasi ꞌilohihilama ꞌiyanaowedi sihegwaeya sigwae, “Ciyamai, tauma ꞌida Cinapwanaina ꞌaꞌiteya.” Ma hesi Tomasi ꞌiꞌahwa ꞌaboꞌabowediya, ꞌigwae, “Taugu ꞌeguma yaboi mataguwega ꞌana ꞌilaꞌilalaedi nimanaina ꞌoidiya situtudiya yaꞌitadi ma wete nimaguwega yaꞌabi tohodi, yaꞌahwa moisa. Ma wete ꞌeguma lisulisunaina sibadiya ꞌoina nimagu yalagu luhuwe, ꞌabwa hesi yaꞌahwa moisa.” ");
INSERT INTO bdd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Coinega wiki ꞌaigeda ꞌigumwala ma tomuliyaedi wete simiya ꞌautahila, hada ꞌaigeda solana siꞌedagudu hila simiyamiya, ma Yesuina ꞌoidiya ꞌilatu hila. Tuta bewa ꞌoina Tomasi mahetediu. Coinega Yesu ꞌoidiya ꞌilatuwa ma gamwagamwanidiya ꞌitoholowa ma ꞌihegwaediya ꞌigwae, “Sahena ꞌateyoho.” ");
INSERT INTO bdd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eeta Yesu Tomasi ꞌihegwaeya ꞌigwae, “Nimagu bewa ꞌuꞌitadi, ma nima ꞌuyamosiu ꞌebwa ꞌulagu ma ꞌagu ꞌilaꞌilala bewa ꞌuꞌabi tohodi. Ma wete nimau ꞌuyasi ꞌebwa ꞌagu badi lisulisuguina ꞌoina ꞌulagu luhuwe, ma ꞌuhemisaegau. Ma sahena ꞌahwa ꞌaboꞌabo.” ");
INSERT INTO bdd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Coinega Tomasi ꞌigwae hila, ma ꞌigwaeya, “Cowa moisa ꞌigu Badaina ma wete ꞌigu Yehobaina.” ");
INSERT INTO bdd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma Yesu ꞌigwaeya, “Tomasi, ꞌabwa hesi ꞌuꞌitegauwa ma ꞌuhemisaegauwa, ꞌawa? Ma hesiyage taiyawedi taudi ꞌeguma geya siꞌitegau ma sihemisaegau, nata moisa siyaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ꞌina ꞌilaꞌilala waiwaidi ꞌana tomuliyao matadiya ꞌipaihowediya, baibaiwa hedada simiyamiya, geya mabwaiyana buki bewa ꞌoina yaleledi. ");
INSERT INTO bdd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma hesiyage hisadimo tuwa bewa yalelediya ma ꞌoinega wahasilidi ma Yesu wasanapu ma wahemisae ꞌabehega tauna moisa Toꞌabihetena Yehoba natuna. Ma ꞌoinega Yesu saninega yawasimi miyamiya hatayana waloba. ");
INSERT INTO bdd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesu wete ꞌiboinamo ꞌiheꞌitae hileya ꞌana tomuliyao ꞌoidiya, tutaina Hola Taibiliya ꞌoina sigomagomana. 14. Cina latuina bewa hetoina ꞌana tomuliyaedi ꞌoidiya tutaina ꞌamasega ꞌitoholo hila. Bewa gidemusa ꞌilatu ꞌesa ꞌoidiya: ");
INSERT INTO bdd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tutaina ꞌoina Saimoni Pita, Tomasi tauna sanina Didiluwaluwa, Nataniyela tauna Kena loheyaina Galili tupwanega, ma Sebedi natunao, ma tomuliyao ꞌeluwa wete mahetediyao simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma Saimoni Pita ꞌiyanaowedi ꞌihegwaediya ꞌigwae, “Ciyagwao, yatautauya taugu yagomana.” Ma ꞌiyanaowedi sigwae, “Bwebweꞌana, tauma wete ꞌanaonaowa.” Coinega mabwaiyadi ꞌewou ꞌaigeda sigeluya ma siwoseya sitauya. Nihuwanaina beno ꞌoina, sigomana masaliya, ma ꞌiyamo geya ꞌeta silahana siꞌonatoho. ");
INSERT INTO bdd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gona ꞌiꞌadaleya, ma tomuliyaedi Yesu siꞌiteya ꞌoyaꞌoya ꞌitotoholo, ma ꞌiyamo geya siꞌinana toho ꞌabehega tauna Yesu. ");
INSERT INTO bdd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Coinega ꞌihegwaediya ꞌigwae, “Ciyagwao, hisa silahana waꞌonediya?” Ta taudi sigwae, “Geya ꞌeta silahana ꞌaꞌonatoho.” ");
INSERT INTO bdd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma wete ꞌihegwaediya ꞌigwae, “Cimi gomanina waꞌabi ma ꞌateyaniyega wayahuwe ma silahana waꞌonadi.” Coinega ꞌidi gomanaina siꞌabiya ma ꞌateyaniyega siyahuweya, ma silahana baibaiwadi siꞌonediya, ma gomana ꞌabina sigagadeya. ");
INSERT INTO bdd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Coinega loheyaina tauna Yesu ꞌiyana moisa Saimoni Pita ꞌihegwaeya ꞌigwae, “Ciyagu, nage tauna tuwa ꞌida Cinapwanaina.” Saimoni Pita gwae bewa ꞌihesagoheya, ma ꞌilomwayamwayauwa, ꞌana ꞌaleꞌo ꞌiꞌote hileya, weyahina tutaina ꞌoina ꞌiꞌelolowa ma ꞌigomagomana. Ee ꞌana ꞌaleꞌoina ꞌiꞌote hileya, ma ꞌiꞌeno hatuiya niꞌuwa, ma ꞌilaga ꞌoyaꞌoya. ");
INSERT INTO bdd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Muliyetega ꞌiyanaowedi mabwaiyadi wagega gomana masilahaina silisi lagaheya ꞌoyaꞌoya. Weyahina ꞌidi ꞌebe gomanaina ꞌoyaꞌoya deina. ");
INSERT INTO bdd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Silaga ꞌoyaꞌoya, siꞌiteya ꞌaiwe ꞌiꞌala ganiyala ꞌiꞌalaꞌalata ma wete ganiyalainaina ꞌoina siꞌiteya beledi ma silahana ꞌibwasabwasadi. ");
INSERT INTO bdd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Yesu ꞌihegwaediya ꞌigwae, “Ceta wete silahana waꞌewedima ma talagu baledi.” ");
INSERT INTO bdd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Coinega Saimoni Pita wagai ꞌigelu hila, ma gomana ꞌiꞌabi lagaheya ꞌoyaꞌoya. Gomanaina ꞌoina silahana ꞌimaha geyogeyoiya, silahanedi ꞌadi baibaiwa gide wani handeledi pipti teli (153) ma wete madomadoudimo. Ma ꞌiyamo gomanaina geya siꞌenosabu toho. ");
INSERT INTO bdd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma Yesu ꞌihegwaediya ꞌigwae, “Wanaoma waꞌai.” Beno ꞌoina ꞌabwa hesi sisanapu bwaibwainiya ꞌabehega tauna tuwa ꞌidi Cinapwanaina. Coinega geya ꞌeta toꞌaha wete ꞌoina sigwaene, bo nuwana ꞌihesilala ma ꞌigwae, “Taiya ꞌowa?” ");
INSERT INTO bdd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Coinega Yesu beledi ma silahana ꞌiꞌewediya ma ꞌana tomuliyaedi ꞌiꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tuta bewa ꞌoina Yesu ꞌiboinamo ꞌiheꞌitaeya hetoina ꞌana tomuliyaedi ꞌoidiya tutaina ꞌina ꞌamasa ꞌoinega ꞌitoholo hila. ");
INSERT INTO bdd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Silohepaꞌala ꞌigumwala, ma Yesu Saimoni Pita ꞌihegwaeya ꞌigwae, “Saimoni, Yoni natuna, ꞌowa moisa ꞌuhelauwegauwa ꞌabwa bewa taudi?” Coinega Saimoni ꞌigwae, “Cinapwana, ꞌusanapu pwaigauwa ꞌabehega moisa tuwa yahelauwegowa.” Ma Yesu Saimoni ꞌihegwaeya ꞌigwae, “Cigu lamiyao ꞌuꞌita yahidi.” ");
INSERT INTO bdd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Muliyetega Yesu Saimoni wete ꞌihesilala hileya ꞌigwae, “Saimoni, Yoni natuna, moisa ꞌuhelauwegauwa?” Coinega Saimoni wete ꞌigwae, “Cinapwana, ꞌusanapu pwaigauwa ꞌabehega yahelauwegowa.” Ma Yesu Saimoni ꞌihegwaeya ꞌigwae, “Cigu sipi ꞌuꞌita yahidi.” ");
INSERT INTO bdd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Coinega Yesu Saimoni Pita ꞌihesilaleya hetoina ꞌigwae, “Saimoni, Yoni natuna, ꞌuhelauwegauwa?” Ta Saimoni Pita nuwana ꞌigala weyahina Yesu ꞌina hesilala ꞌoina matoi, ꞌoinega Yesu ꞌenana ꞌihemaiseya ꞌigwae, “Cinapwana, ꞌowa ginaula mabwaiyana ꞌusanasanapudi, ma ꞌusanapu pwaigauwa ꞌabehega yahelauwegowa.” Coinega Yesu wete Saimoni Pita ꞌihegwaeya ꞌigwae, “Cigu sipi ꞌuꞌita yahidi. ");
INSERT INTO bdd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ma wete yagwae moisa ꞌoiuwa ꞌabehega ꞌino tuta gwama ꞌoina, ꞌuboi ꞌa ꞌaleꞌo ꞌuꞌoteꞌote, ma wete to ꞌasa ꞌoina ꞌeguma nuwanuwau, ma ꞌoina ꞌutau. Ma hesiyage tutaina ꞌeguma ꞌuheꞌinaꞌinapwana, nata nimau ꞌuyasidi ma tomota hagadi ꞌa ꞌaleꞌo siheꞌotego, ma wete to ꞌasa ꞌoina geya nuwau ma ꞌoina ꞌutauya, ꞌasainaina nata ꞌoina sitauyego.” ");
INSERT INTO bdd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gwae bewa ꞌoinega Pita ꞌina ꞌamasa weyahina Yesu ꞌilihasa, ma ꞌina ꞌamasaina ꞌoinega nata Yehoba sanina ꞌiꞌabi hanehe. Muliyetega Yesu Pita ꞌihegwae hileya ꞌigwae, “Cumuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma Pita ꞌiꞌita lohihila loheyaina tauna Yesu ꞌiyana moisa ꞌiꞌiteya. Loheyaina tauna mwalona ꞌidi ꞌai solana Yesu deina ꞌimiya toiya ma ꞌaneyage ꞌihegwaeya ꞌigwae, “Cinapwana, taiya tauna nata ꞌitebaego?” ");
INSERT INTO bdd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Loheyainaina tauna Pita ꞌiꞌiteya mulinega ꞌitautauya, ꞌoinega Pitaina loheyaina weyahina Yesu ꞌoina ꞌihegwaegwaeya ꞌigwae, “Cinapwana, loheya bewa togidega ꞌana loina?” ");
INSERT INTO bdd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Coinega Yesu Pita ꞌenana ꞌihemaiseya ꞌigwae, “Beno geya ꞌeta toꞌaha ꞌoiuwa, ma ꞌeguma nuwanuwagu ma loheyainaina tuwa ꞌimiyamiya ꞌana siga yahilama, nata wete gidemusa ꞌilatu ꞌesa. Ma hesiyage ꞌowa bewa tuwa ꞌumuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesu ꞌina gwaeina bewa ꞌana tomuliyaedi sihesagoheya ꞌoinega siboidimo ꞌoidiya sihegwaegwaeya weyahina ꞌidi nuwatuhu ꞌabehega tomuliyaina geyaꞌabwa ꞌiꞌamaꞌamasa. Ma hesiyage Yesu bewa geya gidemusa ꞌigwae ꞌesa. Ma hesi ꞌina gwaeina ꞌigwae, “Loheyainaina ꞌeguma nuwanuwagu ma ꞌimiyamiya ꞌana siga yahilama, beno geya ꞌeta toꞌaha ꞌoiuwa.” ");
INSERT INTO bdd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tomuliyainaina beno taugu tuwa ginaula bewa weyahidi yahehepwaila ma yalelediya heꞌoteꞌotetela bewa ꞌoina. Coinega tasanapuya ꞌabehega ꞌigu hepwaila mabwaiyana gwae moisadi. ");
INSERT INTO bdd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ꞌina paihowao baibaiwa hedadedi simiyamiya, ma ꞌeguma ꞌina paihowaedi mabwaiyadi taleledi, yanuwatuhuya nata baleꞌu bewa buki ꞌimaha geyogeyoi. ");
INSERT INTO bdd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Cae Tiyopilo, mwalo bukiina yalele nugeteya ꞌalona Yesu ꞌina paihowao ma ꞌina heꞌitao, ");
INSERT INTO bdd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tutaina ꞌina miya gogo gabulena ꞌana siga Yehoba ꞌitoe haneheya galewa, Yesuina ꞌina ꞌamasa mulina, mayawasina ꞌilatuwa ꞌana tohepwailao hesihesinuwadi ꞌoidiya, ta Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌadi loina ꞌiꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sabwelo poti ꞌalodiya ꞌilatulatu ꞌoidiya, ta ꞌebeꞌita baibaiwadi ꞌiheꞌitediya, ꞌoinega ꞌina toholohila siꞌahwa moiseya, ma Yehoba ꞌina loina weyahina ꞌiheꞌitediya. ");
INSERT INTO bdd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cabwa baꞌidadiu simiyamiya ta ꞌadi loina ꞌiꞌebwaediya, ꞌigwae, “Sahena Yelusalema waꞌebeꞌebesine, ma hesi Tamadai ꞌina gwae hemisaina mwalo yahegwaegomiya weyahina wayamwayamwa. ");
INSERT INTO bdd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wanuwatuhuyahi ꞌabehega Yoni weꞌahega ꞌiꞌabiꞌabihe babitaisowegomi ma sabwelo geya baibaiwana simiyamiya ma ꞌomi ꞌimi babitaiso Yaluyaluwa Tabuna ꞌoinega waloba.” ");
INSERT INTO bdd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Caigeda sauga Yesu ma ꞌana tomuliyao simiyaꞌauta, ma sihesilala ꞌoina, sigwae, “Bada, sowasowahina ma sauga bewa tauda meIsileli ꞌuhanugetegita ma taboidamo taloina hilegita?” ");
INSERT INTO bdd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma Yesu ꞌigwae, “Tamagu tauna ꞌiloiloina, ma geya sowasowahina ma ꞌomi wasanapu to sauga ꞌina loinaedi ꞌipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma ꞌomi hesi ꞌabwa Yaluyaluwa Tabuna ꞌinaowa ꞌoimiya ma ꞌiꞌabihe waiwaiyegomi, ma taugu weyahigu wahetohepwaila Yelusalema ꞌoina, ma Yudiya ma Sameliya gogonao mabwaiyadi ꞌoidiya, ta wete gogo gabulena mabwaiyana ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cina gwaeyaowedi bewa ꞌilosalohidiya, ta matadiyega Yesu siꞌiteya ꞌihane galewa, ma yaloha ꞌalona ꞌiꞌwaiha. ");
INSERT INTO bdd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ciꞌebesine pwaidiya, ta ꞌabwa hene siꞌeꞌebubuna galewa, ma loheya ꞌeluwa maꞌadi ꞌaleꞌo waꞌewaꞌeꞌedi deidiya sitoholo, ");
INSERT INTO bdd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ta sigwae, “MeGalili he, toꞌaha weyahina waꞌeꞌebubuna galewa? Yehoba Yesuina ꞌitoe pwaiya galewa, ma ꞌabwa ꞌisulu hilama, ma ꞌina suluma ꞌana ꞌita ꞌabwa gide ꞌina haneina nige waꞌiteya.” ");
INSERT INTO bdd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Coyaina sanina Olibe ꞌoinega sihila ta sitauya Yelusalema, beno geya bwaga, gide loheloheya siyawayawala sabwelo Sabati ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ta siluhuwa ꞌidi hada ta sihaneya ꞌaigeda tupwa ꞌaliupa ꞌoina, taudi Pita ma Yoni ma Yemesa ma Andulu ma Pilipi ma Tomasi ma Batolomiu ma Madiu ta hali Yemesa (tauna Alipiyo natuna), ma Saimoni (tauna mwalo toꞌohe Isileli ꞌina miyawasi Loma weyahina), ma Yudasa (tauna Yemesa natuna). ");
INSERT INTO bdd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mabwaiyadi bewa sabwelo ꞌaigeda ꞌaigeda ꞌoina ꞌidi ꞌatetagwala ꞌoinega siꞌahwaꞌahwanoi Yehoba ꞌoina, wahiwahine mahetediyao, ma Meli tauna Yesu sinana, ma Yesu tasinao wete mahetediyao. ");
INSERT INTO bdd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bodaedi ꞌadi baibaiwa gidemusa wani handeledi ma tuweniti, ma ꞌaigeda sabwelo ꞌoina Pita gamwagamwanidiya ꞌitoholowa ma ꞌihegwaediya, ꞌigwae: ");
INSERT INTO bdd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Tasigwao, mwalo Yaluyaluwa Tabuna Debida ꞌina gwae ꞌiꞌebwaeya Yudasa weyahina, ma Buki Heꞌasisi ꞌoina ꞌimiyamiya. Yudasaina mwalo mahetedai tahetohepwaila Yesu weyahina, ma hesi ꞌida Bada ꞌitebaeya ta ꞌiꞌebwayaeya Yesu ꞌana ꞌalehao nimadiya. Ta ꞌaigeda wali Buki Heꞌasisi ꞌalona Debida ꞌina gwae Yudasa weyahina, bewa gide ꞌigwaeya, ꞌCina gogo ꞌibisula ma gesowana ꞌeta taiya loheya ꞌoina ꞌimiya.’ Ma wete ꞌigwaeya, ꞌMiyalaena tauna ꞌina paihowa ꞌiꞌewa.’ Coinega ꞌilobwaineya ꞌilatu gide gwae bewa ꞌigwae ꞌese.” Pita ꞌina gwae bewa gide, weyahina Yudasa ꞌiꞌamasa pwaiya. Tauna mwalo ꞌina paihowa galana ꞌana maisa ꞌiꞌeweya ma ꞌaigeda baleꞌu ꞌigimwaneya, ta baleꞌuina ꞌalona ꞌibeꞌu talutalubuꞌiya, ta gamwana ꞌilosabuweya, ma sinaena mabwaiyana ꞌilatuwa ta tetelina meYelusalema mabwaiyadi sihesagoheya, ta ꞌenadiyega baleꞌuina sibwauweya “Akeladama,” ma ꞌana sanapu “Baleꞌu Bweyaha.” ");
INSERT INTO bdd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ma Pita wete ꞌigwaeya, “Coinega Yudasa miyalaena tabese, ma ꞌilobwaineya ma loheyaina mwalo mahetedai tamiyamiya sauga mabwaiyana, ");
INSERT INTO bdd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yesu ꞌina babitaiso Yoni ꞌoinega ꞌana siga ꞌina hane galewa, ꞌina sakowasi mabwaiyana ꞌoidiya, ma ꞌane loheyaina mahetedai tahehepwaila Yesu ꞌina toholohila weyahina.” ");
INSERT INTO bdd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Coinega loheya ꞌeluwa sanidiyao siꞌabi lagasidiya, ꞌaigeda Yosepa, tauna sibwauweya Basaba, tauna wete sibwauweya Yusito, ma heluwena loheya sanina Mataya. ");
INSERT INTO bdd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Coinega siꞌahwaꞌahwanoi Yehoba ꞌoina, sigwaeya, “Bada yo, ꞌowa tomota mabwaiyama ꞌima nuwatuhu ꞌusanasanapudi, ꞌoinega ꞌino hesinuwa loheloheya ꞌeluwa bewa ꞌoidiyega ꞌuheꞌitae ꞌoima, ");
INSERT INTO bdd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ma Yudasa miyalaena, ma tauna ꞌihetopaihowa ma ꞌihetohepwaila Yesu weyahina, weyahina Yudasa paihowaina ꞌiꞌebesineya ta ꞌitauya tauna ꞌina tupwa.” ");
INSERT INTO bdd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Coinega dimwa ꞌeluwa ꞌoidiya sanidi silelediya ma siula hanehedi ma sibeꞌuwa, ta Mataya sanina ꞌinugeta, ꞌoinega tauna ꞌiluhu Yesu ꞌana tohepwailao site lebeniyedi baꞌidanao, ta mahetediyao sipaihowa. ");
INSERT INTO bdd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ma muliyetega paihowa sanina Penitikosi ꞌana sabwelo ꞌoina Yesu ꞌana tohemisao mabwaiyadi siꞌetoꞌautama, ");
INSERT INTO bdd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ma hadai simiyamiya, ma galewega ꞌaigeda dagugu gide wediliya madouna sihesagoheya, ta ꞌidi hada ꞌalona gesowana ma toꞌaha wete sihesagohe, ");
INSERT INTO bdd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ta ginaula ꞌaigeda siꞌiteya ꞌana ꞌita gide ꞌaiwe ninininimina, ma ꞌalataedi sitowa ꞌaigeda ꞌaigeda debadiya. ");
INSERT INTO bdd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Coinega mabwaiyadi Yaluyaluwa Tabuna ꞌilohemahediya, ta sihegaina ma hali ꞌenana ma hali ꞌenana ꞌoidiyega sigwaegwae, beno Yaluyaluwa Tabuna ꞌina waiwaiyega. ");
INSERT INTO bdd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sauga nage ꞌoina totapwalolo meYudiya hali tupwega ma hali tupwega sitauya pwaima, ma Yelusalema ꞌoina simiyamiya, ");
INSERT INTO bdd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ma daguguina sihesagoheya ta siꞌetoꞌautama, ma mabwaiyadi taudi ꞌenadiyega ꞌaigeda ꞌaigeda gwae sihesagoheya ꞌoinega nuwadi ꞌihepwanopwanowa madouna, ");
INSERT INTO bdd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ta sigwae, “Togidega, taudi togwaeyedi mabwaiyadi meGalili ꞌawa? ");
INSERT INTO bdd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma togidega ta ꞌoinega mabwaiyada tauda ꞌenadega sigwaegwae, ");
INSERT INTO bdd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ꞌenanaedi beno Palitiya, ma Midiya, ma Elama, ma Mesopotemiya ꞌana tomiya, ma Yudiya ma Kapadosiya, ma Ponito, ma Esiya, ma ");
INSERT INTO bdd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piligiya, ma Pamipiliya, ma Itipita, ta Libiya tupwainaowedi Sailini ꞌalona simiyamiya, ta taudi Lomega sitauyama, tupwadi meYudiya, ma tupwadi geya meYudiya ma hesi ꞌida tapwalolo ꞌoina sitagwalediya mahetediyao, ");
INSERT INTO bdd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ma wete meKiliti, ma meAlebiya, ta mabwaiyada tauda ꞌenada hagana ma hagana ꞌoidiyega sigwaegwae Yehoba ꞌina paihowa waiwaidi weyahina.” ");
INSERT INTO bdd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Coinega mabwaiyadi maꞌidi henuwanainaida siboidimo sigwaegwae, “Toꞌaha lamuna ta ꞌidi paihowa bewa gidemusa?” ");
INSERT INTO bdd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma hesi ꞌiyadiyao tupwadi sigwae, “Nuwana weꞌaha waiwai ꞌoinega sihebuwa.” ");
INSERT INTO bdd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ma Pita ꞌiyanao site lebeni mahetenao sitoholo, ma Pita ꞌihegaina ma ꞌoidiya ꞌiloguguya, ꞌigwaeya, “Comi meYudiya ma Yelusalema ꞌana tomiyao mabwaiyami ꞌigu gwae wahesagohe, ma wanuwa sabwalena, ");
INSERT INTO bdd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ꞌabehega ꞌima paihowa bewa geya weꞌaha waiwai ꞌoinega, weyahina ꞌabwa gonagona, geya numa yauyaule ꞌana tuta. ");
INSERT INTO bdd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma hesi mwalo palopita Yoeli ꞌihepwaila nugeteya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ꞌYehoba ꞌina hepwaila bewa gidemusa ꞌigwae: Cabwa sauga ꞌana ꞌebelosaloha ꞌoina, Yaluyaluwagu yalosiwa tomota mabwaiyadi ꞌoidiya, ma natumiyao loheyadi nuwana natumiyao wahinedi siloguguya, ta ꞌimi hewahewaliyao siꞌeno mataꞌitaꞌita, ta ꞌimi babadao sinihi. ");
INSERT INTO bdd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Moisa, tuta nage ꞌoina Yaluyaluwagu yalosiwa ꞌigu topaihowa, loheloheya ma wahiwahine ꞌoidiya, ma ꞌigu nuwatuhu sihepwaila nugete. ");
INSERT INTO bdd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma ꞌebeꞌita henainaida yapaihowadi galewa, ta wete baleꞌuwa, gidemusa bweyaha ma ꞌaiwe ganinisa ma ꞌasu, ");
INSERT INTO bdd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ta sinala ꞌiguguyou, ta waiꞌena ꞌana ꞌita ꞌihebweyaha, ma muliyetega Bada ꞌina sabwelo ꞌebe matauta ꞌilatu. ");
INSERT INTO bdd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta ꞌeguma taiyawedi Bada saninega sibwaubwau nata ꞌiꞌabihetedi.’” ");
INSERT INTO bdd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita wete ꞌihegwaediya, ꞌigwae, “MeIsileli ꞌomi gwae bewa wahesagohe, Yesu tauna gwama Nasaleta matamiya Yehoba ꞌiheꞌitaeya ꞌabehega tauna ꞌina topaihowaina, weyahina Yesu ꞌina paihowa waiwaidi ma ꞌebe henainaida Yehoba ꞌina waiwaiyega ꞌipaihowediya, ma wasanasanapudi weyahina gamwagamwanimiya ꞌipaihowediya. ");
INSERT INTO bdd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yehoba mwalo hene Yesuina weyahina ꞌiloina, ma toꞌaha baleꞌuwa Yesu nata ꞌiloba Yehoba ꞌisanapu nugeteya, beno ꞌomi watebaeya, ta ꞌimi loina ꞌoinega tomota galadi kelose ꞌoina siloheꞌamasiya. ");
INSERT INTO bdd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma Yehoba ꞌamasa ꞌina tupwa mwauna ꞌoinega ꞌiꞌabiheteya ta ꞌiꞌabihetoholo hileya, weyahina geya sowasowahina ma ꞌamasa ꞌina tupwa ꞌimiyamiya hataya. ");
INSERT INTO bdd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bewa weyahina mwalo Debida Yesu ꞌina gwae ꞌihepwaila nugeteya ꞌigwae, ꞌBada yaꞌiteya mataguwega ꞌimiya hataya, ma ꞌigu ꞌebeulega ꞌimiyamiya, ta ꞌiꞌabihe waiwaiyegauwa ma sahena yaweꞌaweꞌa. ");
INSERT INTO bdd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Coinega yayaliyaya madouna ma yahehepwatuwe, ma yahemisaeya ꞌane gesowana ꞌwapigu ꞌigalagala. ");
INSERT INTO bdd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Taugu ꞌino loheya hesihesinuwaigu, eema sahena yaluyaluwagu ꞌulagulagu hataya toꞌamasao ꞌidi gogowa, ma gesowana wete ꞌwapigu ꞌimwahulu. ");
INSERT INTO bdd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta hesi yawasi bwebweꞌana ꞌina ꞌeda ꞌuheꞌitaeya ꞌoiguwa, ꞌoinega matauwa ꞌuꞌabihe yaliyaya hataegau.’” ");
INSERT INTO bdd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ma Pita wete ꞌigwaeya, “Tasigwao, gwae bewa geya tubuda Debida weyahina, weyahina Debidaina tasanapuya ꞌabehega mwalohene ꞌiꞌamasa ta sigaliheya, ma bewa tuwa ꞌana galihina ꞌebwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ma Debidaina palopita ꞌaigeda, ma Yehoba ꞌina gwae hemisa waiwaina ꞌoina ꞌinuwatuhu yahiya ꞌabehega ꞌabwa Debida tubuna ꞌaigeda Debidaina ꞌina ꞌebeloina ꞌiꞌewa Yehoba ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Coinega Toꞌabihetenaina ꞌina toholohila ꞌisanapu nugeteya, ta ꞌihegwaeya ꞌabehega sahena toꞌamasao yaluyaluwadi ꞌidi gogo ꞌoina ꞌimiyamiya hataya, ma wete ꞌwapina gesowana ꞌimwahumwahulu. ");
INSERT INTO bdd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bewa Yesu ꞌina ꞌamasega Yehoba ꞌiꞌabihetoholo hila pwaiya, ma tauna mabwaiyama ꞌaꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Coinega Yehoba ꞌiꞌabihaneheya ta tauna ꞌina ꞌebeulega ꞌimiyamiya, ma tauna Yaluyaluwa Tabunaina Yehoba mwalo ꞌigwae hemisaeya, ma bewa tuwa ꞌiꞌebwaya pwaimaiya, ꞌoinega paihowa bewa waꞌitaꞌitadi ma wahehesagohedi, tauna ꞌoinega sitauyama. ");
INSERT INTO bdd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Weyahina Debida geya tauna ꞌina hane galewa weyahina ꞌigwae, ma Yesu hesi weyahina ꞌigwaeya, ꞌigwae, ꞌYehoba ꞌigwae pwaiya ꞌigu Bada ꞌoina, “Cigu ꞌebeulega ꞌumiyatoi, ");
INSERT INTO bdd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ma ꞌana siga tutaina ꞌa sahiyao yalagu suluhedi ꞌaheu ꞌadi ꞌebelagu ꞌoina.” ꞌ ");
INSERT INTO bdd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bewa weyahina meIsileli mabwaiyami wasanapu bwaibwaini ꞌabehega Yehoba Yesu ꞌiꞌahwa bada pwaiyeya ma tauna Toꞌabihetena, tauna Yesuina waꞌabihekelose pwaiya.” ");
INSERT INTO bdd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Loheloheyaedi Pita ꞌina gwae bewa sihesagoheya ta weyahina sinuwagala moisa, ma Pita maꞌiyanao ꞌoidiya sihesilala, sigwae, “Tasimao ꞌalopuiya. Togidega nata ꞌapaihowa ꞌesa?” ");
INSERT INTO bdd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Coinega Pita ꞌigwaeya, “Cimi paihowa galana ꞌoidiyega wanuwabui, ma mabwaiyami Toꞌabihetena Yesu saninega ꞌada ꞌabihe babitaisogomi, ma wete ꞌimi puiyao ꞌinuwasamudi, ta wete Yaluyaluwa Tabuna ꞌiꞌebwaegomi. ");
INSERT INTO bdd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Weyahina Yehoba ꞌina gwae hemisaina ꞌabehega ꞌomi weyahimi, ma natumiyao wete weyahidi, ma taudi bwaga ꞌana tomiyao weyahidi, taudi mabwaiyadi ꞌida Badaina Yehoba ꞌibwauwedi ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma Pita ꞌina gwae ta ꞌina loguguya baibaiwana wete ꞌoidiyega ꞌihepwaila, ta ꞌigwaeya, “Ciyagwao, mehau galadi waꞌebesinedi ma ꞌabihetena waꞌebese.” ");
INSERT INTO bdd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Coinega sabweloina ꞌoina Pita ꞌina gwae sihesagoheya, ta sibabitaiso, ta ꞌadi baibaiwa gidemusa ꞌetoi tausani, ");
INSERT INTO bdd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ta sitagwala moisa tohepwailedi ꞌidi heꞌitao ꞌoidiya ma siheꞌiyaꞌiyagu moisa, ma siꞌai mahemahetena, ta wete siꞌahwaꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta mabwaiyadi Yehoba siheꞌasisiyeya, ma tohepwailao ꞌidi paihowao ꞌebehenainaida ma hedehedede baibaiwadi sipaihowediya. ");
INSERT INTO bdd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma tohemisaowedi taudimo sihegogonedima, ta ꞌidi tobwatobwao sitagwalediya ma ꞌabehega tomota mabwaiyadi ꞌidi tobwatobwa. ");
INSERT INTO bdd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta ꞌeguma ꞌidi ꞌebeloina ꞌasai simiyamiya sihegimwaneyedi ta ginaulaedi ꞌadi maisega siheguyaiyedi taudi geya ꞌidi tobwatobwaomo ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Coinega sabwelo ꞌaigeda ꞌaigeda ꞌoidiya maꞌidi ꞌatetagwala sitapwatapwalolo Hada Heꞌasisi ꞌoina, ma taudi ꞌidi hada maꞌidi yaliyaya siꞌai hegogona, ");
INSERT INTO bdd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ma Yehoba sihehepwatuwe. Ta hesi tomota mabwaiyana tohemisaowedi siꞌahwa bwebweꞌanediya. Ma sabwelo ꞌaigeda ꞌaigeda ꞌoidiya Yehoba tupwana tomota wete ꞌiꞌabiꞌabihetedi, ta tohekalesiyao ꞌadi baibaiwa ꞌimadomadou. ");
INSERT INTO bdd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Caigeda tuta lahilahiya, Pita Yoni baꞌidana silagalaga Hada Heꞌasisi ꞌoina sabi ꞌahwanoi, weyahina beno ꞌahwanoi ꞌana tuta. ");
INSERT INTO bdd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma Hada Heꞌasisiina ꞌana ꞌahwaꞌeda sihesaniyeya Causalana deina topeu ꞌaigeda ꞌimiyamiya, tauna ꞌina tuta liꞌu ꞌoinega maꞌina peu, ꞌoinega ꞌiyanao sabwelo ꞌaigeda ꞌaigeda ꞌoidiya siꞌeweꞌeweyama ꞌahwaꞌedaina ꞌoina ma ꞌiloꞌahwaꞌahwanoi ꞌina mane bo ꞌina tobwatobwa weyahidi, Hada Heꞌasisi ꞌana toluhuwao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta topeuina Pita ma Yoni ꞌiꞌitediya ꞌiꞌiuna ma siluhu, ꞌoinega lema weyahina ꞌiꞌahwanoiya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eeta Pita ma Yoni siꞌebubuya, ta Pita ꞌigwaeya, “Cuꞌebubumai.” ");
INSERT INTO bdd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Coinega topeuina ꞌiꞌebubudiya maꞌina hemisa ꞌabehega toꞌaha nata siꞌebwae. ");
INSERT INTO bdd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ta Pita ꞌigwaeya, “Geya ꞌigu manemo, ma hesi helauina ꞌoiguwa ꞌimiyamiya yaꞌebwaego, Toꞌabihetena Yesu, tauna gwama Nasaleta, saninega yaloinego ma ꞌutoholo ma ꞌutauya.” ");
INSERT INTO bdd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma nima ꞌebeulega ꞌiꞌabihe toholoya, ma ꞌaetubwenao sipaꞌala, ");
INSERT INTO bdd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma ꞌiulataheya ma ꞌitoholowa, ma ꞌoinega ꞌitauya ta baꞌidanao siluhuwa Hada Heꞌasisi ꞌalona, ma loheyaina ꞌiulaula taheya ma ꞌihehepwatu Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Coinega boda siꞌiteya topeuina ꞌitautauya maꞌina hepwatu Yehoba ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ta siꞌinaneya ꞌabehega topeuina mwalo Hada Heꞌasisi ꞌana ꞌahwaꞌeda ꞌausalana deina ꞌimiyamiya ma ꞌiloloꞌahwaꞌahwanoi ꞌana lema weyahina, ꞌoinega sisalutuwa ma sihenainaida madouna ꞌina bwebweꞌana hila weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tutaina loheyaina Pita ma Yoni ꞌiꞌabiꞌabi yahidi Hada Heꞌasisi papena, tauna sihesaniyeya Solomoni ꞌina biliupa, ta bodaedi maꞌidi henainaida sipili hegogona ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ma Pita ꞌiꞌitediya, ꞌoinega boda ꞌihegwaediya, ꞌigwae, “Comi meIsileli, toꞌaha weyahina nuwami ꞌihenainaida ma waꞌeꞌebubumai? Geya ꞌabehega tauma ꞌima waiwaiyega bo nuwana ꞌima mumuga bwebweꞌana ꞌoinega, loheya bewa ꞌaꞌabihe bwebweꞌaneya ta ꞌitautau, ");
INSERT INTO bdd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ma hesi Yehoba ꞌina waiwaiyega, tauna Ebalahamo ma Aisake ma Yakobo ꞌidi Yehoba, ta tubudao ꞌidi Yehoba. Yehobaina ꞌina hewali Yesu sanina ꞌiꞌabihaneheya, tauna mwalo Pailato nuwanuwana ma ꞌilihasi, ma ꞌomi wamwehihiyeya, ta waꞌahwa galagalaeya Pailato matana. ");
INSERT INTO bdd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Moisa tuwa, Yesu tauna loheya dumwaluna ma bwebweꞌana, ma hesi walogwahateya, ta tomota ꞌadi toloheꞌamasa ꞌaigeda nuwanuwami, ta weyahina Pailato ꞌoina waꞌahwanoiyeya. ");
INSERT INTO bdd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Coinega yawasi bwebweꞌana ꞌana toꞌebwaya waloheꞌamasiya, ma Yehoba tauna ꞌamasega ꞌiꞌabihetoholo hileya, ta mabwaiyama ꞌaꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Coinega Yesu saninega loheya bewa ꞌibwebweꞌana pwaiya. Loheya bewa waꞌiteya ma wasanapuya, ma Yesu sanina ꞌihemiseya, ꞌoinega matamiya ꞌibwebweꞌana moisa ma ꞌihewaiwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Tasigwao, yasanapugomiya ꞌabehega ꞌimi henuwa potepotega Yesuina waloheꞌamasiya, gidemusa ꞌimi babadao. ");
INSERT INTO bdd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma hesi wada nuwahila ꞌabehega Yehoba ꞌina palopitao ꞌoidiyega ꞌihepwaila nugeta beno Toꞌabihetena ꞌina muyao ꞌilobadi, ꞌoinega gwaeina ꞌana moisa ꞌilatu pwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Coinega ꞌilobwainegomiya wanuwabui ma ꞌimi puiyao ꞌiꞌewayahuledi, ma lotohona bwebweꞌana waloba Bada tauna ꞌoinega, ");
INSERT INTO bdd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ta wete Toꞌabihetenaina tauna ꞌihesinuwa nugeteya, ꞌihewasae ꞌoimiya, beno Yesu. ");
INSERT INTO bdd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tauna ꞌitauya pwaiya galewa, ma ꞌimiyamiya ꞌana siga ginaula mabwaiyadi ꞌiꞌabihe dumwaludi, gidemusa Yehoba ꞌina palopitao mwalona sihepwaileya. ");
INSERT INTO bdd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mwalo Mosese wete ꞌigwae hemisa, ꞌigwaeya, ꞌCabwa ꞌida Bada Yehoba ꞌoimiyega ꞌaigeda loheya ꞌiꞌabilagasi ma ꞌihepalopita weyahimi, gidemusa taugu ꞌiꞌabi lagasigauwa, ma ꞌina hepwaila mabwaiyami nata wahesagohedi. ");
INSERT INTO bdd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ma ꞌeguma taiyawedi palopitaina ꞌina gwae silogwahate Yehoba ꞌiꞌabihegaladi, ma ꞌiꞌewa yahuledi ꞌina tomotaedi ꞌoidiyega.’ ");
INSERT INTO bdd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ma palopita mabwaiyadi Samuwela ꞌoinega ma taudi simuliyeya ꞌoidiya, ꞌidi gwae hemisa ꞌoidiyega sihepwaila nugeta paihowaedi bewa tuwa weyahidi. ");
INSERT INTO bdd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma ꞌomi palopitaowedi tubumiyao. Ma wete gwae hemisaina Yehoba tubudai Ebalahamo ꞌiꞌebwaeya, ꞌigwae, ꞌCowa ꞌino susuwega ꞌabwa ꞌebeloinao mabwaiyadi baleꞌuwa ꞌidi ꞌebeyaliyaya.’ Coinega gwae hemisaina bewa ꞌomi wete weyahimi. ");
INSERT INTO bdd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ma Yehoba ꞌina hewali Yesu ꞌiꞌabihe toholoya, ta ꞌomi meYudiya ꞌoimiya ꞌihetune nugeteyama, ma ꞌina helau ꞌoimiya beno ꞌabehega ꞌimi puiyao ꞌoidiyega wanuwabui, ma hali bodao muliyetega.” ");
INSERT INTO bdd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ma ꞌabwa tuwa sigwaegwae boda ꞌoidiya, ma topwaoliyao ma Hada Heꞌasisi ꞌana tuilala madoudi, ma wete Sadusiyao sinaoma, ");
INSERT INTO bdd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","maꞌidi gamwasowala weyahina Pita ma Yoni bodao siheꞌitediya ꞌabehega Yesu ꞌamasega ꞌitoholo hila. ");
INSERT INTO bdd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Coinega siꞌabiyahidiya ma deliya silagu luguhediya ma ꞌabehega gona ꞌiꞌadale ma ꞌidi yatala sida paihowa, weyahina ꞌiboi pwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta hesi ꞌidi loguguya bodaedi sihesagoha pwaidiya, ma tupwana baibaiwadi sihemisaediya, ꞌoinega tohemisaowedi mabwaiyadi loheloheya ꞌadi hasihasila gidemusa paibi tausani. ");
INSERT INTO bdd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gona ꞌiꞌadaleya, ta ꞌidi toloinao ta ꞌidi babadao ma loina ꞌana toheꞌitao, ");
INSERT INTO bdd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ma wete Anasa, tauna Topwaoli Madouna maꞌina susuwao ta maꞌina bodao, beno Kaiyapa ma Yoni ma Alekisana, taudi Yelusalema ꞌoina sideli ꞌautama. ");
INSERT INTO bdd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Coinega Pita ma Yoni gamwagamwanidiya sihetoholodiya, ma sihesilalediya, sigwae, “Cimi paihowa bewa taiya ꞌina waiwaiyega, nuwana taiya saninega wapaihoweya?” ");
INSERT INTO bdd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ma Pita Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌihegwaediya, ꞌigwae, “Cima toloinao ma babadao he, ");
INSERT INTO bdd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nuwana ꞌima yatala bewa lamuna weyahina tolopegoi ꞌaꞌabiheteya, ma ꞌabehega togidega ꞌaꞌabihe bwebweꞌana ꞌeseya? ");
INSERT INTO bdd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Coinega nuwanuwama ꞌomi ma meIsileli mabwaiyami wada sanapu ꞌabehega loheya bewa matamiya ꞌitohotoholo ꞌina bwebweꞌana Yesu Keliso ꞌoinega, tauna gwama Nasaleta, kelose ꞌoina waloheꞌamasiya, ma Yehoba ꞌiꞌabihetoholo hileya. ");
INSERT INTO bdd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesuina gide logidi, ma toꞌabi hada ꞌomi logidiina walogwahateya, ma hesi tuta bewa ꞌihelogidi nugeta ma logidi mabwaiyadi ꞌiloinaedi. ");
INSERT INTO bdd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ta geya ꞌeta taiya wete sowasowahina ma ꞌilemegita. Beno tuwa Yesu. Ma geya ꞌaigeda wete sani baleꞌuwa ꞌimiyamiya ma ꞌoinega lemaina taloba.” ");
INSERT INTO bdd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma toloinaowedi siꞌiteya Pita ma Yoni ꞌidi ꞌatepatu, ma sisanapuya ꞌabehega taudi tuwa tomiya ꞌasa, ma ꞌebe seꞌulu madouna ꞌoidiya geya siluhuluhu, ꞌoinega nuwadi sihepwanopwanowa ma sinuwatuhuya ꞌabehega mwalo Yesu baꞌidadiu simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ta wete topeuina ꞌibwebweꞌana pwaiya siꞌiteya deidiya ꞌitohotoholo, ꞌoinega geya wete ꞌidi ꞌebe gwaemo. ");
INSERT INTO bdd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ta sihewasaediya ma silatuwa ma ꞌabehega siboidimo hadai sida loina, ꞌoinega Pita ma Yoni sihapwesa, ta toloinaowedi siloina, ");
INSERT INTO bdd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ma sigwaeya, “Togidega tada loina ꞌesa loheloheya ꞌeluwaedi weyahidi, weyahina Yelusalema ꞌana tomiyanao mabwaiyadi sisanapudiya ꞌabehega ꞌilaꞌilala madouna sipaihowa pwaiya, ma geya sowasowahida tauhale. ");
INSERT INTO bdd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Benomo tada toho ma tetela bewa tada ꞌausi, ma sahena ꞌilelelelewana boda mabwaiyadi ꞌoidiya, ꞌoinega tada loina paꞌala ꞌoidiya ma sahena wete Yesu sanina tomota ꞌoidiya sihehewasae.” ");
INSERT INTO bdd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Coinega sibwauwedima ma siluhu hila ꞌoidiya, ma siloinedi ma sahena wete Yesu sanina sigwaegwaene, bo siheheꞌitae tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ta Pita ma Yoni ꞌidi loina sihemaiseya, sigwae, “Togidega ꞌilobwaineya ma Yehoba matana tauna ꞌina gwae ꞌamuliya, bo nuwana ꞌomi tuwa ꞌimi gwae ꞌada muliya? Bewa weyahina wanuwanuwa. ");
INSERT INTO bdd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ma tauma hesi geya sowasowahima ma ꞌima gwae ꞌalolagu ginauledi ꞌaꞌitediya ma ꞌahesagohediya weyahidi.” ");
INSERT INTO bdd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Coinega siheliyediya ma muliyetega silihasidiya. Geya ꞌidi pui ꞌeta silobaloba ma weyahina maisa mwauna sida ꞌebwaedi, ma hesi boda mabwaiyadi Yehoba sihepwatuweya. ");
INSERT INTO bdd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Weyahina topeuina ꞌana bolime poti ma tupwana, ma siꞌabihe bwebweꞌana pwaiya. Coinega toloinao boda simatautediya, ta geya ꞌeta toꞌaha sipaihowa Pita ma Yoni ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Coinega Pita ma Yoni sihapwesa ma ꞌiyadiyao ꞌoidiya sitauya ma topwaoli madoudi ma babadao ꞌidi gwae sihepwailediya. ");
INSERT INTO bdd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ta ꞌiyadiyao sihesagoheya mabwaiyana, ꞌoinega Yehoba ꞌoina sigwae mahemahetena sigwaeya, “Cima Bada yo, ꞌowa galewa ta baleꞌu ta hola ta ginaula mabwaiyadi ꞌalodiya simiyamiya ꞌuhemasalahediya, ");
INSERT INTO bdd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ꞌoinega ꞌino hewali, tauna tubuma Debida, Yaluyaluwa Tabuna ꞌina waiwai ꞌoinega ꞌino gwae ꞌihepwaila latuwa, ꞌigwaeya, ꞌToꞌaha lamuna ꞌebeloina baibaiwadi siloloꞌalehe, ta wete sinuwanuwatuhu bwagabwaga? ");
INSERT INTO bdd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Coinega mebaleꞌu ꞌidi kiniyao ma toloinao sideli ꞌautama ma siꞌatuꞌatububuwa sabi loꞌaleha Yehoba ta ꞌina Keliso ꞌoidiya.’ ");
INSERT INTO bdd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Moisa gogo bewa ꞌalona siꞌetoꞌautama ma Yesu siꞌaleha, tauna ꞌino hewali dumwaluna ma hesihesinuwaina, taudi toꞌalehaowedi beno Helodi, ma Ponitio Pailato, ma meYudiya ma wete taudi geya meYudiya, ");
INSERT INTO bdd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ma sipaihoweya toꞌaha gide ꞌowa ꞌino nuwatuhu mwalo ꞌuloinaeya. ");
INSERT INTO bdd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bada yo, ꞌuꞌita ꞌidi heliya tauma ꞌino topaihowao ꞌoima, ma hesi ꞌuda ꞌabi hewaiwaiyemai ma maꞌima ꞌatepatu ꞌino gwae ꞌada hepwaile latuhe. ");
INSERT INTO bdd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta wete ꞌino waiwaiyega tolohalao ꞌuda ꞌabihe bwebweꞌanedi, ma ꞌilaꞌilalao ma hedehedede ꞌuda gihelatuhedi, ꞌino hewali hesihesinuwaina, sanina Yesu ꞌoinega.” ");
INSERT INTO bdd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cidi ꞌahwanoi bewa silosalohiya, ma hadaina ꞌoina simiyamiya ꞌilonihuwa, ma mabwaiyadi Yaluyaluwa Tabuna ꞌina waiwai ꞌoinega siꞌatepatu, ma Yehoba ꞌina gwae sigwae latuheya. ");
INSERT INTO bdd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bodaedi Yesu sihemisaeya, ta ꞌidi nuwatuhu mabwaiyana mahemahetena, ma geya sida ꞌenuwaha, ma hesi ꞌidi tobwatobwa mabwaiyadi sitagwalediya boda mabwaiyadi ꞌidi paihowa weyahidi. ");
INSERT INTO bdd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ta wete Bada Yesu ꞌana tohepwailaowedi sihewaiwai hedada ꞌina toholo hila ꞌana hepwaila weyahina, ma mabwaiyadi sihehelau hiledi mahemahetena. ");
INSERT INTO bdd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma wete mabwaiyadi maꞌadi, ma maꞌadi ꞌwama, weyahina taudi towasawasao ꞌidi baleꞌu ma ꞌidi hadao sihegimwane pwaidiya, ");
INSERT INTO bdd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ta ꞌadi maisao mabwaiyana siꞌewedima ma siꞌebwaediya Yesu ꞌana tohepwailao ꞌoidiya, ma taudi siheguyaiya taiyewedi simiya mwau ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Towasawasa ꞌaigeda ꞌoidiyega, sanina Yosepa, ma sanina hauhauna tohepwailaowedi siꞌebwaeya Banaba, beno ꞌana sanapu “Toꞌabihe ꞌatepatu,” tauna gwama Saipilosi, ma Libai ꞌina susu ꞌaigeda, ");
INSERT INTO bdd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ma tauna ꞌina tanoha ꞌihegimwaneyeya, ta maneina ꞌiꞌeweyama ta ꞌiꞌebwaeya Yesu ꞌana tohepwailao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Loheya ꞌaigeda wete mamwanena ꞌidi tanoha sihegimwaneyeya, maneina siꞌeweyama. Loheyaina sanina Ananaiyasi ma mwanena Sapaila. ");
INSERT INTO bdd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Siteluwaedi sitalamwa ma tupwana mane sidahweya, ta ꞌana tupwamo Ananaiyasi ꞌiꞌeweyama tohepwailaowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ꞌihegwaeya, ꞌigwae, “Ananaiyasi toꞌaha weyahina Seitani nuwau ꞌiꞌeweya ma tanoha ꞌana maisa tupwana ꞌudahweya? Beno ꞌino ꞌabo Yaluyaluwa Tabuna ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mwalo geya ꞌuhegimwaneye, tanohaina ꞌowa ꞌino ꞌebeloina, ma wete tutaina ꞌuhegimwaneyeya, maneina ꞌowa ꞌino ꞌebeloina. Ma toꞌaha weyahina ꞌateuwa ꞌunuwanuwatuhu ma maneina weyahina ꞌuꞌabowa? Cino ꞌabo bewa geya tomota ꞌoima, ma hesi Yehoba ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita ꞌina gwae bewa Ananaiyasi ꞌihesagoheya ma ꞌibeꞌuwa ta ꞌiꞌamasa, ꞌoinega tomota mabwaiyadi tetelina sihesagoheya ma siꞌateyohowa madouna. ");
INSERT INTO bdd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ta tupwadi hewahewali sinaoma ma toꞌamasina ꞌaleꞌowega siwaduya ma siꞌahala latuheya ma sigaliheya. ");
INSERT INTO bdd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ma mwanena geya ꞌisanapu. Eema mulina ꞌiluhuwa hadai, ");
INSERT INTO bdd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ma Pita ꞌihesilaleya, ꞌigwae, “Sapaila, ꞌimi tanohaina wagimwaneyeya, hisa ꞌana maisaina waꞌeweya? Gide mwaneu ꞌihegwaemaiya ꞌawa?” Ma Sapailaina ꞌigwae, “Cehe, gidemusa.” ");
INSERT INTO bdd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Coinega Pita ꞌigwae, “Togidega ma wateluwa watagwala ma watoho ta ꞌabehega Bada Yaluyaluwana waꞌabowe? Cuhesagohe, mwaneu ꞌana togalihao siluhuluhuma ma ꞌiꞌiunamo siꞌahala latuhego wete.” ");
INSERT INTO bdd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma Sapailaina ꞌibeꞌuwa mwayamwayauwa Pita ꞌaena, ma ꞌiꞌamasa wete. Ta hewahewaliyedi siluhuma, ma siꞌiteya ꞌiꞌamasa pwaiya, ta siꞌahala latuheya ma sigaliheya, mwanena deina. ");
INSERT INTO bdd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ta tohekalesiyao mabwaiyadi simatauta madouna, ma taiyawedi wasaina sihesagoheya wete siꞌateyohowa. ");
INSERT INTO bdd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ma wete boda gamwagamwanidiya Yesu ꞌana tohepwailaowedi hedehedede ma ginaula ꞌebehenainaida baibaiwadi sipaihowediya. Ma mabwaiyadi ꞌidi ꞌebe deliꞌauta Hada Heꞌasisi papena, tauna sibwauweya Solomoni ꞌina biliupa. ");
INSERT INTO bdd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma boda baibaiwadi ꞌidi matautega geya siluhuluhu tohemisaowedi ꞌoidiya, ma tomota mabwaiyadi tohekalesiyao siheꞌasisiyediya madouna, ");
INSERT INTO bdd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ma baibaiwa hedada sihemisa, ma ꞌoinega silugu Bada ꞌina bodao ꞌoidiya, meloheyadi ma wete mewahinedi. ");
INSERT INTO bdd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ma wete tolohalao sitoedima maꞌebeꞌenoidi ma silagudiya Pita ꞌina ꞌebetauyao ꞌoidiya, ma ꞌabehega Pita loguloguna ꞌida ꞌabihe bwebweꞌanedi. ");
INSERT INTO bdd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wete gogowedi Yelusalema deina ꞌadi tomiyao sideli ꞌautama, ma ꞌidi tolohalao ma taiyewedi welabana yaluyaluwadi nuwana hali yaluyaluwa galadi siꞌabihe lohalediya siꞌewedima ta mabwaiyadi siꞌabihe bwebweꞌanediya. ");
INSERT INTO bdd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma topwaoliyao ꞌidi bada madouna ma Sadusi ꞌidi boda baꞌidanao sigamwasowala ma siheꞌipiꞌipiyediya, ");
INSERT INTO bdd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ꞌoinega sitoholo ma Yesu ꞌana tohepwailaowedi siꞌabiyahidi, ma deliya silagudiya. ");
INSERT INTO bdd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma nihuwanega Bada ꞌina anelose ꞌaigeda deli ꞌana gudu ꞌisoꞌeya, ma ꞌitoe hapwesediya, ");
INSERT INTO bdd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ma ꞌihegwaediya, ꞌigwae, “Watauya Hada Heꞌasisi ꞌoina, ma nobwa watoholo ma tomota ꞌoidiya gwaeyedi yawasi bwebweꞌana weyahina waguguya.” ");
INSERT INTO bdd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Coinega aneloseina ꞌina gwae sihesagoheya ma gona ꞌiꞌadaleya, ta Hada Heꞌasisi ꞌoina siluhuwa, ma boda siheꞌitediya. Coinega wete Topwaoli Madouna ma ꞌina bodao siꞌeto ꞌautama, ma meIsileli ꞌidi babadao ma ꞌadi toloinao mabwaiyadi sibwauwedima ta ꞌidi hewaliyao tupwadi deliya sihewasaedi ma ꞌabehega Yesu ꞌana tohepwailao siꞌewedima ma sida yatala matadiya. ");
INSERT INTO bdd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta sitauya ma deli hagalinamo siꞌiteya, ma sihilama, ");
INSERT INTO bdd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ma sigwae, “Deli guduguduina ma paꞌalina ꞌaꞌiteya, ta ꞌana tolomatayahinao ꞌahwaꞌeda ꞌoidiya sitotoholo wete, ma tutaina ꞌahwaꞌeda ꞌasoꞌeya ꞌalona gaugaulinamo.” ");
INSERT INTO bdd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ma Hada Heꞌasisi ꞌana toꞌitayahi madouna, ma topwaoliyao madoudi wasa bewa sihesagoheya ma siꞌateyohowa madouna, toꞌaha ꞌiꞌiunamo ma ꞌilatu weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ma ꞌaigeda loheya ꞌoidiya ꞌinaoma ma ꞌihegwaediya, ꞌigwae, “Loheloheyaedi deliya walagulagudiya, Hada Heꞌasisi ꞌalona sitotoholo, ma siheheꞌita tomota ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ta Hada Heꞌasisi ꞌana toꞌitayahi ma ꞌina topaihowao sihapwesa, ma tohepwailaowedi siꞌabiyahidiya ma hohobigega siꞌewedima, weyahina simatauta boda ꞌoidiya, ta geya nuwadi ma boda sigamwasowala ꞌoidiya, tabu ta daꞌuleyega siꞌetutuwedi. ");
INSERT INTO bdd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Coinega ma wahi bigega siꞌewedima ma toloinaedi matadiya sihetoholodiya. Ma Topwaoli Madouna ꞌihesilalediya, ");
INSERT INTO bdd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ꞌigwae, “Mwalo ꞌoimiya ꞌaloina paꞌala ꞌabehega gesowana Yesu saninega waheheꞌita tomota ꞌoidiya, ma togidega ta ꞌoinega Yelusalema mabwaiyana ꞌalona Tomota waheheꞌita Yesu weyahina, ꞌabehega tauma ꞌima loinega siloheꞌamasiya?” ");
INSERT INTO bdd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ta Pita ma tohepwailaowedi sigwaeya, “Cilobwaineya ma Yehoba ꞌina gwae ꞌahematamatane, ma geyaꞌabwa tomota ꞌidi gwae. ");
INSERT INTO bdd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Moisa, ꞌomi Yesu ꞌaiwe ꞌoina watutu hepaꞌineya ta ꞌana siga ꞌiꞌamasa, ma tubudao ꞌidi Yehoba Yesu ꞌiꞌabihetoholo hileya, ");
INSERT INTO bdd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ma ꞌiꞌabilagasiya tauna ꞌina ꞌebeulega ꞌabehega tauna Toꞌabihetena ma Tohanugeta, ma wete tauna Toꞌabihenuwabui meIsileli tauda weyahida, ma ꞌoinega ꞌida puiyao ꞌinuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Coinega tauma ginaulaedi bewa weyahidi ꞌahehepwaila, ma Yaluyaluwa Tabuna tohepwaila wete, tauna Yehoba ꞌiꞌebwaeya ꞌana tohematamatanao ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta toloinao Yesu ꞌana tohepwailao ꞌidi gwae bewa gidemusa sihesagoheya, ma sigamwasowala moisa, ma nuwanuwadi ma siloheꞌamasidi. ");
INSERT INTO bdd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ta ꞌaigeda ꞌoidiyega, sanina Gameliyela, tauna Palisi, ma loina ꞌana toheꞌita, ta maꞌana heꞌasisi tomota baibaiwadi ꞌoidiya, ꞌitoholo ma ꞌiloina ma ꞌabehega Yesu ꞌana tohepwailaowedi sitoe hapwesedi tuta toꞌutoꞌupanamo weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ta muliyetega toloinaowedi ꞌihegwaediya, ꞌigwae, “MeIsileli he, waꞌitayahigomi ma sahena waloiloina paꞌala loheloheya nage weyahidi. ");
INSERT INTO bdd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wanuwatuhuyahi tuta mwalo Tudasi ꞌihapwesa ꞌabehega tauna hali tohanugeta ꞌaigeda, ma loheloheya ꞌadi baibaiwa gide powa handeledi siluhu ꞌina boda ꞌoina, ma hesi gabemani Tudasiina siloheꞌamasiya, ma ꞌana tomuliyao sisawaleya, ta ꞌidi boda ꞌisawala. ");
INSERT INTO bdd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Ma Tudasi muliyetega, tutaina tomota mabwaiyadi sihasilidiya ꞌoina, ꞌaigeda gwama Galili ꞌihapwesa, sanina Yudasa, ta tupwadi loheloheya ꞌilisidima ma simuliyeya, ta ꞌaleha ꞌoina ꞌiꞌamasa, ta ꞌana tomuliyao sisawaleya. ");
INSERT INTO bdd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Tuta bewa yahegwaegomi ꞌabehega sahena toꞌaha waloiloinae loheloheya nage weyahidi. Ceguma ꞌadi loina nuwana ꞌidi paihowa bewa tomota ꞌoidiyega ꞌihapwesama, ꞌabwa siweꞌa, ");
INSERT INTO bdd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ma hesi ꞌeguma ꞌadi loina Yehoba ꞌoinega ꞌilatuma, geya sowasowahina ma waꞌabihe lolagudi, weyahina ꞌeguma gidemusa, Yehoba waloloꞌalehe.” ");
INSERT INTO bdd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Coinega Gameliyela ꞌina loina simuliyeya, ma tohepwailao wete sibwau hiledima ꞌoidiya, ma sisapidiya, ta sigwae, “Geya sowana wete Yesu sanina wagwaegwaene tomota ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ma silihasidiya ma sihapwesa, ma sitauya taudi ꞌidi boda ꞌoidiya maꞌidi yaliyaya, weyahina sowasowahidi ma muyaedi silobadi Yesu sanina weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma sabwelo ꞌaigeda ꞌaigeda ꞌoidiya siheheꞌita ma siguguya Hada Heꞌasisi ꞌalona, ta wete tomota ꞌidi hadao ꞌoidiya, ꞌabehega Yesu tauna Toꞌabihetenaina. ");
INSERT INTO bdd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tuta nage ꞌoina Yesu ꞌana tohemisao ꞌidi boda ꞌihehemadou, ma ꞌoidiyega toꞌena Gilisi ꞌidi boda toꞌena Yudiya silolomugiyedi, weyahina sabwelo ꞌaigeda ꞌaigeda, ꞌeguma tutaina ꞌeꞌahai siheheguyaiyedi hiwahiwape ꞌoidiya, taudi toꞌena Gilisi ꞌidi hiwapeyao ꞌadi ꞌeꞌahai geya sowasowahidi, ꞌoinega sigomagomale. ");
INSERT INTO bdd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Coinega Yesu ꞌana tohepwailao site tuwelo ꞌidi boda tohemisao mabwaiyadi sibwau heꞌautedima, ma ꞌoidiya sigwaeya, “Geya sowasowahina Yehoba ꞌina gwae ꞌana guguya ꞌalolagu ma ꞌabehega ꞌeꞌahai ꞌaheguyai. ");
INSERT INTO bdd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ma ꞌomi ꞌoimiyega loheloheya sebeni wahesinuwedi, taiyewedi maꞌadi heꞌasisi, ma sanasanapudi, ma wete ꞌeguma Yaluyaluwa Tabuna ꞌina waiwai ꞌoidiya, ma paihowa bewa ꞌeꞌahai ꞌana heguyai weyahina, ꞌada ꞌebwaedi. ");
INSERT INTO bdd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma tauma ꞌada hetapewa ꞌahwanoi weyahina ta wete Yehoba ꞌina gwae ꞌana heꞌita weyahina.” ");
INSERT INTO bdd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma boda siyaliyaya ꞌidi loina bewa weyahina, ꞌoinega site sebeni sihesinuwediya, beno Sitibeni, tauna ꞌina hemisa madouna Yesu ꞌoina, ma Yaluyaluwa Tabuna ꞌina waiwai ꞌoina, ma Pilipi ma Pilokolo ma Nikano ma Timoti ma Pamena ma wete Nikola, tauna gwama Anitioki ma meYudiya ꞌidi tapwalolo ꞌoina ꞌiluhu pwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Coinega loheloheyaedi siꞌabi lagasidiya Yesu ꞌana tohepwailao matadiya, ma siꞌabi debediya ma weyahidi siꞌahwa ꞌahwanoiya Yehoba ꞌoina, ma paihowaina sihegaineya. ");
INSERT INTO bdd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Coinega Yehoba ꞌina gwae ꞌihewaiwai tomota ꞌoidiya, ma tomuliyao ꞌadi boda madou hedada tupwa Yelusalema ꞌoina, ma topwaoliyao tupwana baibaiwana wete gwaeina sihesagoheya, ta Yesu sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitibeniina maꞌina waiwai, ta maꞌina helau madouna, ma paihowa ꞌebe henainaida ma ꞌilaꞌilalao ꞌipaihowediya tomota gamwagamwanidiya. ");
INSERT INTO bdd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ta tupwana tomota sinaoma ma Sitibeni baꞌidadiu siheꞌoheꞌohe, taudi tupwadi meYudiya ꞌidi tapwalolo sihesaniyeya “Lihalihasina,” ma tupwadi Yudiyaedi ꞌasa Sailini ꞌoinega, ma tupwadi ꞌasa Alekisanidela ꞌoinega, ma tupwadi ꞌasa Silisiya ma Esiya ꞌoidiyega, ");
INSERT INTO bdd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ma geya sowasowahina sihewaiwai, weyahina Sitibeni ꞌina gwae ꞌana sanapu Yaluyaluwa Tabuna ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Coinega taudi Sitibeni sitebaeya ma tupwana loheloheya sihegwaediya ma Sitibeni sida heꞌewa, sigwae, “Sitibeniina ꞌina gwae galana ꞌahesagoheya, beno Mosese ma Yehoba ꞌiꞌahwa galagalaediya.” ");
INSERT INTO bdd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ma wete loheloheya sihenuwa laguwediya ma Sitibeniina siloꞌaleheya, ꞌoinega boda baibaiwadi ma babadao ma wete loina ꞌana toheꞌitao sinaoma ma siꞌabiyahiya, ta sitoeya toloinao ꞌidi delihegogona ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ta toheꞌewa ꞌaboꞌabowedi sibwauwedima, ma taudi sigwae, “Loheya bewa tuta baibaiwana ꞌoidiya Mosese ꞌina loinao ma Hada Heꞌasisi bewa wete ꞌisinasinalidi, ");
INSERT INTO bdd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ta wete ꞌina gwae ꞌahesagoheya ꞌigwae, ꞌYesu tauna gwama Nasaleta ꞌabwa Hada Heꞌasisi bewa ꞌida ligehi yahule ma mumugada Mosese ꞌiꞌebwaegita ꞌida buidi, ma hagadi ꞌilagudi.’” ");
INSERT INTO bdd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma todeli hegogonaedi mabwaiyadi Sitibeni manina siꞌeꞌebubuya, ꞌana ꞌita anelose manina gide. ");
INSERT INTO bdd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ma Topwaoli Madouna Sitibeni ꞌihesilaleya, ꞌigwae, “Togidega ꞌidi heꞌewa weyahiu, gwae moisa ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma Sitibeni ꞌigwae, “Tasigwao ma tamagwao, ꞌigu gwae bewa wahesagohe. Yehoba tomiya hane hedada mwalohene tubudai Ebalahamo ꞌoina ꞌilatuwa, tutaina Mesopotemi ꞌoina ꞌimiyamiya, ma ꞌabwa geya ꞌiꞌasaꞌasaliya Helana ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ma Yehobaina ꞌigwae, ꞌEbalahamo, ꞌino gogo ma ꞌino susu bewa ꞌuꞌebesinedi ma ꞌutauya hali tupwa, tupwaina yaheꞌitago ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ta tupwa Kalidiya ꞌihasineya ma ꞌiloꞌasa Helana ꞌoina. Ma Ebalahamo tamana ꞌina ꞌamasa mulina Yehoba ꞌihanugeteya ma ꞌebwa ꞌiꞌasa, ꞌida gogo bewa ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ma geya ꞌeta wete baleꞌu ꞌiꞌebwae Ebalahamo ꞌina ꞌebeloina, ma hesi Yehoba ꞌigwae hemisa tuwa ma ꞌabehega tupwaina bewa tauna Ebalahamo maꞌina susuwao ꞌidi baleꞌu siꞌewa, ma tuta nage ꞌoina Ebalahamo geya natunamo. ");
INSERT INTO bdd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Ma wete Yehoba ꞌihepwaila nugeteya ꞌabehega Ebalahamo tubunao sihetaumana hali boda ꞌidi tupwa ꞌoina, ma toniꞌasaedi paihowa mwauna nata siꞌebwae Ebalahamo tubunao ꞌoidiya, ta ꞌidi miya ꞌigala bolime powa handeledi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma hesi Yehoba ꞌigwaeya, ꞌCabwa toniꞌasaowedi loina mwaudi yaꞌebwaedi, ma muliyetega tupwa nage ꞌoinega ꞌigu bodao silatu ma siꞌetuluha ꞌoiguwa tupwa bewa ꞌoina.’ ");
INSERT INTO bdd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Ma Yehoba ꞌina gwaeina ꞌana ꞌilaꞌilala ꞌiꞌebwaeya Ebalahamo ꞌwapina ꞌana ꞌupwa. Coinega Ebalahamo Aisake ꞌihenatuneya, ta ꞌina sabwelo nima ma hetoina ꞌoina ꞌwapina matana ꞌiꞌupweya, ma muliyetega Aisake Yakobo ꞌihenatuneya, ma muliyetega Yakobo natunao loheloheyadi tuwelo ꞌihenatunediya, ma site tuwelowedi tauda tubudao. ");
INSERT INTO bdd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ta ꞌaigeda ꞌoidiyega sanina Yosepa, ma tasinao site lebeni siheꞌipiꞌipiyeya ma sihegimwaneyeya tomota tupwadi ꞌoidiya, ma taudi Yosepaina sitauyeya ꞌasa Itipita ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma Yehoba baꞌidana ta ꞌilemeya ꞌana mwauyao ꞌoidiyega, ta wete sonoga bwebweꞌana ꞌiꞌebwaeya, ma meItipita ꞌidi kini Pelo sonogaina ꞌiꞌita lobeya, ꞌoinega Pelo Yosepa ꞌihemiya haneheya, ma loina ꞌiꞌebwaeya tupwa Itipita mabwaiyana weyahina, ta wete kiniina tauna ꞌina hada weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ma muliyetega gomale madouna ꞌilatuwa Itipita mabwaiyana ma ꞌasa Kenani ꞌoidiya, ma miya mwauna moisa ꞌihapwesa, ma tubudaowedi geya ꞌadimo. ");
INSERT INTO bdd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ta Yakobo tetela ꞌihesagoheya ꞌabehega ꞌeꞌahai Itipita ꞌoina ꞌimiyamiya, ma natunao loheloheyadi ꞌihesumanediya Itipita ꞌoina, ꞌeꞌahai weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma muliyetega wete sihila Itipita ꞌoina, ma Yosepa tasinao ꞌoidiya ꞌigwae latuwa, ꞌigwae, ‘Taugu tasimiu Yosepa,’ ma Pelo wete ꞌoina ꞌihepwailediya, ꞌigwae, ꞌTasigwao bewa.’ ");
INSERT INTO bdd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Ma Yosepa tamana Yakobo ma ꞌina susuwao ꞌibwauwedima, ꞌadi baibaiwa sebeniti paibi, ma Itipita ꞌoina sinaoma. ");
INSERT INTO bdd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ma nobwa Yakoboina ꞌiꞌamasa, ma wete tubudaowedi siꞌamasa, ");
INSERT INTO bdd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ta wawanidi siꞌewa hiledima gogo Sekemi ꞌoina, ma sigalihediya, galihaina mwalo Ebalahamo ꞌihemaiseya meSekemi, taudi Hemoli natunao, ꞌoidiyega, beno galihaina ꞌana maisa siliba ꞌiꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ma Yosepa ꞌina ꞌamasa mulina Yehoba ꞌina gwae hemisa Ebalahamo ꞌoina ꞌihahoho pwaiya, ma meIsileli Itipita ꞌalona siyada hedada pwaiya, ");
INSERT INTO bdd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","eema kini hauhauna ꞌihegaina ma ꞌiloina paꞌaledi, kiniina Yosepa geya ꞌisanapu, ");
INSERT INTO bdd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ma ꞌiꞌabowediya, weyahina tubudaowedi ꞌiloinaedi ma natudiyao ꞌiꞌiudi siuledi ꞌatamana ma siꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta gwama Mosese ꞌiliꞌuwa tuta nage ꞌalona, tauna ꞌana ꞌita bwebweꞌana, ma tamana ma sinana ꞌidi hada siꞌitayahi dahweya waiꞌena ꞌetoi. ");
INSERT INTO bdd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma muliyetega ꞌidi hadega silagu latuheya, ta Pelo natuna mewahinena ꞌilobeya, ta ꞌitoeya ꞌina hada ma ꞌabehega tauna natuna, ma ꞌiꞌitayahiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","“Ta Mosese meItipita ꞌidi sanapu mabwaiyana siheꞌiteya, ma ꞌisanapudiya, ta ꞌina gwaeyao ta ꞌina paihowao ꞌoidiya ꞌihewaiwai hedada. ");
INSERT INTO bdd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ma tutaina ꞌana bolime poti ꞌilobeya, Moseseina nuwanuwana ma tasinao meIsileli ꞌihaboꞌenedi. ");
INSERT INTO bdd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Coinega ꞌina haboꞌenaina ꞌalona gwama Itipita ꞌaigeda ꞌilobeya gwama Isileli ꞌihunu bwagebwageya, ꞌoinega Mosese tasinaina ꞌilemeya ma gwama Itipitaina ꞌiloheꞌamasiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta Mosese ꞌinuwatuhuya ꞌabehega tasinaowedi sida sanapu ꞌabehega tauna nimanega Yehoba ꞌida ꞌabihetedi, ma hesi geya sisanapu. ");
INSERT INTO bdd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ma hali sabwelo ta Mosese tasinao ꞌeluwa ꞌilobediya siheheꞌupwa, ma nuwanuwana ma ꞌiꞌetoꞌausidi ma silolagu ma ꞌigwae, ꞌCiyagwao, ꞌomi susu ꞌaigeda, ma togidega ma ꞌimi miya wagihegala?” ");
INSERT INTO bdd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ma toheꞌupwaowedi ꞌaigeda ꞌoidiyega Mosese ꞌina gwae ꞌihemaiseya, ma ꞌigwae, ꞌTaiya ꞌowa ꞌutoho ma ꞌuhetoloina ꞌoima? ");
INSERT INTO bdd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Togidega? Nuwanuwau ma ꞌuloheꞌamasigau gidemusa boi gwama Itipitaina ꞌuloheꞌamasiya?” ");
INSERT INTO bdd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Gwae bewa Mosese ꞌihesagoheya ma ꞌiꞌateyohowa ta ꞌidena, ma ꞌihetaumana tupwa Midiyani ꞌoina, ma nobwa ꞌihaiya ma natunao loheloheyadi ꞌeluwa ꞌihenatunediya. ");
INSERT INTO bdd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bolime poti mulina Mosese yoho ꞌawawa, ꞌoya Sainai deina, ꞌiyawayawala, ma anelose ꞌilatuwa ꞌaiwe ꞌalaꞌalata ma ninininiminega, ꞌaiwe manabaina ꞌalonega. ");
INSERT INTO bdd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ta Mosese ꞌiꞌiteya, ꞌoinega nuwana ꞌihepwanopwanowa, ma ꞌinaonao deina sabi ꞌita, ma Yehoba ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ꞌTaugu tubumwao, taudi Ebalahamo ma Aisake ma Yakobo, ꞌidi Yehoba.’ “Ma Mosese ꞌina matautega ꞌidededela, ma genuwana ꞌiꞌebubuna. ");
INSERT INTO bdd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ta Badaina ꞌigwaeya, ꞌCaheu ꞌana butu ꞌuhalolo, weyahina tupwa beno ꞌoina ꞌutotoholo beno baleꞌu heheꞌasisina, ta ꞌigu gwae ꞌuhesagohe. ");
INSERT INTO bdd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Cigu tomotaiyao Itipita ꞌalona ꞌidi miya galana yasanapuya, ta ꞌidi ꞌahwanoi ꞌatemuyamuya yahesagoha pwaiya, ꞌabehega yasuluma sabi lemedi. Ta ꞌowa ꞌutoholo ma yahewasego Itipita ꞌoina, paihowa bewa weyahina.’ ");
INSERT INTO bdd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moisa, Moseseina mwalo silogwahateya, sigwaeya, ꞌCowa hene taiya ma ꞌutoho ma ꞌuhetoloina ꞌoima?” Ma hesi tauna Yehoba ꞌihesinuweya ma ꞌabehega ꞌiloinedi, ma wete ꞌilemedi, anelose ꞌina lemega, tutaina ꞌaiwe ꞌalaꞌalata ꞌoina ꞌilatuwa ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Coinega Mosese ꞌilaꞌilala waiwaidi ma paihowa ꞌebe henainaida ꞌipaihowediya, Itipita ꞌoina ma wete hola bwehabwehalina ma tupwaina yoho ꞌawawa ꞌoidiya, tutaina Itipitega ꞌiꞌewa latuhedima ma ꞌihenugetediya tupwaina yoho ꞌawawa bolime poti ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Bewa Moseseina meIsileli ꞌihegwaediya ꞌigwae, ꞌYehoba ꞌabwa tasimiyao ꞌoidiyega ꞌaigeda palopita ꞌihesinuwe weyahimi, gide mwalo ꞌihesinuwegauwa.’ ");
INSERT INTO bdd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Ma wete Moseseina yoho ꞌawawa tubudao mabwaiyadi baꞌidanao ꞌoya Sainai ꞌoina simiyamiya, ma anelose Mosese loina bwebweꞌana yawasida weyahina ꞌiꞌebwaeya. ");
INSERT INTO bdd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ma tubudaowedi Mosese siheꞌidiꞌidiyeya ta ꞌina loina silogwahateya, ma nuwanuwadi ma sihila Itipita ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ma tasina Eloni sihegwaeya, sigwae, ꞌCida ꞌebe ꞌetuluha ꞌupaihowadi ma sihanugetegita, weyahina Mosese tauna mwalo Itipitega ꞌihanugetegitama, geya tasanapu taꞌeha nana ꞌitauya?” ");
INSERT INTO bdd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Coinega ꞌidi ꞌebe ꞌetuluha tala bulumakau siꞌabiya, ma ꞌoina sipwaopwaoli, ma weyahina siyaliyaya madouna. ");
INSERT INTO bdd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Coinega Yehoba ꞌilogwahatediya ta ꞌabehega siboi ꞌidi nuwatuhu sida paihowa, beno ꞌwadima ꞌoidiya sida ꞌetuluha, gidemusa palopitao ꞌidi buki ꞌalona Yehoba ꞌina gwae ꞌimiyamiya, ꞌigwaeya, ꞌComi meIsileli bolime poti tupwaina yoho ꞌawawa wamiyamiya, hebahebaiyao wahunudi ma geya ꞌoiguwa wada pwaolidiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma hesi hali ꞌebe ꞌetulahaina sanina Moloke ꞌoina wapwaopwaoliyedi ma Molokeina ꞌina hada waꞌahaꞌahali baꞌidamiu, ma wete Lipani ꞌina ꞌwadimaina ꞌoina watulutuluha, ma wete ginaulaedi waꞌabidiya matadiya waꞌahwaꞌahwanoi, ꞌoinega yada paꞌigomi ma watauya hali ꞌasa Babiloni papalina.’” ");
INSERT INTO bdd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitibeni wete ꞌigwaeya, “Tubudaowedi Yehoba ꞌina hada siꞌabiya ꞌana ꞌita gidemusa Yehoba Mosese ꞌihegwaeya ma ꞌida ꞌabiꞌese. Coinega siꞌabiya, ma mwalo tutaina yoho ꞌawawa sitautauya, Yehoba ꞌina hadaina wete siꞌahaꞌahala dadane. ");
INSERT INTO bdd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Loheloheyaedi siꞌamasa ma mehau hadaina siꞌeweyama, taudi tubudao Yosuwa baꞌidanao. Mwalo hali bodao tupwa bewa ꞌebwa simiyamiya, ma hesi Yehoba Yosuwa baꞌidanao ꞌilemedi ma sihewaiwaiya bodaedi sipaꞌidiya, sidena, ta Yosuwa baꞌidanao baleꞌu bewa siꞌeweya, ta ꞌebwa hadaina ꞌimiyamiya ma ꞌana siga Debida ꞌihetoloina. ");
INSERT INTO bdd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ma Debidaina weyahina Yehoba ꞌiyaliyaya, tauna tubudai Yakobo ꞌina Yehoba, ma Debida Yehoba ꞌoina ꞌiꞌahwaꞌahwanoi ma ꞌeguma sowasowahina ꞌabehega Yehoba ꞌina hada hauhauna ꞌida ꞌabi. ");
INSERT INTO bdd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma hesi Debida natuna Solomoni hadaina ꞌiꞌabiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ma hesi wanuwatuhu ꞌabehega Yehoba tauna tomiya tabwana hedada geyaꞌabwa hada tomota nimadiyega siꞌabiꞌabi ꞌoina ꞌimiyamiya, weyahina palopita ꞌaigeda Yehoba ꞌina gwae mwalo ꞌihepwaila pwaiyeya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ꞌGalewa ꞌigu wagahata wasawasa, ma baleꞌu ꞌahegu ꞌadi ꞌebelagu. Coinega to hada sowasowahimi ma weyahigu wada ꞌabi, ma hadaina ꞌoina yaꞌaiyawasi? ");
INSERT INTO bdd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Weyahina ginaulaedi bewa mabwaiyadi taugu yapaihowediya.’” ");
INSERT INTO bdd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma Sitibeni ꞌihegwaediya wete ꞌigwae, “Moisa, ꞌomi tonuwa potapota, ꞌoinega Yehoba ꞌina ꞌilaꞌilala ꞌupwa ꞌwapimimo ꞌoina, ma geya ꞌatemiyega ma wete geya tenamiya, ꞌoinega tuta baibaiwana Yaluyaluwa Tabuna ꞌina loina walologwahate, gidemusa tubumiyao silogwahateya. ");
INSERT INTO bdd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ma wete, tubumiyao palopita mabwaiyadi simumuga galagalaediya ma siloheꞌamasidiya, palopitaowedi taudi Todumwalu ꞌina latuma sihepwaila nugeteya, ꞌoinega ꞌomi wete Todumwaluina watebaeya ma waloheꞌamasiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ta ꞌomi mwalo aneloseyao Yehoba ꞌina loina siꞌebwaegomiya, ma hesi geya wada muliyeya.” ");
INSERT INTO bdd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitibeni ꞌina gwae bewa toloinao sihesagoheya ta sigamwasowala madouna, ma sihesalaꞌiꞌita ꞌidi gamwasowala weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma hesi Yaluyaluwa Tabuna Sitibeni ꞌilohemaheya, ma galewa ꞌiꞌeꞌebubuya ta ꞌiꞌiteya Yehoba maꞌina wasawasa maemaedanina, ma Yesu ꞌina ꞌebeulega ꞌitotoholo, ");
INSERT INTO bdd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ma ꞌigwaeya, “Waꞌita, galewa ꞌiꞌesoꞌeya, ta yaꞌiteya Loheyaina Yehoba ꞌina ꞌebeulega ꞌitotoholo.” ");
INSERT INTO bdd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma Sitibeni ꞌana ꞌalehao siwuiwui ꞌenadi madounega, ma tenadi siꞌausidiya ta ꞌabehega Sitibeni ꞌina gwae sahena sihehesagohe, ma mabwaiyadi sipiliya, ta siꞌabiyahiya, ");
INSERT INTO bdd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ma ꞌasega siula latuheya, ma daꞌuleyega siꞌahuhe ꞌamasiya. Ma Sitibeni ꞌana toheꞌewa ꞌaboꞌabowao ꞌadi ꞌaleꞌowao silolodiya ta ꞌabehega daꞌuleyega Sitibeni sida hunu. Ma ꞌadi ꞌaleꞌowedi hewali sanina Saulo ꞌiꞌitayahidiya. ");
INSERT INTO bdd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eema Sitibeni silolodaꞌuleyeya, ma hesi ꞌibwau haneya ꞌigwae, “Bada Yesu, yaluyaluwagu ꞌuꞌeweyawa.” ");
INSERT INTO bdd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ta ꞌiꞌahetulasa, ꞌibwau ꞌenana madounega, ꞌigwaeya, “Bada yo, ꞌidi mumuga galana bewa geyaꞌabwa ꞌuhehemaise ꞌoidiya.” Cina gwaeina ꞌigumwala, ta yawasina ꞌigumwala. ");
INSERT INTO bdd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Saulo bodaedi ꞌiꞌahwa bwebweꞌanediya, Sitibeni ꞌana loheꞌamasa weyahina. Sabwelo nage ꞌoina tohekalesiyao tupwa Yelusalema ꞌoina ꞌadi ꞌalehaowedi sihegaina ma siloꞌalehedi, ꞌoinega sisawala Yudiya ma Sameliya tupwaedi ꞌoidiya, ma Yesu ꞌana tohepwailao site tuwelomo Yelusalema ꞌoina simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ma tupwana tomota, taudi Yehoba ꞌana toheꞌasisiyao, Sitibeniina sigaliheya maꞌidi dou madouna. ");
INSERT INTO bdd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma Saulo hesi tohekalesiyao ꞌimutumutudi ta weyahidi ꞌiluhuluhu hada ꞌaigeda ꞌaigeda ꞌoidiya, ma ꞌeguma tohekalesiyao loheloheya ma wete wahiwahine ꞌilobalobadi, tuwa ꞌiꞌabiyahidi, ma deliya ꞌilagu luhuwedi. ");
INSERT INTO bdd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma tohekalesiyao sisawala, ma ꞌeguma to tupwa ꞌoina sitautauya, tetela bwebweꞌana siloguguyaeya tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Coinega Pilipi ꞌisulu ꞌaigeda Sameliya ꞌasaina ꞌoina, ma nobwa Toꞌabihetenaina tetelina ꞌiguguyaeya ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ta mabwaiyadi Pilipi ꞌina gwae sihesagoheya, ma ꞌina paihowa waiwaidi siꞌiteya. ");
INSERT INTO bdd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ceguma taiyawedi silohala hiꞌahiꞌa* ꞌoidiyega ꞌiula latuhedi, ma hiꞌahiꞌaedi siwuiwui ma sihapwesa, ma wete topeuyao ma tohasagesageula ꞌiꞌabihe bwebweꞌanediya. Coinega bodaedi sitagwatagwala mahemahetena Pilipi ꞌina loguguya ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ma ꞌoinega ꞌebe yaliyaya madouna gogoina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma toniꞌasa ꞌaigeda, sanina Saimoni, tauna Pilipi ꞌina gwae ꞌihemiseya. Saimoniina tauna mwalo ꞌiꞌobaꞌoba madouna gogoina ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ma meSameliya mabwaiyadi sihenainaida Saimoni ꞌina paihowa waiwaidi weyahidi, eema tauna sanina madouna. Coinega tomota mabwaiyadi, nuwana babadao, nuwana bubutumao, Saimoniina sihemisaeya ma sigwaegwae, “Tauna Saimoniina ꞌina waiwai Yehoba ꞌoinega madou hedadena.” ");
INSERT INTO bdd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Coinega Saimoni ꞌina gwaeyao sihesagohediya, weyahina ꞌina ꞌobega ꞌiꞌabihenuwa pwanopwanowediya tuta mabwaiyana. ");
INSERT INTO bdd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma muliyetega Pilipi ꞌihapwesama ma tetela bwebweꞌana, Toꞌabihetena Yesu sanina ma Yehoba ꞌina loina weyahidi ꞌiloguguya, ma sihemisaeya, ma sibabitaisowa, loheloheya ma wete wahiwahine. ");
INSERT INTO bdd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ma Saimoni wete Yehoba ꞌihemiseya, ta ꞌina babitaiso mulina Saimoni Pilipi ꞌiꞌwayabuya ma Saimoniina ꞌiꞌiteya Pilipi ꞌina ꞌilaꞌilalao ma ꞌina paihowa waiwaidi, ta ꞌoinega ꞌihenainaida moisa. ");
INSERT INTO bdd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eeta Yesu ꞌana tohepwailao taudi Yelusalema ꞌoina simiyamiya, tetela sihesagoheya ꞌabehega meSameliya sitagwala pwaiya Yehoba ꞌina gwae ꞌoina, ꞌoinega Pita ma Yoni sihewasedima, ");
INSERT INTO bdd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ta siteluwaedi sisuluwa Sameliya ꞌoina, ma tohemisao hauhaudi weyahidi siꞌahwaꞌahwanoi ma ꞌabehega Yaluyaluwa Tabuna ꞌiluhu ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Weyahina ꞌabwa geya ꞌiluhu ꞌoidiya. Beno tuwa Bada Yesu saninega sibabitaisowa, ");
INSERT INTO bdd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ꞌoinega Pita ma Yoni nimadi silagudiya ꞌoidiya ta Yaluyaluwa Tabuna ꞌoidiya ꞌiluhuwa. ");
INSERT INTO bdd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ta Saimoni paihowa bewa ꞌiꞌiteya ꞌabehega Yesu ꞌana tohepwailao nimadi silagudiya tomota ꞌoidiya, ma Yaluyaluwa Tabuna ꞌoidiya ꞌiluhuwa, ꞌoinega mane ꞌiꞌeweya ma ꞌabehega Pita ma Yoni ꞌiꞌebwaedi, ");
INSERT INTO bdd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ta ꞌigwaeya, “Cimi waiwai beno nuwanuwagu waꞌebwaegau, ma ꞌoinega ꞌeguma nimagu yalagu taiyawedi ꞌoidiya, Yaluyaluwa Tabuna ꞌiluhu ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma Pita Saimoni ꞌiheliyeya ꞌigwae, “Cino mane baꞌidau wahesilae hataya, weyahina ꞌabehega Yehoba ꞌina ꞌehele ꞌino maneyega ꞌugimwane. ");
INSERT INTO bdd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Cowa geya ꞌima boda, ma hesi ꞌateu ꞌimumuga galagala Yehoba matana. ");
INSERT INTO bdd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Coinega ꞌilobwainegowa ma ꞌino pui bewa ꞌoinega ꞌunuwabui, ma ꞌuꞌahwaꞌahwanoi Yehoba ꞌoina, ma nuwana ꞌino nuwatuhu galadi bewa ꞌinuwasamudi. ");
INSERT INTO bdd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Weyahina yasanapugowa ꞌateu biꞌibiꞌina, heꞌipiꞌipi ma mumugau galadi ꞌoidiyega.” ");
INSERT INTO bdd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma Saimoni ꞌigwaeya, “Waꞌahwanoi Bada ꞌoina ma ginaulaedi galadi wahepwailediya, sahena ꞌoiguwa sinaonaoma.” ");
INSERT INTO bdd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Coinega Pita ma Yoni ꞌidi Bada weyahina sihepwaila latuwa, ma ꞌina gwae siguguyaeya, ma muliyetega sihila Yelusalema ꞌoina, ta ꞌidi tauya ꞌalona tetela bwebweꞌana sihepwaileya Sameliya ꞌasanao ꞌaigeda ꞌaigeda ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma Yehoba ꞌina anelose Pilipi ꞌihegwaeya, “Cutoholo ma ꞌasudibwalala ꞌedaina Yelusalemega ma ꞌasa Gasa ꞌoina ꞌutauya.” Cedaina tupwa yoho ꞌawawa ꞌalonega ꞌitautau. ");
INSERT INTO bdd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Coinega Pilipi ꞌitoholowa ma ꞌitauya, ma gwama Idiopiya ꞌina waga lisilisi ꞌoinega ꞌitautauya ꞌilobeya, tauna ꞌwawana boꞌi siꞌewa yahuleya, ma sanina madouna, ta ꞌidi kuini Kanidesi weyahina ꞌipaipaihowa, beno ꞌina wasawasa mabwaiyana ꞌiꞌitaꞌitayahidi, ma tauna ꞌitauya pwaima Yelusalema sabi tapwalolo, ");
INSERT INTO bdd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ta ꞌina waga lisilisi ꞌihilahila ꞌina ꞌasai, waga lisilisiina ꞌoina ꞌigeluwa ma Buki Heꞌasisi ꞌihasihasila, palopita Aiseya ꞌina lele ꞌihasihasili. ");
INSERT INTO bdd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Yaluyaluwa Tabuna Pilipi ꞌihegwaeya, “Culomwayamwayau ma ꞌutauya waga lisilisi ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Coinega Pilipi ꞌipiliya, ma loheyaina ꞌenana ꞌihesagoheya palopita Aiseya ꞌina lele ꞌihasihasili. Ta Pilipi ꞌigwaeya, “Togidega, gwaeyedi ꞌuhasihasili ꞌusanapudiya?” ");
INSERT INTO bdd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ta loheyaina ꞌigwaeya, “Geya. Weyahina geya wete ꞌigu toheꞌitamo.” Coinega loheyaina Pilipi ꞌibwauweyama wagai, ma Pilipi ꞌigeluwa ta deina ꞌimiyatoiya, ta Buki Heꞌasisiina ꞌihasiliya, ");
INSERT INTO bdd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ta hasiliina ꞌihasila pwaiya bewa gide ꞌina gwae, “Tauna gide sipi nata sihunu, nuwana gidemusa lami, hunuhunuwana ꞌana toꞌupwa matana ꞌitotoholo, geya ꞌaigeda wete ꞌenana ꞌigwae latu. ");
INSERT INTO bdd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma wete ꞌina yatala ꞌoina siꞌaboweya, ma ꞌidebamwadina. Coinega natunao tetelidi geya ꞌaigeda taiya ꞌihepwaila latu weyahina yawasina baleꞌuwa ꞌigumwagumwala.” ");
INSERT INTO bdd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ta gwama Idiopiyaina Pilipi ꞌihegwaeya, “Taiya weyahina palopita bewa ꞌigwaegwaeya? Tauna weyahina bo hali loheya weyahina?” ");
INSERT INTO bdd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Coinega Pilipi ꞌigwaeya, “Yesu weyahina,” ma ꞌihegaina hasilaina ꞌana lihasa weyahina ta Yesu tetelina ꞌiheꞌitaeya. ");
INSERT INTO bdd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ta ꞌedaina sitautau ta weꞌaha siꞌita lobeya, ma loheyaina ꞌigwaeya, “Nage weꞌaha! Togidega, sowasowahina ma ꞌuꞌabihe babitaisogau, ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO bdd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Coinega ꞌina topaihowao ꞌiloinaediya ma waga lisilisi siꞌabi henonoya, ma siteluwa Pilipi mahetena sisuluwa ta sigayo suluwa weꞌaha, ma Pilipi loheyaina ꞌiꞌabihe babitaisoya. ");
INSERT INTO bdd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ma weꞌahega sigayohanema ta Yehoba Yaluyaluwana Pilipi ꞌitoeya, ma loheyaina geya Pilipi ꞌiꞌitaꞌita hila, ta maꞌina yaliyaya ꞌitauya ꞌina ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Pilipi hesi silobeya tupwa Asota ꞌoina, ma ꞌoinega ꞌitautau, ma tetela bwebweꞌana ꞌiloguguyaeya ꞌasa ꞌaigeda ꞌaigeda ꞌoidiya, ma ꞌana siga ꞌilatu Sisaliya. ");
INSERT INTO bdd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma Saulo ꞌabwa tuwa Bada Yesu ꞌana tomuliyao ꞌoidiya ꞌiloloꞌalehedi, nuwanuwana ꞌiloheꞌamasidi. Coinega ꞌitauya Topwaoli Madouna ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nuwanuwana ꞌina letao ꞌileledi ma ꞌitauyedi meYudiya ꞌidi ꞌetoꞌautaina Damasiko ꞌoina, ma letaedi ꞌoidiyega ꞌabehega ꞌeguma Yesu ꞌina ꞌeda ꞌana tomuliyao ꞌilobadi loheloheya ma wahiwahine, ꞌiꞌabiyahidi ma ꞌiꞌewedima Yelusalema, sabi heyatalaedi. Eema letaedi ꞌiꞌewediya ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Citautauya ta Damasiko ꞌoina ꞌiꞌiunamo ꞌilatu, ma maedana galewega ꞌiꞌasilalama, ");
INSERT INTO bdd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ta ꞌibeꞌuwa baleꞌuwa, ma ꞌaigeda ꞌenana ꞌihesagoheya ꞌigwaegwae, “Saulo, Saulo, toꞌaha weyahina ꞌuloloꞌalehegau?” ");
INSERT INTO bdd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Saulo ꞌigwaeya, “Bada taiya hede ꞌowa?” Ma ꞌenanaina ꞌigwaeya, “Taugu Yesu ꞌuloloꞌalehegau. ");
INSERT INTO bdd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma hesi ꞌutoholo ma ꞌuluhu ꞌasai ma nobwa ꞌa hemataluwa ꞌuhesagohe ma ꞌabehega ꞌupaihowa.” ");
INSERT INTO bdd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma tomotaiyedi Saulo baꞌidanao sitautauya nuwadi ꞌihepwanopwanowa ta sitoholo henonowa, ma ꞌenanamo sihesagoheya, ma geya ꞌaigeda wete taiya siꞌita. ");
INSERT INTO bdd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Coinega Saulo baleꞌuwega ꞌitoholo hilama ta nuwanuwana ma matana ꞌiyahali, ma hesiyage geya sowasowahina toꞌaha ꞌiꞌita, weyahina matana sihogahoga, ma hesi Saulo siꞌabinimeya ma siluhuweya Damasiko ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ta nobwa sabwelo ꞌetoi geya toꞌaha ꞌida ꞌiteya, ma geya ꞌida ꞌaiya ma wete geya ꞌida numa. ");
INSERT INTO bdd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ma Damasiko ꞌoina, Yesu ꞌana tomuliya ꞌaigeda ꞌimiyamiya, sanina Ananaiyasi, ta ꞌina ꞌenomataꞌiteꞌitega Yehoba ꞌihegwaeya, ꞌigwae, “Ananaiyasi.” Ma Ananaiyasiina ꞌigwaeya, “Taugu Bada.” ");
INSERT INTO bdd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Coinega Yehoba ꞌigwaeya, “Cutoholo, ma ꞌasa gamwagamwanega ꞌutauya ꞌeda sanina Dumwaluna ꞌoinega, ma Yudasa ꞌina hada loheya ꞌaigeda ꞌuhesilala, tauna gwama Tasisi sanina Saulo, ma sauga bewa ꞌiꞌahwaꞌahwanoi, ");
INSERT INTO bdd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma ꞌaigeda loheya sanina Ananaiyasi ꞌiꞌiteya ꞌitautauyama sabi ꞌabitohoina ma ꞌoinega matana siꞌasilala hila.” ");
INSERT INTO bdd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma Ananaiyasiina ꞌigwaeya, “Bada, loheyaina tetelina tomota baibaiwadi sihegwaegauwa ꞌabehega loheya galana, ta ꞌino tohemisao Yelusalema ꞌoina ꞌiloloꞌaleha hedadadi, ");
INSERT INTO bdd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ma wete topwaoli madoudi sitagwaleya ma sauga bewa ꞌitauyama ma ꞌa bodao mabwaiyama sabi paimai, ꞌeguma saniuwega ꞌaꞌahwaꞌahwanoiwa.” ");
INSERT INTO bdd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma Badaina ꞌihegwaeya, “Tuwa, ma ꞌutauya ꞌoina. Weyahina Sauloina yahesinuwa pwaiya ma teteligu ꞌihepwaile tomiya ganamuli ꞌoidiya, ma toloinao madoudi matadiya ma meIsileli wete ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma ꞌabwa taugu yaheꞌitae muyao madoudi nata ꞌilobadi ꞌagu hepwaila weyahina.” ");
INSERT INTO bdd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Coinega Ananaiyasi ꞌitoholowa ma ꞌitauya Yudasa ꞌina hada, ꞌiluhuwa ta Saulo ꞌiꞌabidebeya, ma ꞌigwaeya, “Tasigu Saulo, Badaina Yesu ꞌedai ꞌilatuwa ꞌoiuwa, tauna bewa ꞌihewasegauwa matau ꞌana ꞌabiheꞌasilala weyahina, ma wete ꞌabehega Yaluyaluwa Tabuna ꞌoinega ꞌilohemahego.” ");
INSERT INTO bdd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Coinega Saulo matanega gide ꞌwenahi sibeꞌuwa mwayamwayauwa ta ꞌiꞌebubuna hila. Ma ꞌitoholoma, ꞌibabitaisowa, ");
INSERT INTO bdd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma wete ꞌeꞌahai ꞌiꞌeweya ta ꞌilohepaꞌala. Ma tupwana sabwelo ꞌoidiya Saulo Yesu ꞌana tomuliyao baꞌidanao simiyamiya Damasiko ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma meYudiya ꞌidi hada tapwalolo ꞌoidiya Sauloina ꞌihegaina ꞌiloguguya ꞌabehega Yesu tauna Yehoba natuna moisa. ");
INSERT INTO bdd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma ꞌana tohesagohao nuwadi ꞌihenainaida madouna ma sigwaeya, “Ciya, ꞌina guguya bewa wada hesagohe? Tauna mwalo Yesu ꞌana tomuliyao Yelusalema ꞌoina ꞌiloloꞌalehedi, ta wete bewa ꞌina tauyama huhuna ꞌabehega Yesu ꞌana tomuliyaedi ꞌebwa simiyamiya ꞌiꞌabiyahidi ma ꞌipaidi ma ꞌihiledi Yelusalema, topwaoli madoudi ꞌoidiya, ma togidega ꞌina nuwabui ꞌiloba ꞌeseya?” ");
INSERT INTO bdd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma Saulo ꞌina guguya nage ꞌoina ꞌihewaiwai hedadeya, ma meYudiyaedi Damasiko ꞌoina simiyamiya ꞌiheꞌitediya ꞌabehega Yesu tauna Toꞌabihetenaina, ma geya wete ꞌidi ꞌebe gwaemo. ");
INSERT INTO bdd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saulo Damasiko ꞌoina ꞌimiyamiya, ma meYudiya siloiloina ma sida loheꞌamasi, ");
INSERT INTO bdd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ma Saulo hesi ꞌidi loina dahwana ꞌihesagoheya ꞌabehega ꞌasa ꞌana ꞌahwaꞌedao silomatayahidi ma ꞌane to tuta Saulo ꞌilatu sida loheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Coinega hinuwana Saulo ꞌana tomuliyao kodo madouna ꞌoina sidoꞌoya, ma ꞌasa ꞌana ꞌabwalu tabwanega sihedawedaweya gwahunega, ma ꞌitauya. ");
INSERT INTO bdd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ta Sauloina ꞌihila Yelusalema ma ꞌitoho ma ꞌiluhu Yesu ꞌana tomuliyao ꞌoidiya, ma simatauteya, weyahina geya sihemise ꞌabehega ꞌinuwabui pwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma Banaba ꞌiboimo ꞌilemeya Saulo, ma ꞌitoeya Yesu ꞌana tohemisao ꞌoidiya, ma ꞌiheꞌoteꞌotetela ꞌabehega Saulo ꞌedai ꞌidi Badaina ꞌilobeya ma ꞌenana ꞌihesagoheya, ꞌoinega Damasiko ꞌoina maꞌina ꞌatepatu Yesuina weyahina ꞌiguguya. ");
INSERT INTO bdd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Coinega sitagwala Saulo ꞌoina ta ꞌiluhuwa ꞌadi boda ꞌoina. Ma ꞌidi paihowa mabwaiyana Yelusalema ꞌoina tauna baꞌidanao simiyamiya. Ma Sauloina maꞌina ꞌatepatu ꞌihewaiwai Bada Yesu ꞌana loguguya weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma meYudiya taudi toꞌena Gilisi Saulo baꞌidadiu sihegwaegwae ma siheꞌoheꞌohena, ꞌoinega taudimo siloiloina ma togidega ma siloheꞌamasi ꞌese. ");
INSERT INTO bdd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ta ꞌidi loinaina tohekalesiyao sihesagoheya ta Saulo sitauyeya Sisaliya, ma nage ꞌoinega sihewasaeya, ꞌitauya Tasisi. ");
INSERT INTO bdd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nage ꞌoina tohekalesiyao meYudiya ma meGalili ma meSameliya ꞌasaedi ꞌoidiya simiya daumwala, ma sipaꞌala, maꞌidi heꞌasisi ꞌidi Badaina ꞌoina, ma Yaluyaluwa Tabuna ꞌina ꞌitayahina ꞌoinega ꞌadi boda ꞌimadouwa. ");
INSERT INTO bdd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ma Pita ꞌisakosakowasi tohekalesiyao ꞌoidiya ma ꞌidobi ꞌaigeda ꞌasa sanina Lida ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ta ꞌaigeda loheya topeu ꞌilobeya, sanina Iniya, tauna bolime ꞌeit ꞌina ꞌebeꞌeno ꞌoina ꞌiꞌenoꞌeno ma geya sowasowahina ma ꞌiyawala. ");
INSERT INTO bdd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita ꞌihegwaeya, ꞌigwae, “Iniya, Yesu Keliso ꞌigihe bwebweꞌanego, ꞌoinega ꞌutoholo ma ꞌino sita ꞌuꞌatububudi.” Ta ꞌitoholo mwayamwayauwa. ");
INSERT INTO bdd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma tomotaedi Lida ma Seloni ꞌadi tomiyanao siꞌiteya, ta sinuwabuiya, ma ꞌoinega Bada Yesu sihemiseya. ");
INSERT INTO bdd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ma ꞌasa Yopa ꞌoina, Yesu ꞌana tomuliya ꞌaigeda wahine ꞌimiyamiya, sanina Tabita, ta ꞌana bui Dokasa, ꞌana bui hebai sanina diya, ma wahineina ꞌabihetena ta helau huhuna. ");
INSERT INTO bdd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma ꞌilohala ma ꞌiꞌamasa. Coinega wawaninamo siꞌeweya ma sihehatuiya, ma hada tabwana ꞌalona silaguya. ");
INSERT INTO bdd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ta ꞌasaina Yopa, Lida ꞌoinega geya bwaga, ma tohekalesiyao sihesagoheya ꞌabehega Pita ꞌasa Lida ꞌoina ꞌimiyamiya, ꞌoinega tomota ꞌeluwa sihewasaediya Lida ꞌoina Pita sabi toeina, ma Lida ꞌoina silatuwa, ma Pita siꞌahwanoiyeya, sigwae, “Bada, ꞌunaoma talomwayamwayau ꞌima ꞌasa.” ");
INSERT INTO bdd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ma Pita ꞌigogona ma baꞌidanao sitauyama Yopa ꞌoina, ta tohekalesiyao Pita sitoeya hadaina ꞌalona. Ma hiwapeyao baibaiwadi Pita sitoholo ꞌwabuꞌwabuya ma sidoudou ta ꞌadi ꞌaleꞌo siheꞌitaeya, weyahina mwalo Dokasa tutaina mayawasina ꞌadi ꞌaleꞌowedi ꞌipaihowediya, ma ꞌiꞌebwaediya, ma sigwae, “Caleꞌowedi bewa tauna Dokasa ꞌana sahisahilao mwalo mayawasina baꞌidamai ꞌamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ma Pita ꞌiloinaediya ta hadega sihapwesa, ma taunamo ꞌimiyamiya ma ꞌiꞌahetulasa ma ꞌiꞌahwanoi Yehoba ꞌoina, ꞌoinega ꞌiꞌita hila ma wawanina ꞌihegwaeya, ꞌigwae, “Tabita ꞌutoholo.” Ta Tabita matana ꞌiyahaliya ma Pita ꞌiꞌiteya, ꞌoinega ꞌenoꞌenowega ꞌimiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ta Pita nimana ꞌiꞌabiyahiya ma ꞌiꞌabihe toholoya. Ciꞌabihe toholoya ma hiwahiwape ta tohekalesiyaowedi ꞌibwauwedima, ma Tabita mayawasina ꞌiheꞌitaeya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ma wasaina ꞌiꞌelelewana tupwa Yopa mabwaiyana ꞌoidiya, ta tomota mabwaiyadi Bada Yesu ꞌoina sihemisa. ");
INSERT INTO bdd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita Yopa ꞌoina ꞌimiya ꞌamana, loheya sanina Saimoni ꞌina hada, tauna ꞌina paihowa hebai ꞌwapidi ꞌoidiyega tobwatobwa ꞌipaipaihowadi. ");
INSERT INTO bdd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma ꞌasa Sisaliya ꞌoina ꞌaigeda loheya sanina Konilio ꞌimiyamiya, tauna meLoma toloꞌalehao ꞌadi baibaiwa handeledi ꞌadi tohanugeta, boda Itali ꞌoinega, ");
INSERT INTO bdd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ma tauna loheya bwebweꞌana, ta maꞌina susuwao Yehoba siheꞌasisiyeya, ma tuta baibaiwana wewelohedi ꞌilemelemedi, ma ꞌiꞌahwaꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ma sabwelo ꞌaigeda ꞌoina ꞌilahilahiya, Konilioina ꞌina ꞌenomataꞌiteꞌitega Yehoba ꞌina anelose ꞌaigeda ꞌitautauyama ꞌoina, ma ꞌiꞌita bwaibwainiya, ma aneloseina ꞌigwaeya, “Konilio!” ");
INSERT INTO bdd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma Konilio aneloseina ꞌiꞌebubuya, ta maꞌina matauta, ma ꞌigwae, “Bada toꞌaha?” Ma anelose ꞌigwaeya, “Yehoba ꞌino ꞌahwanoiyao ma ꞌino ꞌabihetenao taudi wewelohedi ꞌoidiya ꞌisanapudiya, ma weyahidi ꞌinuwatuhugowa. ");
INSERT INTO bdd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Coinega ꞌino topaihowao tupwadi ꞌuhetunedi ma sitauya Yopa, ma Saimoni tauna sibwauweya Pita sitoeyama. ");
INSERT INTO bdd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ma Pitaina ꞌaigeda wete Saimoni ꞌina hada holai ꞌoina ꞌimiyamiya ma Saimoniina ꞌina paihowa hebai ꞌwapidiyega tobwatobwa ꞌipaipaihowa.” ");
INSERT INTO bdd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aneloseina ꞌina gwae ꞌigumwala ma ꞌitauya, ta Konilio ꞌina topaihowao ꞌeluwa ꞌibwauwedima ta ꞌina toloꞌaleha ꞌaigeda, tauna wete Yehoba ꞌana toheꞌasisi madouna. Taudi sitetoiyedi ꞌana tolemao bwebweꞌadi. ");
INSERT INTO bdd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sitetoiyedi sitauyama ma anelose ꞌina hepwaila Konilio ꞌiheꞌoteꞌoteteliya ꞌoidiya, ma ꞌihetunedi Yopa ꞌoina, ma sitauya. ");
INSERT INTO bdd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mali sabwelo ꞌasudibwalala ꞌabwama sitautauya ma ꞌasa Yopa sihahohoya, ta Pita hadai ꞌimiyamiya ta ꞌihane tabwana sabi ꞌahwanoi. ");
INSERT INTO bdd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ciꞌahwaꞌahwanoi ta maꞌina gomale madouna. Cabwama hadai ꞌeꞌahai sigibugibubu ma Pita ꞌiꞌeno mataꞌitaꞌita, ");
INSERT INTO bdd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ma galewa ꞌiꞌiteya ꞌiꞌegegeya, ma ꞌaigeda ginaula ꞌiꞌiteya ꞌisuluma, ꞌana ꞌita gidemusa ꞌaleꞌo madouna papalina matadiyao powa ꞌoidiyega sihedawedawe suluheyama baleꞌuwa, ");
INSERT INTO bdd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ma ꞌalona hali hebai ma hali hebai ta hebai ꞌawaꞌawalidi ma hali bwasumo ma hali bwasumo. ");
INSERT INTO bdd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ta ꞌaigeda ꞌenana Pita ꞌoina ꞌigwaeya, ꞌigwae, “Pita ꞌutoholo ma ꞌa hebai ꞌuhunudi ma ꞌuꞌai.” ");
INSERT INTO bdd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Pita ꞌilogwahata, ꞌigwae, “Bada tuwa, weyahina geya ꞌaigeda wete hebai ꞌetoꞌetobodana bewama gidemusa yada ꞌaidi.” ");
INSERT INTO bdd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma ꞌenanaina ꞌigwae hila, ꞌigwae, “Yehoba hebai beno ꞌigihe bwebweꞌana pwaiya, ma gesowana ꞌuꞌahwaꞌahwa galagalaedi.” ");
INSERT INTO bdd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ginaula bewa matoi Pita ꞌoina ꞌihapwesa ma ꞌenanaina matoi gidemusa ꞌihegwaeya, ma muliyetega ginaulaina ꞌihila galewa. ");
INSERT INTO bdd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma Pita ꞌinuwanuwa ꞌedaꞌedadama ꞌabehega toꞌaha ꞌenomataꞌitaꞌita bewa ꞌiꞌita pwaiya, ta tomota sitetoiyedi Konilio ꞌihetunedima sihapwesa hadai, weyahina ꞌasai silatu pwaima, ma Saimoni ꞌina hada tomota ꞌoidiya sihesilaleya. ");
INSERT INTO bdd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Coinega silobeya ma hada mata ꞌahwaina sitoholo ma sibwau, “Ciyamayao, Saimoniina sihesaniyeya Pita, beno hadai ꞌimiyamiya, bo geya?” ");
INSERT INTO bdd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma hadaina tabwanina Pita maꞌina nuwa ꞌedaꞌedadama ꞌimiyamiya ma Yaluyaluwa Tabuna ꞌoina ꞌigwaeya, “Pita, loheloheya ꞌetoi siꞌebeꞌebesego, ma sitauya pwaima gabula. ");
INSERT INTO bdd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Coinega ꞌutoholo ma ꞌusulu ꞌoidiya, ma baꞌidamwao watauya, ma geya sowana ꞌuꞌateꞌateyoho, weyahina taugu tomotaiyedi yahetunedima.” ");
INSERT INTO bdd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Coinega Pitaina ꞌisuluwa ꞌoidiya ma ꞌigwaeya, “Taugu Pita! Toꞌaha weyahina watauyama?” ");
INSERT INTO bdd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma sigwaeya, “Konilio ꞌihetunemaiya, tauna toloꞌalehao ꞌadi tohanugeta, ma loheya dumwadumwaluna ma Yehoba ꞌana toheꞌasisi, ma wete Yudiya mabwaiyadi siꞌahwa loheya bwebweꞌaneya, ta ꞌana hemataluwa ꞌihesagoheya Yehoba ꞌina anelose ꞌoinega ma ꞌabehega ꞌowa ꞌibwauwego tauna ꞌina hada ma ꞌino gwae ꞌida hesagohe.” ");
INSERT INTO bdd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Coinega Pita loheloheyaedi ꞌibwauwediya, ma hadaina ꞌoina sihetaumana. Gona ꞌiꞌadaleya ma sitoholowa, ta Pita baꞌidanao sitauya, ma tupwadi ꞌiyadiyao Yopa ꞌoinega baꞌidadiyao wete sitauya. ");
INSERT INTO bdd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sitautauya ma hali sabwelo sihapwesa Sisaliya. Ma nage ꞌoina Konilio ꞌina susuwao ma ꞌiyanao ꞌibwau hegogonedima, ta ꞌina hada siyamwayamwa. ");
INSERT INTO bdd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Coinega Pita ꞌilatuma hadai, ma Konilio ꞌihapwesa Pita matana ꞌibeꞌu suluwa ma ꞌiꞌetuluha. ");
INSERT INTO bdd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma Pita Konilio ꞌigihetoholoya ma ꞌigwaeya, “Cutoholo. Taugu loheya tuwa gide ꞌowa.” ");
INSERT INTO bdd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Coinega Pita ma Konilio baꞌidana sihehegwaegwae ta siluhuwa hadai, ma Pita boda hada ꞌalona ꞌiꞌitediya, ");
INSERT INTO bdd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ma ꞌihegwaediya, “Comi geya Yudiya, tauma meYudiya ꞌama loina wasanasanapu ꞌabehega geya ꞌada boꞌenegomi, wete geya baꞌidamao tada heꞌiyaꞌiyagu. Ma hesi Yehoba ꞌenomataꞌiteꞌitega ꞌiꞌitegauwa ma gesowana ꞌaigeda tomota yaꞌahwa galagalae. ");
INSERT INTO bdd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Coinega tutaina Konilio ꞌibwauwegauma geya yalogwahata, ma hesi yatagwalegau ma yatauya pwaima. Ma toꞌaha weyahina ꞌubwauwegauma?” ");
INSERT INTO bdd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ta Konilio ꞌigwaeya, “Bewa weyahina, sabwelo ꞌetoi sigumwala ꞌoina lahilahiya, gidemusa bewa ꞌana tuta ꞌahwanoi Yehoba ꞌoina, ma ꞌaigeda loheya yaꞌiteya mataguwa ꞌitotoholo, maꞌana ꞌaleꞌo ꞌasilalaina. ");
INSERT INTO bdd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma ꞌihegwaegau, ꞌigwaeya, ꞌKonilio, Yehoba ꞌino ꞌahwanoi ꞌihesagoha pwaiya ma wete ꞌino lema wewelohe ꞌoidiya ꞌinuwatuhu yahiya. ");
INSERT INTO bdd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Coinega ꞌino hewaliyao ꞌuhetunedi Yopa ꞌoina ma Saimoni sibwauweyama, tauna sihesaniyeya Pita, ma hali Saimoni ꞌina hada, Yopa ꞌoina gadowa, ꞌimiyamiya, ma hali Saimoniina ꞌina paihowa hebai ꞌwapidiyega tobwatobwa ꞌipaipaihowadi.’ ");
INSERT INTO bdd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ma yalomwayamwayau ta ꞌigu hewahewaliyedi yahetunediwa ta sibwauwegoma, ma ꞌutagwalegowa ꞌutauyama, ta yauwedo. Coinega bewa tuwa mabwaiyama Yehoba matana ꞌadeli ꞌautama ma toꞌaha Badaina ꞌiloinegowa ꞌuhegwaemai ma ꞌahesagohe.” ");
INSERT INTO bdd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ta Pita ꞌihegwaediya ꞌigwae, “Moisa! Bewa nuwagu ꞌisabwalena ꞌabehega tomota mabwaiyadi Yehoba matana mahemahetena, ma geya meYudiyamo ꞌihelauwedi, ");
INSERT INTO bdd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ma hesi hali tupwa ma hali tupwa tomoteninao ꞌeguma siheꞌasisiye ma simumuga dumwalu, ꞌiyaliyaya weyahidi. ");
INSERT INTO bdd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ma Toꞌabihetena Yesu tauna mabwaiyada ꞌida Bada, ta Yehoba ꞌina wasa bwebweꞌana ꞌiꞌebwaeya Yesuina ꞌoina, tauma meIsileli ꞌima ꞌebe yaliyaya weyahina. Ma ꞌomi wasaina wasanasanapu, ");
INSERT INTO bdd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","weyahina Yoni wasaina ꞌihegaineya Galili ꞌoina tutaina ꞌiloguguya, ma tomota ꞌigihe babitaisowediya, ma muliyega Yesu wasaina ꞌiꞌelelewaneya Yudiya tupwanao mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wasaina ꞌabehega Yehoba Yesu gwama Nasaleta ꞌigihe waiwaiyeya Yaluyaluwa Tabuna ꞌoinega, ma ꞌisakowasi ma tomota ꞌilemelemedi, ta ꞌeguma taiyawedi Tomudulele ꞌigihe lohalediya Yesu ꞌiꞌabihe bwebweꞌanedi, weyahina Yehoba ꞌina waiwai ꞌoina ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ma tauma Yesu ꞌana tohepwailao, weyahina ꞌina paihowa ꞌaꞌitediya Yudiya tupwanao mabwaiyadi ꞌoidiya, ma wete Yelusalema ꞌoina, ta ꞌana ꞌebelolagu ꞌaiwe ꞌoina situtu hepaꞌineya ma ꞌiꞌamasa, ");
INSERT INTO bdd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ma sabwelo hetoina ꞌoina Yehoba ꞌiꞌabihetoholo hileya ma ꞌigihelatuheya, ");
INSERT INTO bdd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ma geya tomota mabwaiyadi ꞌoidiya, beno tuwa tauma Yehoba ꞌihesinuwemaiya ꞌana tohepwailao tauma matamega ꞌaꞌiteya, ꞌaꞌaiꞌai ta ꞌanumanuma Yesuina baꞌidamai. ");
INSERT INTO bdd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma ꞌiloinemaiya ma tomota ꞌoidiya ꞌaloguguya ꞌabehega Yehoba Yesu ꞌihesinuweya ta ꞌabehega tuta ꞌana ꞌebelolagu ꞌoina tauna loina ꞌida paihowa tomota taudi siꞌamasa weyahidi ma wete tauda mayawasida weyahida.” ");
INSERT INTO bdd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","“Palopitao wete mwalona sihepwaila nugeteya ꞌabehega ꞌeguma taiyawedi Yesu ꞌoina sihemisa, nata ꞌidi puiyao Yehoba ꞌinuwasamudi Yesu tauna saninega.” ");
INSERT INTO bdd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ꞌabwa ꞌigwaegwae ma Yaluyaluwa Tabuna ꞌisuluma taudi sihenono ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","ta taudi hali ꞌenana ma hali ꞌenana ꞌoidiyega sigwaegwae ta Yehoba sihehepwatuwe. Ma hesi meYudiya taudi Yesu ꞌana tohemisaedi Pita baꞌidanao Yopa ꞌoinega sitauyama, sinuwa pwanopwanowa weyahina siꞌiteya Yehoba tauna Yaluyaluwa Tabuna ꞌiꞌebwaeya tomiya ganamuli, taudi geya meYudiya ꞌoidiya. Ma Pita ꞌihegwaediya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ciyagwao, waꞌita Yaluyaluwa Tabuna siꞌewa pwaiya, gidemusa mwalo tauda. Coinega geya sowasowahina ꞌidi babitaiso weꞌahega taꞌetobode ꞌawa?” ");
INSERT INTO bdd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ta Pitaina ꞌiloina ma Toꞌabihetena Yesu saninega sibabitaiso. Muliyega tomotaedi Pita siꞌahwanoiyeya ma sabwelo hisa wete baꞌidadiu simiyamiya, ta ꞌitagwala. ");
INSERT INTO bdd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ma Yesu ꞌana tohepwailao ma wete tohekalesiyao, taudi Yudiya ꞌana tomiyanao, wasa sihesagoha pwaiya ꞌabehega tupwadi tomiya ganamuli Yehoba ꞌina gwae sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Coinega tutaina Pita ꞌihane hila Yelusalema ꞌoina, tohekalesiyao taudi Mosese ꞌina loinao ꞌana tomuliyao Pitaina silomugiyeya, ");
INSERT INTO bdd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","sigwae, “Togidega ma ꞌowa ꞌuluhuwa taudi geya meYudiya ꞌidi hadai ma baꞌidamwao waꞌai?” ");
INSERT INTO bdd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ta Pita ꞌihegaina ma paihowaina mabwaiyana ꞌihewasa bwaibwainiya, ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mwalo taugu Yopa ꞌoina yamiyamiya ta yaꞌahwaꞌahwanoi Yehoba ꞌoina, ma ꞌenomataꞌiteꞌitega ꞌaigeda ginaula yaꞌiteya gide ꞌaleꞌo madouna ma papalina matadiyao powa ꞌoidiyega galewega sihedawedawe suluheyama ꞌoiguwa. ");
INSERT INTO bdd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ginaulaina ꞌalona yaꞌeꞌebubuya, ma yaꞌiteya hebaiyao, ma hebai bosasa ma mwata ma wete bwasumowao ꞌaleꞌoina ꞌalona simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma ꞌaigeda gwae yahesagoheya ꞌihegwaegauwa, ꞌigwae, ꞌPita, ꞌutoholo ma ꞌa hebai ꞌuhunudi ma ꞌuꞌai.’ ");
INSERT INTO bdd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ma taugu yagwaeya, ꞌBada tuwa! Weyahina geya ꞌaigeda wete ginaula heheꞌasisina yada ꞌaidiya.’ ");
INSERT INTO bdd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ta ꞌenanaina galewega ꞌigwae hila, ꞌigwaeya, ꞌYehoba hebai beno ꞌiꞌabihe bwebweꞌanediya, ꞌoinega gesowana ꞌuꞌahwaꞌahwa galagalae.’ ");
INSERT INTO bdd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Ginaulaina matoi ꞌoiguwa ꞌilatuma, ma ꞌenanaina wete matoi ꞌihegwaegauwa, ta muliyega mabwaiyana ꞌihaneya ta ꞌiꞌwaiha galewa. ");
INSERT INTO bdd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma nage tutaina ꞌoina loheloheya ꞌetoi silatuma hadaina ꞌoina yamiyamiya, Sisaliya ꞌoinega sitauyama weyahigu. ");
INSERT INTO bdd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Ma Yaluyaluwa Tabuna ꞌihegwaegauwa ꞌigwae, ꞌCutoholo ma sahena ꞌuhehenuwanaluwa, ma tuwa hesi taudi baꞌidamwao watauya.’ Ma ꞌiyadao site sikisi bewa siꞌwayabugauwa, ma ꞌatauya Konilio ꞌina hada ꞌaluhuwa. ");
INSERT INTO bdd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Ma loheyaina ꞌoima ꞌiheꞌoteꞌotetela, ꞌigwaeya, ꞌMwalo ꞌaigeda anelose yaꞌiteya ꞌigu hada ꞌalona ꞌitotoholo ma ꞌigwaeya, “Konilio, ꞌino ꞌaliꞌeyao ꞌuhetunedi Yopa ꞌoina ma Saimoni tauna sihesaniyeya Pita, sitoeyama, ");
INSERT INTO bdd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ma tauna wasaina ꞌabwa ꞌihegwaegomi ma ꞌoinega ꞌomi maꞌimi susuwao helau waloba.” ꞌ ");
INSERT INTO bdd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Coinega yahegaina ma yahehegwaegwae, ta Yaluyaluwa Tabuna ꞌoidiya ꞌisuluwa gidemusa mwalo tauda ꞌoida ꞌisuluma. ");
INSERT INTO bdd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","“Ma Bada mwalo ꞌina gwae yanuwatuhu yahiya ꞌigwaeya, ꞌYoni tomota weꞌahega ꞌiꞌabihe babitaisowediya ma ꞌomi ꞌabwa Yaluyaluwa Tabuna ꞌoinega wababitaiso.’ ");
INSERT INTO bdd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Yehoba ꞌina ꞌebwayaina ꞌoidiya gidemusa tauda ꞌoida tutaina tagimi hemisa Bada Yesu Keliso ꞌoina. Ma taugu geya sosowagu Yehoba ꞌina paihowa bewa yaꞌetobode.” ");
INSERT INTO bdd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita ꞌina gwae bewa sihesagoheya ma geya ꞌidi ꞌebe gwaemo, ta Yehoba sihepwatuwe, sigwaeya, “Moisa tuwa, Yehoba tauna ꞌitagwatagwala taudi tomiya ganamuli ꞌoidiya ꞌabehega sinuwabui, ta taudi wete yawasi hataya siloba.” ");
INSERT INTO bdd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mwalo tohekalesiyao ꞌadi ꞌalehao Sitibeni siloheꞌamasiya, ma wete sitoho ma tohekalesiyao mabwaiyadi sida mutudi, ꞌoinega tohekalesiyaowedi sidena hali ꞌasa ma hali ꞌasa ꞌoidiya, ma tupwadi silatuwa Pinisiya ma Saipilosi ma Anitioki ꞌoidiya, ma wasa bwebweꞌana sihehepwaila meYudiya ꞌoidiya, ma hesi geya sihepwaila taudi tomiya ganamuli ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma muliyega tupwadi tohekalesiyao taudi meSaipilosi ma meSailini silatuwa ꞌasa Anitioki ꞌoina ma Bada Yesu wasana siloguguyaeya taudi meYudiya ma taudi geya meYudiya wete ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ma Badaina ꞌiꞌabihe waiwaiyediya ma tomota tupwana baibaiwana ꞌidi gwae sihemisaeya ma sitehinowa Badaina ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tupwadi taudi tomiya ganamuli sihemisa Badaina ꞌoina, ꞌoinega wasadi ꞌiꞌelelewana, ta tohekalesiyao Yelusalema ꞌoina sihesagoheya, ꞌoinega Banaba sihewasaeya ma ꞌihaboꞌenedi. ");
INSERT INTO bdd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta tutaina Banaba ꞌitauyama Anitioki ꞌoina, Yehoba ꞌina helau tohekalesiyaowedi ꞌoidiya ꞌiꞌiteya ma ꞌiyaliyaya madouna, ta ꞌilohatotodiya ma gesowana sihehenuwanaluwa, ma hesi sida toholo paꞌala maꞌidi hemisa ꞌidi Bada ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Weyahina Banaba loheya bwebweꞌana, ma Yaluyaluwa Tabuna ꞌilohemaheya, ma maꞌina hemisa madouna. Ta ꞌina loguguya ꞌoinega tomota tupwana baibaiwana sihemisaeya, ma tohekalesiyao ꞌidi boda ꞌihehemadou. ");
INSERT INTO bdd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Muliyetega Banaba ꞌitauya Tasisi ma Saulo ꞌiꞌebeseya, ");
INSERT INTO bdd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ma ꞌilobeya, ta baꞌidana sihila Anitioki ꞌoina. Eeta bolime ꞌaigeda ꞌalona siloguguya tohekalesiyaedi ꞌidi ꞌetoꞌauta ꞌoidiya, ma tomota mabwaiyadi siheheꞌitadi. Casaina Anitioki ꞌoina Yesu ꞌana tomuliyao tutaina ꞌoina sihesani nugetediya Kelisitiyanao. ");
INSERT INTO bdd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tuta nage ꞌoina tupwadi palopitao Yelusalema ꞌoinega sisuluma Anitioki ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ma ꞌaigeda ꞌoidiyega, sanina Agabu, ꞌidi ꞌetoꞌauta ꞌoina ꞌitoholo, ma Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌihepwaila nugeta ꞌabehega ꞌabwa gomale madouna ꞌihapwesa gogo mabwaiyadi ꞌoidiya, eeta muliyetega Sisa Kalodiu ꞌina tuta hetoloina ꞌoina gomale madouna ꞌihapwesa. ");
INSERT INTO bdd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ta tutaina Yesu ꞌana tomuliyao Agabu ꞌina hepwailaina sihesagoheya taudimo siloina ma ꞌabehega ꞌaigeda ꞌaigeda sitoho ma siꞌehele ma lema mane sihewasae ꞌiyadiyaowedi tupwa Yudiya ꞌoina simiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Coinega siꞌehele nugeta ta mane silobeya, ma tutaina gomale ꞌilatuwa ꞌoina siꞌebwaediya Banaba ma Saulo taudi sitauyeya Yelusalema ꞌoina, tohekelasiyao ꞌidi babadao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tuta nage ꞌoina kini Helodi ꞌina loina paꞌalina ꞌilatuwa, ma ꞌina toloꞌalehao tupwadi tohekalesiya siꞌabiyahidiya sabi ꞌabihegaladi. ");
INSERT INTO bdd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Coinega Yemesa, tauna Yoni tasina, Helodi ꞌina loinega sihunuya ꞌelepega, ma ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma meYudiya siyaliyaya Yemesa ꞌina ꞌamasa weyahina. Ta Helodi ꞌiloina hila ma Pita siꞌabiyahiya. Ta wiki beno meYudiya ꞌidi heꞌasisi ꞌana tuta ma beledi daisina, geya ꞌana ꞌebe gihesesehamo siꞌaiya. ");
INSERT INTO bdd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pitaina siꞌabiyahiya ma deliya silaguya, ma Helodi ꞌina toloꞌalehao sikisitini ꞌiloinaedi silomatayahi bwaibwaini, ma Helodi ꞌinuwanuwatuhu ꞌabehega Hataona Guyaina mulina Pitaina ꞌida lagulatuhe meYudiya ꞌoidiya ta ꞌina yatala sida paihowa. ");
INSERT INTO bdd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Coinega deliya siꞌitayahiya ta tohekalesiyao siꞌahwaꞌahwanoi waiwai Yehoba ꞌoina Pita weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta Pita tupwana sabwelo ꞌoina deliya ꞌimiyamiya, ma hali sabwelo ꞌoina Helodi Pita ꞌida lagulatuhe yatala weyahina, ma hinuwana Pita toloꞌalehao ꞌeluwa gamwagamwanidiya ꞌiꞌenoꞌeno, ma ꞌana ꞌebepai seni ꞌeluwa ꞌoidiyega sipaiya, ma wete deli mataꞌahwana toloꞌalehao siꞌitaꞌitayahi. ");
INSERT INTO bdd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta Yehoba ꞌina anelose ꞌaigeda mwayamwayau ꞌilatuma ma deliina ꞌalona ꞌiꞌasilala, ma aneloseina Pita lesulesuna ꞌisapiya ta ꞌilohanohanoya ta ꞌigwaeya, “Cutoholo mwayamwayau.” Ta ꞌana ꞌebepai nimanega sibeꞌuwa. ");
INSERT INTO bdd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma aneloseina ꞌihegwaeya, ꞌigwae, “Ca ꞌaleꞌo ꞌuꞌote ma ꞌa butu ꞌuꞌotedi.” Ta gwaeina Pitaina ꞌihematamataneya. Ta aneloseina wete ꞌigwaeya, “Ca hewanuwega ꞌuꞌabobo ma ꞌumuliyegau.” ");
INSERT INTO bdd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ta ꞌilatuwa ma Pita ꞌimuliyeya ma ꞌinuwatuhuya ꞌabehega ꞌinihinihi, ta geya ꞌisanapu ꞌabehega aneloseina ꞌina paihowa moisa. ");
INSERT INTO bdd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Coinega toꞌitayahina ꞌaigeda siꞌebesineya, ma heluwena wete siꞌebesineya. Cahwaꞌeda madouna pwawatiyega sipaihoweya ꞌoina sitauyama, ma ꞌahwaina ꞌiboimo ꞌiꞌesoꞌeya, ma sihapwesa ꞌasai ma ꞌeda ꞌoinega sitauya ta mwayamwayau aneloseina Pita ꞌiꞌebesineya. ");
INSERT INTO bdd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ma Pita ꞌinuwasabwalena ta ꞌigwae, “Yasanapu pwaiya ꞌabehega ꞌida Bada ꞌina anelose ꞌihewasaeyama ma ꞌilemegauwa Helodi ꞌina loina ꞌoinega, ta gesowana meYudiya ꞌidi nuwatuhuwao sida paihowadi.” ");
INSERT INTO bdd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pitaina nuwana ꞌisabwalena ma ꞌitauya Meli ꞌina hada, tauna Yoni sinana, ta Yoni sanina heluwena Maki, ma hadaina ꞌalona tomota baibaiwadi boꞌi siꞌautama ta siꞌahwaꞌahwanoi Yehoba ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eeta Pita hada ꞌana ꞌahwaꞌeda ꞌoina ꞌiꞌetunatunaꞌeꞌeya ma topaihowa mewahinena sanina Loda ꞌitauyama, ");
INSERT INTO bdd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ma Pita ꞌina gwae ꞌisanapuya ma ꞌiyaliyaya madouna, ta geya ꞌahwaꞌeda ꞌida soꞌeya, ma ꞌihila mwayamwayau hada ꞌalona ta ꞌigwaeya, “Pita ꞌahwaꞌeda ꞌitotoholo.” ");
INSERT INTO bdd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma sigwae, “Yauyauleiu!” Ta wahine ꞌahwana ꞌipaꞌala ꞌabehega tauna Pitaina. Coinega sigwae, “Nuwana Pita ꞌaluꞌaluwana.” ");
INSERT INTO bdd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma Pita ꞌabwama ꞌatamana, ma ꞌiꞌetunatunaꞌeꞌeya. Eeta ꞌahwaꞌeda sisoꞌeya, ma siꞌiteya tauna, ma nuwadi ꞌihenainaida moisa. ");
INSERT INTO bdd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma Pita nimanega ꞌiꞌetobodediya ma sihenono, ta ꞌiheꞌoteꞌotetela ꞌidi Bada deliyega ꞌitoeyama. Ta ꞌigwae, “Wasa bewa wahepwaila Yemesa maꞌiyanao wete ꞌoidiya.” Ma ꞌiꞌebesinediya ta ꞌitauya hali tupwa. ");
INSERT INTO bdd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Gona ꞌiꞌadaleya ma toloꞌalehao nuwadi ꞌihenainaida ma siꞌateyohowa madouna Pita weyahina, togidega ꞌilatu ꞌesa. ");
INSERT INTO bdd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma Helodi ꞌiloinaediya ma Pitaina siꞌebese. Siꞌebeꞌebeseya ta geya siloba. Coinega tolomatayahinao ꞌidi yatala ꞌipaihoweya, ma ꞌadi loheꞌamasa ꞌiloinaediya. Eeta siloheꞌamasidiya ma Helodiina Yudiya ꞌoinega ꞌisuluwa Sisaliya, ma nobwa ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helodiina meTaiya ma meSaidoni mwalo ꞌigamwasowalediya, ta sitoho ma Helodi ꞌina toꞌitayahinaina sanina Bilasito siꞌabihe yaliyaya. Eeta siꞌabihe yaliyayeya, ma muliyetega mabodaidi sitauyama Helodi ꞌoina, ta nuwanuwadi ma baꞌidanao sida heꞌiyaꞌiyagu hila, weyahina taudi ꞌadi ꞌeꞌahai kiniina ꞌina tupwega silobaloba. ");
INSERT INTO bdd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ta Helodi ꞌaigeda sabwelo ꞌiupaeya ma baꞌidanao sida gwaegwae. Ma sabweloina ꞌoina ꞌana ꞌaleꞌo wasawasa ꞌiꞌoteya ta ꞌina wagahata wasawasa ꞌoina ꞌimiyatoiya ma bodaedi ꞌoidiya ꞌigwaeya. ");
INSERT INTO bdd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Cigwaegwae ꞌigumwala, ma bodaedi sibwaubwau, sigwae, “Nage ꞌaigeda Yehoba ꞌenana, ma geya tomota ꞌenana.” ");
INSERT INTO bdd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tuta nage ꞌoina Yehoba ꞌina anelose Helodi ꞌihunuya, weyahina Yehoba ꞌana hepwatu ꞌilagu balaheya tauna ꞌiboi ꞌoina, ta yapwayapwa ꞌalona siꞌaiya, ma ꞌiꞌamasa. ");
INSERT INTO bdd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ta ꞌoinega Yehoba ꞌina gwae ꞌihewaiwai tomota baibaiwadi ma tupwa mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ta Banaba ma Saulo ꞌidi paihowa Yelusalema ꞌoina silohegumwaliya, ma sisulu hilama Anitioki ꞌoina, ta Yoni sitoeyama baꞌidadiu. Yoniina sanina heluwena Maki. ");
INSERT INTO bdd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Casa Anitioki ꞌoina, tohekalesiyao ꞌidi palopitao ma toheꞌitao bewa: Banaba ma Saimoni (tauna sibwauweya Dubaduba) ma Lusiyasi (tauna gwama Sailini) ma Manaeni (tauna kini Helodi ꞌana yaso ꞌaigeda) ta wete Saulo. ");
INSERT INTO bdd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Taudi sitapwatapwalolo maꞌidi hudi Yehoba ꞌoina, ta Yaluyaluwa Tabuna ꞌihegwaediya, ꞌigwae, “Nuwanuwagu Banaba ma Saulo ꞌigu paihowa ꞌaigeda weyahina, ꞌoinega ꞌomi watagwaledi paihowaina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ta Yehoba ꞌoina siꞌahwaꞌahwanoi hila magomaledi, ma siꞌabidebediya, ta Banaba ma Saulo sihewasediya ꞌidi paihowaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaluyaluwa Tabuna ꞌihetune pwaidiya ta sidobiya Salusiya, ma wagai sigeluwa ma siꞌuꞌe, sihabala bwanabwana Saipilosi ꞌoina, ");
INSERT INTO bdd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ma nobwa ꞌasa sanina Salami ꞌoina silaga, ta meYudiya ꞌidi hada tapwalolo ꞌoina Yehoba ꞌina gwae sihepwaileya. Caigeda ꞌidi hewali baꞌidadiu sisakosakowasi, sanina Yoni. ");
INSERT INTO bdd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eeta bwanabwanaina mabwaiyana ꞌoidiya sisakowasi hegumwaliya, ma ꞌasa Pepose ꞌoina silatuwa. Ma nobwa ꞌaigeda toꞌoba, sanina Bayesu, gwama Yudiya, tauna palopita ꞌaboꞌabo ꞌaigeda. ");
INSERT INTO bdd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ma Bayesuina ꞌiyana ꞌasa ꞌana tohanugeta, sanina Sagiu Paulosi, loheya sanasanapuina. Eeta Sagiu Paulosiina Banaba ma Saulo ꞌibwauwedima, ta nuwanuwana ma Yehoba ꞌina gwae ꞌihesagohe, ");
INSERT INTO bdd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ma hesi toꞌoba ꞌiꞌausidiya, weyahina geya nuwana ma toloinaina ꞌihemisa Yesu ꞌoina. Toꞌobaina sanina ꞌana bui Elaimasi, beno tobalahu. ");
INSERT INTO bdd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ma hesi Saulo, tauna sanina heluwena sibwauweya Paulo, Yaluyaluwa Tabuna ꞌilohemaheya ma toꞌobaina ꞌiꞌeꞌebubu, ");
INSERT INTO bdd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ma ꞌigwaeya, “Cowa Seitani ꞌina boda ma toꞌabo madouna, ꞌoinega paihowa dumwaluna ꞌuheꞌaleheya, ma Bada ꞌina ꞌeda dumwaluna tuta mabwaiyana ꞌutohotoho ma ꞌabehega ꞌuꞌabihepwayoꞌe. ");
INSERT INTO bdd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Coinega bewa tuwa Bada ꞌina waiwai ꞌoinega matau ꞌihoga tuta toꞌutoꞌupanamo weyahina, ma sahena hala ꞌina ꞌasilala ꞌuꞌitaꞌita.” Tuta nage ꞌoina hogahoga gide ꞌoinega toꞌobaina matana ꞌiguguyouwa, ma ꞌibesabesa taiya ꞌileme ma ꞌihanugete. ");
INSERT INTO bdd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta toloinaina Sagiu Paulosi ꞌiꞌiteya Paulo ꞌina paihowaina, ma Bada tetelina weyahina nuwana ꞌihenainaida, ꞌoinega ꞌihemiseya. ");
INSERT INTO bdd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ta Paulo maꞌina bodao Pepose ꞌoinega sigeluwa ma siꞌuꞌe hila, ma Peliga ꞌoina siluhuwa, tupwa Pamipiliya ꞌalona. Ta Yoni ꞌiꞌebesinediya ma ꞌihila Yelusalema. ");
INSERT INTO bdd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ma hesi Paulo maꞌina bodao Peliga siꞌebesineya ma hali Anitioki ꞌoina silatuwa, beno tupwa Pisidiya ꞌalona. Eema sabwelo Sabati ꞌoina siluhuwa meYudiya ꞌidi hada tapwalolo ꞌoina, simiyatoiya. ");
INSERT INTO bdd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ma tohanugetao Mosese ꞌina loina ꞌana hasila, ma palopitao ꞌidi gwae ꞌana hasila sihasilidiya, ta tohanugetaowedi ꞌaigeda loheya sihewasaeya Paulo ma Banaba ꞌoidiya ma ꞌabehega ꞌihemataluwedi, ꞌigwaeya, “Ceguma guguya bo heꞌita ꞌoimiya beno wahepwaila tomota ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Coinega Paulo ꞌitoholowa ma nimana ꞌiꞌabihaneheya, ta ꞌigwae, “Tasigwao, meIsileli, ma ꞌomi hali tupwega Yehoba ꞌana toheꞌasisiyao, ꞌigu gwae bewa wahesagohe. ");
INSERT INTO bdd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yehoba mwalona meIsileli tauda tubudao ꞌihesinuwediya, ta ꞌidi boda ꞌiꞌabihe madouya ꞌidi miya taumana Itipita ꞌalona, ta ꞌina waiwai madouna ꞌoinega ꞌihanugetediya ta Itipita siꞌebesineya. ");
INSERT INTO bdd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ma bolime poti ꞌoidiya ꞌidi weꞌao ꞌiheꞌalamaꞌiꞌitanediya tupwa yoho ꞌawawa pwatula. ");
INSERT INTO bdd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","“Ta muliyetega kini site sebeni maꞌidi bodao ꞌimutudiya tupwa Kenani ꞌalona, ma tupwaina meIsileli ꞌiꞌebwaediya ꞌidi baleꞌu, ma simiyamiya gide bolime powa handeledi ma pipiti ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ma muliyetega ꞌidi toloinao ꞌiꞌebwaediya ma siloinediya ꞌana siga palopita Samuwela ꞌilatuwa. ");
INSERT INTO bdd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Samuwela ꞌilatuwa ta siꞌahwaꞌahwanoi ma Yehoba ꞌidi kini ꞌiꞌebwaedi, ꞌoinega Saulo ꞌiꞌebwaediya, tauna Kisi natuna, ta ꞌina susu Beniyamina ꞌoinega, ma bolime poti ꞌoidiya ꞌiloiloinaedi. ");
INSERT INTO bdd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Muliyetega Yehoba Saulo ꞌilososomaneya ta ꞌidi kini hauhauna Debida ꞌilaguya. Tauna Debida weyahina Yehoba ꞌigwaeya, ꞌDesi natuna Debida yalobeya, ma yahemisaeya, weyahina ꞌigu nuwatuhuwao baibaiwadi ꞌipaipaihowadi.’ ");
INSERT INTO bdd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ta Debida ꞌina susuwega, Yehoba tauda meIsileli ꞌida Toꞌabihetena Yesu ꞌiꞌabilatuheya, gidemusa mwalona ꞌihepwaila nugeteya. ");
INSERT INTO bdd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Ta mwalo tutaina Yesu geya ꞌilatulatuma, Yoni ꞌiloguguya meIsileli ꞌoidiya ma ꞌidi puiyao ꞌoidiyega sinuwabui ma ꞌiꞌabihe babitaisowedi, ");
INSERT INTO bdd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ma Yoni ꞌina paihowa ꞌana ꞌebe lolagu ꞌoina ꞌigwaeya, ꞌComi wanuwatuhuya ꞌabehega taugu taiya? Taugu geya Toꞌabihetenaina. Ta tauna muliguwega ꞌinaonaoma Tabwana hedada. Ta taugu geya ꞌilobwainegau ma ꞌahena ꞌana butu yalihasidi.’ ");
INSERT INTO bdd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tasigwao, ꞌomi Ebalahamo ꞌina susuwao, ma wete ꞌomi hali tupwega Yehoba ꞌana toheꞌasisiyao wahesagohe ꞌabehega ꞌabihetena tetelina bewa ꞌoida ꞌilatu pwaima. ");
INSERT INTO bdd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ta Yelusalema ꞌana tomiyao, ma ꞌidi babadao, Toꞌabihetenaina geya sisanapu, ma wete palopitao ꞌidi hepwailao Sabati ꞌaigeda ꞌaigeda sihasihasili totapwalolo ꞌoidiya, ma hesiyage geya sisanasanapudi, ta hesi Toꞌabihetenaina sitebaeya, ꞌoinega palopitao ꞌidi hepwaila nugetao mwalona hene ꞌadi moisa tuta bewa siꞌabilatuheya. ");
INSERT INTO bdd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ta geya ꞌeta ꞌina puimo sida lobeya, ma ꞌoinega siloheꞌamasi, ma tuwa hesi Pailato siꞌahwanoiyeya ma ꞌiloheꞌamasi. ");
INSERT INTO bdd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Ta gwaeyedi Buki Heꞌasisi ꞌoina sihepwaila nugeteya Toꞌabihetena weyahina, mabwaiyana nage meYudiya sipaihowa pwaidiya, ta ꞌina ꞌamasa mulina ꞌana kelose ꞌoinega silagu suluheya ma sigaliheya. ");
INSERT INTO bdd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma Yehoba ꞌamasa ꞌoinega ꞌiꞌabihe toholoya, ");
INSERT INTO bdd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ta sabwelo tupwana baibaiwana ꞌilatulatu ꞌana toꞌwayabuwao ꞌoidiya, taudi mwalo mahetenao Galiliyega ma Yelusalema ꞌoina sinaoma. Taudi bewa tuwa Toꞌabihetenaina weyahina sihehepwaila tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ma tauma wete tetela bwebweꞌana bewa ꞌaꞌebwaegomi, mwalo Yehoba ꞌigwae hemisa tubudao ꞌoidiya, ");
INSERT INTO bdd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ta sauga bewa ꞌiꞌabihe latuya yaso hauhauda ꞌoida, tutaina Yesu ꞌamasega ꞌiꞌabihe toholoya. Bewa weyahina wali Same heluwena ꞌoina Yehoba ꞌina gwae sihepwaila nugeteya, ꞌigwae, ꞌCowa natugu nige yaꞌahwa natunegowa.’ ");
INSERT INTO bdd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Ma wete ꞌiꞌabihe toholo hileya ma sahena ꞌiꞌamaꞌamasa hila, nuwana ꞌimwahumwahulu, ma bewa weyahina ꞌihepwaila nugeteya, ꞌigwae, ꞌGinaulaedi bwebweꞌadi yagwae hemisediya Debida ꞌoina, ꞌabwa yaꞌebwaego.’ ");
INSERT INTO bdd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ma wete ꞌaigeda wali Same ꞌoina boꞌi ꞌihepwaila nugeta, ꞌigwaeya, ꞌSahena watagwatagwala ma tauna ꞌuhesinuwaeya ꞌimwahumwahulu.’ ");
INSERT INTO bdd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Gwae bewa geya Debida tauna weyahina. Debidaina ꞌina tuta Yehoba ꞌina nuwatuhu ꞌipaihowediya, ma ꞌiꞌamasa ta sigaliheya tubunao mahetediu ma ꞌimwahumwahulu, ");
INSERT INTO bdd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ma hesi loheyaina ꞌamasega Yehoba ꞌiꞌabihe toholoya geya ꞌimwahulu. ");
INSERT INTO bdd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Coinega tasigwao, wasanapu bwaibwaini ꞌabehega loheyaina ꞌoinega ꞌimi puiyao ꞌadi nuwasam waloba. Ma ꞌeguma taiya tauna ꞌoina ꞌihemisa, ꞌina puiyao ꞌoidiyega ꞌilihasi. Ta hesi Mosese ꞌina loina geya sowasowahina ꞌilihasigomi. ");
INSERT INTO bdd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“Coinega waꞌita yahigomi ma gwaeina palopitao mwalo weyahina sigwaegwae hemisa, sahena ꞌoimiya ꞌilatulatu. Gwaeina ꞌigwaeya, ");
INSERT INTO bdd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ꞌComi tolotuyenao, ꞌigu paihowa bewa waꞌita ma weyahina nuwami ꞌihenainaida, ma muliyetega wahesilae, weyahina ꞌimi tuta ꞌoina ꞌigu paihowaina nata sihepwaila ꞌoimiya, ma hesi geya wahemisa.’” ");
INSERT INTO bdd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ta Paulo ma Banaba sihapwesa, ta bodaedi siꞌahwanoiyediya ma hali Sabati wete heꞌita bewa ꞌoidiya sihepwaila hila. ");
INSERT INTO bdd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ta boda hada tapwalolowega sihapwesama, ma tupwadi meYudiya, ma tupwadi Yehoba ꞌana tohemisao hali tupwa ma hali tupwa ꞌoidiyega, Paulo ma Banaba sihemuli tabubudiya, ꞌoinega Paulo ma Banaba ꞌoidiya siloguguya ta ꞌabehega Yehoba ꞌina helau siꞌabiyahi. ");
INSERT INTO bdd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ma hali Sabati ꞌoina, ꞌasaina ꞌana tomiyao baibaiwadi siꞌetoꞌautama Yehoba ꞌina gwae sabi hesagoheina. ");
INSERT INTO bdd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ma hesi meYudiya, boda madouna siꞌiteya, ꞌoinega siheꞌipiꞌipiyeya, ma Paulo ꞌina guguya siꞌahwa ꞌaboꞌaboweya, ma siꞌahwa galagalaeya. ");
INSERT INTO bdd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ta Paulo ma Banaba maꞌidi ꞌatepatu sigwae latuwa meYudiyaedi ꞌoidiya sigwaeya, “Cilobwaineya ma Yehoba ꞌina gwae ꞌahepwaila nugete ꞌoimiya, ma bewa tuwa walogwahateya, nuwana ꞌomi waboi waloinaegomi ꞌabehega geya sowasowahimi ma yawasimi hataya waloba, ꞌoinega ꞌalogwahategomiya, ma tomiya ganamuli ꞌoidiya ꞌaloguguya, taudi geya meYudiya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“Weyahina Bada ꞌiloinemaiya, ꞌigwae, ꞌCimi paihowa yaꞌebwaya pwaigomiya ma ꞌabehega ꞌomi taudi tomiya ganamuli ꞌidi mayale, ma tupwa mabwaiyadi ꞌoidiya ꞌadi ꞌabihetena watauye.’” ");
INSERT INTO bdd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Eeta taudi tomiya ganamuli Paulo ma Banaba ꞌidi gwae bewa sihesagoheya, ma siyaliyaya madouna, ta Yehoba tetelina siꞌahwa bwebweꞌaneya, ta taudi taiyewedi Yehoba ꞌihesinuwanediya ma yawasi miyamiya hatayana siloba, taudi gwaeina sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma Yehoba tetelina silelewaneya tupwaina mabwaiyana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ta hesi meYudiya Paulo ma Banaba siloꞌalehedi, ma silolomugiyedi wahiwahine ꞌalawatao taudi totapwalolo ꞌoidiya, ma wete ꞌasa ꞌana babadao ꞌoidiya, ta taudi wete siloloꞌaleha Paulo ma Banaba ꞌoidiya, ta sipaꞌidiya, ma tupwaina siꞌebesineya. ");
INSERT INTO bdd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ma ꞌiꞌiuna ma ꞌasaina siꞌebesine, ꞌahedi nenegwalina silohutuhutu yahuleya ꞌidi tupwa, beno ꞌebeꞌita toni ꞌasaedi ꞌoidiya, ta muliyetega sitauya Ikoniyami. ");
INSERT INTO bdd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma hesi Yehoba ꞌana tohemisao siyaliyaya madouna, ta Yaluyaluwa Tabuna ꞌina waiwai ꞌilohemahediya. ");
INSERT INTO bdd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo ma Banaba silatuwa Ikoniyami ꞌoina, ta ꞌidi paihowa Anitioki ꞌoina wete gidemusa Ikoniyami ꞌoina sipaipaihowa ꞌesa, beno meYudiya ꞌidi hada tapwalolo ꞌoina siluhuwa, siheꞌita, ta ꞌidi heꞌita waiwai ꞌoinega boda sinabwana sihemisaediya, bodaedi tupwadi meYudiya ma tupwadi tomiya ganamuli ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ta tupwadi meYudiya heꞌitaina geya sihemisae, ta sisinaliya, ma siꞌahwa galagalaeya, ta silomugi taudi tomiya ganamuli ꞌoidiya ma taudi wete Yesu ꞌana tohemisao siloloꞌalehedi. ");
INSERT INTO bdd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ma ꞌiyamo tuta dudulena Paulo ma Banaba simiyamiya tupwaina ꞌoina ta maꞌidi ꞌatepatu silologuguya Bada weyahina. Ma Badaina ꞌina waiwaiyega paihowa ꞌebe henainaida ta hedehedede sipaihowediya, ma ꞌoidiyega Badaina ꞌina helau wasana ꞌana moisa tauna ꞌiheꞌitediya tomota ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ma meIkoniyamiyedi siwataha, ma tupwadi meYudiya siꞌahwa moisaediya, ma tupwadi Yesu ꞌana tohepwailao siꞌahwa moisaediya. ");
INSERT INTO bdd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Coinega taudi ganamuli, geya meYudiya, ta meYudiya wete maꞌidi babadao siloina hegogona ma Paulo ma Banaba sida gihemuyadi, ta daꞌuleyega sida loheꞌamasidi. ");
INSERT INTO bdd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma hesiyage wasana sihesagoheya, ma sidena sitauya Lakeoni gogonao ꞌoidiya, beno Lisitila ma Dabi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ma tetela bwebweꞌana sihepwaila latuheya, ta ꞌasanao deidiya wete. ");
INSERT INTO bdd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisitila ꞌoina ꞌaigeda tolopegoi silobeya, ꞌina tuta liꞌu ꞌoinega ma ꞌiheloheya madouna, ma ꞌimiyamiyamo tuwa, ta geya ꞌida toholowa ma ꞌida yawala, weyahina maꞌaena lopelopegoina ꞌitoleya. ");
INSERT INTO bdd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Eeta tolopegoiina ꞌimiyamiyatoiya, ma Paulo ꞌina loguguya ꞌihesagoheya, ꞌoinega Paulo tolopegoiina ꞌiꞌebubuya, ma ꞌisanapuya ꞌabehega maꞌina hemisa Yesu ꞌoina ta sowasowahina ꞌida ꞌabihe bwebweꞌane. ");
INSERT INTO bdd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Coinega Paulo ꞌenana madouna ꞌoinega ꞌibwau naowa ꞌoina ꞌigwaeya, “Cutoholo.” Ma tolopegoiina ꞌitoholo mwayamwayauwa ma ꞌiyawala. ");
INSERT INTO bdd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ma tomota mabwaiyadi Paulo ꞌina paihowa bewa siꞌiteya, ma Lakeoni ꞌenadiyega sibwaubwau, sigwaeya, “Yehobao sisuluma, ꞌadi ꞌita gide tomota.” ");
INSERT INTO bdd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ma bodaedi Banaba sibwauweya Yupita ma Paulo sibwauweya Mekiuli, weyahina tauna ꞌidi togwae. Saniyedi bewa ꞌidi yehobao sanidiyao, beno Yupita ma Mekiuli. ");
INSERT INTO bdd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ta ꞌidi yehoba Yupita ꞌina topwaoli ꞌasaina ꞌoina ꞌimiyamiya, ta ꞌina hada ꞌebe pwaoli ꞌasa ꞌatamanina. Ta topwaoliina ꞌabehega bulumakau ma ꞌaiwe didina sulasulana ꞌiꞌewedima ꞌasa ꞌana ꞌahwaꞌeda ꞌoina, ma nuwanuwana ꞌabehega boda baꞌidanao sida pwaoli Paulo ma Banaba ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ta siteluwaedi topwaoliina ꞌina nuwatuhu sisanapuya ma geya nuwadi. Coinega ꞌadi ꞌaleꞌo siboi sigisabuya ma sipili latuma, boda ꞌoidiya sigwaegwae, ");
INSERT INTO bdd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ciyamayao gesowana tauma ꞌoima wapwaopwaoli. Tauma tomota tuwa gidemusa ꞌomi, ma wasa bwebweꞌana ꞌaꞌeweyama ꞌoimiya, ta ꞌabehega ꞌomi ꞌebe hemisa besobeso wada logwahatedi ma wada ꞌitahila Yehoba mayawasina ꞌoina, tauna galewa ma baleꞌu ma niꞌu ta wete ginaula mabwaiyadi ꞌalodiya ꞌadi tohemasaleha. ");
INSERT INTO bdd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yehobaina mwalo tupwa mabwaiyana tomotainao ꞌitagwalediya ma taudimo ꞌidi nuwatuhu ta ꞌidi mumuga sida muliyedi, ");
INSERT INTO bdd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ma ꞌebe heꞌitao ꞌoidiya simiyamiya, ta ꞌabehega ꞌoidiyega Yehobaina sida sanasanapu. Ma ꞌebe heꞌitaowedi ꞌina helauwedi ꞌoidiya ta ꞌomi ꞌoimiya, beno ꞌwesu galewega ma wete siwaloha bwebweꞌana ma ꞌoidiyega ꞌeliꞌeli bwebweꞌana walobaloba, ta ꞌoinega waꞌaiꞌai ma weyahina wayaliyaliyaya.” ");
INSERT INTO bdd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ta Paulo ma Banaba tomotaedi siꞌetoboda ꞌasaediya, eema ꞌebelosaloha ꞌoina sihewaiwai, ma geya ꞌoidiya sipwaoli. ");
INSERT INTO bdd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ta meYudiya ꞌasa Anitioki ma Ikoniyami ꞌoidiyega sitauyama, ma siluhu bodaedi Paulo ma Banaba ꞌadi tohesagohao ꞌoidiya, ta silohetu hetunediya ma Paulo daꞌuleyega sihunuya. Cigumwala, ta ꞌasa ꞌalonega silisi latuheya, ta ꞌidi nuwatuhu ꞌiꞌamasa pwaiya. ");
INSERT INTO bdd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ta muliyetega Yesu ꞌana tomuliyao sitauyama, ma Paulo sitoholo sakowasiyeya, ma Pauloina ꞌitoholo ta ꞌiluhuhila ꞌasai. Ta gona ꞌiꞌadaleya, ma Banaba baꞌidana sitauya Dabi. ");
INSERT INTO bdd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dabi ꞌoina wasa bwebweꞌana siloguguyaeya ma tomota tupwana baibaiwana sihemisaeya, ta simuliyeya, ꞌoinega Paulo ma Banaba sihilahila Lisitila ma Ikoniyami ma Anitioki ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ta ꞌidi lohihilaina ꞌoina Yesu ꞌana tohemisao sigihe paꞌalidiya ꞌasa ꞌaigeda ꞌaigeda ꞌoidiya, ta siguguyediya ma gesowana ꞌidi hemisa ꞌida weꞌaweꞌa, ma sigwaeya, “Moisa ꞌabwa ꞌida muya baibaiwadi ꞌoidiyega taluhu Yehoba ꞌina ꞌebeloina ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ma wete ꞌasa ꞌaigeda ꞌaigeda Paulo ma Banaba tohekalesiyao ꞌidi tohanugetao siheꞌasediya, ta ꞌadi ꞌabilagata bewa gidemusa, sihudihudi ta ꞌidi Badaina sihemisaeya ꞌoina siꞌahwaꞌahwanoi, ma ꞌane ꞌida gihewaiwaiyedi ꞌidi paihowaina weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ta Pisidiya ꞌalonega sitauyama ma Pamipiliya ꞌoina silatuwa, ");
INSERT INTO bdd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ta ꞌasa Peliya ꞌoina siloguguya, ꞌoinega sidobiya Atalaya, ");
INSERT INTO bdd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ma wagega sigeluwa, ta sihila Anitioki tupwaina, mwalo ꞌoinega ꞌidi paihowaina siheꞌaleneya, ma ꞌoina wete mwalo Yehoba ꞌina helau silobeya paihowaina silosalohiya weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Eeta tutaina Anitioki ꞌoina siluhuwa, tohekalesiyao sibwau ꞌautedima, ma ginaula baibaiwadi Yehoba ꞌipaihowediya ꞌidi sakowasiina ꞌalona siheꞌoteꞌotetelediya, beno hemisa ꞌana ꞌahwaꞌeda ꞌisoꞌeya ꞌasa ganamuli taudi geya meYudiya weyahidi, ma siluhuluhu. ");
INSERT INTO bdd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Coinega Paulo ma Banaba Yesu ꞌana tohemisao tupwaina Anitioki ꞌoina baꞌidadiyao simiyamiya tuta dudulena. ");
INSERT INTO bdd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ma tupwadi loheloheya Yudiya ꞌoinega sisuluma, ta siheheꞌita tohekalesiyao meAnitioki ꞌoidiya, sigwaegwae, “Mosese mwalo ꞌiloinaemaiya ꞌwapima ꞌana ꞌupwa weyahina. Ma ꞌeguma ꞌomi ꞌwapi ꞌupwaina geya waꞌewa, nata geya ꞌabihetena walobaloba.” ");
INSERT INTO bdd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ma hesi Paulo ma Banaba geya siꞌahwa moisaedi, ꞌoinega mahetediyao siheꞌoheꞌoheya madouna. Ta tohekalesiyao Anitioki ꞌoina Paulo ma Banaba, ma tupwadi wete tomuliya ꞌoidiyega sihesinuwediya ma ꞌabehega sihane Yelusalema, ma nuwatuhu bewa weyahina sigwaegwae, nuwana siloina, Yesu ꞌana tohepwailao site tuwelo ma wete tohanugetao baꞌidadiyao. ");
INSERT INTO bdd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ta tohekalesiyao siloyauwedowediya ma sitauya. Sitautauya tupwa Pinisiya ma Sameliya sibui diꞌwaediya, ta sihepwaileya ꞌidi sakowasi mwalo weyahina, beno ꞌasa ganamuli, taudi geya meYudiya ꞌidi nuwabui Yehoba ꞌoina sihepwaileya, ta Yesu ꞌana tohemisao ꞌasa ꞌaigeda ꞌaigeda ꞌoidiya hepwailaina sihesagoheya, ma siyaliyaya madouna. ");
INSERT INTO bdd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Eeta silatuwa Yelusalema, ma tohekalesiyao ma Yesu ꞌana tohepwailao ma tohanugetao sitoediya ꞌidi hada, ta Paulo ma Banaba siheꞌoteꞌotetela ꞌoidiya toꞌaha ꞌidi paihowaedi Yehoba ꞌina waiwaiyega sipaihowediya. ");
INSERT INTO bdd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ma tupwadi Yesu ꞌana tohemisao Palisi bodaedi ꞌoidiyega sitoholowa, ma sigwaeya, “Ceguma ꞌasa ganamuli ꞌadi tomiyao sihemihemisa, ꞌilobwainediya ma ꞌwapi ꞌupwa siꞌewa, ma wete taloinedi ma Mosese ꞌina loinao simuliya nugetedi, ta ꞌoinega sowasowana sihekalesiya moisa.” ");
INSERT INTO bdd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Coinega Yesu ꞌana tohemisao site tuwelowedi ma tohanugetao ꞌetoꞌauta sipaihoweya, ma nuwatuhu bewa weyahina sigwaegwae. ");
INSERT INTO bdd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ta tupwana siheꞌoheꞌoheya dudulena. Cigumwala ma Pita ꞌitoholowa ma ꞌigwaeya, “Tasigwao, wasanasanapu ꞌabehega tuta mwalo Yehoba ꞌoidega taugu ꞌihesinuwegauwa, ma ꞌahwaguwega tomiya ganamuli tetela bwebweꞌana sihesagoheya, ma sihemisaeya. ");
INSERT INTO bdd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ta Yehoba toꞌaha ꞌateda simiyamiya ꞌisanasanapudi, ma taudi tomiya ganamuli ꞌoidiya ꞌitagwala pwaiya, ma Yaluyaluwa Tabuna ꞌiꞌebwaediya gidemusa tauda meYudiya ꞌiꞌebwaya ꞌesegita, ");
INSERT INTO bdd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ma geya ꞌaigeda wete wataha ꞌiꞌabiꞌabi latuhe, ta ꞌabehega taudi hagahagadi ma tauda hagahagada, ma hesi taudi sihemiseya gide tauda tahemiseya, ma ꞌoinega mabwaiyada ꞌateda ꞌiꞌabihe ꞌehaudi. ");
INSERT INTO bdd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Sahena Yesu ꞌana tohemisao hauhaudi tupwa ganamuliya ꞌoidiyega ꞌadi ꞌahaꞌahala mwauna waꞌebwaꞌebwaedi, tabu ma Yehoba waꞌabihe gamwasowali, weyahina ꞌahaꞌahalaina tubudao meYudiya geya sowasowahidi ma siꞌahali, ta tauda wete geya sowasowahida. ");
INSERT INTO bdd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma hesi ꞌida hemisa ꞌabehega ꞌida Bada Yesu ꞌina helauwega ꞌiꞌabihetegita, ma taudi wete Yesu ꞌihelauwediya, ta ꞌoinega wete ꞌiꞌabihetediya.” ");
INSERT INTO bdd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ta mabwaiyadi simiya henonowa, ma Banaba ma Paulo siheꞌoteꞌotetela hedehededeyao ma ꞌebe henainaidao Yehoba ꞌipaihowediya tupwa ganamuli ꞌoidiya siteluwaedi ꞌidi paihowega, beno taudi geya meYudiya ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cidi gwae ꞌigumwala ma muliyetega Yemesa ꞌitoholowa, ꞌigwaeya, “Tasigwao, ꞌigu gwae bewa wahesagohe. ");
INSERT INTO bdd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimoni ꞌoida boꞌi ꞌihepwaila ꞌabehega Yehoba ꞌihegaina pwaiya, ma taudi geya meYudiya ꞌoidiyega tupwana ꞌina tomotaiyao ꞌihesinuwediya. ");
INSERT INTO bdd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ginaula bewa weyahina mwalo palopitao Yehoba ꞌina gwae sihepwaila nugeteya, ꞌigwae, ");
INSERT INTO bdd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ꞌMuliyetega yahilama ma Debida ꞌina hada ꞌilotaligeha yaꞌabihila. Bewa tuwa ꞌimiya gala ma hesi yaꞌabihe bwebweꞌane hila. ");
INSERT INTO bdd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ta ꞌoinega hali bodao Bada siꞌebese, ma ꞌagu hesihesinuwao tomiya ganamuli ꞌoidiyega, taudi wete siꞌebesegau. ");
INSERT INTO bdd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Bewa Bada ꞌina gwae, tauna mwalo hene nuwatuhu bewa ꞌiꞌabilatuheya.’” ");
INSERT INTO bdd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ta Yemesa wete ꞌigwaeya, “Cigu loina bewa, taudi tomiya ganamuli Yehoba ꞌoina siꞌitaꞌitahila, ꞌabehega sahena ꞌadi mwau talagulagu, ");
INSERT INTO bdd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ma hesi ꞌidi leta talele ma ꞌetoboda ꞌehatamo talagudi beno, ꞌeꞌahaiina hali ꞌebe tuluha ꞌoidiya tomota siꞌebwaediya geyaꞌabwa siꞌaiꞌaidi, ta sahena ganawala, ma hebai ꞌaniꞌo didididi hesiyodi ma wete bweyaha geyaꞌabwa siꞌaiꞌaidi. ");
INSERT INTO bdd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Weyahina mwalona hene ꞌana siga nige Mosese ꞌina loina ꞌana tologuguyao ꞌasa ꞌaigeda ꞌaigeda ꞌoidiya simiyamiya, ta wete meYudiya ꞌidi hada tapwalolo ꞌoidiya ꞌetobodaedi bewa sihasihasilidi, ta tomota sihesagohedi Sabati ꞌaigeda ꞌaigeda ꞌoidiya.” ");
INSERT INTO bdd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Coinega Yesu ꞌana tohepwailao site tuwelo ma tohanugetao ma tohekalesiyao mabwaiyadi sinuwanuwatuhu mahemahetena, ta tupwadi ꞌoidiyega sihesinuwanediya ma sihewasediya, ta ꞌabehega Paulo ma Banaba mahetediyao sitauya Anitioki. Ma ꞌeluwa tohekalesiyao ꞌadi tohanugetao ꞌoidiyega sihesinuwediya, beno Yudasa, tauna sihesaniyeya Basaba, ma wete Sailasa, ");
INSERT INTO bdd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ta tohemisaowedi tupwa ganamuli ꞌoidiya ꞌidi leta siꞌeweya, ma ꞌana lele ꞌigwae, “Yauwedo tasimao ꞌomi tohekalesiyao tupwa ganamuliya Anitioki ma Siliya ma Silisiya ꞌoidiya wamiyamiya. Tauma Yesu ꞌana tohepwailao ma tohanugetao ꞌimi leta ꞌaleleyawa. ");
INSERT INTO bdd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mwalo tetelimi ꞌahesagoheya ꞌabehega tupwadi loheloheya tauma ꞌoimega sinaowa ma hali tetela ꞌoinega siꞌabihe ꞌwanigomiya, beno siboi ꞌidi nuwatuhuwega, ta geya tauma ꞌima hemataluwa. ");
INSERT INTO bdd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ma tauma bewa ꞌaꞌetoꞌauta pwaima, ta ꞌima nuwatuhu ꞌaigeda ꞌoinega tupwana ꞌima loheloheyao ꞌahesinuwediya, ta ꞌiyadao Banaba ma Paulo mahetediyao ꞌahewasaediya ꞌoimiya. ");
INSERT INTO bdd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Taudi Banaba ma Paulo siboimo sitagwalediya ma tuta baibaiwana sitautauya ꞌebe hesilae ꞌalodiya, ꞌida Bada Yesu Keliso ꞌina paihowa weyahina. ");
INSERT INTO bdd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Ta ꞌima loheloheyaedi ꞌahesinuwa pwaidiya, sanidiyao Yudasa ma Sailasa, ma ꞌomi loina siꞌebwaegomi ꞌimi leta ꞌoinega, ma wete taudi ꞌidi gwae ꞌoinega. ");
INSERT INTO bdd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Cami loinaina Yaluyaluwa Tabuna baꞌidamai ꞌanuwatuhuya ꞌabehega bewa loina bwebweꞌana ma ꞌetobodaedi ꞌehata bewa madoudimo wamuliyedi, ta geya ꞌeta toꞌaha wete weyahina wanuwanuwatuhu. ");
INSERT INTO bdd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Cetobodao beno, toꞌaha tomota sipwaopwaoli hali ꞌebe tuluha ꞌoidiya, sahena waꞌaiꞌai, wete hebai mabweyahidi, ma hebai dididimagaidi hesiyodi sahena waꞌaiꞌaidi, ta wete sahena waganaganawala. Ceguma ꞌetobodaedi bewa ꞌoidiyega waꞌitayahigomi, mumugami bwebweꞌana. Yauwedo.” ");
INSERT INTO bdd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Coinega site ꞌehataedi sitoholowa, sisuluwa Anitioki, ma tohekalesiyao nobwa sibwau ꞌautedima, ta ꞌidi letaina siꞌebwaediya. ");
INSERT INTO bdd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Eeta letaina sihasiliya, ta ꞌina hepwaila weyahina siyaliyaya madouna. ");
INSERT INTO bdd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ta Yudasa ma Sailasa taudi wete palopitao, ta ꞌidi guguya baibaiwana ꞌoidiyega tohekalesiyao siꞌabihe waiwaiyediya. ");
INSERT INTO bdd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ma siteluwaedi nobwa simiyamiya, ꞌana siga ꞌidi tuta ꞌilatuwa ma sitau, ta tohekalesiyaedi siloyauwedowediya, ma silokaiyoniyedi, ta sihila taudi ꞌadi tohewasaowedi ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO bdd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma hesi Paulo ma Banaba Anitioki ꞌoina simiya hila, ma Badaina ꞌina gwae siheheꞌita ta siguguguguya, ma tupwana baibaiwadi wete mahetediyao sipaipaihowa. ");
INSERT INTO bdd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ta sabwelo hisa sigumwala ma Paulo Banaba ꞌihegwaeya, ꞌigwae, “Ciyagu, tahila ma gogowedi mwalo ꞌida Bada tetelina ꞌaguguyaeya ꞌoidiya tahaboꞌenedi wete, ma tasidaowedi taꞌitadi, togidega ꞌidi miyamiya.” ");
INSERT INTO bdd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ta Banaba ꞌigwaeya, “Bwebweꞌana, ma Yoni tauna sihesaniyeya Maki tatoe ma mahetedai tatauya.” ");
INSERT INTO bdd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ma Paulo ꞌigwae, “Nuwana sahena tauna ꞌiꞌwayaꞌwayabugita, weyahina mwalo Pamipiliya ꞌoina ꞌiꞌebesinegita, ma ꞌihila ꞌasai, ta geya nuwana ma ꞌiꞌwayabugita ꞌida sakowasi ꞌoina.” ");
INSERT INTO bdd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Coinega Paulo ma Banaba siheꞌoheꞌoheya madouna Maki weyahina, ta Banaba Maki ꞌitoeya ta sigeluwa wagai ma sidobi bwanabwana Saipilosi ꞌoina. ");
INSERT INTO bdd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ma Paulo Sailasa ꞌihesinuweya ma ꞌiꞌwayabu ꞌina sakowasiina ꞌoina. Coinega tohekalesiyao Yehoba ꞌoina siꞌahwaꞌahwanoi, nuwanuwadi ma ꞌina helauwega siteluwaedi ꞌida ꞌabihewaiwaiyedi. Ta sitauya, ");
INSERT INTO bdd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ma silohihila Siliya ma Silisiya ꞌasaidiyao ꞌoidiya, ta Paulo tohekalesiyao ꞌiꞌabihetedi, ma ꞌiꞌabihe waiwaiyedi. ");
INSERT INTO bdd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo ma Sailasa ꞌidi sakowasi ꞌoina sitauya Debi ma Lisitila, ma Lisitila ꞌoina Yesu ꞌana tomuliya ꞌaigeda silobeya, sanina Timoti, tauna sinana wahine Yudiya. Sinanaina Yesu ꞌana tohemisa, ma tamana hesi gwama Gilisi. ");
INSERT INTO bdd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ma tohekalesiyao ꞌasa Lisitila ma Ikoniyami ꞌoidiya, Timotiina siꞌahwa bwebweꞌaneya ");
INSERT INTO bdd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ma Paulo nuwanuwana ma Timoti mahetediu sisakowasi, ꞌoinega ꞌibwauweya ma ꞌwapina ꞌiꞌupweya Mosese ꞌina loina gidemusa, ma ꞌabehega meYudiya Timotiina siheꞌasisiyane, weyahina meYudiya tupwaina Lisitila ꞌoina sisanapuya ꞌabehega Timoti tamana gwama Gilisi. ");
INSERT INTO bdd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ta sisakosakowasi ꞌasa ꞌaigeda ꞌaigeda ꞌoidiya, ma loinaina Yesu ꞌana tohepwailao ma tohanugetao mwalo Yelusalema ꞌoina siloinaeya sihepwaileya ꞌasa mabwaiyadi ꞌoidiya, ma ꞌabehega loinaina simulimuliye. ");
INSERT INTO bdd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Coinega tohekalesiyao ꞌidi hemisa ꞌihewaiwaiya, ma sabwelo ꞌaigeda ꞌaigeda ꞌoidiya ꞌadi boda ꞌimadomadou. ");
INSERT INTO bdd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Coinega Paulo ma ꞌiyanao tupwa Piligiya ma Galetiya ꞌalodiyega sitautau, ma Yaluyaluwa Tabuna ꞌiꞌausidiya ma sahena Yehoba tetelina tupwa Esiya ꞌoina siloguloguguyae. ");
INSERT INTO bdd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ma sinaoma Misiya ma sitohoya ma ꞌabehega Bitiniya ꞌoina siluhu, ta Yesu yaluyaluwana geya ꞌitagwaledi. ");
INSERT INTO bdd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Coinega Misiya siꞌebesineya ma sidobiya Tilowasi. ");
INSERT INTO bdd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Eeta hinuwana siꞌenoꞌeno ma Paulo ꞌinihiya, ta ꞌina nihiina beno loheya ꞌaigeda gwama Masidoniya ꞌiꞌiteya, ꞌitoholowa ma ꞌiꞌahwaꞌahwanoi Paulo ꞌoina, ꞌigwaegwae, “Cuhabalama Masidoniya ꞌoina ma ꞌuꞌabihetemai.” ");
INSERT INTO bdd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo ꞌina nihiina ꞌoinega ꞌasanapuya ꞌabehega Yehoba ꞌibwauwemaiya ma tetela bwebweꞌana ꞌaguguyae meMasidoniya ꞌoidiya, ꞌoinega ꞌeda ꞌabesa sabi habala Masidoniya. ");
INSERT INTO bdd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Coinega waga ꞌalobeya ma Tilowasi ꞌoinega ꞌaꞌuꞌe, ma dumwaluna Samotilesi, ma nobwa ꞌaꞌenowa. Gona ꞌiꞌadaleya ꞌaꞌuꞌe hila ma Niyapoli ꞌoina ꞌasuluwa, ");
INSERT INTO bdd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ma Niyapoli ꞌoinega ꞌatauya Pilipai, tauna ꞌasa madouna tupwa Masidoniya ꞌalona, ma gogoina ꞌalona meLoma taumana baibaiwadi simiyamiya, nage ꞌoina ꞌamiya hila sabwelo tupwana ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ma Sabatiya ꞌasega ꞌalatuwa ꞌatauya ꞌaigeda weꞌaha papalina, tupwaina ꞌanuwatuhuya ꞌebe lotapwalolo, ma ꞌoina ꞌamiyatoiya, ta wahiwahine siꞌetoꞌautama wete baꞌidamayao ꞌahehegwaegwaeya. ");
INSERT INTO bdd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ma ꞌaigeda wahine ꞌoidiyega sanina Lidiya, ꞌasa Tayataila wahineina, ma Yehoba ꞌana tohemisa, ta ꞌina paihowa beno ꞌaigeda ꞌaleꞌo wasawasa ꞌana tohegimwane. Ma wahiwahineyedi ꞌima gwae sihehesagohedi, ma Yehoba hemisa Lidiya ꞌatena ꞌilaguya, ma Paulo ꞌina guguya ꞌihemiseya, ");
INSERT INTO bdd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ma tauna maꞌina susuwao ꞌiꞌabihe babitaisowediya. Ta muliyetega ꞌiꞌahwanoiyemaiya, ꞌigwae, “Babadao, wasanapugauwa ꞌabehega Yesu yahemisaeya moisa, ꞌoinega sowasowahina wanaoma ma wahetaumana ꞌigu hada?” Ta ꞌiꞌohenemaiya, ma ꞌoinega ꞌatauya ꞌina hada. ");
INSERT INTO bdd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Hali sabwelo ꞌoina ꞌatautau tupwaina lotapwaloloina ꞌoina, ma babada tupwadi ꞌidi hewali gumalaulau ꞌalobeya, tauna hiꞌahiꞌa ꞌiluhuwa solana ma ꞌoinega sowasowahina ꞌihepwaila nugeta toꞌaha ꞌabwa ꞌilatu, ta ꞌina paihowa bewa ꞌoinega gumalaulauina ꞌina babadao mane madouna siꞌewaꞌewa tomota ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ta wahineina ꞌimulimuliyemai, ma ꞌiwuiwui, ꞌigwaeya, “Bewa tomotaedi Yehoba Tomiya tabwana hedada ꞌina topaihowao, ma ꞌabihetena ꞌana ꞌeda ꞌana tohepwailao.” ");
INSERT INTO bdd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gumalaulauina bewa gidemusa ꞌiwuiwui sabwelo baibaiwana ꞌoidiya, ꞌoinega Paulo wahina ꞌiloꞌwataꞌwata, ma ꞌiꞌitehinowa, ma yaluyaluwaina ꞌihegwaeya, ꞌigwae, “Yesu Keliso saninega yaloinego ma gumalaulau beno ꞌoinega ꞌulatu.” Ma nage ꞌoina ꞌihapwesa. ");
INSERT INTO bdd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ma gumalaulauina ꞌina babadao sigamwasowalemaiya, weyahina ꞌidi mane madouna ꞌana ꞌebeloba tauna gumalaulauina, ta Paulo ꞌiꞌabihe bwebweꞌaneya. Coinega Paulo ma Sailasa siꞌabiyahidiya ma silisi dadanediya, ta sitauyediya ꞌebehegimwane ꞌoina, ma sitoediya toloinao ꞌoidiya sabi yatalaedi, ");
INSERT INTO bdd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ta sihegwaediya, sigwae, “Bewa loheloheyaedi taudi meYudiya, ma sitauyama ꞌida ꞌasa ta ꞌada wahiꞌwataꞌwata silagulagu, ");
INSERT INTO bdd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","weyahina hali mumuga siheheꞌita, beno tauda meLoma ꞌida ꞌetoboda, ma sahena mumugaina tapaipaihowa.” ");
INSERT INTO bdd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ta bodaedi wete bewa gidemusa siheꞌewediya, ꞌoinega toloinao siloinaediya, ma Paulo ma Sailasa ꞌadi ꞌaleꞌo ꞌoidiyega silolodiya, ta ꞌaiwe ꞌoidiyega sisapi dadanediya. ");
INSERT INTO bdd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sihunu geyogeyoidiya ꞌigumwala, ma deliya silagu luhuwediya, ma deli ꞌana toꞌitayahina siloinaeya ma ꞌilomatayahi bwaibwaini. ");
INSERT INTO bdd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Coinega toꞌitayahinaina ꞌana loina ꞌihesagoheya, ta ꞌilagu luguhediya deli ꞌalona moisa, ma wete ꞌahedi ꞌiꞌahuyahidiya ꞌaiwe madoudi ꞌoidiyega. ");
INSERT INTO bdd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ma hinuwana Paulo ma Sailasa siꞌahwaꞌahwanoi ta siwaliwali Yehoba ꞌoina, ta ꞌoinega toluhu deliyao mabwaiyadi sihehesagohedi, ");
INSERT INTO bdd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ma mwaniꞌiniꞌi madouna ꞌipiliya ta sisalutuwama, ma hada deli ꞌana wahuwahu ꞌinihuwa, ta deliina ꞌana ꞌahwaꞌedao siꞌesoꞌediya, ma ꞌoinega toluhuwedi ꞌahedi ꞌadi paiyao siꞌelihasidiya siboidimo. ");
INSERT INTO bdd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ta deli ꞌana toꞌitayahina ꞌenoꞌenowega ꞌisalutuwama, ta ꞌahwaꞌeda soꞌesoꞌedi ꞌiꞌitediya, ta ꞌina nuwatuhu toluhuwedi sidena pwaiya, ꞌoinega ꞌina ꞌelepa ꞌaleha ꞌiꞌeweya ta ꞌabehega ꞌiboi ꞌida loheꞌamasi hile. ");
INSERT INTO bdd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ta Paulo ꞌiꞌiteyama, ma ꞌiwuiya, ꞌigwae, “Ciyagu, sahena ꞌuboi ꞌulohelohe ꞌamasigo. Mabwaiyama bewa ꞌamiyamiya.” ");
INSERT INTO bdd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Coinega toꞌitayahinaina ꞌina topaihowao ꞌoidiya ꞌibwauwa ma mayale siꞌeweyama, ta mayale ꞌiꞌeweya, ma ꞌipili ta ꞌiluhuwa maꞌina dedela, weyahina ꞌimatauta, ta ꞌibeꞌu talutalubuꞌiya Paulo ma Sailasa matadiya. ");
INSERT INTO bdd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ma muliyetega ꞌitoholo ta ꞌitoe latuhedima, ta ꞌigwae, “Babadao, wahegwaegau toꞌaha yapaihowa ma ꞌoinega Yehoba ꞌiꞌabihetegau?” ");
INSERT INTO bdd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ma Paulo ma Sailasa sigwaeya, “Ceguma Bada Yesu ꞌoina ꞌuhemisa, nata ꞌowa maꞌino susuwao wete ꞌabihetena waloba.” ");
INSERT INTO bdd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ta Badaina tetelina siheꞌoteꞌoteteliya tauna maꞌina susuwao ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hinuwana nage ꞌoina ꞌitoe latuhediya ma ꞌadi gane ma bweyaha sapiyega silobeya ꞌibuyodiya, ta tauna maꞌina susuwao sibabitaiso. ");
INSERT INTO bdd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sibabitaiso ta ꞌitoediya tauna ꞌina hada, ma ꞌoinega ꞌadiwa ꞌiꞌatububuya, ma siꞌaiya. Ta deli ꞌana toꞌitayahinaina maꞌina susuwao siyaliyaya madouna, weyahina ꞌina hemisa hauhauna Yehoba ꞌoina ꞌilobeya. ");
INSERT INTO bdd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Gona ꞌiꞌadaleya ma toloinao ꞌidi topaihowao, gide polisi, sihewasediya deli ꞌana toꞌitayahi ꞌoina ma siloineya ꞌabehega, “Loheya ꞌeluwaedi deliya ꞌalagu luhuwediya ꞌulihasidi ma sitauya.” ");
INSERT INTO bdd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Coinega toꞌitayahiina deli ꞌalonega ꞌiluhuwa ma wasaina ꞌihepwaileya Paulo ꞌoina, ꞌigwae, “Toloinao wasa sihewaseyama ꞌabehega yalihasigomi, ꞌoinega wahapwesama ma maꞌimi yaliyaya watau.” ");
INSERT INTO bdd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma Paulo ꞌilogwahata, ꞌigwaeya, “Sahena ꞌatautau. Weyahina geya ꞌaigeda ꞌima puimo yatala ꞌoina siloba, ma boda matadiya sihunu dadanemaiya, ta deliya silagu luhuwemaiya, ma tauma hesi mwalo ꞌahe Loma. Toꞌaha weyahina ꞌabehega silihasimai ma sitoe latuhemai dahwanega? Ma ꞌilobwainediya hesi taudi tuwa sinaoma ma sitoe hapwesemai.” ");
INSERT INTO bdd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Coinega polisiyedi sihila toloinao ꞌoidiya ma Paulo ꞌina gwae sihepwaileya ꞌoidiya. Ta toloinaowedi sideba mwadina madouna, weyahina hepwaila bewa ꞌoinega sisanapuya ꞌabehega Paulo ma Sailasa sihe Loma. ");
INSERT INTO bdd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Coinega sinaoma deliya, ma ꞌatemuyemuyega sigwae helauwa Paulo ma Sailasa ꞌoidiya, ma deliyega sitoe hapwesediya, ta siꞌahwanoiya ꞌoidiya, nuwanuwadi ma siꞌebesinedi, sitauya hali ꞌasa. ");
INSERT INTO bdd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ta Paulo ma Sailasa deliyega sitauya Lidiya ꞌina hada, ma tohekalesiyao mahetediyao siheꞌiyaꞌiyagu ma siguguya ꞌoidiya, ma muliyetega sitauya. ");
INSERT INTO bdd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Eeta sitauya Amipipoli ma Apoloniya ꞌoidiya, ma Tesalonaika ꞌoina silatuwa, ta Tesalonaika ꞌoina meYudiya ꞌidi hada tapwalolo ꞌimiyamiya. ");
INSERT INTO bdd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ta Paulo ꞌidi lotapwalolo ꞌoina ꞌiluhuwa, gidemusa tupwa mabwaiyana ꞌoidiya ꞌipaipaihowa ꞌesa, ma nobwa Sabati ꞌetoi ꞌoidiya Buki Heꞌasisi ꞌoinega ꞌiheꞌiheꞌita ma baꞌidanao siheheꞌoheꞌohe, ");
INSERT INTO bdd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ta Pauloina sanapu ꞌiꞌebwaediya, ꞌigwae, “Toꞌabihetenaina ꞌilobwaineya ma muya ꞌiloba ma ꞌiꞌamasa ta wete ꞌamasega ꞌitoholo hila.” Ma wete ꞌigwaeya, “Yesuina yahehepwaile ꞌoimiya tauna tuwa Toꞌabihetenaina.” ");
INSERT INTO bdd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Coinega tupwadi siꞌahwa moisaeya, ma Paulo ma Sailasa ꞌidi boda ꞌoina siluhuwa, ta wete Yehoba ꞌana toheꞌasisiyao taudi tupwa ganamuli ꞌoidiyega ma wahiwahine sanidi madoudi ꞌoidiyega tupwana baibaiwadi wete sihemisa. ");
INSERT INTO bdd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ta meYudiya Paulo ma Sailasa siheꞌipiꞌipiyediya ma siꞌahwa galagalaediya, ma tupwana toyawala besobeso galadi siloinedi ma boda madouna sihegogonediya ta nuwanuwadi siloꞌalehedi. Coinega Yesoni ꞌina hada sihaneiya, ꞌidi nuwatuhu ꞌabehega Paulo ma Sailasa hadai simiyamiya, ma ꞌabehega sida ꞌabiyahidi, siꞌewa latuwedi boda ꞌoidiya. ");
INSERT INTO bdd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma siꞌebesa ꞌasaediya, ta Yesoni ma tupwana tohekalesiyao baꞌidanao siꞌabiyahidiya, ma ꞌoinega sitoedima ꞌasa ꞌana toloinao ꞌoidiya sabi heyatalaedi, ta sibwaubwau sigwae, “Loheloheyaedi taudi tupwa mabwaiyadi ꞌadi toꞌabihegalao sitauya pwaima ꞌebwa, ");
INSERT INTO bdd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ma Yesoni ꞌina hadai sihetaumana, ta ꞌidi heꞌita ꞌoinega Sisa ꞌina loina siligehiya, weyahina sigwaegwae ꞌabehega kini hauhauna ꞌilatuma, sanina Yesu.” ");
INSERT INTO bdd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Casa ꞌana toloinao ma bodao heꞌewa bewa sihesagoheya ta siꞌateyohowa, ");
INSERT INTO bdd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ꞌoinega siloina Yesoni maꞌiyanao ꞌoidiya ma ꞌabehega ꞌidi mane ꞌoinega sida hemaisa, ta wete sida miya daumwala. Ma sihemaiseya ma silihasidiya, ta sitauya. ");
INSERT INTO bdd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ma hinuwana tohekalesiyao Paulo ma Sailasa sihewasaedi ma sida tauya Beliya, ꞌoinega sitauya, ma tutaina silatuwa Beliya siluhuwa meYudiya ꞌidi hada tapwalolo ꞌoina, ta Yesu wasana siheꞌita. ");
INSERT INTO bdd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mwalo Tesalonaika ꞌoina meYudiya genuwadi wasaina, ma hesi meYudiya Beliya ꞌoina ꞌidi tagwala bwebweꞌana, ma wasaina nuwadi ꞌiꞌeweya, ꞌoinega sabwelo ꞌaigeda ꞌaigeda Buki Heꞌasisi sihasihasili ta ꞌabehega wasa bewa ꞌana moisa sida sanapu. ");
INSERT INTO bdd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Coinega meYudiya tupwana baibaiwadi sihemisaey