﻿USE sofia;
DROP TABLE IF EXISTS sofia.bcw_vpl;
CREATE TABLE bcw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bcw_vpl WRITE;
INSERT INTO bcw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Avanay njasa nza hwəlfə jijihiy Yesəw *Kəristəw, ntsaa səvəri mbə kar *Davitə ghəshi lə *Abəraham. ");
INSERT INTO bcw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Tə kwataŋay, baw Abəraham yakə *Izakə, mbaꞌa Izakə yakə *Zhakwapə, mbaꞌa Zhakwapə yayakə kar Zhəwda, ghəshi lə nihwəti ngwarməhiy gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Mbaꞌa Zhəwda yakə kar Peresə lə Zara. Tamar na mbəghəshi kar Peresə lə Zara. Mbaꞌa Peresə yakə Esərəm, baw Esərəm yakə Ram, ");
INSERT INTO bcw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","baw Ram yakə Aminadabə, mbaꞌa Aminadabə yakə Nashən, mbaꞌa Nashən yakə Salmən. ");
INSERT INTO bcw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Dzəghwa Salmən baw yakə Bəwazə. *Rahabə na mbəghəy Bəwazə tsa va. Dzəghwa Bəwazə baw yakə ꞌWəbetə. Mbəghəy ꞌWəbetə na Rətə. Mbaꞌa ꞌWəbetə yakə *Zhese, ");
INSERT INTO bcw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","mbaꞌa Zhese yakə mazə *Davitə ki. Dzəghwa baw mazə Davitə yakə *Saləmaŋw. Mbəghəy Saləmaŋw na mali ꞌWəri va niy nza ki. ");
INSERT INTO bcw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Mbaꞌa Saləmaŋw yakə Rəbəwam, baw Rəbəwam yakə Abiya, baw Abiya yakə Asafə, ");
INSERT INTO bcw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","baw Asafə yakə Zhəzafatə, baw Zhəzafatə yakə Zhəwram, baw Zhəwram yakə ꞌWaziyasə, ");
INSERT INTO bcw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","baw ꞌWaziyasə yakə Yətam, baw Yətam yakə Ahazə, baw Ahazə yakə Ezhekiyasə. ");
INSERT INTO bcw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Mbaꞌa Ezhekiyasə yakə Manase, mbaꞌa Manase yakə Amaŋw, baw Amaŋw yakə Zhəshiyasə, ");
INSERT INTO bcw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","baw Zhəshiyasə yakə Yekwəniya, ghəshi lə nihwəti ngwarməhiy, geꞌi ghala pətsaa niy kəəsəhwəshi mbəzli ka *Babilaŋw dzəti hiɗi shi. ");
INSERT INTO bcw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ma ləy hwəm sa kəəsəhwə məndi mbəzli ka *Izərayel dzəti hiɗi ka Babilaŋw ki na, dzəghwa Yekwəniya mbaꞌa yakə Salatiyel, baw Salatiyel yakə Zərəbabel, ");
INSERT INTO bcw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","baw Zərəbabel yakə Abiyədə, baw Abiyədə yakə Eliyakim, baw Eliyakim yakə Azər, ");
INSERT INTO bcw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","baw Azər yakə Sadəse, baw Sadəse yakə Ahim, mbaꞌa Ahim yakə Eliyədə, ");
INSERT INTO bcw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","baw Eliyədə yakə Eliꞌazar, mbaꞌa Eliꞌazar yakə Matan, baw Matan yakə Zhakwapə, ");
INSERT INTO bcw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dzəghwa ki baw Zhakwapə yakə *Zhezhefə, ntsaa məəti Marəy, mbəghəy Yesəw tsa har məndi vaa *Kəristəw Ntsa tivə Hyala ki. ");
INSERT INTO bcw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma mbəzli yakə məndi va kwətiŋ kwətiŋ, ka ꞌwava tə Abəraham paꞌ tə Davitəy, məŋ lə faɗə na jijihi. Dzəghwa mbəzli yakə məndi kwətiŋ kwətiŋ ka ꞌwava tə mazə Davitə paꞌ ghala vici kəəsəhwə ka Babilaŋw ka Izərayel na, məŋ lə faɗə jijihi diɓa. Geꞌi səəkə tə tsava vəghwə ka sar paꞌ tə vəghwə tsa yakə məndi Kəristəw na, gar jijihi məŋ lə faɗə diɓa. Ava tsəgha na. ");
INSERT INTO bcw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Avanay njasa yakə məndi Yesəw Kəristəw: A tsahwəti ndə niy nza tiɓa, *Zhezhefə, kə məndi slən tsa ciy, ghəci niy mə na Marəy, mbəghəy Yesəw. Ma ghəshi ghwəla ta ɓəvay, dza Marəy mbaꞌa ɓəvə hwər lə bərci *Safə tsa Hyala ɗewɗew tsa. ");
INSERT INTO bcw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma Zhezhefə, ghəci bazhata Marəy tsa va kiy, ntsa wəzə tsa ghəci, ka nəw kwəma Hyala tərəŋw. Kala ɗi ghəciy pəli kwəma hwər tsa Marəy vaa səvəriy dzəti ngwəla kaa nihwəti mbəzli. Dza na mbaꞌa tarəkə ndaniy səvəri mbə, kala gar sənay mbəzli gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma ghəci ghwəlay mbə təkə kwəma va tsəgha na, dzəghwa vaŋ ndə kwal tsa Ndə sləkəpə səəkəy ngəci tsəgha kwa shiw. A kə ngəci na: «A Zhezhefə jijiy mazə *Davitə, ka hazləni gha va ɓə makwa gha Marəy ta nza ghənzə ka mali gha ma, sa nzana, ma hwər tsa ɓəvə na vay, Hyala mənti na dzar kwa bərci Safə tsa nzə ɗewɗew tsa. ");
INSERT INTO bcw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ava ta yakə zəghwəə zal dza na, ma nza gha fanati slən Yesəw ngəci, sa nzanay, ghəci dza naa mbəli mbəzli mbə hwəlfə ci səvəri mbə jikir tsa shi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma kwəmaa mənta va gwanata tsəghay, war ta mbə kwəma gəzəkə Ndə sləkəpə va lə miy tsa *ndə gəzə kwəma Hyalaa dzəghwata kwa na, a kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ava ta ɓəvə hwər dza zha kwa cikita, mbaꞌa dzaa yakə zəghwəə zal. Mbaꞌa məndi dzaa fanati slən Emanəwel ngəci, kə niy ni. Ma slən Emanəwel tsa va kiy, lə ghwəmmə na Hyala, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dzəghwa Zhezhefə sa fərghəy na ki na, mbaꞌa dzaa ɓəvə makwa ci ka mali ci, njasa gəzanakə ndə kwal tsa Ndə sləkəpə va ki. ");
INSERT INTO bcw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma sa ɓətəvashi ghəshi ki na, mbaꞌa ghəshi nzəyshi kala həni ma paꞌ va vəghwə tsa yakə Marəy va zəghwə nzə. Mbaꞌa Zhezhefə fanati slən Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mbə məlmə Betəlehem tə hiɗi ka Zhəwde niy yakə məndi Yesəw ki. Ghala vəghwə tsa vay, *Erədə niy nza mazə tsaa sləkə hiɗi va. Ma ləy hwəm sa yakə məndiy, mbaꞌa mbəzliy nighə sasərkwə ta sənashi shiy dzaa məniva tə hiɗi səəkəshi kwa ghwəmə, ta dzəmbə məlmə Zherəwzalem. ");
INSERT INTO bcw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma sa tsəhəshi ghəshi na, tapə ghəshi ta ɗəw, a kə ghəshi na: «A ghəy nata yəwən sasərkwə tsahwəta kwa ghwəmə, ghənzə citəŋəy na a mazə tsa *ka Zhəwifə yay, kə. Va tsəgha səəkə ghəy ta tsəfəkwə kwa kwəma ci lə ta pəraꞌwanci dividivi. Citəŋəyəm nda dzəghwa tima na məlmə yay zəghwə va va mbə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma sa favə mazə Erədə nava kwəma tsəgha na, mbaꞌa her ci dzashi tərəŋw tərəŋw. Mbəzli mbə məlmə Zherəwzalem na, tərəŋw her shi dzashi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nzaꞌjəw Erədə ɓasəti mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala gwaꞌa gwaꞌa. Tapə ghəci ta ɗəw və shi, a kə na: «Kwəma niy dza məndiy ya *Ntsa tivə Hyala va ta mbəli mbəzli shama?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma kə ghəshi ngəci na: «Waa mbə məlmə Betəlehem tə hiɗi ka Zhəwde dza məndiy ya. Sa nzanay, vanta kwəma tsasliti *ndə gəzə kwəma Hyalaa dzəkən, ma kəy: ");
INSERT INTO bcw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ma ghay məlmə Betəleheməy, məniŋa ghaa məlmə gəmta na mbə məlməhi tə hiɗi ka Zhəwde teepəw! Sa nzanay, mbə Betəlehem dza məndiy ya mazə tsaa dzaa sləkə hwəlfə mbəzlee ka *Izərayel, kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dzəghwa sa favə Erədə kwəma va tsəgha ki na, daꞌ harvə mbəzliy sənata kwəma va tsəgha tə mbə. A kə ngəshi na: «Hwəm gha ghwəy nata yəwən sasərkwə vaa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma sa gəzanci ghəshi vəghwə tsa va, a kə na: «Ma pə ghwəy məntiy, mbalam dzəmbə məlmə Betəlehem, a ghwəy pəla zəghwə va mbəɓa lə məhərli. Sa ka ghwəy kəsayəy nza ghwəy səəkəə gəzara. Nzee mbəə dza ta pəraꞌwanci nee dəvə ngəci kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma sa favə mbəzli va kwəma gəzanakəshi mazə va tsəgha na, kafə ghəshi kafəshi ka dzashi. Ma ghəshi mbə dzashi, tsaꞌ kə ghəshi na, sasərkwəə citəvata va ngəshi səəkə kwa ghwəmə mbə ꞌwanshi kwəma, mbaꞌa ghəshi vəshishi tərəŋw ki. Ka nəw ghəshi. Ma sa tsəhəta na geꞌi geꞌi lə pətsa nza zəghwə va dzəghwa ti na, mbaꞌa garəta. ");
INSERT INTO bcw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dzəghwa ghəshi irətsə ghəshi dzashiy dzəmbə ciki tsa va. Mbaꞌa ghəshi kəsay zəghwə va, lə mbəghəy Marəy. Dza gəgələɓə, ghəshi gələɓəshi, ka pəraꞌwanci dividivi shi. Tapə ghəshi mbə pəəli mbəleɗemer shi, ka ɓəɓə shi dza ghəshi ta vəlanci ngəci səəmə kwa shi, ka ɓanci tsahi mbəzə, lə ꞌwərdi, mbaꞌa dimə fəə zən wəzə, *Mirə, kə məndi kaa slən tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma ləy hwəm kwəma va ki na, mbaꞌa ghəshi dzashi. Dza Hyala mbaꞌa gəzanakəshi kwa shiw: «Əntaa ghwəy taa zhiniy dza zhar kwa mazə Erədə ghala pətsa ka ghwəy zhəghəva ta dzaŋwəy ma» kə ngəshi. Ma sa gəzanshi Hyala tsəgha na, mbaꞌa ghəshi ɓəvə tsahwəti kwal ta dzashiy jighi. ");
INSERT INTO bcw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma ləy hwəm sa dzashi mbəzliy sənata kwəma va na, dzəghwa ndəs ndə kwal tsa Ndə sləkəpə səəkəy va Zhezhefə kwa shiw. A kə ngəci na: «A Zhezhefə, sati pəmə mali gha Marəy lə zəghwə nzə va, a ghwəy hwəŋwəy dzəti hiɗi ka Ezhipətə lə zəghwə va. Mbala nzəyŋa ti shi, paꞌ tə vici dzee zhiniy gəzaŋa zhəghəvaa səəkə. Sa nzanay, ta pala zəghwə va dza mazə *Erədə ta paslamti» kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma sa favə Zhezhefə tsəgha na, dzəghwa na pəm, pəməvə mali ci va tsəgha lə zəghwə nzə, war ka dzashiy dzəti hiɗi ka Ezhipətə həvir va. ");
INSERT INTO bcw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mbaꞌa dzaa nzəyəy tə hiɗi va, ka dzar paꞌ ghala vəghwə tsa mətiy Erədə ki. Ma shiy mənishi vay, war ta mbə kwəmaa gəzəkə Ndə sləkəpə va lə miy tsa *ndə gəzə kwəma Hyala tsa ciy dzəghwata mənishi ghəshi. Ma kə niy niy: «Ma yənəy, e harkəvəri zəghwee səvəri mbə hiɗi ka Ezhipətə» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ghala vəghwə tsaa niy gəzanci Hyala va hwəy dzəmbə *Ezhipətə kaa Zhezhefə kiy, war mbə ndəghə səəkə tsa mbəzliy sənata kwəma va niy nza mazə Erədə naci ki. Dzəghwa sa nay na kala tsahwə mbəzli va na, mbaꞌa sənay dakəə dakəti ghəshi, kə, tərəŋw nəfə tsa ci satiy. Dzəghwa na tsəgha ghwəni ghwənashi mbəzliy dzəmbə məlmə Betəlehem lə nihwəti məlməhi dzar vəgha. A kə ngəshi na: «Mbalam dzəmbə məlməhi va a ghwəy dzaa bakwamti ndərazhi yakəm ndatsə paꞌ tə niy mənti piya bakə ghala yakəshim» kə. Ma kwəma gəzəkə Erədə va tsəghay, sa nzana ꞌwava na tə vəghwə tsaa nata mbəzliy sənata kwəma va sasərkwə paꞌ tə vici ghwəni na va mbəzli ta bəkwə ndərazhiy, niy mənti piya bakəw. ");
INSERT INTO bcw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma sa bakwamti Erədə ndərazhi ki na, mbaꞌa kwəma va dzəghwataa dzəghwa kwəmaa niy gəzəkə *Zhereməy ndə gəzə kwəma Hyala va niy nə na: ");
INSERT INTO bcw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ava lalaa gakata mbə məlmə Rama! Tihwəniy tihwəni məndi, war ka ndiɓə ghən tərəŋw tərəŋw. *Rashal təhwəni na ta ndərazhi nzə, zləɓati ya jəw nzə məndiy gəzanta kwəmaa dəpanta nəfə tsa nzə, sa nzana mbaꞌa ndərazhi nzə va bəkwəshiw! kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dzəghwa mbaꞌa *Erədə mətiy ki. Ma sa mətiy Erədə ki na, dzəghwa ndəs ndə kwal tsa Ndə sləkəpə səəkəy kwa shiw kaa Zhezhefə, tə hiɗi ka *Ezhipətə. ");
INSERT INTO bcw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A kə ngəci na: «Zhezhefə, sati maɗi, pəmə mali gha ghəshi lə zəghwə nzə, zhəghəvaa zhəti hiɗi ka *Izərayel li shi. Sa nzanay, a mbəzliy niy pala kwal tsaa pəəsli zəghwə va va bəkwəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dzəghwa Zhezhefə tsəgha mbaꞌa maɗiy, pəm pəməvə kar zəghwə va ghəshi lə mbəghəy, ka zhikəshi zhəti hiɗi ka Izərayel. ");
INSERT INTO bcw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma tsəhə na na, mbaꞌa favə, Arkiləwəsə zəhwə na ghi ta mazə tsa Erədə tə hiɗi ka Zhəwde, kə məndi. Dzəghwa na mbaꞌa hazləniy va nzəy tə hiɗi va ki, sa nzana zəghwə Erədə Arkiləwəsə tsa va niy nza. Dzəghwa Hyala mbaꞌa cinti kwa shiw diɓa njasa ka na məni. Ləy hwəm ki na, mbaꞌa dzaa nzəyəy mbə nahwəti məlmə tə hiɗi ka Galile, ");
INSERT INTO bcw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaretə, kə məndi slən tsa nzə. Ma mbə kwəma va tsəgha kiy, mbaꞌa kwəmaa gəzəkə *ndə gəzə kwəma Hyala va mbəradzə dzəghwata kwa. Ma kə niy ni na: «Ghəciy, ndə ka Nazaretə dza məndiy har» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma ghala vəghwə tsaa nza Yesəw mbə Nazaretə kiy, mbaꞌa Zhaŋ tsaa məni batem kaa mbəzli tsahwəy kwamti, tə gamba ka Zhəwde ki. Dza na mbaꞌa ghati gəzəpə kwəma Hyala, ");
INSERT INTO bcw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma kə na: «Ghwəyəy, tsam titihwə kwa kwəma Hyala, zhəghantim nzəy tsa ghwəy, sa nzanay, ndəkwə ndəkwə na vəghwə ta səəkə Hyala ta sləkə mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ghala kwataŋatay, a *Ezay ndə gəzə kwəma Hyala niy gəzəkə kwəmaa dzəkən Zhaŋ tsa va. Ma kə niy ni na: Ava məli ndəə gaka mbə zlapə mbə gamba, ma kəy: «Gwəmantim nefer ghwəy ta kaꞌwə Ndə sləkəpə, njasa ka məndi vaa zamti kwal wəzə wəzə ta kaꞌwə ntsa dikə tsa, mbaꞌa ghwəy ghwənanamti nefer ghwəy wəzə wəzə» kə, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ma kwəbaŋ tsa dza Zhaŋ li kən ghən ci ghalaɓa ki na, lə shiti ngaləwba niy tsati məndi, dzəghwa ɓiyakə pəhətəvay lə kanda hwətəɓə dzəvəri mbə hwər ci. Ni ci shi zəmə zəmə na na, war hayer lə mbəzəkwə tsa kwamti. ");
INSERT INTO bcw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dzəghwa ki, ka ɓasəva mbəzli mbə məlmə Zherəwzalem, lə mbəzli mbə nihwəti məlməhi tə hiɗi ka Zhəwde, lə ni mbə məlməhi dzəy miy həl Zhərdeŋ gwanashiy dzəvəgha. ");
INSERT INTO bcw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sa tsəhəshi ghəshi na, mbaꞌa ghəshi cicikəvəri kwəma shi jikir na mənti ghəshi gwaꞌa gwaꞌa. Dza Zhaŋ ka mananshi batem kwa həl Zhərdeŋ ki. ");
INSERT INTO bcw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dzəghwa ki ɗaŋ *ka Farisahi, lə *ka Sadəsehi səəkəshiy dzəvəgha Zhaŋ ta mananshi batem ghəci kwərakwə. Ma sa nashi Zhaŋ na, dza na ka gəzanshi, a kə na: «Ghwəyəy, nja shesher ndərəm ghwəy. Mbə təkə kwəma ghwəyəy, ta mbəliŋəy dza ghəy va ngwəvə Hyala va dzaa səəkə sa ka məndi məntəŋəy batem nə ghwəy. Wa ntsaa gəzaŋwəy tsəgha na kəa? ");
INSERT INTO bcw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mbaꞌa pə ghwəy ɗi mbəliŋwəyəy, ə pə ghwəy məni sləni wəzə na, gar sənay məndi a ghwəy zhəghanti nzəy tsa ghwəy kataŋ kataŋ, kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nəghətaa ghwəy taa zəzəti na: “A ghəy dzaa mbəliŋəy, sa nza *Abəraham vaa jijiŋəy” pə ghwəy ma. Ma na Hyala nanzə e gəzaŋwəyəy, a bərci və ta zhəghəti ya hərezli nashi ghwəy ni ka ndərazhi Abəraham. ");
INSERT INTO bcw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A gəzaŋwəy ya, ndəkwə na ngwəvə Hyala nanzə ki, njasa ka tsəꞌi vaa nza mbəzə mbəzə ta kəəsli fəhiy dzaa ya ma ya wəzə na gwanashi, ta ndəti ghwə ti shi. ");
INSERT INTO bcw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ma yən na neyey, lə yam ngəri məniŋwəy ya batem, ta mbə məndiy sənay a ghwəy zhəghanti nzəy tsa ghwəy ka tsati titihwə, kə məndi. A tsahwəti ndə dzaa səəkə ləy hwəm tsee kiy, a taŋətəra tə dikə. Məniree gar gələɓee ta təɗanci kwakwahə tsa mbə səɗa ciw. Na na ciy, lə *Safə tsa Hyala, mbaꞌa lə ghwə dza naa səəkə ta məniŋwəy batem. ");
INSERT INTO bcw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sa ka na səəkəyəy, ta məni ngwəvə dza naa dzəkən mbəzli. Ngwəvə ci vay, njasa ka ndə vaa pəhə ha dza naa məni, lə kwakwa gaga ta dəvə ci. Ma sa ka na pəhamti na, mbaꞌa ɓasaghwa ha ci kwa tamə, ma davəna na, mbaꞌa ndamti mbə ghwəə dzaa məti ma ya paꞌ hwəmɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dzəghwa ki, mbaꞌa Yesəw kafəy mbə hiɗi ka Galile, mbaꞌa səəkəy dzəməy həl Zhərdeŋ. Ma sa tsəhəy na miyɓa na, mbaꞌa kətəghəvay dzəvəgha Zhaŋ ta mananci batem Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Zhaŋ na, kala ɗi zləɓa mananci batem. A kə ngəci na: «Tawa tsəgha nə gha kia? Avanay sanay, gha niy təɓə naa mənira batem, zhini ɓa na, ka səəkə vəya ta məniŋa batemee, pə gha shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma kə Yesəw ngəci na: «A Zhaŋ, wa yaŋ pə gha na gha. Sa nzanay, war tsəgha dza ghwəm mənti, nza ghwəm mbəə faghwa kwəma kwa kwəma ɗi Hyala» kə. Dza Zhaŋ tsəgha mbaꞌa zləɓati ki, mbaꞌa mananati batem. ");
INSERT INTO bcw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","War sa mananamti Zhaŋ tsəgha ki na, mbaꞌa Yesəw səəməy kwa yam. War ghwəla na, ɓəŋ ghwəmə ghwənita, nighə Yesəw na, *Safə tsa Hyalaa səəkə mə ghwəmə ndəɓa ghərpəpə, pə gha, ka paꞌwəə dzəkən. ");
INSERT INTO bcw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma fa na ɓa na, gaka məli ndəə gəzə kwəma səəkə məɓa, ma kə na: «Ava ghəci na Zəghwee ɗee tərəŋw, mbə vəshi nzee ti dalala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma ləy hwəm ki na, mbaꞌa *Safə tsa Hyala pəməghə Yesəw dzəmbə gamba, ta mbə ndə jaka tsa Hyalaa həərə. ");
INSERT INTO bcw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dzəghwa na faɗə mətsəkə ghəci mənti vici mbə gamba va. Shaŋ ghəci ta ngəmiy ya waꞌa havəghwə lə həvir gwaꞌa. Mbaꞌa ma ꞌwati ghəranci ləy hwəm. ");
INSERT INTO bcw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ꞌWakəvə ndə jaka tsa Hyala ki, kət kətikəvay dzəvəgha Yesəw. Ma kə kaa ngəci na: «Ndata Zəghwə Hyala nza ghay, gəzanshi kaa hərezli ni a ghəshi zhəghəshi ka shi zəmə, a gha zəməshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma kə Yesəw kaa zləɓanci na: «Ma kə kwəma tsasliti məndi mbə Zliya Hyalay: “Ka nzəyəy ndə tə hiɗi kwataka lə shi zəmə gwaꞌa tsəghaw, kwəma gəzəkə Hyala lə miy tsa nzəy, ghənzə na saa dzaa kəsəti piy tsa ndə” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ma sa nay ndə jaka tsa Hyala shaŋ ghəci ta mbay Yesəw dza kwa nava bəla na, dza na mbaꞌa pəməghə dzəmbə məlmə Zherəwzalem ɗewɗew na, mbaꞌa pəməghə dzəmə ghən *ciki Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma kə kaa ngəci na: «Ndata Zəghwə Hyala nza ghay, ndəɓəvaa dzəghwaa dzəti hiɗi, sa nzanay, a məndi tsasliti kwa Zliya Hyala: “Ta ghwənikə ka kwal nzə dza Hyalaa dza ngəŋa, nza ghəshi kaꞌwətəŋa lə dividivi shi, va nəghətaa hakwə gwəlahantaa tə səɗa gha” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma kə Yesəw na: «A məndi tsasliti kwa Zliya Hyala, ma kə məndiy: “Əntaa gha dzəghə nighə kwəma Hyala gha Sləkəŋa ma” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ma sa nay ndə jaka tsa Hyala shaŋ ghəci ta mbay Yesəw dza kwa nava bəla diɓa na, mbaꞌa ɓəghə dzəmə ghən dəlagwaa gwəramti yakəyakə. Garə ghəshi garəshi mə, mbaꞌa canamti pətsa sləsləkəm tə hiɗi gwaꞌa gwaꞌa, lə njasa nza diɓədiɓə tsa mbə shi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma kə ngəci na: «Nay gha tsəy, shi nashi gha va gwanashiy, ta ndaŋashi dzee mbə dəvə gha, war tsəfəkwəŋa ma gha kwa kwəmee gwaꞌa tsəgha, ka pəraꞌwəra dəvə gha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma kə Yesəw ngəci tə kwa kərni kwəma va ki na: «Gha gha ndə jaka tsa Hyala tsa, ɓarvaŋa vəghee! A məndi tsasliti kwa Zliya Hyala: “War kwa kwəma Hyala gha sləkəŋa, pə gha dzaa tsəfəkwə, war kaa ngəta pə gha dzaa ghəra sləni kwətita ya hwəmɓa” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dza ndə jaka mbaꞌa ɓarvay vəgha Yesəw ghalaɓa, mbaꞌa zlay ka dzay ki. Mbaꞌa *ka kwal Hyala səəkəshi, tapə ghəshi mbə kəəti ci ki. ");
INSERT INTO bcw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dzəghwa mbaꞌa məndi kəsəti Zhaŋ tsaa məni *batem va kaa mbəzli, mbaꞌam faghwa kwa fərshina. Ma sa favə Yesəw kwəma va na, dzəghwa na mbaꞌa kafəy, ka dzay dzəti hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma sa tsəhəy na na, kala nzəy ghəci mbə məlmə Nazaretə, mbaꞌa dzaa nzəyəy mbə Kapernahwəm, məlmə lati məndi miy kwəfa ka Galile. Ma pətsa nzəyəy na va tiy, mbə tsa sləkə ka Zabəlaŋw lə ka Nefətali pi na. ");
INSERT INTO bcw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ma mənta kwəma va tsəgha kiy, war ta mbə kwəmaa niy gəzəkə *Ezay ndə gəzə kwəma Hyala vaa dzəghwata kwa na. A kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","A ghwəy ghwəy mbəzli tə hiɗi ka Zabəlaŋw lə shi ka Nefətali, hiɗi kwa kwal tsaa səəkəə dzəməy kwəfa, pəriɓa pəriɓa tə miy həl Zhərdeŋ, hiɗi nzəyshi mbəzliy sənata ma Hyala kataŋ na ti shi tə hiɗi ka Galile, ");
INSERT INTO bcw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ghwəy ghwəy mbəzli mbə kwəsliŋwəy niy, ta nay waŋ tsaa dzaa məniva tərəŋw tsa dza ghwəy. Mbaꞌa waŋ tsa va dzaa səəkəy dzəkən mbəzliy nzəyshi mbə zhəkwətə, tə pətsa nza məti, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ma ghalaɓa ki na, mbaꞌa Yesəw ghati gəzəpə kwəma Hyala, a kə na: «A pə ghwəy məntiy, tsatim titihwə tsa ghwəy kaa Hyala, a ghwəy zlashi shiy niy məni ghwəy kwataŋa. Sa nzanay, ndəkwə ndəkwə na vəghwə ta səəkə Hyala ta sləkə mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tə nahwəti vici Yesəw mbə dza dzar miy kwəfa Galile na, mbaꞌa nashi mbəzli bakə, kar ndə lə zəmbəghəy, ghəshi mbə bazla zlekwer dzəti kwəfa ta kəəsə kərpi, sa nza ghəshiy ka kəəsə kərpi. Mbəzli vay, kar Shimaŋw tsa nə məndi slən tsa ci Piyer, kə məndi, mbaꞌa Andəre zəmbəghəy niy nza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma kə Yesəw ngəshi tsəgha ki na: «A mbəzli ni, nəwram, zlashim kəəsə kərpi, e dzaa məntəŋwəy ka mbəzliy haka mbəzliy səəkə ta nəwra» kə. ");
INSERT INTO bcw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma sa favə ghəshi tsəgha na, nzaꞌjəw mbərəkə mbəzli va zlashi zlekwer, mbaꞌa ghəshi nəwhwə. ");
INSERT INTO bcw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zhini sa dzay na kwa kwəma ɓa na, mbaꞌa kəsashi nihwəti mbəzli bakə, ngwarməmə ghəshi, kar Zhakə lə Zhaŋ, ndərazhi Zhebede. Gwanashi ghəshi tiɓa kwa kwambəwal lə dəshi gwaꞌa, ghəshi mbə gwəma zlekwer shi. Dzəghwa sa nashi Yesəw na, mbaꞌa harhwəshi. ");
INSERT INTO bcw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dza nzaꞌjəw, mbərəkə ghəshi zlata kwambəwal tiɓa, lə dəshi Zhebede gwaꞌa, mbaꞌa ghəshi nəwhwə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Dza Yesəw mbaꞌa kafəy təwramti təwrə mbə məlməhi tə hiɗi ka Galile gwanashi. Mbaꞌa ɓananavəshi shiy kaa mbəzli mbə *ciki ɓasəva tsa ka Zhəwifə. Ka gəzə Yəwən kwəma wəzə naa dzəkən njasa dza Hyalaa sləkə mbəzli. Mbaꞌa mbəlanti mbəzli gwərapə gwərapəshi ni, lə vədevəder shi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","War slən tsa ci məndiy gəzə gwaꞌa tə hiɗi ka Shiri ki. Ma sa favə məndi tsəgha na, dza məndi, ɓasə ɓasə məndi ɓasanakə mbəzli sanshi zəleghwer ghənghən ghənghən ngəraꞌwə gwanashi tsəgha ki, mbəzli ghəranshi gazlaka, ka bashakə, lə mbəzli məəti məəti vəgha ni. Dza na mbaꞌa mbəlantishi. ");
INSERT INTO bcw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma ghəci mbə dza dza ci va kiy, tərəŋw mbəzli səəkəshi ta nəw tə hiɗi ghənghən ghənghən. Ka tsahwə tə hiɗi Galile, lə səəkə tə hiɗi nə məndi, Hiɗi Məlməhi Məŋ, kə məndi, lə mbə məlmə Zherəwzalem, lə tə hiɗi ka Zhəwde, mbaꞌa mbəzli mbə məlməhi tə hiɗi pəriɓa pəriɓa taŋ həl Zhərdeŋ gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dzəghwa ki, sa nashi Yesəw mbəzli ɗaŋ ni va mbə səəkəə dzəvəgha tsəghay, dza na mbaꞌa dzəməy mə ghən kəlaŋ. Dza das nzəyəy, mbaꞌa mbəzli ta səɗa ci səəkəshiy dzəvəgha kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dzəghwa Yesəw mbaꞌa ghati ɓananshi kwəma ghənghən ghənghən kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","A kə Yesəw na: «Vəshi na ta mbəzliy sənay daw nza ghəy, a ghəy mawti Hyala mbə nəfə ghəy ta kəətiŋəy, kə ghəshi. Sa nzanay, ghəshi na shiy dzaa nzəy mbə mbəzli sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vəshi na ta mbəzliy wahə. Sa nzanay, ghəshi na shi dza Hyala ta dəpanatishi nefer shi. ");
INSERT INTO bcw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vəshi na ta mbəzli nza nefer shi wəzə. Sa nzanay, ghəshi na shi dza Hyala ta ɓanshi hiɗi, njasa niy gəzanakəshi na va. ");
INSERT INTO bcw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vəshi na ta mbəzliy pəla məni war kwəma ɗi Hyala lə nəfə tsa shi gwaꞌa gwaꞌa. Sa nzanay, ghəshi na shi dza Hyala ta kəəti lə məni kwəma ɗi ghəshi va. ");
INSERT INTO bcw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vəshi na ta mbəzli zhanshi hwər tsa shi ta nihwəti mbəzli. Sa nzanay, ghəshi na shi dza Hyala ta zhəhwər ti shi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vəshi na ta mbəzli nza nefer shi ɗewɗew kwa kwəma Hyala. Sa nzanay, ghəshi na shiy dzaa nata Hyala lə mətsə shi. ");
INSERT INTO bcw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vəshi na ta mbəzliy mbəə sləkati nihwəti mbəzli kwa jipə shi. Sa nzanay, ghəshi na shi dza Hyalaa har ka ndərazhi nzə. ");
INSERT INTO bcw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vəshi na ta mbəzli sanshi məndi ngəraꞌwə, war tə sa məni ghəshi kwəma ɗi Hyala. Sa nzanay, ghəshi na shiy dzaa nzəy mbə mbəzli sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ghwəyəy, vəshi na tə ghwəy, kama na, war ə məndiy tsətsəərəŋwəy, ka saŋwəy ngəraꞌwə, ka slasla dzərvəə dzəkən ghwəy tə gəm, sa nza ghwəy mbəzli ta səɗee. ");
INSERT INTO bcw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ghalaɓay, vəshi pə ghwəy taa vəshi tərəŋw. Sa nzanay, ta ngavəŋwəy zhəmə ghwəy dza Hyala mə ghwəmə. Ava war tsəgha niy sanshi ghəshi ngəraꞌwə kaa ka gəzə kwəma Hyalaa niy ꞌwaa səəkə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Dzəghwa ma kə Yesəw na: «Ghwəy ghwəy mbəzli ta səɗee ni kiy, nzəy tsa ghwəy mbə mbəzli tə hiɗiy, nja məzlir ta gwəma er na. Ma fəca ka ndezhekiy kərəy mbə məzlir kiy, njaa dza məndiy zhiniy zhanambə ndezhekə tsa va ghwəla kia? Ka gwəmati er niva məzlir ghwəla tepəw. War ka shəkati pəsər tsa va dzəy tə ngwəla gwaꞌa tsəgha na kwəma ci. Ma nza mbəzli dza dzar ti. ");
INSERT INTO bcw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nzəy tsa ghwəy mbə mbəzli tə hiɗi diɓay, njasa ka waŋ pi vaa nza na. Mbaꞌa kə məndi ngati məlmə dikə na mə ghən ɗal piy, ka mbay məndiy mbələy kala nata ndə ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Zhini diɓay, səəkə məndiy tsəraghwa ghwə kwa gərkəwa ta dzəɓakən tasaw kənəw. War pətsaa gwəramti ɗal ka məndiy pəla ta fə ti mbə ciki, ta mbə ghənzəə mbərə kaa mbəzli mbəɓa gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ava war tsəgha kə nzəy tsa ghwəy məniy, nja gərkəwaa məni waŋ pi va kaa mbəzli. Məni pə ghwəy məni na wəzə na kwəma ta mbə məndiy nata. Ma nza məndi fal slən tsa Dəŋwəy tsa mə ghwəmə tsəgha ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dzəghwa ma kə Yesəw diɓa na: «Nəghətaa ghwəy zəzəti ta sawavəri kwəma pəhəti Hyala lə kwemer gəzəkə ka gəzə kwəma Hyala səəkee, pə ghwəy ma. Əhəŋ, səəkəree ta sawa nzəw. Ma səəkə tsee tsay, war ta mbəə faghwa kwəma kwemer va kwa, lə ta pəraslikəvəriŋwəyshi səəkəree. ");
INSERT INTO bcw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Favəm ə gəzaŋwəy ya, ta na navay, tsəgha na, ya war hwəmɓa dza naa nza, paꞌ ghala ka ghwəmə nata ghwəy na, lə hiɗi nashi ghwəy ni kəɗishiy, shiy tiɓa ya ni jəw ni, mbaꞌa ghəshi dzaa tamtəvashi səvəri mbə kwəma pəhəti Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Va tsəgha nzana kiy, ma ntsaa ɗi ma fəti va ta kwəma va, ya naa gwəramti jəw na mbə, mbaꞌa ɓananavə kaa nihwəti mbəzli tsəgha a ghəshi ɗi ma fəti tiy, tsava ndə dza naa kəray tə shigə mbəzli sləkə Hyala. Ma ntsaa kəsəvə kwəma va va wəzə, ka ɗi fəti ti, dzəghwa tsəgha ɓananavə kaa nihwəti mbəzli a ghəshi ɗi fəti ta kwəma vay, ntsa dikə tsa mbə mbəzli sləkə Hyala dza tsava ndəə nza. ");
INSERT INTO bcw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ə gəzaŋwəy ya sana, mbaꞌa pə ghwəy ɗi dzəmbə mbəzli sləkə Hyalay, ɗi pə ghwəy ɗi fəti ta kwəma nzə. Tərəŋwɓa ghwəy kəə ɗi fəti kaa *ka ɓənipə kwəma, ghəshi lə *ka Farisahi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ma kə Yesəw diɓa na: «A ghwəy sənay, a *kwəma pəhəti Hyala kaa jijihimmə niy gəzəkə: “Ka pəəsli ndə gha ma! Ya wa ntsaa dzaa pəəsliti ndəy, ta har dza məndiy dzəti ngwəvə” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, ya war nəfəə ɓəti ndəə dzəkən zəmbəghəyəy, ta har dza məndiy dzəti ngwəvə ti. War mbaꞌa kə ndə ni kaa tsahwəti ndə: “Ma ghay, ndə mbə ghaw” kəy, ta dzəti ngwəvə dza tsava ndə kwa kwəma ka sləka mbəzli. Ma ntsaa ni kaa zəmbəghəy: “Hil tsa” kəy, dzəti ghwə Hyala kəɗi ma dza tsava ndə. ");
INSERT INTO bcw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mbaꞌa pə gha ɓəvə shiy ta dza ta vəlantashi kaa Hyala, dzəghwa mbaꞌa gha zəzəvə nahwəti kwəma mənti gha kaa tsahwəti zəməŋa tiɓay, ");
INSERT INTO bcw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ə pə gha zlashi shi tarəkə gha va ɓə kaa Hyala tiɓa kwa kwəma Hyala di. Mbala a ghwəy dzaa jakəŋwəy sləkamti kwəma kwa jipə ghwəy lə zəməŋa tsa va. Ma nza gha zhəghəvaa səəkə ta ɓanta shi gha va kaa Hyala ghalaɓa. ");
INSERT INTO bcw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","War mbaꞌa kə ntsa həərəva ghwəy liy harŋaa dzəti ngwəvəy, ditəvaŋa taŋtaŋ a ghwəy sləkamtim kwəma va li ghala ghwəy ghwəlaŋwəy kwa kwal ta tsəhə vəgha ndə sla ngwəvə. Kala tsəghay, ta pəmanaghəŋa dza na kaa ndə sla ngwəvə, ka ndə sla ngwəvə dza na, mbaꞌa pəmanaghəŋa kaa ka sawji, dzəghwa mbaꞌa ka sawji dzaa kalayŋa mbə ciki fərshina ki. ");
INSERT INTO bcw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","E gəzaŋee, ta na navay, tsəgha na, ghalaɓay ka dza məndiy pəlaŋa tepə, kala war sa ka gha wamti kwəma gwaꞌa gwaꞌa, njasa dza məndiy slavəŋaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Dzəghwa ma kə Yesəw diɓa na: «Zhini ɓay, a ghwəy favə njasa niy gəzəkə *kwəma pəhəti Hyala: “Əntaa gha məni ghwərghwər ma!” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, ya war kwataka lə mətsə nata ndə mali tsahwəti ndə, dza ka səkwa nzəghə ci tiy, a tsava ndə manamti ghwərghwər gwaꞌa tsəgha lə mali va mbə nəfə tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Va tsəgha nzana ki, war mbaꞌa kə nahwəti mətsə ghaa ngəɗiŋaa dzəmbə məni *kwəma jikir nay, lamti kwa ghən gha, a gha ndəghamti kərakə lə gha. Sa nzanay, wəzəɓa nza gha lə mətsə kwətiŋta na, kən na dza vəgha gha gwanataa ndita mbə ghwə. ");
INSERT INTO bcw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ya dəvə kwa bəzəmə gha fəŋa naa dzəmbə məni kwəma jikir nay, sla pə gha slanti, a gha ndəghamti kərakə. Sa nzanay, wəzəɓa nzəyŋa gha lə dəvə kwətiŋta na, kən dzəmbə ghwəə kəɗi ma lə vəgha gha gwanata» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ma kə Yesəw diɓa na: «Zhini ɓay, a *kwəma pəhəti Hyala gəzəkə: “Mbaꞌa kə ndə təhamti mali ciy, ə kə tsaslanavə zliyaa ɓanavə, ta mbəə cipə kwəma təhə tsa təhamti na va” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, ya wa ntsaa təhamti mali ci, kala mənti ghwərghwər ghənzəy, tsava ndə fambə na mali va mbə məni ghwərghwər, sa ka na dza mbaꞌa dzaa ɓəhwə tsahwəti zal. Dzəghwa ma zal tsaa dzaa ɓə mali təhəvərivay tsahwəti zal li kwərakwə ɓa na, aa mənti ghwərghwər» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Dzəghwa ma kə Yesəw diɓa na: «A ghwəy favə njasa gəzanakə *kwəma pəhəti Hyala kaa jijihimmə niy nza diɓa: “Mbaꞌa pə gha zəmanti fəla ta məni kwəmay, ka zhini miy gha ti ma. Mənti kwəma zəmanti gha va fəla ta məni nzə kwa kwəma Ndə sləkəpə” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, əntaa ghwəy zəmə fəla tepə ma. Ka zəmə fəla ghwəy, yən lə pətsa mə ghwəmə, pə ghwəy ma. Sa nzanay, ghwəmə va na gəzli nzəy Hyala mbə Mazə tsa nzə kwa. ");
INSERT INTO bcw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ka zəmə fəla ghwəy, ghəy lə hiɗi ni, pə ghwəy ma. Sa nzanay, hiɗi va na shi kəɗi Hyala səɗa nzə ti shi. Ka zəmə fəla ghwəy, ghəy lə məlmə Zherəwzalem, pə ghwəy ma. Sa nzanay, ghənzə na məlmə Hyala, mazə tsa dikə tsa. ");
INSERT INTO bcw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Əntaa ghwəy dzaa zəmə fəla tepə, ya ghəy lə ghən tsa ghəy, pə ghwəy ma. Sa nzanay, ka mbay ghwəy zhəghanti səti mbə ghən ghwəy payta, ya ngəritaw. ");
INSERT INTO bcw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","War ma kwəma ka ghwəy gəzəy: “Yi” ka ghwəy ni, kwəma kə tsəgha kataŋ. Kala tsəgha kə na: “Awə” pə ghwəy. Sa nzana, mbaꞌa pə gha mətsahakən zəmə fəlay, səəkə va *ndə jaka tsa Hyala səəkə nava kwəma tsəgha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Dzəghwa ma kə Yesəw diɓa na: «Zhini ɓay, a ghwəy favə njasaa niy gəzəkə *kwəma pəhəti Hyala: “Mbaꞌa kə ndə yahwamti mətsə ghay, yahwamti naci kwərakwə. Ɓəkwə kə ndə təɗamti slini ghay, dza ɓəkwə gha təɗamti na ci kwərakwə” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, mbaꞌa kə ndə məntəŋwəy *kwəma jikir nay, ka nə ghwəy war ghəy wati shi ghəy ti lə kwəma jikir na kwərakwə pə ghwəy ma. Mbaꞌa kə ndə sləvantəŋa vəgha ghən gha tar bəla kwa bəzəmə ghay, zhəghanavə na tarkə bəla tar kwa zleɓi, a ghəci zhiniy ləkantəŋa vəgha nava bəla diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mbaꞌa kə ndəə pəla kəsəŋaa dzəti ngwəvə sa ɗi na zləghwəhwə kwəbaŋ ɗaŋkəci tsa kən ghən ghay, zlatanavə kwal a ghəci ɓə ya lə ləkwəsa kən ghata gwaꞌa fəlghən. ");
INSERT INTO bcw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mbaꞌa kə ndə mbə mbəzliy sləkə hiɗi ni kaa ngəŋa, war gha ɓəghəra shi ya niy dzəti pi gar kiləwmetər kwətiŋ, kəy, ə pə gha zhiniy mətsəhə ɓanci shi gar kiləwmetər bakə. ");
INSERT INTO bcw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mbaꞌa kə ndəə ɗəw shiy va ghay, ɓə pə ghaa ɓanci shi. Mbaꞌa kə ndə səəkəy ta ɗəw təm va ghay, ka ini gha ti ma, ɓanavə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Dzəghwa ma kə Yesəw diɓa na: «A ghwəy favə njasa gəzəkə *kwəma pəhəti Hyala: “Ɗi pə ghaa ɗi tsa gha ndə, ka pa jaka lə ndə mbəz tsa gha” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma nə ya ngəŋwəy ta na tsee ghən nee kiy, ə pə ghwəy ɗi kwəma ka jaka ghwəy, ka cəꞌwə wəzə hwər tsa Hyala ta mbəzliy saŋwəy ngəraꞌwə. ");
INSERT INTO bcw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mbaꞌa pə ghwəy məni tsəghay, ndərazhi Dəŋwəy Hyala mə ghwəmə nza ghwəy. Sa nzanay, war yəmyəm ka naa kəɗi piy dzəkən ka ndərəm mbəzli, lə mbəzli wəzə hwər ni gwaꞌa. Ka nzəmə van dzəkən shi mbəzliy məni kwəma wəzə na, lə dzəkən ni mbəzliy məni *kwəma jikir na gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mbaꞌa pə ghwəy ɗi war mbəzliy ɗi kwəma ghwəy gwaꞌa tsəgha, kala ɗi ma nihwətiy, ka dza Hyalaa ngavəŋwəy zhəmə ghwəy ki na? Tiɓaw, ka ngavəŋwəyəw, ya mbəzli nja ka *dəwan, ghəshi ka zləghwəy, kar ghəshiy ɗi kwəma mbəzliy ɗi kwəma shi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mbaꞌa pə ghwəy səkwə war ngwardəhiŋwəy jaꞌ jaꞌ kiy, wa na nahwəti kwəma ghakə ghwəy mbə pərtaa? Sənay ghwəy, ya mbəzliy nəw ma Hyala na kar ghəshiy səkwə ngwardəshi kwərakwə, pə ghwəy sa? ");
INSERT INTO bcw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ava va tsəgha, ghwəy mbəzli ta səɗee ni kiy, a pə ghwəy məni kwəma wəzə na kaa mbəzli gwaꞌa, nza ghwəy nza ka mbəzli kama fəti tar kaɓaka shi ya jəw nzə, njasa nza Dəŋwəy Hyala va mə ghwəmə, kala kama fəti və» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Dzəghwa ma kə Yesəw diɓa na: «Mbaꞌa pə ghwəy ɗi ghərati sləni wəzə na kwa kwəma Hyalay, ka nə ghwəy, war mbəzli naŋwəy gwaꞌa gwaꞌa ta falŋwəy, pə ghwəy ma. War mbaꞌa pə ghwəy məni sləni ta falŋwəy mbəzliy, ka dza ghwəy kwəmavə zhəmə ghwəy va Dəŋwəy Hyala mə ghwəmə tsəgha teepəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mbaꞌa pə ghaa ɗi nga shiy kaa ndə cicikwə kiy, ka nə gha war gha zlaŋata kwəma ta nganci shi va, njasa ka mbəzliy dakə mbəzli va lə kwəma pərikə tə ngwəlaa məni, pə gha ma. Na nashiy, war kwa kwəma mbəzli kala zlaŋə kwəma dzar mbə *ciki ɓasəva tsa ka Zhəwifə, lə kwa kwal ka ghəshiy ɗi nga ni shi shiy kaa ka cicikwə, war ta mbə məndiy falshi. Ə gəzaŋwəy ya, ta na navay, tsəgha na, na nashiy, a ghəshi kwəmavə na shi zhəmə mbə fal tsa falshim va. ");
INSERT INTO bcw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na na gha, mbaꞌa pə ghaa ɗi nga shiy kaa ndə cicikwəy, tə mbə pə ghaa ɓancishi. Kala sənivə ndə ya madigaŋa tsaa gwəramti. ");
INSERT INTO bcw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mbaꞌa pə ghaa məni tsəghay, ta ngavəŋa zhəmə gha dza dəŋa tsaa nashi shi ka gha vaa məni tə mbə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ma kə Yesəw diɓa na: «Mbaꞌa pə ghwəy ɗi cəꞌwə Hyala diɓay, əntaa ghwəy məni nja mbəzliy dakə mbəzli va lə kwəma pərikə tə ngwəla ma. Na nashi mbaꞌa kə shiy ɗi cəꞌwəy, mbə *ciki ɓasəva tsa ka Zhəwifə ka ghəshiy garəshi lə tə pətsa jakəshi kweler, ta mbə mbəzli gwaꞌaa nashi, ka falshi. Ə gəzaŋwəy ya, ta na navay, tsəgha na, na nashiy, a ghəshi kwəmavə na shi zhəmə mbə fal tsa falshim va. ");
INSERT INTO bcw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na na gha mbaꞌa pə ghaa ɗi cəꞌwə Hyalay, dzəmbə ciki tsa gha pə gha dzaa dzəmbəŋa, dzəghwa disl gha kalakən ciki kən ghən gha. Ghalaɓa kiy nza gha cəꞌwə Dəŋa Hyala kwətiŋa, sa nzanay, mbəɓa na Hyala vəgha gha. Mbaꞌa pə ghaa məni tsəghay, Dəŋa tsaa nashi shi ka gha vaa məni tə mbə dza naa ngaŋa na gha zhəmə. ");
INSERT INTO bcw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mbaꞌa pə ghwəy cəꞌwə Hyalay, əntaa ghwəy dzaa nzati nza ndimndim ka ɓala kwəma ɗaŋaŋ, njasa ka ka ta mbəri vaa məni ma. Ma ka gəla niva mbəzliy bərkəti ta na nashiy, ta zləɓavə cəꞌwə ghəy va dza Hyala sa ka ghəy ɓalanakə kwəma ɗaŋaŋ, ka ghəshiy ni. ");
INSERT INTO bcw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Əntaa ghwəy məməni nja sa shi va na ghwəy ma. Sa nzanay, ghala ghwəy ghwəla ta gha cəꞌwəy, cəkeꞌ sənamti Dəŋwəy Hyala kwəmaa gagaŋwəy, ɗi ghwəy cəꞌwə ti gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mbaꞌa pə ghwəy ɗi cəꞌwə Hyalay, avanay njasa ka ghwəy cəꞌwə: “A Dəŋəy tsa mə ghwəmə, ə cəꞌwəŋa ghəy nza mbəzli mbəə sənay Hyala ɗewɗew na nza gha, kə ghəshi, ka fal slən tsa gha. ");
INSERT INTO bcw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mazə nza gha, səəkə sləkəŋəy. Njasa məniva kwəma ɗi gha va mə ghwəməy, tsəgha kəə məniva tikə tə hiɗi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɓəŋəy shi zəmə gar məkəŋəy ndatsə. ");
INSERT INTO bcw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pəlataŋəy kwəma ghəy jikir na mənti ghəy, njasa pəlanshi ghəy va na mbəzliy məniŋəy *kwəma jikir na kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndəghwətəŋəy vantaa ndə jaka dzaa həərətəŋəy ta məni kwəma jikir na, ɓəkəvəriŋəy mbə dəvə ci. Sa nzanay, gha na saa məni mazə, lə bərci, mbaꞌa shəndəkə, ya pa hwəmɓa nzə. *Amin” pə ghwəy ta ni. ");
INSERT INTO bcw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","A gəzaŋwəy yay, war mbaꞌa pə ghwəy mbə pəlanshi kwəma jikir na məniŋwəy nihwəti mbəzli mbə nəfə tsa ghwəyəy, war ta pəlataŋwəy na ghwəy dza Dəŋwəy tsa mə ghwəməə dza mbə nəfə tsa ci ghalaɓa kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kala pəlanshi kwəma məntəŋwəy mbəzli jikir na pə ghwəy mbə nefer ghwəy kwərakwəy, ka dza Dəŋwəy pəlataŋwəy na ghwəy kwəma jikir na mananci ghwəy kwərakwəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ma kə Yesəw diɓa na: «Mbaꞌa pə ghwəy mbə səwmay ta cəꞌwə Hyalay, əntaa ghwəy məniŋwəy war barcicəkwə, njasa ka mbəzliy dakə mbəzli va lə kwəma pərikə tə ngwəlaa məni ma. Ka ghəshiy dzay niꞌwə niꞌwə, ghəshi mənti pətsa mbə kwəma shi, ta mbə məndiy sənivəshi, ka mbəzli ka məni səwmay. Ə gəzaŋwəy ya, ta na navay, tsəgha na, ma gəla mbəzli vay, a ghəshi kwəmavə na shi va zhəmə pəla ghəshi tikəta gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na na gha mbaꞌa pə ghaa məni səwmayəy, pəshi pə gha pəshi pətsa mbə kwəma gha, dza mbaꞌa gha vərəti shəti mbə ghən tsa gha wəzə lə in, ");
INSERT INTO bcw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","əntaa məndi sənay mbə məni səwmay nza gha, kə məndi. War Dəŋa tsa mə ghwəmə saa dzaa sənay, ghəci saa nashi shi məni gha mbə mbə ni gwaꞌa, ghəci dza naa waŋa zhəmə gha ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma kə Yesəw kaa mbəzli ta səɗa ci na: «Ka kəslimbə ghən ghwəy mbə ghəra sləni ta ɓasə shiy tikə tə hiɗi ni, tə pətsa dza ləmaa nza gar ndəɓəhwəshi, ya limir na, gar yəɗamtishi, ya ka ghəli na, mbaꞌa ghəshi pəlaɗamti cikiy pahwəshi lə ghəli ma. ");
INSERT INTO bcw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wəzəɓa ta shiy gwəramti, ɓasəti Hyala mə ghwəmə, pə ghwəy ghəra sləni, tə pətsa dza limir mbay ma yəɗamtishi, kala ndəɓamtishi ya ləma nzə. Ya ka ghəli na, kala dza ghəshiy mbay pəlaɗamti cikiy ghələhwəshi. ");
INSERT INTO bcw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tawa gəzaŋwəy ya kwəma va tsəghay, sa nzana tə pətsa nza shi gha nza bama ti shiy, war tiɓa ka məhərli ghaa nza kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ma kə Yesəw diɓa na: «A ghwəy sənay, mətsəhi ghwəmmə na gərkəwa tə vəgha ghwəmmə. Mbaꞌa kə mətsəhi ghaa nay pi ɗiweŋ ɗiweŋəy, mbə waŋ pi dza vəgha ghaa nza gwanata ghalaɓa ki. ");
INSERT INTO bcw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mbaꞌa kə mətsəhi gha kala nay pi ɗiweŋ ɗiweŋəy, mbə kwəsli na vəgha gha. Tsəgha na diɓa, ma waŋ pətsa kataŋ tsa va Hyalay, sa mbə nəfə tsa ndə ngəri na. Mbaꞌa kə waŋ pətsa mbə gha va məniy zhəkwətəy, mbə kwəsli nza gha gwanaŋa ghalaɓa ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Zhini ma kə Yesəw diɓa na: «A ghwəy sənay, ndə tiɓa mbaꞌa dzaa mbay ghərati sləni kaa mbəzli bakə yəmyəməw. Baŋ dza naa ɗi kwəma tsahwəti, ka ndərə na tsahwəti. Ka na dza na, ka mananci sləni kaa tsahwəti lə kwal, ma kaa tsahwəti na, kala məni ma lə kwal. Ava tsəgha na kwərakwə ki, ka mbay ghwəy ghərati sləni bakə bakə, ka ghəra kaa Hyala, zhini mbaꞌa ghwəy ɓanavə məhərli ghwəy kaa gənaw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","A kə Yesəw diɓa na: «Ava va tsəgha nə ya ngəŋwəy kiy, ka kəslimbə ghən ghwəy mbə zəzə kwəmaa dzəkən shi zəməə dzəghwa hwər ghwəy, ya dzəkən shiy dzəkən ghən ghwəy ma. A piy tsa ndə taŋəti shi zəmə, a vəgha ndə taŋəti shi pa naa dzəkən ghən ci diɓa, pən. Tsəgha ghənzə sa? ");
INSERT INTO bcw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nighətim ya ꞌyegwer tə ghwəmə di. Ka za ghəshiw, ka məni shiy ghəshi səəkə kwamtiw, ka ɓasə shi zəmə ghəshi kwa taməw. Ya tsəgha nzə kiy, Dəŋwəy tsa mə ghwəmə zəmanshi na shiy. Njana nzana tsəgha kiy, a Hyala dzaa ɓəŋwəy shi zəmə, sa nzana diməɓa tə ghwəy kaa ꞌyegwer. ");
INSERT INTO bcw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mbaꞌa pə ghwəy kəslimbə ghən mbə zəzə kwəma tsəgha kiy, ka dza ghwəy mbay mətsahakən viciy dzəkən na slavəŋwəy Hyala ya jəw nzə na? Ka mbay ghwəy tepəw. ");
INSERT INTO bcw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A nava nə ghwəy kəslimbə ghwəy ghən mbə təkə kwəma shiy dzəkən ghən ghwəy gəma? Nighətim njasa ka fəhi kwamtiy mbərəti ghwə wəzə. Kar ghəshiy mənəhwə sləniw, ka cislivə kwəbeŋer ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ya tsəgha nzə, e gəzaŋwəyəy, ya ndə nja mazə *Saləmaŋw ghəci saa niy nza vaa ndə shiy na, səəkə naa pakən kwəbaŋ ka təɓə nja fəhiy mbərə ghwə va tə gambaw. ");
INSERT INTO bcw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A ghwəy sənay mbərə ghwə kiy, ka nzay nza naw. Ka ndə nata ndatsə na, kwəma gagaw, ma tə həzlimə na, ghənzə shəkəta, mbaꞌa ghwə dzaa ndamti. Kwa nzana tsəgha Hyalaa təɓəti shi ka mbərə ghwə wəzə kiy. Kala ghwəy ghənzə dzaa gwəraa pakənŋwəy niy gwəramti wəzə ni shiy, ghwəy mbəzli ki na. A gəzaŋwəy yay, ɓanavə nefer tsa ghwəy ghwəy kaa Hyala gwanashiw. ");
INSERT INTO bcw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ka təkə ghwəy, wa shi dza ghwəmməə zəməa? Wa shi dza ghwəmməə saa? Wa shi dza ghwəmməə paa dzəkən ghən ghwəmməa? pə ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ma mbəzliy tasəva lə pala niva shiyəy, mbəzliy nəw ma Hyala na ghəshi. Ma ghwəy ta na tsa ghwəy ghənəy, a Dəŋwəy tsa mə ghwəmə sənashi niy kama va ghwəy shiy gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wəzəɓa ɓanavə ghwəy nefer ghwəy kaa Hyala na, nza ghənzə sləkəŋwəy. Mənim naa təɓanta kwəma. Ma nza Hyala ndaŋwəy niva shiy gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ka tsə tsəva ghwəy mbə təkəə dzəkən vici həzlimə ma. A vici həzlimə va sənay tsəva ta tsa nzə ghən kwərakwə. Ya namaɓa vici gwaꞌay, war mək na ngəraꞌwə tsa sa na, ta tsa nzə ghən» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A kə Yesəw diɓa na: «Ka ndərə nihwəti mbəzli ghwəy ma. Mbaꞌa pə ghwəy ndərə nihwəti mbəzliy, a Hyala dzaa ndərəŋwəy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa nzanay, war njasa ndərə ghwəy va nihwəti mbəzliy, tsəgha dza Hyalaa ndərəŋwəy kwərakwə. Njasa ka ghwəy vaa mananshi kaa nihwəti mbəzliy, tsəgha dza Hyalaa bərkəti ta məniŋwəy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sa wana nighə gha kwasheɓi məzaɗi jəw ni tə mətsə zəməŋa, kala nighəvə tsəm tsa dikə tsa va gha tə na gha mətsəa? ");
INSERT INTO bcw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Njaa njaa gha mbay ni: “A zəmə, kadiw di e ɓantəŋa kwasheɓi məzaɗi jəw ni ni tə mətsə gha” pə gha, war zlaŋələy tsəm tə na gha mətsə kia? ");
INSERT INTO bcw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ma gha gha ntsaa ɓəti ghən tsa gha tsa ka ntsa slar tsay, a pə gha ɓanti pərɓa tsəm tsa dikə tsa va tə na gha va mətsə di na gha. Ma ghalaɓa kiy, nza gha mbay nay pi ɗiweŋ ɗiweŋ, ta ɓananti kwasheɓi məzaɗi tə na zəməŋa mətsə. ");
INSERT INTO bcw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ka ɓanshi shi wəzə ni ɗewɗew ni ghwəy kaa kireketi ma. Vantaa ghəshi dzaa zhiniy zhəghəkəvashi ta həciŋwəy. Ka ndəghənəy jaꞌwa mbəzə ghwəy ghwəy kaa ngəreder ma, vantaa ghəshi dzaa kaɗambə mbə hiɗi lə shiɗshiɗ shi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ma kə Yesəw diɓa na: «Cəꞌwəm shiy va Hyala, ta ndaŋwəyshi dza na. Pəlam shiy və, ta kwəmavəshi dza ghwəy. A pə ghwəy har, ta zləɓaŋwəy kwəma dza na. ");
INSERT INTO bcw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sa nzanay, ya wa ntsaa cəꞌwə shiyəy, ta ɓanavəshi dza məndi. Ya wa ntsaa pəla shiyəy, ta kwəmavəshi dza na. Ya wa ntsaa tsa yashiy dzakə ghiy, ta zləɓanci kwəma dza məndi. ");
INSERT INTO bcw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ndə tiɓa mbə ghwəy, ka ɗəw ɗafa zəghwə ci və na, dza tsaŋ, ɓəvə hakwə ka ɓanci na? ");
INSERT INTO bcw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa ka ɗəw kəlipə zəghwə ci və na, dza həŋ, ɓanavə shishi diɓa na? Tsava ndə tiɓaw. ");
INSERT INTO bcw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ma ghwəy ghwəy mbəzli gəmgəm ni, mbaꞌa ghwəy sənay ɓanshi shi wəzə ni kaa ndərazhi ghwəy na, hanaɓa Dəŋwəy Hyala mə ghwəmə ki, pə ghwəy, ka na mbay ma ɓanshi shiy gwəramti wəzə kaa mbəzliy cəꞌwə shəkəna? ");
INSERT INTO bcw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Njasa ɗi ghwəy va məndiy məniŋwəy kwəma wəzə nay, war tsəgha pə ghwəy mananshi kaa mbəzli kwərakwə. Ava ghənzə na na gəzəkə *kwəma pəhəti Hyala, lə kwəma gəzəkə Zliya ka gəzə kwəma Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ma kə Yesəw diɓa na: «Ghwəy ghwəy shiy nəw kwal tseyey, kwa na teꞌwə na miy dəgha pə ghwəy dzakə ghi. Ma miy dəgha bəŋw nay, bəŋw na kwal tsa nzə. Mbəzli ɗaŋ ka naa dza kwa kwal tsa va. Ma mbəzliy dza kwa kwal tsa vay, ta zashi dza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma na miy dəgha teꞌwə na vay, kwal tsa dza mbəzliy mbay dzəvəgha Hyala ta kwəmavə piy tsaa kəɗi ma ghəshi na. Ma kwal tsa teꞌwə tsa vay, ngahə ngahə na dza kwa. Ɗaŋ dza mbəzli kwa kwal tsa va kiw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zhini ma kə Yesəw diɓa na: «Ə pə ghwəy ya ghən tsa ghwəy va ka gəzə kwəma Hyala ka dzərvə. Sa ka ghəshiy səəkəshi dzəvəgha ghwəyəy, mbaꞌa ghəshi zhəghəti ghən tsa shi war nja teŋkesliy təvə ma kwəma. Mbalaa mbəɓa mbəɓa mbə nəfə tsa shi na, dəghwava jezl tsa ghyanakə tsa ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mbaꞌa kə ghəshi tsəhəshi vəgha ghwəyəy, gwaꞌa dza ghwəy mbay tihəvərishi tə sləni dza ghəshiy ghəra. A ghwəy sənay kiy, ka mbay mbəzakwaa yati hikəniw, ka mbay gwəviɗiy yati bəzakəw. Tsəgha na. ");
INSERT INTO bcw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma fə wəzə nay, ya fə wəzə na ka naa ya. Fə gəmgəm na na, ya gəmgəm na ka naa yati kwərakwə ɓa. ");
INSERT INTO bcw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na navay, a ghwəmmə sənay ka mbə dəŋw fə wəzə naa yati ya fə gəmgəm naw. Ka mbə tsa gəmgəm tsa dəŋw fəə yati ya wəzə na kwərakwə ɓaw, tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma fəə ya ma ya wəzə na va, ya nama fə na kiy, a ka məndiy kəslamti, mbaꞌam pəhamti ghwə ti. ");
INSERT INTO bcw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ava tsəgha pə ghwəy sənay tihəvəri ka gəzə kwəma Hyala, tə sləni ghəra ghəshi, ta sənay niy nza ghəshiy ka gəzə kwəma Hyala kataŋ ni, ya ka slasla dzərvə na ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ma kə Yesəw diɓa na: «A gəzaŋwəy ya, mbəzliy harɗa: “A Ndə sləkəŋəy, a Ndə sləkəŋəy” kə ghəshiy, gwanashi dza ghəshiy tsəhəshi mbə mbəzli sləkə Hyalaw, war mbəzliy dzaa mənti shi gəzəkə Dirə tsa mə ghwəmə na shiy dzaa tsəhəshi. ");
INSERT INTO bcw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Fəca vici dza Hyalaa ɓasə ngwəvəə dzəkən mbəzliy, ɗaŋ dza mbəzliy ni kaa ngəra, “A Ndə sləkəŋəy, a Ndə sləkəŋəy, ghəyəy tərəŋw gəzəhwə ghəy kwəma gəzaŋəy Hyala kaa mbəzli mbə slən tsa gha. A ghəy tatahamti hyeler mbə ghən tsa mbəzli mbə slən tsa gha. Zhəghwa ɗaŋ ghəy mənəhwə shi maɗaŋa maɗaŋa ni mbə slən tsa gha diɓa” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma dzee ni kaa mbəzli vay: “Sənaŋwəy yaw. Ghwəy ghwəy mbəzliy məni va war kwəma jikir jikir nay, satim, ɓarvaŋwəyəm vəghee” dzee ni ngəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ma kə Yesəw ki na: «A gəzaŋwəyee, ya wa ntsaa favə kwemer gəzəkee va, ka mənishi ghəci njasa favəshi na vay, yəmyəm na ntsa va lə ndə məhərli tsaa ngati ciki tsa ci tə kəlɓa. ");
INSERT INTO bcw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma sa ngamti na na, mbaꞌa van ghati nzəmə tərəŋw tərəŋw, dza paf həl təhəy va ghərakwəli, ka viy safə lə bərci ta ngəzlamti ciki tsa va na, shaŋ ghəci vəgha ngəzlamti, sa nzana tərəŋw səɗa ciki tsa va fəəta səəkə kwaɓa tə kəlɓa. ");
INSERT INTO bcw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ya wa ntsaa favə kwemer gəzəkee va, kala məni kwəma favə na mbə shi ghəciy, yəmyəm na tsava ndə lə ntsa kama məhərli və ngati ciki tsa ci vəgha həl dzəy tə ndarghə. ");
INSERT INTO bcw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma sa ngamti na na, mbaꞌa van ghati nzəmə tərəŋw tərəŋw, paf həl təhəy va ghərakwəli, ka viy safə lə bərci ta ngəzlamti ciki tsa va, dzəghwa nzaꞌjəw, gərip ciki tsa va ngəzlay gwanay ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ma sa kəɗiy Yesəw lə gəzə kwəma va kaa mbəzli na, mbaꞌa shi ɓənipə na va səəvəri məhərli mbəzliy ɓasəshi tə pətsa va, ");
INSERT INTO bcw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sa nzanay, niy mənta na ci va kwəma ɓənipə na, nja ɓəni kwəma *mbəzliy ɓənipə kwəma pəhəti Hyalaw, lə bama ti niy nza na ci va kwəma ɓəni na kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ma sa səkway Yesəw mə ghən kəlaŋ ki na, mbaꞌa mbəzli ɗaŋ nəwvə. ");
INSERT INTO bcw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dzəghwa tsahwəti ndə dərna mbaꞌa səəkəy dzəvəgha Yesəw, tsəfəkwə, tsəfəkwəy kwa kwəma ci. A kə ngəci na: «A Ndə sləkəpə, war mbaꞌa pə ghaa ɗi sənzənvay, a ghaa mbəlantəra ɗewɗew va dərna kənee na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ꞌWakəvə Yesəw tsəgha kaf kafəti dəvə ci, mbaꞌa dapay. A kə ngəci na: «E ɗi ghaa mbəliŋa, mbəliŋa kwəriŋ» kə. Nzaꞌjəw dərna va kərəta mbaꞌa mbəliy. ");
INSERT INTO bcw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A kə Yesəw ngəci sa mbəliy na ki na: «Favə tə gha kwəma dzee na ta gəzaŋa wəzə. Əntaa gha dzaa gəzə kwəma mbəli tsa mbəliŋa gha tsa kaa mbəzli ma. A pə ghaa maɗi a gha dzaa canati ghən tsa gha njasa mbəliŋa gha kaa ndə ta Hyala. Nza gha dzaa vəliti vəli gha, njasa gəzəkə *Məyizə va. Nza mbəzli mbəə sənay gwanashi a gha mbəliŋa va dərna tə gha, kə ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dza Yesəw ki, maɗ maɗiy, ka dzay dzəmbə məlmə Kapernahwəm. Ma sa tsəhəy na na, dza tsahwəti ndə məlmə, dikə tsa ka sawji ka Rəm bələkwə ghəci, kət kətikəvay, tapə ghəci ta cəꞌwə Yesəw, ");
INSERT INTO bcw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a kə na: «A Ndə sləkəpə, ndə ghəra sləni tsee gwərapəy. War məhəni ghəci kə ghi, məti məti vəgha ci kala mbay kafə. War ka sa ngəraꞌwə dalala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma kə Yesəw ngəci na: «Tsəgha na, ta dza dzee mbəlanti» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Ma kə dikə tsa ka sawji tsa va na: «A Ndə sləkəpə, yənəy, mənɗee ndə gar dzakə ghi tsee gha dəꞌwə ghən tsa ghaw. Avanay sanay, a mbəzli dikə dikə ni tiɓa kənee, ka sləkəra. Dzəghwa yən kwərakwə na, lə ka sawji sləkee tiɓa. Yən kəə ɗiy, e ni: “Mbalaa dzəti pətsa tsaꞌ tsa” pən kaa ndə sawji, ka dza ghəci. Aw na, “ndi” pən kaa tsahwəti, ka səəkə ghəci. E ni: “Məntəra sləni tsaꞌ na” pən kaa ndə ghəra sləni tsee, ka məni ghəci. Gha kwərakwə kiy, ntsa dikə tsa nza gha. A cəꞌwəŋee, gəzəkə kwəma kwataka lə miy tsa gha kwətiŋ, ta mbəliy dza ndə ghəra sləni tsee va va zəlghwə tsa ci, ka satiy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma sa favə Yesəw kwəma gəzəkə ntsa va na, tapə ghəci mbə vəshiy dzəkən ntsa va, a kə kaa mbəzli kwasəbə va na: «Ə gəzaŋwəyee, ta na navay, tsəgha na, ya mbə ghwəy ghwəy mbəzli ka *Izərayeləy, səəkee kəsay ntsaa ɓanavə nəfə tsa ci kaa Hyala gwanay nja ndə ka məlmə tsa tepəw. ");
INSERT INTO bcw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A gəzaŋwəy ya, ɗaŋ dza mbəzliy səsəəkəshi dzəghwa kwa ghwəmə, lə dzəghwa kwa mərkwi, ta nzəy ka zəmə shi zəmə ghəshi lə kar *Abəraham, lə *Izakə mbaꞌa *Zhakwapə tə pətsa sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma mbəzli nzə va niy tərati Hyala niy nza, ta nza ghəshi mbə mbəzli sləkə nay, sa ɗiti ma ghəshi fəti na, ka dza ghəshiy tsəhəshiw. Ta kihwashi dza naa dzəti ngwəla, dzəmbə kwəsli. Ma nza ghəshi wahə, ka pəpərə sliꞌi shi ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zhəghwa ma kə kaa dikə tsa ka sawji tsa va ki na: «Mbalaa jighi, ta məntəŋa shi gəzəkə gha va dzee, sa nzana mbaꞌa gha ndara nəfə tsa gha gwanay» kə. ꞌWakəvə ndə ghəra sləni tsa ndə ka sawji tsa va va, pəlis mbəliy ghalaɓa ki. ");
INSERT INTO bcw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dza Yesəw pəkw dzay dzakə ghi tsa Piyer. Ma dzakə na na, shiy Piyer məhəni, gwərapəta ghənzə tərəŋw dalala, nja ghwə vəgha nzə. ");
INSERT INTO bcw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ꞌWakəvə Yesəw sa nata na tsəgha na, dap dapəti tə dəvə nzə. Dzəghwa nzaꞌjəw rəniki vəgha mali va mənta ki. Dza na pəlhəm satita ka dza ta ɓanci shi zəmə. ");
INSERT INTO bcw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma sa pəkwəta vici ki na, mbaꞌa mbəzli ɓanakə mbəzli ghəranshi gezlekiki ɗaŋ, ta mbalamtishi ghəshi. Dza Yesəw mbaꞌa tahamti hyeler mbə vəgha shi lə gəzə kwəma mbə miy tsa ci, mbaꞌa mbalamti mbəzli va nihwəti zəleghwer ghənghən ghənghən gwaꞌa gwaꞌa ki. ");
INSERT INTO bcw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ma mənti Yesəw kwəma va tsəgha kiy, nza kwəma gəzəkə *Ezay ndə gəzə kwəma Hyala va niy nzaa dzəghwata kwa nə na. Saa ni va: «Mbaꞌa ɓəhwə ngirghwə tsa kən ghwəmmə, zhini mbaꞌa ɓəhwə zəlghwə tsa kən ghwəmməə dzəkən ghən ci» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dza Yesəw sa nashi na mbəzliy ɓasəshi va dalala, dəzlətsəɓə ghəshi tsəɓay na, mbaꞌa gəzanshi kaa mbəzli ta səɗa ci, a ghəshi taŋəghəvashi dzəvəri tə kwəfa, dzəti tsa pəriɓa həlbə. ");
INSERT INTO bcw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ꞌWakəvə ndə ɓənipə *kwəma pəhəti Hyala kət, kətikəvay dzəvəgha, a kə ngəci na: «A Metər, ta nəwŋa dzee, ya paꞌ kwəmaɓa dza ghaa dza» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma kə Yesəw na: «A pə gha zəzəvə kwəma wəzə di, a gha sənay, ma keŋkiɗiy, a ghi tsa shi və shi mbə hiɗi. ꞌYegwer ɓa na, lə tsa shi ghi ghəshi mə fə. Ma na nee yən Zəghwə yakə ndə ngəriy, tsee ghi tiɓa gar dəkətəvaree mbə kiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zhəghwa ma kə tsahwəti ndə mbə mbəzliy nəwvə va ngəci ɓa na: «A Ndə sləkəpə, ndara kwal e dzaa lamti dirə di, kee gha səəkə ta nəwŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dzəghwa, ma kə Yesəw ngəci na: «War nəw pə ghaa nəwra dzam. Zlashi mbəreketi tiɓa, a ghəshi lala ghən tsa shi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dza Yesəw mbaꞌa dzay dzəghwa kwambəwal ki, ghəshi lə mbəzli ta səɗa ci gwaꞌa, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nzaꞌjəw səpapəli ꞌyahəꞌyahə na ghati viy tərəŋw paꞌ ka di dzəghwa kwambəwal yam tərəŋw va bərci safə. Ma Yesəw ghalaɓa naci ki na, ghəci tə hi. ");
INSERT INTO bcw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dza mbəzli ta səɗa ci va, mbaꞌa ghəshi maɗishiy dzəvəgha, ka fərghə, ma kə ghəshi ngəci na: «A Ntsaa sləkəŋəy, a Ntsaa sləkəŋəy, wa mbəlitəŋəy, gwaꞌa ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nzaꞌjəw Yesəw fərghəy. Ma kə kaa ngəshi na: «Tawa hazləni ghwəy tsətsə nanzəa? Mbəzliy zləɓavə ma Hyala lə nəfə tsa shi gwanay nza ghwəy» kə. Dza na pəlhəm kafəy, dza naɓ naɓ naɓəti kar safə tsa va ghəshi lə kwəfa, vantaa ghəshi kwəfəghə ghwəla. Ɗekəɗekə pi məniy. ");
INSERT INTO bcw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma sa nashi mbəzli ta səɗa ci shi va na, mbaꞌa nava kwəma mananatishi maɗaŋa. Ma kə ghəshi na: «A ya, wa tsatsa ndə kia? Ya safə lə kwəfa na ka ɗanci fəti» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mbaꞌa Yesəw tsəhəy pəri həlbə, tə hiɗi ka Gadarene. Nzaꞌjəw ka gezlekiki bakə tsahwəshi dzar mbə kwəlihi tiɓa tsəgha, bam bam ghəshi kwəmay lə Yesəw. Ka gezlekiki ghyanakə ni, ka hazləni məndi və shi dalala. Kala mbə məndiy dzar kwa kwal tsa va və shi. ");
INSERT INTO bcw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","War sa nay ghəshi Yesəw tsəgha na, tapə ghəshi ta ngwəmə lala, a kə ghəshi na: «Gha gha Zəghwə Hyala tsa, ta njaa ɗi gha lə ghəya? Ə səəkəŋa gha ta saŋəy ngəraꞌwə ghwəla vici ɓasə ngwəvə ghəy səəkə na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma vəri, kərakə lə pətsa va na, mbaꞌa garəwa ngəreder tərəŋw niy nza tiɓa mbə pala shi zəmə shi. ");
INSERT INTO bcw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tapə hyeler mbə ghən mbəzli va va ta cəꞌwə Yesəw, a kə ghəshi na: «Mbaꞌa pə ghaa ɗi tahantəŋəy mbə ghən mbəzli niy, ndaŋəy kwal a ghəy dzəmbəŋəy mbə garəwa ngəreder pəriɓa va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma kə Yesəw ngəshi na: «Mbalam, cam, avee zlatavəŋwəy kwal» kə. Shaa, ghəshi səvərishi mbə ghən mbəzli bakə ni va, shəɓətə ghəshi dzashi gwanashiy dzəmbə ghən ngəreder va ki. Dzəghwa ki, gəgəgəgə, ngəreder va kafəshi səəkə mə kəlaŋ tsa va, səəkə ghəshi naꞌi shəkatəvashiy dzəti kwəfa. Bətə ghəshi zashi kwaɓa. ");
INSERT INTO bcw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma sa nashi ka makə ngəreder shi va tsəgha na, mbaꞌa ghəshi hwəshiy dzəmbə məlmə. Mbaꞌa ghəshi dzaa gəzanshi kaa mbəzli dzəkən shiy mənishi va gwanashi lə ngəreder, lə kwəma mananati Yesəw va kaa ka gezlekiki bakə ni va ki. ");
INSERT INTO bcw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma sa favə mbəzli mbə məlmə gwanashi na, mbaꞌa ghəshi kafəshi ta dza ta nighə Yesəw. Ma sa nay ghəshi, a kə ghəshi na: «A cəꞌwəŋa ghəy, ɓarvaŋa tə hiɗi ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dza Yesəw ki, ka dzay dzəghwa kwambəwal, mbaꞌa taŋəy səvəri tə kwəfa, ka zhəkəy dzəmbə məlmə ci. ");
INSERT INTO bcw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dzəghwa nihwəti mbəzli mbə məlmə ci va, mbaꞌa ghəshi ɓanakə ntsa məti məti vəgha tsa tə pi həni tsa ci kaa Yesəw. Ma sa sənay Yesəw, a mbəzli va ndara nefer shi gwanashi, kə, ma kə kaa ntsa mətita bəla vəgha ci va na: «A zəghwee, ka hazləni gha ma! A *kwəma gha jikir na pəlita!» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sa gəzəkə Yesəw tsəghay, ma kə nihwəti *ka ɓənipə kwəma pəhəti Hyala, mbə təkə kwəma shi na: «Hyalaa sawa ntsa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mbaꞌa Yesəw sənata kwəma təkə ghəshi va tsəgha na gwaꞌa. A kə ngəshi na: «Tawa nza ghwəy lə tətəkə kwemerəy kama ni wəzə ni mbə nefer ghwəy tsətsəa? ");
INSERT INTO bcw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nama kwəma gwəra na ɓəlaŋ, ndə kə ni: “A kwəma gha jikir na pəlita” kə, lə ndə kə ni kaa ndə zəlghwə: “Sati garəŋa a gha dzaŋa” kəa? ");
INSERT INTO bcw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma kiy, e ɗi ghwəy sənay, a bərci vəya yən Zəghwə yakə ndə ngəri tikə tə hiɗi ni, ta pəlanshi jikir tsa mbəzli, pə ghwəy» kə. Dza ma kə kaa ntsa mətita bəla vəgha ci va na: «A ntsa, avee gəzaŋa sənzənva, sati maɗi, ɓə pi həni tsa gha, mbalaa jighi!» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dzəghwa ntsa va mbaꞌa satiy, ka dzay jighi, sa mbəliy na kwəriŋ. ");
INSERT INTO bcw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma sa nay mbəzliy ɓasəshi tə pətsa va gəla nava kwəma tsəgha na, dzəghwa gwaꞌa gwaꞌa nefer shi hazlənishi va kwəma va. Kə ghəshi ka fal slən tsa Hyala sa ɓanavə na bərci kaa ndə ngəri ta mənti kwəma maɗaŋa maɗaŋa na va. ");
INSERT INTO bcw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dzəghwa Yesəw mbaꞌa ɓarvay tə tsava pi, ka dzay kwa kwəma. Ma ghəci mbə dza kwa kwal na, mbaꞌa nay ndə mənzəy mbə ciki *dəwan, Matiye, kə məndi slən tsa ci. Ma kə Yesəw ngəci na: «Sati, nəwra dzam!» kə. Mbaꞌa Matiye tsa va satiy ka nəw. ");
INSERT INTO bcw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma ləy hwəm shi va kiy, mbaꞌa kar Yesəw lə mbəzli ta səɗa ci ɓasəshi ta zəmə shi zəmə kəghi tsa Matiye. Dzəghwa ɗaŋ nihwəti ka dəwan lə nihwəti mbəzliy məni sləni jikir na səəkəshi, jakə ghəshi ka zəmə shiy lə kar Yesəw lə mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dza *ka Farisahi, mbaꞌa ghəshi nashi ghəshi mbə zəmə shi zəmə jakəjakə tsəgha. Ma sa nay ghəshi na, dza ghəshi ka ɗəw va *mbəzli ta səɗa Yesəw, a kə ghəshi na: «Wa shiy mənishi zəmə ntsa ghwəy tsa dikə tsa shi zəmə jakəjakə lə ka dəwan mbaꞌa mbəzliy məni sləni jikir naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dzəghwa mbaꞌa Yesəw favə kwəma shi va, ma kə kaa ngəshi na: «A mbəzli ni, səəkee nashi mbəzli kwəriŋ kwəriŋ vəgha ni mbə dza va dəkwətərəw, war ka zəlghwə na shi kee nashiy dza və. ");
INSERT INTO bcw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ava va tsəgha na kiy, yən na neyey, ta pəla mbəzli wəzə ni səəkə yaw, ta pəla mbəzliy məni sləni jikir na səəkəree. A pə ghwəy zəzətiy dzəkən kwəmaa niy gəzəkə Hyala va mbə Zliya nzə. Ma kə niy niy: “Zhəhwər na sa ɗee ghwəy məni kaa mbəzli, kaa na ka ghwəy slaslara dəbəkə” kə Hyala niy ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dzəghwa mbəzli ta səɗa Zhaŋ tsaa məni *batem kaa mbəzli, mbaꞌa ghəshi kətəghəvashiy dzəvəgha Yesəw ta ɗəw kwəma və, ma kə ghəshi ngəci na: «Ma ghəy lə mbəzli ka Farisahiy, kar ghəy titi nahwəti vici ta məni səwmay, ka cəꞌwə Hyala. Ma mbəzli ta səɗa gha ni na, kala məni ma ghəshi tsəgha kiy, a shiy mənishia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma kə Yesəw kaa ngəshi na: «A pə ghwəy favə kwəma dzee na ta gəzaŋwəy. Mbaꞌa kə ndə harvə mbəzli ta zəmə gəzləɓə mətəpa na ka dza mbəzli vaa nza tifəmmə ntsa va ghwəlay mbə shi di na? Ka mbə ghəshiy nzəyshi, tifəmməw. A tsahwəti vəghwə dzaa səəkəy, ma ghala pətsa dza məndiy ɓanti ndə mətəpa kwa jipə shiy, ava ghalaɓa dza ghəshiy məni səwmay ki» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dza Yesəw ka zhiniy gəzanshi kwəma kwa fir ɓa, ma kə na: «Ndə tiɓaa ɓəvə yar ꞌwarꞌwar ni ta mbəghəshiy dzəti kwəbaŋ tsaa haliyəw. Sa nzanay, tələsəꞌwə dza tsa yəwən tsa vaa mbahəhwə tsaa haliy va. Mbaꞌa kwal dzaa mətsəhəy dzəti. ");
INSERT INTO bcw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","A ghwəy sənay, ndə tiɓa ka ꞌyaghwa tay tsa njəmnjəm tsaa dzəghwa ghwəlpə hali hali naw. Ma sa dza tay tsa vaa maɗiy ta pəsliy, ta wənəhəta dza ghwəlpə vaa dza. Mbaꞌa tay dzaa shəkəy dzəti hiɗi gəm. Shi dza məndiy mənivə lə ghwəlpə va tiɓa ghwəla kiw. A ghwəy sənay wəzə, dzəghwa yəwən ghwəlpə ka məndiy ꞌyaghwa tay tsa njəmnjəm tsa. Ma tsəgha kiy, ka dza ghwəlpə vaa pəslita ta yiɗamti tayəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ma Yesəw mbə gəzə kwəma va kaa mbəzli va ki na, dzəghwa ndəs tsahwəti ntsa dikə tsa mbə mbəzli ka Zhəwifə səəkəy dzəvəgha. Dza na tsəfəkwə, tsəfəkwəy kwa kwəma ci. Ma kə ngəci na: «Kəətitəra, zhee mətita na sənzənva, səəkə a gha fanakən dəvə gha, a ghənzə zhakatita» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","«Əŋkwa» kə Yesəw. Mbaꞌa ghəshi maɗishi ghəshi lə mbəzli ta səɗa ci ka nəw. ");
INSERT INTO bcw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Dzəghwa, mbaꞌa nahwəti mali tiɓa, gwərapəta ghənzə. Piya nzə məŋ lə bakə war mbə səkwa miymiy kwa hwər nzə. Mbaꞌa təkəti tsəgha mbə ghən tsa nzə: «War mərshi mee kwəfaghay, ya kwataka tə kwəbaŋ tsa kən na, gwaꞌa, war ta mbəlira dzee» kə. Ma sa nza Yesəw mbə dza tsəgha na, dza na kət kətəghəvataa dzəvəgha, zhəkə ləy hwəm ci, kə dapə ghənzə dapay mətsəni kwəbaŋ tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ꞌWakəvə Yesəw tsəgha tərəɗ, zhəghətəvay njəꞌwə kə kaa pətsa lə hwəm ci na, mbaꞌa nata. Dza, ma kə ngəta na: «A zhee, ka dza her gha ma. A gha mbəliŋa tə sa ndara gha nəfə tsa gha» kə. Nzaꞌjəw miymiy mali va va slashi tiɓata. ");
INSERT INTO bcw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dzəghwa Yesəw ki, ndəs tsəhəy kəghi tsa ntsa dikə tsa va mbə ka Zhəwifə. Ma dzakə na na, mbaꞌa kəsashi mbəzli mbə tsa tsa shiy, ka hərsli wahə hərdzə nihwəti. ");
INSERT INTO bcw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma kə ngəshi na: «Ɓarəvaŋwəyəm tikə, ləvərim pəriɓa, mətita zha naw, hiy ɓəhwə na gwaꞌa tsəgha» kə. Ma sa favə mbəzli kwəma gəzəkə na va tsəgha na, njasa pəꞌwə na kwəma ci ghəshiy nighə. ");
INSERT INTO bcw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dza mbəzli mbaꞌa ghəshi səvərishi tə ngwəla tsəgha. Ma sa səvərishi məndi na, mbaꞌa Yesəw dzəmbəy mbə ciki tsa nza mbəri zha va mbə. Dza na tasl kəsəvə tə dəvə nzə, mbaꞌa zha va satita. ");
INSERT INTO bcw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dzəghwa nava kwəma ki mbaꞌa dzamtəvata paꞌ tə pətsa kəray ghala hiɗi va gwaꞌa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dza Yesəw ki mbaꞌa maɗiy tə tsava pi ta dzay. Ma ghəci kwa kwal mbə dza na, kə ghwəlefesli bakə ka nəw, ka zlaŋə kwəma, a kə ghəshi na: «A Yesəw, Jijiy mazə *Davitə, mənti zhəhwər tə ghəy» kə ghəshi. Ka nəw pəkw kəghi. ");
INSERT INTO bcw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma sa tsəhəy Yesəw kəghi na, mbaꞌa ghəshi kəsay, dza ghəshi kət ghəshi kətəghəvashiy dzəvəgha. A kə Yesəw ngəshi na: «A sənay ghwəy a bərci vəya gar mbəlitəŋwəy, pə ghwəy na?» kə. Ma kə ghəshi na: «Yə ntsa ghəy dikə tsa, a ghəy sənay, a gha taa mbay» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dzəghwa Yesəw dapə dapə dapəti mətsəhi shi. A kə na: «Sa nzana mbaꞌa ghwəy ndara nefer ghwəyəy, ta mbəlitəŋwəy dzee» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","War nzaꞌjəw tsəgha na, ɗiweŋ ɗiweŋ mətsəhi shi ghwənishi, ka nay pi ghəshi ki. Mbaꞌa Yesəw damətishi, a kə na: «Favəm wəzə, əntaa ghwəy dzaa gəzə shi məntəŋwəy ya ni kaa nihwəti mbəzli ma» kə. ");
INSERT INTO bcw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma sa dzashi ghəshi na, mbə ghəshiy zhiniy mbələy shi manamtishi Yesəw va ghwəlaw. Dza ghəshi ka gəzə nəwər tsa Yesəw dzar tə hiɗi va gwaꞌa gwaꞌa nashi. ");
INSERT INTO bcw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma sa dzashi mbəzli va na, mbaꞌa nihwəti mbəzli ɓəkə tsahwəti ndə kaa Yesəw. Kala mbay ma gəzə kwəma ghəci, sa pəhanti *hil ghani ci. ");
INSERT INTO bcw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dzəghwa Yesəw ki mbaꞌa tihəkəvəri hil tsa va mbə ntsa va. Nzaꞌjəw ntsa va ghati gəzə kwəma. Ma mbəzli ɗaŋ ni va ɓasəshi tə pətsa vay. Ka mananshi maɗaŋa nava kwəma ki. A kə ghəshi na: «A nana kwəma kia! Kay, səəkə ndəə nashi gəla ni tsətsə ni ni shiy mənishi mbə ka *Izərayel ghala nza məndi teepəw!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma kə *ka Farisahi na: «Waa, mazə tsa mbə hyeler ɓanci na bərci titihə na va nihwəti hyeler səvəri mbə ghən mbəzli li shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Dza Yesəw mbaꞌa kafəy ka təwrə dzar mbə məlməhi dikə dikə ni lə ni jəw jəw ni gwaꞌa gwaꞌa. Ka ɓananshi shiy kaa mbəzli mbə *ciki ɓasəva tsa ka Zhəwifə. Ka gəzə Yəwən kwəma wəzə naa dzəkən njasa dza Hyalaa sləkə mbəzli. Mbaꞌa mbəlanti mbəzli gwərapə gwərapəshi ni lə vədevəer gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sa nə na, nighə kə kaa mbəzli ɓasə ɓasə ni va tə pətsa va ɗaŋ ni na, tapə hwər tsa ci ta zhanci ta mbəzli va ki. Sa nzana mbaꞌa mbəzli va niy dalishi gwaꞌa gwaꞌa, mbaꞌa hazləni kəəsəvəshi nja teŋkesli kama ntsaa ndəghwəshi tiɓa. ");
INSERT INTO bcw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma kə kwa fir kaa mbəzli ta səɗa ci na: «A mbəzlee, ɗaŋ shi zəmə nakamtəvashi kwamti ngar na, daw mbəzli ta ɓasəshi səəkə tə vəhəə jighi. ");
INSERT INTO bcw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ghənzə tsəghay, cəꞌwə pə ghwəy cəꞌwə ndə za tsa va, a ghəci mətsəhə ghwəni nihwəti mbəzli dzəmti, ta mananci shi ci vaa səəkə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ma tə nahwəti viciy, mbaꞌa Yesəw harvə mbəzli ta səɗa ci va məŋ lə bakə ni. Dza na mbaꞌa ɓanavəshi bərci ta tihə hyeler səvəri mbə ghən mbəzli, lə ta mbəli mbəzli va nihwəti zəleghwer, lə ta mbəli vədevəder gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Avanashi sləneɗemer *ka kwal Yesəw va məŋ lə bakə ni: Kwataŋay, Shimaŋw, ntsa nə məndi Piyer, kə məndi slən tsa ci, ghəshi lə Andəre, zəmbəghəy. Kar Zhakə ghəshi lə zəmbəghəy Zhaŋ, ndərazhi Zhebede ghəshi bakanashi. ");
INSERT INTO bcw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mbaꞌa kar Fəlipə lə Bartelemi, Təmasə lə Matiye ndə *dəwan. Zhakə zəghwə Alfe, lə Tade, ");
INSERT INTO bcw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mbaꞌa Shimaŋw ndə pərslə ta hiɗi shi, ghəshi lə Zhəwdasə Isəkariyətə, ntsaa ngati ɗafa ta Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dzəghwa Yesəw mbaꞌa ghwənashi ka kwal ci va məŋ lə bakə ni, ta dza va mbəzli ki. Ma kə kaa ngəshi ghəshi dzaa maɗi na: «Əntaa ghwəy dzaa dzəti hiɗi *mbəzliy kamaa ka Zhəwifə ma. Əntaa ghwəy dzaa dzəmbə məlməhi tə hiɗi mbəzli ka *Samari ɓa ma. ");
INSERT INTO bcw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mbalam va ka *Izərayel, nja teŋkesliy zashi na ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gazanshim kwa kwal ghwəy mbə dza: “Ndəkwə ndəkwə na Hyala ta səəkə ta sləkə mbəzli” pə ghwəy ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbəlim ka zəlghwə, zhinim mbəzliy bəkwəshi sati mbə məti, mbəlim mbəzli nza dərna ti shi, ka titihə hyeler səvəri mbə ghən mbəzli. War njasa kwəmavə ghwəy va bərci mbəli mbəzli tə gəməy, tsəgha pə ghwəy kəəti mbəzli, əntaa ghwəy ɗəw shiy ma. ");
INSERT INTO bcw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma ghwəy maɗi ta dza vay, əntaa ghwəy ɓə ya tsahi mbəzə, ya gəna nzə, ta faghwa kwa zlipa ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Əntaa ghwəy ɓə mbəl tsa ka ghwəy dza ta wə li ma, əntaa ghwəy ɓə za kwəbeŋer bakə, ya kwakwahə tsa ghwəy, ya gəta ghwəy nzə ta dəvə ma. Va sa nzanay, mbaꞌa kə ndəə ghəra sləni na, a təɓə məndiy nganci shi zəmə mbə sləni ghəra na va. ");
INSERT INTO bcw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mbalam, ma sa ka ghwəy tsəhəŋwəy mbə məlmə dikə na, ya mbə na jəw nay, pəlam ghi tsa ntsaa dzaa zləɓavə kaꞌwəŋwəy bekir dəvə kəghi tsa ci. Mbaꞌa ghwəy nzəyŋwəy kəyɓa, paꞌ fəca ka ghwəy kafəŋwəy ta dzaŋwəy. ");
INSERT INTO bcw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ghala pətsa ka ghwəy dzakə ghi tsa dzakə ghwəy gwaꞌay, gəzə tə ghwəy kaa mbəzli kəyɓa: “Zərkə kə məndi kəghi tsa!” pə ghwəy taa ni. ");
INSERT INTO bcw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","War mbaꞌa kə mbəzli kə ghi tsa va va zləɓavə yashi tsa ghwəy va lə vəshiy, ka nza yashi tsa ghwəy va gəməy ti shiw. Ma kala zləɓati kə ghəshi na, ka dza zərkə tsa gəzanshi ghwəy vaa nza kən shi ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mbaꞌa pə ghwəy dzaŋwəy dzəmbə məlmə, kala zləɓa kaꞌwəŋwəy məndi, kala fa ma kwəma gəzə ghwəyəy, səvəriŋwəyəm mbə nava məlmə, ka dzaŋwəy, mbaꞌa ghwəy batamti kwərbi tə shiɗshiɗ ghwəy. Ma tsəgha kiy, a mbəzli mbə məlmə va dzaa sənata, njasa mənti ghəshi *kwəma jikir na kaa ngəŋwəy. ");
INSERT INTO bcw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A gəzaŋwəy ya, ta na navay, tsəgha na, fəca vici dza Hyalaa ɓasə ngwəvəə dzəkən mbəzliy, tərəŋwɓa ngwəvə kən mbəzliy zləɓa ma kwəma ghwəy va dza naa nza, kən na mbəzli jikir jikir ni va mbə məlməhi *Sədəm lə *Gwəmər» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Zhini ma kə Yesəw kaa mbəzli ta səɗa ci ɓa na: «Favə tə ghwəy, ava ghwəniy ghwəniŋwəy ya ta dzaa dzəmbə mbəzli ghyanakə ni, nja teŋkesli ka ndə vaa kambə mbə jipəjipə dəghwava jezlhi. Ma kiy, ka mbəzli tsəhwəli tsəhwəli ni pə ghwəy məniŋwəy, nja shishi, kala pəla ma kwəma tə mbəzli, njasa ka ghərpəpə vaa nza. ");
INSERT INTO bcw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ndəghwəm ghən tsa ghwəy wəzə, sa nzanay, ta kəkəsəŋwəy dza məndiy dzaa dzəti pi ngwəvə. Ka didiꞌwəŋwəy taa nza lə kwərpə mbə *ciki ɓasəva tsa ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta kəkəsəŋwəy dza məndiy dzaa dzəghwa kwəma mbəzli dikə dikə ni, ghəshi lə mezhizhə gwaꞌa sa zləɓavə ghwəy kwəmee. Ghalaɓa kiy ta ndəgha fəti dza ghwəy dzaa dzəkənee kwa kwəma shi lə kwa kwəma *mbəzliy kamaa ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ghala pətsa dza məndiy kasatəŋwəy tə ngwəvə va kiy, əntaa ghwəy dzaa tsətsəva, ka təkə na: “Njaa dza ghəy ni kaa kwəma ka ghəy gəzə kia?” pə ghwəy ma. Ma fəcavay ta səəkəta dza kwəma dza ghwəy gəzanshiy dzəghwa miy tsa ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Səəkə mbə zəzə kwəma ghwəy dza naa səəkəw. Safə tsa Dəŋwəy dza naa gəzə kwəma va mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ghala vəghwə tsa vay, ka nihwəti mbəzli dza na, ka nga ɗafa ta ngwarmbəghəshi ta mbə məndiy bəkwəshi. Zhini tsəgha didihi dzaa məni lə ndərazhi shi kwərakwə ɓa. Ka ndərazhi dza na, ka zhini ghən kaa mbəzliy yakəshi diɓa ki, ka ɓəshi kaa nihwəti mbəzli ta bəkwəshi. ");
INSERT INTO bcw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mbəzli gwanashiy ka dza ghəshiy ɗi mətsə ghwəy, tə sa nəwra ghwəyəw. Ma ntsaa dzaa jihəkəvay kala zlay nəwra ghəci paꞌ tə vici məti ciy, ta mbəliti tsava ndə dza Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mbaꞌa kə məndi ghati saŋwəy ngəraꞌwə mbə nahwəti məlməy, hwəŋwəyəm səvəri mbə nava məlməə dzəmbə nahwəti. A gəzaŋwəy ya, ta na navay, tsəgha na, ka dza ghwəy hati nəw məlməhi tə hiɗi ka *Izərayel gwanashi, dza ghwəy nayma, ndəs yən səəkəra, yən Zəghwə yakə ndə ngəriw. ");
INSERT INTO bcw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A ghwəy sənay kiy, ka mbə ndə ɓəni shiy taŋəti ntsaa ɓananci shiy tə sənashi shiyəw. Ka mbə ndə ghəra sləniy taŋəti ntsa ghəranci na sləni tə dikəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ə ka ntsa ɓananci məndi shiy zləɓavə səꞌwa kwəma, ma nza ghəci nza nja ntsaa ɓananci shiy. Tsəgha ndə ghəra sləni zləɓavə səꞌwa kwəma, nza ghəci nza nja ntsa ghəranci na va sləni ɓa. Əhətim, yən ndə ghi sana kiy, a məndi fatəra slən tsa mazə hyeler, Belzhebəl, kə məndi. Tsəgha kə kiy, kala tərəŋwɓa ghwəy ghwəy mbəzli kəghi tsee məndi dzaa tsəərə shəkəna?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ma kə Yesəw diɓa na: «A gəzaŋwəy ya, əntaa ghwəy hazləni va mbəzli ma. Ya wa kwəma mbəmbə na gwaꞌay, ta dzəti ngwəla dza na. Ya wa kwəma dza məndiy ghələhwə gəzə nzəy, ta sənata dza məndi. ");
INSERT INTO bcw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma kwəma ghəlavəŋwəy ya gəzə nzə mbə kwəsliy, cikəvərim kwəma va tə ngwəla havəghwə kaa mbəzli gwaꞌa. Ya ɗahwə ɗahwə gəzaŋwəy ya kwəma mbaꞌa ghwəy favəy, garəŋwəyəm mə ɗal pi, a ghwəy zlapə gəzə kwəma va nza mbəzli mbəə favə. ");
INSERT INTO bcw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka hazləni ghwəy va mbəzliy dzaa mbay pəəsliti vəgha ghwəy ma, ma na nashiy, ka mbə ghəshiy pəəsliti piy tsa ndəw. Hazlənim va Hyala ghənzə sa dzaa mbay pəəsliti vəgha ndə, ka zamti lə piy tsa ndəta gwaꞌa, ka ndəghambə mbə ghwə. ");
INSERT INTO bcw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A ghwəy sənay, a ndə mbəə pavə ꞌyegwer tiytiyhi bakə tə dala kwətiŋ, va jəw jəw tsa shi ɓay. Ma ya tsəgha ghəshi jəw jəwəy, ka tərəy dzəti hiɗi ya kwətiŋ kala zləɓavə dəŋwəy Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma ghwəy kwərakwə kiy, ya shəti mbə ghən ghwəy gwanashi na, mbəra mbəra na ghəshi, kwətiŋ kwətiŋ tsa shi gwaꞌa va Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Njana nzana tsəgha kiy, ka hazləni ghwəy teepə ma. A ghwəy nay, ya njaa na ꞌyegwer ɗaŋ tsa shiy, ka zamti ghən Hyala ti shi ya kwətiŋəw, hanaɓa ghwəy, ghwəy ke ngəri ki ka na zəzə maa dzəkən ghwəy na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ma kə Yesəw diɓa na: «A gəzaŋwəy yay, ya wa ntsaa dzaa ni “Ndə nəw Yesəw nzee nee” kə, kwa kwəma mbəzliy, yən kwərakwə na, ta gəzə dzee kwa kwəma Dirə mə ghwəmə: “Tsee ndə na tsatsa” pən. ");
INSERT INTO bcw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ntsaa dza vaa ni: “Sənay ndee Yesəw neyew” kə kwa kwəma mbəzliy, ava tsəgha dzee ni: “Sənay tsava ndə yaw” pən, ta nza kwa kwəma Dirə mə ghwəmə kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma kə Yesəw na: «Ma bərkə ghwəy səəkə tsee tsaa dzəti hiɗi na, zərkəə ɓəkee nə ghwəy na? Am awə, səəkəree ta nza zərkə kwa jipə mbəzliw. War pa jaka na sa ɓəkee dzəghwa jipə mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A səəkəree ta həərəvəri kar zəghwə ghəshi lə dəy, ta həərəvəri zha ghəshi lə mbəghəta, ta həərəvəri makwa ghəshi lə shəta kəghi. ");
INSERT INTO bcw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A gəzaŋwəy ya, ma ntsaa nəw kwal tsa yay, ka jaka ci dza mbəzli kəghi tsa ciy nza. ");
INSERT INTO bcw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ma ntsaa ɗiti ɗiɓa dəy lə mbəghəy kaa ngəray, məniy na gar nəwraw. Ya ntsaa ɗiti ɗiɓa ndərazhi ci kaa ngəray, məniy na gar nəwraw. ");
INSERT INTO bcw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kala kafəy kə ndə ta nəwra mbaꞌa zləɓavə lə mətitay, ka nza na ka ntseyew. ");
INSERT INTO bcw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A gəzaŋwəy ya, ma ntsaa ɗi mbəliti piy tsa ci tikə tə hiɗiy, ta zamti piy tsa ci dza na va Hyala. Ma ntsaa zamti piy tsa ci ta nəwray, ta kwəmavə piy tsa ci dza na va Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Zhini ma kə Yesəw ɓa na: «Ma ntsaa kaꞌwətəŋwəy lə nəfə kwətiŋəy, yən na sa kaꞌwəti na va. Ntsaa kaꞌwətəra va ɓa na, Dirə tsaa ghwənara va na sa kaꞌwəti na kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ntsaa kaꞌwəti *ndə gəzə kwəma Hyala lə nəfə kwətiŋ, sa nza ntsa kaꞌwəti na va ka ndə gəzə kwəma Hyalay, ta kwəmavə zhəmə dza na, nja ndə gəzə kwəma Hyala tsa va kwərakwə. Ntsaa kaꞌwəti ntsa slar tsa kwa kwəma Hyala lə nəfə kwətiŋ, sa nzanaa ntsa slar tsa va Hyalay, ta kwəmavə zhəmə dza na nja ntsa slar tsa va kaꞌwəti na kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya wa ntsaa tivə yam sa rəniki niy ɓanavəshi kaa ntsa kwa tsa ci kwal tsa mbə mbəzli ta səɗee, sa nza ntsa tanavə na va yam ka ntsa ta səɗee kəy, a gəzaŋwəy ya ta na navay, tsəgha na, ta kwəmavə zhəmə ci dza ntsa va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dzəghwa Yesəw mbaꞌa kəramti ɓananshi shiy kaa mbəzli ta səɗa ci va məŋ lə bakə ni ki. Ma sa kəɗamtishi na na, mbaꞌa kafəy tə tsava pi, ka dzay ta ɓananshi shiy lə ta gəzə kwəma Hyala kaa mbəzli dzar mbə məlməhi tə hiɗi va. ");
INSERT INTO bcw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma ghala pətsa va na, Zhaŋ tsaa mənipə batem kəli kəli kwa fərshina. Dza na mbaꞌa favə gaka sləni ghəra *Kəristəw ki. ꞌWakəvə na, ɓəŋ ghwənashi nihwəti mbəzli mbə mbəzli ta səɗa ci va Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A kə ngəshi na: «Mbalam ɗəwtəram kwəma va ntsa va, ma pə ghwəy ngəciy: “Waa gha na ntsa ndəghə ghəy va dzaa səəkə ta naa? Naa a ghəy ndəghə tsahwəti ndə na? kə Zhaŋ” pə ghwəy ngəci» kə. ");
INSERT INTO bcw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mbaꞌa mbəzli va dzaa ɗəwti kwəma va va Yesəw tsəgha. Ma kə Yesəw kaa zləɓanshi na: «Mbalam, a ghwəy gəzanci kwəma favə ghwəy sana, lə shi nashi ghwəy lə mətsəhi ghwəy gwaꞌa kaa Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","A ghwəy nay, a mətsəhi ghwəlefesli ghwənishi, mbə nay pi ghəshi, vədevəder na, ka dza, mbaꞌa ka dərna mbəlishi. Dza mbaꞌa slimim mədeŋesli ghwənishi, mbə favə kwəma ghəshi. Mbəzliy niy bəkwəshi na, ka zhakatishi mbə məti, zhini mbaꞌa Yəwən kwəma wəzə na tsəhəta kwa slimim mbəzli ka cicikwə. ");
INSERT INTO bcw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vəshi na ta ntsaa zhəghavəra ma hwəm, sa səəkəra mee dzəghwa ma ci» kə kaa ngəshi. Dzəghwa mbəzli ghwənikə Zhaŋ va ki, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ma sa dzashi ghəshi ki na, tapə Yesəw mbə gəzə kwəma Zhaŋ kaa ləkw ndə ngəri tsaa ɓasəy va tiɓa ki, a kə na: «Sa dzaŋwəy ghwəy vaa dzəti gamba ta nighə Zhaŋəy, a ntsaa niy dza ghwəy ta nighə tay? Ta nighə dzəvəti kwəfəghə safə niy dza ghwəy nanzə ɓa na? ");
INSERT INTO bcw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wa na ntsaa dza ghwəy va ta nighə kia? A ghəy dzaa nay ndə lə kwəbeŋerəy gwəramti wəzə kən ghən ci, niy nə ghwəy nanzə ɓa na? Ta na mbəzliy dza lə kwəbeŋerəy gwəramtiy, war dzar kəy mezhizhə ka gəla niva mbəzliy nzəy nzəy tsa shi. ");
INSERT INTO bcw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Əy, war wa na ntsaa dza ghwəy va ta nighə kia? A ghəy dzaa nighəti *ndə gəzə kwəma Hyala niy nə ghwəy nanzə ɓay? Yaŋ tsəgha na, ndə gəzə kwəma Hyala na Zhaŋ kataŋ. Ghəciy, aa taŋəti nihwəti ka gəzə kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa nzanay, Zhaŋ na ntsaa niy dza vaa ꞌwara kwal, saa niy tsasliti məndi va kwəmaa dzəkən kwa Zliya Hyala. Ma kə Hyala kaa kwəma gəzəkə naa dzəkənəy: Avee taa ghwənəghə ndə kwal tsee, a ghəci ꞌwatəŋa kwal, nza ghəci gwəmantəŋa kwal tsa dza ghaa dza kwa, kə. ");
INSERT INTO bcw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ndə tiɓa tə hiɗi mbə mbəzli yakəghwa məndi kwa hwər baw, ka yəməva lə Zhaŋ ndə məni batem tsa vaw. Ya tsəgha nzə kiy, ya wa ntsa gəməy tsa zləɓavə kwəmee ta sləkə yay, dikəɓa ghəci na kaa Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sa ghava na tə vəghwə tsaa gha Zhaŋ gəzəpə kwəma Hyala paꞌ tə vəghwə tsa ndatsə tsay, lə bərci mbə tərəŋw gəzəva kwəma sləkə tsa dza Hyala ta sləkə mbəzli. Dzəghwa tərəŋw mbəzli jahambəvashi lə bərci mbə pəla kwal, ta nza mbə mbəzli dza Hyala vaa sləkə. ");
INSERT INTO bcw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ka gəzə kwəma Hyala gwanashi, lə zliya *kwəma pəhəti Hyala gwaꞌay, a ghəshi gəzəkə kwəmaa dzəkən sləkə tsa dza Hyala vaa sləkə mbəzli, paꞌ tə vəghwə tsa tsahwə Zhaŋ ti. ");
INSERT INTO bcw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E mbay gəzə sana, ghwəy gar dzaa zləɓa kwəma yay, Zhaŋ tsay, ghəci na *Eli tsaa niy gəzəkə məndi va mbə Zliya Hyala, ta zhəkə dza na, kə məndi, pən. ");
INSERT INTO bcw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Fə tə ghwəy ghən ta kwəma gəzaŋwəy ya na wəzə. Niy nza məhərliy fə ghən ta kwəma va ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ə gəzaŋwəy yay, mbəzli mbə vəghwə tsa ndatsə tsay yəmyəm na ghəshi lə ndərazhiy ɓasətəvashi va tə bəghə ta tsaɓana, dzəghwa ka ꞌwaŋanshi ꞌwaŋə nihwəti kaa nihwəti, ma kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tawa məni ghwəy tsəgha shəka? Mbaꞌa ghwəmmə ɓasəmmə ta tsə, tapə ghəy ta viyŋwəy sherey a ghwəy tsə pə ghəy na, a tsə ghwəyəw. Ənkwa pə ghəy, zhini ka ꞌwaŋwəy cəm civə ghəy na, a zləɓa ghwəyəw!” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tsəgha nza ghwəy nja ndərazhi va. Ndəs səəkəy Zhaŋ, dzəghwa na mbə nzəy tsa ciy, kala zəmə shi wəzə ni, kala sa ma tay ghəci. Dzəghwa ma pə ghwəy na: “A, waa ndə gazlaka na tsatsa ndə” pə ghwəy, kala zləɓa kwəma ci ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma sa səəkəree yən Zəghwə yakə ndə ngəri nee ki na, dzee ka zəmə shi zəmə, ka sa tay. Zhini ma pə ghwəy ɓa na: “Wəyəw, ndə hwər na tsatsa ndə. War shi zəmə lə tay na na ci kwəma sənata na gwaꞌa tsəgha. Ka kəsə madigaa dzəti ka *dəwan, lə dzar tə ka badaway gəmgəm ni” pə ghwəy. Kala zləɓa ma kwəmee ghwəy ɓa. Əy ma ki ya tsəgha nzəy, war mbə civa na sənata kwəma Hyala səvəri mbə sləni ghəra ghəy lə Zhaŋ» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dzəghwa Yesəw tapə ta naɓə mbəzli mbə məlməhi gwəra naa mənəhwə sləni maɗaŋa maɗaŋa na mbə shi, sa nzana, kala ɗi zhəghanti nzəy tsa shi mbəzli dzar mbə məlməhi va kwa kwəma Hyala, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ghwəy ghwəy mbəzli mbə məlmə Kwəraziŋ, lə ghwəy ghwəy mbəzli mbə məlmə Betəsayda, a ngəraꞌwə taa nza kən ghwəy. Sa nzana, mbə məlmə Tir lə mbə məlmə Shidaŋw pən niy mənəhwə shi maɗaŋa maɗaŋa ni ni mənəhwee mbə ghwəy nzay, ci mbəzli mbəɓa tsəfəkwəshi, ka tsati titihwə, ka zhəghanti nzəy tsa shi kwa kwəma Hyala va kwəma shi jikir na nza. ");
INSERT INTO bcw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Va tsəgha nə ya sanay: Fəca vici dza Hyalaa ɓasə ngwəvəə dzəkən mbəzli na, tərəŋwɓa na ghwəy ngwəvə dza naa nza kən na mbəzli mbə məlmə Tir lə mbəzli mbə məlmə Shidaŋw, pən. ");
INSERT INTO bcw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ghwəy ghwəy mbəzli mbə məlmə Kapernahwəm kiy, mbəzli dza məndiy kafashi dzəta ghwəmə nza ghəy na ghəy ki, nə ghwəy na. Nava tiɓa teepəw. Ta dzəghwa dza ghwəy paꞌ tə pətsa nza mbəreketi. Sa nzana, war mbə mbəzli mbə məlmə *Sədəm pən niy mənəhwə kwəma maɗaŋa mənəhwee na mbə ghwəy nzay, ci mbəzli va zhəghanti nzəy tsa shi kwa kwəma Hyala nza. Ka dza Hyalaa ndamti məlmə shi va nzaw, ci ghənzə ghwəlata paꞌ ndatsə nza. ");
INSERT INTO bcw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Va tsəgha nə yaa ni sana ngəŋwəyəy: Ma fəca dza vici ɓasə ngwəvə kəɗi tsa hiɗiy mənivay, tərəŋwɓa na ghwəy ngwəvə dza naa nza kaa na mbəzli mbə məlmə Sədəm pən» kə. ");
INSERT INTO bcw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Zhəghwa tapə Yesəw ta zhiniy gəzə kwəma diɓa, a kə na: «A Dirə tsaa sləkə ghwəmə lə hiɗi, ꞌwəsa nə ya ngəŋa. Sa nzana, ma kwəmaa niy mbələy gha va mbəzliy sənata kwəma, ghəshi lə ka məhərliy, a gha canakəvərishi kaa mbəzli daw daw ni tə sənata kwəma. ");
INSERT INTO bcw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A Di, a falŋee, sa nzana tsəgha gha ɗi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma kə Yesəw kaa mbəzli ki na: «Mbə dəvee fambə Dirə shiy gwanashi. Ndə tiɓa mbaꞌa sənara kala war Dirəw. Ndə tiɓa mbaꞌa sənay Dirə, kala war yən yən Zəghwə ci, mbaꞌa ntsa nə ya, e ɗi canati Dirə pənəw. ");
INSERT INTO bcw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Səəkəm dzəvəghee gwanaŋwəy, ghwəy mbəzliy daliŋwəy ni va shi shəndəkə ni, e ɓaɓantəŋwəyshi, nza ghwəy dəkəva vəghee. ");
INSERT INTO bcw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Zləɓavəram, e nza ka Ndə sləkəŋwəy, nzee ɓəniŋwəy ni ya shiy. Sa nzanay, ntsa kwəɗ nəfə tsa nzee, ka kəli ghən tsee yaw. Mbaꞌa pə ghwəy səəkəŋwəy dzəvəgha yay, ta kwəmavə dəkəva dza ghwəy ta ghən tsa ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa dza naa nza, kwəma dzee gəzaŋwəy məni nzəy, kwəma ɓəlaŋ dza naa nza va ghwəy. Ma nə ya shi dzee ɓəniŋwəy na, ka dza ghəshiy taŋətəŋwəy bərciw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma tə nahwəti vici ləy hwəm kwəma va, geꞌi lə *vici dəkəva ka Zhəwifə na, mbaꞌa kar Yesəw maɗishi lə *mbəzli ta səɗa ci. Dza ghəshi ka taŋə dzar mbə vəh alkamari. Ka ghəranshi ma kaa mbəzli ta səɗa Yesəw. Dzəghwa tapə ghəshi dzəmbəshi mbə slərɓə alkamari va tsəgha, ka mbəliy dzəghwa miy shi, ka pərə. ");
INSERT INTO bcw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mbaꞌa *ka Farisahi nashi. Ma kə ghəshi Kaa Yesəw ki na: «A nava dzəmbəshi mbəzli ta səɗa gha ni, mbə məni shi makəmmə *kwəma pəhəti Hyala va mənishi fəca vici dəkəva kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma kə Yesəw ngəshi na: «Waa səəkə ghwəy jangəhwə kwəmaa niy mənti kar *Davitə va ghəshi lə mbəzli kwasəbə kwa Zliya Hyala bay sa? Tə nahwəti vici sa niy ghəratishi may, ");
INSERT INTO bcw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","təhwə, niy dzəmbəy naa dzəmbə *ciki Hyala, dza na, həŋ ɓəvə peŋ tsa ka məndiy ta Hyala li, mbaꞌa ghəshi zəməhwə lə mbəzliy niy nza kwasəbə. Ya tsəgha niy ɓanavəshi ma kwəma pəhəti Hyala kwal kaa kar Davitə lə mbəzli kwasəbə va ta zəmə peŋ tsa va, war kwataka *ka ta Hyala shiy niy nza kwal və shi ta zəməy, niy naɓəti Davitə Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naa kala səəkə ghwəy jangəhwə nahwəti kwəma mbə zliya kwəma pəhəti Hyalaa dzəkən gəla kwəma va diɓa na? Ya *ka ta Hyalay, mbə ghəra sləni mbə ciki Hyala ka ghəshiy nza, ya fəca vici dəkəva. Nəwti kwəma pəhəti Hyala dzar kwa vici dəkəva ghəshi tsəgha kiw. Ya tsəgha nzə ɓa na, ka ɓanshi fəti Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","E gəzaŋwəy sana, yən tsa nay ghwəy tsay, e taŋamti ciki Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Fəti ghən ghwəy ta kwəma nə Hyala vaa ni: Həhəəni shiy ta taray, ka təɓara niva shiyəw. Məni zhəhwər ta nihwəti mbəzli na kwəma ɗee, kəw. War mbaꞌa pə ghwəy fəti ghən ti nzay, ka dza ghwəy ɓə fəti kaa mbəzli kama fəti və shi tsətsə nzaw. ");
INSERT INTO bcw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sənay tə ghwəy kiy, yən sləkə na vici dəkəva, yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Dza Yesəw mbaꞌa maɗiy tə pətsa va, ka dzay dzəmbə *ciki ɓasəva tsa ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma sa dzəmbəy na na, mbaꞌa kəsay tsahwəti ndə mbəɓa, məti məti dəvə ci. ꞌWakəvə *ka Farisahi va, tapə ta ɗəw kwəma va Yesəw, sa ɗi ghəshi ngali kwəmaa dzəkən ta mbə ghəshiy ɓanci fəti. Ma kə ghəshi ngəci na: «Ndammə kwal tsaa mbəli ndə *kwəma pəhəti Hyala fəca vici dəkəva ta naa, naa njaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma kə Yesəw ngəshi na: «Mbaꞌa kə təmbəkə va ndə mbə ghwəy kwətiŋəy, dza təmbəkə tsa ci va mbaꞌa tərəy dzəghwa kəꞌwə fəca vici dəkəva na, ka dza ntsa vaa dza ta ɓəə səəmə sa? ");
INSERT INTO bcw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hanaɓa ndə ngəri ki ka məndi zlay nə ghwəy, mbaꞌa ghwəy sənay, diməɓa tə ndə ngəri na tərəŋw kən saa dza səɗa, pə ghwəy shəkəna. Ta na kwəma pəhəti Hyalay, ka damə ndə na ta məni wəzə fəca vici dəkəvaw?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma kə Yesəw kaa ntsa məti məti dəvə tsa va tsəgha ki na: «A ntsa, təɗi dəvə gha va!» kə. Dzəghwa ntsa va, mbaꞌa təɗiti sa ci, kwəriŋ dəvə ci va mbəlita tsəgha, njasa nza nahwəti dəvə ci. ");
INSERT INTO bcw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma sa nata ka Farisahi nava kwəma na, mbaꞌa ghəshi səvərishiy ɓasəti ghən tsa shi, ka sləka kwəma kwa jipə shi, njasa dza ghəshiy mbay pəəsliti Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma ləy hwəm jəw ki na, mbaꞌa Yesəw zləwaŋəvə kwəma sləkahwə ghəshi vaa dzəkən. Sa zləwaŋəvə na na, dza na kaf kafəy tə tsava pi, ka dzay. Dza mbəzli tərəŋw, mbaꞌa ghəshi kafəshi tə səəbə ci, ka nəw. Dzəghwa na mbaꞌa mbalamti ni gwərapə gwərapəshi ni mbəzli mbə shi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sa mbəlantishi na, ma kə kaa ngəshi na: «Ka gəzə kwəma kənee ghwəy ma. Əntaa mbəzli dzaa sənara» kə. ");
INSERT INTO bcw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ma mənishi shi va tsəghay, ta mbə kwəmaa niy gəzəkə *Ezay ndə gəzə kwəma Hyala va niy nzaa dzəghwata kwa. Ma kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","A kə Hyalay: «Avanay tsee ndə ghəraɗa sləni tsa tivee. Tsee ntsa ɗee, ka vəshee ti tərəŋw. Ta fanambə Safə tsee dzee mbə nəfə tsa ci, ma nza ghəci canshi njasa dzee sla ngwəvə lə kwal tsa nzə kaa hwəlfə mbəzli tə hiɗi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka dza naa ya miy ghəshi lə ndəw, ka dza naa ngwəmə lalaw, ka dza naa gəzə kwemer dzar kwa kwaləw, ");
INSERT INTO bcw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ka dza naa kərnamti ɓəli dzəvətiy gwərshitaw, ka dza naa kərni shirkwamti ghwəə ɗi mətita kwa gərkəwaw. War tsəgha dza naa məni paꞌ tə vici dza məndiy gha sənay, lə kwal tsa nzə na kwəmaa niy məni na va, kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dzəghwa ya namaɓa hwəlfə mbəzli tə hiɗi gwaꞌa taa nza ki na, war ta kwəma ci ghəshi dzaa fə ghən» kə Hyala, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dzəghwa məndi ki mbaꞌam pəmanakə tsahwəti ndə kaa Yesəw tiɓa: Ghwəlfə ghəci, zhini ɓa na, kala mbə ghəciy gəzə kwəma, sa niy mananci *hil. Dzəghwa Yesəw kaa ntsa va, kwəriŋ mbəlanti, ka gəzə kwəma ghəci, ka nighə pi wəzə. ");
INSERT INTO bcw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ꞌWakəvə nava maɗaŋa kwəma, mbaꞌa səəvəri məhərli ləkw ndə ngəri tsaa ɓasəy va tə pətsa va tsəgha ki. Dzəghwa ma kə ghəshi na: «Aya, jijiy mazə *Davitə tsa va na sasa bərkee?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma kə *ka Farisahi nashi ki sa favə ghəshi gəzə kwəma va na: «A mbəzli ni, ma ntsa nay ghwəy tsay, Belzhebəl, mazə tsa mbə hyeler ɓanci na bərci va ta tihə nihwəti hyeler səvəri mbə ghən mbəzli li shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma na Yesəw naci ki na, gwaꞌa gwaꞌa ghəci sənata kwəma mbə ghən shi. Dzəghwa ma kə kaa ngəshi na: «A mbəzli ni, tawa zəzə ghwəy gəla kwəma tsəgha na tay? A ghwəy sənay mbaꞌa kə mbəzli dikə dikə ni zəmə hiɗi dzəmbəshi mbə pa jaka kwa jipə tsa shiy, ta zamti ghən tsa shi dza ghəshi. Mbaꞌa kə mbəzli mbə məlmə kwətiŋ na, ya mbəzli kəghi tsa kwətiŋ tsaa pa jaka kwa jipə tsa shiy, ta ndanivərivashi dza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mbaꞌa kə *ndə jaka tsa Hyala zhiniy dzəmbəy mbə ɓanci bərci kaa ndə, ta tihə nihwəti mbəzli ci hyeler sana kiy, jaka ghəci pa lə ghən tsa ci tsəgha ɓasa. Ta ndanivərivay dza mazə tsa ci va ghalaɓa ki. ");
INSERT INTO bcw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mbaꞌa pən tihə hyeler lə bərci ndara Belzhebəl kiy, ya nihwəti mbəzli ghwəy va tihə hyeler va na, wa ntsaa ɓanshi ni shi va bərci kia? Sləni ghəra mbəzli ghwəy vay, ti ghwəy sənata a fəti va ghwəy pə ghwəy, mbə kwəma gəzəkə ghwəy na. ");
INSERT INTO bcw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma na nee na kataŋ nay, lə bərci *Safə tsa Hyala ɗewɗew tsa tihee hyeler səvəri mbə mbəzli. Ma ɗi kwəma nata ghwəy na ciŋwəyəy, waa na Hyala ghati sləkəŋwəy, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ya dzakə ghi tsa ndə bərci kiy, ndə tiɓa mbaꞌa dzaa dzakəy ta pa shi ci ɓəlaŋəw. War ndə pəhati na ndə bərci tsa va tə zəꞌwə kwataŋata, dza ndəə mbay pa shi kəghi tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","A na neyey, ma ntsaa ni, ghwəm na lə gha na yaw kəy, ndə mbəz tsee na tsava ndə. Ntsaa kəətira ma mbə sləni yay, slənee vaa liɗi na. ");
INSERT INTO bcw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ava va tsəgha nə ya kaa ngəŋwəy, ya namaɓa hwəlfə *kwəma jikir naa mənti ndə ngəri, ya njaa tsəərəti na Hyalay, a Hyala dzaa pəlata kwəma ci va jikir na gwaꞌa mbə nəfə tsa nzə. Ma na ntsaa gəzakən kwəma sawaa dzəkən Safə tsa Hyala ɗewɗew tsay, ka pəlata kwəma tsava ndə jikir na Hyala mbə nəfə tsa nzə tepəw! ");
INSERT INTO bcw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mbaꞌa kə ndə gəzakən kwəma hwəvə hwəvə naa dzəkənee, yən Zəghwə yakə ndə ngəriy, ta pəlay dza Hyala mbə nəfə tsa nzə. War dza ndə mbaꞌa gəzakən kwəma hwəvə hwəvə naa dzəkən Safə tsa Hyala ɗewɗew tsa kiy, ka dza Hyalaa pəlay jikir tsa tsava ndə mbə nəfə tsa nzə ya paꞌ hwəmɓaw, ya sənzənva, ya ka na nza ghwəla naci kiw!» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ma kə Yesəw kaa nahwəti kwəma kwa fir ɓa na: «Mbaꞌa kə ndəə ɗi ngəlivə ya fə wəzə nay, dəŋw fə wəzə na dza ndəə ngwəɓəti kwərakwə. Mbaꞌa kə ndə ngwəɓəti dəŋw fə gəmgəm nay, ya fə gəmgəm na dza ndəə ngəli kwərakwə. Sa nzanay, tə ya nzə ka məndiy sənata dəŋw fə wəzə na. ");
INSERT INTO bcw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ghwəy ghwəy *ka Farisahiy, nja kwara jigəzlihi ndərəm ghwəy. Va tsəgha mbay ma ghwəy gəzə na wəzə na kwəma səvəri mbə miy tsa ghwəy. Sa nzanay, war kwəma təkəti ndə mbə nəfə tsa ci na sa ka miy tsa ciy gəzəə səvəri. ");
INSERT INTO bcw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma ntsa wəzə tsay, shi mbə nəfə tsa ci va wəzə tsa ka naa gəzəə səvəri. Ma tsa gəmgəm tsa ndə na, shi mbə nəfə tsa ci va gəmgəm ni ghəciy gəzəə səvəri kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Fəca vici dza Hyalaa ɓasə ngwəvəə dzəkən mbəzli, e gəzaŋwəyəy, ta ɗəw kwəma dza naa dza va mbəzli gwanashiy dzəkən kwemerəy niy gəgəzəhwə ghəshi gəmgəm ni ghalaa nza ghəshi tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","War geꞌi geꞌi lə kwəma gəzəhwə gha dza Hyalaa slaŋa ngwəvə gha. Ta gəzaŋa dza na nda fəti va gha, nda kala fəti va gha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dza nihwəti *ka ɓənipə kwəma pəhəti Hyala, ghəshi lə nihwəti ka Farisahi, tapə ta ɗəw kwəma va Yesəw, a kə ghəshi na: «A Metər, a ghəy ɗi ghaa mənti shi maɗaŋa maɗaŋa ni kwətiŋ kwa kwəma ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A kə Yesəw ki na: «Ma ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsay, mbəzli jikirkir ni nza ghwəy, ka ɗi fəti ghwəy va Hyalaw. “Mənti shi maɗaŋa maɗaŋa ni” pə ghwəy kaa ngəra. Na nee nee kiy, nihwəti shi maɗaŋa maɗaŋa ni dzee məntəŋwəy tiɓaw. Mək na shi maɗaŋa maɗaŋa ni va niy mənəhwə Hyala, lə *Zhəwnasə ndə gəzə kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa nzanay, war njasa niy mənti Zhəwnasə va vici mahkan, lə vərɗi mahkan kwa hwər tsa kəlipə dikə nay, war tsəgha dzee mənəhwə vici lə vərɗi yən Zəghwə yakə ndə ngəri kwa kwəli kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A gəzaŋwəy yay, fəca vici dza Hyalaa məni ngwəvəə dzəkən mbəzliy, ta səəkə dza mbəzli mbə məlmə ka *Ninivə dzəti ngwəvə ghəshi lə mbəzli mbə vəghwə tsa ndatsə tsa. Ta kəsəyshi dza ghəshi tə ngwəvə. Ghəshi na nashi sa niy favə ghəshi gəzə kwəma Hyalaa dzəkən jikir tsa shi va Zhəwnasəy, a ghəshi niy tsati titihwə kaa Hyala, ka zhəghanti nzəy tsa shi. Dzəghwa ghwəy na ghwəy kiy, kala ɗi fa kwəmee ghwəy. Yən sa dikə tsa kən Zhəwnasə ngar ki. ");
INSERT INTO bcw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Zhini ɓay, ta səəkə dza mazə maliy niy səəkəta va tə hiɗi ka Sabaa dzəti ngwəvə, ghəshi lə mbəzli mbə vəghwə tsa ndatsə tsa. Ta kəsəyshi dza na tə ngwəvə sa nzana, mbaꞌa niy səəkəta tə hiɗiy gwəramti kərakə, war ta favə kwəma gəzə mazə *Saləmaŋw, sa nzana tərəŋw ghəci sənata kwəma. Dzəghwa ghwəy na ghwəy ki na, kala ɗi zləɓa kwəmee ghwəy. Yən sa dikə tsa kən Saləmaŋw ngar ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ma kə Yesəw ɓa na: «Mbaꞌa kə gazlaka niy nza mbə ghən ndə, dza mbaꞌa səvəritay, a ka naa dza dza, ka təwrə dzar mbə gamba ta pala pətsa dza naa mbay dəkətəvata ti. Ma sa ka na dza kala kwəmavə pi ghənzəy ");
INSERT INTO bcw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka na dza na: “Ma ghənzə tsəgha kiy, wəzəɓa zharee naa zhəmbə ciki tsee va səvəriɗee mbə” kə dzaa ni. Ma sa ka na zhəghəkəvataa zhəmbə na, mbaꞌa kəsay ciki tsa va gwəma gwəma wəzə, papa ɗewɗew, kala ndə mbə. ");
INSERT INTO bcw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sa ka gazlaka va nay pətsa mbəɓa tsəgha kiy, mbaꞌa dzaa hakakə nihwəti gezlekikiy taŋəti tə məni ndərəm, mbərfəŋ, ta nzəy mbə ciki tsa va kwasəbə. Sa ka ghəshi səəkə ki na shirɓitə dzashiy dzəmbə ntsa va gwanashi. Dzəghwa tərəŋw gazlaka dzaa mətsəhəta va ntsa va, taŋ na kwataŋa va. Ava war tsəgha dza kwəma kən ghwəy nza ghwəy mbəzli ndatsə ni jikirkir kwəma ni kwərakwə ki» kə. ");
INSERT INTO bcw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ma Yesəw mbə gəzə kwəma kaa ləkw ndə ngəri tsaa ɓasəy tə pətsa va ki na, mbaꞌa kar mbəghəy ghəshi lə ngwarməhiy səəkəshiy garəshi tə ngwəla. Ka ɗi gəzanci kwəma ghəshi kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma sa nashi məndi na, mbaꞌa tsahwəti ndə dzaa gəzanci kaa Yesəw, ma kə na: «A Metər, ava kar məŋa, lə ngwarməhiŋa pəriɓa tə ngwəla mbə ɗəwŋa, ta gəzaŋa kwəma» kə. ");
INSERT INTO bcw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dzəghwa ma kə Yesəw kaa zləɓanci na: «Kadiw e citəŋa nee mərə, lə ngwarməhira» kə. ");
INSERT INTO bcw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dzəghwa na ci cati dəvə tə *mbəzli ta səɗa ci. A kə na: «Avanashi mbəzli niy, ghəshi na nee mərə, lə ni ya ngwarməhira. ");
INSERT INTO bcw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sa nzanay: Ya wa ntsaa məni kwəma ɗi Dirə tsa mə ghwəməy, ghəci na tsee zəmərə lə nee zhamərə, lə mərə, gwaꞌa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma fəcava ki na, mbaꞌa Yesəw səvəriy kəghi, mbaꞌa dzaa nzəyəy miy kwəfa kwa həl Galile. ");
INSERT INTO bcw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dza mbəzli mbaꞌa ghəshi ɓasəkəvashiy dzəvəgha dalala. Ma sa nashi na mbəzli ɗaŋshi tsəgha na, dza na mbaꞌa dzay dzəghwa kwambəwal nzəyəy. Dzəghwa mbəzliy ɓasəshi va, mbaꞌa ghəshi gagarəshi miy kwəfa va ki. ");
INSERT INTO bcw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dza na ka gazanshi kwemer ghənghən ghənghən kaa mbəzli dzar kwa fir kwa fir, ma kə na: «Tə nahwəti viciy, mbaꞌa tsahwəti ndə za niy maɗiy ta dza ta sləka ha ci. ");
INSERT INTO bcw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma ghəci mbə kihwə ha va ki na, dzəghwa pəriŋ, nahwəti ha pəpəriŋətaa dzəghwa kwal. Dza ꞌyegwer mbaꞌa ghəshi səəkəə iməhwə nava. ");
INSERT INTO bcw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dza nahwəti mbaꞌa pəpəriŋətaa dzəti kwərhə, war ghwəla na, nzaꞌjəw ghənzə pəsəta, sa nzana, kala hiɗi kən ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma war sa satita vici ka ndipə na, nzaꞌjəw ha va ghwəlita ki. Sa kama hiɗi kən ɗaŋ gar tsəhəvə hililiŋə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dza nahwəti diɓa mbaꞌa pəpəriŋəta dzəghwa mbə tekesli. Ma sa pəsəta na na, mbaꞌa tekesli kəlishiy dzəkən. Kala bərci və gar kəli ghwəla. ");
INSERT INTO bcw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma dzəghwa nahwəti nanzə ki na, mbaꞌa məta tə hiɗi wəzə ni, dza na mbaꞌa pəsəta, ka kəlita wəzə. Sa maɗi na ta fə ghən na, dikə dikə nahwəti fəti, ɓahwə ɓahwə nahwəti, nahwəti ɓa na geꞌi geꞌi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zhini ma kə ɓa na: «Ma ntsa nza sləmə vəy, fə tə ghəci ghən ta kwəma va wəzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dzəghwa *mbəzli ta səɗa Yesəw mbaꞌa ghəshi kətəghəvashiy dzəvəgha, tapə ghəshi ta ɗəw kwəma və, a kə ghəshi na: «A nava nzana war kwa fir kwa fir ghaa ɗi gəzanshi kwəmaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma kə Yesəw ngəshi na: «Na na ghwəyəy, a Hyala ndaŋwəy məhərli ta sənay njasa dza naa sləkə mbəzli nzə. Ma na mbəzli kiy, kwəmavə kwal tsa va ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa nzanay, ntsa nza nihwəti shiy və na, ta mətsahanavə nihwəti shiy dzam, nza ghəshi mbəə mətsəhəva və ɗaŋ tərəŋw. Ma na ntsa kama shiy vəy, ta zhini dza məndiy tsaləhwə ya niy nza va jəw ni shiy və. ");
INSERT INTO bcw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ava va tsəgha nza na war dzar kwa fir yən ɗi gəzanshi kwəma. Sa nzanay, mbaꞌa mətsəhi və shi ta nay pi na, a ka nay pi ghəshiw. Mbə favə kwəma slimim shi na, zhini ka favə kwəma fa ghəshi va ghəshiw, tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ma mbə kwəma shi va tsəgha na kiy, kwəmaa niy gəzəkə *Ezay ndə gəzə kwəma Hyala va mbəradzə na sava faghwa ghəshi gəraꞌi kwa. Sa niy nə na va: Ma ghwəyəy, mbə favə kwəma ghwəy dzaa nza lə slimim ghwəy ngar na, a ka dza ghwəy favə shi ɗi kwəma vaa gəzəw. Mbə nighə pi ghwəy dzaa nza lə mətsəhi ghwəy ngar na, a ka dza ghwəy nashi shiyəw. ");
INSERT INTO bcw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sa nzanay, kwəmaa tsəꞌwə mbə nefer mbəzli ni tiɓa ya jəwəw. Nəꞌwə nəꞌwə na naꞌway ghəshi slimim shi, vantaa ghəshi dzaa zləwaŋəvə kwəma. Dzəghwa, disl disl disl ghəshi kakalay mətsəhi shi vantaa ghəshi dzaa nashi shiy. Mbaꞌa ghəshi mənti nefer shi caslakə caslakə vantaa kwəmee tsəꞌwə mbə nefer shi. Ma mənti ghəshi kwəma va tsəghay, va nəghətaa ghəshi zhəghəvaa zhikəə zhəvəghee, ta mbalamtishee, nə ghəshi, kə Hyala, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma na na ghwəy ghwəy mbəzli ta səɗee kiy, vəshi na tə ghwəy. Sa nzana, mbə nay pi ghwəy lə mətsəhi ghwəy, dzəghwa mbə favə kwəma ghwəy lə slimim ghwəy na ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","E gəzaŋwəyee, ta na navay, tsəgha na, ka gəzə kwəma Hyala ɗaŋ, mbaꞌa mbəzliy nəw Hyala ɗaŋ səəkə na mbə maw nashi shi nashi mətsəhi ghwəy ni sana. Kalaa niy kwəmavə nashi ghəshi, mbə maw fa kwəma favə ghwəy na sənzənva ghəshi niy nza na, a kwəmavə fa nzə ghəshiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Zhini ma kə Yesəw diɓa na: «Əy ma kiy, favəm bazhə tsa kwəma ɗi fir tsa ɓəlee va lə ndə sləka haa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Avanay, faꞌ dza nihwəti mbəzliy favə gəzə kwəmaa dzəkən njasa dza Hyalaa sləkə mbəzli, dzəghwa kala dza ghəshiy favə sləkar tsa kwəma va. Ka *ndə jaka tsa Hyala səəkəy, zəkwə jəw ɓanti kwəma va mbə nəfə shi. Niva mbəzliy, yəmyəm ghəshi lə kwal tsa pəriŋəta hwəlfə ha vaa dzəghwa. ");
INSERT INTO bcw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nəfə tsa nihwəti mbəzli ɓa na, yəmyəm na lə kwərhə tsa pəriŋəta nahwəti ha vaa dzəti. Sa ka ghəshiy favə kwəma Hyala na, zəkwə jəw ghəshiy zləɓavə lə vəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Zhini diɓa na, ka nzay nza ghəshi lə kwəma va mbə nəfə tsa shi, sa mbay ma kwəma vaa tsəhə hililiŋə wəzə wəzə mbə shiw. War nə ma ngəraꞌwə ndəs kə kəsashi, ya ə ghəzlishi məndi tə mbərkə kwəma Hyala na, ka ghəshi dza nzaꞌjəw, mbərəkə ghəshi zlata nəw kwəma Hyala tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nəfə tsa nihwəti mbəzli diɓa na, yəmyəm na lə pətsa nza tekesli va ti dzəghwata nahwəti ha va mbə. Gəla niva mbəzli ɓay, sa ka ghəshiy favə kwəma Hyala na, mbaꞌa ghəshi zləɓavə. Ka ghəshi dza diɓa na, mbaꞌa ghəshi dzəmbəshi mbə zəzə kwəma tə hiɗi, ka məni mətsə ta shi tə hiɗi ni ngəɗipə. Ma sa ka shi va təhay nəfə tsa shi ki na, ka ghəshi dza mbaꞌa ghəshi makəti kwəma Hyala va kəli, lə va ghəra sləni mbə nefer mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma nəfə tsa nihwəti mbəzli nashi kiy, yəmyəm na lə hiɗi wəzə ni va dzəmbəta nahwəti ha mbə shi. Ma na gəla niva mbəzli nashi kiy, sa ka ghəshiy favə kwəma Hyala na, kar ghəshiy fəti ghən ti wəzə. Ka ghəshi dza na, ka ghəra sləni Hyala wəzə. Nihwəti mbə shi na tərəŋw ghəshi jahambəvashi mbə, nihwəti na, bərəkə, ma nihwəti ɓa na geꞌi geꞌi. Tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zhəghwa Yesəw diɓa, mbaꞌa ɓəlanakəshi tsahwəti fir, ma kə na: «Ma sləkə tsa sləkə Hyala mbəzliy, ghala mbə lə kwəma dzee na ta gəzaŋwəyəw: Tsəŋw niy tsəŋwəti tsahwəti ndə hwəlfə ha wəzə naa dzəti za ci. ");
INSERT INTO bcw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma tə nahwəti vərɗi, mbəzli tə hi na, mbaꞌa ndə jaka tsa ci səəkəə tsaŋwanambə ka girfiy dzəmbə ha ci va, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mbaꞌa ka girfi va pəpəsəshi kwasəbə ha va, ka kəli yəmyəm li. Ma sa maɗita ha ta pasə na, dza ka girfi ka pasə kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma sa səəkə gwəlaa ghəranci sləni kaa ntsa vaa nashi tsəgha na, dza ghəshi mbaꞌa ghəshi dzaa gəzanci kaa ndə za tsa va, a kə ghəshi ngəci na: “A ntsa ghəy dikə tsa, wa hwəlfə ha sa niy tsaŋwati gha va tə za gha va sham tsəy? Əy, war njaa zhəkə na, zhini ka girfiy təzlishi dzar mbə shiki?” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma kə ndə za tsa va na: “Waa ntsaa ɗi ma mətsee tsaŋwambəshi na” kə. Ma kə gwəla va na: “Ghənzə tsəgha na, zləɓati gha, a ghəy dza ta taɗamtishi tsəna?” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma kə ndə za tsa va na: “Əhəŋ, sana sənzənva, war mbaꞌa pə ghwəy tiɗishiy, a ghwəy dzaa karəhwə lə ha ta. ");
INSERT INTO bcw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Va tsəgha kiy, wəzəɓa zlashi ghwəy na, a ghəshi nakə gwanashi paꞌ tə vəghwə tsa dza məndiy sla ha ti. Ma ghalaɓa ki na, ma nzee gəzanshi kaa mbəzliy dzaa sla ha. Ma pən taa ni ngəshi na: Slantim ka girfi, a ghwəy pəhətishi, nza ghwəy ndamtishi lə ghwə. Ma na ha yay, paghəram jighiy dzəghwa tamə, pən dzaa ni” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zhəghwa Yesəw diɓa mbaꞌa ɓəlanakəshi tsahwəti fir, ma kə na: «Ma na sləkə tsa sləkə Hyala mbəzli diɓay, yəm na lə kwəma cizlə gwəbiri ka ndə vaa ɓəvə, mbaꞌa ndə tsəŋwətishi kwa tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ghəshi na cizləy gwəramti jəw jəw mbə hwəlfə shi ka ndə ngəriy tsəŋwə gwaꞌa gwaꞌa. Ma sa ka ghəshi pəsəshi kiy, ka ghəshi dza na, ka kəli dikə tərəŋw, taŋ fəhi gwanashi ni. Paꞌ ka səəkə ꞌyegwer ghənghən ghənghən lala ghyeghyer shi mə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Dza Yesəw mbaꞌa ɓəlanakəshi tsahwəti fir diɓa, ma kə na: «Sləkə tsa sləkə Hyala mbəzli nzə diɓay, yəmyəm na lə is tsa ka mali vaa tivə jəwə, mbaꞌa tambə mbə ghwəpə gar kiləw bakə mətsəkə cifəti, ka gha nighə na, pifpirif ghənzə pəkəməvata gwanata» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ava tsəgha gəzanamti Yesəw kwemer va kaa mbəzliy ɓasəshi va gwanashi, war dzar kwa fir. Nahwəti kwəma tiɓa mbaꞌa gəzanakəshi kala dzar kwa firiw. ");
INSERT INTO bcw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma gəzə na kwəma va tsəghay, war ta mbə ghənzəə dzəghwata kwa kwəmaa niy gəzəkə ndə Hyala va niy nza. Ma kə niy niy: «Ma kə Hyalay: Yənəy, kwa fir dzee gəzanshi kwəma kaa mbəzli. Ta canatishi shiy niy nza mbəmbə ni ghala ngatee ghwəmə lə hiɗi dzee, kə» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dzəghwa Yesəw ki, mbaꞌa zlashi mbəzliy ɓasəshi va tərəŋw ni, mbaꞌa dzay dzakə ghi ghəshi lə mbəzli ta səɗa ci. Dza mbəzli ta səɗa ci va kət ghəshi kətəghəvashiy dzəvəgha, a kə ghəshi ngəci na: «A Metər, citəŋəy bazhə tsa kwəma ɗi ghaa gəzə lə fir tsa ɓəlikə gha va lə ka girfiy təzlishi mbə ha shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma kə Yesəw ngəshi na: «A ɗi naa gəzəy: Ma ndə za tsaa tsaŋwati hwəlfə ha wəzə na va tə za ciy, ghəci nzee, yən yən Zəghwə yakə ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma zay, ghəshi na hiɗi nza ghwəmə ni ti shi. Hwəlfə ha wəzə na va na, mbəzli sləkə Hyala ghəshi. Ma ka girfi nashi ki na, mbəzli mbə dəvə *ndə jaka tsa Hyala niva. ");
INSERT INTO bcw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma ntsaa ɗi ma mətsee va səəkəə tsaŋwambəra ka girfi mbə hee na, ghəci na ndə jaka tsa Hyala. Vici dza məndiy sla ha ti kiy, ghənzə na vici ɓasə ngwəvə fəca dza hiɗiy kəɗi. Ma gwəla ka sla ha va ki na, ghəshi na ka kwal Hyala ki. ");
INSERT INTO bcw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","War njasa ka məndi vaa təramti ka girfi səvəri mbə ha, mbaꞌam ndamtishi lə ghwə məndi mbə sla hay, war tsəgha dza məndiy məni fəca dza hidiy kəɗi. ");
INSERT INTO bcw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mbaꞌa dzee ghwənashi ka kwalee, yən yən Zəghwə yakə ndə ngəri. Ka ghəshi dzay, mbaꞌa ghəshi iməkəvəri hwəlfə mbəzliy shikə nihwəti mbəzli vaa dzəmbə məni *kwəma jikir na, ghəshi lə mbəzliy məni shi jikirkir ni gwanashi səvəri mbə mbəzli sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ka ghəshi dza na mbaꞌa ghəshi shakambəshi mbə ghwə ngaɗ ngaɗ ngaɗ na, nza ghəshi tihwəni mbə, ka pəpərə sliꞌi shi. ");
INSERT INTO bcw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma na mbəzliy ɗi fəti ta məni na ɗi Hyala kwəma nashi kiy, war mbərə dza ghəshi mbərə ghalaɓa, ghəy ghəy ghəy ndəɓa vici, tə pətsa sləkə dəshi tsa mə ghwəmə. Fə tə ghwəy ghən ta kwəma gəzee va wəzə, niy nza məhərli va ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zhini ma kə Yesəw ɓa na: «Ma sləkə tsa sləkə Hyala mbəzliy nzəy, ghala mbə lə kwəma shiy nza va mbəmbə ni mbə vəh, tərəŋw dimə ti shiw. Mbaꞌa tsahwəti ndə səəkəə kəsashi. Ma sa nashi na na, tərəŋw ghəci vəshiy, mbaꞌa zhiniy gwəmati mbəliy shi va wəzə. Dza na mbaꞌa dzaa ɗəlamti shi və gwanashi, ta səəkə ta pahwə vəh tsa va, va ndə vəh tsa va. ");
INSERT INTO bcw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ma sləkə tsa sləkə Hyala mbəzli nzə diɓay, ghala mbə lə kwəma ndə zhəghə dəvə tsaa nza va, ka pala tsahi mbəzə ta pa shiw. ");
INSERT INTO bcw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ma sa kwəmavə na niy gwəramti na, dza na mbaꞌa ɗəlamti shi və gwanashi, ta səəkə ta pahwə tsahi mbəzə va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Zhini ma kə Yesəw ɓa na: «Ma sləkə tsa sləkə Hyala mbəzli diɓay, ghala mbə lə kwəma zləkwə tsa ka mbəzliy kəəsə kərpi vaa bəzlaghwa kwa kwəfa, ta ka ya nimaɓa kərpi liw. Mbaꞌa kərpi dzəghwashi ghənghən ghənghən ɗaŋ tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dzəghwa ghəshi sa təhəy na na, mbaꞌa ghəshi mbahəkəməə dzəti həlbə. Mbaꞌa ghəshi shəkəkəmə kərpi kwa zləkwə, dza tas ghəshi nzəyshi, ka tərashi. Dza ghəshi kaa ni wəzə wəzə ni kərpi, fəyik fəyik ghəshi bazlaghwashi kwa ghwanin shi. Dzəghwa kaa niy kama wəzə ni, mbaꞌa ghəshi shashakamtishi. ");
INSERT INTO bcw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ava tsəgha dza naa məniva fəca dza hidiy kəɗi ki. Təhwə dza ka kwal Hyalaa səəkəshi. Sa ghəshi səəkə na, mbaꞌa ghəshi tihəvəri mbəzliy məni kwəma wəzə na, lə niy məni *kwəma jikir na. ");
INSERT INTO bcw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ka ghəshi dza na, mbaꞌa ghəshi shakambə ni jikirkir ni va mbəzliy dzəmbə ghwəə tsə ngaɗ ngaɗ ngaɗ na. Ma nza ghəshi titihwəni, ka pəpərə sliꞌi shi mbə ghwə va ghalaɓa ki» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma kə Yesəw kaa mbəzli ta səɗa ci ki na: «Favə kwemer gəzəkee va ghwəy gwanashi na?» kə. Ma kə ghəshi ngəci na: «Yə, a ghəy favəshi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma kə Yesəw ngəshi ki na: «Va tsəgha na kiy, ya wa ndə ɓənipə kwəma tsaa zləɓavə Hyalaa sləkəy, ta mbay dza naa ɓənipə *kwəma pəhəti Hyala mbəradzə, mbaꞌa yəwən kwəma ɓəniŋwəy ya na sana» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dza Yesəw sa kəɗiy na lə ɓəli firhi va kaa mbəzli gwaꞌa, mbaꞌa ɓarvay tə tsava pi, ");
INSERT INTO bcw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ka dzay dzəmbə məlmə Nazaretə kəli na va mbə. Dza na təhwə dzəmbəy mbə *ciki ɓasəva tsa ka Zhəwifə. Sa dzəmbəy na na, dza na ka ɓananshi shiy kaa mbəzli mbəɓa. Ma mbəzli tə pətsa va gwanashi ki na, war hahashi ghəshi hashishi va gəla nava kwəma. Tapə ghəshi dzəmbəshi mbə gəzə kwəma, ma kə ghəshi na: «A mbəzli ni, səəkə kwəma kwəmavə na gəla na ci na sənata kwəma tsətsəa? Kwəma kwəmakə na nici ni bərci ta məni shi maɗaŋa maɗaŋa ni ni tsətsəa? ");
INSERT INTO bcw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ghəci zəghwə ndə fəɗi shəghwə tsa va, Marəy mbəghəyəy yakə nanzə sa. Kar Zhakə lə *Zhezhefə mbaꞌa Shimaŋw mbaꞌa Zhəwdə ngwarməhiy yakə məndi li shi sham sa. ");
INSERT INTO bcw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ya ngwarməhiyəy miꞌi nzə na, tikə ghəshi mbə ghwəmmə sana nanzə sa. War kwəma kwəmavə na nici ni bərci məni na shini li shia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ꞌWakəvə gəla təkə kwəma tsəgha na va, mbaꞌa makətishi ta zləɓa kwəma Yesəw. Ma kə Yesəw ngəshi naci ki na: «A kataŋəy, a məndiy fə bamaa dzəti *ndə gəzə kwəma Hyala, ya paꞌ kwəmaɓa. Ma mbə məlmə yakə məndi lə kəghi tsa yakə məndiy, ka fə bama məndiy dzətiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma sa nzana kala ɗi ɓanavə nefer shi mbəzli mbə məlmə Nazaretə ki na, kəray jəwə tsətsə Yesəw mənəhwə kwəma maɗaŋa maɗaŋa na mbə məlmə va gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma ghala pətsa va ki na, mbaꞌa *Erədə mazə tsa tə hiɗi ka Galile favə ghəpə tsa kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma sa favə na, ma kə kaa ka ghəra sləni ci na: «Ma Yesəw tsa gəzə məndi va kwəma ciy, Zhaŋ tsaa mənipə batem va na, ə zhəkəməy na kwa kwəli, va tsəgha nza bərci və ta məni shi maɗaŋa maɗaŋa ni va tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ma gəzə Erədə kwəma va tsəghay, sa zəzəvə na shiy niy mənti na lə Zhaŋ na. Ghala pətsa vay, ə niy ɓələhwə na mali Fəlipə, zədəy. Erədiyadə, kə məndi kaa slən tsa mali va. Sa niy ɓələhwə nay, ma kə Zhaŋ niy ni kaa ngəci na: «Kwal va gha kwa kwəma Hyala ta ɓəli mali zədəŋa va ɓələhwə ghaw» kə niy ni kaa ngəci. Ma sa niy gəzanakə Zhaŋ kwəma va tsəgha na, dza Erədə mbaꞌa niy tsaghwa kwa dəŋw, mbaꞌa faghwa kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mbə ɗi paslamti Zhaŋ ghəci niy nza na, ka ghəranci hazləni niy nza va mbəzli. Sa nzana mbaꞌa mbəzli gwanashi niy ɓəti Zhaŋ ka *ndə gəzə kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma sa niy bərkəta viciy niy yakə məndi mazə Erədə ti na, dza na mbaꞌa niy tati shiy. Kə mbaꞌa niy hakakə mbəzli ta zəmə shiy fəcava ki. Mbaꞌa zha Erədiyadə niy səəkəə tsəti tsə kwa kwəma mbəzliy niy nza va tiɓa harkə na gwanashi. Mbaꞌa tsə va təɓanati kaa mazə Erədə tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dzəghwa na tə mbərkə ta tsə va, hwaꞌ hwaꞌ, zəmanakə fəla kaa zha va. Ma kə niy ni ngəta na: «Ya wa shi ɗəw gha vəyay, ta ndaŋashi dzee» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sa niy gəzəkə na tsəgha na, dza zha va del niy dzata, mbaꞌa niy dzaa kəsata mbəghəta. Ma kə niy ni kaa ngəta na: «Wa shi kee ɗəw va mazəa mə?» kə niy ni kaa ngəta. Ma kə mbəghəta niy ni ngəta na: «Mbala, ma pə gha kaa ngəciy: Slaghwara ghən tsa Zhaŋ ndə mənipə batem kwa tasaw, pə gha ngəci» kə niy ni. Dzəghwa zha va mbaꞌa niy səəkətaa ɗəwhwə tsəgha va mazə ki. ");
INSERT INTO bcw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma sa niy ɗəw zha va shi va tsəgha na, kwəshay vəgha mazə niy mənta va nava kwəma. Ka zhanci ghənzə niy nza mbə nəfə tsa ci tərəŋw ngar na, a niy mbay naa zhiniy bashamti, sa nzana mbaꞌa niy mbəlitiy zəmanakə fəla kwa kwəma mbəzliy niy ɓasəshi va kiw. Dza na niy nza tsəgha ki na, ɓəŋ niy ghwənay ndə sawji ta mananta kwəma ɗəw na va. ");
INSERT INTO bcw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A kə niy ni ngəci na: «Mbalaa dzəghwa fərshina a gha dzaa kəsəvə Zhaŋ tsaa mənipə batem va, nza gha slanakəvə ghən tsa ci kaa zha na» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mbaꞌa ntsa va niy dzaa kəsəvə Zhaŋ, piyəŋ slahwə ghən ti. Mbaꞌa niy faghwa ghən tsa va kwa tasaw, mbaꞌa niy səəkəə ɓanavə kaa zha va, mbaꞌa zha va niy ɓəvəə, mbaꞌa niy dzaa ɓanavə kaa mbəghəta. ");
INSERT INTO bcw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dzəghwa mbaꞌa mbəzli ta səɗa Zhaŋ niy favə bar tsa va ki. Ma sa favə ghəshi na, mbaꞌa ghəshi niy səəkəə ɓəvə mbəri tsa Zhaŋ, mbaꞌa ghəshi dzaa lamti. Sa niy lamti ghəshi na, mbaꞌa ghəshi niy dzaa slanati kwəmaa niy mənta va gwaꞌa kaa Yesəw. Ava tsəgha niy mətiy Zhaŋ ndə məni batem. ");
INSERT INTO bcw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ma sa favə Yesəw kwəma gəzəkə *Erədə va ki na, dza na mbaꞌa ɓarvay tə pətsa va, ka dzay dzəghwa kwambəwal ta dzay dzəmbə gamba, ta dzaa nzəyəy kwətiy vəgha bəla. Dzəghwa nzaꞌjəw mbəzli favə kwəma dza ci va. Mbaꞌa mbəzli maɗishi səəkə dzar mbə məlməhi ghənghən ghənghən, war ka nəw dzəy vəgha həlbə vəgha həlbə lə shiɗshiɗ shi. ");
INSERT INTO bcw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma sa tsəhəy Yesəw tə pətsa bərkəti na va ki na, mbaꞌa səəməy kwa kwambəwal. Sa nə na tsaꞌ kə na, mbəzli ɓasə ɓasə tə pətsa va ɗaŋ. Tapə hwər tsa ci ta zhanci ta mbəzli va ki, mbaꞌa mbalamti ni gwərapə gwərapəshi ni va zəleghwer mbə shi. ");
INSERT INTO bcw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma sa mənta tihwer na, mbaꞌa *mbəzli ta səɗa Yesəw kətəghəvashiy dzəvəgha. Ma kə ghəshi ngəci na: «A Metər, sana sənzənva kiy, a vici dzata, mbə gamba pətsa. Va tsəgha nə ghəy wəzəɓa ɓanavə gha kwal kaa mbəzli ni, a ghəshi dzashi ta papa shi zəmə shi dzar mbə məlməhi, pə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma kə Yesəw ngəshi na: «Sa wana ka məndi gəzanshi dzashia? Ɓanshim shi zəmə dəꞌwə ghən tsa ghwəy, a ghəshi zəməshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma kə ghəshi ngəci na: «Sana sənzənvay, kwataka peŋ cifə dəvə, mbaꞌa kərpi bakəshi na shi tikə va ghəy gwaꞌa tsəgha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma kə Yesəw na: «Ndakashim tikə na ghwəy» kə. Dzəghwa mbaꞌa məndi ɓanakəvəshi. ");
INSERT INTO bcw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma sa ɓanakəvəshi məndi na, dza na mbaꞌa gəzanshi kaa mbəzli va, a ghəshi nzəyshi mənzəy. Dza na həŋ ɓəvə peŋ tsa cifə tsa va, mbaꞌa kərpi bakə ni va ta dəvə ci, mbaꞌa kafata kwəma ciy dzəta ghwəmə, ka mananta ꞌwəsa kaa Hyala ta shi zəmə va. Ma sa mananati na ꞌwəsa kaa Hyala na, dza na mbaꞌa ngangavəri peŋ tsa va, mbaꞌa ɓanavə kaa mbəzli ta səɗa ci, a ghəshi tahanshi kaa mbəzli ɗaŋ ni va. ");
INSERT INTO bcw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mbaꞌa mbəzli va zəməhwə shi va gwanashi, bəhə, bəhə, bəhə ghəshi, mbaꞌa mbəvəli tərə. Dza mbəzli ta səɗa ci va, ɓasə, ɓasə, ghəshi ɓasəti mbəvəli va, gyaɗə gyaɗə ghwani məŋ lə bakə. ");
INSERT INTO bcw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mbə mbəzliy zəməhwə shiy va bəhə bəhə ghəshiy, a zhər mənti gar bələkwə bələkwə cifə mətsəkə, mbərəkəshi miꞌi lə ndərazhi. ");
INSERT INTO bcw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","War ghwəla, ləy hwəm kwəma va ki, ma kə Yesəw kaa *mbəzli ta səɗa ci na: «Ləghwam dzəghwa kwambəwal, a ghwəy ꞌwati kwal dzəvəriy dzəti həlbə. Kala kərnee səkwəti mbəzli ghəshiy dzashi» kə. Mbaꞌa mbəzli ta səɗa ci va dzəghwashi, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma sa səkwamti Yesəw mbəzli ka dzashi ghəshi ki na, dza na mbaꞌa dzəməy mə kəlaŋ kwətiy, ta cəꞌwə. Paꞌ ka mənta vərɗi war ghəci məɓa kwətiy. ");
INSERT INTO bcw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma ghalaɓa ki na, mbəzli ta səɗa ci kətivə dzaa dzashi kərakə lə həlbə. Dza safə ka viy səəkəə dzəmbə kwəma shi, ka gwaŋəzə kwambəwal yam. ");
INSERT INTO bcw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma tə kwa baka wa ngələkə na, mbaꞌa Yesəw dzətiy tə ghən yam, ka dza dzar ti shi lə səɗa ci ta kəsashi mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma sa nay mbəzli ta səɗa ci va ghəciy dza dzar tə ghən yam lə səɗa na, mbaꞌa her shi dzashi tərəŋw. Ma kə ghəshi na: «Aya, anay *hil ɗaŋəmmə» kə ghəshi. Ka ngwəmə lala ghəshi va hazləni. ");
INSERT INTO bcw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","War ghwəla tsəgha ki na, mbaꞌa Yesəw ghati gəzanshi kwəma, a kə na: «Waa yən na, ə kə her ghwəy dzəghwashi, ka hazləni ghwəy ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma sa gəzəkə Yesəw tsəgha, ma kə Piyer ngəci na: «A Ndə sləkəpə, ndata gha na kataŋəy, gəzara e dzar lə səɗee tə yam vaa dzəvəgha gha kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma kə Yesəw ngəci na: «Sar» kə. Dza Piyer fakatsaꞌwə maɗiy səəmə kwa kwambəwal, ka dza ghəci tə ghən yam va lə səɗa ciy dzar dzəvəgha Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Zhini sa nay na safə mbə viy na, mbaꞌa hazləni ghati ghəranci tiɓa. War ghwəla tsəgha na, səɗakwə Piyer ghati yipəvaa dzəghwa kwəfa. Dzəghwa na tapə ta ngwəmə lala, a kə na «A Ndə sləkəpə, mbəlitəra» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dzəghwa nzaꞌjəw Yesəw vəlanavə dəvə ciy kaꞌwəti. Ma kə kaa ngəci sa kaꞌwəkəmmə na na: «A Piyer ndara nəfə tsa gha gha gwanayəw. Tawa mənti gha ghən tsa gha bakə bakəa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ləy hwəm ki na, mbaꞌa ghəshi dzashiy dzəghwa kwambəwal bakanashi. Dzəghwa gar safə tsa va garəti viy. ");
INSERT INTO bcw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dzəghwa niy nza kwa kwambəwal shi ni mbəzli ta səɗa Yesəw gwanashi, tsəfəkwə tsəfəkwə tsəfəkwə ghəshi tsəfəkwəshi, ka pəraꞌwanci dividivi shi kaa Yesəw. Ma kə ghəshi na: «Wa Zəghwə Hyala nza gha kataŋ» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma sa taŋamti ghəshi kwəfa va na, mbaꞌa ghəshi tsəhəshi tə hiɗi ka Zhenezaretə. ");
INSERT INTO bcw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","War sa tsəhəshi ghəshi na, mbaꞌa mbəzli tə hiɗi va sənivə Yesəw. Nzaꞌjəw, zləŋ məlmə, ghəshi gəzamti səəkə tsa Yesəw kaa mbəzli tə hiɗi va. Mbaꞌa ghəshi ɓasanakə ka zəlghwə ngəci ki. ");
INSERT INTO bcw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tapə ghəshi ta cəꞌwə Yesəw, a ghəci ɓanavəshi kwal tsaa dapəvə ya kwataka mətsəni kwəbaŋ tsa kən ghən ci. Ya tsamaɓa ndə zəlghwə tsaa ndəŋway ki na, mbaꞌa mbəliy kwəriŋ. ");
INSERT INTO bcw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dza *ka Farisahi ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala, mbaꞌa ghəshi səəkəshi mbə məlmə Zherəwzalem dzəvəgha Yesəw. Dza ghəshi ka ɗəw kwəma və, ");
INSERT INTO bcw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","a kə ghəshi na: «A Metər, a kwəma jiji ghwəmmə gəzəkə, ka ndə gha zəmə shiyəy, mbaꞌa ndə pishamti dəvə ci, kə. Ava ghaa nashi mbəzli ta səɗa gha ni mbə zəmə shiy kala pi ma dəvə. Tawa nəw ma ghəshi kwəma jiji va kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma kə Yesəw zləɓanshi na: «Wa shiy mənishi ɗi ma ghwəy fəti ta kwəma pəhəti Hyala, dzaŋwəy ghwəy ta nəw war kwəma jijihiŋwəy na ghwəy shəka? ");
INSERT INTO bcw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Njasa nzana va sənzənva, mbaꞌa Hyala gəzəkə: “Ə pə ghaa haꞌwə tə kar dəŋa lə məŋa” kə. Zhini ma kə ɓa na: “Ya wa ntsaa tsəərəti dəy ya mbəghəyəy, mbaꞌa məndi paslamti tsava ndə” kə diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma pə ghwəy na ghwəy ki, mbə kwəma ɓənipə ghwəy na: “War nə ma ndə kaa dəy, ya kaa mbəghəy: A di, a mə, ma shiy niy nza vəya gar ɓəŋwəyshee ta kəətiŋwəyəy, kaa Hyala ɓəhwəshee, kəy, ya kala zhini tsava ndəə kəəti kar dəy lə mbəghəy na, gwaꞌa tsəgha” pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","War tsəgha pəəsliti ghwəy na Hyala va kwəma pəhəti na, ta mbəə nəw na ghwəy va kwəma jiji! ");
INSERT INTO bcw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma kwəma ghwəy ghwəy ka dakə mbəzli lə kwəma pərikə tə ngwəla niy, kataŋ na kwəmaa niy gəzəkə *Ezay ndə gəzə kwəma Hyala vaa dzəkən ghwəy. A kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","A kə Hyalay: “Ma mbəzli niy, war kwataka lə miy gəzə ghəshi haꞌwə tsa haꞌwə ghəshi tə ya gwaꞌa tsəgha. Ma mbə nefer shi na, kərakə kərakə ghəshi lə ya. ");
INSERT INTO bcw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gəmta na tsəfəkwə tsəfəkwə ghəshi va kwa kwəmee, sa nzanay, war kwəma jiji shi gwaꞌa tsəgha na shi ɓananshi ghəshi kaa mbəzli, njasa nzanaa kwəmee ghəshi zhəghəti” kə Hyala, kə Ezay niy ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dzəghwa Yesəw mbaꞌa harvə mbəzliy ɓasəshi va. Ma kə kaa ngəshi na: «Fam kwəma ɗee na gəzə, nza ghwəy fə ghən ti. ");
INSERT INTO bcw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma na shi zəməhwə ndəə dzəghwa hwər ciy, ka mbay ghəshiy yaɗamti ndə kwa kwəma Hyalaw. Naa səvəri kwəma mbə miy tsa ci na saa yiɗi ndə kwa kwəma Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dzəghwa mbəzli ta səɗa ci kət ghəshi kətəghəvashiy dzəvəgha Yesəw. A kə ghəshi ngəci na: «Sənay gha tərəŋw satiy nəfə tsa *ka Farisahi va kwəma gəzəkə gha va tsəgha na, pə gha tsəna?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma kə Yesəw kaa zləɓanshi na: «Nay ghwəy tsəy, ya tsamaɓa dəŋw fə na, kala Dirə tsa mə ghwəmə kə ngwəɓətiy, war təɗi təɗi dza naa nza. ");
INSERT INTO bcw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zlashim lə kwəma shi. Ghwəlefesliy canshi kwal kaa nihwəti ghwəlefesli na ghəshi. A ghwəy sənay, war mbaꞌa kə ghwəlfəə kəsə tsahwəti ghwəlfə tə dəvə ci, ta canci kwaləy, ta shikəshi dza ghəshiy dzəghwa kəꞌwə bakanavashi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dzəghwa ma kə Piyer ngəci na: «A Metər, citəŋəy bazhə tsa kwəma ɗi fir tsa vaa gəzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma kə Yesəw ngəci na: «Waa lə ghwəyŋwəyshi mbə ma naa favə kwəma kwərakwə ɓa na? ");
INSERT INTO bcw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ə sənay ma ghwəy, ma na shi zəməhwə ndəy, dzəghwa hwər tsa ci ka niva shiy dza, ka ndə dza na, mbaꞌa təhəkəghwashi, pə ghwəy shəkəna? ");
INSERT INTO bcw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Əy ma na kwəmaa səvəri mbə miy ndə nanzə kiy, səəkə mbə nəfə tsa ndə ka navaa səəkə. Ava niva shiy na shiy dzaa laɗamti ndə kwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa nzanay, war səəkə mbə nəfə tsa ndə səəkə təkə *kwəma jikir na. Ma ka gha nighə na, vbəpə təkə kwəma va fambə ndə mbə pəəsli ndə, ka pəəsli miꞌi mbəzli, ka məməni ghwərghwər, ka ghəli, ka təɓə dzərvəə dzəkən mbəzli, ka gəzə kwəma jikir naa dzəkən mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ava shiy məni ndə ka ntsa liɗi liɗi tsa kwa kwəma Hyala. Ma na nə jijihimmə va, mbaꞌa kə ndə zəməhwə shiy kala pishə dəvə na, ntsa liɗi liɗi tsa na kwa kwəma Hyala, kə ghəshiy, tsəgha naw. Ka mbay niva shiy laɗamti ndəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Dza Yesəw mbaꞌa ɓarvay tə tsava pi, ka dzay dzəti hiɗi vəgha məlmə Tir lə məlmə Shidaŋw. ");
INSERT INTO bcw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma sa tsəhəy na na, dzəghwa nahwəti mali mbə hwəlfə ka Kanana, tə hiɗi va, ndəs səəkətaa dzəvəgha Yesəw. A kə ngəci na: «A Ndə sləkəpə, jijiy mazə *Davitə, titihwə mənti zhəhwər tə ya. Gazlaka kəsəvə na zhee, war ə ghənzəə sa ngəraꞌwə tərəŋw tərəŋw və» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dzəghwa Yesəw tərəm, nzəyəy kala zləɓanta kwəma, ya kwətiŋ nzə. Mbaꞌa mbəzli ta səɗa ci səəkəshiy dzəvəgha, ma kə ghəshi ngəci na: «A Metər, mananati kwəma ɗəw na va, a ghənzə zlamməə dzata. Sa nzanay, ka dza naa zlay nəwəmmə war tsəgha lə lala nzə vaw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma kə Yesəw zləɓanshi na: «Yənəy, war kwataka ta hwəlfə ka *Izərayel, ghəshi shiy mənishi nja teŋkesli zaza ni ghwənikəra Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma sa favə mali va tsəgha na, səəkə na gələɓə gələɓəta tə shinin nzə kwa kwəma ci. Ma kə ngəci na: «A Ndə sləkəpə, titihwə kəətitəra na gha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dzəghwa ma kə Yesəw ngəta na: «A mali na, waa wəzə na ndə ɓəvə shi zəmə ndərazhi, ka ndəghashi kaa kireketiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma kə mali va na: «Yaŋ, tsəgha na nava nanzə kataŋ Ndə sləkəpə. Ma nanzə ya tsəgha nzəy, ya kireketi na, kar ghəshiy kwəmavə imə memiriy shikə səkwa tə tabəl tsa ndə shiy, ghəci mbə zəmə shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma kə Yesəw kaa ngəta na: «A mali na, a gha ndara nəfə tsa gha gwanay. Nana kiy, ta məntəŋa kwəma gha va dzee njasa ɗi nəfə tsa gha va» kə. ꞌWakəvə tsəgha, nzaꞌjəw, pəlis zha mali va va mbəlita va gazlaka va ghala pətsa gəzə Yesəw va kwəma va. ");
INSERT INTO bcw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dzəghwa Yesəw mbaꞌa maɗiy tiɓa, ka dzay dzəməy kwəfa har məndiy kwəfa Galile. Dza na mbaꞌa dzəməy mə tsahwəti kəlaŋ tiɓa, mbaꞌa nzəyəy mə. ");
INSERT INTO bcw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dzəghwa mbəzli ɗaŋ, mbaꞌa ghəshi ɓasəkəvashiy dzəvəgha, lə mbəzli gwərapə gwərapəshi ni: Vədevəder, lə ghwəlefesli, mbaꞌa mbəzli məti məti vəgha ni, mbaꞌa mbəzli pəhəta ghani shi mbay ma gəzə kwəma, mbaꞌa nihwəti mbəzli mananshi zəleghwer ghənghən ghənghən ni ɗaŋ. Ɓasə ghəshi ɓasəyshi kwa kwəma Yesəw. Dza na mbaꞌa mbalamtishi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma sa mbalamtishi na na, mbaꞌa nava kwəma mananatishi maɗaŋa kaa mbəzli. Ma kə ghəshi na: «Kay, ꞌyahəꞌyahəy na tsatsa ndə» kə ghəshi. Sa nata ghəshi hwəlfə nava maɗaŋa kwəma. Sa nzana mbə mbata gəzə kwəma mbəzliy niy pəhəta ghani shi va, mbəli mbəli mbəzli məti məti vəgha ni, mbə dza dzashi vədevəder, mbə nay pi ghwəlefesli ɗiweŋ ɗiweŋ. Dzəghwa ghəshi ki tapə ghəshi dzəmbəshi mbə fal Hyala ka *Izərayel. ");
INSERT INTO bcw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dzəghwa Yesəw ki daꞌ harvə mbəzli ta səɗa ci, ma kə ngəshi na: «Ma mbəzli niy, dalalay zhəra hwər tsee ti shi. Sa nzanay, kwa mahkana vici shi na sana, war ghəshi tikə vəghee, shi zəmə tiɓaw. Sana kiy, ka ɗee ghəshiy dzashi kala nganavəshi shi zəmə yaw, va nəghətaa ghəshi dzaa shikəshi, kwa kwal va ma» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma kə mbəzli ta səɗa ci kaa ngəci na: «Əy, kwəma ka ghwəmmə pəlakə shi zəmə sana kwamti na gar məkanshi kaa gəla mbəzli ɗaŋ ni ni tsətsə kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma kə Yesəw ngəshi na: «Hwəm na peŋ va ghwəya?» kə. Ma kə ghəshi na: «Mbərfəŋ na peŋ va ghəy, mbaꞌa kərpi jəw jəw ni, jəwə» kə ghəshi. «Ndakashim tikə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dza na mbaꞌa gəzanshi kaa mbəzliy ɓasəshi va, a ghəshi nzəyshi mənzəy. ");
INSERT INTO bcw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma sa nzəyshi ghəshi na, dza na həŋ ɓəvə peŋ tsa mbərfəŋ tsa va, lə kərpi va ta dəvə ci. Kə ka məni ꞌwəsa kaa Hyala. Ma sa manamti na ꞌwəsa na, dza na ngaꞌ ngaꞌ ngangavəri shi va gwanashi, mbaꞌa ɓanavəshi kaa mbəzli ta səɗa ci. Dza mbəzli ta səɗa ci va mbaꞌa ghəshi ɓəvə shi vaa tahanavəshi kaa mbəzli va ki. ");
INSERT INTO bcw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dzəghwa mbəzli tə pətsa va gwanashi, zəmə zəmə ghəshi zəməhwə shi zəmə va ki, bəhə bəhə ghəshi. Dzəghwa mbaꞌa məndi ɓasəti naa tərmbə mbəvəli, gyaɗə gyaɗə ghwani mbərfəŋ. ");
INSERT INTO bcw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mbə mbəzliy zəməhwə shi va vaa bəhəshiy, a zhər mənti bələkwə bələkwə faɗə mətsəkə. Mbərəkəshi kar miꞌi ghəshi lə ndərazhi. ");
INSERT INTO bcw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma ləy hwəm ki na, dzəghwa Yesəw mbaꞌa ɓanavə kwal kaa mbəzli va, ka dzashi ghəshi. Ma sa dzashi ghəshi na, mbaꞌa dzay dzəghwa kwambəwal ka dzay dzəti hiɗi ka Magadan. ");
INSERT INTO bcw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ma tə nahwəti vici na, mbaꞌa ka Farisahi lə ka Sadəsehi səəkəshi va Yesəw. Ma kə ghəshi kaa Yesəw sa ɗi ghəshi ngali ci na: «Mənti shi maɗaŋa maɗaŋa ni kwa kwəma ghəy. Ti dza ghəy sənay səəkə va Hyala səəkə kwəma gha na kataŋ, pə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma kə Yesəw ngəshi na: «A mbəzli ni, nata ma ghwəy ghwəmə ghəmmə vici mbə pəkwəy, cəkeꞌ ka ghwəy sənay ɗiweŋ dza piy nza həzlimə, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dzəghwa mekəshi ɓa, sa ka ghwəy nata ghwəmə ləvəta ngərəjəkəjəkə va kwəleɓi na, cəkeꞌ ka ghwəy sənay, ta nzəmə dza van ndatsə, pə ghwəy, tsəgha ghənzə. A ghwəy sənay tihəvəri shiy dzaa məniva lə nighə pətsa mə ghwəmə. Ma niy məniva shiy sənzənva mbə ghwəy na, kala sənay tihəvərishi ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ma ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsay, mbəzli jikirkir ni nza ghwəy, ka ɗi fəti ghwəy va Hyalaw. “Mənti shi maɗaŋa maɗaŋa ni” pə ghwəy kaa ngəra. Na nee nee kiy, nihwəti shi maɗaŋa maɗaŋa ni dzee məntəŋwəy tiɓaw. Mək na shi maɗaŋa maɗaŋa ni va niy mənəhwə Hyala lə *Zhəwnasə» kə. Sa gəzanakəshi na tsəgha na, dza na mbaꞌa zlashi tiɓa ka dzay. ");
INSERT INTO bcw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dza kar Yesəw ghəshi lə mbəzli ta səɗa ci, mbaꞌa ghəshi kafəshiy taŋəshi dzəvəri tə kwəfa vaa dzəti tsahwəti həlbə. Mbaꞌa mbəzli ta səɗa ci va niy zamti ghən ta ɓə peŋ. ");
INSERT INTO bcw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dzəghwa Yesəw mbaꞌa maɗiy ta gəzanshi kwəma, ma kə na: «Favə ghwəy na, ndəghwə tə ghwəy ghən tsa ghwəy, va is tsa ka Farisahi va lə sa ka Sadəsehi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma sa favə mbəzli ta səɗa ci va kwəma va tsəgha na, kə ghəshi ka gəzə kwəma kwa jipə shiy, ma kə ghəshi na: «Va sa zay ghən tsa ghwəmmə va ta ɓə peŋ gəzəmmə na kwəma va tsəgha ɓay?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dza Yesəw mbaꞌa fəti ghən ta kwəma gəzə ghəshi va. Ma kə kaa ngəshi na: «A navam kia? Tawa gəzə ghwəy kwəma kwa jipə ghwəy: “Va sa ɓəvə ma ghwəmmə peŋ” pə ghwəya? Ndara nefer ghwəy ghwəy gwanashiw. ");
INSERT INTO bcw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wa ka təkə kwəma ghwəy mbə ghən ghwəy sa? Ə zay ghən tsa ghwəy, ta mbəzli bahay ya va gar bələkwə bələkwə cifə mətsəkə ni tə nahwəti vici lə peŋ cifəy na? Ləy hwəm sa niy ngəslishi ghəshiy, ghwani hwəm niy təhay ghwəy lə kwa tərəmbəa? ");
INSERT INTO bcw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Zhini tsəghee ngaslay mbəzli gar bələkwə bələkwə faɗə mətsəkə, lə peŋ mbərfəŋ dəvə, ghwani hwəm niy nza kwa tərmbə tsaa niy ɓasəti ghwəya? ");
INSERT INTO bcw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ghala pətsa nə ya va ngəŋwəy, ndəghwəm ghən tsa ghwəy va is tsa ka Farisahi lə sa ka Sadəsehi pənəy, njaa sənay ma ghwəy, kwəma peŋ na sa ɗee va gəzaŋwəyəw, pə ghwəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma sa gəzəkə na tsəgha na, mbaꞌa mbəzli ta səɗa ci maɗiy fəti ghən ta kwəma va ki. «Ma kwəma gəzə Yesəw vay, dzəkən is tsaa pəsli shiy ɗi naa gəzəw. Ndəghwəm ghən tsa ghwəy va shi ɓənipə ka Farisahi lə ka Sadəsehi, ɗi naa gəzə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dzəghwa Yesəw ghəshi lə mbəzli ta səɗa ci, mbaꞌa ghəshi maɗishiy dzəti nihwəti hiɗi, ndəkwə vəgha hiɗi Shezare Filipə. Ma sa tsəhəshi ghəshi na, mbaꞌa maɗiy ta ɗəw kwəma va *mbəzli ta səɗa ci, ma kə na: «A ndə nzee ka mbəzliy ni yən Zəghwə yakə ndə ngəri baya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma kə mbəzli ta səɗa ci na: «Zhaŋ tsaa mənipə *batem nza gha, ka nihwəti mbəzliy ni. Nihwəti na: *Eli nza gha, kə ghəshi. Ma nihwəti ɓa na: Kala *Zhereməy pə ghay, tsahwəti ndə mbə ka gəzə kwəma Hyala nza gha, kə shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma kə Yesəw ngəshi na: «Ya ghwəy na ghwəy kiy, wa ndə nzee ka ghwəy nia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma kə Shimaŋw Piyer na: «Ghay, Kəristəw nza gha, Ntsa tivə Hyala ta mbəli mbəzli, zhini gha Zəghwə Hyala kwa ɓəpə piy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma sa gəzəkə Piyer tsəgha, ma kə Yesəw ngəci na: «A Piyer, zəghwə Zhaŋ, vəshi pə ghaa vəshi. Sa nzanay, ma kwəma kataŋ na na gəzəkəvəri ghay, kwəmaa səəkə va ndə ngəri naw. Dirə tsa mə ghwəmə citəŋa na kwəma va. ");
INSERT INTO bcw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma nə ya ngəŋa kiy: Piyer nza gha. Ma Piyer tsa vay, kəlɓa ɗi naa gəzə. Tə kəlɓa va dzee ɓasəy mbəzliy nəwra. Ka dza bərciy nza va məti gar mbashiw. ");
INSERT INTO bcw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Avee taa ndaŋa shiy ghwəni miy dəgha ta dzəti pətsa sləkə Hyala mbə dəvə gha. Ma shi dza ghaa pəhəti, ta mənishi mbəzli tikə tə hiɗiy, tsəgha dza ghəshiy nza va Hyala mə ghwəmə kwərakwə. Ma ni dza ghaa pəhəti shiy, ka mənishi məndiw, pə gha diɓa na, war tsəgha dza ghəshiy nza va Hyala mə ghwəmə kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sa gəzamti na kwəma va tsəgha na, dza na mbaꞌa makəti mbəzli ta səɗa ci, vantaa ghəshi dzaa gəzə kaa nihwəti mbəzli, ghəci na Kəristəw Ntsa tivə Hyala ta mbəli mbəzli, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ma geꞌi ghala vəghwə tsa va ki na, mbaꞌa Yesəw ghati gəzanshi bazhə bazhə kaa mbəzli ta səɗa ci, a kə kaa ngəshi na: «A nana ki, ya njaaɓay, ta dza dzee dzəmbə məlmə Zherəwzalem. Ma sa kee tsəhəray, ta sara ngəraꞌwə dalala dza mətikwəkwər mbə *ka Zhəwifə ghəshi lə mbəzli dikə dikə ni mbə *ka ta Hyala, mbaꞌa *ka ɓənipə kwəma pəhəti Hyala. Ta paslantəra dza məndi. Ma sa kee mətiray, ta satira dzee mbə məti tə kwa mahkana vicee kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma sa favə Piyer nava kwəma na, mbaꞌa harvə Yesəw dzəvəgha bəla. Ma kə kaa ngəci na: «A Ndə sləkəpə, əhəŋ, ka ɗee nava kwəmaa kəsaŋaw. Makəti gəla na tsəgha na va kwəma Hyala va dzəkən gha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ꞌWakəvə Yesəw tsəgha, tərəɗ zhəghəghəvay dzar kwa Piyer. Ma kə ngəci na: «Kərakə pə gha lə ya, *ndə jaka tsa Hyala tsa. Ə ɗi gha həərəɗa, ta tərambəraa dzəmbə *kwəma jikir na. Sa nzanay, na gha na hwəlfə təkə kwəmay, kwəmaa səəkə va Hyala na teepəw. Təkə kwəmaa səəkə va ndə ngəri na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dzəghwa ma kə kaa mbəzli ta səɗa ci na: «Mbaꞌa kə ndəə ɗi nəwray, ə kə tsava ndə zlay zəzəə dzəkən tsa ci ghən, mbaꞌa zləɓavə sa ngəraꞌwə, lə mətita gwaꞌa, ma nza ghəci nəwra. ");
INSERT INTO bcw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa nzana, ya wa ntsaa ɗi mbəliti piy tsa ci tikə tə hiɗiy, ta zamti tsa mə ghwəmə piy tsa ci dza na. Ma ntsaa dzaa zamti piy tsa ci tikə tə hiɗi tə mbərkə kwəma yay, ta mbəliti tsa mə ghwəmə piy tsa ci dza na. ");
INSERT INTO bcw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nay ghwəy na, ya shi tə hiɗi gwaꞌa gwaꞌaa kwəmavə ndə, mbaꞌa piy tsa ci mə ghwəmə zayəy, shiy tiɓa ndəə ꞌwəy ti mbə kwəma va tsəghaw. Tsahwəti sə tiɓa teepə gar dza ndəə mbəərəti piy tsa ci ti mə ghwəmə va Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","E gəzaŋwəy yay, ta səəkə dzee yən Zəghwə yakə ndə ngəri lə shəndəkə tsa Dirə, ghəy lə ka kwal Hyala ci. Sa kee səəkəray, kee dza na mbaꞌee wanati zhəmə ndə, ya tsamaɓa ci gwaꞌa, war geꞌi geꞌi lə na ci sləni ghərahwə na mbə nzəy tsa ci tikə tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ə gəzaŋwəyee, na navay tsəgha na, a nihwəti mbə ghwəy ghwəy mbəzli tikə niy, ka ghəshi gha bəkwə na ta nara dza ghəshi, yən Zəghwə yakə ndə ngəri, yən mbə səəkə ta məni mazə tsee» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dzəghwa sa mənta vici kwaŋ ləy hwəm shi va na, dza Yesəw kaa kar Piyer lə Zhakə, mbaꞌa Zhaŋ zəmbəghəy Zhakə, pəm pəməvəshi kwasəbə ci, ka dzashiy dzəmə ghən kəlaŋ tsa biti tsa, ta nza kwətishi məɓa. ");
INSERT INTO bcw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma sa tsəhəshi ghəshi məɓa na, dzəghwa Yesəw mbaꞌa zhəghanakəshi nahwəti pa kaa mbəzli ta səɗa ci va mahkan ni. Ka mbərə pətsa mbə kwəma ci ghəy ghəy ghəy, ndəɓa vici pə gha. Ma kwəbeŋer kən ghən ci na, mbaꞌa ghəshi zhəghəshi tezlezlezlezl, war ka baməpə. ");
INSERT INTO bcw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma zhini ghəshiy nighə ɓa na, kar *Məyizə lə *Eli tiɓa mbə gəzə kwəma li. ");
INSERT INTO bcw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma kə Piyer kaa Yesəw tsəgha ki na: «A Ndə sləkəpə, jəw na wəzə ghwəmmə nzəyəmmə tə pətsaw. Mbaꞌa pə gha zləɓatiy, kadiw e daŋəti ceker mahkan, kwətiŋ tsa gha, mbaꞌa tsa Məyizə, mbaꞌa tsa Eli» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma war ghəci ghwəlay mbə kərni gəzə kwəma gəzə na vaa səkwa tsəgha na, dzəghwa zləlahə, kwəleɓi səəkəshi tə ghwəmə, ka mbərə, səəkə zhəmakə məcakwə va kəələhwəshi. Fa ghəshi na, məli Hyala mbə gəzanshi kwəmaa dzəkən Yesəw səəkə mbə kwəleɓi va, ma kə na: «Favə tə ghwəy, ava ghəci na Zhəghwee ɗee, tərəŋw yən vəshi ti, fam kwəma və» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma sa favə *mbəzli ta səɗa Yesəw va mahkan ni məli va tsəgha na, mbaꞌa ghəshi hazlənishi tərəŋw. Tsəfəkwə tsəfəkwə ghəshi tsəfəkwəshi, nzəŋw nzəŋw kwəma shi mbə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dza Yesəw, kət kətəghəvay dzəvəgha shi, mbaꞌa dapashi. Ma kə ngəshi na: «Satiŋwəyəm məgarə, ka dza her ghwəy ma» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dzəghwa mbəzli ta səɗa ci va kafə, ghəshi kafata kwəma shi. Ma sa nə ghəshi njəꞌwə kə ghəshi na, nay ndə ghəshi tiɓa ghwəlaw. War Yesəw kwətiy. Mbaꞌa ghəshi maɗishi ta səkwashi mə kəlaŋ ki. ");
INSERT INTO bcw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma kə Yesəw ngəshi ghəshi mbə səkwa səəkə mə kəlaŋ tsa va na: «Ma shi nashi ghwəy ni mənishiy, əntaa ghwəy taa gəzəshi ya kaa tsamaɓa ndə di ma. Ndəghətim, paꞌ tə vici dzee zhakatira mbə məti, yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dzəghwa mbəzli ta səɗa ci va ka ɗəw kwəma və, a kə ghəshi na: «A Metər, sa wana niy nə *mbəzliy ɓənipə kwəma pəhəti Hyala na: “Pərɓa Eli dza naa səəkəy, ka *Kəristəw gha səəkə” kə ghəshia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ma kə Yesəw zləɓanshi na: «Yaŋ tsəgha na nava nanzə, kataŋ na. Eli dza naa ꞌwa kwal səəkə, ta gəzanshi zhəghə nefer shi kaa mbəzli ta nəw kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma ki e gəzaŋwəyəy, a Eli ꞌwakə kwal səəkəy ghala mbəradzəy. Dzəghwa mbəzli na, kala sənivə ghəshi. Mbaꞌa ghəshi mənti *kwəma jikir na li njasa ɗi ghəshi. Njasa sanamiy ghəshi va ngəraꞌwəy, tsəgha dza ghəshi ta samiyra, yən Zəghwə yakə ndə ngəri kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ma sa gəzəkə na kwəma va tsəgha na, mbaꞌa mbəzli ta səɗa ci va fəti ghən tsəgha, dzəkən Zhaŋ tsaa mənipə *batem gəzə na kwəma va, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dzəghwa kar Yesəw lə *mbəzli ta səɗa ci ki mbaꞌa ghəshi tsəhəshi vəgha mbəzli ɗaŋ ni. Dza tsahwəti ndə mbaꞌa maɗiy, ka səəkəə dzəvəgha Yesəw. Səəkə na gələɓə gələɓəy tə shinin ci kwa səɗa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ma kə na: «A Ndə sləkəpə, mənti zhəhwər ta zəghwee ghəci gwərapəy va zəlghwə bashakə, war mbə sa ngəraꞌwə ghəci və tərəŋw. Ɗaŋ səɗa ci səəkə zəlghwə tsa va mbə ndəghaa dzəti ghwə, lə dzəmbə yam. ");
INSERT INTO bcw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Dzəghwa mbaꞌee niy pəmanakəshi kaa mbəzli ta səɗa gha na, shaŋ ghəshi shaŋay mbəli ci» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma sa gəzəkə ntsa va tsəgha, ma kə Yesəw kaa mbəzli na: «Mata ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsa gəmgəm niy, ɓanavə nefer ghwəy ghwəy kaa Hyalaw. Paꞌ hwəm ɗi ghwəy yən nzəyra lə ghwəy kia? Paꞌ hwəm dzee nza mbə səꞌwa kwəma ghwəy diɓa kia? Ɓəram zəghwə vaa sar tikə» kə ");
INSERT INTO bcw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dza mbaꞌa məndi ɓanakə zəghwə va. Sa ɓəkəm na, mbaꞌa gəzanakə kwəma lə bərci kaa bashakə tsa va tərəŋw tərəŋw a ghəci səvəriy mbə zəghwə va. Dzəghwa nzaꞌjəw bashakə tsa vaa səvəriy mbə zəghwə va ki. Pəlis ghəci mbəliy tiɓata kwəriŋ. ");
INSERT INTO bcw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma sa nata *mbəzli ta səɗa Yesəw kwəma va mənta tsəgha na, dza ghəshi, kət ghəshi kətəghəvashiy dzəvəgha Yesəw. Ma kə ghəshi ngəci na: «Wa shiy mənishi niy mbə ma ghəy təhəkəvəri bashakə tsa va na ghəya?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ma kə Yesəw ngəshi na: «Waa ɓanavə nefer ghwəy ghwəy gwanashi kaa Hyalaw, va tsəgha mbay ma ghwəy təhəkəvəri. Ə gəzaŋwəy ya, ta na navay, tsəgha na, war mbaꞌa pə ghwəy ɓanavə nəfə tsa ghwəy kaa Hyala ya jəwə tsətsə nja cizlə gwəbiriy, ta mbay dza ghwəy ni, ya kaa dəlagwa na sana: “Təɗamtəvaŋa tikə, mbalaa dzarɓa!” pə ghwəy, ka na dza na, mbaꞌa ɓarvata. Ma tsəgha kiy, nihwəti shiy tiɓa mbaꞌa dzaa zhəntəŋwəy ghən tepəw.  ");
INSERT INTO bcw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma gəla bashakə tsay, ka mbay məndiy təhəkəvəri mbə ndə, kala lə məni səwmay mbaꞌa cəꞌwə Hyalaw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma tə nahwəti vici sa ɓasəshi kar Yesəw ghəshi lə mbəzli ta səɗa ci gwanashi tə hiɗi ka Galile na, dza na tapə ta gəzanshi kwəma, a kə na: «Ma yən yən Zəghwə yakə ndə ngəriy, ta kəsəvəra dza məndi mbaꞌam fambəra mbə dəvə mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ka mbəzli va dza na, mbaꞌa ghəshi paslantəra. Ma sa kee mətiray, tə kwa mahkana vicee kwa kwəli na ta zhakatira dzee mbə məti» kə. Ma sa favə mbəzli ta səɗa ci gəla nava kwəma tsəgha na, gwaꞌa, kwəshay vəgha shi mənta tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dza kar Yesəw lə mbəzli ta səɗa ci mbaꞌa ghəshi səəkəshiy dzəmbə məlmə Kapernahwəm. Ma sa səəkəshi ghəshi na, mbaꞌa mbəzliy tsəhə ghən va mbəzli mbə ciki Hyala səəkəshiy dzəvəgha Piyer. Ma kə ghəshi ngəci na: «A Piyer, kar ntsa ghwəy tsa dikə tsaa tsəhə ghən tsa mbə ciki Hyala sa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma kə Piyer na: «Yaŋ, kar naa tsəhə» kə. Ma Piyer mbə dzakə ghi na, mbaꞌa Yesəw ꞌwati ɗəw kwəma və pərɓa ghəci, ma kə ngəci na: «A Piyer, njaa na va gha tay? Va nima mbəzli ka mezhizhə tə hiɗiy tsəhə ghən tay? Va ka səəkə səəkə ta naa, naa va ka ya ya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma kə Piyer na: «Va ka səəkə səəkə ka ghəshiy tsəhə» kə. Ma kə Yesəw na: «Ghənzə tsəgha na, ka tsəhə ghən ka ya ya na nashi ɓa na? ");
INSERT INTO bcw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Əy, ma ki ya tsəgha nzə, vantaa nefer ka tsəhə ghən va taa satiy, mbala ɓəvə gwəvbeŋ, a gha dzaa dzəməy kwəfa, ta kəəsə kərpi. Ma kəlipə dza ghaa ꞌwa kəsəvəy, nza gha ɓəvəə ghwənamti miy tsa nzə. Sa ka gha ghwənamtiy, ta kəsay səlay dza gha mbəɓa. Nza gha ɓəvə, nza gha dzaa ɓanavəshi. Mək dza naa nzaa dzəti tsee ghən lə dzəti tsa gha gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ghala pətsa va ki na, dza *mbəzli ta səɗa Yesəw mbaꞌa ghəshi kətəghəvashiy dzəvəgha Yesəw. Ka ɗəw kwəma ghəshi və, ma kə ghəshi na: «A Metər, tsama ndə na ntsaa gwəra dikə mbə mbəzli sləkə Hyala tay?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dzəghwa Yesəw daꞌ haray zəghwə jəwə tiɓa, mbaꞌa garəy kwa kwəma shi. ");
INSERT INTO bcw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A kə ngəshi na: «A gəzaŋwəy ya, ta na navay, tsəgha na, kala zhəghəti ghən tsa ghwəy pə ghwəy nja ndərazhi jəw jəw niy, ka dza ghwəy mbəə tsəhəŋwəy mbə mbəzli sləkə Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ntsaa dzaa zhəghəti ghən tsa ci jəwə nja zəghwə nay, ghəci dza naa gwəra dikə mbə mbəzli sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya wa ntsaa dzaa kaꞌwəti zəghwə jəwə nja sasa tə mbərkə kwəma yay, yən dəꞌwə ghən tsee na sa kaꞌwəti na va tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma kə Yesəw ɓa na: «Ya wa ntsaa dzaa mənti shiy ngəɗi mbəzliy təhəshi ma ni ndara nefer shi, dza mbaꞌa ghəshi shikəshiy dzəmbə məni kwəma jikir nay, a ngəraꞌwə taa nza kən tsava ndə. Wəzəɓa pəhanaghwa məndi vəna kwa wəri ci, mbaꞌam tsəkwati tə hwər kwəfa, mbaꞌa mətiy dza naa favə kən kwəmaa dzaa nza kən. ");
INSERT INTO bcw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kataŋ nanzə kiy mbəzliyay, mbə kwəma na mbəzli tə hiɗi. Va sa nzanay, ya hwəmɓa nzə na, war lə shiy həərəpə dzəmbə məni kwəma jikir na na tiɓa. Ta na niva shiyəy, ka bashi nza ghəshi tiɓa ya hwəmɓaw. Ma nanzə kiy, a ngəraꞌwə dzaa nza tərəŋw kən ntsaa dza vaa titəvay ta məni shiy ngəɗi mbəzliy dzəmbə kwəma jikir na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ma kə kwa fir na: «War mbaꞌa kə dəvə gha, ya nahwəti səɗa ghaa fəŋaa dzəmbə məni kwəma jikir nay, sla pə gha slanti, a gha ndəghamti kərakə. Sa nzanay, wəzəɓa kwəmavə gha piy tsa slar tsa va Hyala, lə dəvə gha kwətiŋ na, ya lə səɗa kwətiŋ na, kən na dza məndiy ndəghambəŋa mbə ghwəə kəɗi ma, lə shi gha bakanashi. ");
INSERT INTO bcw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mbaꞌa kə nahwəti mətsə ghaa ngəɗiŋaa dzəmbə məni kwəma jikir nay, lamti kwa ghən gha, a gha ndəghamti kərakə. Sa nzanay, wəzəɓa kwəmavə gha piy tsa slar tsa va Hyala, lə mətsə kwətiŋ na, kən na dza məndiy ndəghaŋaa dzəmbə ghwəə kəɗi ma, lə mətsəhi gha bakanashi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ma kə Yesəw kaa mbəzli ta səɗa ci diɓa na: «Məni tə ghwəy məhərli, vantaa ghwəy dzaa fə ndərəə dzəti tsahwəti ya kwətiŋ mbə mbəzli daw daw bərci ni. A gəzaŋwəyee, mbə ndəghwəshi na ka kwal Hyalahi shi kwa kwəma Dirə tsa mə ghwəmə ya hwəmɓa nzə. ");
INSERT INTO bcw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sa nzana, yən yən Zəghwə yakə ndə ngəriy, ta mbəli niy zashi mbəzli səəkəree tikə tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A nə yay, njaa na va ghwəya? Ya ndə nza mbaꞌa teŋkesli ci və bələkwə, dza tsahwəti mbaꞌa zay kwətiŋ mbə shi na, nza zlashi ni məsliɗə mətsəkə məsliɗəti ni va tiɓashi ni mə ɗal pi, ka dzay ta pala tsaa zay va kwətiŋ tsa sa? ");
INSERT INTO bcw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E gəzaŋwəy ya, ta na navay, tsəgha na, ma sa ka na dza, mbaꞌa kəsay sa ciy, tərəŋw dza naa vəshiy, ta təmbəkə tsa ci va kwətiŋ tsa. Tərəŋwɓa ti kaa ni ɗaŋ ni va niy zashi ma. ");
INSERT INTO bcw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ava tsəgha ɗi ma Dəŋwəy Hyala mə ghwəmə tsahwətiy zay ya kwətiŋ ta mbəzli daw daw bərci ni va nəwvə kwəma ci ki» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Zhini ma kə diɓa na: «Mbaꞌa kə zəməŋa tsa mbə nəw Yesəw məntəŋa *kwəma jikir nay, mbala harvə a gha gəzanciy dzəkən kwəma va, ghwəy bakə bakəŋwəy li. Ma sa ka na dza mbaꞌa yivə, “Tsəgha na kataŋ, vəya na fəti” kəy, a gha zhəghəkəə dzəghwa kwal Hyala tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma mbaꞌa kə kala ɗi fəti ta kwəma gəzanci gha vay, mbala harvə, ya ndə kwətiŋ, ya mbəzli bakə kwasəbə gha. Nza ghwəy zhiniy gəzanci kwəma li shi. A ghənzə mbəə nza nja kwəma gəzəkə Zliya Hyala va. Sa nə na va: “Mbaꞌa kə kwəma dzətitaa dzəti ngwəvəy, mbəzli bakə, ya mahkan kə dzaa ndəghakə fəti kwətiŋ naa dzəkən kwəma va, ka məndi gha zləɓa” kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma sa ka na ɗi ma fəti ta na dza niva va mbəzliy gəzə kwəma ɓay, ɓasəŋwəyəm lə mbəzliy nəw Yesəw, a ghwəy gəzanci. Kala dza kəə di fəti ta kwəma dza ɓasəva tsa mbəzliy nəw Yesəw gəzanci diɓa kiy, mbaꞌa gha zlay, ka nighə war lə mətsə. Njasa nza naa ndə ta mbəri lə nja ndə *dəwan gha ɓəti ghalaɓa. ");
INSERT INTO bcw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","E gəzaŋwəy na kataŋ nay, mbaꞌa pə ghwəy pəhəti shiy, ta mənishi mbəzli tikə tə hiɗiy, tsəgha dza ghəshiy nza va Hyala mə ghwəmə kwərakwə. Ma ni pəhəti ghwəy, ka mənishi məndiw, pə ghwəy diɓa na, tsəgha dza ghəshiy nza va Hyala mə ghwəmə kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Zhini ɓa, e gəzaŋwəyəy, war dzəghwa mbəzli bakə mbə ghwəy tə hiɗi, mbaꞌa ghəshi yəməti miy tsa shi kwətiŋ ta kwəma ɗi ghəshi ɗəw mbə cəꞌwəy, ta ɓanavəshi shi ɗəw ghəshi va dza Dirə tsa mə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Va sa nzanay, war tə pətsa ɓasəshi mbəzli va gar bakə, ya mahkan mbə slən tseyey, war tiɓa nzee mbə shi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ꞌWakəvə Piyer mbaꞌa kətəghəvay dzəvəgha Yesəw, ka ɗəw kwəma və, ma kə na: «A Ndə sləkəpə, ya zəmərə dza, mbaꞌa ɓəliti mənira *kwəma jikir na, war ka mənira, war ka mənira, gar ɗaŋ səɗay, gar hwəm səɗee təɓə na yən pəlanay kwəma jikir na mənira na va mbə nəfə tsee tay? Gar mbərfəŋ səɗee ta naa, naa njaa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma kə Yesəw kaa zləɓanci na: «Əŋ, əhəŋ, gar mbərfəŋ səɗa dza naa nza gwaꞌa tsəghaw, mbərfəŋ mətsəkə, gar mbərfəŋ səɗa ghaa pəlay mbə nəfə gha. ");
INSERT INTO bcw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Vanɗa taa gəzaŋa kwəma va njasa məniva na mbə mbəzli sləkə Hyala. Yəm na lə kwəma tsahwəti mazə, lə ka ghəra sləni ci, mbaꞌa niy ɓanavəshi gəna kaa mbəzli va ta sləni. Dza na tə nahwəti vici na, mbaꞌa harashi mbəzli va ta ɓəlanati gəna ci ghəra ghəshi sləni li. ");
INSERT INTO bcw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dzəghwa sa ghati na ɓəla gəna va na, mbaꞌa məndi pəmanakə tsahwəti ntsa nza gəna ci və gar mələyaŋw ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma ntsa va na, shiy və gar wati gəna vaw. Dəghwa ma kə ntsa ghəranci na va sləni na: “Ma ghənzə tsəghay, wəzəɓa dza məndiy pamti səkəm na tə ntsa, ghəshi lə mali ci, lə ndərazhi ci, mbaꞌa ni ci shi və gwanashi. Ghalaɓay, aa dzaa mbay watəra təm tsee va” kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ma sa gəzəkə ntsa va tsəgha na, dza zal tsa va, gələɓ gələɓəy tə shinin ci kwa səɗa ndə gəna tsa ghəranci na va sləni, ka cəꞌwə və. Ma kə na: “A ntsee dikə tsa, titihwə, yaŋ pə gha na gha, kadiw ndəghətəra. Ta wavəŋa sa gha dzee dza gwanata” kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dzəghwa ntsa ghəranci na va sləni mbaꞌa zhəti hwər ti, mbaꞌa pəlay mbə nəfə ci, mbərəkə zlatanavə gəna va gwanata. ");
INSERT INTO bcw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ma dzəghwa ndə sləni tsa pəlay məndi va sa səvəriy na tə ngwəla na, bəgəm ghəshi lə tsahwəti ntsa ka ghəshiy ghəra sləni li. Ma ntsa va na mbaꞌa niy ɓəvə təm və, gar mbəl bələkwə kwətiŋ. Dza na tasl kəsəti ntsa va ta na ci va gəna, ka mətsərɗi ta wəri tsa ci. Ma kə ngəci na: “Ə pə gha wavəra gənee va sənzənva” kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dzəghwa tsava ndə sləni kwərakwə ki, gələɓə gələɓəy tə shinin ci kwa kwəma ci. Ka cəꞌwə və, a kə na: “A ntsee, titihwə yaŋ pə gha na gha kadiw ndəghətəra. Ta wavəŋa gəna gha va dzee” kə. ");
INSERT INTO bcw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Awə, war sənzənva ɗee ghaa wavəra see” kə. Dza na, na naci mbaꞌa dzaa kalaghwa ntsa va kwa fərshina, paꞌ fəca vici dza naa wanavə gəna ci va. ");
INSERT INTO bcw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma sa nata nihwəti mbəzli ka sləniy tərmbə kwəmaa mənta va tsəgha na, mbaꞌa nəfə tsa shi satiy tərəŋw tərəŋw dzəkən ntsaa zhəhwər ma va. Dza ghəshi cəkeꞌ ghəshi dzaa slanakə kwəma va kaa ntsa ghəranci ghəshi va sləni. ");
INSERT INTO bcw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sa favə ndə gəna tsa ghəranci ghəshi va sləni ki na, dza na daꞌ ghəci haray ndə ghəra sləni ndə ndərəm tsa va. A kə ngəci na: “A ta gha gha tsatsa ndəy, ndə ndərəm ndə nza gha. A gha nay, sa pəraꞌwəra gha dəvəy, gwanata zlataŋee gənee va niy nza va gha. ");
INSERT INTO bcw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sana kiy, a gha niy təɓəə mənti zhəhwər ta ntsa nza ghwəy tsa li kwa zərə kwətiŋ na, njasa məntəŋee va kwərakwə” kə kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dza na tərəŋw ghəci ɓəti nəfəə dzəkən ntsa va, tə mbərkə kwəma mənti na va. Mbaꞌa kəsaghwa kwa fərshina, nza ghəci nza kwa kwərakwə, paꞌ fəca vici dza naa wanamti na ci va gəna gwanata» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zhini ma kə Yesəw diɓa ki na: «Favə tə ghwəy! Kala dza pə ghwəy pəli mbəzli mbə nəfə tsa ghwəy lə nəfə kwətiŋ, ghəshi kə məntəŋwəy kwəma jikir nay, ava war tsəgha dza Dirə tsa mə ghwəməə məniŋwəy kwərakwə ki, njasa mənti ndə gəna tsa va va kaa ndə ghəra sləni tsa ci va» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ma sa kəɗamti Yesəw ɓəni shi va kaa mbəzli ki na, dza na mbaꞌa ɓarvay tə hiɗi ka Galile, ka dzay dzəti hiɗi ka Zhəwde, pəri na pəriɓa bəla həl Zhərdeŋ. ");
INSERT INTO bcw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mbaꞌa mbəzli ɗaŋ nəwvə. Dza na mbaꞌa mbalamtishi gwanashi va zəleghwer shi. ");
INSERT INTO bcw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dzəghwa *ka Farisahi, mbaꞌa ghəshi səəkəshiy dzəvəgha Yesəw ta ɗəw kwəma və, ta nighə kwəma ci, ma kə ghəshi ngəci na: «Ɓanavə kwal *kwəma pəhəti *Məyizə kaa ndə ta tihə mali ci, ghənzə kə mananati kwəma ya namaɓa na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma kə Yesəw na: «Njaa na kwəma gəzəkə məndi mbə zliyaa dzəkən kwəma vaa, səəkə ghwəy jangəhwə sa? Ma kəy: “Kwa taŋ taŋəy, ngaꞌ ngati Hyala zal ghəshi lə mali” kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dzəghwa, a kə diɓa na: “Ava va tsəgha dza zal ɓarvay vəgha kar dəy lə mbəghəy, nza ghəshi dzaa jakəshi lə mali ci. Ma nza ghəshi bakanashi mənishi ka vəgha kwətiŋ” kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mbaꞌa kə tsəgha kiy, mbəzli bakə na ghəshi ghwəla kiw, vəgha kwətiŋ na sa shi. Ghənzə tsəgha kiy, əntaa ndə ngəri təhəvəri shi jakəti Hyala ma» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma sa favə ka Farisahi tsəgha, ma kə ghəshi na: «Yaŋ, ya sa nzana tsəghay, tawa nə Məyizə, mbaꞌa kə ndəə ɗi tihə mali ciy, a kwal va ndə, tsaslanavə ma ndə zliya kaa ngəta ta dəvə nzə, kə shiki?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma kə Yesəw na: «Wa ma kwəma ɓəŋwəy Məyizə kwal ti ta tihə miꞌi ghwəy ghwəy lə zliyay, sa nzana caslakə ghən tsa ghwəy, kala zləɓa ɗi fəti ghwəy ta nəw kwəmaa gəzəkəvata na. Ma ghala kwataŋatay, niy nza gəla nava kwəma tiɓa tepəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na nee nee e gəzaŋwəyəy: War mbaꞌa kə ndə təhamti mali ci, kala mənti ghwərghwər ghənzə, dza mbaꞌa ɓəvə nahwəti maliy, a ntsa va mənti ghwərghwər» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ma sa favə mbəzli ta səɗa ci kwəma va tsəgha, ma kə ghəshi na: «Əy, ma ghənzə tsəgha, war tsəgha kə kwəma kən nzəy tsa kar zal lə mali na, wəzəɓa maw ma məndiy ɓəva na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma kə Yesəw na: «Ma gəla nana kwəmay, mbəzli gwaꞌa dza naa mbay favəw. War mbəzli ghwənanamtishi Hyala məhərli shi, na shiy dzaa mbay favə. ");
INSERT INTO bcw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta na nava e gəzaŋwəyəy, shiy ghənghən ghənghən na shiy makə zhər va ɓə miꞌi. Nihwəti zhərəy, ghala yakəshi məndi na məti məti kwala shi, va tsəgha ɓə ma ghəshi miꞌi. Nihwəti na, va sa nzana mbaꞌa məndi tsaꞌwamtishi, nihwəti ɓa na, kala ɗi ɓəva ghəshi, sa ɗi ghəshi ghəra sləni kaa Hyala lə nəfə tsa shi kwətiŋ, nza Hyala sləkə mbəzli tikə tə hiɗi. Ma ntsaa ɗi zləɓavə kwəma vay, nza ghəci zləɓa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dzəghwa nihwəti mbəzli mbaꞌa ghəshi ɓanakə ndərazhi kaa Yesəw, a ghəci fakən dividivi ci kən shi, ta cəꞌwə Hyala ti shi, dza *mbəzli ta səɗa Yesəw, ka makə mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma kə Yesəw sa nashi na ghəshiy makəshi na: «Ka makəshi ghwəy ma, zlashim ndərazhi jəw jəw ni va, a ghəshi sar dzəvəghee. Sa nzanay, gəla mbəzli nja ghəshi na shi sləkə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dza na mbaꞌa fanakənshi dividivi ci, ta təfanshi miy. Ləy hwəm ki na mbaꞌa ɓarvay tə tsava pi, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma tə nahwəti vici na, ndəs tsahwəti ndə səəkəy dzəvəgha Yesəw. A kə ngəci na: «A Metər, wa shi dzee mənti wəzə ni kee kwəmavə piy tsaa kəɗi ma tay?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma kə Yesəw ngəci na: «A nava ɗəw gha kwəma wəzə na, ta məni vəya? Ma ntsa wəzə tsay war Hyala na kwətita. Mbaꞌa pə ghaa ɗi kwəmavə piy tsaa kəɗi may, nəw pə ghaa nəw kwəma gəzəkə *kwəma pəhəti Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma kə ntsa va kaa Yesəw na: «Gəla nama hwəlfə kwəma pəhəti Hyala kee nəw kia?» kə. Ma kə Yesəw ngəci na: «Saa ni vay, ka pəəsli ndə gha ma, ka pəla mali ndə gha ma, ka ghəli gha ma, ka təɓə dzərvə ghaa dzəkən ndə ma, ");
INSERT INTO bcw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ə pə ghaa haꞌwə tə kar dəŋa lə məŋa, ka ɗi nihwəti mbəzli gwanashi njasa ɗi gha va ghən tsa gha kwərakwə, kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma sa favə məgəla ndə shiy tsa va kwəma va, ma kə na: «A Metər shi ɓəlakə gha niy, gwanashi nəwamtishee. Nana kiy wa shi kee zhiniy məni diɓa kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","«Mbaꞌa pə ghaa ɗi məniŋa ka ntsaa kərkamti kwəmay, mbala pamti səkəm tə shi va gha, a gha tahanavəshi gəna va kaa ka ndərma, nza gha səəkə ta nəwra. Ma ghalaɓa kiy, ta kwəmavə shiy gwəramti dza gha mə ghwəmə» kə Yesəw ngəci. ");
INSERT INTO bcw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","War sa favə ntsa va kwəma gəzəkə Yesəw va tsəgha na, ka zhanci nəfə tsa ci tərəŋw. Dza na ka dzay lə nəfə lə nəfə, sa nzana ndə shiy tsa tərəŋw tsa ghəci. ");
INSERT INTO bcw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dzəghwa ma kə Yesəw kaa mbəzli ta səɗa ci ki na: «E gəzaŋwəy ya, ta na navay, tsəgha na, ngahə na va ndə shiy ta tsəhə ghəci tə pətsa sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Vanta nahwəti kwəma gəzaŋwəyee diɓa: Ɓəlaŋɓa ngaləwba dza naa dzəvərita kwa kwal batal cisli shiy, kən dzəti pətsa sləkə Hyala va ndə shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ma sa favə mbəzli ta səɗa ci nava kwəma na, mbaꞌa səəvəri məhərli shi. Tapə ghəshi dzəmbəshi mbə ɗəɗəw kwa jipə shi, a kə ghəshi na: «Əy war tsəgha kə kiy, wa ntsaa dza vaa mbəliy kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dzəghwa Yesəw naci, tsaꞌ nighətishi. A kə kaa ngəshi na: «Kwəma vay, ka mbay mbəzliy məntiw, ma na Hyala nanzə kiy, aa mənti. Sa nzanay, shiy tiɓaa taŋanati bərci kaa Hyalaw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A kə Piyer ngəci na: «A Ndə sləkəpə, ghəy sana kiy, avanay gwaꞌa gwaꞌa zlashi ghəy shi ghəy mbaꞌa ghəy nəwvəŋa. Ya sa nzana tsəgha kiy, zhəmə njaa na dza ghəy kwəmavə na ghəy kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma kə Yesəw ngəshi na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, fəca vici dza Hyalaa mənti yəwən hidiy, ta nzəy dzee, yən Zəghwə yakə ndə ngəri kwa gəzli mazə diɓədiɓə na. Ma fəca vay, ghwəy ghwəy mbəzli məŋ lə bakə ni ni nəwvəra na, ta nzəy dza ghwəy dza kwərakwə kwa gəzli gəzli mezhizhə məŋ lə bakə. Nza ghwəy sla ngwəvəə dzəkən mbəzli mbə takəhi məŋ lə bakə ni va mbə hwəlfə ka *Izərayel. ");
INSERT INTO bcw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E gəzaŋwəyəy, ya wa ntsaa zlay ghi tsa ci, ya ngwarməhiyəy zhər lə ghyehi gwaꞌa, ya kar dəy lə mbəghəy, ya ndərazhi yakə na, mbaꞌa veher ci gwaꞌa, war ta ghəraɗa sləniy, kwa kwəma jəw na ta kwəmavə shi ci va dza na tsəgha, gar bələkwə səɗa. Zhini mbaꞌa dzaa kwəmavə piy tsaa kəɗi ma diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mbəzli ɗaŋ mbə ka ꞌwa kwəma kaa mbəzli sanay, ka mbəzli ləy hwəm dza ghəshiy zhəghəshi. Ma ni ləy hwəm mbəzli sana na, mbaꞌa ghəshi zhəghəshi ka mbəzliy ꞌwa kwəma kaa mbəzli» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Dzəghwa ma kə Yesəw ɓa na: «Avee dzaa gəzaŋwəy shi yəməva sləkə tsa sləkə Hyala mbəzli li shi» kə. Ma kə na: «Yəmyəm na lə kwəma tsahwəti ndə za niy maɗiy na mekəshi mekəshi, ta pala ka sləni ta ghəranci sləni mbə za ci. ");
INSERT INTO bcw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dza na mbaꞌa kwəmavə mbəzli. Ma sa kwəmavəshi na na, “Mbəl mbəl dza ghaa waŋəy mbə vəghwə, njasa ka məndi vaa wa ndimndim kaa ka sləni” kə mbəzli va ngəci, “tsəgha na, e zləɓavə waŋwəy tsəgha” kə kaa nghəshi. Sa sləkamti ghəshi na, dza na mbaꞌa pəmashiy dzəmbə za ci ta ghəra sləni ghəshi ki. ");
INSERT INTO bcw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zhini ndə za tsa va ɓa, mbaꞌa zhəkəvəriy ta pala nihwəti mbəzli geꞌi lə tsahi məsliɗə. Ma dza na na, nihwəti mbəzli garə garə dzar tə ləwma gəmshi, kala shi məni ghəshi tiɓa. ");
INSERT INTO bcw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma sa nashi na, a kə kaa ngəshi na: “A mbəzli ni, ndim dzamməm, a ghwəy dzaa ghəraɗa sləni mbə zee kwərakwə. E taa wavəŋwəy zhəmə ghwəy njasa dza naa təɓə” kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsəgha na, kə mbəzli va, ka maɗi tsəgha ta ghəranci sləni ci va. Zhini na diɓa, mbaꞌa zhəkəvəriy geꞌi geꞌi vici kwa ghən. Səvəri na na, mbaꞌa kəsashi nihwəti mbəzli gəm shi diɓa. Dza na mbaꞌa zhiniy pəmashiy dzəmbə za ci va. Zhini na diɓa, mbaꞌa zhəkəvəriy geꞌi geꞌi lə tsahi mahkan, mbaꞌa zhiniy kəsashi nihwəti mbəzli ɓa, mbaꞌa pəmashiy dzəmbə za ci va. ");
INSERT INTO bcw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Zhəghwa na diɓa ki, mbaꞌa zhəkəvəriy geꞌi lə tsahi cifə. Dza na mbaꞌa kəsashi nihwəti mbəzli garə garə tə ləwma diɓa, war gəmshi kala shi məni ghəshi tiɓa. Ma sa nashi na na, dza na tapə ta ɗəw kwəma və shi, ma kə na: “Wa navam, vəghwə ghwəy tikə gəmŋwəy kala sləni ghəra ghwəy tiɓa shəka?” kə ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ma kə mbəzli va na: “Waa ndə tiɓaa ɗəwhwəŋəy ta sləniw, va tsəgha vəghwə ghəy tiɓa tsəgha” kə ghəshi. Ma kə ndə za tsa va na: “Ndim dzamməm a ghwəy dzaa ghəraɗa sləni mbə zee” kə. Mbaꞌa mbəzli va nəwvə ta ghəranci sləni ci va. ");
INSERT INTO bcw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dzəghwa vici ki mbaꞌa pəkwəta. Sa pəkwəta vici na, dza ndə za tsa va, daꞌ harvə ntsaa ghəranci sləni kəghi tsa ci. A kə kaa ngəci na: “Harkə mbəzliy ghəra sləni va, a gha wanshi gəna tə sləni shi. Kaa mbəzliy kəray vaa dza ta sləni pə gha taa gha wa shiy, nza gha kəray tə niy ꞌwa vaa ghəra sləni va” kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dzəghwa ka sləni va mbaꞌa ghəshi ɓasəshi ki. Tapə məndi mbə wanshi gəna shi. Dza niy kəray va mbəzliy dza ta sləni geꞌi geꞌi lə tsahi cifə, təhwə ghəshi səəkəshi, mbaꞌa məndi wanatishi gəna shi. Ya wa ndə mbə shi na, mbəl mbəl məndi wanavə. ");
INSERT INTO bcw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dzəghwa niy ꞌwa vaa dza ta sləni mbəzli ghala mekəshi, ndəs ghəshi səəkəshi. Ma kə ghən tsa shi na: “Ɗaŋ dza ghəy kwəmavə shiy ka taŋəti mbəzli ni ghəy niy vəghwə mbə sləni ɓasa” kə. Ma dzəghwa məndi na, mbəl mbəl məndi wanavəshi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma sa ɓəvə ghəshi gəna va mbaꞌa ghəshi nata na, tapə ghəshi ta ngwəzliməə dzəkən ndə za tsa va, ");
INSERT INTO bcw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a kə ghəshi na: “Shi ka wa na gəla ni məntəŋəy gha ni shiy shəkaa ntsa ghəy dikə tsa? Mbəzli niy, ghəshi kəray naa səəkə ta sləni, war ler kwətiŋshi ghərahwə ghəshi sləni gwaꞌa tsəgha. Na na ghəy kiy, ghala mekəshi ꞌwati ghəy sləni, vəghwamti ghəy mbə vici vici vici, war ə viciy ndindiŋəy, kwəp kwəp ghəy dalantəvaŋəy. Njaa njaa ka gha waŋəy gəna yəmyəm li shi kia?” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dzəghwa ma kə ndə za tsa va kaa zləɓanci kaa tsahwəti ndə mbə shi kwətiŋ na: “A madiga, a madiga, na na yay, ngəɗitəŋa yaw. Niy ꞌwa ghaa ghəraɗa sləniy, a ghwəm niy sləkamti kwəma, mbaꞌa gha niy zləɓavə yən ɓəŋa mbəl tə vəghwə tsa gha mbə sləni. ");
INSERT INTO bcw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Njanaa niy sləkati ghwəm tsəghay, ə pə ghaa ɓə zhəmə gha, a gha dzaa jighi. Wa yən ɗi na wanavə shiy tsəgha kaa ntsaa kəray vaa səəkə ta sləni yəmyəm lə gha. ");
INSERT INTO bcw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ə nzana kala kwal vəya ta məni shi ɗee lə gənee ki shəkəna? Naa ə ghəraŋa hərhə sa mənee wəzə hwər na pən?” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zhəghwa, ma kə Yesəw ki na: «Ava war tsəgha dza naa nza kwərakwə ki, ni ləy hwəm shi ni mbəzliy, ka mbəzli tə kwəma dza ghəshiy zhəghəshi. Ma ni tə kwəma mbəzli na, ka mbəzli ləy hwəm ghəshi taa zhəghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dzəghwa Yesəw mbaꞌa kafəy ka dzay dzəmbə məlmə Zherəwzalem. Ma ghəci mbə kwal na, dza na mbaꞌa harvə mbəzli ta səɗa ci va məŋ lə bakə ni jaꞌ jaꞌ vəgha bəla. Kə ka gəzanshi kwəma, ghəci mbə dza li shi, a kə na: ");
INSERT INTO bcw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Favə tə ghwəy, e gəzaŋwəy kwəma: Avanammə mbə kwal sana ta dzəmə məlmə Zherəwzaleməy, mbəɓa dza mbəzli ta fambəra, yən yən Zəghwə yakə ndə ngəriy dzəmbə dəvə mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala. Ka ghəshi dza na mbaꞌa ghəshi ɓasakənɗa ngwəvəə pəəslira. ");
INSERT INTO bcw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mbaꞌa ghəshi dzaa fambəra mbə dəvə *mbəzliy kamaa ka Zhəwifə. Ka ghəshi dza na, ka tsəərəɗa, ka dəꞌwəra lə kwərpə. Ma ləy hwəm ki na, ka ghəshi dza daŋwə daŋwavəghara vəgha tsəm, mbaꞌee dzaa mətira. Ma sa kee mətiray, ta zhakatira dzee dza mbə məti tə kwa mahkana vici» kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dza mali Zhebede kət kətikəvataa dzəvəgha Yesəw ghəshi lə ndərazhi nzə, kar Zhakə lə Zhaŋ. Dza na tsəfəkwə tsəfəkwəta kwa kwəma Yesəw, ta cəꞌwə kwəma və. ");
INSERT INTO bcw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma kə Yesəw ngəta na: «A shi ɗi gha vəya?» kə. Ma kə mali va na: «Ghala vəghwə tsa dza ghaa nza mbə sləkə mbəzliy, nza gha ɓəvə ndərazhee ni, ta nzəy vəgha gha, mbaꞌa tsahwəti tə kwa bəzəmə gha, mbaꞌa tsahwəti tə kwa zleɓi gha. Ghənzə na kwəma ɗee ghaa zləɓavə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma kə Yesəw ngəshi na: «Ma ghwəyəy, sənashi shi ɗəw ghwəy ni ghwəyəw. A pənəy, ka dza ghwəy mbay səꞌwati ngəraꞌwə tsa dzee tsa ta sa na?» kə. «Ta mbay dza ghəy səꞌwati» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma kə Yesəw na: «Yaŋ, tsəghaa nava nanzə kataŋ. Ta sa ngəraꞌwə tsa dzee va ta sa dza ghwəy kwərakwə. Ə na na nzana kiy, yən dza naa bərkə na, tsatsa ndə dza naa nza tə kwa bəzəmee, tsatsa tə kwa zleɓee pənəw. War mbəzli gwəmanatishi Dirə va pətsa va kaa ngəshiy, ghəshi dza naa nzəy ti» kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ma sa favə niy tərmbə va məŋ ni *mbəzli ta səɗa Yesəw kwəma va na, gha ghəshi ghati ɓə nəfəə dzəkən kar Zhakə ghəshi lə Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dzəghwa Yesəw ki mbaꞌa ɓasayshi gwanashi. Ma kə ngəshi na: «A mbəzlee, a ghwəy sənay, mezhizhə tə hiɗiy, lə gwəlaŋ sləkə ghəshi mbəzli. Mbəzli dikə dikə ni kən shi kwərakwə ɓa na, ka məni kwəma lə bərciy dzəkən shi. ");
INSERT INTO bcw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ghwəy ta na tsa ghwəy ghən na ghwəy kiy, əntaa ghwəy dzaa kəli ghən tsa ghwəy nja mbəzli va ma. Ə gəzaŋwəy ya, mbaꞌa kə ndəə ɗi məniy ka ntsa dikə tsa mbə ghwəyəy, ə kə zhəghəti ghən tsa ci ka ndə ghəraŋwəy sləni tsa mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mbaꞌa kə ndəə ɗi məniy ka ntsaa ꞌwa kwəma ngəŋwəyəy, ə kə zhəghəti ghən tsa ci ka mava tsa mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ava tsəgha nzee, yən Zəghwə yakə ndə ngəri sana. Sa səəkəree na, nza mbəzli ghəraɗa sləni səəkə yaw. Ta ghəranshi sləni kaa mbəzli səəkəree. Kee dza na, mbaꞌee zlay piy tsee, ka mətira, ta mbəərə mbəzli ɗaŋ, nza ghəshi kwəmavə piy tsaa kəɗi ma» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dzəghwa kar Yesəw lə *mbəzli ta səɗa ci, mbaꞌa ghəshi maɗishi ta səvərishi mbə məlmə Zherikwə. Ma ghəshi mbə səvəri na, dza mbəzli ɗaŋ ka nəw Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ghalaɓa na, mbaꞌa nihwəti ghwəlefesli niy nza tiɓa bakə, mənzəy vəgha kwal. Dzəghwa mbaꞌa ghəshi favə gaka. Ma sa favə ghəshi gaka na, dza ghəshi ka ɗəw kwəmaa mənta. Ma kə məndi ngəshi na: «Wa Yesəw na saa dzar» kə məndi. Dza ghəshi tsəgha ki, ka zlapanci kwəma, a kə ghəshi na: «A Ndə sləkəpə, Jijiy mazə *Davitə, mənti zhəhwər tə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dzəghwa mbəzliy ɓasəshi va, ka naɓəshi, a kə ghəshi na: «A ghwəlefesli ni, kalayəm miy tsa ghwəy va» kə ghəshi. Zhəghwa ghwəlefesli nashi ki, mətsəhə ghəshi zhiniy mətsahata zlapə kwəma: «A Ndə sləkəpə, Jijiy mazə Davitə, mənti zhəhwər tə ghəy na gha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ꞌWakəvə Yesəw tsəgha gar garəy, dza na daꞌ harashi, mbaꞌa ghəshi səəkəshi. Sa səəkəshi ghəshi, ma kə Yesəw ngəshi na: «A shi ɗi ghwəy yən məntəŋwəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma kə ghwəlefesli na: «A Ndə sləkəpə, war mərshi ma ghaa ɗiweŋamtəŋəy mətsəhi ghəy, nza ghəy nay pi, na sa ɗi ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dza Yesəw mbaꞌa mərshi li shi, kə dapə dapə dadapashi mətsəhi shi. Dzəghwa nzaꞌjəw mətsəhi zhər bakə ni va ɗiweŋəshi tsəgha, ka mbə ghəshiy nay pi ki. Dza ghəshi ka nəw Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma kar Yesəw lə mbəzli ta səɗa ci ndəkwə ndəkwə lə məlmə Zherəwzalem na, mbaꞌa ghəshi tsəhəshi ndəkwə lə nahwəti məlmə, Betəfazhe slən tsa nzə. Ndəkwə ghənzə vəgha kəlaŋ tsa har məndiy kəlaŋ *ꞌWəlivə. Dza Yesəw mbaꞌa ghwənashi mbəzli bakə mbə mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A kə ngəshi na: «Mbalam dzəmbə məlmə tarɓa va kwa kwəma ghwəy. Sa ka ghwəy tsəhəŋwəy mbəy, ta kəsata kwantəmca dza ghwəy dza pəhəpəhə tə zəꞌwə, ghəshi lə zəghwə nzə. Sa ghwəy dzay, nza ghwəy pəlikəvərashi. ");
INSERT INTO bcw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mbaꞌa kə ndəə ɗəw va ghwəy: “Tawa pəəlishi ghwəya?” kəy, “waa Ndə sləkəpə ɗəwshi na” pə ghwəy dzaa ni. Nzaꞌjəw dza naa zlatavəŋwəyshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ma mənishi shi va tsəghay, war ta mbə kwəmaa niy gəzəkə ndə Hyala va mbəradzəə dzəghwata kwa. Ma kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gəzanshim kaa mbəzli mbə məlmə *Shiyaŋw: Ava Mazə tsa ghwəy səəkə, jəwə zhəghəti ghən tsa ci, ɗallə mə kwantəmca, ma ɗi naa gəzəy, zəghwə kwantəmca, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma sa gəzanakə Yesəw kwəma va kaa mbəzli ta səɗa ci va ki na, mbaꞌa ghəshi dzashi. Mbaꞌa ghəshi dzaa mənti war njasa gəzanakəshi na va. ");
INSERT INTO bcw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mbaꞌa ghəshi pəlanakəvə kwantəmca va lə zəghwə nzə va. Sa pəlikəshi ghəshi na, dza ghəshi pəliꞌ pəliꞌ ghəshi palati kwəbeŋer kən ghən shi tə hwəm kwantəmcici va. Dzəghwa Yesəw mbaꞌa dzəməə nzəyəy ti shi. ");
INSERT INTO bcw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mbaꞌa mbəzli niy nza tiɓa tərəŋw. Dzəghwa ghəshi, pəliꞌ pəliꞌ ghəshi pə pələnəy kwəbeŋer shi kwa kwal. Ka ɓəɓəli kəslifi nihwəti, ka sləkashiy dzəghwa kwal, a ghəci dza ti shi. Ta fal, nja mazə tsa dikə tsa mənti mbəzli va shi va tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dzəghwa mbəzli mbə nəw Yesəw va lə niy ꞌwa kwal ngəci gwanashi, tapə ghəshi dzəmbəshi mbə ngwəmə lala, a kə ghəshi na: «ꞌWəsa kaa Hyala, ntsa dikə tsa na jijiy mazə *Davitə. Təfanati miy tsa nzə Hyalaa sləkəpə kaa ntsaa səəkəy tsa mbə slən tsa nzə. ꞌWəsa kaa Hyala dikə na mə ghwəmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma Yesəw mbə dzəmbə məlmə Zherəwzaleməy, pəlaŋ pəlaŋ pəlaŋ niy səvərishi mbəzli dzəti ngwəla. Dza ghəshi ka gəgəzə kwemer, a kə ghəshi na: «Wa slən tsa tsatsa ndə kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma kə məndi ngəshi na: «Waa *ndə gəzə kwəma Hyala tsa har məndi vaa Yesəw na. Səəkə mbə məlmə Nazaretə, tə hiɗi ka Galile səəkə na» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dza Yesəw ka dzay dzəmbə ciki Hyala. Dzəmbə na na, mbaꞌa kəsashi ka ɗəl shiy, lə ka pa shiy mbəɓa. Dza na cəkeꞌ tihəkəvərishiy dzəti ngwəla, kə dzəpə dzəpə dzədzəpamti tebelerhi mbəzliy mbəərə gəna, mbaꞌa gəzli gəzli nzəy mbəzliy ɗəl kwəkwər palayhi gwaꞌa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma kə kaa ngəshi na: «Ma kə məndi mbə Zliya Hyalay: “Ciki tseyey, ciki tsa dza mbəzliy cəꞌwəra mbə na” kə məndi. Ma dza ghwəy na ghwəy ki na, mbaꞌa ghwəy zhəghəti ka ləgwə ka ka ghəliy nzəy mbə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dzəghwa ghwəlefesli lə vədevəder mbaꞌa ghəshi kətəghəvashiy dzəvəgha Yesəw mbə ciki Hyala. Dza na mbaꞌa mbalamtishi. ");
INSERT INTO bcw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma sa nata mbəzli dikə dikə ni mbə *ka ta Hyala lə *ka ɓənipə kwəma pəhəti Hyala kwəma mənti Yesəw va maɗaŋa maɗaŋa na na, mbaꞌa nəfə tsa shi satiy. Dzəghwa ndərazhi ka gəzə kwəma mbəɓa zlaŋzlaŋ diɓa, ma kə ghəshi na: «Jijiy mazə *Davitə na ntsa dikə tsa, jijiy mazə Davitə na ntsa dikə tsa» kə ghəshi. Mbaꞌa nəfə tsa mbəzli va zhiniy satiy diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma kə ghəshi kaa Yesəw ki na: «Ca ki, favə gəla shi pəꞌwə ghəshi va gha tsəna?» kə ghəshi. Ma kə Yesəw ngəshi na: «Yə, gwaꞌa gwaꞌa favəshee. Ə səəkə ma ghwəy jangəhwə kwəma gəzəkə Hyala va mbə zliya nzə shəkəna? Ma kəy: “Ma ghay, gwaꞌa gwaꞌa ɓananavəshi gha fal slən tsa gha kaa ndərazhi, lə kaa vərenjeꞌwerta gwaꞌa” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sa gəzamti na kwəma va na, dza na mbaꞌa zlashi, ka səvəriy mbə ciki tsa va. Səvəri tsa səvəri na na, mbaꞌa ɓarvay mbə məlmə Zherəwzalem, ka dzay dzəmbə məlmə Betani, hi na mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ma way pi tə mekəshi na, mbaꞌa Yesəw maɗiy ta zhəghəvaa zhəmbə məlmə Zherəwzalem. Ma ghəci mbə kwal na, ka ghəranci ma. ");
INSERT INTO bcw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dza na mbaꞌa nay dəŋw bəzakə. Sa nay na na, kə ka kətivaa dzəvəgha, ta ngəli ya ti, ta zəmə. Tsəhə na na, kwataka kəslifi ghəci kəsashi gwaꞌa tsəgha, kala ya fə məɓa. Sa nata na tsəgha, ma kə kaa fə va na: «Gha na na ghay fə nay, gwaꞌa na na gha kwəma, ka zhini ghaa yahwə ya ghwəla ka gha nzaw!» kə. War sa gəzəkə na tsəgha na, hyaŋ dəŋw bəzakə tsa va ghwəliy. ");
INSERT INTO bcw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ma sa nata *mbəzli ta səɗa Yesəw nava kwəma na, ka mananshi maɗaŋa ghənzə. Ma kə ghəshi na: «njaa na nana kwəma tsətsə, ghwəliy dəŋw bəzakə tsa war nzaꞌjəw tsəghaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma kə Yesəw ngəshi na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, war mbaꞌa pə ghwəy ɓanavə nəfə tsa ghwəy kaa Hyala, kala mənti ghən tsa ghwəy ghwəy bakə bakəy, a ghwəy dzaa mbay mənti njasa məntee tsa lə fə na. Ya paꞌ ka taŋəti na məntee nay, ta mbay dza ghwəy. Ta mbay dza ghwəy gəzə ya kaa dəlagwa: “Ɓarvaŋa tə pətsa va mbalaa dzəghwa kwəfa!” pə ghwəy, ka ghwəy nighə na, dəlagwa va mənti war tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","War ɓanavə ma ghwəy nefer ghwəy kaa Hyalay, ya wa shi cəꞌwə ghwəy na, ta kwəmavəshi dza ghwəy gwaꞌa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dzəghwa Yesəw ka dzay dzəmbə *ciki Hyala. Sa dzəmbəy na na, dza na ka ɓananshi shiy kaa mbəzli. Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala, lə mətikwəkwər *ka Zhəwifə, kət ghəshi kətəghəvashiy dzəvəgha. Dza ghəshi ka ɗəw kwəma və, ma kə ghəshi kaa ngəci na: «A Metər, gəzaŋəy, kwəma səəkə ni gha ni bərci ghəra gha sləni gha na li shi tay? Wa ntsaa ndaŋa kwal ta ghəra gəla sləni naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma kə Yesəw ngəshi na: «Yən kwərakwəy, ta ɗəw kwəma dzee va ghwəy kwətiŋ. Mbaꞌa pə ghwəy zləɓakəra kwəmee vay, ma nzee gəzaŋwəy səəkə tə pətsa səəkə bərci ghəree va slənee na li shi. ");
INSERT INTO bcw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A nə ya kwərakwə kiy: Wa ntsaa ghwənay Zhaŋ ta mənipə *batema? Hyala shəkənaa, naa mbəzli?» kə. Ma sa gəzəkə Yesəw tsəgha na, dzəghwa ghəshi ka sləka kwəma kwa jipə shi, ma kə ghəshi na: «Njaa dza ghwəmməə ni kaa nana kwəma sana kia? Mbaꞌa pə ghwəmmə ni: “Hyala ghwənay na Zhaŋ” pə ghwəmməy, “ya sa nzana Hyala ghwənay na, tawa niy zləɓa ma ghwəy kwəma ci shiki?” dza naa ni ngəmmə. ");
INSERT INTO bcw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mbaꞌa pə ghwəmmə ni: “Mbəzli ghwənay na” pə ghwəmmə diɓa na, a hazləni ghwəmmə va ni gwaꞌa ni mbəzli. Sa nzanay, mbəzli gwanashi sənay na, Zhaŋ ka *ndə gəzə kwəma Hyala» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma kə ghəshi kaa zləɓanci ki na: «Sənay ntsaa ghwənay ghəyəw» kə ghəshi. Ma kə Yesəw ki na: «Ghənzə tsəghay, yən kwərakwə na, ka gəzaŋwəyee nda kwəma səəkə bərci ghəree ni sləni li shiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Dza Yesəw ka nəw lə gəzə kwəma ci naci ki, ma kə na: «Avee taa ɓəlikəŋwəy fir, nza ghwəy təkəə dzəkən: A tsahwəti ndə tiɓa, bakə ndərazhi və. Ma kə kaa tsa dikə tsa zəghwə ci na: “A zəghwee, dzəmti dza gha ta za ndatsə” kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma kə zəghwə va na: “A di, ka tsəhəree kwamtiw” kə. Zhini na ləy hwəm mbaꞌa zhəghanti zəzə kwəma, pəlhəm maɗiy, mbaꞌa dzay dzəmti va, ta za. ");
INSERT INTO bcw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dzəghwa didi tsa va mbaꞌa dzaa gəzanci kaa tsa jəw tsa zəghwə ci, war njasa gəzanakə na va kaa tsa dikə tsa va. Ma kə tsava na: “Wa yikwa, tsəgha na, ta dza dzee di” kə. Dzəghwa na dighevə nzəyəy, kala dza. ");
INSERT INTO bcw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sana sənzənva yən kəə ɗəw va ghwəyəy, mbə ndərazhi bakə ni va na, tsama zəghwə na tsaa ghəranati sləni ɗi dəshia?» kə Yesəw. «Tsa kwa taŋa va kia» kə ghəshi. Ma kə Yesəw ki na: «Ghəci na kataŋ. Ə gəzaŋwəy ya ki, ta na navay, tsəgha na: Pərɓa ka *dəwan, lə miꞌi mbə ghi ka ghwərghwər nashi ghwəy va dza naa tsəhəshi mbə mbəzli sləkə Hyala kən ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa wanay: Ndəs niy səəkəy Zhaŋ tsaa mənipə *batem ta ciŋwəy kwal Hyala, dzəghwa ghwəy na, kala ɗi ghwəy zləɓa na ci va kwəma. Ma ka dəwan, ghəshi lə miꞌi mbə ghi ka ghwərghwər va nashi ki na, mbaꞌa ghəshi zləɓavə, ka nəw kwəma ci va. Ya tsəgha niy nashi ghwəy mbəzli va zləɓavə, mbaꞌa ghəshi tsati titihwə tsa shi kwa kwəma Hyala na, kalaa niy ɗi zhəghanti nefer ghwəy ghwəy na na ghwəy, ta zləɓa kwəma ci va» kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zhini ma kə diɓa na: «Fam tsahwəti fir diɓa, a tsahwəti ndə ghi niy nza tiɓay, dza na ngwəɓə ngwəɓə ngwəɓati fəhiy zəmə tə vəh tsa ci. Dza na dəzlətsəɓə hayshi. Kə kaa kəꞌwə kwaɓa laꞌ lati, ta ɓəsə məəli ya fəhi va kwa. Dza na mbaꞌa ngati pi madzək tsa dza məndiy nzəy ta ndəghwə fəhi va mə. Dza na ki, mbaꞌa pəlavə mbəzli ta ndəghwə tsa va, mbaꞌa zlata mbə dəvə shi, mbaꞌa dzay ta wə. ");
INSERT INTO bcw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma sa mənəy vəghwə tsaa ngəli ya fəhi ki na, dza ndə tsa tsa va, ɓəŋ ghwənashi mbəzli mbə ka sləni ci, ta dza ghəshi va mbəzliy ndəghwə tsa ci va, nza ghəshi ɓanakə na ci bəla ya fə. ");
INSERT INTO bcw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma sa tsəhəshi mbəzli va na, dza mbəzliy ndəghwə tsa va nashi ki, mbaꞌa ghəshi pəslishi ti shi, tasl ghəshi kəsəvə tsahwəti mbə shi, dəꞌwə dəꞌwə ghəshi dəꞌwəti, mbəh ghəshi paslamti tsahwəti. Ma kwa mahkana ndə na, mbaꞌa ghəshi pəꞌwəy lə hərezli ka mbəri. ");
INSERT INTO bcw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dza ndə tsa tsa va kaa nihwəti mbəzli ɗaŋ tərəŋw, ka taŋəti ni kwa taŋa va, mbaꞌa ghwənəghəshi ngəshi diɓa. Zhəghwa war tsəgha mbəzli ka sləni kwa tsa va zhiniy sanamiy shi ngəraꞌwə kaa niva mbəzli diɓa, njasa niy sanamiy ghəshi va kaa ni kwa taŋa va mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dza ndə tsa tsa va tə kwa kərni, mbaꞌa ghwənanaghəshi zəghwə ci dəꞌwə ghən tsa ci. Ma kə mbə ghən ci na: “Sa ka ghəshi nay zəghwə yay, a ghəshi dzaa haꞌwə ti” kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dza zəghwə va mbaꞌa tsəhəy və shi ki. Ma kə mbəzliy ndəghwə tsa va kwa jipə shi, sa nay ghəshi zəghwə va na: “Yawaa, avanay ndə zəmə ghi səəkəy dəꞌwə ghən tsa ci ki. Dzammə ta kəsəvə, a ghwəmmə paslamti, nza ghwəmmə mbəərəhwə tsa ka sa ghwəmmə!” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dzəghwa ghəshi tasl, ghəshi dzaa kəsəti, ka mbahə səəmə kwa tsa vaa dzəti ngwəla. Sa mbahəkəmə ghəshi na, mbaꞌa ghəshi pəəsliti» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ma sa kəɗamti Yesəw fir ki, ma kə kaa mbəzli va na: «Njaa dza ndə tsa tsa vaa məni lə gəla mbəzliy ndəghwə tsa va tsəgha ni sa ka na səəkəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma kə ghəshi ngəci na: «Sa ka na səəkəyəy, rapə dza naa bakwamti ka ndərəm va, kala məni ma zhəhwər ti shi ya jəw nzə. Ka na dza na mbaꞌa fanambəshi tsa ci va mbə dəvə nihwəti ka ndəghwə tsaa dzaa mbay ɓanavə na ci bəla shiy, mbə shi dza ghəshiy ngəliti, sa ka na ɗəwshi, ghala pətsa dza vəghwə tsaa ngəli fəhiy məniy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma kə Yesəw ki na: «Səəkə ghwəy jangəhwə kwəma gəzəkə Hyala va mbə zliya nzə sa? Ma kəy: Ma hakwə tsaa niy ndəghamti ka ndəɓə shiy vay ghəci zhini naa zhəghəy ka hakwə tsaa gwəraa jihəti ciki. Hyala kwa Sləkəpə təravə na hakwə tsa vaa mənti ka saa gwəra tsəgha nanzə ki. Dzəghwa mbər ka kwəma maɗaŋa maɗaŋa na ghənzə mənta kwa mətsə ghwəmmə, kə Zliya Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Ma kə Yesəw diɓa na: «Ntsaa dzaa ɓati tərəə dzəti hakwə tsa vay, ta ɓəəlivərivay dza ntsa va. Ghəci kə tərakənvay kən ndə ɓa na, mbaꞌa zlərəvəri ndə. Ava va tsəgha zhinee gəzaŋwəy, ka dza ghwəy nza mbə mbəzli sləkə Hyala ghwəlaw, hwəlfə nihwəti mbəzli dza naa sləkə. Niva mbəzliy, ta ɗi fəti dza ghəshi ta kwəma nzə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə *ka Farisahi, pəŋw ghəshi famti fir tsa ɓəli Yesəw va. Mbaꞌa ghəshi fəti ghən: «Dzəkən ghəy ɓəli Yesəw fir tsa va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tapə ghəshi mbə pəla kwal tsaa kəsə Yesəw na, ka hazləni ghəshi va nihwəti mbəzliy ɓasəshi va. Sa nzana ka *ndə gəzə kwəma Hyala mbəzli va ɓəti Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Dzəghwa Yesəw diɓa, ka ɓəlanshi tsahwəti fir kaa mbəzli, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ma sləkə tsa sləkə Hyala mbəzli diɓay, ghala mbə lə kwəma dzee na ta gəzaŋwəyəw: A tsahwəti mazə niy nza tiɓa, dza na mbaꞌa tati shi zəmə tərəŋw, ta zəməshi, mbə pəhə mali kaa zəghwə ci. ");
INSERT INTO bcw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma sa gwəmantəvay na na, mbaꞌa ghwənashi nihwəti ka sləni ci, ta haka mbəzliy niy gəzanshi na səəkə ta zəmə shi va. Ma dza mbəzli haka na va nashi ki na, kala ɗi səəkə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Zhini na daꞌ harvə nihwəti ka sləni ci, ta ghwənishi ɓa. A kə kaa ngəshi na: “Mbalam va mbəzliy niy gəzanshee va səəkə, a ghwəy harashi. E hanamti slay, lə gemim kəli kəli ni, mbaꞌam tamti shi zəmə gwaꞌa, tərə na war zəməshi, səəkəm, kə, pə ghwəy kaa ngəshi” kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsəgha na, kə mbəzli va, ka dzashi. Mbaꞌa ghəshi dzaa gəzanshi kaa mbəzli va war tsəgha. Ma mbəzli haka mazə tsa va va nashi ki na, kwəmaa shashanshi tiɓa mbə niva shiy ya jəwəw. Mbaꞌa ghəshi dzadzashi ta sləni shi. Ka dzay tsaa dza ta za za ci, ka dzay tsahwəti ta pala shi zhəghə dəvə ci. ");
INSERT INTO bcw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dza nihwəti niy tərmbə mbəzli, mbaꞌa ghəshi kəəsəti ka sləni mazə va, saꞌ saꞌ ghəshi sanamiy shi ngəraꞌwə, mbaꞌa ghəshi bakwamtishi. ");
INSERT INTO bcw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma sa favə mazə tsa va kwəma va na, mbaꞌa nəfə tsa ci satiy tərəŋw. Dza na mbaꞌa ghwənashi ka sawji ci, ta dza ghəshiy bakwamti mbəzliy bakwamti ka sləni ci va, ka ndamti lə məlmə shi ta gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Zhini ləy hwəm ki, ma kə kaa nihwəti ka sləni ci na: “A mbəzlee, avanay sənzənva kiy, gwaꞌa gwaꞌa niy mbəlitee tamti shi zəmə ta zəməshi mbə pəhə makwa zəghwee na. Sana kiy, mbəzliy niy haree va na, ka dza ghəshiy ꞌwati shi zəmə ni ghwəlaw. Sa nzanay, a ghəshi dzadzashi ta na shi sləni. ");
INSERT INTO bcw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ghənzə tsəgha kiy, ləvərim dzəti ngwəla, a ghwəy dzaa təwrə dzar mbə məlmə. Ya wa ntsa dza ghwəy kəsayəy, nza ghwəy har səəkə, ta zəmə shi zəmə ni” kə mazə tsa va. ");
INSERT INTO bcw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dza ka sləni ci va, mbaꞌa ghəshi səvərishi, ka dzashiy dzəghwa kweler. Mbaꞌa ghəshi haharashi ni kəsashi ghəshi mbəzli dzar mbə məlmə, ta zəmə shi zəmə va. Mbəzli jikir kwəma ni, lə ni wəzə ni gwanashi. Dzəghwa ki, paf ciki təhəy va mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ma sa ɓasəshi məndi gwaꞌa tsəgha na, dza mazə dəꞌwə ghən tsa ci mbaꞌa dzəmbəy ta nighə mbəzli harashi na ta zəmə shiy gwaꞌa ki. Ma dzəmbə na, sa nə na nighə kə na, kar mətsə ci tə tsahwəti ndə. Ntsa va na, kala kwəbaŋ tsə kən ghən ci. ");
INSERT INTO bcw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dza ma kə kaa ntsa va na: “A madiga, njaa ꞌwa ghaa səmbəŋaa dzəmbə ciki tsa kala kwəbaŋ tsə kən ghən ghaa?” Kə. Hash ntsa va hashiy, kala mbəə zləɓanci kwəma kaa mazə. ");
INSERT INTO bcw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ma kə mazə tsa va kaa ka sləni ci na: “Satim, kəsəm a ghwəy pahati tə zəꞌwə, kwa shiɗshiɗ ci, lə kwa dividivi ci gwaꞌa. Nza ghwəy dzaa ndəghəy pəriɓa tə ngwəla mbə kwəsli va. A ghəci wawahə, ka pərə sliꞌi ci pəriɓa” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ma sa ɓəlamti Yesəw fir tsa va, ma kə ɓa na: «Sa nzanay, ɗaŋ tərəŋw na mbəzli harashi Hyala, ə na na nzanay, ɗaŋ na ni təravə na mbəzli mbə shiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dza *ka Farisahi, mbaꞌa ghəshi dzashi, mbaꞌa ghəshi dzaa sləkati kwəma tsəhwəli, ta mbəə ngalivə Yesəw, ta kəsəti, tə kwəma dza naa zləɓakə. ");
INSERT INTO bcw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma sa sləkamti ghəshi kwəma ki na, dza ghəshi, mbaꞌa ghəshi ghwənashi nihwəti mbəzli mbə mbəzli kwasəbə shi, ghəshi lə nihwəti mbəzli mazə *Erədə ta gəzə kwəma kaa Yesəw. Ma sa tsəhəshi ghəshi vəgha Yesəw ki, ma kə ghəshi ngəci na «A Metər, a ghəy sənay kwəma kataŋ na ka ghaa gəzə. War kwəma Hyala na sa ka ghaa ɓananshi kaa mbəzli lə kwal tsa nzə. Ka hazləni gha va kwemer gəəzə mbəzliw. Sa nzanay, ka nə gha, kar ntsa dikə tsa na tsatsa ndə, tsa jəw tsa na tsatsa ndə, pə gha, ka təra ghalaa dzəmbə mbəzliw. ");
INSERT INTO bcw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ma kwəma ɗi ghəy sanay, ə ɗi ghəy ghaa gəzaŋəy kwəma təkə ghaa dzəkən kwəma dza ghəy na ta gəzaŋa: Kwal va ghwəmmə ta tsəhanci ghən ghwəmmə kaa mazə tsaa sləkə hiɗi ka *Rəm gwanashi ta naa, na njaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yesəw naci ki na, cəkeꞌ ghəci sənata kwəma shi va gəmgəm na təkəti ghəshi. Ma kə kaa zləɓanshi na: «Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəlay, tawa ɗi ghwəy ngalira kia? ");
INSERT INTO bcw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Citəram gəna tsəhə məndi va ghən tsa va li di» kə. Dzəghwa ghəshi mbaꞌa ghəshi ɓəvə dalaa cinti. ");
INSERT INTO bcw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma kə Yesəw ngəshi na: «Fəətə tə dala na na sanay, fəətə wa naa? Ya slən tsa tsaslati məndi tsa tiy, slən tsa wa naa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma kə ghəshi ngəci na: «Fəətə mazə tsaa sləkə hiɗi ka Rəm gwanashi na, slən tsa ci sa va diɓa» kə ghəshi. Dzəghwa, ma kə Yesəw ki na: «Ghənzə tsəgha kiy, tsəhancim ghən tsa ci kaa mazə tsa va njasa təɓə na. Ma ni Hyala shiy na, mbaꞌa ghwəy ɓanavə shi Hyala njasa təɓə ghəshi kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma sa favə ghəshi kwəma zləɓakə na va na, mbaꞌa səəti məhərli shi, mbərəkə ghəshi zlay, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A nihwəti mbəzli tiɓay, *ka Sadəsehi, kə məndi kaa ngəshi. Ma kə mbəzli vaa niy: «Ka zhakati mbəzliy bəkwəshi mbə mətiw» kə shiy ni. Dzəghwa fəcavata ki na, ndəs ghəshi tsəhəshi va Yesəw. Dza ghəshi ka ɗəw kwəma və, ");
INSERT INTO bcw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","a kə ghəshi na: «A Metər, ma kə *Məyizə niy niy: “Mbaꞌa kə ndə mətiy kala yavə zəghwə ghəci kwa mali ciy, zəmbəghəy dza naa ɓə mali mbəri tə mali ci va, ta mbə ghəciy yanakə hwəlfə kaa zəmbəghəy tsaa mətiy va” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A nihwəti mbəzli niy nza tiɓa va ghəyəy, mbərfəŋ ghəshi ka ndərazhi ndə kwətiŋ. Dzəghwa Cikwa tsa mbə shi, mbaꞌa ɓəvə mali ci. Dza na mbaꞌa mətiy kala yakə zəghwə ghəshi li. ");
INSERT INTO bcw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sa mətiy na na, dza Zəra həŋ ɓəhwə mali mbəri ti. Zhini Zəra mbaꞌa mətiy kala yakə zəghwə ghəshi lə mali va ɓa. Dzəghwa Takwa mbaꞌa mbəərəhwə diɓa. Sar na kwərakwə mbaꞌa mətiy, dzəghwa ndərazhi va mbərfaŋanavashi, mbəərəvə tsava, mətiy, mbəərəvə tsava, mətiy, war tsəgha. Cəkeꞌ ghəshi hati mali va, nək tsaa yavə zəghwə kwa mbə shi. ");
INSERT INTO bcw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma ləy hwəm shi gwanashi ki na, dza mali va kwərakwə mbaꞌa mətita. ");
INSERT INTO bcw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sana sənzənva kiy, avanay gwanashi ɓəhwə mbəzli va mali va. Fəca vici dza mbəzliy zhakati mbə məti kiy, mali tsama ndə dza naa nza mbə shi kwətiŋ kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma kə Yesəw kaa zləɓanshi na: «Ma ghwəyəy, ka favə kwəma ɗi kwəma vaa gəzə ghwəyəw. Sa nzanay, sənata kwəma gəzəkə Hyala mbə zliya nzə ghwəyəw. Zhini diɓay, sənata bərci Hyala ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A na mbəzliy bəkwəshi, sa ka ghəshi zhakatishi mbə məti e gəzaŋwəyəy, ka ɓə miꞌi zhərəw, ka ɓə zhər miꞌiw dza ghəshiy nza. Ghalaɓay, nja ka kwal Hyala va mə ghwəmə dza ghəshiy nza. ");
INSERT INTO bcw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ghənzə nja na kwəma zhakati tsa mbəzli mbə məti kiy, ə səəkə ma ghwəy jangəhwə kwəma gəzaŋwəy Hyala shəkən na. Ma kəy: ");
INSERT INTO bcw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yənəy Hyala kar *Abəraham, lə *Izakə mbaꞌa *Zhakwapə nzee” kə. Ɗi naa gəzəy, tə ghwəməshi na mbəzliy bəkwəshi va. Sa nzanay, na na Hyala na, Hyala mbəzli bəkwə bəkwə ni naw. Hyala mbəzli tə ghwəmə mbə piy na, na nanzə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma sa favə mbəzliy ɓasəshi va kwəma gəzəkə Yesəw va na, ka mananshi maɗaŋa ghənzə. ");
INSERT INTO bcw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dzəghwa mbaꞌa *ka Farisahi favə, a Yesəw kəsəy *ka Sadəsehi lə gəzə kwəma, kə məndi. Ma sa favə ghəshi na, dza ghəshi ɓasə ghəshi ɓasayvashi. ");
INSERT INTO bcw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dzəghwa tsahwəti *ndə ɓənipə kwəma pəhəti Hyala mbə shi, ka ɗəw kwəma va Yesəw, sa ɗi na ngali ci, a kə ngəci na: ");
INSERT INTO bcw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«A Metər, nama *kwəma pəhəti Hyala gwəramti na dikə mbə Zliya nzə tay?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma kə Yesəw ngəci na: «Saa ni va: “Ɗi pə ghaa ɗi Hyala gha sləkəŋa, lə nəfə tsa gha gwanay, lə məhərli gha gwanata, mbaꞌa gha ɓanavə ghən tsa gha gwanay” kəy, ");
INSERT INTO bcw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ghənzə na kwəma gəzəkə Hyala ta məni gwəramti tə diɓədiɓə, lə dikə gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Vanta nahwəti kwa baka kwəma pəhəti Hyala diɓədiɓə na: Saa ni va: “Ɗi nihwəti mbəzli gwanashi, njasa ɗi gha va ghən tsa gha kwərakwə” kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mbə kwəma gəzəkə na va bakə na səvərishi kar zliya kwəma pəhəti Hyala ghəshi lə zliya ka gəzə kwəma Hyala gwaꞌa gwaꞌa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dzəghwa Yesəw tapə ta ɗəw kwəma va *ka Farisahiy ɓasəshi va tə pətsa va. Ma kə na: ");
INSERT INTO bcw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«A mbəzli ni, njaa ka ghwəy təkəə dzəkən Kəristəw Ntsa tivə Hyala tay? Zəghwə wa na ka ghwəy nia?» kə. Ma kə ghəshi ngəci na: «Jijiy mazə Davitə na, ka ghəy ni» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma kə Yesəw ngəshi na: «Ndata tsəgha na kiy, njaa zhəkə na niy zhini mazə Davitəə har Kəristəw: “Ndə sləkəra” kə, sa cinti *Safə tsa Hyalaa? A mazə Davitə niy gəzəkə, ma kə niy niy: ");
INSERT INTO bcw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","A kə Hyala kwa sləkəpə kaa Ndə sləkəray: “Ndi nzəyŋa tə kwa bəzəmee, paꞌ fəca dzee mənti ka mbəz gha ka mbəzli tə dəvə gha!” kə, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ya sa nzana, Ndə sləkəra, kə mazə Davitə kaa har Kəristəw kiy, zhəkə dza njaa ka Kəristəw zhiniy nza ka jijiy mazə Davitə nə ghwəy kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma sa gəzanakəshi Yesəw tsəgha na, tərəh ntsaa zhiniy mbay zləɓanakə kwəma mbə shi. Dzəghwa ghala fəcava ki na, ndə tiɓa mbaꞌa zhiniy təkə ɗəw nahwəti kwəma və ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dzəghwa, ma kə Yesəw kaa mbəzliy ɓasəshi tə pətsa va ghəshi lə mbəzli ta səɗa ci gwaꞌa na: ");
INSERT INTO bcw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Kwəma pəhanavə Hyala va kaa *Məyizəy, a ghwəmmə sənay, sləni *ka ɓənipə kwəma pəhəti Hyala, ghəshi lə ka Farisahi na ɓəni nzə kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Njana nzana tsəghay, ə pə ghwəy ɗi fəti və shi, ka məni kwəma ɓəniŋwəy ghəshi va gwaꞌa. Nanzə kiy, əntaa ghwəy dzaa məni kwəma njasa məni ghəshi tepə ma. Sa nzanay, na nashi na, ka məni shi ɓənipə ghəshi va ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ghəshi na nashiy, shiy taŋanatishi bərci kaa mbəzli ka ghəshiy gəzanshi məni. Njasa ka məndi vaa fanaghwa shi shəndəkə ni kwa ghən ndə. Ma ghəshi dəꞌwə ghən tsa shi na, kala ɗi ma kanshi dəvə kaa mbəzli ya jəw tsə tsə. ");
INSERT INTO bcw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na shi kwəma ka ghəshiy məni gwanatay, war ta mbə mbəzliy falshi gwaꞌa tsəgha, ka ghəshiy məni. Hwəpər tsa jəw jəw tsa va ka məndiy fə kwəma Hyala kway, dikə dikə ka ghəshi mənivə tsa shi. Ka ghəshi dza diɓa na, ka pəəhə shiy tərəŋw tərəŋw dzar ta mətsəni kwəbeŋer shi. ");
INSERT INTO bcw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ya tə pətsa ɓasəshi məndi ta zəmə shiy tsəhəshi ghəshiy, war pətsa nzəy mbəzli tə slən va ti ka ghəshiy pala ta nzəy. Ya mbə *ciki ɓasəva tsa ka Zhəwifə diɓa na, war tə kwəma ka ghəshiy ɗi nzəy. ");
INSERT INTO bcw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jəw ɗi ghəshi məndiy tsəfəkwə mbə səkwəshi, dzar tə ləwmaw, jəw ɗi ghəshi məndiy harshiy mbəzli dikə dikə niw. ");
INSERT INTO bcw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Na na ghwəy ghwəy mbəzli ta səɗee kiy, əntaa ghwəy zləɓa məndiy hakaŋwəy, mbəzli dikə dikə ni ma. Sa nzanay, ghwəy gwanaŋwəy na, ngwarməmə mbə nəwraa gə ghwəy. Kwətiŋəy na tsa ghwəy ntsa dikə tsa. ");
INSERT INTO bcw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka har ndə ghwəy “Didi” tikə tə hiɗi ni ya tsamaɓa ma. Sa nzanay, Hyala mə ghwəmə kwətita na tsa ghwəy Didi. ");
INSERT INTO bcw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ka zləɓa ghwəy məndiy hakaŋwəy mezhizhə ma. Sa nzanay, kwətiŋəy na mazə tsa ghwəy. Ghəci na *Kəristəw Ntsa tivə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tsaa gwəra dikə ndə mbə ghwəyəy, ghəci kə dzaa nza ka ndə ghəraŋwəy sləni. ");
INSERT INTO bcw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ə gəzaŋwəyee: Ntsaa dzaa kəli ghən tsa ciy, ta zhəghəti dza Hyala jəwə tsətsə. Tsaa dzaa zhəghəti ghən tsa ci ndə, nja ntsa jəw tsay, tsava ndə na saa dzaa məniy ka ntsa dikə tsa va Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Dzəghwa ma kə Yesəw kaa mbəzliy ɓənipə kwəma pəhəti Hyala, ghəshi lə ka Farisahi na: «Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahiy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. Dza ghwəy disl ghwəy kalay miy kwal tsaa dzəti pətsa sləkə Hyala va nihwəti mbəzli. A ɗi ghwəy dzəmbə dəꞌwə ghən tsa ghwəyəw, a zlanay kwal ghwəy kaa niy ɗi dzəmbə mbəzli, a ghəshi dzəmbə ɓaw.  ");
INSERT INTO bcw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi niy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. Ka ghwəy dza, meꞌ meꞌ ghwəy pamti shiy va miꞌi mbəreketi gwaꞌa gwaꞌa na, zhini ka garə, pə ghwəy ni ta cəꞌwə Hyala. Ka ghwəy dza na, nzaꞌ nzaꞌ nzaꞌ ghwəy nzati nza tə cəꞌwə va. Tə mbərkə kwəma vay, ta məni ngwəvə dza Hyalaa dzəkən ghwəy, taŋ na nihwəti mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi niy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. Ka ghwəy dzay, ka dzaŋwəy ta tətəwrə kərakə, lə shiɗshiɗ ghwəy, ka dzəy tə yam, lə kwambəwal. War ta dzaa pəlavə ntsaa dzaa nəw kwəma ghwəy. Ma sa ka ghwəy kwəmavə na, ka ghwəy dza mbaꞌa ghwəy ɓananavəshi ghwəy va. Ka shi dza ghwəy vaa ɓananaghə dza na, mbaꞌa ghəshi mənti ka ntsaa dzaa dzəmbə ghwə, sa ka ghəshi zhəghanti məhərli ci ta məni *kwəma jikir na taŋ kaa na ghwəy va. ");
INSERT INTO bcw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəyəy, ghala mbə ghwəy lə ghwəlefesliy ci kwal va kaa mbəzliw. Ma pə ghwəy niy: “Mbaꞌa kə ndə zəməkə fəla lə *ciki Hyalay, shiy tiɓaa mananciw. Ma mbaꞌa kə zəməkə fəla lə tsahi mbəzə mbə ciki tsa vay, ta kəsə dza fəla va” pə ghwəy ni. ");
INSERT INTO bcw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hyeler ni, ghwəlefesli ni. Pərɓa nima shiy na mbə shi bakə ni va nə məndi ngəŋwəya? Pərɓa tsahi mbəzə shəkənaa, naa pərɓa *ciki Hyala, ghəci tsaa mənti tsahi va ka shi ɗewɗew ni kwa kwəma Hyala? Pərɓa ciki Hyala na, e gəzaŋwəy nee ki. ");
INSERT INTO bcw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma pə ghwəy ni diɓay: “Mbaꞌa kə ndə zəməkə fəla lə pətsa ka məndiy fə shiy ti ta ta Hyalay, shiy tiɓaa mananciw. Ma mbaꞌa kə ndə zəməkə fəla lə shi fanati məndi va tə pətsa va kaa Hyalay, ta kəsə dza fəla va” pə ghwəy ni. ");
INSERT INTO bcw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ghwəlefesli ni. Pərɓa nima shiy na ta shi bakə ni va nə məndi ngəŋwəya? Pərɓa shi ɓə məndi va kaa Hyala shəkənaa, naa pərɓa pətsa fanta məndi va shi va ti ghəci saa zhəghəti shi va ka shi ɗewɗew ni kwa kwəma Hyala? Pərɓa pətsa fəm va shi va ti na e gəzaŋwəy nee ki ");
INSERT INTO bcw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Favə tə ghwəy e gəzaŋwəy: Mbaꞌa kə ndə zəməkə fəla lə pətsa fə məndi shiy ti ta ta Hyalay, lə shi fati məndi va tə pətsa va ta gwaꞌa zəməkə ntsa va fəla, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mbaꞌa kə ndə zəməkə fəla lə ciki Hyalay, lə Hyalaa nzəy va mbə ciki tsa va ta gwaꞌa zəməkə ndə fəla li, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mbaꞌa kə ndə zəməkə fəla lə pətsa mə ghwəməy, lə gəzli Mazə Hyala ta gwaꞌa, mbaꞌa lə Hyalaa nzəy va kwa gəzli va ta gwaꞌa zəməkə ndə fəla li, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi niy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. Ghwəy kiy, kar ghwəy ɓə shiy kwətiŋ mbə shiy məŋ ta ɓəshi kaa Hyala. Tsəgha ka ghwəy ti nihwəti kəslifi jəw jəw ni wəzə ni ka ghwəy ta. Ma shi gwəramti Hyalaa ɗi ghwəy məni mbə kwəma pəhəti na na, kala ɗi məni niva ghwəy. Shi ɗi ma ghwəy va məni gwəramti Hyalaa ɗiy, avanashi: Məni zhəhwər ta mbəzli, mbaꞌa məni kwəma lə kwal tsa nzə, mbaꞌa nəw Hyala lə nəfə kwətiŋ. Tsəgha na shi ka ghwəy məni nza ki, kala za ma ghən ta ɓə shiy kwətiŋ kaa Hyala, səvəri mbə shiy məŋ diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ma ghwəyəy, ghwəlefesliy ci kwal kaa nihwəti mbəzli nza ghwəy. Ka ghwəy dzay, nashi ma ghwəy məcenekwesli tə shi sa ghwəy na, mbaꞌa ghwəy nzəlamtishi. Ma mbaꞌa kə ngaləwba dzətitaa dzəti shi na, kip ghwəy sahwə nava. ");
INSERT INTO bcw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi niy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla, mbalaa paf paf na nefer ghwəy va ghəli, lə va maw məni kwəma jikir na. Gwəyəy, mbəzliy gwəmanti yaɓə devəre sa shiy tsa shi va lə kwakwa tsa shi ɗewɗew pərikə tə hwəm shi, mbalaa ngərjəkəjəkə na ghəshi va rəɗa kwa hwər kwa hwər shi nza ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","A ka Farisahi, ghwəlefesli ni. Ma pə ghwəy mənti e gəzaŋwəyəy, pərɓa pətsa kwa hwər devərehi ghwəy lə kwekwer ghwəy pə ghwəy yaɓanti. Ma ghalaɓay, ɗewɗew dza ghəshiy nza paꞌ pərikə tə hwəm shi. ");
INSERT INTO bcw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ghwəy ghwəy mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy ka Farisahi niy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy, ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. Ghala mbə ghwəy lə kwəli ka məndi vaa hwəti tezlezl na, ka mbərə kwa kwəma mbəzliw. Mbalaa ma kwaɓa kwaɓa nzə ki na, paf təhəta va ꞌyesler lə va shi ghwaɓə ghwaɓə ni. ");
INSERT INTO bcw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ghwəy kwərakwə kiy, war tsəgha nza ghwəy sana sənzənva. Nja mbəzli wəzə wəzə ni ghwəy pəzli kwa kwəma mbəzli na, mbalaa paf təhəy pətsa mbə nefer ghwəy va dakə mbəzli, lə va ndərəm gwaꞌa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Zhini ma kə Yesəw ɓa na: «Ghwəy ghwəy *mbəzliy ɓənipə kwəma pəhəti Hyala ni, mbaꞌa ghwəy ghwəy *ka Farisahiy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy ghwəy mbəzliy dakə mbəzli ni lə kwəma pərikə tə ngwəla. A ghwəy ngangamti kwəlihi ka gəzə kwəma Hyalaa niy bakwamti jijihiŋwəy mbəradzə wəzə wəzə. Mbaꞌa ghwəy ghaslamti ni mbəzliy niy mənti kwəma ɗi Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Zhini ma pə ghwəy na: “Mbaꞌa pə ghwəmmə niy nza tiɓa ghala vəghwə tsaa niy nza jijihimmə va tə ghwəmə nzay, ka dza ghwəmmə zləɓa jakə miy tsa ghwəmmə li shi, ta bəkwə ka gəzə kwəma Hyala va nzaw” pə ghwəy ɓa! ");
INSERT INTO bcw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma ɗi kwəma va gəzəy, mbə gəzə kwəma ghwəy va tsəgha nay, a ghwəy sənay dəꞌwə ghən tsa ghwəy, jijihiŋwəy niy bakwaməti na ka gəzə kwəma Hyala, pə ghwəy, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ghənzə tsəghay, war nəw pə ghwəy nəw məni kwəmaa niy ꞌwatəŋwəy jijihiŋwəy kwal tsaa məni nzə gwaꞌa tsəgha, nza ghwəy kərnamti sləni shi. ");
INSERT INTO bcw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ghwəy ghwəy mbəzliy ndərəm ni nja kwara jigəzlihi niy, njaa njaa dza ghwəy mbay waslamti ghən tsa ghwəy va ngwəvə dzəti ghwə kia? ");
INSERT INTO bcw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ava va tsəgha, kadiwəm, favəm: Ta ghwəniŋwəy ka gəzə kwəma Hyala, lə ka sənata kwəma, mbaꞌa mbəzliy ɓəni kwəma kaa mbəzli dzee. Sa ka ghəshi səəkəshiy, ka ghwəy dza na, mbaꞌa ghwəy bakwaməti nihwəti, dzəghwa kaa nihwəti daŋwə daŋwə dzəvəgha tsəm. Ka didiꞌwə nihwəti lə kwərpə dzar mbə ceker ɓasəvahi ghwəy. Ka nəwshi ta titihəshi dzar mbə məlməhi, mbə məlməhi. ");
INSERT INTO bcw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Va tsəgha ki, ma ngwəvə dza Hyala vaa slaa dzəkən mbəzli tə sa bakwaməti ghəshi mbəzli nzə va slar slar ni kwataŋay, dzəkən ghwəy dza naa dza. Mbəzli ghənghən ghənghən bakwamti ghəshi, tə *Abel, ntsa slar tsa va Hyala gha məndiy pəəsli ndə, ka sar lə bəkwəshi paꞌ tə Zakari, zəghwə Barashi. Dzar kwa jipə pətsa ka məndiy fə shiy ti, ta ta Hyala, lə *ciki Hyala niy pəəsli ghwəy tsava. ");
INSERT INTO bcw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A gəzaŋwəy ya, ta na navay, tsəgha na, ngwəvə dza Hyalaa slaa dzəkən mbəzli tə sa bakwaməti ghəshi mbəzli va gwanashiy, dzəkən ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə ni dza ngwəvə vaa dza» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dzəghwa ma kə Yesəw dzəkən mbəzli mbə məlmə Zherəwzalem na: «A mbəzli mbə məlmə Zherəwzalem, ghwəy bakwamti na ka gəzə kwəma Hyala, mbaꞌa ghwəy paꞌwamti mbəzli Hyala ghwənashi na lə hərezli ka bakwamtishi. Ɗaŋ səɗee mbə pəla ɓasətəŋwəy ta ndəghwəŋwəy, njasa ka kwəkwəla vaa ɓasambə kwərtiti nzə mbə bəkəbəkə nzəy, kala zləɓa ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ə gəzaŋwəy ya, nana kiy, ta ɓanti dəvə nzə dza Hyala tə məlmə ghwəy, war ka kwəfi dza naa mbəərəta. ");
INSERT INTO bcw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ə gəzaŋwəy ya, ka zhiniy ghwəy nara ghwəla tepəw, paꞌ fəca dza ghwəy gəzəə dzəkənee: “Təfanati miy tsa nzə Hyala kaa ntsaa səəkə mbə slən tsa nzə, ghənzə kwa sləkəpə” pə ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dzəghwa Yesəw mbaꞌa maɗiy mbə *ciki Hyala kaa səvəriy dzay. Ma ghəci mbə dzay na, mbaꞌa mbəzli ta səɗa ci səəkəə kəsay. Ma kə ghəshi kaa ngəci na: «Nighətima njasa ngay ciki Hyala tsa va wəzə tsa ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma kə Yesəw kaa ngəshi na: «Yə, e nay. Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya tsəgha nay ghwəy ciki tsa vay, ta baꞌwamti dza məndi. Ka dza ghwəy nashi hərezli tsəŋəzli tsəŋəzli, ya kwətiŋ ghwəlaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ləy hwəm jəw ki na, dza Yesəw mbaꞌa dzaa nzəyəy mə ghən kəlaŋ tsa har məndiy «Kəlaŋ *ꞌWəlivə». Dza mbəzli ta səɗa ci, mbaꞌa ghəshi ɓasəkəvashi kwətishiy dzəvəgha. Mbaꞌa ghəshi nzəyshi jaꞌjaꞌ məɓa. Dzəghwa mbaꞌa ghəshi ghakə ɗəw kwəma və, a kə ghəshi na: «A Ntsa ghəy dikə tsa, geꞌi lə tsama vəghwə dza shi gəzə gha niy məniva tay? Tə wa dza məndiy sənay ndal tərə gha ta səəkəw, ndal tərmbə hiɗi ta kəɗiw, kə məndi tay? Gəzaŋəy di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma kə Yesəw ngəshi na: «Məni tə ghwəy məhərli wəzə, əntaa ghwəy dzaa zləɓa məndiy ngəɗiŋwəy ma. ");
INSERT INTO bcw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sa nzanay, ɗaŋ dza nihwəti mbəzliy səəkə lə slən tsee. Ka ndə dzay: “Yən na *Kəristəw tsa tivə Hyala va” kə, ka tsahwəti dza diɓa na “yən na” kə. Gəla mbəzli vay, mbəzli ɗaŋ tərəŋw dza ghəshiy ngəɗiti. ");
INSERT INTO bcw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta fa favə gaka mbəz dza ghwəy dza mbə məlməhi ndəkwə ndəkwə ni lə ghwəy. Zhini diɓay, ta fa favə nəwər tsa mbəz dza ghwəy mbə məlməhi kərakə kərakə ni lə ghwəy. Ya ə dza ghwəy favə shi va tsəghay, əntaa her ghwəy taa dza ma. Ya njaay ta məniva dza gəla niva shiy tsəgha. Ya tsəgha dza shi vaa mənishiy, ka dza hiɗiy kəɗi diw. ");
INSERT INTO bcw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ka hwəhwə tsa nihwəti mbəzli dzay, ka mbəz lə hwəhwə tsa nihwəti. Ka tsahwəti mazə dza na, mbaꞌa pəlati miy tə tsahwəti, tapə ghəshi mbə mbəz taa nza. Dzar tə nihwəti hiɗi ghənghən ghənghənəy, ta mənta dza ma, ka gərgərəva hiɗi dzar tə tsahwəti pi ghənghən ghənghən. ");
INSERT INTO bcw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Shi va gwanashiy, ngəraꞌwə tsaa dzaa gha səəkə na ghəshi, njasa ka mali vaa ꞌwa kemahə ta ya zəghwə na niva shiy. ");
INSERT INTO bcw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ka məndi dza na, ka kəkəsəŋwəy kaa nihwəti mbəzli, ta saŋwəy ngəraꞌwə ghəshi, ka bəkwəŋwəy. Hwəlfəhi mbəzli gwanashiy, ka dza ghəshiy ɗi mətsə ghwəy tə sa nəwra ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ghala vəghwə tsa va kiy, ɗaŋ dza mbəzliy nəwraa zlay nəwra. Ka ghəshi dza na, ka nga ɗafa ta nihwəti, ghəshi ka ghən tsa shi, ka ndərəva kwa jipə shi. ");
INSERT INTO bcw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɗaŋ dza ka gəzə kwəma Hyala ka dzərvəə tsahwəshi. Ka ghəshi səəkə na mbaꞌa ghəshi ngəɗəhwə nihwəti mbəzli ɗaŋ ta nəwshi. ");
INSERT INTO bcw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tərəŋw dza məni *kwəma jikir naa vəŋəta tə hiɗi. Ka gha nighə war va kwəma vay, mbəzli ɗaŋ zlay ɗiva kwa jipə shi. ");
INSERT INTO bcw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma ntsaa dzaa jihəkəvay kala zlay nəwra ghəci paꞌ tə vici məti ciy, ta mbəliti tsava ndə dza Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma sa ka məndi gəzamti Yəwən kwəma wəzə naa dzəkən sləkə tsa dza Hyala ta sləkə mbəzli kaa mbəzli tə hiɗi gwanashi, ta mbə hwəlfəhi tə hiɗi gwanashiy favəy, ma nza hiɗi maɗi ta kəɗi ki. ");
INSERT INTO bcw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ta nashi shi rəɗa rəɗa ni va jikirkir ni, niy gəzəkə Daniyal *ndə gəzə kwəma Hyala kwəmaa dzəkən shi kwa zliya dza ghwəy garəshi mbə *ciki Hyala, (ntsaa jangəti kwəma vay, favə tə ghəci wəzə). ");
INSERT INTO bcw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ghalaɓa kiy, mbəzli tə hiɗi ka Zhəwde na, hwəshi tə ghəshiy dzəmbə kəlaŋ ta mbəə mbəlishi. ");
INSERT INTO bcw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mbaꞌa kə ndə mə jəba mbə tifərəy, əntaa ghəci dzaa ni na: “Kadiw, e dzaa ɓasəvə shi ya mbə ciki tsee” kə ma. Ə kə dzaa hwəy gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya kwamti dza ndəə nza mbə zay, əntaa ghəci dzaa ni: “Kadiw, e zhəghəvaa jighi ta ɓəvə kwəbeŋeree” kə ma. Ə kə dzaa hwəy gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngəraꞌwə tərəŋw dza savaa nza fəcava kən miꞌi lə hwər lə miꞌi ka ndərazhi tə hwəm. ");
INSERT INTO bcw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cəꞌwə pə ghwəy cəꞌwə Hyala əntaa bali va taa məniva geꞌi geꞌi lə tir tasli, lə nəghətaa dzaa nza fəca *vici dəkəva. ");
INSERT INTO bcw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa dza naa nzay, ma ngəraꞌwə tsaa dza vaa nza tə hiɗi geꞌi lə vici va na, dikəy tərəŋw dza naa nza. Səəkə gəla hwəlfə ngəraꞌwə tsa tsəgha tsa vaa kəsashi mbəzli ghala ngati Hyala hiɗi, ka sar paꞌ tə vəghwə tsa ndatsəw. Ka dza naa zhiniy səəkə kən mbəzli diɓa ka məndi nzaw. ");
INSERT INTO bcw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kala sa nzana mbaꞌa Hyala tamti ɗaŋ tsa vici ngəraꞌwə tsa va tə mbərkə mbəzli nzə təravə nay, ka dza ndəə tərmbə tə ghwəməy nzaw. Əy ma dza na ki na, mbaꞌa tamti ɗaŋ tsa vici va tə mbərkə mbəzli nzə təravə na. ");
INSERT INTO bcw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ma sa ka vəghwə tsa va məniyəy, mbaꞌa kə ndə taa ni ngəŋwəy: “A mbəzli ni, anay *Kəristəw Ntsa tivə Hyala tikə” kə, ya “avaci tarɓa” nə nay, əntaa ghwəy zləɓa kwəma ci va tepə ma. ");
INSERT INTO bcw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sa dza naa nza ghala vəghwə tsa vay, ɗaŋ dza Kəristəwhi ka dzərvə lə ka gəzə kwəma Hyala ka dzərvəə tsahwəshi tə hiɗi. Ka ghəshi dza na, ka məməni shi maɗaŋa maɗaŋa ni tərəŋw, lə shi dimədimə ni, ta mbəə ngəɗi mbəzli. Mbaꞌa kə ghəshi dzaa mbatay, ta dzəghə ngəɗi dza ghəshi ya mbəzli təravə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ə gəzamtəŋwəy ya kwəma va kwaghwətsata, ta mbə ghwəy sənashi shiy dzaa məniva. ");
INSERT INTO bcw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mbaꞌa kə məndi taa ni ngəŋwəy: “Avam Kəristəw pəriɓa tə gamba” kə məndiy, əntaa ghwəy dzəvəri ma. Ya: “Anay tikə mbəy na” nə məndiy, əntaa ghwəy taa zləɓa ma. ");
INSERT INTO bcw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa kee səəkə, yən Zəghwə yakə ndə ngəriy, mbəzli gwanashi dza naa nara. War njasa ka wampiɗi van vaa dzəy tə ghwəmə, ka səəkə kwa ghwəmə paꞌ kwa mərkwiy, tsəgha dza naa nza. ");
INSERT INTO bcw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A ghwəy sənay, dzəghwa tə pətsa mətishi shiyəy, tiɓa ka zliŋiŋ ɓasəva» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ləy hwəm ngəraꞌwə tsa va kiy, nzaꞌjəw shərkwə dza viciy shərkwəta, ka tir dza na, mbaꞌa zlay mbərə, ka sasərkwəhi tə ghwəmə dza na, ka shikəvaa səkwa, ka shi nza bərci vəshi mə ghwəmə ꞌwakəvə na, ka kwəfəghə. ");
INSERT INTO bcw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ghalaɓa kiy, a shiy dzaa tsahwəshi səəkə mə ghwəmə, shiy dzaa ci səəkə tsa Zəghwə yakə ndə ngəri. Ma hwehwer mbəzli tə hiɗi gwanashi ta nza ghala pətsa va ki na, war ə dza ghəshiy ngəngəlvə, ka tihwəni. Ka Zəghwə yakə ndə ngəri dza na, tsahwə tsahwəy war ka nay mbəzli lə mətsə shi səəkə mbə kwəleɓi tə ghwəmə, lə bərci və tərəŋw, mbaꞌa shəndəkə ti diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ka məndi dzay, mbaꞌam viyata təlimə dikə na tərəŋw tərəŋw. Sa ka məndi viyata na, ma nza ghwənashi ka kwal ci, ta dza ghəshiy ɓasəkə mbəzli təravə na tə bəlahi tə hiɗi faɗanavashi səəkə tə pətsa kəray ghala hiɗi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Avee taa ɓəliŋwəy fir lə kwəma daskway, favə tə ghwəy shi ɗi na ɓəniŋwəy. A ghwəy sənay, mbaꞌa kə kəslifi daskwa shikəshi, dza na mbaꞌa ɗakə nihwətiy, a vəghwə tsaa dzəmti kətikəvay, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ava tsəgha na ki, war nashi ma ghwəy gəla shi ɓəlakəŋwəy ya va gwanashi ghati mənivay, sənay tə ghwəy ndal tərmbə Zəghwə yakə ndə ngəri ta səəkəw, miy dəgha na ki, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A gəzaŋwəy ya, ta na navay, tsəgha na, ka dza mbəzli mbə vəghwə tsa ndatsə tsaa bəkwəshi ka shi gəzaŋwəy ya ni gwanashi mənivaw. ");
INSERT INTO bcw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nay ghwəy na, kar ghwəmə nata ghwəy na, ghəshi lə hiɗi gwaꞌay, kərəp dza ghəshiy zashi. Ma na kwəmee na nanzə kiy, ka kərə naw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma kə Yesəw diɓa na: «Ndə tiɓa ya kwətiŋ mbaꞌa sənata vici dza shi vaa məniva tiw. Ya ka kwal Hyala, ya Zəghwə Hyala dəꞌwə ghən tsa ciy, sənata ghəshiw. War Didi Hyala mə ghwəmə kwətita na saa sənata vici lə ler va gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","War njasaa niy məniva shiy va geꞌi ghala vəghwə tsa *Nəwey, tsəgha dza shiy zhiniy məniva, sa ka vici dzee səəkə ti yən Zəghwə yakə ndə ngəri kətikəvata. ");
INSERT INTO bcw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ma niy nza kwataŋa, ghala vəghwə tsa Nəwe va, Hyala ghwəla ta za mbəzli lə yaməy, ə niy zəmə mbəzli shi zəmə, ka sa sa shiy, ka ɓə ɓə miꞌi. Mbəzli nza ghyehi və shi na, ka ɓəshi kaa zhər, war tsəgha. Paꞌ fəca vici dzəmbə Nəwe dzəmbə kwambəwal ti na, war mbə məməni shi va ghəshi niy nza tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ghalaɓa nashi kiy, niy shashanshi shiy ya jəwəw. War sa nighə ghəshi na, van ghati nzəmə kala kərə ma. Ray pətsa tə hiɗi va yam. Dza yam va kərəp ghəshi zamti mbəzli gwanashi. Njasa niy shashanshi ma shiy va kaa mbəzli vay, war tsəgha dza shiy shashanshi ma kaa mbəzli sa ka vəghwə tsa dzee səəkə ti, yən Zəghwə yakə ndə ngəri kətikəvay kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma sa kee səəkə ghala pətsa va kiy, mbəzli bakə dza naa nza tə za, ka məndi dza na mbaꞌam ɓəhwə tsahwəti, mbərəkə zlay tsahwəti tiɓa. ");
INSERT INTO bcw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ta kəsashi miꞌi dza məndi bakə kwa vəna mbə hə, ka məndi dza na mbaꞌam ɓəhwə nahwəti, mbərəkə zlata nahwəti. ");
INSERT INTO bcw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ava va tsəgha, ə pə ghwəy mənti məhərli, sa nzanay, sənata vici dzee səəkə ti yən Ndə sləkəŋwəy ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Favə tə ghwəy kwəma ɗee na gəzaŋwəy wəzə, a ghwəy sənay, mbaꞌa kə ndə ghi sənay nza, fəca vici tsaꞌ nay, ta səəkə dza ndə ghəliy dzakə ghi tsee kəy, ka dza naa ɓə hi fəcavaw, war tsəmtsəmmə dza naa nzəyəy, ka dza naa zlay kwal kaa ndə ghəli ta dzakəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Va tsəgha, ma ghwəy kwərakwə kiy, gwəmatəvaŋwəyəm ya hwəmɓa nzə, ta ndəghə vici va. Sa nzanay, geꞌi lə vəghwə tsa təkəti ma ghwəy dzee səəkə yən Zəghwə yakə ndə ngəri» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma kə Yesəw diɓa na: «Favəm e gəzaŋwəy kwəmaa dzəkən ndə ghəra sləni tsaa fə ghən ta sləni ci, ka ghəra lə məhərli. Kaa ngəci dza ndə ghi tsa ghəranci na va sləniy zlatanavə ndəghwə pətsa kəghi tsa ci, nza ghəci ɓanshi shi zəmə kaa nihwəti ka sləni kəyɓa sa ka vici zəmə shiy mənta. ");
INSERT INTO bcw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ghala vəghwə tsa dza ndə ghi tsa vaa səəkə, mbaꞌa kə kəsay ndə sləni tsa ci va ghəci mbə tsəva lə sləni gəzanci na va wəzə wəzəy, vəshi na ta tsava ndə ghəra sləni. ");
INSERT INTO bcw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A gəzaŋwəy ya, ta na navay, tsəgha na, ta fanambə shi və gwanashi dza ntsa va mbə dəvə ndə sləni tsa ci va. ");
INSERT INTO bcw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma mbaꞌa kə ndə sləni tsa vaa ntsa gəmgəm tsay, vanta kwəma dza naa təkəti mbə nəfə tsa ci: “Ka dza ntsee tsa dikə tsaa zhikə ɓəlaŋəw” dza naa ni, ");
INSERT INTO bcw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ka na dza na, tapə dzəmbəy mbə di diꞌwə nihwəti mbəzli ghəra ghəshi sləni li shi, ka zəzəmə shi zəmə ci, ka sa sa shiy, ghəshi lə mbəzliy nza war ghi ghi ni. ");
INSERT INTO bcw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","War ghəci mbə məni shi ci va tsəgha ki na, ka ntsa ghəranci na va sləni dza vətəghə səəkəy, fəca viciy niy bərkəti ma ndə sləni tsa va səəkə tsa ci, geꞌi lə leriy niy bərkəti ma na diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa naa səəkə na, saꞌ saꞌ sanamiy ngəraꞌwə kaa ndə sləni tsa va tərəŋw, mbaꞌa dzaa jakayshi tə na shi kwəma lə mbəzliy dakə mbəzli va lə kwəma pərikə tə ngwəla. Nza ghəci wahə war wahə, ka pərə sliꞌi ci tə pətsa va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Zhini ma kə Yesəw ɓa na: «Ma kwəma sləkə tsa sləkə Hyala mbəzliy, yəm dza naa nza lə kwəma degheghir məŋ ni ni dzee ta gəzaŋwəy kwəma shi: Sa dza ghəshiy, mbaꞌa ghəshi ɓəɓəvə gərkəwahi shi, ka dzashiy dzəti pətsa nza zal mali ti. ");
INSERT INTO bcw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nihwəti cifə mbə degheghir vay, niy tsəhwəlishi ghəshiw. Ma nihwəti cifə nashi ki na, tsəhwəli tsəhwəli niva. ");
INSERT INTO bcw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dzəghwa niy tsəhwəlishi ma va cifə ni, mbaꞌa ghəshi maɗishi, war sa ɓəvə ghəshi gərkəwahi shi tsəgha, tərəh tsaa ɓəvə hwəpər tsa ciy tivə in gərkəwa kwa mbə shi. ");
INSERT INTO bcw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma ni tsəhwəli tsəhwəli ni va degheghir cifə ni na, laŋ laŋ ghəshi ɓəɓəvə gərkəwahi shi, mbaꞌa hwəpehwəper. Ya wa ndə na, mbaꞌa tivə in kwa tsa ci hwəpər ghəciy kafə. ");
INSERT INTO bcw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma sa tsəhəshi ghəshi na, dza ghəshi ka ndəghə səəkə tsa zal mali. Ndəghə ndəghə, kə ghəshi na, shaŋ, kala tsahwəy ghəci. Dzəghwa hi mbaꞌa dənavə degheghir məŋ ni va gwanashi, fəriŋ fəriŋ ghəshi ɓəɓəhwə hi ki. ");
INSERT INTO bcw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma mbə daŋkala vərɗi ki na, dzam ka fərghəshi lə zlapə, ma kə məndi na: “Waa, a zal mali tsahwəy naci, səvərim a ghwəy dza ta kaꞌwə” kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dzəghwa degheghir məŋ ni va ki, mbaꞌa ghəshi sasatishi gwanashi. Tapə ghəshi mbə gwəmava, ka tsətsərə ghwə dzəghwa gərkəwahi shi. ");
INSERT INTO bcw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma kə niy tsəhwəlishi ma va degheghir cifə ni kaa ni tsəhwəli tsəhwəli ni va na: “A ya, tihwətihwəm jaɗaghwaŋəyəm in tsa ghwəy vaa dzəghwa ni ghəy ni gərkəwahi, ghwə ka shishirkwə kwa shi di” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma kə degheghir tsəhwəli tsəhwəli ni va kaa ngəshi na: “Am, awə, ka dza naa mənti mək kaa ngəmmə gwanamməw. Wəzəɓa dza ghwəy dzaa pavə tsa ghwəy va mbəzliy ɗəl in na” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma sa gəzanakəshi məndi tsəgha na, dza niy tsəhwəlishi ma va degheghir ka dzashi ta pala in ta pa ki. Ma ghala pətsa dzashi ghəshi va ta pala in ki na, ndəs zal mali səəkəy. Dza niy niy gwəmantəvashi va degheghir lə in tsa shi nashi ki, mbaꞌa ghəshi dzashiy dzakə ghi kwasəbə zal mali. Disl məndi kalay dəgha. ");
INSERT INTO bcw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma ləy hwəm ki na, ndəs nihwəti degheghir va səəkəshi. Səəkə ghəshi na, ka zlapə kwəma zlaŋzlaŋ: “A Ndə sləkəpə, a Ndə sləkəpə, ndi ghwənamtəŋəy dəgha” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma kə zal mali kaa zləɓanshi na: “A gəzaŋwəy ya, ta na navay, tsəgha na, sənaŋwəy ya tepəw” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma sa kərəy Yesəw lə ɓəli fir tsa va, ma kə na: «Va tsəgha kiy, ə pə ghwəy fə ghən, sa nzana, kala sənay vəghwə, ya vici dza kwəma vaa məniva ti ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ma kə Yesəw ɓa na: «Kwəma sləkə tsa sləkə Hyala mbəzliy, yəm dza naa nza lə kwəma tsahwəti ntsaa niy ɗi vaa dzay ta wə. Ma fəca dza na ta kafə na, mbaꞌa harvə ka sləni ci mahkan ta tahanshi gəna ci ngəshi ghəci taa dzay, nza ghəshi zhəghə dəvə li. ");
INSERT INTO bcw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma sa ɓasəshi ghəshi na, dza na mbaꞌa tahanavəshi. Ya wa ndə na geꞌi lə bərci ci ghəci ɓanaghə gəna. Mbəl bələkwə cifə ghəci ɓanavə kaa tsahwəti. Ma kaa tsahwəti na, mbəl bələkwə bakə. Kaa kwa mahkana ndə na, mbəl bələkwə. Sa tahanavəshi na gəna ki na, dza na pəkw dzay. ");
INSERT INTO bcw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dza ntsa ɓanavə məndi va mbəl bələkwə cifə, nzaꞌjəw dzay ta zhəghə dəvə lə gəna va. Dza na mbaꞌa zhəghəvə dəvə, mbaꞌa zəməvə tsahwəti mbəl bələkwə cifə zhəkən tsaa niy ɓanavə məndi va. ");
INSERT INTO bcw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dza ntsa ɓanavə məndi va mbəl bələkwə bakə, mbaꞌa dzay ta zhəghə dəvə kwərakwə. Mbaꞌa zəməvə tsahwəti mbəl bələkwə bakəə dzəkən tsa ɓanavə məndi va. ");
INSERT INTO bcw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma dza tsa ɓanavə məndi va mbəl bələkwə naci ki na, laꞌ lati kəꞌwə, dza sliɗ mbəliy na ci va gəna ɓanavə Ntsa ci va dikə tsa kwa kəꞌwə. Dza na das nzəyəy. ");
INSERT INTO bcw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ma ləy hwəm sa nzay ntsa shi va dikə tsa nza ki na, dza na mbaꞌa zhəghəkəvay mbə wə ci va. Sa səəkəy na na, dza na har harashi ka sləni ci va, ta ɗəw njasa mənti ghəshi lə gəna ci va. ");
INSERT INTO bcw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma sa ɓasəshi ghəshi ki na, kə ntsa ɓanavə məndi va mbəl bələkwə cifə kət kətəghəvay dzəvəgha dikə tsa ci va. Ma kə kaa ngəci na: “A Ntsee dikə tsa, anay mbəl bələkwə cifə tsaa niy ndara gha va. Avanay tsahwəti mbəl bələkwə cifə diɓa, sa zəməvee mbə zhəghə dəvə lə gəna ndara gha va” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma kə dikə tsa ci va na: “Wəzə mənti gha, ndə sləni tsa wəzə tsa nza gha, lə nəfə kwətiŋ ghərati gha sləni gha. Wəzə ghərati gha sləni jəw na na ndaŋee. Nana kiy, ta ndaŋa na dikə na sləni dzee mbə dəvə gha, na nza bama ti, a gha ghəra. Səəkə a gha nzəyŋa, ka vəshi lə ya” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dza ntsa ɓanavə məndi va mbəl bələkwə bakə, kət kətikəvay kwərakwə. Ma kə na: “A ntsee dikə tsa, anay mbəl bələkwə bakə tsaa niy ndara gha va. Avanay tsahwəti mbəl bələkwə bakə diɓa, sa zəməvee, mbə zhəghə dəvə lə gəna ndara gha va” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma kə ndə gəna tsa va ngəci na: “Wəzə mənti gha, ndə sləni tsa wəzə tsa nza gha, lə nəfə kwətiŋ ghərati gha sləni gha. Wəzə ghərati gha sləni jəw na na ndaŋee. Nana kiy, ta ndaŋa na dikə na sləni dzee mbə dəvə gha, na nza bama ti, a gha ghəra. Səəkə a gha nzəyŋa, ka vəshi lə ya” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dza ntsa ɓanavə məndi va mbəl bələkwə kət kətikəvay kwərakwə ki. Ma kə na: “A Ntsee dikə tsa, ta na tsee ghənəy, e sənaŋa, ntsa ghyanakə tsa nza gha. Ghay, ya kala tsəŋwəhwə hwəlfə gha tə za na, kar ghaa slahwə shiy tə za va, ya kala ghərahwə sləni gha na, mbə pəla kwəmavə shiy ghaa nza. ");
INSERT INTO bcw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ava va tsəgha ghəratəra hazləni nee. Ma dzee na mbaꞌee lati kəꞌwə, pən sliɗ yən mbələyŋa gəna gha va kwaɓa. Avanta, ava sa gha” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ma kə dikə tsa ci va ngəci na: “Ndə mar tsa kwamətsəni tsa, ndə ghəra sləni tsa gəmgəm tsa nza gha. A gha sənay, mbə sla shiy kee nza, ya tə za tsaŋwati mee hwəlfə, ka pəla kwəmavə shiy, ya kala ghərahwə slənee, pə gha. ");
INSERT INTO bcw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ghənzə tsəgha kiy, mbaꞌa pə gha niy sənay nza, ka zhəghə dəvee liw pə ghay, ə ka gha ɓanavə gənee va kaa tsahwəti ndə nza, ma nza ghəci zhəghə dəvə li. Sa kee səəkə na, nzee ɓasə see və, lə yam ti nza” kə kaa ntsa va. ");
INSERT INTO bcw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","A kə kaa mbəzli na: “A mbəzli ni, ɓantim mbəl tsa bələkwə tsa va və ta dəvə ci, a ghwəy zhiniy ɓanavə kaa ntsaa zəməvə mbəl bələkwə cifə vaa dzəkən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sa nzanay, ma ntsaa kwəmavə shiy, dza na ka ghəra sləni ghəci li shiy, ta mətsahanavə shiy dza məndiy dzəkən shi. Ghalaɓa kiy, tərəŋw dza shiy nza və. Ma ntsaa kwəmavə shiy va, kala zhəghə dəvə ghəci li shiy, ə dza məndi zhiniy ɓəhwə ya ni jəw ni va shiy və. ");
INSERT INTO bcw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta na ndə sləni tsaa mbata ma tsa ya namaɓa kwəmay, ɓəvəm a ghwəy bəzlakəvəriy dzəti ngwəla dzəmbə kwəsli, a ghəci sa ngəraꞌwə, ka wawahə, ka pəpərə sliꞌi ci pəriɓa” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dzəghwa ma kə Yesəw diɓa na: «Ma fəca dzee səəkə yən Zəghwə yakə ndə ngəri mbə shəndəkə tsee, lə ka kwal Hyala kwasəbee gwanashiy, ta nzəyra dzee kwa gəzli mazə. ");
INSERT INTO bcw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ka hwəlfəhi mbəzli tə hiɗi gwanashi dzay, ɓasə ɓasə ghəshi ɓasəshi kwa kwəmee. Kee dza ki na, ka təra nihwəti mbəzli səvəri mbə nihwəti, njasa ka ndə makə shiy vaa təra teŋkesli səvəri mbə kwəy. ");
INSERT INTO bcw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sa kee dzay, mbaꞌee təraghə mbəzli slar slar ni kwa kwəma Hyalaa dzar bəla kwa bəzəmee. Ma niy dzaa tərə na, tə kwa zleɓee niva. ");
INSERT INTO bcw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ma pən dzaa ni yən mazə kaa ni təraghee va mbəzli dzar bəla kwa bəzəmee ki na: “Na na ghwəy ghwəy mbəzli dərniti Dirə niy, səəkəm a ghwəy dzəmbə pətsa sləkə Hyala tsa gwəmatəŋwəy məndi mbəradzəy, ghala ngati na hiɗi! ");
INSERT INTO bcw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sa nzanay, niy nza na, e niy nza lə mara, dza ghwəy mbaꞌa ghwəy niy ngavəra shi zəmə, ka ghəraɗa ndir niy nza, mbaꞌa ghwəy niy samiyra yam. Ghala saa niy nzee ndə məlməy, a ghwəy niy kaꞌwətəra wəzə wəzə. ");
INSERT INTO bcw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sa niy nzee diriŋɗay, a ghwəy niy ndara kwəbeŋer dzəkən ghən tsee. Sa niy nzee gwərapəray, a ghwəy niy tsəva kənee. Sa niy kəsaghwara məndi kwa fərshinay, a ghwəy niy səəkə mbə nighəra” pən taa ni ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ma kə mbəzli slar slar ni va kwa kwəma Hyala dzaa ni ngəra ki na: “A Ndə sləkəpə, hwəm niy səəkə ghəy naŋa, gha lə maŋa, mbaꞌa ghəy ngavəŋa shi zəməa? Hwəm niy səəkə ghəy naŋa, gha lə ndir, mbaꞌa ghəy niy samiyŋa yama? ");
INSERT INTO bcw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hwəm niy səəkə ghaa kəsaŋəy ghaa ndə məlmə, mbaꞌa ghəy kaꞌwətəŋaa? Hwəm niy səəkə ghəy naŋa, gha diriŋ ŋa, mbaꞌa ghəy niy ndaŋa kwəbeŋer dzəkən ghən ghaa? ");
INSERT INTO bcw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hwəm niy səəkə ghəy naŋa, gha gwərapəŋa, ya gha kwa fərshina, mbaꞌa ghəy niy dzaa nighətəŋaa?” kə ghəshi dzaa ni ngəra. ");
INSERT INTO bcw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ma pən dzaa ni yən mazə kaa ngəshi ki na: “A gəzaŋwəy ya, ta na navay, tsəgha na. Ya hwəm niy mananati ghwəy kwəma wəzə na kaa ya tsamaɓa ndə ta ngwarməhira daw daw bərci ni niy, kaa ngəra dəꞌwə ghən tsee mənti ghwəy kwəma va tsəgha” kə. ");
INSERT INTO bcw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Dzəghwa, ma pən dzaa ni yən mazə kaa niy dzar kwa bəla kwa zleɓee va mbəzli ki na: “Ghwəy na na ghwəyəy, katantəvaŋwəyəm kərakə vəghee. Ghwəy ghwəy mbəzli bazlamti Hyala ni. Mbalam dzəti ghwə ngaɗ ngaɗ na məti ma. Ghwə vay, ta fə *ndə jaka tsa Hyala ghəshi lə ni ci ka kwal dzəmbə gwəmati məndi ghala kwataŋata. ");
INSERT INTO bcw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sa wana gəzaŋwəy ya tsəghay, sa nzana mbaꞌee niy nza lə mara kala niy ngara shi zəmə ghwəy. Ka ghəraɗa ndir niy nza na, kalaa niy tira yam ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mbaꞌee niy tsəhəra ka ndə məlmə va ghwəy na, kalaa niy kaꞌwəra ghwəy, diriŋɗee niy nza na, kalaa niy ɓəra shiy ghwəy dzəkən ghən tsee. Mbaꞌee niy nza gwərapəra, zhini mbaꞌam niy kalaghwara kwa fərshina na, kalaa niy tsəva ghwəy kənee” pən taa ni ngəshi na nashi. ");
INSERT INTO bcw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dzəghwa ma kə ghəshi dzaa ni ngəra na: “A Ndə sləkəpə, hwəm niy səəkə ghəy naŋa, gha ya lə maŋa, ya gha lə ndir, ya ghaa ndə məlmə, ya gha diriŋaa, ya gha gwərapəŋa, ya gha kəəli kəəli kwa fərshina na, dzəghwa mbə shi va gwanashi na, kalaa niy kəətiŋa ghəya?” kə ghəshi dzaa ni. ");
INSERT INTO bcw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma pən dzaa ni yən mazə kaa ngəshi na: “A gəzaŋwəy ya, ta na navay tsəgha na: Ya hwəmɓa niy məni ma ghwəy kwəma wəzə na kaa ndə ya kwətiŋ mbə mbəzli daw daw bərci ni ni mbə nəwray, kaa ngəra dəꞌwə ghən tsee niy məni ma ghwəy kwəma va tsəgha kwərakwə” pən dzaa ni ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ma gəla niva mbəzli nashi kiy, dzəti pi tsa nza ngəraꞌwə kala kəɗi ma, paꞌ kwa ndimndim dza ghəshiy dza. Ma na mbəzli slar slar ni kwa kwəma Hyala nashi ki na, ta kwəmavə piy tsaa kəɗi ma dza ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ma sa kəɗiy Yesəw lə ɓəni shi va gwanashi kaa mbəzli ki na, dza na ka gəzə kwəma kaa *mbəzli ta səɗa ci, a kə na: ");
INSERT INTO bcw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«A ghwəy sənay kiy, vici bakə tərə na ta məni makwaghwa *Pakə. Ghala tsə vay, ta kəsəra dza məndi yən Zəghwə yakə ndə ngəri. Sa ka məndi kəsəvəra na, ka məndi dza mbaꞌa məndi ɓanavəra kaa nihwəti mbəzli, nza ghəshi daŋwəraa dzəvəgha tsəm» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə mətikwəkwər mbə *ka Zhəwifə ki, mbaꞌa ghəshi ɓasətəvashi kəghi tsa Kayifə, dikə tsa ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dza ghəshi, mbaꞌa ghəshi sləkati kwəma kwa jipə shi, ta kəsə Yesəw nja dzar kwa tsəhwəli, ta paslamti. ");
INSERT INTO bcw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma kə ghəshi na: «Ma nanzə kiy, əntaa ghwəmmə dzaa kəsə fəca vici Pakə ma. Vantaa mbəzli dzaa pəslishi tə ghwəmmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ghala vəghwə tsa va kiy, mbə məlmə Betani niy nza Yesəw kəghi tsa tsahwəti ndə, Shimaŋw kə məndi kaa slən tsa ci. Ntsa vay, ndə dərna niy nza na kwataŋa. ");
INSERT INTO bcw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma Yesəw mbə zəmə shiy kəyɓa ki na, mbaꞌa nahwəti mali kətəghəvataa dzəvəgha, lə təlimə paf ꞌwərdi kwa ta dəvə nzə. Gəna ɗaŋ məndiy pa ꞌwərdi va. Dza na mbaꞌa shəkambə mbə ghən tsa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma sa nata *mbəzli ta səɗa Yesəw nava kwəma na, mbaꞌa nəfə tsa shi satiy tərəŋw. Ma kə ghəshi na: «Tawa liɗi mali na ꞌwərdi na kia? ");
INSERT INTO bcw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ə ka na zlata liɗi nzə nza, nza ghwəmmə ɗəlamti tə gəna ɗaŋ. Ma nza ghwəmmə tahanavəshi gəna va kaa ka ndərma nza» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dzəghwa mbaꞌa Yesəw fəti ghən ta kwəma gəzə ghəshi va tsəgha na. Ma kə ngəshi na: «A mbəzli ni, tawa səsə ghwəy məhərli mali na tay? Kwəma wəzə na na sa məni na va tə ya! ");
INSERT INTO bcw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sa nzanay, ka ndərma gəzə ghwəy va na tiɓa dza ghwəy nza li shi ya hwəmɓa. Ma na nee kiy, ka dza ghwəmməə nza lə ghwəy tikə ndimndim kiw. ");
INSERT INTO bcw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma ꞌwərdi ɓaslatəra na nay, mbəri tsee na sa gwəmanti na vaa varamti, ta dza ta lara! ");
INSERT INTO bcw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A gəzaŋwəy ya ta na navay, tsəgha na, ya paꞌ kwəmaɓa dza məndiy gəzə Yəwən kwəma wəzə na kaa mbəzli tə hiɗi gwaꞌa gwaꞌay, ta gəzə kwəma mənti na va dza məndi, ka zəzəə dzəkən mali va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dzəghwa Zhəwdasə Isəkariyətə tsahwəti ntsa mbə *mbəzli ta səɗa Yesəw məŋ lə bakə ni, mbaꞌa dzaa kəsashi mbəzli dikə dikə ni mbə *ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma kə kaa ngəshi na: «Ya yən ngati ɗafa ta kəsəŋwəy Yesəw na, wantsa shi dza ghwəy ngavəraa?» kə. Ma sa favə mbəzli va tsəgha na, dza ghəshi mbaꞌa ghəshi gəzəti kwa jipə shi, mbaꞌa ghəshi mbəranavə mbəl mahkan mətsəkə ngəci. ");
INSERT INTO bcw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","War sa kwəmavə Zhəwdasə gəna va tsəgha ki na, mbaꞌa ꞌwati pəla kwal tsaa nga ɗafa ta kəsə Yesəw ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dzəghwa kwa taŋa vici ka məndiy zəmə peŋ tsa kama *is ti mbə, mbaꞌa səəkəta. Dza *mbəzli ta səɗa Yesəw mbaꞌa ghəshi tsəhəshi və, a kə ghəshi ngəci na: «A Metər, kwəma ɗi gha ghəy tatəŋa shi zəmə dza ghaa zəmə mbə makwaghwa Pakaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma kə Yesəw ngəshi na: «Mbalam dzəmbə məlmə, dzakə ghi tsa zana. A pə ghwəy taa ni ngəci sa ghwəy tsəhəŋwəy kəyɓay: “Metər tsa ghəy ghwənikəŋəy na va gha. A kəy: Waa vəghwə tsee məniy na, ma ɗee dzakə ghi tsa gha, ta zəmə shi Pakə, ghəy lə mbəzli ta səɗee, kə” pə ghwəy taa ni ngəci» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dzəghwa mbəzli ta səɗa Yesəw mbaꞌa ghəshi dzaa mənti njasa gəzanakəshi Yesəw va, mbaꞌa ghəshi tati shi zəmə dza ghəshiy zəmə mbə makwaghwa Pakə. ");
INSERT INTO bcw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma sa pəkwəta vici ki na, mbaꞌa kar Yesəw ghəshi lə mbəzli ta səɗa ci va məŋ lə bakə ni nzəyshi ta zəmə shi zəmə ki. ");
INSERT INTO bcw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma kə Yesəw ngəshi ghəshi mbə zəmə shiy na: «Nay ghwəy na, a gəzaŋwəy ya, ta na navay, tsəgha na, a tsahwəti ndə mbə ghwəy kwətiŋəy, ta nga ɗafa dza na tə ya, ta kəsəra məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma sa favə mbəzli ta səɗa Yesəw tsəgha na, ka zhanshi kwəma va tərəŋw, gwanashi. Ya wa ndə na, tapə dzəmbəy mbə ɗəw kwəma va Yesəw: «A Ntsaa sləkəŋəy, yən na nanzə bərkee ɓa na?» kə tsava, tsəgha tsahwəti ɗəw diɓa, war tsəgha ghəshiy ɗəɗəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma kə Yesəw ngəshi na: «Ntsa zəmə ghəy shiy li kwa kwakwa tsa kwətiŋ tsay, ghəci na saa dza va ta nga ɗafa tə ya, ta kəsəra məndi. ");
INSERT INTO bcw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na nee yən Zəghwə yakə ndə ngəriy, ta mətira dzee njasa tsasliti məndi vaa dzəkənee mbə Zliya Hyala. Ma nanzə kiy, tərəŋw dza ngəraꞌwəə nza kən ndə nga ɗafa tə ya tsa va. Wəzəɓaa niy maw ma məndiy yakə dza naa nza və» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma kə Zhəwdasə ntsaa nga ɗafa va ta Yesəw na: «A Metər, yən na nanzə bərkee ɓa na?» kə. Ma kə Yesəw ngəci na: «Wa gha na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma ghəshi mbə zəmə shi zəmə va ki na, dza Yesəw həŋ ɓəvə peŋ. Dza na mbaꞌa mananati ꞌwəsa ti kaa Hyala. Ma sa manamti na ꞌwəsa na, dza na mbaꞌa ngangavəri peŋ tsa vaa ɓanavə kaa mbəzli ta səɗa ci. Ma kə ngəshi na: «Ava ghənzə na vəghee, ɓəm zəməm» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma ləy hwəm na, dza na həŋ ɓəvə hwəpər tsa nza shi sa kwa, dza na mbaꞌa mananati ꞌwəsa kaa Hyala. Ma sa manamti na ꞌwəsa na, dza na həŋ ɓanavəshi. A kə na: «Sashim gwanaŋwəy! ");
INSERT INTO bcw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sa nzanay, ghəshi na miymiy ya, li shi sla Hyala kiri kwa jipə nzə lə mbəzli. Ta shəkəshi dza ghəshi ta mbəzli ɗaŋ, ta mbə Hyalaa pəlata kwəma shi jikir na mbə nəfə nzə. ");
INSERT INTO bcw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ə gəzaŋwəy ya: Ghava na tə ndatsəy, ka zhinee sahwə shi sa ni kala war fəca vici dza ghwəmməə zhiniy sashi ka yəwən jakəjakə lə ghwəy, tə pətsa sləkə Dirə mə ghwəməw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dza ghəshi ka ha cemer, ka fal Hyala. Ma ləy hwəm ki na, mbaꞌa ghəshi səvərishi, ka dzashiy dzəmə kəlaŋ *ꞌWəlivə. ");
INSERT INTO bcw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma kə Yesəw kaa mbəzli ta səɗa ci ki na: «Nay ghwəy na, mbə vərɗi ndatsə nay, ta zlara dza ghwəy kwətiraa hwəŋwəy gwanaŋwəy. Sa nzanay, a Hyala gəzəkə mbə Zliya nzə, a kəy: Ta paslamti ndə ndəghwə shiy dzee, ka teŋkesli ci dzay, mbaꞌa ghəshi zləzləŋərəshi ka dza kwaɓa, ka dza kwaɓa, kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ləy hwəm sa kee zhakatira mbə məti kiy, ta ꞌwatəŋwəy kwal dzee dzaa dzəti hiɗi ka Galile, ma nza ghwəy kəsara mbəɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma kə Piyer kaa zləɓanci na: «A Ndə sləkəpə, na nee neyey, ya gwaꞌa gwaꞌa zlaŋa mbəzliy, ka dzee zlaŋa tepəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma kə Yesəw ngəci na: «A Piyer, a gəzaŋee ta na navay, mbə vərɗi ndatsə na, ka ngələkə gha way, gha zhinti gəzə mahkan səɗa gha: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma kə Piyer na: «Ya ta məti dzee kwasəbə ghay, ka dzee gəzə, sənaŋa yaw, pən tepəw» kə. Dza nihwəti *mbəzli ta səɗa Yesəw va tərmbə, tsəgha ghəshi gəzəkə kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dzəghwa kar Yesəw ghəshi lə mbəzli ta səɗa ci, mbaꞌa ghəshi səəkəshiy dzəti tsahwəti pi. «Getəsemane» kə məndi kaa slən tsa pətsa va. Dzəghwa ma kə kaa ngəshi na: «Nzəyŋwəyəm tikə, e katayvaraa dzarɓa, ta cəꞌwə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dza na mbaꞌa pəməvə kar Piyer ghəshi lə ndərazhi Zhebede va bakə ni kwasəbə ci. Ma ghəshi mbə dza tsəgha na, mbaꞌa her Yesəw ghati dza, ka sla nəfə tsa ci diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma kə kaa ngəshi ki na: «Tərəŋw slay nəfə tsee, ka ɗi pəəslira. Nzəyŋwəyəm tikə kwasəbe, əntaa ghwəy ɓə hi ma» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dza na mbaꞌa kətivə dza bəlakə jəw. ꞌWakəvə na, mbaꞌa ꞌyambə kwəma ci mbə hiɗi. Dza na ka cəꞌwə, a kə na: «A Di, War mbaꞌa kə tsahwəti kwal tiɓay, bashamti ngəraꞌwə tsa va səəkəə dzəkənee. Nanzə kiy, əntaa gha məni war tə sa ɗee ma, war njasa təɓaŋa na ka gha məni» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dza na tərəɗ zhəghəkəvay dzəvəgha mbəzli ta səɗa ci va mahkan ni. Səəkə na na, ghəshi ɓanti hi. Ma kə kaa Piyer ki na: «A nava mbə ma ghwəy nzaynza ləməciŋwəy kwasəbee ya gar tsahi kwətiŋaa. ");
INSERT INTO bcw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ə pə ghwəy nzəyŋwəy ləməciŋwəy, ka cəꞌwə Hyala ta mbə ghənzəə ndəghwəŋwəy, vantaa *ndə jaka tsa nzə ngaɗambəŋwəy mbə məni *kwəma jikir na. Ka ɗi məni kwəma wəzə na ndə ngəri kwa kwəma Hyala mbə nəfə tsa ci ngar ki na, daw bərci vəgha ci ta məni nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zhini na, mbaꞌa katantəvay diɓa kwa baka səɗa ci, ka cəꞌwə Hyala ghəci, a kə na: «A Di, kala tsahwəti kwal tiɓa gar ɓanti ngəraꞌwə tsa kən yay, war ta səꞌwa dzee. War njasa təɓaŋa na kəə məniva» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma sa kəɗiy na lə cəꞌwə Hyala na, zhini na mbaꞌa zhəkəy zhəvəgha mbəzli ta səɗa ci va. Zhəkə na ɓa na, ghəshi tə hi, shaŋ ghəshi ta mbay nzəyshi ləməcishi. ");
INSERT INTO bcw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zhini na mbərəkə zlashi, mbaꞌa katamtəvay diɓa. Dza na mbaꞌa zhiniy cəꞌwəti Hyala kwa mahkana səɗa, war njasa məcana va. ");
INSERT INTO bcw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dzəghwa mbaꞌa zhəkəy zhəvəgha mbəzli ta səɗa ci ki. Ma kə kaa ngəshi na: «A mbəzli ni, him hi tsa ghwəy, ka dəkə vəgha ghwəy na ghwəy. Ava ghwəy nay vəghwə tsee kətikəvay, ta kəsəra məndiy dzəmbə dividivi ka məni kwəma jikir na, yən Zəghwə yakə ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ava ghwəy nay ntsaa ngati ɗafa va tə ya səəkəy, satim a ghwəmmə dzar dzəvəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma Yesəw mbə kərni gəzə kwəma vaa səkwa na, ndəs Zhəwdasə, tsahwəti ntsa mbə mbəzli ta səɗa ci va məŋ lə bakə ni səəkəy. Mbaꞌa mbəzli ɗaŋ tərəŋw kwasəbə, lə kafaꞌihi nihwəti, lə ghədemesli nihwəti. Mbəzli vay, mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə mətikwəkwər mbə *ka Zhəwifə niy ghwənashi na ta kəsə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ma kə Zhəwdasə tsaa ngati ɗafa va ta Yesəw niy ni kaa mbəzli va ghəshi dzaa kafə ki na: «Sa ka ghwəmmə tsəhəmməy, ntsa dza ghwəy vaa nara mbə səkwə njasa ka ndəə səkwə madigayəy, ghəci na. Nza ghwəy kəsə ki» kə niy ni kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsəhə tsa tsəhə ghəshi ki na, karə Zhəwdasə dzay dzəvəgha Yesəw. Ma kə kaa ngəci na: «ꞌWəsa Metər» kə, mbaꞌa səkwəti njasa ka ndə vaa səkwə madigay. ");
INSERT INTO bcw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma kə Yesəw ngəci na: «A madiga, ə pə ghaa məni kwəma səəkə gha ta məni di» kə. War ghwəla ki na, dza mbəzli va ɓasə ɓasakənvashiy dzəkən Yesəw, tasl ghəshi kəsəti tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ꞌWakəvə tsahwəti ntsa tə səəbə Yesəw fəkwatə təɗikəvəri kafaꞌi ci, pətsə kəsləkəghwa sləmə vəgha ghən ndə ghəra sləni kaa dikə tsa ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma kə Yesəw ngəci na: «A ntsee, zhanambə kafaꞌi tsa gha mbə kwəɓək tsa ci. Sa nzanay, ma mbəzli nashi ghwəy va mbə dza lə kafaꞌihi ta dividivi shiy, War kafaꞌi dza naa zamtishi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Favə gha na, yən kə niy ɗi məni tsəgha nzay, e haray Dirə ta kəətira ghəci nza. Ka na dza tiɓata nza na, mbaꞌa ghwənikəra ka kwal ci ɗaŋ tərəŋw ta kəətira. ");
INSERT INTO bcw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kwəma nata ghwəy naa məniva sanay, kwəma tsasliti məndi kwa Zliya Hyalaa dzəkənee na. Mbaꞌa pən niy ni e har Dirə ta kəətira ghəci pən nzay, ka dza kwəma tsasliti məndi vaa mənta nzaw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zhini ma kə kaa mbəzliy kəsə va na: «A mbəzli ni, tawa səəkə ghwəy ta kəsəra lə kafaꞌi mbaꞌa ghədemesli njasa nzee ndə ghəli kia? Vici va vici va ghwəmmə niy nza lə ghwəy mbə *ciki Hyala, ka ɓəni shiyee kaa mbəzli, kalaa niy kəsəra ghwəy ghalaɓa nanzə sa? ");
INSERT INTO bcw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma kwəma nata ghwəy na məntay, ta mbəə dzəghwata kwa kwəmaa niy tsasliti ka gəzə kwəma Hyala va mbə zliya, mənta na tsəgha» kə. Ləy hwəm sa gəzəkə Yesəw kwəma va ki na, ꞌwakəvə mbəzli ta səɗa ci kwərec ghəshi hwəshi gwanashi, mbərəkə ghəshi zlay tiɓa kwətiy. ");
INSERT INTO bcw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dzəghwa mbəzliy kəsəvə Yesəw va mbaꞌa ghəshi ɓəghə Yesəw dzakə ghi tsa Kayifə, dikə tsa *ka ta Hyala. Ghalaɓay, kəghi tsa va niy nza *ka ɓənipə kwəma pəhəti Hyala ghəshi lə mətikwəkwər mbə ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma məndi mbə dza lə Yesəw dzakə ghi tsa va na, dza Piyer ka nəwshi kərakə kərakə, paꞌ kwa tipə dikə tsa ka ta Hyala tsa dikə tsa va. Ma sa tsəhəy na kwa tipə va na, dza na mbaꞌa nzəyəy mbə mbəzliy ndəghwə ghi tsa va, ta mbə ghəciy nashi shi dza məndi ta məni lə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma kəyɓa ki na, dza mbəzli dikə dikə ni mbə ka ta Hyala, ghəshi lə *mbəzliy sləka ka Zhəwifə gwanashi mbaꞌa ghəshi dzəmbəshi mbə pala kwəma dza ghəshiy ɓanavə fəti ti kaa Yesəw, ya dzərvə dza ghəshiy təɓanakən, ta mbə ghəshiy paslamti. ");
INSERT INTO bcw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɗaŋ tərəŋw mbəzli tətəɓanakən dzərvə na, shaŋ ghəshi ta kwəmavə kwəma ka ghəshi ɓanavə fəti kaa Yesəw li. Ma ləy hwəm jəw ki na, ꞌwakəvə nihwəti mbəzli tiɓa bakə, mbaꞌa ghəshi kafəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","A kə ghəshi na: «Aya, a kə ntsa niy niy: “Ma yənəy, e mbay ngəzlamti *ciki Hyala tsa, mbaꞌee zhiniy ngakati mbə vici mahkan” kə niy ni» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma sa gəzəkə mbəzli va tsəgha na, dza dikə tsa ka ta Hyala pəlhəm satiy, ma kə kaa Yesəw na: «Na ntsa, a shiy mənishi zləɓa ma gha kwemer gəəzə məndi niy dzəkən gha shəka?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dzəghwa Yesəw naci dighevə catavay, zhini ma kə dikə tsa ka ta Hyala tsa va ngəci na: «Avee dzaa ɗəw kwəma va gha, nza gha zləɓakəŋəy. Lə slən tsa Hyalaa ɓəka piy ɗəwee va gha, mbaꞌa pə ghaa *Kəristəw Ntsa tivə Hyala, Zəghwə Hyalay, mbaꞌa gha gəzaŋəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma kə Yesəw na: «Yə, tsəgha na njasa gəzə gha va. Ə gəzaŋwəy ya, ghala ndatsəy, tə dəvə kwa bəzəmə Hyala kwa bərciy sləkə shiy gwaꞌa dza ghwəy nara mənzəy, yən Zəghwə yakə ndə ngəri. Zhini diɓay, ta nara dza ghwəy yən mbə səəkə mbə kwəleɓi mə ghwəmə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma sa favə dikə tsa ka ta Hyala tsəgha na, dza na kwəbaŋ tsa kən ghən ci, kwəyah kwəyah ghəci slakwanti, sa satiy nəfə tsa ci. A kə na: «Ava ntsa va sawanti Hyala. Wəkə na nava tsəgha, ka ɗi mbəzli ghwəmmə ta ndəgha fəti ta kwəma mənti na ghwəlaw. A ghwəy favə njasa sawa na Hyala dəꞌwə ghən tsa ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Naa njaa na na təkə ghwəy dzəkən baya?» kə. Ma kə ghəshi ngəci na: «A gəzəkə *kwəma jikir na, gar pəəsli na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dza ghəshi ka titifə ndighwər dzəmbə kwəma ci, ka ndəkwə lə dəvə. Ma nihwəti na, ka sləva dəvəə dzəvəgha ghən ci. ");
INSERT INTO bcw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ma kə ghəshi na: «Gha na Kəristəw, ca a Hyala cətəŋa, a gha gəzaŋəy sana di, nda wa ntsaa ləkəŋa va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Piyer mənzəy kwa tipə tiɓa kəghi tsa dikə tsa *ka ta Hyala tsa va ki na, dzəghwa nahwəti maliy ghəra sləni kəyɓa, kət kətəghəvataa dzəvəgha. A kə kaa Piyer na: «Ghay ntsay, tsahwəti ntsa kwasəbə Yesəw ndə ka Galile tsa va nza gha» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dzəghwa Piyer ka vəraslə kwa kwəma mbəzli gwanashi ki, a kə na: «Sənata gəla kwəma ɗi gha na gəzee sana nee kiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dza na mbaꞌa kafəy dzaa nzəyəy vəgha miy dəgha. Dzəghwa nahwəti mali kwa ghəra sləni ɓa mbaꞌa nighəvə. Ma kə kaa mbəzli tə pətsa va na: «Ma ntsa nanzəy, ntsaa niy nza kwasəbə Yesəw ndə ka Nazaretə na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma sa favə Piyer tsəgha na, ka zhini ghəciy vəraslə, ma kə na: «Yən na neyey, e zəməkə ya fəla, sənay ntsa vee tepəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dza war ghwəla jəw diɓa na, kət mbəzli tiɓa kətəghəvashiy dzəvəgha Piyer. A kə ghəshi ngəci na: «A ntsa, na kataŋ kataŋ nay, tsahwəti ntsa mbə mbəzli ntsa ni nza gha. Ghala mbə gəzə kwəma gha liw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dzəghwa Piyer tapə ta zəmə lə fəlata ki, a kə na: «Tiɓa tepəw, tsamtəra Hyala yən kəə sla dzərvə, sənay ntsavee na yaw!» kə. War sa gəzəkə Piyer tsəgha ki na, ꞌwakəvə ngələkə tsəgha, mbaꞌa way tiɓata ki. ");
INSERT INTO bcw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma sa favə Piyer wa ngələkə tsa va na, nzaꞌjəw ghəci zəzəvə kwəmaa niy gəzanakə Yesəw va. Ma kə Yesəw niy ni ngəciy: «Ka ngələkə gha way, gha zhinti gəzə mahkan səɗa gha: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha» kə Yesəw niy ni ngəci. Ma sa zəzəti Piyer kwəma mənti na va na, dza na pəlhəm satiy, mbaꞌa səvəriy tə ngwəla, ka wahə ghəci tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ma pəətə mekəshi mekəshi ki na, dza mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə mətikwəkwər mbə ka Zhəwifə, mbaꞌa ghəshi ɓasətəvashi, mbaꞌa ghəshi sləkati ɓasanakən ngwəvə kaa Yesəw ta paslamti. ");
INSERT INTO bcw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dza pəhə ghəshi pəhəti, mbaꞌa ghəshi pəməghə kaa ngwəmna Pilatə, ta ɓasə ngwəvəə dzəkən. ");
INSERT INTO bcw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dzəghwa ki, mbaꞌa Zhəwdasə tsaa ɗəlanavə Yesəw va kaa mbəzli favə: «A məndi ɓasanakən ngwəvə dza ta pəəsli ci kaa Yesəw» kə məndi. Ma sa favə na na: «Yən sənay nza» kə. Dza na həŋ ɓəvə mbəl tsa mahkan mətsəkə tsa va niy ɓanavə məndi tə Yesəw. Kə mbaꞌa zhananakəvə sa mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə mətikwəkwər mbə *ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A kə ngəshi na: «A ya, avam gəna ghwəy va. Kwəma jikir naa sava məntee, sa nzana, mbaꞌee ngati ɗafa ta ntsaa təvəti ma kwəma, ta pəəsli məndi» kə. Ma kə mbəzli va ngəci nashi ki na: «Əh, əndaw shiy, war gha sənay nay, wa kwəma ghəy mbə na na ghəya?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma sa favə Zhəwdasə tsəgha na, dza kihwə, kihwəy gəna va mbə *ciki Hyala. Kə war ka səvəriy tsəgha, mbaꞌa dzaa ɓərtamti ghən tsa ci lə zəꞌwə. ");
INSERT INTO bcw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dzəghwa mbəzli dikə dikə ni mbə ka ta Hyala mbaꞌa ghəshi pati gəna va. Ma sa pati ghəshi, a kə ghəshi kwa jipə shi na: «A ghwəmmə sənay, kwal va ghwəmmə ta jakə gəna tsətsə naa dzəmbə gəna fə ghwəmmə ta sləni Hyalaw. Sa wanay, sa nzana gəna kwəmavə məndi tə miymiy ndə ghənzə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma sa gəzəkə ghəshi tsəgha na, dza ghəshi ka sləka kwəma kwa jipə shi ki, a kə ghəshi na: «Pavə za ghwəmmə tə gəna va, ta la ka məlməə dza bəkwəshi» kə ghəshi. Sa sləkati ghəshi tsəgha na, mbaꞌa ghəshi pavə za, va tsahwəti ndə nga ghəəni. ");
INSERT INTO bcw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Va tsəgha nzana, ya paꞌ sana na «za miymiy» məndiy har slən tsa za va. ");
INSERT INTO bcw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Shi vay, war njasa niy gəzəkə *Zhereməy ndə gəzə kwəma Hyala va mənishi ghəshi. Ma kə niy niy: Mbəl tsa mahkan mətsəkə tsa vay, tsəgha niy zləɓavə ka *Izərayel waa dzəti ntsa va. Sa dza ghəshiy, mbaꞌa ghəshi ɓəvə gəna va, ");
INSERT INTO bcw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mbaꞌa ghəshi dzaa pavə za ti va ndə nga ghəəni, war njasa niy gəzəkəra Ndə sləkəpə vay, tsəgha mənti ghəshi, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma sa pəməghə məndi Yesəw dzəghwa kwəma ngwəmna Pilatə ki na, dza məndi mbaꞌam garəy kwa kwəma ci, tapə ngwəmna ta ɗəw kwəma və, a kə na: «Mazə tsa *ka Zhəwifə nza gha na ntsa?» kə. Ma kə Yesəw ngəci na: «Njasa gəzə gha va na» kə. ");
INSERT INTO bcw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dza mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə mətikwəkwər mbə ka Zhəwifə, mbaꞌa ghəshi kafəshi ta ɓə fəti kaa Yesəw. Tərəm Yesəw nzəyəy kala zləɓa ma kwəma. ");
INSERT INTO bcw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma kə ngwəmna ngəci ki na: «A favə ma gha fəti ɓəɓəŋa ghəshi va ghənghən ghənghən na shəkəna?» kə ");
INSERT INTO bcw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yesəw naci ki na dighevə catavay ghalaɓa, kala zhiniy zləɓa kwəma ya kwətiŋ nzə. Tərəŋw nava kwəma mananati maɗaŋa kaa ngwəmna ki. ");
INSERT INTO bcw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Njasa sənaɓəy ngwəmna mbə məni nzəy, ya hwəmɓa war səəkəta ma vici *makwaghwa Pakəy, kar naa pəlanayshi tsa ɗi mbəzli ndə kwətiŋ, mbə mbəzli kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ghala pətsa kəsə məndi va Yesəw ki na, mbaꞌa tsahwəti ndə niy nza tiɓa kəəli kəəli kwa fərshina. «Yesəw Barabasə» kə məndi kaa slən tsa ci. Ndə rəɗa tsa tərəŋw tsa ghəci niy nza. ");
INSERT INTO bcw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dzəghwa ngwəmna Pilatə ki, ka ɗəw va mbəzliy ɓasəshi va tə pətsa va, a kə na: «A nə ya ngəŋwəy kiy, wəzəɓa tsama ndə ɗi ghwəy yən pəlayŋwəy mbə mbəzli bakə ni nia? Yesəw Barabasə shəkənaa, naa wəzəɓa Yesəw tsa har məndiy *Kəristəw?» kə. ");
INSERT INTO bcw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na na Pilatəy, aa niy sənay, ə hərhə mbəzli dikə dikə ni mbə ka ta Hyala ghəshi lə mətikwəkwər mbə ka Zhəwifə va Yesəw, va tsəgha kəsanaghə ghəshi, kə. ");
INSERT INTO bcw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma ngwəmna Pilatə mənzəy tə pətsa ka məndiy sla ngwəvə ki na, ndəs tsahwəti ndə səəkəy sa ghwənikə mali ci. Ma kə ntsa va ngəci na: «A kə mali ghay ngwamənay: “Ntsa vay, əntaa gha dzaa mananci *kwəma jikir na ma. Fəti vəw, ntsa slar tsa na. Ndatsə həvirəy tərəŋw shiwəhwee shiw li ka dza heree” kə» kə ntsa va. ");
INSERT INTO bcw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dza mbəzli dikə dikə ni mbə ka ta Hyala, ghəshi lə mətikwəkwər mbə ka Zhəwifə, cəkeꞌ ghəshi həərəvəri mbəzli. «Pəlayŋəy Barabasə, mbaꞌam pəəsliti Yesəw, pə ghwəy taa ni ngəci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Zhini ngwəmna ki, ka ɗəw və shi, a kə na: «A nə yay, tsama ndə na sa ɗi ghwəy mbə mbəzli bakə ni ni yən pəlayŋwəya? Gəzaram» kə. Ma kə ghəshi ngəci na: «Pəlayŋəy Barabasə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dzəghwa ma kə ngəshi na: «Ya Yesəw tsa har məndiy Kəristəw naci kiy, njaa kee mənti lia?» kə. Ma kə ghəshi ngəci gwanashi na: «Na naciy, war daŋwə pə gha daŋwavəgha vəgha tsəm» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Zhini ma kə ngwəmna Pilatə ngəshi ɓa na: «Əy, wa na kwəma təvəti ntsa gar daŋwə məndiy dzəvəgha tsəm kia?» kə. Zhini ghəshi mətsəhə, ghəshi mətsəhəti zlapə gəzə nzə zlaŋzlaŋ diɓa: «War daŋwə pə gha daŋwavəgha vəgha tsəm» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dzəghwa mbaꞌa Pilatə nighəti, shi dzee mənti tiɓa lə gəzə kwəmee naw, kə. Sa nzana, war ꞌwaŋə saa mətsəhəva. Sa nighəti na tsəgha na, dza na ti tivə yam, kə piꞌ peməti dəvə ci tiɓa kwa kwəma mbəzli gwanashi. A kə na: «Avam ghwəy nata dəvee. Yən mbə kwəma pəəsli ntsa na na yaw, war kən ghən tsa ghwəy kə sa ghwəy taa nza» kə. ");
INSERT INTO bcw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma kə mbəzli va gwanashi na: «Tsəgha na, a ghəy zləɓavə. War va ghəy, lə va ndərazhi ghəy gwaꞌa kə Hyala dzaa ɗəw kəsli kərhiy dzəghwa ntsa va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dzəghwa Pilatə wərət pəlanayshi Barabasə, mbaꞌa gəzanshi kaa mbəzli, a ghəshi dəꞌwəvə Yesəw lə kwərpə, ləy hwəm na, nza ghəshi ɓanavəshi mbə dəvə shi, nza ghəshi dzaa daŋwəə dzəvəgha tsəm. ");
INSERT INTO bcw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dza ka sawji ki, mbaꞌa ghəshi pəməghə Yesəw dzakə ghi, dzəti pi sla ngwəvə tsa ngwəmna. Sa dzakə ghəshi na, mbaꞌa ghəshi ɓasakənvashiy dzəkən lə nihwəti ka sawjiy tərmbə gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dza ghəshi kwərat kwərat ghəshi saramti nici kwəbeŋer kən ghən ci, kwəp ghəshi panakən kwəbaŋ tsa ghəm tsa, nja sa mazə. ");
INSERT INTO bcw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mbaꞌa ghəshi mbərəti tekesli nja məgapa pəərə ghən mazə, sərə ghəshi səranambəshi mbə ghən tsa ci. Dza ghəshi mbaꞌa ghəshi ɓəvə gətaa fanambə mbə dəvə kwa bəzəmə ci. Dzəghwa ghəshi ki tsətsəfəkwə ghəshi tsəfəkwəshi kwa kwəma ci, ka sawa sa shi. Ma kə ghəshi ngəci na: «A mazə *ka Zhəwifə, ava ghəy səkwətəŋa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dza ghəshi ka titifə ndighwər dzəti, dzəghwa laŋ, ghəshi ɓəhwə gəta ta dəvə ci va, ta dəꞌwə li kwa ghən ci. War tsəgha ghəshiy məni. ");
INSERT INTO bcw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dzəghwa sa kəɗishi ghəshi lə sawa ci tsəgha ki na, mbaꞌa ghəshi səramti kwəbaŋ tsa kən va, mbaꞌa ghəshi zhananakən kwəbeŋer ci. Dza ghəshi pəm ghəshi pəməvə ta dza ta daŋwəə dzəvəgha tsəm ki. ");
INSERT INTO bcw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma ghəshi mbə səvəri mbə məlmə na, bəgəm ghəshi kwəmay lə tsahwəti ndə ka Shiren, Shimaŋw, kə məndi kaa slən tsa ci. Dza mbaꞌa ghəshi mbaranavə ɓə tsəm tsa dza məndi va ta daŋwə Yesəw dzəvəgha kaa ntsa va. ");
INSERT INTO bcw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dza Shimaŋw həŋ ghəci ɓəvə tsəm tsa va. Dza ndəs ghəshi tsəhəshi tə pətsa har məndiy «Gwalgwata». Gwalgwata vay, pi nja pa ghən ndə ngəri ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma sa tsəhəshi ghəshi tə pətsa va ki na, mbaꞌa ghəshi ɓəvə tay tsa dzavəɗi dzavəɗi tsa lə shi ꞌyaghwakəghwak ni. Həŋ ghəshi ɓanavə kaa Yesəw, ta sa ghəci. Ma sa nə Yesəw gwərətə kə dzəghəti na, kala ɗi ghəci. ");
INSERT INTO bcw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dza ghəshi ki daŋwə ghəshi daŋwavəgha vəgha tsəm. Mbaꞌa ghəshi tihəhwə kwəbeŋer kən ghən ci kwa jipə shi lə ti dandərɗə. ");
INSERT INTO bcw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sa tihəhwə ghəshi kwəbeŋer ci va ki na, dza ghəshi mbaꞌa ghəshi nzəyshi tiɓa vəgha, ta ndəghwə ci. ");
INSERT INTO bcw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dzəghwa mbaꞌa ghəshi ɓəvə shiy tsaslati kwəma ɓanavə məndi fəti ti. Ma kə ghəshi kaa kwəma va na: «Ntsay, ghəci na Yesəw, mazə tsa *ka Zhəwifə» kə ghəshi. Dza mbaꞌa ghəshi sərəy shi tə ghən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mbaꞌa məndi daŋwavəgha nihwəti mbəzli ka ghərapə bakə tə ni shi shəghwə tiɓa vəgha Yesəw. Ya wa ndə na, tə tsa ci tsəm, tar bəla kwa bəzəmə tsahwəti, mbaꞌa tsahwəti tar kwa zleɓi ci məndi fəyshi vəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dzəghwa mbəzliy dza dzashi dzar vəgha pətsa va, ka sawa Yesəw, ka tsəərə, ");
INSERT INTO bcw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a kə ghəshi na: «Awə pə gha ɓay, gha gha saa niy ɗi tsaa ngəzlamti *ciki Hyala, zhini ka ngakati mbə vici mahkanta pə gha niy niy, ca mbəlanti ghən tsa gha dəꞌwə ghən tsa gha sana di. Ndata Zəghwə Hyala nza gha kataŋəy, səkwaŋa tə tsəm tsa di!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zhini tsəgha mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala, mbaꞌa mətikwəkwər mbə ka Zhəwifə sawa diɓa, a kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ma nihwəti mbəzli mbaꞌa ghəci mbalamtishi na, kala dza ghəci mbəə mbəlanti tsa ci ghən kwərakwə shəkəna. Mazə ka *Izərayel gee kə ɓay, səkwa kə səkway tə tsəm tsa va sənzənva di. War mbaꞌa kə səkwayəy, ta ɓanavə nefer ghwəmmə dza ghwəmmə. ");
INSERT INTO bcw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","War kaa Hyala ɓanavə na nəfə tsa ci, “Zəghwə Hyala nzee” kə. Eh yaŋ, wəzə tsəgha, war nighə pə ghwəmmə nighə di na ghwəy, nda nza Hyalaa ɗi va mbəlanti sənzənva di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mbəzli ka ghərapə bakə ni va daŋwəy məndi vəgha Yesəw na, tsəgha ghəshi zhiniy sawa kwərakwə diɓa. ");
INSERT INTO bcw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma sa mənta vici tarə kwa ghən ki na, dzəghwa tərkwəsl pi məniy, ya paꞌ kwəmaɓa tə hiɗi gwaꞌa gwaꞌa, paꞌ tsahi mahkan hetihwer na war tsəgha pi. ");
INSERT INTO bcw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma geꞌi lə tsahi mahkan ni va ki na, dza Yesəw ka zlapə kwəma zlaŋzlaŋ, a kə na: «Eli, Eli, lama sabakətani?» kə. Ma ɗi kwəma vaa gəzəy: «A Hyalee, a Hyalee, wa shiy mənishi ndəghamtəra gha kia?» ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mbaꞌa nihwəti mbəzli mbə mbəzliy nza tə pətsa va favə kwəma gəzəkə na va, a kə ghəshi na: «Aya, wa avacim haka *Eli» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ghavə tsahwəti ndə tiɓa kwətiŋ mbaꞌa kəsləghə bali, mbaꞌa dzaa ɓəvə shiy nja səwsə, kə yəkwə yəkwambəshi mbə tay tsa ndalakwəlakwə tsa, səəkə na pəərə tə gəta ka ɓanci, a ghəci sa. ");
INSERT INTO bcw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dzəghwa ma kə nihwəti mbəzli tiɓa kaa ntsa va na: «Zlay, a ghwəmmə nighə di, nda kataŋ dza Eli tsa vaa səəkəə mbəlanti» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zhini Yesəw diɓa mbaꞌa ngwəmata lala zlaŋzlaŋ, mbaꞌa mətiy ki. ");
INSERT INTO bcw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ghala pətsa məti na va na, ꞌwakəvə kwəmtə tsa pəhəy məndi ta təhəvəri pətsa mbə *ciki Hyala, bakə mbə sləkwəvərivay, ghala səəkə mə ghən tsa ci paꞌ kwakə tə mətsəni. Dza hiɗi ka gərgərəva, ka wəwəreɗi kələɓahi. ");
INSERT INTO bcw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dzəghwa kwəlihi mbaꞌa ghəshi ghwəghwənishi. Mbəzliy niy bəbəkwəshi mbə mbəzliy nəw kwəma Hyala na, ɗaŋ ghəshi satishi mbə məti. ");
INSERT INTO bcw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sa satishi ghəshi mbə məti na, mbaꞌa ghəshi səsəəməshi kwa kwəli. Ma ləy hwəm sa sati Yesəw mbə məti ci na, mbaꞌa ghəshi dzashiy dzəmbə Zherəwzalem məlmə Hyala. Ma mbə məlmə va ki na, mbəzli ɗaŋ tərəŋw niy nashi. ");
INSERT INTO bcw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ghala pətsa gərgərəshi hiɗi va kiy, tiɓa niy nza dikə tsa ka sawji bələkwə, ghəshi lə ka sawjiy niy nza kwasəbə mbə ndəghwə Yesəw, ya namaɓa kwəmaa mənta gwaꞌa na, cəkeꞌ ghəshi nata. Sa nata ghəshi tsəgha na, tərəŋw ghəshi hazlənishi. A kə ghəshi na: «Na kataŋ nay, Zəghwə Hyala na ntsa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ghala vəghwə tsa va ki na, mbaꞌa miꞌi niy nza tə pətsa va ɗaŋ, nja vəri kərakəshi, ka nighə kwəmaa məniva lə Yesəw. Miꞌi vay, səəkə mbə hiɗi ka Galile niy nəwvə ghəshi Yesəw, ta kəəti. ");
INSERT INTO bcw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ma mbə miꞌi va ki na, mbə shi niy nza kar Marəy mbə məlmə Magədala, lə Marəy mbəghəshi kar Zhakə lə *Zhezhefə, mbaꞌa mbəghəshi ndərazhi Zhebede. ");
INSERT INTO bcw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma hetihwer ki na, mbaꞌa tsahwəti ndə ka Arimate səəkəy, Zhezhefə kə məndi kaa slən tsa ci. Ntsa nza gəna və tərəŋw ghəci. Ghəci kwərakwə ki na, ntsaa nəw Yesəw ghəci. ");
INSERT INTO bcw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma sa mətiy Yesəw na, dza na mbaꞌa dzaa kəsay ngwəmna Pilatə ta cəꞌwə kwal tsaa dza ta ɓə mbəri tsa Yesəw ta dza ta lamti. Dza Pilatə mbaꞌa gəzanci kaa ndə sawji ta ɓanci. ");
INSERT INTO bcw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma sa ɓanavə Pilatə ki na, dza Zhezhefə ki, mbaꞌa dzaa ɓəvə mbəri tsa Yesəw, mbaꞌa dzaa harambə mbə bahəta wəzə na. ");
INSERT INTO bcw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma sa harəti na na, mbaꞌa faghwa kwa kwəli ci niy lati na kaa ghən tsa ci. Kwəli vay ꞌwar la niy nza na, mbə hakwə niy lati na. Ma sa faghwa na mbəri tsa Yesəw va ki na, dza na mbaꞌa tsəkwəkə hərambəzli dikə naa kalamiy miy kwəli va, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Məniva shi va gwanashiy, tiɓa niy nza kar Marəy ka Magədala ghəshi lə nahwəti Marəy va mənzəy vəgha kwəli. ");
INSERT INTO bcw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma way pi tə həzlimə, fəca *vici dəkəva ka Zhəwifə ki na, mbaꞌa mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *ka Farisahi maɗishi, ka dza va ngwəmna Pilatə. ");
INSERT INTO bcw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma sa tsəhəshi ghəshi, a kə ghəshi ngəci na: «A ngwəmna tsa ghəy dikə tsa. Yaŋ pə gha na gha, a ghəy zəzəvə nahwəti kwəmaa niy gəgəzə Yesəw, ghala pətsaa niy nza na tə ghwəməy. A kə ndə dzərvə tsa va niy niy: “Tə kwa mahkana vicee kwa kwəliy, ta zhakatira dzee mbə məti” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Va tsəgha, wəzəɓa gəzanshi gha na kaa mbəzli, a ghəshi ndəghwə kwəli ci va wəzə, ka vici mahkan na va gəzə na dzar. Kala tsəghay, ta səəkə dza mbəzli ta səɗa ciy ghələhwə mbəri tsa ci kwa kwəli va. Ka ghəshi gwəravə kaa mbəzli na: “Aa zhakatiy mbə məti, tə ghwəməy na” kə ghəshi taa ni. Ghalaɓa kiy tərəŋw dza dzərvə shi vaa kwəmavə bərci taŋ kaa na kwa taŋa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma sa favə Pilatə kwəma va tsəgha, ma kə ngəshi na: «Avam ka sawji va, pəməshim a ghəshi dza ta ndəghwə kwəli va geꞌi njasa dza ghwəy mbay ndəghwə wəzə wəzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dzəghwa ghəshi pəm ghəshi pəməvəshi ka dzashi. Ma sa tsəhəshi ghəshi na, dza ghəshi zlərɓə ghəshi zlərɓakən shiy kən hərambəzli miy kwəli va va, ka nahay wəzə. Sa zlərɓay ghəshi na, mbaꞌa ghəshi garəy ka sawji tiɓa kən, ta ndəghwə nzə ki. ");
INSERT INTO bcw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ma tə way pi ləy hwəm *vici dəkəva, mekəshi mekəshi tə kəɗi pi, fəca ləwma Dəmasə ki na, mbaꞌa kar Marəy ka Magədala ghəshi lə nahwəti Marəy va kafəshi, mbaꞌa ghəshi tsəhəshi vəgha kwəli Yesəw, ta nighəti. ");
INSERT INTO bcw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ghavə hiɗi tsəgha ka gərgərə tərəŋw tərəŋw. Dzəghwa *ndə kwal tsa Hyala kwa Sləkəpə mbaꞌa tsahwəy səəkə mə ghwəmə. Səəkə na tsəkwə tsəkwamti hərambəzliy niy kalamiy məndi va miy kwəli Yesəw. Mbaꞌa fəy vəgha bəla tsarakə, dzəghwa das nzəyəy ti. ");
INSERT INTO bcw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ndəɓa wampiɗi van, pə gha ghəciy mbərə. Ma kwəbeŋer kən ghən ci ɓa na ndəɓa ghwəpə məgapa pə gha tezlezl tsa shi. ");
INSERT INTO bcw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma sa nata ka sawjiy ndəghwə kwəli va va gəla nava kwəmaa mənta va na, kwəp ghəshi tashi va hazləni, war ə ghəshiy gwərgwərə tsəgha, war ndəɓa mbəzli bəkwə bəkwə ni pə gha ghəshi zhəghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma kə ndə kwal tsa Hyala tsa va kaa miꞌi nashi ki na: «A miꞌi, ma ghwəy na na ghwəyəy, ka hazləni ghwəy ma. E sənay, Yesəw tsa daŋwavəgha məndi va vəgha tsəm na sa pəla ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ghəci tikə kwa kwəli naw. Aa zhakatiy mbə məti, njasa niy gəzəkə na va. Ndim a ghwəy nighəti pətsaa niy nza na va kwa məhəni lə mətsə ghwəy! ");
INSERT INTO bcw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mbalam taŋtaŋ, a ghwəy dzaa gəzanshi kaa mbəzli ta səɗa ci, a pə ghwəy kaa ngəshiy: “A Ndə sləkəmmə zhakatiy mbə məti. Pərɓa ghəci dza naa ꞌwaa tsəhəy kən ghwəy tə hiɗi ka Galile. Tiɓa dza ghwəy dzaa nay” pə ghwəy. Ghənzə na kwəma gəzaŋwəy ya» kə. ");
INSERT INTO bcw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma sa favə miꞌi va kwəma va na, tərəŋw ghəshi hazlənishi, tərəŋw ghəshi vəshishi diɓa. Dza ghəshi, kyaŋwkyaŋw ghəshi maɗishi, ka kəsli bali ta dza ta gəzanshi kwəmaa mənta va kaa *mbəzli ta səɗa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ghəshi mbə bali va tsəgha na, vətəghə Yesəw tsahwəy kwa kwəma shi. A kə ngəshi na: «A miꞌi, e səkwətəŋwəy» kə. Dzəghwa miꞌi va kət kətəghəvashiy dzəvəgha, mbaꞌa ghəshi tsəfəkwəshi ka fal, tasl tasl, ghəshi kəsəvə dzar mbə ngeler ci. ");
INSERT INTO bcw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A kə Yesəw ngəshi ki na: «A miꞌi, ka hazləni ghwəy ma. Divam, mbalam a ghwəy dzaa gəzanshi kaa ngwarməhira, a ghəshi maɗiy dzəti hiɗi ka Galile. Tiɓa dza ghəy kwəmə li shi» kə. ");
INSERT INTO bcw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ma miꞌi va kwa kwal ghwəlashi mbə dza ki na, mbaꞌa nihwəti mbəzli mbə ka sawjiy ndəghwə kwəli Yesəw va səəkəshiy dzəmbə məlmə. Dza ghəshi mbaꞌa ghəshi slanakə kwəmaa mənta va gwaꞌa gwaꞌa kaa mbəzli dikə dikə ni mbə *ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma sa favə mbəzli dikə dikə ni mbə ka ta Hyala kwəma va tsəgha na, dza ghəshi mbaꞌa ghəshi ɓasətəvashi ghəshi lə mətikwəkwər mbə *ka Zhəwifə. Sa ɓasəshi ghəshi na, mbaꞌa ghəshi sləkahwə kwəmaa dzəkən shiy mənishi va. Ma sa sləkati ghəshi na, mbaꞌa ghəshi ɓanavəshi gəna tərəŋw kaa ka sawji. ");
INSERT INTO bcw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","A kə ghəshi ngəshi na: «Ava ghəy ndaŋwəy gəna. A pə ghwəy taa ni kaa mbəzliy: “Wa mbəzli ta səɗa ci səəkə naa ghələhwə həvir va ghəy, ghəy tə hi” ka ghwəy ni gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ya ə dza ngwəmnaa favə, mbaꞌa kə dzaa gəzaŋwəy kwəmay, war a ghəy taa sənay njasa dza ghəy zhiniy dəpəti lə kwəma ɓa, ta mbə mbəlantəŋwəy mbə kwəma va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dzəghwa ka sawjiy niy ndəghwə kwəli Yesəw va, həŋ ghəshi ɓəvə gəna va. Mbaꞌa ghəshi nəwti gəzə kwemer va war njasa gəzanshi mbəzli dikə dikə ni va ki. ꞌWakəvə nava dzərvə mbaꞌa zləlivərivata dzar mbə mbəzli ka Zhəwifə. ꞌWava na ghalaɓa, ka sar paꞌ ndatsə. ");
INSERT INTO bcw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dza mbəzli ta səɗa Yesəw va məŋ lə taŋ ni ki, mbaꞌa ghəshi maɗishi, ka dzashiy dzəti hiɗi ka Galile. Sa tsəhəshi ghəshi na, mbaꞌa ghəshi dzashiy, dzəmə bahwaa niy gəzanshi Yesəw va. ");
INSERT INTO bcw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma sa tsəhəshi ghəshi məɓa na, mbaꞌa ghəshi nay ki. War sa nay ghəshi na, dza ghəshi tsəfəkwə tsəfəkwə, ghəshi tsəfəkwəshi. Tapə ghəshi ka pəraꞌwanci dividivi shi, ta fal. Ma nihwəti mbəzli mbə shi na lə kə ghən. ");
INSERT INTO bcw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dza Yesəw ki, kət kətəghəvay dzəvəgha shi. Ma kə ngəshi na: «A Hyala ndara bərciy məni mazəə dzəkən shiy gwaꞌa gwaꞌa. Shi mə ghwəmə, lə shi tə hiɗi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ava va tsəgha, mbalam a ghwəy dzar mbə hwəlfə mbəzli tə hiɗi gwanashi ta gəzanshi kwəmaa dzəkənee, nza ghəshi mənishi ka mbəzliy nəwra! Nza ghwəy mananshi *batem lə slən tsa Didi, mbaꞌa lə slən tsa Zəghwə nzə, mbaꞌa lə slən tsa Safə tsa nzə ɗewɗew tsa. ");
INSERT INTO bcw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɓananshim ɗi fəti ta kwəmee gwanata, njasa gəzaŋwəy ya va gwaꞌa! Ə gəzaŋwəy ya, sənay tə ghwəy, war kwasəbə ghwəy dzee nza, njasa səəmə vici va gwaꞌa, paꞌ fəca dza hiɗiy kəɗishi» kə Yesəw. Ava tsəgha na Yəwən kwəma wəzə naa dzəkən Yesəw *Kəristəw, njasa tsasliti Matiye ki.");
INSERT INTO bcw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Ma kwəma mbə zliya nay, Yəwən kwəma wəzə naa dzəkən Yesəw *Kəristəw, Zəghwə Hyala na. Njasa tsasliti *Ezay ndə gəzə kwəma Hyala vay, tsəgha ghatəvata na. Ma kə Hyalaa dzəkən zəghwə nzəy: «Avee taa ghwənəghə ndə kwal tsee a ghəci ꞌwatəŋa kwal, ta gwəmantəŋa kwal tsa dza ghaa dza kwa, kə Hyala» kə Ezay. ");
INSERT INTO bcw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Zhini ma kə Ezay diɓay: «Ava məli ntsa vaa gaka mbə zlapə mbə gamba, ma kəy: “Gwəmantim nefer ghwəy ta kaꞌwə Ndə sləkəpə, njasa ka məndi vaa zamti kwal wəzə wəzə ta kaꞌwə ntsa dikə tsa, mbaꞌa ghwəy ghwənanamti nefer ghwəy wəzə wəzə” kə məli va» kə Ezay. ");
INSERT INTO bcw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Njasa gəzəkə Ezay va kiy, tsəgha səəkəy Zhaŋ tsaa məni batem mbə gamba. Dza na ka gəzə kwəma Hyala kaa mbəzli, a kə na: «Tsam titihwə kwa kwəma Hyala, zhəghantim nzəy tsa ghwəy, ma nza məndi məntəŋwəy batem, nza Hyala pəlayŋwəy jikir tsa ghwəy mbə nəfə tsa nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dza mbəzli mbə məlmə Zherəwzalem lə nihwəti mbəzli tə hiɗi ka Zhəwde gwanashi mbaꞌa ghəshi səəkəshiy dzəvəgha. Ma sa favə ghəshi kwəma ci va na, mbaꞌa ghəshi cicikəvəri kwəma shi jikir na mənti ghəshi gwaꞌa gwaꞌa. Dza Zhaŋ ka mananshi batem kwa həl Zhərdeŋ ki. ");
INSERT INTO bcw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zhaŋ tsa vay, kwəbaŋ tsa tsati məndi tə shəti ngaləwba niy nza na kən ghən ci, mbaꞌa pəhətəvay səvəri mbə hwər ci lə kanda hwətəɓə. War kar hayer lə mbəzəkwə tsa kwamti ni ci shi zəmə na. ");
INSERT INTO bcw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma kə kaa mbəzli mbə gəzə kwəma ci va na: «A tsahwəti ndə taa səəkə ləy hwəmee, tsava ndəy, aa taŋətəra tə dikə. Məniree gar gələɓə kwa səɗa ci ta pəli yiɗi mbə kwakwahə tsa mbə səɗa ciw. ");
INSERT INTO bcw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yən na neyey, lə yam ngəri məniŋwəy ya batem. Na naciy, lə *Safə tsa Hyala dza naa məniŋwəy batem» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ghala vici va ki na, mbaꞌa Yesəw kafəy mbə məlmə Nazaretə tə hiɗi Galile ta dzaa dzəvəgha Zhaŋ, dza Zhaŋ mbaꞌa mananati batem kwa həl Zhərdeŋ. ");
INSERT INTO bcw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma sa səəməy Yesəw kwa yam na, nzaꞌjəw ghwəmə ghwənita, ka səkwa Safə tsa Hyalaa dzəkən ndəɓa ghərpəpə pə gha. ");
INSERT INTO bcw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma fa na na, məli ndəə gaka, ka gəzanci kwəma səəkə mə ghwəmə, a kə ngəci na: «Gha na Zəghwee, tərəŋw ɗiŋee, mbə vəshi nzee dalala tə gha!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","War ghwəla tsəgha ləy hwəm batem tsa mananati Zhaŋ va na, mbahə Safə tsa Hyala mbahəghə dzəmbə gamba. ");
INSERT INTO bcw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Dzəghwa vici faɗə mətsəkə ghəci mənti tə gamba va. War mbə həərə ndə jaka tsa Hyala ka nighə kwəma ci. War ghəshi lə shəkwadeshi ka naa nza gwaꞌa tsəgha, Ka kəəti ka kwal Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dza məndi ki, mbaꞌa məndi kalambə Zhaŋ tsaa məni *batem mbə ciki fərshina. Ma ləy hwəm sa kalay məndi Zhaŋ na, mbaꞌa Yesəw səəkəy dzəti hiɗi ka Galile, ka gəzəpə Yəwən kwəma Hyala wəzə na. ");
INSERT INTO bcw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A kə kaa mbəzli na: «A vəghwə bərkəy nana, ndəkwə ndəkwə na vəghwə ta səəkə Hyala ta sləkə mbəzli. Tsam titihwə kaa Hyala a ghwəy zhəghanti nzəy tsa ghwəy kwataŋa, mbaꞌa ghwəy zləɓavə Yəwən kwəma wəzə na» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dza maɗ Yesəw maɗiy, ka dza dzəy miy kwəfa Galile. Ma dza na na, mbaꞌa kəsashi kar Shimaŋw ghəshi lə zəmbəghəy Andəre, ghəshi mbə bazla zlekwer dzəti kwəfa ta kəəsə kərpi, sa nza ghəshiy ka kəəsə kərpi. ");
INSERT INTO bcw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma kə Yesəw ngəshi sa kəsashi na na: «A mbəzli ni, nəwram, zlashim kəəsə kərpi, e dzaa məntəŋwəy ka mbəzliy haka mbəzliy səəkə ta nəwra» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dza nzaꞌjəw mbərəkə mbəzli va zlashi zlekwer, mbaꞌa ghəshi nəwhwə. ");
INSERT INTO bcw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma sa nə na kət, kə kaa dza kwa kwəma jəw na, mbaꞌa kəsashi kar tsahwəti ndə lə zəmbəghəy, kar Zhakə lə Zhaŋ, ndərazhi Zhebede ghəshi kwa kwambəwal, ka gwama zlekwer shi. ");
INSERT INTO bcw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Daꞌ Yesəw harhwəshi ɓa, mbaꞌa ghəshi zlay dəshi ghəshi lə mbəzli ka ghəra sləni ci tiɓa kwa kwambəwal, mbaꞌa ghəshi nəwhwə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ꞌWakəvə Yesəw ghəshi lə mbəzli ta səɗa ci va ki, mbaꞌa ghəshi maɗishi ka dzashiy dzəmbə məlmə Kapernahwəm. Ma ghəshi mbəɓa, sa mənta *vici dəkəva na, mbaꞌa Yesəw dzəmbəy mbə *ciki ɓasəva tsa ka Zhəwifə, tapə ghəci ta ɓananshi kwəma. ");
INSERT INTO bcw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma mbəzli tiɓa ki na, mbaꞌa shi ɓananavəshi na va səəvəri məhərli shi. Sa nzanay, niy mənta na ci va kwəma ɓənipə na, nja ɓəni kwəma *mbəzliy ɓənipə kwəma pəhəti Hyalaw, lə bama ti niy nza na ci va kwəma ɓəni na kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma geꞌi ghala pətsa va ki na, mbaꞌa tsahwəti ndə niy nza tiɓa mbə ciki ɓasəva tsa va, lə gazlaka ghəci niy nza və. ");
INSERT INTO bcw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ka ꞌwaŋə, a kə na: «A Yesəw, ndə ka Nazaretə, ta njaa ɗi gha lə ghəya? Ta zamtəŋəy səəkə gha shəkəna? Ma na neyey, e sənaŋa wəzə. Ghay, ntsa ɗewɗew tsa ghwənay Hyala nza gha!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dza Yesəw mbaꞌa ꞌyamanakə cihə kaa gazlaka mbə ghən ntsa va va, ma kə na: «Ɗekəɗekə pə gha. Ə pə ghaa səvəri mbə ghən zal tsa, mbala kərakə!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dza gazlaka va mbaꞌa kəsəy ntsa vaa gwaŋzəti lə bərci tərəŋw, mbaꞌa səvərita lə ꞌwaŋə zlaŋzlaŋ zlay ntsa va. ");
INSERT INTO bcw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mbaꞌa mbəzliy nza tiɓa gwanashi hashishi va nava kwəma, ka ɗəɗəw kwəma kwa jipə shi, a kə ghəshi na: «A na tsətsə na na kwəma kia? Kwəmaa ɓənipə nahwəti yəwən kwəma ki naa, njaa? Gwəravə, mbaꞌa gəzanakə kwəma lə bərci kaa gazlaka na, ka ɗi fəti ghənzə və!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","War ghwəla tsəgha na, nzaꞌjəw kwəma Yesəw pəlita, war ka sla məndi gwaꞌa gwaꞌa dzar mbə məlməhi tə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dzəghwa Yesəw ki mbaꞌa səvəriy mbə ciki ɓasəva tsa va, mbaꞌa ghəshi dzashiy dzakə ghi tsa kar Shimaŋw lə Andəre. Mbaꞌa kar Zhakə ghəshi lə Zhaŋ nəwvə. ");
INSERT INTO bcw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma ghala pətsa va na, mbaꞌa shiy Shimaŋw məhəni ndəɓa ghwə, pə gha vəgha nzə. War sa tsəhəshi kar Yesəw na, mbaꞌa məndi gəzanci kwəma zəlghwə tsa mali va va. ");
INSERT INTO bcw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dza Yesəw mbaꞌa dzəvəghay, dza na tasl kəsəvə dəvə nzə, kafə kafakati tə pi həni. Nzaꞌjəw rəniki vəgha mali va mənta ki. Dza na ka dza ta ɓanshi shi zəmə. ");
INSERT INTO bcw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma sa pəkwəta vici ki na, mbaꞌa mbəzli ɓasanakə nihwəti ka zəleghwer ghənghən ghənghən, mbaꞌa ka gezlekiki kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Teꞌ teꞌ teꞌ mbəzli mbə məlmə va gwanashi ɓasəshi kwa dəgha va. ");
INSERT INTO bcw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dzəghwa Yesəw mbaꞌa mbalamti ka zəlghwə ɗaŋ ni va va zəlghwə tsa shi va ghənghən ghənghən tsa gwaꞌa. Mbaꞌa tahamti lə gezlekiki shi ɗaŋ tərəŋw. Kala ɓanavəshi kwal Yesəw kaa gezlekiki va ta gəzə kwəma. Sa nzana, mbaꞌa ghəshi niy sənay Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma tə həzlimə va mekəshi pəətə, pi ghwəlay həvir ki na, dza Yesəw mbaꞌa kafəy kəghi, mbaꞌa səvəriy mbə məlmə, ka dzay dzəti gamba. Dza na ka cəꞌwə Hyala tə gamba va ki. ");
INSERT INTO bcw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dzəghwa kar Shimaŋw lə nihwəti mbəzli ka ghəshiy nza li shi ka pala ki. ");
INSERT INTO bcw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dza ghəshi ndəs ghəshi kəsay. A kə ghəshi ngəci sa kəsay ghəshi na: «Ava mbəzli mbə pəlaŋa gwaꞌa gwaꞌa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma kə Yesəw kaa zləɓanshi na: «Dzammə ghwəmməə dzəti tsahwəti pi, dzar mbə məlməhi jəw jəw ni ni ndəkwə ndəkwə ni, ta mbee gəzanshi kwəma Hyala kaa ni mbə shi mbəzli kwərakwə. Sa nzanay ghənzə na kwəma səəkee ta məni» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dza na ki, ka dzay dzar mbə məlməhi tə hiɗi ka Galile gwanashi, ka gazanshi kwəma Hyala kaa mbəzli mbə ciki ɓasəva tsa shi, ka titihə hyeler. ");
INSERT INTO bcw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dzəghwa tsahwəti ndə dərna tiɓa, mbaꞌa səəkəy dzəvəgha Yesəw. ꞌWakəvə na tsəfəkwə tsəfəkwəy kwa kwəma ci, ka cəꞌwə kwəma və, a kə na: «A Ndə sləkəpə, war mbaꞌa pə ghaa ɗi sənzənvay a ghaa mbəlantəra ɗewɗew va dərna kənee na» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dza tapə hwər tsa Yesəw ta zhanci ti tsəgha, kaf kafəti dəvə ci mbaꞌa dapay. A kə ngəci na: «E ɗi ghaa mbəliŋa, mbəliŋa kwəriŋ!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nzaꞌjəw dərna va səraɓəta ti, mbaꞌa mbəliy kwəriŋ. ");
INSERT INTO bcw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dzəghwa Yesəw mbaꞌa naɓəti ki, mbaꞌa gəzanci dzay jighi kyaŋwkyaŋw. ");
INSERT INTO bcw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","A kə kaa ngəci na: «Favə tə gha kwəma dzee na ta gəzaŋa wəzə. Əntaa gha dzaa gəzə kwəma mbəli tsa mbəliŋa gha tsa kaa mbəzli ya jəw nzə ma. A pə ghaa maɗi, a gha dzaa canamti ghən tsa gha, njasa mbəliŋa gha kaa ndə ta Hyala. Nza gha dzaa vəliti vəli gha kaa Hyala njasa gəzəkə *Məyizə va, nza mbəzli mbəə sənay gwanashi, a gha mbəliŋa va dərna tə gha, kə ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma ghəci naci ki, war sa dzay na na, mbaꞌa ghati gəzə bar tsa va kaa mbəzli ya paꞌ kwəmaɓa. Kala zhini Yesəw mbəə dzavə dza ghwazhə ghwazhə dzar mbə məlmə ghwəla. Ma sa nzana tsəgha ki na, ꞌwakəvə na mbaꞌa dza nzəyəy kwamti mbə gamba kama mbəzli ti. Zhini mbəzli war ka səəkə və ya dza kwəmaɓa diɓa. ");
INSERT INTO bcw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dzəghwa ləy hwəm hi jəw ki, mbaꞌa Yesəw zhəghəkəvay səəkə mbə məlmə Kapernahwəm, mbaꞌa nzəyəy kəghi. Ma sa favə məndi: «Kəghi na Yesəw» kə məndi na, ");
INSERT INTO bcw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ꞌwakəvə mbəzli mbaꞌa ghəshi ɓasəshi ɗaŋ tərəŋw, kala tərə ma ngwəla gar nzəy ya kwa dəgha nzə gwaꞌa. Tapə Yesəw ta gəzanshi kwəma Hyala kaa mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma ghəci mbə gəzanshi kwəma Hyala va tsəgha, mbaꞌa nihwəti mbəzli faɗə səəkəshi lə ntsa mətita bəla vəgha ci, ɓəɓə kwa ghən shi. ");
INSERT INTO bcw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dzəghwa ki na, mbə ghəshiy tsəhəshi li vəgha Yesəw va ɗaŋ tsa ntsa tiɓaw. ꞌWakəvə ghəshi taram, dzəməshi mə ghən ciki tsa va li mbaꞌa ghəshi ghwənivə kwal geꞌi geꞌi dzəghwa tə pətsa nza Yesəw va. Dza mbaꞌa ghəshi vələghə ntsa va dzəghwa kwa kwal tsa va lə pi həni tsa ci vay gwaꞌa dzəghwa kwəma Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma sa sənay Yesəw, a mbəzli va ndara nefer shi gwanashi, kə, ma kə kaa ntsa mətita bəla vəgha ci va na: «A zəghwee, a *kwəma gha jikir na pəlita!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma ghalaɓa ki na, mbaꞌa nihwəti *mbəzliy ɓənipə kwəma pəhəti Hyala niy nza tiɓa mənzəy. Tapə ghəshi ta zəzə kwəma mbə nefer shi, a kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Njaa ka ntsa va gəzə gəla kwəma tsəgha naa, Hyalaa sawa na. A tsava ntsaa dza vaa mbay pəlatanay kwəma ndə jikir na tiɓa kala war Hyala kwətitaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Gwaꞌa gwaꞌa Yesəw sənata kwəma zəzə ghəshi va tsəgha na mbə nefer shi. Dza na ka ɗəw kwəma və shi, a kə na: «A mbəzli ni, sa wana tətəkə ghwəy kwemer tsətsə ni mbə nefer ghwəya? ");
INSERT INTO bcw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nama kwəma gwəra na ɓəlaŋ, ndə kə ni: “A kwəma gha jikir na pəlita” kə, lə ndə ni kaa ndə zəlghwə: “Sati garəŋa, ɓə pi həni tsa gha, a gha dzaŋa” kaa? ");
INSERT INTO bcw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma kiy, e ɗi ghwəy sənay, a bərci vəya, yən Zəghwə yakə ndə ngəri ta pəlanshi jikir tsa mbəzli tə hiɗi pə ghwəy» kə. Dza ma kə kaa ntsa mətita bəla vəgha ci va na: ");
INSERT INTO bcw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«A ntsa, avee gəzaŋa, sati maɗi ɓə pi həni tsa gha, mbalaa jighi!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","War nzaꞌjəw tsəgha, tsər kwətiŋ, ntsa va kafəy, sati na kaa pi həni tsa ci va cimbəŋ ɓakən, ka dzay tiɓa kwa mətsə mbəzli gwanashi. War nja maɗaŋa nava kwəmaa mananshi kaa mbəzli tə pətsa va gwanashi. Tapə ghəshi mbə fal Hyala, a kə ghəshi na: «Ghala nza ghwəmməy, səəkə ghwəmməə nata gəla nana kwəmaw!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zhini Yesəw mbaꞌa zhəghəghəvay njasaa dzəy kwəfa Galile. Dzəghwa ɗaŋ mbəzli səəkəshiy dzəvəgha, mbaꞌa ghəci ɓananavəshi shiy. ");
INSERT INTO bcw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dza na ki, ka dzay. Ma ghəci mbə dza kwa kwal na, mbaꞌa nay tsahwəti ndə, Levi, zəghwə Alfe, ghəci mənzəy mbə ciki *dəwan. Ma kə Yesəw ngəci na: «Sati, nəwra dzam» kə. Mbaꞌa Levi tsa va satiy ka nəw. ");
INSERT INTO bcw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma ləy hwəm shi va ki na, mbaꞌa Yesəw tsəhəy kəghi tsa Levi ta zəmə shiy. Ɗaŋ nihwəti ka dəwan lə nihwəti mbəzliy məni sləni jikir na nza tiɓa mbə nəw Yesəw. Dza ghəshi gwanashi mbaꞌa ghəshi ɓasəshi, ka zəmə shiy tə pətsa kwətiŋ tsa lə kar Yesəw ghəshi lə mbəzli ta səɗa ci ki. ");
INSERT INTO bcw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dzəghwa nihwəti *ka ɓənipə kwəma pəhəti Hyala lə *ka Farisahi mbaꞌa ghəshi nay Yesəw lə mbəzli ta səɗa ci, ghəshi mbə zəmə shi zəmə va jakə lə mbəzli jikir kwəma ni va. Dza ghəshi ka ɗəw va *mbəzli ta səɗa Yesəw, a kə ghəshi na: «A mbəzli ni, tawa zəmə na shiy jakə lə ka dəwan mbaꞌa nihwəti mbəzliy məni sləni jikir naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dza mbaꞌa Yesəw favə kwəma shi va, ma kə kaa ngəshi sa favə na tsəgha na: «A mbəzli ni, səəkee nashi mbəzli kwəriŋ kwəriŋ vəgha ni mbə dza va dəkwətərəw, ka zəlghwə na shi kee nashiy dza və. Va tsəgha na kiy, yən na nee na, ta pəla mbəzli wəzə ni səəkə yaw, ta pəla mbəzliy məni *kwəma jikir na səəkəree» kə. ");
INSERT INTO bcw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma ghalaɓay, ka məni səwmay mbəzli ta səɗa Zhaŋ lə *ka Farisahi niy nza. Ma ni ta səɗa Yesəw na, kala məni ma. Dza nihwəti mbəzli mbaꞌa ghəshi səəkəshi ta ɗəw kwəma va Yesəw dzəkən kwəma va ki, a kə ghəshi na: «Tawa tivə ma ni gha ni mbəzli ta səɗa gha vici səwmay kwərakwə, njasa məni ni ta səɗa Zhaŋ va lə ni ka Farisahi va mbəzlia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma kə Yesəw kaa zləɓanshi na: «Favə tə ghwəy kwəma dzee na ta gəzaŋwəy. Mbaꞌa kə ndə harvə mbəzli ta zəmə gəzləɓə mətəpa kiy, nza mbəzli va zhiniy tivə vici va ka viciy məni səwmay shəkəna? Ka dza ghəshiy məni səwmay kama na war ghwəlay zal mali tsa va mbə shiw. ");
INSERT INTO bcw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A vəghwə tsa va dzaa səəkəy, sa dza məndiy ɓanti ndə mətəpa kwa jipə shiy, ava ghalaɓa dza ghəshiy məni səwmay ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma kə ngəshi kwa fir ɓa na: «Ndə tiɓaa ɓəvə yar ꞌwarꞌwar ni ta mbəghəshiy dzəti kwəbaŋ tsaa haliyəw. Sa nzana, mbaꞌa kə ndə mənti tsəghay, ta sləkwakar ghən tsa shi dza ni ꞌwarꞌwar ni va yar, mbaꞌa kwal dzaa mətsəhəy dzəti pəhal kwəbaŋ tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ava tsəgha na diɓa, ndə tiɓa ka ꞌyaghwa tay tsa njəmnjəm tsaa dzəghwa ghwəlpə halihali naw. Sa nzana, mbaꞌa kə ndə mənti tsəghay, sa ka tay tsa va maɗiy ta pəsli na, ta wənəhəta dza pəhal ghwəlpə va, ka tay dza na, naꞌi shəkəy dzəti hiɗi gəm. Shi dza məndiy mənivə lə ghwəlpə va tiɓa ghwəla kiw. Dzəghwa yəwən ghwəlpə təɓə na məndiy i tay tsa njəmnjəm tsa kwərakwə ki» kə. ");
INSERT INTO bcw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma tə nahwəti *vici dəkəva ka Zhəwifə na, mbaꞌa kar Yesəw lə mbəzli ta səɗa ci maɗishi ka dza dzəvəri mbə vəh alkamari. Ma ghəshi mbə dza dza va tsəgha na, dza mbəzli ta səɗa ci va ka slərɓə alkamari. ");
INSERT INTO bcw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dza *ka Farisahi ki, ka ɗəw kwəma va Yesəw, a kə ghəshi na: «Nighə dia Yesəw, tawa məni mbəzli ta səɗa gha ni shi makəmmə Zliya Hyala va mənishi fəca vici dəkəva kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma kə Yesəw kaa zləɓanshi na: «Səəkə ghwəy jangəhwə mbə zliya Hyalaa dzəkən kwəmaa niy mənti *Davitə va, ghala vəghwə tsaa niy nza Abiyatar vaa dikə tsa *ka ta Hyala bay sa? Saa niy kəsəvə ma kar Davitə lə mbəzli kwasəbə, ka ɗi zəmə shiy ghəshiy, dza na təhwə dzəmbəy dzəmbə *ciki Hyala mbaꞌa ɓəhwə peŋ tsa ka məndiy ta Hyala li, mbaꞌa zəməhwə. Ya tsəgha niy nə *kwəma pəhəti Hyala ka zəmə peŋ tsa va məndi, kala war ka ta Hyalaw kəy, a Davitə niy dzaa ɓəvə, mbaꞌa zəhwə, mbaꞌa tahanavəshi kaa mbəzli kwasəbə va kwərakwə. Niy naɓəti Davitə Hyalaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zhini ma kə ngəshi na: «Talay, ta wəzə tsa ndə ngəri mənta vici dəkəva. Mənəy ndə ngəri ta nzaa mava tsa vici dəkəvaw. ");
INSERT INTO bcw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sa nzana va tsəgha kiy, yən yən Zəghwə yakə ndə ngəri sləkə na vici dəkəva» kə. ");
INSERT INTO bcw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dza Yesəw mbaꞌa dzəmbəy dzəmbə *ciki ɓasəva tsa ka Zhəwifə diɓa. Dzəmbə na na, tsahwəti ndə mbəɓa məti məti dəvə ci. ");
INSERT INTO bcw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","War sa dzəmbəy Yesəw na, dzəghwa nihwəti mbəzli tiɓa, ka fə ghən ti, nda nza naa mbəli ntsa va fəca *vici dəkəva va, sa ɗi ghəshi ngali kwəmaa dzəkən ta mbə ghəshiy ɓanci fəti. ");
INSERT INTO bcw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ꞌWakəvə Yesəw tsəgha kaa ntsa məti məti dəvə tsa va: «A ntsa, sati a gha garəŋa tiɓa tə jipə mbəzli!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zhini na tapə, ta ɗəw kwəma va mbəzli tiɓa va, a kə na: «Njaa nə kwəma mbə Zliya Hyalaa? Mənim kwəma wəzə na kaa ndə fəca vici dəkəva nə na shəkənaa? Naa mənim kwəma gəmgəm na nə na? Kwal tsaa mbəlanti piy tsa ndə na sa ndammə na ta naa? Naa tsaa zamti piy tsa ci na?» kə. Dzəghwa dighevəshi ghəshi kala zləɓanci. ");
INSERT INTO bcw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dzəghwa Yesəw mbaꞌa fati mətsə ci ti shi, ka nighəshi lə nəfə lə nəfə, va kwəma caslakə ghən tsa məni ghəshi va tsəgha tsa. Ma kə kaa ntsa məti məti dəvə tsa va ki na: «A ntsa, təɗi dəvə gha va!» kə. Dza ntsa va mbaꞌa təɗiti sa ci, dza dəvə ci mbaꞌa mbəlita kwəriŋ tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ꞌWakəvə *ka Farisahi tə pətsa va, ka dzashi, nzaꞌjəw ghəshi dzaa ɓasəshi lə nihwəti mbəzli mbə mbəzli *Erədə, mbaꞌa ghəshi sləkati kwəma kwa jipə shi njasa dza ghəshiy mbay pəəsliti Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Dza Yesəw kaf kafəy lə mbəzli ta səɗa ci, ka dzay dzəy vəgha kwəfa Galile. Mbaꞌa vərəm tsa mbəzli tə hiɗi ghənghən ghənghən gwaꞌa nəwvəshi. Mbəzliy səəkə tə hiɗi ka Galile, lə tə hiɗi Zhəwde, ");
INSERT INTO bcw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","lə mbəzli mbə məlmə Zherəwzalem, lə ni tə hiɗi Idəme, lə niy səəkə pəriɓa tə miy həl Zhərdeŋ, lə səəkə tə hiɗi Tir lə Shidaŋw. Gwaꞌa gwaꞌa mbəzli va səəkəshiy dzəvəgha, sa nzana mbaꞌa ghəshi favə sləni ghərati na. ");
INSERT INTO bcw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dza Yesəw ki mbaꞌa gəzanshi kaa mbəzli ta səɗa ci a ghəshi katanakə kwambəwal, vantaa mbəzli ɗaŋ ni va ꞌyapamti mbə tsəəkwəva. ");
INSERT INTO bcw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ma sa nzana mbə mbəli mbəzli ɗaŋ ki na, dzəghwa ka zəlghwə gwaꞌa gwaꞌa ka zlighwəva ta səəkəə dzəvəgha, ta dapə. ");
INSERT INTO bcw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma mbəzli nza gazlaka mbə ghən shi kwərakwə ki, war sa nay ghəshi Yesəw na, dza ghəshi ka ndiɓəvaa dzəti pi tiɓa kwa kwəma ci. Ka ngwəmə lala, a kə ghəshi na: «A Yesəw, waa gha na Zəghwə Hyala!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dza Yesəw mbaꞌa naɓətishi, a kə kaa ngəshi lə bərci na: «Ka gəzə kwəma kənee ghwəy ma, əntaa mbəzli dzaa sənara» kə. ");
INSERT INTO bcw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dzəghwa Yesəw mbaꞌa dzəməy mə kəlaŋ, tapə ghəci ta haka mbəzli ɗi naa dzəməə dzəvəgha. Dza mbəzli va mbaꞌa ghəshi dzəməshiy dzəvəgha ki. ");
INSERT INTO bcw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mbaꞌa təravə mbəzli məŋ lə bakə tsəgha ki. Ma kə ngəshi na: «Ghwəyəy ka kwalee nza ghwəy. Ə təravəŋwəy ya, ta nza ghwəy kwasəbee, nzee ghwəniŋwəy ta dza ghwəy gəzə kwəma kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta ndaŋwəy bərci dzee dzəkən hyeler ta tihəshi ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Avanashi slənedemer mbəzli məŋ lə bakə ni va təravə na: Shimaŋw, zhini mbaꞌa Yesəw fanati slən Piyer, ");
INSERT INTO bcw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mbaꞌa kar Zhakə ghəshi lə zəmbəghəy Zhaŋ, ndərazhi Zhebede. Dza Yesəw mbaꞌa fanatishi slən Bəwanergezə, ma ɗi slən tsa va gəzəy «ndərazhi dərazli van» ɗi na gəzə. ");
INSERT INTO bcw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mbaꞌa Andəre, mbaꞌa Fəlipə, mbaꞌa Bartelemi, mbaꞌa Matiye, mbaꞌa Təmasə, mbaꞌa Zhakə tsa Alfe, mbaꞌa Tade, mbaꞌa Shimaŋw ndə pərslə ta hiɗi ci, ");
INSERT INTO bcw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mbaꞌa Zhəwdasə Isəkariyətə, ntsaa ngati ɗafa va ta Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dza Yesəw mbaꞌa dzay dzakə ghi ki. Zhini mbəzli diɓa ngwərfə ghəshi ngwərfəkəvashi. Paꞌ lə shi zəməshi ta kar Yesəw lə mbəzli ta səɗa ci kala kwəmavə kwal zəməhwəshi. ");
INSERT INTO bcw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma sa favə manhiy kwəma va na, mbaꞌa ghəshi səəkəshi ta pəməhwə. Sa nə ghəshi: «Ndə gazlaka na» kə ghəshi mbə gəzə kwəma shi. ");
INSERT INTO bcw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma kə *mbəzliy ɓənipə kwəma pəhəti Hyala, shiy səəkəshi səəkə mbə məlmə Zherəwzalem na: «A mbəzli ni, waa na Belzhebəl, ndə jaka tsa Hyala mbə ghən tsa ntsa va. Belzhebəl tsa va ghəci mazə tsa mbə hyeler ɓanci na bərci tihə na va nihwəti hyeler səvəri mbə ghən mbəzli li shi!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dzəghwa Yesəw mbaꞌa harashi mbəzli ka gəzanshi kwəma kwa fir ta mbə ghəshiy favə, a kə na: «Njaa njaa ka ndə jaka tsa Hyala gay tahamti ghən tsa cia? ");
INSERT INTO bcw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mbaꞌa kə mbəzli dikə dikə ni zəmə hiɗi dzəmbəshi mbə pa jaka kwa jipə tsa shiy, ta ndanishi dza hiɗi shi. ");
INSERT INTO bcw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mbaꞌa kə mbəzli kəghi tsa kwətiŋ tsaa pa jaka kwa jipə shiy, ta ndaniy dza tsava ghi. ");
INSERT INTO bcw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsəgha na lə ndə jaka tsa Hyala kwərakwə ki. Mbaꞌa kə təhəvərivay bakə mbə, ka pa jaka kwa jipə ci lə nahwəti bəla ciy, ta ndaniy dza tsa ci va mazə, gwaꞌa kwəma ci kərkəta tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A ghwəy sənay, ka mbay ndəə pahwə shiy kəghi tsa ndə bərci ɓəlaŋəw. War ndə pəhəti na ndə bərci tsa va lə zəꞌwə kwataŋata dza ndəə mbay pahwə shi kəghi tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ə gəzaŋwəyee, na navay tsəgha na, ma kwəma mənti mbəzli jikir na gwanata, lə kwəma sawa gəzəkə ghəshi gwaꞌay, a Hyala dzaa pəlashi mbə nəfə nzə. ");
INSERT INTO bcw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma na ntsaa gəzakən kwəma sawaa dzəkən *Safə tsa Hyala ɗewɗew tsay, ka dza Hyalaa pəlata nava kwəma mbə nəfə tsa nzə ya hwəmɓaw, *kwəma jikir naa dzaa kəɗi ma na nava ya pa hwəmɓa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma gəzə Yesəw kwəma va tsəghay, va sa niy gəzə nihwəti mbəzli: «A *hil mbə ghən ci!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ꞌWakəvə kar ngwarməhiy Yesəw mbaꞌa mbəghəy ndəs tsəhəshi ki. Dza ghəshi mbaꞌa ghəshi gagarəshi kwa dəgha, dza ɓəŋ ghəshi ghwənəghə ndə ta dzaa haranayshi Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ma ghalaɓa ki na, vərəm ndə ngəri tsaa ɓasəy va tiɓa, dəzlətsəɓə məndi tsəɓay Yesəw mənzəy. Ma kə məndi kaa Yesəw ki na: «A Metər, ava kar məŋa ghəshi lə ngwarməhiŋa pəriɓa tə ngwəla ka ɗəwŋa» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma kə Yesəw kaa zləɓanshi na: «Kadiw e citəŋwəy nee mərə lə ngwarməhira» kə. ");
INSERT INTO bcw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dza na kaa mbəzliy dəzlay va tiɓa njəꞌwə nighəti shi, a kə na: «Avanashi mbəzli niy, ghəshi na nee mərə lə ni ya ngwarməhira! ");
INSERT INTO bcw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sa nzanay, ya wa ntsaa məni kwəma ɗi Hyalay, ghəci na tsee zəmərə lə nee zhamərə, lə mərə. Gwaꞌa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Zhini Yesəw diɓa, mbaꞌa ghati ɓəni kwəma kaa mbəzli miy kwəfa Galile. Dzəghwa tərəŋw vərəm ndə ngəri ɓasəy vəgha. Ma sa nashi na mbəzli ɗaŋshi tsəgha na, mbaꞌa dzay dzəghwa kwambəwal nzəyəy tə kwəfa va. Mbaꞌa mbəzliy ɓasəshi va məkə tə həlbə. ");
INSERT INTO bcw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dza na mbaꞌa ɓananavə kwemer kaa ngəshi ɗaŋ ghənghən ghənghən dzar kwa fir. Ma kə mbə kwəma ci va ɓənipə na na: ");
INSERT INTO bcw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Favə ta ghwəy, ma tə nahwəti viciy, mbaꞌa tsahwəti ndə za maɗiy ta dza ta sləka ha ci. ");
INSERT INTO bcw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma ghəci mbə kihwə ha va ki na, pəriŋ nahwəti ha pəpəriŋətaa dzəghwa kwal. Mbaꞌa ꞌyegwer səəkəə iməhwə nava. ");
INSERT INTO bcw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dza nahwəti mbaꞌa pəpəriŋətaa dzəti kwərhə. War ghwəla na nzaꞌjəw ghənzə pəsəta, sa nzana kala hiɗi kən ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","War sa satita vici ka ndipə na, nzaꞌjəw ha va ghwəlita ki, sa kama hiɗi kən ɗaŋ gar tsəhəvə hililiŋə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dza nahwəti hwəlfə diɓa mbaꞌa pəpəriŋətaa dzəmbə tekesli. Ma sa pəsəta na na, mbaꞌa tekesli kəlishiy dzəkən, kala mbə ghənzəə fə ya ghən nzə. ");
INSERT INTO bcw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma dza nahwəti nanzə ki na, mbaꞌa dzataa dzəmbə hiɗi wəzə ni. Dza na mbaꞌa pəsəta, ka kəli, mbaꞌa ɓəvə hwər pasəta, mbaꞌa fəti ghən, nahwəti na dikə dikə fəti ghən, ɓahwə ɓahwə nahwəti, nahwəti na geꞌi geꞌi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dza ma kə ngəshi ki na: «Ma ntsa nza sləmə və ta fa kwəmay, fə tə ghəci ghən ta kwəma va!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ma sa tərəmbəshi kar Yesəw kwətishi lə nihwəti mbəzli kwasəbə mbaꞌa mbəzli ta səɗa ci ki na, mbaꞌa ghəshi maɗishi ka ɗəw sləkar tsa kwəma fir tsa ɓəlikə Yesəw va və. ");
INSERT INTO bcw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dza na mbaꞌa zləɓanakəshi, a kə na: «Ta na na ghwəyəy, a Hyala ndaŋwəy məhərli ta sənashi shiy dzəkən sləkə tsa dza na ta sləkə mbəzli. Ma na nihwəti niy tərmbə mbəzli nashi kiy, war kwa fir dza məndiy gəzanshi kwəma. ");
INSERT INTO bcw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta mbəə nza: Mbə nay pi ghəshi lə mətsəhi shi na, kala nashi shi nighə ghəshi va ghəshi. Mbə favə kwəma ghəshi lə slimim shi na, kala sənashi shi ɗi kwəma fa ghəshi vaa gəzə ghəshi. Kala tsəgha nzay, a ghəshi taa pəla zhəghəvaa dzəvəgha Hyala nza. Ma nza Hyala pəlanayshi jikir tsa shi mbə nəfə nzə ghalaɓa nza» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A kə Yesəw ngəshi na: «Ya sa favə ma ghwəy kwəma ɗi fir tsa ɓəlikee tsaa gəzə kiy, njaa dza ghwəy favə tsa gwanay tsa fir kia? ");
INSERT INTO bcw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Avanay bazhə tsa kwəma va ki: Ma ndə za tsaa kihwə ha vay, ntsaa gəzə kwəma Hyala kaa mbəzli na. ");
INSERT INTO bcw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nəfə tsa nihwəti mbəzliy, nja kwal tsa pəriŋəta nahwəti hwəlfə ha vaa dzəti na. War sa favə ghəshi gəzə kwəma Hyala na, mbaꞌa ghəshi zləɓavə, war ghwəla na nzaꞌjəw, *ndə jaka tsa Hyala səəkəy ɓanti kwəma va mbə nəfə tsa shi. ");
INSERT INTO bcw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nəfə tsa nihwəti mbəzli ɓa na, nja kwərhə tsa pəriŋəta nahwəti hwəlfə ha vaa dzəti na. Sa ka ghəshiy favə kwəma Hyala na, nzaꞌjəw, ghəshiy zləɓavə lə vəshi. ");
INSERT INTO bcw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Zhini diɓa na, ka nzay nza ghəshi lə kwəma va mbə nəfə tsa shi sa mbay ma kwəma vaa tsəhə hililiŋə wəzə wəzə mbə shiw. War nə ma ngəraꞌwə ndəs kə kəsashi, ya ə ghəzlishi məndi tə mbərkə kwəma Hyala na, ka ghəshiy dza, nzaꞌjəw, mbərəkə ghəshi zlata nəw kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma nəfə tsa nihwəti diɓa na, nja pi ndə tekesli tsa dzəghwata nahwəti ha va mbə ghəci. Gəla niva mbəzli ɓay, sa ka ghəshiy favə kwəma Hyala na, mbaꞌa ghəshi zləɓavə. ");
INSERT INTO bcw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ka ghəshi dza diɓa na mbaꞌa ghəshi dzəmbəshi mbə zəzə kwəma tə hiɗi, ka məni mətsə ta shi tə hiɗi ni ngəɗipə lə nihwəti shi maw vəgha gwaꞌa. Ma sa ka shi va təhay nefer shi ki na, ka ghəshi dza mbaꞌa ghəshi makəti kwəma Hyala va kəli, lə va ghəra sləni mbə nefer shi. ");
INSERT INTO bcw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma nəfə tsa nihwəti mbəzli nashi kiy, nja hiɗi wəzə ni va dzəmbəta nahwəti ha mbə shi na. Ma na gəla niva mbəzli nashi kiy, sa ka ghəshiy favə kwəma Hyala na kar ghəshiy zləɓavə, ka ghəshiy dza na, ka ghəra sləni Hyala wəzə. Nihwəti mbə shi na tərəŋw ghəshi jahambəvashi mbə, nihwəti na bərəkə, ma nihwəti na geꞌi geꞌi, tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dza Yesəw ka nəw lə gəzə kwəma ci va, a kə na: «Kar ndəə tsəꞌwə ghwəə dzəghwa gərkəwa ta dzəɓakən tasaw kən, ya ta mbələy ta pi həni na? A ghwəy sənay, tə pətsa ɗal tsa ka məndiy fə. ");
INSERT INTO bcw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ya nimaɓa shi mbəmbə niy, ta səvərishi dza ghəshiy dzəti ngwəla. Ya wa kwəma ghələhwə məndi gəzə nzəy, cəkeꞌ dza məndiy sənata zləŋ məlmə. ");
INSERT INTO bcw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Fə tə ghwəy ghən ta kwəma va, niy nza sləmə va ghwəy ta fa kwəma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zhini ma kə Yesəw ngəshi ɓa na: «Mənti tə ghwəy məhərli wəzə mbə fa kwəma fa ghwəy. Va sa nzanay, njasa dza ghwəy məni kwəmay, tsəgha dza Hyalaa məniŋwəy kwərakwə. Paꞌ ka mətsahata na ghwəy bəla. ");
INSERT INTO bcw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa nzanay, ma ntsa nza nihwəti shiy vəy, ta mətsahanavə nihwəti shiy dza məndi. Ma na ntsa kama shiy vəy, ta zhini dza məndiy tsaləhwə ya niy nza va jəw ni shiy və» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zhini ma kə Yesəw kaa tsahwəti fir diɓa na: «Yəmyəm na sləkə tsa sləkə Hyala mbəzli lə kwəma ntsaa səvəriy dzay dzəmti, mbaꞌa tsəŋwəti za ci. ");
INSERT INTO bcw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa tsaŋwamti na za ci na, ka hi, ka vəghwə, ka hi, ka vəghwə ghəci, mbaꞌa ha ci pəsəta ka kəli, kala nahwəti sləni məni na mbə. ");
INSERT INTO bcw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","War ə haa kəli kwətita ka məni dəghəslə, ka ɓə hwər, dza pas pasəta, mbaꞌa fəəti mətsə. ");
INSERT INTO bcw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dzəghwa sa ka ha nakəta ki na, ma ka nza ndə ha maɗiy dzəmbə sləni, ka ɓə mbetə ta kəsli ha ki. Sa məniy vəghwə kəsli nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zhini ma kə Yesəw ɓa na: «A shiy tiɓa gar yəməti sləkə tsa sləkə Hyala mbəzli ghwəmmə li shi. A shiy tiɓa gar ɓəli fir ghwəmmə li shiy dzəkən. ");
INSERT INTO bcw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lə cizlə gwəbiri dza naa yəməva. Ghəshi gwəramti na tə jəw mbə cizlə shiy gwaꞌa gwaꞌa. Tsəŋwətishi ma məndi mbaꞌa ghəshi pəsəshiy, ");
INSERT INTO bcw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ka naa dza mbaꞌa kəliy dikə, ka taŋəti fəhi tə hiɗi gwaꞌa diɓa. Sa ka na hati dividivi na, dikə dikə dikə, paꞌ ka lala ghyeghyer shi ꞌyegwer tə dividivi ci» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ava tsəgha gazanshi Yesəw kwəma ɓananshi na kaa mbəzli, war dzar kwa fir kwa fir ɗaŋ, geꞌi geꞌi lə kwal tsa dza ghəshiy mbay favə. ");
INSERT INTO bcw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nahwəti kwəma gəzanshi na tiɓa ngəshi, kala dzar kwa firiw. Dzəghwa sa ka ghəshiy nza kwətishi lə mbəzli ta səɗa ci ki na. Ka naa dza mbaꞌa gəzanakəvərishi kwəma gəzə na va kwa fir bazhə bazhə. ");
INSERT INTO bcw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma fəcava hetihwer na, dza Yesəw ka gəzə kwəma kaa mbəzli ta səɗa ci, a kə na: «A mbəzli ni, taŋəmmə ghwəmməə dzəvəri tsa pəriɓa pəriɓa həlbə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mbaꞌa ghəshi zlashi mbəzli ɗaŋ ni va tiɓa, ka dzashiy dzəghwa kwambəwal nza Yesəw va kwa. Ma nihwəti kwambəwalerəy niy nza tiɓa vəgha na, ka dzashi kwasəbə ki. ");
INSERT INTO bcw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma ghəshi mbə taŋəə dzəvəri na, mbaꞌa safə tsa dikə tsa kafəy ta viy. Ka baŋzlaꞌwə kwəfa va dalala, ka dzəghwa kwambəwal va yam, paꞌ ka ɗi təhay. ");
INSERT INTO bcw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma ghalaɓa na Yesəw məhəni ləyɓa ləy mətsəni kwambəwal tə hi ciŋ ciŋ ciŋ, mbaꞌa saa fə ghən ta ghən tsa ci. Dza mbəzli ta səɗa ci ki, fərghə ghəshi fərghakati. A kə ghəshi ngəci na: «A Metər, gwaꞌa ghəy! A nava təkə ma ghaa dzəkən shəka?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dza Yesəw pəlhəm satiy, naɓ naɓ naɓəti safə, ɗekəɗekə pə gha, kə kaa kwəfa va. Mbaꞌa safə garəti viy, mbaꞌa kwəfa dəkəta, ɗekəɗekə pi məniy. ");
INSERT INTO bcw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma kə Yesəw ngəshi ki na: «Tawa hazləniŋwəy ghwəy tsəghaa? Ka mbə ghwəy ɓanavə nefer ghwəy kaa Hyala sa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma na mbəzli ta səɗa ci na nashi ki na. Tərəŋw hazləni ghəratishi. A kə ghəshi kwa jipə shi na: «Kay, kwətiy gəla tsatsa ndə ki! Ya safə lə kwəfa na ka ɗanci fəti!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dza Yesəw ghəshi lə mbəzli ta səɗa ci ki ndəs ghəshi tsəhəshi pəriɓa tə həlbə kwəfa tə hiɗi ka Gerazeni. ");
INSERT INTO bcw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma sa tsəhəshi ghəshi, war sa səəməy Yesəw kwa kwambəwal tsəgha na, wəɗ tsahwəti ndə gazlaka tsahwəy dzar mbə kwəlihi tiɓa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ntsa vay, mbə kwəlihi niy nza nzəy tsa ci. Ndə tiɓa niy mbay zhiniy kəsəvə ta tsaghwa ya kwa dəŋw tsahiw. ");
INSERT INTO bcw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɗaŋ səɗa niy səəkəm tsaghwa kwa dəŋw tsahi, mbaꞌa niy ghwaghwanamti dəŋw tsahi tsa va kwa dividivi ci, mbaꞌa ɓalamti tsa kwa shiɗshiɗ ci gwaꞌa. Mbaꞌa taŋanati bərci kaa mbəzli gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","War kwa kwəlihi lə dzar mbə dəlegwigwi gwaꞌa tsəgha tsa ci pətsaa niy nzəy na ti, havəghwə lə həvir gwaꞌa. Ka ngwəmə lala, ka nzanzarə vəgha ci gwaꞌa gwaꞌa lə hərezli kwacakasla. ");
INSERT INTO bcw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","War sa nay na Yesəw ghəci kərakəy ki na, bəvbəpə ghavə bali, səəkə tsəfəkwə tsəfəkwəy kwa kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ka ngwəmə lala ghəci zlaŋzlaŋ, a kə na: «A Yesəw, Zəghwə Hyala ta ghwəmə, ta njaa ɗi gha lə ya? Ə cəꞌwəŋee, ka pəraꞌwəŋa dəvə lə slən tsa Hyala, ka sara ngəraꞌwə gha ma» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kwəma gəzə na va tsəghay, sa nzana mbaꞌa Yesəw naɓəti gazlaka va: «Səvəriŋa mbə ghən tsa ntsa, gha gha gazlaka na!» kə niy ni kaa ngəta. ");
INSERT INTO bcw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dzəghwa ma kə Yesəw kaa ngəci ki na: «A slən tsa ghaa?» kə. Ma kə ntsa va na: «Mbəzli ɗaŋ, na slən tsee. Sa nzanay, ɗaŋ nza ghəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dzəghwa ghəshi ka cəꞌwə Yesəw, əntaa dzaa tahashiy dzəti nihwəti hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tə pətsa va ki na, mbaꞌa garəwa ngəreder tərəŋw niy nza tiɓa dzar mbə kəlaŋ mbə pala shi zəmə shi. ");
INSERT INTO bcw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ꞌWakəvə hyeler va tapə mbə cəꞌwə Yesəw, a kə ghəshi na: «Ndaŋəy kwal a ghəy dzəmbəŋəy mbə ghən ngəreder va» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dza Yesəw mbaꞌa zlatanavəshi kwal. Dza ghəshi mbaꞌa ghəshi səvərishi gwanashi mbə ghən zal tsa va. Shəɓətə, ghəshi shəɓətambəvashi mbə ghən ngəreder va. Dza ngəreder va gəgəgəgə ghəshi kafəshi mbə kəlaŋ tsa va, səəkə naꞌi shəkatəvashiy dzəti kwəfa, bətə ghəshi zashi kwaɓa. Ngəreder gar bələkwə bələkwə bakə mətsəkə ɗaŋ tsa shi. ");
INSERT INTO bcw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dzəghwa kwərec mbəzliy makə ngəreder va hwəshiy dzəmbə məlmə, lə dzar mbə giwahi vəgha məlmə. Mbaꞌa ghəshi dzaa gəzanshi tsava bar kaa mbəzli. Dzəghwa mbəzli ɗaŋ tərəŋw ki, mbaꞌa ghəshi ɓasəkəvashi ta nashi niva gəla shiy mənishi va. ");
INSERT INTO bcw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma səəkə mbəzli va, ndəs tsa shi vəgha Yesəw na, mbaꞌa ghəshi kəsay ntsaa niy nza hyeler va ɗaŋ mbə ghən ci mənzəy tiɓa vəgha Yesəw. Mbaꞌa pakən kwəbaŋ kən ghən ci, lə məhərli ci wəzə. Ma sa nay ghəshi tsəgha na, ka ghəranshi hazləni. ");
INSERT INTO bcw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dza niy nata kwəma va va mbəzli lə mətsə shi, mbaꞌa ghəshi slanakəshi kwəmaa mənta lə ndə gazlaka tsa va, mbaꞌa ngəreder va. ");
INSERT INTO bcw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dza mbəzli mbə məlmə va ka cəꞌwə va Yesəw, a ghəci ɓarvay dzay tə hiɗi shi. ");
INSERT INTO bcw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma sa dzay Yesəw dzəghwa kwambəwal ta maɗiy dzay na, tapə ntsaa niy ghəranci gazlaka va mbə cəꞌwə kwal va Yesəw, a ghəci nəwhwə ta dzashi li. ");
INSERT INTO bcw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kala zləɓati Yesəw, ma kə kaa ngəci na: «Awə, mbalaa jighi a gha dzaa gəzanshi kaa mbəzli ghaa dzəkən kwəma məntəŋa Ndə sləkəpə na, lə zhəhwər tsa məntəŋa na gwaꞌa!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maɗi ntsa va maɗiy tsəgha naci ki, ka təwrə dzar tə hiɗi nə məndi «Hiɗi Məlməhi Məŋ» kə məndi. Tapə ghəci mbə gəzə kwəma mananati Yesəw va kaa mbəzli. Ya wa ntsaa favə nava hwəlfə kwəma ki na, war ka mananci maɗaŋa ghənzə. ");
INSERT INTO bcw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dza Yesəw ki, mbaꞌa zhəghəkəvay zhəkə pəri tsa va həlbə kwa kwambəwal zhəvəri tsahwəti. Ma sa tsəhəy na na, dza mbəzli ɗaŋ tərəŋw mbaꞌa ghəshi ɓasəshi vəgha tiɓa, tə miy kwəfa. ");
INSERT INTO bcw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dzəghwa tsahwəti ndə kwətiŋ ta mbəzli dikə dikə ni mbə *ciki ɓasə va tsa ka Zhəwifə, Zhayrəsə, kə məndi slən tsa ci, ndəs səəkəy tiɓa kwərakwə. Ma sa nay na Yesəw na, dza na tsəfəkwə kwa səɗa Yesəw, ");
INSERT INTO bcw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ka pəraꞌwanci dividivi, ka cəꞌwə, a kə na: «Zhee nza na gwərapəta, ka ɗi mətita ghənzə. Ndi fanakən dividivi, a ghənzə mbəlita, əntaa mətita» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","«Tsəgha na» kə Yesəw, mbaꞌa maɗiy kwasəbə. Takwəs mbəzli ɗaŋ maɗishi kwasəbə ki, war ə ghəshiy dzədzərɗi Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ghalaɓa na, mbaꞌa nahwəti mali niy nza tə pətsa va, gwərapəta ghənzə gar piya nzə məŋ lə bakə, war mbə səkwa miymiy kwa hwər nzə. ");
INSERT INTO bcw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tərəŋw ghənzə sahwə ngəraꞌwə mbə dzadzaa dzəti shibiti. Pəŋw ghənzə laɗamti gəna ta dəvə nzə, shaŋ ghənzə ta kwəmavə mbəlita. War mətsəhə na mətsəhə zəlghwə naci. ");
INSERT INTO bcw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ma sa favə na məndiy gəzə kwəma Yesəw na, mbaꞌa təkəti mbə ghən tsa nzə: «War mərshi mee dapay tə kwəbaŋ tsa kən ghən ciy, war gwaꞌa, ta mbəlira dzee» kə. Səəkə na mbaꞌa dzəmbəta mbə mbəzliy ɓasəshi va. Dza na kət kətəghəvataa dzəvəgha Yesəw zhəkə ləy hwəm ci, dapə dapay kwəbaŋ tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","War sa dapay na tsəgha ki na, nzaꞌjəw hatsə miymiyəy səkwa va kwa hwər nzə slashi lə səkwa. Dza na mbaꞌa favə mbə vəgha nzə: «Ma nana kiy, gwaꞌa nee mbəlira!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ghala pətsa va kwərakwə ki na, mbaꞌa Yesəw sənay a bərci səvərishi mbə vəghee, kə. ꞌWakəvə na, tərəɗ zhəghətəvay zhəy ləy hwəm ci, tə jipəjipə mbəzli kwasəbə va. Dza na ka ɗəw və shi: «A ntsaa dapay kwəbaŋ tsee ya mbəzli ni?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma kə mbəzli ta səɗa ci kaa zləɓanci na: «Əy, njaa ghaa ni: “Wa ntsaa daparaa?” pə gha, kala nashi mbəzli ghaa dzərɗiŋa ya dza kwamaɓa kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma na Yesəw naci ki na, war ə ghəciy pəla ntsaa dapay va lə mətsə. ");
INSERT INTO bcw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dza mali va ki mbaꞌa maɗita, kala gwərgwərə va hazləni. Sa sənata na kwəmaa mənta li, səəkə na tsəfəkwə tsəfəkwəta kwa səɗa Yesəw. Dza na mbaꞌa gəzanakəvəri kwəmaa mənta li gwanata, kala mbələy ma ya kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma kə Yesəw ngəta na: «A zhee, a gha mbəliŋa tə sa ndara gha nəfə tsa gha. Mbəli mbəli pə gha va kwəma ngəraꞌwə tsaa nza kən gha. Mbala lə zərkə mbə nəfə tsa gha» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","War Yesəw mbə gəzə kwəma va kaa mali va tsəgha na, ndəs nihwəti mbəzli səəkəshi səəkə kəghi tsa Zhayrəsə, ntsa dikə tsa va. Ma kə ghəshi kaa Zhayrəsə na: «Ka maw ghaa tasə ghən tsa gha lə har Metər səəkə gəm ma, a zha gha va mətita» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma na Yesəw naci ki na, kala shashanci kwəma gəzə ghəshi va. Ma kə kaa Zhayrəsə na: «A Zhayrəsə, ka dza her gha ma, ɓanavə nəfə tsa gha kaa Hyala gwaꞌa tsəgha!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dza Yesəw kaf kafəy, mbaꞌa harvə Piyer ghəshi lə Zhakə mbaꞌa Zhaŋ, zəmbəghəy Zhakə, kwasəbə ci gwaꞌa tsəgha. Kala ɗi ghəci nihwəti mbəzliy nəw. ");
INSERT INTO bcw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma sa tsəhəy na vəgha ghi tsa Zhayrəsə na, mbaꞌa kəsashi mbəzli gədi gədi gədi ka wahə, ka həhərsli wahə nihwəti tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dza Yesəw mbaꞌa dzakəy dzakə ghi tsa va. Tapə ghəci ta ɗəw kwəma va mbəzli tiɓa: «A mbəzli ni, tawa wahə ghwəy gədi gədi shəka? Wa mətita zha naw, hiy ɓəhwə na gwaꞌa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma sa favə mbəzli kwəma gəzəkə na va tsəgha na, njasa pəꞌwə na kwəma ka gazlaka ghəshiy nighə. ꞌWakəvə Yesəw mbaꞌa tihəkəvərishi gwanashiy dzəti ngwəla. Tərə ghəshi kəyɓa lə mbəzliy yakə zha va mbaꞌa mbəzli ta səɗa ci va mahkan ni niy nəwvə gwaꞌa tsəgha. Dza ghəshi irətsə ghəshi dzəmbəshi mbə ciki tsa nza zha va va tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dza na, tasl kəsəvə zha va tə dəvə nzə, a kə ngəta na: «Talita kwəma!» kə. Ma ɗi kwəma gəzəkə na va gəzəy «A zha na, satiŋa, yən gəzaŋa na!» ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nzaꞌjəw pəlhəm, zha va satita tsəgha, ka dza ghənzə. Zha vay, məŋ lə bakə niy nza piya nzə. Mbaꞌa gəla nava kwəma mananatishi maɗaŋa kaa mbəzli tiɓa tərəŋw ki. ");
INSERT INTO bcw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dzəghwa Yesəw mbaꞌa damətishi lə gəzə kwəma tərəŋw, vantaa ghəshi dzaa gəzə kwəma va kaa tsahwəti ndə pəmta pəmta. Zhini ma kə ngəshi na: «Divam mbalam ɓantam shi zəmə kaa zha na, a ghənzə zəməshi!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dza Yesəw mbaꞌa zhəghəkəvay tə tsava pi ki, səəkəə dzəmbə məlmə Nazaretə, na ci məlmə kəli na mbə. Mbaꞌa mbəzli ta səɗa ci kwasəbə. ");
INSERT INTO bcw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dzəghwa *vici dəkəva mbaꞌa səəkəta. Dza Yesəw ka ɓananshi shiy kaa mbəzli mbə *ciki ɓasəva tsa ka Zhəwifə. Ma sa favə mbəzliy ɓasəshi va ɗaŋ ni tiɓa shi ɓananshi na va na, hahashi ghəshi hashishi va gəla nava kwəma. Tapə ghəshi mbə gəgəzə kwəma kwa jipə shiy dzəkən, a kə ghəshi na: «A mbəzli ni, kwəma səəkə na ci na kwəma gəzəpə ntsa na tay? A ntsaa ɓanavə məhərli tsətsə ta ɓəni shi nia? Wa ntsaa ɓanavə bərci ta məni gəla kwəma maɗaŋa maɗaŋa na na tsətsə na naci baya? ");
INSERT INTO bcw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ghəci ndə fəɗi shəghwə tsa va, zəghwə Marəy va, lə ngwarməhiy tiɓa, ndərazhiy zhər, kar Zhakə lə Zhezhesə, lə Zhəwdə, mbaꞌa Shimaŋw sa? Ya ngwarməhiyəy miꞌi nzə na, tikə ghəshi mbə ghwəmmə sana nanzə sa?» kə ghəshi. ꞌWakəvə gəla təkə kwəma tsəgha na va, mbaꞌa makətishi ta ɓə nefer shi kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma kə Yesəw ngəshi na: «A kataŋəy, a məndiy fə bamaa dzəti *ndə gəzə kwəma Hyala ya paꞌ kwəmaɓa. Ma mbə məlmə yakə məndi lə mbə ni ci mbəzli, lə kəghi tsa yakə məndiy, ka fə bama məndiy dzətiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dzəghwa kala mbə Yesəw zhiniy mənti nahwəti kwəma maɗaŋa maɗaŋa na tiɓa. War kəray dividivi shi fanakən na kaa nihwəti mbəzli gwərapə gwərapəshi ni, mbaꞌa mbəzli va mbəlishi. ");
INSERT INTO bcw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","War hash Yesəw hashiy va kwəma mbəzli va, sa ɗi ma ghəshi ɓanci nefer shi. Ləy hwəm kwəma va ki na, mbaꞌa Yesəw dza dzamti dza dzar mbə məlməhi tə hiɗi va. Mbaꞌa ɓananavə kwəma ci kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dza na kaa mbəzli ta səɗa ci va məŋ lə bakə ni mbaꞌa ɓasətishi. Dza na mbaꞌa ɓanavəshi bərci ta tihə hyeler səvəri mbə ghən mbəzli. Mbaꞌa ghwənashi bakə bakə bakə kwa zəərə shi, ta dza ghəshiy gəzə kwəma ci kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dza ma kə ngəshi ki na: «Mbalam, ghwəy kafəy, əntaa ghwəy dzaa ɓə ya waɓa ta dəvə ghwəy ma. Ya shi zəmə nzə, ya mbəl ta ɓə shiy, ya gəna kwa zlipa ghwəy, əntaa ghwəy ɓə ma. War gəta ka ghwəy ɓəvə ta dəvə ghwəy gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pambə tə ghwəy kwekweher mbə səɗa ghwəy, diɓay əntaa ghwəy dzaa sərakən kwəbeŋer bakə bakə kən ghən ghwəy ghwəy dza ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Zhini ma kə ngəshi ɓa na: «Ma sa ka ghwəy tsəhəŋwəy mbə məlmə ya namaɓay, mbaꞌa kə ndə kaꞌwətəŋwəy mbə na, kəy ntsa va pə ghwəy taa nzəyŋwəy, paꞌ fəca dza ghwəy ɓarva mbə məlmə va. ");
INSERT INTO bcw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mbaꞌa pə ghwəy tsəhəŋwəy mbə məlmə, kala zləɓa kaꞌwəŋwəy məndi, kala fa ma kwəma gəzə ghwəy məndiy, ɓarvaŋwəy tə ghwəy mbə nava məlmə, mbaꞌa ghwəy batamti kwərbi tə shiɗshiɗ ghwəy. War tsəgha pə ghwəy dzaa məni ta mbə ghəshiy sənay, a ghəshi mənti *kwəma jikir na, kə ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma sa gəzanakəshi Yesəw tsəgha ki na, mbaꞌa mbəzli ta səɗa ci va maɗishi, ta dzaa gəzanshi kwəma Hyala kaa mbəzli nza ghəshi tsa titihwə tsa shi kaa Hyala, ka zhəghanti nzəy tsa shi ki. ");
INSERT INTO bcw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dza mbaꞌa ghəshi tahamti hyeler səvəri mbə ghən mbəzli ɗaŋ. Mbaꞌa ghəshi vavaranati in kaa nihwəti mbəzli gwərapə gwərapəshi ni ɗaŋ diɓa, mbaꞌa mbəzli va mbəlishi. ");
INSERT INTO bcw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Dzəghwa gwaꞌa gwaꞌa slən tsa Yesəw dzay ya paꞌ kwəmaɓa ki, ka gəzə məndi: «Waa Zhaŋ tsaa niy mənipə batem va na sava zhəkəməy na kwa kwəli! Va tsəgha nza bərci və ta məni shi maɗaŋa maɗaŋa ni va tsəgha» kə məndi. Ma kə nihwəti na: «*Eli ndə gəzə kwəma Hyala na» kə ghəshi. Ma kə nihwəti ɓa na: «*Ndə gəzə kwəma Hyala na, nja ka gəzə kwəma Hyalaa niy nza va tiɓa mbəradzə» kə ghəshi. Dzəghwa mbaꞌa mazə *Erədə favə ghəpə tsa kwəma Yesəw va. ");
INSERT INTO bcw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma sa favə na tsəgha ki na: «Waa Zhaŋ tsaa mənipə batem va niy slantee ghən ti na sava zhəkəməy na kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sa nzanay, ə niy ɓələhwə na mali zədəy Fəlipə ghəci ghəci mazə Erədə tsa va. Erədiyadə, kə məndi kaa slən tsa mali va. Ma kə Zhaŋ niy ni kaa ngəci na: «Kwal va gha kwa kwəma Hyala ta ɓəli mali zədəŋa va ɓələhwə ghaw» kə. Sa niy gəzəkə na tsəgha ki na, dza Erədə mbaꞌa niy kəsəvəə tsaghwa kwa dəŋw, mbaꞌa niy faghwa kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mbaꞌa nəfə tsa Erədiyadə niy satiy dzəkən Zhaŋ tərəŋw va kwəma va. Mbə ɗi pəəsli ghənzə niy nza na, niy mbay na va mazə Erədəw. ");
INSERT INTO bcw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sa nzanay, mbə ghəranci niy nza hazləni kaa Erədə va kwəma Zhaŋ, sa nzana mbaꞌa niy sənay ndə gəzə kwəma kataŋ naa Zhaŋ, ɗewɗew nəfə tsa ci kwa kwəma Hyala, kə. Dza na ka ndəghwə Zhaŋ niy nza wəzə wəzə, war fa kwəma ka Zhaŋ gəzə ghəci niy maw. Ma sa ka naa favə ki na, ka səəva məhərli ci. ");
INSERT INTO bcw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dzəghwa vəghwə tsa wəzə wəzə tsa va Erədiyadə nanzə ki, ndəs səəkəy. Sa niy mənta viciy niy yakə məndi mazə Erədə ti na, dza na mbaꞌa niy tati shi zəmə tərəŋw, ta makwaghwa mbə zəzə vici ya məndi va ti. Mbaꞌa niy haharashi mbəzli dikə dikə ni tə hiɗi ka Galile, lə mbəzli dikə dikə ni mbə ka sawji shi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dzəghwa zha Erədiyadə irətsə niy dzəmbəta mbə pətsaa niy ɓasəshi kar mazə Erədə va lə mbəzliy niy harkə na va ta zəmə shiy. Mbaꞌa niy tsəti tsə ka təɓanshi kaa kar Erədə lə mbəzliy niy nza va tiɓa gwanashi. Ma kə mazə niy ni ki na: «A zhee, ya wa shi ɗi gha yən ndaŋay, ɗəwshi, ta ndaŋashi dzee!» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dzəghwa mazə hwaꞌ hwaꞌ niy zəməkə fəla: «Yən kala dzaa ndaŋa shi dza ghaa ɗəw vəya, ya war təhəvəri hiɗi sləkə gha ni bakə mbə, a gha ndara nahwəti bəla dza ghaa ni!» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dza zha va tsəgha del niy səvərita, ndəs niy dzaa kəsata mbəghəta. A kə niy ni ngəta na: «A mə, a kə mazə ngəray: “Ɗəw ya wa shi ɗi gha vəya” kə. A shi kee ɗəw vəa?» kə niy ni. Ma kə mbəghəta va niy ni ngəta na: «Mbala, ma pə gha kaa ngəciy: “Slavəra ghən tsa Zhaŋ ndə mənipə batem!” pə gha ngəci» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nzaꞌjəw zha va niy zhəghəkəvata lə diva, ta ɗəw va mazə ki, a kə niy ni kaa mazə na: «Ə ɗee gha slaghwara ghən tsa Zhaŋ ndə mənipə batem kwa tasaw!» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","War sa niy gəzəkə zha va kwəma va tsəgha na, kwəshay vəgha mazə niy mənta va nava kwəma, sa niy ɗi ma na tsəgha, niy mbay naa zhiniy bashamti ghwəla, sa nzana, mbaꞌa niy mbəlitiy zəmanakə fəla tiɓa kwa kwəma mbəzliy ɓasəshi va kiw. ");
INSERT INTO bcw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dzəghwa nzaꞌjəw niy gəzanci kaa tsahwəti ndə sawji kwətiŋ mbə ka sawjiy ndəghwə, a ghəci dzaa slakəvə ghən tsa Zhaŋ ndə mənipə batem taŋtaŋ. Dza ndə sawji tsa va, mbaꞌa niy dzay dzəghwa fərshina, mbaꞌa niy dzaa slavə ghən tsa Zhaŋ faghwa kwa tasaw ki, ");
INSERT INTO bcw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mbaꞌa niy dzaa ɓanavə kaa zha va, mbaꞌa zha va niy ɓəvəə ɓanavə kaa mbəghəta kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma sa niy favə mbəzli ta səɗa Zhaŋ, a məndi paslamti Zhaŋ, kə məndi na, mbaꞌa ghəshi niy səəkəə ɓəvə mbəri tsa Zhaŋ. Mbaꞌa ghəshi dzaa laghwa kwa kwəli. Tsəgha niy mətiy Zhaŋ ki. ");
INSERT INTO bcw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dzəghwa *ka kwal Yesəw va niy ghwənashi Yesəw, mbaꞌa ghəshi zhəghəkəvashi mbə dza shi va ki. Səəkə ghəshi ɓasə ghəshi ɓasəshi, ka ndanci kwəma mənəhwə ghəshi gwaꞌa, lə shi ɓananavə ghəshi kaa mbəzli gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma ghala pətsa ɓasəshi mbəzli va tə pətsa nza Yesəw va ki na, ka dzashi niy dzashi, ka zhəkə nihwəti, war tsəgha. Shaŋ kar Yesəw lə mbəzli ta səɗa ci ta kwəmavə ya kwal tsaa zəhwə shiy nzə. Va tsəgha ki, ma kə Yesəw kaa mbəzli ta səɗa ci na: «A mbəzli ni, dzammə ghwəmmə ta pəlavə pətsa kama ndə ti di, a ghwəmmə dzaa dəkayvammə ti ya jəw nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dzəghwa mbaꞌa ghəshi dzashiy dzəghwa kwambəwal ta dzashiy dzəmbə gamba ta nzəyshi kwətishi vəgha bəla. ");
INSERT INTO bcw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma ghəshi mbə dzashi ki na, mbalaa na mbəzli ɗaŋ nighəvəshi, mbaꞌa məndi sənashi, kar Yesəw lə mbəzli ta səɗa ci na shi va, kə məndi. Mbaꞌa mbəzli maɗishi ya mbə namaɓa məlmə, mbaꞌa ghəshi kəsləghə bali lə səɗaa tsəhəshi tə pətsa va pərɓa ghəshi kaa kar Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma sa tsəhəy Yesəw tə pətsa va ki na, mbaꞌa səəməy kwa kwambəwal, sa nə na tsaꞌ kə na, mbəzli ɓasə ɓasə tə pətsa va ɗaŋ. Tapə hwər tsa ci ta zhanci ta mbəzli va ki. Sa nashi na mbəzli va nja teŋkesli kama ntsaa ndəghwəshi tiɓa. Dza na mbaꞌa ɓananavəshi shiy tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma sa məniy tihwer, ma kə mbəzli ta səɗa ci kaa Yesəw na: «A Metər, avanay sənzənvay, a vici dzata, dzəghwa tə gambay pətsa. ");
INSERT INTO bcw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wəzəɓa ɓanavə gha kwal kaa mbəzli ni, a ghəshi dzashi ta papa shi zəmə shi dzar mbə məlməhi lə mbə nihwəti giwahi ndəkwə ndəkwə ni» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma kə Yesəw kaa ngəshi na: «Ɓanshim shi zəmə dəꞌwə ghən tsa ghwəy a ghəshi zəməshi» kə. Ma kə ghəshi ngəci na: «Zləɓati gha, a ghəy dzaa ɓəvə mbəl bələkwə bakə ta dza ta pəlanshi shi zəmə na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma kə Yesəw ngəshi na: «Peŋ hwəm na sa va ghwəy tiɓa sana nanzəy? Mbalam nighətim di» kə. Dza ghəshi mbaꞌa ghəshi dzaa nighəti. Ma kə ghəshi ngəci na: «Wa cifəy na peŋ tikə, mbaꞌa kərpi bakə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dza na mbaꞌa gəzanshi kaa mbəzli ta səɗa ci va, a ghəshi gəzanshi kaa mbəzli tiɓa va gwanashi, a ghəshi tihəvərivashiy nzəyshi dzar tə gwəzən tsa neɓekə tsa. ");
INSERT INTO bcw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dza mbəzli va mbaꞌa ghəshi nzəyshi ki, bələkwə bələkwə nihwəti, ma nihwəti na cifə mətsəkə cifə mətsəkə. ");
INSERT INTO bcw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma sa nzəyshi mbəzli ki na, dza Yesəw həŋ ɓəvə peŋ tsa cifə tsa va mbaꞌa kərpi bakə ni va ta dəvə ci, mbaꞌa kafata kwəma ciy dzəta ghwəmə, ka mananta ꞌwəsa kaa Hyala ta shi zəmə va. Ma sa mananati na ꞌwəsa kaa Hyala na, dza na mbaꞌa ngangavəri peŋ tsa va, mbaꞌa ɓanavə kaa mbəzli ta səɗa ci, a ghəshi tahanshi kaa mbəzli ɗaŋ ni va. Zhini tsəgha ghəci tahanavəshi kərpi bakə ni va gwanashi diɓa. ");
INSERT INTO bcw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mbaꞌa mbəzli va gwanashi zəməhwə shi va, bəhə bəhə ghəshi, mbaꞌa mbəvəli tərə. ");
INSERT INTO bcw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dza məndi ɓasə ɓasəti naa tərmbə va mbəvəli peŋ tsa va lə kəripə va, paf paf ghwani məŋ lə bakə. ");
INSERT INTO bcw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma ɗaŋ tsa mbəzliy zəhwə shi zəmə va va na, zhər bələkwə bələkwə cifə mətsəkə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","War ghwəla ləy hwəm kwəma va ki, ma kə Yesəw kaa *mbəzli ta səɗa ci na: «Ləghwam dzəghwa kwambəwal, a ghwəy ꞌwati kwal dzəvəriy dzəti həlbə pəriɓa pəri məlmə Betəsayda, kala kərnee səkwəti mbəzli ghəshiy dzashi» kə. Mbaꞌa mbəzli ta səɗa ci va dzəghwashi ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ləy hwəm sa təhəvərivay na lə mbəzli ki na, mbaꞌa kafəy dzay dzəmə kəlaŋ ta cəꞌwə. ");
INSERT INTO bcw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma hetihwer sa pəkwəta vici na na, ava mbəzli ta səɗa ci kətivə dza ka tsəhəshi tə jipəjipə kwəfa, mbaꞌay ghəci pərikəy tə həlbə kwətiy naci ki. ");
INSERT INTO bcw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dzəghwa mbaꞌa nashi mbəzli ta səɗa ci war mbə təməva lə kaɓə kwambəwal ngahə ngahə ngahə, sa nzana səəkəə dzəmbə kwəma shi safə niy viy. Ma tə kwa baka wa ngələkə na, mbaꞌa Yesəw dzətiy tə ghən yam, ka dza dzar ti shi lə səɗa ci, ta kəsashi mbəzli ta səɗa ci. Ma sa tsəhəy na ndəkwə vəgha shi na, njasa ɗi na taŋəshi ghəci mənti. ");
INSERT INTO bcw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma sa nay mbəzli ta səɗa ci va ghəciy dza dzar tə ghən yam lə səɗa na, ndəɓa *hil, kə ghən tsa shi. Ka ngwəmə lala ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sa nzana, ghəshi njasa nza ghəshi va gwanashi na, mbaꞌa ghəshi nay ghəci mbə dza dzəy tə ghən yam va, mbaꞌa her shi dzashi. War ghwəla tsəgha ki na, mbaꞌa Yesəw ghati gəzanshi kwəma, a kə na: «Waa yən na, ə kə her ghwəy dzəghwashi, ka hazləni ghwəy ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dza na kwərəhw dzəghway kwa kwambəwal va kwasəbə shi ki, gar safə garəti viy kwərakwə. Dzəghwa tərəŋw məhərli *mbəzli ta səɗa Yesəw səəta va nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sa nzana, kalaa niy favə ghən tsa kwəma maɗaŋa maɗaŋa na va niy mənti Yesəw lə peŋ ghəshi. War caslakəy nəfə tsa shi niy məniy. ");
INSERT INTO bcw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ma sa taŋamti ghəshi kwəfa va na, mbaꞌa ghəshi tsəhəshi tə hiɗi ka Zhenezaretə ki. Dza ghəshi kaa kwambəwal shi mbaꞌa ghəshi pəhəy vəgha həlbə tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sa pəhəy ghəshi na, mbaꞌa ghəshi səəməshi kwa ki, nzaꞌjəw məndi nighəvə Yesəw mbaꞌam sənay. ");
INSERT INTO bcw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dza məndi ki ka kəkəsli bali ta dzaa gəzə kaa mbəzli tə hiɗi va gwanashi. Ya kwəma favə məndi a səəkəy, kə məndi na, war ə məndiy ɓanci ka zəlghwə səəkə tə pi həni tsa shi. ");
INSERT INTO bcw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ya kwamaɓa dza na, ya dzar mbə məlmə dikə na, ya dzar mbə giwa, ya dzar mbə ni bəla bəla ni ghyeghyer na, war ə məndiy ɓanci ka zəlghwəə dzəti ləwma. Ka cəꞌwə, a ghəci ɓanavəshi kwal tsaa dapəvə ya kwataka mətsəni kwəbaŋ tsa kən ghən ci. Ya tsamaɓa ndə zəlghwə tsaa ndəŋway na, mbaꞌa mbəliy. ");
INSERT INTO bcw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dzəghwa *ka Farisahi ghəshi lə nihwəti mbəzli mbə *ka ɓənipə kwəma pəhəti Hyala, shiy səəkəshi mbə məlmə Zherəwzalem, mbaꞌa ghəshi ɓasəkəvashiy dzəvəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nighə ghəshi na, nihwəti mbəzli mbə *mbəzli ta səɗa Yesəw mbə zəmə shi zəmə lə rəɗa tə dividivi shi. Ɗi naa gəzəy, yaɓanti dividivi shi ghəshi ta zəmə shiy njasa ka ka Zhəwifə məni mbə kwəma jiji shiw. ");
INSERT INTO bcw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na na ka Farisahi lə ka Zhəwifəy, tərəŋw ka ghəshiy məni məhərli ta məni kwəma jijihishi. Ka ghəshiy gha zəmə shi zəməy, ghəshi yaɓanti dividivi shi wəzə wəzə. ");
INSERT INTO bcw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sa ka ghəshiy səəkəshi mbə ləwmay, ka zəmə shiy ghəshi kala pəshamtəvashi ghəshiw. Zhini ɗaŋ nihwəti shi gazanakəshi jijihishi ta mənishi ghəshi tsəgha. Ya dzəkən njasa ka ndə yaɓə shi sa ndə shiy kwa shi, lə yaɓə tsaghwa, lə shekiki vasəti məndi tə mbəzə, ya pətsa həni ndə ti gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sa zəmə mbəzli ta səɗa Yesəw va shiy kala yaɓanti dividivi shi kiy, va tsəgha ɗəw ka Farisahi, lə *ka ɓənipə kwəma pəhəti Hyala va Yesəw: «Tawa ɗi ma mbəzli ta səɗa gha ni fəti ta kwəma ɓanavəka jijihi, zəmə ghəshi shi zəmə lə rəɗa tə dividivi shia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma kə Yesəw ngəshi na: «Mbalaa kataŋ na kwəmaa niy gəzəkə *Ezay ndə gəzə kwəma Hyala vaa dzəkən ghwəy! Ghwəy ghwəy ka dakə mbəzli lə kwəma pərikə tə ngwəla ni. A kə niy niy: “A kə Hyalay: Ma mbəzli niy, war kwataka lə miy gəzə ghəshi haꞌwə tsa haꞌwə ghəshi tə ya gwaꞌa tsəgha. Ma mbə nefer shi na, kərakə kərakə ghəshi lə ya. ");
INSERT INTO bcw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gəmta na tsəfəkwə tsəfəkwə ghəshi kwa kwəmee. Sa nzanay, war kwəma jiji shi na shi ɓananshi ghəshi kaa mbəzli, njasa nzanaa kwəmee ghəshi zhəghəti, kə Hyala” kə Ezay niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dza ghwəy na, mbaꞌa ghwəy zlata nəw kwəma pəhəti Hyala, ka dzaŋwəy ta nəw war kwəma jiji ke ngəri» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zhini ma kə ɓa na: «Kay, tsəghaa nava kataŋ, a ghwəy zlata *kwəma pəhəti Hyala ta nəw, mbaꞌa ghwəy dzaŋwəy ta ɓənipə na ghwəy va kwəma jijihiŋwəy. ");
INSERT INTO bcw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A *Məyizə niy gəzəkə nahwəti kwəma, a kə niy niy: “Ə pə ghaa haꞌwə tə kar dəŋa lə məŋa” kə niy ni. Zhini ma kə ɓa na: “Ya wa ntsaa tsəərəti dəy, ya mbəghəyəy, mbaꞌa məndi paslamti tsava ndə” kə. ");
INSERT INTO bcw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma pə ghwəy na ghwəy ki mbə kwəma ɓənipə ghwəy na, mbaꞌa kə shiy va ndə ta kəəti kar dəy lə mbəghəyəy, a ndəə mbay gəzə: “A di, a mə, ma shiy niy nza vəya gar ɓəŋwəyshee ta kəətiŋwəyəy, kwərban na ghəshi” kə, (ma ɗi kwərban gəzəy, shi ɓanavə məndi kaa Hyala), ");
INSERT INTO bcw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","gwaꞌa, ka zhini tsava ndəə kəəti kar dəy lə mbəghəy ghwəla ma, pə ghwəy. War ə ghwəy makə mbəzliy tsəgha va kəəti mbəzli shi. ");
INSERT INTO bcw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsəgha pəəsliti ghwəy na Hyala va *kwəma pəhəti na, war ta mbəə nəw na ghwəy va kwəma jiji pəhəti ghwəy. Zhini lə nihwəti shi məməni ghwəy tiɓa ɗaŋ war tsəgha tsəgha diɓa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dzəghwa Yesəw mbaꞌa zhiniy harvə mbəzliy ɓasəshi va. Ma kə ngəshi na: «Fam kwəma ɗee na gəzə gwanaŋwəy, fə tə ghwəy ghən ti. ");
INSERT INTO bcw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ma na shi ɓəvə ndəə zəhwəshiy dzəghwa hwər ciy, ka yiɗamti ndə ghəshi kwa kwəma Hyalaw. Shiy səvəri mbə nəfə tsa ndə na shiy dzaa yaɗamti ndə kwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Fə tə ghwəy ghən ta kwəma va, niy nza sləmə va ghwəy ta fa kwəma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma sa təhəvərivay Yesəw lə mbəzliy niy ɓasəshi va na, mbaꞌa dzay dzəmbə ciki. Ma mbəɓa na, maɗ mbəzli ta səɗa ci maɗishi ta ɗəw bazhə tsa fir tsa ɓəlikə na va tsəgha tsa. ");
INSERT INTO bcw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma kə ngəshi na: «Wa ə favə ma ghwəy kwəma ɗi kwəma vaa gəzə lə ghwəyŋwəyshi kwərakwə ɓa na? Ə sənay ma ghwəy, shi ɓəvə ndəə zəməhwəshiy dzəghwa hwər tsa ci na ka yaɗamti ndə ghəshiw pə ghwəy shəkəna? ");
INSERT INTO bcw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sa nzanay, dzəmbə nəfə tsa ndə ka ghəshiy dzaw, dzəghwa hwər ka ghəshiy dza, ka ndə dza na mbaꞌa təhəkəghwashi» kə Yesəw. Ma ɗi Yesəw gəzə mbə kwəma ci va gəzəkə na tsəghay, ya war nimaɓa shi zəmə gwaꞌay, a məndiy mbay zəməshi, nə na. ");
INSERT INTO bcw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Zhini ma kə diɓa na: «Njasa gəzee vay, war kwəmaa səəkə mbə nəfə tsa ndə na saa dzaa mbay laɗamti ndə kwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa nzanay, səəkə mbə nəfə tsa ndə ka təkə *kwəma jikir naa səəkə, lə ghwərghwər, lə ghəli, lə bəkwə mbəzli, ");
INSERT INTO bcw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lə pəəsli miꞌi mbəzli, lə ɗi gəna, lə zliy, lə dakə mbəzli, lə məni kwəma rəɗa rəɗa na, lə səl va ndə, lə gəzə kwəma jikir naa dzəkən mbəzli, lə kəli ghən, mbaꞌa gəzə kwəma kama ghən ti. ");
INSERT INTO bcw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Niva shi jikir ni gwanashiy, səəkə mbə nəfə tsa ndə səəkə ghəshi. Ghəshi na shiy dzaa laɗamti ndə kwa kwəma Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dzəghwa Yesəw mbaꞌa maɗiy ɓarvay tə pətsa va, ka dzay dzəti hiɗi ndəkwə ndəkwə ni vəgha məlmə Tir tə hiɗi ka Shirəfiniki. Dza na mbaꞌa dzakəy dzakə tsahwəti ndə tiɓa, kala ɗi ma ghəci məndiy sənay, tiɓa na, kə məndi. Ya tsəgha nzə ki na, shaŋ ghəci ta mbay mbələy ghən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A nahwəti mali niy nza tiɓa gwərapəta zha nzə va zəlghwə gazlaka tərəŋw, mbaꞌa favə tiɓa na Yesəw, kə məndi. Ma sa favə na tsəgha na, nzaꞌjəw ghənzə maɗita, səəkə na tsəfəkwə tsəfəkwəta kwa kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dza na ka cəꞌwə Yesəw, a ghəci tahanamti gazlaka səvəri mbə ghən tsa zha nzə va. Mali vay, mali *ka Zhəwifə niy nza naw, zha mbəzli ka Shirəfiniki niy nza na. ");
INSERT INTO bcw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma kə Yesəw ngəta na: «A mali na, waa wəzə na ndə ɓəvə shi zəmə ndərazhi ka ndəghashi kaa kireketiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A kə mali va ki na: «Tsəgha na nava nanzə kataŋ Ndə sləkəpə. Ya tsəgha na nanzə kiy, ya kireketi na kar ghəshiy dzar ta tabəl, ka imə shiy shikə va ndərazhi» kə. ");
INSERT INTO bcw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma kə Yesəw ngəta ki na: «A mali, ya kwataka tə kwəma gha na zləɓakə ghay, gwaꞌa! Mbala, a gazlaka va səvərita mbə ghən zha gha va» kə. ");
INSERT INTO bcw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dzəghwa mali va mbaꞌa dzata. Ma tsəhə na kataŋ na, zha nzə va məhəni tə pi həni tsa nzə lə məhərli nzə wəzə, səvəri səvəri gazlaka mbə ghən nzə. ");
INSERT INTO bcw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dza Yesəw ki mbaꞌa ɓarvay tə hiɗi ka Tir ka dzar tə hiɗi ka Shidaŋw, ka dzar tə hiɗi har məndiy hiɗi Məlməhi Məŋ, ta zhəghəkəvay zhəməy kwəfa Galile. ");
INSERT INTO bcw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma sa tsəhəy na na, mbaꞌa məndi pəmanakə tsahwəti ndə tiɓa, mədəŋ ghəci, pəhəpəhə ghani ci, kala mbay ma gəzə kwəma. Dza məndi ka cəꞌwə a ghəci fanakən dəvə ci ta mbəlanti. ");
INSERT INTO bcw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dza Yesəw ki, pəm pəməkəvəri ntsa va səvəri mbə mbəzli. Mbaꞌa ghəshi garəshi tsarakə, bakəshi li. Dza na mbaꞌa ꞌyaghwa dividiviy dzəghwa sləmə ci, mbaꞌa təfati ndighwər tə dəvə ciy dapata ghani ci va li shi. ");
INSERT INTO bcw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dza na kaa kwəma ci, kafə kafataa dzəta ghwəmə, mbaꞌa piyaghwa piy lə bərci. A kə kaa ntsa va na: «Efata!» kə. Ɗi kwəma vaa gəzəy: «Ghwəniŋa!». ");
INSERT INTO bcw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dzəghwa nzaꞌjəw paŋ, slimim ci ghwənishi, mbaꞌa ghani ci va niy pəhəta pəlita, mbaꞌa ghəci ghati gəzə kwəma wəzə wəzə ki. ");
INSERT INTO bcw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dzəghwa Yesəw mbaꞌa gəzanshi kaa mbəzli tiɓa gwanashi, əntaa ghəshi gəəzə kwəma mənti na va. Ya war tsəgha gəzanshi na kaa mbəzli, əntaa ghəshi gəzə kwəma kən ki na, war ə mbəzliy mətsəhə gəzə kwəma ci tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma kə mbəzli ki na: «Kay, sləni wəzə na sa ci gwanata! Ya mədeŋesliy favə ma kwəmay, aa mbəlantishi, mbə favə kwəma ghəshi, mbəzli pəhəta ghani shi na, mbaꞌa pəlamti, ka gəzə kwəma ghəshi!» kə shi. Tərəŋw nava kwəma mananatishi maɗaŋa. ");
INSERT INTO bcw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Zhini mbəzli ɗaŋ tərəŋw mbaꞌa ghəshi ɓasəshi ghala pətsa va vəgha Yesəw diɓa. Kala shi zəmə və shi. Ma sa nay Yesəw kala shi zəmə və shi na, dza na daꞌ harashi *mbəzli ta səɗa ci. Ma kə ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mbəzli niy, dalalay zhəra hwər tsee ti shi. Sa nzanay, kwa mahkana vici shi na sana, war ghəshi tikə vəghee, kala shi zəmə tiɓa! ");
INSERT INTO bcw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mbaꞌa pən ni sana: “Mbalam jighi” pən ngəshi, kala nganavəshi shi zəmə pənəy, ta shikəshi dza ghəshi kwa kwal va ma. Sa nzanay, kərakə səəkə nihwəti mbəzli mbə shi sana» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma kə mbəzli ta səɗa ci ngəci na: «Əy, kwəma ka ndə palakə shi zəmə sana tikə mbə gamba na gar zəhwəshi mbəzli ni nə gha kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma kə Yesəw na: «Hwəm na peŋ va ghwəya?» kə. Ma kə ghəshi na: «Mbərfəŋəy na peŋ va ghəy» kə ghəshi. «Ndakam tikə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dza Yesəw mbaꞌa gəzanshi kaa mbəzliy ɓasəshi va, a ghəshi nzəyshi mənzəy. Ma sa nzəyshi ghəshi na, dza na həŋ ɓəvə peŋ tsa mbərfəŋ tsa va ta dəvə ci, mbaꞌa mananati ꞌwəsa kaa Hyala. Ma sa manamti na ꞌwəsa na, dza na ngaꞌ ngaꞌ nga ngavəri, mbaꞌa ɓanavə kaa mbəzli ta səɗa ci, a ghəshi tahanshi kaa mbəzli va. Dzəghwa mbəzli ta səɗa ci va mbaꞌa ghəshi tahanavəshi ki. ");
INSERT INTO bcw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zhini mbaꞌa kərpi və shi tiɓa jəw tsətsə diɓa. Dza Yesəw mbaꞌa zhiniy mənti ꞌwəsa ti shi kaa Hyala diɓa, mbaꞌa ɓanavəshi mbəzli ta səɗa ci, a ghəshi tahanshi kaa mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Dzəghwa mbəzli tə pətsa va va, zəmə zəmə ghəshi zəməhwə shi zəmə va ki, bəhə bəhə ghəshi. Mbəzli bələkwə bələkwə faɗə mətsəkə na ghəshi ɗaŋ tsa shi. Dzəghwa mbaꞌa məndi ɓasəti naa tərmbə mbəvəli gyaɗə gyaɗə ghwani mbərfəŋ. Ləy hwəm ki na, mbaꞌa Yesəw səkwamtəvay lə mbəzli va, mbaꞌa ɓanavəshi kwal a ghəshi dzashi ki. ");
INSERT INTO bcw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dza ghəshi nzaꞌjəw tsəgha, mbaꞌa ghəshi dzashi dzəghwa kwambəwal, ghəshi lə mbəzli ta səɗa ci, war ka dzashiy dzəti hiɗi Dalmanəta. ");
INSERT INTO bcw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dza nihwəti *ka Farisahi mbaꞌa ghəshi dzəmbəshi mbə kanci ghəpə kaa Yesəw, a kə ghəshi na: «Mənti shi maɗaŋa maɗaŋa ni tə pətsa va, ti dza ghəy sənay, səəkə va Hyala səəkə kwəma gha na kataŋ, pə ghəy» kə ghəshi, sa ɗi ghəshi ngali ta mbə ghəshiy kəsəti. ");
INSERT INTO bcw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dza Yesəw mbaꞌa piyaghwa piy tərəŋw. Ma kə ngəshi na: «A shiy ghəranshi ni kaa mbəzli mbə vəghwə tsa ndatsə, nzana war shi maɗaŋa maɗaŋa ni ghəshiy pala tay? Ə gəzəŋwəy ya, ta na navay, tsəgha na, na nee nee kiy, shi maɗaŋa maɗaŋa ni dzee məntəŋwəy tiɓaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dza na mbaꞌa zhay zhəghwa kwambəwal, mbərəkə zlashi tə pətsa va, mbaꞌa taŋəy dzay zhəvəri tsahwəti həlbə tsa həl tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dzəghwa *mbəzli ta səɗa Yesəw va ghəshiy maɗiy dzashi, mbaꞌa ghəshi zamti ghən ta mətsəhə peŋ, war kəray peŋ kwətiŋəy gwaꞌa tsəgha sa və shi kwa kwambəwal. ");
INSERT INTO bcw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma ghəshi mbə dza na, tapə Yesəw ta canshi nahwəti kwəma, a kə ngəshi na: «Favə ghwəy na, məni tə ghwəy məhərli, ka ndəghwə ghən tsa ghwəy va is tsa ka Farisahi lə is tsa Erədə!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sa gəzəkə na tsəgha na, dza mbəzli ta səɗa ci ka gəzə kwəma kwa jipə shi tsəgha ki, a kə ghəshi na: «Wa sa zay ghən tsa ghwəmmə va ta ɓə peŋ, va tsəgha gəzəmmə na kwəma va tsəgha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dza Yesəw mbaꞌa fəti ghən ta kwəma gəzə ghəshi va. Ma kə ngəshi na: «A mbəzli ni, ta waa nə ghwəy ni, sa ɓəvə ma ghwəmmə peŋ, ma gəzəmmə na kwəma va, pə ghwəya? Ə sənata ma ghwəy kwəma shəkəna? Ka təkə kwəma ghwəy mbə ghən ghwəy sa? War ghwəlay na ghən tsa ghwəy caslakə slakə paꞌ sana na? ");
INSERT INTO bcw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mbaꞌa mətsəhi kwa ghən ghwəy nanzə ki na, ka nay pi ghwəy li shiw? Lə slimim vəgha ghən ghwəy na, ka favə kwəma ghwəy li shiw? Ə zay ghən tsa ghwəy ");
INSERT INTO bcw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ta peŋ tsa cifə tsa va niy ngangavəree ta təhə kaa mbəzli bələkwə bələkwə cifə mətsəkə shəkəna? Gambal hwəm niy tahay ghwəy lə kwa tərmbə peŋa?» kə. Ma kə ghəshi na: «Məŋ lə bakə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A kə diɓa na: «Ya ghala pətsaa ndaŋwəyee va ta tahanshi kaa mbəzli bələkwə bələkwə faɗə mətsəkə ɓay, ghwani hwəm niy tahay ghwəy lə tsaa niy təraa?» kə. Ma kə ghəshi na: «Gambal mbərfəŋ» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma kə Yesəw ki na: «Ya sa nzana tsəgha kiy, wa shiy mənishi mbə ma ghwəy favə kwəmaa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dzəghwa mbaꞌa ghəshi dzashiy dzəmbə məlmə Betəsayda ki, mbaꞌa məndi pəmanakə ghwəlfə tiɓa. Dza məndi ka cəꞌwə Yesəw a ghəci mbəə dapay ntsa va lə dəvə ci ta mbəliti. ");
INSERT INTO bcw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dzəghwa Yesəw kaa ghwəlfə tsa va tasl kəsəvə tə dəvə ci, mbaꞌa kəsəkəvəri səvəri mbə məlmə. Dza na kaa ndighwər, peꞌ peꞌ tafanatishi tə mətsəhi ci, kə mbaꞌa fakən dəvə ci kən. Dza na ka ɗəw va ghwəlfə tsa va, a kə na: «Ka nay pi gha na?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dza ghwəlfə tsa va ka nighə pi. A kə na: «Yə mbə nashi mbəzli nzee, ma yən nighəshiy nja fəhi mbə dza» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zhini Yesəw diɓa mbaꞌa fanati dəvə tə mətsəhi ci. Ma sa nə ghwəlfə vərəghə kə na, ɗiweŋ ghəciy nay pi. ");
INSERT INTO bcw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma kə Yesəw ngəci ki na: «Mbalaa jighi karə ki, əntaa gha zhiniy dzar mbə məlmə ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma ləy hwəm kwəma va ki na, mbaꞌa kar Yesəw lə *mbəzli ta səɗa ci maɗishi ta dzashiy dzəmbə məlməhi ndəkwə ndəkwə ni vəgha məlmə Shezare Filipə. Ma ghəshi mbə kwal na, dza Yesəw ka ɗəw kwəma və shi, a kə na: «A ndə nzee ka mbəzliy ni baya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma kə mbəzli ta səɗa ci kaa zləɓanci na: «Zhaŋ tsaa mənipə batem nza gha, ka nihwəti mbəzliy ni. Nihwəti na: *Eli nza gha, kə ghəshi. Ma nihwəti ɓa na: Tsahwəti ndə mbə ka gəzə kwəma Hyala nza gha, kə shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma kə Yesəw ki na: «Ya ghwəy na ghwəy kiy, wa ndə nzee ka ghwəy nia?» kə. Ma kə Piyer na: «Ghay, Kəristəw nza gha, Ntsa tivə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma sa gəzəkə Piyer tsəgha na, dza Yesəw mbaꞌa makətishi vantaa ghəshi taa gəzə kwəma kən ya kaa waɓa. ");
INSERT INTO bcw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dzəghwa Yesəw ka gəzanshi kwəma kaa *mbəzli ta səɗa ci ki, a kə na: «Yən yən Zəghwə yakə ndə ngəriy, ta sahwə ngəraꞌwə dzee dalala. Mətikwəkwər mbə *ka Zhəwifə, ghəshi lə mbəzli dikə dikə ni mbə *ka ta Hyala, mbaꞌa *ka ɓənipə kwəma pəhəti Hyalay, ka dza ghəshiy ɗi mətsə yaw. Ta paslantəra dza məndi, ma sa kee mətiray, ta zhakatira dzee mbə məti tə kwa mahkana vicee kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dzəghwa na mbaꞌa gəzanakəshi kwəma va, paꞌi paꞌi gwanata tsa nzə. Ma sa favə Piyer tsəgha na, dza na mbaꞌa harvə Yesəw dzəvəgha bəla: «Wəzə na nava kwəmaa kəsaŋaw» kə ngəci. ");
INSERT INTO bcw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ꞌWakəvə Yesəw tsəgha, tərəɗ zhəghətəvay zhar kwa mbəzli ta səɗa ci gwanashi, ka nighəshi. Dza na ka naɓə Piyer, a kə na: «Kərakə pə gha lə ya, *ndə jaka tsa Hyala tsa. Na gha na hwəlfə təkə kwəmay, kwəmaa səəkə va Hyala na teepəw. Təkə kwəmaa səəkə va ndə ngəri na» kə. ");
INSERT INTO bcw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dza Yesəw kaa mbəzliy ɓasəshi va tiɓa, daꞌ harashi ghəshi lə mbəzli ta səɗa ci gwaꞌa, ma kə ngəshi na: «Mbaꞌa kə ndəə ɗi nəwray, ə kə tsava ndə zlay zəzəə dzəkən tsa ci ghən, mbaꞌa zləɓavə sa ngəraꞌwə lə mətita gwaꞌa, ma nza ghəci nəwra. ");
INSERT INTO bcw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa nzana ya wa ntsaa ɗi mbəliti piy tsa ci tikə tə hiɗiy, ta zamti tsa mə ghwəmə piy tsa ci dza na. Ma ntsaa dzaa zamti piy tsa ci tikə tə hiɗi tə mbərkə kwəmee lə Yəwən kwəma wəzə nay, ta mbəliti tsa mə ghwəmə piy tsa ci dza na. ");
INSERT INTO bcw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nay ghwəy na, ya shi tə hiɗi ni gwaꞌa gwaꞌaa kwəmavə ndə, mbaꞌa piy tsa ci mə ghwəmə zayəy, shiy tiɓa ndəə ꞌwəy ti mbə kwəma va tsəghaw. ");
INSERT INTO bcw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sa nzanay, tsahwəti sə tiɓa tepə gar dza ndəə mbəərəti piy tsa ci ti mə ghwəmə va Hyalaw. ");
INSERT INTO bcw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mbaꞌa kə ndəə haꞌwə va ndəgha fətiy dzəkənee, ya va gəzə kwəmee kaa mbəzli mbə vəghwə tsa ndatsə tsa fa ma kwəma Hyala, ka məməni war *kwəma jikir nay, ta haꞌwə dzee, yən Zəghwə yakə ndə ngəri va ndəgha fətiy dzəkən kwərakwə, ghala vəghwə tsa dzee zhəkə mbə shəndəkə tsa Dirə, ghəy lə ka kwal Hyala ɗewɗew ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zhini ma kə Yesəw ɓa na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, a nihwəti mbəzli mbə ghwəy ghwəy mbəzli tikə niy, ka ghəshi gha bəkwə na ta nay dza ghəshi njasa dza Hyalaa səəkə ta sləkə mbəzli lə bərci nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dzəghwa sa mənta vici kwaŋ ləy hwəm shi va na, dza Yesəw kaa kar Piyer lə Zhakə mbaꞌa Zhaŋ, pəm pəməvəshi kwasəbə. Ka dzashiy dzəmə ghən kəlaŋ tsa biti tsa, ta nza ghəshi li məɓa kwətishi. Ma sa tsəhəshi ghəshi məɓa na, mbaꞌa Yesəw zhəghanakəshi nahwəti pa. ");
INSERT INTO bcw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsaꞌ pə gha kaa kwəbeŋer kən ghən ci na, ka mbərə tezlezlezlezl, kala shiy tiɓa gar mənti payshi tsəgha tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nighə ghəshi diɓa na, kar *Eli lə *Məyizə tsahwəshi. Dza ghəshi ka gəzə kwəma lə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma kə Piyer kaa Yesəw tsəgha na: «A Metər, jəw na wəzə ghwəmmə nzəyəmmə tə pətsaw. Kadiw a ghəy daŋəti ceker mahkan, kwətiŋ tsa gha, mbaꞌa tsa Məyizə, mbaꞌa tsa Eli» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kwəma gəzə na va tsəghay, ə sənata ma na kwəma ka na gəzə, sa səəta məhərli ci. Sa nzana tərəŋwshi her shi dzashi va hazləni mahkanashi. ");
INSERT INTO bcw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ghavə kwəleɓi zləlahə ghəshi səəkəə pəlakənvashi kən shi tsəgha. Ma fa ghəshi ki na, məli Hyalaa gəzanshi kwəmaa dzəkən Yesəw səəkə mbə kwəleɓi va, a kə na: «Ava ghəci na Zəghwee ɗee tərəŋw, fam kwəma və!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","War ghwəla ki, njəꞌwə kə ghəshi dzar tiɓa na, nay ndə ghəshi tiɓa ghwəlaw. War Yesəw sa tiɓa vəgha shi kwətiy. Mbaꞌa ghəshi maɗishi ta səkwashi mə kəlaŋ ki. ");
INSERT INTO bcw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma kə Yesəw kaa ngəshi ghəshi mbə səkwa səəkə mə kəlaŋ tsa va na: «Əntaa ghwəy dzaa gəzə shi nashi ghwəy va ya kaa tsamaɓa ndə ma! War gwəŋəŋwəy pə ghwəy taa nza, paꞌ ghala pətsa ka Zəghwə yakə ndə ngəri mətiy, zhini mbaꞌa zhakatiy mbə məti» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mbaꞌa ghəshi ɗivə fəti ta kwəma gəzanakəshi Yesəw va nanzə ngar na, war mbə ɗəɗəw kwəma ghəshi kwa jipə shi, a kə ghəshi na: «A na gəla na zhini na naa gəzəmmə kwəma, nə na “Paꞌ ghala pətsa kee mətira mbaꞌee zhakatira mbə məti” kə kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dza ghəshi ka ɗəw kwəma va Yesəw, a kə ghəshi na: «A Metər, sa wana niy nə *mbəzliy ɓənipə kwəma pəhəti Hyala na, “Pərɓa Eli dza naa səəkəy ka *Kəristəw gha səəkə” kə ghəshia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma kə kaa zləɓanshi na: «Yaŋ tsəghaa nava nanzə, na kataŋ nay Eli dza naa ꞌwa kwal səəkə ta gəzanshi zhəghə nefer shi kaa mbəzli, ta nəw kwəma Hyala. A zliyahi Hyala niy gəzəkə kwərakwə: “War ta sahwə ngəraꞌwə dza Zəghwə yakə ndə ngəri tərəŋw. Ka ghəzliti məndi, ka zhəghəti nja sa kama viri ti” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma ki e gəzaŋwəyəy, a Eli səəkəy. Dza mbəzli mbaꞌa ghəshi mənti *kwəma jikir na li njasa ɗi ghəshi, njasa niy gəzəkə zliyahi Hyalaa dzəkən kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma kar Yesəw lə mbəzli mahkan ni vaa dza ta tsəhə vəgha niy niy tərmbə va tiɓa mbəzli ta səɗa ci na, mbaꞌa ghəshi nashi mbəzli tiɓa ɗaŋ, mbaꞌa mbəzli ta səɗa ci va tə jipə shi. War ka ngərə ghəpə nihwəti mbəzli mbə *mbəzliy ɓənipə kwəma pəhəti Hyala li shi. ");
INSERT INTO bcw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","War sa nay mbəzli tiɓa va Yesəw na, kwəma vətəghə ghənzə mənta və shi tsəgha. Dza ghəshi ka kəsli baliy dzəvəgha ta səkwə. ");
INSERT INTO bcw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dzəghwa Yesəw ka ɗəw kwəma va mbəzli ta səɗa ci ki, a kə na: «Dzəkən wa ngərə ghwəy ghəpə li shi shəka?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma kə tsahwəti ndə kwətiŋ mbə mbəzliy ɓasəshi va na: «A Metər, wa zəghwee niy pəməkee ngəŋa, nza na gwərapəy va zəlghwə bashakə, kala mbə ghəciy gəzə kwəma. ");
INSERT INTO bcw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","War nə ma zəlghwə tsa va, kafə kə ti ya kwəmaɓay, ka naa dza ɓəripə fati tə hiɗi. War gwifgwifi ghaa nighəmaa nza ta miy ci, ka pərə sliꞌi ci. Tsaꞌ pə gha kaa vəgha ciy nza na, hyaŋ hyaŋ hyaŋ mətita. Naa niy səəkəree ka cəꞌwə *mbəzli ta səɗa gha ni, a ghəshi tahantəra bashakə tsa va mbə ghən zəghwee va pən na. Kala mbay ghəshiy tahamti» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma sa gəzəkə ntsa va tsəgha, ma kə Yesəw kaa mbəzli na: «Mata ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsa ɗi ma ɓanavə nefer ghwəy kaa Hyalay! Paꞌ hwəm ɗi ghwəy yən nzəyra lə ghwəy kia? Paꞌ hwəm dzee nza mbə səꞌwa kwəma ghwəy diɓa kia? Pəməram zəghwə vaa səəkə!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dza pəm məndi pəmanakə zəghwə va. War sa nay zəghwə va Yesəw tsəgha na, dza zəlghwə tsa va mbaꞌa gwaŋəzay, ɓəripə ghəci məy tə pi. War ka mərmərə tsəgha. War gwifgwifi ghaa nighəma sar kwa miy ci. ");
INSERT INTO bcw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma kə Yesəw ka dəy na: «A ntsa, gar hwəm na piya zəghwə na lə zəlghwə tsa tsətsə ghala kəsəvə naa?» kə. Ma kə dəy zəghwə va na: «Ghala ghəci jəwəy ghati na tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɗaŋ səɗa səəkə zəlghwə tsa va mbə pəla paslamti. Ndəghambəə dzəmbə ghwə fəcahwəti, ndəghati tə kwəfa fəcahwəti, war tsəgha. Mərshi lə ghəy na gha, a gha mbəlitəŋəy zəghwə ghəy na, gha gar mbay mbəliti» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma kə Yesəw ngəci na: «“Gha gar mbay mbəliti”, pə gha. Ə sənay ma gha tsahwəti sə tiɓa kala mbay məniva kaa ntsaa ɓanavə nəfə tsa ci kaa Hyalaw, pə gha na?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","War sa gəzəkə Yesəw tsəgha na, ghavə ntsa va zlaŋzlaŋ: «Wa nee ɓanavə nəfə tsee kaa Hyala, ə pə ghaa kəətira ta mbee ɓanavə nəfə tsee wəzə wəzə!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsaꞌ kə Yesəw na, mbəzli ɗaŋ mbə ɓasəvaa səəkəə dzəvəgha shi lə bali. Dza na ka gəzə kwəma lə bərci tərəŋwəy kaa zəlghwə bashakə tsa va. Ma kə na: «A bashakə tsaa pəhə ghani ndə tsa, ka zhəghə ndə ka mədəŋ, yən gəzaŋa na, səvəri mbə ghən zəghwə na sənzənva! Əntaa gha zhiniy zhəmbə ghən ci ghwəla ya hwəmɓa ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ꞌWakəvə zəlghwə bashakə tsa va kaa lala zlaŋzlaŋ, kyak ngwəmaghwa ghəciy səvəriy mbə ghən ci. Tsaꞌ pə gha kaa zəghwə va tiɓa na, war nja ntsaa mətiy. Paꞌ ka gəzə nihwəti mbəzli: «Aa mətiy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dza Yesəw, tasl kəsəvə tə dəvə ci, zaŋ kafakati zəghwə va, mbaꞌa zəghwə va garəy məgarə. ");
INSERT INTO bcw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dzəghwa Yesəw mbaꞌa dzay dzəmbə ciki. Ma sa dzəmbəy na mbə ciki tsa va kwətishi ghəshi mbəɓa lə mbəzli ta səɗa ci na, tapə mbəzli ta səɗa ci va ta ɗəw və, a kə ghəshi na: «Tawa niy mbay ma ghəy tihəkəvəri bashakə tsa va na ghəya?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A kə Yesəw ngəshi na: «Gəla hwəlfə bashakə tsa vay, ka təhəva na səvəri mbə ndə kala war lə cəꞌwəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dza ghəshi mbaꞌa ghəshi ɓarvashi tə pətsa va, mbaꞌa ghəshi dzarshi tə hiɗi ka Galile ki. Niy ɗi Yesəw məndiy sənay pətsa nza na tiw. ");
INSERT INTO bcw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sa nzanay, mbə ɗi ɓananshi shiy niy nza na kaa mbəzli ta səɗa ci. A kə na: «Yən yən Zəghwə yakə ndə ngəriy, ta kəsəvəra dza məndi mbaꞌam fambəra mbə dəvə mbəzli. Ka mbəzli va dza na, mbaꞌa ghəshi paslantəra. Ma sa kee mətiray, tə kwa mahkana vicee kwa kwəli na, ta zhakatira dzee mbə məti» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma mbəzli ta səɗa ci nashi ki na, favə shi ɗi Yesəw gəzə ghəshiw, zhini ɓa na, ka ghəranshi hazləni va ɗəw shi va va Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dza ghəshi ndəs ghəshi tsəhəshi mbə məlmə Kapernahwəm, mbaꞌa ghəshi dzəmbəshi mbə ciki. Dza Yesəw ka ɗəw kwəma və shi, a kə na: «Dzəkən wa ngərə ghwəy ghəpə ghwəy kwa kwal baya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gwəŋəshi ghəshi nzəyshi kala zləɓa, sa sənay ghəshi dzəkən kwəma ntsaa gwəra dikə tsa mbə shi ngərəhwə ghəshi ghəpə kwa kwal, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dzəghwa Yesəw ki, das nzəyəy mənzəy, dza na kaa mbəzli ta səɗa ci va məŋ lə bakə ni, mbaꞌa harashi. A kə kaa ngəshi na: «War mbaꞌa kə ndəə ɗi ghəciy məniy ka ntsaa ꞌwa kwəma kaa nihwəti mbəzli mbə ghwəyəy, ə kə ndə zhəghəti ghən tsa ci ka ntsaa kəray ləykə tə mətsəni, ka ndə ghəranshi sləni kaa niy tərmbə va mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dzəghwa na kaa zəghwə jəwə tə pətsa va pəm pəməkə, mbaꞌa garəy kwa kwəma shi tiɓa. Dza na mbaꞌa hwətəməvə, a kə ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ya wa ntsaa kaꞌwəti zəghwə jəwə nja sasa, war tə mbərkə kwəma yay, yən dəꞌwə ghən tsee na sa kaꞌwəti na va tsəgha. Mbaꞌa kə ndə kaꞌwətəray, kwataka yən kaꞌwəti na gwaꞌa tsəghaw, aa kaꞌwəti ntsaa ghwənikəra va kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dzəghwa Zhaŋ mbaꞌa səəkəə gəzanci ka Yesəw, a kə na: «A Metər, a ghəy nay tsahwəti ndə ghəci mbə tihə gazlaka lə slən tsa gha. Mbaꞌa ghəy makəti na ghəy, sa kama na kwasəbə ghwəmmə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma kə Yesəw ngəci na: «Zlayəm ka makə ghwəy ma, sa nzanay, ndə tiɓa mbaꞌa dzaa mənti shi maɗaŋa maɗaŋa ni lə slən tsee, zhini war ghwəla na, ka gəzə kwəma gəmgəm na ghəciy dzəkən yaw. ");
INSERT INTO bcw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ntsaa kama mbə jaka lə ghwəmməy, tsa ghwəmmə ndə na tsava. ");
INSERT INTO bcw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ntsaa dza vaa tavəŋwəy ya yam jəwə, sa nza ghwəy mbəzliy nəwra, yən *Kəristəwəy, ə gəzaŋwəy ya, ta na navay, tsəgha na, ta kwəmavə zhəmə ci dza ntsa va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma kə Yesəw ɓa na: «Ya wa ntsaa dzaa mənti shiy ngəɗi mbəzliy təhəshi ma ndara nefer shi, dza mbaꞌa ghəshi shikəshiy dzəmbə məni kwəma jikir nay, a ngəraꞌwə taa nza kən tsava ndə. Wəzəɓa pəhanaghwa məndi vəna kwa wəri ci, mbaꞌam ndəghaghwa kwa hwər kwəfa mbaꞌa mətiy dza naa favə kən kwəmaa dzaa nza kən. ");
INSERT INTO bcw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ava va tsəgha nzana ki, war mbaꞌa kə sə, ya nja dəvə ghaa fəŋa dzəmbə məni kwəma jikir nay, sla pə gha slanti, wəzəɓa kwəmavə gha piy tsa gha slar tsa va Hyala lə dəvə kwətiŋ na, kən na dza ghaa dzaŋaa dzəmbə ghwəə kəɗi ma lə dividivi gha bakanashi.  ");
INSERT INTO bcw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tə tsava piy, ka məti ləhwəə zəmə vəgha ndə ngəriw, ka məti ghwəw, kə Zliya Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ya səɗa gha fəŋa naa dzəmbə məni kwəma jikir nay, sla pə gha slakəghwa tə gha! Wəzəɓa kwəmavə gha piy tsa gha slar tsa va Hyala, ya kwətiŋta na səɗa va gha na, kən na dza ghaa nza lə shiɗshiɗ gha bakanashi mbaꞌam bəzlambəŋaa dzəmbə ghwəə kəɗi ma,  ");
INSERT INTO bcw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ta nza gha tə pətsa gəzə Zliya Hyala va, ka məti ləhwə tiɓaw, ka məti ghwə tiɓaw, kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tsəgha na diɓa, mbaꞌa kə nahwəti mətsə ghaa ngəɗiŋaa dzəmbə məni kwəma jikir nay, ə pə gha lamti kwa ghən gha! Wəzəɓa tsəhəŋa gha tə pətsa sləkə Hyala ya kwətiŋta na mətsə va gha na, kən na dza ghaa nza lə mətsəhi gha bakanashi, mbaꞌam bəzlambəŋaa dzəmbə ghwəə kəɗi ma,  ");
INSERT INTO bcw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ta nza gha tə pətsa gəzə Zliya Hyala va, ka məti ləhwə tiɓaw, ka məti ghwə tiɓaw, kə. ");
INSERT INTO bcw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ya wa ntsaa dza ta sla shiy kaa Hyalay, a dza naa manati ghwəni tə shi va, ta mbə ghəshiy nza wəzə kwa kwəma Hyala. Ma ghwəy kwərakwəy, ta sa ngəraꞌwə dza ghwəy, ta nza ghwəy wəzə kwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A ghwəy sənay kiy, shiy wəzə na ghwəni. Ma mbaꞌa kə ghwənghwən tsa mbə kəɗiyəy, lə wa ka ndə mbəə zhiniy zhanambə ghwənəghwən tsa vaa? Va tsəgha kiy, ə pə ghwəy məniŋwəy ka mbəzli wəzə ni nja ghwəni, lə zərkə pə ghwəy mbə nzəy tsa ghwəy kwa jipə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dza Yesəw ki, mbaꞌa maɗiy ɓarvay tə tsa va pi, ka dzay dzəti hiɗi ka Zhəwde, pəri na pəriɓa bəla həl Zhərdeŋ. Zhini mbəzli diɓa ngwərfə ghəshi zhiniy ɓasəkəvashiy dzəvəgha. Dza na mbaꞌa ghati ɓananshi kwəma ki, njasa ka na vaa məni ndimndim. ");
INSERT INTO bcw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dzəghwa *ka Farisahi, mbaꞌa ghəshi kətəghəvashiy dzəvəgha ta ɗəw kwəma və, ta nighə kwəma ci, ma kə ghəshi ngəci na: «A Metər, ɓanavə kwal kwəma pəhəti *Məyizə kaa ndə ta tihə mali ci ta na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dza Yesəw ka zləɓanshi lə ɗəw kwəma, a kə na: «A pənəy, njaa niy nə Məyizə ngəŋwəy baya?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A kə ghəshi na: «A Məyizə niy ɓanavə kwal kaa zal ta tihə mali ci, tsasl kaa zliya kwasəbə, kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma kə Yesəw na: «Sa nza ghən tsa ghwəy caslakəy, va tsəgha niy gəzaŋwəy Məyizə kwəma va tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ə gəzaŋwəyee nee ki, ta na na kwataŋa sa niy ngamti Hyala shiy gwanashiy, dzəghwa na mbaꞌa ngati zal ghəshi lə mali, kə Zliya Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ma kə diɓa na: “Ava va tsəgha dza zal ɓarvay vəgha kar dəy lə mbəghəy, nza ghəshi dzaa jakəshi lə mali ci. ");
INSERT INTO bcw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ma nza ghəshi bakanashi mənishi ka vəgha kwətiŋ” kə. Mbaꞌa kə tsəgha kiy, mbəzli bakə na ghəshi ghwəla kiw, vəgha kwətiŋ na sa shi. ");
INSERT INTO bcw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ghənzə tsəgha kiy, əntaa ndə ngəri təhəvəri shi jakəti Hyala ma» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dza kar Yesəw mbaꞌa ghəshi dzakəshiy dzakə ghi. Ma ghəshi kəghi tsa va na, dza mbəzli ta səɗa ci ka zhiniy ɗəw kwəma va və diɓa. ");
INSERT INTO bcw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma kə Yesəw ngəshi na: «War mbaꞌa kə ndə təhamti mali ci, dza mbaꞌa ɓəvə nahwəti maliy, a ntsa va mənti ghwərghwər va na kwa taŋa va mali. ");
INSERT INTO bcw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsəgha na lə mali kwərakwə ɓa, mbaꞌa kə mali ɓarvata va zata, mbaꞌa dzaa ɓəhwə tsahwəti zaləy, aa mənti ghwərghwər» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dza nihwəti mbəzli mbaꞌa ghəshi ɓanakə ndərazhi kaa Yesəw, a ghəci fakən dividivi ci kən shi ta təfanshi miy. Kala ɗi *mbəzli ta səɗa ci tsəgha, dza ghəshi ka makə mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma sa nashi Yesəw ghəshi mbə makə mbəzli va na, mbaꞌa nəfə tsa ci satiy dzəkən mbəzli ta səɗa ci. A kə ngəshi na: «Zlashim ndərazhi jəw jəw ni va, a ghəshi sar dzəvəghee, ka makəshi ghwəy ma. Sa nzanay, gəla mbəzli nja ghəshi na shi sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ə gəzaŋwəy ya, ta na navay, tsəgha na, kala zləɓavə kə ndə Hyalaa sləkə mbə nəfə tsa ci nja zəghwə jəw nay, ka kwəmavə tsəhəy ndə tə pətsa sləkə na tepəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma sa gəzəkə na tsəgha na, dza na hwətəm hwətəm, hwəhwətəməvə ndərazhi va, mbaꞌa fafanakənshi dividivi ciy təfanatishi miy. ");
INSERT INTO bcw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dza Yesəw mbaꞌa maɗiy ka dzay. Ma ghəci mbə kwal na, dza tsahwəti ndə mbaꞌa səəkəy lə bali. Səəkə na tsəfəkwə tsəfəkwəy kwa kwəma ci. A kə na: «A Metər tsa wəzə tsa! Wa shi dzee mənti kee kwəmavə piy tsaa kəɗi ma tay?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma kə Yesəw ngəci na: «Sa wana nə gha, ntsa wəzə tsa, pə gha kaa ngəraa? Ndə tiɓa wəzə ghəci kala war Hyala kwətiŋtaw. ");
INSERT INTO bcw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Talay, a gha sənata kwəma gəzəkə *kwəma pəhəti Hyala ɓasa. Ma kəy: “Ka pəəsli ndə gha ma, ka pəla mali ndə gha ma, ka ghəli gha ma, ka təɓə dzərvə ghaa dzəkən ndə ma, ka məni tsəhwəli gha ta shi ndə ma, ə pə ghaa haꞌwə tə kar dəŋa lə məŋa” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma sa favə ntsa va tsəgha, ma kə na: «A Metər, shi ɓəlakə gha niy, gwanashi nəwamtishee ghala yən zəghwəra» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dzəghwa Yesəw ka nighə, mbaꞌa ɗiti ntsa va mbə nəfə ci. A kə ngəci ki na: «Ma ghənzə tsəghay, shiy kwətiŋ tərə na va gha nana, ta mənishi gha. Mbala pamti səkəm tə shi va gha, a gha tahanavəshi gəna va kaa ka ndərma, nza gha səəkə ta nəwra. Ma ghalaɓa kiy, ta kwəmavə shiy gwəramti dza gha mə ghwəmə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","War sa favə ntsa va Yesəw gəzanakə kwəma va tsəgha na, ka zhanci nəfə tsa ci tərəŋw. Dza na ka dzay lə nəfə lə nəfə, sa nzana ndə shiy tsa tərəŋw tsa ghəci. ");
INSERT INTO bcw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dzəghwa Yesəw njəꞌwə nighəti *mbəzli ta səɗa ci. Ma kə kaa ngəshi na: «Nay ghwəy na, ngahə na tsəhə tə pətsa sləkə Hyala va ka shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dza kwəma va mbaꞌa səəvəri məhərli mbəzli ta səɗa ci tərəŋw, kala sənata kwəma ka ghəshi gəzə. Zhini ma kə Yesəw ɓa na: «A ndərazhee, ngahə na tsəhə tə pətsa sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɓəlaŋɓa ngaləwba dza naa dzəvərita kwa kwal batal cisli shiy, kən dzəti pətsa sləkə Hyala va ndə shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dzəghwa kwəma va, mbaꞌa zhiniy səəvəri məhərli shi, tapə ghəshi mbə ɗəɗəw kwəma kwa jipə shi, a kə ghəshi na: «Əy, war tsəgha kə kiy, wa ntsaa dza vaa mbəliy kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dza Yesəw njəꞌwə nighəti shi. A kə na: «Ma kwəma vay, ka mbay mbəzliy məntiw. Ma na Hyala nanzə kiy, aa mənti. Sa nzanay, shiy tiɓaa taŋanati bərci kaa Hyalaw!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma kə Piyer ngəci na: «A Metər, ghəy sana kiy, avanay gwaꞌa gwaꞌa zlashi ghəy shiy, mbaꞌa ghəy nəwvəŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma kə Yesəw ngəci na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya wa ntsaa zlay ghi tsa ci, ya ngwarməhiyəy zhər lə ghyehi gwaꞌa, ya kar dəy lə mbəghəy, ya ndərazhi yakə na, mbaꞌa veher ci gwaꞌa war tə mbərkə kwəmee, lə Yəwən kwəma wəzə nay, ");
INSERT INTO bcw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kwa kwəma jəw na ta kwəmavə shi ci va dza na tsəgha gar bələkwə səɗa tikə tə hiɗi nza ghwəmmə ni, ya ghi na, ya ngwarməmə, ya didi, ya məmə, ya ndərazhi, ya veher, zhini ta sahwə ngəraꞌwə ghəci dza. Ma ghala vəghwə tsaa dzaa zhikə diɓa na, ta kwəmavə piy tsaa kəɗi ma ghəci dza. ");
INSERT INTO bcw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mbəzli ɗaŋ mbə ka ꞌwa kwəma kaa mbəzli sanay, ka mbəzli ləy hwəm dza ghəshiy zhəghəshi. Ma ni ləy hwəm mbəzli sana na, mbaꞌa ghəshi zhəghəshi ka mbəzliy ꞌwa kwəma kaa mbəzli» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dzəghwa Yesəw mbaꞌa maɗiy ta dzəmə məlmə Zherəwzalem lə *mbəzli ta səɗa ci, ka ꞌwanshi kwal ghəci. Mbəzli ta səɗa ci va na mbə ghəranshi hazləni tərəŋw. Zhini tsəgha nihwəti mbəzli kwasəbəshi va hazlənishi kwərakwə. Zhəghwa Yesəw diɓa daꞌ harashi mbəzli ta səɗa ci va məŋ lə bakə niy dzəvəgha. Dza na mbaꞌa ghati gəzanshi shiy dzaa məniva li kwa kwəma jəw, ");
INSERT INTO bcw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","a kə kaa ngəshi na: «Avanammə mbə kwal sana ta dzəmə məlmə Zherəwzaleməy, mbəɓa dza mbəzli ta fambəra, yən Zəghwə yakə ndə ngəriy dzəmbə dəvə mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala. Ka ghəshi dza na mbaꞌa ghəshi ɓasakənɗa ngwəvəə pəəslira. Mbaꞌa ghəshi dzaa fambəra mbə dəvə *mbəzliy kamaa ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sa ka mbəzli va dza kwərakwə ki na, ka tsəərəɗa, ka tifə ndighwər dzəkənee, ka dəꞌwəra lə kwərpə. Ma ləy hwəm ki na, ka ghəshi dza mbəh paslantəra. Mətira mee, sa kee mənti vici bakə kwa kwəliy, tə kwa mahkana vici na, ta zhikəməra dzee kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ma ləy hwəm kwəma va ki na, mbaꞌa kar Zhakə lə Zhaŋ, ndərazhi Zhebede kətəghəvashiy dzəvəgha Yesəw, ta ɗəw kwəma və, a kə ghəshi ngəci na: «A Metər, ə ɗi ghəy gha məntəŋəy kwəma dza ghəy na ta ɗəw va gha!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma kə Yesəw na: «Wa na ɗi ghwəy va kwəma yən məntəŋwəy kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A kə ghəshi na: «Ma ɗi ghəyəy, ghala pətsa dza ghaa nzəy kwa gəzli mazə tsa gha dikə tsay, nza gha ndaŋəy kwal ta dza ghəy nzəyŋəy vəgha gha, mbaꞌa tsahwəti tə kwa bəzəmə gha, mbaꞌa tsahwəti tə kwa zleɓi gha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma kə Yesəw na: «Ma ghwəyəy, sənashi shi ɗəw ghwəy ni ghwəyəw. A pənəy, ka dza ghwəy mbay səꞌwati ngəraꞌwə tsa dzee va ta sa na? Nza ghwəy zləɓavə *batem tsa dza məndi va ta mənira na?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma kə ghəshi na: «Ta mbay dza ghəy səꞌwati» kə ghəshi. Ma kə Yesəw ngəshi na: «Yaŋ, tsəgha na nava nanzə kataŋ, ta sa ngəraꞌwə tsa dzee va ta sa dza ghwəy kwərakwə, ta məniŋwəy batem tsa dza məndi va ta mənira dza məndi. ");
INSERT INTO bcw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ə na na nzana kiy, yən dza naa bərkə na, tsatsa ndə dza naa nza tə kwa bəzəmee, tsatsa tə kwa zleɓee pənəw. War mbəzli gwəmanatishi Hyala va pətsa va kaa ngəshiy, ghəshi dza naa nzəy ti» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma sa favə niy tərmbə məŋ ni *mbəzli ta səɗa Yesəw kwəma va na, mbaꞌa ghəshi ghati ɓə nəfəə dzəkən kar Zhakə lə Zhaŋ tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ꞌWakəvə Yesəw ki mbaꞌa ɓasayshi gwanashi. Ma kə ngəshi na: «A mbəzlee, a ghwəy sənay, mbəzli nə məndi ka mazə, kə məndi tə hiɗiy, lə gwəlaŋ sləkə ghəshi mbəzli. Mbəzli dikə dikə ni kən shi kwərakwə ɓa na, ka məni kwəma lə bərciy dzəkən shi. ");
INSERT INTO bcw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ghwəy ta na tsa ghwəy ghən na ghwəy kiy, əntaa ghwəy dzaa kəli ghən tsa ghwəy nja mbəzli va ma. Ə gəzaŋwəy ya, mbaꞌa kə ndəə ɗi məniy ka ntsa dikə tsa mbə ghwəyəy, ə kə zhəghəti ghən tsa ci ka ndə ghəraŋwəy sləni tsa mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mbaꞌa kə ndəə ɗi məniy ka ntsaa ꞌwa kwəma ngəŋwəyəy, ə kə zhəghəti ghən tsa ci ka mava tsa mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Va sa nzana, yən yən Zəghwə yakə ndə ngəri sanay, sa səəkəree na, nza mbəzli ghəraɗa sləni səəkə yaw. Ta ghəranshi sləni kaa mbəzli səəkəree. Kee dza na, mbaꞌee zlay piy tsee ka mətira, ta mbəərə mbəzli ɗaŋ, nza ghəshi kwəmavə piy tsaa kəɗi ma» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dza kar Yesəw lə *mbəzli ta səɗa ci ndəs tsəhəshi mbə məlmə Zherikwə ki, zhini mbaꞌa ghəshi maɗishi ta səvərishi. Ma ghəshi mbə səvəri na, mbaꞌa vərəm mbəzli ɗaŋ nəwvəshi. Mbaꞌa ghəshi kəsay tsahwəti ghwəlfə mənzəy vəgha kwal ka cəꞌwə cəꞌwə ci. Bartime, kə məndi slən tsa ci, zəghwə Time ghəci. ");
INSERT INTO bcw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma fa ghwəlfə tsa va na, məndiy gaka. Dza na tapə ta ɗəw shiy mənishi: «Waa Yesəw, ndə ka Nazaretə na saa dzar» kə məndi ngəci. Dza na ka zlapanci kwəma, a kə na: «A Yesəw, Jijiy mazə *Davitə, mənti zhəhwər tə ya!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dza mbəzli ɗaŋ ni va ka naɓə, a kə ghəshi na: «A ghwəlfə tsa, kalay miy tsa gha va» kə ghəshi. Dzəghwa na, na naci ki na, mətsəhə zhiniy mətsahata zlapə kwəma: «A Jijiy mazə Davitə, mənti zhəhwər tə ya na gha!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dza Yesəw garə garəy, a kə na: «Harayəm a ghəci sar!» kə. Dza məndi mbaꞌam dzaa haray ghwəlfə tsa va, a kə məndi ngəci na: «Ca ki, sati, ndahwə nəfə tsa gha! Avaci mbə harŋa!» kə məndi ngəci. ");
INSERT INTO bcw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kə, fakatsaꞌwə satiy tə pətsa va, dza na fiyəkə ndəghamti kwəmtə tsa kən ghən ci, ka səəkəə dzəvəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma sa tsəhəy na na, dza Yesəw ka ɗəw kwəma və, a kə na: «A shi ɗi gha yən məntəŋaa?» kə. Ma kə ghwəlfə tsa va na: «A Metər, mətsəhee ni ɗee ghaa ghwənantəra ta mbee nay pi!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma kə Yesəw ngəci ki na: «Sati mbala, a mətsəhi gha ghwənishi, sa ndara gha nəfə tsa gha» kə. Dzəghwa nzaꞌjəw mətsəhi ci va ghwənishi tsəgha, ka mbə ghəci nay pi ki. Dza na ka nəw Yesəw kwa kwal tsa dza na tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ma sa tsəhəshi ghəshi ndəkwə ndəkwə lə məlmə Zherəwzalem, njasaa dzəvəgha bəla məlmə Betəfazhe lə Betani na, ndəs ghəshi tsəhəshi vəgha kəlaŋ tsa har məndi vaa kəlaŋ *ꞌWəlivə. Dza Yesəw ɓəŋ ghwənashi mbəzli bakə mbə *mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A kə kaa ngəshi na: «Mbalam dzəmbə məlmə tarɓa va kwa kwəma ghwəy. Sa ka ghwəy tsəhəŋwəy mbəy, ta kəsay zəghwə kwantəmca dza ghwəy pəhəpəhə kala səəkə ndəə nza mə, nza ghwəy pəlikəvəra. ");
INSERT INTO bcw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mbaꞌa kə ndəə ɗəw va ghwəy: “Wa shi dza ghwəy ta məni li pəli ghwəya?” kəy, “waa Ndə sləkəpə ɗəw na” pə ghwəy dzaa ni ngəci. Nzaꞌjəw dza naa zlatavəŋwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dza mbəzli bakə ni va mbaꞌa ghəshi dzashi. Dza ghəshi na, mbaꞌa ghəshi kəsay zəghwə kwantəmca tiɓa vəgha kwal pəhəpəhə tə zəꞌwə miy tsahwəti ciki. Tapə ghəshi mbə pəli ci. Ma ghəshi mbə pəli ki na, ");
INSERT INTO bcw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dza nihwəti mbəzli tiɓa məgarə ka ɗəw və shi, a kə ghəshi na: «A shi məni ghwəy vaa mbəzli ni? Tawa pəli ghwəy zəghwə kwantəmca tsa vaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dzəghwa mbəzli va mbaꞌa ghəshi zləɓakə kwəma va njasa niy gəzanakəshi Yesəw va ki. Əŋkwa, kə mbəzli va mbaꞌa ghəshi zlatanavəshi. ");
INSERT INTO bcw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mbaꞌa mbəzli bakə ni va kəsəghə zəghwə kwantəmca tsa va kaa Yesəw ki. Dza pəli ghəshi pəlati kwəbeŋer shi tə hwəm kwantəmca va. Dza Yesəw ki ɗal dzəməy. ");
INSERT INTO bcw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gar ɗaŋ nihwəti mbəzli pəpələnəy kwəbeŋer shi dzar kwa kwal, ka dza nihwəti ka ɓəəli kəslifi dzar kwamti ka səəkəə pəlancishiy dzəghwa kwal. ");
INSERT INTO bcw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dzəghwa tapə mbəzli gwanashi, shiy ꞌwanci kwal, lə ni ləy hwəm ci dzəmbəshi mbə ngwəmə lala, a kə ghəshi na: «ꞌWəsa kaa Hyala! Təfanati miy tsa nzə Hyalaa sləkəpə kaa ntsaa səəkəy tsa mbə slən tsa nzə! ");
INSERT INTO bcw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Təfanati miy tsa nzə Hyala kaa ntsaa dzaa məni mazə dzəghwa sa jijimmə *Davitə! ꞌWəsa kaa Hyala dikə na mə ghwəmə!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dzəghwa ndəs Yesəw tsəhəy mbə məlmə Zherəwzalem ki. Dza na mbaꞌa dzəmbəy mbə *ciki Hyala. Dzəmbə na njəꞌwə njəꞌwə naghamti pətsa mbəɓa gwaꞌa gwaꞌa. Ma sa nzana ki mbaꞌa vərɗi mənta na, dza ghəshi mbaꞌa ghəshi dzashi lə mbəzli ta səɗa ci va məŋ lə bakə niy dzəmbə məlmə Betani. ");
INSERT INTO bcw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma way pi tə həzlimə va ki, sa səvərishi ghəshi mbə məlmə Betani na, dza ma ka ghəranci kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sa nə na tsaꞌ kə na, ka pəzli dəŋw bəzakə kərakə, zləngwəvə kəslifi ti. Dza Yesəw mbaꞌa maɗiy ka dzaa dzəta dəŋw bəzakə tsa va, nda kee dzaa ngəlivə ya ti, kə. Ma sa tsəhəy na, tsaꞌ kə na, war kəslifi zləngwəvə bəzakə va, kala ya ti, sa nzana ghwəla vəghwə tsa ka bəzakəə ya ti. ");
INSERT INTO bcw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dzəghwa ma kə Yesəw kaa bəzakə va na: «Gha gha bəzakə nay, ka dza ndəə zhiniy zəhwə ya tə gha ghwəla na gha ka gha nzaw!» kə. Mbaꞌa mbəzli ta səɗa ci va favə kwəma va. ");
INSERT INTO bcw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dza ghəshi ndəs tsəhəshi mbə məlmə Zherəwzalem, mbaꞌa Yesəw dzay dzəmbə ciki Hyala. Dzəmbə na na ka tihə mbəzli ka ɗəl shiy, lə niy pashi gwaꞌa səvəri mbəɓa. Dza na dzəpə dzəpə dzədzəpanti tebelerhi mbəzliy mbəərə gəna, mbaꞌa gəzli gəzli nzəy mbəzliy ɗəɗəl kwəkwər palayhi. ");
INSERT INTO bcw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Zləɓavə na ndəə ɓə shiy ta taŋə dzar mbə ciki Hyala tsa va ya kwətiŋəw. ");
INSERT INTO bcw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dza na ki, ka ɓananshi kwəma, a kə na: «Favə tə ghwəy, ma kə məndi mbə Zliya Hyalay: “Ciki tseyey, ciki tsa dza hwəlfə mbəzli tə hiɗi gwanashiy cəꞌwəra mbə na” kə məndi. Ma dza ghwəy na na ghwəy ki na, mbaꞌa ghwəy zhəghəti ka ləgwə ka ka ghəliy nzəy mbə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dza mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala, gwaꞌa ghəshi favə kwəma gəzəkə na va. Dza ghəshi tapə ta pəla kwal tsaa paslamti. Zhini kala hazləni ghəshi va kwəma tiɓa, sa nzana mbaꞌa kwəma ɓananshi Yesəw va kaa mbəzli tsəꞌwəta mbə nefer shi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dzəghwa kar Yesəw lə mbəzli ta səɗa ci sa mənta tihwer, mbaꞌa ghəshi səvərishi mbə məlmə va. ");
INSERT INTO bcw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ma həzlimə mekəshi ghəshi mbə zhəghəva zhar kwa kwal tsa va diɓa, tsaꞌ kə ghəshi na, bəzakəə niy nata ghəshi va lə kəslifi ti tərəŋw ghwəlita lə hililiŋə nzə ta gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dza Piyer mbaꞌa zəzəvə kwəmaa niy gəzəhwə Yesəw va. Ma kə kaa ngəci ki na: «A Metər, eh, ava ghaa nata bəzakəə niy bazlamti gha va ghwəlita kataŋəy!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma kə Yesəw ngəshi na: «A pə ghwəy ɓanavə nefer ghwəy kaa Hyala! ");
INSERT INTO bcw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ə gəzaŋwəy ya, ta na navay, tsəgha na, war mbaꞌa pə ghwəy ɓanavə nefer ghwəy kaa Hyala, kala mənti ghən ghwəy bakə bakə, kwəma gəzəkə ghəy vay, ta mənta dza na kataŋ, pə ghwəyəy; ta mbay dza ghwəy gəzə ya kaa dəlagwa na: “Ɓarvaŋa tə pətsa va mbalaa dzəghwa kwəfa!” pə ghwəy, ka na dza na mbaꞌa ɓarvata kataŋ. ");
INSERT INTO bcw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Va tsəgha nə ya ki, ya wa shi ɗi ghwəy cəꞌwə va Hyala gwaꞌay, ɓanavəm nefer ghwəy kaa Hyala njasa nzana mbaꞌa ghwəy kwəmavə shi cəꞌwə ghwəy va. Ma ghalaɓa kiy, a ghwəy dzaa kwəmavəshi. ");
INSERT INTO bcw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya hwəmɓa garəŋwəy ghwəy ta cəꞌwə Hyala, mbaꞌa kə tsahwəti ndə niy məntəŋwəy kwəma, mbaꞌa ghwəy kəsəti mbə nəfə tsa ghwəyəy, pəlatam kwəma ci va mbə nəfə tsa ghwəy, ta mbə Dəŋwəy Hyala mə ghwəməə pəlataŋwəy na ghwəy *kwəma jikir na kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kala pəlanshi kwəma məntəŋwəy mbəzli jikir na, pə ghwəy mbə nefer ghwəy kwərakwəy, ka dza Dəŋwəy Hyala mə ghwəməə pəlataŋwəy na ghwəy kwəma jikir na mananta ghwəy kwərakwəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Dza kar Yesəw mbaꞌa ghəshi zhəkəshiy zhəmbə məlmə Zherəwzalem diɓa. Dza na mbaꞌa dzəmbəy mbə *ciki Hyala, ka təwrə ghəci mbəɓa. Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala, lə *mbəzliy ɓənipə kwəma pəhəti Hyala mbaꞌa mətikwəkwər *ka Zhəwifə, mbaꞌa ghəshi səəkəshiy dzəvəgha. ");
INSERT INTO bcw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tapə ghəshi ta ɗəw kwəma və, ma kə ghəshi na: «A Metər, gəzaŋəy nda kwəma səəkə ni gha ni bərci ghəra gha sləni ghəra gha na li shi di, wa ntsaa ndaŋa kwal ta ghəra gəla sləni naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma kə Yesəw ngəshi na: «Yən kwərakwəy, ta ɗəw kwəma dzee va ghwəy kwətiŋ. Ma sa ka ghwəy zləɓakəray, nzee gəzaŋwəy səəkə tə pətsa səəkə bərci ghəree va slənee na li shi. ");
INSERT INTO bcw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ma nə ya kwərakwə kiy, Hyala ghwənay na Zhaŋ ta məni *batem ta naa, naa mbəzli? Cam zləɓakəram di!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma sa gəzəkə Yesəw tsəgha na, dzəghwa ghəshi ka sləka kwəma kwa jipə shi. Ma kə ghəshi na: «Njaa dza ghwəmməə ni kaa nana kwəma sana kia? Mbaꞌa pə ghwəmmə ni: “Hyala ghwənay na Zhaŋ” pə ghwəmməy, “za sa nzana Hyala ghwənay na, tawa niy zləɓa ma ghwəy kwəma ci shiki?” dza naa ni. ");
INSERT INTO bcw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mbaꞌa pə ghwəmmə ni diɓa: “Mbəzli ghwənay na” pə ghwəmmə na, əndaw» kə ghəshi. Sa nzana mbə hazləni ghəshi va mbəzli, sa sənay məndi Zhaŋ gwaꞌa gwaꞌa ka *ndə gəzə kwəma Hyala ghəci slar slar. ");
INSERT INTO bcw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma kə ghəshi kaa zləɓanci ki na: «Sənay ntsaa ghwənay ghəyəw» kə ghəshi. Ma kə Yesəw ki na: «Ghənzə tsəghay, yən kwərakwə na, ka gəzaŋwəyee nda kwəma səəkə bərci ghəree ni sləni li shiw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dza Yesəw tapə ta gəzanshi kwəma dzar kwa fir, a kə na: «A tsahwəti ndə niy nza tiɓay, dza na ngwəɓə ngwəɓati fəhiy zəmə tə za ci. Dza na dəzlətsəɓə hayshi, kə kaa kəꞌwə kwaɓa laꞌ laꞌ lati ta ɓəsə məəli ya fəhi va kwa. Dza na mbaꞌa ngati pi madzək tsa dza məndiy nzəy ta ndəghwə fəhi va mə. Dza na ki mbaꞌa pəlavə mbəzli ta ndəghwə tsa va, mbaꞌa zlata mbə dəvə shi, mbaꞌa dzay ta wə. ");
INSERT INTO bcw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma sa mənta vici ngəli ya fəhi ki na, mbaꞌa ndə tsa tsa va ghwənay ndə sləni tsa ci va ka ndəghwə tsa va, ta mbə ghəshiy ɓanakəvə na ci bəla ya fə dza ghəshiy ɓanci kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma sa tsəhəy ndə sləni tsa va na, dzəghwa mbəzliy ndəghwə tsa va tasl kəsəti ntsa ghwənikə məndi va, dəꞌwə dəꞌwə ghəshi dəꞌwəti, mbaꞌa ghəshi pəlay dzay tsəghay. ");
INSERT INTO bcw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ənkwa kə ndə tsa tsa va, kə kaa tsahwəti ndə sləni tsa ci, ɓəŋ ghwənanaghəshi kaa ka ndəghwə tsa va diɓa. ꞌWakəvə ghəshi kaa tsava ndə diɓa tasl kəsəti, mbaꞌa ghəshi dəꞌwəti mbə ghən tsa ci. Dza ghəshi tsəərə tsəərə ghəshi tsəərəti. ");
INSERT INTO bcw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","War yaŋ, kə ndə tsa tsa va, dza ɓəŋ ghwənanaghəshi tsahwəti ndə sləni tsa ci diɓa. Dza ka ndəghwə tsa va kaa tsava ndə nana ki, mbəh ghəshi paslamti. War tsəgha, war tsəgha ghəshi məmənti lə nihwəti mbəzli ghwənanaghəshi məndi, ka didiꞌwə nihwəti, ka bəbəkwə nihwəti. ");
INSERT INTO bcw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","War zəghwə ci kwətiŋ gwaꞌa tsəgha, saa niy tərmbə va ndə tsa tsa va. Dza na kaa zəghwə ci va ɗi na tərəŋw, ɓəŋ ghwənanaghəshi tsəgha kaa mbəzliy ndəghwə tsa ci va. Ma kwəmaa niy zəzəti nay: “Sa ka ghəshi nay zəghwə yay, a ghəshi dzaa haꞌwə ti” niy nə na. ");
INSERT INTO bcw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dza zəghwə va mbaꞌa tsəhəy və shi ki, ma kə mbəzliy ndəghwə tsa va kwa jipə shi, sa nay ghəshi zəghwə va na: “Yawaa, avanay ndə zəmə ghi səəkəy dəꞌwə ghən tsa ci ki. Dzammə ta kəsəvə, a ghwəmmə paslamti, nza tsa na mbəə nza ka sa ghwəmmə kwa vələm ki!” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dza tasl, ghəshi kəsəti zəghwə ntsa va va, mbaꞌa ghəshi paslamti, fəyik ghəshi bəzlakəmə mbəri tsa ci səəmə kwa tsa vaa dzəti ngwəla. ");
INSERT INTO bcw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ya sa dza ndə tsa tsa vaa tsəhəy kiy, njaa dza naa məni lə mbəzli vaa? Ta səəkə dza naa bakwamti ka ndəghwə tsa va, ka na dza na mbaꞌa ɓanavə tsa ci va kaa nihwəti ka ndəghwə tsa mbə dəvə shi. ");
INSERT INTO bcw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Shi va gwanashiy, war nja shiy tsaslishi va mbə Zliya Hyala mənishi ghəshi. E sənay a ghwəy səəkəə jangəhwə kwəma va. A kəy: Ma hakwə tsaa niy ndəghamti ka ndəɓə shiy vay, ghəci zhini naa zhəghəy ka hakwə tsaa gwəraa jihəti ciki. ");
INSERT INTO bcw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hyala kwa sləkəpə təravə na hakwə tsa vaa mənti ka saa gwəra tsəgha nanzə ki. Dzəghwa mbər ka kwəma maɗaŋa maɗaŋa na ghənzə mənta kwa mətsə ghwəmmə, kə Zliya Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma sa gəzəkə Yesəw kwəma va tsəgha na, cəkeꞌ *ka ɓənipə kwəma pəhəti Hyala lə mbəzli dikə dikə ni mbə *ka ta Hyala fəti ghən, dzəkən ghəy ɓəli Yesəw fir tsa va, kə ghəshi. Dza ghəshi ka pəla kwal tsaa kəsə ci. Zhini diɓa na, ka hazləni ghəshi va mbəzli ɗaŋ ni va. Dzəghwa mbərəkə ghəshi zlay tiɓa, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dzəghwa mbəzli dikə dikə ni mbə *ka Zhəwifə mbaꞌa ghəshi ghwənashi nihwəti mbəzli mbə *ka Farisahi, ghəshi lə mbəzli *Erədə ta dza ghəshiy ngali Yesəw lə ɗəw kwəma. Ma nza ghəshi mbəə kəsəti tə kwəma dza naa zləɓakə. ");
INSERT INTO bcw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A kə ghəshi ngəci sa tsəhəshi ghəshi na: «A Metər, a ghəy sənay kwəma kataŋ na ka ghaa gəzə, ka hazləni gha va kwemer gəəzə mbəzliw. Sa nzanay, ka nə gha, kar ntsa dikə tsa na tsatsa ndə, tsa jəw tsa na tsatsa ndə, pə gha, ka təra ghalaa dzəmbə mbəzliw. Na na ghay kwəma Hyala na sa ka ghaa ɓananshi kaa mbəzli lə kwal tsa nzə. Ava va tsəgha ɗi ghəy ghaa gəzaŋəy nda kwal va ghwəmmə ta tsəhanci ghən kaa mazə tsaa sləkə hiɗi ka Rəm gwanashi, nda kala kwal va ghwəmmə? A ghwəmmə tsəhanci shəkənaa, naa a ghwəmmə nzəyəmmə na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mbalaa ma Yesəw naci ki na, gwaꞌa gwaꞌa sənata na kwəma mbələy ghəshi mbə nefer shi. A kə ngəshi na: «A mbəzli ni, tawa ɗi ghwəy ngalira kia? Taram dala va ghwəy tə pətsa va e nighəti di» kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dzəghwa həŋ məndi ɓanakə. A kə na: «Fəətə tə dala na na sanay, fəətə wa naa? Ya slən tsa tsaslati məndi tsa tiy, slən tsa wa naa?» kə. Ma kə ghəshi na: «Fəətə mazə tsaa sləkə hiɗi ka Rəm gwanashi na, slən tsa ci sava diɓa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma kə Yesəw ngəshi ki na: «Ghənzə tsəgha kiy, tsəhancim ghən tsa ci kaa mazə tsa va njasa təɓə na. Ma ni Hyala shiy na, mbaꞌa ghwəy ɓanavə shi Hyala njasa təɓə ghəshi kwərakwə» kə Yesəw. Ma sa favə mbəzli va kwəma zləɓakə na va na, mbaꞌa səəti məhərli shi. ");
INSERT INTO bcw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Ka Sadəsehi, kə məndi kaa nihwəti mbəzliy: «Ka zhakati mbəzliy bəkwəshi mbə mətiw» kə ghəshiy ni. Dza ghəshi ndəs ghəshi səəkəshiy dzəvəgha Yesəw, ta ɗəw kwəma və, ma kə ghəshi kaa ngəci na: ");
INSERT INTO bcw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«A Metər, a kə *Məyizə niy ni kaa kwəma tsaslitəŋəy na ta məni ghəyəy: “Mbaꞌa kə ndə ɓəvə mali, dza na mbaꞌa mətiy zlata mali ci va, kala yakə zəghwə ghəshi liy, ə kə zəmbəghəy dzaa ɓə mali mbəri tə mali ci va, ta mbə ghəciy yanakə hwəlfə kaa zəmbəghəy tsaa mətiy va” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dzəghwa ki na, mbaꞌa nihwəti mbəzli niy nza va ghəy, mbərfəŋ ghəshi ka ndərazhi ndə kwətiŋ. Dzəghwa Cikwa tsa mbə shi mbaꞌa ɓəvə mali. Dza na mbaꞌa mətiy, kala yakə zəghwə ghəshi li. ");
INSERT INTO bcw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dza Zəra mbaꞌa ɓəvə mali mbəri tə mali va. Dza na kwərakwə ɓəlahə mətiy, nək ghəci ta yakə zəghwə kwa mali va. Zhini tsəgha lə Takwa kwərakwə diɓa. ");
INSERT INTO bcw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","War tsəgha, war tsəgha, pəŋw ndərazhi mbərfəŋ ni va hati ɓə mali mbəri tə mali va. Cəkeꞌ ghəshi bəkwəshi mbərfaŋanavashi, nək tsaa yakə zəghwə kwa. Dza mali va kwərakwə ləy hwəm shi gwanashi, mbaꞌa mətita. ");
INSERT INTO bcw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sana sənzənva kiy, avanay gwanashi ɓəhwə mbəzli va mali va. Fəca vici dza mbəzliy zhakati mbə məti kiy, mali tsama ndə dza naa nza mbə shi kwətiŋ kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma kə Yesəw kaa ngəshi na: «Ma ghwəyəy, ka favə kwəma ɗi kwəma vaa gəzə ghwəyəw. Sa nzanay, sənata kwəma gəzəkə Hyala mbə zliya nzə ghwəyəw. Zhini diɓay, sənata bərci Hyala ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A na mbəzliy bəkwəshi, sa ka ghəshi zhakatishi mbə məti e gəzaŋwəyəy, ka ɓə miꞌi zhərəw, ka ɓə zhər miꞌiw dza ghəshiy nza. Ghalaɓay, nja ka kwal Hyala va mə ghwəmə dza ghəshiy nza. ");
INSERT INTO bcw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ghənzə nja na kwəma zhakati tsa mbəzli mbə məti kiy, ə səəkə ma ghwəy jangəhwə kwəma gəzəkə Hyala mbə zliya Məyizə ghala vəghwə tsaa gəzə na va kwəmaa dzəkən ghwə mbə zhəghwə shəkəna? A kə Hyala niy niy: “Yənəy, Hyala kar *Abəraham lə *Izakə mbaꞌa *Zhakwapə nzee” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɗi naa gəzəy, tə ghwəməshi na mbəzliy bəkwəshi va. Sa nzanay, na na Hyala na, Hyala mbəzli bəkwə bəkwə ni naw, Hyala mbəzli tə ghwəmə mbə piy na, na nanzə. Ava va tsəgha nə ya, a ghwəy səŋwəy mbə kwəma zhakati tsa mbəzli mbə məti, pən» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ghala vəghwə tsaa niy kəhwə kar Yesəw va ghəpə lə ka Sadəsehiy, a tsahwəti ntsaa ɓənipə kwəma pəhəti Hyala niy nza tiɓa, mbaꞌa niy favə ghəpə tsa shi va. Wəzə ghəci niy nay Yesəw zləɓanakəshi kwəma kaa mbəzli va. Dza na ki mbaꞌa səəkəy ta ɗəw kwəma va Yesəw, a kə na: «A Metər, nama kwəma pəhəti Hyala gwəramti na diɓədiɓə tay?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma kə Yesəw ngəci na: «Avanta kwəma pəhəti Hyala gwəramti tə diɓədiɓə, saa ni va: “A hwəlfə mbəzli ka *Izərayel, favə tə ghwəy! War Hyala ghwəmmə va sləkəmmə na Ndə sləkəpə kwətiŋ! ");
INSERT INTO bcw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ɗi pə ghaa ɗi Hyala gha sləkəŋa, lə nəfə tsa gha gwanay, lə məhərli gha gwanata, lə bərci gha gwanashi, mbaꞌa gha ɓanavə ghən tsa gha gwanay” kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Zhini ma kə kwa baka kwəmaa dzəkən ɓa na: “Ɗi nihwəti mbəzli gwanashi njasa ɗi gha va ghən tsa gha kwərakwə” kə. Nahwəti kwəma pəhəti Hyala tiɓa mbaꞌa taŋamti sa bakə na va tə dikəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma kə ndə ɓənipə kwəma tsa va kaa Yesəw na: «Tsəgha na Metər, kwəma gəzə gha vay, kataŋ na. Kwətiŋtaa Hyala, nahwəti Hyala tiɓa ghwəla dzəghwakənəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","War ɗi kə ndəə ɗi Hyala lə nəfə tsa ci gwanay, lə məhərli ci gwanata, mbaꞌa lə bərci ci gwanashi. Zhini ka ɗi nihwəti mbəzli njasa ɗi na ghən tsa ci kwərakwə. Mbaꞌa kə ndəə ɗi fəti ta kwəma pəhəti Hyala bakə na vay, aa taŋəti shiy dza səɗa ka məndi vaa slasla kaa Hyala lə nihwəti shi ka məndiy ɓanta gwanashi» kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mbaꞌa Yesəw nighəti, a ntsa va fəti ghən ta kwəma va, mbaꞌa zləɓakə wəzə, kə. Ma kə ngəci ki na: «A ntsa, ma ghay, dikə tərə na gha taa tsəhə tə pətsa məni Hyala mazəw» kə. Ləy hwəm shi va ki na, ndə tiɓa mbaꞌa zhiniy kwəmavə bərci ta ɗəw nahwəti kwəma və ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma Yesəw mbə ɓənipə shiy mbə *ciki Hyala na, dza na ka ɗəw kwəma, a kə na: «A pənəy, njaa njaa ka *mbəzliy ɓənipə kwəma pəhəti Hyala ni: “Jijiy mazə Davitə na Kəristəw Ntsa tivə Hyala” kə ghəshia? ");
INSERT INTO bcw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mazə Davitə dəꞌwə ghən tsa ciy, aa gəzəkə lə bərci *Safə tsa Hyala, a kəy: Ma kə Hyala kwa sləkəpə kaa Ndə sləkəray: “Ndi nzəyŋa tə kwa bəzəmee, paꞌ fəca dzee mənti ka mbəz gha, ka mbəzli tə dəvə gha!” kə. ");
INSERT INTO bcw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davitə dəꞌwə ghən tsa ci kiy: “Ndə sləkəra” kə kaa har slən tsa Kəristəw, njaa njaa ka na mbəə nza ka jijiy Davitə diɓa kia?» kə Yesəw. Dzəghwa mbəzliy ɓasəshi va tə pətsa va ɗaŋ ni ki, war ka fa kwəma gəzə Yesəw va lə vəshi. ");
INSERT INTO bcw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma kə kaa mbəzli mbə kwəma ɓananshi na va na: «Favə ghwəy na, ndəghwə tə ghwəy ghən tsa ghwəy va yəmə kwəma məni ka ɓənipə kwəma pəhəti Hyala! Na nashiy, war lə kwəbeŋer dikə dikə ni ka ghəshiy ɗi dza kən ghən, ta ci dikə tsa shi. Jəw ɗi ghəshi məndiy səkwəshi mətsəfəkwə dzar tə ləwmaw. ");
INSERT INTO bcw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","War tə kwəma ka ghəshiy ɗi nzəy mbə *ciki ɓasəva tsa ka Zhəwifə. Mbaꞌa kə məndi harvəshi ta zəmə shiyəy, war pətsa nzəy mbəzli tə slən va ti ka ghəshiy pala ta nzəy ti. ");
INSERT INTO bcw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ghəshi diɓay, meꞌ meꞌ ka ghəshiy pamti shiy va miꞌi mbəreketi, zhini ka garə kə ghəshiy ni ta cəꞌwə Hyala. Ka ghəshi dza na nzaꞌ nzaꞌ ghəshi nzati nza tə cəꞌwə va, ta mbə məndiy ni: “Ka nəw Hyala tərəŋw ni ghəshi” kə məndi. Na nashiy, ta ɓanshi fəti dza Hyala taŋ na nihwəti mbəzli» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dza Yesəw mbaꞌa nzəyəy vəgha sərndəkə tsa shikə məndi gəna vəli məndi kaa Hyala kwa mbə *ciki Hyala. Dza na mbaꞌa mənti məhərli ta nighə njasa səəkə məndi ta shikə gənaa dzəghwa sərndəkə tsa va ki. Dzəghwa ɗaŋ mbəzli nza gəna və shi tərəŋw səsəəkəshiy shakaghwa gəna kwa sərndəkə tsa va, ɗaŋ, ɗaŋ, ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dzəghwa nahwəti mali mbəri, kwa ndərma ghənzə tərəŋw, mbaꞌa faghwa dala bakəta kwa sərndəkə tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kə Yesəw kaa mbəzli ta səɗa ci ki, daꞌ harashi, a kə kaa ngəshi na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, mali mbəri kwa ndərma nata ghwəy nay, tərəŋwɓa ghənzə faghwa na gəna kwa sərndəkə tsa kaa mbəzliy fəhwə gəna va gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sa nzanay, ma na nihwəti mbəzli vay, war jəwə tsətsə tivə ghəshi gəna ɓəkə ghəshi ɗaŋ na, səvəri mbə nahwəti na ɗaŋ na tərmbə və shi. Ma na mali na nanzə kiy, ya tsəgha na mbə ndərma na, dza na mbaꞌa ɓasanavə gənaa niy nza və gwanata kaa Hyala, gwanata tsa nzə njasa niy nza na və ta pa shiy dzəghwa hwər nzə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ma sa səvəriy Yesəw mbə ciki Hyala ki na, dza tsahwəti ndə kwətiŋ mbə mbəzli ta səɗa ci ka gəzanci kwəma, ma kə na: «A Metər, nashi niva hərezli njasa təɓə ghəshi, nay tsava ciki njasa ngatim li shi, ka təɓə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma kə Yesəw ngəci na: «Njasa nay gha va ciki tsa va dikə tsa ci sənzənvay, tə nahwəti vici na, ka dza ghaa nayəw, ta baꞌwamti dza məndi, ka dza ghaa nashi hərezli tsəŋəzli tsəŋəzli ni ni ya kwətiŋəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dza Yesəw mbaꞌa nzəyəy mə kəlaŋ *ꞌWəlivə, mbaꞌa zhəghanavə kwəma ci kaa ciki Hyala, ghəshi kwətishi lə kar Piyer, Zhakə, Zhaŋ mbaꞌa Andəre. Dzəghwa tapə ghəshi ta ɗəw kwəma və, a kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«A Metər, geꞌi lə tsama vəghwə dza shi gəzə gha niy məniva tay? Tə wa dza məndiy sənay ndal tərə shi va gwanashi ta kərkəvaw, kə məndia? Gəzaŋəy di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dza Yesəw ka gəzanshi ki, a kə na: «Məni tə ghwəy məhərli wəzə, əntaa ghwəy dzaa zləɓa məndiy ngəɗiŋwəy ma. ");
INSERT INTO bcw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sa nzanay, ɗaŋ dza nihwəti mbəzliy səəkə lə slən tsee. Ka ndə dza na: “Yən na *Kəristəw!” kə. Gəla mbəzli vay, mbəzli ɗaŋ tərəŋw dza ghəshiy ngəɗiti. ");
INSERT INTO bcw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ta favə gaka mbəz dza ghwəy dzar mbə məlməhi ndəkwə ndəkwə ni lə ghwəy, zhini ka favə nəwər mbəz mbə məlməhi kərakə kərakə ni lə ghwəy. Ya ə dza ghwəy favə shi va tsəghay, əntaa her ghwəy taa dza ma. Sa nzana, ya njaaɓay, ta məniva dza gəla niva shiy tsəgha. Ya tsəgha dza shi vaa mənishiy, ka dza hiɗiy kərə diw. ");
INSERT INTO bcw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ka hwəhwə tsa nihwəti mbəzli dzay, ka mbəz lə hwəhwə tsa nihwəti. Ka tsahwəti mazə dza na, mbaꞌa pəlati miy tə tsahwəti, tapə ghəshi mbə mbəz taa nza. Ka gərgərəva hiɗi dzar tə tsahwəti pi ghənghən ghənghən, zhini mbaꞌa ma dzaa nza tə hiɗi. Shi vay, ngəraꞌwə tsaa dzaa gha səəkə na ghəshi, njasa ka mali vaa ꞌwa kemahə ta ya zəghwə na niva shiy. ");
INSERT INTO bcw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ma ghwəy na na ghwəy kiy, məhərli pə ghwəy dzaa məni ta ghən tsa ghwəy. Sa nzanay, ta kəəsəŋwəy dza məndiy dzaa dzəti pi ngwəvə, ka didiꞌwəŋwəy dzar mbə ceker ka *ka Zhəwifəə ɓasəva. Ta kəəsəŋwəy dza məndiy dzəghwa kwəma mbəzli dikə dikə ni, ghəshi lə mezhizhə gwaꞌa, sa zləɓavə ghwəy kwəmee. Ghalaɓa kiy, ta ndəgha fəti dza ghwəy dzaa dzəkənee kwa kwəma shi. ");
INSERT INTO bcw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ava tsəgha dza naa nza, war pərɓa Yəwən kwəma wəzə na dza məndiy gəzanshi kaa hwəlfə mbəzli tə hiɗi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ghala pətsa dza məndi vaa kəəsəvəŋwəy, ka ɓəghəŋwəy dzəti ngwəvəy, əntaa ghwəy tsətsəva lə tikə kwemer na: “Njaa dza ghəy ni kaa kwəma ka ghəy gəzə kia?” pə ghwəy ma. War naa dzaa kaghwavata kwəma kwa miy ghwəy ta gəzə ghwəy ghalaɓay, ghənzə pə ghwəy dzaa gəzə. Sa dza naa nzay, səəkə mbə zəzə kwəma ghwəy dza naa səəkəw, səəkə va *Safə tsa Hyala ɗewɗew tsa dza naa səəkə. ");
INSERT INTO bcw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ghala vəghwə tsa vay, ka nihwəti mbəzli dza na, ka nga ɗafa ta ngwarmbəghəshi, ta mbə məndiy bəkwəshi. Zhini tsəgha didihi dzaa məni lə ndərazhi shi kwərakwə ɓa. Ka ndərazhi dza na, ka zhini ghən kaa mbəzliy yakəshi diɓa ki, ka ɓəshi kaa nihwəti mbəzli ta bəkwəshi. ");
INSERT INTO bcw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mbəzli gwanashiy, ka dza ghəshiy ɗi mətsə ghwəy tə sa nəwra ghwəyəw. Ma ntsaa dzaa jihəkəvay kala zlay nəwra ghəci paꞌ tə vici məti ciy, ta mbəliti tsava ndə dza Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Zhini ma kə Yesəw ɓa na: «Ta nashi shi rəɗa rəɗa ni va jikirkir ni dza ghwəy garəshi tə pətsaa niy təɓə ma ghəshiy garə, (ntsaa jangəti kwəma vay, favə tə ghəci wəzə), ghalaɓa kiy, mbəzli tə hiɗi ka Zhəwde na, hwəshi tə ghəshiy dzəmbə kəlaŋ ta mbəə mbəlishi. ");
INSERT INTO bcw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mbaꞌa kə ndə mə jəba mbə tifərəy, əntaa ghəci dzaa ni na: “Kadiw, e dzəghwaraa dzəmbə ciki tsee, ta ɓəvə ya nimaɓa shiy” kə ma. ");
INSERT INTO bcw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya kwamti dza ndəə nza mbə zay, əntaa ghəci dzaa ni: “Kadiw e zhəghəvaa jighi ta ɓəvə kwəbeŋeree” kə ma. Ə kə dzaa hwəy gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngəraꞌwə tərəŋw dza savaa nza fəcava kən miꞌi lə hwər, lə miꞌi ka ndərazhi tə hwəm. ");
INSERT INTO bcw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cəꞌwə pə ghwəy cəꞌwə va Hyala, əntaa bali va taa mənivə geꞌi geꞌi lə tir tasli. ");
INSERT INTO bcw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Va sa dza naa nza fəcavay, ngəraꞌwə tərəŋwəy dza naa nza tə hiɗi. Gəla hwəlfə ngəraꞌwə tsa səəkə ma məndiy favə gaka ci ghala ghava hiɗi lə ghala ngati Hyala shiy gwaꞌa, ka sar paꞌ tə vəghwə tsa ndatsə. Ka dza naa zhiniy səəkə kən mbəzli diɓa ka məndi nzaw. ");
INSERT INTO bcw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kala sa nzana, mbaꞌa Ndə sləkəpə Hyala tamti ɗaŋ tsa vici ngəraꞌwə tsa vay, ka dza ndəə tərmbə tə ghwəməy nzaw. Ma dza na ki na, mbaꞌa tamti ɗaŋ tsa vici va tə mbərkə mbəzli nzə təravə na. ");
INSERT INTO bcw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ma sa ka vəghwə tsa va məniyəy, mbaꞌa kə ndə taa ni ngəŋwəy: “A mbəzli ni, anay *Kəristəw Ntsa tivə Hyala tikə” kə, ya “avaci tarɓa” nə nay, əntaa ghwəy zləɓa kwəma ci va tepə ma. ");
INSERT INTO bcw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sa dza naa nza ghala vəghwə tsa vay, ɗaŋ dza Kəristəwhi ka dzərvə lə ka gəzə kwəma Hyala ka dzərvəə tsahwəshi tə hiɗi. Ka ghəshi dza na, ka məni shi maɗaŋa maɗaŋa ni, lə shi dimədimə ni, ta mbəə ngəɗi mbəzli təravə Hyala, ghəshi gar dzaa mbay. ");
INSERT INTO bcw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Əy ma ki, avee gəzamtəŋwəy kwəma va nee ki kwaghwətsata gwaꞌa gwaꞌa, nza ghwəy mbəə məni məhərli wəzə!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ma kə Yesəw diɓa na: «Ghala vəghwə tsa va ki, ləy hwəm ngəraꞌwə tsa vay, shərkwə dza viciy shərkwəta, ka tir dza na, mbaꞌa zlay mbərə. ");
INSERT INTO bcw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ka sasərkwəhi tə ghwəmə dza na, ka shikəvaa səkwa, ka shi nza bərci və shi mə ghwəmə dza na, ka kwəfəghə. ");
INSERT INTO bcw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ghalaɓa kiy, nza Zəghwə yakə ndə ngəri tsahwə, ka nay mbəzli lə mətsə shi səəkə mbə kwəleɓi tə ghwəmə lə bərci və tərəŋw, tsəgha shəndəkə diɓa. ");
INSERT INTO bcw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sa ka na dzay mbaꞌa ghwənashi ka kwal Hyala ta dza ta ɓasanci mbəzli ci tərati na, tə bəla hiɗi faɗanashi, səəkə tə pətsa kəray ghala hiɗi gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ma kə Yesəw diɓa na «Avee taa ɓəliŋwəy fir lə kwəma daskway, favə tə ghwəy shi ɗi na ɓəniŋwəy. A ghwəy sənay, mbaꞌa kə kəslifi daskwa shikəshi, dza na mbaꞌa ɗakə nihwətiy, a vəghwə tsaa dzəmti kətikəvay, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ava tsəgha na ki, nashi ma ghwəy gəla shi ɓəlakəŋwəy ya va ghati mənivay, sənay tə ghwəy ndal tərmbə Zəghwə yakə ndə ngəri ta səəkəw, miy dəgha na ki, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ka dza mbəzli mbə vəghwə tsa ndatsə tsaa bəkwəshi ka shi gəzaŋwəy ya ni gwanashi mənivaw. ");
INSERT INTO bcw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nay ghwəy na, kar ghwəmə nata ghwəy na ghəshi lə hiɗi gwaꞌay, kərəp dza ghəshiy zashi. Ma na kwəmee na nanzə kiy, ka kərə naw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ma kə Yesəw diɓa na: «Ndə tiɓa ya kwətiŋ, mbaꞌa sənata vici dza shi vaa məniva tiw. Ya ka kwal Hyala, ya Zəghwə Hyala dəꞌwə ghən tsa ciy, ndə tiɓaa sənataw. War Didi Hyala mə ghwəmə kwətita na saa sənata vici va lə ler va gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ə pə ghwəy məni məhərli tərəŋw, ka ndəghə vici va kala ɓə ma hi. Sa nzana, kala sənay ma vəghwə tsa dza na vaa səəkə ti ghwəy. ");
INSERT INTO bcw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ma kwəma vay, njasa ka ndə vaa məni ghəciy dzay ta wə dza naa nza. Mbaꞌa zlay ghi tsa ci, bəm fanambə mbə dəvə ka sləni ci nza ghəshi nighəə dzəkən. Ka na dza na, mbaꞌa tahanavəshi sləni kəyɓa, mbaꞌa gəzanci kaa ntsaa nzəy miy dəgha, a ghəci fə ghən tə ndəghwə ghi tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ghwəy kwərakwə kiy, ə pə ghwəy fə ghən ta ndəghə vici va. Sa nzanay, sənata vici dza ndə ghi tsa vaa zhəghəvaa səəkə ti ghwəy, nda hetihwər ka na səəkə, nda mbə daŋkala vərɗi, nda tə kwa taŋa wa ngələkə, nda mekəshi, sənay ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ya ə dza naa səəkə vətəghəy, ka na səəkə na mbaꞌa kəsaŋwəy ləməciŋwəy. ");
INSERT INTO bcw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kwəma gəzaŋwəy ya nay, ghənzə na sa gəzee kaa mbəzli gwanashi, ə pə ghwəy fə ghən» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tərəmbə vici bakə, məndi dzaa maɗi ta *makwaghwa Pakə ki. Mbə makwaghwa vay, kar məndiy zəmə peŋ tsa nza *is mbəw. Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə *ka ɓənipə kwəma pəhəti Hyala, mbaꞌa ghəshi maɗishi ta pəla kwal tsaa kəsə Yesəw nja dzar kwa tsəhwəli, ta dza ghəshiy paslamti. ");
INSERT INTO bcw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma kə ghəshi na: «Nanzə kiy, əntaa ghwəmmə dzaa kəsə fəca vici makwaghwa Pakə ma. Vantaa mbəzli dzaa pəslishi tə ghwəmmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ghala vəghwə tsa va kiy, mbə məlmə Betani niy nza Yesəw mbə zəmə shiy kəghi tsa tsahwəti ndə, Shimaŋw, kə məndi slən tsa ci. Ntsa vay ndə dərna niy nza na kwataŋa. Dza nahwəti mali mbaꞌa səəkəta lə təlimə paf ꞌwərdi kwa, «*Nardə» kə məndi kaa ꞌwərdi va, gəna ɗaŋ məndiy pa. Dza na mbaꞌa ɓəlamti təlimə ꞌwərdi va, mbaꞌa shəkambə mbə ghən tsa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dza nihwəti mbəzli tiɓa, kala ɗi ma kwəma mənti mali va va ghəshi, war ə ghəshiy gəzə kwəma kwa jipə shi, a kə ghəshi na: «A ni mənti mali na ni shiy kia? Tawa gwəravə naa laɗamti ꞌwərdi na gəmta kia? ");
INSERT INTO bcw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A shiy ti məndi ɗəlamti ꞌwərdi vaa kwəmavə gəna gar mbəl bələkwə mahkan, mbaꞌa məndi tahanavəshi gəna va kaa ka ndərma nzaa» kə ghəshi, ka ngwəzliməə dzəkən mali va tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma kə Yesəw ngəshi na: «A mbəzli ni, zlatam mali va! Ka sə məhərli nzə ghwəy ma! Kwəma wəzə na na sa məni na va tə ya. ");
INSERT INTO bcw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sa nzanay, ka ndərma gəzə ghwəy va na tiɓa dza ghwəy nza li shi ya hwəmɓa, gar dza ghwəy mbay mananatishi kwəma wəzə na ya hwəmɓa ɗi ghwəy. Ma na nee kiy, ka dza ghwəmməə nza lə ghwəy tikə ndimndim kiw. ");
INSERT INTO bcw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nanzə kwəma dza naa nza gar mənti fəca dza məndiy lara na sa manamti na va, ɓaslakənra na ꞌwərdi ghala vici va ghwəlaa səəkə. ");
INSERT INTO bcw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya war paꞌ kwəmaɓa dza məndiy gəzə Yəwən kwəma wəzə na kaa mbəzli tə hiɗi gwaꞌa gwaꞌay, ta gəzə kwəma mənti na va dza məndi, ka zəzəə dzəkən mali va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dzəghwa Zhəwdasə Isəkariyətə, tsahwəti ndə mbə *mbəzli ta səɗa Yesəw va məŋ lə bakə ni, mbaꞌa dzaa gəzanshi kaa mbəzli dikə dikə ni mbə *ka ta Hyala: «Ta ngatəŋwəy ɗafa dzee ta Yesəw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma sa favə ghəshi tsəgha na, mbaꞌa ghəshi vəshishi. Mbaꞌa ghəshi gəzanci njasa dza ghəshiy nganci səɗa ci. Ava ghala vəghwə tsa va gha Zhəwdasəə pəla kwal tsaa nga ɗafa ta kəsə Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dzəghwa kwa taŋa vici ka məndiy zəmə peŋ tsa kama is mbə, mbaꞌa səəkəta. Vici vay, fəcava ka məndiy həəni gemim jəw jəw ni ta makwaghwa Pakə. Ma fəcava ki na, dza *mbəzli ta səɗa Yesəw ka ɗəw kwəma və, a kə ghəshi na: «A Metər, kwəma ɗi gha ghəy dza ta tatəŋa shi zəmə dza ghaa zəmə mbə makwaghwa Pakəa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dza Yesəw ki mbaꞌa ghwənashi mbəzli bakə mbə shi, a kə ngəshi na: «Mbalam dzəmbə məlmə. War tsəhəŋwəy ma ghwəyəy, ta kwəmay dza ghwəy lə ndə, lə tsaghwa yam və. Nza ghwəy nəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dzakə ghi tsa dza naa dzay, nza ghwəy gəzanci kaa ndə ghi tsa va, a pə ghwəy taa niy: “Ma kə Metərəy, ndara ciki tsa dza ghəy səəkə ta zəmə shiy lə mbəzli ta səɗee mbə, mbə Pakə, kə” pə ghwəy taa ni. ");
INSERT INTO bcw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Gəzanakə ma ghwəy tsəghay, ta citəŋwəy ciki dza na dikə, mə ghən tsahwəti ciki, cəkeꞌ məndi gwəmanti, mbaꞌa shiy nzəy mbəɓa. Ava mbəɓa ka ghwəy dzaa tatəmmə shi dza ghwəmməə zəmə mbə Pakə ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dza mbəzli ta səɗa ci va bakə ni mbaꞌa ghəshi maɗishi, ka dzaa dzəmbə məlmə ki. Ma dzəmbə ghəshi na, mbaꞌa ghəshi kəsashi shi va gwanashi njasa gəzanakəshi Yesəw va. Mbaꞌa ghəshi tati shi zəmə dza ghəshiy zəmə mbə Pakə. ");
INSERT INTO bcw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma sa pəkwəta vici ki na, mbaꞌa kar Yesəw səəkəshi, ghəshi lə mbəzli ta səɗa ci va məŋ lə bakə ni. ");
INSERT INTO bcw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma kə Yesəw kaa ngəshi, ghəshi mbə zəmə shiy na: «Nay ghwəy na, a gəzaŋwəy ya, ta na navay, tsəgha na, a tsahwəti ndə mbə ghwəy kwətiŋ, ntsa zəmə ghəy shiy liy, ta nga ɗafa dza na tə ya, ta kəsəra məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dza kwəma va ka zhanshi kaa mbəzli ta səɗa ci tərəŋw tərəŋw. Gaꞌ ghəshi ta ɗəɗəw kwəma və, a kə ghəshi na: «Yən na nanzə ɓa naa Ndə sləkəpə? Yən na ɓa na? Yən na ɓa na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma kə Yesəw ngəshi na: «Waa ndə tə ghwəy, ghwəy mbəzli ta səɗee va məŋ lə bakə ni na, ntsa zəmə ghəy shiy li kwa kwakwa tsa kwətiŋ tsa. ");
INSERT INTO bcw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na nee yən Zəghwə yakə ndə ngəriy, ta mətira dzee njasa tsasliti məndi vaa dzəkənee mbə Zliya Hyala. Ma nanzə kiy, tərəŋw dza ngəraꞌwəə nza kən ndə nga ɗafa tə ya tsa va. Wəzəɓaa niy maw ma məndiy yakə dza naa nza və» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma ghəshi mbə zəmə shi zəmə va ki na, dza Yesəw həŋ ɓəvə peŋ, mbaꞌa mananati ꞌwəsa kaa Hyala. Sa mananati na ꞌwəsa na, dza na mbaꞌa ngangavəri peŋ tsa vaa ɓanavəshi. Ma kə ngəshi na: «Vəghee na sana, ɓəm zəməm!» kə ");
INSERT INTO bcw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma ləy hwəm na, dza na həŋ ɓəvə hwəpər tsa nza shi sa kwa, kə mbaꞌa mananati ꞌwəsa kaa Hyala. Sa mananati na ꞌwəsa na, dza na həŋ ɓanavəshi. Dzəghwa mbəzli va gwanashi mbaꞌa ghəshi sasahwə shi sa va. ");
INSERT INTO bcw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma kə Yesəw kaa ngəshi ki na: «Miymiy ya na shi ni, li shi sla Hyala kiri kwa jipə nzə lə mbəzli, ta shəkəshi dza ghəshi ta mbəzli ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ka dzee zhiniy sahwə shi sa ni, kala war fəca vici dzee zhiniy sashi tə pətsa sləkə Hyalaw» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dza ghəshi ka ha cemer, ka fal Hyala. Ləy hwəm ki na, mbaꞌa ghəshi səvərishi ka dzashiy dzəmə kəlaŋ *ꞌWəlivə. ");
INSERT INTO bcw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma kə Yesəw kaa *mbəzli ta səɗa ci na: «Nay ghwəy na, ta zlara dza ghwəy kwətiraa hwəŋwəy gwanaŋwəy. Sa nzanay, a Hyala gəzəkə mbə Zliya nzə, a kəy: “Ta paslamti ndə ndəghwə shiy dzee, ka teŋkesli ci dzay, mbaꞌa ghəshi zləzləŋərəshi ka dza kwaɓa, ka dza kwaɓa” kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ləy hwəm sa kee zhakatira mbə məti kiy, ta ꞌwatəŋwəy kwal dzee dzaa dzəti hiɗi ka Galile, ma nza ghwəy kəsara mbəɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma kə Piyer ki na: «A Ndə sləkəpə, na nee, ya mbəzli gwanashi dza naa zlaŋay, ka dzee zlaŋa na neyew» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma kə Yesəw ngəci na: «A Piyer, ə gəzaŋee, ta na navay, mbə vərɗi ndatsə na, ka ngələkə gha wa kwa bakay, gha zhənti gəzə mahkan səɗa gha: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dzəghwa ma kə Piyer lə bərci na: «Ya ta məti dzee kwasəbə ghay, ka dzee gəzə, sənaŋa yaw, pən tepəw» kə. Tsəgha nihwəti niy tərmbə va gəzəkə gwanashi kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dzəghwa kar Yesəw lə mbəzli ta səɗa ci mbaꞌa ghəshi tsəhəshi, tə pətsa nə məndi va Getəsemane, kə məndi. Ma kə Yesəw kaa mbəzli ta səɗa ci tiɓa na: «Nzəyŋwəyəm tikə, e dza ta cəꞌwə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dza na kaa kar Piyer, ghəshi lə Zhakə, mbaꞌa Zhaŋ, pəm pəməvəshi kwasəbə ci. Dzəghwa her ci mbaꞌa ghəshi ghati dza, mbaꞌa nəfə tsa ci slay. ");
INSERT INTO bcw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma kə kaa ngəshi na: «Tərəŋw slay nəfə tsee ka ɗi pəəslira. Nzəyŋwəyəm tikə, əntaa ghwəy ɓə hi ma!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dza na mbaꞌa kətivə dza bəlakə jəw. Kə tsəfəkwə tsəfəkwəy tə hiɗi ka cəꞌwə Hyala, a ngəraꞌwə tsa dza na va ta sa bashamti səəkəə dzəkən tə nava vici, ghənzə gar mənta. ");
INSERT INTO bcw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma kə mbə cəꞌwə ci va na: «A Di, gha kiy Didiy, nihwəti shiy tiɓa kala mbay ghaa məntiw! Va tsəgha cəꞌwəŋee, bashamti ngəraꞌwə tsa va səəkəə dzəkənee. Nanzə kiy, əntaa gha məni war tə sa ɗee ma, war njasa təɓaŋa na ka gha məni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dza na tərəɗ zhəghəkəvay dzəvəgha mbəzli ta səɗa ci va mahkan ni. Səəkə na na, ghəshi ɓanti hi. Ma kə kaa Piyer ki na: «A Shimaŋw Piyer, wa hiy hi gha na? A shiy mənishi mbə ma ghaa nzaynza ləməciŋa ya ta tsahi kwətiŋ nzəa? ");
INSERT INTO bcw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ə pə ghwəy nzəyŋwəy ləməciŋwəy, ka cəꞌwə Hyala ta mbə ghənzəə ndəghwəŋwəy, vantaa *ndə jaka tsa nzə ngaɗambəŋwəy mbə məni *kwəma jikir na. Ka ɗi məni kwəma wəzə na ndə ngəri kwa kwəma Hyala mbə nəfə tsa ci ngar ki na, daw bərci vəgha ci ta məni nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zhini na mbaꞌa katantəvay vəgha shi diɓa, mbaꞌa zhaa cəꞌwəti Hyala war njasa kwa taŋa va. ");
INSERT INTO bcw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma sa kəɗiy na lə cəꞌwə Hyala na, mbaꞌa zhikəy zhəvəgha shi. Zhəkə na ɓa na, ghəshi tə hi, shaŋ ghəshi ta mbay nzəyshi ləməcishi. Kala sənata kwəma ka ghəshi zləɓanci ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Zhini na ndəs zhəkəy dzəvəgha shi kwa mahkan səɗa diɓa ki. A kə kaa ngəshi na: «A mbəzli ni, him hi tsa ghwəy, ka dəkə vəgha ghwəy na ghwəy. Gwaꞌaa kwəma, a vəghwə məniy. Ava məndi dzaa kəsəraa dzəmbə dividivi ka məni kwəma jikir na, yən Zəghwə yakə ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ava ghwəy nay ntsaa ngati ɗafa va tə ya səəkəy, satim a ghwəmmə dzaa dzəvəgha!» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","War ghwəla tsəgha ki, Yesəw mbə kərni gəzə kwəma vaa səkwa na, ndəs Zhəwdasə, tsahwəti ntsa mbə mbəzli ta səɗa ci va məŋ lə bakə ni tsahwəy. Mbaꞌa mbəzli ɗaŋ kwasəbə, lə kafaꞌihi nihwəti, lə ghədemesli nihwəti. Mbəzli vay, mbəzli dikə dikə ni mbə *ka ta Hyala, lə *mbəzliy ɓənipə kwəma pəhəti Hyala, lə mətikwəkwər mbə *ka Zhəwifə niy ghwənashi na ta kəsə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma kə Zhəwdasə tsaa ngati ɗafa va ta Yesəw niy ni kaa mbəzli va ghəshi dzaa kafə ki na: «Sa ka ghwəmmə tsəhəmməy, ntsa dza ghwəy vaa nara mbə səkwə njasa ka ndəə səkwə madigayəy, ghəci na. Nza ghwəy kəsə, ka ndəghwə wəzə va mbəliy ki» kə niy ni ngəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dza Zhəwdasə war sa tsəhəy na tsəgha ki, karə dzay dzəvəgha Yesəw, a kə ngəci na: «A Metər» kə, mbaꞌa səkwəti njasa ka ndə vaa səkwə madigay. ");
INSERT INTO bcw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gwaꞌa, kahə mbəzli va sənay Yesəw tsəgha ki, ɓasə ghəshi ɓasakənvashi kən, tasl ghəshi kəsəti. ");
INSERT INTO bcw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ꞌWakəvə tsahwəti ndə tiɓa mbə mbəzliy nza lə Yesəw, fat təɗikəvəri kafaꞌi tsa ci, dza na pətsə kəsləkəghwa sləmə vəgha ghən ndə ghəra sləni kaa dikə tsa *ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma kə Yesəw kaa vərəm mbəzliy ɓasəkəvashi va tsəgha ni na: «A mbəzli ni, tawa səəkə ghwəy ta kəsəra lə kafaꞌi mbaꞌa ghədemesli njasa nzee ndə ghəli kia? ");
INSERT INTO bcw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Vici va vici va ghwəmmə niy nza lə ghwəy mbə *ciki Hyala, ka ɓəni shiyee kaa mbəzli, kalaa niy kəsəra ghwəy ghalaɓa nanzə sa? Ma kwəma nata ghwəy na məntay, ta mbə kwəmaa niy tsaslitim va mbə Zliya Hyalaa dzəghwata kwa na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dzəghwa *mbəzli ta səɗa Yesəw gwanashi kwərec ghəshi hwəshi, mbaꞌa ghəshi zlay Yesəw tiɓa ki. ");
INSERT INTO bcw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dza tsahwəti məgəla kwətiŋ, ka nəw kar mbəzli va lə Yesəw tə səəbə tə səəbə. War gwədəwri sa kən ghən ci gwaꞌa tsəgha zlaɓə zlaɓə. Dza məndi ka ɗi kəsə. ");
INSERT INTO bcw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sa nə məndi, a məndi kəsə, kə məndi na, dza na mbaꞌa pəlatanavəshi gwədəwri tsa va tsəgha kaa mbəli va, ka hwəy dirəŋəy. ");
INSERT INTO bcw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dzəghwa mbəzli va mbaꞌa ghəshi pəmanaghə Yesəw kaa dikə tsa *ka ta Hyala ki. Ghala pətsa va na, dza mbəzli dikə dikə ni mbə ka ta Hyala, lə mətikwəkwər ka Zhəwifə, mbaꞌa *mbəzliy ɓənipə kwəma pəhəti Hyala ka ɓasəvaa səəkəə dzakə ghi tsa va. ");
INSERT INTO bcw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Dza Piyer, ka nəwshi kərakə kərakə, paꞌ kəghi tsa dikə tsa ka ta Hyala tsa va. Dzakə na das nzəyəy vəgha gwəlaa ndəghwə ghi tsa ntsa va, ka bəghəzli ghwə kwasəbə shi. ");
INSERT INTO bcw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dza mbəzli dikə dikə ni mbə ka ta Hyala ghəshi lə *mbəzliy sləka ka Zhəwifə gwanashi, tapə dzəmbəshi mbə pala kwəma dza ghəshiy ɓanavə fəti ti kaa Yesəw ta mbə ghəshiy paslamti. Shaŋ ghəshi ta kwəmavə kwəma ka ghəshi ɓanavə fəti ti kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mbəzli ɗaŋ tərəŋw səəkəshi, ka təɓanci dzərvə kaa Yesəw na, kala jakəshi kwemer shi va gəzə ghəshiy dzəkən, gar nə məndi: «Tsəgha na kataŋ» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dza nihwəti mbəzli mbaꞌa ghəshi satishi ta təɓanci na shi kwəma dzərvə, ma kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Wa ma kə niy ni mbə kwəma ciy: “Yənəy, ta ngəzlamti *ciki Hyala tsa ngati ndə ngəri tsa lə dəvə ci dzee. Ma mbə vici mahkanəy, mbaꞌee zhiniy ngakati, kala səəkə dəvə ndə mbə” kə niy ni» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ya tsəgha təɓanaghə ghəshi dzərvə tsəgha na va kaa Yesəw ki na, dzatəvata kwa kwal tsa kwətiŋ tsaw. ");
INSERT INTO bcw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ꞌWakəvə dikə tsa ka ta Hyala tsa va tsəgha fakatsaꞌwə satiy, gar garəy mbə mbəzli tiɓa va. A kə kaa Yesəw na: «Na ntsa, a shiy mənishi zləɓa ma gha kwemer gəəzə məndi niy dzəkən gha shəka?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dzəghwa Yesəw dighevə catavay, kala maw zləɓa kwəma ya jəw nzə. Zhini dikə tsa ka ta Hyala tsa va, ka zhiniy ɗəw kwəma və, a kə ngəci na: «Gha na *Kəristəw Ntsa tivə Hyala, Zəghwə Hyala ka məndi vaa fal na pən?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma kə Yesəw ngəci na: «Yə, yən na! Ghwəy gwanaŋwəy sanay, tə dəvə kwa bəzəmə Hyala kwa bərciy sləkə shiy gwanashi dza ghwəy nara mənzəy, yən Zəghwə yakə ndə ngəri. Zhini diɓay, ta nara dza ghwəy yən mbə səəkə mbə kwəleɓi mə ghwəmə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma sa favə dikə tsa ka ta Hyala tsəgha na, dza na kaa kwəbaŋ tsa kən ghən ci, kwəyah kwəyah slakwanti, sa satiy nəfə tsa ci. A kə na: «Wəkə na nava tsəgha, ka ɗi mbəzli ghwəmmə ta ndəgha fəti ta kwəma mənti na ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A ghwəy favə njasa sawa na Hyala dəꞌwə ghən tsa ghwəy. Njaa na kwəma təkə ghwəya?» kə. Ma kə ghəshi gwanashi ki na: «Aa gəzəkə *kwəma jikir na, gar pəəsli na!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dzəghwa nihwəti mbəzli mbə shi mbaꞌa ghəshi maɗishi, ka tifə ndighwər dzəkən Yesəw. Ka ghəshiy dza mbəkwə mbəkwəti kwəma ci na, ka ghəəni dəvəə ndəkwə li, ma kə ghəshiy ni ngəci sa ka ghəshi ndəkwamti na: «Ca a Hyala cətəŋa, a gha gəzaŋəy, nda tsama ndə ndəkwəŋa na?» kə ghəshiy ni. Dza dəwgerhi pəm ghəshi pəməvə Yesəw, war ka tsatsanci dividivi dzəghwa slimim ci. ");
INSERT INTO bcw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ma Piyer war ghwəlay kwa tipə kəghi tsa va ki na, dzəghwa mali kwa ghəra sləni kəghi tsa dikə tsa *ka ta Hyala ndəs səəkəta. ");
INSERT INTO bcw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma sa səəkə na, tsaꞌ kə na, Piyer ta ghwə tiɓa mbə bəghəzli, dza na vərəghə vərəghəti. A kə kaa Piyer na: «A ntsa, ghay ntsa kwasəbə Yesəw ndə ka Nazaretə nza gha kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tapə Piyer dzəmbəy mbə vəraslə, a ka na: «Am, sənay ya na neyew, sənata gəla kwəma ɗi gha na gəzee sana nee kiw» kə. Dza na mbaꞌa ɓarvay tiɓa kwa tipə va ka dzay dzəmbə jəwler. ꞌWakəvə kwa taŋa ngələkə mbaꞌa way ki. ");
INSERT INTO bcw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zhini maliy ghəra sləni va kəyɓa mbaꞌa nay ghəci mbə jəwler tsa va diɓa, ma kə kaa mbəzli mbəɓa war sa nay na na: «A mbəzlia, ntsay, tsahwəti ntsa mbəzli va na» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Zhini Piyer ka vəraslə diɓa. War ghwəla na, dza mbəzliy nza va tiɓa ka gəzanci kwəma kaa Piyer, a kə ghəshi na: «A ntsa, na kataŋ nay, tsahwəti ntsa mbə mbəzli ntsa ni nza gha. Sa nzana, ghay, ndə ka Galile nza gha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dzəghwa Piyer tapə ta zəmə lə fəlata ki, a kə na: «Tiɓa tepəw, tsamtəra Hyala yən kəə sla dzərvə! Sənay ntsa gəzə ghwəy vee, ya səni səni na neyew!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ꞌWakəvə ngələkə kwa bakə səɗa ki, mbaꞌa zhiniy way. Dza Piyer nzaꞌjəw zəzəvə kwəmaa niy gəzanakə Yesəw va. Sa niy nə na va: «Ka ngələkə gha wa kwa bakə səɗay, gha zhənti gəzə mahkan səɗa gha: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha» kə niy ni ngəci. Mbaꞌa səəkəta mbə ghən ci. Dzəghwa ki tapə dzəmbəy mbə wahə tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pəətə mekəshi na, mbaꞌa mbəzli dikə dikə ni mbə *ka ta Hyala ghati sləka kwəmaa dzəkən Yesəw kwa jipə shi, lə mətikwəkwər *ka Zhəwifə, lə *ka ɓənipə kwəma pəhəti Hyala, mbaꞌa *mbəzliy sləka ka Zhəwifə. Dza pəhə ghəshi pəhəti Yesəw, mbaꞌa ghəshi pəməghə kaa ngwəmna Pilatə ta ɓasə ngwəvəə dzəkən. ");
INSERT INTO bcw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dza Pilatə ki, tapə ta ɗəw kwəma va Yesəw, a kə na: «Mazə tsa ka Zhəwifə nza gha na ntsa?» kə. Ma kə Yesəw ngəci na: «Njasa gəzə gha va na» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dzəghwa mbəzli dikə dikə ni mbə ka ta Hyala ka gəəzə kwemer ɗaŋ dzəkən Yesəw, ta mbəə ɓanci fəti. ");
INSERT INTO bcw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Zhini Pilatə ka ɗəw kwəma va Yesəw diɓa: «A ntsa, ka zləɓa kwəma gha sa? Favə gha njasa gəzəkə ghəshi kwəmaa ɓəŋa fəti ɗaŋ tsa nzə sa?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dighevə Yesəw nzəyəy kala zləɓa kwəma diɓa. Dza nava kwəma, mbaꞌa səəvəri məhərli Pilatə. ");
INSERT INTO bcw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Njasa səəkə vici *makwaghwa Pakə vay, tsəgha ka ngwəmna Pilatəə pəlanayshi tsa ɗi *ka Zhəwifə ndə kwətiŋ mbə mbəzli kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dzəghwa ghala pətsa va ki na, mbaꞌa ntsa nə məndi Barabasə, kə məndi slən tsa ci kwa fərshina. Ghəshi lə nihwəti mbəzli ka zhini ghən, pəkw ka pəəsliti ndə ghəshi mbə zhini ghən tsa shi va. ");
INSERT INTO bcw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dza vərəm tsa mbəzli va tsəgha, takwəs ghəshi maɗishi ta ɗəw va ngwəmna Pilatə a ghəci məni kwəma sənaɓəy na va mbə mananshi ndimndim. ");
INSERT INTO bcw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma kə Pilatə ngəshi na: «Wa ntsa ɗi ghwəy yən pəlayŋwəya? E pəlavəŋwəy mazə ka Zhəwifə na?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tawa gəzə ngwəmna tsəghay, sa sənay na lə kataŋ, sa hərhə mbəzli dikə dikə ni mbə *ka ta Hyala va Yesəw, va tsəgha kəsanaghə ghəshi, kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dza mbəzli dikə dikə ni mbə ka ta Hyala va, tapə dzəmbəshi mbə həərə ni tiɓa mbəzli, nza ghəshi mbəə ɗəw va Pilatə, a ghəci pəlanayshi Barabasə. Dza mbəzli va ka ɗəw tsəgha. ");
INSERT INTO bcw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Zhini ma kə Pilatə kaa mbəzli tiɓa va gwanashi na: «Ya tsa nə ghwəy tsa ndə mazə tsa ka Zhəwifə na, pə ghwəy naci kiy, njaa kee mənti lia?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma kə ghəshi gwanashi zlaŋzlaŋ na: «Na naciy, ə pə gha daŋwavəgha vəgha tsəm!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma kə Pilatə kaa ngəshi na: «Əy, wa kwəma təvəti na gar daŋwə məndiy dzəvəgha tsəm shəka?» kə. Zhini ghəshi mətsəhə ghəshi mətsəhəti zlaŋə kwəma diɓa: «War ə pə gha daŋwavəgha vəgha tsəm!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dzəghwa Pilatə, sa ɗi na nəw məni naa dzaa təɓanshi kwəma kaa mbəzliy ɓasəshi va tiɓa ki, mbaꞌa pəlanayshi Barabasə. Dza na mbaꞌa gəzanshi kaa ka sawji a ghəshi dəꞌwəvə Yesəw lə kwərpə, nza ghəshi dzaa daŋwavəgha vəgha tsəm ki. ");
INSERT INTO bcw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dza ka sawji ki mbaꞌa ghəshi pəməghə Yesəw dzakə ghi dzəghwa hwər tipə, tə pi sla ngwəvə tsa ngwəmna Pilatə. Mbaꞌa ghəshi dzaa ɓasəkə nihwəti ka sawjiy tərmbə gwaꞌaa dzakə. ");
INSERT INTO bcw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dzəghwa ghəshi ki, mbaꞌa ghəshi panakən ləkwəsa ghəmta nja sa mazə kaa Yesəw. Mbaꞌa ghəshi mbərəti tekesli nja məgapa pəərə ghən mazə, sərə ghəshi səranambəshi mbə ghən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dza ghəshi ka səkwə kwa kwəma sawa ki: «A mazə *ka Zhəwifə, ava ghəy səkwətəŋa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dza ghəshi ka dəꞌwə dzəghwa mbə ghən ci lə gəta, ka tifə ndighwər dzəkən, ka gələɓə kwa kwəma ci. ");
INSERT INTO bcw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma sa kəɗishi ghəshi lə sawa ci tsəgha ki na, mbaꞌa ghəshi səramti ləkwəsa ghəm na va kən, mbaꞌa ghəshi zhananakən kwəbeŋer ci. Dza ghəshi mbaꞌa ghəshi pəməkəvəri səvəri mbə məlməə dzəti ngwəla, ta dza ta daŋwəə dzəvəgha tsəm ki. ");
INSERT INTO bcw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma ka sawjiy pəmə Yesəw va mbə dza kwa kwal na, mbaꞌa tsahwəti ndə ka Shiren səəkəy kwamti tiɓa, Shimaŋw, kə məndi kaa slən tsa ci. Dəshi kar Alekəsandərə lə Rəfəsə. Dza ka sawji va mbaꞌa ghəshi tsəkwambə lə gwəlaŋ mbə ɓə tsəm tsa dza məndi va ta daŋwə Yesəw dzəvəgha. ");
INSERT INTO bcw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kə ghəshi ki, mbaꞌa ghəshi ɓəghə Yesəw dzəti pətsa nə məndi «Gwalgwata» kə məndi. Gwalgwata vay, pi nja pa ghən ndə ngəri, ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma sa tsəhəshi ghəshi na, dza ghəshi ka ɗi sanci tay dzavəɗə lə nihwəti shi har məndiy *Mirə kaa Yesəw. Kala zləɓa sa ci Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dza ghəshi ki daŋwə ghəshi daŋwavəgha vəgha tsəm. Mbaꞌa ghəshi tihəhwə kwəbeŋer kən ghən ci kwa jipə shi lə ti dandərɗə. ");
INSERT INTO bcw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ma vici ghala pətsa daŋwə məndi va Yesəw dzəti tsəm ki na, geꞌi lə tsahi məsliɗə. ");
INSERT INTO bcw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dza ghəshi mbaꞌa ghəshi tsasliti shi ɓanavə məndi fəti ti. Ma shi tsasliti ghəshi vay: «Mazə tsa *ka Zhəwifə» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dza ghəshi mbaꞌa ghəshi daŋwavəgha ka ghərapə bakə vəgha shəghwə kwasəbə Yesəw ki. Mbaꞌa ghəshi garəyshi, ya wa ndə na, tə tsa ci tsəm, mbaꞌa tsahwəti tar kwa bəzəmə ci, mbaꞌa tsahwəti tar kwa zleɓi ci.  ");
INSERT INTO bcw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kwəmaa niy gəzəkə məndi va mbə Zliya Hyala, niy nə məndi: «Ta mbərambə dza məndi mbə ka məni jikir» kə məndiy, mbaꞌa dzəghwata kwa tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dzəghwa mbəzliy dza dzashi dzar vəgha pətsa va ka sawa Yesəw, ka tsəərə. A kə ghəshi na: «Awə pə gha ɓay, gha saa niy ni va, e ngəzlamti *ciki Hyala, zhini ka ngakati mbə vici mahkanta, pə gha sa? ");
INSERT INTO bcw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ə ka gha mbəlanti ghən tsa gha dəꞌwə ghən tsa gha sana ɓay! Səkwaŋa tə tsəm tsa di!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zhini tsəgha mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *mbəzliy ɓənipə kwəma pəhəti Hyala gəzanci kwəma sawa kwa jipə shi diɓa, a kə ghəshi na: «Ma nihwəti mbəzli mbaꞌa ghəci mbalamtishi na, kala dza ghəci mbəə mbəlanti tsa ci ghən kwərakwə shəkəna! ");
INSERT INTO bcw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","*Kəristəw Ntsa tivə Hyala, mazə tsa ka *Izərayel gee kə ɓay, səkwa kə səkway tə tsəm tsa va sənzənva di! Ma sa ka ghwəmmə nay ghəci səkway kiy, ta ɓanavə nefer ghwəmmə dza ghwəmmə» kə ghəshi. Tsəgha mbəzli daŋwəy məndi va vəgha sawa kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma sa mənta vici tarə kwa ghən ki na, dzəghwa tərkwəsl pi məniy, ya paꞌ kwəmaɓa tə hiɗi gwaꞌa gwaꞌa, paꞌ tsahi mahkan hetihwer na war tsəgha pi. ");
INSERT INTO bcw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma geꞌi lə tsahi mahkan ni va ki na, dza Yesəw ka zlapə kwəma zlaŋzlaŋ, a kə na: «Eləwy Eləwy lama sabakətani?» kə. Ma ɗi kwəma vaa gəzəy «A Hyalee, a Hyalee, wa shiy mənishi ndəghamtəra gha kia?» ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma kə nihwəti mbəzli mbə mbəzliy nza tə pətsa va, sa favə ghəshi kwəma gəzə Yesəw va na: «Aya, avaci mbə haka *Eli» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dzəghwa tsahwəti ndə mbə shi bəvbəpə ta bali. Dza na tsaŋ ɓəvə shiy nja səwsə, kə yəkwə yəkwambəshi mbə tay tsa ndalakwə tsa, səəkə na mbaꞌa haslivəshi lə gəta, ka ɓanci, a ghəci sa. A kə na: «Zlayəm, a ghwəmmə nighə di, nda kataŋ dza Eli tsa vaa səəkəə pəlamti səkwa tə tsəm tsa va!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dzəghwa Yesəw mbaꞌa ngwəmata lala zlaŋzlaŋ, mbaꞌa mətiy. ");
INSERT INTO bcw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dzəghwa kwəmtə tsa pəhəy məndi ta təhəvəri pətsa mbə *ciki Hyala, mbaꞌa sləkwəy bakə mbə, sa ꞌwava na səəkə mə ghən tsa ci paꞌ kwakə tə mətsəni. ");
INSERT INTO bcw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma kə dikə tsa ka sawji bələkwə, sa nata na məti Yesəw va, ghəci tiɓa ki na: «Ma ntsa kataŋəy, Zəghwə Hyala na!» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma ghala pətsaa məti Yesəw va ki na, tiɓa niy nza nihwəti miꞌi ka nighə kwəma va vəri kərakə. Mbə miꞌi va kar Marəy ka Magədala, lə Marəy mbəghəy kar Zhakə tsa jəw tsa, lə Zhəzesə, mbaꞌa Saləməy niy nza. ");
INSERT INTO bcw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sa niy nəw ghəshi Yesəw ghala ghəci ghwəlay tə hiɗi ka Galile, ka kəəkəəti ghəshiy nza lə shiy ghənghən ghənghən. Ɗaŋ tərəŋw nihwəti miꞌi tiɓa diɓa, sa səsəəkəshi ghəshi kwasəbə Yesəw dzəmbə məlmə Zherəwzalem. ");
INSERT INTO bcw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma vici məti Yesəw va ti kiy, fəca vici ka məndiy gwəmava ta ndəghə *vici dəkəva tə həzlimə niy nza na. Ma sa məniy pi hetihwer na, ");
INSERT INTO bcw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","dza *Zhezhefə, ntsa mbə məlmə Arimate mbaꞌa səəkəy. Ghəciy, ntsa fa məndi kwəma və mbə mbəzliy sləka *ka Zhəwifə niy nza na. Mbə ndəghə vici dza Hyalaa səəkə ta sləkə mbəzli ti ghəci niy nza kwərakwə. Dza na kaa nəfə tsa ci, mbaꞌa ndahwə, mbaꞌa tsəhəy vəgha ngwəmna Pilatə ta cəꞌwə kwal tsaa dza ta ɓə mbəri tsa Yesəw ta dzaa ta lamti. ");
INSERT INTO bcw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","War sa favə Pilatə a Yesəw mətiy, kə məndi na, mbaꞌa məhərli ci səəta, sa mətiy Yesəw va kyaŋwkyaŋw. Dza na daꞌ harvə dikə tsa ka sawji bələkwə ka ɗəw və, a kə na: «A Yesəw mətiy kə məndiy, nzay nza na ghala mətiy na na?» kə. ");
INSERT INTO bcw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma sa gəzanci ndə sawji tsa va kwəma ɗəw na va və gwaꞌa kaa Pilatə ki na, mbaꞌa ɓanavə kwal kaa Zhezhefə ta ɓə mbəri tsa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dza Zhezhefə kaa bahta wəzə na, mbaꞌa pavə ta harə Yesəw mbə. Dza na mbaꞌa dzaa ɓəkəghwa mbəri tsa Yesəw səkwa vəgha tsəm tsa va, mbaꞌa dzaa harambə mbə. Mbaꞌa dzaa faghwa kwa kwəli lati məndi mbə hakwə. Dza na mbaꞌa tsəkwəkə hərambəzliy kalamiy miy kwəli va. ");
INSERT INTO bcw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kar Marəy ka Magədala ghəshi lə Marəy mbəghəy Zhwəzesə ki na, mbaꞌa ghəshi niy nay dzəghwa tə pətsa ləy məndi Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma sa dzəvərita *vici dəkəva ki na, dza kar Marəy ka Magədala, lə Marəy mbəghəy Zhakə, mbaꞌa Saləməy, paꞌ ghəshi pavə ꞌwərdi, ta dza ta məniy dzəti mbəri tsa Yesəw kwa kwəli va. ");
INSERT INTO bcw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dza ghəshi fəca ləwma Dəmasə mekəshi, pəətə ghəshi maɗishi, dza ndəs ghəshi tsəhəshi tə kwəli viciy səəmə. ");
INSERT INTO bcw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma kə ghəshi kwa jipə shi sa tsəhəshi ghəshi na: «A ntsaa dzaa tsəkwantəmmə hərambəzli məy kwəli va va nanzə kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Va sa nzana, hərambəzli dikə sa va tərəŋw gəzə ghəshi tsəgha. Sa nə ghəshi njəꞌwə, kə ghəshi kaa pətsa məy kwəli na, bəŋwəta kwəli, mbaꞌa hərambəzli tsarakə dzar kwa tsa nzə pi. ");
INSERT INTO bcw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dza ghəshi təhwə dzəmbəshi mbə kwəli va. Ma dzəmbə ghəshi na, tsahwəti məgəla ndə mənzəy mbəɓa, geꞌi tar bəla kwa bəzəmə kwəli va, lə kwəbaŋ tsa tezlezl tsa kən ghən ci. Mbaꞌa miꞌi va hazlənishi dalala. ");
INSERT INTO bcw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma kə kaa miꞌi va na: «A miꞌi, ka hazləni ghwəy ma! E sənay Yesəw ndə ka Nazaretə tsa daŋwavəgha məndi va vəgha tsəm na sa pala ghwəy. Ghəci tikə kwa kwəli naw. Aa zhakatiy mbə məti. Vanay pətsaa niy fəy məndi ti. ");
INSERT INTO bcw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maɗim gəzanshim bar tsa kwəma va kaa mbəzli ta səɗa ci, lə kaa Piyer gwaꞌa. A pə ghwəy ngəshiy: “Pərɓa ghəci dza naa ꞌwaa tsəhəy kən ghwəy tə hiɗi ka Galile. Tiɓa dza ghwəy dzaa nay, nja kwəmaa niy gəzaŋwəy na va” pə ghwəy ngəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ꞌWakəvə miꞌi va mbaꞌa ghəshi səəməshi kwa kwəli va, kwəshaꞌ ghəshi ta bali, ka hwəshiy dzashi kərakə vəgha kwəli va, kala gwərgwərə, sa səəta məhərli shi. Dza ghəshi kala maw gəzə kwəma va ya kaa tsamaɓa ndə va hazləni.  ");
INSERT INTO bcw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ma sa zhakatiy Yesəw mbə məti mekəshi mekəshi fəca ləwma dəmasə na, dza na mbaꞌa canati ghən tsa ci pərɓa kaa Marəy ka Magədala. Marəy ka Magədalaa niy tihəkəvəri Yesəw va hyeler mbərfəŋ mbə ghən nzə. ");
INSERT INTO bcw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dza Marəy mbaꞌa dzaa gəzanshi bar tsa kwəma va kaa mbəzliy niy nza lə Yesəw. Ma ghəshi ghala pətsa va na, war cəcəlikwə, lə wahə kwa mətsə shi. ");
INSERT INTO bcw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A kə Marəy ngəshi na: «Mbə piy na Yesəw sənzənva! E nay lə mətsee!» kə Marəy. Ma mbəzli va na kala zləɓati ma kwəma nzə va ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Zhini mbaꞌa Yesəw zhəghəvə nahwəti pa ta canati ghən tsa ci kaa nihwəti mbəzli ci bakə, mbəzli va kwa kwal mbə dza ta dzəti nahwəti giwa. ");
INSERT INTO bcw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mbaꞌa ghəshi zhəghəkəvashiy dzəvəgha nihwəti mbəzli ci va, mbaꞌa ghəshi gəzanshi kwəmaa mənta. Dza ni va kwərakwə ɓa na, kala zləɓa ma kwəma va ghəshi. ");
INSERT INTO bcw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dzəghwa, ləy hwəm kiy, mbaꞌa Yesəw canati ghən tsa ci kaa mbəzli ta səɗa ci va məŋ lə taŋ ni gwanashi, ghəshi mbə zəmə shi zəmə ghala vəghwə tsa va. Dza na naɓə naɓə naɓətishi, sa ɗi ma ghəshi zləɓa kwəma gəzəkə Hyala lə sa nza nefer shi caslakəslakə, mbaꞌa tə sa ɗi ma ghəshi va yi kwəma gəzanakəshi mbəzliy niy nay va ghəci zhakatiy mbə məti. ");
INSERT INTO bcw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A kə kaa ngəshi diɓa ki na: «Mbalam ya paꞌ kwəmaɓa tə pətsa kərkə hiɗi, a ghwəy dzaa gəzanshi Yəwən kwəma wəzə na kaa mbəzli gwanashi. ");
INSERT INTO bcw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma ntsaa dzaa zləɓavə kwəma dza ghwəy vaa gəzə, dzəghwa mbaꞌa məndi mananati *bateməy, ta mbəliy dza tsava ndə. Ma ntsaa dzaa zləɓati may, ta slanakən ngwəvə dza Hyala. ");
INSERT INTO bcw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mbəzliy dzaa zləɓavə kwəma vay, avanta kwəma maɗaŋa maɗaŋa na dza ghəshiy məni: Ta tihə hyeler dza ghəshiy dza mbə mbəzli, lə slən tsee. Ta gəzə kwəma dza ghəshi lə ghani səəkə ma ghəshiy gəzəhwə. ");
INSERT INTO bcw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ya shishiy kəsəvə ghəshi lə dəvə shi, ya ghwəꞌiy pəəsli ndəə sahwə ghəshiy, kwəmaa dzaa mananshi tiɓa tepəw. Ka ghəshi dzay ka fə dividivi shiy dzəkən mbəzli shaw shaw ni, fanakənshi ma ghəshi na, mbaꞌa mbəzli va mbəli shi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ma ləy hwəm sa kəɗiy Ndə sləkəpə Yesəw lə gəzə kwəma va kaa mbəzli ta səɗa ci ki na, dza Hyala mbaꞌa ɓəhwəə dzəmə ghwəmə, mbaꞌa dzaa nzəyəy tə kwa bəzəmə Hyala məɓa. ");
INSERT INTO bcw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dzəghwa mbəzli ta səɗa ci mbaꞌa ghəshi maɗishi ta dza ta gəzə Yəwən kwəma wəzə na va, ya paꞌ kwəmaɓa tə hiɗi gwaꞌa. Dzəghwa Ndə sləkəpə mbaꞌa kəətitishi. Tərəŋw ghəshi mənti kwəma maɗaŋa maɗaŋa na. Ma sa nata mbəzli kwəma va na, mbaꞌa ghəshi sənay, kwəma kataŋ naa sa gəzə ghəshi va, kə ghəshi. Ava tsəgha na Yəwən kwəma wəzə naa dzəkən Yesəw *Kəristəw njasa tsasliti Markə ki.");
INSERT INTO bcw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","A Tiyəwfiləsə ntsa dikə tsa, a gha sənay ghənghən ghənghən mənəhwə Hyala shiy mbə ghəy. A nihwəti mbəzli tiɓay, mbaꞌa ghəshi nashi shi mənəhwə Hyala va lə mətsə shi ghala ghava ghəshi. Dzəghwa Hyala ki mbaꞌa ghwənashi mbəzli va, ta dza ta gəzə kwəma nzə va kaa mbəzli. Ma sa dza nihwəti mbəzli ki na, mbaꞌa ghəshi tsatsaslati shi va tə zliya, war njasa slakəshi mbəzliy nashi va. ");
INSERT INTO bcw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sa dzee kwərakwə kiy, mbaꞌee njəɗivə shi va wəzə va mbəzli, njasa ghava ghəshi gwanashi. Ma sa njəɗivəshee ki na, wəzə na yən tsasləghəŋashi, gha ntsee dikə tsa njasa ghakəvashi ghəshi lə njasa nəwva ghəshi, pən na sana nay gha. ");
INSERT INTO bcw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma kwəma tsasliŋee va shi va tiy, ta mbə ghaa sənay kataŋ na shi ɓanavəŋa məndi va, pə gha, nə ya. ");
INSERT INTO bcw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ghala vəghwə tsaa nza *Erədə mbə məni mazə tə hiɗi ka Zhəwdey, a tsahwəti ndə ta Hyala niy nza tiɓa, Zakari, kə məndi kaa slən tsa ci. Zakari tsa vay, ndə ta Hyala tsa kwa zəərə *ka ta Hyala sləkə Abiya niy nzana. Ma mali ci na, mbə hwəhwə tsa *Araŋw, ntsa dikə tsa mbə ka ta Hyala, Elizabetə, kə məndi kaa slən tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kar Zakari ghəshi lə mali ci va bakanashiy, mbəzliy məni kwəma ɗi Hyala niy nza ghəshi, ka ɗi fəti ta *kwəma pəhəti Hyala lə nəfə tsa shi gwanay. ");
INSERT INTO bcw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Niy nza ndərazhi və shiw. Sa nzanay, jəŋa niy nza Elizabetə. Zhini diɓa ghala vəghwə tsa va na, tərəŋwshi ghəshi niy halishi bakanashi. ");
INSERT INTO bcw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Dzəghwa vəghwə tsa dza kar Zakari kwa zəərə shi, ta ghəra sləni mbə *ciki Hyala ti, mbaꞌa səəkəy. Dza ghəshi, taꞌwə taꞌwə taꞌwə ghəshi slaslati dandərɗə, njasa sənaɓəshi ghəshi mbə məni, ta ti ntsa dza Hyalaa tsəhavə ta məni sləni mbə ciki tsa nzə, geꞌi lə tsava vəghwə. Ma sa ti ghəshi dandərɗə tsa va ki na, mbaꞌa tivə Zakari ta dza ta ndi shiy zən wəzə mbə ciki Hyala. Sa sənata Zakari tə ya na ghəra sləni va kə ki na, mbaꞌa dzay dzəmbə ciki Hyala ta ghəra sləni va. ");
INSERT INTO bcw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma ghəci mbə ndi shiy zən va wəzə mbəɓa na, ka cəꞌwə Hyala mbəzli gwanashi ni pərikə tə ngwəla. ");
INSERT INTO bcw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","War Zakari mbəɓa ki na, vətəghə ndə kwal tsa Hyala tsahwəy kwa kwəma ci. Dza gar garəy vəgha bəla kwa bəzəmə pətsa ka məndi vaa, ndi shiy zən wəzə ni kaa Hyala ti. ");
INSERT INTO bcw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","War sa nay Zakari tsəgha na, mbaꞌa məhərli ci səəta, ka gwərgwərə ghəci va hazləni. ");
INSERT INTO bcw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma kə ndə kwal tsa Hyala tsa va kaa ngəci na: «A Zakari, ka hazləni gha ma. A Hyala zləɓati cəꞌwə gha. Avanay, ta ɓə hwər dza mali gha Elizabetə, ta yaŋa zəghwə. Sa ka na yakə zəghwə vay, Zhaŋ pə gha taa ni kaa slən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ta vəshiŋa dza gha dalala ta kwəma ci. Mbəzli ɗaŋ dza naa nza mbə vəshi, sa ka məndi yakə. ");
INSERT INTO bcw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Zəghwə vay, ntsa dikə tsa dza naa nza mbə sləni Hyala. Ka dza naa sa ya mbezli, ya nimaɓa shi saa ghipəw. Ghala ghəci kwa hwərəy dza *Safə tsa Hyala ɗewɗew tsaa təhay nəfə tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɗaŋ dza naa zhəghəkə məhərli ka *Izərayel, lə kwəma dza naa gəzanshi, ta zhini ghəshiy nəw Hyala kwa sləkəshi. ");
INSERT INTO bcw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ndə kwal tsa Ndə sləkəpə dza naa nza. Məhərli ci lə bərci ci gwaꞌay, war nja sa *ndə gəzə kwəma Hyala *Eli va mbəradzə dza naa nza. Sa ka na dzay, mbaꞌa sləkamti kwəma kwa jipə kar didihi lə ndərazhi shi, mbaꞌa jakətishi. Sa ka na dza kaa mbəzliy zhini ghən kaa Hyalay, mbaꞌa zhəghanti məhərli shi, nza ghəshi nza ka mbəzliy məni kwəma ɗi Hyala. Ava tsəgha dza naa gwəmanti nefer mbəzli wəzə wəzə ta zləɓa Ndə sləkəpə ghəshi sa naa səəkəy» kə ndə kwal tsa Hyala tsa va kaa Zakari. ");
INSERT INTO bcw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma sa favə Zakari kwəma va tsəgha, ma kə kaa ndə kwal tsa Hyala tsa va na: «Kay, njaa njaa dzee gha sənay kataŋ na kwəma va pən kia? Ava ghaa nay sənzənvay, pəhal nzee dalala, zhini tsəgha malee kwərakwə ɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma kə ndə kwal tsa Hyala tsa va na: «Yənəy, yən na ndə kwal tsa Hyala tsa har məndiy Gabəriyel. Kwa kwəma Hyala kee nza, ka ghəranta sləni. Sanay, Hyala ghwənikəra na ta gəzaŋa kwəma, lə ta gəzaŋa Yəwən nəwər tsa wəzə tsa tsa. ");
INSERT INTO bcw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma kwəma gəzaŋee vay, ta məniva dza na, sa ka vəghwə tsa va səəkəy. Ma nja na zləɓati ma gha kwəma vay, ta pəhəta dza ghani gha. Kala mbata ma gəzə kwəma gha, paꞌ fəca vici dza məndi vaa yakə zəghwə gəzaŋee na» kə ndə kwal tsa Hyala tsa va kaa Zakari. ");
INSERT INTO bcw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ma ghala pətsa va ki na, war mbə ndəghə Zakari mbəzliy ɓasəshi va, ta cəꞌwə Hyala pərikə. «Wa shiy mənishi nzəyəy Zakari rikərik mbə ciki tsa tsətsə shəka?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dza Zakari ki, mbaꞌa səvəriy. Ma sa səvəriy na, dzəghə kə kaa gəzanshi kwəma na, kala mbay ghəciy gəzanshi. Dza na ka paghanshi kwəma lə dividivi. Ma sa paghanshi na kwəma lə dəvə na, mbaꞌa ghəshi sənay tsəgha, shi maɗaŋa maɗaŋa ni səəkə va Hyalaa nashi na, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma sa kəɗiy vəghwə tsa slanavə məndi kaa Zakari ta ghəra sləni mbə ciki Hyala ki na, mbaꞌa dzay jighi. ");
INSERT INTO bcw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ləy hwəm hi jəw ki na, mbaꞌa mali ci Elizabetə ɓəvə hwər. Ma sa nay na ghənzə ɓəvə hwər na, mbaꞌa nzəyta kəghi tsa nzə mbə tir cifə, kala dzəti ma ngwəla. Ma kə kaa kwəma gəzə na na: ");
INSERT INTO bcw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Hyala məntəɗa na tsava wəzə hwər. Aa ɓanti haꞌwə tsa tə ya, va kwəma jiŋa kənee na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ma tə kwa kwaŋa tir tsa Elizabetə lə hwər na, dza Hyala tə nahwəti vici, mbaꞌa ghwənay ndə kwal tsa nzə Gabəriyel dzəmbə məlmə Nazaretə tə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ndə kwal tsa vay, kaa nahwəti zha ghwənəghə na, Marəy, kə məndi kaa slən tsa nzə. Makwa tsahwəti ndə ghənzə, *Zhezhefə, kə məndi kaa slən tsa ci, ntsa yakə məndi mbə hwəhwə tsa mazə *Davitə ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma sa tsəhəy ndə kwal tsa Hyala tsa va kəghi tsa kar Marəy ki, ma kə kaa ngəta na: «Avee səkwətəŋa kwajin, vəshi pə ghaa vəshi, sa nzanay, a Hyala dərnitəŋa. Kwasəbə gha na Ndə sləkəpə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sa favə Marəy kwəma va na, mbaꞌa məhərli nzə səəta. Ma kə mbə ghən tsa nzə na: «Njaa ɗi gəla tsatsa səkwəpəə gəzə kia mbəzlia!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma ghənzə mbə təkə tsəgha, ma kə ndə kwal tsa Hyala tsa va ngəta na: «A Marəy, ka hazləni gha ma! Hyala məntəŋa na wəzə hwər tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Avanay, ta dzəghwa hwər dza gha, ta ya zəghwəə zal. Sa ka gha yakəy, Yesəw pə gha taa ni kaa slən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma zəghwə vay, ntsa dikə tsa dza naa nza, Zəghwə Hyala ta ghwəmə dza məndiy har. Ta fəy dza Hyala kwa sləkəpə ka mazə, njasaa niy nza jijiy Davitə va niy nza. ");
INSERT INTO bcw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ghəci dza naa sləkə hwəlfə ka *Izərayel paꞌ kwa ndimndim. Ka dza sləkəpə tsa ciy kəɗi ka na nzaw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma sa favə Marəy tsəgha, ma kə kaa ndə kwal tsa Hyala tsa va na: «njaa kee mbay ɓəvə tsava hwər ki, kala səəkə ghəy nza lə zal ghala nzee kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma kə ndə kwal tsa Hyala tsa va kaa ngəta na: «*Safə tsa Hyala ɗewɗew tsa dza naa səəkəy dzəkən gha, mbaꞌa bərci nzə dzaa səəkəə ləmaꞌwakənvashi kən gha nja məcakwə. Ava tsəgha dza ghaa ɓəvə hwər. Ma zəghwə dza gha va ta yay, ntsa ɗewɗew tsa dza naa nza, Zəghwə Hyala dza məndi har. ");
INSERT INTO bcw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Avanay sanay, zhadəŋa Elizabetə ghənzə sa niy nə məndi va, jiŋa na, ka yakə zəghwə naw, kə məndiy, lə hwər na sənzənva. Kwa kwaŋa tir tsa nzə na, ya tsəgha naa pəhal. ");
INSERT INTO bcw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A gəzaŋee, na na Hyalay, shiy tiɓa kala mbay ghənzəə məntishiw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma sa favə Marəy tsəgha, ma kə na: «Yənəy, sa kwa sləkəpə nzee. Məniva kwəma nzə vaa dzəkənee lə kwal tsa bərkəti na va, njasa gəzə gha va» kə. Ma sa zləɓakə Marəy tsəgha ki na, dza ndə kwal tsa Hyala tsa va, mbaꞌa dzay, zlata. ");
INSERT INTO bcw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma ləy hwəm sa gəzəkə *ndə kwal tsa Hyala va kwəma kaa Marəy ki na, dza na mbaꞌa maɗita kyaŋwkyaŋw ta wə vəgha Elizabetə, mbə məlmə nza kar Zakari mbə. Məlmə vay, dzar mbə kəleŋer tə hiɗi ka Zhəwde niy nza na. ");
INSERT INTO bcw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma sa tsəhəta na mbəɓa na, mbaꞌa dzakətaa dzakə ghi tsa Zakari, dza na ka səkwə Elizabetə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","War sa səkwəti Marəy Elizabetə na, mbaꞌa zəghwə nzə kafəy ta kwəfəghə kwa hwər nzə. Dzəghwa *Safə tsa Hyala ɗewɗew tsa paf təhay nəfə tsa Elizabetə tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dza na ka gəzanta kwəma kaa Marəy zlaŋzlaŋ, ma kə na: «A Hyala dərnitəŋa na gha ki Marəy. Tərəŋwɓa ghaa dərniti na kaa nihwəti miꞌi gwanashi. Zəghwə dza gha va ta ya ɓay, a Hyala təfanati miy. ");
INSERT INTO bcw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wa slən tsee mbə mbəzli kwərakwə kia mbəzlee səəkəta mbəghəy Ntsaa sləkəra ta wəra wə? ");
INSERT INTO bcw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sənay gha na Marəy, ghala pətsa səkwəra gha vay, maɗ, zəghwə maɗiy ta kwəfəghə va vəshi tsəgha kwa hwər tsee. ");
INSERT INTO bcw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A Marəy, vəshi na tə gha, sa nzana, mbaꞌa gha zləɓavə kwəma gəzəkəŋa Ndə sləkəpə, mbaꞌa gha sənay, ta məniva dza na, pə gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ləy hwəm sa gəzəkə Elizabetə tsəgha na, dza Marəy ka fal Hyala kwa cəm, ma kə na: «A falee dikə tsa Hyala kwa sləkəpə. ");
INSERT INTO bcw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Paf təhəy nəfə tsee va vəshi, tə mbərkə Hyalaa mbəlira. ");
INSERT INTO bcw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sa nzanay, aa fakən məhərli nzə kənee, yən yən kwa ghəranta sləniy zhəghəti ghən tsee jəwə. Va tsəgha kiy, ghava na sana, paꞌ kwa ndimndiməy, mali dərniti Hyala dza məndiy harɗa. ");
INSERT INTO bcw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa nzanay, a Hyalaa gwəramti tə bərci ɗewɗew na məntəra shi wəzə ni tərəŋw. Ntsa ɗewɗew tsa, na slən tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ya hwəmɓay, war mbə məni wəzə hwər na kaa mbəzliy ɗanta fəti. ");
INSERT INTO bcw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aa mənti sləni dikə na tərəŋw lə bərci mbə dəvə nzə, mbaꞌa ndanivəri zəzə kwəma mbəzli nza kəli ghən mbə nefer shi, ");
INSERT INTO bcw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","mbaꞌa tsəkwəkəghwa mezhizhə kwa gəzli mazə shi, mbaꞌa parambə mbəzliy zhəghəti ghən tsa shi jəw jəw mbə mazə tə pətsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aa ngangaslay mbəzli mbə mashi ni paf paf lə shi wəzə ni. Mbaꞌa tihəti ka shiy paw dividivi shi. ");
INSERT INTO bcw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aa kəətitəmmə ghwəmmə hwəlfə ka *Izərayel, ghwəmmə ka sləni nzə. Zamti ghən na ta məni wəzə hwər tsa nzə ");
INSERT INTO bcw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kaa *Abəraham, lə kaa ngəmmə ghwəmmə jijihiy ya hwəmɓaw. Njasa niy gəzəkə na va məni kaa jijihimməy, tsəgha mənimmə na wəzə hwər tsa va» kə Marəy kaa cəm tsa nzə va. ");
INSERT INTO bcw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dza Marəy mbaꞌa nzəyta kəghi tsa kar Elizabetə, mbaꞌa mənti tir gar mahkan kəyɓa. Ləy hwəm ki na, mbaꞌa zhataa jighi. ");
INSERT INTO bcw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dzəghwa ki, mbaꞌa tir tsa dza Elizabetə ta ya ti səəkəy. Dza na baw yakə zəghwəə zal. ");
INSERT INTO bcw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ma sa yata na na, mbaꞌa ka ghalahita, lə manhita gwaꞌa favə: «A Hyala mananati wəzə hwər tsa nzə kaa Elizabetə, mbaꞌa ɓanavə zəghwə» kə məndi, dza mbaꞌa ghəshi vəshishi tərəŋw li. ");
INSERT INTO bcw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma sa mənti zəghwə ləwma kwətiŋ ghala yakə məndi ki na, mbaꞌa məndi ɓasəshi ta *slanci fəꞌyasa lə ta fanci slən. Dza məndi ka ɗi fanci slən Zakari, nja dəy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma kə mbəghəy na: «Awə, tsəgha dza slən tsa ciy nzaw, Zhaŋ ka məndi har» a kə. ");
INSERT INTO bcw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma kə mbəzliy ɓasəshi va kaa ngəta na: «Səəkə slən tsa tsəgha tsaa nza tə tsahwəti ndə mbə takə tsa ghwəy ya kwətiŋəw Elizabetəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dzəghwa ghəshi ka paghanci kwəma lə dəvə kaa Zakari, dəy zəghwə va ta mbəə sənay slən tsa ɗi na məndiy fanci kaa zəghwə ci. ");
INSERT INTO bcw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dza Zakari, mbaꞌa ɗəwvə tsəm tsa fəɗiti məndi ta tsasli shiy dzəti və shi. Sa ɓanavə məndi na, dza na mbaꞌa tsaslati slən tsa zəghwə va ti. «Zhaŋ na slən tsa ci» kə. Sa jangəvə mbəzli va shi tsasliti na va na, mbaꞌa məhərli shi səəta va nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","War ghwəla ki na, wərət ghani Zakari va niy pəhəta pəlita, nighəm na, ghəciy mbata gəzə kwəma wəzə. Dza na ka fal Hyala zlaŋzlaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma sa nata ka ghalahiy Zakari nava kwəma tsəgha na, mbaꞌa her shi dzashi. War ə məndiy slasla kwəma zəghwə va dzar mbə məlməhi mbə kəleŋer tə hiɗi ka Zhəwde. ");
INSERT INTO bcw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ya wa ntsaa favə nava kwəma na, mbaꞌa ɓanavə təkə kwəma mbə nəfə tsa ci. A kə ndəə ni na: «Ta njaa dza kwəma tsava zəghwəə nza kia?» kəə ni. Ta na nava kataŋəy, a Hyala fakən dəvə nzə kən zəghwə va. ");
INSERT INTO bcw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dzəghwa Hyala lə Safə tsa nzə ɗewɗew tsa paf təhay nəfə tsa Zakari, dəy Zhaŋ, tapə ghəci ta gəzə kwəmaa səəkə va Hyala, ");
INSERT INTO bcw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ma kə na: «ꞌWəsa nə ya kaa Hyalaa sləkəra, kaa Hyala ka *Izərayel, sa nzana mbaꞌa fakən məhərli nzə kən shi, ghəshi mbəzli nzə, dza na mbaꞌa mbəlitishi. ");
INSERT INTO bcw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aa ghwənikəmmə ndə mbəlimmə lə bərci və tərəŋw. Ndə mbəlimmə tsa vay, jijiy mazə *Davitə, ndə ghəra sləni tsa Hyala mbəradzə na. ");
INSERT INTO bcw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kwəma mənti Hyala vay, aa niy gəzəkə lə miy tsa ka gəzə kwəma nzə ɗewɗew ni mbəradzə. ");
INSERT INTO bcw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aa niy gəzəkə: “Ta mbəlitəŋwəy dzee mbə dəvə ka mbəz ghwəy, lə mbə dəvə mbəzliy ɗi ma kwəma ghwəy gwanashi” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Zhini diɓa, mbaꞌa niy gəzəkə: “Ta məntəŋwəy wəzə hwər dzee” kə niy ni kaa jijihimmə niy nza. “Ka dzee zamti ghən ta kiri tsa slati ghwəmmə tsaw” kə niy ni kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gəzee kwəma va tsəghay, sa nzana, mbaꞌa Hyala niy zəmanakə fəla kaa jijimmə *Abəraham, ");
INSERT INTO bcw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ta mbəlikəvərimmə mbə dəvə ka mbəz ghwəmmə, lə ta ndammə kwal tsaa ghəranta sləni nzə, kala hazləni mbə nəfə ghwəmmə. ");
INSERT INTO bcw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mbaꞌa ta mbə ghwəmməə nza ka mbəzli ɗewɗew ni, ka nəw kwəma lə kwal tsa nzə, ɗewɗew ghwəmmə kwa kwəma nzə ya paꞌ hwəmɓa. ");
INSERT INTO bcw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta na na gha kiy, zəghwə yay, *Ndə gəzə kwəma Hyala ta ghwəmə dza ghaa nza, kwa kwəma Ndə sləkəpə dza ghaa dza, ta gwəmanci kwal tsa dza naa səəkə kwa. ");
INSERT INTO bcw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gha dza naa gəzanshi kaa mbəzli ci: “Ta pəlayŋwəy jikir tsa ghwəy dza Hyala mbə nəfə tsa nzə, ta mbə ghwəy mbəliŋwəy” pə gha. ");
INSERT INTO bcw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sa nzanay, tərəŋw na wəzə hwər va Hyala ghwəmmə, tərəŋw hwər tsa nzə zhanta ta mbəzli diɓa. Ava va tsəgha dza waŋ pi tsa nzəə səəkə mə ghwəmmə kaa ngəmmə, nja waŋ tsa ka vici vaa məni ghənzə mbə səəmə. ");
INSERT INTO bcw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Waŋ pi tsa vay, ghəci dza naa mbərə kaa mbəzli mbə kwəsli, lə kaa mbəzliy hazləni va məti. Ghəci dza naa cimmə kwal tsaa dzəvəgha Hyala, ta mbə zərkəə nza kwa jipə ghwəmmə li» kə Zakari kaa cəm tsa ci va. ");
INSERT INTO bcw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma Zhaŋ naci ki na, war mbə kəli ghəci, ka mətsəhəva məhərli ci. Dza na mbaꞌa dzaa nzəyəy mbə gamba, kərakə lə mbəzli, paꞌ fəca vici gha naa səəkə ta ci ghən tsa ci kaa ka Izərayel ta ꞌwa sləni ci. ");
INSERT INTO bcw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Ghala vəghwə tsa vay, a tsahwəti ndə niy nza tiɓa, Agwəstə kə məndi kaa slən tsa ci. Ghəci niy nza naa mazə tsaa sləkə hiɗi ka *Rəm gwanashi. Dzəghwa na mbaꞌa fəy Kiriniyəsə ka ngwəmna tə hiɗi ka Shiri. Ghala vəghwə tsaa nza Kiriniyəsə vaa ngwəmna ki na, dza mazə Agwəstə tə nahwəti vici, mbaꞌa gəzanshi tsasli slən tsa mbəzli tə hiɗi ka Rəm gwanashi kaa mezhizhə. Ghənzə na kwa taŋa tsasli ꞌwa məndiy tsasli tə hiɗi va. ");
INSERT INTO bcw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma sa gəzəkə mazə Agwəstə tsəgha ki na, dza mbəzli gwanashi ka dzashi ta tsasli slən tsa shi ki. Ya tsamaɓa ndə na, ka dzaa dzəmbə məlmə jijihiy. ");
INSERT INTO bcw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","A tsahwəti ndə niy nza tiɓay, *Zhezhefə, kə məndi kaa slən tsa ci. Dza na kwərakwə ki, ghəshi lə makwa ci Marəy, mbaꞌa ghəshi kafəshi mbə məlmə Nazaretə tə hiɗi ka Galile, ta dzəmbə məlmə Betəlehem tə hiɗi ka Zhəwde. Məlmə vay, mbə niy yakə məndi mazə *Davitə mbəradzə. Sa nzana jijiy Davitə Zhezhefə ki na, na dza ghəshi ta tsasli tsa shi slən mbəɓa. Ma Marəy ghala vici va ki na, lə hwər ghənzə niy nza. ");
INSERT INTO bcw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma sa tsəhəshi ghəshi mbə məlmə Betəlehem va ki na, mbaꞌa vici ya Marəy mənta. ");
INSERT INTO bcw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dzəghwa baw yakə zəghwəə zal, Cikwa tsa nzə. Sa yakə na na, dza na mbaꞌa parambə mbə kadibəl faghwa kwa pətsa ngati məndi ta shəkə gwəzən kaa gədəw. Ma kwəma faghwa na kwa pətsa va tiy, sa kama ngwəla mək mbə ciki tsa ka ka məlmə nza mbə. ");
INSERT INTO bcw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma ghala vici va ki na, mbaꞌa ka garəwa niy nza kwamti vəgha məlmə Betəlehem va mbə makə shiy həvir. ");
INSERT INTO bcw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dza *ndə kwal tsa Hyalaa sləkəpə, vətəghə səəkəy dzəghwa kwəma shi. Dza shəndəkə tsa Ndə sləkəpə mbaꞌa səəkəy dzəkən shi, ka mbərə waŋ pi tsa nzəə dzəkən shi. Ma sa nay ghəshi tsəgha na, mbaꞌa hazləni kəsəvəshi tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dzəghwa ma kə ndə kwal tsa Hyala tsa va ngəshi na: «Ka hazləni ghwəy ma, sa nzanay, nəwər tsa wəzə tsa na sa ɓəkəŋwəy ya. Nəwər tsa vay, saa dzaa ɓanavəshi vəshi tərəŋw kaa hwəlfə mbəzli tə hiɗi gwaꞌa na. ");
INSERT INTO bcw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Favə tə ghwəy, ndatsə tə vərɗi nay, a ndə mbəlipə yay tə ghwəy mbə məlmə Betəlehem, məlmə mazə Davitə. Ghəci na Ndə sləkəpə, ghəci *Kəristəw, ntsa təravə Hyala va ta mbəli mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mbalam, a ghwəy dzaa nighəti. War kəsay ma ghwəy vərnjəꞌwə pəərə pəərə mbə kadibəl, məhəni ghəci kwa pətsa ka gədəw pərə gwəzənəy, ghəci na ki» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","War sa gəzəkə ndə kwal tsa Hyala tsa va tsəgha na, nzaꞌjəw vərəm ka kwal Hyala mə ghwəmə mətsəhəkəvashiy dzəvəgha tsava ndə kwal tsa Hyala. Ka fal Hyala ghəshi, ma kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Hyala shəndəkə na na Hyala ta ghwəmə, fal ghwəmmə, aa ɓanakəshi zərkə kaa mbəzli ɗi na tikə tə hiɗi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sa falamti ka kwal Hyala va Hyala ki na, dza ghəshi, mbaꞌa ghəshi kafəshi vəgha ka garəwa va, ka zhashiy zhimə ghwəmə. Ma sa zhashi ghəshi na, dza ka garəwa va, ka gəzə kwəma kwa jipə shi, a kə ghəshi na: «Ndata tsəgha na kwəma vay, dzamməm dzəmbə məlmə Betəlehem va, a ghwəmmə dzaa nashi shiy mənishi va gəzammə Ndə sləkəpə lə mətsə ghwəmmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dza ghəshi tsəgha, kafə ghəshi kafəshi, ka dza, lə diva lə diva. Dza mbaꞌa ghəshi tsəhəshi mbə məlmə Betəlehem. Sa tsəhəshi ghəshi na, mbaꞌa ghəshi kəsashi kar Marəy lə Zhezhefə mbaꞌa vərnjəꞌwə tsa va, məhəni ghəci kwa pətsa ka gədəw pərə gwəzən. ");
INSERT INTO bcw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma sa nay ghəshi vərnjəꞌwə tsa va na, tapə ghəshi ta slanshi kwəma gəzanakəshi *ndə kwal tsa Hyala vaa dzəkən zəghwə va. ");
INSERT INTO bcw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ya wa ntsaa favə kwəma gəzəkə ka garəwa va va na, nja maɗaŋa ghəci nata nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Marəy nanzə ki na, war ka fə kwəma va gwanataa dzəmbə ghən nzə, ka təkə kwəmaa dzəkən wəzə. ");
INSERT INTO bcw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ghavə ka garəwa va, mbaꞌa ghəshi kafəshi, ka zhashiy jighi. Ma ghəshi mbə kwal na, war ə ghəshiy fal dikə tsa Hyala ta shi favə ghəshi va lə shi nashi ghəshi va. Sa nzana tsəgha mətsə shi nashi shi va, njasaa niy gəzanakəshi ndə kwal tsa Hyala va. ");
INSERT INTO bcw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma sa mənta ləwma kwətiŋ ghala yata Marəy ki na, mbaꞌa vici *slanci fəꞌyasa kaa zəghwə nzə mənta. Sa slanamti məndi na, mbaꞌa məndi fanati slən Yesəw. Slən tsa vay, ghəci na saa niy gəzanci *ndə kwal tsa Hyala kaa mbəghəy ta fanci ghala ghənzə ghwəla ta ɓə hwər. ");
INSERT INTO bcw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dza Marəy mbaꞌa mənti vici faɗə mətsəkə mbə pi yam ghwə məwti, njasa gəzəkə kwəma pəhəti *Məyizə kaa ka *Izərayel. Ma sa kəɗamti na pi yam ghwə ki na, mbaꞌa ghəshi ɓəvə zəghwə shi va, ka dzashiy dzəmbə ciki Hyala mbə məlmə Zherəwzalem ta fəə dzəghwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sa tsəhəshi ghəshi na, mbaꞌa ghəshi fəy kwa kwəma Hyala, sa nzana tsəgha məndi tsasliti mbə *kwəma pəhəti Hyala. Ma kə məndi na: «Yakə ma mali kwa taŋa zəghwə nzə, zəghwəə zal kəy, tsa Hyalaa sləkəpə dza tsavaa nza» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dza ghəshi mbaꞌa ghəshi ɓəvə shiy vəlanavəshi kaa Hyala, sa nzana tsəgha kwəma pəhəti Məyizə gəzəkə: «Mbaꞌa kə mali kəɗita lə pi yam ghwə məwtiy, nza ghənzə dzaa ɓanavə ya ghərpəpəhi bakə, ya kwəkwər palayhi bakə kaa Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma ghala vəghwə tsa va ki na, mbaꞌa tsahwəti ndə niy nza tiɓa mbə məlmə Zherəwzalem, Shimeyaŋw, kə məndi kaa slən tsa ci. Ndə wəzə ghəci niy nza, ntsa slar tsa, ka nəw kwal Hyala lə nəfə kwətiŋ. War mbə ndəghə səəkə tsa ntsaa dzaa mbəli ka *Izərayel ghəci. Lə *Safə tsa Hyala ɗewɗew tsa mbə nəfə ci. ");
INSERT INTO bcw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mbaꞌa Safə tsa Hyala va niy gəzanci, ka dza ghaa mətiŋa kala dza mətsə ghaa nay *Kəristəw Ntsa tivə Hyalaw, kə niy ni ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dza Safə tsa Hyala va, mbaꞌa kakə Shimeyaŋw dzəmbə *ciki Hyala. Ma ghala vəghwə tsa va na, mbaꞌa kar dəy lə mbəghəy ɓəkə Yesəw dzəmbə ciki Hyala, ta fəə dzəghwa kwəma Hyala, njasa gəzəkə kwəma pəhəti *Məyizə. ");
INSERT INTO bcw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sa nay Shimeyaŋw zəghwə va ki na, mbaꞌa ɓəvə vəgha hwər tsa ci. Dza na ka məni ꞌwəsa kaa Hyala, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","«A Ndə sləkəpə, ꞌwəsa dalala, nana kiy, a kwəmaa niy gəzəkə miy tsa gha va niy nza mənta, a mətsee nay ndə mbəlipə tsa ghwənikə gha. Nana kiy, a ghaa mbəə zlay ndə sləni tsa gha a ghəci mətiy lə wəzə. ");
INSERT INTO bcw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","*Ndə mbəlipə tsa va na sa garəy gha ta mbəzli tə hiɗi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ghəci na waŋ pi tsaa dzaa canshi kwal tsaa nəwŋa kaa hwəlfə mbəzli tə hiɗi gwanashi. Ghəci dza naa fə shəndəkəə dzəti ka *Izərayel ghəshi mbəzli gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma sa favə kar dəy Yesəw ghəshi lə mbəghəy kwəma gəzə Shimeyaŋw va na, nja maɗaŋa ghəshiy nata nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dzəghwa Shimeyaŋw mbaꞌa təfanatishi miy. Zhini ma kə kaa Marəy mbəghəy Yesəw na: «Avanay zəghwə nay, Hyala təravə na ta sənay nəfə tsa ka Izərayel ghənzə. Nihwəti mbəzliy zəghwə va dza naa mbəlitishi, nihwətiy diɓa na, raꞌi ghəshi dzaa zashi, sa ka ghəshi zləɓa ma nəw ci. Zəghwə va dza naa ci shi ɗi Hyala mbəzliy məni. Ə na na nzanay, ka dza mbəzliy zləɓaw. ");
INSERT INTO bcw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ghəciy, ta cikəvəri kwəma mbəmbə na dzar mbə nefer mbəzli ɗaŋ dza naa dzəti ngwəla. Ma gha na na ghay Marəyəy, ta sa ngəraꞌwə dza ghaa dza tə kwəma zəghwə gha na. Njasa dzəramtəŋa məndi miy nəfə tsa gha lə gwapa dza ngəraꞌwə tsa tə ghaa zhəŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma ghalaɓa diɓa ki na, mbaꞌa nahwəti mali niy nza tiɓa mbə məlmə Zherəwzalem. Kwa gəzə kwəmaa səəkə va Hyala ghənzə. Ana slən tsa mali va, zha Penəwel mbə hwəlfə kar Aser ghənzə. Tərəŋw ghənzə niy halita. Ghənzə kiy, piya mbərfəŋ niy mənəhwə ghəshi lə zal tsaa niy ɓəvə na, ghənzəə zha. Dzəghwa mbaꞌa zata tsa va mətiy. ");
INSERT INTO bcw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma sa mətiy zata na, dza na mbaꞌa nzəyta ka məgwəmba. Ghala vəghwə tsa vay, piya dəghəsə mətsəkə faɗəti niy nza sa nzə. Kalaa niy səvəri ghənzə mbə *ciki Hyala, war sləni Hyala ghənzəə məni havəghwə lə həvir gwaꞌa. Ka məni səwmay, ka cəꞌwə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dza na ki ndəs səəkəta tiɓaa dzəvəgha kar Marəy lə zata geꞌi lə vəghwə tsa va. Sa səəkəta na na, tapə ghənzə ta mananta ꞌwəsa kaa Hyala kwərakwə, dza na ka gəzanshi kwəmaa dzəkən Yesəw kaa mbəzliy ndəghə vici dza Hyalaa mbəli mbəzli mbə Zherəwzalem ti. ");
INSERT INTO bcw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dza kar Zhezhefə ghəshi lə Marəy ki, mbaꞌa ghəshi kəɗamti məni *kwəma pəhəti Hyalaa dzəkən zəghwə shi. Ma sa kəɗamti ghəshi məni nzə na, dza ghəshi ka zhashi lə zəghwə shiy jighi, zhimbə məlmə Nazaretə tə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma zəghwə shi va naci ki na, war mbə mətsəhə kəli dikə, kwəriŋ kwəriŋ vəgha ci. Mbaꞌa Hyala fanambə məhərliy sənata kwəma tərəŋw dzəmbə ghən tsa ci. Bəm Hyala fakən dəvə nzə kən. ");
INSERT INTO bcw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Njasa səəkə piya vay, mbə dza niy nza kar dəy lə mbəghəy Yesəw dzəmbə məlmə Zherəwzalem ta *makwaghwa Pakə. ");
INSERT INTO bcw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma sa mənti Yesəw piya məŋ lə bakə ki na, dza ghəshi pəm ghəshi pəməvə, ka dza ta makwaghwa va li njasa sənaɓəshi ghəshi mbə məni. ");
INSERT INTO bcw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sa tsəhəshi ghəshi mbə Zherəwzalem na, ka məni makwaghwa Pakə ghəshi. Dza ki mbaꞌa Pakə kəɗita. Ma sa kəɗita Pakə na, mbaꞌa kar *Zhezhefə lə Marəy kafəshi ka zhashiy jighi nashi ki. Mbalaa mbaꞌay na Yesəw ləy hwəməy mbə məlmə Zherəwzalem. Kalaa niy fəti ghən ghəshi ta nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","War dza ghəshiy dza. Ma kə ghən tsa shi na: «Dzar mbə nihwəti mbəzli nza ghəy mbə dza li shi kwa zəərə kwətiŋ na na zəghwə» kə ghəshi nashi ki. Vəghwamti ghəshi mbə dza. Ma hetihwer ki na, mbaꞌa ghəshi maɗishi ta pala dzar mbə manhiy, lə dzar mbə madigahishi. ");
INSERT INTO bcw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pəlaꞌ pəlaꞌ kə ghəshi na, shaŋ ghəshi ta nay. Ma sa nay ma ghəshi na, dza ghəshi ka zhəghəvaa zhimbə Zherəwzalem ta pəla mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vəghwamti ghəshi mbə pəla ci. Ma tə kwa mahkana vici na, zhini ndəs ghəshi tsəhəshi mbə Zherəwzalem. Dza ghəshi na, Yesəw mənzəy mbə ciki Hyala, tə jipəjipə *ka ɓənipə kwəma pəhəti Hyala mbə *ka Zhəwifə. Ka fa kwemer ɓənipə ghəshi va, ka ɗəɗəw nahwəti kwəma mbə və shi ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ya wa ntsaa favə gəla kwemer gəzə na va na, ka mananci maɗaŋa va na ci va hwəlfə məhərli, lə va gəla kwəma ka naa zləɓakə gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma sa səəkə kar Zhezhefə lə Marəy nay na, ka mananshi maɗaŋa nava kwəma. Ma kə mbəghəy ngəci na: «A zəghwee, tawa məntəŋəy gha nana kwəma tsətsəa, tawa gwəravə ghaa dzamtəŋəy her ghəy lə dəŋa, kwəp kwəp kwəp ghəy mbə pəlaŋa kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma kə Yesəw kaa zləɓanta na: «Wa shi pəlara ghwəy ti tsəghaa? Ə sənay ma ghwəy mbə ciki tsa Dirə dzee nza ta ghəranci sləni ci pə ghwəy shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kwəma gəzəkə na va ki na, mbaꞌa səəti məhərli kar dəy ghəshi lə mbəghəy. ");
INSERT INTO bcw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dzəghwa Yesəw ki, mbaꞌa nəwvəshi, ka zhashi ghəshiy zhimbə məlmə Nazaretə kwa zəərə shi. Ka yə fəti ghəci kaa mbəzliy yakə va, njasa ɗi ghəshi. Ma na mbəghəy nanzə ki na, war mbə fə ghən ghənzə ta shiy məniva va gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesəw ki na ka mətsəhə kəli vəgha ci, ka mətsəhəva məhərliy sənata kwəmaa dzəmbə ghən tsa ci gwaꞌa. Ka təɓanta kwəma ci kaa Hyala, tsəgha kaa mbəzli kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ləy hwəm sa mətiy Agwəstə, mazə tsaa sləkə hiɗi ka *Rəm gwanashi na, mbaꞌa məndi pəərəti tsahwəti ndəə dzəghwa pətsa ci. Tiber, kə məndi kaa slən tsa ci. Ma Tiber mbə məni kwa məŋ lə cifə piya ci mbə mazəy, Paŋwəsə Pilatə niy nza naa ngwəmna tə hiɗi ka Zhəwde. Ma *Erədə na, ka məni ngwəmna tə hiɗi ka Galile. Fəlipə, zədəy Erədə na, tə hiɗi ka Itəre lə ni ka Terakwanitə, mbaꞌa Lizaniyasə ka məni tə ni ka Abilen. ");
INSERT INTO bcw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ghala vici vay, bakə niy nza mbəzli dikə dikə ni mbə *ka ta Hyala mbə ka *Izərayel. Anə, kə məndi kaa slən tsa tsahwəti, Kayifə tsahwəti. Geꞌi geꞌi lə vəghwə tsa va ki na, dza Hyala mbaꞌa gəzanta kwəma nzə kaa Zhaŋ zəghwə Zakari ghəci ghwəlay mbə gamba. ");
INSERT INTO bcw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma sa favə Zhaŋ kwəma gəzanakə Hyala va na, dza na mbaꞌa maɗiy ka dza dzar mbə məlməhi dzar miy həl Zhərdeŋ gwanashi ka gəzanshi kwəma Hyala kaa mbəzli, ma kə na: «Tsam titihwə kwa kwəma Hyala, zhəghantim nzəy tsa ghwəy, ma nza məndi məntəŋwəy batem, nza Hyala pəlayŋwəy jikir tsa ghwəy mbə nəfə tsa nzə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kwəma gəzə na vay, kərasl dzəghwata na kwa kwəmaa niy tsasliti *Ezay ndə gəzə kwəma Hyala va niy nza mbə zliya ciy dzəkən Zhaŋ. Ma kə niy niy: Ava məli ndəə gaka mbə zlapə mbə gamba. Ma kəy: «Gwəmantim nefer ghwəy ta kaꞌwə Ndə sləkəpə, njasa ka məndi vaa zamti kwal wəzə wəzə ta kaꞌwə ntsa dikə tsa, mbaꞌa ghwəy ghwənanamti nefer ghwəy wəzə wəzə. ");
INSERT INTO bcw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pətsa dəɓaŋ dəɓaŋ tsa gwaꞌay, ta yəməy dza na, cəkeꞌ dza məndiy həlɓanti kar dəlegwigwi lə hwəmer pi gwaꞌa. Tə pətsa nza kweler hwəɗaŋə hwəɗaŋəy, tiɗiɗ dza məndiy gəŋətishi. Kweleriy yiɗishi gwaꞌay, ta yəmamtishi dza məndi. ");
INSERT INTO bcw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya wa ndə ghalaɓa kiy, ta nay ntsa ghwənikə Hyala ta mbəlipə dza na» kə mali va, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma Zhaŋ mbə gəzə kwəma ci va tsəgha ki na, dza mbəzli mbaꞌa ghəshi ɓasəkəvashi dalala ta mbə ghəciy mananshi batem. Ma kə Zhaŋ kaa ngəshi na: «Ghwəyəy, nja shesher ndərəm ghwəy. Mbə təkə kwəma ghwəyəy, ta mbəliŋəy dza ghəy va ngwəvə Hyala va dzaa səəkə, sa ka məndi məntəŋəy batem, nə ghwəy. A ntsaa gəzaŋwəy tsəgha na kə kia? ");
INSERT INTO bcw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mbaꞌa pə ghwəy ɗi mbəliŋwəyəy, ə pə ghwəy məni sləni wəzə na gar sənay məndi a ghwəy zhəghanti nzəy tsa ghwəy kataŋ kataŋ, kə məndi. Nəghətaa ghwəy taa zəzəti na: “A ghəy dzaa mbəliŋəy sa nza *Abəraham vaa jijiŋəy” pə ghwəy ma. Ma na Hyala nanzə e gəzaŋwəyəy, a bərci və ta zhəghəti ya hərezli nashi ghwəy ni ka ndərazhi Abəraham. ");
INSERT INTO bcw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ə gəzaŋwəy ya, ndəkwə na ngwəvə Hyala nanzə ki, njasa ka tsəꞌi vaa nza mbəzə mbəzə ta kəəsli fəhiy dzaa ya ma ya wəzə na gwanashi, ta ndəti ghwə ti shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma sa gəzəkə Zhaŋ tsəgha, ma kə mbəzliy ɓasəkəvashi va kaa ngəci na: «Njaa dza ghəy məni sana kia Zhaŋ?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma kə Zhaŋ ngəshi na: «Ma pə ghwəy məntiy, ntsa nza kwəbeŋer və bakəy, ə kə tanavə tsahwəti kwətiŋ kaa ntsa kama na və. Ntsa nza shi zəmə və ɓa na, ka təhəshi ghəci lə mbəzli kama ghəshi və shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dzəghwa ka *dəwan kwərakwə mbaꞌa ghəshi səəkəshi ta mbə Zhaŋ mananshi batem. Sa səəkəshi ghəshi na, dza ghəshi ka ɗəw kwəma va Zhaŋ, ma kə ghəshi na: «A Metər, njaa ka ghəy məni na ghəy kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma kə Zhaŋ kaa ngəshi na: «Ghwəy mbə sləni ghwəyəy, əntaa ghwəy papa shiy va mbəzli ma, war njasa gəzaŋwəy ngwəmna tsəhə shiy va mbəzli pə ghwəy dzaa tsəhəshi» kə kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dza ka sawji kwərakwə, mbaꞌa ghəshi səəkəshi, ka ɗəw və tsəgha ɓa, ma kə ghəshi na: «Njaa dza ghəy məni na ghəy kia?» kə ghəshi. Ma kə Zhaŋ ngəshi na: «Əntaa ghwəy zlighwə gəna va mbəzli lə bərci ma, əntaa ghwəy dzaa slasla dzərvəə dzəkən mbəzli ma. Ta na ghwəy va zhəmə waŋwəy məndi pə ghwəy vəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ya wa ndəy, mbə ndəghə səəkə tsa *Kəristəw Ntsa tivə Hyala niy nzana. Ma sa nata məndi kwəma məni Zhaŋ ki na, ghəci dza Kəristəw tsa vaa nza bərkee, kə mbəzli kaa kwəma təkə ghəshi mbə ghən shi. ");
INSERT INTO bcw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma kə Zhaŋ kaa ngəshi gwanashi ki na: «Yən na neyey, lə yam ngəri məniŋwəy ya batem. A tsahwəti ntsaa taŋətəra tə dikə tiɓa dzaa səəkə. Ntsa vay, məniree gar gələɓə ta pəli yiɗi mbə kwakwahə tsa mbə səɗa ciw. Na naciy, lə *Safə tsa Hyala, mbaꞌa lə ghwə dza naa səəkə ta məniŋwəy batem. ");
INSERT INTO bcw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sa ka na səəkəyəy, ta məni ngwəvə dza naa dzəkən mbəzli. Ngwəvə ci vay, njasa ka ndə vaa pəhə ha lə kwakwa gaga ta dəvə ci dza naa məni. Ma sa ka na pəhamti na, mbaꞌa ɓasaghwa ha ci kwa tamə, ma davəna na mbaꞌa ndamti mbə ghwəə dzaa məti ma ya paꞌ hwəmɓa» kə Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ava tsəgha niy gəzanshi Zhaŋ Yəwən kwəma wəzə na kaa mbəzli, ka tsəhanshi səətiy dzəghwa sləmə shi lə kwəma ghənghən ghənghən ta mbə ghəshiy zhəghanti nzəy tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dza Zhaŋ tə nahwəti vici mbaꞌa gəzanakə kwəma kaa ngwəmna Erədəə dzəkən kwəma mənti na gəmgəm na. Ə niy ɓəhwə Erədə mali zədəy, Erədiyadə, kə məndi kaa slən tsa mali va. Zhini mbaꞌa niy mənti nihwəti shi gəmgəm ni ɗaŋ diɓa. Va tsəgha niy nə Zhaŋ, shi wəzə ni na shi mənti gha vaw, kə kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma sa gəzanakə Zhaŋ kwəma va kaa Erədə tsəgha na, mbaꞌa nəfə tsa ci satiy, dza na mbaꞌa faghwa Zhaŋ kwa fərshina. Zhini mətsəhə mətsəhəti liɗi kwəma tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zhaŋ ghwəla ta dzəghwa fərshinay, mbəzli ɗaŋ niy səəkə na və, ka mananshi batem ghəci. Ma tə nahwəti vici na, dza Yesəw mbaꞌa səəkəy va Zhaŋ, mbaꞌa Zhaŋ mananati batem kwərakwə. Ma Yesəw mbə cəꞌwə na, gwəravə ghwəmə tsəgha ɓəŋ ghwənita. ");
INSERT INTO bcw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dza *Safə tsa Hyala ɗewɗew tsa ka səəkə mə ghwəməə dzəkən, njəꞌwə pə gha na, ndəɓa vəgha ghərpəpə, pə gha. Fa məndi na, məli ndəə gəzə kwəma səəkə mə ghwəmə, a kə na: «Gha na Zəghwee, tərəŋw ɗiŋee, mbə vəshi nzee dalala tə gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma gha Yesəw gha sləni Hyalay, mahkan mətsəkə niy nza piya ci. Ma dəy tə bərkə nzəy, *Zhezhefə na, ma Zhezhefə na, zəghwə Eli, ");
INSERT INTO bcw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli na, zəghwə Matatə, Matatə na, zəghwə Levi, Levi na, zəghwə Meləki, Meləki na, zəghwə Zhanay, Zhanay na, zəghwə *Zhezhefə, ");
INSERT INTO bcw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zhezhefə na, zəghwə Matatiyasə, Matatiyasə na, zəghwə Aməsə, Aməsə na, zəghwə Nahwəm, Nahwəm na, zəghwə Ezəli, Ezəli na, zəghwə Nagay. ");
INSERT INTO bcw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay na, zəghwə Matə, Matə na, zəghwə Matatiyasə, Matatiyasə na, zəghwə Sheməŋ, Sheməŋ na, zəghwə Zhəsəkə, Zhəsəkə na, zəghwə Zhəda, ");
INSERT INTO bcw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zhəda na, zəghwə Zhəwanan, Zhəwanan na, zəghwə Resa, Resa na, zəghwə Zhərəbabel, Zhərəbabel na, zəghwə Salatiyel, Salatiyel na, zəghwə Neri, Neri na, zəghwə Meləki, ");
INSERT INTO bcw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meləki na, zəghwə Adi, Adi na, zəghwə Kwasam, Kwasam na, zəghwə Eləmadam, Eləmadam na, zəghwə Er, ");
INSERT INTO bcw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er na, zəghwə Yesəw, Yesəw na, zəghwə Eliyezer, Eliyezer na, zəghwə Zhewrim, Zhewrim na, zəghwə Matatə, Matatə na, zəghwə Levi, ");
INSERT INTO bcw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi na, zəghwə Shimeyaŋw, Shimeyaŋw na, zəghwə Zhəwda, Zhəwda na, zəghwə *Zhezhefə, Zhezhefə na, zəghwə Zhənam, Zhənam na, zəghwə Eliyakim, ");
INSERT INTO bcw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim na, zəghwə Meleya, Meleya na, zəghwə Mena, Mena na, zəghwə Matata, Matata na, zəghwə Natan, Natan na, zəghwə *Davitə, ");
INSERT INTO bcw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davitə na, zəghwə *Zhese, Zhese na, zəghwə ꞌWəbetə, ꞌWəbetə na, zəghwə Bəwazə, Bəwazə na, zəghwə Sala, Sala na, zəghwə Nashən, ");
INSERT INTO bcw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashən na, zəghwə Aminadabə, Aminadabə na, zəghwə Adəmin, Adəmin na, zəghwə Arni, Arni na, zəghwə Esərəm, Esərəm na, zəghwə Peresə, Peresə na, zəghwə Zhəwda, ");
INSERT INTO bcw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zhəwda na, zəghwə *Zhakwapə, Zhakwapə na, zəghwə *Izakə, Izakə na, zəghwə *Abəraham, Abəraham na, zəghwə Tera, Tera na, zəghwə Nahwər, ");
INSERT INTO bcw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahwər na, zəghwə Serəgwə, Serəgwə na, zəghwə Rewə, Rewə na, zəghwə Pelegə, Pelegə na, zəghwə Eber, Eber na, zəghwə Shela, ");
INSERT INTO bcw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela na, zəghwə Kaynan, Kaynan na, zəghwə Arfakəsadə, Arfakəsadə na, zəghwə Shem, Shem na, zəghwə *Nəwe, Nəwe na, zəghwə Lamekə, ");
INSERT INTO bcw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekə na, zəghwə Matəsalem, Matəsalem na, zəghwə Henəkwə, Henəkwə na, zəghwə Zharet, Zharet na, zəghwə Malelelə, Malelelə na, zəghwə Kaynan, ");
INSERT INTO bcw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynan na, zəghwə Enəsə, Enəsə na, zəghwə Setə, Setə na, zəghwə *Adam, Adam na, Zəghwə Hyala. Ava tsəgha na jijihiy Yesəw njasa nza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ma ləy hwəm sa mananati məndi *batem kaa Yesəw kwa həl Zhərdeŋ ki na, mbaꞌa zhəghəkəvay, paf nəfə tsa ci təhəy va *Safə tsa Hyala ɗewɗew tsa. Dza Safə tsa va, mbaꞌa pəməghə dzəmbə gamba. ");
INSERT INTO bcw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hi faɗə mətsəkə ghəci mənti mbə gamba va, war mbə həərə *ndə jaka tsa Hyala. Səəkə shi zəmə kwa miy ci nehem mbə hi tsa va gwanayəw. Ma lə hwəm sa kərəta vici faɗə mətsəkə na va ki na, mbaꞌa ma ꞌwati ghəranci. ");
INSERT INTO bcw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma kə ndə jaka tsa Hyala kaa ngəci na: «Ndata Zəghwə Hyala nza ghay, gəzanci kaa hakwə tsa, a ghəci zhəghəy ka shi zəmə, a gha zəməshi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma kə Yesəw kaa zləɓanci na: «Ma kə kwəma tsasliti məndi mbə Zliya Hyalay: “Ka nzəyəy ndə tə hiɗi kwataka lə shi zəmə gwaꞌa tsəghaw” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sa nay ndə jaka tsa Hyala shaŋ ghəci ta mbay Yesəw dza kwa nava bəla na, dza na pəm pəməghə dzəmə pətsaa gwəramti yakəyakə. Sa pəməghə na na dza na nzaꞌjəw, canamti məlməhi tə hiɗi gwaꞌa gwaꞌa lə mezhizhəy sləkəshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ma kə ngəci na: «War mbaꞌa pə gha tsəfəkwəŋa kwa kwəma yay, ta ndaŋa kwal tsaa sləkə məlməhi va, lə shi mbə shi va dzee, mbə dəvə gha dza ghəshiy nza gwaꞌa gwaꞌa. Sa nzana shi va gwanashiy, kaa ngəra ndarashi məndi mbə dəvee. Yən kwərakwəy, e mbay ɓanavəshi kaa ntsa ɗee ɓanci shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma kə Yesəw kaa ngəci na: «Ma kə kwəma tsasliti məndi kwa Zliya Hyalay: “War kwa kwəma Hyala gha sləkəŋa, pə gha dzaa tsəfəkwə, war kaa ngəta pə ghaa ghəra sləni kwətita ya hwəmɓa” kə məndi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma sa nay ndə jaka tsa Hyala shaŋ ghəci ta mbay Yesəw dza kwa nava bəla diɓa na, dza na mbaꞌa pəməghə Yesəw dzəmbə məlmə Zherəwzalem, mbaꞌa pəməghə dzəmə ghən *ciki Hyala. Ma kə kaa Yesəw na: «Ndata Zəghwə Hyala nza ghay, ndəɓəvaa dzəghwaa dzəti hiɗi. ");
INSERT INTO bcw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sa nzanay a məndi tsasliti kwa Zliya Hyala: “Ta ghwənikə ka kwal nzə dza Hyala ta səəkə ta ndəghwəŋa” kə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma kə məndi diɓay: “Ma nza ghəshi kaꞌwəŋa lə dividivi shi va nəghətaa hakwə gwəlahantaa tə səɗa gha” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma kə Yesəw ngəci na: «A Zliya Hyala gəzəkə diɓa, a kəy: “Əntaa gha dzəghə nighə kwəma Hyala gha sləkəŋa ma” kə məndi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ma sa kəɗamti ndə jaka tsa Hyala dzəghə həərə Yesəw lə tsəhwəli ghənghən ghənghən ɗaŋ tsəgha ki na, dza na, mbaꞌa dzay tə nava vici di, ta ndəghə nahwəti vici. ");
INSERT INTO bcw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma ləy hwəm kwəma va ki na, dzəghwa Yesəw mbaꞌa zhəghəghəvay zhiti hiɗi ka Galile. Paf nəfə tsa ci təhəy lə bərci ɓanavə *Safə tsa Hyala ɗewɗew tsa. Dzəghwa zləŋ məlmə slən tsa ci dzay. ");
INSERT INTO bcw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","War ə ghəciy ɓəni kwəma Hyala kaa mbəzli dzar mbə ceker ɓasəva *ka Zhəwifə, ka fal mbəzli gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dzəghwa Yesəw mbaꞌa dzay dzəmbə məlmə Nazaretə, məlmə kəli na mbə. Ma sa səəkəta *vici dəkəva ka Zhəwifə na, dza na mbaꞌa dzəmbəy dzəmbə *ciki ɓasəva tsa shi va, njasa sənaɓəy na mbə dzəmbə. Ma sa tsəhəy na, mbaꞌa garəy ta jangə Zliya Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dzəghwa mbaꞌa məndi vəlanavə zliya tsasliti *Ezay ndə gəzə kwəma Hyala. Ma sa ɓəvə na na, mbaꞌa palamti, dza na mbaꞌa kəsata kwəma mbəɓa tsasli tsasli naa dzəkən ghən tsa ci. Kə ka jangə kwəma va, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«A *Safə tsa Hyala kənee, ə tsəhavəra na ta gəzanshi Yəwən kwəma wəzə na kaa ka ndərma. Ə ghwənara na ta gəzanshi pəli tsa shi kaa mbəzli kwa fərshina, lə ta ghwənanamti mətsəhi ghwəlefesli. Zhini mbaꞌa ghwənara ta mbalamti mbəzli sanshim ngəraꞌwə. ");
INSERT INTO bcw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mbaꞌa ta gəzanshi kaa mbəzli, nza ghəshi mbəə sənay, a vəghwə tsa dza Hyalaa mbəlishi ti səəkəy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ma sa jangamti Yesəw kwəma va tsəgha na, dza na mbaꞌa zhiniy paray zliya va. Mbaꞌa ɓanavə kaa ntsaa ghəra sləni mbə ciki ɓasəva tsa va. Ma sa ɓanavə na na, das nzəyəy mənzəy ta ɓananshi shiy. Mbəzli tiɓa ghalaɓa mbə ciki ɓasəva tsa va gwanashi na issə, ghəshi fati mətsə tə Yesəw, ka nighə. Ka ndəghə kwəma dza na ta gəzanshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dzəghwa ki, ma kə Yesəw ngəshi na: «Kwəshala tə zliya na na jangəhwee sənzənvay, a nava kwəma mənta ndatsə. Ghala pətsaa fa ghwəy va yən mbə jangə məniva na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma sa favə ghəshi kwəma gəzəkə Yesəw va na, tərəŋw ghənzə təɓanatishi gwanashi. Ma kə ghəshi na: «Kay, kwəma gagaa nava kwəma wəzə tsa nzəw, zəghwə *Zhezhefə va sasa tsəy?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma kə Yesəw ngəshi na: «Ka dza ghwəy bashəhwə gəzəkəra kwəma nja kwa fir taa nzaw. Ma dza ghwəy niy: “A ndə mbəlipə, ca mbəliti ghən tsa gha kwərakwə kəshi” dza ghwəy ni. Zhini a pə ghwəy taa ni ngəra diɓa na: “Ya gəla shiy mənəhwə gha va tə hiɗi ka Kapernahwəm, favə ghəyəy, məntishi tsəgha tikə mbə na gha na məlmə kwərakwə di” dza ghwəy ni» a kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Zhəghwa, ma kə ngəshi diɓa na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ndə tiɓa ya kwətiŋ mbə ka gəzə kwəma Hyala mbaꞌa məndi zləɓati kwəma ci, ka fə bamaa dzəti mbə məlmə yakə məndiw. ");
INSERT INTO bcw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Zhini diɓa e gəzaŋwəy kwagwaꞌay, mbəradzə ghala vəghwə tsa *Eli ndə gəzə kwəma Hyalay, ɗaŋ niy nza miꞌi mbəreketi tə hiɗi ka *Izərayel. Ghalaɓay, tərəŋw niy nza ma tə hiɗi va, sa niy nzəməy ma van mbə piya mahkan mbaꞌa tir kwaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ya tsəgha niy nza miꞌi mbəreketi tə hiɗi ci va ɗaŋ mbə may, niy ghwənəghə Eli Hyalaa dzakə ghi tsa nahwəti ya kwətiŋ ti shi, ta kəəti ghəciw. War dzakə ghi tsa nahwəti mali mbəriy kama tə hiɗi shi, niy ghwənəghə na Eli. Mali vay, mbə məlmə Sarepəta niy nza na, tə hiɗi ka Shidaŋw. ");
INSERT INTO bcw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ya ghala vəghwə tsa ndə Hyala Elizhe kiy, ɗaŋ niy nza ka dərna tə hiɗi ka Izərayel ghəshi ni ci hiɗi. Ya tsəgha niy nza ka dərna ɗaŋ tə hiɗi ci vay, niy mbəlanti tsahwəti Elizhe ti shi ya kwətiŋəw. War *Naaman, tsahwəti ndə dərna tsaa səəkə tə hiɗi Shiri na saa niy mbəlanti na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma sa favə mbəzliy ɓasəshi va mbə ciki ɓasəva tsa va kwəma gəzə Yesəw va tsəgha na, mbaꞌa nefer shi satishi gwanashi mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dza ghəshi rəərə ghəshi satishi, tasl ghəshi kəsəvə Yesəw, ka mbahəə səvəri mbə məlmə, sa mbahəkəvəri ghəshi na, mbaꞌa ghəshi dzəməshi liy dzəti ɗal pətsa ləy ghəshi va məlmə shi va ti. Ta mbə ghəshiy tsəkway səəkə mə pətsa vaa dzəti ngwəla, ta məti ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma dza Yesəw naci ki na, liweɗ səvəriy mbə shi, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dzəghwa Yesəw mbaꞌa dzay dzəmbə məlmə Kapernahwəm, tə hiɗi ka Galile. Sa tsəhəy na mbəɓa na, dza na ka ɓəni shiy ghəci kaa mbəzli mbə *ciki ɓasəva tsa ka Zhəwifə fəca *vici dəkəva. ");
INSERT INTO bcw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma mbəzli tiɓa ki na, mbaꞌa shi ɓananshi na va səəvəri məhərli shi. Sa nzana lə bama ti ghəci gəzə kwəma kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mbaꞌa tsahwəti ndə niy nza tiɓa mbə ciki ɓasəva tsa va, lə gazlaka ꞌyahəꞌyahə na mbə ghən ci. ꞌWakəvə ntsa va tsəgha tapə ta ꞌwaŋə, zlaŋzlaŋ, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«A Yesəw, ndə ka Nazaretə tsa, ta njaa ɗi gha lə ghəya? Ta zantəŋəy səəkə gha shəkəna? Ma na neyey, e sənaŋa wəzə. Ghay, ntsa ɗewɗew tsa ghwənay Hyala nza gha!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dza Yesəw mbaꞌa ꞌyamanakə cihə kaa gazlaka mbə ghən ntsa va va, ma kə na: «Ɗekəɗekə pə gha. Ə pə ghaa səvəri mbə ghən zal tsa, mbala kərakə» kə. Ma sa gəzəkə Yesəw kwəma va tsəgha na, ꞌwakəvə gazlaka va tsəgha, mbəriv fati zal tsa va tə pi tiɓa kwa kwəma mbəzli gwaꞌa. Mbaꞌa səvərita mbə ghən ntsa va. Shaŋ ta mananati shiy kaa ntsa va gar zhanci ghənzə mbə səvəri mbə ghən ci. ");
INSERT INTO bcw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ma sa nata mbəzliy nza tiɓa gwanashi nava kwəma ki na, mbaꞌa mananatishi maɗaŋa. Dza ghəshi ka gəgəzə kwəma kwa jipə shi, ma kə ghəshi na: «Wa slən tsa na tsətsə na na kwəma kia? Njaa mbay tsatsa ndəə gəzanakə kwəma kaa gazlaka lə gwəlaŋ, dza mbaꞌa hwəta səvəri mbə ghən ndəə zlayaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dzəghwa ki war kwəma Yesəw məndiy sla tə hiɗi va gwaꞌa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ma sa dza Yesəw na, mbaꞌa səvəriy ghalaɓa mbə ciki ɓasəva tsa va, mbaꞌa dzay dzakə ghi tsa Shimaŋw. Dzakə na na, shiy Shimaŋw tiɓa gwərapəta dalala məhəni, ndəɓa ghwə, pə gha vəgha nzə. Dza mbəzli ka cəꞌwə Yesəw a ghəci mbəlanti. ");
INSERT INTO bcw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ꞌWakəvə Yesəw ki, gəlaŋ gəlaŋəy kən mali va. Dza na ka gəzanci kwəma ghəci kaa zəlghwə tsa va lə gwəlaŋ, a ghəci səvəriy mbə vəgha mali va. Sa gəzanakə Yesəw kwəma tsəgha na, dza zəlghwə tsa va mbaꞌa səvəriy mbə vəgha mali va. War ghwəla tsəgha na, nzaꞌjəw ghənzə kafəta ka dza ta ɓanshi shi zəmə. ");
INSERT INTO bcw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma sa pəkwəta vici ki na, dzəghwa məndi ɓasə ɓasə məndi ɓasanakə nihwəti ka zəleghwer ghənghən ghənghən. Dzəghwa Yesəw, mbaꞌa fafanakənshi dividivi ci kwətiŋ kwətiŋ tsa shi gwaꞌa. Dza ghəshi, kwəriŋ kwəriŋ ghəshi mbəlishi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɗaŋ gezlekiki səvərishi mbə ghən ka gezlekiki ɗaŋaŋ mbə mbəzli va, kala ngwəmə lala ghəshi mbə səvəri. Ma kə ghəshiy ni na: «Gha na Zəghwə Hyala. Gha na Zəghwə Hyala» kə ghəshiy ni. Ka Yesəw dza na, ka naɓəshi lə gwəlaŋ. A ghəshi catavashi kala gəzə ma kwəma. Sa nzana, ma gezlekiki va na nashiy, a ghəshi sənay ghəci na *Kəristəw Ntsa tivə Hyala, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma tə way pi mekəshi na, mbaꞌa Yesəw kafəy səvəriy mbə məlmə Kapernahwəm, ka dzay dzəti gamba kərakə lə mbəzli. Dza mbəzli ɗaŋaŋ, mbaꞌa ghəshi kafəshi, ka papala, dza ghəshi ndəs ghəshi kəsay. Ma sa kəsay ghəshi tsəgha na, kala zhini ghəshiy ɗi ghəciy zlashi ta dzay ghwəla. ");
INSERT INTO bcw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma kə Yesəw kaa ngəshi naci ki na: «Wəzəɓa dzee na ta gəzanshi Yəwən kwəma wəzə naa dzəkən sləkə tsa dza Hyala ta sləkə mbəzli, kaa mbəzli mbə nihwəti məlməhi kwərakwə. Sa nzanay, ghənzə na kwəma ghwənikəra Hyala ti» kə. ");
INSERT INTO bcw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dza na mbaꞌa dzay, ka gəzanshi kwəma Hyala kaa mbəzli dzar mbə ceker ka *ka Zhəwifəə ɓasəva tə hiɗi ka Zhəwde. ");
INSERT INTO bcw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ma tə nahwəti vici na, mbaꞌa Yesəw səvəriy garəy tə həlbə tsa miy kwəfa *Zhenezaretə. Dza mbəzli, ɗaŋ ghəshi ɓasəkəvashiy dzəvəgha. Dza ghəshi ka tsətsəkwəva ta nza ndəkwə vəgha, ta fa kwəma Hyala gəzə na va. ");
INSERT INTO bcw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsaꞌ kə Yesəw na, mbaꞌa nashi kwambəwaler bakə tə pətsa va vəgha həlbə. Ə niy səəməshi ka kəəsə kərpi kwa shi, mbaꞌa ghəshi niy dzashi ta yaɓə zlekwer shi. ");
INSERT INTO bcw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dza Yesəw ki, mbaꞌa dzay dzəghwa nahwəti kwambəwal va, sa Shimaŋw ghənzə. Ma kə ngəci na: «A Shimaŋw, katata kwambəwal gha naa jəw dzar dzəti yam di» kə kaa ngəci. Dza Shimaŋw mbaꞌa dzəghwaa katata. Mbaꞌa Yesəw nzəyəy kwa, dza na mbaꞌa ghati gəzanshi kwəma kaa mbəzli ki. ");
INSERT INTO bcw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma lə hwəm sa kəɗiy na lə gəzə kwəma kaa mbəzli ki, ma kə kaa Shimaŋw na: «Ca mbala, kətəghə kwambəwal gha naa dzar dzəti hwər kwəfa, nza ghwəy pəəli zlekwer ghwəy, a ghwəy ndaghashiy dzəghwa kwəfa, ta ka kərpi njasa nza ghwəy va kwa zəərə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma kə Shimaŋw ngəci na: «A Metər, ava ghaa nay mbə ka kərpi hi ghəy virvirvir, kəsəvə sə ghəy ya waɓaw. E ma njana nzana gha gəzəkəray, kadiw a ghəy zhiniy pəli zlekwer ghəy zhimbə kwəfa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dza ghəshi ki mbaꞌa ghəshi katatavashiy dzəti hwər, ka pəpəli zlekwer shiy dzəmbə kwəfa, ka ka kərpi. Dzəghwa tərəŋw ghəshi kavə kərpi, paꞌ ka ɗi slikwə zlekwer shi va ɗaŋ tsa kərpi. ");
INSERT INTO bcw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sa nashi ghəshi tsəgha na, dza ghəshi mbaꞌa ghəshi təhwaɗashi nihwəti madigahishi kwa nahwəti kwambəwal ta kəətishi. Ndəs niva mbəzli səəkəshi. Dza ghəshi tiɓa ki ka pa kərpiy dzəghwa kwambəwaler bakə ni va. Paf paf ghəshi tahayshi lə kərpi bakanashi, paꞌ ka ɗi ndava kwambəwaler vaa dzəmbə yam, va shəndəkə tsa kərpi, gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma sa nay Shimaŋw Piyer tsəgha na, dza na gələɓ gələɓəy shinin ci mbə hiɗi kwa kwəma Yesəw. Ma kə kaa ghəci na: «A Ntsaa sləkəra, katantəvaŋa vəghee, sa nzanay, ndə məni *kwəma jikir na nzee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ma Shimaŋw kiy, tərəŋw niy dzashi her ci, lə mbəzli va ta gwaꞌa, va kwəma kərpi kəəsəvə ghəshi va ɗaŋ ni tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ndərazhi Zhebede, kar Zhakə lə Zhaŋ kwərakwə na, tsəgha her shi dzashi. Mbəzli bakə ni vay, ghəshi lə kar Shimaŋw niy nza na mbə sləni shi kwa zəərə kwətiŋ na. Ma kə Yesəw kaa Shimaŋw ki na: «A Shimaŋw, ka dza her gha ma. Ghala ndatsə e gəzaŋay, ka zhini ghaa nzaa ndə kəəsə kərpiw. Ndə dza ta haka mbəzli səəkə ta nəwra dza ghaa nza» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma sa favə ghəshi tsəgha ki na, dza ghəshi mbaꞌa ghəshi pakəmə kwambəwaler shiy dzəti həlbə. Mbərəkə ghəshi zlashi tiɓa, lə shi və shi gwaꞌa. Mbaꞌa ghəshi nəwhwə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma tə nahwəti vici na, mbaꞌa Yesəw tsəhəy mbə nahwəti məlmə. ꞌWakəvə tsahwəti ndə tiɓa mbaꞌa tsahwəy, war dərna vəgha ci. Dza na mbaꞌa nay Yesəw. Ma sa nay na Yesəw tsəgha na, dza na, mbaꞌa səəkəə tsəfəkwəy kwa kwəma ci, lə kwəma ci mbə hiɗi, ka pəraꞌwanci dəvə. Ma kə na: «A Ndə sləkəpə, war mbaꞌa pə ghaa ɗi sənzənvay, a ghaa mbəlantəra ɗewɗew va dərna kənee na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma sa gəzəkə na tsəgha na, dza Yesəw, kaf kafəti dəvə ci, mbaꞌa dapay. A kə ngəci na: «E ɗi ghaa mbəliŋa, mbəliŋa kwəriŋ» kə. Nzaꞌjəw dərna va səraɓəta ti. ");
INSERT INTO bcw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A kə Yesəw kaa ngəci sa mbəliy na na: «Əntaa gha gəzə kwəma məntəŋee na ya kaa wa ma. Mbala tsərə, a gha dzaa canati ghən tsa gha njasa mbəliŋa gha kaa ndə ta Hyala. Nza gha dzaa vəliti vəli gha kaa Hyala njasa gəzəkə *Məyizə va, nza mbəzli mbəə sənay gwanashi, a gha mbəliŋa va dərna tə gha, kə ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma ghalaɓa ki na, war ə mbəzliy mətsəhə sla kwəma Yesəw dza kwa kwəma kwa kwəma dzar mbə mbəzli gwaꞌa. Ka mbəzliy dza na, ka ɓasəvaa səəkə ɗaŋ, ta fa kwəma ɓənipə na, lə ta mbə ghəciy mbəlitishi va zəleghwer shi. ");
INSERT INTO bcw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka Yesəw dza na, mbaꞌa səvəriy mbə məlmə, ka dzay dzəti gamba kərakə vəgha mbəzli, ta cəꞌwə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma tə nahwəti vici na, dza Yesəw ka ɓananshi kwəma Hyala kaa mbəzli mbə tsahwəti ciki. Dza *ka Farisahi lə *ka ɓənipə kwəma pəhəti Hyala mbə *ka Zhəwifə, mbaꞌa ghəshi ɓasəkəvashi səəkə dzar mbə məlməhi ghənghən ghənghən tə hiɗi ka Galile, lə tə hiɗi ka Zhəwde, mbaꞌa səəkə mbə məlmə Zherəwzalem gwaꞌa. Sa səəkəshi ghəshi na, mbaꞌa ghəshi nzəyshi vəgha Yesəw. Bərci Hyala ki na kwasəbə Yesəw ghənzə niy nza, ka mbəli ka zəlghwə ghəci lə bərci va. ");
INSERT INTO bcw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma ləy hwəm jəw na mbaꞌa nihwəti mbəzli ɓəkə tsahwəti ndə tə pi həni tsa ci, sa nza nahwəti bəla vəgha ci məti məti. Dza ghəshi ka pəla kwal tsaa ɓəghə dzəmbə ciki tsa va ta mbay ghəshiy fəy kwa kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Shaŋ ghəshi ta kwəmavə kwal gar dzəmbəshi ghəshi li, va ɗaŋ tsa mbəzliy ɓasəshi tə pətsa va. ꞌWakəvə ghəshi tsəgha tsaŋ ghəshi ɓəvə, dza taram ghəshi dzəməshi li mə ghən ciki tsa va, sa tsəti məndi nja beela. Dza ghəshi mbaꞌa ghəshi tsahwati kwal ti. Sa tsahwati ghəshi kwal na, mbaꞌa ghəshi vələghə ntsa va tə pi həni tsa ci dzəghwa tə jipəjipə mbəzli dzəghwa səɗa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma sa sənay Yesəw a mbəzli va ndara nefer shi gwanashi, kə, ma kə kaa ntsa shaw tsa va ki na: «A madiga, a kwəma gha jikir na pəlita!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","War sa favə *ka ɓənipə kwəma pəhəti Hyala lə ka Farisahi nava kwəma tsəgha na, mbaꞌa ghəshi dzəmbəshi mbə təkə kwəma, ma kə ghəshi mbə ghən shi na «A tsatsa ntsaa sawa Hyala tsa shəka? Wa tsava ntsaa dza vaa mbay pəlatanay kwəma ndə jikir na tiɓa kala war Hyala kwətitaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Yesəw naci ki na, gwaꞌa gwaꞌa ghəci sənata təkə kwəma mbə ghən shi. Ma kə kaa ngəshi na: «A mbəzli ni, tawa tətəkə ghwəy kwemer tsətsə ni mbə nefer ghwəya? ");
INSERT INTO bcw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nama kwəma gwəra na ɓəlaŋ, ta ndə kə ni: “A kwəma gha jikir na pəlita” kə, lə ndə ni kaa ndə zəlghwə: “Sati garəŋa a gha dzaŋa” kəa? ");
INSERT INTO bcw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma kiy, e ɗi ghwəy sənay, a bərci vəya yən Zəghwə yakə ndə ngəri tikə tə hiɗi ni, ta pəlanshi jikir tsa mbəzli, pə ghwəy» kə. Dza ma kə kaa ntsa mətita bəla vəgha ci va na: «A ntsa, avee gəzaŋa sənzənva, sati, maɗi ɓə pi həni tsa gha, mbalaa jighi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","War sa gəzəkə Yesəw kwəma va na, dza ntsa va tsəgha, nzaꞌjəw satiy tə hiɗi tiɓata, kwa kwəma mbəzli va gwaꞌa. Tsaŋ ɓəvə pi həni tsa ci, ka dzay jighi. War ə ghəciy fal Hyala ghəci mbə dzay. ");
INSERT INTO bcw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma sa nata mbəzli tiɓa va gwanashi nava kwəma na, ka mananshi maɗaŋa ghənzə. Dza ghəshi ka fal Hyala, mbaꞌa hazləni təhay nefer shi. Ma kə ghəshi mbə gəzə kwəma shi na: «Ndatsəy, a ghwəmmə nata kwəma maɗaŋa maɗaŋa na, nanzə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma ləy hwəm shi va ki na, dza Yesəw mbaꞌa kafəy ta dzay. Ma ghəci mbə dzay na, mbaꞌa nay ndə *dəwan mənzəy mbə ciki sləni tsa ci. Levi, kə məndi kaa slən tsa ntsa va. Ma sa nay Yesəw ki, ma kə kaa ngəci na: «Sati, nəwra dzam» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","War sa gəzanakə Yesəw tsəgha na, dza Levi pəlhəm satiy, mbərəkə zlashi shiy tiɓa gwaꞌa, ka nəw Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dzəghwa Levi mbaꞌa pəməghə Yesəw dzakə ghi tsa ci, mbaꞌa tanati shiy tərəŋw. Ɗaŋ nihwəti ka dəwan lə nihwəti mbəzli niy səəkəshi ta zəmə shi va. Ka zəmə shiy ghəshi jakə lə kar Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma *ka Farisahi lə mbəzliy ɓananshi *kwəma pəhəti Hyala mbə shi ki na, tsarakə ghəshi niy nza tə na shi bəla. Ma sa nashi ghəshi kar Yesəw tsəgha mbə zəmə shiy lə mbəzli va na, mbaꞌa zhanatishi kwa hwər shi. Ma kə ghəshi kaa *mbəzli ta səɗa Yesəw na: «Tawa zəmə ghwəy shiy ka sa shiy jakə lə ka dəwan mbaꞌa nihwəti mbəzliy məni sləni jikir naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma kə Yesəw kaa zləɓanshi na: «A mbəzli ni, səəkee nashi mbəzli kwəriŋ kwəriŋ vəgha ni mbə dza va dəkwətərəw, war ka zəlghwə na shi kee nashiy dza və. ");
INSERT INTO bcw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ava va tsəgha na kiy, yən neyey, ta pəla mbəzli wəzə ni səəkə yaw, ta pəla mbəzliy məni sləni jikir na səəkəree, ta mbay ghəshiy tsa titihwə kaa Hyala, ka zhəghə nzəy tsa shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma ləy hwəm sa gəzəkə Yesəw tsəgha ki, ma kə nihwəti mbəzli mbə shi kaa Yesəw na: «Mbəzli ta səɗa Zhaŋ ghəshi lə mbəzli ta səɗa *ka Farisahiy, kar ghəshiy tivə vici, ka məni səwmay ka cəꞌwə Hyala. Ya ni gha ni *mbəzli ta səɗa gha kiy, wa shiy mənishi məni ma ghəshi tsəgha, nza na war shiy ghəshiy zəmə, ka sa shiy ya hwəmɓaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma kə Yesəw kaa zləɓanshi na: «A pə ghwəy favə kwəma dzee na ta gəzaŋwəy. Mbaꞌa kə ndə harvə mbəzli ta zəmə gəzləɓə mətəpa na, mbaꞌa mbəzli va dzaa tivə vici va ka vici məni səwmay shəkəna? Ka dza ghwəy mbay makətishi va zəmə shiy, kama zal mali tsa va ghwəlay mbə shiw. ");
INSERT INTO bcw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma kiy, a tsahwəti vəghwə dzaa səəkəy, ghala pətsa dza məndi vaa ɓanti ndə mətəpa kwa jipə shiy, ghalaɓa dza ghəshiy məni səwmay ki» kə. ");
INSERT INTO bcw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dza Yesəw mbaꞌa ɓəlanakəshi tsahwəti fir diɓa, ma kə na: «Ndə tiɓaa sləkwə kwəbaŋ tsa yəwən tsa, ta dza ta mbəghəə dzəti tsaa haliyəw. Sa nzana, mbaꞌa kə ndə mənti tsəghay, liɗiy laɗamti ndə tsa yəwən tsa va kwəbaŋ gəməy. Zhini diɓa na, ka dza kəjer tsa yəwən tsaa jakəshi, lə tsa halihali tsaw, ta slikwəshi dza ni halihali ni shiy. ");
INSERT INTO bcw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ava tsəgha na diɓa, ndə tiɓa ka ꞌyaghwa tay tsa njəmnjəm tsaa dzəghwa ghwəlpə halihali naw. Sa nzana, mbaꞌa kə ndə mənti tsəghay, sa ka tay tsa va maɗiy ta pəsli na, ta wənəhəta dza pəhal ghwəlpə va, ka tay dza na, naꞌi shəkəy dzəti hiɗi gəm. Shi dza məndiy mənivə lə ghwəlpə va tiɓa ghwəla kiw. ");
INSERT INTO bcw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Va tsəgha, ma təɓə na kiy, dzəghwa yəwən ghwəlpə təɓə na məndiy i tay tsa njəmnjəm tsa kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ndə tiɓa dzaa zləɓa sa tay tsa njəmnjəm tsa, sahwə ma na tsa pəslipəsli tsaw. Ta na navay, kar məndiy gəzə: “Wəzəɓa tay tsa pəslipəsli tsa na kaa tsa njəmnjəm tsa” kə məndiy ni» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ma tə nahwəti vici, fəca vici dəkəva ka Zhəwifə na, ka taŋə kar Yesəw lə mbəzli ta səɗa ci dzəvəri mbə vəh alkamari. Ma ghəshi mbə dza va na, dza mbəzli ta səɗa ci va ka slərɓə alkamari va, ka zəmə. ");
INSERT INTO bcw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma sa nashi nihwəti mbəzli mbə *ka Farisahi mbə məni tsəgha, ma kə ghəshi kaa ngəshi na: «Tawa dzəmbəŋwəy ghwəy mbə məni shi makəmmə *kwəma pəhəti Hyala va məni ghwəmmə fəca vici dəkəva kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma kə Yesəw kaa ngəshi na: «Wa səəkə ghwəy jangəhwə mbə Zliya Hyalaa dzəkən kwəmaa niy mənti kar *Davitə va ghəshi lə mbəzli kwasəbə bay sa? Tə nahwəti vici sa niy ghəratishi may, ");
INSERT INTO bcw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","təhwə niy dzəmbəy Davitə mbə *ciki Hyala, dza həŋ ɓəvə peŋ tsa ka məndi ta Hyala li, mbaꞌa zəməhwə, mbaꞌa tatahanavəshi kaa mbəzli kwasəbə va, mbaꞌa ghəshi zəməhwə kwərakwə. Ya tsəgha niy nə kwəma pəhəti Hyala, ka zəmə peŋ tsa va məndi kala war *ka ta Hyalaw kəy, niy naɓəti Davitə Hyalaw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zhini ma kə Yesəw ngəshi ɓa na: «Yən sləkə na vici dəkəva, yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma fəca nahwəti *vici dəkəva diɓa na, mbaꞌa Yesəw kafəy, dzay dzəmbə *ciki ɓasəva tsa ka Zhəwifə. Sa dzəmbəy na na, dza na ka ɓananshi kwəma Hyala kaa mbəzli. Mbaꞌa tsahwəti ndə niy nza tiɓa mbə mbəzli va məti məti dəvə kwa bəzəmə ci. ");
INSERT INTO bcw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dza *ka ɓənipə kwəma pəhəti Hyala lə *ka Farisahi ki, war ka fə ghən ta Yesəw, ta nighə nda nza naa mbəli ntsa va fəca vici dəkəva, sa ɗi ghəshi ngali kwəmaa dzəkən ta mbə ghəshiy ɓanci fəti. ");
INSERT INTO bcw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mbalaa ma Yesəw naci ki na, gwaꞌa sənata na kwəma təkə ghəshi. Dza na ki, ma kə kaa ntsa məti məti dəvə tsa va tsəgha na: «Satiŋa, a gha garəŋa tiɓa tə jipə mbəzli» kə. Pəlhəm ntsa va satiy, mbaꞌa garəy məgarə tiɓa. ");
INSERT INTO bcw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma sa garəy ntsa va ki, ma kə Yesəw kaa mbəzli tə pətsa va na: «A pənəy, njaa nə *kwəma pəhəti Hyalaa? Mənim kwəma wəzə na kaa ndə fəca vici dəkəva nə na shəkəna? Naa mənim kwəma gəmgəm na nə na? Kwal tsaa mbəlanti piy tsa ndə na sa ndammə na ta naa? Naa tsaa zamti piy tsa ci na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa gəzəkə na tsəgha na, dza na mbaꞌa fati mətsə ci ti shi gwanashi ka nighəshi. Dzəghwa ma kə kaa ntsa məti məti dəvə tsa va ki na: «A ntsa təɗi dəvə gha va» kə. Dzəghwa ntsa va mbaꞌa təɗata, war sa təɗata na na, dza dəvə ci mbaꞌa mbəlita kwəriŋ tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma sa nata nihwəti mbəzli kwəma va tsəgha na, mbaꞌa nəfə tsa shi satiy tərəŋwəy. Dza ghəshi ka sləka kwəma kwa jipə shiy dzəkən shi dza ghəshiy məni lə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dza Yesəw geꞌi ghala vəghwə tsa va, mbaꞌa dzəməy mə kəlaŋ ta cəꞌwə. Dzəghwa na virvirvir key pi ghəci hyamti mbə cəꞌwə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ma sa kərəy pi na, dza na daꞌ harvə *mbəzli ta səɗa ci. Dzəghwa na təraꞌ, təraꞌ təraꞌ ghəci təravə mbəzli məŋ lə bakə mbə shi. Ma kə kaa ni təravə na va na: «Ghwəyəy ka kwalee nza ghwəy na ghwəy» kə kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Avanashi sləneɗemer mbəzli va: Shimaŋw tsa fanati na slən Piyer ghəshi lə Andəre zəmbəghəy, Zhakə, Zhaŋ, Fəlipə ghəshi lə Bartelemi, ");
INSERT INTO bcw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Təmasə, Zhakə zəghwə Alfe mbaꞌa Shimaŋw tsa har məndi: «Ndə pərslə ta hiɗi ci» ");
INSERT INTO bcw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zhəwdə zəghwə Zhakə, mbaꞌa Zhəwdasə Isəkariyətə, ntsaa dzaa nga ɗafa ta Yesəw. Ava tsəgha ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dzəghwa Yesəw ki, mbaꞌa səkway lə mbəzli təravə na va səəkə mə kəlaŋ tsa va, mbaꞌa ghəshi səkwaa garəshi tə ngwəla. Tə pətsa va, mbəzliy nəwvə kwəma ci niy nza ɗaŋ. Tiɓa nihwəti mbəzli niy ɓasəshi diɓa. Mbəzliy səəkə tə hiɗi ka Zhəwde, lə mbə məlmə Zherəwzalem, lə mbə məlməhi tə miy həl, lə ni tə hiɗi ka Tir lə Shidaŋw. ");
INSERT INTO bcw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gwaꞌa niy səəkə ghəshi. Ta fa kwəma ɓənipə Yesəw, mbaꞌa ta mbəə kwəmavə mbəlishi va zəleghwer shi niy ɓasətəvashi mbəzli va gwanashi. Lə mbəzli mananshi gazlakata niy səəkəshi na, mbaꞌa ghəshi mbəlishi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dzəghwa ya tsamaɓa ndə mbə mbəzliy ɓasəshi va na, war ka pəla kwal tsaa dapay, sa nzana, mbə səvəri bərci niy nza mbə vəgha ci ka mbəlishi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dzəghwa Yesəw njəꞌwə nighəti *mbəzli ta səɗa ci. Ma kə kaa ngəshi na: «Vəshi na tə ghwəy, ghwəy ka ndərma. Sa nzanay, ghəy na shiy dzaa nzəy mbə mbəzli sləkə Hyala tə pi kwəti mbə mazə tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Vəshi na tə ghwəy, ghwəy mbəzli mbə ma sənzənva. Sa nzanay, ghwəy na shiy dzaa ngəsliŋwəy tərəŋw. Vəshi na tə ghwəy, ghwəy mbəzli nza wahə kwa mətsəhi ghwəy sənzənva. Sa nzanay, ghwəy na shiy dzaa ꞌwəshi. ");
INSERT INTO bcw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mbaꞌa kə mbəzli kala ɗi mətsə ghwəy, mbaꞌam ndəghamtəŋwəy, ka tsəərəŋwəy, ka ndərəŋwəy, war tə sa nəwra ghwəy yən Zəghwə yakə Ndə ngəriy, vəshi na tə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","War mbaꞌa pə ghwəy nata nava kwəma mənta tsəghay, ə pə ghwəy taa vəshi ghalaɓa, ka ɓərməə dzəta ghwəmə va nava vəshi. Sa nzanay, ta ngavəŋwəy zhəmə ghwəy dza Hyala mə ghwəmə. War tsəgha niy sanshi jijihishi ngəraꞌwə kaa ka gəzə kwəma Hyala mbəradzə kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ta səəkə dza ngəraꞌwəə dzəkən ghwəy, ghwəy ka shiy. Sa nzanay a ghwəy kwəmavə tsa ghwəy wahə tikə tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A ngəraꞌwə kən ghwəy, ghwəy mbəzli bəhəbəhə ni sənzənva. Sa nzanay, ta dzəkən ghwəy dza maa dza. A ngəraꞌwə kən ghwəy, ghwəy mbəzliy ꞌwəshi sənzənva. Sa nzanay, barcicəkwə dza ghwəy nza, war lə wahə kwa mətsə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngəraꞌwə dza naa nza kən ghwəy, mbəzli kəə gəzə war kwəma wəzə wəzə naa dzar kaɓaka ghwəy. Sa nzanay, war tsəgha niy gəzə jijihishi kwəma wəzə wəzə na dzar kwa kaɓaka ka Hyala ka dzərvə mbəradzə kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Zhini ma kə Yesəw diɓa na: «Na na ghwəy, ghwəy mbəzliy fa kwəma gəzee nay, ə pə ghwəy ɗi kwəma ka jaka ghwəy, mananshim kwəma wəzə na kaa mbəzliy ɗi ma mətsə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mbaꞌa kə mbəzliy bazlaŋwəyəy, ə pə ghwəy təfanshi miy tsa wəzə tsa na na ghwəy. Mbaꞌa kə mbəzliy tsəərəŋwəyəy, ə pə ghwəy cəꞌwə wəzə hwər tsa Hyalaa dzəkən shi. ");
INSERT INTO bcw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mbaꞌa kə ndə ləkavəghaŋa dəvə vəgha ghən ghay, ə pə gha zhəghanavə nahwəti bəlaa tərmbə, a ghəci ləkəŋa vəgha diɓa. Mbaꞌa kə ndə sərəhwə ləkwəsa kən ghən tsa ghay, zlay a ghəci zhiniy sərəhwə lə ɗaŋkəci tsa kən ghay ta gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ya tsamaɓa ndə ɗəw na shiy va ghay, ɓə pə ghaa ɓancishi. Mbaꞌa kə ndə ɓəhwəŋa shi ghay, ka nə gha war gha zhanavəra shi ya, pə gha ngəci ma. ");
INSERT INTO bcw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Njasa ɗi ghwəy va məndiy məniŋwəy kwəma wəzə nay, war tsəgha pə ghwəy mananshi kaa mbəzli kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ma kala tsəgha, mbaꞌa pə ghwəy ɗi war mbəzliy ɗi kwəma ghwəy gwaꞌa tsəghay, zhəmə njaa naa ndəghə ghwəy va Hyalaa? A ghwəy sənay ya mbəzliy məni *kwəma jikir nay, a ghəshiy ɗi mbəzliy ɗi kwəma shi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mbaꞌa pə ghwəy mananshi kwəma wəzə na, war kwataka kaa mbəzliy məniŋwəy wəzəy. Zhəmə njaa naa ndəghə ghwəy va Hyala kia? A ghwəy sənay, ya mbəzli jikir niy, tsəgha məni ghəshi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mbaꞌa pə ghwəy ɓanshi təm war kwataka kaa mbəzli sənashi ghwəy a ghəshi dzaa wavəŋwəy sa ghwəy, pə ghwəyəy. Zhəmə njaa naa ndəghə ghwəy va Hyalaa? A ghwəy sənay, ya mbəzliy məni kwəma jikir nay, war kaa nihwəti mbəzliy məni kwəma jikir na nja ghəshi, ka ghəshiy ɓə təm tsa shi, ta mbay mbəzli vaa wanshi sa shi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma na na ghwəy, ghwəy mbəzliy nəwray, ə pə ghwəy ɗi ka jaka ghwəy, mananshim kwəma wəzə na, ɓanshim təm kaa mbəzli bərkəti ma ghwəy gar kwəmavə təm və shi. Ma ghalaɓay, ta kwəmavə zhəmə dikə na dza ghwəy va Hyala ta ghwəmə, ka məniŋwəy ndərazhi nzə. Sa nzanay, Hyala na nanzə na, aa məni wəzə kaa mbəzli gwanashi. Kaa ka ndərəm lə kaa ka viniꞌwə shiy gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ə pə ghwəy məni wəzə hwər kaa mbəzli tərəŋw, njasa nza Dəŋwəy Hyala va mbə məni wəzə hwər tərəŋw kaa mbəzli kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Zhəghwa ma kə Yesəw ngəshi ɓa na: «Ka ndərə nihwəti mbəzli ghwəy ma, ghalaɓay, ka dza Hyalaa ndərəŋwəyəw. Ka ɓə fəti ghwəy kaa nihwəti mbəzli ma, ghalaɓay, ka dza Hyalaa ɓəŋwəy fətiw. Mbaꞌa kə ndə məntəŋwəy *kwəma jikir nay, ə pə ghwəy pəlay mbə nəfə tsa ghwəy, ghalaɓay, ta pəlataŋwəy kwəma ghwəy jikir na dza Hyala mbə nəfə nzə kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nganshim shiy kaa nihwəti mbəzli, ghalaɓay ta ngaŋwəy shiy dza Hyala kwərakwə. Mbaꞌa pə ghwəy nga shiy kaa nihwəti mbəzliy, tsəgha dza Hyala ngaŋwəy shiy, paf, ka shikə ɓəratatatə njasa ka ha vaa shikə ta tasaw. Sa nzanay, war njasa ka ghwəy vaa mananshi kaa nihwəti mbəzliy, tsəgha dza Hyalaa bərkəti ta məniŋwəy kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dza Yesəw diɓa, mbaꞌa ɓəlanakəshi fir, ma kə na: «Ya wa ndəy aa sənay, ka mbay ghwəlfəə kəsəvə tsahwəti ghwəlfə nja ghəci ta canci kwaləw. Mbaꞌa kə kəsəvəy, bakanashi dza ghəshiy shakaghwavashi kwa kəꞌwə. ");
INSERT INTO bcw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ndə ɓəni shiy tiɓa mbaꞌa taŋəti ntsaa ɓananci shiy tə sənashi shiw. Nanzə ki, mbaꞌa kə ɓənəhwə shi va wəzə gwaꞌay, yəmə dza naa nza lə ndə ɓananci shiy tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sa wana nighə gha kwasheɓi məzaɗi jəw ni tə mətsə zəməŋa, kala nighəvə tsəm tsa dikə tsa va gha tə mətsə ghaa? ");
INSERT INTO bcw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Njaa dza ghaa mbay ni kaa zəməŋa na: “A zəmə, kadiw di e ɓantəŋa kwasheɓi məzaɗi tə mətsə gha ni jəw ni” pə gha, mbaꞌa gha zlay tsəm tsa dikə tsa va tə mətsə ghaa? Ma gha gha ntsaa ɓəti ghən tsa gha tsa ka ntsa slar tsay, a pə gha ɓanti pərɓa tsəm tsa dikə tsa va tə na gha va mətsə di na gha. Ma ghalaɓa kiy, nza gha mbay nay pi ɗiweŋ ɗiweŋ ta ɓananti kwasheɓi məzaɗi tə mətsə zəməŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ma kə Yesəw kaa tsahwəti fir ɓa na: «Ka mbay dəŋw fə wəzə naa yati ya gəmgəm naw. Ka mbay dəŋw fə gəmgəm naa yati ya wəzə naw. ");
INSERT INTO bcw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ya tsamaɓa dəŋw fəy, war tə ya ci ka məndiy sənay sa wəzə tsa na, kə məndi. Sənzənvay, ka mbay məndiy ngəlivə ya bəzakə tə gwəviɗiw. Zhini ɓay, ka mbay məndiy ngəlivə ya shəkən tə dəŋw mbəzakwaw. ");
INSERT INTO bcw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ava tsəgha na, ma ntsa wəzə tsay, sləni wəzə na ka naa məni, sa nzana shi wəzə ni shi mbə nəfə tsa ci. Ma tsa gəmgəm tsa ndəy, sləni gəmgəm na ghəciy məni, sa nza shi mbə nəfə tsa ciy shi gəmgəm ni. Sənay tə ghwəy, kwəmaa təhay nəfə tsa ndə na sa ka ndəə gəzə səkwa tə miy ci» kə. ");
INSERT INTO bcw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma kə Yesəw kaa ngəshi ɓa na: «Tawa harɗa ghwəy, “A Ndə sləkəŋəy, a Ndə sləkəŋəy” pə ghwəy, kala məni kwəma ghwəy, njasa gəzaŋwəy ya? ");
INSERT INTO bcw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ya wa ntsaa səəkəy dzəvəghee mbaꞌa favə kwəma gəzəkee, dzəghwa na ka məni njasa gəzəkee vay, avanashi shi yəməva na li shi: ");
INSERT INTO bcw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yəmyəm na lə ntsaa ɗi nga ciki, laꞌ laꞌ laꞌ lati pərɓa kəꞌwə təɗəm, mbaꞌa fəti səɗa ciki tsa ci tə kəlɓa səəkə kwa hiɗi. Ma sa ngamti na na, mbaꞌa ghərakwəli səəkəta tə nahwəti vici, pəyaꞌ həl təhəy ka dəzlay ciki tsa ci va, shaŋ ghənzə ta ngəzlamti, sa ngay na wəzə tə kəlɓa. ");
INSERT INTO bcw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma na ntsaa favə kwəma gəzee, kala məni kwəma favə na vay, yəmyəm na lə ntsaa ghavə vaa fəti səɗa ciki tsa ci dzəy tə hiɗi gəmshi, kala lay ya kəꞌwə jəwə, mbaꞌa ngati. Ma sa kərəy na lə ngaci, tə nahwəti viciy mbaꞌa ghərakwəli səəkəta pəyaꞌ həl təhəy, ka dəzlay ciki tsa ci va, nzaꞌjəw, gərip, ghəci ngəzlay. Kala zhiniy tərmbə ya jəw tsətsə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sa kəɗamti Yesəw gəzə kwəma va gwanata tsəgha kaa mbəzli ki na, dza na mbaꞌa maɗiy ka dzay dzəmbə məlmə Kapernahwəm. ");
INSERT INTO bcw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma mbə məlmə va na, mbaꞌa tsahwəti dikə tsa ka sawji ka Rəm bələkwə niy nza tiɓa, mbaꞌa ntsaa ghəranci sləni tiɓa, tərəŋw ghəci ɗi. Dzəghwa mbaꞌa zəlghwə kəsəvə ndə ghəranci sləni tsa va dalala, tərmbə war miy nəfə ta məti. ");
INSERT INTO bcw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma sa tsəhəy Yesəw mbə məlmə va na, mbaꞌa dikə tsa ka sawji tsa va favə məndiy gəzə kwəma Yesəw. Dza na nzaꞌjəw harvə mətikwəkwər mbə *ka Zhəwifə, mbaꞌa ghwənəghəshi kaa Yesəw ta dza ghəshiy cəꞌwə, a ghəci səəkə ta mbəlanamti ndə ghəra sləni tsa ci va. ");
INSERT INTO bcw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dzəghwa mətikwəkwər va, mbaꞌa ghəshi maɗishi, dza ndəs ghəshi tsəhəshi va Yesəw. Sa tsəhəshi ghəshi na, dza ghəshi tapə ta cəꞌwə Yesəw dalala, ma kə ghəshi ngəci na: «Dikə tsa ka sawji ka Rəm ghwənikəŋəy na ta cəꞌwəŋa, a gha mbəlanamti ndə ghəra sləni tsa ci. Ntsa vay, jəw na wəzəw, aa təɓə ghaa kəətiti. ");
INSERT INTO bcw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sa nzanay, tərəŋw ɗiti na hwəlfə ghwəmmə, ghwəmmə ka Zhəwifə. Sanay, ghəci ngatəmmə na ciki ɓasəva tsa ghwəmmə tsa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ma sa favə Yesəw kwəma va na, dza na kaf kafəy, mbaꞌa nəwvəshi. Ma ghəshi kwa kwalshi, ghəshi ndəkwə lə ghi tsa ntsa va na, mbaꞌa dikə tsa ka sawji tsa va ghwənikə madigahiy kaa Yesəw. Bəgəm ghəshi mbə kwal lə mbəzli va. Ma kə ghəshi kaa Yesəw na: «A Ndə sləkəpə, ma kə dikə tsa ka sawjiy: Ka tasə ghən tsa gha gha ma. Yənəy, mənɗee ndə gar dzakə ghi tsee gha dəꞌwə ghən tsa ghaw. ");
INSERT INTO bcw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Sa kamee va mək, ɗimee tsəhə kwa kwəma gha dəꞌwə ghən tsee. Avanay sanay, a mbəzli dikə dikə ni tiɓa kənee ka sləkəra, yən kwərakwə na, lə ka sawji sləkee tiɓa. Yən kəə ɗiy, e ni: “Mbalaa dzəti pətsa tsaꞌ tsa” pən kaa ndə sawji, ka dza ghəci. Aw na: “Ndi” pən kaa tsahwəti, ka səəkə ghəci. E ni: “Məntəra sləni tsaꞌ na” pən kaa ndə ghəra sləni tsee, ka məni ghəci. Gha kwərakwə kiy, ntsa dikə tsa nza gha. Ə cəꞌwəŋee, gəzəkə kwəma lə miy tsa gha kwətiŋ, ta mbəliy dza ndə ghəra sləni tsee va va zəlghwə tsa ci, ka satiy, kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ma sa favə Yesəw kwəma gəzəkə dikə tsa ka sawji tsa va va tsəgha na, tapə ghəci mbə vəshiy dzəkən ntsa va. Dza na, tərəɗ zhəghəghəvay dza kwa vərəm tsa kwasəbə va. A kə kaa ngəshi na: «Ya mbə ghwəy, ghwəy mbəzli ka *Izərayeləy, səəkee kəsay ntsaa ɓanavə nəfə tsa ci kaa Hyala gwanay nja ndə ka məlmə tsa tepəw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma ləy hwəm ki na, mbaꞌa mbəzli ghwənəghə dikə tsa ka sawji tsa va va zhəghəghəvashiy jighi ki. Dza ghəshi na, ndə ghəra sləni tsa ci va mbəliy kwəriŋ. ");
INSERT INTO bcw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma ləy hwəm shi va ki na, mbaꞌa Yesəw kafəy, ka dzay dzəmbə nahwəti məlmə, Nayin, kə məndi slən tsa məlmə va. Mbaꞌa mbəzli ta səɗa ci kwasəbə, ghəshi lə nihwəti mbəzli ɗaŋaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma ghəci ndəkwə ta tsəhə mbə məlmə va na, bəgəm ghəshi lə mbəri, məndiy dza ta la. Ntsaa mətiy vay, zəghwə nahwəti mali mbəri niy nza na. War kwətiŋəy niy yakə na. Ɗaŋ mbəzli mbə məlmə va niy nza kwasəbə mali va mbə ɓə mbəri tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","War sa nata Yesəw mali va tsəgha na, tapə hwər tsa ci ta zhanci ti. Ma kə kaa ngəta na: «A mali, ka wahə gha ma» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dzəghwa na, kət kətəghəvay dzəvəgha mbəri tsa va, dapə dapashi shəghwə ɓə məndi mbəri tsa va ti shi. Sa dapətishi na na, dza ka ɓə mbəri, gar ghəshi garəshi. A kə Yesəw kaa mbəri tsa va na: «A məgəla, yən gəzaŋa na, satiŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pəlhəm, zəghwə va satiy, das nzəyəy mənzəy, dza na ka gha gəzə kwəma tsəgha. Dza Yesəw ki, mbaꞌa ɓanavə kaa mbəghəy. ");
INSERT INTO bcw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma sa nata mbəzli tiɓa va gwanashi nava kwəma na, mbaꞌa her shi dzashi tərəŋw. Dza ghəshi ka fal Hyala, ma kə ghəshi na: «Kay, par nava kwəma ki. Avanay *ndə gəzə kwəma Hyala tsa dikə tsa tsahwəy dzəmbə ghwəmmə ndatsə. Hyala səəkəta na ta kəəti mbəzli nzə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dza kwəma mənti Yesəw va tsəgha na, mbaꞌa pəlivərivata gwaꞌa gwaꞌa tə hiɗi ka Zhəwde, lə tə nihwəti hiɗi dzar vəgha shi gwaꞌa ki. ");
INSERT INTO bcw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ma ləy hwəm shi va ki na, mbaꞌa mbəzli ta səɗa Zhaŋ tsaa mənipə batem dzaa zhananavə shi mənəhwə Yesəw va gwanashi kaa ngəci ghəci kwa fərshina. Ma sa favə Zhaŋ kwəma va tsəgha na, dza na daꞌ harvə mbəzli bakə mbə mbəzli ta səɗa ci va. ");
INSERT INTO bcw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kə ka ghwənishi kaa Yesəw Ndə sləkəpə, ma kə kaa ngəshi na: «Mbalam ɗəwtəram kwəma va ntsa va. Ma pə ghwəy ngəciy: “Waa gha na ntsa ndəghə ghəy va dzaa səəkə ta naa? Naa, a ghəy ndəghə tsahwəti ndə na? kə Zhaŋ” pə ghwəy ngəci» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dza mbəzli va kaf ghəshi kafəshi, mbaꞌa ghəshi dzaa kəsay Yesəw. Ma kə ghəshi kaa ngəci na: «Waa Zhaŋ, ndə mənipə batem ghwənikəŋəy na va gha. Ma kəy: “Waa gha na ntsa ndəghə ghəy va dzaa səəkə ta naa? Naa, a ghəy ndəghə tsahwəti na?” kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma geꞌi ghala vəghwə tsa gəzə mbəzli va va kwəma na, dza Yesəw mbaꞌa mbalamti ka zəlghwə ɗaŋ, mbəliꞌ kaa vədevəder, mbəliꞌ kaa ka gezlekiki, zhini mbaꞌa ghwənamti mətsəhi ghwəlefesli ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dzəghwa, ma kə kaa mbəzli ghwənikə Zhaŋ va ki na: «Mbalam, a ghwəy dzaa gəzanci shi nashi ghwəy lə mətsəhi ghwəy, lə kwəma favə ghwəy lə slimim ghwəy kaa Zhaŋ. A ghwəy nay, aa mətsəhi ghwəlefesli ghwənishi, mbə nay pi ghəshi, vədevəder na, ka dza, mbaꞌa ka dərna mbəlishi, dza mbaꞌa slimim mədeŋesli ghwənishi, mbə favə kwəma ghəshi. Mbəzliy niy bəkwəshi na, ka zhakatishi mbə məti. Zhini, mbaꞌa Yəwən kwəma wəzə na tsəhəta kwa slimim ka cicikwə. ");
INSERT INTO bcw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vəshi na ta ntsaa zhəghavəra ma hwəm, sa səəkəra mee dzəghwa ma ci» kə kaa ngəshi. Dzəghwa mbəzli ghwənikə Zhaŋ va ki, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ma sa dzashi ghəshi na, tapə Yesəw ta gəzanshi kwəma Zhaŋ kaa niy ɓasəshi va mbəzli tə pətsa va, a kə kaa ngəshi na: «Sa dzaŋwəy ghwəy vaa dzəti gamba ta nighə Zhaŋəy, a ntsaa niy dza ghwəy ta nighə tay? Ta nighə dzəvəti kwəfəghə safə niy dza ghwəy nanzə ɓa na? ");
INSERT INTO bcw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Naa wa na ntsaa dza ghwəy va ta nighə kia? A ghəy dzaa nay ndə lə kwəbeŋerəy gwəramti wəzə kən ghən ci, niy nə ghwəy nanzə diɓaw? Ta na ka pa kwəbeŋerəy gwəramti wəzə lə mbəzli tə wahəy, dzar kəy mezhizhə ka gəla niva mbəzliy nzəy nzəy tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","War wa na ntsaa dza ghwəy va ta nighə kia? A ghəy dzaa nighəti *ndə gəzə kwəma Hyala niy nə ghwəy nanzə ɓay? Yaŋ tsəgha na, ndə gəzə kwəma Hyala na Zhaŋ kataŋ. Ghəciy aa taŋəti nihwəti ka gəzə kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sa nzanay, Zhaŋ na ntsaa niy dza vaa ꞌwara kwal, saa niy tsasliti məndi va kwəmaa dzəkən kwa Zliya Hyala. Ma kə Hyala kaa kwəma gəzəkə naa dzəkənəy: Avee taa ghwənəghə ndə kwal tsee, a ghəci ꞌwatəŋa kwal, nza ghəci gwəmantəŋa kwal tsa dza ghaa dza kwa, kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ə gəzaŋwəy ya, ndə tiɓa tə hiɗi məndi yakə ka yəməva lə Zhaŋ tə dikəw. Ya tsəgha nzə kiy, ya wa ntsa gəməy tsa zləɓavə kwəmee, ta sləkə Hyalay, dikəɓa ghəci na kaa Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A ghwəy na, ya tsamaɓa ntsaa favə kwəma gəzəkə Zhaŋ ndə mənipə batem va, lə ka dəwanshi gwaꞌay, mbaꞌa ghəshi zləɓavə Hyalaa sləkəshi, sa nzana lə kwal ghənzə məni kwəma nzə. Mbaꞌa Zhaŋ mananatishi batem. ");
INSERT INTO bcw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma *ka Farisahi lə *ka ɓənipə kwəma pəhəti Hyala nashi ki na, mbaꞌa ghəshi ndəghamti kwəma taranakəshi Hyala, kala zləɓa məni batem va Zhaŋ» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zhini ma kə diɓa na: «Mbəzli mbə vəghwə tsa ndatsə tsay, lə wa yəməva ghəshi tay? ");
INSERT INTO bcw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yəmyəm na ghəshi lə ndərazhiy ɓasətəvashi va tə bəghə ta tsaɓana. Dzəghwa ka ꞌwaŋanshi ꞌwaŋə nihwəti kaa nihwəti, ma kə ghəshi na: “Tawa məni ghwəy tsəgha shəka? Mbaꞌa ghwəmmə ɓasəmmə ta tsə, tapə ghəy ta viyŋwəy sherey a ghwəy tsə, pə ghəy na, a tsə ghwəyəw. Ənkwa pə ghəy, zhini ka ꞌwaŋwəy cəm civə ghəy na, a zləɓa ghwəyəw!” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tsəgha nza ghwəy nja ndərazhiy səəvəri nihwəti va. Sa nzanay, ndəs səəkəy Zhaŋ tsaa mənipə batem, ma mbə nzəy tsa ci na, kala zəmə ma shi wəzə ni, kala sa ma tay ghəci. Ma pə ghwəy na: “Waa ndə gazlaka na tsatsa ndə” pə ghwəy, kala zləɓa kwəma Zhaŋ ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dzəghwa sa səəkəree, yən Zəghwə yakə ndə ngəri nee ki na, dzee ka zəmə shi zəmə, ka sa tay. Zhini ma pə ghwəy ɓa na: “Wəyəw, ndə hwər na tsatsa ndə, war shi zəmə lə tay na na ci kwəma sənata na gwaꞌa tsəgha, ka kəsə madigaa dzəti ka *dəwan lə dzar tə ka badaway gəmgəm ni” pə ghwəy, kala zləɓa ma kwəmee ghwəy ɓa. ");
INSERT INTO bcw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ya tsəgha nzə kiy, nihwəti mbəzliy zləɓavə kwəmee na a ghəshi sənay, kwəma mənti Hyala va lə sənata kwəma nzəy, kwəma lə kwal na, kə ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ma tə nahwəti vici na, dza tsahwəti ndə Farisa, Shimaŋw kə məndi kaa slən tsa ci, daꞌ haray Yesəw dzakə ghi tsa ci ta zəmə shiy ghəshi li. Dza Yesəw mbaꞌa dzakəy dzakə ghi tsa ntsa va, dza das nzəyəy ta zəmə shi zəmə. ");
INSERT INTO bcw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma mbə məlmə va na, mbaꞌa nahwəti mali niy nza tiɓa, kwa məni *kwəma jikir na ghənzə tərəŋw. Ma sa favə mali va kəghi tsa *ndə Farisa tsa va na Yesəw mbə zəmə shiy, kə məndi na, pəlhəm kafəta, kə laŋ ɓəvə təlimə paf ꞌwərdi kwa, ka dzata liy dzakə ghi tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tsəhə tsa tsəhə na na, mbaꞌa nzəyta lə hwəm Yesəw ndəkwə vəgha səɗa ci. Dza na ka wahə tsəgha. Ɓeɓeɓeɓeɓ ghaa nighə ma wahə kwa mətsə nzə, ka səkwaa dzəti səɗa Yesəw, cəkeꞌ ɓaslamti shiɗshiɗ Yesəw lə wahə. Kə diɓa ka saɗishi lə shiti mbə ghən nzə. Sa saɗamtishi na na, hwətəm hwətəməvəshi. Ləy hwəm ki na, dza na naꞌi naꞌi ɓaslati ꞌwərdi ti shi. ");
INSERT INTO bcw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma sa nata Shimaŋw tsaa haray Yesəw va ta zəmə shiy kwəma va tsəgha na, dza na ka təkə kwəma mbə ghən ci kwətiy, a kə na: «Ntsay, *ndə gəzə kwəma Hyala naw. Sa nzana war mbaꞌa kə niy nzaa ndə gəzə kwəma Hyala nza kataŋəy, ka dza naa bashi sənata maliy dapə na nzaw. Cəkeꞌ niy dza naa sənay, mali kwa məni kwəma jikir na na, kə nza» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dzəghwa Yesəw tsəgha ki, mbaꞌa maɗiy ta gəzanci kwəma, ma kə ngəci na: «A Shimaŋw, e ɗi gəzaŋa nahwəti kwəma» kə. Ma kə Shimaŋw na: «Gəzə shaa, Metər» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma kə Yesəw na: «A tsahwəti ndə niy nza tiɓa kwataŋa lə temer ci va mbəzli bakə. Mbəl bələkwə bələkwə cifə va tsahwəti. Ma va tsahwəti na, mbəl cifə mətsəkə. ");
INSERT INTO bcw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma mbəzli va bakanashi na, daw bərci shi ta wa təm tsa va. Sa nay ntsa va bərci shi daw tsəgha na, mbaꞌa zlatanavəshi gəna va, kala zhiniy ɗəw və shi bakanashi. Mbə mbəzli bakə ni va sanay, tsama ndə dza naa gwəraa ɗi kwəma ndə gəna tsa va məndi kəə ɗəw va ghaa?» kə Yesəw kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma kə Shimaŋw kaa zləɓanci na: «Ɗiɓa ntsa zlatanavə na va gəna ɗaŋɓa ngəci dza naa ɗi kwəma ntsa va bərkee nee» kə. Ma kə Yesəw ngəci na: «A gha sənata kataŋ» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dzəghwa na dzar kwa bəla mali va, tərəɗ zhəghəghə kwəma ci. Ma kə kaa Shimaŋw na: «A Shimaŋw, nata mali na gha na. Avanay sanay, ndəs səəkəree dzakə ghi tsa gha, dza na nanzə ki, ɓasl ɓasl ɓaslamti shiɗshiɗee lə wahə kwa mətsə nzə, dza na mbaꞌa saɗamtishi lə shəti mbə ghən nzə. Ma gha na na ghay, tara gha ya yam ta pi shiɗshid yaw. ");
INSERT INTO bcw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Zhini diɓay hwətəməhwəra gha ghala səəkəra yaw. Na nanzəy, ghala səəkəree dzakə ghi tsa gha tsa na, war mbə hwətəmə shiɗshiɗee na. ");
INSERT INTO bcw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gha na na gha diɓay, varambəra in gha mbə ghən tsee ta ci kaꞌwə tsa kaꞌwətəra ghaw. Na nanzə, nanzə ki na, aa ɓaslati ꞌwərdi tə shiɗshiɗee. Nata kwəma va gha sa. ");
INSERT INTO bcw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Va tsəgha gəzaŋee, ma shi mənti mali na niy, aa ci ghəshi ɗi tsa ɗitəra na tərəŋw. Aa ci ghəshi pəli tsa pəlay Hyala jikir tsa nzə va tərəŋw tsa diɓa. Ma na ntsa pəlanay Hyala jikir tsa ci jəwə tsətsəy, daw dza naa ɗira kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sa gəzəkə na kwəma va tsəgha ki na, dza na ka gəzanta kwəma kaa mali va, ma kə na: «A mali, avee pəlayŋa kwəma mənəhwə gha jikir na kwa hwər tsee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sa gəzəkə Yesəw tsəgha na, dza mbəzli zəmə ghəshi va shiy li shi, tapə ghəshi ta təkə kwəma mbə ghən shi, ma kə ghəshi kwa jipə shi na: «Wa slən tsa gəla tsatsa ndə dza naa mbay pəlanay lə kwəma ndə jikir na taa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma kə Yesəw kaa mali va naci ki na: «A mali, sa ndara gha tsa nəfə tsa gha gwanayəy, a gha mbəliŋa, mbala kwəriŋ» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dzəghwa, ləy hwəm shi va ki na, mbaꞌa Yesəw maɗiy ka dza dzar mbə məlməhi dikə dikə ni, lə dzar mbə ni jəw jəw ni gwaꞌa. Mbaꞌa gəzanavəshi Yəwən kwəma wəzə naa dzəkən sləkə tsa dza Hyala ta sləkə mbəzli. Ma ghalaɓa na, kwasəbə mbəzli ta səɗa ci va məŋ lə bakə ni niy nza, ");
INSERT INTO bcw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ghəshi lə nihwəti miꞌiy niy mbəlanti na va gazlaka, mbaꞌa va nihwəti zəleghwer ghənghən ghənghən gwaꞌa. Avanay slən tsa miꞌi va: Marəy ka Magədala, mbərfəŋ niy tihəkəvəri Yesəw hyeler mbə ghən nzə. ");
INSERT INTO bcw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mbaꞌa Zhanə, mali Shəwza ndə ghəra sləni kaa mazə *Erədə, mbaꞌa Səwzanə, mbaꞌa nihwəti miꞌi ghənghən ghənghən. Shi və shi niy ɓəvə ghəshi ta kəəkəəti kar Yesəw ghəshi lə mbəzli ta səɗa ci. Tsəgha niy nza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dza mbəzli tə nahwəti vici ɓa, ɗaŋ ghəshi ɓasəkəvashi, səəkə mbə məlməhi ghənghən ghənghən dzəvəgha Yesəw. Ma sa nashi na mbəzli ɓasəshi tsəgha na, dza na tapə ta ɓəlanshi fir. ");
INSERT INTO bcw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ma kə na: «Tə nahwəti viciy mbaꞌa tsahwəti ndə za maɗiy dzəmti ta sləka ha. Ma sa tsəhəy na na, dzəghwa na tapə ghəci ta kihwə ha va kihwə kihwə. Ma ghəci mbə kihwə ha va ki na, dzəghwa pəriŋ nahwəti ha pəpəriŋətaa dzəghwa kwal. Ma mbəzli mbə dza kwa kwal tsa va na, mbaꞌa ghəshi kaɗamti, zhini ꞌyegwer ɓa, im im im ghəshi səəkəə iməhwə. ");
INSERT INTO bcw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dzəghwa nahwəti ɓa, mbaꞌa pəpəriŋətaa dzəti kwərhə. War sa pəsəta na na, nzaꞌjəw ghənzə ghwə ghwəlita, sa nzəy ma yam mbə kwərhə. ");
INSERT INTO bcw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dza nahwəti diɓa mbaꞌa pəpəriŋəta dzəghwambə jipə tekesli. Ma sa pəsəta na na, tapə ghəshi ka kəli lə tekesli gwanashi, dzəghwa tekesli tisl ghəshi kəələhwə ha va kala mbə ghənzəə zhiniy kəli. ");
INSERT INTO bcw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma dzəghwa nahwəti nanzə ki na, mbaꞌa dzataa dzəmbə hiɗi wəzə ni, dzəghwa na, mbaꞌa pəsəta, ka kəli kəli nzə. Ma sa kəlita na na, mbaꞌa ɓəvə hwər, mbaꞌa fəti mətsə wəzə wəzə» kə Yesəw. Ma sa kəɗamti Yesəw gəzə kwəma va kaa mbəzli tsəgha, ma kə kaa ngəshi na: «Ma ntsa nza sləmə və ta fa kwəmay, fə tə ghəci ghən ta kwəma va!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dzəghwa *mbəzli ta səɗa Yesəw tapə ghəshi ta ɗəw sləkar tsa fir tsa ɓəli na va kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma kə Yesəw kaa zləɓanshi na: «Ta na na ghwəyəy, a Hyala ndaŋwəy məhərli ta sənashi shiy dzəkən sləkə tsa dza na ta sləkə mbəzli. Ma na kaa nihwəti mbəzliy, kwa fir gəzanshee kwəma. Sa nzana, ghəshi na nashiy, lə mətsəhi və shi ta nighə pi na, a ka nay pi ghəshiw. Mbaꞌa slimim vəshi ta favə kwəma na, a ka favə kwəma ghəshiw, tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Dzəghwa ma kə Yesəw ki na: «Avanɗa taa gəzaŋwəy kwəma ɗi fir tsee vaa gəzə: Ma hwəlfə vay, ghənzə na kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nefer nihwəti mbəzliy, nja kwal tsa pəriŋəta nahwəti hwəlfə ha vaa dzəghwa na. Sa ka ghəshiy favə gəzə kwəma Hyalay, ka *ndə jaka tsa Hyala səəkə mbaꞌa ɓanti kwəma va mbə nefer shi, va nəghətaa ghəshi dzaa mbəlishi, sa ka ghəshi ɓanavə nefer shi kaa kwəma va. ");
INSERT INTO bcw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma nefer nihwəti mbəzli ɓay, nja kwərhə tsa pəriŋatəvata nahwəti ha va ti na ghəshi. Gəla mbəzli vay, war favə ma ghəshi kwəma Hyala tsəgha na, nzaꞌjəw ka ghəshiy ɓanavə nefer shi lə vəshi. Ma ləy hwəm ɓa ki na, ka zlata kwəma va ghəshiy nza gar tsəhəvə hililiŋə ghənzə wəzə mbə nefer shiw, war ta vici jəwə ka ghəshiy zləɓavə gwaꞌa tsəgha. War səəkəy ma ngəraꞌwəə dzəkən shiy, ka ghəshiy dza, mbərəkə ghəshi zlata kwəmaa niy zləɓavə ghəshi va. ");
INSERT INTO bcw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma nefer nihwəti mbəzli diɓa na, nja pi ndə tekesli tsa dzəghwata nahwəti ha va mbə. Niva mbəzliy, sa ghəshiy favə kwəma Hyala na, mbaꞌa ghəshi zləɓavə, ka ghəshi dza diɓa na mbaꞌa ghəshi ghati zəzə kwəmaa kən shi, lə kwəma shi tə hiɗi, mbaꞌa wəzə tsa nzəy tsa tə hiɗi. Ka niva shiy dza ki na, mbaꞌa ghəshi makəti kwəma Hyala kala zhini ghənzəə ghəra sləni mbə nefer shi. ");
INSERT INTO bcw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma nefer nihwəti mbəzli nashi kiy, nja hiɗi wəzə ni va dzəmbəta hwəlfə haa dzəmbə shi na. Sa favə ghəshi kwəma Hyalay, mbaꞌa ghəshi zləɓavə, dza tasl, ghəshi kəsəvə kwəma va mbə nefer shi wəzə wəzə. Ka nəw kwəma Hyala ghəshi lə kwal, ghəshi na shiy ghəra sləni wəzə na ɗi Hyala kala zlata» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zhəghwa ma kə Yesəw ɓa na: «A ghwəmmə sənay, ndə tiɓa, mbaꞌa tsəꞌwaghwa ghwə kwa gərkəwa na, zhini dzəɓə dzəɓakən tasaw bərkə shiy kən, awə kə bay na, mbaꞌa mbələy dzəy ta pi həni tsa ciw. Mbaꞌa kə məndi pəhaghwa ghwə kwa gərkəway, tə pətsa ɗal tsa ka məndiy fəy, ta mbə ghənzəə mbərə, ma nza mbəzliy dzəmbə ciki nay pi waŋ. ");
INSERT INTO bcw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tsəgha na ki, ya wa shi mbəmbə niy, ta səvərishi dza ghəshiy dzəti ngwəla, ya wa kwəma ghələhwə məndi gəzə nzəy, cəkeꞌ dza məndiy sənata, zləŋ məlmə. ");
INSERT INTO bcw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Va tsəgha ki, a nə ya ngəŋwəyəy, mənim məhərliy dzəkən kwəma fa ghwəy. Sa nzanay, ntsa nza nihwəti shiy və na ta mətsahanavə nihwəti shiy dza məndi. Ma na ntsa kama shiy vəy, ta zhini dza məndiy tsaləhwə ya ni jəw ni va shiy niy fə na ghən ti shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dza kar mbəghəy Yesəw lə ngwarməhiy, mbaꞌa ghəshi maɗishi ta dza ta nighə ci. Dza ghəshi ndəs tsəhəshi tə pətsa nza na va. Ma sa tsəhəshi ghəshi na, kala mbə ghəshiy dzar dzəvəgha Yesəw sa nza mbəzli ɗaŋshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma sa nashi mbəzli na, mbaꞌa ghəshi dzaa kəsay Yesəw. A kə məndi ngəci na: «Ava kar məŋa lə ngwarməhiŋa pərikə tə ngwəla ka ɗəwŋa ta nighətəŋa, kə ghəshi» kə məndi ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma kə Yesəw kaa zləɓanshi na: «Na neyey, mbəzliy fa kwəma Hyala va, ka nəw ghəshi njasa gəzəkə nay, ghəshi na ni ya ngwarməhira, zhini ghəshi nee mərə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ma tə nahwəti vici na, dza Yesəw mbaꞌa dzay dzəghwa kwambəwal ghəshi lə *mbəzli ta səɗa ci. Ma sa dzəghwashi ghəshi, a kə kaa ngəshi na: «Taŋəmmə ghwəmməə dzəvəri tsahwəti həlbə» kə. Sa gəzəkə na tsəgha na, dza ghəshi mbaꞌa ghəshi kafəshi, ka dzashi. ");
INSERT INTO bcw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma ghəshi mbə dza kwa kwambəwal na, mbaꞌa Yesəw ɓəhwə hi. War dzəghwa safə tsəgha vətəghə ghava viy lə bərci mbə tərəŋw tə yam va. Dza yam paf ghəshi təhay kwambəwal, ka ndava ghənzəə dzəmbə yam, jəw ghəshi tərmbə ta yəpəshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nzaꞌjəw mbəzli ta səɗa Yesəw kətəghəvashiy dzəvəgha Yesəw. Mbaꞌa ghəshi fərghay tə hi. Ma kə ghəshi ngəci naa: «A Metər, a Metər, gwaꞌa ghəy!» kə ghəshi. Dza Yesəw pəlhəm satiy, sa satiy na na, naɓə naɓəti kar safə, lə legweper dzəy tə ghən yam va lə bərci. Sa gəzanakəshi na kwəma na, mbaꞌa safə tsa va zlay viy, mbaꞌa yam va dəkəshi, ɗekəɗekə pi məniy tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma kə Yesəw kaa mbəzli ta səɗa ci ki na: «Wa shiy ghəraŋwəya? Kwəma kəray ni ghwəy nefer ɓanavə ghwəy kaa Hyalaa?» kə. Sa nata mbəzli ta səɗa ci kwəma mənti Yesəw va nashi ki na, mbaꞌa hazləni ghəratishi. Ka mananshi maɗaŋa nava kwəma gwaꞌa tsəgha. Ma kə ghəshi kwa jipə shi na: «Kay, kwətiy gəla tsatsa ndə ki! Ya kar safə lə yam na a ghəshi ɗanati fəti sa gəzanakəshi na kwəma lə bərci ni!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ma ləy hwəm shi va ki na, dza kar Yesəw mbaꞌa ghəshi kafəshi tə hiɗi ka Galilee taŋəshi dzəvəri tə kwəfa ka Galile. Mbaꞌa ghəshi dzətishi tə hiɗi ka Gerazeni. ");
INSERT INTO bcw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Mbə məlmə vay, mbaꞌa tsahwəti ndə gazlaka niy nza tiɓa. Tərəŋw ghəci niy hiy mbə gazlaka ci va. Kala dza ma ghəci lə kwəbeŋer. Kala hi ma kəghi, war dzar mbə kwəlihi nzəy tsa ci gwaꞌa tsəgha. Ka sanci ngəraꞌwə ghənzə. Sa ka məndiy dza, tsa məndi tsaghwa dividivi ci lə shiɗshiɗ ci kwa dəŋw tsahi, ta mbay məndiy ndəghwəti na, ka na ghavə cəkeꞌ ngəəlivəri niva shiy na naci. Sa ka gazlaka vaa dza na, zləŋər zləŋərəghə dzar mbə gamba, war tsəgha. Ma sa səkway Yesəw kwa kwambəwal na, mbaꞌa ndə gazlaka tsa va nay. Dza na mbaꞌa ngwəmata lala, kə ka dzar dzəmbə kwəma Yesəw. Dza na tsəfəkwə tsəfəkwəy, ka gəzə kwəma kaa Yesəw zlaŋzlaŋ, a kə na: «A Yesəw Zəghwə Hyala ta ghwəmə, ta njaa ɗi gha lə ya?» kə. Dza Yesəw ka gəzə kwəma kaa hyeler va lə bərci, a kə na: «Səvəriŋwəyəm mbə ntsa» kə. Ma kə ndə gazlaka tsa va ki na: «A cəꞌwəŋee, ka sara ngəraꞌwə gha na gha ma» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa gəzəkə ntsa va tsəgha, ma kə Yesəw kaa ngəci ki na: «A slən tsa ghaa?» kə. Ma kə ntsa va na: «Mbəzli ɗaŋ» kə. Ɗaŋ tərəŋw niy ɓasambəvashi hyeler mbə ghən ci, va tsəgha niy gəzə na kwəma va tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dzəghwa hyeler va tapə ta cəꞌwə Yesəw, ma kə ghəshi na: «Titihwə ka tihəŋəy gha səvəri mbə ghən ntsa, ta dza ta kalaghwaŋəy kwa kəꞌwə tsa hwərhwər tsa va ma» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Geꞌi tə pətsa məniva shi va vay, a garəwa ngəreder tərəŋw niy nza tiɓa. Mbə pala shi zəmə shi dzəghwa vəgha kəlaŋ. Dza hyeler va tapə ta cəꞌwə Yesəw diɓa, a kə ghəshi na: «Ndaŋəy kwal, a ghəy səvəriŋəy dzaŋəy dzəmbə ngəreder ni» kə ghəshi. Dza Yesəw mbaꞌa zlatanavəshi kwal. ");
INSERT INTO bcw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sa zlatanavəshi Yesəw kwal ki na, dza hyeler va shaa ghəshi səvərishi mbə ghən ntsa va, shəɓətə shəɓətambəvashi mbə ghən ngəreder va. Dza ngəreder va gəgəgəgə ghəshi kafəshi səəkə mə kəlaŋ tsa va, səəkə ghəshi naꞌi ghəshi shakatəvashi tə kwəfa. Bətə ghəshi zashi kwaɓa. ");
INSERT INTO bcw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mbəzliy niy makə ngəreder va na, tiɓa ghəshi niy nza ka nata kwəmaa məniva. Ma sa nata ghəshi na, bəvbəpə ghəshi hwəshiy dzəmbə məlmə, lə dzar mbə giwahi vəgha məlmə, mbaꞌa ghəshi dzaa gəzanshi tsava bar kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sa favə mbəzli nava kwəma na, kəram ghəshi maɗishi, ta dzaa nata kwəmaa mənta va. Ndəs ghəshi tsəhəshi vəgha Yesəw. Mbaꞌa ghəshi kəsay zal tsa səvərita gazlaka va mbə ghən ci mənzəy vəgha Yesəw. Mbaꞌa pakən kwəbaŋ kən ghən ci, lə məhərli ci və wəzə. Ma sa nay ghəshi tsəgha na, ka ghəranshi hazləni. ");
INSERT INTO bcw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dzəghwa mbəzliy niy nashi shi va va gwanashi njasa mənishi ghəshi, mbaꞌa ghəshi slanakəshi kaa mbəzliy səəkəshi va, njasa gha gazlaka vaa səvərita mbə ghən ntsa va. ");
INSERT INTO bcw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma sa favə ghəshi kwəma va na, dza mbəzli mbə məlmə va gwanashi, ka cəꞌwə Yesəw a ghəci ɓarvay tə hiɗi shi, sa nzana tərəŋw ghəshi hazlənishi va nava kwəma. Mbaꞌa Yesəw zhay zhəghwa kwambəwal, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Dza ntsa səvərita gazlaka va mbə ghən ci, tapə ta cəꞌwə Yesəw, ma kə na: «Yaŋ pə gha, e nəwvəŋa» kə. Ma kə Yesəw ngəci na: «Awə, mbalaa jighi, a gha dzaa gəzanshi kwəma məntəŋa Hyala na gwanata kaa nihwəti mbəzli» kə. Sa gəzanakə Yesəw tsəgha ki na, dza ntsa va ka dzay jighi. Jighi na na, ka gəzanshi kwəma mananati Yesəw va kaa mbəzli mbə məlmə gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dzəghwa ki sa zhəghəkəvay Yesəw səəkə pəri tsahwəti həlbə na, mbaꞌa mbəzli ɓasəshi tərəŋw, sa nzana mbə ndəghə ghəshi niy nza gwanashi. Dza mbaꞌa ghəshi kaꞌwəti ki. ");
INSERT INTO bcw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Mbaꞌa tsahwəti ndə niy nza tiɓa, ntsa dikə tsa ghəci mbə *ciki ɓasəva tsa ka Zhəwifə. Zhayrəsə, kə məndi kaa slən tsa ci. Mbaꞌa zha və kwətiŋta, məŋ lə bakə piya nzə. Dza na mbaꞌa tərəta gwərapəta tərəŋw, tərə na war miy nəfə. Dza ntsa va ndəs səəkəy dzəvəgha Yesəw. Dza na tsəfəkwə tsəfəkwəy tə shinin ci kwa kwəma Yesəw ta cəꞌwə, a kə kaa ngəci na: «Titihwə dzam dzakə ghi tsee, a gha dzaa mbəlitəra zhee nza na gwərapəta» kə. Dza Yesəw mbaꞌa zləɓavə. Kafə ghəci kafəy ta dzaa dzakə ghi tsa va. Ma ghəci mbə kwal na, war a mbəzliy nəw dishi, rəɗ rəɗ rəɗ ghəshi kwasəbə. ");
INSERT INTO bcw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mbə mbəzli va na, mbaꞌa nahwəti mali niy nza tiɓa, gwərapəta ghənzə. Piya nzə məŋ lə bakə, war mbə səkwa miymiy kwa hwər nzə. Pəŋw pəŋw ghənzə daŋəramti shi ta dəvə nzə kaa ka ciki ghwəꞌi, ta pəla mbəli ghən tsa nzə. Tərəh ntsaa mbay mbəliti. ");
INSERT INTO bcw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dza na ki, kət kətəghəvataa dzəvəgha Yesəw zhəkə ləy hwəm ci, kə dapə, ghənzə dapay mətsəni kwəbaŋ tsa ci. War ghwəla tsəgha na, nzaꞌjəw miymiy nzə va slashi lə səkwa, mbaꞌa mbəlita. ");
INSERT INTO bcw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma sa ndəŋway mali va Yesəw na, dza Yesəw ka ɗəw va mbəzli, ma kə na: «Wa ntsaa daparaa?» kə. Ya wa ndə mbə mbəzli kwasəbə va na: «Am, yən na na yaw, am, yən na na yaw, am, yən na na yaw» ghəshiy gəzə. Ma kə Piyer na: «A ntsa ghəy dikə tsa, a nava kia? Mbaꞌa gha nashi mbəzli dishi rəɗ rəɗ rəɗ kwasəbə gha na, zhini gha ka ɗəw, wa ntsaa daparaa, pə gha shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma kə Yesəw na: «Yaŋ war a ndə dapara, sa nzanay, e favə bərci tikəvərivashi mbə ya» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sa gəzəkə Yesəw tsəgha na, dzəghwa mali va mbaꞌa sənay, a məndi sənara, ka mbələyvara yaw, kə. Dza na shəlehwə shəlehwə səəkətaa dzəvəgha Yesəw kala gwərgwərə. Kə tsəfəkwə tsəfəkwəta kwa səɗa ci. Dza na cəkeꞌ gəzanakə kwəma dapə na ti kaa Yesəw, tiɓa kwa kwəma mbəzli gwanashi. Mbaꞌa gəzanakə njasa mbəlita na va zəlghwə tsa nzə ghala dapay na va. ");
INSERT INTO bcw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma sa gəzəkə na tsəgha, ma kə Yesəw ngəta na: «A zhee, a gha mbəliŋa tə sa ndara gha nəfə tsa gha. Mbala lə zərkə mbə nəfə tsa gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ma Yesəw mbə gəzə kwəma va kaa mali va tsəgha na, ndəs ntsa kəghi tsa Zhayrəsə səəkəy. A kə kaa Zhayrəsə na: «A zha gha va mətita, ka maw ghaa gagay Metər ma» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mbaꞌa Yesəw favə kwəma gəzə ntsa va va. Ma kə kaa Zhayrəsə na: «A Zhayrəsə, ka dza her gha ma, ɓanavə nəfə tsa gha kaa Hyala gwaꞌa tsəgha, ta mbəlita dza zha gha va» kə. War a ghəshiy nəw lə kwal tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dza ndəs ghəshi tsəhəshi miy dəgha Zhayrəsə ki. Dza Yesəw mbaꞌa makəti mbəzli gwanashi ni va dzakə ghi tsa va kwasəbə. Kwataka Piyer, ghəshi lə kar Zhaŋ lə Zhakə, mbaꞌa kar dəta zha va lə mbəghəta shi pəməvə na gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma sa dzakəshi ghəshi na, mbaꞌa ghəshi kəsashi nihwəti mbəzli, war a ghəshiy wahə, ka tihwəniy dzəkən zha va. Ma kə Yesəw ngəshi na: «Kadiwəm, ka wahə ghwəy ma. Mətita zha naw, hiy ɓəhwə na gwaꞌa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma sa favə mbəzli kwəma gəzəkə na va tsəgha na, njasa pəꞌwə na kwəma ka gazlaka ghəshiy nighə. Sa sənay ghəshi a zha va məti ta, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dzəghwa Yesəw naci ki, tasl kəsəvə zha va tə dəvə nzə. Ma kə kaa ngəta zlaŋzlaŋ na: «A zhee, satiŋa!» kə ");
INSERT INTO bcw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","War sa gəzəkə Yesəw tsəgha na, nzaꞌjəw piy tsa nzə zhəkəy zhəmbə. Kə pəlhəm satita. Ma kə Yesəw kaa mbəzli, sa satita na na: «Ɓantam shi zəmə a ghənzə zəmə shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dza nava kwəma, mbaꞌa mananatishi maɗaŋa kaa kar dəta zha va, lə mbəghəta. Ma kə Yesəw kaa ngəshi ki na: «Əntaa ghwəy dzaa gəzə kwəma na ya kaa waɓa ma» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ma tə nahwəti vici na, dza Yesəw mbaꞌa ɓasəti mbəzli ta səɗa ci va məŋ lə bakə ni. Dza na mbaꞌa ɓanavəshi bərci ta tihə hyeler gwanashi səvəri mbə ghən mbəzli, lə ta mbəli ka zəlghwə. ");
INSERT INTO bcw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dzəghwa na ki, mbaꞌa ghwənashi ta gəzə kwəmaa dzəkən sləkə tsa dza Hyalaa sləkə mbəzli, lə ta mbəli ka zəlghwə, ");
INSERT INTO bcw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ma kə ngəshi na: «Mbalam, ghwəy kafəy, əntaa ghwəy dzaa ɓə ya waɓa ta dəvə ghwəy ma. Ya gəta, ya mbəl ta ɓə shiy, ya shi zəmə, ya gənay, əntaa ghwəy ɓə ma. Zhini ɓay, ya tsama ndə mbə ghwəy na, əntaa ghəci ɓə kwəbeŋer bakə ta dza va ma. ");
INSERT INTO bcw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ya mbə namaɓa məlmə dza ghwəy tsəhəŋwəyəy, mbaꞌa kə ndə kaꞌwətəŋwəy kəghi tsa ci na, əntaa ghwəy mbəərə ghi ma. War kəghi tsa kwətiŋ tsa pə ghwəy taa nzəy paꞌ fəca dza ghwəy səvəriŋwəy mbə nava məlmə. ");
INSERT INTO bcw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mbaꞌa pə ghwəy tsəhəŋwəy mbə məlmə, kala zləɓa fəŋwəy gwəci tsa ghwəy mbəzli mbəy, səvəriŋwəy tə ghwəy mbə nava məlmə. Ghwəy səvəriy, nza ghwəy batamti kwərbi mbə məlmə shi tə shiɗshiɗ ghwəy, ta mbə ghəshiy sənay a ghəshi mənti *kwəma jikir na, kə ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma sa gəzanakəshi Yesəw kwəma va tsəgha na, mbaꞌa mbəzli ta səɗa ci va kafəshi. Dza ghəshi ka dzar mbə məlməhi gwanashi, ka gəzə Yəwən kwəma wəzə na kaa mbəzli, ka mbəmbəli ka zəlghwə ya kwəma kəsashi ghəshi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma ghala vəghwə tsa va ki na, cəkeꞌ ngwəmna Erədə favə kwəma məməni Yesəw va. Dzəghwa raꞌi ghəci zay va nava kwəma tsəgha. Sa nzana, ma nihwəti mbəzliy: «Wa Zhaŋ tsaa niy mənipə *batem va na sava zhəkəməy na kwa kwəli» kə ghəshi niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma kə nihwəti na: «*Eli ndə gəzə kwəma Hyala na sava tsahwəy na» kə niva. Ma kə nihwəti ɓa na: «Waa ndə gəzə kwəma Hyala tsa mbəradzə na sava zhəkəməy na kwa kwəli» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma kə Erədə na naci ki na: «Ya gar nə ya Zhaŋ na sava pənəy, e niy slanti ghən tə Zhaŋ. Əy wa ndə na, tsatsa ntsa gəzə məndi tsa kwəmaa dzəkən tsətsə diɓa kia?» kə. Dza tapə ghəci mbə pəla kwal tsaa nay Yesəw dəꞌwə ghən tsa ci ki. ");
INSERT INTO bcw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma sa dza *ka kwal Yesəw mənikə sləniy niy ghwənashi Yesəw va ti ki na, mbaꞌa ghəshi zhəkəshi. Cəkeꞌ ghəshi gəzanakə shi məmənəhwə ghəshi kaa Yesəw. Dza Yesəw mbaꞌa pəməvəshi ka dzay li shiy dzəti pətsa kama mbəzli ti, ta dza nzəyshi kwətishi. Pətsa dzashi ghəshi vaa dzəti na, ndəkwə ghəci vəgha məlmə Betəsayda. ");
INSERT INTO bcw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nzaꞌjəw mbəzli ɗaŋ sənivəshi, mbaꞌa ghəshi nəwghəshi tə səəbə. Dzəghwa sa tsəhəshi ghəshi vəgha Yesəw na, mbaꞌa kaꞌwətishi lə nəfə kwətiŋ. Dza na mbaꞌa gəzanavəshi kwəma njasa dza Hyalaa sləkə mbəzli. Mbaꞌa mbalamti niy səəkəshi ta mbəli ghən tsa shi va zəlghwə. ");
INSERT INTO bcw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dzəghwa mbaꞌa tihwer ꞌwati məniva, ma sa nata *mbəzli ta səɗa Yesəw va məŋ lə bakə ni vici ndəkwə ndəkwə ta pəkw na, dza ghəshi, kət ghəshi kətəghəvashiy dzəvəgha Yesəw. Ma kə ghəshi ngəci na: «Wəzəɓa ɓanavə gha kwal kaa mbəzli ni, a ghəshi ndanivaa dzashi dzar mbə məlməhi lə mbə giwahi ndəkwə ndəkwə ni, ta pala shi zəmə shi, lə pətsa dza ghəshiy hi ti gwaꞌa. Sa nzanay, gamba na pətsa nza ghwəmmə tsa ti tikə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma kə Yesəw ngəshi naci ki na: «Ɓanshim shi zəmə dəꞌwə ghən tsa ghwəy, a ghəshi zəməshi» kə. Ma kə ghəshi ngəci na: «Nihwəti shiy va ghəy tikə, kala war peŋ cifəy mbaꞌa kərpi bakəshiw. Mbaꞌa pə ghaa ɗi ghəy dza ta pa shi zəmə, ta ɓanshi kaa mbəzli tikə ni gwanashiy, mbə nava» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Zhərəy niy nza tə pətsa vay, a ghəshi mənti gar bələkwə bələkwə cifə mətsəkə. Ma kə Yesəw kaa mbəzli ta səɗa ci na: «Tihəvərim mbəzli va, a ghəshi nzəyshi, cifə mətsəkə, cifə mətsəkə, cifə mətsəkə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dza mbəzli ta səɗa ci mbaꞌa ghəshi tihəvərishi njasa gəzəkə na va, mbaꞌa mbəzli va nzəyshi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma sa nzəyshi mbəzli ki na, dza Yesəw tsəgha, həŋ ɓəvə peŋ tsa cifə tsa va mbaꞌa kərpi bakə ni va ta dəvə ci, mbaꞌa kafata kwəma ciy dzəta ghwəmə, ka mananta ꞌwəsa kaa Hyala ta shi zəmə va. Ma sa mananati na ꞌwəsa kaa Hyala na, dza na mbaꞌa ngangavəri peŋ tsa va, mbaꞌa ɓanavə kaa mbəzli ta səɗa ci, a ghəshi tahanshi kaa mbəzli ɗaŋ ni va. Dza mbəzli ta səɗa ci həŋ həŋ ghəshi ɓəvə, ka tahanshi kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mbaꞌa mbəzli va zəməhwə shi va gwanashi, bəhə bəhə bəhə ghəshi, mbaꞌa mbəvəli tərə. Dza məndi kaa naa tərmbəta mbəvəli ɓasə ɓasə məndi ɓasəti, gyaɗə gyaɗə ghwani məŋ lə bakə. ");
INSERT INTO bcw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ma tə nahwəti vici ki na, mbaꞌa Yesəw dzaa nzəyəy kwətiy ka cəꞌwə Hyala. Dza mbəzli ta səɗa ci ndəs ghəshi səəkəshiy dzəvəgha. Ma sa səəkəshi ghəshi na, dza na ka ɗəw kwəma və shi, a kə na: «A ndə nzee ka mbəzliy ni baya?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma kə ghəshi ngəci na: «Zhaŋ tsaa mənipə *batem nza gha, ka nihwəti mbəzliy ni. Nihwəti na: *Eli nza gha, kə ghəshi. Ma nihwəti ɓa na: Tsahwəti ndə mbə ka gəzə kwəma Hyala mbəradzə zhakatiy na mbə məti nza gha, kə shi» kə mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma kə Yesəw ngəshi na: «Ya ghwəy na ghwəy kiy, wa ndə nzee ka ghwəy nia?» kə. Ma kə Piyer na: «Ghay Kəristəw nza gha, Ntsa tivə Hyala ta mbəli mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ma sa gəzəkə Piyer tsəgha na, dza Yesəw mbaꞌa makətishi vantaa ghəshi dzaa gəzə kwəma va, ya kaa waɓa. ");
INSERT INTO bcw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma kə Yesəw kaa *mbəzli ta səɗa ci diɓa na: «Yən yən, Zəghwə yakə ndə ngəriy, ta sahwə ngəraꞌwə dzee dalala. Mətikwəkwər mbə *ka Zhəwifə ghəshi lə mbəzli dikə dikə ni mbə *ka ta Hyala, mbaꞌa *ka ɓənipə kwəma pəhəti Hyalay, ka dza ghəshiy ɗi mətsə yaw. Ta paslantəra dza məndi, ma sa kee mətiray, ta zhakatira dzee mbə məti, tə kwa mahkana vicee kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dzəghwa ma kə kaa mbəzli gwanashi ki na: «Mbaꞌa kə ndəə ɗi nəwray, a kə tsava ndə zlay zəzəə dzəkən tsa ci ghən, mbaꞌa zləɓavə sa ngəraꞌwə lə mətita gwaꞌa, njasa səəmə vici, ma nza ghəci nəwra. ");
INSERT INTO bcw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa nzana, ya wa ntsaa ɗi mbəliti piy tsa ci tikə tə hiɗiy, ta zamti tsa mə ghwəmə piy tsa ci dza na. Ma ntsaa dzaa zamti piy tsa ci tikə tə hiɗi tə mbərkə kwəma yay, ta mbəliti tsa mə ghwəmə piy tsa ci dza tsava ndə. ");
INSERT INTO bcw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nay ghwəy na, ya shi tə hiɗi ni gwaꞌa gwaꞌaa kwəmavə ndə mbaꞌa piy tsa ci mə ghwəmə zay, awə na mbaꞌa yaɗamti ghən tsa ciy, shiy tiɓa ndəə ꞌwəy ti mbə kwəma va tsəghaw. ");
INSERT INTO bcw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mbaꞌa kə ndəə haꞌwə va ndəgha fətiy dzəkənee, ya va gəzə kwəmee kaa mbəzliy, ta haꞌwə dzee, yən Zəghwə yakə ndə ngəri va ndəgha fətiy dzəkən kwərakwə, ghala vəghwə tsa dzee zhəkə mbə shəndəkə tsee lə mbə shəndəkə tsa Dirə, mbaꞌa sa ka kwal ci ɗewɗew ni mə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A gəzaŋwəy ya, ta na navay, tsəgha na, a nihwəti mbəzli mbə ghwəy ghwəy mbəzli tikə niy, ka ghəshi gha bəkwə na ta nay dza ghəshi njasa dza Hyalaa sləkə mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma sa məniy hi gar dəghəsə ləy hwəm kwəma gəzəkə Yesəw va ki na, dza na mbaꞌa pəməvə kar Piyer, lə Zhaŋ mbaꞌa Zhakə. Mbaꞌa dzay li shiy dzəmə kəlaŋ ta cəꞌwə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sa tsəhəshi ghəshi ki na, mbaꞌa ꞌwati cəꞌwə. Ma ghəci mbə cəꞌwə na, dza pətsa mbə kwəma ci mbaꞌa zhəghəkə nahwəti pa. Ma kwəbeŋer kən ghən ci na, tezlezlezlezl ghəshi zhəghəshi, ka mbərə. ");
INSERT INTO bcw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Dzəghwa, vətəghə zhər bakə təzlishi tiɓa lə shəndəkə tsa mə ghwəmə kən shi. Dza ghəshi ka gəzə kwəma lə Yesəw dzəkən məti dza na va ta məti mbə məlmə Zherəwzalem, ta kərkə sləni ci niy ghwənikə Hyala ti. Zhər vay kar *Məyizə lə *Eli niy nza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma kar Piyer lə nihwəti mbəzli va ghalaɓa nashi ki na, ciŋ ciŋ ciŋ ghəshi ɓa ɓanti hi. Dzəghwa mbaꞌa ghəshi fərghəshi. Sa fərghəshi ghəshi na, mbaꞌa ghəshi nay shəndəkə tsa Yesəw, lə zhər bakə ni va nza na li shi. ");
INSERT INTO bcw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dza mbəzli bakə ni va ki, mbaꞌa ghəshi kafəshi ta zhashi. Ma ghəshi mbə tihəva lə Yesəw ki, ma kə Piyer kaa Yesəw na: «A Metər, jəw na wəzə ghwəmmə nzəyəmmə tə pətsaw, kadiw a ghəy daŋəti ceker mahkan. Kwətiŋ tsa gha, mbaꞌa tsa Məyizə, mbaꞌa tsa Eli» kə. Ma na Piyerəy, niy sənay ghən tsa kwəma ɗi na va gəzə naw. ");
INSERT INTO bcw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma ghəci mbə gəzə kwəma va tsəgha na, ꞌwakəvə kwəleɓi tə ghwəmə zləlahə səəkəshi, zhəmakə məcakwə shi dzəkənshi kən kar Yesəw lə mbəzli bakə ni va. Ma sa nata *mbəzli ta səɗa Yesəw kwəma va tsəgha na, mbaꞌa her shi dzashi. ");
INSERT INTO bcw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Fa ghəshi na, məli Hyalaa gəzanshi kwəmaa dzəkən Yesəw səəkə mbə kwəleɓi va, ma kə na: «Favə tə ghwəy, ava ghəci na Zəghwee təravee, fam kwəma və» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","War sa gəzamti məli Hyala kwəma na, nay ndə ghəshi tiɓa ghwəlaw, war Yesəw kwətiy. Ləy hwəm kwəma va na, gwəŋəshi mbəzli ta səɗa Yesəw niy nzəyshi, kala gəzə ma kwəma nata ghəshi va, ya kaa waɓa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ma tə way pi həzlimə ki na, mbaꞌa kar Yesəw lə *mbəzli ta səɗa ci va mahkan ni səkwashi mə kəlaŋ tsa va. Ma sa səkwashi ghəshi na, dza mbəzli ɗaŋ, mbaꞌa ghəshi səəkəshiy dzəghwa kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dza tsahwəti ndə mbə mbəzliy ɓasəshi va, ka zlaŋə kwəma, ma kə na: «A ntsa dikə tsa, ə cəꞌwəŋee, nighətima zəghwee na, war kwətiŋəy na tsəgha vəya. ");
INSERT INTO bcw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sana kiy ndə bashakə na. Kafəy ma bashakə tsa va tiy, war ə ka naa ngwəmə lala, ka mərmərə lə bərci. Ka gha nighə na tsəkwəf kwəf kwəf gwifgwifi ta miy ci. Tərəŋw ka naa sanamiy ngəraꞌwə. ꞌYahəꞌyahə ka naa gha dəkə mbə ghən ci kafəy ma na ti. ");
INSERT INTO bcw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naa niy səəkəree, ka cəꞌwə mbəzli ta səɗa gha nee, a ghəshi təhamtəra bashakə tsa va mbə ghən ci, pən na, kala mbay ghəshiy tahamti» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma sa gəzəkə ntsa va tsəgha, ma kə Yesəw kaa mbəzli na: «Mata ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsa gəmgəm niy, ɓanavə nefer ghwəy ghwəy kaa Hyalaw. Paꞌ hwəm ɗi ghwəy yən nzəyra lə ghwəy kia? Hwəm dzee kərə lə səꞌwa kwəma ghwəy kia?» kə. Sa gəzəkə na tsəgha, a kə kaa dəy zəghwə va na: «Pəməra zəghwə gha vaa səəkə tikə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dza məndi ka dza ta pəmə zəghwə va. Ma ghəci mbə səəkə na, dza bashakə tsa va, mbeɓ fati tə pi. War a ghəciy mərmərə lə bərci. Dzəghwa Yesəw ki, mbaꞌa gəzanakə kwəma lə bərci kaa bashakə tsa va, mbaꞌa tahamti. Dza na kwəriŋ mbəlanti zəghwə va, mbaꞌa pəmanavə kaa dəy. ");
INSERT INTO bcw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma sa nashi mbəzli tiɓa gwanashi shi va na, ka mananshi maɗaŋa, sa nata ghəshi bərci Hyala. Ya wa ndə na, war mbə mananci maɗaŋa kwəma mənti Yesəw va ki. Ma kə kaa mbəzli ta səɗa ci na: ");
INSERT INTO bcw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Kwəma dzee na ta gəzaŋwəy sanay, fə tə ghwəy ghən ti wəzə. Ma yən yən Zəghwə yakə ndə ngəriy, ta kəsəvəra dza məndi, mbaꞌam fambəra mbə dəvə mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma mbəzli ta səɗa ci nashi ki na, favə shi ɗi Yesəw gəzə ghəshiw. Mbəmbə niy nza sləkar tsa kwəma va və shi, va nəghətaa ghəshi favə shi ɗi naa gəzə. Mbə ghəranshi hazləni niy nza ta ɗəw shi va va Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dzəghwa *mbəzli ta səɗa Yesəw, mbaꞌa ghəshi dzəmbəshi mbə ngərə ghəpə kwa jipə shi, ta mbəə sənay, nda a ntsaa gwəra dikə mbə shi. ");
INSERT INTO bcw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mbalaa cəkeꞌ sənata Yesəw kwəma təkə ghəshi mbə nefer shi, naci ki. Dzəghwa na kaa zəghwə jəwə pəm pəməvə, dza na mbaꞌa garəy kwa kwəma ci. ");
INSERT INTO bcw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma kə kaa ngəshi na: «Nay ghwəy na, a gəzaŋwəy ya, ya wa ntsaa kaꞌwəti zəghwə jəwə nja sasa tə mbərkə kwəma yay, yən dəꞌwə ghən tsee na sa kaꞌwəti na tsəgha. Mbaꞌa kə ndə kaꞌwətəray, aa kaꞌwəti ntsaa ghwənikəra va kwərakwə. Sa nzanay ntsaa dzaa zhəghəti ghən tsa ci jəwə mbə ghwəy gwanaŋwəyəy, ghəci na ntsa dikə tsa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma sa gəzamti Yesəw kwəma, ma kə Zhaŋ kaa ngəci na: «A Metər, a ghəy nay tsahwəti ndə ghəci mbə tihə gazlaka lə slən tsa gha. Mbaꞌa ghəy makəti na ghəy, sa kama na kwasəbə ghwəmmə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma kə Yesəw ngəci na: «Zlayəm, ka makə ghwəy ma. Sa nzana, ma ntsaa kama mbə jaka lə ghwəyəy, ntsa ghwəy na tsava ndə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dzəghwa vici dza Yesəw ta dzay dzəmə ghwəmə ti, mbaꞌa kətikəvata. Ghala vəghwə tsa vay, dza na mbaꞌa pəhəti dzaa dzəmbə məlmə Zherəwzalem mbə nəfə tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa pəhəti na tsəgha na, dza na, mbaꞌa ghwənashi ka ghwəni miy tə kwəma ci. Dza mbəzli va pəkw ghəshi dzashi, ndəs ghəshi tsəhəshi mbə nahwəti məlmə tə hiɗi ka Samari ta dzaa gwəmanati pi fə gwəci tsa Yesəw mbə. ");
INSERT INTO bcw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma mbəzli mbə məlmə va na, kala zləɓa kaꞌwə ci ghəshi, sa nzana va dzəmbə məlmə Zherəwzalem ghəci dza. ");
INSERT INTO bcw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma sa nata *mbəzli ta səɗa Yesəw, kar Zhakə ghəshi lə Zhaŋ nava kwəma tsəgha, ma kə ghəshi kaa Yesəw na: «A Ndə sləkəŋəy, ka ɗi gha ghəy cəꞌwə Hyala a ghənzə ghwənəkəghwa ghwə səəkə mə ghwəməə ndamtishi na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ꞌWakəvə Yesəw tsəgha tərəɗ, zhəghətəvay, dza kwa shi, ka naɓəshi. Ma kə ngəshi na: «A ntsaa fambəŋwəy gəla nana zəzə kwəma mbə ghən tsa ghwəya? Na nee yən Zəghwə yakə ndə ngəriy, ta zamti piy tsa mbəzli səəkə yaw, ta mbəlishi səəkee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma ləy hwəm kwəma va ki na, dza ghəshi mbaꞌa ghəshi dzashiy dzəmbə nahwəti məlmə. ");
INSERT INTO bcw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma kar Yesəw kwa kwal mbə dza ki na, dza tsahwəti ndə tiɓa, mbaꞌa ghavə gəzanci kwəma. Ma kə ngəci na: «A Ndə sləkəpə, ta nəwŋa dzee, ya paꞌ kwəmaɓa dza ghaa dza» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma kə Yesəw kaa ngəci na: «A pə gha zəzəvə kwəma wəzə di, a gha sənay, ma keŋkiɗiy a ghi tsa shi və shi mbə hiɗi. ꞌYegwer ɓa na, lə tsa shi ghi ghəshi mə fə. Ma na nee yən Zəghwə yakə ndə ngəriy tsee ghi tiɓa gar dəkətəvaree mbə kiw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma kə kaa tsahwəti ndə na: «Nəwra dzam» kə. Ma kə ntsa va na: «A Ndə sləkəpə, ndara kwal, e dzaa lamti dirə di, kee gha səəkə ta nəwŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma kə Yesəw ngəci na: «Zlashi mbəreketi tiɓa a ghəshi lala ghən tsa shi. Na na ghay, mbala ta gəzə njasa sləkə Hyala mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma kə tsahwəti ndə kaa Yesəw ɓa na: «Yən neyey, ta nəwŋa dzee Ntsee dikə tsa. Ma nanzə kiy, ndara kwal e dzaa səkwamti mbəzli kəghi tsee, ma nzee səəkə ta nəwŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma kə Yesəw ngəci na: «Mbaꞌa kə ndə kəsəvə ngwər slay ta za, zhini mbaꞌa dzay ta nighə pətsa zhəy ləy hwəməy, ta dzay dza ngwər tsa vaa dzəvəgha bəla. Tsəgha na lə ntsaa ɗi nəwra kwərakwə, mbaꞌa kə zhiniy dzay ta zəzə shi dzəy lə hwəməy, dzəkwətəvay tsava ndə ta gəzə sləkə tsa dza Hyalaa sləkə mbəzliw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma ləy hwəm kwəma va ki na, dza Yesəw Ntsaa sləkəpə mbaꞌa təravə nihwəti mbəzli mbərfəŋ mətsəkə bakəti. Dza na mbaꞌa ghwənashi, bakə bakə bakə kwa zəərə shi, a ghəshi dza kwa kwəma kwa kwəma ci, dzar mbə məlməhi gwaꞌa gwaꞌa lə dzəti pətsa dza naa dza dəꞌwə ghən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dzəghwa, ma kə kaa ngəshi kwa fir na: «A mbəzlee, ɗaŋ shi zəmə nakamtəvashi kwamti ngar na, daw mbəzli ta ɓasəshi səəkə tə vəhəə jighi. Ghənzə tsəghay, cəꞌwə pə ghwəy cəꞌwə ndə za tsa va, a ghəci mətsəhə ghwəni nihwəti mbəzli dzəmti, ta mananci shi ci vaa səəkə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ma kə diɓa na: «Nana kiy satim, mbalam, aa ghwəniŋwəy ya, nja ndərazhi teŋkesli ka məndi vaa kambə mbə jipəjipə dəghwava jezlhi. ");
INSERT INTO bcw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Əntaa ghwəy dzaa ɓə ya mbəl pas tsaa ɓə gəna kwa, ya mbəl ndə dza ta wə, ya kwekweher nzə ma. Ghwəy mbə kwaləy, əntaa ghwəy səkwə mbəzli ma. ");
INSERT INTO bcw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ya tsama ghi dza ghwəy dzakəŋwəyəy: “Ndaŋwəy zərkə Hyala mbə nzəy tsa ghwəy kəykə” pə ghwəy taa ni kaa mbəzli kəyɓa ghwəy dzakə. ");
INSERT INTO bcw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma ghalaɓa, mbaꞌa kə ntsa zərkə nəfə tsa kəghi tsa vay, ta dzəkən dza zərkə tsa ɓəghə ghwəy va. Ma kala gəla tsava ndə kəyɓay, ka dza zərkə tsa gəzanshi ghwəy vaa nza kən shi ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mbaꞌa kə ndə kaꞌwətəŋwəy kəghi tsa ciy, nzəyŋwəy tə ghwəy kəyɓa. Ka zəmə shi zəmə ɓəŋwəy məndi kəyɓa, ka sa shi sa ɓəŋwəy məndi kəyɓa diɓa. Sa nzanay, mbaꞌa kə ndəə ghəra sləni na, aa təɓə məndiy nganci shi zəmə ci. Əntaa ghwəy dzaa təɗi ghi kəy pətsa gha ghwəy nzəy kəy, ta dzakə tsahwəti ghi, mbə məlmə kwətiŋ na ma. ");
INSERT INTO bcw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mbaꞌa pə ghwəy tsəhəŋwəy mbə məlmə, dza mbaꞌa məndi kaꞌwətəŋwəy mbəy, a pə ghwəy taa zəmə shi dza məndiy ɓəŋwəy mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ka zəlghwə dza ghwəy kəsashi mbəɓay, ka mbəlishi. A pə ghwəy taa ni kaa mbəzli mbə məlmə vay: “Ndəkwə ndəkwə na Hyala ta səəkə ta sləkəŋwəy” pə ghwəy taa ni ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma mbaꞌa pə ghwəy tsəhəŋwəy mbə məlmə, kala zləɓa kaꞌwəŋwəy məndi mbəy. Səvəriŋwəy tə ghwəy dzəti pətsa ka məndiy ɓasəva mbəɓa. Tsaꞌ pə ghwəy taa ni ngəshiy: ");
INSERT INTO bcw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ava ghəy batəyŋwəy lə kwərbi mbə məlmə ghwəy ta niy dzətishi tə shiɗshiɗ ghəy, ta mbə ghwəy sənay a ghwəy mənti *kwəma jikir na, pə ghwəy. Nanzə kiy, sənay tə ghwəy wəzə, ndəkwə ndəkwə na Hyala ta səəkə ta sləkəŋwəy” pə ghwəy taa ni ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A gəzaŋwəyee, fəca dza Hyalaa məni ngwəvəə dzəkən mbəzliy, tərəŋwɓa ngəraꞌwə tsaa dzaa nza kən mbəzli mbə nava məlmə dza naa nza kən ngəraꞌwə tsaa dzaa nza kən mbəzli mbə məlmə *Sədəm» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dzəghwa, ma kə Yesəw na: «Ghwəy ghwəy mbəzli mbə məlmə Kwəraziŋ lə ghwəy ghwəy mbəzli mbə məlmə Betəsayda, a ngəraꞌwə taa nza kən ghwəy. Sa nzana mbə məlmə Tir lə mbə məlmə Shidaŋw pən niy mənəhwə shi maɗaŋa maɗaŋa ni ni mənəhwee mbə ghwəy nzay, ci mbəzli mbəɓa tsəfəkwəshi, ka tsati titihwə ka zhəghanti nzəy tsa shi kwa kwəma Hyala va kwəma shi jikir na nza. ");
INSERT INTO bcw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Va tsəgha kiy, fəca dza Hyalaa məni ngwəvəə dzəkən mbəzli na, tərəŋwɓa na ghwəy ngwəvə dza naa nza kən na mbəzli mbə məlmə Tir lə mbəzli mbə məlmə Shidaŋw. ");
INSERT INTO bcw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ghwəy ghwəy mbəzli mbə məlmə Kapernahwəm kiy, mbəzli dza məndiy kafashiy dzəta ghwəmə nza ghəy na ghəy ki nə ghwəy na, nava tiɓa teepəw. Ta dzəghwa dza ghwəy paꞌ tə pətsa nza mbəreketi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ma kə kaa mbəzli ta səɗa ci diɓa ki na: «Ya wa ntsaa fa kwəma ghwəyəy, kwəmee fa na kwərakwə. Ya wa ntsaa ɗi ma fa kwəma ghwəyəy, kwəmee ɗi ma na fa kwərakwə. Ya wa ntsaa ɗi ma fa kwəmee kwərakwə diɓa na, kwəma ntsaa ghwənara na sa ɗi ma na va fa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dzəghwa mbəzli mbərfəŋ mətsəkə bakəti ni va niy ghwənashi Yesəw ki, mbaꞌa ghəshi zhəghəkəvashi mbə dzashi va lə vəshi. Ma kə ghəshi kaa Yesəw sa səəkəshi ghəshi na: «A Ndə sləkəpə, lə hyelershi ɗitəŋəy na fəti. Sa ka ghəy tihəshi səvəri mbə ghən mbəzli lə slən tsa ghay, ka səvəri ghəshi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma kə Yesəw ngəshi na: «Tsəgha na, mbə nay *ndə jaka tsa Hyala niy nzee ghəci mbə tərə səəkə mə ghwəmə, wampiɗ, kə, nja wampiɗi van. ");
INSERT INTO bcw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Favə tə ghwəy: Avee ndaŋwəy bərci ta dza ghwəy dzar tə shesher lə dzar tə yətihi, zhini ka təɗanakən bərci kaa ndə jaka tsa Hyala. Shiy tiɓa dzaa mbaŋwəyəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nanzə kiy, ka vəshi ghwəy war tə sa ɗitəŋəy hyeler fəti ma, tə sa nzana mbaꞌa Hyala tsasliti slən tsa ghwəy mə ghwəmə pə ghwəy vəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma geꞌi ghala vəghwə tsa səəkəshi mbəzli vaa gəzanci kwəma kaa Yesəw ki na, mbaꞌa safə tsa Hyala ɗewɗew tsa təhanay nəfə tsa Yesəw lə vəshi. Ma kə na: «A Dirə tsaa sləkə ghwəmə lə hiɗi, ꞌwəsa nə ya ngəŋa, sa nzana ma kwəmaa niy mbələy gha na va mbəzliy sənata kwəma ghəshi lə ka məhərliy, a gha canakəvərishi kaa mbəzli daw daw ni tə sənata kwəma. A Di a falŋee, sa nzana tsəgha gha ɗi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ma kə Yesəw kaa mbəzli ki na: «Mbə dəvee fambə Dirə shiy gwanashi. Ndə tiɓa mbaꞌa sənata kwəmee kala war Dirəw. Ndə tiɓaa sənata kwəma Dirə kala war yən yən Zəghwə ci, mbaꞌa ntsa nə ya e ɗi canati Dirə pənəw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sa gəzəkə Yesəw tsəgha ki na, dza na, tərəɗ zhəghəghəvay dzar kwa mbəzli ta səɗa ci. Ma kə kaa ngəshi kwətishi na: «Vəshi na va ghwəy, sa kwəmavə ghwəy nashi shi mənti Hyala lə mətsəhi ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sa nzana e gəzaŋwəyəy, ka gəzə kwəma Hyala ɗaŋ, lə mezhizhə ɗaŋ niy ɗi na nashi shi nashi mətsəhi ghwəy ni sənzənva, kalaa niy kwəmavə nashi ghəshi. Mbə ɗi fa kwəma favə ghwəy na sənzənva ghəshi niy nza na, a kwəmavə fa nzə ghəshiw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma tə nahwəti vici na, dza tsahwəti *ndə ɓənipə kwəma pəhəti Hyala, mbaꞌa səəkəy dzəvəgha Yesəw ta ngali lə kwəma. Ma kə kaa Yesəw na: «A Metər, wa shi dzee mənti, kee kwəmavə piy tsaa kəɗi maa?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma kə Yesəw ngəci na: «Njaa nə məndi kaa kwəma tsasliti məndi mbə kwəma pəhətəmmə Hyala ta mənia? Njaa na kwəma ka ghaa favə gha mbə jangə nzəa?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma kə ntsa va na: «A kə məndi mbə kwəma pəhəti Hyalay: “Ɗi pə ghaa ɗi Hyala gha sləkəŋa, lə nəfə tsa gha gwanay, lə bərci gha gwanashi, lə məhərli gha gwanata, mbaꞌa gha ɓanavə ghən tsa gha gwanay. Zhini diɓay, ɗi nihwəti mbəzli gwanashi njasa ɗi gha va ghən tsa gha kwərakwə” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma sa zləɓakə ntsa va tsəgha ki, ma kə Yesəw kaa ngəci na: «Kay, wəzə zləɓati gha kwəma va. Mbala məni war tsəgha, ta kwəmavə piy tsaa kəɗi ma dza gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma ntsa va na, kala ɗi ghəci kwəma vaa kəray və. Ma kə kaa Yesəw ki na: «Yaŋ, tsəgha na, sana kiy, wa na tsee ndə ghalaraa?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma kə Yesəw kaa zləɓanci kwa fir na: «Tə nahwəti viciy, mbaꞌa kafəy tsahwəti ndə Zhəwifə mbə məlmə Zherəwzalem ta dzaa dzəmbə məlmə Zherikwə. Ma ghəci mbə kwal na, mbaꞌa ka ghəli pəslishi ti. Dza dəꞌwə dəꞌwə ghəshi dəꞌwəti. Kwərat kwərat ghəshi səsərəhwə shiy kən ghən ci. Mbaꞌa ghəshi pahwə shi və gwanashi, ka dzashi. Tərə na war miy nəfə ta məti. ");
INSERT INTO bcw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma kwa kwəma jəw na, dza tsahwəti ndə ta Hyala tsa mbə hwəlfə kwətiŋ na li mbaꞌa dzakə dza ci kwa kwal tsa va. Mbaꞌa kəsay ntsa dəꞌwəvə ka ghəli va bəzhehə tiɓa kwa kwal. Ma sa nay na na, dza na, wəsl wəslivə kwal tsa ci, mbaꞌa zlay ntsa va tiɓa, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma kwa kwəma jəw ɓa na, zhəghwa tsahwəti ndə mbə hwəlfə Levi ɓa, ntsa nza ghəshi mbə hwəlfə kwətiŋ na li, mbaꞌa zhəkəy kwa kwal tsa va. Səəkə na na, mbaꞌa kəsay ntsa va war tə pətsa va bəzhehə. Ma sa nay na kwərakwə na, dza na wəsl wəslivə kwal tsa ci. Mbaꞌa zlay ntsa va tiɓa, ka dzay. ");
INSERT INTO bcw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma kwa kwəma jəw diɓa kiy, dza tsahwəti ndə ka Samari, ndə məlmə kala kama mbə hwəlfə ci, mbaꞌa dzakə dza ci kwərakwə. Səəkə na ndəs tsəhəy vəgha ntsa va. War sa nay na naci ki na, mbaꞌa hwər tsa ci zhanati tərəŋw ti. ");
INSERT INTO bcw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dzəghwa na kət kətəghəvay dzəvəgha ntsa va. Dza na kaa zheher ti njəꞌwə njəꞌwə naghamtishi, dza na mbaꞌa mananati ghwəꞌi tə zheher va, kə ki pəərə pəərə pəərətishi. Ma sa paramtishi na na, dza na tsaŋ ɓəvə, ɗal famə mə kwantəmca ci səəkə na li. Dza na mbaꞌa dzaa fəy mbə ciki tsa ka ka məlməə nzəy mbə tə gəna, ka zəlghwə ntsa va mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma tə way pi həzlimə ki na, mbaꞌa kafəy ta dzay. Dza na mbaꞌa ɓəvə gəna gar mbəl bakə, mbaꞌa ɓanavə kaa ndə ciki tsa va. Ma kə kaa ngəci na: “A dzaree ta dza, ndi gəna na, nza gha nighəə dzəkən ntsa va. Ya ə dza gəna dza ghaa zamti mbə kwəma ciy taŋəti nanay, sa kee zhəghəkəvara mbə dzee na e taa zhanavəŋa sa gha” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma sa kəɗamti Yesəw ɓəlanci fir tsa va kaa ndə ɓənipə kwəma pəhəti Hyala va ki, ma kə kaa ngəci na: «Mbə mbəzli mahkan ni va sana kiy, tsama na ndə ghalay ntsa dəꞌwəvə ka ghəli vaa?» kə ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma kə ntsa va na: «Vəya na neyey, ntsaa pəərəti zheher ci va na» kə. Ma kə Yesəw ki na: «Tsəgha na, gha kwərakwə kiy, mbala, gha dzaa məni tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dzəghwa kar Yesəw ghəshi lə *mbəzli ta səɗa ci, mbaꞌa ghəshi kafəshi ta dza. Ma ghəshi mbə kwal na, mbaꞌa ghəshi kəsata nahwəti məlmə. Mbaꞌa nahwəti mali niy nza mbə məlmə va, Martə, kə məndi kaa slən tsa nzə. Dza na mbaꞌa kaꞌwətishi kəghi tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martə vay, a zhaməmmə niy nza və, Marəy, kə məndi kaa slən tsa nzə. Dza Marəy nanzə kiy, paꞌ pavə pətsa nzə vəgha Ndə sləkəpə. Dərasə nzəyta war ka fa kwəma gəzə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Martə nanzə ki na, war a ghənzəə tsəva lə ghəra sləni ghənghən ghənghən kwətita. Dzəghwa na, kaf kafəta, dza ndəs tsəhəta vəgha Yesəw. Ma kə ngəci na: «A Ndə sləkəpə, kwəmaa shashaŋa tiɓa mbə kwəma zhamərə na, sa zlara na tsa mbə sləni, war e tsəva mbə kwətira tsəy? Gəzanta a ghənzə kəətira» kə. ");
INSERT INTO bcw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma kə Yesəw kaa ngəta na: «A Martə, wa nava dzaŋa gha ta təra kwəma tsəgha ɗaŋaŋaŋ, ka tasə ghən tsa gha tərəŋw tay? ");
INSERT INTO bcw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Shiy kwətiŋ na shiy gwəramti e gəzaŋa nee ki. Na na Marəyəy, a təravə bəlaa gwəramti wəzə. Zlata a ghənzə fa kwəmee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma tə nahwəti vici na, dza Yesəw ka cəꞌwə Hyala dzəghwa tə tsahwəti pi. Ma sa kəɗiy na lə cəꞌwə na, dza tsahwəti ndə kwətiŋ mbə mbəzli ta səɗa ci ka gəzanci kwəma, ma kə ngəci na: «A Ntsaa sləkəŋəy, ɓanavəŋəy cəꞌwə Hyala kwərakwə, njasa ɓananavə Zhaŋ va kaa mbəzli ta səɗa ci» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma kə Yesəw ngəshi na: «Mbaꞌa pə ghwəy cəꞌwə Hyalay. Vanta kwəma ka ghwəy gəzə: A Dəŋəy, a cəꞌwəŋa ghəy nza mbəzli mbəə sənay Hyala ɗewɗew na nza gha, kə ghəshi, ka fal slən tsa gha. Mazə nza gha, səəkə sləkəŋəy. ");
INSERT INTO bcw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɓəŋəy shi zəmə gar məkəŋəy vici va vici va. ");
INSERT INTO bcw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pəlataŋəy kwəma ghəy jikir na mənti ghəy. Sa nzanay, kar ghəy pəlata na mbəzliy məniŋəy *kwəma jikir na kwərakwə. Ndəghwətəŋəy vantaa *ndə jaka dzaa həərətəŋəy ta məni kwəma jikir na. Ava tsəgha ka ghwəy ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zhini ma kə kaa ngəshi ɓa na: «Sənzənvay ava ndə mbə ghwəy, mbaꞌa madigay və, dzəghwa na mbə daŋkala vərɗi pəkw dzay dzakə ghi tsa madigay tsa va. Ma kə kaa ngəci sa tsəhəy na na: “A madiga, va gha səəkee, a gha ngavəra shi zəmə nzee watəŋa shi gha. ");
INSERT INTO bcw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","A səəkəy tsahwəti madigara ta wə kəghi tsee, kala shi zəmə vəya ta ngancishi” kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A kə madigay tsa məhəni va kaa ngəci na: “Am, am, am! Kaa gagara gha ma! Kəəli kəəli na dəghee məcanata, məhəni ghəy lə ndərazhee gwanaŋəy. Ka mbay ya satira tə pi həni sənzənva ta ndaŋa shi vaw” kə ");
INSERT INTO bcw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya tsəgha gəzəkə na na, war ə madigay tsa vaa gagay lə cəꞌwə va ki. Mbaꞌa madigay tsa va satiy ɓanavə shi ɗəw na va gwaꞌa, sa gagay na, kala kama tə sa nza ghəshiy madiga. ");
INSERT INTO bcw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","A gəzaŋwəy ya kiy, cəꞌwəm shiy va Hyala, ta ndaŋwəyshi dza na. Pəlam shiy və, ta kwəmavəshi dza ghwəy. A pə ghwəy har, ta zləɓaŋwəy kwəma dza na. ");
INSERT INTO bcw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sa nzana, ya wa ntsaa cəꞌwə shiyəy, ta ɓanavəshi dza məndi. Ya wa ntsaa pəla shiyəy, ta kwəmavəshi dza na. Ya wa ntsaa tsa yashiy dzakə ghiy, ta zləɓanci kwəma dza məndi. ");
INSERT INTO bcw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Didi tiɓa mbə ghwəy, ka ɗəw ɗafa zəghwə ci və na, dza tsaŋ ɓəvə hakwə ka ɓanci na? Ka ɗəw kəlipə ghəci və na, nza naa ɓanavə shishi ka məjəꞌa kəlipə va na? ");
INSERT INTO bcw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ya zəghwə ciy cəꞌwə slisli kwəkwəla və na, nza naa ɓanci yiti na? ");
INSERT INTO bcw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ma ghwəy ghwəy mbəzli gəmgəm ni mbaꞌa ghwəy sənay ɓanshi shi wəzə ni kaa ndərazhi ghwəy na, hanaɓa Dəŋwəy tsa mə ghwəmə ka na mbay ma ɓanavə Safə tsa nzə ɗewɗew tsa kaa mbəzliy cəꞌwə və shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A tsahwəti ndə niy nza tiɓay, mbaꞌa *hil niy pəhəti ghani ci, kala mbə ghəciy gəzə kwəma. Dzəghwa Yesəw tə nahwəti vici, mbaꞌa tihəkəvəri hil tsa va mbə ntsa va. Ma sa səvəriy hil tsa va mbə na, ka gəzə kwəma ntsa va. Sa nata mbəzli ɗaŋ ni va ɓasəshi tə pətsa va nava kwəma na, ka mananshi maɗaŋa ghənzə. ");
INSERT INTO bcw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma kə nihwəti mbəzli nashi ki na: «Belzhebəl, mazə tsa mbə hyeler ɓanci na bərci tihə na va nihwəti hyeler səvəri mbə ghən mbəzli li shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dza nihwəti ɓa, ka pəla ngali ci lə kwəma. Ma kə ghəshi kaa Yesəw na: «Mənti shi maɗaŋa maɗaŋa ni, ti dza ghəy gha sənay Hyala ghwənikəŋa na kataŋ, pə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Na na Yesəw naci ki na, gwaꞌa gwaꞌa ghəci sənata kwəma mbə ghən shi. Ma kə ngəshi na: «Mbaꞌa kə mbəzli dikə dikə ni zəmə hiɗi dzəmbəshi mbə pa jaka kwa jipə tsa shiy, ta zamti ghən tsa shi dza ghəshi. Ka ceker shi dzay, ka ngangazlavaa dzəkən nihwəti. ");
INSERT INTO bcw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mbaꞌa kə *ndə jaka tsa Hyala dzəmbəy mbə pa lə mbəzli ciy, ta ndanivərivay dza mazə tsa ci va. Ma pə ghwəy mbə gəzə kwəma ghwəyəy, lə bərci ndara Belzhebəl tihee hyeler mbə ghən mbəzli, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mbaꞌa pən tihə hyeler lə bərci ndara Belzhebəl kiy, ya nihwəti mbəzli ghwəy va tihə hyeler va na, wa ntsaa ɓanshi ni shi va bərci kia? Sləni ghəra mbəzli ghwəy vay, ti ghwəy sənay, a fəti va ghwəy, pə ghwəy mbə kwəma gəzəkə ghwəy na. ");
INSERT INTO bcw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma na nee na kataŋ nay, lə bərci Hyala tihee hyeler səvəri mbə mbəzli. Ma ɗi kwəma nata ghwəy na ciŋwəyəy: Wa na Hyala ghati sləkəŋwəy, ɗi naa gəzə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Zhini ma kə Yesəw ɓa na: «Mbaꞌa kə ndə bərci pəhətəvay wəzə lə shi mbəzə ci, ka ndəghwə ghi tsa ciy, ndə tiɓa dzaa ndəŋwashi shi ciw. ");
INSERT INTO bcw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma mbaꞌa kə tsahwəti ntsaa taŋəti tə bərci səəkəy dzəkən, mbaꞌa təɗanakənəy, ta pahwə shi mbəz ci va niy vəshi na ti shi dza ntsa va. Shi dza na vaa pahwə və na, mbaꞌa tatahamtishi. ");
INSERT INTO bcw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","A na neyey, ma ntsaa ni ghwəm na lə gha na yaw, kəy, ndə mbəz tsee na tsava ndə. Ntsaa kəətira ma mbə sləni yay, slənee vaa liɗi na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zhini ma kə Yesəw ɓa na: «Mbaꞌa kə gazlaka niy nza mbə ghən ndə, dza mbaꞌa səvəritay, a ka naa dza dza, ka təwrə dzar mbə gamba, ta pəla pətsa dza naa mbay dəkətəvata ti. Ma sa ka na dza kala kwəmavə pi ghənzəy, ka na dza mbə zəzə kwəma nzəy: “Ma ghənzə tsəgha na, wəzəɓa zharee zhəmbə ciki tsee vaa səvəri ɗee mbə” dza naa ni. ");
INSERT INTO bcw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma sa ka na zhəghəkəvataa zhəmbə na, mbaꞌa kəsay ciki tsa va gwəma gwəma wəzə, papa ɗewɗew. ");
INSERT INTO bcw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma sa ka gazlaka va nay pətsa mbəɓa tsəgha ki na, mbaꞌa dzaa hakakə nihwəti gezlekikiy gwəramti məni ndərəm kən mbərfəŋ, ta nzəy mbə ciki tsa va. Ma sa ka ghəshi səəkəə ki na, shirɓitə dzashiy dzəmbə ntsa va gwanashi. Dzəghwa tərəŋw gazlaka dzaa mətsəhəta va ntsa va, taŋ na kwataŋa va ki» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ma sa kəramti Yesəw gəzə kwəma va na, mbaꞌa nahwəti mali maɗita mbə jipə mbəzli tiɓa, ka gəzə kwəma zlaŋzlaŋ. Ma kə na: «Vəshi na ta mali səkwa gha kwa hwər nzə, mbaꞌa gha sahwə ꞌwa tə hati nzə!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma kə Yesəw kaa zləɓanta na: «Aw kiw, mbəzliy fa kwəma Hyala va, dza ghəshi ka ɗi fəti tiy, ghəshi na shi mbə vəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma sa ɓasətəvashi mbəzli vəgha Yesəw, a kə na: «Ma ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsay, mbəzli jikirkir ni nza ghwəy. “Mənti shi maɗaŋa maɗaŋa ni” pə ghwəy kaa ngəra. Na nee nee kiy, nihwəti shi maɗaŋa maɗaŋa ni dzee məntəŋwəy tiɓaw. Mək na shi maɗaŋa maɗaŋa ni va niy mənəhwə Hyala lə *Zhəwnasə. ");
INSERT INTO bcw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A Hyala mənti shi maɗaŋa maɗaŋa ni lə Zhəwnasə, ta mbə ka *Ninivə sənay, Hyala ghwənikə na, kə ghəshi. Ta mənti shi maɗaŋa maɗaŋa ni dza Hyala lə ya kwərakwə, ta mbə ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsaa sənay, Hyala ghwənikəra na, yən Zəghwə yakə ndə ngəri, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nay ghwəy na, fəca dza Hyalaa məni ngwəvəə dzəkən mbəzliy, ta dza dza mazə maliy niy səəkəta va tə hiɗi ka Sabaa dzəti ngwəvə ghəshi lə mbəzli mbə vəghwə tsa ndatsə tsa. Ta kəsəyshi dza na tə ngwəvə, sa nzana mbaꞌa niy səəkəta tə hiɗiy gwəramti kərakə, war ta favə kwəma gəzə mazə *Saləmaŋw, sa nzana tərəŋw ghəci sənata kwəma. Dzəghwa ghwəy na ghwəy ki na, kala ɗi zləɓa kwəmee ghwəy. Yən sa dikə tsa kən Saləmaŋw ngar ki. ");
INSERT INTO bcw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Fəca vici dza Hyalaa məni ngwəvəə dzəkən mbəzliy, ta səəkə dza mbəzli mbə məlmə ka Ninivə dzəti ngwəvə ghəshi lə mbəzli mbə vəghwə tsa ndatsə tsa, ta kəsəyshi dza ghəshi tə ngwəvə. Ghəshi na nashi sa niy favə ghəshi gəzə kwəma Hyalaa dzəkən jikir tsa shi va Zhəwnasəy, a ghəshi niy tsati titihwə kaa Hyala, ka zhəghanti nzəy tsa shi. Dzəghwa ghwəy na ghwəy kiy, kala ɗi fa kwəmee ghwəy, yən tsa dikə tsa kən Zhəwnasə ngar ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Zhini ma kə Yesəw ɓa na: «Ndə tiɓaa tsəraghwa ghwə kwa gərkəwa, sa tsəraghwa na na, mbaꞌa mbələy, aw bay na, mbaꞌa dzəɓakən tasaw kənəw. Mə pətsa ɗal tsa ka məndiy fəy, ta mbə ghənzəə mbərə, ma nza mbəzliy dzəmbə ciki nay pi waŋ. ");
INSERT INTO bcw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Məcihi ghay, nja gərkəwa tə vəgha gha na ghəshi. Mbaꞌa kə mətsəhi ghaa nay pi ɗiweŋ ɗiweŋəy, mbə waŋ pi dza vəgha ghaa nza gwanata ghalaɓa ki. Mbaꞌa kə mətsəhi gha kala nay pi ɗiweŋ ɗiweŋəy, mbə kwəsli na vəgha gha. ");
INSERT INTO bcw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ghənzə tsəgha kiy, məni tə gha məhərli, vantaa waŋ pi tsa mbə nəfə tsa gha dzaa nzaa kwəsli. ");
INSERT INTO bcw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Waŋ kə pətsa mbə vəgha gha gwanay, kala tərmbə nahwəti bəla nzə mbə kwəsliy, ghalaɓa na, mbə waŋ pi dza naa nza gwanata, njasa ka gərkəwa vaa mbərəŋa waŋ tsa nzə kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ma sa kəɗamti Yesəw gəzə kwəma ki na, dzəghwa tsahwəti ndə Farisa mbaꞌa harvə ta zəmə shiy kəghi tsa ci. Dzəghwa Yesəw mbaꞌa tsəhəy kəghi tsa ci va. Mbaꞌa ghəshi ghati zəmə shiy kala yaɓə dəvə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma sa nay ndə Farisa tsa va Yesəw ghati zəmə shiy, kala yaɓəhwə dəvə ghəci ta zəməshi na, mbaꞌa məhərli ci səəta va nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma kə Ndə sləkəpə kaa ngəci ki na: «Ghwəy ghwəy ka Farisahiy, paf paf təhəshi nefer ghwəy va ndərəm lə va ghəli. Gwəyəy, mbəzliy gwəmanti yaɓə devəre sa shiy tsa shi va lə kwakwa tsa shi ɗewɗew pərikə tə hwəm shi, mbalaa ngərjəkəjəkə na ghəshi va rəɗa kwa hwər kwa hwər shi nza ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ghwəyəy, mbəzli kama məhərli mbə ghən shi nza ghwəy. Ma Hyalaa mənti pətsa pərikə va tə ngwəla na, kala ghənzə mənti tsa mbəɓa mbəɓa pi nə ghwəy kwərakwə shəkəna? ");
INSERT INTO bcw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wəzəɓa ɓanavə ghwəy shi kwa devəre sa yam tsa ghwəy lə shi kwa kwa zənɗafa tsa ghwəy kaa ka ndərma. Mbaꞌa pə ghwəy mənti tsəghay ɗewɗew dza nefer ghwəy nza kwa kwəma Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","A gəzaŋwəy ya, ghwəy ghwəy ka Farisahiy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Ghwəy kiy, kar ghwəy ɓə shiy kwətiŋ mbə shiy məŋ ta ɓəshi kaa Hyala. Ka ɓə shiy kwətiŋ mbə shiy məŋ, ya səvəri mbə kəslifi er jəw jəw ni wəzə ni ka ghwəy ta ghənghən ghənghən ni. Ma na nza bama ti *kwəma pəhəti Hyala na, kala ɗi nəw ghwəy. Shi ɗi kwəma pəhəti Hyalay: Ka ɗi Hyala lə nəfə kwətiŋ, ka məni kwəma lə kwal tsa nzə, ava ghənzə na kwəma nza bama ti va Hyala. Tsəgha na shi ka ghwəy məni nza ki, kala za ma ghən ta ɓə shiy kwətiŋ səvəri mbə shiy məŋ kaa Hyala diɓa. ");
INSERT INTO bcw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ghwəy ghwəy ka Farisahiy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Sa nzanay, war tsa kwa kwəma pi nzəy ka ghwəy pəla ta nzəy mbə *ciki ɓasəva tsa ka Zhəwifə nza mbəzli mbəə naŋwəy. Jəw ɗi ghwəy məndiy səkwəŋwəy mətsəfəkwə dzar tə ləwmaw. ");
INSERT INTO bcw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ghwəy ghwəy ka Farisahiy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. Sa nzanay, yəmyəm nza ghwəy lə kwəli mbə hiɗi, kala mbə məndiy nata, war dza məndiy dza dzar kən kala sənata məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ma kə tsahwəti ndə mbə ka ɓənipə kwəma pəhəti Hyala na: «A Metər, mbə kwəma gəzə gha va tsəgha nay, lə ghəyŋəyta tsəərə gha mbə kwəma va» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma kə Yesəw kaa ngəci na: «Mbə səəkə na ngəraꞌwəə dzəkən ghwəy kwərakwə, ghwəy ghwəy ka ɓənipə kwəma pəhəti Hyala! Sa nzanay, kwəma shəndəkə na taŋəti bərci mbəzli ka ghwəy ɗi ghəshiy məni. Ma ghwəy na, ka ka dəvə ghwəy kaa mbəzli ya jəw mbə nəw kwəma ghwəy vaw. ");
INSERT INTO bcw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ghwəy ghwəy shiy gwəmanti nga kwəlihi ni wəzəə dzəkən ka gəzə kwəma Hyala bakwamti jijihiŋwəyəy, mbə səəkə na ngəraꞌwəə dzəkən ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sa gwəmanti ghwəy va kwəlihi vay, a ghwəy zləɓavə kwəma mənti jijihiŋwəy va ɗi na gəzə. Sa nzanay, bəkwə bakwamti jijihiŋwəy ka gəzə kwəma Hyala, sa dza ghwəy na ghwəy ki na, mbaꞌa ghwəy gwəmanti kwəlihi ka gəzə kwəma Hyala va. ");
INSERT INTO bcw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Va tsəgha niy nə Hyala ghənzə kwa sənata kwəma: “Ta ghwənanakəvəshi ka gəzə kwəmee dzee lə ka kwalee, ka ghəshi dzay, mbaꞌa ghəshi bakwamti nihwəti mbə shi, nihwəti na, mbaꞌa ghəshi sanamiyshi ngəraꞌwə” kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ka gəzə kwəma Hyala bakwamti məndi ghala ghava hiɗi kiy, tə ghwəy ghwəy mbəzli mbə vəghwə tsa ndatsə tsa dza Hyalaa kəsli kərhi tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tə *Abel gha məndiy pəəsli ndə, ka sar lə bəkwəshi paꞌ tə Zakari tsa pəəsliti məndi va kwa jipə pətsa ka məndi fə shiy ti ta ta Hyala lə ciki tsa nzə. Njasa gəzaŋwəy ya va na, ta sla ngwəvə dza Hyalaa dzəkən ghwəy, ghwəy mbəzli ndatsə ni, tə mbərkə mbəzli bakwamti məndi va gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ghwəy ghwəy ka ɓənipə kwəma pəhəti Hyalay, mbə səəkə na ngəraꞌwəə dzəkən ghwəy, sa nzana mbaꞌa ghwəy ɓəhwə sənata kwəma Hyalaa dzəmbə dəvə ghwəy, mbaꞌa ghwəy kalay kwal va mbəzliy ɗi sənata kwəma va, ya ghwəy dəꞌwə ghən tsa ghwəy na sənata ghwəyəw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma sa gəzamti Yesəw kwəma va ki na, dza na mbaꞌa ɓarvay tiɓa. Dza ka ɓənipə kwəma pəhəti Hyala, ghəshi lə ka Farisahi ka ghwərvəə dzəkən tərəŋw, ka ɗəɗəw nihwəti shiy və ghənghən ghənghən, ");
INSERT INTO bcw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ka pəla ngali ci, nda nza naa mbəlikəvəri *kwəma jikir na tə miy ci, ta mbə ghəshiy kwəmavə kwəma dza ghəshiy kəsə ti. ");
INSERT INTO bcw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma ghala pətsa va ki na, mbaꞌa mbəzli gar diwəy diwəy diwəy, ɓasəshi, ka dza tə ndə tə ndə va ɗaŋshi. Dza Yesəw mbaꞌa ghati gəzə kwəma pərɓa kaa mbəzli ta səɗa ci, ma kə na: «Ndəghwə tə ghwəy ghən tsa ghwəy va is tsa ka Farisahi va. Ɗi naa gəzəy, ndəghwə tə ghwəy ghən tsa ghwəy va ngəɗipə tsa ɓəni ghəshi va kaa mbəzli. Sa ka ghəshiy dzay, mbaꞌa ghəshi ɓəti ghən tsa shi ka mbəzli slar slar ni, a tsəgha na ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ya wa kwəma mbəmbə na gwaꞌay ta dzəti ngwəla dza na. Ya wa kwəma dza məndiy ghələhwə gəzə nzəy, ta sənata dza məndi. ");
INSERT INTO bcw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Va tsəgha, ya wa kwəma dza ghwəy gəzəhwə taa nza mbə kwəsliy, ta favə dza məndi havəghwə tə ngwəla. Ya wa kwəma dza ghwəy ɗahwəhwə kaa ndə mbə ciki kəəli kəəliy, ta zlapata kwəma va dza məndi mə ɗal pi pərikə tə ngwəla, ka favə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Zhini ma kə Yesəw ɓa na: «Ma nə ya kaa ngəŋwəyəy madigahiray, ka hazləni ghwəy va mbəzliy dzaa mbay pəəsliti vəgha ghwəy ma. Na niva mbəzliy, nihwəti shiy tiɓa ghəshi dzaa mbay mənti dzəghwakən shi vaw. ");
INSERT INTO bcw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kadiwəm, e citəŋwəy ntsa təɓə na ghwəy hazləni və. Va Hyala pə ghwəy hazləni. Ghənzə na ntsaa dzaa mbay pəəsliti ndə, zhini mbaꞌa bərci və ta zhiniy ndəghambə ntsa va mbə ghwə diɓa. Ə gəzaŋwəy ya, gəla tsava ndə na sa təɓə ghwəy hazləni və. ");
INSERT INTO bcw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A ghwəmmə sənay, cifə ka məndiy tanavə ꞌyegwer tiytiyhi kaa ndə tə dala bakə. Ya tsəgha nzə kiy, ka zamti ghən Hyala ta tsahwəti mbə shi ya kwətiŋəw! ");
INSERT INTO bcw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ghwəy kiy, ya shəti mbə ghən ghwəy gwanashi na mbəra mbəra na ghəshi, kwətiŋ kwətiŋ tsa shi gwaꞌa va Hyala. Njana nzana tsəgha kiy, ka hazləni ghwəy tepə ma. A ghwəy nay, ya njaa na ꞌyegwer ɗaŋ tsa shiy, ka zamti ghən Hyala ti shi ya kwətiŋəw, hanaɓa ghwəy ghwəy ke ngəri ki ka na zəzə maa dzəkən ghwəy na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Zhini ma kə Yesəw ɓa na: «Ə gəzaŋwəyee, ya wa ntsaa dzaa ni: “Ndə nəw Yesəw nzee nee” kə kwa kwəma mbəzliy, ta gəzə dzee yən Zəghwə yakə ndə ngəri, kwa kwəma ka kwal Hyala kwərakwə: “Tsee ndə na tsatsa” pən. ");
INSERT INTO bcw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma ntsaa dza vaa ni: “Sənay ndee Yesəw na yaw” kə kwa kwəma mbəzliy, tsəgha dzee gəzə yən Zəghwə yakə ndə ngəri kwərakwə kwa kwəma ka kwal Hyala: “Sənay tsava ndə yaw” pən. ");
INSERT INTO bcw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ya wa ntsaa dzaa gəzəkə kwəma hwəvə hwəvə naa dzəkənee yən Zəghwə yakə ndə ngəriy, ta pəlay dza Hyala mbə nəfə nzə. Ma na ntsaa gəzakən kwəma sawaa dzəkən *Safə tsa Hyala ɗewɗew tsay, ka dza Hyalaa pəlay tsava ndə mbə nəfə tsa nzə teepəw. ");
INSERT INTO bcw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mbaꞌa kə məndi dzaa kəəsəghəŋwəy dzəti ngwəvə mbə *ciki ɓasəva tsa ka Zhəwifə, ya dzəghwa kwəma mezhizhə, ya va nihwəti mbəzli dikə dikə ni ta slaŋwəy ngwəvəy, sa ka ghwəy tsəhəŋwəy na, əntaa ghwəy taa zəzə njasa dza ghwəy mənti ta mbəliŋwəy, ya kwəma dza ghwəy gəzə ma. ");
INSERT INTO bcw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sa nzanay, gwaꞌa dza Safə tsa Hyala ɗewɗew tsaa citəŋwəy kwəma dza ghwəy gəzə ghala vici va» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ꞌWakəvə tsahwəti ndə mbə mbəzliy ɓasəshi va, mbaꞌa maɗiy, ma kə kaa Yesəw na: «A Metər, gəzanci kaa zədirə a ghəci zləɓa ghəy təhə shi zəmə ghi tsa dəŋəy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma kə Yesəw ngəci na: «A madiga, wa ntsaa fəyra ta sləka kwəma kən ghwəy, ya ta təhəŋwəy shi ghwəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dzəghwa ma kə kaa mbəzli gwanashi na: «Mənim məhərli, ndəghwə tə ghwəy ghən tsa ghwəy va nəghətaa ghwəy məniŋwəy ka mbəzli ka ɗi gəna. Sa nzana, ya njaa na gəna ɗaŋ tsa nzə va ndəy, ka ɓanavə piy gəna va kaa ndəw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa gəzəkə na kwəma va ki na, dza na mbaꞌa ɓəlanakəshi fir. Ma kə na: «A tsahwəti ndə niy nza tiɓay, ndə gəna ghəci tərəŋw. Mbaꞌa veher və. Ma sa zati na za ti shi na, tərəŋw shiy mənishi tə veher va. ");
INSERT INTO bcw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma sa nashi na shiy mənishi və tsəgha ki na, dza na mbaꞌa dzay dzəmbə təkə kwəma mbə ghən ci kwətiy, ma kə na: “Njaa dzee məni tay? Sanay, daw na pi vəya ta shikə shi zakee ni gwanashi” kə, war ka zəzə kwəma, war ka zəzə kwəma. Ma kə ki na: ");
INSERT INTO bcw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Yawa kadiw na gha ki. E sənay njasa dzee mənti nana ki. A dzee bakwamti gəzhemer ya ni gwanashi, kee dza na mbaꞌee zhiniy nga ngati ni dikə dikə ni. Kee dza ki na ɓasə ɓasə ɓasaghwa shi zakee kwa shi, lə nihwəti shi vəya gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sa kee mənti tsəgha ki, ma pən taa ni kaa ghən tsee na, a ghən tsee! A shiy mənishi va gha dalala nana ki, ɗaŋ gəna, lə shi zəmə paf paf paf, məkəŋa ta piya gar ɗaŋ. Nana kiy, a pə ghaa dəkəva, ka zəmə shiy, ka sa shi sa, ka vəshi” kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma kə Hyala kaa ngəci na: “Gha niy ya, sa kama məhərli tsa ya jəw tsətsə mbə ghən ci! Avanay, ndatsə ndatsə, tə vərɗi ndatsə nay, ta mətiŋa dza gha. Sa ka gha mətiŋa kiy, ya shi gha ni gwanashi ɓasəti gha kaa ghən tsa gha na, wa ntsaa dza zəməshia?” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma sa kəɗamti Yesəw ɓəli fir tsa va, zhəghwa ma kə na: «Ava tsəgha dza naa nza lə ntsaa kəslimbə ghən va war mbə tsəni shiy kaa ghən tsa ci, ma dza kwa kwəma Hyala na, ndə ndərma ghəci» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma ləy hwəm kwəma va ki, ma kə Yesəw kaa *mbəzli ta səɗa ci na: «Ava va tsəgha nə ya ngəŋwəy kiy, ka kəslimbə ghən ghwəy mbə zəzə kwəmaa dzəkən shi zəməə dzəghwa hwər ghwəy, ya dzəkən shiy dzəkən ghən ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sa nzanay, a piy tsa ndə taŋəti shi zəmə ndə. A vəgha ndə taŋəti shi pa naa dzəkən ghən ci diɓa, pən. ");
INSERT INTO bcw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nashim ghaməkəhi, njasa ka ghəshiy zəmə shiy di. Ka za ghəshiw, ka məni shiy ghəshi səəkə kwamtiw, tamə və shiw, gəzəm və shiw. Ya tsəgha nzə kiy, Hyala zəmanshi na shiy. Ghwəy kiy, diməɓa tə ghwəy na kwa kwəma Hyala kən ꞌyegwer. ");
INSERT INTO bcw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mbaꞌa pə ghwəy kəslimbə ghən mbə zəzə kwəma tsəgha kiy, ka dza ghwəy mbay mətsahakən viciy dzəkən na slavəŋwəy Hyala ya jəw nzə na? Ka mbay ghwəy tepəw. ");
INSERT INTO bcw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Njana nzana kala mbay ghwəy mənti na jəw na kwəma kiy, wa shiy mənishi zəzə ghwəy kwəma tərəŋw dzəkən niy tərmbə shiya? ");
INSERT INTO bcw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nashim fəhiy mbərə ghwə tə gamba njasa ka ghəshiy təɓə kyasə tsa shi. Ghəshiy, kar ghəshiy mənəhwə sləniw, ka cislivə kwəbeŋer ghəshiw. Ya tsəgha nzə e gəzaŋwəyəy, ya ndə nja mazə *Saləmaŋw, ghəci saa niy nza vaa ndə shiy na, səəkə naa pakən kwəbaŋ ka təɓə nja fəhiy mbərə ghwə va tə gambaw. ");
INSERT INTO bcw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A ghwəy sənay, mbərə ghwə kiy, ka nzay nza naw, ka ndə nata ndatsə na kwəma gagaw, həzliməy ghənzə shəkəta, mbaꞌa ghwə dzaa ndamti. Ya tsəgha nzə kiy, kar Hyalaa ghasləti, ka təɓə wəzə. Hanaɓa ghwəy ghwəy mbəzli dza naa pakənŋwəy ma kwəbeŋerəy gwəramti wəzə ki na. Ma ghwəyəy ɓanavə nefer ghwəy ghwəy kaa Hyala gwanashiw. ");
INSERT INTO bcw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ka tasə ghən tsa ghwəy ghwəy lə papala shi dza ghwəy zəmə, lə shi dza ghwəy sa, ka zəzə, war ka zəzəə dzəkən shi ma. ");
INSERT INTO bcw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ma na gəla niva shiyəy, mbəzliy nəw ma Hyala məni shi tikə tə hiɗi na shiy tasəva lə pala niva shiy. Na na ghwəyəy, a Didi va ghwəy. Gwaꞌa sənashi na niy kama va ghwəy shiy. ");
INSERT INTO bcw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wəzəɓa ɓanavə ghwəy nefer ghwəy kaa Hyala na, nza ghənzə sləkəŋwəy. Ma nza Hyala ndaŋwəy niva shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma kə Yesəw diɓa na: «A mbəzlee ni, ya kala ɗaŋ nza ghwəyəy, ka hazləni ghwəy ma. Sa nzanay, a Dəŋwəy tsa mə ghwəmə vəshiy ta ɓəŋwəy dzəti pətsa dza naa sləkə mə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A gəzaŋwəy ya, mbalam pamtim səkəm tə shi va ghwəy, nza ghwəy tahanavə gəna dza ghwəy kwəmavə ti shi kaa ka ndərma. Pavəm mbəl tsaa hali ma. Ɗi naa gəzəy, ghəra sləni ta shi mə ghwəmə. Sa nzana məɓay, ka dza shi va kərəshiw, ka mbə ndə ghəliy kətəghəvay dzəvəgha shiw, ka mbə ləmaa ndəbəhwəshiw. ");
INSERT INTO bcw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa nzana tə pətsa nza shi gha nza bama ti shiy, war tiɓa ka məhərli ghaa nza kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zhəghwa ma kə Yesəw ɓa na: «Pəhətəvaŋwəyəm ta ghəra sləni ya hwəmɓa, mbaꞌa ghwəy tsəꞌwaghwa ghwə kwa gərkəwahi ghwəy, kala hi ma ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Məniŋwəyəm nja ka ghəra sləniy ndəghə ntsa ghəranci ghəshi sləni, dzaa zhəkə mbə ɓə mali. Ya vici hwəm səəkə nay, war favə ma ghəshi har tsa ci na, ka ghwənanci dəgha. ");
INSERT INTO bcw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sa dza ntsa ghəranci ghəshi va sləniy zhəghəkəvay kəsashiy, vəshi na va ka sləni va, sa nzana mbə ndəghə səəkə tsa ci ghəshi niy nza, kala hi ma. A gəzaŋwəy ya, ta na navay, tsəgha na, ta pakən kwəbeŋer sləni ci dza ntsa va, mbaꞌa pəhantəvay ta ghəra sləni. Ka na dza na, ka harshi a ghəshi nzəyshi. Sa ghəshi nzəyshi na, ka təhanshi shi zəmə ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mbaꞌa kə ntsa va zhəghəkəvay ya mbə daŋkala vərɗi, ya tə kwa taŋa ngələkə, səəkə na ghəshi mbə ndəghə kala ɓəhwə ma hiy, vəshi na ta niva ka sləni. ");
INSERT INTO bcw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Favə tə ghwəy kwəma ɗee na gəzaŋwəy wəzə. A ghwəy sənay mbaꞌa kə ndə ghi sənay vəghwə tsa dza ndə ghəliy səəkəə dzakə ghi tsa ciy, ta fə ghən dza na ti. Ka dza naa zlay kwal kaa ndə ghəli ta dzakəw. ");
INSERT INTO bcw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Va tsəgha, ma ghwəy kwərakwə kiy, gwəmatəvaŋwəyəm ya hwəmɓa. Sa nzanay, geꞌi lə vəghwə tsa təkəti ma ghwəy dzee səəkə yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ma sa gəzəkə Yesəw tsəgha, ma kə Piyer ngəci na: «A Ndə sləkəpə, kwataka kaa ngəŋəy ɓəli gha fir tsa ta naa, naa kaa mbəzli gwanashi?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma kə Yesəw zləɓanci na: «Favə tə ghwəy, e gəzaŋwəy kwəmaa dzəkən ntsa fəy məndi ta nighəə dzəkən sləni nihwəti mbəzli. Ntsaa fə ghən ta sləni ci, ka ghəra lə məhərliy, kaa ngəci dza ndə ghi tsa ghəranci na va sləniy zlatanavə ndəghwə pətsa kəghi tsa ci, nza ghəci ɓanshi shi zəmə kaa nihwəti ka sləni kəyɓa sa ka vici zəmə shiy mənta. ");
INSERT INTO bcw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ghala vəghwə tsa dza ndə ghi tsa vaa səəkə, mbaꞌa kə kəsay ndə sləni tsa ci va, ghəci mbə tsəva lə sləni gəzanci na va wəzə wəzəy, vəshi na ta tsava ndə ghəra sləni. ");
INSERT INTO bcw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ta fanambə shi və gwanashi dza ntsa va mbə dəvə ndə sləni tsa ci va. ");
INSERT INTO bcw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma mbaꞌa kə ndə sləni tsa va ghavə təkə mbə nəfə tsa ci: “Ka dza ntsee tsa dikə tsaa zhikə ɓəlaŋəw” kə, dza na tapə, dzəmbəy mbə didiꞌwə nihwəti ka ghəra sləni tiɓa, shiy zhər lə miꞌi gwaꞌa, war ka zəmə shi zəmə ci, ka sa shi sa, ka ghiy, ");
INSERT INTO bcw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","war ghəci mbə məni shi ci va tsəgha ki na, ka ntsa ghəranci na va sləni dza vətəghə səəkəy, fəca viciy niy bərkəti ma ndə sləni tsa va səəkə tsa ci, geꞌi lə leriy niy bərkəti ma na diɓa. Sa naa səəkə na, saꞌ saꞌ sanamiy ngəraꞌwə kaa ndə sləni tsa va tərəŋw, mbaꞌa dzaa jakayshi tə na shi kwəma lə mbəzliy kəsəvə ma sləni ci va bekir divi. ");
INSERT INTO bcw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ma ndə sləni tsaa sənashi shi ɗi ntsa ghəranci na sləni, dza na kala gwəmava ghəci ta sləni va, kala məni ma shi ɗi ntsa ghəranci na va sləni ghəciy, tərəŋw dza məndiy dəꞌwəti. ");
INSERT INTO bcw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma na ndə sləni tsaa sənashi ma shi ɗi ntsa ghəranci na sləni, dza na mbaꞌa təvəti kwəma gar dəꞌwə məndi tiy, jəwə dza məndiy dəꞌwəvə. Ava tsəgha dza naa nza, ma ntsa ɓanavə Hyala shiy ɗaŋəy, shiy ɗaŋ dza naa ɗəw və. Ma ntsa zlanay na sləni dikə nay, tərəŋwɓa və dza naa ɗəw sləni» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zhəghwa ma kə Yesəw ɓa na: «Ma səəkə tsee tsay, ghwə na sa ɓəkee dzəti hiɗi. Ma tə ɗi tsee kə nzay, tsətsə na ghənzə pəhəpəhə. ");
INSERT INTO bcw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ta sa ngəraꞌwə dzee ya njaaꞌa. Mbə hazləni na nəfə tsee tərəŋw, paꞌ fəca dza naa səəkəy dzəkənee. ");
INSERT INTO bcw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Zərkəə ɓəkee kaa mbəzli nə ghwəy bay na? Awə, a gəzaŋwəy ya, waa tihə mbəzli na sa ɓəkee dzəti hiɗi. ");
INSERT INTO bcw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ghala ndatsə, mbaꞌa kə mbəzli kəghi tsa kwətiŋ tsa cifəy, ta tihəvərivashi dza ghəshi. Mahkan nihwəti kwa na shi bəla, ka ɓə nəfəə dzəkən ni bakə ni va, bakə nihwəti kwa na shi bəla, ka ɓə nəfəə dzəkən ni mahkan ni va. ");
INSERT INTO bcw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ka ɓə nəfə didiy dzəkən zəghwə ci, zəghwə kwərakwə na, ka ɓə nəfəə dzəkən dəy. Məməy, ka ɓə nəfəə dzəkən zha nzə, zha kwərakwə na, ka ɓə nəfəə dzəkən mbəghəta. Ma mashiy mali na, ka ɓə nəfəə dzəkən makwa nzə, makwa na, ka ɓə nəfəə dzəkən shəta» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dzəghwa, ma kə Yesəw kaa vərəm tsa tiɓa va kwərakwə na: «Sa ka ghwəy nashi kwəleɓi kwa ghwəməy, ta səəkə dza van, pə ghwəy ni, war ghwəla ka gha nighə na, van səəkəy kataŋ. ");
INSERT INTO bcw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dzəghwa ɓa, mbaꞌa pə ghwəy nay safə zhəghəkəvay səəkə ləykə ka viy dzatikəy, a fəghwə səəkəta, pə ghwəy ni, ka gha nighə na məndi mbə fəghwə kataŋ. ");
INSERT INTO bcw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ghwəy kiy, ka ngəɗi mbəzli lə kwəma pərikə tə ngwəla nza ghwəy. Mbaꞌa ghwəy sənay nighə pətsa mə ghwəmə lə pətsa tə hiɗi ta gəzə shiy dzaa məniva kiy, sa wana mbay ma ghwəy sənashi shi ɗi shiy məniva ni sanaa gəzəa?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ma kə Yesəw ɓa na: «Wa slən tsa shiy mənishi, mbay ma ghwəy təra na təɓə məndiy məni kwəma dəꞌwə ghən tsa ghwəya? ");
INSERT INTO bcw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mbaꞌa kə ntsa nza ghwəy mbə həərəva liy harŋaa dzəti ngwəvəy, dzəghə tə gha sləka kwəma va ghwəy li kwa kwalŋwəy, vantaa ghəci dzaa pəmanavəŋa kaa ka sla ngwəvə, vantaa ka sla ngwəvə dzaa pəmanavəŋa kaa ka sawji, vantaa ka sawji dzaa kalaghwaŋa kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ghalaɓa kiy, ka dza məndiy pəlaŋa tepə, kala war sa ka gha wamti kwəma gwaꞌa gwaꞌa njasa dza məndiy slavəŋaw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ghala vəghwə tsa va ki na, dzəghwa nihwəti mbəzliy nza tə pətsa va mbaꞌa ghəshi gəzanci kwəma kaa Yesəw, ma kə ghəshi na: «A ghəy favə, a Pilatə niy bakwamti ka Galile ghəshi mbə həəni shiy kaa Hyala, dzavəɗə miymiy mbəzli va dzavəɗishi lə miymiy shi həəni ghəshi va kaa Hyala, kə məndi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma kə Yesəw zləɓanshi na: «Tərəŋwɓa ka Galile bakwamti məndi va mənti na rəɗa kən nihwəti ka Galile, va tsəgha bakwamtishim, nə ghwəy sa bərkə ghwəy na? ");
INSERT INTO bcw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tiɓaw, ghwəy kwərakwə ki, e gəzaŋwəyəy, kala zhəghanti nzəy tsa ghwəy pə ghwəy sana na, ta bəkwə dza ghwəy gwanaŋwəy nja ghəshi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A ghwəy niy favə, a ciki Shiləwe niy ngəzlay dzəkən mbəzli məŋ lə dəghəsə, mbaꞌa ghəshi bəkwəshi, kə məndi niy ni. Tərəŋwɓa ghəshi mənti na *kwəma jikir na kən nihwəti mbəzli mbə məlmə Zherəwzalem gwanashi, va tsəgha bəkwəshi ghəshi, nə ghwəy sa bərkəti ghwəy na? ");
INSERT INTO bcw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tiɓaw, ghwəy kwərakwə ki, e gəzaŋwəyəy, kala zhəghanti nzəy tsa ghwəy pə ghwəy sana na, ta bəkwə dza ghwəy gwanaŋwəy nja ghəshi kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma ləy hwəm ki na, dza Yesəw mbaꞌa ɓəlanakəshi fir tsa, a kə na: «A tsahwəti ndə niy nza tiɓa, lə tsa və. Dza na ngwəɓə ngwəɓəti bəzakə kwa tsa ci va. Ma sa kəlita fə va na, dza na tə nahwəti vici mbaꞌa maɗiy ta ngəli nzə, tsəhə na na, kala kəsata ya ti. ");
INSERT INTO bcw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma kə kaa ntsaa ghəra sləni kwa tsa ci va na: “Nata fə na ghay, ndatsə mənta na gar yaw. Kwa mahkana piyee na sana mbə səəkə ta ngəli ya nzə, shaŋ ghənzə ta yati ya. Ghənzə tsəghay ɓə tsəꞌi gha kəslamti. A nava ka na nzəyta war ka kəli, ka makamti ngwəla tə za gəmtaa?” kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma kə ndə ghəra sləni tsa va ngəci na: “A ntsee dikə tsa, kadiw, zlata tə piya na na gha diɓa, e lamti pətsa dzar ta mətsəni nzə, ma nzee tənti məlɓə. ");
INSERT INTO bcw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ghalaɓay aa ta yati ya mbə piya zhəkə va bərkee. Kala dza kəə yay, nza gha kəslamti ghalaɓa ki”» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma tə nahwəti vici dəkəva na, dza Yesəw mbaꞌa dzəmbəy mbə *ciki ɓasəva tsa ka Zhəwifə. Dza na ka ɓananshi kwəma Hyala kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mbaꞌa nahwəti mali niy nza tiɓa gwərapəta va *hil. Piya nzə məŋ lə dəghəsə niy mənti na lə hil tsa va mbə vəgha nzə. Cəkeꞌ hil tsa va zhighəvəri, war mə dəməhwə ghənzəə dza, kala mbay ma garə. ");
INSERT INTO bcw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma sa nata Yesəw mali va na, dza na mbaꞌa harata, ma kə ngəta na: «A mali, a gha mbəliŋa va zəlghwə tsa zhəghəŋa gha tsa və» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dza na bəm fati dividivi ci tə mali va, war ghwəla tsəgha na nzaꞌjəw tiɗiɗ, mali va garəta. Tapə ghənzə mbə fal Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma sa nata ntsaa sləwa ciki ɓasəva tsa va nava kwəma tsəgha na, mbaꞌa nəfə tsa ci satiy tərəŋw, sa mbəliti Yesəw va mali va fəca vici dəkəva. Ma kə kaa mbəzliy ɓasəshi va tə pətsa va ki na: «Vici kwaŋ na sa ka məndiy ghəra sləni ti mbə ləwma kwətiŋ. Mbaꞌa pə ghwəy ɗi mbəliŋwəy va zəlghwə tsa ghwəyəy, mbə vici kwaŋ na va ka ghwəy səəkə. Ma na vici dəkəvay, mbəli mbəzli tiɓa fəca nava viciw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma sa gəzəkə na tsəgha, ma kə Ndə sləkəpə ngəci na: «Ghwəyəy, mbəzliy dakə mbəzli lə kwəma pərikə tə ngwəla nza ghwəy. Ya tsamaɓa ndə mbə ghwəy na, kar pəli məcar tsa ci, ya kwantəmca ci, ta dza ta santa yam fəca vici dəkəva sa? ");
INSERT INTO bcw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mali na kiy, jijiy *Abəraham na, kwa məŋ lə dəghəsə na piya nzə ghala zhəghəvəri *ndə jaka tsa Hyala, shaŋ ghənzə ta mbay garə. Ya sa nzana mbə pəli dəbəkə tsa ghwəy ghwəy fəca vici dəkəva ta sanci yam kiy, hanaɓa mali na ka məndi zlata mbəli nzə fəca vici dəkəva nə ghwəy na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ma sa gəzəkə Yesəw kwəma va tsəgha na, mbaꞌa haꞌwə kəəsəvə mbəzliy niy kanci ghəpə va. Ma mbəzli gwanashi ni nashi ki na, tərəŋw ghəshi vəshishi ta slənihi wəzə wəzə ni va ghərati Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zhəghwa ma kə Yesəw ɓa na: «A shiy tiɓa, nja sləkə tsa sləkə Hyala mbəzli li shi ghəshi, ");
INSERT INTO bcw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","lə cizlə gwəbiri dzee yəməti. A ghwəy sənay, mbaꞌa kə ndə mənivə cizlə gwəbiri, mbaꞌa tsəŋwəyshi mbə za ciy, ta pəsəshi dza ghəshi, ka ghəshi dza na mbaꞌa ghəshi kəlishi ka fə dikə na. Ka ꞌyegwer səəkə ki na, ka la ghyeghyer shi mə. Ava tsəgha na lə mazə tsa Hyala kwərakwə ki, jəwə ka naa ꞌway, ka kəli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zhini ma kə Yesəw kaa tsahwəti fir ɓa na: «A shiy tiɓa dzee yəməti sləkə tsa sləkə Hyala mbəzli lə shi diɓa. ");
INSERT INTO bcw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yəmyəm na lə is tsa ka mali vaa tivə jəwə, mbaꞌa tambə mbə ghwəpə gar kiləw bakə mətsəkə cifəti, ka gha nighə na pifpirif ghənzə pəkəməvata gwanata. Ava tsəgha na lə mazə tsa Hyala kwərakwə ki, jəwə ka naa ꞌway, ka kəli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ma ləy hwəm ki na, mbaꞌa Yesəw taŋəhwə məlməhi ghənghən ghənghən, ta tsəhə mbə məlmə Zherəwzalem. Ghəci mbə dza dza ci vay, kala gəzə kwəma Hyala niy nza na kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma tə nahwəti vici na, dza tsahwəti ndə ka ɗəw kwəma və, a kə na: «A Metər, kwataka mbəzli jəwə na shiy dzaa mbəlishi ta naa, njaa?» kə. Ma kə Yesəw ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Ə pə ghwəy jihəva ta dzakə kwa miy dəgha teꞌwə na. Sa nzanay ɗaŋ na mbəzliy dzaa dzəghə dzakə kwa miy dəgha va, kala dza ghəshiy mbay dzakə, e gəzaŋwəy nee ki. ");
INSERT INTO bcw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kala dza pə ghwəy jihəva ta dzakə kwa miy dəgha vay, sa ka ndə ghi dza na, disl dza naa kalay dəgha ci, mbaꞌa kwəɓəlay kəyɓa kəyɓa. Ma ghwəy na ghwəy ki na, pərikəŋwəy ghwəy taa nza tə ngwəla. Ka ghwəy ghavə na, ka dəmdəmə gəzli miy dəgha. Ma pə ghwəy taa ni na: “A Metər, ghwənamtəŋəy dəgha” pə ghwəy taa ni. Ma kə taa ni ngəŋwəy naci ki na: “Ka ghwəni yaw, sənay ya nda dza kwama tsahwə ghwəyəw” kə taa ni. ");
INSERT INTO bcw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma pə ghwəy dzaa ni ngəci ki na: “A ghəy niy zəməhwə shiy jakə lə gha, ka sa shiy lə gha. A gha niy ɓənəhwə shiy kaa mbəzli dzar kwa kweler mbə məlmə ghəy” pə ghwəy taa ni. ");
INSERT INTO bcw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Zhəghwa ma kə ndə ghi tsa va dzaa ni ngəŋwəy diɓa na: “Waa sənay ya nda dza kwama tsahwə ghwəyəw, satim ɓarvaŋwəyəm vəghee gwanaŋwəy, ghwəy mbəzli ka məni kwəma jikir na ni” kə dzaa ni. ");
INSERT INTO bcw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sa ka ghwəy nashi kar Abəraham lə *Izakə, mbaꞌa *Zhakwapə, mbaꞌa ka gəzə kwəma Hyala gwanashi, ghəshi mbə Mazə tsa Hyala, ma ghwəy na, mbəzli bazlakəvəri məndiy dzəti ngwəla, e gəzaŋwəyəy, war ə dza ghwəy wahə, ka pərə sliꞌi ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta səəkə dza mbəzliy dza ya paꞌ səəkə kwa ghwəmə lə njasaa dzəghwa mərkwi, lə səəkə kwa həci, lə zhəkə dzati kwa məw, ta nzəy ka zəmə shiy tə pətsa sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ghalaɓa kiy, nihwəti mbəzli mbə mbəzliy ꞌwa kwəma nanay, ka mbəzli ləy hwəm dza ghəshiy zhəghəshi. Ma nihwəti mbə mbəzli ləy hwəm sana na, ka mbəzli kwa kwəma ghəshi taa zhəghəshi ghalaɓa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma ghala vəghwə tsa va ki na, dza nihwəti *ka Farisahi mbaꞌa ghəshi səəkəshiy dzəvəgha Yesəw. Ma kə ghəshi ngəci na: «Ɓarvaŋa tikə, a gha dzaŋaa dzəti tsahwəti pi, sa nzanay, mbə pəla pəəsliŋa na mazə *Erədə» kə ghəshi ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma kə Yesəw ngəshi na: «Mbalam, gəzancim kaa saa tsəhwəliy va tərəŋw tsa. Ma pə ghwəy ngəciy: “Avanara mbə tihə hyeler səvəri mbə mbəzli, ka mbəli ka zəlghwə, ndatsə lə həzlimə. Ma tə kwa mahkana viciy, gwaꞌa dza slənee nza, kə ntsa va” pə ghwəy kaa ngəci» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","«Ya njaa nay, war ta nəw kwal tsee dzee, ndatsə, lə həzlimə, lə vəghwə tsa həzlimə gwaꞌa. Sa nzanay, ka təɓə na məndiy pəəsli *ndə gəzə kwəma Hyala tə tsahwəti pi kala war mbə məlmə Zherəwzaleməw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Dzəghwa ma kə Yesəw na: «A mbəzli mbə məlmə Zherəwzalem, ghwəy bakwamti na ka gəzə kwəma Hyala, mbaꞌa ghwəy paꞌwamti mbəzli Hyala ghwənashi na lə hərezli, ka bakwamtishi. Ɗaŋ na səɗee mbə pəla ɓasətəŋwəy, ta ndəghwəŋwəy, njasa ka kwəkwəla vaa ɓasambə kwərtiti nzə mbə bəkəbəkə nzə. Dzəghwa kala zləɓa ma ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ə gəzaŋwəy ya nana kiy, ta ɓanti dəvə nzə dza Hyala tə məlmə ghwəy. Ə gəzaŋwəy ya, ka zhini ghwəy nara ghwəla tepəw, paꞌ fəca dza ghwəy gəzəə dzəkənee: “Təfanati miy tsa nzə Hyala kaa ntsaa səəkə mbə slən tsa nzə ghənzə kwa sləkəpə” pə ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Ma fəca nahwəti *vici dəkəva ka Zhəwifə na, mbaꞌa Yesəw dzakəy dzakə ghi tsa tsahwəti ntsa dikə tsa mbə *ka Farisahi ta zəmə shiy. Dzəghwa tsahwəti ndə gwərapəy ghəci va zəlghwə pəpə, mbaꞌa səəkəə garəy vəgha. Ma mbəzli kəyɓa na, war ə ghəshiy fə ghən ta Yesəw, ta nighə shi dza naa məni fəcava. ");
INSERT INTO bcw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma sa nay Yesəw tsəgha na, dza na ka ɗəw kwəma va *ka ɓənipə kwəma pəhəti Hyala, lə va ka Farisahi, ma kə ngəshi na: «Ndapə kwal kwəma pəhəti ghwəmmə ta mbəli mbəzli fəca vici dəkəva ta naa, na kala ndapə na?» kə ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dza mbəzli va shalal ghəshi nzəyshi, kala ɗi ma zləɓanci kwəma. Dza Yesəw ki mbaꞌa fakən dividivi ci kən ghən zal tsa va, mbaꞌa mbəlanti. Sa mbəlanti na na, mbalaa jighi, kə kaa ngəci, ka dzay ntsa va. ");
INSERT INTO bcw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Zhəghwa ma kə Yesəw kaa mbəzli va ki na: «Mbaꞌa kə ndə mbə ghwəy sana lə zəghwə və, ya məcar na sa və, dzəghwa na mbaꞌa ɓaghwa tərə kwa wawərə fəca vici dəkəvay, nza ghwəy dza ta ɓəə səəmə tiɓata sa?» kə kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma sa favə mbəzli va tsəgha na, shaŋ ghəshi ta mbay zləɓanakə kwəmaa dzəkən kwəma va, shalal, ghəshi nzəyshi. ");
INSERT INTO bcw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mbəzli harashim vaa dzakə ghi tsa va ta zəmə shiy na, war pətsa wəzə tsa ghəshiy təra ta nzəy ti, mbalaa na Yesəw fəti ghən ti shi. Dza na tapə dzəmbəy mbə ɓəlanshi fir ki, ma kə ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Mbaꞌa kə ndə harvəŋa ta zəmə shiy mbə ɓə maliy, əntaa gha dzaa nza, tsəhəŋa ma gha na, ka nzəy tə pətsaa gwəra wəzə tsa ma. Sənay gha nda tsahwəti ndə tiɓa mbə mbəzli harashi ntsa va tərəŋwɓa ti bama kaa ngəŋaw. ");
INSERT INTO bcw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ka gha nighə na ntsaa haraŋwəy va ta zəmə shiy səəkə kəsaŋa, a kə taa ni ngəŋa na: “Satiŋa zlanay tsava pi kaa ntsa” kə taa ni. Ghalaɓa ki na, lə haꞌwə lə haꞌwə dza ghaa dza ta zhiniy nzəy zhəkə ləy hwəm mbəzli ki. ");
INSERT INTO bcw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A ka gha məni ndə kə harvəŋa ta zəmə shiyəy, tsəhəŋa ma ghay, mbaꞌa gha dzaa nzəyŋa tə pətsaa kəray. Ma sa ka ntsa haraŋwəy va səəkə ki, ma kə dzaa ni ngəŋa na: “A madiga, satiŋa tikəə dzəghwa pi nzəy tsa wəzə tsa tsa” kə dzaa ni. Ma tsəgha ghalaɓa kiy, bama tərəŋw dza naa nza tə gha kwa kwəma mbəzli dza ghwəy zəmə shiy li shi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sa nzanay, ya wa ntsaa kəliti ghən tsa ciy, ta zhəghəti dza Hyala ka ntsa jəw tsa. Ma ntsaa zhəghəti ghən tsa ci ka ntsa jəw tsay, ta mənti dza Hyala ka ntsa dikə tsa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dzəghwa, ma kə kaa *ndə Farisa tsaa harvə va ki na: «Mbaꞌa pə gha tati shiy ta har mbəzliy, əntaa gha haka madigahiŋa, lə ngwarməhiŋa, mbaꞌa manhiŋa, mbaꞌa ka ghalahiŋa nza shiy və shi ma. Sa nzana, mbaꞌa pə gha harvəshiy, ta harŋa dza ghəshiy dza ta zəmə shiy fəcahwəti kwərakwə. Ghalaɓay shi gha va dza ghəshiy zhanavəŋa. ");
INSERT INTO bcw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mbaꞌa pə gha tati shiy ta har mbəzli ta zəmə shi mbə makwaghwa ghay, ka cicikwə, lə mbəzli məti məti vəgha ni, lə vədevəder, mbaꞌa ghwəlefesli, pə gha dzaa har. ");
INSERT INTO bcw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ghalaɓa kiy, ta vəshi dza ghaa dza, sa nzana kala dza ghəshiy mbəə zhanavəŋa shi gha va. Ma nza Hyala dəꞌwə ghən tsa nzə zhanavəŋashi geꞌi lə vici dza mbəzliy məni kwəma ɗi Hyalaa zhikəmə kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma sa favə mbəzli tiɓa va mbə zəmə shiy kwəma gəzəkə Yesəw va tsəgha, ma kə tsahwəti ndə mbə shi kaa Yesəw na: «Vəshi na ta ntsaa dzaa zəmə shi zəmə tə pətsa sləkə Hyala sa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma kə Yesəw kaa zləɓanci kwəma va lə fir na: «Favə tə gha, a tsahwəti ndə niy nza tiɓay, dza na mbaꞌa tati shi zəmə ɗaŋ tərəŋw, ta haka mbəzli ɗaŋaŋ tərəŋw ta zəməshi. ");
INSERT INTO bcw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma sa mənta vici zəmə shi zəmə va na, daꞌ haray ntsaa ghəranci sləni, mbaꞌa ghwənay kaa mbəzli har na va. Ma kə ngəci na: “Mbala, ma pə gha kaa mbəzli haree va ta zəmə shiyəy: Səəkəm, gwaꞌa gwaꞌa nakamtəvashi shi zəmə, pə gha ngəshi” kə. Tsəgha na, kə ndə sləni tsa va, mbaꞌa dzaa gəzanshi tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ya wa ndə mbə shi gwanashi na, war kwal vəya na yaw, kwal vəya na yaw, kə ghəshi gwanashi. Ma kə kwa taŋa ndə na: “Wa e pavə za, ꞌwarꞌwar tiɓa, ta dza ta nighəti za va ɗee, ka dzee tsəhəra mbə zəmə shi zəmə vaw, titihwə ə cəꞌwəŋee, yaŋ pə gha na gha!” kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma kə tsahwəti ɓa na: “E pavə slay ka zee, ngwər cifə, ta dza ta dzəghəshi ɗee, ka dzee tsəhəra mbə zəmə shi zəmə vaw, titihwə ə cəꞌwəŋee, yaŋ pə gha na gha!” kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma kə tsahwəti ɓa na: “Yənəy, ꞌwar ɓə mali nzee, va tsəghay, ka dzee tsəhəraw” kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sa favə ndə sləni tsa va kwemer shi va gwanashi na, ənkwa kə. Dza na mbaꞌa zhəghəkəvay dzəvəgha ntsa ci va dikə tsa. Səəkə na cəkeꞌ zhananavə kwemer gəgəzəkə mbəzli va va kaa ngəci. Ma sa favə ndə ghi tsa va kwəma gəzəkə mbəzli va va na, mbaꞌa nəfə tsa ci satiy tərəŋwəy. Ma kə kaa məgəla tsa ci va na: “Mbala dzar tə ləwmahi, lə dzar kwa kweler dzar mbə məlmə, a gha harashiɗa ka ndərma, lə mbəzli məti məti vəgha ni, lə ghwəlefesli, mbaꞌa vədevəder” kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tsəgha na, kə ndə sləni tsa va, mbaꞌa dzaa mənti tsəgha. Dzəghwa na mbaꞌa zhikəy. Ma kə kaa ntsa ci dikə tsa na: “A ntsee dikə tsa, e harashi mbəzli va njasa gəzəkəra gha va nee, ɗaŋ səəkəshi mbəzli. Ya tsəgha nzəy, a tsahwəti pi nzəy tərmbə” kə. ");
INSERT INTO bcw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma kə ndə ghi tsa va kaa ndə sləni tsa ci va na: “Mbalaa dzəghwa kweleriy dzəmti, lə dzar kwa kweler slehə slehə ni, a gha dzaa cəꞌwə mbəzli kəsashi gha gwaꞌa, ta səəkə ghəshi, ta mbə ghi tsee təhəy va mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A na mbəzliy niy ghee vaa har, kala səəkə ghəshi nashi, e gəzaŋay, ndə mbə shi ya kwətiŋ mbaꞌa dzaa tsəhəməy shi zəmee vaw” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma tə nahwəti vici na, mbaꞌa Yesəw kafəy ta dza, lə mbəzli ɗaŋ kwasəbə. Ma ghəshi mbə kwal tsəgha na, ꞌwakəvə na, tərəɗ zhəghətəvay ləy hwəm, ma kə kaa ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Mbaꞌa kə ndəə səəkə ta nəwray, tərəŋwɓa yən kə ndə dzaa ɗi kən kar dəy, lə mbəghəy, lə mali ci, lə ndərazhi ci, mbaꞌa ngwarməhiy. Tərəŋwɓa yən kə taa ɗi ya kaa ghən tsa ci dəꞌwə ghən tsa ci. Kala tsəghay, ka mbay tsava ndəə məniy ka ntsa ta səɗa yaw. ");
INSERT INTO bcw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kala kafəy kə ndə ta nəwra, mbaꞌa zləɓavə lə mətitay, ka mbay tsava ndəə məniy ka ntsa ta səɗa yaw. ");
INSERT INTO bcw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A ghwəy sənay, mbaꞌa kə ndə mbə ghwəy ɗi nga ciki tsa ci sanay, a dza naa nzəyəy di, ka na dza na, mbaꞌa təkamti gəna dza naa zamti ta nga ci. Ka na dza mbaꞌa nighəti nda wəkə na gəna və ta kəɗamti sləni va. ");
INSERT INTO bcw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vantaa dzaa nza, mbaꞌa dzaa ghati fə səɗa ciki na, dza walwal kwəma gəna mananati kala dzaa mbay kərnamti. Ma sa ka mbəzli nashi niva shiy ki na, ka ghəshiy dza tapə mbə ꞌwəshi ci. Ma kə ghəshi dzaa ni na: ");
INSERT INTO bcw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Nayəm tsava ndə dia mbəzli ni, mbaꞌa niy ghati fə səɗa ciki ndəndəta na, dzəghwa kala mbay ghəciy kərnamti!” kə ghəshi dzaa ni. ");
INSERT INTO bcw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A ghwəy sənay tsəgha na lə mazə diɓa. Mbaꞌa kə tsahwəti mazə ɗi dza ta mbəz lə tsahwəti mazə nja ghəci sanay, das dza naa nzəyəy di, ka na dza mbaꞌa təkəti wəzə, nda nza naa nza gar kafəy lə ka sawji bələkwə bələkwə məŋ, ta dza ta mbəz lə mazə tsaa səəkə va lə ni ci ka sawji bələkwə bələkwə bakə mətsəkə. ");
INSERT INTO bcw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma sa ka na nighəti, kala gar mbay ghəciy dza ta mbəz lə mazə tsa vay, ta ghwənəghə mbəzli dza naa dza kaa mazə tsa ɗi na va mbəz li ghəci kərakəy, ta cəꞌwə zərkə və, ta dəpanti mbəz tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nay ghwəy kiy, tsəgha dza naa nza lə ghwəy kwərakwə. Ya tsamaɓa ndə mbə ghwəy, kala zlashi shi və gwanashi kəy, ka dza naa mbay məniy ka ntsa ta səɗeyew» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ma kə Yesəw diɓa na: «Məzlir nashiy, wəzə jəw na ghəshiw, ma mbaꞌa kə ndezhekə kərəy mbə shiy, njaa dza məndiy zhiniy zhanambə ndezhekə tsa va ghwəla kia? ");
INSERT INTO bcw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naa tərmbə kiy, war a ka məndiy shəkəy pəsər tsa va dzəy tə ngwəla. Sa nzanay, ka gwəmati er ghwəlaw, wəzə na ta dzəmbə zaw. Zhini diɓa na, məniy naa məlɓəw, tsəgha. Ma ntsa nza sləmə və ta fa kwəmay, fə tə ghəci ghən ta kwəma va!» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dzəghwa ka *dəwan ghəshi lə nihwəti mbəzliy məni *kwəma jikir na, mbaꞌa ghəshi kətəghəvashiy dzəvəgha Yesəw ta fa kwəma gəzə na va. ");
INSERT INTO bcw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma sa nashi *ka Farisahi lə *ka ɓənipə kwəma pəhəti Hyala na, tapə ghəshi ta ngwəzlimə kwa jipə shi, ma kə ghəshi na: «Ntsay, mbə kaꞌwə mbəzli jikir ni na, ka zəmə shi zəmə li shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dza Yesəw mbaꞌa ɓəlanakəshi fir tsa ki, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Favə tə ghwəy kwəma dzee na ta gəzə. Sənzənvay, ya ndə mbə ghwəy lə teŋkesli və bələkwə, dza tsahwəti mbə shi kwətiŋ mbaꞌa zay na, nzaꞌjəw ghəci dzaa zlashi ni məsliɗə mətsəkə məsliɗəti ni va tiɓa kaa ntsa makə ghəshi shiy li, kaf kafəy ta pəla tsaa zay va kwətiŋ tsa, ka pəla, ka pəla, paꞌ sa ka na kəsay sa ci sa. ");
INSERT INTO bcw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sa ka na kəsay sa ci kiy, tərəŋw dza naa vəshiy. Ka na dza tsaŋ ɓəvə sa ci, bəm fati tə wəri, ");
INSERT INTO bcw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ka dzay jighi. Sa ka na tsəhəy kəghiy, ka na dza daꞌ daꞌ harashi madigahiy lə ka ghalahiy. Ma kə dzaa ni kaa ngəshi na: “A mbəzlee, vəshim kwasəbee, sa nzanay, e kwəmavə təmbəkə tsee va niy zay” kə dzaa ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma sa kəramti Yesəw ɓəli fir tsa va, ma kə na: «War tsəgha dza məndiy vəshi mə ghwəmə ta ntsa jikir tsa kwətiŋ, ghəci tsati titihwə kwa kwəma Hyala. Tərəŋwɓa ti dza məndiy vəshishi kən ni məsliɗə mətsəkə məsliɗəti ni va tərmbə bərkəti ghən tsa shi ka mbəzli slar ni, kala təkə ma tsanta titihwə ghəshi kaa Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Zhini Yesəw ɓa, mbaꞌa ɓəlanakəshi tsahwəti fir, ma kə na: «A nahwəti mali niy nza lə mbəl məŋ, dzəghwa tsahwəti kwətiŋ mbaꞌa zay. Nzaꞌjəw ghənzə tsəraghwa ghwə kwa gərkəwa, ta pəla pətsa mbə ciki tsa nzə wəzə, ka pəla, ka pəla, mbaꞌa kəsay sa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma sa kəsay nay, dza na daꞌ daꞌ harashi madigahita, lə ka ghalahita. Ma kə kaa ngəshi na: “A mbəzlee, vəshim kwasəbee, sa nzanay, e kwəmavə mbəl tsee va niy zay” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma sa kəɗamti Yesəw ɓəli fir tsa va, ma kə diɓa na: «Ə gəzaŋwəy ya, ta vəshi dza ka kwal Hyala ta ntsa jikir tsa kwətiŋ, ghəci kə tsati titihwə kaa Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zhəghwa ma kə Yesəw kaa tsahwəti fir ɓa na: «A tsahwəti ndə niy nza tiɓay, bakə ndərazhi və. ");
INSERT INTO bcw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dzəghwa ma kə tsa jəw tsa kaa dəy tsa va na: “A di, ndara ni ya shi zəmə ghiy niy dzee zəmə mbə ghi tsa gha” kə. “Tsəgha na” kə didi tsa va, dza na mbaꞌa təhanavərishi shi və kaa ndərazhi ci va bakə ni. ");
INSERT INTO bcw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma ləy hwəm hi jəw ki na, dza zəghwə jəw na va, mbaꞌa papamti səkəm tə ni ci shi zəmə ghi gwanashi. Dza na pəkw dzay lə gəna ci vaa dzəti nihwəti hiɗi kərakə. Ma sa tsəhəy na tə pətsa va na, dza na ka liɗi gəna va, war ka liɗi, war ka liɗi. Kə pəŋw laɗamti gəna va mbə məni badaway. ");
INSERT INTO bcw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma sa kəɗita gəna ci va gwaꞌa ki na, dzəghwa ma mbaꞌa mənta tərəŋw tə hiɗi nza na va. Mbaꞌa ndərma ghati dzəkən ki. ");
INSERT INTO bcw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dzəghwa na, mbaꞌa dzay dzakə tsahwəti ndə mbə məlmə va, ta ɗəw sləni və. Mbaꞌa ntsa va ghwənay ta makə ngəreder ci kwamti. ");
INSERT INTO bcw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma ghəci mbə makəshi ki na, ka ghəranci maa nza tərəŋw. Ka ɗi kwəmavə ghəciy nza ya fəhi ka məndiy shakanshi kaa ngəreder va dzəghwa miy tsa ci na, a ka ɗi ɓanci shi məndiw. ");
INSERT INTO bcw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dza na tə nahwəti vici, mbaꞌa dzəmbəy mbə təkə kwəmaa dzəkən nzəy tsa ci, ma kə na: “Sənzənvay, ka ghəra sləni kəghi tsa dirəy, ɗaŋshi na shi zəmə və shi, ka mbay ghəshiy zəmantishiw. Ma yən nee ki na, war ka məti va ma tikə. Əm, awə. ");
INSERT INTO bcw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wəzəɓa zhəghəvee zhəvəgha dirə na. Ma pən dzaa ni ngəci sa kee tsəhəra vəghay, a Di, e mananati *kwəma jikir na kaa Hyala, lə kaa ngəŋa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanay, mənɗee gar zhini ghaa harɗa ka zəghwə gha ghwəlaw. War mərshi ma ghaa məntəra, nja tsahwəti ndə ghəraŋa sləni gwaꞌa tsəgha, pən, dzaa ni” kə. ");
INSERT INTO bcw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma sa təkamti na tsəgha na, dza na mbaꞌa maɗiy ta dzay dzəvəgha dəy. Ka dza, ka dza, ka dza ghəci. Ma ghwəla ghəci mbə kwal kərakə vəgha ghi na, mbaꞌa dəy tsa va nighəvə tsəgha. Dza hwər tsa ci ka zhanci ti. Kə ka kəsli bali ta dza ta kwəmə li. Sa kwəməti ghəshi na, dza na hwətəm hwətəməvə zəghwə ci va. ");
INSERT INTO bcw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma kə zəghwə va ngəci ki na: “A di, e mananati kwəma jikir na kaa Hyala, lə kaa ngəŋa gwaꞌa. Mənɗee gar zhini ghaa harɗa ka zəghwə gha ghwəlaw” kə. ");
INSERT INTO bcw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma kə didi tsa va kaa ka sləni ci na: “Mbalam kyaŋwkyaŋw a ghwəy ɓəkə ləkwəsaa gwəramti wəzə, nza ghwəy panakən, mbaꞌa ghwəy pəlakə shi kwa dəvəə səranaghwashi kwa dəvə ci, pəlaꞌ kaa kwekweher, paꞌ mbə səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mbalam kəsəkəm kəɓə ghwəmmə va kəliti ghwəmmə, a ghwəy slanti, a ghwəmmə ta, ta zəmə ngəslə ngəslə ghwəmmə, ka vəshi tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa nzana, ma zəghwee na nay ghwəyəy, nja ntsaa mətiy mbaꞌa zhiniy zhakatiy mbə məti na. Raꞌi niy zay na, dzəghwa mbaꞌee zhiniy kwəmavə see” kə. Sa gəzəkə na tsəgha na, mbaꞌa ka sləni ci manamti kwəma va gwaꞌa. Dza tsə mbaꞌa ghatəvata tərəŋw lə vəshi tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Məniva shi va gwanashiy, kwamti niy nza tsa dikə tsa va zəghwə. Ma ghəci mbə səəkə, war sa kətikəvay na ndəkwə lə ghi tsa shi na, mbaꞌa favə tsa shiy, lə cəm, ka tsə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma sa tsəhəy na kəghi na, dza na daꞌ harvə tsahwəti ndə mbə ka sləni dəy va, ka ɗəw kwəma və: “A shiy mənishi shəka?” kə. ");
INSERT INTO bcw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma kə ntsa va ngəci na: “Waa zəməŋa zhəkəy na, ma slanti dəŋa kəɓə kəliti ghwəmmə va, sa nzana mbaꞌa zhiniy kwəmavə sa ci kwəriŋ, va tsəgha tsə məndi, ka vəshi tərəŋw” kə. ");
INSERT INTO bcw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma sa favə tsa dikə tsa va zəghwə kwəma va tsəgha na, mbaꞌa nəfə tsa ci satiy, kala zləɓa dzakə ghi ghəci. Dzəghwa dəy mbaꞌa səvəriy, kə ka cəꞌwə zəghwə ci va, a ghəci dzakə ghi. ");
INSERT INTO bcw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma kə kaa dəy na: “A di, nighətiy piya ɗaŋ na ghala nza ghwəm, war mbə məniŋa slənee, səəkee taŋəti kwəma gəzara gha ya namaɓaw. Ya tsəgha nzə kiy, səəkə ghaa kəsavəra ya ꞌwəgə ta zəməhwə shi zəmee lə vəshi ghəy lə madigahiraw. ");
INSERT INTO bcw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma war sa səəkəy zəghwə gha na daŋəramtəŋa gəna gha mbə ghwərghwər na, mbaꞌa gha kəsəvə kəɓə kəliti ghwəmmə na, pəf gha hənənəy” kə. ");
INSERT INTO bcw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma kə dəy ngəci ki na: “A zəghwee, gha na na ghay, ghwəm na lə gha ya hwəmɓa. Ya wa shi vəya gwaꞌay, shi gha na ghəshi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nanzə kiy, aa təɓə ghwəm tsə, ka vəshi tərəŋw ta zəməŋa tsa. Sa nzanay, nja ntsaa mətiy va, zhini mbaꞌa zhakatiy mbə məti na. Sa nzanay, aa niy zay, dza mbaꞌee zhiniy kwəmavə, sana” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Dzəghwa ma kə Yesəw kaa *mbəzli ta səɗa ci na: «A tsahwəti ndə gəna niy nza tiɓa, lə ntsa ka naa fə shi ci və ta ndəghwəshi tiɓa. Ma tə nahwəti vici na, ndəs məndi səəkəshiy gəzanci, ma kə məndi ngəci na: “A ntsa fə gha va shi gha vəə liliɗi shi gha va” kə məndi kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma sa favə na tsəgha na, dza na daꞌ harvə ntsa va. Ma kə kaa ngəci na: “E favə məndiy gəgəzə kwəma dzar kwa kaɓaka gha. Ca cikəvəriɗa njasa mənəhwə gha sləni gha. Na neyey, ka zhini ghaa ndəghwəra shi ya ghwəlaw” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma sa favə ndə fə shiy tsa va kwəma va tsəgha na, dza na ka zəzə kwəma dza naa məni, ma kə na: “Vanay ta ɓantəra ɗi ntsee tsa dikə tsa mbə fə shi ci ni. Sana kiy, njaa dzee ta məni kee ghaa kwəmavə shi zəmə kia? E dza ta za, pən na, bərci vəya gar zaw. E cəꞌwə shiy va mbəzli, pən ɓa na, kwəma haꞌwə haꞌwə na na tərəŋw diɓa” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Dza na mbaꞌa təkəvə nahwəti kwəma. Ma kə na: “E sənay njasa dzee mənti, madiga dzee məni tə mbəzli, ma sa ka ntsee dikə tsa ɓantəra mbə sləniy, nza mbəzli va kəsəvəra bekir dəvə taa nza kəghi tsa shi” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dzəghwa na, daꞌ daꞌ haharashi mbəzliy niy ɓə ɓəhwə temer va ntsa ghəranci na va sləni gwanashi. Sa səəkəshi ghəshi na, dza na ka harshi kwətiŋ kwətiŋ. Ma kə kaa kwa taŋa ndə na: “A pənəy, shiy hwəm na təm tsa ntsee dikə tsa va ghaa?” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma kə ntsa va ngəci na: “Təm in gwaŋgwaŋ tsa dikə tsa diwəy na sa ci vəya” kə. Ma kə ndə fə shiy tsa va tsəgha ki na: “Vanta zliyaa niy tsaslati məndi va təm tsa va ti. Ca taŋtaŋ nzəyŋa tsasliti, gwaŋgwaŋ cifə mətsəkə na sa ci vəya pə gha” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ya ghay təm shiy hwəm nəwŋa ntsee dikə tsaa?” kə. Ma kə tsa va na: “Təm bəhwə ha diwəy cifə na sa ci vəya” kə. Ma kə ndə fə shiy tsa va ngəci na: “Vanta zliyaa niy tsaslati məndi va təm tsa va ti. Ca tsasliti bəhwə ha diwəy faɗə na sa ci vəya pə gha” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma sa favə ndə shiy tsa va kwəma mənti ndə fə shiy tsa ci va gəmgəm tsay, mbaꞌa falti, sa nzana mbaꞌa mənti tsəhwəli mbə sləni ci va» kə Yesəw. «E gəzaŋwəyəy, a mbəzli tikə tə hiɗi taŋəti mbəzli mbə waŋ pi tsa Hyala tə tsəhwəli mbə sləni kwa jipə shi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma kə Yesəw diɓa na: «E gəzaŋwəy nee kiy, ma gənay, shi tikə tə hiɗi na, ə pə ghwəy tahanavə gəna va ghwəy kaa mbəzli, ka məni madiga ti shi. Ma sa ka gəna ghwəy kərətay, a Hyala dzaa zləɓavəŋwəy kwa kwəma nzə mə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ma ntsaa kəsəvə ghəra sləni jəw na bekir diviy, tsəgha dza naa mbay ghərati na dikə na sləni kwərakwə. Ma ntsa ghərati sləni jəw na lə gwəfəy, tsəgha dza naa ghəra na dikə na sləni kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kala mbay pə ghwəy ghərati sləni wəzə bekir divi lə gəna tikə tə hiɗi ni sənzənva kiy, njaa dza ghwəy mbay ghərati sləni lə naa gwəramti gəna dza Hyala ɓəŋwəy kia? ");
INSERT INTO bcw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kala mbə pə ghwəy ghərati sləni wəzə bekir divi lə ni ndə shiy ndaŋwəy na kiy, ka dza Hyalaa ndaŋwəy ni ɗi na ɓəŋwəy shiy ka shi ghwəy ki na? ");
INSERT INTO bcw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ndə ghəra sləni tiɓa, mbaꞌa dzaa mbay ghərati sləni kaa mbəzli bakə yəmyəməw. Baŋ dza naa ɗi kwəma tsahwəti, ka ndərə na tsahwəti. Ka na dza na, ka mananci sləni kaa tsahwəti lə kwal, ma kaa tsahwəti na kala məni ma lə kwal. Ava tsəgha na kwərakwə ki, ka mbay ghwəy ghərati sləni bakə bakə, ka ghəra kaa Hyala, zhini mbaꞌa ghwəy ɓanavə məhərli ghwəy kaa gənaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ma Yesəw mbə gəzə kwəma va ki na, cəkeꞌ ka Farisahi favə. Dza ghəshi ka ꞌwəshi Yesəw, sa nza ghəshiy ka ɗi gəna. ");
INSERT INTO bcw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma kə Yesəw ngəshi na: «Ghwəyəy, a ka ghwəy kəli ghən tsa ghwəy kwa kwəma mbəzli nzam mbəə ni, mbəzli slar slar ni nza ghwəy, kə məndi. Na Hyalay, aa sənashi nefer ghwəy njasa nza ghəshi. Sa nzana, shi ka ndə ngəriy nighəti nja shi diɓədiɓə niy, shi gəmgəm ni tərəŋw na ghəshi va Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kwataŋay a kwəma pəhəti *Məyizə, lə zliyahi ka gəzə kwəma Hyala mbəradzə niy nza tiɓa, ghənzə na sa niy nəw mbəzli, ka sar paꞌ tə vəghwə tsa səəkəy Zhaŋ tsaa mənipə *batem. Ma sa səəkəy Zhaŋ kiy, mbə gəzə Yəwən kwəma wəzə naa dzəkən njasa sləkə Hyala mbəzli nza məndi paꞌ ndatsə. Ya wa ndə ki na, mbə jihəva ghəci lə bərci ta tsəhə mbə mbəzli sləkə Hyala va. ");
INSERT INTO bcw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ya tsəgha nzə e gəzaŋwəyəy, tiɓa na *kwəma pəhəti Hyala ghwəlata, taŋtaŋɓa ghwəmə nata ghwəy na lə hiɗi nashi ghwəy ni dza naa kəɗishi kən tamti shiy gwəra jəw ni mbə kwəma pəhəti Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ə zhinee gəzaŋwəy diɓa, ya wa ntsaa təhamti mali ci, dza na mbaꞌa ɓəvə nahwəti maliy, a ntsa va mənti ghwərghwər. Ma ntsaa dzaa ɓəhwə mali təhamti zata va diɓay, a ntsa va mənti ghwərghwər kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ma kə Yesəw ɓa na: «A tsahwəti ndə niy nza tiɓay, ndə shiy tsa tərəŋw tsa ghəci niy nza. Ka dza ləkwəsahi, mbaꞌa nihwəti kwəbeŋer ka gəna tərəŋw tərəŋw ni kən ghən, ka zəmə shi zəməə gwəramti wəzə ni tə hiɗi. Ya hwəmɓa na, war tə wahə nzəy tsa ci. ");
INSERT INTO bcw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Dzəghwa mbaꞌa tsahwəti ndə ndərma niy nza tiɓa, Lazar, kə məndi kaa slən tsa ci. Vəgha ciy, war zheher ghənzə niy nza gwaꞌa gwaꞌa. Ka kireketiy dza na, ka səəkəə dərni zheher ci va, war tsəgha. Ka Lazar tsa vaa dza na, takwəl səəkəə həniy kwa dəgha ndə shiy tsa va, ta mbəə iməvə memir shi zəməə dzaa shikə ta miy ndə shiy tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ma tə nahwəti vici ki na, dzəghwa Lazar ɓəlahə mətiy. Ma sa mətiy na na, səəkə ka kwal Hyala, tsaŋ ghəshi ɓəhwə ka dzashi liy dzəmə ghwəmə dzəti pətsa nza *Abəraham. Ma tə nahwəti vici ɓa na, dza ndə shiy tsa va ɓəlahə mətiy kwərakwə, mbaꞌa məndi lamti. ");
INSERT INTO bcw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka sa ngəraꞌwə ghəci tərəŋw tə pətsa nza mbəzliy bəkwəshi. Sa nə na kafə kə kaa kwəma ci na, kar mətsə ci tə kar Abəraham lə Lazar, kərakə ghəci li shi. ");
INSERT INTO bcw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma sa nashi na na, dza na ka zlapə kwəma, a kə na: “A Didi Abəraham, mənti zhəhwər tə ya, ghwənay Lazar a ghəci tsaməvə yam tə zəghwə dəvə ci, nza ghəci səəkəə tekwatərashi tə ghane nda nza naa məntəra rəniki jəwə. Sa nzanay, tərəŋwəy see ngəraꞌwə mbə ghwə na” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ma kə Abəraham kaa ngəci na: “A zəghwee, təkəvə nzəy tsa gha ghalaa niy nza gha tə ghwəməŋa di. Ghay, ndə gəna tsa tərəŋw tsa niy nza gha, ma Lazar na naci ghalaɓa na, war ngəraꞌwə ghəci niy sa. Nana kiy, a Hyala ɓəkəə dzətikə ta dəkə nəfə tsa ci. Ma gha nana na gha ki na, mbə sa ngəraꞌwə gha. ");
INSERT INTO bcw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ya kala na va talay, a zleha təɗəm na kwa jipə ghəy lə ghwəy. Ya ə ɗi ndə kafə tikə mbə ghəy ta dzaa dzəvəgha ghwəy sanay, ka mbay ndəə taŋəyəw. Ya mbə ghwəy ɗi ndə səvəriy dzəmbə ghəy diɓa na, ka mbay naa taŋəyəw” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Zhəghwa ma kə ndə shiy tsa va na: “A Di, ghənzə tsəghay, titihwə ə cəꞌwəŋee a gha ghwənay Lazar dzakə ghi tsa dirə. ");
INSERT INTO bcw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sa nzanay, a ngwarməhira tiɓa cifə tə ghwəməshi. Sa ka na tsəhəyəy, nza ghəci dzaa gəzanshi ngəraꞌwə tsa see tsa tikə, vantaa ghəshi dzaa zhikəə dzəti pətsa nzee tsa mbə sa ngəraꞌwə kwərakwə” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma kə Abəraham ngəci na: “A na ngwarməhiŋay, a zliya kar *Məyizə lə ka gəzə kwəma Hyala məɓa ta itishi, ə kə ghəshiy jangəshi ka fa kwəma gəzə ghəshi” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma kə ndə shiy tsa va na: “Awə didi Abəraham, ka nza na wəkə tsəgha na ghaw. War mbaꞌa kə ntsaa niy mətiy zhəməy, mbaꞌa dzaa gəzanshiy, ta zhəghəti nzəy tsa shi dza ghəshi” kə. ");
INSERT INTO bcw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma kə Abəraham ngəci ki na: “Kala zləɓa kwəma gəzanshi kar Məyizə lə ka gəzə kwəma Hyala kə ghəshiy, ya səəkə kwa kwəli səəkəy ndə ta gəzanshi na ka dza ghəshi zləɓaw” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ma kə Yesəw kaa mbəzli ta səɗa ci na: «Ya hwəmɓa nanzəy, a shiy dzaa ngəɗiti mbəzli ta məni kwəma jikir na tiɓa. Nanzə kiy, a ngəraꞌwə dzaa nza tərəŋw kən ntsaa ngəɗi mbəzli ta məni kwəma jikir na. ");
INSERT INTO bcw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma ntsaa taa ngəɗi tsahwəti kwətiŋ ta mbəzliy təhəshi ma ni ndara nefer shi ta məni kwəma jikir nay, wəzəɓa pəhanaghwa məndi vəna kwa wəri ci, mbaꞌam ndəghaghwa kwa hwər kwəfa dza naa nza. Sa nzana, mbaꞌa kə ngəɗiti ndə ta zlay kwal tseyey, ngəraꞌwə dza naa nza kən. ");
INSERT INTO bcw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","A gəzaŋwəy ya, məni tə ghwəy məhərliy dzəkən nzəy tsa ghwəy. Mbaꞌa kə zəməŋa tsa mbə nəw Yesəw məntəŋa kwəma jikir nay, mbala harvə a ghaa gəzanci kwəma sahə lə məhərli. Mbaꞌa kə ni: “Titihwə pəlara mbə nəfə tsa gha” kəy, pəlay tə gha mbə nəfə tsa gha. ");
INSERT INTO bcw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya a məniŋa na kwəma jikir na gar mbərfəŋ səɗa mbə vici kwətiŋ, kama na war mbə səəkə ghəci gar mbərfəŋ səɗa, ka gəzaŋa: “Titihwə pəlara mbə nəfə tsa gha” kəy, war ə pə gha dzaa pəli mbə nəfə tsa gha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma kə *ka kwal ci kaa Yesəw na: «A Ndə sləkəpə, kəətitəŋəy, a ghəy mbəə ɓanavə nefer ghəy gwanashi kaa Hyala shi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma kə Ndə sləkəpə kaa ngəshi na: «War mbaꞌa pə ghwəy ɓanavə nefer ghwəy kaa Hyala ya jəw tsətsə nja cizlə gwəbiriy, ta mbay dza ghwəy gəzə kaa dəŋw kwəkwə tsa: “Təɗamtəvaŋa tiɓa, a gha dzaa ngwəɓəyvaŋa kwa kwəfa” pə ghwəy, ta yə fəti dza na ta kwəma ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zhini ma kə Yesəw kaa *mbəzli ta səɗa ci ɓa na: «Favə tə ghwəy, ya ndə mbə ghwəy sana, lə ndə ghəra sləni və kəghi tsa ci, ka zanci za ntsa va, ka ndəghwanci shiy kaa ntsa va. Sa ka ndə ghəra sləni tsa va səəkəy kwamti kiy, ka dza ntsa ghəranci na va sləniy ni ngəci na, sar tikə taŋtaŋ zəmə shi zəmə, kə na? ");
INSERT INTO bcw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awə, ka gəzanci na tsəgha tepəw. Ma dza naa ni ngəciy: “Səramti ni kən gha ni kwəbeŋer, mbala tatəra shi zəmə, sa ghaa tatishiy, nza gha ɓəkəra shi. Ma sa kee zəhwə ni ya shi zəmə ki na na, nza gha zəmə shiy, ka sa ni gha shi sa” dza naa ni. ");
INSERT INTO bcw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sa ka ntsa va manamti sləni gəzanakə na va gwanata na, nza ntsa ci va dikə tsa mananci ꞌwəsa na? Tiɓaw. ");
INSERT INTO bcw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ava war tsəgha na lə ghwəy ghwəy mbəzli ta səɗee kwərakwə ki. Mbaꞌa pə ghwəy ghəramti sləni gəzəkəŋwəy Hyala ta məni nzə gwanatay, “Ka ghəra sləni gəmshi ni nza ghəy gwaꞌa tsəgha, sləniy niy dza ghəy ghəra na sa ghərati ghəy va” pə ghwəy dzaa ni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mbaꞌa Yesəw maɗiy ta dzaa dzəmbə məlmə Zherəwzalem. Ma tə nahwəti vici na, dza na ka dzar kwa ghala hiɗi ka *Samari lə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma ghəci mbə dzəmbə nahwəti məlmə na, mbaꞌa ka dərna məŋ nay, ka səəkə ghəshi ta kwəmə li. Dzəghwa ghəshi mbaꞌa ghəshi garəshi vəri kərakə li, ");
INSERT INTO bcw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka zlapanci kwəma zlaŋzlaŋ. Ma kə ghəshi na: «A Yesəw, a metər, mənti zhəhwər tə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma sa nashi Yesəw, ma kə ngəshi na: «Mbalam, a ghwəy dzaa canati vəgha ghwəy kaa *ka ta Hyala» kə. Ma sa gəzanakəshi Yesəw tsəgha na, dza ka dərna va kəram ghəshi maɗishi ka dzashi. Ma ghəshi mbə kwalshi na, mbaꞌa dərna shi va kərəta. ");
INSERT INTO bcw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma sa nay tsahwəti mbə shi ghəci mbəliy na, kə ka fal Hyala zlaŋzlaŋ, dza na tərəɗ zhəghətəvay va Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Səəkə na gələɓ gələɓəy, lə kwəma ci mbə hiɗi kwa kwəma Yesəw, mbaꞌa mananati ꞌwəsa. Ntsa vay, ndə məlmə na, mbə hwəhwə tsa ka Samari ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma kə Yesəw ki na: «Gwanashi mbəzli məŋ ni va mbəlishi nanzə sa? Əy, kwəma dzashi ni məsliɗə ni va tərmbə shiki? ");
INSERT INTO bcw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tərəh tsaa zəzəti səəkə ta mananta ꞌwəsa kaa Hyala mbə ghwəy war gha, gha ndə məlmə na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","«Sati mbala, a gha mbəliŋa tə sa ɓanavə gha nəfə tsa gha kaa Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dza *ka Farisahi tapə ta ɗəw va Yesəw, ma kə ghəshi na: «Hwəm dza Hyalaa sləkə mbəzlia?» kə ghəshi. Ma kə Yesəw ngəshi na: «Ma sləkə tsa dza Hyala ta sləkə mbəzliy, ka dza məndiy nay njasa dza naa səəkəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ka dza naa nza gar gəzə məndi: “Avanayəm pətsa sləkə Hyala mbəzli ti tikə” aw na: “Avamcim tarɓa” kə məndiw. Awə, ə gəzaŋwəy ya, ya sana sənzənvay, mbə sləkə mbəzli na Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma kə kaa *mbəzli ta səɗa ci ki na: «A tsahwəti vəghwə dzaa səəkəy, ka dzee nza mbə ghwəyəw. Ghalaɓay, tərəŋw dza ghwəy mawti nara yən Zəghwə yakə ndə ngəri, ya ta vici kwətiŋ nzə, ka dza ghwəy mbəə nara diw. ");
INSERT INTO bcw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma dza məndiy ni kaa ngəŋwəyəy: “A mbəzli ni, anay *Kəristəw tikə, ya avaci tarɓa” dza məndiy ni, sa ka məndi gəzaŋwəy tsəghay, əntaa ghwəy dzaa kəsli bali, ka dza kwakə, ka dza kwakə ta nighəra ma. ");
INSERT INTO bcw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa kee səəkə yən Zəghwə yakə ndə ngəriy, mbəzli gwanashi dza naa nara. War njasa ka van vaa wampiɗi dzəy tə ghwəmə, ka səəkə kwa ghwəmə paꞌ dzəghwa kwa mərkwiy, tsəgha dzee səəkə. ");
INSERT INTO bcw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma kiy, war pərɓa ngəraꞌwə dzee sahwə tərəŋw di, ka shi va məniva. Ka mbəzli ndatsə ni dza na, mbaꞌa ghəshi ndərantəra. ");
INSERT INTO bcw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Njasa niy mənishi shiy va ghala vəghwə tsa *Nəwey, war tsəgha dza ghəshiy məniva geꞌi lə vəghwə tsa dzee səəkə ti yən Zəghwə yakə ndə ngəri kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ghala vəghwə tsa vay, shiy niy zəmə mbəzli, ka sa shi sa, ka ɓəɓəli miꞌi, ka ɓə ghyehi shi kaa zhər, war tsəgha, paꞌ fəca vici dzəmbəy *Nəwe dzəmbə kwambəwal. Ma sa dzəmbəy na na, dza van mbaꞌa ghati nzəmə, ka nzəmə, war ka nzəmə kala kərə ma. Ray pətsa tə hiɗi va yam. Dza yam va kərəp ghəshi zamti mbəzli gwanashi. War kar Nəwe lə mbəzli kəghi tsa ci gwaꞌa tsəgha shiy mbəlishi. ");
INSERT INTO bcw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","War njasa niy mənishi shiy va ghala vəghwə tsa *Ləwtə ɓay, tsəgha dza ghəshiy məniva ghala vəghwə tsa dzee səəkə. Ghala vəghwə tsa vay, war shiy niy zəmə mbəzli, ka sa shiy, ka ɗəɗəl shiy, ka papa nihwəti, ka za shiy, ka nganga ceker, war tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma tə nahwəti vici, fəca səvəri Ləwtə mbə məlmə *Sədəm ki na, dza ghwə lə barəwdəw, mbaꞌa ghəshi nzəməkəvashi səəkə mə ghwəmə. Kərəp ghəshi zamti niy niy tərmbə mbəzli mbə məlmə va gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","E gəzaŋwəyəy, ava war tsəgha dza shiy məniva ghala vəghwə tsa dzee səəkə yən Zəghwə yakə ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ma fəcava, mbaꞌa kə ndə mə jəba mbə tifər, mbaꞌa shi ci mbə cikiy, əntaa ghəci dzəmbə ciki tsa va ta ɓəshi ma. War ə kə dzaa hwəy gwaꞌa tsəgha. Ya kwamti dza ndəə nza mbə zay, əntaa ghəci dzaa ni: “Kadiw e zhəghəvaa jighi ta ɓəvə shi ya kəghi” kə ma. War ə kə dzaa hwəy gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Zəzətim dzəkən kwəma mali Ləwtə va. Sa niy naghay na pətsa ləy hwəm na, mbaꞌa niy mətita. ");
INSERT INTO bcw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Va tsəgha nə ya ngəŋwəy, ntsaa ɗi mbəlanti piy tsa ci tikə tə hiɗiy, ta zamti tsa mə ghwəmə piy tsa ci dza na. Ma ntsaa dzaa zamti piy tsa ci tikə tə hiɗiy, ta kwəmavə tsa mə ghwəmə piy tsa ci dza na, pən. ");
INSERT INTO bcw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ə gəzaŋwəy ya, tə vərɗi dzee vaa səəkəy, mbəzli bakə dza naa nza tə pi həni tsa kwətiŋ tsa, ka məndi dzay, mbaꞌam səəkəə ɓəhwə tsahwəti kwətiŋ ti shi, ma tsahwəti na, mbərəkə məndi zlay. ");
INSERT INTO bcw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Miꞌi bakə dza naa nza mbə hə tə vəna, ka məndi dzay, mbaꞌam səəkəə ɓəhwə nahwəti kwətiŋ ti shi, ma nahwəti na mbərəkə məndi zlata. ");
INSERT INTO bcw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mbəzli bakə dza naa nza mbə za kwamti na, ka məndi dza na tsaŋ məni səəkə ɓəhwə tsahwəti kwətiŋ ti shi, ma tsahwəti na mbərəkə məndi zlay» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma sa favə mbəzli ta səɗa ci kwəma gəzəkə Yesəw va, ma kə ghəshi kaa ngəci na: «Dzəghwa tima dza niva shiy məniva kia Ndə sləkəpə?» kə ghəshi. Ma kə Yesəw kaa ngəshi na: «Dzəghwa tə pətsa mətishi shiyəy tiɓa ka zliŋiŋ ɓasəva» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dzəghwa Yesəw mbaꞌa ɓəlanakəshi fir tsa kaa *mbəzli ta səɗa ci, ta mbə ghəshiy cəꞌwə Hyala war ka cəꞌwə, kala dali ma va cəꞌwə nzə. ");
INSERT INTO bcw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ma kə kaa ngəshi na: «A tsahwəti ndə sla ngwəvə niy nza tiɓa mbə nahwəti məlməy, kala hazləni ma ghəci va Hyala ya jəw nzə. Na naciy, ka nighə mbəzli na nja mbəzliw. ");
INSERT INTO bcw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dzəghwa, mbaꞌa nahwəti mali mbəri niy nza mbə məlmə va kwərakwə. War ka səəkə ghənzəə nza zhevi va ntsa va, a ghəci mananati ngwəvə nzə. Ma kəə ni ngəci na: “Ndəghatəŋəy fəti kwa jipə ghəy lə ndə jaka tsee tsa, nza gha mbəlitəra va kwəma va” kəə ni. ");
INSERT INTO bcw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndimndim mali va war mbə səəkə tsəgha, gwəŋəy ndə sla ngwəvə tsa va kala kəəti ma. Ma tə nahwəti vici na, dza na, mbaꞌa ghavə təkə kwəma mbə ghən ci, ma kə na “Ya tsəgha, hazləni mee va Hyala, kala nighə mbəzlee nja mbəzliy, ");
INSERT INTO bcw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta mananati ngwəvə mali na na dzee. Sa nzanay, war ə gagara na. Kala dza pən kəətitiy, ta səsə məhərlee dza na” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma sa kəɗamti Yesəw gəzanshi kwəma kwa fir ki, ma kə ngəshi ɓa na: «Favəm kwəma gəzəkə ndə sla ngwəvə ndə ndərəm tsa va di. Ya tsəghaa ntsa va kala nighə ndə nja ndəy, sa nzana war mbə səəkə mali va, war ka səəkə, war ka səəkə na, nay ntsa va ghwəy kəətiti sa. ");
INSERT INTO bcw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma Hyala nanzə ki na, kala dzaa kəətiti mbəzli nzə tsəhavə na, ghəshi kəə tsanta titihwə ka pəraꞌwanta dividivi, həvir lə havəghwə nə ghwəy shəkəna? Aa dzaa nzay nza ta kəətishi nə ghwəy na? ");
INSERT INTO bcw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ə gəzaŋwəy ya, taŋtaŋ dza naa zləɓavə kəətishi. Ghala vəghwə tsa dzee zhəkəə dzəti hiɗi, yən Zəghwə yakə ndə ngəriy, nza ya kəsashi mbəzliy ɓanavə nefer shi kataŋ kaa Hyala ki na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Dzəghwa Yesəw ka ɓəli fir kaa mbəzliy ɓəti ghən tsa shi va ka mbəzli ɗewɗew ni kwa kwəma Hyala. Kala nighə ma nihwəti mbəzli nja mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ma kə na: «Tə nahwəti viciy, təhwə dzashi nihwəti mbəzli bakə dzəmbə *ciki Hyala ta cəꞌwə Hyala. Mbəzli vay, ndə Farisa tsahwəti, ndə dəwan tsahwəti. ");
INSERT INTO bcw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ma sa dzəmbəshi ghəshi na, dza ndə Farisa gar garəy, ka cəꞌwə Hyala ki, ma kə na: “A Hyala, ꞌwəsa nə ya kaa ngəŋa, sa kamee nja nihwəti mbəzli gwanashi ni, mbəzli nja ka ghəli, ka vəraslə, lə ka ghwərghwər, ya nja ndə dəwan tsa tikə tsa sənzənva. ");
INSERT INTO bcw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yən na neyey, vici bakə kee tivə mbə ləwma kwətiŋ, ka məni səwmay. Ya nimaɓa shi vəyay, məŋ mbə kee təhəvərishi mbaꞌee ndaŋa nihwəti kwətiŋ” kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma ndə dəwan tsa va naci ki na, dza na gar garəy kərakə, kala kafə kwəma ciy dzəta ghwəmə. Kə mbəkwə mbəkwəti nəfə tsa ci, ma kə na: “A Hyalee, titihwə mənti zhəhwər tə ya, yənəy, ntsa jikir tsa nzee” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma sa kəɗamti Yesəw ɓəli fir ki, ma kə na: «Nay ghwəy e gəzaŋwəyəy, ma sa dzay naa jighiy, a Hyala zləɓavə cəꞌwə ci mbaꞌa pəlata kwəma ci jikir na. Ma na ndə Farisa na naciy, zləɓati na ci va kwəma Hyalaw. Sa nzana, ya wa ntsaa kəliti ghən tsa ciy, ta zhəghəti dza Hyala jəwə tsə tsə. Ya wa ntsaa zhəghəti ghən tsa ci jəwə ɓay, ta kafakati dza Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dza nihwəti mbəzli mbaꞌa ghəshi ɓanakə lə ndərazhi jəw jəw ni ta kaa Yesəw ta mbə ghəciy fakən dividivi ci kən shi ta təfanshi miy. Ma sa nashi *mbəzli ta səɗa Yesəw tsəgha na, dza ghəshi ka makə mbəzli va. ");
INSERT INTO bcw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dzəghwa Yesəw naci ki na, mbaꞌa harashi ndərazhi vaa dzəmbə hwər ci, ma kə kaa mbəzli ta səɗa ci na: «Zlashim ndərazhi jəw jəw ni va, a ghəshi sar dzəvəghee, ka makəshi ghwəy ma. Sa nzanay, gəla mbəzli nja ghəshi na shi sləkə Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ə gəzaŋwəy ya, ta na navay, tsəgha na, kala zləɓavə kə ndə Hyalaa sləkə mbə nəfə tsa ci nja zəghwə jəw nay, ka kwəmavə tsəhəy ndə tə pətsa sləkə na tepəw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ləy hwəm kwəma va ki na, dza tsahwəti ntsa dikə tsa mbə *ka Zhəwifə ndəs səəkəy va Yesəw ta ɗəw kwəma və, ma kə na: «A Metər tsa wəzə tsa, wa shi dzee mənti kee kwəmavə piy tsaa kəɗi ma tay?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma kə Yesəw kaa ngəci na: «Sa wana nə gha, ntsa wəzə tsa, pə gha kaa ngəraa? Ndə tiɓa wəzə ghəci kala war Hyala kwətiŋtaw. ");
INSERT INTO bcw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Talay, a gha sənata kwəma gəzəkə *kwəma pəhəti Hyala ɓasa. Ma kəy: “Ka pəla mali ndə gha ma, ka pəəsli ndə gha ma, ka ghəli gha ma, ka təɓə dzərvə ghaa dzəkən ndə ma, ə pə ghaa haꞌwə tə kar dəŋa lə məŋa” kə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma sa favə ntsa va tsəgha, ma kə na: «A Metər, shi ɓəlakə gha niy, gwanashi nəwamtishee ghala yən zəghwəra» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma sa favə Yesəw kwəma zləɓakə na va, ma kə kaa ngəci na: «Ma ghənzə tsəghay, shiy kwətiŋ tərə na va gha nana ta mənishi gha. Mbala pamti səkəm tə shi va gha gwanashi, a gha tahanavəshi gəna va kaa ka ndərma, nza gha səəkə ta nəwra. Ma ghalaɓa kiy, ta kwəmavə shiy gwəramti dza gha mə ghwəmə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","War sa favə ntsa va kwəma gəzəkə Yesəw va tsəgha na, ka zhanci nəfə tsa ci tərəŋw, sa nzana ndə shiy tsa tərəŋw tsa ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dzəghwa mbaꞌa Yesəw nay njasa zhanci nəfə tsa ci. Ma kə ki na: «Nay ghwəy na, ngahə na tsəhə tə pətsa sləkə Hyala va ka shiy. ");
INSERT INTO bcw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɓəlaŋɓa ngaləwba dza naa dzəvərita kwa kwal batal cisli shiy, kən dzəti pətsa sləkə Hyala va ndə shiy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ma sa favə mbəzli kwəma ci va tsəgha, ma kə ghəshi na: «Əy, war tsəgha kə kiy, wa ntsaa dza vaa mbəliy kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma kə Yesəw na: «Ma shi mbashi ma mbəzli vaa məntiy, kar Hyala mbay məntishi na nanzə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma kə Piyer na: «Ghəy sana kiy, avanay gwaꞌa gwaꞌa zlashi ghəy shi ghəy, mbaꞌa ghəy nəwvəŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma kə Yesəw ngəshi na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya wa ntsaa zlay ghi tsa ci, ya mali ci, ya ngwarməhiy, ya mbəzliy yakə, ya ndərazhi yakə na, war ta sləkə Hyala njasa dza Hyala sləkə mbəzliy, ");
INSERT INTO bcw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta kwəmavə shiy dza na tərəŋwɓa ghəshi, kaa shi zlashi na va, mbə vəghwə tsa sənzənva tsa. Ghala vəghwə tsaa dzaa zhikə diɓay, ta kwəmavə piy tsaa kəɗi ma dza na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma ləy hwəm kwəma va ki na, dzəghwa Yesəw mbaꞌa harvə *mbəzli ta səɗa ci va məŋ lə bakə ni, ma kə kaa ngəshi na: «Avanammə mbə kwal sana ta dzəmə məlmə Zherəwzaleməy, mbəɓa dza kwemerəy niy tsasliti ka Hyala mbəradzə gwanashiy dzəkənee, yən Zəghwə yakə ndə ngəriy məniva. ");
INSERT INTO bcw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta fambəra dza məndi mbə dəvə *mbəzliy kamaa ka Zhəwifə, ka ghəshi dza na, ka ꞌwəshira, ka tsəərəɗa, ka tifə ndighwər dzətee. ");
INSERT INTO bcw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka ghəshi dza diɓay, ka dəꞌwəra lə kwərəpə. Ma ləy hwəm ki na, ka ghəshi dza mbəh paslamtəra. Mənti mee vici bakə kwa kwəli, tə kwa mahkana viciy, ta zhikəməra dzee kwa kwəli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma sa gəzəkə Yesəw kwəma va tsəghay, shaŋ mbəzli ta səɗa ci ta favə kwəma ɗi naa gəzə, sa nzana mbaꞌa mahəzlaɗə tsa kwəma va niy mbələyvata və shi. Kala sənata ma ghəshi nda dzəkən wa gəzə Yesəw kwəma va. ");
INSERT INTO bcw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ma tə nahwəti vici na, mbaꞌa Yesəw maɗiy ta dzəmbə məlmə Zherikwə. Ma ghəci ndəkwə ta tsəhə na, mbaꞌa tsahwəti ghwəlfə niy nza mənzəy vəgha kwal mbə cəꞌwə shiy. ");
INSERT INTO bcw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ka dzar mbəzli ɗaŋ vəgha ghwəlfə tsa va. Ma sa favə na gaka səɗa mbəzli ghəshi mbə dza na, kə ka ɗəw kwəmaa mənta va mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma kə məndi ngəci na: «Waa Yesəw ndə ka Nazaretə na saa dzar» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","War sa favə na tsəgha na, dza na ka zlapanci kwəma, a kə na: «A Yesəw Jijiy mazə *Davitə, mənti zhəhwər tə ya» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dzəghwa mbəzliy niy nza kwa kwəma na, ka naɓə, a kə ghəshi na: «A ghwəlfə tsa, kalay miy tsa gha va» kə ghəshi. War ə ghəciy mətsəhə zlapə kwəma, a kə na: «A Jijiy mazə Davitə, mənti zhəhwər tə ya na gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma sa favə Yesəw tsəgha na, dza na gar garəy. Ma kə kaa mbəzli na: «Kəsəram ghwəlfə tsa vaa sar» kə. Dza mbəzli ka kəsəə dzəvəgha Yesəw. Sa kəsəghəm na, dza Yesəw ka ɗəw kwəma və, ma kə ngəci na: ");
INSERT INTO bcw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«A ntsa, a shi ɗi gha yən məntəŋa?» kə. Ma kə ghwəlfə tsa va na: «A Ndə sləkəpə, ə ɗee ghaa ghwənantəra mətsəhee ni, ta mbee nay pi» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma kə Yesəw ngəci na: «A mətsəhi gha ghwənishi, sa ndara gha nəfə tsa gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","War sa gəzəkə Yesəw tsəgha na, dza mətsəhi ghwəlfə tsa va, mbaꞌa ghəshi ghwənishi tiɓata ka nay pi ghəci ki. Dza na ka nəw Yesəw, war fal ghəciy fal Hyala. Mbəzliy ɓasəshi va gwanashi na, mbaꞌa ghəshi nata kwəma va. Dza ghəshi ka fal Hyala kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mbaꞌa Yesəw tsəhəy mbə məlmə Zherikwə, ka dza ghəci mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mbaꞌa tsahwəti ndə gəna niy nza tiɓa mbə məlmə va, Zashe, kə məndi kaa slən tsa ci. Dikə tsa ka *dəwan ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dza na ka ɗi pəla nay Yesəw ghəci ta mbəə sənay. Kaf kafəy ta nighə, shaŋ ghəci ta nay, sa nzana ɗaŋshi mbəzli, dəkwəy ghəci. ");
INSERT INTO bcw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dzəghwa na bəvbəpə ghavə bali, ka dzay kwa kwəma. Dza na taram dzəməy mə fə dikə na ta mbə ghəciy nay Yesəw, sa dza na ta dzar ta fə va. ");
INSERT INTO bcw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma sa tsəhəy Yesəw ta fə va na, dza na kafə kafata kwəma ci, mbaꞌa nay Zashe məɓa. Ma kə ngəci na: «A Zashe, mbata gha, səkwa mə fə va taŋtaŋ. Ndatsəy kəghi tsa gha dzee ta fə gwəci tsee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dza Zashe ka səkwa kyaŋwkyaŋw mə fə va, mbaꞌa pəməghə dzakə ghi tsa ci, mbaꞌa kaꞌwəvə lə vəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma sa nata mbəzli tiɓa gwanashi nava kwəma tsəgha na, tapə ghəshi mbə ngwəzlimə, ma kə ghəshi na: «Ntsay, kəghi tsa ndə məni *kwəma jikir na dza na ta hi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Əy, ma na Zashe naci ki na, dza na gar garəy kwa kwəma Ndə sləkəpə, ma kə ngəci na: «A Ndə sləkəpə, ta təhəvəri shi vəya dzee bakə mbə, nzee ɓanavə nahwəti bəla kaa ka ndərma. Ya ə niy ngəɗəhwee shiy va ndə ghala pətsaa mənee dəwanəy, ta wanati gəna ci va niy ɓəhwee dzee faɗə səɗa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma kə Yesəw ngəci na: «Ndatsəy a Hyala mbəlitəŋa lə mbəzli kəghi tsa gha gwanashi. Sa nzana, mbaꞌa gha ɓanavə nəfə tsa gha kaa Hyala nja *Abəraham, va tsəgha nza ghaa jijiy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na nee yən Zəghwə yakə ndə ngəriy, ta pəla mbəzliy zashi, ta mbəlishi səəkəree» kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma mbə zəzə kwəma mbəzliy, ndal tərmbə Hyala ta səəkə ta sləkə mbəzliw, niy nə ghəshi. Sa nzana ndəkwə Yesəw niy nza ta tsəhə mbə məlmə Zherəwzalem. Dzəghwa Yesəw ki na, mbaꞌa ɓəlanakəshi tsahwəti fir kaa mbəzliy favə kwəma gəzəkə na va, ");
INSERT INTO bcw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ma kə ngəshi na: «A tsahwəti ntsa dikə tsa niy nza tiɓay, dza na mbaꞌa maɗiy ta dzaa dzəti hiɗi kərakə ni ta pəla mazə. Ma sa naa kwəmavəy nza ghəci zhəkəy ta nza. ");
INSERT INTO bcw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dzəghwa na ghəci taa maɗi, daꞌ daꞌ harashi mbəzli məŋ mbə ka sləni ci. Sa ɓasəshi ghəshi na, dza na kaa gəna, mbəl diwəy diwəy diwəy tahanavəshi gwanashi. Ma kə kaa ngəshi na: “Mbalam zhəghəm dəvə lə gəna va paꞌ fəca vici dzee zhəkə ti” kə. Dza na pəlhəm maɗiy ka dzay. ");
INSERT INTO bcw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mbalaa niy ɗi mətsə ci mbəzli mbə məlmə ci vaw. Ma sa dzay na na, dza ghəshi, ɓəŋ ghəshi ghwənashi mbəzli ləy hwəm ci, ta dza ghəshiy gəzanshi kaa mbəzli dza ntsa va va ta pəla mazə və shi. Ma kə mbəzli va taa ni na: “Ghəy na na ghəyəy, ka ɗi ghəy ntsa vaa məni mazəə dzəkən ghəyəw” kə ghəshi taa ni. ");
INSERT INTO bcw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ya tsəgha nzə na, dza məndi mbaꞌam ɓanavə mazə tsa ci kaa ntsaa va naci. Mbaꞌa zhəkəy dzəti hiɗi ci ta məni mazə ki. Dza na mbaꞌa ɓasəkə ka sləni ci va tahanavəshi na gəna ghəciy dzay, ta sənashi shi mətsahakən ghəshi kən gəna va ki. ");
INSERT INTO bcw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ma sa ɓasəshi ghəshi na, dzəghwa kwa taŋa ndə, təhwə səəkəy, ma kə na: “A Ndə sləkəra, ma gəna ndara gha va ta zhəghə dəvə liy, a mbəl diwəy diwəy məŋ mətsəhəy dzəkən” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma kə ntsa ci va dikə tsa ngəci na: “Wəzə tsəgha! Ndə sləni tsa wəzə tsa nza gha. Sa nzana, mbaꞌa gha ghərati sləni jəw na lə nəfə kwətiŋ. Avee ndaŋa məni mazə dzəkən məlməhi məŋ” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dza kwa baka mbaꞌa maɗiy ta gəzə kwəma, ma kə na: “A Ndə sləkəra, ma gəna ndara gha va ta zhəghə dəvə liy, a a mbəl diwəy diwəy cifə mətsəhəy dzəkən” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma kə kaa tsava ɓa na: “Gha kwərakwəy, avee ndaŋa məni mazəə dzəkən məlməhi cifə” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dza tsahwəti mbaꞌa kafəy, ma kə na: “A Ndə sləkəra, avanay mbəl tsa gha diwəy tsa nee, mbə kəjer niy parambee mbələy. ");
INSERT INTO bcw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ə niy ghəratəra hazləni va gha tərəŋw, sa nzanay, ntsa ghyanakə tsa nza gha. Na na ghay, shiy kamaa shi gha na, tsaŋ ka ghaa ɓəhwəshi. Shi zati ma gha na, mbaꞌa ghaa lahwəshiy nza” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ma kə mazə ngəci na: “Ghay ndə sləni tsa gəmgəm tsa nza gha. Tə kwəma gəzəkə miy tsa gha dzee ta məniŋa ngwəvə sənzənva. Ya sa sənay gha ntsa ghyanakə tsa nzee, shiy kama ka shi ya na, tsaŋ kee ɓəhwə shi, shi zati mee na karee lahwəshi, pə gha kiy, ");
INSERT INTO bcw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","wa shiy mənishi niy ɓanavə ma gha gənee va kaa tsahwəti ndə, a ghəci zhəghə dəvə li, ya ə dzee zhəghəkəvara tsətsə na, ma nzee ɓə see lə yam kən nzaa?” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ma sa gəzəkə na tsəgha, ma kə kaa mbəzli tiɓa na: “Ɓantim mbəl tsa diwəy tsa va və, a ghwəy jakanakən kaa ntsa nza mbəl diwəy diwəy məŋ va və!” kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ma kə məndi ngəci na: “A Ndə sləkəpə, lə tsahwəti mbəl diwəy diwəy məŋ və kiy, tawa lə tsava və diɓaa?” kə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma kə ntsa dikə tsa va na: “Favə tə ghwəy, e gəzaŋwəy, ntsaa kwəmavə shiy, dza na ka ghəra sləni ghəci li shiy, ta mətsahanavə shiy dza məndiy dzəkən shi. Ma ntsaa kwəmavə shiy va, kala zhəghə dəvə ghəci li shiy, ə dza məndi zhiniy ɓəhwə ya ni jəw ni va shiy və. ");
INSERT INTO bcw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta na ka jakee va niy ɗi ma yən məni mazə dzəkən shiy, kəəsəkəshim a ghwəy bakwamtishi tikə kwa kwəmee” kə ntsa dikə tsa va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ma sa gəzamti Yesəw kwəma va tsəgha ki na, dza na mbaꞌa dzətiy tə kwəma mbəzli, ta dzəmbə məlmə Zherəwzalem. ");
INSERT INTO bcw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dza na mbaꞌa tsəhəy ndəkwə vəgha məlmə Betəfazhe mbaꞌa vəgha məlmə Betani, vəgha kəlaŋ tsa har məndiy kəlaŋ *ꞌWəlivə. Kə tiɓa mbaꞌa ghwənashi mbəzli bakə mbə mbəzli ta səɗa ci kwa kwəma. Ma kə ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Mbalam dzəmbə məlmə tarɓa va kwa kwəma ghwəy, sa ka ghwəy tsəhəŋwəy mbəy, ta kəsay zəghwə kwantəmca dza ghwəy pəhəpəhə kala səəkə ndəə nza mə, nza ghwəy pəlikəvə. ");
INSERT INTO bcw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mbaꞌa kə ndəə ɗəw va ghwəy: “Tawa pəli ghwəya?” kəy, “Waa Ndə sləkəpə ɗəw na” pə ghwəy taa ni ngəci» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sa gəzanakəshi Yesəw tsəgha na, dza mbəzli va mbaꞌa ghəshi dzashi. Sa tsəhəshi ghəshi na, mbaꞌa ghəshi kəsata kwəma va njasa gəzanakəshi Yesəw va. ");
INSERT INTO bcw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dza ghəshi ka pəli kwantəmca va ki. Ma ghəshi mbə pəli, ma kə ka kwantəmca va ngəshi na: «Tawa pəli ghwəy kwantəmca va shika mbəzli ni?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma kə mbəzli va ngəshi na: «Waa Ndə sləkəpə ɗəw na» kə ghəshi. Mbaꞌa ka kwantəmca ɓanavəshi kwal ta pəli nzə. ");
INSERT INTO bcw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dza mbəzli va ki, mbaꞌa ghəshi kəsəghə zəghwə kwantəmca tsa va kaa Yesəw. Dza ghəshi mbaꞌa ghəshi fafati kwəbeŋer shi tə hwəm kwantəmca va. Kə ghəshi ɗal ghəshi famə Yesəw mə, ");
INSERT INTO bcw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ka dza ghənzə liy dzəmbə Zherəwzalem. War ə mbəzli pəpəəli kwəbeŋer shi dzar kwa kwal, ta mbə ghəciy dza dzar ti shi. ");
INSERT INTO bcw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ka səkwa ghəci kwa kwal tsaa səəkə va mə kəlaŋ *ꞌWəlivə, mbaꞌa tsəhəy ndəkwə vəgha Zherəwzalem. Dza mbəzli kwasəbə va ɗaŋ ni gwanashi ki, ka vəshi, ka fal Hyala zlaŋzlaŋ, ta kwəma maɗaŋa maɗaŋa na va nata ghəshi ɗaŋ na. ");
INSERT INTO bcw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma kə ghəshi na: «Təfanati miy tsa nzə Hyalaa sləkəpə kaa ntsaa səəkəy tsa, Mazə mbə slən tsa nzə! A zərkə səəkəy mə ghwəmə, tə shəndəkə ghwəmmə dzəti Hyala dikə na!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A nihwəti *ka Farisahi niy nza mbə mbəzli va. Ma sa favə ghəshi tsəgha, ma kə ghəshi ngəci na: «A Metər, gəzanshi kaa mbəzliy nəwŋa ni, a ghəshi nzəyshi gwəŋəshi!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma kə Yesəw na: «Nay ghwəy e gəzaŋwəy na, mbaꞌa kə ghəshi nzəyshi gwəŋəshi sənzənvay, ta ngwəmə lala dza hərezliy dza ta falɗa!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dza Yesəw mbaꞌa tsəhəy vəgha məlmə Zherəwzalem. Ma sa nata na na, tapə ghəci mbə wahəə dzəkən mbəzli mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma kə na: «A mbəzli ni, mbaꞌa pə ghwəy taa nza gar zləɓa zərkə tsa ɗi Hyala ɓəŋwəy ndatsəy, a ghwəy taa mbəliŋwəy! Vanay sana kiy, mbəmbə na kwəma va va ghwəy, ka mbay ghwəy sənataw. ");
INSERT INTO bcw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A gəzaŋwəy ya, a nahwəti vici ngəraꞌwə tiɓa taa səəkəə dzəkən ghwəy, ta dəzlay məlmə ghwəy dza ka mbəz ghwəy, lə shi mbəz tərəŋw ni və shi. Ka ghəshi dza na təpələꞌwə ɓasakənvashiy dzəkən ghwəy, ka ghəraŋwəy gwanaŋwəy. ");
INSERT INTO bcw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kərəp dza ghəshiy zantəŋwəy, lə məlmə ghwəy ta gwaꞌa. Ka dza ghəshiy zlay ya hakwə tsa tsəŋzlaməm mə tsahwəti manəy mbə məlmə vaw. Dza kwəma vaa məniva tsəghay, sa nzana ghala vəghwə tsaa niy səəkəta Hyala ta mbəliŋwəy na, kalaa niy zləɓa ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dza Yesəw mbaꞌa dzəmbəy mbə ciki Hyala. Ma sa nashi na ka zhəghə dəvə na, kə ka tihəshi səvəri mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma kə kaa ngəshi na: «Ma kə məndi mbə Zliya Hyalay: “Ciki tseyey, ciki tsa dza mbəzliy cəꞌwəra mbə dza naa nza” kə məndi. Ma dza ghwəy na ghwəy ki na, mbaꞌa ghwəy zhəghəti ka ləgwə ka ka ghəliy nzəy mbə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Njasa səəkə vici va na, war tsəgha Yesəw niy nza mbə gəzə kwəma Hyala kaa mbəzli mbə ciki tsa nzə. Ma mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *ka ɓənipə kwəma pəhəti Hyala, mbaꞌa mbəzli dikə dikə ni mbə *ka Zhəwifə na, war mbə pəla kwal tsaa pəəsli ci ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Shaŋ ghəshi ta sənay njasa ka ghəshi mbəə kwəmavə kwal pəəsli ci. Va sa nzana, mbə fa kwəma ɓənipə na va mbəzli niy nza lə nəfə kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tə nahwəti viciy, dza Yesəw ka ɓəni Yəwən kwəma wəzə na kaa mbəzli mbə *ciki Hyala. Dza mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *ka ɓənipə kwəma pəhəti Hyala, mbaꞌa mətikwəkwər *ka Zhəwifə tsəgha, ndəs ghəshi səəkəshiy dzəvəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ka ɗəw kwəma ghəshi, ma kə ghəshi na: «A Metər, gəzaŋəy, kwəma səəkə ni gha ni bərci ghəra gha sləni ghəra gha na li shi tay? Wa ntsaa ndaŋa kwal ta ghəra gəla sləni naa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma kə Yesəw ngəshi na: «Yən kwərakwəy, ta ɗəw kwəma dzee va ghwəy kwətiŋ. E ɗi ghwəy gəzara, ");
INSERT INTO bcw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hyala ghwənay na Zhaŋ ta mənipə *batem ta naa, naa mbəzli?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma sa gəzəkə Yesəw tsəgha na, dzəghwa ghəshi ka sləka kwa jipə shi, ma kə ghəshi na: «Njaa dza ghwəmməə ni kaa nana kwəma sana kia? Mbaꞌa pə ghwəmmə ni: “Hyala ghwənay na Zhaŋ” pə ghwəmməy, “Ya sa nzana Hyala ghwənay na, tawa niy zləɓa ma ghwəy kwəma ci shiki?” dza naa ni. ");
INSERT INTO bcw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mbaꞌa pə ghwəmmə ni diɓa: “Mbəzli ghwənay na” pə ghwəmmə na, ka mbəzli gwanashi dza ɓa na, ka pəꞌwəmmə lə hərezli ta bəkwəmmə. Sa nzanay, gwanashi sənay məndi Zhaŋ ka *ndə gəzə kwəma Hyala» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ma sa hashishi ghəshi ki na, ꞌwakəvə ghəshi tsəgha: «Sənay ntsaa ghwənay ghəyəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma kə Yesəw ngəshi ki na: «Ghənzə tsəghay, yən kwərakwə na, ka gəzaŋwəyee nda kwəma səəkə bərci ghəree ni sləni li shiw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dzəghwa Yesəw ləy hwəm kwəma va, mbaꞌa maɗiy ta ɓəli fir lə kwəma na, ma kə kaa mbəzli tiɓa va na: «A tsahwəti ndə niy nza tiɓay, dza na ngwəɓə, ngwəɓə ngwəɓə ngwəɓəti fəhiy zəmə tə vəh tsa ci. Dza na ki, mbaꞌa pəlavə mbəzli ta ndəghwə tsa va, mbaꞌa zlata mbə dəvə shi, mbaꞌa dzay ta wə, kə dalala ghəci hiy mbə wə va. ");
INSERT INTO bcw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mbaꞌa vici ngəli ya fəhi mənta, dza na ɓəŋ ghwənay ndə sləni tsa ci va mbəzliy ndəghwə tsa ci va, a ghəci dzaa ɓanakə na ci bəla ya fə. Ma sa tsəhəy ndə sləni tsa va na, dza ghəshi dəꞌwə dəꞌwə ghəshi dəꞌwəti ntsa va, mbaꞌa ghəshi pəlay dzay jighi tsəghay. ");
INSERT INTO bcw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ənkwa, kə ndə tsa tsa va, zhəghwa na ɓəŋ ghwənay tsahwəti ndə sləni tsa ci ɓa. ꞌWakəvə ghəshi kaa tsava ndə ɓa tasl ghəshi kəsəti. Zhəghwa ghəshi dəꞌwə dəꞌwə ghəshi dəꞌwəti tsava diɓa, tsəərə tsəərə ghəshi tsəərəti. Mbaꞌa ghəshi təhay jighi tsəghay. ");
INSERT INTO bcw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaŋ, kə ntsa va, zhini na diɓa ɓəŋ ghwənay kwa mahkana ndə. Sa tsəhəy na na, dza ghəshi mbaꞌa ghəshi paslanati zheher, mbaꞌa ghəshi təhamti. ");
INSERT INTO bcw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ma sa nata ndə tsa tsa va kwəma va tsəgha, ma kə na: “Njaa dzee mənti tay? Kadiw, e ghwənay zəghwee na ɗee tərəŋw. Sa ka ghəshi nayəy, a ghəshi dzaa haꞌwə ti” kə. Dza na ɓəŋ ghwənay. ");
INSERT INTO bcw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dza zəghwə va mbaꞌa tsəhəy və shi ki, ma kə mbəzliy ndəghwə tsa va kwa jipə shi, sa nay ghəshi zəghwə va na: “Yawaa, avanay ndə zəmə ghi səəkəy dəꞌwə ghən tsa ci ki! Dzammə ta kəsəvə, a ghwəmmə paslamti! A tsa mbəə nza ka sa ghwəmmə kwagwaꞌa ki” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dza ghəshi tasl ghəshi kəsəvə, ka mbahə səəmə kwa tsa vaa dzəti ngwəla, mbaꞌa ghəshi pəəsliti» kə Yesəw. Ma sa kəɗamti Yesəw fir tsa va, ma kə diɓa na: «Sana kiy, njaa dza ndə tsa tsa vaa məni lə mbəzli vaa? ");
INSERT INTO bcw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ə gəzaŋwəy ya, ta səəkə dza naa bakwamti ka ndəghwə tsa va, ka na dza na mbaꞌa ɓanavə tsa ci va kaa nihwəti ka ndəghwə tsa mbə dəvə shi» kə Yesəw. Ma sa favə mbəzli va kwəma gəzəkə Yesəw va tsəgha, ma kə ghəshi na: «Kay, ka məniva gəla nava kwəma tsəgha teepəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ꞌWakəvə Yesəw njəꞌwə nighətishi, ma kə ngəshi na: «Kwəma tsasliti məndi na mbə Zliya Hyalay, wa slən tsa shi ɗi na gəzəa? Ma kə məndi kwəma vay: Ma hakwə tsaa niy ndəghamti ka ndəɓə shiy vay, ghəci zhini naa zhəghəy ka hakwə tsaa gwəraa jihəti ciki, kə məndi mbə zliya. ");
INSERT INTO bcw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ya wa ntsaa ɓati tərəə dzəti hakwə tsa vay, ta ɓəəlivərivay dza ntsa va. Ghəci kə tərakənvay kən ndə ɓa na, mbaꞌa zlərəvəri ndə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma sa gəzəkə Yesəw kwəma va tsəgha na, cəkeꞌ *ka ɓənipə kwəma pəhəti Hyala lə mbəzli dikə dikə ni mbə *ka ta Hyala fəti ghən, dzəkən ghəy ɓəli Yesəw fir tsa va, kə ghəshi. Dza ghəshi ka pəla kwal tsaa kəsə Yesəw tiɓata. Kala mbə ghəshiy kəsə, sa hazləni ghəshi va mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ghalaɓay dza ghəshi ki mbaꞌa ghəshi ghati ndəghwə Yesəw ta kəsə. Kə ghəshi mbaꞌa ghəshi ghwənashi mbəzliy taa məntəvashi nja mbəzli tərəŋw tərəŋw ni. Nza ghəshi ɗəɗəw kwemer va Yesəw, ta mbə ghəshiy ngaliti, ta kəsəti mbə kwəma dza naa zləɓakə. Ə ɗi ghəshi kwəmavə kwal tsaa kəsəti ta ɓanaghə kaa ngwəmna. ");
INSERT INTO bcw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma sa tsəhəshi ghəshi vəgha Yesəw ki, ma kə ghəshi kaa ɗəw kwəma shi na: «A Metər, a ghəy sənay, shi ɓənipə gha ni lə kwəma gəzə gha gwanatay, war kwəma lə kwal na. Sa nzanay, ka nə gha kar ntsa dikə tsa na tsatsa ndə, ntsa jəw tsa na tsatsa ndə, pə gha, ka təra ghalaa dzəmbə mbəzliw. Ma ghay, kwəma Hyala na sa ka ghaa ɓananshi kaa mbəzli lə kwal tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Va tsəgha ɗi ghəy ghaa gəzaŋəy, kwal va ghwəmmə ta tsəhə ghən kaa mazə tsaa sləkə hiɗi ka Rəm gwanashi ta naa njaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Yesəw na naci ki na, mbaꞌa sənamti tsəhwəli shi va, ma kə ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Citəram dala va ghwəy tə pətsa va di. Fəətə tə dala na na sanay, fəətə wa naa? Ya slən tsa tsaslati məndi tsa tiy, slən tsa wa naa?» kə. Ma kə ghəshi na: «Fəətə mazə tsaa sləkə hiɗi ka Rəm gwanashi na, slən tsa ci sa va diɓa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma kə Yesəw ngəshi ki na: «Ma ghənzə tsəgha kiy, tsəhancim ghən tsa ci kaa mazə tsa va njasa təɓə na. Ma ni Hyala shiy na, mbaꞌa ghwəy ɓanavə shi Hyala njasa təɓə ghəshi kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma sa gəzanakəshi Yesəw tsəgha na, mbaꞌa gəla nava kwəma səəti məhərli shi, mbaꞌa ghəshi catavashi. Shaŋ ghəshi ta favə, kwəma gəmgəm na gəzəkə na tiɓa kwa kwəma mbəzli gar kəsəti ghəshi ti. ");
INSERT INTO bcw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dzəghwa nihwəti mbəzli mbə *ka Sadəsehi ndəs ghəshi səəkəə kəsay Yesəw. Ka Sadəsehi vay, ka zhakati mbəzliy bəkwəshi mbə mətiw, ka ghəshiy ni na nashi. Sa səəkəshi ghəshiy dzəvəgha Yesəw ki na, dza ghəshi ka ɗəw kwəma və, ");
INSERT INTO bcw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ma kə ghəshi na: «A Metər, a kə *Məyizə niy ni kaa kwəma tsaslitəŋəy na ta məni ghəyəy: “Mbaꞌa kə ndə ɓəvə mali, dza na mbaꞌa mətiy zlata mali ci va, kala yakə zəghwə ghəshi liy, ə kə zəmbəghəy dzaa ɓə mali mbəri tə mali ci va, ta mbə ghəciy yanakə hwəlfə kaa zəmbəghəy tsaa mətiy va” kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A nihwəti mbəzli niy nza tiɓa, mbərfəŋ ghəshi ka ndərazhi ndə kwətiŋ. Dzəghwa Cikwa tsa mbə shi mbaꞌa ɓəvə mali, dza na mbaꞌa mətiy, kala yakə zəghwə ghəshi li. ");
INSERT INTO bcw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dza Zəra mbaꞌa ɓəvə mali mbəri tə mali va, kə mbaꞌa mətiy kala yakə zəghwə ghəshi li kwərakwə. Zhini Takwa ɓa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","War tsəgha, war tsəgha, pəŋw ndərazhi mbərfəŋ ni va hati ɓə mali mbəri tə mali va. Cəkeꞌ ghəshi bəkwəshi mbərfaŋanavashi, nək tsaa yakə zəghwə kwa. ");
INSERT INTO bcw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma ləy hwəm ki na, mbaꞌa mali va mətita kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sana kiy, avanay gwanashi ɓəhwə mbəzli va mali va. Fəca vici dza mbəzliy zhakati mbə məti kiy, mali tsama ndə dza naa nza mbə shi kwətiŋ kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma kə Yesəw kaa zləɓanshi na: «Tikə tə hiɗi sənzənvay, mbə ɓəɓəva na kar zhər lə miꞌi. ");
INSERT INTO bcw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma na zhər lə miꞌi dza Hyalaa ni, gar zhakati na nini mbəzli mbə məti ta piy mbə vəghwə tsaa dza səəkə kwa kwəma, kəy, ka dza niva mbəzliy ɓəva ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ka dza ghəshiy zhiniy bəkwəw, yəmyəm dza ghəshiy nza lə ka kwal Hyala. Ndərazhi Hyala dza ghəshiy nza, sa nzanay, a ghəshi zhakatishi mbə məti. ");
INSERT INTO bcw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma na kwəmaa dzəkən zhakati tsa mbəzli mbə mətiy, a Məyizə niy gəzəkə, mbəzliy bəkwəshiy, ta zhakatishi dza ghəshi mbə məti, kə. Mbə zliya ciy, aa niy tsaslitiy dzəkən ghwə mbə zhəghwə, ma mbəɓay: “Hyala kar *Abəraham, lə *Izakə, mbaꞌa *Zhakwapə” kə niy ni kaa har Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɗi naa gəzəy, tə ghwəməshi na mbəzliy bəkwəshi va. Sa nzanay, na na Hyala na, Hyala mbəzli bəkwə bəkwə ni naw, Hyala mbəzli tə ghwəmə mbə piy na, na nanzə. Ti piy mbəzli gwanashi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma sa favə ghəshi kwəma gəzəkə Yesəw va, ma kə nihwəti mbəzli mbə *ka ɓənipə kwəma pəhəti Hyala na: «A Metər, a gha gəzəkə kwəma wəzə na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dzəghwa mbaꞌa ghəshi hazlənishi va zhiniy ɗəw nahwəti kwəma və. ");
INSERT INTO bcw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma kə Yesəw ngəshi na: «Njaa njaa ka məndi ni “Kəristəw Ntsa tivə Hyala na, jijiy mazə Davitə na” kə məndia? ");
INSERT INTO bcw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ya Davitə dəꞌwə ghən tsa ci kiy, aa gəzəkə mbə *zliya cəm tsa ci, ma kəy: Ma kə Hyala kwa sləkəpə, kaa Ndə sləkəray: “Ndi nzəyŋa tə kwa bəzəmee, ");
INSERT INTO bcw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","paꞌ fəca dzee mənti ka mbəz gha ka mbəzli tə dəvə gha!” kə, kə Davitə niy ni. ");
INSERT INTO bcw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nighətim Davitə dəꞌwə ghən tsa ci, “Ndə sləkəra” kə kaa har slən tsa Kəristəw kiy, njaa njaa ka na zhiniy nza ka jijiy kia?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dzəghwa Yesəw ka gəzə kwəma kaa mbəzli ta səɗa ci kwa kwəma mbəzli ɗaŋ, ma kə kaa ngəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Avee gəzaŋwəy, ya tə ghwəy ghən tsa ghwəy va yəmə kwəma məni *ka ɓənipə kwəma pəhəti Hyala! Na nashiy war lə kwəbeŋer dikə dikə ni ka ghəshiy ɗi dza kən ghən, ta ci dikə tsa shi. Jəw ɗi ghəshi məndiy səkwəshi mətsəfəkwə dzar tə ləwmaw. War tə kwəma ka ghəshiy ɗi nzəy mbə *ciki ɓasəva tsa ka Zhəwifə. Mbaꞌa kə məndi harvəshi ta zəmə shiyəy, war pətsa nzəy mbəzli tə slən va ti ka ghəshiy pala ta nzəy ti. ");
INSERT INTO bcw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ghəshi diɓay, meꞌ meꞌ ka ghəshiy pamti shiy va miꞌi mbəreketi, zhini ka garə kə ghəshiy ni ta cəꞌwə Hyala, ka ghəshi dza na, nzaꞌ nzaꞌ nzaꞌ ghəshi nzati nza tə cəꞌwə va, ta mbə məndiy ni, ka nəw Hyala tərəŋw ni ghəshi, kə məndi. Na nashiy, ta məni ngwəvə dza Hyalaa dzəkən shi, taŋ na nihwəti mbəzli» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ma Yesəw mbə *ciki Hyala na, dza na ka nighə njasa shəkə ka gəna shiy kaa Hyalaa dzəghwa sərndəkə. ");
INSERT INTO bcw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mbaꞌa nighəvə njasa səəkəta nahwəti mali mbəri kwa ndərma kwərakwə, mbaꞌa faghwa dala bakə kwa sərndəkə tsa va. ");
INSERT INTO bcw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma sa naghamti Yesəw kwəma va tsəgha, ma kə ki na: «Ə gəzaŋwəy ya lə kataŋ, mali mbəri kwa ndərma nata ghwəy nay, tərəŋwɓa ghənzə faghwa na gəna kaa mbəzli tiɓa gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sa nzanay, nihwəti mbəzli gwanashiy, war jəwə tsətsə tivə ghəshi gəna ɓəkə ghəshi səvəri mbə nahwəti na ɗaŋ na tərmbə və shi. Ma na mali na nanzə kiy, ya tsəgha na mbə ndərma na, dza na mbaꞌa ɓasanavə shiy niy dza naa pa shiy dzəghwa hwər nzə ti shi gwanashi kaa Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dzəghwa nihwəti mbəzli ka gəzə kwəmaa dzəkən *ciki Hyala tsa mbə Zherəwzalem, ma kə ghəshi kaa Yesəw na: «Kay, jəw təɓə hərezli ndəɓəti məndi ni ciki tsa li shiw, jəw ghaslamti məndi tsava cikiw, zhini mbaꞌa shi wəzə wəzə ni mbəɓa, shi ɓəkə məndi kaa Hyala ta fanta shəndəkə» kə ghəshi. Ma sa favə Yesəw məndiy gəzə kwəma va tsəgha, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ə gəzaŋwəy ya, mbə səəkə na tsahwəti vəghwə, ya tsəgha nay ghwəy ciki tsa va ghaslə ghaslə tsəghay, ta baꞌwamti dza məndi, ka dza ghwəy nashi hərezli tsəŋəzli tsəŋəzli ya kwətiŋ ghwəlaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dza ghəshi ki, ka ɗəw va Yesəw, ma kə ghəshi na: «A Metər, geꞌi lə tsama vəghwə dza shi gəzə gha niy məniva tay? Tə wa dza məndiy sənay, ndal tərə shi va ta mənivaw kə məndia? Gəzaŋəy di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma kə Yesəw na: «Məni tə ghwəy məhərli wəzə, əntaa ghwəy dzaa zləɓa məndiy ngəɗiŋwəy ma. Sa nzanay, ɗaŋ dza nihwəti mbəzliy səəkə lə slən tsee. Ka ndə dza na: “Yən na *Kəristəw, a vəghwə səəkəy” kə. Mbaꞌa kə ndə gəzəkəŋwəy tsəghay, əntaa ghwəy dzaa zləɓa kwəma gəla tsava ndə ma. ");
INSERT INTO bcw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma sa ka ghwəy favə gaka mbəz dzar mbə məlməhi, ka zhini ghən mbəzli, kala ɗi ma fəti ta kwəma gəzə mbəzli dikə dikə ni sləkə hiɗiy, əntaa ghwəy dzaa gwərgwərə ma. Ya njaay pərɓa niva shiy dza naa gha manamtəvashi di, ta na hiɗiy, ka dza ghəshiy kərəshi taŋtaŋ ləy hwəm shi vaw. ");
INSERT INTO bcw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ə zhinee gəzaŋwəy, ka hwəhwə tsa nihwəti mbəzli dzay, ka mbəz lə hwəhwə tsa nihwəti. Ka tsahwəti mazə dza na, mbaꞌa pəlati miy tə tsahwəti, tapə ghəshi mbə mbəz ta nza. ");
INSERT INTO bcw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta gərgərə dza hiɗiy dza tərəŋw, nza zəlghwə biyambə tsa dikə tsa shəəkəy mbəzli. Tərəŋw ma dzaa nza tə nihwəti hiɗi ghənghən ghənghən. Ta məniva dza shiy, ka dza her mbəzli və shi tərəŋw, zhini ka tsahwəva shiy cipə kwəma tərəŋw dzəy tə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma ya tsəgha nzə, ka shi va mənivay, ta kəkəsəŋwəy dza məndiy dza, ta saŋwəy ngəraꞌwə. Ka məndi dzay həŋ ɓanavəŋwəy kaa mbəzli dikə dikə ni mbə *ciki ɓasəva tsa ka Zhəwifə ta ɓasə ngwəvəə dzəkən ghwəy. Ka məndi dza na, mbaꞌam kalaghwaŋwəy kwa fərshina. Ka məndi dza diɓay, ka kəkəsəŋwəy dzəghwa kwəma mezhizhə, lə dzəghwa kwəma mbəzli dikə dikə ni tə hiɗi, ta məni ngwəvə. Sa wana dza məndiy saŋwəy ngəraꞌwə tsa va tsəghay, sa nəwra ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma na na ghwəy ghalaɓay, kwal na sava dza ghwəy kwəmavə ta mbə ghwəy ndəgha fəti dzəkənee. ");
INSERT INTO bcw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fambə tə ghwəy kwəma dzee na ta gəzaŋwəy wəzə mbə məhərli ghwəy. Əntaa ghwəy tatasə ghən tsa ghwəy lə tətəkə: “Njaa dza ghəy mənti dza ghəy mbəliŋəya?” pə ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sa nzanay, yən dza naa ndaŋwəy kwəma dza ghwəy gəzə ghalaɓa, lə məhərli sənata kwəma gwaꞌa. Sa ka ghwəy ɓəkəvəri na ghwəy gəzə kwəmay, ka dza ka mbəz ghwəy mbay zləɓakəŋwəy kwəma gar mbaŋwəyəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ya mbəzliy yakəŋwəy, ya ngwarməhiŋwəy, ya madigahiŋwəyəy ta kəəkəsəŋwəy dza mbəzli va gwanashi ta fambəŋwəy mbə dəvə mbəzli dikə dikə ni, ɗaŋ dza məndiy bakwamti nihwəti mbəzli mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mbəzli gwanashiy, ka dza ghəshiy ɗi mətsə ghwəy tə sa nəwra ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ya tsəgha nzə kiy, əntaa ghwəy hazləni ma. Ya səəti mbə ghən ghwəy kwətiŋəy, ka dza naa zataw. ");
INSERT INTO bcw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Va tsəgha, jihəkəvaŋwəyəm wəzə. Ma tsəghay, ta mbəlivə piy tsa ghwəy dza ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Zhəghwa ma kə Yesəw diɓa na: «Ma sa ka ghwəy nata məlmə Zherəwzalem dəzlətsəɓə mbəzli tsəɓay lə shi mbəz və shiy, sənay tə ghwəy ghalaɓa na, ndal tərə məndi ta ngazlamtiw, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ghalaɓa kiy, ma mbəzli tə hiɗi ka Zhəwde na, hwəshi tə ghəshiy dzəmbə kəlaŋ ta mbəə mbəlishi. Mbəzli mbə məlmə Zherəwzaleməy, hwəshi tə ghəshi. Ni dzar kwamtiy, əntaa ghəshi dzaa zhimbə məlmə va ma. ");
INSERT INTO bcw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sa dza naa nza, ma vəghwə tsa vay, vəghwə tsa dza Hyalaa məni ngwəvəə dzəkən mbəzli ti na. Ghalaɓa dza shi tsasliti məndi mbə zliya gwanashiy məniva. ");
INSERT INTO bcw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngəraꞌwə tərəŋw dza savaa nza fəcava kən miꞌi lə hwər lə miꞌi ka ndərazhi tə hwəm. Sa nzanay, tərəŋw dza ngəraꞌwə ta səəkəə dzəti hiɗi. Ta məni ngwəvə dza Hyalaa dzəkən mbəzli mbə məlmə va, sa satiy nəfə tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta bakwamtishi dza *mbəzliy kamaa ka Zhəwifə lə kafaꞌi. Ka ghəshi dza na mbaꞌa ghəshi kakasamtishi, ta nza ghəshi ka mevivi dzar mbə hwəlfəhi mbəzliy kamaa ka Zhəwifə. Ta zləghwəhwə məlmə Zherəwzalem dza ghəshi ka sa shi, paꞌ fəca vici dza Hyalaa ɓəhwə və shi, mbaꞌa ɓanavə kaa nihwəti mbəzli» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ma kə Yesəw diɓa na: «Sa ka hiɗi nza ndəkwə ta kərəy, ta məniva dza shiy cipə kwəma ka pəghəva tə vici, kə pəghəva tə tir, ka pəghəva tə sasərkwəhi gwaꞌa. Tərəŋw dza her hwəlfəhi mbəzli tə hiɗiy dzashi, kala dza ghəshiy sənashi ma shi ka ghəshi məni va gaka yam kwa həl lə va kwəfəghə tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ka shi nza bərci və shi mə ghwəmə ꞌwakəvə na, ka kwəfəghə. Ka mbəzli dzay, ka hazləni, sa ka ghəshi zəzəti kwəmaa dzaa səəkəə dzəkən mbəzli tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ghalaɓa kiy, nza Zəghwə yakə ndə ngəri tsahwə, war ka nay mbəzli lə mətsə shi səəkə mbə kwəleɓi tə ghwəmə, lə bərci və tərəŋw, tsəgha shəndəkə diɓa. ");
INSERT INTO bcw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma sa ka ghwəy nashi gəla shi tsəgha ni va ghati mənivay, heɗeheɗe kə nəfə tsa ghwəy taa nza, mbaꞌa ghwəy jihətəvaŋwəy. Sa nzanay, ndal tərə ghwəy ta mbəliŋwəy ghalaɓaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma ləy hwəm kwəma va na, dzəghwa Yesəw diɓa ka ɓəlanshi fir. Ma kə na: «Nighəvə tə ghwəy daskwa, lə nihwəti fəhi gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","War nashi ma ghwəy ghəshi ghati ɗay. Gwaꞌa ka ghwəy sənay na, a vəghwə tsaa dzəmti kətikəvay, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ava tsəgha na ki, nashi ma ghwəy gəla shi ɓəlakəŋwəy ya va ghati mənivay, sənay tə ghwəy ndal tərmbə Hyala ta səəkə ta sləkə mbəzliw, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A gəzaŋwəy ya, ta na navay, tsəgha na, ka dza mbəzli mbə vəghwə tsa ndatsə tsaa bəkwəshi ka shi gəzaŋwəy ya ni gwanashi mənivaw. ");
INSERT INTO bcw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nay ghwəy na, kar ghwəmə nata ghwəy na ghəshi lə hiɗi gwaꞌay, kərəp dza ghəshiy zashi. Ma na kwəmee na nanzə kiy, ka kərə naw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ma kə Yesəw ɓa na: «Məni tə ghwəy məhərli tərəŋw. Əntaa ghwəy dzaa zlatanavə məhərli ghwəy kaa zəzəmə shiy lə kaa sasa shiy ghipə lə kaa məni mətsə ta mbəə kwəmavə shi tə hiɗi ma. Mbaꞌa pə ghwəy dzaa kəslimbə ghən kən niva shiyəy, vətəghə dza vici dzee vaa səəkə tiy kəsaŋwəy. ");
INSERT INTO bcw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Njasa ka məndi vaa kaghwa kərpi vətəghə dzəghwa zləkwəy, ava tsəgha dzee səəkə vətəghəə dzəkən mbəzli tə hiɗi gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ghənzə tsəgha kiy, əntaa ghwəy ɓə hi ma, ə pə ghwəy cəꞌwə Hyala ya hwəmɓa. Ta mbə ghwəy kwəmavə bərci ta mbəliŋwəy va shiy dza vaa səəkə gwanashi. Ma nza ghwəy mbə kwəmavə garəŋwəy, kwa kwəmee, yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ava tsəgha niy ɓənipə Yesəw shiy havəghwə mbə *ciki Hyala. Ma hetihwer sa ka vərɗiy mənta na, ka dzay ta hi mə kəlaŋ tsa har məndiy kəlaŋ *ꞌWəlivə. ");
INSERT INTO bcw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka mbəzli gwanashiy dza ki na, ka səəkə pəətə mekəshi mekəshi ta fa kwəma gəzə na va kaa mbəzli mbə ciki Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma ghala pətsa va ki na, mbaꞌa vici *makwaghwa Pakə kətikəvata. Mbə makwaghwa vay, kar məndiy zəmə peŋ tsa nza *is mbəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala ghəshi lə *ka ɓənipə kwəma pəhəti Hyala, mbaꞌa ghəshi maɗishi ta pəla kwal tsaa kəsə Yesəw, ta pəəsli ci. Mbə hazləni ghəshi va mbəzli, kala mbə ma ghəshiy kəsə ci. ");
INSERT INTO bcw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dzəghwa *ndə jaka tsa Hyala mbaꞌa dzay dzəmbə nəfə tsa Zhəwdasə, tsa har məndiy Isəkariyətə. Ndə mbə *mbəzli ta səɗa Yesəw va məŋ lə bakə ni. ");
INSERT INTO bcw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dza Zhəwdasə mbaꞌa dzaa kəsashi mbəzli dikə dikə ni mbə ka ta Hyala, ghəshi lə mbəzli dikə dikə ni sləwa ka ndəghwə *ciki Hyala. Dza na mbaꞌa gəzanshi kaa mbəzli va. Njasa dza naa mbay kwəmavə ngati ɗafa ta kəsə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma sa favə mbəzli va kwəma gəzanakəshi Zhəwdasə va na, mbaꞌa ghəshi vəshishi. «Ta ngavəŋa səɗa gha dza ghəy gha kə kwəmavəŋəy kwal tsaa kəsə ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsəgha na, e zləɓavə, kə Zhəwdasə ka dzay. Dza na ka pəla kwal tsaa nga ɗafa ta kəsə Yesəw nja kwa mbəmbə kala dza nihwəti mbəzli gwanashi niy fəti ghən. ");
INSERT INTO bcw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dzəghwa vici makwaghwa ka məndiy zəmə ma peŋ tsa nza *is mbə, mbaꞌa mənta. Ma mbə vici vay, kar məndiy həni zəghwə təmbəkə ta tsə Pakə. ");
INSERT INTO bcw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dza Yesəw daꞌ harvə kar Piyer lə Zhaŋ. Ma kə ngəshi na: «Mbalam a ghwəy dzaa tatəmmə shi dza ghwəmməə zəmə mbə makwaghwa Pakə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma kə kar Piyer ngəci na: «Kwəma ɗi gha ghəy dzaa tatəmmə shi zəmə vaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma kə Yesəw ngəshi na: «Mbalam, ma sa ka ghwəy tsəhəŋwəy mbə məlməy, ta kwəmay dza ghwəy lə ndə, lə tsaghwa yam və. Nza ghwəy nəw dzakə ghi tsa dza naa dza. ");
INSERT INTO bcw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma sa ka ghwəy tsəhəŋwəy kəyɓay, ma nza ghwəy gəzanci kaa ndə ghi tsa va, ma pə ghwəy taa niy: “Metər tsa ghəy ghwənikəŋəy na. A kəy, ndara ciki tsa dza ghəy səəkə ta zəmə shiy lə mbəzli ta səɗee mbə Pakə, kə” pə ghwəy taa ni ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Gəzanakə ma ghwəy tsəghay, ta citəŋwəy ciki dza na dikə mə ghən tsahwəti ciki, gwəma gwəma ghəci. Ava mbəɓa ka ghwəy dzaa tatəmmə shi dza ghwəmməə zəmə mbə Pakə ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsəgha na, kə kar Piyer, mbaꞌa ghəshi maɗishi ka dzashi. Mbaꞌa ghəshi kəsashi shi va gwanashi njasa gəzanakəshi Yesəw va. Mbaꞌa ghəshi tati shi zəmə dza ghəshiy zəmə mbə Pakə. ");
INSERT INTO bcw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ma sa mənta tihwer ki na, dza kar Yesəw lə mbəzli ta səɗa ci mbaꞌa ghəshi səəkəshiy nzəyshi, ka zəmə shiy ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma ghəshi mbə zəmə shi zəmə va, ma kə kaa mbəzli ta səɗa ci va na: «Yən kiy, kwəma jəw səəkee mbə maw zəmə shi zəmə mbə Pakə ni lə ghwəy gwanaŋwəy, ka məndi gha sara ngəraꞌwəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sa gəzaŋwəy ya va tsəghay, ka dzee zhiniy zəhwə shi zəmə mbə Pakə ghwəlaw. War shi ɗi Pakə vaa gəzə cikəvərivashi gwaꞌa gwaꞌa. Ma ghalaɓa kiy, ta zəmə shi zəmə va dzee dza tə pətsa sləkə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma sa gəzəkə na tsəgha na, dza na həŋ ɓəvə hwəpər tsa nza shi sa kwa, kə mbaꞌa mananati ꞌwəsa kaa Hyala. Ma kə kaa mbəzli ta səɗa ci na: «Ndim shi sa ni a ghwəy sa shi. ");
INSERT INTO bcw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa nzana, e gəzaŋwəyəy, ka zhinee sahwə shiy ghwəla kala fəca dza Hyalaa səəkə tə sləkə mbəzliw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Zhini na ləy hwəm kwəma va, həŋ ɓəvə peŋ, dza na, mbaꞌa mananati ꞌwəsa kaa Hyala. Ma sa mananati na ꞌwəsa na, mbaꞌa ngangavəri peŋ tsa vaa ɓanavəshi. Ma kə ngəshi na: «Ava ghənzə na vəghee va zlatee kaa məti tə ghwəy. Tsəgha pə ghwəy taa məni ta zəzəə dzəkən mətee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Zhini na kaa hwəpər tsa nza shi sa kwa, tsəgha ghəci mənti li sa zəməhwə ghəshi shi zəmə. Ma kə na: «Avanashim shi sa niy, ghəshi na yəwən *sla kiri tsa slati Hyala, ta zhiniy jakəva lə mbəzli lə miymiy ya ni shəkəshi tə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ə gəzaŋwəy ya, avanayəm ntsaa ngati ɗafa tə ya mbə zəmə shiy kwa kwakwa tsa kwətiŋ tsa lə ya. ");
INSERT INTO bcw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta na navay, yən yən Zəghwə ndə ngəri nee kiy, ta pəəslitəra dza məndi war njasa tarəkə Hyala vaa dzəkənee. Ə na na nzana nanzə kiy, tərəŋw dza ngəraꞌwəə nza kən ndə nga ɗafa tə ya tsa va» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ghalaɓa tsəgha ki na, dza mbəzli ta səɗa ci ka ɗəɗəw kwa jipə shi, ma kə ghəshi na: «Wa tsaa dza va ta məni gəla nava kwəma mbə ghwəmmə kia? Tsama kia? Tsama kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dza *mbəzli ta səɗa Yesəw, mbaꞌa ghəshi ghavə ngərə ghəpə kwa jipə shi, ta mbəə sənay ntsaa dzaa nza dikə tsa mbə shi. ");
INSERT INTO bcw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mbaꞌa Yesəw favə ghəpə tsa shi va. Ma kə kaa ngəshi na: «Favə ghwəy na, a ghwəmmə sənay mbə məni mazə tsa shi na mezhizhəy dzəkən mbəzli tə hiɗi. Mbəzli dikə dikə niy, a ghəshiy ɗi mbəzli sləwa ghəshi vaa falshi: “Mbəzli wəzə ni nza ghwəy” kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Na na ghwəy na ghwəy kiy, tsəgha dza naa nzaw. Ntsa dikə tsa mbə ghwəyəy, nja ntsa jəw tsa kə taa zhəghəy. Ma ntsaa sləkəŋwəy na, mbaꞌa zhəghəy nja ndə sləni tsa ghwəy. ");
INSERT INTO bcw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tsama ndə gwəra na dikə mbə kar ntsaa nzəyəy dərasə ka ndəghə shi zəmə, ghəshi lə tsaa ɓanci shiy ta zəməshi ghəcia? A ghwəmmə sənay, tsaa nzəyəy va ndə ta zəmə shiyəy, ghəci na sa dikə tsa. Avanay sana kiy, yən na ntsa dikə tsa mbə ghwəy. Ya tsəgha nzee ntsa dikə tsay, ndə ghəraŋwəy sləni zhəghəree. Mən tə ghwəy tsəgha kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ghwəy kiy, war kwasəbee nza ghwəy ya hwəmɓa mbə ngəraꞌwə tsa see tsa. ");
INSERT INTO bcw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yən kwərakwəy ta ndaŋwəy məni mazə dzee, njasa ndara Dirə va məni ci. ");
INSERT INTO bcw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka zəmə shi zəmə, ka sa shi sa dza ghwəy nza kwasəbee tə pətsa kwətiŋ tsa, tə pətsa sləkee. Ka ghwəy dza na das das nzəyŋwəy kwa gəzligəzli mezhizhə, ka sla ngwəvəə dzəkən mbəzli mbə takəhi məŋ lə bakə ni va mbə hwəlfə ka *Izərayel» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ləy hwəm kwəma va, ma kə Yesəw ka Shimaŋw na: «A Shimaŋw, a Shimaŋw, a *ndə jaka tsa Hyala niy ɗəw kwal ta mbə taŋəshamətəŋwəy, njasa ka ndə vaa pəhəkəvəri davəna mbə ha. ");
INSERT INTO bcw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sa nighətee tsəghay dzee, mbaꞌee cəꞌwəti Hyala tə gha əntaa gha zlay nəwra. E sənay, a gha taa zlay nəwra, ma sa ka gha zhakatiŋay, nza gha mətsahanshi bərci kaa nihwəti ngwarməhiŋa mbə nəwra» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma kə Piyer na: «A Ndə sləkəpə, e pəhamtəvara ta zləɓa dza kwasəbə gha, ya paꞌ kwa fərshina, ya paꞌ ka məti kwasəbə gha na nee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma kə Yesəw kaa ngəci na: «A Piyer, ə gəzamtəŋee avanay ndatsə, ka ngələkə gha way, gha zhinti gəzəə dzəkənee: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha mahkan səɗa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Zhəghwa ma kə Yesəw ngəshi na: «Ghala pətsaa niy ghwənaŋwəy ya vay, e niy gəzaŋwəy, əntaa ghwəy ɓə mbəl pas, lə mbəl wə, lə kwekweher ma, pən, niy shaŋashi shiy ghwəy na?» kə. Ma kə ghəshi na: «Awə, niy shaŋashi shiy ghəyəw» kə ghəshi ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zhəghwa, ma kə ngəshi na: «Nana kiy, ntsa nza mbəl pas vəy, ɓəvə tə ghəci sa ci ta dza li. Mbaꞌa kə mbəl wə va ndə na, ka dza ghəci li diɓa. Kala kafaꞌi va ndəy, ə kə dzaa ɗəlamti kwəbaŋ tsa ci ta pa kafaꞌi. ");
INSERT INTO bcw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sa nzana kwəmaa niy tsasliti məndi vaa dzəkənee mbə Zliya Hyala ghala mbəradzəy, war ghənzə mənta na. Ma kə məndi niy niy: “Mbə ka məni rəɗa niy mbərambə məndi” kə məndi niy ni. Tsəgha na, ta na navay, shi tsasliti məndi vaa dzəkənee na ta məniva dza ghəshi tsəgha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma sa favə mbəzli ta səɗa ci va tsəgha, ma kə ghəshi na: «A Ntsaa sləkəŋəy, avanashi kafaꞌihi tikə bakə va ghəy» kə ghəshi. Ma kə Yesəw ngəshi na: «Gwaꞌa ki, wəkə na tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma ləy hwəm kwəma va na, dza Yesəw mbaꞌa maɗiy dzəmə kəlaŋ ꞌWəlivə njasa sənaɓəy na mbə məni ndimndim. Mbaꞌa *mbəzli ta səɗa ci maɗishi kwasəbə kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma sa tsəhəshi ghəshi mə kəlaŋ ki, ma kə Yesəw kaa mbəzli ta səɗa ci va na: «Cəꞌwəm Hyala a ghənzə ndəghwəŋwəy, vantaa *ndə jaka tsa nzə ngaɗambəŋwəy mbə məni *kwəma jikir na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","War sa gəzəkə na tsəgha na, mbaꞌa katantəvay vəgha shi geꞌi geꞌi gar bəzlaghə hakwə ndəə dzəti pətsa nza na va ti li shi. Dzəghwa na ki, tsəfəkwə tsəfəkwəy tə shinin ci, ka cəꞌwə Hyala ghəci, ma kə na: ");
INSERT INTO bcw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«A Di mbaꞌa pə gha zləɓatiy, bashamti ngəraꞌwə tsa va səəkəə dzəkənee. Ma nanzə kiy, a ghənzə məniva war njasa ɗee nə yaw. War kwəmaa təɓaŋa mbə nəfə tsa gha kə taa məniva» kə.  ");
INSERT INTO bcw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ghalaɓa tsəgha ki na, dzəghwa *ndə kwal tsa Hyala mbaꞌa səəkəy mə ghwəmə dzəvəgha ta mətsahanci bərci. ");
INSERT INTO bcw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesəw kiy, mbaꞌa hazləniy va ngəraꞌwə tsa va ka gwərgwərə, sa nzana tsəgha ki na, dza na ka zhiniy mətsəhə cəꞌwə Hyala tərəŋw tərəŋw. Capə capə capə ghaa nay ma ghwətəghwətə və, war ka njəreməə dzəti hiɗi nja miymiy. ");
INSERT INTO bcw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma sa kəramti na cəꞌwə Hyala ki na, dzəghwa na pəlhəm kafəy, mbaꞌa səəkəy dzəvəgha mbəzli ta səɗa ci. Səəkə na na, ghəshi tə hi va dali təkə ngəraꞌwə. ");
INSERT INTO bcw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Səəkə na, mbaꞌa fərghashi. Ma kə ka ngəshi na: «Wa navam ɓəhwə ghwəy hi kia? Satiŋwəyəm, a ghwəy cəꞌwə Hyala a ghənzə ndəghwəŋwəy, vantaa ndə jaka tsa nzə ngaɗambəŋwəy mbə məni kwəma jikir na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","War Yesəw mbə kərni gəzə kwəma vaa səkwa na, giɗəɗə mbəzli səəkəshi. Mbaꞌa Zhəwdasə tsahwəti ndə kwətiŋ mbə *mbəzli ta səɗa Yesəw va məŋ lə bakə ni tə kwəma shi, ka ꞌwanshi kwal. Ma sa səəkəy na na, karə ka dzar dzəvəgha Yesəw, ta səkwə njasa ka ndə vaa səkwə madigay. ");
INSERT INTO bcw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma kə Yesəw kaa ngəci na: «A Zhəwdasə, wa nava səkwəra ghaa nja madigaŋa sa ɗi gha nga ɗafa tə ya yən Zəghwə yakə ndə ngəri kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma sa nashi mbəzli kwasəbə Yesəw shiy dzaa məniva tsəgha, ma kə ghəshi kaa ngəci na: «A Ntsaa sləkəŋəy, zləɓati gha a ghəy kəəslivərishi lə kafaꞌihi ghəy ni na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","War ghwəla tsəgha na, dza tsahwəti kwətiŋ mbə shi pətsə kəsləkəghwa sləmə kwa bəzəmə vəgha ghən ndə ghəra sləni kaa dikə tsa *ka ta Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma kə Yesəw ngəshi ki na: «Ka məni ghwəy tsəgha ma, zlashim» kə. Dza na dap dapata sləmə zal tsa va va, mbaꞌa mbəlanamti sa ci. ");
INSERT INTO bcw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ma sa mbəliti Yesəw ntsa va, ma kə kaa mbəzli dikə dikə ni va mbə *ka ta Hyala, ghəshi lə mbəzli dikə dikə ni ndəghwə *ciki Hyala, mbaꞌa mətikwəkwər na: «A mbəzli ni, tawa səəkə ghwəy ta kəsəra lə kafaꞌihi mbaꞌa ghədemesli njasa nzee ndə ghəli kia? ");
INSERT INTO bcw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Vici va vici va ghwəmmə niy nza lə ghwəy mbə ciki Hyala na, a kar ghwəy kəsəra ghalaɓaw. Sənay tə ghwəy, tsatsa vəghwəy, tsa ghwəy na səəkəy na ta kəsəra, vəghwə tsa dza ntsaa ghəra sləni mbə kwəsliy ci ni ci bərciy səvəri na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ma sa gəzamti Yesəw kwəma va tsəgha na, dza ghəshi tasl ghəshi kəsəti. Ka pəməə dzakə ghi tsa dikə tsa *ka ta Hyala. Ghəshi mbə pəmə na, war ə Piyer nəwshi kərakə kərakə paꞌ kəghi tsa dikə tsa ka ta Hyala va ghəci nəwghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mbaꞌa məndi niy pəhəy ghwə kwa tipə va, tazəl mbəzli ta ghwə va ka bəghəzli. Dza Piyer kwərakwə ki, das nzəyəy mbə shi. ");
INSERT INTO bcw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dza nahwəti mali kwa ghəra sləni kəghi tsa va, mbaꞌa fati mətsə tə Piyer ghəci mənzəy ta ghwə va, war ə ghənzəə nighə. Ma kə kaa mbəzli tiɓa na: «Ma zal tsay, ntsaa nza kwasəbə ntsa va na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dzəghwa Piyer ka vəraslə, a kə na: «Əm, sənay tsava ndee na neyew mali naw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma ləy hwəm jəw ɓa na, dza tsahwəti ndə mbaꞌa nighəvə, ma kə ngəci ɓa na: «Gha kwərakwəy ntsay, ntsa kwasəbə mbəzli va nza gha» kə. Ma kə Piyer ɓa na: «Tiɓaw, na neyey dzar kwasəbə nzee neyew, pən ɓasa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma ləy hwəm sa nzay məndi nza gar tsahi kwətiŋ diɓa na, dza tsahwəti ndə ka gəzə kwəma diɓa, a kə na: «A ntsa nanzə na kataŋ kataŋ nay, kwasəbə ntsa va niy nza na. Sa nzanay, ndə ka Galile na kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma kə Piyer diɓa na: «A zal tsa, sənashi gəla ni ɗi gha ni gəzə shiyee na neyew» kə. War ghwəla Piyer kərni gəzə kwəma va səvəri tə miy ci na, mbaꞌa ngələkə way tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sa way ngələkə ki na, dza Ndə sləkəpə, tərəɗ zhəghəghə kwəma ci dzar kwa Piyer, ka nighə ghəci. Ghalaɓa ki na mbaꞌa Piyer zəzəvə kwəmaa niy gəzanakə Ndə sləkəpə va, ma kə niy ni ngəciy: «Ka ngələkə gha wa ndatsəy gha zhinti gəzə mahkan səɗa gha: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha» kə niy ni kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sa zəzəti Piyer kwəma mənti na va na, dza na pəlhəm satiy, mbaꞌa səvəriy tə ngwəla, ka wahə ghəci tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma Yesəw kwa hwər tipə dikə tsa *ka ta Hyala ki na, dza mbəzliy ndəghwə va, ka sawa, ka dəꞌwə. ");
INSERT INTO bcw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka ghəshiy dza, mbəkwə mbəkway kwəma ci, ka dəꞌwə. Ka ghəshi dza na ka ɗəw və, ma kə ghəshiy ni na: «Ca gəzaŋəy ntsaa ləkəŋa di?» kə ghəshiy ni. ");
INSERT INTO bcw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dzəghwa ghəshi, war ə ghəshi gagay ka tsətsəərə tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma sa kərəy pi ki na, dzəghwa mətikwəkwər mbə ka Zhəwifə ghəshi lə mbəzli dikə dikə ni mbə *ka ta Hyala, mbaꞌa *ka ɓənipə kwəma pəhəti Hyala ɓasə ghəshi ɓasətəvashi. Mbaꞌa ghəshi dzaa pəməkə Yesəw dzəkwa kwəma mbəzliy sləka ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dza ghəshi ka ɗəw kwəma və, ma kə ghəshi ngəci na: «Ə ɗi ghəy gha gəzaŋəy, nda gha na *Kəristəw tsa tivə Hyala» kə ghəshi. Ma kə Yesəw ngəshi na: «Ya ə gəzaŋwəy ya sanay, ka dza ghwəy ni kataŋ na pə ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mbaꞌa pən ni, kadiw e ɗəw kwəma va ghwəy pən ɓa na, a ka zləɓara kwəma ɗəwee va ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ghava na tə ndatsəy, ta nzəy dzee, yən Zəghwə yakə ndə ngəri tə dəvə kwa bəzəmə Hyalaa kwa bərciy sləkə shiy gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma sa favə ghəshi Yesəw gəzəkə tsəgha, ma kə ghəshi gwanashi na: «Zəghwə Hyala nza gha tsəna?» kə ghəshi. Ma kə Yesəw na: «Njasa gəzaŋwəy ya va na, zəghwə nzə nzee» kə. ");
INSERT INTO bcw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma kə ghəshi na: «Wəkə na nava tsəgha, ka ɗi mbəzli ghwəmmə, ta ndəgha fəti ta kwəma mənti na ghwəlaw. A ghwəmmə favə kwəma zləɓakəmmə na lə miy tsa ci, dəꞌwə ghən tsa ghwəmmə ɓasa. Mək na tsəgha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ꞌWakəvə mbəzliy ɓasəshi va gwanashi, takwəs ghəshi satishi ka dzashi lə Yesəw, mbaꞌa ghəshi dzaa pəmanaghə kaa ngwəmna Pilatə. ");
INSERT INTO bcw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma sa tsəhəshi ghəshi na, dza ghəshi ka pəꞌwə kwəma mənti na ka Pilatə ki, ma kə ghəshi na: «Ma ntsay, a ngəɗi na mbəzli ghəy ta zhini ghən. A kə kaa ngəshiy, ka tsəhanci ghən ghwəy kaa mazə tsaa sləkə hiɗi ka *Rəm gwanashi ma, kə. Ma kə mbə gəzə kwəma ci ɓa na: “Yən na *Kəristəw. Yən na mazə” kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma sa gəzəkə ghəshi tsəgha na, dza Pilatə ka ɗəw kwəma va Yesəw, ma kə na: «Mazə tsa *ka Zhəwifə nza gha na ntsa?» kə. Ma kə Yesəw ngəci na: «Njasa gəzə gha va na» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma kə Pilatə kaa mbəzli dikə dikə ni mbə *ka ta Hyala lə mbəzliy ɓasəshi va tə pətsa va gwanashi na: «A mbəzli ni, a na na yay kəsata kwəma jikir nee va ntsa gar ɓanci fəti məndiw» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Zhəghwa mbəzli va mətsəhə, ghəshi mətsahata gəzə kwəma va lə bərci, ma kə ghəshi na: «Ə ɓananshi na zhini ghən kaa mbəzli lə shi ɓənipə na va, səəkə tə hiɗi ka Galile ghati na shi ci va, ka dzar mbə hiɗi ka Zhəwde gwanashi, avanay tsəhəy tikə sana» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma sa favə Pilatə mbəzli va haməykə kwəma hiɗi ka Galile na, dza na ka ɗəw və shi, ma kə na: «Ndə ka Galile na ntsa na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma kə mbəzli ngəci na: «Ndə ka Galile na» kə ghəshi. Ma sa favə Pilatə tsəgha na, dza na mbaꞌa gəzanshi kaa mbəzli a ghəshi pəməghə kaa mazə Erədə. Sa nzanay, ghəci niy məni na mazə tə hiɗi ka Galile. Ghala vəghwə tsa va ki na, tiɓa ghəci niy nza mbə məlmə Zherəwzalem. ");
INSERT INTO bcw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma sa tsəhəshi məndi lə Yesəw kwa kwəma Erədə ki na, mbaꞌa Erədə vəshiy tərəŋw. Sa niy nzana mbəradzəy ghəci niy nza mbə pəla kwal tsaa nay Yesəw, sa ka naa favə kwəma ka məndi gəzəə dzəkən. Ma kwəmaa niy bərkəti na mbə ghən ciy, nay Yesəw ghəci mbə məni kwəma maɗaŋa maɗaŋa na, niy ɗi na. ");
INSERT INTO bcw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dza na ki ka ɗəɗəw kwemer ghəci ɗaŋ ɗaŋ va Yesəw. Kala zləɓa kwəma Yesəw ngəci ya kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma ghala pətsa va na, tiɓa mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *ka ɓənipə kwəma pəhəti Hyala niy nza, war ka pəꞌwə kwəma ghəshi tərəŋw kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dza kar Erədə lə ka sawji ci tapə mbə sawa Yesəw, ka sawa, ka ꞌwəshiy dzəkən. Ghavə ghəshi mbaꞌa ghəshi panakən kwəbaŋ tsa tə dimə. Dza ghəshi mbaꞌa ghəshi pəməghə kaa Pilatə diɓa. ");
INSERT INTO bcw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma kwataŋay ka jaka niy nza kar Pilatə lə Erədə. Ma fəcava na dza nava kwəma, mbaꞌa jakayshi, mbaꞌa ghəshi mənishi ka madigahi tərəŋw ni. ");
INSERT INTO bcw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ma sa pəmanaghəm Yesəw kaa ngwəmna Pilatə ki na, dza na mbaꞌa ɓasəti mbəzli dikə dikə ni mbə *ka ta Hyala lə mbəzli dikə dikə ni, mbaꞌa nihwəti mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma kə ngəshi na: «A ghwəy kəsəkə ntsa, ma pə ghwəyəy: “a ngəɗi na mbəzli ta zhini ghən” pə ghwəy. Dzəghwee kiy, mbaꞌee ɗəwhwə kwəma va və tiɓa kwa kwəma ghwəy. Kəsata fətee və ya kwətiŋ dzar kwa gəla shi gəzəkə ghwəy vaa dzar kaɓaka ciw. ");
INSERT INTO bcw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Zhini tsəgha *Erədə ɓa, shaŋ ta kəsata fəti və. Va tsəgha zhinikəvə na tikə, ma zal tsay, fəti və gar pəəsli məndiw. ");
INSERT INTO bcw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ghənzə tsəghay, ə dzee kəkəɗiti lə ghwəɗa, nzee pəlay a ghəci dzay» kə.  ");
INSERT INTO bcw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ndimndim tsa shiy nzay, səəkəta ma tsə Pakə njasa nza ghəshi va mbə sanay, kwətiŋ ka ngwəmna Pilatəə pəlanayshi ndə mbə mbəzli kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa gəzəkə Pilatə tsəgha na, dza mbaꞌa ghəshi dzəmbəshi mbə zlaŋə kwəma lə bərci gwanashi gwanashi, ma kə ghəshi na: «Pəəsliti ntsa va, a gha pəlayŋəy Barabasə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasə tsa ɗi ghəshi va məndiy pəlanayshiy, ə niy ngaɗambə na mbəzliy dzəmbə zhini ghən, mbaꞌa niy pəəsliti ndə. Va tsəgha niy kəsaghwa məndi kwa fərshina. ");
INSERT INTO bcw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa mawti Pilatə pəlay Yesəw na, zhəghwa na diɓa ka gəzanshi kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma mbəzli va nashi ki na, zləɓa na Pilatə va kwəma ghəshiw. Kə ghəshi ka zlapə zlaŋzlaŋ, ma kə ghəshi na: «Wa daŋwavəgha, daŋwavəgha vəgha tsəm, a ghəci mətiy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma kə Pilatə kaa ngəshi kwa mahkana gəzə kwəma ci ɓa na: «Əy wa na kwəma təvəti ntsa gar dəŋw məndiy dzəvəgha tsəm kia? Nata kwəma yəɗamti nee ya jəw gar pəəsli məndiw. Ə na na dzee dəꞌwəvə lə ghwəɗa nee, nzee pəlay a ghəci dzay» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma sa favə ghəshi Pilatə zləɓanakəshi tsəgha na, zhəghwa ghəshi mətsəhə, ghəshi mətsahata gəzə kwəma zlaŋzlaŋ: «War daŋwə pə gha daŋwavəgha Yesəw tsa va vəgha tsəm» kə ghəshi. Dzəghwa na shi va kwəma tsəgha, mbaꞌa zəhwə na ngwəmna Pilatə kwəma ki. ");
INSERT INTO bcw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dza na mbaꞌa zləɓati mananshi njasa ɗi ghəshi va. ");
INSERT INTO bcw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mbaꞌa ɓanavəshi Yesəw, a ghəshi məni shi ɗi ghəshi va li, kə mbaꞌa pəlanayshi ntsa va ki. Ntsaa niy kəsaghwa məndi va kwa fərshina, sa niy ngaɗambə mbəzli mbə zhini ghən lə sa pəəsliti na ndə. ");
INSERT INTO bcw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma sa ɓanavəshi məndi Yesəw ki na, dza ghəshi ka dzashi li ta daŋwəə dzəvəgha tsəm. Ma ghəshi mbə kwal na, bəgəm ghəshi kwəmay lə tsahwəti ndə, Shimaŋw, kə məndi kaa slən tsa ci, ndə ka Shiren ghəci. Ntsa vay mbə za za ci niy səəkə na kwamti. Sa kwəmay ghəshi li na, dza ka sawji, tasl ghəshi kəsəvə, bərəɗə ghəshi bərɗanakən tsəm tsa dza ghəshi va ta daŋwə Yesəw dzəti, a ghəci ɓə ta nəw Yesəw li. ");
INSERT INTO bcw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dzəghwa ɗaŋ mbəzli ɓasəshi, bəliɗiŋ ghaa nashi ma kwasəbə Yesəw. Mbaꞌa miꞌi kwasəbə diɓa, war ə ghəshiy tihwəni, ka pəəsli ghən tsa shi lə wahə. ");
INSERT INTO bcw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dza Yesəw tərəɗ, zhəghəghə kwəma ci dzar kwa miꞌi va, ma kə kaa ngəshi na: «A miꞌi ka Zherəwzalem, ka wahə ghwəy tə ya na nee ma. Ta tsa ghwəy ghən lə ta ndərazhi ghwəy, pə ghəy wahə! ");
INSERT INTO bcw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sa nzanay, a tsahwəti vəghwə taa səəkə, vəghwə tsa vay, tərəŋw dza ngəraꞌwəə nza mbə. Ma dza məndiy ni ghala vəghwə tsa vay: “Wahə na kən jiŋa maliy yakə ma zəghwə, kala səəkə zəghwə sahwə ꞌwa tə hati nzə sa!” dza məndiy ni. ");
INSERT INTO bcw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma dza mbəzliy ni kaa dəlagwigwi ghalaɓay: “A dəlagwa, ngəzlakənvaŋa kən ghəy” va tsatsa ngəraꞌwə, dza ghəshiy ni. Ma kə ghəshi dzaa ni kaa hwəm pi ɓa na: “A hwəm pi, mbələyŋəy va tsatsa ngəraꞌwə shi” dza ghəshiy ni. ");
INSERT INTO bcw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nighətimam kiy, kwa vəghwə tsa nzana yən tsaa məni shi ɗi Hyala ka sa ngəraꞌwee tsətsə kiy, njaa dza naa nza kən mbəzliy zləɓa ma kwəma Hyala kia?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ghala pətsaa pəmə məndi va Yesəw ta pəəsliy, a məndi niy pəməvə nihwəti zhər bakə ta bəkwəshi kwasəbə Yesəw, sa hwəti niva mbəzli rəɗa tərəŋw na. ");
INSERT INTO bcw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma sa tsəhəshi məndi li shi tə pətsa har məndiy «Gwalgwata», pi nja pa ghən ndə ngəri na, dza ghəshi mbaꞌa ghəshi daŋwavəgha Yesəw vəgha tsəm tiɓa ki. Dzəghwa daŋwə ghəshi daŋwavəgha ka hwə rəɗa bakə ni va, ya wa ndə na tə tsa ci tsəm kwərakwə. Tsahwəti na, tə kwa bəzəmə Yesəw, tsahwəti na, tə kwa zleɓi ci. ");
INSERT INTO bcw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dzəghwa Yesəw ghəci vəgha tsəm tsa va, tapə ta cəꞌwə Hyala ta mbəzliy sanamiy ngəraꞌwə va: «A Di, yaŋ pə gha na gha, pəlashi mbə nəfə tsa gha. Sa nzanay, sənashi shi məni ghəshi ni ghəshiw» kə. Ma sa daŋwamti mbəzli va nashi ki na, mbaꞌa ghəshi tihəhwə kwəbeŋer kən ghən ci kwa jipə shi lə ti dandərɗə. ");
INSERT INTO bcw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbəzliy ɓasəkəvashi nashi kiy, war tiɓa ghəshi ka nighə kwəmaa məniva. Mbəzli dikə dikə ni mbə *ka Zhəwifə na, war kwəma səna ghəshiy gəzanci. Ma kə ghəshi na: «Ndata *Kəristəw tsa, tivə Hyala na kataŋəy, ə kə mbəliti tsa ci ghən njasa mbəlanti na va nihwəti mbəzli ki!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Zhini tsəgha ka sawji gəzanci kwəma səna kwərakwə ɓa, ka sawa. Dza ghəshi kət ghəshi kətəghəvashiy dzəvəgha Yesəw, mbaꞌa ghəshi ɓanavə shi sa ndalakwə niy dzəta miy ci. Ma kə ghəshi na: ");
INSERT INTO bcw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ndata mazə ka Zhəwifə nza gha kataŋəy, ca mbəlanti ghən tsa gha dəꞌwə ghən tsa gha sana di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dzəghwa ghəshi mbaꞌa ghəshi tsasliti shiy tə tsəm tə ghən Yesəw. Ma shi tsasliti ghəshi vay: «Ntsay mazə ka Zhəwifə na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Dzəghwa tsahwəti ndə mbə ka rəɗa bakə ni va daŋwəy məndi vəgha Yesəw mbaꞌa ghavə sawa ci kwərakwə ɓa. Ma kə na: «Ə kama ghaa Kəristəw Ntsa tivə Hyala shəkəna? Ca mbəlanti ghən tsa gha, nza gha mbəlantəŋəy kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma sa gəzəkə tsahwəti ndə rəɗa tsa va kwəma tsəgha, ma kə tsahwəti tsa va kaa ngəci na: «Tawa gəzə gha kwəma tsəgha tay. Ə hazləni ma gha va Hyala ta na. Ghwəm na na ghwəm sənzənvay, ka rəɗa nza ghwəm. Sanay fəti kwətiŋ naa ndammə məndi lə ntsa. ");
INSERT INTO bcw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta na na ghwəməy, kwaakwa na ngəraꞌwə tsa ghwəm tsa, sa nzanay, a ghwəm hwəti rəɗa, va tsəgha sam məndi ngəraꞌwə. Na naci kiy, rəɗa mənti na tiɓa ya jəwəw, war təgəm tsəgha sa na ngəraꞌwə» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma sa gəzamti na kwəma va tsəgha kaa ntsa va ki, ma kə kaa Yesəw na: «A Yesəw, ma na nee neyey, zəzə tə ghaa dzəkənee fəca dza ghaa səəkə ta sləkə mbəzli gha» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma kə Yesəw kaa ngəci na: «Nay gha na, kwa gwaꞌa gəzaŋee, ndatsə ndatsə nay ghwəm dza naa nza lə gha tə pətsa wəzə tsa mə ghwəmə!» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ma sa mənta vici tarə kwa ghən ki na, dzəghwa tərkwəsl pi məniy ya paꞌ kwəmaɓa tə hiɗi gwaꞌa gwaꞌa, paꞌ tsahi mahkan hetihwer na war tsəgha pi. ꞌWakəvə kwəmtə tsa pəhəy məndi ta təhəvəri pətsa mbə *ciki Hyala, bakə mbə sləkwəvərivay. ");
INSERT INTO bcw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dzəghwa Yesəw ki, mbaꞌa gəzəy kwəma zlaŋzlaŋ, ma kə na: «A Didi, avee zlatavəŋa piy tsee mbə dəvə gha» kə. Ma ləy hwəm sa gəzəkə na tsəgha na, mbaꞌa mətiy ki. ");
INSERT INTO bcw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ghala pətsa va na, tiɓa dikə tsa ka sawji bələkwə niy nza, gwaꞌa gwaꞌa nashi shiy mənishi va. Sa nashi na na mbaꞌa dzəmbəy mbə fal Hyala. Ma kə na: «Kataŋ kataŋ niy nza zal tsaa ntsa wəzə tsa» kə. ");
INSERT INTO bcw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mbəzliy niy ɓasəkəvashi va ɗaŋ ni gwanashi ta nighə kwəma dzaa məniva na, mbaꞌa ghəshi nashi shiy mənishi va. Ma sa nashi ghəshi na, dza ghəshi ka dzashiy jighi, ya wa ndə mbə shi na, war lə dəvə miy nəfə ci, sa zhanshi nəfə tsa shi va nava kwəma. ");
INSERT INTO bcw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ghala vəghwə tsa məniva shi va vay, tiɓa niy nza madigahiy Yesəw gwanashiy, vəri kərakə, ghəshi lə miꞌiy niy nəwvə va ghala maɗi na səəkə mbə məlmə Galile. Mbaꞌa ghəshi nashi shiy mənishi va gwanashi. ");
INSERT INTO bcw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A tsahwəti ndə niy nza tiɓa ghala vici vay, Zhezhefə, kə məndi kaa slən tsa ci. Ntsa mbə məlmə Arimate tə hiɗi *ka Zhəwifə ghəci niy nza. Ntsa vay ntsa wəzə tsa, ka nəw kwal Hyala wəzə, niy nza na, mbə ndəghə səəkə tsa Hyala ta sləkə mbəzli ghəci niy nza. Ntsa va diɓay, mbə ka sləka ka Zhəwifə niy nza na. Ghala pətsaa sla mbəzli nza na va mbə shi ngwəvəə dzəkən Yesəwəy, niy zləɓavə kwəmaa niy garəti nihwəti ka sla ngwəvə va na na naciw. Niy zləɓavə shi məni ghəshi va na diɓaw. ");
INSERT INTO bcw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ma sa mətiy Yesəw na, mbaꞌa dzaa kəsay ngwəmna Pilatə ta cəꞌwə kwal tsaa dza ta ɓə mbəri tsa Yesəw ta dza ta lamti. ");
INSERT INTO bcw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mbaꞌa Pilatə ɓanavə kwal. Dza na mbaꞌa dzaa ɓəkəghwa səkwa mə tsəm tsa daŋwavəgha məndi va. Dza na, laŋ ɓəvə, mbaꞌa harambə mbə bahəta wəzə na, mbaꞌa faghwa kwa kwəli niy lati məndi mbə hakwə. Kwəli vay, niy səəkə məndiy lahwə ndə kwa ya kwətiŋəw. ");
INSERT INTO bcw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma ghala vəghwə tsa la na va Yesəwəy, hetihwer fəca vici ka məndiy, gwəmava ta ndəghə *vici dəkəva ka Zhəwifə niy nza na. ");
INSERT INTO bcw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dza miꞌiy niy səəkəshi va kwasəbə Yesəw ghala səəkə tə hiɗi ka Galile, mbaꞌa ghəshi pəhay *Zhezhefə. Mbaꞌa ghəshi nata kwəli Yesəw tə pətsa nza na, lə njasa laghwa Zhezhefə mbəri tsa va kwaɓa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ma sa lamtim mbəri ki na, dza miꞌi va tərəɗ ghəshi zhəghəghəvashiy jighi. Ma sa tsəhəshi ghəshi kəghi na, dza ghəshi mbaꞌa ghəshi pəlati in mbaꞌa wərdi, ta dza ta məsəə dzəti mbəri. Dzəghwa ghəshi fəca vici dəkəva ka Zhəwifə ki, das ghəshi nzəyshi, ka dəkəva njasa gəzəkə kwəma pəhəti *Məyizə. ");
INSERT INTO bcw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma fəca ləwmə dəmasə pəətə mekəshi mekəshi ki na, dza miꞌi va pəlhəm ghəshi maɗishi, mbaꞌa ghəshi ɓəvə shiy niy gwəmanti ghəshi va, ꞌwərdi, mbaꞌa in, ta məsəə dzəti mbəri. Dza ghəshi pəkw ghəshi dzashiy dzəti kwəli Yesəw va. ");
INSERT INTO bcw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma sa sa tsəhəshi ghəshi tsəgha, tsaꞌ kə ghəshi na, kwəli ghwəni ghwəni, kərakə məndi tsəkwəy hərambəzliy niy kalay məndi va kwəli li. ");
INSERT INTO bcw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dza ghəshi təhwə ghəshi dzəmbəshiy dzəmbə kwəli va, njəꞌwə njəꞌwə kə ghəshi na, a nay mbəri tsa Yesəw Ndə sləkəpə ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Raꞌi ghəshi zashi va nava kwəma. War ghəshi hahashi tiɓa tsəgha na, ghavə zhər bakə vətəghə ghəshi tsahwəshi vəgha shi tsəgha, lə kwəbeŋer tezlezl tezlezl ni kən ghən shi, ka mbərə. ");
INSERT INTO bcw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","War sa nashi miꞌi va mbəzli va tsəgha na, mbaꞌa hazləni kəəsəvəshi, nzəŋw nzəŋw nzəŋw ghəshi nzəŋwambə kwəma shi mbə hiɗi gwanashi. Ma kə zhər va ngəshi na: «A miꞌi, tawa pala ghwəy ntsa tə ghwəməy tsa mbə mbəzli bəkwə bəkwə ni shəka? ");
INSERT INTO bcw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ghəci tikə kwa kwəli naw. Aa zhakatiy mbə məti. Zəzəvəm kwəmaa niy gəzaŋwəy na va niy nza, ghəci ghwəlay tə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ma kə niy niy: “Ta ɓanavəra dza məndi, yən Zəghwə yakə ndə ngəri kaa ka məni *kwəma jikir na, ka ghəshi dza na mbaꞌa ghəshi daŋwavəghara vəgha tsəm. Ta mətira dzee dza, ma tə kwa mahkana vicee kwa kwəli kiy, ma nzee zhakatira mbə məti” kə niy ni» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma sa gəzanakəshi zhər va kwəma va tsəgha kaa miꞌi va na, mbaꞌa ghəshi zəzəvə kwəmaa niy gəzanakəshi Yesəw va. ");
INSERT INTO bcw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Dzəghwa mbaꞌa ghəshi ɓarvashi tə kwəli va, ka dzashi. Avanay slən tsa miꞌi va, kar Marəy ka Magədala, Zhanə, mbaꞌa Marəy mbəghəy Zhakə, mbaꞌa nihwəti miꞌiy nza kwasəbə shi, tsəgha niy nza ghəshi. Ma sa ɓarvashi ghəshi tə kwəli va na, dza ghəshi mbaꞌa ghəshi dzaa gəzanshi kwəmaa mənta va gwanata kaa *mbəzli ta səɗa Yesəw va tərmbə məŋ lə taŋ ni, mbaꞌa kaa nihwəti mbəzli gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma sa favə *ka kwal Yesəw va məŋ lə taŋ ni kwəma va na, njasa gəzəkə miꞌi va kwəma kama ghən ti ghəshi favə niva shiy. Kala yə kwəma miꞌi va va ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ya tsəgha nzə ki na, dza Piyer fakatsaꞌwə satiy dəꞌwə ghən tsa ci, dza na bəvbəpə ɓəvə bali, ka dzay dzəti kwəli va. Dzəghwa na ndəs tsəhəy miy kwəli, gələɓ gələɓəy, njəꞌwə nighəti pətsa kwaɓa. War məgapaa niy gapəti məndi mbəri li gwaꞌa tsəgha sa nata na kwaɓa tə hiɗi, kala nay mbəri ghəci. Sa nata na nava kwəma tsəgha na, ꞌwakəvə na tərəɗ zhəghətəvay, mbaꞌa dzay jighi. Tərəŋw nava kwəma mananati maɗaŋa kaa ngəci. ");
INSERT INTO bcw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma fəcavata, fəca dəmasə na, mbaꞌa nihwəti *mbəzli ta səɗa Yesəw bakə maɗishi ta dza ta wə mbə nahwəti məlmə, Emawəsə kə məndi kaa slən tsa nzə. Ma ngwəla kwa jipə məlmə va lə məlmə Zherəwzaleməy, gar kiləwmetər məŋ lə taŋ na. ");
INSERT INTO bcw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma ghəshi mbə kwal na, war ə ghəshiy sla kwəmaa mənta va gwanata. ");
INSERT INTO bcw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma ghəshi mbə sla kwəma shi va tsəgha na, dzəghwa ndəs Yesəw kəsashi. Kə ka dza ghəci li shi kwa zəərə kwətiŋ na. ");
INSERT INTO bcw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mbə nay Yesəw ghəshi nanzə ki na, mbaꞌa shiy makətishi ta sənay ghəshi Yesəw na, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma kə Yesəw ngəshi na: «Wa kwəma sla ghwəy mbə kwal shəka?» kə. Sa gəzəkə Yesəw tsəgha na, ꞌwakəvə mbəzli va tsəgha, ghərəŋ ghəshi ghərəŋəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma kə ntsa har məndiy Kəleyəwpasə ta mbəzli bakə ni va kaa zləɓanci na: «Kwətiŋa nza gha mbə Zherəwzalem, gha gha tsaa sənashi ma shiy mənishi ni mbəɓa ꞌwarꞌwar na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma kə Yesəw ngəshi na: «Wa shiy mənishi baya mbəzlia?» kə. Ma kə ghəshi na: «Ə sənashi ma gha shi mananati məndi va kaa Yesəw, ndə ka Nazaretə shəkəna? Ghəciy, *ndə gəzə kwəma Hyala lə bərci nza na, mbaꞌa mənəhwə shi dikə dikə ni ghənghən ghənghən. Kwəma wəzə na ghənzə tərəŋw. Hyala lə mbəzli gwaꞌay, a ghəshi sənata kwəma va. ");
INSERT INTO bcw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ma sa niy nashi ghəy bərci ci va tsəghay, ghəci na sa ghwənikə Hyala va ta mbəli ka *Izərayel niy nə ghəy. Ma dza *ka ta Hyala ghəy dikə dikə ni, ghəshi lə mbəzli ghəy dikə dikə ni na, mbaꞌa ghəshi kəsəghə dzəghwa kwəma ngwəmna, mbaꞌa ghəshi slanakən ngwəvə məti. Dza ghəshi daŋwə ghəshi daŋwavəgha vəgha tsəm, mbaꞌa ghəshi pəəsliti. Avanta kwa mahkana vici na sana ndatsə ghala mənishi shi va. ");
INSERT INTO bcw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma kwəmaa gwəramti vaa səəvəriŋəy kiy. A nihwəti miꞌi ka ghəy nza li shi kwa zəərə kwətiŋ na li shi kafəshi ndatsə pəətə mekəshi. Mbaꞌa ghəshi tsəhəshi tə kwəli Yesəw va ta nighə. ");
INSERT INTO bcw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma dza ghəshiy, kala kəsay mbəri tsa Yesəw ghəshi kwa kwəli va. Mbaꞌa ghəshi zhəghəkəvashi. Ma kə ghəshi kaa ngəŋəy sa səəkəshi ghəshi na: “A ka kwal Hyala tsahwəshi ghəy miy kwəli va mbaꞌa ghəshi gəzaŋəy, aa zhakatiy mbə məti, mbə piy na, kə ghəshi” kə miꞌi va kaa ngəŋəy. ");
INSERT INTO bcw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma sa favə ghəy tsəgha na, dza nihwəti mbəzli mbə ghəy, mbaꞌa ghəshi dzaa nighəkə kwəli va. Ma dza ghəshi na, war njasa gəzəkə miꞌi va va ghəshi kəsata. Kala nay mbəri tsa Yesəw ghəshi kwaɓa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sa famti Yesəw kwəma shi gwanata ki, ma kə kaa ngəshi na: «Ghwəyəy mbəzli kama məhərli və shi gar fə ghən ta kwəma nza ghwəy. Bakə bakə na nefer ghwəy ta kwəma gəzəkə ka gəzə kwəma Hyala mbə zliya gwanata. ");
INSERT INTO bcw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tsəgha kwəma va niy gəzəta nanzə sa? Ta sahwə ngəraꞌwə dza *Kəristəw Ntsa tivə Hyala, ka shəndəkə gha dzəti, kə məndi niy ni nanzə sa?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dzəghwa na tapə, ta canshi kwəmaa gəzəkəvataa dzəkən mbə Zliya Hyala gwanata. Sa ghati na tə zliyahi *Məyizə ka sar paꞌ tə zliyahi nihwəti ka gəzə kwəma Hyala gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma sa tsəhəshi ghəshi ndəkwə vəgha məlmə Emawəsə na, dza ghəshi vaa dzəmbə na, dza Yesəw mbaꞌa mənti njasa ɗi na dzay kərakə kən shi. ");
INSERT INTO bcw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dzəghwa mbəzli va, mbaꞌa ghəshi tətəꞌwəvə, a ghəci hi. Ma kə ghəshi ngəci na: «Nzəyŋa lə ghəy, sa nzanay, a vici dzata, ndal tərmbə vərɗi ta mənivaw» kə ghəshi. «Tsəgha na» kə Yesəw, mbaꞌa dzakəy dzakə ghi ta nzəy lə shi. ");
INSERT INTO bcw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dza ghəshi das ghəshi nzəyshi ta zəmə shiy, kə Yesəw mbaꞌa ɓəvə peŋ, mbaꞌa mənti ꞌwəsa kaa Hyala. Dza na mbaꞌa ngangavəri mbaꞌa ɓanavəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","War sa ɓanavəshi na peŋ tsa va tsəgha na, mbaꞌa məhərli shi ghwənita. Kar ghəshi sənay na, Yesəw na sasa, kə ghəshi. Dza Yesəw ki mbaꞌa zanavəshi za tiɓa. ");
INSERT INTO bcw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tapə ghəshi ta gəgəzə kwəma kwa jipə shi, ma kə ghəshi na: «Ghala sa gəzam na va kwəma ka cim kwəma mbə zliya kwa kwal na, paf nefer ghwəm niy nza va vəshi sa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dza ghəshi nzaꞌjəw ghəshi maɗishi tsəgha, ka zhəghəvaa zhəmbə Zherəwzalem. Dza ndəs ghəshi tsəhəshi, mbaꞌa ghəshi kəsashi mbəzli ta səɗa Yesəw va məŋ lə taŋ ni ɓasə ɓasə lə nihwəti mbəzli kwasəbə shi. ");
INSERT INTO bcw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma kə mbəzliy ɓasəshi va kaa mbəzli bakə ni va tsəhəshi vəgha shi na: «A mbəzli ghəy ni, kataŋ kataŋ zhakatiy Ndə sləkəpə mbə məti. A Shimaŋw nay lə mətsə ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dzəghwa, ni bakə ni va mbəzli tapə ta gəzanshi shiy mənishi li shi, ma kə ghəshi na: «Ma ghəy mbə dzaa dzəmbə məlmə Emawəsəy, a ghəy kwəmay lə Yesəw kwa kwaləy, kalaa niy sənay ghəy. Ma hetihwer sa təhavəŋəy na peŋəy, mbaꞌa ghəy sənay ghalaɓa ki» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","War ghwəla mbəzli bakə ni va mbə gəgəzə kwəma va tsəgha na, ꞌwakəvə Yesəw dəꞌwə ghən tsa ci tsəgha, tsahwə tsahwəy kwa jipə tsa shi. Ma kə kaa ngəshi na: «Nzəyəy zərkə lə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dzəghwa mbəzli gwanashi ka gwərgwərə va hazləni, «Ndəɓa məcakwə ndə dzanakənshi na dza» a kə ghən tsa shi. ");
INSERT INTO bcw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma kə Yesəw kaa ngəshi ki na: «Wa shiy mənishi hazləniŋwəy ghwəy shəka? Wa nava mənti ghwəy nefer ghwəy bakə bakə tsəgha nanzəa? ");
INSERT INTO bcw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Waa yən na, cam nighətimam dividivee lə shiɗshiɗee gwaꞌa. Cam daparam tə vəghee nza ghwəy mbəə sənay məcakwə ndə nza yaw pə ghwəy. Sa nzanay, ya ꞌyesler, ya sliw na ghəshi mbə məcakwəw. Na nee kiy, a shi va mbə ya» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ma ghəci mbə gəzanshi kwəma va na, dza na mbaꞌa cintishi dividivi ci lə shiɗshiɗ ci. ");
INSERT INTO bcw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dza mbəzli va ka vəshi tərəŋw tərəŋw. Ka mananshi maɗaŋa nava kwəma tərəŋw. Kala mbə ghəshiy zləɓavə gəla nava kwəma di. Ma sa nighəti Yesəw tsəgha, ma kə ngəshi na: «Shi zəmə va ghwəy tikə ta na?» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dza mbəzli va mbaꞌa ghəshi ɓanakə kəlipə səli səli na. ");
INSERT INTO bcw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dza Yesəw laŋ ɓəvə, mbaꞌa zəməhwə tiɓa kwa kwəma shi. ");
INSERT INTO bcw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma kə kaa ngəshi na: «Ghala vəghwə tsaa niy nzee kwa jipə ghwəy diy, e niy gəzamtəŋwəy, shi tsasliti məndi vaa dzəkənee mbə zliya *Məyizə, lə mbə zliya ka gəzə kwəma Hyala, mbaꞌa mbə zliya cəməy, ya njaaɓay, cəkeꞌ dza ghəshiy mənishi lə ya, pən niy ni ka ngəŋwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dza na ki, mbaꞌa kəətitishi nza məhərli shi mbəə ghwənita ta mbə ghəshiy sənashi shiy tsaslishi mbə Zliya Hyala. ");
INSERT INTO bcw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma kə ngəshi na: «Avantam kwəma tsasliti məndiy dzəkənee: Ya njaaɓay ta sa ngəraꞌwə dza *Kəristəw Ntsa tivə Hyala, ka mətiy. Ma tə kwa mahkana viciy, nza zhakatiy mbə məti. ");
INSERT INTO bcw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Diɓa kiy, ta gəzə Yəwən kwəma wəzə na dza məndi kaa hwəlfə mbəzli ghənghən ghənghən gwaꞌa tikə tə hiɗi. Tawa dza məndiy gəzanshiy, nza ghəshi mbəə zhəghanti nzəy tsa shi. Ma nza Hyala pəlatanashi kwəma shi jikir na mbə slən tsa ci. Ma nəwər tsa vay, mbə məlmə Zherəwzalem dza məndiy gha gəzə, ka nəw paꞌ tə pətsa kəray hiɗi, kə məndi. ");
INSERT INTO bcw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ava ghwəy na ka ndəgha fətiy dzəkən shi va kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sa kee dzay, mbaꞌee ghwənikəvəŋwəy *Safə tsa Hyala va niy gəzəkəŋwəy Dirə ɓəŋwəy. Ma nana diy, nzəyŋwəyəm mbə məlmə Zherəwzalem, paꞌ fəca dza Hyalaa ghwənikəŋwəy Safə tsa nzə, nza ghwəy kwəmavə bərci ta gəzə kwəmee kaa mbəzli» kə. ");
INSERT INTO bcw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma sa gəzanamtishi Yesəw kwəma va tsəgha *kaa mbəzli ta səɗa ci va na, dza na pəm pəməkəvərishi mbə məlmə va, mbaꞌa dzay li shi ndəkwə dzəvəgha məlmə Betani. Ma sa tsəhəshi ghəshi tiɓa na, mbaꞌa Yesəw kafashi dividivi ci mbaꞌa təfanatishi miy. ");
INSERT INTO bcw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma ghəci mbə təfanshi miy tsa va na, dza na mbaꞌa təhəvərivay li shi, mbaꞌa Hyala ɓəhwəə dzəmə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dzəghwa ghəshi nashi ki na, ka fal Hyala ghəshi mbaꞌa ghəshi maɗishi ka zhashiy zhəmbə məlmə Zherəwzalem lə vəshi mbə nefer shi tərəŋw tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ya hwəmɓa na, war ka ɓasəva ghəshiy nza mbə *ciki Hyala, ka fal Hyala. Ava tsəgha na Yəwən kwəma wəzə naa dzəkən Yesəw *Kəristəw njasa tsasliti Ləwka ki.");
INSERT INTO bcw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ghala kwataŋata, Hyala ghwəla ta nga shi tə hiɗi lə shi mə ghwəmə gwaꞌay, ntsa har məndiy «Kwəma gəzə Hyala» tiɓa. «Kwəma gəzə Hyala» vay, ghəshi niy nza na lə Hyala, niy təhəvərivashi ghəshiw. «Kwəma gəzə Hyala» va na, Hyala va ghənzə. ");
INSERT INTO bcw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma «Kwəma gəzə Hyala» va kiy, ghəshi niy nza na lə Hyala ghala kwataŋata. ");
INSERT INTO bcw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ya wa shi ngati Hyala gwaꞌay, war lə Kwəma va ngatishi na. Tsahwəti sə tiɓa ya kwətiŋ, mbaꞌa mənəy kala lə Kwəma vaw. ");
INSERT INTO bcw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","«Kwəma gəzə Hyala» va kiy, səəkə mbə səəkə piy. Dza piy tsa va, ka mbərə ka mənipə waŋ pi, ta mbə mbəzli tə hiɗiy sənata kwəma kataŋ na. ");
INSERT INTO bcw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma waŋ pi tsa va ki na, ka mbərə, ka mənipə waŋ pi mbə kwəsli, kala mbay kwəsliy shərkwamti ya jəw nzə. ");
INSERT INTO bcw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mbaꞌa Hyala ghwənikə tsahwəti ndə, Zhaŋ, kə məndi slən tsa ci, ta nza ghəciy ndə kwal tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ghəci na ntsaa səəkəy ta cipə kwəma kən kwəma waŋ pi tsa va. Ma nza məndi favə kwəma kən, nza məndi mbəə zləɓavə gwanashi ki. ");
INSERT INTO bcw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma na Zhaŋ naciy, ghəci na waŋ pi tsa vaw. A səəkəy na ta ndəgha fətiy dzəkən kwəma kən waŋ pi tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma ntsa nza slən tsa ci vaa «Kwəma gəzə Hyala» kiy, ghəci naa mbərə waŋ pi tsa kataŋ kataŋ tsa. Mbaꞌa səəkəy dzəti hiɗi tikə, dzəghwa ka mbərə kaa nefer mbəzli gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","«Kwəma gəzə Hyala» vay, tiɓa niy nza na tə hiɗi, lə kwəma nzə va ngati Hyala shi ngati na tə hiɗi gwanashi. Ma na ntsa tə hiɗi naci ki na, sənivə kwəma va naw. ");
INSERT INTO bcw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mbaꞌa «Kwəma gəzə Hyala» va səkwata mbaꞌa nzəyta tə hiɗi nzə. Ma dza mbəzli nzə na, kala zləɓati kaꞌwəvə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma nihwəti mbəzli na, mbaꞌa ghəshi kaꞌwəvə, ka ɓanavə nefer shi. Dzəghwa na kaa niy ɓanavə nefer shi va, mbaꞌa ɓanavəshi bərci ta mbə ghəshiy mənishi ka ndərazhi Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nza tsa nza ghəshi va ka ndərazhi Hyala ɓa na, tə sa yakəshi məndi njasa ka məndi vaa yapə kwa hwər naw, tə sa ɗi ndə ngəri na ɓaw, əhəŋ, sa nzana, mbaꞌa Hyala ɓanavəshi piy tsa ꞌwarꞌwar tsa na. ");
INSERT INTO bcw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma dza «Kwəma gəzə Hyala» va kiy, mbaꞌa zhəghəta ka ndə, lə vəgha ti, mbaꞌa səəkətaa nzəyta mbə ghwəmmə. Mbaꞌa ghəy nay dikə tsa məni na, ma dikə tsa nzə va na, nja dikə tsa ka Didi vaa fanati kaa zəkwəti zəghwə ci ghəci kwətiŋəy və. Ava tə kwəma nzə va sənay ghwəmmə nza tsa nza Hyala ka ntsa wəzə hwər tsa, lə ka ntsa slar tsa ki. ");
INSERT INTO bcw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dzəghwa Zhaŋ tsaa məni *batem ki, ka gəzəpə kwəmaa dzəkən ntsa va zlaŋzlaŋ njasa nza na, ma kə na: «A ghwəy niy favə yən gəzəŋwəy kwəmaa dzəkən ndə ɓay, ava ghəci na ntsa va ki, saa niy nə ya va: “A ndə tiɓa taa səəkə lə hwəm yay, a ntsa va taŋətəra tə dikə. Sa nzana, ghəci na naciy, ghala məndi ghwəla ta yara na tiɓa” pən niy ni» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ghwəmmə gwanamməy, a ghwəmmə kwəmavə bəla mbə shi sləkə na gwanashi, sa nzana, mbə təfəmmə miy tsa nzə ghənzə ghənghən ghənghən həzlimə həzlimə. ");
INSERT INTO bcw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwataŋa kiy, a Hyala niy pəhəti kwəma ta nəw məndi, mbaꞌa niy ɓanavə kaa *Məyizə ta ɓəmmə. Ma kwəma wəzə hwər tsa Hyala tə ghwəmmə, lə kwəma nzə kataŋ na kiy, lə Yesəw *Kəristəw kwəmavə ghwəmmə. ");
INSERT INTO bcw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","A ghwəmmə sənay, tsahwəti ndə tiɓa mbaꞌa səəkəə nata Hyala njasa nza na tepəw. Zəghwə nzə va, zəkwəti tsa va, saa niy nza va ka ntsa kwətiŋ tsa ghəshi lə Dəy kiy, ghəci citəmmə na njasa nza Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ma dza mbəzli dikə dikə ni mbə hwəlfə *ka Zhəwifə mbə məlmə Zherəwzalem na, mbaꞌa ghəshi ghwənashi mbəzli mbə *ka ta Hyala ghəshi lə mbəzli Levi, ta dzaa ɗəw kwəma va Zhaŋ, a kə ghəshi taa ni na: «A Zhaŋ, a kə məndiy: “Wa ndə nza gha na ghaa?” kə məndi» kə ghəshi taa ni. ");
INSERT INTO bcw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Sa tsəhəshi ghəshi, mbaꞌa ghəshi ɗəwti kwəma va tsəgha ki, ma kə Zhaŋ naci kaa zləɓanshi, kala mbə maa dzəkən na: «Ma na nee yən Zhaŋəy, yən na *Kəristəw Ntsa tivə Hyala na neyew» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma kə ghəshi ngəci ki na: «Əy wa ndə nza gha na gha kia? *Eli na?» kə ghəshi. «Əm, əhəŋ, ghəci nzeyew» kə. «Ndə Hyala tsa ndəghə ghəy va nza gha na?» kə ghəshi. «Wa awə ɓaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma kə ghəshi ki na: «War wa ndə nza gha nə gha nana kia? Gəzaŋəy, ta mbə ghəy dzaa zhananshi kaa mbəzliy ghwənaŋəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma kə Zhaŋ ki na: «Favə tə ghwəy, yənəy, yən na ntsaa gaka va mbə gamba, njasa niy gəzəkə ndə Hyala *Ezay va, niy nə na: Ava məli ndəə gaka mbə zlapə mbə gamba, a kəy: “Zanamtim kwal tsa dza Ndə sləkəpəə dza kwa bəŋw wəzə wəzə, ka gəŋəti tiɗiɗ” kə, kə niy ni» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mbaꞌa nihwəti *ka Farisahi mbə mbəzli ghwənikə məndi va ta ɗəw kwəma va Zhaŋ ki. ");
INSERT INTO bcw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ma kə ghəshi na: «Ya sa nzana, nza ghaa Kəristəwəw, a nza ghaa Eliw, zhini nza gha ka Ndə Hyala tsa ndəghə ghəy ɓa kiwəy, war njaa njaa mananshi gha *batem kaa mbəzlia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma kə Zhaŋ kaa zləɓanshi na: «Yən ta na tsee ghənəy, batem tsa məniŋwəyee tsa na, kwataka lə yam gwaꞌa tsəgha məniŋwəyee. A tsahwəti ndə tiɓa, mbə ghwəy ghəci na, kala sənay ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ma ghəci na naci kiy, ləy hwəmee dza naa səəkə. Daw nzee ta pəli ya kwataka yiɗi mbə kwakwahə tsa mbə səɗa ci» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma shi va gwanashi kiy, pəriɓa tə miy həl Zhərdeŋ geꞌi lə məlmə Betani, tə pətsa məni Zhaŋ batem məniva ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ma way pi tə həzlimə ki na, mbaꞌa Zhaŋ nay Yesəw ghəci mbə səəkəə dzəvəgha. Ma kə war sa nay na tsəgha na: «Ava ghwəy nay *Zəghwə təmbəkə tsa Hyala, ghəci dza na ta ɓanti kwəmashi jikir na kən mbəzli tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ghəci na ntsaa niy gəzəŋwəy ya va kwəma ci niy nə ya: “A ndə tiɓa taa səəkə ləy hwəm yay, aa dzaa taŋətəra tə dikə. Sa nzanay, ghəci na naciy, ghala məndi ghwəla ta yara na tiɓa” pən niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yən yən Zhaŋəy, niy sənay ya diɓaw. War a səəkəree ta məni *batem lə yam kaa hwəlfə ka *Izərayel, ta mbə ghəshiy sənay ntsa va gwaꞌa tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","A kə Zhaŋ diɓa na: «Mbaꞌee nay *Safə tsa Hyalaa səəkə mə ghwəmə nja ghərpəpə, ka səkwaa paꞌwəə dzəkən ntsa va ki. ");
INSERT INTO bcw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kwataŋay, niy sənay yaw. Mbaꞌa Hyala ghənzə saa ghwənara va ta məni batem niy gəzara, a kə niy niy: “A Zhaŋ, ma ta nza, sa ka gha nay Safə tsee səkwa mə ghwəmə, ka səəkəə paꞌwəə dzəkən tsahwəti ndəy, ava ntsa va dza naa məniŋwəy batem lə Safə tsee ɗewɗew tsa” kə Hyala niy ni ngəra. ");
INSERT INTO bcw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dzəghwa sa nay ya tsəgha ki na, mbaꞌee garəɗa tə kwəma va lə bərci kataŋ kataŋ, ava war ghəci na Zəghwə Hyala ki, pən» kə Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma way pi tə həzlimə kiy, mbaꞌa kar Zhaŋ ghəshi lə nihwəti mbəzli ta səɗa ci bakə tə pətsa va diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mbaꞌa Yesəw səəkəy kwərakwə ki, ka dzar ghəci vəgha shi. Ma sa nay Zhaŋ Yesəw dzar vəgha shi ki, ma kə na: «Ava ghwəy nay *Zəghwə təmbəkə tsa Hyala va» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sa favə mbəzli ta səɗa ci va bakə ni kwəma gəzəkə na va na, mbaꞌa ghəshi kafəshi ka nəw Yesəw tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tərəɗ kə Yesəw na, mbəzli ta səɗa Zhaŋ va bakə ni mbə nəw. Tapə ghəci ta ɗəw kwəma və shi, a kə na: «A mbəzli ni, a shi pəla ghwəy shəka?» kə. Ma kə ghəshi na: «A Rabi, kwəma nza gha lə nzəy tsa ghaa?» kə ghəshi. (Ma ɗi slən Rabi tsa va gəzəy «Metər».) ");
INSERT INTO bcw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma kə ki na: «Ndim, səəkəm a ghwəy nay!» kə. Mbaꞌa ghəshi kafəshi, mbaꞌa ghəshi dzaa nay pətsa nza na ti. Ma ghala pətsa va na, vici geꞌi geꞌi lə səəkə tsa mbəzli kwamti. Pəkw va hetihwer ghəshi li. ");
INSERT INTO bcw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tsahwəti mbə mbəzli bakə ni va favə kwəma gəzə Zhaŋ niy nəwvə Yesəwəy, Andəre, zəmbəghəy Shimaŋw Piyer niy nza na. ");
INSERT INTO bcw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma sa dzashi ghəshi ki na, dza Andəre mbaꞌa ghəshi ꞌwa kwəmay lə zəmbəghəy Shimaŋw Piyer di. A kə ngəci sa kwəmay ghəshi na: «A Shimaŋw, a ghəy kəsay ntsa har məndi vaa Meshi» kə. (Ma ɗi slən Meshi tsa va gəzəy *Kəristəw Ntsa tivə Hyala.) ");
INSERT INTO bcw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dza na pəm pəməghə zəmbəghəy tsa va kaa Yesəw. Sa tsəhəshi ghəshi na, dza Yesəw ka nighə Shimaŋw, ma kə kaa ngəci na: «Shimaŋw zəghwə Zhaŋ nza gha ɓay, dzaa nza kwa kwəmay, Kefasə, dza məndiy ni kaa slən tsa gha» kə. (Ma ɗi slən Kefasə tsa va gəzəy, Kəlɓa.) ");
INSERT INTO bcw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ma tə həzlimə ki na, mbaꞌa Yesəw maɗiy ta zhəghəvaa zhəti hiɗi ka Galile. Dza mbaꞌa ghəshi kwəmay lə tsahwəti ndə, Fəlipə, kə məndi slən tsa ci. Ma kə kaa ngəci na: «A Fəlipə, nəwra dzam!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ma Fəlipə tsa va kiy, ntsa mbə məlmə Betəsayda niy nza na, mbə məlmə kwətiŋ na ghəshi lə kar Andəre lə zəmbəghəy Piyer. ");
INSERT INTO bcw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ləy hwəm jəw ki na, mbaꞌa kar Fəlipə kwəmay ghəshi lə Natanayel kwərakwə. A kə ngəci na: «A Natanayel, a ghəy kəsay Ntsa gəzə *Məyizə va kwəmaa dzəkən kwəma ci mbə zliya *kwəma pəhəti Hyala, zhini tsəgha nihwəti mbəzli ka Hyala gəzəpə kwəmaa dzəkən kwəma ci diɓa. Ma ntsa vay, Yesəw zəghwə *Zhezhefə, ndə ka Nazaretə na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma kə Natanayel na: «Mbə məlmə ka Nazaretə na, ka nza shi wəzə ni tsahwəshi tsəgha kiy?» kə. Ma kə Fəlipə na: «E yaŋ, ndi nighəti na gha ɓa shi!» kə. Əŋkwa kə, mbaꞌa maɗiy ta dzaa nighəti. ");
INSERT INTO bcw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ma sa nay Yesəw Natanayel mbə sar dzəvəgha na, tapə ghəci ta gəzə kwəmaa dzəkən, a kə na: «Ava ndə ka *Izərayel tsa karkar tsaa sar. Məni kwəma gwəfə gwəfə na mbə nəfə ciw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dza Natanayel ka ɗəw və, a kə na: «Njaa gha ghaa sənara shəkara ntsa?» kə. Ma kə Yesəw na: «Ghala pətsaa nza gha va ta daskwa, Fəlipə ghwəla ta harŋay, cəkeꞌ niy naŋee» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma kə Natanayel ki na: «A Metər, waa ni yaw, gha na Zəghwə Hyala! Gha na mazə tsa hwəlfə ka *Izərayel!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma kə Yesəw na: «War tə sa nə ya ngəŋa: “Ya ghala pətsaa nza gha va ta daskway cəkeꞌ naŋee” pən na, mbaꞌa gha zləɓavə kwəmee na. Ghwəla gha ta nashi niy dzaa taŋamti nini shiy tə dikə diɓa sa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zhini ma kə ɓa na: «Nay ghwəy tsəy, ə gəzaŋwəy ya, ta na navay, tsəgha na, ta nata ghwəmə dza ghwəy ghwənita, ka ghwəy nighəy, ka kwal Hyala ka dzəmə, ka səkwa, ka dzəmə, ka səkwaa dzəkənee, yən Zəghwə yakə ndə ngəri» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ma sa mənta vici mahkan ləy hwəm nava kwəma ki na, mbaꞌa məndi harashi mbəzli ta zəmə shiy mbə pəhə makwa mbə məlmə Kana tə hiɗi ka Galile. Mbaꞌa mbəghəy Yesəw tiɓa kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Dza mbaꞌa məndi harashi kar Yesəw lə *mbəzli ta səɗa ci ta zəmə shi va. ");
INSERT INTO bcw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma ghəshi mbə sa shiy na, mbaꞌa shi sa kəɗishi. Ma sa nay mbəghəy Yesəw shi sa va kəɗishi tsəgha, a kə na: «A zəghwee, gwaꞌa na shi sa və shi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma kə Yesəw na: «A mə, wa kwəma gha na mbə kwəmee tay, səəkəy tsee vəghwə nee diw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma kə mbəghəy kaa mbəzliy ghəra sləni va mbə zəmə shi va ki na: «A mbəzli ni, ya wa kwəma dza naa gəzaŋwəy gwaꞌay, məni tə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dzəghwa mbaꞌa ceꞌwer niy nza tiɓa kwaŋ, nja tsəham nja tsəham, shi ka mbəzli *ka Zhəwifəə ga yam dzəti shi ta gaꞌwəva li shi, ta nza ɗewɗew njasa ka ghəshiy məni mbə kwəma jiji shi ndimndim. Ma dikə dikə tsa ceꞌwer vay, kwətiŋ tsa ci na, kar naa ɓəhwə yam gar ləytər dəghəsə mətsəkə, tsahwəti na gar bələkwə bakə mətsəkə ghən kən. ");
INSERT INTO bcw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma kə Yesəw kaa mbəzliy ghəra sləni mbə zəmə shi va ki na: «A mbəzli ni, gatim yam pəyaꞌ pəyaꞌ tə deghwer va diɓiy» kə. Dza mbaꞌa məndi gatishi. ");
INSERT INTO bcw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma kə sa gamtishi məndi ki na: «Nana kiy tishim, a ghwəy ɓanshi kaa ntsaa nighəə dzəkən zəmə shiy ki» kə. Dza mbaꞌa məndi ɓanavəshi njasa gəzəkə na va. ");
INSERT INTO bcw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dzəghwa ntsa va ki, gwərətə, hwətəmiyshi. Fa na na, ka shi sa wəzə ni ghəshi, a sənay tə pətsa səəkə ghəshiw, war mbəzliy ghəra sləni va gati yam va shiy sənata kwəma va gwaꞌa tsəgha. ꞌWakəvə ntsa va daꞌ harvə zal makwa tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma kə ngəci na: «Ni wəzə ni shi saa gwəramti ꞌyaghwakə ni ka məndiy ꞌwa ɓanshi kaa mbəzli harvə məndi ta zəmə gəzləɓə, dza sa ka ghəshiy ghyamtəvashi ki na, ma ka nza məndi ɓanshi, ya ni ndalakwə ni nza. Mbalaa a gha mbələy shiy gwəramti ꞌyaghwakə ghala məcana pəkw nana na gha ki na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ava tsəgha mənta kwa taŋa kwəma maɗaŋa gha Yesəw məni, mbə məlmə Kana tə hiɗi ka Galile. Mbaꞌa cinti kaa mbəzli ta səɗa ci njasa nza dikə tsa məni na tsəgha ki. Mbaꞌa ghəshi zləɓati kwəma ci. ");
INSERT INTO bcw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dzəghwa ghəshi ləy hwəm kwəma va, ghəshi lə kar mbəghəy lə ngwarməhiy, lə mbəzli ta səɗa ci gwaꞌa, ka dzashiy dzəmbə məlmə Kapernahwəm, mbaꞌa ghəshi nzəyshi mbə gar vici jəwə. ");
INSERT INTO bcw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma vici *makwaghwa Pakə ka Zhəwifə ndəkwə ndəkwə na, mbaꞌa Yesəw maɗiy dzəmbə məlmə Zherəwzalem. ");
INSERT INTO bcw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sa tsəhəy na na, mbaꞌa dzəmbəy mbə ciki Hyala. Ma dzəmbə na na, mbəzliy ɗəɗəl shiy mbəɓa. Ka ɗəl slay, lə teŋkesli, lə kwəkwər palayhi. Mbaꞌa ka mbəərə gəna mbəɓa mənzəy mənzəy kwa kwəma tebeler shi diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ꞌWakəvə na tsəgha kaa zhiꞌwəꞌwə mbaꞌa jakətishiy mbərətishi bəlbəl, nja kwərəpə. Mbaꞌa dzəmbəy mbə shi, ka tihəshiy səvəri lə shi shi va gwaꞌa, kar teŋkesli, lə slay shi, mbaꞌa kikihwəvəri gəna shi va, ka dzədzəpati tebelerhi shi va tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma kə kaa mbəzliy ɗəl kwəkwər palay va na: «Katamtim shi ghwəy va tə pətsa va, ka zhəghəra ciki tsa Dirə tsa ghwəy ka ciki ka zhəghə dəvə ma» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dzəghwa kwəma va, mbaꞌa ɓanavəshi zəzə kwəma kaa mbəzli ta səɗa ciy dzəkən kwəmaa tsaslita va mbə Zliya Hyala, saa ni va: «A Hyala, tərəŋwɗa ɗitee ghi tsa gha tsa gar mətira ti» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma sa nay mbəzli dikə dikə ni mbə *ka Zhəwifə Yesəw tihə mbəzli ki, ma kə ghəshi ngəci na: «A Yesəw, a kwəma maɗaŋa dza ghaa mənti, ta mbə ghəy sənay, kataŋəy, a Hyala ndaŋa kwal ta məni tsəgha, pə ghəya?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma kə Yesəw na: «Ghənzə tsəghay, ngəzla pə ghwəy ngəzlamti ciki Hyala tsa, a ghwəy nay ma yən zhiniy ngakati war tsəgha mbə vici mahkan» kə. ");
INSERT INTO bcw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma kə ka Zhəwifə na: «Piya faɗə mətsəkə kwaŋti məndi mənti mbə nga ciki tsa na, ma gha na, war gwaꞌa gha taa ngakati mbə vici mahkanta na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma na Yesəwəy, vəgha ci na sa ɓəti na va nja ciki Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma ləy hwəm sa pəəsliti məndi Yesəw, mbaꞌa zhakatiy mbə məti ləy hwəm vici mahkan ki na, dza mbəzli ta səɗa ci mbaꞌa ghəshi maɗiy zəzəvə kwəma va njasa niy gəzanakəshi na va. Dzəghwa mbaꞌa ghəshi zləɓavə kwəma tsatsasliti məndi mbə Zliya Hyala lə kwemerəy niy gazanshi Yesəw ngəshi gwaꞌa, ka shi kataŋ ni ki. ");
INSERT INTO bcw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma Yesəw mbə məlmə Zherəwzalem, geꞌi lə *makwaghwa Pakə na, mbaꞌa mbəzli ɗaŋ tərəŋw nata kwəma maɗaŋa mənti na, mbaꞌa nefer shi hənishi ta kwəma ci. ");
INSERT INTO bcw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma Yesəw naci ki na, ɓanavəshi nəfə tsa ci na, sa nzana gwaꞌa gwaꞌa ghəci niy sənashi gwanashiw. ");
INSERT INTO bcw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Diɓa na, ɗi tsahwəti ndə na ta canci kwəma təkə ndə ngəri mbə nəfə tsa ciw, sa nzanay, gwaꞌa gwaꞌa sənashi na ke ngəri. ");
INSERT INTO bcw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mbaꞌa tsahwəti *ndə Farisa niy nza tiɓa, Nikwədem, kə məndi slən tsa ci, ndə dikə ghəci mbə *ka Zhəwifə. ");
INSERT INTO bcw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dza ntsa va tə nahwəti vici həvir, ndəs tsəhəy vəgha Yesəw. Ma kə ngəci na: «A Metər, a ghəy sənay, gha na ntsa ghwənikə Hyala ta ciŋəy kwəma. Sa nzanay, tsahwəti ndə tiɓaa mbay mənti kwəma maɗaŋa na nja sa məni gha na, kala war ntsa nza Hyala liw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma kə Yesəw na: «A gəzaŋee, ta na navay, tsəgha na, kala zhini kə ndəə yay kwa baka səɗay, ka kwəmavə tsəhə ndə mbə mbəzli sləkə Hyalaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma kə Nikwədem na: «A Metər, ya ntsaa halantəvay kiy, njaa dza naa yay kwa baka səɗa cia? Njaa dza naa zhiniy mbay zhay zhəghwa hwər mbəghəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ma kə Yesəw ngəci na: «A gəzaŋee, ta na navay, tsəgha na, kala yay kə ndə lə yam, mbaꞌa lə *Safə tsa Hyalay, ka kwəmavə tsəhəy ndə mbə mbəzli sləkə Hyala tepəw. ");
INSERT INTO bcw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa nzanay, ma vəgha yakəm ndə ngəri li tikə tə hiɗiy, war vəgha ndə ngəri tsa va vay na gwaꞌa tsəgha. Ma naa yata va vəgha lə Safə tsa ɗewɗew tsay, vəgha lə piy tsa Safə tsa ɗewɗew tsa na. ");
INSERT INTO bcw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Əntaa kwəma nə ya va: “War ghwəy yaŋwəy ꞌwarꞌwar” pən, məniŋa nja maɗaŋa ma. ");
INSERT INTO bcw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kar ghaa nay, mbaꞌa kə safəə viyəy, səəkə dza kwa pətsa ɗi na ka naa viy, war ka favə gaka ci ghaa nza. Ma ki na, ka sənay gha tə pətsa ghava na, ya dzəti pətsa dza naw. Ava war tsəgha na lə kwəma ntsaa yay səəkə dzar kwa Safə tsa Hyala kwərakwə ki» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma kə Nikwədem na: «Njaa njaa ka nava kwəma mbay məntəvata tsəgha kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma kə Yesəw na: «Gha ndə ɓənipə kwəma tsa dikə tsa mbə ka *Izərayel na, kala sənata kwəma tsəgha na gha na? ");
INSERT INTO bcw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A gəzaŋee, ta na navay, tsəgha na, ghəy ta na tsa ghəy ghənəy, kwəma gəzəŋwəy ghəyəy, kwəma sənata ghəy na, ka gəzaŋwəy kwəmaa dzəkən shi nashi ghəy lə mətsəhi ghəy. Ma ghwəy ki na, a ɗi ghwəy zləɓa kwəma gəzəŋwəy ghəyəw. ");
INSERT INTO bcw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya sa nzana ki, kala ɗi zləɓa ghwəy, ghala pətsa gəzaŋwəyee kwəma shi tə hiɗiy, njaa dza ghwəy mbay zləɓa kwəmee ghala pətsa dzee maɗi ta gəzaŋwəy kwəma ni mə ghwəmə shia? ");
INSERT INTO bcw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tsahwəti ndə tiɓa mbaꞌa səəkəə nza mə ghwəmə kala war yən yən ntsaa səəkə va səəkə məɓa, yən Zəghwə yakə ndə ngəri kiw. ");
INSERT INTO bcw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Niy nza kwamti mbə gambay, a *Məyizə ni vasəti *shishi, mbaꞌa zlaŋəlati tə tsəm. Njasa niy mənti Məyizə vay, ava war tsəgha dza məndiy favəghara, yən Zəghwə yakə ndə ngəri vəgha tsəm kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ta way, ta mbə ya tsamaɓa ntsaa ndara nəfə tsa ciy kwəmavə piy tsaa kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sa nzanay, tərəŋwta ɗiti Hyala mbəzli tə hiɗi, dza na mbaꞌa ɓanakəshi Zəghwə nzə, zəkwəti ghəci və. Ta mbəə nza, ya wa ntsaa ɓanavə nəfə tsa ci kaa Zəghwə nzə vay, kala dza ghəciy zay ma, mbaꞌa kwəmavə piy tsaa kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ma na Hyalay, ghwənikə Zəghwə nzə na tikə tə hiɗi ta ɓasə ngwəvəə dzəkən mbəzliw. War ta mbə ghəshiy kwəmavə mbəlishi tə mbərkə ghəci gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ma ntsaa ɓanavə nəfə tsa ci kaa Zəghwə Hyala vay, ka dza ngwəvəə nza kənəw. Ntsaa ɓanavə ma nəfə tsa ci na, kəsə kəsə tsava ndə va ngwəvə Hyala. Sa nzana, kala ɗi ghəciy ɓə nəfə tsa ci kaa Zəghwə Hyala va, zəkwəti tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tə wa kəsəy ngwəvə Hyala va mbəzliy, tə sa nzana mbaꞌa pətsa waŋ tsa səəkəy va Hyala kaa mbəzli tə hiɗi, dzəghwa mbəzli diɓa na, nzəy tsa shi va mbə kwəsli ghəshi ɗi kən nza mbə pətsa waŋ tsa. Sa nzana, war *kwəma jikir na ghəshiy məni. ");
INSERT INTO bcw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ya wa ntsaa ɗi məni kwəma jikir nay, ka ɗi nzəy na tə pətsa waŋ tsa ya jəwəw, war tə pətsa zhəkwətə tsa ka naa ɗi. Sa nzanay, mbə hazləni ghəci vantaa kwəma ci va jikir na ghavəə citaa dzəti ngwəla. ");
INSERT INTO bcw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma na ntsaa məni na slar na kwəma kiy, war pətsa waŋ tsa ka naa ɗi, ta mbə mbəzli gwanashiy nata na ci va sləni məni na. Sa nzana mbaꞌa ghərati lə ɗi fəti ci va Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma ləy hwəm ki na, mbaꞌa Yesəw ghəshi lə *mbəzli ta səɗa ci maɗishi ka dzashiy dzəti hiɗi ka Zhəwde. Dza na mbaꞌa hyayvay tə pətsa va li shi, ka məni batem ghəci kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma ghala pətsa va kwərakwə ɓa na, mbə məni batem Zhaŋ mbə məlmə Ayənən, ndəkwə ndəkwə vəgha məlmə Salem. Sa nza yam ɗaŋ kwa həl tsa va gar məni batem. War ka səəkə mbəzliy nza və tə pətsa va ki, ka mananshi batem ghəci. ");
INSERT INTO bcw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ghala pətsa va na, məndi ghwəla ta kəsə Zhaŋ dzəghwa fərshina di. ");
INSERT INTO bcw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dza nihwəti mbəzli ta səɗa Zhaŋ mbaꞌa ghəshi ghavə ngərə ghəpə kwa jipə shi lə tsahwəti ndə *ka Zhəwifəə dzəkən kwəma yaɓə vəgha ɗewɗew, njasa nza kwəma jiji shi. ");
INSERT INTO bcw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma kə ghəshi kaa Zhaŋ na: «A Metər, zəzəvə ntsaa niy nza ghwəy va li gha pəriɓa pəriɓa tə miy həl Zhərdeŋ, ntsaa niy gəzaŋəy gha va kwəma ci. Ma ghəci kiy, batem məni na kaa mbəzli kwərakwə, mbəzli gwaꞌa gwaꞌa dza na və» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma kə Zhaŋ na: «Nay ghwəy tsəy, ndə tiɓaa mənti shiy, kala war shi kanavə Hyala ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ma ghənzə nja tsee ghən kiy, ghwəy dəꞌwə ghən tsa ghwəy dza naa ndəgha fəti tə ya, sa nzana, mbaꞌa ghwəy niy favə njasa niy gəzəkee: “Ma yən ta na tsee ghənəy, *Kəristəw Ntsa tivə Hyala nzeyew! Ə na na ghwənikəra məndi ta ꞌwanci kwal” pən niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kwəma va sanay, njasa ka ndə vaa nza ghəciy ɗi ɓə mali ci, mbaꞌa madigay tiɓa, ma ntsaa ɓə mali vay, ghəci ka naa nzaa ndə mali. Ma na madigay tsa vay, war ta nzəyəy ghəci vəgha madigay, ka fa kwəma gəzə na, ka naci kwəmaa nza. Ma sa ka na favə gəzə kwəma ntsaa ɓə mali va ki na, ka vəshi ghəci tərəŋw. Ava tsəgha nzee sana kwərakwə ki, tərəŋw təhəree va vəshi, sa favee gaka ci. ");
INSERT INTO bcw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","War mətsəhə kə tsa ci dikəə mətsəhə kəli dza kwa kwəma, ka zhəy tsee ləy hwəm» kə Zhaŋ. ");
INSERT INTO bcw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ma ntsaa səəkəy mə ghwəməy, ghəci na sa kən ghən shiy gwaꞌa gwaꞌa. Ma tsaa yay ndə tikə tə hiɗi kwərakwə na, ntsa hiɗi va na tsava ndə. Ya kwəma gəzə na na, war kwəma tiɓa tə hiɗi va ghənzə ɓa. Ma na ntsaa səəkəy mə ghwəmə kiy, ghəci na sa kən ghən shiy gwaꞌa gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ya kwəma gəzə na na war kwəma shi nashi na, lə ni favə na gwaꞌa tsəgha. Ya tsəgha nzə ki na, ndə tiɓa ya kwətiŋ yivə kwəma ci vaw. ");
INSERT INTO bcw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ya wa ntsaa zləɓavə kwəma gəzə na vay, a tsava ndə sənay: «Kataŋ na kwəma gəzə Hyala» kə. ");
INSERT INTO bcw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma ntsa ghwənay Hyalay, war kwəma Hyala ka naa gəzə. Sa nzana, mbaꞌa Hyala va təhay lə Safə tsa nzə. ");
INSERT INTO bcw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Didi ɗiti Zəghwə ci, dza na mbaꞌa ɓanavə bərci ngəciy dzəkən shiy gwanashi. ");
INSERT INTO bcw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ya wa ntsaa zləɓati kwəma Zəghwə ci vay, a tsava ndə kwəmavə piy tsaa kəɗi ma. Ma na ntsaa dzaa ɗi ma fəti ta kwəma gəzə Zəghwə vay, ka kwəmavə piy tsaa kəɗi maw. War ngwəvə sati nəfə tsa Hyala na saa dzaa nza kən ya hwəmɓa. ");
INSERT INTO bcw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dzəghwa mbaꞌa *ka Farisahi favə məndiy gəzə: «Mbə məni *batem na Yesəw, ɗaŋ tərəŋw mbəzli ka səəkə və, ɗaŋɓa nici mbəzliy nəw mənishi kən ni Zhaŋ» kə məndi ngəshi. ");
INSERT INTO bcw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Na Yesəw dəꞌwə ghən tsa ci kiy, niy mənəhwə batem na kaa ndəw, mbəzli ta səɗa ci niy məni na. ");
INSERT INTO bcw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dza Yesəw sa favə na kwemer gəəzə məndi va tsəgha, mbaꞌa ɓarvay tə hiɗi ka Zhəwde ta zhay zhəti hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta dzaa zhəmbə Galile va ki na, dzəvəri tə hiɗi ka Samari ghəci dzaa taŋə. ");
INSERT INTO bcw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma ghəci mbə taŋə dzəvəri tə hiɗi ka Samari va ki na, mbaꞌa tsəhəy mbə nahwəti məlmə tə hiɗi va, Shikar, kə məndi slən tsa nzə. Məlmə va na, vəgha vəh tsaa niy ɓanavə *Zhakwapə va kaa zəghwə ci *Zhezhefə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma mbə vəh tsa va kiy, mbaꞌa Zhakwapə niy lati yam. Sa daliy Yesəw va dza ki na, mbaꞌa nzəyəy ka dəkəva miy yam va, geꞌi lə vici kwa ghən. ");
INSERT INTO bcw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ꞌWakəvə nahwəti mali ka Samari ndəs səəkəta ta ga yam ghala vici va ki. Ma sa səəkəta na na, dza Yesəw ka gəzanta kwəma: «A mali, samiyra yam va di» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ma ghala pətsa va kiy, *mbəzli ta səɗa Yesəw dzashi ta papa shi zəmə dzar mbə məlmə niy nza na. ");
INSERT INTO bcw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma kə mali va kaa Yesəw na: «A ntsa, ndə *ka Zhəwifə gha, mali ka Samari yən kiy, tawa ɗəw gha yam vəya ta sashi kia?» kə. Ma kwəma gəzə na vay, sa nzana, kalaa niy tsəɓə ghən tsa ka Zhəwifə ghəshi lə ka Samari ghala pətsa va ya jəw nzə, va tsəgha gəzə na tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma kə Yesəw zləɓanta na: «A mali na, mbala na gha sənay gəla ni ɗi Hyala vəlipə shiy nza, mbaꞌa gha sənay, nda wa ntsaa ɗəw yam tsa va gha nzay, gha na saa niy dzaa təɓəə ɗəw yam və. Ma nza ghəci ɓəŋa yaməə ɓəpə piy tsaa kəɗi ma nza» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma kə mali va na: «A Metər, kərakə yam kwaɓa, zhini saa ga yam va ghaw na, kwəma dza ghaa ɓəkə niva yaməə ɓəpə piy tiɓa sənzənva kia? ");
INSERT INTO bcw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yam nashi gha niy, jijimmə *Zhakwapə latəŋəyshi na. Ghəci dəꞌwə ghən tsa ci, lə ndərazhi ci, mbaꞌa dəbəkə tsa ci gwaꞌay, yam ni niy sa ghəshi. Naa ə nzana mbaꞌa gha taŋəti jijimmə Zhakwapə tə dikə nə gha ki shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma kə Yesəw na: «A mali, ya wa ntsaa sahwə nini yaməy, war ta zhini dza ndir ghəranci ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma ni dzee vaa ɓanshi yam kaa mbəzli kiy, ntsaa dzaa sahwə shi na, ka zhini ndir ghəranci kaa tsava ndə ghwəla tepəw. Yam dzee vaa ɓanavəy, mbər ka shənifə yam dza ghəshiy nza mbə, ta ɓanci piy tsaa kəɗi ma ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma sa favə mali va tsəgha, ma kə kaa Yesəw ki na: «A Metər, gavəra gəla niva yam di, e sahwəshi, nda kee mbəlira va zhini ndir ghəraɗa kala dzee zhiniy zhəkə tikə ta ga yam ghwəla» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma kə Yesəw na: «Tsəgha na, mbala harkə zaŋa, a ghwəy səəkə li tikə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma kə mali va na: «Zal vəyaw» kə. Ma kə Yesəw na: «Geꞌi geꞌi na kwəma nə gha va: “Zal vəyaw” pə gha. ");
INSERT INTO bcw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sa nzanay, cifə na zhər səəkə gha ti shi ghənghən ghənghən. Tsa nza gha tsa və zal sənzənvanay, zaŋa tsa slar tsa naw, dzərvə mbə kwəma gəzəkəra gha vaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dzəghwa ma kə mali va ki na: «A Metər, wa nee sənay nana ki, ndə Hyala nza gha. ");
INSERT INTO bcw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ghəy ghəy ka Samariy, tikə mə ghən dəlagwa niy va jijihiŋəy tsəfəkwə ta pəraꞌwanta dividivi shi kaa Hyala. Ma pə ghwəy ghwəy ka Zhəwifə na ghwəy ki na: “War mbə məlmə Zherəwzalem gwaꞌa tsəgha na pətsa ka məndi pəraꞌwanta dəvə ti kaa Hyala” pə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A kə Yesəw ngəta na: «A mali, zləɓavə kwəma dzee na ta gəzəŋa: Mbə səəkə na tsahwəti vəghwə, mbə vəghwə tsa vay, ka dza ghwəy pəraꞌwanci dividivi ghwəy kaa Didi Hyala ya tikə mə dəlagwa na, ya mbə məlmə Zherəwzaleməw. ");
INSERT INTO bcw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ghwəy ghwəy ka Samari talay, sənay ntsa pəraꞌwanci ghwəy dividivi ghwəy ghwəyəw. Əy, ma na ghəy ghəy ka Zhəwifə kiy, a ghəy sənay ntsa pəraꞌwanci ghəy dividivi ghəy. Sa nzanay, səəkə mbə hwəlfə ka Zhəwifə dza ntsaa dzaa mbəlipəə tsahwə. ");
INSERT INTO bcw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","A tsahwəti vəghwə dzaa səəkə, ya sana nzəy, aa məniy. Ghalaɓay, lə *Safə tsa Hyala ɗewɗew tsa, mbaꞌa lə nəfə tsa kataŋ tsa dza ka pəraꞌwə dəvə slar niy pəraꞌwanci dəvə kaa Didi. Sa nzanay Safə na Hyala. Mbəzliy ɗi pəraꞌwanta dividivi shi kaa Hyala kwərakwə kiy, lə bərci Safə tsa nzə, mbaꞌa lə nəfə tsa kataŋ tsa dza ghəshiy pəraꞌwanta dividivi shi. Sa nzanay, gəla mbəzliy pəraꞌwanta dividivi tsəgha na shi ɗi Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma kə mali va ki na: «Talay, e sənay, ta səəkə dza Ntsa tivə Hyala, ntsa nə məndi va, *Kəristəw, kə məndi. Sa ka na səəkəyəy, ta pəraslavəŋəy kwəma Hyala dza naa dza gwaꞌa gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma kə Yesəw ngəta na: «Ava yən na ki, yən ntsaa gəzaŋa kwəma tsa sənzənva» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ghala pətsa va ki na, mbaꞌa mbəzli ta səɗa Yesəw zhəghəkəvashi mbə məlmə. Ma səəkə ghəshi na, Yesəw mbə gəzə kwəma lə mali, mbaꞌa nava kwəma səəti məhərli shi. Ya tsəgha nzə ki na, ndə tiɓa mbə shiy ɗəw: «A mali na, wa shi ɗi gha və shəka?» kəw. Ya ka ɗəw va Yesəw na: «Gha kiy, a kwəma gəzə ghwəy lia?» kə ɓaw. ");
INSERT INTO bcw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ꞌWakəvə mali va tsəgha, mbərəkə zlata tsaghwa nzə tiɓa miy yam, ka zhəghəvaa jighi ta dzaa gəzanshi mbəzli. A kə kaa mbəzli sa tsəhəta na na: ");
INSERT INTO bcw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«A mbəzlia, wa ndim nighətimam tsahwəti ndə tikə, mbaꞌa gəzəkəra shi mənəhwee ghala mbəradzə gwaꞌa gwaꞌa. Nda ghəci na Kəristəw Ntsa tivə Hyala vay? Əndaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ꞌWakəvə mbəzli mbə məlmə va tsəgha takwəs maɗishi ta dza ta nighə Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ləy hwəm sa dzata mali vaa dzəmbə məlmə ki na, mbaꞌa mbəzli ta səɗa Yesəw maɗishi ta cəꞌwə Yesəw, a ghəci zəməhwə shi zəmə di, ma kə ghəshi na: «A Metər, zəhwə shi zəmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dzəghwa ma kə ngəshi na: «Kadiwəm na ghwəy di, a ni ya shi zəmə vəya zəməshee, shi zəmə sənashi ma ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tapə mbəzli ta səɗa ci va dzəmbəshi mbə ɗewɗew kwəma kwa jipə shi, a kə ghəshi na: «Ə nzana mbaꞌa tsahwəti ndə ɓanakə shi zəmə shəkəna?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma kə Yesəw ngəshi ki na: «Ma na ni ya shi zəmə gəzaŋwəy yay, ghəshi na ɗi fəti ta kwəma gəzəkə ntsaa ghwənara, mbaꞌa kəramti sləni ndara na ta məni nzə. ");
INSERT INTO bcw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tir faɗə tərə na məndi dzaa məni shi zəmə səəkə kwamti, pə ghwəy sana ɓay? A gəzaŋwəy ya nee ki, nighətim njasa nza pətsa kwamti, gwaꞌa gwaꞌa nakamtəvashi shi zəmə. Tərə na war mənishiy jighi. ");
INSERT INTO bcw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndə məni shiy jighi kiy, mbə kwəma zhəmə ci na, ka na dza kaa hwəlfə shi vay, ɓasə ɓasə ɓasətishi, mbaꞌa dzaa gwəmaghwashi kwa gəzəm, ta kwəma piy tsaa kəɗi ma ghəshi. Ta mbə kar ntsaa zati shi va ghəshi lə tsaa mənikəshi vaa jighi nza lə vəshi bakanashi. ");
INSERT INTO bcw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A kwəma va mbəə nza nja kwəma fir tsaa niy gəzə va, ma kə na: “Kwətiy ndə tsəŋwə shiy na, kwətiy tsaa mənishiy jighi” kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sa nzanay, ghwəniy ghwəniŋwəy ya sana, ta dza ghwəy məni shi zəmə tsəŋwəti ma ghwəy jighi. Kwətishi na mbəzliy, zati shi va. Mbaꞌee ghwənaŋwəy kwərakwə ki tə mbərkə sləni shi va» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Ma sa tsəhəshi mbəzli mbə məlmə ka Samari va vəgha Yesəw na, ɗaŋ mbəzli mbəɓa ɓanavə nefer shi ki, tə mbərkə kwəma gəzanshi mali va va, nə na: «Gwaꞌa gəzara na kwəmaa niy mənəhwee ghala mbəradzə» kə. Dza ghəshi ka cəꞌwə Yesəw, a ghəci hyayvay mbə shi. Dza Yesəw mbaꞌa zləɓati mbaꞌa hiy mbə shi gar vici ci bakə. ");
INSERT INTO bcw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sa favə ghəshi kwəma gəzanshi na lə miy tsa ci dəꞌwə ghən tsa shi na, dzəghwa mətsəhə nihwəti mbəzliy ɓanavə nefer shi zhiniy mətsəhə shi ki. ");
INSERT INTO bcw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma kə ghəshi kaa maliy harashi va ki na: «A mali, kwataka tə sa gəzaŋəy gha va gwaꞌa tsəgha ɓanavə ghəy nefer ghəy kaa Yesəw nana kiw. Sa nzana, mbaꞌa ghəy favə kwəma gəzə na lə miy tsa ci ngəŋəy dəꞌwə ghən tsa ghəy. Dzəghwa mbə kwəma va na, mbaꞌa ghəy sənay kataŋ kataŋ, ghəci na Ndə mbəli mbəzli tə hiɗi, pə ghəy, va tsəgha ɓanavə ghəy nefer ghəy diɓa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ləy hwəm vici mənti Yesəw va bakə na mbə məlmə *Samari kiy, dza na mbaꞌa zlay tsava piy səvəriy, ka dzay dzəti nici hiɗi, hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwataŋay aa niy gəzəkə, a kə niy niy: «Ka fati dikə məndiy dzəti ndə Hyala njasa təɓə na mbə məlmə ciw» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ya tsəgha nzə kiy, ma sa tsəhəy na tə hiɗi ka Galile na, dzəghwa mbəzli tə hiɗi va mbaꞌa ghəshi kaꞌwəvə wəzə wəzə tərəŋw. Sa nzana mbaꞌa ghəshi səəkə mbə məlmə Zherəwzalem ta *makwaghwa Pakə, mbaꞌa ghəshi nashi shi mənəhwə Yesəw mbə makwaghwa va lə mətsə shi njasa mənishi na gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dzəghwa Yesəw mbaꞌa zhəghəghəvay zhimbə məlmə Kana, tə hiɗi ka Galile. Mbə pətsaa niy zhəghəti na va yam gəmshi ni ka tay. Dzəghwa mbaꞌa tsahwəti ndə ghəra sləni ngwəmna tsa dikə tsa tiɓa mbə məlmə Kapernahwəm gwərapəy zəghwə ci. ");
INSERT INTO bcw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma sa favə na, a Yesəw zhəghəkəvay tə hiɗi ka Zhəwde dzəti hiɗi ka Galile, kə məndi na, dza na mbaꞌa dzaa kəsay ta cəꞌwə, a kə na: «A Metər, titihwə dzam a gha dzaa mbəlitəra zəghwee ghəci gwərapəy mbə məlmə Kapernahwəm, tərə na jəw sana ta məti» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ma kə Yesəw ngəci na: «Yaŋ tsəgha na, ghwəy ɗi na ɓəra nefer ghwəy kala war ghwəy nay na yən mənti shi maɗaŋa maɗaŋa ni, lə shiy cipə kwəma ɓa na.» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma kə ndə sləni ngwəmna tsa va ngəci na: «A Metər, yaŋ pə gha, ndi mbata ghaa dzakə ghi tsee di na gha, əntaa zəghwee va mətiy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma kə Yesəw ngəci na: «A pə gha məntiy, mbalaa jighi, mbəli mbəli na zəghwə gha» kə. Dza na: «Yaŋ» kə zləɓavə kwəma gəzanci Yesəw va, war ka dzay. ");
INSERT INTO bcw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma war ghəci ghwəlay kwa kwal mbə jighəy, mbaꞌa mbəzliy ghəra sləni kəghi tsa ci səəkəshi ta kaꞌwə, ka gəzanci: «A zəghwə gha va mbəliy ɓay» kə shi. ");
INSERT INTO bcw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma kə na: «Geꞌi geꞌi lə vici njaa gha naa mənti gəjaꞌ baya?» kə. Ma kə mbəzli va na: «Mbəra sa səkwata vici kwa ghən gha naa kwəmavə gəjaꞌa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dzəghwa ndə ghəra sləni ngwəmna tsa va mbaꞌa sənay tsəgha, war geꞌi geꞌi ghala vici gəzanci Yesəw va nə naa ni: «Mbala, mbəli mbəli na zəghwə gha va» kə, zəghwə ci va kwəmavə gəjaꞌa. Dzəghwa na, ghəci lə mbəzli kəghi tsa ci gwanashi, mbaꞌa ghəshi ɓanavə nefer shi kaa Yesəw ki. ");
INSERT INTO bcw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ava, ghənzə na kwa baka kwəma maɗaŋa maɗaŋa na mənti Yesəw tə hiɗi ka Galile, ghala pətsaa səvəriy na mbə hiɗi ka Zhəwde dzətiy ti shi. ");
INSERT INTO bcw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma ləy hwəm kwəma va na, mbaꞌa nahwəti vici makwaghwa *ka Zhəwifə mənta, mbaꞌa Yesəw dzay dzəmbə məlmə Zherəwzalem ta makwaghwa va kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma mbə məlmə va na, mbaꞌa kwəfa lati məndi tiɓa ndəkwə ghənzə vəgha miy dəgha ka teŋkesliy dzəmbə məlmə va kwa. Slən tsa kwəfa va lə kwəma ka *Ebərə na: «Betizata.» Cifə məndi lalati geshikiki vəgha. ");
INSERT INTO bcw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma mbə geshikiki va na, mbaꞌa mbəzli gwərapə gwərapəshi ni niy ɓasəyvashi ɗaŋ tərəŋw, ghwəlefesli, lə vədevəder, mbaꞌa mbəzli məəti məəti vəgha ni gwaꞌa. Ka ndəghə dazləɓə tsa dza yam vaa dazləɓayvashi. ");
INSERT INTO bcw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sa ka naa nzay, bərkəti ma *ndə kwal tsa Hyala na, kar naa səkway dzəghwa kwəfa vaa dazləɓata. Ma ndə zəlghwə tsaa dzaa ꞌwaa dzəghway dzəghwa kwəfa va, ya zəlghwə ka wa niy nza sa ci na, mbəli mbəli ghəci. ");
INSERT INTO bcw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mbaꞌa tsahwəti ndə niy nza tiɓa məhəni mbə gaska va, gwərapəy gar piya ci, mahkan mətsəkə dəghəsəti. ");
INSERT INTO bcw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sa nay Yesəw tsəgha məhəni, mbaꞌa niy sənay gwərapəy na ghala ndimndim kə na, dza na ka ɗəw kwəma və, a kə na: «Ka ɗi ghaa mbəliŋa na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma kə ntsa gwərapəy tsa va na: «A Ndə sləkəpə, ava war tsəgha kee nza tiɓa. Tsee ndə tə ya gar ɓəvəraa fambəra mbə yam taŋtaŋ, ghala pətsa ka ghəshiy dazləɓəshiw. Sa kee dza kaf kafəra, ka dza ta dzəghə dzəmbəshiy, kee maɗiy tsəhə na, tsahwəti ndə ꞌwati kwal dzəghway kənee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma kə Yesəw na: «Sati, pəərə kəshəɗə tsa gha, mbala» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nzaꞌjəw tsəgha, kwəriŋ, ntsa va mbəliy. Dza na mbaꞌa pəərəvə kəshəɗə tsa ci, ka dza. Ma vici məniva shi va ti kiy, fəca *vici dəkəva ka Zhəwifə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma kə mbəzli dikə dikə ni mbə ka Zhəwifə kaa ntsaa mbəliy va na: «Gha kiy, kwal va gha ta ɓə kəshəɗə tsa gha tsa, njana nzana mahalakə ghəra sləni va ghwəmmə ndatsə nzaw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma kə kaa zləɓanshi na: «Waa ntsaa mbəlitəra va, nə naa ni: “Sati pəərə kəshəɗə tsa gha a gha dzaa” kə sa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zhini ma kə ghəshi ngəci ɓa na: «Yaŋ, wa slən tsa tsava ntsaa gəzaŋa va tsəgha naciy?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma na ntsa mbəlitim va naci kiy, niy sənay ntsaa mbəliti va naw. Sa nzanay, a Yesəw niy ɓarvay tə pətsa va, mbaꞌa dzay sa nza mbəzli ɗaŋshi tiɓa. ");
INSERT INTO bcw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dzəghwa ləy hwəm shi va ki na, mbaꞌa Yesəw dzaa kəsay ghəci mbə *ciki Hyala. Ma sa kəsay na tsəgha ki na, dza na mbaꞌa gəzanci, ma kə ngəci na: «A ntsa, avanay sənzənvay, a gha mbəliŋa, nana kiy, ya tə gha ghən tsa gha va zhiniy məni *kwəma jikir na. Vantaa nahwəti kwəma zhataa dzəkən gha, taŋ kaa na kwataŋa va» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dzəghwa ntsa va mbaꞌa dzaa gəzanshi ka mbəzli dikə dikə ni mbə ka Zhəwifə: «Wa Yesəw mbəlitəra na ki» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tə kwəma va ɗi ma mbəzli ka Zhəwifə dikə dikə ni mətsə Yesəw ki, sa mbəliti na va ntsa va fəca vici dəkəva shi. Mbaꞌa ghəshi ghati ghəzli ci tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma kə Yesəw ngəshi na: «A mbəzli ni, Dirəy, vici va vici va na mbə ghəra sləni. Yən kwərakwə kiy, war tsəgha ghəree» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tə mbərkə kwəma gəzəkə Yesəw va tsəgha na gwəra mbəzli dikə dikə niy ɓəti nəfəə dzəkən Yesəw tərəŋw ka pəla kwal pəəsli ci. Kwataka va ntsa mbəliti na va fəca vici dəkəva naw, əhəŋ, gaw tə sa nə na va: «Dirə na Hyala» kə, ka zhəghəti ghən tsa ci yəm lə Hyala na. ");
INSERT INTO bcw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma kə Yesəw ngəshi ki na: «A mbəzli ni, a gəzaŋwəy ya, ta na navay, tsəgha na, ya wa shi nashi ghwəy va Zəghwə məntiy, shi mənti na dəꞌwə ghən tsa ci ghəshiw. Shi nashi na Dəy mbə mənishi na, shi va mənti na. Ya nimaɓa shiy na shi məni Didi va gwaꞌay, ghəshi na shi məni Zəghwə ci kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sa nzana mbaꞌa Didi ɗiti Zəghwə ciy, dza na mbaꞌa cinti məni shi ka naa məni gwaꞌa ngəci. Ta zhini dza naa canci ghəra sləniy taŋamti nana tə dikə tərəŋw diɓa, nza Zəghwə ci mbəə ghəra, ma nza ghwəy nighə nava kwəma, nja kwəma dimədimə na ki. ");
INSERT INTO bcw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sa nzanay, njasa mbay Didi vaa zhanakati mbəzliy bəkwəshi zhakati mbə məti, ka zhanambə piy tsa shiy, tsəgha dza Zəghwə ciy mbay ɓanci piy tsaa kəɗi ma kaa ya tsama ntsa dza naa ɗi gwaꞌa kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na Didiy, ka ɓasə ngwəvə naa dzəkən ndə ya kwətiŋ naciw. War kaa Zəghwə ci ɓanavə na kwal ɓasə ngwəvə. ");
INSERT INTO bcw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ta mbə ndə ya tsamaɓa ciy fal Zəghwə ci va, njasa fal ghəshi va Didi kwərakwə. Ntsaa dzaa ɗi ma fal Zəghwə ci vay, ava tsəgha dza naa fal ma Dəy tsaa ghwənay va kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Avanay sənzənvay, ə gəzaŋwəy ya, ta na navay, tsəgha na, ya tsamaɓa ndə favə na kwəma gəzee, dza na mbaꞌa zləɓavə kwəma ntsaa ghwənaray, a tsava ndə kwəmavə piy tsaa kəɗi ma. Ka kəsəy tsava ndə ngwəvəw. A taŋəy dzəghwa kən məti, mbaꞌa dzay dzəmbə piy tsaa kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ə gəzaŋwəy ya, ta na navay, tsəgha na, a tsahwəti vəghwə tiɓa dzaa səəkə, ya sənzənvay, aa səəkəy, vəghwə tsa vay, vəghwə tsa dza mbəzli bəkwə bəkwə niy favə gaka məli Zəghwə Hyala ti na. Mbəzliy dzaa favə gaka məli ci va kiy, ta piy dza ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sa nzanay, njasa nza Didi va lə bərci və ta ɓə piy kaa ndə na, tsəgha ɓanavə na bərci va kaa Zəghwə ci a ghəci ɓanshi piy kaa mbəzli kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mbaꞌa ɓanavə kwal tsaa ɓasə ngwəvəə dzəkən mbəzli gwaꞌa kaa ngəci, sa nzana Zəghwə yakə ndə ngəri ghəci. ");
INSERT INTO bcw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Əntaa ghwəy dzaa nighə nja maɗaŋa sa ka tsahwəti vəghwə səəkəy ma. Ghala vəghwə tsa vay, mbəzli kwa kwəli gwaꞌa gwaꞌa dza naa favə məli ci, ");
INSERT INTO bcw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ka ghəshi dza na, mbaꞌa ghəshi zhikəməshi kwa kwəli. Ma mbəzliy niy nza mbə məni kwəma wəzə nay, səəmə tsa shi na, ta kwəmavə piy tsaa kəɗi ma, ma niy niy məni war *kwəma jikir na na, ka səəmə ta dzəti ngwəvə. ");
INSERT INTO bcw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na neyey, sa mbay ya məni dəꞌwə ghən tsee, njasa tarəvee tiɓaw. Ya ngwəvə njasa slee nay, njasa gəzara Hyala slee. Ngwəvə slee vay sa tsərtsər na na, sa nzana, kala pəla fambə nee kwəma ɗee yən dzəmbə, war njasa ɗi ntsaa ghwənara yən məni» kə. ");
INSERT INTO bcw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ma kə Yesəw diɓa na: «Na neyey, mbaꞌa pən ni, e ndəgha fəti ta ghən tsee, pənəy, fəti kataŋ na naw dza mbəzliy ni. ");
INSERT INTO bcw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nanzə kiy, a ndə tiɓa, ntsaa dzaa ndəgha fəti tə ya. E sənay, fəti ndəgha ntsa vaa dzəkən yay, ndəgha fəti lə kwal tsa kataŋ tsa na. ");
INSERT INTO bcw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A ghwəy niy ghwənashi mbəzli kaa Zhaŋ tsaa məni *batem ta ɗəw kwəma və. Dza Zhaŋ mbaꞌa ndəghamti fəti ta kwəma kataŋ na va. ");
INSERT INTO bcw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma na nee ta na tsee ghən kiy, ɗəw ndee a ghəci mbəə ndəghatəra fəti, pənəw. War tə mbərkə ghwəy gəzee kwəma ndəgha fəti Zhaŋ, ta mbə ghwəy zləɓa, ma nza ghwəy mbəliŋwəy. ");
INSERT INTO bcw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sa nzana Zhaŋəy, nja gərkəwa ka ghwə vaa nza waŋə kwa, ka mbərə kaa mbəzli ghəci niy nza. Dzəghwa mbaꞌa ghwəy niy vəshiŋwəy geꞌi lə tsava vəghwə gar jəwə tsətsə, ta kwəma waŋ tsa mən na va. ");
INSERT INTO bcw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na nee diɓay, a nihwəti shiy dzaa ndəgha fətiy dzəkənee tiɓa, tərəŋwɓa na shi va ndəgha fəti kən na Zhaŋ. Sləni gəzara Dirə va, ta ghəray, ghənzə ndəgha na fəti tə ya. Sləni mənee vay, ti dza mbəzliy sənay, Dirə tsa mə ghwəmə ghwənikəra na, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dzəghwa Dirə tsaa ghwənikəra va ɓa na, mbə ndəgha fəti ghəci dəꞌwə ghən tsa ci tə ya. Ma ghwəy ta na tsa ghwəy ghən ki na, səəkə ghwəy favə gaka məli ciw, səəkə ghwəy nata mətsə ciw, tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Njana ɗi ma ghwəy zləɓa kwəma ntsaa ghwənaray, kwəma ci mbə nəfə ghwəyəw ɗi naa gəzə. ");
INSERT INTO bcw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dzəghwa ghwəy mbaꞌa ghwəy jahambəvaŋwəy tərəŋw dzəmbə jangə zliyahi Hyala, sa bərkəti ghwəy: “Ta kəsata kwəmaa cipə njasa dza məndiy kwəmavə piy tsaa kəɗi ma dza ghəy mbə” pə ghwəy. Mbalaa dzəkənee gəzə kwemer mbə zliyahi va va kwəma nashi ki. ");
INSERT INTO bcw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","A ka ɗi ghwəy səəkə vəya ta kwəmavə tsa kataŋ tsa piyəw. ");
INSERT INTO bcw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma na nee, ta na tsee ghənəy, nə yaa ni, war ndə ngəri faltəra, pənəw. ");
INSERT INTO bcw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","E sənaŋwəy, ka ɗi Hyala ghwəy ya jəw mbə nefer ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Vanay sanay, e səəkəra tikə, ta kwəma ghwənikəra Dirə, dzəghwa ghwəy na, a ɗi kaꞌwəra ghwəyəw. Ka ghwəy nighə taa nza kiy, mbaꞌa kə tsahwəti ndə səəkəy lə kwəma tarəkə na, dəꞌwə ghən tsa ci na, ka ghwəy dza, kaꞌwə kaꞌwəvə tsava ndə tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","War fal tsa dza ndə ngəri, nja ghwəy faltəŋwəy sa pala ghwəy gwaꞌa tsəgha, kala pəla fal tsa dza Hyala kwətitaa faltəŋwəy. Njaa dza ghwəy zləɓavə kwəmee nə ghwəy kia? ");
INSERT INTO bcw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Əntaa ghwəy təkə na, nja yən dza naa hakaŋwəy dzəti ngwəvə kwa kwəma Dirə, pə ghwəy nee ki ma. *Məyizə tsa sənay ghwəy va fəy ghwəy ghən tsa ghwəy tiy, ghəci dza naa harŋwəy dzəti ngwəvə. ");
INSERT INTO bcw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","War mbaꞌa pə ghwəy niy zləɓavə kwəma Məyizə lə nəfə tsa karkar tsa nzay, a ghwəy niy dzaa zləɓavə nee va kwəma nza kwərakwə ki, sa nzanay, kwəmaa dzəkənee na sa niy tsasliti Məyizə va. ");
INSERT INTO bcw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kwa vəghwə tsa njana, kala zləɓavə na Məyizə va kwəma ghwəy kiy, njaa dza ghwəy ghaa zləɓavə nee kwəma nee paraa?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma ləy hwəm kwəma va ki na, mbaꞌa Yesəw kafəy taŋəy dzəvəri na pəriɓa pəriɓa bəla həl Galile tsa har məndi vaa həl *Tiberiyadə. ");
INSERT INTO bcw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma sa nay məndi ghəci dzay na, tapə vərəm ndə ngəri mbə nəw ci, sa nay məndi kwəma maɗaŋa maɗaŋa na mbə mbəli tsa mbalamti na va mbəzli gwərapə gwərapəshi ni. ");
INSERT INTO bcw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dza kar Yesəw ghəshi lə mbəzli ta səɗa ci mbaꞌa ghəshi dzəməshi mə kəlaŋ tiɓaa nzəyshi mə. ");
INSERT INTO bcw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma ghala pətsa va ki na, *makwaghwa Pakə ka Zhəwifə ndəkwə ndəkwə ta məniva. ");
INSERT INTO bcw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sa nə Yesəw njəꞌwə, kə na, ndə ngəri ɗaŋ tərəŋw ɓasəkəvay, ka səəkəə dzəvəgha. Sa nashi na mbəzli va, ma kə kaa Fəlipə na: «A Fəlipə, kwəma dza ghwəm pakə shi zəmə tə pətsa sana gar ɓanshi kaa mbəzli ni gwanashia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma gəzə na kwəma va tsəghay, war ta mbəə favə na dza Fəlipəə zləɓanci kwəma gwaꞌa tsəgha. Ma ghəci na naciy, gwaꞌa sənata na njasa dza naa məni. ");
INSERT INTO bcw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma kə Fəlipə na: «A Metər, ya war mbəl gar bələkwə bələkwə bakəə ɓəvə ghwəm pavə shi zəmə tiy, daw dza ghəshiy nza ta kwəmavə ngəmiy shi mbəzli ni jəw jəw gwanashi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma kə tsahwəti mbə mbəzli ta səɗa ci, Andəre, zəmbəghəy Shimaŋw Piyer na: ");
INSERT INTO bcw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Avanay tsahwəti zəghwə tikə jəwə lə peŋ cifə mbaꞌa kərpi bakə və. Nanzə kiy, wa shi dza niva shiy ghakə ta gəla mbəzli ɗaŋ ni ni tsətsə kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma kə Yesəw ngəshi na: «Gəzanshim mbəzli va, a ghəshi nzəyshi mənzəy na ghwəy» kə. Ma pətsa vay, lə gwəzən ti gar nzəyshi mbəzli. Mbəzli va ki na, mbaꞌa ghəshi mənti gar bələkwə bələkwə cifə mətsəkə. Dza ghəshi mbaꞌa ghəshi nzəyshi ki. ");
INSERT INTO bcw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sa nashi Yesəw mbəzli va nzəyshi gwaꞌa na, dza na tsaŋ ɓəvə peŋ, ka məni ꞌwəsa kaa Hyalaa dzəkən. Sa manamti na ꞌwəsa na, mbaꞌa ɓanavəshi kaa mbəzliy nzəyshi va gwanashi a ghəshi zəmə. Tsəgha mənti lə kərpi va ɓa. Ya wa də mbə shi na, mbaꞌa kwəmavə shiy zəhwəshi gar məkanci. ");
INSERT INTO bcw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma ləy hwəm sa zəhwə mbəzli va shi zəmə gwanashi bəhə bəhə kiy, mbaꞌa Yesəw gəzanshi mbəzli ta səɗa ci, a kə ngəshi na: «A pə ghwəy mənti kiy, ɓasətim tsaa tərmbə va va mbəzli va, əntaa tsahwəti dzaa daŋərəy mbə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dzəghwa məndi ɓasə ɓasə məndi ɓasəti tsaa tərmbə peŋ mbə sa cifə tsa va sa zəməvə məndi, ghwani məŋ lə bakə məndi təhay li gyaɗə gyaɗə. ");
INSERT INTO bcw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mbaꞌa ghəshi nata njasa mənti Yesəw kwəma dimədimə na va gwanashi tsəgha, a kə ghəshi ki na: «Ntsa na ndə Hyala tsa gəzə məndi va dzaa səəkəə dzəti hiɗi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mbaꞌa Yesəw sənay tsəgha, «Ndal tərmbə ghəshi ta səəkə ta kəsəra lə bərci ta pəərəɗa ka mazəw» kə. Mbaꞌa zhiniy zhay zhimə kəlaŋ tsa va kwətiy, mbaꞌa dzaa nzəyəy mə diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sa məniy tihwer na, mbaꞌa *mbəzli ta səɗa Yesəw dzashiy dzəməy həl. ");
INSERT INTO bcw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mbaꞌa ghəshi dzəghwashi kwa kwambəwal, ka taŋə dzəvəri tə həl tsa va ta dzəmbə məlmə Kapernahwəm. Paꞌ ka mənta vərɗi war ghəshi mbə taŋə, kala səəkəy Yesəw kəsashi. ");
INSERT INTO bcw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mbaꞌa safə maɗiy ta viy dzəy tə kwəfa va lə bərci tərəŋw. War paslaꞌwə yam paslaꞌwəva dalala tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma sa kaɓə ghəshi kwambəwal tsəgha, mbaꞌa ghəshi kəətivə dza gar kiləwmetər cifə, ya gar kwaŋ kiy, nighə ghəshi na Yesəw səəkəy ndəkwə ndəkwə lə kwambəwal, ka dza lə səɗa ci dzəy tə yam. Dzəghwa mbaꞌa her shi dzashi və. ");
INSERT INTO bcw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma kə Yesəw ngəshi ki na: «Waa yən na, ka hazləni ghwəy ma» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","«Ənkwa» kə ghəshi. Dza ghəshi ka ɗi kaꞌwəə dzəghwa kwambəwal, war ghwəla tsəgha na, ndəs kwambəwal kəsashi hiɗi pəri həlbə tsa ɗi ghəshi va dzaa dzəti. ");
INSERT INTO bcw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ma way pi tə həzlimə na, ghaꞌ mbəzliy niy ɓasəshi va ghati zəzə kwəma Yesəw tə pətsa nza na. Sa nzana mbaꞌa ghəshi sənay, mbəray war kwətiŋta kwambəwal niy nza tə pətsa va, mbaꞌa *mbəzli ta səɗa Yesəw niy dzəghwashi kwa. Ma ghala pətsa dzəghwa ghəshi va na, niy nay Yesəw ghəshi dzəghway li shiw, war mbəzli ta səɗa ci va shiy niy dzashi jaꞌjaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma ghəshi mbə zəzə kwəma Yesəw tsəgha ki na, mbaꞌa nihwəti kwambəwalerəə səəkə mbə məlmə *Tiberiyadə dzakə dzashi tə pətsa va, tiɓa ndəkwə lə pətsa zəmə məndi va peŋ tsa mənti Yesəw va ꞌwəsa kaa Hyala məndiy zəmə. ");
INSERT INTO bcw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sa nay ghəshi, kala Yesəw tiɓa, zhini kala mbəzli ta səɗa ci tiɓa kwərakwəy, mbaꞌa ghəshi dzəghwashi kwa kwambəwaler va, ka dzashiy dzəvəri məlmə Kapernahwəm ta pala Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dza ghəshi ndəs ghəshi kəsay Yesəw pəriɓa ki. Ma sa kəsay ghəshi na: «A Metər, hwəm səəkəŋa gha tikəa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma kə Yesəw na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, sa nzana mbaꞌa ghwəy favə kwəma ɗi shi maɗaŋa məntee va ciŋwəy palara ghwəyəw. Sa nzana, mbaꞌa ghwəy kwəmavə shi zəmə vəya, ka zəhwəshi bəhə ghwəy, va tsəgha palara ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka kəslimbə ghən ghwəy war kən ghəra sləni ta shi zəməə dzaa gwəravəə yiɗishi gəm ki ma. Ta niy dzaa nza ndimndim ni shi zəmə ka ɓanci piy tsaa kəɗi ma kaa ndə pə ghwəy ghəra sləni. Shi zəmə vay, yən Zəghwə yakə ndə ngəri, yən sa fati Dirə Hyala lamba nzə tə ya, dza naa ɓəŋwəyshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tapə mbəzli va ta ɗəw kwəma və ki, a kə ghəshi na: «War njaa njaa dza ghəy mənti dza ghəy mbay ghərati sləniy dzaa təɓanta kaa Hyalaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma kə Yesəw zləɓanshi na: «War ndara ma ghwəy nefer ghwəy, yən ntsa ghwənay nay, ghənzə na ghəra sləni wəzə na ɗi na va ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zhini ma kə ghəshi na: «A kwəma maɗaŋa mənti gha gar nata ghəy, ta mbə ghəy ndaŋa nefer ghəya? Naa a sləni mənti ghaa? ");
INSERT INTO bcw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A gha sənay ghala pətsaa nza jijihimmə kwamti mbə gambay, a ghəshi niy kwəmavə shi zəmə nə məndi *manə, kə məndi, mbaꞌa ghəshi zəhwəshi, njasa gəzəkə kwəma mbə Zliya Hyala, ma kə na: “Mbaꞌa ɓanakəshi na shi zəmə səəkə mə ghwəmə” kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma kə Yesəw na: «Ə gəzaŋwəy ya, ta na navay tsəgha, *Məyizə ndaŋwəy na shi zəməə səəkə mə ghwəməw, Dirə na saa dzaa ɓəŋwəy ni kataŋ kataŋ ni shi zəməə səəkə mə ghwəmə. ");
INSERT INTO bcw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sa nzanay, ma ni ɓəkə Hyala shi zəmə mə ghwəməy, shi ka ɓanshi piy kaa mbəzli tə hiɗi na ghəshi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma kə mbəzli va na: «A ntsa dikə tsa, ɓəŋəy niva gəla shi zəmə həzlimə həzlimə di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma kə Yesəw na: «Yənəy, yən na shi zəməə ɓəpə piy. Ya tsamaɓa ndə səəkəy na vəyay, ka dza maa ghəranciw. Ntsaa ndara nəfə tsa ciy, ka ghəranci ndir ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nanzəy, e niy gəzəkəŋwəy: A ghwəy nara ngar na, a ndara nəfə tsa ghwəy ghwəyəw, pən niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya tsama ndə na mbə ni ndara Dirə va mbəzliy, ta səəkə dza naa dzəmbə dəvee, ka tihəti tsaa dzaa səəkəy va ndəə dzəmbə dəvee ya tepə kiw. ");
INSERT INTO bcw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sa nzanay, səəkəree mə ghwəmə ta məni kwəma war njasa ɗi yaw, ta məni kwəma ɗi ntsaa ghwənara səəkee. ");
INSERT INTO bcw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kwəma ɗi ntsaa ghwənara vay, war mbaꞌee ndəghwəti mbəzli ndara na va mbə dəvee gwanashi. Kala zay ndə mbə shi ya kwətiŋ nzə. Mbaꞌee dzaa zhanakatishi mbə məti gwanashi, fəca dza hiɗiy kərə. ");
INSERT INTO bcw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ma kwəma ɗi Dirəy, ya wa ntsaa nara, yən Zəghwə ci, dza na mbaꞌa ndara nəfə tsa ciy, mbaꞌa tsava ndə kwəmavə piy tsaa kəɗi ma, zhini mbaꞌee dzaa zhanakati mbə məti fəca dza hiɗiy kərə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ꞌWakəvə *ka Zhəwifə gaꞌ ta ngwəzliməə dzəkən Yesəw, sa nə na va: «Yən na shi zəməə səəkəshi mə ghwəmə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma kə ghəshi na: «Yesəw sasa tsəy? Ghəci zəghwə *Zhezhefə va tsəy. Ntsa sənay ghwəmmə kar dəy lə mbəghəy ghəci ki na. Njaa njaa naa ni: “Mə ghwəmə səəkee” kəa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma kə Yesəw na: «A mbəzli ni, ka ngwəzlimə ghwəy kwa jipə ghwəy gəm ma. ");
INSERT INTO bcw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndə tiɓa mbaꞌa dzaa mbay səəkəy dzəvəghee, kala war ntsa haray Didi tsaa ghwənikəraw. Yən kiy, ta zhanakati dzee mbə məti fəca dza hiɗiy kərə. ");
INSERT INTO bcw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A mbəzliy gəzə kwəma Hyala niy tsasliti kwəma mbə Zliya Hyala, a kə ghəshi niy niy: “Ta ɓananavəshi kwəma dza Hyala kaa mbəzli gwanashi” kə ghəshi niy ni. Ntsaa dzaa fəti ghən ta kwəma dza Didiy ɓananci, dza mbaꞌa zləɓavə kwəma ɓənipə na va kiy, ta səəkə dza tsava ndəə dza vəya. ");
INSERT INTO bcw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mbə gəzə kwəma vay, ə nə ya: A tsahwəti ndə tiɓa, mbaꞌa səəkəə nay Didi, pənəw. War yən kwətira yən saa səəkə va mə Hyala na saa nay Didi. ");
INSERT INTO bcw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya wa ntsaa ndara na nəfə tsa ciy, aa kwəmavə piy tsaa kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yən na shi zəməə ɓəpə piy. ");
INSERT INTO bcw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Njasa gəzə ghwəy vay, a jijihiŋwəy niy zəhwə shi har məndiy manə kwamti mbə gamba, ya tsəgha nzə kiy, gwanashi bəkwəshi ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma na shi zəməə səəkə mə ghwəmə nashi kiy, ya wa ntsaa dzaa zəhwəshiy, ka məti tsava ndəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yən na shi zəməə səəkə mə ghwəmə, ka ɓəpə piy. Zəhwə ma ndə niva shi zəməy, ta nza dza na lə piy ta kwa ndimndim jiji. Vəghee dəꞌwə ghən tsee na shi zəmə dzee vaa ɓanci kaa ntsa va. Ta zlatanavə vəghee va dzee kaa məti, tə mbərkə mbəzli tə hiɗi, ta mbə ghəshiy kwəmavə piy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma sa favə ka Zhəwifə kwəma gəzəkə Yesəw va tsəgha na, mbaꞌa kafəkə ghəpə kwa jipə shi, a kə ghəshi na: «Njaa njaa ka ntsa mbay ndammə vəgha ci, ta zəmə ghwəmmə nə na kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dzəghwa ma kə Yesəw ki na: «A mbəzli ni, a gəzaŋwəy ya, ta na navay, tsəgha na, war dza ghwəy kala zəhwə vəghee ghwəy, yən Zəghwə yakə ndə ngəri, kala sahwə miymiy ya ghwəyəy, ka dza ghwəy kwəmavə piyəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma na ntsaa zəhwə vəghee, mbaꞌa sahwə miymiy yay, aa kwəmavə piy tsaa kəɗi ma. Ta zhanakati dzee mbə məti ci fəca dza hiɗiy kəɗi. ");
INSERT INTO bcw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sa nzanay, vəghee va na ni kataŋ ni shi zəmə, zhini miymiy ya na, ni kataŋ ni shi sa. ");
INSERT INTO bcw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma ntsaa zəhwə vəghee va, mbaꞌa sahwə miymiy yay, jakəjakə nza ghəy li. Mbə ya na, mbee piy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Dirə tsaa ghwənaray ghəci ɓəpə na piy. Tə mbərkə ghəci piyee sana. Ava tsəgha dza ntsaa zəhwə vəghee nza lə piy tə mbərkee kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma na shi zəmə mə ghwəmə nashi kiy, yəm na ghəshi lə niy niy zəhwə jijihiŋwəy va shi zəmə mbəradzə kwamtiw. Ya tsəgha niy zəməhwəshi ghəshiy, a ghəshi niy bəkwəshi na nashi. Ma ntsaa dzaa zəhwə nini shi zəməy, ta nza dza na lə piy tsa ci, ta kwa ndimndim jiji» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesəw mbə ɓananshi kwəma kaa mbəzli mbə ciki ɓasə va tsa ka Zhəwifə, mbə məlmə Kapernahwəm, gəzəkə na kwəma na. ");
INSERT INTO bcw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma sa favə mbəzliy nəw Yesəw va kwemer gəzəkə na va tsəghay, ɗaŋ nihwəti mbəzli ghati ngwəzlimə, a kə ghəshi na: «Kay, ata gəla nana kwəmay, caslakəta na. Ka dza ndəə mbay nəwtiw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mbalaa gwaꞌa sənay Yesəw njasa ngwəzlimə ghəshiy dzəkən. Ma kə ngəshi na: «A mbəzli ni, njaa baya ə zhəŋwəy kwəma na na? ");
INSERT INTO bcw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ya sa dza ghwəy nara yən Zəghwə yakə ndə ngəri, yən maɗiy dzara dzəmə ghwəməə zhəti pətsaa niy nzee kwataŋa kiy, njaa dza ghwəy təkə ghalaɓaa? ");
INSERT INTO bcw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","*Safə tsa Hyala naa ɓə piy kaa ndə, tsahwəti sa mbay ndə ngəriy ghakə tiɓa ya waɓaw. Ma kwemer gəzaŋwəy ya niy, Safə tsa Hyala na ghəshi, piy ghəshi diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ya tsəgha nzə kiy, a nihwəti mbəzli mbə ghwəy kala ɗi ghəshiy zləɓa kwəma va» kə. Sa gəzə Yesəw va tsəghay, aa niy sənashi mbəzliy dzaa zləɓa ma kwəma ci ghala kwataŋata, lə ntsaa dzaa nga ɗafa ti gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma kə Yesəw ɓa na: «Va tsəgha niy nə ya ngəŋwəy kiy: Ndə tiɓa mbaꞌa taa səəkəy dzəvəghee, kala ntsa pəməvə Dirəw, pən» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma sa favə mbəzliy nəw va kwəma gəzəkə na va tsəgha ki na, mbaꞌa nihwəti mbəzli ɗaŋ mbə mbəzliy nəw zlay dzashi. ");
INSERT INTO bcw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma kə Yesəw kaa mbəzli ta səɗa ci va məŋ lə bakə ni ki na: «A mbəzli ni, njaamə shəka, ə ɗi ghwəy zlaraa dzaŋwəy kwərakwə na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma kə Shimaŋw Piyer na: «A Ndə sləkəŋəy, va wa ghəy dza kia? A ghəy sənay, kwəma gha na saa ɓəpə piy tsaa kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A ghəy zləɓavə kwəma gha, mbaꞌa ghəy sənay gha na ntsa Hyala ɗewɗew tsa ghwənikə na, pə ghəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma kə Yesəw na: «Ghwəy ghwəy mbəzli ta səɗee ni məŋ lə bakə ni na, yən təravəŋwəy tsəy? Ya tsəgha nzə kiy, *ndə jaka tsa Hyala na tsahwəti ndə mbə ghwəy kwətiŋ» kə. ");
INSERT INTO bcw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kwəma gəzə Yesəw va tsəgha nay, dzəkən Zhəwdasə zəghwə Shimaŋw Isəkariyətə gəzə na. Sa nzana, ya tsəgha na Zhəwdasə mbə mbəzli ta səɗa ci va məŋ lə bakə niy, ghəci dza na ta nga ɗafa ta Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma ləy hwəm kwəma va ki na, mbaꞌa Yesəw dzay ta təwrə mbə məlməhi tə hiɗi ka Galile. Kalaa niy ɗi dza ghəciy dzəti hiɗi ka Zhəwde, sa nzana mbə ɗi pəəsli ci mbəzli dikə dikə ni mbə *ka Zhəwifə niy nza. ");
INSERT INTO bcw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma sa nza vici *makwaghwa ka ka Zhəwifə vaa tsə ta Gaska ndəkwə na, ");
INSERT INTO bcw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","dza ngwarməhiy ka gəzanci kwəma kaa Yesəw, ma kə ghəshi na: «A Yesəw, ɓarvaŋa tikə, mbalaa dzəti hiɗi ka Zhəwde, a gha dzaa ghərati sləni maɗaŋa na, ta mbə mbəzli ta səɗa ghaa nata kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sa nzana, mbaꞌa kə ndəə ɗi mbəzli gwaꞌaa sənayəy, kar ndəə məni kwəma tə mbəw. Ma njana nzana, mbaꞌa ghaa mbata ghəra sləni tsəgha na naghay, war ghəra pə gha dzaa ghərati kwa mətsə mbəzli gwanashi!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ya ngwarmbəghəyshi kiy, niy ɓanavə nefer shi ghəshiw, va tsəgha gəzə ghəshi tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma kə Yesəw ngəshi na: «Ta na neyey, səəkəy tsee vəghwə nee diw. E sənay, na na ghwəy na ghwəyəy, ya hwəmɓa na, war yəməy na vəghwə va ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sa nzana, ma ghwəy ta na tsa ghwəy ghənəy, a mbəzli tə hiɗiy ɗi mətsə ghwəy. Na nee nee kiy, ka ɗi mətsee ghəshiw. Sa nzana, mbə gəzanshee sləni jikir naa məni ghwəy, pən ngəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zlaram, mbalam ta makwaghwa ghwəy na ghwəy, na neyey, ka dzee tsəhəra mbə diw, sa nzanay, ghwəla na tsee vəghwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ma sa gəzanakəshi na kwəma va tsəgha na, dza na mbaꞌa nzəyəy tə hiɗi ka Galile. ");
INSERT INTO bcw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma sa dzashi ngwarməhiy Yesəw ta tsə makwaghwa Gaska va ki na, mbaꞌa Yesəw maɗiy ləy hwəm shi, ta dza ta tsə va kwərakwə nja mbəmbə, kala ci ghən tsa ci kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dzəghwa mbəzli dikə dikə ni mbə ka Zhəwifə ka papala dzar mbə mbəzli mbə tsə va. A kə ghəshi na: «Kwəma na kia nə ghwəmməy?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma vərəm ntsaa ɓasəy ta tsə makwaghwa naci ki na, bakə mbə təhəvərivay tə mbərkə kwəma ci, ka ngwəngwəliva kwa jipə shi. Ma kə nihwəti na: «Kay, ma ntsa vay, wəzə na kwəma ci tərəŋw» kə ghəshi. A kə nihwəti ɓa na: «Kay, tiɓaw, ndə mbə tepəw. Mbəzli na ni dakə na» kə niva ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ya tsəgha nzə ki na, a mbə ghəshiy gəzəkəvəri kwəma va paꞌi paꞌi dzəti ngwəla, sa hazləni ghəshi va mbəzli ka Zhəwifə dikə dikə niw. ");
INSERT INTO bcw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma sa mənta vici məntim mbə tsə va yəmyəm lə naa tərmbə ki na, ꞌwakəvə Yesəw irətsə dzəmbəy mbə *ciki Hyala, ka ɓananshi shiy kaa mbəzli mbəɓa. ");
INSERT INTO bcw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma sa favə ka Zhəwifə kwəma ɓənipə na va na, mbaꞌa nava kwəma səəvəri məhərli shi. A kə ghəshi na: «Aya, njaa sənata tsatsa ndə kwəma mbə zliya kala səəkə ghəci mbə ɓəni nzə kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma kə Yesəw ngəshi na: «A mbəzli ni, nay ghwəy na, kwəma ɓəniŋwəy ya nay, kwəmaa səəkə vəya dəꞌwə ghən tsee naw. Kwəmaa səəkə va Hyalaa ghwənara va na. ");
INSERT INTO bcw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ma ntsaa tarəti məni kwəma ɗi Hyala mbə nəfə ciy, ta mbay dza tsava ndəə sənata, niy nza kwəma gəzee na, ka kwəmaa səəkə va Hyala karkar, ya ka kwəmaa səəkə vəya dəꞌwə ghən tsee na. ");
INSERT INTO bcw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","War mbaꞌa pə ghwəy nay ndə dzətiy tə gəzə kwəmaa səəkə və dəꞌwə ghən tsa ciy, fal tsa ciy pəla tsava ndə kaa ghən tsa ci. Ma na ntsaa pəlanci fal kaa ntsaa ghwənikəy, ava ntsa kataŋ tsa, dzərvə mbə kwəma ci tepəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","A *Məyizə niy ndaŋwəy *kwəma pəhəti Hyala. Ya ndə kwətiŋəy ntsaa nəwti kwəma pəhəti na va mbə ghwəyəw. Wa shiy mənishi pəla ghwəy kwal tsaa pəəslira kia?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dzəghwa, ma kə vərəm tsaa ɓasəy va tə pətsa va ngəci na: «Gazlaka kəsəvəŋa na shəkəna? Wa ntsaa pəla pəəsliŋa tiɓaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma kə Yesəw na: «A ghwəy nay war sa məntee sləni kwətiŋ gwaꞌa tsəghay, mbaꞌa səəvəriŋwəy məhərli ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sa gəzaŋwəy Məyizə *slanshi fəꞌyasa kaa ndərazhiy zhər ghwəy mənti ma ghəshi hi dəghəsə ghala yakəshi məndiy, ya fəca *vici dəkəva məniva kwa dəghasa vici va na, kar ghwəy slanshi fəꞌyasa kaa ndərazhi ghwəy. Mbalaa kwəma ghakə Məyizə na sava tala naci kiw, kwəma gəzəkə Hyala kaa jijihiŋwəy ghala mbəradzə na. ");
INSERT INTO bcw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ya sa nzana mbə slanshi fəꞌyasa ghwəy nza kaa ndərazhi ghwəy ya paꞌ fəca vici dəkəva, sa ɗi ma ghwəy dzəghwaŋwəy kən kwəma gəzəkə Məyizə kiy, war tawa ɓə ghwəy nəfə dzəkənee, sa mbəlantee ndə fəca vici dəkəva mbə ngəraꞌwə tsa kən, nza vəgha ci mbəə nza kwəriŋ kia? ");
INSERT INTO bcw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A pə ghwəy məntiy, ka ɓə fəti ghwəy kaa ndə, war tə shi nashi ghwəy ghəci mənti kwa mətsə ghwəy gwaꞌa tsəgha ma. Sənay tə ghwəy kwal tsa kwəma, ka ghwəy maɗi ta ɓə fəti kaa ndə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma kə nihwəti mbəzli mbə mbəzli mbə məlmə Zherəwzalem sa nay ghəshi Yesəw mbə gəzə kwəma na: «Aya, wa ntsa sa pala məndi va ta pəəsli ci sham sa? ");
INSERT INTO bcw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Avanay mbə gəzə kwəma tə ngwəla parahwə kala ntsaa gəzanci ya kwəma tiɓa ni? Naa ə nzana mbaꞌa mbəzli ghwəmmə dikə dikə ni sənay “Ghəci na Kəristəw ntsa tivə Hyala va” kə ghəshi shəkəna? ");
INSERT INTO bcw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sa ka Kəristəw səəkəy na naciy, ka dza məndiy sənay nda ndə ka wa naw. A na tsatsa ndə naci kiy, a ghwəmmə sənay tə pətsa səəkə na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ghala vəghwə tsa gəzə mbəzli va va kwəma vay, Yesəw mbə ɓəni shiy kaa mbəzli mbə *ciki Hyala na. Dza na, ka zlapə kwəma zlaŋzlaŋ, a kə na: «Njaa pə ghwəya? A ghwəy sənara, ka sənay ya tə pətsa səəkee, pə ghwəy? Kataŋ sənara ghwəy na? Yən nee ki e gəzaŋwəyəy, səəkə tsee tsa na, yən səəkəra na lə ɗee dəꞌwə ghən tseyew, ndə ghwənara na. Ntsa va kiy, ntsa slar tsa na, ghwəy na na ghwəyəy, sənay ntsaa ghwənara va ghwəyəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na nee nee kiy, e sənay, sa nzanay, ghəy li niy nza na. Dza na mbaꞌa ghwənikəra sana ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma sa favə ghəshi kwəma gəzəkə na va tsəgha ki na, mbaꞌa ghəshi dzəmbəshi mbə pəla kwal tsaa kəsə ci. Kala ntsaa mbay dapati dəvə ti tiɓa ya jəw nzə. Sa nzana, ghwəla tsa ci vəghwə niy nzaa səəkə. ");
INSERT INTO bcw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɗaŋ mbəzliy zləɓavə kwəma ci mənishi mbə mbəzliy ɓasəshi va. Ma kə ghəshi na: «Sa ka Kəristəw tsa va səəkəy na, war pərɓa ghəci dzaa mənti kwəma maɗaŋa maɗaŋa na kən ntsa ki shəkəna?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma sa favə *ka Farisahi mbəzli tiɓaa ɗahwə ɗahwə gəzə kwəma Yesəw na, dza ghəshi mbaꞌa ghəshi jakəti miy tsa shi lə mbəzli dikə dikə ni mbə *ka ta Hyala, mbaꞌa ghəshi ghwənashi mbəzliy ndəghwə ciki Hyala, ta dza ghəshiy kəsəti Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma sa tsəhəshi ghəshi, ma kə Yesəw na: «Vici ɗaŋ tərmbə nzəy tsa ghwəmmə lə ghwəy yən dzaa maɗi ta dzaraa dzəvəgha ntsaa ghwənikəraw. ");
INSERT INTO bcw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ta palara dza ghwəy dza, kala dza ghwəy nara. Ka dza ghwəy mbay tsəhəŋwəy tə pətsa dzee nza diɓaw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma kə *ka Zhəwifə kaa ɗəw kwəma kwa jipə shi na: «Wa slən tsa nana kwəma kia? Kwəma dza na ta dzay, nə na: “Ka dza ghwəy naraw” kəa? Ə nzana ta dzay ghəci dzaa dzəmbə hwəlfə mbəzli ghwəmmə ka Zhəwifə va dzashiy dzəmbə hiɗi ka *Gərekə, ta dza ta ɓananshi kwəma kaa ka Gərekə shəkənaa njaa? ");
INSERT INTO bcw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wantsa hwəlfə gəla kwəma gəzəkə na na, nə na: “Ta palara dza ghwəy dza kala dza ghwəy nara, ka dza ghwəy mbay tsəhəŋwəy tə pətsa dzee nzaw” kəa? Am, sənata hwəlfə gəla kwəma ɗi na na gəzə ghwəmməw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mbə makwaghwa vay, tə kwa kərni vici nzə ka bamaa gwəramti. Dzəghwa Yesəw fəca kwa kərni vici va ki, gar garəy kwa kwəma vərəm tsaa ɓasəy va tə pətsa va gwanay, dza na ka gəzə kwəma zlaŋzlaŋ, a kə na: «Mbaꞌa kə ndir ghəranci kaa ndəy, səəkə ghəci vəya, a ghəci sa yam. ");
INSERT INTO bcw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ya wa ntsaa ndara nəfə tsa ciy, a nəfə tsa ci taa zhəghəy ka mətsə yam ɗaŋ ni ɓəpə piy, njasa gəzəkə məndi va mbə zliy Hyala» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ma kwəma gəzə Yesəw va tsəgha nay, dzəkən *Safə tsa Hyala ɗewɗew tsa dza mbəzliy ɓanavə nəfə tsa shiy kwəmavə ta nza, gəzə na. Ghala pətsa va di na, kalaa niy kwəmavə ghəshi, sa nzana, ghwəla Yesəw niy nza ta dzəmbə dikə tsa ci. ");
INSERT INTO bcw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma kə nihwəti mbəzli mbə vərəm tsaa ɓasəy va sa favə ghəshi kwəma gəzəkə Yesəw va na: «Ma ntsa kataŋəy, ndə Hyala tsa ndəghə ghəy va na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma kə nihwəti na: «Əhəŋ, *Kəristəw Ntsa tivə Hyala va na» kə ghəshi. Ma kə nihwəti ɓa na: «Am awə, Kəristəw kə na, ka səəkə na tə hiɗi ka Galile nzaw. ");
INSERT INTO bcw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Niy favə ghwəy njasa gəzəkə Zliya Hyala sa: “Mbə hwəhwə tsa mazə *Davitə dza Kəristəw səəkə, mbə məlmə Betəlehem, tə pətsaa niy nza mazə Davitə tsa va va” kə sa» kə ghəshi ");
INSERT INTO bcw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mbaꞌa mbəzliy ɓasəshi va tərəŋw ni tihəvərivashi tsəgha ki, tə mbərkə kwəma Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mbə ɗi kəsə ci nihwəti mbəzli niy nza mbə shi na, ndə tiɓa mbə shiy dapati dəvə ci tiw. ");
INSERT INTO bcw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dzəghwa ka ndəghwə *ciki Hyalaa niy ghwənashi məndi va ta kəsə Yesəw, ndəs ghəshi zhəkəshiy dzəvəgha mbəzli dikə dikə ni mbə *ka ta Hyala lə *ka Farisahiy niy ghwənashi va ki, kala səəkəshi ghəshi li. Ma kə ghəshi kaa mbəzli va sa nay ma ghəshi Yesəw na: «Kwəma zhini ghwəy zlay, kəsə ma ghwəy səəkə ɓaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma kə ka ndəghwə ciki Hyala ngəshi na: «Ghala nza məndi na səəkə tsahwəti ndəə gəzəkə kwəma nja sa ci vaw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma kə ka Farisahi ki na: «Waa ə ngəɗəhwəŋwəy na kwərakwə ɓa lə ghwəyŋwəyshi na? ");
INSERT INTO bcw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nay ndə ghwəy ya kwətiŋ mbə mbəzli ghwəmmə dikə dikə ni, ya mbə ka Farisahi yivə nəw kwəma ci va na? ");
INSERT INTO bcw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nay ghwəy, kəray mbəzliy sənata ma kwəma pəhəti *Məyizə va shiy yivə nəw kwəma ci va sa? Mbəzli bəzla bəzla ni na niva mbəzli» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ma mbə ka Farisahi vay, Nikwədem, kə məndi niy ni kaa tsahwəti. Saa niy səəkə va həvir mbə ɗəw kwəma va Yesəw niy nza, ");
INSERT INTO bcw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ma ka na naci ki na: «Nanzəy, ndammə kwal tsaa ɓə fəti kaa ndə kwəma pəhəti ghwəmmə, kala sa ka ghwəmmə famti kwəma gəzəkə ndə gwaꞌa, mbaꞌa ghwəmmə sənata kwəma mənti naw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma kə ghəshi ngəci na: «Ə nza ghaa ndə ka Galile kwərakwə shəkəna? Mbala ɓəvə Zliya Hyala, a gha jangəti di, ndata dza ghaa kəsay slən tsa ndə Hyala tsaa təzliy səəkə mbə mbəzli ka Galile mbəɓa ya kwətiŋ» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ma ləy hwəm kwəma va ki na, mbaꞌa ghəshi ndanivərivashi, kwətiŋ kwətiŋ, ka dzashiy jighi. ");
INSERT INTO bcw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma dza Yesəw naci ki na, mbaꞌa dzay dzəmə kəlaŋ *ꞌWəlivə nzəyəy. ");
INSERT INTO bcw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Way pi tə həzlimə va pəətə ki na, mbaꞌa Yesəw səkway məɓaa dzay dzəmbə *ciki Hyala. ꞌWakəvə vərəm ndə ngəri tərəŋw, mbaꞌa ɓasəkəvay dzəvəgha mbəɓa ki. Dza na das nzəyəy mənzəy, mbaꞌa ghati ɓananshi shiy. ");
INSERT INTO bcw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma sa ghati na ɓananshi shi va na, dza *mbəzliy ɓənipə kwəma pəhəti Hyala, ghəshi lə *ka Farisahi, ndəs ghəshi səəkəshi tə pətsa va lə mali sa kəsəvə ghəshi ghənzə mbə məni ghwərghwər. Səəkə ghəshi, gar ghəshi garəy tə jipəjipə mbəzli gwanashi. ");
INSERT INTO bcw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma kə ghəshi kaa Yesəw na: «A Metər, mali nay, ə kəsata ghəy ghənzə mbə həni lə tsahwəti zal, ka məni ghwərghwər. ");
INSERT INTO bcw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tə kwəma gəzəkəŋəy *Məyizə mbə zliya kwəma pəhəti Hyalay, gəla mali tsətsə na na, war ka pəꞌwamti ka mbəri lə hərezli gwaꞌa tsəgha na kwəma nzə. Nda njaa na va gha na gha kiy, əndaw?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma kwəma gəzə ghəshi va tsəgha nay, kəlaŋa na sava ngənəy ghəshi kaa Yesəw ta mbəə kəsəy lə fəti tə kwəma dza naa zləɓakə. Ma sa famti Yesəw kwəma shi va na, nzəŋw nzəŋwəy, ka tsasli shiy dzar tə hiɗi lə dəvə ci. ");
INSERT INTO bcw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dza ghəshi ka ɗəw kwəma va və tsəgha zhənti zhənti ki. ꞌWakəvə Yesəw mbaꞌa kafəti kwəma ci, ma kə ngəshi na: «Ghənzə tsəghay, ə kə ntsaa səəkə maa mənti *kwəma jikir na mbə ghwəy ghati pəꞌwə mali va lə hakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Zhini na nzəŋw nzəŋwəy diɓa, war ka tsasli shi ci va məcana lə dəvə ci dzar tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma sa favə mbəzli va kwəma gəzəkə Yesəw va na, kwətiŋ, kwətiŋ, kwətiŋ ghəshi ꞌwati ghəlivaa səvəri, ka dzashi, pərɓa mətikwəkwər ꞌwati kwal, ka kəray niy tərmbə. Tərə na war mali va tiɓa diɗiŋ məgarə kwa kwəma Yesəw bakəshi ghəshi li. ");
INSERT INTO bcw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ꞌWakəvə Yesəw kafə kafəti kwəma ci, ma kə kaa mali va na: «A mali, kwəma dzashi mbəzli ni shəka? A kama ntsaa kəsəyŋa tiɓa mbə shi lə ngwəvə shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma kə mali va na: «Am, ndə tiɓa ya kwətiŋəw Metərəw» kə. Ma kə Yesəw ki na: «Yən kwərakwə kiy, ka ɓasə ngwəvee dzəkən ghaw. Mbala, əntaa gha zhiniy məni kwəma jikir na ghwəla ma» kə Yesəw ngəta. ");
INSERT INTO bcw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zhini Yesəw ka gəzə kwəma kaa vərəm tsaa ɓasəy va. Ma kə na: «Favə tə ghwəy, waa yən na waŋ pi tsaa mbərə kaa mbəzli tə hiɗi gwanashi. Ntsaa nəwvəray, ka dza naa nza mbə kwəsliw. Ta kwəmavə waŋ tsaa dzaa canci kwal, ta kwəmavə piy tsaa kəɗi ma dza na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma kə *ka Farisahi ngəci na: «Ava ghaa ndəgha fəti ta kwəma gəzə gha dəꞌwə ghən tsa gha sana, kwəma mbə kwəma gəzə gha vaw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma kə Yesəw na: «Ya ə ndəghee fətiy dzəkən kwəma gəzee dəꞌwə ghən tseyey, war kwəma kataŋ na na sa gəzee. Sa nzanay, e sənay tə pətsa səəkee, zhini mbaꞌee sənay zhəti pətsa dzee zha ɓa. Na na ghwəy na ghwəy kiy, sənay ghwəy tə pətsa səəkə yaw, sənay ghwəy nda kwəma dzee diɓaw. ");
INSERT INTO bcw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Na na ghwəyəy, dza kwa zəzə kwəma ke ngəri sla ghwəy na ghwəy ngwəvə. Na nee ta na tsee ghən nee kiy, ka ɓasə ngwəvee kaa ndəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ya ə niy nzana, mbaꞌee harati ndə tə ngwəvə, mbaꞌee ɓanavə fətiy, fəti lə kwal tsa nzə na, tə kwəma mənti na. Sa nzanay, war yən kwətira dza naa nza mbə sla ngwəvə vaw. Bakanaŋəy dza ghəy nza mbə sla nzə ghəy lə Dirə tsaa ghwənikəra. ");
INSERT INTO bcw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Njasa nzana va tsəgha kwəma va tsaslita mbə zliya pəhəti ghwəy: “War mbaꞌa kə mbəzli bakə ndəghakən fəti kwətiŋ naa dzəkən kwəmay, ndəgha fəti kataŋ na dza nava ndəgha fətiy nza” kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tsəgha na, fətiy ndəghee ta kwəmee dəꞌwə ghən tsee, mbə ndəgha na Dirə tsaa ghwənara vaa dzəkənee kwərakwə diɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma kə ka Farisahi na: «Kwəmaa Dəŋaa?» kə ghəshi. Ma kə Yesəw na: «Sənara ghwəyəw, sənay Dirə ghwəy ɓaw. Ava tsəgha na. Mbala a ghwəy sənara nzay, a ghwəy dza sənay Dirə nza kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesəw mbə ciki Hyala mbə ɓəni shiy kaa mbəzli gəzə na kwemer ni gwanashi. Ghəci tə pətsa ka məndiy fə gəna kaa Hyala ti. Ghala pətsa vay, ndə tiɓa niy mbay kəsəti, sa nzana, ghwəla vəghwə tsa ci niy nzaa səəkəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zhini ma kə Yesəw kaa ngəshi diɓa na: «Nay ghwəy na, ta dzara dzee. Ka ghwəy dzay, ka palara. Ka dza ghwəy mbəə tsəhəŋwəy tə pətsa dzee va nzaw. Ta bəkwə dza ghwəy tiɓa lə kwəma ghwəy jikir na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma kə *ka Zhəwifə kwa jipə shi ki na: «Əy kwəma dza na ta dzay shəka? Ta dzaa pəəsliti ghən tsa ci dza na shəkəna? Njaa na nava kwəma, nə na: “Ka dza ghwəy mbəə tsəhəŋwəy tə pətsa dzee nzaw” kəa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma kə Yesəw sa favə na kwəma təkə ghəshi ki na: «A mbəzli ni, ma ghwəyəy mbəzli tə hiɗi nza ghwəy. Yən nee kiy, mə ghwəmə səəkee. Ghwəyəy, mbəzli tə hiɗi ni tikə nza ghwəy. Yən nee kiy, ntsa tikə nzeyew. ");
INSERT INTO bcw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Va tsəgha nə ya ngəŋwəy kiy, tiɓa dza ghwəy nza, ka bəkwə lə kwəma ghwəy jikir na, pən. Kala zləɓati pə ghwəy mbə nefer ghwəy, yən na ntsa nzee ghəci, pə ghwəyəy. Ta bəkwə dza ghwəy lə kwəma ghwəy jikir na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","A kə ghəshi na: «A ndə nza ghaa?» kə ghəshi. Ma kə Yesəw na: «Yən na sa kee vaa gəzaŋwəy ndimndim ghala ghatee gəzaŋwəy ɓasa. ");
INSERT INTO bcw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nay ghwəy na, yənəy, ɗaŋ na kwemer vəya gar gəzəshee, ya gar ɓasəŋwəy ngwəvə nza. Ma ki na, mbaꞌee sənay, ntsaa ghwənara vay, kwəma kataŋ na na sa ci, pən. Ə dzee gəzanshi kwəma gəzara na gwaꞌa tsəgha kaa mbəzli tə hiɗi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mbəzli va nashi ki na, sənay ghəshiy dzəkən Dəy Hyala gəzaŋəy Yesəw kwəma na, kə ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ma kə ngəshi ki na: «Ghala pətsa dza ghwəy kafakatəra yən Zəghwə yakə ndə ngəriy, ghalaɓa dza ghwəy sənay, yən na Ntsa nzee ghəci, pə ghwəy. Ta sənay dza ghwəy diɓa, shiy tiɓa mbaꞌee məni lə ɗi tsee njasa ɗi yaw, ya namaɓa kwəma na sa gəzə yay, war kwəma ɓanavəra Dirə na, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","War ghəy na kwa zəərə lə ntsaa ghwənara va, ka zlara na kwətiraw. Sa nzanay, ya hwəmɓa na, war kwəmaa təɓanci kee məni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma sa favə mbəzli kwəma gəzəkə Yesəw va tsəgha ki na, ɗaŋ nihwəti ɓanavə nefer shi. ");
INSERT INTO bcw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma kə Yesəw kaa *ka Zhəwifəə ɓanavə nefer shi va ki na: «Ghwəy na ghwəy kiy mbəzli niy, mbaꞌa pə ghwəy kəsəvə kwəma ɓəniŋwəy ya na mbə nefer ghwəy kataŋ kataŋəy, ka ni ya mbəzli ta səɗee dza ghwəy nza kataŋ kataŋ. ");
INSERT INTO bcw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta sənata na kataŋ na kwəma dza ghwəy. Ka kwəma kataŋ na va dzay, mbaꞌa pəlantəŋwəy səvəri mbə mevivi ka gwəra ghən tsa ghwəy ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma kə ka Zhəwifə ngəci na: «A Metər, ghəy kiy, jijihiy *Abəraham nza ghəy, səəkə ndəə mənəhwə mava tə ghəy ghala nza ghəyəw. Njaa njaa ka gha ni na: “A kwəma kataŋ na va dzaa pəlantəŋwəy mbə mevivi ka gwəra ghən tsa ghwəy ghwəy” pə ghaa?» Kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma kə Yesəw na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya wa ntsaa məni *kwəma jikir na ya hwəmɓay, mava tsa kwəma jikir na va məniy na. ");
INSERT INTO bcw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A ghwəmmə sənay, ya hwəm kiy, ka mbay məndiy ɓəlati mava, ka zəghwə kəghi mbə ndərazhi yaya niw. Ma tsa yakə məndi yaya tsa zəghwəy, ntsa kəghi na tsava ya hwəmɓa naci. ");
INSERT INTO bcw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Va tsəgha na ki, mbaꞌa pən yən Zəghwə kəghi pəlantəŋwəyəy, ghalaɓa na mbəzliy gwəra ghən tsa shi dza ghwəy nza kwagwaꞌa kwagwaꞌa ki. ");
INSERT INTO bcw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E sənay jijihiy Abəraham nza ghwəy nanzə. Ya tsəgha nzə ki na, mbə pəla pəəslira ghwəy. Sa nzana, kala zləɓavə kwəma ɓəniŋwəy ya ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yən nee kiy, dzəkən shi citəra Dirə gəzee kwəma. Ghwəy kwərakwə na, kwəma gəzaŋwəy dəŋwəy ghwəy məni» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ma kə ghəshi zləɓanci na: «Wa Abəraham na jijiŋəy sa» kə ghəshi. Ma kə Yesəw na: «Mbaꞌa pə ghwəy niy nzaa jijihiy Abəraham kataŋ nzay, ta ghəra sləni niy dza ghwəy njasa niy ghərahwə Abəraham va nza. ");
INSERT INTO bcw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vanay sana, ya tsəgha ɓəniŋwəy ya kwəma kataŋ na, njasa ɓanavəra Hyala kwagwaꞌay, mbə zhini nza ghwəy pəla kwal tsaa pəəslira ɓa. Gəla kwəma vay, səəkə Abəraham mənəhwə ghala nza naw. ");
INSERT INTO bcw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ghwəyəy, sləni ghəra dəŋwəy na sa ghəra ghwəy va» kə Yesəw. Ma kə ghəshi na: «Ghəyəy, ndərazhi yakə məndi kwa ciki kala sənay dəshim nza ghəyəw. Hyala na tsa ghəy Dəŋəy kwətiŋ» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma kə Yesəw na: «E gəzaŋwəy kwəma na, dəŋwəy kə Hyala nza kataŋ kataŋəy, ta ɗira niy dza ghwəy nza, sa nzana, va Hyala yən maɗi səəkee tikə. Ə tarəvee səəkəra sana dəꞌwə ghən tseyew, ghənzə ghwənikəra na. ");
INSERT INTO bcw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sənzənva kiy, wa shiy mənishi favə ma ghwəy kwəma ɗee na gəzaŋwəy sanaa? Sa nzana, kala mbay ghwəy fa kwəma gəzaŋwəy ya. ");
INSERT INTO bcw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sa nza ghwəy ndərazhi *ndə jaka tsa Hyala. Dzəghwa ka ɗi məni shi ɗi dəŋwəy ghwəy ki. Dəŋwəy tsa vay, ndə bəkwəpə na ghala kwataŋata na naci. Səəkə naa gəzəkəvəri na kataŋ na kwəma səvəri mbə miy tsa ci ghala nza na ya kwətiŋəw. Sa nzanay gəzə na kataŋ na kwəma vəw. Na dzərvə dzərvə na va kwəmay, ghənzə na naci gəzə kwəma sənaɓəy na mbə, sa nzana didi dzərvə ghəci. ");
INSERT INTO bcw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na nee kiy, kwəma kataŋ naa na gəzee. Va tsəgha zləɓa ma ghwəy nee va kwəma. ");
INSERT INTO bcw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wa ntsaa kəsara mbə ghwəy yən mbə məni kwəma jikir na, gar nə ghəci na: “Ava tə pətsa tsaꞌ tsa naŋee mbə məni kwəma jikir na nee” kəa? Əy kala tsəgha, war kwəma kataŋ na kə sa gəzee nay, tawa ɗi ma ghwəy zləɓa kwəmee kia? ");
INSERT INTO bcw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A na tsa Hyala ndəy, ta fa kwəma nzə va dza na. Sa nzana kala mbəzli Hyala ghwəy, va tsəgha fa ma ghwəy kwəma va» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma kə *ka Zhəwifə kaa Yesəw na: «Nay gha kataŋ kwəma gəzaŋa ghəy va, nə ghəy: “Ndə ka *Samari nza gha, zhini ndə gazlaka gha” pə ghəy kəsa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma kə Yesəw na: «Ndə gazlaka nzeyew. Yənəy, dikə na sa fee dzəti Dirə, ma ghwəy na, kala ɗi ghwəy fə dikəə dzətee. ");
INSERT INTO bcw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pəla dikee kaa ghən tsee na na yaw, a ntsaa pəlara tsee dikə tiɓa. Ntsa vay, ghəci dza naa sla ngwəvə kən mbəzli diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ə gəzaŋwəy ya, ta na navay, tsəgha na, war mbaꞌa kə ndə kəsəvə kwəma gəzee na mbə nəfə tsa ciy, ka nata məti tsava ndə naciw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma kə ka Zhəwifə ngəci ki na: «Yawaa, nana kiy, a ghəy sənay karkar, ndə gazlaka nza gha, pə ghəy. Ma kar *Abəraham ghəshi lə ka gəzə kwəma Hyala mbəradzə, mbaꞌa ghəshi bəkwəshi gwaꞌa na, ka nata məti ntsaa kəsəvə kwəma gəzee na mbə nəfə tsa ciw, pə gha na. ");
INSERT INTO bcw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ma Abəraham ghəci jijiŋəy naci ki, mbaꞌa mətiy na, war tərəŋwɓa tsa gha va dikə tsa məni gha kən tsa ci va na? Ya ka gəzə kwəma Hyala mbəradzəy pəŋw bəkwəshi ghəshi. Ndə ka wa ɓəti gha ghən tsa gha na gha kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ma kə Yesəw na: «War mbaꞌa pən fal ghən tsee dəꞌwə ghən tseyey, ka dza bamaa nza tə kwəma fal tsa vaw. Dirə tsa mə ghwəmə falra na tsee fal. Dirə tsa nə ghwəy va: “Hyala ghəy na” pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zhini kala sənay ghwəy ɓa. Yən nee kiy, e sənay. Mbaꞌa pən ni, sənay yaw, pənəy, ndə dzərvə dzee zhəghəra kwərakwə ki, njasa nza ghwəy va. E sənay ta na tsee ghən, mbaꞌee kəsəvə kwəma ci mbə nəfə tsee. ");
INSERT INTO bcw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ndə nja jijiŋwəy Abəraham tsa gəzə ghwəy tsa sanay, dalala niy vəshiy na, ta nata vici dzee təzli ti. Ma sa tsəhəy vəghwə tsa va mbaꞌa nayəy, dza na mbaꞌa vəshiy dalala» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma kə ka Zhəwifə na: «Ghaa wa nə gha, shaŋ gha ta mənti ya piya cifə mətsəkə ghala yakəŋa məndi na, hwəm nay gha Abərahamaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma kə Yesəw na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ghala məndi ghwəla ta ya Abərahaməy, yən tiɓa na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma sa favə ghəshi Yesəw zləɓakə kwəma va tsəgha na, mbaꞌa nəfə tsa shi satiy. Tapə ghəshi mbə ɓasə hərezli, ta pəꞌwə li shi. Dza Yesəw naci mbaꞌa mbəy və shi. Mbaꞌa ghəlikəvərivay səvəri mbə *ciki Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ma sa tsəhəy Yesəw geꞌi lə tsahwəti pi ghəci mbə dza na, mbaꞌa nay tsahwəti ndə, ghwəlfə ghəci, ghala yakə məndi. ");
INSERT INTO bcw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma kə *mbəzli ta səɗa ci na: «A Metər, wa shiy mənishi yakə məndi ntsa tsətsə ka ghwəlfə tay? Va na ci *kwəma jikir na ghwəlfəy na tanaa? Naa va na mənti mbəzliy yakə na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma kə Yesəw kaa zləɓanshi na: «Məniy ghwəlfə tsa kən ntsa tsa va kwəma ci jikir na, ya va na mənti mbəzliy yakəw. War ə yakə məndi tsəgha, ta mbə bərci Hyalaa civaa dzəti ngwəla kaa mbəzli, tə mbərkə kwəma ci. ");
INSERT INTO bcw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nay ghwəy na, ghala nza pi ghwəlay havəghwə, ka mbərə viciy, ghəra pə ghwəmməə ghəra sləni ntsaa ghwənikəra. Sa ka vərɗi səəkətay, ka dza ndəə mbay ghəra sləniw. ");
INSERT INTO bcw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ghala pətsa nzee tsa tikə tə hiɗi diy, yən na waŋ pi ta mbəzli tə hiɗi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma sa gəzəkə na kwəma va tsəgha na, dza na peꞌ təfati ndighwər tə hiɗi, dza hwaɗ hwaɗivəshi lə dəvə ci jəwə, mbaꞌa saɗatishi tə mətsəhi ghwəlfə tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma kə ngəci ki na: «Mbala pishə kwəma gha kwa kwəfa nə məndi va Shiləwe, kə məndi slən tsa nzə» kə. (Ma ɗi slən Shiləwe tsa vaa gəzəy, ntsa ghwənay məndi.) Mbaꞌa ghwəlfə dzay dzəghwa kwəfa va, mbaꞌa pishə kwəma ci. Ma zhəghəva naa səəkə na, ghəci mbə nay pi ɗiweŋ ɗiweŋ. ");
INSERT INTO bcw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ka ghalahiy, lə nihwəti mbəzliy niy nay ghəci mbə cəꞌwə shiy nza na, mbaꞌa ghəshi nay mbə nay pi. Sa nay ghəshi na, dza ghəshi ka ɗəɗəw kwəma kwa jipə shi, a kə ghəshi na: «Ntsa sa ka ghwəmmə vaa nay mənzəy vəgha kwal ka cəꞌwə shiy tsəy?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dzəghwa bakə mbə mbəzli təhəvərivashi ta zləɓa kwəmaa dzəkən: «Ghəci na» kə nihwəti. «Awə, ghəci naw, tsahwəti ndə na sava nzana waꞌi ghəci» kə ghəshi. Ma kə dəꞌwə ghən tsa ci ki na: «Waa yən na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma kə məndi ngəci ki na: «njaa njaa səəkə na, ghwənishi mətsəhi gha, ka nay pi gha nana shiki?» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma kə na: «Waa ntsa nə məndi va, Yesəw, kə məndi slən tsa ci hwaɗivə na hiɗi lə dəvə ci jəwə, mbaꞌa manatərashi tə mətsəhee, ma kə ngəra na: “Mbala pishə kwəma gha kwa kwəfa Shiləwe” kə. Ənkwa pən, mbaꞌee dzaa pishə. Ma sa pishə ya, tsaꞌ pən na, yən mbə nay pi tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma kə ghəshi na: «Kwəmaa ntsa va sənzənva tsəy?» kə ghəshi. «Aꞌ sənay ya nda kwəma naw» kə ntsa va. ");
INSERT INTO bcw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ma fəca vici hwaɗivə Yesəw va hiɗi jəwə, mbaꞌa saɗatishi tə mətsə ghwəlfə tsa va mbaꞌa mbəliyəy, fəca *vici dəkəva niy nza na. Dza məndi mbaꞌam pəmanakəshi ntsa va kaa *ka Farisahi. ");
INSERT INTO bcw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dzəghwa ka Farisahi kwərakwə ki, ka ɗəw kwəma va ghwəlfə tsa va, a kə ghəshi na: «A ntsa, ya sa niy nzana ghwəlfə gha niy nza kala nay piy, njaa njaa səəkə na zhini ghaa nay pi nanaa?» kə ghəshi. A kə ghwəlfə tsa va na: «Waa hiɗiy saɗati na tə mətsəhee jəwə. “Mbala pishamtishi” kə. Ma sa dzee pishishi na, mbaꞌa mətsəhee ghwənishi ɗiweŋ, ka nay pee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ꞌWakəvə nava kwəma bakə mbə tihəvəri ka Farisahi kwa jipə shi ki. Ma kə nihwəti mbəzli mbə shi na: «Ma ntsaa ghərati sləni vay, ntsa Hyala naw, mbaꞌa kəə ntsa Hyala nzay, ka dza naa məni sləni tsəgha na fəca vici dəkəva nzaw» kə ghəshi. Ma kə nihwəti na: «njaa njaa ka ntsaa kamaa ntsa Hyala mbay mənti sləni maɗaŋa maɗaŋa na va tsəghaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dzəghwa ka Farisahi va ka zhiniy ɗəw kwəma va ntsa ghwənita mətsə ci va diɓa, a kə ghəshi na: «A ntsa, njaa na kwəma gəzə ghaa dzəkən ntsaa ghwənantəŋa mətsəhi gha ni naghaa?» kə ghəshi. A kə ntsa va na: «Ma ta vəyay, ndə Hyala na, nə ya na nee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma mbəzli dikə dikə ni mbə *ka Zhəwifə nashi ghalaɓa na, ɗi zləɓa ghəshi, kataŋ niy nza ntsa vaa ghwəlfə na ghwənishi mətsəhi ci, kə ghəshi, kala war sa ghəshi ɗəwti va mbəzliy yakəw. Dza ghəshi mbaꞌa ghəshi harashi mbəzliy yakə ki. ");
INSERT INTO bcw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma sa səəkəshi ghəshi na, tapə ghəshi ta ɗəw və shi, a kə ghəshi na: «Zəghwə ghwəy na sasa kataŋ na mbəzli ni? Kataŋ kataŋ sənay ghwəy, ka ghwəlfə ghwəy yakə na? Ya sa nzana tsəghay, njaa mənti na maɗi naa nay pi sana kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma kə mbəzli va na: «A na na ghəyəy, a ghəy sənay zəghwə ghəy na, ka ghwəlfə ghəy yakə. ");
INSERT INTO bcw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma ghwəni tsa ghwənishi mətsəhi ci, maɗi na ta nay pi sanay, nda wantsaa ghwənamtishi na, sənata nava ghəyəw. Ɗəwəm nava və, dikə na gar zləɓa kwəma ghəci dəꞌwə ghən tsa ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Va wa gəzə ghəshi kwəma va tsəghay, sa nzana mbə hazləni ghəshi va mbəzli dikə dikə ni va mbə ka Zhəwifə. Sa nzana, mbaꞌa ghəshi niy gəzəti kwa jipə shi: «Ntsaa dzaa ni: “*Kəristəw Ntsa tivə Hyala na Yesəw” kəy, ta ɓanti dzam səvəri mbə ciki ɓasə va tsa ka Zhəwifə» kə ghəshi niy niy. ");
INSERT INTO bcw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Va tsəgha nə mbəzliy yakə zəghwə va va: «Ɗəwəm və, aa kəliy gar zləɓa kwəma dəꞌwə ghən tsa ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Zhini ka Farisahi daꞌ ghəshi harvə ntsaa niy nza vaa ghwəlfə, ka zhiniy ɗəw kwəma və kwa baka səɗa diɓa, a kə ghəshi na: «Ntsa, sənzənvay, kwa kwəma Hyala nza ghwəmmə, gəzə pə gha gəzəkəvəri kwəma tsərtsər. A ghəy sənay, ndə məni *kwəma jikir naa ntsa va, pə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma kə ntsaa niy nza vaa ghwəlfə na: «Am, a na neyey, sənay ya nee, nda ndə məni kwəma jikir na na, nda kala tsəgha naw. Ma na neyey, shiy kwətiŋ na shi sənashee, ghwəlfə niy yakəram, ma nanay, mbə nay pee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma kə ghəshi ngəci na: «njaa məntəŋa na tay? A shi mənti na maɗi mətsə gha vaa ghwənitaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma kə ntsa va na: «A mbəzli ni, e gəzaŋwəy kwəma na ngar nanzə məcanata gwaꞌa ɓay? A shi ɗi ghwəy ni mbə kwəma va, zhini ghwəy ɗəw bayaa? Naa, ə ɗi ghwəy məniŋwəy ka mbəzli ta səɗa ci kwərakwə shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sa gəzəkə ntsa va tsəgha na, dza ghəshi ka tsəərə, a kə ghəshi na: «Nighəvəŋəy tə gha wəzə. Gha ka na nzaa ntsa ta səɗa tsava ndə, pə gha. Lə ghəyŋəyshi na ghəyəw. Ghəy na na ghəyəy, mbəzli ta səɗa *Məyizə nza ghəy. ");
INSERT INTO bcw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","A ghəy sənay, a Hyala niy gəzanci kwəma kaa Məyizə. A na tsatsa ndəy, sənay ghəy nda dzəghwa tima təzlikəvay naw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma kə ntsaa niy nza vaa ghwəlfə na: «Kwəma maɗaŋa maɗaŋa naa nava ki, sa nzana va kala sənay pətsa səəkə na ti ghwəy, zhini mbaꞌa ghwənantəra mətsəhee? ");
INSERT INTO bcw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nanzə kiy, a ghwəmmə sənay, kar Hyalaa yəmanshi kwəma mbəzliy məni kwəma jikir naw, war ntsaa haꞌwə ti, ka məni kwəma ɗi na, na sa ka naa mananci kwəma ɗəw na. ");
INSERT INTO bcw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ghala nza ghwəmmə sana tə hiɗiy, səəkə ghwəmməə favə məndiy gəzə tsahwəti ntsaa ghwənanamti mətsə ntsa yakəm ka ghwəlfəw. ");
INSERT INTO bcw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kala va Hyala kə ntsa səəkə nzay, shi dza naa mbay mənti tiɓa ya jəw nzəw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","«Gha sa yakəm mbə kwəma jikir na, mbaꞌaŋa gha mbə paꞌ ndatsə na, zhini gha saa dzaa ɓanavəŋəy kwəma na?» kə ghəshi. Mbaꞌa ghəshi ɓanti mbə ciki ɓasəva tsa shi ki. ");
INSERT INTO bcw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ma sa favə Yesəw məndiy gəzə, a ghəshi ɓanti ntsa mbəliti na va mbə ciki ɓasəva, kə məndi na, mbaꞌa ghəshi kwəmay li. Ma kə ngəci sa kwəmay ghəshi na: «A ntsa, ɓanavə nəfə tsa gha gha kaa Zəghwə yakə ndə ngəri na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma kə ntsa va na: «A Ntsaa sləkəra, gəzara nda wa ndə na, nzee mbəə ɓanavə nəfə tsee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma kə Yesəw ngəci na: «Ava ghəci na saa gəzaŋa kwəma tsa sənzənva, yən yən sa nighə gha tsa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma sa favə na tsəgha, a kə na: «A Ntsaa sləkəra, e ndaŋa nəfə tsee» kə. Tsəfəkwə tsəfəkwəy kwa səɗa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma kə Yesəw ki na: «Ta mbə shiy zhəghəshi səəkəree dzəti hiɗi, a mbəzli ghwəlfə ghwəlfə ni nay ma pi mbəə nay pi, ma ka mətsəə nay pi na, mbər niva ka ghwəlefesliy nay ma pi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma sa favə nihwəti *ka Farisahi tiɓa vəgha Yesəw, ghəci mbə gəzə kwəma va na, tapə ghəshi ta ɗəw kwəma və, a kə ghəshi na: «Ghwəlefesli nza ghəy sana sənzənva kwərakwə tsəna?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma kə Yesəw na: «War mbaꞌa pə ghwəy: “Ghwəlefesli nzay” ka dza fətiy nza kən ghwəy nzaw. Sa nə ghwəy va ki: “Mbəzliy nay piy gə ghəy na ghəy” pə ghwəyəy, va tsəgha nza fəti kən ghwəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dza Yesəw mbaꞌa gəzəkə kwəma kwa fir, a kə na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, ya wa ntsaa dza maa dzəghwa səəmə teŋkesli kwa miy pətsaa dzəghwa səəmə, dza na mbaꞌa dzəghway tə kələm dzəghwa səəməy, ndə ghəli na tsava ndə, zhini ndə zləghwə ghəci diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma na ntsaa dzakə kwa miy pətsaa dzəghwa səəməy, ghəci na ndə teŋkesli tsa slar tsa. ");
INSERT INTO bcw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ta ghwənanamti səəmə dza ntsaa ndəghwə ghi tsa va. Ka na dza na, ka haka teŋkesli ci vaa səvəriy dzəti ngwəla, lə slən lə slən ki. Sa nzana gwaꞌa gwaꞌa teŋkesli va sənata məli ci na, war ka ɗanci fəti ghəshiy səvəri. ");
INSERT INTO bcw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ka na dza, sa ka na harkəvərishi gwanashiy dzəti ngwəla na, ka ꞌwanshi kwal, ka nəw ghəshiy dzəmti. Sa nzana, gwaꞌa ghəshi sənaɓəhwə məli ci. ");
INSERT INTO bcw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma na ntsa sənaɓəshi ma ghəshi liy, ka ɗi ghəshiy nəwəw. A ka ghəshiy hwəhwəshi və, sa sənaɓəshi ma ghəshi li» kə. ");
INSERT INTO bcw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tsəgha ɓəlanakəshi Yesəw fir tsa va. Ma ki na, favə kwəma va ghəshi nda dzəkən wa ɗi Yesəw gəzanshiw. ");
INSERT INTO bcw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zhini ma kə Yesəw ɓa na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, yən na miy pətsaa dzəghwa səəmə kəli məndi teŋkesli kwa. ");
INSERT INTO bcw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mbəzliy ꞌwakə kwal vaa səəkəshi pərɓa ghəshi kaa ngəra gwanashiy, ka ghəli na ghəshi, zhini ka zləghwə ghəshi diɓa. Sa səəkəshi ghəshi na, kala fa kwəma teŋkesli və shi. ");
INSERT INTO bcw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yən na miy dəgha. Mbaꞌa kə ndə dzakəy kwayay, a tsava ndə taa mbəliy. Ta mbə dza naa dza, ka dzakə, ka səvəriy, ka kwəmavə shi zəmə ci. ");
INSERT INTO bcw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A na ndə ghəli naci kiy, nay gha ghəci səəkəy na, war ta ghəli shiy, ka bəkwə shiy, ka laɗamtishi gwaꞌa tsəgha ka naa səəkə. Yən na nee kiy, ta mbə mbəzliy kwəmavə piy səəkəree. Piy tsa va na, ta kwa ndimndim, kala kəɗi ma. ");
INSERT INTO bcw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yən na ndə ndəghwə shiy tsa wəzə tsa. Ndə ndəghwə shiy tsa wəzə tsay, kar naa zlay piy tsa ci tə mbərkə teŋkesli ci. ");
INSERT INTO bcw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma na ndə ndəghwə shiy tsaa ndəghwə shiy war ta kwəmavə gəna ci, kala ndə ndəghwə shiy tsa kataŋ tsa ghəci, zhini kala shi ci teŋkesliy, war nay ma na dəghwava jezl tsahwəy mbə teŋkesli na, bəvbəpə ka naa hwəy zlashi teŋkesli tiɓa. Ka dəghwava jezl dza na, ka zliy dzəmbə shi, mbaꞌa zlərhəvəri teŋkesli ki. ");
INSERT INTO bcw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Va wa hwəy na tsəgha zlashi teŋkesli va kiy, sa nzana war ta gəna ghəci ndəghwə shiy gwaꞌa tsəgha, kala kwəmaa shashanci tiɓa ta teŋkesli. ");
INSERT INTO bcw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yən na ndə ndəghwə shiy tsa wəzə tsa. Njasa nzana va, mbaꞌa Dirə sənara, mbaꞌee sənay kwərakwəy, tsəgha sənashee teŋkeslee, mbaꞌa ghəshi sənara kwərakwə. Ta zlay piy tsee dzee tə mbərkə ti shi. ");
INSERT INTO bcw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A nihwəti teŋkeslee tiɓa tə ngwəlashi, kala tsəhəshi kwa səəmə diɓa. Ta dza dzee ɓasəkəshiy dzəghwa səəmə, nza ghəshi favə gaka məlee, nza ghəshi jakəshi ka garəwa teŋkesli kwətiŋ. Nzee nzaa ndə ndəghwəshi kwətira ki. ");
INSERT INTO bcw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tərəŋw ɗiti Dirə kwəmee sana, sa nzana mbaꞌee zləɓati zlanay ghən tsee kaa məti, ma nzee zhiniy zhakatira taa nza diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndə tiɓa ka mbay ɓəhwə piy tseyew. Yən lə ɗi tsee zləɓati na zlanay ghən tsee kaa məti. A bərciy zlanay ghən tsee kaa məti vəya, zhini lə bərciy zhakatira mbə məti vəya diɓa. Ava tsəgha na kwəma ndara Dirə ta mənee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sa gəzəkə Yesəw tsəgha na, dza bakə mbə *ka Zhəwifə zhiniy təhəshi, tə mbərkə kwəma ci va gəzəkə na. ");
INSERT INTO bcw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ma kə nihwəti mbəzli ɗaŋ mbə shi na: «A shiy mbə ghən ci, ndə gazlaka na, tawa fafa ghwəy kwəma ci va tay» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma kə nihwəti na: «Ka mbay ndə shi mbə ghən gəzəkə kwəma tsətsə naw. Ndə gazlaka na, mbaꞌa mbay ghwənamti mətsəhi ghwəlfə na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dza *ka Zhəwifə mbaꞌa ghəshi mənti makwaghwaa zəzəə dzəkən ghwəni *ciki Hyala tsa mbə məlmə Zherəwzalem, sa mənta vici va ki. Kəghəli, ghala tir tasli ka makwaghwa vaa nza. ");
INSERT INTO bcw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dza Yesəw mbaꞌa tsəhəy mbə tsə va. Dza na ka təwrə dzar mbə gərka nə məndi va «Gərka *Saləmaŋw» kə məndi mbə ciki Hyala tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ꞌWakəvə ka Zhəwifə ɓasə ghəshi ɓasəkəvashi, dəzlətsəɓə ghəshi tsəɓay Yesəw. Gaꞌ ghəshi ta ɗəw kwəma və, a kə ghəshi na: «A Yesəw, paꞌ hwəm dza ghaa nza mbə səəŋəy məhərli ghəy tay, wəzəɓa kəslatəŋəy gha na slən tə kwəma na, niy nza ghaa *Kəristəw ntsaa tivə Hyala va sa» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma kə Yesəw ngəshi na: «Ghala ndatsə gəzaŋwəy ya kwəma vaw, ghwəy na shiy ɗi ma zləɓa. Ya kwataka sləni ghəree na maɗaŋa maɗaŋa na lə bərci ɓəra Dirəy, mbə ndəgha fəti naa dzəkənee. ");
INSERT INTO bcw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ya tsəgha nzə kiy, ndara nefer ghwəy ghwəy, sa kama ghwəy mbə teŋkesliy yaw. ");
INSERT INTO bcw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ma ni ya va teŋkesliy, a ghəshi sənaɓəhwə nee məli. Ka nəwra tə səəbee. Mbaꞌee sənashi shi ya kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta ɓanavəshi piy tsaa kəɗi ma dzee, ka dza ghəshiy zashi tepəw. Tsahwəti ndə tiɓa dzaa mbay zləghwəhwəshi mbə dəvə yaw. ");
INSERT INTO bcw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A Dirə tsaa ndarashi va mbə dəvee taŋəti shiy gwaꞌa gwaꞌa tə dikə. Tsahwəti ndə tiɓa mbaꞌa dzaa mbay zləghwəhwə shi mbə dəvə ciw. ");
INSERT INTO bcw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na na ghəy ghəy lə Dirə kiy, ndə kwətiŋ nza ghəy» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dza ka Zhəwifə ka zhiniy imə hərezli ta pəꞌwə Yesəw li shi diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma kə Yesəw ngəshi na: «Ya sa nzana sləni wəzə na yən ghərati kwa kwəma ghwəy lə bərci ndara dirə, mbaꞌa ghwəy nata kiy, ta nama mbə kwəma va ɗi ghwəy zhiniy pəꞌwəra lə hərezli kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma kə ka Zhəwifə na: «Va sləni wəzə na mənti gha ɗi ghəy pəꞌwəŋa lə hərezliw. Ma kwəma pəꞌwəŋa ghəy tiy, sa dzəmbəŋa gha va mbə gəzə kwəma sawaa dzəkən Hyala. Ndə ngəri gha na, dza gha ka ɗi zhəghə ghən tsa gha ka Hyala» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ma kə Yesəw ngəshi na: «A məndi tsasliti mbə zliya kwəma pəhəti ghwəy, ma kə Hyalay: “Ghwəy na hyalahi” kə. ");
INSERT INTO bcw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Zhini diɓa kiy, a ghwəmmə sənay, ma kwəmaa gəzəkəvata mbə Zliya Hyalay, ka mbay ndəə bashamtiw. A Hyala fanati slən gwaꞌa kaa mbəzli ɓanakəshi na va kwəma nzə: “Ghwəy na hyalahi” kə ngəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yən sana kiy, Hyala təravəra na mbaꞌa ghwənikəra tikə tə hiɗi ni. Njaa njaa ka ghwəy ni ɓa na: “Kwəma sawaa gəzee dzəkən Hyala” pə ghwəy ki, yən patsəŋwəy kwəmaa dzəti ngwəla: “Zəghwə Hyala nzee” pən kia? ");
INSERT INTO bcw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbaꞌa kə sləni ghəratee, kala sləni Dirəy, ghalaɓa na ka ɓəra nefer ghwəy ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","War sləni Dirə karkar kə sa ghəree vay, ya kala ɓəra nefer ghwəy ghwəy na, zləɓatim sləni ghəratee va gwaꞌa tsəgha. Ghalabay, ta sənay dza ghwəy njasa nza Dirə mbə ya, yən kwərakwə na, mbee» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Zhini ka Zhəwifə tapə zhimbəshi mbə pəla kwal tsaa kəsə ci diɓa, dza na mbaꞌa mbəliy və shi. ");
INSERT INTO bcw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mbaꞌa dzaa taŋəy dzəvəri tsahwəti həlbə tsa həl Zhərdeŋ, geꞌi tə pətsaa niy məni Zhaŋ va *batem. Dza na mbaꞌa nzəyəy. ");
INSERT INTO bcw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dzəghwa ɗaŋ nihwəti mbəzli səəkəshiy dzəvəgha. A kə ghəshi na: «A ghwəmmə sənay, mənəhwə kwəma maɗaŋa maɗaŋa na Zhaŋ ya kwətiŋəw. Nanzə kiy, ya namaɓa kwəma gəzəkə naa dzar ntsa gwanata na, tsəgha ghənzə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɗaŋ mbəzli tə pətsa va ɓanavə nefer shi kaa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dza zəlghwə mbaꞌa kəsəvə tsahwəti ndə mbə məlmə Betani, Lazar, kə məndi slən tsa ci. Betani vay, məlmə nza kar Marəy va, ghəshi lə zhambəghəta Martə mbə na. ");
INSERT INTO bcw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma Marəy vay, ghənzə na maliy niy ɓasliti shiɗshiɗ Ndə sləkəpə va lə ꞌwərdi, zhini mbaꞌa niy saɗamtishi lə shiti mbə ghən nzə. Zəmbəghəta Lazar na sa gwərapəy tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dza ghəshi lə zhambəghəta bakanashi ki, ghwəni ghəshi ghwənay ndə ta dza ghəciy gəzə kaa Yesəw. A kə taa ni na: «A Ndə sləkəpə, wa vanay madigaŋa tərəy gwərapəy, kə məndi» kə taa ni. ");
INSERT INTO bcw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma sa favə Yesəw bar tsa zəlghwə tsa Lazar va ki, a kə na: «Nay kwəma zəlghwə tsa Lazar va ghwəy na, məniy zəlghwə tsa vaa zəlghwə ta mətiy ghəci və bətəw. Zəlghwə tsaa dzaa ci dikə tsa Hyala tərəŋw tsa ci, lə ta mbə məndiy fə bamaa dzəti dikə tsa Zəghwə Hyala na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesəw kiy, tərəŋw niy ɗi na kar Martə lə Marəy mbaꞌa zəmbəghəshi Lazar. ");
INSERT INTO bcw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ya tsəgha nzə, ləy hwəm sa favə na zəlghwə tsa Lazar va na, mbaꞌa mənti vici bakə diɓa tə pətsa nza na va. ");
INSERT INTO bcw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma kə kaa *mbəzli ta səɗa ci lə hwəm vici bakə na va ki na: «A mbəzli ni, zhəghəva ghwəmməə zhəti hiɗi ka Zhəwde» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma kə ghəshi na: «A Metər, a gha nay nanzə hiy hi ɗaŋ ghala səəkə *ka Zhəwifə mbə pəla pəəsliŋa lə hərezliw, zhini a ghwəmmə zhaa zhəmbə ɓa, pə gha na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma kə Yesəw na: «A ghwəy sənay tsahi məŋ lə bakə na waŋ pi mbə vici kwətiŋ. Mbaꞌa kə ndəə dza havəghwəy, ka tsati təhwəni tə səɗa ciw. Sa nzanay, mbə nay pi na, va waŋ tsa havəghwə. ");
INSERT INTO bcw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma mbaꞌa kə ndəə dza həvirəy, ta tsa dza təhwəni tə səɗa ci ghalaɓa. Sa ka na nay ma pi, sa nzana kala waŋ pi və» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tsəgha gəzanakəshi Yesəw kwemer va, zha ma kə ləy hwəm ki na: «A madigammə Lazar ɓəti hi, nanzəy, ta dza dzee fərghakati» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma kə mbəzli ta səɗa ci na: «Əy, a Ndə sləkəŋəy, ma ghənzə tsəgha tə hi kəy, ta mbəliy dza na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma na Yesəw naciy, a Lazar mətiy, na kwəma ɗi na gəzanshi. Ma mbəzli ta səɗa ci na, favə kwəma va ghəshiw, hiy ɓəhwə na kataŋ, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zhini ma kə Yesəw bazhə bazhə ngəshi na: «Wa mətiy mətiy Lazar. ");
INSERT INTO bcw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dalala vəshiree ta kwəma kən ghwəy sa mətiy na va, kala tsəhəree vəgha, nza ghwəy mbəə ndara nefer ghwəy. Nana kiy, dzamməm dzəvəgha!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma kə Təmasə tsa har məndi vaa ihwəli kaa nihwəti *mbəzli ta səɗa Yesəw na: «Dza ghwəmmə kwərakwə, a ghwəmmə dza ta bəkwə kwasəbə Ndə sləkəmmə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dzəghwa kar Yesəw lə mbəzli ta səɗa ci ki ndəs tsəhəshi mbə məlmə Betani. Ma maɗi ghəshiy tsəhə na, məndi lamti Lazar, ka mənti vici ghəci faɗə kwa kwəli. ");
INSERT INTO bcw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Məlmə Betani vay, ndəkwə ndəkwə na lə Zherəwzalem, gar kiləwmetər mahkanəy na kwa jipə shi gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dza *ka Zhəwifə, mbaꞌa ghəshi səəkəshi tiɓa ɗaŋ, ta səkwə kar Martə lə zhambəghəta Marəy, lə ta dəpanshi nefer shi va kwəma məti zəmbəghəshi va ki. ");
INSERT INTO bcw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma kə məndi kaa Martə na: «A Yesəw səəkəy, mbə səəkə na» kə məndi. Ma sa favə na na, dza na pəlhəm kafəta, ka dza ta kaꞌwə kwa kwal. Ma Marəy nanzə ki na, gwəŋəta mənzəy kəghi. ");
INSERT INTO bcw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ma sa kə ꞌwəvə Martə Yesəw ki, ma kə na: «A Ndə sləkəra, a is, mbaꞌa pə gha niy nza tiɓa nza na, ka mətiy zəmərə tsa nzaw. ");
INSERT INTO bcw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ya tsəgha nzə kiy, e sənay, ya sana nzə ɗəw gha shiy, ya nimaɓa va Hyalay, ka zlay ɓəŋashiw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma kə Yesəw ngəta na: «Ta zhəkəməy dza zəməŋa kwa kwəli pəra Martə, e gəzaŋa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma kə Martə na: «Yaŋ, e sənay ta zhəkəməy dza na kwa kwəli fəca dza nihwəti mbəreketiy səəmə kwa kwəli, fəca dza hiɗiy kərə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma kə Yesəw na: «Martə, yən na ntsaa zhini mbəzli zhakati mbə məti, ka ɓanshi piy tsaa kəɗi ma kaa mbəzliy bəkwəshi. Ntsaa ndara nəfə tsa ciy, tə ghwəməy dza naa nza, ya ə mətiy na. ");
INSERT INTO bcw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ntsa tə ghwəməy tsa diɓay, mbaꞌa kə ndara nəfə tsa na, ka məti na bətə teepəw. Zləɓavə kwəma va gha tsəgha na, pə gha sa?» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma kə Martə na: «Yə tsəgha na Ndə sləkəra, e zləɓavə, gha na *Kəristəw Zəghwə Hyala, saa niy gəzəm va dzaa səəkəə dzəti hiɗi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma sa gəzəkə Martə kwəma va tsəgha na, mbaꞌa dzaa kəsata zhambəghəta Marəy. A kə ngəta ɗahwə ɗahwə na: «A Marəy, a Metər tsa ghwəmmə səəkəy, mbə harŋa na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma sa favə Marəy kwəma va tsəgha na, pəlhəm kafəta, ka diva ta dzəvəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ghala pətsa va na, Yesəw ghwəla ta tsəhə mbə məlmə di, ghəci war tiɓay tə pətsa kwəmə Martə va li. ");
INSERT INTO bcw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma sa nata *ka Zhəwifəə niy nza va vəgha Marəy ta dəpanta nəfə tsa nzə ghənzəə səvəri lə diva na, dza ghəshi ka nəw tə səəbə. «Nda dzəti kwəli dza na ta wahə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma sa tsəhəta Marəy tə pətsa nza Yesəw va, mbaꞌa nay na, dza na tsəfəkwə tsəfəkwəta tiɓa kwa səɗa Yesəw. Ma kə ngəci na: «A Ndə sləkəra, a is, mbaꞌa pə gha niy nza tiɓa nzay, ka mətiy zəmərə tsa nzaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma sa nay Yesəw ghənzə mbə wahə, zhini tsəgha ka Zhəwifəə səəkəshi va kwasəbə mbə wawahə kwərakwə ɓa na, dza hwər tsa ci ka maɗi ta slanci ti shi tərəŋw tərəŋw, gar taŋamti bərci. ");
INSERT INTO bcw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dza na ka ɗəw və shi, a kə na: «Kwəma lamti ghwəy sənzənva tsəy?» kə. Ma kə məndi ngəci na: «A Ndə sləkəpə, vanta kwəli ci tikə, ndi natama» kə məndi. ");
INSERT INTO bcw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dzəghwa Yesəw ka wahə. ");
INSERT INTO bcw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma kə ka Zhəwifə tiɓa sa nata ghəshi nava kwəma na: «Kay, nighətim njasa ɗiti Yesəw ntsa di» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma kə nihwəti mbə shi na: «Ya sa nzana mbaꞌa ghəciy mbay ghwənamti mətsəhi ghwəlfə kiy, tawa niy daməti ma na məti va ɓə Lazara?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zhini mətsəhə hwər tsa Yesəw mətsəhəti slanci ta Lazar tiɓa tərəŋw tərəŋw, pəkw dzay dzəti kwəli. Mbə ləgwə niy nza kwəli va, mbaꞌa məndi kalay lə hərambəzli. ");
INSERT INTO bcw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma sa tsəhəy Yesəw ki, a kə kaa mbəzli tiɓa na: «Kafantim hərambəzli va mbəzli ni» kə. Ma kə Martə, zhambəghəy Lazar tsaa mətiy va na: «A Ndə sləkəpə, tawa kia! Mbə zən dza naa nza sənzənva. Sa nzanay, kwa faɗə vici ci na ndatsə ghala lamti məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma kə Yesəw na: «A Martə, niy gəzaŋee: “War ndara ma gha nəfə tsa ghay, ta nay dikə tsa Hyala dza gha?” pən sa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mbaꞌa məndi ɓanti hərambəzli va ki. Ma sa ɓanti məndi na, ꞌwakəvə Yesəw kaa kwəma ciy dzəta ghwəmə mbaꞌa kafata, tapə ta cəꞌwə Hyala, a kə na: «A Didi, ꞌwəsa nə ya ngəŋa, sa nzana, mbə fəra kwəma ɗəwee ghaa dzəghwa. ");
INSERT INTO bcw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E sənay, mbə fəra nza ghaa dzəghwa, ya hwəm diɓa. Va wa gəzee tsəghay, ta mbə mbəzliy tsəɓayra ni tikəə favə, mbaꞌa ghəshi zləɓati tsərtsər, gha ghwənikəra na, kə ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","War sa gəzəkə na kwəma va tsəgha, a kə zlaŋzlaŋ na: «Lazar, səəmə!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ꞌWakəvə mbəri mbaꞌa səəməy, pəərə pəərə shiɗshiɗ ci lə dividivi ci lə məgapa, mbaꞌa gəjer mbə kwəma ci. Ma kə Yesəw kaa mbəzli tiɓa na: «Palamtim shi va ti a ghwəy zlay dzay!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mbə *ka Zhəwifəə niy səəkəshi va ta nighə kar Marəyəy, mbaꞌa nihwəti ɗaŋ ɓanavə nefer shi kaa Yesəw sa nata ghəshi kwəma mənti na va maɗaŋa maɗaŋa na. ");
INSERT INTO bcw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma nihwəti mbəzli mbə shi na mbaꞌa ghəshi dzaa gəzanshi shi mənti Yesəw va gwaꞌa kaa *ka Farisahi. ");
INSERT INTO bcw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dza ka Farisahi lə mbəzli dikə dikə ni mbə *ka ta Hyala ɓasə ghəshi ɓasətəvashi lə *ka sləka kwəma mbə ka Zhəwifə, ta sləka kwəmaa dzəkən Yesəw. A kə ghəshi na: «njaa njaa dza ghwəmməə məni sana kia? Avanay mbə ghəra sləni maɗaŋa maɗaŋa naa ntsa tərəŋw sana. ");
INSERT INTO bcw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mbaꞌa pə ghwəmmə ni, zlay ghwəmmə, a ghəci məni sa ci tsəgha pə ghwəmmə na, mbəzli gwanashi dza naa ɓanavə nefer shi. Ma sa ka mbəzliy sləkəmmə dikə dikə ni mbə *Rəm favəy, ta səəkə dza ghəshiy dzashiy dzəmbə kwəma va, ka ghəshi dza na mbaꞌa ngəzlamti *ciki Hyala tsa ghwəmmə, kərəp zamti mbəzli mbə hwəlfə ghwəmmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma kə ndə mbə shi, Kayifə, kə məndi slən tsa ci, dikə tsa ka ta Hyala ghəci mbə piya va na: «A navam tay, ka ɗi ghwəy fə ghən ta kwəma nanzə tepəw. ");
INSERT INTO bcw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ə təkə ma ghwəy, wəzəɓa mətiy ndə kwətiŋ tə mbərkə mbəzli gwanashi na, kən na ka məndi səəkəə zamti hwəlfə ghwəmmə, pə ghwəy na?» kə ");
INSERT INTO bcw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma kwəma gəzəkə na va tsəgha nay, lə sənata kwəma ci tarəvə na gəzə nzəw. Sa nzana, dikə tsa ka ta Hyala ghəci mbə piya va, na kanambə Hyala kwəma gəzə na vaa səvəri, nja kwəma ghyaghya nzə. Va tsəgha gəzə naa dzəkən məti dza Yesəw ta mətiy tə mbərkə hwəlfə ka Zhəwifə gwanashi. ");
INSERT INTO bcw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ta mbərəkə hwəlfə ka Zhəwifə lə ndərazhi Hyala tihəvərivashi gwaꞌa mətiy na, ta ɓasətishi ta nza ghəshiy mbəzli kwətiŋ ni. ");
INSERT INTO bcw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma sa gəzəkə Kayifə tsəgha ki na, dzəghwa mbəzli dikə dikə ni mbə ka Zhəwifə mbaꞌa ghəshi sləkati kwəmaa dza ta pəəsli Yesəw fəcava ki. ");
INSERT INTO bcw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Va tsəgha zhini ma Yesəw ci ghən tsa ci dzar mbə ka Zhəwifə ghwəla. Dza na mbaꞌa dza nzəyəy mbə nahwəti məlmə ndəkwə vəgha gamba, ghəshi lə mbəzli ta səɗa ci, Efərayim, kə məndi slən tsa məlmə va. ");
INSERT INTO bcw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dzəghwa vici *makwaghwa ka Zhəwifə va ka məndiy har Pakə, mbaꞌa kətikəvata. Dza mbəzliy səəkə dzar mbə məlməhi ghənghən ghənghən, mbaꞌa ghəshi ɓasəkəvashi ɗaŋ dzəmbə məlmə Zherəwzalem, vici tsə va ghwəlaa tsəhə, ta mbə ghəshiy gwamamti vəgha shi njasa ka məndiy məni mbə kwəma jiji shi. ");
INSERT INTO bcw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dza mbəzli va ka pala Yesəw mbə mbəzli. Ma ghəshi mbə ciki Hyala ki, sa nay ma ghəshi na, dza ghəshi ka ɗəw kwəma kwa jipə shi, a kə ghəshi na: «njaa na kwəma təkə ghwəmmə tay, ta səəkə dza na ta tsə na tanaa, naa kala dzaa səəkə?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mbaꞌa mbəzli dikə dikə ni mbə ka ta Hyala, ghəshi lə ka Farisahi niy gəzəy kaa mbəzli: «Nza ndə səəkə gəzanshi, sa ka na nay Yesəw tə pətsa nza na, ma nza məndi dza kəsəhwə» kə ghəshi niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tərəmbə vici kwaŋ ta *makwaghwa Pakə ki. Dza Yesəw mbaꞌa ꞌwati kwal dzay dzəmbə məlmə Betani, dzəmbə məlmə Lazar tsaa zhinikəmə na va kwa kwəli. ");
INSERT INTO bcw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mbaꞌa məndi tanati shi zəmə ghənghən ghənghən ngəci mbəɓa. Tiɓa Lazar ghəshi lə nihwəti mbəzli mbə zəmə shi zəmə tanati məndi va kaa Yesəw ki. Ma ghala pətsa va ki na, Martə saa tsəva mbə ɓaɓanshi shi zəmə ngəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma ghəshi mbə zəmə shi va tsəgha na, mbaꞌa Marəy ɓəvə ꞌwərdi tə dimə, sa tati məndi tə *Nardə ɗewɗew, gar paf kwa magwaji ti kən, mbaꞌa dzaa ɓaslanati tə shiɗshiɗ Yesəw. Ləy hwəm sa ɓaslamtishi na na, mbaꞌa saɗanamti shiɗshiɗ ci va lə shiti mbə ghən nzə. Dza ciki tsa nza ghəshi va mbə gwanay ki, ka zən war ꞌwərdi va jaꞌ jaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma kə Zhəwdasə Isəkariyətə, tsahwəti ntsa mbə *mbəzli ta səɗa Yesəw va, saa dza va ta nga ɗafa ti na: ");
INSERT INTO bcw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«A is, tawa niy ɗəlamti ma ghwəmmə ꞌwərdi naa, pavə gəna ti gar mbəl bələkwə bələkwə mahkan, mbaꞌa ghwəmmə tahanavə kaa ka ndərma nza kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kwəma gəzə na va tsəghay, sa nzana, mbə shashanci kwəma kən ka ndərma naw. Sa nzana va, və məndiy fə gənay, nza ghəli sa ci, njasa sənaɓəy na mbə ghəli nzə nə na. ");
INSERT INTO bcw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma kə Yesəw ngəci na: «A ntsa, zlata mali va, ka gəzanta kwəma gha ma. Sləni dza məndiy məni, sa ka məndi laraa dzəghwa kwəli na sa ꞌwati na va məni, e gəzaŋa. ");
INSERT INTO bcw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma na ka ndərmay, tiɓa nza ghwəy li shi gar nganavəshi shiy ghwəy ya hwəmɓa. Na tsee ghən nee kiy, ka dza ghwəmməə nza ndimndim tikə lə ghwəyəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dza vərəm *ka Zhəwifə tərəŋw, mbaꞌa maɗiy ta dzaa dzəmbə məlmə Betani sa favə ghəshi: «Mbə məlmə va na Yesəw» kə məndi. Kwataka ta Yesəw gwaꞌa tsəgha maɗishi ghəshi diɓaw, lə ta dza ghəshiy nay Lazar tsa zhanakati Yesəw va mbə məti gəzə məndi na diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala ki, mbaꞌa ghəshi tarəkə paslamti Lazar kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Sa nzana, ɗaŋ mbəzli mbə ka Zhəwifə zlashi mbə na shi va kwəma, ka dzashi ta nəw Yesəw, mbaꞌa ghəshi ɓanavə nefer shi ngəci tə mbərkə zhəkəmə tsa Lazar va kwa kwəli. ");
INSERT INTO bcw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ma way pi tə həzlimə va, sa favə vərəm tsa ɗaŋ tsa va niy ɓasəy mbə Zherəwzalem ta tsə *makwaghwa Pakə: «Ava Yesəw mbə səəkəə dzəmbə Zherəwzalem» kə məndi na, ");
INSERT INTO bcw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ꞌwakəvə ghəshi tsəgha ka kəsli bali, ta slikwə dividivi slərpə ta dəvə shi, ka dzashi ta kaꞌwə Yesəw kwa kwal. Dza ghəshi ka ngwəmə lala zlaŋzlaŋ, a kə ghəshi na: «ꞌWəsa kaa Hyala! Təfanati miy tsa nzə Hyalaa sləkəpə kaa ntsaa səəkəy tsa mbə slən tsa nzə! Təfanati miy tsa nzə Hyala kaa mazə tsa ka *Izərayel tsa!» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dza Yesəw ndəs kəsata kwantəmca, taram dzəməy mə, ka dzaa dzəmbə Zherəwzalem, nja kwəma gəzəkə məndi va mbə Zliya Hyalaa dzəkən, a kə məndi na: ");
INSERT INTO bcw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","A mbəzli mbə məlmə *Shiyaŋw, əntaa ghəy hazləni ma! Ava ghwəy nay mazə tsa ghwəy, dallə mə zəghwə kwantəmca mbə səəkə, kə məndi. ");
INSERT INTO bcw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ghala pətsa məniva shi vay, niy favə kwəma ɗi ghəshi gəzə mbəzli ta səɗa ci diw. Ma ləy hwəm sa dzay Yesəw dzəmbə dikə tsa ci va Hyala mə ghwəmə ki na, mbaꞌa ghəshi zəzəvə. A kə ghəshi na: «Ma shiy niy məni mbəzli va kaa Yesəwəy, a məndi niy gəzəkəshi tsəghaa dzəkən mbə Zliya Hyala va sham» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ghala pətsaa har Yesəw va Lazar səəmə kwa kwəli, mbaꞌa zhanakati mbə məti kiy, vərəm ɗaŋ niy nza na tiɓa. Mbaꞌa ghəshi niy slanakəshi shiy niy nashi ghəshi kaa nihwəti mbəzli kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Va tsəgha ɓasəkəvay ndə ngəri ɗaŋ tsəgha ta kaꞌwə Yesəw ki. Sa nzana mbaꞌa ghəshi favə kwəma maɗaŋa maɗaŋa na məni na. ");
INSERT INTO bcw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma kə *ka Farisahi kwa jipə shi ki na: «Njaa dza ghwəmməə məni kia? Shi dza ghwəmməə ghakə tiɓa ghwəla ya jəw nzəw. Ava mbəzli gwanashi maɗiy dzashi ta nəw kwəma ci» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mbə mbəzliy niy ɓasəkəvashi vaa dzəmbə məlmə Zherəwzalem ta pəraꞌwə dividivi shi kaa Hyala geꞌi lə vici *makwaghwa Pakəy, a nihwəti ka Gərekə niy nza na mbə shi. ");
INSERT INTO bcw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ghavə ghəshi, ghəshi ka Gərekə va, mbaꞌa ghəshi səəkəshiy dzəvəgha Fəlipə, ndə ka Betəsayda tə hiɗi ka Galile, ma kə ghəshi ngəci na: «A ntsa dikə tsa, a ghəy ɗi kwəmay lə Yesəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dza Fəlipə mbaꞌa dzaa gəzanci kaa Andəre. Dza ghəshi bakanashi mbaꞌa ghəshi dzaa gəzanci kaa Yesəw: «Ava məndiy ɗəwŋa» kə ghəshi ki. ");
INSERT INTO bcw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma kə Yesəw kaa zləɓanshi na: «Nana kiy, a vəghwə tsa va məniy, ta fəva dikəə dzətee, yən Zəghwə yakə ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ə gəzaŋwəy ya, ta na navay, tsəgha na, kala ɓəvə hwəlfə ha kə ndə, mbaꞌa tsaŋwambə mbə hiɗiy, kwətiŋta ka naa nza, ka mətsəhəw. War məndi tsaŋwambə na mbə hiɗi, mbaꞌa pəsəta ka naa gha səghəta ɗaŋ. ");
INSERT INTO bcw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tsəgha na lə ke ngəri kwərakwə. Ntsaa njəɗi piy tsa ci tikə tə hiɗiy, ta zay dza piy tsa tsava ndə. Ma ntsaa njəɗi ma piy tsa ci tikə tə hiɗi na, ta kwəmavə piy tsaa kəɗi ma dza na. ");
INSERT INTO bcw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","War mbaꞌa kə ndəə ɗi nza ka ndə ghəraɗa sləniy, nəw kə ntsa vaa nəwra. Nza ndə ghəra sləni tsee nzəy tə pətsa dzee nza kwərakwə. Ma ntsaa ghəraɗa sləni kiy, ta falti kwəma ci dza Dirə tərəŋw diɓa» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zhini ma kə Yesəw ɓa na: «Sanay, a məhərlee səəta. Wəzəɓa njaa məntee bay tay? Wəzəɓa nə ya kaa Dirə: “A Di, mbəlantəra səvəri mbə ngəraꞌwə tsa dzee tsa ta sa” pən ta na? Tiɓaw, war ta sa ngəraꞌwə tsa dzee tsa ta sa səəkəree. ");
INSERT INTO bcw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“A Di, fə bamaa dzəti slən tsa gha” nə ya» kə. Dzəghwa, ma kə gaka məli ndə kaa zləɓanci kwəma səəkə mə ghwəmə ki na: «E fati bama ti, ta zhini dzee mətsəhə fəə dzəti ka yəwən diɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma kə vərəm tsa tə pətsa va gwaꞌa sa favə na gaka məli va na: «Fam məli van sa gərgərəy na» kə ghəshi. Ma kə nihwəti mbə shi na: «Am, awə, məli *ndə kwal tsa Hyala na sava gəzanci na kwəma» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma kə Yesəw na: «Ma gaka məli favə ghwəy vay, ta kwəmee səəkəta naw, əhəŋ, war tə ghwəy na. ");
INSERT INTO bcw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Avanay vəghwə tsa dza Hyalaa ɓasə ngwəvəə dzəkən mbəzli tə hiɗi ti ki. War sənzənva dza na ta ɓanti mazə tsa tə hiɗi ni tsa. ");
INSERT INTO bcw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ghala pətsa dza məndi vaa kafara vəgha tsəməy, ta harəhwə mbəzli dzee dza gwaꞌa gwaꞌaa dzəvəghee» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ma mbə kwəma gəzəkə na va tsəgha na kiy, ciy citəpə na gəla məti dza na ta məti. ");
INSERT INTO bcw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma kə vərəm tsa tiɓa va ngəci na: «Sa ka *Kəristəw Ntsa tivə Hyala səəkəyəy, war tiɓa dza naa nza tə ghwəmə ta kwa ndimndim, kə kwəma ɓənivə ghəy mbə zliyahi kwəma ghəy pəhəpəhə na. Zhini ma pə gha ɓa na: “Ghala pətsa dza məndiy kafay Zəghwə yakə ndə ngəriy dzəvəgha tsəm” pə gha. A ndə na Zəghwə yakə ndə ngəri tsa va diɓa kia?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma kə Yesəw na: «A mbəzli ni, nana diy, ghwəlay na waŋ pi mbə ghwəy ta vici jəw. Mbatsəm dza ta waŋ pi tsa va, vantaa kwəsli səəkəə kəələhwəŋwəy. Sa nzanay, ntsaa dza mbə kwəsli na, ka sənay na dzəghwa tə pətsa kəɗi na səɗa ciw. ");
INSERT INTO bcw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Va tsəgha kiy, wəzəɓa zləɓavə ghwəy waŋ pi tsa va ghala pətsa nza na tsa ghwəlay lə ghwəy di. Ta mbə ghwəy zhəghəŋwəy ka mbəzli mbə waŋ pi» kə Yesəw. Ma sa gəzamti Yesəw kwəma va tsəgha na, mbaꞌa dzay kərakə, dzaa mbəy və shi. ");
INSERT INTO bcw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɗi ghəshiy ɓanavə nefer shi kaa Yesəw, ya tsəgha nzana, mbaꞌa ghəci məmənəhwə shi dimədimə ni ɗaŋ kwa kwəma shiw. ");
INSERT INTO bcw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ma mənti ghəshi tsəghay, ta mbə kwəma niy gəzəkə ndə Hyala *Ezay va mbə zliyaa dzəghwata kwa, a kə niy niy: A Hyala kwa sləkəpə, wa ntsaa zləɓa kwəma gəzə ghəy kia? Kaa wa cinti gha bərci kəətipə gha li kia Ndə sləkəpə? kə Ezay niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Zhini ɓa mbaꞌa Ezay gəzəkə nda sa wana ɓanavə ma ghəshi nefer shi kaa Yesəw, a kəy: ");
INSERT INTO bcw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A Hyala ghwəlfay mətsəhi shi, mbaꞌa dəŋɗay məhərli shi. Tawa ghwəlfay na mətsəhi shiy, əntaa ghəshi nay pi. Tawa dəŋɗay ma məhərli shiy, vantaa ghəshi sənata kwəma, «Zhini əntaa ghəshi zhiniy zhəghəvaa səəkəə dzəvəghee, gar mbayee zhiniy mbəlantishi diɓa» kə Hyala, kə Ezay. ");
INSERT INTO bcw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sa wana gəzə Ezay kwəma va tsəghay, sa nzana, mbaꞌa ghəci nay dikə tsa məni Yesəw. Na gəzə na kwəmaa dzəkən tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ya tsəgha nzə kiy, ɗaŋ niy nza nihwəti mbə mbəzli dikə dikə ni mbə ka Zhəwifə, mbaꞌa ghəshi ɓanavə nefer shi kaa Yesəw. Kala ɗi ci ghən tsa shi ghəshiy səvəri bazhə bazhə. Sa hazləni ghəshi va *ka Farisahi, vantaa ghəshi ɓantishi səvəri mbə ciki ɓasəva tsa shi. ");
INSERT INTO bcw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sa nzana ɗiɓa fal tsa falshi ke ngəri ghəshi niy ɗi kaa fal tsa Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dza Yesəw ka gəzə kwəma zlaŋzlaŋ, a kə na: «Favə tə ghwəy, ya wa ntsaa ndara nəfə tsa ciy, kaa ngəra kwətira ndara na nəfə tsa ciw. Aa ɓanavə nəfə tsa ci kaa ntsaa ghwənikəra kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mbaꞌa kə ndə naray, a ntsa va nay ntsaa ghwənikəra kwərakwə ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yənəy, nja waŋ tsaa mbərə kaa mbəzli səəkəree tikə tə hiɗi. Vantaa ntsaa ndara nəfə tsa ci nzəy mbə kwəsli. ");
INSERT INTO bcw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","War mbaꞌa ndə favə kwəma gəzee, dza na kala ɗi fəti ghəci tiy, yən dza naa ɓanci fəti na tsee ghənəw. Sa nzanay, səəkəree ta ɓasə ngwəvəə dzəkən mbəzli tə hiɗi niw, war ta mbəlishi səəkəree. ");
INSERT INTO bcw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma ntsaa zhiniɗa ghən kala ɗi zləɓa kwəmee ghəciy, a ntsaa dzaa ɓasə ngwəvəə dzəkən tiɓa. Kwəma gəzee na dza naa sla ngwəvəə dzəkən ndə fəca dza hiɗiy kərə. ");
INSERT INTO bcw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sa nzanay, nahwəti kwəma tarəvee gəzəkə lə bərcee tiɓaw. War kwəma Dirə tsaa ghwənikəra va na sava. Ghəci ka naa gəzara kwəma, ma kee gəzə ya na kee canshi kaa mbəzli nzə gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kwəma gəzaŋwəy na va məni nzəy, e sənay, kwəmaa dzaa ɓəŋwəy piy tsaa kəɗi ma na. War kwəma gəzəkəra Dirə dzee gəzə gwaꞌa tsəgha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dzəghwa ki, sa tərə hi kwətiŋ ta vici *makwaghwa Pakə ki na, mbaꞌa Yesəw sənay tsəgha, vəghwə tsa ci na sava səəkəy na ta ɓarvay ghəciy zlashi hiɗi ni, ta dzay dzəmə ghwəməə dzəvəgha Dəy, kə. War mbə ɗi mbəzli ci tikə tə hiɗi ni ghəci niy nza ki, war tsəgha ghəci mbə ɗishi paꞌ tə kwa kərni vici. ");
INSERT INTO bcw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma hetihwer va na, mbaꞌa kar Yesəw lə mbəzli ta səɗa ci ɓasəshi ta zəmə shiy, ghalaɓay *ndə jaka tsa Hyala fanambə kwəma nga ɗafa ta Yesəw mbə nəfə tsa Zhəwdasə, zəghwə Shimaŋw Isəkariyətə na naci ki. ");
INSERT INTO bcw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma na Yesəw na, aa sənay naci, sa nzana, ntsaa səəkə vəgha Hyala ghəci, zhini ta zhəghəva ghəci dzaa zhəvəgha diɓa. Aa sənay a Hyala zlatanavə shiy gwanashi ngəci mbə dəvə ci, kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ꞌWakəvə na kaf kafəy sati tə pi zəmə shiy, dza na kwərat səramti tsahwəti kwəbaŋ kən ghən ci laŋ ɓəvə kadibəl, mbaꞌa pəhəti təti ci. ");
INSERT INTO bcw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dza na nganə tivə yam kwa tasaw, mbaꞌa ghati yaɓanshi shiɗshiɗ mbəzli ta səɗa ci li shi. Saɗamtishi saɗamtishi ghəci kaa shiɗshiɗ shi va lə kadibəl tsa titi ci va. ");
INSERT INTO bcw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma sa tsəhəy na tə Shimaŋw Piyer ki, tsaꞌ kə ta yaɓanci shiɗshiɗ ci na: «A Ndə sləkəra, a gha yaɓəra shiɗshiɗee, pə gha na? Əm, tiɓaw!» kə Shimaŋw. ");
INSERT INTO bcw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma kə Yesəw na: «A Piyer, kadiw na gha di. Ma kwəma nata gha na yən məni sənzənvay, ka dza ghaa mbay favə nana diw. Ma kwa kwəma jəwəy, ta favə dza gha» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma kə Piyer na: «Am, awə, ya tsəgha nzəy, zləɓatee na nee ghaa yaɓəra shiɗshiɗ yaw» kə. Ma kə Yesəw na: «Ma ghənzə tsəgha, gha kala zləɓati yən yaɓəŋa shiɗshiɗ ghay, ə ɗi ma gha kwəmavə ya nimaɓa shiy vəya» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma kə Shimaŋw Piyer sa gəzəkə Yesəw tsəgha na: «Ma ghənzə tsəghay Ndə sləkəray, ka dza naa nza war shiɗshiɗee shi dza ghaa yaɓəra gwaꞌa tsəghaw, wəzəɓa yaɓəra gha lə dividivishi, lə ghən tseyey gwaꞌa na» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma kə Yesəw na: «Na ntsaa pishivay gwanata vəgha ci ɗewɗewəy, ka maw məndiy pi ghwəla gwanata vəgha ciw. War pəshanamti ma məndi shiɗshiɗ ciy, mək na tsəgha. Ghwəyəy, ɗewɗew nza ghwəy. Nanzə kiy, ghwəy gwanaŋwəy na ɗewɗewəw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sa nzana, mbaꞌa sənay lə ntsaa dzaa nga ɗafa ti tiɓa mbə shi, va tsəgha gəzə na: «Ghwəy gwanaŋwəy na ɗewɗewəw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dza Yesəw sa kəɗiy na lə pi shiɗshiɗ mbəzli ta səɗa ci, mbaꞌa zhanakən kwəbaŋ tsa ci, das nzəyəy tə pi zəmə shiy. Ma kə kaa ngəshi na: «Favə gəla kwəma məntəŋwəy ya na ghwəy na? ");
INSERT INTO bcw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ghwəy dəꞌwə ghən tsa ghwəy ka naa ni: “A Metər” pə ghwəy, zhini “A Ndə sləkəŋəy” pə ghwəy ni ngəra. Tsəgha ghənzə kataŋ ɓa, sa nzana, Metər tsa ghwəy yən, zhini Ndə sləkəŋwəy yən ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Njana nzana, yən Ndə sləkəŋwəy, zhini yən Metər tsa ghwəy, dzəghwa ka yaɓəŋwəy shiɗshiɗ ghwəyee kiy, tsəgha ka ghwəy məməni kwa jipə ghwəy kwərakwə ki, ka yayaɓə shiɗshiɗ ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kwal na sava citəŋwəy ya, ma nza ghwəy mbəə məni tsəgha kaa ghən tsa ghwəy njasa məntəŋwəy ya va kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ndə ghəra sləni tsaa taŋəti ntsa ghəranci na va sləni tiɓa tə dikəw, ka mbə ntsa ghwəni məndiy taŋəti ntsaa ghwəni tə dikəw, ava tsəgha na. ");
INSERT INTO bcw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sana sənzənvay, a ghwəy sənata kwəma va gwaꞌa. Mbəzli təfanatishi Hyala miy dza ghwəy nza, ghwəy kə fəti ghən ta məni nzə. ");
INSERT INTO bcw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ya tsəgha nzəy dzəkən ghwəy gwanaŋwəy gəzee kwəma vaw. E sənashi nefer ni təratee va mbəzli. Əy ma diɓa na, wəzəɓa nza na mbaꞌa kwəmaa gəzəva va mbə zliya dzəghwata kwa na. Saa ni va: “Ntsaa zəmə ghəy ɗafa li kwa kwakwa tsa kwətiŋ tsa zhiniy məniy ka ndə ghəra tsee” kə, kə məndi. ");
INSERT INTO bcw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ə gəzaŋwəy ya sənzənvanata ghala vici va ghwəla ta məniva. Sa ka shi va mənishi kiy, ma nza ghwəy mbəə sənay, yən na ntsa nzee ghəci, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ə gəzəŋwəy ya, ta na navay, tsəgha na, ma ntsaa zləɓavə ntsa ghwənay yay, yən dəꞌwə ghən tsee na sa zləɓavə na va kwərakwə. Ntsaa zləɓavəra na, ntsaa ghwənikəra va na sa zləɓavə na kwərakwə ɓa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ləy hwəm sa gəzəkə Yesəw kwəma va tsəgha na, mbaꞌa məhərli ci səəta. Gaꞌ ghəci ta gəzə kwəma, a kə na: «Ə gəzaŋwəy ya, ta na navay, tsəgha na, a tsahwəti ndə mbə ghwəy kwətiŋəy, ta nga ɗafa dza na tə ya, ta kəsəra məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mbaꞌa mbəzli ta səɗa ci ghati nighəva kwa jipə shi, ka ɗəɗəw kwa jipə shi nda dzəkən tsama mbə shi gəzə Yesəw kwəma va. ");
INSERT INTO bcw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mbə mbəzli ta səɗa ci va kiy, a ntsa ɗi na niy nza tiɓa vəgha. ");
INSERT INTO bcw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Gaꞌ Shimaŋw Piyer ta məlaꞌwə gəzanci kaa ntsa ɗi Yesəw va lə mətsə, a ghəci ɗəw kwəma va və, nda dzəkən tsama ndə mbə shi gəzə na kwəma va. ");
INSERT INTO bcw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dza ntsa va kwərakwə ki, kət kətəghəvay dzəvəgha Yesəw, ka ɗəw, a kə na: «A Ndə sləkəŋəy, tsama ndə na savaa?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma kə Yesəw na: «Kadiw, avee taa nga peŋ ta mbəzə er dzəti ta ɓanci kaa ndəy, ntsa dzee vaa ɓanciy, ghəci na» kə. ꞌWakəvə na, baꞌwə ngavə peŋ ki, dza bəkə mbəzəvə er ti, tsaŋ ɓanavə kaa Zhəwdasə, zəghwə Shimaŋw Isəkariyətə. ");
INSERT INTO bcw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","War sa ɓəvə Zhəwdasə peŋ tsa va tsəgha na, gwaꞌa, mbaꞌa ndə jaka tsa Hyala dzay dzəmbə nəfə tsa ci. Ma kə Yesəw ngəci ki na: «A Zhəwdasə, ca mbata gha taŋtaŋ, məni kwəma tarə gha va məni nzə!» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dzəghwa hashi, mbəzli nza ghəshi li shi mbə zəmə shiy hashishi, ntsaa sənay tiɓa nda tawa gəzanci na kwəma va tsəgha ngəciw. ");
INSERT INTO bcw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma kə zəzə kwəma nihwəti mbəzli mbə shi na: «Nda sa nzana va, Zhəwdasə ntsa fə ghəshi gəna və, na gəzanci Yesəw a ghəci dza ta pa shi ɗi ghəshi ta kwəma *makwaghwa Pakə, aw na, a Zhəwdasə ɓanshi nihwəti shiy kaa mbəzli ka ndərma bərkee shiki» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ma Zhəwdasə naci ki, war sa ɓəvə na peŋ tsa nganati Yesəw vaa dzəti dəvə ci tsəgha na, nzaꞌjəw del səvəriy. Pi həvir na ghalaɓa. ");
INSERT INTO bcw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma sa səvəriy Zhəwdasə ki, ma kə Yesəw kaa niy tərmbə mbəzli tiɓa ki na: «Nana kiy, a dikə tsa mənee yən Zəghwə yakə ndə ngəri cikəvərivay tə ngwəla, mbaꞌa məndi sənay dikə tsa Hyalaa səvəri mbə ya diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Njana nzana mbaꞌa dikə tsa Hyala citəvay səvəri mbə ya tsəgha kiy, ta citəpə dikə tsee yən Zəghwə nzə dza Hyalaa dzaa səvəri mbə dəꞌwə ghən tsa nzə, sənzənvanata, ka dzaa nzay nzaw. ");
INSERT INTO bcw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A ndərazhi ya, vəghwə jəwə tsətsə tərə nzəy tsa ghwəmmə lə ghwəy. Ma ləy hwəm jəwəy ta palara dza ghwəy. Avee taa zhiniy gəzaŋwəy kwəma nja kwəmaa niy gəzəhwee va kaa *ka Zhəwifə diɓa, sa niy nə ya va ngəshi: “Ka dza ghwəy mbay tsəhəŋwəy tə pətsa dzee vaa dzaw” pən. ");
INSERT INTO bcw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sana sənzənvay, avee taa gəzaŋwəy nahwəti kwəma ꞌwarꞌwar na, nza ghwəy məni: Ɗim ghən tsa ghwəy kwa jipə ghwəy. Njasa ɗiŋwəy ya vay, tsəgha pə ghwəy ɗi ghən tsa ghwəy kwa jipə ghwəy kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mbaꞌa a pə ghwəy ɗi ghən tsa ghwəy tsəghay, ghalaɓa na ta sənay dza məndi, mbəzli ta səɗee nza ghwəy, kə məndi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dzəghwa Shimaŋw Piyer ka ɗəw kwəma va Yesəw, a kə na: «A Ndə sləkəŋəy, kwəma dza gha ta dzaŋa baya?» kə. Ma kə Yesəw ki na: «Ta dzara dzee, pətsa dzee va ta dzətiy, ka dza gha nəwvəraa dzəti nana diw. War kwa kwəma dzaa nza» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma kə Piyer na: «Wa shiy mənishi nə gha: “Ka dza gha nəwvəra nana diw!” pə gha kia? Gwaꞌa gwaꞌa gwəmantəvaree ta ndəghə ya kwəma gar məti ndə mbə na na, war yaŋ, pən taa ni, tə mbərkə kwəma gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma kə Yesəw na: «Zlata nava kwəma di! Kataŋ gwəmantəvaŋa gha sana ta zləɓa ya məti tə mbərkə kwəmee na? Ə gəzaŋee, ta na navay, tsəgha na, ndatsə ka ngələkə gha way, gha zhənti vəraslə: “Sənay tsava ndə yaw, sənay tsava ndə yaw” pə gha, mahkan səɗa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A kə Yesəw kaa mbəzli ta səɗa ci na: «Ka dza her ghwəy ma, ɓanavəm nefer ghwəy kaa Hyala, mbaꞌa ghwəy ndara nefer ghwəy diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ma mə ghwəmə kəghi tsa Dirəy, ɗaŋ na pi nzəy məɓa. Ta dzara dzee dzəmə ta gwəmantəŋwəy pi nzəy. Mee kala pi məɓa tsəgha nzay, ka dzee gəzaŋwəy na: “Ta dza dzee ta gwəmantəŋwəy pi” pənəw. ");
INSERT INTO bcw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma sa kee dza mbaꞌee dzəmə gwəmantəŋwəy pi gwaꞌa kiy, ma nzee zhəghəvaa zhəkə ki, ta pəməŋwəy dzəməə dzəti pətsa dzee vaa nza. Ta mbə ghwəy nzəy kwərakwə vəghee tə pətsa nzee. ");
INSERT INTO bcw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A ghwəy sənay kwal tsaa dzaa dzəti pətsa dzee va kwərakwə» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma kə Təmasə na: «A Ndə sləkəpə, a sənay ghəy dzəti pətsa dza ghaw na, njaa njaa ka ghəy sənay kwal nə gha shəka?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma kə Yesəw na: «Yən na kwal tsa kataŋ tsa, sa dza mbəzliy kwəmavə piy tsaa kəɗi ma kwa. Tsahwəti ndə tiɓa dzaa tsəhə vəgha Dirə Hyala mə ghwəmə, kala war dzar kweyew. ");
INSERT INTO bcw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mbaꞌa pə ghwəy sənara kiy, ta sənay Dirə dza ghwəy dza ghalaɓa kwərakwə ki. Ya sana sənzənvanata tala na, a ghwəy nay, mbaꞌa ghwəy sənay» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma kə Fəlipə na: «A Ndə sləkəŋəy, citəŋəy Didi tsa va, war məkəŋəy dza navaa nza tsəgha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma kə Yesəw ngəci na: «Njaa pə ghaa Fəlipəə? Mbəradzəmmə ghwəmmə lə ghwəy na, kala sənara gha na? A sənay ma gha, ntsaa nara na, aa nay Didi, pə gha shəkəna? Njaa njaa ka gha zhiniy gəzə na: “Citəŋəy Didi tsa va” pə gha diɓa kia? ");
INSERT INTO bcw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wa ə zləɓati ma gha kwəma nza tsa nza na, yən na mbə Dirə, Dirə kwərakwə na, mbə ya ghəci na? Kwəma nja sa kee naa gəzaŋwəyəy, vəya dəꞌwə ghən tsee səəkə naw. Ma shi mənee vay, Dirə mənishi na mbə ya, sa nzana mbə ya ghəci. ");
INSERT INTO bcw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Zləɓatim kwəma gəzaŋwəy ya va, sa nə ya va: “Ka ndə kwətiŋ məniŋəy ghəy lə Dirə, mbəya ghəci, dzəghwa mbee kwərakwə” pən. Kala tsəgha na, mbaꞌa ghwəy zləɓati tə mbərkə sləni ghəree na tala tala. ");
INSERT INTO bcw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ə gəzaŋwəy ya, ta na navay, tsəgha na, ntsaa ndara nəfə tsa ciy, ta ghəra sləni dza na njasa ghəree na. Zhini tərəŋwɓa na ci va sləni dza naa ghərahwə dzaa nza diɓa. Sa nzanay, ta dzara dzee dzəvəgha Dirə. ");
INSERT INTO bcw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ghalaɓa ki ya nimaɓa shiy dza ghwəy ɗi ɗəw lə slən tseyey, ta ndaŋwəy shi dzee dza. Ta mbee cinti njasa nza dikə tsa Dirə kaa mbəzli. ");
INSERT INTO bcw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","War mbaꞌa pə ghwəy ɗəw shiy vəya mbə slən tseyey, ta məniŋwəy shi dzee» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ma kə Yesəw diɓa na: «War mbaꞌa pə ghwəy ɗitəra tsərtsərəy, ta ɗi fəti dza ghwəy ta kwəma gəzaŋwəy ya. ");
INSERT INTO bcw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta cəꞌwə dzee dza va Dirə a ghəci ghwənikəvəŋwəy tsahwəti ndə ta kəətiŋwəy, Safə tsa ci ɗewɗew tsa. Ma nza ghəci nzəy tiɓa lə ghwəy ya pa hwəmɓa. ");
INSERT INTO bcw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Safə tsaa cipə na kataŋ na kwəma. Ma na mbəzli tə hiɗi na nashi kiy, ka kwəmavə ghəshi, sa nay ma ghəshi mbaꞌa sa sənay ma ghəshiw. Ghwəy ta na tsa ghwəy ghən kiy, a ghwəy sənay wəzə. Sa nzana ntsa mbə ghwəy ghəci, mbə nzəy ghəci jakəjakə lə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ya tsəgha nzəy, ka dzee dzaraa zlaŋwəy kwətiŋwəy nja məzhititiw. Ta zhəghəva dzee zhikəə zhəvəgha ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kwa kwəma jəwəy, ka dza mbəzli tikə tə hiɗiy naraw. Ghwəy na na ghwəy kiy, ta nara dza ghwəy dza. Sa nzanay, mbə piy nzee. Dzəghwa mbə piy ghwəy taa nza kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ghala pətsa va sa ka vəghwə tsa va tsəhəyəy, ta sənay dza ghwəy mbə Dirə nzee, mbaꞌa ghwəy mbə ya, zhini yən na mbə ghwəy, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ma ntsaa fəti ghən ta kwəma gəzəkee, dza na mbaꞌa kəsəvə ka ɗi fəti tiy, tsava ndə na saa ɗira. Ta ɗi ntsaa ɗira dza Dirə kwərakwə ki, zhini tsəghee dzaa ɗi ɓa. Ghalaɓa ki na, ta cinti ghən tsee dzee kaa tsava ndə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ma kə tsahwəti ntsa har məndiy Zhəwdə, mbərəkəy Zhəwdasə Isəkariyətə na: «A Ndə sləkəpə, njaa njaa dza nava kwəmaa məniva dza ghaa citi ghən tsa gha kaa ngəŋəy, ma nihwəti mbəzli tə hiɗi na, kala dza ghəshiy mbay naŋa nashi kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma kə Yesəw na: «Ma ntsaa ɗiray, a ta kəsəvə kwəma gəzəkee, ka ɗi fəti ti. Ta ɗi ntsa va dza Dirə. Ghəy lə Dirəy, ta səəkə dza ghəy və, ta nzəy ghəy lə kar ntsa va gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma na ntsaa ɗira may, ka ɗi fəti na ta kwəma gəzə yaw. Kwəma nja kwəma nzee na mbə gəzə nzə sana favə ghwəyəy, kwəma gəzee dəꞌwə ghən tsee naw, kwəma gəzə Dirə tsaa ghwənikəra va tikə na sava. ");
INSERT INTO bcw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ə gəzaŋwəy ya shi va gwanashi, ghala vəghwə tsa nzee ghwəlara mbə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ləy hwəm shi vay, a Dirə dzaa ghwənikəŋwəy Safə tsa ci ɗewɗew tsa ta kəətiŋwəy. Ma nza ghəci ɓəniŋwəy kwəma va gwanata, ka zəzəŋwəy nahwəti kwəma gəzaŋwəy ya gwanata. ");
INSERT INTO bcw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Avee zlaŋwəy mbə zərkə, zərkə tsee na sa ndaŋwəy ya va. Njasa ka mbəzli tə hiɗi vaa ɓə kaa mbəzli ɓəŋwəy ya tsee zərkəw. Ka dza her ghwəy ma, ka hazləni ghwəy ma. ");
INSERT INTO bcw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Njasa niy favə ghwəy va yən gəzaŋwəy: “Ta maɗi dzee dzara, nanzə kiy, ta zhini dzee zhəghəvaa zhəkəə dzəvəgha ghwəy” pən niy niy, mbaꞌa pə ghwəy ɗira na, ta vəshi dza ghwəy tərəŋw, sa dzee ta dzaa dzəvəgha Dirə. Sa nzanay, a Dirə taŋətəra tə dikə. ");
INSERT INTO bcw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ə gəzaŋwəy ya kwəma va sana ghala nanata di. Ma sa ka na mənta ki na, nza ghwəy mbəə zləɓavə kwəma va. ");
INSERT INTO bcw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ka zhinee gəzəhwə kwemer lə ghwəy ghwəla ɗaŋ ɗaŋəw, sa nzanay, mbə səəkə na mazə tsaa sləkə hiɗi ni. Bərci vəə dzəkən yaw. ");
INSERT INTO bcw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ya tsəgha nzə kiy, wəzəɓa sənay mbəzli tə hiɗi gwanashi, e ɗi Dirə tərəŋw, mbə məni shi gəzara na nzee gwaꞌa, kə ghəshi. Satim dzamməm tikə!» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ma kə Yesəw ɓa na: «Yən na dəŋw fə tsa kataŋ tsa. Dirə na, ndə za tsaa sləkə vəh fəhi va. ");
INSERT INTO bcw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma dəvəə dzaa yati ma ya, mbə dividiviy dzaa hashi tə ya gwaꞌay, ta kəslamtishi dza Dirə səkwa tə ya. Ma naa dzaa yati ya dəvə na, ka na dza mbaꞌa gwəmati slahə nava dəvə wəzə ki, nza ghənzə mbəə gwəmavə ya na wəzə na ya, taŋ na kwa taŋa va. ");
INSERT INTO bcw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma ghwəy sana kiy, mbəzli gaga ni, gwəma gwəma ni, nza ghwəy gwanaŋwəy, tə mbərkə kwəma ɓanavəŋwəy ya na. ");
INSERT INTO bcw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jakəŋwəyəm wəzə lə ya, njasa nzee va jakəjakə lə ghwəy. A ghwəy sənay kiy, ka mbə dəvə fəə yati ya kwətita, kala ghənzə tə dəŋw tsa pəsəta na va tiw. Ava tsəgha nza ghwəy kwərakwə ki, ka dza ghwəy mbəə mənti shiy dzaa fə shəndəkəə dzəti Hyala, ghwəy kala jakəjakə lə yaw. ");
INSERT INTO bcw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yənəy, yən na dəŋw fə, ghwəy na, dividivi tə ya. Ma ntsa jakəy lə yay, tsəgha nzee jakəjakə li kwərakwə, ta yati ya dza na ɗaŋ. Kala jakəŋwəy pə ghwəy lə yay, ka dza ghwəy mbay mənti ya namaɓa kwəmaw. ");
INSERT INTO bcw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ntsaa kama jakəjakə lə yay, ta ndəghamti tsava ndə dza məndiy dza, njasa ka məndi vaa ndəghamti dəvə tə fə, sa ka məndiy slanti, nza ghwəlita. Ma gəla niva shəghwə dəvə fəə nza kiy, nahwəti kwəma shi tiɓa, kala ɓasəshi ta pəhə ghwə li shiw. ");
INSERT INTO bcw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mbaꞌa pə ghwəy jakəŋwəy lə ya, mbaꞌa kwəmee nzəyta mbə ghwəy wəzəy, ghalaɓa na, ɗəwəm shiy ya nimaɓa shiy na shi ɗi ghwəy vəya gwaꞌa, ta kwəmavəshi dza ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sa ka ghwəy cikəvəri kwəma wəzə na məni ghwəyəy, ghalaɓa dza ghwəy nza ka mbəzli ta səɗee karkar ni. Mbaꞌa pə ghwəy mənti tsəghay, a mbəzli dzaa nay dikə tsa Dirə kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ma yənəy, mbə ɗiŋwəy nzee njasa ɗira Dirə va kwərakwə. Garəŋwəyəm tə ɗi tsa ɗiŋwəy ya va ya hwəmɓa. ");
INSERT INTO bcw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbaꞌa pə ghwəy ɗi fəti ta kwəma gəzəkəŋwəy ya məni nzəy, a ghwəy garəŋwəy tə ɗi tsa ɗiŋwəy ya va ya hwəmɓa ɗi naa gəzə. Njasa ɗee va fəti ta kwəma gəzara Dirə məni nzə, mbaꞌee garəɗa tə ɗi tsa Dirə va ya hwəmɓa. ");
INSERT INTO bcw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma gəzaŋwəy ya kwəma va tsəghay, ta mbə vəshee təhayŋwəy nefer ghwəy. Ma nza na ghwəy vəshi kərniy yəmayvata kwərakwə ki. ");
INSERT INTO bcw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma nə ya kaa nee kwəma gəzaŋwəy ya, ta məni ghwəyəy: Ɗim ghən tsa ghwəy kwa jipə ghwəy, njasa ɗiŋwəy ya va kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A ghwəy sənay, tsahwəti ɗi tiɓa ndəə cikəvəri ka taŋəti məti zləɓati ndə tə mbərkə madigahiyəw. ");
INSERT INTO bcw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma ghwəy ki, mbaꞌa pə ghwəy məni kwəma njasa gəzəkəŋwəy ya vay, madigahiraa gə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ka dzee harŋwəy ka ghəraɗa sləni ghwəlaw. Madigahira dzee harŋwəy. Sa nzanay, ndə ghəra sləni tsa ndə na kar naa sənashi shi ka Ntsaa sləkəə məniw. Ma ghwəy na na ghwəyəy, cəkeꞌ ɓanavəŋwəy ya shi citəra Dirə, va tsəgha harŋwəy ya ka madigahira. ");
INSERT INTO bcw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sanay, ghwəy təravəra naw. Yən na saa təravəŋwəy, ta nza ghwəy ka mbəzlee. A ndaŋwəyee sləni, nza ghwəy dza ta ghəra, nza sləni va mbəə dza kwa kwəma kwa kwəma ka kəəti mbəzli ta kwəmavə piy tsaa kəɗi ma. Ghalaɓa ki na, nza Dirə ɓəŋwəy ya nimaɓa shi dza ghwəy ɗəw və mbə slən tsee ki. ");
INSERT INTO bcw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A nə ya kaa kwəma gəzaŋwəy ya ta məni ghwəy kiy: Ɗim ghən tsa ghwəy kwa jipə ghwəy, nə ya» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ma kə Yesəw ɓa na: «Mbaꞌa pə ghwəy nay kala ɗi mətsə ghwəy mbəzli tə hiɗiy, sənay tə ghwəy nee mətsə na sa ꞌwa ghəshiy ɗi ma, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mbaꞌa pə ghwəy niy nza jakəjakə lə mbəzli tə hiɗi ni nzay, ta ɗi mətsə ghwəy niy dza ghəshi nza, sa ka ghwəy nza ka mbəzli shi. Ma sa nzana ki, mbaꞌee təravəŋwəy, harkəvəriŋwəy səvəri mbə mbəzli tə hiɗi, mbaꞌa ghwəy məniŋwəy ka shi ya nana, kala kama ghwəy jakəjakə li shiy, va tsəgha ɗi ma ghəshi mətsə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Talay, njaa niy nə ya kaa ngəŋwəy shəka? E niy gəzaŋwəy: “Ndə ghəra sləni tsaa taŋəti ntsa ghəranci na va sləni tiɓa tə dikəw” pən ɓasa. War mbaꞌa kə ghəshi niy ɗi fəti ta kwəma gəzanshee nzay, tsəgha dza ghəshiy ɗi fəti ta na ghwəy nza kwərakwə. Njasa niy sara ghəshi va ngəraꞌwəy, tsəgha dza ghəshiy saŋwəy kwərakwə ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kwəma dza ghəshi vaa məməni tsəgha na lə ghwəy gwaꞌa kiy, war tə mbərkee dza naa nza. Sa sənay ma ghəshi ntsaa ghwənikəra. ");
INSERT INTO bcw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kalaa niy səəkəree nza, kalaa niy gəzanakəshi kwəmee nzay, ka nza fəti və shi nzaw. Njana nzana mbaꞌee gəzanakəshiy, kwal və shi ta ɓanti fəti kən ghən shi mbə kwəma va ghwəlaw. ");
INSERT INTO bcw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ya wa ntsaa ɗi ma mətsə yay, mətsə Dirə na sa ɗi ma na kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbala kalaa səəkee mənti sləni dimədimə na mbə shi, sa səəkə ma ghəshiy nay tsahwəti ndəə mbata mənti nzay, ka nza fəti və shi ya jəw nzaw. Njana nzana nana ki, mbaꞌee ghərati sləni va tsəgha, mbaꞌa ghəshi nata njasa nzana, zhini tapə ghəshi ta ɗi ma kwəma ghəy lə Dirəy, a fəti və shi. ");
INSERT INTO bcw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","A mənta nava kwəma tsəgha, ta mbə kwəmaa niy tsasliti məndi va mbə zliya kwəma shi pəhəpəhə naa dzəghwata kwa. Ma kə məndi niy niy: “A kwəma məntee tiɓaw na, gwəravə məndi kala ɗi ma mətsee, kə” kə məndi niy niy. ");
INSERT INTO bcw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ta səəkə dza ndə kəətiŋwəy tsa va, səəkə va Didi dzee vəliŋwəy. Ghəci na Safə tsaa cipə na kataŋ na kwəma, vəgha Didi səəkə na. Sa ka na səəkəyəy, ta ndəgha fəti dza na tə ya. ");
INSERT INTO bcw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ghwəy kwərakwə kiy, ta ndəgha fəti dza ghwəy tə ya. Sa nzana, kwasəbee ghwəy niy nza ghala ghava kwəmee paꞌ sənzənva. ");
INSERT INTO bcw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A gəzaŋwəy ya kwəma va, vantaa təhwəni tsatəŋwəy, mbaꞌa ghwəy zlata nəw kwəmee taa nza. ");
INSERT INTO bcw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ghalaɓay, ta ɓantəŋwəy dza *ka Zhəwifə səvəri mbə ciki ɓasəva tsa shi. Mbə zəzə kwəma shiy, sləniy gwəraa təɓə kwa kwəma Hyalaa mənti ghəy, dza ghəshiy ni, sa ka ghəshi bəkwəŋwəy. ");
INSERT INTO bcw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Va wa dza ghəshiy məni shi va tsəgha kiy, sa nzana, kala sənay Dirə ghəshi, kala sənara ghəshi na. ");
INSERT INTO bcw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Avee gəzamtəŋwəy shi va sanata, ma sa ka ghəshi maɗishi ta məni kwəma tsəgha na va ki na, nza ghwəy zəzəvə: “Wa a Yesəw niy gəzaŋəy kwəma shi ni sham” pə ghwəy taa ni» kə Yesəw. «Va wa niy gəzaŋwəy mee kwəma va ghala kwataŋatay, sa niy nzana ghwəlaree tikə mbə ghwəy di. ");
INSERT INTO bcw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nana kiy, ta maɗi dzee dzaraa dzəvəgha ntsaa ghwənikəra. Ndə mbə ghwəy ɗəw na: “Kwəma dza gha ta dzaa?” kəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","War nefer ghwəy shiy slashi va kwəma va, sa gəzəkəŋwəyee tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na kataŋ naa gəzaŋwəy ya, va ghwəyəy, wəzəɓa dzaree na. Kala dzara pənəy, ka dza ntsaa dza vaa kəətiŋwəy səəkəyəw. Mbaꞌa pən dzaray, ta ghwənikəŋwəy dzee. ");
INSERT INTO bcw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma sa ka na səəkəy kiy, ta cintishi kwəma məni ghəshi jikir na dza na kaa mbəzli tə hiɗi, mbaꞌa cintishi na tiɗiɗ na kwəma, zhini mbaꞌa cintishi ngwəvə Hyala. ");
INSERT INTO bcw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A *Safə tsa Hyala dzaa cintishi kwəma məni ghəshi jikir na, sa nzana kala ndara nəfə tsa shi ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A Safə tsa Hyala dzaa cintishi na tiɗiɗ na kwəma, sa nzana mbaꞌee dzaa dzaraa dzəmə ghwəməə dzəvəgha Dirə, kala dza ghwəy nara ghwəla. ");
INSERT INTO bcw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A dzaa cintishi ngwəvə Hyala, sa nzanay, a Hyala kəsəy mazə tsaa sləkə hiɗi ni lə fəti tə ngwəvə nzə. ");
INSERT INTO bcw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ɗaŋ na nihwəti kwemer vəya ta gəzaŋwəyshi nanzə kiy, nana di na ka gəzaŋwəyshi yaw. Ka dza ghwəy mbəə favəshi nana diw. ");
INSERT INTO bcw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma dzaa nza ghala pətsa dza Safə tsa Hyala va cipə na kataŋ na kwəma səəkəyəy, nza ɓəniŋwəy sənata na kataŋ na kwəma gwanata. Sa nzanay, kwəma ɗi na njasa təkəti na dza naa səəkə ta gəzəw. Gwanata tsa kwəma favə na dza naa gəzaŋwəy, ka gəzaŋwəy kwəma shiy dzaa səəkə ta məniva kwa kwəma. ");
INSERT INTO bcw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta ci dikə tsee dza na njasa nzana. Sa nzanay, kwəmee dza naa ɓəvə ta səəkə ghəciy gəzaŋwəy. ");
INSERT INTO bcw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya nimaɓa shiy na shi va Dirə gwaꞌay, shi ya na ghəshi. Va tsəgha nə ya kiy, kwəmee na sa dza Safə tsa Hyala vaa ɓəvə ta səəkə ghəciy gəzaŋwəy, pən» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ma kə Yesəw diɓa na: «Kwa kwəma jəwəy, ka dza ghwəy naraw. Ma ləy hwəm hi jəw diɓay ta zhini dza ghwəy nara» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dza nava kwəma mbaꞌa səəti nihwəti mbəzli mbə *mbəzli ta səɗa ci, mbaꞌa ghəshi ꞌwati ɗəɗəw kwəma kwa jipə shi, a kə ghəshi na: «Kwəma ka waa na ɗi ntsa na gəzəmmə nə na: “Kwa kwəma jəwəy, ka dza ghwəy naraw. Ma ləy hwəm jəw diɓay, ta zhini dza ghwəy nara” a kəa? Zhini ɓa na: “Sa wanay, sa dzee dzaraa dzəvəgha Dirə” a kə. ");
INSERT INTO bcw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Njaa ɗi “Ləy hwəm jəw” tsa vaa gəzəa? Favə gəla kwəma va ghwəmmə, nda njaa ɗi na gəzəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mbaꞌa Yesəw sənay mbə ɗi ɗəw kwəma na ghəshi və, kə. Ma kə kaa ngəshi na: «Kwəma gəzaŋwəy ya va nə ya: “Kwa kwəma jəwəy, ka dza ghwəy naraw. Ma ləy hwəm diɓay, ta zhini dza ghwəy nara” pən. Va tsəgha ɗəɗəw ghwəy, kwa jipə ghwəy na? ");
INSERT INTO bcw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ə gəzaŋwəy ya, ta na navay, tsəgha na, a ghwəy dzaa nay ma, ghwəy mbə tihwəni, ka ngəlvə. Ma va mbəzli tə hiɗi nashi ki na, mbər nava vici dzaa mbəərəta ka vici kwa vəshi. Ma ghwəy na ghwəy ki na, war tifəmmə. Ma taa nza ki na, mbər ka vəshi nzəy tifəm tsa ghwəy va dzaa mbəərəy. ");
INSERT INTO bcw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nay ghwəy tsəy, mbaꞌa kə vici ya mali lə hwər kətikəvata ndəkwə ndəkwəy, kar imbə ꞌwəshiy nza tə miy nzəw. War tifəmmə ka naa nza, va zəzə vici ngəraꞌwə tsaa dza vaa səəkəə dzəkən. Ma sa ka na dza baw, yata kiy, gwaꞌa nzaꞌjəw dəŋwəzl, ka naa zamti ghən ta ngəraꞌwə tsaa səəkə va kən, kwataka va vəshi mbə nəfə nzə ta zəghwə yakəghwa na vaa dzəti hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ava tsəgha nza ghwəy sana sənzənva kwərakwə ki, war titifəmmə. Ə na na nzana kiy, ta zhini dzee səəkəə naŋwəy. Ghalaɓay, ta təhəshi dza nefer ghwəy va vəshi tərəŋw tərəŋw. Ndə tiɓa dzaa mbay ɓəhwə nava vəshi mbə nefer ghwəy ghwəla tepəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sa dza vəghwə tsa gəzaŋwəyee tsaa məniy kiy, shi dza ghwəy zhiniy ɗəw vəya tiɓa ghwəlaw. Ə gəzaŋwəy ya, ta na navay, tsəgha na, war ta ɓəŋwəy shi ɗəw ghwəy dza Dirəə dza ya nimaɓa shiy na ghəshi, ɗəwshi ma ghwəy lə slən tsee. ");
INSERT INTO bcw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paꞌ sanay, ɗəwhwə shiy ghwəy lə slən tsee diw. Ɗəwshim və, ta ndaŋwəy shi dza ghwəy vaa ɗəw və dza na. Nza vəshi ghwəy mbəə kərkəta» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ma kə Yesəw diɓa na: «Ma kwemer gazaŋwəy ya va gwanashiy, war dzar kwa fir kwa fir gazaŋwəyshee. Ma ta nza ki, sa dza tsahwəti vəghwə tsa vaa səəkəyəy, ka dzee zhiniy gəzaŋwəy kwəma dzar kwa fir ghwəla teepəw. Kwəma kən Dirə dzee gəzəŋwəy səvəri bazhə bazhə. ");
INSERT INTO bcw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ghala tsava vəghwə sa ka na səəkəyəy, ghwəy dəꞌwə ghən tsa ghwəy dza naa ɗəw shi ɗi ghwəy va Dirə mbə slən tsee. Ka nə ya, e dzaa cəꞌwəŋwəy shiy və, pənəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sa nzanay, mbə ɗiŋwəy na Dirə dəꞌwə ghən tsa ci. Mbə ɗiŋwəy na sa nzana mbaꞌa ghwəy ɗitəra, ka zləɓati səəkə və səəkee, pə ghwəy. ");
INSERT INTO bcw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vəgha Didi kafee, mbaꞌee səəkəraa dzəti hiɗi. Sənzənva kiy, ta maɗi dzee tə hiɗi, ta dzaraa dzəvəgha Didi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma kə mbəzli ta səɗa ci na: «A Ndə sləkəŋəy, nana kiy, kwəmaa na gəzəŋəy gha na bazhə bazhə, kala kwəma lə fir mbə. ");
INSERT INTO bcw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nana gha ghəy sənay, nahwəti kwəma tiɓa kala sənata ghaw, pə ghəy. Ya ə ɗi ndə ɗəw kwəma va ghay, ka ndə gha maɗi ta ɗəw kwəma va na, gha sənamti kwəma ɗi na va ɗəw. Va tsəgha zləɓati ghəy vəgha Hyala səəkə gha kataŋ, pə ghəy» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma kə Yesəw na: «Əy zləɓati ghwəy nana kiw? ");
INSERT INTO bcw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ə gəzaŋwəyee, a tsahwəti vəghwə dzaa səəkə, ya tsəgha nzəy, a vəghwə tsa va tsəhəy. Ta ndaniŋwəy dza ghwəy kwətiŋ kwətiŋ gwanaŋwəy ka dzaŋwəy dzakə ghyeghyer ghwəy, mbərəkə ghwəy zlara kwətira. Nanzəy e sənay kwətira dzee nzaw. Ghəy lə Dirə dza naa nza. ");
INSERT INTO bcw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma kwəma gəzaŋwəy ya va gwanatay, ta mbə ghwəy nza lə zərkə mbə nefer ghwəy, sa jakəŋwəy ghwəy lə ya nə ya. E sənay, ta sa ngəraꞌwə dza ghwəy va mbəzli tə hiɗi. Ya tsəgha nzə kiy, ɗikəvaŋwəy tə ghwəy tərəŋw. Na nee ta na tsee ghən kiy, e təɗanakən kaa shi tə hiɗi gwaꞌa gwaꞌa, miydalaa mənee» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ma ləy hwəm sa gəzamti Yesəw kwemer va gwaꞌa gwaꞌa tsəgha ki na, dza na kaf kafəti kwəma ciy dzəta ghwəmə. A kə na: «A Di, nana kiy, a vəghwə tsee tsəhəy. Citi njasa nza dikə tsa mənee, yən Zəghwə gha, ta mbee ci tsa gha dikə njasa nzana kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gha kiy, a gha ndara bərciy dzəkən mbəzli tə hiɗi gwanashi, ta mbee ɓanshi piy tsaa kəɗi ma kaa mbəzli fambəra gha mbə dəvee gwanashi. ");
INSERT INTO bcw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma piy tsaa kəɗi ma tsa kwəmavə ghəshi vay, sa sənaŋa ghəshi ka Hyala kwətiŋa, kataŋ, mbaꞌa ghəshi sənay, Yesəw *Kəristəw na ntsa ghwənikə gha, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gwaꞌa cintee dikə tsa gha njasa nza na kaa mbəzli tə hiɗi. Dza mbaꞌee kəɗamti ghəra sləni ndara gha ta ghəra nzə tikə gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nana kiy Diy, zhanavəra dikə tsee va niy nzee mbə kwa kwəma gha, ghala pətsaa niy nza ghwəm ghwəlam lə gha hiɗi ghwəla ta ꞌwa ngava. ");
INSERT INTO bcw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Gwaꞌa cantəŋee kaa mbəzli tərakəvəri gha va səvəri mbə mbəzli tə hiɗi, mbaꞌa gha ndarashi. Mbəzli gha niy nza ghəshi ka shi gha, dza mbaꞌa gha ndarashi mbə dəvee. Mbaꞌa ghəshi ɗiti fəti, ka məni kwəma gha ki. ");
INSERT INTO bcw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sənzənva kiy, gwaꞌa sənay ghəshi, ya nimaɓa shiy na ni ya shi kwəmavee na, va gha səəkə ghəshi, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sa nzana mbaꞌee gəzanshi kwəma gəzara gha ngəshi, mbaꞌa ghəshi zləɓavə kwərakwə. Mbaꞌa ghəshi sənay kataŋ, vəgha gha maɗee ta səəkə tikə, kə ghəshi, mbaꞌa ghəshi zləɓati ghwəni tsa ghwənikəra gha va mbə nefer shi. ");
INSERT INTO bcw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Va tsəgha cəꞌwəŋee ti shi, a gha kəətishi. Cəꞌwəŋee ta na mbəzli tə hiɗi gwanashiw, war ta ni ndara gha va mbəzli mbə dəvee cəꞌwəŋee, sa nzana mbəzli gha ka shi gha ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ya wa ni ya shi vəya gwaꞌay, shi gha na ghəshi. Ni gha shiy gwanashi kwərakwə ɓa na, shi ya ghəshi. Səvəri mbə kwəma shi sənay məndi dikə tsee. ");
INSERT INTO bcw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yən kiy, ntsa tikə tə hiɗi ni nzee ghwəlaw, ta dzaraa dzəvəgha gha dzee sana. Ma ghəshi na nashi kiy, tikə na ghəshi lə nzəy tsa shi. A Didi tsa ɗewɗew tsa, ndəghwətishi wəzə lə bərci mbə slən tsa gha va ndara gha. A ghəshi mbəə jakəti ghən tsa shi lə miy tsa shi, ta nza ka mbəzli kwətiŋ ni, njasa nza ghwəm va sənzənva kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma yən mbə nzəy tsa nzəyŋəy ghəy li shiy, ndəghwə niy ndəghwəshee lə bərci slən tsa gha va niy ndara gha. E ndəghwətishi, tsahwəti ndə tiɓa mbə shi mbaꞌa zay ya kwətiŋəw. War tsaa niy dza vaa zay, ta mbə kwəmaa niy tsasliti məndi va mbə Zliya gha mbəradzəə mənta. ");
INSERT INTO bcw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sana kiy, ta dzara dzee dzəvəgha gha. Ə gəzamtee kwəma va gwaꞌa ghala yən tikəra tə hiɗi ni. A nefer shi mbəə tihəshi paf lə vəshee. ");
INSERT INTO bcw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","E gəzanshi kwəma gha. Dzəghwa kiy, kala ɗi ma mətsə shi mbəzli tə hiɗi ni, sa kama ghəshi jakəjakə li shi, njasa nzee va kwərakwə, kala jakəva ma lə mbəzli tə hiɗi ni. ");
INSERT INTO bcw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cəꞌwəŋee a gha səəkəə ɓantishi tikə tə hiɗiw. Ta mbə gha ndəghwətishi va *ndə jaka tsa shi cəꞌwəŋee. ");
INSERT INTO bcw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Njasa nzee va, kala jakəva ma lə mbəzli tikə tə hiɗiy, tsəgha ghəshi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ə pə gha zhəghətishi, ka mbəzli gha kataŋ kataŋ ni, lə kwəma gha va kataŋ na. ");
INSERT INTO bcw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ə ghwənashee dzəmbə mbəzli tə hiɗi, njasa ghwənikəra gha vaa dzəti hiɗi kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Laŋ ɓəvee ghən tsee mbaꞌee ndaŋa ti shi, ta mbə ghəshiy nza ka mbəzli gha kataŋ ni kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mbə cəꞌwə cəꞌwəŋee na diɓay Didiy, war ti shi kwətishi gwaꞌa tsəgha cəꞌwəŋeyew, lə ta nihwəti mbəzliy dzaa ndara nəfə tsa shi tə mbərkə kwəma dza ghəshiy gəzanshi cəꞌwəŋee gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","A Di, ə cəꞌwəŋee, məntishi ka mbəzli kwətiŋ. Mbaꞌa ghəshi jakəshi lə ghwəm, njasa nza gha va jakəjakə lə ya, tsəghee lə gha kwərakwə. Kəətitishi a ghəshi jakəti ghən tsa shi, nza mbəzli tə hiɗi mbəə sənay, gha ghwənikəra na, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","E ɓanavəshi dikə tsa ndara gha va kwərakwə, a ghəshi mbəə nza ka ndə kwətiŋ, njasa nza ghwəm va lə gha sana ka ndə kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yən na, mbə shi, gha na mbə ya, tsəgha. A ghəshi mbəə mənishi ka ndə kwətiŋ tsəgha slar slar. Ma tsəghay, a mbəzli tə hiɗi dzaa sənay, gha ghwənikəra na. Ava gha mbə ɗishi, njasa ɗira gha va, kə ghəshi taa ni. ");
INSERT INTO bcw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","A Didi, mbəzli niy, gha ndarashi na, e ɗi ghəshiy nza vəghee, tə pətsa dzee ta nza kwərakwə, ta mbə ghəshiy nay dikə tsee. Dikə tsa ndara gha, sa nzana mbaꞌa gha ɗitəra ghala hiɗi ghwəla ta gha ngava. ");
INSERT INTO bcw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","A Didi tsaa nəw kwəma lə kwal tsa nzə, gha sənzənvay sənaŋa mbəzli tə hiɗiw. Yən na nee kiy, e sənaŋa. Dzəghwa mbaꞌa mbəzlee ni sənay, gha ghwənikəra na, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","E citəŋa kaa ngəshi, ta zhini dzee mətsəhə ciŋa ngəshi diɓa. Ta mbə ɗi tsa ɗira gha vaa tahanayshi nefer shi paf kwərakwə. Mbə shee taa nza dəꞌwə ghən tsee ghalaɓa kwərakwə ki» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ma sa cəꞌwəti Yesəw cəꞌwə va kiy, mbaꞌa ghəshi maɗishi lə *mbəzli ta səɗa ci, ka taŋə dzəvəri tə həl tsa har məndiy Kedərən. Ma pəriɓa taŋ həl tsa va na, mbaꞌa tsa pəriɓa. Dza kar Yesəw lə mbəzli ta səɗa ci mbaꞌa ghəshi dzəghwashi kwa tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Zhəwdasə, ntsaa ngati ɗafa va ta kəsə Yesəw kwərakwə na, mbaꞌa sənay pətsa va, sa sənaɓəshi ghəshi mbə dzəghwa. ");
INSERT INTO bcw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ꞌWakəvə kar Zhəwdasə lə ka sawji mbaꞌa ghəshi maɗishi lə mbəzliy ndəghwə *ciki Hyala ghwənashi mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə *ka Farisahi. War pəhəpəhə ghaa nashima lə shi mbəz shi, mbaꞌa gərkəwahi lə shehwer, giꞌwə giꞌwə ghwə ti shi və shi ta dividivi shi. ");
INSERT INTO bcw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma Yesəw naci ki na, mbaꞌa sənata kwəmaa dzaa mənivaa dzəkən ghala kwataŋata. War sa tsəhəshi ghəshi kwa tsa va na, dza Yesəw kət kətəghəvay dzəvəgha shi, ka ɗəw və shi, a kə na: «A ntsa pəla ghwəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma kə ghəshi na: «Yesəw ndə ka Nazaretə» kə ghəshi. Ma kə Yesəw na: «Ane, yən na sava» kə. Tiɓa Zhəwdasə tsaa ngati ɗafa va ta kəsə Yesəw kwasəbə shi ki. ");
INSERT INTO bcw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ma sa gəzəkə Yesəw: «Ane, yən na sava» kə na, ꞌwakəvə ghəshi zhəy lə hwəm lə hwəm tsəgha, dididi səyshi, naꞌi ghəshi shəkatəvashi tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zhini Yesəw ka ɗəw və shi diɓa: «A mbəzli ni, a ntsa pəla ghwəy, pə ghwəya?» kə. A kə ghəshi na: «Waa Yesəw ndə ka Nazaretə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ma kə Yesəw ngəshi ɓa na: «E gəzaŋwəy nanzə ghala məcanata, avanaram, yən na sava, pən sa? Ma ghənzə tsəgha, yən kə sa pəla ghwəy kataŋəy, ə pə ghwəy zlashi nini mbəzli, a ghəshi dzashi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ma sa gəzə na va tsəghay, ta mbə kwəma gəzəkə na va kaa Didiy dzəməyta. Sa niy nə na va: «A Didi, ma mbəzli ndara gha va mbə dəvə yay, zamti ndee mbə shi ya kwətiŋəw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dzəghwa Shimaŋw Piyer kaa kafaꞌi sa nzana və tə pətsa va ɓəkwə təɗikəvəri, pətsə kəsləkəghwa sləmə kwa bəzəmə vəgha ghən ndə ghəra sləni kaa dikə tsa ka ta Hyala. Malkwəsə, kə məndi kaa slən tsa ndə ghəra sləni tsa va. ");
INSERT INTO bcw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma kə Yesəw kaa Piyer na: «A Piyer, zhanambə kafaꞌi tsa gha mbə kwəɓək tsa ci taŋtaŋ. Ka dzee sa ngəraꞌwə tsa ndara Dirə ta saw nə gha mbə zəzə kwəma gha shəkəna?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dza ka sawji tiɓa ghəshi lə ntsaa sləkə shi, mbaꞌa ka ndəghwə *ciki Hyala mbə *ka Zhəwifə, pay ghəshi kəsəti Yesəw, mbaꞌa ghəshi pəhəti. ");
INSERT INTO bcw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dza ghəshi pəm pəmanaghə kaa Anə, kwa taŋa di. Ma Anə tsa vay, shiy Kayifə, dikə tsa ka ta Hyala tə nava piya na. ");
INSERT INTO bcw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayifə tsa va na saa niy gəzanshi va kaa mbəzli ka Zhəwifə dikə dikə ni, ma kə na: «Aya, wəzəɓa mətiy ndə kwətiŋ na tə mbərkə hwəlfə ghwəmmə» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ma ghala pətsa pəmə məndi va Yesəw ta dzakə ghi tsa dikə tsa *ka ta Hyala tsa vay, mbaꞌa Piyer ghəshi lə tsahwəti ntsa ta səɗa Yesəw nja ghəci nəwvə. Ma ntsa vay, a dikə tsa ka ta Hyala tsa va niy sənay. Va tsəgha kwəmavə na dzakə ghi tsa va kwasəbə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mbaꞌa Piyer garəy pərikəy kwa dəgha naci ki. Mbaꞌa ntsa ta səɗa Yesəw va, ntsa sənay dikə tsa ka ta Hyala va səvəriy gəzanta kwəma kaa mali kwa ndəghwə dəgha va. Mbaꞌa ntsa va pəməghə Piyer dzakə ghi ki. ");
INSERT INTO bcw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dza maliy ndəghwə dəgha va, tapə ta ɗəw kwəma va Piyer kəyɓa ki, a kə na: «A ntsa, tsahwəti ntsa ta səɗa ntsa gha tsəy?» kə. Ma kə Piyer na: «Am, əhəŋ, ntsa ta səɗa ci nzee neyew» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ghalaɓa ki na, mbaꞌa tasli mənta. Dzəghwa mbəzliy ndəghwə pətsa kəghi lə nihwəti ka sləni kəyɓa bəkə ghəshi pəhəy ghwə. Ka bəghəzli ghwə va Piyer kwərakwə. ");
INSERT INTO bcw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dza dikə tsa ka ta Hyala va, ka ɗəw kwəma va Yesəw dzəkən kwəma mbəzli ta səɗa ci, lə dzəkən shi ɓənipə na va. ");
INSERT INTO bcw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma kə Yesəw kaa zləɓanci na: «Yən kiy, mbə gəzə kwəma va niy nzee kaa mbəzli ɗaŋ, paꞌi paꞌi tə ngwəla. Ka ɓananshee kaa mbəzli dzar mbə *ciki ɓasəva tsa ka Zhəwifə, paꞌ mbə *ciki Hyala, tə pətsa ɓasəva *ka Zhəwifə gwaꞌa gwaꞌa. Kwəma tiɓa mbaꞌee gəzəhwə tə mbə ya kwətiŋəw. ");
INSERT INTO bcw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wa shi zhini ghaa ɗəw vəya diɓaa? Ə pə ghaa ɗəw va mbəzliy niy gəzanshee va, a ghəshi ciŋa njasa niy favə ghəshi yən gəzanshi. A ghəshi sənata gwaꞌa gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ma sa gəzəkə Yesəw kwəma va tsəgha na, ꞌwakəvə tsahwəti ndə ndəghwə ciki Hyala tiɓa paꞌwə tsavəgha dəvə vəgha ghən ci. A kə na: «Tsəgha ghaa zhananci kwəma kaa dikə tsa ka ta Hyala nee?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ma kə Yesəw na: «Tawa ləkəra gha kia? Kwəma jikir na kə sa gəzəkee vay, ka gəzə gha! Kwəma wəzə na pən gəzəkə kiy, tawa ləkəra gha kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dzəghwa Anə mbaꞌa zhiniy vələghə Yesəw kaa Kayifə dikə tsa ka ta Hyala, war ghwəlay pəhəpəhə tə zəꞌwə va tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma ghala pətsa va ki na, war tiɓa Shimaŋw Piyer vəgha mbəzli va mbə bəghəzli ghwə ci va naci ki. Dza tapə məndi maɗishi ta ɗəw kwəma və, a kə məndi na: «A ntsa, tsahwəti ntsa ta səɗa ntsa gha tsəy?» kə məndi. Ma kə Piyer na: «Ntsa ta səɗa ci nzeyew» kə, ka vəraslə. ");
INSERT INTO bcw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dza ma kə tsahwəti ndə kwətiŋ mbə ka ghəra sləni dikə tsa *ka ta Hyala va, ngwardidi ghəshi lə ntsa kəslamti Piyer va sləmə ci na: «Niy naŋee kwasəbə ntsa ghala pətsaa nza ghwəy va kwa tsa tsəy?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Zhini Piyer mbaꞌa vərasləti vəraslə diɓa. ꞌWakəvə ngələkə ghala pətsa va ki, mbaꞌa way. ");
INSERT INTO bcw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dza məndi tə həzlimə pəətə mekəshi ki, pəm məndi pəməkə Yesəw kəghi tsa Kayifə, ka dzakə ghi tsa ngwəmna ka Rəm li. Ma *ka Zhəwifə nashi ka ghən tsa shi na, kala dzakə ma ghi tsa ngwəmna ghəshi. Sa naa nza mahalakə dzakə ghi tsa ndə ka Rəm və shi, ndə kə gwəmantəvay ta zəmə shiy mbə *makwaghwa Pakə. ");
INSERT INTO bcw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma sa mbə ma ka Zhəwifə dzakə na, dza ngwəmna Pilatə, mbaꞌa səvəriy kəsashi pərikə kwa dəgha. Dza na ka ɗəw və shi: «Wa shi mənti ntsa kəsəti ghwəya?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma kə ghəshi ngəci na: «War mbaꞌa kə kala ndə liɗi kwəma nzay, ka dza ghəy səəkə li ngəŋaw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma kə ngwəmna Pilatə kaa ngəshi na: «Mbalam li, a ghwəy dzaa sla ngwəvəə dzəkən dəꞌwə ghən tsa ghwəy njasa gəzəkə kwəma ghwəy pəhəpəhə na» kə. Ma kə ka Zhəwifə na: «Kwal va ghəy ta sla ngwəvə mətiy dzəkən ndəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mbaꞌa nava kwəma mənta tsəgha, ta mbə kwəmaa niy gəzəkə Yesəw va, ghala pətsa cipə na kwəma məti dza na ta *məti vəgha tsəm dzəghwata kwa. ");
INSERT INTO bcw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mbaꞌa Pilatə zhay zhakə ghi tsa ci ɓa, daꞌ harvə Yesəw. Ka ɗəw kwəma ghəci və, a kə na: «Mazə tsa ka Zhəwifə nza gha na ntsa?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma kə Yesəw na: «A ngwəmna tsee, kwəma təkəti gha dəꞌwə ghən tsa gha, ta ɗəw tsətsə na sana shəkənaa, naa kə ndə kaa ngəŋa na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma kə ngwəmna Pilatə na: «Waa yən ɓa, pə gha, ndə kaa Zhəwifə nzee na? Mbəzli ghwəy ka hwəlfə ghwəy, lə *ka ta Hyala ghwəy dikə dikə ni kəsəkəŋa na ngəra. Va tsəgha ɗəwee, wa shi mənti gha kəsəŋa məndia? pən» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma kə Yesəw ki na: «Mazə tseyey, sa tikə tə hiɗi ni naw. Mbaꞌa kə niy nzaa sa tikə tə hiɗi niy nzay, ci gwəla ta səɗee ndəghwətəra, va nəghətaa ka Zhəwifə kwəfaghati dəvə shi tə ya nza. Ma ki na, məniy naa mazə tsa tə hiɗi ni kiw» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma kə Pilatə ki na: «Mazə nza gha, ghənzə tsəgha ɓay?» kə. Ma kə Yesəw na: «Njasa gəzə gha va na, mazə nzee. Ya tsa yakəram lə səəkə tsa səəkəree tikə tə hiɗiy, ta canshi kwəma kataŋ na kaa mbəzli na. Ya wa ntsaa dzaa ɗi fa na kataŋ na kwəma kiy, ta fa nee va kwəma dzee gəzə dza na» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma kə Pilatə na: «A shiy na kwəma kataŋ naa?» kə. Ma ləy hwəm shi va na mbaꞌa zhəkəvəriy dzəghwa kwəma ka Zhəwifə. A kə ngəshi na: «A mbəzli ni, na neyey, kəsata kwəma jikir nee va ntsa gar ɓanci fəti məndiw. ");
INSERT INTO bcw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nanzə kiy, a ghwəy sənay, njasa sənaɓəŋwəy ghwəy mbə məni mbə makwaghwa Pakə. Mbə pəlayŋwəy ndə kee nza kwətiŋ kwa fərshina, geꞌi lə vici va. Ka ɗi ghwəy ki, yən pəlayŋwəy mazə *ka Zhəwifə na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma kə ghəshi zlaŋzlaŋ na: «Awə! Zləɓati ghəyəw. Barabasə na sa ɗi ghəy ghaa pəlayŋəy!» kə ghəshi. Ma Barabasə tsa vay ndə rəɗa tsa dikə tsa niy nza na. ");
INSERT INTO bcw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","«Əŋkwa» kə ngwəmna Pilatə ki, dza na mbaꞌa gəzanshi kaa ka sawji, a ghəshi pəmə Yesəw ta dzaa dəꞌwəti lə kwərpə. ");
INSERT INTO bcw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dza ka sawji va pəmə ghəshi pəməvə Yesəw ki, mbaꞌa ghəshi mbərəti tekesli nja məgapa pəərə ghən mazə sərambə mbə ghən ci. Mbaꞌa ghəshi səranakən kwəbaŋ ghəməy nja sa mazə. ");
INSERT INTO bcw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ka ghəshiy dza na ka kətivaa dzəvəgha ta sawa ci, ma kə ghəshiy ni na: «A mazə *ka Zhəwifə, ava ghəy səkwətəŋa» kə ghəshiy ni. Ka ləkə dəvəə dzəvəgha ghən ci. ");
INSERT INTO bcw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dzəghwa Pilatə mbaꞌa zhəkəvəriy. A kə kaa ka Zhəwifə va na: «Favəm, na neyey, avee dzaa pəməkəvəriŋwəy Yesəw dzəti ngwəla sənzənva, ti ghwəy sənay, kəsata kwəma jikir nee və gar ɓasə ngwəvəə dzəkənəw, pə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dzəghwa pəm məndi pəməkəvəri Yesəw tə ngwəla ki, lə daghwəba tsa tsatim tə tekesli mbə ghən tsa ci, mbaꞌa kwəbaŋ ghəməy kən ghən ci. Ma kə ngwəmna Pilatə ngəshi na: «Avanayəm ntsa va ki» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dzəghwa mbəzli dikə dikə ni mbə *ka ta Hyala, ghəshi lə dəwgerhi shi, mbaꞌa ghəshi nay Yesəw. Ma sa nay ghəshi, a kə ghəshi zlaŋzlaŋ na: «Daŋwə pə gha daŋwavəgha vəgha tsəm. Daŋwə pə gha daŋwavəgha vəgha tsəm» kə ghəshi. Ma kə Pilatə kaa ngəshi na: «Ɓəm a ghwəy daŋwə sa ghwəy dəꞌwə ghən tsa ghwəy. Na neyey, kəsata kwəma jikir nee və gar pəəsliw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A kə ghəshi kaa ngwəmna na: «A kwəma pəhəti ghəy tiɓa, mbaꞌa gəzəkə, war ka pəəsliti kə, sa gəzəkə na “Zəghwə Hyala nzee” kə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sa favə Pilatə kwəma gəzəkə mbəzli va va tsəgha na, mbaꞌa hazləniy tərəŋw. ");
INSERT INTO bcw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Zhini na mbaꞌa pəməvə Yesəw zhakə ghi diɓa. Dza na ka ɗəw kwəma və, a kə na: «Kwəma tsahwə ghaa?» kə. Dighevə Yesəw nzəyəy, kala zləɓanci kwəma. ");
INSERT INTO bcw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma kə Pilatə ngəci na: «Wa ə zləɓara ma gha kwəma kia? Ə sənay ma gha, a kwal vəya ta pəlaŋa, zhini lə kwal vəya ta gəzanshi kaa mbəzli ta daŋwavəghaŋa vəgha tsəm, pə gha na?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ma kə Yesəw ngəci na: «Kwal va gha ya jəw ta məntəra shiy gha, kala ndaŋa kwal Hyala səəkə mə ghwəməw. Va tsəgha nzana ki, ma ntsaa ɓəvəra vaa fambəra mbə dəvə ghay, tərəŋwɓa na ci *kwəma jikir na na kən na gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ma sa favə Pilatə kwəma va tsəgha na, dza na ka pəla kwal tsa pəlay Yesəw. Dza ka Zhəwifə gwanashi ka ꞌwaŋə zlaŋzlaŋ, a kə ghəshi na: «War mbaꞌa pə gha pəlay ntsay, ka zhini ghaa nzaa madiga lə mazə tsaa sləkə hiɗi ka *Rəm gwanashi ghwəlaw. A gha sənay, ya wa ntsaa mənti ghən tsa ci nja mazəy, ndə gaɓə tsa mazə tsa va na» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ma sa favə Pilatə kwəma va tsəgha na, mbaꞌa gəzanshi kaa ka sawji a ghəshi pəmə Yesəw səvəriy dzəti ngwəla diɓa. Dza na das nzəyəy kwa gəzli ka naa nzəy ta sla ngwəvə kwa. Pətsa nzəyəy na va tiy, «Gabata» kə məndi kwa kwəma ka *Ebərə. A ɗi na gəzəy «pətsa ndəɓətim lə hərezli» ta ɓasə ngwəvə ti. ");
INSERT INTO bcw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Fəca məniva shi va vay, gar vici kwa ghən niy nza na, məndi taa səvəri ta gha *makwaghwa Pakə. Ma kə Pilatə kaa ka Zhəwifə na: «Avam mazə tsa ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma kə ghəshi zlaŋzlaŋ na: «Ayaw, pəəsli pə gha paslamti. Daŋwavəgha vəgha tsəm, a ghəci məti» kə ghəshi. Ma kə ngwəmna Pilatə ngəshi na: «Ə ɗi ghwəy, yən daŋwavəgha mazə tsa ghwəy vəgha tsəm na?» kə. Ma kə mbəzli dikə dikə ni mbə ka ta Hyala na: «Tsahwəti mazə tiɓa va ghəy na ghəy, kala war mazə tsaa sləkə hiɗi ka Rəm gwanashiw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dzəghwa ngwəmna Pilatə ki mbaꞌa pəlanavəshi Yesəw ta dza ta daŋwəə dzəvəgha tsəm. Dzəghwa ka sawji va ki, pəm ghəshi pəməti Yesəw, ka səvəri mbə məlməə dzəti ngwəla. ");
INSERT INTO bcw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Dza məndi mbaꞌa məndi ɓanakən tsəm tsa dza məndi va ta daŋwəə dzəvəgha, a ghəci ɓə dəꞌwə ghən tsa ci. Mbaꞌa ghəshi dzashi liy dzəti pətsa nə məndi «Gwalgwata» kə məndi kwa kwəma ka *Ebərə. A ɗi Gwalgwata tsa vaa gəzəy, pi nja ghən ndə ngəri. ");
INSERT INTO bcw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma sa tsəhəshi ghəshi na, dza ka sawji va mbaꞌa ghəshi daŋwavəgha Yesəw vəgha tsəm tə pətsa va ki. Mbaꞌa ghəshi daŋwavəgha nihwəti mbəzli bakə vəgha tsemer, ya wa ndə na tə tsa ci tsəm. Tsahwəti na, tə kwa bəzəmə Yesəw, tsahwəti na tə kwa zleɓi ci, mbaꞌa Yesəw kwa jipə shi ki. ");
INSERT INTO bcw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dza Pilatə mbaꞌa gəzanshi kaa mbəzli a məndi tsaslati kwəmaa dzəti shiy, mbaꞌam nahati tə tsəm tsa daŋwə məndi vaa dzəti, a kə kwəma va na: «Yesəw ndə ka Nazaretə, mazə tsa *ka Zhəwifə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kwəma tsasliti məndi vay, ka Zhəwifə ɗaŋ jangəhwə na, sa nzana ndəkwə ndəkwə pətsa daŋwavəgha məndi va Yesəw vəgha tsəm lə məlmə Zherəwzalem. Lə kwəma ka Ebərə, mbaꞌa sa ka *Rəm, mbaꞌa sa ka *Gərekə niy tsasliti məndi kwəma va. ");
INSERT INTO bcw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dza mbəzli dikə dikə ni mbə *ka ta Hyala mbə ka Zhəwifə mbaꞌa ghəshi dzaa kəsay Pilatə. Ma kə ghəshi kaa ngəci na: «Ma kwəma vay, ə pə gha zhəghanti, ka nə gha “Mazə tsa ka Zhəwifə” pə gha ma. Ma ka gha tsaslitiy: “Yən na mazə tsa ka Zhəwifə” kə ntsa pə gha» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma kə Pilatə ngəshi na: «Na tsaslitee va kwəma na neyey, tsəgha dza naa nza» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma sa daŋwamti ka sawji Yesəw dzəvəgha tsəm na, mbaꞌa ghəshi ɓasəva kwəbeŋer ci, mbaꞌa ghəshi tihəhwəshi kwa jipə shi faɗanashi, ya wa ndə mbə shi na lə ni ci. Kwataka gee kən ghən ci saa niy tərə. Gee vay, gəvbaw niy nza na kala cisli ti, ka səəkə mə ghən paꞌ kwakə mbə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dza ghəshi sləka ghəshi sləkati kwa jipə shi, ma kə ghəshi na: «Ka sləkwə gee na ghwəmmə ma, ə pə ghwəmməə ti dandərɗə, ta nighə ntsaa dzaa ɓə mbə ghwəmmə» kə ghəshi. Kwəma mənti ghəshi va tsəghay, kwəmaa niy tsaslita va mbə Zliya Hyalaa faghwa ghəshi kwa. Ma kə niy niy: «A ghəshi tihəhwə kwəbeŋer kən ghən tsee kwa jipə shi. Mbaꞌa ghəshi slati dandərɗə ta sənay ntsaa dzaa ɓə gee ya» kə niy ni. Ava ghənzə na kwəma mənti ka sawji va ki. ");
INSERT INTO bcw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tiɓa niy nza kar mbəghəy Yesəw garə vəgha tsəm tsa daŋwavəgha məndi va, ghəshi lə zhambəghəta, mbaꞌa Marəy, mali Kəleyəwpasə, mbaꞌa Marəy ka Magədala. ");
INSERT INTO bcw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mbaꞌa Yesəw nata mbəghəy tiɓa vəgha, mbaꞌa ntsa ta səɗa ci va ɗi na tərəŋw kwərakwə ɓa. Dza ma kə kaa mbəghəy na: «A mə, avanay ntsaa zəghwə gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Zhini ma kə kaa ntsa ta səɗa ci va ɓa na: «Avanta məŋa» kə. Dzəghwa ntsa va pəm pəməhwə Marəy ghala fəcavataa dzakə ghi tsa ci ki. ");
INSERT INTO bcw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ləy hwəm shi va kiy, a Yesəw sənay gwaꞌa gwaꞌa kəɗita kwəma njasa ɗi Hyala nana, kə. Ma kə na: «A ndir ghəraɗa» kə. Sa gəzə na va kwəma va tsəghay, ta mbə kwəmaa tsaslita va mbə Zliya Hyalaa dzəkən dzəghwata kwəlaꞌ kwa. ");
INSERT INTO bcw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma tə pətsa va na, mbaꞌa ghwəlpə tiɓa paf shi sa tati məndi tə shi ndalakwə ni kwa. Dza ka sawji va tsaŋ ghəshi ɓəvə səwsə tiɓa, mbaꞌa ghəshi parati tə gəta. Dza ghəshi yəkwə ghəshi yəkwambə mbə shi sa va, ka fanciy dzəghwa miy tsa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ma sa nə Yesəw, ɓəsə kə ɓəsəvə shi ndalakwə ni va lə miy tsa ci ki, ma kə na: «Nana kiy, gwaꞌa mənishi shiy njasa ɗi Hyala» kə. Dzəghwa kwəshəŋw ghən tsa ci məniy, mbaꞌa mətiy. ");
INSERT INTO bcw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Məniva shi vay, fəca ləwma Bərha. Səvəri way pi na, *vici dəkəva ka Zhəwifə. Kala ɗi *ka Zhəwifə mbəzli daŋwavəgha məndi va vəgha shəghwə nza war ghwəlashi daŋwə daŋwə fəca vici dəkəva. Sa nzana, nava vici dəkəva na, vici tərəŋw na ghənzə niy nza və shi. Va tsəgha ki na, mbaꞌa ghəshi dzaa kəsay ngwəmna Pilatə ta ɗəw, a ghəci gəzanshi kaa mbəzli, a məndi ɓalamti shiɗshiɗ tə mbəzli daŋwəy məndi va vəgha shəghwə, nza ghəshi mbəə bəkwəshi taŋtaŋ. Nza məndi mbəə pələkəghwa mbəreketi shi tə shəghwə. ");
INSERT INTO bcw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dzəghwa Pilatə ki mbaꞌa gəzanshi kaa ka sawji. Sa maɗi ghəshi ki na, mbaꞌa ghəshi ɓalamti shiɗshiɗ pərɓa tə tsahwəti mbə mbəzli daŋwavəgha məndi va vəgha tsəm vəgha Yesəw, zhini ɓəli tə kwa baka tsa va ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma maɗi ghəshi ta tsəhə vəgha Yesəw naci, njəꞌwə kə ghəshi na, ghəci mətiy. Va tsəgha ɓəlamti ma ghəshi səɗa Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dzəghwa tsahwəti ndə mbə shi kwətiŋ, mbaꞌa ꞌyamti Yesəw mbə slərpə ci lə gwapa. Ka səəmə miymiy lə yam kwa pətsa va tiɓata. ");
INSERT INTO bcw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ntsaa gəzə kwəma tsaa dzəkən shiniy, lə mətsə ci nashi na shi va, kwəma gəzə na va na, sa kataŋ na ghənzə. Aa sənata dəꞌwə ghən tsa ci, kwəma kataŋ na sa gəzee na, kə. Ta mbə ghwəy ɓanavə nəfə tsa ghwəy kaa Yesəw gəzə na kwəma va. ");
INSERT INTO bcw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma mənishi shi va tsəghay, ta mbə kwəmaa niy tsasliti məndi va mbə Zliya Hyalaa dzəghwata kwa. Ma kə niy niy: «Ka dza məndiy ɓəlamti isl tsa ci ya kwətiŋəw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Zhini ma kə geꞌi kwa nahwəti kwəshala ɓa na: «Ta zhini dza ghəshi nay ntsa ꞌyamti ghəshi va lə gwapa» kə. ");
INSERT INTO bcw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma ləy hwəm sa mətiy Yesəw ki na, mbaꞌa *Zhezhefə ndə ka Arimate maɗiy, ka dza ta ɗəw kwal ta ɓə mbəri tsa Yesəw va ngwəmna Pilatə. Mbaꞌa Pilatə ɓanavə kwal ta ɓə ghəci. Dza Zhezhefə mbaꞌa səəkə pələkəghwa mbəri tsa Yesəw vəgha tsəm ki, ta dza ta la. Zhezhefə tsa va kiy, tsahwəti ntsa ta səɗa Yesəw niy nza na. Kwa mbəmbə ghəci niy nəw Yesəw va hazləni va mbəzli *ka Zhəwifə dikə dikə ni. ");
INSERT INTO bcw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Dza Nikwədem, tsahwəti ntsaa niy səəkəy vaa dzəvəgha Yesəw həvir, ndəs səəkəy kwərakwə, mbaꞌa ɓəkə in ta la Yesəw. In tsa wəzə tsa, sa kaɓəti məndi lə *mirə mbaꞌa *Aləye, ka zən nja ꞌwərdi. In tsa vay, gar kiləw mahkan mətsəkə na shəndəkə tsa ci. ");
INSERT INTO bcw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dzəghwa ghəshi bakanashi ki, tsaŋ ghəshi ɓəvə mbəri tsa Yesəw, ka harə lə məgapa, ka shikə in tsa wəzə tsa va ghəshi mbə harə, njasa sənaɓəshi ka Zhəwifə mbə harə mbəri. ");
INSERT INTO bcw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma tiɓa vəgha pətsa daŋwavəgha məndi va Yesəw vəgha tsəm na, mbaꞌa tsa tiɓa. Dzəghwa mbaꞌa məndi lati kwəli kwa tsa va ꞌwarꞌwar, kala səəkə məndiy laghwa mbəri kwa. ");
INSERT INTO bcw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dzəghwa mbaꞌa ghəshi laghwa Yesəw kwa kwəli va, sa nzana ndəkwə ghənzə tiɓa ki. Ma sa lamti ghəshi va ndəkwə tsəghay, sa nza vici ndəkwə ta pəkw, sa nzana tə way pi həzlimə na, *vici dəkəva ka Zhəwifə ghənzə. ");
INSERT INTO bcw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ma pəətə fəca dəmasə, pi ghwəlaa wali ki na, mbaꞌa Marəy ka Magədala kafəta, ka dzaa dzəti kwəli Yesəw. Tsəhə na, sa nə na njəꞌwə kə na, kwəli va bəŋwəta, tsarakə hakwə tsaa niy nza va miyɓa dzar kwa nahwəti bəla. ");
INSERT INTO bcw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ꞌWakəvə na bəvbəpə maɗita lə bali. Mbaꞌa dzaa kəsashi kar Shimaŋw Piyer ghəshi lə tsahwəti ntsa ta səɗa Yesəw va ɗi na. Ma kə na: «A kar Piyer, ava məndi ɓəhwə Ntsaa sləkəmmə kwa kwəli, sənay ghəy kwa pətsa dzashi məndi liw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ma sa favə kar Piyer lə tsahwəti ntsa ta səɗa Yesəw va kwəma va tsəgha na, mbaꞌa ghəshi maɗishi ka dzaa dzəti kwəli va ki. ");
INSERT INTO bcw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kə ghəshi ka kəsli bali bakanashi, mbaꞌa tsahwəti ntsa ta səɗa Yesəw va taŋəti Piyer tə bali. Dza na ndəs tsəhəy pərɓa ghəci tə kwəli va. ");
INSERT INTO bcw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tsəhə tsa tsəhə na na, ka kəɗaŋə pətsaa dzəmbə kwəli va, kala dzəmbə ma, njəꞌwə njəꞌwə kə na, nashi shiy na kwaɓaw war məgapaa niy harə məndi va Yesəw li sa kwaɓa tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Dza Piyer kwərakwə ndəs tsəhəy ki, səəkə lətə dzəmbəy mbə kwəli va. Sa nə na njəꞌwə kə na, war məgapa harə məndi va li sa mbəɓa tə hiɗi. ");
INSERT INTO bcw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma məgapa pəərə məndi miy tsa Yesəw li ki na, tsarakə kwətita pəərə pəərə vəgha nahwəti bəla kwəli. ");
INSERT INTO bcw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dza tsahwəti ntsaa gha vaa tsəhə, lətə dzəmbəy mbə kwəli va kwərakwə, mbaꞌa nashi shi va war tsəgha lə mətsə ci, mbaꞌa zləɓavə kwəma va ki. ");
INSERT INTO bcw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwəmaa niy nə Zliya Hyala va: «Ta zhakatiy dza Yesəw mbə məti» kəy, paꞌ ghala pətsa va na, niy favə ghən tsa kwəma va mbəzli ta səɗa ciw. ");
INSERT INTO bcw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dza *mbəzli ta səɗa Yesəw va bakə ni, mbaꞌa ghəshi zhəghətəvashiy jighi ki. ");
INSERT INTO bcw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma sa zhəghəkəvata Marəy ka Magədala ki na, mbaꞌa dzaa garəta miy kwəli va, ka wahə. Ma ghənzə mbə wahə va na, dza na ka kəɗaŋə pətsaa dzəghwa kwəli va. ");
INSERT INTO bcw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nighə na na, ka kwal Hyala bakə lə kwəbeŋer tezlezl tezlezl ni kən shi, mənzəy tə pətsaa niy nza Yesəw va məhəni. Mbaꞌa tsahwəti lati ghən, mbaꞌa tsahwəti ləy mətsəni. ");
INSERT INTO bcw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ma sa nata mbəzli va ghənzəə nighəshi tsəgha, a kə ghəshi ngəta na: «A mali na, a shiy mənishi wahə gha shəka?» kə ghəshi. Ma kə Marəy na: «Wa ə ɓəhwə məndi Ntsaa sləkəra kwa kwəli tikə, kala sənayee tə pətsa fəy məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","War sa zləɓakə na kwəma va na, tərəɗ zhəghətəvata, nighə na na Yesəw tiɓa məgarə, sənay na Yesəw na sava, kəw. ");
INSERT INTO bcw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dza Yesəw ka ɗəw və, a kə na: «A mali, a shi wahə gha ti shəka? A ntsa pala ghaa?» kə. Ndəɓa ndə ghəra sləni kwa tsa va na, kə ghən tsa nzə. Va tsəgha, ma kə ngəci na: «A Ndə sləkəra, gha kə ɓəhwəy, gəzara tə pətsa fəy gha, e dza ta ɓə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dzəghwa Yesəw ka har lə slən tsa nzə ki, a kə na: «A Marəy» kə. Dza Marəy nzaꞌjəw tərəɗ zhəghəghə kwəma nzə dzar kwa. Ma kə lə kwəma ka *Ebərə na: «Rabəni» kə. Rabəni tsa vay: «Ndə ɓəni shiy kaa mbəzli» ɗi na gəzə. ");
INSERT INTO bcw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma kə Yesəw ngəta na: «Kadiw, ka dapəra gha di ma, sa nzanay ghwəla nzee ta dzəməə dzəvəgha Dirə. Mbala a gha dzaa gəzanshi kaa ngwarməhira, “Avee dzəməə dzəvəgha Dirə, Dəŋwəy ghəci kwərakwə, dzəməə dzəvəgha Hyala, Hyala ghwəy kwərakwə ɓa” kə, pə gha ngəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sa gəzəkə na tsəgha na, dza Marəy ka Magədala mbaꞌa maɗita ka dza ta gəzanshi kaa *mbəzli ta səɗa Yesəw, a kə na: «Ndatsəy e nay Ntsaa sləkəmmə, ka gəzəhwə kwəma ghəy li» kə. Dza na mbaꞌa slanakəshi kwəma gəzanakə Yesəw va kaa ngəshi. ");
INSERT INTO bcw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma fəca dəmasə va vata hetihwer na, dza mbəzli ta səɗa Yesəw mbaꞌa ghəshi ɓasambəvashi mbə ciki. Bəsl ghəshi kalakən gəzli kən ghən shi ka jihəti sa hazləni ghəshi va mbəzli *ka Zhəwifə dikə dikə ni. Dzəghwa Yesəw wəɗ tsahwəy, mbaꞌa garəy kwa jipə shi. A kə ngəshi na: «Nzəyəy zərkə lə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma sa gəzanakəshi na tsəgha na, dza na mbaꞌa canatishi veviyerhi mbə hwər dividivi ci, lə ni mbə slərpə ci ngəshi. Sa nay mbəzli ta səɗa ci Ndə sləkəshi ki na, dza ghəshi ka vəshi tərəŋw tsəgha ki. ");
INSERT INTO bcw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zhini ma kə Yesəw ngəshi ɓa na: «Nzəyəy zərkə lə ghwəy. Nanay ta ghwəniŋwəy dzee, njasa niy ghwənara Dirə va kwərakwə» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","War sa gəzəkə na tsəgha na, mbaꞌa viyanakənshi *Safə tsa Hyala. A kə na: «Ɓəm Safə tsa ɗewɗew tsa. ");
INSERT INTO bcw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ma mbəzli pəlata ghwəy kwəma shi jikir na kwa hwər tsa ghwəyəy, a Hyala dzaa pəlata kwəma shi jikir na kwərakwə. Ma ni pəlatanashi ma ghwəy kwəma shi jikir nay, ka dza Hyala pəla kwərakwəw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ghala pətsaa səəkə Yesəw vaa dzəvəgha *mbəzli ta səɗa ciy, niy nza tsahwəti ntsa nza slən tsa ci vaa Təmasə, zhini ihwəli, kə məndi tiɓa kwasəbə nihwəti mbəzli ta səɗa ciw. ");
INSERT INTO bcw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dzəghwa ma kə niy nza va tiɓa *mbəzli ta səɗa Yesəw ngəci sa səəkəy na na: «Təmasə, a ghəy nay Ntsaa sləkəmmə ndatsə» kə ghəshi. Ma kə Təmasə na: «Kala nashi vaviyer daŋwə məndi va pən mbə dəvə ci, mbaꞌee dapashi lə dəvee, mbaꞌee dapəti ni mbə slərpə ci va lə dəvə yay, ka zləɓa yaw» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma ləy hwəm ləwma kwətiŋ ki na, mbaꞌa mbəzli ta səɗa Yesəw zhiniy ɓasəshi mbə ciki diɓa. Fəca va ki na, mbaꞌa Təmasə tiɓa. Dza bəsl ghəshi kalakən gəzli kən ghən shi ka jihəti. Mbaꞌa Yesəw səəkəy garəy kwa jipə shi. Ma kə ngəshi na: «Nzəyəy zərkə lə ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma kə kaa Təmasə na: «A Təmasə, nighəvə dividivee ni, ndaka dəvə gha va, a gha tiɓəti vaviyer mbə dividivee ni, dapəti ni vəgha slərpee ni, ka mənti ghən tsa gha gha bakə bakə ma, ndara nəfə tsa gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma kə Təmasə na: «A Ntsaa sləkəra, a Hyalee» kə. ");
INSERT INTO bcw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma kə Yesəw ngəci na: «Sa nara gha nana ndara gha nəfə tsa gha ki na? Vəshi na va mbəzliy ndara nefer shi ya kala nara ghəshi» kə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","A Yesəw məmənəhwə nihwəti shi dimədimə ni ɗaŋ ghənghən kwa kwəma mbəzli ta səɗa ci. Kala tsaslambəshi məndi mbə zliya na gwanashi. ");
INSERT INTO bcw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma shi tsasliti məndi ni mbə zliya nay, nza ghwəy mbəə sənay kataŋ kataŋ, Yesəw na *Kəristəw Ntsa tivə Hyala, pə ghwəy, va tsəgha tsaslitishi məndi. Ghəci kiy Zəghwə Hyala na. Nza ghwəy mbəə ɓanavə nefer ghwəy kaa Yesəw tsa va, ma ghalaɓa ki na, nza ghwəy kwəmavə piy tsaa kəɗi ma mbə slən tsa ci, va tsəgha tsasliti məndi shi ni diɓa. ");
INSERT INTO bcw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma ləy hwəm ki na, mbaꞌa Yesəw cinti ghən tsa ci kaa nihwəti mbəzli ta səɗa ci miy kwəfa *Tiberiyadə. Avanay njasa canatishi na ghən tsa ci. ");
INSERT INTO bcw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kar Shimaŋw Piyer, ghəshi lə Təmasə ntsa har məndiy ihwəli, mbaꞌa Natanayel, ndə ka Kana tə hiɗi ka Galile, mbaꞌa ndərazhi Zhebede, mbaꞌa nihwəti *mbəzli ta səɗa Yesəw bakə diɓa, tsəgha niy ɓasəshi ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma kə Shimaŋw Piyer ngəshi na: «A mbəzli ni, e dzara ta kəəsə kərpi nee» kə. Ma kə nihwəti mbəzli va na: «Tsəgha na, ta nəwŋa dza ghəy kwərakwə» kə ghəshi. Mbaꞌa ghəshi maɗishi, ka dzashi, mbaꞌa ghəshi dzashiy dzəghwa kwambəwal. Hi ghəshi virvir mbə ka kərpi, shaŋ ghəshi ta kəsəvə kəlipə ya kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma mekəshi sa kəɗiy pi ki na, mbaꞌa Yesəw təzliy tiɓa tə həlbə tsa miy kwəfa va. Sənay mbəzli ta səɗa ci na, ghəci na sava, kə ghəshiw. ");
INSERT INTO bcw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ma kə kaa ngəshi na: «Kəəsəvə kərpi va ghwəy tsəna ndərazhee ni?» kə. Ma kə ghəshi ngəci na: «Əhəŋ, kəəsəvəshi ghəyəw» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma kə ngəshi na: «A pə ghwəy məntiy, ɓəm zləkwə tsa ghwəy va, a ghwəy kashi li tar bəla kwa bəzəmə kwambəwal va, a ghwəy nayma ghwəy kəəsəvə kərpi» kə. «Əŋkwa» kə ghəshi, dza ghəshi ka ka kərpi dzar kwa bəla va ki. Mbaꞌa ghəshi kəəsəvə kərpi ɗaŋ tərəŋw. Paf zləkwə tsa shi təhəy kala mbə ghəshiy mbahə səvəri mbə yam va ghwəla. ");
INSERT INTO bcw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma kə tsahwəti ntsa ta səɗa Yesəw va ɗi na kaa Shimaŋw Piyer na: «Ndə sləkəpə na sasa» kə. War sa favə Shimaŋw Piyer: «Ndə sləkəpə na sava» kə məndi na, həŋ ɓəvə kwəbaŋ tsa ci, sa niy səramti na kən ghən ci, paꞌ pakən, zhiɗə zliy dzəti yam ta dzar dzəvəgha Yesəw. ");
INSERT INTO bcw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma nihwəti mbəzli ta səɗa ci va na, ka mbahə zləkwə tsaa təhəy va paf tsa va kərpi, ka səəkəə dzəvəgha həlbə. Niy nza ghəshi kərakə lə həlbə tərəŋwəw, war gar bəlakə səɗa bələkwə gwaꞌa tsəgha. ");
INSERT INTO bcw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma sa tsəhəshi ghəshi na, mbaꞌa ghəshi səkwashiy dzəti həlbə. Mbaꞌa ghəshi nata laɗi ghwə tiɓa, mbaꞌa kəlipə ti, mbaꞌa peŋ tə pətsa va. ");
INSERT INTO bcw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma kə Yesəw ngəshi ki na: «Taram kərpi, mbə ni kəəsəvə ghwəy va sənzənva» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dza Shimaŋw Piyer mbaꞌa dzəghway kwa kwambəwal, mbaꞌa mbahəkəmə zləkwə tsa va mbə yam dzəti həlbə, paf kərpi dikə dikə ni kwa, bələkwə mbaꞌa cifə mətsəkə mahkan ti. Ya tsəgha na kərpi va ɗaŋ tərəŋw ki na, sləkwəy zləkwə tsa va, və shiw. ");
INSERT INTO bcw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma kə Yesəw ngəshi ki na: «Səəkəm zəməm shi zəmə ki» kə. Ghalaɓa ki na, ndə tiɓa mbə mbəzli ta səɗa Yesəw maw ɗəw: «Wa ndə nza ghaa?» kəw. Sa nzana mbaꞌa ghəshi sənay, Ndə Sləkəpə na sava, kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dzəghwa Yesəw kət kətəghəvay dzəvəgha shi, kə həŋ ɓəvə peŋ tsa va, mbaꞌa ɓanavəshi, zhini mbaꞌa ɓanavəshi kərpi ɓa. ");
INSERT INTO bcw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ghala zhakatiy Yesəw mbə mətiy, ghənzə na kwa mahkana səɗa ci mbə ci ghən tsa ci kaa mbəzli ta səɗa ci. ");
INSERT INTO bcw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ləy hwəm sa zəhwə ghəshi shi zəmə ki na, dza Yesəw ka ɗəw kwəma va Shimaŋw Piyer, a kə na: «Shimaŋw Piyer, zəghwə Zhaŋ, ka ɗira gha lə nəfə kwətiŋ ka taŋəti nihwəti mbəzli ni na?» kə. Ma kə Piyer ngəci na: «Yə Ndə sləkəpə, a gha sənay, e ɗiŋa» kə. Ma kə Yesəw ngəci na: «Ndəghwə mbəzlee ni mənishi nja ndərazhi teŋkesli» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zhini kwa baka səɗa diɓa tapə ta gəzanci: «A Shimaŋw, zəghwə Zhaŋ, ka ɗira gha lə nəfə kwətiŋ na?» kə. Ma kə na: «Yə Ndə sləkəpə, a gha sənay e ɗiŋa» kə. Ma kə Yesəw na: «Ndəghwə mbəzlee ni mənishi nja teŋkesli» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dzəghwa tapə Yesəw ta zhiniy ɗəw və kwa mahkana səɗa diɓa: «A Shimaŋw, zəghwə Zhaŋ, ka ɗira gha na?» kə. Dzəghwa kwəshay Piyer məniy, sa zhini Yesəw vaa ɗəw və: «Ka ɗira gha na?» kə kwa mahkana səɗa. A kə Piyer na: «A Ndə sləkəpə, gwaꞌa sənashi gha shiy. A gha sənay, e ɗiŋa» kə. A kə Yesəw ngəci ki na: «Ndəghwə mbəzlee ni mənishi nja teŋkesli. ");
INSERT INTO bcw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ə gəzaŋee, ta na navay, tsəgha na, ghala pətsaa nza ghaa məgəlay, gha dəꞌwə ghən tsa gha niy va naa pəhə kanda gha, ka dzaŋa kwa pətsa ɗi gha. Sa ka gha haliŋay, ta kafə dividivi gha dza gha, nza tsahwəti ndə pəhəŋa kanda gha, ka na dza na mbaꞌa pəməghəŋaa dzəti pətsa ɗi ma gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ma kwəma gəzəkə Yesəw va tsəgha nay, a cipə na njasa dza Shimaŋw Piyer ta məti, mbaꞌa dzaa fanati bama kaa Hyala lə məti ci va. Ma kə Yesəw ngəci ləy hwəm kwəma va ki na: «Nəwra ki» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma sa kəramti Yesəw gəzə kwəma va tsəgha, sa nə Piyer nighə kə ləy hwəm ci na, mbaꞌa nay ntsa ta səɗa Yesəw va ɗi na mbə səəkə tə səəbə shi. Ntsa va na saa niy kətəghəvay vaa dzəvəgha Yesəw ghala pətsaa niy zəmə ghəshi va shi zəmə mbə Pakə. Ghəci na saa niy ni va kaa Yesəw: «A Ndə sləkəpə, tsama ndə dza naa nga ɗafa tə ghaa?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ma sa nay Piyer ntsa va, ma kə kaa Yesəw na: «A Ntsaa sləkəra, a kwəmaa dzaa kəsay ntsa naci kia?» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ma kə Yesəw ngəci na: «Ya ə nə ya war tiɓa kə tə ghwəməy paꞌ fəca dzee zhikə pənəy, wa kwəma gha mbəa? Na na ghay, ə pə ghaa nəwra na gha» kə. ");
INSERT INTO bcw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dza kwəma gəzəkə Yesəw va, mbaꞌa pəlivərivata dzar mbə mbəzliy nəw Yesəw, a kə ghəshi na: «Ma tsava ntsa ta səɗa Yesəw naci kiy, ka dza naa mətiw» kə ghəshi. Niy gəzanci Yesəw kaa Piyer na: «Ka dza tsava ntsa ta səɗee mətiw» kəw. Ma kə niy niy: «Ya ə nə ya war tiɓa kə tə ghwəməy paꞌ fəca dzee zhikə, pənəy, wa kwəma gha mbəa?» kə niy ni. ");
INSERT INTO bcw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ava ghəci ghəci ntsa ta səɗa Yesəw va ndəgha na fətiy dzəkən shi va. Ghəci tsasliti shi ni diɓa, a ghəy sənay, kwəma tsasliti na vay, kwəma kataŋ na na. ");
INSERT INTO bcw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A Yesəw zhiniy məmənəhwə nihwəti shiy ɗaŋ tə hiɗi. Mbaꞌa kə məndi niy tsaslitishi gwanashi kwətiŋ kwətiŋ nzay, ɗaŋshi dza zliyahiy nza nza. Ma bərkee na, daw dza pətsa tə hiɗi niy nza ta fə zliyahi nza. Ava tsəgha na Yəwən kwəma wəzə naa dzəkən Yesəw *Kəristəw njasa tsasliti Zhaŋ ki.");
INSERT INTO bcw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A Tiyəwfiləsə, Mbə kwa taŋa zliya tsasləghəŋee vay, dzəkən sləni ghərahwə Yesəw lə kwəma ɓənəhwə na kaa mbəzli tsasləghəŋee kwəma, njasa gha na sləni ci, ");
INSERT INTO bcw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","paꞌ fəca vici ɓəhwə Hyalaa dzəmə ghwəmə. Ghəci ghwəla ta dzay dzəmə ghwəmə ləy hwəm pəəsli tsaa pəəsliti məndi vay, aa niy zhakatiy mbə məti. Dza na mbaꞌa citəvay tə ghwəməy kaa ka kwal ci va tsəhavə na. Ɗaŋ səɗa ghəci citəvay ngəshi lə kwal ghənghən ghənghən, mbə vici faɗə mətsəkə, ta mbə ghəshiy sənay tə ghwəməy na, kə ghəshi. Ka gəzanshi lə bərci *Safə tsa Hyala ɗewɗew tsa njasa dza ghəshiy məni. Ka gəzanshi kwəmaa dzəkən njasa sləkə Hyala mbəzli. ");
INSERT INTO bcw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dza na tə nahwəti vici sa jakəshi ghəshi lə ka kwal ci va na, mbaꞌa gəzanshi kwəma, ma kə na: «Əntaa ghwəy taa ɓarvaŋwəy mbə məlmə Zherəwzalem dzaŋwəy kərakə ma. Ndəghəvə tə ghwəy Safə tsa Hyala va niy gəzəkə Didi vəliŋwəy niy gəzaŋwəyee kwataŋa. ");
INSERT INTO bcw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sa nzanay, lə yam niy mənipə Zhaŋ *batem, ma ləy hwəm jəwəy ta səəkə dza Safə tsa Hyala ɗewɗew tsaa dzəkən ghwəy» kə. ");
INSERT INTO bcw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dzəghwa ka kwal Yesəw va tsəgha ki, ghəshi ɓasə ɓasə vəgha, tapə ta ɗəw kwəma və, ma kə ghəshi na: «A Ndə sləkəpə, ghala vəghwə tsa va dza ghaa zhananshi mazə kaa ka *Izərayel na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma kə Yesəw ngəshi na: «Na na ghwəyəy, kwəma ghwəy mbə kwəma sənay vəghwə, ya vici tivə Didi njasa tarəvə na lə bərci ciw. ");
INSERT INTO bcw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ə na na nzanay, ta kwəmavə bərci dza ghwəy, sa ka Safə tsa Hyala ɗewɗew tsa səəkəy dzəkən ghwəy. Ghalaɓa na, nza ghwəy nza ka ka ndəgha fətiy dzəkənee, ka gəzə kwəmee kaa mbəzli. Sa ghwəy dzay, ka gha mbə Zherəwzalem, ka dzar mbə Zhəwde gwaꞌa gwaꞌa, lə *Samari, ka kərni tə pətsa kərkə hiɗi gwaꞌa» kə. ");
INSERT INTO bcw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma ləy hwəm sa gəzəkə na tsəgha na, mbaꞌa bərci Hyala kafay, ka dzəmə ghwəmə li. War ghəshi mbə nighə tsəgha na, dzəghwa timbətimbə mbaꞌa kəələhwə ghəci mbə dzəmə, kala zhini ghəshiy nay ghwəla. ");
INSERT INTO bcw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma sa nza ghəshi war mbə vərghə pətsaa dzəmə ghwəmə tsəgha ghəci mbə dzəməy, dza vətəghə zhər bakə tsahwəshi tiɓa lə kwəbeŋer tezlezl tezlezl ni kən ghən shi. ");
INSERT INTO bcw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma kə zhər va ngəshi na: «A zhər ka Galile, wa nava garəŋwəy ghwəy, ka vərghə pətsaa dzəmə ghwəməa? Ma Yesəw tsa nay ghwəy va dzay dzəmə ghwəmə səvəri mbə jipə ghwəyəy, ta zhəghəva dza naa səəkə njasa nay ghwəy va ghəci mbə dzəmə ghwəmə» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dza *ka kwal Yesəw va ki, mbaꞌa ghəshi səkwashi mə kəlaŋ tsa ɓasəshi ghəshi va mə, ka dzashiy dzəmbə Zherəwzalem. Kəlaŋ *ꞌWəlivə, kə məndi slən tsa kəlaŋ tsa va. Ma kəlaŋ tsa va na, ndəkwə ghəci lə məlmə Zherəwzalem gar kiləwmetər kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma sa tsəhəshi ghəshi na, mbaꞌa ghəshi dzashiy dzəmə ciki tsa ngati məndi mə ghən tsahwəti, sa ka ghəshiy nza mbə ndimndim. Avanay slən tsa mbəzli va: Piyer ghəshi lə Zhaŋ, Zhakə, Andəre, Fəlipə, Təmasə, Bartelemi, Matiye, Zhakə tsa Alfe, Shimaŋw ndə pərslə ta hiɗi ci, mbaꞌa Zhəwdə zəghwə Zhakə. Ava tsəgha na ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dza ghəshi gwanashi, mbaꞌa ghəshi sləkati miy tsa shi ka sa kwətiŋ tsa ta cəꞌwə Hyala, vici va vici va, jakə lə miꞌi mbə shi, mbaꞌa Marəy mbəghəy Yesəw, lə kar ngwarməhiy Yesəw gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ꞌWakəvə Piyer fəca nahwəti vici mbə ɓasəva tsa shi va tsəgha, gar garəy mbə jipəjipə mbəzliy nəw Yesəw, mbəzli gar bələkwə, bakə mətsəkə ghən kən shi. Ma kə na: ");
INSERT INTO bcw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«A ngwarməhira mbə nəw Yesəw, kwəmaa niy gəzəkə *Safə tsa Hyala ghala kwataŋata lə miy tsa Davitəə dzəkən Zhəwdasə mbə Zliya Hyalay, aa təɓəə mənta kwa pətsa gəzəkə na. Ntsaa zhəghəy ka ndə pəmə mbəzliy kəsə Yesəw. ");
INSERT INTO bcw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ghəciy, ntsa mbə ghwəmmə niy nza na, lə na ci bəla mbə sləni ghəra ghwəmmə. ");
INSERT INTO bcw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Dzəghwa mbaꞌa kwəmavə gəna tə kwəma ci jikir na, mbaꞌa pahwə za ti. Ghavə tsəgha ki, ɓə ɓəti tərə, mbaꞌa hwər tsa ci pəsliy, ngwəy her tə ngwəla, mbaꞌa mətiy. ");
INSERT INTO bcw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma kwəma va na, gwaꞌa gwaꞌa məndi sənata mbə Zherəwzalem. Paꞌ lə slənta ghəshi fanati kaa za va kwa kwəma shi “Hakeldama” kə məndi. Ɗi slən tsa va gəzəy: “Za miymiy” kə məndi» kə. ");
INSERT INTO bcw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Zhini ma kə Piyer ɓa na: «Vanta kwəmaa tsaslita mbə *zliya kwa cəm tsa *Davitə nanzə ki, ma kəy: Ghi tsa ciy, kwəfi kə taa nza. Əntaa ndə ta nzəy kwa ya kwətiŋ ma, kə. Zhini ma kə ɓa na: Nza tsahwəti ndə ɓə pi sləni tsa ci, kə. ");
INSERT INTO bcw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Va tsəgha na ki, sənzənvay, a ndəə təɓə kwətiŋ dzəvəgha ghəy, ta ndəgha fətiy dzəkən zhakati tsa Yesəw mbə məti. Ma ntsa vay, ndə mbə mbəzliy niy nza vici va vici va kwasəbə ghəy ghala vəghwə tsaa niy nza Yesəw lə ghəy, ꞌwava na tə vici mananati Zhaŋ *batem, ka sar paꞌ fəca ɓarva na mbə jipə ghəy ta dzay dzəmə ghwəmə təɓə na» kə. ");
INSERT INTO bcw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Sa favə mbəzli kwəma Piyer va tsəgha na, dza ghəshi təra ghəshi təravə mbəzli bakə mbə mbəzli va, kar *Zhezhefə tsa har məndiy Barsabasə, zhini ɓa na, Zhəsətəsə, kə məndi tsahwəti slən tsa ci, ghəshi lə Matiyasə. ");
INSERT INTO bcw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dza ghəshi ki, ka cəꞌwə Hyala, ma kə ghəshi na: «A Ntsaa sləkəŋəy, ntsaa sənay pətsa mbə nefer mbəzli gwaꞌa, citəŋəy tsa tivə gha ndə mbə mbəzli bakə ni ni, ");
INSERT INTO bcw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a ghəci ɓə pətsa Zhəwdasə ta nza ghəci ka ndə kwal tsa gha, njana nzana mbaꞌa Zhəwdasə zlata sləni va ta dzay kwa tsa ci kwal» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dzəghwa ghəshi slaꞌ slaꞌ ghəshi slaslati dandərɗə ta mbəə tishi. Mbaꞌa dandərɗə tsa va tivə Matiyasə. Kə məndi ki, mbaꞌa məndi jakambə mbə ka kwal Yesəw va məŋ lə tan ni. ");
INSERT INTO bcw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dzəghwa sa mənta vici makwaghwa Paŋtekwətə ki na, mbaꞌa mbəzliy ɓanavə nefer shi kaa Yesəw ɓasəshi gwanashi mbə pətsa kwətiŋ tsa. ");
INSERT INTO bcw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Fa ghəshi tsəgha na, gaka tsahwəta səəkə mə ghwəmə ndəɓa gaka səpapəli, pə gha, gizl gizl gizl təhay ciki tsa nza ghəshi va mbə gwaꞌa. ");
INSERT INTO bcw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nighə ghəshi ki na nihwəti shiy tsahwəshi nja ghani ghwə. Ka tihəvaa dzəkən shi gwanashi kwətiŋ kwətiŋ. ");
INSERT INTO bcw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dzəghwa tsəgha ki, paf paf Safə tsa Hyala tahay nefer shi gwanashi. Dza ghaꞌ ghəshi ghavə gəzə kwəma lə ghanihi mbəzli ghənghən ghənghən, njasa ɓanavəshi Safə tsa Hyala gəzə nzə. ");
INSERT INTO bcw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ghalaɓay, a *ka Zhəwifəə nəwti kwəma Hyala, ka hazləni və niy nza mbə Zherəwzalem, tə hiɗi ghənghən ghənghən niy səəkəshi ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma sa favə ghəshi gaka va tsəgha na, dza ghəshi ɓasə ghəshi ɓasəkəvashi. Dzəghwa tərəŋw mbəzliy ɓasəkəvashi va hashishi kala sənata ma kwəma ka ghəshi gəzə, sa nzana ya tsamaɓa ndə mbə mbəzliy səəkəshi va na, ka favə kwəma gəzə mbəzliy zləɓavə Yesəw va kwa kwəma ci yakə məndi li. ");
INSERT INTO bcw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nja maɗaŋa tərəŋw nava kwəma mənta tiɓa və shi gwanashi ki: «ꞌYahəꞌyahəta na nana kwəma» kə ghəshi. Ma kə ghəshi na: «Ka Galile mbəzliy gəzə kwəma ni gwanashi nanzə tsəy? ");
INSERT INTO bcw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","War njaa səəkə na sana favə ghwəmmə, njasa nza ghwəmmə kwətiŋ kwətiŋ tsa ghwəmmə, kwəma yakəmmə məndi li ghəshi gəzəa? ");
INSERT INTO bcw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Əhətimam, sənzənvay, ghwəmmə ghwəmmə mbəzli tikə niy, mbə ka Partə, mbə ka Medi, lə ka Elam, mbaꞌa ka Mesəwpətami, mbə mbəzli tə hiɗi ka Zhəwde, lə ka Kapadəsə, mbə ni tə Pəŋw, mbaꞌa ni tə hiɗi ka Azəy, ");
INSERT INTO bcw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","mbə ka Firigi, mbə ka Pamfili, mbə ka *Ezhipətə, lə mbəzli mbə giwahi ka Libiy ndəkwə ni vəgha Shiren, mbə niy səəkəshi tə hiɗi ka *Rəm, mbə *ka Zhəwifə yaya ni lə niy dzəmbəshiy dzəmbə kwəma ka Zhəwifə dzəmbə dzəmbə. ");
INSERT INTO bcw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Zhini ɓa, tiɓa ka Kəretə, lə ka Arapə. Tsəgha nza ghwəmmə, vərtsa, war gwanammə ghwəmmə ka favə, ghəshi ka gəzə kwəma kwa ghani ghwəmmə, kwəmaa dzəkən sləni Hyala dikə na na?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mbaꞌa kwəma va səti məhərli shi gwanashi, shaŋ ghəshi ta sənata kwəma ka ghəshi gəzə. Dza tapə ghəshi mbə ɗəɗəw kwəma kwa jipə shi: «Wantsa gəla nana kwəmaa?» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma nihwəti mbəzli nashi ki na, ka sawa mbəzliy zləɓavə Yesəw va, a kə ghəshi na: «Waa ghiy ghyamtəvashi ghəshi va tay nə məndi» kə ghəshi. ");
INSERT INTO bcw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ꞌWakəvə Piyer tsəgha, gar garəy ghəshi lə nihwəti *ka kwal Yesəw va məŋ lə tan ni, dza tapə ghəci ta gəzə kwəma zlaŋzlaŋ, ma kə na: «A mbəzli *ka Zhəwifə, lə mbəzli mbə məlmə Zherəwzalem, sənatam kwəma na ndatsə di, favəm kwəma dzee na ta gəzəŋwəy wəzə. ");
INSERT INTO bcw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","A mbəz